﻿USE sofia;
DROP TABLE IF EXISTS sofia.qveNT_vpl;
CREATE TABLE qveNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES qveNT_vpl WRITE;
INSERT INTO qveNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucristoqa Abrahampa hinaspa Davidpa mirayninmantan karan. Kay listapi kaq runakunan Jesucristopa ñawpaq abuelonkunaqa karanku: ");
INSERT INTO qveNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahampa wawanmi karan Isaac; Isaacpa wawanmi karan Jacob; Jacobpa wawanmi karan Judá, hinallataq Judapa wawqenkunapiwan; ");
INSERT INTO qveNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judapa wawankunan karan warmin Tamarpi: Fares hinaspa Zarapiwan; Farespa wawanmi karan Esrom; Esrompa wawanmi karan Aram; ");
INSERT INTO qveNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arampa wawanmi karan Aminadab; Aminadabpa wawanmi karan Naasón; Naasonpa wawanmi karan Salmón; ");
INSERT INTO qveNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmonpa wawanmi karan Booz, Boozpa mamitanqa karan Rahabmi; Boozpa wawanmi karan Obed, Obedpa mamitanqa karan Rutmi; Obedpa wawanmi karan Isaí; ");
INSERT INTO qveNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaipa wawanmi karan rey David; rey Davidpa wawanmi karan Salomón; Salomonpa mamitanqa karan wañukuq Uriaspa warminmi. ");
INSERT INTO qveNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomonpa wawanmi karan Roboam; Roboampa wawanmi karan Abías; Abiaspa wawanmi karan Asa; ");
INSERT INTO qveNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asapa wawanmi karan Josafat; Josafatpa wawanmi karan Joram; Jorampa wawanmi karan Uzías; ");
INSERT INTO qveNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziaspa wawanmi karan Jotam; Jotampa wawanmi karan Acaz; Acazpa wawanmi karan Ezequías; ");
INSERT INTO qveNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequiaspa wawanmi karan Manasés; Manasespa wawanmi karan Amón; Amonpa wawanmi karan Josías; ");
INSERT INTO qveNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiaspa wawanmi karan Jeconías, hinallataq Jeconiaspa wawqenkunapiwan. Paykunan karanku Israel nación llaqtayoq runakuna, Babilonia nacionman apasqa kasqanku tiempopi. ");
INSERT INTO qveNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Israel nacionniyoq runakunata Babilonia nacionman apasqanku tiempomanta qepamanmi, Jeconiaspa wawan karan Salatiel; Salatielpa wawanmi karan Zorobabel; ");
INSERT INTO qveNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabelpa wawanmi karan Abiud; Abiudpa wawanmi karan Eliaquim; Eliaquimpa wawanmi karan Azor; ");
INSERT INTO qveNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azorpa wawanmi karan Sadoc; Sadocpa wawanmi karan Aquim; Aquimpa wawanmi karan Eliud; ");
INSERT INTO qveNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudpa wawanmi karan Eleazar; Eleazarpa wawanmi karan Matán; Matanpa wawanmi karan Jacob; ");
INSERT INTO qveNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobpa wawanmi karan Mariapa qosan José. Mariañataqmi karan Jesuspa mamitan; Jesustan runakunaqa Cristowan suticharanku. Nota: Cristoqa “Salvador” ninantan nin. ");
INSERT INTO qveNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Saynapin Abrahammanta asta Davidkama chunka tawayoq miraykuna karan. Davidmanta asta Israel nacionniyoq runakuna, Babilonia nacionman preso apasqa kasqankukaman chunka tawayoq miraykuna karan. Hinallataq Babilonia nacionman, Israel nación llaqtayoq runakuna apasqa kasqankumanta asta Jesucristopa nacesqankaman, chunka tawayoq miraykunallataq karan. ");
INSERT INTO qveNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucristopa nacesqanqa khaynan karan: Marian Joseywan casarakunanpaq comprometesqaña karan. Hinaqtinmi Mariaqa Joseywan manaraq kushka puñushaspa, Diospa Santo Espiritunpa atiyninwan onqoq rikhuriruran. ");
INSERT INTO qveNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Chaymi Joseyqa justo runa kasqanrayku, Mariata p'enqayman churayta mana munaspan, aswan mana pipapas yachasqallan saqepuyta piensaran. ");
INSERT INTO qveNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Saynata piensashaqtinmi, Señorpa angelnin Joseyman sueñoyninpi rikhuriykuspa khaynata niran: —Davidpa mirayninmanta José. Ama manchakuychu Mariawan casarakuytaqa. Payqa Diospa Santo Espiritunpa atiyninwan hunt'ayusqa kaspanmi, onqoq kashan. ");
INSERT INTO qveNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Chaymi Mariaqa qari wawata onqokunqa. Hinaspan chay wawaman sutinta churanki Jesuswan. Paymi llaqtamasin runakunata salvanqa huchapi kawsasqankumanta, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tukuy kaykunan pasaran, Diosmanta willakuq profeta Isaiaspa nisqankuna cumplikunanpaq. Chay profeta Isaiasmi ñawpaqtaraq khaynata escribiran: ");
INSERT INTO qveNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Manaraq hayk'aqpas qariwan puñuq sipasmi huk qari wawata onqokunqa; hinaspan chay wawaman sutinta churanqaku, Emanuel”, nispanku. Emanuelqa “Diosmi noqanchiswan”, ninantan significan Isaías 7.14. ");
INSERT INTO qveNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Chaymi Joseyqa puñusqanmanta rikch'ariran. Hinaspan angelpa nisqanman hina Mariawan casarakuran. ");
INSERT INTO qveNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ichaqa manan Joseyqa puñuranraqchu Mariawanqa, asta primer kaq wawanta María onqokunankama. Onqorukuqtintaqmi, Joseyqa chay wawaman sutinta churaran Jesuswan. ");
INSERT INTO qveNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesusqa Belén llaqtapin naceran. Chay Belén llaqtaqa Judea provinciamanmi perteneceran. Chay tiempopin hatun kaq rey Herodes gobiernasharan Judea provinciapi. Hinaqtinmi ancha yachayniyoq reyes magos runakuna, intipa lloqsimunan lawmanta, Jerusalén llaqtaman hamuranku. Nota: Chay Jerusalén llaqtaqa Israel nación llaqtapa capitalninmi karan; hinaspapas Judea provinciamanmi perteneceran. ");
INSERT INTO qveNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Hinaspan paykunaqa Jerusalén llaqtapi tapukuranku: —¿Maypitaq kay Israel nación llaqtapa reyninri nacerun? Noqaykun intipa lloqsimunan lawpi qoyllurninta rikuramuyku. Chaymi hamushayku chay naceq wawata adoranaykupaq, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Chay yachayniyoq reyes magos runakunapa nisqanta uyarispanmi, rey Herodespas hinallataq Jerusalén llaqtapi tiyaq llapallan runakunapas anchata preocupakuranku huk rey nacesqanwan. Nota: Chay nacemuq reyqa manan rey Herodespa familianmantachu karan. Chayraykun Herodesqa preocupakuran chay nacemuq rey paypa rantinta gobiernaq haykunanmanta. Chaymi Jerusalén llaqtapi runakunapas preocupakullarankutaq chay reykuna guerrapi peleaqtinku nishu ñak'ariy kananmanta. ");
INSERT INTO qveNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Hinaqtinmi rey Herodesqa waqyachimuran sacerdotekunapa llapallan jefenkunata, hinallataq leykunata yachachiq runakunatawan ima. Hinaspan paykunata tapuran khaynata: —Diosmanta Hamuq Salvador Cristori, ¿maypitaq nacenan karan? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Chaymi paykunaqa niranku: —Belén llaqtapin nacenan karan. Chay Belén llaqtaqa Judea provinciapin kashan. Saynatan Diosmanta willakuq profetapas ñawpaqtaraq ña escribiranña khaynata: ");
INSERT INTO qveNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Belén llaqtapi tiyaq runakuna, qankunapa llaqtaykichismi Judea provincia lawpi llapallan llaqtakunamanta aswan más uchuychalla kashaspanpas, aswan más importante llaqta kanqa. Chay llaqtaykichis ukhupin huk kamachikuq nacenqa. Paymi Israel nación llaqtaypi tiyaq runakunata cuidanqa, imaynan huk runapas ovejakunata allinta michin chay hinata”, nispa Miqueas 5.2. ");
INSERT INTO qveNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Chay nisqankuta uyarispanmi, rey Herodesqa secretollapi waqyachimuran chay yachayniyoq reyes magos runakunata. Hinaspan paykunata tapuran hayk'aqsi chay qoyllur paykunaman rikhurisqanmanta. ");
INSERT INTO qveNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Saynata tapuruspanmi, rey Herodesqa, chay yachayniyoq reyes magos runakunata Belén llaqtaman mandaspa, khaynata niran: —Belén llaqtaman rispaykichisyá, alli-allinta averiguamuychis chay wawa nacesqanmanta. Wawata tariruspaykichisqa, kutimuspayá noqaman willawankichis, noqapas rispay chay wawata adoramunaypaq, nispa. Nota: Rey Herodesqa saynatan niran, chay nacemuq wawata wañuchiyta munasqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Hinaqtinmi rey Herodespa nisqanta uyarispanku, chay yachayniyoq reyes magos runakunaqa Belén llaqta lawman riranku. Hinaqtinmi chay intiq lloqsimunan lawpi qoyllur rikusqankuqa yapamanta paykunapa ñawpaqninkuta riran. Wawapa kasqanpa altonman chayaruspantaqmi, chay qoyllurqa chaypi sayaykuran. ");
INSERT INTO qveNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Hinaspan chay qoyllurpa sayasqanta rikuruspanku, chay yachayniyoq reyes magos runakunaqa anchata kusikuranku. ");
INSERT INTO qveNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Wawapa kasqan wasiman haykuspankun, wawata rikuranku mamitan Mariatawan kushkata. Hinaspan qonqoriyukuspanku wawata adoraranku. Apamusqanku alforjankumanta orqomuspankutaqmi, regalokunata qoranku: qorita, inciensota hinallataq mishk'i q'apaq mirrawan sutichasqa perfumeta ima. ");
INSERT INTO qveNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ichaqa chaymantan Diosqa chay yachayniyoq reyes magos runakunaman sueñoyninkupi willaran khaynata: —Rey Herodespa kasqanmanqa amañan kutinkichishñachu, nispa. Chaymi paykunaqa huk law ñannintaña llaqtankuman kutipuranku. ");
INSERT INTO qveNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Chay yachayniyoq reyes magos runakuna llaqtankuman kutipusqankupa qepanmanmi, Diospa angelnin Joseyman sueñoyninpi rikhuriykuspa, khaynata niran: —Hatarispayki wawata mamitantinta Egipto nación llaqtaman ishkapachiy. Hinaspa chay Egipto nacionpi tiyamuy, noqa qankunaman willamunaykama. Ichaqa rey Herodesmi wawata wañuchinanpaq mashkachinqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Chaymi Joseyqa puñusqanmanta hatarispa, wawata mamitantinta Egipto nación llaqtaman chay tuta ayqechiran. ");
INSERT INTO qveNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Hinaspan chay Egipto nación llaqtapi tiyaranku asta rey Herodes wañunankama. Saynapin cumplikuran Diosmanta willakuq profetapa ñawpaqtaraq Bibliapi khayna escribisqan: “Wawaytan Egipto nacionmanta waqyamurani”, nispa Oseas 11.1. ");
INSERT INTO qveNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Rey Herodesqa chay yachayniyoq reyes magos runakuna willakuq mana kutimuqtinkun, cuentata qokuran engañasqa kasqanta. Chaymi anchata phiñakuran. Hinaspan soldadonkunata kamachiran, chay Belén llaqtapi hinallataq muyuriqninkunapi manaraq ishkay watayoq llapallan qari wawakunata wañuchimunankupaq. Saynataqa kamachiran, chay yachayniyoq reyes magos runakunaman ñawpaqtaraq chay qoyllurpa rikhurisqan tiempota yachasqanraykun. ");
INSERT INTO qveNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Saynapin cumplikuran Diosmanta willakuq profeta Jeremiaspa ñawpaqtaraq khayna escribisqan: ");
INSERT INTO qveNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramá llaqtapi tiyaq runakunan ancha waqayta hinallataq llakikuyta ima uyarinqaku. Payqa Raquelmi karan. Payqa wawankunamantan waqaran. Payqa wawankunata wañuchiqtinkun waqaran. Payqa manan consuelasqa kayta munaranchu”, nispa Jeremías 31.15. ");
INSERT INTO qveNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Rey Herodes wañuruqtinmi, Joseymanqa sueñoyninpi Diospa angelnin rikhuriran, Egipto nación llaqtapi tiyashaqtinku. Hinaspan chay angelqa khaynata niran: ");
INSERT INTO qveNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Hatariy, hinaspa wawata mamitantinta pusayukuspa, Israel nación llaqtaykiman kutipuy. Ñan wañurunkuña wawa wañuchiy munaq runakunaqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Chaymi Joseyqa wawata mamitantinta pusayukuspa, Israel nación llaqtanman kutipuran. ");
INSERT INTO qveNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ichaqa chay Israel nación ukhupi Judea provinciaman ripushaspanmi, Joseyqa yacharuran rey Herodespa wawan Arquelaoña papanpa rantinta chay Judea provinciapi gobiernasqanta. Chayraykun Joseyqa chay rey Arquelaota manchakuspa, Judea provinciamanqa manaña riranñachu. Aswanmi Diospa angelnin sueñoyninpi niran, Galilea provincia lawman tiyaq rinanpaq. ");
INSERT INTO qveNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Galilea provinciaman chayaruspankuñataqmi, Nazaret sutiyoq llaqtaman riranku chaypi tiyanankupaq. (Chay Nazaret llaqtaqa Galilea provinciamanmi perteneceran). Saynapin Diosmanta willakuq profetakunapa ñawpaqtaraq khayna nisqanku cumplikuran: “Diosmanta Hamuq Salvadortaqa ‘Nazaret llaqtayoqmi’, ninqakun”, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Chay p'unchawkunapin Bautizaq Juanqa riran Judea provincia lawpi kaq ch'inñeq desierto lugarkunapi runakunaman khaynata willastin: ");
INSERT INTO qveNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","—Huchaykichismanta wanakuspa Diosman kutirikuychis. Diospa kay pachapi gobiernanan p'unchawqa chayamushanñan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Diosmanta willakuq ñawpaq profeta Isaiasmi Bautizaq Juanmantaqa ña escribiranña khaynata: “Ch'inñeq desierto lugarpin huk runa altollamantaña rimaspa willakushan khaynata: ‘Sonqoykichista allichaychis Diosmanta Hamuq Salvadorta chashkinaykichispaq, imaynan wiksu ñankunata allichanku chay hinata’ ”, nispa Isaías 40.3. ");
INSERT INTO qveNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Bautizaq Juanpa p'achanmi karan hatun camello animalpa pelonmanta ruwasqa. Cinturan watakunanñataqmi karan qaramanta ruwasqa. Hinaspapas payqa langosta urukunata, hinallataq ch'inñeq desierto lugarkunapi abejapa mishk'inkunatan mikhuran. ");
INSERT INTO qveNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Hinaqtinmi ashka runakunaqa Bautizaq Juanpa yachachisqanta uyarinankupaq hamuranku Jerusalén llaqtamanta, Judea provincia lawmanta, hinallataq Jordán mayupa muyuriqninpi kaq llapallan llaqtakunamantawan ima. ");
INSERT INTO qveNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Hinaspan paykunaqa huchankuta willakuspanku Bautizaq Juanwan bautizachikuranku Jordán mayupi. ");
INSERT INTO qveNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Hinaqtinmi Juanpa bautizasqan lugarmanqa hamullarankutaq ashka runakunapas. Paykunan karanku fariseo religionniyoq runakuna, hinallataq saduceo religionniyoq runakunapiwan ima. Chaymi Bautizaq Juanqa paykunata rikuspa khaynata niran: —¡Mach'aqwaypa miraynin hina runakuna! Qankunamanri, ¿pitaq nisurankichis Diospa castigonmanta ayqekunaykichispaqrí? ");
INSERT INTO qveNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tukuy huchaykichismanta wanakuspayá, allin kawsaypiña puriychis. ");
INSERT INTO qveNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Amayá niychishchu: “Noqaykuqa ñawpaq abueloyku Abrahampa mirayninmanta kasqaykuraykun salvasqa kasaqku”, nispachu. Nota: Saynataqa piensaranku Diospi Abraham anchata confiasqanraykun. —Ichaqa noqan nisqaykichis, sichus Dios munanman chayqa, Abrahammanta miramuq runakunamanmi kay rumikunatapas tukurachinman. ");
INSERT INTO qveNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Imaynan mana ruruq sach'akunatapas dueñonqa, saphinmanta orqospa, hachawan takaspa ninaman wikch'uyun, saynallatataqmi Diospas ruwanqa mana allin ruwaq runakunawanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Noqaqa unullawanmi qankunataqa bautizaykichis huchaykichismanta wanakusqaykichisrayku. Aswanqa hukraqmi hamushan noqamanta aswan más atiyniyoq. Chaymi noqaqa paypa husut'anllantapas mana apanaypaq hinachu kani. Paymi Diospa Santo Espiritunta qosunkichis qankunapi kananpaq; hinallataq bautizasunkichispas ninawan hina. ");
INSERT INTO qveNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Pay hamuspanmi t'aqanqa allin runakunata mana allin runakunamanta, imaynan pajanmanta trigota akllaspa wayrachinku chay hinata. Ichaqa allin ruwaq runakunatataqmi salvanqa. Mana allinpi kawsaq runakunatataqmi mana wañuq nina rawrayman wikch'uyuspa k'ananqa, chaypi wiña-wiñaypaq ñak'arinankupaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jesusmi riran Galilea provincia lawmanta Jordán mayuman, Bautizaq Juan chaypi bautizananpaq. ");
INSERT INTO qveNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ichaqa Juanñataqmi Jesusta bautizayta mana munaspa, khaynata niran: —Noqan necesitashani qan bautizawanaykitaqa, ¿chaychu qanri noqawan bautizachikunaykipaq hamushankirí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Chaymi Jesusñataq contestaran khaynata: —Bautizawanaykipunin, saynapin Diospa nisqanta cumplisunchis, nispa. Chayñan Juanqa bautizaran Jesusta. ");
INSERT INTO qveNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Bautizaruqtintaqmi Jesusqa unumanta lloqsimuran; hinaqtinmi chay rato hanaq pacha cielo kicharikuran. Hinaspan Jesusqa Diospa Santo Espiritunta rikuran, paloma hina payman urayamushaqta. ");
INSERT INTO qveNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Hinaqtinmi hanaq pachamanta nimuran khaynata: —Paymi ancha munakusqay Wawayqa. Paywanmi ancha kusisqa kashani, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Chaymantan Diospa Santo Espiritunqa ch'inñeq desierto lugarman Jesusta pusaran. Hinaqtinmi diabloqa Jesusta huchaman urmachiyta munaran. ");
INSERT INTO qveNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Chay ch'inñeq desierto lugarpin Jesusqa tawa chunka p'unchaw, hinallataq tawa chunka tuta mana ni imatapas mikhusqanraykun yarqachikuran. ");
INSERT INTO qveNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Chaymi diabloqa huchaman urmachiyta munaspa Jesusman ashuyuran. Hinaspan khaynata niran: —Cheqaqtapuni Diospa Wawan kaspaykiqa, kay rumikunatayá kamachiy t'antaman tukunanpaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Hinaqtinmi Jesusqa khaynata contestaran: —Bibliapin nishan: “Runaqa manan t'antallawanchu kawsanqa; aswanqa Diospa palabranta kasukuspan kawsanqa”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Chaymantan diabloqa Jerusalén ch'uya llaqtaman Jesusta pusaran. Chaypin Dios yupaychana templopa alton patapi sayaykachispa, ");
INSERT INTO qveNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","khaynata niran: —Cheqaqtapuni Diospa Wawan kaspaykiqa kaymantayá saltaykuy. Bibliapin nishan khaynata: “Diosmi angelninkunata kamachinqa hap'isunaykipaq, saynapi chakiykita rumiman ama takakunaykipaq”, nispa Salmos 91.11-12. ");
INSERT INTO qveNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Chaymi Jesusqa diablota niran: —Bibliapiqa nillashantaqmi: “Señor Diosniykitaqa aman ni ima pruebamanpas yanqapuniqa churankichu”, nispa Deuteronomio 6.16. ");
INSERT INTO qveNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Chaymantan diabloqa yapamanta pusaran huk alto orqoman. Hinaspan chaymanta qawachiran kay pachapi llapallan nación llaqtakunata, hinallataq chay llaqtakunapa qapaq kayninkunatawan ima. ");
INSERT INTO qveNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Hinaspan diabloqa khaynata niran: —Sichus qonqorikuspa adorawanki chayqa, kay qawasqayki llapallan nación llaqtakunatan qanman qosqayki, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Chaymi Jesusqa khaynata niran: —¡Pasay kaymanta diablo! Bibliapin khaynata nishan: “¡Señor Diosnillaykitan adoranki, pay sapallantataqmi servinkipas!”, nispa Deuteronomio 6.13; 10.20. ");
INSERT INTO qveNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Hinaqtinmi diabloqa Jesuspa ladonmanta ripuran. Chaymantan angelkuna hamuspa Jesusta serviranku. ");
INSERT INTO qveNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jesusqa Bautizaq Juan carcelpi kasqanta yacharuspanmi, Judea provincia lawmanta kutiran Galilea provincia lawman. ");
INSERT INTO qveNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Hinaspan chay Galilea provincia ukhupi Nazaret llaqtapi kasqanmanta, Capernaúm llaqtaman Jesusqa riran, chaypi tiyananpaq. Chay Capernaúm llaqtaqa karan Galilea laguna qochapa ladonpin, saynallataq Zabulón hinallataq Neftalí tiyasqanku lawpin. Nota: Zabulonwan hinallataq Neftaliywanqa karan, ñawpaq Israel nación llaqtapi chunka ishkayniyoq ayllunkunamanta ishkaynin kaq ayllukunan. ");
INSERT INTO qveNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Chay Capernaúm lawman Jesuspa risqanwanmi Diosmanta willakuq ñawpaq profeta Isaiaspa escribisqankuna cumplikuran. Chay profeta Isaiasmi khaynata niran: ");
INSERT INTO qveNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Galilea laguna qochapa ladonpi kaq Zabulonwan sutichasqa allpapi tiyaq runakuna, hinallataq Jordán mayupa chimpanpi Neftaliywan sutichasqa allpapi tiyaq runakuna. Qankunapa tiyasqaykichis Galilea provincia allpapin tiyashanku huk law nacionniyoq ashka runakuna Isaías 9.1-2. ");
INSERT INTO qveNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ichaqa tutayaqpi hina huchallapi kawsaq runakunan k'anchayta rikunqaku; Hinallataq nishu tutapi hina tiyaq runakunan k'anchayusqa kanqaku”, nispa Isaías 42.7. ");
INSERT INTO qveNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jesusqa chaymantapachan yachachiyta qallariran khaynata: —Wanakuychis huchaykichismanta; hinaspa Diosman kutirikuychis. Diospa gobiernanan p'unchawmi ña chayamushanña, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesusqa Galilea laguna qochapa patanta rishaspanmi, Pedrowan sutichasqa Simonta hinallataq wawqen Andrestawan rikuran. Paykunaqa challwa hap'iqkuna kaspankun mallankuwan challwata challwasharanku. ");
INSERT INTO qveNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Hinaspan Jesusqa paykunata khaynata niran: —Hamuychis noqawan kushka purinaykichispaq. Noqan qankunaman yachachisqaykichis, imaynan challwata challwankichis, saynallatataq runakunatapas huñunaykichispaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Chaymi Pedroqa wawqen Andrespiwan kasqan ratolla mallankuta saqespa Jesusta qatikuranku. ");
INSERT INTO qveNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Saynallataqmi Jesusqa Galilea laguna qochapa patanta rishaspa, rikullatarantaq Jacobota wawqen Juanta, hinallataq papanku Zebedeotawan ima. Paykunan mallankuta botenkupi remendashasqaku. Hinaspan Jesusqa ishkayninkuta waqyaran, payta qatikunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Hinaqtinmi Jacoboqa wawqen Juanpiwan, papankuta hinallataq botenkutapas kasqan ratolla saqespa, Jesusta qatikuranku. Nota: Jacobopa huknin sutinmi karan Santiago. ");
INSERT INTO qveNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesusmi Galilea provincia lawpi kaq llapallan llaqtakunapi puriran; Diosmanta yachachina sinagoga wasikunapi Diospa gobiernananmanta allin willakuykunata willastin; hinallataq llapallan onqosqa runakunatapas sanoyachistin ima. ");
INSERT INTO qveNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Hinaqtinmi Siria provincia lawpi kaq llapallan llaqtakunamanta, ashka runakuna Jesuspa tukuy ima ruwasqankunata yacharuspanku, apamuranku tukuy ima onqoyniyoq hinallataq nanayniyoq runakunata. Hinaspapas apamullarankutaqmi demoniopa ñak'arichisqan runakunatapas, atakiwan ñak'ariqkunatapas, such'ukunatapas, hinallataq tukuy imaymana onqoywan ñak'ariqkunatapas. Chay runakunatan Jesusqa sanoyachiran. ");
INSERT INTO qveNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Chaymi ashka runakunaqa Galilea lawmanta, Decápolis lawmanta, Jerusalén llaqtamanta, Judea lawmanta, hinallataq Jordán mayupa chimpan lawpi tiyaqkunamantapas, Jesusta qatikuranku. ");
INSERT INTO qveNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesusqa ashka runakunata ladonpi rikuspanmi, huk moqoman wicharan. Hinaspan chaypi yachachinanpaq tiyayuran. Chayta rikuspankun discipulonkunaqa payman ashuyuranku. ");
INSERT INTO qveNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Hinaqtinmi Jesusqa yachachiyta qallariran khaynata: ");
INSERT INTO qveNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Ancha kusisqan kanqaku Diosta necesitaq runakunaqa; paykunapaqmi Diospa sumaq gobiernasqanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ancha kusisqan kanqaku waqaspa kawsaq runakunaqa; paykunatan Diosqa sumaqta consuelanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ancha kusisqan kanqaku llamp'u sonqoyoq runakunaqa; paykunan allpa pachata huk herenciata hina chashkinqaku. ");
INSERT INTO qveNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ancha kusisqan kanqaku justiciata mana tariq runakunaqa. Paykunan anchata kusikunqaku paykunapa favorninpi justiciata Dios ruwasqanrayku. Saynataqa kusikunqaku, paykuna yarqachikuq hinaraq, hinallataq ch'akichikuq hinaraq chay justiciata suyasqankuraykun. ");
INSERT INTO qveNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ancha kusisqan kanqaku khuyapayakuq runakunaqa; paykunatan Diosqa sumaqta khuyapayanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ancha kusisqan kanqaku limpio sonqoyoq runakunaqa; paykunan Diostaqa rikunqaku. ");
INSERT INTO qveNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ancha kusisqan kanqaku hawkalla kawsanankupaq runamasinkuta allinpanachiq runakunaqa; paykunan Diospa wawankuna kanqaku. ");
INSERT INTO qveNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ancha kusisqan kanqaku Diospa nisqankunata kasukusqankurayku ñak'ariq runakunaqa; paykunan Diospa gobiernasqan suma-sumaq glorianpiqa kanqaku. ");
INSERT INTO qveNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ancha kusisqan kankichis noqapi creesqaykichisrayku runakuna k'amisuqtiykichis, cheqnisuqtiykichis, hinallataq llulla-llullarikusparaq contraykichispi tukuy imatapas rimaqtinkuqa. ");
INSERT INTO qveNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Anchatayá kusikuychis; hanaq pachapin hatun premiota chashkinkichis. Saynatan ñak'arichiranku qankunapa ñawpaqniykichista Diosmanta willakuq ñawpaq profetakunatapas, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jesusqa nillarantaqmi khaynata: —Qankunaqa kay pachapin kachi hina kankichis. Kachi q'aymayaruqtinqa, ¿imapaqñataq chay kachiri valenman? Manan ni imapaqpas valenmanñachu. Aswanqa wikapanallapaqñan valen. Hinaqtinmi runakunapas saruchakunku, nispa. Nota: Allin kachiqa Diospi allinta creespa Diosta qatikuq runakunamanmi rikch'akun. Ichaqa q'aymayaq kachiñataqmi rikch'akun Diospi creeshaspa mana kasukuq runakunaman. ");
INSERT INTO qveNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Jesusqa nillarantaqmi khaynata: —Qankunaqa kay pachapi runakunapaqmi huk k'anchay hina kankichis, imaynan moqo patapi ruwasqa llaqtapas, llapallan runakunapa rikunanpaq alayri kashan chay hina. ");
INSERT INTO qveNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Saynallataqmi mecherota ratachispapas, manan cajonpa ukhunmanchu churanku. Aswanqa alto patamanmi churanku, chaymanta wasipi llapallan kaqkunata allinta k'anchamunanpaq. ");
INSERT INTO qveNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Saynayá qankunapas Diosta kasukuspa huk k'anchay hina kaychis llapallan runakunapaq; saynapin allin ruwasqaykichista runakuna rikuspanku, hanaq pachapi Dios Taytaykichista paykunapas alabanqaku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jesusqa nillarantaqmi khaynata: —Uyariwaychis, noqaqa manan Moisespa escribisqan leykunata chinkachinaypaqchu, nitaq Diosmanta willakuq profetakunapa yachachisqankunata chinkachinaypaqchu hamurani. Aswanqa Moisespa escribisqan leykunata cumplinaypaqmi hamurani. ");
INSERT INTO qveNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Cheqaqtapunin niykichis, cielopas hinallataq kay pachapas tukukunqan. Ichaqa kay leymantaqa manan ni huk letrallapas ni uchuy kamachikuyllapas qechusqaqa kanqachu. Aswanqa kay leykunaqa llapallanmi cumplikunqapuni. ");
INSERT INTO qveNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Chaymi niykichis, sichus pipas kay leykunapi huk uchuy kamachikuyllatapas mana kasukunqachu chayqa, Diospa gobiernasqan sumaq glorianpiqa menos importanten kanqa. Saynallataqmi sichus pipas runamasinman kay leykunapi huk uchuy kamachikuyllatapas ama kasukunankupaq yachachinqa chayqa, Diospa gobiernasqan sumaq glorianpiqa menos importantellataqmi kanqa. Ichaqa sichus pipas kay leykunapa nisqanta kasukunqa chayqa, Diospa gobiernasqan sumaq glorianpiqa allin importante runan kanqa. Saynallataqmi sichus pipas kay leykunapi yachachikuykunata runamasinman allinta yachachinqa chayqa, Diospa gobiernasqan sumaq glorianpiqa allin importante runallataqmi kanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Chaymi niykichis, sichus fariseo religionniyoq runakunamanta, hinallataq leykunata yachachiq runakunamantapas mana aswan mastachu Diospa kamachisqanta kasukunkichis chayqa, manan Diospa gobiernasqan sumaq glorianmanqa haykunkichishchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jesusqa nillarantaqmi khaynata: —Qankunaqa uyarirankichismi ñawpaq runakunaman Moisespa khayna yachachisqanta: “Aman pitapas wañuchinkichu. Pipas runamasinta wañuchinqa chayqa, juzgasqan kanqa”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Noqan ichaqa niykichis: Pipas runamasinpaq phiñakuspa cheqnikuqqa juzgasqan kanqa. Runamasin k'amiqñataqmi juzgadopi juzgasqa kanqa. Hinallataq runamasinta maldeciqpas, nina rawraq infiernomanmi wiñaypaq wikch'uyusqa kanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Sichus ofrendaykita templopi altarman apamushaspayki, runamasiykiwan phiñachinakusqaykita yuyarirunki chayqa, ");
INSERT INTO qveNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","apamusqayki ofrendaykita altarpa ladonpi saqeyuspayá kutiy; hinaspa chay runamasiykiwan allinpamuy. Chaymantañayá chay ofrenda apamusqaykitaqa churay. ");
INSERT INTO qveNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Sichus pipas imamantapas qanpa contraykipi quejakusunki chayqa, manaraq juezpaman chayashaspayá ñanllapiraq arreglaspa allinpaychis. Sichus guardiaman juez entregarusunki chayqa, carcelmanmi apaspa churamusunki. ");
INSERT INTO qveNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Chaymi cheqaqtapuni niyki, chaymantaqa manan lloqsimunkichu llapallan debesqaykita paganaykikama, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jesusqa nillarantaqmi khaynata: —Qankunaqa uyarirankichismi ñawpaq runakunaman Moisespa khayna yachachisqanta: “Aman waqllikunkichu”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Noqan ichaqa niykichis: pipas huk warmita qawapayaspa sonqollanpipas munapayanman chayqa, ñan sonqonpiqa waqllirukunña. ");
INSERT INTO qveNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Chaymi niykichis, sichus phaña ñawiyki huchallichisunki chayqa, aswanyá orqorukuspa wikapay. Saynapin chay ñawillaykita pierdenki enteron cuerpoyki nina rawraq infiernoman wikch'uyusqa kananmantaqa. ");
INSERT INTO qveNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Hinallataq sichus phaña makiykipas huchallichisunki chayqa, kuchurpaspa wikapay. Saynapin chay makillaykita pierdenki, enteron cuerpoyki nina rawraq infiernoman wikch'uyusqa kananmantaqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Jesusqa nillarantaqmi khaynata: —Qankunaqa uyarirankichismi ñawpaq runakunaman Moisespa yachachisqanta. Paymi niran: “Pipas warminwan manaña tiyayta munaspaqa, divorcio papelta firmaspayá t'aqakuchun”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Noqan ichaqa niykichis: Sichus casado qari, warmin mana waqllikushaqtin, t'aqakunman chayqa, warmintan waqllikuy huchaman tanqashan. Ichaqa casado qariqa t'aqakunmanmi, sichus warmin huk qariwan waqllirukuqtinqa. Saynallataqmi pipas chay divorciasqa warmiwan casarakuspaqa, ishkayninkun waqllikuy huchapi kashanku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Jesusqa nillarantaqmi khaynata: —Qankunaqa uyarirankichismi ñawpaq runakunaman Moisespa khayna yachachisqanta: “Juramentota ruwaspaykichisqa, cumplinaykichispunin”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Noqan ichaqa niykichis: Qankunaqa amapunin juramentotaqa imaraykupas ruwankichishchu. Aman juramentotaqa ruwankichishchu hanaq pacharaykuqa; chayqa Diospa tiyananmi. ");
INSERT INTO qveNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Aman juramentotaqa ruwankichishchu kay pacharaykupas, chayqa Diospan. Aman juramentotaqa ruwankichishchu Jerusalén llaqtaraykupas. Chay llaqtapas hatun Reypa llaqtanmi. ");
INSERT INTO qveNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Aman juramentotaqa ruwankichishchu vidaykichisraykupas. Qankunaqa manan vidaykichispa dueñonchu kankichis. ");
INSERT INTO qveNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Imatapas rimaspaykichisqa “arí” niychis, otaq “manan” niychis. Hinaspa chay nisqaykichisman hina cumpliychis. Ichaqa imapas yapasqaykichisqa diablopa partenmantan hamun, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jesusqa nillarantaqmi khaynata: —Qankunaqa uyarirankichismi ñawpaq runakunaman Moisespa yachachisqanta. Paymi niran: “Pipas runamasinpa ñawinta orqonqa chayqa, paypa ñawinpas orqosqallataqmi kanan. Hinallataq pipas runamasinpa kirunta p'akinqa chayqa, paypa kirunpas p'akisqallataqmi kanan”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Noqan ichaqa niykichis: Pipas mana allinta qankunapa contraykichispi ruwanqaku chayqa, qankunapas amayá paykuna hinallataqchu ruwaychis. Sichus pipas phaña uyaykipi takasuqtiykiqa, aswanyá lloq'e uyaykitawan kutirichiy. ");
INSERT INTO qveNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Hinallataq, sichus pipas juezman quejakuspa camisaykita qechuyta munasunki chayqa, aswanyá ponchoykitawan qoykuy. ");
INSERT INTO qveNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Hinallataq, sichus pipas obligaspa, huk kilómetro puriyta hina, q'epinta q'epichisunki chayqa, ishkay kilómetro puriyta hinayá aparapuy. ");
INSERT INTO qveNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Hinallataq, sichus pipas mañakusunki imatapas chayqa, qoykuyá. Saynallataq pipas imatapas “prestaykuway” nisunki chayqa, prestaykuyá, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jesusqa nillarantaqmi khaynata: —Qankunaqa uyarirankichismi ñawpaq runakunaman khayna yachachisqankuta: “Amigoykitaqa khuyakunkin, enemigoykitan ichaqa cheqnikunki”, nisqankuta. ");
INSERT INTO qveNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Noqan ichaqa niykichis: Enemigoykichis runakunata khuyakuychis; {bendeciychis maldecisuqniykichis runakunata; allin kaqta ruwaychis cheqnisuqniykichis runakunapaq;} hinallataq Diosmanta mañapuychis cheqnispa qatikachasuqniykichis runakunapaqpas. ");
INSERT INTO qveNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Chayta ruwaspan qankunaqa hanaq pachapi Dios Taytaykichispa wawankuna kasqaykichista reqsichikunkichis. Paymi intitapas lloqsichimun allin ruwaq runakunapaq, hinallataq mana allin ruwaq runakunapaqpas. Payllataqmi parachimunpas allin ruwaq runakunapaq, hinallataq mana allin ruwaq runakunapaqpas. ");
INSERT INTO qveNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Sichus khuyakusuqniykichis runakunallata khuyakunkichis chayqa, qankunaqa manan ni ima premiotapas chashkinkichishchu. Saynataqa impuestota cobraq huchasapa runakunapas ruwankun. (Chayraykun paykunapas mana ni ima premiotapas chashkinqakuchu). ");
INSERT INTO qveNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Hinaspapas, sichus amigollaykichista rimayukunkichis chayri, ¿ima allintataq ruwashankichisrí? Saynataqa Diospi mana creeq huchasapa runakunapas ruwankun. ");
INSERT INTO qveNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Qankunaqa allin kaqkunatayá llapallan runakunapa favorninpaq imatapas ruwaychis, imaynan hanaq pachapi Dios Taytaykichispas allin kaqkunallata ruwan chay hinata, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jesusqa nillarantaqmi khaynata: —Amayá qankunaqa runakuna rikunallanpaqchu allin kaqkunataqa ruwaychis. Sichus runakunapa rikunallanpaq imatapas ruwankichis chayqa, hanaq pachapi Dios Taytaykichisqa manan ni ima premiotapas qosunkichishchu. ");
INSERT INTO qveNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Wakchakunaman imatapas qospaykichisqa, amayá runakunaman willakachakusparaqchu imatapas qoychis. Ichaqa ishkay uya runakunallan runakunaman willakachakuspaqa qonku, Diosmanta yachachina sinagoga wasikunapi, hinallataq callekunapipas, alabasqa kanankupaq. Ichaqa cheqaqtapunin niykichis, saynata ruwasqankuraykun chay runakunaqa, ña chashkirunkuña premionkuta; chay premioqa runakunapa alabasqanmi. Chaymi paykunaqa manaña ni ima premiotapas Diosmantaqa chashkinqakuñachu. ");
INSERT INTO qveNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Aswanqa wakchakunaman imatapas qosqaykitaqa, amayá ni pipas yachachunchu. ");
INSERT INTO qveNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Sayna secretollapi qosqaykita rikuspan, Diosqa premioykita qanman qosunki {runakunapa ñawpaqninpi}. ");
INSERT INTO qveNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jesusqa nillarantaqmi khaynata: —Qankunaqa Diosman orakuspaykichisqa amayá ishkay uya runakuna hinachu orakuychis. Paykunaqa runakuna rikunallanpaqmi orakunku, Diosmanta yachachina sinagoga wasikunapi, hinallataq calle esquinakunapipas sayaykuspa. Noqan ichaqa cheqaqtapuni niykichis: saynata orakuspaqa ñan paykunaqa premionkuta chashkirunkuña; chay premionkuqa runakunapa alabasqanmi. Chaymi paykunaqa Diosmanta manaña ni ima premiotapas chashkinqakuñachu. ");
INSERT INTO qveNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ichaqa Diosmanta qan orakuspaykiqa, wasiyki ukhuman haykuy; punkuta wisq'ayukuspa, mana rikuna Dios Taytaykiman orakuy. Saynata secretollapi orakusqaykita rikuspanmi, Dios Taytaykiqa premioykita qosunki {llapallan runakunapa ñawpaqninpi}. ");
INSERT INTO qveNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Qankunaqa Diosman orakuspaqa, amayá Diosta mana reqsiq runakuna hinachu, kaq-kaqllata rimaspa comunta orakuychis. Paykunaqa piensankun, kaq-kaqllata unayllataña orakuqtinku, Dios uyarinanpaq. ");
INSERT INTO qveNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Qankunaqa amayá paykuna hinachu orakuychis. Dios Taytaykichisqa manaraq orakushaqtiykichismi, ña yachanña imakuna necesitasqaykichistapas. ");
INSERT INTO qveNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Qankunaqa Diosmanta orakuspaykichisqa khaynatayá orakuychis: “Hanaq pachapi Dios Taytayku, sutiyki yupaychasqa kachun. ");
INSERT INTO qveNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Hamuy noqaykuman sumaqta gobiernawanaykikupaq. Munayniyki ruwasqa kachun, imaynan hanaq pachapipas hinallataq kay pachapipas. ");
INSERT INTO qveNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Sapa p'unchawtaq t'antaykuta qowayku. ");
INSERT INTO qveNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tukuy huchaykutapas perdonawayku, imaynan noqaykupas perdonayku mana allin ruwawaqniykutapas. ");
INSERT INTO qveNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Amataq dejawaykuchu tentasqa kanaykuta, aswan mana allinmanta waqaychawayku. {Ichaqa qanpan, kay pachapi, hanaq pachapi gobiernasqaykipas, atiyniykipas, hinallataq sumaq k'anchariq kayniykipas wiña-wiñaypaq. Amén}”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Contraykichispi mana allin ruwaq runakunata qankuna perdonankichis chayqa, hanaq pachapi Dios Taytaykichispas perdonasunkichismi. ");
INSERT INTO qveNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Sichus mana perdonankichishchu contraykichispi mana allin ruwaq runakunata chayqa, hanaq pachapi Dios Taytaykichispas manan qankunataqa huchaykichismanta perdonasunkichishchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jesusqa nillarantaqmi khaynata: —Ayunaspaykichisqa aman ishkay uya runakuna hinachu llakisqa uyayoq kankichis. Paykunaqa llakisqa uyantinmi kanku, saynapi ayunasqankuta runakuna yachanankupaq. Cheqaqtapunin niykichis, saynata ruwasqankuraykun chay runakunaqa ña chashkirunkuña premionkutaqa. Chay premio chashkisqankuqa runakunapa alabasqanmi. Chaymi paykunaqa Diosmanta manaña ni ima premiotapas chashkinqakuñachu. ");
INSERT INTO qveNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ichaqa qan ayunaspaykiqa, uyaykita unuwan uphakuspa, sumaqta umaykitapas ñaqch'akuy. ");
INSERT INTO qveNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Saynata ruwaqtiykin, qanpa ayunasqaykimantaqa mana ni pipas cuentata qokunqachu. Aswanpas hanaq pachapi Dios Taytallaykin yachanqa. Hinaspan premioykita qosunki {llapallan runakuna rikunanpaq}, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jesusqa nillarantaqmi khaynata: —Qankunaqa amayá kay pachapi qolqeta huñuspa qapaq kayllapichu piensaychis. Kay pachapi imapas huñusqaykichistaqa phuyu urun mikhuspa tukun; ismuspan tukukun; hinallataqmi suwapas suwakun. ");
INSERT INTO qveNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Qankunaqa aswanyá hanaq pachapi qapaq kayta munaspaqa, Diosta allinta serviychis tukuy kaqniykichiswan. Saynata ruwaspan hanaq pachapiqa qapaq kankichis. Chaypiqa manan ismunqachu, nitaq phuyu urupas mikhunqachu, nitaq suwapas suwakunqachu. ");
INSERT INTO qveNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ichaqa maypichus qapaq kayniyki kashan, chayllapitaqmi sonqoykichispas kashan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Jesusqa nillarantaqmi khaynata: —Ñawiykiqa huk mechero hinan kashan, enteron aycha cuerpoykita k'anchayunanpaq. (Mecheropa k'anchayninqa Diospa yachachikuyninmi). Chaymi chay k'anchayta allinta rikuspaykichisqa, tukuy imatapas allinta ruwanaykichis, (Diospa yachachikuyninta allinta chashkisqaykichisrayku). ");
INSERT INTO qveNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ichaqa sichus ñawiyki ñawsayasqa kaqtinqa, manan allintachu qawawaq purinaykipaqqa. (Saynallataqmi sichus sonqoyki qenlli kaqtinpas, allintaqa manan kawsawaqchu, huchapi kawsasqaykirayku), nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Jesusqa nillarantaqmi khaynata: —Manan ni pi sirvientepas ishkay patronkunataqa kasqan ratollaqa serviyta atinmanchu. Huknin kaq patronnintan masta khuyakuspa allinta servinman; huknin kaq patronnintañataqmi cheqnikuspa mana allintachu servinman. Saynallataqmi pipas kay pachapi qapaq kayllata munaspaqa, Diostaqa mana allintachu servinman, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Jesusqa nillarantaqmi khaynata: —Qankunaqa amayá preocupakuychishchu mikhunaykichismanta, tomanaykichismanta nitaq p'achakunaykichismantapas. Kay pachapi vidaykichisqa valen allin kaqkunata ruwanaykichispaqmi, manan mikhuchinallaykichispaqchu. Saynallataqmi cuerpoykichispas allin kaqkunata ruwanaykichispaq valen, manan sumaqta p'achachinallaykichispaqchu. ");
INSERT INTO qveNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Aswanyá qawariychis alton phawaq pichinkukunata. Paykunaqa manan tarpunkuchu nitaq cosechankuchu, nitaqmi huñunkupashchu waqaychanankupaqqa. Ichaqa hanaq pachapi Dios Taytaykichismi mikhuchin. ¡Qankunaqa chay pichinkukunamantapas, aswan más valorniyoqmi kankichis! ");
INSERT INTO qveNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Icha ¿qankuna creenkichishchu sapa p'unchaw aswan masta afanakuspaykichis, huk p'unchawtawan kawsanaykichispaq, otaq huk chikallantapas wiñaruyta? ");
INSERT INTO qveNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Chayri, ¿imanaqtintaq p'achaykichismantapas afanakunkichís? Qawariychisyá campokunapi sumaqllaña wiñaq t'ikakunata. Chay t'ikakunaqa manan llank'ankuchu nitaqmi pushkankupashchu p'achakunankupaqqa. ");
INSERT INTO qveNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ichaqa cheqaqtapunin niykichis, Israel nación llaqtapi ñawpaq kamachiq rey Salomonpas, ancha qapaq kashaspanmi, huknin kaq t'ikakuna hinallapas mana p'achakuranchu. ");
INSERT INTO qveNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Diosmi chay t'ikakunataqa sumaqta t'ikachispa chikan tiempollapaq wiñachin; ch'akiruqtintaqmi ninaman wikch'uyusqa. Chayri, ¿Diosqa manachu qankunata chay t'ikakunamantapas aswan mastaraq p'achachisunkichisman? ¡Qankunaqa pisi iñiyniyoq runakunan kankichis! ");
INSERT INTO qveNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Hinaspapas qankunaqa amayá afanakuychishchu, nitaq preocupakuychishchu mikhunaykichismanta, tomanaykichismanta, nitaq p'achakunaykichismantapas. ");
INSERT INTO qveNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kay pachapi mikhuymanta, tomaymanta hinallataq p'achakuymantaqa, Diospi mana creeq runakunallan mastaqa afanakunku. Ichaqa hanaq pachapi Dios Taytaykichisqa yachanmi imapas necesitasqaykichistaqa. ");
INSERT INTO qveNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Chaymi niykichis, primertaqa Diosta mashkaychis, hinaspa Diospa munasqanman hina imatapas ruwaychis. Saynata ruwaspa kawsaqtiykichismi tukuy ima necesitasqaykichistapas Diosqa qosunkichis. ");
INSERT INTO qveNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Saynaqa amayá afanakuychishchu paqarin p'unchawmantaqa. Sapa p'unchaw afanakuyqa chay p'unchawllapaqyá kachun, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jesusqa nillarantaqmi khaynata: —Aman runamasiykichistaqa yanqapuniqa juzgankichishchu, Diospas qankunata ama juzgasunaykichispaq. ");
INSERT INTO qveNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Imaynatan qankunapas runamasiykichista juzgankichis, saynallatataqmi Diospas qankunataqa juzgasunkichis. Imaynatan qankuna runamasiykichiswan ruwankichis, saynatan Diospas qankunawan ruwanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Qanri, ¿imanaqtintaq runamasiykipa ñawinpi kaq ishutari qawashankí? Qanqa, ¿manachu aswan qawakuwaq ñawiykipi rakhu k'aspi kasqanta? ");
INSERT INTO qveNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ñawiykipi rakhu k'aspi hina kashaqtinri, ¿imaynataq wawqeykitari niwaq: “Wawqéy, ñawiykipi ishuta orqorusqayki”, nisparí? ");
INSERT INTO qveNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Ishkay uya runa! ¿Manachu aswan primertaqa ñawiykipi rakhu kaq k'aspitaraq orqokuwaq? Chayta ruwaspan allinta rikunki, wawqeykipa ñawinpi ishuta orqonaykipaqqa. Nota: “Ñawipi ishuqa” rimashan chikallan huchamantan. “Ñawipi rakhu k'aspiñataqmi” rimashan nishu millay hatun huchakunamanta. ");
INSERT INTO qveNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Diospa sumaq palabrantaqa amayá mana uyariy munaq runakunamanqa willaychishchu. Chay runakunaman Diospa palabranta willaspaykichisqa, alqomanpas otaq khuchikunamanpas Diospa palabranta willashawaqchis hinan. Paykunaqa chay willasqaykichista saruchakuspankun, kanikuq alqo hina qankunapa contraykichispi sayarinkuman, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jesusqa nillarantaqmi khaynata: —Diosmanta mañakuychis; payqa qosunkichismi. Mashkaychis; tarinkichismi. Punkuta tocaychis; kichamusunkichismi. ");
INSERT INTO qveNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Pipas Diosmanta mañakuqmi, chashkin. Mashkaqmi, tarin. Waqyakuqtintaqmi, punkuta kichamun. ");
INSERT INTO qveNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿Mayqenniykichistaq wawaykichis t'antata mañakusuqtiykichis, huk rumita qoykuwaqchís? ");
INSERT INTO qveNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Otaq ¿challwata mañakusuqtiykichispas, mach'aqwayta qoykuwaqchís? ");
INSERT INTO qveNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Qankunaqa mana allin runakuna kashaspaykichispas, wawaykichismanqa allin kaqkunatan qonkichis. Saynallataqmi hanaq pachapi Dios Taytaykichismanta mañakuqtiykichispas, payqa aswan mastaraq qosunkichis. ");
INSERT INTO qveNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Saynaqa imaynatachus qankunapaq runakuna ruwananta munankichis, saynallatataq qankunapas paykunapaq ruwaychis. Saynatan Moisespa escribisqan leykunapipas, hinallataq profetakunapa escribisqankunapipas nishan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Jesusqa nillarantaqmi khaynata: —Qankunaqa k'itku punkuntayá haykuychis. Ancho punkunta haykuqqa, ancho ñannintan rishan, facilla purinapaq kasqanrayku. Chay ñannintaqa ashkallaña runakunan rishanku wiña-wiñay ñak'ariy nina rawray infiernoman. ");
INSERT INTO qveNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ichaqa kanmi wiñay kawsayman apakuq k'itku punkupas, hinallataq k'itku ñanpas. Chay k'itku ñantaqa chikallanmi runakunaqa tarinku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jesusqa nillarantaqmi khaynata: —Qankunaqa cuidakuychis, falso profeta runakunamanta. Paykunaqa huk manso oveja hinan qankunaman hamunqaku. Ichaqa paykunapa piensayninkuqa yarqasqa suwa atoqpa hinaraqmi kashan. ");
INSERT INTO qveNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Qankunaqa chay falso profeta runakunataqa, imapas ruwasqanpin reqsinkichis. Runakunaqa manan kishkayoq sach'amantachu uvastaqa pallanku, nitaqmi higostapas kishkayoq sach'amantachu pallanku. ");
INSERT INTO qveNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Llapallan allin sach'akunaqa allin rurutan rurun. Ichaqa mana allin sach'akunañataqmi, mana allin ruruta rurun. ");
INSERT INTO qveNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Allin sach'aqa manapunin mana allin rurutaqa rurunmanchu. Saynallataqmi mana allin sach'apas manapuni allin rurutaqa rurunmanchu. ");
INSERT INTO qveNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Llapallan mana allin ruruq sach'akunataqa, wit'uspan ninaman wikch'uyuspa k'ananku. ");
INSERT INTO qveNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Chaymi niykichis, chay llullakuspa rimaq falso profetakunataqa reqsinkichis imatapas ruwasqankuta qawaspan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Jesusqa nillarantaqmi khaynata: —Runakunaqa niwanqakun “¡Señorlláy, Señorlláy!” nispanku. Ichaqa manan paykunamantaqa llapallankuchu hanaq pacha Dios Taytaypa glorianmanqa haykunqaku, aswanqa Dios Taytaypa munasqanta ruwaqkunallan. ");
INSERT INTO qveNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Juicio p'unchaw chayaramuqtinmi, ashka runakunaqa niwanqaku khaynata: “Señorlláy, Señorlláy, noqaykuqa qanmantan willarayku. Qanpa sutiykipin demoniokunatapas runakunamanta qarqorayku. Saynallataqmi qanpa sutiykipi ashka milagrokunatapas ruwarayku”, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Hinaqtinmi noqaqa paykunata nisaq: “¡Llapallan huchasapa runakuna, ñawpaqniymanta ayqeriychis! ¡Manan qankunataqa reqsiykichishchu!” nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jesusqa nillarantaqmi khaynata: —Noqapa yachachisqaykunata uyarispa kasukuq runaqa, huk yachayniyoq runamanmi rikch'akun. Paymi wasinta ruwananpaq pampata t'oqospa, rumi hawapi cimientota hatarichin. ");
INSERT INTO qveNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Chaymi paraqa, wayrantin hinallataq lloqllantin hamuspa, chay wasitaqa mana thuñichiranchu, rumiwan cimentacionnin allin ruwasqa kasqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ichaqa wakin runakunaqa noqapa yachachisqaykunata uyarishaspankun mana kasukunkuchu. Paykunan rikch'akunku wasinta ruwaq huk mana yachayniyoq runaman. Paymi wasinta ruwananpaq pampata t'oqon hawallata. Hinaspan chay runaqa, roqro uma kasqanrayku, aqo-aqo hawallapi wasinta hatarichin. ");
INSERT INTO qveNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Chaymi paraqa, wayrantin hinallataq lloqllantin hamuspa, chay wasitaqa q'alata apan, allpa hawallapi ruwasqa kasqanrayku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Chaymi Jesús yachachiyta tukuruqtin, chaypi uyariq runakunaqa ancha admirasqallaña karanku. ");
INSERT INTO qveNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Jesusqa manan leykunamanta yachachiq runakuna hinachu yachachiran. Aswanmi payqa huk maestro hina ancha autoridadwan yachachiran. Chayraykun llapallan runakunaqa Jesuspa yachachisqanwan anchata admirakuranku. ");
INSERT INTO qveNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesusqa chay moqopi yachachiyta tukuruspanmi urayamuran. Chaymi ashka runakunaqa Jesuswan kushka riranku. ");
INSERT INTO qveNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Hinaqtinmi huk runa lepra onqoyniyoq Jesusman ashuyuran. Hinaspan Jesuspa ñawpaqninpi qonqoriyukuspa, khaynata niran: —Señorlláy, munaspaykiqa kay onqoyniymantayá sanoyaykachiway, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Chaymi Jesusqa makinwan llamiykuspa chay runata niran: —Arí, noqaqa munanin sanoyanaykita, nispa. Hinaqtinmi kasqan ratolla chay lepra onqoyniyoq runaqa, sanoyapuran. ");
INSERT INTO qveNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Hinaspan Jesusqa niran: —Aman pimanpas kaykuna pasasusqaykimantaqa willankichu. Aswanyá Israel templopi serviq sacerdotekunaman rispa, qawachikamuy sanoña kasqaykita. Hinaspayki Moisespa escribisqan leyman hina ofrendaykita qomuy. Saynapin paykunaqa sanoña kasqaykita yachanqaku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Capernaúm llaqtaman Jesús chayaruqtinmi soldadokunapa jefenqa Jesusman ashuyuspa khaynata ruegakuran: ");
INSERT INTO qveNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Señorlláy, serviwaqniy runan wasiypi nishuta ñak'arishan, enteron cuerpon wañusqa hina kasqanrayku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Hinaqtinmi Jesusqa khaynata niran: —Kunanmi wasiykiman rispa sanoyachimusaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Chaymi chay soldadokunapa jefenqa niran: —Señorlláy, ¿pitaq noqari kani wasiyman haykunaykipaqrí? Noqaqa manan merecenichu wasiyman rinaykipaqqa. Ichaqa kunan rato qan rimarillaqtiykin, serviqniyqa sanoyanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ichaqa noqapas jefeykunata kasukuqmi kani; saynallataqmi soldadoykunapas noqapa kamachisqayta ruwan. Chaymi paykunata kamachiqtiy, paykunapas kasuwanku; hukninta: “Riy” niqtiyqa, rinmi; huknintapas: “Hamuy” niqtiyqa, hamunmi. Saynallataqmi serviwaqniy runatapas: “Kayta ruway” niqtiyqa, paypas ruwanmi, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Chay soldadokunaq jefenpa nisqanta uyarispanmi Jesusqa, admirakuspa, paywan kushka riq runakunata niran: —Cheqaqtapunin niykichis, kay enteron Israel nación llaqtapipas, manan noqaqa ni pitapas tariranichu khayna allin iñiyniyoq runataqa. ");
INSERT INTO qveNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Chayqa uyariwaychisyá kay nisqayta: Enteron mundomantan noqapi creeq runakunaqa hamunqaku kay forastero runa hina. Hinaspan paykunapas Abrahamwan, Isaacwan hinallataq Jacobwan ima, Diospa gobiernasqan sumaq glorianpi, mesaman tiyayunqaku mikhunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ichaqa Diospa gobiernasqan sumaq glorianman haykunankupaqmi primerta invitasqa karanku Israel nacionniyoq runakuna. Ichaqa Diospi mana creesqankuraykun paykunaqa huk tutayaq lugarman qarqosqa kanqaku. Chaypin waqanqaku, hinallataq nanaymanta kirunkuraq rach'ikyanqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Chaymantan Jesusqa chay soldadokunapa jefenta niran: —Wasiykiman kutipuy; hinaspa noqapi creesqaykiman hina ruwasqa kachun, nispa. Hinaqtinmi Jesuspa rimarisqan ratomantapacha, chay soldadokunapa jefenta serviq runaqa sanoyaran. ");
INSERT INTO qveNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesusqa Pedropa wasinmanmi riran. Chaypin Pedropa suegranta rikuran nishu fiebrewan camapi onqoshaqta. ");
INSERT INTO qveNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Hinaspanmi Pedropa suegranman ashuyuspa, Jesusqa makinta llamiykuran. Chaymi Pedropa suegranqa chay fiebre onqoymanta kasqan ratolla sanoyaran. Hinaspan camanmanta hatarispa, paykunaman mikhunata serviran. ");
INSERT INTO qveNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tutayaykushaqtinñan Jesusman apamuranku demoniokunapa ñak'arichisqan ashka runakunata. Hinaqtinmi Jesusqa huk rimayllawan chay demoniokunata qarqoran. Hinaspan chaypi kaq llapallan onqosqa runakunatapas sanoyachillarantaq. ");
INSERT INTO qveNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Saynapin Diosmanta willakuq ñawpaq profeta Isaiaspa khayna escribisqan cumplikuran: “Paymi noqanchispa onqoyninchiskunamanta, hinallataq tukuy nanayninchiskunamantapas sanoyachiwasun”, nispa Isaías 53.4. ");
INSERT INTO qveNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesuspa muyuriqninpi ashkallaña runakuna kaqtinmi, Jesusqa discipulonkunata kamachispa, khaynata niran: —Hakuchi Galilea laguna qochapa waq law chimpanman, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Hinaqtinmi leykunata yachachiq huk runaqa, Jesusman ashuyuspa, khaynata niran: —Yachachikuq, maytaña riqtiykipas noqaqa qatikusqaykin, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Hinaqtinmi Jesusqa contestaran: —Atoqkunapaqa kanmi puñunankupaq t'oqokuna. Alton phawaq pichinkukunapapas kanmi puñunankupaq lugarninku. Ichaqa noqa Diosmanta Hamuq Runapaqa manan kanchu mayman haykuspa puñunaypaqpas, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Hinaqtinmi Jesusta huk discipulon nillarantaq khaynata: —Señorlláy, primertaqa dejaykuwayraq papay wañuqtin p'amparamunaykama. Chaymantaña qantaqa qatikusqayki, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Chaymi Jesusqa niran: —Qanqa noqata qatikuway. Diospi mana creeq runakunaqa wañusqa hinan kashanku. Paykunayá wañusqa runakunataqa p'ampamushachunku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesusmi huk boteman wicharan. Hinaqtinmi discipulonkunapas wichaspanku, paywan kushka riranku. ");
INSERT INTO qveNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Hinaqtinmi chay botepi rishaqtinku Jesusqa puñururan. Hinaspan qonqayllamanta nishuta wayra-wayramuspa, chay hatun laguna qochapi unuta altoman qallchichimuran. Chaymi chay risqanku botemanqa unu hunt'ayta qallariran. ");
INSERT INTO qveNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Hinaqtinmi discipulonkunaqa nishuta mancharikuspanku, Jesusta rikch'achiranku khaynata: —¡Señor, Señor! ¡Salvawayku! ¡Unu ukhumanmi chinkayushanchishña! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Chaymi Jesusqa niran: —¡Pisi iñiyniyoq runakuna! ¿Imanaqtintaq qankunari noqapi mana confiaspa, aswan mancharisqa kashankichís? nispa. Saynata nispanmi, Jesusqa sayarimuspa chay wayrata, hinallataq laguna qochapi qallchikamuq unutawan kamachiran thañinanpaq. Chaymi kasqan ratolla wayrapas unupas thañiran. ");
INSERT INTO qveNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Hinaqtinmi Jesuspa discipulonkunaqa admirasqallaña anchata mancharikuspanku tapunakuranku khaynata: —¿Imayna runañataq kay runarí? Pay kamachiqtin, ¿wayrapas, unupas kasukunanpaqrí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Galilea laguna qochapa waq lawnin Gadara lugarman Jesús chayaruqtinmi, panteonmanta ishkay runakuna Jesusman hamuranku. Chay ishkaynin runakunaqa demoniopa ñak'arichisqanraykun ancha manchakunapaq karanku. Chaymi chay ñannintaqa mana ni pipas pasayta atirankuchu. ");
INSERT INTO qveNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Hinaqtinmi chay ishkay runakunapi kaq demoniokunaqa, altota qaparispa, khaynata niranku: —Tukuy atiyniyoq Diospa Wawan Jesús, ¿imatataq qanri noqaykuwan munashankí? ¿Manaraq tiempo chayamushaqtinchu noqaykuta ñak'arichiwanaykikupaq hamushankí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Chay cercallankupitaqmi ashka khuchikuna mikhusharanku. ");
INSERT INTO qveNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Hinaqtinmi demoniokunaqa chay khuchikunata rikuspanku, Jesusta ruegakuranku khaynata: —Qarqowankiku chayqa dejaykuwaykuyá waq khuchikunaman haykunaykupaq, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Hinaqtinmi Jesusqa niran: —Riychis, nispa. Chaymi demoniokunaqa chay ishkaynin runakunamanta lloqsispanku, chay ashka khuchikunapa cuerponman haykuranku. Hinaqtinmi chay khuchikunaqa qata urayta p'itaspanku, Galilea laguna qochaman urmayuranku. Hinaspan chay laguna qochapi heq'epaspa wañuranku. ");
INSERT INTO qveNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Hinaqtinmi chay khuchikunata michiq runakunaqa, chayta rikuspanku, anchata mancharikuspa llaqtaman ayqekuranku. Chay llaqtaman chayaruspankutaqmi tukuy ima rikusqankuta runakunaman willakachakuranku, hinallataq demoniokunapa ñak'arichisqan runakuna sanoyasqanmantawan ima. ");
INSERT INTO qveNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Chaykunata uyarispankun, chay llaqtapi tiyaq llapallan runakunaqa Jesuspa kasqanman hamuranku. Hinaspan Jesusta ruegakuranku khaynata: —Kay llaqtaykumanta huk lawman ripuy, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Chaymantan Jesusqa boteman qespispa, Galilea laguna qochapa waq law chimpanman riran. Hinaspan chayaran tiyasqan Capernaúm llaqtaman. ");
INSERT INTO qveNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Chaypi kashaqtinmi huk mana puriq runata kallapipi wantumuranku. Hinaqtinmi Jesusqa chay wantumuq runakunapa iñiyninkuta yachaspa, chay mana puriq runata niran: —Wawalláy, ama llakikuychu, kallpanchakuy. Llapallan huchaykikunatan perdonayki, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Hinaqtinmi leykunata yachachiq wakin runakunaqa, sonqollankupi piensaranku khaynata: “Kay runaqa runallan, chayri ¿pi kananpaqtaq payri creekun? ¿Payri Dios kananpaqchu creekun, tukuy kaykunata rimaspa? Payqa Diostan ofendeshan kaykunata rimaspanqa”, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesusñataqmi chay runakunapa piensasqanta yachaspa, tapuran khaynata: —Qankunari, ¿imanaqtintaq chay mana allinkunatari piensashankichís? ");
INSERT INTO qveNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kunanyá niwaychis: ¿Imataq más facilri kanman? ¿Kay runapa huchankunata perdonaychú? Icha ¿sanoyachispa “ripuy” niychú? ");
INSERT INTO qveNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kunanmi yachankichis, noqa Diosmanta Hamuq Runaqa kay pachapi runakunapa huchankunata perdonanaypaq atiyniyoq kasqayta, nispa. Chayta rimayta tukuruspanmi, Jesusqa chay mana puriq runata niran: —Sayariy; hinaspa chay kallapiykita oqarispa wasiykiman ripuy, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Chaymi chay mana puriq runaqa sayarispa wasinman ripuran. ");
INSERT INTO qveNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Hinaqtinmi chaypi kaq runakunaqa, chay mana puriq runapa sanoyasqanta rikuspanku, anchata admirakuspa, tukuy manchakuywan Diosta alabaranku, Jesucristoqa ancha atiyniyoq kasqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesusqa chay mana puriq runata sanoyarachispanmi, chaymanta lloqsispa risharan. Hinaspan Mateo sutiyoq runata impuesto cobranan puestopi tiyashaqta rikuran. Hinaspan Jesusqa payta niran: —¡Qatikuway noqata! nispa. Chayta uyarispanmi Mateoqa, tukuy ruwasqankunata saqespa, Jesuswan kushka riran. ");
INSERT INTO qveNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Hinaspan Mateoqa mikhunata wasinpi wayk'uchiran Jesusman invitananpaq. Chaymi Jesusqa discipulonkunapiwan, Mateopa impuesto cobraqmasinkunapiwan, hinallataq huchasapa runakunapiwan ima, mesapi kushka mikhusharanku. ");
INSERT INTO qveNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Chayta rikuspankun fariseo religionniyoq runakunaqa, Jesuspa discipulonkunata tapuranku khaynata: —Yachachisuqniykichis Jesusri, ¿imanaqtintaq impuesto cobraq runakunawan, hinallataq huchasapa runakunawan kushkari mikhushan? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesusqa chayta uyariruspanmi, khaynata niran: —Medicotaqa onqosqa runakunallan necesitanku; sano runakunan ichaqa mana necesitankuchu. ");
INSERT INTO qveNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Qankunaqa riychisyá, hinaspa yachamuychis ima ninantas Bibliapi nishan chayta. Diosmi khaynata niran: “Manan munanichu animalkunata wañuchispa sacrificio ofrendata q'oshñichimuwanaykichistaqa. Aswanqa munani khuyapayakuq kanaykichistan”, nispa. Noqaqa hamurani manan justo tukuq runakunata waqyaqchu, aswanqa huchayoq runakunata salvaqmi, saynapi huchankuta saqespanku, noqata qatikuwanankupaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Bautizaq Juanpa discipulonkunan Jesusman hamuspa tapuranku: —Noqaykupas hinallataq fariseo religionniyoq runakunapas ayunaykun. Ichaqa qanpa discipuloykikunari, ¿imanaqtintaq mana ayunankuchú? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Hinaqtinmi Jesusqa contestaran khaynata: —Huk casarakuyman invitasqa runakunaqa manan llakisqaqa kankumanchu, casarakuq qari chayllapiraq kashaqtinqa. Ichaqa kanqan p'unchawkuna, casarakuq qari paykunapa kasqanmanta qechusqa kaqtin, paykunapas ayunanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Thanta p'achataqa manan ni pipas mosoq telawanqa remendanmanchu. Saynata remendaqtinqa chay mosoq remiendoqa ch'intispanmi astawanmi chay thanta p'achataqa llik'irunman. ");
INSERT INTO qveNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Saynallataqmi manaraq poqosqa vinotaqa mana ni pipas hich'anmanchu thanta odrekunamanqa. Ichaqa chay vino poqoruspanmi chay thanta odrekunataqa phatarachinman. Hinaspan vinopas usunman, hinallataq odrekunapas manaña ni imapaqpas valenmanñachu. Chaymi manaraq poqosqa vinotaqa mosoq odrekunaman hich'ana, saynapi odrepas hinallataq vinopas mana perdenanpaq, nispa. Nota: Mana poqosqa vinon rikch'akun Jesuspa yachachisqankunaman. Poqosqa vinoñataqmi rikch'akun Israel nacionniyoq runakunapa ñawpaq mana valeq costumbrenkunaman. Chaymi Diospa palabrankunamanqa costumbrenchiskunataqa mana yapananchishchu. ");
INSERT INTO qveNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Chaykunata Jesús rimallashaqtinraqmi, Diosmanta yachachina sinagoga wasipi kamachiq runa, Jesusman hamuspa, ñawpaqninpi qonqoriyukuspa, ruegakuran khaynata: —¡Ususiymi kunallan wañurun! Sichus qan rispayki payta llamiykuqtiykiqa kawsarinqan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Hinaqtinmi Jesusqa tiyasqanmanta hatarispa, discipulonkunapiwan kushka, chay runapa qepanta riranku. ");
INSERT INTO qveNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Hinaqtinmi ñanta rishaqtinku, huk warmi chunka ishkayniyoq wataña yawar apariy onqoywan onqosqa kasqa. Hinaspan Jesusman qepallanta ashuyuspa, p'achanpa patallanta llamiykuran. ");
INSERT INTO qveNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Chay warmiqa sonqollanpin piensaran khaynata: “Sichus p'achallantapas tupayusaq chayqa, sanoyasaqmi”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Chaymi Jesusqa qepan lawta qawariran. Hinaspan chay warmita rikuspan khaynata niran: —Wawáy, kallpanchakuy. Diospi iñisqaykiraykun sanoña kanki, nispa. Hinaqtinmi chay warmiqa chay ratomantapacha sanoyapuran. ");
INSERT INTO qveNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Chaymantan Jesusqa chay kamachiq runapa wasinman riran. Chaypin quenata tocaqkunapas listollaña kashasqaku chay runapa ususinta p'ampaq apanankupaq; hinallataqmi ashka runakunapas llakikuymanta waqashasqaku. ");
INSERT INTO qveNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Hinaqtinmi Jesusqa paykunata niran: —Lloqsiychis kaymanta. Sipasqa manan wañusqachu kashan. Aswanqa puñullashanmi, nispa. Chaymi chaypi kaq runakunaqa, Jesusmanta burlakuspa, asipayaranku. ");
INSERT INTO qveNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ichaqa hawaman paykunata Jesús lloqsirachispanmi, Jesusqa chay wañusqa sipaspa kasqanman haykuspa, ashuyuran. Hinaspan makinmanta aysariykuqtin, chay sipasqa hatarimuran. ");
INSERT INTO qveNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Hinaqtinmi chay Capernaúm llaqtapa cercankunapi tiyaq runakunaqa, tukuy kaykuna pasasqanmanta yacharanku. ");
INSERT INTO qveNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Chaymanta Jesús rishaqtinmi, ishkay ñawsa runakuna Jesuspa qepanta riranku, khaynata waqyakuspa: —¡Davidpa mirayninmanta Jesús, khuyapayaykuwaykuyá! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Hinaqtinmi wasiman Jesús chayaruqtin, chay ñawsakunaqa Jesuspa ladonman ashuyuranku. Chaymi Jesusqa chay ñawsakunata tapuran: —Qankunari, ¿noqapi confiankichishchu sanoyachinaypaqrí? nispa. Hinaqtinmi chay ñawsakunaqa contestaranku: —Arí, Señorlláy, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Saynata contestaqtinkun, Jesusqa chay ishkaynin ñawsakunapa ñawinkunata llamiykuspa niran: —Noqapi confiasqaykichisraykun sanoyachisqaykichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Chaymi chay ñawsa runakunapa ñawinqa kasqan ratolla rikuran. Hinaqtinmi Jesusqa paykunata allinta avisaspa niran: —Aman pimanpas kay sanoyachisqaymantaqa willankichishchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Paykunan ichaqa chaymanta lloqsiruspanku, chay llaqtakunapi llapallan tiyaq runakunaman willakachakuranku, paykunata Jesús sanoyachisqanmanta. ");
INSERT INTO qveNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ñawsa kasqankumanta sanoyaq ishkaynin runakuna lloqsirullaqtinkun, Jesusman pusamullarankutaq demoniopa ñak'arichisqan mana rimay atiq runata. ");
INSERT INTO qveNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Hinaqtinmi Jesusqa chay runamanta demoniota qarqoran. Chaymi chay runaqa chayraq rimayta atiran. Hinaqtinmi chaypi kaq runakunaqa anchata admirakuspa, khaynata niranku: —Saynataqa manan ni hayk'aqpas rikuranchishchu kay Israel nación llaqtapiqa, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ichaqa fariseo religionniyoq runakunañataqmi khaynata niranku: —Kay runaqa demoniokunataqa qarqon demoniokunapa jefen payman atiyninta qoqtinmi, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesusqa llapallan llaqtakunaman, hinallataq uchuy llaqtachakunamanmi riran. Hinaspan Diosmanta yachachina sinagoga wasikunapi willakuran, Diosmanta allin willakuykunata hinallataq Diospa gobiernananmantapas. Saynallataqmi onqosqa runakunatapas, hinallataq runakunapa cuerponpi nanayninkutapas sanoyachiran. ");
INSERT INTO qveNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jesusqa ashka runakunata rikuspanmi khuyapayaran. Saynataqa khuyapayaran mana michiqniyoq ovejakuna hina, wikch'usqa hinallataq ch'eqesqa kasqankuraykun. ");
INSERT INTO qveNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Hinaspan Jesusqa discipulonkunata niran: —(Diospi mana creeq runakunan ashka kanku. Ichaqa Diosmanta willakuq runakunan chikallan kanku.) Chakraqa ñan listollaña kashan cosechanapaq. Ichaqa cosechaqkunan chikachallan kashanku. ");
INSERT INTO qveNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Chayraykuyá qankunaqa Diosman orakuychis, yachachiq runakunata mandamunanpaq, saynapi llapallan runakunaman Diosmanta allin willakuykunata willamunankupaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Chaymantan Jesusqa waqyaran chunka ishkayniyoq discipulonkunata. Hinaspan sapankamaman atiyninta qoran, runakunamanta demoniokunata qarqonankupaq, hinallataq runakunapi imaymana onqoykunatapas, nanaykunatapas sanoyachinankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Chay chunka ishkayniyoq akllasqan discipulonkunatan suticharanku apostolwan. Paykunan karanku: Simón, huknin sutinmi karan Pedro; Simón Pedropa wawqen Andrés; Zebedeopa wawankuna Jacobowan hinallataq Juanpiwan ima; ");
INSERT INTO qveNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","saynallataq Felipe; Bartolomé; Tomás; impuesto cobraq Mateo; Alfeopa wawan Jacobo; Lebeo, paytan suticharanku Tadeowan; ");
INSERT INTO qveNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","cananista partidomanta kaq Simón; hinallataq Judas Iscariote ima. Kay Judas Iscarioten Jesusta traicionaspa enemigonkunaman entregaran. ");
INSERT INTO qveNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesusqa paymanta willakuq rinankupaqmi, chay chunka ishkayniyoq akllasqan apostolninkunata comisionaspa, kamachiran khaynata: —Aman rinkichishchu huk law nacionniyoq runakunamanqa. Hinaspapas aman haykunkichishchu Samaria provincia lawpi tiyaq runakunamanpas. ");
INSERT INTO qveNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Aswanmi rinkichis Israel nacionniyoq runakunallaman. Paykunan chinkasqa ovejakuna hina kashanku. ");
INSERT INTO qveNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Paykunaman rispaykichis willamuychis khaynata: “Diosmi sumaq gobiernayta ña qallarishanña (runakuna paypi creeqtinku)”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Saynallataqyá qankunaqa onqosqakunata, hinallataq lepra onqoywan ñak'ariq runakunatapas sanoyachimuychis. Wañusqakunatapas kawsarichimuychis. Hinallataq demoniokunatapas runakunamanta qarqomuychis. Qankunamanmi kay atiyta gratislla qoshaykichis; saynaqa qankunapas gratisllayá sanoyachimuychis. ");
INSERT INTO qveNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Hinaspapas rispaykichisqa aman apankichishchu ima qolqetapas, ");
INSERT INTO qveNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","nitaq qoqawtapas, nitaq bastontapas, nitaq husut'atapas, nitaq p'achatapas cambiakunaykichispaqqa. Yachasqanchisman hinaqa, llapallan llank'apakuq runakunapas, llank'apakusqankumanta merecenkun pagon chashkikapuytaqa. ");
INSERT INTO qveNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ichaqa huk hatun llaqtaman otaq huk taksa llaqtachamanpas chayaruspaykichisqa, confianapaq hina allin respetasqa runata mashkaychis. Hinaspa chay runapa wasinpi samapakuychis asta huk law llaqtaman rinaykichiskama. ");
INSERT INTO qveNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Chay runapa wasiman haykuspaqa, khaynatayá rimayukuychis: “Diospa hawkayaynin qankunawan kachun”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Sichus chay wasipi kaq runakuna allinta chashkisunkichis chayqa, Diosmi paykunataqa hawkayaypi kawsachinqa. Ichaqa sichus mana allintachu chashkisunkichis chayqa, chay nisqaykichis hawkayayqa, qankunallamanmi kutinpunqa. ");
INSERT INTO qveNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Hinallataq sichus mayqen llaqtapipas, otaq mayqen wasipipas mana chashkisunkichishchu, nitaq qankunapa rimasqaykichistapas uyariyta munanqakuchu chayqa, chay llaqtamanta otaq chay wasimanta lloqsispayá husut'aykichispi allpatapas thaptirikusparaq huk lawman ripuychis. ");
INSERT INTO qveNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Cheqaqtapunin niykichis, chay llaqtakunaqa, juicio p'unchaw chayamuqtinmi, Sodoma llaqtamantapas hinallataq Gomorra llaqtamantapas aswan mastaraq castigasqa kanqaku, nispa. Nota: Sodoma llaqtapi hinallataq Gomorra llaqtapi tiyaq runakunaqa nishu huchasapa runakunan karanku. Génesis 18. ");
INSERT INTO qveNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jesusqa nillarantaqmi khaynata: —Noqan qankunataqa mandashaykichis huchasapa runakunapa kasqanman, imaynan ovejakunatapas kachayushayman yarqasqa atoqkunapa kasqanman hinata. Chayraykuyá qankunaqa chay huchasapa runakuna ukhupiqa, mach'aqway hina yachaysapa hinallataq paloma hina sumaq llamp'u sonqoyoq kaychis. ");
INSERT INTO qveNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Saynaqa cuidakuychisyá chay runakunamanta. Paykunaqa juezkunamanmi apasunkichis; hinallataq Diosmanta yachachina sinagoga wasikunapipas castigasunkichis; ");
INSERT INTO qveNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Hinaspapas noqapi creesqaykichisraykun, autoridadkunaman hinallataq reykunamanpas entregasunkichis. Saynapin qankunaqa paykunaman hinallataq huk law nacionniyoq runakunamanpas noqamanta willamunkichis. ");
INSERT INTO qveNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Chay autoridadkunaman apasuqtiykichisqa, amayá qankunaqa preocupakunkichishchu: “Ima nispan otaq imaynata nispan defiendekusaq”, nispaqa. Ichaqa Diosmi chay ratopiqa yachayta qosunkichis imaynata rimanaykichispaqpas. ");
INSERT INTO qveNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Saynapin qankunaqa mana kikillaykichismantachu chaypiqa rimankichis; aswanqa Diospa Santo Espiritunmi qankunataqa yanapasunkichis, imaynata rimanaykichispaqpas. ");
INSERT INTO qveNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Saynallataqmi chay tiempopiqa, wawqentin kashaspankupas wañuyman entreganakunqaku. Papanpas wawantan wañunanpaq entreganqa. Wawanpas tayta mamanta traicionaspan wañuchinqa. ");
INSERT INTO qveNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Hinaspapas noqapi creesqaykichisraykun, llapallan runakunaqa qankunata cheqnisunkichis. Ichaqa pipas noqapi wañunankama creeqmi, salvasqa kanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Saynallataq, sichus kay llaqtapi runakuna qankunata wañuchisunaykichispaq qatikachasunkichis chayqa, huk law llaqtamanyá ayqekuychis. Noqaqa cheqaqtapunin niykichis, qankuna kay Israel nación llaqtakunapi puriyta manaraq tukushaqtiykichismi, noqa Diosmanta Hamuq Runaqa kutimusaq. ");
INSERT INTO qveNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Huk preparakuq discipuloqa, yachachiqnin maestronmantaqa manan aswan más importanteqa kanmanchu. Hinallataqmi huk sirviente runapas, patronninmantaqa manan aswan más importanteqa kanmanchu. ");
INSERT INTO qveNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Aswanmi chay discipuloqa procuranan chay yachachiqnin maestron hina kayta. Saynallataq chay sirviente runapas procuranan chay patronnin hina kayta. Ichaqa imaynan noqatapas kay runakunaqa demoniokunapa jefen Beelzebú nispa k'amiwaranku. Saynallatataqmi qankunatapas, imaynataraqchá k'amisunkichis, noqapi creesqaykichisrayku, nispa. Nota: Patronpas hinallataq yachachikuq maestropas Jesusmi. Discipulowan hinallataq sirvientewanñataqmi Jesucristopi creeqkuna kanchis. ");
INSERT INTO qveNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jesusqa nillarantaqmi khaynata: —Qankunaqa ama manchakuychishchu runakunataqa. Runakunapa tukuy ima sonqollanpi piensasqanpas, hinallataq pakallapi tukuy ima ruwasqanpas yachasqan kanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Qankunaman mana pipa uyarisqallan ima willasqaytapas, llapallan runakunaman alayrita willamuychis. Saynallataq secretollapi qankunaman ima willasqaytapas, llapallan runakunaman willamuychis. ");
INSERT INTO qveNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Hinaspapas qankunaqa, runakuna wañuchiyta munasuqtiykichisqa, amayá manchakunkichishchu. Paykunaqa cuerpollaykichistan wañuchiyta atinkuman. Ichaqa manan almaykichistaqa wañuchiytaqa atinkumanchu. Aswanqa Dios Taytaykichistayá qankunaqa manchakuychis. Payllan cuerpoykichistapas hinallataq almaykichistapas wiñaypaq ñak'ariy infiernoman wikch'uyunanpaq ancha atiyniyoqqa. ");
INSERT INTO qveNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Qankunaqa yachankichismi ishkay pichinkuchakunata huk pisi qolqechallaman vendesqankutaqa. Ichaqa chay pichinkuchakunapas manan wañunkumanchu Diospa mana yachasqallanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Diosqa yachanmi hayk'a chukchayoq kasqaykichistapas. ");
INSERT INTO qveNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Qankunaqa chay pichinkuchakunamantapas aswan mastaraqmi valenkichis. Chayraykun qankunaqa mana ni imamantapas manchakunaykichishchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Jesusqa nillarantaqmi khaynata: —Sichus pi runapas runakunapa ñawpaqninpi noqata mana negawanqachu chayqa, noqapas hanaq pachapi Dios Taytaypa ñawpaqninpiqa noqapi creeq runataqa manan negasaqchu. ");
INSERT INTO qveNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ichaqa sichus pipas runakunapa ñawpaqninpi noqata negawanqa chayqa, noqapas hanaq pachapi Dios Taytaypa ñawpaqninpiqa negallasaqtaqmi chay runataqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Jesusqa nillarantaqmi khaynata: —Noqaqa kay pachamanqa hamurani manan hawkalla kawsanaykichispaqchu. Aswanmi noqaqa hamurani, qankuna noqapi creeqtiykichis, runakuna qankunapa contraykichispi kanankupaqmi. ");
INSERT INTO qveNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Chaymi qari wawanpas papanpa contranpi kanqa. Warmi ususinpas mamitanpa contranpi kanqa. Saynallataqmi qachunninpas suegranpa contranpi kanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Chaymi niykichis, cheqnisuqniykichis enemigoykichisqa, qankunapa familiallaykichismantan kanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ichaqa pipas papanta otaq mamitanta noqamanta aswan masta munakunqa chayqa, manan discipuloyqa kanmanchu. Hinallataq pipas qari wawanta otaq ususinta noqamanta aswan masta munakunqa chayqa, manallataqmi noqapa discipuloyqa kanmanchu. ");
INSERT INTO qveNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Pipas noqapa discipuloy kayta munaspaqa listo kanan sasachakuykuna chayamuqtin ñak'arinanpaq. Hinaspan sapa p'unchaw noqapi iñinan. Sichus noqapi mana iñinqachu chayqa, manan discipuloyqa kanmanchu. ");
INSERT INTO qveNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Pipas kay pachapi payllapaq kawsay munaqqa, wiñaypaqmi wañunqa. Aswanqa pipas noqapi creesqanrayku wañuyta tariqmi, wiña-wiñaypaq kawsanqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jesusqa nillarantaqmi khaynata: —Qankunata wasinpi chashkiq runaqa, noqatan chashkiwashan. Saynallataqmi noqata chashkiwaq runapas hanaq pachamanta mandamuwaqniy Dios Taytaytapas chashkillashantaq. ");
INSERT INTO qveNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Pipas Diosmanta willakuq profetata wasinpi samachinqa chayqa, Diosmi chay samachiq runamanpas qonqa, chay profetapa chashkinan hina premiota. Saynallataqmi pipas Diospi creeq justo runata wasinpi samachinqa chayqa, Diosmi paymanpas qonqa, chay justo runapa chashkinan hina premiota. ");
INSERT INTO qveNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Chaymi cheqaqtapuni niykichis, sichus pipas huk tazapi chiri unullatapas haywaykunqa, noqapi creeq huk humilde runaman chayqa, Diosmi paymanpas premionta qopunqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesusqa chunka ishkayniyoq discipulonkunaman yachachiyta tukuruspanmi, huk llaqtakunaman riran. Chay llaqtakunapin Diosmanta allin willakuykunata runakunaman willaspa yachachiran. ");
INSERT INTO qveNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Hinaqtinmi Bautizaq Juanqa carcelpi kashaspan, Jesuspa tukuy ima ruwasqankunamanta uyariran. Chayraykun ishkay discipulonkunata Jesusman mandaran, ");
INSERT INTO qveNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","khaynata tapumunankupaq: —¿Qanchu kanki Diosmanta Hamuq Salvawaqniyku, icha huktachu suyasaqkurí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Hinaqtinmi Jesusqa contestaran khaynata: —Kutispaykichis Bautizaq Juanman willamuychis tukuy rikusqaykichista, hinallataq uyarisqaykichismantawan khaynata: ");
INSERT INTO qveNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","“Ñawsakunan rikun; mana puriqkunan purin; lepra onqoywan ñak'ariqkunan sanoyan; mana uyariqkunan uyarin; wañusqakunan kawsarin. Saynallataqmi wakcha runakunapas Diosmanta allin willakuyta uyarishanku, salvasqa kanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Chaymi ancha kusisqa kanqaku noqapi allinta iñiqkunaqa”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Bautizaq Juanpa discipulonkuna pasapuqtinkun, Jesusqa yachachiyta qallariran llapallan runakunaman Bautizaq Juanmanta, khaynata: —Qankunari, ¿pi qawaqtaq rirankichis ch'inñeqtarí? ¿Wayrapa apakachasqan mana kallpayoq tiwli-tiwli soqosman rikch'akuq runatachú? ");
INSERT INTO qveNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Icha ¿allin p'achawan p'achasqa runata qawaqchu rirankichís? Yuyariychisyá, allin p'achawan p'achasqa runakunaqa, gobiernaq qapaq reykunapa hatun wasinpin tiyanku. ");
INSERT INTO qveNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Aswan qankunari, ¿pi qawaqtaq rirankichís? ¿Diosmanta willakuq profeta runata qawaqchú? Arí, Bautizaq Juanqa Diosmanta willakuq ñawpaq profeta runakunamantapas aswan más importanteraqmi karan. ");
INSERT INTO qveNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Bautizaq Juanmantan Dios Taytayqa niwaranña khaynata: “Noqan mandamusaq willakuqniyta, qanpa ñawpaqniykita rispa willamunanpaq. Paymi ñanta allichaq hina, runakunata allinta yachachinqa, chayamuqtiyki sumaqta chashkisunaykikupaq”, nispa Malaquías 3.1. ");
INSERT INTO qveNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Cheqaqtapunin niykichis, kay pachapiqa manan ni pipas naceranchu Bautizaq Juanmanta aswan más importante runaqa. Ichaqa noqapi iñiqmi, humilde runalla kashaspanpas, hanaq pacha Diospa gobiernasqan glorianpiqa, Bautizaq Juanmantapas aswan más importante kanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Saynallataqmi Bautizaq Juanpa predicasqan p'unchawmanta asta kunan p'unchawkamapas, ashka runakunaqa willakushanku Diosmanta allin willakuykunata, hinallataq Diospa gobiernananmantapas. Saynata willakuspankun creyentekunaqa ancha sasachakuykunata pasashanku. Ichaqa Diosmanta willakuqkunata chinkachiyta munashaqtinkupas, Diosmanta willakuqkunaqa astawanraqmi mirashanku. ");
INSERT INTO qveNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ichaqa Diosmanta willakuq llapallan profetakunapas, hinallataq leykunata yachachiq runakunapas, Bautizaq Juanpa hamusqan p'unchawkamallan willakuranku. ");
INSERT INTO qveNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Chaymi niykichis, sichus qankuna Moisespa escribisqan leykunapi hinallataq profetakunapa yachachisqanpi creenkichis chayqa, Bautizaq Juanmi chay suyasqaykichis profeta Eliasqa. ");
INSERT INTO qveNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Sichus cheqaqtapuni ninriyoq kankichis chayqa, allintayá uyariychis kay nisqaykunataqa. ");
INSERT INTO qveNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Pimantaq kay tiempopi kawsaq runakunatari comparachiyman? Paykunaqa rikch'akunku plazakunapi tiyaruspanku pukllaspa waqyanakuq warmakunamanmi. ");
INSERT INTO qveNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Paykunan khaynata ninakunku: “Quenata tocashaqtiykupas qankunaqa manan tusunkichishchu. Llakisqa takikunata takishaqtiykupas, qankunaqa manan waqankichishchu”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ichaqa Bautizaq Juan hamuspanmi mana nishutachu mikhuran, nitaq vinotapas tomaranchu. Chaykunata rikuspaykichismi qankunaqa khaynata nirankichis: “Waq runaqa demoniopa kamachisqanmi”, nispaykichis. ");
INSERT INTO qveNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Noqa Diosmanta Hamuq Runa hamuspaytaqmi ichaqa mikhuni, hinallataq vinotapas tomani. Chayta rikuspaykichishñataqmi qankunaqa noqamanta rimankichis khaynata: “Payqa mikhuysapan, vinotapas tomakuspan mach'akun. Hinaspapas llapallan impuesto cobraqkunapa, hinallataq huchasapa runakunapapas amigonmi”, nispaykichis. Ichaqa yachaychisyá Diosta kasukuq runaqa imapas ruwasqanpin reqsichikun, nispa. Nota: Jesucristopa enemigon runakunaqa manan contentochu karanku, Bautizaq Juanpa ruwasqanwanpas nitaq Señorninchis Jesucristopa ruwasqanwanpas. Chaymi paykunaqa saynata rimaranku Bautizaq Juanpa contranpi hinallataq Jesucristopa contranpipas. ");
INSERT INTO qveNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jesusqa llaqtakunapin ashka milagrokunata ruwaran. Ichaqa chay llaqtakunapi tiyaq runakunaqa milagrokuna ruwasqanta rikushaspankupas, huchankumantaqa manan wanakurankuchu, nitaqmi Diostapas kasukuytaqa munarankuchu. Chaymi Jesusqa chay llaqtakunapi tiyaq runakunata q'aqchaspa khaynata niran: ");
INSERT INTO qveNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Ay, imaynaraq kankichis Corazín llaqtapi tiyaq runakuna! ¡Ay, imaynaraq kankichis Betsaida llaqtapi tiyaq runakuna! Qankunapa llaqtaykichispin ashka milagrokunata ruwarani. Sichus Tiro llaqtapi hinallataq Sidón llaqtapipas kay milagrokunata ruwayman karan chayqa, maypacharaqchá paykunaqa qashqa p'achawan p'achakuspanku, hinallataq ushpakunapi tiyaspanku ima, huchankunamanta wanakuspanku, Diosman kutirikunkuman karan. ");
INSERT INTO qveNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Chayraykun juicio p'unchawpiqa Tiro llaqtapi, hinallataq Sidón llaqtapi tiyaq runakunamantapas, aswan mastaraqmi qankunaqa Corazín llaqtapi tiyaq runakuna, hinallataq Betsaida llaqtapi tiyaq runakunapas castigasqa kankichis, Diosman mana kutirikusqaykichisrayku. ");
INSERT INTO qveNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Saynallataq Capernaúm llaqtapi tiyaq runakuna uyariwaychis allinta: ¡Manan qankunapas hanaq pachamanqa haykunkichishchu! ¡Aswanmi qankunaqa nina rawray infiernopa ukhu-ukhunmanraq wikch'uyusqa kankichis! Sichus Sodoma llaqtapi kay ruwasqay milagrokunata ruwayman karan chayqa, chay Sodoma llaqtaqa kunankamapas kashanmanraqmi karan. ");
INSERT INTO qveNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Chaymi niykichis, qankunapas huchaykichismanta mana wanakunkichishchu chayqa, juicio p'unchaw chayamuqtinmi Sodoma llaqtapi tiyaq runakunamantapas aswan mastaraq castigasqa kankichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Chaykunata rimayta tukuruspanmi Jesusqa Dios Taytanman orakuspa, khaynata alabaran: —Dios Taytalláy, qantan alabayki, qanmi kanki hanaq pachapipas, hinallataq kay pachapipas kamachiqqa. Tukuy ruwasqaykikunatan yachaq tukuq runakunamanqa mana rikuchirankichu. Aswanmi pisi yachayniyoq wawa hina kaq runakunallaman kaykunataqa yachanankupaq rikuchiranki. Sayna ruwasqaykimantan graciasta qoyki. ");
INSERT INTO qveNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Arí, Dios Taytalláy, sayna kanantan qanqa munaranki, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jesusqa nillarantaqmi chaypi kaq runakunamanpas khaynata: —Dios Taytaymi tukuy imakunata noqaman entregawaran. Hinaspapas noqataqa manan pipas reqsiwanchu, aswanqa Taytallaymi. Manataqmi Dios Taytaytaqa ni pipas reqsinchu. Aswanqa noqa wawallanmi paytaqa reqsini. Noqan runakunatapas akllani, paykunapas Dios Taytayta noqa hina reqsinankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Saynaqa pisipasqa kawsaq runakuna, hinallataq llasa q'epiwan ñak'ariq runakuna, hamuychis noqaman. Qankuna noqapi creeqtiykichismi, noqaqa qankunata samachisqaykichis. ");
INSERT INTO qveNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Noqawan kushka puriychis; hinaspa noqamanta yachaychis. Noqaqa sumaq llamp'u sonqoyoq, hinallataq pacienciayoq humilde runan kani. Chaymi noqapi creespaykichis qankunaqa samayta tarinkichis. ");
INSERT INTO qveNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Noqapa yachachisqaykunaqa mana huk llasaq yugo hinachu, aswanqa samp'allan. Chayraykun yachachisqaykunaqa manan sasachu kasukunaykichispaqqa, nitaqmi llasa q'epi hinapashchu apayta mana atinaykichispaqqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Huk samana p'unchawpin Jesusqa discipulonkunapiwan huk trigo chakraq patanta pasasharanku. Chaymi discipulonkunaqa yarqaymanta kaspanku, trigota pallaspa mikhuyta qallariranku. ");
INSERT INTO qveNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Chay ruwasqankuta rikuspan, fariseo religionniyoq runakunaqa, khaynata niranku: —¡Qawariy discipuloykikunapa ruwasqankuta! ¡Moisespa escribisqan leyman hinaqa, samana p'unchawpiqa manan saynataqa ruwanankuchu! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesusñataqmi contestaspa niran: —¿Manachu qankuna Bibliapi leerankichis, rey Davidqa puriqmasinkunapiwan yarqachikuspa imatachus ruwasqanmanta? ");
INSERT INTO qveNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Rey Davidqa Diosta adorana wasiman haykuspanmi, Diosman ofrecesqa kaq t'antakunata puriqmasinkunapiwan kushka mikhuranku. Chay t'antakunaqa, manan permitisqachu karan, rey Davidpas hinallataq puriqmasinkunapas mikhunankupaqqa. Aswanqa Israel nación llaqtapi sacerdotekunapa mikhunallanpaqmi permitisqa karan. ");
INSERT INTO qveNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Manachu qankunari Moisespa escribisqan leykunata leerankichís? ¿Manachu qankunari yachankichis, sacerdotekunapas samana p'unchawpi Dios yupaychana templopi llank'asqankuta? Paykunataqa samana p'unchawpi llank'ashaqtinkupas manan ni pipas acusankuchu, “qankunaqa huchallikushankichismi”, nispaqa. ");
INSERT INTO qveNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ichaqa kunanmi niykichis, Dios yupaychana templo wasimantapas aswan más importante runan kaypiqa kashan. ");
INSERT INTO qveNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Qankunaqa manan entiendenkichishchu ima ninantas Diospa nisqantaqa. Payqa niranmi khaynata: “Animalkunata wañuchispa sacrificio ofrendata q'oshñichimuwanaykichistaqa manan munanichu. Aswanqa runamasiykichista khuyapayaq kanaykichistan munani”, nispa Oseas 6.6. Chayta entiendespaykichisqa, manachá yanqapuniqa kay mana culpayoq runakunataqa ni imamantapas acusawaqchishchu. ");
INSERT INTO qveNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Chayraykun niykichis, noqa Diosmanta Hamuq Runaqa samana p'unchawpapas dueñonmi kani. Chaymi kamachini ima ruwanankupaqpas, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Chaymanta rishaspanmi Jesusqa Diosmanta yachachina sinagoga wasiman haykuran. ");
INSERT INTO qveNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Chaypin huk runa mana valeq makiyoq kashasqa. Hinaqtinmi fariseo religionniyoq runakunaqa Jesusta acusayta munaspanku, khaynata tapuranku: —¿Moisespa escribisqan leypiri, permitisqachu kashan samana p'unchawpi onqosqa runata sanoyachinapaq? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Chaymi Jesusqa niran: —¿Mayqenniykichistaq samana p'unchawpi ovejaykichis huk t'oqoman urmayuqtin mana orqowaqchishchú? ");
INSERT INTO qveNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¡Runaqa ovejamantapas aswan más valorniyoqmi! Chaymi samana p'unchawpipas Diosqa permitiwanchis allin ruwaykunata ruwananchispaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Hinaqtinmi Jesusqa chay mana valeq makiyoq runata niran: —Chay mana valeq makiykita chutariy, nispa. Chaymi makinta chutariqtin hinalla, chay mana valeq makinqa kasqan ratolla sanoyaran; hinaspan huknin kaq sano makin hina karan. ");
INSERT INTO qveNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Hinaqtinmi chay sinagoga wasimanta lloqsimuspanku, fariseo religionniyoq runakunaqa Jesusta wañuchinankupaq parlanakuranku khaynata: “Kay Jesuspa contranpiri, ¿imatataq ruwarusunchís?” nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesusqa fariseo religionniyoq runakunapa piensasqankuta yachaspanmi, chay sinagoga wasimanta ripuran. Hinaqtinmi paypa qepanta ashka runakunaqa qatikuranku. Paykunamantan Jesusqa llapallan onqosqa runakunata sanoyachiran. ");
INSERT INTO qveNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Hinaspan chay runakunata Jesusqa kamachispa niran: —Aman pimanpas willankichishchu pis noqa kasqaytaqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Saynataqa niran Diosmanta willakuq profeta Isaiaspa ñawpaqtaraq escribisqan cumplikunanpaqmi. Paymanmi Diosqa khaynata niran: ");
INSERT INTO qveNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Qawariychis, kaypin kashan serviwananpaq akllakusqay runaqa. Paytan noqa anchata khuyakuni. Paywanmi anchata kusikuni. Paymanmi Santo Espirituywan hunt'ayusaq. Chaymi payqa ashka nacionniyoq runakunaman juicio p'unchaw chayamunanmanta willamunqa, paykunapas Diospi creenankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Payqa manan piwanpas discutinakunqachu, nitaqmi piwanpas qaparinakunqachu. Payqa manan waqyakunqachu. Chaymi callekunapipas mana uyarinqakuchu. ");
INSERT INTO qveNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Payqa manan dañotaqa astawanqa ruwanqachu k'irisqaña kaq runakunataqa. Nitaqmi wañuchinqachu wañuypa patallanpiña kaq runakunatapas. (Aswanmi mana kallpayoq runakunatapas kallpanchanqa). Hinallataqmi mana allin ruwaq runakunata vencenqa. Hinaspan cheqaq justiciata ruwanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Chaymi llapallan nación llaqtakunapi tiyaq runakunaqa paypi confianqaku”, nispa Isaías 42.1-4. ");
INSERT INTO qveNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Jesusmanmi apamuranku demoniopa ñak'arichisqan huk mana rimaq ñawsa runata. Hinaqtinmi Jesusqa chay runata sanoyachiran. Chaymi chay runaqa kasqan ratolla rimariran hinallataq rikuran ima. ");
INSERT INTO qveNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Hinaqtinmi llapallan chaypi kaq runakunaqa admirasqallaña karanku. Hinaspan Jesusmanta tapunakuranku khaynata: —Icha ¿paychu kanmanpas noqanchista salvawananchispaq Diosmanta Hamuq Runaqa? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Hinaqtinmi wakin fariseo religionniyoq runakunaqa chaykunata uyarispanku, khaynata niranku: —Kay Jesusqa demoniokunapa jefen Beelzebú sutiyoq diablopa atiyninwanmi runakunamanta demoniokunataqa qarqon, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Chaymi Jesusqa runakunapa piensasqanta yachaspa, paykunata niran: —Huk nación llaqtapi tiyaq runakuna contranakuspa, enemigontin hina kawsanqaku chayqa, chinkapunqakun. Saynallataq huk llaqtapi tiyaq runakunapas otaq huk wasipi tiyaq runakunapas contranakuspa, peleaspalla tiyanqaku chayqa, chinkapunqakun. ");
INSERT INTO qveNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Hinallataqmi, sichus demoniokunapas paykunapura peleaspa qarqonakunkuman, hinallataq rakinakunkuman chayri, ¿imaynataq chay diablori kaq atiynillayoq kanmanrí? ");
INSERT INTO qveNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Sichus noqa Beelzebupa atiyninwan demoniokunata qarqoni chayri, ¿qankunapa discipuloykichismanri, pitaq atiyta qon runakunamanta demoniokunata qarqonanpaqrí? Sichus qankuna kunan contestawankichis: “Diosmi chay atiyta qowanku”, nispa, hinaqtinqa llapallan runakunan yachanqa qankunaqa pantaypi kasqaykichista. ");
INSERT INTO qveNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Noqaqa Diospa Santo Espiritunpa atiyninwanmi demoniokunataqa runakunamanta qarqoni. Chaymi niykichis, cheqaqtapunin Diospa sumaq gobiernanan p'unchawqa ña qankunamanqa chayaramunña. ");
INSERT INTO qveNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Kunan nisqaykichis, huk kallpasapa runapa wasinmanta imantapas qechuyta munaspari, ¿imatataq ruwanan chay kallpasapa runatarí? Primertan chay kallpasapa runataqa vencespa alli-allinta chaqnanan. Saynata chaqnaruspañan chay runapa wasinpi imankunatapas qechunqa. Nota: Chay kallpasapa runaqa diablon. Ichaqa chay kallpasapa runata chaqnaqñataqmi Jesucristo. Señorninchis Jesucristoqa diablomanta aswan más kallpayoqmi. Chaymi payqa diablota chaqnaspa diablopa atiyninmanta librawanchis. ");
INSERT INTO qveNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Sichus pipas mana acuerdopichu noqawan kashan chayqa, noqapa contraypin kashan. Hinallataqmi sichus pipas mana yanapawanqachu Dios Taytaypi runakuna creenankupaq chayqa, runakunatan Diosmanta astawanraq karunchashan. ");
INSERT INTO qveNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Chayraykun niykichis, Diosqa runakunapa tukuy huchankunatapas hinallataq tukuy mana allin rimasqankutapas perdonanqan. Ichaqa Santo Espiritupa contranpi ofendespa rimaq runakunataqa manan perdonanqachu. ");
INSERT INTO qveNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Noqa Diosmanta Hamuq Runapa contraypi rimaqkunatapas Diosqa perdonanqan. Ichaqa Santo Espiritupa contranpi ofendespa rimaqkunataqa manan perdonanqachu, ni kunan tiempopipas nitaq qepa tiempopipas. ");
INSERT INTO qveNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jesusqa nillarantaqmi: —Allin sach'aqa allintan rurun. Ichaqa mana allin sach'añataqmi mana allintachu rurun. Chaymi sach'ataqa rurusqanpi reqsina. (Saynallataqmi runakunawanpas pasan; allin runachus icha mana allin runachus kasqanta yachanapaqqa, imapas ruwasqanpin fijakuna). ");
INSERT INTO qveNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Mach'aqwaypa miraynin hina runakuna! ¿Ima uyaykichiswantaq qankunari allin kaqkunata rimawaqchis, mana allin ruwaq runakuna kashaspaykichisrí? Runakunaqa sonqonku ukhupi imapas hunt'a kasqanman hinan rimanku. ");
INSERT INTO qveNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Runapa sonqonpi allin kaqkuna kaqtinqa, allin kaqkunatan chay runaqa rimanpas hinallataq ruwanpas. Ichaqa runapa sonqonpi mana allinkuna kaqtinqa, mana allinkunallatan chay runaqa rimanpas hinallataq ruwanpas. ");
INSERT INTO qveNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Chaymi noqaqa niykichis, juicio p'unchawpiqa llapallaykichismi Diosmanqa cuentata qonkichis, tukuy mana allin palabrakuna rimasqaykichismantaqa. ");
INSERT INTO qveNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Chayraykun qankunataqa tukuy rimasqaykichismanta Diosqa juzgasunkichis. Sichus allin kaqkunata rimarankichis chayqa, salvasqan kankichis. Sichus mana allinkunata rimarankichis chayqa, castigasqan kankichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Wakin fariseo religionniyoq runakunañataqmi, leykunata yachachiq runakunapiwan Jesusta niranku: —Yachachikuq, milagro ruwanaykitan munayku, saynapi Diosmanta Hamuq Runa kasqaykita yachanaykupaq, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Hinaqtinmi Jesusqa khaynata contestaran: —Huchasapa runakuna, qankunaqa Diospi mana confiaspaykichismi, huk milagro ruwanaytaraq munashankichis noqapi creenaykichispaq. Ichaqa Diosqa manan ni ima milagrotapas rikuchisunkichishchu. Aswanqa Diosmanta willakuq profeta Jonasta imachus pasaran, saynallatataqmi qankuna ukhupipas noqawan pasasqanta rikunkichis. ");
INSERT INTO qveNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Imaynan Jonaspas huk hatun challwapa wiksan ukhupi kinsa p'unchaw hinallataq kinsa tuta ima karan. Saynallataqmi noqa Diosmanta Hamuq Runapas, allpa ukhupi p'ampasqa kasaq kinsa p'unchaw hinallataq kinsa tuta ima. ");
INSERT INTO qveNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nínive llaqtapi tiyaq runakunan, Diosmanta willakuq profeta Jonás willakuqtin, huchankuta saqespanku Diosman kutirikuranku. Chaymi juicio p'unchaw chayamuqtinqa, chay Nínive llaqtapi tiyaq runakunapas kawsarimuspanku, qankuna fariseo religionniyoq runakunapa contraykichispi rimanqaku, Dios castigasunaykichispaq. Saynataqa rimanqaku, qankunaman kay allin willakuykunata willashaqtiypas, huchaykichismanta mana wanakusqaykichisraykun. Noqaqa Jonasmantapas aswan más importanten kaypiqa kashani. ");
INSERT INTO qveNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Saynallataqmi Sabá nacionniyoq reinapas juicio p'unchawpiqa kawsarimuspanmi, qankunapa contraykichispi rimanqa Dios castigasunaykichispaq. Israel nación llaqtapi rey Salomón gobiernashaqtinmi, chay reinaqa karu llaqtamanta hamuran, rey Salomonpa yachayninta uyarinanpaq. Qankunataqmi ichaqa noqapa yachachisqayta mana ni uyariytapas munankichishchu, rey Salomonmantapas aswan más yachayniyoq kashaqtiypas, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jesusqa nillarantaqmi: —Runamanta huk demonio lloqsispaqa, ch'inñeq desierto ch'aki lugarkunapin purin, samananpaq huk lugarta mashkaspa. Manaña tarispanñataqmi ");
INSERT INTO qveNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","khaynata nin: “Aswanyá kutipusaq maymantachus lloqsimurani chay wasiyman”, nispa. Kutispataq chay runapa sonqonta tarin sumaq allichasqata, imaynan huk illaq wasipas sumaq pichasqa kashanman hinata. ");
INSERT INTO qveNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Saynata tarispanmi, chay demonioqa kutispa mashkamun paymanta aswan más millay qanchis demoniokunata. Hinaspan chay demoniokunata pusayukuspa kutimun, chay runapa sonqonman haykuspa, chaypi tiyanankupaq. Chaymi chay runapa vidanqa ñawpaq vidanmantapas aswan más millaymanraq tukupun. Saynallataqmi kay tiempopi kawsaq runakunawanpas pasanqa, sichus paykuna huchankumanta mana wanakunqakuchu chayqa, nispa. Nota: Chay runapa “illaq sonqonqa” kasharan, chaypi Santo Espíritu mana tiyasqanraykun. ");
INSERT INTO qveNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Chaypi kaq runakunaman Jesús yachachillashaqtinraqmi, paypa wawqenkuna mamitanpiwan ima chayamuranku. Paykunan Jesuswan parlayta munaspanku, hawallapi suyaranku. ");
INSERT INTO qveNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Hinaqtinmi huk runaqa Jesusman willaran: —Mamitaykin wawqeykikunapiwan hawapi kashanku. Paykunan qanwan parlayta munashanku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Hinaqtinmi Jesusqa willaqnin runata niran: —¿Pitaq mamitayrí? ¿Pikunataq wawqeykunarí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Saynata niruspanmi, Jesusqa discipulonkunata makinwan señalaspa, chay runata niran: —Paykunan mamitaypas wawqeykunapas. ");
INSERT INTO qveNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Pipas hanaq pachapi Dios Taytaypa munayninta ruwaqmi, wawqeypas, panaypas, hinallataq mamitaypas, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Chay p'unchawmi Jesusqa chay wasipi kasqanmanta lloqsiruspa, Galilea laguna qochapa patanman riran. Hinaspanmi chaypi tiyayuran runakunaman yachachinanpaq. ");
INSERT INTO qveNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Hinaqtinmi chayman ashkallaña runakuna hamuranku Jesuspa yachachisqanta uyarinankupaq. Chaymi Jesusqa laguna qochapi huk boteman wicharuspa tiyayuran. Hinaspan chay bote hawamanta yachachimuran, laguna qochapa patanpi runakuna kaqtinku. ");
INSERT INTO qveNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Chaypin Jesusqa ashka willakuykunata runakunaman willaran khaynata: —Huk runan chakranman trigo t'akaq riran. ");
INSERT INTO qveNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Chaypi t'akashaqtinmi wakin trigoqa ñan patakunaman urmaran. Hinaqtinmi pichinkukuna hamuspa alayrilla kaqtin mikhuran. ");
INSERT INTO qveNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Wakin trigoñataqmi ranra-ranraman urmaran. Chaypin chay trigo mukhuqa mana ashka allpallapi wiñamuran. ");
INSERT INTO qveNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ichaqa saphin mana ashka allpapi kaqtintaqmi, inti lloqsiramuspa ch'akichiran. ");
INSERT INTO qveNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Saynallataqmi wakin trigopas kishka-kishka ukhukunaman urmaran. Ichaqa chay kishkakuna trigomanta aswan masta wiñaspa taparuqtinmi, chay trigoqa q'elloyaspa ch'akipuran. ");
INSERT INTO qveNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ichaqa wakin trigoñataqmi allin wanu allpaman urmaran. Chaymi chay trigoqa sumaqta wiñamuran. Hinaspan wakin mukhuqa rururan pachaqta, wakintaq soqta chunkata, wakinñataq kinsa chunkata ima. ");
INSERT INTO qveNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","¡Sichus cheqaqtapuni ninriyoq kankichis chayqa, allintayá uyariychis kay nisqaykunata! nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jesuspa willakusqanta uyariruspankun, discipulonkunaqa Jesusman ashuyuspa tapuranku: —¿Imanaqtintaq runakunamanri kay ejemplokunallawan yachachinkí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Hinaqtinmi Jesusqa contestaran khaynata: —Diospa sumaq gobiernananqa pakasqa hinan kasharan. Chaytan qankunallaman clarota yachachishaykichis, (qankuna noqapi iñisqaykichisrayku). Ichaqa manan paykunamanqa clarotachu yachachini, (noqapi creeyta mana munasqankurayku). ");
INSERT INTO qveNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Pipas Diospa palabranta entiendeqmanqa, astawanraqmi Diosqa entiendechinqa. Ichaqa Diospa palabranta mana entiendey munaq runakunamantan, Diospuni qechunqa pisilla yachasqankutapas. ");
INSERT INTO qveNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Chayraykun paykunamanqa yachachini kay ejemplokunallawan. Paykunaqa rikushaspankupas, manan rikunkuchu; uyarishaspankupas, manan entiendenkuchu. ");
INSERT INTO qveNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Saynapin cumplikun Diosmanta willakuq profeta Isaiaspa khayna escribisqankuna: “Kay runakunaqa uyarishaspankupas, manan entiendenqakuchu. Qawashaspankupas, manan rikunqakuchu. ");
INSERT INTO qveNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kay runakunapa sonqonqa rumiyasqan kashan. Chaymi mana entiendenkupashchu. Paykunaqa ñawinkutan ch'illminku ama rikuq tukunankupaq. Ninrinkutan tapakunku mana uyarinankupaq. Sichus paykuna rikunkuman, uyarinkuman, entiendenkuman, hinallataq noqapi creenkuman chayqa, chay millay kawsayninkumantan noqaqa perdonaspay salvayman”, nispa Isaías 6.9-10 Septuaginta. ");
INSERT INTO qveNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Qankunan ichaqa kusisqa kankichis, ñawiykichis allinta rikusqanrayku, hinallataq ninriykichispas allinta uyarisqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Chayraykun qankunataqa cheqaqtapuni niykichis, Diosmanta willakuq profetakunapas, hinallataq Diosta kasukuq justo runakunapas, qankunapa rikusqaykichistan rikuyta munaranku, hinallataq uyarisqaykichistan uyariyta munaranku. Ichaqa manan rikurankuchu paykunaqa, nitaqmi uyarirankupashchu manaraq hamushaqtiy wañusqankurayku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Jesusqa nillarantaqmi: —Qankunaqa allintayá uyariwaychis. Chay trigo t'akaymanta willasqayqa khaynata ninanmi: ");
INSERT INTO qveNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ñan patakunaman urmaq mukhuqa rikch'akun, Diospa sumaq gobiernananmanta allin willakuykunata uyarishaspa mana entiendey munaq runakunamanmi. Chaymi diabloqa hamuspa, Diospa palabran uyarisqankutapas paykunamanta qonqarachipun. ");
INSERT INTO qveNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ranra-ranraman urmaq mukhuqa rikch'akun, Diospa palabranta uyarispa kusisqallaña chashkikuq runakunamanmi. ");
INSERT INTO qveNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ichaqa trigo hina hawallapi saphiyoq kasqankuraykutaqmi, Diospi mana allin creesqanku pisi tiempollapaq duran. Paykunaqa sasachakuy tiempokuna, hinallataq qatikachasqa kanankupaq p'unchawkuna chayamuqtinmi, Diosmanta karunchakunku. ");
INSERT INTO qveNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kishka-kishka ukhuman urmaq mukhuqa rikch'akun, Diospa palabranta uyariq runakunamanmi. Ichaqa Diospa palabranta mana kasukuspankun, chay kishka-kishka ukhupi mana wiñay atiq trigo hina kanku. Hinaspan paykunaqa aswan qapaq kayta munaspanku, afanasqallaña qolqe mashkaypi purinku; hinallataq kay pachapi tukuy kusikuykunallapi kawsankupas. ");
INSERT INTO qveNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Allin wanu allpaman urmaq mukhuñataqmi ichaqa rikch'akun, Diospa palabranta uyarispa, hinallataq entiendespa, tukuy sonqonkuwan chashkikuq runakunaman. Paykunan Diospa Palabranta kasukuspa Diosta qatikunku. Chaymi paykunaqa kay allin allpaman trigo mukhu urmaq hina kanku. Hinaspan sumaqta wiñaspa rurunkupas chay trigo mukhu hina: pachaqta, wakintaq soqta chunkata, wakinñataq kinsa chunkata ima, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesusqa yachachillarantaqmi kay willakuywanpas khaynata: —Runakunata Dios gobiernayta qallarisqanqa rikch'akun allin trigo mukhuta chakranpi t'akaq runamanmi. ");
INSERT INTO qveNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ichaqa llapallanku puñushanankukaman, enemigon runaqa, chay trigo t'akasqanku chakraman hamuspa, mana allin qorapa mukhunta t'akaratamuspa pasapuran. ");
INSERT INTO qveNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Hinaqtinmi chay tarpusqan trigoqa wiñamuspa ruruyta qallariran. Saynallataqmi chay mana allin qorapas wiñamullarantaq. ");
INSERT INTO qveNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Chaymi chakrapi llank'aq runakunaqa patronninman willaq rispa, khaynata niranku: “Señor, ¿chakraykipiqa allin trigo mukhuwantaq tarpuchirankiqa? ¿Imaynanpitaq kay mana allin qorakunapas trigowan kushka wiñaramuranrí?” nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Chayta uyarispanmi patronninkuqa niran: “Enemigoymi kay mana allin qorakunataqa t'akaruran”, nispa. Chaymi chay llank'aq runakunaqa patronninkuta tapuranku: “¿Rispaykuchu chay mana allin qorakunata p'elaramusaqkú?” nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Hinaqtinmi chay patronninkuqa khaynata niran: “Ama chay mana allin qorataqa p'elamuychisraqchu. Chay qorakunaqa anchatan trigoman rikch'akunku. Chay mana allin qorakunata p'elamuspaqa, trigotawan kushkatan p'elaruwaqchis. ");
INSERT INTO qveNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Aswanqa trigo cosechana p'unchawkama hina wiñashachun. Ichaqa cosecha tiempo chayamuqtinñan allinta reqsisun trigotapas, hinallataq mana allin qorakunatapas. Chay p'unchawñan llank'aqniykunata kamachisaq khaynata: ‘Primertaqa chay mana allin qorakunata huñumuychis. Hinaspa monto-montonta wataychis k'anasqa kanankupaq. Chaymantañataq trigota eraspaykichis, trigo waqaychana wasiypi waqaychamuychis’ ”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesusmi kay huk willakuywan yachachispa nillarantaq: —Runakunata Dios gobiernayta qallarisqanqa rikch'akun huk runapa tarpusqan mostaza mukhumanmi. ");
INSERT INTO qveNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kay mostazapa mukhunqa llapallan mukhukunamantapas aswan más uchuychallan; ichaqa wiñaruspantaqmi huertapi wakin plantakunamantapas aswan más hatunkaray. Chaymi pichinkukunapas hamuspanku ramankunapi thapachakunku, nispa. Nota: Kay mostaza mukhuqa yachachiwanchis, imaynan kay mostaza mukhupas ch'ulla mukhullamanta hatunta wiñaspa ashkata rurun, saynallataqmi Diospi creeq runakunapas ch'ullallamanta ashkaman tukunku. ");
INSERT INTO qveNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesusqa huk willakuywanmi runakunaman yachachillarantaq khaynata: —Runakunata Dios gobiernayta qallarisqanqa rikch'akun chikallan levadurata huk warmi ashka harinaman churasqanwanmi. Hinaqtinmi chay levaduraqa chay masata poqochimuspan ashkaman tukuchin, nispa. Nota: Saynallataqmi Diosta kasukuq runakunapas chay levadura hina chikallan kashaspankupas, chay poqosqa masa hina ashkaman tukunqaku. ");
INSERT INTO qveNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesusqa chay ejemplokunallawanmi runakunamanqa yachachiran. Mana ejemplokunawanqa manan ni imatapas yachachiranchu. ");
INSERT INTO qveNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Sayna yachachisqanwanmi, Diosmanta willakuq ñawpaq profetapa nisqan cumplikuran. Chay profetan paymanta niran: “Runakunamanqa kay ejemplokunawanmi yachachisaq; hinaspan kay pacha unanchasqa kasqanmantapacha tukuy pakasqa kaqkunamanta paykunaman willasaq”, nispa Salmos 78.2. ");
INSERT INTO qveNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Hinaspanmi Jesusqa llapallan yachachisqan runakunata chaypi saqeruspa, huk wasiman haykuran. Chaypin discipulonkunaqa, Jesusman ashuyuspa, khaynata niranku: —Astawanyá entiendechiwayku, chakrapi trigowan kushka wiñamuq mana allin qorakunamantaqa, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Chaymi Jesusqa discipulonkunata niran: —Trigota t'akaqqa, noqa Diosmanta Hamuq Runan kani. ");
INSERT INTO qveNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Trigo chakraqa kay pachan. Trigo mukhuqa, Diospa wawan runakunan. Mana allin qorakunaqa, Diosta mana kasukuspa diablopa kamachisqanta ruwaq runakunan. ");
INSERT INTO qveNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mana allin qorapa mukhunta t'akaq runaqa, diablon. Cosechana tiempoqa, juicio p'unchawmi. Trigota rutuspa eraqkunañataqmi, Diospa angelninkuna. ");
INSERT INTO qveNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Imaynatan mana allin qorakunata saphinmanta orqospa ninapi k'ananku, saynallataqmi Diospi mana creeq runakunawanpas juicio p'unchawpiqa pasanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Hinaqtinmi noqa Diosmanta Hamuq Runaqa angelniykunata mandamusaq. Paykuna hamuspankun huchallapi kawsaq llapallan runakunata, hinallataq runamasinta huchallichiq runakunatapas, noqapi creeq runakunamanta separaspa, ");
INSERT INTO qveNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","nina rawray infiernoman wikch'uyunqaku. Chaypin anchata ñak'arispa waqanqaku, kirunkupas rach'ikyanankamaraq. ");
INSERT INTO qveNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ichaqa Diospi creespa kasukuq justo runakunañataqmi, Diospa sumaq gobiernasqan glorianpiqa inti hinaraq k'ancharinqaku. Sichus cheqaqtapuni ninriyoq kankichis chayqa, allintayá uyariychis kay nisqaykunata, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","—Runakunata Dios gobiernayta qallarisqanqa rikch'akun, chakrapi pakasqa kaq tapaw qorimanmi. Chay tapaw qorita huk runa tariruspanmi, kaqmanta taparun. Hinaspan kusikuspa, chaylla ripuspa, tukuy ima kaqninkunata venderamuspa, qolqentin kaqmanta kutimun, chay chakrata rantinanpaq. (Saynataqa ruwan, chay chakrapi tarisqan tapaw qoriwan qepakunanraykun), nispa. Nota: Chay ancha valorniyoq tapaw qoriqa rikch'akun Jesusmanmi. ");
INSERT INTO qveNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","—Saynallataqmi runakunata Dios gobiernayta qallarisqanqa rikch'akun, negociante runapa mashkasqan ancha valorniyoq alaja perlakunaman. ");
INSERT INTO qveNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Chay negociante runaqa huk allin valorniyoq alaja perlata tariruspanqa, rispanmi tukuy imaymana kaqninkunata vendemuspa kutimun, hinaspan chay ancha sumaq valorniyoq alaja perlata rantin, nispa. Nota: Kay valorniyoq alaja perlaqa yachachiwanchis, Diospa sumaq gobiernasqanpas ancha valorniyoq kasqantan. Chaymi Jesucristopi creeq runakunaqa, Diosta mashkananchis, kay pachapi tukuy imamantapas aswan mastaraq. ");
INSERT INTO qveNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","—Saynallataqmi runakunata Dios gobiernayta qallarisqanqa rikch'akun huk challwana mallaman. Chay mallata lamar qochaman wikch'uyuqtinkuqa, tukuy clase challwakunatan hap'imun. ");
INSERT INTO qveNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Challwakuna mallaman hunt'aruqtinñataqmi, challwaq runakunaqa lamar qochapa patanman mallankuta orqomunku. Chaypi tiyayuspankun, alli-allinnin challwakunallata akllaspanku canastankuman churanku. Ichaqa mana valeq challwakunatañataqmi wikapanku. ");
INSERT INTO qveNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Saynallataqmi juicio p'unchaw chayamuqtinpas kanqa. Chay p'unchawmi Diospa angelninkuna hamuspanku, Diosta kasukuq justo runakunamanta llapallan huchasapa runakunata akllaspa separanqaku. ");
INSERT INTO qveNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Hinaspan Diosta mana kasukuq runakunataqa, nina rawray infiernoman wikch'uyunqaku. Chaypin llapallan huchasapa runakunaqa anchata waqanqaku, hinallataq kirunkupas rach'ikyanqaraq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesusqa kay ejemplokunata willayta tukuruspanmi, discipulonkunata tapuran: —¿Entienderankichishchu kay yachachikuykunata? nispa. Hinaqtinmi paykunaqa contestaranku: —Arí, entiendeykun, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Chaymi Jesusqa paykunata niran: —Pipas leykunata allinta yachaq, hinallataq Diospa sumaq gobiernasqanmantapas allinta entiendeq runaqa, huk wasipa dueñonmanmi rikch'akun. Paymi wasinpi waqaychasqan kaqkunamanta, ñawpaq tiempomanta kaq qorikunata hinallataq kay tiempopi kaq qorikunatawan orqomun, nispa. Nota: “Ñawpaq tiempomanta kaq qorikunaqa” Antiguo Testamentopi Diosmanta willakuq ñawpaq profetakunapa willakusqanmi. “Kay tiempopi kaq qorikunañataqmi” Jesuspa yachachisqankuna. Chay ishkaynin yachachikuykunaqa ancha allinpunin yachanapaq. ");
INSERT INTO qveNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Chay willakuykunata yachachiyta tukuruspanmi, Jesusqa chay lugarmanta ripuran. ");
INSERT INTO qveNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Hinaspan Jesusqa wiñasqan Nazaret llaqtaman chayaruspa, Diosmanta yachachina sinagoga wasipi yachachiran. Chaypi yachachisqanta uyarispankun, runakunaqa admirasqallaña, khaynata niranku: —Kay runari, ¿maypitaq kay yachachisqankunatari yacharamun? ¿Imaynanpitaq milagrokunatapas ruwanrí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ichaqa wakinñataqmi burlakuspa, khaynata niranku: —Kay runaqa, ¿manachu carpintero Joseypa wawan? ¿Manachu mamitanpa sutinpas María? ¿Manachu wawqenkunapa sutinpas: Jacobo, José, Simón, hinallataq Judas ima? ");
INSERT INTO qveNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Manachu panankunapas llaqtamasinchiskuna kashankú? Chayri, ¿maypitaq kay runari, kay rimasqankunatari yacharamun? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Chaymi Jesuspa yachachisqankunata, chaypi kaq runakuna uyariyta mana munaqtinku, Jesusqa paykunata niran: —Diosmanta willakuq profeta runaqa, huk law llaqtakunallapin allin respetasqa. Ichaqa llaqtanpi hinallataq familianpiqa, manan allin respetasqachu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Chaymi Jesusqa chikan milagrokunallata llaqtanpiqa ruwaran, paypi mana creesqankurayku. ");
INSERT INTO qveNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Chay tiempopin Herodes Antipas sutiyoq runa Galilea provinciapi kaq llapallan llaqtakunata gobiernasharan. Hinaspan Jesusmanta tukuy ima rimasqankuta uyariran. ");
INSERT INTO qveNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Chaymi chay Herodes Antipasqa serviqnin runakunata huk p'unchaw niran: —Chay Jesusqa wañusqanmanta kawsarimuq Bautizaq Juanmi. Chaymi payqa ancha atiyniyoq milagrokunata ruwananpaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodes Antipasqa Bautizaq Juantan ñawpaqtaraq hap'ichiran. Hinaspan chaqnarachispa, carcelman churachiran. Herodes Antipasqa saynataqa ruwaran Herodías warmi niqtinmi. Chay Herodías warmiqa ñawpaqtan karan Herodes Antipaspa wawqen Felipepa warmin. Ichaqa chay cuñadan warmiwanmi Herodes Antipasqa tiyaran. ");
INSERT INTO qveNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Chayraykun Bautizaq Juanqa ñawpaqtaraq Herodes Antipastaqa khaynata niran: —Leyman hinaqa manan cuñadaykiwanqa tiyawaqchu hermanoyki kawsashaqtinraqqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Chaymi Herodes Antipasqa Bautizaq Juanta, wañuchiytapuni munaran. Ichaqa llapallan runakunan Juantaqa reqsiranku Diosmanta willakuq profeta kasqanta. Chaymi Herodes Antipasqa chay runakunata manchakuspa, Juantaqa mana wañuchiyta atiranchu. ");
INSERT INTO qveNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Hinaspan Herodes Antipasqa cumpleañon p'unchaw chayaramuqtin fiestata ruwaran. Chay fiestapin Herodías warmipa ususinqa llapallan runakunapa ñawpaqninpi tusuran. Hinaqtinmi Herodes Antipasmanqa chay sipaspa tususqan anchatapuni gustaran. ");
INSERT INTO qveNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Chayraykun Herodes Antipasqa chay sipasman juramentota ruwaspa prometeran, ima mañakusqantapas chay sipasman qonanpaq. ");
INSERT INTO qveNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Chaymi Herodiaspa ususinqa, mamitanpa consejasqanrayku, Herodes Antipasta niran: —Kunanpunin munani, Bautizaq Juanpa umanta huk platopi qowanaykita, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Chaymi Herodes Antipasqa chay mañakusqanta uyarispa anchata llakikuran. Ichaqa llapallan invitadonkunapa ñawpaqninpi juramentota ruwaspa prometesqanraykun, Juanpa umanta chay sipasman qonankupaq kamachiran. ");
INSERT INTO qveNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Chaymi Herodes Antipaspa kamachisqan runakunaqa, carcelman rispanku, Bautizaq Juanpa kunkanta kuchumuranku. ");
INSERT INTO qveNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Hinaspan Bautizaq Juanpa umanta huk platopi apamuspanku, Herodiaspa ususinman qoranku. Chay ususinñataqmi mamitan Herodiasman Juanpa umantaqa entregaran. ");
INSERT INTO qveNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Chaymantañataqmi Bautizaq Juanpa discipulonkunaqa cuerponta apaspa p'ampamuranku. Hinaspan tukuy chaykuna pasasqanmanta Jesusman rispanku, willamuranku. ");
INSERT INTO qveNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Bautizaq Juanta wañuchisqankuta yacharuspanmi, Jesusqa huk boteman qespispa, pasatamuran mana pipa kasqan ch'inñeq desierto lugarman. Ichaqa chayta yacharuspankutaqmi, chay llaqtakunapi tiyaq runakunaqa, Jesuspa risqan lugarman chakillapi riranku. ");
INSERT INTO qveNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesusqa chay lugarman chayaruspanmi, risqan botemanta uraykuran. Hinaspan chaypi ashka runakunata qawayuspa, anchata khuyapayaspa, onqosqakunata sanoyachiran. ");
INSERT INTO qveNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tardeyamushaqtinñan Jesuspa discipulonkunaqa ashuykamuspa, khaynata niranku: —Nishu tardeñan kashan. Aswanyá kay llapallan runakunataqa despedipullayña, enteron muyuriqninchispi llaqtakunaman rinankupaq, hinaspa chaykunapi mikhunata mashkaspa rantikamunankupaq. Kaypiqa ch'inñeq desierto lugarpin kashanchis, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ichaqa Jesusñataqmi contestaran khaynata: —Paykunaqa ama ripuchunkuchu. Aswanqa qankunayá mikhunata qomuychis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Hinaqtinmi Jesuspa discipulonkunaqa niranku: —Noqaykupaqa kashan pishqa t'antawan, hinallataq ishkay (kankasqa) challwallapiwanmi, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesusñataqmi discipulonkunata niran: —Apamuychis chay pishqa t'antata, hinallataq chay ishkay challwatawan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jesusqa saynata nispanmi, llapallan runakunata pasto pampapi tiyanankupaq kamachiran. Hinaspan pishqa t'antata ishkaynin challwatawan hap'iyuspa, hanaq pachata qawarispa, Diosman graciasta qoran. Graciasta qoruspanmi t'antata partiyuspa, discipulonkunaman qoran, paykuna runakunaman rakimunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Chaymi llapallan runakunaqa saqsanankukama mikhuranku. Hinaspan puchuqkunatapas chunka ishkayniyoq canasta hunt'ataraq huñuranku. ");
INSERT INTO qveNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Chaypi mikhuq qarikunaqa pishqa waranqa hinan karanku. Ichaqa warmikunatapas hinallataq wawakunatapas manan yuparankuchu. ");
INSERT INTO qveNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Chaymantan Jesusqa discipulonkunata kamachiran khaynata: —Qankunaqa boteman wichaspa laguna qochapa chimpanman ñawpashaychis. Noqaqa llapallan runakunata despediruspayñan hamusaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Hinaspan Jesusqa runakunata despediruspa, Diosman orakunanpaq huk moqo pataman riran. Chaypin Jesusqa asta tutayanankama Diosmanta sapallan orakuran. ");
INSERT INTO qveNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ichaqa Jesuspa discipulonkuna laguna qochapa chawpintaña botepi rishaqtinkun, wayra paykuna lawman nishuta wayramuran. Chaymi chay laguna qochapi olakuna nishuta qallchikamuspa, risqanku boteta tukuy lawman apakacharan. ");
INSERT INTO qveNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Yaqaña achiqaramushaqtinmi, Jesusqa laguna qochapi mana hundikuspa unupa hawanta purispa paykunaman ashuyuran. ");
INSERT INTO qveNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Hinaqtinmi discipulonkunaqa rikuranku, chay laguna qochapi unupa hawanta huk runa hamushaqta. Hinaspan paykunaqa chayta rikuspanku, anchata mancharikuspa niranku: —¡Fantasman kayqa! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Chaymi Jesusqa paykunata niran: —¡Noqan kani! ¡Ama mancharikuychishchu! Aswan kallpanchakuychis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Hinaqtinmi Pedroqa contestaran: —Señor, sichus qanpuni kanki chayqa, mana hundikuspa ununtakama qanpa kasqaykiman purispa hamunaypaq nimuway, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesusñataqmi payta niran: —¡Hamuyá! nispa. Chaymi Pedroqa botemanta urayuspa, Jesuspa kasqanman rinanpaq unu hawanta puriyta qallariran. ");
INSERT INTO qveNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ichaqa nishuta wayra-wayramusqanta qawarispanmi payqa mancharikuran. Hinaspan unu ukhuman chinkayuyta qallarispa, qapariran khaynata: —¡Señor, yanapaykuway! nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Hinaqtinmi Jesusqa makinmanta aysarispa, Pedrota niran: —¡Pisi iñiyniyoq runa! ¿Imanaqtintaq noqapi mana allinta creespa ishkayashankirí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Chaymantan Jesusqa Pedropiwan boteman qespiranku. Hinaqtinmi chay nishu wayrapas chay ratolla thañiran. ");
INSERT INTO qveNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Chaymi botepi llapallan kaqkunaqa, Jesuspa ñawpaqninpi qonqorikuspanku adoraranku khaynata: —¡Cheqaqtapunin qanqa kanki Diospa Wawan! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jesusqa discipulonkunapiwanmi laguna qochata chimparuspanku, Genesaret llaqtaman chayaranku. ");
INSERT INTO qveNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Hinaqtinmi chay llaqtapi tiyaq runakunaqa, Jesusta reqsiruspanku, llapallan muyuriqnin llaqtakunapi willanakuranku. Chaymi llapallan onqosqa runakunata Jesusman apamuranku. ");
INSERT INTO qveNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Hinaspan Jesusta ruegakuranku, p'achanpa patallantapas llamiykunankupaq. Chaymi llapallan onqosqa runakunaqa Jesuspa p'achanta llamiyuspanku, chay onqoyninkumanta sanoyaranku. ");
INSERT INTO qveNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Fariseo religionniyoq wakin runakunan, hinallataq leykunamanta yachachiq runakunapiwan ima, Jerusalén llaqtamanta chayamuranku. Hinaspan Jesusman ashuyuspanku, khaynata tapuranku: ");
INSERT INTO qveNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Qanpa discipuloykikunari, ¿imanaqtintaq ñawpaq abuelonchiskunapa costumbrenkunatari mana kasukunkuchú? ¿Imanaqtintaq paykunari costumbrenchisman hina mana makinkutari maqllikunkuchu mikhunankupaqrí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Chaymi Jesusqa contestaspa, khaynata niran: —Qankunaqa costumbreykichiskunallata ruwasqaykichisraykun, Diospa kamachisqankunataqa mana kasukushankichishchu. ");
INSERT INTO qveNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Diosqa ninmi: “Tayta mamaykichista respetaspa kasukuychis. Ichaqa pipas tayta mamanta maldecinqa chayqa, wañunanpaqmi condenasqa kanqa”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ichaqa qankunañataqmi nishankichis: “Manan tayta mamaytaqa yanapayta atiymanchu. Chay yanapanay llapallan kaqniykunaqa Diosman qopunaypaqmi separasqaña kashan”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Saynata piensaspaykichismi tayta mamaykichistaqa mana yanapankichishchu. Hinaspan aswan qankunaqa kay pachapi costumbrellaykichista ruwashankichis. Ichaqa Diospa kamachisqankunatan pisiman churaspa mana kasukushankichishchu. ");
INSERT INTO qveNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Chaymi qankunaqa ishkay uya runakuna kankichis! Allintapunin Diosmanta willakuq profeta Isaiasqa ñawpaqtaraq qankunamanta escribiranña khaynata: ");
INSERT INTO qveNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Kay runakunaqa simillanwanmi adorawanku. Ichaqa sonqonkutaqmi noqamantaqa karupi kashan. ");
INSERT INTO qveNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Paykunaqa yanqapunin allinta rimaq tukuspa adorawanku. Hinallataqmi yachachinkupas runakunapa kamachisqallanta, Diospa palabranpas kashanman hinata”, nispa Isaías 29.13. ");
INSERT INTO qveNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Hinaspan Jesusqa llapallan runakunata waqyaspa, khaynata niran: —Qankunaqa allinta uyarispa entiendeychis. ");
INSERT INTO qveNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Runataqa manan mikhuna mikhusqanchu huchallichin. Aswanqa mana allinta piensarispa, imatapas rimasqanmi runataqa huchallichin, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Chaymi discipulonkunaqa Jesusman ashuyamuspa niranku: —Fariseo religionniyoq runakunan kay nisqaykita uyarispanku nishuta phiñarpakunku, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesusñataqmi khaynata contestaran: —Chay fariseo religionniyoq runakunataqa, hanaq pachapi Dios Taytaymi ladonmanta wikapanqa, imaynan huk runapas mana plantasqan plantakunataqa, saphinmanta p'elaspa wikapan chay hinata. ");
INSERT INTO qveNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Saynaqa ama qankunaqa kasukuychishchu fariseo religionniyoq runakunataqa. Paykunaqa ñawsa runakuna hina kaspankun, Diospa nisqankunata mana allintachu yachachinku. Sichus huk ñawsa runa ñawsamasinta pusanqa chayqa, ishkayninkun ima t'oqomanpas urmayunqaku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Chaymi Pedroqa kay willakuykunata uyarispa, Jesusta tapuran: —Kay willakusqaykiri, ¿ima ninantataq nin? Astawanyá yachachiwayku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Hinaqtinmi Jesusqa niran: —Qankunapas, ¿manachu entienderankichís? ");
INSERT INTO qveNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Runakunapa mikhusqanpas hinallataq tomasqanpas, manan huchallichinchu, wiksanman haykuspa, letrinallamanña risqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ichaqa runakunapa tukuy mana allinkuna rimasqanmi, sonqonmanta lloqsimuspa, chay rimaq runakunataqa huchallichin. ");
INSERT INTO qveNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kaykunan runakunapa sonqonmanta lloqsimuqqa: tukuy mana allin piensaykuna, runa wañuchiykuna, waqllikuy huchakuna, mana casarakuspa tiyaykuna, suwakuykuna, llullakuspa yanqapuni runamasinmanta rimaykuna, hinallataq k'amiykunapas. ");
INSERT INTO qveNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Chaykunan runataqa huchallichin. Ichaqa pipas makinta mana maqllikuspa mikhunata mikhun chayqa, manan huchallikunchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesusqa Genesaret llaqtamanta lloqsispanmi, Tiro sutiyoq llaqtapa, hinallataq Sidón sutiyoq llaqtapa cercanman riran. ");
INSERT INTO qveNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Chay lugarpin huk forastera warmi tiyaran. Paypa abuelonkunaqa kasqaku ñawpaq Canaán sutiyoq chinkaq nación llaqtamantan. Paymi Jesuspa kasqanman hamuspa, altota qaparispa niran: —¡Davidpa mirayninmanta Señor, khuyapayaykuwayá! Ususiytan demonio nishuta ñak'arichishan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ichaqa Jesusñataqmi chay warmipa qaparisqanta mana kasuranchu. Hinaqtinmi Jesuspa discipulonkunaqa Jesusman ashuyuspanku, khaynata ruegaranku: —Chay warmitaqa “Ripuy” niy. Payqa nishuta qaparqachaspan qepanchista hamushan, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Hinaqtinmi Jesusqa chay warmita niran: —Diosqa Israel nación llaqtayoq runakunallata yanapanaypaqmi mandamuwaran. Paykunan noqapaqqa chinkasqa ovejakuna hina kashanku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Chaymi chay warmiqa Jesusman ashuyuran. Hinaspan ñawpaqninpi qonqorikuspa, ruegakuran khaynata: —¡Señor, yanapaykuway! nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesusñataqmi contestaran: —Manan allinchu kanman wawakunapa t'antanta qechuruspa, alqokunaman wikch'uyuyqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Hinaqtinmi chay warmiqa niran: —¡Señorlláy, chay nisqaykiqa cheqaqpunin! Ichaqa alqokunapas mikhunmi, dueñonpa mesanmanta pampaman parte-parten urmaq t'antakunatapas, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Chaymi Jesusqa niran: —¡Qanqa cheqaqtapunin Diospi iñishanki! Saynaqa ripullay. Mañakusqaykiman hinayá ruwasqa kachun, nispa. Hinaqtinmi chay ratomantapacha, chay warmipa ususinqa sanoyapuran. ");
INSERT INTO qveNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesusqa chay Tiro llaqtapa hinallataq Sidón llaqtapa cercanmanta hamuspanmi, Galilea laguna qochapa patanman chayamuran. Chaymantan huk moqoman rispa, chaypi tiyayuran. ");
INSERT INTO qveNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Hinaqtinmi onqosqakunata pusayukuspa, Jesuspa kasqanman ashka runakuna huñunakamuranku. Chay onqosqakunan karanku: wist'ukuna, ñawsakuna, mana rimay atiqkuna, mana valeq makiyoq runakuna, hinallataq onqoyniyoq ashka runakuna ima. Hinaspan Jesuspa ñawpaqninpi churaranku. Chaymi Jesusqa chay onqosqakunata sanoyachiran. ");
INSERT INTO qveNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Chaymi runakunaqa anchata admirakuranku, mana rimay atiqkuna rimaqtin, mana valeq makiyoqkuna sanoyasqa kaqtin, wist'ukunapas puriqtin, hinallataq ñawsakunapas rikuqtin. Chaymi chaykunata rikuspanku Israel nacionniyoq runakunapa Diosninta alabaranku. ");
INSERT INTO qveNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesusmi discipulonkunata waqyaspa niran: —Noqaqa khuyapayanin kay llapallan runakunataqa. Paykunaqa kinsa p'unchawñan noqawan kushka kashanku. Ichaqa manataqmi ni imankupas kanchu paykuna mikhunankupaqqa. Chaymi noqaqa mana munanichu wasinkuman yarqasqa kutipunankutaqa. Yanqan paykunaqa ñan risqankupi yarqaymanta desmayarunkuman, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Chaymi Jesuspa discipulonkunaqa niranku: —Kay ch'inñeq lugarpiri, ¿maymantataq kay llapallan runakunapaqri, ashka mikhunata tarimusunman? Kay lugarpiqa manan ni pipas tiyanchu, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Hinaqtinmi Jesusqa discipulonkunata tapuran: —Qankunapari, ¿hayk'a t'antaykichistaq kashan? nispa. Chaymi paykunañataq contestaranku khaynata: —Qanchis t'antallaykun kashan, kankasqa chikan challwachakunallapiwan, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Hinaqtinmi Jesusqa kamachiran, chaypi kaq llapallan runakuna pampapi tiyanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Hinaspan Jesusqa chay qanchisnintin t'antata, hinallataq kankasqa challwachakunatawan hap'ispa, Diosman graciasta qoran. Partiyuspanñataqmi discipulonkunaman qoran. Hinaqtinmi paykunaqa llapallan runakunaman rakimuranku. ");
INSERT INTO qveNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Chaymi llapallan runakunaqa saqsanankukama mikhuranku. Hinaspan puchuqkunatapas qanchis canasta hunt'ataraq huñumuranku. ");
INSERT INTO qveNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Chaypi mikhuq qarikunaqa tawa waranqa hinan karanku; ichaqa warmikunatapas hinallataq wawakunatapas manan yuparankuchu. ");
INSERT INTO qveNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Chaymantan Jesusqa runakunata wasinkuman ripunankupaq despediran. Hinaspan boteman wichaspa Magdala llaqta lawman riran. ");
INSERT INTO qveNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Wakin fariseo religionniyoq runakunan, hinallataq saduceo religionniyoq runakunapiwan ima, Jesusta imallapipas pantachiyta munaranku. Chaymi Jesusman ashuyuspanku, khaynata niranku: —Cheqaqtapuni Diosmanta Hamuq Runa kaspaykiqa, huk milagrotayá ruway noqayku rikunaykupaq, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Hinaqtinmi Jesusqa chay fariseo religionniyoq runakunata, hinallataq chay saduceo religionniyoq runakunata niran: —Qankunaqa tardeyaqtinmi, intiq haykunan law cielopi antaruphayta qawarispa, ninkichis: “Allin tiempon kanqa”, nispaykichis. ");
INSERT INTO qveNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Saynallataqmi cielopi tutallamanta yana phuyuta qawarispapas, nillankichistaq: “Paramunqan”, nispaykichis. ¡Ishkay uya runakuna, qankunaqa cielota qawarispallaykichismi yachankichis, imayna tiempo kanantapas! Chayri, ¿imanaqtintaq mana cuentatari qokunkichishchu, kunan tiempokunapi tukuy imaymana señalkuna pasasqanmantarí? ");
INSERT INTO qveNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","¡Huchasapa mana allin ruwaq runakuna! Qankunaqa noqapi creenaykichispaqmi, milagro ruwanaytaraq mañakuwashankichis. Ichaqa manan ni ima milagrotapas Diosqa rikuchisunkichishchu. Aswanqa Diosmanta willakuq profeta Jonasta imachus pasaran, chay hinallatan noqawan imas pasasqantapas rikunkichis, nispa. Nota: Jesusqa kaypin comparasharan, imaynan profeta Jonaspas kinsa p'unchaw hinallataq kinsa tuta ima huk hatunkaray challwapa wiksanpi karan, saynallataqmi Jesuspas p'ampasqa karan kinsa p'unchaw hinallataq kinsa tuta ima. Saynata niruspanmi, Jesusqa paykunata saqespa pasapuran. ");
INSERT INTO qveNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jesusqa discipulonkunapiwan kushkan Galilea laguna qochata chimparanku. Ichaqa discipulonkunañataqmi t'antata apayta qonqarusqaku. ");
INSERT INTO qveNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Hinaqtinmi Jesusqa niran: —Allinta cuidakuychis fariseo religionniyoq runakunapa, hinallataq saduceo religionniyoq runakunapa levadurankumantaqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Chaymi Jesuspa discipulonkunaqa ninakuranku: —T'antata mana apamusqanchisraykun saynataqa niwashanchis, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesusñataqmi cuentata qokuspa discipulonkunata niran: —Pisi iñiyniyoq runakuna, ¿imanaqtintaq rimashankichis t'antata mana apamusqaykichismantarí? ");
INSERT INTO qveNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Manaraqchu allinta entiendenkichis imatachus niyta munani chayta? Qankunari, ¿manachu yuyankichis pishqa t'antallawan, pishqa waranqa runakuna mikhunanpaq milagro ruwasqayta? Hinaspapas, ¿manachu yuyankichis ashka canasta hunt'ataraq puchuq t'antakunatapas huñusqaykichista? ");
INSERT INTO qveNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Manallataqchu yuyankichis, qanchis t'antallamanta tawa waranqa runakuna mikhunanpaq milagro ruwasqayta? Hinaspapas, ¿manachu yuyankichis ashka canasta hunt'ataraq puchuq t'antakunatapas huñumusqaykichista? ");
INSERT INTO qveNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Imanaqtintaq qankunari mana entiendewankichishchú? Noqaqa manan t'antamantachu rimapayashaykichis. Aswanqa fariseo religionniyoq runakunapa, hinallataq saduceo religionniyoq runakunapa levaduranmanta cuidakunaykichispaqmi rimapayashaykichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Hinaqtinmi Jesuspa discipulonkunaqa chayraq entienderanku, Jesuspa yachachisqanta. Payqa manan t'antata ruwana levaduramantachu niyta munaran. Aswanqa fariseokunapa, hinallataq saduceokunapa costumbrenkuman hinalla yachachisqankunamanta cuidakunankupaqmi chaykunataqa yachachiran. ");
INSERT INTO qveNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesusqa Filipo sutiyoq lugarpi kaq Cesarea llaqtapa cercanman chayaruspanmi, discipulonkunata tapuran: —Noqa Diosmanta Hamuq Runari, ¿pitaq kani runakunapaqrí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Chaymi discipulonkunaqa contestaranku: —Wakinmi ninku: “Bautizaq Juanmi”, nispanku. Wakintaqmi ninku: “Ñawpaq profeta Eliasmi”, nispanku. Wakinñataqmi ninku: “Ñawpaq profeta Jeremiasmi”, nispanku. Hukkunañataqmi ninku: “Mayqen profetapashchá”, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Hinaqtinmi Jesusqa discipulonkunata tapuran: —Qankunari, ¿ima ninkichistaq noqamanta? Qankunapaqri, ¿pitaq noqari kaní? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Chaymi Simón Pedroqa contestaran: —Qanqa kanki Diosmanta Hamuq Salvadorniyku Criston, hinaspapas wiña-wiñaypaq kawsaq Diospa Wawanmi, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Hinaqtinmi Jesusqa Simón Pedrota niran: —Jonaspa wawan Simón, qanpaqyá ancha kusikuy kachun. Kay nisqaykitaqa manan kikillaykimantachu, nitaq runakunamantachu yachamuranki. Aswanqa hanaq pachapi Dios Taytaymi kay yachaytaqa revelasuranki. ");
INSERT INTO qveNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Chaymi noqapas niyki, qanqa kanki “Pedron” nispa. Kay sutiykiqa “rumi” ninantan nin. Noqaqa rumi hawapin iglesiaytaqa hatarichisaq. (Chay iglesiayqa noqapi creeqkunan kanku). Hinaspapas paykunataqa manan diablopas nitaq wañuypas chinkachiytaqa atinqachu. ");
INSERT INTO qveNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Hinaspan noqaqa qanman atiyta qosqayki huk llaveta hina, Diospa qayllanman runakuna haykunankupaq. Chaymi kay pachapi imapas watasqaykiqa, hanaq pachapipas watasqallataq kanqa. Hinallataq kay pachapi imapas pashkasqaykiqa, hanaq pachapipas pashkasqallataq kanqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Hinaspan Jesusqa chaykunata rimayta tukuruspa, discipulonkunata kamachiran khaynata: —Qankunaqa amaraq ni pimanpas willankichisraqchu noqa Diosmanta Hamuq Salvador Cristo kasqaytaqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Chaymantapachan Jesusqa discipulonkunaman willayta qallariran khaynata: —Noqaqa Jerusalén llaqtamanmi risaq. Chaypin kay Israel nación llaqtapi kamachiq jefekuna, sacerdotekunapa jefenkuna, hinallataq leykunamanta yachachiq runakunapas, noqa Diosmanta Hamuq Runataqa, anchata ñak'arichiwaspanku, wañuchiwanqaku. Ichaqa saynata wañuchiwaqtinkupas, kinsa p'unchawmantan noqaqa kawsarinpusaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Hinaqtinmi Pedroqa Jesusta huk lawman waqyarispa, sayna nisqanmanta Jesusta q'aqchaspa, khaynata niran: —¡Diosqa amayá permitichunchu qanta chaykuna pasasunaykitaqa! nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ichaqa Jesusñataqmi kutirimuspa Pedrota niran: —¡Ayqeriy noqapa ñawpaqniymanta! Diospa munasqanta ama ruwanaypaqmi, qantaqa diablo rimachishasunki. Qanqa manan entiendenkichu Diospa munasqantaqa. Chaymi qanqa (Diospi mana creeq) runakuna hinalla piensashanki, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Chaymantan Jesusqa discipulonkunata nillarantaq khaynata: —Pipas noqapa discipuloy kayta munaspaqa, qonqananmi kikinpa munasqanman hina imatapas ruwayta. Hinaspapas noqapi creesqanraykun tukuy ima sasachakuykuna chayamuqtinpas, listo kanan cruzpi ñak'arispa wañunanpaq. Hinallataqmi noqapa kamachisqaykunatapas ruwanan. ");
INSERT INTO qveNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ichaqa pipas kay pachapi payllapaq kawsay munaq runaqa, wiñaypaqmi wañunqa. Aswan pi runapas noqapi creesqanrayku wañuqmi, wiñaypaq kawsanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kay pachapi tukuy ima kaqniyoq kayri, ¿imapaqtaq sirven, sichus runapa alman mana salvasqa kaqtinrí? Kay pachapi runari, ¿hayk'atataq paganman almanta salvananpaqrí? Manan ni hayk'ataña pagaspapas salvakuytaqa atinkumanchu. ");
INSERT INTO qveNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ichaqa Dios Taytaypa ancha atiyninwanmi, noqa Diosmanta Hamuq Runaqa, angelniykunawan kushka hamusaq. Hinaspan sapankamankuman pagonkuta qopusaq kay pachapi ruwasqankuman hina. ");
INSERT INTO qveNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Cheqaqtapunin niykichis, kaypi noqawan wakin kaqkunaqa manaraqmi wañunkichisraqchu, noqa Diosmanta Hamuq Runa, gobiernanaypaq hamushaqta rikuwanaykichiskama, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Chaykuna rimasqanmanta soqta p'unchaw pasaruqtinmi, Jesusqa discipulon Pedrota, Jacobota, hinallataq Jacobopa wawqen Juantawan pusayukuspa, huk orqoman riran, chaypi paykunalla kanankupaq. Nota: Jocobopa huknin sutinmi karan Santiago. ");
INSERT INTO qveNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Chaypin kinsantin discipulonkunapa ñawpaqninpi, Jesusqa hukniraqman tukuran. Chaymi uyanpas inti hinaraq k'anchariran. Hinallataqmi p'achanpas sumaq yuraq k'anchariqman tukuran. ");
INSERT INTO qveNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Hinaqtinmi chaypi qonqayllamanta rikhuriranku Jesuswan parlaspanku, Diosmanta yachachiq ñawpaq profetakuna Moiseswan hinallataq Eliaspiwan ima. ");
INSERT INTO qveNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Chaymi Pedroqa Jesusta niran: —Yachachikuq, ¡allinmi kaypi kasqaykuqa! Munaqtiykiqa, kinsa ramadatayá ruwarusaqku, hukninta qanpaq, hukninta Moisespaq, huknintataq Eliaspaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Chaykunata Pedro rimallashaqtinraqmi, huk k'anchariq phuyu paykunata tapaykuran. Hinaqtinmi phuyu ukhumanta khaynata nimuran: —Paymi khuyakusqay Wawayqa. Paywanmi anchata kusikuni. Payta uyarispayá kasukuychis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Chayta uyarispankun Jesuspa discipulonkunaqa anchata mancharikuranku. Hinaspan qonqorikuranku uyankupas pampaman tupanankamaraq. ");
INSERT INTO qveNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Chaymi Jesusqa discipulonkunaman ashuyuran. Hinaspan paykunata tupayuspa, khaynata niran: —Sayariychis, ama mancharikuychishchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Hinaqtinmi paykunaqa sayarimuspanku, Jesustaqa sapallantaña chaypi rikuranku. ");
INSERT INTO qveNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Chay orqomanta kutinpushaspankun, Jesusqa kinsantin discipulonkunata kamachiran khaynata: —Kaykuna rikusqaykichistaqa, aman pimanpas willankichisraqchu, noqa Diosmanta Hamuq Runa wañusqaymanta kawsarimunaykama, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Chaymi discipulonkunaqa Jesusta tapuranku: —Leykunata yachachiq runakunari, ¿imanaqtintaq ninku, “Diosmanta Hamuq Runapa ñawpaqnintaqa profeta Eliasraqmi hamunqa”, nisparí? ");
INSERT INTO qveNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Hinaqtinmi Jesusqa contestaran: —Arí, cheqaqtapunin Eliasqa ñawpaqta hamuspa, Diosmanta runakunaman willanqa, Salvadorta chashkinankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ichaqa noqan kunan niykichis: Eliasqa ñan hamuranña. Hinaqtinmi Israel nacionniyoq runakunaqa mana cuentata qokurankuchu. Chaymi paytaqa mana chashkirankuchu. Aswanmi paytaqa tukuy ima munasqankuta ruwaranku. Saynallataqmi noqa Diosmanta Hamuq Runatapas, anchata ñak'arichiwanqaku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Chayta uyarispankun kinsantin discipulonkunaqa, chayraq cuentata qokuranku, Bautizaq Juanmanta Jesús rimasqanta. Nota: Profeta Eliasmi ñawpaq tiempopi runakunata waqyaran Diosman kutirikunankupaq, saynallatataqmi Bautizaq Juanpas Salvadorta chashkinankupaq runakunata waqyaran. Chayraykun Jesusqa niran: “Chay profeta Elías suyasqaykichisqa Bautizaq Juanmi karan”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jesusqa chay kinsa discipulonkunapiwanmi ashka runakunapa kasqanman chayamuranku. Chaymi Jesusman huk runa ashuykamuspa, ñawpaqninpi qonqorikuspa, khaynata niran: ");
INSERT INTO qveNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—¡Señorlláy, khuyapayaykuy kay wawallayta, hinaspa yanapaykuy! Paymi nishuta ñak'arin ataki hap'iqtin. Chaymi payqa ashka kutiña ninaman, hinallataq unumanpas urmaykun. ");
INSERT INTO qveNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Noqaqa ñan apamuraniña discipuloykikunamanqa; ichaqa manan paykunaqa sanoyachiyta atirankuchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Chaymi Jesusqa niran: —¡Ay, Diospi mana creespa mana allin ruwaq runakuna! ¿Hayk'aqkamataq qankunawanri kasaq kaykunata uyarinaypaqrí? ¿Hayk'aqkamataq aguantasqaykichis qankunatarí? nispa. Chayta nispanmi Jesusqa niran: —¡Apamuychis chay joventa! nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Saynata niqtinmi Jesusman chay joventa apamuranku. Hinaqtinmi Jesusqa q'aqchaspa demoniota kamachiran chay jovenmanta lloqsinanpaq. Chaymi chay ratomantapacha chay jovenqa sanoyaran. ");
INSERT INTO qveNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Chaymantan discipulonkunaqa Jesusman ashuyuspa, sapallankupi tapuranku: —¿Imanaqtintaq noqaykuri mana atiraykuchu chay demonio qarqoytarí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Chaymi Jesusqa discipulonkunata niran: —Qankunaqa pisi iñiyllayoq kasqaykichisraykun mana atirankichishchu chay demonio qarqoytaqa. Ichaqa cheqaqtapunin niykichis, sichus huk mostazapa mukhun hina uchuychallapas qankunapa iñiyniykichis kanman chayqa, niwaqchismi kay orqotapas “huk lawman ayqeriy”, nispa. Hinaqtinqa kay orqopas huk lawmanmi ayqerinman. Manan imapas sasaqa kanmanchu Diospi qankuna allinta iñiqtiykichisqa. ");
INSERT INTO qveNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","{Ichaqa ayunowan hinallataq oracionllawanmi kay demoniokunaqa lloqsin}, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jesusqa Galilea provincia llaqtapi discipulonkunapiwan kushka kashaspankun, paykunata niran: —Noqa Diosmanta Hamuq Runataqa, cheqniwaqniy runakunan hap'iwaspanku entregawanqaku. ");
INSERT INTO qveNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Hinaspan wañuchiwanqaku. Ichaqa kinsa p'unchawmantan noqaqa kawsarinpusaq, nispa. Chayta uyarispankun discipulonkunaqa anchata llakikuranku. ");
INSERT INTO qveNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Capernaúm llaqtaman Jesús discipulonkunapiwan chayaruqtinkun, templopaq impuesto cobraqkuna, Pedroman ashuyuspa tapuranku: —Yachachisuqniykichisri, ¿manachu impuestota pagan templopaq? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Chaymi Pedroqa contestaran: —Arí, payqa paganmi, nispa. Hinaqtinmi wasipi llapallan runakunapa kasqanman Simón Pedro haykuruqtin hinalla, Jesusqa payta tapuran: —Simón, ¿qanri ima ninkitaq? Kay pachapi reykunari, ¿pikunamantataq cobranku impuestokunatarí? ¿Llaqtamasinku runakunamantachu, icha huk law llaqtayoq runakunamantachú? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Hinaqtinmi Pedroqa contestaran: —Huk law llaqtayoq runakunamantan cobranku, nispa. Chaymi Jesusqa niran: —Arí, qanpa nisqaykiman hinan; llaqtamasinku runakunaqa manan pagankuchu. ");
INSERT INTO qveNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ichaqa chay impuesto cobraqkuna ama phiñakunankupaqyá, laguna qochaman rispayki, anzueloykiwan challwata challwamuy. Hinaspa primer kaq challwa hap'isqaykipa siminta kichariy. Chay challwapa siminpin tarinki huk qolqeta. Hinaspa chay qolqewan chay impuesto cobraqkunaman pagamuy, noqapa impuesto paganayta, hinallataq qanpa impuesto paganaykitawan ima, nispa. Nota: Ñawpaq Israel nación llaqtapiqa, costumbrenkuman hinan, templota mantenenankupaq llapallan chay Israel nacionniyoq runakunaqa huk impuestota pagaranku. Chay clase impuestomantan rimashan Mateo 17.24. ");
INSERT INTO qveNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Chay p'unchawkunapin discipulonkunaqa Jesusman ashuyuspa, khaynata tapuranku: —¿Pitaq Diospa sumaq gobiernasqanpiri más importante runari kanqa? nispanku. Nota: Jesuspa discipulonkunaqa paytukusqa kaspankun saynataqa tapuranku. ");
INSERT INTO qveNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Chaymi Jesusqa huk warmachata waqyaspa discipulonkunapa chawpinpi sayaykachiran. ");
INSERT INTO qveNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Hinaspan discipulonkunata niran: —Cheqaqtapunin niykichis, pipas kay wawa hina humilde kaspan, Diospa gobiernasqan sumaq glorianmanqa haykuyta atinqa. ");
INSERT INTO qveNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Chaymi pipas kay wawa hina humilde sonqoyoq kaspa, Diospa gobiernasqan sumaq glorianpiqa aswan más importante runa kanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Saynallataqmi pipas noqapa sutiypi kay wawata chashkiqqa, noqatapas chashkiwashanmi, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Jesusqa nillarantaqmi: —Noqapi chayllaraq creeq runakunata, pipas huchaman urmachinqa chayqa, ancha castigasqan kanqa. Chayraykun chay runapaqqa aswan allin kanman, huk hatun molino rumita kunkanman wataruspa, lamar qochaman wikch'uyamuy. ");
INSERT INTO qveNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Chaymi niykichis, kay pachapiqa kanqapunin runamasinta huchaman urmachiq runakunaqa. Ichaqa ¡ay, imaynaraq kanqa runamasinta huchaman urmachiq runakunaqa! ");
INSERT INTO qveNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Saynaqa sichus makiykipas otaq chakiykipas huchaman urmachisunki chayqa, aswanyá kuchuspa karuman wikapay. Aswan allinmi kanman huknin makillayoq otaq huknin chakillayoq, wiñay kawsayman haykunaykipaqqa, aswan ishkaynin makintin otaq ishkaynin chakintin, wiñaypaq nina rawraq infiernoman wikch'uyusqa kanaykimantaqa. ");
INSERT INTO qveNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Hinallataq sichus ñawiyki huchaman urmachisunki chayqa, aswanyá orqospa karuman wikapay. Aswan allinmi kanman huknin ñawillayoq, wiñay kawsayman haykunaykipaqqa, aswan ishkaynin ñawintin nina rawraq infiernoman wikch'uyusqa kanaykimantaqa. ");
INSERT INTO qveNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Saynaqa noqapi creeq humilde runakunataqa, amayá ni mayqentapas despreciankichishchu. Ichaqa noqapi creeq humilde runakunataqa, hanaq pachapi Diospa angelninkunan waqaychan. ");
INSERT INTO qveNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","{Noqa Diosmanta Hamuq Runaqa, huchankupi chinkasqa runakunata salvaqmi hamurani}, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Jesusqa nillarantaqmi khaynata: —¿Ima niwaqchistaq qankunarí? Sichus mayqenniykichispapas pachaq ovejaykichismanta huknin chinkaruqtin, ¿manachu esqon chunka esqonniyoq ovejaykichiskunata saqeruspa, chay chinkaq ovejata mashkaq riwaqchis tarimunaykichiskama? ");
INSERT INTO qveNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Cheqaqtapunin niykichis, qankunaqa chay esqon chunka esqonniyoq ovejaykichismantapas, aswan mastaraqmi kusikunkichis chay chinkasqa ovejaykichis tarimusqaykichiswanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Saynallataqmi, Dios Taytaykichispas mana munanchu, noqapi chayllaraq creeqkunamanta ni ch'ullallapas huchaman urmaspa, wiñaypaq chinkasqa kanantaqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jesusqa nillarantaqmi: —Diospi creeqmasiyki qanpa contraykipi imatapas mana allintachu ruwanqa chayqa, paywanyá sapallanpi parlaspa q'aqchay, chaykuna ruwasqanmanta cuentata qokunanpaq. Sichus chay nisqaykiman hina kasukunqa chayqa, Dioswanmi allinpiña kawsanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mana kasukunqachu chayqa, huk testigota otaq ishkay testigokunata pusayukuspayki riy, contraykipi ruwasqanmanta paywan parlamunaykipaq, saynapi chay ishkay otaq kinsa testigokunapa ñawpaqninpi rimapayasqayki, yachasqa kananpaq. ");
INSERT INTO qveNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Hinallataq chay testigokunapa ñawpaqninpipas mana uyarisunkichu chayqa, iglesiaman rispayki willamuy llapallan creyentekuna yachanankupaq. Sichus iglesiapi huñunakuqkunatapas mana kasukunqachu chayqa, Diospi mana creeq huchasapa runata hinaña rikuychis, imaynan Roma llaqtapaq impuesto cobraq runakunapas huchasapa runakuna kashanku chay hinata. ");
INSERT INTO qveNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Cheqaqtapunin niykichis, kay pachapi imapas watasqaykiqa, hanaq pachapipas watasqallataqmi kanqa. Hinallataq kay pachapi imapas pashkasqaykiqa, hanaq pachapipas pashkasqallataqmi kanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Hinallataqmi qankunataqa huktawan niykichis, sichus ishkayllapas kay pachapi huk acuerdoman haykuspa, Dios Taytaymanta imatapas mañakunkichis chayqa, payqa qosunkichismi chay mañakusqaykichistaqa. ");
INSERT INTO qveNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Chayraykun niykichis, sichus ishkayllapas otaq kinsallapas noqapa sutiypi huñunakunqaku chayqa, paykunapa chawpinpin noqaqa kashani, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Chaymi Pedroqa Jesusman ashuyuspa tapuran: —Señorlláy, ¿Diospi creeqmasiy noqapa contraypi ima mana allintapas ruwaspa huchallikuqtinri, hayk'a kutikamataq perdonaymanrí? ¿Qanchis kutikamachú? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Hinaqtinmi Jesusqa contestaran: —Manan qanchis kutillatachu Diospi creeqmasiykitaqa perdonanayki, aswanqa qanchis chunkata qanchis kutikaman, nispa. Nota: Kay versiculoqa khayna ninantan nin: Noqanchisqa tukuy tiempon dispuesto kananchis perdonananchispaq. ");
INSERT INTO qveNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Jesusqa nillarantaqmi: —Runakunata Dios gobiernayta qallarisqanqa rikch'akun huk reymanmi. Chay reymi llank'apakuqnin runakunata waqyachimuspa cuentata mañaran. ");
INSERT INTO qveNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Chaymi cuentata mañayta qallarishaqtin, payman pusamuranku ashka-ashka millonninpi qolqe debeq serviqnin runata. ");
INSERT INTO qveNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ichaqa chay serviqnin runapaqa manan qolqen karanchu chay reyman pagapunanpaqqa. Chaymi chay reyqa wakin serviqnin runakunata khaynata kamachiran: “Chay debewaqniy runata, warmintinta, wawakunantinta, hinallataq tukuy ima kaqninkunatawan vendemuychis”, nispa. Saynataqa kamachiran, chay debesqan pagasqa kananpaqmi. ");
INSERT INTO qveNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Hinaqtinmi chay serviqnin runaqa reypa ñawpaqninpi qonqoriyukuspa, khaynata ruegakuran: “Señorlláy, ama hina kaychu, huk tiempochatawan suyayukuway; debesqaytaqa llapachallantan pagapusqayki”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Saynata ruegakuqtinmi, reyqa chay serviqnin runata khuyapayaspa niran: “Ripuy hawkalla. Perdonaykin llapallan debewasqaykitaqa”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Hinaqtinmi chay serviqnin runaqa, reypa ladonmanta lloqsiruspa, pachaq qolqella debeqnin serviqmasin runawan tuparuran. Hinaspan payqa chay chikachallan qolqe debeqnin runata, kunkanmanta hap'ispa, niran: “¡Debewasqaykita kunachallan pagapuway!” nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Chaymi chay pachaq qolqe debeq runaqa, debesqan runapa ñawpaqninpi qonqoriyukuspa, ruegakuran khaynata: “Ama hina kaychu, huk tiempochatawan suyayukuway. Noqaqa llapachallan debesqaytan pagapusqayki”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ichaqa chay runañataqmi, debeqnin runapa ruegakusqantapas mana khuyapayaranchu. Hinaspan chay debeqnin runata aswan carcelman churachimuran, llapallan debesqanta pagayta tukunankama. ");
INSERT INTO qveNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Chaymi sayna ruwasqanta rikuspanku, serviqmasin runakunaqa, sonqonkupi anchata renegaranku. Hinaspan paykunaqa reyman rispanku, chaykuna ruwasqanmanta willamuranku. ");
INSERT INTO qveNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Hinaqtinmi reyqa chay ashka-ashka millonninpi debeqnin runata waqyachimuspa, khaynata niran: “¡Yaw mana khuyapayana yana alma runa! Llapallan debewasqaykitan noqaqa perdonarayki ruegakuwasqaykirayku. ");
INSERT INTO qveNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Chayri, ¿manachu qanpas noqa hina perdonaykuwaq karan, chay debesuqniyki runamasiykita?” nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Chaymi reyqa anchata phiñakuran chay runapaq. Hinaspan castiganankupaq apachiran, llapallan debesqanta pagayta tukunankama. ");
INSERT INTO qveNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Chaykunata nispanmi, Jesusqa niran: —Saynallatataqmi hanaq pachapi Dios Taytaypas qankunawanqa ruwanqa, sichus qankuna runamasiykichista mana tukuy sonqoykichiswanchu perdonankichis chayqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesusqa kaykunata Galilea provincia lawpi yacharachispanmi, chaymanta ripuran. Hinaspan chayaran Jordán mayupa chimpanpi Judea provincia lawman; chay lugarqa intiq lloqsimunan lawpin tarikuran. ");
INSERT INTO qveNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Hinaqtinmi Jesuspa qepanta ashkallaña runakuna riranku. Chaypin Jesusqa onqosqa runakunata sanoyachiran. ");
INSERT INTO qveNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Chaymi wakin fariseo religionniyoq runakunaqa, Jesusta rimasqanpi pantachiyta munaranku. Hinaspan payman ashuyuspa khaynata tapuranku: —Huk casado runari, ¿ima motivollawanpas warminmanta t'aqakuyta atinmanchú? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesusñataqmi contestaran: —¿Manachu qankunari Bibliapi leerankichis, Diosqa kay pacha qallariyninpi qarita warmitawan ruwasqanta? ");
INSERT INTO qveNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Hinaspan Diosqa niran: “Qariqa papantapas mamitantapas saqespanmi, casarakusqan warminwan tiyanan. Hinaspan ishkayninku huk runa hinallaña kananku”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Chaymi casado kaspankuqa, manaña ishkay runakuna hinañachu kanku. Aswanqa huk runa hinallañan kanku. Chayraykun Diospa hukllasqantaqa, runaqa mana t'aqananchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Hinaqtinmi fariseo religionniyoq runakunaqa Jesusta tapullarankutaq: —Chayri, ¿imanaqtintaq Moisesri escribisqan leypi yachachiran khaynata: “Pipas warminmanta t'aqakuyta munaspaqa, divorcio papelta firmayuspanmi t'aqakullanman”, nisparí? ");
INSERT INTO qveNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesusñataqmi contestaran: —Moisespa tiemponpi runakunaqa qankuna hinan nishu rumi sonqo karanku. Chayraykun Moisesqa chay runakunataqa permitiran warminkumanta t'aqakunankutaqa. Ichaqa kay pacha qallariyninmantapachapas Diosqa manan munaranchu, pipas casarasqa kashaspa warminmanta t'aqakunantaqa. ");
INSERT INTO qveNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Chaymi niykichis, manan ni pipas warminmantaqa t'aqakunmanchu. Sichus pipas warminmanta t'aqakuspa huk warmiwan casarakuspaqa, waqllikuy huchapin kashan. T'aqakunmanqa sichus warmin piwanpas waqllirukullaqtinmi, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Chaykunata niqtinmi discipulonkunaqa Jesusta niranku: —Sayna kaqtinqa aswanchá amaña casarakuyqa kanmanchu, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Chaymi Jesusqa discipulonkunata niran: —Kay yachachikuykunaqa manan llapallan runakunapaqchu. Aswanqa pikunamanchus Dios atiyta qon, paykunallapaqmi. ");
INSERT INTO qveNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ichaqa kanmi qarikuna nacesqankumantapacha capasqa hina nacemuspanku mana warminayachikuqkuna. Wakinñataqmi runapa capasqan kasqanrayku mana warminayachikuqkuna kanku. Hinallataq wakinpas Diospa kamachisqanpi llank'anankupaq akllasqa kaspanku mana warmiyoq kayta munaqkuna kanku. Saynaqa kay yachachikuyta chashkiyta munaqkunaqa, chashkichunkuyá, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Jesusmanmi wawakunata pusamuranku, paykunaman makinta churayuspa Diosmanta mañapunanpaq. Ichaqa Jesuspa discipulonkunañataqmi wawakuna pusamuq runakunata q'aqcharanku. Hinaspan mana munarankuchu Jesusman ashuyunankuta. ");
INSERT INTO qveNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Hinaqtinmi Jesusqa discipulonkunata niran: —Ama hark'aychishchu wawakuna noqaman hamunantaqa. Kay wawakuna hina kaq runakunapaqmi, hanaq pachapi Diospa suma-sumaq glorianqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jesusqa saynata niruspanmi, sapankama wawakunapa umanman makinta churayuspa, Diosmanta paykunapaq mañapuran. Hinaspan chaymanta ripuran. ");
INSERT INTO qveNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Huk jovenmi, Jesusman hamuspa tapuran: —Allin yachachikuq, ¿imata ruwaspaytaq Diospa ladonpiri wiña-wiñaypaq kawsayman? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Hinaqtinmi Jesusqa contestaspa niran: —¿Imanaqtintaq allin kaqkunamantari yachayta munankí? Manan pipas allinqa kanchu, aswanqa Diosllan. Sichus wiñaypaq kawsayta munaspaykiqa, Diospa kamachikuyninkunata kasukuy, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Hinaqtinmi chay jovenqa Jesusta tapullarantaq khaynata: —¿Mayqen kaq kamachikuykunatataq kasukunayrí? nispa. Chaymi Jesusqa niran: —Aman pitapas wañuchinkichu; aman piwanpas waqllikunkichu; aman suwakunkichu; aman pipa contranpipas llullakuspaqa rimankichu. ");
INSERT INTO qveNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Tayta mamaykitapas allinta respetaspayá kasukunki. Hinallataq runamasiykitapas, qan kikiykita hina munakunki, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Hinaqtinmi chay joven runaqa niran: —Taksa kasqaymantapachan chay kamachikuykunataqa kasukurani. ¿Imatawanraqtaq ruwaymanrí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Chaymi Jesusqa niran: —Sichus allin cabal runa kayta munanki chayqa, tukuy ima kaqniykikunata vendemuy. Hinaspa chay qolqeta wakchakunaman rakimuy. Saynapin hanaq pachapi tukuy ima kaqniyoq kanki. Chayta ruwaramuspaykitaq hamunki noqata qatikuwanaykipaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Hinaqtinmi Jesuspa nisqanta uyarispa, chay jovenqa anchata llakikuspa ripuran, nishu qapaq runa kasqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Chaymi Jesusqa discipulonkunata niran: —Cheqaqtapunin niykichis, huk qapaq runaqa ancha sasatan Diospa hanaq pacha glorianmanqa haykunqa. ");
INSERT INTO qveNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Aswanmi ichaqa nisqaykichis, huk hatun camello animalraqmi awqapa ninrinta pasarunman, huk qapaq runa Diospa gobiernasqan sumaq glorianman haykunanmantaqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Hinaqtinmi Jesuspa discipulonkunaqa, chay yachachisqankunata uyarispanku, astawanraq admirakuranku. Hinaspan khaynata niranku: —Sayna kaqtinri, ¿pitaq atinman salvakuytarí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Chaymi Jesusqa discipulonkunata qawarispa, khaynata niran: —Runakunapaqqa sasan ima ruwaypas. Diospaqmi ichaqa tukuy imapas mana sasachu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Hinaqtinmi Pedroqa Jesusta niran: —Noqaykuqa tukuy imaykutapas saqemuspaykun qanwan kushka purishayku. Chayri, ¿ima premiotataq noqaykuri chashkisaqkú? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Hinaqtinmi Jesusqa contestaspa niran: —Cheqaqtapunin niykichis, tukuy imatapas mosoqman Dios tukuchiqtinmi, noqa Diosmanta Hamuq Runaqa, sumaq k'ancharishaq tronoypi tiyayusaq, atiyniywan gobiernanaypaq. Saynallataqmi qankunapas, noqapi creesqaykichisrayku, chunka ishkayniyoq tronokunapi tiyaykullankichistaq; hinaspan Israel nación llaqtapa chunka ishkayniyoq hatun ayllunkunata juzgankichis. ");
INSERT INTO qveNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Chaymi noqaqa niykichis, pipas wasinta, wawqenta, pananta, papanta, mamitanta, warminta, wawankunata, hinallataq chakrankunatapas noqarayku saqeqmi, pachaq kuti mastaraq chashkinqa; hinallataqmi wiña-wiñaypaq kawsaytapas chashkillanqataq. ");
INSERT INTO qveNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Chaymi niykichis, kay pachapi runakuna qawananpaq importante kaq ashka runakunan, hanaq pachapiqa mana importantechu kanqaku. Ichaqa kay pachapi mana importante kaq ashka runakunañataqmi, hanaq pachapiqa aswan más importante kanqaku. ");
INSERT INTO qveNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","—Runakunata Dios gobiernayta qallarisqanqa rikch'akun huk uvas chakrayoq runamanmi. Chay runan tutallamanta lloqsispa runakunata mashkamun chakranpi llank'anankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Hinaspan chay mashkamusqan runakunawan acuerdoman haykuranku, chakranpi llank'amuqtinku huk p'unchaw jornalta pagapunanpaq. Saynata acordaruspankutaqmi, paykunataqa chakranman mandaran llank'amunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Hinallataqmi esqon horas hinaña kashaqtin chay uvas chakrayoq runaqa kaqmanta lloqsiran. Hinaspan plazapi rikuran mana llank'anayoq yanqa sayashaq runakunata. ");
INSERT INTO qveNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Chaymi paykunatapas niran: “Qankunapas riychisyá chakraypi llank'amuq; llank'asqaykichismantaqa pagapusqaykichismi”, nispa. Hinaqtinmi paykunapas chay uvas chakranman llank'aq riranku. ");
INSERT INTO qveNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Saynallataqmi chawpi p'unchaw hina horasta, hinallataq kinsa horas tarde hinaña kashaqtinpas, chay uvas chakrayoq runaqa lloqsillarantaq. Hinaspan apamullarantaq runakunata chakranpi llank'anankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Chaymantapas pishqa horas hina tardeña kashaqtinmi, chay uvas chakrayoq runaqa plazaman lloqsillarantaq. Hinaspan mana llank'anayoq yanqa sayashaq runakunata rikuspa, tapuran: “¿Imanaqtintaq qankunari mana imatapas ruwaspa, kaypi enteron p'unchaw kashankichís?” nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Chaymi chay runakunaqa contestaranku khaynata: “¡Manan ni pipas llank'apakunaykupaq pusawankuchu!” nispanku. Hinaqtinmi chay uvas chakrayoq runaqa niran: “Saynaqa qankunapas chakraypi llank'aqyá riychis; {llank'asqaykichismantaqa pagapusqaykichismi}”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Chaymantan inti haykuyushaqtinña uvas chakrayoq runaqa, capatazninta kamachispa, khaynata niran: “Llank'aqkunata waqyamuspa jornalninta pagapuy, qepallataña hamuqkunamanta qallarispa, tutamantan hamuqkunapi tukunaykikama”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Chaymi pishqa horas hina tardetaña llank'anankupaq hamuq runakuna ashuyamuqtinku, chay capatazqa huk p'unchaw jornal completota sapankamaman pagapuran. ");
INSERT INTO qveNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Chaymantañataqmi ashuyamullarankutaq, tempranomanta llank'aq runakunapas. Hinaspan paykunaqa piensaranku, chay qepa hamuq runakunamanta aswan mastaraq pagonkuta chashkinankupaq. Hinaqtinmi paykunamanpas chay capatazqa, huk p'unchaw jornal completollatataq pagapuran. ");
INSERT INTO qveNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Chaymi chay enteron p'unchaw llank'apakuq runakunaqa, chakrayoqpa contranpi rimapakuranku. ");
INSERT INTO qveNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Hinaspan chay uvas chakrayoq runata, khaynata niranku: “Kay qepallataña hamuq runakunaqa huk horallan llank'arunku. Chayri, ¿imanaqtintaq paykunamanri noqaykuman hina iguallata pagarapunkí? Noqaykuqa enteron p'unchawmi ruphaypipas pisipaspa llank'arayku. Sayna ruwasqaykiqa manan allinchu”, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Hinaqtinmi uvas chakrayoq runaqa, chay reclamaq runakunamanta huknin kaq runata, khaynata contestaran: “¡Amigo! Manan noqaqa engañashaykichu. Qanmanqa pagapushayki imaynan parlasqanchisman hinan. Icha ¿manachu noqawan acuerdopi qeparanchis, huk p'unchaw jornalta pagapunaypaq? ");
INSERT INTO qveNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Saynaqa chay pagoykita chashkikapuspa ripuy. Noqaqa imaynan huk p'unchaw jornalta qanman pagapushayki, saynallatataqmi kay qepallataña hamuq runakunamanpas, pagapuyta munani. ");
INSERT INTO qveNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ichaqa noqan yachani qolqeywan ima ruwaytapas. Icha, ¿allin runa kasqaywanchu qanqa envidiakushankí?” nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Kay willakuywan yachachiyta tukuruspanmi, Jesusqa niran: —Kay pachapi runakuna qawananpaq importante kaq ashka runakunan, hanaq pachapiqa mana importantechu kanqaku. Ichaqa kay pachapi mana importante kaq ashka runakunañataqmi, hanaq pachapiqa aswan más importante kanqaku. {Diosqa ashka runakunatan waqyan salvasqa kanankupaq, ichaqa chikallanmi akllasqa runakunaqa kanku}, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jerusalén llaqtaman rishaspankun, Jesusqa chunka ishkayniyoq discipulonkunata huk lawman waqyarispa, khaynata niran: ");
INSERT INTO qveNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Noqanchisqa Jerusalén llaqtamanmi rishanchis. Chaypin noqa Diosmanta Hamuq Runaqa entregasqa kasaq, sacerdotekunapa jefenkunaman, hinallataq leykunata yachachiq runakunaman ima. Paykunan acusawanqaku “wañuchun”, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Hinaspan huk law nacionniyoq runakunaman entregawanqaku. Chaymi paykunaqa asipayawaspanku burlakuwanqaku; hinallataq maqawanqaku ima. Chaymantataqmi cruzpi chakataspa wañuchiwanqaku. Ichaqa kinsa p'unchawmantan kawsarinpusaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Chaymantan Zebedeopa warminqa Jesusman ashuyuran ishkaynin wawankunapiwan ima. Hinaspan huk favorta mañakunanpaq Jesuspa ñawpaqninpi qonqorikuran. ");
INSERT INTO qveNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Hinaqtinmi Jesusqa payta tapuran: —¿Imatataq munankirí? nispa. Chaymi chay warmiqa khaynata niran: —Ama hina kaychu, favorniykita merecesaq, qan gobiernaspaykiyá, kay wawaykunata tiyaykachipuway, hukninta phaña ladoykipi, huknintañataq lloq'e ladoykipi, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Hinaqtinmi Jesusqa contestaspa niran: —Qankunaqa manan yachankichishchu ima mañakusqaykichistapas. Noqaqa anchatan ñak'arisaq. Ichaqa, ¿qankuna atiwaqchishchu noqa hina ñak'ariyta? nispa. Hinaqtinmi paykunañataq niranku: —Arí, atisaqkun, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Chaymi Jesusqa niran: —Cheqaqtapunin niykichis, qankunaqa noqa hinan anchata ñak'arinkichis. Ichaqa manan noqachu nisaq pis phaña ladoypi otaq lloq'e ladoypi tiyananpaqqa. Aswanmi chaypiqa tiyanqaku Papaypa akllasqan runakunalla, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Chayta uyarispankun Jesuspa chunkantin discipulonkunaqa phiñakuranku, Juanpaq hinallataq Jacobopaqwan ima. ");
INSERT INTO qveNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Chaymi Jesusqa discipulonkunata waqyaspa, khaynata niran: —Qankunaqa yachankichismi kay pacha nación llaqtakunapi gobiernaqkunaqa, llaqta runakunata kamachispankun munasqankuta ruwanku. Saynallataqmi autoridadkunapas paytukusqallaña kaspanku, llaqta runakunawanqa munasqankuta ruwanku. ");
INSERT INTO qveNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ichaqa qankuna ukhupiqa manan saynachu kanan. Aswanqa pipas qankuna ukhupi kamachiyta munaspaqa, qankunata servisuqniykichismi kanan. ");
INSERT INTO qveNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Hinallataq pipas allin reqsisqa primeropi kayta munaspaqa, qankuna ukhupiraqmi serviqniykichis runa kanan. ");
INSERT INTO qveNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Saynallataqmi noqa Diosmanta Hamuq Runaqa, manan noqata serviwanankupaqchu hamurani. Aswanqa runakunata servinaypaqmi hamurani. Hinaspapas huchasapa runakunapa rantinpi wañuspay, paykunata salvanaypaqmi noqaqa hamurani, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesusqa discipulonkunapiwan kushka Jericó llaqtamanta lloqsimushaqtinkun, ashka runakunapas Jesuspa qepanta riranku. ");
INSERT INTO qveNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Hinaqtinmi chay risqanku ñanpa patanpi, ishkay ñawsa runakuna tiyashasqaku. Chayninta Jesús pasasqanta uyariruspankutaqmi, chay ishkay ñawsa runakunaqa qaparispa, waqyakuranku khaynata: —¡Davidpa mirayninmanta Jesús, khuyapayaykuwaykuyá! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Chaymi runakunaqa phiñarikuranku, chay ñawsa runakuna upallanankupaq. Ichaqa saynata phiñarikushaqtinkupas, chay ñawsa runakunaqa astawanraqmi qapariranku khaynata: —¡Davidpa mirayninmanta Jesús, khuyapayaykuwaykuyá! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Hinaqtinmi Jesusqa chay ñan risqankupi sayaykuspa, chay ishkaynin ñawsa runakunata waqyaspa tapuran: —¿Imatataq qankunapaq ruwanaytari munankichís? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Chaymi paykunaqa contestaranku: —Señor, ñawsa kasqaykumantan sanoyayta munayku, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Chaymi Jesusqa paykunata khuyapayaspa, ñawinkuta tupayuran. Hinaqtinmi chay ratomantapacha chay ishkaynin ñawsa runakunaqa sanoyaspa rikuranku. Hinaspan Jesuspa qepanta riranku. ");
INSERT INTO qveNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jesusqa discipulonkunapiwanmi Jerusalén llaqtapa cercanpi Betfagé sutiyoq llaqtaman chayaruranku. Hinaspan Olivos moqopi samariranku. Chaypin Jesusqa ishkay discipulonkunata, ");
INSERT INTO qveNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","khaynata niran: —Riychis waq chimpapi llaqtachaman. Chayman chayaruspaykichismi watasqa asnota malta uñantinta tarinkichis. Chayta pashkamuspayá aysamunkichis. ");
INSERT INTO qveNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Sichus pipas imatapas nisunkichis chayqa, qankunaqa khaynatayá ninkichis: “Señormi necesitashan; payqa kutichinpullasunkin”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Kaykunaqa pasaran Diosmanta willakuq ñawpaq profetapa escribisqan cumplikunanpaqmi. Paymi khaynata escribiran: ");
INSERT INTO qveNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Jerusalén llaqtapi tiyaq runakunata nimuychis: ¡Qawariychis! ¡Qankunapa reyniykichismi hamushan! ¡Payqa cargana asnopa uñanpi montayukuspan hamushan! ¡Hinaspapas payqa huk humilde runa hinan hamushan!” nispa Zacarías 9.9. ");
INSERT INTO qveNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Hinaqtinmi Jesuspa kamachisqan ishkaynin discipulonkunaqa, chay llaqtachaman riranku. Chayaruspankutaqmi Jesuspa nisqanman hina ruwaranku. ");
INSERT INTO qveNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Hinaspan Jesuspa kasqanman chay asnotaqa malta uñantinta aysamuranku. Hinaqtinmi Jesuspa discipulonkunaqa p'achankuwan karunaranku. Chay asnopa uñanpi montayukuspan Jesusqa Jerusalén llaqtaman riran. ");
INSERT INTO qveNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Saynallataqmi ashka runakunapas Jesuswan kushka riranku. Hinaqtinmi wakin runakunaqa p'achankuta Jesuspa risqan ñanpi mast'aranku. Wakinñataq sach'apa ramankunata wit'umuspanku Jesuspa risqan ñanpi mast'aranku, chayninta Jesús pasananpaq. ");
INSERT INTO qveNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Hinaspan Jesuspa ñawpaqninta, hinallataq qepanta riqkunapas, altomanta qaparispa, khaynata niranku: “¡Davidpa mirayninmanta hamuq Salvadorqa, alabasqayá kachun! ¡Señor Diospa sutinpi hamuqqa alabasqayá kachun! ¡Hanaq pachapi kaqkunapas Diostayá alabachunku!” nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Hinaqtinmi Jerusalén llaqtaman Jesús haykuruqtin, llapallan chay Jerusalén llaqtapi kaq runakunaqa, Jesuspa hamusqanta rikuspanku, bullata ruwaspa ninakuranku: —¿Pitaq kay runarí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Chaymi Jesuswan kushka hamuq runakunaqa contestaranku: —Payqa Galilea provinciapi kaq Nazaret llaqtayoq Jesusmi, hinaspapas Diosmanta willakuq profetan, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jerusalén llaqtaman chayaruspanmi, Jesusqa temploman riran. Hinaspan temploman haykuspa, chaypi llapallan vendeq runakunata, hinallataq rantiqkunatapas hawaman qarqomuran. Saynallataq huk law nacionpa qolqenta templopa qolqenwan cambiaqkunapa mesankutapas pampaman wikaparan. Saynallataqmi paloma vendeqkunapa cajonninkutapas pampaman wikaparan. ");
INSERT INTO qveNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Hinaspan paykunata niran: —Diosmi Bibliapi nishan: “Temployqa noqamanta mañakunankupaq sutichasqa wasin kanqa”, nispa. Qankunan ichaqa, suwakunapa wasinman hina tukurachinkichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jesusqa templopi kallashaqtinraqmi, payman ashuykamuranku ñawsa runakuna, hinallataq wist'u runakunapas. Chaymi Jesusqa paykunata sanoyachiran. ");
INSERT INTO qveNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Hinaqtinmi templopi warmakunaqa niranku: “Davidpa mirayninmanta hamuq Salvadorqa, alabasqayá kachun”, nispanku. Chayta uyarispanku, hinallataq Jesuspa milagrokuna ruwasqanta rikuspankun, sacerdotekunapa jefenkunaqa, hinallataq leykunata yachachiq runakunapiwan ima anchata phiñakuranku. ");
INSERT INTO qveNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Hinaspan Jesusta khaynata tapuranku: —¿Manachu uyarinki kay warmakuna imatachus nishanku chayta? nispanku. Jesusñataqmi contestaran: —Arí, allintan uyarishani. Qankunari, ¿manachu Bibliapi leerankichis: “Uchuy warmakunan, ñuñuq wawakunapiwan ima alabasunki”, nisqanta? nispa Salmos 8.2. ");
INSERT INTO qveNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Chayta niruspanmi Jesusqa, paykunata saqespa Jerusalén llaqtamanta Betania llaqtaman riran. Hinaspan Jesusqa chay tuta chay Betania llaqtapi samapakuran. ");
INSERT INTO qveNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Jesusqa Jerusalén llaqtamanmi achiqayllata kutimuran. Hinaspan ñan hamusqanpi yarqachikuran. ");
INSERT INTO qveNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Chaymi Jesusqa ñan patapi huk higos sach'ata rikuruspa ashuyuran. Ichaqa manan ni ima ruruntapas chay sach'apiqa tariranchu. Aswanmi chay sach'aqa rap'iyoqlla kasqa. Chaymi Jesusqa chay sach'ata niran: —¡Kunanmantaqa manañan ni hayk'aqpas rurunkiñachu! nispa. Chaymi chay higos sach'aqa kasqan ratolla ch'akipuran. ");
INSERT INTO qveNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Chayta rikuspankun Jesuspa discipulonkunaqa admirasqallaña tapuranku: —¿Imanaqtintaq kay higos sach'ari kasqan ratolla ch'akirparin? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Hinaqtinmi Jesusqa contestaran: —Cheqaqtapunin niykichis, sichus qankuna Diospi creenkichis mana ishkayaspa chayqa, (chashkinkichispunin oracionpi mañakusqaykichistaqa. Hinaspapas qankunaqa), imatachus kay higos sach'awan ruwarani, chaymantapas aswan mastaraqmi ruwankichis. Hinaspapas niwaqchismi kay orqotapas “Ayqeriy kaymanta, hinaspa lamar qochaman wikch'uyukuy”, nispa, hinaqtinqa kay orqopas kasusunkichismi. ");
INSERT INTO qveNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Saynallataq sichus cheqaqtapuni Diospi creespaykichis qankuna imatapas mañakunkichis chayqa, chashkinkichismi, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesusqa temploman haykuspanmi runakunaman yachachisharan. Hinaqtinmi sacerdotekunapa jefenkunaqa, hinallataq Israel nacionpi autoridadkunapiwan ima, Jesusman ashuyuspa tapuranku: —Kaykunata ruwanaykipaqri, ¿pitaq qantari autorizasurankí? Hinaspapas kay atiytari, ¿pitaq qosurankirí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Hinaqtinmi Jesusqa contestaran: —Noqapas kunanmi qankunata tapullasqaykichistaq. Sichus qankuna contestawankichis chayqa, noqapas nisqaykichismi, ima atiywansi kaykunata ruwani chayta. ");
INSERT INTO qveNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Kunanyá niwaychis, runakunata Juan bautizananpaqri, ¿pitaq mandamuran? ¿Dioschu icha runakunallachú? nispa. Saynata Jesús tapuqtinmi, paykunapura tapunakuranku khaynata: —“Diosmi mandamuran” nisunchis chayqa, niwasunchá, “¿imanaqtintaq Juanpa nisqantari mana creerankichishchú?” nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Sichus “runakunallan mandamuran” nisunchis chayqa, llapallan llaqta runakunachá noqanchispa contranchispi sayarimunkuman. Hinaspapas paykunaqa yachankun, Juanqa Diosmanta willakuq profeta kasqanta, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Chaymi paykunaqa Jesusta contestaranku khaynata: —Manan yachaykuchu, nispanku. Hinaqtinmi Jesuspas nillarantaq: —Noqapas manan nisqaykichishchu ima atiywansi kaykuna ruwasqaytaqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesusqa nillarantaqmi: —Qankunari, ¿ima niwaqchistaq kay willakuymantarí? Huk runan ishkay wawayoq karan. Hinaspan kuraq wawanta niran: “¡Waway! kunan p'unchawyá uvas chakranchispi llank'aq riruy”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Chaymi chay kuraq wawanqa contestaran: “¡Manan riymanchu!” nispa. Ichaqa chay kuraq wawanqa, tumpa unaymanta yuyaymanarispanmi, “manan riymanchu” nishaspanpas, chay uvas chakraman llank'aq riran. ");
INSERT INTO qveNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Saynallataqmi chay runaqa sullk'a kaq wawantapas nillarantaq: “¡Wawáy! kunan p'unchawyá uvas chakranchispi llank'aq riruy”, nispa. Hinaqtinmi chay wawanqa niran: “¡Arí papáy! Risaqmi”, nispa. Ichaqa “arí” nishaspanpas, manan payqa riranchu. ");
INSERT INTO qveNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Chayta willaspanmi Jesusqa tapuran chay runakunata: —¿Mayqen kaq wawantaq papanpa kamachisqanman hina ruwaranrí? nispa. Chaymi sacerdotekunapa jefenkunaqa, hinallataq Israel nacionniyoq runakunapa kamachiqnin runakunapiwan contestaranku: —Kuraq kaq wawanmi, nispanku. Hinaqtinmi Jesusñataq niran: —Cheqaqtapunin niykichis, impuesto cobraq runakuna, hinallataq qenlli vidapi puriq huchasapa warmikuna iman, Diospa gobiernasqan sumaq glorianmanqa qankunamanta primerta haykunqaku, (huchankumanta wanakusqankurayku). ");
INSERT INTO qveNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ichaqa Bautizaq Juan hamuspanmi qankunata yachachisurankichis, Diosta imaynata kasukunaykichispaq. Ichaqa qankunañataqmi Bautizaq Juanpa yachachisqankunapi mana creerankichishchu. Aswanqa Roma llaqtapaq impuesto cobraq runakuna, hinallataq millay qenlli vidapi puriq huchasapa warmikuna iman Bautizaq Juanpa rimasqanpiqa creeranku. Qankunañataqmi ichaqa tukuy chaykunata rikushaspaykichispas, Bautizaq Juanpa willakusqanpiqa mana creerankichishchu; nitaq huchaykichistapas saqerankichishchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jesusqa nillarantaqmi: —Uyariychis kay huk willakuyta. Huk chakrayoq runan chakranpi uvas plantakunata plantaran. Hinaspan chay chakranpa enteron muyuriqninta cercochiran. Hinallataqmi uvas pallamusqanmanta vinota ruwachinanpaqpas, huk uvas saruna pozota, hinallataq huk hatun torretawan ima ruwachiran. Chay torretaqa ruwachiran, chay torre patamanta enteron chakranta qawaspa cuidananpaqmi. Chaykunata ruwaruspanmi, chay uvas chakrapa dueñonqa huk runakunaman arrendaruspa, karu llaqtaman viajaran. ");
INSERT INTO qveNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Hinaqtinmi uvas cosechana tiempo chayaramuqtin, chay uvas chakrayoq runaqa, serviqnin runakunata mandamuran, chay chakrata arrendaq runakunamanta dueñonman tupaqninta chashkispa apapunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ichaqa chakra arrendaq runakunañataqmi, chay uvas chakrayoqpa mandamusqan sirvienten runakunata, khaynata ruwaranku: Huknintan maqaranku, huknintañataq wañuchiranku, huknintañataqmi rumikunawan p'anaranku. ");
INSERT INTO qveNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Hinaqtinmi chay uvas chakrayoq runaqa, kaqmanta mandamullarantaq primer kaq mandamusqan sirvientenkunamantapas aswan más ashka sirvientekunataña. Ichaqa chay uvas chakrata arrendaq runakunañataqmi, imaynan primer kaq hamuq sirvientekunata maqaranku, p'anaranku hinallataq wañuchiranku ima, saynallatataqmi paykunatapas ruwaranku. ");
INSERT INTO qveNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Chaykuna pasaruqtinmi, chay uvas chakrayoq runaqa wawantañataq mandamuran, khaynata yuyaymanaspa: “Wawayta rikuspaqa ichapas respetankuman” nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ichaqa chay uvas chakra arrendaq runakunaqa, chay chakrayoqpa wawan chayamusqanta rikuruspankun, ninakuranku khaynata: “¡Kay runaqa chakrayoqpa wawanmi! Paymi kay herenciata chashkinqa. Saynaqa aswanyá wañurpachillasunña, kay chakrawan noqanchis qepakunanchispaq”, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Saynata piensaspankun, paykunaqa chay uvas chakrayoqpa wawanta hap'iranku. Hinaspan chay chakra ukhumanta hawaman orqomuspa, chaypi wañuchiranku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Saynata niruspanmi Jesusqa tapuran: —Uvas chakrapa dueñon hamuspanri, ¿imatataq ruwanqa chay chakran arrendaq runakunawanrí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Chaymi llapallan chaypi uyariq runakunaqa contestaranku khaynata: —Chay runakunataqa mana khuyapayaspan wañuchinqa, millay yana alma runakuna kasqankurayku. Hinaspan chay uvas chakrantaqa huk runakunamanñataq arrendanqa, saynapi tupaqnin cosechata tiempollanpi qopunankupaq, nispa. Nota: chay chakrayoq dueñoqa, Dios Taytan. Chay chakrayoqpa wawanñataqmi, Señorninchis Jesucristo. Dueñopa serviqninkuñataqmi, Diosmanta willakuq profetakuna. Chakrata arrendaq runakunañataqmi, fariseo religionniyoq runakuna. Saynata comparaspanmi Jesucristoqa yachachiran. ");
INSERT INTO qveNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Hinaqtinmi Jesusqa paykunata niran: Qankunari, ¿manachu Bibliata leerankichís? Bibliapiqa khaynatan nishan: “Albañilkunapa mana munasqan rumin, kunanqa aswan más allin kaq rumi, wasiq esquinanpi allinta enteron wasipa perqanta sostienen. Kayqa Diosninchispa ruwasqanmi. Hinaspapas kay qawasqanchisqa anchata admirakunapaqmi”, nispa Salmos 118.22-23. ");
INSERT INTO qveNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Chayraykun niykichis, Diospa gobiernasqan sumaq glorianmanqa manan qankunaqa haykunkichishchu. Ichaqa Diospa gobiernasqan sumaq glorianmanqa haykunqaku Diosta kasukuspa, paypa munasqanman hina kawsaq runakunallan. ");
INSERT INTO qveNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","{Chaymi pi runapas chay rumi hawaman urmayuspaqa, ñut'usqa kanqa. Saynallataqmi pi runapa hawanmanpas chay rumi urmayuspaqa, kutasqa aychaman hinaraq chay runataqa tukuchinqa}, nispa. Nota: Chay albañilkunapa mana munasqanku rumiqa, Jesucriston. ");
INSERT INTO qveNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kay willakuykunata uyarispankun sacerdotekunapa jefenkunaqa, fariseo religionniyoq runakunapiwan ima cuentata qokuranku, chay millay wañuchiq runakunaman comparaspa, paykunamanta Jesús rimasqanta. ");
INSERT INTO qveNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Chaymi Jesustaqa hap'iruytapuni munaranku. Ichaqa chaypi kaq runakunata manchakuspankun mana atirankuchu. Hinaspapas chaypi kaq runakunaqa yacharankutaqmi, Jesusqa Diosmanta willakuq profeta kasqanta. ");
INSERT INTO qveNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesusqa kay willakuykunatan willaran Israel nación llaqtapi kamachiq runakunaman, Hinaspan khaynata niran: ");
INSERT INTO qveNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Runakunata Dios gobiernayta qallarisqanqa rikch'akun, huk rey qari wawanta casarachispa, fiestata ruwaq runamanmi. ");
INSERT INTO qveNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Hinaspan sirvienten runakunata kamachiran, casarakuy fiestaman invitasqan runakunata waqyamunankupaq. Ichaqa chay invitasqan runakunañataqmi, hamuyta mana munarankuchu. ");
INSERT INTO qveNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Hinaqtinmi chay reyqa kaqmanta huk sirvienten runakunatañataq kamachiran, invitasqan runakunata khaynata nimunankupaq: “Ñan wirayachisqa torokunatapas, hinallataq wakin wirayachisqa animalkunatapas ñak'arachiniña. Chaymi mikhunapas listoña kashan. Chayqa hamuychisyá kay casarakuy fiestapi mikhunaykichispaq”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ichaqa chay invitasqan runakunaqa manan hamurankuchu. Aswanmi paykunaqa sapankamanku pasakuranku. Hukninmi chakranman llank'aq pasaran, huknintaqmi negocionta atiendeq, ");
INSERT INTO qveNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","wakinñataqmi reypa serviqnin runakunata hap'ispa, maqashaspalla wañuchiranku. ");
INSERT INTO qveNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Chaymi chay reyqa nishuta phiñakuran. Hinaspan soldadonkunata kamachiran, chay wañuchiq runakunata wañuchimuspanku, llaqtankutapas k'anamunankupaq ima. ");
INSERT INTO qveNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Chaymantan chay reyqa serviqnin runakunata niran: “Wawaypa casarakunanpaqqa tukuy imapas listoñan kashan. Ichaqa chay invitamusqay runakunaqa, manan kay fiestaman hamunankupaq hinañachu kanku. ");
INSERT INTO qveNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Aswanqa kunanyá riychis callekunaman; hinaspa llapallan chaypi tarimusqaykichis runakunata, wawaypa casarakuynin fiestaman hamunankupaq invitamuychis”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Chaymi reypa sirvienten runakunaqa, callekunaman lloqsispanku, llapallan tarisqanku runakunata invitaspa pusamuranku, allin kaqta ruwaspa kawsaq runakunata, hinallataq huchapi kawsaq runakunatapas. Chaymi casarakuqpa wasinmanqa, ashka runakuna hunt'aykamuranku. ");
INSERT INTO qveNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Hinaqtinmi chay reyqa invitachimusqan runakunata qawaq haykuspa, chaypi huk mana allin cambiasqa runata rikuran. ");
INSERT INTO qveNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Chaymi chay runata niran: “Amigo, mana allin cambiasqa kashaspaykiri, ¿imanaqtintaq kaymanri haykuramurankí?” nispa. Hinaqtinmi chay runaqa ni imatapas mana contestaspa upallalla karan. ");
INSERT INTO qveNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Hinaqtinmi chay reyqa serviqnin runakunata khaynata kamachiran: “Kay mana allin cambiasqa runataqa, makinkunata chakinkunatawan chaqnaruspayá, tutayaq ukhuman wikch'uyamuychis. Chay tutayaqpin runakunaqa waqanqaku, hinallataq nanaymanta kirunkupas rach'ikyanqaraq. ");
INSERT INTO qveNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ichaqa ashkallañan Diospi creenankupaq invitasqa runakunaqa kashanku. Aswanqa chikallanmi akllasqa runakunaqa kanku”, nispa. Nota: fiestaman invitachimuq reyqa, Dios Taytan. Casarakuq qariqa, Jesucriston. Fiestaman mana hamuy munaq runakunaqa, Jesucristopi mana creey munaq Israel nacionniyoq runakunan. Fiestaman tukuy clase huchasapa hamuq runakunaqa, Jesucristopi llapallan creeq runakunan. Hinallataq fiestapi mana allin cambiasqa runaqa, manan wakcha runachu karan; aswanqa Jesucristota mana respetaq runan karan. ");
INSERT INTO qveNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Chaymantan fariseo religionniyoq runakunaqa, huk p'unchaw huñunakuspanku, acuerdota ruwaranku. Hinaspan acordaranku ima rimasqallanpipas Jesusta pantachispa acusanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Hinaspan chay fariseo religionniyoq runakunaqa qatikuqnin runakunata, hinallataq Herodespa partidonmanta kaq runakunatawan ima mandaranku, Jesusta khaynata ninankupaq: —Yachachikuq, noqaykuqa yachaykun cheqaq kaqkuna rimasqaykitaqa. Hinaspapas qanqa Diosmantan runakunaman yachachishanki allinta kasukuspa kawsanankupaq. Hinaspapas yachachisqaykimanta runakuna contraykipi rimaqtinkupas manan qanqa kasunkichu. Hinaspapas qanqa manan runakunawan allinpi qepanallaykipaqchu rimankipas. Aswanqa llapanmanmi igualta yachachinkipas, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Hinaspan paykunaqa tapuranku khaynata: —Qanri, ima ninkitaq, ¿allinchu Roma llaqtamanta gobiernawaqninchis Cesarman impuestokunata pagananchispaq, icha manachú? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesusñataqmi ichaqa mana allin intencionllawan tapusqankuta yachaspa, khaynata niran: —¡Ishkay uya runakuna! ¿Imanaqtintaq qankunari pantachiwayta munashankichís? ");
INSERT INTO qveNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Apamuychis impuesto paganaykichis qolqeta, nispa. Chaymi huk qolqeta Jesusman haywaranku. ");
INSERT INTO qveNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Hinaqtinmi Jesusqa chay qolqeta paykunaman qawachispa tapuran: —Kay qolqepiri, ¿pipa uyantaq, hinaspapas pipa sutintaq kashan? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Paykunañataqmi khaynata contestaranku: —Roma llaqtapi gobiernaq rey Cesarpan, nispanku. Saynata niqtinkun Jesusqa niran: —Saynaqa rey Cesarpa kaqtaqa payman qopuychis. Hinallataq Diospa kaqtapas Diosman qopuychis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Hinaqtinmi Jesuspa nisqanta uyarispanku, chay runakunaqa anchata admirakuspa pasapuranku. ");
INSERT INTO qveNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Chay p'unchawllataqmi wakin saduceo religionniyoq runakunaqa Jesusman hamuranku. Paykunaqa manan wañuqkunapa kawsarimunanpiqa creerankuchu. Chayraykun Jesusta tapuranku khaynata: ");
INSERT INTO qveNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Yachachikuq, Moisespa escribisqan leypin niwanchis: “Huk runa casarakuspa, warminpi manaraq wawayoq kashaspa wañupunman chayqa, sullk'a wawqenmi, chay viuda warmiwan casarakuspa wawayoq kanan. Hinallataqmi chay wawa nacemuqpas, wañuqpa wawan hina kananpaq chay wañuqpa sutinta apanan, saynapi wañuqpa sutin mana chinkananpaq”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Saynallataqmi llaqtaykupipas qanchis wawqekuna karan. Hinaspan kuraq kaqqa casararukuspa, manaraq wawayoq kashaspa wañupuran. Chaymi wañuqpa viudanwan casarakullarantaq chay wañuqpa sullk'an. ");
INSERT INTO qveNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Saynallataqmi huk tiempo pasaruqtin, paypas manaraq wawan kashaqtin wañupuran. Saynallataqmi pasaran kinsa kaqwanpas, tawa kaqwanpas, pishqa kaqwanpas, soqta kaqwanpas, hinallataq qanchis kaqwanpas. ");
INSERT INTO qveNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Chaymantañataqmi chay qanchisnintin wawqekunapa wañusqanpa qepanman, chay viuda warmipas wañupullarantaq. ");
INSERT INTO qveNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Chayqa kunanyá niwayku, llapallan wañuqkunata Dios kawsarichimuqtinri, ¿mayqenpa warmintaq kanqa chay warmirí? Qanchisnintinwanmi chay warmiqa casarasqa karan, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Hinaqtinmi Jesusqa paykunata contestaran khaynata: —Qankunaqa pantashankichismi, Bibliapi escribisqakunata mana yachaspaykichis, hinallataq Diospa atiynintapas mana reqsispaykichis. ");
INSERT INTO qveNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ichaqa wañuqkunata Dios kawsarichimuqtinqa, manañan casarakuyqa kanqañachu. Aswanqa Diospa angelninkuna hinan hanaq pachapiqa mana ni pipas casarakunqachu. ");
INSERT INTO qveNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ichaqa wañuqkunapa kawsarimunankumantari, ¿manachu qankuna Bibliapi leerankichis Diospa nisqanta? Diosqa khaynatan niran: ");
INSERT INTO qveNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Noqan kani Abrahampa, Isaacpa, hinallataq Jacobpa Diosnin”, nispa. Paykunaqa wañusqa kashaspankupas, Diospaqqa kawsashankun. Chayraykun Diosqa llapallan wañusqa runakunapapas Diosnin, paykunapa almanku kawsasqanrayku. Saynallataqmi Diosqa kawsaq runakunapapas Diosnin, nispa. Nota: Diosqa paypi creespa wañuq runakunapa Diosninmi, hinallataq Salvadornin ima. Saynallataqmi Diospi mana creeq runakunapapas Diosnin, ichaqa manan Salvadorninchu. ");
INSERT INTO qveNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Saynata Jesuspa yachachisqankunata uyarispankun chaypi kaq runakunaqa anchata admirakuranku. ");
INSERT INTO qveNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jesusmi saduceo religionniyoq runakunata upallachiran. Chayta yacharuspankun, fariseo religionniyoq runakunaqa huñunakuranku Jesuswan parlaq rinankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Hinaspan leykunamanta allinta yachaq huknin kaq fariseo religionniyoq runa, Jesusta pantachiyta munaspa, tapuran khaynata: ");
INSERT INTO qveNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Yachachikuq, Diospa kamachisqankunamantari, ¿mayqen kaq kamachikuytaq aswan más importanterí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Hinaqtinmi Jesusqa niran: —“Señor Diosniykita munakuy tukuy sonqoykiwan, tukuy almaykiwan, hinallataq tukuy piensayniykiwan ima”. ");
INSERT INTO qveNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kay primer kaq kamachikuymi wakin kamachikuykunamantaqa aswan más importante. ");
INSERT INTO qveNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Saynallataqmi ishkay kaq kamachikuypas, kay primer kaq kamachikuyman rikch'akun. Chaymi khaynata nin: “Runamasiykita khuyakuy qan kikiykita hina”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Chaymi niykichis, kay ishkaynin kamachikuypin cumplikun, Moisespa escribisqan leykunapas, hinallataq Diosmanta willakuq ñawpaq profetakunapa yachachisqankunapas, nispa Deuteronomio 6.5; Levítico 19.18. ");
INSERT INTO qveNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseo religionniyoq runakuna huñunasqa kashaqtinkuraqmi, Jesusqa paykunata tapuran khaynata: ");
INSERT INTO qveNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—Qankunari, ¿pin ninkichistaq Diosmanta Hamuq Salvadortarí? ¿Pipa wawanmi ninkichistaq? nispa. Hinaqtinmi paykunaqa contestaranku khaynata: —Ñawpaq rey Davidpa mirayninmantan, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Hinaqtinmi Jesusqa kaqmanta tapuran: —Davidta Santo Espíritu rimachiqtinri, ¿imanaqtintaq payri, Cristomanta rimaspa niran: “Señorniymi”, nisparí? Ichaqa kikin rey Davidmi, ancha respetasqa runa kashaspapas, khaynata niran: ");
INSERT INTO qveNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Señor Diosmi Señorniyta niran: ‘Phaña ladoypi tiyaykuy, llapallan enemigoykikunata noqa vencespay, chaki plantaykiman churanaykama’ ”, nispa Salmos 110.1. ");
INSERT INTO qveNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Hinaspapas kikin rey Davidpunin niran: “Señorlláy”, nispa. Chayri, ¿imanaqtintaq Diosmanta Hamuq Salvadorqa ñawpaq rey Davidpa mirayninmanta kanman? nispa. Nota: Davidpa mirayninmantan nacenan karan Diosmanta Hamuq Salvador Cristoqa. Chayta yachaspanmi Davidqa ña niranña: “Señorlláy” nispa. Saynataqa niran, Diosmanta Hamuq Salvadorqa, paymanta más atiyniyoq kananta yachaspanmi. ");
INSERT INTO qveNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Saynata Jesús tapuqtinmi, mana ni mayqenninkupas ni imaynanmantapas contestayta atirankuchu. Hinaspan chay p'unchawmantapacha Jesustaqa manaña ni pipas ni imamantapas tapurankuñachu. ");
INSERT INTO qveNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jesusmi discipulonkunata hinallataq chaypi kaq runakunatapas, khaynata niran: ");
INSERT INTO qveNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Moisespa escribisqan leykunata yachachinankupaqqa autorizasqa karanku, fariseo religionniyoq runakuna, hinallataq leykunata yachachiq runakunallapiwanmi. ");
INSERT INTO qveNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Chaymi qankunaqa paykunapa yachachisqanta, sonqoykichispi waqaychaspa kasukunaykichis. Ichaqa amataqyá paykunapa imapas ruwasqankutaqa qatipakunkichishchu. Paykunaqa manan yachachisqankutaqa ruwayman churankuchu. ");
INSERT INTO qveNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Hinaspapas paykunaqa runakuna cumplinanpaqmi sasa kamachikuykunata kamachinku. Ichaqa manan ni huk dedollankuwanpas yanapankuchu chay kamachisqankuta runakuna cumplinankupaqqa. ");
INSERT INTO qveNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Paykunaqa runakuna rikunallanpaqmi imatapas ruwanku. Chaymi llapallan runakuna rikunanpaq, qaramanta ruwasqa p'alta cintakunapi Bibliamanta textokunata escribispanku, mat'enkupi hinallataq brazonkupi watakunku. Hinallataqmi allin adornasqa k'ancharishaq p'achakunawan p'achakunkupas, (saynapi runakuna rikuspa “waq runaqa Diosta kasukuqmi”, nispa ninankupaq). ");
INSERT INTO qveNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Hinaspapas paykunaqa Diosmanta yachachina sinagoga wasiman rispankupas, otaq fiestakunaman mikhunankupaq rispankupas, sumaq atiendesqa kaytan munanku. Hinallataqmi allinnin asientokunallapi tiyaytapas munanku. ");
INSERT INTO qveNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Hinaspapas paykunaqa mercadokunapipas runakuna ancha respetowan rimayukuspa “yachachikuq”, nispa ninankutan munanku. ");
INSERT INTO qveNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Qankunaqa amayá saynachu kaychis. Qankunaqa amayá permitiychishchu runakuna “yachachikuq” nispa nisunaykichistaqa. Yachachiqniykichisqa noqallan kani, hanaq pachamanta hamuq Cristo kasqayrayku. Chaymi qankunaqa llapaykichispas wawqentin hinalla kankichis. ");
INSERT INTO qveNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Hinaspapas qankunaqa amayá kay pachapiqa ni pi (yachachikuq) runatapas ninkichishchu: “Taytay” nispaqa. Qankunapa cheqaq Dios Taytaykichisqa ch'ullallan. Payqa hanaq pachapin kashan. Nota: Kay textopi “Taytay” nisqanqa manan rimashan kay pachapi papanchismantachu. Aswanqa rimashan Diospa sutinta oqarispa “Padre” nispa kay pachapi sutichakuq runakunamantan. ");
INSERT INTO qveNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Qankunaqa amayá permitiychishchu “Kamachikuq” nispa runakuna nisunaykichistaqa. Qankunapaqqa, noqa Diosmanta Hamuq Salvadorllan kamachiqniykichisqa kani. ");
INSERT INTO qveNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Qankuna ukhupi aswan más importante kaq runaqa, llapaykichista serviqninmi kanan. ");
INSERT INTO qveNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Pipas paytukusqa kaspa wakinninmanta aswan más importante kayta munaqqa, humillasqan kanqa. Ichaqa pipas humillakuspa wakinninta serviqmi, hatunchasqa kanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ay, ¡imaynaraq kankichis ishkay uya fariseo religionniyoq runakuna, hinallataq leykunata yachachiq runakunapas! Qankunaqa manan dejankichishchu runakuna Diospa gobiernasqan sumaq glorianman haykunantaqa. Nitaqmi qankunapas haykunkichishchu, nitaq wakintapas haykunanta munankichishchu. { ");
INSERT INTO qveNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ay, ¡imaynaraq kankichis ishkay uya fariseo religionniyoq runakuna, hinallataq leykunata yachachiq runakunapas! Qankunaqa viudakunapa wasintan qechushankichis. Saynata ruwashaspapas una-unaytaraqmi orakushankichis, allin runakuna hina rikusqa kanaykichispaq. Chayraykun qankunaqa ancha-ancha castigasqa kankichis}. ");
INSERT INTO qveNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ay, ¡imaynaraq kankichis ishkay uya fariseo religionniyoq runakuna, hinallataq leykunata yachachiq runakunapas! Qankunaqa tukuy lawman rispaykichismi, religionniykichisman iñinanpaq runakunata rimapayamushankichis. Chay runakunata convencerachispan infiernoman pusashankichis, qankunamanta ishkay kuti mastaraq castigasqa kanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ay, ¡imaynaraq kankichis runakunata pusaq ñawsakuna! Qankunan ninkichis: “Sichus pipas templopa sutinta oqarispa juramentota ruwaqqa, chay juramento ruwasqantaqa dejallanmanmi. Ichaqa sichus pipas templo ukhupi qori waqaychasqankupa sutinpi juramentota ruwaqmi, cumplinanpuni”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Qankunaqa mana yuyayniyoq ñawsakunan kankichis! Diospaq separasqa qoriqa, templo ukhupi kasqanraykullan ch'uyanchasqa. Ichaqa Dios yupaychana templon aswan más importante chay templo ukhupi qorimantaqa, chay qorita ch'uyanchasqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Hinaspapas qankunaqa nillankichistaqmi khaynata: “Sichus pipas altarpa sutinta oqarispa juramentota ruwaqqa, chay juramento ruwasqantaqa dejallanmanmi. Ichaqa sichus pipas altarpa hawanpi ofrenda waqaychasqankupa sutinpi juramentota ruwaqmi, cumplinanpuni”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Mana yachayniyoq ñawsakuna! ¿Mayqentaq aswan más importanteri, ofrendachu icha Diospaq ofrendata churana altarchú? Ofrendamanta aswan más importanteqa Diospa altarninmi. ");
INSERT INTO qveNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Pipas altarpa sutinpi juramentota ruwaspaqa, manan altarllamantachu juramentotaqa ruwashan, aswanqa altarpa hawanpi kaqkunamantawanmi. ");
INSERT INTO qveNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Hinallataq, sichus pipas templorayku juramentota ruwaspaqa, manan templollamantachu juramentotaqa ruwashan. Aswanqa Diosmantawanmi juramentotaqa ruwashan, chay templopi Diospa presencian kasqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Saynallataqmi hanaq pachapa sutinpi juramentota ruwaqpas, Diospa tiyanan trononmantawan, hinallataq chay tronopi tiyaq Diosmantawanmi juramentotaqa ruwashan. ");
INSERT INTO qveNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ay, ¡imaynaraq kankichis ishkay uya fariseo religionniyoq runakuna, hinallataq leykunata yachachiq runakunapas! Qankunan diezmota qonkichis yerba buenamanta, anismanta, hinaspa cominosmantawan ima. Ichaqa Diospa kamachisqankunataqa manataqmi ruwaymanqa churankichistaqchu. Diosqa kamachiranmi khaynata: “Runamasiykichispa favorninpi imatapas allinta ruwaychis. Ancha khuyapayakuq kaychis. Hinallataq Diospa kamachikusqankunatapas llapanta kasukuychis”, nispa. Kay kinsantin kamachikuykunatan ruwanaykichis, wakin kamachikuykunatapas mana qonqaspalla. ");
INSERT INTO qveNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Runakunata pusaq ñawsakuna! ¡Qankunaqa tomanaykichisman urmaykuq ch'uspichatapas suysunkichismi. Caballomantapas aswan más hatunkaray camello animaltan ichaqa, enterollanta millp'unkichis! Nota: Israel nacionniyoq runakunapaqqa ch'uspipas, hinallataq camello animalpas mana mikhuna animalkunan karanku, leypi prohibisqa kasqanrayku. Chay ch'uspiwanmi Jesusqa comparachiran uchuy kaq kamachikuy leykunata; chay camello animalwantaqmi Jesusqa comparachiran hatun kaq kamachikuy leykunata. Paykunan Moisespa leyninkunamanta chay ch'uspi hina uchuy kamachikuykunata allinta cumplinankupaq preocupakuranku. Ichaqa chay camello hina hatun kamachikuykunata cumplinankupaqtaqmi mana preocupakurankuchu. ");
INSERT INTO qveNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ay, ¡imaynaraq kankichis ishkay uya fariseo religionniyoq runakuna, hinallataq leykunata yachachiq runakunapas! Qankunaqa tazatapas platotapas hawallantan maqchinkichis. Ichaqa ukhunñataqmi qenllillaña kashan. Saynallataqmi qankunaqa runakuna rikunallanpaq allin cambiasqa kashankichis. Ichaqa sonqoykichistaqmi ancha qenllillaña kashan, suwakusqaykichiskunawan, hinallataq mana allin ruwasqaykichiskunawan ima. ");
INSERT INTO qveNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Fariseo religionniyoq ñawsa runakuna! Primertaqa tazatapas platotapas ukhuntaraqyá allinta maqlliychis, saynapi hawanpas ukhunpas limpio kananpaq. ");
INSERT INTO qveNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ay, ¡imaynaraq kankichis ishkay uya fariseo religionniyoq runakuna, hinallataq leykunata yachachiq runakunapas! Qankunaqa, runakuna qawarinallanpaqmi sumaq cambiasqa kashankichis, imaynan panteonpi nichupa hawanpas sumaq yuraqwan pintasqa hina. Ukhuykichistaqmi ichaqa wañusqakunapa tullunwan, hinallataq tukuy qenllikunawan hunt'asqa kashan. ");
INSERT INTO qveNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Qankunaqa llapallan runapa rikunallanpaqmi, allinta imatapas ruwaq tukushankichis. Sonqoykichispin ichaqa ishkay uya mana allin ruwaq runakuna kashankichis. ");
INSERT INTO qveNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ay, ¡imaynaraq kankichis ishkay uya fariseo religionniyoq runakuna, hinallataq leykunata yachachiq runakunapas! Qankunaqa Diosmanta willakuq ñawpaq profetakunapa p'ampakusqan sepulturankunapa hawanpin sumaq perqakunata hatarichishankichis. Hinallataq allin justo runakunapa sepulturankunatan sumaqta adornashankichis. ");
INSERT INTO qveNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Hinaspapas qankunaqa ninkichismi khaynata: “Sichus chay profetakunapa tiemponpi kawsaykuman karan chayqa, manan noqaykuqa permitiykumanchu karan, chay ñawpaq profetakunata, wañuchinankutaqa”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ichaqa, saynata nishaspaykichispas, qankunaqa chay ñawpaq profetakunata wañuchiq runakunawan igualmi kashankichis. ");
INSERT INTO qveNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Qankunapas tukupaychisyá, profetakunata wañuchiq ñawpaq runakunapa qallarisqanta! ");
INSERT INTO qveNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Mach'aqwaypa miraynin hina runakuna! (Qankunaqa llulla runakunan kankichis. Mach'aqwaypa venenon hinan qankunapa simiykichismantaqa lloqsimun). Chaymi niykichis, ¡qankunaqa nina rawray infiernomantaqa manan ayqekunkichishchu! ");
INSERT INTO qveNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Noqan mandamusaq qankunaman Diosmanta willakuq profetakunata, ancha yachayniyoq runakunata, hinallataq Diosmanta yachachiq runakunatapas. Ichaqa paykuna hamuqtinmi, wakintaqa qankuna wañuchinkichis, otaq cruzkunaman chakatankichis. Wakintataqmi sinagoga wasikunapi p'anankichis. Wakintañataqmi llaqtan-llaqtan qatikachankichis. ");
INSERT INTO qveNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Chayraykun qankunaqa allin runakunata kay pachapi wañuchisqaykichismanta culpayoq kankichis, Cainpa wawqen Abelmanta qallarispa asta Berequiaspa wawan Zacarías profetapa wañuchisqankukama. Zacarías profetaqa wañuchisqa karan, sacrificio ruwana altarmanta temploman haykuna punkuq ladonpin. ");
INSERT INTO qveNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Cheqaqtapunin niykichis, chay llapallan castigokunaqa kunan tiempopi kawsaq runakunamanmi chayamusunkichis profetakunata wañuchisqaykichisrayku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jerusalén llaqtata qawarispanmi Jesusqa niran: —Ay, ¡Jerusalén llaqtapi tiyaq runakuna! ¡Qankunan Diosmanta willakuq profeta runakunata wañuchirankichis! ¡Saynallataqmi qankunaqa Diospa mandamusqan runakunatapas rumiwan p'anashaspalla wañuchirankichis! ¡Noqaqa maytan munarani qankuna huñuykuyta, imaynan huk wallpapas chiwchichankunata raphran ukhupi huñuykun chay hinata! Ichaqa manan munarankichishchu huñuykunaytaqa. ");
INSERT INTO qveNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Chayraykun Diosta yupaychanaykichis templopas, hinallataq llaqtaykichispas, wasiykichispas wikch'usqa kanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Cheqaqtapunin niykichis, manañan rikuwankichishñachu kutimunay tiempo chayamunankama. Chay tiempo chayamuqtinñan ninkichis: “Alabasqayá kachun Diospa Sutinpi Hamuq Salvadorqa”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jerusalén llaqtapi templomanta lloqsiruspa Jesús rishaqtinmi, discipulonkuna payman ashuyuranku. Hinaspan chay templopa sumaqllaña perqankunata qawachiranku. ");
INSERT INTO qveNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Chaymi Jesusqa discipulonkunata khaynata niran: —¿Rikushankichishchu kay templopa perqankunata? Cheqaqtapunin niykichis, kay llapallan rikusqaykichiskunan thuñichisqa kanqa. Manan ni ch'ulla rumillapas perqasqaqa qepanqachu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Chayta nispanmi, Jesusqa Olivos nisqa moqoman discipulonkunapiwan riran. Chaypi tiyayuqtinmi, discipulonkunaqa sapallanpiña Jesusta tapuranku khaynata: —Niwaykuyá, ¿hayk'aqtaq chay niwasqaykikuri pasanqa? ¿Imaynanpitaq yachasaqku qanpa kutimunaykita, hinallataq kay pachapa tukukuynintarí? ¿Ima señalkunataq chay p'unchawkunapiri kanqa? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Hinaqtinmi Jesusqa discipulonkunata contestaspa niran: —Qankunaqa piwanpas ama engañachikunaykichispaq, ¡allinta cuidakuychis! ");
INSERT INTO qveNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ichaqa ashka runakunan noqapa sutiypi hamunqaku. Hinaspan khaynata ninqaku: “Noqan kani Cristo”, nispanku. Saynata rimaspankun paykunaqa ashka runakunata engañanqaku. ");
INSERT INTO qveNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Hinallataqmi qankunaqa uyarinkichis guerrakunamanta, hinallataq guerra ruway munaq nación llaqtakunamantawan. Aswanqa chaykunata uyarishaspaykichispas amayá mancharikunkichishchu. Chaykunaqa hinapunin pasanan. Aswanqa chay guerrakunamanta uyarispaykichisqa, yachaychisyá kay pachapa tukukuyninqa manaraq chayamusqanta. ");
INSERT INTO qveNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kay pachapiqa huk nación llaqtakunan guerrapi peleanqaku huk law nación llaqtakunawan. Hinaqtinmi mana mikhuy kaqtin ancha muchuy kanqa. Hinallataqmi tukuy enteropi terremotokunapas pasanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ichaqa yachaychisyá, chaykunaqa tukuy ñak'ariykunapa qallariyllanraq kasqanta. ");
INSERT INTO qveNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Chay tiempopiqa, qankunatapas autoridadkunamanmi apasunkichis. Hinaspan chay autoridadkunaqa presochaspa ñak'arichisunkichis, hinallataq wañuchisunkichis ima. Hinaspapas noqapa discipuloykuna kasqaykichisraykun, llapallan runakuna qankunataqa cheqnisunkichis. ");
INSERT INTO qveNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Chaykuna pasaqtinmi, noqapi wakin creeqkunapas, noqapi creeyta dejaspanku, noqamanta aswan p'enqakunqaku. Hinaspan paykunapura cheqninakuspa traicionanakunqaku ima. ");
INSERT INTO qveNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Saynallataqmi ashkallaña falso profetakunapas rikhurimunqaku. Hinaspan paykunapas llullakuspanku ashka runakunata engañanqaku. ");
INSERT INTO qveNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Chay p'unchawkunapiqa mana allin ruwaykuna astawan miraqtinmi, khuyanakuypas chiriyapunqa. ");
INSERT INTO qveNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ichaqa wañunankukama noqapi llapallan iñiqkunallatan, noqaqa salvasaq. ");
INSERT INTO qveNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Hinallataq Diosmanta allin willakuykuna enteron mundontinpi runakunaman willasqa kaqtinmi, chayraq kay pachapa tukukuyninqa chayamunqa. ");
INSERT INTO qveNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ichaqa pipas kaykunata leeqqa, allintan entiendenan, Diosmanta willakuq profeta Danielpa ñawpaq nisqanman hina. Paymi niran: “Huk p'unchawmi huchasapa runa (Jerusalén templo ukhuman haykuspa), chay Lugar Santo nisqa cuartopi huk ancha millakuypaq sacrificio ofrendata ruwanqa”, nispa Daniel 9.27; 10.31. Chayta rikuspaykichisqa, ");
INSERT INTO qveNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Judea provincia llaqtapi tiyaq runakuna orqokunaman apuraylla ayqekuychis. ");
INSERT INTO qveNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Wasi patapi kaqkunapas, apurayllaman urayamuspayá ayqekuchunku; amayá imankutapas wasinkumantaqa orqochunkuchu. Nota: Ñawpaq Israel nación llaqtapi wasikunaqa manan kay llaqtanchiskunapi wasikuna hinachu karan. Chay tiempopi wasi pataqa karan huk ramada hinan. ");
INSERT INTO qveNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Hinallataq campopi kaqkunapas, amayá wasinkumanqa kutimuchunkuchu p'achankuta orqoqqa. ");
INSERT INTO qveNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ay, ¡imaynaraq kanqaku chay p'unchawkunapi wiksayoq warmikunapas, hinallataq qolla wawayoq warmikunapas! ");
INSERT INTO qveNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Qankunaqa Diosmantayá mañakuychis, chay ayqekunaykichis p'unchawkuna ama paray tiempopichu, nitaq samana p'unchawpichu kananpaq. ");
INSERT INTO qveNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Chay p'unchawkunapiqa llapallan runan anchata ñak'arinqa. Sayna ñak'ariyqa manan karanchu, kay pachata Dios unanchasqanmantapacha; nitaqmi huktawanpas sayna ñak'ariyqa kanqachu. ");
INSERT INTO qveNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Diosqa anchatapunin akllasqankunataqa khuyakun. Chayraykun chay ñak'ariy p'unchawkunaqa, mana unaytachu duranqa. Sichus unayta duranman chayqa, llapallankun runakunaqa wañunkuman. ");
INSERT INTO qveNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Sichus chay p'unchawkunapi pipas nisunkichis: “Qawaychis, kaypin kashan Cristoqa” otaq “Waqpin kashan Cristoqa”, nispa, chayqa, aman qankunaqa paykunataqa creenkichishchu. ");
INSERT INTO qveNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ichaqa rikhurimunqakun “Criston kani” niq runakunapas, hinallataq “Diosmanta willakuqmi kani” niq falso profetakunapas. Paykunan runakunata engañanankupaq, ancha admirakuypaq milagrokunata ruwaspa purinqaku. Chay milagrokunata rikuchispan, Diospa akllasqan runakunatapas engañayta munanqaku. ");
INSERT INTO qveNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Qankunamanqa ñawpaqtaraqmi ña niraykichishña chaykunamantaqa. ");
INSERT INTO qveNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Chayraykun niykichis, sichus pipas nisunkichis: “¡Qawaychis, Cristoqa waq ch'inñeq lugarpin kashan!” nispa. Hinaqtinqa aman rinkichishchu. Otaq nisunkichisman: “¡Qawaychis, Cristoqa waq wasipin pakakuspa kashan!” nispa. Hinaqtinqa aman creenkichishchu. ");
INSERT INTO qveNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ichaqa noqa Diosmanta Hamuq Runa kay pachaman hamusaq hinaspaqa, manan pakakusaqchu. Noqaqa hamusaq imaynan huk rayo t'oqyamunanpaq llataq nispa k'ancharimun intipa lloqsimunan lawmanta asta intipa haykunan lawkama, saynan hamusaq. Chaymi llapallan runakunaqa rikuwanqaku hamusqayta. ");
INSERT INTO qveNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Chayqa kanqa, maypichus wañusqa aycha kashan, chaypin ashka condorkunapas huñunakunku. Chaytan runakunapas rikunku. (Saynallataqmi noqa hamuqtiypas, llapallan runakunaqa rikuwanqaku). ");
INSERT INTO qveNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jesusqa discipulonkunatan nillarantaq: —Chay ñak'ariy p'unchawkuna pasarullaqtinmi intipas tutayanqa, killapas manañan k'anchanqañachu, qoyllurkunapas cielomantan urmayamunqa, hinallataqmi cielokunapi tukuy ima kaqkunapas khatatatanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Hinaqtinmi noqa Diosmanta Hamuq Runapa señalniyta llapallan runa rikunqa cielopi. Chaymi kay pachapi llapallan llaqtakunapi tiyaq runakunaqa anchata mancharikuspa waqanqaku, noqa Diosmanta Hamuq Runata cielomanta phuyu ukhunta, tukuy atiyniyoq, hinaspa k'ancharistin hamushaqta rikuwaspanku. ");
INSERT INTO qveNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Hinaqtinmi huk corneta tocamuqtin, noqaqa angelniykunata kamachisaq, paykuna rispanku llapallan akllasqaykunata llapallan nación llaqtakunamanta huñumunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Qankunaqa yachaychisyá higos sach'amanta willakuyta. Chay higos sach'apa ramankuna retoñamuqtinmi, qankunaqa yachankichis paray wichay cercaña kasqanta. ");
INSERT INTO qveNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Saynallataqyá llapallan nisqaykunata rikuspaykichisqa, yachaychis hamunay p'unchawqa cercallaña kasqanta. ");
INSERT INTO qveNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Cheqaqtapunin niykichis, kay nisqaykunaqa pasanqa manaraq kay tiempopi kawsaq runakuna wañushaqtinkuraqmi. ");
INSERT INTO qveNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Hanaq pachapas hinallataq kay pachapas tukukunqan. Kay nisqaykunan ichaqa mana ni hayk'aqpas tukukunqachu. ");
INSERT INTO qveNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ichaqa manan pipas yachanchu ima p'unchawtas otaq imay horastas noqapa kutimunay p'unchawtaqa. Nitaqmi hanaq pachapi angelkunapas, nitaq noqapas yachanichu. Aswanqa Dios Taytallaymi yachan. ");
INSERT INTO qveNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noqa Diosmanta Hamuq Runapa kutimunay p'unchawqa, Noeypa tiemponpi hinan kanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Chay Noeypa tiemponpiqa, manaraq para nishuta paramushaqtinmi, runakunaqa mikhusharanku, tomasharanku, wakintaq casarakusharanku ima. Ichaqa tukuy chaykunataqa ruwaranku arcaman Noé haykusqan p'unchawkamallan. ");
INSERT INTO qveNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Hinaspapas chay tiempopi tiyaq runakunaqa manan creerankuchu Noeypa yachachisqanpiqa. Hinaqtinmi nishuta para-paramuspa, enteron mundontinman unu hunt'aran. Chaymi llapallan runakunaqa unupi heq'epaspa wañuranku. Saynallataqmi kanqa noqa Diosmanta Hamuq Runa kutimunay p'unchaw chayamuqtinpas. ");
INSERT INTO qveNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Chay p'unchawpin ishkay runakuna campopi kashanqaku; hukninmi apasqa kanqa, hukninñataqmi saqesqa kanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Hinallataqmi ishkay warmikunapas huk maranpi kutashanqaku; hukninmi apasqa kanqa, hukninñataqmi saqesqa kanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Chaymi niykichis, qankunaqa manan yachankichishchu ima p'unchawtas noqa Señorniykichis kay pachaman kutimunay p'unchawtaqa. Saynaqa rikch'ashaq hinallayá kaychis. ");
INSERT INTO qveNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Aswanqa yachaychisyá kayta, sichus huk wasiyoq runa yachanman imay horastas wasinman suwa haykunanta chayqa, manachá chay tutaqa puñunmanchu, wasinpi kaqninkunata ama suwachikunanpaq. ");
INSERT INTO qveNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Saynallataqyá qankunapas rikch'aychis, hinaspa listolla kaychis. Noqa Diosmanta Hamuq Runaqa mana yachasqaykichis horasllan kutimusaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jesusqa discipulonkunatan nillarantaq: —¿Pitaq kasukuspa allinta ruwaq sirviente runarí? Kasukuspa allinta ruwaq sirvienteqa, patronninpa kamachisqanta ruwaqmi. Chaymi patronninqa chay allin ruwaq sirvienten runamanqa encargaran, wasinpi familianmanpas hinallataq wakin sirvientekunamanpas horasllanpi mikhunata qonanpaq. ");
INSERT INTO qveNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Chay sirviente runaqa, ancha kusisqan kanqa, patronnin hamuspa kamachisqanman hina ruwashaqta tarimuqtinqa. ");
INSERT INTO qveNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Cheqaqtapunin niykichis, sayna kaqtinqa patronninmi chay kasukuq sirviententaqa tukuy kaqninkunata cuidananpaq churanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ichaqa chay serviqnin runa patronninpa kamachitamusqanta mana kasukuspa sonqollanpi piensanman khaynata: “Patronniyqa manaraqmi hamunqaraqchu”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Hinaspataq chay serviqmasinkunata maqanman; hinallataq patronninpa qolqenwan mikhukuspa runakunawan mach'akunman, tomakunman ima. ");
INSERT INTO qveNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Saynata ruwashaqtinmi, mana yachasqan horaslla, hinallataq mana yachasqan p'unchawlla patronnin kutiramunman. Hinaspan sayna ruwashaqta tariramuspa, ");
INSERT INTO qveNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ancha-anchata castiganqa. Hinaspan ishkay uya runakunawan kushkata churanqa, chaypi anchata ñak'arispa waqananpaq, hinallataq kirunkunaraq rach'ikyananpaq ima, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jesusqa discipulonkunatan nillarantaq khaynata: —Diospa gobiernasqan sumaq glorianqa rikch'akun huk casarakuymanmi. Chay casarakuymanmi huk tuta chunka sipaskuna lamparinninkuta aparikuspa, novioman taripaq riranku chashkinankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Chay sipaskunamantan pishqa sipaskunaqa qonqay sonqo qella sipaskuna karanku. Wakin pishqañataqmi allin viva sipaskuna karanku. ");
INSERT INTO qveNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Chay pishqantin qonqay sonqo qella sipaskunaqa, lamparinninku ratashaqlla kananpaqmi aceiteta lamparinninkuman yapanankupaq mana apakurankuchu. ");
INSERT INTO qveNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Wakin chay allin viva sipaskunan ichaqa, lamparinninku ratashaqlla kananpaq aceiteta yapanankupaq apakuranku. ");
INSERT INTO qveNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Hinaqtinmi casarakuq novio mana chayamuqtin, chay chunkantin taripaq sipaskunaqa, puñuywan aysarachikuspa puñurapuranku. ");
INSERT INTO qveNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Hinaqtinmi chawpi tutaña kashaqtin, waqyakuqta uyariranku khaynata: “¡Lloqsimuychis chashkinaykichispaq; ñan kaytaña novioqa hamushan!” nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Chaymi chunkantin sipaskunaqa puñusqankumanta hatarimuspa, lamparinninkuta alistaranku, chay casarakuq noviota chashkinankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Hinaqtinmi chay pishqantin qonqay sonqo qella sipaskunaqa, wakin viva sipaskunata, khaynata niranku: “Qankunapa aceite apakamusqaykichista ashllata qoykuwayku. Lamparinniykuqa aceiten tukurukuqtinmi wañurushanña”, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Chaymi chay allin viva sipaskunaqa niranku: “Noqaykupapas aceiteykuqa manan ashkachu, qankunamanwan qonaykupaqqa. Aswanyá rispaykichis aceite vendeqkunamanta rantikamuychis”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Hinaqtinmi chay pishqa qonqay sonqo qella sipaskunaqa, aceiteta rantikuq pasaranku. Chaykaman novioqa chayaramuran. Chaymi pishqantin listo kaq viva sipaskunalla noviopa casarakusqan fiestaman haykuranku. Haykuruqtinku hinallan punkuqa wishq'akuran. ");
INSERT INTO qveNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Hinaqtinmi chay pishqantin qonqay sonqo qella sipaskunaqa, aceite rantiq risqankumanta kutimuranku. Hinaspan punkuta wishq'asqataña tarispanku, qaparispa, waqyakuranku khaynata: “¡Señor, Señor, punkuta kichaykamuwayku!” nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Hinaqtinmi novioqa contestamuran khaynata: “Manan qankunataqa reqsiykichishchu. Pichá kankichispas”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Kay willakuyta tukuruspanmi Jesusqa discipulonkunata niran: —Saynayá qankunapas, rikch'an-rikch'anlla kaychis. Qankunaqa manan yachankichishchu ima p'unchawtas, nitaq imay horastas noqapa kutimunaytaqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jesusqa discipulonkunatan nillarantaq: —Diospa gobiernasqan sumaq glorianqa rikch'akun, huk patrón karuman ripuspa, serviqninkunata waqyaspa, ashka qori qolqenta encargatamuqmanmi. ");
INSERT INTO qveNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Chay patronqa sapankama serviqnin runakunamanmi qorita qoran, sapankamapa ruway atinanman hina. Primer kaqmanmi pishqa bolsa qorita qoran. Ishkay kaqmantaqmi ishkay bolsa qorita qoran. Kinsa kaqmanñataqmi huk bolsa qorita qoran. Saynata sapankamaman qotamuspanmi chay patronqa ripuran. ");
INSERT INTO qveNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Hinaqtinmi chay pishqa bolsa qorita chashkiqqa, negociokunata allinta ruwaspa, pishqa bolsa qoritawan ganaruran. ");
INSERT INTO qveNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Saynallataqmi ishkay bolsa qorita chashkiqpas, negociokunata allinta ruwaspa, ishkay bolsa qoritawan ganaruran. ");
INSERT INTO qveNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ichaqa huk bolsa qorita chashkiqñataqmi, pampata t'oqoruspa, patronninpa qosqan qoritaqa pakaruran. ");
INSERT INTO qveNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Unay watakuna pasaruqtinñataqmi, chay sirviente runakunapa patronninqa kutimuran. Chaymi chayamuspa, serviqninkunamanta cuentata mañaran. ");
INSERT INTO qveNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Hinaqtinmi chay pishqa bolsapi qorita chashkiqqa, pishqa bolsa qoritawan apamuspa, patronninta niran: “Patronníy, qanqa pishqa bolsapi qoritan qowaranki. Chaywanmi pishqa bolsapi qoritawan ganaramuni”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Chaymi patronninqa niran: “¡Allinmi! Qanqa allin serviq, hinallataq confianapaq runan kanki. Kay chikan qosqayta gananciayoqta kutichipuwasqaykiraykun, qanmanqa aswan mastaraq qosqayki. Saynaqa noqawan kushka kusikuy”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Saynallataqmi ishkay bolsapi qorita chashkiqpas, hamuspa patronninta nillarantaq: “Patronníy, qanqa ishkay bolsapi qoritan qowaranki. Chaywanmi ishkay bolsapi qoritawan ganaramuni”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Chaymi patronninqa niran: “¡Allinmi! Qanqa allin serviq, hinallataq confianapaq runan kanki. Kay chikan qosqayta gananciayoqta kutichipuwasqaykiraykun, qanmanqa aswan mastaraq qosqayki. Saynaqa noqawan kushka kusikuy”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Saynallataqmi huk bolsapi qorita chashkiqpas, hamuspa patronninta nillarantaq: “Patronníy, noqaqa yacharanin qanqa exigente runa kaspayki, mana tarpushaspapas cosechasqaykita. ");
INSERT INTO qveNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Chaymi noqaqa anchata manchakuspay, chay huk bolsapi qowasqayki qoritaqa allpata t'oqoruspa pakaramurani. Kunanmi ichaqa hina kaqllata apanpushayki”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Chaymi patronninqa contestaspa niran: “Qanqa qella runan kasqanki. Manan allin sirviente runachu. Qanqa yacharankitaq, mana tarpushaspaypas cosecha oqarisqaytaqa. ");
INSERT INTO qveNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Chayri, ¿imanaqtintaq qori qosqaytari mana ni bancollamanpas churamurankichu, kutimuspay qori qosqayta interesnintinta chashkikapunaypaq?”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Saynata nispanmi, chay patronqa sirvienten runakunata kamachispa niran: “Chay qella runamanta qori qosqayta quitaychis. Hinaspa chay chunka bolsapi qoriyoqman qoychis. ");
INSERT INTO qveNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ashka kaqniyoqmi (kasukusqanrayku) astawanraq chashkinqa, saynapi aswan más kaqniyoq kananpaq. Ichaqa chikallan kaqniyoqmantan, (mana kasukusqanrayku), chikallan kaqninpas quitasqa kanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Saynaqa kay mana imapaq valeq qella runataqa, hawa tutayaqman wikch'uychis. Chaypin anchata ñak'arispa waqanqa. Chaymi kirunkunapas rach'ikyanqa”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jesusqa discipulonkunatan nillarantaq: —Noqa Diosmanta Hamuq Runaqa llapallan angelniykunapiwan kushkan hamusaq. Hinaspan huk hatun sumaq k'ancharishaq tronoypi tiyayusaq. ");
INSERT INTO qveNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Hinaqtinmi tukuy nación llaqtakunamanta runakunaqa ñawpaqniyman huñunakamunqaku. Chaymi allin kawsaq runakunata rakisaq mana allinpi kawsaq runakunamanta, imaynan huk oveja michiqpas rakin ovejankunata cabrakunamanta hina. ");
INSERT INTO qveNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Allinta ruwaspa kawsaq runakunataqa phaña lawniymanmi churasaq. Ichaqa mana allinta ruwaspa kawsaq runakunatan, lloq'e lawniyman churasaq. ");
INSERT INTO qveNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Hinaspan noqa Reyqa phaña lawniypi kaq runakunata nisaq: “Hanaq pachapi Dios Taytaymi qankunataqa anchata bendecisunkichis. Chayrayku, hamuspaykichis, Dios Taytaypa preparasqan hanaq pacha glorianman haykuychis. Chay hanaq pacha gloriantaqa kay pacha unanchasqanmantapachan qankunapaq prepararan. ");
INSERT INTO qveNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Noqa yarqasqa kaqtiymi, mikhuchiwarankichis. Ch'akiypi kaqtiymi, unuta qowarankichis. Forastero kaqtiymi, samachiwarankichis. ");
INSERT INTO qveNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","P'achay mana kaqtinmi, p'achaykichista qowarankichis. Onqosqa kaqtiypas, cuidawarankichismi. Hinallataq carcelpi kaqtiypas, visitamuwarankichismi”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Kaykunata niqtiymi, allin ruwaq justo runakunaqa niwankichis: “Señorlláy, ¿hayk'aqtaq qanri yarqaypi karanki, chaytaq mikhuchiraykikurí? ¿Hayk'aqtaq ch'akisqa karanki, chaytaq unutari qoraykikú? ");
INSERT INTO qveNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Hayk'aqtaq forastero karanki, chaytaq samachiraykikurí? ¿Hayk'aqtaq mana p'achayoq karanki, chaytaq p'achaykutari qoraykikú? ");
INSERT INTO qveNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Hayk'aqtaq onqosqa karanki, otaq carcelpi preso karanki, chaytaq visitamuraykikurí?” nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Hinaqtinmi noqa Reyqa nisqaykichis khaynata: “Qankunaqa kay pachapi humilde wakcha runakunapa favorninpin allin kaqkunata ruwarankichis. Chay ruwasqaykichismi noqapaqpas allin kaqkunata ruwashawaqchis hina karan”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Saynallataqmi noqaqa lloq'e lawniypi kaq runakunatapas nisaq: “¡Dios Taytaypa maldecisqan runakuna! Qankunaqa kaymanta pasawaychis, diablopaq hinallataq demoniokunapaqwan wiña-wiñaypaq preparasqa nina rawrayman. ");
INSERT INTO qveNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Qankunaqa yarqasqa kaqtiymi, mikhunata mana qowarankichishchu. Ch'akisqa kaqtiymi, unullatapas mana qowarankichishchu. ");
INSERT INTO qveNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Forastero kaqtiymi, mana samachiwarankichishchu. P'achay mana kaqtinmi, p'achaykichistapas mana qowarankichishchu. Onqosqa kaqtiymi, mana cuidawarankichishchu. Hinallataqmi carcelpi kaqtiypas, mana visitamuwarankichishchu”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Hinaqtinmi chay runakunaqa niwanqaku: “Señor, ¿hayk'aqtaq yarqasqatari rikuraykikú? ¿Hayk'aqtaq ch'akisqatari rikuraykikú? ¿Hayk'aqtaq mana p'achayoqta rikuraykikú? ¿Hayk'aqtaq forasterota, onqosqata, hinallataq carcelpi kaqtiykipas, mana visitamuraykikuchú?” nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Chaymi noqaqa paykunata nisaq: “Qankunaqa kay pachapi humilde wakcha runakunapa favorninpin mana ni imatapas allinta ruwarankichishchu. Chay ruwasqaykichismi noqatapas rechazawashankichisman hina karan”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Chayraykun paykunaqa, wiñaypaq nina rawray infiernoman wikch'usqa kanqaku, chaypi ñak'arinankupaq. Ichaqa Diosta kasukuspa allin ruwaq justo runakunan, wiñay kawsayta chashkinqaku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesusqa yachachiyta tukuruspanmi, discipulonkunata niran: ");
INSERT INTO qveNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Qankunaqa yachankichismi kay ishkay p'unchawmanta Pascua fiesta kananta. Chay fiestapin, noqa Diosmanta Hamuq Runataqa, hap'iwaspanku presochawanqaku, hinaspan cruzpi chakatawanqaku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Hinaqtinmi chay p'unchawkunapiqa, sacerdotekunapa jefenkuna, hinallataq Israel nación llaqtapi kamachiq autoridadkunapiwan ima huñunakuranku Caifaspa palacio wasinpi. Caifasqa llapallan sacerdotekunapa jefenmi karan. ");
INSERT INTO qveNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Chay huñunakuypin paykunaqa acuerdoman haykuranku, Jesusta engañollawan hap'iruspa wañuchinankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Hinaspan nillarankutaq: —Kay acordasqanchistaqa amayá fiesta p'unchawpichu ruwasunchis. Sichus kay acordasqanchista fiesta p'unchawpi ruwaqtinchisqa, runakunan bullata ruwaspa, noqanchispa contranchispi hatarinkuman, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesusqa Betania llaqtapin (discipulonkunapiwan kushka), Simón sutiyoq runapa wasinpi kasharanku. Chay Simonqa antestaraqmi lepra onqoymanta sanoyasqa karan. ");
INSERT INTO qveNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Chay Simonpa wasinpin Jesusqa mikhusharan. Hinaqtinmi Jesuspa kasqanman huk warmi hamuran. Chay warmin sumaq rumimanta ruwasqa p'uyñuchapi mishk'i perfumeta apamuran. Hinaspan Jesusman ashuyuspa, chay perfume apamusqanta umanman hich'ayuran. Chay perfumeqa ashka qolqepa valorninmi karan. ");
INSERT INTO qveNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Hinaqtinmi Jesuspa discipulonkunaqa, chayta rikuspanku, anchata phiñakuspa, khaynata niranku: —¿Imanaqtintaq usuchishan chay mishk'i perfumetarí? ");
INSERT INTO qveNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kay perfumetaqa ashka qolqeman vendespachá, wakchakunata yanapasunman karan, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Chay rimasqankuta uyarispanmi, Jesusqa discipulonkunata niran: —Ama saynataqa rimaychishchu. Kay warmiqa aswanmi allin kaqta noqapaq ruwarun. ");
INSERT INTO qveNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Qankunapa ladoykichispiqa wakcha runakunaqa kallanqan paykunata yanapanaykichispaq. Noqan ichaqa mana tukuy tiempochu qankunawanqa kushka kasaq. ");
INSERT INTO qveNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kay warmiqa, wañuqtiy p'ampasqa kanaypaqmi cuerpoyta alistashan. Chaymi payqa chay mishk'i q'apaq perfume apamusqanwan umayman hich'ayuwan. ");
INSERT INTO qveNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Chaymi niykichis, maypipas kay pachapi noqamanta allin willakuykunata noqapi creeq runakuna willakuspankuqa, noqapaq kay warmi ruwasqanta yuyarispankun, paymanta willakunqaku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Hinaqtinmi Judas Iscarioteqa sacerdotekunapa jefenkunawan parlaq riran. Chay Judasqa Jesuspa chunka ishkayniyoq discipulonkunamanta hukninmi karan. ");
INSERT INTO qveNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Hinaspan Judasqa paykunata niran: —Sichus Jesusta qankunaman entregayman hinaqtinri, ¿hayk'atataq pagawankichismanrí? nispa. Chaymi paykunaqa ashka valorniyoq kinsa chunka qolqeta paganankupaq Judasman ofreceranku. ");
INSERT INTO qveNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Hinaspan chay ratomantapacha, Judas Iscarioteqa mashkaran imaynatas Jesusta traicionaspa, chay sacerdotekunapa jefenkunaman entregananpaq. ");
INSERT INTO qveNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Chay p'unchawkunapin mana levadurayoq t'antata mikhunankupaq fiesta qallarisharan. Hinaqtinmi chay p'unchawpi discipulonkunaqa Jesusman ashuyuspa, khaynata tapuranku: —¿Maypitaq munanki Pascua fiestapi cenayta alistamunaykutarí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Hinaqtinmi Jesusqa discipulonkunata contestaran khaynata: —Llaqtaman rispaykichis, chay reqsisqanchis runata mashkaspa, khaynata nimuychis: “Yachachikuqmi nin: ‘Wañunay horan chayamushanña. Chayraykun kay Pascuapi cenayta discipuloykunawan kushka wasiykipi cenasaq’ ”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Chaymi discipulonkunaqa rispanku, Jesuspa kamachisqanman hina alistamuranku, chay Pascuapi cenayta mikhunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tutayaruqtintaqmi, Jesusqa chunka ishkayniyoq discipulonkunapiwan mesapi kushka mikhuran. ");
INSERT INTO qveNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mikhushaqtinkun Jesusqa niran: —Cheqaqtapunin qankuna ukhumanta hukniykichis, noqata traicionawaspa, enemigoy runakunaman entregawanqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Hinaqtinmi Jesuspa discipulonkunaqa anchata llakirikuspanku, sapankamanku Jesusta tapuranku: —¿Noqachu kani Señorlláy? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Hinaqtinmi Jesusqa paykunata niran: —Pichus t'antanta apichanqa noqapa t'antay apichasqay kaq platollapitaq, paymi traicionawanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Saynan Bibliapi noqamanta escribisqa kashan, noqa Diosmanta Hamuq Runaqa wañunaypunin. Ichaqa, ¡ay, imaynaraq kanqa traicionawaqniy runaqa! ¡Payqa aswanchá ama nacenmanpashchu karan! nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Hinaqtinmi traicionaqnin Judas Iscarioteqa tapuran: —Yachachikuq, ¿icha noqachu kaní? nispa. Chaymi Jesusqa niran: —Arí, qanmi kanki, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mikhushaqtinkun Jesusqa huk t'antata hap'iyuspa Diosman graciasta qoran. Hinaspan partiyuspa discipulonkunaman haywaspa niran: —Hap'ispa mikhuychis. Kay t'antan noqapa cuerpoy, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Chaymantan kaq copata vinoyoqta hap'iyuspa, Diosman graciasta qoran. Hinaspan discipulonkunaman haywaspa, khaynata niran: —Kay vinota llapaykichis tomaychis. ");
INSERT INTO qveNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kaymi noqapa yawarniy. Kay yawarniywanmi noqaqa huk mosoq pactota ruwani. Kay yawarniymi ch'aqchusqa kanqa ashka runakunapa huchankuna perdonasqa kananpaq. ");
INSERT INTO qveNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kay copapi vinotaqa manañan qankunawanqa tomasaqñachu, asta Dios Taytaypa sumaq glorianpi, mosoq vinota qankunawan kushka, huktawan tomananchiskama, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Jesusqa discipulonkunapiwan kushka huk himno takita takiruspankun, Olivos nisqa moqoman riranku. ");
INSERT INTO qveNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Chaypin Jesusqa discipulonkunata niran: —Noqapi iñiyniykichismi kunan tuta pisiyanqa. Hinaqtinmi noqamanta qankunaqa p'enqakunkichis. Saynan Bibliapi escribisqa kashan: “Michiqta wañuchiqtinkun, ovejankuna ch'eqechisqa kanqa”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ichaqa wañusqaymanta kawsarimuspaymi, noqaqa qankunapa ñawpaqniykichista Galilea provincia lawman risaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Chaymi Pedroqa niran: —Sichus llapallanku qanmanta p'enqakuspanku saqesunkiku chayqa, noqaqa manan ni hayk'aqpas qantaqa saqesqaykichu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Hinaqtinmi Jesusqa Pedrota contestaran: —Pedro, cheqaqtapunin niyki, kunan tuta gallo manaraq waqamushaqtinmi, qanqa kinsa kutikama negawanki, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Hinaqtinmi Pedroqa niran: —Sichus qanwan kushka wañunay kaqtinpas, noqaqa manan ni hayk'aqpas qantaqa negasqaykichu, nispa. Saynallatataqmi wakin discipulonkunapas niranku. ");
INSERT INTO qveNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jesusqa discipulonkunapiwan kushkan Getsemaní sutiyoq huertaman riran. Chayman chayaruspankun, Jesusqa wakin discipulonkunata niran: —Qankunaqa kayllapi qepakuychis. Waqman rispay, noqa orakamunaykama, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jesusqa saynata nispanmi, discípulon Pedrota, hinallataq Zebedeopa ishkaynin wawankunatawan huk lawchaman pusarikuran. Hinaspan Jesusqa ancha-anchata llakikuspa, ");
INSERT INTO qveNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","paykunata niran: —Noqaqa wañunayta yachakuspaymi sonqoypi ancha llakisqa kashani. Saynaqa noqawan qepakuspaykichisyá, ama puñuychishchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Hinaspan Jesusqa tumpanta ñawpaqman rispa, chaypi qonqorikuspa pampakama k'umuyuran. Hinaspan Dios Taytanman orakuran khaynata: —Dios Taytalláy, noqaqa anchatan munayman kay ñak'ariykunamanta librawanaykitaqa. Ichaqa amayá noqapa munasqaychu ruwasqaqa kachun, aswanqa qanpa munasqaykiman hinayá ruwasqa kachun, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jesusqa chay kinsantin discipulonkunapa kasqanman kutirimuspanmi, paykunata puñushaqta tariran. Chaymi Pedrota niran: —¿Manachu huk horallapas noqawan kushka rikch'ayta atirankichís? ");
INSERT INTO qveNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Amayá puñuychishchu. Aswanqa orakuychisyá ama tentasqa kanaykichispaq. Qankunaqa allin kaqkunata ruwayta munashaspapas, kallpallaykichiswanqa manan atiwaqchishchu ruwaytaqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Saynata nispanmi Jesusqa huktawan tumpanta ñawpaqman rispa, yapamanta Dios Taytanman orakuran khaynata: —Dios Taytalláy, sichus kay ñak'ariykunata pasanaypuni kaqtinqa, munasqaykiyá ruwasqa kachun, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Saynata nispanmi Jesusqa kaqmanta kutiran chay kinsantin discipulonkunapa kasqanman. Hinaspan discipulonkunataqa aswan más mishk'i puñushaqtaña tariran. ");
INSERT INTO qveNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Hinaspan chay kinsantin discipulonkunata saqespa, Jesusqa kaqmanta orakuq kutiran. Hinaspan kay kinsa kuti orakuyninpipas, orakuran imaynatan primer kaqkunapi orakuran saynallatataq. ");
INSERT INTO qveNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Orakuyta tukuruspanmi Jesusqa, chay kinsantin discipulonkunapa kasqanman kutimuspa, khaynata niran: —Qankunari, ¿kunankamachu puñullashankichisraq? Ñan hora chayaramunña, noqa Diosmanta Hamuq Runaqa huchasapa runakunapa makinman entregasqa kanaypaq. ");
INSERT INTO qveNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Hatariychis, hinaspa hakuchi! Ñan kaytaña traicionawaqniy runaqa hamushan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Kinsantin discipulonkunawan Jesús parlallashaqtinraqmi, Judas Iscarioteqa Jesuspa kasqanman chayamuran. Paywanmi hamuranku ashka runakuna espadayoqkuna, hinallataq k'aspiyoqkuna ima. Paykunatan mandamuranku Israel nación llaqtapi kamachiq jefekuna, hinallataq sacerdotekunapa jefenkunapas. ");
INSERT INTO qveNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Chaymi Judas Iscarioteqa paywan hamuq runakunata ña yachachimuranña khaynata: —Mayqentachus noqa much'aykusaq, chaymi Jesusqa. Payta hap'ispayá, presochankichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judasqa chay nisqanman hinan, Jesusman ashuyuspa, rimayukuran: —Yachachikuq, nispa. Hinaspan much'aykuran. ");
INSERT INTO qveNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Hinaqtinmi Jesusqa Judas Iscarioteta, khaynata niran: —Amigo, ¿imamantaq hamushankirí? Kaypiñataq kashanki chayqa, iman ruwanaykitayá ruway, nispa. Chaymi paywan hamuq runakunaqa Jesusta hap'iranku presota apanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Chayta rikuspanmi, Jesuspa huknin kaq discipulonqa, espadanta orqomuran. Hinaspan sacerdotekunapa jefenpa sirvienten runapa huknin ninrinta kuchurparan. ");
INSERT INTO qveNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Chaymi Jesusqa chay ninri kuchuq discipulonta niran: —Chay espadaykita waqaychay. Pipas espadawan wañuchiqqa, espadallawantaqmi wañuchisqa kanqa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Acaso manachu yachankichis, Dios Taytaymanta kunan mañakuqtiy, chunka ishkayniyoq tropa angelninkunata mandamuspa defiendewananmanta? Nota: Huk tropataqa ashka waranqa angelkunan conforman. ");
INSERT INTO qveNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Qankunaqa kaykuna hina pasananta dejaychis. Sayna kaqtinmi Bibliapi escribisqakuna llapallan cumplikunqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Chayta nispanmi Jesusqa runakuna lawman kutirispa, paykunata tapuran khaynata: —Qankunari, ¿imanaqtintaq espadakunantin, hinallataq k'aspikunantin hamurankichis suwata hina hap'iwanaykichispaqrí? Noqaqa sapa p'unchawmi Jerusalén templopi yachachirani. Ichaqa manataqmi preso kanaypaqqa pipas hap'iwaranchu. ");
INSERT INTO qveNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kunanmi ichaqa kaykuna pasan, ñawpaqmantaraq Diosmanta willakuq profeta runakunapa nisqanman hina cumplikunanpaq, nispa. Hinaqtinmi discipulonkunaqa Jesusta saqespa, chay ratolla ayqekuranku. ");
INSERT INTO qveNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jesusta hap'iq runakunan, sacerdotekunapa jefen Caifaspa palacio wasinman Jesusta aparanku. Chaypin leykunata yachachiq runakunapas, hinallataq Israel nación llaqtata kamachiq runakunapas huñunasqa kasharanku. ");
INSERT INTO qveNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Hinaqtinmi Jesusta apaqtinku, Pedroqa karu qepallankuta riran asta chay sacerdote Caifaspa palacio pationman chayachinankukama. Hinaspan Pedropas chayman haykuspa, guardiakunawan kushka tiyayuran, Jesusta imatachus ruwasqankuta rikunanpaq. ");
INSERT INTO qveNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Hinaspan chay sacerdotekunapa jefenkunapas, Israel nación llaqtata kamachiqkunapas, hinallataq chaypi kaq llapallan autoridadkunapas, Jesuspa contranpi llullakuspa rimaq runakunata mashkaranku, chayman hina Jesusta acusaspa wañuchinankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Chaymi ashka runakuna Jesuspa contranpi llullakuspa rimanankupaq hamuranku. Ichaqa manataqmi chay falso testigokunaqa hukllatachu rimaranku. Hinaqtinmi qepallataña ishkay falso testigokuna hamuspa, ");
INSERT INTO qveNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","khaynata niranku: —Kay runan niran: “Noqaqa Dios yupaychana templota thuñirachispaymi, kinsa p'unchawllapi kaqmanta ruwaruyman”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Hinaqtinmi sacerdotekunapa jefen Caifasqa, tiyasqanmanta sayarispa, Jesusta tapuran khaynata: —¿Uyarishankichu kay acusasuqniyki runapa nisqanta? Qanri, ¿manachu ima nispallapas defiendekunkí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ichaqa Jesusñataqmi mana ni imatapas rimarispa upallalla karan. Chaymi chay sacerdotekunapa jefenqa kaqmanta niran: —Wiñay kawsaq Diospa sutinpin kamachiyki. Kunan juraspa niwayku, ¿cheqaqtapunichu qanri kanki Diospa wawan Cristo? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Hinaqtinmi Jesusqa niran: —Arí, qanpa nisqaykiman hinan. Hinaspapas nillasqaykichistaqmi, qankunaqa kunanmanta wichaymanmi rikuwankichis, noqa Diosmanta Hamuq Runataqa, hanaq pachapi tukuy atiyniyoq Diospa phaña ladonpi tiyashaqta. Hinallataqmi Diospa atiyninwan phuyuq chawpinta hamushaqtapas rikuwankichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Chaymi Jesuspa nisqanta uyarispa sacerdotekunapa jefen Caifasqa, anchata phiñakuspa p'achantaraq llik'ispa, khaynata niran: —¡Kay runaqa Diostan k'amishan! ¿Imapaqñataq munanchis huk testigokunatawanrí? Qankunapas paypa nisqantan uyarishankichis Diospa contranpi rimasqantaqa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Chayri, ¿ima ninkichistaq kunanrí? nispa. Chaymi chaypi kaq runakunaqa contestaspa niranku: —¡Kay runaqa wañuchun! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Saynata nispankun chay runakunaqa, Jesusman ashuyuspa uyanman toqaykuranku. Wakintaq maqaranku. Wakinñataq uyankunapi saqmaranku. ");
INSERT INTO qveNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Hinaspan Jesusta niranku: —Cheqaqtapuni Diosmanta Hamuq Cristo kaspaykiqa, niwaykuyá, ¿pitaq saqmamushasunkirí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Chaykuna pasashaqtinmi, Pedroqa chay palacio wasipa pationpi tiyasharan. Hinaqtinmi chay palacio wasipi kaq huk sirvienta warmi, ashuyuspa, Pedrota niran: —Qanpas tukuy tiempomá chay Galilea provincia lawmanta kaq Jesuswanqa puriranki, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Hinaqtinmi llapallan runakuna uyarishaqtin Pedroqa negaran khaynata: —Chay niwasqaykiqa manan cheqaqchu. Qanqa imamantachá rimashankipas, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Chayta nispanmi Pedroqa chay patiopa punkunta hawaman lloqsisharan. Hinaqtinmi huk sirvienta warmiñataq Pedrota rikuruspa, chaypi kaq runakunaman niran: —Kay runaqa chay Nazaret llaqtayoq Jesuswanmi kasharan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Hinaqtinmi Pedroqa chay warmipa nisqanta uyarispa, Diospa sutinpi juramentota ruwaspa, kaqmanta negaran khaynata: —Cheqaqtapunin niykichis, chay Jesuswan sutichasqa runataqa, noqaqa manan reqsinichu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Hinallataqmi tumpa unayninman, chaypi kaq wakin runakunapas, Pedropa kasqanman ashuyuspanku, nillarankutaq khaynata: —Qanqa cheqaqtapunin Jesusta qatikuq runakunamanta huknin kaq runa kashanki. Chaymi rimasqaykipas paykunapa rimasqanwan igualla kashan, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Saynata niqtinkun, Pedroqa maldecikuspa, Diospa sutinpi juramentota ruwaspa, khaynata niran: —¡Noqaqa manan chay runataqa reqsinichu! nispa. Saynata rimayta tukuruqtillanmi gallo waqaramuran. ");
INSERT INTO qveNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Chaymi Pedroqa yuyariran: “Manaraq gallo waqamushaqtinmi qanqa kinsa kutikama negawanki”, nispa Jesús nisqanta. Hinaqtinmi Pedroqa chay lugarmanta hawaman lloqsispa, renegaymanta anchata waqaran. ");
INSERT INTO qveNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Achiqaramuqtinmi sacerdotekunapa llapallan jefenkunaqa, Israel nación llaqtapi autoridadkunapiwan huñunakuranku. Hinaspan Jesusta wañuchinankupaq acordaranku. ");
INSERT INTO qveNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Saynata acordaruspankun, sacerdotekunapa jefen Caifaspa palacio wasinmanta, Jesustaqa chaqnasqata orqomuranku. Hinaspan gobernador Poncio Pilatopa kasqanman aparanku. ");
INSERT INTO qveNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas Iscarioteqa, Jesusta wañunanpaq sentenciasqankuta yacharuspanmi, Jesusta traicionaspa entregasqanrayku ñakapakuran. Hinaspan sacerdotekunapa jefenman, hinallataq Israel nación llaqtapi kamachiq runakunamanwan ima, chay kinsa chunka qolqe qosqankuta kutichipuran. ");
INSERT INTO qveNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Hinaspan Judasqa paykunata niran: —Jesusta qankunaman entregasqaywanqa, Diospa contranpin noqaqa huchallirukuni. Payqa mana huchayoq runan karan, nispa. Chaymi paykunañataq contestaranku: —Noqaykumanri, ¿imataq qokuwankú? ¡Chayqa qanpa problemaykin! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Saynata niqtinkun, Judasqa chay qolqe qosqankuta templo ukhupi wikaparan. Hinaspan Judasqa templomanta ripuspa, seq'okuran. ");
INSERT INTO qveNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Sacerdotekunapa jefenkunañataqmi chay qolqe wikapasqanta oqarispanku, khaynata niranku: —Kay qolqetaqa manan ofrenda churana cajamanqa churasunmanchu. Kay qolqetaqa huk runata wañuchinapaqmi pagaranchis, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Hinaspan chay sacerdotekunapa jefenkunaqa huk Manka Ruwaq Runapa Allpanwan sutichasqa allpata rantiranku, chay lugarpi forastero runakunata p'ampanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Hinaspan chay rantisqanku allpataqa suticharanku: “Yawar Allpawan”, asta kunan p'unchawkamapas. ");
INSERT INTO qveNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Saynapin cumplikuran Diosmanta willakuq ñawpaq profeta Jeremiaspa nisqan. Paymi niran: “Israel nación llaqtapi tiyaq runakunaqa, preciotan churanqaku kinsa chunka qolqellata. ");
INSERT INTO qveNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Hinaspan paykunaqa chay qolqewan, Manka Ruwaq Runapa Allpanwan sutichasqa allpata rantinqaku, imaynan Diospa kamachiwasqanman hina”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Poncio Pilatopa ñawpaqninpi Jesús kashaqtinmi, Poncio Pilatoqa tapuran: —¿Qanchu kanki Israel nacionniyoq runakunapa reynin? nispa. Chaymi Jesusqa contestaran: —Arí, qanpa nisqaykiman hinan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Hinaqtinmi chaypi kaq sacerdotekunapa jefenkunaqa, hinallataq Israel nación llaqtapi kamachiq runakunapiwan, Jesusta Poncio Pilatopa ñawpaqninpi acusaranku. Ichaqa manataqmi Jesusqa ni ima nispapas paykunataqa contestaranchu. ");
INSERT INTO qveNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Chaymi Poncio Pilatoqa Jesusta tapuran: —¿Uyarishankichu qanpa contraykipi tukuy ima rimasqankuta? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesusqa manataqmi ni imanispapas contestaranchu. Chaymi Poncio Pilatoqa ancha admirasqallaña karan. ");
INSERT INTO qveNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Sapa watanmi, Poncio Pilatoqa Pascua fiesta chayamuqtin, huk presochasqa runata kachariran, llaqta runakuna mañakusqanman hina. ");
INSERT INTO qveNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Chay tiempopin carcelpi kasharan Barrabás sutiyoq runa. Payqa criminal kasqanraykun, runakunapa reqsisqan karan. ");
INSERT INTO qveNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Chaymi Poncio Pilatoqa chaypi huñunasqa kaq llapallan runakunata tapuran khaynata: —¿Mayqentataq qankuna munawaqchis kunan kacharinayta? ¿Barrabastachu icha Diosmanta Hamuq Salvadorwan sutichasqa Jesustachú? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Poncio Pilatoqa saynata tapuran, sacerdotekunapa jefenkuna, hinallataq Israel nación llaqtapi kamachiq runakunapiwan, Jesusta envidiakuspallanku acusasqankuta yachaspanmi. ");
INSERT INTO qveNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Hinaqtinmi juzganan sillapi Poncio Pilato tiyashaqtin, warminpa partenmanta huk willakuyta chashkiran. Chaymi khaynata niran: “Kay runaqa cheqaqtapunin mana huchayoq. Ama imanankipashchu. Paypa kawsanpin ch'isi sueñoyniypi nishuta ñak'ariruni”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Chay ratollapitaqmi, sacerdotekunapa jefenkunaqa, hinallataq Israel nación llaqtapi kamachiq runakunapiwan ima, chaypi kaq llapallan runakunata convencechiranku, Poncio Pilatota khaynata mañakunankupaq: “Barrabasta kacharipuy; Jesustañataq wañuchiy”, nispa ninankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Hinaqtinmi gobernador Poncio Pilatoqa, chaypi huñunasqa llaqta runakunata, kaqmanta tapuran: —Qankunari, ¿pitataq munankichis kacharinaytarí? nispa. Hinaqtinmi chaypi huñunasqa runakunaqa contestaranku: —¡Barrabasta kachariy! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Hinaqtinmi Poncio Pilatoqa yapamanta paykunata tapuran: —Sayna kaqtinqa, ¿imatataq ruwasaq kay Diosmanta Hamuq Cristowan sutichasqaykichis Jesustarí? nispa. Paykunañataqmi llapallanku contestaranku khaynata: —¡Cruzpi chakatasqa kachun! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Hinaqtinmi gobernador Poncio Pilatoqa yapamanta llaqta runakunata tapuran: —Niwaychisyá. Kay runari, ¿ima mana allintataq ruwaruran? nispa. Saynata niqtinmi, llapallan runakunaqa aswan más altotaraq qaparispa niranku: —¡Chay runaqa cruzpi chakatasqa wañuchun! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Hinaspan llaqta runakunaqa manaña Poncio Pilatopa nisqankunata uyariyta munarankuñachu. Chaymi Poncio Pilatoqa chay llaqta runakuna ch'aqwata manaraq hatarichishaqtinku, aswan unuta apachimuspa, llapallan runakuna rikushaqtin, makinta maqchikuran. Hinaspan chaypi kaq runakunata niran: —Noqaqa manan culpayoqchu kasaq kay runapa wañusqanmantaqa. Culpayoqqa qankunan kankichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Hinaqtinmi chaypi kaq llapallan runakunaqa niranku: —¡Noqaykun hinallataq wawaykupas chay runapa wañusqanmantaqa responsable kasaqku! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Saynata niqtinkun, gobernador Poncio Pilatoqa Barrabasta carcelmanta kacharipuran. Hinaspan soldadonkunata kamachiran alli-allinta Jesusta wasanpi waqtaruspanku, cruzpi chakataspa clavamunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Hinaqtinmi gobernador Poncio Pilatopa soldadonkunaqa, chay palacio wasipa pationman Jesusta aparuspanku, chayman waqyaranku llapallan tropa soldadokunata. ");
INSERT INTO qveNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Hinaspan chaypi Jesuspa p'achanta orqospanku, huk puka capawan churaranku. ");
INSERT INTO qveNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Umanmantaqmi kishkamanta ruwasqa coronata churaranku. Phaña makinmantaq hap'ichiranku huk k'aspita bastonta hina. Hinaspan chay soldadokunaqa ñawpaqninpi qonqorikuspa, burlakuranku khaynata: —¡Kawsachun Israel nación llaqtapa Reynin! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Saynata burlakuspankun chay soldadokunaqa, toqaykuspa, chay k'aspi qosqankuwan umanpi p'anaranku. ");
INSERT INTO qveNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Hinaspan burlakuyta tukuruspanku, chay puka capawan p'achachisqankuta ch'ustispa, kaq p'achallanwantaq churapuranku. Hinaspan cruzpi chakataspa clavamunankupaq aparanku. ");
INSERT INTO qveNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","(Poncio Pilatopa palacionmantan soldadokunaqa Jesusta aparanku). Hinaspan Jerusalén llaqtamanta lloqsichishaspanku, Cirene llaqtayoq Simonwan ñanpi tuparuspa, payta obligaranku Jesuspa cruzninta wikriysinanpaq. ");
INSERT INTO qveNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Hinaspan cruzpi chakatanankupaq Gólgota nisqa moqoman Jesusta chayachiranku. Chay Gólgota moqoqa rimayninkupiqa “Calavera moqo”, ninantan nin. ");
INSERT INTO qveNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Chaypin qatqellaña qorakunawan chapusqa vinagreta Jesusman qoranku. Ichaqa chay qatqe vinagreta malliyuspanmi, Jesusqa mana tomayta munaranchu. ");
INSERT INTO qveNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Chaymantan Jesustaqa cruzpi chakataspa clavaranku. Hinaspan chay soldadokunaqa Jesuspa p'achanta rakinakunankupaq sortearanku. {Saynapin Diosmanta willakuq profetapa nisqan cumplikuran. Paymi niran: “P'achaypa hawanpi sorteaspankun, paykunapura p'achayta rakinakunqaku”, nispa} Salmos 22.18. ");
INSERT INTO qveNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Hinaspan soldadokunaqa Jesusta cuidaranku, cruzpa ladonpi tiyaspanku. ");
INSERT INTO qveNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Saynallataqmi cruzpa puntanpipas, huk letrerota churaranku khayna niqta: “kay runan jesús; paymi israel nacionniyoq runakunapa reynin”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Hinallataqmi ishkay suwakunatapas chakatallarankutaq, hukninta Jesuspa phaña ladonpi, huknintataq lloq'e ladonpi. ");
INSERT INTO qveNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Saynallataqmi chayninta pasaq runakunapas, umankuta maywirisparaq, Jesusta k'amiranku khaynata: ");
INSERT INTO qveNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Qanqa nirankitaq: “Kay Jerusalén llaqtapi templota thuñirachispaymi, noqaqa kinsa p'unchawllapi hatarirachiyman”, nispa. Chayqa, ¡sichus Diospa wawan kaspaykiqa, kikiykitayá kunan salvakuy! ¡Hinaspa chay cruzmanta urayamuy! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Saynallataqmi sacerdotekunapa jefenkunapas, leykunata yachachiq runakunapas, hinallataq Israel nación llaqtapi kamachiq runakunapas Jesusmanta burlakuspa, khaynata parlaranku: ");
INSERT INTO qveNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Hukkunataqa salvaranmi, ichaqa pay kikintataqmi mana salvakuytaqa atinchu. ¡Sichus cheqaqtapuni kay Israel nación llaqtapa Reynin kaspaqa, kunanyá chay cruzmanta urayamuchun, paypi creenanchispaq! ");
INSERT INTO qveNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Hinaspapas payqa Diospi confiaspan niran: “Diospa wawanmi kani” nispa. ¡Sichus cheqaqtapuni Dios munakuspaqa, kunanyá salvachun! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Saynallataqmi Jesuswan kushka chakatasqa runakunapas Jesustaqa k'amillarankutaq. ");
INSERT INTO qveNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Jesuspa wañusqan p'unchawmi inti tutayaran chawpi p'unchawmantapacha asta kinsa horas tardekama. ");
INSERT INTO qveNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Hinaqtinmi yaqaña kinsa horas tarde kashaqtin, Jesusqa altota qaparispa, khaynata niran: —Elí, Elí ¿lama sabactani? nispa. Kay rimayqa khayna ninanmi: “¡Diosnilláy, Diosnilláy! ¿Imanaqtintaq sapallaytari saqerullawankí?” nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Hinaqtinmi chay nisqanta uyarispanku, chaypi kaq wakin runakunaqa, mana allinta entiendespanku niranku: —Uyariychis, payqa Diosmanta willakuq ñawpaq profeta Eliastan waqyakushan, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Chaymi kasqan ratolla chaypi kaq huknin runaqa, huk largo soqos k'aspipa puntanman apurayllamanña esponjata wataran. Hinaspan chay esponjata qatqe vinagreman challpuspa, Jesuspa siminman aypachiran ch'unqananpaq. ");
INSERT INTO qveNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Hinaqtinmi chaypi kaq wakin rikuq runakunaqa, khaynata niranku: —Ama saynata ruwaychu. Aswan suyasunchis Diosmanta willakuq profeta Elías hamunqachus kay cruzmanta salvananpaq icha manachus chayta, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Hinaqtinmi Jesusqa kaqmanta altota qaparispa, chay ratolla wañuran. ");
INSERT INTO qveNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Chaymi chay ratollapitaq, Jerusalén templo ukhupi rakiq cortinapas kushkanmanta llik'ikuran altonmanta urayman. Saynallataqmi kay pachapipas terremoto pasaqtin, qaqakunapas partikuran. ");
INSERT INTO qveNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Saynallataqmi panteonpi sepulturakunapas kicharikuran. Hinaqtinmi Diospi ashka creeq ñawpaq tiempokunapi wañuq runakunapas kawsarimuranku. ");
INSERT INTO qveNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Chay kawsarimuq runakunaqa, Jesuspa kawsarimusqan p'unchawpa qepantan Jerusalén llaqtaman haykuranku. Hinaspan paykunataqa ashka runakuna rikuranku. ");
INSERT INTO qveNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jesús cruzpi wañuruqtinmi, soldadokunapa jefenqa, wakin soldadonkunapiwan Jesusta cuidasharanku. Paykunan chay ratopi terremoto pasaqtin, hinallataq chaypi tukuy imakuna pasasqanta rikuranku. Hinaspan anchata mancharikuspanku, khaynata niranku: —¡Cheqaqtapunin kay runaqa Diospa Wawan kasqa! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Chaypin kasharanku ashka warmikunapas karullamanta qawaspanku. Chay warmikunaqa Galilea provincia lawmantapachan Jesusta servispa hamuranku. ");
INSERT INTO qveNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Chay warmikunawan kushkan karanku: María Magdalena, Zebedeopa warmin, saynallataq Jacobopa hinallataq Joseypa mamitan María ima. Nota: María Magdalena nispaqa niranku, Magdala sutiyoq llaqtamanta kasqanraykun. ");
INSERT INTO qveNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Arimatea llaqtayoq Joseymi tutayaykushaqtinña, Poncio Pilatopa kasqanman hamuran. Joseyqa karan huk qapaq runan, hinallataq Jesuspi creeq ima. ");
INSERT INTO qveNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Chaymi Joseyqa gobernador Poncio Pilatopa palacionman chayaruspa, Jesuspa cuerponta mañaran, apaspa p'ampamunanpaq. Hinaqtinmi Poncio Pilatoqa Joseyman Jesuspa cuerponta qomunankupaq kamachiran. ");
INSERT INTO qveNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Chaymi Joseyqa Jesuspa cuerponta mosoq sabanaswan p'istuyuspa, ");
INSERT INTO qveNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","qaqa sikipi mosoq sepultura t'oqochisqanman churaran. Chaymantan chay sepulturaman haykuna punkunta, huk hatun rumiwan tapaspa, ripuran. ");
INSERT INTO qveNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Chaypin qepakuranku María Magdalena, hinallataq huknin Mariapiwan sepulturapa ñawpaqninpi. ");
INSERT INTO qveNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Paqarisnintin p'unchawmi samana p'unchaw karan. Chay p'unchawmi tardeyaykuytaña, sacerdotekunapa jefenkunaqa, fariseo religionniyoq runakunapiwan gobernador Poncio Pilatoman rispanku, khaynata niranku: ");
INSERT INTO qveNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","—Señor gobernador Poncio Pilato, noqaykuqa yuyashaykun, chay llulla Jesusqa kawsashaspanraqmi niran: “Noqaqa wañuchiwaqtinkun kinsa p'unchawmanta kawsarimusaq”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Chayraykun kunan qanta valekuykiku, guardiaykikunata kamachispayki, chay sepulturata allinta cuidachimunaykipaq, asta kinsa p'unchaw pasarunankama. Mana chayqa discipulonkunan tuta rispanku cuerponta suwarukuspanku, llaqta runakunaman ninkuman: “Jesusqa wañusqanmantan kawsariramun”, nispanku. Sayna kaqtinqa chay discipulonkunapa llullakusqanchá, Jesuspa ñawpaq llullakusqanmantapas aswan masraq karunman, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Chaymi Poncio Pilatoqa paykunata niran: —Kaypin kashan soldadokunaqa. Paykunata pusaspayá chay sepulturataqa alli-allinta cuidachimuychis, munasqaykichisman hina, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Chaymi paykunaqa Jesuspa p'ampasqanku sepulturaman rispanku, chay sepulturapa punkuntaqa ama ni pipas haykunanpaq hatun rumiwan alli-allinta seguraranku. Hinaspan huk señalta churaranku, pipas ama kuyuchinanpaq. Hinaspan guardiakunata kamachiranku chay sepulturata tuta p'unchaw allinta cuidanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Samana p'unchaw pasaruqtinmi domingo achiqayta, María Magdalena, huknin Mariapiwan Jesusta p'ampasqanku sepulturata qawaq riranku. ");
INSERT INTO qveNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Chay ratopin qonqayllamanta huk hatun terremoto pasaran. Hinaqtinmi Diospa angelnin hanaq pachamanta urayamuspa sepultura tapasqanku rumita huk lawman tanqaran. Hinaspan chay rumi patapi tiyayuran. ");
INSERT INTO qveNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Chay angelqa rayo t'oqyamunanpaq llataq hina k'anchashaqmi karan. Hinallataq p'achanpas rit'i hinaraqmi sumaq yuraq ch'illo karan. ");
INSERT INTO qveNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Chayta rikuspankun sepultura cuidaq soldadokunaqa anchata mancharikuspanku, khatatataspa desmayarankuraq. ");
INSERT INTO qveNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Hinaqtinmi angelqa sepulturaman hamuq warmikunata, khaynata niran: —Ama mancharikuychishchu. Noqaqa yachanin cruzpi chakatasqa wañuq Jesusta mashkasqaykichista. ");
INSERT INTO qveNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Payqa manan kaypiñachu. Nisqanman hinan ña kawsarirunña. Sepultura ukhuman haykuspayá mayman cuerpon churasqanku sitiota qawamuychis. ");
INSERT INTO qveNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Hinaspayá apurayllaman rispa, Jesuspa discipulonkunaman kay kawsarimusqanmantaqa willamuychis. Jesusqa Galilea provincia lawmanmi ñawpaqniykichista rishan. Chaypin tupankichis paywanqa. Kay willakuytan kunanqa ña qankuna yachankichishña, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Saynata ángel niqtinmi warmikunaqa mancharisqa kashaspankupas anchata kusikuspa, chay sepulturamanta lloqsimuspanku, correyllaña Jesuspa discipulonkunaman willaq riranku. Hinaqtinmi ñanta rishaqtinku, ");
INSERT INTO qveNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Jesusqa paykunaman rikhurispan rimayukuran. Chaymi warmikunaqa ashuyuspanku, chakinkunata abrazaykuspa adoraranku. ");
INSERT INTO qveNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Hinaqtinmi Jesusqa paykunata khaynata niran: —Ama mancharikuychishchu. Aswan correylla rispaykichis discipuloykunaman willamuychis, Galilea provincia law llaqtaman rispanku, chaypi noqawan tupanankupaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Warmikunaqa Jesuspa discipulonkunata mashkaq rishanankukaman, sepulturata cuidaq wakin soldadokunaqa Jerusalén llaqtaman rispanku, chaypi sacerdotekunapa jefenkunaman tukuy ima pasasqanmanta willamuranku. ");
INSERT INTO qveNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Chaymi sacerdotekunapa jefenkunaqa, Israel nación llaqtapi kamachiq runakunapiwan huñunakuspa acordaranku, soldadokunaman ashka qolqeta paganankupaq, (saynapi chay soldadokuna rikusqankuta pimanpas ama willaspanku, aswan llullakuspa, sacerdotekunapa yachachisqanman hina willakunankupaq). ");
INSERT INTO qveNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Hinaspan chay sacerdotekunaqa soldadokunata yachachiranku khaynata: —Qankunaqa runakunaman willamuychis khaynata: “Tuta puñushaqtiykun Jesuspa discipulonkuna hamuspanku, Jesuspa cuerpontaqa suwarpariwanku”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Sichus kaykunamanta gobernador Poncio Pilato yacharunqa chayqa, noqaykun paywan parlamusaqku, qankunata ama imanasunaykichispaq, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Chaymi chay soldadokunaqa qolqeta chashkirukuspanku, sacerdotekunapa yachachisqanman hina runakunaman willaranku. Kay llullakuspa willasqankutan Israel nación llaqtayoq runakunaqa kunankamapas willanakushankuraq. ");
INSERT INTO qveNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jesuspa chunka hukniyoq discipulonkunan Jesuspa kamachisqanman hina, Galilea provincia lawpi orqoman riranku. ");
INSERT INTO qveNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Hinaqtinmi Jesusta chaypi rikuspanku adoraranku. Ichaqa wakin discipulonkunañataqmi Jesusta rikushaspankupas, mana creeyta atirankuchu, pay kikinpuni kashaqtinpas. ");
INSERT INTO qveNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Hinaqtinmi Jesusqa discipulonkunaman ashuyuspa, kamachiran khaynata: —Diosmi noqaman tukuy atiyta qowan hanaq pachapipas hinallataq kay pachapipas. ");
INSERT INTO qveNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Qankunaqa llapallan nación llaqtakunaman rispaykichisyá, runakunaman willamuychis, noqapi creespa discipuloykuna kanankupaq. Hinaspa Dios Taytapa, Dios Churipa, hinallataq Dios Santo Espiritupa sutinpi ima bautizamuychis. ");
INSERT INTO qveNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Saynallataq noqapa llapallan yachachisqaykunatapas yachachimuychis, paykuna kasukuq kanankupaq. Noqaqa sapa p'unchawmi qankunawan kasaq kay pacha tukukunan p'unchawkama, nispa.");
INSERT INTO qveNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Diospa Wawan Salvadorninchis Jesucristomanta allin willakuykunaqa khaynatan qallariran. ");
INSERT INTO qveNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","(Dios Taytan niran Wawan Jesucristoman Bautizaq Juanta mandamunanmanta). Diospa chay nisqantan ñawpaq tiempopiraq Diosmanta willakuq profeta Isaías escribiran khaynata: “Noqan mandamusaq willakuqniyta, qanpa ñawpaqniykita rispa willamunanpaq. Paymi ñanta allichaq hina, runakunata allinta yachachinqa, chayamuqtiyki sumaqta chashkisunaykikupaq Malaquías 3.1. ");
INSERT INTO qveNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ch'inñeq desierto lugarpin huk runa altollamantaña rimaspa willakushan khaynata: ‘¡Sonqoykichista allichaychis; Diosmanta Hamuq Salvadorta chashkinaykichispaq, imaynan wiksu ñankunatapas allichanku chay hinata!’ ” nispa Isaías 40.3. ");
INSERT INTO qveNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Bautizaq Juanqa runakunata ch'inñeq desierto lugarpi bautizashaspanmi, khaynata niran: —Diosman kutirikuychis huchaykichista saqespa, saynapi llapallan huchaykichista Dios perdonasunaykichispaq; hinaspataq bautizachikuychis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Chaymi Judea provincia lawmanta, hinallataq Jerusalén llaqtamanta ima, Juanpa willakusqanta uyariq ashka runakuna riranku. Hinaspan huchankuta willakuqtinku, Juanqa paykunata bautizaran Jordán mayupi. ");
INSERT INTO qveNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Bautizaq Juanpa p'achanmi karan hatun camello animalpa pelonmanta ruwasqa. Cinturan watakunanñataqmi karan qaramanta ruwasqa. Hinaspapas payqa langosta urukunata, hinallataq ch'inñeq desierto lugarkunapi abejapa mishk'inkunatan mikhuran. ");
INSERT INTO qveNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Hinaspan Bautizaq Juanqa runakunaman willaran khaynata: —Noqapa qepaytan noqamanta aswan más ancha atiyniyoq runa hamushan. Chaymi noqaqa paypa husut'anpa watullantapas mana pashkanaypaq hinachu kani. ");
INSERT INTO qveNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Noqaqa unullawanmi bautizashaykichis. Paymi ichaqa Diospa Santo Espiritunta qankunapi kananpaq qosunkichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jesusqa Nazaret llaqtapin kasharan. Chay Nazaret llaqtaqa Galilea provinciamanmi perteneceran. Chay p'unchawkunapin Jesusqa chay Nazaret llaqtamanta, hinallataq Galilea provinciamanta lloqsispa, Jordán mayuman riran. Hinaspan Jesusqa Bautizaq Juanwan chay Jordán mayupi bautizachikuran. ");
INSERT INTO qveNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Hinaqtinmi Jesusqa unu ukhumanta lloqsimushaspa, rikuran hanaq pacha cielo kicharikushaqta, hinallataq Diospa Santo Espirituntapas paloma hina payman urayamushaqta. ");
INSERT INTO qveNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Chay ratollapitaqmi Diosqa hanaq pachamanta nimuran khaynata: —Qanmi kanki ancha munakusqay Waway. Qanwanmi anchata kusikuni munasqayta ruwasqaykirayku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Chaymantan Diospa Santo Espiritunqa ch'inñeq desierto lugarman Jesusta pusaran. ");
INSERT INTO qveNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Chaypin Jesusqa tawa chunka p'unchaw phiña animalkunapa kasqanpi karan. Hinaqtinmi diabloqa payta huchaman urmachiyta munaran. Chaymantan Diospa angelninkunañataq, Jesusta cuidaspa servinankupaq hamuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Bautizaq Juanta carcelman churaruqtinkun, Jesusqa Galilea provincia lawman riran, Diosmanta allin willakuykunata yachachistin. ");
INSERT INTO qveNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Hinaspan payqa khaynata niran: —Diospa gobiernanan p'unchawmi ña chayamunña. Chayrayku Diosmanta allin willakuykunata uyarispa, huchaykichismanta wanakuychis. Hinaspa kay allin willakuykunapi creespaykichis, Diosta kasukuspa kawsaychis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesusqa Galilea laguna qochapa patanta rishaspanmi, Simonta, hinallataq wawqen Andrestawan rikuran. Paykunaqa challwa hap'iqkuna kaspankun mallankuwan challwata challwasharanku. ");
INSERT INTO qveNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Hinaspan Jesusqa paykunata khaynata niran: —Hamuychis noqawan kushka purinaykichispaq. Noqan qankunaman yachachisqaykichis, imaynan challwata challwankichis, saynallatataq runakunatapas huñunaykichispaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Chaymi Simonqa wawqen Andrespiwan kasqan ratolla mallankuta saqespa, Jesusta qatikuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jesusqa Galilea laguna qochapa patanta rishaspanmi, rikullarantaq Jacobota, wawqen Juanta, hinallataq papanku Zebedeotawan ima. Paykunan mallankuta botenkupi remendashasqaku. ");
INSERT INTO qveNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Hinaspan Jesusqa Jacobota hinallataq Juantawan waqyaran. Chaymi paykunaqa papanku Zebedeota, hinallataq paykunapaq llank'aq runakunatawan botepi saqespa, Jesusta qatikuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesusqa Capernaúm llaqtamanmi chayaruran. Hinaspan samana p'unchawpi sinagoga wasiman haykuspa, runakunaman yachachiyta qallariran. ");
INSERT INTO qveNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Jesusqa manan leykunamanta yachachiq runakuna hinachu yachachiran. Aswanmi payqa huk ancha yachayniyoq kaspa, ancha atiywan yachachiran. Chayraykun llapallan runakunaqa Jesuspa yachachisqanwan anchata admirakuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Chay ratollapitaqmi demoniokunapa ñak'arichisqan huk runa chay sinagoga wasipi kasharan. Hinaqtinmi chay runaqa qaparispa, Jesusta niran: ");
INSERT INTO qveNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¡Yaw, Nazaret llaqtayoq Jesús! ¿Imatataq noqaykuwanri munankí? ¿Noqaykuta wañuchiqchu qanqa hamurankí? Noqaqa reqsiykin pi kasqaykita. ¡Qanqa Diospa Wawanmi kanki, mana ni ima huchayoq! nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesusñataqmi chay demoniotaqa q'aqchaspa khaynata niran: —¡Upallay, hinaspa lloqsiy kay runamanta! nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Hinaqtinmi chay demonioqa, chay runata anchata khatatatachisparaq chay runamanta altota qaparispa lloqsiran. ");
INSERT INTO qveNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Hinaqtinmi chaypi kaq runakunaqa admirasqallaña paykunapura tapunakuranku khaynata: —¿Imataq kay rikusqanchisrí? ¿Ima mosoq yachachikuytaq kayrí? Atiyninwan kamachiqtinmi demoniokunapas kasukuspa lloqsinku, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Chaymi Jesusmantaqa chay enteron Galilea provincia llaqtakunapi astawanraq rimaranku, Jesuspa yachachisqanmanta hinallataq ruwasqankunamantawan ima. ");
INSERT INTO qveNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesusqa sinagoga wasimantan lloqsiran. Hinaspan Jesusqa Jacobopiwan hinallataq Juanpiwan riran, Simón Pedropa hinallataq Andrespa tiyasqanku wasiman. ");
INSERT INTO qveNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Chay wasipin Simonpa suegranqa fiebrewan camapi onqoshasqa. Hinaqtinmi chay wasiman Jesús haykuyuqtin willaranku Simonpa suegranmanta. ");
INSERT INTO qveNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Chaymi Simonpa suegranman Jesusqa ashuyuspa, makinmanta hatariykachiran. Hinaqtinmi fiebrenmantaqa kasqan ratolla sanoyaran. Hinaspan Simonpa suegranqa paykunaman mikhunata serviran. ");
INSERT INTO qveNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Inti haykuspa tutayaykushaqtinñan Jesusman apamuranku demoniokunapa ñak'arichisqan ashka runakuna, hinallataq onqosqa runakunatawan ima. ");
INSERT INTO qveNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Chaymi chay llaqtapi tiyaq runakunaqa, Simonpa wasi punkunman llapallanku huñunakamuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Hinaqtinmi Jesusqa sanoyachiran tukuy imaymana onqoyniyoq runakunata. Hinallataq llapallan demoniokunatapas runakunamanta qarqoran. Chay demoniokunaqa reqsirankun pis Jesusqa kasqantaqa. Chayraykun Jesusqa mana dejaranchu chay demoniokuna rimanankutaqa. ");
INSERT INTO qveNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ña achiqaramushaqtinñan Jesusqa chay Capernaúm llaqtamanta lloqsiran. Hinaspan huk ch'inñeq desierto lugarman riran, chaypi orakunanpaq. ");
INSERT INTO qveNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Hinaqtinmi Simonqa puriqmasinkunapiwan, Jesusta mashkamuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Jesusta tariruspankutaqmi khaynata niranku: —Llapallan runakunan mashkashasunki, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Chaymi Jesusqa paykunata niran: —Hakuchi kay cercapi llaqtakunaman, chay llaqtakunapipas kay allin willakuykunata willamunaypaq. Noqaqa chaypaqmi kay pachamanqa hamurani, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Hinaspan Jesusqa enteron Galilea provincia llaqtakunapi puriran, sinagoga wasikunapi yachachistin, saynallataq runakunamantapas demoniokunata qarqostin ima. ");
INSERT INTO qveNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Huk runan lepra onqoyniyoq Jesusman ashuyuran. Hinaspan Jesuspa ñawpaqninpi qonqoriyukuspa, ruegakuran khaynata: —Señorlláy, munaspaykiqa kay onqoyniymantayá sanoyaykachiway, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Chaymi Jesusqa chay lepra onqoyniyoq runata anchata khuyapayaykuspan, makinwan llamiykuspa niran: —Arí, noqaqa munanin sanoyanaykita, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Saynata Jesús rimayta tukurullaqtinmi, kasqan ratolla chay runaqa lepra onqoyninmanta sanoyaran. ");
INSERT INTO qveNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Chaymi Jesusqa chay sanoyapuq runata, manaraq ripushaqtin allinta avisaspa, khaynata niran: ");
INSERT INTO qveNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Aman pimanpas kaykuna pasasusqaykimantaqa willankichu. Aswanyá sacerdotekunaman rispa, qawachikamuy sanoña kasqaykita. Hinaspayki Moisespa escribisqan leyman hina ofrendaykita qomuy. Saynapin paykunaqa sanoña kasqaykita yachanqaku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ichaqa chay lepra onqoymanta sanoyaq runaqa, chaymanta lloqsispanmi llapallan runakunaman willakachakuyta qallariran, Jesús imaynatas payta sanoyachisqanmanta. Chaymi Jesusqa manaña ni mayqen llaqtamanpas alayritaqa haykuyta atiranñachu. Hinaqtinmi Jesusqa llaqtapa cercan ch'inñeq desierto lugarkunallapiña puriran. Sayna kashaqtinpas runakunaqa tukuy lawmantan Jesuspa kasqanmanqa rirankupuni. ");
INSERT INTO qveNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Jesusqa ishkay kinsa p'unchawmantañan kaqmanta Capernaúm llaqtaman kutimuran. Chaymi chay Capernaúm llaqtapi tiyaq runakunaqa yacharuranku, Jesusqa huk wasipi kasqanta. ");
INSERT INTO qveNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Hinaqtinmi chay wasiman ashka runakunaqa huñunakamuranku. Chaypin Jesusqa Diosmanta allin willakuykunata runakunaman yachachiran. Chaymi ashka runakuna chay wasi ukhuman hunt'aruqtinku, manaña chay wasi punkunpipas campoqa karanñachu. ");
INSERT INTO qveNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Hinaqtinmi huk mana puriq runata tawa runakuna kallapipi wantuyukuspa chay wasiman apamuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Chaymi chay wasipa punkunpi ashkallaña runakuna kasqanrayku, mana ni maynintapas wasi ukhumanqa apayuyta atirankuchu. Chaymi paykunaqa wasi pataman wichachispanku, chay wasi patata t'oqoranku. Hinaspan chay mana puriq runataqa, chayninta kallapipi Jesuspa ñawpaqninman urayachiranku. ");
INSERT INTO qveNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Chaymi Jesusqa chay wantumuq runakunapa iñiyninkuta yachaspa, chay mana puriq runata niran: —Wawáy, huchaykikunatan perdonayki, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Chaypin kasharanku leykunata yachachiq wakin runakunapas. Hinaspan paykunaqa Jesuspa nisqanta uyarispanku, sonqonku ukhullapi piensaranku khaynata: ");
INSERT INTO qveNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Kay runari, ¿imanaqtintaq kaykunatari riman? Saynata rimaspaqa, Diostan ofiendeshan. ¿Pitaq runakunapa huchankunatari perdonanman? ¡Aswanqa runakunapa huchantaqa Diosllan perdonaytaqa atin!” nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Chaymi Jesusqa sonqollankupi piensasqankuta yachaspa, paykunata tapuran: —Qankunari, ¿imanaqtintaq saynatari sonqoykichis ukhullapi piensashankichís? ");
INSERT INTO qveNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kunanyá niwaychis: ¿Imataq más facilri kanman? ¿Kay mana puriq runapa huchankunata perdonaychú? Icha ¿“kallapiykita oqarispa ripuy” niychú? ");
INSERT INTO qveNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kunanmi yachankichis, noqa Diosmanta Hamuq Runaqa kay pachapi runakunapa huchankunata perdonanaypaq atiyniyoq kasqayta, nispa. Chayta rimayta tukuruspanmi, Jesusqa chay mana puriq runata niran: ");
INSERT INTO qveNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Sayariy; hinaspa chay kallapiykita oqarispa wasiykiman ripuy, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Chaymi kasqan ratolla, chay mana puriq runaqa sayariran. Hinaspan llapallan runakuna qawashaqtinku, kallapinta oqarispa ripuran. Chaypi kaq llapallan runakunañataqmi anchata admirakuspa, Diosta alabaranku khaynata: —¡Kaykunataqa manan ni hayk'aqpas rikuranchishchu! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesusqa kaqmantan Galilea laguna qochapa patanman riran. Hinaqtinmi ashka runakuna paypa kasqanman huñunakamuranku. Chaymi Jesusqa paykunata chaypi yachachiran. ");
INSERT INTO qveNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Chaymanta rishaspanmi, Jesusqa Alfeopa wawan Leví sutiyoq runata rikururan. Payqa impuesto cobraq kaspanmi, impuesto cobranan mesapi tiyasharan. Hinaqtinmi Jesusqa payta niran: —Qatikuway, nispa. Chaymi chay Leví sutiyoq runaqa tiyasqanmanta kasqan ratolla sayarispa Jesusta qatikuran. Nota: Leviypa huknin sutinqa karan Mateo. ");
INSERT INTO qveNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Chaymantan Jesusqa discipulonkunapiwan kushka Leviypa wasinman riran. Hinaqtinmi Jesustaqa ashka runakuna qatikuranku. Jesusqa Leviypa wasinman chayaruspanmi Leviywan kushka hinallataq discipulonkunapiwan ima mesapi tiyayuspa mikhusharan. Paykunawan kushkan chay mesapi tiyayuspa mikhullasharankutaq impuesto cobraq runakunapas, hinallataq ashka huchasapa runakunapas. ");
INSERT INTO qveNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Chaymi leykunata yachachiq runakuna, hinallataq fariseo religionniyoq runakunapas, Jesuspa discipulonkunata tapuranku khaynata: —Kay yachachisuqniykichis Jesusri, ¿imanaqtintaq kay impuesto cobraq huchasapa runakunawan, hinallataq wakin huchasapa runakunawanpas kushkari mikhushan? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Chaymi Jesusqa chay nisqankuta uyarispa, paykunata niran: —Medicotaqa onqosqa runakunallan necesitanku; sano runakunan ichaqa mana necesitankuchu. Noqaqa manan justo tukuq runakunata salvaqchu hamurani. Aswanqa huchasapa runakunata salvanaypaqmi hamurani, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Huk p'unchawmi Bautizaq Juanpa discipulonkuna, hinallataq fariseo religionniyoq runakunapa discipulonkunapas ayunasharanku. Chayta wakin runakuna rikuspankun, Jesusta tapuranku khaynata: —Qanpa discipuloykikunari, ¿imanaqtintaq mana ayunankuchú? Bautizaq Juanpa discipulonkunapas, hinallataq fariseo religionniyoq runakunapa discipulonkunapas ayunankutaq, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Chaymi Jesusñataq paykunata contestaspa niran: —Huk casarakuy fiestaman invitasqa runakunaqa manan ayunankumanchu, casarakuq novio chayllapiraq kashaqtinqa. ");
INSERT INTO qveNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Aswanmi kanqa p'unchawkuna, noqa (iglesiapa novion) qankuna ukhumanta qechusqa kaqtiy, discipuloykunapas ayunanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Thanta p'achataqa manan ni pipas mosoq telawanqa remendanmanchu. Saynata remendaqtinqa chay mosoq remiendoqa ch'intispanmi astawan chay thanta p'achataqa llik'irunman. ");
INSERT INTO qveNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Saynallataqmi manaraq poqosqa vinotaqa mana ni pipas hich'anmanchu thanta odrekunamanqa. Ichaqa chay vino poqoruspanmi chay thanta odrekunataqa phatarachinman. Hinaspan vinopas usunman, hinallataq odrekunapas manaña ni imapaqpas valenmanñachu. Chaymi manaraq poqosqa vinotaqa mosoq odrekunaman hich'ana, nispa. Nota: Mana poqosqa vinon rikch'akun Jesuspa yachachisqankunaman. Poqosqa vinoñataqmi rikch'akun Israel nacionniyoq runakunapa ñawpaq mana valeq costumbrenkunaman. Chaymi Diospa palabrankunamanqa costumbrenchiskunataqa mana yapananchishchu. ");
INSERT INTO qveNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jesusqa discipulonkunapiwan kushkan trigo chakraq ukhunta huk samana p'unchawpi risharanku. Hinaqtinmi discipulonkunaqa trigopa espigankunata pallayta qallariranku mikhunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Chay pallasqankuta rikuspankun fariseo religionniyoq runakunaqa Jesusta niranku: —¡Qawariy! ¿Imanasqataq discipuloykikunari, samana p'unchawpi trigopa espigantari pallashanku prohibisqa kashaqtin? Moisespa escribisqan leyman hinaqa chaykunata ruwaspankuqa manan kasukushankuchu, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Hinaqtinmi Jesusqa paykunata contestaspa, khaynata niran: —¿Manachu qankunari ni hayk'aqpas Bibliapi leerankichis, rey Davidpas imatachus ruwasqanta? Payqa puriqmasinkunapiwan kushkan anchata yarqachikuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Hinaspan Dios yupaychana tabernáculo nisqa wasiman haykuran, Abiatar runa sacerdotekunapa jefen kashaqtin. Hinaspan chay tabernáculo ukhupi, sacerdotekunallapa mikhunankupaq churasqa t'antakunata mikhuran. Saynallataqmi puriqmasinkunamanpas qollarantaq mikhunankupaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Chaymantan Jesusqa paykunata nillarantaq khaynata: —Diosqa runakunataqa unancharan manan samana p'unchawraykuchu. Aswanmi Diosqa runakunapa allinninpaq chay samana p'unchawtaqa unancharan. ");
INSERT INTO qveNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Chayraykun noqa Diosmanta Hamuq Runaqa samana p'unchawpapas dueñon kani. Chaymi noqaqa kamachinaypaq atiyniyoq kani, samana p'unchawpi runakuna imatas ruwanankupaq otaq imatapas mana ruwanankupaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesusmi yapamanta haykuran Diosmanta yachachina sinagoga wasiman. Chaypin kasharan huk mana valeq makiyoq runa. ");
INSERT INTO qveNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Chaymi fariseo religionniyoq runakunaqa Jesusta disimulawlla qawaranku, samana p'unchawpi chay mana valeq makiyoq runata sanoyachiqtinqa, chayman tumpalla acusanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Hinaqtinmi Jesusqa chay mana valeq makiyoq runata niran: —Hatarimuy, hinaspa chawpinkupi sayay, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Hinaspan Jesusqa chaypi kaq runakunata tapuran khaynata: —Samana p'unchawpiri, ¿allin kaqtachu icha mana allin kaqtachu ruwana? ¿Runa sanoyachiychu icha runa wañuchiychu allin kanman? nispa. Chayta uyarispankun chaypi kaq runakunaqa mana ni imatapas rimarispa, upallalla karanku. ");
INSERT INTO qveNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Hinaqtinmi Jesusqa muyuriqninpi kaq runakunata qawarispa, anchata phiñakuspa llakikuran, chay runakunaqa rumi sonqo kaspanku, mana entiendesqankurayku. Hinaspan chay mana valeq makiyoq runata niran: —Makiykita haywarimuway, nispa. Makinta haywariqtinmi, chay runapa mana valeq makinqa kasqan ratolla sanoyaran. ");
INSERT INTO qveNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Chaymi fariseo religionniyoq runakunaqa lloqsimuspanku, kamachiq rey Herodespa partidonmanta runakunapiwan huñunakuspa parlaranku, imaynatas Jesusta wañuchinankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesusqa discipulonkunawan kushkan Galilea laguna qochapa patanman riranku. Chaymanmi runakuna hamuranku Galilea provincia lawmanta, Judea provincia lawmanta, ");
INSERT INTO qveNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalén llaqtamanta, Idumea provincia lawmanta, Jordán mayupa waq law chimpanmanta, hinallataq Tiro hinaspa Sidón llaqtakunapa muyuriqninpi kaq llaqtakunamantawan ima. Paykunaqa Jesuspa tukuy ima ruwasqankunata uyarispankun hamuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Chaymi Jesuspa muyuriqninpi ashkallaña runakuna karanku. Chayraykun Jesusqa discipulonkunata kamachiran, huk boteta listollataña suyachinankupaq. Saynataqa kamachiran chay ashka runakuna tanqanakuspa Jesusta ñit'imuqtinkun, hinaspa chay boteman qespispa chaymanta yachachimunanpaqmi. ");
INSERT INTO qveNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jesusqa chay lugarpin ashka runakunata tukuy onqoyninkumanta sanoyachiran. Chayraykun wakin onqosqa runakunapas, onqoyninkumanta sanoyayta munaspanku, Jesustaqa tupayuytapuni munaranku. ");
INSERT INTO qveNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Saynallataqmi demoniokunapa kamachisqan runakunapas Jesuspa ñawpaqninpi qonqorikuranku. Hinaspan chay demoniokunaqa altota qaparispa niranku: —¡Qanqa Diospa Wawanmi kanki! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Hinaqtinmi Jesusqa chay demoniokunata q'aqchaspa upallachiran, paykuna saynata qaparqachaspanku Jesusqa pis kasqanta runakunaman ama rimashanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesusqa huk orqomanmi riran. Hinaspan paypa kasqanman ashuyunankupaq akllasqan runakunallata waqyaran. Hinaqtinmi chay akllasqan runakunaqa paypa kasqanman ashuyuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Hinaqtinmi Jesusqa chaypi kaq runakunamanta chunka ishkayniyoq runakunallata akllaran, apostolninkuna kaspanku, paywan purinankupaq. Hinaspan kamachiran, Diosmanta allin willakuykunata runakunaman willamunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Hinallataq atiytapas qoran, runakunamanta demoniokunata qarqomunankupaq, {saynallataq tukuy imaymana onqoyniyoq runakunatapas sanoyachimunankupaq ima}. ");
INSERT INTO qveNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jesuspa akllasqan chunka ishkayniyoq apostolninkunan karanku kay runakuna: Simón, paypa huknin sutinmi karan Pedro; ");
INSERT INTO qveNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Juan hinallataq wawqen Jacobo; paykunan karanku Zebedeopa wawankuna; paykunatan Jesusqa “Boanerges” sutiwan suticharan; Boanergesqa “rayo t'oqyamuqpa wawankuna” ninantan nin; ");
INSERT INTO qveNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés; Felipe; Bartolomé; Mateo; Tomás; Alfeopa wawan Jacobo; Tadeo; cananista partidomanta kaq Simón; ");
INSERT INTO qveNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","hinallataq Judas Iscariote ima. Kay Judas Iscarioten Jesusta traicionaspa, enemigon runakunaman entregaran. ");
INSERT INTO qveNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Chaymantan Jesusqa discipulonkunapiwan huk wasiman kutimuranku. Hinaqtinmi ashkallaña runakunaqa Jesuspa kasqanman yapamanta huñunakamuranku. Chaymi Jesuspa, hinallataq discipulonkunapapas manaña tiemponku karanñachu ni mikhunankupaqpas. ");
INSERT INTO qveNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Hinaqtinmi Jesuspa familiankunaqa runakunapa khayna rimasqankuta uyariranku: “Jesusqa locoyasqa hinañan kashan, manañan yuyayninpiñachu”, nisqankuta. Chaymi paykunaqa Jesusta pusakapunankupaq hamuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Saynallataqmi leykunata yachachiq runakunapas, Jerusalén llaqtamanta hamuspanku niranku: —Kay Jesusqa demoniokunapa jefen Beelzebú sutiyoq diablopa atiyninwanmi runakunamantaqa demoniokunata qarqon, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Hinaqtinmi Jesusqa paykunata waqyaspa, huk willakuyta willaran khaynata: —Niwaychisyá, ¿diablo atinmanchu pay kikillanta qarqokuyta? ");
INSERT INTO qveNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Sichus huk nación llaqtapi tiyaq runakuna cheqninakuspa rakinakunkuman chayqa, chay nación llaqtaqa purmapunqan. ");
INSERT INTO qveNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Hinallataq sichus huk wasipi tiyaq runakunapas cheqninakuspa kawsankuman chayqa, peleaspankun rakinakunqaku. ");
INSERT INTO qveNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Saynallataqmi sichus diablopas demoniokunapa contranpi hatarinman chayqa, paykunapas dividinakuspan rakinakunkuman. Saynata ruwaspankuqa fracasaspan chinkapunkuman. ");
INSERT INTO qveNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kunan nisqaykichis, sichus pipas huk kallpasapa runapa wasinmanta imatapas qechuyta munaspaqa, primertan chay kallpasapa runataraq alli-allinta chaqnanan. Hinaspañan chay runapa wasinpi imankunatapas qechuytaqa atinman. Nota: Chay kallpasapa runaqa, diablon. Chay kallpasapa runata chaqnaqñataqmi, Jesús. Jesusmi Santo Espiritupa atiyninwan diablomanta ashka runakunata qechun, infiernoman ama rinankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Chaymi cheqaqtapuni niykichis, Diosqa runakunapa tukuy huchankunatapas, hinallataq tukuy mana allin rimasqankutapas perdonanqan. ");
INSERT INTO qveNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ichaqa Santo Espiritupa contranpi ofendespa rimaq runakunataqa, manan ni hayk'aqpas Diosqa perdonanqachu. Aswanmi paykunaqa wiñaypaq huchayoq kanqaku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesusqa saynataqa niran, leykunata yachachiq runakuna Jesusmanta khaynata rimaqtinkun: “Jesusqa demoniokunapa atiyninwanmi milagrokunataqa ruwan”, niqtinkun. ");
INSERT INTO qveNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesusqa chay kasqan wasipi kallashaqtinraqmi, wawqenkuna hinallataq mamitan ima chayman hamuranku. Paykunaqa hawallapi suyaspankun, Jesusta waqyachimuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Hinaqtinmi Jesuspa ladonpi tiyaq runakunaqa, khaynata niranku: —Mamitaykin wawqeykikunapiwan {hinallataq panaykikunapiwan ima} hawapi kashanku. Paykunan mashkamushasunkiku, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Hinaqtinmi Jesusqa chaypi kaq runakunata, khaynata niran: —¿Pitaq mamitayrí? ¿Pikunataq wawqeykunarí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Chayta niruspanmi, ladonpi tiyaq runakunata qawayuspa, Jesusqa niran: —Kay runakunan mamitaypas, hinallataq wawqeykunapas. ");
INSERT INTO qveNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ichaqa Dios Taytaypa munayninta ruwaq runakunan wawqeykunapas, panaykunapas, hinallataq mamitaypas, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesusqa chay hatun laguna qochapa patanpin yapamanta yachachiyta qallariran. Hinaqtinmi ashka runakuna chayman huñunakamuqtinku, Jesusqa huk boteman wicharan. Hinaspan chay botepi Jesusqa tiyayuran yachachinanpaq. Chaypi kaq runakunañataqmi chay laguna qochapa patanpi qepakuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Hinaspan Jesusqa tukuy imaymanata yachachiran ejemplokunawan. Chaymi Jesusqa huk ejemplota willaspa, khaynata yachachiran: ");
INSERT INTO qveNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Uyariychis kayta. Huk runan mukhu t'akaq riran. ");
INSERT INTO qveNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Chaypi t'akashaqtinmi, wakin mukhuqa ñan patakunaman urmaran. Hinaqtinmi mukhu alayrillapi kaqtin pichinkukuna hamuspa mikhuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Wakin mukhuñataqmi ranra-ranraman urmaran. Chaypin chay mukhuqa mana ashka allpallapi wiñamuran. ");
INSERT INTO qveNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ichaqa saphin mana ashka allpapi kaqtintaqmi, inti lloqsiramuspa ch'akichiran. ");
INSERT INTO qveNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Wakin mukhuñataqmi kishka-kishka ukhukunaman urmaran. Chaymi chay kishkakunaqa, chay mukhu wiñamuqmantapas aswan mastaraq wiñaruspa taparuran; chaymi chay mukhu wiñamuqqa q'elloyaspa mana rururanchu. ");
INSERT INTO qveNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Wakin mukhuñataqmi allin wanu allpaman urmaran. Chaymi chay mukhuqa sumaqta wiñamuran. Hinaspan wakin mukhuqa kinsa chunkata rururan, wakintaq soqta chunkata, wakinñataq pachaqta, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Chayta willaspanmi Jesusqa niran: —¡Sichus cheqaqtapuni ninriyoq kankichis chayqa, allintayá uyariychis kay nisqaykunata! nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Runakunaqa Jesuspa kasqanmantan yaqa llapallanku pasapuranku. Hinaqtinmi Jesuspa chunka ishkayniyoq discipulonkunaqa, hinallataq chaypi qepakuq wakin runakunapiwan, Jesusta tapuranku chay mukhu t'akay willakusqan ejemplomanta. ");
INSERT INTO qveNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Chaymi Jesusqa contestaspa, khaynata niran: —Diospa gobiernanan sumaq glorianqa pakasqa hinan kasharan. Chaytan qankunallaman clarota yachachishaykichis. Noqapi mana creeyta munaq runakunamanmi ichaqa, kay ejemplokunallawan yachachini, ");
INSERT INTO qveNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","saynapi ñawinku qawashaqtinpas ama rikunankupaq, ninrinku uyarishaqtinpas ama entiendenankupaq. Sichus paykuna rikunkuman otaq uyarinkuman chayqa, huchankumanta wanakuspan Diosman kutirikunkuman perdonasqa kanankupaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesusqa discipulonkunatan nillarantaq: —¿Qankunapas manachu entiendenkichis kay ejemplowan yachachisqaykunata? Chayri, ¿imaynataq entiendewaqchis wakin yachachisqaykunatarí? ");
INSERT INTO qveNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Chay mukhu t'akaq runaqa Diospa palabranta willakuqmi. ");
INSERT INTO qveNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ñan patakunaman urmaq mukhuqa rikch'akun, allin willakuykunata uyarishaspa, rumi sonqo runakunamanmi. Ichaqa chay willakuy uyarisqankutan diablo hamuspa paykunamanta qechun mana ni imatapas entiendenankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ranra-ranraman urmaq mukhuqa rikch'akun, Diospa palabranta uyarispa kusisqallaña chashkikuq runakunamanmi. ");
INSERT INTO qveNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ichaqa mana allinta creespankun paykunaqa chay mukhu wiñamuq hina, hawallapi saphiyoq kaspanku, pisi tiempollapaq Diospi creenku. Hinaspan sasachakuy, hinallataq qatikachasqa kana p'unchawkuna chayamuqtin Diosmanta karunchakunku. ");
INSERT INTO qveNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Kishka-kishka ukhuman urmaq mukhuqa rikch'akun, Diospa palabranta uyariq runakunamanmi. ");
INSERT INTO qveNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ichaqa paykunaqa aswan qapaq kayta munaspankun afanasqallaña qolqe mashkaypi purinku; hinallataq kay pachapi tukuy kusikuykunallapi kawsankupas. Chaymi paykunaqa chaykuna ruwasqankuwan Diospa palabrantaqa sonqonkumanta chinkachispa, mana ruruchinkuchu. ");
INSERT INTO qveNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ichaqa allin wanu allpaman urmaq mukhuñataqmi rikch'akun, Diospa palabranta tukuy sonqonkuwan chashkikuq runakunaman. Paykunan ichaqa Diospa palabranta allinta kasukuspa, kusikuy sonqonkuwan Diosta qatikunku. Chaymi paykunaqa chay allin allpaman urmaq mukhu hina kanku. Hinaspan sumaqta wiñaspa, rurunkupas kinsa chunkata, wakintaq soqta chunkata, wakinñataq pachaqta ima, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesusqa nillarantaqmi khaynata: —Mecherota ratachispari, ¿churawaqchishchu huk cajonpa pachanman otaq puñunaykichis catrepa pachanman? ¡Manan! Chay ratashaq mecherotaqa alayri alto patamanmi churana, chaymanta allinta k'anchamunanpaq. ");
INSERT INTO qveNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Saynan llapallan tukuy ima pakasqa kaqkunapas, hinallataq secretollapi kaqkunapas, yachasqa kanqa. ");
INSERT INTO qveNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","¡Sichus cheqaqtapuni ninriyoq kankichis chayqa, allintayá uyariychis kay nisqaykunata! nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Chaymantan Jesusqa nillarantaq: —Qankunaqa kay nisqaykunatayá allinta uyariychis. Imaynatan qankuna runamasiykichiswan ruwankichis, saynatan Diospas qankunawan ruwanqa. Hinaspapas Diosqa qankunamanqa aswan mastaraqmi qosunkichis. ");
INSERT INTO qveNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Pipas Diospa yachachikuyninta allinta uyarinqa chayqa, Diosmi payman astawanraq yachayta qonqa. Ichaqa Diospa palabranta mana entiendey munaq runakunamantan, Diospuni qechunqa pisilla yachasqankutapas, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesusqa nillarantaqmi: —Diospa gobiernasqan sumaq glorianqa rikch'akun, chakrapi mukhu t'akaq runamanmi. ");
INSERT INTO qveNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Chay mukhu t'akaq runaqa, manan yachanchu chay mukhu imaynatas wiñamusqantaqa, puñushaqtinchus icha rikch'ashaqtinchus, tutachus icha p'unchawchus chaytaqa. ");
INSERT INTO qveNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Aswanmi chay allpa ukhupi mukhuqa kikillanmanta wiñamun. Hinaspan wiñasqanman hina espigan. Chaymantataq ruruspa poqon. ");
INSERT INTO qveNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Chay espiga poqoruqtintaqmi, chay mukhu t'akaq runaqa, ishunawan kuchuspa, cosechan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesusqa nillarantaqmi: —Diospa gobiernasqan sumaq gloriantari, ¿imawantaq comparasunman? ¿Ima willakuywantaq yachachisunman? ");
INSERT INTO qveNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Diospa gobiernasqan sumaq glorianqa mostaza mukhu hinan. Chay mostaza mukhu tarpusqankuqa, llapallan mukhukunamantapas aswan más uchuychallan. ");
INSERT INTO qveNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ichaqa wiñaramuspantaqmi huertapi wakin plantakunamantapas aswan más hatun ramasapa sach'a hinamanraq tukun. Chaymi pichinkukunapas hamuspanku, ramankunapi thapachakunku. Hinallataq llantukunku ima, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesusqa ashka ejemplokunawanmi Diospa palabranmanta runakunaman yachachiran, entiendesqankuman hinalla. ");
INSERT INTO qveNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Jesusqa imata yachachispapas ejemplokunawanpunin yachachiran. Ichaqa discipulonkunawan sapallankupi kaspanqa, llapallan yachachikuytan paykunamanqa allinta entiendechiran. ");
INSERT INTO qveNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jesusqa chay p'unchaw tardeykuytañan discipulonkunata niran: —Hakuchiyá laguna qochapa waq law chimpanman, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Hinaspan chaypi llapallan runakunata despediratamuspa, Jesusqa wichasqan botepi discipulonkunapiwan kushka, laguna qochapa waq law chimpanman riranku. Saynallataqmi wakin runakunapas huk botekunapi riranku. ");
INSERT INTO qveNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Chaymi chay botepi rishaqtinku, qonqayllamanta nishuta wayra-wayramuran. Hinaqtinmi laguna qochapi unupas qallchikamuspa, risqanku boteman hunt'ayta qallarimuran. ");
INSERT INTO qveNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ichaqa Jesusñataqmi, chay risqanku botepa qepa lawninpi sawnayukuspa puñusharan. Hinaqtinmi discipulonkunaqa altota qaparispa, Jesusta rikch'achispa niranku: —¡Yachachikuq, yaqañan chinkaykushanchishña! ¿Manachu qanmanri ni imapas qokusunkí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Chaymi Jesusqa hatarimuspa, chay wayrata hinallataq laguna qochapi unutawan thañinanpaq kamachiran. Hinaqtinmi kasqan ratolla wayrapas, hinallataq unupas thañipuran. ");
INSERT INTO qveNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Chaymantañataqmi Jesusqa discipulonkunata niran: —¿Imanaqtintaq qankunari nishu mancharisqallaña kashankichís? ¿Manachu noqapi confiankichís? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Hinaqtinmi chaypi llapallan kaq discipulonkunaqa anchata admirakuspanku, paykunapura parlanakuranku khaynata: —¿Pitaq kay runari, wayrapas unupas kasunanpaqrí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesusqa discipulonkunapiwan kushkan Galilea laguna qochata chimparanku. Hinaspan Gadara llaqtaman chayaranku. Nota: Gadara llaqtapa huknin sutinqa Gerasan. ");
INSERT INTO qveNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Hinaqtinmi Jesusqa risqanku botemanta urayushaqtin, demoniokunapa ñak'arichisqan huk runa panteonmanta lloqsimuspa, Jesuspa kasqanman hamuran. ");
INSERT INTO qveNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Chay runaqa demoniokunapa ñak'arichisqan kaspanmi, panteonllapiña tiyaran. Chay runataqa manan ni pipas ni cadenakunawanpas sujetayta atirankuchu. ");
INSERT INTO qveNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Hinaspapas chay runataqa ashka kutitañan fierromanta ruwasqa cadenakunawan chaqnaranku. Saynata watashaqtinkupas, chay cadenakunataqa t'ipiranmi. Chaymi mana ni pipas controlaytaqa atirankuchu. ");
INSERT INTO qveNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Hinaqtinmi tuta p'unchaw chay demoniokunapa ñak'arichisqan runaqa panteonkunapi, orqokunapi qaparqachaspa, hinallataq cuerpontapas rumikunawan k'irikuspa ima puriran. ");
INSERT INTO qveNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Chaymi chay demoniokunapa ñak'arichisqan runaqa, Jesusta karullapiraq rikuruspa, apurayllamanña hamuran. Hinaspan Jesuspa ñawpaqninpi qonqorikuspa, ");
INSERT INTO qveNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","chay runaqa qaparispa, khaynata niran: —Tukuy atiyniyoq Diospa Wawan Jesús, ¿imatataq noqawanri munankí? ¡Diosraykun ruegakuyki, ama ñak'arichiwanaykipaq! nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Saynatan demonioqa niran, antestaraq Jesús khaynata nisqanrayku: —¡Yaw, demonio, lloqsiy kay runamanta! nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Hinaspan Jesusqa chay demoniokunapa ñak'arichisqan runata tapuran: —¿Imataq qanpa sutiykirí? nispa. Chaymi chay demonioqa contestaran: —Noqapa sutiyqa waranqa-waranqantinmi, ashka kasqaykurayku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Hinaqtinmi chay demoniokunaqa Jesusta anchata ruegakuranku khaynata: —Amayá kaymantaqa huk lawmanqa qarqoruwaykuchu, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Chay ladonku orqopitaqmi ashka khuchikuna mikhusharanku. ");
INSERT INTO qveNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Chaymi chay demoniokunaqa Jesusta ruegakuranku khaynata: —Waq khuchikunaman haykunaykupaqyá dejaykuwayku, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Hinaqtinmi Jesusqa chay demoniokunaman permisota qoran. Chaymi chay demoniokunaqa chay runamanta lloqsiruspanku, khuchikunapa cuerponman haykuranku. Hinaqtinmi chay khuchikunaqa qata urayta p'itaspanku, Galilea laguna qochaman urmayuspa, chaypi heq'epaspa wañuranku. Chay khuchikunaqa ishkay waranqa hinan karanku. ");
INSERT INTO qveNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Hinaqtinmi chay khuchita michiq runakunaqa llaqtaman ayqekuranku. Hinaspan chaykuna pasasqanmanta chay llaqtapi, hinallataq llaqtapa camponkunapipas willakachakamuranku. Chaymi llapallan runakunaqa chaykuna pasasqanta qawaq hamuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Hinaspan Jesuspa kasqan lugarman chayaramuranku. Chaypin chay demoniokunapa ñak'arichisqan runataqa Jesuspa ladonpi tiyashaqta rikuranku, p'achasqata hinallataq allin yuyayninpiña. Saynata rikuspankun chay hamuq runakunaqa mancharikuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Hinaqtinmi khuchita michiq runakunaqa, chay hamuq runakunaman willaranku, demoniopa ñak'arichisqan runapa sanoyasqanmanta, hinallataq khuchikunapa wañusqanmantawan ima. ");
INSERT INTO qveNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Chaymi chay Gadara llaqtayoq runakunaqa Jesusta ruegakuyta qallariranku, chay llaqtankumanta huk law llaqtaman ripunanpaq. ");
INSERT INTO qveNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Hinaqtinmi Jesusqa boteman wichashaqtin, chay demoniokunapa ñak'arichisqanmanta sanoyaq runaqa, Jesusta ruegakuran khaynata: —Qanwanmi riyta munani, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesusñataqmi ichaqa chay runata niran: —Wasiykiman kutipuy, hinaspa familiaykikunaman willamuy, qanta khuyapayasuspayki imaynatas Dios sanoyachisusqaykimanta, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Hinaspanmi chay sanoyaq runaqa, Decápolis law llaqtakunaman riran. Hinaspan Jesuspa imayna sanoyachisqanmanta willakachakuran. Hinaqtinmi llapallan uyariq runakunaqa, chay runapa willakusqanwan anchata admirakuranku. Nota: Decápolis ninanqa chunka llaqtakuna ninanmi. ");
INSERT INTO qveNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesusqa Galilea sutiyoq hatun laguna qochapa waq law chimpanmanmi huk botepi riran. Chaypi kashaqtinmi Jesuspa muyuriqninman ashka runakuna huñunakamuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Hinaqtinmi Diosmanta yachachina sinagoga wasipi kamachiq Jairo sutiyoq runa, Jesusman hamuspa ñawpaqninpi qonqoriyukuran. ");
INSERT INTO qveNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Hinaspan Jesusta ruegakuran khaynata: —Ama hina kaychu, hakuchi wasiyman. Ususiymi wañuypa patallanpiña kashan. Qan rispayki makiykita payman churayuqtiykiqa, sanoyaspan payqa kawsanqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Chaymi Jairopa wasinman Jesús rishaqtin, ashka runakunapas paywan kushka ñit'i-ñit'illaña riranku. ");
INSERT INTO qveNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Hinaqtinmi runakunapa chawpinta huk warmipas risharan. Paymi chunka ishkayniyoq wataña nishuta ñak'ariran yawar apariy onqoywan. ");
INSERT INTO qveNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Chaymi payqa ashka medicokunaman hampichikunanpaq riran. Hinaspan llapallan qolqechantapas ña tukuranña. Ichaqa manataqmi ni mayqen medicopas sanoyachiytaqa atiranchu. Aswanmi payqa sapa p'unchaw aswan más graveraq karan. ");
INSERT INTO qveNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Chaymi chay warmiqa Jesusmanta rimasqankuta uyariran. Hinaspan llapallan runakunapa chawpinta rispa, Jesusman qepallanta ashuyuspa, p'achanpa patallanta tupayuran, ");
INSERT INTO qveNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","sonqollanpi khaynata piensaspa: “Sichus p'achallantapas tupayusaq chayqa, sanoyasaqmi”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Hinaqtinmi chay warmiqa Jesuspa p'achanta tupayuspa, chay yawar apariywan onqosqanmanta kasqan ratolla sanoyaran. Hinaspan cuentata qokuran sanoña kasqanmanta. ");
INSERT INTO qveNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Hinaqtinmi Jesusqa cuentata qokuran paymanta atiynin lloqsisqanta. Hinaspan muyuriqninpi llapallan runakunata qawarispa, tapuran khaynata: —¿Pitaq p'achaytari tupaykaramuwan? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Hinaqtinmi Jesuspa discipulonkunaqa niranku: —¿Manachu rikunki llapallan runakuna montonakamuspa ñit'imususqaykita? Chaychu qanri ninki: “¿Pitaq p'achaytari tupaykaramuwan nisparí?” nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ichaqa Jesusñataqmi muyuriqninpi runakunata qawaran, pis p'achanta tupaykamuran chayta reqsinanpaq. ");
INSERT INTO qveNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Hinaqtinmi chay warmiqa manchakuymanta khatatataspa, Jesuspa ñawpaqninman ashuykamuspa, chaypi qonqorikuran. Hinaspan cheqaqta willakuran, imaraykuchus Jesuspa p'achanta tupayusqanmanta. ");
INSERT INTO qveNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Chayta uyarispanmi Jesusqa chay warmita niran: —Wawalláy, noqapi creesqaykiraykun qanqa sanoña kashanki. Kunanqa hawkalla ripuy. Qanqa manañan sufrinkiñachu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesús manaraq rimayta tukurushaqtinmi, Jairopa wasinmanta runakuna hamuspa, khaynata niranku: —¡Ususiykiqa ñan wañurunña! Yachachikuqtaqa amaña wasiykimanqa pusayñachu, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ichaqa chay runakunapa willakusqanta uyarispanmi Jesusqa Jairota niran: —Ama llakikuychu. Creellay, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Saynata nispanmi, Jesusqa mana ni pi runatapas paywan kushka rinantaqa munaranchu. Aswanqa Pedrota, Jacobota, hinallataq Jacobopa wawqen Juanllatawanmi rinankutaqa munaran. ");
INSERT INTO qveNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Hinaspan Jairopa wasinman riranku. Chayman chayaruspankutaqmi Jesusqa rikuran, wañuq sipasmanta chaypi kaq runakuna nishuta llakikuspanku, anchallataña waqasqankuta. ");
INSERT INTO qveNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Hinaqtinmi Jesusqa Jairopa wasinman haykuspa, chay waqaq runakunata, khaynata niran: —¿Imanaqtintaq qankunari anchata waqashankichís? Sipasqa manan wañusqachu kashan. Aswanqa puñullashanmi, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Saynata Jesús niqtinmi, chaypi kaq runakunaqa burlakuspanku, Jesusta asipayaranku. Hinaqtinmi Jesusqa hawaman lloqsinankupaq chaypi kaq llapallan runakunata kamachiran. Hinaspan Jesusqa chay wañuq sipaspa tayta mamanpiwan, hinallataq kinsantin discipulonkunapiwan imalla, chay wañuq sipaspa cuartonmanqa haykuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Hinaspanmi Jesusqa chay wañusqa sipasta makinmanta hap'iyuspa, arameo rimaypi niran: —Talita cumi, nispa. Chay nisqanqa khayna ninanmi: “Sipas, qantan niyki, ¡sayariy!” nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Chaymi chay sipasqa wañusqa kasqanmanta chay ratolla sayarimuspa, puriyta qallariran. Hinaqtinmi chaypi kaq runakunaqa chay sipaspa purisqanta rikuspanku, anchata admirakuranku. Chay sipasqa chunka ishkayniyoq watayoqmi karan. ");
INSERT INTO qveNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Chaymi Jesusqa chaypi kaq runakunata kamachispa niran: —Qankunaqa aman pimanpas willankichishchu kaykuna rikusqaykichismantaqa, nispa. Chaymantan Jesusqa sipasman mikhunata qonankupaq kamachiran. ");
INSERT INTO qveNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jairopa wasinmanta lloqsispanmi, Jesusqa discipulonkunapiwan kushka Nazaret llaqtanman ripuran. ");
INSERT INTO qveNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Hinaqtinmi Jesusqa samana p'unchaw chayaramuqtin, Diosmanta yachachina sinagoga wasiman haykuspa, chaypi yachachiyta qallariran. Chaymi yachachisqankunata uyarispanku, runakunaqa admirakuranku. Hinaspan khaynata tapunakuranku: —Kay runari, ¿maypitaq kay yachasqankunatari yacharamun? ¿Maymantataq kay yachaykunatari orqoramun? ¿Imaynanpitaq kay milagrokunatapas ruwashanrí? ");
INSERT INTO qveNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Manachu kay runaqa Mariapa wawan carpintero? ¿Manachu wawqenkunapas noqanchiswan kushka kashanku: Jacobo, José, Judas, hinallataq Simonpas? Saynallataq, ¿manachu panankunapas kay llaqtapi tiyashankú? nispanku. Saynata rimaspankun chay runakunaqa Jesuspaq phiñakuranku. Hinaspan paytaqa manaña uyariytapas munarankuñachu. ");
INSERT INTO qveNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Chaymi Jesusqa paykunata niran: —Diosmanta willakuq profetaqa huk law llaqtakunapin ancha allin respetasqa. Ichaqa llaqtanpi, familianpi, hinallataq wasinpi kaqkunallan mana respetankuchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Chayraykun Jesusqa chaypi ishkay kinsa onqosqa runakunallata makinwan llamiykuspa sanoyachiran. Ichaqa huk milagrokunataqa manan ruwaranñachu. ");
INSERT INTO qveNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Chaymi Jesusqa, llaqtamasinkuna paypi mana creeqtinku, anchata admirakuran. Chaymantan Jesusqa huk llaqtakunaman riran, Diosmanta allin willakuykunata yachachistin. ");
INSERT INTO qveNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesusqa chunka ishkayniyoq apostolninkunatan waqyaran. Hinaspan ishka-ishkayta kamachispa comisionaran, Diosmanta allin willakuykunata runakunaman willakuq rinankupaq. Hinallataq atiytapas qoran runakunamanta demoniokunata qarqonankupaq ima. ");
INSERT INTO qveNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Hinaspan Jesusqa chay apostolninkunata kamachispa, khaynata niran: —Rispaykichisqa bastonllaykichistan apankichis. Ichaqa aman apankichishchu qoqawtapas, t'antatapas, qolqetapas, ");
INSERT INTO qveNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","nitaq ishkay p'achatapas cambiakunaykichispaqqa. Aswanqa churakusqaykichis husut'allaykichistan apankichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Hinallataqmi Jesusqa chay apostolninkunataqa nillarantaq: —Huk llaqtaman chayaspaykichisqa, huk wasillapin samapakunkichis, chay llaqtamanta ripunaykichiskama. ");
INSERT INTO qveNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Sichus mayqen llaqtapipas mana chashkisunkichishchu, nitaq rimasqaykichistapas mana uyariyta munanqakuchu chayqa, husut'aykichispi allpatapas thaptirikuspayá chay llaqtamanta lloqsiychis. Saynapin paykunaqa mana allin runakuna kasqankuta yachakunqaku. {Cheqaqtapunin niykichis, chay llaqtakunaqa, juicio p'unchaw chayamuqtinmi, Sodoma llaqtamantapas, hinallataq Gomorra llaqtamantapas aswan mastaraq castigasqa kanqaku}, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jesuspa nisqanman hinan apostolninkunaqa riranku. Hinaspan q'aqchaspa hinaraq runakunaman willaranku khaynata: —Huchaykichismanta wanakuspa Diosman kutirikuychis, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Chaymi apostolkunaqa runakunamanta demoniokunata qarqoranku. Hinaspan onqosqakunatapas aceitewan llusispa, sanoyachimuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","(Chay tiempopin rey Herodes Antipas sutiyoq runaqa gobiernasharan Galilea provincia law llaqtakunapi). Hinaspan Herodes Antipasqa uyariran Jesusmanta runakunapa tukuy ima rimasqankuta. Wakin runakunan Jesusmanta khaynata rimaranku: —Bautizaq Juanmi wañusqanmanta kawsariramuspa, ancha atiywan milagrokunata ruwashan, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Wakin runakunañataqmi niranku: —Diosmanta willakuq ñawpaq profeta Eliasmi payqa, nispanku. Wakin kaq runakunañataqmi niranku: —Ñawpaq tiempopi huk kaqnin profetapashchá kawsariramun, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Chaymi rey Herodes Antipasqa chay nisqankuta uyariruspa niran: —Chay runaqa Juanmi. Paytaqa noqa kikiypunin kunkanta kuchuchirani. Paymi kawsariramun, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Chay Herodes Antipasmi, Bautizaq Juantaqa ñawpaq tiempopiraq hap'ichimuspa, cadenawan cadenaspa, carcelman churachiran. Chaytaqa warmin Herodías niqtinmi ruwaran. Chay Herodías warmiqa Herodes Antipaspa wawqen Felipepa warminmi karan. Chay Herodías warmiwanmi Herodes Antipasqa wawqen Felipemanta qechuspa casarakuran. ");
INSERT INTO qveNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Chaymi Bautizaq Juanqa Herodes Antipastaqa q'aqchaspa niran: —Moisespa escribisqan leyman hinaqa, manan wawqeyki Felipepa warmin Herodiaswanqa casarakuwaqchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Chayraykun Herodías warmiqa Bautizaq Juanta cheqnikuspa, wañuchiyta munaran. Ichaqa manataqmi imaynanmantapas wañuchiytaqa atiranchu, ");
INSERT INTO qveNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Bautizaq Juanta rey Herodes Antipasqa anchata respetasqanrayku. Saynataqa respetaran, Bautizaq Juanqa justo runa kaspa, Diosllapaqña kawsasqanta yachaspanmi. Chaymi Herodes Antipasqa Bautizaq Juanta protegeran, Herodias ama wañuchinanpaq. Ichaqa Juanpa willakusqankunata mana creeshaspapas, Herodes Antipasqa ganaswanmi uyariran. ");
INSERT INTO qveNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Hinaqtinmi Herodes Antipasqa cumpleañon chayamuqtin, huk hatun fiestata ruwaran. Chaymanmi invitamuran llaqtapi kamachiq runakunata, jefekunata, hinallataq Galilea provincia lawpi kamachiq allin reqsisqa runakunatawan ima. Chay fiesta p'unchawmi huk oportunidad karan, Herodías warmi, Bautizaq Juanta wañuchinanpaq. ");
INSERT INTO qveNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Hinaqtinmi chay hatun fiestapi mikhushaqtinku, Herodiaspa ususinqa chay fiestaman haykuspa, llapallan runakunapa ñawpaqninpi sumaqllataña tusuran. Chay tususqanmi rey Herodes Antipasman, hinallataq chaypi kaq runakunamanwan anchata gustaran. Chaymi rey Herodes Antipasqa Herodiaspa ususinta niran: —Imatapas mañakuway; noqaqa qanpa munasqaykitan qosqayki, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Hinallataqmi juramentota ruwaspa, Herodes Antipasqa nillarantaq: —Noqaqa tukuy ima mañakuwasqaykitapas, hinallataq sichus gobiernasqay llaqtakunapa kushkanta mañakuwaqtiykipas qosqaykin, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Chaymi chay sipasqa chay lugarmanta lloqsispa, mamitanta tapuran: —¡Mamitáy! ¿Imatataq mañakuymanrí? nispa. Hinaqtinmi mamitan Herodiasqa ususinta niran: —Bautizaq Juanpa umanta mañakamuy, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Chaymi Herodiaspa ususinqa, apurayllamanña rey Herodes Antipaspa kasqanman kutiyuspa niran: —Kunachallanmi Bautizaq Juanpa umanta huk platopi qowanaykita munani, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Saynata chay sipas niqtinmi, rey Herodes Antipasqa anchata llakikuran. Ichaqa llapallan invitadon runakunapa ladonpi juramentota ruwasqanraykun, manaña “manan” niytaqa atiranñachu. ");
INSERT INTO qveNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Chaymi rey Herodes Antipasqa huk soldadota kamachiran, carcelman rispa, Bautizaq Juanpa kunkanta kuchumuspa, umanta apamunanpaq. Hinaqtinmi chay soldadoqa carcelman rispa, Bautizaq Juanpa kunkanta kuchuspa, ");
INSERT INTO qveNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","umanta huk platopi chay sipasman apamuran. Hinaqtinmi chay sipasñataq mamitanman qoran. ");
INSERT INTO qveNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Chaymantañataqmi Bautizaq Juanpa discipulonkunaqa, Juanta wañuchisqankuta yacharuspanku hamuranku. Hinaspan Bautizaq Juanpa cuerponta apaspa, p'ampamuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesuspa apostolninkunan ishka-ishkay risqankumanta kutimuspanku, Jesuswan huñunakuranku. Hinaspan tukuy ima ruwamusqankumanta, hinallataq yachachimusqankumantawan ima Jesusman willaranku. ");
INSERT INTO qveNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Hinaqtinmi Jesuspa kasqanman ashka runakuna sapa raton hamuranku. Chaymi Jesuspa hinallataq discipulonkunapapas manaña tiemponkuqa ni mikhunankupaqpas karanñachu. Chaymi Jesusqa discipulonkunata niran: —Hakuchi runakunapa mana kasqan lugarman, chaypi huk ratollapas hawka samarimunanchispaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Hinaspan Jesusqa apostolninkunapiwan kushka, runakunapa mana kasqan lugarman huk botepi riranku. ");
INSERT INTO qveNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Hinaqtinmi runakunaqa yacharuranku maymansi Jesusqa apostolninkunapiwan risqankuta. Chaymi muyuriqninpi llaqtakunamanta ashkallaña runakunaqa chakipi apurayllamanña riranku. Hinaspan paykunaqa Jesusmantapas primertaraq chayaruranku. ");
INSERT INTO qveNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Hinaqtinmi Jesusqa chay risqanku botemanta urayamuspa, chaypi ashkallaña huñunasqa runakunata rikuran. Hinaspan anchata khuyapayaran, mana michiqniyoq ovejakuna hina kasqankurayku. Chaymi tukuy imakunamanta paykunamanqa yachachiyta qallariran. ");
INSERT INTO qveNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nishu tardeña kaqtintaqmi, discipulonkunaqa Jesusman ashuyuspa, khaynata niranku: —Nishu tardeñan kashan. Hinaspapas kay lugarqa runapa mana tiyananmi. ");
INSERT INTO qveNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Aswanyá kay llapallan runakunataqa despedipuy, saynapi kay enteron muyuriqninchispi llaqtakunaman rispanku, mikhunata chay llaqtakunapi mashkaspa rantikamunankupaq. Kaypiqa manan mikhunankupaqqa ni imapas kanchu, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Chaymi Jesusqa contestaran: —Qankunayá mikhunata qomuychis, nispa. Hinaqtinmi discipulonkunaqa contestaspa niranku: —Kaypi llapallan runakuna mikhunankupaqqa, rantimunaykuchá kanman t'antata. Chaypaqqa yaqa huk wata jornalpa chanin qolqen necesitakunman, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Chaymi Jesusqa paykunata tapuran: —Qankunapari, ¿hayk'a t'antaykichistaq kashan? Rispayá qawamuychis, nispa. Chaymi discipulonkunaqa riranku. Hinaspan kutimuspa Jesusta niranku: —Noqaykupaqa pishqa t'antawan, ishkay kankasqa challwallapiwanmi kashan, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Hinaqtinmi Jesusqa discipulonkunata kamachiran, llapallan runakunata pasto pampapi grupo-grupopi tiyachimunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Chaymi discipulonkunaqa, pachaqninpi hinallataq pishqa chunka grupo-grupopi tiyanankupaq, llapallan runakunata kamachiranku. ");
INSERT INTO qveNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Hinaqtinmi Jesusqa chay pishqantin t'antata, hinallataq ishkaynin kankasqa challwatawan hap'iyuspa, hanaq pachata qawarispa, Diosman graciasta qoran. Graciasta qoruspantaqmi Jesusqa t'antata partiyuspa, discipulonkunaman qoran, runakunaman rakimunankupaq. Saynallatataqmi ishkaynin kankasqa challwakunawanpas ruwaran. ");
INSERT INTO qveNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Chaymi llapallan runakunaqa saqsanankukama mikhuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Hinaspan discipulonkunaqa puchuq t'antakunatapas, hinallataq kankasqa puchuq challwakunatapas, chunka ishkayniyoq canasta hunt'ataraq huñumuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Chaypi mikhuq qarikunaqa pishqa waranqan karanku. Nota: Chay tiempopiqa yuparanku qarikunallatan. Ichaqa warmikunatawan, hinallataq wawakunatawanqa manan yuparankuchu. ");
INSERT INTO qveNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Chaymantan Jesusqa discipulonkunata kamachiran, boteman wichaspanku, laguna qochapa waq law chimpanpi Betsaida llaqtaman ñawpashanankupaq. Jesusñataqmi chaypi qeparukuspa, runakunata despediran. ");
INSERT INTO qveNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Hinaspan Jesusqa, runakunata despediruspa, Diosmanta mañakunanpaq moqo pataman riran. ");
INSERT INTO qveNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tutayaramushaqtinñan discipulonkunaqa chay laguna qochapa chawpintaña botepi risharanku. Jesusñataqmi ichaqa, orakusqan sitiollapiraq sapallan kasharan. ");
INSERT INTO qveNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Hinaqtinmi Jesuspa discipulonkuna laguna qochapa chawpintaña rishaqtinku, risqanku lawmanta contrankupi wayra wayramuqtin, ñak'ayllataña paletawan unuta qachiranku. Ichaqa manataqmi chay risqanku boteqa avanzayta atiranchu. Chayta rikuspanmi yaqaña achiqamushaqtin, Jesusqa unuq hawanta purispa paykunapa kasqanman riran. Paykunaman ashuyuspantaqmi pasarpatamuq tukuran. ");
INSERT INTO qveNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Chaymi discipulonkunaqa unu hawanta puriqta rikuspanku, anchata mancharikuspa, qapariranku khaynata: —¡Fantasman kayqa! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Llapallanku chayta rikuspankun, anchata mancharikuranku. Ichaqa Jesusñataqmi paykunata niran: —¡Noqan kani! ¡Ama mancharikuychishchu! Aswan kallpanchakuychis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Saynata nispanmi Jesusqa boteman wicharan. Hinaqtinmi kasqan ratolla chay wayraqa thañiran. Chaymi discipulonkunaqa chayta rikuspanku, ancha admirasqallaña karanku. ");
INSERT INTO qveNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Hinaspapas paykunaqa sonqonku rumiyasqa kasqanraykun, mana entienderankuchu chaykunamanta, hinallataq ñawpaqtaraq pishqa waranqa runakuna t'antata mikhunankupaq milagrota Jesús ruwasqanmantapas. ");
INSERT INTO qveNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jesusqa discipulonkunapiwanmi laguna qochata chimpaspa, Genesaret allpaman chayaranku. Hinaspan risqanku boteta laguna qochapa patanpi wataranku. ");
INSERT INTO qveNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Hinaqtinmi chay botemanta urayamushaqtinku, chay lugarpi tiyaq runakunaqa Jesusta reqsiruranku. ");
INSERT INTO qveNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Hinaspan willakachakamuranku muyuriqninkupi kaq llapallan llaqtakunapi. Hinaqtinmi onqosqa runakunata kallapikunapi apamuranku, Jesuspa kasqan lugarman. ");
INSERT INTO qveNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Saynallataqmi Jesusqa chayaran hatun llaqtakunaman, uchuy llaqtachakunaman, hinallataq campokunamanpas. Chay lugarkuna chayasqanmanmi onqosqa runakunata apamuranku. Hinaspan chay onqosqa runakunataqa churaranku plazakunapi, callekunapi, hinallataq ñankunapipas. Hinaspan Jesusta ruegakuranku, p'achanpa patallantapas llamiykunankupaq. Chaymi llapallan onqosqa runakunaqa, Jesuspa p'achanta llamiyuspanku, chay onqoyninkumanta sanoyapuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Jerusalén llaqtamantan hamuranku fariseo religionniyoq runakuna, hinallataq leykunata yachachiq runakunapiwan ima. Paykunan Jesuspa muyuriqninpi huñunakuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Hinaspan paykunaqa Jesuspa wakin discipulonkunata rikuranku, makinkuta mana maqllikuspa, mikhusqankuta. Chaymi paykunaqa Jesuspa discipulonkunapa contranpi rimaranku. ");
INSERT INTO qveNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Saynataqa rimaranku, chay fariseo religionniyoq runakunapas, hinallataq Israel nacionniyoq runakunapas, ñawpaq abuelonkupa costumbrenkuman hinan, imatapas mikhunankupaqqa makinkuta ashka kutikama maqchikusqankuraykun. Makinkuta mana maqchikuspankuqa manan paykunaqa ni imatapas mikhurankuchu. ");
INSERT INTO qveNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Saynallataqmi paykunaqa mercadomanta kutimuspankupas, mana mikhurankuchu ni imatapas, makinkuta manaraq maqllikuspankuqa. Hinaspapas paykunaqa costumbrenkuman hinan vasokunatapas, jarrokunatapas, hinallataq fierromanta ruwasqa cosaskunatapas maqlliranku. {Saynallataq puñunanku camakunatapas t'aqsaranku}. Nota: Kay makinku maqchikuy costumbretaqa, manan makinku limpio kananpaqchu ruwarankuqa. Aswanqa costumbrenkuman hina allin rikusqa kanallankupaqmi ruwarankuqa. ");
INSERT INTO qveNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Chayraykun fariseo religionniyoq runakuna, hinallataq leykunata yachachiq runakunapas, Jesusta tapuranku khaynata: —¿Imanaqtintaq discipuloykikunari ñawpaq abuelonchiskunapa yachachikusqankunatari mana kasukunkuchú? ¿Saynallataq makinkutapas mikhunankupaqqa mana maqllikunkuchú? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Chaymi Jesusqa contestaspa niran: —¡Ishkay uya runakuna! Allintan Diosmanta willakuq profeta Isaiasqa ñawpaqtaraq qankunamanta escribiran, Diospa khayna nisqanta: “Kay runakunaqa simillanwanmi yupaychawanku. Ichaqa sonqonkutaqmi noqamanta karupi kashan. ");
INSERT INTO qveNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Paykunaqa yanqapaqmi adorawanku. Hinaspapas runakunapa kamachikusqanman hinallan yachachinkupas. Sayna yachachisqankutan paykunaqa ninku: ‘Diosmi khaynata nimuwanchis’ ”, nispanku Isaías 29.13. ");
INSERT INTO qveNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Chaymi niykichis, qankunaqa Diospa kamachisqankunata mana kasukuspan, runakunapa costumbrenkuman hinalla imatapas ruwashankichis. {Chaymi qankunaqa jarratapas, vasotapas hinallataq huk cosaskunatapas hawallanta maqllinkichis}, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jesusqa paykunatan nillarantaq: —Qankunaqa costumbreykichisman hinalla imatapas ruwaspaykichismi, Diospa kamachisqankunataqa mana kasukunkichishchu. ");
INSERT INTO qveNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Chayraykun Moisespas yachachispa khaynata niran: “Papaykichista hinallataq mamitaykichista respetaspa kasukuychis. Ichaqa pipas papanta otaq mamitantapas maldecinqa chayqa, wañunanpaqmi sentenciasqa kanqa”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ichaqa qankunataqmi yachachinkichis runakunapa wawankunaman, papankutapas hinallataq mamitankutapas, khaynata ninankupaq: “Tayta mamalláy, manan qanta yanapaytaqa atiymanchu; chay yanapanay llapallan kaqniykunataqa Diosman qonaypaqmi ña separaniña”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Saynata yachachiqtiykichismi, paykunaqa papankuta hinallataq mamitankutapas manaña yanapaytaqa munankuñachu. ");
INSERT INTO qveNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Saynapin qankunaqa ñawpaq costumbreykichiskunata runakuna cumplinanta munaspaykichis, Diospa kamachikusqankunatapas mana imapaq valeqman tukurachinkichis. Saynallatataqmi wakin costumbreykichiskunatapas runakunaman yachachishankichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Chayta nispanmi Jesusqa llapallan runakunata waqyarispa, khaynata niran: —Llapallaykichisyá allinta uyarispa, kaykunata entiendeychis: ");
INSERT INTO qveNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Runataqa manan mikhuna mikhusqanchu huchallichin. Aswanqa mana allinta piensaspa imatapas rimasqanmi, runataqa huchallichin. ");
INSERT INTO qveNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","{¡Sichus cheqaqtapuni ninriyoq kankichis chayqa, allintayá uyariychis kay nisqaykunata!} nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesusqa chay lugarpi runakunata saqespanmi, huk wasiman haykuran. Hinaqtinmi discipulonkunaqa Jesusta tapuranku chay willakuykuna willasqanmanta. ");
INSERT INTO qveNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Hinaqtinmi Jesusqa paykunata contestaran: —Qankunapas, ¿manachu kay willakusqaykunata entienderankichís? ¿Manachu yachankichis runapa mikhuna mikhusqanqa, runata mana huchallichisqanta? ");
INSERT INTO qveNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Runapa mikhuna mikhusqanqa, manan sonqonmanchu haykun. Aswanqa wiksallanmanmi haykun. Hinaspan letrinallamanña lloqsin, nispa. Saynata nispanmi Jesusqa yachachiran, tukuy ima mikhunapaq kaqpas, allinpuni mikhunapaq kasqanta. ");
INSERT INTO qveNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Hinaspan Jesusqa nillarantaq: —Runataqa huchallichin mana allin rimasqankuna, hinallataq mana allin ruwasqankunan. ");
INSERT INTO qveNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Chaykunan runapa sonqonmanta lloqsimun. Chaykunaqa kaykunan: mana allin piensaykuna, mana allin ruwaykuna, waqllikuykuna, manaraq casado kashaspa qariwan otaq warmiwan puñuykuna, runa masin wañuchiykuna, suwakuykuna, ");
INSERT INTO qveNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","payllapaq qolqetapas otaq tukuy imatapas munapakuykuna, envidiakuykuna, maldeciykuna, k'amiykuna, Diosta mana manchakuykuna, hinallataq paytukuykuna ima. ");
INSERT INTO qveNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kay llapallan millay ruwaykunan runapa sonqonmanta lloqsimuspa, runataqa huchallichin, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesusqa chay (Genesaret) lugarmanta lloqsispanmi, Tiro llaqta lawman riran, {hinallataq Sidón llaqta lawmanwan ima}. Chay lawpi kashaspanmi Jesusqa huk wasiman haykuran. Hinaspan payqa mana munaranchu chay wasipi kasqanta runakuna yachanankutaqa. Ichaqa manataqmi pakakuytaqa atiranchu. ");
INSERT INTO qveNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Chay wasipi Jesús kasqanta yacharuspanmi, Jesuspa kasqanman huk warmi hamuran. Payqa hamuran ususinta huk demonio nishuta ñak'arichisqanraykun. Chayraykun Jesuspa ñawpaqninpi qonqoriyukuspa payta ruegakuran. ");
INSERT INTO qveNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Chay warmiqa manan Israel nacionniyoqchu karan. Payqa Fenicia llaqtamantan karan. Chay llaqtaqa Siria provinciamanmi perteneceran. Paymi Jesusta ruegakuran ususinmanta demoniota qarqonanpaq. ");
INSERT INTO qveNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Chaymi Jesusqa niran: —Primertaqa wawakunan saqsananku. Manan allinchu kanman wawakunapa t'antanta qechuruspa, alqokunaman wikch'uyuyqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Hinaqtinmi chay warmiqa niran: —Arí Señor, saynapunin chayqa. Ichaqa alqokunapas mikhunmi, wawakunapa mikhusqan mesamanta pampaman parte-parten urmaq t'antachakunatapas, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Chaymi Jesusqa niran: —¡Allinpunin nisqaykiqa! Kunanqa ripuy. Ñan demonioqa ususiykimanta lloqsirunña, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Hinaqtinmi chay warmiqa wasinman ripuspa, ususinta camapi hawkallata tariran, ñak'arichiqnin demonio paymanta lloqsisqanrayku. Nota: Mesapi mikhuq wawakunaqa Israel nacionniyoq runakunan kanku. Alqokunawantaqmi Jesusqa rikch'anachiran huk law nacionniyoq runakunata. Ichaqa Sirofenicia warmiqa, huk law nacionniyoq kashaspanmi Jesuspi creeran. Chaymi Jesusqa paypa ususinta sanoyachiran. ");
INSERT INTO qveNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesusqa Tiro llaqtamanta lloqsimuspan, Sidón llaqtanta, hinallataq Decápolis provincia lawninta kutimuran. Hinaspan Galilea laguna qochapa patankama chayamuran. ");
INSERT INTO qveNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Hinaqtinmi chayman apamuranku mana rimay atiq upayasqa runata. Hinaspan Jesusta ruegakuranku makinta chay mana rimay atiq upayasqa runaman churayuspa sanoyachinanpaq. ");
INSERT INTO qveNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Hinaqtinmi Jesusqa chay runata sapallanta huk lawchaman pusarispa, ishkaynin ninri t'oqonta dedonkunawan tupayuran. Saynallataqmi toqayninwanpas qallunta tupayullarantaq. ");
INSERT INTO qveNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Hinaspan cielota qawarispa, Jesusqa sonqollanpi anchata llakirikuspa niran: —¡Efata! nispa. Chayqa “kicharikuy” ninantan nin. ");
INSERT INTO qveNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Hinaqtinmi kasqan ratolla chay runapa ninrinkunaqa kicharikuran. Hinallataq qallunpas pashkarikuqtin rimayta atiran. ");
INSERT INTO qveNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Hinaspan Jesusqa chaypi kaq runakunata kamachiran khaynata: —Aman pimanpas willankichishchu kaykuna rikusqaykichistaqa, nispa. Ichaqa saynata Jesús kamachishaqtinpas, paykunaqa aswantaraqmi willakachakuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Chaymi runakunaqa anchata admirakuspa, khaynata niranku: —Jesusqa tukuy imatapas allintan ruwan. Payqa upa runakunatapas uyarichinmi. Hinallataqmi mana rimaq runakunatapas rimarichin, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Huk p'unchawmi Jesuspa kasqanman yapamanta ashkallaña runakuna huñunakamuranku. Hinaqtinmi chay llapallan runakunapa mikhunanpaq mana ni imapas kaqtin, Jesusqa discipulonkunata waqyaspa, khaynata niran: ");
INSERT INTO qveNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Noqaqa llapallantan kay runakunataqa anchata khuyapayani. Paykunaqa ñan kinsa p'unchawña noqawan kushka kashanku. Ichaqa manataqmi ni imapas mikhunankupaqqa kanchu. ");
INSERT INTO qveNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Sichus mana mikhusqallata wasinkuman kutipunankupaq kamachiyman chayqa, ñan risqankupichá desmayankuman. Hinaspapas wakin runakunaqa karumantaraqmi hamuranku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Hinaqtinmi discipulonkunaqa niranku: —Kay ch'inñeq lugarpiri, ¿maymantataq pipas t'antatari apamunman, kay llapallan runakuna mikhunanpaqrí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Hinaqtinmi Jesusqa discipulonkunata tapuran: —Qankunapari, ¿hayk'a t'antaykichistaq kashan? nispa. Chaymi discipulonkunaqa contestaranku: —Noqaykupaqa qanchis t'antallaykun kashan, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Hinaqtinmi Jesusqa llapallan chaypi kaq runakunata kamachiran, pampapi tiyanankupaq. Hinaspan chay qanchisnintin t'antata hap'iyuspa, Diosman graciasta qoran. Graciasta qoruspantaqmi, t'antata partiyuspa, discipulonkunaman qoran; hinaqtinmi paykunaqa runakunaman rakimuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Saynallataqmi Jesuspa discipulonkunapaqa ishkay kinsa kankasqa taksa challwachakunapas kallarantaq. Chaymi Jesusqa Diosman graciasta qospa, discipulonkunata kamachiran runakunaman rakimunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Chaypin llapallan runakunaqa asta saqsanankukama mikhuranku. Hinaspan puchuqkunatapas qanchis canasta hunt'ataraq huñumuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Chaypi mikhuq qarikunaqa tawa waranqa hinan karanku. Mikhuyta tukuruqtinkutaqmi, Jesusqa paykunata wasinkuman ripunankupaq despediran. ");
INSERT INTO qveNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Chaymantan Jesusqa discipulonkunapiwan kushka huk boteman wichaspanku, Dalmanuta sutiyoq lugarman riranku. ");
INSERT INTO qveNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Jesuspa kasqanmanmi fariseo religionniyoq runakuna hamuspanku, Jesuswan discutiyta qallariranku. Jesusta pruebaman churayta munaspankutaqmi, khaynata niranku: —Cheqaqtapuni Diosmanta Hamuq Runa kaspaykiqa, huk milagrota ruwaspayá rikuchiwayku, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Hinaqtinmi Jesusqa sonqon ukhullapi anchata llakirikuspa, llapallankuta khaynata niran: —Qankunari, ¿imanaqtintaq huk milagrota ruwanaytaraq munashankichís? Cheqaqtapunin nisqaykichis, qankuna rikunaykichispaqqa, manan ni ima milagrotapas ruwasaqchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Saynata nispanmi Jesusqa runakunata chaypi saqespa, boteman yapamanta wicharan. Hinaspan Galilea laguna qochapa waq law chimpanman riran. ");
INSERT INTO qveNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jesuspa discipulonkunan Galilea laguna qochapa waq law chimpanman botepi rishaspanku, mikhunankupaq t'anta apakuyta qonqarusqaku. Ichaqa huk t'antallan chay risqanku botepiqa karan. ");
INSERT INTO qveNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Hinaqtinmi Jesusqa discipulonkunata niran: —Allinta cuidakuychis fariseo religionniyoq runakunapa, hinallataq rey Herodes Antipas sutiyoq runapa levaduranmantaqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Chaymi Jesuspa discipulonkunaqa khaynata ninakuranku: —T'antata mana apakamuqtinchismi saynataqa niwashanchis, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesusñataqmi sayna rimanakusqankumanta cuentata qokuspa, discipulonkunata khaynata niran: —¿Imanaqtintaq t'antata mana apakamusqaykichismantari rimashankichís? ¿Manachu entiendenkichisraq imatachus niyta munani chayta? ¿Qankunapa sonqoykichisri rumiyasqallaraqchu kashan? ");
INSERT INTO qveNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Qankunaqa ñawiyoq kashaspapas, ¿manachu rikunkichís? Ninriyoq kashaspapas, ¿manachu uyarinkichís? Qankunari, ¿manachu yuyankichishña ");
INSERT INTO qveNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","chay pishqa t'antata partispa, pishqa waranqa runakunaman mikhuchisqaytapas? Hinaspapas, ¿manachu yuyankichishña hayk'a canastataraq puchuq t'antakunatapas huñumusqaykichista? nispa. Chaymi discipulonkunaqa contestaranku: —Chunka ishkayniyoq canasta hunt'ataraqmi huñumurayku, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Hinaqtinmi Jesusqa discipulonkunata tapullarantaq: —Qanchis t'antallamanta tawa waranqa runakunaman mikhuchisqaymantari, ¿hayk'a canasta hunt'ataraqtaq puchuqnintari huñumurankichís? nispa. Chaymi discipulonkunañataq contestaranku: —Qanchis canasta hunt'ataraqmi huñumurayku, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Chaymi Jesusqa discipulonkunata niran: —¿Chaychu qankunapas kay yachachisqaykunata manaraq entiendenkichís? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Betsaida llaqtaman Jesús chayaramuqtinmi, huk ñawsa runata Jesuspa kasqanman pusamuranku. Hinaspan Jesusta ruegakuranku makinta payman churayunanpaq. ");
INSERT INTO qveNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Chaymi Jesusqa chay ñawsa runata makinmanta aysaspa, chay llaqtapa waq lawninman pusaran. Hinaspan toqayninwan ñawinkunata llusiyuspa, hinallataq makinta umanman churayuspa, khaynata tapuran: —¿Imallatapas rikushankichú? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Chaymi chay ñawsa runaqa niran: —Arí, runakunatan rikushani sach'akunata hina. Ichaqa paykunaqa purishankun, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Hinaqtinmi Jesusqa yapamanta chay ñawsa runapa ñawinkunata tupayuran. Chaymi chay ñawsa runaqa kasqan ratolla sanoyaspa, tukuy imatapas allinta rikuran. ");
INSERT INTO qveNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Hinaqtinmi Jesusqa chay runata kamachiran wasinman ripunanpaq. Hinaspan avisaran khaynata: —Ripuspaykiqa aman llaqtamanqa kutinkiñachu, nitaqmi ni pimanpas ni imatapas willakunkichu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesusqa discipulonkunapiwan kushkan, Filipo sutiyoq kaq Cesarea llaqtapa muyuriqninpi llaqtachakunaman riranku. Hinaspan chay ñan risqankupi, Jesusqa discipulonkunata, khaynata tapuran: —¿Pitaq noqari kani runakunapaqrí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Chaymi discipulonkunaqa Jesusta contestaranku: —Wakinmi ninku: “Bautizaq Juanmi payqa”, nispanku. Wakinñataqmi ninku: “Diosmanta willakuq ñawpaq profeta Eliasmi”, nispanku. Hukkunañataqmi ninku: “Payqa mayqen profetapashchá”, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Chaymi Jesusqa paykunata niran: —Qankunari, ¿ima ninkichistaq noqamanta? Qankunapaqri, ¿pitaq noqari kaní? nispa. Hinaqtinmi Pedroqa contestaspa niran: —Qanqa Diosmanta Hamuq Salvadorniyku Criston kanki, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Chaymi Jesusqa paykunata kamachiran khaynata: —Aman pimanpas qankunaqa willankichishchu noqa Diosmanta Hamuq Salvador Cristo kasqaytaqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesusqa chaymantapachan payta imakunas pasananmanta discipulonkunaman willakuyta qallariran khaynata: —Kay Israel nación llaqtapi kamachiq jefekunan, sacerdotekunapa jefenkunapiwan, hinallataq leykunata yachachiq runakunapiwan ima, noqa Diosmanta Hamuq Runataqa cheqniwaspanku, anchata ñak'arichiwaspa wañuchiwanqaku. Saynata wañuchiwaqtinkupas, noqaqa kinsa p'unchawmantan kawsarinpusaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Chaykunamantan Jesusqa discipulonkunaman willaran imatapas mana pakaspalla allin clarota. Chaymi Pedroqa Jesusta huk lawman waqyarispa, sayna nisqanmanta Jesusta q'aqcharan. ");
INSERT INTO qveNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Hinaqtinmi Jesusqa llapallan discipulonkunaman kutirispa, Pedrota q'aqcharan khaynata: —¡Satanás, ayqeriy noqapa ñawpaqniymanta! Qanpa piensayniykiqa manan Diospa piensasqanman hinachu. Qanqa runakunapa piensasqanman hinallan piensashanki, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Chaymantan Jesusqa discipulonkunata, hinallataq chaypi kaq runakunatawan waqyaspa, khaynata niran: —Sichus pipas noqapa discipuloy kayta munaspaqa, qonqananmi kikinpa munasqanman hina imatapas ruwayta. Hinaspa tukuy ima sasachakuykuna chayamuqtinpas, noqapi iñisqanraykun, ñak'arinanpaq listo kanan. Saynallataqmi noqapa kamachisqaykunatapas ruwanan. ");
INSERT INTO qveNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Pipas kay pachapi payllapaq kawsay munaqqa, wiñaypaqmi wañunqa. Ichaqa pipas noqapi creesqanrayku wañuqmi, wiñaypaq kawsanqa. ");
INSERT INTO qveNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Imapaqtaq valenman kay pachapi tukuy ima kaqniyoq kayrí, hinaspa almanñataq mana salvasqa kaqtinrí? ");
INSERT INTO qveNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kay pachapi runakunari, ¿hayk'atataq pagankuman vidankuta salvanankupaqrí? ");
INSERT INTO qveNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ichaqa sichus pipas noqamanta hinallataq yachachisqaykunamantapas, huchasapa runakunapa ñawpaqninpi p'enqakunqa chayqa, noqa Diosmanta Hamuq Runapas, paykunamantaqa p'enqakullasaqtaqmi, Dios Taytaypa atiyninwan, hinallataq angelninkunapiwan ima kay pachaman kutimuspay, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesusqa nillarantaqmi: —Cheqaqtapunin niykichis, wakin kaypi noqawan kaqkunaqa manaraqmi wañunkichisraqchu, ancha atiywan Diospa gobiernasqan sumaq glorianta rikunaykichiskama, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Chaykuna rimasqanmanta soqta p'unchaw pasaruqtinmi, Jesusqa Pedrota, Jacobota hinallataq Juantawan pusayukuspa, huk orqoman riran. Chaypin discipulonkunapa ñawpaqninpi Jesuspa cuerponqa k'anchariran. ");
INSERT INTO qveNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Hinallataqmi p'achanpas rit'i hina sumaq yuraqllaña k'ancharishaqman tukuran. Sayna k'ancharishaq yuraq ch'illo p'achamanqa manan ni pipas tukuchinmanchu, ni imaynataña t'aqsaspapas. ");
INSERT INTO qveNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Hinaqtinmi Moiseswan, hinallataq Diosmanta ñawpaq yachachiq profeta Eliaspiwan ima, qonqayllamanta rikhuriranku Jesuswan parlaspanku. ");
INSERT INTO qveNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Chaymi Pedroqa Jesusta niran: —¡Yachachikuq, allinmi kaypi kasqanchisqa! Chayqa kaypiyá kunan kinsa ramadakunata ruwasaqku: hukta qanpaq, huktataq Moisespaq, huktañataq Eliaspaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pedroqa mana allinta piensarispan chaykunataqa rimaran, paypas hinallataq wakin discipulokunapas ancha mancharisqa kasqankurayku. ");
INSERT INTO qveNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Hinaqtinmi cielomanta huk phuyu urayamuspa, paykunata tapaykuran. Hinaspan chay phuyu ukhumanta khayna rimamuqta uyariranku: —Paymi ancha khuyakusqay Wawayqa. Payta uyarispa kasukuychis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Chaymantan qonqayllamanta muyuriqninkuta qawarikuspanku, manaña ni pitapas rikurankuñachu. Aswanqa Jesusllatañan sapallanta chaypi rikuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Hinaqtinmi chay orqomanta urayamushaqtinku, Jesusqa discipulonkunata kamachiran khaynata: —Chay rikusqaykichistaqa aman pimanpas willankichisraqchu, noqa Diosmanta Hamuq Runa wañusqaymanta kawsarimunaykama, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Chaymi paykunaqa chay rikusqankumantaqa mana ni pimanpas willarankuchu. Aswanmi chaykunataqa sonqonku ukhullapi waqaycharanku. Hinaspan paykunapuralla tapunakuranku khaynata: —¿Ima ninantataq nin: “Wañusqaymanta kawsarimunaykama”, nisparí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Chaymi discipulonkunaqa Jesusta tapuranku: —Leykunata yachachiq runakunari, ¿imanaqtintaq ninku: “Diosmanta Hamuq Runapa ñawpaqnintaqa hamunqa, Diosmanta yachachiq ñawpaq profeta Eliasraqmi”, nisparí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Hinaqtinmi Jesusqa paykunata contestaspa niran: —Arí, cheqaqtapunin Eliasqa ñawpaqta hamuspa, tukuy imatapas allichanqa. Ichaqa Bibliapipas escribisqan kashan: Noqa Diosmanta Hamuq Runataqa cheqniwaspankun ñak'arichiwanqaku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Aswanqa noqan niykichis: Eliasqa ñan hamuranña; ichaqa runakunan paytaqa ñak'arichispa munasqankuta ruwaranku, imaynan Eliasmanta escribisqa Bibliapi kashan hinata, nispa. Nota: Eliasmanta Jesús rimaspanqa, Bautizaq Juanmantan rimaran. ");
INSERT INTO qveNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jesusqa kinsantin discipulonkunapiwanmi wakin discipulonkunapa kasqanman chayamuranku. Hinaspan chay discipulonkunapa muyuriqninpi ashka runakunata rikuranku, hinallataq leykunata yachachiq runakunatapas Jesuspa discipulonkunawan discutinakushaqta. ");
INSERT INTO qveNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Hinaqtinmi chaypi kaq runakunaqa, Jesusta rikuruspanku, anchata admirakuspa, Jesusman ayparanku rimayukunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Chaymi Jesusqa discipulonkunata tapuran: —Qankunari, ¿imatataq paykunawan discutinakushankichís? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Hinaqtinmi huk runa chay ashka runakunapa chawpinmanta, khaynata nimuran: —Yachachikuq, kay wawaytan qanman pusamushayki. Paymi mana rimayta atinchu, demonio paypi kasqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Hinaspapas chay demonioqa wawaytan maypipas pampakunaman wikch'un. Chaymi payqa posoqotaraq aqtuspa, kirunkunatapas rach'ikyachin. Hinallataqmi sapa kutin chay ataki hap'iqtinqa, cuerponpas chutakachakun. Chaymi discipuloykikunata valekurani, chay demoniota qarqonankupaq. Ichaqa manan paykunaqa qarqoyta atirankuchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Chayta uyarispanmi Jesusqa niran: —Noqapi mana iñiyniyoq runakuna, ¿hayk'aqkamataq qankunawanri kasaq? ¿Hayk'aqkamataq qankunatari aguantasqaykichís? ¡Apamuychis chay joventa! nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Hinaqtinmi chay joventaqa Jesuspa kasqanman pusamuranku. Ichaqa Jesusta rikuruspa hinallan chay demonioqa, chay joventa shapchispa, pampaman wikaparan. Chaymi chay jovenqa pampapi qospaspa posoqotaraq aqturan. ");
INSERT INTO qveNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Hinaqtinmi Jesusqa chay jovenpa papanta tapuran: —¿Hayk'aqmantapachataq kay wawaykiri ñak'arishan khaynata? nispa. Chaymi chay jovenpa papanqa contestaran khaynata: —Warmacha kasqanmantapachan. ");
INSERT INTO qveNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Hinaspapas chay demonioqa wawayta wañuchiyta munaspan, ashka kutitaña nina ukhukunaman, hinallataq unukunamanpas wikch'uyun. Ichaqa sichus noqaykupaq imallatapas ruwayta munaspaykiqa, khuyapayaykuwaykuyá; hinaspa yanapaykuwayku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Chaymi Jesusñataq niran: —¿Diospi qan creenkichú? Sichus Diospi creenki chayqa, munasqaykiman hinayá ruwasqa kachun. Diospi cheqaqtapuni creeqpaqqa, manan ni imapas sasachu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Hinaqtinmi chay jovenpa papanqa altota qaparispa niran: —¡Arí, noqaqa creenipunin; yanapaykuway aswan mastaraq Diospi creenaypaq! nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Hinaqtinmi Jesuspa kasqanman runakuna astawanraq huñunakamuqtinku, Jesusqa chay demoniota q'aqchaspa niran: —Upayachispa mana rimachiq demonio, noqan kamachiyki, kay jovenmanta lloqsiy; hinaspa amaña paymanqa ni hayk'aqpas kutiyamunkiñachu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Chaymi chay demonioqa altota qaparispa, yapamanta chay joventa anchata shapchispa, lloqsiran. Hinaqtinmi chay jovenqa wañusqa hinaraq qeparan. Chaymi chaypi kaq runakunaqa chayta rikuspa niranku: —Wañusqan kashan, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ichaqa Jesusñataqmi chay joventa hap'iyuspa, makinmanta aysariran. Hinaqtinmi chay jovenqa sayariran. ");
INSERT INTO qveNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jesusqa huk wasiman haykuruqtinmi, kaqmanta discipulonkunaqa huk lawman waqyarispanku, sapallanpi khaynata tapuranku: —¿Imanaqtintaq chay demoniotari mana qarqoyta atiraykuchú? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Hinaqtinmi Jesusqa paykunata contestaspa niran: —Khayna clase demoniokunataqa, qarqoytaqa atinkuman orakuspallan, {hinallataq ayunowan ima}, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Chaymanta lloqsispankun Jesusqa discipulonkunapiwan kushka, Galilea provincia ukhunta pasasharanku. Ichaqa Jesusqa manan munaranchu, chaynin risqankuta runakuna yachanankutaqa. ");
INSERT INTO qveNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Hinaspan Jesusqa discipulonkunallata yachachispan, khaynata niran: —Noqa Diosmanta Hamuq Runataqa runakunamanmi wañuchiwanankupaq entregawanqaku. Ichaqa kinsa p'unchawmantan noqaqa kawsarinpusaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ichaqa Jesús saynata willakuqtinmi, discipulonkunaqa mana entiendeyta atirankuchu. Hinaspan paykunaqa yapa-yapamanta tapupayayta manchakuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jesusqa discipulonkunapiwan kushkan Capernaúm llaqtaman chayaruranku. Chaypin huk wasipiña kashaspanku, Jesusqa discipulonkunata khaynata tapuran: —Qankunari, ¿imamantataq ñan hamusqanchispiri discutinakamusharankichís? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ichaqa Jesuspa discipulonkunaqa manan ni ima nispapas contestarankuchu. Paykunaqa ñan hamusqankupin, mayqenninkus aswan más allin importante kanankumanta discutinakamuranku. (Chaymi p'enqakuspanku Jesustaqa mana contestayta munarankuchu). ");
INSERT INTO qveNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Hinaspan Jesusqa, chaypi tiyayuspa, chunka ishkayniyoq discipulonkunata waqyaspa niran: —Sichus pipas llapanmanta aswan más importante kayta munaspaqa, huk sirviente runa hinan primerta llapallan discipuloykunata servinan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jesusqa saynata niruspanmi, huk warmachata waqyaruspa, discipulonkunapa ñawpaqninpi sayaykachiran. Hinaspan chay warmachata marq'arikuspa, discipulonkunata khaynata niran: ");
INSERT INTO qveNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Pipas kay wawata sutiypi allinta chashkiqqa, noqatan chashkiwashan. Hinallataq pipas noqata chashkiwaqqa, hanaq pachamanta mandamuwaqniy Diostapas chashkishanmi, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jesuspa discipulon Juanmi khaynata niran: —Yachachikuq, huk runatan rikuramuyku qanpa sutiykipi runakunamanta demoniokunata qarqoshaqta. Chaymi noqanchis partemanta mana kasqanrayku, noqaykuqa prohibimuyku, qanpa sutiykipi chaykunata ama ruwananpaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ichaqa Jesusñataqmi discipulonkunata khaynata niran: —Pipas noqapa sutiypi milagrota ruwaspaqa, manan noqapa contraypiqa rimanmanchu. Saynaqa amayá hark'akunkichishchu noqapa sutiypi milagrokunata ruwanantaqa. ");
INSERT INTO qveNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Pipas mana contranchispi kaqqa, noqanchis partemantan kashan. ");
INSERT INTO qveNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Chaymi cheqaqtapuni niykichis, sichus pipas noqapi creesqaykichisrayku, huk tazapi unullatapas qankunaman qoykusunkichis chayqa, Diosmi chay runamanqa premiota qonqapuni, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jesusqa nillarantaqmi: —Noqapi chayllaraq creeqkunata pipas huchaman urmachiq runataqa, aswan allinmi kanman karan, manaraq huchaman pitapas urmachishaqtin, huk hatun molino rumita kunkanman wataruspa, lamar qochaman wikch'uykuy. ");
INSERT INTO qveNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Hinallataq sichus makiyki huchaman urmachisunki chayqa, aswanyá kuchurpaspa wikapay. Aswan allinmi kanman huknin makillayoq wiñay kawsayman haykunaykipaq, ishkaynin makintin wiñaypaq nina rawray infiernoman wikch'uyusqa kanaykimantaqa. ");
INSERT INTO qveNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","{Chay wiñaypaq nina rawray infiernopiqa, manan aycha urupas wañunchu, nitaqmi ni hayk'aqpas ninaqa wañunqachu}. ");
INSERT INTO qveNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Hinallataq sichus chakiyki huchaman urmachisunki chayqa, aswanyá kuchurpaspa wikapay. Aswan allinmi kanman huknin chakillayoq wiñay kawsayman haykunaykipaq, ishkaynin chakintin nina rawray infiernoman wikch'uyusqa kanaykimantaqa. ");
INSERT INTO qveNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","{Chay wiñaypaq nina rawray infiernopiqa, manan aycha urupas wañunchu, nitaqmi ni hayk'aqpas ninaqa wañunqachu}. ");
INSERT INTO qveNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Hinallataq sichus ñawiyki huchaman urmachisunki chayqa, aswanyá orqorpaspa wikapay. Aswan allinmi kanman huknin ñawillayoq Diospa gobiernasqan sumaq glorianman haykunaykipaq, ishkaynin ñawintin nina rawray infiernoman wikch'uyusqa kanaykimantaqa. ");
INSERT INTO qveNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Chay wiñaypaq nina rawray infiernopiqa, manan aycha urupas wañunchu, nitaqmi ni hayk'aqpas ninaqa wañunqachu. ");
INSERT INTO qveNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Diosqa llapallan runakunapa imapas ruwasqantan probanqa ninawan. Hinaspan ch'uyanchanqa, {imaynan kachiwanpas otaq ninawanpas ch'uyanchanku, chay hinata}. ");
INSERT INTO qveNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Kachiqa allinmi. Sichus kachi q'aymayarunman chayqa, ¿imapaqñataq valenman chay kachirí? Qankunaqa runamasiykichiswan allinta hinallataq hawkalla ima kawsaychis, saynapi huk kachi hina kanaykichispaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesusmi Capernaúm llaqtamanta lloqsispa, Judea lawman riran; hinaspan Jordán mayupa waq lawninman chimparan. Hinaqtinmi ashka runakunaqa yapamanta chayman huñunakamuqtinku, Jesusqa costumbrenman hina paykunata yachachiyta qallariran. ");
INSERT INTO qveNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Hinaqtinmi fariseo religionniyoq runakunaqa, Jesusman ashuyuranku. Hinaspan huchallichiyta munaspanku, Jesusta tapuranku khaynata: —¿Huk casado runa, warminmanta t'aqakuyta atinmanchú? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Hinaqtinmi Jesusqa paykunata tapuran: —Moisesri, ¿ima nispataq qankunatari kamachisurankichís? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Chaymi paykunaqa contestaranku: —Moisesqa permitiranmi, divorcio papelta firmayuspa, warminmanta huk runa t'aqakunantaqa, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Saynata niqtinkun Jesusqa paykunata niran: —Chaykunatan Moisesqa escribiran ñawpaq abueloykichiskunapaq, hinallataq qankunapaqwan ima, rumi sonqo kasqaykichisrayku. ");
INSERT INTO qveNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ichaqa kay pacha qallariyninpin, Diosqa warmi qarita ruwaran, (casarakuspa kushka tiyanankupaq). ");
INSERT INTO qveNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Chayraykun qariqa tayta mamanta saqespa, casarakusqan warmiwan kushka tiyanan. ");
INSERT INTO qveNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Chaymi casarakuspankuqa, manaña ishkay runa hinañachu kanku; aswanqa huk runa hinallaña kanku. ");
INSERT INTO qveNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Chayraykun Diospa juntasqan qaritawan warmitawanqa, mana ni pi runapas t'aqananchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Chaymantan Jesuspa discipulonkunaqa, wasipiña kashaspanku, chay t'aqanakuymantaqa Jesusta kaqmanta tapuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Chaymi Jesusqa paykunata niran: —Pipas warminmanta t'aqakuspa, huk warmiwan casarakuqqa, waqllikuspan huchallikun warminpa contranpi. ");
INSERT INTO qveNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Saynallataqmi sichus warmipas qosanmanta t'aqakuspa, huk qariwan casarakuqqa, waqllikuspan huchallikun qosanpa contranpi, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jesusmanmi wawakunata pusamuranku, paykunaman makinta churayuspa, Diosmanta mañapunanpaq. Ichaqa Jesuspa discipulonkunañataqmi chay wawakuna pusamuqkunata q'aqcharanku. ");
INSERT INTO qveNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Hinaqtinmi Jesusqa chay hark'akusqankuta rikuspa, discipulonkunata phiñarikuspa, khaynata niran: —Wawakuna noqaman hamunantaqa, ama hark'akuychishchu. Kay wawakuna hina kaq runakunapaqmi, Diospa gobiernasqan sumaq glorianqa. ");
INSERT INTO qveNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Chaymi cheqaqtapuni niykichis, kay wawakuna hina tukuy sonqonkuwan Diospi creeq runakunallan, Diospa gobiernasqan sumaq glorianmanqa haykunqaku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Hinaspan Jesusqa chaykunata rimayta tukuruspa, chaypi kaq wawakunata marq'arikuran. Hinaspan chay wawakunaman makinta churayuspa, paykunapaq Diosmanta mañapuran. ");
INSERT INTO qveNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesusqa chay wasimanta lloqsishaqtinñan, huk runa correyllaña payman hamuran. Hinaspan Jesuspa ñawpaqninpi qonqoriyukuspa, khaynata tapuran: —Allin yachachikuq, wiñaypaq kawsanaypaqri, ¿imatataq ruwayman? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Chaymi Jesusqa khaynata contestaran: —¿Imanaqtintaq noqatari niwanki: “Allin yachachikuq”, nisparí? Manan ni pi runapas allinqa kanchu; aswanqa Diosllan. ");
INSERT INTO qveNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Qanqa ñan yachankiña Diospa kamachikuyninkunataqa. Chay kamachikuykunan khaynata nin: “Aman waqllikunkichu, aman ni pitapas wañuchinkichu, aman suwakunkichu, aman ni pipa contranpipas llullakuspaqa rimankichu, aman ni pitapas engañankichu, hinallataq tayta mamaykitapas allinta respetaspa kasukunki”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Hinaqtinmi chay runaqa contestaspa niran: —Yachachikuq, noqaqa warma kasqaymantapachan kay kamachikuykunataqa kasukurani, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Chaymi Jesusqa munakuywan chay runata qawayuspa niran: —Chaykuna ruwasqaykimantapas hukraqmi ruwanaykiqa faltashasunki. Kunanyá wasiykiman rispayki llapallan kaqniykikunata vendemuy. Hinaspa chay vendemusqayki qolqeta wakcha runakunaman rakimuy. Saynata ruwaqtiykin, Diosqa huk allin premiota qosunki. Chayta ruwaramuspaykiñayá noqapa discipuloy kanaykipaqqa kutimunki, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ichaqa chay runañataqmi, Jesuspa chaykuna nisqanta uyariruspa, llakisqallaña pasapuran, ancha qapaq runa kasqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Hinaqtinmi Jesusqa muyuriqninpi llapallan runakunata qawarispa, discipulonkunata niran: —¡Ancha sasatan qapaq runakunaqa hanaq pachamanqa haykunqaku! nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Chaymi discipulonkunaqa Jesuspa sayna rimasqanta uyarispanku, anchata admirakuranku. Hinaqtinmi Jesusqa yapamanta niran: —Khuyasqay wawaykuna, {¡kay pachapi qori qolqellankupi confiaq} runakunaqa, ancha sasatan Diospa gobiernasqan sumaq glorianmanqa haykunqaku! ");
INSERT INTO qveNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ichaqa huk hatun camello animalraqmi awqapa ninrinta pasarunman, huk qapaq runa Diospa gobiernasqan sumaq glorianman haykunanmantaqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Hinaqtinmi Jesuspa yachachisqankunata uyarispanku discipulonkunaqa anchata admirakuspanku, paykunapura tapunakuranku khaynata: —Sayna kaqtinri, ¿pitaq atinman salvakuytarí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Chaymi Jesusñataq discipulonkunata qawayuspa niran: —Runakunapaqqa ima ruwaypas sasan. Diospaqmi ichaqa tukuy imapas mana sasachu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Hinaqtinmi Pedroqa Jesusta niran: —Noqaykuqa tukuy ima kaqniykutapas saqeruspaykun qanwan kushka purishayku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Chaymi Jesusqa khaynata niran: —Cheqaqtapunin niykichis, pipas noqarayku, hinallataq kay willakusqay palabraykunarayku saqenqa wasinta, wawqenta, pananta, papanta, mamitanta, warminta, wawankunata, hinallataq chakrankunatapas chayqa, ");
INSERT INTO qveNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kay pachapin kunan tiempopi pachaq kuti mastaraq chashkinqa: wasikunata, wawqekunata, panakunata, mamitakunata, wawakunata, hinallataq chakrakunatapas. Ichaqa ancha qatikachasqa kaspankun sasachakuykunawan kaykunataqa chashkinqaku. Hinallataqmi qepa tiempopipas wiñay kawsayta chashkinqaku. ");
INSERT INTO qveNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ichaqa kay pachapi runakuna qawananpaq importante kaq ashka runakunan, hanaq pachapiqa mana importantechu kanqaku. Ichaqa kay pachapi mana importante kaq ashka runakunañataqmi, hanaq pachapiqa aswan más importante kanqaku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesusqa discipulonkunapiwan kushka Jerusalén llaqtaman rishaspanmi, paykunapa tumpa ñawpaqninkuta riran. Ichaqa discipulonkunañataqmi qepanta riranku ancha preocupasqallaña. Saynallataqmi paykunawan riq runakunapas ancha mancharisqallaña riranku. Chaymi Jesusqa chunka ishkayniyoq discipulonkunata huk lawman waqyarispa, payta imas pasananmanta paykunaman kaqmanta willayta qallariran khaynata: ");
INSERT INTO qveNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Rikusqaykichisman hinan Jerusalén llaqtaman rishanchis. Chaypin noqa Diosmanta Hamuq Runaqa entregasqa kasaq sacerdotekunapa jefenkunaman, hinallataq leykunata yachachiq runakunaman ima. Paykunan sentenciawanqaku wañuchiwanankupaq. Hinaspan entregawanqaku huk law nacionniyoq runakunaman. ");
INSERT INTO qveNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Chaymi paykunaqa noqamanta burlakuwanqaku, uyaykunaman toqayuwanqaku, chansakunata ruwaspa latigawanqaku, hinallataq wañuchiwanqaku ima. Ichaqa kinsa p'unchawmantan noqaqa kawsarinpusaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zebedeopa wawankunan karan Jacobo, hinallataq Juan. Paykunan Jesusman ashuyuspanku, khaynata niranku: —Yachachikuq, kunanmi qanta valekuyta munayku, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Chaymi Jesusqa paykunata tapuran: —¿Imatataq valekuwaytari munashankichís? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Chaymi paykunaqa valekuranku khaynata: —Gobiernanaykipaq sumaq gloriaykipi tiyayuspaykiqa, permitiykuwaykuyá ishkayniyku qanpa ladoykipi tiyayunaykupaq, hukniyku phaña ladoykipi, hukniykuñataq lloq'e ladoykipi, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Chaymi Jesusqa paykunata contestaran khaynata: —Qankunaqa manan yachankichishchu ima mañakusqaykichistapas. Noqaqa anchatan ñak'arisaq. Chayri, ¿qankuna listochu kashankichis noqa hina ñak'arinaykichispaq? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Chaymi paykunaqa contestaranku khaynata: —Arí, noqaykuqa atisaqkun, nispanku. Hinaqtinmi Jesusqa paykunata niran: —Cheqaqtapunin niykichis, qankunaqa noqa hinan ñak'arinkichis. ");
INSERT INTO qveNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ichaqa manan noqachu nisaq pis phaña ladoypi otaq lloq'e ladoypi tiyananpaqqa. Aswanqa papaypa akllasqan runakunallan chaypiqa tiyanqaku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Hinaqtinmi wakin chunkantin discipulonkunaqa, chay valekusqankuta uyariruspanku, Jacobopaq hinallataq Juanpaq ima phiñakuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Chaymi Jesusqa discipulonkunata waqyaspa niran: —Qankunaqa yachankichismi nación llaqtakunata gobiernaq runakunaqa munasqankutan llaqtamasin runakunawanqa ruwanku. Saynallataqmi autoridadkunapas llaqtamasin runakunataqa kamachiranku munasqankuman hina. ");
INSERT INTO qveNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ichaqa qankuna ukhupiqa manan saynachu kanan. Aswanqa pipas qankuna ukhupi kamachiyta munaspaqa, qankunata servisuqniykichismi kanan. ");
INSERT INTO qveNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Hinallataq pipas allin reqsisqa primeropi kayta munaspaqa, qankuna ukhupiraqmi serviqniykichis runa kanan. ");
INSERT INTO qveNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Saynallataqmi noqa Diosmanta Hamuq Runaqa manan noqata serviwanankupaqchu hamurani. Aswanmi noqaqa runakunata servinaypaq hamurani, hinallataq huchasapa ashka runakunapa rantinpi wañuspa, salvanaypaq ima, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesusqa discipulonkunapiwan kushkan Jericó llaqtanta pasasharanku. Chaymi chay llaqtamanta lloqsishaqtinku, ashka runakuna Jesuspa qepanta riranku. Hinaqtinmi chay risqanku ñan patapi tiyashasqa Bartimeo sutiyoq huk ñawsa runa limosnata mañakuspa. Payqa Timeo sutiyoq runapa wawanmi karan. ");
INSERT INTO qveNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Hinaqtinmi chay ñawsa runaqa uyariran, Nazaret llaqtayoq Jesuspa hamusqanta. Hinaspan waqyakachakuyta qallariran khaynata: —¡Davidpa mirayninmanta Jesús, ama hina kaychu, khuyapayaykuway! nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Saynata waqyakuqtinmi chaypi kaq runakunaqa chay ñawsata q'aqchaspa, khaynata niranku: —¡Upallay! nispanku. Ichaqa saynata nishaqtinkupas, chay ñawsaqa astawanraqmi qapariran khaynata: —¡Davidpa mirayninmanta Jesús, ama hina kaychu, khuyapayaykuway! nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Chaymi Jesusqa risqan ñanpi sayaykuspa niran: —Chay ñawsa runata waqyamuspa apamuychis, nispa. Hinaqtinmi runakunaqa rispanku, chay ñawsa runataqa niranku: —¡Sayariy, ama manchakuychu! Jesusmi waqyamushasunki, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Chaymi chay ñawsa runaqa, capanta wikapaspa, hinallataq saltarisparaq Jesusman hamuran. ");
INSERT INTO qveNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Hinaqtinmi Jesusqa chay ñawsa runata tapuran: —¿Imatataq qanpaq ruwanaytari munankí? nispa. Chaymi chay ñawsa runaqa contestaspa niran: —Yachachikuq, rikuytan munani, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Chaymi Jesusqa chay nisqanta uyarispa niran: —Ripuy, Diospi creesqaykiraykun sanoña kanki, nispa. Hinaqtinmi kasqan ratolla ñawin rikuqtin, chay runaqa Jesusta qatikuran. ");
INSERT INTO qveNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jesusqa discipulonkunapiwan kushkan Olivos nisqa moqopa ladonman chayaranku. Chay Olivos moqoqa karan Betfagé sutiyoq llaqtapa cercanpi, Betania llaqtapa cercanpi, hinallataq Jerusalén llaqtapa cercanpiwan iman. Chaypin Jesusqa ishkay discipulonkunata kamachispa ");
INSERT INTO qveNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","khaynata niran: —Waq chimpapi kaq llaqtachaman riychis. Chayman chayaruspaykichismi, manaraq pipas montakusqan malta asnota watasqata tarinkichis. Chayta pashkamuspayá aysamunkichis. ");
INSERT INTO qveNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Pipas tapusunkichis: “¿Imapaqtaq chay asnotari pashkashankichís?” nispa; hinaqtinqa qankunan khaynata ninkichis: “Señorniykun necesitashan; payqa kutichinpullasunkin”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Hinaqtinmi Jesuspa discipulonkunaqa, chay llaqtachaman rispanku, chay malta asnotaqa wasipa punkun ñanpi watasqata tariranku. Hinaspan chay malta asnota pashkaranku. ");
INSERT INTO qveNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Hinaqtinmi chaypi kaq wakin runakunaqa, chay pashkaq runakunata rikuspanku, tapuranku khaynata: —¿Imapaqtaq chay asnotari pashkashankichís? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Chaymi discipulokunaqa Jesuspa kamachisqanman hina contestaranku. Hinaqtinmi manaña hark'akuqtinku, chay asnota aysamuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jesuspa kasqanman asnota aysaramuspankun, p'achankuwan karunaruspanku, Jesusta chay asnoman montachiranku. ");
INSERT INTO qveNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Chaymi ñanninta Jesús rishaqtin, wakin runakunaqa p'achankuta ñanman mast'aranku, chayninta Jesús pasananpaq. Wakin runakunañataqmi sach'apa ramankunata wit'umuspanku, ñanman churaranku, chayninta Jesús pasananpaq. ");
INSERT INTO qveNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Chaymi Jesuspa ñawpaqninta, hinallataq qepanta riqkunapas, llapallanku altota qaparispa, khaynata niranku: —¡Diospa sutinpi Hamuq Salvadorninchisqa alabasqayá kachun! ");
INSERT INTO qveNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Ñawpaq abuelonchis rey David hina gobiernananpaq Hamuq Runaqa hatunchasqayá kachun! ¡Hanaq pachapi kaqkunapas Diostayá alabachunku! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Chaymantan Jesusqa Jerusalén llaqtaman chayaramuspa, temploman riran. Hinaspan temploman haykuspa, chaypi tukuy ima kaqkunata qawaran. Ichaqa tardeña kaqtintaqmi, chunka ishkayniyoq discipulonkunapiwan kushka Betania llaqtaman riran. ");
INSERT INTO qveNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Paqarisnintin p'unchawñataqmi, Jesusqa discipulonkunapiwan kushka, Betania llaqtamanta lloqsimuranku. Hinaqtinmi Jesusqa chay ñan hamusqankupi yarqachikuran. ");
INSERT INTO qveNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Hinaspan rap'isapallaña higos sach'ata karullamantaraq rikururan. Chaymi chay sach'apa rurunta qawaq riran. Ichaqa chay sach'apa kasqanman chayaruspantaqmi, ruruntaqa mana tariranchu, rurunan tiempo manaraq kasqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Chaymi Jesusqa chay higos sach'ata, khaynata niran: —Kunan p'unchawmantaqa manan ni pipas ruruykitaqa mikhunqachu, nispa. Chay nisqantan discipulonkuna uyariranku. ");
INSERT INTO qveNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jesusqa Jerusalén llaqtaman chayaramuspanmi, temploman riran. Hinaspan temploman haykuspa chaypi vendeq runakunata, hinallataq rantiqkunatapas templomanta qarqomuyta qallarimuran. Saynallataqmi huk law nacionpa qolqenta, templopa qolqenwan cambiaq runakunapa mesankunatapas wikaparan. Hinallataq paloma vendeqkunapa tiyananku bancakunatapas pampaman wikaparan. ");
INSERT INTO qveNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Hinallataqmi mana permitiranchu, runakuna templo ukhullantaña, ima cosasninkutapas apayukuspa, ñanninta hina pasanankutaqa. ");
INSERT INTO qveNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Hinaspan Jesusqa llapallan runakunaman yachachiyta qallariran khaynata: —Qankunari, ¿manachu Bibliapi Diospa nisqanta yacharankichís? Bibliapiqa nishanmi khaynata: “¡Kay wasiyqa, noqamanta mañakuna wasin kanqa, llapallan nacionkunapaq!” nispa. Ichaqa qankunan tukurachinkichis suwakunapa wasinman hina, nispa Isaías 56.7; Jeremías 7.11. ");
INSERT INTO qveNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jesuspa yachachisqankunatan llaqtapi runakunaqa admirakuspa uyariranku. Chayraykun Jesusta manchakuspanku, sacerdotekunapa jefenkuna, hinallataq leykunata yachachiq runakunapas piensaranku, imaynata ruwaspas Jesusta wañurachinankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tardeyaramuqtintaqmi Jesusqa discipulonkunawan kushka, chay Jerusalén llaqtamanta lloqsispa ripuran. ");
INSERT INTO qveNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Paqarisnintin p'unchawmi, tutallanmanta Jesusqa discipulonkunapiwan kushka chay higos sach'apa ladonta pasasharanku. Hinaspan rikuranku chay higos sach'aqa, saphinkama ch'akirusqanta. ");
INSERT INTO qveNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Chaymi Pedroqa chay higos sach'amanta yuyariruspa, Jesusta niran: —¡Yachachikuq, waq higos sach'a maldecisqaykita qawariy! ¡Chay higos sach'aqa ch'akirapusqan! nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Hinaqtinmi Pedropa nisqanta uyarispa, Jesusqa khaynata niran: —Qankunaqa Diospi creespayá confiaychis. ");
INSERT INTO qveNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Sichus cheqaqtapuni, pipas sonqonpi mana ishkayaspa, kay orqota ninman khaynata: “Chaymanta kuyurispa lamar qochaman wikch'uyukuy”, nispa, hinaqtinqa kay orqopas kasususpaykichismi, nisqaykichisman hina, ruwasqa kanman. ");
INSERT INTO qveNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Chayraykun niykichis: Sichus cheqaqtapuni creespa Diosmanta mañakunkichis chayqa, ima mañakusqaykichistapas chashkinkichismi. ");
INSERT INTO qveNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ichaqa Diosmanta mañakushaspaykichisqa, perdonaychisyá qankunata ofendesuqniykichis runataqa. Saynata perdonaqtiykichismi hanaq pachapi Dios Taytaykichispas huchaykichistaqa perdonasunkichis. ");
INSERT INTO qveNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","{Ichaqa ofiendesuqniykichis runata mana perdonankichishchu chayqa, hanaq pachapi Diospas manan qankunataqa perdonasunkichishchu}, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jesusqa discipulonkunapiwan kushkan Jerusalén llaqtaman yapamanta kutimuranku. Hinaspan temploman rispa chaypi purisharan. Hinaqtinmi payman ashuykamuranku Israel nación templopi serviq sacerdotekunapa jefenkuna, leykunata yachachikuq runakuna, hinallataq llaqtapi kamachiq wakin runakunapiwan ima. ");
INSERT INTO qveNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Hinaspan paykunaqa Jesusta tapuranku khaynata: —Templomanta vendeqkunata qarqonaykipaqri, ¿pitaq qanmanri autorizacionta qosurankí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Chaymi Jesusqa paykunata contestaspa niran: —Noqapas qankunatan kunan tapullasqaykichistaq. Sichus qankuna contestawankichis chayqa, noqapas nisqaykichismi ima autoridadwansi kaykuna ruwasqaytaqa. ");
INSERT INTO qveNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Kunanyá niwaychis, Bautizaq Juanmanri, ¿pitaq autorizaran runakunata bautizananpaqrí? ¿Dioschu icha runakunallachú? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Saynata Jesús tapuqtinmi, paykunapura parlanakuranku khaynata: —Sichus noqanchis nisunchis: “Diosmi autorizaran”, nispa, hinaqtinqa niwasunchá: “¿Imanasqataq Juanpa nisqantari mana creerankichishchú?” nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Hinaspapas manan nisunmanchu: “Runakunallan Juantaqa autorizaran bautizananpaq”, nispaqa. Paykunaqa saynatan parlanakuranku chaypi kaq runakunata manchakusqankurayku. Hinaspapas chaypi kaq llapallan runakunaqa yacharankun, Bautizaq Juanqa llapallan runakunapa ancha respetasqan cheqaq profeta kasqanta. ");
INSERT INTO qveNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Chayraykun Jesusta contestaspa niranku: —Manan yachaykuchu, nispanku. Hinaqtinmi Jesuspas nillarantaq: —Noqapas manan nisqaykichishchu ima atiywansi kaykuna ruwasqaytaqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesusmi ejemplonkunawan runakunaman yachachispa, khaynata niran: —Huk runan uvas plantakunata chakranpi plantaran. Hinaspan chay chakranpa muyuriqninta cercoran. Hinallataqmi uvas cosechasqanmanta vinota ruwananpaqpas, huk pozota ruwaran. Saynallataqmi chay chakranta cuidananpaqpas, huk hatun torreta ruwaran. Chaykunata ruwayta tukuruspanmi, chay uvas chakranta huk llank'aq runakunaman arrendaran. Hinaspan karu llaqtaman viajaran. ");
INSERT INTO qveNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Cosecha tiempo chayaramuqtintaqmi, chay chakrayoq runaqa huk serviqnin runata mandamuran, chay chakran arrendasqan runakunamanta, tupaqnin cosechata chashkispa dueñonman apapunanpaq. ");
INSERT INTO qveNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ichaqa chay arrendaq runakunaqa chay sirviente runata hap'iruspankun, alli-allinta maqaranku. Hinaspan mana imantillanta qatirpapuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Hinaqtinmi chay uvas chakrapa dueñonqa payman tupaqnin cosechata cobramunanpaq, huknin serviqnin runatañataq kaqmanta mandamuran. Ichaqa paytapas, chay arrendaq runakunaqa millayta k'amispankun, umantapas p'anaspa llik'iranku. Hinaspan paytapas mana imantillanta qatirpapuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Hinaqtinmi chay chakrapa dueñonqa kaqmanta mandamullarantaq huk serviqnin runatañataq. Chaymi uvas chakra arrendaq runakunaqa paytapas wañuchiranku. Saynata ruwashaqtinkupas, dueñonqa huk sirvienten runakunatapas mandamullarantaqmi. Paykunatapas wakintan maqaranku, wakintañataqmi wañuchiranku ima. ");
INSERT INTO qveNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Chaykuna pasaqtinmi, chay uvas chakrayoq runaqa mandamuran ancha munakusqan wawantañataq, khaynata yuyaymanaspa: “Wawayta rikuspaqa ichapas respetankuman”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ichaqa uvas chakra arrendaq runakunañataqmi, chakrayoqpa wawan chayamusqanta rikuspanku, khaynata ninakuranku: “Paymi papan wañuruqtinqa kay herencia chakrawanqa qepakunqa. Chayqa aswanyá wañurachillasunña, saynapi kay enteron chakrawan noqanchis qepakunanchispaq”, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Chaymi uvas chakrayoqpa wawantaqa hap'iruspanku wañuchiranku. Hinaspan cuerpontapas uvas chakrapa waq lawninman wikapamuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Kunan piensaychis, chay chakrapa dueñonri, ¿imatataq ruwanqa? Payqa kikinpuni hamuspanmi, chay chakran arrendaq runakunata wañuchispa, huk runakunamanñataq chay chakrantaqa arrendanqa. ");
INSERT INTO qveNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Qankunari, ¿manachu Bibliapi leerankichis khayna nisqanta?: “Albañilkunapa mana munasqan rumin, kunanqa aswan más allin kaq rumi, wasiq esquinanpi allinta enteron wasipa perqanta sostienen. ");
INSERT INTO qveNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Kayqa Diosninchispa ruwasqanmi. Hinaspapas kay qawasqanchisqa anchata admirakunapaqmi”, nispa Salmos 118.22-23. ");
INSERT INTO qveNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Hinaqtinmi sacerdotekunapa jefenkunaqa, leykunata yachachiq runakunapiwan, hinallataq Israel nación llaqtapi kamachiq runakunapiwan ima cuentata qokuranku, paykunamanta Jesús rimasqanta. Chayraykun paykunaqa Jesusta presochanankupaq hap'iruytapuni munaranku. Ichaqa manataqmi piensasqankuman hina ruwaytaqa atirankuchu, runakunata manchakuspanku. Hinaspan mana ni imatapas ruwayta atispa pasapuranku. Nota: Chakraqa Diospa obranmi. Chakrapa dueñonqa, Diosmi. Chakra arrendaq runakunaqa, Diosmanta yachachiq sacerdotekuna, hinallataq leymanta yachachiq runakuna iman. Sirviente runakunañataqmi, Diosmanta willakuq profetakuna. Chakrayoqpa wawanñataqmi, Jesucristo. ");
INSERT INTO qveNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Llaqtapi kamachiq autoridadkunan Jesusman mandamuranku wakin fariseo religionniyoq runakunata, hinallataq rey Herodespa partenmanta runakunatawan ima. Paykunataqa mandamuranku, Jesús rimaspa imamantapas pantaruqtin chayman hinalla acusanankupaqmi. ");
INSERT INTO qveNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Chaymi paykunaqa rispanku, Jesusta khaynata niranku: —Yachachikuq, noqaykuqa yachaykun cheqaqtapuni rimaq kasqaykita. Hinaspapas qanqa manan runakunapa munasqanman hinachu imatapas ruwanki. Aswanmi qanqa pimanpas mana sayapakuspalla, Diosmanta cheqaqtapuni yachachinki, saynapi Diosta kasukunankupaq. Chayqa kunanyá niwayku, rey Cesarman impuesto pagayri, ¿allinchu kanman icha manachú? ¿Pagaykumanchu icha manachú? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ichaqa Jesusqa yacharanmi, paykunaqa ishkay uya runakuna kasqankuta. Chaymi contestaran khaynata: —Qankunari, ¿imanaqtintaq pantachiwayta munashankichís? Apamuychis (impuesto paganaykichis) qolqeta qawayunaypaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Hinaqtinmi huk qolqeta payman apamuqtinku, Jesusqa paykunata tapuran: —Kay qolqepiri, ¿pipa uyantaq hinaspapas pipa sutintaq kashan? nispa. Chaymi paykunaqa contestaranku: —Roma llaqtamanta kamachikamuq rey Cesarpan, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Hinaqtinmi Jesusqa paykunata niran: —Saynaqa rey Cesarpa kaqtaqa, rey Cesarman qopuychis. Hinallataq Diospa kaqtapas, Diosman qopuychis, nispa. Hinaqtinmi Jesuspa nisqanta uyarispanku, llapallan chaypi kaq runakunaqa anchata admirakuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Saduceo religionniyoq runakunan mana creerankuchu wañusqa runakunapa kawsarimunanpi. Chayraykun paykunaqa Jesuspa kasqanman hamuranku. Hinaspan Jesusta tapuranku huk ejemplota willaspanku: ");
INSERT INTO qveNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Yachachikuq, Moisespa escribisqan leypin niwanchis: “Huk runa casarakuspa, warminpi manaraq wawan kashaqtin wañupunman chayqa, wawqenmi chay viudawan casarakuspa wawayoq kanan. Hinallataqmi chay wawa nacemuqpas, wañuqpa wawan hina kaspa, paypa sutinta apanan, saynapi wañuq wawqenpa sutin ama chinkananpaq”, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kunan willasqaykiku. Qanchis wawqekunan karanku. Hinaspan kuraq kaq casarakuran. Ichaqa manaraq wawayoq kashaspanmi, wañupuran. ");
INSERT INTO qveNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Hinaqtinmi kuraq kaqman qatiq wawqen chay viudawan casarakuran. Paypas saynallataqmi manaraq wawayoq kashaspa, wañupullarantaq. Saynallataqmi pasaran kinsa kaqwanpas, tawa kaqwanpas, pishqa kaqwanpas, soqta kaqwanpas, hinallataq qanchis kaqwanpas. ");
INSERT INTO qveNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Chay qanchisnintin mana wawayoq wawqekunapa wañusqanpa qepanmanmi, chay viuda warmipas wañupullarantaq. ");
INSERT INTO qveNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Chaymi kunan tapukuyniyku kashan. Llapallan wañuqkunata Dios kawsarichimuqtinri, ¿mayqenpa warmintaq kanqa chay warmirí? Chay warmiqa qanchisnintin wawqekunawanmi casarasqa karan, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Hinaqtinmi Jesusqa paykunata khaynata contestaran: —Qankunaqa pantaypin kashankichis. Manan yachankichishchu Bibliapa nisqanta, nitaqmi Diospa atiynintapas reqsinkichishchu. ");
INSERT INTO qveNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Chaymi niykichis, wañuqkunata Dios kawsarichimuqtinqa, manan ni pipas casarakunqachu. Aswanmi hanaq pachapi angelkuna hinallaña kanqaku manaña casarakuspa. ");
INSERT INTO qveNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ichaqa wañuqkunapa kawsarimunanmantari, ¿manachu Bibliapi leerankichis nina rawrashaq t'ankar kishka ukhumanta Diospa nimusqanta? Paymi Moisesta khaynata niran: “Noqan kani Abrahampa, Isaacpa hinallataq Jacobpa Diosnin”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Diosqa manan wañusqa runakunapa Diosninchu, aswanqa kawsashaq runakunapa Diosninmi. Chaymi Abrahampas, Isaacpas, hinallataq Jacobpas, wañusqaña kashaspankupas, Diospaqqa kawsashankun. ¡Chaymi niykichis, qankunaqa pantaypin kashankichis! nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jesusmi saduceo religionniyoq runakunata allinta contestaran. Saynata Jesús contestaqtinmi, leykunata yachachiq runakunamanta huknin kaq runa, Jesusman ashuyuspa, tapuran khaynata: —Yachachikuq, ¿Diospa kamachikuyninkunamantari, mayqen kaq kamachikuytaq aswan más importanterí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Chaymi Jesusqa contestaspa niran: —Llapan kamachikuykunamanta aswan más importante kaq kamachikuyqa, khaynatan nin: “Kay Israel nación llaqtapi tiyaq runakuna uyariychis, Diosninchisqa ch'ullallan. Payllan Dios. ");
INSERT INTO qveNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Señor Diosniykita khuyakuy tukuy sonqoykiwan, tukuy almaykiwan, tukuy piensayniykiwan, hinallataq tukuy kallpaykiwan ima”. ");
INSERT INTO qveNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Saynallataqmi huknin kaq kamachikuypas, kay primer kaq kamachikuyman rikch'akun. Chaymi khaynata nin: “Runa masiykita khuyakuy, qan kikiykita hina”, nispa. Kay ishkaynin kamachikuykunan, wakin kamachikuykunamantaqa aswan más importante, nispa Levítico 19.18; Deuteronomio 6.4-5. ");
INSERT INTO qveNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Jesuspa nisqanta uyarispanmi, leykunata yachachiq runaqa, Jesusta niran: —Yachachikuq, chay nisqaykiqa cheqaqpunin. Diosqa ch'ullallan. Manan ni pipas pay hinaqa kanchu. ");
INSERT INTO qveNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Chaymi Diostaqa khuyakuna tukuy sonqowan, tukuy piensaywan, hinallataq tukuy kallpawan ima. Saynallataqmi runamasinchistapas khuyakuna imaynan noqanchispas kikinchista khuyakunchis chay hinata. Chay ishkaynin kamachikuykunan aswan más importanteqa, animalkunata k'anaspa, Diosman sacrificio ofrecenaykichismantaqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Saynata chay runa allin yachaywan rimaruqtinmi, Jesusqa payta niran: —Qanqa Diospa gobiernasqan sumaq glorianmantaqa manan karupichu kashanki, nispa. Jesuspa nisqankunata uyarispankun, manaña ni imaynanmantapas tapuytaqa atirankuñachu. ");
INSERT INTO qveNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jerusalén templopi Jesús yachachispanmi tapuran: —Leykunata yachachiq runakunari, ¿imanaqtintaq ninku: “Diosmanta Hamuq Salvawaqninchisqa Davidpa mirayninmantan kanqa”, nisparí? ");
INSERT INTO qveNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ichaqa kikin rey Davidpunin, Diospa Santo Espiritun yachachiqtin, khaynata escribiran: “Señor Diosmi Señorniyta niran: ‘Phaña ladoypi tiyaykuy, llapallan enemigoykikunata noqa vencespay, chaki plantaykiman churanaykama’ ”, nispa Salmos 110.1. ");
INSERT INTO qveNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Hinaspapas kikin rey Davidpunin niran Cristomantaqa: “Señorlláy”, nispa. Chayri, ¿imanaqtintaq Diosmanta Hamuq Runari, ñawpaq rey Davidpa mirayninmantari kanman? nispa. Chaypin karanku ashka runakuna. Hinaspan llapallanku Jesuspa nisqankunata ganaswan uyariranku. ");
INSERT INTO qveNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesusmi runakunaman yachachispa, khaynata nillarantaq: —Qankunaqa leykunata yachachiq runakuna hina kanaykichismantayá cuidakuychis. Paykunaqa allin p'achakunawanmi p'achakuytapas munanku. Plazakunapipas runakuna respetollawanña rimayukunankutan munanku; ");
INSERT INTO qveNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","fiestakunaman rispankupas, otaq Diosmanta yachachina sinagoga wasiman rispankupas, ñawpaqpi kaq allinnin asientokunallapin tiyaytapas munanku. ");
INSERT INTO qveNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","¡Hinaspapas paykunaqa viudakunapa wasinpi kaqninkunatan qechunku! ¡Saynata ruwashaspankupas una-unaytaraqmi Diosmantapas mañakunku! Chayraykun paykunataqa, wakin runakunamantapas aswan mastaraq Dios castiganqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Huk p'unchawmi Jesusqa Jerusalén temploman haykuspa, ofrenda churananku cajapa ñawpaqninpi tiyayuran. Hinaspan runakunapa ofrenda churasqankuta qawaran. Hinaqtinmi qapaq runakunapas ofrenda churana cajaman ashka qolqeta churaranku. ");
INSERT INTO qveNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Chay ratollapitaqmi, huk wakcha viudapas hamuspa, mana ancha valorniyoq ishkay qolqechallata ofrenda cajaman churaran. ");
INSERT INTO qveNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Hinaqtinmi Jesusqa discipulonkunata waqyarispa, khaynata niran: —Cheqaqtapunin niykichis, kay wakcha viudan llapallan qapaq runakunamantapas, aswan mastaraq churarun ofrenda churana cajaman. ");
INSERT INTO qveNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Qapaq runakunaqa puchuqllantañan ofrendankutaqa churanku. Ichaqa kay viudañataqmi wakcha kashaspapas, llapallan mantenekunan qolqechanta churarun, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jerusalén llaqtapi templomanta Jesús lloqsishaqtinmi, Jesusta huknin kaq discipulon niran: —Yachachikuq, ¡qawariy kay templota, hinallataq kay hatun rumikunawan sumaq perqankunatapas! nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Hinaqtinmi Jesusqa contestaspa niran: —Kay sumaq templo rikusqaykin thuñichisqa kanqa. Hinaqtinmi mana ni huk rumillapas perqasqaqa qepanqachu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesusqa discipulonkunapiwanmi Jerusalén templopa chimpan Olivos nisqa moqoman riran. Chaypi Jesús tiyayuqtinmi Pedro, Jacobo, Juan, hinallataq Andrespiwan ashuyuspanku, Jesusta sapallankupi tapuranku: ");
INSERT INTO qveNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Yachachikuq, willaykuwaykuyá ¿hayk'aqtaq kay Jerusalenpi templori thuñichisqa kanqa? ¿Ima señalkunataq pasanqa chaykuna cumplikunanpaqrí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Hinaqtinmi Jesusqa contestaspa niran: —Qankunaqa piwanpas ama engañachikunaykichispaq, ¡allinta cuidakuychis! ");
INSERT INTO qveNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ichaqa ashka runakunan noqapa sutiypi hamunqaku. Hinaspan khaynata ninqaku: “Noqan kani Cristo”, nispanku. Saynata rimaspankun paykunaqa ashka runakunata engañanqaku. ");
INSERT INTO qveNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Hinallataqmi qankunaqa uyarinkichis, ashka nación llaqtakunapi guerrakunamanta, hinallataq guerra ruway munaq llaqtakunamantawan ima. Chaykunata uyarispaykichisqa amayá mancharikunkichishchu. Chaykunaqa hinapunin pasanan. Ichaqa chaykuna pasashaqtinpas, manaraqmi kay pachapa tukukunan tiemporaqchu. ");
INSERT INTO qveNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kay pachapi huk nación llaqtakunaqa, huk law nación llaqtakunawanmi guerrapi peleanqaku. Saynallataqmi kaypi waqpi terremotokunapas pasanqa. Hinallataqmi mikhuy mana kaqtin, ancha muchuypas kanqa. Ichaqa chaykuna pasashaqtinpas, yachaychisyá chaykunaqa ñak'ariykunapa qallariynillanraq kasqanta. ");
INSERT INTO qveNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Saynaqa allintayá cuidakuychis. Ichaqa qankunatan autoridadkunaman entregasunkichis; hinallataq Diosmanta yachachina sinagoga wasikunapi p'anasunkichis. Saynapin qankunataqa noqapa discipuloykuna kasqaykichisrayku, llaqtapi kamachiq autoridadkunaman, hinallataq reykunapa ñawpaqninkunamanpas presochasqata apasunkichis. Ichaqa saynapin qankunapaqqa huk oportunidad kanqa, paykunaman noqamanta willanaykichispaq. ");
INSERT INTO qveNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ichaqa kay pachapa tukukuynin tiempo manaraq chayamushaqtinmi, Diosmanta allin willakuykuna enteron mundopi willasqa kanqa. ");
INSERT INTO qveNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Qankunata autoridadkunaman apasuqtiykichisqa, amayá preocupakunkichishchu ima ninaykichismantapas, nitaq imaynata defiendekunaykichismantapas. Diospa Santo Espiritunmi qankunataqa ima rimanaykichispaqpas yanapasunkichis. Chaymi qankunaqa Diospa yanapasqanwan imatapas rimankichis. ");
INSERT INTO qveNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Chay p'unchawkunapiqa, wawqellanmi wawqenta traicionaspa wañuchinankupaq entreganqa. Saynallataqmi papanpas wawanta traicionanqa. Hinallataq wawanpas papanpa otaq mamitanpa contranpi sayarispa wañuchinqa. ");
INSERT INTO qveNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Noqapa discipuloykuna kasqaykichisraykun, qankunata ashka runakuna cheqnisunkichis. Ichaqa wañunankukama noqapi creeqkunatan noqaqa salvasaq. ");
INSERT INTO qveNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Pipas kaykunata leeqqa entiendechunyá. Sichus qankuna kay Jerusalén templopi huk millakuypaq ofrendata Diosman haywaqta rikunkichis chayqa, ayqekuychisyá apurayllaman. Hinallataq kay enteron Judea provincia lawpi kaqkunapas, correyllayá orqokunaman riychis. ");
INSERT INTO qveNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Wasi patapi kaqkunapas, amayá imatapas orqonankupaqqa urayamuchunkuchu. ");
INSERT INTO qveNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Hinallataq campopi kaqkunapas, amayá wasinkumanqa kutimuchunkuchu, p'achankuta orqoqqa. ");
INSERT INTO qveNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Ay, imaynaraq kanqaku chay p'unchawkunapi wiksayoq warmikunapas, hinallataq qolla wawayoq warmikunapas! ");
INSERT INTO qveNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Qankunaqa aswanyá Diosmanta mañakuychis, kay nisqaykuna paray wichaypi ama kananpaq. ");
INSERT INTO qveNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Chay p'unchawkunapin runakunaqa anchata ñak'arinqaku. Sayna ñak'ariyqa manan karanchu, kay pachata Dios unanchasqanmantapacha asta kunankamapas, nitaqmi sayna ñak'ariyqa huktawanqa ni hayk'aqpas kanqachu. ");
INSERT INTO qveNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Diosqa akllasqan wawankunataqa anchatapunin khuyakun. Chayraykun chay ñak'ariy p'unchawkunaqa mana unaytachu duranqa. Sichus unayta duranman chayqa, manan ni pipas salvasqa kaytaqa atinmanchu. ");
INSERT INTO qveNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Sichus chay p'unchawkunapi pipas nisunkichis: “Qawaychis, kaypin kashan Cristoqa” otaq “Waqpin kashan Cristoqa”, nispa, chayqa, aman qankunaqa paykunataqa creenkichishchu. ");
INSERT INTO qveNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ichaqa qepa p'unchawkunataqa “Criston kani” niq runakunapas, hinallataq Diosmanta willakuq “profetan kani” niq runakunapas hamunqakun. Hinaspan paykunaqa runakunata engañanankupaq, ancha admirakuypaq milagrokunata ruwanqaku. Chay milagrokunata rikuchispan, Diospa akllasqan runakunatapas engañayta munanqaku. ");
INSERT INTO qveNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Saynaqa ¡cuidakuychisyá! Noqaqa ñan kaykunamantaqa willaraykichishña manaraq kaykuna pasashaqtin, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Jesusqa discipulonkunatan nillarantaq khaynata: —Chay ñak'ariy p'unchawkunapin intipas tutayanqa; killapas manaña k'anchanqañachu. ");
INSERT INTO qveNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Hinallataqmi qoyllurkunapas cielomanta urmayamunqa. Hinaqtinmi cielopi tukuy ima kaqkunapas khatatatanqa. ");
INSERT INTO qveNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Chaymi noqa Diosmanta Hamuq Runataqa llapallan runakuna rikuwanqaku, cielomanta tukuy atiyniywan phuyuq chawpinta k'ancharispa hamushaqta. ");
INSERT INTO qveNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Hinaspan enteron mundoman angelniykunata mandasaq, noqapi llapallan creeq runakunata huñumunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Saynaqa yachaychisyá higos sach'amanta willakuyta. Kay higos sach'apa ramankuna retoñamuqtinmi, qankunaqa yachankichis paray wichay cercaña kasqanta. ");
INSERT INTO qveNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Saynallataqyá kay llapallan nisqaykunata rikuspaykichisqa, noqapa hamunay p'unchawqa cercallaña kasqanta yachaychis. ");
INSERT INTO qveNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Cheqaqtapunin niykichis, kay nisqaykunaqa cumplikunqa, kay tiempopi kawsaq runakuna manaraq wañushaqtinmi. ");
INSERT INTO qveNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Hanaq pachapas hinallataq kay pachapas tukukunqan. Noqapa palabraykunan ichaqa, mana ni hayk'aqpas tukukunqachu. ");
INSERT INTO qveNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Manan ni pipas yachanchu ima p'unchawtas, otaq imay horastas noqapa kutimunaytaqa. Manan ni hanaq pachapi angelkunapas yachankuchu. Noqapas manan yachanichu. Aswanqa Dios Taytallaymi kutimunay p'unchawtaqa yachan. ");
INSERT INTO qveNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Chaymi niykichis, qankunaqa allintayá cuidakuychis, hinaspapas rikch'an-rikch'an hinallayá Diosmanta mañakuspaykichis kawsaychis. Ichaqa hayk'aq kutimunaytapas manan yachankichishchu. ");
INSERT INTO qveNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Noqapa kutimunayqa rikch'akun viajeman riq runamanmi. Paymi viajananpaq sirvientenkuna allinta cuidanankupaq wasinta encargatamun. Hinaspan sapankamaman ima ruwanankutapas qon. Punkupi cuidaqtapas kamachitamunmi rikch'an-rikch'anlla kananpaq. ");
INSERT INTO qveNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Chay llank'aq runakunaqa tuta p'unchawmi listolla kanqaku. Paykunaqa manan yachankuchu imay horastas dueñon kutimunantaqa: tardeykuytachus, chawpi tutatachus, gallo waqamuy horastachus, icha pacha achiqamuytachus. Saynallataqyá qankunapas listolla kaychis, noqa kutimuqtiy allinta chashkiwanaykichispaq. ");
INSERT INTO qveNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Noqaqa mana yachasqaykichis horaslla kutiramuspaymi, puñushaqta tariramuykichisman. ");
INSERT INTO qveNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Chayraykun kay nisqaykunataqa noqapi llapallan creeqkunaman nitamushani. ¡Chayqa, sapa p'unchawyá listolla kaychis! nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ishkay p'unchawllañan faltasharan Pascua fiestapaq, hinallataq mana levadurayoq t'antata mikhunanku fiestapaqpas. Chay p'unchawkunapin Israel nación llaqtapi sacerdotekunapa jefenkunaqa, leykunata yachachiq runakunapiwan, Jesuspa rimasqanta pantarachiyta munaranku, saynapi pantaruqtin presochaspa wañuchinankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Chaymi paykunaqa khaynata ninakuranku: —Jesustaqa hap'isunpunin, aswanqa amayá chay fiesta p'unchawpichu, Jesusman sayapakuspanku runakuna contranchispi ama hatarimunankupaq, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Betania llaqtapi lepra onqoymanta sanoyaq Simonpa wasinpin Jesusqa kasharan. Chaypi mikhushaqtinmi, huk warmiqa Jesuspa kasqanman hamuran, huk llushk'a rumimanta ruwasqa p'uyñuchapi, sumaq mishk'i perfumeta apayukuspa. Hinaspan Jesusman ashuyuspa, chay p'uyñuchata p'akispa, chay mishk'i q'apaq perfumetaqa Jesuspa umanman hich'ayuran. Chay perfumeqa ashka qolqepa valorninmi karan. ");
INSERT INTO qveNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Hinaqtinmi chaypi wakin kaq runakunaqa, anchata phiñakuspanku tapunakuranku: —¿Imanaqtintaq kay ashka valorniyoq mishk'i q'apaq perfumetari usuchishan? ");
INSERT INTO qveNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Kay perfumetaqa huk wata jornalpa valorninman vendespachá, wakchakunata yanapasunman karan, nispanku. Saynata piensaspankun, chay warmitaqa q'aqcharanku. ");
INSERT INTO qveNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Hinaqtinmi Jesusqa paykunata niran: —¡Upallaychis! Kay warmitari, ¿imanaqtintaq q'aqchashankichís? Payqa aswanmi allin kaqta noqapaq ruwarun. ");
INSERT INTO qveNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Wakcha runakunaqa tukuy tiempon qankunapa ladoykichispi kanqa. Chaymi qankunaqa munasqaykichis hora paykunataqa yanapawaqchis. Noqan ichaqa mana tukuy tiempochu qankunawanqa kasaq. ");
INSERT INTO qveNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Chayraykun kay warmiqa atisqallanta ruwashan. Payqa manaraq wañushaqtiymi cuerpoyta alistashan, wañuchiwaqtinku p'ampasqa kanaypaq. ");
INSERT INTO qveNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Chaymi cheqaqtapuni niykichis, Diosmanta kay allin willakuykunata maypipas willakuspankuqa, kay warmipa ruwasqantapas yuyarispankun willakunqaku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jesuspa chunka ishkayniyoq discipulonkunamanta, Judas Iscariote sutiyoq kaqmi, Israel nación llaqtapi sacerdotekunapa jefenkunaman riran. Hinaspan Jesusta paykunaman entregananpaq ofrecekuran. ");
INSERT INTO qveNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Hinaqtinmi chay sacerdotekunaqa, Judaspa nisqanta uyarispanku, anchata kusikuranku. Hinaspan Judasman qolqeta paganankupaq prometeranku. Chaymi Judasqa chay ratomantapacha huk oportunidadta mashkaran, imaynatas Jesusta traicionaspa paykunaman entregananpaq. ");
INSERT INTO qveNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pascua fiesta p'unchaw chayaramuqtinmi, primer kaq p'unchawta, huk corderota wañuchiranku chay Pascua fiestapi mikhunankupaq. Chaymi discipulonkunaqa Jesusta tapuranku: —¿Maypitaq munawaq kay Pascua fiestapi cenayta preparamunaykutarí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Hinaqtinmi Jesusqa ishkay discipulonkunata khaynata niran: —Jerusalén llaqtaman riychis. Chaypin huk runawan tupankichis p'uyñupi unu apashaqta. Hinaspan payta qatikunkichis. ");
INSERT INTO qveNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Chay runa huk wasiman haykuruqtinmi, chay wasiyoq runata tapunkichis: “Yachachikuqmi nin: ¿Mayqen cuartopitaq Pascua cenaytari discipuloykunawan cenasaq?” nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Hinaqtinmi payqa wasipa altosninpi huk hatun cuartota ña arreglasqataña rikuchisunkichis. Chay cuartopiyá qankunaqa cenayta preparamunkichis cenananchispaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Saynata Jesús niqtinmi, chay ishkaynin discipulonkunaqa Jerusalén llaqtaman rispanku, Jesuspa nisqanman hina chaypi tariranku. Hinaspan Pascua cenayta chaypi preparamuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Chay p'unchaw tutayaruqtinmi, Jesusqa chunka ishkayniyoq discipulonkunapiwan chay cuartoman riranku. ");
INSERT INTO qveNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Chaypi cenashaqtinkun Jesusqa discipulonkunata niran: —Traicionawaspa enemigoykunaman entregawaqniy runaqa, kaypin noqawan kushka cenashan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Hinaqtinmi Jesuspa discipulonkunaqa anchata llakirikuspanku, sapankamanku tapuranku: —¿Icha noqachu kashanipas? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Hinaqtinmi Jesusqa contestaspa niran: —Noqata traicionawaqniy runaqa qankunamanta hukniykichismi. Payqa kunanpunin t'antanta challpushan noqapa challpusqay platollapitaq. ");
INSERT INTO qveNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Bibliaqa cheqaqtapunin nin, noqa Diosmanta Hamuq Runaqa wañunaypunin. Ichaqa ¡ay imaynaraq kanqa traicionawaqniy runaqa! ¡Payqa aswanchá ama nacenmanpashchu karan! nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mikhushaqtinkun Jesusqa t'antata hap'iyuspa, Diosman graciasta qoran. Hinaspan partiyuspa discipulonkunaman haywaspa niran: —Chashkiychis. Kaymi cuerpoy, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Saynallataqmi huk vasotapas hap'iyuspa, Diosman graciasta qoran. Hinaspan discipulonkunaman haywayuspa, llapallanku tomaranku. ");
INSERT INTO qveNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Hinaspan niran: —Kaymi yawarniy. Kay yawarniywanmi huk mosoq pactota Dios qankunawan ruwan. Kay yawarniywanmi ashka runakunata huchankumanta salvasaq. ");
INSERT INTO qveNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Cheqaqtapunin niykichis, kunankamallañan uvasmanta ruwasqa vinotaqa qankunawan kushka tomashani. Ichaqa Diospa gobiernasqan sumaq glorianpiñan huk mosoq vinotaqa qankunawan kushka tomasaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Jesusqa discipulonkunapiwan kushka, huk himno takita takiruspankun, Olivos nisqa moqoman riranku. ");
INSERT INTO qveNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Hinaspan chayman chayaruspanku, Jesusqa discipulonkunata khaynata niran: —Kunan tutan llapallaykichispa iñiyniykichis pisiyanqa. Hinaqtinmi qankunaqa noqamanta p'enqakunkichis. Saynatan Biblia nishan: “Michiqta wañuchiqtinkun, ovejankuna ch'eqechisqa kanqa”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ichaqa wañusqaymanta kawsarimuspaymi, noqaqa qankunapa ñawpaqniykichista Galilea provincia lawman risaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Hinaqtinmi Pedroqa Jesusta niran: —Sichus llapallanku qanmanta p'enqakuspanku saqesunkiku chayqa, noqaqa manan qantaqa saqesqaykichu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Chaymi Jesusqa Pedrota niran: —Pedro, cheqaqtapunin niyki. Kunan tuta manaraq ishkaykama gallo waqamushaqtinmi, qanqa kinsa kutikama negawanki, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Hinaqtinmi Pedroqa Jesusta niran: —Sichus qanwan kushka wañunay kaqtinpas, noqaqa manan qantaqa negasqaykichu, nispa. Saynallatataqmi Jesuspa wakin discipulonkunapas niranku. ");
INSERT INTO qveNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jesusqa discipulonkunapiwan kushkan Getsemaní nisqa huertaman riranku. Chay lugarman chayaruspankun Jesusqa paykunata niran: —Qankunaqa kayllapi tiyashaychis, noqa orakamunaykama, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Saynata nispanmi Jesusqa, Pedrota, Jacobota, hinallataq Juantawan pusarikuran. Hinaspan Jesusqa anchata llakirikuspa, ");
INSERT INTO qveNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","chay kinsantin discipulonkunata khaynata niran: —Noqaqa wañunayta yachakuspaymi sonqoypi ancha llakisqa kashani. Qankunaqa kayllapiyá qepakuychis; aswanqa amayá puñunkichishchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Saynata nispanmi Jesusqa, tumpa ñawpaqninkuman rispa mañakuran, Dios Taytan munaqtinqa chay ñak'arinan hora ama chayamunanpaq. Hinaqtinmi chaypi qonqorikuran mat'inpas pampaman tupanankamaraq. ");
INSERT INTO qveNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Hinaspan Dios Taytanman orakuran khaynata: —Dios Taytáy, qanqa tukuy imatapas ruwanaykipaqmi atiyniyoq kanki. Noqaqa anchatan munayman kay ñak'ariykunamanta librawanaykitaqa. Ichaqa amayá noqapa munasqaychu ruwasqa kachun; aswanqa qanpa munasqaykiyá ruwasqa kachun, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Saynata Diosmanta orarukuspanmi, Jesusqa kinsantin discipulonkunapa kasqanman kutimuran. Hinaspan paykunataqa puñushaqta tariran. Chaymi Simón Pedrota niran: —Simón, ¡qanqa puñurapusqankitaq! ¿Manachu ni huk horallapas rikch'ayta atirankí? ");
INSERT INTO qveNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Amayá puñuychishchu. Aswanyá Diosmanta mañakuychis, kay prueba chayamuqtin ama tentasqa kanaykichispaq. Qankunaqa allinta ruwayta munashaspapas, manan kallpallaykichiswanqa ruwayta atiwaqchishchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Saynata nispanmi Jesusqa kaqmanta kutispa, Diosman orakuran imaynatan primer kaqpi orakuran saynallatataq. ");
INSERT INTO qveNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Hinaspan discipulonkunapa kasqanman kutimuspa, paykunataqa kaqmanta puñushaqta tariran, ancha pisipasqa kasqankurayku. Chaymi Jesusqa paykunata rikch'achiran. Ichaqa manataqmi paykunaqa ni ima niytapas atirankuchu. ");
INSERT INTO qveNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Hinaspan Jesusqa kinsa kaq kutita orakuq riran. Orakusqanmanta kutiramuspanmi, kinsantin discipulonkunata khaynata niran: —Qankunari, ¿kunankamachu puñullashankichisraq? Ama puñuychishñachu. Ñan horaqa chayaramunña, noqa Diosmanta Hamuq Runaqa, huchasapa runakunaman entregasqa kanaypaq. ");
INSERT INTO qveNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kunanqa hatariychis. Hinaspa hakuchi. Ñan kaytaña traicionawaqniy runaqa hamushan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesusqa discipulonkunawan rimallashaqtinraqmi, Judas Iscarioteqa paykunapa kasqankuman hamuran. Judasqa Jesuspa chunka ishkayniyoq discipulonkunamanta huknin kaqmi karan. Paywan kushkan ashka runakuna hamuranku, espadakunata, hinallataq k'aspikunata apayukuspanku. Chay runakunataqa mandamuranku, sacerdotekunapa jefenkuna, leykunata yachachiq runakuna, hinallataq Israel nación llaqtapi kamachiq runakunapiwanmi. ");
INSERT INTO qveNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jesusta traicionaq Judas Iscarioteqa, paywan hamuq runakunatan ña yachachimuranña khaynata: —Mayqentachus noqa much'aykusaq, paymi Jesusqa. Payta hap'ispaykichismi, allin watasqata apankichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Hinaspan Judas Iscarioteqa, Jesusman ashuyuspa rimayukuran khaynata: “Yachachikuq”, nispa. Hinaspan much'aykuran. ");
INSERT INTO qveNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Hinaqtinmi Judas Iscariotewan hamuq runakunaqa, Jesusta hap'ispanku presocharanku. ");
INSERT INTO qveNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Chaymi Jesuswan chaypi kaq huknin runaqa, espadanta orqospa, Judaswan hamuq huknin sirviente runapa ninrinta kuchurparan. Chay runaqa Israel nación llaqtapi sacerdotekunapa jefenpa serviqninmi karan. ");
INSERT INTO qveNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Hinaqtinmi Jesusqa Judaswan hamuq runakunata, khaynata tapuran: —Qankunari, ¿imanaqtintaq suwata hina hap'iwanaykichispaq espadakunantin, hinallataq k'aspikunantin ima hamushankichisrí? ");
INSERT INTO qveNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Sapa p'unchawmi noqaqa qankunawan kushka Jerusalén templopi yachachispa kasharani. Ichaqa manataqmi ni mayqenniykichispas chaypiqa presochawarankichishchu. Ichaqa kaykunaqa pasananpunin, saynapi Bibliapa nisqan cumplikunanpaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Hinaqtinmi Jesuspa discipulonkunaqa, Jesusta sapallanta saqespa, ayqekuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jesusta hap'iruspa apashaqtinkun, huk jovenpas sabanaswan p'istuyukuspa, Jesuspa qepanta qatikuran. Hinaqtinmi Jesusta apaq runakuna chay joventa hap'iruqtinku, ");
INSERT INTO qveNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","payqa chay p'istukusqan sabanasta saqespa, q'alalla ishkapakuran. ");
INSERT INTO qveNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jesustan apamuranku sacerdotekunapa jefenpa palacio wasinman. Chaypin huñunakuranku Israel nación llaqtapi sacerdotekunapa jefenkuna, Israel nación llaqtata kamachiq runakuna, hinallataq leykunata yachachiq runakunapiwan ima. ");
INSERT INTO qveNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Hinaqtinmi Jesusta apaqtinku, Pedroqa karu qepallankuta qatikuran, chay sacerdotekunapa jefenpa wasin punkupi patiokama. Hinaspan guardiakunawan kushka Pedroqa ninapa ladonpi tiyayuran q'oñikunanpaq. ");
INSERT INTO qveNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Hinaqtinmi sacerdotekunapa jefenkuna, hinallataq chaypi kaq wakin juzgaq runakunapiwan ima, Jesusta acusaspa wañuchinankupaq, paypa contranpi ima pruebatapas mashkaranku. Ichaqa manataqmi ni ima pruebatapas tarirankuchu. ");
INSERT INTO qveNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Hinaspan ashka falso testigokuna Jesuspa contranpi llullakuspa rimanankupaq hamuranku. Ichaqa manataqmi chay falso testigokunaqa hukllatachu rimaranku. ");
INSERT INTO qveNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Hinaspan chaypi kaq wakin runakunaqa, Jesuspa contranpi llullakuspa, rimaranku khaynata: ");
INSERT INTO qveNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Paymi niran: “Noqaqa kay Jerusalén llaqtapi templota thuñirachispaymi, kinsa p'unchawllapi huk mosoq templota hatarichisaq, saynapin chay mosoq temploqa mana runakunapa ruwasqanchu kanqa”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ichaqa manataqmi chay acusaq runakunaqa hukllatachu rimaranku. ");
INSERT INTO qveNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Chaymi sacerdotekunapa jefenqa sayariyuspa, llapallan runakunapa ñawpaqninpi, Jesusta tapuran: —¿Uyarishankichu kay acusasuqniyki runakunapa nisqanta? Qanri, ¿manachu ima nispallapas defiendekunkí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ichaqa Jesusqa manan ni ima nispapas contestaranchu. Aswanmi upallalla karan. Hinaqtinmi sacerdotekunapa jefenqa, kaqmanta tapuran: —¿Qanchu alabasqayku Diospa Wawan Salvador Cristori kankí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Chaymi Jesusqa contestaspa niran: —Arí, noqan kani. Qankunaqa noqa Diosmanta Hamuq Runatan, hanaq pachapi Papaypa phaña ladonpi tiyashaqta rikuwankichis. Hinaspapas qankunaqa cielomanta phuyuq chawpinta ancha atiyniyoq hamushaqtan rikuwankichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Hinaqtinmi sacerdotekunapa jefenqa, Jesuspa nisqanta uyarispa, anchata phiñakuran. Chaymi p'achankunataraq llik'ikuspa, khaynata niran: —¿Imapaqñataq munanchis huk testigokunatawanrí? ");
INSERT INTO qveNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kunanmi uyarishankichis pay kikinpuni Diospa contranpi rimasqantaqa. Chayri, ¿ima ninkichistaq qankunarí? nispa. Chaymi chaypi kaq llapallan runakunaqa, Jesusta wañunanpaq sentenciaranku. ");
INSERT INTO qveNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Hinaspan wakin runakunaqa, Jesusman ashuyuspanku toqayuranku; ñawintapas vendaspankun saqmaranku. Hinaspan khaynata niranku: —¿Pitaq saqmamushasunkirí? ¡Cheqaq profeta kaspaykiqa niwayku! nispanku. Chaymantan Jesustaqa Jerusalén templota cuidaq guardiakunaman entregaranku. Hinaqtinmi paykunapas, Jesustaqa saqmapiyaspa chashkiranku. ");
INSERT INTO qveNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedroqa palacio wasipa hawa pationpin tiyasharan. Hinaqtinmi Pedropa kasqanman huk sirvienta warmi hamuran. Payqa sacerdotekunapa jefenta serviq warmin karan. ");
INSERT INTO qveNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Hinaspan chay warmiqa, Pedrota ninaq ladonpi q'oñikuqta rikuruspa niran: —Qanpas chay Nazaret llaqtamanta Jesuswan kushka puriqmi kashanki, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Hinaqtinmi Pedroqa contestaspa niran: —Chay Jesustaqa manan reqsinichu. Qanqa, ¡imamantachá rimapayawashankipas! nispa. Saynata nispanmi Pedroqa chay patiomanta hawaman lloqsiran. {Hinaqtinmi chay ratopi gallo waqamuran}. ");
INSERT INTO qveNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tumpa unayninmanmi kaqmanta chay sirvienta warmiqa, Pedrota yapamanta rikuspa, chaypi kaq runakunata niran: —Kay runaqa Jesuswan kushka puriqmi, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Hinaqtinmi Pedroqa yapamanta contestaspa niran: —Chay runataqa manan reqsinichu, nispa. Ichaqa tumpa unayninmanmi, chaypi kaq wakin runakunapas Pedrota nillarankutaq khaynata: —Qanqa cheqaqtapunin chay Jesuspa qatikuqnin kashanki. Hinaspapas qanqa Galilea provincia lawmantan kanki. Chaymi rimasqaykipas alayrilla kashan paykunapa rimasqan hina, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Chaymi Pedroqa Diospa sutinpi juramentota ruwaspa niran: —¡Ñan niykichishña! ¡Chay runataqa manan noqaqa reqsinichu! ¡Sichus llullakushani chayqa, Diosyá castigawachun! nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Hinaqtinmi chay ratopi ishkay kaq kutita gallo waqaramuqtin, Pedroqa yuyariran Jesuspa khayna nisqanta: “Manaraq ishkay kutita gallo waqamushaqtinmi, qanqa kinsa kutikama negawanki”, nispa nisqanta. Chaymi Pedroqa llakikuymanta anchata waqaran. ");
INSERT INTO qveNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Achiqaramuqtinmi sacerdotekunapa jefenkuna, Israel nación llaqtapi kamachiq runakuna, leykunata yachachiq runakuna, hinallataq wakin juzgaqkunapiwan ima, huñunakuyta tukuruspanku, Jesusta alli-allinta makinta wataspa aparanku. Hinaspan paykunaqa Roma llaqtayoq gobernador Poncio Pilatoman entregaranku. ");
INSERT INTO qveNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Chaymi chay gobernador Poncio Pilatoqa Jesusta tapuran: —¿Qanchu kanki Israel nacionniyoq runakunapa reynin? nispa. Hinaqtinmi Jesusqa contestaspa niran: —Qanpunin saynataqa nishanki, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Chaymi sacerdotekunapa jefenkunaqa, Jesusta tukuy imaymananmanta acusaranku. ");
INSERT INTO qveNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Saynata acusaqtinkun, Poncio Pilatoqa Jesusta huktawan tapuran: —Qanpa contraykipi acusaspa kay runakunapa imaymana rimasqantari ¿uyarishankichú? Chayri, ¿manachu ni imallatapas rimarinki defiendekunaykipaq? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ichaqa manan ni ima nispapas Jesusqa contestaranchu. Chaymi Poncio Pilatoqa anchata admirakuran. ");
INSERT INTO qveNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Gobernador Poncio Pilatoqa sapa watanmi Pascua fiestapi huk presota carcelmanta kachariyta yacharan. Chay presotaqa kachariran, llaqtapi runakuna mañakusqanman hinan. ");
INSERT INTO qveNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Chay tiempopin Barrabás sutiyoq runa, wakin criminal runakunapiwan kushka carcelpi preso kasharan. Paykunan rey Cesarpa contranpi ch'aqwata ruwaspanku, runakunata wañuchiranku. ");
INSERT INTO qveNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Hinaqtinmi llaqtapi runakunaqa Poncio Pilatopa kasqanman riranku. Hinaspan gobernador Poncio Pilatota niranku, costumbrenman hina huk runata carcelmanta kacharipunanpaq. ");
INSERT INTO qveNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Chaymi Poncio Pilatoqa llapallan chaypi kaq runakunata tapuran khaynata: —Qankunari, ¿munankichishchu kay Israel nación llaqtapa reyninta kacharipunayta? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Saynataqa tapuran, sacerdotekunapa jefenkuna Jesusta envidiakuspallanku acusasqankuta yachaspanmi. ");
INSERT INTO qveNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ichaqa chaypi kaq sacerdotekunapa jefenkunañataqmi, runakunata exigispa yachachiranku, paykuna “Runa wañuchiq Barrabasta kacharipuy”, nispa, Poncio Pilatota exiginankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Hinaqtinmi Poncio Pilatoqa yapamanta runakunata tapuran: —Chayri, ¿imatataq ruwanayta munankichis kay “Israel nación llaqtapa reynin” nisqaykichis Jesuswanrí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Chaymi runakunaqa altota qaparispanku, huk simillapi khaynata niranku: —¡Cruzpi wañunanpaq chakatachiy! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Hinaqtinmi Poncio Pilatoqa contestaspa niran: —Saynaqa niwaychisyá, ¿ima mana allintataq kay runari ruwaruran? nispa. Hinaqtinmi chaypi kaq runakunaqa aswan más altota qaparispa, yapamanta niranku: —¡Cruzpi wañunanpaq chakatachiy! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Chaymi Poncio Pilatoqa llapallan runakunawan allinpi kayta munaspa, chay runa wañuchiq Barrabasta carcelmanta kacharichimuran. Hinaspan Jesusta alli-allinta latigarachispa, soldadonkunaman entregaran, cruzpi chakataspa clavamunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Hinaqtinmi Poncio Pilatopa soldadonkunaqa, cuartelpa pationman Jesusta aparanku. Hinaspan chayman wakin tropa soldadokunatawan waqyamuspanku, ");
INSERT INTO qveNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Jesusman huk nina sansa hina puka color capawan churaranku. Hinaspan kishkamanta ruwasqa coronawan umanmanpas churaranku. ");
INSERT INTO qveNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Saynata p'acharachispankun, chay soldadokunaqa asipayaranku. Hinaspan burlakuspa khaynata niranku: —¡Kawsachun Israel nacionniyoq runakunapa reynin! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Saynata nispankun, chay soldadokunaqa Jesusta umanpi p'anaranku k'aspikunawan; hinaspan toqaykuranku ima. Jesuspa ñawpaqninpi qonqorikuspankutaqmi, chansakuspanku adoraq tukuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Hinaspan burlakuyta tukuruspanku, chay puka capawan p'achachisqankuta ch'ustispa, kaq p'achallanwantaq churapuranku. Hinaspan Jesusta cruzpi chakataspa clavamunankupaq aparanku. ");
INSERT INTO qveNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","(Poncio Pilatopa soldadonkunan Jesusta apasharanku, cruzpi chakatamunankupaq). Hinaqtinmi Cirene llaqtayoq Simón sutiyoq runawan ñan risqankupi tuparanku. Payqa Alejandropa hinallataq Rufopa papanmi karan. Paytan campomanta kutimushaqtin, soldadokuna obligaranku Jesuspa apasqan cruzta wikriysinanpaq. ");
INSERT INTO qveNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Saynatan Gólgota nisqa moqoman Jesustaqa aparanku. Chay Gólgota moqoqa rimayninkupiqa “Calavera moqo”, ninantan nin. ");
INSERT INTO qveNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Hinaspan Jesuspa nanayninkuna thañinanpaq, qatqe qorakunawan chapusqa vinota tomananpaq qoranku. Ichaqa manan Jesusqa tomayta munaranchu. ");
INSERT INTO qveNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Chaymantan Jesustaqa cruzpi chakataranku. Hinaspan chay soldadokunaqa Jesuspa p'achanta rakinakunankupaq sortearanku. ");
INSERT INTO qveNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jesusta cruzman chakatasqanku horaqa, esqon horas alto intiñan karan. ");
INSERT INTO qveNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Saynallataqmi chay soldadokunaqa, Jesusta chakatasqanku cruzpa umanman huk letrerota churaranku, khayna niqta: “kay runan israel nacionniyoq runakunapa reynin” nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Hinallataqmi ishkay suwakunatapas chakatallarankutaq, hukninta Jesuspa phaña ladonpi, huknintataq lloq'e ladonpi. { ");
INSERT INTO qveNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Saynapin cumplikuran Bibliapi khayna nisqan: “Huchasapa runakunawanmi yupasqa karan”, nispa.} ");
INSERT INTO qveNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Saynallataqmi chayninta pasaq runakunapas, umankuta maywirisparaq, Jesusta k'amiranku khaynata: —¡Yaw! Qanqa nirankitaq: “Kay Jerusalén llaqtapi templota thuñirachispaymi, noqaqa kinsa p'unchawllapi hatarirachiyman”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡Sichus ancha atiyniyoq kaspaykiqa, kikiykita salvakuspayá, chay cruzmanta urayamuy! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Saynallataqmi sacerdotekunapa jefenkunapas, hinallataq leykunata yachachiq runakunapas, Jesusmanta burlakuspanku khaynata ninakuranku: —Kay runaqa, hukkunataqa salvaranmi. Ichaqa kikintataqmi mana salvakuyta atinchu. ");
INSERT INTO qveNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Hinaspapas payqa niranmi: “Noqaqa Diosmanta Hamuq Salvadormi kani, hinallataq kay Israel nación llaqtapa reynin ima”, nispa. Saynaqa ¡noqanchispas paypi creenanchispaqyá, chay cruzmanta urayamuchun! nispanku. Saynallataqmi paywan kushka cruzpi chakatasqa suwakunapas, Jesustaqa k'amillarankutaq. ");
INSERT INTO qveNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Jesuspa wañusqan p'unchawmi, kay pachaqa tutayaran chawpi p'unchawmantapacha asta kinsa horas tardekama. ");
INSERT INTO qveNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Hinaqtinmi chay kinsa horas tardeykuyta, Jesusqa altota qaparispa, rimasqan idiomanpi khaynata niran: —Eloi, Eloi, ¿lama sabactani? nispa. Kay rimayqa khayna ninanmi: “¡Diosnilláy, Diosnilláy! ¿Imanaqtintaq sapallaytari saqerullawankí?” nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ichaqa chaypi kaq wakin runakunaqa Jesuspa nisqantaqa manan entienderankuchu. Chaymi khaynata niranku: —Uyariychis, payqa Diosmanta willakuq ñawpaq profeta Eliastan waqyakushan, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Saynata nispanmi chaypi kaq huknin runaqa, huk largo soqos k'aspipa puntanman apurayllamanña esponjata wataran. Hinaspan chay esponjata qatqe vinoman challpuspa, Jesuspa siminman aypachiran ch'unqananpaq. (Saynataqa aypachiran ch'akichikusqanraykun). Hinaspan khaynata niran: —Kunanyá qawasunchis, cheqaqtachus Elías hamuspa kay cruzmanta urayachinqa, icha manachus, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Chay ratopin Jesusqa altota qaparispa wañuran. ");
INSERT INTO qveNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Hinaqtinmi chay ratollapitaq, Jerusalén templo ukhupi rakiq ratk'a cortinapas, altomanta urayman llik'ikuran. ");
INSERT INTO qveNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jesusta cruzpi chakatasqankupa ñawpaqninpin soldadokunapa jefen kasharan. Paymi Jesuspa {qaparisqanta, hinallataq} wañusqantawan rikuran. Hinaspan khaynata niran: —¡Cheqaqtapunin kay runaqa Diospa Wawan kasqa! nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Chaypin ashka warmikunapas karullamanta qawaspa kasharanku. Paykunawan kushkan kasharanku María Magdalena, Salomé, Joseypa hinallataq sullk'a kaq Jacobopa mamitan Mariapiwan. ");
INSERT INTO qveNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Paykunan ñawpaqtaqa Galilea provincia law llaqtakunapi, Jesusta yanapaspa kushka puriranku. Hinallataqmi ñawpaqtaqa huk warmikunapas Jerusalén llaqtaman Jesuswan kushka hamullarankutaq. Nota: María Magdalena nispaqa niranku, Magdala sutiyoq llaqtamanta kasqanraykun. ");
INSERT INTO qveNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Jesuspa wañusqan p'unchawqa viernesmi karan. Chay tardetan Israel nación llaqtayoq runakunaqa sábado p'unchawpi samanankupaq alistakusharanku. ");
INSERT INTO qveNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Hinaqtinmi Arimatea llaqtamanta José sutiyoq runaqa, Poncio Pilatopa kasqanman mana manchakuspa riran. Hinaspan Jesuspa cuerponta, cruzmanta urayachispa p'ampamunanpaq mañamuran. Joseyqa Israel nacionpi kamachiq jefekunapa hukninmi karan. Hinaspapas payqa allin respetasqa runan karan. Paypas Diospa gobiernanan p'unchawtan suyasharan. ");
INSERT INTO qveNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Poncio Pilatoqa Jesuspa ratolla wañusqanmanta uyarispanmi, anchata admirakuran. Chaymi cheqaqchus wañusqaña kasqanta yachananpaq, soldadokunapa jefenta waqyachimuspa, tapuran. ");
INSERT INTO qveNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Hinaqtinmi chay soldadokunapa jefen, Jesuspa wañusqanmanta willaqtin, Poncio Pilatoqa Arimatea llaqtayoq Joseyman Jesuspa cuerponta p'ampamunanpaq permisota qoran. ");
INSERT INTO qveNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Chaymi Joseyqa Jesuspa cuerponta cruzmanta urayachispa, huk sumaq fino sábanas rantimusqanwan p'istuykuran. Hinaspan huk hatun qaqa sikipi sepultura ruwasqa t'oqoman, Jesuspa cuerponta aparan. Hinaspan chaypi churaran. Chaymantan chay sepulturaman haykuna punkunta, huk hatun rumiwan taparan. ");
INSERT INTO qveNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Chaypin kasharanku qawaspa, María Magdalena, hinallataq Joseypa mamitan Mariapiwan. Paykunan rikuranku Jesuspa cuerponta mayman churasqankuta. ");
INSERT INTO qveNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Samana p'unchaw pasarullaqtinmi, María Magdalena, Jacobopa mamitan María, hinallataq Salomeypiwan ima, mishk'i q'apaq perfumekunata rantiranku, chaywan Jesuspa cuerponta sepultura ukhupi llusimunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Hinaspan paykunaqa domingo p'unchaw achiqayllata, chayraq inti lloqsiramushaqtin, Jesuspa cuerpon p'ampasqanku sepulturaman riranku. ");
INSERT INTO qveNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Rishaspankutaqmi chay warmikunaqa khaynata ninakuranku: —Kunanri, ¿pitaq sepulturapa punkunpi hatun rumitari tanqarirapuwasunchís? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ichaqa sepulturapa punkunman chayaruspankutaqmi, chay hatun tapasqanku rumitaqa, huk lawman kuyuchisqataña tariranku. ");
INSERT INTO qveNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Hinaspan paykunaqa chay sepultura ukhuman haykuspanku, huk joventa rikuranku, Jesuspa cuerpon churasqankupa phaña ladonpi tiyashaqta. Chay jovenqa pampakama hatun yuraq p'achayoqmi karan. Chayta rikuspankun, paykunaqa anchata mancharikuranku. ");
INSERT INTO qveNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Hinaqtinmi chay jovenqa khaynata niran: —Ama mancharikuychishchu. Qankunaqa cruzpi wañuq Nazaret llaqtayoq Jesuspa cuerpontan mashkashankichis. Payqa manan kaypiñachu. Qawariychis cuerpon churasqanku lugarqa illaqllañan kashan. Payqa ñan kawsarirunña. ");
INSERT INTO qveNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kunanqa rispaykichis, Jesuspa discipulonkunaman, hinallataq Pedromanwan ima kay nisqayta willamuychis. Jesusqa Galilea provincia lawmanmi ñawpaqniykichista rishan. Chaypin tupankichis paywanqa, imaynan manaraq wañushaspa nisusqaykichisman hina, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Hinaqtinmi chay warmikunaqa mancharikuymanta khatatataspa, chay sepultura ukhumanta lloqsimuspanku ayqekuranku. Ichaqa ñan risqankupiqa chaykuna rikusqankumantaqa paykunaqa manan ni pimanpas willarankuchu, ancha mancharisqa kasqankurayku. { ");
INSERT INTO qveNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesusqa domingo p'unchawtan kawsarimuran. Hinaspan primerta María Magdalenaman rikhuriran. Paymantan Jesusqa qanchis demoniokunata ñawpaqtaraq qarqoran. ");
INSERT INTO qveNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","María Magdalenaqa Jesuspa discipulonkunapa kasqanmanmi riran. Hinaspan paykunataqa tariran ancha llakikuymanta waqashaqta. Hinaspan paykunaman Jesuspa kawsarirusqanmanta willaran. ");
INSERT INTO qveNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ichaqa, “Jesusqa kawsashanmi” niqtinpas, hinallataq “rikumunin” niqtinpas, Jesuspa discipulonkunaqa Mariapa willakusqantaqa manan creerankuchu. ");
INSERT INTO qveNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Chaymantan Jesusqa ishkay discipulonkunamanpas ñanninta campoman rishaqtinku rikhuriykuran. (Ichaqa qallariyninpiqa paykunaqa manan reqsirankuchu, hukniraqña kasqanrayku. Chaymantan ichaqa reqsiranku). ");
INSERT INTO qveNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Chaymi paykunaqa kutimuspanku, wakin discipulokunaman chaykunamanta willaranku. Ichaqa chay willakusqankuta uyarishaspankupas, wakin discipulokunaqa manan creerankuchu. ");
INSERT INTO qveNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Jesuspa chunka hukniyoq discipulonkunaqa mesapin mikhusharanku. Hinaqtinmi Jesusqa paykunaman rikhuriran. Hinaspan paykunata q'aqcharan, rumi sonqo kasqankumanta, hinallataq kawsarimusqanmanta willashaqtinkupas, mana creesqankurayku. ");
INSERT INTO qveNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Hinaspan Jesusqa discipulonkunata kamachiran khaynata: —Qankunaqa kay enteron mundontinman riychis. Hinaspan kay allin willakuykunata llapallan runakunaman willamuychis. ");
INSERT INTO qveNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Pipas salvasqa kananpaqqa noqapin creenan. Hinaspan bautizachikunan. Ichaqa noqapi mana creeq runaqa, castigasqan kanqa. ");
INSERT INTO qveNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Noqapi creeqkunan kay señalkunata ruwanqaku: sutiypin runakunamanta demoniokunata qarqonqaku; mana yachasqanku rimaykunatan rimanqaku; ");
INSERT INTO qveNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","mach'aqwaykunatan hap'inqaku, ima venenotaña tomanqaku chaypas, manan wañunqakuchu; hinallataqmi onqosqa runakunaman makinkuta churaqtinkupas, chay onqoyninkumanta sanoyanqaku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jesusqa discipulonkunaman yachachiyta tukuruspanmi, hanaq pacha cieloman ripuran. Chaypin Jesusqa Dios Taytanpa phaña ladonpi tiyayuran. ");
INSERT INTO qveNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jesuspa discipulonkunañataqmi tukuy lawman rispanku, Diospa palabranmanta llapallan runakunaman willaranku. Hinaqtinmi Jesusqa paykunata yanaparan, tukuy señalkunata hinallataq tukuy milagrokunata ruwanankupaq. Saynapin llapallan runakunaqa yacharanku, Jesuspa discipulonkunapa willakusqankuqa, cheqaqpuni kasqanta. Amén.}");
INSERT INTO qveNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ancha respetasqay Teófilo, ñan ashka runakunaña atisqankuman hina escribiranku noqanchis ukhupi tukuy imakuna cheqaqtapuni pasasqanmantaqa. ");
INSERT INTO qveNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Chay escribisqankuqa iguallan karan qallariyninmantapacha Jesucristowan kushka puriq discipulokunapa willakusqankuman hina. Chay discipulonkunatan kikin Jesucristo comisionaran Diosmanta willakamunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Saynallataqmi noqapas ancha respetasqay Teófilo, kikiypuni Diospa tukuy imakuna ruwasqanmanta alli-allinta tapukachakuspa averiguarani, allinta yachanaypaq. Saynapin qallariyninmantapacha asta tukukuyninkama, Señor Jesucristomanta willakuykunaqa cheqaqpuni kasqanta yacharani. Chayraykun kunan chay allin willakuykunata ordenninpi qanmanpas escribimuyki, ");
INSERT INTO qveNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","saynapi Señor Jesucristomanta yachasqaykita astawanraq cheqaqpuni kasqanta allinta yachanaykipaq. ");
INSERT INTO qveNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Huk sacerdoten karan Zacarías sutiyoq Jerusalén templopi. Warminpa sutintaqmi karan Elísabet; paypas ñawpaq sacerdote Aaronpa mirayninmantan karan. Zacariasmi kawsaran rey Herodes Judea provinciapi gobiernashaqtin. (Kay Herodestan reqsiranku Hatun kaq Herodes sutiwan). Chay p'unchawkunapin ñawpaq sacerdote Abiaspa mirayninmanta kaq sacerdotekunaman turno tuparan, Diosta templopi servinankupaq. (Chaymi sacerdote Zacariasqa Diosta templopi serviran). ");
INSERT INTO qveNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacariasqa warmin Elisabetpiwanmi Diospa ñawpaqninpiqa justo runakuna karanku. Diospa kamachisqankunatapas llapallantan kasukuranku. Chaymi paykunapa contranpiqa mana ni pipas maltaqa rimarankuchu. ");
INSERT INTO qveNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Paykunaqa wawayoq kaytaqa manan atirankuchu, warmin Elísabet qolluri kasqanrayku; hinaspapas ishkayninkutaqmi sinchi machu payaña karanku. ");
INSERT INTO qveNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Huk p'unchawmi Zacariaspa gruponman turno tuparan Diosta templopi servinankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Chaymi sacerdotekunapa costumbrenkuman hina sortearanku. Hinaspan Zacariasman tuparan incienso q'oshñichiy Diospa templon ukhupi. ");
INSERT INTO qveNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Chaymi Zacariasqa Diospa templonman haykuran inciensota q'oshñichinanpaq. Chay horasllapitaqmi llapallan chaypi kaq runakunaqa hawapi qepakuranku Diosmanta mañakuspanku. ");
INSERT INTO qveNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Hinaspan chay ratopi Zacariasman qonqayllamanta rikhuriran Diospa angelnin, incienso q'oshñichina altarpa phaña ladonpi sayashaq. ");
INSERT INTO qveNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Chaymi Zacariasqa chay angelta rikuspa nishuta mancharikuran. Hinaspan mana ni imatapas ruwayta atiranchu. ");
INSERT INTO qveNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Angelñataqmi Zacariasta niran: —¡Zacarías, ama mancharikuychu! Diosmi mañakusqaykita uyarin. Warmiyki Elisabetmi qari wawata onqokunqa. Paymanmi sutinta churanki Juanwan. ");
INSERT INTO qveNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Chaymi qanqa ancha-anchata kusikunki. Saynallataqmi ashka runakunapas kusikunqaku wawaykipa nacesqanwan. ");
INSERT INTO qveNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Diosmi chay wawaykita yanapanqa, ancha atiyniyoq kananpaq. Payqa manan vinotapas nitaq ni ima mach'anapaq tomanakunatapas tomanqachu. Diospa Santo Espiritunwanmi hunt'asqa kanqa mamanpa wiksanpi kasqanmantapacha. ");
INSERT INTO qveNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Paymi Israel nación llaqtapi runakunata yachachinqa, huchankuta saqespanku, Diosta kasukuspa kawsanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Diosmanta Hamuq Salvasuqniykichis manaraq hamushaqtinmi, Juanqa hamunqa. Payqa Diosmanta ñawpaq willakuq profeta Elías hinan ancha atiyniyoq kanqa. Hinaspapas yachachisqanta uyarispankun tayta mamakunapas wawankuwan allinpanqaku. Saynallataqmi Diosta mana kasukuq runakunapas yachanqaku huchayoq kasqankuta; hinaspan Diosman kutirikunqaku. Saynallataqmi payqa runakunata yachachinqa, Diosmanta Hamuq Salvasuqniykichista allinta runakuna chashkinankupaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Chaykunata uyarispanmi, Zacariasqa chay angelta tapuran: —Noqaykuqa nishu machu payañan kayku. ¿Imaynataq yachayman niwasqaykiqa cheqaqpuni kasqantarí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Chaymi angelqa contestaran: —Noqapa sutiyqa Gabrielmi. Diospa ñawpaqninpi serviq angelmi kani. Pay kikinmi noqata mandamuwaran, kay allin willakuyta qanman willanaypaq. ");
INSERT INTO qveNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ichaqa kay willasqayta mana creesqaykiraykun, kunanmantapacha rimayta mana atinkichu, kay nisqaykuna cumplikunan p'unchawkama, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Dios yupaychana templo ukhupi Zacarías nishuta demoramuqtinmi, hawapi suyaq runakunaqa tapunakuranku: —¿Imataq pasarun, chaytaq mana lloqsimunchurí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Hinaqtinmi Zacariasqa templo ukhumanta lloqsimuspan rimayta mana atiranchu. Chaymi makinwan señaschaspalla runakunaman entiendechiran. Chayta rikuspankun runakunaqa ninakuranku: —Ima visiontachá payqa templo ukhupi rikuramun. Chaychá rimaytaqa mana atinchu, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Templopi servinan p'unchawkuna tukurukuqtinmi, Zacariasqa wasinman kutipuran. ");
INSERT INTO qveNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Hinaspan chay p'unchawkuna pasaruqtin, warmin Elisabetqa onqoq rikhuriran Zacariaspa wawanta. Chaymi Elisabetqa wasinmanta pishqa killa hunt'a mana lloqsiranchu. Sonqonpitaqmi khaynata piensaran: ");
INSERT INTO qveNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Diosmi onqokuq kanayta munan. Chaymi runakunamantaqa manaña p'enqakusaqchu, kunanqa wawayoqña kasqayrayku”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elísabet soqta killaña onqoq kashaqtinmi, Diosqa ángel Gabrielta mandamuran provincia Galilea ukhupi Nazaret llaqtaman. ");
INSERT INTO qveNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Chay angelqa huk willakuytan apamuran Nazaret llaqtapi tiyaq María sutiyoq sipasman. Mariaqa casarakunanpaqmi Joseywan comprometesqaña karan. Joseyñataqmi karan ñawpaq kamachiq rey Davidpa karu familianmanta. Mariaqa comprometesqaña kashaspanpas, manaraqmi ni hayk'aqpas qariwanqa puñuranchu. ");
INSERT INTO qveNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Hinaqtinmi ángel Gabrielqa Mariapa kasqanman haykuspa, khaynata rimayukuran: —¡Kusikuy! ¡Diosmi anchata bendecisunki! ¡Paymi qanwan kashan! nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mariaqa angelpa rimayukusqanta uyarispanmi, anchata admirakuspa sonqollanpi yuyaymanaran: “¿Imatataq kay rimayukuywanri niwayta munan?”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Hinaqtinmi angelqa khaynata niran: —María, ama mancharikuychu. Diospa akllasqanmi kanki. ");
INSERT INTO qveNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kunanmi qan onqoq rikhurinki; hinaspan huk qari wawata onqokunki. Paymanmi sutinta churanki Jesuswan. ");
INSERT INTO qveNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Chay wawaykin ancha allin reqsisqa kanqa. Hinaqtinmi paymantaqa ashka runakuna khaynata rimanqaku: “Tukuy atiyniyoq Diospa Wawanmi payqa”, nispanku. Paytaqa Diospunin churanqa hatun kamachikuq rey kananpaq, ñawpaq rey Davidta hina. ");
INSERT INTO qveNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Hinaspan Jacobpa mirayninkunata wiñaypaq gobiernanqa; saynapin chay gobiernasqanqa mana ni hayk'aqpas tukukunqachu, nispa. Nota: Jacobpa mirayninqa Israel nacionniyoq runakunan. ");
INSERT INTO qveNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Chaykunata uyarispanmi Mariaqa angelta tapuran: —Manaraq ni hayk'aqpas qariwan puñushaspayri ¿imaynataq wawayoqri kayman? nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Chaymi angelqa contestaran: —Diospa Santo Espiritunmi qanman urayamunqa; hinaspan Diospuni atiyninwan llantuykusunki onqoq kanaykipaq. Chayraykun chay wawaqa mana ni ima huchayoq nacenqa. Hinaqtinmi paytaqa ninqaku “Diospa Wawanmi”, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Saynallataqmi familiayki Elisabetpas, yuyaqña kashaspapas, soqta killa onqoqña kashan, runakunapas “qollurin chay warmiqa” nishaqtinku. ");
INSERT INTO qveNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Diospaqqa manan ni imapas sasaqa kanchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Chaymi Mariaqa khaynata niran: —Noqaqa Diosta servikuqllan kani. Paypa munayninyá niwasqaykiman hina ruwasqa kachun noqapi, nispa. Hinaqtinmi María rimayta tukuruqtin hinalla, angelqa ripuran. ");
INSERT INTO qveNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Chay p'unchawkunapin Mariaqa apurayllamanña alistakuspa, Elisabetpa tiyasqan llaqtaman riran. Chay llaqtaqa Judea provincia lawpin karan, huk orqokunaq chawpinpi. ");
INSERT INTO qveNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Mariaqa chay llaqtaman chayaruspanmi, Zacariaspa wasinman haykuspa, Elisabetta rimayukuran. ");
INSERT INTO qveNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Hinaqtinmi Mariapa rimayukusqanta Elísabet uyariqtin, Elisabetpa wiksanpi wawaqa kusikuymanta kuyukachariran. Diospa Santo Espirituntaqmi Elisabetman hunt'ayuran. ");
INSERT INTO qveNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Chaymi Elisabetqa altota rimarispa, khaynata niran: —¡María, Diosmi qanta bendecisunki llapallan warmikunamantapas aswan mastaraq! Saynallataqmi nacemuq wawaykitapas anchata bendecinqa. ");
INSERT INTO qveNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Pitaq noqari kani, Salvaqniypa mamitan watukamuwanaykipaqrí? ");
INSERT INTO qveNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Rimayakamuwaqtiykin wiksaypi waway kusikuymanta kuyukacharin. ");
INSERT INTO qveNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","¡Ancha kusisqan kanki Diospa nisqanta creesqaykirayku! ¡Diospa nisqankunaqa cumplikunqapunin! nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Chaykunata uyarispanmi Mariaqa, kusikuymanta Diosta alabaran khaynata: “¡Diosmanmi graciasta qoni tukuy sonqoymanta! ");
INSERT INTO qveNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","¡Anchatan kusikuni, Salvaqniy kasqanrayku! ");
INSERT INTO qveNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Diosmi akllaykuwan kay serviqnin humilde warmita, mana importante kashaqtiypas. Kunanmantaqa llapallan runakunan hinallataq mirayninkunapas ninqaku: ‘¡Mariaqa ancha kusisqan kashan, Diospa bendecisqanrayku!’ nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tukuy atiyniyoq Diosmi noqapi admirakuypaq hatun milagrokunata ruwaspa anchata yanapaykuwan. ¡Payqa Ch'uya Diosmi! ");
INSERT INTO qveNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Payqa wiña-wiñaypaqmi munakunqa payta respetaspa adoraqkunataqa. ");
INSERT INTO qveNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Diosqa tukuy atiyninwanmi tukuy imatapas ruwaran. Pay tukuq runakunapa piensasqankuman hina, ima ruway munasqankutapas, mana imamanmi tukuchin. ");
INSERT INTO qveNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kay pachapi kamachiqkunatan wikch'un kamachisqanmanta. Kamachiqkunapa mana reparasqan runakunatan ichaqa kikin Diospuni hatunchan. ");
INSERT INTO qveNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Yarqaypi kawsaqkunamanmi tukuy imata qon. Qapaq runakunatataqmi mana imayoqta qarqon. ");
INSERT INTO qveNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Israel nacionniyoq runakunatan serviqnin kasqanrayku yanapan. Manan ni hayk'aqpas Diospa khuyakuyninqa kay Israel nación llaqtanpaqqa tukukunqachu. ");
INSERT INTO qveNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Saynatan wiñaypaq prometeran ñawpaq taytanchiskunaman, Abrahamman, hinallataq llapallan mirayninkunamanpas”, nispa. Saynatan Mariaqa Diosta alabaran. ");
INSERT INTO qveNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Hinaspan Mariaqa kinsa killa hunt'a Elisabetpa wasinpi qepakuran. Chaymantañan wasinman kutipuran. ");
INSERT INTO qveNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabetpa onqokunan tiempo chayaramuqtinmi, payqa qari wawata onqokuran. ");
INSERT INTO qveNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Chaymi familiankunapas hinallataq vecinonkunapas Elisabetpa onqokusqanta yachaspanku, wasinman riranku. Hinaspan paywan kushka anchata kusikuranku, Dios khuyapayasqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Elisabetpa wawan pusaq p'unchawniyoq kashaqtinmi, chay wawata aparanku circuncisión costumbre ruwanankupaq. Chay circuncisión costumbreta ruwaruqtinkun, runakunaqa wawaman sutinta churayta munaranku papanpa sutin Zacariaswan, costumbrenkuman hina. ");
INSERT INTO qveNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Chayta uyarispanmi Elisabetqa paykunata niran: —¡Manan! Wawaypa sutinqa Juanmi kanqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Chaypi kaq runakunañataqmi Elisabetta tapuranku: —¿Imanaqtintaq chay sutitari churayta munankí? Manan ni mayqen familiaykipas sayna sutiyoqqa kanchu, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Chaymi chay runakunaqa señasllawan Zacariasta tapuranku: “Wawaykipa sutinri, ¿imataq kanqa?” nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Hinaqtinmi Zacariasqa escribina tablachata mañakuspa, chaypi escribiran khaynata: “Wawaypa sutinqa Juanmi kanqa”, nispa. Chayta rikuspankun llapallanku anchata admirakuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Chaymi chay ratomantapacha Zacariasqa kaqmanta rimariran. Hinaspan Diosta alabayta qallariran. ");
INSERT INTO qveNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Chaymi llapallan vecinonkunaqa anchata admirakuranku. Hinaqtinmi chay enteron Judea provinciapi tiyaq runakunaqa chaykuna pasasqanmanta rimaranku. ");
INSERT INTO qveNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Chaymi llapallan uyariqkunaqa sonqollankupi tapukuranku: “¿Chay wawa wiñaspanqa imaraqchá kanqa?”, nispanku. Ichaqa paykunaqa yacharankun chay wawataqa kikin Diospuni yanapasqanta. ");
INSERT INTO qveNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Diospa Santo Espiritun Zacariasman hunt'ayuqtinmi, payqa khaynata rimaran: ");
INSERT INTO qveNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“¡Diosyá alabasqa kachun! ¡Paymi hamuran kay Israel nacionpi tiyaqkunata salvawananchispaq! ");
INSERT INTO qveNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Diosmi hanaq pachamanta mandamun ancha atiyniyoq Salvawaqninchista. Payqa ñawpaq rey Davidpa mirayninmantan. Davidqa Dios serviqmi karan. ");
INSERT INTO qveNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Chaykunatan Diosmanta ñawpaq willakuq profetakuna escribiranku khaynata: ");
INSERT INTO qveNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","‘Diosmi enemigonchis runakunamanta hinallataq cheqniwaqninchis runakunamantapas salvawasunchis’, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Hinaspapas Diosqa nillarantaqmi khaynata: ‘Qankunata khuyapayasqayraykun prometesqaykunataqa cumplisaqpuni’, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Saynatan Diosqa ñawpaq abuelonchis Abrahamman prometeran, ");
INSERT INTO qveNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","llapallan enemigonchis runakunamanta librasqa kananchispaq, saynapi mana manchakuspa Diosllatapuni servinanchispaq, ");
INSERT INTO qveNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","saynallataq huchaman mana urmaspa, Diospa munasqanman hina sapa p'unchaw allinta kawsananchispaq. ");
INSERT INTO qveNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Wawalláy, qantan runakuna reqsisunkiku, tukuy atiyniyoq Diosmanta willakuq profetawan. Qanmi runakunata yachachiq rinki. Yachachisqaykita uyarispanku, hanaq pachamanta hamuq Salvadorta allinta chashkinankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Yachachispaykin Israel nacionpi tiyaq runakunata ninki: ‘Diosmi munan huchaykichista saqeqtiykichis perdonaspa salvasunaykichispaq’, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Diosqa khuyakuwaspanchismi, anchata munakuwanchis. Chaymi hanaq pachamanta Salvawaqninchista mandamun, imaynan huk mosoq p'unchawpi inti k'anchariqta hina. ");
INSERT INTO qveNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Paypa yachachikuyninmi inti hina k'anchayunqa huchallapi kawsaspa wañuyman riq runakunaman. Hinaspan allin kawsay ñanninta pusawasunchis, saynapi Dioswan hinallataq runamasinchiskunawan allinpi kawsanapaq”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Diospa yanapayninwanmi Zacariaspa wawan Juanqa wiñasqanman hina, allin yachayniyoq runa karan. Hinaspan payqa ch'inñeq lugarkunapi tiyaran, Israel nación llaqtapi tiyaq runakunata yachachiq rinan p'unchawkama. ");
INSERT INTO qveNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Jesús manaraq nacemushaqtinmi, chay p'unchawkunapi Rey Augusto César gobiernasharan ashka nación llaqtakunata. Hinaspan kamachimuran llapallan gobiernasqan llaqtakunapi runakuna censasqa kanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Chay primer kaq censoqa karan Siria provincia lawpi Cirenio sutiyoq runa gobernador kashaqtinmi. ");
INSERT INTO qveNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Chayraykun censasqa kanankupaq sapankama runakuna nacesqanku llaqtankuman riranku. ");
INSERT INTO qveNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Hinaqtinmi Joseypas Nazaret llaqtapi tiyasqanmanta Belén llaqtaman riran censasqa kananpaq. Nazaret llaqtaqa Galilea provinciamanmi perteneceran. Belén llaqtañataqmi Judea provinciaman perteneceran. Chaymi Joseyqa ñawpaq tiempopi rey Davidpa mirayninmanta kasqanrayku Belén llaqtamanqa riran. Nota: Rey Davidqa Belén llaqtapin naceran. ");
INSERT INTO qveNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Joseyqa warmin Mariapiwanmi ishkayninku censasqa kanankupaq riranku. Mariaqa onqoqñan kasharan, (Diospa Santo Espiritun atiyninwan llantuykusqanrayku). ");
INSERT INTO qveNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Belén llaqtapiña kashaqtinkun Mariapa onqokunan p'unchaw chayamuran. ");
INSERT INTO qveNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Hinaspan samana wasikunapi manaña campota tarispanku, animalkunapa puñunan lugarpi samapakuranku. Chaypin Mariaqa kuraq qari wawanta onqokuran. Pañalwan walthaykuspataqmi pesebrepi puñuykachiran. ");
INSERT INTO qveNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Belén llaqtapa camponpin michiqkuna ovejankuta tuta cuidasharanku. ");
INSERT INTO qveNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Chaypin qonqayllamanta Diospa angelnin paykunaman rikhuriykuran. Muyuriqninkutataqmi Diospa k'anchaynin k'anchayuran. Chaymi michiqkunaqa anchallataña mancharikuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Hinaqtinmi Diospa angelninqa paykunata khaynata niran: —Ama mancharikuychishchu. Llapallan runakuna kusikunanpaqmi Diosmanta allin willakuykunata qankunaman willaq hamushani. ");
INSERT INTO qveNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kunanmi nacerapusunkichis ñawpaq rey Davidpa tiyasqan Belén llaqtapi Salvasuqniykichis. Payqa Diosmanta Hamuq Salvadormi, hinaspapas runakunata salvaq Señormi. ");
INSERT INTO qveNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kunanmi rispa qankunaqa chay wawata tarimunkichis pañalkunawan walthaykusqata pesebrepi puñushaqta, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Chay angelpa ladonpin qonqayllamanta ashka angelkuna rikhuriykamuspa, Diosta alabaranku khaynata: ");
INSERT INTO qveNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“¡Diosyá hanaq pachapi alabasqa kachun! ¡Hinallataq kay pachapipas Diospa khuyakuynin chashkiq runakunapaq hawkayay kachun!” nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Hinaspan chay angelkuna hanaq pachaman kutipuqtinku, chay michiqkunaqa khaynata ninakuranku: —¡Hakuchiyá Belén llaqtaman, Diospa niwasqanchista rikumunanchispaq! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Chaymi michiqkunaqa apurayllamanña rispanku Mariata Joseytawan tariranku, hinallataq wawatapas pesebrepi puñushaqta. ");
INSERT INTO qveNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Chay wawata rikuruspankutaqmi, michiqkunaqa angelpa tukuy ima nisqanta willakuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Chaymi llapallan chaypi kaq runakunaqa, michiqkunapa willakusqanta uyarispanku, anchata admirakuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ichaqa Mariañataqmi sapa kutin yuyaymanaran sonqon ukhullapi chaykuna pasasqanmanta. ");
INSERT INTO qveNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Chaymantan michiqkunaqa kutipuranku Diosta alabastin, hinallataq graciasta qostin. Sayna kusisqaqa kutipuranku, angelpa nisqanman hina uyarisqankumanta, hinallataq angelpa nisqanman hina rikumusqankumantawan ima. ");
INSERT INTO qveNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mariapa wawan pusaq p'unchawniyoq kashaqtinmi circuncisión costumbreta ruwaranku. Hinaspan sutintapas churaranku Jesuswan. Chay sutitaqa ángel Gabrielmi Mariamanqa ña willaranña manaraq onqoq kashaqtin. ");
INSERT INTO qveNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moisespa escribisqan leyman hinan huk onqokuq warmiqa ch'uyanchakunan karan. Chay ch'uyanchakunan tiempo tukurukuqtinmi, wawa tawa chunka p'unchawniyoq kashaqtin, Joseyqa Mariapiwan wawata aparanku Jerusalén llaqtapi temploman, Diosman dedicanankupaq. Nota: Moisespa escribisqan leyman hinaqa tawa chunka p'unchawmi onqokuq warmiqa ch'uyanchakunan karan. Chaymantañan temploman rinan karan huchankunamanta Diosman sacrificiota ofrecenanpaq, Levítico 12.1-8. Chayta ruwaruspañan primer kaq qari wawantaqa Diosman dedicanan karan. ");
INSERT INTO qveNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Moisespa escribisqan leypin khayna kamachikuy karan: “Diosmanmi sapaqchaspa dedicapuna llapallan primerta nacemuq qari wawakunataqa”, nispa Éxodo 13.2, 12. ");
INSERT INTO qveNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Hinaspapas Moisespa escribisqan leypiqa nillarantaqmi khaynata: “Ishkay kullkuta otaq ishkay malqo urpita wañuchispa, Diosman sacrificio ofrendata qonkichis”, nispa Levítico 12.8. ");
INSERT INTO qveNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Chay tiempopin Jerusalén llaqtapi tiyaran Simeón sutiyoq runa. Paymi Diosta kasukuspa allin kawsaq runa karan. Hinaspapas payqa suyasharanmi Israel nación llaqtapi tiyaq runakuna salvasqa kanankuta. Diospa Santo Espirituntaqmi Simeonwan kaspa, ");
INSERT INTO qveNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","paymanqa ña willaranña khaynata: “Manan wañunkiraqchu Diospa mandamusqan Salvadorta rikunaykikama”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Chaymi Diospa Santo Espiritun kallpanchaqtin, Simeonqa temploman riran. Chaymanmi Mariaqa Joseypiwan wawata aparanku, leypa kamachisqanman hina cumplinankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Chaypin Simeonqa wawata marq'arikuspa, Diosta alabaran khaynata: ");
INSERT INTO qveNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Diosnilláy, kay serviqniykiman prometewasqaykiqa ñan cumplirukunña. Kunanqa hawkallayá wañukapusaq. ");
INSERT INTO qveNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Salvaqniyku mandamusqaykitan ña rikuykuniña. ");
INSERT INTO qveNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Paytan mandamuranki llapallan llaqtakunapi runakuna reqsinankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Paymi llapallan nacionkunapi tiyaq runakunata inti hina k'ancharinqa. Hinallataqmi Israel nacionniyoq runakunapas ancha allin reqsisqa kanqaku”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Chaymi Joseyqa Mariapiwan Simeonpa nisqanta uyarispanku, anchata admirakuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Hinaspan Simeonqa paykunapaq Diosmanta mañapuyta tukuruspa, Jesuspa mamitan Mariata khaynata niran: —Diosmi kay wawata mandamun Israel nacionpi ashka runakuna paypi creespa salvasqa kanankupaq, ichaqa paypi mana creeqkunañataq castigasqa kanankupaq. Paymi kanqa huk señal hina llapallan runakunapaq; hinaqtinmi ashka runakuna paypi creeyta mana munaspanku, paypa contranpi sayarinqaku. ");
INSERT INTO qveNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Saynapin runakunapa tukuy ima piensasqankupas yachasqa kanqa. Chaymi, María, qanqa ancha llakisqa kanki, imaynan huk hatun cuchillowanpas sonqoykita k'irishasunkikuman hinaraq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Chaypitaqmi kasharan Aserpa mirayninmanta Fanuelpa ususin Anapas yuyaq warmiña. Payqa Diosmanta willakuq profetisan karan. Sipas kashaspanmi Anaqa casarakuran hinaspan qanchis watalla qosanwan tiyaran. ");
INSERT INTO qveNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Chaymantan viuda qeparan pusaq chunka tawayoq wata. Hinaspan payqa sayna yuyaqña kashaspanpas Diosta templopi tuta p'unchaw serviran, ayunaspa, hinallataq Diosmanta mañakuspa ima. ");
INSERT INTO qveNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeón rimayta tukurullaqtinmi, Anaqa paykunaman ashuyuspa, Diosta alabaran. Chaymantan Jerusalenpi tiyaq wakin runakunaman willaran wawa Jesusmanta. Paykunaqa suyasharankun salvaqninku hamunanta. ");
INSERT INTO qveNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Diospa leyninpi kamachisqankunata cumpliruspankun, Joseyqa Mariapiwan Galilea provinciapi Nazaret llaqtankuman kutipuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Chaypin Jesusqa wiñaran allin kallpayoq, hinallataq allin yachayniyoq ima. Diostaqmi paywan anchata kusikuspa, tukuy imapi yanaparan. ");
INSERT INTO qveNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jesuspa tayta mamanqa sapa watanmi, Jerusalén llaqtapi Pascua fiestaman riranku. ");
INSERT INTO qveNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Chaymi Jesusqa chunka ishkayniyoq watanpiña kashaspa, tayta mamanpiwan riranku costumbrenkuman hina Jerusalén llaqtapi Pascua fiestaman. ");
INSERT INTO qveNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pascua fiesta tukurukuqtintaqmi llaqtankuman kutipusharanku, Jesusñataqmi ichaqa tayta mamanpa mana yachasqallan qeparukuran Jerusalén llaqtapi. ");
INSERT INTO qveNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Tayta mamanñataqmi piensaranku wakin kutipuqkunawan kushka Jesús rinanpaq. Huk p'unchaw puriytaña rishaspankutaqmi, chayraq cuentata qokuranku Jesusqa paykunawan mana risqanta. Hinaspan mashkaranku familiankuna ukhupi, hinallataq reqsisqan runakunatapas tapukachakustin. ");
INSERT INTO qveNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mana tarispankuñataqmi Jerusalén llaqtaman kutiranku, chaypi mashkamunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Chaymi kinsa p'unchawmantaña Jerusalén templopi Jesustaqa tariranku, Moisespa escribisqan leykunamanta yachachiq runakunapa chawpinpi tiyayuspa uyarishaqta, hinallataq paykunata tapushaqta ima. ");
INSERT INTO qveNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Hinaspan llapallan chaypi uyariqkunaqa anchata admirakuranku Jesuspa yachasqanwan, hinallataq paykunapa tapusqankutapas allinta contestasqanwan ima. ");
INSERT INTO qveNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Saynallataqmi tayta mamanpas Jesusta templopi rikuspanku anchata admirakuranku. Hinaspan mamitan Mariaqa Jesusta niran: —Wawáy, ¿imanaqtintaq kaytari ruwawankikú? Papaykin, noqapiwan ancha llakisqallaña mashkamushaykiku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Chaymi Jesusqa khaynata contestaran: —¿Imanaqtintaq noqatari mashkawashankichís? ¿Manachu yacharankichis noqaqa Papaypa ruwanankunapi kanayta? nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Chayta uyarispankun Joseyqa Mariapiwan mana entienderankuchu. ");
INSERT INTO qveNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Chaymantan Jesusqa tayta mamanpiwan Nazaret llaqtaman kutiran. Hinaspan tayta mamanta tukuy imapi kasukuspa, paykunawan kushka tiyaran. Mariañataqmi ichaqa tukuy imaymana pasasqankunamanta mana qonqaspa, sapa kutin yuyarispa sonqollanpi yuyaymanaran. ");
INSERT INTO qveNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesusñataqmi wiñaran sayayninpi, hinallataq yachayninpas astawan yapakuran. Hinaqtinmi Diospas hinallataq runakunapas Jesuspa ruwasqankunawan astawanraq kusikuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Chunka pishqayoq wataña rey Tiberio César ashka nación llaqtakunata gobiernashaqtinmi, chay p'unchawkunapi prefecto hina kamachiq karanku: Judea provinciapi Poncio Pilato; Galilea provinciapi Herodes Antipas; Iturea provinciapi hinallataq Traconite provinciapiwan Herodes Antipaspa wawqen Felipe; Abilinia provinciapitaq Lisanias sutiyoq runa prefecto karan. ");
INSERT INTO qveNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Israel nacionniyoq sacerdotekunapa jefenkunañataqmi karanku Anaswan Caifaspiwan. Chay p'unchawkunallapitaqmi Zacariaspa wawan Bautizaq Juanpas huk ch'inñeq lugarpi kasharan. Chaypi kashaqtinmi Diosqa payman rimaykuran, (saynapi Diosmanta willakuq profeta kananpaq). ");
INSERT INTO qveNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Chaymi Bautizaq Juanqa Jordán nisqa mayupa ladonman riran. Chay mayuq patankunapi purispanmi, Bautizaq Juanqa runakunaman willaran khaynata: —Huchaykichista saqespayá, Diosman kutirikuychis, huchaykichis perdonasqa kananpaq. Hinaspataq bautizachikuychis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kaykunataqa Diosmanta willakuq ñawpaq profeta Isaiasmi Bautizaq Juanmantaqa ña escribiranña khaynata: “Ch'inñeq desierto lugarpin huk runa altollamantaña rimaspa willakushan khaynata: ‘Sonqoykichista allichaychis Diosmanta Hamuq Salvadorta chashkinaykichispaq, imaynan wiksu ñankunata allichanku chay hinata. ");
INSERT INTO qveNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Diosmanta Hamuq Salvadorta chashkinaykichispaqqa, sonqoykichista allichaychis, imaynan llapallan wayq'okunapas hunt'asqa kanman hinata, imaynan tukuy orqokunapas, hinallataq moqokunapas pampayachisqa kanman hinata, imaynan q'ewi-q'ewi ñankunapas derechasqa kanman hinata, imaynan khallka-khallka ñankunapas allichasqa kanman hinata, sonqonchista allichasunchis. ");
INSERT INTO qveNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Saynapin kay pachapi llapallan runakuna Diosmanta Hamuq Salvadorninchista rikunqaku’ ”, nispa Isaías 40.3-5. ");
INSERT INTO qveNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Hinaqtinmi ashka runakuna riranku Juanwan bautizachikuq. Chaymi Bautizaq Juanqa paykunata rikuspa khaynata niran: —¡Mach'aqwaypa miraynin hina runakuna! Qankunamanri, ¿pitaq nisurankichis Diospa castigonmanta ayqekunaykichispaqrí? ");
INSERT INTO qveNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Tukuy huchaykichismanta wanakuspayá, allin kawsaypiña puriychis. Amataq piensaychishchu: “Noqaykuqa ñawpaq abueloyku Abrahampa mirayninmanta kasqaykuraykun salvasqa kasaqku”, nispachu. (Saynataqa piensaranku Diospi Abraham anchata iñispa confiasqanraykun). Ichaqa noqan nisqaykichis, sichus Dios munanman chayqa, Abrahammanta miramuq runakunamanmi kay rumikunatapas tukurachinman. ");
INSERT INTO qveNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Imaynan mana ruruq sach'akunatapas dueñonqa, saphinmanta orqospa, hachawan takaspa ninaman wikch'uyun, saynallatataqmi Diospas ruwanqa mana allin ruwaq runakunawanqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Chaykunata uyarispankun runakunaqa Juanta tapuranku khaynata: —¿Imatataq ruwaykuman salvasqa kanaykupaqrí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juanñataqmi contestaran: —Pipas ishkay p'achayoq kaspaqa, hukninta mana p'achayoqman qoykuchun. Mikhunayoq kaqpas, mana mikhunayoqman qoykuchun, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Saynallataqmi Roma llaqtapaq impuesto cobraq runakunapas hamullarankutaq Juanwan bautizachikunankupaq. Hinaspan Juanta tapukuranku khaynata: —Yachachikuq, noqaykuri ¿imatataq ruwaykuman salvasqa kanaykupaqrí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juanñataqmi contestaran khaynata: —Qankunaqa, amayá mas-mastaraqchu cobraychis; aswanqa kamachiq autoridadpa leyninman hinallayá cobraychis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Chaymantan huk soldadokunapas Juanta tapukullarankutaq: —Noqaykuri, ¿imatataq ruwasaqkurí? nispanku. Juanñataqmi paykunata contestaran: —Qankunaqa amayá ni pitapas amenazaspachu imankutapas qechuychis, nitaq yanqamanta tumpaspachu pagachikuychispas. Aswanqa pagoykichiswanyá contentakuychis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Chaymi Juanpa nisqanta uyarispanku chaypi kaq runakunaqa admirakuranku. Hinaspan sonqonku ukhullapi tapukuranku khaynata: “Icha, ¿paychu Diosmanta Hamuq Salvadorninchisqa?” nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Chaymi Juanqa, chaypi kaq runakunata niran: —Noqaqa unullawanmi qankunataqa bautizaykichis. Aswanqa hukraqmi hamushan noqamanta aswan más atiyniyoq. Paymi Diospa Santo Espiritunta qosunkichis qankunapi kananpaq; hinallataq bautizasunkichispas ninawan hina. Noqaqa manan paypa husut'anpa watullantapas pashkanaypaq hinachu kani. ");
INSERT INTO qveNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Pay hamuspanmi t'aqanqa allin runakunata mana allin runakunamanta, imaynan pajanmanta trigota akllaspa wayrachinku chay hinata. Ichaqa allin ruwaq runakunatataqmi salvanqa. Mana allinpi kawsaq runakunatataqmi mana wañuq nina rawrayman wikch'uyuspa k'ananqa, chaypi wiña-wiñaypaq ñak'arinankupaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Saynatan Juanqa Diosmanta runakunaman willaran allin willakuykunata. ");
INSERT INTO qveNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Hinallataq Juanqa q'aqcharan kamachiq Herodes Antipastapas, wawqen Felipepa warmin Herodiaswan waqllikusqanmanta, hinallataq tukuy mana allinkuna ruwasqanmantawan ima. ");
INSERT INTO qveNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Chaymi Herodes Antipasqa anchata phiñakuspa, Bautizaq Juantaqa carcelman churachiran. Chayta ruwaspanmi Herodesqa astawanraq huchallikuran. ");
INSERT INTO qveNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Manaraq carcelman churashaqtinkun, Juanqa runakunata bautizasharan. Chaymanmi Jesuspas riran Juanwan bautizachikuq. Chay ratopin, Jesusqa Diosmanta mañakushaqtin, hanaq pacha cielo kicharikuran. ");
INSERT INTO qveNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Hinaqtinmi Diospa Santo Espiritun paloma hina urayamuran Jesuspa hawanman. Hinaspan chay ratopi hanaq pachamanta nimuran khaynata: —Qanmi kanki ancha munakusqay Waway. Qanwanmi anchata kusikuni munasqayta ruwasqaykirayku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Kinsa chunka watayoq hina kashaspanmi, Jesusqa qallariran runakunaman yachachiyta. Runakunapa piensayninman hinaqa, Jesusqa Joseypa wawanmi karan. Joseyñataqmi Eliypa wawan karan. ");
INSERT INTO qveNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eliyñataqmi Matatpa wawan karan, Matatñataqmi Leviypa wawan karan, Leviyñataqmi Melquipa wawan karan, Melquiñataqmi Janapa wawan karan, Janañataqmi Joseypa wawan karan, ");
INSERT INTO qveNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joseyñataqmi Matatiaspa wawan karan, Matatiasñataqmi Amospa wawan karan, Amosñataqmi Nahumpa wawan karan, Nahumñataqmi Eslipa wawan karan, Esliñataqmi Nagaipa wawan karan, ");
INSERT INTO qveNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaiñataqmi Maatpa wawan karan, Maatñataqmi Matatiaspa wawan karan, Matatiasñataqmi Semeipa wawan karan, Semeiñataqmi Joseypa wawan karan, Joseyñataqmi Judapa wawan karan, ");
INSERT INTO qveNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judañataqmi Joanapa wawan karan, Joanañataqmi Resapa wawan karan, Resañataqmi Zorobabelpa wawan karan, Zorobabelñataqmi Salatielpa wawan karan, Salatielñataqmi Neripa wawan karan, ");
INSERT INTO qveNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neriñataqmi Melquipa wawan karan, Melquiñataqmi Adipa wawan karan, Adiñataqmi Cosampa wawan karan, Cosamñataqmi Elmadampa wawan karan, Elmadamñataqmi Erpa wawan karan, ");
INSERT INTO qveNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Erñataqmi Josueypa wawan karan, Josueyñataqmi Eliezerpa wawan karan, Eliezerñataqmi Jorimpa wawan karan, Jorimñataqmi Matatpa wawan karan, ");
INSERT INTO qveNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matatñataqmi Leviypa wawan karan, Leviyñataqmi Simeonpa wawan karan, Simeonñataqmi Judapa wawan karan, Judañataqmi Joseypa wawan karan, Joseyñataqmi Jonanpa wawan karan, Jonanñataqmi Eliaquimpa wawan karan, ");
INSERT INTO qveNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquimñataqmi Meleapa wawan karan, Meleañataqmi Mainanpa wawan karan, Mainanñataqmi Matatapa wawan karan, Matatañataqmi Natanpa wawan karan, ");
INSERT INTO qveNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natanñataqmi Davidpa wawan karan, Davidñataqmi Isaipa wawan karan, Isaiñataqmi Obedpa wawan karan, Obedñataqmi Boozpa wawan karan, Boozñataqmi Salmonpa wawan karan, Salmonñataqmi Naasonpa wawan karan, ");
INSERT INTO qveNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasonñataqmi Aminadabpa wawan karan, Aminadabñataqmi Arampa wawan karan, Aramñataqmi Esrompa wawan karan, Esromñataqmi Farespa wawan karan, Faresñataqmi Judapa wawan karan, ");
INSERT INTO qveNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judañataqmi Jacobpa wawan karan, Jacobñataqmi Isaacpa wawan karan, Isaacñataqmi Abrahampa wawan karan, Abrahamñataqmi Tareypa wawan karan, Tareyñataqmi Nacorpa wawan karan, ");
INSERT INTO qveNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacorñataqmi Serugpa wawan karan, Serugñataqmi Ragaupa wawan karan, Ragauñataqmi Pelegpa wawan karan, Pelegñataqmi Heberpa wawan karan, Heberñataqmi Salapa wawan karan, ");
INSERT INTO qveNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salañataqmi Cainanpa wawan karan, Cainanñataqmi Arfaxadpa wawan karan, Arfaxadñataqmi Sempa wawan karan, Semñataqmi Noeypa wawan karan, Noeyñataqmi Lamecpa wawan karan, ");
INSERT INTO qveNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamecñataqmi Matusalenpa wawan karan, Matusalenñataqmi Enocpa wawan karan, Enocñataqmi Jaredpa wawan karan, Jaredñataqmi Mahalaleelpa wawan karan, Mahalaleelñataqmi Cainanpa wawan karan, ");
INSERT INTO qveNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainanñataqmi Enospa wawan karan, Enosñataqmi Setpa wawan karan, Setñataqmi Adanpa wawan karan, Adanñataqmi Diospa unanchasqan karan. ");
INSERT INTO qveNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesusqa Diospa Santo Espiritunwanmi hunt'asqa kutipusharan Jordán mayumanta. Hinaqtinmi Diospa Santo Espiritunqa ch'inñeq desierto lugarman Jesusta pusaran. ");
INSERT INTO qveNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Chaypin Jesusqa karan tawa chunka p'unchaw mana ni imatapas mikhuspa. Chay p'unchawkunapin diabloqa Jesusta huchaman urmachiyta munaran. Chay tawa chunka p'unchaw pasaruqtinñataqmi Jesusqa yarqachikuran. ");
INSERT INTO qveNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Chaymi diabloqa khaynata niran: —Cheqaqtapuni Diospa Wawan kaspaykiqa, kay rumikunatayá niy t'antaman tukunanpaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesusñataqmi contestaran: —Bibliapin nishan: “Runaqa manan t'antallawanchu kawsanqa, {aswanqa Diospa palabranta kasukuspan kawsanqa}”, nispa Deuteronomio 8.3. ");
INSERT INTO qveNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Chaymantan diabloqa huk alto orqoman Jesusta pusaran. Hinaspan huk ratollapi qawarichiran kay pachapi llapallan nación llaqtakunata. ");
INSERT INTO qveNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Hinaspan diabloqa khaynata niran: —Qanmanmi qosqayki kay nacionkunata kamachinaykipaq, hinallataq qapaq kaynintapas. Noqamanmi qowaran; chaymi noqaqa pi munasqaymanpas qoyman. ");
INSERT INTO qveNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Sichus qan ñawpaqniypi qonqorikuspa adorawanki chayqa, llapallanmi qanpaq kanqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesusñataqmi diablota niran: —Bibliapin khaynata nishan: “Señor Diosnillaykitan adoranki, pay sapallantataqmi servinkipas”, nispa Deuteronomio 6.13; 10.20. ");
INSERT INTO qveNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Chaymantan diabloqa Jerusalén llaqtaman Jesusta pusaran. Chaypin Dios yupaychana templopa alton patapi sayaykachispa, khaynata niran: —Cheqaqtapuni Diospa Wawan kaspaykiqa kaymantayá saltaykuy. ");
INSERT INTO qveNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Bibliapin nishan khaynata: “Diosmi angelninkunata kamachinqa cuidasunaykipaq. ");
INSERT INTO qveNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Paykunan makinkuwan hap'isunkiku, chakiykita rumiman ama takakunaykipaq”, nispa Salmos 91.11-12. ");
INSERT INTO qveNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Chaymi Jesusqa diablota niran: —Bibliapiqa nillashantaqmi: “Señor Diosniykitaqa aman ni ima pruebamanpas yanqapuniqa churankichu”, nispa Deuteronomio 6.16. ");
INSERT INTO qveNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Diabloqa Jesusta huchaman mana urmachiyta atispanmi, karunchakuran huk kutinkama. ");
INSERT INTO qveNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesusmi kutiran Diospa Santo Espiritunpa atiyninwan hunt'asqa Galilea provincia lawman. Chaymi chay enteron provincia lawpi runakunaqa Jesusmanta allinta rimaranku. ");
INSERT INTO qveNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Hinaspan chay p'unchawkunapi Jesusqa yachachiran Diosmanta yachachina sinagoga wasikunapi. Chaypi uyariq runakunañataqmi anchata admirakuranku; hinaspan Jesusta alabaranku. ");
INSERT INTO qveNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesusqa wiñasqan Nazaret llaqtaman rispanmi, costumbrenman hina samana p'unchawpi Diosmanta yachachina sinagoga wasiman riran. Chaypin sayariyuran leenanpaq. ");
INSERT INTO qveNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Chaymi Diosmanta willakuq profeta Isaiaspa escribisqan librota Jesusman haywaranku leenanpaq. Hinaqtinmi chay librota kicharispa leeran: ");
INSERT INTO qveNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Diospa Santo Espiritunmi noqapi kashan. Paymi atiyta qowan; hinaspan mandamuwan allin willakuykunata wakcha runakunaman willanaypaq, hinallataq carcelpi kaqkunaman willaqtiy kacharisqa kanankupaq, ñawsakunapa ñawinta qawarichinaypaq, ñak'ariypi kawsaqkunata orqospa salvanaypaq, ");
INSERT INTO qveNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","runakunaman Diospa salvanan tiempo chayamusqanta willanaypaq ima”, nispa Isaías 61.1-2. ");
INSERT INTO qveNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Leeyta tukuruspanmi, Jesusqa Diosmanta willakuq profeta Isaiaspa escribisqan librota haywayapuran librokuna waqaychaqman. Hinaspanmi Jesusqa tiyayuran. Chaypi kaq llapallan runakunañataqmi Jesusta qawapayaranku. ");
INSERT INTO qveNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Chaymi paykunata Jesusqa niran: —Kunanmi kay leesqaykunaqa qankunapa ñawpaqniykichispi cumplikun, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jesuspa sumaqllaña yachachisqankunata uyarispankun llapallan chaypi kaq runakunaqa admirasqallaña Jesusmanta allinta rimaranku. Hinaspan paykunapura ninakuranku khaynata: —¿Manachu kay runaqa Joseypa churillan? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Chaymi Jesusqa paykunata niran: —Runakunapa nisqankutan niwankichis: “Médico kaspaykiqa, qan kikiykitaraqyá primertaqa hampikuy”, nispa. Hinaspapas qankunaqa niwankichismi: “Capernaúm llaqtapi imaymana milagrokuna ruwasqaykitan uyariyku, chaykunatayá kay llaqtaykipipas ruway”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jesusqa nillarantaqmi khaynata: —Cheqaqtapunin niykichis, Diosmanta willakuq profetaqa manan llaqtanpiqa allin chashkisqaqa kanmanchu. ");
INSERT INTO qveNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Diosmanta ñawpaq willakuq profeta Eliaspa kawsasqan p'unchawkunapipas, kinsa wata parten mana paraqtinmi ancha muchuy karan enteron Israel nacionpi, hinallataq muyuriqnin ladon nacionkunapipas. Ichaqa Israel nacionpi ashka viudakuna kashaqtinpas, ");
INSERT INTO qveNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Diosqa manan profeta Eliastaqa mandamuran chay viudakunata yanapananpaqchu. Aswanmi Eliasqa huk law nacionpi tiyaq viudallaman yanapaq riran. Chay viudaqa tiyaran Sidón provincia ukhupi Sarepta sutiyoq llaqtapin. ");
INSERT INTO qveNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kallarantaqmi Diosmanta willakuq profeta Eliseopa kawsasqan p'unchawkunapipas Israel nacionpi ashkallaña mana sanoyaq lepra onqoywan onqoq runakuna. Paykunapas manan chay onqoymantaqa sanoyachisqachu karanku. Aswanqa Siria nacionmanta kaq Naamán sutiyoq runallatan Eliseoqa sanoyachiran, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Chaykunata uyarispankun, Diosmanta yachachina sinagoga wasipi llapallan huñunasqa runakunaqa anchata phiñakuranku, (chay huk law nacionniyoq runakunapa favorninpi Jesús rimasqanrayku). ");
INSERT INTO qveNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Chaymi sayarispanku Jesustaqa tanqa-tanqarisparaq aparanku llaqtapa waq lawnin qaqa pataman, chaymanta qaqaman tanqaykunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Jesusñataqmi ichaqa chawpinkumanta lloqsispa ripuran. ");
INSERT INTO qveNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesusqa Galilea provincia ukhupi Capernaúm llaqtamanmi riran. Chaypin samana p'unchawkunapi Diosmanta yachachina sinagoga wasipi runakunaman yachachiran. ");
INSERT INTO qveNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Chaymi runakunaqa uyarispanku anchata admirakuranku, Jesusqa ancha yachayniyoq kaspa atiywan yachachisqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Chay ratollapitaqmi demoniokunapa ñak'arichisqan huk runa chay sinagoga wasipi kasharan. Hinaqtinmi chay runaqa altota qaparispa, Jesusta niran: ");
INSERT INTO qveNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Yaw, Nazaret llaqtayoq Jesús! ¿Imatataq noqaykuwanri munankí? ¿Noqaykuta wañuchiqchu qanqa hamurankí? Noqaqa reqsiykin pi kasqaykita. ¡Qanqa Diospa Wawanmi kanki, mana ni ima huchayoq! nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesusñataqmi chay demoniotaqa q'aqchaspa khaynata niran: —¡Upallay, hinaspa lloqsiy kay runamanta! nispa. Hinaqtinmi chay demonioqa, llapallan chaypi kaq runakunapa ñawpaqninpi chay runata pampaman wikaparan. Hinaspan chay runamanta lloqsiran mana ni ima dañotapas ruwaspalla. ");
INSERT INTO qveNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Hinaqtinmi chaypi kaq runakunaqa, admirakuspanku paykunapura ninakuranku khaynata: —¿Imayna atiyniyoqtaq kay runarí? ¡Rimayllanwan kamachiqtinmi demoniokunapas lloqsin! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Chaymi Jesusmantaqa chay enteron llaqtakunapi astawanraq rimaranku, rimasqanmanta hinallataq tukuy ruwasqankunamantawan ima. ");
INSERT INTO qveNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Diosmanta yachachina sinagoga wasimanta lloqsispan, Jesusqa Simón Pedropa wasinta riran. Chayaruspanmi wasi ukhuman haykuran. Chaypin Simón Pedropa suegranqa fiebre onqoywan nishuta onqosharan. Chaymi Jesusta ruegakuranku sanoyachinanpaq. ");
INSERT INTO qveNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Hinaqtinmi Jesusqa Simón Pedropa suegranman ashuyuspa, chay fiebre onqoyta chinkananpaq kamachiran. Chaymi Simón Pedropa suegranqa chay fiebre onqoymanta kasqan ratolla sanoyaran. Hinaspan payqa hatarispa, paykunaman mikhunata serviran. ");
INSERT INTO qveNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Inti haykuyushaqtinñan, Jesusman tukuy onqoyniyoq runakunata apamuranku. Chaymi Jesusqa sapankama onqosqa runakunaman makinta churayuspa sanoyachiran. ");
INSERT INTO qveNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Hinallataq ashka runakunamantapas demoniokuna lloqsiranku khaynata qaparispanku: —¡Qanqa Diospa Wawanmi kanki! nispanku. Jesusñataqmi chay demoniokunata q'aqchaspa mana dejaranchu paymanta rimanankutaqa. Chay demoniokunaqa yacharankun Jesusqa Diosmanta Hamuq Salvador kasqanta. ");
INSERT INTO qveNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ña achiqamushaqtinñan Jesusqa chay Capernaúm llaqtamanta lloqsiran. Hinaspan huk ch'inñeq desierto lugarman riran. Hinaqtinmi runakunaqa Jesusta mashkaranku. Tariruspankutaqmi ruegakuranku llaqtankumanta ama ripunanpaq. ");
INSERT INTO qveNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Chaymi paykunata Jesusqa niran: —Noqaqa rinaymi huk law llaqtakunamanpas Diospa gobiernananmanta allin willakuykunata runakunaman willamunaypaq. Chaypaqmi Diosqa noqata mandamuwaran, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Hinaqtinmi Jesusqa Galilea provincia ukhupi Diosmanta yachachina sinagoga wasikunaman haykuspa, Diosmanta allin willakuykunata willaran. ");
INSERT INTO qveNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Huk p'unchawmi Jesusqa Genesaret sutiyoq laguna qochapa patanpi kasharan. Chaymanmi ashka runakuna huñunakamuranku ñit'i-ñit'iraq Diospa palabranta uyarinankupaq. Nota: Genesaret laguna qochapa huknin sutinmi karan Galilea laguna qocha. ");
INSERT INTO qveNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Chay laguna qochapa patanpin Jesusqa ishkay botekunata rikuran. Challwaqkunataqmi mallankuta maqchisharanku chay botenkupa ladonpi. ");
INSERT INTO qveNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Hinaspanmi Simón Pedropa botenman qespispa Jesusqa payta valekuran, laguna qocha ukhuman tumpallanta boteta tanqariykunanpaq. Chaypi tiyayuspataqmi Jesusqa chay botemanta laguna qocha patapi llapallan runakunata yachachimuran. ");
INSERT INTO qveNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yachachiyta tukuruspanñataqmi Simón Pedrota niran: —Boteykita laguna qochapa chawpinman apayuspayki, mallaykita laguna qochaman wikch'uyuy challwanaykipaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Chaymi Simón Pedroqa contestaran: —Señor, tukuy tutan challwarayku; ichaqa manan ni ch'ullallatapas hap'iraykuchu. Qan niwaqtiykiqa wikch'uyusaqyá mallayta, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Chaymi Jesuspa nisqanta kasukuspanku paykunaqa mallankuta wikch'uyuranku. Hinaspan ashkallataña challwata hap'iranku, mallankupas yaqa llik'ikunankamaraq. ");
INSERT INTO qveNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Hinaqtinmi huknin botepi challwaqmasinkuna yanapaq hamunankupaq makinkuwan señaschaspa waqyaranku. Chaymi paykunaqa hamuspanku ishkaynin boteman challwasqankuta hunt'achiranku, botenkupas yaqaraq unu ukhuman chinkayunankama. ");
INSERT INTO qveNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Chayta Simón Pedro rikuspanmi, Jesuspa ñawpaqninpi qonqorikuspa niran: —¡Señor, noqaqa huchasapa runan kani; ayqeriy noqapa ladoymanta! nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Chaymi Simón Pedropas, hinallataq paywan kushka kaqkunapas ashka challwata hap'isqankurayku admirasqallaña karanku. ");
INSERT INTO qveNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Saynallataqmi Zebedeopa wawankuna, Juanwan Jacobopiwan ima admirasqallaña karanku. Paykunaqa Simón Pedropa challwaqmasinkunan karan. Jesusñataqmi Simón Pedrota niran: —Ama manchakuychu, imaynan challwata challwankichis, saynatan runakunatapas huñumunkichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Laguna qochapa patanman botenkuta chayarachispankutaqmi, tukuy kaqninkutapas chaypi saqespa, Jesusta qatikuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Huk p'unchawmi Jesusqa huk llaqtapi kasharan. Hinaqtinmi lepra onqoyniyoq runa payman hamuran. Hinaspan ñawpaqninpi qonqoriyukuspa ruegakuran khaynata: —Señorlláy, munaspaykiqa kay onqoyniymantayá sanoyaykachiway, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Chaymi Jesusqa makinwan llamiyuspa, chay runata niran: —Arí, noqaqa munanin sanoyanaykita, nispa. Hinaqtinmi kasqan ratolla chay lepra onqoyniyoq runaqa sanoyapuran. ");
INSERT INTO qveNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Chaymi Jesusqa kamachiran khaynata: —Aman pimanpas kaykuna pasasusqaykimantaqa willankichu. Aswanyá Israel templopi serviq sacerdotekunaman rispa, qawachikamuy sanoña kasqaykita. Hinaspayki Moisespa escribisqan leyman hina ofrendaykita qomuy. Saynapin paykunaqa sanoña kasqaykita yachanqaku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Kaykuna ruwasqanta uyarispankun ashka runakunaqa Jesusmanta tukuy lawpi rimaranku. Chaymi ashka runakuna hamuranku, Jesuspa yachachisqanta uyarinankupaq, hinallataq onqoyninkumantapas sanoyasqa kanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jesusqa Diosmanta mañakunanpaqmi, sapa kutin ch'inñeq lugarkunaman sapallan riran. ");
INSERT INTO qveNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Huk p'unchawmi Jesusqa runakunaman yachachisharan. Chaypin kasharanku fariseo religionniyoq runakuna, hinallataq leykunata yachachiq runakunapas. Paykunaqa hamuranku Galilea provincia lawpi ashka llaqtachakunamanta, Judea provincia lawmanta, hinallataq Jerusalén llaqtamantawan iman. Chaypin Jesusqa Diospa atiyninwan onqoyniyoq runakunata sanoyachiran. ");
INSERT INTO qveNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Hinaqtinmi huk mana puriq runata kallapipi wantumuranku Jesuspa kasqan wasiman. Chayarachimuspankun Jesuspa ñawpaqninman apayuyta munaranku. ");
INSERT INTO qveNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ichaqa manan wasi ukhumanqa maynintapas apayuyta atirankuchu, ashka runakuna wasipa punkunpi kasqankurayku. Chaymi paykunaqa wasi pataman wichachispa, wasita t'oqoranku. Hinaspan chayninta mana puriq runataqa, Jesuspa ñawpaqninman urayachiranku. ");
INSERT INTO qveNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Chaymi Jesusqa chay wantumuq runakunapa iñiyninkuta yachaspa, chay mana puriq runata niran: —Amigo, huchaykikunatan perdonayki, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Chaymi leykunata yachachiq runakuna, hinallataq fariseo religionniyoq runakunapiwan ima piensasharanku khaynata: “¿Pitaq kay runari, kaykunata rimaspa Diosta ofendenanpaqrí? ¿Pitaq runakunapa huchankunatari perdonanman? ¡Aswanqa runakunapa huchantaqa Diosllan perdonaytaqa atin!” nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Chaymi Jesusqa paykunapa piensasqanta yachaspa, tapuran khaynata: —Qankunari, ¿imanaqtintaq saynatari sonqoykichis ukhullapi piensashankichís? ");
INSERT INTO qveNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Kunanyá niwaychis, ¿Imataq más facilri kanman? ¿Kay runapa huchankunata perdonaychú? Icha ¿sanoyachispa ripuy niychú? ");
INSERT INTO qveNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kunanmi yachankichis, noqa Diosmanta Hamuq Runaqa kay pachapi runakunapa huchankunata perdonanaypaq atiyniyoq kasqayta, nispa. Chayta rimayta tukuruspanmi, Jesusqa chay mana puriq runata niran: —Sayariy; hinaspa chay kallapiykita oqarispa wasiykiman ripuy, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Chaymi chay mana puriq runaqa, llapallan runakuna rikushaqtin, kasqan ratolla sayariran. Hinaspan llapallan runakuna rikushaqtin kallapinta apayukuspa wasinman ripuran, Diosta anchata alabastin. ");
INSERT INTO qveNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Saynallataqmi chay wasipi kaq runakunapas rikusqankuwan anchata admirakuspanku tukuy manchakuywan Diosta alabaranku khaynata: —¡Mana hayk'aq rikusqanchiskunatan kunan p'unchaw rikunchis! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jesusqa chay mana puriq runata sanoyarachispanmi chay wasimanta ripuran. Rishaspantaqmi impuesto cobraq Leví sutiyoq runata rikuran, Roma llaqtapaq impuesto cobranan puestopi tiyashaqta. Leviytan Jesusqa niran: —Qatikuway, nispa. Nota: Leviypa huknin sutinqa karan Mateon. ");
INSERT INTO qveNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Chayta uyarispanmi Leví sutiyoq runaqa, tukuy ruwasqankunata saqespa, Jesusta qatikuran. ");
INSERT INTO qveNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Hinaspan Leví runaqa wasinpi ashka mikhunata wayk'uchiran Jesusman invitananpaq. Chaypitaqmi ashka impuesto cobraqmasinkunapas, huk runakunapiwan mesapi mikhusharanku. ");
INSERT INTO qveNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Chaymi leykunata yachachiqkunapas, hinallataq fariseo religionniyoq runakunapas, Jesuspa discipulonkunapa contranpi rimaranku khaynata: —¿Imanaqtintaq qankunari mikhushankichis tomashankichis chay impuesto cobraq runakunawan, hinallataq huchasapa runakunawan kushkarí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Chaymi Jesusqa paykunata khaynata niran: —Medicotaqa onqosqa runakunallan necesitanku; sano runakunan ichaqa mana necesitankuchu. ");
INSERT INTO qveNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Noqaqa manan justo tukuq runakunata salvaqchu hamurani. Aswanqa huchankumanta wanakuspa noqapi creeqkunata salvaqmi hamurani, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jesustan chaypi kaq runakuna niranku: —Bautizaq Juanpa discipulonkunapas, hinallataq fariseo religionniyoq runakunapas, sapa kutinmi ayunaspa Diosmanta anchata mañakunku. ¿Imanaqtintaq qanpa discipuloykikunari mana ayunankuchu; aswanqa mikhuyllapi tomayllapi kashankú? nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Hinaqtinmi Jesusqa paykunata khaynata niran: —Qankunari, ¿huk casarakuy fiestaman invitasqa runakunatari, ayunachiwaqchishchu, chayllapiraq casarakuq qari kashaqtinrí? Manan. ");
INSERT INTO qveNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Aswanmi kanqa p'unchawkuna, casarakuq qari qankuna ukhumanta qechusqa kaqtin ayunanaykichispaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesusqa paykunamanmi huk willakuyta willaran khaynata: —Manan ni pipas mosoq telataqa kuchunmanchu thanta p'acha remendananpaqqa. Saynata ruwaspaqa yanqapaqmi kuchunman mosoq telataqa. Remendaqtinpas millaymi kanman mana tupasqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Saynallataqmi manaraq poqosqa vinotaqa mana ni pipas hich'anmanchu thanta odrekunamanqa. Ichaqa chay vino poqoruspanmi chay thanta odrekunataqa phatarachinman. Hinaspan vinopas usunman, hinallataq odrekunapas manaña ni imapaqpas valenmanñachu. ");
INSERT INTO qveNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Chaymi manaraq poqosqa vinotaqa mosoq odrekunaman hich'ana. ");
INSERT INTO qveNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Pipas poqosqa vinota malliyuspaqa, manañan munanqañachu mana poqosqa vinotaqa. Aswanmi ninman: —Poqosqa vinon aswan allinqa, nispa. Nota: Mana poqosqa vinon rikch'akun Jesuspa yachachisqankunaman. Poqosqa vinoñataqmi rikch'akun Israel nacionniyoq runakunapa ñawpaq mana valeq costumbrenkunaman. Chaymi Diospa palabrankunamanqa costumbrenchiskunataqa mana yapananchishchu. ");
INSERT INTO qveNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Huk samana p'unchawpin, trigo chakraq patanta Jesusqa discipulonkunapiwan pasasharanku. Hinaqtinmi discipulonkunaqa trigota pallaspa makinkuwan qaqorispa mikhuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Chay ruwasqankuta rikuspan, fariseo religionniyoq runakunaqa, khaynata niranku: —Qankunari, ¿imanaqtintaq samana p'unchawpiri mana permitisqa kaqkunata ruwashankichís? ¡Manan saynataqa Moisespa escribisqan leyman hinaqa samana p'unchawpiqa ruwanaykichishchu! nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesusñataqmi contestaspa niran: —¿Manachu qankuna Bibliapi leerankichis, rey Davidqa puriqmasinkunapiwan yarqachikuspa imatachus ruwasqanmanta? ");
INSERT INTO qveNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Rey Davidqa, Diosta yupaychana wasiman haykuspanmi, Diosman dedicasqa t'antakunata orqomuspa mikhuran, saynallataqmi puriqmasinkunamanpas qollarantaq. Chay t'antakunaqa sacerdotekunapa mikhunallanpaqmi permitisqa karan. ");
INSERT INTO qveNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Noqa Diosmanta Hamuq Runaqa samana p'unchawpapas dueñonmi kani. Chaymi munasqayta ruwanankupaq kamachini, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Jesusqa huk samana p'unchawpin Diosmanta yachachina sinagoga wasiman haykuran yachachinanpaq. Chaypin huk runa kasqa mana valeq phaña makiyoq. ");
INSERT INTO qveNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Chaymi leykunata yachachiq runakunaqa, fariseo religionniyoq runakunapiwan ima, Jesusta disimulawlla qawaranku, sichus chay mana valeq makiyoq runata chay samana p'unchawpi sanoyarachiqtinqa, chayman tumpalla acusanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesusñataqmi paykunapa piensasqankuta yachaspa, chay mana valeq makiyoq runata khaynata niran: —Hatarimuy, hinaspa chawpinkupi sayay, nispa. Chaymi chay runaqa hatarimuspa chawpinkupi sayaran. ");
INSERT INTO qveNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Hinaqtinmi llapallan chaypi kaq runakunata Jesusqa niran: —Kunanmi huk tapukuyta tapusqaykichis: Samana p'unchawpiri, ¿allin kaqtachu icha mana allin kaqtachu ruwana? ¿Runa sanoyachiychu icha wañuchiychu allin kanman? nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Chaymantan llapallan runakunata qawarispa, Jesusqa chay mana valeq makiyoq runata niran: —Chay mana valeq makiykita chutariy, nispa. Chaymi makinqa chutariqtin kasqan ratolla sanoyaran. ");
INSERT INTO qveNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Chaymi leykunata yachachikuqkunapas, hinallataq fariseo religionniyoq runakunapas nishuta phiñakuranku. Hinaspan parlanakuranku: —¿Imatan Jesuspa contranpi ruwarusunchis? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Chay p'unchawkunapin Jesusqa riran huk alto moqoman Diosmanta mañakuq. Chaypin enteron tuta Diosmanta mañakuran. ");
INSERT INTO qveNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Achiqaramuqtinñataqmi Jesusqa llapallan qatikuqnin runakunata waqyaran. Hinaspan paykuna ukhumanta akllaran chunka ishkayniyoq runakunata, apostolninkuna kananpaq. ");
INSERT INTO qveNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Paykunapa sutinkun karan kaykuna: Simón, paypa huknin sutinmi karan Pedro, Simón Pedropa wawqen Andrés, Jacobo, Juan; Felipe; Bartolomé; ");
INSERT INTO qveNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo; Tomás; Alfeopa wawan Jacobo, paypa huknin sutinmi karan Santiago, Simón. Paymi karan Zelote partidomanta; ");
INSERT INTO qveNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jacobopa wawqen Judas, hinallataq Judas Iscariote ima. Kay Judas Iscarioten Jesusta traicionaran. Nota: Zelote partidomanta runakunaqa manan munarankuchu Israel nación llaqtankupi Roma llaqtamanta hamuq runakuna kamachinantaqa. Aswanmi munaranku Israel nacionniyoq llaqtamasinku runakuna gobiernanankuta. Chaymi paykunaqa hatariranku, Romamanta kamachikamuq autoridadkunapa contranpi, saynapi Israel nación llaqtankuta defiendenankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Chay moqomantan Jesusqa chunka ishkayniyoq apostolninkunapiwan urayamuran. Hinaspan riranku huk pampaman. Chaymanmi ashka runakuna huñunakamuranku Judea provincia lawmanta, Jerusalén llaqtamanta, hinallataq Tiro llaqtapa, hinaspa Sidón llaqtapa ladon llaqtakunamantawan ima. Paykunan hamuranku Jesuspa yachachisqanta uyarinankupaq, hinallataq onqoyninkumantapas sanoyachisqa kanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Saynapin onqosqa runakunapas, hinallataq demoniokunapa ñak'arichisqan runakunapas sanoyasqa karanku. ");
INSERT INTO qveNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Chaymi llapallan runakunaqa Jesusta tupayuytapuni munaranku, atiyninwan sanoyachisqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesusqa discipulonkunata qawarispanmi khaynata niran: —Kusisqan kankichis wakcha runakunaqa; qankunan Diospa kasqanpi kawsankichis, pay sumaqta gobiernaqtin. ");
INSERT INTO qveNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kusisqan kankichis yarqaypi kunan kaqkunaqa; qankunan qepa tiempopiqa saqsachisqa kankichis. Kusisqan kankichis kunan waqaqkunaqa; qankunan qepa tiempopiqa kusikuymanta asikunkichis. ");
INSERT INTO qveNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kusisqan kankichis Diospa Wawanpi creesqaykichisrayku cheqnisuqtiykichis, despreciasuqtiykichis, k'amisuqtiykichis, hinallataq qankunamanta millayta rimaqtinkupas. ");
INSERT INTO qveNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Saynatan kay millay rimaq runakunapa ñawpaq abuelonkunapas rimaranku, Diosmanta willakuq ñawpaq profetakunapa contranpi. Chaykunata ruwasuqtiykichisqa kusikuychisyá. Kusikuspa saltaychis; premioykichistan chashkikunkichis hanaq pachapi, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","(Ichaqa chaypi wakin runakunata qawarispanmi Jesusqa nillarantaq:) —¡Ay, qapaqkuna! ¡Imaynaraq kankichis! Ñan qankunaqa qapaq kayniykichiswan kusirukunkichishña. ");
INSERT INTO qveNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","¡Ay, saqsasqa kaqkuna! ¡Imaynaraq kankichis! Chayamunqan tiempo yarqasqa kayta yachanaykichispaq. ¡Ay, kunan asikuqkuna! ¡Imaynaraq kankichis! Llakikuy chayamuqtinmi waqaspa qaparqachankichis. ");
INSERT INTO qveNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","¡Ay, imaynaraq kankichis runakuna alabasuqtiykichis! Saynatan qankunapa ñawpaq abueloykichiskunapas ñawpaq falso profetakunata alabaranku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jesusqa nillarantaqmi khaynata: —Qankunayá kay nisqaykunata allinta uyariwaychis: Enemigoykichis runakunata khuyakuychis; cheqnisuqniykichis runakunapaqpas allin kaqkunata ruwaychis; ");
INSERT INTO qveNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ñakasuqniykichis runakunatapas allinta contestaychis; hinallataq yanqamanta tumpasuqniykichis runakunapaqpas Diosmanta mañapuychis. ");
INSERT INTO qveNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Pipas uyaykipi saqmasuqtiykiqa, huknin uyaykitawan kutirichiy. Hinallataq pipas capaykita qechusuqtiykiqa, camisaykitawan qoykuy apakunanpaq. ");
INSERT INTO qveNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Pipas mañakusunki imaykitapas chayqa, qoykuyá. Imaykitapas qechusuqtiykiqa, amañayá mañakapuychu. ");
INSERT INTO qveNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Imaynatachus qankunapaq runakuna ruwananta munankichis, saynallatataq qankunapas paykunapaq ruwaychis. ");
INSERT INTO qveNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Sichus khuyakusuqniykichis runakunallata khuyakunkichis chayqa, ¿ima allintataq ruwashankichisrí? Saynataqa huchasapa runakunapas ruwankun. ");
INSERT INTO qveNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Sichus qankunapaq allin kaqkunata ruwaq runakunallapaq, allin kaqkunata qankunapas ruwankichis chayqa, ¿ima allintataq ruwashankichisrí? Saynataqa Diospi mana creeq huchasapa runakunapas ruwankun. ");
INSERT INTO qveNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Sichus imatapas prestankichis interesniyoqta kutichipusuqniykichis runakunallaman chayqa, ¿ima allintataq ruwashankichisrí? Saynataqa huchasapa runakunapas ruwankun. ");
INSERT INTO qveNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Aswanyá qankunaqa enemigoykichis runakunatapas khuyakuychis; hinaspa allin kaqkunata paykunapaq ruwaychis. Manuychispas amayá chay manusqaykichismanta imatapas chashkinaykichisraykullachu. Saynata ruwankichis chayqa, tukuy atiyniyoq Diospa wawankunan kankichis. Chaymi Diosmanta hatun premiota chashkikunkichis. Diosqa khuyapayanmi malvado runakunatapas, hinallataq desagradecido runakunatapas. ");
INSERT INTO qveNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Saynallataqyá qankunapas llapallan runakunata khuyakuychis, imaynan Dios Taytaykichispas llapallan runakunata khuyapayan chay hinata, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jesusqa nillarantaqmi khaynata: —Aman runamasiykichistaqa juzgankichishchu, Diospas qankunataqa ama juzgasunaykichispaq. Runamasiykichistaqa amayá condenaychishchu; chaymi Diospas mana qankunataqa condenasunkichishchu. Qankunaqa runamasiykichistapas perdonaychisyá; chaymi Diospas qankunata perdonasunkichis. ");
INSERT INTO qveNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Runamasiykichismanqa tukuy ima faltaqnintayá qoychis; saynata ruwaqtiykichismi Diospas qankunaman qosunkichis tukuy faltasuqniykichista. Diosqa qosunkichis allin medisqatan, mat'i-mat'iykusparaq, hunt'ay hunt'ataraq. Imaynatan qankuna runamasiykichiswan ruwankichis, saynatan Diospas qankunawan ruwanqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesusqa nillarantaqmi huk willakuytapas: —Huk ñawsa runaqa manan ñawsamasin runataqa pusayta atinmanchu; ishkayninkun ima t'oqomanpas urmayunkuman. ");
INSERT INTO qveNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Yachachisqa runaqa, manan yachachiqnin runamantaqa aswan más yachayniyoqqa kanmanchu. Aswanmi astawan yachaspaña yachachiqnin hina kanqa. ");
INSERT INTO qveNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Qanri, ¿imanaqtintaq runamasiykipa ñawinpi kaq ishutari qawashankí? Qanqa, ¿manachu aswan qawakuwaq ñawiykipi rakhu k'aspi kasqanta? ");
INSERT INTO qveNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ñawiykipi rakhu k'aspi hina kashaqtinri, ¿imaynataq wawqeykitari niwaq: “Wawqéy, ñawiykipi ishuta orqorusqayki”, nisparí? ¡Ishkay uya runa! ¿Manachu aswan primertaqa ñawiykipi rakhu kaq k'aspitaraq orqokuwaq? Chayta ruwaspan allinta rikunki, wawqeykipa ñawinpi ishuta orqonaykipaqqa, nispa. Nota: “Ñawipi ishuqa” rimashan chikallan huchamantan. “Ñawipi rakhu k'aspiñataqmi” rimashan nishu millay hatun huchakunamanta. ");
INSERT INTO qveNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jesusqa nillarantaqmi khaynata: —Allin sach'aqa allintan rurun; mana allin sach'añataqmi mana allintachu rurun. ");
INSERT INTO qveNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kishkayoq sach'amantaqa manan higostaqa pallankuchu, nitaqmi t'ankar kishka sach'amantapas uvastaqa pallankuchu. Sapankama sach'ataqa rurunpin reqsinchis, allinchus icha mana allinchus kasqanta. ");
INSERT INTO qveNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Saynallataqmi runapa sonqonpi allin kaqkuna kaqtinqa, allin kaqkunatan chay runaqa rimanpas hinallataq ruwanpas. Ichaqa runapa sonqonpi mana allinkuna kaqtinqa, mana allinkunallatan chay runaqa rimanpas hinallataq ruwanpas. Runaqa sonqonpi imapas hunt'asqa kasqanmantan riman. ");
INSERT INTO qveNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jesusqa nillarantaqmi khaynata: —¿Imanaqtintaq qankunari, “Señorlláy, Señorlláy” niwashaspa, noqapa kamachisqaykunatari mana ruwankichischú? ");
INSERT INTO qveNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Sichus pipas noqaman ashuykamuwaspa, yachachisqaykunatapas uyarispa kasukuqmi, ");
INSERT INTO qveNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","huk yachayniyoq runamanqa rikch'akun. Paymi wasinta ruwananpaq pampata t'oqospa, rumi hawapi cimientota hatarichin. Chaymi paraqa, wayrantin hinallataq lloqllantin hamuspa, chay wasitaqa mana thuñichiranchu, rumiwan cimentacionnin allin ruwasqa kasqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Aswan noqapa yachachisqaykunata uyarishaspa mana kasukuqmi ichaqa, huk mana yachayniyoq roqro uma runaman rikch'akun. Paymi wasinta hatarichinanpaq t'oqon hawallata, hinaspan allpa hawallapi perqata hatarichin. Chaymi paraqa, wayrantin hinallataq lloqllantin hamuspa, chay wasitaqa q'alata apan, allpa hawallapi ruwasqa kasqanrayku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Runakunaman yachachiyta tukuruspanmi Jesusqa Capernaúm llaqtaman kutipuran. ");
INSERT INTO qveNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Chay llaqtapin tiyaran Roma llaqtamanta soldadokunapa huk jefen. Chay jefepan karan ancha munakusqan serviqnin runa. Chay serviqnin runan nishuta onqospa wañuypa patallanpiña kasharan. ");
INSERT INTO qveNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Hinaqtinmi soldadokunapa jefenqa, Jesusmanta rimasqankuta uyariran. Hinaspan Israel nación llaqtapi wakin kamachiq runakunata Jesuspa kasqanman mandaran, khaynata nimunankupaq: —Ama hina kaychu, favorniykitan merecesaq, wasiyman hamuspaykiyá ancha munakusqay serviqniy runata onqosqanmanta sanoyaykachipuway, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Chaymi chay Israel llaqtapi kamachiq runakunaqa, Jesuspa kasqanman rispanku, chay soldadokunapa jefenpa valekusqanta Jesusman willaranku. Hinaspan paykunaqa anchata ruegakuspanku, Jesusta khaynata niranku: —Ama hina kaychu, soldadokunapa jefenpa mañakusqantayá yanapaykuy. Payqa ancha allin runan. ");
INSERT INTO qveNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Chaymi kay Israel nacionniyoq runakunata khuyakuspa, Diosmanta yachachina sinagoga wasitapas ruwachipuwaranku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Hinaqtinmi chay valekusqankuta uyarispa, Jesusqa paykunawan riran. Chay soldadokunapa jefenpa wasinman manaraq chayashaqtinkutaqmi, chay soldadokunapa jefenqa amigonkunata mandaran, Jesusman khaynata nimunankupaq: —Señorníy, manan necesariochu wasiyman hamunaykipaqqa. ¿Pitaq noqari kani wasiyman haykunaykipaqrí? ");
INSERT INTO qveNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Noqaqa anchata p'enqakuspaymi, mana qanman taripamunaypaq hinachu kani. Ichaqa kunan rato qan rimarillaqtiykin, serviqniyqa sanoyanqa. ");
INSERT INTO qveNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Noqapas jefeykunata kasukuqmi kani; saynallataqmi soldadoykunapas noqapa kamachisqayta ruwan. Chaymi paykunata kamachiqtiy, paykunapas kasuwanku; hukninta: “Riy” niqtiyqa, rinmi; huknintapas: “Hamuy” niqtiyqa, hamunmi. Saynallataqmi serviwaqniy runatapas: “Kayta ruway” niqtiyqa, paypas ruwanmi, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Chay willasqankuta uyarispanmi, Jesusqa chay soldadokunapa jefenpa nimusqanwan admirakuran. Hinaspan paywan kushka riq runakunata khaynata niran: —Manan enteron Israel nación llaqtapipas tariranichu noqapi ancha iñiyniyoq runataqa. Ichaqa kay soldadokunapa jefenmi noqapi ancha iñiyniyoq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Chaymi Jesusman taripaq runakunaqa, soldadokunapa jefenpa wasinman kutiranku. Hinaspan chaypi tariranku chay serviqnin runataqa sanotaña. ");
INSERT INTO qveNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Chaymantan Jesusqa discipulonkunapiwan, hinallataq ashka runakunapiwan ima Naín sutiyoq llaqtaman riranku. ");
INSERT INTO qveNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Hinaspan chay llaqtapa punkunman chayaruspanku, chaypi tuparanku huk wañusqa joventa p'ampanankupaq apashaq runakunawan. Chay wañusqa jovenqa karan huk viudapa sapallan qari wawanmi. Chaymi chay viudata acompañaspanku paywan kushka llaqtamanta ashka runakunapas rishasqaku. ");
INSERT INTO qveNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Hinaqtinmi Jesusqa chay viudapa waqasqanta rikuspa, anchata khuyapayaspa, payta niran: —Ama waqaychu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Saynata nispanmi Jesusqa, chay kallapipi wañusqa joventa apaq runakunaman ashuyuspa, kallapi apasqankuta llamiykuran. Hinaqtinmi wañusqa joventa apaq runakuna sayaykuqtinku, Jesusqa chay wañusqa joventa niran: —Joven, qantan niyki: ¡Hatarimuy! nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Chaymi chay jovenqa kawsarimuspa rimayta qallariran. Hinaqtinmi Jesusqa chay joventa mamitanman entregapuran. ");
INSERT INTO qveNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Llapallan chaypi kaq runakunañataqmi, mancharikuspanku, anchata admirakuranku. Hinaspan Diosta alabayta qallariranku khaynata: —¡Noqanchis ukhupin kashan Diosmanta willakuq profeta runa! ¡Kunanmi Diosqa hamun, akllawasqanchis Israel nacionniyoq runakunata yanapawananchispaq! nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Chaymi enteron Judea provincia lawpi, hinallataq muyuriqnin llaqtakunapipas yacharuranku, wañusqa runata Jesús kawsarichisqanmanta. ");
INSERT INTO qveNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Bautizaq Juanpa discipulonkunan, carcelpi Juan kashaqtin payman riranku, Jesuspa tukuy milagrokuna ruwasqankunamanta willamuq. Chaymi Juanqa ishkay discipulonkunata waqyaspa kamachiran, ");
INSERT INTO qveNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","paykuna rispanku, Jesusta khaynata tapumunankupaq: —¿Qanchu kanki Diosmanta Hamuq Salvawaqniyku icha huktachu suyakusaqkú? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Chaymi Bautizaq Juanpa discipulonkunaqa, Jesuspa kasqanman chayaruspanku khaynata niranku: —Noqaykutaqa Bautizaq Juanmi mandamuwashanku qanta khaynata tapunaykupaq: “¿Qanchu kanki Diosmanta Hamuq Salvawaqniyku icha huktachu suyasaqkú?” nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Chay ratopin, Jesusqa sanoyachiran tukuy ima onqoyniyoq runakunata, ñak'ariypi kaqkunata, demoniopa kamachisqan runakunata, hinallataq ashka ñawsakunatawan ima. ");
INSERT INTO qveNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Chaykunata ruwaruspanmi, Bautizaq Juanpa discipulonkunata Jesusqa contestaran: —Kutispaykichis Bautizaq Juanman willamuychis tukuy rikusqaykichista, hinallataq uyarisqaykichismantawan khaynata: “Ñawsakunan rikun; mana puriqkunan purin; lepra onqoywan ñak'ariqkunan sanoyan; mana uyariqkunan uyarin; wañusqakunan kawsarin. Saynallataqmi wakcha runakunapas Diosmanta allin willakuyta uyarishanku salvasqa kanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Noqapi mana ishkayaspa iñiq runakunaqa, anchatan kusikunqaku”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Chaymanta Bautizaq Juanpa discipulonkuna pasapuqtinkun, Jesusqa yachachiyta qallariran llapallan runakunaman Bautizaq Juanmanta, khaynata: —Qankunari, ¿pi qawaqtaq rirankichis ch'inñeqtarí? ¿Wayrapa apakachasqan mana kallpayoq tiwli-tiwli soqosman rikch'akuq runatachú? ");
INSERT INTO qveNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Icha ¿allin p'achawan p'achasqa runata qawaqchú? Yuyariychisyá, allin p'achawan churakuq runakunaqa qapaq reypa hatun wasinpin tiyanku. ");
INSERT INTO qveNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ichaqa qankunari, ¿pi qawaqtaq rirankichís? ¿Diosmanta willakuq profeta runata qawaqchú? Arí, Bautizaq Juanqa karan Diosmanta willakuq ñawpaq profeta runakunamantapas aswan más importanteraqmi. ");
INSERT INTO qveNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Bautizaq Juanmantan Diosqa palabranpi niwaranña khaynata: “Noqan mandamusaq willakuqniyta, qanpa ñawpaqniykita rispa willamunanpaq. Paymi ñanta allichaq hina, runakunata allinta yachachinqa, chayamuqtiyki sumaqta chashkisunaykikupaq”, nispa Malaquías 3.1. ");
INSERT INTO qveNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Cheqaqtapunin niykichis, kay pachapiqa manan ni pipas naceranchu Bautizaq Juanmanta aswan más importante runaqa. Ichaqa pipas humilde kaspa noqapi creeqmi, Diospa ñawpaqninpiqa aswan más importanteraq Juanmantapas kanqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Hinaqtinmi Bautizaq Juanpa nisqanta uyarispanku, impuesto cobraq runakunapas, hinallataq chaypi kaq llapallan uyariq runakunapas, Juanta valekuspanku, paywan bautizachikuranku. Saynapin paykunaqa kasukuranku Diospa kamachisqankunata. ");
INSERT INTO qveNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ichaqa fariseo religionniyoq runakunañataqmi, leykunata yachachiq runakunapiwan, Diospa kamachisqankunata mana kasukuspanku, Juanwanqa mana bautizachikuyta munarankuchu. ");
INSERT INTO qveNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Saynallataqmi Jesusqa chaypi kaq runakunata nillarantaq: —¿Pimantaq kay tiempopi kawsaq runakunatari comparachiyman? ¿Pimantaq paykunari rikch'akunkú? ");
INSERT INTO qveNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Paykunaqa rikch'akunku plazapi tiyaruspanku pukllaspa waqyanakuq warmakunamanmi. Chay warmakunan khaynata ninakunku: “Quenata tocashaqtiykupas qankunaqa manan tusunkichishchu. Llakisqa takikunata takishaqtiykupas qankunaqa manan waqankichishchu”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Bautizaq Juan hamuspaqa manan vinotapas tomaranchu, nitaqmi mikhunatapas mikhuranchu. Chayta rikuspaykichismi, qankunaqa nirankichis: “Waq runaqa demoniopa kamachisqan runan”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Noqa, Diosmanta Hamuq Runan ichaqa mikhuni, hinaspan vinotapas tomani. Chayta rikuspaykichishñataqmi qankunaqa noqamanta rimankichis: “Payqa mikhuysapan, vinotapas tomakuspan mach'akun; hinaspapas llapallan impuesto cobraqkunapas, hinallataq huchasapa runakunapapas amigonmi”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ichaqa Diospa kamachisqanman hina kawsaq runakunan, allin ruwasqankupi reqsichikunku Diospa wawankuna kasqankuta, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Simonmi karan fariseo religionniyoq runa. Paymi wasinman Jesusta invitaran kushka mikhunankupaq. Chaymi Jesusqa Simonpa wasinman rispa mesapi mikhuq tiyayuran. ");
INSERT INTO qveNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Chay wasipi Jesús kasqanta yacharuspanmi, chay llaqtamanta huk qenlli vidapi puriq huchasapa warmi, Jesuspa kasqanman hamuran. Payqa hamuran huk yuraq rumichamanta ruwasqa p'uyñuchapi sumaq mishk'i perfumeta apayukuspanmi. ");
INSERT INTO qveNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Hinaspan Jesuspa kasqanman ashuyuran. Qonqorikuspataqmi anchata waqaran, Jesuspa chakinta weqenwan apichanankama. Waqayta tukuruspantaqmi Jesuspa chakinta, chukchallanwan secaspa ch'akichiran. Hinaspan Jesuspa chakinkunata much'aspa, chay mishk'i q'apaq perfume apamusqanwan llusiran. ");
INSERT INTO qveNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Chaykunata rikuspanmi, chay wasiyoq Simonqa piensaran khaynata: “Cheqaqtapuni Diosmanta willakuq profeta runa kaspanqa, yachanmanchá pis kay huchasapa warmi kasqantaqa”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Chaymi Jesusqa chay fariseo religionniyoq Simonta niran: —Simón, qanmanmi willasqayki huk willakuyta, nispa. Chaymi Simonqa contestaran: —Yachachikuq, niwayá chay willakuyta, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Hinaqtinmi Jesusqa willaran huk willakuyta khaynata: —Ishkay runakunan qolqeta deberanku prestaqninku runaman. Hukninmi pishqa pachaq qolqeta deberan; hukninñataqmi pishqa chunka qolqellata deberan. ");
INSERT INTO qveNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Hinaspan prestaqninku runaman paykunaqa mana pagapuyta atirankuchu. Chaymi chay qolqe prestaq runaqa paykunata perdonaspa manaña cobraranñachu. Kunan tapusqayki kay willakuymanta, ¿ima ninkitaq qanrí? ¿Mayqentaq chay ishkay runakunamanta aswan masta khuyakunman chay perdonaqnin runatarí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Chaymi chay fariseo religionniyoq Simonqa contestaran: —Noqapa piensayniymantaqa, aswan mastaqa khuyakunman pishqa pachaq qolqeta debeqmi, nispa. Hinaqtinmi Jesusqa niran: —Allinmi nisqaykiqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Hinaqtinmi Jesusqa chay huchasapa warmita qawarispa Simontaqa niran: —¿Rikushankichu kay warmita? Qanpa wasiykiman haykumuqtiymi, mana ni unullatapas qowarankichu chakiy maqchikunaypaqqa. Kay warmin ichaqa, weqellanwan chakiykunata maqchin. Chukchanwantaq secaspa sumaqta chakiykunata ch'akichin. ");
INSERT INTO qveNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Qanqa wasiykiman chayamuqtiypas manan much'aykuwarankichu. Kay warmin ichaqa wasiykiman haykumusqaymantapacha chakiykunata much'ashan. Nota: Israel nación llaqtapiqa qarikunapas much'aywanmi saludanakuranku; ichaqa kay llaqtanchiskunapiqa manan saynatachu saludanakunchis. ");
INSERT INTO qveNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Qanqa manan ni aceitellawanpas umayta llusiwarankichu. Kay warmin ichaqa mishk'i q'apaq perfumewan sumaqta chakiykunata llusiyun. ");
INSERT INTO qveNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kay warmiqa ashka huchankuna perdonasqaña kasqantan yachan. Chaymi payqa anchata khuyakuwan noqataqa. Ichaqa pisilla huchankunata perdonasqa kaqmi, pisillata khuyakun, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Saynata nispanmi, Jesusqa chay warmitañataq niran: —Llapallan huchaykikunan perdonasqaña, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Chayta uyarispankun chaypi kaq wakin runakunaqa tapunakuyta qallariranku: —¿Pitaq kay runari, runakunapa huchankunata perdonananpaqrí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesusmi ichaqa chay warmita niran: —Qanqa, noqapi iñisqaykiraykun salvasqaña kanki. Ripuy hawkalla, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Chaymantañataqmi Jesusqa chunka ishkayniyoq akllasqan discipulonkunapiwan riran ashka llaqtakunaman, hinallataq taksa llaqtachakunamanwan ima. Chaykunapin Jesusqa Diospa gobiernanan sumaq glorianmanta willakuran. ");
INSERT INTO qveNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Jesuswanqa rillarankutaqmi warmikunapas. Chay warmikunamantan, Jesusqa wakinmanta demoniokunata qarqoran, wakin warmikunatataqmi onqoyninkumanta sanoyachiran. Chay warmikunamanta hukninmi karan: María; paytan suticharanku Magdalenawan, Magdala llaqtamanta kasqanrayku. Paymantan Jesusqa qanchis demoniokunata qarqoran. ");
INSERT INTO qveNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Wakintaqmi karanku: Susana, Juana, hinallataq ashka warmikunapas. Juanaqa karan Chuza sutiyoq runapa warminmi; chay Chuza runaqa karan rey Herodes Antipaspa kamachin ruwaq mayordomo runan. Chay warmikunan Jesusta hinallataq discipulonkunatapas yanaparanku tukuy kaqninkuwan. ");
INSERT INTO qveNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Sapankama llaqtakunamantan ashka runakuna Jesuspa kasqanman huñunakamuranku. Hinaqtinmi Jesusqa paykunaman huk willakuyta willaran: ");
INSERT INTO qveNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Huk runan chakranman trigo t'akaq riran. Chaypi t'akashaqtinmi wakin trigoqa ñanman urmaran. Hinaqtinmi chay ñanninta puriq runakunaqa sarutamuranku; hinallataq pichinkukunapas pallakuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Wakin trigoñataqmi ranra-ranraman urmaran. Chaylla wiñaramuspantaqmi chay trigoqa mana allpa kasqanrayku ch'akipuran. ");
INSERT INTO qveNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Wakin trigoñataqmi kishka-kishka ukhukunaman urmaran. Chaymi chay kishkakuna trigomanta masta wiñaspa taparuqtin, chay trigoqa q'elloyaspa ch'akipuran. ");
INSERT INTO qveNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Wakin trigoñataqmi ichaqa, allin wanu allpaman urmaran. Chaymi chay trigoqa sumaqta wiñamuran; hinaspan sapankama mukhuqa pachaqta rururan, nispa. Chayta willaspanmi Jesusqa altomanta rimarispa niran: —¡Sichus cheqaqtapuni ninriyoq kankichis chayqa, allintayá uyariychis kay nisqaykunata! nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jesús kaykunata willaqtinmi discipulonkunaqa tapuranku: —¿Ima ninantataq nin kay willakusqaykirí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Chaymi Jesusqa contestaran khaynata: —Qankunallamanmi yachachishaykichis Diospa sumaq gobiernananmantaqa. Chaykunaqa pakasqa hinan karan. Chaymi mana ni pipas entiendeytaqa atirankuchu (noqapi mana creesqankurayku). Chayraykun noqapi mana creey munaq runakunamanqa yachachini ejemplokunallawan, saynapi rikushaspankupas mana rikunankupaq, hinallataq uyarishaspankupas mana entiendenankupaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Jesusmi discipulonkunaman yachachiran trigo t'akaq runamanta khaynata: —Trigo mukhuqa Diospa palabranmi. ");
INSERT INTO qveNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ñanman urmaq mukhuqa Diospa palabranmi. Chay ñanpi allpañataqmi rikch'akun Diospa palabranta uyariq rumi sonqo runakunaman. Ichaqa diablo hamuspanñataqmi Diospa palabran uyarisqankuta qonqachin, saynapi Diospi mana creenankupaq, hinallataq mana salvasqa kanankupaq ima. ");
INSERT INTO qveNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ranra-ranraman urmaq mukhuqa Diospa palabranmi. Chay ranra-ranra ukhupi allpañataqmi rikch'akun Diospa palabranta kusikuywan chashkikuq runakunaman. Paykunan mana allinta entiendespanku pisi tiempollapaq Diospi creenku; hinaspa sasachakuy p'unchawkuna hamuqtintaq Diosmanta karunchakunku. ");
INSERT INTO qveNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kishka-kishkaman urmaq mukhuqa Diospa palabranmi. Chay kishka-kishka ukhupi allpañataqmi rikch'akun Diospa palabranta uyariq runakunaman. Paykunaqa Diospa palabrata uyarishaspankupas manan kasukunkuchu. Aswanmi afanasqallaña qolqe mashkaypi purinku. Saynallataqmi kay pachapipas kusikuykunallapi kawsanku. Saynata kawsaspankun chay runakunaqa mana wiñaq kanku, nitaq rurunkupashchu. ");
INSERT INTO qveNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mukhuq urmasqan allin allpaqa Diospa palabranta allinta uyariq runakunan kanku. Paykunan ichaqa Diospa palabranta chashkikunku tukuy sonqonkuwan. Kasukuspankutaqmi huchamanpas mana urmaspanku kusikuy sonqonkuwan Diosta qatikunku. Hinaspan paykunaqa allin trigo hina sumaqta rurunkupas, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jesusqa nillarantaqmi khaynata: —Manan ni pipas mecherotaqa ratachin mankawan tapananpaqchu, nitaqmi puñunan catrepa pachanman churananpaqchu. Aswanqa alto patamanmi churan, chaymanta wasiman llapallan haykuq runakunata allinta k'anchamunanpaq. ");
INSERT INTO qveNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Saynallataqmi llapallan runakunapa sonqonpi tukuy ima pakasqa kaqkunapas, hinallataq tukuy ima piensasqankupas yachasqa kanqa. ");
INSERT INTO qveNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Chayraykuyá, qankunapas allinta uyarispa entiendeychis. Pipas Diospa yachachikuyninta allinta uyarinqa chayqa, Diosmi payman astawanraq yachayta qonqa. Ichaqa, noqapi mana creey munaq runakunamantan, Diospuni qechunqa pisilla yachasqankutapas, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesuspa wawqenkunan mamitankupiwan hamuranku Jesuspa kasqanman. Ichaqa manan Jesusman ashuyuytaqa atirankuchu muyuriqnintinpi ashka runakuna kasqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Hinaqtinmi chaypi kaq huk runa Jesusman willaran: —Mamitaykin wawqeykikunapiwan hawapi kashanku. Paykunan qanwan parlayta munanku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Hinaqtinmi Jesusqa contestaran: —Mamitaypas wawqeykunapas Diospa palabranta uyariqkunan, hinallataq Diosta kasukuq llapallan runakunan kanku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Huk p'unchawmi Jesusqa discipulonkunapiwan qespiranku hatun laguna qochapi huk boteman. Hinaspan Jesusqa paykunata niran: —Hakuchi kay laguna qochapa waq law chimpanman, nispa. Hinaqtinmi paykunaqa riranku. ");
INSERT INTO qveNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Botepi rishaqtinkuñataqmi Jesusqa puñururan. Hinaspan qonqayllamanta nishuta wayra-wayramuqtin, chay hatun laguna qochapi unuqa altoman qallchikamuran. Chaymi risqanku boteman unu hunt'ayta qallariqtin, paykunaqa yaqaña unu ukhuman chinkaykusharanku. ");
INSERT INTO qveNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Hinaqtinmi Jesuspa discipulonkunaqa nishuta mancharikuspanku, Jesusta rikch'achiranku khaynata nispanku: —¡Señor, Señor, unu ukhumanmi chinkayushanchishña! nispanku. Jesusñataqmi rikch'arimuspa nishu wayrata, hinallataq laguna qochapi qallchikamuq unutawan kamachiran thañinanpaq. Chaymi kasqan ratolla wayrapas unupas thañiran. ");
INSERT INTO qveNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Hinaqtinmi Jesusqa discipulonkunata niran: —¿Imanaqtintaq qankunari noqapi mana confiankichishchú? nispa. Paykunataqmi admirasqallaña anchata mancharikuspanku ninakuranku: —¿Imayna runañataq kay runarí, pay kamachiqtin, wayrapas, unupas kasukunanpaqrí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jesusmi discipulonkunapiwan kushka chayaranku Galilea laguna qochapa chimpan Gadara lugarman. Nota: Gadara llaqtapa huknin sutinqa Gerasan. ");
INSERT INTO qveNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Botemanta Jesús urayushaqtinmi, huk runa ashka demoniokunapa kamachisqan chay Gadara llaqtamanta lloqsimuspa Jesusman ashuyamuran. Chay runaqa unayñan q'alalla puriran; nitaqmi wasipichu tiyaranpas; aswanmi payqa alma p'ampananku panteonllapi tiyaran. ");
INSERT INTO qveNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jesusta rikuruspankun, chay runapi kaq demoniokunaqa qapariranku. Hinaqtinmi chay runaqa Jesuspa ñawpaqninpi qonqorikuran. Chaymi chay demoniokunaqa altota qaparispa niranku: —Tukuy atiyniyoq Diospa Wawan Jesús, ¿imatataq noqaykuwanri munankí? ¡Ruegakuykikun ama ñak'arichiwanaykikupaq! nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Saynataqa qapariranku, Jesús chay runamanta demoniokunata lloqsinanpaq kamachiqtinmi. Hinaspapas demoniokunaqa unayñan ñak'arichiran chay runataqa. Chaymi runakunapas chay runataqa makinkunata chakinkunatawan fierromanta ruwasqa cadenakunawan wataranku. Saynata ruwashaqtinkupas, payqa t'ipiranmi chay cadenawan watasqankutapas; hinaspan chay runaqa demoniokunapa apasqan ch'inñeq desierto lugarkunaman riran. ");
INSERT INTO qveNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Hinaqtinmi Jesusqa tapuran khaynata: —¿Imataq sutiykirí? nispa. Hinaqtinmi contestaran khaynata: —Waranqa waranqantinmi, nispa. Saynataqa niran, ashkallaña demoniokuna chay runapi kasqanraykun. ");
INSERT INTO qveNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Hinaqtinmi chay waranqa waranqantin demoniokunaqa, Jesusta ruegakuranku khaynata: —Amayá ukhu pachamanchu qarqowayku chaypi ñak'arinaykupaq, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Chay ladonku orqopin ashka khuchikuna mikhusharanku. Chayta rikuspankun demoniokunaqa Jesusta ruegakuranku, chay khuchikunapa cuerponman haykunankupaq. Jesusñataqmi “arí”, niran. ");
INSERT INTO qveNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Hinaqtinmi demoniokunaqa chay runamanta lloqsispanku khuchikunapa cuerponman haykuranku. Chaymi chay khuchikunaqa qata urayta p'itaspanku, laguna qochaman urmayuranku. Hinaspan chaypi heq'epaspa wañuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Khuchi michiqkunañataqmi chayta rikuspanku anchata mancharikuspa ayqekuranku. Rispankutaqmi chaykuna rikusqankumanta willakuranku, llaqtapi hinallataq campokunapipas. ");
INSERT INTO qveNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Chaykunata uyariruspankun ashka runakunaqa qawaq riranku. Chayaspankun chay demoniokunapa ñak'arichisqan runataqa tariranku, Jesuspa ñawpaqninpi sanoña tiyashaqta. Hinaspapas allin p'achasqata, hinallataq allin yuyayninpiña kashaqta ima. Chaykunata rikuspankun paykunaqa anchata mancharikuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Hinaspan Jesuspa sanoyachisqanta rikuq runakunaqa, llaqtamanta hamuq runakunaman willakuranku, Jesús imaynatas sanoyachiran chay demoniokunapa ñak'arichisqan runamanta. ");
INSERT INTO qveNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Hinaqtinmi chay Gadara llaqtayoq runakunaqa nishuta mancharikuspanku, Jesusta ruegakuranku chaymanta ripunanpaq. Chaymi Jesusqa boteman wicharan, Galilea provincia llaqtaman kutipunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Manaraq ripushaqtintaqmi, demoniokunapa ñak'arichisqanmanta sanoyaq runaqa, Jesusta ruegakuran paywan kushka rinanpaq. Jesusñataqmi ichaqa khaynata niran: ");
INSERT INTO qveNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Wasiykiman kutipuy; hinaspa willamuy Diospa tukuy ima qanpaq ruwasqankunamanta, nispa. Chaymi chay runaqa llaqtanman ripuspa, llaqtanpi llapallan runakunaman willakachakuran, imakunatachus paypaq Jesús ruwasqanmanta. ");
INSERT INTO qveNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Gadara lugarmantan Jesusqa kutipuran Galilea provincia lawman. Paywan kushkataqmi discipulonkunapas riranku. Chayaruqtinkutaqmi, Jesusta suyaq runakunaqa ancha kusikuywan chashkiranku. ");
INSERT INTO qveNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Hinaqtinmi Diosmanta yachachina sinagoga wasipi kamachiq Jairo sutiyoq runa, Jesusman hamuspa, ñawpaqninpi qonqoriyukuspa, mañakuran wasinman rinanpaq. ");
INSERT INTO qveNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Saynataqa mañakuran sapallan ususin, chunka ishkayniyoq watallayoqraq wañuypa patallanpiña kasqanraykun. Hinaqtinmi Jesusqa Jairopa wasinman riran. Paywan kushkataqmi ashka runakunapas ñit'i-ñit'illaña riranku. ");
INSERT INTO qveNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Hinaqtinmi runakunapa chawpinta huk warmipas risharan. Paymi chunka ishkayniyoq wataña nishuta ñak'ariran yawar apariy onqoywan. Chaymi llapallan qolqentapas tukusqaña ashka medicokunaman hampichikunanpaq rispa; manataqmi mayqen medicopas sanoyachiytaqa atisqachu. ");
INSERT INTO qveNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Chaymi chay warmiqa Jesusman qepallanta ashuyuspa, p'achanpa patallanta tupayuran. Hinaqtinmi kasqan ratolla chay warmiqa yawar apariyninmanta sanoyapuran. ");
INSERT INTO qveNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Hinaqtinmi Jesusñataq muyuriqninpi runakunata tapuran khaynata: —¿Pitaq tupaykaramuwanrí? nispa. Chaymi paykunaqa contestaranku: —Manan noqaykuqa tupaykamuykikuchu, nispanku. Hinaqtinmi Pedroqa paywan kaqkunapiwan niran: —Yachachikuq, ¿manachu rikunki ashka runakuna tukuy lawmanta tanqanakamuspa ñit'imususqaykita? nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesusñataqmi kaqmanta niran: —Pichá qankuna ukhumanta tupaykaramuwan. Cuentatan qokuni noqamanta atiyniy lloqsisqanta, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Chaymi chay warmiqa manaña pakakuyta atispa, khatatatayuspa, Jesusman ashuyuspa ñawpaqninpi qonqoriyukuran. Hinaspan llapallan runakuna uyarishaqtinku willakuran, onqosqa kasqanrayku Jesusta tupayusqanmanta, hinallataq kasqan ratolla sanoyasqanmantawan ima. ");
INSERT INTO qveNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Chayta uyarispanmi Jesusqa chay warmita niran: —Wawalláy, noqapi creesqaykiraykun qanqa sanoña kashanki. Kunanqa hawkalla ripuy, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesús manaraq rimayta tukushaqtinmi, Jairopa wasinmanta huk runa hamuspa, Jairota niran: —Ususiykiqa ñan wañurukunña. Amaña yachachikuqtaqa wasiykimanqa pusayñachu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Chayta uyarispanmi Jesusqa Jairota niran: —Ama qanqa llakikuychu. Creellay noqapi, ususiykiqa kawsarillanqan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jesusqa Jairopa wasinman chayaruspanmi, wañuq sipaspa kasqanman haykuchiran discipulonkunamanta Pedrota, Jacobota, Juanta, hinallataq wañuq sipaspa tayta mamantawan ima. Wakin runakuna haykunantaqa manan munaranchu. ");
INSERT INTO qveNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ichaqa runakunañataqmi wañuq sipasmanta llakikuspanku nishuta waqashasqaku. Chaymi Jesusqa chaypi waqaqkunata niran: —¡Ama waqaychishchu! Manan wañusqachu kashan, aswanqa puñullashanmi, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Hinaqtinmi chaypi kaq runakunaqa Jesusmanta burlakuranku, sipasqa wañusqaña kasqanta yachasqankurayku. ");
INSERT INTO qveNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jesusñataqmi wañuq sipaspa makinta hap'iyuspa, altota rimaspa niran: —¡Sipas, hatariy! nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Chaymi espiritun kutiykapuqtin, chay wañusqa sipasqa kawsarimuspa kasqan ratolla hatarimuran. Hinaqtinmi chaypi kaq runakunata Jesusqa kamachiran sipasman mikhunata qonankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Chayta rikuspankun kawsarimuq sipaspa tayta mamanqa anchata admirakuranku. Hinaqtinmi Jesusqa paykunata kamachiran, rikusqankuta pimanpas ama willanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesusmi huñuran chunka ishkayniyoq akllasqan discipulonkunata. Hinaspan paykunaman atiyta qoran onqosqakunata sanoyachinankupaq, saynallataq demoniokunatapas kamachispanku runakunamanta qarqomunankupaq ima. ");
INSERT INTO qveNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Hinaspan paykunataqa onqosqakunata sanoyachimunankupaq mandaran, hinallataq llapallan runakunaman Diospa gobiernanan sumaq glorianmanta willamunankupaq ima. ");
INSERT INTO qveNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Chaymantapas paykunataqa nillarantaqmi khaynata: —Ñanniykichispaqqa, aman apankichishchu bastontapas, q'epitapas, qoqawtapas, t'antatapas, qolqetapas, nitaq p'achatapas cambiakunaykichispaqqa. ");
INSERT INTO qveNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Mayqen wasiman chayaqtiykichispas, sichus “pasayakamuy” nisuqtiykichisqa, chay wasipiyá samapakunkichis, chay llaqtamanta ripunaykichiskama. ");
INSERT INTO qveNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Hinallataq mayqen llaqtapipas mana samachisunkichishchu chayqa, chay llaqtamanta lloqsispaykichisyá husut'aykichispi allpatapas thaptirikuspa huk lawman ripuychis, saynapi mana allin runakuna kasqankuta paykuna yachakunankupaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Saynata Jesús niqtinmi discipulonkunaqa llapallan llaqtakunaman riranku, Diosmanta allin willakuykunata willakuspanku, hinallataq onqosqa runakunatapas sanoyachispanku ima. ");
INSERT INTO qveNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Jesuspa tukuy ima ruwasqankunata yachaspankun runakunaqa rimaranku khaynata: —Payqa Bautizaq Juanmi kawsariramun, nispanku. Chaykunata yacharuspanmi kamachiq rey Herodes Antipasqa, anchata preocupakuran. ");
INSERT INTO qveNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Wakin runakunapas nillarankutaqmi: —Diosmanta willakuq ñawpaq profeta Eliasmi rikhuriramun, nispanku. Huk runakunañataqmi khaynata niranku: —Diosmanta willakuq mayqen profetapashchá kawsariramun, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes Antipasñataqmi tapukuran: —¿Pitaq chay runari, paymanta llapallan runakuna rimanankupaqrí? Manan Bautizaq Juanqa kanmanchu. Noqa kikiypunin kamachirani, Juanpa kunkanta kuchuspa wañuchinankupaqqa, nispa. Chayraykun Herodes Antipasqa reqsiytapuni munaran Jesusta. ");
INSERT INTO qveNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jesuspa chunka ishkayniyoq apostolninkunan, llaqtakunaman risqankumanta kutimuspanku, tukuy ima ruwamusqankumanta Jesusman willaranku. Chaymantañataqmi Jesusqa paykunallata pusarikuspa, Betsaida sutiyoq llaqtaman riran, chaypi paykunapuralla kanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ichaqa runakunañataqmi, Jesusqa apostolninkunapiwan Betsaida llaqtaman risqanta yacharuspanku, paykunapa qepanta riranku. Hinaqtinmi Jesusqa chay runakunata chashkispa, paykunata yachachiran Diospa sumaq gobiernananmanta. Saynallataqmi sanoyachillarantaq onqosqa runakunatapas. ");
INSERT INTO qveNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tardeña kashaqtintaqmi chunka ishkayniyoq apostolninkunaqa Jesusman ashuyuspa khaynata niranku: —Despedipullayña kay runakunataqa enteron muyuriqninchispi llaqtakunaman, chaypi mikhunata mashkakamunankupaq, hinallataq puñupakamunankupaq ima. Kaypiqa manan imatapas tarinkumanchu mikhunankupaqqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Chaymi Jesusqa apostolninkunata contestaran: —Qankunayá mikhunata qoychis, nispa. Hinaqtinmi apostolninkunaqa niranku: —Noqaykupaqa pishqa t'antawan, ishkay kankasqa challwallaykupiwanmi kashan. Chayllaqa kay llapallan runamanqa manan aypanmanchu. ¿Icha mikhuna rantiqchu llaqtata risaqkú? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Chaypiqa pishqa waranqa runamantapas aswan masraqmi karanku, chaypas qarikunallata yupaspa. Chayta uyarispanmi Jesusqa apostolninkunata khaynata niran: —Llapallan runakunata tiyachimuychis grupo-grupopi, sapankama grupopi pishqa chunka runakunata, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Chaymi apostolninkunaqa llapallan runakunata Jesuspa nisqanman hina tiyachiranku. ");
INSERT INTO qveNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Hinaqtinmi Jesusqa pishqantin t'antata, ishkaynin challwatawan hap'iyuspa, hanaq pachata qawarispa Diosman graciasta qoran. Chaymantan t'antata, challwatawan partiyuspa apostolninkunaman qoran. Paykunañataqmi llapallan chaypi kaq runakunaman rakimuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Hinaqtinmi llapallan runakuna mikhuranku saqsanankukama. Mikhuyta tukuruqtinkutaqmi chunka ishkayniyoq canasta hunt'ataraq puchuqkunatapas huñumuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Jesusqa sapallanmi Diosmanta mañakusharan. Hinaqtinmi discipulonkunaqa Jesusman ashuyuranku. Chaymi Jesusqa paykunata tapuran khaynata: —¿Pitaq noqari kani runakunapaqrí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Chaymi discipulonkunaqa contestaranku: —Wakinmi ninku: “Bautizaq Juanmi”, nispanku. Wakintaqmi ninku: “Ñawpaq profeta Eliasmi”, nispanku. Huk runakunañataqmi ninku: “Mayqen profetachá kawsariramun”, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jesusñataqmi discipulonkunapa nisqankuta uyarispa khaynata tapuran: —Qankunari, ¿ima ninkichistaq? ¿Pitaq noqari kani qankunapaq? nispa. Hinaqtinmi Pedroqa niran: —Qanqa kanki Diosmanta Hamuq Salvadorniyku Criston, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesusmi discipulonkunata kamachiran khaynata: —Aman qankunaqa pimanpas willankichishchu, Diosmanta Hamuq Salvador Cristo kasqaytaqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Hinaspapas Jesusqa nillarantaqmi khaynata: —Diosmanta Hamuq Runataqa nishutan ñak'arichiwanqaku, kay Israel nación llaqtapi kamachiq jefekuna, sinagoga wasipi kamachiq sacerdotekuna, hinallataq leykunata yachachiq runakunapiwan ima. Paykunan cheqnikuwaspanku wañuchiwanqaku. Saynata wañuchiwaqtinkupas kinsa p'unchawmantan noqaqa kawsarinpusaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Saynallataqmi Jesusqa llapallan chaypi kaq runakunata nillarantaq: —Sichus pipas noqapa discipuloy kayta munaspaqa, qonqananmi kikinpa munasqanman hina imatapas ruwayta. Hinaspapas sapa p'unchawña sasachakuykuna chayamuqtinpas, noqapi creesqanraykun listo kanan ñak'arinanpaq. Hinallataqmi sapa p'unchaw kamachisqaykunata ruwanan. ");
INSERT INTO qveNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Pipas kay pachapi payllapaq kawsay munaqqa, wiñaypaqmi wañunqa. Ichaqa pipas noqapi creesqanrayku wañuqmi, wiñaypaq kawsanqa. ");
INSERT INTO qveNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ichaqa kay pachapi tukuy ima kaqniyoq kayqa, manan sirvinchu salvasqa kanapaqqa. Sichus pipas kay pachapi qapaq kashaspa, huchallapi kawsanqa chayqa, wiñaypaqmi chinkachisqa kanqa. ");
INSERT INTO qveNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Pipas noqa Diosmanta Hamuq Runamanta hinallataq yachachisqaykunamantapas p'enqakunqa chayqa, noqapas p'enqakullasaqtaqmi chay runamantaqa. Kaykunaqa pasanqa Diospa atiyninwan, hinallataq angelninkunapiwan kushka kay pachaman kutimuqtiymi. ");
INSERT INTO qveNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Cheqaqtapunin niykichis, wakin kaypi kaqkunaqa manaraqmi wañunqakuchu, Diospa sumaq gobiernasqanta rikunankukama, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Chaykuna rimasqanmanta pusaq p'unchaw hinaña pasaruqtinmi, Jesusqa discipulon Pedrowan, Juanwan hinallataq Jacobowan ima, huk orqoman riran, Diosman chaypi orakunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Chaypi mañakushaqtinmi, Jesuspa uyanqa qonqayllamanta huk niraqman tukuran. Hinallataqmi p'achanpas sumaq k'ancharishaq yuraqman tukuran. ");
INSERT INTO qveNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Hinaqtinmi qonqayllamanta chaypi rikhuriranku, Diosmanta yachachiq Moiseswan, hinallataq ñawpaq profeta Eliaspiwan ima. Hinaspan paykunaqa Jesuswan parlaranku. ");
INSERT INTO qveNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Moisespas hinallataq Eliaspas muyuriqninkupi hanaq pachamanta k'anchaywan muyurisqan rikhuriranku. Hinaspan Jesuswan parlaranku, imaynatas Jerusalén llaqtapi Jesús wañuchisqa kananmanta, hinallataq kawsarimuspa hanaq pachaman ripunanmantawan ima. ");
INSERT INTO qveNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Hinaqtinmi Pedroqa paywan kushka kaqkunapiwan anchata puñuywan aysachikuspanku puñuy puñusharankuña. Hinaspan qonqayllamanta rikch'arispanku, Jesustaqa Moisestawan, hinallataq ñawpaq profeta Eliastawan kushkata, Diospa sumaq k'anchayninwan muyurichisqata rikuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Chaypin Moisesqa, Eliaspiwan ña ripunankupaqña kashaqtinku, Pedroqa Jesusta khaynata niran: —Yachachikuq ¡allinmi kaypi kasqaykuqa! Munaqtiykiqa, kinsa ramadatayá ruwarusaqku: hukninta qanpaq, hukninta Moisespaq, huknintataq Eliaspaq, nispa. Pedroqa chaykunataqa rimaran mana allinta piensarispanmi. ");
INSERT INTO qveNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Chaykunata Pedro rimashaqtinmi, huk phuyu urayamuspa paykunata tapaykuran. Chayta rikuspankun Jesuspa kinsantin discipulonkunaqa anchata mancharikuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Hinaqtinmi phuyu ukhumanta Diospa rimamusqanta, paykunaqa uyariranku khaynata: —¡Paymi munakusqay Wawáy! Qankunaqa payta uyarispayá kasukuychis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Chay rimamusqanta uyariruspankun, Jesuspa kinsantin discipulonkunaqa manaña rikurankuchu chay ishkaynin qarikunataqa. Aswanmi Jesustaqa sapallantaña rikuranku. Chaykuna rikusqankutan paykunaqa chay p'unchawkunapi mana ni pimanpas willarankuchu. ");
INSERT INTO qveNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Paqarisnintin p'unchawmi Jesusqa orqomanta kutimuran kinsantin discipulonkunapiwan. Hinaqtinmi ashka runakunaqa chayta yacharuspanku, Jesuspa kasqanman hamuranku paywan tupanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Hinaqtinmi huk runa llapallan runakunapa chawpinmanta qaparimuspa Jesusta valekuran khaynata: —Yachachikuq, ruegakuykin kay sapallan qari wawayta qawaykapuwanaykipaq. ");
INSERT INTO qveNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Paytan huk demonio qonqayllamanta qaparichin paypi kasqanrayku; hinallataq anchata khatatatachin; saynallataqmi simimantapas posoqotaraq aqtuchin. Saynata ñak'arichispanmi sasallataña kacharin. ");
INSERT INTO qveNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Chaymi noqaqa discipuloykikunata ruegakurani, chay demoniota qarqonankupaq. Ichaqa manataqmi qarqoyta atirankuchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Chaymi Jesusqa niran: —¡Ay, Diospi mana creeq huchallapi kawsaq saqra runakuna! ¿Hayk'aqkamataq noqari qankunawan kasaq? ¿Hayk'aqkamataq soportasqaykichisrí? nispa. Saynata nispanmi Jesusqa chay runata niran: —¡Wawaykita kayman apamuy! nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Hinaqtinmi chay jovenqa Jesusman ashuyamuran. Chaymi qonqayllamanta demonioqa pampaman joventa wikapaspa, pampapi qospachiran. Hinaqtinmi Jesusqa chay demoniota q'aqchaspa, rimayllanwan qarqoran. Hinaspan chay joventaqa papanman sanotaña entregapuran. ");
INSERT INTO qveNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Chaypi kaq runakunañataqmi Diospa ruwasqankunata rikuspanku, anchata admirakuranku. Jesuspa tukuy ima ruwasqankunawanmi, runakunaqa ancha admirasqallaña kasharanku. Hinaqtinmi Jesusqa discipulonkunata khaynata niran: ");
INSERT INTO qveNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Allinta uyariychis kay nisqayta. Noqa, Diosmanta Hamuq Runaqa, cheqniwaqniy runakunamanmi entregasqa kasaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ichaqa paywan kaq discipulonkunaqa manan entienderankuchu, Jesuspa rimasqankunaqa pakasqa hina kasqanrayku. Hinaqtinmi paykunaqa mancharikuspanku mana tapurankuchu ima ninantas Jesús niran chayta. ");
INSERT INTO qveNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Huk p'unchawmi Jesuspa discipulonkunaqa discutinakuranku, mayqenninkus paykuna ukhumanta aswan más importante kanankumanta. ");
INSERT INTO qveNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Chaymi Jesusqa discipulonkunapa piensasqanta yachaspa, huk warmachata waqyaran. Ladonpi sayaykachispataqmi, ");
INSERT INTO qveNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","paykunata khaynata niran: —Pipas kay warmachata sutiypi chashkiqqa, noqatan chashkiwan. Hinallataq pipas noqata chashkiwaqqa, hanaq pachamanta mandamuwaqniy Dios Taytaytan chashkin. Qankuna ukhumanta mayqenniykichispas humilde kaqmi, aswan más importante kanqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jesuspa discipulon Juanmi khaynata niran: —Yachachikuq, huk runatan rikuramuyku qanpa sutiykipi runakunamanta demoniokunata qarqoshaqta. Chaymi noqaykuqa prohibimuyku noqanchis partemanta mana kashaspaqa, sutiykipi chaykunata ama ruwananpaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Chayta uyarispanmi Jesusqa niran: —Ama saynataqa prohibiychishchu. Pipas mana contranchispi kaqqa, favorninchispin kashan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Hanaq pachaman kutinanpaq tiempo yaqaña cumplikushaqtinmi, Jesusqa proponekuran Jerusalén llaqtaman rinanpaq. ");
INSERT INTO qveNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Hinaqtinmi Jesusqa huk runakunata mandaran, Samaria provincia lawpi huk llaqtaman rinankupaq. Hinaspa chaypi huk wasita mashkaspa Jesuspa samananpaq alistamunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ichaqa, chay Samaria llaqtapi tiyaq runakunaqa, Jesustaqa manan samachiyta munarankuchu, Jerusalén llaqtaman risqanta yacharuspanku. Nota: Samaria llaqtapi tiyaq runakunaqa, creerankun Samaria llaqtallankupi Diosta yupaychanankupaq. Chaymi Jesustaqa mana samachiyta munarankuchu, Jesusqa Diosta yupaychananpaq Jerusalén llaqtaman risqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Chaymi Juanqa Jacobopiwan chay runakunapa rimasqankuta uyarispanku, Jesusta khaynata niranku: —Señor, munaqtiykiqa {ñawpaq profeta Elías hinayá} Diosmanta mañakuspayku, hanaq pachamanta nina rawrayta urayachimusaqku, kay runakunata ruphananpaq, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Chaymi Jesusqa paykunata q'aqcharan {khaynata: —¿Manachu yachankichis ima espiritus qankunapi kasqanta? ");
INSERT INTO qveNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Noqa, Diosmanta Hamuq Runaqa hamuni, manan kay pachapi runakunata infiernoman kachayunaypaqchu. Aswanqa hamuni infiernoman riqkunata salvanaypaqmi}, nispa. Chaymantan paykunaqa huk law llaqtaman riranku. ");
INSERT INTO qveNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ñanta rishaqtinkun Jesusta huk runa niran: —Qantaqa maytaña riqtiykipas noqaqa qatikusqaykin, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Hinaqtinmi Jesusqa contestaran: —Atoqkunapaqa kanmi puñunankupaq t'oqokuna. Alton phawaq pichinkukunapapas kanmi puñunankupaq lugarninku. Ichaqa noqa Diosmanta Hamuq Runapaqa manan kanchu mayman haykuspa puñunaypaqpas, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Saynata nispanmi Jesusqa huk runatañataq niran: —¡Hakuchi noqawan! nispa. Hinaqtinmi chay runaqa niran: —Señorlláy, primertaqa dejaykuwayraq papay wañuqtin p'amparamunaykama. Chaymantaña qantaqa qatikusqayki, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Chaymi Jesusqa contestaran: —Ama saynataqa piensaychu. Diospi mana creeq runakunaqa, wañusqa hinan kashanku. Hina paykunaqa wañusqa masinkuta p'ampamushachunku. Aswan qanqa riy; hinaspa runamasiykikunaman Diosmanta allin willakuykunata willamuy, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Huk runañataqmi Jesusta nillarantaq: —Señorlláy, noqaqa qanwanmi riyta munani; aswanqa dejaykuwayá, primerta wasiyman rispa, familiaykunamanta despedirakamunaypaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Chaymi Jesusqa payta niran: —Pipas takllawan yapushaspa qepan lawta qawaspa wiksu-wiksuta yapuq runaqa, manan valenchu allinta yapunanpaqqa. Saynallataqmi ima ruwaypipas ishkayaq runaqa, Diospaq llank'ananpaqqa manan valenchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Chaymantan Jesusqa akllaran qanchis chunka ishkayniyoq discipulonkunata. Hinaspan ishka-ishkayta comisionaspa mandaran, may llaqtakunamansi Jesús rinan karan, chay llaqtakunaman paykuna rinankupaq. Nota: Wakin ñawpaq pergaminokunapin escribisqa kashan qanchis chunka discipulokunamanta; wakinpiñataqmi escribisqa kashan qanchis chunka ishkayniyoq discipulokunamanta. ");
INSERT INTO qveNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Paykunatan Jesusqa khaynata niran: —Ashkan cosechanaqa kashan. Ichaqa Diosmanta willakuq runakunan chikallan kanku. Chayraykuyá qankunaqa Diosman orakuychis, yachachiq runakunata mandamunanpaq, saynapi llapallan runakunaman Diosmanta allin willakuykunata willamunankupaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kunanyá qankunaqa tukuy imamanta allinta cuidakuspa riychis. Noqan qankunataqa mandashaykichis atoqkunapa kasqanman ovejakunata hina. ");
INSERT INTO qveNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Hinaspapas qankunaqa aman apankichishchu qolqeta, mochilata, nitaq husut'atapas cambiakunaykichispaqqa. Saynallataq ñan risqaykichispiqa, aman piwanpas unayta parlaspachu demorankichis. ");
INSERT INTO qveNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Mayqen wasiman chayaspaykichispas, llapallan chay wasipi kaq runakunatayá rimayukunkichis khaynata: “Hawkayay qankunapi kachun”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Chay wasipi hukllapas allin runa kaqtinqa, qankunapa chay rimayukusqaykichisman hinan paykunapi chay hawkayay cumplikunqa. Sichus mana allin runakuna kaqtinkun ichaqa, qankunapa rimayukusqaykichis hawkayaytaqa mana paykunaqa chashkinqakuchu. ");
INSERT INTO qveNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Wasin-wasin samapakuqqa aman purinkichishchu. Aswanqa huk wasillapiyá samapakunkichis. Hinaspapas chay wasiyoqpa kapusqanman hina qosusqaykichistayá mikhunkichispas, hinallataq tomankichispas. Ichaqa huk llank'aq runaqa, chashkinqapunin pagontaqa. ");
INSERT INTO qveNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Mayqen llaqtaman chayaqtiykichispas, sichus runakuna allinta chashkisunkichis chayqa, ima mikhuna qosusqaykichistapas, mikhuychis. ");
INSERT INTO qveNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Saynallataq, chay llaqtapi kaq onqosqakunatapas sanoyachiychis. Hinaspa paykunatapas niychis: “Diospa gobiernanan p'unchawmi ña chayamushanña qankunaman”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Hinallataq may llaqtamanpas chayaqtiykichis, runakuna mana allintachu chashkisunkichis chayqa, callekunaman lloqsispaykichis, runakunata niychis khaynata: ");
INSERT INTO qveNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Llaqtaykichispa allpan chakiykuman ratamuqtapas thaptikuykun, saynapi qankunaqa mana allin runakuna kasqaykichista yachanaykichispaq. Ichaqa yachaychisyá Diospa gobiernanan p'unchawmi ña chayamushanña qankunamanpas”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Cheqaqtapunin niykichis, juicio p'unchaw chayamuqtinqa, Diosmi castiganqa Sodoma llaqtamantapas aswan mastaraq chay mana chashkisuqniykichis llaqtataqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jesusqa nillarantaqmi: —Ay ¡imaynaraq kankichis Corazín llaqtapi tiyaq runakuna! Ay ¡imaynaraq kankichis Betsaida llaqtapi tiyaq runakuna! Qankunapa llaqtaykichispin ashka milagrokunata ruwarani. Sichus Tiro llaqtapi hinallataq Sidón llaqtapipas chay milagrokunata ruwayman karan chayqa, paykunaqa huchankumanta wanakuspankun rikuchikunkuman karan Diosman kutirikusqankuta, qashqa p'achakunawan p'achakuspanku, hinallataq ushpa hawakunapi tiyaspanku ima. Nota: Israel nación llaqtapi tiyaq ñawpaq runakunaqa, ushpa hawakunapin tiyaranku, llakisqa kasqankuta runakunawan rikuchikunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Chayraykun juicio p'unchawpiqa, Tiro llaqtapi hinallataq Sidón llaqtapi tiyaq runakunamantapas aswan mastaraqmi castigasqa kankichis, qankuna Corazín llaqtapi tiyaq runakuna, hinallataq Betsaida llaqtapi tiyaq runakunapas. (Saynataqa castigasqa kankichis, Diosman mana kutirikusqaykichisraykun). ");
INSERT INTO qveNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","¡Capernaúm llaqtapi tiyaq runakuna! ¿Creenkichishchu Dios qankunata hanaq pachaman oqarisunaykichista? ¡Manan! Aswanmi qankunaqa nina rawray infiernopa aswan más ukhu-ukhunmanraq wikch'uyusqa kankichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Chaykunata niruspanmi Jesusqa discipulonkunata khaynata niran: —Qankunapa rimasqaykichista uyariq runakunaqa, noqatan uyariwan. Qankunata mana uyariq runakunan ichaqa, noqatapas mana uyariwanchu. Hinallataq qankunata mana chashkiqqa, noqatapas manan chashkiwanchu, nitaqmi mandamuwaqniy Diostapas chashkinchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Jesuspa qanchis chunka ishkayniyoq comisionasqan discipulonkunan kusisqallaña kutimuspanku Jesusman willaranku khaynata: —Señor, sutiykipi qarqoqtiykuqa demoniokunapas kasuwankun, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Chaymi Jesusñataq paykunata khaynata niran: —Arí, Satanastan rikurani rayo hina cielomanta urmayamuqta. ");
INSERT INTO qveNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Atiytan qoraykichis enemigoykichis diablota vencenaykichispaq, hinallataq mach'aqwaykunawan otaq ato-atoqkunawan qonqayllamanta tupaqtiykichispas, mana imanasunaykichispaq. ");
INSERT INTO qveNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ichaqa amayá qankunaqa kusikuychishchu demoniokunata venceruspaqa; aswanqa hanaq pachapi sutiykichis escribisqa kasqanwanyá kusikuychis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Chay ratollapin Santo Espiritupa yanapayninwan anchata kusikuspa, Jesusqa khaynata niran: —Dios Taytalláy, qantan alabayki, qanmi kanki hanaq pachapipas, hinallataq kay pachapipas kamachiqqa. Tukuy ruwasqaykikunatan yachaq tukuq runakunamanqa mana rikuchirankichu. Aswanmi pisi yachayniyoq wawa hina kaq runakunallaman kaykunataqa yachanankupaq rikuchiranki. Sayna ruwasqaykimantan graciasta qoyki. Arí, Dios Taytalláy, sayna kanantan qanqa munaranki, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jesusqa chaypi kaq runakunatan nillarantaq: —Dios Taytaymi qoykuwaran tukuy imakunata. Noqataqa manan ni pipas allintaqa reqsiwanchu, aswanqa Dios Taytallaymi. Manataqmi Dios Taytaytaqa ni pipas reqsinchu; aswanqa noqa wawallanmi reqsini. Noqan runakunataqa akllani, paykunapas Dios Taytayta noqa hina reqsinankupaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Chaymantan Jesusqa discipulonkunata sapallankupiña khaynata niran: —Mayna kusisqan qankunapa rikusqaykichista rikuq runakunaqa. ");
INSERT INTO qveNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Cheqaqtapunin niykichis, Diosmanta ashka willakuq profeta runakunan, hinallataq kay pachapi kamachiq runakunapas, qankunapa rikusqaykichistan rikuyta munaranku; hinaspapas qankunapa uyarisqaykichistan uyariyta munaranku. Ichaqa manan rikurankuchu nitaqmi uyarirankupashchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Huk p'unchawmi leykunata yachachiq runa, Jesusta pantachispa p'enqayman churayta munaspa tapuran khaynata: —Yachachikuq, ¿imatataq noqari ruwayman, wañuruspa, Diospa ladonpi wiñaypaq kawsanaypaqrí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Chaymi Jesusqa payta contestaran: —¿Ima nispataq Moisespa escribisqan leypiri nishan? nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Hinaqtinmi leykunata yachachiq runaqa khaynata niran: —“Señor Diosniykitan munakunki tukuy sonqoykiwan, tukuy vidaykiwan, tukuy kallpaykiwan, hinallataq tukuy yuyayniykiwan ima. Saynallataqmi runamasiykitapas qan kikiykita hina khuyakunayki”, nispa Levítico 19.18; Deuteronomio 6.5. ");
INSERT INTO qveNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Chaymi Jesusñataq niran: —¡Allinmi nisqaykiqa! Chaykunata ruwaspaykin Diospa ladonpiqa wiñaypaq kawsanki, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Hinaqtinmi leykunata yachachiq runaqa allinpi qepayta munaspa, Jesusta kaqmanta tapuran: —¿Pitaq noqapa runamasiyrí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Chaymi Jesusqa kay willakuyta willaran: —Huk p'unchawmi huk runa Jerusalén llaqtamanta Jericó llaqtaman risharan. Hinaqtinmi ñan risqanpi, suwakunaqa hap'iruspanku nishuta maqaspanku tukuy kaqninkunatapas qechuranku. Hinaspan chay runataqa wikapatamuranku yaqa wañusqata hinaña. ");
INSERT INTO qveNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Hinaqtinmi chay ñanninta Israel nación llaqtayoq huk sacerdote runa rishaspan, chay k'irisqa runata karullamanta qawarispa pasatamuran. ");
INSERT INTO qveNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Hinallataqmi chay ñanninta rillarantaq Jerusalén templopi sacerdotekunata yanapaq Israel llaqtamanta huk Leví runa. Paypas chay k'irisqa runata rikuspan, huk lawman muyurispa pasatamuran. ");
INSERT INTO qveNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Saynallataqmi Samaria law llaqtamanta huk runapas chay ñanninta rillasharantaq. Paymi (ichaqa huk law nación llaqtayoq runa kashaspanpas), chay k'irisqa runata rikuruspa, anchata khuyapayaran. ");
INSERT INTO qveNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Chaymi chay k'irisqa runaman ashuyuspa, k'irinkunata vinowan hinallataq aceitewan ima hampiran. Chaymantan k'irinkunata wataruspa, asnonman montachispa, samana wasiman apaspa, chaypi cuidaran. ");
INSERT INTO qveNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Chay samana wasimanta ripuspanñataqmi, wasiyoqman ishkay p'unchaw jornal qolqeta qotamuran, khaynata nispan: “Kay k'irisqa runata allinta atiendeykapuwanki. Sichus masta gastanki chayqa, kutimuspaymi pagapusqayki”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jesusqa saynata willaspanmi, leykunata yachachiq runata tapuran: —¿Qanri ima ninkitaq? Chay kinsantin runamantari, ¿mayqen kaqtaq runamasinta khuyapayaqrí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Hinaqtinmi leykunata yachachiq runaqa niran: —Chay k'irisqa runata khuyapayaspa yanapaq runan, nispa. Chaymi Jesusñataq niran: —Qanpas ripuspayki saynata ruwamuy, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesusqa discipulonkunapiwanmi Jerusalén llaqtaman rishaspanku, huk llaqtaman chayaranku. Hinaqtinmi chay llaqtapi tiyaq Marta sutiyoq warmiqa wasinpi samachiran. ");
INSERT INTO qveNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martapaqa karanmi huk hermanan María sutiyoq. Mariaqa Jesuspa yachachisqankunatan ñawpaqninpi tiyayuspa uyariran. ");
INSERT INTO qveNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ichaqa Martañataqmi mikhuna ruwaypi hinallataq wasipi tukuy ruwanakunapi afanakuspa, Jesuspa yachachisqankunataqa mana uyariranchu. Chaymi Martaqa Jesusman ashuyuspa khaynata niran: —Señorlláy ¿manachu qanman imapas qokusunki hermanay mana yanapawaqtin? Niy, ima ruwayllapipas yanapawananpaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Hinaqtinmi Jesusqa Martata contestaran: —¡Ay, Marta, Marta! ¿Imanaqtintaq qanri wasipi tukuy ima ruwanakunawan ancha afanasqallaña kashankirí? ");
INSERT INTO qveNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ichaqa ima ruwaykunamantapas aswan más allinqa, yachachisqaykunata uyariymi. Chaymi Mariaqa, aswan más allinnin kaqta akllarukun. Chay yachasqantaqa manan ni pipas qechunqachu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Huk p'unchawmi Jesusqa riran huk lugarman Diosmanta mañakuq. Mañakuyta tukuruqtinmi, huknin kaq discipulon ashuyuspa khaynata niran: —Señor, yachachiwayku Diosmanta mañakuyta, imaynan Bautizaq Juanpas discipulonkunaman yachachiran saynata, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Hinaqtinmi Jesusqa niran: —Qankunaqa khaynatayá mañakunkichis: “Hanaq pachapi Dios Taytayku, sutiyki yupaychasqa kachun. Hamuy noqaykuman sumaqta kamachiwanaykikupaq. Munayniyki ruwasqa kachun, imaynan hanaq pachapipas hinallataq kay pachapipas. ");
INSERT INTO qveNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Sapa p'unchawtaq t'antaykuta qowayku. ");
INSERT INTO qveNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tukuy huchaykutapas perdonawayku, imaynan noqaykupas perdonayku contraykupi mana allin ruwaq runakunatapas chay hinata. Amataq dejawaykuchu tentasqa kanaykuta, aswan mana allinmanta waqaychawayku”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesusqa nillarantaqmi: —Qankunamanta icha mayqenniykichispas kushka tuta horasta amigonpa wasinman rispa, ¿khaynata ruegakunmanchú? “Amigo, aynillapaq kinsa t'antaykita manuykuway. ");
INSERT INTO qveNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Huk visitaymi viajemanta wasiyman chayaramun. Chaymi payman qonaypaq mana ni ima mikhunaypas kanchu”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Saynata mañakuqtinqa wasin ukhumantan chay amigonqa khaynata nimunqa: “Ama ch'urmichamuwaychu. Wishq'asqañan punkupas kashan. Manan t'antata qanman qonaypaqqa hatarimuymanñachu. Noqaqa wawaykunapiwanmi puñushaniña”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Saynata amigon nimushaqtinpas, wasinpa punkunta tocapayasqanraykun, chay amigonqa phiñakushaspapas hatarimunqan. Hinaspan mañakusqantaqa qonqapuni. Chaytaqa ruwanqa, punkuta tocapayaspa, nishuta fastidiasqanraykun. ");
INSERT INTO qveNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Chaymi noqaqa niykichis: Diosmanta mañakuychis, payqa qosunkichismi. Mashkaychis, tarinkichismi. Punkuta tocaychis, kichamusunkichismi. ");
INSERT INTO qveNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Pipas Diosmanta mañakuqmi, chashkin. Mashkaqmi, tarin. Waqyakuqtintaqmi, punkuta kichamun. ");
INSERT INTO qveNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","¿Mayqenniykichistaq wawaykichis t'antata mañakusuqtiykichis, huk rumita qoykuwaqchís? Otaq ¿challwata mañakusuqtiykichispas, mach'aqwayta qoykuwaqchís? ");
INSERT INTO qveNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Otaq ¿runtuta mañakusuqtiykichispas ato-atoqta qoykuwaqchischú? ");
INSERT INTO qveNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Qankunaqa mana allin runakuna kashaspaykichispas, wawaykichismanqa allin kaqkunatan qoyta yachankichis. Saynallataqmi qankuna mañakuqtiykichispas, hanaq pachapi Dios Taytaykichisqa qosunkichis aswan mastaraq Santo Espiritunta, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Huk runan rimayta mana atiranchu ukhunpi demonio kasqanrayku. Chay runamantan Jesusqa qarqoran demoniota. Hinaqtinmi demonio lloqsiruqtin, chay runaqa yapamanta rimaran. Chayta rikuspankun chaypi kaq runakunaqa anchata admirakuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Wakin runakunañataqmi Jesuspa contranpi rimaranku khaynata: —Kay Jesusqa demoniokunapa jefen Beelzebú sutiyoq diablopa atiyninwanmi runakunamanta demoniokunataqa qarqon, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Wakin runakunañataqmi Jesusta pantachiyta munaspanku niranku: —Cheqaqtapuni Diosmanta Hamuq Runa kaspaykiqa, huk milagrota ruway rikunaykupaq, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Chaymi Jesusqa runakunapa piensasqanta yachaspa, paykunata niran: —Huk nación llaqtapi tiyaq runakuna cheqninakuspa rakinakunqa chayqa, chay nación llaqtaqa purmapunqan. Saynallataqmi huk wasipi tiyaq runakunapas cheqninakuspa kawsanqaku chayqa, maqanakuspan qarqonakunqaku hinallataq rakinakunqaku ima. ");
INSERT INTO qveNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Sichus diablopas paykunapura rakinasqa kanman chayqa, ¿imaynataq kanman kaq atiynillayoqrí? Kaytaqa niykichis, demoniokunapa jefen Beelzebupa atiyninwanmi runakunamanta demoniokunata qarqon niwasqaykichisraykun. ");
INSERT INTO qveNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Sichus noqa Beelzebupa atiyninwan demoniokunata qarqoni chayri, ¿qankunapa discipuloykichismanri, pitaq atiyta qon runakunamanta demoniokunata qarqonanpaqrí? Sichus qankuna kunan contestawankichis: “Diosmi chay atiyta qowanku”, nispa, hinaqtinqa llapallan runakunan yachanqa qankunaqa pantaypi kasqaykichista. ");
INSERT INTO qveNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Aswanqa, sichus noqa, Diospa atiyninwan runakunamanta demoniokunata qarqoni chayqa, yachanaykichismi Diospa kamachinan sumaq p'unchawkuna qankunapa sonqoykichisman chayamusqanta. ");
INSERT INTO qveNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Saynallataqmi niykichis, sichus huk allin armasqa kallpasapa runa allinta wasinta cuidanqa chayqa, manan ni pipas kapuqninkunataqa suwakuyta atinmanchu. ");
INSERT INTO qveNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ichaqa paymanta más kallpayoq runa hamuspanmi, chay kallpayoq runataqa vencenqa. Hinaspan armankunata qechuspa, tukuy kaqninkunatapas amigonkunaman rakinqa. Nota: Armasqa runaqa, diablon. Ichaqa aswan más kallpayoq runañataqmi, Jesucristo. ");
INSERT INTO qveNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Sichus qankuna noqapa ruwasqaykunawan mana acuerdopichu kankichis chayqa, noqapa contraypin kashankichis. Sichus qankuna pitapas Diosman mana pusaysiwankichishchu chayqa, runakunatan Diosmanta astawanraq karunchashankichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jesusqa nillarantaqmi: —Runamanta huk demonio lloqsispaqa, ch'inñeq desierto ch'aki lugarkunapin purin samananpaq huk lugarta mashkaspa. Manaña tarispataqmi nin: “Aswanyá kutipusaq maymantachus lloqsimurani chay wasiyman”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kutispataq chay runapa sonqonta tarin sumaq allichasqata, imaynan huk wasipas sumaq pichasqa kanman hinata. ");
INSERT INTO qveNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Saynata tarispanmi, chay demonioqa kutispa mashkamun paymanta aswan más millay qanchis demoniokunata. Hinaspanmi chay runaman haykuspanku sonqonpi tiyanku. Chaymi chay runapa vidanqa ñawpaq vidanmantapas aswan más millayraq kanqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Chaykunata Jesús rimashaqtinmi, ashka huñunasqa runakunapa chawpinmanta, huk warmi altota rimaspa nimuran: —¡Mamitaykiqa sumaqtachá kusikushan, qanta onqokuspa uywasusqaykimanta! nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesusñataqmi contestaran khaynata: —¡Aswan ancha kusisqaqa kanqaku, Diospa palabranta uyarispa kasukuq runakunan! nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Jesuspa kasqanmanmi astawanraq runakuna huñunakamuranku yachachisqankunata uyarinankupaq. Hinaqtinmi Jesusqa paykunata niran: —Mana allin ruwaq runakuna, qankunaqa milagro ruwanaytaraqmi munashankichis noqapi creenaykichispaq. Ichaqa manan Diosqa ni ima milagrotapas ruwanqachu qankuna rikunaykichispaqqa. Aswanqa Diosmanta willakuq profeta Jonasta imachus pasaran, saynatan qankuna ukhupipas noqawan pasasqanta rikunkichis. ");
INSERT INTO qveNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Imaynan profeta Jonaspas huk milagro hina enviasqa karan Nínive llaqtapi tiyaq runakunapaq, saynallataqmi noqa Diosmanta Hamuq Runapas, huk milagro hina kasaq, mana allinpi kawsaq runakunapaq. ");
INSERT INTO qveNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Sabá nacionniyoq reinapas juicio p'unchawpiqa kawsarimuspanmi, qankunapa contraykichispi rimanqa Dios castigasunaykichispaq. Israel nación llaqtapi rey Salomón gobiernashaqtinmi, chay reinaqa karu llaqtamanta hamuran, rey Salomonpa yachayninta uyarinanpaq. Qankunataqmi ichaqa noqapa yachachisqayta mana ni uyariytapas munankichishchu, rey Salomonmantapas aswan más yachayniyoq kashaqtiypas. ");
INSERT INTO qveNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nínive llaqtapi tiyaq runakunan, Diosmanta willakuq profeta Jonás willakuqtin, huchankuta saqespanku Diosman kutirikuranku. Chaymi juicio p'unchaw chayamuqtinqa, chay Nínive llaqtapi tiyaq runakunapas kawsarimuspanku, qankunapa contraykichispi rimanqaku, Dios castigasunaykichispaq. Saynataqa rimanqaku, qankunaman kay allin willakuykunata willashaqtiypas, huchaykichismanta mana wanakusqaykichisraykun. Noqaqa Jonasmantapas aswan más importanten kaypiqa kashani, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jesusqa nillarantaqmi: —Manan ni pipas mecherotaqa ratachin pakananpaqchu, nitaq cajonpa ukhunman churananpaqchu. Aswanqa alto patamanmi churanku, chaymanta wasiman llapallan haykuq runakunata allinta k'anchamunanpaq. ");
INSERT INTO qveNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Saynallataqmi runapa ñawinpas huk mechero hina kashan, enteron aycha cuerponta k'anchayunanpaq. Chaymi chay k'anchayta allinta rikuspaykichisqa, tukuy imatapas allinta ruwanaykichis, (Diospa yachachikuyninta allinta chashkisqaykichisrayku). Sichus chay k'anchayta yanqa tuta-tutallata rikuspaykichisqa, Diospa yachachikuynintapas manan allintachu chashkinkichis. ");
INSERT INTO qveNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Chayraykuyá qankunaqa allinta cuidakuychis, qankunapa k'anchayniykichis ama tutayananpaq. ");
INSERT INTO qveNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Sichus enteron cuerpoykichis mana tutayaqpi kaspa, aswan k'anchaypi kanqa chayqa, allintan kawsankichis, imaynan huk mecheropas k'anchayusunkichisman hinata, nispa. Nota: Mecheroq k'anchayninqa Diospa yachachikuyninmi. ");
INSERT INTO qveNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesús rimayta tukuruqtinmi, huk fariseo religionniyoq runa Jesusta wasinman invitaran, paywan kushka mikhunankupaq. Chaymi Jesusqa fariseo runapa wasinman rispa, mesapi mikhuq tiyayuran. ");
INSERT INTO qveNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Chay fariseo religionniyoq runañataqmi anchata admirakuspa Jesusta qawaran, Moisespa leyninman hina makinta mana mayllikuspa mesapi mikhuq tiyayuqtin. ");
INSERT INTO qveNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Chaymi Jesusqa chay fariseo religionniyoq runata khaynata niran: —Qankuna fariseo religionniyoq runakunaqa tazatapas platotapas hawallantan mayllinkichis, ukhuntataqmi ichaqa qenllillata saqenkichis. Saynan qankunapas runakunapa rikunallanpaq allinllaña kashankichis, sonqoykichis ukhupitaqmi ichaqa piensashankichis suwakuyllapi, hinallataq mana allinkuna ruwaykunallapi ima. ");
INSERT INTO qveNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Qankunaqa mana yachayniyoq roqro uma runakunan kankichis! ¿Manachu yachankichis hawantapas ukhuntapas, Dios ruwasqantarí? ");
INSERT INTO qveNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Qankunapa ruwasqaykichiswan Dios anchata kusikunanpaqqa, kaqniykichismantan wakchakunaman qonaykichis tukuy khuyakuywan. ");
INSERT INTO qveNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ay, ¡imaynaraq fariseo religionniyoq runakuna kankichis! Qankunaqa anchatan preocupakunkichis Moisespa escribisqan leykunaman hina Diosman diezmoykichis qoypi, hierba buenaykichismanta, rudaykichismanta, hinallataq huertaykichispi wiñaqkunamantapas. Ichaqa qankunaqa qonqarapunkichismi runamasiykichispaq allin kaqkunata ruwayta, hinallataq Diosta khuyakuytapas. Kaykunatan qankunaqa ruwanaykichis karan, diezmoykichista Diosman qoyta mana qonqaspalla. ");
INSERT INTO qveNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ay, ¡imaynaraq fariseo religionniyoq runakuna kankichis! Qankunaqa Diosmanta yachachina sinagoga wasikunapin, ñawpaqpi kaq sumaq asientokunallapin tiyaytapas munankichis, saynapi allin yachayniyoq runakuna hina alabasqa kanaykichispaq. Saynallataqmi plazakunapipas allin respetollawanña rimayukunata munankichis. ");
INSERT INTO qveNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ay, ¡imaynaraq fariseo religionniyoq runakuna, hinallataq leykunata yachachiq runakunapas kankichis! Qankunaqa allpa ukhupi alma p'ampasqa asnarishaq hinan kankichis, ishkay uya runakuna. Chaymi runakunaqa hawaykichispi purin mana cuentata qokuspalla, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jesuspa rimasqankunata uyarispanmi, leykunata yachachiq huknin kaq runaqa, Jesusta khaynata niran: —Yachachikuq, chaykunata rimaspaqa, noqaykutapas k'amiwashankikun, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Chaymi Jesusqa paykunatapas khaynata niran: —Ay, ¡leykunata yachachiq runakuna, imaynaraq kankichis! Qankunaqa mana ruway atina kamachikuykunatan costumbreykichisman hinalla runakunaman yachachishankichis. Ichaqa manataqmi qankunaqa ni huk dedollaykichiswanpas yanapankichishchu chay kamachikuykunata cumplinankupaqqa. Chay yachachisqaykichis kamachikuykunaqa huk llasa q'epi hinan paykunapaqqa. ");
INSERT INTO qveNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ay, ¡imaynaraq kankichis! Qankunapa ñawpaq abueloykichiskunan Diosmanta willakuq profetakunata wañuchiranku. Chay abueloykichiskuna hina kaspaykichismi, qankunapas kunanqa runakuna qawasunallaykichispaq, chay profetakuna p'ampasqaykichispa hawanpi sumaq labrasqa rumikunawan nichukunata ruwashankichis. ");
INSERT INTO qveNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Chaykunata ruwaspaykichismi qankunaqa, ñawpaq abueloykichiskunawan acuerdopi kashankichis. Paykunan Diosmanta willakuq profetakunata wañuchiranku. Qankunañataqmi ichaqa profetakunapa p'ampasqa hawanpi kunan nichukunata ruwashankichis sumaq labrasqa rumikunawan, saynapi allin rikusqa kanaykichispaq. ");
INSERT INTO qveNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Chaymi Diosqa ancha yachayniyoq kaspa qankunamanta khaynata niran: “Noqamanta willakuq profetakunata, hinallataq apostolkunatawan mandamuqtiymi, wakinta wañuchinkichis, wakintañataqmi llaqtan-llaqtan qatikachaspa ñak'arichinkichis”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Chayraykun niykichis, Diosmi qankunamantaqa cuentata mañasunkichis, kay pacha qallariyninmantapacha, Diosmanta willakuq llapallan profetakuna wañuchisqa kasqanmanta. ");
INSERT INTO qveNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ñawpaq Adanpa wawan Cainmi hermanon Abelta wañuchiran. Chay tiempomantapachan, asta Diosmanta willakuq profeta Zacariaskama, Diosqa cuentata mañasunkichis, paykuna wañuchisqaykichismanta. Profeta Zacariastaqa ñawpaq abueloykichiskunan wañuchiranku templopi altarmanta Lugar Santo nisqaman haykunapi. ");
INSERT INTO qveNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ay, ¡leykunata yachachiq runakuna, imaynaraq kankichis! Qankunaqa yachankichismi imaynatas Diosta reqsinamanta. Ichaqa manataqmi Diosta reqsiy munaq runakunataqa, yanaparankichishchu Diosta reqsinankupaqqa, nitaqmi qankunapas Diostaqa reqsiyta munankichishchu; aswanmi qankunaqa impedirankichis Diosta reqsinankutaqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Chaymantan Jesusqa chay fariseo religionniyoq runapa wasinmanta lloqsispa ripuran. Hinaqtinmi leykunata yachachiq runakunaqa, hinallataq fariseo religionniyoq runakunapiwan ima, anchata phiñakuranku. Hinaspan Jesuspa qepanta riranku astawan tapupayaspanku. ");
INSERT INTO qveNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Paykunaqa Jesusta pantachiyta munaspankun tapupayaranku, sichus imatapas mana allinta rimaruqtinqa, chayman hinallata acusanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Waranqa-waranqantin runakunan Jesuspa muyuriqninpi tanqanakustinraq huñunasqa kasharanku. Hinaqtinmi Jesusqa discipulonkunata khaynata niran: —Qankunaqa fariseo religionniyoq runakunapa levaduranmanta allinta cuidakuychis. Paykunaqa llullakuspan yachachinku ishkay uya runakuna kasqankurayku. Nota: Levaduraqa rikch'akun ishkay uya runamanmi. Imaynan chikachallan levadurapas, masata ashkaman tukuchin, saynallataqmi ishkay uya kaq runapas, chay ishkay uya kayninta ashka runakunaman contagian. ");
INSERT INTO qveNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ichaqa runapa tukuy ima pakallapi piensasqanpas, yachasqan kanqa. Hinallataq pakallapi tukuy ima ruwasqanpas, yachasqallataqmi kanqa. ");
INSERT INTO qveNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Qankunapuralla tutayaq ukhupi hina rimasqaykichispas, p'unchawpi hinan uyarisqa kanqa. Pakallapi imapas rimasqaykichistapas, llapallan runakunan yachanqaku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Jesusqa nillarantaqmi: —Khuyasqay runakuna, ama manchakuychishchu, sichus runakuna wañuchiyta munasuqtiykichisqa. Paykunaqa chaymanta aswan mastaqa manan ni imatapas ruwaytaqa atinkumanchu. ");
INSERT INTO qveNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Aswanqa Diosta manchakuychis. Payqa manan kay kawsay vidallaykichistachu qechusunkichisman. Aswanmi payqa ancha atiyniyoq, wañuqtiykichis wiña-wiñaypaq ñak'ariy infiernoman wikch'uyusunaykichispaq. Chaymi qankunataqa niykichis, Diostayá manchakuychis. ");
INSERT INTO qveNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ichaqa pishqa pichinkukunatapas ishkay qolqechallamanmi vendekunku. Sayna mana precioyoq kashaqtinpas, Diosqa chay pichinkukunataqa manan qonqanchu. ");
INSERT INTO qveNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Saynallataqmi qankunatapas Diosqa mana qonqasunkichishchu. Hinaspapas Diosqa yachanmi hayk'a chukchayoq kasqaykichistapas. Saynaqa amayá manchakuychishchu, ichaqa qankunan valenkichis ashka pichinkukunamantapas aswan mastaraq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Jesusqa nillarantaqmi khaynata: —Pillapas runakunapa ñawpaqninpi mana p'enqakuspa noqamanta rimanqa chayqa, noqapas Diospa llapallan angelninkunapa ñawpaqninpin nillasaqtaq: “Payqa noqapa discipuloymi”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Sichus pipas runakunapa ñawpaqninpi, noqata negawanqa chayqa, noqapas Diospa angelninkunapa ñawpaqninpin negallasaqtaq: “Manan paytaqa reqsinichu”, nispay. ");
INSERT INTO qveNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Sichus pipas noqa Diosmanta Hamuq Runapa contranpi rimanqa chayqa, perdonasqan kanqa. Ichaqa, Santo Espiritupa contranpi rimaq runaqa, manan perdonasqachu kanqa. ");
INSERT INTO qveNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Hinallataq, pipas Diosmanta yachachina sinagoga wasikunaman, otaq juzgadokunaman, otaq autoridadkunapa ñawpaqninman apasunkichis acusasunaykichispaq chayqa, aman llakikunkichishchu imayna rimanaykichismantaqa, nitaq imayna contestanaykichismantapas. ");
INSERT INTO qveNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Chay rimasqaykichis ratopin, Diospa Santo Espiritun yachachisunkichis imayna contestanaykichispaqpas, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Chaypi kaq ashka runakuna ukhumantan, Jesusta huk runa nimuran khaynata: —Yachachikuq, wawqeyta niykapuway papaykupa herencia saqewasqankumanta, noqaman tupawaqta qoykapuwananpaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Chaymi Jesusqa contestaran: —¿Pitaq noqatari churawaran, qankunapa juezniykichis kanaypaq, otaq herenciaykichistapas rakiq kanaypaqrí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Saynata nispanmi Jesusqa runakunata qawarispa, khaynata niran: —Amayá qankunaqa tukuy imayoq kayllatachu piensaychis. Ichaqa manan kay pachapi tukuy imayoq kaspachu, kusisqa kankichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Saynata nispanmi, Jesusqa huk willakuyta paykunaman khaynata willaran: —Huk qapaq runapa chakranmi allinta rururan. ");
INSERT INTO qveNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Chaymi chay qapaq runaqa sonqonpi piensaran khaynata: “¿Imatataq ruwasaq kunanrí? ¿Maypitaq waqaychasaq kay cosechaykunatarí? ");
INSERT INTO qveNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Aswanyá khaynata ruwasaq: Cosecha waqaychanay wasikunata pashkaruspayá, aswan más hatun wasikunata ruwasaq, chaypi cosechasqaykunata hinallataq llapallan kaqniykunatapas waqaychanaypaq. ");
INSERT INTO qveNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Chayta ruwaspaymi noqaqa kikillayta nikusaq: ‘¡Kunanqa tukuy imaykunapas lliwmi hunt'a waqaychasqa kapuwan ashka wata durawananpaq! ¡Kunanqa samakuspayá mikhukusaq, tomakusaq, hinallataq fiestakunata ruwaspay kusikusaq ima!’ ” nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Saynata chay qapaq runa piensashaqtinmi Diosqa niran: “¡Mana piensayniyoq roqro uma runa! Kunan tutan wañunki. Chayri, ¿pipaqtaq kanqa lliw hunt'a waqaychasqaykikunarí?” nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Chay willakuyta willaruspanmi, Jesusqa chaypi kaq runakunata khaynata niran: —Saynallataqmi kay pachapi qapaq runakunawanpas pasanqa. Paykunaqa kay pachallapin qapaq runakuna kanku. Ichaqa Diospa ñawpaqninpiqa, mana imayoq wakcha runakunan kanku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Chaymantan Jesusqa discipulonkunata khaynata niran: —Qankunaqa amayá preocupakuychishchu mikhunaykichismanta, nitaq p'achakunaykichismantapas. ");
INSERT INTO qveNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kay pachapi vidaykichisqa valen allin kaqkunata ruwanaykichispaqmi, manan mikhuchinallaykichispaqchu. Saynallataqmi cuerpoykichispas allin kaqkunata ruwanaykichispaq valen, manan sumaqta p'achachinallaykichispaqchu. ");
INSERT INTO qveNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Qawariychis pichinkukunata. Paykunaqa manan tarpunkuchu nitaq cosechankuchu, nitaqmi cosecha waqaychananku wasinkupas kanchu. Aswanmi paykunamanqa Diospuni sapa p'unchaw mikhunankupaq qon. Chaymi niykichis, ¡qankunaqa pichinkukunamantapas aswan mastaraqmi Diospaqqa valenkichis! ");
INSERT INTO qveNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Qankuna creenkichishchu sapa p'unchaw aswan masta afanakuspaykichis, huk p'unchawtawan kawsanaykichispaq, otaq huk chikallantapas wiñaruyta? ");
INSERT INTO qveNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ichaqa manan qankunaqa ni chayllatapas ruwaytaqa atinkichishchu. Chayri ¿imanaqtintaq qankunari anchata afanakushankichis kay pachapi tukuy kaqkunamantarí? ");
INSERT INTO qveNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Qawariychisyá campokunapi sumaqllaña wiñaq t'ikakunata. Chay t'ikakunaqa manan llank'ankuchu nitaqmi pushkankupashchu p'achakunankupaqqa. Ichaqa cheqaqtapunin niykichis, Israel nación llaqtapi ñawpaq kamachiq rey Salomonpas, ancha qapaq kashaspapas, manan ni huknin kaq t'ikakuna hinallapas p'achakuranchu. ");
INSERT INTO qveNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Diosmi chay t'ikakunataqa sumaqta t'ikachispa chikan tiempollapaq wiñachin; ch'akiruqtintaqmi ninaman wikch'uyusqa. Chayri, ¿Diosqa manachu qankunata chay t'ikakunamantapas aswan mastaraq p'achachisunkichisman? ¡Ichaqa qankunamanqa Diosmi qosunkichis tukuy necesitasqaykichista, pisi iñiyniyoq runakuna! ");
INSERT INTO qveNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Saynaqa, amayá afanakuychishchu nitaq preocupakuychispashchu, mikhunaykichismanta nitaq tomanaykichismantapas. ");
INSERT INTO qveNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kay pachapi mikhuymanta, tomaymanta hinallataq p'achakuymantaqa, Diospi mana creeq runakunallan mastaqa afanakunku. Ichaqa Dios Taytaykichisqa yachanmi imapas necesitasqaykichistaqa. ");
INSERT INTO qveNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Chaymi niykichis, qankunaqa Diosta mashkaychis. Saynata ruwaspa kawsaqtiykichismi tukuy ima necesitasqaykichistapas Diosqa qosunkichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Jesusqa nillarantaqmi kay willakuyta: —¡Ama imatapas manchakuychishchu! ¡Qankunaqa khuyasqa ovejaykuna hinan kankichis! Dios Taytaykichisqa munanmi hanaq pacha glorianpi, paywan wiñaypaq kanaykichista. ");
INSERT INTO qveNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Chayqa kay pachapi llapallan kaqniykichista vendespayá, wakcha runakunaman rakimuychis. Saynata ruwaspaqa, hanaq pachapin mana mawk'ayaq bolsonman hina tukuy kapuqniykichista hunt'ashankichis. Chaypiqa manan suwakunapas suwakunqachu, nitaqmi phuyu urupas mikhunqachu. ");
INSERT INTO qveNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Yachaychisyá maypichus qapaq kayniykichis kashan, chayllapitaqmi sonqoykichispas kashan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Jesusqa nillarantaqmi: —Llank'ana p'achaykichiswan p'achasqa hinallayá kaychis; mecheroykichispas ratachisqallayá kachun. ");
INSERT INTO qveNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Imaynan huk patronta serviq runakunapas, rikch'aspalla suyanku casarakuy fiestamanta patronninku kutimuspa, punkuta tocamuqtin apurayllaman kichanankupaq, saynayá qankunapas listolla kaychis, noqa kutimunayta suyawaspaykichis. ");
INSERT INTO qveNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kusisqan kanqaku patronninpa kutimunanta rikch'ashaspalla suyaq runakunaqa. Chaymi cheqaqtapuni niykichis, rikch'ashaspalla suyaq runakunatan, patronninqa mesaman tiyaykachinqa. Hinaspan kikinpuni paykunaman mikhunata servinqa. ");
INSERT INTO qveNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Chaymi niykichis, chawpi tutatapas otaq imay horastapas, patronnin hamuspa, serviqnin runakunata rikch'ashaspalla suyashaqta tarimunqa chayqa, chay serviqnin runakunaqa ancha kusisqan kanqaku. ");
INSERT INTO qveNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Yachaychisyá kayta, sichus wasiyoq yachanman imay horastas suwa hamunanta chayqa, allintachá cuidanman, wasinman suwa ama haykumunanpaq. ");
INSERT INTO qveNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Saynayá qankunapas listolla kaychis. Diosmanta Hamuq Runaqa kutiramusaqmi mana piensasqaykichis horasllapi, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jesuspa yachachisqankunata uyarispanmi, Pedroqa tapuran khaynata: —Señorlláy, kay willakusqaykiri, ¿noqallaykupaqchu icha llapallan runakunapaqwanchú? nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jesusñataqmi niran: —¿Pitaq kasukuspa allinta ruwaq mayordomo runarí? Kasukuspa allinta ruwaq mayordomo runaqa, patronninpa kamachisqanta kasukuspa ruwaqmi. Chaymi payta patronninqa haciendanpi churan serviqkunata kamachinanpaq, hinallataq wasinpi kaq runakunamanpas horasllanpi mikhunata qonanpaq. ");
INSERT INTO qveNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ancha kusisqan chay mayordomo runaqa kanqa, patronnin hamuspa kamachisqanman hina ruwashaqta tarimuqtinqa. ");
INSERT INTO qveNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Cheqaqtapunin niykichis, sayna kaqtinqa patronninmi chay kasukuq sirviententaqa tukuy kaqninkunata cuidananpaq churanqa. ");
INSERT INTO qveNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ichaqa sichus chay mayordomo runa, patronninpa kamachitamusqanta mana kasukuspa, sonqollanpi piensanman khaynata: “Patronniyqa manaraqmi hamunqachu”, nispa. Saynata piensaspan, kamachisqan runakunata qarita warmita maqanman, hinallataq tukuy munasqanta mikhuspa, mach'akunman chayqa, ");
INSERT INTO qveNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","patronninmi mana suyasqan p'unchawta, hinallataq mana piensasqan horasta, qonqayllamanta chayaramuspa, chay runataqa alli-allinta castigaspa, mana kasukuq runakunawan kushkata churanqa ñak'arinanpaq. ");
INSERT INTO qveNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Chaymi niykichis, patronninpa kamachisqankunata chay mayordomo yachashaspa mana ruwanqachu chayqa, alli-allin castigasqa kanqa. ");
INSERT INTO qveNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ichaqa patronninpa kamachisqankunata mana yachashaspa, ima mana allintapas ruwaq mayordomoqa, pisillata castigasqan kanqa. Pipas Diosmanta ashkata chashkiqmi, Diosmanpas ashkamanta cuentata qonqa. Saynallataqmi pimanpas tukuy imata Dios confiaran chayqa, paymantapas Diosmi cuentata mañanqa aswan mastaraq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jesusqa nillarantaqmi: —Noqaqa ninata hinan kay pachaman hamuspay apamurani. Saynaqa maytan munayman chay nina ratashanantaña. ");
INSERT INTO qveNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Aswanmi noqa primerta ñak'arisaq. Chaymi ancha llakikuywan chay p'unchaw chayamunanta suyashani. ");
INSERT INTO qveNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Qankunaqa creerankichishchu, noqa kay pachaman hamuspay hawkayayta apamunaypaq? ¡Manan! Aswanmi noqapi creesqaykichisrayku, noqapi mana creeqkuna qankunamanta rakikunqaku. ");
INSERT INTO qveNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Chaymi niykichis, kunanmanta ñawpaqmanmi runakunaqa, noqapi creesqankurayku dividisqa kawsanqaku; huk wasipi pishqa tiyaqkunamantan kinsa ishkaypa contranpi kanqa; ishkayñataqmi kinsapa contranpi kanqa. ");
INSERT INTO qveNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Papanmi wawanpa contranpi kanqa; wawanñataqmi papanpa contranpi kanqa. Mamitanmi ususinpa contranpi kanqa; ususinñataqmi mamitanpa contranpi kanqa. Saynallataqmi suegranpas qachunninpa contranpi kanqa; hinallataq qachunninpas suegranpa contranpi kanqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesusqa chaypi kaq runakunata qawarispanmi nillarantaq: —Qankunaqa intipa haykunan lawmanta phuyu lloqsimuqta rikuspaykichismi ninkichis: “Paramunqan”, nispa; hinaqtintaqmi paramun. ");
INSERT INTO qveNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Uraymanta wichayman wayra-wayramuqtintaqmi ninkichis: “Ruphamunqan”, nispa; hinaqtintaqmi ruphamun. ");
INSERT INTO qveNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Cheqaqtapunin niykichis, ¡qankunaqa ishkay uya runakunan kankichis! Cielotapas kay allpa pachatapas qawaspaykichismi, yachankichis p'unchawkuna allin kananta otaq mana allin kanantapas. Ichaqa noqapa ruwasqaykunata qawashaspaykichismi, mana ni imatapas entiendenkichishchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Jesusqa nillarantaqmi: —Qankunaqa allin kaqtayá imatapas ruwaychis. ");
INSERT INTO qveNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Quejakusuqniyki runawan juezman rispaykiqa, ñanllapiraqyá arreglaspa allinpaychis, saynapi juezman ama entregasunaykipaq. Sichus guardiaman juez entregarusunki chayqa, carcelmanmi apaspa churamusunki. ");
INSERT INTO qveNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Chaymi cheqaqtapuni niyki, chaymantaqa manan lloqsimunkichu llapallan debesqaykita paganaykikama, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Chay p'unchawkunapin wakin runakuna Jesusman hamuranku. Hinaspan willaranku khaynata: —Galilea provincia lawmantan runakuna Jerusalén temploman hamuranku. Hinaspan animalkunata wañuchispanku sacrificio ofrendata Diosman haywasharanku. Hinaqtinmi gobernador Poncio Pilatopa soldadonkuna hamuspanku, qonqayllamanta chay sacrificio ruwaq runakunata wañuchiranku. Chaymi yawarninkupas animalkunapa yawarninwan chapukuran, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Chaymi Jesusqa paykunata niran: —¿Qankuna piensankichishchu chay Poncio Pilatopa wañuchisqan runakunaqa, Galilea provincia lawmanta wakin runakunamantapas aswan más huchasapa kanankupaq? ");
INSERT INTO qveNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","¡Manan chayqa saynachu! Qankunapas huchaykichismanta Diosman mana kutirikuspaqa, saynatan wañunkichis. ");
INSERT INTO qveNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Yuyariychisyá, Jerusalén llaqta ukhupi, Siloé nisqa sutiyoq lugarpi, huk hatun torre thuñiyamuspa chunka pusaqniyoq runakunata wañuchisqanmanta. Chaytapas, ¿qankuna piensankichishchu, paykunapas Jerusalén llaqtapi tiyaq runakunamanta, aswan más huchasapa kaspanku wañunankupaq? ");
INSERT INTO qveNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","¡Manan saynachu! Qankunapas huchaykichismanta Diosman mana kutirikuspaqa, saynatan wañunkichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesusmi huk willakuyta willaran khaynata: —Huk runan higosta plantaran uvas plantakunawan kushkata. Chaymi unay watamantaña chay runaqa riran chay higospa rurunta pallaq. Ichaqa chay higos sach'aqa, manan rurusqachu. ");
INSERT INTO qveNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Chaymi dueñonqa chakran cuidaq runata niran: “Kinsa watañan hamuni kay higos sach'apa rurunta pallanaypaq; ichaqa manan ni ch'ullatapas ruruntaqa tarinichu. Aswanyá wit'upuy; yanqan kay sach'aqa campota ocupashan”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Hinaqtinmi chay chakra cuidaq runaqa niran: “Señor, kay watatawanraqyá dejaykuy, muyuriqninta hasp'iruspay wanuta hich'arunaypaq. ");
INSERT INTO qveNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Sichus rurunqa chayqa, allinmi kanqa. Mana ruruqtinmi ichaqa, wit'uchipunki”, nispa. Nota: Chay mana ruruq higos sach'aqa, Diosta mana kasukuq runakunan kanku. ");
INSERT INTO qveNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Samana p'unchawpin Diosmanta yachachina sinagoga wasipi Jesusqa yachachisharan. ");
INSERT INTO qveNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Chaypin kasharan huk warmi wasan qopoyasqa. Chaytaqa demonion qopoyachispa k'umu-k'umuman tukuchiran. Chaymi chay warmiqa, chunka pusaqniyoq wataña derechota mana sayayta atispa, k'umu-k'umulla puriran. ");
INSERT INTO qveNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Hinaqtinmi Jesusqa chay warmita rikuruspa waqyaran. Hinaspan khaynata niran: —Chay ñak'arisqayki onqoymantan sanoña kanki, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Saynata nispanmi, Jesusqa makinwan llamiykuran chay warmita. Hinaqtinmi chay warmiqa kasqan ratolla sanoyapuspa, Diosta alabaran. ");
INSERT INTO qveNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ichaqa sinagoga wasipi kamachiq runañataqmi anchata phiñakuran, chay warmita, samana p'unchawpi, Jesús sanoyachisqanrayku. Hinaspan chaypi kaq runakunata khaynata niran: —Soqta p'unchawmi llank'anapaqqa. Chay p'unchawkunapiyá hamuychis sanoyayta munaspaqa, amayá samana p'unchawpichu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Hinaqtinmi Jesusqa paykunata contestaran: —Ishkay uya runakuna. ¿Manachu qankunapas samana p'unchawpi wakaykichista asnoykichistapas pashkaspa unuta tomananpaq qatinkichís? ");
INSERT INTO qveNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kay warmiqa Abrahampa mirayninmanta kasqanraykun, wakaykichismantapas asnoykichismantapas aswan masta valen. Paytan chunka pusaqniyoq wataña demonio ñak'arichiran. Chayri, ¿manachu samana p'unchaw kashaqtinpas, payta sanoyachiyman? nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Saynata rimaqtinmi, Jesuspa llapallan enemigonkunaqa p'enqaypi quedaranku. Wakin runakunañataqmi Jesuspa tukuy ima ruwasqankunata rikuspanku anchata kusikuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesusqa nillatarantaqmi: —¿Imawantaq rikch'anachiyman Diosta kasukuspa kawsaq runakunatarí? ");
INSERT INTO qveNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Diosta kasukuq runakunaqa rikch'akun, huk runapa tarpusqan mostaza mukhumanmi. Chay mostazapa mukhunmi hatun sach'aman tukun wiñaspaqa. Chaymi pichinkukunapas ramankunapi thapachakunku, nispa. Nota: Kay mostaza mukhuqa yachachiwanchis, imaynan kay mostaza mukhupas ch'ulla mukhullamanta hatunta wiñaspa ashkata rurun, saynan Diospi creeq runakunapas ch'ullallamanta ashkaman tukunanchis. ");
INSERT INTO qveNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesusqa nillarantaqmi: —¿Imawantaq rikch'anachiyman Diosta kasukuspa kawsaq runakunatarí? ");
INSERT INTO qveNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Diosta kasukuq runakunaqa rikch'akun chikallan levadurata ashka harinawan huk warmi chapuqtin ashkaman chay masa poqosqanmanmi. Saynallataqmi Diospi creeq runakunapas sapa p'unchaw ashkaman tukunqaku, imaynan chay levadurapas chikan masata ashkaman tukuchin, chay hinata, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jerusalén llaqtaman rishaspanmi, Jesusqa yachachiran llaqtakunapi, hinallataq uchuy llaqtachakunapipas. ");
INSERT INTO qveNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Hinaqtinmi huk runa tapuran: —Señor, ¿chikallanchu salvasqa kanqakú? nispa. Chaymi Jesusñataq contestaran: ");
INSERT INTO qveNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Qankunaqa kallpanchakuychisyá k'itku punkunta haykunaykichispaq. Ashka runakunan huk p'unchaw haykuyta munanqaku, ichaqa manan haykuytaqa atinqakuchu. ");
INSERT INTO qveNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Chay punkuta wasiyoq wishq'aruqtinmi ichaqa, hawapi qeparunkichis. Hinaspan punkuta takaspa waqyakunkichis: “¡Señor, Señor kichaykullawayku!” nispa. Ichaqa payñataqmi nimusunkichis: “Manan qankunataqa reqsiykichishchu; maymantachá qankunaqa kankichispas”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Hinaqtinmi qankunañataq ninkichis: “Señor, qanwan kushkan mikhuraykupas, tomaraykupas, llaqtaykupa plazanpitaqmi qanqa yachachirankipas”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Hinaqtinmi payñataq nimusunkichis: “Manan reqsiykichishchu, maymantachá qankunaqa kankichispas. Ladoymanta ayqeriychis mana allin ruwaq runakuna”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Chaymi hawapi qeparuspa Abrahamta, Isaacta, Jacobta hinallataq Diosmanta willakuq profetakunata ima, hanaq pacha Diospa ladonpi rikuspaykichis, waqankichis kiruykichispas rach'ikyanankamaraq. ");
INSERT INTO qveNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Hanaq pacha Diospa ladonmanqa, llapallan llaqtakunamantan runakunaqa hamunqaku, kay lawmanta, waq lawmanta, wichay lawmanta hinallataq uray lawmanta ima. Hinaspan paykunaqa Dioswan kushka mikhunqaku. ");
INSERT INTO qveNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kay pachapi mana importante kaq runakunan, hanaq pacha Diospa ladonpiqa, aswan importante runakuna kanqaku. Kay pachapi importante runakunañataqmi ichaqa, p'enqachisqa kaspanku, qepakunqaku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Chay p'unchawmi fariseo religionniyoq runakuna Jesuspa kasqanman chayamuranku. Hinaspan Jesustaqa khaynata niranku: —¡Ripuy kaymanta! Rey Herodesmi wañuchiyta munashasunki, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Chayta uyarispanmi Jesusqa paykunata niran: —Riychis hinaspa chay atoq hina Herodes runata nimuychis khaynata: “Kunan p'unchawkunallañan runakunamanta demoniokunata qarqosaq; hinaspa onqosqakunatapas sanoyachisaq. Chaymantan ichaqa kay ruwanaykunata tukusaq”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Chaymi noqaqa kunan, paqarin hinallataq minshapas Jerusalén llaqtamanqa rinaypuni kashan. Ichaqa Diosmanta willakuq huk profeta runaqa, manan wañunmanchu huk law llaqtapiqa; aswanmi Jerusalén llaqtapi wañunan. ");
INSERT INTO qveNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ay, ¡Jerusalén llaqtapi tiyaq runakuna! ¡Qankunan Diosmanta willakuq profeta runakunata wañuchirankichis! ¡Saynallataqmi qankunaqa Diospa mandamusqan runakunatapas rumiwan p'anashaspalla wañuchirankichis! ¡Noqaqa maytan munarani qankuna huñuykuyta, imaynan huk wallpapas chiwchichankunata raphran ukhupi huñuykun chay hinata! Ichaqa manan munarankichishchu huñuykunaytaqa. ");
INSERT INTO qveNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Chayraykun Diosta yupaychanaykichis templopas, hinallataq llaqtaykichispas, wasiykichispas wikch'usqa kanqa. Cheqaqtapunin niykichis, manañan rikuwankichishñachu kutimunay tiempo chayamunankama. Chay p'unchawñan ninkichis: “Alabasqayá kachun Diospa Sutinpi Hamuq Salvadorqa”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Huk samana p'unchawpin Jesusqa, fariseo religionniyoq runakunapa huknin kaq jefenpa wasinman mikhuq riran. Hinaqtinmi chaypi kaq wakin fariseo religionniyoq runakunapas Jesusta qawapayaranku, imapipas pantaruqtinqa chayman hinalla acusanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Chaypi Jesús kashaqtinmi, punkipakuy onqoyniyoq runa, Jesuspa ñawpaqninman ashuyuran. ");
INSERT INTO qveNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Hinaqtinmi Jesusqa leykunata yachachiq runakunata, hinallataq fariseo religionniyoq runakunatawan tapuran khaynata: —¿Moisespa leyninman hina, samana p'unchawpi sanoyachiy, allinchu kanman icha manachú? nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Paykuna upallalla kaqtinkun, Jesusqa punkipakuy onqoywan onqoq runata llamiykuspa sanoyachiran; hinaspan niran: —Ripuy, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Hinaqtinmi chaypi kaq runakunata Jesusqa niran: —Mayqenniykichispapas wawaykichis, (asnoykichis) otaq toroykichispas samana p'unchawpi huk hatun t'oqoman urmayuqtin, ¿manachu orqowaqchis samana p'unchaw kasqanraykú? nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ichaqa mayqenninkupas manan ni imaynatapas contestayta atirankuchu. ");
INSERT INTO qveNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Cenaman invitasqa runakunan, ñawpaqpi allin kaq lugarkunapi asientokunata mashkaranku. Chayta rikuspanmi, Jesusqa chaypi kaq runakunaman yachachiran khaynata: ");
INSERT INTO qveNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Pipas invitasunki casarakuyninman hinaqtinqa, amayá ñawpaqpi sumaq asientokunatachu akllanki tiyanaykipaqqa. Saynata ruwaqtiykiqa, pipas qanmanta aswan más reqsisqa invitado runa chayaramuqtinmi, chay invitasuqniykiqa ");
INSERT INTO qveNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","“ayqeriy” nisunkiman, chay allin reqsisqa runa chaypi tiyananpaq. Hinaqtinmi qanqa p'enqa-p'enqayta qepaman tiyaq riwaq. ");
INSERT INTO qveNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Aswanmi casarakuyman invitasqa kaspaykiqa, qepallapiña tiyakuy, invitasuqniyki hamuspa khaynata nisunaykipaq: “Amigo, ñawpaqpi allin kaq lugarpi tiyakamuy”, nispa. Saynapin chaypi qanwan kushka tiyaqkuna yachanqaku aswan más respetasqa kasqaykita. ");
INSERT INTO qveNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ichaqa paytukusqa runakunan humillasqa kanqaku. Humillakuq runakunañataqmi, respetasqa kanqaku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesusqa nillarantaqmi chay wasinman invitaqnin fariseo religionniyoq runata: —Huk fiestapi mikhunata otaq cenayta ruwaspaqa, amayá amigoykikunallatachu, nitaq wawqeykikunallatachu, nitaq familiaykikunallatachu, nitaq qapaq kaq vecinoykikunallatachu invitankiqa. Sichus paykunallata invitanki chayqa, paykunapas wasinman qanta invitasuspaykin, huk fiestata ruwaspa qanmanpas kaq mikhuchillasunkitaq, imaynan qanpas ruwaranki saynata. ");
INSERT INTO qveNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Aswanyá fiestata ruwaspaykiqa, mikhunankupaq invitakamunki: wakchakunata, ñuk'ukunata, mana puriq wist'ukunata, hinallataq ñawsa runakunatawan ima. ");
INSERT INTO qveNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Paykunaqa chay invitasqaykimantaqa manan kutichipuyta atisunkikuchu. Aswanmi chay runakunapa favorninpi allin kaqkunata ruwasqaykirayku ancha kusisqa kanki. Hinaspapas Diosmi premioykita qosunki, Diospi creeq runakuna, wañusqankumanta kawsarimusqan p'unchawpi, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Chayta uyarispanmi, mesapi cenayta mikhuq runakunamanta huknin kaq runa, Jesusta niran: —Ancha kusikuyniyoqmi kanqaku Diospa gobiernasqan sumaq glorianpi paywan kushka mikhunata mikhuq runakunaqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Hinaqtinmi Jesusqa contestaspa huk ejemplota willaran khaynata: —Huk runan fiestata ruwaspa ashka runakunata invitamuran mikhunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Chaymi mikhuy horas chayaramuqtin chay runaqa, sirvienten runata kamachiran invitasqan runakunata waqyamunanpaq: “Hamuychishña mikhunaykichispaq; mikhunaqa listoñan kashan”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Hinaqtinmi chay invitamusqan runakunaqa mana hamuyta munarankuchu. Chaymi primerta waqyamusqan runaqa niran: “Chakra rantisqaymi qawamunay kashan. Manan hamuyta atiymanchu. Disculpaykuwayá”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Hukñataqmi niran: “Manan hamuyta atiruymanchu. Pishqa masa torokunatan rantiruni; chaytaraqmi yapunanpaq pruebamunay kashan. Disculpaykuwayá”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Huk runañataqmi niran: “Chayllaraqmi casararukuni. Chayraykun mana hamuyta atiymanchu”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Hinaqtinmi chay waqyamuq sirvienteqa kutimuspa, patronninman willaran runakunapa nimusqanta. Chayta uyarispan, patronninqa anchata phiñakuran chay waqyachimusqan runakunapaq. Hinaspan sirvienten runata kamachiran: “Apurayllaman riy plazakunaman, hinallataq callekunamanpas. Hinaspa chaymanta pusamuy wakchakunata, ñuk'ukunata, mana puriq wist'ukunata, ñawsa runakunatawan ima”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Hinaqtinmi chay sirvienten runaqa patronninpa kamachisqanman hina runakunata waqyamuran. Chaymanta kutimuspantaqmi patronninta niran: “Señorlláy, kamachiwasqaykiman hinan runakunata pusaramuni. Chaypas wasipiqa campo kashanraqmi”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Chaymi patronninqa chay sirvienten runata niran: “Riy ñankunaman, hinallataq llaqtaq muyuriqninkunamanwan. Hinaspa runakunata pusamuypuni wasiypi hunt'a kanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Cheqaqtan niykichis, chay primer kaq mana kasukuq invitamusqay runakunaqa, manan ni mayqenninpas mallinqachu kay preparachisqay mikhunataqa”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ashkallaña runakuna Jesuspa qepanta riqtinmi, Jesusqa kutirispa paykunata khaynata niran: ");
INSERT INTO qveNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Pipas noqata qatikuwayta munaspaqa, papanmantapas, mamitanmantapas, warminmantapas, wawankunamantapas, wawqenkunamantapas, panankunamantapas, hinallataq kikinpa vidanmantapas noqatan aswan masta khuyakuwanan; ichaqa saynata mana khuyakuwaspaqa, manan noqapa discipuloyqa kanmanchu. ");
INSERT INTO qveNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Pipas noqapi creespa mana ñak'ariy munaq, hinallataq noqata mana qatikuway munaq runaqa, manan discipuloyqa kanmanchu. ");
INSERT INTO qveNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Sichus mayqenniykichispas, huk torreta ruwayta munaspaqa, manaraq qallarishaspanmi, tiyayuspa qolqentaraq allinta yupanan. Hinaspan allinta tanteakunan, chay torreta ruwaspa tukuchinanpaq, qolqen aypanqachus icha manachus chayta. ");
INSERT INTO qveNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Sichus mana allinta tanteakuspa chay torrepa cimientonta ruwayta qallarinman, hinaspa mana tukunmanchu chayqa, runakuna rikuspankun paymanta burlakuspa asipayankuman, ");
INSERT INTO qveNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","khaynata nispanku: “Kay runaqa afanllañan torreta ruwayta qallarirun, ichaqa manataqmi tukuyta atinchu”, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","¿Imatataq ruwanman huk reyri, chunka waranqa soldadollayoq kashaspan, ishkay chunka waranqa soldadoyoq reywan peleaq rinanpaqrí? Primertan payqa tiyayuspan allinta tanteakunan, chay chunka waranqa soldadonkunallawan ganayta atinmanchus icha manachus chayta. ");
INSERT INTO qveNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Sichus peleaspa mana ganananpaq hina kaspaqa, karullataraq chay enemigon rey soldadonkunapiwan hamushaqtinmi, payqa soldadonkunata akllaspan kamachinqa, rispanku khaynata nimunankupaq: “Amaña peleasunchishchu; aswan hawkalla qepanapaq, parlasun”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Saynallataqmi qankunatapas niykichis, sichus noqapa discipuloy kayta munaspaqa, llapallan kaqniykichiskunata saqespan, allinta tanteakuspa qatikuwanaykichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Jesusqa nillarantaqmi khaynata: —Kachiqa imapaqpas allinmi; q'aymayaruspanmi ichaqa manaña imapaqpas valenñachu. Hinaqtinri ¿imawantaq salachiwaq kaqmantarí? ");
INSERT INTO qveNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mana salaq kachiqa, manañan ni imapaqpas valenñachu, nitaq chakraman hich'anapaqpas ni wanupaqpas. Aswanqa wikapanallapaqñan valen. Kay yachachikuykunata uyariqqa, kasukuytayá yachachun, nispa. Nota: Allin kachiqa Diospi allinta creespa Diosta qatikuq runakunamanmi rikch'akun. Ichaqa q'aymayaq kachiñataqmi rikch'akun Diospi creeshaspa mana kasukuq runakunaman. ");
INSERT INTO qveNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Jesuspa yachachisqanta uyarinankupaqmi, paypa kasqanman impuesto cobraq runakuna, hinallataq huchasapa runakunapas hamuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Chayta rikuspankun fariseo religionniyoq runakunapas, hinallataq leykunata yachachiq runakunapas, Jesuspa contranpi rimaspanku ninakuranku khaynata: —Kay runaqa huchasapa runakunapa amigonmi; hinaspapas paykunawan kushkan mikhunpas, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Hinaqtinmi Jesusqa kay ejemplota willaran khaynata: ");
INSERT INTO qveNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Mayqenniykichispapas pachaq ovejaykichismanta huknin kaq ovejaykichis chinkaruqtinqa, ¿manachu esqon chunka esqonniyoq ovejaykichista, maypin michisqaykichispi saqeyuspa, chay chinkaq ovejata mashkaq riwaqchis tarimunaykichiskama? ");
INSERT INTO qveNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tariramuspataq ancha kusisqallaña q'epiyukuspa kutinpuwaqchis. ");
INSERT INTO qveNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Hinaspan wasiykiman chayamuspa, amigoykikunata hinallataq vecinoykikunatawan waqyaspa niwaq: “Hamuychis wasiyman. Kusikusunchis. Chinkasqa ovejaytan tarirakanpuni”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Cheqaqtapunin niykichis, saynan hanaq pachapipas chay esqon chunka esqonniyoq allin runakunamantapas, aswan más kusikuyraq kanqa huk ch'ullalla huchasapa runa, huchanta saqespa, Diosman kutirikuqtinqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jesusqa nillarantaqmi huk willakuyta: —¿Manachu huk warmipa chunka qolqenmanta huknin qolqen chinkaruqtin, payqa mecherota ratachispa, wasinta pichaspa mashkanman tarinankama? ");
INSERT INTO qveNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tariruspanmi ichaqa, amistadninkunata hinallataq vecinankunatapas waqyaspa ninman: “Hamuychis wasiyman, hinaspa noqawan kusikuychis, chinkasqa qolqeyta tarikapusqayrayku”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Cheqaqtapunin niykichis, saynan hanaq pachapipas, Diospa angelninkunapa ñawpaqninpi ancha kusikuy kanqa, huk huchasapa runa huchanta saqespa, Diosman kutirikuqtinqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesusqa nillarantaqmi: —Huk runapan ishkay wawankuna karan. ");
INSERT INTO qveNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Hinaqtinmi sullk'a wawanqa papanta niran: “Papáy, noqaman tupaqniy herenciayta qoykapuway”, nispa. Chaymi papanqa ishkaynin wawankunaman, herenciankuta rakipuran. ");
INSERT INTO qveNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Chay p'unchawkunapin chay sullk'a wawanqa papanmanta chashkisqanta llapallanta vendespan, karu llaqtaman ripuran. Chaypin llapallan qolqenta tukuran millay kawsaykunapi purispa. ");
INSERT INTO qveNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Hinaqtinmi manaña qolqeyoq kashaqtin, chay kasqan llaqtapi ancha muchuy karan. Chaymi mana imapas mikhunanpaq kaqtin, ");
INSERT INTO qveNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","huk kaqnin chakrayoqta ruegakuran imallapipas llank'anata qoykunanpaq. Chaymi chakrayoq runaqa chakranman pusaspa, kamachiran khuchikunata michinanpaq. ");
INSERT INTO qveNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Hinaqtinmi payqa yarqaymanta kaspa, khuchikunapa mikhusqan algarrobataña mikhuyta munaran. Ichaqa manan ni pipas chayllatapas qoykuranchu. ");
INSERT INTO qveNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Chaymi payqa yuyaymanaspa khaynata niran: “¡Papaypa wasinpiqa manan mikhunaqa faltanchu; llank'aqninkunapas allin mikhusqachá kashanku! ¡Noqañataqmi ichaqa, kaypi yarqaymanta wañushaniña! ");
INSERT INTO qveNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Kunanyá papaypa wasinman kutipusaq, hinaspa khaynata nisaq: ‘Papáy, huchallirukunin Diospa contranpi, hinallataq qanpa contraykipipas. ");
INSERT INTO qveNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Manañan wawaymi niwanaykipaq hinañachu kani. Aswanpas huknin kaq llank'apusuqniykita hinallañayá chashkiykuway’, nispa”. ");
INSERT INTO qveNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Saynata yuyaymanaspanmi papanpa wasinman kutinpuran. Karullataraq hamushaqtintaqmi, papanqa chinkasqa wawanta rikuruspa, apurayllaman aypaspa, khuyakuymanta abrazaspa hinallataq much'ayuspa ima, wawanta chashkiran. ");
INSERT INTO qveNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Hinaqtinmi wawanqa niran: “Papáy, huchallirukunin Diospa contranpi, hinallataq qanpa contraykipipas. Manañan ‘wawaymi’ niwanaykipaq hinañachu kani”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Hinaqtinmi papanqa sirvienten runakunata kamachiran khaynata: “Allinnin p'achata orqomuspaykichis p'achachiychis; anillowanpas, zapatowanpas churaychis. ");
INSERT INTO qveNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Hinallataq allinnin wira torillotapas apamuspa ñak'aychis, kusikuymanta mikhunanchispaq. ");
INSERT INTO qveNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kay wawayqa wañusqa hinañan karan; kunanmi ichaqa chinkasqa kasqanmanta tarirakapuni”, nispa. Chaymi paykunaqa kusisqallaña fiesta ruwayta qallariranku. ");
INSERT INTO qveNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Hinaqtinmi kuraq kaq wawanqa, chakrapi llank'amusqanmanta wasiman kutinpuran. Papanpa wasinpa ladonman yaqaña chayaramushaspataqmi, fiesta ruwasqanku musicata hinallataq tususqankutawan uyariran. ");
INSERT INTO qveNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Chaymi payqa huk sirviente runata waqyaspa tapuran: “¿Imanaqtintaq fiestatari ruwashankú?” nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Hinaqtinmi chay sirviente runaqa contestaran: “Ripuq sullk'a wawqeykin kutiranpusqa sanolla. Chaymi papaykiqa kusikuymanta fiestata ruwashan. Mikhunankupaqpas allinnin wira torillotan ñak'arachinpas”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Chaymi kuraq wawanqa nishuta phiñarukuspa, chay fiestamanqa mana haykuyta munaranchu. Hinaqtinmi papanqa lloqsimuspa ruegaran haykunanpaq. ");
INSERT INTO qveNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ichaqa chay kuraq wawanñataqmi, papanta niran: “Kay unay watañan kasukuspay tukuy imapi yanapayki. Ichaqa manan qoykuwarankichu huk cabrachallatapas, amigoykunawan fiestata ruwaspa mikhurunaykupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kunantaq ichaqa, kay wawayki, mana allinpi puriq warmikunawan tukuy qosqaykitapas tukuramuspa kutiramuqtin, huk allinnin wira torillotaraq ñak'arachipunki; hinaspa fiestataraq ruwashankipas”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Chaymi papanqa chay kuraq wawanta, khaynata niran: “Wawalláy, qanqa sapa p'unchawmi noqawan kashanki. Qanpaqmi kanqa tukuy ima kaqniykunapas. ");
INSERT INTO qveNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kay wawqeykiqa wañusqapas kashanman hinan karan, kunanmi ichaqa kawsariramun. Chinkasqapas kashanman hinan karan, kunanmi ichaqa rikhuriramun. Chaymi noqanchisqa kusikuymanta fiestata ruwananchis”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesusmi discipulonkunata nillarantaq khaynata: —Huk qapaq runapan karan huk mayordomon. Chay qapaq runamanmi willamuranku khaynata: “Chay mayordomoykiqa nishutan usuchishan tukuy ima kaqniykikunata”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Hinaqtinmi patronninqa chay mayordomonta waqyachimuspa niran: “¿Imatan ruwashanki kaqniykunawan? Kaqniykunawan mana allin ruwasqaykitan willawanku. Chaymi kunan tukuy ima kaqniykunamanta cuentata qowanki. Hinaspapas qanqa manañan mayordomoyñachu kanki”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Chaymi chay mayordomonqa sonqon ukhullapi khaynata piensaran: “¿Kunanri imatataq ruwasaq llank'anaymanta patronniy qarqowaqtinrí? Chakrapi llank'aytaqa manan atiymanchu; limosna mañakuytapas p'enqakunitaqmi. ");
INSERT INTO qveNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aswanyá patronniy manaraq qarqoruwashaqtin, runakunata yanaparusaq, paykunapas manaña mayordomo kaqtiy, wasinkupi samachiwaspa yanapawanankupaq”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Chaymi patronninman debeqnin runakunata waqyachimuspa, huk-hukllamanta tapuran. Primer kaqtan tapuran khaynata: “¿Hayk'atataq patronniymanri debeshankí?” nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Hinaqtinmi chay debeq runaqa niran: “Ishkay chunka cilindro aceitetan debeshani”, nispa. Chaymi chay mayordomoqa niran: “Kaypin contrato ruwasqayki papelqa kashan. Kunachallan aswan huk contratota ruway chunka cilindro aceitellamantaña”, nispa. Nota: pachaq barril aceiteqa, ishkay chunka cilindron karan. ");
INSERT INTO qveNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Nillarantaqmi huknin debeqtapas: “¿Hayk'atataq patronniymanri debeshankí?” nispa. Hinaqtinmi chay debeq runaqa niran: “Pachaq carga trigotan debeshani”, nispa. Chaymi mayordomoqa paytapas niran: “Kaypin contrato ruwasqayki papelqa kashan. Kunachallan aswan huk contratota ruway pusaq chunka cargallamantaña”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Hinaspan patronninqa suwa mayordomonpa ruwasqanta yacharuspa, sayna ruwasqanmanta admirakuspa allinta paymanta rimaran. Chaymi kunan qankunatapas niykichis, Diospi mana creeq runakunaqa, Diospa wawan runakunamantaqa aswan más astuton kanku, paykunapura qolqenkuwan yanapanakunankupaq. Ichaqa Diospi creeq runakunañataqmi, qolqenkuwanpas mana yanapanakuyta yachankuchu. ");
INSERT INTO qveNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Chayraykun niykichis: Kay pachapi mana allinkunapi gastanaykichis qolqeykichiswanqa, runakunatayá yanapaychis, amigoykichis kananpaq. Saynapi qolqeykichis manaña kaqtinpas, hanaq pachapin kanqa ashka amigoykichiskuna qankunata chaypi chashkisunaykichispaq. ");
INSERT INTO qveNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Pipas chikallan qosqaykita, allinta cuidanqa chayqa, ashka qosqaykitapas allintan cuidanqa. Ichaqa, pipas chikallan qosqaykita, mana allintachu cuidanqa chayqa, ashka qosqaykitapas, manan allintachu cuidanqa. ");
INSERT INTO qveNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Chaymi niykichis, kay pachapi imapas cosaskunata, sichus qankuna mana allintachu cuidankichis chayri, ¿pitaq qankunamanri confiasunkichisman hanaq pachapi ancha valorniyoq kaqkunatarí? ");
INSERT INTO qveNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ichaqa kay pachapi imapas kaqkunata, mana allinta cuidashaqtiykichisri, ¿pitaq qankunamanri imatapas qosunkichisman kikiykichispa kananpaqrí? ");
INSERT INTO qveNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Manan ni pi sirvientepas ishkay patronkunataqa kasqan ratollaqa serviyta atinmanchu. Huknin kaq patronnintan masta khuyakuspa allinta servinman; huknin kaq patronnintañataqmi cheqnikuspa mana allintachu servinman. Saynallataqmi pipas kay pachapi qapaq kayllata munaspaqa, manan Diostaqa allintachu servinman, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Chaymi fariseo religionniyoq runakunaqa, Jesuspa yachachisqanta uyarispanku asikuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Saynataqa asikuranku paykunaman qolqe anchata gustasqanraykun. Hinaqtinmi Jesusqa paykunata niran: —Qankunaqa, runakuna qawasunallaykichispaqmi, allin rikusqa kayta munankichis. Diosmi ichaqa sonqoykichista reqsin imayna huchasapa kasqaykichista. Kay pachapi runakunapa rikunallanpaq ancha importante kaqkunaqa, Diospa ñawpaqninpiqa mana imapaq valeqmi kanku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Jesusqa nillarantaqmi: —Bautizaq Juanpa willakusqan tiempokaman runakunaqa, Moisespa escribisqan leykunata, hinallataq profetakunapa yachachisqankunatawan ima kasukuspa kawsaranku. Ichaqa Bautizaq Juanpa yachachisqan p'unchawmantapachan, Diosmanta allin willakuykunata runakunaqa uyarishanku. Chaymi ashka runakunaqa, Diospa gobiernasqan sumaq glorianman imaynatapas haykuytapuni munashanku. ");
INSERT INTO qveNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ichaqa kunan p'unchawkamapas Moisespa escribisqan leykunaqa valellashanmi. Chaymi niykichis, hanaq pachaña otaq kay pachaña chinkanman hinaqtinpas, Moisespa escribisqan leykunamantaqa, manan ni huk letrallapas chinkanqachu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Jesusqa nillarantaqmi: —Pipas warminmanta t'aqakuspa, huk warmiwan tiyanqa otaq casarakunqa chayqa, Diospa contranpin waqllikuy huchata ruwashan. Saynallataqmi pipas, tiyanqa otaq casarakunqa, qosanmanta t'aqakuq warmiwan chayqa, Diospa contrallanpitaqmi waqllikuy huchata ruwashan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesusqa nillarantaqmi kay willakuyta: —Huk qapaq runan karan ancha allin fino p'achakunallawan p'achakuq. Paymi sapa p'unchaw fiestata ruwaspa, tukuy ima allin mikhunakunallata ruwachiq mikhunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Kallarantaqmi huk wakcha runapas Lázaro sutiyoq. Paymi chay qapaq runapa wasinpa punkunpi kasharan, sarna onqoypa tukusqan. ");
INSERT INTO qveNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Hinaqtinmi payqa chay qapaq runapa mesanmanta pampaman urmaq mikhunawan saqsaykuyta munaran. Chaypi kashaqtinmi, chay wakcha runataqa, alqokunallaña sarnankunatapas llaqwaran. ");
INSERT INTO qveNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Sayna kashaspan chay wakcha Lázaro runaqa, huk p'unchaw wañupuran. Hinaqtinmi Diospa angelninkuna hanaq pachaman almanta aparanku, Abrahampa kasqanman. Saynallataqmi chay qapaq runapas wañullarantaq, hinaqtinmi p'amparanku. ");
INSERT INTO qveNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Chay qapaq runaqa, wañusqakunapa kasqanpi anchata ñak'arishaspanmi, karumanta qawarispa, Abrahamtawan kushkata chay wakcha Lázaro runata rikuran. ");
INSERT INTO qveNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Chaymi chay qapaq runaqa, ancha ñak'ariypi tarikuspa, waqyakuran khaynata: “¡Taytáy Abraham, khuyapayaykuway! Hinaspa Lazarota mandamuway, dedonpa puntallanpipas unuta apamuspa, qallullaytapas apichaykuwananpaq. Noqaqa kay nina rawraypin anchata ñak'arishani”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Chaymi Abrahamqa contestamuran khaynata: “Yuyariy wawalláy. Ñawpaq kawsayniykipiqa tukuy imayoqmi karanki. Lázaron ichaqa mana ni imayoq kaspa anchata ñak'ariran. Kunanmi payqa ancha kusisqa kaypi kashan. Qanñataqmi ichaqa, chaypi anchata ñak'arishanki. ");
INSERT INTO qveNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Manan pipas kaymantaqa qankunapa kasqaykichismanqa, hamuytaña munaspapas, chimpamuytaqa atinmanchu. Nitaqmi qankunapas noqaykupa kasqaykumanqa chimpamuyta atiwaqchishchu, ukhu-ukhu mana tukukuq wayq'o rakiwasqanchisrayku”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Chaymi, chay qapaq runaqa niran: “Taytáy Abraham, ruegakuykin, papaypa wasinpi kaqkunamanyá Lázaro willaranpuwachun. ");
INSERT INTO qveNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Chaypin pishqaraq wawqeykuna kashan. Paykunaqa amañayá kaypi ñak'arinankupaqqa hamuchunkuñachu”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Hinaqtinmi Abrahamqa contestaran khaynata: “Chaypaqmi Moisespa escribisqan leykunata, hinallataq Diosmanta willakuq profetakunapa escribisqanta hap'ishanku; chaytayá kasukuchunku”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Hinaqtinmi chay qapaq runaqa niran: “Taytáy Abraham, ¡manan chaykunallataqa kasunkumanchu! Sichus huk runa wañusqanmanta kawsarispa riqtinmi ichaqa, huchankuta saqespa, Diosman kutirikunkuman”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Chaymi Abrahamñataq contestaran: “Moisespa escribisqan leytapas, hinallataq Diosmanta willakuq profetakunapa willakusqantapas mana kasukushaspankuqa, manan creenkumanchu, huk runaña wañusqanmanta kawsarispa willakuq riqtinpas”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesusqa discipulonkunatan niran: —Huchaman runamasinta urmachiq runakunaqa kanqapunin. Ichaqa ¡Ay, imaynaraq kanqa runamasinta huchaman urmachiq runaqa! ");
INSERT INTO qveNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Chaymi niykichis, sichus chay runa noqapi chayraq iñiqkunata huchaman urmachinman chayqa, aswan allinmi kanman sayna runakunataqa, huk hatun molino rumita kunkanman wataruspa, lamar qochaman wikch'uyuqtinku, chaypi wañunanpaq. ");
INSERT INTO qveNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Saynaqa amayá runamasiykichispa contranpiqa imatapas ruwankichishchu. Sichus runamasiyki qanpa contraykipi imatapas ruwaspa ofendesuqtiykiqa, q'aqchay yuyayman kutirinanpaq, hinallataq “perdonaway” nisuqtiykipas, perdonaykuyá. ");
INSERT INTO qveNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Saynallataq sichus pipas huk p'unchawllapi qanchis kutita ofendesuspayki, qanchis kutita kutimuspa “perdonaway”, nisunki chayqa, perdonaykuyá, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Apostolninkunan Jesusta niranku: —Iñiyniykuta yapaykuwayku, astawan Diospi creenaykupaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Hinaqtinmi Jesusqa contestaran khaynata: —Sichus qankunapa iñiyniykichis huk mostaza mukhu hina sayaychallapas, kanman chayqa, qankunaqa kay hatun sach'atan niwaqchis: “Saphiykimanta p'elakuspa lamar qochapi saphichakuspa wiñamuy”, nispa. Hinaqtinqa kay sach'aqa, kasusunkichismanmi, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Jesusqa nillarantaqmi khaynata: —Kamachinaykichis sirviente runa yapusqanmanta otaq animalniykichis michimusqanmanta kutiramuqtinqa, manan qankunaqa niwaqchishchu: “mesapi tiyayuspa mikhuy”, nispachu. ");
INSERT INTO qveNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Aswanmi niwaqchis: “Cenayta ruwamuspa, sirviente p'achaykiwan cambiakamuspayki, servimuway mikhunaypaq, hinallataq tomanaypaq ima; chaymantaña qanqa mikhunkipas, hinallataq tomankipas”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Saynata kamachishaspapas, qankunaqa manan gracias niyllatapas yachankichishchu. ");
INSERT INTO qveNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ichaqa qankunaqa Diospaq imatapas ruwaspaykichisqa, aman suyankichishchu “gracias” nispa nisunaykichistaqa. Aswanmi ninaykichis: “Noqaykuqa Diospa sirvientellanmi kayku. Hinaspapas noqaykuqa Diospa kamachillawasqankutan imatapas ruwayku”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesusmi Jerusalén llaqtaman rishaspa, Galilea provinciawan hinallataq Samaria provinciawan tupanakuqnin lugarninta pasasharan. ");
INSERT INTO qveNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Hinaqtinmi huk taksa llaqtachaman chayashaqtin, chunka runakuna lepra onqoyniyoqkama, Jesusman aypamuranku. Hinaspan karullapi sayayuspanku ");
INSERT INTO qveNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","waqyakamuranku khaynata: —¡Señor Jesús, khuyapayaykuwayku! nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Chaymi paykunata qawarispa Jesusqa niran: —Jerusalén templopi sacerdotekunaman rispaykichis, qawachikamuychis, nispa. Hinaqtinmi ñan risqankupi chay chunkantin lepra onqoyniyoq runakunaqa, sanoyapuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Chaymi paykunamanta huknin kaq runaqa, sanoña kasqanta qawayukuspa, Jesusman kutiran Diosta alabastin, hinallataq graciasta qostin ima. ");
INSERT INTO qveNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesuspa kasqanman chayaruspantaqmi, qonqoriyukuspa k'umuyuran pampakama, hinaspan graciasta qoran. Chay runaqa karan Samaria provincia llaqtamantan. ");
INSERT INTO qveNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Chaymi Jesusqa niran: —¿Acaso manachu chunka runakuna chay lepra onqoymantaqa sanoyarankú? ¿Maytaq wakin esqon runakunarí? ");
INSERT INTO qveNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Kay sapallan forastero runallachu Diosta alabananpaq kutimuranrí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Saynata nispanmi, Jesusqa chay runata niran: —Sayarispa ripuy, noqapi confiasqaykiraykun sanoña kanki, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fariseo religionniyoq runakunan Jesusta tapuranku: —Diospa gobiernanan p'unchawri ¿hayk'aqtaq qallarinqa? nispanku. Chaymi paykunata Jesusqa contestaran: —Diospa gobiernanan p'unchawqa manan runakunapa rikunanpaq hinachu kanqa. ");
INSERT INTO qveNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Manataqmi pipas ninmanchu: “Kaypin kashan” otaq “waqpin kashan”, nispaqa. Aswanmi Diospa gobiernasqan sumaq glorianqa qankuna ukhupiña kashan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Chaymantan Jesusqa discipulonkunata khaynata niran: —Chayamunqan p'unchaw noqa Diosmanta Hamuq Runataqa rikuyta munanaykichispaq; ichaqa manan rikuwankichishchu. ");
INSERT INTO qveNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Chay p'unchawkunapin runakuna nisunkichis: “Kaypin kashan”, otaq “Waqpin kashan Cristoqa”, nispanku. Hinaqtinqa amayá qankunaqa rinkichishchu, nitaq qatikunkichispashchu. ");
INSERT INTO qveNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Imaynan rayopas llapallan runakuna rikunanpaq enteron cielotaraq llatáq nispa k'ancharin. Saynallataqmi noqa Diosmanta Hamuq Runa kutimuqtiypas, llapallan runakuna rikuwanqaku. ");
INSERT INTO qveNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ichaqa ñawpaqtan ancha-anchataraq ñak'arichiwanqaku. Hinaspan kay tiempopi kawsaq runakunaqa cheqnikuwaspa negawanqaku. ");
INSERT INTO qveNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Imaynan runakuna kawsaranku Noeypa tiemponpipas, saynallataqmi pasanqa noqa Diosmanta Hamuq Runa kutimuqtiypas. ");
INSERT INTO qveNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noeypa tiemponpi runakunaqa kusikuspankun mikhusharanku, tomasharanku, hinallataq casarakusharanku ima, Noeypa willakusqanta mana uyarispanku. Chaytaqa ruwaranku barcoman Noé haykunan p'unchawkamallan. Chaymi barcoman Noé haykuruqtin hinalla, nishuta para-paramuspa enteron mundopi qochaspa hunt'aran. Hinaqtinmi llapallan runakunaqa heq'epaspa wañuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Saynallataqmi Lotpa tiemponpipas pasaran. Runakunan mikhusharanku, tomasharanku, vendesharanku, rantikusharanku, tarpusharanku, hinallataq wasikunatapas ruwasharanku. ");
INSERT INTO qveNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ichaqa Sodoma llaqtamanta Lotpa lloqsisqan p'unchawmi, azufreyoq nina para cielomanta paramuran; hinaspan llapallan runakunata wañuchiran. ");
INSERT INTO qveNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Saynallataqmi kanqa, noqa Diosmanta Hamuq Runa kutimuqtiypas. ");
INSERT INTO qveNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Chay kutimunay p'unchawpiqa pipas wasinpa punkunpi kashaspanpas, amayá wasin ukhumanqa haykuchunñachu imantapas orqomunanpaqqa. Hinallataq pipas chakrapi llank'ashaspapas amañayá wasinmanqa kutichunñachu. ");
INSERT INTO qveNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Yuyariychisyá Lotpa warminmanta. Lotpa warminqa kachi rumimanmi tukuran, qepan lawman kutirispa qawasqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Pipas payllapaq kawsay munaqqa, wiña-wiñaypaqmi wañunqa. Ichaqa pipas noqapi creesqanrayku wañuqmi, wiña-wiñaypaq kawsanqa. ");
INSERT INTO qveNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Chaymi niykichis, tuta kutimuqtiymi ishkay runakuna camapi puñushanqaku. Hukninmi apasqa kanqa; hukninñataqmi saqesqa kanqa. ");
INSERT INTO qveNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Hinallataqmi ishkay warmikunapas kushka kutashanqaku. Hukninmi apasqa kanqa; hukninñataqmi saqesqa kanqa. ");
INSERT INTO qveNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","{Saynallataqmi ishkay runakunapas campopi kashanqaku. Hukninmi apasqa kanqa; hukninñataqmi saqesqa kanqa, nispa}. ");
INSERT INTO qveNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Hinaqtinmi chaypi uyariq runakuna Jesusta tapuranku: —Señor, ¿maypitaq pasanqa chaykunarí? nispa. Chaymi Jesusqa contestaran: —Maypin wañusqa aycha kashan, chaypin condorkunapas huñunakun. Saynallataqmi noqa hamuqtiypas pasanqa; llapallan runakunan yachanqaku hamusqayta, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesusqa huk ejemplowanmi discipulonkunata yachachiran, paykuna ama hukmanyaspa Diosmanta mañakunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Hinaspan khaynata niran: —Huk llaqtapin karan huk juez Diosta mana manchakuq, hinallataq runakunatapas mana respetaq. ");
INSERT INTO qveNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Hinaspapas kallarantaqmi chay llaqtapiqa, huk viuda. Paymi chay juezman sapa kutin rispa, ruegakuran khaynata: “Contraypi kaq runatawan allin justiciata ruwaykuway”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Chaymi chay viuda sapa p'unchaw kutipayaqtin, chay juezqa, allin justiciata mana ruwayta munashaspanpas, sonqonpi piensarispanmi niran: “Diosta mana manchakushaspaypas hinallataq runakunata mana respetashaspaypas, ");
INSERT INTO qveNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","kay viudapaqyá allin justiciata ruwaykapusaq, mana chayqa, sapa p'unchaw hamupayawaspanmi umayta nanachiwanman”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jesusqa saynata willaspanmi, khaynata niran: —Imaynan chay mana allin justicia ruwaq juezpas justiciata ruwaran; ");
INSERT INTO qveNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","saynallataqmi Diospas justiciata ruwanqa payman tuta p'unchaw wawankuna mañakuqtinkuqa; hinaspapas payqa manapunin tardanqachu contestananpaqqa. ");
INSERT INTO qveNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Chaymi cheqaqtapuni niykichis, Diosqa allin justiciatan ruwanqa mana tardaspa. Ichaqa, noqa Diosmanta Hamuq Runa, kay pachaman kutimuspay, ¿tarimuymanchu noqapi iñiq runakunata kay allpa pachapí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Wakin runakunaqa creekurankun allin justo runa kanankupaq; hinaspan wakin runamasinkuta despreciaranku. Chayta rikuspanmi, Jesusqa huk willakuyta runakunaman willaran khaynata: ");
INSERT INTO qveNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Ishkay runakunan Diosmanta mañakunankupaq, Diosta yupaychana temploman riranku. Hukninmi karan fariseo religionniyoq; hukninñataqmi karan impuesto cobraq. ");
INSERT INTO qveNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseo religionniyoq runan sayaspalla khaynata mañakuran: “Graciastan qoyki Diosnilláy, noqaqa mana huchayoq runa kasqaymanta. Chayraykun noqaqa, mana wakin runakuna hinachu kani, suwakuq, mana allinkuna ruwaq, huk warmikunawan waqllikuq, nitaqmi waq impuesto cobraq runa hinachu kanipas. ");
INSERT INTO qveNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Aswanmi noqaqa, semanapi ishkay kutikama ayunani; llapallan ganasqaykunamantapas diezmoytan qanman Diosnilláy qomuyki”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ichaqa impuesto cobraq runañataqmi, karullapi sayaruspa, alto cielotapas mana qawariranchu. Aswanmi qasqonta takakuspan khaynata mañakuran: “Diosnilláy, huchasapa runan kani; khuyapayaykuway, hinaspa huchayta perdonaykuway”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kay willakuyta tukuruspanmi, Jesusqa chay runakunata niran khaynata: “Impuesto cobraq runan huchanmanta perdonasqa wasinman kutipuran; ichaqa fariseo religionniyoq runañataqmi, huchanmantaqa mana perdonasqachu karan. Yachaychisyá, paytukuq runan humillasqa kanqa; humillakuq runañataqmi hatunchasqa kanqa”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Wawakunatan Jesusman apamuranku, makinta churaykuspa, Diosmanta mañakuspa bendecinanpaq. Chaymi Jesuspa discipulonkunaqa, wawa apamuqkunata niranku: —¡Ayqechiychis chay wawakunata; ama apamuychishchu! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Hinaqtinmi Jesusqa wawakunata waqyaspa, discipulonkunata khaynata niran: —Ama hark'aychishchu wawakuna noqaman hamunantaqa. Kay wawakuna hina kaq runakunapaqmi, Diospa gobiernasqan sumaq glorianqa kanqa. ");
INSERT INTO qveNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Chaymi cheqaqtapuni niykichis, kay wawakuna hina tukuy sonqonkuwan Diospi creeq runakunallan, Diospa gobiernasqan sumaq glorianmanqa haykunqaku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Huk allin reqsisqa qapaq runan Jesusta tapuran khaynata: —Allin yachachikuq, ¿imatataq ruwasaq Diospa ladonpi wiñaypaq kawsanaypaqrí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Chaymi Jesusqa contestaran: —¿Imanaqtintaq noqatari niwanki: “Allin yachachikuq” nisparí? Manan ni pi runapas allinqa kanchu; aswanqa Diosllan. ");
INSERT INTO qveNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Qanqa yachankiñan Diospa kamachikuyninpi, khayna nisqantaqa: “Aman huk warmikunawanqa waqllikunkichu; aman ni pitapas wañuchinkichu; aman suwakunkichu; aman pimantapas qepanpiqa llullakuspaqa rimankichu; aswanyá papaykita hinallataq mamitaykitapas respetay”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Hinaqtinmi chay qapaq runaqa, Jesusta khaynata niran: —Noqaqa wawa kasqaymantapachan chaykunataqa cumplirani, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Chayta uyarispanmi Jesusqa niran: —Kayraqmi faltashasunki ruwanayki: rispayki vendemuy tukuy kaqniykikunata, hinaspa chay qolqeta wakchakunaman rakimuy. Saynata ruwaqtiykin hanaq pachapi tukuy imayki kanqa sumaq qori qolqe hina. Chayta ruwaruspaykiña kutimunki noqata qatikuwanaykipaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Hinaqtinmi chay runaqa Jesuspa nisqanta uyarispa, anchata llakikuran, ancha qapaq runa kasqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Chaymi Jesusqa ancha llakisqallaña kasqanta qawayuspa niran: —¡Mayna sasatan qapaq runakunaqa, hanaq pachapi Diospa sumaq glorianmanqa haykunqa! ");
INSERT INTO qveNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ichaqa huk hatun camello animalraqmi awqapa ninrinta pasarunman, huk qapaq runa Diospa gobiernasqan sumaq glorianman haykunanmantaqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Chayta uyarispan, runakunaqa Jesusta tapuranku: —Sayna kaqtinri, ¿pitaq atinman salvakuytarí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Chaymi Jesusqa niran: —Runakunaqa manan atinmanchu; Diosmi ichaqa, tukuy imatapas atillanpuni, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Hinaqtinmi Pedroñataq niran: —Noqaykuqa tukuy imaykutapas saqeruspan qanta qatikushaykiku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Chaymi Jesusñataq contestaran: —Cheqaqtapunin niykichis, pipas Diospa kamachin ruwaq kayta munaspaqa, saqenanmi wasinta, warminta, wawqe-panankunata, papanta, mamitanta, hinallataq wawankunata ima. ");
INSERT INTO qveNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Saynata ruwaspan, saqesqankunamantapas aswan mastaraq chashkinqa kay pachapi, hinallataq qepa tiempopipas wiña-wiñaypaq kawsayta, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesusqa chunka ishkayniyoq akllasqan discipulonkunata huk lawman waqyarispanmi, paykunallata khaynata niran: —Kunanqa Jerusalén llaqtamanmi risunchis. Chaypin Diosmanta willakuq profeta runakunapa, tukuy imakuna noqamanta escribisqanku cumplikunqa. ");
INSERT INTO qveNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ichaqa huk law nacionniyoq runakunamanmi entregawanqaku. Chaymi paykunaqa asipayawanqaku, k'amiwanqaku, toqaykuwanqaku, ");
INSERT INTO qveNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","hinallataq anchata latigaruwaspanku wañuchiwanqaku ima. Saynata ruwawashaqtinkupas, ichaqa kinsa p'unchawmantan noqaqa kawsarinpusaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ichaqa Jesuspa discipulonkunaqa manan ni imatapas nisqanmantaqa entienderankuchu, chay rimasqankunaqa pakasqa hina kasqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jericó llaqtaman Jesús chayashaqtinmi, huk ñawsa runa ñan patapi tiyashasqa limosnata mañakuspa. ");
INSERT INTO qveNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Chaymi chay ñawsa runaqa ashka runakuna pasasqanta uyarispa, tapukuran khaynata: —¿Imataq pasashanrí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Hinaqtinmi contestaranku: —Nazaret llaqtayoq Jesusmi pasashan kayninta, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Chaymi chay ñawsa runaqa waqyakuran khaynata: —¡Davidpa mirayninmanta Jesús, ama hina kaychu, khuyapayaykuway! nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Hinaqtinmi Jesuspa ñawpaqninta riq runakunaqa, chay ñawsata niranku: —¡Upallay! ¡Upallay! nispanku. Ichaqa saynata nishaqtinkupas, chay ñawsaqa astawanraqmi qapariran khaynata: —¡Davidpa mirayninmanta Jesús, ama hina kaychu, khuyapayaykuway! nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Hinaqtinmi Jesusqa sayaykuspa kamachiran, chay ñawsa runata pusamunankupaq. Ladonpiña kashaqtintaqmi payta tapuran khaynata: ");
INSERT INTO qveNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Imatataq qanpaq ruwanaytari munankí? nispa. Chaymi chay ñawsa runaqa niran: —Señor, ¡qawariytan munani! nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Chaymi Jesusqa niran: —¡Qawariy! Noqapi confiasqaykiraykun Dios sanoyachisunki, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Hinaqtinmi chay ñawsa runaqa, kasqan ratolla sanoyaspa qawariran. Hinaspan payqa Jesusta qatikuran Diosta alabastin. Saynallataqmi chaypi kaq llapallan runakunapas, chaykunata rikuspanku Diosta alabaranku. ");
INSERT INTO qveNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesusmi Jericó sutiyoq llaqtaman haykuspa, chayninta pasasharan. ");
INSERT INTO qveNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Hinaqtinmi chay llaqtapi tiyaran huk qapaq runa Zaqueo sutiyoq. Payqa karan impuesto cobraqkunapa jefenmi. ");
INSERT INTO qveNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Paymi Jesusta reqsiyta munaspa qawaq riran. Taksalla kaspataqmi, ashka runakuna chaypi kaqtin, Jesusta mana rikuyta atiranchu. ");
INSERT INTO qveNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Chaymi Zaqueoqa apurayllamanña ñawparan, maynintas Jesús pasanqa chayman. Hinaspan huk sicómoro sutiyoq sach'aman wicharan, Jesusta allinta rikunanpaq. ");
INSERT INTO qveNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Chayninta Jesús pasashaspanmi, sach'a hawapi Zaqueota rikuspa, sutinmanta waqyaran: —¡Zaqueo, apurayman urayamuy! Kunanmi qanpa wasiykipi samasaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Chaymi Zaqueoqa apurayllamanña urayamuspa, kusisqallaña Jesusta wasinman pusaran. ");
INSERT INTO qveNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Chayta rikuspankutaqmi, runakunaqa Jesuspa contranpi rimaranku khaynata: —Huchasapa runaq wasinmanmi haykurparin, chaypi samananpaq, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zaqueoñataqmi, tiyasqanmanta sayarispa Señor Jesusta niran: —Señor, kunanmi tukuy kaqniykunamanta kushkanta wakchakunaman qosaq. Hinallataqmi sichus pitapas engañarani chayqa, tawa kutitan kutichipusaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesusñataqmi niran: —Kunanmi qanpas hinallataq familiaykipas salvasqa kankichis, Abrahampa iñiynin hina qankunapa iñiyniykichispas kasqanrayku, hinallataq Abrahampa mirayninmanta kasqaykichisrayku. ");
INSERT INTO qveNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Noqa Diosmanta Hamuq Runaqa, chinkasqa runakunata mashkaspa salvanaypaqmi hamurani, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jerusalén llaqtapa cercanpiña Jesús kashaqtinmi, runakuna Jesuspa nisqanta uyarispanku piensaranku, Jesusqa Jerusalén llaqtaman chayaspa kasqan ratolla gobiernayta qallarinanpaq. Chaymi Jesusqa huk ejemplowan willaran khaynata: ");
INSERT INTO qveNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","—Huk allin reqsisqa runan gobiernananpaq nombramienton chashkikuq karu nación llaqtaman viajaran, chaymanta kutimuspa gobiernananpaq. ");
INSERT INTO qveNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Chaymi, chay runaqa manaraq viajashaspa, chunka llank'aqnin runakunata waqyaran. Hinaspan sapankamaman ashka qolqeta saqetamuran: “Kutimunaykama kay qolqewan negociota ruwashaychis”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ichaqa chay allin reqsisqa runataqa, llaqtamasin runakunaqa cheqnikurankun. Chaymi viajasqanpa qepallanta huk comisionta mandaranku, contranpi khaynata nimunankupaq: “Manan paytaqa munaykuchu noqaykuta gobiernawanankutaqa”, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ichaqa chay allin reqsisqa runaqa, gobiernananpaq nombrasqaña kaspanmi, llaqtanman kutimuran. Hinaspan chunkantin llank'aqninkunata waqyachimuran, saynapi chay qolqe saqesqanwan ima negociokunatas ruwaranku, chayta yachananpaq. ");
INSERT INTO qveNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Chaymi chay primer kaq llank'aq chayamuspa, khaynata niran: “Señorlláy, negociota ruwaspaymi chay qolqe saqewasqaykiwan chunka kuti mastaraq ganaramuni”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Chay gobiernaqñataqmi contestaran: “Allinmi, qanqa allin llank'aqniymi kanki. Chaymi kay chikallan saqesqayta allinta cuidasqaykirayku, kunan nombrasqayki, chunka llaqtakunata kamachinaykipaq”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Chayllamanmi qepa kaq llank'aqninpas chayaramuspa nillarantaq: “Señorlláy, qolqe saqewasqaykiwanmi negociota ruwaspay, pishqa kuti mastaraq ganaramuni”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Chaymi paytapas chay gobiernaqqa niran: “Kunanmi noqa qantapas nombrasqayki, pishqa llaqtakunata kamachinaykipaq”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Chayllamanmi huknin kaq llank'aqninpas chayaramuspa nillarantaq: “Señorlláy, kay qolqeykitan apanpushayki kaqllata. Noqaqa alli-allintan pañuelopi khipuruspa waqaycharani. ");
INSERT INTO qveNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ichaqa qantan noqaqa nishuta manchakuyki, ancha manchakunapaq kasqaykirayku. Hinaspapas noqaqa yachanin qanqa mana churasqaykimanta oqarisqaykita, hinallataq mana tarpusqaykimanta cosechasqaykitapas”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Chaymi chay gobiernaq runaqa niran: “Qanqa kanki mana allin llank'aqmi. Chaymi kikillayki rimasqaykiman hina condenasqa kanki. Qanqa allintan yacharanki noqaqa exigente runa kasqayta, mana churasqaymanta oqarisqayta, hinallataq mana tarpusqaymanta cosechasqayta ima. ");
INSERT INTO qveNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Chayri, ¿imanaqtintaq qanri kay qolqeyta mana bancollamanpas churarankichu, kutimuspay gananciayoqta orqokanpunaypaqrí?” nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Saynata nispanmi chay gobiernaq runaqa, wakin llank'aq runakunata kamachiran khaynata: “Chay mana llank'aq inútil qella runamanta, qolqeta qechuychis. Hinaspa qoychis chunka kuti mastaraq ganamuq runaman”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Chaymi paykunaqa niranku: “Señorlláy, ¿imanaqtintaq paymanri qosaqkú? Paypaqa ñan kashanña chunka kuti masraq”, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Hinaqtinmi chay gobiernaq runaqa contestaspa niran: “Kunanmi nisqaykichis, pipas Diosmanta chashkisqankunawan allinta ruwanqa chayqa, Diosmantan masta chashkinqa. Ichaqa pipas Diosmanta chashkisqankunawan mana allintachu ruwanqa chayqa, chay llapan chashkisqankunatan kikin Diospuni qechupunqa. ");
INSERT INTO qveNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Saynallataqmi kay llaqtapi noqapa gobiernanayta mana munaspa, contraypi sayariq runakunatapas, ñawpaqniyman apachimuspay, wañuchinankupaq kamachisaq”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesusqa chaykunata rimayta tukuruspanmi, runakunapa ñawpaqninta Jerusalén llaqtaman riran. ");
INSERT INTO qveNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Hinaspan Betfagé llaqtaman hinallataq Betania llaqtamanwan yaqaña chayaykushaspan, Jesusqa samariran Olivos nisqa moqopa ladonpi. Hinaspan ishkaynin discipulonkunata khaynata niran: ");
INSERT INTO qveNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Riychis waq chimpapi llaqtachaman. Chaypin qankunaqa tarinkichis manaraq pipapas montakusqan watasqa malta asnota. Chay asnota pashkamuspayá aysamuychis. ");
INSERT INTO qveNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Sichus pipas tapusunkichis: “¿Imapaqmi chay asnota pashkashankichís?”, nispa, nisuqtiykichisqa, khaynatan ninkichis: “Señormi necesitashan”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Chaymi chay ishkay discipulokunaqa rispanku, Jesuspa nisqanman hina tariranku chay asnota. ");
INSERT INTO qveNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Hinaqtinmi chay malta asnota pashkasqankuta rikuspanku, chay asnopa dueñonkunaqa tapuranku khaynata: —¿Imapaqmi pashkashankichis asnoykuta? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Chaymi Jesuspa discipulonkunaqa contestaranku: —Señormi kay asnota necesitashan, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Saynata nispankun paykunaqa chay asnota apamuranku, Jesuspa kasqanman. Hinaspan discipulonkunaqa p'achankuwan karunaspanku, Jesusta chay asnopi montachiranku. ");
INSERT INTO qveNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Hinaqtinmi Jerusalén llaqtaman Jesús rishaqtin, paywan kushka riq runakunaqa, Jesuspa risqan ñanpi p'achankuta mast'aranku. ");
INSERT INTO qveNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Olivos moqo urayta rishaqtintaqmi, Jesuswan llapallan riq runakunaqa, tukuy milagrokuna ruwasqanta rikusqankuwan anchata kusikuranku. Hinaspan Diosta alabayta qallariranku, khaynata qaparispanku: ");
INSERT INTO qveNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","—¡Alabasqayá kachun, Señor Diospa sutinpi gobiernawananchispaq hamuq Reyqa! ¡Hawkayay kachun hanaq pachapi; hinallataq Diospas alabasqa kachun! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Hinaqtinmi fariseo religionniyoq wakin runakunaqa, chay ashka runakunapa chawpinmanta, Jesusta reclamaspa nimuranku: —Yachachikuq, discipuloykikunataqa upallachiy, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Chaymi Jesusqa chay reclamamuq fariseo runakunata contestaran khaynata: —Kunanmi cheqaqtapuni nisqaykichis, sichus paykuna upallaqtinkuqa, rumikunan paykunapa rantinta qaparinqaku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jerusalén llaqtaman yaqaña chayashaspanmi, Jesusqa llaqtata qawarispa, waqaran, ");
INSERT INTO qveNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","khaynata nispa: —¡Jerusalén llaqtapi tiyaq runakuna, ima allinchá kanman kunan p'unchawllapas hawkayaypi qankuna tiyayta yachaqtiykichisqa! Ichaqa manan qankunaqa entiendeyta atinkichishchu, qankunamanta pakasqa kasqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ichaqa chayamunqan qankunapaq mana allin p'unchawkuna. Chay p'unchawkunapin kay llaqtaykichispa muyuriqninpi hatun perqaykichispa qepanman allpakunata enemigoykichis runakuna montonamunqaku, chayninta haykumuspa, qankunata hap'isunaykichispaq. Hinaqtinmi mana ni mayqenniykichispas ayqekuytaqa atinkichishchu. ");
INSERT INTO qveNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Chaymi kay llaqtapi llapallan tiyaqkunataqa wañuchisunkichis. Saynallataqmi kay llaqtapi llapallan wasikunatapas thuñichinqaku. Hinaqtinmi manan ni ima rumi perqapas qepanqachu. Saynataqa ruwanqaku, salvasunaykichispaq hamuq Diosta, mana chashkisqaykichisraykun, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jerusalén llaqtaman chayaruspanmi, Jesusqa temploman riran. Hinaspan chay templomanta qarqoran llapallan chaypi vendeq runakunata. ");
INSERT INTO qveNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Hinaspanmi khaynata niran: —Bibliapiqa nishanmi: “Kay wasiyqa Diosmanta mañakuna wasin”, nispa. Ichaqa kunanmi qankuna tukurachinkichis suwakunapa wasinman, nispa Isaías 56.7; Jeremías 7.11. ");
INSERT INTO qveNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Chaymantan Jesusqa sapa p'unchaw temploman riran chaypi yachachinanpaq. Hinaqtinmi sacerdotekunapa jefenkunaqa, leykunata yachachiqkunapiwan, hinallataq llaqtapi kamachiq autoridadkunapiwan ima huñunakuranku. Hinaspan yachachinakuranku imaynatas Jesusta wañurachinankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ichaqa manataqmi ni imaynanmantapas wañuchiyta atirankutaqchu, Jesuspa yachachisqanta uyarinankupaq, ashka runakuna chaypi kasqankurayku. ");
INSERT INTO qveNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Jesusmi huk p'unchaw Jerusalén templopi Diosmanta allin willakuykunata runakunaman yachachisharan. Chaymanmi sacerdotekunapa jefen, leykunata yachachiqkuna, hinallataq Israel nacionpi kamachiq runakunapiwan ima, Jesusman ashuyuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Hinaspan tapuranku khaynata: —Niwayku, ¿pitaq qantari autorizasuranki, kaykunata ruwanaykipaqrí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesusñataqmi contestaran: —Noqapas kunan qankunata tapusqaykichis; niwaychis: ");
INSERT INTO qveNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Pitaq Juantari mandamuran bautizananpaq? ¿Dioschu icha runakunachú? nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Saynata Jesús tapuqtinmi paykunapura parlanakuranku khaynata: —“Diosmanta” nisun chayqa, niwasunmi “¿Imanaqtintaq qankunari mana Juanpi creerankichishchú?” nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","“Runakunallan mandamuran”, nispa nisunchis chayqa, kay llaqtapi tiyaq llapallan runakunachá rumiwan p'anaspa wañurachiwasunman. Hinaspapas kay llaqtapi tiyaq runakunaqa ancha convencesqan kashanku, Juanqa Diosmanta willakuq profeta kasqanta, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Saynata parlaruspankun, Jesusta contestaranku: —Manan noqaykuqa yachaykuchu, pichá Juantaqa mandamuranpas, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Hinaqtinmi Jesusqa paykunata niran: —Noqapas manan nisqaykichishchu ima atiywansi kaykuna ruwasqaytaqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Chaymantan Jesusqa runakunaman yachachiran, huk willakuywan khaynata: —Huk runan uvas plantakunata chakranpi plantaran. Hinaspan chay runaqa chay uvas chakranta huk llank'aq runakunaman arrendaspa, unay tiempopaq ripuran. ");
INSERT INTO qveNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Uvas cosechana tiempo chayaramuqtintaqmi, chakrayoqqa huk serviqnin runata mandamuran, tupaqninta chashkispa apapunanpaq. Hinaqtinmi chay arrendaq runakunaqa, chakrayoqpa serviqnin runata, nishuta maqaruspanku, mana imayoqllata qatirpapuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Hinaqtinmi chakrayoq runaqa, yapamanta huk serviqnin runatañataq mandamuran. Chayaramuqtinmi paytapas k'amispanku, alli-allinta maqaruspanku mana imayoqllata qatirpapuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Chaymantan chakrayoq runaqa huk serviqnin runatañataq mandamuran. Paytapas saynallataqmi alli-allinta maqaruspanku, ancha k'irisqata qarqorparanku. ");
INSERT INTO qveNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Hinaqtinmi uvas chakrayoq runaqa yuyaymanaran khaynata: “Kunanri, ¿imatataq ruwasaq? Aswanyá ancha munakusqay wawayta mandasaq. Payta rikuspaqa ichapas respetankuman”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Chaymi arrendaq runakunaqa, chakrayoqpa wawanta rikuruspanku, paykunapura yachachinakuranku khaynata: “Kay wawanpaqmi papanpa kaqninkunaqa qepanqa. Aswanyá paytaqa wañurachillasunña, kay enteron herencia chakrawan qepakunanchispaq”, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Saynata piensaruspankun, uvas chakrayoqpa wawantaqa, chakramanta hawaman aparuspanku wañuchiranku. Hinaqtinmi Jesusqa chay uyariqkunata tapuran: —Uvas chakrayoqri, ¿imananqataq wawanta wañuchiq runakunatarí? ");
INSERT INTO qveNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ichaqa uvas chakrapa dueñon kutimuspanmi, chay mana allin llank'aqkunataqa wañuchinqa, wawanta wañuchisqankurayku. Hinaspan uvas chakrantapas huk runakunamanña arrendanqa, nispa. Chayta uyariruspankun, runakunaqa niranku: —Amayá hayk'aqpas chaykunaqa pasachunchu, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Hinaqtinmi Jesusqa paykunata qawarispa niran: —Bibliapiqa khaynan escribisqa kashan: “Albañilkunapa mana munasqan rumin, kunanqa allin kaq rumi, wasiq esquinanpi allinta enteron wasipa perqanta sostienen”, nispa Salmos 118.22. ");
INSERT INTO qveNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ichaqa pipas chay rumi hawaman urmayuspaqa ñut'usqan kanqa. Saynallataqmi pi runapa hawanmanpas chay rumi urmayuspaqa, kutasqa aychaman hinaraq chay runataqa tukuchinqa. Nota: Chay albañilkunapa mana munasqanku rumiqa, Jesucriston. ");
INSERT INTO qveNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Chaymi Moisespa escribisqan ley yachachiqkuna, hinallataq Jerusalén templopi sacerdotekunapa jefenkunapas cuentata qokuranku, chay millay wañuchiq runakunawan paykunata comparaspa Jesusqa yachachisqanta. Chayraykun paykunaqa Jesusta chay ratolla hap'iruytapuni munaranku. Ichaqa runakunata manchakuspankun, mana hap'irankuchu. ");
INSERT INTO qveNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Jesuspa contranpi kaq runakunan, Roma llaqtapi kamachiqman Jesusta entregayta munaranku. Chayraykun allin tukuq runakunata mandaranku, Jesuspa rimasqanta disimulawlla uyarinankupaq, hinallataq ima rimasqanpipas pantaruqtinqa, chayman hinalla tumpaspa autoridadkunaman entreganankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Hinaqtinmi chay allin tukuq runakunaqa, Jesusta khaynata niranku: —Yachachikuq, yachaykun qanpa yachachisqaykiqa cheqaqpuni kasqanta. Qanqa manan pimanpas sayapakunkichu; aswanmi yachachinki imaynan Diospa munasqanman hina kawsanaykumanta. ");
INSERT INTO qveNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Chaymi qanta tapukuyta munayku: ¿Allinchu kanman icha manachu, Roma llaqtapi rey Cesarman impuestota paganaykupaqrí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Hinaqtinmi Jesusqa engañollawan tapusqankuta yachaspa, contestaran khaynata: —¿Imanaqtintaq qankunari pantachiwayta munashankichís? ");
INSERT INTO qveNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Apamuychis huk qolqeta qawanaypaq. ¿Pipa uyantaq, hinaspapas pipa sutintaq kay qolqepiri escribisqa kashan? nispa. Hinaqtinmi paykunaqa contestaranku: —Roma llaqtamanta llapallan llaqtakunata kamachikamuq Rey Cesarpan, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Chaymi Jesusqa niran: —Saynaqa Roma llaqtamanta llapallan llaqtakunata kamachikamuq rey Cesarpa kaqtaqa, payman qopuychis. Diospaq kaqtataq, Diosman qopuychis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Chay runakunaqa manan Jesustaqa pantachiytaqa atirankuchu. Aswanmi Jesuspa contestasqanwan admirakuspanku upallallaña karanku. ");
INSERT INTO qveNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Chaymantan wakin saduceo religionniyoq runakunapas Jesusman hamullarankutaq. Paykunaqa wañuq runakuna kawsarimunanpiqa manan creerankuchu. Chayraykun Jesusta khaynata niranku: ");
INSERT INTO qveNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Yachachikuq, Moisespa escribisqan leypin niwanchis: “Huk runa casarakuspa, warminpi manaraq wawan kashaqtin wañupunman chayqa, wawqenmi chay viudawan casarakuspa wawayoq kanan. Hinallataqmi chay wawa nacemuqpas, wañuqpa wawan hina kaspa, paypa sutinta apanan, saynapi wañuq wawqenpa sutin ama chinkananpaq”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Huk kutinpin karan qanchis wawqekuna. Hinaqtinmi kuraq kaqqa casarakuspa, manaraq wawayoq kashaspa wañupuran. ");
INSERT INTO qveNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Hinallataqmi wañuqman qatiq wawqenpas, chay wañuqpa viudanwan casarakullarantaq. Hinaspan chay viudapi manaraq wawan kashaqtin, wañupullarantaq. ");
INSERT INTO qveNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Saynallataqmi chay wañuqman qatiq wawqenpas chay viudawan casarakullarantaq. Paypas manaraq chay viudapi wawan kashaqtinmi, wañupullarantaq. Saynatan chay viudawanqa qanchisnintin wawqekuna casarakuranku. Ichaqa chay viudapi manaraq wawanku kashaqtinmi, paykunaqa wañupuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Chaymantan viuda warmipas wañupullarantaq. ");
INSERT INTO qveNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kunanyá niwayku. Llapallan wañuq runakunata Dios kawsarichimuqtinri, ¿mayqen wawqekunapa warmintaq kanqa, chay warmirí? Qanchisnintinwanmi chay warmiqa casarasqa karan, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Hinaqtinmi Jesusqa paykunata contestaran: —Kay pachapiqa qarikunapas, hinallataq warmikunapas casarakunkun. ");
INSERT INTO qveNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ichaqa Diosmi yachan, (pikunas Wawan Jesucristopi creesqankurayku), kay pacha tukukuqtin, kawsarimuspanku, paywan wiñaypaq kawsanankutaqa. Chay wiñay kawsaypiqa, manan ni pipas casarakunqachu, nitaqmi casarakuymanpas entreganakunqakuchu, ");
INSERT INTO qveNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","nitaqmi paykunaqa wañunqakupashñachu. Aswanmi paykunaqa angelkuna hina kanqaku. Hinaspapas paykunaqa Diospa wawanmi kanqaku, paypi creespa kawsarimusqankurayku. ");
INSERT INTO qveNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ichaqa (Diospi creespa) wañuq runakuna kawsarimunanmantan, Moisespas ña escribiranña khaynata: “Diosqa, Abrahampa, Isaacpa hinallataq Jacobpa Diosninmi”, nispa. Chaytaqa niran t'ankar sach'api nina rawrasqan p'unchawmi. ");
INSERT INTO qveNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Chay yachachikuywanmi Moisesqa yachachiwanchis, Diospaqqa wañusqa runakunapas kawsallasqanmanta. Chayraykun Diosqa Abrahampapas, Isaacpapas hinallataq Jacobpapas Diosnin, paykunapa almanku kawsasqanrayku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Hinaqtinmi chay contestasqanta uyarispanku, leykunata wakin yachachiqkunaqa niranku: —Yachachikuq, allintapunin qanqa rimaramunki, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Hinaqtinmi manaña pipas astawanqa ni imatapas tapuranñachu. ");
INSERT INTO qveNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesusmi chaypi kaq runakunata tapuran: —¿Imanaqtintaq runakunari ninku, Cristoqa ñawpaq rey Davidpa mirayninmantan kanqa nisparí? ");
INSERT INTO qveNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ichaqa kikin Davidmi, Salmos libropi ña escribiranña khaynata: “Señor Diosmi Señorniyta niran: ‘Phaña ladoypi tiyaykuy, ");
INSERT INTO qveNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","llapallan enemigoykikunata vencespay, chaki plantaykiman churanaykama’ ”, nispa Salmos 110.1. ");
INSERT INTO qveNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ichaqa kikin Davidpunin niran: “Señorlláy”, nispa. Chayri ¿imanaqtintaq Diosmanta Hamuq Runari, ñawpaq rey Davidpa mirayninmanta kanmanrí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Llapallan runakuna uyarishaqtinmi, Jesusqa discipulonkunata niran: ");
INSERT INTO qveNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Cuidakuychis leykuna yachachiq runakuna hina kanaykichismanta. Paykunamanqa anchatan gustan ashka qolqepa valornin p'achawan churayukuspa puriy. Hinallataqmi paykunaqa plazakunapipas respetowan runakuna rimayukunankuta munanku. Saynallataqmi Diosmanta yachachina sinagoga wasikunapipas, hinallataq fiestakunapipas, ñawpaqpi allin kaq sumaq asientokunallapi tiyaytapas munanku. ");
INSERT INTO qveNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Hinaspapas paykunaqa viudakunapa wasintan qechunku tukuy imantinta. Paykunaqa allin qawasqa kanankupaqmi, Diosmantapas una-unayllataña mañakuq tukunku. Sayna clase runakunatan Diosqa anchata castiganqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesusmi qapaq runakunata qawaran Jerusalén templopi, ofrenda churana cajaman ofrendanku churasqankuta. ");
INSERT INTO qveNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Rikullarantaqmi huk wakcha viudatapas, ofrenda churana cajaman ishkaylla qolqechan churasqanta. ");
INSERT INTO qveNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Chaymi Jesusqa niran: —Cheqaqtapunin niykichis, kay wakcha viudan llapallan qapaq runakunamantapas, aswan mastaraq churarun. ");
INSERT INTO qveNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Qapaq runakunaqa puchuq qolqellankutañan ofrendankutaqa churanku. Ichaqa kay viudañataqmi wakcha kashaspapas, llapallan mantenekunan qolqechanta churarun, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Wakin chaypi kaqkunañataqmi rimasharanku Jerusalén llaqtapi temploqa, suma-sumaq k'anchariq hatun rumikunawan ruwasqa kasqanmanta. Hinallataq perqankunapipas sumaqllaña qapaq runakunapa regalasqan adornokunawan adornasqa kasqanmanta. Chay rimasqankuta uyarispanmi Jesusqa niran: ");
INSERT INTO qveNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Chayamunqan p'unchawkuna, kay tukuy ima rikusqaykichiskuna thuñichisqa kananpaq. Manataqmi ni huk rumillapas perqasqaqa qepanqachu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jesuspa discipulonkunan paytaqa tapuranku khaynata: —Yachachikuq, ¿hayk'aqtaq kay nisqaykikunari pasanqa? ¿Imakuna pasaqtintaq yachasaqku kaykuna pasananmantarí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesusñataqmi contestaran: —Qankunaqa piwanpas ama engañachikunaykichispaq, ¡allinta cuidakuychis! Manaraq noqa hamushaqtiymi ashka runakuna hamunqaku noqapa sutiypi khaynata nispanku: “Ñan tiempoqa chayamunña, noqan kani Diosmanta Hamuq Salvaqniykichis Cristoqa”, nispa. Saynata nisuqtiykichispas aman paykunataqa qatikunkichishchu, nitaqmi creenkichispashchu. ");
INSERT INTO qveNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Qankunaqa uyarinkichismi guerrakunamanta rimaqta, hinallataq llaqta ukhupi ch'aqwakunamantapas. Aswanqa aman manchakunkichishchu. Hinan kaykunaqa pasananpuni manaraq tukukuy p'unchaw chayamushaqtin, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jesusqa nillarantaqmi: —Chay p'unchawkunapin huk nación llaqtapi tiyaq runakuna huk law nación llaqtapi tiyaq runakunawan guerrakunapi peleanqaku. ");
INSERT INTO qveNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Hinallataqmi pasanqa tukuy lawpi ancha mancharikuypaq terremotokunapas. Kallanqataqmi kaypi waqpi ancha muchuypas, hinallataq onqoypas; chaykunawanmi anchata ñak'arinqaku. Cielopipas rikhurinqan ancha mancharikuypaq señalkuna; chaykunata kay pachapi runakuna rikuspankun, anchata mancharikunqaku. ");
INSERT INTO qveNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ichaqa manaraq chaykuna pasashaqtinmi, qankunataqa qatikachasunkichis. Hap'ispataqmi apasunkichis Diosmanta yachachina sinagoga wasikunaman; carcelkunamanpas presota churasunkichis. Hinallataqmi gobernadorkunaman, reykunaman entregasunkichis ñak'arichisunaykichispaq, noqapi creesqaykichisrayku. ");
INSERT INTO qveNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Saynapin qankunapaq huk oportunidad kanqa, noqamanta paykunaman willanaykichispaq. ");
INSERT INTO qveNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Chaypiqa amayá qankunaqa preocupakunkichishchu: “Imaynatan nisaq defiendekunaypaq”, nispaqa. ");
INSERT INTO qveNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Noqan chay ratopi yanapasqaykichis yachaywan allinta rimanaykichispaq. Chaymi mayqen enemigoykichispas mana ni imaynanmantapas contestayta atisunkichishchu. ");
INSERT INTO qveNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ichaqa tayta mamaykichis, wawqeykichis, familiaykichis, hinallataq amigoykichiskunapas, traicionllawanmi autoridadkunaman entregasunkichis. Wakinniykichistataqmi wañuchisunkichis ima. ");
INSERT INTO qveNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Hinallataqmi llapallan runakunapas cheqnisunkichis, noqapi creesqaykichisrayku. ");
INSERT INTO qveNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ichaqa Diospa ñawpaqninpiqa manan ni huk chukchallaykichispas chinkanqachu. ");
INSERT INTO qveNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tukuy chaykuna pasasuqtiykichisqa, amayá ishkayankichishchu. Saynata kawsaspan qankunaqa, wiñaypaq kawsayniyoq kankichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Jesusqa nillarantaqmi: —Jerusalén llaqtapa muyuriqninpi enemigoykichis soldadokunata rikuspaykichisqa, yachankichismi kay Jerusalén llaqta thuñichinanku tiempo chayamusqanta. ");
INSERT INTO qveNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Chay p'unchaw chayamuqtinqa, Jerusalén llaqtapi tiyaqkuna lloqsiychis. Hinallataq Judea provinciapi kaqkunapas ayqekuychis orqokunaman. Campopi kaqkunapas amaña llaqtaman haykuychishñachu. ");
INSERT INTO qveNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Chay p'unchawkunapin Diosqa castiganqa mana kasukuq llapallan runakunata, Bibliapi nisqanman hina. ");
INSERT INTO qveNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Ay, imaynaraq kanqaku chay p'unchawkunapi wiksayoq warmikuna, hinallataq qolla wawayoq warmikunapas! Kay Israel nacionpi llapallan tiyaq runakunaqa anchatan ñak'arinqaku, Dios castigaqtin. ");
INSERT INTO qveNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Wakintan wañuchinqaku huk hatun espadawan. Wakintañataqmi presochaspa apanqaku huk law nacionkunaman. Hinaspan kay Jerusalén llaqtaqa thuñichisqa kanqa. Hinaspapas huk law nacionmanta runakunan kay Jerusalén llaqtaykichistaqa dueñochakunqaku, Diospa permitisqan p'unchawkamalla, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jesusqa nillarantaqmi khaynata: —Kanqan señalkuna. Chay señalkunatan qankunaqa rikunkichis intipi, killapi, qoyllurkunapi ima. Hinallataqmi lamar qochapi unupas qaparispa llimp'arimunqa. Chaymi llapallan nacionkunapi runakunapas, anchata mancharikuspanku llakikunqaku. ");
INSERT INTO qveNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Hinallataqmi cielomanta k'anchamuqkunapas kuyukachanqa kay lawman waq lawman shapchisqa hinaraq. Hinaqtinmi tukuy imaymana pasasqanta rikuspanku, kay pachapi runakunaqa mancharikuymanta desmayanqaku. ");
INSERT INTO qveNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Hinaqtinmi llapallan runakuna rikuwanqaku noqa Diosmanta Hamuq Runata, phuyu ukhupi k'ancharispa tukuy atiyniywan hamushaqta. ");
INSERT INTO qveNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Chay señalkuna qallariqtinqa ama manchakuspayá, qankunaqa Diospi astawan confiaychis; hinaspa allinta kallpanchakuychis. Salvasqa kanaykichis p'unchawmi ña chayamushanña, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesusqa nillarantaqmi huk willakuyta: —Qawariychis higos sach'ata, hinallataq wakin sach'akunatawan. ");
INSERT INTO qveNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Chay sach'akunapa rap'inkuna kaqmanta wiñarimuqtinmi, qankunaqa yachankichis, paray tiempoqa ña qallarinanña kasqanta. ");
INSERT INTO qveNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Saynallataqmi chay señalkunapa pasasqanta rikuspaykichisqa, yachankichis, Diospa gobiernanan tiempoqa ña qallarinanña kasqanta. ");
INSERT INTO qveNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Cheqaqtapunin niykichis kay nisqaykunaqa cumplikunqapunin, kay tiempopi kawsaq runakuna manaraq wañushaqtin. ");
INSERT INTO qveNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Hanaq pachapas kay pachapas tukukunqan. Ichaqa noqapa nisqaykunan cumplikunqapuni, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Jesusqa nillarantaqmi: —Qankunaqa allinta cuidakuspa kawsaychis. Yanqataq sonqoykichis rumiyarunman, tukuy millay viciokunapi, mach'aykunapi hinallataq kay pachapi tukuy ima kaqkunallapi piensaspa kawsasqaykichisrayku. Saynata kawsashaqtiykichismi qonqayllamanta tukukuy p'unchaw qankunaman chayaramunman. ");
INSERT INTO qveNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Chay tukukuy p'unchawqa huk trampa hinan qonqayllamanta chayamunqa, kay pachapi llapallan kawsaq runakunapaq. ");
INSERT INTO qveNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Chaymi qankunaqa ama ishkayaspa listollaña kanaykichis. Aswanpas tuta p'unchaw Diosmanta mañakuychis, kay pachapi tukuy imaña pasaqtinpas, qankunata imapas ama pasasunaykichispaq, saynapi noqa kutimuqtiy, mana p'enqakuspa, ñawpaqniypi kanaykichispaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Saynatan Jesusqa yachachiran sapa p'unchaw Jerusalén templopi. Ichaqa sapa tutantaqmi, discipulonkunapiwan kushka, Olivos sutiyoq moqoman riran samananpaq. ");
INSERT INTO qveNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Hinaqtinmi llapallan runakunaqa, Jesuspa yachachisqanta uyarinankupaq sapa p'unchaw tutallamanta temploman riranku. ");
INSERT INTO qveNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pisi p'unchawkunallañan Pascua fiestapaq faltasharan. Chay fiestapiqa Israel nacionniyoq runakunan mana levadurayoq ruwasqa t'antata mikhuq karanku. ");
INSERT INTO qveNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Chay p'unchawkunapin Jerusalén templopi sacerdotekunapa jefenkuna, hinallataq leykunata yachachiqkunapiwan, Jesusta mashkaranku, imaynatas pakallapi wañuchinankupaq. Ichaqa manataqmi atirankuchu runakunata manchakuspanku. ");
INSERT INTO qveNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Hinaspan Judas Iscariotepa sonqonman Satanás haykuran. Chay Judasqa karan, Jesuspa chunka ishkayniyoq akllasqan discipulonkunamanta huknin kaqmi. ");
INSERT INTO qveNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Chaymi Judasqa riran sacerdotekunapa jefenkunaman, hinallataq templopi cuidaq guardiakunapa jefenkunamanwan ima. Chaypi paykunawan parlaspan huk acuerdoman haykuranku imaynatas Jesusta paykunaman entregananpaq. ");
INSERT INTO qveNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Hinaqtinmi chay jefekunaqa anchata kusikuspanku, acordaranku Judasman qolqe qonankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judasñataqmi ichaqa, chay qolqe qosqankuta chashkirukuspa, chay ratomantapacha piensaran, imaynatas traicionllawan, llaqta runakunapa mana yachasqallan, Jesusta enemigonkunaman entregarunanpaq. ");
INSERT INTO qveNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Mana levadurayoq ruwasqa t'anta mikhunanku fiesta p'unchaw chayaramuqtinmi, sapankama familiakuna huk corderota ñak'aranku Pascua fiestapi cenanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Hinaqtinmi Jesusqa Pedrota Juantawan waqyaspa niran: —Qankuna rispaykichis cenata ruwamuychis, kay Pascua fiestapi mikhunanchispaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Chaymi paykunañataq Jesusta tapuranku: —¿Maypitaq ruwamunaykutari munankí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesusñataqmi niran: —Riychis Jerusalén llaqtaman. Chayman haykushaspan rikunkichis huk runata p'uyñupi unu apashaqta. Hinaspan paypa qepanta rinkichis wasiman haykunankama. ");
INSERT INTO qveNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Chay wasiyoqtan tapunkichis: “Yachachikuq Jesusmi mandamuwashanku qanta tapunaykupaq: ‘¿Mayqen cuartopitaq Pascua cenata mikhusaq discipuloykunawanrí?’ ” nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Chaymi wasiyoqqa qawachisunkichis altospi allin allichasqa hatun cuartota. Chaypin qankunaqa cenata ruwamunkichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Hinaqtinmi Pedroqa Juanpiwan rispanku, Jesuspa nisqanman hina tariranku. Chaypin paykunaqa cenata ruwaranku, Pascua fiestapi mikhunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Cenay horas chayaramuqtinmi, Jesusqa apostolninkunapiwan kushka mesaman mikhunankupaq tiyayuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Chaypin Jesusqa niran: —Manaraq wañushaspaymi noqaqa anchatapuni qankunawan kushka kay Pascua fiestapi mikhuyta munasharani. ");
INSERT INTO qveNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Cheqaqtapunin niykichis, kay cena mikhusqanchista hinaqa, manañan huktawanqa qankunawan kushkaqa mikhusaqñachu, Dios Taytaypa gobiernanan p'unchaw chayamunankama. Chaypiñan llapallanchis sumaqta mikhusunchis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Saynata nispanmi Jesusqa vinoyoq vasota oqariyuspan, Diosman graciasta qoran; hinaspan khaynata niran: —Llapaykichis haywarinakuspa, kay vasomanta tomaychis. ");
INSERT INTO qveNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Cheqaqtapunin niykichis: Manañan kay vinotaqa tomasaqñachu, Dios Taytaypa gobiernanan p'unchaw chayamunankama, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Saynallataqmi t'antata hap'ispa, Jesusqa Diosman graciasta qoran. Mañakuyta tukuruspanmi, t'antata partirispa haywariran discipulonkunaman. Hinaspan khaynata niran: —Kaymi cuerpoy. Kunanmi cuerpoyta entregasaq huchaykichismanta qankunata salvanaypaq. Qankunapas kunanmantapachayá kay cenata ruwankichis, saynapi sapa kutin t'antata partispa, noqamanta yuyariwanaykichispaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Saynallataqmi cenayta tukuruspanku, Jesusqa huk vinoyoq vasota oqarispa niran: —Kay vasopi vinon noqapa yawarniy. Chaymi ch'aqchusqa kanqa qankunata huchaykichismanta salvanaypaq. Kay yawarniywanmi Diosqa kunan huk mosoq pactota qankunawan ruwan. ");
INSERT INTO qveNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ichaqa yachaychisyá, kunanmi kay mesapi noqawan kushka tiyashan traicionllawan enemigoykunaman entregawaqniy runa. ");
INSERT INTO qveNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Chaymi niykichis, cheqaqtan noqa Diosmanta Hamuq Runaqa Diospa nisqanman hina wañusaq. ¡Ay, imaynaraq kanqa traicionawaqniy runaqa! nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Saynata Jesús niqtinmi, discipulonkunaqa paykunapura tapunakuranku khaynata: —Noqanchismantari, ¿mayqenninchistaq Señorninchis Jesusta traicionaqri kashanman? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jesuspa discipulonkunan phiñachinakuspa tapunakuranku, mayqenninkus paykunamanta aswan más importante kanankumanta. ");
INSERT INTO qveNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Hinaqtinmi Jesusqa paykunata niran: —Kay pacha nacionkunapi gobiernaq reykunaqa, paytukusqallaña kanku. Chaymi paykunaqa munasqankuman hina gobiernanku. Hinaspan chay gobiernasqanku nacionpi tiyaq runakunatapas khaynata ninku: “Allintan qankunapaq imatapas ruwashayku”, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ichaqa amayá qankunaqa paykuna hinachu kankichis. Qankuna ukhupi aswan más importante kaq runaqa, manapas importantechu kanman hinayá aswan kachun. Hinallataqmi pipas llapanpa jefen kaspaqa, aswanmi llapanta servinan. ");
INSERT INTO qveNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kunan tapusqaykichis, ¿mayqentaq aswan más importanteri kanman? ¿Mesapi mikhunanpaq tiyaqchu icha mikhuna serviqchú? Qankunapaqqa mesapi mikhunanpaq tiyaqmi aswan más importante runaqa. Noqan ichaqa huk sirviente runa hina qankunata servishaykichis. ");
INSERT INTO qveNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Qankunan ichaqa, ima sasachakuypiña kashaqtiypas, noqawan kasharankichis. ");
INSERT INTO qveNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Chaymi noqapas nombraykichis kamachiq kanaykichispaq, imaynan noqatapas Dios Taytay nombrawaran saynata. ");
INSERT INTO qveNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Noqa wiñaypaq gobiernaqtiymi qankunaqa mesaypi tiyaspa mikhunkichis, tomankichis. Hinallataq juzgana sillapi tiyaspaykichis, Israel nacionpa chunka ishkayniyoq ayllunkunata juzgankichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesusqa nillarantaqmi: —Simón, Simón, diablon permisota Diosmanta mañakamun, qankunata ancha sasachakuykunaman churasunaykichispaq, imaynan trigotapas wayrachispa zarandeanku, saynataraq qankunatapas zarandeasunaykichispaq. ");
INSERT INTO qveNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Noqan ichaqa, Dios Taytaymanta ña mañakuniña, iñiyniyki ama pisiyananpaq, saynapi aswan allinta kallpanchakunaykipaq. Qanqa Simón, noqamantan huk tiempo karunchakuwanki. Ichaqa noqaman kutirinpuspaykiyá noqapi creeqkunata yanapanki, paykunapas noqapi allinta iñinankupaq, nispa. Nota: Kay Simonqa Jesuspa apostolnin Pedron. ");
INSERT INTO qveNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Chaymi Pedroqa niran: —Señorlláy, noqaqa liston kashani carcelmanña apasuqtiykikupas, qanwan kushka rinaypaq, wañuqtiykipas, qanwan kushka wañunaypaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Hinaqtinmi Jesusqa niran: —Pedro, kunanmi niyki, kunan tutan manaraq gallo waqamushaqtin, kinsa kutikama negawanki: “Manan reqsinichu”, nispayki. ");
INSERT INTO qveNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Chaymantan Jesusqa discipulonkunata niran: —Yuyariychis, qankunatan mandaraykichis noqamanta willakuq rinaykichispaq, mana qolqeyoqta, mana qoqawniyoqta, hinallataq mana husut'ayoqta ima. Saynaqa kunanyá niwaychis, ¿imallapas faltasurankichishchú? nispa. Chaymi discipulonkunaqa contestaspa niranku: —Señorlláy manan ni imapas faltawarankuchu, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Chaymi Jesusqa paykunata niran: —Kunanmi ichaqa niykichis: Qolqeykichistapas, qoqawniykichistapas apakuychis. Pipapas espadan mana kaqtinqa, p'istukunan p'achata vendespa huk espadata rantikuchun. ");
INSERT INTO qveNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Bibliapin noqamanta escribisqa khaynata nishan: “Payqa huchasapa hinan ñak'arinqa”, nispa Isaías 53.12. Noqamanta chay escribisqankuqa cumplikunqapunin, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Hinaqtinmi discipulonkunaqa niranku: —Señorlláy, kaypin kashan ishkay espadakuna, nispanku. Chaymi Jesusqa contestaran: —Saynayá kachun, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesusqa Jerusalén llaqtamanta lloqsispanmi, costumbrenman hina, Olivos sutiyoq moqoman riran. Chaymi paywan kushka riranku discipulonkunapas. ");
INSERT INTO qveNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Chay moqoman chayaruqtinkun Jesusqa niran: —Diosmanta mañakuychis, sasachakuykunaña hamuqtinpas, huchaman ama urmanaykichispaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Chayta niruspan, Jesusqa discipulonkunamanta huk lawchaman rispa qonqorikuran. Hinaspan Diosmanta mañakuran, ");
INSERT INTO qveNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","khaynata: —Dios Taytalláy, munaspaykiqa kay sasachakuymanta orqoykuway. Ichaqa amayá noqapa munasqayman hinachu ruwasqa kachun; aswanqa qanpa munasqaykiman hinayá ruwasqa kachun, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Chay ratopin hanaq pachamanta huk ángel hamuspa payta astawan kallpancharan. ");
INSERT INTO qveNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesusqa anchatapuni llakikuspanmi, astawanraq Diosmanta mañakuran. Chaypin hump'inpas yawar hinaraq hatu-hatunmanta pampaman sut'uran. ");
INSERT INTO qveNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Jesusqa Diosmanta mañakuyta tukuruspanmi, discipulonkunapa kasqanman hamuran. Hinaspan paykunata puñushaqta tariran, ancha llakikuymanta puñuywan vencerachikusqankurayku. ");
INSERT INTO qveNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Chaymi paykunata niran: —¿Imanaqtintaq qankunari puñushankichís? Hatariychis; hinaspa Diosmanta mañakuychis, diablo tentasuqtiykichis, noqapi allinta confiaspa, huchaman ama urmanaykichispaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús manaraq rimayta tukushaqtinmi, huknin kaq discipulon Judas Iscariote chayamuran, ashka runakunata pusayukuspa. Hinaspan Jesusman ashuyuran much'ayunanpaq. ");
INSERT INTO qveNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Chaymi Jesusqa niran: —Judas, ¿huk much'aywanchu noqa Diosmanta Hamuq Runata enemigoykunaman entregawankí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Chaymi discipulonkunaqa Jesusta niranku: —Señorlláy, ¿kay espadaykuwanchu peleasaqkú? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Chayta nispanmi, Jesuspa huknin kaq discipulonqa, Israel nacionniyoq sacerdotekunapa jefenpa sirvienten runapa phaña ninrinta espadanwan waqtaspa kuchurparan. ");
INSERT INTO qveNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Saynata ruwaqtinmi Jesusqa niran: —¡Dejaychis; ama peleaychishchu! nispa. Saynata nispanmi, Jesusqa chay sirviente runapa ninrinta tupayuspa, kasqan ratolla sanoyachiran. ");
INSERT INTO qveNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesusta presochaspa apanankupaq hamuq runakunaqa karanku: Israel nacionniyoq sacerdotekunapa jefenkuna, templopi cuidaq guardiakunapa jefenkuna, hinallataq llaqtapi kamachiq autoridadkunapiwan iman. Hinaqtinmi Jesusqa paykunata khaynata niran: —¿Imanaqtintaq qankunari k'aspikunantin, hinallataq espadakunantin hamurankichis suwata hina hap'iwanaykichispaqrí? ");
INSERT INTO qveNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Noqaqa Jerusalén templopin sapa p'unchaw qankunapa ñawpaqniykichispi yachachirani. Ichaqa manan ni hayk'aqpas qankunaqa presochawarankichishchu. Kunanmi ichaqa, qankunapaq ña hora chayaramunña. Chaymi qankunaqa diablopa kamachisqan, tutalla hamushankichis, presochawaspa, apawanaykichispaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jesusta hap'iruspankun, sacerdotekunapa jefenpa palacio wasinman aparanku. Pedroñataqmi mana rikuchikuspalla karu qepallankuta riran. ");
INSERT INTO qveNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Chay wasiman chayaruspankun, chawpi patiopi ninata ratachispa, muyuriqninpi tiyaranku. Chaypin Pedropas paykunawan kushka tiyayullarantaq. ");
INSERT INTO qveNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Hinaqtinmi chaypi huk sirvienta warmi, Pedrota nina ratachisqankupa ladonpi tiyashaqta rikururan. Hinaspan allinta qawapayaspa niran: —Kay runapas Jesuswan kushka puriqmi kashan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Chaymi Pedroqa niran: —¡Paytaqa manan noqaqa reqsinichu! nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Chaymantan huk runañataq Pedrota chaypi tiyaqta rikuspa nillarantaq: —Qanpas paykunawan kushka puriqmi kashanki, nispa. Pedroñataqmi contestaran: —¡Manan noqaqa paykunawan puriqchu kani! nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Huk hora hinaña pasaruqtinmi, huk runañataq niran: —Kay runaqa cheqaqtapunin Jesuswan kushka puriq. Hinaspapas payqa Galilea provincia llaqtamantan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Chaymi Pedroqa niran: —¡Imamantachá rimashankipas, noqaqa manan yachanichu! nispa. Pedro manaraq rimaytapas tukurushaqtinmi, chay ratopipuni gallo waqaramuran. ");
INSERT INTO qveNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Hinaqtinmi Jesusqa kutirimuspa Pedrota qawarimuran. Chaymi Pedroqa yuyariran Jesuspa nisqanta: “Kunan tutan manaraq gallo waqaramushaqtin, kinsa kutikama negawanki: ‘Manan Jesustaqa reqsinichu’ nispayki”, nispa nisqanta. ");
INSERT INTO qveNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Chaymi Pedroqa hawaman lloqsimuspa, anchata llakikuspa, renegaymanta waqaran. ");
INSERT INTO qveNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jerusalén templopi cuidaq guardiakunan, Jesusmanta chansakuspa burlakuranku. Hinaspan maqaranku. ");
INSERT INTO qveNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Hinallataqmi ñawintapas vendawan wataruspanku, maqapiyaspa tapuranku: —Niwaykuyá, ¿pitaq maqashasunkirí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Hinaspan k'amillarankutaq millay rimaykunawan. ");
INSERT INTO qveNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","P'unchawña karamuqtinmi, llaqtapi kamachiq autoridadkuna, sacerdotekunapa jefenkuna, hinallataq leykunata yachachiq runakunapiwan huñunakuranku. Hinaspan Jesusta apachimuranku paykunapa kasqanku corteman. Chaypin Jesusta tapuranku khaynata: ");
INSERT INTO qveNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Kunanyá niwayku, ¿qanchu Diosmanta Hamuq Salvadorqa kankí? nispanku. Hinaqtinmi Jesusqa contestaran: —Arí, nisqaykichis chayqa, manan qankunaqa creewankichismanchu. ");
INSERT INTO qveNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Hinallataq imataña tapuykichisman chaypas, manan qankunaqa contestawankichismanchu. ");
INSERT INTO qveNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kunanmantan ichaqa, noqa Diosmanta Hamuq Runaqa, tukuy atiyniyoq Diospa phaña ladonpi tiyasaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Hinaqtinmi llapallan chaypi kaq runakunaqa tapuranku: —Saynaqa, ¿qanchu kanki Diospa wawan? nispanku. Chaymi Jesusqa contestaran: —Arí, qankunapunin nishankichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Chaymi paykunaqa niranku: —¿Imapaqñataq más testigokunatapas munanchisrí? Noqanchis kikinchispunin, paypa siminmanta uyarishanchis rimasqantaqa, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Israel nacionpi kamachiq llapallan jefekunan, Jesusta aparanku Judea provinciapi gobiernaq Poncio Pilatopa kasqanman. ");
INSERT INTO qveNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Chayarachispankutaqmi paykunaqa Jesusta acusayta qallariranku, khaynata: —Kay runatan tarimuyku kay Israel nación llaqtaykupi tiyaq runakunata engañashaqta, Roma nacionpa contranpi sayarinankupaq yachachishaqta, hinallataq Roma llaqtapi gobiernaq rey Cesarmanpas, amaña impuestotapas paganankupaq yachachishaqta ima. Hinaspapas payqa ninmi: “Noqan kani Cristo, kamachikuq reyqa”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Saynata acusaqtinkun, Poncio Pilatoqa Jesusta tapuran: —¿Qanchu kanki Israel nacionniyoq runakunapa reynin? nispa. Hinaqtinmi Jesusqa contestaran: —Arí, qanpunin nishanki, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Saynata tapuruspan Poncio Pilatoqa sacerdotekunapa jefenkunaman, hinallataq chaypi kaq runakunamanwan niran: —Kay runapiqa, manan ni ima culpatapas tarinichu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Chay nisqanta uyarispankun, Jesusta acusaq runakunaqa astawan qaparispa, khaynata niranku: —Kay runaqa Israel nacionpi runakunata yachachispan ch'aqwanachishan. Chaytan qallarimuran Galilea provincia llaqtamanta, hinaspan kunanpas kay Judea provincia llaqtapipas saynallatataq ruwashan, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","“Galileamantan kay runaqa”, nisqankuta uyarispanmi, Poncio Pilatoqa paykunata tapuran: —¿Galileamantachu kay runaqa? nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Chaymi Jesusta acusaq runakunaqa contestaranku: “Arí”, nispanku. Chayta uyarispan, Poncio Pilatoqa Jesusta apachiran Galileapi gobiernaq rey Herodesman. Ichaqa chay p'unchawkunapin rey Herodesqa kasharan chay Jerusalén llaqtapi. ");
INSERT INTO qveNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Rey Herodesqa Jesusta rikuruspanmi anchata kusikuran. Payqa ñan Jesusmanta rimasqankutaqa ñawpaqtaraq uyarisqaña. Hinaspan payqa Jesuspa milagrokuna ruwasqanta rikuytapuni munaran. ");
INSERT INTO qveNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Hinaspan Herodesqa Jesusta ashka kutikama tapupayaran. Jesusqa manataqmi ni ima nispapas contestaranchu. ");
INSERT INTO qveNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Chaypitaqmi kasharanku sacerdotekunapa jefenkunapas, hinallataq leykunata yachachiq runakunapas. Paykunan anchallataña Jesustaqa acusaranku. ");
INSERT INTO qveNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Saynallataqmi rey Herodespas hinallataq soldadonkunapas, Jesusta k'amiranku; chansakunawan burlakuspankutaqmi, huk reyta hina suma-sumaq p'achawan p'acharachiranku. Hinaspan Poncio Pilatopa kasqanman kutichiranku. ");
INSERT INTO qveNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Chay p'unchawmi Poncio Pilatoqa Herodeswan allinparanku, enemigontin hina ñawpaqta kasqankumanta. ");
INSERT INTO qveNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Poncio Pilatoman Jesusta kutichimuqtinkun, Pilatoqa sacerdotekunapa jefenkunata, llaqtapi kamachiq autoridadkunata, hinallataq llaqtapi runakunatawan waqyachimuran. ");
INSERT INTO qveNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Hinaspan Poncio Pilatoqa paykunata niran: —Kay runatan qankuna apamuwarankichis khaynata nispaykichis: “Kay Israel nación llaqtapi tiyaq runakunatan engañaspa, Roma nacionpa contranpi sayarinankupaq yachachishan”, nispa. Chaymi noqaqa qankunapa ñawpaqniykichispi acusasqaykichisman hina tapurani. Ichaqa manan noqaqa ni ima huchatapas tarinichu. ");
INSERT INTO qveNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nitaqmi Herodespas ni ima hucha ruwasqantapas tarimuranchu; chaymi noqaman kaqmanta kutichimuwaran. Saynaqa qawariychis, payqa manan ni ima huchatapas ruwaranchu wañunanpaq hinaqa. ");
INSERT INTO qveNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Aswanmi kunan alli-allinta castigachispay kacharipusaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","{Sapa watanmi Pascua fiesta chayamuqtin, Poncio Pilatoqa huk presota kacharichiran costumbrenman hina}. ");
INSERT INTO qveNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Chaymi Poncio Pilatopa nisqanta uyarispanku chayman huñunakamuq runakunaqa qaparispa niranku: —¡Chay Jesusta wañuchinankupaq kamachiy! ¡Hinaspa Barrabasta kacharipuy! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabasqa carcelpin preso karan, Roma llaqtapi kamachiqkunapa contranpi runakunata hatarichisqanmanta, hinallataq runa wañuchisqanmantawan ima. ");
INSERT INTO qveNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Chaymi Poncio Pilatoqa, Jesusta kachariyta munaspa, chaypi kaq runakunata kaqmanta rimapayaran. ");
INSERT INTO qveNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Chayta uyarispankutaqmi, chaypi kaq runakunaqa astawanraq qaparispa niranku: —¡Cruzpi chakatachiy! ¡Cruzpi chakatachiy! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Saynata niqtinkun, Poncio Pilatoqa kinsa kaq kuti rimaypi, khaynata niran: —¿Ima mana allintataq kay runari ruwaran? Manan noqaqa ni ima huchatapas tarinichu wañunanpaq hinaqa. Kunanmi allinta castigachispallay kacharipusaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ichaqa chaypi huñunasqa llaqta runakunañataqmi, astawan tukuy kallpankuwanraq qaparispa khaynata niranku: —¡Jesustaqa cruzpi chakatachiypuni! nispanku. Saynatan paykunaqa qaparqacharanku, paykunapa munasqankuman hina ruwasqa kananpaq. ");
INSERT INTO qveNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Chaymi Poncio Pilatoqa kamachiran, mañakusqankuman hina ruwasqa kananpaq. ");
INSERT INTO qveNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Chayta nispanmi Poncio Pilatoqa, chay runakunapa mañakusqankuman hina, Barrabás sutiyoq runata carcelmanta kacharichiran. Barrabasqa Roma llaqtapi kamachiqkunapa contranpin runakunata sayarichiran; hinaspapas payqa runa wañuchiqmi karan. Jesustañataqmi ichaqa Poncio Pilato entregaran, runakunapa mañakusqankuman hina ruwanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Poncio Pilatopa soldadonkunan Jesusta cruzpi chakatanankupaq aparanku. Chay risqankupitaqmi Cirene llaqtayoq Simón sutiyoq runawan campomanta kutimushaqtin tuparanku. Hinaspan cruzta wikrichispa Jesuspa qepanta apachiranku. ");
INSERT INTO qveNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Hinaqtinmi ashkallaña runakuna Jesuspa qepanta riranku. Paykunawan kushkataqmi ashka warmikunapas Jesusmanta waqayuspa rillarankutaq. ");
INSERT INTO qveNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Chaymi Jesusqa paykunata qawarispa niran: —Jerusalén llaqtayoq warmikuna, noqamantaqa ama waqaychishchu. Aswanqa waqaychis qankunamanta, hinallataq wawaykichismanta ima. ");
INSERT INTO qveNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Chayamunqan sasachakuy p'unchawkuna. Chay p'unchawpin runakuna ninqaku: “¡Kusisqayá kachun qolluri kaq warmikunaqa! ¡Paykunan kanku mana hayk'aq onqokuq warmikuna, hinallataq mana ni hayk'aqpas qolla wawayoq kaqkuna!” nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Hinaspan runakunaqa nishu sasachakuypi tarikuspa, orqokunata ninqaku khaynata: “¡Orqokuna, hawaykuman urmayamuy!” nispanku. Saynallataqmi moqokunatapas nillanqakutaq khaynata: “¡Moqokuna, pakaykuwayku!”, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ichaqa noqa mana huchayoq qolla sach'a hina kashaqtiy, tukuy kaykunata ruwawashanku chayqa, ¡imataraqchá ruwanqaku ch'aki sach'a hina huchayoq runakunataqa! nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Hinaspapas ishkay mana allin ruwaq runakunatapas apallarankutaqmi, Jesuspa ladonpi chakataspa wañuchinankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Hinaspan Calavera sutiyoq moqoman chayarachispanku, soldadokunaqa Jesusta cruzpi chakataranku. Saynallataqmi chay mana allin ruwaq ishkay runakunatapas chakatallarankutaq, hukninta Jesuspa phaña ladonpi, huknintañataq Jesuspa lloq'e ladonpi. ");
INSERT INTO qveNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","{Chakatasqaña kashaspantaqmi Jesusqa niran: —Dios Taytáy, perdonay kay runakunata. Paykunaqa manan yachankuchu kay ruwasqankutaqa, nispa.} Chaypi kaq soldadokunañataqmi Jesuspa p'achanta sortearanku apakunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Chaypi kaq runakunapas tukuy chaykuna pasasqantan qawaranku. Saynallataqmi llaqta kamachiq jefekunapas, chansakunawan burlakuspa, Jesusmanta khaynata niranku: —Payqa, huk runakunataqa salvaranmi. Kunanyá cheqaqtapuni Diospa akllasqan Cristo kaspaqa, pay kikinta salvakuchun, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Saynallataqmi Poncio Pilatopa soldadonkunapas Jesusman ashuyuranku burlakunankupaq. Hinaspan qatqe vinagreta ofrecespa, ");
INSERT INTO qveNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","khaynata niranku: —Cheqaqtapuni Israel nacionniyoq runakunapa reynin kaspaykiqa, qan kikiykitayá salvakuy, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Hinaspan Jesusta chakatasqanku cruzpa puntanpi, huk letrero churasqa karan {griego rimaypi, latín rimaypi, hinallataq hebreo rimaypipas} khaynata: “kay runan israel nacionniyoq runakunapa reynin”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Hinaqtinmi Jesuspa ladonpi chakatasqa, huknin kaq mana allin ruwaq runaqa, Jesusta k'amispa khaynata niran: —¡Cheqaqtapuni Diosmanta Hamuq Salvawaqniyku kaspaykiqa, qan kikiykitayá salvakuy! ¡Hinallataq noqaykutapas salvawayku! nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Chaymi Jesuspa ladonpi chakatasqa, huknin kaq mana allin ruwaq runaqa, chay k'amiq runata q'aqcharan khaynata: —¿Manachu qanri Diosta manchakunki khayna ñak'ariypi kashaspaykipas? ");
INSERT INTO qveNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Noqanchisqa razonmantan kaypi ñak'arishanchis, tukuy mana allinkuna ruwasqanchismanta. Kay runan ichaqa, mana ni ima huchatapas ruwaranchu, khayna ñak'ariypi kananpaqqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Hinaspan chay runaqa Jesusta khaynata niran: —Jesús, amayá noqataqa qonqarukuwankichu, gobiernayta qallarispaykiqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Chaymi Jesusqa chay runata niran: —Cheqaqtapunin niyki, kunanpunin noqawan kushka kanki sumaq k'anchaq paraíso lugarpi, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Chawpi p'unchaw hinamanta asta kinsa horas tardekaman kay pacha tutayaran, ");
INSERT INTO qveNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","inti manaña k'anchasqanrayku. Hinallataqmi Jerusalén templo ukhupi cortinapas, kushkanmanta llik'ikuran, altonmanta urayman. ");
INSERT INTO qveNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesusñataqmi tukuy kallpanwan qaparispa niran: —¡Dios Taytalláy, qanmanmi almayta entregamuyki! nispa. Saynata nispanmi, Jesusqa wañupuran. ");
INSERT INTO qveNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tukuy chaykuna pasasqantan Roma llaqtamanta soldadokunapa jefen rikuran. Hinaspan payqa Diosta alabaspa khaynata niran: —Cheqaqtapunin kay runaqa mana huchayoq kasqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Chaypi llapallan huñunasqa kaq runakunapas, kaykuna pasasqanta rikuspankun, llakikuymanta qasqonkuta takakuspa kutipuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Saynallataqmi Jesuspa llapallan amigonkunapas, Galilea provinciamanta hamuq warmikunapiwan, tukuy ima pasasqanta karullamanta qawaranku. ");
INSERT INTO qveNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Huk runan karan José sutiyoq. Paymi karan Arimatea llaqtamanta. Chay llaqtaqa Judea provinciamanmi perteneceran. Hinaspapas payqa Israel nacionta kamachiq runakunamanta huknin kaqmi karan. Payqa Diosta kasukuspanmi, allin runa kaspa, imatapas allintapuni ruwaran. ");
INSERT INTO qveNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Hinaspapas Joseyqa suyasharanmi Diospa gobiernanan p'unchaw chayamunanta. Chaymi payqa, mana acuerdopichu karan, Israel nacionta kamachiq jefekuna Jesusta wañuchinankupaq, acuerdo ruwasqankuwan. ");
INSERT INTO qveNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Hinaspan Joseyqa Poncio Pilatowan parlaq riran, Jesuspa cuerponta p'ampaq apananpaq. ");
INSERT INTO qveNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Chaymi Poncio Pilatowan parlaramuspa, Joseyqa riran Jesuspa cuerponta cruzmanta urayachiq. Urayachispataqmi huk sumaq hatun sábanas hina telawan p'isturan. Hinaspan huk hatun qaqa sikipi sepultura ruwasqa t'oqoman, Jesuspa cuerponta apaspa, chaypi churaran. Chay sepulturapiqa manaraqmi ni pitapas p'amparankuraqchu. ");
INSERT INTO qveNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Chay p'ampasqanku p'unchawqa viernesmi karan. Chaymi Israel nacionniyoq runakunaqa alistakusharanku samanankupaq sábado p'unchaw yaqaña qallarinanpaq kashaqtin. Nota: Israel llaqtayoq runakunapaqqa, soqta horas tardeyaykuytan qatiqnin p'unchawqa qallariran asta paqarisnintin soqta horas tardekama. ");
INSERT INTO qveNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Hinallataqmi Galilea provincia llaqtamanta, Jesuspa qepanta hamuq warmikunapas, Joseywan kushka rispanku rikuranku, imaynatas Jesuspa cuerponta sepulturaman churasqankuta. ");
INSERT INTO qveNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Chaymantan chay warmikunaqa wasinkuman kutipuspanku, sumaq mishk'i q'apaq perfumekunata prepararanku, chaywan Jesuspa cuerponta llusimunankupaq. Hinaspan paykunaqa sábado p'unchaw qallarisqanrayku samaranku, Moisespa escribisqan leypi kamachikusqanman hina. ");
INSERT INTO qveNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Domingo p'unchawtan manaraq achiqamushaqtin chay warmikunaqa, {wakin warmikunapiwan}, mishk'i q'apaq perfume ruwasqankuta apayukuspanku, Jesuspa sepulturanman riranku. ");
INSERT INTO qveNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Chayaruspankutaqmi sepultura tapasqanku hatun rumitaqa tariranku, huk lawman kuyurichisqata. ");
INSERT INTO qveNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Chaymi chay warmikunaqa sepultura ukhuman haykuspanku, Señor Jesuspa cuerpontaqa mana tarirankuchu. ");
INSERT INTO qveNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Hinaqtinmi paykunaqa chaykuna pasasqanta rikuspanku, mana ni ima ruwaytapas atirankuchu. Ichaqa sayna kashaqtinkun, qonqayllamanta ishkay runakuna, sumaq k'ancharishaq yuraq p'achayoqkama ladonkupi rikhuriran sayashaq. ");
INSERT INTO qveNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Chaymi chay warmikunaqa anchata mancharikuspanku pampakamaraq k'umuyuranku. Hinaqtinmi chay ishkay runakunaqa khaynata niran: —¿Imanaqtintaq qankunari mashkashankichis kawsaq runata wañusqakunapa kasqanpirí? ");
INSERT INTO qveNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Payqa manan kaypiñachu. Aswanqa kawsarinpunñan. Yuyariychis Galilea provincia llaqtapi kashasparaq khaynata rimapayasusqaykichista: ");
INSERT INTO qveNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Diosmanta Hamuq Runataqa entregawanqakun huchasapa runakunaman, cruzpi chakataspa wañuchiwanankupaq. Ichaqa kinsa p'unchawmantan kawsarinpusaq”, nisqanta. ");
INSERT INTO qveNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Chaymi chay warmikunaqa chayraq yuyariranku Jesuspa nisqankunata. ");
INSERT INTO qveNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Hinaspan paykunaqa chay sepulturamanta kutimuspanku, tukuy ima rikusqankuta willakuranku, Jesuspa chunka hukniyoq apostolninkunaman, hinallataq wakin runakunamanpas. ");
INSERT INTO qveNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Chay warmikunan karanku: María Magdalena, Juana, Jacobopa mamitan María, hinallataq wakin warmikunapas. Paykunan Jesuspa apostolninkunaman tukuy ima rikusqankuta willakuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Hinaqtinmi Jesuspa apostolninkunaqa, chay warmikunapa willakusqanta uyarispanku, mana creerankuchu. Aswanmi piensaranku, chay warmikunaqa yanqalla rimanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ichaqa chayta uyarispanmi, Pedroqa p'itayllaña riran Jesusta p'ampasqanku sepultura qawaq. Chayaruspanñataqmi chay sepultura ukhuta qawayuspa, rikuran hatun p'istusqanku telallataña chaypi churalayashaqta. Hinaspan Pedroqa ancha admirasqallaña wasiman kutinpuran. ");
INSERT INTO qveNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Jesuspa kawsarimusqan p'unchawmi, Jesuspi creeq ishkay runakunaqa risharanku, Emaús sutiyoq llaqtaman. Chay Emaús llaqtaqa karan Jerusalén llaqtamanta kinsa hora hina puriypin. ");
INSERT INTO qveNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Chay ishkay runakunaqa ñantan risharanku parlayuspanku, chay p'unchawkunapi tukuy ima pasasqanmanta. ");
INSERT INTO qveNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Saynata parlayuspa rishaqtinkun, Jesusqa ashuyuspa, paykunawan kushka riran. ");
INSERT INTO qveNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ichaqa manataqmi paykunaqa Jesusta reqsiyta atirankuchu, ñawinku tutayasqa hina kasqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Hinaspan Jesusqa chay ishkay runakunata tapuran: —¿Imamanta parlayuspataq qankunari rishankichís? nispa. Hinaqtinmi paykunaqa ancha llakisqallaña uyantin sayaykuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Chaymi Cleofas sutiyoq kaq runaqa contestaran khaynata: —Jerusalén llaqtapiqa llapallan runakunan yachanku kay p'unchawkunapi tukuy imakuna pasasqanmantaqa. Chayri, ¿qan sapallaykichu kay p'unchawkunapi tukuy ima pasasqanmanta mana yachaq runa kashankí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Hinaqtinmi Jesusqa tapuran: —¿Imakunataq pasaruranrí? nispa. Chaymi chay ishkaynin runakunaqa contestaranku khaynata: —Noqaykuqa parlashayku Nazaret llaqtayoq Jesusmantan. Payqa Diosmanta willakuq profetan karan. Chaymi payqa Diospa ñawpaqninpipas, hinallataq runakunapa ñawpaqninpipas, ancha atiywan tukuy ima milagrokunata ruwaran. Hinaspapas payqa cheqaqtan runakunamanpas yachachiran. ");
INSERT INTO qveNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Paytan sacerdotekunapa jefenkuna, hinallataq kay Israel nacionta kamachiq jefekunapiwan ima, Roma llaqtamanta soldadokunaman entregaranku. Hinaspan cruzpi chakataspa wañurpachinku. ");
INSERT INTO qveNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Noqaykun ichaqa suyasharayku, Jesusqa kay Israel nacionta, Roma llaqtayoq runakuna kamachisqanmanta librawaspanchis, noqanchista gobiernawananchispaq. Chayta suyashaqtiykun, wañurpachinku. Hinaspapas ñan kinsa p'unchawña wañusqanmantaqa pasarun. ");
INSERT INTO qveNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ichaqa kunan achiqayllatan, noqaykupa grupoykumanta kaq wakin warmikuna sepultura qawaq riranku; hinaspan kutimuspanku, ancha admirakuywan willawanku ");
INSERT INTO qveNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","khaynata: “Manan Señor Jesuspa cuerponqa kanchu. Aswanmi ishkay angelkuna chaypi rikhurispa niwanku: ‘Jesusqa kawsashanmi’ ”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Chaymi noqayku ukhumanta wakinniyku sepultura qawaq riranku. Hinaspan paykunapas warmikunapa willakusqanman hina Jesuspa cuerpontaqa mana tarimusqakuchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Chaykunata uyarispan Jesusqa chay ishkay runakunata niran: —¡Mana entiendeq tullu uma runakuna! ¿Imanaqtintaq qankunari, mana creenkichishchu, Diosmanta willakuq profeta runakunapa yachachisqanpirí? ");
INSERT INTO qveNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Acaso manachu yacharankichis, Diosmanta Hamuq Salvadorqa, hanaq pachaman manaraq wichashaspa, kay pachapi tukuy imapi anchata ñak'arinanmantá? nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Hinaspan Jesusqa chay ishkaynin runakunaman willayta qallariran, Moisespa escribisqan librokunapi, hinallataq Diosmanta willakuq profetakunapa escribisqan librokunapi, paymanta imakunas escribisqa kasqanmanta. ");
INSERT INTO qveNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Hinaqtinmi Emaús llaqtaman yaqaña chayashaqtinku, Jesusqa ñanta seguispa más karu llaqtaman riq hina karan. ");
INSERT INTO qveNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Chaymi paykunaqa ruegaranku khaynata: —Noqaykuwan kushka qepakuy. Nishu tardeñan kashan. Hinaspapas tutayamushanñan, nispanku. Hinaqtinmi Jesusqa chay ishkay runakunawan kushka wasiman haykuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Hinaspan chaypi mikhunankupaq mesaman tiyayuranku. Hinaqtinmi Jesusqa t'antata oqariyuspa, Diosman graciasta qoran; partiyuspataq paykunaman haywaran. ");
INSERT INTO qveNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Hinaqtinmi chay ishkaynin runakunaqa, chayraq cuentata qokuranku payqa Señor Jesús kasqanta. Ichaqa Jesusñataqmi paykuna qawashaqtinku kasqan ratolla ladonkumanta chinkarapuran. ");
INSERT INTO qveNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Chaymi chay ishkaynin runakunaqa ninakuranku: —¿Manachu sonqonchisqa allinta kusikuspa watupakusharan, Diospa palabranpi escribisqakunamanta ñan hamusqanchispi willawaqtinchís? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Chaymi chay ishkaynin runakunaqa kasqan ratolla Jerusalén llaqtaman kutimuranku. Hinaspan Jesuspa chunka hukniyoq apostolninkunata huñunasqata tariranku, hinallataq huk runakunatapas paykunawan kushkata. ");
INSERT INTO qveNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Hinaspan chaypi huñunasqa kaqkunaqa niranku: —Cheqaqtapunin Señor Jesusqa kawsariramun. Chaymi Simón Pedromanpas rikhurirunña, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Hinaqtinmi Emaús llaqtamanta chayamuq ishkaynin runakunaqa willakuranku, imaynatas ñanpi paykunamanpas Jesús rikhurisqanmanta, hinallataq mikhunankupaq tiyayuqtinku, t'antata partishaqtin Jesusta reqsisqankumantawan ima. ");
INSERT INTO qveNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Chay ishkay runakuna manaraq willakuyta tukurushaqtinkun, chaypi kaq runakunapa chawpinkupi, Jesusqa rikhuriran. Hinaspan rimayukuran khaynata: —Hawkayay qankunawan kachun, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Hinaqtinmi llapallan chaypi kaq runakunaqa anchata mancharikuranku, huk alma kananpaq piensaspanku. ");
INSERT INTO qveNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Chaymi Jesusqa paykunata niran: —¿Imanaqtintaq qankunari ancha mancharisqallaña kashankichís? ¿Imanaqtintaq sonqoykichis ukhupiri ishkayashankichís? ");
INSERT INTO qveNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Qawaychis makiykunata, chakiykunatawan. ¡Noqa kikiymi kashani! ¡Qawaykuwaychis! ¡Llamiykuwaychis! ¡Noqapunin kani! Almapaqa manan kanchu aychanpas, nitaq tullunpas. Rikusqaykichisman hinan noqapaqa kashan aychaypas, tulluypas, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Chaykunata nispanmi, Jesusqa makinkunaman hinallataq chakinkunaman (clavoq haykusqanta), paykunaman qawachiran. ");
INSERT INTO qveNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ichaqa paykunataqmi kusikusparaq hinallataq mancharikusparaq, Jesusta rikushaspankupas, mana creeyta atirankuchu. Chaymi Jesusqa paykunata tapuran: —¿Kashanchu ima mikhunallaykichispas? nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Chaymi paykunaqa kankasqa parten challwata qoranku. ");
INSERT INTO qveNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Hinaqtinmi Jesusqa chayta chashkikuspa, paykunapa ñawpaqninkupi mikhuran. ");
INSERT INTO qveNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Hinaspan Jesusqa paykunata niran: —Yuyariychisyá, noqaqa qankunawan kushka kashaspayraqmi ña willaraykichishña, noqata tukuy imakuna pasawananmantaqa. Ichaqa chaykunaqa cumplikunanpunin karan, Moisespa escribisqan leykunaman hina, profetakunapa escribisqankunaman hina, hinallataq Salmos libropi escribisqakunaman hina, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Saynatan Jesusqa Bibliapi escribisqa kaqkunamanta paykunaman allinta entiendechiran. ");
INSERT INTO qveNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Hinaspan Jesusqa nillarantaq: —Bibliapin escribisqa kashan, noqa Diosmanta Hamuq Salvadorqa anchata ñak'arispa, wañunaymanta, hinallataq kinsa p'unchawmanta kawsarimunaymantawan ima. ");
INSERT INTO qveNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Hinallataqmi escribisqa kashan, Jerusalén llaqtamanta qallarispa, tukuy enteron mundontin llaqtakunapi, noqapa sutiypi willakunankupaq. Saynapi runakuna uyarispanku, huchankuta saqespa Diosman kutirikuqtinku, perdonasqa kanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Qankunan ichaqa tukuy kaykuna rikusqaykichismanta testigoy kankichis, saynapi noqamanta runakunaman willanaykichispaq. ");
INSERT INTO qveNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Kunanmi noqaqa, qankunaman mandamusqaykichis Dios Taytaypa prometesusqaykichis Santo Espirituta. Ichaqa kay Jerusalén llaqtapiyá qepakuychis, hanaq pachamanta Dios Taytaypa atiyninta chashkinaykichiskama, nispa. ");
INSERT INTO qveNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Chaymantan Jesusqa discipulonkunata pusaran Jerusalén llaqtamanta asta Betania llaqtakama. Chaypin makinta oqarispa, Diosmanta mañapuran, paykunata yanapananpaq. ");
INSERT INTO qveNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Saynata mañakushaqtinmi, Jesusqa chay ratopi hanaq pacha cieloman ripuran. ");
INSERT INTO qveNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Chayta rikuspankun discipulonkunaqa adoraranku. Hinaspan Jerusalén llaqtaman ancha kusisqallaña kutipuranku. ");
INSERT INTO qveNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Chaypin temploman sapa p'unchaw rispanku, Diosta alabaranku. Amén.");
INSERT INTO qveNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Qallariyninpi manaraq kay pacha unanchasqa kashaqtinmi, Palabraqa ña karanña. Chay Palabraqa Dioswanmi karan. Chay Palabran Dios karan. ");
INSERT INTO qveNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Paymi qallariyninpi Dioswan karan. ");
INSERT INTO qveNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Diosqa tukuy kaqkunatapas chay Palabrawanmi ruwaran. Diosqa manan ni imatapas ruwaranchu mana paypiwanqa. ");
INSERT INTO qveNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Chay Palabran Kawsayqa; payllataqmi runakunapaqpas huk K'anchay. Nota: Chay Palabrapas, chay Kawsaypas, hinallataq chay K'anchaypas kikin Señor Jesusmi. ");
INSERT INTO qveNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Chay K'anchayqa tutayaqpin k'anchan. Ichaqa tutayaq limboqa manan chay K'anchaytaqa wañuchiyta atiranchu. ");
INSERT INTO qveNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Diosmi huk runata mandamuran. Paypa sutinmi karan (Bautizaq) Juan. ");
INSERT INTO qveNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Paymi huk testigo hina chay K'anchaymanta willakuq hamuran, saynapi llapallan runakuna chay K'anchaypi creenankupaq. ");
INSERT INTO qveNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ichaqa manan Bautizaq Juanchu chay K'anchayqa karan. Aswanmi payqa chay K'anchaymanta willakunanpaq hamuran. ");
INSERT INTO qveNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Chay cheqaq K'anchaymi kay pachaman ña hamusharanña, llapallan runakunapa kawsayninta k'anchayunanpaq. ");
INSERT INTO qveNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Chay K'anchaq Palabran ña kay pachapiña kasharan. Kay pachatapas paymi unancharan. Ichaqa kay pachapi tiyaq runakunaqa manan reqsirankuchu kay pacha unanchaq pay kashaqtinpas. ");
INSERT INTO qveNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Chay K'anchaq Palabraqa kay pacha ruwasqanmanmi hamuran. Ichaqa kay pachapi runakunaqa manan chashkirankuchu. ");
INSERT INTO qveNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Aswanqa paypi creespanku sonqonkupi payta chashkikuqkunamanmi, payqa atiyta qoran, Diospa wawankunaña kanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Diospa wawan kanankupaqqa manan wawakuna hinachu naceranku, nitaq tayta mamankupa munasqanman hinachu. Aswanqa Diosmantan naceranku. ");
INSERT INTO qveNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Chay k'anchaq Palabran runaman tukumuspa, noqanchiswan kushka tiyaran. Chaymi noqaykuqa Diospa sapallan Wawanta rikurayku, ancha atiyniyoq kasqanta, ancha munakuyniyoq kasqanta, hinallataq tukuy cheqaq kaqkunapas paypi kasqanta. ");
INSERT INTO qveNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Paymantan Bautizaq Juanqa runakunaman willaran khaynata: —Chay Palabraqa ñan chayamushanña. Payqa noqamantapas aswan más atiyniyoqmi. Hinaspapas payqa ñawpaqtaraqmi ña karanña kay pachapi noqa manaraq naceshaqtiy, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Paymantan noqanchisqa llapallanchis chashkiranchis munakuyninta hinallataq tukuy yanapakuynintapas. ");
INSERT INTO qveNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Diosmi Moisesnintakama leyninkunata qowaranchis. Ichaqa Jesusñataqmi Diospa sumaq khuyakuyninta, hinallataq cheqaq yachachikuynintawan qowaranchis. ");
INSERT INTO qveNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Diostaqa manan ni pipas ni hayk'aqpas rikuranchu. Aswanqa Diospa Wawan Jesusllan, Papanwan kushka kawsasqanrayku. Hinaspapas Dios kasqanraykun payqa yachachiwaranchis, imaynas Papan kasqanmanta. ");
INSERT INTO qveNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Israel nación llaqtapi kamachiq jefekunan mandaranku, sacerdotekunata hinallataq Jerusalén templopi serviq levita nisqa runakunatawan, Bautizaq Juanta khaynata tapumunankupaq: —Qanri, ¿pitaq kankí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Chaymi Bautizaq Juanqa contestaran khaynata: —Diosmanta Hamuq Salvadorqa manan noqachu kani, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Hinaqtinmi paykunaqa Bautizaq Juanta kaqmanta tapullarankutaq khaynata: —Diosmanta willakuq ñawpaq profeta Eliasri, ¿qanchu kashankí? nispanku. Chaymi Bautizaq Juanqa paykunata contestaspa niran: —Profeta Eliasqa, manan noqachu kani, nispa. Hinaqtinmi chay sacerdotekunaqa kaqmanta tapullarankutaq: —Diospa mandamunan profetari, ¿qanchu kashankí? nispanku. Hinaqtinmi Bautizaq Juanqa contestaran khaynata: —Manan noqachu kani, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Chaymantan chay runakunaqa nillarankutaq khaynata: —Chayri, ¿pitaq qanri kashankí? Niwaykuyá pi kasqaykita, kutispayku, mandamuwaqniyku runakunaman willamunaykupaq, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Chaymi Bautizaq Juanqa, ñawpaq profeta Isaiaspa escribisqanman hina, contestaspa niran: —Noqaqa huk ch'inñeq lugarpi waqyakuqmi kani: “Diosmanta Hamuq Salvadorta allinta chashkinaykichispaqqa sonqoykichistayá allichaychis, imaynan wiksu-wiksu ñankunatapas allichanku chay hinata”, nispa Isaías 40.3. ");
INSERT INTO qveNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Bautizaq Juanta tapumunankupaq riq runakunaqa, fariseo religionniyoq runakunapa mandamusqan runakunan karanku. ");
INSERT INTO qveNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Paykunan Bautizaq Juanta kaqmanta tapuranku khaynata: —Manataq Diosmanta Hamuq Salvadorchu kanki, nitaq Eliaschu, nitaq ni huk profetapashchu, chayqa niwaykuyá, ¿imanaqtintaq qanri bautizashankí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Chaymi Bautizaq Juanqa contestaran khaynata: —Noqaqa unullawanmi bautizashani. Ichaqa qankuna ukhupin manaraq reqsisqaykichis runa kashan. ");
INSERT INTO qveNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Paymi noqapa qepayta hamushan. Payqa noqamantapas ancha atiyniyoqmi. Chaymi noqaqa husut'anpa watullantapas mana pashkanaypaq hinachu kani, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Kaykunaqa pasaran Jordán mayupa waq law chimpan Betania llaqta lawpin. Chaypin Bautizaq Juanqa runakunata bautizaran. ");
INSERT INTO qveNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Paqarisnintin p'unchawmi Bautizaq Juanqa, paypa kasqanman hamushaqta, Jesusta rikuran. Chaymi Bautizaq Juanqa runakunata khaynata niran: —¡Qawariychis (Diosmanta Hamuq Runata)! Payqa Diospa Corderonmi. Paymi runakunapa huchankunata perdonanqa. ");
INSERT INTO qveNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Paymantan noqaqa rimapayaraykichis khaynata: “Payqa noqa manaraq naceshaqtiymi ña karanña. Chaymi payqa noqamantapas aswan más atiyniyoq. Paymi noqapa qepayta hamushan”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ichaqa manan noqaqa yacharanichu pis runakunapa Salvadornin kasqantaqa. Aswanqa kay Israel nación llaqtapi tiyaq runakuna, paymanta yachanankupaqmi, runakunata unuwan bautizanaypaq, noqataqa Dios mandamuwaran, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Hinaspapas Bautizaq Juanqa nillarantaqmi khaynata: —Noqaqa Diospa Santo Espirituntan rikurani, hanaq pacha cielomanta huk paloma hina Jesuspa hawanman urayamusqanta. ");
INSERT INTO qveNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ichaqa ñawpaqtaqa manan noqaqa yacharanichu, Diosmanta Hamuq Salvador pis kasqantaqa. Aswanqa unuwan bautizanaypaq mandamuwaqniy Diosmi khaynata niwaran: “Pimanchus Santo Espiritun urayamunqa, paymi runakunata salvananpaq hamusqanrayku, Diospa Santo Espiritunta runakunaman qonqa”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Chaymi noqaqa chaykuna rikusqaymanta testigo kani. Chayraykun kunan qankunaman niykichis, Payqa cheqaqpunin Diospa Wawan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Paqarisnintin p'unchawmi Bautizaq Juanqa, ishkaynin discipulonkunapiwan kaq lugarllapitaq kasharan. ");
INSERT INTO qveNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Hinaspan Bautizaq Juanqa, Jesuspa pasasqanta rikuruspa, khaynata niran: —¡Qawariychis, Diospa Corderonmi kayta hamushan! nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Chayta uyarispankun, Bautizaq Juanpa chay ishkaynin discipulonkunaqa Jesusta qatikuranku. ");
INSERT INTO qveNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Chay qatikusqankuta rikuspanmi, Jesusqa paykunata tapuran khaynata: —Qankunari, ¿imatataq mashkashankichís? nispa. Hinaqtinmi paykunaqa Jesusta niranku: —Yachachikuq, qanri ¿maypitaq tiyankí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Chaymi Jesusñataq paykunata contestaran: —Hakuchiyá rikuchimusqaykichis, nispa. Chaymi paykunaqa rispanku, maypichus Jesús tiyasqanta rikuranku. Hinaspan paykunaqa tawa horas tardeykuy hinaña kasqanrayku, Jesuswan qepakuranku. ");
INSERT INTO qveNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Paykunamanta huknin kaqmi karan Simón Pedropa wawqen Andrés. Kay Andresmi Bautizaq Juanpa chay ishkaynin discipulonkunamanta huknin kaq discipulon karan. Paymi Bautizaq Juanpa rimasqanta uyarispa, Jesusta qatikuran. ");
INSERT INTO qveNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andresqa wawqen Simón Pedrotan primerta tariran. Hinaspan khaynata niran: —Tariramuykun Mesiasta, nispa. Mesiasqa, “Diosmanta Hamuq Salvador” ninanta nin. ");
INSERT INTO qveNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Hinaspan Andresqa wawqen Simón Pedrota Jesuspa kasqanman pusaran. Chaymi Jesusqa Simonta rikuruspa niran: —Qanqa Juanpa wawan Simonmi kanki. Kunanmantan qanpa sutiyki kanqa Cefas, nispa. Cefasqa “Pedro” ninantan nin. Nota: Cefas sutiqa arameo rimaypin karan. Pedro sutiñataqmi griego rimaypi karan. Kay ishkaynin sutikunan “rumi” ninanta nin. ");
INSERT INTO qveNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Paqarisnintin p'unchawmi Jesusqa Galilea provincia lawman rinanpaqña kasharan. Hinaspan Jesusqa Felipe sutiyoq runata tarispa niran: —Qatikuway, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipeqa Betsaida llaqtamantan karan. Chay llaqtallamantataqmi Andrespas hinallataq wawqen Pedropas karanku. ");
INSERT INTO qveNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Hinaspan Felipeqa Natanael sutiyoq runata tariruspa, khaynata niran: —Joseypa wawan Nazaret llaqtayoq Jesustan tariramuyku. Paymantan Moisespas, hinallataq Diosmanta willakuq ñawpaq profetakunapas escribiranku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Chaymi Natanaelqa Felipeta tapuran khaynata: —Chay Nazaret llaqtamantari, ¿allin yachayniyoq runa lloqsimunmanchú? nispa. Felipeñataqmi payta contestaspa niran: —Hakuchiyá rikumunaykipaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Hinaqtinmi Jesusqa Natanaelpa hamusqanta rikuruspa niran: —Kay runaqa cheqaqtapunin Israel nación llaqtamanta. Hinaspapas payqa cheqaq ch'uya sonqoyoq runan. Chaymi payqa pitapas mana engañanmanchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Hinaqtinmi Natanaelqa chay nisqanta uyarispa, Jesusta tapuran: —¿Imaynanpitaq qanri reqsiwankí? nispa. Chaymi Jesusñataq contestaran khaynata: —Felipe manaraq waqyamushasuqtiykin, qantaqa higos sach'a sikipi tiyashaqta ña rikuraykiña, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Chaymi Natanaelqa niran: —Yachachikuq, qanqa cheqaqtapunin Diospa Wawan kanki, hinallataq kay Israel nacionniyoq runakunapa reynin, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesusñataqmi Natanaelta niran: —Qanri, ¿“higos sach'a sikipi tiyashaqtan rikuyki”, nispa niqtiychu noqapi creerunkí? Ichaqa kaykunamantapas aswan más hatun ruwaykunataraqmi qanqa rikunki, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Chaymantan Jesusqa chaypi kaq llapallan uyariq runakunata niran: —Cheqaqtapunin niykichis, qankunaqa hanaq pacha cielo kicharikushaqtan rikunkichis. Hinallataqmi Diospa angelninkunatapas, noqa Diosmanta Hamuq Runapa ladoyman urayamushaqta, hinallataq hanaq pacha cieloman qespishaqta ima rikunkichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kinsa p'unchaw pasaruqtinmi Galilea provincia law Caná llaqtapi huk casarakuy fiesta karan. Chaypin Jesuspa mamitan María kasharan. ");
INSERT INTO qveNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Chay casarakuy fiestamanmi Jesuspas hinallataq discipulonkunapas invitasqa karanku. ");
INSERT INTO qveNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Hinaqtinmi chay casarakuy fiestapi vino tukurukuqtin, mamitan Mariaqa wawan Jesusta niran: —Casarakuqkunapa vinonkun manaña kanñachu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Chaymi Jesusqa niran: —Mamitáy, ¿imapaqtaq chaytari niwankí? Pis kasqayta reqsichikunay horasqa manaraqmi chayamunraqchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Hinaqtinmi Jesuspa mamitan Mariaqa, chaypi serviqkunata niran: —Jesuspa nisqanman hina ruwaychis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Chay casarakusqanku fiestapin soqta hatun tinajakuna rumimanta ruwasqa kasharan. Chay tinajakunapi unutaqa Israel nacionniyoq runakunapa ch'uyanchakunankupaqmi waqaycharanku. Sapankama tinajamanmi pachaq litro hina unu haykuran. ");
INSERT INTO qveNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Chaymi Jesusqa chay fiestapi sirviente runakunata niran: —Kay tinajakunaman unuta hunt'aychis, nispa. Hinaqtinmi paykunaqa sapankama tinajakunaman unuta hunt'achiranku. ");
INSERT INTO qveNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Chaymantañataqmi Jesusqa chay sirviente runakunata niran: —Kunanqa chay tinajamanta wisispa apaychis despenseroman mallinanpaq, nispa. Hinaqtinmi chay sirviente runakunaqa, Jesuspa kamachisqanman hina aparanku. ");
INSERT INTO qveNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Chaymi chay despenseroqa vinoman tukuchisqa unuta malliyuran. Payqa manataqmi yacharanchu chay vinotaqa maymanta apamusqankutapas, nitaq maypi waqaychasqankutapas. Ichaqa sirviente runakunaqa yacharankun unumanta vinoman tukuchisqa kasqantaqa. Hinaqtinmi chay despenseroqa casarakuq runata waqyaspa, ");
INSERT INTO qveNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","khaynata niran: —Casarakuypiqa allin kaq vinotan primertaqa haywakunku; ichaqa invitasqa runakuna allinta tomaruqtinkuñan mana allin vinotaqa haywakunku. Chaychu qanri, ¿allin kaq vinota kunankama waqaychasharankí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesusqa Galilea provincia law Caná llaqtapin kay primer kaq milagrotaqa ruwaran. Chay ruwasqanwanmi Jesusqa rikuchikuran ancha atiyniyoq kasqanta. Hinaqtinmi discipulonkunaqa paypi creeranku. ");
INSERT INTO qveNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Hinaqtinmi chay casarakuy fiesta tukurukuqtin, Jesusqa mamitanpiwan, wawqenkunapiwan, hinallataq discipulonkunapiwan ima, Capernaúm llaqtaman riran. Hinaspan chay llaqtapi ishkay kinsa p'unchawlla qepakuranku. ");
INSERT INTO qveNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Israel nacionniyoq runakunapa Pascua fiesta ruwananku chayamushaqtinñan, Jesusqa Jerusalén llaqtaman riran. ");
INSERT INTO qveNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Hinaspan Jesusqa Jerusalén templopi negocio ruwaq ashka runakunata tariran. Paykunan torokunata, ovejakunata, hinallataq palomakunatawan ima vendesharanku. Saynallataqmi huk law nacionpa qolqenta templo qolqewan cambiaq runakunatapas, puestonkupi tiyashaqta tariran. ");
INSERT INTO qveNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Chaykunata rikuspanmi, Jesusqa latigota ruwaspa, templomanta lliw runakunata ovejantinta hinallataq torokunantinta ima qarqoran. Hinaspan qolqe cambiaq runakunapa qolqenkunatapas, pampaman wikapaspa mesankutapas t'ikraran. ");
INSERT INTO qveNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Hinaspan Jesusqa palomakuna vendeq runakunata, khaynata niran: —¡Kay templomanta kaykunata orqoychis! ¡Dios Taytaypa wasinqa manan negocio ruwanaykichispaqchu! nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jesuspa discipulonkunaqa chaykunata rikuspankun yuyariruranku Bibliapi khayna escribisqa kasqanta: “Yupaychana wasiykitan noqaqa anchata munakuni. Ichaqa runakunan tukuy mana allinkunata ruwaranku. Chaymi sonqoyraq anchata nanawan”, nisqanta Salmos 69.9. ");
INSERT INTO qveNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Hinaqtinmi Israel nacionniyoq runakunapa jefenkunaqa, phiñarikusparaq Jesusta niranku: —Kaykuna ruwanaykipaq atiyniyoq kasqaykita yachanaykupaqqa, rikuchiwaykuyá ima milagrollatapas, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Chaymi paykunata contestaspa, Jesusqa niran: —Kay templota thuñichiychis. Hinaqtinmi noqaqa kinsa p'unchawllapi hatarirachisaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Hinaqtinmi Israel nacionniyoq runakunapa jefenkunaqa niranku: —Kay temploqa tawa chunka soqtayoq watapin ruwasqa karan. ¿Chaychu kinsa p'unchawllapi kunan ruwaruwaq? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jesusqa chay templomanta rimaspaqa, kikinpa cuerponmantan rimasharan, (wañuchiqtinku kinsa p'unchawninman kawsarinpunanmanta). ");
INSERT INTO qveNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Chaymi Jesuspa discipulonkunaqa, wañusqanmanta Jesús kawsarimuqtinña, chaykuna rimasqanmanta yuyariranku. Hinaspan Bibliapa nisqanpi, hinallataq Jesuspa rimasqankunapipas creeranku. ");
INSERT INTO qveNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesusqa Pascua fiesta p'unchawpin Jerusalén llaqtapi kashaspa, ashka milagrokunata ruwaran. Chaymi ashka runakuna chay milagrokuna ruwasqanta rikuspanku, Jesuspi creeranku. ");
INSERT INTO qveNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ichaqa Jesusqa paykunapa piensasqankutaqa yacharanmi. Chaymi paykunapa creesqankupiqa mana confiaranchu. ");
INSERT INTO qveNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Hinaspapas Jesusqa manan necesitaranchu ni pipas runamasinmanta ni imallatapas payman willanankutaqa, llapallan runakunapa sonqonta allinta reqsisqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Huk runan karan Nicodemo sutiyoq. Payqa fariseo religionniyoq, hinallataq Israel nación llaqtata kamachiq runakunamanta huknin kaq importante runan karan. ");
INSERT INTO qveNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Paymi huk tuta Jesuspa kasqanman hamuspa, khaynata niran: —Yachachikuq, noqaykuqa yachaykun qanqa yachachiwanaykikupaq Diosmanta hamusqaykita. Qanpa ruwasqayki milagrokunataqa manan ni pipas ruwaytaqa atinmanchu, sichus paywan Dios mana kaqtinqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Hinaqtinmi Jesusqa Nicodemota niran: —Cheqaqtapunin niyki, sichus pipas kaqmanta mana nacenqachu chayqa, manan Diospa gobiernasqan sumaq glorianmanqa haykunqachu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Chaymi Nicodemoqa Jesusta tapuran: —¿Imaynataq runari machuña kashaspan, kaqmantari naceramunman? Icha, ¿mamitanpa wiksanman kutiyuspanchu kaqmantari naceramunman? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Hinaqtinmi Jesusqa contestaran: —Cheqaqtapunin niyki, pipas unumanta hinallataq Diospa Santo Espiritunmantawan mana nacenqachu chayqa, Diospa gobiernasqan sumaq glorianmanqa manan haykunqachu. ");
INSERT INTO qveNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Runamanta nacemuqqa runallan. Santo Espiritumanta nacemuqmi ichaqa, Santo Espiritupa hunt'asqan runa. ");
INSERT INTO qveNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Amayá qanqa “kaqmantan nacenayki” nisqaywanchu admirakuy. ");
INSERT INTO qveNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Wayraqa wayramun tukuy lawmantan; chaymi qanqa uyarinki qaparispa hamusqallanta. Ichaqa manataqmi yachankichu maymantas hamun, maymantaqsi rin chaytapas. Saynallataqmi pasan Santo Espiritumanta llapallan nacemuqkunawanpas, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Chaymi Nicodemoqa kaqmanta Jesusta tapuran: —¿Imaynataq kaykunari kanman? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Hinaqtinmi Jesusqa contestaspa niran: —Israel nación llaqtapi yachachiq kashaspachu, ¿kaykunata mana yachankí? ");
INSERT INTO qveNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Cheqaqtapunin niyki, noqaykuqa yachasqaykutan rimayku; rikusqaykutataqmi willaykupas. Ichaqa qankunaqa manan creenkichishchu noqaykupa nisqaykutaqa. ");
INSERT INTO qveNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nitaqmi kay pachapi kaqkunamanta willashaqtiypas, creenkichishchu. Chayri, ¿imaynataq creewaqchis hanaq pachapi kaqkunamanta willaqtiyrí? ");
INSERT INTO qveNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Manan ni pipas hanaq pachamanqa wicharanchu. Aswanqa noqa Diosmanta Hamuq Runallan hanaq pachamanta urayamurani. ");
INSERT INTO qveNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Imaynan Moisespas ch'inñeq lugarpi broncemanta mach'aqwayta ruwaspa k'aspipi altoman oqariran, saynallatataqmi noqa Diosmanta Hamuq Runatapas, cruzpi chakatawaspa altoman oqariwanqaku, ");
INSERT INTO qveNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","saynapi pipas noqapi creeqqa, mana chinkasqa kananpaq, aswanqa wiñay kawsayniyoq kananpaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Diosqa ancha-anchatan kay pachapi runakunata munakuran. Chaymi sapallan Wawanta kay pachaman mandamuran, pipas paypi creeqqa ama wañunanpaq, aswanpas wiñay kawsayniyoq kananpaq. ");
INSERT INTO qveNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Diosqa kay pachamanqa sapallan Wawantaqa mandamuran, manan runakunata sentenciaspa ñak'arichinanpaqchu, aswanqa runakunata huchanmanta perdonaspa salvananpaqmi. ");
INSERT INTO qveNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Pipas Diospa Wawanpi creeq runaqa, manan sentenciasqachu kanqa. Ichaqa pipas Diospa Wawanpi mana creeq runaqa, ñak'arinanpaqmi ña sentenciasqaña kashan, paypi mana creesqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Payqa kay pachamanqa hamuran, tutayaqpi hina huchallapi puriq runakunata k'anchayunanpaqmi. Ichaqa kay pachapi runakunaqa, huchallankupi kawsaytan akllakuranku, mana allinkunata ruwaspa kawsasqankurayku. ");
INSERT INTO qveNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Chaymi huchallapi llapallan kawsaq runakunaqa, k'anchaypi kawsayta cheqnikuspanku, k'anchaymanqa mana ashuyamunkuchu. Sichus k'anchayman ashuyamunkuman chayqa, tukuy mana allinkuna ruwasqankun rikusqa kanman. ");
INSERT INTO qveNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Allin kaqkunata ruwaq runakunan ichaqa, k'anchayman ashuyamunku, saynapi Diospa kamachikuyninta kasukuspanku, allin kawsasqankuta llapallan runakuna rikunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Chaymantan Jesusqa discipulonkunapiwan kushka Judea provincia lawman riran. Chaypin huk tiempo qepakuspa, Jesusqa runakunata bautizaran. ");
INSERT INTO qveNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Saynallataqmi Bautizaq Juanpas Enón nisqa sitiopi ashka unu kaqtin, payman hamuq runakunata bautizaran. Chay Enón sitioqa Salim nisqa lugarpa cercanpin karan. ");
INSERT INTO qveNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Chaykunaqa pasaran Bautizaq Juanta manaraq carcelman churashaqtinkun. ");
INSERT INTO qveNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Hinaqtinmi Bautizaq Juanpa discipulonkunaqa Israel nacionniyoq runamasinwan discutinakuyta qallariranku, huchankumanta imaynata limpiakuna costumbremanta. ");
INSERT INTO qveNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Hinaspan Bautizaq Juanpa discipulonkunaqa, Bautizaq Juanman rispanku, khaynata niranku: —Yachachikuq, Jordán mayupa waq lawninpi qanwan kushka kaq runamanta willawasqaykikutari, ¿yuyashankichú? Paymi kunan bautizashan. Hinaqtinmi ashka runakuna paytaqa qatikushanku, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Bautizaq Juanñataqmi paykunata contestaran khaynata: —Runaqa manan ni imatapas ruwaytaqa atinmanchu, sichus Dios payta mana yanapaqtinqa. ");
INSERT INTO qveNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Qankunaqa ñan uyariwarankichishña: “Manan noqaqa Diosmanta Hamuq Salvadorchu kani. Diosmi noqataqa mandamuwaran chay Salvadorpa ñawpaqninta hamuspay, runakunaman paymanta willanaypaq”, nispa nisqaytaqa. ");
INSERT INTO qveNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Huk casarakuypiqa noviollan noviawanqa casarakun. Noviopa amigonmi ichaqa, anchata kusikun noviopa rimasqanta uyarispa. Saynallataqmi noqapas chay noviopa amigon hina kani. Chayraykun noqapas ancha kusisqa kashani, Diosmanta Hamuq Salvador kaypi kasqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Paymi noqamantaqa aswan más importante kanan. Noqañataqmi ichaqa, pisi reqsisqallaña kanay, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Diospa Wawanqa hanaq pachamanta hamuqmi. Chayraykun payqa kay pachapi llapallan runakunamanta aswan más importante. Kay pachapi tiyaq runakunaqa, kay pachallamantan kanku. Chayraykun paykunaqa imapas kay pachapi kaqkunallamanta rimanku. Ichaqa hanaq pachamanta hamuqmi, noqanchismanta aswan más importante. ");
INSERT INTO qveNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Chayraykun Diospa Wawanqa hanaq pachapi rikusqanmanta, hinallataq uyarisqantawan ima riman. Ichaqa manataqmi kay pachapi runakunaqa paypa willakusqantaqa creenkuchu. ");
INSERT INTO qveNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pipas paypa willakusqanpi creen chayqa, yachanmi Diospa nisqanqa, cheqaqpuni kasqanta. ");
INSERT INTO qveNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Diosmi paymanqa Santo Espiritupa tukuy atiyninta qon mana hark'akuspa. Chaymi Diospa mandamusqan Wawanqa, Diospa nisqankunata willakun. ");
INSERT INTO qveNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Dios Taytaqa ancha-anchatan Wawantaqa munakun. Chaymi Diosqa tukuy ima kaqkunata Wawanman qoran, pay kamachinanpaq. ");
INSERT INTO qveNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Chaymi niykichis, pipas Diospa Wawanpi creeqqa, wiñay kawsayniyoqmi kanqa. Ichaqa Diospa Wawanpi mana creeqkunaqa, manan chay wiña-wiñaypaq kawsaytaqa chashkinqakuchu. Aswanmi paykunataqa kikin Diospuni anchata phiñakuspa castiganqa. ");
INSERT INTO qveNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Fariseo religionniyoq runakunan yacharuranku, Jesusqa ashka discipulokunayoq kasqanta, hinallataq Bautizaq Juanmantapas aswan más ashka runakunata Jesús bautizasqanmantawan ima. ");
INSERT INTO qveNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ichaqa manan kikin Jesuschu bautizaranqa, aswanqa paypa discipulonkunan. ");
INSERT INTO qveNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Chay fariseo runakunapa rimasqanta yacharuspanmi, Jesusqa Judea provincia lawmanta lloqsiran. Hinaspan Galilea provincia lawman kaqmanta kutiran. ");
INSERT INTO qveNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Chayman rishaspanmi, Jesusqa Samaria provincia ukhunta pasanan karan. ");
INSERT INTO qveNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Hinaspan chay Samaria provincia ukhupi Sicar nisqa llaqtaman Jesusqa chayaran. Chay llaqtaqa karan Joseyman papan Jacob herencia allpa saqetamusqan lugarpa cercanpin. ");
INSERT INTO qveNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Chaypin unu orqonankupaq Jacobpa ruwachisqan pozo karan. Hinaqtinmi chawpi p'unchaw hinaña kaqtin, Jesusqa purimusqanpi pisiparuspa, chay pozo patapi tiyayuran. ");
INSERT INTO qveNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Chaypi Jesús tiyashaqtinmi, Samaria llaqtamanta huk warmi chay pozoman unu orqoq hamuran. Chaymi Jesusqa chay warmita niran: —Pozomanta orqomusqayki unuta tomanaypaq qoykuway, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Chay ratopiqa, Jesuspa discipulonkunaqa manan chaypichu karanku). Paykunaqa mikhuna rantikuqmi llaqtata riranku. ");
INSERT INTO qveNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Israel nacionniyoq runakunaqa manan Samaria llaqtayoq runakunawanqa allinpichu apanakuranku, nitaqmi rimanakurankupashchu. Chaymi Samaria llaqtayoq warmiqa Jesusta tapuran: —¿Israel llaqtayoq runa kashaspaykichu, noqa Samaria llaqtayoq warmi kashaqtiy, unuta mañakuwashankí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Hinaqtinmi Jesusqa chay warmita niran: —Qanqa manan yachankichu imatachus Dios qoyta munasunki chaytaqa. Nitaqmi pi kasqaytapas yachankichu. Sichus yachawaq chayqa, qanmi aswan noqamanta mañakuwankiman; hinaspan noqa qoykiman kawsay qokuq unuta, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Chaymi chay warmiqa Jesusta khaynata niran: —Señor, kay pozomanta unuta orqonaykipaqqa, manamá ni imaykipas kanchu; hinaspapas kay pozoqa nishu ukhun kashan. Chayri, ¿maymantataq qanri qowankiman chay kawsay qokuq unutarí? ");
INSERT INTO qveNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Qanri ñawpaq abuelonchis Jacobmantapas aswan más atiyniyoqchu kankí? Paymi kay pozotaqa saqetamuwaranku. Kay pozomantan paypas, wawankunapas, hinallataq animalninkunapas unutaqa tomaranku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Chaymi Jesusqa contestaran: —Pipas kay pozomanta unu tomaqqa, kaqmantan ch'akichikunqa. ");
INSERT INTO qveNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Noqapa unu qosqayta tomaqmi ichaqa, manaña ni hayk'aqpas ch'akichikunqachu. Chay unuqa pukyumanta t'oqyamuq unu hinan kanqa, runakunaman wiñay kawsayta qonanpaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Chayta uyarispan chay warmiqa, Jesusta niran: —Señor, chay unutayá qoykuway, manaña ni hayk'aqpas ch'akiwananpaq, hinallataq kay pozomanpas amaña unu orqoq hamunaypaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Chaymi Jesusqa chay warmita niran: —Rispayki qosaykita waqyamuy; hinaspa kutimuy, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Hinaqtinmi chay warmiqa Jesusta niran: —Noqapa qosayqa manan kanchu, nispa. Chaymi Jesusqa chay warmita niran: —Arí, cheqaqtapunin ninki: “Manan qosayqa kanchu”, nispayki. ");
INSERT INTO qveNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Qanqa pishqa qariwanmi tiyaranki. Kunan tiyasqayki qaripas manan qosaykichu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Jesuspa nisqanta uyarispanmi chay warmiqa niran: —Señor, ¿qanqa Diosmanta willakuq profeta runachus kasqankí? ");
INSERT INTO qveNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Diostaqa kay moqopin ñawpaq abueloykuqa yupaycharanku. Ichaqa qankuna Israel nacionniyoq runakunan ninkichis, Jerusalén llaqtallapin Diostaqa yupaychana, nispaykichis. ");
INSERT INTO qveNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Saynata niqtinmi, Jesusqa chay warmita niran: —Creeway, chayamunqan p'unchawkuna; chay p'unchawkunapiqa manan kay moqollapichu, nitaq Jerusalén llaqtallapichu Diostaqa yupaychankichis. ");
INSERT INTO qveNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Qankuna, Samaria llaqtayoq runakunaqa manan yachankichishchu pis yupaychasqaykichista. Noqayku, Israel nacionniyoq runakunan ichaqa, pi yupaychasqaykutapas yachayku, Israel nacionniyoq runakunamanta Salvaqniykichis hamusqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Aswanmi tiempo chayamushanña, Diosmanta cheqaq kaqta yachaspa, Diospa Santo Espiritun yanapaqtin, tukuy sonqonkuwan Diosta yupaychanankupaq. Ichaqa Diosmi munan sayna yupaychanata. ¡Chay tiempon kunan chayaramunña! ");
INSERT INTO qveNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Diosqa Espiritun, manan cuerpoyoqchu. Chaymi payta yupaychaqkunaqa, Santo Espiritupa yanapasqan, tukuy sonqonkuwan cheqaqtapuni Diosta yupaychananku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Saynata Jesús niqtinmi, Samaria llaqtayoq warmiqa, Jesusta khaynata niran: —Noqaqa yachanin Diosmanta Salvawaqninchis Cristo nisqanku Mesías hamunantaqa. Pay hamuspanmi tukuy imakunamantapas cheqaqta yachachiwasunchis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Chaymi Jesusqa contestaspa niran: —Noqan Diosmanta Hamuq Salvadorqa kani. Kunanpunin kikinwan parlashanki, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Hinaqtinmi chaykunata parlashaqtinku, Jesuspa discipulonkunaqa llaqta risqankumanta chayaramuranku. Hinaspan paykunaqa anchata admirakuranku, Jesusta huk warmiwan parlashaqta tarimuspanku. Ichaqa manataqmi ni mayqen discipulonpas tapuranchu: “¿Imamantataq chay warmitari tapusharankí? ¿Imamantataq chay warmiwanri parlashankí?” nispaqa. ");
INSERT INTO qveNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Hinaqtinmi chay Samaria llaqtayoq warmiqa, unu apanan p'uyñunta chaypi saqeruspa, llaqtanman kutiran. Hinaspan chay llaqtapi runakunata, khaynata niran: ");
INSERT INTO qveNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Hakuchi; hinaspa huk runata rikumuychis. Paymi kunan nimuwan kay kawsay vidaypi tukuy ima ruwasqayta. Icha, ¿paychu Diosmanta Hamuq Salvaqninchisqa kanpas? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Chayta uyarispankun chay llaqtapi tiyaq runakunaqa, Jesuspa kasqanman hamuranku. ");
INSERT INTO qveNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Chay llaqta runakuna hamushaqtinkutaqmi, Jesuspa discipulonkunaqa, Jesusta ruegaranku khaynata: —Yachachikuq, chikallantapas mikhuykuyá, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Jesusñataqmi paykunata contestaran: —Noqapa mikhunayqa kashanmi. Ichaqa manan qankunaqa chay mikhunaytaqa reqsinkichishchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Chayta uyarispankun discipulonkunaqa, tapunakuranku khaynata: —Paymanri, ¿pitaq mikhunatari aparamunman karan? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Chaymi Jesusqa niran: —Noqapa mikhunayqa hanaq pachapi Dios Taytaypa munasqanta ruwaymi. Hinallataq tukuy kamachimuwasqanta ruwaspa cumpliymi. ");
INSERT INTO qveNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Qankunan ichaqa trigota t'akaruspaykichis ninkichis: “Tawa killamantañan erasaqku”, nispa. Kunanyá uyariwaychis kay nisqayta: Noqaman kay ashka hamuq runakunan, chakrapi eranapaq poqosqa trigo hinaña kashanku. ");
INSERT INTO qveNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Hinaqtinmi cosechaq runakunaqa, Diosmanta wiñay kawsay premionkuta chashkinqaku. Saynapin tarpuqpas hinallataq cosechaqpas, anchata kusikunqaku. ");
INSERT INTO qveNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Chaymi cheqaqpuni runakunapa rimasqankuqa: “Hukmi tarpuqqa, hukñataqmi cosecha huñuqqa”, nisqanku. ");
INSERT INTO qveNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Noqan qankunataqa mandaraykichis, mana llank'asqaykichis chakramanta cosechata huñumunaykichispaq. Hukkunan chay chakrapiqa llank'aranku; ichaqa qankunañataqmi chay llank'asqankutaqa cosechashankichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Chaymi chay Samaria llaqtayoq warmiqa, willakuran khaynata: “Paymi kunan nimuwan kay kawsay vidaypi tukuy ima ruwasqayta”, nispa. Chay willakusqanta uyarispankun, chay Sicar llaqtapi tiyaq ashka runakunaqa, Jesuspi creeranku. ");
INSERT INTO qveNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Hinaqtinmi chay llaqtapi tiyaq runakunaqa, Jesuspa kasqan lugarman chayamuranku. Hinaspan Jesusta ruegakuranku paykunawan kushka qepakunanpaq. Chaymi Jesusqa paykunawan kushka ishkay p'unchaw qepakuran. ");
INSERT INTO qveNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Hinaqtinmi Jesuspa rimasqanta uyarispanku, runakunaqa aswan más ashkaraq paypi creeranku. ");
INSERT INTO qveNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Hinaspan runakunaqa chay warmita niranku: —Noqaykuqa manan qanpa willakusqallaykiwanchu creeyku. Aswanqa kikiykupunin kunan uyariyku. Hinaspapas kunanmi yachayku, payqa cheqaqtapuni kay pachapi runakunata salvananpaq hamusqanmanta, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jesusqa Samaria llaqtapi ishkay p'unchaw karuspanmi, discipulonkunapiwan kushka Galilea provincia lawman kutiran. ");
INSERT INTO qveNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Chaymanqa riran, kikinpa nisqan cumplikunanpaqmi. Paymi ñawpaqtaraq khaynata niran: “Diosmanta willakuq profeta runaqa manan llaqtanpiqa allin chashkisqaqa kanmanchu”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ñawpaqtaraqmi Galilea provincia lawpi tiyaq runakunaqa, Jerusalén llaqtaman rispanku, Pascua fiestapi Jesuspa tukuy ima ruwasqanta rikuranku. Chayraykun paykunaqa anchata kusikuspanku, Jesusta chashkiranku. ");
INSERT INTO qveNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Chaymantan Jesusqa Galilea provincia lawpi Caná sutiyoq llaqtaman riran. Chaypin Jesusqa ñawpaqtaraq unuta vinoman tukuchiran. Chay Caná llaqtapin rey Herodes Antipasta yanapaqnin huk autoridad runa kasharan. Chay autoridadpa wawanmi Capernaúm llaqtapiraq onqosqa kasharan. ");
INSERT INTO qveNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Chaymi chay autoridad jefeqa, Jesús Judea provincia lawmanta Galilea provincia lawman hamusqanta yacharuspa, Jesuspa kasqanman riran. Hinaspan Jesusta ruegakuran, wasinman rispa chay onqosqa wawanta sanoyachinanpaq. Chay wawanqa wañuypa patallanpiñan kasharan. ");
INSERT INTO qveNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Chaymi Jesusqa niran: —Qankunaqa manan Diospiqa creewaqchishchu, sichus hatun milagrokunata, hinallataq Diosmanta señalkunata mana rikuspaqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Hinaqtinmi chay autoridad jefeqa, Jesusta kaqmanta ruegakuspa, khaynata niran: —Yachachikuq, ama hina kaychu, waway manaraq wañurushaqtinyá wasiyman hakuchi, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Hinaqtinmi Jesusqa chay autoridad jefeta niran: —Wasiykiman kutipuy. Wawaykiqa manan wañunqachu, nispa. Chaymi chay autoridad jefeqa, Jesuspa rimasqanpi creespa, wasinman kutipuran. ");
INSERT INTO qveNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Hinaqtinmi wasinman yaqaña chay autoridad jefe chayarushaqtin, serviqnin runakuna taripamuspa niranku: —Wawaykiqa kawsashanmi, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Chaymi chay autoridad jefeqa, serviqnin runakunata tapuran: —¿Imay horastataq sanoyaruranrí? nispa. Hinaqtinmi paykunaqa contestaranku: —Qayninchaw chawpi p'unchaw pasariy horasta hinan fiebrenqa thañirun, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Chaymi chay autoridad jefeqa yuyariran chay horastapuni Jesuspa khayna nisqanta: “Wasiykiman kutipuy. Wawaykiqa manan wañunqachu”, nispa. Chayta yuyarispanmi, chay jefeqa llapallan familiantin Jesuspi creeranku. ");
INSERT INTO qveNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Kay ishkay kaq milagrotan Jesusqa Judea provincia lawmanta kutimuspa, Galilea provincia lawpi ruwaran. ");
INSERT INTO qveNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Jesusqa (Galilea provincia lawpi kasqanmantan), Jerusalén llaqtaman kutiran, chaypi Israel nacionniyoq runakunapa fiesta ruwasqankuman rinanpaq. ");
INSERT INTO qveNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Chay Jerusalén llaqtapin huk punku karan “Ovejakunapa punkun” nisqa sutiyoq. Chay punkupa cercanpin huk estanque karan. Chay estanqueq muyuriqninpin karan pishqa corredorkuna. Chay estanquetan hebreo rimaypi niranku “Betesda” nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Chay estanquepa corredorninkunapin ashka onqosqa runakuna karanku pampapi t'ikralayashaq: ñawsakuna, wist'ukuna, hinallataq mana puriq runakuna ima. {Paykunan unu qallchikamunanta suyakuranku. ");
INSERT INTO qveNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Chay unuqa qallchikamuran, huk ángel una-unaymanta chay estanqueman urayamuspa, qonqayllamanta qallchichimuqtinmi. Chaymi chay unu qallchikamuqtin hinalla, pipas primerta chay estanquepi unuman haykuqqa, ima onqoyninmantapas sanoyasqa karan}. ");
INSERT INTO qveNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Chay estanquepa corredorninpin huk mana puriq runa kasharan. Paymi kinsa chunka pusaqniyoq wataña onqosqa karan. ");
INSERT INTO qveNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesusqa chay runata pampapi t'ikralayashaqta rikuspanmi, hinallataq unay wataña onqosqanta yachaspanmi, payta tapuran: —¿Munankichu sanoyayta? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Hinaqtinmi chay onqosqa runaqa contestaran: —Señorlláy, manan ni pipas kanchu, kay estanquepi unu qallchikamuqtin apaykuwananpaq, kikiy rinaykamaqa hukmi ganaruwan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Saynata niqtinmi, Jesusqa chay onqosqa runata niran: —Hatariy; hinaspa kallapiykita oqarispa ripuy, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Hinaqtinmi chay onqosqa runaqa kasqan ratolla sanoyaspa, kallapinta oqarispa ripuran. Chay sanoyasqan p'unchawqa, Israel nacionniyoq runakunapa samananku p'unchawmi karan. ");
INSERT INTO qveNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Chaymi Israel nacionniyoq runakunapa wakin jefenkunaqa chay sanoyasqa runata niranku: —Manan allinchu samana p'unchawpi kallapiykita q'epiyukuspa purinaykipaqqa, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Chaymi chay sanoyaq runaqa niran: —Sanoyachiwaqniy runan khaynata niwaran: “Hatariy; hinaspa kallapiykita oqarispa ripuy”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Hinaqtinmi Israel nacionniyoq runakunapa jefenkunaqa tapuranku: —¿Pitaq chaytari nisuranki: “Hatariy, hinaspa kallapiykita oqarispa ripuy”, nisparí? ");
INSERT INTO qveNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ichaqa chay sanoyachisqan ratopin Jesusqa ashka runakunapa kasqanmanta, huk lawman pasatamuran. Chayraykun chay sanoyaq runaqa mana yacharanchu, pis chay sanoyachiqnin runa kasqantaqa. ");
INSERT INTO qveNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Chaymantan Jesusqa Jerusalén templopi chay sanoyachisqan runata tarispa niran: —Kunanqa sanoñan kashanki; amañayá huchallikunkiñachu. Yanqañataq yapamanta huchallirukuqtiykiqa ima mana allinpas astawanraq pasarusunkiman, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Hinaqtinmi chay sanoyaq runaqa Israel nacionniyoq runakunapa jefenkunapa kasqanman rispa, khaynata willaran: —Noqata sanoyachiwaqniy runaqa, Jesusmi kasqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Chaymi chay jefekunaqa, samana p'unchawpi milagrokunata Jesús ruwasqanrayku, wañuchinankupaq mashkaranku. ");
INSERT INTO qveNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Hinaqtinmi Jesusqa niran: —Dios Taytayqa sapa p'unchawmi llank'ashan; chaymi noqapas llank'ashani, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Chay nisqanta uyarispankun, Israel nacionniyoq runakunapa jefenkunaqa anchata phiñakuranku. Hinaspan Jesustaqa wañuchiytapuni munaranku, samana p'unchawpi onqosqa runakunata sanoyachisqanmanta, hinallataq “Diosqa Papaymi” nispa Dioswan igualakusqanmantawan ima. ");
INSERT INTO qveNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Chay Israel nación llaqtapi jefekunatan Jesusqa nillarantaq khaynata: —Cheqaqtapunin niykichis: Noqa Diospa Wawanqa manan kikiypa munasqayman hinachu imatapas ruwashani. Aswanqa Dios Taytaypa tukuy ima ruwasqantan rikuni; hinaspan Papaypa munasqanman hina ruwashani. ");
INSERT INTO qveNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Papayqa munakuwanmi. Chaymi tukuy ima ruwasqankunatapas rikuchiwan. Ichaqa qankunan kay milagrokuna ruwasqaymantapas aswan más cosaskunataraq rikuspa, anchata admirakunkichis. ");
INSERT INTO qveNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Imaynan Papaypas wañusqa runakunaman kawsayta qon, saynallataqmi noqapas pi munasqayman kawsayta qoni. ");
INSERT INTO qveNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Papayqa manan ni pitapas juzganchu; aswanmi noqata akllawaran, runakunata juzganaypaq, ");
INSERT INTO qveNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","saynapi Papayta hina noqatapas adorawanankupaq. Noqata mana adorawaqkunaqa, mandamuwaqniy Dios Taytaytapas manallataqmi adorankuchu. ");
INSERT INTO qveNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Cheqaqtapunin niykichis, pipas palabraykunata uyarispa kasukuqqa, hinallataq mandamuwaqniy Diospipas creenqa chayqa, manañan juzgasqañachu kanqa. Aswanmi wañusqanmanta kawsarimuspa, wiñaypaq kawsayniyoq kanqa. ");
INSERT INTO qveNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Cheqaqtapunin niykichis: Ñan hora chayaramunña, Diospi mana creeq wañusqa hina runakuna noqata uyariwanankupaq. Sichus noqapa willasqayta kasukunqaku chayqa, wiñaypaqmi kawsanqaku. ");
INSERT INTO qveNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Imaynan Dios Taytaypas kikinmanta kawsananpaq atiyniyoq, saynallataqmi noqa Wawanmanpas atiyta qowan, kikiymanta kawsayniyoq kanaypaq. ");
INSERT INTO qveNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Hinaspapas Dios Taytayqa noqamanmi atiyta qowan, llapallan runakunata juzganaypaq. Saynataqa juzgasaq, Diosmanta Hamuq Runa kasqayraykun. ");
INSERT INTO qveNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Qankunaqa amayá kaykunata nisqayraykuchu admirakuychis. Ichaqa chayamunqan p'unchaw, sepulturapi p'ampasqa kaqkunapas, vozniyta uyarispanku, kawsarispa ");
INSERT INTO qveNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","lloqsimunankupaq. Chay p'unchawmi Diospa munasqanman hina allin kaqkunata ruwaq runakunaqa, wiñaypaq kawsanankupaq kawsarimunqaku. Ichaqa mana allinkunata ruwaq runakunañataqmi, castigasqa kanankupaq kawsarimunqaku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Noqaqa manan ni imatapas kikillaymantaqa ruwaymanchu. Aswanmi noqaqa Dios Taytaypa niwasqanman hina juzgani. Chaymi noqapa juzgasqayqa cheqaqpuni. Hinaspapas noqaqa manan munasqaytachu ruwani; aswanqa Dios Taytaypa munasqanman hinan imatapas ruwani. Chaypaqmi Dios Taytayqa mandamuwaran. ");
INSERT INTO qveNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Sichus noqapa favorniypi imatapas kikillaymanta willakuyman chayqa, chay willakusqayqa manan valenmanchu. ");
INSERT INTO qveNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ichaqa huk runan testigo kaspa noqapa favorniypi willakuran. Paymi qankunaman noqamanta willasurankichis. Chay willakusqanqa cheqaqpunin. ");
INSERT INTO qveNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Qankunaqa noqamanta tapumunankupaqmi, Bautizaq Juanman runakunata kacharankichis. Hinaqtinmi payqa noqamanta cheqaqtapuni paykunaman willamuran. ");
INSERT INTO qveNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ichaqa manan noqaqa necesitanichu pipas favorniypi willakunantaqa. Aswanmi kaykunataqa niykichis, qankuna salvasqa kanaykichispaq. ");
INSERT INTO qveNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Bautizaq Juanmi tutayaqpi ratashaq lámpara hina qankunapaq karan. Chaymi qankunaqa paypa yachachisqankunawan pisi tiempolla kusikurankichis. ");
INSERT INTO qveNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ichaqa noqapa ruwasqaykunan, Bautizaq Juanpa willakusqanmantaqa aswan más importante. Chaymi ruwasqaykunaqa huk testigo hina llapallan runakunapaq, saynapi Diosmanta Hamuq Runa kasqayta yachanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Hinaspapas kikin Dios Taytaymi kay pachaman mandamuwaspa, noqamanta allinta riman. Ichaqa qankunaqa manan ni hayk'aqpas Dios Taytaypa rimasqantaqa uyarirankichishchu, nitaqmi ni hayk'aqpas rikurankichispashchu. ");
INSERT INTO qveNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ichaqa Dios Taytaypa kamachisqankunata uyarishaspaykichispas, qankunaqa manan kasukurankichishchu. Chaymi qankunaqa mandamuwaqniy Dios Taytaypa Wawan kashaqtiypas mana creewankichishchu. ");
INSERT INTO qveNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Qankunaqa wiñay kawsayniyoq kayta munaspaykichismi, Bibliata anchallataña estudiankichis. Ichaqa noqamanta Bibliapi willakuyta tarishaspaykichispas, ");
INSERT INTO qveNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","manan qankunaqa noqapi creeyta munankichishchu. Sichus noqapi creewaqchis chayqa, wiñaypaqmi Dioswan kawsawaqchis. ");
INSERT INTO qveNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Noqaqa manan runakuna alabawanankutachu mashkani. ");
INSERT INTO qveNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Hinaspapas noqaqa allintan qankunataqa reqsiykichis. Hinaspapas noqaqa yachallanitaqmi, Diosta mana khuyakuq runakuna kasqaykichista. ");
INSERT INTO qveNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Noqaqa Dios Taytaypa sutinpin hamurani. Ichaqa qankunaqa manan chashkiwankichishchu. Sichus pi runapas kikinpa sutillanpi hamunman chayqa, paytan ichaqa sumaq khuyakuywanraq chashkiruwaqchis. ");
INSERT INTO qveNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Qankunaqa, ¡qankunapurallan alabanakuyta munankichis! ¡Ichaqa Dios alabasunaykichistaqa manan qankunaqa mashkankichishchu! Chayri, ¿imaynataq noqapiri creewaqchís? ");
INSERT INTO qveNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Qankunaqa amayá piensaychishchu Dios Taytaypa ñawpaqninpi noqa acusanaymantaqa. Dios Taytaypa ñawpaqninpiqa, manan noqachu acusasqaykichis, aswanqa Moisesmi acusasunkichis, paypa escribisqan leykunaman hap'ipakuspa mana kasukusqaykichisrayku. ");
INSERT INTO qveNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moisesqa noqamantan escribiran. Chaymi niykichis, sichus qankuna Moisespa escribisqan leykunapi cheqaqtapuni creewaqchis chayqa, noqapipas creewaqchismi. ");
INSERT INTO qveNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Saynaqa Moisespa escribisqan leykunapi mana creeshaspaykichisri, ¿imaynataq noqapa rimasqaykunapiri creewaqchís? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Chaymantan Jesusqa Galilea laguna qochapa waq law chimpanman riran. Chay laguna qochapa huknin sutinmi karan Tiberias. ");
INSERT INTO qveNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Jesustaqa ashka runakunan qatikuranku, ñawpaqtaraq ashka runakunata sanoyachisqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Chay laguna qochapa chimpanman chayaruspanmi, Jesusqa discipulonkunapiwan kushka huk moqoman riran. Hinaspan chay moqopi discipulonkunawan kushka tiyayuran. ");
INSERT INTO qveNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Chay p'unchawkunapin Israel nacionniyoq runakunapa Pascua fiesta ruwananku ña chayamusharanña. ");
INSERT INTO qveNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Hinaqtinmi ashkallaña runakuna Jesuspa kasqanman hamuranku. Chayta rikuspanmi, Jesusqa Felipeta tapuran: —Kay ashkallaña runakuna mikhunanpaqri, ¿maypitaq t'antatari rantiramusunman? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Saynataqa Jesusqa tapuran, Felipepa iñiyninta yachanallanpaqmi. Ichaqa Jesusqa ñan yacharanña ima ruwaytapas. ");
INSERT INTO qveNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Hinaqtinmi Felipeqa Jesusta contestaran: —Ishkay pachaq p'unchaw jornalpa chanin qolqewan t'antata rantispanchispas, kay ashkallaña runakunamanqa, manan ni chika-chikallankapas aypachisunmanchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Chaymi Jesuspa discipulon Simón Pedropa wawqen Andresqa, Jesusta niran: ");
INSERT INTO qveNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Kaypin huk warmachapa cebadamanta ruwasqa pishqa t'antan, hinallataq ishkay kankasqa challwachanpiwan kashan. Chayllaqa manamá aypanmanchu kay ashkallaña runakunaman rakinanchispaqqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Chaymi Jesusqa discipulonkunata niran: —Llapallan runakunata tiyachimuychis, nispa. Hinaqtinmi discipulonkunaqa pasto-pasto pampapi llapallan runakunata tiyachiranku. Chaypi tiyachisqanku qarikunaqa pishqa waranqa hinan karanku. ");
INSERT INTO qveNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Chaymantan Jesusqa t'antata makinpi hap'iyuspa, Diosman graciasta qoran. Graciasta qoruspanmi Jesusqa t'antata partiyuspa, discipulonkunaman qoran, runakunaman paykuna rakimunankupaq. Saynallatataqmi kankasqa challwakunawanpas ruwaran. Chaymi chaypi runakunaqa mikhuranku asta saqsanankukama. ");
INSERT INTO qveNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Hinaqtinmi llapallan runakuna saqsanankukama mikhuruqtinku, Jesusqa discipulonkunata niran: —Puchuqkunata huñumuychis ama usunanpaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Chaymi Jesuspa discipulonkunaqa chay pishqa t'anta rakisqankumanta puchuqkunata, chunka ishkayniyoq canasta hunt'ataraq huñumuranku. ");
INSERT INTO qveNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Hinaqtinmi chaypi runakunaqa, Jesuspa chay milagro ruwasqanta rikuspanku, khaynata niranku: —Cheqaqtapunin kay runaqa Diosmanta willakuq profeta. Paymi kay pachaman hamunan karan, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Hinaqtinmi Jesusqa cuentata qokuran chaypi kaq runakuna Jesusta hap'iruspa, reyninku kananpaq churay munasqankuta. Chayraykun Jesusqa huk orqoman kaqmanta pasatamuran, chaypi sapallan kananpaq. ");
INSERT INTO qveNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ña tutayaramushaqtinñan Jesuspa discipulonkunaqa chay hatun laguna qochaman riranku. ");
INSERT INTO qveNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Hinaspan huk boteman wicharuspanku, laguna qochapa waq law chimpanpi Capernaúm llaqtaman riranku. Risqanku ratoqa ñan tutaña karan. Jesusñataqmi ichaqa mana paykunawan kushkachu riran. ");
INSERT INTO qveNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Hinaqtinmi qonqayllamanta chay botepi rishaqtinku nishuta wayra-wayramuqtin, laguna qochapi unu qallchikamuspa altomanraq oqarikamuran. ");
INSERT INTO qveNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Chaymi discipulokunaqa pishqa otaq soqta kilometrota hinaña rishaspanku, laguna qochapi unuq hawantakama hamushaqta Jesusta rikururanku. Hinaspan risqanku boteman Jesús ashuyamusqanta rikuspanku, paykunaqa anchata mancharikuranku. ");
INSERT INTO qveNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Hinaqtinmi Jesusqa paykunata niran: —¡Noqan kani! ¡Ama mancharikuychishchu! nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Chaymi discipulonkunaqa risqanku botepi ancha kusikuywan Jesusta chashkiranku. Ichaqa chay ratollataqmi chay risqanku llaqtamanpas chayaranku. ");
INSERT INTO qveNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Paqarisnintin p'unchawmi, laguna qochapa waq lawninpi qepamuq runakunaqa cuentata qokuranku ch'ullalla bote chaypi kasqanta. Hinaspapas paykunaqa yacharankun Jesusqa discipulonkunawan botepi mana risqanta. ");
INSERT INTO qveNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Chaymi chay ratolla huk botekunapi Tiberias llaqtamanta runakuna chayamuranku. Hinaspan chay runakunaqa qepakuranku, maypichus Jesusqa Diosman graciasta qospa t'antata runakunaman mikhuchiran, chay lugarpa ladonpi. ");
INSERT INTO qveNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Hinaqtinmi chay runakunaqa, Jesusta hinallataq discipulonkunatawan chay botekunapi mana hamusqanta rikuspanku, huk botekunaman wicharanku. Hinaspan paykunaqa Capernaúm llaqtakama mashkaq riranku. ");
INSERT INTO qveNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Jesusta mashkaq runakunaqa, Galilea laguna qochapa waq law chimpanman rispankun, Jesusta chaypi tariranku. Hinaspan khaynata tapuranku: —Yachachikuq, kay lugarmanri, ¿hayk'aqtaq chayaramurankí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Hinaqtinmi Jesusqa paykunata contestaspa, khaynata niran: —Cheqaqtapunin niykichis, qankunaqa manan milagrokuna ruwasqayta entiendesqaykichisraykuchu mashkawashankichis. Aswanqa t'antata saqsanaykichiskama mikhusqaykichisraykun, qankunaqa mashkawashankichis. ");
INSERT INTO qveNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Chaymi niykichis, qankunaqa amayá tukukuq mikhunallapaqchu llank'aychis. Aswanqa mana tukukuq wiñay kawsay mikhunapiyá preocupakuychis. Chay mikhunatan noqa Diosmanta Hamuq Runaqa wiñaypaq kawsanaykichispaq qosqaykichis. Chaypaqmi Dios Taytayqa atiyta noqaman qowan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Saynata Jesús niqtinmi, chay runakunaqa payta tapuranku khaynata: —Diospa munasqanta ruwanaykupaqri, ¿imatataq noqaykuri ruwaykuman? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Hinaqtinmi Jesusqa paykunata contestaspa niran: —Diosqa munan, noqapi qankuna creenaykichistan. Paymi noqata kay pachaman mandamuwaran, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Chaymi runakunaqa kaqmanta Jesusta tapullarankutaq khaynata: —Noqayku qanpi creenaykupaqri, ¿ima milagrotataq ruwankí? ¡Rikuchiwaykuyá ima milagrollatapas qanpi creenaykupaq! ");
INSERT INTO qveNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ñawpaq tiempopi abueloykuqa, ch'inñeq lugarkunapi purishaspankun “maná” nisqa sutiyoq t'antata mikhuranku. Chaymi Bibliapi escribisqa kashan: “Diosmi cielomanta mikhunankupaq t'antata qomuran”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Chaymi Jesusqa paykunata contestaspa niran: —Cheqaqtapunin niykichis, manan Moiseschu chay t'antataqa ñawpaq abueloykichiskunamanqa qoran, aswanqa Dios Taytaymi. Chaymi kunanpas qankunamanqa kikin Dios Taytaypuni cielomanta cheqaq t'antataqa qosunkichis. ");
INSERT INTO qveNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Diosmi chay cheqaq t'antataqa hanaq pachamanta mandamuran, runakunaman wiñay kawsayta qonanpaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Hinaqtinmi Jesuspa nisqanta uyarispanku, chay runakunaqa niranku: —Señor, chay t'antatayá sapa kutin qowayku, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Chaymi Jesusqa paykunata niran: —Noqan kani chay kawsay t'antaqa, hinallataq runakunaman kawsay qoqpas. Pipas noqaman hamuqqa, manan hayk'aqpas yarqachikunqachu. Hinallataq pipas noqapi creeqqa manan hayk'aqpas ch'akichikunqachu. ");
INSERT INTO qveNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ichaqa saynata nishaqtiypas, hinallataq milagrokuna ruwasqayta rikushaspaykichispas, manan qankunaqa noqapiqa creenkichishchu. ");
INSERT INTO qveNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Dios Taytaypa llapallan qowasqan runakunaqa, noqapin creenqaku. Pipas noqapi creeqtaqa chashkisaqmi. Hinaspapas paykunataqa manan ni hayk'aqpas wikch'usaqchu. ");
INSERT INTO qveNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Noqaqa manan munasqayta ruwanaypaqchu hanaq pachamantaqa hamurani, aswanqa Dios Taytaypa munasqanta ruwanaypaqmi. ");
INSERT INTO qveNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Dios Taytayqa kay pachamanmi mandamuwaran. Hinaspan payqa mana munanchu qowasqan runakunata ni ch'ullallatapas chinkachinayta. Aswanmi payqa juicio p'unchawpi paykunata kawsarichinayta munan. ");
INSERT INTO qveNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ichaqa Dios Taytaypa munayninqa kaymi: pipas Diospa Wawanta rikuspa, paypi creeqqa, wiñay kawsayniyoqmi kanqa. Sayna creeqtaqa juicio p'unchawpin noqa kawsarichimusaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Chaymi Israel nacionniyoq runakunaqa, “Noqan kani hanaq pachamanta hamuq kawsay t'anta” nispa Jesús nisqanta uyarispankun, Jesuspa contranpi rimayta qallariranku. ");
INSERT INTO qveNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Hinaspan paykunapura ninakuranku: —Payqa, ¿manachu Joseypa wawan? Noqanchisqa reqsishanchismá tayta mamantaqa. Chayri, ¿imanaqtintaq payri nin: “Hanaq pachamantan hamuni”, nisparí? ");
INSERT INTO qveNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Chaymi Jesusqa paykunata contestaspa niran: —Qankunapuraqa amayá mana allinkunataqa rimapakuychishchu. ");
INSERT INTO qveNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Dios Taytaymi noqataqa mandamuwaran. Chaymi niykichis, manan ni pipas kikillanmantaqa noqapiqa creenmanchu, sichus Dios Taytay mana yanapaqtinqa. Chaymi noqapi creeq runakunataqa wiñaypaq kawsanankupaq juicio p'unchawpi kawsarichisaq. ");
INSERT INTO qveNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kaykunaqa Diosmanta willakuq ñawpaq profeta runakunapa escribisqanpin khaynata nishan: “Diosmi yachachinqa llapallan runakunataqa”, nispa. Chaymi Dios Taytaypa rimasqankunata uyarispa, paymanta allinta yachaqkunaqa, noqaman hamunqaku, (noqapi creespa discipuloykuna kanankupaq). ");
INSERT INTO qveNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Manan ni pipas Dios Taytaytaqa rikuranchu. Aswanqa Diosmanta noqa hamuqllan paytaqa rikuni. ");
INSERT INTO qveNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Chaymi cheqaqtapuni niykichis, “pipas noqapi creeq runakunan wiñay kawsayniyoq kanqaku”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Noqan kani wiñay kawsay qoq t'antaqa. ");
INSERT INTO qveNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ñawpaq abueloykichiskunaqa ch'inñeq lugarkunapi kashaspankun “maná” nisqa t'antata mikhuranku. Ichaqa paykunaqa, chay t'antata mikhushaspankupas wañurankun. ");
INSERT INTO qveNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Noqan kani hanaq pachamanta urayamuq cheqaq t'antaqa. Chaymi pipas kay cheqaq t'antata mikhuqqa, wiñaypaq kawsanqa. ");
INSERT INTO qveNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Noqan kani hanaq pachamanta urayamuq kawsaq t'antaqa. Sichus pipas kay kawsaq t'antata mikhuqqa, wiñaypaqmi kawsanqa. Chay qosqay kawsaq t'antaqa, noqapa cuerpoymi. Chay t'antatan noqaqa qosaq, pipas noqapi creeqkuna wiñay kawsayniyoq kanankupaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Chaykunata Jesús niqtinmi, chay Israel nacionniyoq runakunaqa, paykunapura Jesuspa contranpi rimaspanku, discutinakuranku khaynata: —Kay runari, ¿imaynataq kikinpa cuerpontari mikhuchiwasunman? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Hinaqtinmi Jesusqa paykunata niran: —Cheqaqtapunin niykichis, sichus noqa Diosmanta Hamuq Runapa cuerpoyta, qankuna mana mikhunkichishchu, hinallataq yawarniytapas mana tomankichishchu chayqa, manan wiñay kawsayniyoqchu kankichis. ");
INSERT INTO qveNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Chaymi pipas cuerpoyta mikhuqqa, hinallataq yawarniytapas tomaqqa, wiñaypaq kawsanqa. Saynallataqmi juicio p'unchaw chayamuqtinpas kawsarichimusaq. ");
INSERT INTO qveNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Cheqaqtapunin niykichis, noqapa cuerpoyqa cheqaq t'antan; hinallataq yawarniypas cheqaq tomanan. ");
INSERT INTO qveNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Chaymi pipas noqapa cuerpoyta mikhuqqa, hinallataq yawarniytapas tomaqqa, noqawanmi kashan; saynallataqmi noqapas paywan kashani. ");
INSERT INTO qveNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Kachamuwaqniy Dios Taytayqa wiñay kawsayniyoqmi. Saynallataqmi noqapas payrayku wiñay kawsayniyoq kani. Saynallataqmi pipas noqapa cuerpoyta mikhuqqa, noqarayku wiñay kawsayniyoq kanqa. ");
INSERT INTO qveNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Noqaqa hanaq pachamanta hamuq t'antan kani. Hinaspapas noqaqa manan ñawpaq abueloykichiskunapa mikhusqan maná t'anta hinachu kani. Paykunaqa chay t'antata mikhushaspankupas, wañullarankun. Ichaqa pipas kay pachaman hamuq t'antata mikhuqqa, (noqapi creesqanraykun) wiña-wiñaypaq kawsayniyoq kanqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesusqa Diosmanta yachachina sinagoga wasipin chaykunata runakunaman yachachiran Capernaúm llaqtapi kashaspa. ");
INSERT INTO qveNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Hinaqtinmi Jesuspa yachachisqankunata uyarispanku, payta qatikuq wakin runakunaqa, khaynata niranku: —Ancha sasan kay rimasqankunaqa. ¿Pitaq kay rimasqankunawanri acuerdopi kanman? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Hinaqtinmi Jesusqa paykunapura rimapakusqankuta yachaspa, khaynata niran: —Qankunari, ¿kay nisqaykunawanchu phiñakuspa chaykunata rimapakushankichís? ");
INSERT INTO qveNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Aswanqa, ¿ima niwaqchistaq noqa Diosmanta Hamuq Runata hanaq pachaman kutipusqayta rikuwaspaykichisrí? ");
INSERT INTO qveNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Diospa Santo Espiritunmi runakunamanqa wiña-wiñaypaq kawsayta qon. Runakunaqa manan ni pipas wiñaypaq kawsaytaqa atinmanchu. Ichaqa kay rimasqaykunaqa, Santo Espiritumantan hamun. Paymi noqapi creeqkunamanqa wiñay kawsayta qon. ");
INSERT INTO qveNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ichaqa kashanraqmi, qankuna ukhumanta noqapi mana creeq runakuna, nispa. Jesusqa saynataqa niran, pikunas paypi mana creeq runakuna kasqanta yachaspanmi, hinallataq pis payta traicionananpaq runa kasqanta ñawpaqmantaraq yachasqanraykun. ");
INSERT INTO qveNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Chaymi Jesusqa nillarantaq: —Qankunamanqa ñan niraykichishña, manan mayqenniykichispas noqapi creeytaqa atiwaqchishchu, sichus Dios Taytay qankunata mana yanapasuqtiykichisqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Saynata Jesús rimaqtinmi, payta qatikuq ashka discípulo runakunaqa, ishkayaspa ripuranku. Hinaspan Jesuswanqa chay ratomantapacha manaña purirankuñachu. ");
INSERT INTO qveNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Chaymi Jesusqa chunka ishkayniyoq discipulonkunata tapuran: —Icha, ¿qankunapas ripuytachu munashankichís? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Hinaqtinmi Simón Pedroqa contestaran: —Señor, noqaykuri, ¿pimantaq riykuman? Qanpa rimasqaykikunallan wiñay kawsay qokuqqa. ");
INSERT INTO qveNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Chaymi noqaykuqa qanpi creeyku; hinallataq yachayku qanqa Diosmanta Hamuq Salvadorniyku kasqaykita, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Hinaqtinmi Jesusqa niran: —Qankunataqa chunka ishkayniyoqtan akllaraykichis. Ichaqa hukniykichismi qankuna ukhumanta huk demonio kashan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Saynataqa Jesusqa rimaran, Simonpa wawan Judas Iscariotemantan. Paymi Jesustaqa traicionaspa wañuchinankupaq entreganan karan. Chay Judas Iscarioteqa Jesuspa chunka ishkayniyoq discipulonkunamanta huknin kaqmi karan. ");
INSERT INTO qveNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Huk tiempo pasaruqtinmi, Jesusqa Galilea provincia law llaqtakunapi puriran. Hinaspan payqa Judea provincia lawpi llaqtakunaman riyta mana munaranchu, chaypi Israel nacionniyoq runakunapa jefenkuna wañuchinankupaq Jesusta mashkasqankurayku. ");
INSERT INTO qveNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Chay p'unchawkunapin Israel nacionniyoq runakunapa ramada fiesta ruwananku chayamusharanña. ");
INSERT INTO qveNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Chaymi Jesuspa wawqenkunaqa, Jesusta khaynata niranku: —Judea lawpi fiestamanqa rinaykin, discipuloykikuna chaypi milagro ruwasqaykita rikunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Pipas runakunawan reqsichikunanpaq imatapas ruwaspaqa, manan pakallapichu ruwan. Saynaqa milagrokunata ruwaspaykiqa, llapallan runakuna rikunanpaqyá ruway, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Saynataqa Jesuspa wawqenkunaqa niranku, paykunapas Jesuspi mana creesqankuraykun. ");
INSERT INTO qveNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Hinaqtinmi Jesusqa paykunata contestaspa niran: —Jerusalén llaqtaman rinaypaqqa manaraqmi tiempoqa chayamunraqchu. Qankunapaqmi ichaqa ima tiempopas allinlla. ");
INSERT INTO qveNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kay pachapi runakunaqa manan qankunataqa cheqnikusunkichishchu. Noqatan ichaqa cheqnikuwanku, tukuy mana allinkuna ruwasqankumanta, paykunaman willasqayrayku. ");
INSERT INTO qveNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Chay fiestamanqa qankunallaraqyá rishaychis. Noqapaqqa manaraqmi reqsichikunay tiempoqa chayamunraqchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jesusqa saynata wawqenkunata niruspanmi, Galilea provinciallapi qepakuran. ");
INSERT INTO qveNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Jesuspa wawqenkuna fiestaman pasaqtinkun, Jesuspas mana ni pipa yachasqallan chay fiestaman riran. ");
INSERT INTO qveNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Chaymi chay fiestapi, Israel nacionniyoq runakunapa jefenkunaqa Jesusta mashkaranku, khaynata ninakuspanku: —Chay runari, ¿maypitaq kunan kashan? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Llapallan chay fiestapi kaq runakunan Jesusmanta rimaranku. Wakinmi niranku: —Payqa allin sumaq runan, nispanku. Hukkunataqmi niranku: —Payqa runakunata engañaq runan, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ichaqa Jesusmanta rimaq runakunaqa pakallapin chaykunataqa rimaranku, Israel nación llaqtayoq runakunapa jefenkunata manchakusqankurayku. ");
INSERT INTO qveNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Hinaqtinmi chawpi fiestaña kashaqtin, Jesusqa Jerusalén temploman haykuran. Hinaspan chay templopi yachachiyta qallariran. ");
INSERT INTO qveNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Chaymi Israel nacionniyoq runakunapa jefenkunaqa Jesuspa yachachisqanta uyarispanku admirasqallaña karanku. Hinaspan paykunaqa ninakuranku khaynata: —Kay runari, ¿imaynanpitaq kaykunatari yachan, yachayniyoq runakunapa mana yachachisqan kashaspanrí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Hinaqtinmi Jesusqa paykunata contestaspa niran: —Noqaqa manan kikillaymantachu yachachini. Aswanqa Diosmi noqataqa mandamuwaran, paypa niwasqanta yachachinaypaq. ");
INSERT INTO qveNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Sichus pipas Diospa munayninman hina kasukuq runaqa, yachanqan kay yachachisqaykunaqa Diosmanta kasqanta, hinallataq rimasqaykunapas mana noqallamantachu kasqanta. ");
INSERT INTO qveNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Pipas munasqallanta riman chayqa, kikin alabasqa kayllatan mashkan. Noqan ichaqa munani, mandamuwaqniy Taytay alabasqa kananta. Chaymi noqaqa cheqaqtapuni rimani. ");
INSERT INTO qveNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Qankunaqa Moisespa escribisqan leykunatan chashkirankichis. Ichaqa chay leykunataqa manan ni mayqenniykichispas kasukurankichishchu. Chayri, ¿imanaqtintaq qankunari wañuchiwayta munashankichís? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Hinaqtinmi runakunaqa Jesusta contestaspa niranku: —Qantaqa diablon rimachimushasunki. ¿Pitaq qantari wañuchiyta munashasunkí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Hinaqtinmi Jesusqa khaynata niran: —Qankunaqa samana p'unchawpi huk milagro ruwasqaywanmi ancha admirasqallaña kashankichis. ");
INSERT INTO qveNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ichaqa Moisesmi qankunaman qosurankichis, circuncisión costumbre kamachikuyta, samana p'unchawpiña tupamuqtinpas ruwanaykichispaq. Chay kamachikuyqa manan Moisespa kamachisqanchu karan. Aswanqa ñawpaq Abrahampa, Isaacpa, hinallataq Jacobpa kawsasqan tiempomantapachan karan. ");
INSERT INTO qveNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Chaymi qankunaqa Moisespa kamachisqanta kasukuspa, samana p'unchawña kashaqtinpas, chay circuncisión costumbreta huk wawapi ruwankichis. Chayri, samana p'unchawpi huk onqosqa runata sanoyachiqtiyri, ¿imanaqtintaq qankunari noqawan phiñakunkichís? ");
INSERT INTO qveNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Saynaqa, amayá qankunaqa ruwasqayta qawarispallachu “manan allinchu” niychis. Aswanqa allinta piensaspayá cheqaq kaqta imatapas rimaychis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalén llaqtapi tiyaq wakin runakunan tapunakuranku khaynata: —Manachu kay runari, ¿wañuchinankupaq mashkasqanku runa? ");
INSERT INTO qveNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Qawariychisyá, payqa waqpin runakunawan parlashan; ichaqa manataqmi pipas ni imallatapas ninchu. ¿Icha cheqaqtachu kay llaqtanchispi autoridadkunaqa yacharunkupas payqa Diosmanta Hamuq Salvador kasqanta? ");
INSERT INTO qveNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Noqanchisqa yachanchismi maymantas kay runa kasqantaqa. Ichaqa Diosmanta Hamuq Salvaqninchis hamuqtinqa, manan ni pipas yachanqachu maymanta hamusqantapas, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Runakuna chaykunata rimaqtinkun, Jesusqa templopi yachachiran. Hinaspan altota rimaspa niran khaynata: —Qankunari, ¿creenkichishchu reqsiwanaykichispaq? ¡Qankunaqa manan yachankichishchu maymantas noqa kasqaytaqa, hinallataq pis kasqaytapas! Hinaspapas noqaqa manan kikillaymantachu hamurani. Aswanqa noqata mandamuwaqniymi cheqaq kaqta riman. Paytan ichaqa mana qankunaqa reqsinkichishchu. ");
INSERT INTO qveNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Noqan ichaqa payta reqsini. Paymantan noqaqa hamuni; hinaspapas paymi noqataqa kay pachaman mandamuwaran, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Saynata niqtinmi, Jerusalén llaqtayoq wakin runakunaqa presochayta munaranku. Ichaqa manan mayqenninkupas atrevekurankuchu hap'inankupaqqa, wañuchinankupaq tiempo manaraq chayamusqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Hinaqtinmi ashka runakuna Jesuspi creespanku, khaynata niranku: —Diosmanta Hamuq Salvadorninchis Cristo hamuspari, ¿kay runamanta aswan más hatun milagrokunataraqchus ruwanqa? Manan ni pipas pay hinaqa khayna hatun milagrokunataqa ruwayta atinmanchu. (Chaymi creenchis, payqa cheqaqtapuni Diosmanta Hamuq Salvadorninchis Cristo kasqanta), nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariseo religionniyoq runakunan uyariranku, Jesusmanta llaqtapi runakuna rimasqankuta. Chaymi paykunaqa templopi serviq sacerdotekunapiwan ima, templota cuidaq guardiakunata mandaranku, Jesusta hap'ispa presota apamunankupaq. ");
INSERT INTO qveNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Hinaqtinmi Jesusqa runakunata niran: —Noqaqa chikan tiempollañan qankunawan kushkaqa kasaq. Chaymantan noqaqa mandamuwaqniypa kasqanman kutipusaq. ");
INSERT INTO qveNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Hinaqtinmi qankunaqa mashkawankichis, ichaqa manataqmi tariwankichishchu. Hinaspapas qankunaqa, noqapa kasqaymanqa, manan atiwaqchishchu riytaqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Saynata Jesús niqtinmi, Israel nacionniyoq runakunapa jefenkunaqa paykunapura tapunakuranku khaynata: —Kay runari, ¿maymantaq rinqa mana tariy atinapaqrí? Icha, ¿huk law nacionkunapi Israel nacionniyoq llaqtamasinchis runakunaman rispachu, chay griego rimayniyoq runakunaman yachachimunqa? ");
INSERT INTO qveNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Kay runaqa khaynatan nishan: “Qankunaqa mashkawankichismi; ichaqa manataqmi tariwankichishchu. Hinaspapas qankunaqa, noqapa kasqaymanqa, manan atiwaqchishchu riytaqa”, nispa. Chay nisqanwanri, ¿ima ninantataq nishan? nispankun tapunakuranku. ");
INSERT INTO qveNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ramada fiesta tukukuy hatun p'unchawpin, Jesusqa sayariyuspa, altota rimaspa, khaynata niran: —Pipas ch'akichikuqqa, noqaman hamuchun; hinaspa kawsay qokuq unuta tomachun. ");
INSERT INTO qveNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Pipas tukuy sonqonmanta noqapi creenqa chayqa, Bibliapi nisqanman hinan: “Paypa sonqonmantaqa kawsashaq unu puririnqa”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesusqa kaykunataqa rimaran, paypi creeq llapallan runakuna Santo Espirituta chashkinankumantan. Ichaqa Santo Espirituqa manaraqmi paykunamanqa hamuranraqchu, Jesusqa kawsarinpuspa hanaq pachaman manaraq ripusqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Hinaqtinmi chaypi wakin kaq runakunaqa, Jesuspa rimasqanta uyarispanku, khaynata ninakuranku: —Kay runaqa cheqaqtapunin Diospa mandamusqan profeta, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Wakin runakunataqmi niranku: —Payqa Diosmanta Hamuq Salvawaqninchismi, nispanku. Hukkunañataqmi niranku: —Diosmanta Hamuq Salvawaqninchisqa manan Galilea provincia lawmantachu hamunqa. ");
INSERT INTO qveNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ichaqa Bibliapin khaynata nishan: “Diosmanta Hamuq Salvawaqninchisqa ñawpaq rey Davidpa mirayninmantan kanan, hinallataq Davidpa llaqtan Belén llaqtapin nacenqapas”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Chaymi runakunaqa pis Jesús kasqanmanta mana acuerdopichu karanku. Hinaspan paykunaqa Jesusrayku rakinakuranku. ");
INSERT INTO qveNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Hinaqtinmi wakin runakunaqa Jesusta presota hap'iruyta munaranku. Ichaqa manataqmi ni mayqenninkupas atrevekurankuchu hap'iytaqa. ");
INSERT INTO qveNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Fariseo religionniyoq runakunapa, hinallataq sacerdotekunapa jefenkunapa kasqanmanmi, templota cuidaq guardiakunaqa kutimuranku. Hinaqtinmi chay fariseokunaqa sacerdotekunapiwan ima chay guardiakunata, khaynata tapuranku: —Jesustari, ¿imanaqtintaq mana apamurankichishchú? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Chaymi chay guardiakunaqa khaynata contestaranku: —¡Manan ni pipas chay runa hinaqa ni hayk'aqpas rimaranchu! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Hinaqtinmi fariseo religionniyoq runakunaqa, khaynata niranku: —¿Qankunatapas chay Jesuschu engañaramusunkichishña? ");
INSERT INTO qveNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Kay Israel nación llaqtapi autoridadkunamanta, hinallataq fariseo religionniyoq runakunamantapas, ¿mayqellankupas chay Jesuspiri creeshankuchú? Manan. ");
INSERT INTO qveNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Hinaspapas Jesuspi creeq runakunaqa Moisespa escribisqan leykunataqa manan yachankuchu. Chayraykun paykunaqa maldecisqa kanqaku, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Chaypin fariseo religionniyoq Nicodemo sutiyoq runa kasharan. Paymi Jesuswan parlananpaq ñawpaqtaraq tutalla risqa. Paymi wakin fariseo religionniyoq runakunata niran: ");
INSERT INTO qveNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Moisespa escribisqan leyninchisman hinaqa, manan ni pi runatapas acusasunmanchu manaraq parlasqanta uyarishaspaqa, nitaqmi mana allin ruwasqankunamantapas manaraq allinta yachashaspaqa acusasunmanchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Chay nisqanta uyarispankun, wakin fariseo religionniyoq runakunaqa, contestaspa niranku: —¿Qanpas, Galilea provincia lawmantachu kankí? Bibliatayá allinta estudiay. Saynata estudiaspaykin yachanki, Galilea lawmantaqa manan ni pi profetapas hamuranchu, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","{Chaykunata discutiruspankun, paykunaqa wasinkuman ripuranku. ");
INSERT INTO qveNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesusqa Olivos sutiyoq moqomanmi riran. ");
INSERT INTO qveNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Paqarisnintin p'unchawñataqmi Jesusqa tutallamanta temploman kutimuran. Chaymi templopi kasqanta rikuspanku, runakunaqa payman hamuranku. Hinaqtinmi Jesusqa tiyayuspa paykunata yachachiran. ");
INSERT INTO qveNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Chaymanmi leykunata yachachiq runakunaqa, fariseo religionniyoq runakunapiwan, huk warmita waqllikushaqta tariramuspa, temploman apamuranku. Hinaspan runakunapa chawpinpi sayaykachispa, ");
INSERT INTO qveNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jesusta khaynata niranku: —Yachachikuq, kunanmi noqayku tarimuyku kay warmita huk qariwan waqllikushaqta. ");
INSERT INTO qveNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisespa escribisqan leypiqa yachachiwankun khayna clase warmikunataqa, rumiwan p'anashaspalla wañuchinaykupaq. Qanri, ¿ima ninkitaq? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Jesustan saynata tapuranku, imaynanmantapas pantarachiyta munaspanku, hinaspa chayman hinalla huchachanankupaq. Hinaqtinmi Jesusqa pampaman k'umuyuspa, dedonwan allpapi escribiran. ");
INSERT INTO qveNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Chaymi yapa-yapamanta tapupayaqtinku, Jesusqa k'umusqanmanta sayarispa, paykunata niran: —Sichus mayqenllaykichispas mana huchayoq kaspaqa, kay warmita rumiwan p'anayta qallarimuychis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Chayta niruspanmi, Jesusqa pampaman kaqmanta k'umuyuran. Hinaspan allpa pampapi yapamanta escribiran. ");
INSERT INTO qveNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Hinaqtinmi Jesuspa nisqanta uyariruspanku, chaypi kaq runakunaqa huchayoq kasqankuta yachakuranku. Hinaspan kuraq kaqmanta asta sullk'a kaqkama, ch'ulla-ch'ullallamanta ripuranku. Chaymi chay warmiqa sapallanña Jesuspa ladonpi qeparuran. ");
INSERT INTO qveNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Hinaspan Jesusqa sayarispa, chay huchachaq runakunata mana rikuspa, chay warmita tapuran: —¿Maytaq chay huchachasuqniyki runakunarí? ¿Manachu mayqellanpas condenasurankí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Chaymi chay warmiqa Jesusta contestaran: —Señor, manan ni mayqen runapas condenawanchu, nispa. Hinaqtinmi Jesusqa niran: —Noqapas manan condenaykichu. Kunanqa ripuy; hinaspa amaña kaqmantaqa huchallikunkichu, nispa.} ");
INSERT INTO qveNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesusqa runakunatan kaqmanta nillarantaq: —Noqan runakunapaq k'anchay kani. Pipas noqapi creeqqa manan tutayaqpi hinachu purinqa. Aswanqa noqapa k'anchayniywanmi kawsanqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Chaymi fariseo religionniyoq runakunaqa niranku: —Qanqa kikillaykimanta alabakuspan rimashanki. Manan sayna rimasqaykiqa cheqaqchu. ¿Imaynanpitaq noqaykuri yachaykuman rimasqayki cheqaq kasqantarí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Hinaqtinmi Jesusqa paykunata contestaspa niran: —Kikillaymanta noqa rimani chaypas, noqapa rimasqayqa cheqaqpunin. Noqaqa yachanin maymanta hamusqaytapas, hinallataq mayman risqaytapas. Ichaqa qankunaqa manan yachankichishchu ni maymanta hamusqayta nitaq mayman risqaytapas. ");
INSERT INTO qveNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Qankunaqa juzgankichis munasqaykichisman hinallan. Noqan ichaqa mana ni pitapas yanqapuniqa juzganichu. ");
INSERT INTO qveNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Runakunata noqa juzgaspayqa, cheqaqtapunin juzgani. Ichaqa manan noqaqa sapallaychu juzgani. Aswanqa mandamuwaqniy Dios Taytaymi noqawan kushka juzgan. ");
INSERT INTO qveNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Saynatan Moisespa escribisqan leypipas nishan: “Ishkay testigopa kaqlla rimasqanmi necesitakun, imapas allin cheqaq kasqanta creenapaqqa”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Noqan chay huknin testigo kani. Chaymi noqaqa kikiymanta cheqaqta rimani. Huknin testigotaqmi Papay. Chaymi paypas noqamanta cheqaqta riman, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Saynata niqtinmi, chaypi kaq fariseo religionniyoq runakunaqa Jesusta, khaynata tapuranku: —¿Maypitaq papaykiri kashan? nispanku. Chaymi Jesusqa contestaspa niran: —Qankunaqa manan noqataqa reqsiwankichishchu. Chaymi Taytaytapas mana reqsinkichishchu. Sichus noqata reqsiwankichisman chayqa, Taytaytapas reqsiwaqchismi, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesusqa kaykunatan rimaran templopi ofrendata churanankupa ladonpi yachachishaspa. Ichaqa manan ni pipas presochanankupaqqa hap'irankuchu, Jesuspa wañunan hora manaraq chayamusqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesusqa kaqmantan nillarantaq khaynata: —Noqaqa ripusaqñan. Chaymi qankunaqa mashkawankichis. Ichaqa (noqapi mana creesqaykichisraykun), qankunaqa huchallaykichispi wañunkichis. Chaymi noqapa risqaymanqa mana riytaqa atiwaqchishchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Chaymi Israel nacionniyoq runakunapa jefenkunaqa niranku: —Kay runaqa icha, ¿kikillanmantachu wañuyta piensashanpas? Chaypashchá payqa niwashanchis: “Noqapa risqaymanqa manan riytaqa atiwaqchishchu”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Chaymi Jesusqa chay ninakusqankuta yachaspa niran: —Qankunaqa kay pachamantan kankichis. Noqan ichaqa hanaq pachamanta kani. Qankunaqa kay pachallamanmi pertenecenkichis, noqan ichaqa hanaq pachaman perteneceni. ");
INSERT INTO qveNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Chaymi qankunataqa niraykichis: “Sichus qankuna noqapi mana creenkichishchu chayqa, huchallaykichispin wañunkichis”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Chaymantan paykunaqa Jesusta tapullarankutaq khaynata: —Chayri, ¿pitaq qanri kankí? nispanku. Hinaqtinmi Jesusqa paykunata contestaran: —Noqaqa ñawpaqmantaraqmi ña niraykichishña pis noqa kasqaytaqa. ");
INSERT INTO qveNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Noqaqa tukuy huchakuna ruwasqaykichismantan qankunata ninay kashan, hinallataq juzganay ima kashan. (Ichaqa manan noqallachu juzgasqaykichisqa. Aswanqa noqata mandamuwaqniypas juzgasunkichismi. Noqaqa imatapas ruwashani Dios Taytaypa niwallasqantan). Dios Taytayqa cheqaqtapunin riman. Saynallataqmi noqapas paypa rimasqallanta uyarispa, qankunaman willashaykichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ichaqa chaypi kaq runakunaqa manan entienderankuchu, Jesusqa Dios Taytanmanta paykunaman willasqantaqa. ");
INSERT INTO qveNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Chaymi Jesusqa paykunata niran: —Qankunaqa noqa Diosmanta Hamuq Runata cruzpi chakataruwaspaykichishñan yachankichis pi kasqaytaqa. Noqaqa manan kikillaymantachu imatapas ruwashani. Aswanqa Papaypa yachachillawasqantan qankunamanqa willashaykichis. Chaykunataqa qankunaqa entiendenkichis, wañusqaypa qepan p'unchawkunatañan. ");
INSERT INTO qveNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Noqaqa Papaypa munasqanman hinan imatapas ruwani. Chaymi noqata mandamuwaqniy Papayqa noqawan kashan. Chayraykun Papayqa mana sapallaytachu saqewan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Chaykunata Jesús rimaqtinmi, ashka runakunaqa Jesuspi creeranku. ");
INSERT INTO qveNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jesusqa paypi creeq Israel nacionniyoq runakunatan, khaynata nillarantaq: —Sichus qankuna kay yachachisqaykunata kasukunkichis chayqa, cheqaqtapunin noqapa discipuloykuna kankichis. ");
INSERT INTO qveNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Saynapin qankunaqa cheqaq kaqta reqsinkichis. Chay cheqaq kaqtaqmi librasunkichispas, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Hinaqtinmi paykunaqa contestaspa niranku: —Noqaykuqa Abrahampa mirayninmantan kayku. Hinaspapas noqaykuqa manan ni pipa esclavonpas ni hayk'aqpas karaykuchu. ¿Chaychu qanri kunan ninki: “Cheqaq kaqpi creespan libre kankichis”, nisparí? ");
INSERT INTO qveNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Hinaqtinmi Jesusqa paykunata contestaran: —Noqaqa cheqaqtapunin niykichis, pipas huchallapi kawsaq runaqa, diablopa esclavonmi. ");
INSERT INTO qveNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Huk esclavoqa manan patronninpa wasinpiqa wiñaypaqqa qepakunmanchu. Patronpa wawanmi ichaqa wiñaypaq chay wasipi qepakun. ");
INSERT INTO qveNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Chaymi niykichis, sichus noqa Taytaypa Wawan qankunapa huchaykichista perdonasqaykichis chayqa, cheqaqtapunin qankunaqa huchaykichismanta libre kankichis. ");
INSERT INTO qveNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Arí, noqaqa yachanin qankunaqa Abrahampa mirayninmanta kasqaykichista. Ichaqa qankunaqa wañurachiwaytan munashankichis, yachachisqaykunata sonqoykichispi chashkiyta mana munasqaykichisrayku. ");
INSERT INTO qveNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Noqaqa Taytaypa rikuchiwasqantan qankunaman willashaykichis. Qankunan ichaqa papaykichispa yachachisusqaykichista ruwashankichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Hinaqtinmi paykunaqa niranku: —Noqaykupa papaykuqa Abrahammi, nispa. Chaymi Jesusqa paykunata contestaran: —Sichus cheqaqtapuni Abrahampa mirayninmanta kaspaqa, paypa ruwasqantachá qankunapas ruwawaqchis. ");
INSERT INTO qveNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ichaqa Diospa willawasqan cheqaq kaqkunatan qankunamanqa willashaykichis. Chaymi qankunaqa noqata wañuchiwayta munashankichis. ¡Abrahamqa manan ni hayk'aqpas saynataqa ruwaranchu! ");
INSERT INTO qveNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Qankunan ichaqa papaykichispa ruwasqallanta ruwashankichis, nispa. Chaymi paykunaqa Jesusta niranku: —Noqaykuqa manan wachapakuq warmipa wawanchu kayku. Noqaykupa papaykuqa kikin Diospunin, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Hinaqtinmi Jesusqa paykunata contestaspa niran: —Sichus cheqaqta kikin Diospuni papaykichis kanman chayqa, noqataqa munakuwankichismanmi, Diosmanta hamusqayrayku. Ichaqa manan noqaqa kikillaymantachu hamurani. Aswanqa kikin Diospunin noqataqa kay pachaman mandamuwaran. ");
INSERT INTO qveNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Qankunari, ¿imanaqtintaq rimasqaytari mana entiendenkichishchú? Qankunaqa rimasqaykunata uyariyta mana munasqaykichisraykun, mana entiendenkichishchu. ");
INSERT INTO qveNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Qankunapa papaykichisqa kikin diablon. Chaymi qankunaqa paypa munasqallanta ruwayta munankichis. Diabloqa qallariyninmantapachan runa wañuchiq, hinallataq llullakuspa rimaq. Hinaspapas diabloqa llulla kasqanraykun, imatapas llullakuspalla riman. Chaymi diabloqa llullakuq runakunapa papan. ");
INSERT INTO qveNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Chayraykun qankunaqa cheqaqta rimashaqtiypas, noqapiqa mana creenkichishchu. ");
INSERT INTO qveNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Chayri, ¿mayqenniykichistaq qankuna ukhumanta acusawankichisman “huchayoqmi kanki” nisparí? Cheqaqta rimashaqtiyri, ¿imanaqtintaq qankunari noqapi mana creenkichishchú? ");
INSERT INTO qveNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Diospa wawankunaqa, Diospa palabrankunata uyarispan paypi creenku. Ichaqa manan qankunaqa Diospa palabrantaqa uyariyta munankichishchu, Diospa wawankuna mana kasqaykichisrayku. ");
INSERT INTO qveNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Israel nacionniyoq wakin runakunan Jesusta niranku khaynata: —Noqaykuqa allintan qantaqa nishaykiku, qanqa “Samaria llaqtayoq runakuna hinan millay runa kanki”, nispayku. Chaymi qantaqa demonio rimachishasunki, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Hinaqtinmi Jesusqa paykunata contestaspa, khaynata niran: —Noqaqa manan demonioyoq runachu kani. Aswanmi noqaqa hanaq pachapi Papaymanta allinta rimani. Qankunan ichaqa mana allinkunata noqamanta rimashankichis. ");
INSERT INTO qveNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Noqaqa manan munanichu huchasapa runakuna alabawanankutaqa. Hinaspapas noqaqa manan kikiypa munayniytachu mashkashani. Aswanqa Diosmi noqapi creeq runakuna alabawananta munan. Hinaspapas Diosmi llapallan runakunata juzgananpaq juezqa. ");
INSERT INTO qveNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Cheqaqtapunin niykichis, pipas noqapa yachachisqaykunata kasukunqa chayqa, wiñaypaqmi Dioswan hanaq pachapi kawsanqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Hinaqtinmi Israel nacionniyoq runakunaqa niranku: —Kunanmi ichaqa allinta yachayku demonio qanpi kasqanta. Ñawpaq abueloyku Abrahampas, hinallataq Diosmanta willakuq profetakunapas wañupurankun; ¿chaychu qanri ninki: “Pipas noqapa yachachisqaykunata kasukunqa chayqa, wiñaypaqmi kawsanqa”, nispaykí? ");
INSERT INTO qveNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Qanri, ¿wañuq abueloyku Abrahammantapas aswan más atiyniyoqchu kawaq? Abrahampas wañupunmá, hinallataq Diosmanta willakuq profetakunapas. Chayri, ¿pi kanaykipaqtaq qanri creekunkí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Hinaqtinmi Jesusqa paykunata contestaran khaynata: —Sichus noqa kikillaymanta alabakuspa rimayman chayqa, ¿imapaqtaq valewanman? Ichaqa Papaymi noqamantaqa allinta riman; paytan qankunapas ninkichis: “Diosniykun”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ichaqa qankunaqa manan Diostaqa reqsinkichishchu. Noqan ichaqa Papaytaqa reqsini hinallataq kasukuni ima. Sichus “manan Papaytaqa reqsinichu” nispa niyman chayqa, qankuna hina llullakuqmi kayman. Chayraykun niykichis, Papaytaqa cheqaqtapunin noqaqa reqsini. ");
INSERT INTO qveNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ñawpaq abueloykichis Abrahamqa anchatan kusikuran, kay pachaman huk p'unchaw hamunayta yachaspa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Saynata niqtinmi, Israel nacionniyoq runakunaqa Jesusta tapuranku: —Qanqa manaraqmi ni pishqa chunka watayoqpasraqchu kashankipas. ¿Chaychu qanri, Abrahamta reqsiwaq karan? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Hinaqtinmi Jesusqa paykunata niran: —Cheqaqtapunin qankunataqa niykichis, abueloykichis Abrahampas manaraq naceshaqtinmi, noqaqa ña karaniña, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Saynata Jesús niqtinmi, Israel nacionniyoq runakunaqa rumiwan p'anashaspalla Jesusta wañuchiyta munaranku. Chaymi Jesusqa disimulawlla runakunapa chawpinta templomanta huk lawman lloqsiruran. ");
INSERT INTO qveNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Templomanta lloqsiramuspan Jesusqa ñan risqanpi huk ñawsa runata rikururan. Chay runaqa nacesqanmantapachan ñawsa kasqa. ");
INSERT INTO qveNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Chaymi discipulonkunaqa Jesusta khaynata tapuranku: —Yachachikuq, kay runa ñawsa nacemunanpaqri, ¿mayqentaq huchallikunmanri karan, paychu icha tayta mamanchú? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Hinaqtinmi Jesusqa paykunata contestaspa niran: —Manan ni paychu nitaq tayta mamanpashchu huchallikuranqa. Aswanmi payqa sayna ñawsa naceran, saynapi chay ñawsa runata sanoyachiqtin Diospa atiyninta rikunaykichispaq. ");
INSERT INTO qveNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Chaymi noqaqa p'unchaw kallashaqtinraq, Papaypa kamachiwasqankunata ruwanay kashan. Tutayaramuqtinmi ichaqa manaña ni imatapas ruwaytaqa atisunmanñachu. ");
INSERT INTO qveNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ichaqa kay pachapi kanaykaman noqaqa llapallan runakunapaq huk k'anchay kasaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Saynata nispanmi Jesusqa allpa pampaman toqaruspa, toqayninwan barrota ruwaran. Hinaspan chay ñawsa runapa ñawinman chay barrowan llusiyuran. ");
INSERT INTO qveNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Hinaspan Jesusqa chay ñawsa runata niran: —Kunanyá riy; hinaspa Siloé sutiyoq estanquepi ñawiykita maqchikamuy, nispa. Chay Siloé sutiqa: “Mandasqa” ninantan nin. Chaymi chay ñawsa runaqa chay Siloé nisqa estanqueman rispa, ñawinta maqchikamuspa, rikustinña kutimuran. ");
INSERT INTO qveNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Hinaqtinmi vecinonkunapas, hinallataq payta reqsiq runakunapas tapunakuranku khaynata: —Kay runari, ¿manachu tiyayuspa limosnata mañakuq ñawsa runa? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Chaymi wakin runakunaqa niranku: —Arí, pay kikinmi, nispanku. Wakin runakunañataqmi niranku: —Manan paychu. Chay ñawsa runaman rikch'akuq runan, nispanku. Hinaqtinmi chay ñawsa kasqanmanta sanoyaq runaqa, yapa-yapamanta astawanraq niran: —Arí, chay ñawsa runaqa noqapunin karani, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Hinaqtinmi runakunaqa payta tapuranku: —Qanri, ¿imaynanpitaq manaña ñawsañachu kashankirí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Chaymi payqa contestaspa niran: —Jesús sutiyoq runan toqayninwan barrota ruwaspa ñawiyta llusiyuwaran. Hinaspanmi niwaran: “Siloé sutiyoq estanqueman rispayki, ñawiykita chaypi maqchikamuy”, nispa. Chaymi noqaqa rispay maqchikamurani. Hinaspan chaymantapacha kunanqa rikuni, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Hinaqtinmi chay runakunaqa kaqmanta chay sanoyaq runata tapuranku: —Kunanri, ¿maypitaq chay Jesús sutiyoq runari kashan? nispanku. Chaymi chay runaqa paykunata contestaspa niran: —Noqaqa manan yachanichu, maypichá kakunpas, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Chay ñawsa kasqanmanta sanoyaq runatan fariseo religionniyoq runakunapa kasqanman aparanku. ");
INSERT INTO qveNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Chay ñawsa runata Jesús toqayllanwan barrota ruwaspa sanoyachisqan p'unchawqa, samana p'unchawmi karan. ");
INSERT INTO qveNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Chaymi fariseo religionniyoq runakunaqa, khaynata tapuranku: —Kunanri, ¿imaynanpitaq ñawsa kasqaykimanta rikushankirí? nispanku. Hinaqtinmi chay sanoyaq runaqa contestaran khaynata: —Jesús sutiyoq runan barrota ruwaspa, ñawiyman llusiyuwaspa niwaran “maqchikamuy” nispa. Hinaqtinmi noqaqa maqchikamurani. Hinaspan noqaqa chay ratomantapacha rikuni, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Hinaqtinmi wakin fariseo religionniyoq runakunaqa niranku: —Chay runaqa manan Diosmantachu hamun. Chaymi payqa samana p'unchawtapas mana respetanchu, nispanku. Wakinñataqmi niranku: —Huchasapa runari, ¿khayna milagrokuna ruwaytari atinmanchú? nispanku. Chaymi paykunaqa acuerdopi mana kasqankurayku, mana entiendenakurankuchu. ");
INSERT INTO qveNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Hinaspan fariseo religionniyoq runakunaqa, chay sanoyaq runata, kaqmanta tapuranku: —Qanri, ¿ima ninkitaq ñawiyki sanoyachiq chay runamantarí? nispanku. Hinaqtinmi payqa contestaran: —Payqa Diosmanta willakuq huk profetan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ichaqa Israel nacionniyoq runakunapa jefenkunaqa, chay ñawsa runa sanoyaspa rikusqantaqa, manan creerankuchu. Chaymi paykunaqa tayta mamanta waqyachimuranku. ");
INSERT INTO qveNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Hinaspan paykunata khaynata tapuranku: —Kay runari, ¿qankunapa wawaykichishchú? Payri, ¿cheqaqtachu ñawsa naceran? Kunanri, ¿imaynanpitaq payri rikushan? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Hinaqtinmi chay sanoyaq runapa tayta mamanqa contestaranku khaynata: —Arí, payqa noqaykupa wawaykun. Chaymi yachayku, payqa ñawsa nacesqanta. ");
INSERT INTO qveNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ichaqa noqaykuqa manan yachaykuchu imaynanpis rikusqantaqa, nitaqmi yachaykupashchu ni pi sanoyachisqantapas. Aswanqa paytayá tapuychis. Chaypaqmi payqa yuyayniyoq runaña. Pay kikinchá willasunkichis, imaynanpi rikusqantapas, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Saynataqa niranku, Israel nacionniyoq runakunapa jefenkunata manchakuspankun. Ichaqa chay jefekunaqa ñan acordasqakuña, sichus pillapas: “Jesusqa Diosmanta Hamuq Salvadormi”, nispa niqkunataqa, Dios yupaychana sinagoga wasimanta qarqonankupaq. ");
INSERT INTO qveNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Chaymi chay sanoyaq runapa tayta mamanqa niranku: “Paytayá tapuychis. Chaypaqmi payqa yuyayniyoq runaña”, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Hinaqtinmi Israel nacionniyoq runakunapa jefenkunaqa, chay ñawsa kasqanmanta sanoyaq runata kaqmanta waqyachimuspa, niranku: —Diospa sutinpi, juramentota ruwaspa, ama llullakuspa, cheqaqtapuni niwayku. Noqaykuqa yachaykun, chay sanoyachisuqniyki runaqa, huchasapa runa kasqanta, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Hinaqtinmi payqa contestaspa niran: —Noqaqa manan yachanichu huchasapachus icha mana huchayoqchus kasqantaqa. Aswanmi noqaqa yachani ñawpaq ñawsa kasqayta, hinaspa kunan rikusqayta, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Saynata niqtinmi, chay Israel nacionniyoq runakunapa jefenkunaqa, tapuranku kaqmanta: —Ñawiyki rikunanpaqri, ¿imatataq chay runari ruwasurankí? ¿Imaynatapunitaq ñawiykikunatari sanoyachiran? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Hinaqtinmi chay runaqa contestaspa niran: —Noqaqa ñan qankunamanqa willaraykichishña imayna sanoyachiwasqantaqa. Ichaqa qankunaqa manan uyariwankichishchu. ¿Imapaqtaq yapamanta willanaytari munashankichís? Icha, ¿qankunapas discipulonkunachu kayta munashankichís? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Saynata niqtinmi, Israel nacionniyoq runakunapa jefenkunaqa k'amispa, khaynata niranku: —Chay runapa discipulonqa, ¡qanpashchá kanki! Noqaykuqa Moisespa escribisqan leykunata kasukuq runakunan kayku. ");
INSERT INTO qveNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Hinaspapas noqaykuqa yachaykun Moisesta Dios parlapayamusqanta. Ichaqa chay Jesús runamantaqa manan ni imatapas, nitaq ni maymanta kasqantapas yachaykuchu, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Chaymi chay sanoyaq runaqa paykunata, khaynata niran: —Qankunari, ¿imaynanpitaq mana yachawaqchishchu chay runa maymanta hamusqanta, hinallataq noqata sanoyachiwasqantarí? ¡Chayqa ancha admirakuypaqmá! ");
INSERT INTO qveNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Hinaspapas noqanchisqa yachanchismi, huchasapa runakunapa mañakusqanta, Dios mana uyarisqantaqa. Aswanmi Diosqa payta kasukuqkunallata, hinallataq munasqanman hina ruwaqkunallata uyarin. ");
INSERT INTO qveNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Hinaspapas noqanchisqa manan ni hayk'aqpas uyariranchishchu ni pitapas, nacesqanmantapacha ñawsa runata pipas sanoyachisqanmantaqa. ");
INSERT INTO qveNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Sichus chay sanoyachiwaqniy runa, mana Diosmantachu hamunman chayqa, manachá ni ima ruwaytapas atinmanchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Hinaqtinmi Israel nacionniyoq runakunapa jefenkunaqa niranku: —Qanqa nacesqaykimantapachan huchasapa kanki. ¿Chaychu noqaykutari yachachiwankikuman? nispanku. Saynata niruspankun, chay sanoyaq runataqa chay sinagoga wasimanta qarqoranku. ");
INSERT INTO qveNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesusqa chay sanoyachisqan runata, sinagoga wasimanta qarqomusqankutan yacharuran. Hinaspan paywan tuparuspa, khaynata tapuran: —Qanri, ¿Diosmanta Hamuq Runapiri creenkichú? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Chaymi payqa contestaspa niran: —Señor, ¿pitaq chay runari, niykuwayá noqa paypi creenaypaq? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Hinaqtinmi Jesusqa chay runata niran: —Rikushankin. Noqan chay runaqa kashani. Pay kikinwanmi parlashankipas, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Chaymi chay runaqa Jesuspa ñawpaqninpi qonqorikuspa, payta alabaspa, niran: —Señorlláy, creenin qanpi, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Hinaqtinmi Jesusqa niran: —Noqan kay pachaman hamurani llapallan runakunata juzganaypaq, ñawsakunata rikuchinaypaq, hinallataq rikuqkunatapas ñawsa hinaman tukuchinaypaq, saynapi paykuna rikushaspankupas, ama rikunankupaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Hinaqtinmi wakin fariseo religionniyoq runakunaqa, Jesuspa rimasqanta uyariruspanku, khaynata niranku: —¿Ima ninkin? ¿Qanpa rimasqaykiman hinachu noqaykupas ñawsa kashaykú? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Chaymi Jesusqa paykunata contestaran: —Sichus qankuna yachakuwaqchis ñawsa hina kasqaykichista chayqa, mana huchayoqchá kawaqchis. Ichaqa ñawsa hina kasqaykichista mana yachakusqaykichisraykun, huchallaykichispi kawsashankichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesusmi niran: —Cheqaqtapunin niykichis, pipas ovejapa corralninman punkunta mana haykuspa, aswan cerconta haykuqqa, suwa runan, hinallataq salteador ima. ");
INSERT INTO qveNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ichaqa ovejakunata michiq runaqa, punkuntan corralmanqa haykun. ");
INSERT INTO qveNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Chaymi punkuta cuidaq runaqa, ovejakuna haykunanpaq punkuta kichan. Hinaspan dueñonqa ovejankunata sutinmantakama waqyan. Chaymi ovejankunaqa dueñonpa vozninta reqsispa, qepanta qatikunku. ");
INSERT INTO qveNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Oveja michiqqa, corralmanta ovejankunata qarqoruspanmi, pastoman pusananpaq ovejankunapa ñawpaqninta rin. Ovejankunataqmi michiqpa vozninta reqsisqankurayku, payta qatikunku. ");
INSERT INTO qveNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ichaqa huk extraño runataqa, manan chay ovejakunaqa qatikunmanchu, aswanmi ishkapakunku, vozninta mana reqsisqankurayku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesusqa chay willakuytan fariseo religionniyoq runakunaman willaran. Ichaqa manataqmi paykunaqa ima ninantas nin chaytaqa entienderankuchu. Nota: Israel nación llaqtapiqa, oveja michiqqa ovejankunapa ñawpaqnintan rin, saynan asta kunankamapas. ");
INSERT INTO qveNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jesusmi yapamanta niran: —Cheqaqtapunin niykichis, corralman ovejakunapa haykunan punkuqa, noqa kikiymi kani. ");
INSERT INTO qveNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ichaqa noqapa ñawpaqniyta hamuq falso profeta runakunaqa, salteador suwa runakuna hinan karanku. Chaymi ovejaykunaqa paykunata mana kasukurankuchu. ");
INSERT INTO qveNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Noqan kani punkuqa. Pipas noqanta haykuqqa, salvasqan kanqa. Chaymi pipas noqapi creeqqa, chay oveja hina corralman haykunqa, seguro kananpaq; hinallataq corralmantapas lloqsinqa, allin pastota tarinanpaq. ");
INSERT INTO qveNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Suwa runaqa hamun suwakunanpaq, wañuchinanpaq, hinallataq mana imaman tukuchinanpaq iman. Noqan ichaqa hamurani, pipas noqapi creespa wiñaypaq kawsanankupaq, hinallataq t'ikarishaq hina kanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Noqan ovejakunata allin michiqqa kani. Chaymi noqaqa vidayta qospa wañusaq, ovejaykunata salvanaypaq. ");
INSERT INTO qveNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ichaqa pagoraykulla ovejakuna michipakuqqa, manan allintachu michin, ovejakuna paypa mana kasqanrayku. Chaymi chay pagoraykulla ovejakunata michipakuqqa, atoqña otaq ima animalña hamuqtinpas, ovejakunata dejarpatamuspa ayqekun. Hinaqtinmi chay atoqqa ovejakunata ch'eqechin. ");
INSERT INTO qveNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Chaymi pagoraykulla michipakuqqa ayqekun, ovejakuna paypa mana kasqanrayku. Saynataqa ruwan payman mana ni imapas qokusqanraykun. ");
INSERT INTO qveNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Noqan ovejakunata allin michiqqa kani. Chaymi noqaqa ovejaykunata allinta reqsini. Saynallataqmi paykunapas noqataqa allinta reqsiwanku. ");
INSERT INTO qveNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Imaynan Papaypas noqata reqsiwan, saynallataqmi noqapas Papaytaqa reqsini. Chaymi noqaqa ovejaykunata salvanaypaq wañusaq. ");
INSERT INTO qveNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Noqapaqa kashanmi huk ovejaykunapas. Paykunaqa manan kay corralmantachu kanku. Paykunatapas kay corralmanmi apamunaypuni kashan, huk corrallapiña kanankupaq. Chaymi paykunapas vozniyta uyarinqaku; hinallataqmi michiqninpas noqa kasaq. ");
INSERT INTO qveNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Noqaqa ovejaykunaraykun wañusaq, hinaspan kawsarimusaq. Chayraykun Papayqa noqata munakuwan. ");
INSERT INTO qveNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Manan pipas noqapa vidaytaqa qechuwanmanchu. Aswanmi noqaqa kikillay vidayta qosaq. Hinaspapas noqaqa atiyniyoqmi wañunaypaq, hinallataq kawsarimunaypaqpas kani. Chaytan Dios Taytayqa ordenawaran ruwanaypaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jesuspa rimasqanta uyarispankun, Israel nacionniyoq runakunaqa kaqmanta mana acuerdopichu karanku. ");
INSERT INTO qveNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Chaymi wakin runakunaqa niranku: —Kay runaqa demoniopa kamachisqanmi locoyarun. Chayri, ¿imapaqtaq paypa rimasqantari kasusunman? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Wakin kaq runakunañataqmi khaynata niranku: —Sichus pipas demoniopa kamachisqan kaspaqa, manan khayna sumaqllatañaqa rimanmanchu. Hinaspapas ñawsa runakunataqa manan ni mayqen demoniopas sanoyachiytaqa atinmanchu, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jesusqa paray tiempo kashaqtinmi, Jerusalén llaqtapi templopa aniversarion fiestaman riran. ");
INSERT INTO qveNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Hinaspan Jesusqa templopiña kashaspa, Salomonpa corredornin nisqanku lugarpi purisharan. ");
INSERT INTO qveNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Hinaqtinmi Israel nacionniyoq runakunaqa Jesusman ashuyuspanku, khaynata tapuranku: —Qanri, ¿hayk'aqkamataq noqaykutari ishkayachiwankikú? Diosmanta Hamuq Salvadorniyku kaspaqa, ¡cheqaqtayá niwayku! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Saynata tapuqtinkun Jesusqa contestaran khaynata: —Noqaqa ñan niraykichishña pis kasqayta. Qankunan ichaqa mana creewankichishchu. Noqaqa tukuy imatapas Papaypa atiyninwanmi ruwani. Chay ruwasqaykunan pi kasqaymantaqa willakushan. ");
INSERT INTO qveNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ichaqa qankunaqa kay nisqaykunataqa manan creenkichishchu, nitaqmi kasukunkichispashchu, ovejaykuna mana kasqaykichisrayku. ");
INSERT INTO qveNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Noqapa ovejaykunaqa vozniytan uyarinku. Saynallataqmi noqapas ovejaykunata reqsini. Hinaqtinmi ovejaykunapas qepayta qatikuwanku. ");
INSERT INTO qveNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Chaymi noqaqa ovejaykunaman wiñay kawsayta qoni. Chayraykun paykunaqa mana ni hayk'aqpas infiernomanqa chinkasqa kanankupaqqa rinqakuchu. Hinaspapas paykunataqa manan ni pipas makiymantaqa qechuwanqachu. ");
INSERT INTO qveNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Hanaq pachapi Papaymi ovejaykunataqa qowaran. Paymi llapanmantapas aswan más atiyniyoq. Chaymi Papaypa makinmantaqa mana ni pipas paykunataqa qechunqachu. ");
INSERT INTO qveNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ichaqa Papaywan noqawanqa hukllan kayku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Saynata Jesús rimaqtinmi, Israel nacionniyoq runakunapa jefenkunaqa, rumita oqarikuspanku, kaqmanta p'anayta munaranku. ");
INSERT INTO qveNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Hinaqtinmi Jesusqa paykunata niran: —Qankuna rikushaqtiykichismi, Papaypa atiy qowasqanwan tukuy allin kaqkunata ruwarani. Chayri, ¿mayqen ruwasqaymantataq rumiwan p'anaspa wañuchiwaytari munashankichís? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Hinaqtinmi chay jefekunaqa Jesusta contestaranku: —Manan allin kaqkuna ruwasqaykimantachu wañuchiytaqa munaykiku, aswanqa Diospa contranpi rimasqaykimantan, hinallataq runalla kashaspayki “Dios kani” nisqaykimantan, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Hinaqtinmi Jesusqa paykunata kaqmanta nillarantaq: —Moisesmi leykunata escribispa saqesurankichis. Chay leypin nishan khaynata: “Noqan niykichis, qankunaqa dioskunan kashankichis”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Sichus “dioskunan kashankichis” niran Diospa palabranta uyariq runakunata chayqa, yachanaykichismi Bibliaqa cheqaq kasqanta. ");
INSERT INTO qveNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Noqataqa Papaymi mandamuwaran. Chaymi noqaqa niraykichis “Diospa Wawanmi kani”, nispa. Chayri, ¿imanaqtintaq qankunari niwankichis, saynata rimaspaqa “Diostan k'amishan”, nispaykichisrí? ");
INSERT INTO qveNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Sichus mana Papaypa kamachisqanman hinachu imatapas ruwashani chayqa, ama creewaychishchu. ");
INSERT INTO qveNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ichaqa sichus Papaypa kamachiwasqanta kasukuspa ruwashani chayqa, noqata amaña creewaspapas, ruwasqayta rikuspaykichisyá creewaychis. Chaymi qankunaqa yachankichis, noqaqa Papaywan huklla kasqayta, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Chaykunata rimaqtinmi, Jesustaqa presochanankupaq, kaqmanta hap'iyta munaranku. Ichaqa paykunapa makinkumantañan Jesusqa ishkapatakamuran. ");
INSERT INTO qveNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Hinaspan Jesusqa Jordán mayuta chimpaspa, Juanpa ñawpaq bautizasqan lugarman kutiran. Chaypi qepakuspa kashaqtinmi, ");
INSERT INTO qveNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ashka runakuna Jesuspa kasqanman riranku. Hinaspan paykunaqa ninakuranku khaynata: —Bautizaq Juanqa manan ni ima milagrotapas ruwaranchu. Ichaqa Jesusmanta Bautizaq Juanpa tukuy ima rimasqanqa cheqaqpunin kasqa, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Chaypin ashka runakuna Jesuspi creeranku. ");
INSERT INTO qveNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Lázaro runan onqosqa kasharan. Paymi Betania llaqtayoq karan. Hinaspan chay llaqtapi hermanan Martawan, hinallataq hermanan Mariapiwan ima kushka tiyaranku. ");
INSERT INTO qveNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Kay Lazaropa hermanan Marian karan, Jesusman rispa, huk sumaq mishk'i q'apaq perfumewan Jesuspa chakinkunaman hich'ayuspa, chukchanwan ch'akichiqqa. ");
INSERT INTO qveNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lazaropa hermanankunaqa huk runatan Jesusman mandaranku, khaynata nimunanpaq: —Señor, khuyakusqayki amigoyki Lázaron onqosqa kashan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Hinaqtinmi Jesusqa chay willakusqanta uyarispa niran: —Chay onqoyqa manan wañuchinqachu. Aswanmi chay onqoyqa Diospa atiyninta hinallataq noqa Wawanpa atiyniytapas runakuna rikunankupaq kanqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesusqa anchatan khuyakuran Lazarota, Martata hinallataq Mariatapas. ");
INSERT INTO qveNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ichaqa Lazaropa onqosqanta willashaqtinkupas, Jesusqa chay kasqan lugarpin ishkay p'unchawtawanraq qepakuran. ");
INSERT INTO qveNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Chay ishkay p'unchaw pasaruqtinñan, Jesusqa discipulonkunata niran: —Judea provincia lawman hakuchi kutisunchis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Chaymi discipulonkunaqa Jesusta niranku: —Yachachikuq, qayninpa p'unchawkunallan chay Judea provincia lawpi tiyaq Israel nacionniyoq runakunaqa wañuchiyta munashasurankiku. ¿Chaychu kunanri chay Judea provincia lawman kutiyta munashankí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Hinaqtinmi Jesusqa paykunata contestaran: —P'unchawqa chunka ishkayniyoq horasniyoqmi. Chaymi pipas p'unchawpi purispaqa, p'unchawraq kasqanrayku mana ni imapipas urmanqachu. ");
INSERT INTO qveNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Tuta puriqmi ichaqa tutayaqpi purisqanrayku laq'apakuspa urman, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Chaykunata rimaruspanmi, Jesusqa niran: —Amigonchis Lazaroqa puñullashanmi. Chaymi kunan rispay rikch'arichimusaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Hinaqtinmi discipulonkunaqa niranku: —Señorlláy, puñullashantaq chayqa, Lazaroqa sanoyanqachá riki, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesusqa Lázaro wañusqanta yachaspanmi saynataqa niran. Ichaqa discipulonkunaqa Lázaro cheqaqta puñunallanpaqmi piensaranku. ");
INSERT INTO qveNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Chaymi Jesusqa discipulonkunata clarota niran: —Lazaroqa wañurunñan. ");
INSERT INTO qveNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ichaqa qankunaraykun noqaqa chaypi mana kasqaywan anchata kusikuni. Kunanmi qankunaqa aswan mastaraq noqapi creenkichis. Saynaqa hakuchiyá Lazaropa kasqanman, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Hinaqtinmi Mellizowan sutichasqa discipulon Tomasqa, wakin discipulokunata niran: —Noqanchispas Jesuswan kushka wañunanchispaq hakuchi, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jesusqa Betania llaqtaman chayaruspanmi, Lazarota tariran sepulturapi tawa p'unchaw p'ampasqataña. ");
INSERT INTO qveNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania llaqtaqa Jerusalén llaqtamanta kinsa kilómetro hina puriyllapin karan. ");
INSERT INTO qveNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Chaymi Israel nacionniyoq ashka runakunaqa, Lazaropa wañusqanmanta consuelanankupaq, Martapa hinallataq Mariapa tiyasqanku wasiman riranku. ");
INSERT INTO qveNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Hinaqtinmi Martaqa chay llaqtaman Jesús chayamusqanta yacharuspa, wasimanta lloqsispa, Jesusta chashkiq riran. Mariañataqmi ichaqa wasillapi qepakuran. ");
INSERT INTO qveNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Chaymi Martaqa Jesusta tarispa niran: —Señorlláy, sichus qan kaypi kawaq karan chayqa, hermanoyqa manan wañunmanchu karan. ");
INSERT INTO qveNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ichaqa noqaqa yachanin, sichus Diosmanta kunan mañakuqtiykiqa, Diosqa tukuy ima mañakusqaykitapas qosunkin, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Saynata niqtinmi, Jesusqa Martata niran: —Hermanoykiqa kawsarinpullanqan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Chaymi Martaqa niran: —Arí, noqaqa yachanin, juicio p'unchaw chayamuqtin, llapan wañuqkuna, hinallataq hermanoypas kawsarimunantaqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Hinaqtinmi Jesusqa niran: —Noqan kani kawsay qoqqa, hinallataq wañusqakunata kaqmanta kawsarichiqpas. Pipas noqapi creeqqa wañusqaña kashaspapas kawsarinpunqan. ");
INSERT INTO qveNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Pipas kawsashaspallaraq noqapi creeqqa, manan wiñaypaqchu wañunqa; aswanmi wiñaypaq kawsanqa. ¿Kay nisqayta qan creenkichú? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Chaymi Martaqa niran: —Arí, Señor, noqaqa creenin, qanqa Diospa Wawan kay pachaman Hamuq Salvadorniyku kasqaykita, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Chaykunata parlaruspanmi, Martaqa hermanan Mariata waqyaspa, secretollapi niran: —Yachachikuqmi chayaramun. Hinaspan qanta waqyashasunki, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Chaymi Mariaqa Martapa nisqanta uyarispa hinalla, Jesuspa kasqanman apurayllaman riran. ");
INSERT INTO qveNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ichaqa Martapa hinallataq Mariapa tiyasqanku wasimanqa, Jesusqa manaraqmi chayamuranraqchu. Aswanmi Jesusqa Martawan tupasqan lugarllapiraq kasharan. ");
INSERT INTO qveNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Hinaqtinmi Israel nacionniyoq llaqtamasin runakunaqa Mariata consuelaspa kashaqtinku, Mariaqa apurayllaman sayarispa lloqsitamuran. Chayta rikuspankun chay Israel nacionniyoq runakunaqa piensaranku, Mariaqa hermanon Lazaropa sepulturanman waqaq rinanpaq. Chaymi paykunapas qepanta riranku. ");
INSERT INTO qveNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Hinaqtinmi Mariaqa Jesuspa kasqanman chayaruspa, Jesuspa ñawpaqninpi qonqoriyukuspa, khaynata niran: —Señorlláy, sichus kaypi kawaq karan chayqa, hermanoyqa manan wañunmanchu karan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Chaymi Jesusqa Mariapa waqasqanta, hinallataq Israel nacionniyoq runakunapas paywan kushka waqasqankuta rikuspan, anchata llakirikuran. ");
INSERT INTO qveNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Hinaspan Jesusqa paykunata tapuran: —Qankunari, ¿maypitaq Lazarotari p'amparamurankichís? nispa. Hinaqtinmi paykunaqa contestaspa niranku: —Señor, hakuchiyá qawamunaykipaq; hinaspa maypi p'ampamusqaykuta rikumuy, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Hinaqtinmi Jesusqa waqaran. ");
INSERT INTO qveNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Chay waqasqanta rikuspankutaqmi, chaypi kaq Israel nacionniyoq runakunaqa ninakuranku khaynata: —¡Qawariychis! ¡Jesusqa anchatapunin Lazarotaqa munakusqa! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ichaqa wakin runakunañataqmi niranku: —Kay runaqa ñawsa runatapas qawarichiranmi. Chaychu, ¿imallatapas mana ruwayta atinman karan, Lázaro ama wañunanpaqrí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesusqa kaqmanta anchata llakikuspanmi, Lazaropa sepulturanman ashuyuran. Chay sepulturaqa qaqa sikipin huk hatun mach'ay hina karan. Hinallataqmi punkunpas huk hatun rumiwan tapasqa karan. ");
INSERT INTO qveNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Hinaspan Jesusqa chaypi kaq runakunata niran: —Chay sepulturapa punkunpi rumita ayqechiychis, nispa. Hinaqtinmi wañuq Lazaropa hermanan Martaqa niran: —Señorlláy, wañusqanmantaqa tawa p'unchawñan pasarun. Chayqa ñachá kunankamaqa nishutaña asnarirun, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Chaymi Jesusqa niran: —Ñan noqaqa niraykiña, “sichus noqapi creenki chayqa, Diospa atiynintan rikunki”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Hinaqtinmi runakunaqa sepultura tapaq rumita huk lawman ayqechiranku. Hinaqtinmi Jesusqa hanaq pachata qawarispa niran: —Dios Taytáy, uyariwasqaykimantan graciasta qoyki. ");
INSERT INTO qveNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Hinaspapas noqaqa yachanin tukuy tiempo uyariwasqaykitaqa. Ichaqa kunanmi kay runakunapa ñawpaqninpi graciasta qoyki, noqata mandamuwasqaykipi paykuna creenankupaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Saynata rimaruspanmi, Jesusqa altota rimaspa, khaynata niran: —¡Lázaro, chaymanta lloqsimuy! nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Chaymi wañuq Lazaroqa kasqan ratolla chay sepulturamanta lloqsimuran, makinpas hinallataq chakinkunapas hatun telamanta ruwasqa vendakunawan alli-allin p'istusqa; hinallataq uyanpas huk hatun pañuelowan hina p'istusqa. Hinaqtinmi Jesusqa chaypi kaq runakunata niran: —Chay vendakunata pashkaychis purinanpaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mariata consuelanankupaq riq ashka runakunaqa, Lazarota Jesús kawsarichisqanta rikuspankun, Jesuspi creeranku. ");
INSERT INTO qveNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ichaqa wakin runakunañataqmi, fariseo religionniyoq runakunaman Jesuspa chaykuna ruwasqanmanta willamuq riranku. ");
INSERT INTO qveNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Hinaqtinmi sacerdotekunapa jefenkunaqa, hinallataq fariseo religionniyoq runakunapiwan ima huk hatun asambleapi huñunakuranku. Hinaspan chaypi tapunakuranku khaynata: —¿Imatataq ruwasun chay runawanrí? Chay runaqa nishutañan milagrokunata ruwashan. ");
INSERT INTO qveNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Sichus hinallata dejasun chayqa, llapallan runakuna paypi creespankun, Roma llaqtapi autoridadkunapa contranpi hatarinqaku. Hinaqtinmi Roma llaqtayoq autoridadkuna soldadokunantin hamuspanku, kay Jerusalén llaqtapi templonchista thuñichinqaku, hinallataq kay Israel nacionninchistapas chinkachinqaku, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ichaqa chay watapin Israel templopi serviq sacerdotekunapa jefen Caifás sutiyoq runa karan. Paymi niran: —Qankunaqa manan ni imatapas yachankichishchu, ");
INSERT INTO qveNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","nitaqmi allintaqa ni imatapas entiendenkichishchu. Aswan allinmi kanman huk runalla kay llaqtanchista salvananrayku wañuqtinqa, aswan enteron nacionninchis, mana imaman tukunanmantaqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Chaytaqa chay sacerdotekunapa jefen Caifasqa manan kikillanmantachu rimaran. Aswanmi kikin Diospuni sacerdotekunapa jefen kasqanrayku paytaqa rimachiran, saynapi Jesusqa Israel nacionpi runakunata salvananrayku wañunanmanta ninanpaq. ");
INSERT INTO qveNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Hinaspapas Jesusqa manan Israel nacionpi runakunaraykullachu wañunan karan. Aswanqa enteron mundontinpi Diospa ch'eqesqa wawankunata hukllaman huñunanpaqmi. ");
INSERT INTO qveNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Chaymi chay p'unchawmantapacha Israel nacionniyoq runakunapa jefenkunaqa acuerdoman haykuranku, Jesusta wañuchinankupaq. ");
INSERT INTO qveNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Chayraykun Jesusqa mana alayritañachu puriran, Israel nacionniyoq runakunapa jefenkuna ama rikunanpaq. Aswanmi Jesusqa Judea provincia lawmanta lloqsispa, Efraín sutiyoq llaqtaman riran. Hinaspan discipulonkunawan kushka chaypi qepakuran. ");
INSERT INTO qveNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Chay p'unchawkunapin Israel nacionniyoq runakunapa Pascua fiesta ruwananku p'unchaw ña chayamusharanña. Chaymi ashka runakuna chay Pascua fiesta p'unchaw manaraq chayamushaqtin, Jerusalén llaqtaman riranku, huchankumanta chaypi perdonasqa kanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Chaymi runakunaqa Jesusta mashkaranku. Hinaspan temploman chayaruspanku, paykunaqa tapunakuranku khaynata: —Qankunari, ¿ima ninkichistaq? Chay Jesusri, ¿hamunqachu icha manachu kay fiestaman? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Hinaqtinmi fariseo religionniyoq runakunaqa, Israel templopi serviq sacerdotekunapa jefenkunapiwan ima, llaqtamasin runakunata, khaynata kamachiranku: —Sichus pipas rikunqa otaq yachanqa chay Jesusqa maypis kasqanta chayqa, noqaykuman willakuq hamuchunku, saynapi noqayku payta hap'ispa presochanaykupaq, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pascua Fiestapaq soqta p'unchawraq faltashaqtinmi, Jesusqa Lazaropa tiyasqan Betania llaqtaman riran. Chay llaqtapin Lazarota wañusqanmanta ñawpaqtaraq kawsarichiran. ");
INSERT INTO qveNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Hinaqtinmi Jesuspaq mikhunata chaypi ruwachiranku. Chaypin Jesusqa Lazaropiwan, hinallataq huk runakunapiwan ima, mesapi kushka mikhunankupaq tiyayuranku. Lazaropa hermanan Martañataqmi, mikhunata servimuran. ");
INSERT INTO qveNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Hinaqtinmi (Martapa hermanan) Mariaqa, huk sinchi precioyoq sumaq q'apaq perfumeta medio litro hinata orqomuspa apamuran. Chay perfumeqa nardo sutiyoq plantapa q'apayninmanta ruwasqan karan. Chaywanmi Jesuspa chakinkunaman llusiyuspa, chukchallanwan ch'akichiran. Hinaqtinmi chay perfumepa sumaq q'apayninqa enteron wasi ukhupi hunt'ayuran. ");
INSERT INTO qveNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Chayta rikuspan, Jesusta traicionananpaq kaq discipulon Judas Iscarioteqa, khaynata niran: ");
INSERT INTO qveNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Kay sumaq q'apaq perfumetari, ¿imanaqtintaq aswan mana venderanchishchú? Kay perfumeqa kinsa pachaq p'unchaw jornal qolqepa valorninmi. Hinaspapas sayna ashka qolqewanqa, wakchakunatan yanapasunman karan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas Iscarioteqa manan wakchakunata khuyapayasqanraykuchu saynataqa niran, aswanqa suwakuy mañayoq kasqanraykun. Chay Judasqa Jesuspa, hinallataq discipulonkunapa qolqenkutan bolsapi hap'iran. Hinaspan chay waqaychasqan qolqeta sapa kutin suwakuran. ");
INSERT INTO qveNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Hinaqtinmi Jesusqa chay Judas Iscarioteta niran: —Ama hark'akuychu, chakiyta kay warmi chay perfumewan llusiwanantaqa. Payqa p'ampawananku p'unchawpaqmi kay perfumetaqa waqaychasharan. ");
INSERT INTO qveNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Wakchakunaqa sapa p'unchawmi qankunawan kanqa. Noqan ichaqa mana sapa p'unchawchu qankunawan kasaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jesusqa Betania llaqtapin kasharan. Chaytan Jerusalén llaqtapi tiyaq Israel nacionniyoq runakunaqa yacharuranku. Hinaspan paykunaqa, Jesusta hinallataq wañusqanmanta kawsarichisqan Lazarotawan qawaq, Betania llaqtaman riranku. ");
INSERT INTO qveNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Chaymi sacerdotekunapa jefenkunaqa, Lazarotapas wañuchinankupaq acordaranku. ");
INSERT INTO qveNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Saynataqa acordaranku, ashka runakuna paykunamanta t'aqakuspa, Jesuspi creesqankuraykun. Runakunaqa Jesuspiqa creeranku, Lazarota Jesús kawsarichimusqanraykun. ");
INSERT INTO qveNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Paqarisnintin p'unchawmi Jerusalén llaqtapi Pascua fiestaman riq ashkallaña runakunaqa Jesuspa hamunanta yacharuranku. ");
INSERT INTO qveNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Hinaspan palmerapa ramankunata apayukuspa Jesusta chashkinankupaq riranku. Hinaspan chay llapallan runakunaqa altota qaparispa niranku: —¡Diospa sutinpi hamuqqa, alabasqayá kachun! ¡Israel nacionninchispa Reyninqa, bendecisqayá kachun! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Chaykuna pasashaqtinmi, Jesusqa huk asnochata tarispa, chay asnochapi montakuran, Bibliapi nisqanman hina. Bibliapin nishan: ");
INSERT INTO qveNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“¡Jerusalén llaqtapi tiyaq runakuna, ama manchakuychishchu. Reyniykichismi hamushan, huk asnochapi montayukuspa!” nispa Zacarías 9.9. ");
INSERT INTO qveNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Jesuspa discipulonkunaqa chay ratopiqa manan entienderankuchu chaykuna pasasqanmantaqa. Ichaqa hanaq pachaman Jesuspa ripusqanpa qepanmanñan, chayraq discipulonkunaqa chaykuna pasasqanmanta yuyarispa entienderanku. Hinaspan yuyariranku, Jesusmanta Bibliapi sayna rimasqanta, hinallataq paymanta chaykunaqa escribisqa kasqanmantawan ima. ");
INSERT INTO qveNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ashka runakunan karanku, Lazarota Jesús kawsarichimusqan ratopiqa. Paykunan runakunaman chay rikusqankumanta willakuranku. ");
INSERT INTO qveNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Chaymi runakunaqa chay milagro ruwamusqanta yachaspanku, Jesusman tariparanku. ");
INSERT INTO qveNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Hinaqtinmi fariseo religionniyoq runakunaqa, khaynata ninakuranku: —¡Qawariychis! Manan ni ima ruwaytapas atisunmanchu; llapallan runakunan paypi creespa qepanta rishanku, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Pascua fiestapi adoranankupaq hamuq runakunamanta wakinmi, Grecia nación lawmanta karanku. ");
INSERT INTO qveNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Hinaspan paykunaqa Jesuspa discipulon Felipeman ashuyuranku. Payqa Galilea provincia law ukhupi Betsaida sutiyoq llaqtamantan karan. Paytan ruegakuranku khaynata: —Señor, Jesustan rikuyta munayku, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Chaymi Felipeqa Andresman willaq riran. Hinaspan ishkayninkuña Jesusman rispanku willaranku. ");
INSERT INTO qveNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Hinaqtinmi Jesusqa khaynata niran: —Tiempoqa ñan chayaramunña, noqa Diosmanta Hamuq Runa, pis kasqayta llapallan runakuna yachaspa, noqata hatunchawanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Chaymi qankunaman cheqaqtapuni niykichis, qankunaqa yachankichismi: Trigo t'akasqaykichis allpawan p'ampasqa kaspaqa, wiñamunqan; hinaspan allinta rurunqa. Ichaqa sichus chay trigo allpapa hawallanpi kaspaqa, manan wiñanqachu rurunanpaqqa. ");
INSERT INTO qveNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Saynallataqmi pipas kay pachapi payllapaq kawsay munaqqa, wiñaypaqmi wañunqa. Ichaqa pipas noqapi creesqanrayku wañuqmi, wiña-wiñaypaq kawsanqa. ");
INSERT INTO qveNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Saynallataqmi sichus pipas serviwananpaq qatikuwayta munaspaqa, noqatan kasukunan. Chaymi noqata serviwaqniy runaqa, may kasqaypi kanqa. Saynallataqmi paymanqa Dios Taytaypas premionta qopunqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jesusmi khaynata niran: —¡Kay ratopin noqaqa ancha llakisqa kashani! Chayri, ¿ima niymantaq? Icha, ¿Papáy, libraykuway kay ratopi ñak'ariykunamanta, nispachu nisaq? ¡Manan! ¡Noqaqa ñak'arispa runakunata salvanaypaqmi hamurani! ");
INSERT INTO qveNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Saynaqa Dios Taytáy, kay pachapi runakunamanyá atiyniykita rikuchiy, nispa. Hinaqtinmi hanaq pachamanta Dios Taytanqa nimuran: —Ñan atiyniytaqa rikuchiniña; ichaqa huktawanpas rikuchisaqmi, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Hinaqtinmi chaypi kaq runakunaqa, Dios Taytapa nimusqanta uyarispa niranku: —Rayon t'oqyamushan, nispanku. Ichaqa wakinñataqmi niranku: —Huk angelmi Jesustaqa rimapayamushan, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Chaymi Jesusqa paykunata niran: —Kaykuna uyarisqaykichisqa manan noqaraykuchu, aswanqa qankuna noqapi creenaykichispaqmi. ");
INSERT INTO qveNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ichaqa kay pachapi huchallapi kawsaq llapallan runakuna juzgasqa kanankupaqmi, ña tiempoqa chayaramunña. Hinaqtinmi kay pachata gobiernaq diablopas, qarqosqa kanqa. ");
INSERT INTO qveNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ichaqa cruzpi chakataspa wañuchiwaqtinkun, noqaqa llapallan nacionkunamanta runakunata pusamusaq, noqaman hamuspanku, noqapi creenankupaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Saynata nispanmi, Jesusqa entiendechiran imaynan wañunanmanta. ");
INSERT INTO qveNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Chaymi runakunaqa Jesusta khaynata tapuranku: —Noqaykuqa yachaykun Bibliapi khayna escribisqa kasqanta: “Diosmanta Hamuq Salvadorqa wiñaypaqmi kawsanqa”, nisqanta. Chayri, ¿imanaqtintaq qanri ninki: “Diosmanta Hamuq Runaqa chakatasqan wañunqa”, nispaykirí? Sayna kaqtinri, ¿pitaq chay Diosmanta Hamuq Salvadorqa? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Chaymi Jesusqa niran: —(Noqan Diosmanta Hamuq K'anchayqa kani). Ichaqa kay K'anchayniyqa chikan tiempollañan qankunawanqa kanqa. Saynaqa noqapa K'anchayniypiyá puriychis, chay K'anchayniy qankunawan kallashaqtinraq. Saynapin tutayaqqa mana sorprendesunkichishchu. Ichaqa pipas tutayaqpi puriqqa, manan yachanchu mayman risqantapas. ");
INSERT INTO qveNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Qankunawanraq noqa K'anchay kashaqtiyqa, noqapiyá creeychis, saynapi K'anchaypi puriq wawaykuna kanaykichispaq, nispa. Chaykunata niruspanmi Jesusqa, runakunapa ladonmanta ripuspa, manaña alayritañachu puriran. ");
INSERT INTO qveNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesusqa ashka milagrokunata Israel nacionniyoq runakunapa ñawpaqninpi ruwashaqtinpas, Jesuspiqa manan creerankuchu. ");
INSERT INTO qveNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Saynapin cumplikuran Diosmanta willakuq profeta Isaiaspa khayna escribisqan: “Señorlláy, willakusqaykutari, ¿pitaq creeran? Manan pipas creenchu. Señorlláy, ¿pimantaq atiyniykitari rikuchirankí?” nispa Isaías 53.1. ");
INSERT INTO qveNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Chayraykun runakunaqa Jesuspi mana creerankuchu. Hinaspapas profeta Isaiasqa paykunamantan escribispa, khaynata nillarantaq: ");
INSERT INTO qveNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Diosmi paykunataqa ñawsaman hina tukuchiran. Sonqonkutataqmi rumiyarachiran, saynapi ama entiendenankupaq, mana kasukuq kanankupaq, huchankumantapas Diosman ama kutirinankupaq, hinallataq mana salvasqa kanankupaq ima”, nispa Isaías 6.10. ");
INSERT INTO qveNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Kaykunatan profeta Isaiasqa escribiran, Jesuspa sumaq glorianta rikusqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Saynata ashka runakuna Jesuspi mana creeshaqtinkupas, ichaqa ashkan wakin runakunamantaqa Jesuspiqa creeranku. Chay creeqkunamantan wakinqa Israel nacionpi kamachiq jefekuna karanku. Ichaqa chay jefekunaqa fariseo religionniyoq runakunatan manchakuranku. Chayraykun Jesuspi creesqankutaqa mana alayritachu pimanpas willakuranku, saynapi sinagoga wasimanta ama qarqosqa kanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Aswanmi chay jefekunaqa, runakuna alabanallanta munaranku, Diospa alabananmantaqa. ");
INSERT INTO qveNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesusmi altota rimaspa khaynata niran: —Pipas noqapi creeqqa manan noqallapichu creen. Aswanqa mandamuwaqniy Taytaypipas creenmi. ");
INSERT INTO qveNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Saynallataqmi pipas noqata rikuwaqqa, mandamuwaqniy Taytaytapas rikushanman hinan. ");
INSERT INTO qveNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Noqan kay pachaman hamuq K'anchayqa kani. Chaymi pipas noqapi creeqqa, mana tutayaqpichu purinqa. ");
INSERT INTO qveNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Sichus pipas noqapa nisqaykunata uyarishaspa, mana kasukuqtaqa, manan noqachu juzgasaq. Noqaqa manan kay pachapi runakunata juzgaqchu hamurani; aswanqa salvaqmi. ");
INSERT INTO qveNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ichaqa pipas noqata cheqniwaspa, hinallataq yachachisqaykunatapas uyarishaspa, mana kasukuqtaqa, palabraypa nisqanman hinan juzgasqa kanqa juicio p'unchawpi. ");
INSERT INTO qveNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Chaymi noqaqa mana kikillaymantachu ni imatapas rimarani. Aswanqa mandamuwaqniy Taytaymi ima ninaytapas, hinallataq imaynata yachachinaytapas kamachiwaran. ");
INSERT INTO qveNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Hinaspapas noqaqa yachanin, Taytaypa kamachikuyninqa wiña-wiñaypaq kawsay qokuq kasqanta. Chayraykun Taytaypa kamachiwasqanta, noqaqa qankunaman yachachishaykichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pascua fiesta celebrananku p'unchawmi ña chayamusharanña. Hinaqtinmi Jesusqa ña yacharanña, Dios Taytanpa kasqanman kutipunan p'unchaw chayamusqanta. Jesusqa kay pachapi kashaspanqa, discipulonkunataqa anchatapunin munakuran. Hinaspapas chay munakuyninqa wiña-wiñaypaqmi karan. ");
INSERT INTO qveNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Hinaqtinmi Jesusqa discipulonkunapiwan kushka manaraq cenashaqtin, diabloqa Simonpa wawan Judas Iscariotepa sonqonpi ña piensachiranña Jesusta traicionananpaq. ");
INSERT INTO qveNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ichaqa Jesusqa yacharanmi Dios Taytan tukuy atiyta payman qosqanta. Hinaspapas Jesusqa yacharanmi, Dios Taytan kay pachaman mandamusqanta, hinallataq Dios Taytanpa kasqanman kutipunantapas. ");
INSERT INTO qveNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Chaymi Jesusqa mesapi mikhusqankumanta hatarispa, capanta orqokuran. Hinaspan huk toallata hap'ispa, cinturanman watakuran. ");
INSERT INTO qveNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Chaymantan huk lavatorioman unuta hich'aspa, discipulonkunapa chakinta maqchiyta qallariran. Hinaspan cinturanpi toallanwan secaran. ");
INSERT INTO qveNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Simón Pedropa chakinta maqchinanpaq tupamuqtinñataqmi, Pedroqa Jesusta niran: —Señorlláy, ¿qanchu noqapa chakiykunatari maqchiruwankiman? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Chaymi Jesusqa niran: —Kunanqa manaraqmi kaykuna ruwasqaytaqa entiendenkiraqchu. Aswanqa chaymantañan kaykunataqa entiendenki, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Hinaqtinmi Pedroqa niran: —Noqataqa manapunin chakiytaqa maqchiwankimanchu, nispa. Chaymi Jesusqa niran: —Sichus chakiykita mana maqchisqaykichu chayqa, manan noqapa discipuloyqa kawaqchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Hinaqtinmi Pedroqa niran: —Señorlláy, sayna kaqtinqa, amayá chakillaytachu maqchiway, aswanqa makiytawan hinallataq umaytawan imayá, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Chaymi Jesusqa Pedrota khaynata niran: —Bañasqa runaqa manan kaqmanta bañakuytaqa necesitanñachu, aswanqa chakillantañan maqchikunan. Chaymi niykichis, qankunaqa tukuy huchaykichismantaqa ñan limpioña kashankichis. Ichaqa manan llapaykichishchu limpioqa kashankichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesusqa pis payta traicionanantaqa ñan yacharanña. Chayraykun payqa niran: “Manan llapallaykichishchu limpioqa kashankichis”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Hinaspan discipulonkunapa chakinta maqchiyta tukuruspa, Jesusqa capanta churakapuran. Hinaspan mesapi kaqmanta tiyayuspa, discipulonkunata khaynata tapuran: —Qankunawan kay ruwasqayta, ¿entiendeshankichishchú? ");
INSERT INTO qveNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Qankunaqa niwankichismi: “Yachachikuq hinallataq Señorlláy”, nispa. Ichaqa niwasqaykichisman hinan noqaqa Yachachikuq hinallataq Señor kani. ");
INSERT INTO qveNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Chaymi niykichis, imaynan noqapas Señorniykichis hinallataq Yachachiqniykichis kashaspay, qankunapa chakiykichista maqchiraykichis, saynallatataqyá qankunapas chakiykichista maqchinakuychis. ");
INSERT INTO qveNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Noqaqa qankunamanmi huk ejemplota qoraykichis, saynata noqa hina qankunapas ruwanaykichispaq. ");
INSERT INTO qveNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Hinaspapas qankunaqa yachankichismi, huk sirviente runaqa, manan patronninmantaqa aswan más importanteqa kanmanchu. Nitaqmi comisionpi riq runapas, chay comisionaqnin runamantaqa aswan más importanteqa kanmanchu. ");
INSERT INTO qveNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Chaymi niykichis, sichus qankuna allinta entiendespa, noqapa ruwasqaykunata ruwankichis chayqa, kusisqan kankichis. ");
INSERT INTO qveNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ichaqa manan noqaqa llapaykichismantachu rimashani. Noqaqa yachanin pikunatachus akllasqayta. Ichaqa kay nisqaykuna cumplikunanpaqmi, Bibliapi ña escribisqaña kashan. Chaymi khaynata nin: “Noqawan kushka t'antata mikhuqmi, noqapa contraypi kanqa”, nispa Salmos 41.9. ");
INSERT INTO qveNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Chaymi noqaqa imapas manaraq pasashaqtin, kunanmantapacha kaykunata nishaykichis, chaykuna pasawaqtin, noqa Diospa Wawan kasqayta creenaykichispaq. ");
INSERT INTO qveNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Cheqaqtapunin niykichis: Pipas noqamanta willakunanpaq comisionasqay runata chashkiqqa, noqatapas chashkiwashanman hinan. Pipas noqata chashkiwaqqa, mandamuwaqniy Dios Taytaytapas chashkinmi, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Chaykunata niruspanmi, Jesusqa ancha llakisqallaña karan. Hinaspan discipulonkunataqa clarota niran: —Cheqaqtapunin niykichis, qankunamantan hukniykichis traicionawanqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Hinaqtinmi Jesuspa nisqanta uyarispanku, discipulonkunaqa mayqenninkumantas rimasqanta mana yachaspanku, paykunapura qawanakuranku. ");
INSERT INTO qveNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Chaypin Jesuspa ancha khuyakusqan discipulonpas, paypa ladonpi kasharan. ");
INSERT INTO qveNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Chaymi Pedroqa Jesuspa ancha munakusqan discipulota señascharan, Jesusta khaynata tapunanpaq: “Jesusri, ¿mayqenninchismantataq saynata nishan?” nispa. Nota: Jesuspa ancha munakusqan discipuloqa kay librota escribiq Juanmi karan. ");
INSERT INTO qveNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Chaymi Jesuspa ancha munakusqan discipulonqa, Jesusman astawan ashuyuspa, khaynata tapuran: —Señorlláy, ¿pitaq traicionasunkirí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Hinaqtinmi Jesusqa contestaran khaynata: —Chay runaqa pimanchus t'antata platoman challpuyuspa qosaq, paymi, nispa. Hinaqtinmi Jesusqa t'antata challpuyuspa, Simonpa wawan Judas Iscarioteman qoran. ");
INSERT INTO qveNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Chay t'antatan Judas Iscarioteqa mikhuran. Chay mikhusqanpa qepallanmanmi, diabloqa Judaspa sonqonman haykuran. Chaymi Jesusqa Judas Iscarioteta niran: —Chay ruwanaykitaqa, apurayllamanyá ruwamuy, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ichaqa saynata Judas Iscarioteta Jesús niqtinmi, mesapi tiyaq discipulonkunaqa mana ni mayqenninkupas entienderankuchu. ");
INSERT INTO qveNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Aswanmi Jesuspa wakin discipulonkunaqa piensaranku, Judas Iscariote qolqe waqaychaq kasqanrayku, “Pascua fiestapaq imapas faltaqkunata rispa rantimuy”, ninanpaq; otaq qolqe hap'isqanta “wakchakunaman rakimuy” ninanpaq. ");
INSERT INTO qveNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Hinaqtinmi Judas Iscarioteqa t'antata mikhuruspan lloqsitamuran. Chay horasqa ñan tutaña karan. ");
INSERT INTO qveNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas lloqsiruqtin hinallan, Jesusqa discipulonkunata niran: —Noqa Diosmanta Hamuq Runa, ancha atiyniyoq kasqayta llapallan runakunaman rikuchinaypaqmi, ña hora kunan chayaramunña. Chaymi noqata rikuwaspanku, Dios Taytaypas ancha atiyniyoq kasqanta yachanqaku. ");
INSERT INTO qveNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Sichus llapallan runakunaman rikuchisaq, Dios Taytayqa ancha atiyniyoq kasqanta chayqa, Dios Taytaypas llapallan runakunamanmi rikuchillanqataq, noqa Wawanpas ancha atiyniyoq kasqayta. Chaytan Dios Taytayqa kay hamuq pisi p'unchawkunallapi ruwanqa. ");
INSERT INTO qveNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Saynaqa munakusqay wawaykuna, manan unayñachu qankunawan kushkaqa kasaq. Manataqmi mashkawaspaykichispas tariwankichishchu. Ichaqa, imaynan Israel nacionniyoq runakunapa jefenkunatapas nirani, saynallataqmi qankunatapas kunan niykichis: “Noqapa risqay lugarmanqa, manan qankunaqa atiwaqchishchu riyta”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Kunanmi huk mosoq kamachikuyta qankunaman qoykichis: Khuyanakuychis qankunapura, imaynan noqapas qankunata munakuykichis saynata. ");
INSERT INTO qveNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Sichus qankunapura khuyanakuspa kawsankichis chayqa, llapallan runakunan noqapa discipuloykuna kasqaykichista yachanqaku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Señor Jesustan Simón Pedroqa tapuran khaynata: —Señorlláy, ¿maymantaq rinkirí? nispa. Hinaqtinmi Jesusqa contestaran: —Noqapa risqay lugarmanqa manaraqmi kunanqa riwaqchu. Ichaqa noqapa kasqaymanqa qepatañan hamunki, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Chaymi Pedroqa kaqmanta tapullarantaq: —Señorlláy, kunanri, ¿imanaqtintaq riytari mana atiymanchú? Noqaqa liston kashani, qanrayku wañunaypaqpas, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Chaymi Jesusqa khaynata niran: —¿Cheqaqtachu noqarayku wañunaykipaq listo kashankí? Cheqaqtapunin qanta niyki: Kunan tutan manaraq gallo waqashaqtin, kinsa kutita negawanki: “Chay Jesustaqa manan reqsinichu”, nispayki. ");
INSERT INTO qveNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesusmi khaynata niran: —Qankunaqa ama llakikuychishchu. Aswanqa Diospiyá confiaychis; saynallataq noqapipas confiaychis. ");
INSERT INTO qveNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Dios Taytaypa kasqanpiqa ashkan wasikuna kashan. Sichus wasikuna mana kanmanchu chayqa, manachá niykichismanchu karan: “Rispaymi huk lugarta qankunapaq preparamusaq”, nispaqa. ");
INSERT INTO qveNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Noqaqa Dios Taytaypa kasqanman rispaymi, qankunapaq huk lugarta preparamusaq. Chaymantan kutimuspay, qankunata pusasqaykichis, qankunapas noqawan kushka maypi kasqaypi kanaykichispaq. ");
INSERT INTO qveNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ichaqa qankunaqa ñan yachankichishña mayman risqaytapas; hinaspapas reqsinkichishñan ñantaqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Hinaqtinmi Tomasqa niran: —Señorlláy, noqaykuqa manan yachaykuchu mayman risqaykitapas. Chayri, ¿imaynataq risqayki ñantari reqsiykuman? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Chaymi Jesusqa khaynata niran: —Noqan kani ñanqa, cheqaq kaqpas, saynallataq kawsay qoqpas. Chaymi Dios Taytaymanqa noqallantapuni pipas chayanqa. ");
INSERT INTO qveNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Sichus noqata allinta reqsiwankichis chayqa, Dios Taytaytapas reqsillankichistaqmi. Ichaqa Dios Taytaytaqa kunanmantapachan reqsishankichis, noqata rikuwasqaykichisrayku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Hinaqtinmi discipulon Felipeqa khaynata niran: —Señorlláy, Dios Taytaykitayá rikuyachiwayku. Chaywanmi noqaykuqa kusisqa kasaqku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Chaymi Jesusqa contestaran khaynata: —Felipe, qankunawanqa unayñan kashani. ¿Chaychu manaraq reqsiwankí? Pipas noqata rikuwaqqa, Dios Taytaytapas rikunmi. Chayri, ¿imanaqtintaq qanri niwanki: “Dios Taytaykitayá rikuchiwayku”, nispaykirí? ");
INSERT INTO qveNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Qanri, ¿manachu creenki Dios Taytaywanqa huklla kasqaykuta? Qankunaman imapas nisqaytaqa, manan noqaqa kikillaymantachu rimashani. Noqaqa Dios Taytaypa munasqallantan imatapas ruwani. Hinaspapas Dios Taytayqa noqantakaman imatapas ruwan. ");
INSERT INTO qveNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Chayqa, creewaychisyá, noqaqa Dios Taytaywan huklla kasqayta, hinallataq Dios Taytaypas noqawan huklla kasqanta. Sichus mana creewankichishchu chayqa, kay milagrokuna ruwasqayraykuyá creewaychis. ");
INSERT INTO qveNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Noqaqa cheqaqtapunin niykichis: Pipas noqapi creeqqa ruwasqaykunatapas ruwanqan. Hinaspapas Dios Taytaypa kasqanman ripusqayraykun, qankunaqa noqapa ruwasqaykunamantapas aswan mastaraq ruwankichis. ");
INSERT INTO qveNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Qankuna sutiypi imatapas mañakuqtiykichisqa, noqaqa ruwasaqmi. Saynapin Dios Taytaypas alabasqa kanqa, noqapa ruwasqaykunawan. ");
INSERT INTO qveNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Sichus nisqayman hina noqapa sutiypi imatapas mañakunkichis chayqa, noqaqa ruwasaqmi, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jesusqa nillarantaqmi: —Sichus noqata munakuwankichis chayqa, kamachisqaykunatapas kasukunkichismi. ");
INSERT INTO qveNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Hinaqtinmi noqaqa Dios Taytayta ruegakusaq, Santo Espirituta qankunaman mandamunanpaq. Chay Santo Espíritu hamuspanmi qankunawan tukuy tiempo kanqa. ");
INSERT INTO qveNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Chaymi chay Santo Espirituqa qankunaman cheqaq kaqta yachachisunkichis. Ichaqa chay Santo Espiritutaqa, Diospi mana creeq runakunaqa, manan chashkinqakuchu, payta mana rikuspanku, hinallataq mana reqsisqankurayku. Qankunan ichaqa reqsinkichis, qankunawan kushka kasqanrayku; hinaspapas qankunapa sonqoykichispin tukuy tiempo kanqa. ");
INSERT INTO qveNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Noqaqa manan sapallaykichistachu qankunataqa saqesqaykichis. Aswanqa kutimusaqmi, qankunawan kushka kanaypaq. ");
INSERT INTO qveNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ichaqa pisi tiempollañan faltashan runakuna manaña rikuwanankupaq. Qankunan ichaqa rikuwankichis; noqa wañusaq chaypas, kawsarimusaqmi. Chaymi qankunatapas kawsarichisqaykichis. ");
INSERT INTO qveNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Chay p'unchawmi qankunaqa yachankichis, noqaqa Dios Taytaywan huklla kasqayta, hinallataq noqapas qankunawan huklla kasqayta, saynallataq qankunapas noqawan huklla kasqaykichista. ");
INSERT INTO qveNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Pipas noqapa kamachisqaykunata kasukuspa ruwaqmi, noqataqa cheqaqtapuni munakuwan. Sayna munakuwaqniy runatan, Dios Taytayqa munakunqa. Chaymi noqapas chay munakuwaqniy runata munakusaq; hinaspan paywanqa astawanraq reqsichikusaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Chaymi Jesuspa discipulon Judas mana Iscariote kaq, khaynata niran: —Señorlláy, ¿imanaqtintaq noqallaykuwanri reqsichikunki, qanpi mana creeq runakunawantaq mana reqsichikunkichú? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Chaymi Jesusqa contestaspa niran: —Pipas noqata munakuwaqqa, kamachisqaykunatan kasukunqa. Chaymi Dios Taytaypas payta munakunqa. Hinaqtinmi noqaykuqa chay kasukuq runaman hamuspayku, paypa sonqonpi tiyasaqku. ");
INSERT INTO qveNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Pipas noqata mana munakuwaqqa, kamachisqaykunataqa manan kasukunqachu. Ichaqa kay yachachisqaykuna uyarisqaykichisqa, manan noqallamantachu, aswanqa kay pachaman mandamuwaqniy Dios Taytaymantan. ");
INSERT INTO qveNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Kaykunataqa qankunawan kallashaspayraqmi willashaykichis. ");
INSERT INTO qveNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ichaqa Dios Taytaymi noqapa rantiyta qankunaman Santo Espirituta mandamunqa. Paymi qankunaman hamuspa, tukuy imapi kallpanchasunkichis, yachachisunkichis, hinallataq tukuy ima yachachisqaykunatapas yuyarichisunkichis. ");
INSERT INTO qveNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Noqa qankunata tukuy imapi yanapaqtiymi, qankunaqa hawkalla kankichis. Ichaqa chay hawkayay qosqayqa, manan kay pachapi runakunapa qosqan hinachu. Saynaqa amayá qankunaqa hukmanyaychishchu, nitaq manchakuychishchu. ");
INSERT INTO qveNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ñan qankunaqa uyarirankichishña: “Ripusaqmi ichaqa qankunamanmi kutimusaq”, nisqaytaqa. Sichus qankuna cheqaqtapuni munakuwankichisman chayqa, kusisqachá kashawaqchis, Dios Taytaypa kasqanman kutipusqayrayku. Ichaqa Dios Taytaymi noqamantaqa aswan más importante. ");
INSERT INTO qveNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kaykunatan manaraq imapas pasashaqtin qankunaman nishaykichis, chaykuna pasaruqtin, noqapi qankuna creenaykichispaq. ");
INSERT INTO qveNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Kay pachapi runakunata kamachiq diabloqa ñan hamushanña. Chaymi qankunawanqa manaña astawanqa rimasaqñachu. Diabloqa noqata vencewananpaqqa manan noqamanta aswan más atiyniyoqchu. ");
INSERT INTO qveNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ichaqa kay pachapi llapallan runakunan yachananku noqaqa Dios Taytayta anchata munakusqayta. Chaymi noqaqa Dios Taytaypa tukuy ima niwasqantapuni ruwani, nispa. Saynata nispanmi Jesusqa khaynata kamachiran: —Hatariychis; hinaspa kay lugarmanta lloqsisunchis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesusqa nillarantaqmi: —Noqan cheqaq uvas plantaqa kani. Dios Taytaytaqmi chakra llank'aq. ");
INSERT INTO qveNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Sichus noqapi kaq mayqen ramapas mana ruruqtinqa, Dios Taytaymi chay ramataqa takaspa wikapan. Ichaqa ruruq ramatañataqmi, sumaqta podaspa limpian astawan rurunanpaq. ");
INSERT INTO qveNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Saynan qankunaqa ña limpioña kashankichis, kay yachachisqaykunata uyarispa kasukusqaykichisrayku. ");
INSERT INTO qveNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Sichus qankuna noqawan huklla kankichis chayqa, noqapas qankunawanmi huklla kasaq. Hinaspapas ñan qankunaqa yachankichishña, huk rama allinta rurunanpaqqa uvas sach'apin kanan; uvas sach'api mana kaspaqa, manan rurunmanchu. Saynallataqmi qankunapas sichus noqawan huklla mana kaspaykichisqa, manan ni imatapas Diospaq hinaqa ruwayta atiwaqchishchu. ");
INSERT INTO qveNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Noqan chay uvas sach'aqa kani. Qankunataqmi chay uvas sach'apa ramankuna kankichis. Pipas noqapi kashan chayqa, hinallataq noqapas paypi kashani chayqa, paymi chay uvas sach'a hina ashkata rurunqa. Ichaqa noqamanta pipas rakikuspaqa, manan kikillanmantaqa ni imatapas ruwaytaqa atinmanchu. ");
INSERT INTO qveNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Sichus pipas noqamanta rakikuqqa, takasqa ch'aki rama hinan ninaman wikch'uyusqa kanqa; hinaspan chaypi k'anasqa kanqa. ");
INSERT INTO qveNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Sichus qankuna, mana ishkayaspa, noqapi allinta creenkichis, hinallataq yachachisqaykunatapas kasukunkichis chayqa, tukuy ima mañakusqaykichistapas chashkinkichismi. ");
INSERT INTO qveNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Qankuna allinta kawsaspa, sumaqta ruruqtiykichismi, Diosqa alabasqa kanqa. Saynapin qankunaqa cheqaq discipuloykuna kankichis. ");
INSERT INTO qveNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Imaynan Dios Taytaypas noqata munakuwan, saynatan noqapas qankunataqa munakuykichis. Saynallataqyá qankunapas ama qonqawaspaykichis noqata munakuwaychis. ");
INSERT INTO qveNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Noqaqa Dios Taytaypa kamachiwasqankunatan kasukuni; chaymi payqa anchata munakuwan. Saynallataqmi sichus qankunapas kamachisqaykunata kasukunkichis chayqa, noqapas wiñaypaqmi qankunataqa munakusqaykichis. ");
INSERT INTO qveNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Kaykunatan qankunaman nishaykichis, qankunapas noqa hina ancha kusisqa kanaykichispaq. ");
INSERT INTO qveNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ichaqa kunanmi kayta kamachiykichis: Qankunapurayá khuyanakuychis, imaynan noqapas qankunata munakuykichis, chay hinata. ");
INSERT INTO qveNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","¿Pitaq kanman ancha hatun munakuyniyoqrí? Chay hatun munakuyniyoq runaqa, amigonkunarayku wañuqllan. ");
INSERT INTO qveNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Sichus noqapa kamachisqaykunata ruwankichis chayqa, amigoykunan kankichis. ");
INSERT INTO qveNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Qankunaqa manañan sirviente runakuna hinañachu kankichis. Ichaqa huk sirviente runaqa patronninpa ima ruwasqantapas manan yachanchu. Chaymi qankunataqa manaña “sirviente runa” nisqaykichishñachu; aswanqa “amigoykuna” nisqaykichishñan. Chaymi noqaqa Dios Taytaypa tukuy ima willawasqankunata, qankunaman willaraykichis. ");
INSERT INTO qveNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Noqataqa manan qankunachu akllawarankichis; aswanqa noqan qankunataqa akllaraykichis. Hinaspan qankunataqa comisionaraykichis, rispa, chay allin rama hina, ashkata rurunaykichispaq, saynapi chay ruruykichis wiñaypaq takyananpaq. Chaymi tukuy imatapas sutiypi mañakuqtiykichis, Dios Taytayqa qosunkichis. ");
INSERT INTO qveNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Noqaqa kaytan kamachiykichis: Qankunapura khuyanakuychis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jesusqa nillarantaqmi: —Sichus huchallapi kawsaq runakuna cheqnisunkichis chayqa, yuyariychisyá, qankunamanta aswan antestaraqmi, ña noqataqa cheqniwarankuña. ");
INSERT INTO qveNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Sichus qankuna huchapi kawsaq runakuna hina kawaqchis chayqa, huchapi llapallan kawsaq runakunaqa khuyakusunkichismanmi. Ichaqa noqa qankunata akllakusqayraykun, qankunaqa manaña huchapi kawsaq runakunañachu kankichis. Chaymi huchallapi kawsaq runakunaqa cheqnikusunkichis. ");
INSERT INTO qveNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Kay nisqaykunatayá yuyariychis: Wasipi kamachi ruwaq sirviente runaqa manan patronninmantaqa aswan más importanteqa kanmanchu. Chayraykun niykichis, noqa kamachiq kashaqtiy runakuna cheqniwaspanku ñak'arichiwaranku chayqa, qankunatapas chay runakunaqa, noqapa serviqniy kasqaykichisraykun, ñak'arichisunkichis. Ichaqa sichus paykuna noqapa yachachisqaykunata kasukunqaku chayqa, qankunapa yachachisqaykichistapas kasukunqakun. ");
INSERT INTO qveNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Saynataqa ñak'arichisunkichis, noqapi creesqaykichisrayku, hinallataq mandamuwaqniy Diostapas mana reqsisqankuraykun. ");
INSERT INTO qveNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Sichus noqa mana hamuymanchu, nitaq paykunaman ni imatapas willaymanchu chayqa, manachá huchankumantaqa culpayoqchu kankuman karan. Kunanmi ichaqa huchayoq kasqankuta yachakusqankurayku manaña ni ima niytapas atinqakuñachu. ");
INSERT INTO qveNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Pipas noqata cheqniwaqqa, Taytaytapas cheqnillantaqmi. ");
INSERT INTO qveNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Sichus noqa mana ruwaymanchu karan paykuna ukhupi mana pipa ruwasqan milagrokunata chayqa, manachá huchankumantaqa culpayoqchu kankuman karan. Kunanmi ichaqa tukuy milagrokuna ruwasqayta rikushaspankupas, noqata hinallataq Taytaytapas cheqniwanku. ");
INSERT INTO qveNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ichaqa Bibliapi escribisqa cumplikunanpaqmi kaykunaqa pasashan. Bibliapin nishan khaynata: “Yanqapunin cheqniwanku”, nispa Salmos 35.19; 69.4. ");
INSERT INTO qveNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Noqan Taytaypa partenmanta Santo Espirituta mandamusqaykichis. Paymi qankunata yanapasunkichis, hinallataq cheqaq kaqkunatapas noqamanta yachachisunkichis. ");
INSERT INTO qveNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Hinaqtinmi qankunapas noqamanta willakunkichis, yachachiy qallarisqaymantapacha noqawan kushka kasqaykichisrayku. ");
INSERT INTO qveNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Qankunamanmi kaykunataqa nishaykichis, noqapi iñiyniykichis ama chiriyananpaq. ");
INSERT INTO qveNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Qankunataqa Diosmanta yachachina sinagoga wasikunamantan qarqosunkichis. Ichaqa chayamunqan p'unchawkuna, pipas noqapi creeq runakunata wañuchispanku, khaynata piensanankupaq: “Noqaqa Diospa favorninpin kay runakunataqa wañuchishani”, nispa ninankupaq. ");
INSERT INTO qveNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Kaykunataqa ruwanqaku, Taytayta hinallataq noqatapas mana reqsiwasqankuraykun. ");
INSERT INTO qveNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ichaqa kaykunatan ña niraykichishña, chay sasachakuy p'unchawkuna chayamuqtin, kay nisqaykunata yuyarinaykichispaq. Qankunaman yachachiyta qallarispayqa, manan kay ñak'ariykunamantaqa yachachiraykichishchu, qankunawan kushka kasqayrayku. ");
INSERT INTO qveNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Jesusqa nillarantaqmi: —Kunanmi ichaqa Dios Taytaypa kasqanman ripusaqña. (Chaymi noqaqa kaykunata entiendenaykichista munani). Ichaqa manan ni mayqenniykichispas tapuwankichishchu: “¿Maymantaq ripunkirí?” nispaqa. ");
INSERT INTO qveNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Aswanmi kaykunata niqtiy, qankunaqa ripunaymanta yachaspaykichis, nishu llakisqallaña kashankichis. ");
INSERT INTO qveNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ichaqa cheqaqtapunin noqaqa nishaykichis: Noqa ripuqtiyqa, qankunapaqqa aswan allinmi kanqa. Sichus mana ripuymanchu chayqa, Santo Espirituqa manan qankunata yanapasunaykichispaqqa hamunmanchu. Aswanqa noqa ripuspaymi, payta qankunaman mandamusaq. ");
INSERT INTO qveNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Santo Espíritu hamuspanmi, runakunaman rikuchinqa huchayoq kasqankumanta, Diosqa mana ni ima huchayoq kasqanmanta, hinallataq juicio p'unchawpi runakuna juzgasqa kanankumantawan ima. ");
INSERT INTO qveNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","¿Pitaq huchayoqrí? Noqapi mana creeq runakunan huchayoqqa kanku. ");
INSERT INTO qveNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","¿Pitaq mana huchayoqrí? Noqallan kani mana huchayoqqa. Chaymi Dios Taytaypa kasqanman ripusaq. Hinaqtinmi manaña rikuwankichishñachu. ");
INSERT INTO qveNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","¿Pitaq Diospa castigontari chashkinqa? Kay pachapi runakunata kamachiq diablon. Hinaspapas diabloqa ñan juzgasqaña kashan. (Chaymi yachanchis huchayoq runakunapas juzgasqa kanankuta). ");
INSERT INTO qveNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Qankunaman willanaypaqqa ashkaraqmi kashan. Ichaqa manaraqmi kunanqa atiwaqchisraqchu entiendeytaqa. ");
INSERT INTO qveNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ichaqa Santo Espíritu qankunaman hamuspanmi, Diosmanta llapallan cheqaq kaqkunata entiendenaykichispaq yachachisunkichis. Santo Espirituqa manan kikillanmantachu imatapas rimanqa. Aswanqa Taytaymanta tukuy ima uyarisqantan rimanqa. Hinaspan qepa tiempokunapi imakunas pasananmanta qankunaman willasunkichis. ");
INSERT INTO qveNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Saynallataqmi Santo Espirituqa noqata alabawanqa. Hinaspan qankunaman yachachisunkichis noqamanta tukuy ima uyarisqanta. ");
INSERT INTO qveNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Dios Taytaypa tukuy ima piensasqankunatapas, noqaqa yachallanitaqmi. Chaymi noqaqa qankunata niraykichis, Santo Espiritun noqamanta tukuy imakunatapas willasunkichis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jesusqa nillarantaqmi: —Ashllatawanqa manañan rikuwankichishñachu. Chaymantan ichaqa kaqmanta rikuwankichis, {Taytaypa kasqanman ripusqayrayku}, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jesús saynata niqtinmi, wakin discipulonkunaqa, paykunapura tapunakuranku khaynata: —Kaykunatari, ¿ima ninantataq nishan? ¿“Ashllatawanqa manañan rikuwankichishñachu Dios Taytaypa kasqanman ripusqayrayku. Chaymantan ichaqa kaqmanta rikuwankichis”, nisparí? ");
INSERT INTO qveNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Ima ninantataq, “ashllatawanqa manañan rikuwankichishñachu”, nishanrí? Kay rimasqankunataqa manan entiendenchishchu, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Chaymi Jesusqa discipulonkuna payta tapuy munasqankuta yachaspa, paykunata niran: —Qankunatan noqaqa niraykichis: “Ashllatawanqa manañan rikuwankichishñachu. Chaymantan ichaqa kaqmanta rikuwankichis”, nispa. ¿Sayna nisqaymantachu qankunari tapunakushankichís? ");
INSERT INTO qveNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Noqaqa cheqaqtapunin niykichis, qankunaqa ñakapakuspan waqankichis. Aswanqa noqapi mana creeq runakunañataqmi kusikunqaku. Ichaqa llakisqallaña kashaqtiykichispas, llakikuyniykichisqa ancha kusikuymanmi tukunqa. ");
INSERT INTO qveNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Wiksayoq warmiqa wawanta onqokunan horas chayaramuqtinmi, dolorwan ñak'arin. Ichaqa chay wawanta onqorukuspanñataqmi, chay ancha ñak'arisqan horastapas qonqaspa, anchata kusikun wawata kay pachaman apamusqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Saynallataqmi qankunatapas pasasunkichis. Kunanmi qankunaqa ancha llakisqa kashankichis. Ichaqa noqa kutimuqtiymi ancha kusisqa kankichis. Chay kusikuytaqa manan ni pipas qechuytaqa atisunkichishchu. ");
INSERT INTO qveNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Chaymi chay p'unchawpiqa manaña ni imamantapas tapuwankichishñachu. Chaymi cheqaqtapuni niykichis, imatapas sutiypi Dios Taytaymanta mañakuqtiykichisqa, Dios Taytayqa qosunkichismi. ");
INSERT INTO qveNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Qankunaqa manan ni imatapas sutiypiqa kunankama mañakunkichisraqchu. Mañakuspaqa chashkinkichismi, saynapi ancha kusisqa kanaykichispaq. ");
INSERT INTO qveNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Noqaqa kaykunatan qankunaman niraykichis kay willakuykunallawan. Ichaqa chayamunqan p'unchaw willakuykunallawan qankunaman manaña willanaypaq. Chay p'unchaw chayamuqtinmi, Taytaymantaqa alayritaña qankunaman rimapayasqaykichis. ");
INSERT INTO qveNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Chay p'unchawkunapiqa, manañan noqañachu Taytaymantaqa mañapusqaykichis. Aswanqa qankunañan Taytaymantaqa noqapa sutiypi mañakunkichis, noqapi creesqaykichisrayku. ");
INSERT INTO qveNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Dios Taytayqa anchatan qankunataqa munakusunkichis. Saynataqa munakusunkichis noqata munakuwasqaykichisraykun, hinallataq noqata kay pachaman Dios Taytay mandamuwasqanpi creesqaykichisraykun. ");
INSERT INTO qveNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Noqaqa Taytaypa kasqanmantan kay pachaman hamurani. Kunanmi ichaqa kay pachata saqespa, Taytaypa kasqanman kutipusaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Chayta uyarispankun discipulonkunaqa niranku: —Kunanmi ichaqa noqayku entiendenaykupaq clarota rimashanki mana ejemplokunallawan. ");
INSERT INTO qveNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Chaymi kunanqa manaña necesarioñachu ni pipas tapusunaykipaqqa. Hinaspapas qanqa tukuy ima piensasqaykutapas ñan yachankiña. Chayraykun noqaykuqa creeyku, qantaqa kikin Diospuni kay pachaman mandamususqaykita, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Chaymi Jesusqa niran: —Noqapiri, ¿chayraqchu kunan creerunkichís? ");
INSERT INTO qveNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Wañunay horasmi ña chayamushanña. Chaymi qankunaqa tukuy lawman ch'eqespaykichis sapallayta saqewankichis. Ichaqa manan sapallaychu kashani; aswanqa Taytaymi noqawan kushka kashan. ");
INSERT INTO qveNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Chaymi kaykunataqa nishaykichis, noqapi creespaykichis hawkalla kanaykichispaq. Kay pachapiqa ñak'arinkichismi, ichaqa kallpanchakuspayá noqapi confiaychis. Noqan kay pachapi mana allinkunataqa ña venceruniña, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesusqa chaykunata rimaruspanmi, hanaq pachata qawarispa, Dios Taytanmanta mañakuran khaynata: —Dios Taytáy, noqapa wañunay horan chayaramunña. Saynaqa kunanyá kay Wawaykita hatunchaykuy, saynapi noqa Wawaykipas qanta hatunchanaypaq. ");
INSERT INTO qveNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Qanqa noqamanmi atiyta qowaranki, llapallan runakunata kamachinaypaq, hinallataq noqaman qowasqayki runakunamanpas wiñay kawsayta qonaypaq. ");
INSERT INTO qveNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Wiñaypaq kawsaytaqa chashkinqaku ch'ullalla cheqaq Dios kasqaykita creeq runakunallan; hinallataq noqa mandamusqayki Salvador Jesucristopi creeq runakunallan. ");
INSERT INTO qveNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Chaymi noqaqa ancha hatun atiyniyoq kasqaykita kay pachapi llapallan runakunaman rikuchini. Saynapin cumplirani lliw ruwanaypaq kamachimuwasqaykita. ");
INSERT INTO qveNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Dios Taytáy, imaynan qanwan kushka kashaqtiy, hinallataq manaraq kay pachapas kashaqtin hatunchawaranki, saynallataqyá kunanpas hatunchaykuway. ");
INSERT INTO qveNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Noqaqa pis kasqaykimantaqa kay pachapi qowasqayki runakunamanqa ñan willaraniña. Paykunaqa qanpan karan. Hinaspan paykunataqa noqaman qowaranki. Hinaqtinmi paykunaqa kamachisqaykikunata kasukushanku. ");
INSERT INTO qveNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Kunanqa ñan paykunaqa yachankuña tukuy ima ruwasqaypas, hinallataq yachachisqaykunapas qanmanta hamusqanta. ");
INSERT INTO qveNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ichaqa qanpa niwasqaykikunatan paykunaman willarani. Hinaspan paykunaqa chay niwasqaykikunata chashkispanku, cheqaqtapuni qanmanta hamusqayta yachanku; hinallataq qan mandamuwasqaykipipas creenku. ");
INSERT INTO qveNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Chaymi noqaqa paykunapaq mañapushani. Ichaqa manan kay pachapi qanpi mana creeq runakunapaqchu mañakushani. Aswanqa qowasqaykikunapaqmi noqaqa mañakushani qanpa kasqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Noqapi creeq runakunaqa qanpan; saynallataqmi qanpi creeq runakunapas noqapa. Hinaspapas noqaqa paykunantakaman ancha atiyniyoq kasqayta reqsichikuni. ");
INSERT INTO qveNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Dios Taytáy, qanqa ch'uyan kanki. Noqaqa manañan kay pachapiñachu kasaq. Noqapi creeq runakunan ichaqa kay pachapiraq kanqaku. Noqaqa qanwan kushka kanaypaqmi hamushaniña. Chaymi mañakamuyki, paykunata hatun atiyniykiwan cuidaykunaykipaq, saynapi paykunapas noqanchis hina huk piensayniyoqlla kanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Noqaqa kay pachapiraq kashaspayqa, sutiykipin paykunataqa cuidarani. Chaymi qowasqaykikunaqa mana mayqenninkupas noqamantaqa rakikurankuchu. Ichaqa noqapi mana creeq (Judas Iscariotellan) rakikuran. Chay hinata ruwaqtinmi, Bibliapi nisqan cumplikuran. ");
INSERT INTO qveNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Kunanmi ichaqa qanpa kasqaykiman kutimushaniña. Chaymi kay pachallapiraq kashaspay kaykunataqa rimashani, paykunapas noqa hina ancha kusisqa kanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Noqaqa palabraykikunatan paykunaman willarani. Hinaqtinmi kay pachapi runakunaqa palabraykita uyariyta mana munaspanku, discipuloykunata cheqnikunku. Saynataqa cheqnikunku, discipuloykunapas hinallataq noqapas manaña kay pachamanta runakuna hinañachu kasqaykuraykun. ");
INSERT INTO qveNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Noqaqa manan qowasqayki runakunata kay pachamanta orqonaykipaqchu mañakushayki, aswanqa diablomanta cuidanaykipaqmi. ");
INSERT INTO qveNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Discipuloykunaqa noqapi creesqankuraykun manaña kay pachamantañachu kanku; nitaqmi noqapas kay pachamantachu kani. ");
INSERT INTO qveNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Dios Taytáy, qanpa palabraykiqa cheqaq yachachikuymi. Chayta discipuloykuna uyariqtinkuyá, qanqa ch'uyanchaykuy. ");
INSERT INTO qveNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Imaynan qanpas kay pachapi runakunaman mandamuwaranki, saynallataqmi noqapas discipuloykunataqa kay pachapi runakunaman (palabraykimanta willamunankupaq) ña mandaruniña. ");
INSERT INTO qveNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Noqaqa paykunaraykun qanpa munasqaykita ruwaspa kawsashani, saynapi paykunapas qanpa munasqaykita ruwaspa kawsanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Manan noqaqa discipuloykunallapaqchu mañakushayki. Aswanmi noqaqa mañakushani, discipuloykuna noqamanta willakuqtinku, pikunachus qepa tiempokunata noqapi creeqkunapaqwanmi. ");
INSERT INTO qveNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Dios Taytáy, noqaqa mañakuykin, noqapi creeqkunaqa huk runa hinalla kanankupaq, imaynan qanpas noqawan, hinallataq noqapas qanwan huklla kanchis, saynallataqyá paykunapas noqanchiswan huklla kachunku. Saynapin kay pachapi runakunaqa creenqaku, qan kay pachaman mandamuwasqaykita. ");
INSERT INTO qveNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Noqaqa hatunchawasqaykiman hinan noqapi creeqkunataqa hatuncharani, saynapi paykunapas noqanchis hina huklla kanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Noqaqa paykunawanmi kashani. Qantaqmi noqawan kashanki. Saynapin paykunaqa cheqaqta huk runa hinalla kanqaku. Saynata kawsaqtinkun kay pachapi runakunaqa yachanqaku qan mandamuwasqaykita, hinallataq paykunatapas munakusqaykita, imaynan qanpas noqata munakuwaranki hinata. ");
INSERT INTO qveNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Dios Taytáy, noqaqa anchatapunin munani, qowasqayki discipuloykunapas noqapa kasqaypi kanankuta, saynapi chay hatunchawasqayki atiyta rikunankupaq. Chay hatunchawasqayki atiytaqa qowaranki, kay pachapas manaraq kashaqtinmi munakuwasqaykirayku. ");
INSERT INTO qveNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Dios Taytáy, qanqa pimanpas mana sayapakuqmi kanki. Ichaqa kay pachapi runakunaqa manan reqsisurankikuchu allin ruwaq justo kasqaykitaqa. Noqan ichaqa reqsiyki Papay kasqaykirayku. Saynallataqmi discipuloykunapas kay pachaman qan mandamuwasqaykita yachanku. ");
INSERT INTO qveNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Noqaqa paykunamanmi yachachishani pi kasqaykimanta. Hinaspapas paykunaman yachachiytaqa, manan dejasaqchu, saynapi munakuywan munakuwasqayki paykunapi kananpaq, saynallataq noqapas kikiypuni paykunapi kanaypaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesusqa mañakuyta tukuruspanmi, discipulonkunapiwan kushka Cedrón nisqa wayq'opa chimpanpi kaq huertaman riran. ");
INSERT INTO qveNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Chay lugartaqa Jesusta traicionaq Judas Iscariotepas allintan reqsiran, chaypi ashka kutita Jesusqa discipulonkunapiwan huñunakusqankurayku. ");
INSERT INTO qveNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","(Jesusqa chay lugarpin discipulonkunawan huñunasqa kasharanku). Hinaqtinmi Judas Iscarioteqa, Roma llaqtayoq soldadokunata pusayukuspa, hinallataq templota cuidaq guardiakunapiwan ima hamuranku. Paykunaqa hamuranku lamparinniyoq, mecheroyoq, hinallataq allin armasqa iman. Paykunataqa mandamuranku sacerdotekunapa jefenkuna, hinallataq fariseo religionniyoq runakunapiwan iman. ");
INSERT INTO qveNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ichaqa Jesusqa ñan yacharanña imakunas payta pasananmantaqa. Chaymi Jesusqa chay armasqa runakunapa hamusqanta rikuruspa, paykunaman ashuyuran. Hinaspan paykunataqa khaynata tapuran: —Qankunari, ¿pitataq mashkamushankichís? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Chaymi chay runakunaqa contestaranku: —Nazaret llaqtayoq Jesustan mashkashayku, nispanku. Hinaqtinmi Jesusqa niran: —Noqan chay mashkasqaykichis runaqa kani, nispa. Jesusta traicionaqnin Judaspas chaypin kasharan. ");
INSERT INTO qveNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","“Noqan chay mashkasqaykichis runaqa kani”, nispa Jesús niqtinmi, paykunaqa qepaman kutispanku, pampaman t'ikrakuranku. ");
INSERT INTO qveNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Hinaqtinmi Jesusqa kaqmanta paykunata tapuran: —Qankunari, ¿pitataq mashkamushankichís? nispa. Chaymi paykunaqa kaqmanta contestaranku: —Nazaret llaqtayoq Jesustan mashkashayku, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Chaymi Jesusqa contestaran: —Ñan niykichishña: “Noqan kani”, nispa. Noqata mashkamuwashankichis chayqa, kay discipuloykunatayá ripunankupaq dejaychis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Kaykunaqa pasaran, Jesuspa ñawpaqtaraq rimasqan cumplikunanpaqmi. Paymi niran: “Papaypa qowasqankunataqa, manan ni ch'ullallatapas chinkachinichu”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Hinaqtinmi Simón Pedroqa espadanta orqomuspa, Malco sutiyoq runapa phaña ninrinta kuchurparan. Chay runaqa sacerdotekunapa jefenta serviq runan karan. ");
INSERT INTO qveNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Chaymi Jesusqa Pedrota niran: —Chay espadaykita waqaychay. Dios Taytaymi ñak'arinaypaq noqataqa kamachimuwaran. ¿Chaychu noqari, chay ñak'ariyta mana chashkiyman? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Chay Roma llaqtayoq soldadokunan, jefenpiwan, hinallataq templota cuidaq guardiakunapiwan ima, Jesusta hap'ispa, makinta chaqnaspa, presota aparanku. ");
INSERT INTO qveNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Hinaspan primertaqa sacerdote Anaspa wasinman aparanku. Anasqa Caifaspa suegronmi karan. Chay watapin Caifasqa sacerdotekunapa jefen karan. ");
INSERT INTO qveNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Chay Caifasmi Israel nación llaqtapi kamachikuq jefekunata, ñawpaqtaraq consejaspa, khaynata niran: “Allinmi kanman huk runalla wañunanpaq, ashka runakuna nacionninchispi wañunanmantaqa”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedroqa Jesuspa huknin discipulonpiwanmi, Jesusta presota apaqtinku qepanta riranku. Pedrowan riq discipuloqa, sacerdotekunapa jefenwanmi reqsinakuran. Chayraykun Jesusta chay palacio wasipa pationman apayuqtinku, Pedrowan riq discipulopas chayman haykuran. Nota: Pedrota acompañaq discipuloqa, kay librota escribiq Juanmi karan. ");
INSERT INTO qveNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ichaqa Pedroñataqmi hawallapi qepakuran. Chaymi sacerdotekunapa jefenwan reqsinakuq discipuloqa ukhumantaña lloqsimuspa, punkupi cuidaq warmita niran, Pedrota palacio wasipa pationman haykuchinanpaq. Chayñan Pedroqa haykuran. ");
INSERT INTO qveNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Hinaqtinmi punkuta cuidaq warmiqa Pedrota khaynata tapuran: —¿Qanqa kay runapa huknin discipulonmá kashankí? nispa. Hinaqtinmi Pedroqa contestaran: —Noqaqa manan chay runapa discipulonchu kani, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Chayllapitaqmi sacerdotekunapa jefenpa sirvientenkunapas, hinallataq templota cuidaq guardiakunapas, chirimusqanrayku ninata ratachispanku muyuriqninpi q'oñikusharanku. Chaypin Pedropas paykunawan kushka q'oñikusharan. ");
INSERT INTO qveNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Sacerdotekunapa ñawpaq kaq jefen Anasmi Jesusta tapuran, pikunas discipulonkuna kasqanmanta, hinallataq imakuna yachachisqanmantawan ima. ");
INSERT INTO qveNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Chaymi Jesusqa contestaran: —Noqaqa alayritan llapallan runakunamanqa rimarani. Hinaspapas noqaqa sapa kutinmi templopi, hinallataq Diosmanta yachachina sinagoga wasikunapipas, Israel nacionniyoq llapallan runakuna uyarishaqtinku yachachirani. Noqaqa manan ni imatapas pakallapiqa rimaranichu. ");
INSERT INTO qveNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Chayri, ¿imanaqtintaq noqatari tapuwashankí? Sichus noqamanta imatapas yachayta munaspaykiqa, aswanyá chay uyariwaqniy runakunata tapumuy. Paykunan noqapa tukuy imakuna rimasqaykunamantaqa yachanku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Saynata niqtinmi templota cuidaq huknin guardiaqa, Jesusta uyanpi saqmaran. Hinaspan niran: —¿Saynatachu ninayki sacerdotekunapa jefenta? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Hinaqtinmi Jesusqa chay saqmaqnin guardiata contestaspa, khaynata niran: —Sichus mana allinkunata rimarani chayqa, niwayá mana allin rimasqaykunata. Ichaqa, sichus cheqaqta rimarani chayqa, ¿imanaqtintaq saqmawashankirí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Hinaqtinmi sacerdotekunapa ñawpaq kaq jefen Anasqa, Jesuspa makinkuna hina watasqallata, sacerdotekunapa jefen Caifasman apachiran. ");
INSERT INTO qveNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pedroqa kaqllapiraqmi ninaq ladonpi sayaspa q'oñikusharan. Hinaqtinmi paytaqa khaynata tapuranku: —Qanpas, ¿manachu chay runapa huknin discipulon kashankí? nispanku. Chaymi Pedroqa negaspa khaynata contestaran: —Noqaqa manan chay runapa discipulonchu kani, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Chaymantan sacerdotekunapa jefenta serviq runaqa, Pedrota rikuruspa tapullarantaq: —Noqaqa, ¿qantachus hina Jesuswan kushkata, huertapiqa rikusharaykí? nispa. Chay sirviente runaqa Malco sutiyoq runapa familianmi karan. Chay Malcotan Pedroqa ninrinta huertapi kuchuran. ");
INSERT INTO qveNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Chaymi Pedroqa kaqmanta negallarantaq. Hinaqtinmi chay ratolla galloqa waqaramuran. ");
INSERT INTO qveNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tutallamantan sacerdotekunapa jefen Caifaspa wasinmanta gobernador Poncio Pilatopa palacio wasinman Jesusta aparanku. Hinaspan Israel nacionniyoq runakunaqa costumbrenkuman hina chay palacio wasimanqa mana haykunankuchu karan, Poncio Pilato forastero runa kasqanrayku. Sichus forasterokunapa wasinman haykuspankuqa, manañan chay Pascua mikhunata mikhunankupaqqa limpioñachu kankuman karan. ");
INSERT INTO qveNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Chaymi Roma llaqtayoq gobernador Poncio Pilatoqa, hawaman lloqsimuspa, Jesusta acusaq runakunata tapuran: —Qankunari, ¿imamantataq kay runatari acusashankichís? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Hinaqtinmi paykunaqa contestaranku: —Sichus allin ruwaq runa kaqtinqa, manachá qanmanqa apamuykikumanchu karan, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Hinaqtinmi Poncio Pilatoqa niran: —Kay runataqa apakapuychis. Hinaspa qankunapa leyniykichisman hina juzgamuychis, nispa. Hinaqtinmi Israel nacionniyoq autoridad runakunaqa contestaranku khaynata: —Noqaykuqa manan autorizasqachu kayku, pitapas wañunanpaq sentencianaykupaqqa, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Saynapin cruzpi wañunanmanta Jesuspa nisqan cumplikuran. ");
INSERT INTO qveNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Saynata niqtinkun Poncio Pilatoqa palacio wasinman kaqmanta kutiyuspa, Jesusta waqyaspa, khaynata tapuran: —¿Qanchu kanki Israel nacionniyoq runakunapa reynin? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Chaymi Jesusqa huk tapukuywan contestaran: —Qanri, ¿kikillaykimantachu tapuwashankí? Icha, ¿hukkunachu noqamantari nisurankí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Hinaqtinmi gobernador Poncio Pilatoqa khaynata contestaran: —Noqari, ¿acaso Israel nacionniyoq llaqtamasiykichu kaní? Llaqtamasiyki runakunan, hinallataq sacerdotekunapa jefenkuna iman, qantaqa noqaman apamuwanku. Chayri, ¿ima mana allintataq paykunapa contranpiri ruwaramurankí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Hinaqtinmi Jesusqa contestaspa niran: —Noqaqa manan kay pachapi reykuna hina kamachiqchu kani. Sichus kay pachapi reykuna hina kayman chayqa, noqapa discipuloykunan noqarayku peleaspanku defiendewanman, saynapi Israel nacionniyoq jefekunaman ama entregawanankupaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Hinaqtinmi gobernador Poncio Pilatoqa niran: —Saynaqa, ¿reychu kankí? nispa. Hinaqtinmi Jesusqa contestaran: —Qanmi niwashanki: “Reymi kanki”, nispaqa. Noqaqa kay pachaman hamuspan nacerani, hinaspan kay pachapi runakunaman cheqaq kaqmanta willarani. Chaymi pipas cheqaq kaqta mashkaqqa, willakusqaytapas uyarin, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Saynata niqtinmi gobernador Poncio Pilatoqa tapuran: —¿Imataq chay cheqaq kaqrí? nispa. Saynata Jesusta tapuruspanmi, Poncio Pilatoqa palacio wasinpa punkunman kaqmanta lloqsimuspa, Israel nacionniyoq runakunata niran: —Kay runapiqa manan ni ima huchatapas tarinichu. ");
INSERT INTO qveNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ichaqa qankunapa costumbreykichisman hinan, noqaqa Pascua fiesta p'unchawpi huk presota kacharini. Chayri, ¿qankuna munankichishchu Israel nación llaqtapa reyninta kacharipunayta? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Saynata Poncio Pilato niqtinmi, llapallan runakunaqa khaynata qaparispa niranku: —¡Chay runataqa ama kachariychu! ¡Aswanqa Barrabás runata kacharipuy! nispanku. Chay Barrabasqa criminal suwa runan karan. ");
INSERT INTO qveNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Saynata niqtinkun gobernador Poncio Pilatoqa Jesusta latigachiran. ");
INSERT INTO qveNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Chaymantan Roma llaqtayoq soldadokunaqa, kishkamanta coronata ruwaspanku, Jesuspa umanman churaranku. Saynallataqmi reykunapa churakunan nina sansa color capawanpas burlakunankupaq churaranku. ");
INSERT INTO qveNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Hinaspan ashuyuspa, khaynata niranku: —¡Kawsachun Israel nacionniyoq runakunapa reynin! nispanku. Saynata nispankun paykunaqa uyankunapi saqmaranku. ");
INSERT INTO qveNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Hinaqtinmi Poncio Pilatoqa kaqmanta palacio wasimanta lloqsimuspa, runakunata nillarantaq: —¡Qawariychis! Manan kay runapiqa ni ima huchatapas tarinichu. Chaymi kaqmanta qankunaman orqomushani, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Hinaqtinmi Jesustaqa kishkamanta ruwasqa coronawan churayusqata, hinallataq reypa churakunan nina sansa color capawan churasqata ima orqomuranku. Hinaspan Poncio Pilatoqa runakunata niran: —¡Kayqayá kay runaqa! nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Chaymi sacerdotekunapa jefenkuna, hinallataq templota cuidaq guardiakunapiwan, Jesusta rikuruspanku, altota qaparispa niranku: —¡Cruzpi chakatachiy! ¡Cruzpi chakatachiy! nispanku. Chaymi Poncio Pilatoqa niran: —¡Kay runataqa apakapuychis; hinaspa qankuna chakatamuychis! Manan noqaqa wañunanpaq hinaqa ni ima huchatapas paypiqa tarinichu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Saynata Poncio Pilato niqtinmi, chaypi huñunasqa runakunaqa niranku: —Chay runaqa: “Diospa Wawanmi kani”, nisqanraykun leyniykuman hina wañunan, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Hinaqtinmi Poncio Pilatoqa chay nisqankuta uyarispa, astawan mancharikuran. ");
INSERT INTO qveNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Chaymi Poncio Pilatoqa palacio wasiman kaqmanta kutiyuspa, Jesusta tapuran: —¿Maymantataq qanri kankí? nispa. Hinaqtinmi Jesusqa mana ni imatapas contestaranchu. ");
INSERT INTO qveNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Chaymi Poncio Pilatoqa niran: —¿Manachu ni imatapas contestawankí? Qanri, ¿manachu yachanki kacharipunaypaq otaq cruzpi chakatachinaypaq atiyniyoq kasqaytarí? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Hinaqtinmi Jesusqa contestaran khaynata: —Qan noqata condenawanaykipaqqa manan ni ima atiyniyoqchu kawaq, sichus Dios atiyta mana qosunkimanchu chayqa. Chayraykun wañunaypaq entregawaqniy runakunaqa, aswan más huchayoq qanmantaqa, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Chaymi chay ratomantapacha Poncio Pilatoqa Jesusta kacharipuytapuni munaran. Ichaqa chaypi kaq Israel nacionniyoq runakunañataqmi astawanraq altota qaparispanku, khaynata niranku: —¡Sichus chay runata kacharipunki chayqa, manan Rey Cesarpa amigonchu kanki! ¡Pipas “reymi kani” niqqa, Roma llaqtamanta llapallan nación llaqtakunata kamachikuq rey Cesarpa contranpin kashan! nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Saynata niqtinkun, Poncio Pilatoqa kamachiran, chay palacio wasi ukhumanta Jesusta hawaman orqonankupaq. Hinaspan Poncio Pilatoqa justicia ruwana sillapi tiyayuran. Chay tiyanan lugartan hebreo rimaypiqa suticharanku “Gabata” nisqa sutiwan, rumiwan empedrasqa kasqanrayku. ");
INSERT INTO qveNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Huk p'unchawllañan Pascua fiesta ruwanankupaq faltasharan. Chaymi chawpi p'unchaw horas hinaña kashaqtin, Poncio Pilatoqa Israel nacionniyoq runakunaman khaynata niran: —¡Qankunapa reyniykichisqa kayqayá! nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Hinaqtinmi chaypi runakunaqa altota qaparispa niranku: —¡Cruzpi chakatasqa wañuchun! ¡Cruzpi chakatasqa wañuchun! nispanku. Chaymi Poncio Pilatoqa niran: —¿Cheqaqtapunichu reyniykichista cruzpi chakatachinayta munashankichís? nispa. Sacerdotekunapa jefenkunañataqmi khaynata niranku: —Noqaykupaqqa manan kanmanchu huk reyqa. Roma llaqtamanta rey Cesarllan noqaykupa reyniykuqa, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Hinaqtinmi Poncio Pilatoqa, Jesusta cruzpi chakatanankupaq paykunaman entregaran. Chaymi soldadokunaqa Jesusta aparanku. ");
INSERT INTO qveNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesusqa chakatanankupaq cruzta wikriyukuspanmi, Calavera nisqa moqo pataman riran. Chay Calavera moqotan hebreo rimaypiqa “Gólgota” nispa suticharanku. Nota: Chay sutikunaqa “uma tullu lugar”, ninantan nin. ");
INSERT INTO qveNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Chay lugarpin Jesustaqa cruzpi clavaspa chakataranku. Saynallataqmi ishkay runakunatapas chakatallarankutaq, hukninta Jesuspa phaña ladonpi, huknintataq lloq'e ladonpi. ");
INSERT INTO qveNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Saynallataqmi Poncio Pilatoqa, huk letrerota escribichispa cruzpa puntanpi churachillarantaq, khayna niqta: “kaymi nazaret llaqtayoq jesús. paymi israel nacionniyoq runakunapa reynin”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Chay chakatasqanku moqoqa, Jerusalén llaqtapa cercallanpin karan. Chaymi Israel nacionniyoq ashka runakunaqa cruzpi churasqanku letrerota leeranku. Chay letreroqa kinsa clase rimaypin escribisqa karan: hebreo rimaypi, griego rimaypi, hinallataq latín rimaypiwan ima. ");
INSERT INTO qveNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Chaymi sacerdotekunapa jefenkunaqa Poncio Pilatota niranku: —“Israel nacionniyoq runakunapa Reynin”, nispaqa ama escribichiwaqchu karan. Aswanqa khayna niqta escribichiwaq karan: “Kay runaqa niran: ‘Noqaqa Israel nacionniyoq runakunapa Reyninmi kani’ ”, niqta. ");
INSERT INTO qveNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Hinaqtinmi Poncio Pilatoqa niran: —Ñan escribisqaña kashan; chaytaqa manan ni pipas cambianmanñachu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Chay soldadokunaqa Jesusta chakataruspankun, p'achankunata tawaman partispa rakinakuranku. Saynallataqmi mana costurayoq túnica p'achantapas hap'ispanku, ");
INSERT INTO qveNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","soldadokunaqa ninakuranku khaynata: —Kay tunicataqa ama partisunchu. Aswanqa kay tunicapa hawanpi sorteasunchis mayqenninchismanpas tupawananchispaq, nispanku. Saynapin Bibliapi khayna escribisqa cumplikuran: “P'achaykunatan partispa paykunapura rakinakuranku. Hinallataqmi túnica p'achaytapas sorteanakuranku”, nispa nisqan Salmos 22.18. Saynatan soldadokunaqa ruwaranku. ");
INSERT INTO qveNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesusta chakatasqanku cruzpa cercanpin kasharanku Jesuspa mamitan María, Jesuspa tían, Cleofaspa warmin María, hinallataq Magdala llaqtamanta Mariapiwan ima. ");
INSERT INTO qveNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Chaymi Jesusqa mamitanta, hinallataq ancha khuyakusqan discipulontawan rikuspa, khaynata niran: —Mamitáy, chaypin wawaykiqa kashan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Saynata niruspanmi, Jesusqa chay ancha khuyasqan discipulonta niran: —Chaypin mamitaykiqa kashan, nispa. Hinaqtinmi chay ancha khuyakusqan discipulonqa, chay ratomantapacha Jesuspa mamitanta wasinman pusaran. ");
INSERT INTO qveNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jesusqa Diospa kamachisqankuna cumplikusqantaqa ñan yacharanña. Chaymi Bibliapi escribisqa cumplikunanpaq niran: —Ch'akiwashanmi, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Chaypin huk p'uyñupi hunt'a qatqe vinagre kasharan. Chaymi huk k'aspipa puntanman esponjata wataranku. Hinaspan chay vinagreman challpuyuspanku, Jesuspa siminman aypachiranku. Nota: Chay qatqe vinagreqa, pobre runakunapa tomananpaqmi karan. Chaytan Jesusmanqa ch'akichikuqtin, tomachiyta munaranku. ");
INSERT INTO qveNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Hinaqtinmi Jesusqa chay qatqe vinagreta malliyuspa, khaynata niran: —¡Tukuy imapas ñan cumplirukunña! nispa. Hinaspan umanta k'umuykachispa, Jesusqa chay ratopi wañuran. ");
INSERT INTO qveNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Jesuspa wañusqan p'unchawqa viernesmi karan. Paqarisnintin p'unchawñataqmi Pascua fiesta p'unchaw karan. Chaymi Israel nacionta kamachiq runakunaqa, chay kinsantin runakuna cruzpi chakatasqa kanankutaqa mana munarankuchu, samana p'unchaw kasqanrayku. Chaymi Poncio Pilatoman rispanku, payta ruegakuranku, cruzpi chakatasqa runakunapa piernankunata p'akimunankupaq, saynapi lukullaman wañuruqtinku, chay cruzmanta cuerponkuta orqonankupaq. ");
INSERT INTO qveNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Chaymi chay soldadokunaqa rispanku, Jesuswan kushka chakatasqa ishkaynin runakunapa piernankunata p'akimuranku. ");
INSERT INTO qveNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Saynallataqmi Jesuspa piernantapas p'akinankupaq ashuyuranku. Hinaspan cuentata qokuranku, Jesusqa ña wañusqaña kasqanta. Chayraykun Jesuspa piernantaqa manaña p'akirankuñachu. ");
INSERT INTO qveNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ichaqa huknin kaq soldadotaqmi, Jesuspa waqtanta fierro puntayoq largo k'aspiwan sat'iran. Hinaqtinmi Jesuspa waqtanmanta yawar, hinallataq unupas lloqsimuran. ");
INSERT INTO qveNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Noqan kani Jesuspa discipulon Juan). Chaymi, chaykuna pasasqanta kikiypuni rikuspay, qankunaman escribimushaykichis cheqaqpuni kasqanmanta, saynapi qankunapas Jesuspi creenaykichispaq. ");
INSERT INTO qveNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ichaqa chaykunaqa pasaran Bibliapi khayna nisqan cumplikunanpaqmi. Bibliapin nishan: “Manan ni huk tullullanpas p'akisqachu kanqa”, nispa Salmos 34.20. ");
INSERT INTO qveNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Saynallataqmi Bibliapiqa nillashantaq: “Waqtanpi sat'isqanku runatan, runakunaqa qawanqaku”, nispa Zacarías 12.10. ");
INSERT INTO qveNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","José sutiyoq runan Arimatea llaqtamanta karan. Paymi Israel nacionta kamachiq llaqtamasin runakunata manchakuspa, Jesuspa discipulon secretollapi karan. Chay Joseymi cruzpi Jesús wañuruqtin, Poncio Pilatoman rispa ruegakuran, Jesuspa cuerponta cruzmanta urayachispa p'ampaq apananpaq. Chaymi Poncio Pilatoqa Joseyman permisota qoran. ");
INSERT INTO qveNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Saynallataqmi Nicodemopas kinsa chunka kilo hina sumaq q'apaq mirra nisqa perfumeta, hinallataq áloes nisqa perfumekunata apayukuspa hamullarantaq. Paymi karan, Jesuswan parlananpaq ñawpaqtaraq tutalla hamuq runa. ");
INSERT INTO qveNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Hinaspan Joseyqa Nicodemopiwan kushka, huk fino telamanta ruwasqa hatun vendakunata chay sumaq q'apaq perfumewan chapuspanku, Jesuspa cuerponta chay vendakunawan p'isturanku. Saynataqa ruwaranku, Israel nacionniyoq runakunapa costumbrenku sayna kasqanraykun. ");
INSERT INTO qveNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesusta cruzpi chakatasqankupa ladonpin huk huerta karan. Chay huertapin huk mosoq sepultura karan. Chay sepulturapiqa manan ni pi runatapas p'amparankuraqchu. ");
INSERT INTO qveNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Chay sepulturamanmi cercalla kasqanrayku Jesuspa cuerponta p'ampamunankupaq aparanku. Saynataqa ruwaranku, Israel nacionniyoq runakunapa samananku p'unchaw yaqaña qallarisqanraykun. Nota: Samana p'unchawqa Israel nacionniyoq runakunapaqqa, soqta horas viernes tardentan qallariran. Tukurantaqmi soqta horas sábado tardenta. ");
INSERT INTO qveNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Domingo p'unchawtan manaraq achiqamushaqtin, Magdala llaqtayoq Mariaqa, Jesusta p'ampasqanku sepulturaman riran. Chayman chayaruspanmi Mariaqa rikururan, rumiwan tapasqanku sepulturaqa kichasqaña kasqanta. ");
INSERT INTO qveNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Chaymi Mariaqa apurayllaman p'itaspa, Simón Pedroman hinallataq Jesuspa munakusqan discipulonmanwan, khaynata willamunanpaq riran: —¡Señor Jesuspa cuerpontan p'ampasqa kasqanmanta orqoruspa aparpasqaku. Ichaqa mayman apasqankutapas manan yachaykuchu! nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Chaymi Pedroqa Jesuspa ancha khuyasqan discipulopiwan, sepultura qawaq p'itayllaña riranku. ");
INSERT INTO qveNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ichaqa huknin kaq discipuloqa, Pedromanta aswan masta p'itaspanmi, primerta sepulturaman chayaran. ");
INSERT INTO qveNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Chayaspantaqmi k'umuyuspa sepultura ukhuta qawayuran. Hinaspan Jesuspa cuerpon p'istusqanku vendallataña rikuran. Ichaqa manan chay sepultura ukhumanqa haykuranchu. ");
INSERT INTO qveNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Saynata qawapayashaqtinmi, Simón Pedroqa chayamuspa, sepultura ukhuman haykuran. Hinaspan paypas p'istusqanku vendallataña rikuran. ");
INSERT INTO qveNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Saynallataqmi Jesuspa uman p'istusqanku telatapas, chay vendapa ladonpi rollosqata rikuran. ");
INSERT INTO qveNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Saynallataqmi primerta sepulturaman chayamuq discipulopas, chay sepultura ukhuman haykullarantaq. Hinaspan paypas chaykunata rikuspa creeran. ");
INSERT INTO qveNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ichaqa chay p'unchawkamaqa, chay discipulokunaqa manaraqmi entienderankuraqchu, Bibliapi nisqanman hina Jesuspa kawsarimunanmantaqa. ");
INSERT INTO qveNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Hinaqtinmi chay ishkaynin discipulokunaqa, maypi kasqankuman kutipuranku. ");
INSERT INTO qveNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Magdala llaqtayoq Mariaqa sepultura punku hawallapin waqaspa kasharan. Chaypi waqashaspanmi, Mariaqa k'umuyuspa Jesuspa cuerpon churasqanku sepultura ukhuta qawayuran. ");
INSERT INTO qveNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Hinaspan Mariaqa ishkay angelkunata sumaq yuraq p'achawan p'achasqata chaypi rikuran. Huknin angeltan rikuran, Jesuspa cuerpon churasqanku uman ladopi tiyashaqta, huknintañataq hayt'an ladopi tiyashaqta. ");
INSERT INTO qveNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Hinaqtinmi chay angelkunaqa Mariata, khaynata tapuranku: —Qanri, ¿imanaqtintaq waqashankirí? nispanku. Chaymi Mariaqa contestaran: —Señor, Señorniypa cuerpontan p'ampasqa kasqanmanta aparpasqaku. Ichaqa manataqmi cuerponta mayman apasqankutapas yachanichu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Saynata niruspanmi, Mariaqa kutirimuspa hinalla, Jesusta chaypi sayashaqta rikururan. Ichaqa manataqmi Jesús kasqantaqa yacharanchu. ");
INSERT INTO qveNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Hinaqtinmi Jesusqa Mariata khaynata tapuran: —Qanri, ¿imanaqtintaq waqashankirí? ¿Pitataq mashkashankirí? nispa. Saynata tapuqtinmi, Mariaqa piensaran chaypi huertata cuidaq runa kananpaq. Chaymi khaynata tapuran: —Señor, ¿Señorniy Jesuspa cuerpontaqa icha qanchu aparurankipas? Sichus aparuspaykiqa, willaykuwayá, mayman churamusqaykitapas, noqa rispay Señorniypa cuerponta apakanpunaypaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Chaymi Señor Jesusqa niran: —¡María! nispa. Chaymi Mariaqa, pay lawman kutirispa, Jesús kasqanta reqsiruran. Hinaspan niran: —¡Raboni! nispa. Chay rimayqa “yachachikuq maestro” ninantan nin. Nota: Wakin Bibliakunapin ninku: “hebreo rimaypi”, nispa; wakinpitaqmi ninku “arameo rimaypi”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Hinaqtinmi Jesusqa niran: —Kachariway. Noqaqa hanaq pachapi Papaymanqa manaraqmi kutiniraqchu. Aswanqa kunan rispaykiyá discipuloykunaman willamuy khaynata: “Noqaqa Dios Taytaymanmi kutishani; payqa qankunapapas Dios Taytaykichismi. Hinaspapas payqa Diosniymi, saynallataqmi qankunapapas Diosniykichis”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Chaymi Magdala llaqtayoq Mariaqa, Jesuspa discipulonkunapa kasqanman rispa, paykunaman willamuran, Señor Jesusta rikumusqanmanta, hinallataq tukuy imakunata Jesús payman nisqanmantawan ima. ");
INSERT INTO qveNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Jesuspa kawsarimusqan domingo p'unchaw tutatan, discipulonkunaqa punkuta allinta wishq'arukuspanku, huk wasipi huñunasqa kasharanku. Sayna wishq'asqa ukhupiqa kasharanku, Israel nación llaqtayoq runakunapa jefenkunata manchakusqankuraykun. Hinaqtinmi Jesusqa chay ratopi paykunaman rikhuriykuran; hinaspan chawpinkupi sayaykuspa, khaynata niran: —Hawkayay qankunawan kachun, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Chayta nispanmi, Jesusqa makinkunapi, hinallataq waqtanpi k'irikunata paykunaman rikuchiran. Chaymi paykunaqa, Señor Jesusta rikuspanku, anchata kusikuranku. ");
INSERT INTO qveNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Hinaspan Jesusqa kaqmanta paykunata nillarantaq: —Hawkayay qankunawan kachun. Imaynan noqata Dios Taytaypas mandamuwaran, saynallatataqmi noqapas qankunata kachaykichis noqamanta willamunaykichispaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Saynata rimayta tukuruspanmi, Jesusqa discipulonkunaman phukuyuspa niran: —Santo Espirituta chashkiychis. ");
INSERT INTO qveNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Sichus runakuna huchallikuqtin, qankuna perdonankichis chayqa, perdonasqan kanqaku. Sichus qankuna mana perdonankichishchu chayqa, manan perdonasqachu kanqaku, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomasqa Jesuspa chunka ishkayniyoq discipulonkunamanta huknin kaq discipulonmi karan. Paytan Mellizo sutiwan suticharanku. Hinaqtinmi discipulonkunaman Jesús rikhurishaqtin, Tomasqa mana paykunawan kushkachu karan. ");
INSERT INTO qveNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ichaqa Tomás chayaramuqtinmi, wakinnin discipulokunaqa payman willaranku khaynata: —¡Señor Jesustan rikuruyku! nispanku. Hinaqtinmi Tomasqa khaynata niran: —Sichus makinkunapi clavoq haykusqanta mana rikusaqchu, nitaq dedoytapas chay clavoq haykusqanman mana winasaqchu, hinallataq waqtanta k'irisqankumanpas makiyta mana winasaqchu chayqa, manan noqaqa creesaqchu, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Chaymanta pusaq p'unchaw pasaruqtinmi, Jesuspa discipulonkunaqa Tomaspiwan chay wasipi kaqmanta huñunasqa kasharanku, chay wasipa punkunta allinta wishq'arukuspanku. Hinaqtinmi Jesusqa paykunapa chawpinkupi rikhurispa khaynata niran: —Hawkayay qankunapi kachun, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Saynata niruspan, Jesusqa Tomasta khaynata niran: —Tomás, qaway makiykunata; hinaspa winay kayman dedoykita; hinallataq waqtaymanpas makiykita winay. Ama mana creeqqa kaychu, aswanqa creeq runa kay, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Chaymi Tomasqa khaynata niran: —¡Qanqa Señorniymi, hinaspapas Diosniymi kanki! nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Chaymi Señor Jesusqa khaynata niran: —Tomás, ¿qanqa rikuruwaspaykichu chayraq noqapi creeshankí? ¡Mayna kusisqan kanqaku, mana rikuwashaspa noqapi creeq runakunaqa! nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesusqa discipulonkunapa rikusqanmi ashka milagrokunatapas ruwallarantaq. Chay milagrokuna ruwasqanqa manan llapallanchu kay libropiqa escribisqa kashan. ");
INSERT INTO qveNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ichaqa kaykunaqa escribisqa kashan, qankuna leespaykichis, Jesusqa Diosmanta Hamuq Salvadorninchis kasqanta creenaykichispaqmi, hinaspapas payqa Diospa Wawan kasqanta yachanaykichispaqmi, saynapi Jesucristopi qankuna creespaykichis, wiñay kawsayniyoq kanaykichispaq. ");
INSERT INTO qveNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Chaymantan Jesusqa huktawan discipulonkunaman rikhuriran Galilea provincia lawpi Tiberias sutiyoq laguna qochapa patanpi. Chay lugarpin kaykuna pasaran: ");
INSERT INTO qveNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Chaypin huñunasqa kasharanku Jesuspa kay discipulonkuna: Simón Pedro, Mellizowan sutichasqa Tomás, Galilea lawpi Caná llaqtamanta Natanael, Zebedeopa wawankuna, hinallataq ishkay discipulokunapiwan ima. ");
INSERT INTO qveNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Hinaqtinmi Simón Pedroqa chaypi kaq wakin discipulokunata, khaynata niran: —Challwata challwaqmi risaq, nispa. Chaymi paykunapas nillarankutaq: —Noqaykupas qanwanmi risaqku, nispanku. Chaymi paykunaqa huk boteman wichaspa riranku. Ichaqa enteron tuta challwashaspankupas, paykunaqa manan ni huk challwallatapas hap'irankuchu. ");
INSERT INTO qveNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Hinaqtinmi ña achiqamushaqtinña, Jesusqa chay challwasqanku laguna qochapa patanpi sayasharan. Ichaqa chay discipulonkunaqa, Jesusta rikushaspankupas manan reqsirankuchu. ");
INSERT INTO qveNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Hinaqtinmi Jesusqa paykunata tapuran: —Wawqellaykuna, ¿mikhunaykichispaq imallaykichispas kashanchú? nispa. Chaymi paykunaqa contestaranku: —Manan kanchu ni imaykupas, nispanku. ");
INSERT INTO qveNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Chaymi Jesusqa khaynata niran: —Botepa phaña ladonman challwanaykichis mallata wikch'uyuychis. Hinaspan qankunaqa challwata hap'inkichis, nispa. Hinaqtinmi Jesuspa nisqanman hina ruwaranku. Chaymi challwananku malla ashkallaña challwayoq kasqanrayku, manaña ni chutaytapas atirankuñachu. ");
INSERT INTO qveNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Jesuspa munakusqan discipuloñataqmi, Jesús kasqanta reqsiruspa, Pedrota niran: —¡Payqa Señorninchis Jesusmi! nispa. Chaymi Simón Pedroqa Señor Jesús kasqanta yacharuspa, q'ala wasalla kasqanrayku apurayllaman p'achakuspa, unu ukhuman saltaykuran. ");
INSERT INTO qveNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ichaqa pachaq metro hinallañan laguna qochapa patanman chayamunankupaqqa faltasharan. Hinaqtinmi wakin discipulonkunaqa botepi hamuranku, challwa challwamusqankuta laguna qochapa patankama mallapi aysamuspanku. ");
INSERT INTO qveNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Hinaspan laguna qochapa patanman lloqsimuspanku, nina sansapa hawanpi huk challwata rikuranku, chaypa ladonpitaq t'antatawan ima. ");
INSERT INTO qveNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Hinaqtinmi Jesusqa khaynata niran: —Challwa hap'imusqaykichista apamuychis, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Chaymi Simón Pedroqa boteman qespispa, challwa hap'inan mallata hunt'a challwayoqta laguna qochapa patanman chutamuran. Chay mallapiqa pachaq pishqa chunka kinsayoq hatun challwakunan karan. Sayna ashka challwata chutamushaqtinpas, chay challwanan mallaqa manan llik'ikuranchu. ");
INSERT INTO qveNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Hinaqtinmi Jesusqa khaynata niran: —Mikhunanchispaq hamuychis kayman, nispa. Ichaqa manataqmi ni mayqen discipulonpas tapuytaqa atirankuchu, “¿pitaq qanri kankí?” nispaqa. Hinaspapas paykunaqa ñan yacharankuña Señor Jesús kasqantaqa. ");
INSERT INTO qveNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Hinaqtinmi Jesusqa paykunaman ashuyuspa, t'antatawan hinallataq kankasqa challwatawan paykunaman rakiran. ");
INSERT INTO qveNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jesusqa kawsarimusqan p'unchawmantaqa, kinsa kutitañan kay rikhuriywanqa, discipulonkunaman rikhuriran. ");
INSERT INTO qveNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Discipulonkuna mikhuyta tukuruqtinkun, Jesusqa Simón Pedrota khaynata tapuran: —Jonaspa wawan Simón, ¿wakin discipuloykunamanta aswan mastachu khuyakuwankí? nispa. Pedroñataqmi contestaran: —Arí Señor. Qanqa yachankin khuyakusqaytaqa, nispa. Chaymi Jesusqa niran: —Cheqaqtapuni khuyawaspaykiqa, noqapi chayraq creeq runakunatayá, corderokunata hina allinta cuidamuy, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Hinaqtinmi Jesusqa kaqmanta tapullarantaq: —Jonaspa wawan Simón, ¿khuyakuwankichú? nispa. Chaymi Pedroqa contestaran khaynata: —Arí Señor. Qanqa yachankin khuyakusqayta, nispa. Hinaqtinmi Jesusqa niran: —Saynaqa noqapi creeq runakunatayá cuidamuy, imaynan ovejakunata cuidaq runa hina, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Hinaqtinmi Jesusqa huktawan kinsa kaq tapuypi, Pedrota niran: —Jonaspa wawan Simón, ¿khuyakuwankichú? nispa. Chaymi Pedroqa kinsa kutikamaña “khuyakuwankichu” nispa Jesús tapupayasqanrayku, anchata llakikuran. Hinaspan khaynata niran: —Señor, qanqa tukuy imatapas yachankin. Hinaspapas yachallankitaqmi noqa qanta khuyakusqaytaqa, nispa. Hinaqtinmi Jesusqa niran: —Saynaqa noqapi creeq runakunatayá cuidamuy, imaynan ovejakunata cuidaq runa hina, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Jesusqa nillarantaqmi khaynata: —Cheqaqtapunin niyki, jovenllaraq kashaspaykiqa kikillaykin p'achakuranki; hinaspan may munasqaykiman ima rirankipas. Yuyaqña kaqtiykin ichaqa, makiykimantapas hukraq aysarisunki, hinallataq p'achachisunkipas; hinaspan pusasunkipas mana riy munasqayki lugarkunaman, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Saynata nispanmi Jesusqa entiendechiran, imaynatas Pedro wañunanmanta, saynapi Dios alabasqa kananpaq. Hinaspan Jesusqa Pedrota niran: —¡Qatikuway! nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedroqa Jesuswan rishaspanmi, qepanta qawarikuran. Hinaspan Jesuspa munakusqan discipulonta qepankuta hamushaqta rikuran. Chay munakusqan discipulonmi, ñawpaqtaraq Pascua cenaypi mikhusqanku rato, Jesuspa qasqonman k'imiyukuspa kasharan. Hinaspan khaynata tapuran: “Señorlláy, ¿mayqenniykutaq traicionasunkirí?” nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Hinaspanmi Pedroqa chay discipulota rikuruspa, Jesusta khaynata tapuran: —Señorlláy, ¿imataq paytari pasanqa? nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Chaymi Jesusqa khaynata contestaran: —Sichus munayman chayqa, kutimunaykamapas payqa kawsanmanmi; qanmanri, ¿imataq qokusunkí? Qanqa qatikullawayá, nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Saynata niqtinmi, discipulokunaqa paykunapura rimaranku khaynata: “Chay discipuloqa manas wañunqachu” nispanku. Ichaqa Jesusqa manan niranchu: “Manan wañunqachu”, nispachu. Aswanqa khaynatan niran: “Sichus munayman chayqa, kutimunaykamapas payqa kawsanmanmi; qanmanri, ¿imataq qokusunkí?” nispa. ");
INSERT INTO qveNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Noqan chay ancha munakusqan discipuloqa kani. Chaymi noqa kikiy, Jesuspa tukuy ima ruwasqankunamanta kay libropi escribimushaykichis. Hinaspapas noqaykuqa yachaykun, kay libropi llapallan escribisqakunaqa cheqaqpuni kasqanta. ");
INSERT INTO qveNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesusqa ashkatan tukuy imakunatapas ruwaran. Sichus sapankama ruwasqankunamanta escribikunman chayqa, piensasqayman hinaqa, manan kay enteron pachapipas campoqa kanmanchu, chay llapallan librokuna churanapaqqa. Amén.");
INSERT INTO qveNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ancha respetasqay Teófilo, primer kaq librota qanman escribimuspaymi, ña willamuraykiña Jesuspa llapallan imapas ruwasqanmanta, hinallataq yachachisqankunamantawan ima. ");
INSERT INTO qveNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Jesusqa hanaq pachaman manaraq ripushaspanmi, akllasqan apostolninkunata Santo Espiritupa atiyninwan kamachiran, tukuy imakunatapas imayna ruwanankupaq. Chaykunatan qanmanqa escribimurayki imakunatas Jesús ruwaran ñawpaqta, qallariyninmantapacha asta hanaq pachaman Jesús ripunan p'unchawkama tukuy imakuna ruwasqanmanta. ");
INSERT INTO qveNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jesusqa wañusqanmanta kawsarimuspanmi, apostolninkunaman rikhuriran. Hinaspan cheqaqtapuni kawsasqanta yachanankupaq paykunaman presentakuspa, pay kikinpuni rikuchikuran, tukuy ima pruebakunawan paypuni kasqanta. Hinaspan Jesusqa tawa chunka p'unchaw apostolninkunawan kaspa, Diospa gobiernanan sumaq glorianmanta paykunaman yachachiran. ");
INSERT INTO qveNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Jesusqa huk kutinmi apostolninkunawan kushka kashaspa, paykunata khaynata kamachiran: —Jerusalén llaqtamantaqa aman ripunkichishchu. Aswanqa Diospa prometesqan Santo Espirituta chashkinaykichiskaman suyankichis. Noqaqa chay Santo Espiritumantan rimapayaraykichishña ");
INSERT INTO qveNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","khaynata: “Bautizaq Juanqa unullawanmi bautizaran. Ichaqa qankunan Santo Espirituwan kay pisi p'unchawkunallapi bautizasqa kankichis”, nispa. ");
INSERT INTO qveNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jesusqa apostolninkunawanmi kushka huñunasqa kasharan. Hinaqtinmi apostolninkunaqa Jesusta tapuranku khaynata: —Señor, ¿qanri kay p'unchawkunapichu (Roma nacionmanta kamachikuqkunata vencespayki), kay Israel nación llaqtaykupi reyniyku kankí? nispanku. ");
INSERT INTO qveNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Hinaqtinmi Jesusqa apostolninkunata contestaspa niran: —Manan qankunamanchu tupasunkichis ima p'unchawtachus chaykuna pasananmanta yachanaykichispaqqa. Aswanqa ancha atiyniyoq Dios Taytallaymi yachan ima tiempopichus otaq ima p'unchawtachus chaykuna pasananmantaqa. ");
INSERT INTO qveNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ichaqa Santo Espíritu qankunaman hamuqtinmi, atiyta chashkinkichis. Hinaspan qankunaqa testigoykuna kankichis: kay Jerusalén llaqtapi, Judea provinciapi, Samaria provinciapi, hinallataq kay pachapi llapallan llaqtakunapipas, runakunaman noqamanta willamunaykichispaq, nispa. ");
INSERT INTO qveNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Chaykunata rimayta tukuruspanmi, apostolninkuna rikushaqtin, Jesusqa hanaq pacha cieloman ripuran. Chaymi phuyu ukhuman chinkaykuqtin, apostolninkunaqa manaña rikurankuñachu. ");
INSERT INTO qveNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Hinaqtinmi Jesuspa apostolninkuna alto cielota qawallashaqtinkuraq, ishkay runakuna yuraq p'achayoqkama apostolkunapa ladonkupi qonqayllamanta rikhuriykuran. Hinaspan apostolkunata niranku: ");
INSERT INTO qveNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","—Galilea provincia lawmanta runakuna, ¿imanaqtintaq qankunari alto cielota qawashankichís? Imaynan Jesuspa hanaq pachaman ripusqanta kunan rikushankichis, saynallataqmi Jesusqa huk p'unchaw hanaq pachamanta kay pachaman kutimunqa, nispa. Nota: Chay ishkay yuraq p'achayoq runakunaqa Diospa angelninkunan karanku. ");
INSERT INTO qveNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Chaymantan apostolkunaqa Olivos moqopi kasqankumanta, Jerusalén llaqtaman kutipuranku. Chay Olivos moqoqa huk kilómetro hinallan Jerusalén llaqtamantaqa karan. ");
INSERT INTO qveNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Hinaspan apostolkunaqa Jerusalén llaqtaman chayaruspanku, samapakusqanku wasipa altosninman wicharanku. Chaypin karanku: Pedro, Jacobo, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Alfeopa wawan Jacobo, Zelote partidomanta Simón, hinallataq huk Jacobopa wawan Judaspiwan ima. Nota: Kay Judasqa manan Jesusta traicionaspa wañuq Judas Iscariotechu karan. Aswanqa huk Judasmi. ");
INSERT INTO qveNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Chaypin llapallanku huk sonqolla huñunasqa karanku: apostolkuna, Jesuspa mamitan María, Jesuspa wawqenkuna, hinallataq huk warmikunapiwan ima. Hinaspan paykunaqa Diosmanta mana dejaspa mañakuranku. ");
INSERT INTO qveNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Hinaqtinmi chay p'unchawkunapi, Diospi iñiq runakunaqa pachaq ishkay chunka hina huñunakuranku. Hinaqtinmi Pedroqa paykuna ukhumanta sayarispa, khaynata niran: ");
INSERT INTO qveNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Wawqe panaykuna, Bibliapi nisqanmi cumplikunanpuni karan. Chaytan ñawpaqtaraq Santo Espíritu rey Davidnintakama ña niranña, Jesusta Judas Iscariote traicionananmantaqa. Chay Judasmi Jesuspa enemigon runakunata pusamuran, Jesusta presochanankupaq. ");
INSERT INTO qveNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Hinaspapas chay Judasqa noqanchis apostolkunawan kushka yupasqan karan. Chaymi payqa noqanchiswan kushka llank'aranpas. ");
INSERT INTO qveNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Chay Judasmi, Jesusta traicionasqanmanta pagasqanku qolqewan, huk chakrata rantiran. Chaypin Judasqa umanpan pampaman urmayuqtin, wiksanraq phataran. Hinaqtinmi ch'unchulninkunaraq lloqsiran. ");
INSERT INTO qveNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Hinaqtinmi Jerusalén llaqtapi tiyaq runakunaqa, Judaspa sayna wañusqanta yacharanku. Chaymi chay chakrataqa suticharanku “Acéldama”, nispa. Aceldamaqa “Yawar pampa chakra” ninantan nin. ");
INSERT INTO qveNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Judasta kaykuna pasananmantaqa, ñan Salmos libropi escribisqaña kasharan. Chay Salmos libropin khaynata nishan: “¡Wasinpas ch'inñeqman tukuchun! Hinaspa chay wasipiqa ama ni pipas tiyachunchu”, nispa Salmos 69.25. Hinaspapas Bibliapiqa nillashantaqmi: “Paypa ima ruwasqantapas huk runayá rantinta ruwachun”, nispa Salmos 109.8. ");
INSERT INTO qveNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Chayraykun Judas Iscariotepa rantinta huk runata akllasunchis. Payqa Señor Jesuswan, hinallataq noqanchiswan kushka tukuy tiempo puriqmasinchismi kanan. ");
INSERT INTO qveNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Hinaspapas chay runaqa Jesusta Bautizaq Juan bautizasqanmantapacha asta Jesuspa hanaq pachaman ripusqan p'unchawkama noqanchiswan puriqmasinchismi kanan. Saynallataqmi payqa Jesuspa kawsarimusqanta noqanchiswan kushka rikuq kanan, nispa. ");
INSERT INTO qveNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Chaymi paykunaqa Judas Iscariotepa rantinta, ishkay runakunata akllaranku, paykunamanta huknin kaq runa akllasqa kaspa, Jesuspa apostolnin kananpaq. Hukninpa sutinmi karan José Barsabás; paytan reqsiranku Justowan. Hukninñataqmi karan Matías. ");
INSERT INTO qveNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Hinaspan Diosmanta llapallanku khaynata mañakuranku: —Señor Diosniyku, qanllan llapallan runapa sonqonta reqsinki. Kunanyá kay ishkaynin runakunamanta mayqentachus akllakusqaykita reqsichiwayku, ");
INSERT INTO qveNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","saynapi Judas Iscariotepa rantinta apóstol kaspa kamachiykikunata ruwananpaq. Ichaqa Judasmi apóstol kashaspa huchaman urmaran. Chaymi wañuruqtin, almanqa huchasapa runakunapa kasqanman ripuran, nispa. ");
INSERT INTO qveNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Hinaspan sortearanku; hinaqtinmi suerteqa Matiasman tuparan. Chaymi Matiasqa chay p'unchawmantapacha chunka hukniyoq apostolkunawan yupasqa karan. ");
INSERT INTO qveNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentecostés fiesta p'unchaw chayaramuqtinmi, Jesucristopa apostolninkuna, wakin creyentekunapiwan kushka, huk wasipi huñunasqa kasharanku. ");
INSERT INTO qveNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Hinaqtinmi qonqayllamanta hanaq pachamanta wayra hina qaparishaq uyarikuran. Hinaspan chay kasqanku wasiman hunt'ayuran. ");
INSERT INTO qveNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Hinaqtinmi sapankamankupa umanpa altonman nina rawrashaq hina urayamuran. ");
INSERT INTO qveNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Hinaqtinmi paykunaqa Santo Espirituwan llapallanku hunt'ayusqa karanku. Hinaspan paykunaqa Santo Espíritu rimachiqtin, mana hayk'aq rimasqanku tukuy clase rimaykunapi sapankamanku rimayta qallariranku. ");
INSERT INTO qveNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Chay p'unchawkunapin Dios Taytata kasukuq Israel nacionniyoq ashka runakuna Jerusalén llaqtapi kasharanku. Paykunaqa huk law nación llaqtakunapin tiyaranku. (Chaymi Jerusalén llaqtapi Pentecostés fiestaman chay nación llaqtakunamanta hamuranku, Diosta yupaychanankupaq). ");
INSERT INTO qveNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Hinaqtinmi chay Jerusalén llaqtaman hamuq runakunaqa, chay wayra hina qaparisqanta uyarispanku, apostolkunapa kasqanman huñunakamuranku. Hinaspan sapankamankupa rimayninkupi rimasqankuta uyarispanku, chay runakunaqa mana ni imaynatapas piens