﻿USE sofia;
DROP TABLE IF EXISTS sofia.qvcNT_vpl;
CREATE TABLE qvcNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES qvcNT_vpl WRITE;
INSERT INTO qvcNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jisukristuqam unay Abrajamba, unay gubyirnu Dabidpa karu willkanmanda nasirqan. Kaypim iskibrini Jisuspa chay unay agwilungunapa shutingunata: ");
INSERT INTO qvcNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Chay agwilun Abrajamba churinmi Isak shutirqan. Isakpa churinqam Jakubu. Jakubupa churingunaqam Juda masangunawan karqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Chay Judaqam ishkay churiyuq karqan. Suqqam shutirqan Faris. Suqqam shutirqan Sari. Chay runakunapa mamanqam shutirqan Tamar. Chay Farispa churinqam Isrum shutirqan. Isrumba churinqam Aran; ");
INSERT INTO qvcNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramba churinqam Aminadab; Aminadabpa churinqam Nasun; Nasumba churinqam Salmun; ");
INSERT INTO qvcNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","chay Salmumba churinqam Bus; Buspa mamanmi shutiq Rrab. Chay Buspa churinqam Ubid; Ubidpa mamanmi shutiq Rrut. Chay Ubidpa churinqam Isayi. ");
INSERT INTO qvcNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isayipa churinqam karqan chay unay gubyirnu Dabid. Chay Dabidmi alma Uriyaspa warmin biyudapi churiyuq karqan. Chay churinqam karqan chay gubyirnu Salumun. ");
INSERT INTO qvcNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salumumba churinqam Rrubun; Rrubumba churinqam Abiyas; Abiyaspa churinqam Asa; ");
INSERT INTO qvcNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asapa churinqam Jusafat; Jusafatpa churinqam Jur; Jurpa churinqam Usiyas; ");
INSERT INTO qvcNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiyaspa churinqam Jutan; Jutamba churinqam Akas; Akaspa churinqam Isikiyas; ");
INSERT INTO qvcNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Isikiyaspa churinqam Manasis; Manasispa churinqam Amun; Amumba churinqam Jusiyas. ");
INSERT INTO qvcNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Chay Jusiyasqam churiyuq karqan isrraylinukunata prisushpa, Babiluña nasyunman apashqanllapa tyimpupi. Chaqa chay tyimpupim churin Jikuniyas yumbay masangunawan nasirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Chaymandaqam chay Jikuniyas Babiluñamanda Isrrayilman kutimushqan tyimpupi nasirqan churin Salatyil shutiq. Chay Salatyilpa churinqam Surubabil shutirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Surubabilpa churinqam Abiyud; Abiyudpa churinqam Ilyakin; Ilyakimba churinqam Asur; ");
INSERT INTO qvcNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asurpa churinqam Saduk; Sadukpa churinqam Akin; Akimba churinqam Ilyud; ");
INSERT INTO qvcNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ilyudpa churinqam Ilyasar; Ilyasarpa churinqam Matan; Matamba churinqam Jakubu. ");
INSERT INTO qvcNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakubupa churinqam Jusi shutirqan. Chay Jusim Maryapa qosanqa karqan. Chay Maryam Jisuspa mamanqa karqan. Chay Jisusllam Dyus Akrashqan Washadurpis shutin. ");
INSERT INTO qvcNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Chayshinam chay agwilu Abrajanmandapacha agwilu Dabidkaman katursi agwilukuna karqan. Chay Dabidpa tyimpunmandapacham isrraylinukunata Babiluñaman apashqan tyimpukamambis katursi agwilukuna karqan. Chay tyimpumandapismi Jisukristu nasishqan tyimpukaman katursi agwilukuna karqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kayshinam Jisukristuqa nasirqan. Suq warmi Marya shutiqmi suq runa Jusi shutiqwan tratukushqa karqan kasarananllapa. Piru dunsillaraq kashpa, manaraq puñuptinllapam, chay Maryaqa pach'ayuqna (ukuyuqna) karqan, Dyuspa Santu Ispiritumba pudirninmanda. ");
INSERT INTO qvcNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kanan Jusiqam ancha allin runa karqan. Chaymi Marya “Pach'ayuqmi (Ukuyuqmi) kani”, niptin, mana munarqanchu dimandayta, ni suqkunata parlachiyta: “Suqwanmi kashqa”, nishpaqa. Ashwanmi munarqan uyaraplla (uyaralla) akrakayta Maryamandaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Chaymi akrakanambaq yuyaykaptinqa, Dyuspa suq anjilnin musqoynimbi Jusitaqa nirqan: —Dabidpa karu willkan Jusi, ama manchaychu Maryawan kasaranaykiqa. Chaqa payqam mana runayuqchu kashqa. Ashwanmi Dyuspa Santu Ispiritumba pudirninmanda pach'ayuqqa (ukuyuqqa). ");
INSERT INTO qvcNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Chay wambrituqam nasyun masin isrraylinukunata uchangunamanda rin washaq. Chayri nasiptinqa, Jisusta shutichiy. Nuta: Chay shutin Jisusqam munan niyta: “Tayta Dyusmi washakun”, nishpa.  ");
INSERT INTO qvcNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tukuy chaykunam pasarqan, Tayta Dyus nishqan kumplinambaq. Chaqa payqam Santu Librumbi paypaq suq rimaqta kayshina iskibrichishqa karqan: ");
INSERT INTO qvcNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Suq dunsilla china manaraq runawan puñushpam, pach'ayuq (ukuyuq) rin kaq. Chaymi rin qeshyaq suq wambrituta. Chay wambritundam rinllapa shutichiq Imanwilta. Chay shutinmi munan niyta: “Dyusmi noqanchiqkunawan”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Chaymi Jusiqa puñuymanda rikch'akashpa, Dyuspa anjilnin kamachishqanshina rurashpa, Maryawanqa kasararqanna. ");
INSERT INTO qvcNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Piru kasarashpapismi, Jusiqa mana puñurqanchu Maryawanqa, chay kulaka churin nasinangaman. Nasiptinqam Jusiqa chay wambritumbaqqa nirqan: “Jisusmi rin shutiq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jisusqam kayshina nasirqan prubinsya Judiyapa Bilin llaqtambi. Waq tyimpupim gubyirnu Irudis chay Judiyapiqa kamachikuykarqan. Jisus nasiptinqam, lusirukunapaq wakin yach'aqkuna lusirukunata rikashpa yach'arqan: Suq kamachikuq wambritush nasishqa, nishpa. Chaymi paykunaqa ancha karu nasyunninmanda maskashpa, ch'ayamurqanllapa Jirusalin llaqtakaman. Paykunaqam shamushqallapa karqan rupay lluqshinan ladumandapacha. ");
INSERT INTO qvcNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ch'ayashpaqam, tapukurqanllapa: —¿Maypitaq nasishqa kay nasyunnikipa chay chayraq nasiq gubyirnunqa? Chaqa waq rupay lluqshinambi kashpam, rikarqayllapa mushuq lusiruta kay ladupi. Chay lusiruta rikashpaqam, yach'arqayllapa: Suq mushuq gubyirnum nasishqa, nishpa. Chaymi shamushqallapa kani, payta aduraq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Chaymi chay yach'ayniyuq runakuna chayshina tapukuptinllapaqa, chay gubyirnu Irudis, chay Jirusalimbi achka tiyaqkunapis chayta yach'ashpaqa, ancha manchashpa, yuyarqanllapa: ¿Ima, mushuq gubyirnuchush nasishqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Chaymi chay Irudisqa chay kamachikuq isrraylinu kurakunata, Muysispa liyningunata yach'achikuqkunatapis qayachishpa, tapurqan: —Dyuspa Santu Librumbiqa ¿imatam nin? ¿Maypitaq nasinambaq kashqa Dyus Akrashqan Washadurqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Chaymi paykunaqa Irudista nirqanllapa: —Kay prubinsya Judiyapa Bilin llaqtambim nasinambaqqa kashqa. Chaqa Dyuspaq rimaq librumbi iskibrishqa karqan: ");
INSERT INTO qvcNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Qamkuna Bilin llaqtapi tiyaqkuna, prubinsya Judiyamanda llaqtayki takshita kashpapismi, ancha rin baliq chay Judiyapa mas kamachikuqnin llaqtangunamandaqa. Chaqa chay llaqtitaykipim rin nasiq suq ancha pudirniyuq gubyirnu, yumbay isrraylinukunata shumaqta kamachinambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Chayshina niptinllapaqam, chay Irudisqa chay karumanda shamuq yach'ayniyuqkunata uyaraplla (uyaralla) qayachishpa, tapurqan: —¿Ima diyam rikarishqa chay lusiruqa? nishpa. Nuta: Chay Irudisqam chayshina tapurqan, munashpa yach'ayta chay wambritupaq: ¿Ima tyimpum nasishqa? nishpa.  ");
INSERT INTO qvcNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Chaymi Irudisqa (chay runakunata ingañayta yuyashpa) nirqan: —Mayá, riyllapa Bilinman, tapukuq chay wambritupaq. Tarishpaqar abisawayllapa, noqapis rinaypaq aduraq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Chayshina Irudis kunaptinmi, chay yach'ayniyuq runakunaqa lluqshirqanllapana Jirusalinmanda. Kanan chay rikashqanllapa lusiruqam paykunapa ñawpanllapata rirqan Bilin llaqtaman chay wambritu Jisus kashqangaman. Chaymi chay lusiru Jisus kashqanman ch'ayashpaqa, wasip sawan dirichumbina shayarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Chaymi chay runakuna lusiruta shayaqta rikashpaqa, anchana kushikurqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Chaymandaqam chay wasiman yaykushpaqa, rikarqanllapana chay wambritu Jisusta, maman Maryawan kaykaqta. Chaymi qonqorikushpa, Jisusta adurarqanllapa. Chaymandaqam apamushqan trastinllapata kich'ashpa, surqoshpa uruta, ancha ch'aniyuq insinsyuta, ch'aniyuq mirra shutiq ambita, Jisuspaq qorqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Chaymandaqam nasyunninman kutinambaqllapaqa, Tayta Dyus musqoynimbi chay runakunata kayshina nirqan: —Amakish kutingillapachu chay gubyirnu Irudismanqa, nishpa. Chaymi Dyusta kasushpa, suq ladu ñandana kutirqanllapa nasyunninmanqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Chaymandaqam chay yach'ayniyuq runakuna riptinllapanaqa, Jusi puñuykaptin, Dyuspa suq anjilnin musqoynimbi nirqan: —Jusi, atarishpa chay wambrituta mamitandinda mitikachiy Ijiptu nasyunman. Chay nasyumbi tiyayllapa, noqa nishunaykaman. Chaqa chay gubyirnu Irudismi rin kamachiq suldadungunata, chay wambrituta wanchinambaqllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Chaymi Jusiqa puñuykashqanmanda rikch'akashpa, chay uras tutaplla Bilinmanda chay wambrituta mamandinda Ijiptu nasyunman aparqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Chayshina rishpam, chay Ijiptu nasyumbina tiyarqanllapa chay gubyirnu Irudis wañunangaman. Chayshina ruraptinllapam, kumplirqan Tayta Dyuspaq suq rimaq Santu Librumbi kayshina nishqan: “Churiytam Ijiptu nasyunmanda kay Isrrayil nasyunman kutichimurqay”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Chay yach'ayniyuq runakuna Irudista mana abisaptinqam, payqa yach'arqan: Chay runakunaqam ingañawashqa, nishpa. Chaymi ancha fiyuta piñakushpa, suldadungunata kamachirqan: —Riyllapa Bilin llaqtaman tukuy rridurninman. Chaypi wanchiyllapa yumbay ullqo wambritukunata manaraq ishkay watayuq kaptinllapa, nishpa. Chayshinam chay Irudisqa kamachikurqan, chay yach'ayniyuq runakuna chay wambrapaq kayshina nishqa kaptin: “Chay lusirum rikakushqa ishkay watana”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Chayshina chay Irudis kamachikuptinmi, Dyuspaq rimaq Jirimiyas nishqanqa kumplirqanna. Chaqa chay Jirimiyasmi Dyuspa Santu Librumbi iskibrishqa karqan: ");
INSERT INTO qvcNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Uyashqam kanchiq chay llaqta Rrama shutiqpi ancha kunyashpa yupakuqta. Chaqa Rrakilpa karu willkangunam wambritungunapaq llakishpa yupakuykarqanllapa. Mananam ni pipis atirqanchu kunswilayta, chay wambritunguna wañushqana kaptinqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Chaymandaqam Irudisqa wañurqanna. Wañuptinqam, Dyuspa anjilnin waq Ijiptupi Jusita musqoynimbi nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Jusi, atarishpa, wambrituta mamitandinda apashpa, kutiriy Isrrayil nasyunnikiman. Chaqa chay wambrituta wanchiyta munaqkunaqam wañushqana, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Chaymi Jusiqa atarishpa chay wambrituta mamitandinda apashpana, kutirqan Isrrayil nasyunmanna. ");
INSERT INTO qvcNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Lukismi alma Irudispa churin Arkilawna taytamba rrimplasun gubyirnu karqan chay Isrrayilpa prubinsyan Judiyapiqa. Chaymi Jusiqa chay gubyirnu Arkilawpaq yach'ashpa, mancharqan Judiyaman kutiytaqa. Chayshina Jusi manchaptinmi, bwilta musqoyningunapi Tayta Dyus kunarqan, chay prubinsya Galiliyaman rinambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Waqman ch'ayashpaqam, Nasarit llaqtamanna rirqan tiyaq. Chayshina ruraptinmi, Dyuspaq rimaqkuna nishqan kumplirqan. Chaqa paykunaqam nishqallapa karqan: “Washadurninchiqmi nasarinu rin shutiq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","(Chay Nasaritpi tiyaykaptinllapam) suq runa Jwan Shutichikuq rirqan prubinsya Judiyapa chuncha lugarninman. Chaypi runakunata yach'achishpam, ");
INSERT INTO qvcNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","kutin kutin nirqan: —Dyusmi dasna rin shamuq, shumaqta kamachiwananchiqllapa. Chayri uchaykillapata dijashpa, shumaqtana kawsayllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Chay Jwambaqmi Dyuspaq rimaq Isayiyasqa librumbi iskibrishqa karqan: Chunchakunapim suq runa ancha jwirtita rimashpa, kayshina rin yach'achikuq: “Siñurninchiqta shumaqta ch'ayachinaykillapa, bidaykillapata ñandashina allichayllapa. Chayri kananmandaqa, amana uchakunata rurashpachu, shumaqtana kawsayllapa. Chaqa uchaykillapata dijashpaqam, alabis qamkunaqa allichaykangimanshina Siñurninchiqpa ñanninda”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Chay Jwanqam chuncha lugarkunapi tiyaq. Mudananqam kamillu animalpa millwanmanda awadu karqan. Wach'ukunqam qaramanda karqan. Nuta: Chay mudananqam Dyuspaq unay rimaqkunapa mudananshina karqan.  Chay chunchakunapi tiyashpaqam, chay Jwanqa atun churqapkunata (churqakunata), myil di abijata mikuq. ");
INSERT INTO qvcNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Achka lugarkunamandam runakuna, warmikuna chay Jwan kashqanman rirqanllapa, payta uyaq. Jirusalin llaqtamanda, prubinsya Judiyapa yumbay llaqtangunamanda, tukuy chay rriyu Jurdamba ladungunamandapis rirqanllapa Jwanmanqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kanan achka uyaqkunaqam, chay Jwanda kriyishpa, Dyusman mañakurqan, uchangunata pirdunanambaq. Chaymi Jwanqa chay uchata dijaqkunata rriyu Jurdambi shutichiq. ");
INSERT INTO qvcNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Piru achka farisiyu duktrinayuqkuna, achka sadusiyu duktrinayuqkuna (uchangunata mana dijashpachu) Jwanman shamurqanllapa, paykunata shutichinambaq. Chaymi paykunata rikashpa, Jwanqa nirqan: —¡A! ¿Qamkuna kulibrapa wambranguna layapischu munangillapa washakayta, ama kastigadu kanaykillapa? ");
INSERT INTO qvcNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Chayshina washakanaykillapa uchaykikunata dijashpana, Dyusman tukuy shunqo mañakuyllapa, qamkunata pirdunashunambaq. Kananmandaqa allitana rurashpa kawsayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Piru amar ni ashlita yuyayllapachu: Abrajamba karu willkanguna kaptinchiqmi, Dyusqa rin washawaqninchiq, nishpaqa. Ashwan allita intyindiwayllapa, Dyusmi kay rumikunamanda runakunata atin rurayta, Abrajamba karu willkanguna kanambaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Chaqa qamkunaqam uchata rurashqaykirayku, suq yura birdura mana allita puqoqshina kangillapa. Chaymi Dyusqa qamkunaman achanda qemishqana. Listunam suq yuratashina bulashunanllapa. Chaqa Tayta Dyusqam yumbay chay mana baliq birdura yurakunata das kuchushpa, rin wichuq lumyaykaq ninaman rupanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Alliptam niykillapa, ucha rurashqaykikunata dijaptikillapaqam, noqaqa yakupilla shutichiykillapa. Piru rinnam shamuq noqamanda suq mas pudirniyuq. Chaymi qamkuna paypi kriyiptikiqa, payqa Dyuspa Santu Ispiritunwan rin shutichishuqllapa, chay Santu Ispiritunwanna purinaykillapa. Piru chay mas pudirniyuqpi mana kriyiptikillapaqam, ninawan rin kastigashuqllapa. Chaqa pay ancha pudirniyuq kaptinmi, noqaqa mana nimapaqpis balinichu paypa ñawpambiqa, ni llanqenda apanaypaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Chaqa paypi kriyiqkunaqam paypa trigunshina. Payqam palata piskaqshina kashpa, chay trigunda rin abyintaq, trujanman apanambaq. Piru paypi mana kriyiqkunaqam tamushina. Chaymi paykunataqa Siñurninchiqqa rin wichuq chay mana nunka wañuq ninaman, tamushina rupanambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jisusmi prubinsya Galiliyamanda rirqan rriyu Jurdanman, Jwan shutichinambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Piru Jwanqam Jisusta mana munashpa shutichiyta nirqan: —Manam balinichu, noqaman shamunayki shutichishunaqqa. Ashwanri qam noqata shutichiway, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Chaymi Jisusqa nirqan: —Shutichiwaylla. Chayshinam alli rurananchiqpaq, Taytanchiq Dyus yumbay munashqanda kumplinaypaq, nishpa. Chaymi Jwanqa “Mayár”, nishpa, shutichirqanna Jisustaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jisus shutikushpa, yakumanda lluqshiykaptinqam, syilu das kich'akarqan. Chaymi Jisusqa rikarqan Dyuspa Santu Ispiritunda suq palumashina syilumanda urangumushpa payman shamuqta. ");
INSERT INTO qvcNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kanan syilumandapacham Tayta Dyusqa nirqan: —¡Kaymi ancha kuyashqay Churisituyqa! ¡Paywanmi noqaqa ancha kushikuni! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jisus shutikuptinmi, Dyuspa Santu Ispiritun suq chuncha lugarman aparqan, dyablu mallipanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Chay chuncha lugarpiqam 40 diyasta punchawnindin tutapnindin mana nimata mikurqanchu. Chaymi ancha mallaqnarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kanan dyablu mallaqtana rikashpaqa, qemikarqan tyintanambaq. Chaymi Jisustaqa nirqan: —Mayá, qam Dyuspa Churin allip kashpaqa, kamachiy kay rumikunata, tandapaq tikrakanambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Chaymi Jisusqa nirqan: —¡Manám! Chaqa Dyuspa Santu Librumbim nin: “Runakuna warmikunaqam mana mikunawanllachu kawsanqallapa. Ashwanmi kawsanqallapa Dyus tukuy ima nishqangunawan”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Chaymandaqam dyabluqa Jisusta aparqan Dyus akrashqan llaqta Jirusalinman. Waqpim Dyuspa adurana wasimba mas altu sawanman surqoshpa, ");
INSERT INTO qvcNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Jisusta nirqan: —Mayá, Dyuspa Churin allip kashpaqa, kaymanda ura pachakaman brinkay. Chaqa Dyuspa Santu Librumbim nin: Dyusmi anjilningunata rin kamachiq kwidashunanllapa. Chaymi makingunapi rin ch'askishuqllapa, ama ni ch'akikikuna waq ura rumikunapi tupakashpa chuqrikanambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Chayshina dyablu niptinmi, Jisusqa nirqan: —Dyuspa Santu Librumbiqam niwanchiqpis: “Amar Dyusnikita mallipaychu, munashqaykita ruranambaqqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Chaymandaqam chay dyabluqa suq ancha altu qaqapa sawanman Jisusta apashpa, rikachirqan kay mundupa yumbay nasyunningunata, tukuy chay munaypaq imandinda. ");
INSERT INTO qvcNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Chaymandaqam nirqan: —Mayá, qonqorikushpa adurawaptikiqam, yumbay kay nasyungunata qoshqayki, chaykunapi qamna kamachikunayki, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Piru Jisusqam mana kasushpachu, nirqan: —¡A dyablu, ashuy laduymanda! Chaqa Dyuspa Santu Librumbim nin: “Tayta Dyustalla aduray. Pay munashqandalla rurashpa kawsay”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Chaymi chay dyabluqa, (mana atishpa uchata rurachiyta), Jisuspa ladunmandaqa ladiyarqan. Chaymandaqam Jisus sapalitanna kaykaptinqa, Dyuspa anjilningunana shamushpa, payta tukuy imapi yanaparqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jisusqam chay chunchakunamanda kutimushpa, yach'ashpa: Kay prubinsya Judiyapish Jwan Shutichikuqta karsilashqallapa, nishpaqa, prubinsya Galiliyaman kutirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Piru manana kidashpa Nasarit llaqtapim, rirqanna Kapirnawun llaqtaman tiyaq. Chay Kapirnawunqam Galiliya Atun Qoch'apa manyambi kidan. Chay Kapirnawumba ladumbim ishkay lugarkuna karqan. Chaykunaqam shutiqllapa Sabulun, Niptali. ");
INSERT INTO qvcNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Chayshina Jisus chay Kapirnawunman riptinmi, Dyuspaq rimaq Isayiyas iskibrishqan kumplirqanna: ");
INSERT INTO qvcNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Chay prubinsya Galiliyapa yumbay llaqtangunapi tiyaqkunam rikashqallapana Dyusmanda shamuq Washadurta. Chay Sabulun lugarpi tiyaqkuna, chay Niptali lugarpi tiyaqkuna, chay ancha atun qoch'apa manyambi tiyaqkuna, chay rriyu Jurdamba ladungunapi tiyaqkuna, isrraylinukuna, mana isrraylinu kaqkunapismi Washadurtaqa rikashqallapana. ");
INSERT INTO qvcNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Chay uchayuqkuna tutayaqpishina kawsaqkunaqam suq atun michatashina rikashqallapa. Chaqa Washadurninchiqqam paykunata uchangunamanda washashqana, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Chay Kapirnawun llaqtaman rishpa tiyaqmi, Jisusqa yach'achikuykarqan: —Dyusqam ch'ayamuykanna qamkunaman, shumaqta kamachikunambaq. Chayri uchaykillapata dijashpa, paytana shumaqta ch'ayachiyllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisusqam Galiliya Atun Qoch'apa manyanda riykashpa, ishkay runa masapura kaqta rikarqan. Suqqam Simun Pidru shutiq. Suqqam Andris shutiq. Paykunaqam atarrayanllapata yakuman wichuykarqanllapa, piskaduta piskanambaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Paykuna chayshina ruraykaptinqam, Jisusqa nirqan: —Shamuyllapa noqawan purinayki. Qamkunaqam yach'angina piskadukunata piskayta. Noqaqam rini yach'achishuqllapa, runakunatana maskashpa, yach'achinaykillapa, noqapi kriyinanllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Chayshina niptinmi, chay uras paykunaqa, atarrayanllapata dijashpa, Jisuswanna rirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Riykashpa, ashla waqsitupiqam Sibidiyupa ishkay churingunatapis rikarqan. Suqmi shutirqan Jakubu. Masanqam shutirqan Jwan. Paykunam taytan Sibidiyuwan chay yakupa manyambi yakupi puriq barkumbi atarrayangunata rrimindaykarqanllapa. Piru Jisus chayshina qayaptinqam, ");
INSERT INTO qvcNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","chay uras das barkunmanda ishkishpa, taytanda chaypi dijashpa, Jisuswanna rirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisusmi Galiliyapa tukuy llaqtangunaman, kasiriyungunaman rirqan yach'achikuq. Kada llaqtaman ch'ayashpaqam, sinaguga wasiman rishpa, Dyuspa shumaq nutisyanda yach'achikushpa nirqan: —Tayta Dyusmi dasna rin shamuq, shumaqta kamachikunambaq, nishpa. Tukuy laya nanaywan kaqkunatapismi kach'akachirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Chaymi Jisuspa famandaqa yach'arqanllapa prubinsya Siryapa tukuy lugarningunapi: Jisusqash qeshyaqkunata kach'akachiykan, nishpa. Chaymi chay siryanukunaqa Jisusman apamurqanllapa tukuy laya nanaywan padisiykaqkunata, dyablupa ispiritunwan puriqkunata, atakiwan padisiqkunata, wañushqashina kwirpuyuqkunata. Chaypim Jisusqa yumbayta kach'akachirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Chaymi ancha achka runakuna, warmikuna shamurqanllapa prubinsya Galiliyamanda, prubinsya Dikapulismanda, Jirusalin llaqtamanda, prubinsya Judiyamanda, rriyu Jurdamba waq ladunmanda, Jisusta uyanambaqllapa. Nuta: Chay shutin “Dikapulismi” munan niyta: Dyis llaqtakunapa prubinsyan, nishpa.  ");
INSERT INTO qvcNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Chay achka ch'ayamuqkunata rikashpam, Jisusqa suq lumaman rishpa, tiyashpa, paykunata yach'achirqan. Chaymi payman shamuqkunaqa chay punta yach'akuqningunawan Jisuspa rridurninman tandakarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Chaypim Jisusqa kayshina yach'achikurqan: ");
INSERT INTO qvcNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Tayta Dyusta nisitaqkunar kushikunqallapa. Chaqa Dyus allita kamachikushpa, paykunata shumaqta rin ch'askiq, paywanna kawsananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Waqaqkunar kushikunqallapa. Chaqa Dyusmi paykunataqa rin kunswilaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Umildi shunqoyuqkunar kushikunqallapa. Chaqa Tayta Dyus kay mundupi shumaqta kamachikuptinmi, paykunapis paywan pulla rinllapa kamachikuq. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Dyusta ancha munaq kasuqkunar kushikunqallapa. Chaqa Dyusmi paykunataqa ancha rin yanapaq, pay nishqanda allita kasushpa kawsananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Runa masinda llakipaqkunar kushikunqallapa. Chaqa paykuna llakipashqanshinam Taytanchiq Dyuspis paykunata rin llakipaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Limpyu shunqoyuqkunar kushikunqallapa. Chaqa Dyuswanmi rinllapa kawsaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Suqkunata alliyachiqkunar kushikunqallapa. Chaqa paykunapaqmi Dyusqa ninqa: “Kaykunam wambraykunaqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Qesachadukunapisri kushikunqallapa. Chaqa paykunaqam Dyus munashqanda rurashqanrayku padisiykanllapa. Chaymi Tayta Dyusqa shumaqta kamachikushpa, paykunata rin washaq, paywan kawsananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","12","’Chayri noqapi yuyakushqaykirayku musyashushpa, qamkunata qesachashuptinqa, kushikuyllapa. Yanqakunata rimashuptinllapaqa, masta kushikuyllapa. Chaqa Dyusmi ancha allin primyuykita syilupi rin qoshuqllapa. Chay qesachadu kashqaykishina Dyuspaq chay unay rimaqkunapis qesachadu karqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jisukristuqam nirqambis: —Kay mundupi kawsashpaqam, qamkunaqa kach'ishina kangillapa. Piru kach'i lambaqyaptinqam, manana atinchu kach'ipaq tikrakaytaqa. Chaymi chay mana baliq kach'itaqa wichukunchiqna. Chaypinam runakuna sarrun, ¿manachu? ");
INSERT INTO qvcNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Qamkunaqam kay mundupi tiyaqkunapaqqa michashinapis kangillapa, paykuna Dyusman ch'ayananllapaqa. Chaymi allita kawsaptikillapa, suq michatashina das rikashungillapa, suq llaqta qaqap sawambi kaqta das rikashqanllapashina. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Chayshinallam suq michata syindishpa, mana kajumba waranmanqa ruranchiqchu. Ashwanmi altupi ruranchiqqa, chay wasipi yumbay kaqta achikchawananchiq, ¿manachu? ");
INSERT INTO qvcNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Qamkunapisri michashina kashpa, allitalla rurashpa kawsayllapa. Chayshina allita ruraptikillapam, chay rikashuqkuna alabanqallapa Taytanchiq Dyusta. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jisusqam kayshinapis yach'achikurqan: —Kinsapch'i wakinniki yuyangillapa: Jisukristum rin chingachiq Muysis kamachikushqanda, Dyuspaq chay suq rimaqkuna kamachikushqanda, nishpa. Amakish chayshinaqa yuyangillapachu. Manam chingachiqchu shamushqaqa kani. Ashwanmi shamushqaqa kani, tukuy ima nishqanda kumpliq. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Alliptam niykillapa, Dyuspa Santu Librumbi kaq liyningunaqam mana nimapis rinllapachu chingaq, kay pachawan syilu ushyakanangaman. Chay liyningunamandaqam mana rinchu chingaq ni suq litra ni suq puntitupis, tukuy ima nishqan kumplinangaman. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Chaqa Dyuspa yumbay liyningunam ancha balin. Chayri yumbay chay liyningunata kasushunllapa. Chaymi suq runa suq taksha liysituta mana kasushpachu, suqkunatapis animachiptin ama kasunanllapaqa, Dyuspaqqa mana nimapis balinchu. Taytanchiq Dyus shumaqta kamachiwaptinchiqqam, chay laya uchayuqqa mana nimapaqpis rinchu baliq. Piru suq runa ichu suq warmi Dyus nishqanda allita kasushpa, suqkunata kasunambaq yach'achishpaqam, syilupiqa ancha rinllapa baliq. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Chaymi ancha klaruta niykillapa, Tayta Dyus munashqandar tukuy shunqo rurayllapa. Chaqa mayqanniki chay farisiyu duktrinayuqshina ichu Muysispa liyningunata chay yach'achikuq runakunashina Dyus munashqanda ashlitatalla rurashpaqam, ringillapa chingaq. Piru paykunamanda mas allita Dyusta kasuptikillapaqam, payqa rin washashuqllapa, shumaqta kamachikuptin, paywan kawsanaykillapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jisusqam nirqambis: —Qamkunaqam yach'angillapa chay unay agwiluykikunata Tayta Dyus kamachishqanda: “Ama pitapis wanchiychu. Mayqan wanchikuqqam dimandadu rin kaq, juyiskuna sintinsyashpa kastigananllapa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Piru kananqam noqaqa niykillapa, runa masikipaq piñakushpaqam, uchayuq kangi. Chaymi sintinsyadu ringi kaq. Chayshinallam suq runata musyashpapis, ancha kastigadu ringi kaq chay Mas Kamachikuq Tandakaq Juyiskunapa ñawpambi. Runa masikita: “Ancha tuntum kangi” nishpaqam, ancha kastigadu ringi kaq infyirnupa ninambi. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Chayri ufrindaykita apashpa pata altarman Dyusta aduranaykiqa, piru yuyashpa: Suq runa masiytam piñachishqa kani, nishpaqa, ");
INSERT INTO qvcNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","amaraq ufrindaykita qoychu. Ashwanri chay uraslla pata altarpa ñawpambi ufrindaykita dijashpa, kutishpa chay runa masikiman, paywan allichay. Chayshina allichashparaqmi, atingi ufrindaykita qoytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Chayshina suq runata mana allita ruraptiki, juyisman riykaptin dimandashuqqa, payman das rishpa, ñambilla allichay, amana dimandashunambaq. Mana chayta ruraptikikish, apashungiman juyisman. Chaykish juyisqa kach'ashungiman suldadukunaman karsilachishunan. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","¡Alliptam niykillapa, karsilmandaqam mana ringichu lluqshiq, tukuy ima dibirashqaykita payta pagaranaykikaman! ");
INSERT INTO qvcNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jisusqam nirqambis: —Qamkunaqam uyakushqallapa kangi unay tyimpupi kayshina kamachikushqanda: “Suq runapa warminwan ama puñuyllapachu”, niqta. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Piru kananqam noqaqa kaytapis niykillapa, mayqan runa chapashpa suqpa warminda, paywan puñunambaqqam ancha uchayuqna. Chaqa chayshina shunqombilla yuyashpaqam, alabis puñuykanmanshinana chay warmiwanqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Chayri ama nima laya uchata ruraychu. Piru chay allin ladu ñawiki inkitashuptin uchata ruranaykiqa, surqoshpa wichukuy. Mas allim suq parti kwirpuykilla chinganambaq, ama yumbay kwirpuykita infyirnuman wichukunambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Chayshinallar chay allin ladu makiki ancha qawch'u kaptin uchata ruranambaqpis, kuchushpa wichukuy. Mas allim suq parti kwirpuykilla chinganambaq, ama yumbay kwirpuykita infyirnuman wichukunambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Unayqam nirqanllapapis: “Mayqan runa warminmanda akrakaqqa, suq dukumintuta qonqa, amana warmin kanambaq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Piru kananqam noqaqa niykillapa, suq runa warminmanda akrakashpa, ancha uchayuqna. Piru mayqan warmi runanda traysyunda rurashpa, suq runawan kaptinllam, qosanqa atin akrakaytaqa. Manaqa manam balinchu warminda qatinanqa. Chaqa chay qatishqa warmiqa suq runawan kashpam, uchatana ruranman. Piru chay punta runan qatishpam, chay uchataqa rurachinman. Kanan chay qatishqa warmita mayqan tandaqpismi uchayuqna. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Unay liykunaqam agwiluykikunata kayshinapis nirqan: “Amakish yanqata rimashpaqa: ‘purdyusitu’ ningichu. Imata Tayta Dyuspa ñawpambi ufrisikushpa, ‘purdyusitu’ nishpaqa, allipta kumpliy. Amakish llullakungichu”, nishpa, ¿manachu? ");
INSERT INTO qvcNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Piru kananqam noqaqa niykillapa, amar nimapaqpis “purdyusitu” nishpaqa, jurayllapachu. Amakish Dyuspa tiyanan syiluta myintashpaqa jurangillapachu. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Amakish kay pacha allpata myintashpaqa jurangillapachu. Chaqa kay pacha allpaqam Dyuspa ch'akin sarrukushqan lugar. Amakish ni Dyus akrashqan Jirusalin llaqtata myintashpaqa jurangillapachu. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Amakish ni umaykita myintashpa jurangillapachu. Chaqa Dyusllam rurashqa umaykitaqa. Qamqam mana ni suq aqchaykita atingichu yuraqyachiyta ni yanayachiyta. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Chayri ama jurayllapachu. Ashwan imatapis ufrisikushpaqa kumpliy. Chaqa qamkuna jurashpa ufrisikuptikiqam, dyablu chayshinaqa rimachishungillapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Unay nishqanllapatapismi uyashqallapa kangi: “Mayqan runa masinda suq ladu ñawinda sarkuyachiptinqa, chayshinalla paytapis dimandashpa, suq ladu ñawindalla sarkuyachinqa. Mayqan runa masinda suq kirunda surqoptinqa, dimandashpa, chayshinalla paytapis suq kirundalla surqonqallapa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Piru kananqam noqaqa niykillapa, suq malutaqa ama bingayllapachu. Ashwan kayshina rurayllapa: Mayqan allin ladu qaqllaykipi takashuptinqa, tikrakay, chay suq ladu qaqllaykipipis maqashunambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ichu mayqan dimandashushpa munaptin kushmaykita qoch'ishuytaqa, punchuykitapis dijay apanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mayqan qamkunata kamachishuptin, trastinda suq kilumitru y midyukaman apanaykipaqqa, kimsa kilumitrukaman apay. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mayqan imata mañashuptimbis, qoy. Mayqan pristanayki munaqtaqa, ama fyirusyashpachu, pristay ima munashqanda, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jisusqam kayshinapis nirqan: —Unay nishqanllapatam kayshina yach'akushqallapa kangi: “Kuyashuqkunata kuyay. Kuntrashuqkunataqa ch'iqniy”, nishpa, ¿manachu? ");
INSERT INTO qvcNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Piru kananqam chaypaqqa niykillapa, kuntrashuqkunata kuyayllapa. Maldisyashuqkunapaq Dyusman mañakuyllapa, paykunata yanapanambaq. Ch'iqnishuqkunata allita rurayllapa. Musyashushpa, qesachashuqkunapaq Dyusman mañakuyllapa, paykunata tukuy imapi yanapanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Chaqa chay Taytaykillapa Dyusmi ancha allin yumbaywan. Chaymi rupayta lluqshichin, tamyachikun yumbay allingunapaq, malukunapaqpis. Chayri qamkunapis yumbaywan shumaqta kawsayllapa, chay rikashuqkuna ninambaq: “Waq kriyiqkunaqam allipta Dyuspa wambranguna”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Chaqa kuyashuqkunatalla kuyashpaqam, mana ancha allitaqa ruraykangillapachu. Chaymi chay layata ruraqqa ¿ima laya pagutaraq Dyusmandaqa rinllapa ch'askiq? Chaqa chay uchayuq kuntribusyunda kubrakuqkunapismi chayshina kuyaq masingunatalla kuyanllapa, ¿manachu? ");
INSERT INTO qvcNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Chayri qamkunaqa uyawayllapa, kriyiq masikikunatalla napaykushpaqam, chay uchayuq runakunamandaqa mana mas allitachu ruraykangillapa. Chaqa chayshina kuyashpaqam, Dyuspi chay mana kriyiqkunashinalla kawsaykangillapa. Chayshinallam chay mana kriyiqkunaqa kuyaqkunatalla shumaqta napaykunllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Chayri allita uyawayllapa: Taytaykillapa Dyusqam ancha allin kashpa, mana nima maluta ruranchu. Chayri qamkunapis Dyusshina kawsayllapa, ama nima maluta rurashpachu. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jisusqam kayshinapis yach'achikurqan: —Ima allikunata rurashpaqa, ama rurayllapachu, runakuna rikashushpa alabashunambaq. Alabadu kaptikillapaqam, Tayta Dyusqa mana qoshunqallapachu primyuykitaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Chayri pubrisitukunata yanapashpaqa, ama pitapis parlachiychu: “Kayshinam noqaqa yanapakuni”, nishpaqa, Dyusta chay shiminwanlla kasuqkunashinaqa. Chaqa chay shiminwanlla kasukuqkunaqam pita imanllapata qoshpaqa, sinaguga wasipi, kallikunapi yanapakushqanda rimanllapa, uyaqkuna paykunata alabananllapa. Piru alliptam niykillapa, paykunaqam chayshina alabadukuna kashpaqa, manana Dyusmandaqa nimatapis rinllapachu ch'askiq. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Chayri ufrindaykita qoptikiqa, ama ni mas kuyashqayki yanasuyki (yanasayki) yach'anqachu. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Chayshina pakashpa qoptikiqam, Taytanchiq Dyus rikashuqlla ufrindaykipaqqa yach'anqaqa. Chaymi payqa yumbaypa ñawpambi primyuykitaqa rin qoshuq. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jisusqam nirqambis: —Amar chay shiminwanlla kasukuqshinaqa Tayta Dyusmanqa mañakuyllapachu. Chaqa paykunaqam ancha gustanllapa shayashpa sinaguga wasikunapi, kallikunapa iskinangunapi Dyusman mañakuyta, suqkuna rikanambaq. Piru alliptam niykillapa, paykunaqam chayshina kay bidapi alabashqakuna kashpaqa, Dyusmandaqa mana nima primyuta rinllapachu ch'askiq. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Chayri qamkunaqa ama paykunashinaqa kayllapachu. Ashwanri Dyusman munashpa mañakuytaqa, uku wasikiman yaykushpa, punguykita kirpashpa, sapalaykilla Dyusman mañakuy. Chayshina mañakuptikiqam, Tayta Dyuslla uyashushpa, suq shumaq primyuta ˻yumbaypa ñawpambi˼ rin qoshuqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Piru Dyusman mañakunaykillapaqa, ama kutin kutinqa rimayllapachu Dyuspi mana kriyiqkunashinaqa. Chaqa paykunaqam kutin kutin ancha mañakunllapa dyusningunaman, yuyashpa: Achkata rimashpa mañakuptiymi, dyusniykuna rinllapa uyawaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Amar paykunashinaqa kayllapachu. Chaqa Taytanchiq Dyusqam manaraq ni mañakuptiki, yach'anna imam faltashungi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Chayri kayshina Tayta Dyusman mañakuyllapa: Taytanchiq Dyusitu syilupi kaq, qamllam ancha santu, mana nima uchayuqchu kangi. Chaymi ancha balin, yumbay runa, warmi qamtalla alabashunanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Shamuyri, qamna yumbayta shumaqta kamachinayki. Qam munashqaykitar yumbay runa warmi kay pachapi ruranqallapa, anaq syilupi ruraqkunashina. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Taytitu, tukuy diyapaqri mikunitayta qowayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Mana allita rurashqaytapisri pirdunawayllapa, noqaykuna waq mana alli rurawaqkunata pirdunashqayshina. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Dyablu munaptin tyintawaytapisri, ama dijaychu uchata rurachiwananqa. Ashwanri tukuy chay mana allikunamanda washawayllapa. ˻Tukuy imar qamtalla kasushunqa. Chaqa qamllam ancha pudirniyuqqa kangi. Qamllam ancha shumaqtaqa llipyangi. Chayshinallar tukuy tyimpu kanqa,˼ nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Chayri yumbay dañachishuqkunata pirdunayllapa. Chaqa mayqan runa ichu warmi mana allita rurashuptin, qamkuna pirdunaptikiqam, syilupi kaq Tayta Dyuspis uchaykimanda rin pirdunashuq. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Piru paykunata mana pirdunaptikiqam, Taytanchiq Dyuspis mana rinchu pirdunashuqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jisusqam kayshinapis yach'achikurqan: —Ayunashpaqa, ama rurayllapachu Dyusta shiminwanlla kasuqkunashinaqa. Chaqa paykunaqam ayunashpaqa, llakiqkunashina tukunllapa, rikaqkuna ninanllapa: “Rikay, akakáw, ayunaykanllapam”, nishpa. Piru allita uyawayllapa: chay shiminwanlla kasukuqkunapaq chayshina niptinllapaqam, Dyusmandaqa mana nima primyunda rinllapachu ch'askiq. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Chayraykur qamkuna ayunashpaqa, qaqllaykita mayllashpa, shumaqta ñaqchakuyllapa, ");
INSERT INTO qvcNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","rikashuqkuna ama yach'anambaq: Chay runam ayunaykan, nishpa. Chayshina ruraptikillapaqam, Tayta Dyuslla yach'anqa. Chaymi payqa primyuykita ˻yumbaypa ñawpambi˼ rin qoshuq. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jisusqam nirqambis: —Amar llakiyllapachu, kay mundupi tukuy imayuq kanaykiqa. Chaqa kay mundupiqam pulillakuna chay kusasnikikunata rin kush'kuq. Wakin kusasnikiqam rin muqosuyaq. Wakindaqam ladrunguna rin apaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Chay kusaskunamandaqa ashwan mushuq bidapaq syilupi ancha yuyayllapa. Chaqa waqpiqam mana nima pulillaqa kanchu, imatapis kush'kunanllapaqa. Manam nimapis rinchu muqosuyaq, ni ladrunguna kanchu apananllapaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Chayri allita yuyayllapa, tukuy imaykiwan Dyuspaq trabajanayki. Chayshina trabajashpaqam, Dyuspilla ringillapa yuyakuq; mananam kusasnikipiqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Jisusqam kayshinapis yach'achikurqan: —Ñawinchiqqam kwirpunchiqpa michanshina. Chaymi ancha yanapawanchiq allita rikakushpa, yach'ananchiq: ¿Maymanmi rini? nishpa. Chayshinallam Dyuspis suq michashina paypi kriyiqkunapaqqa. Chaqa paymi yanapawanchiq, yach'ananchiq: ¿Imam alli? ¿Imam mana allichu? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Piru Dyusmanda akrakashpaqam, tutayaqpishina puriykanchiq. Chaymi mana nimatapis rinchiqchu intyindiq Dyuspaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Manam pipis atinchu ishkay patrunda kasuytaqa. Chaqa ishkay patrunniyuq kashpaqam, suq patrunninda ch'iqnishpa, suqta masta kuyanman. Chaymandaqam suqta manana kasushpachu, suqtana masta kasurinman. Chayshinallam noqanchiqkunapis mana atinchiqchu Dyusta qellaytapis pullata kasuytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Jisusqam nirqambis: —Noqaqam niykillapa, ama llakiyllapachu: ¿Imataraq mikushaq? ¿Imataraq upyashaq kawsanaypaqqa? ¿Imataraq rurakushaq? nishpallapaqa. Ima, ¿manachu yach'angillapa, Taytanchiq Dyusmi bidaykita qoshushqanshina, mikunaykitapis rin qoshuq kawsanaykipaq, nishpaqa? Ima ¿manachu yach'angillapa, paymi kwirpuykillapata rurashqanshina rin yanapashuqllapa mudanayuqpis kanaykillapa, nishpaqa? ");
INSERT INTO qvcNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Pishqokunata chapashpa, allita yuyayllapa: Paykunaqam mana tarpukunllapachu, ni kusichakunllapachu, ni trujakunapi granukunata tandanllapachu. Piru Tayta Dyus paykunata mantyinin. Dyuspaqqam qamkunaqa masta balingillapa chay pishqokunamandaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mayá, ancha munashpa masta wiñaytaqa, ¿atingimanchu midyu mitru masta wiñayta? Manám. Chaymi niykillapa, ama chayshinaqa llakiyllapachu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Mudanaykipaqpis ¿imaraykutaq llakingillapaqa? Yuyayllapa chay liryu tuktukunapi. Chaykunaqam mana trabajanllapachu, ni puchkakunllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Piru alliptam niykillapa, chay ancha kapuq gubyirnu Salumunqam maychika ancha shumaqta mudakushpapis, mana chay tuktukunashinaqa mudakurqanchu. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Yuyayllapapis qewakunapaq. Chaykunaqam suq tyimpupaqlla kawsan. Chaymanda limpu chakiptinqam, rupachinapaqna balin. Chayshina mana duraqkuna kaptimbismi, Dyusqa ancha shumaq munaypaqta mudachin. Piru qamkunaqam chay qewakunamandaqa Dyuspaqqa masta balingillapa. ¿Ima manachu yuyakungillapa Dyuspiqa? Payqam chay tuktukunamandaqa ashwan mas shumaqta qamkunataqa rin kwidashuqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Chaymi niykillapa, ama llakiyllapachu: ¿Imataraq mikushun? ¿Imataraq upyashun? ¿Imataraq rurakushun? nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Dyuspi mana yuyakuqkunallam chay layapaqqa llakinllapa. Piru qamkunaqar ama paykunashinaqa kayllapachu. Chaqa Taytanchiq Dyusmi allita yach'an imam faltashungillapa, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Chayri chay tukuy imapaq llakinaykimandaqa, ashwan ancha munayllapa Dyus munashqanda rurayta, paylla ancha allin kamachikuqniki kanambaq. Chayshina Dyus munashqanda ruraptikiqam, payqa ima nisitashqaykita rin qoshuqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Chayri ama llakiyllapachu: ¿Qayaqa imaraq pasawanqa? nishpaqa. Kanan kaqtalla allichayllapa. Qaya ima pasashuptin, qayaraq allichayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jisusqam nirqambis: —Runa masikitaqa ama jusgayllapachu, qamkunatapis Dyus ama jusgashunambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Chaqa suqkunata jusgaptikiqam, qamkunatapis Dyusqa chayshinalla rin jusgashuqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Qamkuna mas uchayuqkunaqa ama jusgayllapachu kriyiq masikita, ashla uchata ruraptinqa. Chaqa jusgashpaqam, paypa ñawimbi uqshitatashina rikangi. Piru manam rikangichu qamba ñawikipi suq bigatashinaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Chayshina qamba kikin ñawikipi suq biga kaptinqa, ¿imashinataq kriyiq masikita atingi niyta: “Dijaway chay ñawikimanda chay uqshitata surqonaypaq”, nishpaqa? ");
INSERT INTO qvcNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡A, shimikiwanlla kasukuq! ¡Qambaqam kan grasyayki, suqkunata jusganayki! Chayshina kanaykimandaqa puntata qamba ñawikimandaraq chay bigatashina surqoy. Chaymanda allita rikakushparaq, atingiman surqoyta chay uqshitatashina kriyiq masikipa ñawinmanda. ");
INSERT INTO qvcNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Jisusqam kayshinapis yach'achikurqan: —Ancha santu Tayta Dyusta asipaqkunataqa ama yach'achiyllapachu. Chaqa paykunakish saqra allqo kanikuqkunashina ancha dañachishungiman. Chay yach'akushqayki nutisyaqam ancha baliq ch'aniyuq perlaskunashina. Piru Dyusta asipaqkunaqam chay shumaq nutisyataqa mana munanllapachu uyayta. Chaqa paykunaqam kuchikunashina sarruykan chay llipyaq perlasshina nutisyataqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jisusqam kayshinapis yach'achikurqan: —Dyusman (mana shaykuq) mañakuyllapa. Chaqa qamkuna chayshina mañakuptikiqam, payqa rin qoshuqllapa. Nisitashqaykita maskashpaqam, Dyusmanda ringillapa ch'askiq. Chaqa payman mañakushpaqam, pungumbi qayakuykangishina, yanapashunambaq. Chayshina (mana shaykuq) qayakuptikiqam, Tayta Dyusqa rin yanapashuq. ");
INSERT INTO qvcNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Chaymi mañakuqqa paymanda ch'askin; ima nisitashqanda maskaqqam paypiqa tarin; chay pungumbishina qayakuqqam ukuman yaykun. ");
INSERT INTO qvcNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’¿Suq wambrayki tandata mañashuptinchu, suq rumita qongiman? Manám. ");
INSERT INTO qvcNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Ichu suq piskaduta mañashuptinqa, suq kulibrata qongiman? Manám. ");
INSERT INTO qvcNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Chaqa qamkuna malukuna kashpapismi, yach'angillapa wambraykillapata allin kusaskunata qoyta. Piru Taytanchiq Dyusqam qamkunamandaqa mas allin. ¡Chaymi payman yumbay mañakuqtaqa ancha rin yanapaq! ");
INSERT INTO qvcNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Qamkunaqam munangi, suqkuna allita rurashunambaq. Chayshina munashpaqa, ashwan qamkuna allita ruray paykunata. Chayshina rurashpaqam, ringi kumpliq Muysis kamachikushqanda, Dyuspaq rimaqkuna yach'achikushqandapis. ");
INSERT INTO qvcNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Jisusqam kayshinapis yach'achikurqan: —Kay bidapiqam kan ishkay pungu, ishkay ñan. Suq pungu, suq ñanqam ancha anchu, mana nima trabajuschu yaykunanchiq. Chaymi ancha achka runakuna, warmikuna chay punguta, chay ñanda riykanllapa. Piru chay anchu ñanmi rin apashuqllapa infyirnuman, chaypi ushyakanaykillapa. Kambismi suq pungu, suq ñan ancha kich'ki ancha trabajus yaykunanchiq. Chayri allita yuyashpa, chay kich'ki punguta yaykushpa, chay kich'ki ñanda riy. Chaqa wakingunallam chay kich'ki punguta chay kich'ki ñanda maskashpa tarinllapa, mushuq bidaman ch'ayananllapa, tukuy tyimpu kawsananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jisusqam kayshinapis yach'achikurqan: —Kwidakayllapa Dyuspaq rimaq tukuqkunamanda. Chaqa paykunaqam rinllapa niq: “Noqaykunam Dyuspaq allip rimaqkuna kanillapa”, nishpa. Piru shunqonllapapiqam chay lubu (ichu chay surru) wishata mikuqkunashina rinllapa kaq. Chayri allita kwidakayllapa yumbay chay mana baliq yach'achikuqmanda, qamkunata ama pandachishunanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kayshinam paykunataqa atingillapa riqsiyta: Dyuspaqchu allipta yach'achikun ichu mana, nishpaqa. Allita rurashpa kawsaptinllapaqam, ringillapa yach'aq: Alliptam Dyuspaq yach'achikunllapa, nishpa. Piru chay llullakuqkunaqam mana baliq yurakunashina. Chaqa kashakunamandaqam mana tandanchiqchu ubaskunata ichu iguskunata. ");
INSERT INTO qvcNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Yumbay allin yuraqam allindalla puqon. Piru chay mana baliq yurapa puqoyninqam mana balinchu mikunapaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Chaqa chay allin yurakunaqam mana atinllapachu mana baliqta puqoytaqa. Chayshinallam chay mana allin yurakunapis maychikapis mana atinllapachu allinda puqoytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Chaymi yumbay chay mana allinda puqoq yurakunataqa kuchushpa wichukunllapa ninaman. Chayshinallam Tayta Dyusqa rin ruraq chay llullakuqkunataqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Chaymi niykillapa, chay llullakuqkunataqam atingillapa riqsiyta, ima laya kashqanllapata, allita ichu mana allita ruraptinllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Jisusqam kayshinapis yach'achikurqan: —Yumbay niwaqkuna: “Kamachikuq Siñursitu, Kamachikuq Siñursitu”, nishpaqam, mana rinllapachu yaykuq syilumanqa. Chaqa Taytay Dyus nishqandaqam mana kasushqallapachu. Piru Taytay Dyusta kasuqkunam paywan, noqawan rinllapa kawsaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Chaymi chay jwisyu diyapiqa achka rinllapa niwaq: “¡Kamachikuq Siñursitu, Kamachikuq Siñursitu, qamba shutikita myintashpam yach'achikurqayllapa! ¡Shutikita myintashpam, dyablukunata qatirqayllapa! ¡Shutikita myintashpam, achka milagrukunata rurarqayllapa!” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Chayshina niwaptinllapaqam, noqaqa rini niq: “Manam nunka riqsishushqallapachu kani. Qamkuna mana alli ruraqkunaqa akrakayllapa noqamanda.” ");
INSERT INTO qvcNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Kay nishqayta kasuqqam suq ancha yach'ayniyuq runashina. Chay yach'ayniyuqqam wasinda rurarqan kaskajupa sawambi. ");
INSERT INTO qvcNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Chaymandaqam ancha tamyaptin, rriyukuna undaptin, ancha jwirti wayraptinqa, chay yach'ayniyuqpa wasinqa mana bulakarqanchu, ancha allin simyintuyuq kashqanrayku. ");
INSERT INTO qvcNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Piru kay nishqayta mana kasuqqam suq tuntu runa aqokunap sawambi wasikuqshina. ");
INSERT INTO qvcNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Chaymandaqam ancha tamyaptin, rriyukuna undaptin, ancha jwirtita wayraptin, chay tuntupa wasinqa limpu bulakarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Chaykunata Jisus yach'achikuptinqam, chay uyaqkunaqa ancha ispantashqata yuyarqanllapa: Jisusqam ancha yach'ayniyuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Chaqa Jisusqam ancha yach'ayniyuq kamachikuq kashpa, mana yach'achikuqchu Muysispa liyningunata yach'achikuqkunashina. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Chay lumamanda Jisus uraman riptinmi, ancha achka runakuna, warmikuna ikinda rirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Chaypim suq runa ismuykaq kwirpuyuq shamushpa, ñawpambi qonqorikushpa, nirqan: —Kamachikuq taytitu, yanapawayri. Chaqa qamqam munashpa kay qeshyayniymandaqa das atingi kach'akachiwayta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Chaymi Jisusqa chay millanaypaq runapa sawanman makinda rurashpa nirqan: —Munanim kach'akachishuyta. Kanalitan kach'akay, nishpa. Chayshina niptinllam, chay qeshyayqa limpu chingarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Chaymi Jisusqa nirqan: —Amakish pitapis nimata ningichu “Kayshinam kach'akachiwarqan”, nishpaqa. Ashwan kuramanlla riy, pay rikashushpa nishunambaq: “Kach'akashqanam kangi”, nishpa. Chaymandaqa apay ufrindaykita Muysis kamachikushqanshina, yumbay yach'ananllapa: Chay runaqam kach'akashqana, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jisus ch'ayaptin Kapirnawun llaqtamanmi, payman shamurqan suq suldadu rrumanu. Paymi achka suldadukunapa kamachikuqnin karqan. Chay kamachikuq suldadupa suq ancha kuyashqan kriyadunmi qeshyaq karqan. Chaymi chay suldaduqa qemikashpa, Jisusta kayshina rruqarqan: ");
INSERT INTO qvcNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Kamachikuq Taytitu, kriyaduymi wasiypi ancha qeshyaq kamapi. Mananam atinchu kuyuyta. Kanan nanaywanmi ancha padisin, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Chaymi Jisusqa nirqan: —Rishaqri kach'akachiq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Chaymi chay kamachikuq suldaduqa nirqan: —Kamachikuq Taytitu, qamkuna isrraylinukuna ningillapa: Manam balinchu suq isrraylinu yaykunambaq suq furastiru runapa wasinman, nishpa. Ancha pudirniyuqmi kangi. Chayri kamachikuylla, chay kriyaduy kach'akanambaqqa. Chayshinallam kach'akanqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Chaqa noqapismi kamachiwaqkunata kasuni. Chayshinallam suldaduykunapis ima nishqayta kasuwanllapa. Suqninda “riy”, niptiyqam, rin. Suqta “shamuy”, niptiyqam, shamun. Kriyaduykunata “kayta ruray”, niptiyqam, ruran. Chaymi yach'ani: Rimaptikillam, kriyaduyqa das rin kach'akaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Chayshina niqta uyashpaqam, Jisusqa ispantashpa, kushikushpa, chay pullan riqkunata nirqan: —¡Kay furastiru runaqam ancha shumitaqta kuntistawan! ¡Alliptam niykillapa, kay nasyunninchiq Isrrayilpiqam mana ni suq runata tarishqachu kani kay ancha yuyakuq furastiru runatashinaqa! ");
INSERT INTO qvcNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Chaymi niykillapa, yumbay nasyungunamanda achka furastirukuna Dyuspi kriyishpaqam, chay unay agwilunchiq Abrajanwan, Isakwan, Jakubuwan pulla tiyashpa, rinllapa mikuq Dyuswan syilupi. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Piru achka llaqta masinchiq isrraylinukunataqam (noqapi mana kriyishqanrayku), sawa tutayaqman rinllapa wichukuq. Chaypiqam ancha padisishqanrayku waqashpa kirunllapata rinllapa qech'yachiq. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Chayshina nishpaqam, Jisusqa chay kamachikuq suldadutaqa nirqan: —Riyna. Kriyishqaykishinam rin kaq, nishpa. Chay nishqan urasllam kriyadunqa kach'akarqanna. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Suq diyam Jisusqa Pidrupa wasinman shamushpa, Pidrupa swigranda tarirqan jibriwan qeshyaq kamapi kaqta. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Chaymi Jisus chay warmita makinmanda piskaptinlla, chay jibrimandaqa das kach'akarqan. Chaymandaqam atarishpana, paykunata qararqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Amsayaykaptinnam dyablukuna kamachishqan runakunata, warmikunata Jisusman apamurqanllapa. Chaymi payqa dyablukunata “Lluqshiy” niptinlla, chay runakunamanda lluqshirqanllapa. Kach'akachirqanmi yumbay chay apamushqan qeshyaqkunatapis. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Chayshinaqam karqan Dyuspaq rimaq Isayiyas kayshina iskibrishqan kumplinambaq: “Paymi tukuy laya nanayninchiqmanda kach'akachiwashqa kanchiq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Suq diya Jisusman ancha achka runa tandakaptinmi, ch'awpinllapapina kashpa, yach'akuqningunata nirqan: —Aku pasaq kay ancha atun qoch'apa waq chimba ladunman, qamkunawanlla kanaypaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Chayshina niptinmi, suq runa Muysispa liyningunata yach'achikuqqa qemikashpa, Jisusta nirqan: —Yach'achikuq Taytitu, maytapismi qamwanna munani riyta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Chaymi Jisusqa nirqan: —Surrukunam mach'ayniyuqkuna. Pishqokunam kamachayuqkuna. Piru noqa Dyusmanda shamuq runa kashpapismi, mana nima wasiyuqchu kani samanaypaqqa. (Chayri yach'akuqniy kashpaqa, qambis noqashina ancha ringi padisiq.) ");
INSERT INTO qvcNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Chaymandaqam suq yach'akuq masiy nirqan: —Taytitu, dijawayri puntata rinaypaq taytayta pambaq. Pambashpaqam qamwanna rini puriq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Chayshina niptinmi, Jisusqa nirqan: —Mas allim noqawan purinayki. Chaqa noqapi mana kriyiqkunaqam wañushqakunashina. Chayri shamuyna noqawan purinayki. Taytayki wañuptinqam, chay wañushqa laya aylluykikunana pambanqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jisusmi yach'akuqningunawan yakupi puriq barkupi rishpa, chay ancha atun qoch'ata pasaykarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Piru yakupa ch'awpimbi kaykaptinllapam, ancha jwirtitana wayrarqan. Chaymi yakuqa ancha maqchikamushpa undaykarqanna chay barkumanqa. Chayshina kaykaptinqam, Jisusqa puñuykarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Chaymi paykunaqa Jisusta rikch'achishpa, nirqanllapa: —¡Ay, Taytitu, washawayllapa! ¡Seqaykanchiqnam yakuman! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Chaymi Jisusqa nirqan: —¿Imaraykutaq ancha manchangillapa? Qamkunaqam mana allitachu noqapi yuyakungillapa. Chayshina nishpaqam, Jisusqa atarishpa, chay wayrata yakuta jwirtita rimashpa, kamachishpa, limpu qasillachirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Chaymi ancha ispantashqata nirqanllapa: —¿Ima laya runataq kay Siñurninchiq Jisusqa? Rikay, kamachiptinlla, yakuqa wayrawan kasushpa qasillarqan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jisus chay ancha atun qoch'ata pasashpam, ch'ayarqan Gadara lugarman. Chayshina ch'ayaptinmi, pantyunmanda ishkay lukukuna shamurqanllapa Jisusta tinguq. Chay lukukunapa ukumbiqam dyablukunapa ispiritunguna kashqanrayku, ancha wapukuna karqan. Kanan chay lukukuna ñambi kaptinllapaqam, mana pipis atirqanllapachu pasayta. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Chaymi Jisusman ch'ayashpaqa, chay lukukunaqa kayshina qayach'akurqan: —Qam Jisus Dyuspa Churinqa, ¿imapaqtaq mitikungi noqaykunamanqa? ¿Ima shamushqachu kangi kastigawaqllapa, manaraq jwisyu diya ch'ayamuptin? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Chay kaykashqanllapa sirkambiqam runakuna achka kuchikunata michiykarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Chaymi chay dyablukunaqa Jisusta ancha rrugarqanllapa: —Noqaykunata qatiwashpaqar, yush'ayku dijaway, waq kuchikunaman yaykunayllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Chaymi Jisusqa paykunata nirqan: —Mayá, riyllapa waq kuchikunaman, nishpa. Chayshina niptinmi, chay dyablukunaqa chay runakunamanda lluqshishpa, rirqanllapa chay kuchikunamanna. Chaymi chay kuchikunaqa das lukuyashpa, qaqamanda chay ancha atun qoch'aman yumbay seqashpa, yakupi ch'uqashpa, limpu wañurqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Chaymi chay kuchikunata michiqkunaqa ancha manchashpa, kallpaylla rirqanllapa Gadara llaqtaman abisakuq. Ch'ayashpaqam nirqanllapa: —Jisusqam chay ishkay lukukunataqa kayshina kach'akachirqan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Chaymi yumbay chay gadarinukuna manchashpa, Jisus kaykashqanman shamushpa nirqanllapa: —Jisus, yush'ayku kay llaqtamandaqa riyna suq laduman, nishpallapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Chayshina niptinllapaqam, Jisusqa yakupi puriq barkuman yaykushpa, pasarqan suq ladu chimbaman llaqta Kapirnawunman. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Chaymi chaypina kaykaptinqa, runakuna ch'ayarqanllapa suq runa wañushqashina kwirpuyuqta parapi apamushpa. Chaymi Jisusqa yach'ashpa: Chay runakunam noqapi ancha yuyakunllapa, nishpaqa, chay runa wañushqashina kwirpuyuqta nirqan: —Ijitu, ama llakiychu. Noqam uchaykikunamanda pirdunayki, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Chayshina Jisus niptinqam, Muysispa liyningunata wakin yach'achikuqkuna uyashpa, kayshina yuyarqanllapa: Kay runaqam Dyusshina yanqa tukushpa, Tayta Dyusta burlaykan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Chaymi Jisusqa yuyashqanllapata yach'ashpa, paykunata nirqan: —¿Imaraykutaq chayshina mana baliqkunataqa yuyaykangillapa? ");
INSERT INTO qvcNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mayá, ¿imataq mas trabajus ruranaypaq, ichu ninaypaq: “Uchaykikunatam pirdunayki” ichu ninaypaq: “Kach'akachiykim; atarishpa, riy” nishpa? ");
INSERT INTO qvcNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mayá, kayta rikachishqayki yach'anaykillapa: Tayta Dyus Jisusta pudirniyuqta rurashqa, kay mundupi runakunata uchangunamanda pirdunanambaq, nishpa. Chaymandaqam Jisusqa chay runa wañushqashina kwirpuyuqtaqa nirqan: —Atarishpa, paraykita apashpa, riyna wasikiman, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Chaymi chay runaqa das atarishpa, kach'akashqana rirqan wasinman. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Chay milagruta ruraptinqam, chay rikaqkunaqa ispantashqata Dyusta kayshina ancha alabarqanllapa: —Dyusilupagi, Taytitu, pudirnikitam qoshqa kangi chay runakunata, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisusqam chay kashqanmanda shamuqshinaqa, noqa Matiyuta rikawarqan kuntribusyun kubrakunay dispachuypi tiyaykaqta. Chaymi niwarqan: —Shamuy. Aku noqawan, nishpa. Chaymi noqaqa chay urasna paywan rirqay. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Chaymandaqam Jisus noqaykuna yach'akuqningunawan wasiypi mikuykaptiyllapa, wakin kuntribusyunda kubrakuq masiykuna, suq laya uchayuq runakunapis ch'ayamushpa, pullayllapana tiyarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Chaymi wakin farisiyu duktrinayuqkunaqa chayta rikashpa, noqaykuna Jisuspa yach'akuqningunata niwarqanllapa: —¿Imaraykutaq Jisusqa chay millanaypaq kuntribusyunda kubrakuqkunawan, chay suq laya mana baliqkunawanqa mikuykan? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Chaymi Jisusqa chayshina niqta uyashpaqa, nirqan: —Mana qeshyaqkunaqam mana munanchu ambikuqtaqa. Qeshyaqkunallam munan ambikuqtaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","(Kay uchayuqkunam qeshyaqkunashinaqa.) Chaymi paykunata washaq shamushqaqa kani. Manam shamushqachu kani chay allin tukuqkunata washaq. Chayrayku yach'akuyllapa Dyuspa Santu Librumbi kayshina nishqanda: “Noqaqam munani llakipakuqkuna kanaykillapa. Chaymi qamkuna suqkunata mana llakipaptikiqa, mana munanichu ufrindaykillapata qowashpa adurawanaykiqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jwan Shutichikuqpa yach'akuqningunam Jisusman qemikarqanllapa, kayshina tapunambaqllapa: —Taytitu, noqaykuna Jwanda kasuqkunaqam ayunanillapa. Yumbay chay farisiyu duktrinayuqpismi ayunanllapa. ¿Imaraykutaq qamba yach'akuqnikikunaqa mana ayunanllapachu? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Chaymi Jisusqa paykunata nirqan: —Mayá, suq runa kasaraykaptinqachuraq, yanasunguna (yanasanguna) chaypi pullan kaykaptin, ¿ayunanmanllapa? Manám. Chayshinallam kay yach'akuqniykunaqa noqawan kashpaqa, kushikuykanllapa. Chaymi manaraq ayunanllapachu. Piru suq diyam (ch'iqniwaqkuna) paykunamanda rinllapa akrawaq. Chayshina akrawaptinraqmi, paykunapis rinllapa ayunaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Manam pipis mawka mudanandaqa mushuq rritasuwanqa rrimindanchu, ¿manachu? Chayshina ruraptinqach'i, chay mushuq rritasuqa qendishpa, ashwamba llikinman chay mawka mudanataqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Chayshinallam llullu binutapis mana wichunchiqchu mawka qara taligamanqa. Chaqa chay llullu binuqash' qarwashpa, chay mawka qara taligata pach'yachinman. Chayshinam pulla qesachakanman binuwan qara taligaqa. Chaymi llullu binutaqa mushuq qara taligaman wichunchiq, ama ni binu ni taliga qesachakanambaq. Nuta: Jisuspa chay mushuq yach'achikushqanqam chay llullu binushina. Isrraylinukunapa chay unay kustumbringunaqam chay mawka qara taligashina. Chaymi mana balirqanchu taqllunanllapa Jisuspa mushuq duktrinangunata chay mawka kustumbrikunawanqa.  ");
INSERT INTO qvcNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Chayshina Jisus rimaykaptinmi, ch'ayamurqan suq runa. Chay runaqam isrraylinukunapa suq kamachikuqnin karqan. Payqam Jisuspa ñawpambi qonqorikushpa, kayshina ancha rruqarqan: —Taytitu, chinitaymi kanalitan wañurqanna. Yush'ayku aku kawsachinayki. Chaqa kriyinim: Makikita sawambi ruraptikim kawsarinqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Chaymi Jisusqa “Arí”, nishpa, chay lugarmanda lluqshishpa, noqaykuna yach'akuqningunawan chay runawanna rirqayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Chaymi ñanda riykaptiyllapaqa, suq warmipis noqaykunawan riykarqan. Chay warmitaqam dusi wata tukuyta yawar mana dijashqachu karqan. Chaymi yuyarqan: Jisuspa kapamba manyanda llamkashpallam kach'akashaq, nishpa. Chayshina yuyashpa, manchashpapismi, chay warmiqa ikinda riqshina Jisuspa kapamba manyanda ashlita llamkarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Chayshina llamkaptinmi, Jisusqa ikinman tikrakashpa, chay warmita chapashpa nirqan: —Ijita, ama manchashpachu, animakay. Noqapi allita yuyakushqaykiraykum kach'akashqana kangi, nishpa. Chaymi chay urasmandapacha chay warmiqa kach'akarqanna. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Chaymandaqam Jisusqa chay kamachikuq runapa wasinman ch'ayashpaqa, rikarqan runakunata, warmikunata kunyalla waqaykaqta, flawtirukunatapis. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Chaymi Jisusqa paykunata nirqan: —Ashuyllapa. Manam wañushqachu chinitaqa. Puñuykanllám, nishpa. Chaymi chay uyaqkunaqa Jisusta asiparqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Chaymandaqam chay asipaqkunataqa ukumanda sawaman surqoshpa, Jisusqa uku wasiman yaykurqan. Chaymandaqam chay almataqa makinmanda piskaptin, das kawsamushpa, shayarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Chaymi chay milagruta rurashqambaqqa, Jisuspa famanqa tukuy mayta shikwakarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Chay Jayrupa wasinmanda Jisuswan riykaptiyllapam, ishkay sarkukuna ikiyllapata rirqan, ancha jwirtita qayakushpa: —¡Unay Dabidpa Karu Willkan, yush'ayku llakipawayllapa! nishpa. Nuta: “Dabidpa Karu Willkanmi” munan niyta: “Dyus Akrashqan Washadur”, nishpa.  ");
INSERT INTO qvcNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Chaymandaqam Jisusqa suq wasiman ch'ayashpa, ukuman yaykuptinqa, chay ishkay sarkukunapis ikinda yaykurqan. Chaymi Jisusqa paykunata tapurqan: —¿Qamkunaqachu kriyingi: Jisusmi atin kach'akachiwayta? nishpa. Paykunaqam nirqan: —Arí, Taytitu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Chaymi Jisusqa ñawinllapata llamkashpa, nirqan: —Qamkuna kriyishqaykishina kanqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Chayshina niptinllam, paykunapa ñawingunaqa ancha klarutana rikakurqanllapa. Chaymandaqam Jisusqa paykunata nirqan: —Amakish pitapis parlachingillapachu kay rurashqaypaqqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Piru paykunaqam chay wasimanda lluqshishpa, waqman kaymanna rishpa, yumbayta parlachirqan: —Jisusmi kach'akachiwashqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Chayshina riykaptiyllapam, wakin runakunaqa suq muduta apamurqanllapa Jisusman. Chaqa dyablupa ispiritunmi chay runapa kwirpunman yaykushpa, muduyachishqa karqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Chaymi Jisus chay dyabluta runamanda qatiptinqa, atirqanna rimayta. Chaymi chayta rikaqkuna ancha ispantashqata nirqanllapa: —¡Manakish nunka kay Jisus rurashqandashinaqa rikashqallapachu kanchiq kay Isrrayilpiqa! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Piru farisiyu duktrinayuqkunaqam chayta rikashpaqa, Jisusta kuntrashpa, nirqanllapa: —Dyablukunapa kamachikuqnin yanapaptinmi, Jisusqa chay dyablukunata runakunamanda atin qatiytaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Chay diyakunapim Jisusqa ancha achka llaqtakunaman, kasiriyukunaman rirqan yach'achikuq. Chaymi sinaguga wasikunapi Dyuspa shumaq nutisyangunata yach'achikushpa, nirqan: —Taytanchiq Dyusmi dasna rin shamuq, shumaqta kamachikunambaq, nishpa. Chayshina yach'achikushpam, tukuy laya qeshyaqkunata kach'akachirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Chaymandaqam Jisusqa ancha achka ch'ayamuqkunata rikashpa, ancha llakiparqan. Chaqa chay ch'ayamuqkunaqam ancha shaykushqa, wichukudu mana michidurniyuq wishakunashina karqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Chaymi payqa noqaykuna yach'akuqningunata niwarqanllapa: —Alliptam niykillapa, chay achka maskawaqkunaqam ancha achka kusichashina. Piru kusichadurkunaqam ashlitalla kanchiqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Tayta Dyusmi chay kusichapa dwiñun. Chayri payman mañakuyllapa, mas kusichadurkunata numbranambaq, yanapawananchiqllapa, yumbayta yach'achinanchiq, Dyuspi kriyinanllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisusmi yumbay chay yach'akuqninmanda dusi runakunata akrawashpa, pudirniyuqkunata rurawarqanllapa, atinayllapa runakunamanda dyablukunata qatiyta, tukuy laya nanaywan kaqkunata atinayllapa kach'akachiyta. Nuta: Chay dusi akrashqangunaqam “apustulkuna” shutirqanllapa.  ");
INSERT INTO qvcNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Chay dusi apustulkunaqam kaykuna karqayllapa: puntatam Simun; payllam Pidrupis shutin; chay Pidrupa masan Andris, Sibidiyupa churinguna Jakubuwan Jwan, ");
INSERT INTO qvcNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipi, Bartulu (payllam Natanayilpis shutin), Tumas. Suqqam noqa Matiyu. Unaymi noqaqa kuntribusyunda kubrakuq karqay. Suqqam Alfiyupa churin Jakubu. Suqqam ˻Libiyu; payllam˼ Tadiyupis shutin. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Suqqam suq Simun. Payqam isrraylinu Kananista partidumanda karqan. Suqqam Judas Iskaryuti. Chay Judas Iskaryutim Jisusta intrigakurqan chay kuntraqkunamanqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisusmi noqaykuna dusi yach'akuqningunata manaraq kach'awashpa, kayshina kunawarqanllapa: —Amakish chay suq nasyungunamanqa ringillapachu. Amakish chay prubinsya Samaryamambis ringillapachu. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ashwan riyllapa llaqta masinchiq isrraylinukunamanlla. Chaqa paykunaqam chingashqa wishakunashina puriykanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Chayri niyllapa: “Taytanchiq Dyusmi kay tyimpupi qallariykan shumaqta kamachikuq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Chayshina yach'achikushpaqar, qeshyaqkunata kach'akachiyllapa. Chay ismuykaq kwirpuyuqkunatapis kach'akachiyllapa. Wañushqakunatapis kawsachiyllapa. Dyablukunatapis runakunamanda, warmikunamanda qatiyllapa. Chaqa qamkunataqam dibaldilla pudirniyuqta rurashushqallapa kani. Chayri qamkunapis chay pudirniywanqa yumbayta yanapayllapa, ama nimata kubrashpachu. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Chayshinalla riyllapa. Amakish ñannikipaqqa apangillapachu uruta, ni qellayta ni kubrimanda qellaykunatapis bulsikuykipiqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Amar ni alfurjata ni llanqeta ni burdunda apayllapachu. Mudanaykitapis suqsitutalla apayllapaqa. Chaqa suqkunata yach'achiptiki, kach'akachiptikiqam, alli paykuna qamkunata qarashunambaq. Manchu suq trabajaqqa dirichuyuq, pagunda ch'askinambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Chayri suq llaqtaman ichu suq kasiriyuman ch'ayashpaqa, maskayllapa suq allin runata, chaypi paywan kidanaykillapa, chay llaqtamanda rinaykillapa diyakaman. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Suq wasiman ch'ayashpaqar, shumaqta napaykushpa, Dyusman mañakuyllapa, chay wasipi tiyaqkunata yanapanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Chay wasipa dwiñun shumaqta qamkunata ch'ayachishuptinqa, masta mañakuyllapa paykunapaq. Piru qamkunata fyirusyashuptinqa, paykunapaqqa amana mañakuyllapachu. Chaqa Dyusqam mana rinchu yanapaq paykunataqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Chayshina mana munaptinllapa chay wasiman ch'ayachishuyta ni uyashuytaqa, chay wasimanda ichu chay llaqtamandaqa das lluqshishpa, riyllapa suq ladumanna. Ch'akikillapamanda pulbuta ch'apsiy, chay llaqtapi tiyaqkuna yach'anambaq: Chay yach'achikuqkunaqam manana kwintayuqchu noqanchiqkunawanqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Alliptam niykillapa, jwisyu diyapiqam chay mana ch'askishuqkunataqa ancha fiyuta rinllapa kastigaq, maski chay ancha uchayuq runakuna Sudumapi, Gumurrapi tiyaqkunamanda. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jisusqam niwarqanllapapis: —¡Alliptam niykillapa! Uñitakunata ancha atun surrukunapa ukunda kach'aykaymanshinam, qamkunataqa kach'ayki, chay malu runakunapa ukunda rinaykillapa. Chayri ancha sabidu kayllapa kulibrashina, yumbayta allita yanapanaykillapa. Piru ancha allin mana nimata dañachikuq palumitashinar kayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Allita yuyashpa, kwidakashpa puriyllapa. Chaqa chay wapu runakunam prisushushpa, awturidarkunapa ñawpambi rinllapa dimandashuq. Rinllapapismi asutishuqllapa sinaguga wasikunapi. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kanan noqapi kriyiptikiqam, prifiktukunaman, gubyirnukunaman rin apashuqllapa. Chaymi qamkunaqa chay awturidarkunapa ñawpambi, chay mana isrraylinu kaqkunapa ñawpambipis noqapaq ringillapa yach'achikuq. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Chayri awturidarkunaman qamkunata apashuptinqa, ama llakiyllapachu: ¿Imataraq rimashaq? nishpaqa. Chaqa prisushuptinllapaqam, chay uras Dyus kikin rin yanapashuqllapa, shumaqta paypaq yach'achikunayki. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Chaqa chay uraspiqam manana qamkunallachu ringillapa yach'achikuqqa. Ashwanmi Dyuspa Santu Ispiritun qamkunapi kashpa, rin yanapashuq, shumaqta rimanayki. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Wakingunaqam chay tyimpupi masanda rinllapa intrigakuq wanchinambaqllapa. Wakin taytaqam wambranda rin intrigakuq. Wakin wambrangunaqam taytanda mamanda kuntrashpa, rinllapa intrigakuq wanchinambaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kanan noqapi kriyishqaykiraykum, achka runakuna qamkunata rinllapa ch'iqnishuq. Chayshina padisishpa, noqapi mana shaykuq yuyakuptikillapa wañunayki diyakamanqam, rini washashuq. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Chayri suq llaqtapi qamkunata qesachashuptinqa, suq llaqtaman mitikayllapa. Chaqa alliptam niykillapa, qamkuna manaraq yach'achikuptiki kay Isrrayilpa yumbay llaqtangunapim, noqaqa Dyusmanda Shamuq Runa rini kutimuq. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","’Piru noqata qesachawashqanshinam, qamkunatapis rinllapa qesachashuq. Chaqa suq yach'achikuqmi mas rrispitadu rin kaq yumbay yach'akuqninmandaqa. Chayshinallam suq patrumbis mas pudirniyuq rin kaq yumbay kriyadunmandaqa. Chayri suq yach'akuqqa yuyanqa: Allita yach'akushaq, chay yach'achikuqniyshina kanaypaq, nishpa. Chayshinallar suq kriyadupis yuyanqa: Allita yach'akushaq, patrunniyshina kanaypaq, nishpa. Piru noqapaq niptinllapa: “¡Jisukristum chay mas pudirniyuq dyablu Bilsibu!” nishpaqam, qamkunataqa ashwamba rinllapa musyashuq. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jisusqam kayshinapis yach'achiwarqanllapa: —Runa masikitaqa ama manchayllapachu. Chaqa tukuy ima pakadu kaqpaqmi ancha klaruta rinchiqllapa yach'aq. Tukuy ima pakaduta maychika ñigashqapis, yach'ashqa rin kaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Chayri chay pakadu nishushqaytaqa, qamkunaqa amana pakashpachu, yumbayta yach'achiyllapa. Chay uyaritap nishushqaytaqa, wasikikunapa sawanmanda ancha jwirtita rimayllapa, yumbay uyashunanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Chayshina rimashpaqa, ama manchayllapachu wanchikuqkunataqa. Chaqa paykunaqam qamkunapa kwirpuykitalla atinman wanchiyta. Piru almaykitaqam mana nimatapis atinllapachu dañachiytaqa. Chayri Taytay Dyustalla manchayllapa. Chaqa payqam kwirpuykillapata almandinda atin chingachiyta infyirnupi. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’(Tayta Dyusmi ancha allita kwidashungillapa. Chayri ama manchayllapachu chay wanchikuqkunataqa.) ¿Manachu ishkay pishqetuta suq rriyalitupaqlla randikunllapa? Piru mana baliqsitukuna kaptimbismi, ni suq pishqetu atinchu wañuyta Taytanchiq Dyus mana dijaptinqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Dyusmi ancha allita kwidashushpa, yumbay aqchaykillapatapis ancha allita yupashqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Chayri ama pitapis manchayllapachu. Chaqa qamkunaqam pishqokunamandaqa masta balingillapa Dyuspaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Qamkuna runakunapa ñawpambi noqapaq niptikillapa: “Noqam Jisukristuta sigini” nishpaqam, noqapis qambaqqa syilupi Dyuspa ñawpambi rini niq: “Paymi allipta noqata sigiwashqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Piru penqakushpa, runakunapa ñawpambi ñigawaptiki: “Manam siginichu Jisusta”, nishpaqam, noqapis Taytay Dyuspa ñawpambiqa rini ñigashuq: “Manam riqsinichu paytaqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Jisusqam kayshinapis yach'achiwarqanllapa: —Noqapaqqa ama yuyayllapachu: Jisusmi kay munduman shamushqa, ama pipis qesachawananchiq, nishpaqa. Ashwanmi noqapi kriyiptikillapaqa, aylluykikuna, suqkuna rinllapa qesachashuq. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Chaqa wakin runakuna noqapi kriyiptinqam, ullqo wambran rin kuntraq. Wakin warmikunapis noqapi kriyiptinqam, warmi wawan rin kuntraq. Chayshinallam wakin llumchukunapis swigranllapata rin kuntraq. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Chayshinallam kikin aylluykikunapis kuntraykillapa rin kaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’(Chaymi niykillapa, yumbay runakunata kuyashpapis, noqata masta kuyaway.) Piru mayqanniki noqata ashlatalla kuyawashpa, taytaykita ichu mamaykita masta kuyashpaqam, mana balingichu yach'akuqniy kanaykiqa. Chayshinallam noqata ashlatalla kuyawashpallapa, wambraykikunata masta kuyashpaqa, mana balingichu noqapa yach'akuqniy kanaykillapaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Chayri noqapi kriyishqaykirayku padisishpa ichu suq kruspi munaptinllapa wanchishuytapis, allita kasuwashpaqa, noqapa allip yach'akuqniy ringillapa kaq; manaqa manám. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Chaymi mayqanniki noqata ñigawashpa bidaykita washanaykiqa, ringillapa chingaq tukuy tyimpupaq. Piru noqapi kriyishqaykirayku wanchishuptinllapaqam, noqa rini washashuq, tukuy tyimpu noqawan kawsanaykipaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jisusqam niwarqanllapapis: —Mayqan runa ichu warmi qamkunata shumaqta ch'ayachishushpaqam, noqata ch'ayachiwaykanshina. Chayshina noqata ch'ayachiwashpaqam, Taytay Dyustapis ch'ayachiykanmanshina. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Chaqa Dyuspaq rimaqta, shumaqta ch'ayachiptikiqam, Dyusqa primyuykita rin qoshuq chay rimaqpa primyundashina. Chayshinalla Dyus munashqanda ruraykaq runata yanapaptikiqam, paypa primyundashina Dyus rin qoshuq. ");
INSERT INTO qvcNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Chayraq yach'akuykaq wambraykunata yanapashpam, primyuykita ringi ch'askiq. Chaqa allipta niykillapa, chiri yakituta qoptiki upyananmi, Taytanchiq Dyus ancha shumaq primyuykita rin qoshuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisusmi noqaykuna dusi yach'akuqningunata kunawashpaqa, chay llaqtamanda suq llaqtakunamanna rirqan, Dyuspa shumaq nutisyanda yach'achikuq. ");
INSERT INTO qvcNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Chay Jwan Shutichikuqmi karsilpina kashpa, yach'arqanna Jisukristu ruraykashqambaq. Chaymi ishkay yach'akuqninda Jisusman kach'arqan, kayshina tapunanllapa: ");
INSERT INTO qvcNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","—Taytitu, ¿Dyusmanda chay shamunambaq Akrashqan Washadurqachu qam kangi, ichu suqtaraq shuyashaqllapa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Chayshina tapuptinllapaqam, Jisusqa nirqan: —Riyllapa, Jwanda willay noqa yach'achikushqayta uyashqaykita, kay rurashqayta tukuy ima rikashqaykita. ");
INSERT INTO qvcNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Chaqa sarkukunaqam kach'akachiptiy rikakunna. Kujukunapismi purinna. Kwirpun ismuykaqkunapismi allinna kidan. Surdukunapismi uyakunna. Wañushqakunapismi kawsamunna. Pubrikunatam Taytanchiq Dyuspa shumaq nutisyanda yach'achiykani. ");
INSERT INTO qvcNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","(Chayri Jwanda niyllapa, noqapi mas allita kriyinambaq.) Chaqa noqapi chay mana shaykuq kriyiqqam ancha rin kushikuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Chaymandaqam Jwamba chay kach'adunguna riptinllapaqa, Jisusqa chaypi kaqkunata kayshina yach'achikurqan Jwan Shutichikuqpaq: —¿Ima laya runatam rirqaykillapa chapaq chay chuncha lugarmanqa? ¿Rirqaykillapachu chapaq suq runa mana alli yach'aqta, suq kañata wayra waqman kayman kuyuchiqtashina? Manám. ");
INSERT INTO qvcNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ichu ¿rirqaykillapaqa chapaq suq runa ancha ch'aniyuq shumaq mudanayuqta? Manám. Chaqa qamkunaqam allita yach'angillapa, chay ancha shumaq mudanayuqkunaqam gubyirnukunapa atun wasingunapi tiyanllapa, ¿manachu? ");
INSERT INTO qvcNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Chaymi tapuykillapa: ¿imata rikaqtaq rirqaykillapaqa? Rirqaykillapa rikaqqam Dyuspaq suq ancha yach'ayniyuq rimaqta, ¿manachu? Arí, qamkuna chay rikashqaykiqam Dyuspaq yumbay rimaqkunamandaqa mas klaruta noqapaqqa yach'achikushqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Chaymi Jwan Shutichikuqpaq Taytay Dyusqa Santu Librumbi kayshina niwarqan: Qamba mas puntaykitam noqanchiqpaq suq rimaqta rini kach'aq. Chaqa paymi qambaq rin yach'achikuq, chay uyaqkuna shumaqta ch'ayachishunanllapa. Chayshina yach'achikushpaqam, ñannikita allichaykanmanshina, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Chaymi allipta niykillapa, runakuna kawsashqan diyamandapacha kanangamanqam, mana pipis kashqachu Jwan Shutichikuqmanda mas baliqqa. Piru noqapi kriyiqkunamanda chay yaqqa mana baliqqam chay Jwanmanda mas pudirniyuq rin kaq syilupiqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Chaymi chay Jwan Shutichikuq yach'achikushqan diyamandapacha achka runakuna, warmikuna Tayta Dyusta allitana kasuykanllapa. Piru achka wapu runakunapismi Dyusta ancha kuntraykanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kanan chay Jwan Shutichikuq manaraq yach'achikuptinmi, unay tyimpukunapi Muysis liynimbi, Dyuspaq yumbay rimaqkuna librungunapipis nirqanllapa: “Taytanchiq Dyusmi suq diya tukuy maypi rin kamachikuq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Chayri kay nishushqayllapata paqtar qamkuna intyindingiman: Chay Eliyas shamunambaq kaqqam chay Jwan Shutichikuq kashqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Chayri qamkuna rinriyuqkunaqa, allita uyawashpa intyindiyllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’Piru kay tyimpumanda mana kriyiqkunaqam chay wambra mana munaq pugllaqkunashina. Manchu wakin wambrakunaqa plasakunapi pugllanllapa, fyistatashina rurashpa ichu suq almata pambaykaqshina tukushpa. Piru wakin wambrakuna mana munaptin pugllaytaqam, chay pugllaqkunaqa kayshina anyanllapa: ");
INSERT INTO qvcNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Flawtata waqachiptiyllapam, ay, qamkunaqa mana munangillapachu dansayta. Chaymandaqam noqaykuna llakiy llakiyta yupakuptiypis, qamkunaqa mana munangillapachu waqayta noqaykunawanqa”, nishpa. (Chayshinallam wakinnikipis mana munangillapachu uyayta ni Jwan Shutichikuqta ni noqata.) ");
INSERT INTO qvcNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Chaqa chay Jwan shamushpa, allinda mana mikuptin, binuta mana upyaptin, chay yupakuq wambrakunashina kaptinmi, qamkunaqa nirqaykillapa: “Waq Jwamba uku kwirpumbim dyablupa ispiritun”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Chaymandaqam noqa Dyusmanda Shamuq Runa shamushpa, imata mikushpa upyaptiyqa, ningillapa: “Chay Jisusqam mana undaqchu mikun, binuta upyan. Kanan kuntribusyunda kubrakuqkunawan suq laya uchayuqkunawanmi tandakan”, nishpa. Piru noqapi kriyiqkunaqam Dyus munashqanshina kawsaptinllapa, suqkuna rikashpa rinllapa yach'aq: Taytanchiq Dyusmi ancha yach'ayniyuq kashpa, Churin Jisusta, chay Jwan Shutichikuqtapis kach'amushqa, noqanchiqkunata yach'achiwananchiq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jisukristu chay llaqtakunapi achka milagrukunata ruraptimbismi, chaypi tiyaqkunaqa mana munarqanllapachu uchanllapata dijaytaqa. Chaymi Jisusqa kayshina anyarqan: ");
INSERT INTO qvcNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Ay, imanangiraqri qamkuna Kurasin llaqtapi tiyaqkuna, qamkuna Bitsayda llaqtapi tiyaqkunaqa! Chaqa ñawpaykillapapim achka milagrukunata ruraptiypismi, mana munangillapachu noqapiqa kriyiyta. Piru qamkunapi rurashqay milagrukunata waq uchayuq Tiru llaqtapi, waq Sidun llaqtapi ruraptiyqach'i, paykunaqa unayna uchangunata dijanandallapa. Chaqa paykuna mana allikunata rurashqanrayku syintishpach'i, waqashpa, lutu mudanakunata rurakushpa, ush'pata sawanman basyanandallapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kaykish niykillapa, jwisyu diyapiqam qamkunaqa chay Tirumanda Sidunmanda kaqkunamandaqa mas kastigadu ringillapa kaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","’Mayá, qamkuna Kapirnawumbi tiyaqkunaqa, ¿imatam yuyangillapa? ¿Palanganukuna kashpachu yuyangillapa: Syilumanmi rini ch'ayaq, nishpa? ¡Manám! Ashwanmi qamkunataqa rinllapa wichushuqllapa wañushqakuna kashqanman. Chaqa kay milagrukuna qamkunapi rurashqayta waq chingachishqa Suduma llaqtapi ruraptiyqach'i, chaypi tiyaqkunaqa uchanllapataqa dijanandana. Chayshina dijaptinllapaqam, Tayta Dyusqa chay llaqtandaqa mana chingachinandachu. Ashwanmi kanangaman kananda. ");
INSERT INTO qvcNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kaykish niykillapa, jwisyu diyapiqam qamkunaqa chay Suduma llaqtapi tiyaqkunamandaqa mas kastigadu ringillapa kaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","26","Chay tyimpupim Jisusqa Tayta Dyusta nirqan: —Taytitu, kay pachapa, anaq syilupa kamachikuqninmi qamlla kangi. Kanan yuyashqaykitam chay yach'ayniyuqkunamanda pakashqa kangi. Piru chay mana yach'aqkunatam chay yuyaynikikunata yach'achishqa kangi. Chaqa chayshina kanambaqmi munashqa kangi, Taytitu. Chaymi ancha alabayki. ");
INSERT INTO qvcNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Chaymandaqam Jisusqa nirqambis: —Taytay Dyusmi noqatalla akrawashqa, tukuy imata paypaq yach'ashpa, pudirniyuq yach'achikuq kanaypaq. Chaqa manam pipis alliptaqa riqsiwanchu. Taytayllam riqsiwan Churin kashqaytaqa. Chayshinallam paytapis mana pipis riqsinchu. Noqa sapalan Churin kaqllam paytaqa riqsini. Kanan noqapi kriyiqkunata yach'achiptiymi, paykunapis atinllapa Taytay Dyustaqa riqsiyta yuyayninllapapi. Nuta: Piru paykunaqam ancha yuyarqanllapa: ¿Imashinam atini kasuyta Muysispa yumbay liyningunata washakanaypaq, Taytanchiq Dyus ama kastigawanambaq? nishpa. Chayshina ancha yuyashpaqam, suq ancha llashaq yugutashina apaykarqanllapa. Chaymi Jisukristuqa paykunata kayshina nirqan:  ");
INSERT INTO qvcNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","’Qamkuna yugutashina apaqkuna, shaykushpa, shamuy noqaman samachishunaqpaqllapa, amana llakinaykillapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Chaqa noqamanda yach'akuqqam suq yunta wangudushina noqawanqa rin kawsaq. Kanan noqaqam ancha manshu ancha umildi kani. Chaymi mana trabajuschu rin kaq qamkuna noqawan purinaykiqa. Chaymi noqapi yuyakushpa, mana nimata llakishpachu, noqapina atingillapa samayta. ");
INSERT INTO qvcNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Chaqa manam trabajuschu rin kaq qamkuna chay yach'achishushqayta kasunaykiqa. Suq mana llashaq yugitushinam rin kaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Waq tyimpupim Jisusqa noqaykuna yach'akuqningunawan samana diyapi trigu tarpudupa ukunda riykarqayllapa. Chaymi noqaykuna yach'akuqningunaqa mallaqnashpa, pasaqshina trigupa ispiganda pitikushpa, qaqokushpa mikurqayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Chaymi wakin farisiyu duktrinayuqkunaqa rikawashpallapa, Jisusta anyarqan: —Liyninchiqpim kamachiwanchiq, samana diyapi ama trabajananchiq. Rikay, yach'akuqnikikunaqa kay samana diyapi qaqokushpa trabajaykanllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Chaymi Jisusqa chay farisiyukunata nirqan: —¿Ima, manachu liyishqallapa kangi chay unay gubyirnu Dabid kumpañirungunawan mallaqnashpa rurashqandaqa? ");
INSERT INTO qvcNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Chaqa payqam yaykurqan karpamanda adurana wasiman mikunata maskaq. Chay adurana wasipi ufrinda tandakuna kaqmi kurakunapaqlla karqan. Suqkunaqam mana atiqllapachu mikuytaqa. Piru chay Dabidqam kumpañirungunawan mana dirichuyuq kashpapis, chay ufrinda tandakunata mikurqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Manachu Muysispa librunda liyishqallapa kangi? Chaypiqam nin: “Dyuspa adurana wasimbiqam kurakunaqa samana diyata mana gwardashpachu trabajanqallapa”, nishpa. ¿Chayshina trabajashpachu, paykunaqa uchata ruraykanllapa? Manám. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Alliptam niykillapa, Dyuspa chay adurana wasinmandaqam noqa mas baliqqa kani. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Chaqa Dyuspa Santu Librunmanda intyindishpaqach'i, kay nishqandaqa yach'angimanllapa: “Manam munanichu animalkunata wanchishpa, chay laya ufrindata qowanaykillapaqa. Ashwanmi munani suqkunata llakipanaykillapa”, nishpa. Chayta intyindishpaqach'i, qamkunaqa kay mana uchayuqkunataqa mana wichupanaykitachu. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Noqaqam Dyusmanda Shamuq Runa kashpa, samana diyapa dwiñun kani. Chaymi atini kamachikuyta: Kaymi alli ichu kayqam mana allichu, samana diyapi rurananchiqqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jisusqam chay kashqayllapamanda rishpa, sinaguga wasiman yaykurqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Chaypim karqan suq qendishqa makiyuq runa. Chaymi wakin isrraylinukuna Jisusta munashpa dimandayta, yanqa tapurqanllapa: —Mayá, ¿Dyusqachu kamachiwanchiq samana diyapi suq qeshyaqta kach'akachinanchiq ichu mana? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Chaymi Jisusqa chay tapuqkunata nirqan: —Mayqannikipa suq wishayki samana diyapi seqaptin suq pusumanqa, ¿manachu das surqongiman? ");
INSERT INTO qvcNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Kanan suq runaqam suq wishamandaqa masta balin. Chaymi liyninchiq dijawanchiqllapa, samana diyapi runa masinchiqkunata allita rurananchiqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Chaymandaqam chay chaki makiyuq runata nirqan: —Chutay makikita, nishpa. Chaymi runapa makinqa chaki kashqanmanda das allinyarqan, chay suq ladu makin allin kaqshinana. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Piru chay farisiyu duktrinayuqkunaqam chay uras sawaman lluqshishpa, kunanakurqan, Jisusta wanchinanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Chay farisiyukuna kunanakuptinqam, Jisusqa yach'arqan. Chaymi chay sinaguga wasimanda lluqshishpaqa, paykunamanda akrakashpa, suq ladumanna rirqayllapa. Piru ancha achka runakuna, warmikunam sigirqanllapa. Kanan Jisusqam yumbay qeshyaqkunata kach'akachishpa, ");
INSERT INTO qvcNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","kayshina kamachirqan: —Amakish suqkunataqa parlachingichu: “Jisusmi kach'akachiwashqa”, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Chayshina Jisus niptinmi, Dyuspaq rimaq Isayiyas nishqan kumplirqan. (Chaqa Isayiyaspa librumbim Tayta Dyus Churimbaq kayshina nishqa karqan): ");
INSERT INTO qvcNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Kaymi akrashqay yanapawaqqa. Paytam ancha kuyani. Paywanmi ancha kushikuni. Chaymi Ispirituyta qoptiy, payqa tukuy kay mundupi tiyaqkunata noqapaq rin yach'achiq: “Kayshinam Tayta Dyus allin justisyata rin ruraq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Chay yanapawaqqam mana ni piwambis anyanakunqachu. Chaymi mana ni pipis rinchu uyaq kallikunapi anyanakuptinqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ancha llakipakuq kashpam, chay manaraq allita kriyiqkunataqa mana rinchu wichukuq suq llawikaykaq kañatashinaqa. Chay ashlalla kriyiqkunataqam mana rinchu wanchiq salqayaykaq michatashinaqa. Chayshinam rin llakipakuq, malukunata binsishpa, allin justisyata ruranangaman. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kanan yumbay nasyungunapi achka runa warmim paypi rinllapa yuyakuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Suq dyablum suq runaman yaykushpa sarkuyachishpa, muduyachishqa karqan. Chayraykum chay sarku mudu runata Jisusman apamuptinllapa, payqa kach'akachirqan. Chaymi chay runaqa atirqanna chapakuyta, parlayta. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Chayraykum payta rikaqkunaqa ancha ispantashqata kayshina tapunakurqanllapa: —¿Kay Jisusqachuraq chay unay gubyirnu Dabidpa Karu Willkan chay shamunambaq Washadurninchiq? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Chayshina tapunakuptinmi, farisiyu duktrinayuqkunaqa uyashpa nirqan: —Kay runaqam mana payllachu dyablukunataqa qatin. Chay mas pudirniyuq dyablu Bilsibu yanapaptinmi, atin qatiytaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jisusqam chay yuyashqanllapata yach'ashpa, kayshina nirqan: —Mayqan nasyumba awturidarninguna paykunapura pilyanakushpaqash', chingachinakunman. Suq llaqtapi ichu suq ayllupi paykunapura pilyashpaqam, ushyanakunman. Maychikapisch'i mana atinmanllapachu duraytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Chayshinallam chay Satanaspis dyablu masingunawan pilyashpaqa, mana atinmanchu suqkunata binsiyta. Chayshinaqach'i limpu chingachinakunman. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Qamkunaqam noqapaq ningillapa: “Dyablu Bilsibu yanapaptinmi, qatin dyablukunataqa”, nishpa. Chayshina kaptinqa ¿chay kikin Bilsibuchu yanapan wakin yach'akuqnikitapis, dyablukunata qatinambaqqa? ¡Manám! Chaymi paykuna rikachishungillapa qamkuna pandashqaykitaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Chaqa Dyuspa Santu Ispiritunmi noqataqa yanapawan, dyablukunata runakunamanda qatinaypaqqa. Chaymi allita yach'anchiqllapa: Dyuspa pudirninqam ch'ayamuykanna qamkunaman, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Chaqa suq qoch'ikuq runaqam mana atinchu dasqa qoch'iyta imangunata suq ancha wapu runataqa. Chay qoch'ikuqqam puntata chay wapu runata binsishpa, alli alli ch'aqnashparaq, atin qoch'iyta imandaqa. (Chay runashinam noqapis dyabluta binsishpa, runakunata, warmikunata qoch'ini washanaypaq), nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Jisusqam nirqambis: —Chay mana yanapawaqqam kuntrawaykan. Chaymi mana yanapawanchu, runakunata, warmikunata tandanaypaqqa. Ashwanmi tandashqaykunataqa shikwaykan. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Chayshina kaptimbismi, Dyusqa runakunapa tukuy laya uchangunata rin pirdunaq. Piru Dyuspa Santu Ispiritunda kuntrashpa rimaqkunataqam mana rinchu pirdunaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Chaqa mayqan kuntrawaqtam Tayta Dyusqa atin pirdunayta. Piru Santu Ispiritunda kuntrashpa rimaqkunata mana rinchu pirdunaq, ni kay bidapi, ni suq bidapi. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Suq allin yuraqam allinda puqon. Piru suq mana baliq yuraqam mana baliqta puqon. Chaqa suq yurataqam riqsinchiq puqoyninmanda. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡A, farisiyu duktrinayuqkuna, qamkunaqam kulibrakunapa wawanguna kangillapa! ¡Malukuna kashpam, mana atingillapachu allikunata rimaytaqa! Chaqa shimikillapaqam shunqoykillapapi kaqkunata riman. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Chaymi allin runaqam shunqombi allita yuyashpa, allita riman. Piru malu runaqam, shunqombi mana allita yuyashpa, chayshinalla mana allikunata riman. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Chaymi niykillapa, jwisyu diyapiqam yumbay ringillapa kwintata qoq chay mana baliq rimashqaykipaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Chaymi chay rimashqaykimanda Dyusqa jusgashushpa, rin nishuqllapa: “Uchayuqmi kangi”, ichu “Manam uchayuqchu kangi”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Jisukristu chayshina niptinmi, wakin farisiyu duktrinayuqkunaqa Muysispa liyningunata yach'achikuqkunawan Jisusta nirqanllapa: —Yach'achikuq Taytitu, munanillapam suq milagruta ruranaykipaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Chaymi Jisusqa paykunata nirqan: —Qamkunaqam ancha uchayuq kashpa, Dyusta mana munangillapachu kasuyta. Kanan munangillapam suq milagruta rikayta. Piru manam rurashaqchu qamkuna munashqaykitaqa. Ashwanmi kayshina kanqa. Manchu unay tyimpupi Dyus rurarqan suq milagruta paypaq rimaq Junaswan. Chay laya milagrutallam Dyusqa noqawambis rin ruraq, qamkuna rikanaykiqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Chaqa Junasqam suq ancha atun piskadupa ukumbi kimsa diya, kimsa tutata karqan. Chayshinallam noqapis kimsa diya, kimsa tutata uku allpapi rini kaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","(Chaymandaqam chay Junasta piskadu wichukuptinqa, rirqan Ninibi llaqtaman, Dyuspaq yach'achikuq.) Chayshina Junas yach'achikuptinmi, chay ninibinukunaqa uchangunata dijashpa, Dyustana kasurqanllapa. Chaymi jwisyu diyapiqa chay ninibinukuna qamkuna farisiyukunata, qamkuna Muysispa liyningunata yach'achikuqkunata rin shimbishuqllapa: “Qamkunaqam ancha uchayuqkuna kangillapa”, nishpa. Chaqa chay Junasmanda mas pudirniyuq kaptiypismi, mana kasuwangillapachu. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Chay jwisyu diyapim Saba nasyumba gubyirnambis kawsamushpa, kay tyimpumanda kaqkunataqa rin shimbishuqllapa. Chaqa chay gubyirna warmiqam ancha karu nasyunmandapacha shamurqan, chay yach'ayniyuq gubyirnu Salumun yach'achikushqanda uyaq. Piru kaypi Salumunmanda mas yach'ayniyuq kaptiypismi, mana munangillapachu uyawaytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Suq dyablum suq runamanda lluqshishpaqa, rin puriq chuncha lugarkunaman, maskashpa maypi tiyanambaq. Piru mana tarishpa tiyanandaqam, chay runa lluqshishqanmanda kaqpaq yuyashpa nin: ");
INSERT INTO qvcNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“¡A, paymanlla kutirishaq!” nishpa. Chayshina yuyashpa, kutirishpaqam, chay runataqa tarin suq illaq wasi pichadutashina. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Chaymi rin riq apamuq mas dyablu masingunata. Chaymi chay punta dyabluqa syiti dyablukuna mas fiyuta tarishpa, apamun chay runaman. Chayshinam suq trupa dyablukunapa ispiritunguna chay runamanqa yaykunllapa, wasipishina tiyaq. Chaymi chay runaqa ashla malu kashqanmandaqa mas maluna tikrakan. Chayshinallam rin kaq kay malu runakunawambis, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisus runakunata parlachiykaptinmi, maman masangunawan ch'ayarqan. Chaymi paywan munashpa parlayta, sawapilla shuyaykarqanllapa. ˻ ");
INSERT INTO qvcNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Chaypi paykuna shuyaykaptinqam, suq runa Jisusta nirqan: —Kay sawapim mamitayki masaykikunawan shuyashuykan. Anchash munanllapa parlayta qamwan, nishpa.˼ ");
INSERT INTO qvcNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Chaymi Jisusqa chay willaqtaqa nirqan: —¿Pitaq mamay? ¿Pitaq masaykunaqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Chaymandaqam makinwan noqaykuna yach'akuqningunaman rikachikushpa, nirqan: —Kaykunam mamitay, masaykunaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Chaqa Tayta Dyus munashqanda kasuqkunam mamay, masaykuna, paniykunaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Jisusqam chay diyalla wasimanda lluqshishpa, rirqan chay ancha atun qoch'apa manyanman yach'achikuq. Chayman ch'ayashpa tiyaykaptinmi, ");
INSERT INTO qvcNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ancha achka runakuna, warmikuna payman shamushpa, qoch'apa manyambi undarqanllapa. Chaymi payqa yakupi puriq barkuman lluqshishpa, chay barkupi tiyarqan yach'achikunambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Chaymandaqam Jisusqa achka laya kumparasyunda rurashpa, kayshina yach'achikurqan: —Suq runam rirqan tarpukuq. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Chaymi simillanda shikwaptinqa, wakinqa ancha angu ñanman ishkirqan. Chaymandaqam pishqokuna shamushpa, chay simillakunata limpu pallarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Wakin simillaqam kaskajuman ishkirqan. Chaymi sawitapilla kashpa, wayralla wiñarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Piru kaskaju kashqanrayku mana ukukaman atishpa ch'upakuytam, rupay lluqshiptinqa, das chakirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Wakin simillaqam kashakunapa ukunman ishkirqan. Chaymi chay kashakunaqa wiñashpa, maqashpa limpu chingachirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Piru wakin simillaqam allin allpaman ishkirqan. Chaykunaqam shumaqta wiñashpa, allita puqorqan. Wakinqam kada simillita syin granusta puqorqan. Wakinqam 60 granusta; wakinqam 30 granusta puqorqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","¡Chayri qamkuna rinriyuqkunaqa allita uyawayllapa kay nishushqayta! ");
INSERT INTO qvcNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Chaymi noqaykuna yach'akuqninguna qemikashpa, Jisusta tapurqayllapa: —¿Imaraykutaq kumparasyunwanqa yach'achikungi? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Chayshina tapuptiyllapaqam, Jisusqa niwarqanllapa: —Dyusmi munan yach'anaykillapa imashinam syilupi paywan ancha shumaqta ringillapa kawsaq, nishpa. Chaymi kay kumparasyungunawan yach'achikushpaqa, qamkunatalla intyindichiyki. Piru chay mana munaq kriyiqkunataqam mana intyindichinichu. Paykunapaqqam pakadu. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Chayshina mayqan allita uyawaqtaqam yanapani, mas yach'ayniyuq kanambaq. Piru chay mana kriyiqtaqam ashlita yach'akushqanda Taytay Dyus limpu rin qoch'iq. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Chaymi noqapi chay mana munaq kriyiqkunataqa kumparasyungunawan yach'achini. Chaqa paykunaqam maychika rikashpa uyashpaqa, mana intyindinllapachu chay yach'achikushqayta. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Chayshina mana intyindiptinllapam, Dyuspaq rimaq Isayiyas kayshina nishqanqa kumpliykanna paykunapi: Maychika uyashpapismi, mana ringillapachu intyindiq. Rikashpapismi, mana ringillapachu yach'aq: imam chayqa, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","(Chaymandaqam Taytanchiq Dyusqa Isayiyasta kayshina nirqan:) Chay runakunapa shunqonqam ancha angu tikrakashqa, ama kasuwananllapa. Chaymi yach'achiptiypis, mana intyindinllapachu. Chaqa ñawinda, rinrindam kirpanllapa, noqapi ama kriyinanllapa, uchanllapamanda ama pirdunanaypaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Piru Tayta Dyusqam qamkunawanqa ancha alli. Chaymi ñawikillapawan chapashpa, intyindingillapa. Rinrikillapawan uyakushpam kasungillapa. Chayri kushikuyllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Alliptam niykillapa, Dyuspaq achka rimaqkuna, suq laya allin runakunapismi ancha munarqanllapa rikawayta, uyawayta qamkuna rikawashqaykishina. Piru paykunaqam wañurqan manaraq shamuptiy. Chaymi mana atirqanllapachu rikawayta ni uyawayta. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Alliptam niykillapa, chay tarpukuq kumparasyunwan yach'achikushqayta. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Chay angu ñanqam munan niyta runakuna, warmikuna angu shunqoyuqkunapaq. Chaqa paykunaqam mana munanllapachu intyindiyta Dyuspa shumaq nutisyandaqa. Chaymi chay pishqokuna simillata pallaqshinam dyabluqa chay uyakushqanda das qonqachin. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Chay kaskaju ch'akraqam yach'achiwanchiq chay das disanimakaqkunapaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Chaqa paykunaqam Dyuspa shumaq nutisyanda uyashpaqa, kushikushpa das kriyinllapa. Piru manam allitachu noqapiqa yuyakunllapa. Chaymi noqapi kriyishqanrayku qesachadu kashpaqa, das disanimakashpa, manana munanllapachu noqapi kriyiytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Chay allpa kashayuqqam munan niyta Dyus nishqanda ashla uyaqkunapaq. Chaqa paykunaqam Dyus nishqanda uyashpaqam, kay mundupa kusasningunapaq llakishpa, tukuy imayuq munashpa kayta, manana munanllapachu Dyus nishqanda kasuytaqa. Chaymi manana siginllapachu Dyuspi yuyakushpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Piru wakin uyakuqkunaqam chay ancha allin allpashina. Paykunaqam nishqayta uyashpa, allita kriyishpaqa, ancha allita rurashpa kawsanllapa. Wakinqam chay ancha allin allpa syin granusta puqoqshina, ancha allita Dyusta kasunllapa. Wakinqam chay allin allpa 60 granusta puqoqshina. Wakinqam chay allin allpa 30 granusta puqoqshina, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisusmi suq kumparasyundapis rurashpa, kayshina nirqan: —Taytanchiq Dyusmi suq runa tarpukuqshina rin ruraq. Chay runam allin simillanda ch'akrambi tarpurqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Piru tarpushpa puñunangamanmi, chay runapa suq kuntran shamushpa, trigun tarpushqamba ukunman ballikuta shikwashpa rirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Chaymi trigun wiñashpa, ispigaykaptinqa, chay ballikukunapis ukumbi wiñarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Chaymi dwiñupa kriyadungunaqa ballikuta rikashpaqa, rirqanllapa niq: “Patrunsitu, ¿manachu allin simillata tarpurqaykiqa? ¿Maymandaraq chay ballikukuna trigupa ukumbiqa wiñashqa?” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Chaymi dwiñuqa nirqan: “Suq kuntrawaqmi chaytaqa rurashqa kanqa.” Chayshina niptinqam, chay kriyadungunaqa nirqan: “Patrunsitu, ¿munangichu rinaypaqllapa, chay ballikuta trigumanda surqoq?” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Piru dwiñunqam nirqan: “Dijayllapa wiñanan. Ballikuta pilashpa, imakish trigundinda pilangimanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Chayri dijayllapa trigupa pullan wiñanambaq kusichakaman. Kusicha tyimpupinam syigaqkunata rini kamachiq, puntata chay ballikukunata akrashpa, qotushpa, rupachinambaq, chaymanda trigutalla trujaypi waqaychananllapa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Kay kumparasyunda rurashpapismi, Jisusqa paykunata kayshina nirqan: —Dyusta kasuqkunaqam ñapushpa murunshina. Chaqa suq runa ch'akrambi tarpuptinqam, ");
INSERT INTO qvcNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","chay ñapushpa murunqa yumbay simillamanda mas takshita kashpapis, wiñashpaqa, achka tarpuduta binsin. Chayshina atunna kaptinqam, pishqokuna rikrangunapi kamachakunllapa (makachakunllapa). Nuta: Chay ñapushpa muritunshinam Dyusta kuyaqkunapis ashlita kashqanllapamanda rinllapa achkayaq.  ");
INSERT INTO qvcNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Kay kumparasyunda rurashpam, Jisusqa nirqan: —Dyusta kasuqkunaqam libadura saksachikuqshina. Manchu suq warmi midyu kustal mash'kata yakuwan sangushpa, ashla libadurata taqlluptinqa, ancha achkayashpa, yumbay chay mach'kataqa limpu saksachin. Nuta: Chayshinallam Dyusta kasuqkunapis, ashlitalla kashpapis, ancha rinllapa achkayaq.  ");
INSERT INTO qvcNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisusqam yumbay chay nishqanda achka kumparasyunwanlla yach'achikurqan. Mana kumparasyunda rurashpaqam, mana yach'achikuqchu. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Chayshina Jisukristu yach'achikuptinmi, Dyuspaq rimaq kayshina iskibrishqan kumplirqan: Tayta Dyus kay munduta rurashqan tyimpumandapacha manaraq yach'ashqanllapatam kumparasyungunawan rini yach'achikuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Runakunata yach'achishpa ushyashpaqam, Jisusqa wasiman yaykurqan. Chaymandaqam noqaykuna yach'akuqninguna qemikashpa kayshina tapurqayllapa: —Taytitu, kay noqaykunatar intyindichiway ¿imam munan niyta chay nishqayki ch'akrapi ballikuqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Chaymi Jisusqa noqaykunata kayshina niwarqanllapa: —Noqa Dyusmanda Shamuq Runam chay allin simillata tarpuq runashinaqa kani. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kay munduqam chay ch'akrashina. Dyusta kasuq runakuna, warmikunam chay allin simillashinaqa. Dyabluta kasuq runakuna, warmikunam chay ballikushinaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Chaqa dyablum kuntrayqa. Chaymi pay chay ballikuta tarpuq runashinaqa. Chay dyabluqam wambrangunata taqllun wambraykunaman. Jwisyu diyaqam chay syigashina rin kaq. Dyuspa anjilningunam chay syigakuqkunaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Chay ballikukunata akrashpa rupachishqanshinam, jwisyu diyapi chay mana wambray kaqkunataqa rinllapa rupachiq. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Chaqa noqa Dyusmanda Shamuq Runaqa kashpam, anjilniykunata rini kamachiq, wambraykunamanda akrananllapa uchata rurachikuqkunata, tukuy chay uchayuqkunatapis. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Chaymandaqam rin wichuqllapa lumyaykaq urrnuman. Chaypim chay uchata ruraqkunaqa ancha waqashpa, kirunllapata rinllapa qech'yachiq. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Piru Dyus shamuptin, shumaqta kamachikunanmi, payta kasuqkunaqa ancha alabashqa rinllapa kaq. Chaymi rupayshina rinllapa llipyaq. Chayri qamkuna rinriyuqkunaqa, allita uyayllapa kay nishushqayta. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Dyuswan suq bidapi kawsananchiqqam ancha balin suq kampupi mina pakadushina. Chaymi suq runa chay minata tarishpaqa, manana munanchu dijayta. Chaymi mushuqmanda chay minata pambarishpa, kushikushpa rin tukuy iman kaqta randikuq. Chayshina randikushpa, kutimushpaqam, chay ch'akra minayuqta randin. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Dyuswan suq bidapi kawsananchiqqam ancha balin suq ancha ch'aniyuq perla rumishina. Suq nigusyantiqam chay mas shumaq llipyaq perlas rumikunata maskan. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Chaymi chay mas munaypaq llipyaq perla rumita tarishpaqa, tukuy iman kaqkunata randikun, kutirinan randiq. Nuta: Chayshinar tukuy ima atishqanchiqta rurashun, Dyuswan syilupi kawsananchiqllapa.  ");
INSERT INTO qvcNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Tayta Dyus shamushpa shumaqta kamachikunanmi, piskadukunata piskaqkunashina rin ruraq. Chaqa chay runakunaqam piskadukunata piskanambaqqa, atarrayanda yakuman wichukunllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Chaymandaqam tukuy laya piskadukuna bulsachakaptin, atun qoch'apa manyanman chutashpa tiyanllapa, allin piskadukunata akrananllapa kanastanman. Piru mana baliq piskadukunataqam wichukunllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Chayshinam jwisyu diyapi Dyuspa anjilninguna allin kaqkunamanda uchayuqkunata akrashpa, ");
INSERT INTO qvcNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","lumyaykaq ninaman rin wichukuqllapa. Chaypim chay uchata ruraqkunaqa ancha waqashpa kirunllapata rinllapa qech'yachiq. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jisusmi noqaykuna yach'akuqningunata kayshina tapuwarqanllapa: —¿Qamkunaqachu intyindingillapa yumbay chay kumparasyunda? nishpa. Noqaykunaqam nirqanillapa: —Arí, intyindinillapam, Taytitu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Chaymi Jisusqa niwarqanllapa: —Wakin runakunaqam Dyuspa Santu Librunmanda allita yach'achikunllapa: “Kayshinam Tayta Dyus shumaqta rin kamachikuq”, nishpa. Chay laya yach'achikuqqam suq wasipa dwiñunshina. Chaqa chay dwiñuqam yach'an surqoyta unay waqaychashqanda, chayraq waqaychashqandapis. Nuta: Chayshinallam chay yach'achikuqkunapis Dyuspa unay duktrinangunata, mushuq duktrinangunatapis allita yach'an yach'achikuyta.  ");
INSERT INTO qvcNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jisusqam chay kumparasyungunawan yach'achikushpaqa, chay lugarmandaqa rirqanna. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Chaymi uywakashqan llaqta Nasaritman ch'ayashpaqa, sinaguga wasipi llaqta masingunata yach'achirqan. Chaymi paykuna uyashpa ancha shumaqta yach'achikuptinqa, ancha ispantashqata nirqanllapa: —¿Ima, maymandataq kay runa ancha yach'ayniyuqqa? ¿Imashinataq achka milagrukunataqa ruran? ");
INSERT INTO qvcNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Manachu kayqa chay karpintirupa churin? ¿Manachu mamanqa Marya shutin? ¿Manachu masangunaqa Jakubu, Jusi, Simun, Judas shutin? ");
INSERT INTO qvcNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Manachu kay llaqtanchiqpi paningunaqa tiyanllapa? Chayshinaqa, ¿imashinataq kay karpintirituqa ancha yach'ayniyuq, tukuy chaykunata ruranambaqqa? ");
INSERT INTO qvcNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Chayshina ninakushpaqam, mana munarqanllapachu chay yach'achikushqanda kasuytaqa. Chaymi Jisusqa paykunata nirqan: —Dyuspaq rimaqkunataqam suq llaqtakunapiqa shumitaq ch'askishpa kasunllapa. Piru llaqta masinguna, kikin ayllungunaqam mana kasunllapachu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Chaymi paykuna mana kriyishqanrayku, Jisusqa chay Nasaritpiqa mana achka milagrukunataqa rurarqanchu. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Chay tyimpupi prubinsya Galiliyapa gubyirnun Irudis Jisuspa famanda yach'ashpa, ");
INSERT INTO qvcNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","yanapakuqnin awturidarkunata nirqan: —Chay alma Jwan Shutichikuqmi kawsamushqana. Chaymi chay milagrukunata atin rurayta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Chaqa chay Irudismi chay Jwan Shutichikuqta wanchichishqa karqan. Piru manaraq wanchichiptinmi, kayshina karqan. Puntatam chay Irudisqa masan Filipipa warmin Irudiyaswan kashqa karqan. Chaymi chay Jwanqa Irudista kayshina anyashqa karqan: —Ama masaykipa warminwanqa kaychu, nishpa. Chayshina anyashqambaqmi chay Irudisqa suldadungunata kamachirqan, Jwandaqa prisushpa, watashpa, karsilananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Irudisqam Jwanda munarqan wanchichiyta. Piru ancha achka runakunam Jwambaqqa kriyirqanllapa: Paymi Dyuspaq rimaq, nishpa. Chaymi Irudisqa paykunata manchashpa, mana daschu Jwandaqa wanchichirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Chaymandaqam Irudisqa diyambaq suq fyistata rurarqan. Chaypim yumbaypa ñawpambi chay warmi Irudiyaspa chinan ancha dansaptin, chay gubyirnu Irudistaqa ancha gustarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Chaymi payqa intinadanda jurashpa nirqan: —Ima mañawashqaykitam qoshqayki, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Chaymi maman kunaptin, chay chinaqa padrastun Irudista nirqan: —Jwan Shutichikuqpa umanda suq platupi qoway, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Chayshina mañaptinmi, gubyirnu Irudisqa limpu malaganayarqan. Piru yumbaypa ñawpambi jurashqanraykum, ");
INSERT INTO qvcNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","suq suldadunda kamachirqan, karsilman rishpa, Jwamba umanda apamunambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Chayshina Jwanda wanchishpam, umanda suq platupi apamurqan chinaman. Chinaqam ch'askishpaqa, mamandana qorqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Chaymi chay Jwamba yach'akuqningunaqa chay karsilman ch'ayashpaqa, Jwamba kwirpundallana aparqanllapa pambaq. Pambashpaqam, rirqanllapa Jisusta willaq chay pasashqambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisusqam yach'ashpa, Jwan Shutichikuqta wanchishqallapa, nishpaqa, chay kaykashqanmanda rirqan yakupi puriq barkupi suq chuncha lugarman, sapalan chaypi kanambaq. Piru ancha achka runakuna, warmikunam yach'arqan: Chay lugarmanmi riykan, nishpa. Chaymi llaqtangunamanda ch'akip rishpa, Jisus riykashqan lugarman ch'ayarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Chaymi Jisusqa chay barkumanda ishkishpaqa, chay ancha achka runakunata, warmikunata rikarqan. Chaymi paykunata llakipashpa, apashqan qeshyaqkunata kach'akachirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Amsayaykaptinqam noqaykuna yach'akuqningunaqa qemikashpa, Jisusta kayshina nirqayllapa: —Tardinám. Kay chunchapiqam mana pipis tiyanchu. Chayri kay runakunataqa kach'ayna, sirka kasiriyukunaman rinambaqllapa, mikunata randiq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Chaymi Jisusqa niwarqanllapa: —¿Imapaqnamir rinqallapaqa? Qamkuna qarayllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Chaymi noqaykuna yach'akuqningunaqa nirqayllapa: —Manam nima mikuna kanchu. Sinku tandita, ishkay piskaditullam kan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Chaymi Jisusqa niwarqanllapa: —Chaykunata kayman apamuyllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Chaymandaqam Jisusqa kamachikurqanna qewakunapa sawambi chay runakuna, warmikuna tiyanambaqllapa. Chaymandaqam chay sinku tanditata, chay ishkay piskadituta piskashpa, syiluman chapakushpa, Dyusta pagikurqan. Chayshina pagikushpaqam, chay tanditakunata piti piti rurashpa, noqaykuna yach'akuqningunata qowarqanllapa, chay runakunata qonaypaqllapa. Chayshinam rurarqan chay ishkay piskadituwambis. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mikushpallapaqam yumbay undarqanillapa. Chay tandawan piskaduqam subrarqanraq dusi kanasta undakuna. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kanan chay mikuqkunaqam ullqokunalla 5.000ch'i karqan. Warmikunata, wambrakunataqam mana yuparqayllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Chaymi chay uras Jisusqa noqaykuna yach'akuqningunata niwarqanllapa: —Lluqshishpa chay barkuman, ñawpayllapa waq chimbaman, nishpa. Chay barkupi riykaptiyllapaqam, Jisusqa kidarqan dispidiq chay achka runakunata, warmikunata. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Chaymandaqam payqa rirqan suq chuncha lumaman, chaypi Tayta Dyusman mañakuq. Chaymi chaypilla sapalitan tutayarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Chay barkupi noqaykuna riykaqqam ancha atun qoch'apa ch'awpimbina karqayllapa. Lukismi ñawpa ladumanda ancha wayrarqan. Chaymi yakukuna waqmanda kaymanda maqchikashpa chay barkuta arkaptin, manana atirqayllapachu riyta. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Piru yaqqana achikyaptinmi, Jisusqa yakupa sawanda ch'akip riykarqan noqaykunapa ikiyta. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Chaymi noqaykuna rikashpa, yakupa sawanda riykaptinqa, ancha manchashpa qayach'akurqayllapa: —¡Ichichín, almam shamuykan! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Chaymi Jisusqa niwarqanllapa: —Ama manchayllapachu. Noqam kani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pidruqam nirqan: —Qam Jisukristu kashpaqar, kamachikuy, kay yakukunapa sawanda purishpa, ch'akip shamunaypaq qaman, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Chaymi Jisusqa nirqan: —Shamuyri, nishpa. Chaymi Pidruqa chay barkumanda ishkishpa, chay yakupa sawanda riykarqan Jisusman. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Lukismi rikashpa ancha wayraykan, nishpa, manchashpa, yuyarqan: seqayman imakish, nishpa. Chaymi seqaykashpana, qayach'akushpa, Jisusta kayshina nirqan: —¡Washawayri, Taytitu! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Chaymi Jisusqa Pidruta das piskashpa, nirqan: —¡A, runa noqapi mana allita kriyiq! ¿Imapaqmír mana allitaqa noqapiqa yuyakungichu? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Chaymandaqam Jisuswan Pidru barkumanna lluqshiptinqa, chay wayraqa limpuna qasillarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Chaymi chay barkupi noqaykuna Jisuspa ñawpambi qonqorikushpa, payta adurarqayllapa, —¡Allibraq qamqa Dyuspa Churin kangi! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Chay ancha atun qoch'ata pasashpaqam, ch'ayarqayllapa suq atun pamba Jinisarit shutiqman. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Chaymi chay jinisarinukuna Jisusta riqsishpaqa, chay lugarnimba tukuy rridurninman abisukunata kach'arqanllapa. Chaymi yumbay qeshyaqninllapata Jisusman apamurqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ch'ayamushpaqam Jisusta kayshina rrugarqanllapa: —Dijawayri kapitaykipa manyandalla llamkanaypaq, nishpa. Chaymi chay qeshyaqkuna kapanda llamkaqkunaqa yumbaynin das kach'akarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Suq diyam Muysispa liyningunata yach'achikuqkuna, farisiyu duktrinayuqkuna Jirusalin llaqtamanda Jisusman shamurqanllapa. Payman qemikashpam, tapurqanllapa: ");
INSERT INTO qvcNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Unay agwilunchiqkunaqam mikunambaqqa puntata mayllakuna kustumbrita rurashpa, makingunata mayllaqllapa. Yach'achiwarqanchiq, noqanchiqkunapis chay kustumbrita rurananchiq. Chayri ¿imaraykutaq yach'akuqnikikunaqa mana kasunllapachu chay kustumbritaqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Chaymi Jisusqa paykunata tapurqan: —¿Imaraykutaq Dyus kamachikushqanda dijashqallapa kangi, kustumbrikitalla ruranaykillapaqa? ");
INSERT INTO qvcNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Chaqa Dyusqam kayshina kamachikushqa: “Taytaykita, mamaykita rrispitayllapa. Mayqan runa warmi taytanda mamanda maldisyaqqam wañunqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Piru qamkunaqam kustumbrikikunata kasushpa, ningillapa: “Taytayki, mamayki mañashuptin yanapanaykiqam, atingi ñigayta: ‘Chay mañawashqaykitaqam rini qoq Dyusta. Chaymi mana atinichu qamtaqa yanapashuyta’ ”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Chayshina yach'achikushpaqam, Dyus kamachikushqandaqa ñigaykangillapa, chay kustumbrikikunata siginaykirayku. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡A, shimikiwanlla kasukuqkuna! Dyuspaq rimaq Isayiyasqam qamkunapaq ancha allita kayshina nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Kay runakunaqam shiminwanlla adurawanllapa. Piru shunqonllapapiqam mana nimatapis kuyawanllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Chaymi yanqa adurawanllapa. Chaqa runakuna kamachikushqandallam yach'achikunllapa. Manam yach'achikunllapachu noqapa duktrinaytaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Chaymi Jisusqa chay uyakuq runakunata qayashpa nirqan: —Allita uyawashpa, intyindiyllapa: ");
INSERT INTO qvcNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Imata mikushpaqam, mana uchayuqchu kanchiq. Ashwan shunqonchiqpi mana allikunata yuyashpa, shiminchiqwan rimashpam, uchayuqqa kanchiq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Chaymi noqaykuna yach'akuqningunaqa qemikashpa, Jisusta kayshina nirqayllapa: —Taytitu, chayshina niptikiqam, farisiyu duktrinayuqkunaqa mana gustashpachu ancha piñakurqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","Chaymi Jisusqa noqaykunata niwarqan: —Paykunataqa ama manchayllapachu. Chaqa runakunaqam plantakunashinalla. Suq diyam Tayta Dyus paypi mana kriyiqkunataqa rin wichukuq mana baliq plantatashina. Chay farisiyu duktrinayuqkunaqam ancha pandashpa, sarkukunashina kidashqallapa. Chaymi suqkunata mana baliq duktrinanda yach'achishpa, sarkupura rambanakuqshina. Chaymi chay farisiyukuna, paykunata kasuqkunapis ush'kuman seqaqkunashina kashpa, limpu rinllapa chingaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Chaymi Pidruqa nirqan: —Intyindichiwayllapár chay kumparasyunda, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Chaymi Jisusqa nirqan: —¿Ima manachu qamkunapis intyindingillapa? ");
INSERT INTO qvcNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Allita yuyayllapa. Mayqan runa imatapis mikuptin upyaptinqam, pach'anman yaykun, ¿manachu? Chaymandaqam pach'anmandaqa sawaman pasan. (Manam shunqonmanchu yaykun, uchayuq kanambaqqa.) ");
INSERT INTO qvcNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Piru mana baliq palabrakunata rimashpam uchayuqqa. Chaqa chay rimashqandaqam shunqombi yuyashpa, rimanqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kay laya mana baliq yuyaykunaqam shunqonmanda lluqshin: wanchikunambaq; warmiyuq kashpa, suqwan kanambaq; manaraq willashpa taytanda mamanda, chinawan puñunambaq; suwakunambaq; yanqa llullakunata rimanambaq; washa rimay kanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Chay laya mana baliq yuyayniyuqkunam uchayuqqa. Piru chay mayllakuna kustumbrita mana ruraqkunaqam mana uchayuqchu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Chaymandaqam Jisusqa chay kaykashqanmanda rirqanna (Isrrayilpa ladumbi kaq nasyunman.) Chay nasyumba Tiru llaqtamba, Sidun llaqtamba sirkanman ch'ayarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Waqpim prubinsya Kanayanmanda kaq warmi tiyaq. Chay warmim Jisusman shamushpa ancha jwirtita qayakurqan: —¡Unay gubyirnu Dabidpa Karu Willkan Taytitu, llakipawayri! ¡Wawaymanmi dyablupa ispiritun yaykushqa! ¡Chaymi mana dijashpachu, ancha padisichin! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Piru Jisusqam uyararqanlla. Manam nimatapis nirqanchu. Chaymi noqaykuna yach'akuqningunaqa Jisusta nirqayllapa: —Chay warmi ikinchiqta shamuq qayakushpaqam ancha piñachiwanchiq. Yush'ayku, willay rinambaqna. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Chayshina niptiyllapam, Jisusqa chay warmita nirqan: —Taytay Dyusqam mana kach'amuwashqachu furastirukunamanqa. Ashwan kach'amuwashqaqam isrraylinukunaman, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Piru chay warmiqam Jisuspa ñawpanman shamushpa, qonqorikushpa urkunda pachaman ch'ayachishpa, kayshina rrugarirqan: —¡Taytitu, yanapawayri! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jisusqam nirqan: —Manam allichu wambrakunata mikunanda qoch'ishpa, allqetukunata qonanchiqqa. (Chayshinallam mana allichu, isrraylinukunata dijashpa, qamkuna furastirukunata yanapashunayqa), nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Chayshina niptinqam, chay warmiqa nirqan: —Arí. Chayshinam, Taytitu. Piru patrunguna mesapi mikuptinqam, allqokunapis chay pidasitun ishkiqkunata mikunllapa. (Chayshinam alli kanman, noqaykunatapis ashlitata yanapawanayki), nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Chayshina niptinmi, Jisusqa nirqan: —¡Warmisita! ¡Ancha allitaraq noqapi kriyishqa kangi! Chaymi chay mañawashqaykita rini ruraq, nishpa. Chayta nishqan urasmandapacham chinanqa kach'akarqanna. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisusmi chay lugarmanda rishpaqa, Galiliya ancha atun qoch'apa manyanda rishpa, suq lumaman lluqshishpa, chaypi tiyarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Jisus kaykashqanman achka runakuna, warmikuna ch'ayarqanllapa apamushpa kujukunata, sarkukunata, mudukunata, mankukunata, suq laya nanaywan kaqkunatapis. Chayshina ch'ayashpaqam, chay qeshyaqkunata Jisuspa ñawpambi rurarqanllapa. Chaymi payqa yumbayta kach'akachirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Chaymi mudukuna rimaptin, mankukuna allinyaptin, kujukuna puriptin, mana rikakuqkuna chapakuptinqa, chay isrraylinu rikaqkunaqa ancha ispantashqata Taytanchiq Dyusta ancha alabarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Chayshina paykunata kach'akachishpam, Jisusqa noqaykuna yach'akuqningunata qayawashpa, kayshina niwarqanllapa: —Ancharaq kay runakunapaq llakini. Chaqa kimsa diyanam kaypi pullay noqawan; piru manam nima kanchu mikunanllapaqa. Chaymi mana munanichu mallaqta kach'ayllapataqa. Chaqa ñambi imakish binsikanmanllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Chaymi noqaykunaqa nirqanillapa: —¿Imatamir qarashun kay chunchapiqa? Chaqa kaypiqam mana pipis tiyanchu, mikunata randichiwananchiqqa, paykunata qarananchiq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Chaymi Jisusqa niwarqanllapa: —¿Ayka tanditayuqmi kangillapa? nishpa. Noqaykunaqam nirqayllapa: —Syiti tandita, ashla piskaditullam kan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Chaymi Jisusqa kamachikurqan, yumbay chay runakuna pambapi tiyanambaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Chaymandaqam chay syiti tanditata, chay piskaditukunata piskashpa, Dyusta pagikurqan. Chaymandaqam piti piti rurashpa, noqaykunata qowarqanllapa, chay yumbay runakunata qaranaypaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Qaraptiyllapaqam, yumbay mikurqanllapa undanangaman. Mikuptinllapaqam, syiti kanasta unda subrarqan. Chaymi chay subraqkunata tandarqayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Chay mikuqkunaqam ullqokunalla 4.000ch'i karqan. Warmikunata wambrakunataqam mana yuparqayllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Chaymandaqam chay runakunamanda dispidikashpaqa, Jisusqa yakupi puriq barkuman lluqshishpa, rirqanna Magdala shutiq lugarman. ");
INSERT INTO qvcNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Wakin farisiyu duktrinayuqkuna sadusiyu duktrinayuqkunawan shamushpam Jisusta mallipanambaq, yanqa kayshina nirqanllapa: —Mayá, suq manchaypaq milagruta ruray yach'anaypaqllapa, allipchu syilumanda shamushqa kangi ichu mana, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Chaymi Jisusqa paykunata nirqan: —Qamkunaqam tardiman rupay seqaptin, syilupi chupikata rikashpaqa, ningillapa: “Allin diyam qayaqa rin kaq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Chayshinallam madrugadupi syilu tuldadu kaptin, qarwita chupikayaykaqta rikashpaqa, ningillapa: “Tamyaqmi rin”, nishpa. ¡A shimikiwanlla Dyusta kasuqkuna! Chayshina syiluta chapashpam, yach'angillapa, imashinam rin kaq tyimpu, nishpa. Chayshina yach'ashpaqa, ¿imaraykutaq mana yuyangillapachu, Dyus nishqanmi kumpliykanna, nishpaqa? ");
INSERT INTO qvcNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","¡Qamkuna kay tyimpumanda malukunaqam Dyustaqa mana munangillapachu kasuyta! Chaymi qamkuna chay milagru mañawashqaykitaqa mana rinichu ruraq. Ashwanmi kay laya milagrulla rin kaq. Manchu Dyuspaq rimaq Junaswan suq milagru karqan. Chayshinallam noqawambis kanqa. Nuta: Chay Junasqam suq ancha atun piskadupa pach'ambi karqan pambadushina. Chaymandaqam lluqshirqan. Chayshinallam Jisuspis atun mach'ayshina sipulturapi pambadu kashpa, kawsamushpa, lluqshirqan.  Chayshina nishpaqam, paykunamandaqa akrakashpa, rirqanna. ");
INSERT INTO qvcNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Noqaykuna Jisuspa yach'akuqningunam chay ancha atun qoch'apa waq chimbanman rishpaqa, qonqarqayllapa tandata apaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Chaymandaqam chay chimbaman ch'ayaptiyllapaqa, Jisusqa niwarqanllapa: —Uyawayllapa, kaykish niykillapa, farisiyukunapa libaduranmanda, sadusiyukunapa libaduranmanda kwidakanaykillapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Chayshina niwaptinllapaqam, noqaykunapura kayshina parlarqayllapa: —Tandata mana apamushqanchiqraykum chay libadurapaqqa niwanchiqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Piru chayshina parlaptiyllapaqam, Jisusqa yach'ashpa, kayshina niwarqanllapa: —Tandaykillapata qonqashpaqa ¿imaraykutaq chayshina parlaykangillapa? ¿Ima manachu allita noqapi yuyakungillapa: Jisukristum atin qarawayninchiqta, nishpaqa? ");
INSERT INTO qvcNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Ima manachu intyindingillapa? ¿Manachu yuyangillapa chay sinku tanditakuna chay 5.000 runapaq aypashqandaqa? ¿Manachu yuyangillapa paykuna mikushpa undaptinllapa, chay achka kanastakunapi subrashqandaqa? ");
INSERT INTO qvcNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Manachu ni yuyangillapa chay syiti tandakuna 4.000 runakunapaq aypashqandaqa? ¿Manachu yuyangillapa chay 4.000 mikushpa undaptinllapa, chay achka kanastakunapi subrashqandaqa? ");
INSERT INTO qvcNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Ima manachu intyindingillapa? Manam niykillapachu, tandaykillapata qonqashqaykiraykuchu. Ashwanmi niykillapaqa, farisiyukunapa, sadusiyukunapa libaduranmanda kwidakanaykillapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Chayshina noqaykunata niwaptinraqmi intyindirqayllapa: Manam niwashqachu kanchiq, tandapa libaduranmanda kwidakananchiqchu. Ashwanmi chayshinaqa niwarqanchiq, farisiyukunapa, sadusiyukunapa duktrinanmanda kwidakananchiq, nishpa. Nuta: Chaqa ashla libadurallam achka masata atin saksachiyta. Chayshinallam farisiyupa, sadusiyupa kustumbringunata ashlitatalla ruraptinchiq, ancha dañachiwanchiqman.  ");
INSERT INTO qvcNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisusqam ch'ayashpa prubinsya Filipupa Sesarya llaqtamba lugarningunaman, noqaykuna yach'akuqningunata tapuwarqanllapa: —Runakunaqa ¿imatam nin noqapaqqa? ¿Pish kani noqaqa paykunapaqqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Chaymi noqaykunaqa nirqayllapa: —Wakinqam nin chay alma Jwan Shutichikuqshi kangi. Wakinqam nin: Dyuspaq chay unay rimaq Eliyasshi kangi. Wakinqam nin: Dyuspaq chay unay rimaq Jirimiyasshi kangi ichush Dyuspaq suq unay rimaq kangi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Chaymandaqam tapuwarqanllapa: —Mayá, qamkunaqa ¿imatataq ningi? ¿Pitaq kani qamkunapaqqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Chaymi Simun Pidruqa nirqan: —Qamqam Dyus Akrashqan Washadurniyllapa kangi. Qamqam Dyus kawsaqpa Churin kangi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Chayshina niptinqam, Jisusqa nirqan: —Manam ni mayqan runa nishushqachu: pim Jisukristuqa, nishpaqa. Ashwanmi Taytanchiq Dyus syilupi kaq yanapashushqa intyindinayki. Chayri qam, Junaspa churin Simun Pidruqa kushikuy. ");
INSERT INTO qvcNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","(Chaqa shutiki “Pidrum” munan niyta “rumi.”) Kanan suq simyintu rumishinam ringi kaq. Chaqa runakuna, warmikuna qamanda yach'akushpa, noqapi kriyiptinllapaqam, rini washaq, ama ni mas pudirniyuq dyablu atinambaq apayta wañushqakunapa lugarninman. Chaqa noqapi chay kriyiqkunaqam ilgisyay. ");
INSERT INTO qvcNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Syilupa llabingunatam rini qoshuq. Chaqa noqapi chay mana kriyiqkunaqam dyablupa kadinangunawan watadushina. Piru kay mundupi noqapaq yach'achikushpaqam, chay kadinakunata paskaykangimanshina. Chaymi noqapaq willaptiki, paykuna noqapi kriyiptinllapaqa, syilupa pungunda kich'aykangimanshina, syiluman yaykunanllapa. Piru noqapaq willashqaykita mana kriyiqkunaqam watadushinalla kidan. Manam atinqallapachu yaykuyta syilumanqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Chayshina nishpaqam, Jisusqa yumbay yach'akuqningunata niwarqanllapa: —Amaraq ni pitapis noqapaqqa niyllapachu: “Jisusqam Dyus Akrashqan Washadurninchiq”, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Chaymandaqam Jisusqa yach'akuqningunata kayshina niriwarqanllapa: —Riqmi rini Jirusalin llaqtaman. Waqpim chay kamachikuq ansyanukuna, chay kamachikuq isrraylinu kurakuna, Muysispa liyningunata yach'achikuqkuna ancha rinllapa padisichiwaq. Kanan rinllapam sintinsyawaq wañunaypaq. Piru chay wanchiwashqan diyamandam qaya suq punchawnin rini kawsamuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Chaymi Pidruqa Jisusta suq laduman sapalanda apashpa, nirqan: —Taytitu, amar Taytanchiq Dyus munanmanchu chayshina padisishpa wañunaykipaqqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Chaymi Jisusqa tikrakashpa, Pidruta nirqan: —¡Qamqam dyablushina rimaykangi! ¡Ashuy ñawpaymanda! Chaqa qamqam munangi disanimachiwayta, Tayta Dyus munashqanda ama ruranaypaq. Mana intyindiq runashinam yuyaykangi. Manam yuyaykangichu Dyus yuyashqanshinaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Chaymandaqam Jisusqa noqaykuna yach'akuqningunata niwarqanllapa: —Mayqan munaq yach'akuqniy kaytaqa tukuy ima munashqanda dijashpa, noqatalla sigiwanqa, suq kruspi munaptinllapa wanchiytapis. ");
INSERT INTO qvcNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","(Chaqa noqapi kriyiqkunataqam chay kuntrawaqkuna munanqallapa wanchiyta.) Piru amar ñigawaychu, chay kuntrawaqkuna ama wanchishunanllapa. Chayshina ñigawashpaqam, jwisyu diyapiqa ringi chingaq. Piru noqapi kriyishqaykirayku wanchishuptinqam, jwisyu diyapi rini washashuq, tukuy tyimpu noqawan kawsanayki. ");
INSERT INTO qvcNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Chaqa suq runa ichu suq warmi kay mundupa tukuy imanda ch'askishpa, piru jwisyu diyapi chingashpaqa, ¿imatam ganashqa? Chaqa manam atinchu pagarakuyta washakanambaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Noqaqam Dyusmanda Shamuq Runa kashpa, Taytay Dyuspa pudirninwan llipyashpa, anjilningunawan syilumanda rini kutimuq. Chay diyapim runakuna tukuy ima rurashqambaq rini pagaraq, primyunda qoshpa, ichu kastigashpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Alliptam niykillapa, wakinnikiqam manaraq wañushpa, ringillapa rikawaq, chayshina Dyuspa pudirninwan llipyashpa, shamuptiyqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Chay nishqanguna sayis diyas pasaptinnam, Jisusqa Pidruta, Jakubuta, masan Jwannindinda apashpa, rirqan suq altu lumapa sawanman. ");
INSERT INTO qvcNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Chay lumapim Jisusqa suq layayarqan. Chaqa qaqllanqam rupayshina llipyashpa, achikchakurqan. Rurakushqan mudanambismi rupayshina ancha llipyarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Chaymandaqam Dyuspaq chay unay rimaqkuna Muysiswan Eliyas chay uras ladumbi rikakushpa, Jisuswan parlaykarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Chaymi Pidruqa Jisusta nirqan: —Taytitu, ancha alliraq kaypi kananchiqllapa. Munaptikiqa, kimsa chuqllata rurashaqllapa, suqta qambaq, suqta Muysispaq, suqta Eliyaspaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Chayshina Pidru rimaykaptinllam, suq llipyaq pukutay shamushpa, limpu pambarqan. Chayshina pambaptinqam, chay uras pukutaypa ukunmanda Dyusta uyarqanllapa kayshina niqta: —Kaymi kuyashqay Churiy. Paywanmi anchallana kushikuni. ¡Paytar uyayllapa! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Chayta uyashpaqam, chay kimsa yach'akuq masiykunaqa ancha manchashpa, qonqorikurqanllapa qaqllanllapa allpaman ch'ayanangaman. ");
INSERT INTO qvcNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Chaymi Jisusqa qemikashpa, paykunapa sawanman makinda rurashpa, nirqan: —Atariyllapa. Ama manchayllapachu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Chaymi atarishpaqa, manana ni pitapis ladumbiqa rikarqanllapachu. Jisustallanam rikarqanllapaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Chaymandaqam Jisus chay lumamanda uraman riqshinaqa, chay kimsa yach'akuq masiykunata kamachirqan: —Kay rikashqaykitaqa amaraq pitapis niyllapachu, wañushpa kawsamunaykaman, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Chaymi chay yach'akuq masiykunaqa Jisusta tapurqanllapa: —Muysispa liyningunata yach'achikuqkunaqa ¿imaraykutaq ninllapa: “Dyus Akrashqan Washadur manaraq shamuptinshi, chay alma Eliyas kawsamushpa, puntata rin shamuq”, nishpaqa? ");
INSERT INTO qvcNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Chaymi Jisusqa paykunata nirqan: —Allibmi chayshina. Eliyasmi puntata shamunambaq karqan, runakunata yach'achinambaq, uchangunata dijanambaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Piru noqaqam niykillapa, Eliyasqam shamurqanna. Piru paytaqam mana riqsirqanllapachu, Dyuspaq rimaq, nishpaqa. Chaymi paytaqa munashqanllapata rurarqanllapa. Paytashinallam noqa Dyusmanda Shamuq Runatapis ancha rinllapa padisichiwaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Chayshina Jisus Eliyaspaq niptinqam, paykunaqa intyindirqanllapa: Jwan Shutichikuqpaqmi chayshina niwashqaqa kanchiq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jisus chay kimsa yach'akuq masiykunawan chay lumamanda shamushpaqam, chay kashqayllapaman ch'ayamurqanllapa. Chaymi suq runa shamushpa, Jisuspa ñawpambi qonqorikushpa, kayshina rrugarqan: ");
INSERT INTO qvcNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Taytitu, llakipayri wambrayta. Atakikuna piskashpam, ancha padisichin. Chaqa kutin kutin piskashpam, ninakunaman yakukunaman bulashqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Chaymi kay yach'akuqnikikunaman apamushqa kani. Piru paykunaqam mana atishqallapachu kach'akachiyta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Chayshina niptinmi, Jisusqa nirqan: —¡A, qamkuna Dyuspi mana yuyakuqkuna, mana allita ruraqkunaqa! ¿Ima tyimpukamanraq qamkunawanqa padisishaq? ¿Ima tyimpukamanraq qamkunataqa agwantashqaykiqa? Mayá, kayman apamuyllapa wambraykita, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Apamuptinllapaqam, Jisusqa dyabluta anyashpa, chay chulumanda qatirqan. Chaymi chay urasmandapacha kach'akashqana kidarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Chaymandaqam noqaykunalla Jisuswan kashpaqa, kayshina tapurqayllapa: —¿Imaraykutaq noqaykunaqa mana atirqayllapachu chay dyabluta qatiytaqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Chaymi Jisusqa niwarqanllapa: —Dyuspi mana allita yuyakushpam, mana atirqaykillapachu qatiytaqa. Piru alliptam niykillapa, ashlita Dyuspi yuyakushpa, chay ñapushpa muritun tantitutaqach'i, kay atun urqqota kamachiptikillapa suq laduman rinambaqqa, kasushushpa rinman suq laduman. Chaqa qamkuna Dyuspi allipta yuyakuptikiqam, mana nimapis trabajuschu kanman qamkunapaqqa. ˻ ");
INSERT INTO qvcNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Piru kay laya dyablutaqam chayshinallaqa mana atingillapachu qatiyta. Ashwanmi ayunashpa, Dyuspi allita yuyakushpa, payman mañakushpa atingillapa qatiytaqa, nishpa.˼ ");
INSERT INTO qvcNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Prubinsya Galiliyapi kaykaptiyllapam, Jisusqa noqaykuna yach'akuqningunata kayshina niriwarqanllapa: —Noqa Dyusmanda Shamuq Runataqam rinllapa intrigakuwaq runakunapa makinman. ");
INSERT INTO qvcNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Rinllapam wanchiwaq. Piru kimsa diyamanmi rini kawsamuq, nishpa. Chayshina niwaptinllapaqam, ancha llakirqayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jisusqam noqaykuna yach'akuqningunawan Kapirnawun llaqtaman ch'ayarqayllapa. Chaypi kaptiyllapam, kuntribusyunda kubrakuqkuna Pidruman qemikashpa, kayshina tapurqanllapa: —¿Qamkunapa yach'achikuqnikichu Dyuspa adurana wasimbaq kuntribusyunda pagarakun ichu mana? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Chaymi Pidruqa nirqan: —Arí, pagarakunmi, nishpa. Chaymandaqam Simun Pidru wasiman yaykuptinqa, manaraq nimata niptin, Jisusqa tapurqan: —Mayá, ¿ima ningitaq, Simun? Kay mundupi gubyirnukunaqa ¿pitataq kubranllapa kuntribusyundaqa? ¿Llaqta masingunatachu ichu jwirakunata? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Chaymi Pidruqa nirqan: —(Girrapi binsishqanraykum), jwirakunataqa kuntribusyunda kubranllapa, nishpa. Chaymi Jisusqa nirqan: —Arí. Chay gubyirnukunapa llaqta masingunaqam mana pagarakunchu kuntribusyundaqa. (Chaymi noqanchiqkuna Dyuspa wambran isrraylinukuna kashpaqa, mana nisisaryuchu pagarakunanchiq chay kuntribusyundaqa.) ");
INSERT INTO qvcNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Piru ama ni pitapis piñachinanchiq pagarakushun. Chayri riy chay atun qoch'aman, answiluykiwan piskaduta piskanayki. Chaqa chay punta piskadu piskashqaykipa shimimbim ringi tariq suq qellayta. Chayta apamushpa, noqapaq qambaqpis chay kuntribusyunda pagarakuy, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Chay tyimpupim noqaykuna yach'akuqninguna Jisusman qemikashpa, kayshina tapurqayllapa: —Taytitu, Tayta Dyus shumaqta kamachikuptin syilupiqa, yumbay runamandaqa ¿pitaq masta rin kamachikuqqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Chaymi Jisusqa suq wambrituta qayashpa, ch'awpiyllapapi rurashpa, ");
INSERT INTO qvcNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","kayshina niwarqanllapa: —Alliptam niykillapa, kay umildi wambritushina mana kashpaqam, mana ringillapachu atiq yaykuyta syiluman, Dyuswan kawsanaykillapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Chaymi Tayta Dyus shumaqta kamachikuptinqa, kay wambritushina umildi kaqkunaqam Dyuspaqqa masta rinllapa baliq. ");
INSERT INTO qvcNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Mayqan runa kasuwashpa kay laya wambrituta ch'ayachiqqam, noqata ch'ayachiwaykanshina, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Noqapi chayraq kriyiqkunata uchata rurachiqqam ancha kastigadu rin kaq. Chaymi chay uchata rurachiqpaqqa mas alli kanman, suq atun mulinu rumita kungambi watashpa, wichukunanllapa mar yakupa ch'awpinman, chaypi ch'uqashpa wañunambaq (manaraq chay uchata rurachiptin, ama mas kastigadu kanambaq). ");
INSERT INTO qvcNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Akakáw kay mundupi kawsaqkunapaqqa! Chaqa achka laya mana baliq yuyaykunam runakunata, warmikunata animachin, uchata rurananllapaqa. Chaymi ancha trabajus rin kaq, shumaqta kawsananllapaqa. ¡Piru mas kastigadum rin kaq chay runa uchata rurachikuqqa! ");
INSERT INTO qvcNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Chayrayku makiki ichu ch'akiki ancha qawch'u kaptin uchata rurachishunanqa, kuchushpa wichukuy, uchata ama ruranaykipaq. Mas allim kanman, kuju ichu manku suq bidaman yaykunaykipaqqa. Manam allichu ishkay makiyuq ichu ishkay ch'akiyuq kashpa, tukuy tyimpu lumyaykaq ninaman wichukudu kanaykipaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kanan ñawikiwan imata rikashpa, animakashpa uchata ruranaykiqa, surqoshpa, karuman wichukuy. Chaqa mas allim suq ñawiyuqlla kashpa, suq bidaman yaykunayki. Manam allichu ishkay ñawiyuq kashpa, lumyaykaq infyirnuman wichukudu kanaykiqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Kay taksha wambritutashinaqa ama disprisyayllapachu. Chaqa paykunata kwidaq anjilkunam Tayta Dyuspa ñawpanman ima uraspis atin ch'ayayta, chay wambritukunapaq mañakunan. ˻ ");
INSERT INTO qvcNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Noqaqam shamushqa kani, chay chingashqakunata washanaypaq.˼ ");
INSERT INTO qvcNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Imatataq yuyangillapa? Suq runa 100 wishayuq kashpa, suq wishitan chingaptinqa, ¿manachuraq chay 99ta lumapi dijashpa, rinman chay suq chingashqa wishitanda maskaq tarinangaman? ");
INSERT INTO qvcNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Chay chingashqa wishanda tarishpaqash', ancha kushikunqa maski chay 99 mana chingashqakunapaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Chayshinam syilupi Taytanchiq Dyuspis mana munanchu kay wambritushina kaqkuna ni suqnin chinganambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Kriyiq masiki mana allita rurashuptinqa, rishpa, paywanlla parlay: “Kayshinam dañachiwashqa kangi”, nishpa. Chaymi kasushushpa alliyaptinqa, shumaqtana ringi kawsaq chay kriyiq masikiwanqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Piru mana kasushuptinqa, apay suq ichu ishkay tistigukunata, ishkay ichu kimsa yach'anaykillapa, ¿Imatam nin? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Chay apashqaykikunata mana kasuptinqa, yumbay chay tandakaq kriyiq masinchiqkunata willay. Yumbay paykunata mana kasuptinqa, paytaqa suq mana kriyiqtashina ichu suq uchayuq kuntribusyunda kubrakuqtashinana riqsiyllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Alliptam niykillapa, noqapi chay mana kriyiqkunataqam dyablu kadinakunawan watashqashina. Piru kay mundupi noqapaq yach'achikushpaqam, chay kadinakunata paskaykangimanshina. Chayshina suqkunata animachishpa noqapi kriyinanllapaqam, qamkunaqa syilupa pungunda alabis kich'aykangimanshina, syiluman yaykunanllapa. Piru kay mundupi yach'achikushqaykita mana kriyiqkunaqam watadushinalla rin kidaq. Manam atinqallapachu yaykuyta syilumanqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Niykillapapismi, kay mundupi ishkay qamkuna suq yuyayniyuqlla kashpa, Tayta Dyusman mañakuptikiqam, payqa mañashqaykita syilumanda rin qoshuqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Chaqa ishkay ichu kimsa noqapi yuyakushpa tandanakuptinqam, paykunapa ch'awpimbi kani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Chaymi Pidruqa qemikashpa, Jisusta kayshina tapurqan: —Taytitu, suq kriyiq masiy mana allita rurawaptinqa, ¿ayka kutindam pirdunashaq? ¿Syiti bwiltastachu pirdunashaq? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Chayshina tapuptinmi, Jisusqa nirqan: —Manam niykichu syiti bwiltastalla pirdunay, nishpaqa. Ashwan pirdunayqa 70 bwiltasta syitiyuqwan, nishpa. Nuta: Chayqam munan niyta tukuy bwiltasta pirdunananchiq.  ");
INSERT INTO qvcNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Jisusqam nirqambis: —Taytanchiq Dyus shumaqta kamachikuptinqam, suq gubyirnu pirdunakuqshina rin kaq. Chaqa chay gubyirnum munarqan yach'ayta: Kriyaduykunaqa, ¿aykatataq dibirawanllapa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Chaymi kwintanda surqoykaptinqa, apamurqanllapa suq runa 10.000 talintu dibiraqta. Nuta: 10.000 talintukunaqam ancha achka qellay karqan. Chaqa suq trabajaq runam masdi 15 watakunata trabajashpa, suq talintutalla atiq ganayta.  ");
INSERT INTO qvcNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Chaymi chay dibirakuqqa manana nimatapis atirqanchu pagarakuytaqa. Chaymi patrunninqa kamachikurqan: “Randikuyllapana kay runata warmindinda, wambrandingunata, tukuy imandinda, chay dibirawashqanda kutichiwanambaq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Piru chay dibiraqqam qonqorikushpa, ancha rrugarqan chay gubyirnuta: “Patrunsitu, yush'ayku shuyawayri. Yumbay dibirashushqaytam pagarashqayki”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Chaymi chay gubyirnuqa chay dibiraq rrugaptin, llakipashpa, yumbay dibirashqambaq nirqan: “Pirdunaykinam. Mananam dibirawangichu. Librinam kangi”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","’Piru chay pirdunashqa kriyaduqam chay gubyirnumanda lluqshishpalla, suq kriyadu masinda tarirqan. Payqam 100 dinaryu qellaytalla dibirarqan. Piru payqam chay dibiraqtaqa kunganmanda piskashpa, urka urka rurashpa nirqan: “Pagaraway dibirawashqaykita”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Chaymi chay dibiraqpis qonqorikushpa ancha rrugarqan: “Shuyawayri. Rinim pagarashuq yumbay dibirashushqayta”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Piru payqam mana shuyashpachu, apamurqan karsilman, yumbay dibirashqanda pagaranangaman. ");
INSERT INTO qvcNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Wakin kriyadu masingunam chayshina chay dibiraqta ruraptin rikashpaqa, ancha llakiparqan. Chaymi rirqanllapa chay gubyirnuta parlachiq yumbay rikashqanda. ");
INSERT INTO qvcNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Chayraykum chay gubyirnuqa chay pirdunashqa kriyadunda qayachishpa nirqan: “¡A, kriyadu malu! Rrugawaptikiqam noqaqa yumbay dibirawashqaykita pirdunashushqa kani. ");
INSERT INTO qvcNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Chayshina qambis llakipashpa, chay dibirashuqta pirdunanaykita”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Chaymi patrunninqa ancha piñakushpa, karsilman apashpa, kastigakuqkunata intrigarqan, munashqanda kastigananllapa, yumbay dibirashqanda pagaranangaman. ");
INSERT INTO qvcNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Chaymi Jisusqa nirqambis: —Runa masikikunata tukuy shunqo qamkuna mana pirdunaptikiqam, syilupi tiyaq Taytanchiq Dyuspis qamkunata mana rinchu pirdunashuq. ");
INSERT INTO qvcNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisusqam ushyashpa rimaytaqa, rirqanna chay prubinsya Galiliyamandaqa. Chayshina rishpam, ch'ayarqan rriyu Jurdamba waq chimba ladunman, chay prubinsya Judiyapa lugarningunaman. ");
INSERT INTO qvcNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Piru ikindaqam ancha achka runakuna, warmikuna rirqanllapa. Chaypim Jisusqa yumbay qeshyaqkunata kach'akachirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Chaymi wakin farisiyu duktrinayuqkuna ch'ayashpa, pandachiyta munashpa, yanqa kayshina tapurqanllapa: —¿Allichuraq suq runa imapaqpis yuyashpa, warminmanda akrakanambaq? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Chayshina tapuptinllapaqam, Jisusqa nirqan: —Qallarishqan tyimpuqam Dyusqa ullqota, warmita rurarqan. ¿Manachu librumbiqa chayta liyishqallapa kangi? ");
INSERT INTO qvcNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Chaqa paykunapaqmi Taytanchiq Dyusqa nirqan: “Runaqam taytanda, mamanda dijashpa, warminwanna tandakashpa rin tiyaq. Chaymi ishkay kashpapis, suqshinallana kanqallapa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Chaymi niykillapa, rrispituyuqkunaqam ishkay kashpapis, suqllana. Chayri Dyus tandashqandaqa, runakunaqa ama akranqachu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Chayshina Jisus niptinqam, chay farisiyukunaqa nirqan: —Chayshina kaptinqa, ¿imaraykutaq Muysisqa unay agwilunchiqkunata kamachirqan, suq runa warminmanda akrakanambaqqa suq dukumintuta qonqa, nishpaqa? ");
INSERT INTO qvcNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Chaymi Jisusqa paykunata nirqan: —Chaqa angu shunqoyuqkuna kaptinllapam, Muysisqa dijarqan paykunata, dukumintuta qoshpa, warminmanda akrakananllapaqa. Piru qallarishqan tyimpupiqam mana chayshinachu karqan. Ashwan Tayta Dyusqam runakunata, warmikunata rurarqan, tandanakushpa, ama akrakananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Chaymi niykillapa, suq runa warminmanda akrakashpa, suq warmiwan kanambaqqam ancha uchayuqna. Chayshinallam chay warmi dijashqawan suq runa kasaraqpis ancha uchayuqna. Piru mayqan warmi runanda traysyunda rurashpa, suq runawan kaptinllam, qosanqa atin akrakaytaqa. Manaqa manam balinchu akrakananqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Chayshina Jisus niwaptinllapaqam, noqaykuna yach'akuqningunaqa malaganayashpa, kayshina nirqayllapa: —Chayshina warmiyuqkuna manana atishpa akrakayta, suqwan kanambaqqa, mas allich'i kanman, ama ni mayqan warmiyuq kananchiqllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Chaymi Jisusqa niwarqanllapa: —Yumbay runakunaqam mana atinchu intyindiyta kay nishushqaytaqa. Piru Taytanchiq Dyus yanapaptinllam, wakinqa atinllapa intyindiyta. ");
INSERT INTO qvcNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Wakin runakunaqam mana atinllapachu kasaraytaqa. Chaqa wakinqam nasin, sapalanlla kawsanambaq. Wakindaqam runakuna inukuta ruranllapa, ama kasaranambaq. Piru wakinqam mana kasaranchu, Dyusta mas allita sirbinanllapa. Chayri mayqanniki kay nishushqayta atishpa ruraytaqa, rurayllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Wakinqam wambritukunata Jisusman apamurqanllapa, makinda sawambi rurashpa, Dyusman mañakunambaq paykunapaq. Piru noqaykuna yach'akuqningunaqam chay wambran apamuqkunata anyarqayllapa (ama Jisusta piñachinanllapa). ");
INSERT INTO qvcNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Chaymi Jisusqa niwarqanllapa: —Ama arkayllapachu. Ashwan dijayllapa, chay wambritukuna noqaman shamunanllapa. Chaqa mayqan kay wambritukunashina kaqmi Dyuswanqa syilupi rin kawsaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Chaymandaqam chay wambritukunapa sawambi makinda rurashpa, Dyusman mañakushpaqa, rirqanna suq lugarman. ");
INSERT INTO qvcNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Suq wambra runa shamushpam, Jisusta kayshina tapurqan: —Ancha Allin Yach'achikuq Taytitu, ¿imatam atini rurayta, Taytanchiq Dyuswan tukuy tyimpu kawsanaypaqqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Chaymi Jisusqa nirqan: —¿Imaraykutaq niwangi: “Ancha Allin Yach'achikuq”, nishpaqa? Dyusllam ancha allinqa. Munaptiki suq bidapi tukuy tyimpu kawsanaykipaqqa, Dyus kamachikushqanda kasushpa kawsay, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Chaymi chay runaqa nirqan: —¿Mayqan kamachikushqandam kasushaqqa? nishpa. Chayshina tapuptinqam, Jisusqa nirqan: —Ama wanchikuychu. Qam warmiyuq kashpaqa, ama suq warmiwanqa puñuychu. Ama suwakuychu. Ama yanqa llullakunata runa masikipaq rimaychu. ");
INSERT INTO qvcNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Taytaykita, mamaykita ancha rrispitashpa kasuy. Qam kwirpuykita kuyashqaykishina, runa masikitapis kuyay, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Chayshina Jisus niptinqam, chay runaqa nirqan: —Yumbay chaykunatam wambra kashqaymandapacha kasushqa kani. ¿Imataq mas faltawan ruranaypaqqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jisusqam nirqan: —Dyus nishqanda ancha allita kumplinaykipaqqa, tukuy imayki kaqta randikushpa, qoy chay mana nimayuqkunata. Chayshina qoshpam, syilupiqa tukuy imayuqqa ringi kaq. Chayta rurashpaqa shamuyna, noqawan purinanchiq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Chayshina niptinqam, chay runaqa limpu malaganayashpa, tukuy imambaq llakishpa, rirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Chaymi Jisusqa noqaykuna yach'akuqningunata niwarqanllapa: —Alliptam niykillapa, ancha trabajusmi suq kapuq runa Dyusta kasunambaq, paywan kawsanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Suq kutindam niriykillapa. Mas fasilmi chay atun kamillu animal awjap rinrinda pasanambaq. Piru suq runa tukuy imayuqqam Dyusta kasushpa syiluman yaykunanqa ancha trabajus, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Chayshina niwaptinllapaqam, noqaykunaqa ancha ispantashqata kayshina parlarqayllapa: —Chayshina kapuqkuna mana washakaptinqa, ¿pitaq atinman washadu kaytaqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Chaymi Jisusqa noqaykunata chapawashpa niwarqanllapa: —Runakunallaqam mana atinchu washakaytaqa. Piru Dyuspaqqam mana nima trabajuschu, runakunata washanambaqqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Chaymi Pidruqa nirqan: —Taytitu, noqaykunaqam tukuy imayllapata dijashqallapa kani, qamwanna purinaypaqllapa. Chayshina dijashpaqa, ¿imatam ganashaqllapa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jisusqam niwarqanllapa: —Alliptam niykillapa, mushuq bidapi noqa Dyusmanda Shamuq Runa llipyashpa kamachikuptiyqam, qamkuna sigiwaqkunapis dusi awturidarkuna ringillapa kaq, chay dusi isrraylinu atun ayllukunata kamachinaykillapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Chayshinallam rin kaq chay mayqan dijashpa wasingunata, masangunata, paningunata, taytanda, mamanda, warminda, wambrangunata, ichu ch'akrangunata, noqata kasuwanambaqqa. Chaqa payqam 100 tantusta rin ch'askiq. Kanan suq bidapim tukuy tyimpu rin kawsaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Piru kay pachapi achka kamachikuqqam suq bidapiqa manana rinllapachu baliq. Piru kay pachapi mana kamachikuqkunaqam syilupiqa kamachikuqkuna rinllapa kaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jisusqam kay kumparasyunda rurashpa yach'achikurqan: —Tayta Dyus kutimushpaqam, suq ubasniyuq runashina rin ruraq. Chaqa chay ubasniyuq runaqam madrugadu wasinmanda lluqshishpa, rirqan trabajaqkunata maskaq, rinanllapa ubasninda kusichaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Chaymi trabajaqkunata tarishpaqa nirqan: “Riyllapa trabajaq ch'akraypi. Chishyashtin qamkuna trabajaptikiqam, suq dinaryu qellayta pagarashqaykillapa”, nishpa. Chaymi chay runakunaqa “Arí”, nishpa, rirqanna trabajaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Chaymandaqam chay ch'akra dwiñuqa las nwibich'i ririrqan plasaman. Chaypim wakin runa mana trabajuyuqta rikashpa, ");
INSERT INTO qvcNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","paykunatapis nirqan: “Riyllapa ubasniyta kusichaq. Kabaltam rini pagarashuqllapa”, nishpa. Chaymi chay runakunaqa “Arí”, nishpa, rirqanllapana trabajaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Chaymandaqam chay patrunqa larrdusitach'i bwilta ririrqan mas trabajaqkunata maskaq. Chaymandaqam, las tris di la tarditapisch'i bwilta kutirirqan maskariq mas trabajadurkunata. ");
INSERT INTO qvcNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Chaymandaqam las sinku di la tardipisch'i kutirishpa, suq mana trabajuyuqkunata tarirqan. Paykunatapismi tapurqan: “¿Qamkunaqa imata rurashpam chishyangillapa kaypiqa?” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Chaymi chay runakunaqa nirqan: “Manam pipis trabajuta qowanllapachu”, nishpa. Chaymi chay ubasniyuqqa nirqan: “Qamkunapis riyllapa ubasniyta kusichaq. Kabaltam rini pagarashuq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","’Chaymandaqam amsayaykaptinna, chay patrunqa kapatasninda nirqan: “Piyungunata qayashpa, pagarayna. Piru puntata pagaray chay iki yaykuqkunata. Chay punta yaykuqkunataqa ultimutaraq pagarayqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Chaymi chay ultimu yaykuqkunaqa rirqanllapana pagunda ch'askiq. Paykunaqam pagundaqa ch'askirqan suq dinaryu qellayta kada unu. ");
INSERT INTO qvcNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Chayshina chay iki yaykuqkunata puntata pagarashpam, chay punta yaykuqkunataqa ultimutaraq pagararqan. Chaymi chay punta yaykuqkunaqa yuyarqanllapa: Paykunamandaqam masta rini ch'askiq, nishpa. Piru paykunapismi suq dinaryutalla pagundaqa ch'askirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Chaymi pagunllapata ch'askishpaqa, piñakushpa, anyarqanllapa chay dwiñutaqa: ");
INSERT INTO qvcNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Chay ultimu yaykuqkunaqam suq uritatallana trabajarqanllapa. Piru paykunatapismi igwalta pagarashqa kangi. Noqaykunaqam chishyashtin ancha trabajashqallapa kani tukuy rupaypi”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Chaymi dwiñuqa chay anyaqkunata suqninda nirqan: “Yanasita (Yanasitu), manam nima agrabyuta rurashushqachu kani. Chaqa tratukurqanchiqqam, suq dinaryuta pagarashunaqpaq, ¿manachu? ");
INSERT INTO qvcNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Mayá, kaypi paguyki. Riyna. Noqaqam munani kay ultimu yaykuqkunatapis qamtashinalla igwalta pagarayta. ");
INSERT INTO qvcNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Chaqa noqaqam dirichuyuq kani, munashqayta ruranaypaq qellayniywanqa. ¿Qamqachu imbidyakungi qellayniywan paykunata yanapaptiyqa?” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Chay kumparasyunda rurashpam, Jisusqa nirqan: —Chayshinam kay pachapi achka kamachikuqkunaqa suq bidapiqam manana rinllapachu baliq. Piru kay pachapi achka umildi kaqkunaqam suq bidapiqa ancha rinllapa baliq. ˻Chaqa Taytanchiq Dyusqam achkata qayan. Piru paypi yuyakuqkunatallam akran, paywan kawsananllapaqa˼, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisusmi paywan puriqkunawan Jirusalinman riykashpa, ñanmanda suq laduman noqaykuna dusi yach'akuqnindalla apawashpa, kayshina niwarqanllapa: ");
INSERT INTO qvcNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Rikayllapa, Jirusalinmannam riykanchiqllapa. Waqpim noqa Dyusmanda Shamuq Runataqa rin intrigakuwaq kamachikuq isrraylinu kurakunaman, Muysispa liyningunata yach'achikuqkunaman. Paykunaqam rinllapa sintinsyawaq wanchiwananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Chayshina sintinsyawashpaqam, nasyunninchiq Isrrayilpa kuntrangunaman rinllapa intrigakuwaq. Paykunana asipawashpa, suq lastima rurawashpa, asutiwashpallapa, kruspi klabawanqallapa wañunaykaman. Piru kimsa diyamanmi rini kawsamuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sibidiyupa warminmi chay ishkay wambran Jakubuwan, Jwanwan Jisusman shamushpa, qonqorikushpa, suq faburta mañarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Chaymi Jisusqa tapurqan: —¿Imapitaq munangi yanapashunaypaq? nishpa. Chaymi chay Sibidiyupa warminqa nirqan: —Taytitu, yumbaypa gubyirnun kashpaqar, yush'ayku kamachikuy, kay wambraykuna suqnin allin laduykipi, suqnin ichuq laduykipi tiyashpa, qamwan kamachikunanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Chaymi Jisusqa paykunata nirqan: —Qamkunaqam mana yach'angillapachu: Imatam mañaykani, nishpaqa. Chaqa noqaqam ancha rini ñakaq. Chay ñakaykunaqam noqapaqqa suq basu ancha ayaq yakuta upyaykaymanshina rin kaq. ¿Chayshinachu qamkunapis atingimanllapa padisiyta? nishpa. Chaymi paykunaqa nirqan: —Arí. Atinillapam chayshina padisiyta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Chaymi Jisusqa paykunata nirqan: —Alliptam qamkunapis ancha padisishpaqam, chay ayaq basumandashina ringillapa upyaq. Piru noqaqam mana atinichu kamachikuyta, allin laduypi ichu ichuq laduypi tiyanaykillapaqa. Ashwanmi Taytay Dyuslla sigurashqa, pikunam rinllapa tiyaq allin laduypi ichu ichuq laduypi, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Chay mañakushqambaq yach'ashpaqam, noqaykuna dyis yach'akuqkunaqa chay ishkay masaykunawanqa piñakurqayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Chaymi Jisusqa noqaykunata qayawashpa, niwarqanllapa: —Chay suq nasyungunapiqam gubyirnunguna patrungunashina wapuyashpa, manchachikushpa, llaqta masingunata kamachin, ¿manachu? ");
INSERT INTO qvcNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Piru qamkunaqa ama chayshinaqa kayllapachu. Ashwan mas kamachikuq munashpa kaytaqa, suqkunata sirbiyllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Chayri mayqanniki munashpa kamachikuq kaytaqa, suq kriyadushina kanqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Chayshinalla noqa Dyusmanda Shamuq Runa kashpapismi, mana shamushqachu kani suqkuna sirbiwananqa. Ashwanmi shamushqaqa kani, yumbayta sirbinaypaq. Chaymi rini wañuq uchangunapaq pagarakunay, ama kastigadu kanambaqllapa. Chayshinam noqapi yumbay yuyakuqkunata rini washaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Noqaykuna Jiriku llaqtamanda Jisuswan riykaptiyllapam, ancha achka runakuna, warmikuna Jisuspa ikinda rirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Chay ñamba ladumbi ishkay sarku runakuna tiyaykashpam, yach'arqanllapa: Jisukristum kayta pasaykan, nishpa. Chaymi ancha jwirtita qayakurqanllapa: —¡Dabidpa Karu Willkan Taytitu, llakipawayri! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Chaypi kaqkunaqam chay sarkukunata anyarqan, uyaranambaq. Piru paykunaqam mana uyarashpachu, ashwamba masta qayakurqanllapa: —¡Dabidpa Karu Willkan Taytitu! ¡Llakipawayri! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Chaymi Jisusqa rishqanshina shayashpa, chay sarkukunata qayashpa, tapurqan: —¿Imashinam munangillapa yanapashunayqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Chaymi paykunaqa nirqan: —Taytitu, munanillapam rikakuyta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Chaymi Jisusqa llakipashpa, chay sarkukunapa ñawingunata llamkarqan. Chay urasllam das rikakurqanllapa. Chaymi Jisuspa pullanna rirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jirusalin llaqtaman yaqqana ch'ayashpaqam, puntata ch'ayarqayllapa Bitfaji llaqtitaman. Chay Bitfajiqam Ulibu lumapa sirkambi kidan. Chay lugarpiqam Jisusqa ishkay yach'akuq masiykunata nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Rikay, waq ñawpanchiqpim suq kasiriyu. Waqman rishpam, ringillapa tariq suq burra watashqata wawandinda. Chay burrata paskashpa, ishkandinda apamuyllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Piru mayqan imata nishuptinllapaqa, niyllapa: “Siñurninchiqmi munan. Dasllam rin kutichimuq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Chayshina ruraptinllapam, Dyuspaq rimaq kayshina iskibrishqanqa kumplirqanna: ");
INSERT INTO qvcNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Jirusalin llaqtapi tiyaqkunata niyllapa: “Rikay, gubyirnuykiqa suq burrapa wawambi muntakushpa, ancha umildi shamun qamkunaman”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","7","Chaymi chay ishkay yach'akuqnin masiykunaqa rishpa, Jisus nishqanshina apamurqanllapa suq burrata wawandinda. Chaymandaqam sawanman kapanllapata rurarqanllapa. Chayshina ruraptinllapaqam, Jisusqa muntakushpana rirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Chaypim ancha achka runakuna, warmikuna karqan. Paykunam Jisus riykashqan ñawpanda kapangunata mandashpa rirqan. Wakinqam muntipa rikran raprayuqkunata kuchushpa, mandarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kanan chay ñawpanda, ikinda riqkunaqam ancha kushikushpa, ancha jwirtita kunyarqanllapa: —¡Biba, biba! ¡Alabashun unay Dabidpa Karu Willkan Jisusta! ¡Taytanchiq Dyus ancha yanapanqa kay rrimplasun shamuykaqta! ¡Tayta Dyustaqa ancha alabashunllapa! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jirusalinman yaykuptinqam, chaypi achka tiyaqkuna ancha kunyaptinllapaqa, wakinqa kayshina tapurqanllapa: —¿Pitaq kay runaqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Chaymi chay runakuna, warmikunaqa nirqanllapa: —Kayqam Dyuspaq rimaq Jisus. Payqam Galiliyapa Nasarit llaqtanmanda shamushqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Chaymandaqam Jisus Tayta Dyuspa adurana wasinman yaykushpaqa, (patyumbi) tarirqan randiykaqkunata randikuykaqkunata. Chaymi yumbay paykunata qatirqan, chay adurana wasimanda lluqshinanllapa. Kanan chay qellay kambyaqkunapa mesangunata, chay palumitakunata randikuqkunapa iskañundindam bularqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kanan paykunataqam nirqan: —Dyuspa Santu Librumbiqam nin: “Wasiyqam noqaman mañakunanllapa”, nishpa. Piru qamkunaqam ladrungunapa mach'aynindashina rurashqallapa kangi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Chaymandaqam Tayta Dyuspa adurana wasimbi Jisus kaykaptin, payman tandakarqanllapa sarkukuna, kujukuna. Chaymi yumbay paykunata kach'akachirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Piru isrraylinu kurakunapa kamachikuqninguna, Muysispa liyningunata yach'achikuqkunam Jisusta rikarqanllapa, chay milagrukunata ruraykaptin. Chaymandaqam uyarqanllapapis chay wambritukunata, Tayta Dyuspa adurana wasimbi Jisusta kayshina alabaptinllapa: “¡Biba gubyirnu Dabidpa Karu Willkan!” nishpa. Chaymi ancha piñakushpa, ");
INSERT INTO qvcNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jisusta kayshina tapurqanllapa: —¿Uyangichu kay wambrakuna niqta? (Manam balinchu qambaq ninanllapa: “Dabidpa Karu Willkanmi”, nishpaqa.) Chaymi Jisusqa nirqan: —Arí, uyanim. ¿Manachu liyishqallapa kangi Dyuspa Santu Librumbi paykunapaq kayshina nishqanda? Dyus yanapaptinmi, chay wambritukuna tukuy chay iti ñuñuykaqkuna ancha shumaqta rinllapa alabaq, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Chaymandaqam paykunata dijashpana, Jisusqa noqaykunawan rirqan Bitanilla (Bitaniya) llaqtamanna, waqpina chay tuta kidanayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Jisusqam qayandin madrugadu Jirusalinman kutiriykashpaqa mallaqnarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Chayshina riqshinaqam, ñamba ladumbi suq yura igusta rikarqan. Rikashpaqam rirqan puqoyninda maskaq. Piru manam nima puqoyninda tarirqanchu. Raprangunatallam tarirqanqa. Chaymi chay yura igustaqa nirqan: —¡Mananam nunka ringichu puqoq! nishpa. Chayshina niptinllam, chay uras igusqa limpu chakirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Chayta rikashpam, noqaykuna yach'akuqningunaqa ispantashqata tapurqayllapa: —¿Imashinataq chayta niptikilla, chay igusqa das chakirqan? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Chaymi Jisusqa kayshina niwarqanllapa: —Alliptam niykillapa, Dyuspi allita yuyakushpa mañakushpaqam, kay rurashqaymanda masta atingillapa rurayta. Chaymi Dyuspi allita yuyakushpa, kay qaqata niptikillapa, “Riy mar yakuman”, nishpaqam, chayshina rin kaq. Piru chayshina ruranaykiqam mana balinchu ashlitatalla Tayta Dyuspi yuyakunaykillapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Chaymi Dyuspi allita yuyakushpa, tukuy ima mañakushqaykita paymanda ringillapa ch'askiq. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisus Tayta Dyuspa adurana wasinman yaykushpa yach'achikuykaptinmi, kamachikuq isrraylinu kurakuna, chay kamachikuq ansyanukunawan payman qemikashpa, tapurqanllapa: —Mayá, niwayllapa. ¿Ima karguyuqtaq kangi? ¿Pitaq numbrashushqa, awturidar kanaykiqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Chaymi Jisusqa paykunata nirqan: —Mayá, noqapis suq tapunata tapushqaykillapa. Chayta qamkuna kuntistawaptikim, noqapis nishqaykillapa: Pi kamachiwaptinmi, kaykunata rurani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Mayá, Jwan Shutichikuqtaqa ¿pitaq numbrarqan, shutichikunanqa? ¿Dyuschu ichu runakunalla? Chaymi chay isrraylinu kurakuna, chay ansyanukunaqa suqnin suqnin parlarqanllapa: —Dyusmi kamachishqa, niptinchiqqach'i, niwashun: “Chayshina numbraptinqa, ¿imaraykutaq qamkuna mana kriyirqaykichu paytaqa?” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Piru “runakunallam kamachishqa” niptinchiqqach'i, ¿imanachiwashun yumbay kay runakunaqa? Chaqa paykunaqam Jwambaqqa kriyinllapa, Dyuspaq rimaqmi karqan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Chaymi Jisusta kayshinana nirqanllapa: —Manam yach'anillapachu, nishpa. Chayshina niptinllapaqam, Jisuspis paykunata nirqan: —Noqapismi mana nishqaykillapachu pi kamachiwaptinmi, kaykunata rurani, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jisusqam chay kamachikuqkunata nirqan: —Mayá, ¿imatam yuyangillapa kaypaqqa? Suq runam ishkay churiyuq karqan. Chaymi suqninda nirqan: “Ijitu, riy kananqa ubasninchiqta kusichaq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Chay churinqam nirqan: “Manam rinichu”, nishpa. Piru chaymandaqam taytanda kasushpa, rirqanna trabajaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Chayshinallam taytanqa chay suq churindapis nirqan: “Riy ubasninchiqta kusichaq”, nishpa. Payqam, “Rishaqri” nirqan. Piru yanqam nirqanqa. Manam rirqanchu tandaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Chayshinaqa ¿mayqan churindaq taytan nishqandaqa kasurqan? nishpa. Chaymi paykunaqa nirqan: —Chay punta churinmi kasurqanqa, nishpa. Chaymi Jisusqa paykunata nirqan: —Alliptam niykillapa, chay uchayuq kuntribusyunda kubrakuqkuna, bandulira warmikunapismi chay uchangunata dijashpa, Dyustana kasushpa, qamkunamanda mas puntata syiluman rinllapa yaykuq, Dyuswan kawsananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Chaqa Jwan Shutichikuq shamushpaqam, qamkunata yach'achishurqan, allita rurashpana kawsanaykillapa. Piru qamkunaqam paytaqa mana kriyirqaykillapachu. Piru chay kuntribusyunda kubrakuqkuna, chay bandulira warmikunam Jwandaqa kriyirqanllapa. Piru qamkunaqam chayta rikashpapis, uchaykikunataqa mana dijarqaykillapachu, Dyuspi yuyakunaykiqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Uyayllapa kay suq kumparasyunda: Suq runa ancha achka ubasta tarpushpash, rridurninda muralla pirqata rurarqan. Chaymandaqash jwirti rumi kantiriyapi ush'kukushpa, suq pusuta rurarqan, ubasningunata kusichashpa, chaypi qapinambaq. Rurarqambisshi suq altu turrita, chay altumanda chay tarpudunda kwidanambaq. Chayshina rurashpaqash, partidaryungunawan ch'akranda dijashpa, payqa karumanna rirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Chaymandaqash ubasta kusichanan tyimpu ch'ayaptinqa, chay ch'akrapa dwiñunqa kriyadungunata kach'arqan, chay partidaryunguna partinda qoptinllapa apanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Piru chay partidaryungunaqash, chay dwiñupa kriyadunguna ch'ayaptinqa, piskashpa, suqninda alli alli maqarqanllapa; suqtaqash wanchirqanllapa; suqtaqash rumikunawan sitarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Chaymandaqash chay dwiñuqa mas achka kriyadungunata kach'arirqan. Paykunatapisshi chayshinalla suq lastima rurarqanllapa chay punta shamuqkunatashina. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Ultimutaqash chay dwiñuqa churindana kach'arqan: “Churiytaqam kasunqallapana”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Piru chay partidaryungunaqa chay dwiñupa churin yaqqana ch'ayaqta rikashpaqash suqnin suqnin parlarqanllapa: “Payqam irinsyawan rin kidaq. Chayri aku wanchiq, noqanchiqkunana kay ch'akranwan kidananchiq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Chayshi chayshina parlashpaqa, chay dwiñupa churinda piskashpa, ch'akranmanda sawaman surqoshpa, wanchirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Chaymi Jisusqa chay runakunata kayshina tapurqan: —Chay ch'akrapa dwiñun shamushpaqa, ¿imanachinqaraq chay malu partidaryungunataqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Paykunaqam nirqanllapa: —Chay malukunataqam mana llakipashpachu wanchinqa. Chaymandaqam allin partidaryukunata maskanqa, kusichan puqoptin, partinda qonanllapa, nishpa. Nuta: Chay ch'akrapa dwiñunqam munan niyta Tayta Dyus. Chay kriyadungunaqam munan niyta Dyuspaq rimaqkuna. Chay dwiñupa churinqam munan niyta Jisukristu. Chay mana baliq partidaryukunaqam munan niyta chay mas kamachikuq isrraylinu kurakuna chay kamachikuq ansyanukunapis, nishpa.  ");
INSERT INTO qvcNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Chayshina niptinllapaqam, Jisusqa suq kumparasyunda rurashpa, nirqan: —Qamkunaqam riqsiwangillapa mana baliq rumitashina. Piru Dyuspa Santu Librumbiqa ¿manachu liyishqallapa kangi kayshina nishqandaqa? Albañilkuna wichukushqan rumitaqam kananqa Dyusqa wasimba simyintumbi mas baliqpaqna rurashqa. Dyus chayshina rurashqanraykum ancha alabanchiqllapa: “Ancha shumitaqtam rurashqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Chaymi niykillapa, qamkuna disprisyawashpam, manana ringillapachu kawsaq Dyuswanqa. Ashwanmi payta kasuqkunalla suq bidapiqa paywan rinllapa kawsaq. ˻ ");
INSERT INTO qvcNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Piru chay ancha baliq rumipa sawambi bulakaqkunaqam piti piti rin kidaq. Kanan chay rumi mayqamba sawanman ishkishpaqam, limpu chankashpa, pulbuta rin dijaq, nishpa.˼ Nuta: Jisukristum chay rumishinaqa. Paypi mana munaq yuyakuqkunam chay albañilkunashina, chay rumipi bulakaqkunashina.  ");
INSERT INTO qvcNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Chay ishkay kumparasyunda uyashpaqam, chay kamachikuq isrraylinu kurakuna, chay farisiyu duktrinayuqkunaqa intyindirqanllapa: Noqanchiqkunatam kumparawaykanchiq chay malu partidaryukunawan, chay albañilkunawanqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Chaymi Jisustaqa prisuytana munarqanllapa. Lukismi runakunata mancharqanllapa. Chaqa achka runam kriyirqanllapa: Jisusmi Dyuspaq rimaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisusmi achka kumparasyunda rurashpa, suq kutinda paykunata kayshina yach'achirqan: ");
INSERT INTO qvcNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Dyuswan suq bidapi kawsananchiqqam suq kasamyintu fyistashina. Suq gubyirnush fyistata rurarqan, churin kasaranambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Chaymandaqash kriyadungunata nirqan: “Riyllapa kumbidashqaykunata apamuq”, nishpa. Piru chay kumbidashqangunaqash mana munarqanllapachu shamuytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Chayshi paykuna mana shamuptinqa, suq kriyadungunata nirqan: “Rishpa chay kumbidashqaykunata kayshina niyllapa: ‘Patrunniymi yanuchikushqa mikunata. Gurduyachishqan mishirungunata wanchichishqa. Suq laya animalkunatam gurduyachishpa wanchichishqana, ancha mishkita mikunanchiq. Tukuy imatam allichashqana. Akullapar fyistaman’ ”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Piru paykunaqash kriyadungunata fyirusyashpa, suqqa ch'akranman rirqan trabajaq. Suqqash rirqan nigusyungunata ruraq. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Suqkunaqash chay gubyirnupa kriyadungunata suq lastima maqashpa wanchirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","’Chayshi chay gubyirnu chay rurashqanllapata yach'ashpaqa, ancha piñakushpa, suldadungunata kamachirqan: “Riyllapa wanchiq chay matansyirukunata. Wanchishpaqa, llaqtanda rupachiyllapa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Chaymandaqash chay gubyirnuqa kriyadungunata nirqan: “Alliptam niykillapa, tukuy imam allichashqana, kasamyintu fyistata rurananchiqllapa. Lukismi chay kumbidashqaykunaqa fyirusyawashqa. Chaymi manana munanichu paykuna shamunanqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Mayá, atun ñangunaman rishpa, yumbanda kumbiday, shamunanllapa kay kasamyintu fyistaman”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Chayshi kriyadunguna ñangunaman rishpaqa, yumbay tarishqanllapata allinda, maluta kumbidarqan, fyistaman shamunambaq. Chayshinash chay wasimanqa achka runakuna undarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Chaymandaqash gubyirnuqa yaykurqanna chay kumbidashqangunata rikaq. Piru chaypi karqan suq kumpañaq runa. Payqash (chay kasaraqta mana rrispitashpachu) mana mudakushqachu karqan kasamyintu mudanataqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Chayshi chay gubyirnuqa tapurqan: “Yanasita (Yanasitu), ¿imashinataq kaymanqa yaykumurqayki kasamyintupaq mana mudakushpaqa?” nishpa. Piru runaqash uyararqanlla. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Chayshi chay gubyirnuqa kriyadungunata kamachirqan: “Ch'akingunata, makingunata ch'aqnashpa, sawa tutayaqman wichukuyllapa. Chay tutayaqpim ancha padisishpa, waqashpa, kirungunata rin qech'yachiq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Chaqa Taytanchiq Dyusqam achkata kumbidaykan, paywan kawsananllapa. (Piru ashlalla paypi yuyakunllapa.) Chaymi ashlatalla akran, (paywan tukuy tyimpu kawsananllapaqa.) ");
INSERT INTO qvcNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Chaymandaqam farisiyu duktrinayuqkunaqa tandanakushpa, kayshina parlarqanllapa: —Aku tapuq Jisusta, imapi pandaptin, chaypaq tumbanna prisunanchiqllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Chaymi chay farisiyukunaqa wakin yach'akuqningunata, Irudispa partidunmanda wakin kaqkunatapis kach'arqanllapa, Jisusta kayshina tapunan: —Yach'achikuq Taytitu, qamqam allip kaqtalla Dyuspaq yach'achikungi. Chaqa manam nima pudirniyuq runata manchashpachu ni sawachashpachu, Dyus munashqandalla yach'achikungi. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Chayri niwayllapa, ¿Allichu Rrumapa gubyirnunda kuntribusyunda pagarananchiqllapa, ichu mana? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Piru Jisusqam yach'arqan: Prisuwananraykum chay layataqa tapuwanllapa, nishpa. Chaymi paykunataqa nirqan: —¡A, shimikiwanlla Dyusta kasuqkuna! ¿Imaraykutaq chayshinaqa munangillapa mallipawaytaqa? ");
INSERT INTO qvcNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mayá, rikachiwayllapa chay kuntribusyun pagarakunanchiq qellayta, nishpa. Chayshina niptinqam, chay runakunaqa suq dinaryu qellayta rikachirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Chaymi Jisusqa chay qellayta rikashpaqa, paykunata tapurqan: —¿Pipa rritratunmi, pipa shutinmi kay qellaypiqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Chaymi paykunaqa nirqan: —Rrumapa gubyirnumba shutinwan rritratunmi, nishpa. Chayshina niptinllapaqam, Jisusqa paykunata nirqan: —Rrumapa gubyirnumba kaqtaqa, payta qoyllapa. Dyuspa kaqtaqa Dyusta qoyllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Chayshina Jisusta mana atishpa pandachiytaqam, chay kuntraqkunaqa ancha ispantarqanllapa. Chaymi dijashpana, rirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Chay diyataqmi wakin sadusiyu duktrinayuqkunaqa shamurqanllapa Jisusta rikaq. Chay sadusiyukunaqam kriyinllapa: Wañushqakunaqash manana rinchu kawsamuq, nishpa. Chaymi paykunaqa Jisusta tapurqanllapa: ");
INSERT INTO qvcNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Yach'achikuq Taytitu, chay unay Muysismi kamachikushqa, suq warmiyuq runa manaraq wambrayuq kashpa wañuptinqa, chay almapa masanna biyudawan kasaranqa, chay biyudapi wambrayuq kaptin, chay alma masamba wambranshina kanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Chaymi munanillapa tapushuyta: Suq ayllupish syiti ullqo masapura karqan. Chay syitimanda kulaka masanqash warmikurqanna. Piru manaraq wambrayuq kashpash wañurqan. Chayshina wañuptinqash, chay almapa minur masanna kasararqan biyudawanqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Chay masambisshi chayshina manaraq wambrayuq kashpa wañurqan. Chaymandaqash chay mas minur masanna chay biyudawanqa kasararirqan. Paypisshi manaraq wambrayuq kashpa wañurqan. Chayshinash syitindin chay warmiwan kasarashpa, mana ni mayqannin chay warmipiqa wambrayuq kashpachu wañurqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Chaymandaqash chay warmipis wañurqanna. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Chayshina wañushqakuna allipta kawsamuptinqach'i, ¿mayqannimba warminraqri kanman? Chaqa syitindimba warminshi kashqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Chayshina niptinllapam, Jisusqa paykunata nirqan: —Qamkunaqam Dyuspa Santu Librun nishqanda mana intyindishpa ni Dyus pudirniyuq kashqambaq yach'ashpa, ancha pandashqa kangi. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Chaqa wañushqakuna kawsamushpaqam, manana warmiyuqchu ni runayuqchu rinllapa kaq. Ashwanmi Dyuspa anjilningunashina manana kasarashpachu rinllapa kawsaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","Piru wañushqakunapaq yach'ananchiqqa, yuyashunllapa chay unay agwilunchiqkunapaq Dyus nishqanda. Chaqa chay unay alma agwilunchiqkuna Abrajan, Isak, Jakubum puntata wañurqanllapa. (Chaymandaqam achka watakunamanda) Tayta Dyus paykunapaq nirqan: “Kanangamanmi paykunapa Dyusnin kani”, nishpa. Chaymi yach'anchiq: Chay almakunam Dyuspaqqa kawsaykanllaparaq, nishpa. ¿Manachu chaytaqa liyishqallapa kangi? ");
INSERT INTO qvcNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Chayshina Jisus ancha shumaqta yach'achikuptinqam, chaypi kaq uyaqkuna ancha ispantashqata yuyarqanllapa: Ancha yach'ayniyuqmi kay runaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Farisiyu duktrinayuqkuna yach'ashpa: Jisusmi sadusiyu duktrinayuqkunata uyarachishqa nishpa, tandakarqanllapa, paykunapis payta tapunambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Chaymi Muysispa liyningunata suq yach'achikuq mallipananrayku Jisusta kayshina tapurqan: ");
INSERT INTO qvcNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Yach'achikuq Taytitu, ¿Tayta Dyuspa yumbay liyninmandaqa mayqan liytaq mas allinqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Chaymi Jisusqa nirqan: —“Dyusnikita kuyayllapa, tukuy shunqoykiwan, tukuy bidaykiwan, tukuy yuyaynikiwan.” ");
INSERT INTO qvcNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kay liymi mas alli ruranaykipaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Kay suq liypismi chay punta liyshinalla ancha balin. Kayshinam nin: “Qam kwirpuykita kuyashqaykishina, yumbay runa masikitapis kuyay”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kay ishkay liykunata kasushpaqam, alabis Muysispa yumbay liyningunata, Dyuspaq suq rimaqkuna yumbay nishqanllapatapis kasuykangillapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Chayshina farisiyu duktrinayuqkuna tandanakushqa kaptinmi, Jisusqa paykunata tapurqan: ");
INSERT INTO qvcNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Imatataq yuyangillapa Dyus Akrashqan Washadurpaqqa? ¿Pipa karu willkandaq qamkunapaqqa? nishpa. Farisiyukunaqam nirqanllapa: —Alma gubyirnu Dabidpa karu willkanmi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Chayshina niptinllapam, Jisusqa tapurirqan: —Chayshina kaptinqa, ¿imaraykutaq Dyuspa Santu Ispiritum Dabidta rimachirqan: “Dyus Akrashqan Washadurqam kamachikuqniy”, ninambaqqa? Chaqa Dabidqam nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Tayta Dyusmi Kamachikuqniyta nirqan: “Allin laduypi tiyay, kuntrashuqkunata binsishpa, ch'akikipa waranman ruranaykaman (qamta kasushunanllapa)”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Chayshina chay ancha baliq gubyirnu Dabid Dyus Akrashqan Washadurpaq “Siñurniymi” nirqan. Piru Dabidpa karu willkan kaptinqam, ¿imashinataq siñurninqa kanman? Nuta: Jisusqam chayshinaqa nirqan, chay uyaqkuna yach'anambaqllapa: Dyus Akrashqan Washadurqam, runa kashpapis, yumbay runakunamanda mas pudirniyuq, nishpa.  ");
INSERT INTO qvcNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Chayshina tapuptinqam, manana ni pipis atirqanchu Jisusta kuntistaytaqa. Chaymi chay diyamandapacha manana ni pipis almitikarqanchu Jisusta yanqa tapuytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Chaymandaqam Jisusqa chaypi kaqkunata, noqaykuna yach'akuqnindapis kayshina niwarqanllapa: ");
INSERT INTO qvcNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Muysispa liyningunata yach'achikuqkuna, farisiyu duktrinayuqkunawanmi kayshina yuyanllapa: Noqanchiqkunallam kamachikuqqa kanchiq, Muysispa liyningunata suqkunata intyindichinanchiqqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Paykuna yach'achikushqandar kasuyllapa, piru ama rurayllapachu paykuna rurashqandaqa. Chaqa paykunaqam shiminwanlla ninllapa: “Kay imata rurashunllapa”, nishpa. Piru manam chay nishqandaqa ruranllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Paykunaqam Dyus nishqanda yach'achikushpaqa, yuyayningunatapis yapanllapa. Chayshina yach'achikushpaqam, llaqta masinchiqkunata ancha llashaqtashina aparichiykan: “Yumbay kaykunata rurayllapa”, nishpa. Piru kamachishpaqam, paykunaqa mana ni ashlita ni suq didunwan munanllapachu yanapayta, chay kamachikushqanda kumplinambaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","’Tukuy imataqam ruranllapa, runakuna rikanambaqlla. Chaymi Dyuspa Santu Librunmanda wakin birsikulukunata taksha papilkunapi iskibrishpa, mas atun kajitakunapa ukumbi rurashpa, urkungunapi, rikrangunapi watashpa purinllapa. Kanan kapangunatapismi rurakunllapa manyangunapi mas atun flikuskunata rurashpa, suqkuna alabashpa: “Waqkunaqam kamachikuqkuna”, ninanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Apaptinllapa mikuqpismi, gustanllapa chay mas kamachikuqkunapa ladumbi tiyayta, yumbay rikananllapa. Chayshinallam sinaguga wasipipis gustanllapa kamachikuqkunapa tiyanambi tiyayta. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Plasakunaman rishpam, munanllapa suqkuna shumaqta napaykunanllapa: “Yach'achikuq Taytitu”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Piru qamkunaqa ama dijakayllapachu, suqkuna “Yach'achikuq Taytitu” nishunanllapaqa. Chaqa yumbay qamkunaqam masapurashinalla kangillapa. Noqallam qamkunapa yach'achikuqnikiqa kani. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Chayri kay mundupi mayqan kamachikuqtaqa ama “Taytitu” niyllapachu. Chaqa Dyus syilupi kaqllam Taytaykillapaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Amar ni dijakayllapachu: “Kamachikuq Taytitu” nishunanllapaqa. Chaqa noqa Dyus Akrashqan Washadurllam kamachikuqnikiqa kani. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Qamkunapa kamachikuqnikiqam yumbayta sirbinqa kriyadushina. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Chaqa mayqan palanganutaqam Taytanchiq Dyusqa rin penqachiq. Piru mana kamachikuq kaqkunataqam kamachikuqpaq rin numbraq. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Imanangiraqri qamkuna Muysispa liyningunata yach'achikuqkuna, qamkuna farisiyu duktrinayuqkunaqa! ¡Chaqa shimikiwanllam Dyustaqa kasungillapa! Dyusta kasuyta munaqkunataqam mana baliq duktrinaykikunata yach'achishpa, ancha dañachingillapa. Chaymi paykunaqa syilumanqa manana rinllapachu yaykuq, Dyuswan kawsananllapa. Chayshina dañachishpaqam, qamkuna syilupa pungunda kirpaykangishina. Chaymi qamkunaqa syilumanqa mana ringillapachu atiq yaykuyta. ˻ ");
INSERT INTO qvcNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Imanangiraqri qamkuna Muysispa liyningunata yach'achikuqkuna, farisiyu duktrinayuqkunaqa! ¡Chaqa qamkunaqam shimikiwanlla Dyusta kasungillapa! Kanan biyudakunapa wasingunata qoch'ingillapa. Chaymandaqam allin runakunapaq tukushpa, yumbaypa ñawpambi Dyusman mana shaykuq mañakungillapa. Chaymi suqkunamanda mas kastigadu ringillapa kaq.˼ ");
INSERT INTO qvcNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Imanangiraqri qamkuna Muysispa liyningunata yach'achikuqkuna, farisiyukunaqa! ¡Chaqa shimikiwanllam Dyustaqa kasungillapa! Qamkunaqam ancha qawch'u kangillapa, tukuy pachata, tukuy mar yakutapis rinaykillapa, suq runa masta duktrinaykipi kriyichinaykillapa. Piru chay runa kriyichishqaykiqa qamkunashina ruraptinqam, ishkay tantu mas uchayuqta ruraykangillapa, infyirnupi mas kastigadu kanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Imanangiraqri qamkuna mana allita yach'achikuqkunaqa! Dyus nishqanda mana intyindiptikiqam, yuyaynikikunaqa suq mana rikakuqshina. Chaymi suqkunata mana baliq kustumbrikikunata yach'achishpaqa, paykunatapis pandachingillapa. Chaqa qamkunaqam yach'achikungi: Mayqan runa ichu warmi Tayta Dyuspa adurana wasimba shutimbi jurashpaqam, mana nisisaryuchu kumplinambaq. Piru mayqan runa Dyuspa adurana wasimba urumba shutimbi jurashpaqam, ancha nisisaryuna kumplinambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡A, tuntu sarkukunashina! ¿Mayqannindaq masta balin Dyuspaqqa, uru ichu paypa adurana wasin? Paypa adurana wasinmi masta balin urumandaqa. Chay uruqa Dyuspa adurana wasimba kaptinmi santu kidan, Dyuspaqna kashqanrayku. Manaqa manam balinmanchu Dyuspaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ningillapapismi: “Pata altarpa shutimbi jurashpaqam, mana nisisaryuchu kumplinambaqqa. Piru chay pata altarpa sawambi ufrinda kaqpa shutimbi jurashpaqam, ancha nisisaryu kumplinambaq. Chaqa mana kumplishpaqam ancha uchayuq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡A tuntukuna! ¡Sarkukunashinam mana nimatapis rikangillapachu! ¿Mayqandaq masta balin, ufrindachu ichu pata altar? Chay pata altarmi mastaqa balin. Chaqa pata altarpi chay ufrinda Dyuspaqna kashpaqam, ancha balin. Manaqa manam balinchu. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Alliptam niykillapa, pata altarpa shutimbi juraqqam, tukuy ufrindandimba shutimbipis juraykan. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Dyuspa adurana wasimba shutimbi juraqqam, Dyuspa shutimbipis juraykan. Chaqa Dyusqam tiyan chay shumaq wasimbi. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Syilupa shutimbi juraqpismi, Dyuspa ancha altu trunumba shutimbipis juraykan. Chaqa syiluqam Dyuspa ancha shumaq trunun. Chayshinaqam Dyuspa shutimbipis juraykan. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Imanangiraqri qamkuna Muysispa liyningunata yach'achikuqkuna, qamkuna farisiyu duktrinayuqkunaqa! ¡Chaqa qamkunaqam shimikiwanlla Dyustaqa kasungillapa! Asta anisnikimanda, kuminusnikimanda mintaykimandam dyismuta surqongillapa Dyuspaq. Piru Tayta Dyus mas baliq kamachikushqandaqam mana kasungillapachu. Chayri bidaykillapata kambyashpa, chay mas baliq kamachikushqanda kasushpaqa, allitana rurashpa, llakipakuqkuna kashpa, Dyuspi allita kriyingimanllapa. Chayshina rurashpaqa, chay dyismuykitapis qoyllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡A, qamkuna, mana yach'ayniyuq yach'achikuqkuna! Qamkunaqam ancha allita kwidakangillapa, ama nima mapa mikunata mikunaykillapa. Piru mas fiyu uchakunata rurashpaqam, mana ni intyindingillapachu: Uchatam ruraykani, nishpaqa. Ancham kwidakangillapa, ama ni suq chushpisitu shimikiman yaykunan. Piru manam intyindingillapachu: Suq atun mapa kamillu animalmi yaykuykan shimiyman, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Imanangiraqri qamkuna Muysispa liyningunata yach'achikuqkuna, qamkuna farisiyu duktrinayuqkuna! ¡Chaqa qamkunaqam shimikiwanlla Dyustaqa kasungillapa! Qamkunaqam basuykikunapa, platuykikunapa sawandalla mayllangillapa, piru kwirpuyki munashqandalla rurashpaqam, chay upyashqaykita, chay mikushqaykita qoch'ishqallapa kangi runa masikikunata. Chaymi shunqoykillapaqa ancha mapa Dyuspaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡A, mana yach'ayniyuq farisiyukuna! Puntata Dyusman mañakuy, yumbay uchaykimanda pirdunashunambaq. Chaymandaqa pay munashqanda rurashpaqam, limpyu shunqoyuq kayllapa. Chayshina rurashpaqam, tukuy kwirpuykipis Dyuspaqqa limpyuna rin kaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Imanangiraqri qamkuna Muysispa liyningunata yach'achikuqkuna, qamkuna farisiyu duktrinayuqkunaqa! ¡Chaqa qamkunaqam shimikiwanlla Dyustaqa kasungillapa! Chaymi qamkunaqa chay almakuna pambakashqa nichu laya sipulturashina kangillapa. Manchu almata pambaptinchiqqa, nichupa sawanda ancha shumaqta blankiyanchiq. Piru ukunqam tullu likidu ancha millanaypaq mapakuna ash'naykan. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Chay nichushinallam qamkunapis kangillapa. Chaqa sawa kwirpuykillam allin laya kangillapa, runakuna rikashunanllapa. Piru shimikiwanlla Dyusta kasushpaqam, shunqoykipiqa ancha uchayuq kangillapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Imanangiraqri qamkuna Muysispa liyningunata yach'achikuqkuna, qamkuna farisiyu duktrinayuqkunaqa! ¡Chaqa qamkunaqam shimikiwanlla Dyustaqa kasungillapa! Unay agwiluykillapam wanchirqan Dyuspaq rimaqkunata. Piru kananmi qamkunaqa chay rimaqkunapa nichu laya sipulturangunata kwidaykangillapa. Chay nichungunata kwidashpa, chay unay rimaqkunata alabashpaqam, ");
INSERT INTO qvcNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ningillapa: “Chay unay agwilunchiqkunapa tyimpumbi kawsashpaqach'i, Dyuspaq rimaqkunata mana wanchinayllapatachu”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","(Piru kananqam noqata munangillapa wanchiwayta.) Chaymi chay unay agwiluyki wanchikuqkunashina kangillapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Chaqa qamkunaqam munangillapa ushyayta chay unay agwiluykikuna qallarishqanda. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Qamkunaqam malukuna kashpa, kulibrapa ayllunguna kangillapa! Chayshina kashpaqa, ¿imashinaraq atingimanllapa infyirnumandaqa washakayta? Manam ringillapachu atiq washakaytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Chayshina malukuna kaptikillapam, qamkunaman rini kach'amuq noqapaq rimaqkunata, yach'ayniyuqkunata, yach'achikuqkunata. Piru paykunamanda wakindaqam ringillapa wanchiq. Wakindaqam kruspi ringillapa klabaq. Wakindaqam sinaguga wasikunapi ringillapa asutiq. Llaqtan llaqtanmi ikinllapata ringillapa riq, paykunata qesachanayki. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Chayshina ruraptikillapam, chay unay agwiluykikuna allin runakunata wanchishqangunapaq qamkunapis uchayuqkuna ringillapa kaq. Chay ancha allin Abilta wanchishqan tyimpumandapacha, chay Birikiyaspa churin Sakariyasta wanchishqan tyimpukaman, yumbay chay agwiluykikuna wanchishqan runakunapaqmi qamkunapis kastigadu ringillapa kaq. Chay unay agwiluykikunaqam chay Sakariyasta wanchirqanllapa Dyuspa adurana wasimba pungumbi, pata altarpa ñawpambi. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Chayri allita uyawayllapa, Taytanchiq Dyusqam yumbay qamkunata rin kastigashuqllapa, chay ancha uchata rurashqaykirayku, chay agwiluykikuna rurashqanraykupis. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Ay, Jirusalimbi tiyaqkuna! Qamkunaqam Taytanchiq Dyuspaq rimaqkunata wanchingillapa. Kanan Dyus kach'amushqan runakunatam sitangillapa. Manchu suq wallpaqa alitamba warambi pulichitungunata tandan. Chayshinallam noqapis qamkunata kutin kutin ancha munashqa kani tandashuyllapata, piru mana munarqaykillapachu. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Chaymi kay llaqtaykiqa wichukudu rin kidaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kanan mananam ringillapachu rikawaq, syilumanda kutimunay diyakaman. Chay diyapiqam noqapaq ringillapa niq: “¡Alabashqa kanqa Tayta Dyuspa rrimplasun shamuqqa!” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Tayta Dyuspa adurana wasinmanda Jisus lluqshishpa riykaptinnam, noqaykuna yach'akuqningunaqa qemikashpa, nirqayllapa: —¡Siñursitu, rikay kay ancha shumaq atun adurana wasita! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Chaymi Jisusqa niwarqanllapa: —Kananqam rikaykangillapa kay atun wasitaqa. Piru alliptam niykillapa, suq diyam kay rikashqaykitaqa limpu rinllapa bulaq. Chayshina bulaptinllapa kay wasitaqam, manana ni suq rumi patachaduqa rinchu kidaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jisusmi noqaykuna yach'akuqningunawan Ulibu lumaman rishpa, chaypi tiyarqan. Chaypi tiyaykaptinmi noqaykunaqa qemikashpa, uyaraplla (uyaralla) tapurqayllapa: —Niwayllapari chay nishqaykikunaqa ¿ima tyimpum rin kumpliq? ¿Imata rikashpam yach'ashaqllapa: Jisukristum rinna kutimuq. Kay munduqam rin ushyakaqna, nishpaqa? ");
INSERT INTO qvcNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Chaymi Jisusqa niwarqanllapa: —Kwidakayllapa ama pipis ingañashunambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Chaqa achka llullakuqkuna shamushpam, noqapa shutiyta myintashpa, rin niq: “Noqam Dyus Akrashqan Washadurqa kani”, nishpa. Chayshinam achka runata, warmita rinllapa ingañaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Qamkunaqam ringillapa uyaq: “Waqpi, kaypim pilyaykanllapa”, nishpa. Piru amar manchayllapachu. Chayshinam rin kaq. Piru chayshina kaptimbismi, manaraq rinchu ushyakaq kay munduqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Chaqa puntata suq nasyumbi tiyaqkunam rin pilyaq suq nasyumbi tiyaqkunawan. Achka nasyungunapuram rinllapa pilyaq. Kay mundupiqam waqpi, kaypi qeshyaykuna, ambrunakuna rin kaq. Pachapismi waqpi kaypi rin kuyuq. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tukuy kay siñakunaqam munan niyta, ñakaykunam qallariykanna, nishpa. Chaymandaqam mas achka ñakaykuna rin kaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Qamkunatapismi qesachashushpa, rinllapa wanchishuq. Yumbaymi rin ch'iqnishuqllapa, noqapi kriyishqaykirayku. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Chaymi achka runakuna noqamandaqa rinllapa akrakaq. Kanan paykunapura ch'iqninakushpam, kuntrangunaman rinllapa intriganakuq. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Achka llullakuqkuna shamushpam, rinllapa niq: “Noqam Dyuspaq rimaq kani. (Paypaqmi yach'achikuni)” nishpa. Chayshinam achka runata warmita rinllapa ingañaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Chay runakuna, warmikuna ancha maluyashpam, manana rinllapachu llakipaq runa masingunataqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Piru noqapi mana shaykuq yuyakuptikiqam, suq bidapi rini washashuq. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kanan noqapi yuyakuqkunam shumaq nutisyayta tukuy mundupi ringillapa yach'achikuq: Jisukristum shumaqta rin kamachiwaqninchiq, nishpa, yumbay nasyungunapi noqapaq yach'ananllapa. Chaymandaraqmi rin ushyakaq kay munduqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Dyuspaq rimaq Dañilmi (unay tyimpupi) librumbi kayshina iskibrirqan: “Suq millanaypaq dañachikuqmi rin yaykuq Tayta Dyuspa adurana wasinman”, nishpa. Chayri qamkuna yach'ashpa: Chay millanaypaq dañachikuqmi chay santu lugarman yaykushqa, nishpaqa, intyindiyllapa: Chay unay Dañil iskibrishqanqam kumpliykanna, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Chayta yach'ashpaqa, kay prubinsya Judiyapi kaqkunaqa qaqakunaman mitikanqallapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kanan wasimba sawambi kaqkunapisri ishkishpa, ama yaykunqallapachu wasinman, imangunata surqonambaqqa. Ashwanri chayshinalla das mitikanqallapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ch'akrapi kaqkunapis ama wasinman kutinqallapachu, ni mudananda apananllapaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Imananqallaparaq chay pach'ayuq (ukuyuq) warmikuna, chay iti wambrituyuqkunaqa! ");
INSERT INTO qvcNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Chayri Dyusman mañakuyllapa, ama mitikanaykillapa tamya tyimpupi, ni samana diyapi. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Chay mitikanayki tyimpupiqam yumbay runakuna, warmikuna ancha rinllapa ñakaq maski yumbay ñakaykunamanda. Chaqa kay mundu qallarishqan diyamandapacham mana nunka ñakashqallapachu chay mitikanan tyimpupishinaqa. Chay ñakana tyimpu ushyakaptinmi, manana nunka rinllapachu ñakaq chay tyimpupishinaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Piru Dyusqam akrashqan wambrangunata llakipashpa, chay ñakana diyakunata das rin pasachiq, paypi kriyiqkuna ama achka diyakunata padisinanllapa. Chaqa chayshina mana pasachiptinqach'i, mana pipis atinmanchu kawsaytaqa. Yumbay runa, warmi wañunmanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Chayri mayqan runa qamkunata nishuptin: “¡Rikayllapa, kaypim Dyus Akrashqan Washadurqa!” ichu nishuptin: “Kay waqpim payqa”, nishpaqa, ama kriyiyllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Chaqa achka llullakuqkuna shamushpam rin niq: “Noqam Dyus Akrashqan Washadur kani”, nishpa, ichu “Noqam Dyuspaq rimaq kani”, nishpa. Paykunam ispantaypaq milagrukunata, siñakunata rinllapa ruraq. Chayshina rurashpam, achka runata, warmita rinllapa ingañaq. Atishpaqach'i, asta Dyuspa akrashqan wambrangunatapis ingañanmanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kaykish manaraq chaykuna pasaptin, nishushqallapana kani (ama pipis ingañashunanllapa). ");
INSERT INTO qvcNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Chayri nishuptinllapa: “Waq chunchapim Washadurninchiqqa”, nishpaqa, ama riyllapachu; ichu “Kay uku wasipim”, nishuptinllapapis, ama kriyiyllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Chaqa noqa Dyusmanda Shamuq Runam rini kutimuq llipyaq rrilampagushina. Manchu rrilampaguqa tukuy syilupi lliwyan kay ladumanda suq ladukaman. Chayshinallam noqapis yumbay ladukunapi lliwyashpa, rini kutimuq. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Chaqa maypi suq wañushqa kaptinqam, shingukuna tandakanllapa. Nuta: Chay shingukunata karumanda rikashpam yach'anchiq, imam wañushqa, nishpa. Chayshinallam chay diya Jisukristu shamuriptinqa, karumanda yumbay rinllapa rikaq.  ");
INSERT INTO qvcNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Chay ñakaykuna pasaptinllam, rupaywan killa wañushpa, manana rinchu achikchakuq. Lusirukunapismi syilumanda rinllapa ishkimuq. Syilupi tukuy ima kaqkunapismi rin kuyuq. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Chaymandaqam yumbayna rinllapa rikaq syilupi suq siñata. Chaymi rinllapa yach'aq: Dyusmanda Shamuq Runa Jisukristum kutimuykanna, nishpa. Chay siñata rikashpaqam, tukuy mundupi ancha manchashpa, rinllapa waqaq. Chaypinam rinllapa rikawaq, syilumanda pukutaypa sawambi, ancha pudirniyuq llipyashpa shamuykaqta. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Anjilniykunatam rini kach'aq kay pachapa yumbay kuchungunaman, paykuna kurnitata waqachishpa, akrashqaykunata tandananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Kay kumparasyunda allita yach'akuyllapa: Qamkunaqam suq yura igusta pallpamuykaqta rikashpaqa, yach'angillapana: Biranunam rin kaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Chayshinallar yumbay kay nishushqayllapa qallariptinqa, yach'ayllapa: Chay willawashqanchiqmi rinna kumpliq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Alliptam niykillapa, kay tyimpupi kawsaqkuna manaraq wañuptinmi, kay nishushqaykunaqa rin kumpliq. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Chaqa syiluwan kay pacham rin ushyakaq. Piru kay nishushqaykunaqam mana nunka rinchu ushyakaq. Ashwanmi yumbay rin kumpliq. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Piru manam pipis noqapaqqa yach'anchu: ¿Ima diyata, ima urastam rin kutimuq? nishpaqa. Manam ni anjilkuna ni noqa Dyuspa Churimbis yach'anillapachu. Tayta Dyusllam chaytaqa yach'an. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nuwipa tyimpumbi kashqanshinam, kutimunay tyimpupis rin kaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Chaqa chay Nuwipa tyimpumbiqam runakunaqa mikuykarqan, upyaykarqan, kasaraykarqan, wambrangunata kasarachiykarqan, chay Nuwi wambuq wasiman yaykushqan diyakaman. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Manam intyindirqanllapachu: Ancha tamyaptinmi, yakukunapi yumbay ch'uqashpa rinchiqllapa ushyakaq, nishpaqa. Chayshinallam noqa Dyusmanda Shamuq Runa kutimuptiy, mana rinllapachu yach'aq: Kay diyapim Jisukristu rin kutimuq, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ishkay runa ch'akrapi kaykaptinmi, suqta apashaq, suqta dijashaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Chayshinallam ishkay warmi kutakuykaptimbis, suqta apashaq, suqta dijashaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Chaqa manam yach'angillapachu: ¿Imurasmi Jisukristuqa rin kutimuq? nishpaqa. Chayrayku chayta yuyashpa, allita kwidakashpa, listu kayllapa kutimunaypaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Kaytapis allita yach'ayllapa, suq runa yach'ashpa, ima urasmi ladrunqa rin shamuq, nishpaqach'i, wasindaqa ancha allita kwidanman, ama yaykunambaq suwaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Chayshina qamkunapis tukuy tyimpu listu kayllapa. Chaqa noqaqam mana yuyashqaykillapa uraspi rini kutimuq. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Noqata allita shuyawaqkunaqam allin yach'ayniyuq kumplidu kriyadushina. Chaqa chay allin kriyadupa patrunninqam paypa makimbi dijan wasinda: “Kay kriyadu masikikunatar allita kwidashpa, urasnimbi qaray”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Chaymi chay wasi kwidaq kriyaduqa ancha rin kushikuq, chay patrunnin kutimushpa, kamachishqanshina ruraykaqta tariptin. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Alliptam niykillapa, chay patrunninqam chay allin kriyadunda mas kamachikuqta numbrashpa, tukuy imangunata paypa kwintan rin dijaq, payna kwidanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Piru amakish chay kriyaduqa yuyanqachu: Manaraqmi patrunniyqa rinchu kutimuq, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Chaqa chayshina yuyashpa maluyashpaqam, kriyadu masingunata maqashpa, mach'aqkunawan unda unda mikushpa, upyaptinqam, ");
INSERT INTO qvcNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","patrunninqa mana yuyashqan uraspi shamushpa, ");
INSERT INTO qvcNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ancha fiyuta rin kastigaq. Chaymandaqam paytaqa rin wichukuq chay shiminwanlla Dyusta kasuqkunapa kashqanman, chaypi paykunawan pulla padisinambaq. Chaypim waqashpa, kirungunata rin qech'yachiq. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Suq bidapi Dyusman ch'ayananchiqqam, kay dyis dunsillakuna kasamyintu fyistaman riqkunashina rin kaq. Chaqa chay dyis dunsillakunaqam michangunata piskashpa, rirqanllapa kasamyintu fyistaman, suq dunsilla masimba namuradunda shuyaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Paykunamandam sinku chinakuna ancha yach'ayniyuq, jwisyusakuna karqan. Sinkuqam dijada mana yach'ayniyuqkuna karqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Chay dijadakunaqam michangunatalla aparqan. Manam lamparamba mas asiytindaqa aparqanllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Piru chay yach'ayniyuq dunsillakunaqam butillangunapi asiytinllapata aparqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Chaymandaqam chay kasaraq runa unayaptin ch'ayamuqqa, chay dunsillakunaqa shuyashqanshina, yumbayninna puñurqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","’Chaymandaqam ch'awpi tutata uyarqanllapa kayshina qayakuqta: “¡Kasaraq runaqam shamuykanna! ¡Lluqshiyllapa tinguq!” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Chaymi yumbay chay dunsillakunaqa utqaymaya atarishpa, michanllapata allicharqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Piru dijadakunaqam jwisyusakunata nirqan: “¡Michayllapam wañuykanna! ¡Ashlita asiytikitar qowayllapa!” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Chaymi chay jwisyusa dunsillakunaqa chay dijadakunata kayshina nirqan: “Ama pullata faltawananchiq, riyllapa randimuy”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Piru chay dijadakuna rinangamanllapa asiytita randimuqqam, ch'ayamurqanna chay kasaraq runaqa. Chaymi chay sinku dunsilla lista kaqkunaqa wasimanna yaykurqanllapa, dunsilla masinda kushichiq. Chayshina ukupina kaptinllapaqam, pungutaqa kirparqanna. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Chaymandaqam chay dijada dunsillakunapis ch'ayamushpaqa, qayakurqanllapa: “Taytitu, Taytitu, punguykitar kich'ay yaykunayllapa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Piru chay kasaraqqam paykunataqa nirqan: “¿Pich'i kangillapa? Alliptam niykillapa, manam riqsiykillapachu”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Chayta nishpaqam, Jisusqa nirqan: —Chayshinar qamkunapis allita rurashpa shuyawayllapa. Chaqa manam yach'angillapachu: Ima diya, ima urasmi Jisukristuqa rin shamuq, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Suq bidapi Dyuswan kawsananchiqqam suq qellayniyuq runashina rin kaq. Chaqa chay runaqam karu nasyunman rinambaq, kriyadungunata qayashpa, qellayninda mingarqan trabajachishpa ganachinanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Suq kriyadundam 5.000 qellayta mingarqan. Suq kriyadundaqam 2.000 qellayta mingarqan. Suq kriyadundaqam 1.000 qellayta mingarqan. Nuta: Kada qellaymi ancha baliq. Chaqa suq trabajadurmi masdi 15 watakunata trabajaq, mil qellayta gananambaqqa.  Chayshina mingashpaqam, rirqanna karu llaqtaman. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Chaymi chay 5.000 qellayta ch'askiqqa, nigusyukunata rurashpa, ganachirqan 5.000 masta. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Chay 2.000 qellayta ch'askiqpismi, 2.000 masta ganachirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Piru chay 1.000 qellayta ch'askiqqam suqkunamanda akrakashpa, allpapi ush'kukushpa, patrunnimba qellaynindaqa pambarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Chaymandaqam achka tyimpumanda chay kriyadukunapa patrunninqa kutimurqanna. Chaymi qellaynimba wach'aynimbaq chay kriyadungunata kwintata mañarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Chay 5.000 qellayta ch'askiq kriyadunqam 5.000 masta apamushpa patrunnindaqa nirqan: “Patrunsitu, 5.000 qellaytam qowarqayki. Piru 5.000 mastam ganachishqa kani”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Chaymi patrunninqa paytaqa nirqan: “Allin kumplidu kriyaditu, allitam noqapaq trabajachishqa kangi chay ashla qellayniy mingashushqayta. Chaymi ancha achka imaykunata qamta rini mingashuq, qamna rikanayki. Chayri allin lugarniyman yaykuy, kushikunanchiq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","’Chay 2.000 qellayta ch'askiqpismi nirqan: “Patrunsitu, 2.000 qellaytam qowarqayki. Piru 2.000 mastam ganachishqa kani”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Chaymi chay patrunninqa nirqan: “Allin kumplidu kriyaditu, qambismi allita noqapaq trabajachishqa kangi chay ashla qellayniy mingashushqayta. Chaymi achka imaykunata qamta rini mingashuq, qamna rikanayki. Chayri qambis allin lugarniyman yaykuy kushikunanchiq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","’Piru chay 1.000 qellayta ch'askiq kriyadunmi ch'ayashpaqa nirqan: “Patrunsitu, noqaqam riqsishurqaq wapu kashqaykita. Chaqa suqkuna tarpushqangunatam qamna kusichangi. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Chaymi manchashushpa, chay 1.000 qellay qowashqaykita allpapi ush'kukushpa pambashpa, pakashqa kani. Kaypi qellayniki”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Chaymi chay patrunninqa nirqan: “¡A, malu, qella kriyadu! Qamqam yach'arqayki suqpa tarpudunda kusichashqayta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Chayshina waqaychashqayki kwintamandaqa, chay qellayniytaqa bankuman ruranaykita, kutimushpa ganansyayuqta surqonaypaq”. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Chayshina nishpaqam, chaypi kaqkunata kayshina kamachirqan: “Chay 1.000 qellay qoshqayta qoch'ishpa, chay 10.000 qellayniyuqta qoyllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Chaqa chay imayuqtaqam masta rini qoq (allita kasuwashqanrayku). Chaymi mas imayuqna rin kaq. Piru chay ashlita kaqniyuqtaqam limpu rini qoch'iq (mana allita kasuwashqanrayku). ");
INSERT INTO qvcNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Chayri chay malu kriyadutaqa sawa tutayaqman wichukuyllapa, chaypi padisishpa, waqashpa, kirungunata qech'yachinambaq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jisukristuqam kayshinapis nirqan: —Yumbay anjilniykunawanmi noqa Dyusmanda Shamuq Runa ancha kamachikuq gubyirnu shamushpa, llipyaq trunuypi rini tiyaq kamachikunaypaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Yumbay nasyungunamandam runakuna, warmikuna ñawpayman rinllapa tandakaq. Manchu michidurqa wishangunata akran chibukunamanda. Chayshinallam noqapis rini akraq noqata kuyawaqkunata chay mana kuyawaqkunamanda. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Chaqa chay kuyawaqkunaqam wishaykuna. Chaymi paykunata allin laduypi rini ruraq. Chay mana kuyawaqkunaqam chay chibukunashina. Chaymi paykunataqa ichuq laduypi rini ruraq. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Chaymandaqam allin laduypi kaqkunataqa rini niq: “Tayta Dyusmi qamkunata ancha yanapashushqa. Chayri noqaman shamuyllapa. Chaqa kay munduta rurashqan diyamandapacham Tayta Dyusqa anaq syilupi ancha shumaq lugarta rurashqa, qamkuna waqpi tiyanaykillapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Chaqa mallaqnaptiymi, qamkuna qarawarqayki. Yakunaptiymi, yakuta qowarqayki. Furastiru kaptiymi, pusadata qowarqayki. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Mana mudanayuq kaptiymi, qamkuna mudanata qowarqayki. Qeshyaq kaptiymi, shamurqaykillapa watukuwaq. Karsilpi kaptiypismi, rirqaykillapa kunswilawaq”. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Chayshina niptiymi, chay kuyawaqkunaqa rin niwaq: “Taytitu, ¿ima tyimputaq mallaqta rikashushpa, qarashurqaqllapa, yakunaqta rikashushpa, qoshurqaqllapaqa? ");
INSERT INTO qvcNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Ima tyimputaq furastiru kaptiki, pusadata qoshurqaqllapa, mana mudanayuq kaptiki, mudanata qoshurqaqllapa? ");
INSERT INTO qvcNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Ima tyimputaq qeshyaq kaptiki, karsilpi kaptiki, rirqayllapa watukushuqqa?” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Chayshina tapuwaptinllapam, noqaqa paykunata rini niq: “Alliptam niykillapa, chay mana imayuqkunata yanapashpaqam, alabis noqata yanapawashqa kangi”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Chaymandaqam ichuq laduypi kaqkunatana rini niq: “¡Ashuyllapa laduymanda qamkuna malditu kundinadukuna! Riyllapa chay tukuy tyimpu lumyaykaq ninaman. Chay infyirnutaqam Taytanchiq Dyus rurashqa, dyablu tukuy yanapakuqnin dyablukunawan rupanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Chaqa mallaqnaptiymi, qamkunaqa mana qarawarqaykichu; yakunaptiypismi, mana qowarqaykichu. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Furastiru kaptiypismi, mana pusadata qowarqaykichu. Mudanay faltawaptimbismi, mana nimatapis qowarqaykichu. Qeshyaq kaptiy, karsilpi kaptiypismi, mana rirqaykillapachu watukuwaqqa”. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Chayshina niptiyqam, paykunaqa rin tapuwaqllapa: “Taytitu, mallaq kaptiki, yakunaptiki, furastiru kaptiki, mana mudanayuq kaptiki, qeshyaq kaptiki, karsilpi kaptikiqam, mana rikashushqachu kanillapa yanapashunayqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Chayshina niwaptinllapaqam, paykunata nishaq: “Alliptam niykillapa, chay pubrikunata mana yanapashpaqam, alabis noqata disprisyawashqa kangi”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Chayta nishpaqam, Jisusqa nirqambis: —Paykunaqam rinllapa riq chay mana ushyakaq kastiguman. Piru allingunaqam rinllapa riq luryaman, tukuy tyimpu kawsananllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisusmi chaykunata yach'achikushpaqa, noqaykuna yach'akuqningunata niwarqanllapa: ");
INSERT INTO qvcNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Qamkunaqam yach'angillapa: Ishkay diyallanam faltan Paskwa fyista qallarinanqa, nishpa. Chay fyistapim noqa Dyusmanda Shamuq Runataqa kuntrawaqkunaman rinllapa intrigakuwaq, kruspi klabawananllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Alliptam chay diyakunapi kamachikuq isrraylinu kurakuna, Muysispa liyningunata yach'achikuqkuna, kamachikuq ansyanukunawan tandakarqanllapa chay mas kamachikuq isrraylinu kurapa atun wasimba patyumbi. Chay kuraqam Kayfas shutirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yumbay chay kamachikuqkunam kayshina parlarqanllapa: —¿Imashinaraq Jisusta ingañashpa dimandanchiqman, prisushpa wanchinanchiqllapa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Chaymandaqam nirqanllapa: —Kay fyistapiqam mana balinchu wanchinanchiqqa. Chaqa kay fyistapi kaqkunakish kuntranchiq alsakanmanllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jisusmi noqaykuna yach'akuqningunawan Bitanilla (Bitaniya) llaqtapi kashpa, rirqayllapa suq runa Simun shutiqpa wasinman. Chay Simunmi unayqa ismuykaq kwirpuyuq kashqa karqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Paypa wasimbi kaykaptiyllapam, suq warmi ch'ayarqan kirpadu rumi pumupi ancha ch'aniyuq mishki mutkinata apamushpa. Mesapi kaykaptiyllapam, chay warmiqa chay mishki mutkinawan Jisuspa umanda nuyuchirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Chayta rikashpam, noqaykunaqa piñakushpa, nirqayllapa: —¿Imapaqtaq qesachaykan chay ch'aniyuq mishki mutkinataqa? ");
INSERT INTO qvcNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Chaytaqash' achka qellaypaq randikushpa, chay mana nimayuqkunata yanapananchiqta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Chaymi Jisus chayta uyashpaqa, kayshina niwarqanllapa: —¿Imapaqmi kay warmitaqa piñachingillapa? Payqam ancha allita rurawashqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Chaqa pubrikunaqam qamkunapa pullaykillapa tukuy tyimpu rinllapa kaq. Piru noqaqam manana tukuy tyimpuchu pullaykillapaqa rini kaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kayshina mishki mutkinata sawayman basyashpaqam, allichawashqashina, wañuptiy pambawananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Chaymi allipta niykillapa, tukuy kay mundupi noqapa shumaq nutisyayta yach'achikushpaqam, kay warmi allita rurawashqandapis rinllapa yach'achikuq, payta ama qonqananllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Chaymandaqam yach'akuq masiy Judas Iskaryutiqa kamachikuq isrraylinu kurakunaman rirqan kayshina niq: ");
INSERT INTO qvcNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","—¿Aykatam qamkunaqa pagarawangiman, Jisusta intriganaqqa? nishpa. Chaymi chay kamachikuq kurakunaqa 30 yuraq qellayta pagararqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Chay urasmandapacham Judasqa yuyarqan: ¿Maypitaq, imashinataq Jisusta intrigakuni? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Chay Paskwa fyistapiqam suq laya mikunakunata, kachangakunata noqaykuna isrraylinukunaqa mikunillapa. Chay fyista qallarishqan diyam wakin yach'akuq masiykunaqa Jisusta tapurqanllapa: —Kay Paskwa fyista mikunata mikunanchiqqa, ¿maypitaq munangi allichanayllapa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Chaymi Jisusqa paykunataqa nirqan: —Rishpa Jirusalinmanqa, riyllapa chay riqsishqanchiq runaman. Payta niyllapa: “Yach'achikuq Taytitum nin: Ch'ayamushqanam uras. Wasikipim munani rurayta Paskwa fyistata yach'akuqniykunawan”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Chay nishqanshina rurashpam, Paskwa mikunata allicharqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tutayaptinnaqam, Jisusqa noqaykuna dusi yach'akuqningunawan mesapina karqayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Chaypi mikuqshinam niwarqanllapa: —Alliptam niykillapa, suqnikim ringi intrigakuwaq kuntrawaqkunaman, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Chaymi yumbay noqaykuna limpu malaganayashpa, suqniy suqniy kayshina tapurqayllapa: —Taytitu, ¿noqachu kani? nishpallapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Chaymi Jisusqa niwarqanllapa: —Noqawan suq platupilla pullay mikuqmi rin intrigakuwaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Chaqa Dyuspa Santu Librun nishqanshinam noqa Dyusmanda Shamuq Runaqa rini wañuq. Lukis ¡imananqaraqri chay intrigakuwaqqa! Mas allich'i kananda chay runaqa ama nasinambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Chaymi chay intrigakuq Judasqa Jisusta nirqan: —Yach'achikuq Taytitu, ¿noqachu kani? nishpa. Chaymi Jisusqa nirqan: —Arí, nishqaykishinam qam kangi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Chaypi mikuqshinam Jisusqa kachangata piskashpa, Dyusman pagikurqan. Chaymandaqam pitishpa, noqaykuna yach'akuqningunata niwarqanllapa: —Kay kachangata ch'askiwashpa, mikuyllapa. Kaymi kwirpuy, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Chaymandaqam kupatapis piskashpa, Dyusman pagikushpa, noqaykunata niwarqanllapa: —Kay kupamanda yumbayniki upyayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Chaqa kaymi yawarniy, Dyuswan mushuq tratuta ruranaypaqqa. Yawarniyta ich'aptinllapam rini wañuq, achka runata, warmita uchangunamanda washanaypaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Piru niykillapam, kay binutaqam manana mastaqa rinichu upyaq kay mundupiqa, Taytay tiyashqambi qamkunawan mushuq binuta upyanaykaman, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Suq imnuta kantashpaqam, noqaykunaqa chay kashqaymanda lluqshishpa, rirqayllapana Ulibu lumaman. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Riqshinaqam Jisusqa kayshina niwarqanllapa: —Kay tutaqam yumbayniki noqapi manana yuyakushpa, noqamanda akrakashpa, shikwa shikwana ringillapa riq. Chaqa Tayta Dyuspa Santu Librumbim nin: “Michidurta chuqriptiyqam, wishangunaqa waqta kayta shikwakanqallapa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Piru wañushqaymanda kawsamushpam, qamkunamanda mas puntata rini riq prubinsya Galiliyaman, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Chayshina Jisus niptinqam, Pidruqa nirqan: —Qambi manana pipis yuyakuptimbismi, noqaqa qambilla rini yuyakuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Chaymi Jisusqa nirqan: —Alliptam niyki, kay tuta gallu manaraq kantaptinmi, kimsa kutinda ringi ñigawaq: “Manam riqsinichu Jisustaqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Chaymi Pidruqa nirirqan: —Pullayki imapis wañushaq. Manamir ñigashqaykichu, nishpa. Chayshinallam nirqayllapa noqaykuna chay suq yach'akuqningunapis. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jisusqam noqaykuna yach'akuqningunawan Jitsimani shutiq lugarman rirqanillapa. Chayman ch'ayashpaqam, Jisusqa niwarqanllapa: —Kaypi tiyayllapa, noqa kay waqman rinaykaman Dyusman mañakuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Chayshina nishpaqam, Pidruta, Sibidiyupa chay ishkay churingunata ashla waqkaq apashpa, Jisusqa suq layayashpa, ancha malaganayarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Chaymi paykunata nirqan: —Ancha jwirtitam llaki piskawan. Limpuraq shunqoy tutayan. Tukuy kay llakikunam munan wanchiwayta. Kaypi kidashpa, ama puñushpachu, yapachawayllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Chaymi ashla waqkaq rishpa, qonqorikushpa, ancha kumurashpa qaqllan allpaman ch'ayachishtin, Dyusman mañakushpa, nirqan: —Taytitu, kay tukuy ñakaykunaqam noqapaqqa suq kupa ancha ayaq yakushina. Munashpaqar chay ñakaykunamanda washaway. Piru amar noqa munashqayqa kanqachu. Ashwanri qam munashqaykishina kanqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Chayshina Dyusman mañakushpa, kutimushpaqam, chay kimsa yach'akuq masiyllapata puñuykaqta tarishpa, Pidruta nirqan: —¿Ima manachu atishqallapa kangi agwantayta puñuymandaqa ni suq uritata? ");
INSERT INTO qvcNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Rikch'akashpa, Dyusman mañakuyllapa, ama tyintadu kanaykillapa. Chaqa qamkunaqam allipta munangillapa Dyusta kasuyta. Piru manam atingillapachu kwirpuykita sujitayta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Chaymandaqam Jisusqa suq kutinda waqkaq ririshpa, Dyusman kayshina mañakurirqan: —Taytitu, illuki ñakanaypaq kaptinqa, qam munashqaykishina kanqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Chaymi shamurishpaqa, puñuykaqta taririrqan chay kimsa yach'akuq masiykunataqa. Chaqa paykunataqam puñuyqa ancha binsiykarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Chaymandaqam chaypilla paykunata dijashpa, mushuqmanda chay waqkaq ririrqan, Tayta Dyusman mañakuriq. Chay kimsa kutindam chayshina nishpalla, mañakurqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Chaymandaqam chay kimsa kutinda kutimushpaqa, chay yach'akuq masiykunataqa nirqan: —¿Sigingillapachu puñushpa? Kananqam ch'ayamushqa chay uras noqa Dyusmanda Shamuq Runata intrigakuwanan uchayuq runakunaman. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Atariyllapa. Akuna. Rikayllapa, chay intrigakuwaqqam ch'ayamuykanna, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Chayshina rimaykaptinllam, chay yach'akuq masiy Judasqa achka runakunawan ch'ayamurqan. Chay runakunaqam qeruta, atun kuchilluta piskashpa, shamurqanllapa chay kamachikuq isrraylinu kurakuna, chay kamachikuq ansyanukuna kach'amuptin. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Chay Judas intrigakuqqam paykunataqa nishqa karqan: —Jisusta riqsinaykillapaqam, muchashpa rini napaykuq. Chaytam piskangillapaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Chaymi ch'ayashpaqa, Jisustaqa muchashpa napaykurqan: —Bwinas nuchis, Yach'achikuq Taytitu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jisusqam nirqan: —Yanasita (Yanasitu), ¿imapaqtaq shamushqa kangi? nishpa. Chay uritaslla chay runakunaqa Jisusta piskarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Piru Jisuspa suq yach'akuqninmi atun kuchillunda surqoshpa, mas kamachikuq isrraylinu kurapa kriyadumba rinrinda pitirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Chaymi Jisusqa nirqan: —Atun kuchilluykitaqa waqaychayna. Chaqa kuchilluwan pilyaqkunataqam, kuchilluwan rinllapa wanchiq. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Ima manachu yach'angi, noqa Taytay Dyusman mañakuptiyqam, kach'amunman mas di 70.000 anjilningunata washawanambaq, nishpaqa? ");
INSERT INTO qvcNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Lukis chayshina kach'amunambaq mañaptiyqach'i, Dyuspa Santu Librumbi noqapaq nishqanqa mana kumplinqachu. Chaqa librumbiqam kayshina pasawanambaq riman, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Chaymandaqam Jisusqa chay shamuq runakunata nirqan: —Qamkunaqa, ¿imaraykutaq shamushqallapa kangi atun kuchillukunawan, qerukunawan, saltiyadurtashina prisuwaqqa? Manchu tukuy diya Tayta Dyuspa adurana wasimbi qamkunawan kashpa, yach'achikushqa kani. ¿Imaraykutaq qamkunaqa chaypiqa mana prisuwarqaykichu? ");
INSERT INTO qvcNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Piru tukuy kaykunam kayshina pasaykan, Dyuspaq rimaqkuna iskibrishqanguna kumplinambaq, nishpa. Chay urasmi noqaykuna yumbay yach'akuqningunaqa Jisusta sapalitanda dijashpana, mitikarqayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Chay prisuqkunaqam Jisustaqa chay mas kamachikuq isrraylinu kura Kayfaspa wasinman aparqanllapa. Chaypim karqanllapa Muysispa liyningunata yach'achikuqkuna, kamachikuq ansyanukunapis. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piru Pidruqam Jisuspa karu ikinda rirqan chay Kayfaspa wasimba patyungaman. Chaypiqam suldadukunawan tiyarqan, rikanambaq imanachiqshi rin Jisustaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Chay kamachikuq isrraylinu kurakuna, chay kamachikuq ansyanukuna, yumbay chay Mas Kamachikuq Tandakaq Juyiskunapismi tistigukunata maskarqanllapa, llullakushpa, Jisuspa kuntran rimananllapa, chaypaq tumbanna wanchinanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Piru maychika suqnin suqnin yanqakunata llullakushpa, mana igwalta rimaptinllapaqam, mana nimapaq atirqanllapachu tumbayta Jisusta, wanchinanllapaqa. Piru ultimupim ishkay llullakuqkuna ñawpanllapaman pasashpa, ");
INSERT INTO qvcNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","nirqanllapa: —Kay runam nishqa: “Dyuspa chay atun adurana wasinda bulashpam, atini kimsa diyapi mushuqmanda rurariyta”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Chaymi chay mas kamachikuq isrraylinu kuraqa atarishpa, Jisusta tapurqan: —¿Manachu nimatapis ningi? ¿Manachu uyangi kay runakuna qambaq rimashqandaqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Piru kuntraptinllapaqam, Jisusqa uyararqanlla. Manam nimatapis nirqanchu. Chaymi chay mas kamachikuq kuraqa nirqan: —Mayá, kamachiykim juranayki Dyuspa shutimbi, ¿Qamchu Dyuspa Churin kangi? ¿Qamchu Dyus Akrashqan Washadurqa kangi ichu mana? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Chaymi Jisusqa nirqan: —Qam nishqaykishinam kani. Niykillapapismi, kananmandaqam noqa Dyusmanda Shamuq Runata ringillapa rikawaq, ancha pudirniyuq Tayta Dyuspa allin ladumbi tiyaykaqta. Ringillapam rikawaqpis pukutaykunapi syilumanda shamuykaqta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Chayshina Jisus niptinmi, chay mas kamachikuq isrraylinu kuraqa ancha piñakushpa, kwirpumbi kaq mudananda llikishpa, chay juyiskunata nirqan: —¡Ichichín, kay runaqam Taytanchiq Dyusta burlaykan! Kananqam manana munanchiqchu tistigukunataqa, ¿manachu? Waqqar kananqa qamkuna kikiki uyashqallapa kangi, kayshina rimashpa Dyusta burlaptinqa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Chaymandaqam chay juyiskunata tapurqan: —¿Imatataq yuyangillapa? nishpa. Chaymi paykunaqa nirqanllapa: —Arí, uchayuqmi. Allim wañunambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Chay urasmi qaqllambi tuqapashpa, wakinqa puñitiyarqanllapa, wakinqam qaqllambi paqyachishpa, nirqanllapa: ");
INSERT INTO qvcNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","—Mayá, qam Dyus Akrashqan Washadur kashpaqa, niwayllapa: ¿Pitaq maqashushqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pidru chay wasipa patyumbi tiyaykaptinmi, suq kriyada qemikashpa nirqan: —Qambismi Jisus Galiliyamanda kaqwan purirqayki, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Piru Pidruqam yumbay chaypi kaqkunapa ñawpambi ñigashpa nirqan: —Manam yach'anichu imatach'i niwaykangi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Chaymandaqam chay patyumanda sawa punguman lluqshiptin, suq kriyadapis Pidruta rikashpa, chaypi kaqkunata nirqan: —Kay runapismi Jisus Nasaritmanda kaqwan puriq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piru payqam kayshina jurashpa, ñigarirqan: —Pur Dyusitu, manam riqsinichu chay runataqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Chaymandaqam suq rratitumandalla, chaypi kaqkuna qemikashpa, Pidruta nirqan: —Allibraq qambis paykunamanda suqnin kangi. Chaqa qamqam chay Galiliyamanda kaqkunashina rimangi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Chayshina niptinllapam, Pidruqa masta jurashpa, nirqan: —¡Pur Dyusitu, allipta niykillapa, manamir chay runataqa riqsinichu! nishpa. Chay urasmi suq gallu kantarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Chaymi Pidruqa yuyarqan Jisus kayshina nishqanda: “Manaraq gallu kantaptinmi, kimsa kutinda ringi ñigawaq”, nishpa. Chaymi payqa ancha syintishpa, sawaman lluqshishpa, ancha waqarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nuta: Chay tyimpukunapim Rruma llaqtamanda kaqkuna achka nasyungunapi kamachikuqllapa. Chaymi isrraylinukunatapis suq rrumanu gubyirnu kamachiq. Chay gubyirnuqam shutiq Pilatu.  Achikyaptinnam isrraylinukunapa yumbay kamachikuq kuranguna, kamachikuq ansyanukunawan tandakarqanllapa parlanambaq, Jisusta wanchinanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Chaymandaqam Jisusta grillitashpa, aparqanllapa gubyirnu Punsyu Pilatuta intrigaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Chay intrigakuq Judasqam rikashpa Jisusta sintinsyadu wanchinanllapa kaptinqa, ancha syintirqan intrigakushqambaq. Chaymi rirqan kamachikuq isrraylinu kurakunata, kamachikuq ansyanukunata chay 30 yuraq qellay ch'askishqanda kutichiq. Chaymi nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","—Uchatam rurashqa kani, suq mana nima uchayuq runata intrigakushpa wanchinaykillapa, nishpa. Piru chay isrraylinu kurakunaqam Judastaqa nirqanllapa: —¿Ima kwintayuqtaq noqaykunaqa kani? Chayqam qamba kwintayki, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Chayshina niptinqam, Judasqa uku Dyuspa adurana wasimbi chay qellayta wichukurqan. Chaymandaqam suq lugarman rishpa, urkakashpa wañurqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Chay kamachikuq isrraylinu kurakunaqam chay qellayta tandashpa, kayshina parlarqanllapa: —Kay qellaypaqmi suq runata intrigakurqan, payta wanchinanchiqllapa. Chaymi liyninchiq mana dijawanchiqchu wichunanchiq ufrindanchiqpa kajunninmanqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Chayshina parlashpallapaqam, kayshina yuyarqanllapa: Chay qellaywanqa randishunllapa chay manga ruraqpa ch'akranda, pantyun kanambaq, furastirukuna wañuptin, chaypi pambananchiqllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Chaymi chay ch'akraqa kanan diyakaman shutin “Yawar Pamba”. Chaqa chay ch'akrataqam Jisuspa prisyunwan randirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Chayshinam kumplirqan Dyuspaq rimaq Jirimiyas kayshina nishqan: “Chay isrraylinukunam suq runapaq pagarashqanllapa prisyunda paykunalla tandarqanllapa. Chay 30 qellaykunawanmi randirqanllapa mangata ruraq runapa ch'akranda, Kamachikuqniy niwashqanshina”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Gubyirnu Pilatuman Jisusta apaptinllapa, paypa ñawpambi shayaykaptinmi, chay Pilatuqa kayshina tapurqan: —¿Qamchu isrraylinukunapa gubyirnunqa kangi? nishpa. Chaymi Jisusqa nirqan: —Arí, chay nishqaykishinam kani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kanan chay kamachikuq kurakuna, chay kamachikuq ansyanukuna kuntrashpa kusasta niptimbismi, Jisusqa mana nimatapis nirqanchu. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Chaymi Pilatuqa Jisusta nirqan: —¿Manachu uyangi kuntrashushpa, malutash rurashqa kangi, niptinllapaqa? ");
INSERT INTO qvcNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Chayshina niptimbismi, Jisusqa mana ni suq palabrata rimarqanchu. Chaymi uyaraqtalla rikashpaqa, chay gubyirnuqa ancha ispantarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Chay Paskwa fyistapim gubyirnuqa watan watan suq prisuta kach'aq, runakuna rrugakuptin. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Chay tyimpupim suq runa Barrabas shutiq karsilpi karqan. Paypaqqam yumbay isrraylinukuna ancha allita yach'arqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kanan chay achka runakuna tandakashqandam Pilatuqa kayshina tapurqan: —¿Pitam munangillapa kach'anaypaq? ¿Barrabasta ichu kay Jisus Dyus Akrashqan Washadur shutiqta? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Chaqa Pilatuqam intyindishqa karqan: Paykuna imbidyashpam, kay Jisustaqa intrigawashqallapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Chayshina Pilatu trunumbi tiyaykaptinmi, paypa warminqa suq rrikaduta kayshina kach'akurqan: —Chay allin runamanqa ama mitikuychu. Chaqa tutam ancha llakita paypaq musqoshqa kani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Piru chay kamachikuq isrraylinu kurakuna, chay ansyanukunawanqam chay achka runata kunashpa, animachishpa, kayshina kunarqanllapa: —Pilatutaqa mañayllapa Barrabasta kach'ashpa, Jisusta wanchinan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Chaymi chayshina niptinllapaqa, chay gubyirnu Pilatuqa paykunata tapurirqan: —Kay ishkay prisukunamanda, ¿mayqannindataq munangillapa kach'anaypaqqa? nishpa. Paykunaqam nirqanllapa: —¡Barrabasta kach'ay! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Chaymi Pilatuqa tapurirqan: —Chayshinaqa, ¿imanachishaqtaq kay Jisus Dyus Akrashqan Washadur shutiqtaqa? nishpa. Chaymi yumbaynin nirqanllapa: —¡Kruspi klabay! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Chayshina niptinllapaqam, Pilatuqa nirqan: —Piru ¿ima malutamir rurashqa? nishpa. Chayshina tapuptinmi, paykunaqa ashwamba sh'uqyarqanllapa: —¡Kruspi klabay! ¡Kruspi klabay! nishpallapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Chayshina niptinllapaqam, Pilatuqa yach'arqanna: Maychika imata niptiypismi, mana rinllapachu kasuwaq. Piñakushpam mastana rinllapa sh'uqyaq. Noqamannam rinllapa alsakaq, nishpa. Chaymi yakuta mañashpa, yumbaypa ñawpambi makingunata mayllashpa, nirqan: —Kay allin runata qamkuna wanchiptikiqam, mana uchayuqchu kani noqaqa. Qamkuna munashqaykita rurayllapa. Qamkunam uchayuqqa ringillapa kidaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Chayshina niptinmi, yumbay chay runakunaqa nirqan: —¡Ari! Wanchishpaqam, noqaykuna wambraykunawan uchayuqkuna kashaqllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Chaymi Pilatuqa, Barrabastana kach'ashpa, Jisustaqa asutichishpa, paykunatana intrigarqan, kruspina klabanambaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Chaymandaqam chay gubyirnupa suldadungunaqa uku kwartilninman Jisusta aparqanllapa. Chay ukupiqam yumbay suldadu masingunata Jisuspa rridurninman tandarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Chaymandaqam chay suldadukunaqa Jisuspa kapanda surqoshpa, granati kapata rurachirqan, gubyirnushina kanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Umanmanmi rurarqanllapa suq kuruna kasha likiduta. Allin ladu makimbipismi suq gubyirnupa burdunnin layata piskachirqanllapa. Chayshina rurashpaqam, ñawpambina qonqorikushpa, ancha burlarqanllapa: —¡Biba isrraylinukunapa gubyirnun! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Kanan tuqapashpam, chay piskachishqanllapa burdunwan umambi waqtarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Chayshina burlashpaqam, chay kapa rurachishqanllapata surqoshpa, mudananda rurachirqanllapa. Chaymandaqam aparqanllapa, kruspina klabanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kwartilmanda lluqshishpaqam, tingunakurqanllapa suq runa Simun shutiqwan. Payqam Sirini llaqtamanda karqan. Chay Simundam Jisuspa krusninda amalas umbruchachirqanllapa apanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Chayshinam ch'ayarqanllapa chay lugar Gulguta shutiqman. Chay Gulgutaqam paykunapa rimaynimbiqa munan niyta “Kalabira Lugar”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Chaypina kashpaqam, binuta ayaqwan taqllushpa, Jisusta qorqanllapa upyanambaq. Piru Jisusqam mallishpa chay binutaqa, mana upyarqanchu. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Chaymandaqam kruspina klabarqanllapa. Kruspi klabashpaqam, chay suldadukunaqa swirtita rurarqanllapa, Jisuspa mudananda partinakunanllapa. ˻Chayshina ruraptinllapam, kumplirqanna Dyuspaq rimaq kayshina iskibrishqan: “Paykunapuram swirtita rurashpa, mudananda partinakurqan”, nishpa. ˼ ");
INSERT INTO qvcNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Partinakushpaqam, chaypina tiyarqanllapa kwidaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Chay kruspiqam Jisuspa umamba sawambi suq tablitata rurarqanllapa, imaraykum wañun, nishpa. Chay litrakunaqam niq: “Kay Jisusmi isrraylinukunapa gubyirnun”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jisuspa ladumbiqam ishkay ladrungunatapis kruskunapi klabarqanllapa, suqninda allin ladumbi, suqninda ichuq ladumbi. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Kanan ladunllapata pasaqkunaqam umanllapata kuyuchishpa, musyashpa niqllapa: ");
INSERT INTO qvcNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Qam Dyuspa adurana wasinda bulashpa kimsa diyapi ruraqqar, qam kikiki washakay. Mayá, Dyuspa Churin kashpaqa, chay krusmanda ishkimuy, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Chayshinallam kamachikuq isrraylinu kurakuna, Muysispa liyningunata yach'achikuqkuna, farisiyu duktrinayuqkuna, kamachikuq ansyanukunapis ancha burlashpa, Jisuspaq nirqanllapa: ");
INSERT INTO qvcNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Suqkunataqam washarqan. Piru pay kikinllaqam mana atinchu washakayta. Mayá, Isrrayilpa gubyirnun kashpaqa, kanalitan chay krusmanda ishkimunqa, paypi kriyinanchiqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Payqam niwarqanchiqllapa: “Dyuspa Churinmi kani. Paypillam yuyakuni”, nishpa. Mayá, Tayta Dyus payta allipta kuyashpaqa washanqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Chay ladrunguna ladumbi kaqkunapismi musyarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Chay diyaqam tukuy pachapi limpu tutayarqan larrdusi urasmanda asta las tres di la tardikaman. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Yaqqana las tris kaptinmi, Jisusqa ancha jwirtita qayakushpa, nirqan: —Eli, Eli, ¿lama sabaktani? nishpa. Chay nishqanqam isrraylinukunapa rimaynimbiqa munan niyta: “Dyusitu, Dyusitu, ¿imapaqmir sapalaytaqa dijawashqa kangi?” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Chayshina niqta uyashpaqam, chaypi kaqkunamanda wakinninqa pandashpa, yuyarqan: Dyuspaq chay unay rimaq Eliyastam qayaykan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Chay urasmi suqnin kallparqan ish'uputa apamuq. Apamushpaqam puchqo binupi nuyuchishpa, suq kañapa puntambi rurashpa, Jisuspa shiminman qemirqan chupanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Piru chay wakingunaqam nirqan: —Shuyay rikananchiq, mayá, ¿Eliyaschush rin shamuq washaq ichu mana? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Chaymandaqam Jisusqa suq kutinda jwirtita rimashpa, ispiritunda Dyusman mingashpa, wañurqanna. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Chay urasmi Dyuspa adurana wasimba kurtinanqa anaqmanda urakaman ch'awpi ch'awpi llikikarqan. Nuta: Chay ancha atun rrakta kurtinaqam chay Ancha Santisimu Kwartuta akraq chay Santu Kwartumanda.  Chay urasmi timblurpis karqan. Chaymi atun rumikuna limpu partikarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","53","Chaymandaqam Jisus wañushqanmanda kawsamuptinqa, chay mach'ayshina sipultura alma pambakashqanguna kich'akarqan. Chaymi Dyuspi kriyiq wañushqakunapis achka kawsamushpa, rirqanllapa Dyus akrashqan llaqta Jirusalinman. Chay Jirusalimbiqam achka runakuna, warmikuna chay kawsamuqkunataqa rikarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kanan Jisus wañushqan urasqam kay pachapi timblur karqan. Chaymi chay kwidaykaq kamachikuq suldaduqa yumbay suldadungunawan chayta rikashpa, tukuy chay mas kusaskuna pasaptinqa, ancha manchashpa nirqanllapa: —Allibraq kay runaqa Dyuspa Churin kashqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Chaypim achka warmikunapis karumanda Jisusta chapaykarqanllapa. Paykunaqam Galiliya kashqanmandapacha payta yanapashpa, pullan shamushqallapa karqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Chay warmikunamanda wakinninqam karqan: Marya Magdalamanda kaq, Jakubupa Jusipa maman Marya, chay Sibidiyupa churingunapa mamambis. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Chay diya byirnis amsayaykaptinnam, suq kapuq runa Jusi shutiq shamurqan Pilatuman. Payqam Arimatiya llaqtamanda karqan. Paypismi Jisuspa yach'akuqnin karqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Chaymi payqa Pilatuman rishpa, Jisuspa kwirpunda mañarqan. Chaymi Pilatuqa kamachikurqan, kwirpunda intrigananllapa Jusita. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Chayshina Jisuspa kwirpunda intrigaptinqam, suq limpyu trapuwan liyashpa, aparqanna pambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Chay Jusiqam suq luma qaqitapa pach'ambi mushuq mach'ayshina sipulturata rurachishqa karqan. Chaymi payqa chay sipulturapina kwirpunda kamakachishpa, suq atun rumiwan kirpashpa, rirqanna. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Chay mach'ayshinapa ñawpambim tiyaykarqanllapa chay Marya Magdalamanda kaq, tukayan Maryawan. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Qayandin sabaduqam isrraylinu kurakunapa kamachikuqninguna farisiyu duktrinayuqkunawan rirqanllapa gubyirnu Pilatuta niq: ");
INSERT INTO qvcNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","—Taytitu, yuyanillapam chay alma llullakuq kawsaykashpa kayshina nishqanda: “Wañushpaqam kimsa diyaman rini kawsamuq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Chayri wakin suldaduykita kamachiy, rinanllapa allita kwidaq chay pambakashqanman, kimsa diya kumplinangaman. Yach'akuqninguna imakish tutap shamushpa, chay kwirpunda surqoshpa, isrraylinu masiyllapata ingañanmanllapa: “Chay wañushqaqash kawsamushqana”, nishpa. Chayshinaqach'i mas piyur llulla kanman chay punta llulla rimashqanmandaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Chayshina niptinllapaqam, Pilatuqa nirqan: —Mayá, chaypim suldadukuna. Paykunata apashpa, may atishqaykikaman ancha allita kwidachiyllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Chayshina niptinmi, paykunaqa rishpa, chay mach'ayshina sipulturapa kirpanan rumita ancha allita siñalarqanllapa suq silluwan, yach'ananllapa kunfurmi kashqanda. Chaymi chaypina suldadungunata dijarqan kwidananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Chay samana diya pasaptin, dumingu yaqqana achikyaptinmi, chay Marya Magdalamanda kaq tukayan Maryawan rirqanllapa Jisus pambakashqanman rikaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Chay madrugadum ancha jwirti timblur karqan. Chay urasmi Tayta Dyuspa anjilnin syilumanda shamushpa, chay mach'ayshina sipulturapa kirpashqan rumita ashuchishpa, sawambi tiyarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Chay anjilmi rrilampagushina achikchakurqan. Mudanangunaqam ancha yuraq qasashina llipyarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Kanan chay kwidakuq suldadukunaqam chay anjilta rikashpaqa, ancha manchashpa ch'apsikashpa, bulakashpa, wañushqashinana kidarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Chay anjilqam chay warmikunata nirqan: —Ama manchayllapachu. Noqaqam yach'ani: Qamkunaqam chay kruspi wañushqa Jisusta maskaykangillapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mananam kaypichu. Pay nishqanshinam kawsamushqana. Shamuyllapa kay uku kamakachishqanman chapakuq. ");
INSERT INTO qvcNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Utqana rishpa, yach'akuqningunata niyllapa: “Jisusqam wañushqanmanda kawsamushqana. Ñawpaykillapatam prubinsya Galiliyaman riykan. Waqpinam ringillapa rikaq”, nishpa. Chay allip kaqtallam nishushqallapa kani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Chaymi chay warmikunaqa chay pambakashqanmanda dasna lluqshirqanllapa. Chay anjilta rikashqanrayku manchashpapismi, ancha kushikushpa, kallpaylla rirqanllapa chay anjil nishqanda Jisuspa yach'akuqningunata willaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Chayshina riykaptinllapaqam, Jisusqa chay riykashqanllapapi das rikakushpa napaykurqan: —Bwinus diyas warmisitakuna, nishpa. Chaymi paykunaqa qemikashpa, ch'akingunata abrasashpa, Jisusta adurarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kanan Jisusqa paykunataqa nirqan: —Ama manchayllapachu. Ashwanri masayshina kaqkunaman riyllapa abisaq, paykuna rinanllapa prubinsya Galiliyaman. Waqpinam rinllapa rikawaq, nishpa. Nuta: Jisus “Riyllapa masayshina kaqkunata abisaq” nishqanqam munan niyta paypa apustulningunata rinanllapa abisaq.  ");
INSERT INTO qvcNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Chay warmikuna noqaykunaman shamuykaptinqam, wakin kwidakuq suldadukunaqa Jirusalinman rishpa, chay kamachikuq isrraylinu kurakunata willarqanllapa chay tukuy ima pasashqambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Chaymi chay kurakuna, kamachikuq ansyanukunawan tandakashpa, kayshina parlarqanllapa: “¿Kananqa imatanam rurashunllapa?” nishpa. Chayshina parlashpaqam, suldadukunata achka qellayta pagarashpa nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","—Amar rimayllapachu chay pasashqandaqa. Ashwan kayshina rimayllapaqa: “Noqaykuna puñunaykamanmi Jisuspa yach'akuqninguna tutap shamushpa, suwawashqallapa paypa kwirpunda”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kay nishushqayshina rimaptikillapa, gubyirnu yach'aptinqam, noqaykuna paytaqa kriyichishaqllapa: Chay suldadukunaqam mana uchayuqchu, nishpa. Chayshinam washashqaykillapa, qamkunata ama kastigashunan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Chaymi chay suldadukuna qellayta ch'askishpaqa, chay kunashqanshinana rimarqanllapa. Chay nishqandam achka isrraylinukuna kanangaman parlanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Noqaykuna chay unsi yach'akuqninguna Galiliyaman rishpaqam, Jisus nishqan lumaman rirqayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Chay lumapi Jisusta rikashpaqam, adurarqayllapa. Piru wakin yach'akuqniy masiykunaqam mana allita kriyishpa yuyarqanllapa: ¿Allipchuraq pay? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Chaymi Jisusqa noqaykunaman qemikashpa, kayshina niwarqanllapa: —Tayta Dyusqam ancha pudirniyuq kamachikuqta numbrawashqa, syilupi, kay pachapi kamachikunaypaq. ");
INSERT INTO qvcNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Chaymi kamachiykillapa, riyllapa yumbay nasyungunaman, runakunata, warmikunata yach'achiq, noqapi kriyishpa, yach'akuqniykuna kanambaq. Chay kriyiqkunataqa shutichiyllapa Taytay Dyuspa shutimbi, noqapa shutiypi, Santu Ispiritupa shutimbi. ");
INSERT INTO qvcNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Chayshina shutichishpaqar, yach'achiyllapa tukuy kamachikushqayta kasunanllapa. Kay mundu ushyakaptimbismi, noqaqa tukuy tyimpu pullaykillapa rini kaq, nishpa. Kaytallam iskibriykillapa.");
INSERT INTO qvcNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kayshinam qallarin Dyuspa Churin Jisukristupa ancha shumaq nutisyanqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","(Jisukristu manaraq shamuptin kay pachamanmi, Tayta Dyuspaq suq rimaq karqanna. Paymi Isayiyas shutirqan.) Chay Isayiyasmi librumbi iskibrishqa karqan Taytanchiq Dyus Churinda kayshina nishqanda: Qamba puntaykitam rini kach'aq suq runata, qambaq yach'achikunambaq, runakuna, warmikuna shumaqta ch'ayachishunanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Chaymi chunchakunapi ancha jwirtita rimashpa, kayshina rin yach'achikuq: “Uyakuyllapa, Siñurninchiqmi rinna shamuq. Chayri shumaqtana kawsayllapa, pay shamuptin, allita ch'ayachinaykillapa. Chaqa uchaykillapata dijashpaqam, alabis allichaykangimanshina paypa ñanninda”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Chay nishqanshinam allip karqan. Chaqa Taytanchiq Dyusmi Jisusmanda mas puntata Jwan Shutichikuqta kach'amurqan, Jisuspaq yach'achikunambaq. Chay Jwanmi chunchakunapi runakunata, warmikunata niq: —¡Uyawayllapa, uchaykikunata dijashpa, Tayta Dyusta kasushpana, shutikuyllapa, chay uchaykikunamanda pirdunashunambaq! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Chaymi Jirusalin llaqtamanda, tukuy chay prubinsyan Judiyamanda ancha achka runakuna, warmikuna chay chunchaman riqllapa, chay Jwanda uyaq. Kanan Jwanqam chay uchanda dijaqkunataqa rriyu Jurdambi shutichiq. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Chay Jwanqam chunchakunapim tiyaq. Kapanqam kamillupa millwanmanda kaq. Wach'ukunqam qaramanda kaq. Kanan payqam atun churqapkunata (churqakunata), myil di abijata mikushpa kawsaq. Nuta: Jwamba chay mudananqam Dyuspaq unay rimaqkunapa mudananshina karqan.  ");
INSERT INTO qvcNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Payqam runakunata yach'achishpa niq: —Dyusmandam rinna shamuq suq ancha pudirniyuq maski noqamanda. Chay ancha kamachikuqpa ñawpambiqam noqaqa mana nimachu kashaq. Chaymi nini, manam balinichu ni kriyadunshina llanqemba watunda paskanaypaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Chaqa noqaqam qamkunataqa yakuwan shutichiykillapa. Piru chay ancha baliq shamushpaqam, shutichishunqallapa Dyuspa Santu Ispiritumba pudirninwan, chay Santu Ispiritunwanna purinaykillapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jisusmi prubinsya Galiliyapa Nasarit llaqtanmanda rirqan Rriyu Jurdanman, Jwan shutichinambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Chayshina Jwan shutichiptinqam, Jisusqa yakumanda lluqshiykashpa, anaqman chapakushpa, syiluta kich'akaykaqta rikarqan. Chaymandaqam rikarqan Dyuspa Santu Ispiritunda suq palumitashina syilumanda urangumushpa payman shamuqta. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Chay urasmi syilumandapacha Tayta Dyus Jisusta nirqan: —¡Ijitu! ¡Qam ancha kuyashqay Churiyqa kangi! ¡Qamwanmi ancha kushikuni! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Chaymandaqam Dyuspa Santu Ispiritun suq chunchaman Jisusta aparqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Chay chunchapim Jisusqa 40 diyas tukuyta tiyarqan, chukaru kita animalkunapa ukumbi. Chaypi kaptinmi, dyabluqa rikakurqan tyintanambaq. Chaymandaqam mana nimapi atishpa tyintaytaqa, Jisuspa ñawpanmanda ashushpa rirqan. Chaymandaqam Dyuspa anjilninguna shamushpa, tukuy imapi Jisusta yanaparqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Chay Jwan Shutichikuqta karsilaptinmi, Jisusqa rirqan prubinsya Galiliyaman, Tayta Dyuspa shumaq nutisyanda yach'achikuq. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Chaymi yumbayta nirqan: —Tayta Dyusmi qamkunapa laduykimanna ch'ayamushqa, shumaqta kamachishunanllapa. Chayri qamkunaqa mana allikunata rurashqaykirayku syintishpa, Dyusta rrugayllapa pirdunashunambaq. Kanan paypi kriyishpa, allipta yuyakuyllapa: Taytanchiq Dyusmi munan washawayninchiqta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jisusmi chay prubinsya Galiliyapi ancha atun qoch'apa manyanda riykashpa, rikarqan ishkay masapura runakunata. Suqmi shutirqan Simun. Suqqam shutirqan Andris. Chaypim paykunaqa atarrayanwan piskaykarqan piskadukunata. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Paykunatam Jisusqa kayshina qayarqan: —Shamuyllapa noqawan purinayki. Qamkunaqam yach'angina piskadukunata piskayta. Noqaqam rini yach'achishuqllapa, runakunata maskashpa, yach'achinaykillapa, noqapi kriyinanllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Chaymi paykunaqa chay uras atarrayangunata dijashpa, Jisuswanna rirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Riykashpallapa, ashla waqman ch'ayaykashpaqam, Jisusqa ishkay runa masta rikarqan. Paykunaqam Sibidiyupa churinguna karqan. Suqnin shutirqan Jwan; suqqam Jakubu. Paykunaqam yakupi puriq barkumba ukumbi atarrayangunata allichaykarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Paykunatapismi Jisus qayarqan, paywan pulla purinambaqllapa. Chaymi chay uras das paykunaqa taytanda dijashpa, rirqanllapa Jisuswan. Taytanqam chay barkupiqa kidarqan wakin yanapakuqninwan. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jisusqam chay runakunawan Kapirnawun llaqtaman ch'ayarqan. Chay llaqtapiqam samana diyapi sinaguga wasiman yaykushpa, chaypi yach'achikurqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Chaymi Jisus yach'achikuptinqa, chay uyaqkunaqa ancha ispantashqata uyarqanllapa. Chaqa Jisusqam ancha yach'ayniyuq kamachikuq kashpa, mana yach'achikuqchu Muysispa liyningunata yach'achikuqshina. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Chay sinaguga wasipiqam suq runapis karqan. Paypiqam suq millanaypaq dyablupa ispiritun tiyaq. Chaymi qayach'akurqan: ");
INSERT INTO qvcNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¡A! Qam Jisus Nasaritmanda kaq, ¿ima kwintayuqtaq kangi piñachiwanaykiqa? ¿Ima, kayman shamushpachu, ringi chingachiwaqllapa? ¡Noqaqam riqsiyki! ¡Qamqam Dyuspa chay santu Churin kangi! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Chaymi Jisusqa chay dyabluta anyashpa nirqan: —¡Uyaray! ¡Lluqshiy kay runamanda! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Chayshina qatiptinqam, chay dyabluqa chay runata atakikunata qoshpa, ancha qayach'akushpa, ukunmanda lluqshirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kanan chayta rikashpaqam, chay runakunaqa ancha ispantashqata chaparqanllapa Jisustaqa. Chaymandaqam paykunapura kayshina parlarqanllapa: —¿Imataq kayqa? ¿Ima laya mushuq yach'achikuqtaq, ima laya kamachikuqtaq? ¡Rikay, paypaqqam mana nimachu waq saqra dyablukunaqa! ¡Chaymi kamachiptinqa, das kasunllapa! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Jisus rurashqambaqmi das parlarqanllapa chay prubinsya Galiliyapa tukuy lugarningunapi. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Lluqshishpa chay sinaguga wasimandaqam, Jisusqa chay Jakubuwan, Jwanwan rirqan Simumba, Andrispa wasinman. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Chaypim Simumba swigranqa jibriwan kamapi karqan. Chaymi Jisusta nirqanllapa: —Simumba swigranmi qeshyaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Chaymi Jisusqa chay warmiman qemikashpa, makinmanda rambashpa, shayachirqan. Chayshina shayachiptinmi, das kach'akarqan. Chaymi chay warmiqa chay uras paykunataqa qararqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Chay diya rupay seqaykaptinmi, ancha achka runakuna, warmikuna tandakarqan Jisusman. Paykunaqam apamurqan yumbay qeshyaqningunata, Jisus kach'akachinan. Dyablukuna kamachishqan runakunatapis apamurqanllapa, dyablukunata paykunamanda wichukunambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Chay llaqtapi yumbay tiyaqkunam tandakashpa, Jisus kaykashqan pungupi undakarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jisusqam chaypiqa kach'akachirqan tukuy laya nanaywan kaqkunata. Suqkunamandapismi dyablukunata qatirqan. Chay dyablukunaqam yach'arqanllapa: Jisukristum Dyuspa Churin, nishpa. Piru Jisusqam mana nimatapis dijarqanchu, paypaq rimananllapaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Qayandin yaqqana achikyaykaptinmi, Jisusqa atarishpa, rirqan suq chunchaman, Tayta Dyusman mañakuq. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Chay chunchapi kaykaptinmi, Simun Pidruqa chay suqkunawan rishpa payta maskaq, chaypi tarirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tarishpaqam, Jisusta nirqanllapa: —Yumbaymi maskashuykangi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Piru Jisusqam nirqan: —Ashwan aku waq sirka llaqtakunaman, waqpipis yach'achikunaypaq. Chaqa chaypaqmi shamushqaqa kani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Chaymi chay prubinsya Galiliyapa tukuy llaqtangunaman ch'ayashpaqa, sinaguga wasikunaman yaykushpa, yach'achikurqan. Dyablukunatapismi runakunamanda qatirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Suq diyam suq ismuykaq kwirpuyuq runa Jisusman shamushpa, ñawpambi qonqorikushpa rrugarqan: —¡Taytitu! Qamqam ancha pudirniyuq kangi. Chayri qam munashpaqa, atingi kach'akachiwayta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Chaymi Jisusqa chay millanaypaq runata ancha llakipashpa, paypa sawanman makinda rurashpa nirqan: —Noqam munani kach'akachishuyta. Kanalitan kach'akay, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Chayta niptinllam, chay ancha fiyu qeshyayqa kwirpunmanda das chingarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Chaymandaqam Jisusqa chay runata ancha kunarqan: —Amakish pitapis ni maypipis parlachikungichu. Riy kuramanlla, allita rikashunan. Ufrindaykita apay Dyuspa adurana wasinman, Muysis kamachikushqanda ruranayki, yumban yach'anambaq: Waq runaqam kach'akashqana, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Piru waq runaqam mana rurarqanchu Jisus kunashqandaqa. Ashwanmi payqa rishpa, yumbayta parlachirqan: —Jisusmi kayshina allita yanapawashqa, nishpa. Chaymi Jisusqa manana atirqanchu llaqtakunapi yach'achikuyta, ancha achka qeshyaqkuna maskaptinllapa. Chaymi sawa chunchakunapina puriq. Chay chunchakunapi kaykaptimbismi, achka runakuna, warmikunaqa yach'arqanllapa. Chaymi Jisuspa ikinda ancha achkakuna tukuy maymanda chay chunchaman rirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","2","Suq diyam Jisusqa kutirirqan chay Kapirnawun llaqtaman. Chaymi runakunaqa yach'ashpa: Chaypinam, nishpaqa, ancha achka tandakarqan, Jisusta rikananllapa. Chayraykum Jisus kashqanman undaptinllapa, manana ayparqanchu chay wasiqa. Chaymi manana karqanchu lugar ni sawa pungupi. Ukupiqam Jisusqa Tayta Dyus kunashqanda yach'achikuykarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Chay kashqanmanmi ch'usku runakuna suq runa wañushqashina kwirpuyuqta parapi apamurqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Piru chay wasiman ch'ayachishpaqam, mana atirqanllapachu irpuyta uku Jisus kashqanman, ancha unda runakuna kaptin. Chaymi wasipa sawanman lluqshishpa, tichunda ush'kushpa, chay ush'kutana chay qeshyaqtaqa waskakunawan parambi ishkichirqanllapa Jisuspa uku ñawpanman. ");
INSERT INTO qvcNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jisusqam chayta rikashpaqa, yuyarqan: Ancharaq noqapi yuyakunllapa, nishpa. Chaymi chay qeshyaqtaqa nirqan: —Ijitu, pirdunaykim uchaykikunamanda, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Piru chay uku wasipiqam Muysispa liyningunata yach'achikuqkuna tiyashpa, uyakuykarqanllapa. Paykunaqam yuyarqan: ");
INSERT INTO qvcNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Kay Jisusqam yanqa runalla. ¿Imaraykutaq kayshinaqa nin? ¡Chaqa rikay! Dyusshina tukushpam, Tayta Dyusta burlaykan. Manam ni pipis atinchu uchakunata pirdunakuytaqa. Tayta Dyusllam chaytaqa atin rurayta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jisusqam yach'arqanna chay runakuna yuyashqandaqa. Chaymi paykunata tapurqan: —¿Imaraykutaq qamkunaqa chay mana baliqkunata yuyaykangillapa? ");
INSERT INTO qvcNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Mayá, ¿imataq mas trabajus ruranaypaq, ninaypaq: “Uchaykikunatam pirdunayki” ichu ninaypaq: “Noqam kach'akachiyki; atarishpa, paraykita tandashpa, riy”, nishpa? ");
INSERT INTO qvcNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kananqam rini rikachishuq yach'anaykillapa: Tayta Dyus Jisusta pudirniyuqta numbrashqa, runakunata uchangunamanda pirdunanambaq, nishpa. Chaymandaqam, chay runa wañushqashina kwirpuyuqta nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Atarishpa, paraykita tandashpa, apashpa, riyna wasikiman, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Chayshina kamachiptinllam, chay runaqa dasna atarirqan. Chaymi paranda tandashpa, yumbay chapaykaptin, ñawpanllapata rirqan. Chay chapaqkunaqam chayta rikashpaqa, ancha ispantarqanllapa. Chaymi Dyusta ancha alabashpa nirqanllapa: —¡Manam nunka kay layataqa rikashqachu kanchiqllapa! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Chaymandaqam Jisusqa ririrqan chay ancha atun qoch'apa manyanman. Chaymambismi ancha achka runakuna, warmikuna tandakarqan. Chaymi chaypipis payqa paykunata yach'achirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Chaymanda riqshina suq lugarta pasaqshinam rikarqan suq runa Libi shutiqta. Nuta: Chay Libillam Matiyupis shutiq.  Payqam Alfiyupa churin karqan. Chay Libiqam tiyaykarqan kuntribusyun kubrakunan dispachumbi. Payta rikashpaqam, Jisusqa kayshina qayarqan: —Shamuy, aku noqawan, nishpa. Chaymi Libiqa chay uras atarishpa, Jisuswanna rirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Chaymandaqam Jisusqa yach'akuqningunawan rirqan Libipa wasinman mikuq. Chaypim karqanllapa wakin kuntribusyunda kubrakuqkuna, suq laya uchayuq runakunapis. Chay uchayuqkunaqam chay mesapilla tiyashpa, Jisuswan pulla mikuykarqanllapa. Jisuspa ikinda achka riqkunapismi chaypiqa karqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Chaymi Muysispa liyningunata wakin yach'achikuqkuna, wakin farisiyu duktrinayuqkunaqa chayta rikashpa, Jisuspa yach'akuqningunata tapurqanllapa: —¿Imaraykum Jisusqa mikun waq kuntribusyunda kubrakuqkunawan, waq uchayuq runakunawanqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Piru Jisusqam uyarqan chay runakuna nishqandaqa. Chaymi paykunataqa nirqan: —Mana qeshyaqkunaqam mana munanchu ambikuqtaqa. Qeshyaqkunallam munan ambikuqtaqa. Chaymi noqaqa shamushqa kani kay uchayuqkunata washanaypaq. (Chayraykum paykunawan kani.) Piru manam shamushqachu kani washaq allita ruraq tukuqkunataqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Suq diyam Jwan Shutichikuqpa yach'akuqninguna, ayunaykarqanllapa. Chay farisiyu duktrinayuqkunapismi ayunaykarqanllapa. Chaymi chayta rikaqkunaqa Jisusman rishpa, payta tapurqanllapa: —Jwan Shutichikuqpa yach'akuqninguna, chay farisiyukunapis ayunanllapa. ¿Imaraykutaq qamba yach'akuqnikikuna mana ayunanllapachu? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Chaymi Jisusqa paykunata nirqan: —Manchu suq runa kasarashpaqa, kumpañirungunata kumbidan shamunambaq fyistanman. Chay kasaraq runa kumpañirungunawan fyistapi kushikuqkunaqam mana ayunanchu, ¿manachu? Chayshina yupaymi noqapa kumpañiruykunapis pullay kashpaqa, manaraq ayunanllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Piru suq diyam (ch'iqniwaqkunaqa) paykunamanda rinllapa akrawaq. Chaypinam paykunapis rinllapa ayunaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Manam pipis mawka trapunda mushuq trapuwanqa rrimindanchu. Chaqa mushuq trapuwan rrimindaptinqam, chay mushuq rritasuqa qendishpa, ashwamba llikin mawka traputaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Chayshinallam llullu binutapis rurashpa, mana wichunchiqchu mawka qara taligaman. Chaqa chay llullu binuqam qarwashpa, pach'yachin mawka qara taligataqa. Chayshinam pulla qesachakan binuwan qara taligaqa. Qara taligapismi llikikan. Chayri llullu binutaqa mushuq qara taligakunaman wichushun, chay qara chutakashpa, ama pach'yanambaq. Nuta: Jisus chay mushuq yach'achikushqanqam chay llullu binushina. Isrraylinukunapa chay unay kustumbringunaqam chay mawka qara taligashina.  ");
INSERT INTO qvcNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Suq samana diyapim Jisusqa yach'akuqningunawan tarpudukunapa ukunda riykarqan. Chaymi chay yach'akuqninguna mallaqnashpa, pasaqshina trigukunapa ispigangunata pitikushpa, qaqokushpa, mikurqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Chaypaqmi farisiyu duktrinayuqkunaqa Jisusta nirqanllapa: —Muysismi kamachikushqa, samana diyapi ama trabajananchiq. ¡Rikay! Chay yach'akuqnikikunaqa trabajaykanllapa. Manam kasunllapachu Muysis nishqandaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Chaymi Jisusqa chay farisiyukunata nirqan: —¿Ima, manachu liyishqallapa kangi chay unay gubyirnu Dabid kumpañirungunawan mallaqnashpa rurashqandaqa? ");
INSERT INTO qvcNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Chaqa payqam yaykurqan chay unay karpamanda adurana wasiman mikunata maskaq. Chay tyimpupim chay kura Abyatarqa mas kamachikuq isrraylinu kura kashpa, chay adurana wasita kwidaq. Chay adurana wasipi ufrinda tandakuna kaqmi kurakunapaqlla karqan. Piru chay Dabidqam mana dirichuyuq kashpapis, chay ufrinda tandakunata mikushpa, chay kumpañirungunatapis qorqan mikunambaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jisusqam nirqambis: —Dyusqam samana diyataqa runakunapaq rurarqan, paykunata yanapanambaq. Manam rurarqanchu samana diyataqa, runakunapa patrunninshina kanambaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Noqaqam Dyusmanda Shamuq Runa kashpa, samana diyapa dwiñun kani. Chaymi atini kamachikuyta: Kaymi alli ichu kayqam mana allichu, samana diyapi rurananchiqqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Suq samana diyapim Jisusqa ririrqan sinaguga wasiman. Chaypim karqan suq qendishqa makiyuq runa. ");
INSERT INTO qvcNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Kanan wakinqam Jisustaqa mana shaykuq chaparqanllapa: ¿Ima, kay samana diyapinachu rin kach'akachiq kay qendishqa makiyuqtaqa? Chayta ruraptinqa dimandashun, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jisusmi chay qendishqa makiyuqtaqa nirqan: —Atarishpa, shamuy kay ch'awpiyllapaman, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Chaymi chay runa ch'awpiman riptinqa, Jisusqa yumbay chay runakunata tapurqan: —Tayta Dyusqa, ¿imatam kamachiwanchiq, samana diyapi rurananchiqqa? ¿Allita rurananchiq ichu maluta? ¿Munanchu runapa bidanda washananchiq ichu wanchinanchiq? nishpa. Chayshina Jisus tapuptinqam, chay runakunaqa uyaraplla (uyaralla) kidarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Piru Jisus nishqandaqam mana nimatapis munarqanllapachu intyindiytaqa. Chaymi Jisusqa ancha chapashqanshina malaganayashpa, chay qendishqa makiyuq runataqa nirqan: —Chutay makikita, nishpa. Chaymi chay runa makinda chutaptinqa, dasna allinyarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Chayta rikashpam, chay farisiyu duktrinayuqkunaqa lluqshishpa, gubyirnu Irudispa partidungunawan parlarqanllapa, Jisusta wanchinanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Jisusmi yach'akuqningunawan ririrqan chay ancha atun qoch'apa manyanman. Chaypi ancha shumaq milagrukunata rurariptinmi, achka runa, warmi yach'ashpa, chay prubinsya Galiliyapa llaqtangunamanda tandakarqanllapa Jisusman. Shamurqambismi prubinsya Judiyamanda, Jirusalin llaqtamanda, Idumiyamanda, Tirumanda, Sidunmanda, rriyu Jurdamba waq ladun chimbanmandapis Jisusta rikaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Chay runakuna, warmikunam ancha undarqan Jisus kashqanman. Chaymi yumbay qeshyaqkuna kach'akanambaq kumsanakuypa, waqmanda kaymanda chutakashpa, Jisuspa kapanda munashpa llamkayta, ancha kish'kiyachirqanllapa paytaqa. Chaymi Jisusqa yach'akuqningunata kamachirqan, yakupi puriq barkuta apamunanllapa, chay barkupi tiyashpa yach'achikunambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kanan dyablupa ispiritunwan puriqkunam Jisusman shamushpa, ñawpambi qonqorikurqanllapa. Paykunapim dyablukunapa ispiritunguna tiyarqanllapa. Chay dyablukunaqam Jisusta rikashpaqa qayach'akuqllapa: —¡Qamqam Dyuspa Churin kangi! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Piru Jisusqam chay dyablukunataqa anyarqan uyarananllapa, ama chayshina rimananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jisusqam suq lumapa sawanman lluqshishpa, yach'akuqningunata qayarqan, payman shamunanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Riptinllapaqam, paykunamanda akrarqan dusi yach'akuqningunata, paywan pulla purinanllapa, suq lugarkunaman kach'aptin, pay nishqanda suqkunata yach'achinanllapa. Nuta: Chay dusi akrashqangunaqam apustulninguna shutiqllapa.  ");
INSERT INTO qvcNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Paykunataqam ancha pudirniyuqta rurarqan, atinambaqllapa qeshyaqkunata kach'akachiyta, atinambaq dyablukunata runakunamanda qatiyta. ");
INSERT INTO qvcNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Chay dusi akrashqan runakunaqam kaykuna karqan: Suqmi shutiq Simun. Paypaqllam Jisukristuqa nirqan: “Paylla Pidrupis shutinqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ishkayqam karqan Sibidiyupa churinguna Jakubuwan masan Jwan. Paykunapaqmi Jisukristu nirqan: “Buwanirjismi shutinqallapa”, nishpa. Chay shutinqam rimaynimbiqa munan niyta: “Lanyashina rimayniyuqkuna”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Chay suqkunaqam shutiqllapa: Andris, Filipi, Bartulu, Matiyu, Tumas. Suqqam karqan Alfiyupa churin Jakubu. Suqqam karqan Tadiyu. Suqqam karqan suq Simun. Payqam isrraylinu Kananista partidumanda karqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Suqqam karqan Judas Iskaryuti. Chay Judasmi suq tyimpumanda Jisusta randikurqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jisusmi chay yach'akuqningunawan yaykurqan suq wasiman. Chaymambismi, ancha achka runa, warmi tandakarqan. Chaymi Jisusqa yach'akuqningunawan chay shamuqkunata yach'achishpa, yanapashpa, mana ni atirqanllapachu mikuyta. ");
INSERT INTO qvcNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Chayshina kaykaptinllapam, suqkuna rimarqanllapa: —Jisusqash lukuyashqa, nishpa. Chaymi Jisuspa ayllunguna chayta uyashpaqa, rirqanllapa Jisusta apamuq wasinman. ");
INSERT INTO qvcNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Kanan Muysispa liyningunata yach'achikuqkunam Jirusalin llaqtamanda Jisusman shamushpa, kayshina rimarqanllapa: —Chay mas kamachikuq dyablu Bilsibupa ispiritunqam Jisuspi tiyan. Chaymi chay Bilsibu yanapaptin, payqa atin dyablukunata runakunamanda qatiyta. Manaqa manam atinmanchu qatiyta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Chaymi Jisus chayta yach'ashpaqa, chay washan rimaqkunata qayashpa, kay kumparasyunda rurashpa nirqan: —Chay dyabluqam mana nunka atinmanchu pay mismuqa qatikayta suq runamandaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Chayshinallam suq nasyumbi tiyaqkunapis paykunapura pilyashpa, wanchinakushpaqa, ¿imashinam atinmanllapa kawsaytaqa? ");
INSERT INTO qvcNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Chayshinallam suq ayllupi paykunapura wanchinakushpaqa limpuna chinganmanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Chayshinallam dyablupis mana munanchu pay mismu wanchikaytaqa. Chayshina wanchikashpaqach'i, chinganmanna. ");
INSERT INTO qvcNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kaytapis uyayllapa: Suq ladrunqam mana dasqa atinchu qoch'iyta imangunata suq ancha wapu runataqa. Ashwanmi puntata chay wapu runawan pilyan binsinangaman. Chayshina binsishparaqmi, alli alli ch'aqnashpa, atin imangunata qoch'iytaqa. (Chay runashinam noqapis dyabluta binsishpa, runakunata, warmikunata qoch'ini washanaypaq, nishpa.) ");
INSERT INTO qvcNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","30","’(Dyuspa Santu Ispiritunmi Jisukristuta ancha yanaparqan achka milagrukunata ruranambaqqa.) Piru wakin runakunaqam Jisuspaq rimaykarqanllapa: “Jisustaqam dyablu yanapaykan”, nishpa. Chaymi Jisukristuqam chay rimaqkunataqa nirqan: —(Chayshina kuntrayta rimashpaqam, Dyuspa Santu Ispiritumbaq “dyablum” niykangillapa.) Alliptam niykillapa, runakuna allipta mañakuptinmi, Taytanchiq Dyus tukuy laya uchangunata, mana baliq rimashqangunata rin pirdunaq. Piru mayqan runa Santu Ispiritumbaq niptin: “Chayqam dyablu” nishpaqam, chay runataqa Taytanchiq Dyusqa mana nunka rinchu pirdunaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jisus chay wasipi kaykaptinmi, maman masanguna chayman ch'ayashpa, sawamandalla Jisusta qayachirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Chaymi Jisuspa ladumbi tiyaykaqkunaqa paytaqa nirqanllapa: —Mamaykiwan masaykikunash sawapi shuyashuykangillapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Chaymi Jisusqa nirqan: —¿Pitaq mamay? ¿Pitaq masaykunaqa? ");
INSERT INTO qvcNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Chaymandaqam rridurnimbi kaqkunata chapashpa nirqan: —Qamkunam mamay, masaykunaqa kangillapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Chaqa Tayta Dyus munashqanda kasuqkunam mamay, masaykuna, paniykunaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Suq diyam Jisus ririshpa chay atun qoch'apa manyanman, yach'achikurirqan. Chaymambismi ancha achka runa, warmi tandakarqan, payta uyanambaq. Chaymi kish'kichaptinllapa, Jisusqa yakupi puriq barkuman lluqshishpa, barkumandana paykunata yach'achirqan. Paykunaqam manyapilla kidashpa uyarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Chaymi Jisusqa achka laya kumparasyunda rurashpa, kayshina yach'achikurqan: ");
INSERT INTO qvcNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Mayá, kayta uyawayllapa: Suq runam rirqan tarpukuq. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Chaymi tarpukushpa, simillanda shikwaptinqa, wakin simillaqa ñanman ishkirqan. Chay simillitatam pishqokuna shamushpa limpu pallarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Wakin simillaqam kaskajuman ishkirqan. Chaymi chay simillaqa sawapilla kashpa, wayralla wiñarqan. Piru kaskaju kashqanraykum, mana ch'upakurqanchu ukukamanqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Chaymi rupayaptinqa, das chakirqan, mana ukukaman ch'upakushqanrayku. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Wakin simillaqam kashakunapa ukunman ishkirqan. Chaymi wiñaykaptinqa, kashakuna maqaptin, limpu chingarqan. Manam nimatapis puqorqanchu. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Piru wakin simillakunaqam allin allpaman ishkirqan. Chaykunaqam shumaqta wiñashpa, allita puqorqan. Wakinqam kada simillita 30 granusta puqorqan. Wakinqam 60 granusta puqorqan. Piru wakinqam syin granusta puqorqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","¡Chayri qamkuna rinriyuqkuna, allita uyawayllapa kay nishushqayta! ");
INSERT INTO qvcNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Chay achka runakuna riptinqam, Jisusqa chay dusi akrashqangunawan, wakin yach'akuqningunawan kidarqan. Chaymi paykunaqa Jisusta tapurqanllapa: —¿Imaraykutaq kumparasyunwan yach'achikungi? Chay nishqaykiqa ¿imam munan niyta? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Chaymi Jisusqa nirqan: —Taytay Dyuslla yuyashqandam qamkunataqa yach'achiyki: Kayshinam ancha shumaqta rini kamachikuq, nishpa. Piru manam balinchu chay mana munaq kriyiqkuna chaypaq yach'ananllapaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Chaymi achka kumparasyunwanlla yach'achikuni, paykunaqa chapashpa, uyashpapis, ama allita intyindinanllapa. Chaqa manam balinchu, paykuna amalas noqapi kriyishpa, uchangunamanda pirdunadu kanambaqqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jisukristum chay yach'akuqningunata nirqambis: —¿Ima qamkunapischu mana intyindishqa kangi chay kumparasyundaqa? Chayshina mana intyindishpaqa, ¿imashinataq ringillapa intyindiq suq kumparasyungunawan yach'achikuptiyqa? ");
INSERT INTO qvcNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Suq runa Dyus nishqanda yach'achikuqqam chay tarpukuq runashina. Chaymi yach'achikushqanqa chay similla shikwashqanshina. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Wakin runakunaqam ancha angu shunqoyuqkuna chay angu ñanshina. Chaymi dyabluqa paykunaman rishpa, uyakushqanda limpu qonqachin. Chaqa dyabluqam chay pishqokuna simillata ñanmanda pallaqkunashina. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Chay kaskaju ch'akraqam yach'achiwanchiq chay das disanimakaqkunapaq. Chaqa paykunaqam Dyuspa shumaq nutisyanda uyashpaqa, kushikushpa das kriyinllapa. Piru manam allitachu noqapiqa yuyakunllapa. Chaymi noqapi kriyishqanrayku qesachadu kashpaqa, das disanimakashpa, manana munanllapachu noqapi kriyiytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Wakin runakunaqam chay kashapa ukumbi tarpudu wiñaqkunashina. Chaqa paykunaqam Dyus nishqanda uyashpa, das ch'askinllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Chaymandaqam kay mundupa imangunapaq llakishpa, tukuy imayuq munashpa kayta, Dyusta das qonqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Piru wakinqam Dyus nishqanda uyashpa, ch'askishpaqa, allipta paypi yuyakunllapa. Chaymi paykunaqa chay similla allin allpapi wiñaqkunashina. Chaqa Dyusta kuyashpa, kasushpam, shumaqta kawsanllapa. Chaymi paykunaqa chay similla 30 puqoqkunashina. Wakinninqam Dyusta masta kuyashpa, chay similla 60 puqoqkunashina. Llalli wakinqam Dyusta masta kuyashpa, chay similla syin puqoqkunashina. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kay kumparasyunda rurashpapismi, Jisusqa yach'achikurqan: —Mayá, ¿suq michataqachu ruranchiqman suq kajumba waranman ichu suq kamapa waranman? Manám. Ashwanmi altupi ruranchiqqa, allita achikchakunanqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Chayshinallam yumbay pakadu kaqqam suq diyaqa manana pakaduchu rin kaq. Ashwanmi achka runakuna chay mana yach'ashqangunata rinllapa yach'aq. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Chayri qamkuna rinriyuqkunaqa, allita uyawayllapa kay nishushqayta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Chaymandaqam kayshinapis yach'achikurqan: —Allita kasuyllapa kay uyakushqaykita. Qamkuna allita kasuwaptikiqam, Taytanchiq Dyusqa masta rin yach'achishuqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Allita uyawayllapa, chay allita yach'akuqtam Dyusqa masta rin yach'achiq. Piru chay mana allita uyakuqtaqam chay ashla yach'akushqandaqa limpu rin qonqachiq. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kayshinapismi Jisusqa yach'achikurqan: —Taytanchiq Dyusta ancha achka runakuna, warmikuna shumaqta kasushpaqam, suq tarpudushina rin kaq. Chaqa suq tarpukuqqam simillanda ch'akrambi tarpushpaqa, chaypina dijan wiñanambaq, ¿manachu? ");
INSERT INTO qvcNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Chaymandaqam chay dwiñuqa ch'akranmanda rishpaqa, puñun, rikch'akan. Manam yach'anchu, imashinam wiñan chay simillaqa, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Piru chay simillaqam gustunlla wiñashpa, allpamanda lluqshin. Chayshina wiñashpa atunyashpaqam ispiganna. Chaymandaqam chay muritungunaqa qarwanna. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Chayshinam kusicha tyimpuqa ch'ayamunna. Chaymi runakuna rinna syigaq. Nuta: Chayshina yupaymi Dyuspaq yach'achikuptinchiq, mas achka runakuna, warmikuna payta kasuykan.  ");
INSERT INTO qvcNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jisusqam nirqambis: —¿Ima mas kumparasyunda rurashpam, atini qamkunata yach'achishuyta: “Taytanchiq Dyustam ancha achka runakuna, warmikuna shumaqta rin kasuq”, nishpa? ");
INSERT INTO qvcNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Chayqam ñapushpa murunshina rin kaq. Chaqa chay ñapushpa murunqam yumbay simillamanda mas uchulita, ¿manachu? ");
INSERT INTO qvcNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Piru allpapi pambakashpaqam, uchulita kashpapis, atunda wiñan yumbay yurakunata binsishpa. Kanan ancha achkatam rikrakun. Chay rikrangunapim pishqetukunapis tiyashpa llandukun. Nuta: Chay ñapushshinam Dyusta kasuqkunaqa ashlita kashpapis, ancha rinllapa achkayaq.  ");
INSERT INTO qvcNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisusmi chayshina achka kumparasyunwanlla yach'achikurqan, chay uyaqkuna may intyindinangaman. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Piru yach'akuqningunatallam intyindichiq chay kumparasyungunapaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Chay diyallam yaqqana tutayaykaptin, Jisusqa yach'akuqningunata nirqan: —Aku kay atun qoch'apa waq ladu chimbanman, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Chaymi paykunaqa, runakunata dijashpa, yakupi puriq barkupi Jisusta aparqanllapa. Wakin barkukunapipismi runakunaqa pullan rirqan yapachashpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Piru riykaptinllapam, ancha jwirtita wayrarqan. Chaymi yakuqa ancha maqchikamushpa chay barkuman undaykarqanna. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Chay barkupiqam Jisusqa iki ladupi suq sawanapa sawambi umanda rurashpa puñuykarqan. Chaymi chay yach'akuqningunaqa utqaymaya rikch'achishpa, Jisusta nirqanllapa: —¡Ay, Taytitu! ¡Yakumanmi seqaykanchiqna! ¿Ima, manachu noqaykunata llakipawangi? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Chaymi Jisusqa atarishpa, wayrata, yakuta jwirtita rimashpa kamachirqan: —¡Qasillay! nishpa. Chayshina kamachiptinqam, chay wayra, tukuy chay yaku maqchikamuykaq limpu qasillarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Chaymandaqam chay yach'akuqningunata nirqan: —¿Imaraykutaq qamkunaqa mancharqaykillapa? ¿Ima manachu allita noqapi yuyakungillapa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Chaymi chay yach'akuqningunaqa ancha manchashqata paypura kayshina parlarqanllapa: —¿Ima laya runataq kay Siñurninchiqqa? ¡Rikay, wayrawan yakuta kamachiptinqa, das kasun! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Chayshina rishpaqam ch'ayarqanllapana waq chimba Gadara lugar shutiqmanna. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Chay yakupi puriq barkumanda lluqshiptinllapaqam, Jisuspa ñawpanman kallpaylla ch'ayarqan suq luku runa dyabluwan puriq. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Chay runaqam pantyungunapi tiyaq. Kanan ancha jwirsayuqmi kaq. Chaymi kadinakunawan watashpapis, mana pipis atiqchu sujitaytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Sujitananllapa yuyashpam, kutin kutin makingunamanda ch'akingunamanda kadinakunawan ch'aqnaqllapa. Chayshina ruraptinllapapismi, chay runaqa kadinakunata limpu pitishpa, maytapis riq. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Chay runaqam punchawnindin, tutapnindin qaqakunapi, pantyungunapi qayach'akushpa puriq. Kanan rumikunawanmi paylla chankakashpa limpu chuqrikaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Chay runaqam karumanda Jisusta rikashpa, kallpaylla rishpa, ñawpambi qonqorikurqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Chaymi Jisusqa nirqan: —Qam, dyablu mana baliq, lluqshiy kay runamanda, nishpa. Chayshina niptinqam, chay dyabluqa kayshina qayach'akurqan: —¿Imapaqmi noqamanqa mitikungi qam anaq altu Dyuspa Churinqa? ¡Yush'ayku, amar qesachawaychu! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Chayshina qayach'akushpa niptinqam, Jisusqa tapurqan: —¿Imataq shutingi? nishpa. Chaymi dyabluqa nirqan: —Noqaykunaqam shutini Manada, ancha achka kashqayllaparayku, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Chay dyablukunaqam kutin kutin Jisusta rrugarqan: —Yush'ayku, kay lugarmandaqa ama qatiwayllapachu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Chay qaqapa ladumbim ancha achka kuchikuna mikuykarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Chaymi dyablukunaqa Jisusta rrugarqan: —Kach'awayllapa, waq kuchikunaman yaykunayllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Chaymi Jisusqa nirqan: —Mayá, riyllapa, nishpa. Chaymi dyablukunaqa runamanda lluqshishpa, kuchikunamanna yaykurqan. Yaykuptinllapaqam, kuchikunaqa chay qaqamanda kallpashpa, limpu qaqayashpa, yumbaynin yakuman seqashpa, ch'uqashpa wañurqanllapa. Chay qaqayaq kuchikunaqam ishkay milch'i karqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Chaymi chay kuchikunata michiqkunaqa ancha manchashpa kallparqanllapa abisakuq: —Jisukristum kay kusaskunata rurashqa, nishpa. Paykunaqam abisarqan ch'akrapi kaqkunata, llaqtapi kaqkunata. Chaymi ancha achka runakuna, warmikuna shamurqanllapa rikaq, mayá, ¿imash kashqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Chayshina ch'ayamushpaqam, chay runataqa rikarqanllapa manana lukutachu. Ashwanmi kapanda rurakushpana, Jisuspa ladumbi shumaqta tiyaykarqan. Chaymi chay runakuna, warmikuna chayshina rikashpaqa, anchana mancharqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Chay michidurkunaqam chay lukupaq, chay kuchikunapaq manyaqlla paykunata parlachirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Chaymi chay shamuqkunaqa Jisusta ancha rrugarqanllapa, lluqshinan paykunapa lugarninmanda. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kanan Jisus yaykuptin barkumanqam, chay kach'akashqa runaqa ancha rrugarqan, pullan rinambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Chaymi Jisusqa nirqan: —Noqawan rinaykimandaqam mas allin aylluykikunawan wasikiman rinayki. Rishpaqa, paykunata parlachiy Dyus llakipashushpa yanapashushqambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Chaymi chay runaqa rishpa, dyis llaqtakunapa prubinsyambi kayshina parlachikurqan: “Jisusmi ancha yanapawashqa” nishpa. Kanan yumbay uyaqkunaqam ancha ispantashqata kushikurqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisusmi kutirirqan yakupi puriq barkupi atun qoch'apa suq ladun chimbanman. Chaypipismi ancha achka runakuna, warmikuna tandakarqan, payta uyanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Paykunawan kaykaptinmi, sinaguga wasipa suq kamachikuqnin chayman ch'ayamurqan. Chay runaqam Jayru shutiq. Paymi Jisuspa ñawpambi qonqorikushpa, ");
INSERT INTO qvcNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","kayshina rrugarqan: —Taytitu, suq faburta ruraway. Chinaymi wañuykanna. Akur makikita sawambi rurashpa, kach'akachinayki, ama wañunambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Chaymi Jisusqa paywanna rirqan. Chayshina riykaptinqam, ancha achka runakuna, warmikuna ikinda rishpa, ñambiqa Jisusta kish'kicharqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Chay ikinda riqkunapim suq qeshyaq warmi karqan. Chay warmitaqam dusi watakuna tukuyta yawar mana dijarqanchu. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Chaymi ambikuqkunaman rishpa ancha ñakarqan. Kanan qellaynindapismi limpuna ushyashqa karqan. Piru manam nimatapis kach'akarqanchu. Ashwanmi mastana ashwambayarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Chaymi payqa Jisuspaq uyakushpa, yuyarqan: ¿Imanayraq Jisuspa kapitanda llamkayman kach'akanaypaq? nishpa. Chaymi runakunapa ukundalla rishpa, ikimanda aypakushpa, kapanda llamkarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Chay llamkashqan urasllam yawarqa das dijarqan. Chaymi kwirpundaqa kach'akashqatana tantiyarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Piru Jisusqam pudirnin lluqshiptinqa, yach'arqanna. Chaymi ikiman tikrakashpa tapukurqan: —¿Pitaq kapayta llamkashqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Chayshina tapukuptinmi, chay yach'akuqningunaqa nirqan: —Rikay, achka runakunam kish'kichashuykangi. ¿Chaychu ningi: “¿Pitaq kapayta llamkashqa?” nishpaqa? ");
INSERT INTO qvcNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Piru Jisusqam yumbayta ancha chaparqan, yach'anambaq, ¿Pim kapayta llamkashqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Chaymi chay warmiqa yuyarqan: Noqapaqmi chapakuykan, nishpa. Chaymi manchaywan ch'apsikashpa rirqan, ñawpambi qonqorikushpa, tukuy ima pasashqanda Jisusta niq. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jisusqam chay warmita nirqan: —Ijita, noqapi yuyakushqaykiraykum kach'akashqana kangi. Kushikushpana riy. Chaqa chay qeshyaynikimandam ringi kach'akashqana kidaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Chayshina Jisus chay warmiwan parlanangamanmi, chay Jayrupa wasinmanda abisuwan ch'ayamushpallapa, Jayruta nirqan: —Chinaykiqam wañushqana. Akuna. Amana piñachiychu kay yach'achikuq siñurtaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Piru chay nishqanllapata mana kasushpam, Jisusqa Jayruta nirqan: —Ama manchaychu. Yuyakuylla noqapi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Chayshina nishpaqam, Jisusqa chay ikin riqkunataqa manana aparqanchu yumbaytaqa. Aparqanqam Jayruta, Pidruta, Jakubuta, masan Jwandalla. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Chayshina Jayrupa wasinman ch'ayashpaqam, uyarqan ancha waqashpa yupakuykaptinllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Chaymi Jisusqa yaykushpa uku wasinman nirqan: —¿Imapaqmi kunyallaqa waqaykangillapa? Chinaqam mana wañushqachu. Puñuykanllám, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Chayshina niptinqam, chaypi kaqkunaqa Jisusta asiparqanllapa. Piru Jisusqam yumbay ukupi kaqkunata sawaman surqoshpa, chay chinapa taytanda, mamanda apashpa, chay kimsa pullan riqkunawanlla yaykurqan chay alma kashqanmanqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Chaymandaqam chinata makinmanda piskashpa nirqan: —Talita kumi. Chay nishqanqam rimaynimbiqa munan niyta: “Chinita, qamtam niyki, ¡atarimuy!” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Chaymi chinaqa chay uras wañushqanmanda atarishpa purirqanna. Payqam dusi watayuq karqan. Chay rikaqkunaqam ancha ispantarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Piru Jisusmi paykunataqa ancha jwirtita kamachirqan, ama pitapis chaytaqa parlachinanllapa. Nirqambismi chay chinata qarananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Chay llaqtamandaqam Jisusqa uywakashqan llaqta Nasaritmanna kutirqan. Yach'akuqningunapismi pullan rirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Chaypiqam samana diya ch'ayamuptinqa, Jisusqa yach'achikuykarqan sinaguga wasipi. Chaymi achka llaqta masinguna uyashpaqa, ancha chapashqanshina rimarqanllapa: —¿Maypitaq waq imaqa chaykunataqa yach'akushqa? ¿Ima yach'ashqandataq yach'achiwanchiq? ¿Imashinataq waq runaqa milagrukunataqa ruran? ");
INSERT INTO qvcNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Chaqa waqqam chay karpintiru. Maryapa ullqo wawan. Jakubupa, Jusipa, Judaspa, Simumba masanmi kay runaqa. Paningunapismi noqanchiqkunawan kay llaqtapi tiyanllapa. Chayshina nishpam, ancha rimarqanllapa. Kanan paykunaqam mana munarqanllapachu Jisusta uyaytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Chaymi Jisusqa nirqan: —Yumbay llaqtakunapi Dyuspaq rimaqkunataqam shumaqta ch'askinllapa. Chay rimaqkunapa llaqta masingunalla, ayllunguna, wasimbi tiyaqkunallam mana shumaqtachu ch'askinllapaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Chaymi payqa chay Nasarit llaqtambiqa manana atirqanchu achka milagrukunata ruraytaqa. Wakin qeshyaqkunapa sawambi makinda rurashpam kach'akachirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Chaypaqmi Jisusqa ancha yuyarqan: ¿imaraykutaq kay llaqta masiykunaqa mana munanchu noqapi yuyakuytaqa? nishpa. ˻Chaymandaqam Jisusqa chay sirka llaqtitakunamanna rirqan yach'achikuq.˼ ");
INSERT INTO qvcNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jisusqam chay dusi apustulningunata qayashpa kamachirqan, ishkay ishkay rinanllapa yach'achikuq. Pudirninda paykunataqa qorqan, dyablukunata runakunamanda qatinanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Paykunatam kamachirqan: —Ñanda rinaykillapaqa, ama nimatapis apayllapachu. Kadunu suq qeru burdundalla apayllapa. Alfurjata, fiyambrita, qellayta ama apayllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Llanqekushpalla sapalan kapaykiwanlla riyllapa. Ama apayllapachu ishkay kapaykitaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Pusadata tarishpaqa, chaypilla kidayllapa, chay llaqtamanda rinaykikaman. Ama tiyayllapachu suq wasipi suq wasipiqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Piru mayqan llaqtapi mana munaptinllapa ch'ayachishuyta, ama kidayllapachu chaypiqa. Piru chay llaqtamanda rinaykillapaqa llanqekimanda allpata ch'apsishpa riyllapa, ama ni allpanda apanaykillapa, yach'ananllapa: Paykunaqam manana kwintayuqchu noqanchiqkunawanqa, nishpa. Alliptam niykillapa, chay fyirusyashuqkunaqam jwisyu diya ch'ayamuptinqa, chay Sudumawan Gumurra llaqtakunamanda mas kastigadu rinllapa kaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Chayshina kamachiptinmi, paykunaqa rishpa, runakunata, warmikunata yach'achirqan, uchanllapata dijashpa, Dyustana kasunambaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Paykunaqam qatirqan achka dyablukunatapis. Qeshyaqkunapa sawanman asiytita rurashpam, paykunatapis kach'akachirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Chay llaqtakunapa gubyirnun Irudismi Jisuspa famanda yach'arqan, yumbay parlaptinllapa. Chay famata yach'ashpaqam nirqan: —Alma Jwan Shutichikuqmi wañushqanmanda kawsamushqana. Chaymi chay milagrukunata atin rurayta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Suqkunaqam niqllapa: —Dyuspaq rimaq chay alma Eliyasmi kawsamushpa, Jisusna shutin, nishpa. Wakinqam niqllapa: —Payqam Dyuspaq suq mushuq rimaq kanman, chay unay rimaqkunashina, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Gubyirnu Irudisqam chaykunata yach'ashpaqa nirirqan: —Chay Jisusqam alma Jwan Shutichikuq. Manchu noqaqa umanda pitichirqay. Chay almam kananqa kawsamushqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Chaqa chay alma Jwan Shutichikuq kawsaykaptinraqmi, chay gubyirnu Irudisqa masan Filipipa warmin Irudiyasta purichiykarqan. Chaymi Jwan Shutichikuqqa mana manchashpachu, anyashqa karqan: —Manam balinchu masaykipa warminwan kanaykiqa, nishpa. Chaymi Irudisqa Jwandaqa karsilachishpa, kamachirqan kadinakunawan watananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kanan chay warmi Irudiyasmi Jwan Shutichikuqtaqa ancha ch'iqnishpa, munarqanna wanchiyta, piru manam atirqanchu wanchiytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Chaqa Irudisqam Jwanda washashpa, chay warmin Irudiyasta nirqan: —Ama wanchishunchu, nishpa. Chaqa payqam Jwanda ancha rrispitashpa yuyarqan: Jwanqam ancha allin runa. Dyustam ancha allita kasun, nishpa. Chaymi Jwan yach'achikuptin, chay gubyirnu Irudisqa uyashpa yuyarqan: ¿Kasushaqchu ichu mana? nishpa. Chayshina yuyashpapismi, ancha gustarqan uyaytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Piru suq diyam chay warmi Irudiyasqa illuki kayshina rurarqan. Gubyirnu Irudisqam chay prubinsya Galiliyapa yanapakuq awturidarningunata, mas kamachikuq suldadungunata, suq laya ancha baliq runakunata kumbidarqan, diyambaq shamuptin, fyistata rurananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Chaymi chay diyambaq kumbidashqangunawan mesapi mikuykaptinqa, chay Irudiyaspa chinan ñawpanllapapi ancha dansarqan. Chayshina dansaptinqam, ancha gustarqan chay Irudistaqa. Chaymi chay Irudisqa intinadanda nirqan: —Imatapis mañaway. Ima mañawashqaykitam qoshqayki, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Chayshinam ancha jurashpa nirirqan: —Mañawaylla. ¿Imatam munangi? Noqaqam tukuy ima munashqaykita qoshqayki. Tukuy imay kaqmandam midya partita atini qoshuyta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Chaymi chinaqa lluqshishpa, maman Irudiyasta tapurqan: —¿Imataraq mañayman? nishpa. Chaymi mamanqa nirqan: —Mañay, Jwan Shutichikuqpa umanda suq platupi qoshunambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Chaymi chinaqa utqaymaya kallpashpa, yaykurishpa, gubyirnutaqa nirqan: —Jwan Shutichikuqpa umanda suq platupi kanalitan qoway, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Chayta mañashqanraykum, gubyirnu Irudisqa limpu malaganayarqan. Piru yanapakuq awturidarkunapa ñawpambi jurashqanraykum, mana munarqanchu chinata ñigaytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Chaymi suq suldadunda kamachirqan, rishpa karsilman, Jwamba umanda apamunambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Chaymi chay suldaduqa rishpa, Jwamba umanda kuchushpa, suq platupi apamushpa, chinatana qorqan. China ch'askishpaqam mamandana qorqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Chay alma Jwamba yach'akuqningunam chayta yach'ashpaqa, karsilman rishpa, kwirpundallana aparqanllapa pambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jisuspa chay dusi apustulninguna yach'achikushpa, qeshyaqkunata kach'akachishpaqam kutimurqanna. Kutimushpaqam Jisusta nirqanllapa tukuy ima rurashqambaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Chay diyakunapiqam ancha achka runa, warmi Jisusman tandakaqllapa. Chaymi payqa yach'akuqningunawan tandakaqkunata yanapashqanrayku, mana atiqllapachu ni mikuyta ni samayta. Chaymi Jisusqa yach'akuqningunata nirqan: —Akullapa ashlita samaq suq chuncha lugarman, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Chaymi Jisusqa yach'akuqningunawan rirqanllapa yakupi puriq barkupi chay atun qoch'apa suq chuncha manyanman. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Piru achka runakunam Jisusta rikarqanllapa barkupi riykaqta. Chaymi paykunaqa chay uras chay atun qoch'apa manyanda kallpaylla rirqanllapa. Yumbay chay llaqtakunamanda rishpam, chay barkuta binsishpa, puntata chay chunchamanna ch'ayarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Chaymi Jisus barkumanda ishkishpaqa, chay ancha achka runata, warmita rikashpa, llakipashpa, yuyarqan: Manam ni pipis kanchu paykunata Dyus nishqanda yach'achinambaqqa. Mana dwiñuyuq wishakunashinam purinllapa, nishpa. Chaymi Jisusqa paykunataqa ancha yach'achirqan Dyuspaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Piru tardina kaptinqam, chay yach'akuqningunaqa nirqan: —Tardinám. Manam pipis kay chunchapiqa tiyanchu. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Chayri kay runakunata, warmikunataqa dispidiyna, sirka kasiriyukunaman rinanllapa, mikunanda randiq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Piru Jisusqam nirqan: —Qamkuna qarayllapa, nishpa. Chaymi paykunaqa nirqan: —¿Maymandataq dusyintus dinaryu qellaytaqa tarishaqllapa, yumbaypaq tandata randinayllapaqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Chaymi Jisusqa tapurqan: —¿Ayka tandayuqtaq kangillapa? Mayá, riyllapa rikay, nishpa. Chaymi paykunaqa rishpa rikaqqa nirqanllapa: —Sinku tandita ishkay piskaditullam kan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Chaymi Jisusqa yumbay chay runakunata, warmikunata kamachirqan, pachan pachan chay qewakunapa sawambi tiyanambaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Chayshina kamachiptinqam, wakinqa 50, 50 tiyarqanllapa; wakinqam 100, 100 tiyarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Chaymandaqam Jisusqa chay sinku tanditata, ishkay piskadituta piskashpa, syiluman chapakushpa, Dyusta pagikurqan. Chaymandaqam chay tanditakunata piti piti rurashpa, yach'akuqningunata qorqan, chay yumbay runata, warmita qonanllapa. Chay ishkay piskaditutapismi chayshinalla piti piti rurashpa, yumbayta qorqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Chayshina qoptinqam, yumbay undanangaman mikurqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Chayshina mikuptinllapaqam, achka pidasu tanda piskaduwan subrarqan. Chaymi dusi kanasta undakunata tandarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Chay mikuqkunaqam ullqokunalla 5.000 karqan. (Warmikunawan, wambrakunawanqam mas achka karqan.) ");
INSERT INTO qvcNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Chay ancha achka runakuna, warmikuna mikuptinqam, Jisusqa yach'akuqningunata nirqan: —Yakupi puriq barkuman lluqshishpa, ñawpayllapa waq chimba Bitsayda llaqtaman, nishpa. Chayshina nishpam, payqa kidarqan, yumbaymanda dispidikanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Chaymandaqam, sapalanllana rirqan suq lumaman, Tayta Dyusman mañakuq. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Chay diya amsayaptinqam, chay barkuqa chay atun qoch'apa ch'awpimbina karqan. Kanan Jisusqam sapalanlla kidarqan chay lumapi. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Piru ñawpa ladunmanda ancha wayraptinmi, chay yach'akuqningunaqa mana atirqanllapachu ñawpaman riyta. Chayshina kaykaptinmi, Jisusqa paykunataqa rikarqan barkupa kumsanan palangunawan ancha shinchikushpa apaykaqta. Chayshina ñakaykaptinllapam, manaraq achikyaptin, Jisusqa yakupa sawanda ikinllapata rirqan. Chayshina rishpaqam, paykunataqa pasaykarqanna. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Chayshina yakupa sawanda riykaqta rikashpaqam, paykunaqa yuyarqan: ¡Waqqam alma! nishpa. Chaymi ancha manchashpa yumbaynin qayach'akurqan. Chaymi Jisusqa nirqan: —Ama manchayllapachu. Noqam kani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Chaymandaqam Jisusqa chay barkuman lluqshiptinqa, wayraqa limpu qasillarqan. Chayta rikashpaqam, chay yach'akuqningunaqa ancha ispantarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Paykunaqam chayraq rikashqallapa karqan, Jisus tanditata achkayachiptin. Piru chay milagruta rikashpapismi, manaraq paypiqa allitaqa kriyirqanllapachu, angu shunqoyuq kashqanllaparayku. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Chaymandaqam barkupi chay atun qoch'ata pasashpaqa, Jinisarit pambaman ch'ayarqanllapa. Chayman ch'ayashpaqam, barkuta watarqanllapa atun qoch'apa manyambi. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Chay barkumanda diki ishkiptinllapaqam, chaypi tiyaqkunaqa Jisustaqa das riqsirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Chaymi chay rikaqkunaqa kallparqanllapa yumbay chay lugarkunaman abisakuq: —Jisusqam chay lugarman shamushqa, nishpa. Chaymi achka qeshyaqkunata parakunapi apamurqanllapa Jisusman. ");
INSERT INTO qvcNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kanan yach'ashpa: Jisusqam chaymanna riykan, nishpa, qeshyaqkunata apaqllapa shuyachiq. Chaymi llaqtakunapi, kasiriyukunapi, chunchakunapi, ñangunapi, tukuy maypi qeshyaqkunata shuyachishpa, Jisusta ancha rrugarqanllapa: —Yush'ayku kay qeshyaqniykunatar dijay, kapitaykipa manyanda llamkananllapa, nishpa. Chaymi chay qeshyaqkunaqa Jisuspa kapanda llamkashpa, yumbay kach'akarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Suq diyam wakin farisiyu duktrinayuqkuna, Muysispa liyningunata wakin yach'achikuqkunapis Jirusalin llaqtamanda shamurqanllapa Jisusman. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Paykuna rikaykaptinmi, Jisuspa wakin yach'akuqninguna makingunata mana mayllashpachu mikurqanllapa. Chaymi chay shamuqkunaqa Jisuspa yach'akuqningunata anyarqanllapa. Chaqa isrraylinu llaqta masingunapa mayllakuna kustumbrindam mana rurarqanllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","4","Piru chay farisiyukunaqam, isrraylinu masingunawan kanangaman unay agwilungunapa chay mayllakuna kustumbrinda, suq laya kustumbringunatapis ruranllapa. Chaymi kutin kutin mayllanllapa makingunata, basungunata, jarrangunata, jirru mangangunata, kamangunata. Llalli plasaman rishpa kutimushpaqam, kutin kutin makingunata mayllashparaq mikunllapaqa. Mana mayllashpaqam, mana mikunllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Chaymi chay farisiyukuna, Muysispa liyningunata chay yach'achikuqkunapis piñakushpa, Jisusta nirqanllapa: —Rikay, qamwan puriqkunaqam mana mayllakushpachu, mapa makingunawan mikunllapa. Mayá, ¿imaraykutaq mana ruranllapachu agwilunchiqkuna rurashqanshinaqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Chaymi Jisusqa chay rimaqkunata nirqan: —¡A, qamkuna shimikiwanlla Dyusta kasuqkunaqa! Qamkunapaqmi Dyuspaq rimaq Isayiyasqa librumbi kayshina Dyus nishqanda iskibrirqan: Kay runakunaqam shiminwanlla kasuwanllapa. Manam alliptaqa kasuwanllapachu tukuy shunqonwanqa. Chaymi noqamandaqa akrakashqallapana. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Chayraykum mana nimapis balinchu paykuna noqata alabawananqa. Chaqa runakuna nishqandallam yach'achikunllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kayshinallam qamkunapis Dyus kamachikushqanda dijashpaqa, runakuna kamachikushqandalla ruraykangillapa. Chaymi chay mayllakuna kustumbri layata rurashpaqa, jarraykikunata, basuykikunata mayllangillapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Chaymandaqam Jisusqa nirqambis: —Qamkunaqam chay kustumbrikikunata ruranaykirayku, Dyus kamachikushqandaqa mana kasungillapachu. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Chaqa Muysismi kamachikurqan: “Taytaykita, mamaykita rrispitashpa kasuy. Taytanda mamanda mayqan maldisyaqta wanchiyllapa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Piru qamkunaqam ningi: “Suq runaqam taytanda mamanda atin niyta: ‘Manam atinichu yanapashuyta. Yumbay kusasniykunatam Dyusta rini qoq’ ” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Chayshina nishpaqam, qamkunaqa suqkunata yach'achiykangi: “Mana munashpa yanapayta taytaykita mamaykitaqa, ama yanapaychu”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Chayshina yach'achikushpaqam, qamkunaqa Dyus nishqandaqa mana baliqpaqna riqsiykangillapa, runakunapa kustumbrindalla ruranaykirayku. Kanan suqmanda yach'akushpam, suqkunatana yach'achingillapa. Achka laya mana baliq kustumbrikunatam rurangillapa chay kustumbritashina. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Chaymandaqam yumbay chaypi kaqkunata qayashpa nirqan: —Yumbayniki uyawashpa, allita intyindiwayllapa: ");
INSERT INTO qvcNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tukuy ima sawamanda yaykuqqam mana uchayuqtachu dijashungi. Ashwanmi mana allikunata shunqoykipi yuyashpa, uchayuqqa kangillapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","˻Chayri qamkuna rinriyuqkunaqa allita uyawayllapa,˼ nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Chaymandaqam Jisusqa chay achka runakunamanda akrakashpa, suq wasimanna yaykurqan. Chay wasipina kashpaqam, chay yach'akuqningunaqa tapurqanllapa: —Chay nishqaykitaqar allita intyindichiwayllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Chaymi Jisusqa nirqan: —¿Ima qamkunapischu mana intyindingillapa? Noqaqam nishushqallapa kani: Mikuna sawamanda pach'anchiqman yaykushpaqam, mana uchayuqtaqa rurachiwanchiqchu. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Chaqa manam ni pipis shunqonmanqa mikunchu. Ashwan mikunchiqqam pach'anchiqman. Chaymandaqam kwirpunchiqmandaqa lluqshinna litrinaman. Chayshina nishpaqam yach'achikurqan: Yumbay laya mikunaqam limpyu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kayshinapismi nirqan: —Runakunapa mana allin yuyayningunam uku shunqonmanda lluqshin, uchayuq kanambaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Chaqa shunqonllapapi mana allin yuyayninguna kaptinmi, kay laya mana allikunata ruranllapa: Wakinqam warmiyuq kashpa, ichu warmipis runayuq kashpaqa, suqwan puñunllapa. Wakin sapalan kaqkunaqam piwambis puñunllapa. Wakinqam wanchikun, ");
INSERT INTO qvcNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","suwakun, suqpa imangunata ancha munanllapa. Wakinqam malnaturalkuna. Wakinqam mishki mishkita parlachishpa, ingañakunllapa. Wakinqam kwirpunda mana sujitashpachu, munashqandalla ruranllapa. Wakinqam imapaqpis imbidyakunllapa. Wakinqam washa rimaykuna. Wakinqam palanganukuna. Wakinqam mana jwisyuyuqkuna. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yumbay chay mana baliq yuyaykunaqam runapa shunqombi tarikan. Chay laya mana baliqkunata yuyashpam, uchayuqna kidanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jisusqam chay kashqanmandaqa rirqanna (Isrrayilpa ladumbi kaq nasyunman. Chay nasyumba) Tiru llaqtamba, Sidun llaqtamba sirkanman ch'ayashpaqam, suq wasipina kidarqan. Jisusqam mana munarqanchu ni pipis yach'anambaq chaypi kashqanda. Piru dasmi yach'arqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Chaymi suq warmi Jisus chaypi kashqanda yach'ashpaqa, das shamushpa, ñawpambi qonqorikushpa, rrugarqan: —Taytitu, chinitaymanmi dyablupa ispiritun yaykushqa. Yush'ayku paymanda qatiy chay dyablutaqa, nishpa. Chay warmiqam chay suq nasyun Sirufinisya shutiqmanda kashpa, grigu rimaypi rimarqan. Manam isrraylinachu karqan. Chaymi chay warmitaqa Jisusqa nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","—Manam allichu isrraylinu masiykunata dijashpa, jwirakunata yanapanaypaqqa. Isrraylinu masiykunaqam wambraykunashina. Puntataqam wambranchiqkunata qaranchiq, ¿manachu? Manam allichu wambranchiqkunapa tandanda qoch'ishpa, allqetukunata puntata qarananchiqqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Chaymi chay warmiqa nirqan: —Arí. Chayshinam, Taytitu. Piru wambrakuna mesapi mikuptinqam, allqokunapis mesapa warambi tiyashpa, chay pidasitun ishkiqkunata mikunllapa. (Chayshinam alli kanman, noqaykunatapis ashlitata yanapawanayki,) nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Chaymi Jisusqa chay warmita nirqan: —Allitam kuntistawashqa kangi. Chaymi rini yanapashuq. Atinginam riyta. Dyabluqam wawaykimandaqa lluqshishqana, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Chaymi chay warmiqa wasinman kutirishpaqa, chay wawandaqa kamambi tarirqan kach'akashqatana. Chaqa paymandaqam dyabluqa lluqshishqana karqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jisusqam chay Tiru llaqta ladumanda rishpaqa, chay prubinsya Sidunda, chay prubinsya Dikapulista pasashpa, ch'ayarirqan chay Galiliya Atun Qoch'aman. Nuta: Chay shutin “Dikapulismi” munan niyta: Dyis llaqtakunapa prubinsyan, nishpa.  ");
INSERT INTO qvcNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Chayman ch'ayaptinqam, Jisusman apamurqanllapa suq surdu mudu runata. Ch'ayachimushpaqam Jisusta rrugarqanllapa, chay runapa sawambi makinda rurashpa, kach'akachinambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Chaymandaqam Jisusqa chay runata suq laduman apashpa, rinringunaman didungunata rurarqan. Tuqayninwan didunda nuyuchishpa, qallunman rurarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Chaymandaqam anaq syiluman chapakushpa, llakishpa, samayninda kach'ashpa nirqan: —¡Ifata! Chayqam munan niyta: “¡Kich'akay!” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Chayshina niptinqam, chay runaqa surdu kashqanmanda chay uras uyakurqanqa. Kanan mudu kashqanmandapismi, chay uras dasna atirqan rimayta. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kanan Jisusqam yumbay chaypi kaqkunata nirqan: —Kay runata kach'akachishqaypaqqa amakish ni pitapis willangillapachu, nishpa. Chayshina kutin kutin niptimbismi, paykunaqa mana kasushpachu, ashwamba chay famata parlachikurqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Chaymi runakunaqa: ¿Ima laya runataq chayqa? nishpa, ancha ispantashqata Jisusta kayshina alabaqllapa: —¡Rikay kay runaqa! Tukuy imata allita yach'an rurayta. Surdukunatam uyachin. Mudukunatam rimachin, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Chay tyimpupim ancha achka runa, warmi Jisusman shamurqanllapa. Kanan manam nimapis waqpiqa karqanchu mikunanllapa. Chaymi Jisusqa yach'akuqningunata qayashpa nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Ancham llakini kay uyawaqkunapaq. Chaqa kaypiqam kimsa diyana noqawan kashqallapa uyawanambaq. Kanan paykunaqam mana nimayuqchu mikunanllapaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Piru mallaqtalla wasinman kach'aptiyqach'i, shaykushpa ñambi binsikanmanllapa. Llalli wakinqam ancha karumanda shamushqallapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Chayshina niptinqam, yach'akuqningunaqa nirqan: —¿Imatamir qarashun kay chunchapiqa? Chaqa kaypiqam mana pipis tiyanchu, mikunata randichiwananchiqqa, paykunata qarananchiq. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Chayshina niptinmi, Jisusqa tapurqan: —¿Ayka tanditayuqmi kangillapa? nishpa. Chaymi paykunaqa nirqan: —Syiti tanditayuqllam kanillapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Chayshina niptinqam, Jisusqa yumbay chay runata, warmita kamachirqan, waqpi kaypi pambapi tiyananllapa. Chaymandaqam chay syiti tanditata piskashpa, Tayta Dyusta pagikurqan. Chayshina pagikushpaqam, tanditakunata piti piti rurashpa, yach'akuqningunata qorqan, paykunana yumbay runata, warmita qarananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Karqambismi piskaditukuna. Chaykunapaqpismi pagikushpa, yumbayta qarachirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Chayshina qarachiptinqam, yumbay runa, warmi undanangaman mikurqanllapa. Chaymandaqam chay subrataqa syiti kanastakuna undata tandarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Chay mikuqkunaqam ullqokunalla 4.000ch'i karqan. Chaymandaqam yumbayta dispidishpa, dijarqanna rinanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Chayshina yumbay riptinqam, Jisusqa yach'akuqningunawan yakupi puriq barkupi rirqanllapa Dalmanu lugarmanna. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Chay Dalmanu lugarpina kaptinqam, farisiyu duktrinayuqkunaqa Jisusman shamurqanllapa. Chaymi Jisusta uyashpaqa, payta mallipashpa nirqanllapa: —Manam chayshinachu. Kayshinám. Mayá, qam Dyusmanda shamuq kashpaqa, suq milagru syilumanda kaqta ruray rikanayllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Chaymandaqam Jisusqa shunqombi ancha llakishpa nirqan: —Kay runakunaqa ¿imaraykutaq munanllapa milagrukunata ruranayqa? Alliptam niykillapa, manam rinichu ruraq nima laya milagrukunata, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Chaymandaqam chay farisiyukunamanda akrakashpa, Jisusqa yakupi puriq barkupina rirqan chay atun qoch'apa suq manyanman. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Rishpaqam, Jisuspa yach'akuqningunaqa tandata mana randishqallapachu karqan. Kanan fyambrinda qonqashpam, suq tanditayuqlla riykarqanllapa yakupi puriq barkupiqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Chaypim Jisusqa paykunata nirqan: —Farisiyukunapa libaduranmanda, gubyirnu Irudispa libaduranmandaqa kwidakayllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Chayshina kunaptinqam, Jisuspa yach'akuqningunaqa paykunapura kayshina parlarqanllapa: —¿Imapaqraq chayshinaqa niwanchiq? Mana tandayuq kaptinchiqch'i, chaytaqa niwanchiq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Chayshina parlaptinqam, Jisusqa tapurqan: —¿Imaraykutaq niykangillapa: “Manam tandayuqchu kanchiq” nishpaqa? ¿Ima, manachu intyindingillapa? ¿Ima manachu jwisyuyuq kangillapa? ");
INSERT INTO qvcNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Ima manachu ñawikillapawan rikashqallapa kangi chay rurashqaytaqa? ¿Ima manachu rinrikiwan uyawangillapa? ¿Ima manachu nimatapis yuyangillapa? ");
INSERT INTO qvcNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Mayá, chay sinku tanditata piti piti ruraptiy 5.000 runakuna mikuptinqa, ¿ayka kanastakuna undataq subrarqanqa? nishpa. Chayshina tapuptinqam, paykunaqa nirqan: —Dusi kanastakuna undam subrarqanqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Chaymandaqam Jisusqa tapurqan: —Mayá, chay syiti tanditata piti piti ruraptiy 4.000 runakuna mikuptinqa, ¿ayka kanasta undataq subrarqanqa? nishpa. Chayshina tapuptinqam, paykunaqa nirqan: —Syiti kanastakuna undam subrarqanqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Chaymi Jisusqa nirqan: —¿Ima manaraqchu intyindingillapa? nishpa. Nuta: Jisukristuqam mana tandapaqchu rimarqanqa. Ashwanmi nirqanqa: “Ashla libadurallam saksachin achka masata. Chayshinallam chay farisiyukunapa mana baliq kustumbringunata ashlitatalla ruraptinchiqqa, ancha dañachiwanchiqman”, nishpa.  ");
INSERT INTO qvcNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Chaymandaqam Bitsayda llaqtamanna ch'ayarqanllapa. Chay llaqtapi Jisus kaykaptinqam, suq sarku runata apamurqanllapa, ñawingunata kach'akachinan. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Chaymi Jisusqa chay sarkuta rambashpa, chay llaqtamanda sawa chunchaman aparqan. Chay chunchapiqam chay runapa ñawingunata tuqayninwan nuyuchishpa, makingunata sawambi rurashpa, tapurqan: —Mayá, ¿atinginachu imatapis rikayta? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Chayshina tapuptinqam, chay runaqa ashla rikakushpaqa, nirqan: —Salqetatam runakunata rikani muntikuna puriykaqtashina, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Chaymi Jisusqa chay runapa ñawinda suq kutinda llamkarirqan. Chay urasllam ñawingunaqa allitana chapakurqan. Chaymi tukuy imata atirqanna rikayta. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Chayshina rikakuptinqam, Jisusqa chay runataqa kamachirqan: —Riyna wasikiman. Piru amakish chay llaqtamanqa ringichu. ˻Amakish ni pitapis nimatapis ningichu, nishpa.˼ ");
INSERT INTO qvcNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Chaymandaqam Jisusqa yach'akuqningunawan rirqan prubinsya Sesarya Filipupa kasiriyungunaman. Riqshinam ñambi yach'akuqningunata tapurqan: —Runakunaqa, ¿imatam nin noqapaqqa? ¿Pish kani paykunapaqqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Chaymi paykunaqa nirqan: —Wakinqam nin, Jwan Shutichikuqshi kangi. Wakinqam nin, Dyuspaq unay rimaq Eliyasshi kangi. Wakinqam nin, Dyuspaq suq rimaqshi kangi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Chayshina niptinllapaqam, paykunata tapurqan: —Mayá, qamkunaqa ¿imatataq ningi? ¿Pitaq kani qamkunapaqqa? nishpa. Chaymi Pidruqa nirqan: —Qamqam Dyus Akrashqan Washadurniyllapa kangi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Chayshina niptinqam, Jisusqa kamachirqan: —Amakish ni pitapis chaytaqa ningillapachu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Chaymandaqam Jisusqa yach'akuqningunata nirqan: —Noqaqam Dyusmanda Shamuq Runa kashpa, ancha rini padisiq. Kanan kamachikuq ansyanukuna, kamachikuq isrraylinu kurakuna, Muysispa liyningunata yach'achikuqkunam mana baliqpaq riqsiwashpa, rinllapa wanchiwaq. Piru wanchiwaptinllapam, kimsa diyamanda rini kawsamuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Chayshina paykunata ancha klaruta niptinqam, Simun Pidruqa suq laduman sapalanda apashpa, Jisusta nirqan: —Ama chayshinaqa rimaychu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Chayshina niptinmi, Jisusqa das tikrakashpa, yach'akuqningunata chapashpa, Pidruta kayshina anyarqan: —¡A dyablu! ¡Ladiyay ñawpaymanda! Chaqa qamqam dyablushina mana munangichu ruranaypaq Taytay Dyus munashqanda. Kanan Dyuspi mana kriyiqkunashinam qamqa yuyaykangi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Chaymandaqam yach'akuqningunata qayashpa nirqan: —Mayqan runa yach'akuqniy munashpa kaytaqa, noqa munashqayta ruranqa. Amana ruranqachu pay munashqandaqa. Noqapi kriyishqanrayku suq kruspi munaptinllapa wanchiytapisri, noqatalla sigiwanqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Chaymi mayqanniki noqata ñigawashpa bidaykita washanaykiqa, ringi chingaq tukuy tyimpupaq. Piru noqapi ichu Dyus nishqambi kriyiptiki wanchishuptinllapaqam, noqa rini washashuq, tukuy tyimpu noqawan kawsanayki. ");
INSERT INTO qvcNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Piru suq runa ichu suq warmi kay mundupa tukuy imanda ch'askishpa, piru jwisyu diyapi chingashpaqa, ¿imapaqtaq balinman? ");
INSERT INTO qvcNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mayá, chay wañushqaqa, ¿aykatam pagarakunman washakananqa? ");
INSERT INTO qvcNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Chaymi qamkuna Dyusta kuntraq uchayuq runakunapa ñawpambi noqapaq ichu noqa nishqaypaq penqakushpaqa, kayta yach'ayllapa: Dyusmanda Shamuq Runa Jisukristum syilumanda rin kutimuq suq ancha kamachikuq gubyirnushina, Tayta Dyuspa llipyayninwan llipyashpa, paypa santu anjilningunawan. Chay diyaqam paypis noqapaqqa rin penqakuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Kayshinapismi Jisusqa nirqan: —Alliptam niykillapa, kaypi wakin kaqkunam manaraq wañushpa, Taytaypa pudirninda rinllapa rikaq, pay ancha jwirsayuq kamachikuptin, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Sayis diyas pasaptinmi, Jisusqa rirqan suq atun lumapa sawanman. Chaymanqam pullan aparqan Pidruta, Jakubuta, Jwanda. Chay lumapina kashpaqam, Jisusqa paykunapa ñawpambi suq layayarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kapanqam ancha yuraq llipyaykaq ˻qasashina˼ tikrakarqan. Kay mundupi mudananda mayqan taqshashpapismi, mana pipis atinmanchu chay layata yuraqyachiytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Chaymandaqam chay kimsa yach'akuqninqam chapaykashpa rikarqan Eliyasta, Muysista Jisuswan parlaykaqta. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Chaymi paykunaqa ancha mancharqanllapa. Chayshina manchashpam, Pidruqa Jisusta nirqan: —Yach'achikuq Taytitu. Ancha alliraq kaypi kananchiqqa. Rurashaqllapa qamkunapaq kimsa chugllata: suqta qambaq, suqta Muysispaq, suqta Eliyaspaq, nishpa. Piru Pidruqam manchashpa, chay rimashqambaqqa mana yach'arqanchu: ¿Imatam rimaykani? nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Chaykamanqam paykunapa sawambi pukutay rikakushpa, limpu pambarqan. Chay pukutaypa ukunmandam Tayta Dyus Churin Jisuspaq nirqan: —Kaymi kuyashqay Churiy. Payta uyayllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Chaymandaqam chay uras rridurninllapaman chapakushpaqa, Jisuswan chay ishkay parlaykaqtaqa manana rikarqanllapachu. Jisustallanam rikarqanllapaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Chaymandaqam chay lumamanda shamuqshina, Jisusqa chay kimsa yach'akuqninda nirqan: —Qamkuna rikashqaykitaqa amaraq ni pitapis parlachiyllapachu wañushqaymanda kawsamunaykaman, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Chaymi paykunaqa mana ni pitapis parlachirqanchu. Piru paykunapuram tapunakurqan: —¿Imaraq munan niyta: “Wañushqaymanda kawsamunaykaman”, nishpa? ");
INSERT INTO qvcNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Chayshina parlashpaqam, Jisusta tapurqanllapa: —Muysispa liyningunata yach'achikuqkunaqa ¿imaraykum nin: “Eliyasmi puntata rin shamuq. (Chaymandaraqmi Dyus Akrashqan Washadurqa rin shamuq”, nishpaqa?) ");
INSERT INTO qvcNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Chaymi Jisusqa nirqan: —Allibmi Eliyas puntata shamun tukuy imata allichaq. Piru Dyuspa Santu Librumbiqa ¿imatataq nin Dyusmanda Shamuq Runapaq? Chaypiqam nin: “Shamuptinqam, runakunaqa mana baliqpaq rinllapa riqsiq. Kanan ancham rin padisiq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Piru noqaqam niykillapa, Eliyasqam shamushqana. Shamuptinqam, runakunaqa mana llakipashpachu, paykuna munashqanda rurarqanllapa. Chaqa Dyuspa Santu Librumbim paypaqqa nishqa karqan: Rinmi padisiq, nishpa. Nuta: Jisukristuqam chayshina Jwan Shutichikuqpaq parlachikurqan Eliyaspa shutinwan. Payqam Eliyasshina karqan. Rikay Matiyu 17.13pi.  ");
INSERT INTO qvcNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jisusqam chay kimsa yach'akuqninwan kutimushpaqa, chay wakin yach'akuqningunata ancha achka runakunawan kaykaqta tarirqan. Chaypim Muysispa liyningunata wakin yach'achikuqwan anyanakuykarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Chay runakunaqam Jisusta ch'ayaykaqta rikashpaqa, ispantashqata kallparqanllapa napaykuq. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Chaymi Jisusqa paykunata tapurqan: —¿Imapaqmi paykunawanqa qamkunaqa anyanakuykangillapa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","18","Chayshina tapuptinqam, chaypi kaq suq runa nirqan: —Yach'achikuq taytitu, dyablum churiyta muduyachishpa, atakikunata qon. Chaymi qaman apamurqay kach'akachinayki. Chaqa chay dyablu chay atakikunata qoptinmi, maypipis churiyqa bulakan. Kanan babash'kunatam sitakuchin. ¡Kirungunatam qech'yachin! Kanan limpunam ishkin. Chaymi yach'akuqnikikunata rrugarqani, kay churiymanda chay dyabluta qatinambaq. Piru paykunaqam mana atishqallapachu qatiyta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Chaymi Jisusqa nirqan: —¡A, qamkuna Dyuspi mana yuyakuqkuna! ¿Ima tyimpukamanraq qamkunataqa agwantashqayki? Mayá, chay wambraykita kayman apamuyllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Chayshina paykuna apamuptinqam, chay dyablu Jisusta rikashpa, atakikunata qorqan chay wambrataqa. Chaymi chay wambraqa pambaman bulakashpa, bulatikashpa, babash'kunata sitakurqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Chaymi Jisusqa paypa taytanda tapurqan: —Kay churikiqa, ¿ima tyimpumandapacham kayshinaqa? nishpa. Chaymi chay runaqa nirqan: —Takshitanmandam kayshinalla. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kanan kutin kutinmi chay dyabluqa kay wambrituytaqa ninaman yakuman bulan wanchinambaq. ¡Chayri llakipawashpa yush'ayku, atishpaqa kach'akachiy kay wambraytaqa! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Chayshina niptinqam, Jisusqa nirqan: —Noqapi yuyakuptikiqam, tukuy imata atini rurayta. Piru ¿atingichuraq noqapi yuyakuytaqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Chaymi chay runaqa qayach'akushpa nirqan: —¡Qambim yuyakuni! ¡Piru yanapawayri, masta yuyakunaypaq! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Chayshina niptinqam, Jisusqa achka runa shamuqta rikashpa, utqaymaya chay dyabluta kayshina anyarqan: —¡Qam surdu mudu dyabluqa, noqa kikiymi kamachiyki, lluqshiy kay wambramanda! ¡Amakish yaykuringichu! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Chayshina nishpa qatiptinqam, chay dyabluqa qayach'akushpa, atakikunata qoshpa, chay wambramanda lluqshirqan. Lluqshishpaqam wañushqatashina dijarqan. Chaymi rikaqkunaqa nirqan: —¡Jwira, wañurqannam wambraqa! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Piru Jisusqam wambrataqa makinmanda piskashpa shayachirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Chaymandaqam Jisusqa yach'akuqningunawan yaykurqanna suq wasiman. Chaypi mana pipis kaptinqam, paykunalla Jisusta tapurqanllapa: —Noqaykunaqa, ¿imaraykutaq mana atirqayllapachu qatiyta chay dyablutaqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Chaymi Jisusqa nirqan: —Chay laya ancha wapu dyablukunataqam mana chayshinallaqa atinchiqchu qatiytaqa. Dyuspi ancha yuyakuqkunallam payman ancha mañakushpa, ˻ayunashpa˼ atin qatiytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jisusqam chay kaykashqanmanda rishpaqa, pasarqan prubinsya Galiliyapa lugarningunata. Piru payqam mana munarqanchu ni pipis yach'anambaq chayman riykashqandaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Chayman riqshinaqam chay yach'akuqningunata nirqan: —Noqa Dyusmanda Shamuq Runatam kuntrawaqkunapa makinman rinllapa intrigakuwaq. Chaymi wanchiwanqallapa. Chayshina paykuna wanchiwaptimbismi, kimsa diyamanda rini kawsamuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Piru Jisus chayshina niptinqam, chay yach'akuqningunaqa mana nimatapis intyindirqanchu: ¿Imapaqmi chaytaqa niykan? nishpaqa. Kanan tapuq purishpapismi, manchashpa, mana ni tapurqanllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Chayshina rishpaqam, Kapirnawun llaqtamanna ch'ayarqanllapa. Chayman ch'ayashpaqam, suq wasimanna yaykurqanllapa. Chaypi kashpaqam, Jisusqa yach'akuqningunata kayshina tapurqan: —¿Qamkunaqa imapaqmi ñambiqa anyanakurqayki? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Chaqa paykunaqam ñambiqa anyanakushqaqa karqan: “Mayqanninchiqmi mas baliqqa kanchiq”, nishpa. Chaymi tapuptinqa, paykunaqa penqakushpa, uyararqanllana. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Chaymandaqam Jisusqa chay dusi yach'akuqninda qayashpa, tiyashpa, nirqan: —Chay mas baliq munaq kaytaqa, umildiyashpa, yumbayta sirbinqa kriyadushina, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Chaymandaqam suq wambrituta apashpa, paykunapa ch'awpimbi marqashpa nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Mayqan runa kasuwashpa kay laya wambrituta ch'ayachiqqam, alabis noqata ch'ayachiwaykanmanshina. Piru manam noqatallachu ch'ayachiwaykanqa. Ashwanmi Taytay Dyustapis ch'ayachiykanqa. Chaqa paymi kach'amuwashqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Chaymandaqam yach'akuqnin Jwanqa nirqan: —Yach'achikuq Taytitu, rikashqallapam kani suq runata qamba shutikita myintashpa, dyablukunata runakunamanda qatiykaqta. Piru chay runaqam mana noqanchiqwanqa purishqachu. Chaymi nirqayllapa, ama chayshina ruranambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Chayshina niptinqam, Jisusqa nirqan: —Dijayllapa chayshina ruranambaq. Chaqa mayqan ruraq suq milagruta shutiyta myintashpaqam, mana kuntrawanchu. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mana kuntranchiq kaqkunaqam, faburninchiq. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Chaymi allipta niykillapa, mayqan runa ichu warmi shutiyta myintashpa, ashla yakituta qoshuptin noqapa kashqaykiraykum, Dyus kikin rin pagaraq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Noqapi chayraq kriyiqkunata uchata rurachiqqam ancha kastigadu rin kaq. Chaymi chay uchata rurachiqpaqqa mas alli kanman suq atun mulinu rumita kungambi watashpa, mar yakuman wichukunanllapa (manaraq chay uchata rurachiptin, ama mas kastigadu kanambaq). ");
INSERT INTO qvcNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Chayri makiki ancha qawch'u kaptin uchata ruranambaqqa, kuchushpa wichukuy. Chaqa mas allim kanman, syiluman manku ch'ayanayki. Manam allichu ishkay makiyuq kashpa, uchaykirayku infyirnu mana nunka wañuq ninaman rinaykipaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","46","Chayshinalla ch'akiki munaptin apashuyta uchata ruranaykiqa, kuchushpa wichukuy. Mas allim kanman, kuju ch'ayanayki syiluman. Manam allichu ishkay ch'akiyuq kashpa, uchaykirayku chay mana nunka wañuq infyirnu ninaman rinaykiqa. ˻Chaqa infyirnupiqam mana nunka wañunqachu chay kuru mikushuqkunaqa. Chaypi chay nina lumyaqpismi mana nunka wañunqachu.˼ ");
INSERT INTO qvcNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ñawikiwan imata rikashpa, uchata munaptiki ruraytapis, mas allim surqoshpa wichukunayki. Chaqa mas allim chulla ñawiyuqlla kashpa, syiluman ch'ayanayki. Manam allichu ishkay ñawiyuq kashpa, uchaykirayku infyirnuman rinaykiqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Chaqa infyirnupiqa kuru mikushuqkunaqam mana nunka rinchu wañuq. Chay nina lumyaykaqpismi mana nunka rinchu wañuq. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’(Manchu aychamanqa kach'ita wichunchiq, ufrinda kanambaq.) Chayshinallam runakunapa sawanman kach'itashina ninataqa rinllapa ruraq, (uchanmanda akrakanambaq). Chaqa yumbay ufrindakunam kach'iwan allichadu rin kaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Piru kach'iqam allin kashpapis dañakashpaqa, manana nimapaq balinchu, ¿manachu? Chaqa ¿imashinanam atinchiqman allichaytaqa? Piru qamkuna kuyanakushpaqam, allin kach'ishina kangillapa. Chayri shumaqta kuyanakushpa kawsayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Chay Kapirnawun llaqtamandaqam Jisus rirqanna prubinsya Judiyaman, rriyu Jurdamba waq ladu chimbanman. Chaypim ancha achka runakuna, warmikuna Jisusman tandakarqan. Chaypipismi paykunata Taytanchiq Dyuspaq yach'achirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Wakin farisiyu duktrinayuqpismi tandakarqanllapa Jisusman, mana atiypaq tapunakunata tapunanllapa, mana allita kuntistaptin, tumbananllapa. Chaymi kayshina tapurqanllapa: —Mayá, ¿suq runachu atin warminmanda akrakayta ichu mana? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Chaymi Jisusqa paykunata nirqan: —Mayá, ¿imatam Dyuspaq unay rimaq Muysisqa chaypaqqa kamachikurqan? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Chaymi paykunaqa nirqan: —Muysismi nirqan, suq runa warminmanda munashpa akrakaytaqash, suq kartata qoshpa, atin akrakayta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Chayshina niptinllapaqam, Jisusqa nirqan: —Unay agwilunchiqkunaqam qamkunashina Dyustaqa mana munarqanchu kasuyta. Chaymi Muysisqa ancha angu shunqoyuq kaptinllapa, paykunata kamachirqan, chay kartata qonanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Piru Dyusqam mana munanchu chayshina rurananchiqqa. Chaqa kay pachata tukuy imata rurashpaqam, suq ullqota, suq warmita rurarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Chaymi chay tyimpumandapacha suq ullqoqa taytanmanda, mamanmanda akrakashpa, warminwanna tandakashpa tiyan. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Kanan ishkay kashpapismi suqshinallana tiyanllapa. Mananam ishkayshinachu. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Chayri runakunaqa Dyus tandashqandaqa ama akranqallapachu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Chaymandaqam Jisuswan wasipina kashpallapaqa, chay yach'akuqningunapis chay nishqambaq tapurqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Chaymi Jisusqa nirqan: —Mayqan runa warminmanda akrakashpa, suq warmitana tandaqqam, punta warminda traysyunda ruraykan. Chaymi ancha uchayuqna chay runaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Warmipismi runanmanda akrakashpa, suq runawan kashpaqa, chay punta runanda traysyunda ruraykan. Chaymi chay warmipis ancha uchayuqna. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Achka runa, warmim wambritungunata apamurqanllapa Jisusman, sawambi makinda rurashpa, Dyusman mañakunambaq. Piru yach'akuqningunaqa wambran apamuqkunata anyarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Chayta uyashpaqam Jisusqa piñakushpa, yach'akuqningunata nirqan: —Dijayllapa chay wambritukuna noqaman shamunambaq. Ama arkayllapachu. Chaqa Tayta Dyus shumaqta kamachikuptinqam, kay wambritushina kaqkuna paywan rinllapa kawsaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Alliptam niykillapa, kay umildi wambritushina kaqkunallam tukuy tyimpu rin kawsaq Dyuswanqa; manaqa manám. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Chayshina nishpaqam, wambritukunata marqashpa, makinda sawanman rurashpa, Dyusman mañakurqan, chay wambritukunata yanapanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jisukristu riykaptinnam, suq runa kallpaylla ñawpanman ch'ayamushpa, qonqorikushpa, tapurqan: —Ancha allin Yach'achikuq Taytitu, ¿imatam atini rurayta, Taytanchiq Dyuswan tukuy tyimpu kawsanaypaqqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Chaymi Jisusqa tapurqan: —¿Imaraykutaq niwangi: “Ancha allin Yach'achikuq”, nishpaqa? Dyusllam ancha allinqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Qamqam Dyus kamachikushqandaqa allita yach'angi. Paymi nin: “Qam warmiyuq kashpaqa, ama suq warmiwanqa puñuychu; ama wanchikuychu; ama suwakuychu; ama llullakuychu suqkunapaq; ama pitapis ingañaychu, imanda qoch'inayki; taytaykita, mamaykita ancha rrispitay”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Chayshina niptinqam, chay runaqa nirqan: —Yach'achikuq Taytitu, yumbay chay niwashqaykitaqam wambraymandapacha kumplishqa kani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Chaymi Jisusqa chapashpa, chay runata ancha kuyashpa, nirqan: —Kaysitullam faltashungi. Tukuy imaykita randikushpa, mana nimayuqkunata qoy. Chayshina qoshpaqam, syilupiqa tukuy imayuqna ringi kaq. Chayta rurashpaqar shamuy, noqawan purinanchiq. ˻Awnki kruspi munaptinllapa wanchishuytapis, noqatalla kasuway,˼ nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Chayshina Jisus niptinqam, chay runaqa limpu malaganayarqan. Chaqa tukuy imayuq kashpam, chay imangunapaq llakishpa, kutirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Chaymandaqam Jisusqa rridurninman chapakushpa, yach'akuqningunata nirqan: —¡Ancha trabajusraq, kapuqkuna Dyusta kasunanllapa, paywan tukuy tyimpu kawsananllapaqa! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Chayshina niptinqam, yach'akuqningunaqa ancha ispantarqanllapa. Chaymi Jisusqa paykunataqa nirirqan: —Ijitukuna, ¡ancha trabajusraq waq kapuq runakuna, tukuy imangunapilla yuyakushpa, Dyusta kasunanllapa, paywan tukuy tyimpu kawsananqa! ");
INSERT INTO qvcNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Chaqa suq kapuq runa Dyusta kasunambaqmi ancha trabajus. Mas fasilmi kanman chay atun kamillu animal awjapa rinrinda pasanambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Chayta uyashpaqam, paykunaqa ashwamba ispantarqanllapa. Chaymi paykunapura ancha tapunakurqanllapa: —Chayshina kaptinqa, ¿pitaq atinman washakaytaqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Chaymi Jisusqa paykunata chapashpa nirqan: —Runakunallaqam mana nimatapis atinchu washakaytaqa. Piru Dyusqam tukuy ima munashqanda atin rurayta. Paypaqqam mana nimapis trabajuschu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Chaymi Pidruqa Jisusta nirqan: —Yach'achikuq Taytitu, noqaykunaqam tukuy imayllapata dijashqallapa kani, qamwan purinaypaqllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Chayshina niptinmi, Jisusqa nirqan: —Alliptam niykillapa, mayqan runa dijaq wasinda, masangunata, paningunata, taytanda, mamanda, warminda, wambrangunata, ch'akrangunata, noqa nishqayta kasuwashpa, nishqayta yach'achikushqanraykum, ");
INSERT INTO qvcNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","syin tantus masta rin ch'askiq kay mundupilla. Qesachadu kashpapismi, mas achka wasingunata, masangunata, paningunata, mamangunata, wambrangunata, ch'akrangunata kay mundupiqa rin ch'askiq. Chay ch'askishqanmandam syilupiqa Dyuswan tukuy tyimpu rin kawsaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Piru kay pachapi achka kamachikuqqam suq bidapiqa manana rinllapachu baliq. Piru kay pachapi achka mana kamachikuqkunam syilupiqa ancha kamachikuqkuna rinllapa kaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Chayshina yach'achikushpaqam, Jisusqa yach'akuqningunapa ñawpanda Jirusalin llaqtamanna riykarqan. Chaymi paykunaqa ancha manchashqata ikinda riykarqanllapa. Chaymi Jisusqa riqshina, chay dusi yach'akuqningunatalla suq laduman qayashpa, kayshina nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Rikay, kananqa riykanchiqna Jirusalinman. Waqpiqam noqa Dyusmanda Shamuq Runataqa rinllapa intrigakuwaq isrraylinu kurakunapa kamachikuqninman, Muysispa liyningunata yach'achikuqkunaman. Paykunam jwira runakunaman rinllapa intrigakuwaq wanchiwananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Chaypi paykuna asipawananraykum, kusas layata rinllapa rurawaq. Kanan tuqapawashpam, suq lastima chuqri chuqri maqawashpa, rinllapa wanchiwaq. Piru kimsa diya wañushqaymandam rini kawsamuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sibidiyupa chay churinguna Jakubuwan Jwanmi qemikashpa, Jisusta rrugarqanllapa: —Yach'achikuq Taytitu, suq faburta rurawayllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Chaymi Jisusqa nirqan: —Mayá, ¿imatam munangillapa, qamkunapaq ruranaypaq? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Chaymi paykunaqa nirqan: —Shumaqta llipyashpa, yumbaypa gubyirnun kashpaqar, yush'ayku kamachikuy, suqniy allin laduykipi, suqniy ichuq laduykipi tiyanayllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Chayshina paykuna mañakuptinqam, Jisusqa nirqan: —Qamkunaqam mana yach'angillapachu: Imatam mañaykanchiq, nishpaqa. Chaymi chaytaqa mañawangillapa. Chaqa noqaqam ancha rini ñakaq. Chay ñakaykunaqam noqapaqqa suq basu ancha ayaq yakuta upyaykaymanshina rin kaq. ¿Atingimanllapachu qamkunapis noqashina ñakayta? Chaqa kuntrawaqkunaqam ancha padisichiwashpa, rinllapa wanchiwaq. ¿Chayshinachu qamkunapis atingimanllapa padisiyta? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Chaymi paykunaqa nirqan: —Ariri. Atinillapam chayshina padisiyta, nishpa. Chaymi Jisusqa paykunata nirqan: —Alliptam qamkunapis chay ayaq yakuta upyaqshina ancha ringillapa padisiq. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Piru chayshina qamkuna padisiptikipismi, noqaqa mana atinichu kamachikuyta, allin laduypi ichu ichuq laduypi tiyanaykillapaqa. Taytay Dyusllam munashqanshina runakunata akrashqa, laduypi tiyananllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Chay Jakubuwan Jwan Jisusta mañashqanda chay dyis yach'akuq masinguna yach'ashpaqam, ancha piñakurqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Chayshina chay suqkuna piñakuptinqam, Jisusqa qayashpa, nirqan: —Chay suq nasyungunapa gubyirnungunam wapuyashpalla, manchachikushpa llaqta masingunata kamachinllapa, ¿manachu? ");
INSERT INTO qvcNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Piru qamkunaqa ama chayshinaqa kayllapachu. Ashwanri mayqanniki munashpa kamachikuytaqa, suq kriyadushina sirbiy chay suqnikikunata. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","45","Chaqa noqa Dyusmanda Shamuq Runa kashpapismi, mana shamushqachu kani runakuna sirbiwananqa. Ashwanmi shamushqaqa kani, suq kriyadushina runakunata sirbinaypaq, wañushpa, uchangunapaq pagarakushpa, paykunata washanaypaq. Chaymi niykillapa, mayqanniki mas baliq munashpa kaytaqa, chay suqnikikunata kriyadushina sirbiyllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jisusqam Jirusalinman riqshina, ch'ayarqan Jiriku llaqtaman. Chaymandaqam chay Jirikumanda yach'akuqningunawan ancha achka runakunawan riykaptinqa, suq sarku runa Bartimiyu shutiq ñamba ladumbi tiyaykarqan, limush'nata mañakushpa. Payqam Timiyupa churin karqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Chay Bartimiyuqam yach'ashpa: Jisus Nasaritmanda kaqshi kayta shamuykan, nishpaqa, ancha jwirtita qayakurqan: —¡Unay Dabidpa Karu Willkan Jisus, llakipawayri, yanapawayri! nishpa. Nuta: “Dabidpa Karu Willkanmi” munan niyta: “Dyus Akrashqan Washadur”, nishpa.  ");
INSERT INTO qvcNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Chayshina qayakuptinqam, achka runa anyarqan: —¡Uyaray! ¡Uyaray! nishpa. Anyaykaptimbismi, ashwamba qayakurqan: —¡Unay Dabidpa Karu Willkan, llakipawayri, yanapawayri! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Chaymi Jisusqa rishqanshina shayashpa nirqan: —Qayamuyllapa chay runata, nishpa. Qayamuqkunaqam Bartimiyuta nirqan: —Kushikushpa atariy. Jisusmi qayashungi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Chaymi payqa, kapanda utqaymaya wichukushpa, brinkashpa shamurqan Jisusman. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ñawpambina kaptinqam, Jisusqa tapurqan: —¿Imashinam munangi yanapashunayqa? nishpa. Chaymi chay sarku Bartimiyuqa nirqan: —Yach'achikuq Taytitu, yanapawayri rikakunaypaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Chaymi Jisusqa nirqan: —Atinginam riyta. Noqapi kriyishqaykiraykum allitana ringi rikakuq. Chayshina niptinllam, chay Bartimiyuqa atirqanna rikakuyta. Chaymi kushikushpana, Jisuswan rirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jirusalinman riqshinam, ch'ayarqanllapa chay llaqtakuna Bitanillapa (Bitaniyapa), Bitfajipa ladunman. Chay llaqtakunapa ñawpambim karqan Ulibu luma. Chay lugarpina kashpaqam, Jisusqa ishkay yach'akuqninda nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Rikay, waq ñawpanchiqpim suq kasiriyu. Waqman ch'ayashpaqam, ringillapa tariq suq burritu watashqata. Chay burrupiqam manaraq ni pipis purishqachu. Chay burrituta paskashpa, apamuyllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Piru mayqan tapushuptinllapa: “¿Imapaqmi apangillapa?” nishpaqa, niyllapa: “Siñurninchiqmi nisitan. Dasllam rin kutichimuq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Paykuna rishpaqam, allipta burrutaqa ñamba ladumbi suq wasipa pungumbi watashqata tarirqanllapa. Chaymi waskanda paskaykaptinllapa, ");
INSERT INTO qvcNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","chaypi kaqkunaqa tapurqanllapa: —¿Imatam ruraykangillapa? ¿Imapaqtaq paskangillapa burrutaqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Chaymi paykuna Jisus nishqanda niptinqa, dijarqanllapana apanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Chayshina ch'ayachishpa Jisus kashqanmanqam, paykunaqa kapangunata burritupa sawambi rurarqanllapa. Chayshina ruraptinqam, Jisusqa muntakushpana rirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ñandaqam achka runakuna Jisuspa ñawpanda riqllapa, kapangunata mandashpa. Wakinqam muntikunapa raprangunata kuchushpa, ñambi mandaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kanan ñawpanda riqkuna, ikinda riqkunaqam yumbaynin ancha kushikushpa, Jisuspaq kayshina kunyaqllapa: —¡Biba, biba! ¡Kushikushun, Washadurninchiq shamuykashqanrayku! ¡Taytanchiq Dyus ancha yanapanqa kay rrimplasun shamuykaqta! ");
INSERT INTO qvcNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Biba Washadurninchiq! ¡Chaqa shamushqam, noqanchiqkunata shumaqta kamachiwananchiq, chay unay gubyirnu Dabidshina! ¡Biba syilupi Taytanchiq Dyus! ¡Paytalla alabashun! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Chayshinam Jisusqa Jirusalinman ch'ayarqan. Chaypiqam yaykurqan Tayta Dyuspa adurana wasinman. Chay wasipi kashpaqam, tukuy imata ancha allita chaparqan. Chaymandaqam tardina kaptinqa, chay dusi yach'akuqninwan kutirqanna Bitanilla (Bitaniya) llaqtaman. ");
INSERT INTO qvcNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Qayandin, Bitanillamanda (Bitaniyamanda) kutiriqshina Jirusalinmanqam, Jisusqa mallaqnarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Chaymandaqam suq yura igusta rikarqan. Manaraq puqonan tyimpun kaptimbismi, chay igusqa raprayuqna karqan. Chaymi Jisusqa rirqan rikaq: Paqta puqoyniyuq, nishpa. Piru ch'ayashpaqam, raprangunatalla rikarqan. Manam nima puqoyniyuqchu karqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Chaymi Jisusqa chay igusta nirqan: —Mananam nunka ringichu puqoq, runakuna mikunambaq puqoynikitaqa, nishpa. Chay nishqandaqam uyarqan chay yach'akuqninguna. ");
INSERT INTO qvcNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Chaymandaqam Jisusqa Jirusalinman ch'ayashpaqa, Tayta Dyuspa adurana wasinman yaykurqan. Ukupiqam tarirqan achka randikuykaqta, randiykaqkunata. Achka nasyungunapa qellaynindapismi kambyaykarqanllapa. Chaymi Jisusqa yumbay paykunata animalnindinda sawaman qatirqan. Chay qellayta kambyakuqkunapa mesangunatam sh'ilya sh'ilya bularqan. Palumakunata randikuqkunapa iskañungunatapismi bularqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Wakingunaqam suq ñandashina dirichaqllana Dyuspa adurana wasimba patyumbiqa. Chaqa kusasningunata apashpam, suq punguta yaykushpa, suq pungutana lluqshiqllapa. Paykunatapismi Jisusqa anyarqan: —Kaytaqa ama puriyllapachu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Yumbay chaypi kaqkunatam nirqan: —Dyuspa Santu Librumbiqam nin: “Kay wasiyqam kanqa yumbay nasyunmanda kaqkuna noqaman mañakunanllapa”, nishpa. Piru qamkunaqam kay wasitaqa rurashqallapa kangi ladrungunapa mach'aynindashina, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Chayshina niptinqam, chay kamachikuq isrraylinu kurakuna, Muysispa liyningunata yach'achikuqkunaqa uyashpa, Jisustaqa mancharqanllapa. Chaymi anchana yuyarqanllapa: ¿Imashinaraq paytaqa atinchiqman wanchiyta? nishpa. Chaqa chaypi kaqkunaqam Jisusta ancha allita uyaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Piru tutayaptinqam, Jisusqa Jirusalin llaqtamandaqa Bitanilla (Bitaniya) llaqtamanna rirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Qayandin madrugadu kutiriykashpa Jirusalinmanqam, chay yura igustaqa ch'upandinna chakishqata rikarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Chaymi Pidruqa yuyashpa Jisus chay igusta anyashqanda nirqan: —Yach'achikuq Taytitu, rikay chay igus qayna anyashqaykiqa chakishqana. ");
INSERT INTO qvcNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Chayshina niptinqam, Jisusqa nirqan: —Taytanchiq Dyuspi allita yuyakuyllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Chaqa alliptam niykillapa, mayqan runa Dyuspi allita yuyakushpa kay urqqota niptin: “Ashuy kaymanda. Riy mar yakuman”, kamachiptinqa, chay nishqanshina rin kaq. Piru chay kamachikuqqar shunqombiqa ama nimata yuyanqachu: Mana imach'i chayshinaqa kanqachu, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Chaymi niykillapa, allita kriyishpa mañakuyllapa, yuyashpa: Dyusmi rin qowaq mañashqayta, nishpa. Chayshina mañakushpaqam, allipta ringillapa ch'askiq. ");
INSERT INTO qvcNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Piru Dyusman mañakunaykiqa, chay mana alli rurashuqta pirdunayllapa. Chayshina pirdunaptikiqam, syilumanda Tayta Dyus qamkunatapis uchaykikunamanda rin pirdunashuq. ");
INSERT INTO qvcNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","˻Chay imanachishuqta mana pirdunaptikiqam, syilumanda Taytanchiq Dyuspis mana rinchu pirdunashuq yumbay uchaykimandaqa.˼ ");
INSERT INTO qvcNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jirusalinman ch'ayashpaqam, Jisusqa Dyuspa adurana wasimbina puriykarqan. Chaypi puriykaptinqam, kamachikuq isrraylinu kurakuna, Muysispa liyningunata yach'achikuqkuna, wakin kamachikuq ansyanukunapis Jisusman tandakarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Kanan paykunaqam Jisusta kayshina tapurqanllapa: —¿Ima karguyuqtaq kangi? ¿Mayqan awturidartaq numbrashushqa, kaykunata ruranaykipaq kay adurana wasipiqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Chaymi Jisusqa nirqan: —Mayá, noqapis suq tapunata tapushqaykillapa. Chayta niwaptikiqam, noqapis nishqayki chay tapuwashqaykipaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Mayá, ¿pitaq Jwan Shutichikuqtaqa numbrarqan shutichikunanqa? ¿Dyuschu numbrarqan ichu runakunalla? Mayá, niwayllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Chaymi paykunapura suqnin suqnin kayshina parlarqanllapa: —¿Imatam ninchiqman? Chaqa niptinchiq: “Dyusmi Jwanda numbrarqan”, nishpaqach'i, Jisusqa niwashun: “Chayshina numbraptinqa, ¿imaraykutaq qamkunaqa mana kriyirqaykichu paytaqa?” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Piru: “Runakunallam numbrarqan”, niptinchiqqach'i, kay yumbay uyakuqkunaqa ¿imanachiwashun? nishpa. Chaqa chaypiqam ancha achka runakuna uyakuykarqan. Yaqqa yumbay paykunaqam kriyirqan: Dyusmi Jwanda allipta numbrarqan, nishpa. Chaymi chay awturidarkunaqa ancha mancharqanllapa chay uyakuqkunata. ");
INSERT INTO qvcNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mana imanayta atishpaqam, Jisusta nirqanllapa: —Manam yach'anillapachu, nishpa. Chaymi Jisuspis nirqan: —Tapushqaqta qamkuna mana niwashqaykiraykum, noqapis mana rinichu nishuq: “Kay laya karguyuqmi kani”, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Chaymandaqam Jisusqa kay kumparasyunda rurashpa nirqan: —Suq runash ancha achka ubasta tarpushpa, rridurninda muralla pirqata rurarqan. Chaymandaqash rumi kantiriyapi ush'kukushpa, suq pusuta rurarqan, ubasningunata kusichashpa, chaypi qapinambaq. Rurarqambisshi suq altu turrita, chay altumanda chay tarpudunda kwidanambaq. Chayshina rurashpaqash, partidaryungunawan tratukurqan, paykunana tarpudunda kwidanambaq. Chaymandaqash karumanna rirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Chaymandaqash kusicha tyimpu ch'ayamuptinqa, chay ch'akrapa dwiñunqa suq kriyadunda kach'arqan, paypa partinda apamunambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Piru chay kwidakuqkunaqash chay kriyadutaqa mana nimata qoshpachu, suq lastima maqaptinllapa, illaqllana kutirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Chaymandaqash chay dwiñuqa suq kriyadunda kach'arirqan, partinda apamunambaq. Chay kriyadu ch'ayaptimbisshi, chay kwidakuqkunaqa rumikunawan sitarqanllapa, umanda pakishtin. Kanan ima layash musyarqanllapa chay kriyadutaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Chayshina paykuna ruraptimbisshi, chay dwiñuqa suq kriyaduta kach'arirqan. Chaytaqash wanchirqanllapa. Chayshina paykuna ruraptimbisshi, chay dwiñuqa suqta suqta achka kriyadungunata kach'arqan. Piru chay kwidakuqkunaqash chay kriyadukunata mana ch'ayachishpachu, wakinda ancha maqarqanllapa, wakinda wanchirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Chay dwiñupaqash suq churinlla karqan. Paytaqash ancha kuyaq. Chaymandaqash chay kuyashqan churindana kach'arqan, yuyashpa: Kay churiytaqam kasunqallapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Piru chay runakunaqash yaqqana ch'ayaykaqta rikashpaqa, kayshina parlarqanllapa: “Chay churinqam irinsyiru rin kaq. Chayri akullapa wanchiq, noqanchiqkunana piskananchiq kay ch'akrandaqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Chayshina parlashpash, chay churindaqa wanchirqanllapana. Chaymandaqash chay ch'akranmanda sawa ladumanna wichukurqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Chayshina nishpaqam, Jisusqa chay uyakuqkunata tapurqan: —Mayá, chay ch'akra dwiñuqa ¿imanachinqaraq chay ch'akrambi tiyaqkunataqa? Payqam shamushpa, yumbayta wanchishpa, suqkunatana ch'akrandaqa minganqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Dyuspa Santu Librumbim kan suq kumparasyun kay kumparasyunshina. ¿Manachu liyishqallapa kangi? Chaypiqam nin: Albañilkuna wichukushqan rumiqam mas allin rumi simyintupaq rin kaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Chaqa Tayta Dyusmi chay rumitaqa akrashqa, mas baliq kanambaq. Chayshina akrashqanraykum ancha ispantashqata kushikunchiqllapa, nishpa. Nuta: Chay ishkay kumparasyunda rurashpaqam, kayshina yach'achiwanchiq: Ch'akra dwiñuqam Taytanchiq Dyus. Chay ch'akra dwiñupa churinqam Jisukristu. Chay wanchikuq partidaryukunaqam chay mas kamachikuq isrraylinu kurakuna. Ch'akra dwiñupa kriyadungunaqam Dyuspaq rimaqkuna. Chay albañilkunapismi chay kamachikuq isrraylinu kurakuna. Chay wichukudu rumipismi Jisukristu, nishpa.  ");
INSERT INTO qvcNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Chay awturidarkuna Jisusta uyashpaqam, intyindirqanllapa: Jisusqam noqanchiqkunapaq chaytaqa niykan, nishpa. Chaymi piñakushpa, ancha yuyarqanllapa Jisusta prisunanllapa. Piru chaypi kaqkunata manchashpam, mana prisurqanllapachu. Chaymi Jisuspa ñawpanmandaqa ladiyarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Chaymandaqam chay kuntraqkunaqa kach'amurqan wakin farisiyu duktrinayuqkunata, gubyirnu Irudispa wakin partidungunata, imapaq Jisusta tumbashpa prisunanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Chaymi chay kach'adukuna ch'ayamushpaqa, mishki mishkita kayshina Jisusta parlachirqanllapa: —Taytitu, noqaykunaqam yach'ani: Qamqam allip kaqtalla rimangi. Chaqa qamqam mana nima pudirniyuq runata manchashpachu ni sawachashpachu, Dyus munashqandalla yach'achikungi. Mayá, niwayllapa: ¿Allichu gubyirnu Sesarta kuntribusyunda pagarananchiq, ichu mana? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Piru Jisusqam yach'arqan: Yanqam kaykunaqa tapuwaykan, nishpa. Chaymi paykunata tapurqan: —¿Imapaqmi tapuwangillapa, chaypaq tumbawashpa, prisuwanaykillapaqa? Mayá, suq qellayta apamuyllapa rikanaypaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Chayshina niptinqam, paykunaqa suq qellayta qorqan. Chaymi Jisusqa chay qellayta chapashpaqa nirqan: —¿Pipa rritratunmi kay qellaypiqa? ¿Pipa shutindam iskibrishqa kay qellaypiqa? nishpa. Chaymi paykunaqa nirqan: —Chay mas kamachikuq gubyirnu Sesarpa rritratunda, shutindam rurashqa kay qellaypiqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Chaymi Jisusqa paykunataqa nirqan: —Sesarpa kaqtaqa, Sesarta qoyllapa. Dyuspa kaqtaqa, Dyustalla qoyllapa. Chayshina niptinqam, ancha ispantarqanllapa, ancha yach'ayniyuq kashqanrayku. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Chaymandaqam sadusiyu duktrinayuqkuna Jisusman shamurqanllapa. Paykunaqam kriyinllapa: Wañushqakunaqash manana rinchu kawsamuq, nishpa. Chaymi Jisusta tapurqanllapa: ");
INSERT INTO qvcNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Yach'achikuq Taytitu, chay unay Muysismi librumbi iskibrishpa kamachikushqa, suq warmiyuq runa manaraq wambrayuq kashpa wañuptinqa, chay almapa masanna biyudawan kasaranqa, chay biyudapi wambrayuq kaptin, chay alma masamba wambranshina kanambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Chaymi munanillapa tapushuyta: Suq ayllupish syiti ullqo masapura karqan. Chay syitimanda kulaka masanqash warmikurqanna. Piru manaraq wambrayuq kashpash wañurqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Chayshi wañuptinqa, chay almapa minur masanna biyudawanqa kasararqan. Chay masambisshi manaraq wambrayuq kashpa, wañurqan. Chaymandaqa mas minur masanna biyudawanqa kasararqan. Paypisshi manaraq wambrayuq kashpa, wañurqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Chayshinash syitindin chay warmiwan kasararqanllapa. Piru manash ni mayqannin chay warmipiqa wambrayuq kashpachu wañurqanllapa. Chaymandaqash chay warmipis wañurqanna. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Chayshina wañuqkuna allipta kawsamuptinqach'i, ¿mayqannimba warminraq kanman? Chaqa syitindimba warminshi kashqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Chayshina tapuptinllapaqam, Jisusqa nirqan: —Qamkunaqam Dyuspa Santu Librun nishqanda mana intyindishpa, ni Dyus pudirniyuq kashqambaq yach'ashpa, ancha pandashqa kangi: (Wañushqakunaqam mana kawsamunqachu, nishpa). ");
INSERT INTO qvcNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Chaqa wañushqakuna kawsamushpaqam, manana warmiyuqchu ni runayuqchu rinllapa kaq. Chinangunatapismi manana rinllapachu kasarachiq. Ashwanmi Dyuspa anjilningunashina manana kasarashpachu kawsanqallapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Piru wañushqakunapaq yach'anaykiqa, yuyayllapa Tayta Dyus nishqanda chay unay agwilunchiqkunapaq Muysispa librumbiqa. Chaqa chay unay almakuna Abrajan, Isak, Jakubum puntata wañurqanllapa. Chaymandaqam achka watakunamanda Tayta Dyus chay lumyaykaq sarsa sach'amanda Muysista parlachishpa, paykunapaq kayshina nirqan: “Noqam kanangaman Abrajamba, Isakpa, Jakubupa Dyusnin kani”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Chayshina niptinmi yach'anchiq: Chay almakunaqam Dyuspaqqa kawsaykanllaparaq, nishpa. Piru qamkuna chayta mana intyindishpaqam, ancha pandashqallapa kangi: Wañushqakunaqam mana rinllapachu kawsamuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jisukristu chay sadusiyukunata shumaqta kuntistaptinmi, Muysispa liyningunata suq yach'achikuq chaypi uyaykarqan. Chaymi qemikashpa tapurqan: —Taytitu, Tayta Dyuspa yumbay liyninmandaqa, ¿mayqan liytaq mas allinqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Chaymi Jisusqa nirqan: —Yumbay liyninmandam kay mas allinqa: “Uyakuy isrraylinukuna, Tayta Dyusllam Dyusqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Payta kuyayllapa tukuy shunqoykiwan, tukuy bidaykiwan, tukuy yuyaynikiwan, tukuy jwirsaykiwan”, nishpa. Chay liyninmi mas allinqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Chaymandaqam kay suq liypis yaqqalla chay punta liyshina. Kayshinam nin: “Qam kwirpuykita kuyashqaykishina runa masikitapis kuyay”, nishpa. Manam ni suq liy mastaqa balinchu kay ishkay liymandaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Chayshina Jisus niptinqam, chay runaqa nirqan: —Yach'achikuq Taytitu, alliptam nishqa kangi. Allibmi Taytanchiq Dyusqa payllam Dyusqa. Manam suqqa kanchu. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Chaymi ancha alli, payta kuyananchiq tukuy shunqonchiqwan, tukuy yuyayninchiqwan, tukuy bidanchiqwan, tukuy jwirsanchiqwan. Runa masinchiqtapismi ancha alli kuyananchiq kwirpunchiqtashina. Chayshina kuyanakushpa kawsaptinchiqmi, mastaqa balin yumbay chay rupachishqan animalkunamanda ichu chay suq laya ufrindakunata qonanchiqmanda. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Chayshina jwisyunwan allita nishqa kaptinmi, Jisusqa nirqan: —Ashlitallanam faltashungi, Dyusta shumaqta kasunaykiqa, nishpa. Chaymi chay urasmandapacha manana ni pipis almitikarqanchu Jisusta tapuytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Dyuspa adurana wasimbi Jisus yach'achikushpam, kayshina tapurqan: —¿Imaraykum Muysispa liyningunata yach'achikuqkunaqa nin: “Dyus Akrashqan Washadurmi unay gubyirnu Dabidpa karu willkan rin kaq” nishpaqa? ");
INSERT INTO qvcNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","(Chayshina kaptinqa, ¿imaraykutaq chay kikin Dabidqa nirqan: “Dyus Akrashqan Washadurqam kamachikuqniy”, nishpa?) Chaqa Dyuspa Santu Ispiritun rimachiptinmi, chay gubyirnu Dabidqa nirqan: Tayta Dyusmi Kamachikuqniyta nirqan: “Allin laduypi tiyay, kuntrashuqkunata binsishpa, ch'akikipa waranman ruranaykaman (qamta kasushunanllapa)”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Mayá, chay Washadurqa Dabidpa karu willkan kaptinqa, ¿imaraykutaq paypaqqa chay Dabidqa nirqan: “Kamachikuqniy” nishpaqa? Chayshina Jisus yach'achikuptinqam, chay achka runakunaqa ancha gustarqanllapa uyayta. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Chaymandaqam Jisusqa kayshina yach'achikurqan: —Kwidawkish. Chaqa Muysispa liyningunata yach'achikuqkunaqam ancha gustanllapa shumaq mudananda rurakushpa puriyta. Kanan ñangunapipismi ancha munanllapa shumaqta napaykunanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Sinaguga wasikunaman rishpapismi, ancha gustanllapa tiyayta chay mas pwidiqkunapa tiyanambi. Mikunambaqpismi mesapiqa mas baliq lugarkunapi tiyanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Chayshinam allingunashina tukushpa, biyudakunapa wasingunata qoch'inllapa. Chaymandaqam allin runakunapaq tukushpa, yumbaypa ñawpambi Dyusman mana shaykuq mañakunllapa. Chaymi suqkunamanda mas kastigadu rinllapa kaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Dyuspa adurana wasimbim karqan kajunguna, ufrindakunata tandanambaqllapa. Chay kajungunapa ñawpambi Jisus tiyaykaptinmi, achka runakuna, warmikuna ufrindangunata wichuqllapa. Achka kapuq runakunapismi chaypi achka qellayta wichuqllapa chay kajungunaman. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Piru suq pubri biyuda ch'ayashpam, ishkay qellitaynin kubrimanda kaqta chay kajunman wichurqan. Chay qellitaykunaqam ancha ashlitalla balirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Chaymi Jisusqa yach'akuqningunata qayashpa nirqan: —Alliptam niykillapa, kay pubri biyudita qoshqanqam Dyuspaqqa ancha balin maski yumbay chay suqkuna qoshqanmanda. ");
INSERT INTO qvcNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Chaqa chay suqkunaqam qellaynin subrandalla qonllapa. Piru chay biyuditaqam ancha pubri kashpapis, mantyinikanan kaqta limpulla qoshqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Dyuspa adurana wasinmanda lluqshiptinllapam, Jisuspa suq yach'akuqnin nirqan: —Yach'achikuq Taytitu, rikay Dyuspa adurana wasinqam ancha shumaq. Chaqa ancha atun rumikunawanmi murallanda rurashqallapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Chaymi Jisusqa payta nirqan: —Kananqam rikaykangi kay atun wasita. Piru suq diyam limpu rinllapa bulaq. Chayshina bulaptinllapam, manana ni suq rumi patachaduqa kidanqachu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Chaymandaqam Ulibu lumamanna rirqanllapa. Chay lumaqam Dyuspa adurana wasimba chimba ladu frintimbi karqan. Chay lumapinam Jisusqa samaykarqan. Chaymi Pidru, Jakubu, Jwan, Andrisqa uyaritaplla Jisusta kayshina tapurqanllapa: ");
INSERT INTO qvcNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Chay nishqaykiqa, ¿ima wataraq kanqa? ¿Imataraq rikashpa yach'ashaqllapa: Kay munduqam rinna ushyakaq, nishpaqa? ");
INSERT INTO qvcNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Chaymi Jisusqa nirqan: —Kwidakayllapa ama pipis ingañashunambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Chaqa achka llullakuqkuna shamushpam, noqapa shutiyta myintashpa, rin niq: “Noqam Dyus Akrashqan Washadurqa kani”, nishpa. Chayshinam achka runata, warmita rinllapa ingañaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Chayri qamkuna uyashpa: “Waqpi, kaypim pilyaykanllapa”, nishpapis, ama manchayllapachu. Chaqa chayshinam rin kaq. Chayshina kaptimbismi, manaraq rinchu ushyakaq kay munduqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ashwanmi puntata suq nasyumbi tiyaqkuna rinllapa pilyaq suq nasyumbi tiyaqkunawan. Achka nasyungunapuram rinllapa pilyaq. Kay pachapismi waqpi kaypi rin kuyuq. Ambrunapismi waqpi, kaypi rin kaq. Tukuy kay siñakunaqam munan niyta: Ñakaykunam qallariykanna, nishpa. Chaymandaqam mas achka ñakaykuna rin kaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Chayri qamkunaqa allita yach'ayllapa: Rinim padisiq, nishpa. Chaqa rinllapam apashuq awturidarkunaman. Kanan sinaguga wasikunapim rinllapa maqashuq. Rinllapam apashuq gubyirnukunapa ñawpanman, noqapi kriyishqaykirayku. Chaymi qamkunaqa paykunapa ñawpambiqa noqapa faburniyta ringillapa rimaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Chaqa kay pacha manaraq ushyakaptinmi, puntata yumbay nasyungunapi noqapa shumaq nutisyayta ringillapa yach'achikuq. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kanan qamkunata apashuptinllapa intrigakushuq awturidarkunamanqa, ama llakiyllapachu ni yuyayllapachu: ¿Imashinaraq kuntistashaq? nishpaqa. Chaqa chay urasmi Tayta Dyus rin yanapashuqllapa, pay munashqanda ninaykillapa. Manam qamkunallachu ringillapa rimaqqa. Ashwanmi Dyuspa Santu Ispiritun rin yanapashuqllapa, allita rimanaykillapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Kanan runakunaqam masanllapata rin intrigakuq wanchinanllapa. Taytakunapismi rinllapa intrigakuq wambrangunata wanchinambaq. Churingunapismi taytangunata kuntrashpa, rinllapa wanchichiq. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kanan yumbay runakunam rinllapa ch'iqnishuq, noqapi kriyishqaykirayku. Piru noqapi mana shaykuq yuyakuptikiqam, suq bidapi rini washashuq. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Dyuspaq rimaq Dañilmi unay tyimpupi librumbi kayshina iskibrishqa: “Suq millanaypaq dañachikuqmi rin yaykuq santu lugarman mapachakuq”, nishpa. Chayri chaypaq yach'ashpaqa, yuyayllapa chay liyishqaykita. Chaqa chay tyimpu ch'ayamuptinqar, kay prubinsya Judiyapi kaqkunaqa mitikanqallapa chuncha lugarkunaman. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Kanan wasimba sawambi kaqkunapisri ishkishpa das mitikanqallapa, ama ni wasinman yaykushpa imanda surqonambaq. Ashwanri chayshinalla das mitikanqallapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ch'akrapi kaqkunapisri amana kutinqallapachu wasinman, imanda surqoqqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Kanan imananqaraqri chay pach'ayuq (ukuyuq) warmikunaqa, chay iti wambrituyuqkunaqa! ");
INSERT INTO qvcNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Chayri Dyusman mañakuyllapa, ama mitikanaykillapa tamya tyimpupi. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Chay mitikanayki diyakunapiqam runakuna, warmikuna ancha rinllapa padisiq. Chaqa Dyus kay pachata rurashqan diyamandapacham mana nunka chayshinaqa padisishqallapachu. Chay ñakay diyakuna pasaptinmi, manana nunka chayshinaqa rinllapachu padisiq. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Piru Dyusqam akrashqan wambrangunata llakipashpa, chay ñakana diyakunata das rin pasachiq, paypi kriyiqkuna ama achka diyakunata padisinanllapa. Chaqa Taytanchiq Dyusmi chayshina mana pasachiptinqach'i, mana pipis atinmanchu kawsayta. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Chayri mayqan qamkunata nishuptinllapa: “¡Rikay, kaypim Dyus Akrashqan Washadur!” ichu: “¡Rikay, waqpim payqa!” nishuptinqa, ama kriyiyllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Chaqa rinllapam shamuq achka llullakuqkuna: “Noqam Dyus Akrashqan Washadur kani”, nishpa, ichu: “Noqam Dyuspaq rimaq kani”, nishpa. Kanan rinllapam ruraq ispantaypaq milagrukunata, suqkuna paykunapi kriyinambaqllapa. (Chayshina rurashpam, achka runata, warmita rinllapa ingañaq.) Atishpaqach'i, asta Dyuspa akrashqan wambrangunatapis ingañanmanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","¡Chayri allita kwidakayllapa! Yumbay kaykunatam nishushqallapana kani manaraq nima pasaptin (ama pipis ingañashunanllapa). ");
INSERT INTO qvcNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Chay laya ñakaykuna pasaptinqam, rupaywan killa wañushpa, manana rinchu achikchakuq. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Lusirukunapismi syilumanda rin ishkimuq. Syilupi tukuy ima kaqkunapismi rinllapa kuyuq. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Chaymandaqam noqa Dyusmanda Shamuq Runataqa rinllapa rikawaq syilumanda shamuykaqta. Chaqa noqaqam rini shamuq pukutaykunapa ukumbi, ancha pudirniyuq, ancha shumaqta llipyashpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Chayshina shamushpaqam, anjilniykunata rini kamachiq, akrashqay wambraykunata tukuy kay mundumanda tandananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Kay kumparasyunda allita yach'akuyllapa: Qamkunaqam suq yura igusta pallpamuykaqta rikashpaqa, yach'angillapana: Tamya tyimpumanmi ch'ayaykanchiqna, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Chayshinallam kay nishushqayllapata rikashpa, yach'ayllapa: Allibmi Jisukristu nishqanshina utqana rin kumpliq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Chaymi allipta niykillapa, kay tyimpupi kawsaqkuna manaraq wañuptinmi, chay nishushqaykunaqa rin kumpliq. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Chaqa syiluwan kay pacham rin chingaq. Piru kay nishqaykunaqam mana nunka rinchu ushyakaq. Ashwanmi chayshinalla rin kumpliq. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Piru kay nishqaytaqam mana pipis yach'anchu: ¿Ima diya, ima urasmi rin kaq? nishpaqa. Ni syilupi kaq anjilkuna ni noqa Dyuspa Churimbis mana yach'anillapachu. Taytay Dyusllam chaytaqa yach'an. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Llalli qamkunaqam mana yach'angichu, ¿Ima tyimpum chay diyaqa rin ch'ayamuq? nishpaqa. Chayraykur qamkunaqa Dyusman mañakushpa, ama shaykushpachu shuyawayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Chaqa noqam qonqaylla rini kutimuq suq runa wasiyuq kutimuqshina. Chay runa karuta rinambaqqam wasindaqa kriyadungunata mingashpa rin. Piru manaraq rishpaqam, chay kriyadungunata kamachin, tukuy imangunata allita kwidanambaq, trabajungunata ruranambaq. Wasikamandapismi kamachin, allita rikanambaq, kutimushpa, tukuy imanda allita tarinambaq. Qamkunaqam chay kriyadukunashina kangillapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Chayri bidaykita allita allichashpa shuyawayllapa. Chaqa manam yach'angillapachu: ¿Ima diyam Siñurninchiq rin kutimuq? nishpaqa. Kinsapch'i kutimushaqqa chishipacha ichu ch'awpi tuta, ichu gallu kantaykashqan uras ichu achikyaq puriykaptin. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Chayri kwidawkish; mana yuyashqayki uras kutimushpa, puñuykaqllapata tarishuyman. ");
INSERT INTO qvcNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kay nishushqaytaqam yumbay runata, warmita nini: Allita allichashpa bidaykita shuyawayllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nuta: Tayta Dyusqam unay isrraylinukunata nasyun Ijiptumanda surqoshqa karqan. Chaymi chaytaqa ama qonqananllapa, watan watan suq fyistata ruraqllapa. Chay fyistaqam shutiq “Paskwa”.  Chay Paskwa fyistapiqam kachangakunata mikuqllapa. Ishkay diya faltaptin chay paskwa fyistapaqqam, kamachikuq isrraylinu kurakuna, Muysispa liyningunata wakin yach'achikuqkunawan kunanakushpa yuyarqanllapa: ¿Imanayraq ingañashpa, Jisusta piskanchiqman wanchinanchiq? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Wakinqam nirqanllapa: —Ama wanchishunchu fyistapiqa. Chaqa fyistaman tandakaqkunakish, chayta ruraptinchiqqa, kuntranchiq alsakanmanllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Suq runa Simun shutiqmi Bitanilla (Bitaniya) llaqtapi tiyaq. Unaymi payqa ismuykaq kwirpuyuq kashqa karqan. Jisusmi chay Simumba wasinman ch'ayashpa, mesaman tiyarqan mikunambaq. Chaypi tiyaykaptinmi, suq warmi ch'ayarqan kirpadu rumi pumupi ancha ch'aniyuq nardu puru plantamanda mishki mutkinata apamushpa. Chaymandaqam chay warmiqa chay pumupa kunganda pakishpa, chay mishki mutkinawan Jisuspa umanda nuyuchirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Chaymi wakin chaypi kaqkuna chayshina ruraqta rikashpaqa, ancha piñakushpa, paykunapura kayshina parlarqanllapa: —Kay warmiqa, ¿imapaqraq kay ancha ch'aniyuq mishki mutkinataqa qesachan? ");
INSERT INTO qvcNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Chaqa kayta randikushpaqach'i masdi 300 dinaryu qellayta ch'askinanchiqta, chay qellaywan pubrikunata yanapananchiq, nishpa. Chayshina parlashpaqam, anyarqanllapa chay warmitaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Chaymi Jisusqa nirqan: —Chay warmitaqa ama anyayllapachu. ¿Imapaqmi piñachingillapa? Kayshina rurawashpaqam, ancha allita rurashqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Chaqa pubrikunaqam qamkunawanraq rinllapa kaq, munashqayki uraspi yanapanaykillapa. Piru noqaqam manana qamkunawanqa rinichu kaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kay warmiqam atishqanda rurashqa. Chaqa manaraq wañuptiymi, kay mishki mutkinawan kwirpuyta allichaykan, wañuptiy pambawananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Chaymi allipta niykillapa, tukuy kay mundupi shumaq nutisyayta yach'achikushpaqam, kay warmi allita rurawashqandapis rinllapa yach'achikuq, paytaqa ama nunka qonqananllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Chay runa Judas Iskaryuti shutiqmi Jisuspa chay dusi akrashqan yach'akuqninmanda suqnin karqan. Piru chay Judasmi kamachikuq isrraylinu kurakunaman rishpa, tratukurqan, paykunaman Jisusta intrigakunan. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Chaymi chay kamachikuq kurakuna ancha kushikushpa, ufrisirqanllapa qellayta qonambaq. Chaymi Judasqa ancha yuyarqan: ¿Imashinataq Jisusta intrigakushaq chay kuntraqkunaman? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Paskwa fyistapiqam uñitakunata wanchishpa, aychanda, kachangakunata, suq laya mikunakunatapis mikuqllapa. Chay punta diya fyistapim Jisuspa yach'akuqninguna payta tapurqanllapa: —Kay Paskwa fyista mikunata mikunanchiqqa, ¿maypitaq munangi allichanayllapa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Chaymi Jisusqa ishkay yach'akuqninda kamachirqan: —Riyllapa Jirusalin llaqtaman. Waqpim ringillapa tinguq suq runa puyñumbi yakuta apaykaqta. Chay runapa ikinda riyllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Chay may yaykushqambi chay wasipa dwiñunda tarishpa, tapuyllapa: “Yach'achikuqniymi nin: ¿Mayqan kwartuykipish yach'akuqniykunawan Paskwa mikunata mikushaq?” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Chayshina niptikillapam, payqa rin rikachishuq wasimba altumbi suq atun kwartuta tukuy imawan allichashqata. Chaypi allichayllapa Paskwa mikunataqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Chaymi chay ishkay yach'akuqninguna Jirusalinman rishpaqa, Jisus nishqanshina runata tarirqanllapa. Chaymandaqam chay wasipina Paskwa mikunata allicharqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","18","Tutayaptinnaqam Jisusqa chay dusi yach'akuqningunawan chay wasimanna rirqan. Chaypinam paykunawan Paskwa mikunata mikuykarqan. Mikuqshinaqam Jisusqa nirqan: —Alliptam niykillapa, qamkunamanda suqniki noqawan pulla mikuqmi, ringi intrigakuwaq kuntrawaqkunaman, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Chaymi paykunaqa limpu malaganayashpa, suqnin suqnin Jisusta tapurqanllapa: —¿Noqachu kani? nishpallapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Chaymi Jisusqa chay dusi apustulninda nirqan: —Suqniki noqawan suq platupilla mikuqmi rin intrigakuwaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Chaqa Dyuspa Santu Librumbi noqa Dyusmanda Shamuq Runapaq nishqanqam allipta rin kumpliq. Piru chay runa intrigakuwaqqam chay uchanrayku ancha kastigadu rin kaq. ¡Chaymi mas allich'i kananda, chay runa ama nasinambaq! ");
INSERT INTO qvcNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Paskwa mikunata mikuqshinam Jisusqa kachangata piskashpa, Dyusman mañakushpa, bindisirqan. Chaymandaqam pitishpa, paykunata nirqan: —Ch'askiway kay kachangata. Kaymi kwirpuy, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Chaymandaqam suq kupata piskashpa, Dyusta pagikushpa paykunata qorqan. Chaymi paykunaqa chay kupamanda binuta yumbay upyarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Paykuna upyaykaptinqam Jisusqa nirqan: —Kay kupa binuqam yawarniy. Kay yawarniywanmi runakunawan, warmikunawan suq mushuq tratuta rini ruraq. Chaqa kay yawarniyta ich'ashpam, achka runakunata, warmikunata rini washaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Alliptam niykillapa, mananam rinichu upyaq ubaspa yakundaqa, syilupi mushuq binuta upyanaykaman, Taytanchiq Dyus shumaqta kamachikuptin, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Chaymandaqam imnuta kantashpa, Ulibu lumamanna rirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Chaypina kashpaqam, Jisusqa nirqan: —Kay tutam yumbay qamkunaqa manchashpa, noqamanda ringillapa akrakaq. Chaqa Tayta Dyuspa Santu Librumbim nin: “Michidurta suq lastima ruraptiymi, wishangunaqa waqta kayta rinllapa shikwakaq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Piru wañushqaymanda kawsamushpaqam, qamkunapa ñawpaykita rini riq waq prubinsya Galiliyaman, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Chaymi Pidruqa nirqan: —Yumbay manchashpa akrakaptimbismi, noqaqa mana akrakashaqchu qamandaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Chayshina niptinmi, Jisusqa Pidruta nirqan: —Alliptam niyki, kay tuta gallu manaraq ishkay bwiltata kantaptinmi, qamqa kimsa kutinda ringi ñigawaq: “Manam riqsinichu Jisustaqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Chaymi Pidruqa kutin kutin nirqan: —Pullayki wañushpapismi, mana ñigashqaykichu, nishpa. Yumbay chay suq yach'akuqningunapismi chayshinalla nirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Chaymandaqam Jisusqa chay yach'akuqningunawan rirqanna suq lugar Jitsimani shutiqman. Chaypim wakin paykunataqa nirqan: —Kaypi tiyayllapa, rinaykaman kay waqman, Tayta Dyusman mañakuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Chayshina nishpaqam, Jisusqa Pidruwan, Jakubuwan, Jwanwan riqshinaqa, ancha llakirqan. Shunqon munaptin tutayaytam, ");
INSERT INTO qvcNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","paykunata nirqan: —Ancharaq llakini. Chaymi shunqoy tutayashpa munan wanchiwayta. Mayá, kaypilla shuyawayllapa. Piru amakish puñungillapachu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Chayshina nishpaqam, Jisusqa mas waqkaq rishpa, qonqorikushpa, kumurashpa pambakaman, Dyusta ancha rrugarqan, ama chay kruspi padisinambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Mañakushpaqam, kayshina nirqan: —Taytitu, qamqam tukuy imata atingi rurayta. Munashpaqa washaway, ama chayshina wañunaypaq. Chaqa yumbay kay ñakaykunaqam suq basupi ancha ayaq yakukunashina. Yush'ayku amar dijawaychu, chayshina ñakanaypaqqa. Piru mastam munani qam munashqaykita ruranaykipaq. Amar noqa munashqaytaqa ruraychu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Chayshina mañakushpa, paykunaman kutimushpaqam, puñuykaqta tarirqan. Chaymi Pidruta nirqan: —Simun, ¿ima puñuykangichu? ¿Ima manachu atishqa kangi suq uritata agwantayta puñuymandaqa? ");
INSERT INTO qvcNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Allita rikch'akashpa, Dyusta rrugay, ama tyintadu kanaykillapa. Qamqam allipta munangi Dyusta kasuyta. Piru manam atingichu kwirpuykita sujitayta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Chaymandaqam Jisusqa kutirirqan, chayshinalla Dyusman mañakuriq. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Chaymandaqam kutirimushpaqa, yach'akuqningunata taririrqan puñuykaqta. Chaqa puñuywanqam ñawingunaqa kirpakaykarqan. Chaymi paykunaqa penqakushpa, Jisustaqa mana nimatapis atirqanllapachu niyta. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Chaymandaqam Jisusqa suq kutinda rishpa mañakuq, kutirimushpaqa, puñuykaqta taririrqan. Chaymi nirqan: —Puñuyllapana, samayllapana, nishpa. (Chaymandaqam suq rratitumanda nirqan:) —Rikch'akayllapana. Ch'ayamushqanam uras, uchayuq runakunaman noqa Dyusmanda Shamuq Runata intrigakuwanan. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Atariyllapa. Akuna. Shamunnam chay intrigakuwaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisukristu chay wakin yach'akuqninwan parlaykaptinmi, chay yach'akuqnin Judasqa ch'ayamurqanna achka runakunawan. Paykunaqam atun kuchillukunawan, qerukunawan shamurqanllapa. Chaqa paykunataqam chay kamachikuq isrraylinu kurakuna, Muysispa liyningunata chay yach'achikuqkuna, chay kamachikuq ansyanukunawan kach'amushqallapa karqan, Jisusta prisunanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judasqam chay runakunata nishqa karqan: —Qamkuna Jisusta riqsinaykiqam, muchashpa rini napaykuq. Chaymi chay napaykushqayta piskashpa, apayllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Chaymi chay Judasqa ch'ayashpa, Jisusmanqa qemikashpa, napaykurqan: —Yach'achikuq Taytitu, nishpam, mucharqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Chaymi chay runakunaqa Jisusta piskashpa aparqanllapana. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Piru Jisuspa suq yach'akuqninmi das surqoshpa atun kuchillunda, mas kamachikuq isrraylinu kurapa kriyadumba rinrinda pitirqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Chaymi Jisusqa chay runakunataqa nirqan: —¿Ima qamkunachu shamushqa kangi atun kuchillukunawan, qerukunawan, suq ladrundashina prisuwaq? ");
INSERT INTO qvcNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Noqaqam tukuy diya qamkunapa pullaykillapa kashpa, Dyuspa adurana wasimbi yach'achikushqa kani, ¿manachu? Piru chaypiqam qamkunaqa mana prisuwarqaykichu. Kayshinaqam rurawangillapa, Dyuspa Santu Librumbi nishqanshina kumplinambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Chayshina Jisusta piskaptinllapaqam, yach'akuqningunaqa payta sapalandallana dijashpa, mitikarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Suq wambra runa utkumanda kapayuqmi Jisuspa ikinda riykarqan. Chaymi chay prisuq runakunaqa paytapisna piskarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Piru chay runaqam, kapanda dijashpa, siprallana mitikarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jisustaqam chay tutatalla aparqanllapa mas kamachikuq isrraylinu kuraman. Chaymanmi tandakarqan kamachikuq isrraylinu kurakuna, kamachikuq ansyanukuna, Muysispa liyningunata yach'achikuqkuna. Nuta: Yumbay chay awturidarkunaqa tandadu kashpam, shutiq Mas Kamachikuq Tandakaq Juyiskuna, nishpa.  ");
INSERT INTO qvcNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Kanan Pidruqam Jisuspa karu ikinda rirqan chay mas kamachikuq isrraylinu kurapa uku patyungaman. Chay patyupiqam nina miraykarqan. Chaypim Pidruqa suldadukunawan ninapi mashakuykarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kanan chay kamachikuq isrraylinu kurakuna yumbay chay Mas Kamachikuq Tandakaq Juyiskunawanqam maskarqanllapa allin tistigukunata, Jisusta wanchinanllapa; piru manam tarirqanllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Chaqa chay tarishqan tistigukunaqam wakingunaqa suq layata llullakurqan. Wakinnataqmi suq layata llullakushpa rimarqanllapa. Chaymi mana balirqanchu chay rimashqanllapaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Wakimbismi Jisusta yanqakunata llullakushpa nirqanllapa: ");
INSERT INTO qvcNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Noqaykunaqam uyashqallapa kani kayshina niptin: “Noqaqam Dyuspa adurana wasinda runakuna rurashqandaqa pamba pamba rini bulaq. Chaymandaqam kimsa diyapilla rini rurariq suq laya wasita. Chay wasiqam mana kanqachu runakuna rurashqanshinaqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Chay tistigukunapismi suq layata suq layata rimarqanllapa. Manam chay layatallachu rimarqanllapaqa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Chaymi chay mas kamachikuq isrraylinu kura atarishpa, Jisusta tapurqan: —¿Imaraykum uyarangi? ¿Manachu uyangi kay runakuna qambaq rimashqandaqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Piru Jisusqam uyararqanlla. Manam nimatapis nirqanchu. Chaymi chay kamachikuqqa Jisusta tapurirqan: —¿Qamqachu Tayta Dyus Akrashqan Washadur kangi? ¿Binditu Tayta Dyuspa Churinchu kangi? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Chayshina tapuptinmi, Jisusqa nirqan: —Arí, noqam kani. Kanan qamkunaqam noqa Dyusmanda Shamuq Runata ringillapa rikawaq ancha pudirniyuq Tayta Dyuspa allin ladumbi tiyaykaqta. Ringillapam rikawaq syilumanda pukutaykunapa ukumbi shamuykaqta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Chayshina Jisus niptinmi, chay mas kamachikuq isrraylinu kuraqa ancha piñakushpa pay kikin kapanda llikishpa, nirqan: —¡Mayá, kananqa mananam munanchiqchu mas tistigukunataqa! ");
INSERT INTO qvcNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Yumbay qamkuna uyarqaykillapa kay runata: “Dyuspa Churinmi kani”, nishqanda. Chayshina rimashpaqam, Dyusta burlaykan. Mayá, qamkunaqa ¿imatam ningillapa? nishpa. Chaymi yumbay nirqan: —Chayshina rimashqanrayku wañunqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Chaymi wakinqa chay uras Jisusta qaqllambi tuqaparqanllapa. Kanan ñawinda pambashpam, suq lastima maqashpa nirqanllapa: —Mayá, niwayllapa: ¿Pim maqashurqan? nishpa. Kanan wakin suldadukunaqam suq lastima qaqllitambi maqarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Chay mas kamachikuq isrraylinu kurapam suq kriyadan karqan. Kanan Pidru chay kurapa wasimba patyumbi kaykaptinmi, chay kriyadaqa shamurqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Shamushpaqam, Pidruta ninapi mashakuykaqta rikashpa, ancha chapashqanshina nirqan: —Qambismi Jisus Nasaritmanda kaqwan puriq kangi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Piru Pidruqam nirqan: —Manam paytaqa riqsinichu. Manam ni yach'anichu imatach'i niwaykangi, nishpa. Chayshina nishpa, Pidruqa sawa punguman lluqshiykaptinmi, suq gallu kantarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kanan chay kriyadaqam Pidruta ancha chapashpa, chaypi kaqkunata nirirqan: —Kay runaqam Jisuswan puriq, nishpa. Chaymi Pidruqa chayshina niqta uyashpaqa nirirqan: ");
INSERT INTO qvcNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","—Manam riqsinichu Jisustaqa, nishpa. Chaymandaqam suq rratitumanda chaypi kaqkunaqa Pidruta nirirqan: —Allibmi qamqa paykunapa suqnin kangi. Chaqa chay Galiliyamanda kaqkunashinam rimangi. Chaymi riqsiykillapa, prubinsya Galiliyamandam kangi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Chayshina niptinllapaqam, Pidruqa ancha jurashpa llullakushpa nirqan: —¡Pur dyusitu, alliptam niykillapa, manam riqsinichu chay runataqa! Pipaqch'i niwaykangillapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Chayshina niptinllam, galluqa kantarirqan. Chaymi Pidruqa galluta uyashpa kantariqtaqa, das yuyarqan Jisus nishqanda: “Gallu manaraq ishkay kutinda kantaptinmi, qamqa kimsa kutinda ringi ñigawaq: ‘Manam riqsinichu Jisusta’ ”, nishpa. Chay nishqanda yuyashpam, Pidruqa ancha waqarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nuta: Chay tyimpukunapim Rruma llaqtamanda kaqkuna achka nasyungunapi kamachiqllapa. Chaymi isrraylinukunatapis suq rrumanu gubyirnu kamachiq. Chay gubyirnuqam shutiq Pilatu.  Achikyaykaptinnam kamachikuq isrraylinu kurakuna, kamachikuq ansyanukuna, Muysispa liyningunata yach'achikuqkunawan tandanakushpa parlarqanllapa. Paykunaqam Jisuspa makingunata grillitashpa aparqanllapa gubyirnu Pilatuman intrigakuq. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatuqam Jisustaqa tapurqan: —¿Qamchu isrraylinukunapa gubyirnun kangi? Chaymi Jisusqa nirqan: —Arí, chay nishqaykishinam kani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kanan chay kamachikuq isrraylinu kurakunaqam Jisusta kriminashpa, ancha rimarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Chaymi gubyirnu Pilatuqa Jisusta tapurqan: —Kayshina kuntrashushpa ancha rimaptinllapaqa ¿ima manachu qamqa nimata ningi? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Piru Jisusqam mana nimata nirqanchu. Chaymi Pilatuqa ancha ispantarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Piru chay Paskwa fyistapi isrraylinukuna rrugakuptinqam, gubyirnu Pilatuqa kada wata suq prisuta karsilmanda surqoq. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Chay tyimpupi wakin isrraylinukunam rrumanukunawan pilyashpa, wakingunata wanchishqallapa karqan. Chaymi chay wanchikuqkunaqa karsilpi karqan. Suqqam Barrabas shutiq. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Chaymandaqam Pilatupa ñawpambi Jisus kaykaptinqa, suq isrraylinukuna shamurqanllapa rrugakuq, suq prisuta karsilmanda surqonambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Chaymi Pilatuqa nirqan: —¿Munangillapachu kay gubyirnuyki Jisusta kach'anaypaq? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Chaqa chay Pilatuqam yach'arqan: Chay kamachikuq isrraylinu kurakunaqam Jisusta imbidyashpalla, noqamanqa apamushqallapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Piru chay kamachikuq isrraylinu kurakunaqam chay mañakuq isrraylinukunata ancha kunarqan, Pilatuta ninambaqllapa: —Jisustaqa ama kach'aychu. Barrabasta kach'ayqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Chaymi chayshina niptinllapa, Pilatuqa tapurqan: —Munashpa Barrabasta kach'anaypaqqa, ¿imatam munangillapa kay gubyirnuyki Jisusta ruranaypaq? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Chaymi paykunaqa ancha sh'uqyarqanllapa: —¡Jisusta suq kruspi klabayllapa! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Chaymi Pilatuqa nirqan: —¿Imapaqmi kamachishaq wanchinanllapaqa? ¿Ima uchatam rurashqa? Chayshina niptinqam, paykunaqa masta sh'uqyarqanllapa: —¡Kruspi klabay! ¡Kruspi klabay! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Chaymi Pilatuqa ama malpi kidanambaq chay rrugakuqkunawan, Barrabastana karsilmandaqa kach'arqan. Chaymandaqam kamachirqan, ancha asutinanllapa Jisusta. Asutichishpaqam, suldadukunata intrigarqan, paykunana kruspi klabananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Chaymi suldadukunaqa Jisustaqa aparqanna gubyirnu Pilatupa dispachumba patyunman. Kanan paykunaqam yumbay suldadu masingunata chayman tandarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Chaymandaqam chay suldadukunaqa suq granati kapata kapachirqanllapa Jisustaqa. Kanan suq kuruna kashamanda shimbadutam umachachirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Chayshina rurashpaqam, ancha asipashpa, kayshina sh'uqyarqanllapa: —¡Biba, biba isrraylinukunapa gubyirnun! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Chayshina nishpaqam, suq qeruwan umitambi waqtashpa, payta tuqapaqllapa. Kanan ñawpambi qonqorikushpam, aduraq tukuqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Chayshina burlashpaqam ancha asipashpa, chay kapata surqoshpa, paypa kapandana rurachirqanllapa. Chaymandaqam aparqanllapana, kruspi klabananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jisusta apaykaptinllapa kruspi klabaqmi, suq runa Sirini llaqtamanda kaq chayta pasaykarqan. Payqam Simun shutiq. Suq churinmi Alijandru shutiq. Suqqam Rrufu shutiq. Chay Simundam suldadukunaqa amalas umbruchachirqan Jisus apaykashqan krusta. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kanan Jisustaqam apaykarqanllapa suq lugar Gulguta shutiqman. Chay Gulgutaqam paykunapa rimaynimbiqa munan niyta “Kalabira Lugar”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Chay lugarman ch'ayashpaqam, binuta ayaq qewawan taqllushpa, Jisusta qorqanllapa upyanambaq. Chay ayaq qewaqam shutin mirra. Piru Jisusqam mana upyarqanchu. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kanan Jisustaqam kruspina klabarqanllapa. Chaymandaqam chay suldadukunaqa swirtita rurarqanllapa, Jisuspa mudananda partinakunanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jisustaqam kruspi klabarqanllapa rupay altuna kaptin. Chay urasqam las nwibina karqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Chayshina kruspi klabashpaqam, chay kruspa puntambi suq tablitata rurarqan. Chay tablitapiqam iskibrishqa karqan: “Kay runaqam isrraylinukunapa gubyirnun” nishpa. Chayshinaqam rurarqan, liyiqkuna yach'anambaq: Jisusqam chayrayku wañurqan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Kanan ishkay ladrungunatapis Jisuspa ladumbi kruskunapi klabarqanllapa, suqninda allin ladumbi, suqninda ichuq ladumbi. ˻ ");
INSERT INTO qvcNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Chayshina ruranambaqmi Dyuspa Santu Librumbi kayshina nishqa karqan: “Dyus Akrashqan Washadurpaqmi ninqallapa: ‘Uchayuqkunawanmi purin’ ”, nishpa. Chayshinam Dyus nishqanshina kumplirqan.˼ ");
INSERT INTO qvcNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Kanan kruspa ladunda pasaqkunapismi umanllapata kuyuchishpa, Jisusta musyashpa, asiparqanllapa: —¡Jajáy! Qamqam nirqayki: “Dyuspa adurana wasinda pamba pamba bulashpam, kimsa diyapi mushuqmanda rini alsariq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Chayshina atishpa ruraytaqa, kananqa qam kikiki washakashpa, chay krusmanda ishkimuy, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Kanan kamachikuq isrraylinu kurakuna, Muysispa liyningunata yach'achikuqkunawan asikushpa, paykunapura kayshina parlarqanllapa: —Suqkunataqam atirqan washayta. Piru pay kikinllaqam manana atinchu washakayta. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mayá, Dyus Akrashqan Washadur kashpa, Isrrayilpa gubyirnun kashpaqa, krusmanda ishkimunqa, chayta rikashpa, paypi kriyinanchiqllapa, nishpa. Chay ishkay kruspi kaq ladrungunapismi Jisustaqa musyarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Chay diya larrdusimandapacham las tres di la tardikaman limpu tutayarqan tukuy pachapi. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Las tresna kaptinmi, Jisusqa ancha jwirtita kayshina qayakurqan Tayta Dyusman: —Eloi, Eloi, ¿lama sabaktani? Chayqam paykunapa rimaynimbiqa munan niyta: “Dyusituy, Dyusituy, ¿imapaqmi sapalitaytaqa dijawashqa kangi?” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Chaymi wakin chaypi kaqkuna uyashpaqa nirqan: —Uyayllapa, Dyuspaq chay unay rimaq Eliyastam qayaykan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Chay urasmi suq runa kallpashpa, suq ish'uputa puchqo binupi nuyuchishpa, suq shukchapa puntambi rurashpa, Jisuspa shiminman qemirqan chupanambaq. Chaymandaqam nirqan: —Shuyashun rikananchiq, mayá, ¿Eliyaschu rin shamuq krusmanda ishkichimuq ichu mana? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Chaymandaqam Jisusqa jwirtita rimashpa wañurqanna. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jisus wañuptinqam, Dyuspa adurana wasimba kurtinanqa anaqmanda urakaman punta punta limpu llikikarqan. Nuta: Chay ancha atun rrakta kurtinaqam chay Ancha Santisimu Kwartuta akraq chay Santu Kwartumanda.  ");
INSERT INTO qvcNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kanan chay rrumanu suldadukunapa kamachikuqninmi Jisuspa ñawpambi shayaykarqan. Paymi allita rikashqa karqan Jisus ˻Tayta Dyusman qayakushpa˼ wañuptin. Chaymi payqa nirqan: —Allibmi kay runaqa Dyuspa Churin kashqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Chaypim wakin warmikunapis karqan. Paykunaqam karumandalla chapaykarqanllapa. Paykunamanda suq warmiqam chay Marya Magdalamanda kaq karqan. Suqqam suq Marya karqan. Payqam minur Jakubupa, Jusipa maman karqan. Suqqam Salumi karqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Chay warmikunaqam Jisuspa pullan purishpa, ancha yanapashqa karqan waq prubinsya Galiliyapa llaqtangunapi. Paykunawanmi mas warmikunapis chaypiqa karqan. Paykunaqam Galiliyamanda Jirusalinman Jisuspa pullan shamushqa karqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Chay diyaqam tardina karqan. Chay urasqam karqan allichakananllapa samana diyapaqna. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Chay urasmi suq ancha allin runa Jusi shutiq gubyirnu Pilatuman rirqan. Chay Jusiqam Arimatiya llaqtamanda karqan. Paymi chay Mas Kamachikuq Tandakaq Juyiskunapa suq ancha baliq myimbrun karqan. Chay Jusiqam ancha munarqan rikayta, Tayta Dyus shamuptin yumbayta shumaqta kamachinan. Chaymi payqa manchayta dijashpa, Pilatuman rirqan, Jisuspa kwirpunda mañaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Chaymi Jusi ch'ayaptinqa, Pilatuqa yuyarqan: ¿Ima dasnachu Jisusqa wañushqa? nishpa. Chayraykum ancha kunsidirashpa, suldadukunapa kamachikuqninda qayachishpa tapurqan: —¿Alliptachu Jisusqa wañushqana ichu manaraq? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Chaymi suldadukunapa kamachikuqnin Pilatuta nirqan: —Arí, wañushqanam, nishpa. Chaymi Pilatuqa Jusita pirmisuta qorqan, Jisuspa kwirpunda apanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Chaymi Jusiqa suq atun shumaq traputa randishpa rirqan, Jisuspa kwirpunda krusmanda ishkichimuq. Ishkichimushpaqam, chay trapuwan liyashpa, aparqanna pambaq. Suq luma qaqitapa pach'ambi mushuq mach'ayshina sipulturata rurachishqa karqan. Chaymi chaypi Jisuspa kwirpunda kamakachishpa, suq atun rumiwan kirparqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Pambaptinqam Marya Magdalamanda kaq, Jusipa maman Maryawan allita rikarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Samana diya pasaptinmi, Marya Magdalamanda kaq, Jakubupa maman Maryawan, Salumiwan mishki mutkinata randishpa rirqanllapa, Jisuspa kwirpunda chay mishki mutkinawan liyaq, ama ash'nanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Chaymandaqam chay diya dumingu madrugadu rirqanllapa Jisus pambakashqanman. ");
INSERT INTO qvcNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Paykunaqam rirqanllapa parlaqshina: —Chay ancha atun rumiwan chay mach'ayshina sipultura kirpashqandaqa ¿piraq ashuchinman yaykunanchiq? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Piru chay pambashqanman yaqqana ch'ayashpa, chapakushpaqam, chay atun rumitaqa rikarqanllapa chay mach'ayshina sipulturapa yaykunanmanda suq ladumanna isqandaykaqta. ");
INSERT INTO qvcNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Chaymi paykunaqa chay sipulturaman yaykushpaqa, suq wambra runa atun yuraq kapayuqta chaypi rikarqanllapa. Uku pantyumbiqam allin ladupi tiyaykarqan. Chaymi chay warmikuna rikashpaqa, ancha mancharqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Chayraykum chay runaqa nirqan: —Ama manchayllapachu. Qamkunaqam maskaykangillapa Jisus Nasaritmanda kaq kruspi wañushqata. Kananqam kawsamushqana. Mananam kaypichu. Chapakuyllapa kay kashqanman. ");
INSERT INTO qvcNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Riyllapa yach'akuqningunata, Pidruta abisaq: “Jisusqam qamkunapa ñawpaykita riykan prubinsya Galiliyaman. Waqpinam ringillapa rikaq, pay kawsaykashparaq nishushqanshina”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Chaymi chay warmikunaqa ancha manchashpa, ch'apsikashpa, chay pambakashqanmandaqa lluqshishpa, kallpaylla rirqanllapa. Paykunaqam manchaywan riykashpa, ñambiqa mana pitapis parlachirqanchu. ");
INSERT INTO qvcNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","˻Chay diya dumingu achikyaykaptinnam, Jisusqa wañushqanmanda kawsamurqan. Chaymandaqam puntata rikakurqan Marya Magdalamanda kaqman. Chay Maryamandam syiti dyablukunata qatishqa karqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Chayshina chay Maryaqa Jisusta rikashpaqam, rirqanna abisaq yach'akuqningunata. Piru paykunaqam ancha llakiwan Jisuspaq waqaykarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Chay Maryaqam nirqan: —¡Jisusqam kawsamushqana! Noqam payta rikashqa kani, nishpa. Piru chayshina niptinqam, paykunaqa mana kriyirqanllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Chaymandaqam ishkay yach'akuqninguna chuncha ñanda riykaptinllapa, Jisusqa paykunaman rikakurqan suq runa mana yaqqa riqsishqashina. ");
INSERT INTO qvcNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Piru payta riqsishpa, kutimushpa, kriyiq masingunata willaptinllapaqam, paykunatapis mana kriyirqanllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Chaymandaqam chay unsi yach'akuqninguna mesapi tiyashpa mikuykaptinllapa, Jisusqa paykunaman rikakurqan. Kawsamushqa kaptin, chay rikaqkuna niptinqa, chay unsikunaqa mana kriyishqallapachu karqan. Chaymi paykunataqa kayshina anyarqan: —Qamkunaqam rumi shunqoyuqkuna kashpa, kawsamushqayta mana kriyishqallapachu kangi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nirqambismi: —Riyllapa yumbay nasyungunaman, shumaq nutisyayta yumbay runata, warmita yach'achiq. ");
INSERT INTO qvcNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Chaymi noqapi kriyishpa shutikuqkunataqa rini washaq. Piru noqapi mana kriyiqkunaqam rinllapa chingaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kanan noqapi kriyiqkunaqam pudirniywan runakunamanda dyablukunata ringillapa qatiq. Kanan mana yach'ashqayki rimaykunapim ringillapa rimaq. ");
INSERT INTO qvcNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kulibrakunata piskashpapismi, mana ringillapachu wañuq. Bininuta mikushpapismi, mana ringillapachu wañuq. Kanan makikikunata qeshyaqkunapa sawanman rurashpam, ringillapa kach'akachiq. ");
INSERT INTO qvcNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jisus chayshina paykunata willashpaqam, syiluman rishpa, Tayta Dyuspa allin ladumbina tiyarqan. ");
INSERT INTO qvcNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Chay yach'akuqningunaqam tukuy mayta rirqanllapa, Jisus nishqangunata yach'achikuq. Kanan Taytanchiq Dyus yanapaptinmi, paykunaqa milagrukunata rurarqanllapa. Chaymi chay milagrukunata rikaqkunaqa yach'arqanllapa: Allip kaqkunatam yach'achikunllapa, nishpa. Kaytallam iskibrini qamkunapaq. Chayshina kanqa.˼");
INSERT INTO qvcNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Achka runakunam Jisuspa bidambaq manyaqlla iskibrishqallapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Paykunaqam Jisuspa pullan puriqkuna nishqanda iskibrishqallapa. Chaqa chay pullan puriqkunaqam kikin ñawinllapawan Jisustaqa rikashqallapa. Chaymi paykunaqa tistigunguna kashpa, chay rikashqanshinalla shumaq famanda yach'achiwashqallapa kanchiq. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Dun Tiyufilitu, noqapismi chay tistigukuna Jisuspaq nishqanda allita yach'akushqa kani tukuy bidambaq, nasishqan diyamandapacha. Chaymi yuyarqani tukuy ima rurashqambaq manyaqlla iskibriyta, puntata imashina kashqa, chaymandaqa imatam rurashqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Kaykunatam iskibriyki, chay yach'ashqaykimanda mas allip kaqta Jisuspaq yach'anayki. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Irudis Judiya prubinsyapa gubyirnun kaptinmi, suq isrraylinu kura karqan. Paymi shutirqan Sakariyas. Payqam kurakunapa suq trupanmanda karqan. Chay trupam shutiq Abiyas. Sakariyaspa warmin Ilisabitpismi payshina chay unay kura Arumba karu willkan karqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Paykunaqam ishkandin shumaqta kawsaqllapa. Chaymi Dyusqa ancha kushikurqan paykunawanqa. Chaqa pay nishqanda, tukuy liyningunatapis allita kasushpam kawsarqanllapa. Chaymi mana pipis atirqanchu paykunata anyaytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Piru manam wambrayuqchu karqanllapa. Chaqa chay Ilisabitqam mana nunka wambrayuqchu karqan. Kanan ishkandinmi ancha byijitukunana karqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Suq diyam chay Abiyas trupa kurakunata tukarqan, Dyuspa adurana wasimbi ruranangunata rurananllapa. Chaymi chay kurakunaqa swirtita rurashpa, Sakariyasta akrarqanllapa, yaykunambaq Dyuspa adurana wasimba Santu Kwartunman, insinsyuwan qondachikunan. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Chaymi uku Santu Kwartupi Sakariyas insinsyuta rupachishpa qondachiykaptinqa, sawapi ancha achka isrraylinukuna Dyusman mañakuykarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Chayshina Sakariyas ukupi kaykaptinmi, Dyuspa suq anjilnin payman rikakurqan. Chay anjilqam insinsyuta qondachikunan pata altarpa allin ladumbi shayaykarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Chaymi Sakariyasqa anjilta rikashpaqa, ancha manchashpa, mana nimanayta atirqanchu. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Piru anjilqam nirqan: —Sakariyas, ama manchaychu. Mañakushqaykitam Dyusqa uyashushqa. Chaymi warmiki Ilisabitqa wambrayuq rin kaq. Chay wambraykitaqam Jwanda ringi shutichiq. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Pay nasiptinqam, ancha ringi kushikuq. Chayshinam achka llaqta masikikunapis ancha rinllapa kushikuq. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Chaqa Dyusqam chay churikitaqa ancha kamachikuqta rin ruraq, Dyusta sirbinambaq. Manam rinchu upyaq binuta ni suq laya tragukunatapis. Mamamba pach'ambilla kaykaptinmi, Dyuspa Santu Ispiritunqa paypina rin kaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Achka isrraylinukunata yach'achiptinmi, uchangunata dijashpa, Dyustana rinllapa kasuq. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Dyusmi Jwannikita Santu Ispiritunda rin qoq, chay unay pudirniyuq Eliyasshina kanambaq. Kanan Dyus Akrashqan Washadurmandaqam Jwannikiqa mas puntata rin yach'achikuq, piñakushqa taytakuna alliyanambaq wambrangunawan, Dyusta mana kasuqkuna yach'akunambaq payta kasuyta. Chayshinam runakunata, warmikunata rin yach'achiq, chay Akrashqan Washadurta shumaqta ch'ayachinanllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Chayshina niptinmi, Sakariyasqa anjilta tapurqan: —¿Imata rikashpam atini kriyiyta kay niwashqaykitaqa? Chaqa noqaqam ancha byijuna kani. Warmiypismi byijana, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Chayshina tapuptinmi, chay anjilqa nirqan: —Noqaqam Grabyil kani. Dyuspa ñawpambim kani, kamachiwashqanda ruranaypaq. Tayta Dyus kikinmi kach'amuwashqa, chay kushikunayki nutisyata nishunaypaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Piru chay nishushqaytaqam mana kriyiwangichu. Chaymi muduna ringi kidaq. Mananam ringichu atiq rimayta, kay nishushqay kumplinangaman, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Chayshina ukupi anjilwan unayaptinmi, sawapi kaq runakunaqa Sakariyasta ancha shuyaykarqanllapa: ¿Imanashqataq Sakariyasqa? ¿Imakushparaq ancha unayan lluqshimunambaq Santu Kwartumandaqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Chaymanda lluqshimushpaqam, Sakariyasqa manana atirqanchu parlachiyta paykunataqa. Chaymi intyindirqanllapa: Santu Kwartupi kashpa, musqoypishinach'i karqan, nishpa. Chaqa Sakariyasqam siñakunata rurashpana intyindichirqan. Chayshinam mudullana kidarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Chayshina Sakariyas Dyuspa adurana wasimbi yumbay ruranangunata kumplishpaqam, rirqanna wasinman. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Chaymandaqam warmin Ilisabitqa pach'ayuqna (ukuyuqna) karqan. Chaymi wasinmandaqa sinku killata manana maytapis rirqanchu. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Payqam nirqan: —Dyusmi munashqana, wawayuq kanaypaq, suqkuna ama rimawanambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Sayis killamandam Tayta Dyusqa kach'arqan chay anjilnin Grabyilta waq prubinsya Galiliyapa Nasarit llaqtanman, ");
INSERT INTO qvcNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","parlachinambaq suq china Marya shutiqta. Chay Maryaqam dunsillaraq karqan. Piru tratukushqanam karqan, suq runa Jusi shutiqwan kasaranambaq. Chay Jusiqam alma gubyirnu Dabidpa karu willkan karqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Chaymandaqam Dyuspa anjilnin chay Maryaman shamushpa, napaykushpa, nirqan: —¡Maryita, Dyusri yanapashunqa! ¡Kushikuy! Chaqa Tayta Dyusmi qamwan. Paymi qamtaqa rin yanapashuq maski yumbay warmikunamanda, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Chayshina chay anjil napaykuptinmi, Maryaqa ispantashqata chapashpa, ancha yuyarqan: ¿Imapaqraq kayshina nishpaqa napaykuwan? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Chaymi anjilqa nirqan: —Ama manchaychu, Maryita. Chaqa Dyusqam qamwan ancha kushikun. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Pach'ayuqmi (Ukuyuqmi) ringi kidaq. Chaymandaqam ringi qeshyaq suq wambrituta. Chay wambrituykiqam rin shutiq Jisus. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Paymi ancha kamachikuq rin kaq. Chaymi paypaqqa rinllapa niq: Ancha pudirniyuq Dyuspa Churinmi, nishpa. Kanan Taytanchiq Dyusmi rin ruraq ancha pudirniyuq gubyirnuta, chay karu agwilun Dabidtashina. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Wambraykim yumbay isrraylinukunata tukuy tyimpu rin kamachiq. Chaqa kargunqam mana nunka ushyakanqachu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Chayshina chay anjil niptinqam, Maryaqa tapurqan: —Mayá, ¿imashinam chay niwashqaykiqa rin kaq? Chaqa dunsillaraqmi kani. Manaraqmi runawanqa puñushqachu kani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Chaymi chay anjilqa nirqan: —Dyuspa Santu Ispiritunmi qaman rin shamuq. Paymi Tayta Dyuspa pudirninwan pukutayshina rin pambashuq. Chaymi chay urasmandapacha pach'ayuqna (ukuyuqna) ringi kidaq. Chaymi chay nasiq wawaykiqa Dyuspaqlla kashpa, mana nima uchayuqchu rin kaq. Paypaqmi ninqallapa: Dyuspa Churinmi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Aylluyki Ilisabitpismi ancha byijana kashpapis, pach'ayuqna (ukuyuqna). Paypaqmi niqllapa: “Payqam mana atinchu wambrayuq kaytaqa” nishpa. Piru kananqam sayis killakunana pach'ayuq (ukuyuq). ");
INSERT INTO qvcNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Chaqa Dyuspaqqam mana nima trabajuschu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Chayshina anjil niptinqam, Maryaqa nirqan: —Dyuspa kriyadanmi kani, payta kasunaypaq. Chay niwashqaykishina kanqa, nishpa. Chayshina niptinqam, chay anjilqa rirqanna. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Chay diyakunam Maryaqa utqaymaya rirqan prubinsya Judiyapa jalkanman. Chay jalkapa suq llaqtambim Ilisabitqa tiyaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Maryaqam Sakariyaspa wasinman ch'ayarqan. Chaymandaqam yaykushpa, Ilisabitta napaykurqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Chayshina napaykuptinmi, Ilisabitpa pach'ambi wambritunqa kuyurqan. Kanan chay urasmi Dyuspa Santu Ispiritunwan Ilisabitqa unda karqan shunqombi. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Chaymi payqa ancha jwirtita nirqan: —Maryita, Dyusmi ancha yanapashuykangi maski yumbay warmikunamanda. Pach'aykipi wambrituykitapis ancha yanapaykan. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Pitaq kani noqaqa? Manam nimapaq balinichu shamunambaq watukuwaq Siñurniypa mamanqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Chaqa diki napaykuwaptikim, uku pach'aypi wambrayqa kushikushpa kuyurqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kriyishqaykirayku kushikuy. Chaqa Tayta Dyus tukuy ima nishushqandam allipta rin kumpliq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Chayshina Ilisabit niptinmi, Maryaqa nirqan: Taytanchiq Dyustam tukuy shunqoywan ancha alabani. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Chayshinam ancha kushikuni Dyus Washadurniypaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Chaqa mana baliq kriyadanshina kaptiypismi, Tayta Dyusqa akrawashqa. Chaymi kananmandapacha tukuy runakuna noqapaq kayshina ninqallapa: “Dyus yanapaptinmi, payqa ancha kushikuq warmi”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Chaqa Dyusqam ancha pudirniyuq kashpa, ancha yanapawashqa. Manam nima maluta ruranchu. Chaymi Santu shutin. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kanan Tayta Dyusqam yumbay kasuqkunata tukuy tyimpu rin yanapaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kanan mana ni pi atishqanda ruraytam payqa rurashqa. Yumbay afanirutam binsishqana. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Pwidiqkunatam kargungunamanda kambyarqanna. Mana karguyuq kaqkunataqam numbrarqan, ancha kamachikuqkuna kanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Chay mallaqkunatam tukuy imata qorqan. Piru kapuqkunataqam nirqan illaqllana rinanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Tayta Dyusmi sirbikuqnin isrraylinukunata llakipawaqninchiq, ancha yanapawashqallapa kanchiq. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Chaqa chay unay agwilunchiq Abrajanda yumbay ayllundinda chayshina ufrishqa karqan yanapayta tukuy tyimpupaq. Chay ufrisishqandam kumplishqana, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Kanan kimsa killatach'i Maryaqa Ilisabitpa pullan tiyarqan. Chaymandaqam kutirqanna wasinman. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Chaymandaqam Ilisabitpa qeshyanan tyimpun kumpliptinqa, qeshyarqanna wambritundaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Bisinungunawan ayllungunaqam yach'arqanllapa: Tayta Dyusshi Ilisabitta ancha yanapashqa, nishpa. Chaymi paykunaqa Ilisabitpa wasinman tandakashpa, paywan ancha kushikurqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Chaymandaqam 8 diyasmanda chay wambritupa kwirpumbi siñalta rurarqanllapa. Chay diyapiqam chaypi kaqkuna wambritupaq nirqanllapa: —Sakariyas shutinqa, taytanshina shutiyuq kanambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Piru mamanqam nirqan: —¡Manám! Jwanmi rin shutiq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Chaymi mamandaqa nirqanllapa: —¿Imaraykutaq munangi chayshina shutinanqa? Chaqa manam pipis aylluykipiqa Jwanqa shutinchu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Chaymi siñiyashpa, taytanda tapurqanllapa: —¿Wambrituykitaqa imatam munangi shutichiyta? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Chayraykum taytanqa suq tablitata mañashpa, chaypi kayshina iskibrirqan: “Wambrayqam shutin Jwan”, nishpa. Chaymi chay iskibrishqanda rikashpaqa, yumbaynin ancha ispantarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Chay urasmi Sakariyasqa mudu kashqanmanda, atirqanna rimayta. Kanan Dyustam ancha alabarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Chaykunata rikashpaqam, chay bisinungunaqa masta ispantarqanllapa. Chaymandaqam chay famaqa chay prubinsya Judiyapa tukuy jalkangunaman shikwakarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Yumbay chayta yach'ashpaqam, ancha yuyashpa, paykunapura tapunakurqan: —Chay wambra wiñashpaqa ¿ima karguyuqraq kanqa? nishpa. Chaqa paytaqam Tayta Dyusqa ancha yanapaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tayta Dyuspa Santu Ispiritunmi yaykurqan Jwamba taytan Sakariyasman. Chaymi chay Santu Ispiritu rimachiptin, Sakariyasqa kayshina nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","¡Alabashqa kanqa noqanchiq isrraylinukunapa Taytanchiq Dyus! Chaqa kayman shamushpam, noqanchiq wambrangunata washawashqa kanchiq. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Chay unay Dabidqam Tayta Dyusta ancha kasuq. Kananqam chay Dabidpa karu willkanda qowashqa kanchiq, ancha pudirniyuq Washadurninchiq kanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Chayshinam Dyusqa unaymandapacha paypaq ancha santu rimaqkunata akrashpa, kayshina rimachirqan: ");
INSERT INTO qvcNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","“Yumbay kuntrashuqmanda, ch'iqnishuqmandam rini washashuqllapa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Chaymi Tayta Dyus chay unay agwilunchiqkunata llakipashpa, paykunawan suq santu tratuta rurarqan. Chay tratutaqam mana qonqashqachu. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ashwanmi unay agwilunchiq Abrajanda jurashpa, noqanchiqkunapaq kayshina ufrisirqan: ");
INSERT INTO qvcNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","“Karu willkaykikunatam kuntraqkunamanda rini washaq, ama ni pita manchashpa noqatalla kasuwananllapa, ");
INSERT INTO qvcNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","allitalla rurashpa, mana uchayuq kashpa, tukuy tyimpu noqawan kawsananllapa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Chayshina nishpaqam, Sakariyasqa chay wambritunda nirqan: Ijitu, qambaqmi rinllapa niq: “Ancha pudirniyuq Dyuspaq rimaqmi kangi” nishpa. Chaqa qam Dyus Akrashqan Washadurmanda puntata yach'achikushpaqam, ñanninda allichaqshina ringi kaq, payta shumaqta ch'ayachinanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ringim kayshina yach'achikuq: “Tayta Dyus pirdunashushpam, uchaykikunamanda rin washashuqllapa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Chaqa Taytanchiq Dyusmi kuyawaqninchiq, llakipawaqninchiq, Washadurninchiqta syilumanda rin kach'amuq runakunata, warmikunata washawananchiq. Paymi rupayshina llipyashpa, suq mushuq diyashina rin achikchakuq. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Uchayuq kashpaqam chingaykarqanchiqllapa. Piru payqam suq mushuq bidata rin qowaqninchiq. Chaqa rinmi yanapawaqninchiq, kushikushpa, shumaqta kawsananchiqllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Chaymandaqam chay Jwan wiñaykaptinqa, Dyuspa Santu Ispiritun yanaparqan, tukuy shunqo Dyusta kuyanambaq. Kanan Jwanqam chuncha lugarkunapi tiyaq, ch'ayanangaman tyimpu isrraylinukunata yach'achinambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Waq tyimpukunapim Rrumapa gubyirnun Sesar Agustu kamachikurqan, suq sinsuta rurananllapa tukuy mundupi. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Chay punta sinsutaqam rurarqanllapa, chay prubinsya Siryapa prifiktun Siriniyu kaptin. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Chayshina chay gubyirnu kamachikuptinmi, yumbay runakuna riqllapa kikin llaqtanman, chay sinsupi apuntakananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Chaymi Jusiqa prubinsya Galiliyapa Nasarit llaqtanmanda lluqshishpa, rirqanna prubinsya Judiyapa Bilin llaqtanman. Chaqa chay Bilimbim chay unay alma gubyirnu Dabidqa nasishqa karqan. Chaymi Jusiqa Dabidpa karu willkan kashqanrayku, rirqan Maryawan Bilinman, chay sinsupi apuntakanambaq. Chaqa Jusiqam Maryawanqa tratukushqana karqan kasarananllapa. (Piru mana puñuptinllapam,) Maryaqa pach'ayuqna (ukuyuqna) karqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Chaymi Bilimbilla kaykaptinllapa, Maryapa qeshyanan diya ch'ayamurqanna. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Chaymi chaypi qeshyashpa kulaka wambritunda, llambu trapukunawan wangushpa, usurachirqan suq istablu kurralpi suq pisibripi. Chaqa pusadapiqam mana karqanchu lugar, paykuna kidanambaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Chay Bilimba sawa chunchambim michidurkuna yuraqashtin wishanllapata kwidaykarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Paykunamanmi das rikakurqan Dyuspa suq anjilnin. Kanan Tayta Dyuspa llipyayninmi rridurninllapata limpu achikcharqan. Chaymi chay michidurkunaqa ancha mancharqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Piru anjilqam paykunata nirqan: —Ama manchayllapachu. Qamkunamanmi ancha shumaq nutisyata apamuni. Kay nutisyata yach'ashpaqam, yumbay runakuna ancha rinllapa kushikuq. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kananmi chay unay Dabidpa llaqtambi nasishqa suq Washadur. Paymi Dyus Akrashqan Washadur. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kriyiwanaykim, chay wambritutaqa ringillapa tariq llambu trapukunawan wangushqata, suq pisibripi usuraykaqta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Chaymandaqam chay anjilpa ladumbi das rikakurqan ancha achka anjilkuna. Paykunaqam kunyarqanllapa, Dyusta kayshina alabashpa: ");
INSERT INTO qvcNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—¡Biba, biba altu syilupi Tayta Dyus! ¡Alabashqa kanqa! ¡Chaqa payqam achka runata, warmita munan yanapayta! ¡Chaymi paykunaqa kay mundupi ancha kushikunqallapa! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Chayshina chay anjilkuna Dyusta alabashpaqam, kutirqanna syiluman. Chayshina kutiptinllapaqam, michidurkunaqa paykunapura kayshina parlarqanllapa: —Mayá, akullapa Bilinman, Taytanchiq Dyus niwashqanchiqta rikananchiq, imash' kashqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Chaymandaqam utqaymaya rishpa, Maryata, Jusitaqa, iti wambrituyuqtana tarirqanllapa. Chay wambritunqam usuraykarqan chay pisibripi. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Chaymi chay michidurkuna wambrituta rikashpaqa, chaypi kaqkunata parlachirqan chay anjil nishqanda. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Chayshina parlachiptinqam, yumbay chay uyaqkunaqa ancha ispantarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Piru Maryaqam tukuy chaykunata uyashpa, ancha yuyashpa, shunqombilla waqaycharqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Chaymandaqam chay michidurkunaqa kutiriqshina Tayta Dyusta ancha alabarqanllapa yumbay uyashqambaq, rikashqambaqllapa. Chaqa chay anjil tukuy ima nishqanqam allip kashqa karqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Chay wambritu 8 diyasniyuq kaptinmi, kwirpumbi siñalta rurashpa, nirqanllapa: “Jisus shutinqa”, nishpa. Chaqa Marya manaraq pach'ayuq (ukuyuq) kaptinmi, Dyuspa anjilnin chayshina nishqa karqan shutinambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Chaymi Muysis kamachikushqanda kumplishpaqa, 40 diyasmandaqa rirqanllapana Jirusalinman. Kanan Dyuspa adurana wasinman rishpaqam, Dyusta nirqanllapa: “Kay wambrituytam apamunillapa prisintaq qamba ñawpaykiman, qamta sirbishunan”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Chaqa Tayta Dyusqam liynimbi kamachikushqa karqan: “Yumbay ullqo kulaka nasiqtam noqapa ñawpayman apamuyllapa, wiñashpa noqata sirbiwananllapa”, nishpa. Chaymi Dyus nishqanda rurarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Dyusqam liynimbi kamachikushqapis karqan, ufrindananllapa ishkay turtula pishqokunata ichu ishkay palumata. Chaymi Maryawan Jusiqa chayshina rurarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Chay tyimpupim Jirusalimbi suq ancha allin runa tiyarqan. Paymi Simiyun shutirqan. Payqam Dyusta ancha aduraq. Chaymi ancha shuyakuykarqan, Dyus Akrashqan Washadur payta, isrraylinu llaqta masingunata washanambaq. Chaqa Dyuspa Santu Ispiritunmi Simiyunwan kashpa, ");
INSERT INTO qvcNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","kayshina yach'achishqa karqan: “Manaraq wañushpam, ringi rikaq Tayta Dyus Akrashqan Washadurta”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kanan Dyuspa Santu Ispiritun chay Simiyunda apaptinmi, payqa rishqa karqan Dyuspa adurana wasinman. Chaymi Maryawan Jusiqa chay adurana wasiman Jisusta apaptinllapa, Muysis kamachikushqanda kumplinan, ");
INSERT INTO qvcNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","chay Simiyunqa Jisusta marqashpa, Dyusta kayshina ancha alabarqan: ");
INSERT INTO qvcNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Dyusilupagi Taytitu; ufrisiwashqaykitam kumplishqana kangi. Chayraykum ancha kushikuni. Kananqam atingina dijawayta wañunaypaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Chaqa kikiy ñawiykunawanmi rikashqana kani kay Washadurta. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Qam paytaqa kach'amushqana kangi, yumbay runa, warmi riqsinanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Kay wambritum suq micha achikchakuqshina rin yanapaq yumbay nasyungunapi tiyaqkunata, qamta shunqonllapapi riqsishushpa, allita kasushunanllapa. Kay wambritu achka furastirukunata washaptinmi, paykuna rinllapa alabaq llaqta masin isrraylinukunatapis, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Chayshina Simiyun Jisusta alabaptinmi, Maryawan Jusiqa ancha ispantarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simiyunqam Dyusman mañakurqambis, paykunata shumaqta yanapanambaq. Chaymandaqam Maryata nirqan: —Kay wambraykim achka isrraylinu masinchiqkunata rin washaq, paypi kriyiptinllapa. Piru achka llaqta masinchiqkunaqam rinllapa chingaq, paypi mana kriyishpallapa. Chaqa achka runakunam paytaqa rinllapa disprisyaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Chayshina disprisyaptinllapam, wakinqa chayta rikashpa, yach'anqallapa: Chay runakunaqam mapa shunqoyuqkuna, nishpa. Lukismi Maryita, tukuy chaykunata rikashpaqa, ancha ringi llakiq. Chaqa qambaqqam chay llakikunaqa suq atun kuchilluwan shunqoykipi puntiyashuqshina rin kaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Chaypim karqambis Dyuspaq suq rimaq warmi Ana shutiq. Paypa taytanmi Fanwil shutishqa karqan. Chay Fanwilmi atun ayllu Asirmanda kashqa karqan. Chay Anaqam chinalla kashpa, kasarashqa karqan. Kanan qosanwanqam syiti watastalla purirqan. Chaymandaqam qosan wañuptinqa, 84 watas biyudalla kashpa, ancha byijana karqan. Payqam Dyuspa adurana wasinmandaqa mana lluqshiqchu. Chaypim punchawnindin tutapnindin Dyus munashqanda rurashpa, ayunashpa, Dyusman mañakushpa kawsaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Chay Simiyun wambritu Jisuswan kaykaptinmi, Anaqa paykunaman qemikashpa, Dyusta pagikushpa, chaypi kaqkunata parlachirqan. Paykunaqam unaymandapacha ancha munarqanllapa rikayta, Jirusalin llaqtapa Washadurnin ch'ayamuptin. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Jusiwan Maryaqam, Dyus tukuy ima kamachikushqanda rurashpaqa, wambritundinna prubinsya Galiliyaman kutirqanllapa chay kikin Nasarit llaqtanman. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Wambritun Jisusqam diyapi diyapi wiñashpaqa, mas jwirsayuq, mas yach'ayniyuqna karqan. Kanan Tayta Dyusqam tukuy imapi payta ancha yanaparqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","42","Jisuspa taytan mamanmi watan watan riqllapa Jirusalinman chay Paskwa fyistaman. Chaymi Jisusqa dusi watayuqna kaptin, paykunawan rirqan Jirusalinman chay Paskwa fyistamanqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Chay fyista ushyakaptinqam, taytanwan mamanqa kutiriykarqanna Nasarit llaqtaman. Piru Jisusqam Jirusalimbilla kidashqa karqan. Kanan Maryawan Jusiqam mana watukushqachu karqan Jisus kidaptinqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Paykunaqam yuyarqan: Kay achka runapa ukumbich'i riykan, nishpa. Chayshina yuyashpaqam, suq diya ñandana rirqanllapa. Chaymandaqam watukushpaqa, manana tarirqanllapachu. Chaymi ayllungunapi, tukuy chay riqsishqangunapi maskashpa, ");
INSERT INTO qvcNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","mana tarishpaqa, paykunaqa kutirirqanna Jirusalinman maskaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Chaymi ancha maskashpa, kimsa diyamanda Dyuspa adurana wasimbi tarirqanllapa. Jisusqam Muysispa liyningunata yach'achikuqkunapa ch'awpimbi tiyashpa, paykunata uyaykarqan, tapuykarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kanan payta tapuptinllapaqam, ancha allita kuntistarqan. Chaymi yumbay chay uyaqkunaqa ispantashqata kidarqanllapa: ¡Rikay, tapuptinllapaqam, kay wambraqa ancha yach'ayniyuq kashpa, ancha allita kuntistan! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kanan taytanwan mamanqam chay yach'ayniyuqkunapa ch'awpimbi tarishpaqa, ancha ispantarqanllapa. Chaymi mamanqa nirqan: —Ay, ijitu, ¿imapaqmir kayshina rurawangillapa? Taytaykiwanmi noqaqa ancha manchashpa, llakishpa, maskaykaykillapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Chayshina niptinmi, Jisusqa nirqan: —¿Imapaqmir maskawaykangiqa? ¿Manachu yach'angillapa: Taytaymi munan, paypa wasimbi ruranangunata ruranaypaq, nishpaqa? ");
INSERT INTO qvcNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Piru paykunaqam mana intyindirqanchu Jisus nishqandaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Chaymandaqam Jisusqa paykunawan kutirirqan Nasaritman. Chaypim payqa paykunata tukuy imapi kasushpa kawsarqan. Kanan mamanqam yumbay chay pasashqambaq mana pitapis parlachirqanchu. Ashwanmi shunqombilla waqaychaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Kanan Jisusqam diyapi, diyapi wiñashpa, mas jwirsayuq, mas yach'ayniyuq karqan. Tayta Dyusqa, runakunapismi paywanqa ancha kushikuqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tibiryu Sesar Rrumapa gubyirnun kinsi watasna kamachikuykaptinmi, prubinsya Judiyapa prifiktun Punsyu Pilatu karqan. Prubinsya Galiliyapa prifiktunmi suq Irudis karqan. Nuta: Chay suq Irudismi chay punta gubyirnu Irudispa churin karqan.  Prubinsya Ituriyapa tukuy Trakunitipa prifiktunmi chay Irudispa masan Filipi karqan. Prubinsya Abiliñapa prifiktunqam Lisaniyas karqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Kanan Anaswan Kayfasmi mas kamachikuq isrraylinu kurakuna karqanllapa. Chay tyimpupim suq chuncha lugarpi Sakariyaspa churin Jwanda Dyusqa nirqan, paypaq rimanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Chaymi Jwanqa yach'achikushpa, yach'achikushpa, riykarqan chay rriyu Jurdamba tukuy chuncha lugarningunata. (Chay chunchakunamanmi achka runakuna, warmikuna shamurqanllapa, Jwanda uyaq.) Chaymi paykunata nirqan: —Uchaykikunata dijashpa, Dyustana kasushpa, shutikuyllapa, Dyus pirdunashunan uchaykikunamanda, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Chay Jwambaqmi Dyuspaq rimaq Isayiyasqa unay tyimpupi librumbi kayshina iskibrishqa karqan: Chunchakunapim suq runa ancha jwirtita rimashpa, kayshina rin yach'achikuq: “Dyus Akrashqan Washadurta shumaqta ch'ayachinayki, bidaykita allichayllapa suq ñandashina. ");
INSERT INTO qvcNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Chaqa mana allin yuyaynikikunam suq weqru ñanshina. Chayri chay mana baliq ñandashina bidaykita allichayllapa, Washadurninchiq mas allita qamkunaman ch'ayamunambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Chayshina bidaykillapata allichaptikiqam, yumbay runakuna rinllapa yach'aq: Kayshinam Dyus washawashun”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kanan achka runakuna, warmikuna tandakaptin shutichinanqam, Jwanqa wakinda nirqan: —¡A, qamkuna kulibrapa wambrangunata! ¿Pinamir nishurqan, Dyuspa ancha manchaypaq kastigunmanda washadu kanaykillapaqa? ");
INSERT INTO qvcNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mana allita rurashqaykirayku malayakushpa, chay uchakunata dijashpana, kananmandaqa allita rurashpa, kawsayllapa. Piru ama ni ashlita yuyayllapachu: “Abrajamba karu willkanguna kaptinchiqmi, Dyus washawashun”, nishpaqa. Ashwan allita intyindiwayllapa: Dyusmi kay rumikunamanda runakunata atin rurayta, Abrajamba karu willkanguna kanambaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Chaqa qamkunaqam uchata rurashpaqa, chay mana allin puqoq yurakunashina kangillapa. Chaymi Dyusqa qamkunaman achanda qemishqana. Listunam kuchushunanllapa. Chaqa Tayta Dyusqam yumbay chay mana baliq yurakunata kuchushpa, rin wichuq lumyaykaq ninaman rupanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Chayshina Jwan niptinmi, chay runakunaqa tapurqan: —¿Imatamiri atinillapa rurayta washakanayqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Chaymi Jwanqa nirqan: —Mayqanniki ishkay mudanayuq kashpaqa, suq mudanaykita qoyllapa chay mana mudanayuqta. Mayqanniki mikunayuq kashpaqa, chay mana mikunayuqta qoyllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Chay Jwanmanqam wakin kuntribusyunda kubrakuqkunapis ch'ayarqanllapa shutichinambaq. Paykunaqam Jwanda kayshina tapurqan: —Yach'achikuq Taytitu, ¿imatamiri noqaykunaqa atinillapa rurayta? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Chaymi Jwanqa nirqan: —Liy nishushqanshinalla kubrakuyllapa; ama mastaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Chaymandaqam wakin suldadukunapis Jwandaqa tapurqan: —Noqaykunaqa ¿imatataq atinillapa rurayta? nishpa. Chaymi paykunata nirqan: —Ama ni pitapis jurapashpa, ni yanqakunata tumbashpaqa, imanda qoch'iyllapachu. Ashwan paguykita ch'askishpa, kuntintakayllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Chaymi Jwambaqqa chay llaqta masin isrraylinukunaqa yuyarqanllapa: Paqtaraq payna Washadurninchiqqa, nishpa. (Chaqa unaymandapacham paykunaqa ancha shuyaykarqan, Dyus Akrashqan Washadur shamunambaq.) ");
INSERT INTO qvcNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Piru Jwanqam paykunataqa nirqan: —Alliptam niykillapa. (Manam paychu kani.) Piru shamuqnam rin. Noqaqam qamkunataqa yakupilla shutichiykillapa. Piru payqam ancha kamachikuq maski noqamanda. Chaymi Dyuspa Santu Ispiritumba pudirninwan ninawambis rin shutichishuqllapa, chay Santu Ispiritunwanna purinaykillapa. Pay shamuptinqam, noqaqa mana nimachu kashaq paypa ñawpambiqa. Manam ni llanqemba watunda paskanaypaq balishaqchu. ");
INSERT INTO qvcNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Dyusta kasuqkunaqam allin trigushina. Chaymi chay Washadurninchiqqa palan piskashqana, trigunda wayrachashpa, trujambi waqaychanambaq. Piru mayqan paypi mana kriyiqkunaqam tamushina. Chay tamutaqam rin wichuq chay mana nunka wañuq ninaman rupananllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kanan Jwanqam runakunata ancha allita chay Washadurpa shumaq nutisyanda yach'achirqan: —Dyus Akrashqan Washadurmi rinna shamuq washawananchiq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Chay Jwanqam anyashqa karqan gubyirnu Irudista, masanda traysyunda rurashqambaq, suq laya mana allikunata rurashqambaqpis. Chaqa chay Irudisqam masan Filipipa warmin Irudiyasta qoch'ishpa, payna purichiykarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Chaymi chay Irudisqa malpaq piskashpa, ashwamba maluta rurashpa, Jwandaqa karsilarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Piru Jwan manaraq karsilpi kashpam, ancha achka runakunata shutichirqan. Jisuspismi chay diyakunapi Jwanman rirqan shutichinambaq. Chaymandaqam Jisusqa shutikushpa, Dyusman mañakuykaptinqa, syiluqa kich'akarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Chaymandaqam Dyuspa Santu Ispiritun suq palumitashina shamurqan Jisuspa sawanman. Chay urasmi Tayta Dyusqa syilumandapacha payta kayshina nirqan: —¡Qami ancha kuyashqay Churiyqa kangi! ¡Qamwanmi ancha kushikuni! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jisukristu 30 watayuq kashpach'i, qallarirqan Tayta Dyuspaq yach'achikuq. Jisuspaqqam niqllapa: “Jusipa churinshi”, nishpa. Chay Jusipa taytanmi Eli shutiq. ");
INSERT INTO qvcNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elipa taytanqam Matat shutiq. Matatpaqam Libi; Libipaqam Milki; Milkipaqam Jana; Janapaqam Jusi; ");
INSERT INTO qvcNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Jusipaqam Matatiyas; Matatiyaspaqam Amus; Amuspaqam Nawun; Nawumbaqam Isli; Islipaqam Nagayi; ");
INSERT INTO qvcNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagayipaqam Mat; Matpaqam Matatiyas; Matatiyaspaqam Simiyi; Simiyipaqam Jusi; Jusipaqam Juda; ");
INSERT INTO qvcNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judapaqam Juwana; Juwanapaqam Rrisa; Rrisapaqam Surubabil; Surubabilpaqam Salatyil; Salatyilpaqam Niri; ");
INSERT INTO qvcNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Niripaqam Milki; Milkipaqam Adi; Adipaqam Kusam; Kusambaqam Ilmudam; Ilmudambaqam Ir; ");
INSERT INTO qvcNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Irpaqam Juswi; Juswipaqam Ilyisir; Ilyisirpaqam Jurin; Jurimbaqam Matat; ");
INSERT INTO qvcNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matatpaqam Libi; chay Libipaqam Simiyun; Simiyumbaqam Juda; Judapaqam Jusi; Jusipaqam Junan; Junambaqam Ilyakin; ");
INSERT INTO qvcNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ilyakimbaqam Miliya; Miliyapaqam Maynan; Maynambaqam Matata; Matatapaqam Natan; ");
INSERT INTO qvcNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natambaqam Dabid; Dabidpaqam Isayi; Isayipaqam Ubid; Ubidpaqam Bus; Buspaqam Salmun; Salmumbaqam Nasun; ");
INSERT INTO qvcNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasumbaqam Aminadab; Aminadabpaqam Aram; Arambaqam Isrum; Isrumbaqam Faris; Farispaqam Juda; ");
INSERT INTO qvcNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judapaqam Jakubu; Jakubupaqam Isak; Isakpaqam Abrajan; Abrajambaqam Tari; Taripaqam Nakur; ");
INSERT INTO qvcNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakurpaqam Siruq; Siruqpaqam Rragaw; Rragawpaqam Piliki; Pilikipaqam Ibir; Ibirpaqam Sala; ");
INSERT INTO qvcNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salapaqam Kaynan; Kaynambaqam Arfasad; Arfasadpaqam Sim; Simbaqam Nuwi; Nuwipaqam Lamik; ");
INSERT INTO qvcNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamikpaqam Matusalin; Matusalimbaqam Inuk; Inukpaqam Jarid; Jaridpaqam Malalil; Malalilpaqam Kaynan; ");
INSERT INTO qvcNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kaynambaqam Inus; Inuspaqam Set. Setpa taytanqam kashqa chay punta runa Adan. Adandaqam Dyus rurarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jisusmi chay rriyu Jurdambi shutikushpaqa, kutiykarqanna. Chayshina kutiykaptinqam, Dyuspa Santu Ispiritun shunqombi kaqqa suq chuncha lugarman aparqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Chaypiqam 40 diyas tukuyta karqan, mana nimata mikushpachu. Chaymi Jisus ancha mallaqnaptin, dyabluqa chaypi rikakurqan tyintanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Chaymi Jisustaqa nirqan: —Mayá, qam Dyuspa Churin allip kashpaqa, kay rumita kamachiy, tandapaq tikrakanambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Chayshina dyablu niptinmi, Jisusqa nirqan: —Dyuspa Santu Librumbim nin: “Runakuna, warmikunaqam mana mikunawanllachu kawsanqa. Ashwanmi Dyus tukuy ima nishqangunawan kawsanqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Chaymandaqam chay dyabluqa suq ancha altu qaqapa sawanman Jisusta apashpa, kay mundupa yumban nasyunningunata rikachishpa, ");
INSERT INTO qvcNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","nirqan: —Rikay kay ancha shumaq nasyungunata. Tukuy munaypaq imandindam noqa ch'askishqa kani. Chaymi pitapis atini qoyta. Mayá, qamta qoshqayki, qamna tukuy imapa dwiñun kanaykipaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Piru qam qonqorikushpa adurawaptikiqam, yumbay kaykunata qoshqayki, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Piru Jisusqam nirqan: —¡A, dyablu, ashuy ñawpaymanda! Chaqa Dyuspa Santu Librumbim nin: “Tayta Dyustalla aduray. Pay munashqandalla rurashpa kawsay”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Chaymandaqam dyabluqa Jisusta aparqan Jirusalin llaqtaman. Waqpim Dyuspa adurana wasimba mas altu sawanman surqoshpa, Jisusta nirqan: —Mayá, Dyuspa Churin allip kashpaqa, kaymanda ura pachakaman brinkay. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Chaqa Dyuspa Santu Librumbim nin: “Dyusmi anjilningunata rin kamachiq kwidashunambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Chaymi makingunapi rinllapa ch'askishuq, ama ni ch'akikikuna waq ura rumikunapi tupakashpa chuqrikanambaq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Chayshina dyablu niptinmi, Jisusqa nirqan: —Dyuspa Santu Librumbiqam niwanchiqpis: “Dyusnikitaqar ama mallipaychu, munashqaykita ruranambaq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Chayshina dyablu tukuy layata rurashpa, mana atishpa tyintaytaqam, Jisuspa ñawpanmanda suq tyimpupaq ashurqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jisusmi Santu Ispiritupa pudirninwan kutirqan prubinsya Galiliyaman. Kanan chay Galiliyapa yumbay llaqtangunapim waqpi kaypi famanqa shikwakarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Chaqa Jisusqam kada llaqtaman ch'ayashpaqa, sinaguga wasikunaman yaykushpa, shumaqta yach'achikurqan. Chaymi yumbay ancha alabaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jisusmi uywakashqan llaqta Nasaritman kutirqan. Waqpim samana diyapi sinaguga wasiman rirqan, chayshina kustumbrin kaptin. Chaymi atarishpa, ñawpanllapaman riptin liyiq Dyuspa Santu Librunmandaqa, ");
INSERT INTO qvcNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","qorqanllapa Dyuspaq rimaq Isayiyaspa librunda. Chaymi chay libruta ch'askishpa, kich'ashpa, kayshina liyirqan: ");
INSERT INTO qvcNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Taytanchiq Dyusmi Ispiritunda qowashqa. Chaqa akrawashqam, paypa shumaq nutisyanda pubrikunata yach'achinaypaq. ˻Kach'amuwashqam llakishqa kaqkunata kunswilanaypaq˼ prisukunata ninaypaq: “Ringillapanam lluqshiq”, nishpa, sarkukunata chapachinaypaq; chay qesachadu kaqkunata washanaypaq; ");
INSERT INTO qvcNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","yumbayta ninaypaq: “Rinnam ch'ayamuq Siñurnikipa allin tyimpun. Chay tyimpupim payqa ancha rin yanapashuqllapa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jisusmi chayta liyishpaqa, chay librundaqa kutichirqanna chay sinaguga wasipi yanapakuqta. Chaymandaqam tiyarqanna. Chaymi yumbay chaypi kaqkunaqa ancha unayta chaparqanllapa Jisustaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Chaymi Jisusqa nirqan: —Dyuspa Santu Librunmanda kay liyishqayqam kanan diya ñawpaykillapapi kumplishqana, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Chaymi yumbay chay uyaqkunaqa ispantashqata, Jisusta ancha alabashpa, kayshina parlaqllapa: —¡Ancha shumaqtaraq riman! nishpa. Piru chayshina nishpaqam, suqnin suqnin paypura nirqanllapa: —Piru kay runaqam Jusipa churin, ¿manachu? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Chaymi Jisusqa paykunata nirqan: —Qamkunaqach'i chay rimashqaypaqqa niwangimanllapa: “Qam ambikuqqar, qamlla ambikashpa, kach'akay. Mayá, waq Kapirnawun llaqtapi yumbay chay rurashqayki milagrukunata, kay llaqtaykipipis ruray rikanaypaqllapa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Chayta nishpaqam, Jisusqa nirqambis: —Alliptam niykillapa, Dyuspaq rimaqkunataqam mana allitaqa ch'askinllapachu kikin llaqtambiqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Manchu Dyuspaq rimaq Eliyaspa tyimpumbim kimsa wata y midyuta mana tamyarqanchu. Chaymi tukuy Isrrayilpi ambrunawan ancha padisirqanllapa. Chay tyimpupim Isrrayilpiqa achka biyudakuna karqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Piru Dyusqam chay rimaq Eliyastaqa mana ni suq isrraylina biyudaman kach'arqanchu yanapanambaq. Ashwanmi kamachirqan suq nasyunman rinambaq, chay prubinsya Sidumba Saripta llaqtanman, suq biyudata yanapanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Chayshinallam Dyuspaq rimaq Elisiyupa tyimpumbipis Isrrayilpiqa achka ismuykaq kwirpuyuq runakuna karqan. Piru Elisiyupismi mana ni mayqanninda kach'akachirqanchu. Ashwanmi chay nasyun Siryamanda kaq runa Naman shutiqta kach'akachirqanqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Chayshina Jisus furastirukunata sawachashpa niptinmi, chayta uyashpa, chay sinaguga wasipi yumbay kaqkunaqa ancha piñakurqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Chaymi Jisusta piskashpa, chay Nasarit llaqtamanda aparqanllapa, suq filamanda wichukuq. Chaqa chay llaqtaqam ancha altu qaqapa sawambi karqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Piru Jisusqam paykunapa ch'awpinda rirqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jisusqam rirqan prubinsya Galiliyapa Kapirnawun llaqtanman. Chay llaqtapiqam samana diyapi sinaguga wasiman rishpa, chaypi ");
INSERT INTO qvcNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ancha yach'ayniyuq kamachikuq kashpa, yach'achikurqan. Chaymi uyaqkunaqa ancha ispantarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Chay sinaguga wasipiqam karqan suq runa. Paypiqam dyablupa ispiritun tiyaq. Chaymi chay runaqa kayshina qayach'akurqan: ");
INSERT INTO qvcNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡A, qam, Jisus Nasaritmanda kaq! ¡Dijawayllapa! ¡Ama mitikuychu noqaykunamanqa! ¿Ima, kayman shamushpachu, ringi chingachiwaqllapa? ¡Noqaqam riqsiyki! ¡Qamqam Dyuspa santu Churin kangi! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Chaymi Jisusqa chay dyabluta anyashpa, nirqan. —¡Uyaray! ¡Lluqshiy kay runamanda! nishpa. Chayshina Jisus kamachiptinqam, chay dyabluqa yumbaypa ñawpanman runata waqtakushpa, mana chuqrishpachu, paymanda lluqshirqanna. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Chayta rikashpam, runakunaqa ancha ispantashqata suqnin suqnin Jisuspaq parlarqanllapa: —¿Ima laya pudirniyuq awturidar kashpam, dyablukunata atin qatiyta? ¡Rikay, “Lluqshiy” niptinlla, chay dyablukunaqa das lluqshin! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Chay famanqam chay llaqtamandaqa chay prubinsyapa yumbay lugarningunaman shikwakarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Chaymandaqam Jisusqa chay sinaguga wasimanda lluqshishpa, Simun Pidrupa wasinman rirqan. Chay Simumba swigranmi ancha jwirti jibriwan qeshyaq kamapi karqan. Chaymi Jisusta rrugarqanllapa kach'akachinambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Chayraykum Jisusqa qeshyaqman rishpa, kumurashpa, jibritaqa anyarqan. Chayshina anyaptinllam, chay warmiqa jibrimanda das kach'akarqan. Kanan chay urasmi atarishpa, paykunata qararqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Rupay seqaykaptinnam, tukuy laya nanayniyuqkunata apamurqanllapa Jisusman. Chaymi payqa makinda suqpa suqpa sawanman rurashpa, yumbayta kach'akachirqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Achka runakunamandam dyablukunata qatirqan. Chaymi dyablukunaqa lluqshishpa, qayach'akurqan: —¡A, qamqam Dyuspa Churin kangi! nishpa. Piru Jisusqam paykunata anyashpa, mana dijarqanchu masta rimananllapa. Chaqa chay dyablukunaqam yach'arqanllapa: Jisusqam Dyus Akrashqan Washadur, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Achikyaykaptinnam, Jisusqa chay llaqtamanda lluqshishpa, suq chunchamanna rirqan. Chay chunchapi kaykaptimbismi, ancha achka runakuna, warmikuna maskarqan tarinangaman. Chaymi tarishpaqa, ancha rrugarqanllapa, paykunamanda amana rinambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Piru Jisusqam paykunata nirqan: —Rinim suq llaqtakunamambis, Taytay Dyuspa shumaq nutisyanda yach'achikuq, payta allita kasunanllapa. Chaqa chaypaqmi noqataqa kach'amuwashqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Chayshina nishpam, Jisusqa chay prubinsya Galiliyapi llaqtan llaqtan purishpa, sinaguga wasikunapi yach'achikurqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Suq diyam Jisusqa Jinisarit atun qoch'apa manyambi kaykarqan. Nuta: Chay Jinisarit qoch'allam Galiliya qoch'apis shutiq.  Chaypim Jisusqa Tayta Dyus nishqanda yach'achikuykarqan. Chaymi ancha achka shamuqkuna ancha kumsanakushpa Jisusta kich'kichashpa yaqqa bularqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Chayshina yaqqa bulaptinllapaqam, Jisusqa rikarqan ishkay yakupi puriq barkuta chay qoch'apa manyambi shayaykaqta. Chaqa piskaduta piskaqkunaqam chay barkukunamanda ishkishpa, atarrayangunata mayllaykarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Suq barkum Simun Pidrupa karqan. Chay barkunman Jisus lluqshishpam, chay Simunda nirqan: —Kay barkuykita kay manyamanda ashlita waqkaq apay, nishpa. Chayshina apaptinmi, Jisusqa chay barkupina tiyashpa, chay atun qoch'amanda chay manyambi kaqkunata yach'achirqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ushyashpa yach'achikuytaqam, Simun Pidruta nirqan: —Barkuykita kay atun qoch'apa mas ch'awpinman apashpa, atarrayaykita wichuyllapa, piskadukunata piskanayki, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Chaymi Simun Pidruqa nirqan: —Yach'achikuq Taytitu, kay tutam yuraqashtin yanqa trabajashpa, mana nimatapis piskashqallapachu kani. Piru qam niwaptikiqa, atarrayayta wichurishaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Chaymandaqam atarrayanda wichuptinqa, allipta ancha achka piskadukuna atarrayambiqa bulsachakarqan. Chaymi llashaqwanqa atarrayanqa llikikaykarqanna. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Chayshina kaptinqam, paykunaqa makingunawan siñiyakushpa, qayarqanllapa chay suq barkupi kaq kumpañirungunata, shamunambaqllapa yanapaq. Shamuptinllapaqam, yumbayninmanda ishkandin barkuta ancha undachirqanllapa piskadukunawan. Chaymi chay barkukuna ancha llashaqwanqa yaqqa seqarqanllapa chay atun qoch'aman. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Chaymi Simun Pidruqa Jisuspa ñawpambi qonqorikushpa, nirqan: —Kamachikuq Taytitu, noqaqam ancha uchayuq runa kani. Chaymi rrugayki noqamandaqa ashunaykipaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Chaqa Simun Pidruqam chay pullan kaqkunawan ancha achka piskaduta surqoshqanrayku, Jisuspaq ancha ispantarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Simun Pidrupa kumpañirungunam Jakubuwan Jwan karqan. Paykunaqam Sibidiyupa churinguna karqan. Jisusmi Simun Pidrutaqa nirqan: —Ama manchaychu. Chaqa piskadukunata maskashqaykishinam, kananmandaqa runakunatana maskashpa, ringi yach'achiq, noqapi kriyinanllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Chaymi paykunaqa barkunllapata atun qoch'amanda manyanman surqoshpaqa, chaypina tukuy imandinda dijashpa, Jisuswanna rirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Suq llaqtapi Jisus kaykaptinmi, payman ch'ayarqan suq runa ismuykaq kwirpuyuq. Chaymi Jisusta rikashpaqa, ñawpanman rishpa, qonqorikushpa, qaqllanda pachaman ch'ayachishpa, ancha rrugarqan: —Kamachikuq Taytitu, munashpaqam kay nanayniymanda atingi kach'akachiwayta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Chaymi Jisusqa chay millanaypaq runapa sawanman makinda rurashpa, nirqan: —Munanim kach'akachishuyta. Chayri kanalitan kach'akay, nishpa. Chayta niptinllam, chay qeshyayqa limpu chingarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Chaymandaqam Jisusqa chay runata kamachirqan: —Amakish pitapis parlachingichu kay kach'akachishushqaypaq. Ashwan kuramanlla rishpa, Muysis kamachikushqanshina ufrindaykita Dyuspaq qoy, yumbay yach'anambaq: Waq runaqam kach'akashqana, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Piru Jisuspaqqam chay parlaqa diyapi diyapi ashwamba shikwakarqan. Chaymi ancha achka runa ch'ayamurqanllapa, payta uyanambaq, nanayninmanda kach'akachinambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Piru Jisusqam paykunamanda ladiyashpa, kutin kutin rirqan chuncha lugarkunaman, Tayta Dyusman mañakuq. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Suq diyam Jisus yach'achikuykaptin, chaypi tiyaykarqan wakin farisiyu duktrinayuqkuna, Muysispa liyningunata wakin yach'achikuqkuna. Paykunaqam shamushqallapa karqan prubinsya Galiliyapa, prubinsya Judiyapa llaqtangunamanda, Jirusalinmandapis. Kanan Jisusqam Dyuspa pudirninwan qeshyaqkunata kach'akachiykarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Chaymi wakin runakunaqa suq runa wañushqashina kwirpuyuqta parapi apamushpa, ch'ayamurqanllapa. Paykunaqam ancha munarqanllapa ukuman yaykuyta Jisuspa ñawpanman, chaypi chay qeshyaqta kach'akachinan. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Piru ancha unda runa kaptinmi, mana mayta atirqanllapachu yaykuytaqa. Chaymi wasipa sawanman qeshyaqta surqorqanllapa. Chaymandaqam tijakunata ashuchishpa, waskakunawan parambi watashpa, qeshyaqtaqa uku runakunapa ch'awpinman, Jisuspa ñawpanman ishkichirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Chaymi Jisusqa ancha kriyiqkunata rikashpa, nirqan: —Runita, uchaykikunamandam pirdunayki, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Chay nishqambaqmi Muysispa liyningunata chay yach'achikuqkuna, chay farisiyu duktrinayuqkuna yuyarqanllapa: “¿Ima pitaq kay runaqa chayshina nishpa Dyusshina tukushpa, Tayta Dyusta burlaykan? ¡Paqta imanan ima! Chaqa manam pipis atinchu runakunapa uchangunata pirdunayta. Tayta Dyusllam atin pirdunaytaqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Chaymi Jisusqa yuyashqanllapata yach'ashpa, paykunata nirqan: —¿Imaraykutaq chay mana baliqkunata yuyaykangillapa? ");
INSERT INTO qvcNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Mayá, ¿imataq mas trabajus ruranaypaq, ichu ninaypaq: “Uchaykikunamandam pirdunayki” ichu ninaypaq: “Kach'akachiykim; atarishpana, riy” nishpa? ");
INSERT INTO qvcNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Chaymi rini rikachishuq yach'anaykillapa: Tayta Dyusmi Jisukristuta pudirniyuqta numbrashqa, runakunata uchangunamanda pirdunanambaq, nishpa. Chaymandaqam Jisusqa chay runa wañushqashina kwirpuyuqta nirqan: —Qamtam niyki, atarishpa, paraykita apashpa, riyna wasikiman, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Chayshina kamachiptinllam, yumbay chapaykaptin, das atarirqan. Chaymi chay uras paranda tandashpa, Dyusta ancha alabaqshina rirqanna wasinman. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Chayta rikashpam, yumbay chaypi kaqkunaqa ancha ispantashqata Dyusta ancha alabarqanllapa. Kanan manchashqatam kayshina parlarqanllapa: —Mana nunka rikashqanchiqtam kananqa rikanchiq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Chaymandaqam Jisusqa chay kashqanmandaqa rirqanna. Chaymi riqshinaqa rikarqan suq runa Libi shutiqta. Nuta: Chay Libillam Matiyupis shutiq.  Chay Libiqam tiyaykarqan kuntribusyun kubrakunan dispachumbi. Kanan Jisusqam Libitaqa nirqan: —Shamuy, aku noqawan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Chaymi Libiqa das atarishpa, tukuy imata dijashpa, Jisuswanna rirqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Chaymandaqam chay Libiqa Jisusta wasinman apashpa, suq atun fyistata paypaq rurarqan. Kanan wakin kuntribusyunda kubrakuqkuna, suq runakunapismi chay mesapilla pulla tiyaykarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Chaymi chayta rikashpaqa, farisiyu duktrinayuqkuna, Muysispa liyningunata yach'achikuqkunaqa ancha piñakushpa, Jisuspa yach'akuqningunata kayshina anyarqanllapa: —¿Imaraykutaq qamkunaqa kuntribusyunda kubrakuqkunawan, suq laya uchayuq runakunawan tandakashpa mikuykangillapa, upyaykangillapaqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Chaymi Jisusqa chay piñakuqkunata nirqan: —Qeshyaqkunallam munan ambikuqtaqa. Chay mana qeshyaqkunaqam ambikuqtaqa mana munanchu. (Kay uchayuqkunaqam chay qeshyaqkunashinaqa.) ");
INSERT INTO qvcNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Chayshinallam noqaqa shamushqa kani uchayuqkunata qayanaypaq, uchangunata dijashpa, Dyuspi kriyinanllapa. Piru manam shamushqachu kani chay mana uchayuq tukuqkunata qayaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Wakin runakunam Jisusta tapurqan: —Jwan Shutichikuqpa yach'akuqninguna, yumbay farisiyu duktrinayuqkunaqa ancha ayunanllapa; kutin kutin Dyusman mañakunllapa. ¿Imaraykutaq qamba yach'akuqnikikuna mana ayunashpachu mikunllapa, upyanllapa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Chaymi Jisusqa paykunata nirqan: —Mayá, suq kasaraq runa kumpañirungunata kumbidashpa, fyistapi kaptinqachuraq, ¿atingimanllapa chay kumpañirungunata ayunachiyta? Manám. Chayshinallam kay yach'akuqniykunapis pullay kushikuykashpaqam, mana ayunanllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Piru suq diyam kuntrawaqkuna paykunamanda rinllapa akrawaq. Chayshina akrawaptinraqmi, kay yach'akuqniykunapis rinllapana ayunaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jisusqam kayshinapis suq kumparasyunda rurarqan: —Manam pipis mushuq mudananmanda suq pidasuta kuchunchu, mawka mudananda rrimindananqa. Chaqa mushuq mudananda kuchuptinqam qesachakan. Kanan mushuq rritasuqam mana pullachu mawkawanqa. Siraptinqam mana shumaqchu kanqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Chayshinallam llullu binutapis mana wichunchiqchu mawka qara taligamanqa. Chaqa llullu binuqam qarwashpa, mawka qara taligataqa pach'yachin. Chayshinam binu, qara taligaqa qesachakan. ");
INSERT INTO qvcNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Chayri mushuq binutaqa wichushun mushuq qara taligaman (chay qara chutakashpa, ama pach'yanambaq). Nuta: Chay llullu binuqam Jisuspa mushuq nutisyanshina. Chay mawka qara taligaqam isrraylinukunapa chay unay kustumbringunashina.  ");
INSERT INTO qvcNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Piru chay qarwashqa binutalla upyaqqam, llullu binutaqa mana munanllapachu: Qarwashqa binum noqapaqqa mas allinqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Suq samana diyapim Jisusqa yach'akuqningunawan tarpudukunapa ukunda pasaykarqan. Chaymi yach'akuqningunaqa mallaqnashpa, triguta pitishpa, qaqoshpa, mikuykarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Chaypaqmi wakin farisiyu duktrinayuqkuna Jisusta anyarqanllapa: —Samana diyapiqam mana balinchu trabajananchiqqa. ¿Imaraykutaq kay samana diyapi wakin yach'akuqnikiqa trigupa ispigangunata pitikushpa, qaqokushpa trabajaykanllapa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Chaymi Jisusqa paykunata nirqan: —Ima, ¿manachu liyishqallapa kangi chay unay gubyirnu Dabid kumpañirungunawan mallaqnashpa rurashqandaqa? ");
INSERT INTO qvcNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Karpamanda adurana wasipi ufrinda tandakuna kaqmi kurakunapaqlla karqan. Piru Dabid mana dirichuyuq kashpapismi, chay adurana wasiman yaykushpa, chay ufrinda tandakunata mikushpa, chay kumpañirungunatapis qorqan mikunambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Chaymandaqam Jisusqa nirqan: —Noqaqam Dyusmanda Shamuq Runa kashpa, samana diyapa dwiñun kani. Chaymi atini kamachikuyta: Kaymi alli ichu kayqam mana allichu, samana diyapi rurananchiqqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Suq samana diyapim Jisusqa sinaguga wasiman rishpa, chaypi yach'achikuykarqan. Chay ukupiqam suq runa allin ladu qendishqa makiyuq karqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Chaymi Muysispa liyningunata yach'achikuqkuna, farisiyu duktrinayuqkunaqa Jisusta ancha chaparqanllapa: ¿Payqachu rin kach'akachiq chay runata kay samana diyapi ichu mana? nishpa. Chaqa paykunaqam yuyarqanllapa, chaypaq tumbashpa dimandananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Piru Jisusqam yuyayninllapata yach'ashpa, chay qendishqa makiyuq runata nirqan: —Atarishpa, shamuy kay ch'awpiyllapaman, nishpa. Chaymi runaqa atarishpa ch'awpinllapapina shayarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Chaymandaqam Jisusqa chay jusgaqkunata nirqan: —Mayá, niwayllapa: ¿Imatam Tayta Dyus kamachiwanchiq, samana diyapi rurananchiqqa? ¿Allita rurananchiq ichu maluta? ¿Suq runata washananchiq, ichu wanchinanchiq? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Chayshina Jisus nishpaqam, yumbay chay rridurnimbi kaqkunata chapashpa, chay qendishqa makiyuq runata nirqan: —Chutay makikita, nishpa. Chaymi chay runa makinda diki chutaptinlla, qendishqa kashqanmandaqa dasna allinyarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Chayta rikashpaqam, chay kuntraqkunaqa ancha fiyuta piñakurqanllapa. Chaymi paykunapura parlarqanllapa: ¿Imanachishundaq Jisusta? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Chay diyakunapim Jisusqa rirqan suq lumaman Dyusman mañakuq. Chay lumapiqam chay tutaqa yuraqarqan Dyusman mañakushpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Chaymandaqam achikyaptinqa, yach'akuqningunata qayashpa, yumbay paykunamanda dusita akrashpa numbrarqan, apustulninguna kanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Chay dusi apustulningunaqam kaykuna karqan: Simun; payllam Pidrupis shutirqan; paypa masan Andris; wakinqam Jakubu, Jwan, Filipi, Bartulu, ");
INSERT INTO qvcNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiyu, Tumas, Alfiyupa churin Jakubu. Suq Simun shutiqtapismi akrarqan, apustulnin kanambaq. Paymi isrraylinu Kananista partidumanda karqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ishkay apustulkunaqam Judas shutirqan. Suqqam Jakubupa masan karqan. Suqqam Judas Iskaryuti shutirqan. Chay Judas Iskaryutim suq tyimpupi Jisusta kuntraqkunaman intrigakurqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jisusmi chay lumamanda yach'akuqningunawan shamushpa, suq pambaman ch'ayarqanllapa. Chaypim ashla unayarqan. Ancha achka runa, warmim chay pambaman ch'ayamushqallapa karqan prubinsya Judiyapa kapitalnin Jirusalinmanda, yumbay llaqtangunamanda, Tiru llaqtapa, tukuy Sidun llaqtapa kustangunamanda. Paykunaqam shamushqallapa karqan Jisusta uyanambaq, qeshyayningunamanda kach'akanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Chaymi Jisusqa paykunata kach'akachishpa, runakunamanda dyablukunatapis qatirqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kanan payqam ancha pudirniyuq kashpa, qeshyaqkunapa sawanman makinda rurashpa, yumbayta kach'akachirqan. Chaymi yumbay qeshyaqkunaqa imashinapis munarqanllapa Jisusman makinda rurayta kach'akanambaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisusmi yach'akuqningunata chapashpa nirqan: —Qamkuna pubrikunaqar kushikuyllapa. Chaqa Tayta Dyus allita kamachikushpaqam, shumaqta rin ch'askishuqllapa, paywan kawsanaykillapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Kanan qamkuna mallaqnaqkunapisri kushikuyllapa. Chaqa suq diyaqam ringillapa undaq. Qamkuna waqaqkunapisri kushikuyllapa. Chaqa suq diyaqam ringillapa kushikuq. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Noqapi kriyishqaykirayku ch'iqnishuptinllapa ichu qatishuptinllapa ama tandakanayki paykunaman, ichu mana allikunata rimashuptinllapa, ichu malukunatashina musyashuptinllapaqa, kushikuyllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Chaqa ancha shumaq primyutam syilupiqa ringillapa ch'askiq. Unay tyimpupipismi chay ch'iqnishuqkunapa agwilungunaqa chayshinalla Dyuspaq rimaqkunata ancha qesacharqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Piru ¡imanangillaparaqri qamkuna kapuqkunaqa! Dyuswanqam mana ringillapachu kushikuq. Chaqa kay pachapi bwina bidata pasashpaqam kushikuykangillapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’¡Ay, imanangiraqri qamkuna unda unda mikuqkunaqa! Chaqa ringillapam mallaqnaq. ¡Imanangiraqri qamkuna asikuqkunaqa! Chaqa ancha llakishpam, ringillapa waqaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’¡Ay, imanangiraqri qamkuna, runa masikimanda alabashqakunaqa! Chaqa chay alabashuqkunapa unay agwilungunapismi Dyuspaq rimaq tukuqkunataqa chayshinalla alabarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Piru qamkuna uyawaqkunatam niykillapa, kuntraykikunata kuyayllapa. Ch'iqnishuqkunata allita rurayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Maldisyashuqkunata niyllapa: “Dyus yanapashunqa”, nishpa. Musyashuqkunapaq Dyusman mañakuyllapa, paykunata yanapanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mayqan runa suq ladu qaqllaykipi takashuptinqa, suq ladutapis qoy, chaypipis takashunambaq. Kapaykita qoch'ishuptimbis, kushmaykitapis dijay apanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mayqan imata mañashuptimbis, qoy. Pi imaykita qoch'ishuptimbis, amana mañaychu kutichishunanqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Qamkuna munashpa runa masikikuna allita rurashunambaqqa, paykunatapis chayshina allitalla ruray. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Kuyashuqkunatalla kuyaptikiqam, Dyuspaqqa mana balingillapachu. Chaqa chay ancha uchayuqkunapismi kuyaqkunatalla kuyan. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Chaymi qamkuna faburta rurashuqtalla faburta ruraptikiqa, Dyuspaqqa mana balingillapachu. Chaqa asta chay ancha uchayuq kaqkunapismi chayshinalla ruranllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","(Chayri qamkunapa imayki kaptinqa, runa masiki ima nisitashqanda pristayllapa.) Piru imata qoshunanrayku pristaptikiqam, Dyuspaqqa mana balingillapachu. Chaqa chay uchayuqkunapismi pristan chay iman qoqkunatalla. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Piru qamkunaqar ashwan kuntraykikunata kuyashpa, allita rurayllapa. Qamkunapa imayki kaptinqar, ima nisitashqanda pristayllapa. Piru ama imata qoshunanraykuchu pristayllapaqa. Chayshina allita ruraptikiqam, Dyusqa ancha shumaq primyuykita rin qoshuqllapa. Chayta rurashpallapaqam, Dyuspa wambranguna ringillapa kaq. Chaqa Dyusqam ancha allin kashpa, chay mana ni agradisiqkunata, chay malukunatapis yanapan. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Chayri ancha allin Taytanchiq Dyus llakipashuptinqa, qamkunapis llakipakuqkuna kayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Ama jusgakuychu, qamkunapis ama jusgadu kanaykillapa. Suqkunata ama wichupayllapachu, qamkunapis ama wichupadu kanaykillapa. Ashwan suqkunata pirdunayllapa, qamkunapis pirdunadu kanaykillapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Imayki kaptimbis, suqkunata qoyllapa. Chayshina qoptikiqam, Tayta Dyus rin qoshuq. Chaqa Dyusqa ancha achkata qoshushpa, kuyuchishpa, ch'apsishpa, llapchashpa, ich'akaykaqta rin millqachishuq. Chay ima tantuta yanapaptikim, Dyuspis chay tantuta rin yanapashuqllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Chaymandaqam Jisusqa kay kumparasyundapis yach'akuqningunata nirqan: —Suq sarku runaqa ¿imashinaraq apanman suq sarkutaqa? Manam atinchu. ¿Imanaymi apanqaqa? Ashwambam suq ush'kuman ishkandin seqanmanllapa, ¿manachu? ");
INSERT INTO qvcNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Chayshinallam suq yach'akuqqa mana rinchu binsiq yach'achikuqnindaqa. Piru tukuy imata allita yach'akushpaqam, chay yach'achikuqninshina atin kayta. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’Qamkuna mas uchayuqkunaqa ama jusgayllapachu, kriyiq masiki ashla uchata ruraptinqa. Chaqa jusgashpaqam, paypa ñawimbi suq pidasu uqshitashina kaqta chapaykangishina, mana intyindishpa qamba ñawikipi suq bigashina kashqanda. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Chayshina chay kikin ñawikipi suq ancha atun biga kashqanda mana rikashpaqa, ¿manachu penqakungi masaykita ninayki: “Masita, dijaway ñawikimanda chay uqshitata surqonaypaq” nishpaqa? ¡A, qamkuna shimikiwanlla kasukuqkuna! ¡Suqta jusganaykiqam kan grasyayki! ¡Chaqa suqta jusganaykimandaqa puntata qamba ñawikimandaraq chay ancha atun bigata surqoy! Chayshina allita chapakushparaqmi, kriyiq masikipa ñawinmanda uqshitataqa atingi surqoyta. Manaqa manam atingichu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Suq yura mana baliqqam mana allitaqa puqonchu. Piru suq allin yuraqam allinda puqon. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Chayshinam yumbay plantakunataqa puqoyninmanda riqsinchiq, ¿manachu? Kashamandaqam mana iguskunataqa pallanchiqchu. Chayshinallam chay sarsamandapis mana ubaskunataqa pallanchiqchu. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Chayshinallam allin runaqa allikunata riman, allin yuyaykuna shunqombi kashqanrayku. Piru chay mana allin runakunaqam mana baliqkunata riman, malu yuyaykuna shunqonllapapi kashqanrayku. Chaqa shunqombi ima laya yuyaykuna kashqandam shiminwanqa rimanllapa; manam maymandachu. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Imaraykutaq qamkunaqa “Siñursitu, Siñursitu” niwangillapaqa, nishushqayta mana kasushpaqa? ");
INSERT INTO qvcNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Suq kumparasyunda nishqaykillapa. Noqata allita kasuwaqkunaqam suq yach'ayniyuq runa wasita ruraqshina. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Chay yach'ayniyuq runaqam wasinda ruranambaqqa allakurqan uku angu rumiman ch'ayashtin. Chaymandaqam chay jwirti rumipa sawambina simyintunda rurashpa, wasinda alsarqan. Chaymanda ushyaptinqam, rriyu undashpa, ancha jwirtita ch'ayamurqan bulaq chay wasitaqa. Piru manam ni kuyuchirqanchu, rumipa sawambi allin simyintuyuq kashqanrayku. Chay rumipa sawambi wasikuqshinam noqata kasuwaqkunaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Piru mana kasuwaqkunaqam suq runa pamba allpapi mana simyintuyuq wasinda ruraqshina. Chaqa wasinda ushyaptinqam, chay rriyu undashpa, ancha jwirtita ch'ayamushpa, chay wasi mana simyintuyuqta bulashpa, limpu chingachirqan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisusqam paykunata yach'achishpaqa, rirqanna Kapirnawun llaqtaman. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Chaypim suq rrumanu suldadu tiyaq. Chay suldaduqam achka suldadukunapa kamachikuqnin karqan. Paypam suq ancha kuyashqan kriyadun qeshyaq wañuykarqanna. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Chay rrumanu suldaduqam Jisuspa famanda yach'arqan. Chaymi kach'arqan kamachikuq ansyanu isrraylinukunata, rinambaqllapa Jisusta rrugashpa apamuq, kriyadunda kach'akachinambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Chaymi kach'adungunaqa rishpa, Jisusta ancha rrugarqanllapa: —Ancha allinmi chay rrumanu suldaduqa. Yanapayri yush'ayku. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Chaqa noqanchiq isrraylinukunatam ancha kuyawanchiq. Chaymi sinaguga wasita rurashqa noqaykunapaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Chayshina niptinqam, Jisusqa chay rrugaqkunawanna rirqan. Chaymi suldadupa wasinman yaqqana ch'ayaptinqa, chay rrumanuqa wakin kumpañirunda kach'arqan, ñanmanlla tingushpa, ninanllapa: —Taytitu, amar piñakuychu. Amanar kaykamanqa shamuychu. Chaqa manamir baliq runachu kani, kay wasiyman yaykunaykiqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Chaymi mana rirqaychu noqa kikiy maskashuqqa. Kamachikuyri. Chay nishqaykiwanllam kriyaduyqa rin kach'akaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Chaqa noqapismi kamachiwaqta kasuni. Chayshinallam kamachishqay suldaduykunapis kasuwan. Suqninda “Riy”, niptiymi, rin. Suqta “Shamuy”, niptiymi, shamun. Kriyaduyta kamachiptiy, imata ruranambismi ruran. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Chayshina niptinmi, Jisusqa ancha ispantashpa, kushikurqan. Chaymi tikrakashpa chay pullan riqkunata nirqan: —Alliptam niykillapa, kay ancha kriyiq runatashinaqam mana ni suqta tarishqachu kani, ni kay llaqta masinchiq isrraylinukunapi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Chaymandaqam chay kach'adungunaqa wasiman kutirishpaqa, chay kriyadun qeshyaqtaqa kach'akashqatana tarirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Chaymandaqam Jisusqa Nayin shutiq llaqtamanna rirqan. Paypa pullanmi rirqanllapa yach'akuqninguna, ancha achka runakuna, warmikuna. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Chay Nayin llaqtaman yaqqana ch'ayashpaqam, rikarqan suq almata apaykaptinllapa pambaq. Chay wañushqaqam suq biyudapa sapalan ullqo wawan kashqa karqan. Chay llaqtamandaqam achka runakuna, warmikuna riykarqan pambakuq, chay biyudata kumpañashpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Chaymi Jisusqa chay biyudata chapashpa, llakipashpa nirqan: —Amar waqaychu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Chaymandaqam almaman qemikashpa, paranman makinda rurarqan. Chaymi chay apaqkunaqa riykashqanmanda shayaptin, Jisusqa chay almata nirqan: —Wambra, qamtam niyki, ¡atariy! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Chayshina niptinllam, chay wañushqa wambraqa alsakamushpa, parlarqanna. Chaymandaqam Jisusqa chay wambrataqa kawsaqtana mamanda intrigarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Chaymi rikaqkunaqa manchashqata chapashpa, Dyusta kayshina alabarqanllapa: —¡Dyuspaq suq ancha kamachikuq rimaqmi kay noqanchiqkunaman shamushqa! nishpa. Nirqanllapapismi: —Tayta Dyusmi shamushqa yanapawananchiq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kanan Jisuspa famanqam chay prubinsya Judiyapa tukuy rridurnin llaqtakunaman shikwakarqan, “Jisusshi kawsachikushqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Chaykunata Jisukristu ruraptinmi, Jwan Shutichikuqpa yach'akuqninguna yach'arqan. Chaymi paykunamanda yach'ashpa, Jwanqa ishkay yach'akuqninda qayashpa, ");
INSERT INTO qvcNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Jisusman kach'arqan, kayshina tapunambaq: —Mayá, ¿qamchu Dyusmanda chay shamunambaq Washadur kangi, ichu suqtaraq shuyashaqllapa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Chaymi chay kach'adungunaqa rishpa, Jisusta nirqan: —Jwan Shutichikuqmi kach'amuwashqa tapushunayllapa: “¿Qamchush Dyusmanda chay shamunambaq Washadur kangi, ichu suqtaraq shuyashaqllapa?” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Chay urasmi Jisusqa achka qeshyaqkunata kach'akachiykarqan. Wakinmandaqam dyablukunata qatiykarqan. Achka sarkukunatapismi chapachiykarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Chaymi Jisusqa chay tapuqkunata nirqan: —Kutirishpa, Jwanda niyllapa kay rikashqaykillapata, uyashqaykillapata, sarkukuna rikakushqanda, kujukuna purishqanda, ismuykaq kwirpuyuqkuna kach'akashqanda, surdukuna uyakushqanda, wañushqakuna kawsamushqanda, pubrikuna Dyuspa shumaq nutisyanda uyashqanda. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kanan noqapi mana shaykuq kriyiqkuna kushikunqallapa. Chayta Jwanda niyllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Chayshina niptinmi, chay kach'adungunaqa Jwanmanna kutirirqan. Riptinllapaqam, Jisusqa chaypi kaqkunata kayshina yach'achikurqan Jwan Shutichikuqpaq: —¿Ima laya runatam rirqaykillapa chapaq chay chuncha lugarmanqa? ¿Rirqaykillapachu chapaq suq runa mana alli yach'aqta, suq kañata wayra waqman kayman kuyuchiqtashina? Manám. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Ichu rirqaykillapaqa chapaq suq ancha ch'aniyuq mudanayuq runata? Manám. Chaqa chay ancha shumaqta mudakuqkuna, chay bwina bida kawsaqkunaqam tiyanllapa gubyirnukunapa atun wasingunapi, ¿manachu? ");
INSERT INTO qvcNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Chayshinaqa ¿imata rikaqtaq rirqaykillapaqa? ¿Dyuspaq suq allip rimaqta? Arí, alliptam niykillapa, Dyuspaq ancha baliq rimaqtam rirqaykillapa rikaqqa. Kanan chay Jwanqam yumbay chay suq rimaqkunamanda mas baliq kashqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Chaqa chay Jwambaqmi Taytanchiq Dyusqa Santu Librumbi Akrashqan Washadurta kayshina niwarqan: Qamba ñawpaykitam noqapaq suq rimaqta rini kach'aq. Paymi ñanda allichanmanshina runakunata rin yach'achiq, shumaqta qamta ch'ayachishunanllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Chaymi allipta niykillapa, Dyuspaq yumbay rimaqkunamandam mana ni suq Jwanmandaqa mas baliqqa kashqachu. Piru noqa Taytaywan kamachikuptiy, noqapi yuyakuqmanda mas umildi kaqqam mas baliq rin kaq chay Jwanmandaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Chayshina Jisus Jwanda alabaptinqam, yumbay chay uyaqkuna asta chay kuntribusyun kubrakuqkunapis nirqanllapa: —Dyusqam ancha allin kashqa noqanchiqkunawanqa, nishpa. Chaqa yumbay paykunatam Jwanqa shutichishqa karqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Piru farisiyu duktrinayuqkuna, Muysispa liyningunata yach'achikuqkunaqam mana dijakashqachu karqan Jwan shutichinambaq. Ashwanmi Tayta Dyus paykunata munaptin washaytaqa, fyirusyashpa mana munarqanllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Chaymi Jisusqa nirqan: —¿Imawandaq kay tyimpumanda runakunataqa atini kumparayta? ¿Ima laya kustumbriyuqmi paykunaqa? ");
INSERT INTO qvcNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kay mana kriyiqkunataqam kumparani chay wambra mana nimatapis munaq pugllaqkunawan. Manchu wambrakunaqa plasapi pugllanllapa, fyistatashina rurashpa ichu suq almata pambaqshina tukushpa. Piru wakin wambrakuna mana munaptin pugllaytaqam, chay pugllaqkunaqa ninllapa: “¡Fyistapishina flawtata waqachiptiymi, mana dansangillapachu! ¡Pambakuqshina llakiy llakiyta kantaptiypismi, mana waqangillapachu!” nishpa. (Chayshinallam wakinnikikuna mana munangillapachu uyayta ni Jwan Shutichikuqta ni noqata). ");
INSERT INTO qvcNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Chaqa chay Jwan shamushpa, mana ni tandata ni allin mikunata mikuptin, mana ni binuta upyaptinqam, nirqaykillapa: “Waq Jwanqam dyabluwan kashpa, lukushina purin”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Chaymandaqam Dyusmanda Shamuq Runa kashpa mikuptiy, imitata upyaptiyqam, noqapaq ningillapa: “¡Jwi, mana undaqmi mikun, upyan! Chay uchayuqkunawan, kuntribusyunda kubrakuqkunawanmi tandakan”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Piru Dyus nishqanda kasuqkunaqam ancha yach'ayniyuqkuna. Chaymi shumaqta kawsaptinllapa, rikaqkunaqa intyindinllapa: Ancha yach'ayniyuqmi Dyusqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Suq farisiyu duktrinayuq runam Jisusta nirqan: —Aku wasiyman mikuq, nishpa. Chaymi Jisusqa wasinman rishpaqa, mesaman tiyarqan mikunambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Chay llaqtapim suq warmi ancha uchayuq karqan. Chay warmim yach'arqan chay farisiyupa wasimbi Jisus kashqanda. Chaymi ikinda ch'ayarqan mishki mutkinata suq rumi pumupi apashpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jisuspa ch'akinman qemikashpam, ancha waqarqan. Waqaqshinam ch'akingunata nuyuchirqan waqayninwan. Nuyuchishpaqam aqchanwan chakichishpa, muchashpa, chay mishki mutkinawan pasarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Chay farisiyu Jisusta apaqqam chay warmi chayta ruraykaqta rikashpaqa, yuyarqan: Atatayraq kay warmiqa. Mana allikunata rurashpam purirqan. Kay runa Dyuspaq allip rimaq kashpaqach'i, atinanda yach'ayta: Uchayuq warmim ch'akiymanda piskawaykan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Chayshina yuyaptinmi, Jisusqa nirqan: —Simun, munanim suq kusitata nishuyta. Chaymi farisiyuqa nirqan: —Niwayri, Yach'achikuq Taytitu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Chaymi Jisusqa nirqan: —Ishkay runam suq qellayniyuqta dibiraq. Suqmi 500 dinaryu qellayta dibirarqan; suqqam 50 dinaryu qellayta dibirarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Mana atiptinllapa pagaraytam, chay qellay dwiñuqa chay ishkandin dibiraqta pirdunarqan. Mayá, niway, chay dibiraqkunaqa, ¿mayqanninraq masta rin kuyaq chay qellay dwiñutaqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Chayshina niptinqam, Simunqa nirqan: —Noqam yuyani, chay runa mas achka dibirashqan pirdunashqanmi mastaqa rin kuyaq, nishpa. Chaymi Jisusqa nirqan: —Arí, chayshinam. Allitam yuyashqa kangi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Chaymandaqam chay warmita chapashpa, Simunda nirqan: —¿Intyindishqachu kangi kay warmi rurashqandaqa? Rikay, kay wasikiman yaykuptiyqam, mana qowarqaykichu yakuta, ch'akiykunata mayllanayqa. Piru kay warmiqam waqayninda ich'ashpa, ch'akiykunata aysashpa, aqchanwan chakichishqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Qamqam mana napaykuwashqachu kangi muchawashpa. Piru payqam ch'ayamushqay urasmandapacha mana shaykuq ch'akiykunata muchashqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Qamqam mana umaytaqa asiytiwanqa pasarqaykichu, shumaqta ch'ayachiwanaykiqa. Piru payqam ancha ch'aniyuq mishki mutkinawan ch'akiykunata liyashqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Chaymi allipta niyki, Taytanchiq Dyus kay warmita yumbay uchangunata pirdunaptinqam, kayshina ancha kuyawan. Piru Tayta Dyus suq runa ashla uchayuqta pirdunaptinqam, chay runaqa ashlitatalla kuyan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Chaymandaqam chay warmitaqa nirqan: —Uchaykimandam pirdunayki, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Chayshina niptinqam, Jisuswan mesapi kaqkunaqa, suqnin suqnin parlarqanllapa: —¿Imataq kashpa, kay yanqa runaqa uchangunata pirdunaykan? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Piru Jisusqam chay warmita nirqan: —Noqapi kriyishqaykiraykum, yumbay uchaykimanda pirdunaduna kangi. Kushikushpana riy, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Chaymandaqam Jisusqa dusi apustulningunawan rirqan achka llaqtakunata, achka kasiriyukunata, Dyuspa shumaq nutisyanda yach'achikuq, chay uyaqkuna Dyusta kasunambaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Wakin warmikunapismi Jisuspa pullan rirqan. Paykunataqam nanayningunamanda kach'akachishqa karqan. Wakinmandaqam dyablukunata qatishqa karqan. Chay warmikunamandaqam suqninqa Marya karqan. Payllam Madalinapis shutiq (Magdalamanda kashqanrayku). Paymandam Jisukristu syiti dyablukunata wichukushqa karqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Suq warmiqam Jwana shutiq. Payqam Chusapa warmin karqan. Chay Chusaqam prifiktu Irudispa wasimba kamachikuqnin karqan. Suq warmiqam Susana karqan. Wakin warmikunapismi Jisuspa pullan puriqllapa tukuy iman kaqwan yanapashpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Achka llaqtakunamanda achka runa, warmi shamuptin Jisusta rikaqmi, payqa kay kumparasyunwan paykunata yach'achirqan: ");
INSERT INTO qvcNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Suq tarpukuq runa simillanda shikwaptinmi, wakin simillaqa ñanman ishkirqan. Chay ñambi ishkiq simillatam pasaqkuna sarrurqanllapa; wakindaqam pishqokuna pallarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Wakin simillaqam kaskajuman ishkirqan. Chay simillaqam sawapilla kashpa, wayralla wiñarqan. Lukismi kaskaju kashqanrayku, mana atishpa ch'upakuyta, chakirqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Wakin simillaqam kashakunapa ukunman ishkirqan. Chaymi chay similla wiñaptinqa, kashakunapis pullan wiñashpa maqarqan. Chaymi limpu chingachirqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Piru wakin simillaqam ancha allin allpaman ishkirqan. Chay simillaqam shumaqta wiñashpa, allita puqorqan. Chaqa kada simillitam syin granusta puqorqan. Chayshina nishpaqam, Jisusqa ancha jwirtita nirqan: —¡Qamkuna rinriyuqkunaqar allita uyawayllapa kay nishushqayta! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Chay kumparasyunda nishqambaqmi yach'akuqninguna Jisusta tapurqan: —Niwayllapar, ¿imam munan niyta chay nishqaykiqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Chaymi Jisusqa nirqan: —Dyusmi munan noqapi kriyiqkuna allita intyindinaykillapa: Kayshinam ancha shumaqta rin kamachikuq, nishpa. Piru noqapi mana munaq kriyiqkunataqam achka kumparasyunwanlla yach'achini, maychika chapashpapis, ama rikananllapa, maychika uyashpapis, ama intyindinanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Chay kumparasyunqam kayshina munan niyta: Dyuspa shumaq nutisyanqam chay simillashina. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Wakin uyawaqkunam chay similla ñanman ishkiqshina. Ancha angu shunqoyuq kashpa, Dyuspa shumaq nutisyanda uyashpaqa, mana kriyinllapachu. Chaymi dyabluqa shamushpa, uyashqanda das qonqachin, ama kriyishpa washadu kananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Wakin uyawaqkunaqam chay ashla allpayuq kaskajushina. Chaymi Dyuspa shumaq nutisyanda uyaptinllapaqa, shunqombi mana allitaqa yurakanchu. Chaymi das kriyishpa, ashla tyimputalla ancha kushikushpa kawsanllapa. Chaymandaqam ashla padisishpaqa, das syintishpa, Dyusmanda akrakanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Wakin uyawaqkunaqam chay kashapa ukumbi tarpudu wiñaqkunashina. Paykunaqam Dyuspa shumaq nutisyanda uyashpa kriyin. Piru chaymandaqam tukuy imayuq munashpa kayta, kwirpun munashqambilla yuyashpaqa, Dyusta qonqanllapa, chay similla kashakunapa ukumbi chingaqshina. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Piru wakingunaqam chay allin allpashina. Chaqa ancha allin shunqoyuqkuna Dyus nishqanda uyaptinllapam, allita yurakan. Chaymi Dyustana mana shaykuq kuyashpa, kasushpa, shumaqtana kawsanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Suq michata syindishpaqam, mana pipis suq almunwanqa pambanchu ni kamamba waranman pakanchu. Ashwanmi altupi ruran, yaykuqkunata achikchanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Chayshinallam yumbay pakadu kaqqam suq diyaqa manana pakaduchu rin kaq. Ashwanmi achka runakuna chay mana yach'ashqangunata rinllapa yach'aq. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Allita uyawayllapa, chay allita yach'akuqtam Dyusqa masta rin yach'achiq. Piru chay mana allita uyakuqtaqam chay ashla yach'akushqandaqa limpu rin qonqachiq. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jisuspa masanguna mamambismi ch'ayamurqan chay kashqanman. Piru ancha unda runa kaptinmi, mana atirqanllapachu ch'ayayta Jisuspa ladunmanqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Chaymi Jisustaqa suq runa abisarqan: —Siñursitu, mamayki masaykikunam kay sawapi. Anchash munanllapa qamwan parlayta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Chaymi Jisusqa nirqan: —Taytay Dyus nishqanda uyaqkuna kasuqkunam noqapa mamay, masaykunaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Suq diyam Jisusqa yach'akuqningunawan yakupi puriq barkuman yaykushpa, paykunata nirqan: —Aku kay atun qoch'apa waq chimbanman, nishpa. Chayshina niptinqam, rirqanllapana. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Chaymi riykaptinllapaqa, Jisusqa puñurqanna. Kanan qonqaylla ancha jwirtita wayraptinmi, chay yakuqa ancha maqchikamushpa, undaykarqanna chay barkuman. Chaymi chay barkuqa yaqqana seqarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Seqaykaptinnaqam utqaymaya Jisusta rikch'achishpa nirqanllapa: —¡Ay, Taytitu, Taytitu! ¡Seqaykanchiqnam yakuman! nishpa. Chaymi Jisusqa atarishpa, chay wayrata, chay maqchikaykaq yakukunata jwirtita rimashpa, kamachishpa, limpu qasillachirqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Chaymandaqam chay yach'akuqningunata tapurqan: —¿Imapaqmi qamkunaqa mancharqaykillapa? ¿Ima manachu noqapi allita yuyakungillapa? nishpa. Chaymi paykunaqa ancha ispantashqata, suqnin suqnin parlarqanllapa: —¿Ima layaraq kay runaqa? ¡Rikay, kamachiptin kay wayrawan yakuqa das kasushpa, qasillarqan! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Chay qoch'apa waq chimbanman rishpaqam, Gadarapa manyanman ch'ayarqanllapa. Gadaraqam Galiliyapa chimba shutimbi kidan. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Chay yakupi puriq barkumanda qoch'apa manyambi ishkiptinllapaqam, suq luku gadarinu runa Jisusman ch'ayarqan. Chay runapa kwirpumbim achka tyimpuna dyablukunapa ispiritunguna tiyashqa karqan. Chaymi luku kashpa, sipralla puriq. Kanan pantyungunapim tiyaq. Wasimbiqam manana tiyarqanchu. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Chay runaqam Jisusta chapashpa, qayach'akushpa, ñawpambi qonqorikushpa nirqan: —¿Imapaqmi mitikungi noqamanqa, qam ancha pudirniyuq Dyuspa Churinqa? Rrugaykim, yush'ayku, amar qesachawaychu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Chaqa Jisusqam chay runamanda qatiykarqan chay dyabluta. Chaymi chayshina chay dyabluqa rrugarqan. Chay dyabluqam achka tyimpuna chay runataqa dwiñukushqa karqan. Chaymi runakunaqa chay runata sujitananllapa yuyashpa, makingunamanda, ch'akingunamanda kadinakunawan alli alli watashqallapa karqan. Piru chay lukuqam chay kadinataqa mana kwintashpachu, pitishpa, chuncha lugarkunaman rirqan, dyablu apaptin. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jisusmi tapurqan: —¿Imam shutingi? nishpa. Payqam nirqan: —Manadam shutinillapa, nishpa. Chayshinaqam nirqan, ancha achka dyablukunapa ispiritunguna chay runapa kwirpunman yaykushqa kaptin. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Chay dyablukunaqam Jisusta ancha rrugarqanllapa, ama chay manchaypaq talalanman kach'anambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Anaq ladun qaqapim ancha achka kuchikuna mikuykarqan. Chaymi chay dyablukunaqa Jisusta rrugarqanllapa, chay kuchikunaman yaykunambaq. Chaymi Jisusqa nirqan: —Mayá, riyllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Chayshina niptinqam, chay dyablukunaqa runamanda lluqshishpa, chay kuchikunamanna yaykurqanllapa. Chaymi yumbay chay kuchikunaqa, lukuyashpa, qayach'akushpa, qaqamanda kallpashpa, qoch'aman seqarqan. Chaymi ch'uqashpa yumbayna wañurqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kanan chay michiqkunaqam chayta rikashpaqa, ancha manchashpa, kallpaylla rirqanllapa abisaq ch'akrangunapi kaqkunata, llaqtambi kaqkunata: —Kay kusasmi pasawashqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Chaymi ancha achka runakuna rirqanllapa, chay pasashqanda rikaq. Kanan Jisus kashqanman ch'ayashpaqam, chay lukutaqa kach'akashqatana tarirqanllapa, Jisuspa ch'akin kaqpi tiyaykaptin. Chay runaqam jwisyumbina kashpa, mudanandapis allitana rurakushqa karqan. Chayta rikashpaqam, ancha mancharqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Kanan chay rikaqkunaqam chay shamuq runakunata manyaqlla parlachirqanllapa: —Rikashqallapam kani chay lukuta Jisus kayshina kach'akachiptin, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Chaymi chay gadarinukunaqa ashwamba mancharqanllapa. Chayraykum yumbaynin Jisusta rrugarqanllapa, chay Gadaramanda lluqshinan. Chaymi Jisusqa barkuman yaykushpa, chay Gadaramandaqa rirqanna. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Kanan chay runa kach'akaqqam Jisusta ancha rrugarqan pullan apanambaq. Piru Jisusqam kamachishpa kidanambaq, dispidikashpa nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Wasikiman kutirishpa, Tayta Dyus tukuy ima ancha yanapashushqanda aylluykikunata willay, nishpa. Chaymi chay runaqa llaqtanman kutirishpa, yumbayta parlachirqan: —Jisusmi kayshina ancha yanapawashqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jisus kutimuptin chay qoch'apa suq ladu chimbanmanqam, ancha achka runa, warmi chaypi payta shuyaykarqanllapa. Chaymi shamuptinqa, ancha kushikushpa, shumaqta ch'ayachirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Chaymambismi suq runa Jayru shutiq ch'ayarqan. Payqam suq sinaguga wasipa kamachikuqnin karqan. Chay Jayrum Jisuspa ñawpambi qonqorikushpa, kayshina ancha rrugarqan: —Taytitu, yush'aykur aku wasiyman, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Chaqa payqam suq chinayuqlla karqan. Piru chay chinanqam dusi watayuq kashpach'i, wañuykarqanna. Chaymi Jisusqa Jayruwanna riptinqa, ancha achka runa, warmi ikinda kish'kichaypa rirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Chay runakunapa ukumbiqam suq qeshyaq warmi riykarqan. Chay warmitaqam yawarqa dusi wata tukuyta mana dijarqanchu. Chaymi ancha qeshyaqlla puriq. Kanan ambikuqkunata pagarashpam, tukuy ima kaqninda limpuna ushyashqa karqan. Piru manam ni mayqan ambikuq atirqanchu kach'akachiytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Chaymi chay warmiqa ikin laduta qemikashpa, Jisuspa kapamba manyanda makinda ruraptinlla, yawarqa das dijarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Chaymi Jisusqa tapurqan: —¿Pitaq kapayta llamkashqa? nishpa. Yumbay ikinda riqkunaqam nirqanllapa: —Manam, manam, nishpa. Chayshina niptinllapaqam, Pidruqa ˻wakin yach'akuq masingunawan˼ nirqan: —Yach'achikuq Taytitu, kay tukuy runam kish'kichashuykangi. Tukuy ladumandam kumsashungi. Chaypaqqa ¿imaraykutaq tapukungi: “¿Pitaq kapayta llamkashqa?” nishpaqa? ");
INSERT INTO qvcNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Piru Jisusqam nirirqan: —Suqnikim kapayta llamkarqayki. Chaqa pudirniy kach'akachishqandam syintishqa kani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Chaymi warmiqa yuyashpa: Mananam atinichu pakakuyta, nishpa, ancha manchaywan ch'apsikashpa, Jisuspa ñawpanman rishpa, qonqorikushpa, yumbaypa ñawpambi Jisusta nirqan: —Taytitu, noqam qeshyaq kashpa, kapitaykipa manyanda llamkashqa kani. Chaymi diki llamkashpalla kach'akarqay, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Chaymi Jisusqa nirqan: —Ijita, noqapi yuyakushqaykiraykum kach'akashqana kangi. Chayri kananqa kushikushpana riy, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Chayshina Jisus rimaykaptinmi, chay sinaguga wasipa kamachikuqnin Jayrupa wasinmanda suq runa ch'ayamushpa nirqan: —Chinaykiqam wañushqana. Amana Yach'achikuqtaqa piñachiychu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Chayshina chay runa niptimbismi, Jisusqa Jayruta nirqan: —Ama manchaychu. Allita noqapi yuyakuy. Chinaykiqam rin kawsamuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Chaymandaqam wasinman ch'ayashpaqa, Jisusqa yumbayta nirqan: —Ama yaykuyllapachu, nishpa. Chaymandaqam Pidruwan, Jakubuwan, Jwanwan, almapa taytanwan mamanwanlla Jisusqa yaykurqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Uku wasipiqam dwilupi kaqkunaqa almitapaq yupakuykarqanllapa. Piru Jisusqam chay yupakuqkunata nirqan: —Ama waqayllapachu. Chinaqam mana wañushqachu. Puñuykanllám, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Chaymi yumbay paykuna yach'ashpa: Chinaqam allipta wañushqana, nishpa, Jisustaqa asiparqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Piru Jisusqam almitata makinmanda piskashpa, jwirtita nirqan: —¡Chinita, atariy! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Chayshina qayaptinllam, chay chinaqa das kawsamushpa, atarimurqanna. Chaymi Jisusqa kamachirqan, qaranambaqllapa chay chinata. ");
INSERT INTO qvcNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kanan chay taytanwan mamanqam ispantashqata ancha kushikurqanllapa. Piru Jisusqam paykunata kamachirqan, chay rurashqambaq ama pitapis parlachinanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisusmi tandashpa chay dusi akrashqan yach'akuqninda, pudirninda qorqan, runakunamanda atinanllapa dyablukunata qatiyta, qeshyaqkunata atinanllapa kach'akachiyta. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kanan paykunatam kach'arqan, rinanllapa Dyuspaq yach'achiq runakunata, warmikunata: “Dyusmi munan shumaqta payta kasunanchiqllapa”, nishpa. Kach'arqambismi, kach'akachinanllapa qeshyaqkunata. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Chaymandaqam nirqan: —Chayshinallar riyllapa. Amar apayllapachu burdunda, alfurjata, fiyambrita, ni qellayta. Mudanaykitaqa suqtalla kadunu apayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Mayqan wasiman ch'ayashpaqa, chaypilla kidayllapa, chay lugarmanda rinaykikaman. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mayqan llaqtapi mana munaptinllapa ch'ayachishuytaqa, lluqshishpa, ch'akikikunata ch'apsiy pulbu ishkinan, yach'ananllapa: Chay apustulkunaqam manana kwintayuqchu noqanchiqkunawanqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Chaymi apustulningunaqa kasiriyukunaman rishpa, tukuy maypi Dyuspa shumaq nutisyanda yach'achikushpa, qeshyaqkunata kach'akachirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Gubyirnu Irudismi tukuy ima Jisus rurashqambaq yach'arqan. Lukismi runakuna suqpaq suqpaq rimaptinllapa, Irudisqa ancha yuyashpa tapurqan: “¿Chayshinaqa pitaq chay runaqa?” nishpa. Chaqa Jisuspaqqam wakinqa niq: “Alma Jwan Shutichikuqmi wañushqanmanda kawsamushpa, Jisusna shutin”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Wakinqam nirqan: “Dyuspaq rimaq Eliyasmi rikakumushqa”, nishpa. Wakinqam nirqan: “Dyuspaq unay rimaqkunamandam suqnin kawsamushqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Chaymi chay Irudisqa ancha yuyashpa nirqan: —Piru Jwan Shutichikuqpa umandaqam noqa kikiy pitichirqay. ¿Chayshinaqa pipa famandaraqri ancha parlanllapa: “Kaykunatam rurashqa”, nishpaqa? Chaymi Irudisqa Jisusta ancha munarqan riqsiyta. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Chaymandaqam chay dusi apustulninguna kutimushpaqa, yumbay rurashqanllapata Jisusta parlachirqanllapa. Chaymi Jisusqa suqkunamanda akrakashpa, paykunata apashpa, rirqan Bitsayda llaqtapa sawa chuncha lugarmanna. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Piru runakunaqam yach'ashpa: Jisusqash waq llaqta Bitsaydapa sawa chunchambi, nishpaqa, ikinda rirqanllapa. Chaymi chay runakuna ch'ayaptin, Jisusqa paykunata shumaqta ch'ayachishpa, yach'achirqan imashinam Tayta Dyus shumaqta rin kamachiq yumbay payta kasuqkunata. Kanan qeshyaqkunatapismi chaypiqa kach'akachirqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Chaymandaqam tardiyaptinqa, chay dusi apustulkunaqa Jisusta nirqanllapa: —Dispidiyna kay achka runata, warmita, kay sirka lugarkunaman rinanllapa, pusadanda, mikunanda maskaq. Chaqa kay chunchapiqam mana pipis tiyanchu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Chaymi Jisusqa paykunata nirqan: —Qamkuna qarayllapa, nishpa. Chaymi paykunaqa nirqan: —¿Imatanamir qarashaqllapaqa? Sinku tandita, ishkay piskaditullam kan. Yumbay kay uyashuqkunata qaranayllapaqam munan rinayllapa karuman, ancha achka mikunata randimuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Chaqa ullqokunallach'i karqan 5.000qa. Piru Jisusqam yach'akuqningunata kamachirqan: —Yumbayta tiyachiyllapa 50, 50 waqpi kaypi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Chay nishqanshinam yumbayta tiyachirqanllapa pachan pachan. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Chaymi Jisusqa chay sinku tanditata chay ishkay piskadituta piskashpa, syiluman chapakushpa, Dyusta pagikurqan. Chaymandaqam pitishpa, yach'akuqningunata qorqan, paykunana aypachinambaq yumbay runakunata, warmikunata, wambrakunata. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Chayshinam yumbay mikurqanllapa undanangaman. Undaptinllapaqam chay tandawan pijisituqa dusi kanastas unda subrarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Suq diyam Jisus suq chuncha lugarpi Dyusman mañakuykarqan. Chaypi yach'akuqninguna paypa pullan kaykaptinmi, Jisusqa kayshina tapurqan: —Mayá, runakunaqa ¿imatam nin noqapaqqa? ¿Pish kani paykunapaqqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Chaymi paykunaqa nirqan: —Wakinmi nin, Jwan Shutichikuqshi kangi. Wakinqam nin, Dyuspaq unay rimaq Eliyasshi kangi. Wakingunaqam nin, Dyuspaq unay rimaqkunamanda suqnin kawsamuqshi kangi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Chayshina niptinllapaqam, paykunata tapurqan: —Mayá, qamkunaqa ¿imatataq ningi? ¿Pitaq kani qamkunapaqqa? nishpa. Chaymi Pidruqa nirqan: —¡Qamqam Dyus Akrashqan Washadurniyllapa kangi! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Piru Jisusqam chay yach'akuqningunata ancha kunarqan, chay nishqanllapata ama pitapis ninambaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kayshinapismi nirqan: —Dyus nishqanda kumplinaypaqmi noqa Dyusmanda Shamuq Runaqa ancha rini ñakaq. Chaqa chay kamachikuq ansyanukuna, chay kamachikuq isrraylinu kurakuna, Muysispa liyningunata chay yach'achikuqkunam mana baliqpaq riqsiwashpa, rinllapa wanchiwaq. Piru chayshina wanchiwaptimbismi, kimsa diyamanda rini kawsamuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Chayshina nishpaqam, yumbayta nirqan: —Mayqan runa noqapa yach'akuqniy munashpa kaytaqa, tukuy ima pay munashqanda dijanqa. Chaymandaqa tukuy diya noqatalla kasuwashpa kawsanqa, awnki suq kruspi munaptinllapa wanchiytapis. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Chaqa mayqanniki noqata ñigawashpa, bidaykita washanaykiqam, ringi chingaq tukuy tyimpupaq. Piru noqapi kriyishqaykirayku mayqan wanchishuptinqam, noqa rini washashuq, tukuy tyimpu noqawan kawsanayki. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mayá, suq runa ichu suq warmi tukuy kay munduta ganashpa, piru jwisyu diyapi chingashpaqa, ¿imatam ganashqa? Manam nimatapis ganashqachu. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Chaymi mayqan runa noqapaq ichu yach'achikushqaypaq penqakushpaqa, kayta yach'anqa: Dyusmanda Shamuq Runa Jisukristum syilumanda rin kutimuq suq ancha kamachikuq gubyirnushina, Tayta Dyuspa llipyayninwan llipyashpa, paypa santu anjilningunawan. Chay diyaqam paypis noqapaqqa rin penqakuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Piru alliptam niykillapa, wakin kaypi kaqkunaqam mana rinllapachu wañuq, Dyus kamachikuqta rikanangaman, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Uchu diyas pasaptinch'i, Jisusqa Pidruta, Jakubuta, Jwanda apashpa, rirqan suq atun lumapa sawanman, Dyusman mañakuq. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Chaypi Jisus Tayta Dyusman mañakuykaptinmi, qaqllanqa limpu suq layayarqan. Mudanambismi ancha yuraqpaq tikrakashpa, ancha llipyarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Chaymandaqam ishkay runa chaypi rikakushpa, paywan parlarqanllapa. Suqmi Muysis, suqqam Eliyas karqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Yumbay rridurninllapapi ancha llipyarqan. Kanan paykunaqam Jisuswan parlaqllapa: —Jirusalimbi wañuptikim, Dyus nishqanshina rin kumpliq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Kanan Pidruqam ishkay kumpañirunwan ancha puñunaykarqan. Piru puñuymanda agwantashpa, chapakuykashpam, rikarqanllapa Jisusta chay ishkay runawan rupayshina achikchakuqta. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Chaymanda Muysis, Eliyas Jisusmanda ashuykaptinqam, Pidruqa Jisusta nirqan: —¡Yach'achikuq Taytitu, ancha shumaqraq kaypi kashqanchiqqa! Rurashaqllapa kimsa chugllakunata, suqta qambaq, suqta Muysispaq, suqta Eliyaspaq, nishpa. Piru Pidruqam ancha ispantashpa, mana yach'arqanchu: Imatam rimaykani, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Chayshina Pidru rimaykaptinllam, pukutay shamushpa, paykunataqa limpu pambarqan. Chaymi ancha mancharqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kanan chay urasmi anaq pukutaymanda Taytanchiq Dyusqa Jisukristupaq nirqan: —Kaymi kuyashqay Churiyqa. Payta uyayllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Chaymandaqam paykuna chapakushpaqa, sapalandallana Jisustaqa rikarqanllapa. Kanan paykunaqam chay diyakunaqa mana ni pitapis chay rikashqambaqqa parlachirqanchu. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Qayandin chay lumamanda shamuptinllapam, achka runakuna rirqanllapa Jisusta tinguq. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kanan chay runakunapa ch'awpinmanda suqninqam ancha jwirtita Jisusta nirqan: —¡Yach'achikuq Taytitu, yush'aykur kay sapalan churiyta yanapay! ");
INSERT INTO qvcNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Chaqa dyablum atakikunata qoshpa, qayach'achin. Kanan ancha qesachashpam, babash'kunata sitakuchishpa, mana munanchu dijayta. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Chaymi yach'akuqnikikunata rrugarqani, kay wambraymanda dyabluta qatinanllapa. Piru manam atirqanllapachu qatiytaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Chaymi Jisusqa nirqan: —¡Ayayay, qamkuna mana yuyakuqkuna, mana allita ruraqkunaqa! ¿Ima tyimpukamanraq qamkunataqa agwantashqayki? Chaymandaqam chay chulupa taytanda nirqan: —Mayá, chay wambraykita kayman apamuy, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Chaymi chay chuluqa Jisusman qemikaptin, chay dyabluqa ancha fiyu atakikunata qoshpa, ch'apsi ch'apsi pambaman bularqan. Piru Jisusqam chay dyabluta anyashpa, qatirqan chay chulumanda. Chaymandaqam chay chulutaqa intrigarqanna taytanda. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Chay runakunaqam ancha ispantashqata chapashpa, yuyarqanllapa: Ancha pudirniyuqmi Tayta Dyusqa, nishpa. Chay rurashqambaq yumbay ispantaptinmi, Jisusqa yach'akuqningunata nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Kay nishushqayta allita uyawashpa, ama qonqayllapachu. Noqa Dyusmanda Shamuq Runatam rinllapa intrigakuwaq ch'iqniwaq runakunapa makinman, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Piru yach'akuqningunaqam chay nishqandaqa mana atirqanllapachu intyindiyta, yuyayninllapa pambadushina kaptin. Kanan intyindinanllapa munashpa tapuytapismi, manchashpa, mana tapurqanllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Chaymandaqam chay yach'akuqningunaqa paykunapura suqnin suqnin anyanakurqan: —Noqam mas kamachikuqqa kani, nishpa. Suqqam niriq: —Manam qamchu; noqam mas kamachikuqqa kani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Chayshina anyanakuptinmi, Jisusqa paykuna yuyashqanda yach'arqan. Chaymi suq wambrituta apamushpa ladunman, ");
INSERT INTO qvcNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","paykunata nirqan: —Mayqan runa kasuwashpa, kay wambrituta ch'ayachiqqam alabis noqata ch'ayachiwaykanmanshina. Chay ch'ayachiwaqqam kach'amuwaqtapis ch'ayachiykan. Chaqa mayqanniki kay takshitashina umildi kaqmi mas kamachikuqqa ringi kaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Chaymandaqam yach'akuqnin Jwanqa Jisusta nirqan: —Yach'achikuq Taytitu, rikashqallapam kani suq runata qamba shutikita myintashpa, dyablukunata runakunamanda qatiykaqta. Piru chay runaqam mana noqanchiqwanqa purishqachu. Chaymi nirqayllapa, ama chayshina ruranambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Chaymi Jisusqa payta nirqan: —Ama chayshinaqa niyllapachu. Chay mana kuntranchiqmi noqanchiqpa faburninchiqqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Syiluman kutinambaq tyimpu ch'ayaykaptinqam, Jisusqa suq balurta piskarqan, Jirusalinman rinambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kanan ñanda riykashpam, wakin yach'akuqninda ñawpanda kach'arqan, pusadata maskanambaq. Chaymi paykuna ñawpashpaqa, prubinsya Samaryapa suq kasiriyunman ch'ayarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Piru chay Samaryamanda kaqkunaqam yach'arqanllapa: Jisusmi Jirusalinman riykan, nishpa. Chaymi mana munarqanllapachu pusadata qoytaqa. Nuta: Chay prubinsya Samaryamanda kaqkunam munarqanllapa yumbay runakuna Samaryapilla Dyusta adurananllapa; ama Jirusalimbiqa.  ");
INSERT INTO qvcNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Chayta rikashpaqam, chay apustulnin Jakubuwan Jwanqa nirqanllapa: —Kamachikuq Taytitu, ¿munangichu ˻Dyuspaq rimaq Eliyasshina˼ kamachikunayllapa, syilumanda ninakuna ishkishpa ushyanambaq chay kasiriyupi tiyaqkunata? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Chaymi Jisusqa tikrakashpa, paykunata anyarqan: ˻—Qamkunaqam mana yach'angichu ima laya malu ispiritum chay layataqa yuyachishungi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Chaqa noqaqam mana shamushqachu kani, runakunata wanchinaypaq. Ashwanmi shamushqaqa kani, paykunata washanaypaq, nishpa.˼ Chaymandaqam suq kasiriyumanna rirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Riykaptinllapaqam ñambi suq runa Jisusta nirqan: —Taytitu, munanim riyta may rishqaykita, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Chaymi Jisusqa nirqan: —Surrukunaqam mach'ayniyuq. Pishqokunapismi kamachayuqkuna. Piru noqa Dyusmanda Shamuq Runa kashpapismi, mana atinichu maypi umayta isqandashpa samachiyta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Chaymandaqam Jisusqa suq runata nirqan: —Shamuy, aku noqawan, nishpa. Piru chay runaqam nirqan: —Taytitu, dijawayraqri rinaypaq taytayta pambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Chayshina niptinqam, Jisusqa nirqan: —(Noqapi mana kriyiqkunaqam wañushqakunashina.) Chay mana kriyiqkunata dijay, chay mana kriyiq wañushqakunata pambananllapa. Piru qamqa shamuy noqawan, runakunata yach'achinanchiq: Dyusmi yumbay runata, warmita shumaqta rin kamachiq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Chaymandaqam suq runapis Jisusta nirqan: —Taytitu, noqapismi munani riyta qamwan. Piru dijawayri puntata aylluykunamanda dispidikanaypaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Piru Jisusqam chay runataqa nirqan: —Suq runa yapukuq aradunda piskashpaqam, mana ikimanqa chapakunchu. Chayshinallam noqata munaq kasuwaqqa ikiman kutishpaqa, mana balinmanchu, Dyusta sirbinanqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Jisusqam munarqan riyta achka lugarkunaman. Chaymi yach'akuqningunamanda 70ta akrashpa, puntata kach'arqan, ishkay ishkayta, chay yumbay llaqtakunaman, kasiriyukunaman rinanllapa. Nuta: Wakin unay biblyakunapim nin: “72 yach'akuqningunatam kach'arqan”, nishpa.  ");
INSERT INTO qvcNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Chaymi paykunata nirqan: —Alliptam niykillapa, kusichaqam ancha achka kan. Piru kusichakuqkunaqam ashlitalla. Chayrayku qamkunaqa kusichapa dwiñunman mañakuyllapa, mas trabajadurkunata kach'anambaq, kusichata tandananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Chaymi qamkunata uñakunatashina kach'aykillapa, rinaykillapa ancha atun surru layakunapa ukunda. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","(Piru Dyusmi rin kwidashuqllapa.) Chayri ama apayllapachu alfurjaykita ni qellaynikita ni llanqekita. Ñanda riqshinapis ama arkakayllapachu mayqanda parlachishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kanan ch'ayashpa suq wasimanqa, puntata napaykushpa kayshina niyllapa: “Tayta Dyusri kay wasipi tiyaqkunata yanapashunqa, shumaqta kawsanaykillapa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Chayshina niptikillapam, Dyusqa rin yanapaq chay shumaq uyashuqkunata. Piru mana munaptinllapa uyashuytaqam, Dyusqa mana rinchu yanapaq paykunataqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mayqan wasiman ch'ayachishuptinqa, chaypilla kidashpa, paykuna ima qoshushqanda mikuyllapa, upyayllapa. Amar wasin wasinqa puriyllapachu. Chaqa trabajaqqam dirichuyuq mantinsyunninda ch'askinambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Chayri suq llaqtaman ch'ayashpa, chay may ch'ayachishushqambi ima qoshushqanda mikuyllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Chay llaqtapi qeshyaqkunata kach'akachishpa, niyllapa: “Dyusqam ch'ayamuykanna qamkunaman, shumaqta kamachikunambaq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Piru chay mayqan llaqtapi mana pipis ch'ayachishuptinqa, sawa kallingunaman lluqshishpa, paykunata niyllapa: ");
INSERT INTO qvcNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Kay llaqtaykipa allpan ch'akiyllapapi pigakashqandam ch'apsinillapa, amana nima kwintayuqchu kanayllapa qamkunawanqa, nishpa. Chaqa yach'ayllapa, Dyusmi munashqa qamkunaman ch'ayayta, payta kasushpa, shumaqta kawsanaykillapa. (Piru qamkunaqam mana munarqaykillapachu)” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Chaymandaqam Jisusqa nirqan: —Allita uyawayllapa, chay mana ch'ayachishuqkunaqam jwisyu diyapiqa mas kastigadu rinllapa kaq chay rupashqa Sudumapi tiyaqkunamandaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡Ay, imanangillaparaqri qamkuna Kurasin llaqtapi tiyaqkuna, qamkuna Bitsayda llaqtapi tiyaqkunaqa! Chaqa ñawpaykillapapi achka milagrukunata ruraptiypismi, mana munangillapachu noqapi kriyiytaqa. Qamkunaqam uchaykikunata mana munangillapachu dijayta. Piru qamkunapi rurashqay milagrukunata waq Tiru llaqtapi, waq Sidun llaqtapi ruraptiyqach'i, paykunaqa unayna uchangunata dijanandallapa. Chaqa paykuna mana allikunata rurashqanrayku syintishpach'i, waqashpa, lutu mudanakunata rurakushpa, ush'pata sawanman basyanandallapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kaytapis yach'ayllapa, qamkuna Kurasin llaqtapi tiyaqkuna, Bitsayda llaqtapi tiyaqkunaqam, jwisyu diyapiqa mas kastigadu ringillapa kaq chay Tirupi, Sidumbi tiyaqkunamandaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Mayá, ¿qamkuna Kapirnawun llaqtapi tiyaqkunaqachu yuyangillapa: Anaq syilumanmi rini riq, nishpa? ¡Manám! Ashwanmi Tayta Dyus rin wichukushuqllapa wañushqakunapa lugarninman. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Chaymandaqam Jisusqa yach'akuqningunata nirqan: —Qamkunata uyashuqkunaqam noqatapis uyawaykanllapa. Ch'iqnishuqkunaqam noqatapis ch'iqniwaykanllapa. Chay mayqan ch'iqniwaqqam Taytay Dyustapis ch'iqniykan. Chaqa paymi kach'amuwashqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Jisuspa chay 70 kach'adungunam ancha kushikushpa kutimurqanllapa. Chaymandaqam Jisusta nirqanllapa: —Taytitu, qamba shutikita myintashpa dyablukunata qatiptiyllapam, kasuwashpa runakunamanda lluqshirqanllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Chayshina niptinllapam, Jisusqa paykunata nirqan: —Arí, rikashqam kani chay dyabluta anaq syilumanda rrilampagushina ishkimuqta. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Chaymi noqaqa kamachikuqkunata rurashushqallapa kani, kulibrakunapa, atallkikunapa (alakran kurukunapa) sawambi sarrukunaykillapa, dyablutapis binsinaykillapa, ama nimapi dañachishunanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Piru ama kushikuyllapachu dyablukunata qatiptikillapa. Ashwan kushikuyllapaqa shutikillapata anaq syilupi iskibrishqambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Chayshina Jisus niykaptinqam, Dyuspa Santu Ispiritun paytaqa ancha kushichirqan. Chaymi Tayta Dyusta nirqan: —Taytitu, anaq syilupa, kay pachapa kamachikuqnin kashpam, waq yach'ayniyuq runakunamanda, waq intyindiqkunamanda pakashqaykita shumaqta yach'achishqa kangi umildikunata. Chaymi ancha alabayki, Taytitu. Chaqa chayshina kanambaqmi qam munashqa kangi. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Taytay Dyusmi yanapawashqa, tukuy imapaq yach'anaypaq. Piru manam pipis yach'anchu Dyuspa Churin kashqaytaqa. Taytay Dyusllam yach'an paypa Churin kashqaytaqa. Chayshinallam mana pipis yach'anchu: Pim Tayta Dyusqa, nishpaqa. Noqa kikiy Churinllam paytaqa riqsini. Kanan yach'achishqay runakunallam Taytay Dyustaqa rinllapa riqsiq shunqombi. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Chayshina nishpaqam, Jisusqa yach'akuqningunaman tikrakashpa, paykunatalla nirqan: —Kushikunqallapa qamkunashina rikawaqkunaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ancha klarutam niykillapa, Dyuspaq achka rimaqkuna, achka gubyirnukunam ancha munarqanllapa rikawayta, uyawayta, qamkuna kanan kay rikawashqaykishina, uyawashqaykishina. Lukismi (wañushqana kashpa) mana atirqanllapachu rikawayta ni uyawayta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Muysispa liyningunata suq yach'achikuqmi Jisusta mallipananrayku atarishpa, kayshina tapurqan: —Yach'achikuq Taytitu, ¿imatam atini rurayta, Dyuswan tukuy tyimpu kawsanaypaqqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Chaymi Jisusqa nirqan: —Muysispa liyningunaqa ¿imatam nin? Liyishpaqa, ¿imatam intyindingi? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Chaymi chay yach'achikuqqa nirqan: —Chay liykunaqam nin: “Tayta Dyusta kuyayllapa tukuy shunqoykiwan, tukuy bidaykiwan, tukuy jwirsaykiwan, tukuy yuyaynikiwan. Runa masikitapis kuyay, kwirpuykita kuyashqaykishina”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Chaymi Jisusqa nirqan: —Allitam nishqa kangi. Chay rimashqaykita rurashpaqam, Dyuswanna tukuy tyimpu ringi kawsaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Piru chay yach'achikuqqam ama atipadu kanambaq, yanqana tapurqan: —¿Piru pitaq runa masiyqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Chaymi Jisusqa nirqan: —Suq isrraylinu runam Jirusalinmanda ura Jiriku llaqtaman riykarqan. Chayshina riykaptinmi, ladrunguna ñambi tingushpa, ancha maqashpa, yaqqa wanchishpa, tukuy imanda limpu qoch'irqanllapa. Kanan mudanandapismi llushtichishpa, aparqanllapa. Kanan chay runataqam wañushqatashina ñambi dijashpana, rirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Chaymandaqam suq isrraylinu kura chay ñanda pasaykarqan. Payqam chay runata rikashpaqa, ladiyashpa, karu kaqta pasarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Chaymandaqam isrraylinu kurakunapa suq yanapakuqnin libita runa chay chuqridu runa kashqanman seqamurqan. Chay libita runapismi rikashpaqa, ladiyashpa, karu kaqtalla pasarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Piru suq runa Samaryamanda kaqmi chay ñanda riqshina chay runata rikashpaqa, ancha llakiparqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Chaymi paypa ladunman qemikashpa, asiytiwan, binuwan ambishpa, trapitukunawan chuqringunata pambarqan. Chaymandaqam burrumbina aparqan suq pusadaman. Chaypiqam chay diyaqa payna kwidarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Qayandinqam rinambaqna kashpaqa, chay pusada dwiñuta ishkay dinaryu qellayta qoshpa nirqan: “Yush'ayku kay runitata kwiday. Payta yanapashpa masta gastaptikiqam, kutimushpa pagarashqayki”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Chayshina nishpaqam, Jisusqa tapurqan: —Mayá, niway, chay chuqridu runapaq, chay kimsa runamandaqa ¿mayqanninmi mas allin runa masinqa kashqa, (chay furastiru samaryanu ichu chay isrraylinu kura ichu kurakunapa chay yanapakuqnin libita)? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Muysispa liyningunata chay yach'achikuqqam nirqan: —Chay llakipaqmi mas allin runa masinqa karqan, nishpa. Chaymi Jisusqa kamachirqan: —Qambis rishpa, chayshinalla yanapakuy, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jisusmi chay kaykashqanmanda rishpaqa, suq kasiriyuman ch'ayarqan. Chaypim suq warmi Marta shutiq tiyarqan. Paymi Jisusta wasinman ch'ayachirqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martapaqam suq masan (panin) Marya shutiq. Chay Maryaqam Jisuspa ñawpambi tiyarqan, payta uyanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Piru Martaqam tukuy ima ruranayuq karqan. Chaymi payqa qemikashpa, Jisusta nirqan: —Taytitu, ¿manachu llakipawangi? Maryam dijawashqa yumbay trabajukunawan, sapalaylla ruranaypaq. Kamachiyri yush'ayku, yanapawanambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Piru Jisusqam nirqan: —Marta, Marta, qamqam chay ruranaykipaqlla ancha llakiwan kangi ruranaykipaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Suq ruranallam tukuy imamanda mas allinqa. Chay ruranataqam Maryaqa ancha allita akrashqa. Chaymi mana ni pipis atinqachu laduymanda ashuchiytaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Suq diyam suq lugarpi Jisusqa Tayta Dyusman mañakurqan. Chaymandaqam suq yach'akuqninqa nirqan: —Jwan Shutichikuqmi yach'akuqningunata yach'achirqan, Dyusman mañakunanllapa. Chayri qambis yach'achiwayllapa, Dyusman mañakunayllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Chaymi Jisusqa nirqan: —Kayshina Dyusman mañakuyllapa: Taytanchiq Dyusitu ˻syilupi kaq˼, qamllam ancha santu, mana nima uchayuqchu kangi. Chaymi ancha balin, yumbay runa warmi qamtalla adurashunanllapa. Shamuyri, qamna yumbayta shumaqta kamachinayki. Qam munashqaykitar yumbay runa, warmi kay pachapi ruranqallapa, anaq syilupi ruraqkunashina. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Taytitu, tukuy diyapaqri mikunitayta qowayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mana allita rurashqaytapisri pirdunawayllapa, noqaykuna waq mana alli rurawaqkunata pirdunashqayshina. Dyablu munaptin tyintawaytapisri, ama dijaychu uchata rurachiwananqa. Ashwanri tukuy chay mana allikunamanda washawayllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jisusqam paykunataqa nirqambis: —Mayá, mayqanniki suq kumpañiruyuq kashpa, ch'awpi tutata ringiman pungunmanda qayaq: “Kuyashqay kumpañiritu, pristawayri kimsa tanditata. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Suq bisitaymi karumanda kanalitan wasiyman ch'ayamushqa. Chaymi mana nimay kanchu qaranaypaq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Chayshina niptikiqam, chay kumpañiruyki ukumanda nishungiman: “¡Ama piñachiwaychu! Punguyqam alli kirpashqana. Puñuykaninam. Wambraykunapismi pullay puñuykanna. Manam nimatapis atinichu qoshuyta”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Chaymi niykillapa, awnki kumpañiruyki mana munaptin nimata qoshuyta, piru mana shaykuq mañaptikiqam, atarishpa yumbay munashqaykita qoshungiman, ama masta piñachinayki. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Chaymi niykillapa, Dyusman (mana shaykuq) mañakuy. Chayshina mañakuptikiqam, Dyusqa rin qoshuqllapa. Allita imatapis maskashpaqam, ringillapa tariq. Dyuspa pungumbishina qayakuptikiqam, rin kich'aq yaykunaykillapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Chaqa chayshina (mana shaykuq) mañakushpaqam, ringillapa ch'askiq. Maskashpaqam, ringillapa tariq. Chayshinallam pungupi qayakuptikiqa, rin kich'akaq yaykunaykillapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’¿Mayá, wambraykiqa suq tanditata mañashuptinqachu, qongimanllapa suq rumita? ¿Ichu suq piskaduta mañashuptinqachu, qongimanllapa suq kulibrata? ");
INSERT INTO qvcNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Ichu, “Wallpap wawanda qoway”, nishuptinqa, suq atallki kuruta (alakran kuruta) qongimanllapa? Manám. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Chayshinar intyindiyllapa, qamkunaqam malu kashpapis, allin kusasta wambraykitaqa qongillapa, ¿manachu? Piru Taytanchiq Dyus syilupi kaqqam qamkunamandaqa mas allin. Chaymi payqa Santu Ispiritunda rin qoq mayqan mañaqtaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Suq runatam dyablu muduyachishqa karqan. Chaymi Jisusqa chay mudumanda dyabluta qatirqan. Chay dyablu lluqshiptinqam, chay runaqa atirqanna rimayta. Chaymi chayta rikashpa, runakunaqa ancha ispantarqanllapa. Nuta: Manam yumbay mudukunaqa dyabluwanchu. Wakingunallam dyabluwanqa.  ");
INSERT INTO qvcNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Piru wakinqam niqllapa: —Chay mas kamachikuq dyablu Bilsibum Jisustaqa yanapan. Chaymi atin dyablukunata qatiyta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Wakinqam Jisusta munashpa mallipayta, kayshina nirqanllapa: —Mayá, suq milagruta ruray syilupi, rikashpa yach'anayllapa: Dyuspaqmi rimangi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Piru Jisusqam yach'arqan chay runakuna yuyashqandaqa. Chaymi yumbayta nirqan: —Mayá, suq nasyumbi paykunapura pilyashpaqa, ¿imanaytaq atinmanllapa kawsaytaqa? Chaqa wanchinakushpash', limpuna ushyakanmanllapa. Chayshinallam suq ayllu, paykunapura pilyashpaqach'i, limpuna ushyakanmanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Chayshinallam dyablupis pay kikin ch'iqnikashpa maqakashpa wanchikashpaqa, ushyakanmanna, ¿manachu? Piru qamkunaqam noqapaq ningillapa: “Dyablu Bilsibu yanapaptinmi, atishqa dyabluta runakunamanda qatiytaqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Chayshina noqapaq niptikillapaqa, ¿pim yanapan qamkunapa yach'akuqnikikunata, dyablukunata runakunamanda qatinanllapaqa? ¿Dyabluchu yanapan paykunata qatinanllapaqa? Chay yach'akuqniki kaqkunapaq yuyashpa, intyindiyllapa: Ancham pandashqallapa kanchiq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Piru noqaqam dyablukunataqa runakunamandaqa qatini, Taytay Dyus kikin yanapawaptin. Chayri rurashqayta rikashpa, yach'ayllapa: Dyuspa pudirninqam shamushqana noqanchiqkunaman, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Suq runa ancha jwirsayuq, armayuq wasinda kwidaptinqam, tukuy iman kaqkuna chay wasimbi allita tiyan. Chaqa manam pipis chutanchu. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Piru suq mas wapu runa shamushpam, chay jwirsayuq runata maqashpa binsishpana, paypa armangunata, kusasningunata limpu atin qoch'iyta. Chayshina wichukushpa chay jwirsayuq dwiñutaqam, chay binsikuqna kamachikun chay qoch'ishqambiqa. (Chay runashinam noqapis dyabluta binsishpa, runakunata, warmikunata qoch'ini washanaypaq.) ");
INSERT INTO qvcNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Mana noqapa faburniy kaqqam kuntrawashpa purin. Chaqa mayqan washanaypaq kaqmanqam mana tandakanchu. Ashwanmi shikwan, ama pullay kanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Suq dyablum suq runamanda lluqshishpa, rin puriq chuncha lugarkunaman, maskashpa maypi tiyanambaq. Piru chay dyablu mana atishpa maypi tiyaytaqam, chay runa lluqshishqanmanda kaqta yuyashpa, nin: “¡A, paymanlla kutirishaq!” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Chayshina yuyashpa kutirishpaqam, chay runataqa tarin suq pichadu allichadu wasitashina. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Chaymi dyablu masingunaman rishpa, syiti mas fiyu dyablukunata apamun chay runamanqa. Chayshinam suq trupa dyablukunapa ispiritungunana runamanqa yaykunllapa, wasipishina tiyananllapa. Chaymi chay runaqa unay ashla malu kashqanmandaqa mas maluna tikrakan. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisus chaykunata rimaykaptinqam, chay ancha achka runakunapa ukunmanda suq warmi ancha jwirtita rimashpa nirqan: —¡Ancha kushikunqa chay warmi qeshyashuq, ñuñuchishushpa uywashuqqa! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Chayshina paypaq niptinmi, Jisusqa nirqan: —Ashwan masta kushikunqa Dyus nishqanda uyashpa kasuqkunaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ancha achka runakunam Jisusman tandakarqanllapa. Chaymi payqa kayshina yach'achikurqan: —Kay tyimpumanda runakunaqam ancha uchayuqkuna. Suq milagrutaraqmi munanllapa rikayta. Piru manam paykuna munashqanqa kanqachu. Ashwanmi Dyusqa suq milagrutalla rin ruraq, paykuna rikanambaq. Manchu unay tyimpukunapi Dyusqa rurarqan suq milagruta paypaq rimaq Junaswan. Chay laya milagrutallam Dyusqa rin ruraq noqawambis. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Chaqa Ninibi llaqtapi tiyaqkuna kriyinambaqmi, chay Junaswan Dyus suq milagruta rurarqan. Chayshinallam noqa Dyusmanda Shamuq Runawambis rin ruraq, kay tyimpumanda runakuna noqapi kriyinanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kanan jwisyu diyapim Dyusqa rin jusgaq kay tyimpumanda kaqkunata. Chay diyapim Saba nasyumba warmi gubyirnan kawsamushpa, shayashpa, Dyuspa ñawpambi rin shimbiq kay mana kasuwaqkunata. Chaqa chay warmi gubyirnaqam ancha karu nasyunmandapacha shamurqan, yach'ayniyuq gubyirnu Salumun nishqanda uyaq. Piru Salumunmanda kaypi mas yach'ayniyuq kaptiypismi, mana munangillapachu uyawaytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Chay Ninibipi tiyaqkunapismi Junas yach'achiptin, mana alli rurashqangunata dijashpa, Dyustana kasurqanllapa. Piru chay Junasmanda kaypi mas kamachikuq kaptiypismi, mana munangillapachu kasuwaytaqa. Chaymi jwisyu diyapiqa chay ninibinukunapis Dyuspa ñawpambi rin jusgashuqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Suq michata syindishpaqam, mana pipis suq pakaqman ichu suq kajumba waranman ruranchu, ¿manachu? Ashwanmi michataqa altupi ruran, yaykuqkunata achikchanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ñawinchiqpismi suq michashina kwirpunchiqpaqqa. Chaymi allita chapakuptinchiqqa, tukuy kwirpunchiqpis achikpishina purin. Piru mana baliptin ñawinchiqkunaqam, tukuy kwirpunchiqpis tutayaqpishina purin. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Chaymi kunaykillapa, chay michaykillapakish tutayaqpaq tikrakanman. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Piru Dyusta kasuptikiqam, yumbay kwirpuyki michayuqshina rin kaq. Manam nima tutayaqpishinachu ringi puriq. (Chaqa allita rurashpaqam, suq atun micha achikchakuqshina ringillapa kaq.) ");
INSERT INTO qvcNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisus yach'achikuptinqam, suq farisiyu duktrinayuq runa payta kumbidarqan, wasinman rishpa, paywan mikunambaq. Chaymi ukuman yaykushpa, Jisusqa mesaman tiyarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Chaypim Jisusqa makinda mana mayllashpachu, tiyarqan mikunambaq. Chaymi isrraylinukunapa mayllakunan kustumbrinda mana ruraptin, chay farisiyuqa ancha chaparqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Chaymi Jisusqa chay farisiyuta nirqan: —Qamkunaqam suq platupa suq basupa sawandalla maylladukunashina kangillapa. Chaqa sawa kwirpuykitallam mayllangillapa. Piru shunqoykipiqam ancha nisyu ancha uchayuq kangillapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Ay, tuntukuna! ¿Manachu yach'angillapa, runakunapa sawanda Dyus rurashpaqam, shunqondapis rurarqan, nishpaqa? ");
INSERT INTO qvcNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Chayri qamkunaqa limush'naykita tukuy shunqo qoshpaqam, mana nima uchayuqchu ringillapa kaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Ay qamkuna farisiyukunaqa! Chaqa Dyustaqa qongillapa irba bwinamanda, rrudamanda dyis rapranmanda suqta. Chayshinallam yumbay plantamanda dyismuykita qongillapa. Piru runa masikikunata malta rurashpam kawsangillapa. Tayta Dyustapismi mana kuyangillapachu. Chayri chay dyismuykita qoshpa, shumaqta kuyayllapa Dyusta, runa masikikunatapis. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Ay qamkuna farisiyukunaqa! Sinaguga wasikunapi kashpaqam, ancha munangillapa tiyayta chay kamachikuqkunapa tiyanangunapi. Kanan munangillapam, shumaqta napaykushunanllapa kallikunapi. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Ay, qamkuna Muysispa liyningunata yach'achikuqkuna, farisiyukuna! Shimikiwanllam Dyusta kasungillapa. Chaymi qamkunaqa chay pakashqa sipulturashina kangillapa. Chaqa runakunaqam chay pakashqa sipulturapa sawanda pasashpaqa, mana yach'anllapachu: (Ukupim ancha mapa ash'naykan, nishpaqa. Chayshinallam qamkunata tingushushpapis, mana yach'anllapachu: Paykunam uku shunqombi ancha uchayuq, nishpaqa.) ");
INSERT INTO qvcNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Chaymi suq runa Muysispa liyningunata yach'achikuqqa Jisusta nirqan: —Yach'achikuq Taytitu, chayshina nishpaqam, noqaykunatapis ancha piñachiwaykangi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Chaymi Jisusqa nirqan: —¡Ay qamkuna Muysispa liyningunata yach'achikuqkuna! Chaqa qamkunaqam suqkunata mana atiypaqta aparichingillapa. Piru qamkunaqam mana nimatapis ni suq diduykiwan munangillapachu yanapayta paykunataqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Ay qamkunaqa! Chay unay agwiluykillapam wanchirqan Dyuspaq rimaqkunata. Kanan qamkunaqam chay rimaqkunapa nichu laya sipulturangunata allichangillapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Piru chayshina allichashpapismi, chay unay kastaykishinalla yuyaykangillapa. Chaqa paykunaqam Dyuspaq rimaqkunata wanchirqan. Chaymandaqam qamkunaqa sipulturangunata allichangillapa. (Piru kananqam noqata munangillapa wanchiwayta. Chaymi chay unay agwiluyki wanchikuqkunashina kangillapa). ");
INSERT INTO qvcNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Chaymi Tayta Dyusqa chayta yach'ashpa nirqan: “Kach'amuqmi rini qamkunaman noqapaq rimaqkunata, apustulniykunatapis. Piru wakindaqam ringillapa wanchiq; wakindaqam ringillapa qesachaq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Chaymi niykillapa, Tayta Dyusqam rin kastigashuqllapa yumbay chay wanchishqa rimaqkunapa yawarnimbaq, chay punta runa Adamba churin Abilta wanchishqan tyimpumandapacha chay Sakariyasta wanchishqan tyimpukaman. Chay Sakariyastaqam wanchirqanllapa Dyuspa adurana wasimba pata altarpa ladumbilla. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Ay qamkuna Muysispa liyningunata yach'achikuqkunaqa! Chaqa qamkunaqam mana munangillapachu Dyusta kasuyta, syiluman ch'ayanaykiqa. Kanan suqkuna munaptin Dyusta kasuytaqam, qamkunaqa mana allin duktrinaykita yach'achingillapa. Chaymi paykunaqa ancha pandashpa, mana atinllapachu Dyusta allita kasuytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Jisus chayshina niptinqam, Muysispa liyningunata chay yach'achikuqkuna, chay farisiyukunapis ancha piñakurqanllapa. Chaymi tukuy laya tapunata tapurqanllapa, pandaptin, chaypaq tumbananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Chayshina farisiyukuna tapunangamanmi, ancha achka mil runakuna ch'ayarqan Jisusman sarrunakuypa. Chaymandaqam Jisusqa puntata yach'akuqningunata nirqan: —Kwidakayllapa chay farisiyukunapa libaduranmanda. Chaqa paykunaqam shiminwanlla Dyusta kasunllapa. Nuta: Ashla libadurallam achka masata atin saksachiyta. Chayshinallam farisiyupa kustumbringunata ashlitatalla ruraptinchiq, ancha dañachiwanchiqman.  ");
INSERT INTO qvcNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Piru tukuy chay pakadu mana allita rurashqanda ancha klaruta yumbay rinllapa yach'aq. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Chay tyimpupiqam tukuy maypi manyaqlla rinllapa yach'aq tutap pakakushpa ichu uku wasikipi uyaritap (uyarita) parlashqaykitapis. Chay tyimpupiqam wasikunapa sawangunamanda ancha jwirtita rinllapa rimaq tukuy ima parlashqaykipaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Yanasitakuna (Yanasitukuna), qamkunatam niykillapa, ama manchayllapachu wanchikuqkunataqa. Chaqa kwirpuykitallam atinllapa wanchiytaqa. Manam mastaqa atinllapachu imanachishuyta. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Chayri Dyustalla manchayllapa. Chaqa payqam bidaykita qoch'ishushpa, atin infyirnuman wichushuyta. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","7","’Piru Dyusqam ancha kuyashushpa, ancha allita riqsishungillapa. Chaymi yumbay aqchaykillapata manyaqlla yupashqa. Asta ashla baliq pishqetukunatapismi kwidan. Manchu runakunaqa ishkay qellitaywanlla atin randiyta sinku indyu pishqo layakunata. Chayshina runakunapaq mana baliptimbismi, Dyusqa mana ni suq pishqetuta qonqanchu. Chayri ama llakiyllapachu. Chaqa qamkunaqam ancha achka pishqetukunamanda masta balingillapa Dyuspaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Yumbaytam niykillapa, mayqan runa ichu warmi mana penqakushpachu, runakunapa ñawpambi noqapaq rimaptinqam, noqa Dyusmanda Shamuq Runapis jwisyu diyapi Dyuspa chay anjilningunapa ñawpambi paypa faburninda rini rimaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Piru runakunapa ñawpambi ñigawaqtaqam, jwisyu diyapiqa noqapis Dyuspa anjilningunapa ñawpambi kayshina rini ñigaq: “Manam paytaqa riqsinichu”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Mayqan runa noqa Dyusmanda Shamuq Runata kuntrawashpa mana allikunata rimawaptinqam, Dyusqa pirdunanman. Piru Dyuspa Santu Ispiritunda mayqan kuntranda rimaqtaqam mana rinchu pirdunaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Noqapaq yach'achikuptikim, kuntrashuqkunaqa rinllapa apashuq sinaguga wasikunaman, juyiskunaman, suq awturidarkunaman. Chayshina rurashuptinllapaqa, ama llakiyllapachu: Tapuwaptinqa, ¿imataraq nishaq? nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Chaqa Dyuspa Santu Ispiritunmi chay uraspi rin yanapashuq, allita rimanaykillapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Chay ancha achka runakunamanda suqninmi Jisusta nirqan: —Yach'achikuq Taytitu, masaytar niy, irinsyayta partiwanambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Chaymi Jisusqa nirqan: —¿Pitaq numbrawashqa, juyisniki kashpa, irinsyaykita partichishunayqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nirqambismi: —Kwidakayllapa, ama tukuy imata munakunaykillapa. Chaqa runakuna shumaqta kawsanambaqqam mana munanchu tukuy imayuq kanambaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Chayshina nishpaqam, suq kumparasyunda rurashpa nirqan: —Suq kapuq runash ch'akrangunamanda ancha allita kusichakuq. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Chayshi chay runaqa yuyarqan: “¿Imanashaqtaq? Chaqa kusichaytaqam mana maypi atinichu waqaychayta”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Chayshina yuyashpaqash nirqan: “¡A, ya! Yach'aninam imatam rini ruraq. Yumbay waqaychana wasiykunata bulashpam, mas atungunata rini ruraq, chaypi kusichayta tukuy imayta tandanaypaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Chaymandaqam nishaq: Kananqam waqaycharqayna tukuy kusichayta achka watakunapaq. Chayri kananqa samashpa, mikushaq, upyashaq, kushikushaq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Piru Tayta Dyusqash chay runataqa nirqan: “A, runa tuntu, kay tutatam ringi wañuq. Kanan chay imaykikunaqa, ¿pipaqraq kidanqa?” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Chayshinam rin kaq chay nisyukunawanqa. Chaqa achka qellayniyuq kashpapismi, Dyuspaqqa mana nima allita rurashqachu. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Chaymandaqam Jisusqa yach'akuqningunata nirqan: —Noqaqam niykillapa, ama llakiyllapachu, ¿imataraq mikushaq? ¿Imataraq rurakushaq? nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Chaqa bidaykiqam ancha balin maski mikunamanda. Kwirpuykipismi balin maski mudanaykimanda. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pishqokunapaq yuyayllapa: Paykunaqam mana tarpukunchu, ni kusichakunchu. Manam ni trujayuqchu ni wasiyuqchu, granukunata tandanambaqqa. Piru Tayta Dyusmi paykunata mantyinin. Qamkunaqam chay pishqokunamandaqa masta balingillapa Dyuspaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mayá, qamkunamanda suqniki ancha munashpa masta wiñaytaqa, ¿ima ancha llakishpachu atingiman midyu mitru masta wiñayta? ¡Manám! ");
INSERT INTO qvcNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Chayshina mana ni chayta atishpa ruraytaqa, ¿imapaqnam llakingillapa, imaraq pasawanqa, nishpaqa? ");
INSERT INTO qvcNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Allita yuyayllapa chay ancha shumaq liryu tuktukunapi. Manam trabajanllapachu ni puchkakunllapachu. Piru alliptam niykillapa, chay ancha kapuq gubyirnu Salumunqam ancha shumaqta mudakushpapis, mana atirqanchu chay tuktukunashina mudakuytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Chay ch'akraykipi qewakunam suq tyimpitulla kawsan. Qayandimbaqqam rupachinapaqna balin. Piru chay tuktu mana duraqkunatam Dyusqa ancha shumaqta ruran. Chayshinam qamkunatapis ancha shumaqta rin rurachishuqllapa maski chay shumaq tuktukunamanda. Chayshina kaptinqa, ¿imaraykutaq Dyuspiqa mana allitaqa yuyakungillapachu? ");
INSERT INTO qvcNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Chayri ama llakiyllapachu, ¿imataraq mikushaq? ¿Imataraq upyashaq? nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Chaqa Dyusta mana kasuqkunaqam tukuy imata munashpa, ancha llakinllapa: ¿Imashinataq chaytaqa atini kunsigiyta? nishpa. Chayri qamkunaqa ama paykunashinaqa kayllapachu. Chaqa Taytanchiq Dyusmi yach'an imam faltashungillapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Chayri Dyus munashqanda puntata rurayllapa, pay kamachikuqniki kanambaq. Chayshina ruraptikillapaqam, tukuy ima faltashushqandapis rin qoshuqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Kuyashqay wishitaykuna, ama nimata manchayllapachu. Chaqa ashlita kaptikipismi, Taytanchiq Dyusqa ancha kushikushpa, suq mushuq bidata munan qoshuyllapata, paywan tukuy tyimpu kawsanaykillapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Chayri imaykita randikushpa, chay mana nimayuqkunata qoyllapa. Chayshina Dyus munashqanda ruraptikiqam, payqa shumaq primyuykita syilupi rin qoshuqllapa. Anaqpiqam chay primyuyki mana nunka rinchu ushyakaq. Manam ni ladrunguna rinchu yaykuq apaqqa, ni pulillakuna rinchu kush'kuq. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kanan chay primyuyki syilupi kaptinqam, qamqa shunqoykipi ancha ringi yuyakuq Tayta Dyuspilla. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","’Listu kayllapa, noqa shamuptiy, shumaqta ch'ayachiwanayki. Manchu suq patrumba kriyadungunaqa, allita sigurakashpa, michata syindishpa, patrunninda shuyanllapa. Chaqa chay kriyadukunaqam patrunnin kasamyintu fyistapi kaptinqa, rikch'aykashpalla shuyan, ch'ayamuptin, das kich'anambaq punguta. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Chaymi chay shuyakuq kriyadukunaqa ancha kushikunqallapa, chay patrunnin kutimushpa, mana puñuykaqta tariptinqa. Alliptam niykillapa, chay patrunmi, mandilninda rurakushpa, chay kriyadungunata mesaman tiyachishpa, rin qaraq. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Chaymi ch'awpi tutata ichu madrugadupi shamushpa, paykunata mana puñuykaqta tariptinqa, kushikunqallapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kaytapis yach'ayllapa, suq wasi dwiñu yach'ashpa: Kay tutam ladrunqa rin shamuq suwawaq, nishpaqach'i, mana puñunmanchu. Ashwanmi allita rikch'ashpa, kwidakunman yuraqashtin, ama wasinman yaykunambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Chayshinar qamkunapis allita kawsashpa, listu kayllapa, shumaqta ch'ayachiwanayki. Chaqa noqa Dyusmanda Shamuq Runaqam mana yuyashqaykillapa uraspi rini kutimuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pidruqam Jisusta tapurqan: —Taytitu, ¿chay kumparasyundaqachu noqaykunapaqlla rurarqayki ichu yumbay runakunapaq? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Chaymi Jisusqa nirqan: —Mayá, yuyayllapa, ¿pim chay allin kumplidu yach'ayniyuq kamachikuq impliyaduqa? ¿Ima laya runatam patrunninqa numbran, paypa makimbi dijanan wasinda kwidanan, kriyadungunata urasnimbi qaranambaqqa? ");
INSERT INTO qvcNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Chay wasi kwidaqqam ancha rin kushikuq, chay patrunnin kutimushpa, kamachishqanshina ruraykaqta tariptinqa. Chaymi chay wasi kwidaq kriyaduqa ancha rin kushikuq, chay patrunnin kutimushpa, kamachishqanshina ruraykaqta tariptin. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Alliptam niykillapa, chay kriyadun allita kasushqanrayku, chay patrunninqa mas kamachikuqta numbrashpa, tukuy imandana paypa kwintan rin dijaq, payna rikanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Piru amakish chay kriyaduqa yuyanqachu: Manaraqmi patrunniyqa rinchu kutimuq, nishpa, maluyashpa, kriyadu masingunata maqashpa, payllana unda unda mikunman, upyanman, mach'anman. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Chayshina ruraykaptingish, patrunninqa mana yuyashqan diyapi, qonqaylla shamushpa, ancha fiyuta rin kastigaq. Chaymandaqam paytaqa rin wichukuq mana kriyiqkuna kashqanman. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Mayqan kriyadu yach'ashpa: Patrunniymi kayshina munan ruranaypaq, nishpaqa, piru mana nima rurananda rurashpaqa, ancha kastigadu rin kaq, patrunninda mana kasushqanrayku. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Piru suq kriyadu mana yach'ashpa, patrunnin munashqanda mana rurashpaqam, ashla kastigadulla rin kaq. Chayshinallam suq kriyaduta achkata intrigashpa, suq tyimpumanda ancha rin mañaq kwintata qonambaq: ¿Maypim ganansyay? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Noqam kay mundumanqa shamushqa kani, ninata apamushpa. ¡Chaymi ancha munani miranambaq! ");
INSERT INTO qvcNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Piru puntatam ancha padisishpa, mallipadu rini kaq. Chaymi ancha padisini Dyus munashqanshina kumplinangaman. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Ima qamkunaqachu yuyangi: Siñurninchiq Jisuspi kriyiptinchiqmi, yumbay runakuna shumaqta rin kawsaq noqanchiqkunawan, nishpa? Manam chayshinachu. Ashwanmi noqapi kriyiptikillapa, suqkunaqa qamkunamanda rinllapa akrakaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Chaqa suq ayllupi noqapi mana kriyiqkunaqam rin akrakaq noqapi kriyiq ayllungunamanda. Sinku kaptinqam, kimsa rin kuntraq ishkayta. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Kanan taytanmi ullqo wambranda rin kuntraq. Churimbismi taytanda rin kuntraq. Mamambismi warmi wawanda rin kuntraq. Warmi wawambismi mamanda rin kuntraq. Swigrambismi llumchunda rin kuntraq. Llumchumbismi swigranda rin kuntraq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Chay achka runakunataqam Jisusqa kayshinapis yach'achirqan: —Qamkunaqam waq rupay seqanamba ladumbi pukutayta rikashpaqa ningillapa: “Rinnam tamyaq”, nishpa. Allibri chay nishqaykishina rin tamyaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kay lugarpi sur ladumanda wayraptinqam, ningillapa: “Biranum rinna shamuq”, nishpa. Kanan allibri chay nishqaykishina shamun. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Piru Dyus munashqandaqam mana munangillapachu yach'ayta. ¡A, qamkuna shimikiwanlla Dyusta kasuqkunaqa! Qamkunaqam syilupi ichu kay pachapi ima kaqta rikashpa yach'angillapana: Imam rin kaq, nishpa. Chayshina yach'ashpaqa, ¿imaraykutaq mana yach'angillapachu: Dyus nishqanqam kumpliykanna, nishpaqa? ");
INSERT INTO qvcNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Imaraykutaq qamkuna kikiki mana yach'angillapachu: Imam alli, imam mana allichu, nishpaqa? ");
INSERT INTO qvcNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Chayri mayqan imapaq dimandashushpa, juyisman apashuykaptinqa, ñambilla alliyay chay mana allita rurashqaykipaq. Mana chayta ruraptikikish, apashungiman juyisman. Chaykish juyisqa kach'ashungiman suldadukunaman, karsilman apashunambaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Chaymi allipta niykillapa, karsilmandaqam mana ringichu lluqshiq yumbay kubrashushqanda pagaranaykikaman. Chaqa manash' ni suq sintimuta rinchu pirdunashuq. ");
INSERT INTO qvcNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Chay tyimpupillam suq runakuna shamushpa, Jisusta nirqan: —Suq disgrasyam kashqa. Chaqa wakin llaqta masiki galiliyanukunam Dyuspa adurana wasimbi animalningunata wanchiykarqanllapa, Dyusta aduranambaq. Chayshina ruraykaptinllapam, gubyirnu Pilatupa suldadunguna qonqaylla paykunataqa wanchirqan. Chaymi chay runakunapa yawarnin chay animalningunapa yawarninwan taqllukarqan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Chaymi Jisusqa nirqan: —(Kwidawkish qamkunapis paykunashina wañungimanllapa.) Amar yuyayllapachu: Chay runakunaqam yumbay llaqta masin galiliyanukunamanda mas uchayuq kashqanrayku, wañurqanllapa, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ashwanri allita yach'ayllapa, uchaykita mana dijaptikillapa Dyusta kasunaykipaqqam, qamkunapis ringillapa chingaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Manchu Jirusalimbiqa chay Siluwi shutiq altu turri bulakashpa, 18 jirusaliniruta pambashpa wanchirqan. Piru amar yuyayllapachu: Chay wañuqkunam yumbay llaqta masingunamanda mas uchayuq kashqanrayku, chayshina wañurqanllapa, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ashwan alliptam niykillapa, uchaykita mana dijashpaqam, qamkunapis ringillapa chingaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Suq kumparasyunda ruranambaqmi, Jisusqa kayshina nirqan: —Suq runapa wirtambim suq yura igus karqan. Chaymi chay dwiñunqa suq diya rirqan chay igusnimba puqoyninda maskaq. Piru manam nima puqoyninda tarirqanchu. ");
INSERT INTO qvcNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Chaymi piyunninda qayashpa nirqan: “Rikay, kimsa watanam achka bwiltasta yanqa shamushqa kani igusta pallaq. Piru rikay, kanangamanmi mana nima puqoyninda tarishqachu kani. Chayri kuchuyna. Yanqam arkakuykan wirtaypiqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Piru chay piyunninqam nirqan: “Taytitu, dijayraq kay watitata. Mayá, tukuy rridurninda allashpa wanuta wichushaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Talbisri chayshina ruraptiy, puqonman. Piru mana puqoptinqam, chaypina kuchushpa wichukungi”, nishpa. Nuta: Chay yura igus mana puqoyniyuqqam chay runa Dyusta mana kasuqshina.  ");
INSERT INTO qvcNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Suq kutinmi Jisusqa samana diyapi sinaguga wasipi yach'achikuykarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Chaypim karqan suq qeshyaq warmi. Payqam 18 watas tukuyta kumurashpalla puriq. Chaqa suq dyablum rurashqa karqan, ama nimatapis atinambaq dirichu shayayta. ");
INSERT INTO qvcNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Chaymi Jisusqa chay qeshyaq warmita rikashpa, qayashpaqa nirqan: —Warmisita, nanaynikimandam kach'akachiykina. ");
INSERT INTO qvcNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Chayshina nishpaqam, Jisusqa makingunata sawanman rurashpa, chay uras das kach'akachirqan. Chaymi chay warmiqa, dirichuna shayashpa, Taytanchiq Dyusta ancha alabarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Chayta rikashpam, chay sinaguga wasipa kamachikuqninqa Jisuspaq ancha piñakurqan. Chaqa Jisusqam chay warmitaqa kach'akachishqa karqan samana diyapi. Chaymi chay kamachikuqqa yumbay chaypi kaqkunata nirqan: —Sayis diyastallam atinchiqllapa trabajaytaqa. Chayri chay diyakunapilla shamuyllapa, kach'akachishunan nanaynikimanda. ¡Ama samana diyapiqa! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Chayshina niptinqam, Jisusqa nirqan: —¡A, shimikiwanlla Dyusta kasuqkuna! ¿Ima qamkunaqachu mana trabajangillapa samana diyapiqa? Chaqa chay samana diyapiqam buyisnikita, burruykita takalninmanda paskashpa, apangillapa yakuta upyachiq, ¿manachu? ");
INSERT INTO qvcNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Chayshinallam kay warmi Abrajamba karu willkan kaqta dyabluqa 18 watasta kay qeshyaywan watashqashina. Chayshina kaptinqa, ¿akasuchu mana balin samana diyapi kach'akachinayqa? Chaqa ancham balin kach'akachinaypaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Chayshina Jisus niptinqam, yumbay chay kuntraqkunaqa ancha penqakurqanllapa. Piru chay ancha achka rikaqkunaqam, Jisus yumbay chay shumaq rurashqangunata rikashpaqa, ancha kushikurqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Chaymandaqam Jisusqa kayshinapis nirqan: —Dyustana kasuqkunataqa ¿imawandaq atini kumparayta? ");
INSERT INTO qvcNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Paykunaqam ñapushpa murunshina. Chaqa suq runa ch'akrambi tarpuptinqam, chay ñapushpa murunqa uchulitamanda wiñashpa, atunda wiñan. Chaymi asta bwilaq pishqokuna rikrangunapi kamachakunllapa (makachakunllapa). Nuta: Chay ñapushpa murunshinam Dyusta kasuqkunaqa. Chaqa ashlita kashpallapapismi, ancha rinllapa achkayaq.  ");
INSERT INTO qvcNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jisusqam nirqambis: —Dyustana kasushpa kawsaqkunataqa ¿ima maswandaq atini kumparayta? ");
INSERT INTO qvcNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Paykunaqam libadurashina. Suq warmiqam midyu kustal mach'kata yakuwan sangushpa, ashla libadurata taqlluptinqa, ancha achkayan. Chay ashla libaduraqam chay achka mach'kataqa limpu saksachin, ¿manachu? Nuta: Chayshinallam Dyusta kasuqkunapis ashlitalla kashpapis, ancha rinllapa achkayaq.  ");
INSERT INTO qvcNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jisusqam Jirusalinman riqshinaqa, llaqtakunaman, kasiriyukunaman ch'ayarqan. Ch'ayashpaqam, chay llaqtakunapi tiyaqkunata yach'achishpa, yach'achishpa, pasarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Chaypim Jisusta suq runa kayshina tapurqan: —Taytitu, ¿ashlitallachu rinllapa washadu kaqqa? nishpa. Chaymi Jisusqa nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Chay kich'ki punguta imashinapis utqa yaykuyllapa. Kaykish niykillapa, ancha achka runa warmim rinllapa munaq yaykuyta. Piru tardina kaptinqam, manana rinllapachu atiq yaykuytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Chaqa wasi dwiñu atarishpa, pungunda kirpaptinqam, mayqanniki sawapi kidaqqa pungunda takashpa, ringillapa qayakuq: “Kamachikuq Siñursitu, kich'ayri punguykita”, nishpa. Piru payqam rin nishuqllapa: “Manam riqsiykillapachu. ¿Maymandach'i kangillapa?” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Chaymandaqam qamkunaqa ringillapa niq: “Qamwanmi mikurqanchiq, upyarqanchiq. Manchur qamqa chay kalliykunapi yach'achikurqayki” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Chayshina qamkuna niptikipismi, payqa rin nishuqllapa: “¡Nishushqallapanam kani: Manam riqsiykillapachu! ¿Maymandach'i kangillapa? ¡Ashuyllapa kaymanda, qamkuna mana allikunata ruraqkunaqa!” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Chaymi sawa pungupi kidashpa, ringillapa rikaq chay alma Abrajanda, Isakta, Jakubuta, Dyuspaq rimaqkunatapis syilupi Dyuspa ñawpambina kaqta. Chaymi qamkunaqa ancha ringillapa malayakuq. ¡Llalli qamkunata Dyuspa ñawpanmanda qatishuptinqam, ancha waqashpa, ancha llakishpa, kiruykillapata ringillapa qech'yachiq! ");
INSERT INTO qvcNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Chaqa chay diyapiqam kay pachapa yumbay kuchungunamanda rin tandakaqllapa Dyusman, paywan syilupi tiyashpa, pulla mikunambaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Chay diyapim wakin mana kamachikuq kaqkunaqa ancha kamachikuqna puntapi rinllapa kaq. Piru wakin kamachikuq kaqkunaqam chay diyapiqa mana nimapaq balishpa, ancha ikipi rinllapa kaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Chay diyallam wakin farisiyu duktrinayuqkuna ch'ayamushpa, Jisusta nirqanllapa: —Riy kaymanda. Chaqa chay gubyirnu Irudismi munan wanchishuyta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Chayshina willaptinllapam, Jisusqa nirqan: —Riyllapa willay chay surrushina ingañakuq Irudista: “Kay diyakunam Jisusqa rin qatiq dyablukunata. Rimbismi kach'akachiq qeshyaqkunata. Chaymandaqam yumbay trabajunda rinna ushyaq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Piru kanan, qaya, qaya suq punchawpismi alli, kay ñanda rinaypaq. Chaqa Dyuspaq yumbay rimaqkunataqam masta wanchinllapa Jirusalin llaqtapi. ");
INSERT INTO qvcNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Ay, Jirusalimbi tiyaqkuna! ¡Qamkunaqam Dyuspaq rimaqkunata wanchingillapa! ¡Kanan Dyus kach'amushqan runakuna ch'ayashuptinmi, sitashpa wanchingillapa! Manchu suq wallpaqa alitamba warambi pulichitungunata tandan. Chayshinallam noqapis kutin kutin ancha munashqa kani qamkunata tandashuyllapata. Piru manam munashqallapachu kangi. ");
INSERT INTO qvcNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Chaymi kay llaqtaykiqa wichukudu rin kaq. Kanan mananam ringillapachu rikawaq, suq diya kutimunaykaman. Chaymi chay diyapi noqapaqqa ringillapa niq: “¡Alabashqa kanqa, Tayta Dyuspa rrimplasun shamuqqa!” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Suq samana diyapim Jisusqa rirqan mikuq suq kamachikuq farisiyu duktrinayuqpa wasinman. Chaypim wakin farisiyukunaqa Jisusta chapaykarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Chaypim karqambis suq runa ancha padisiykaq saksaywan. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Chaymi Jisusqa Muysispa liyningunata chay yach'achikuqkunata, chay farisiyukunatapis tapurqan: —Mayá, ¿qamkunaqa imatam ningillapa? ¿Dyusqachu dijawanchiq, runa masinchiqta kach'akachinanchiq samana diyapi ichu mana? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Chayshina tapuptinqam, chay farisiyukunaqa uyararqanlla. Chaymi Jisusqa chay uras chay qeshyaqpa sawanman makinda rurashpa, kach'akachishpa: —Riyna, nirqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Chaymandaqam chay farisiyukunata nirqan: —Mayqannikipa suq burruyki ichu suq turuyki suq qoch'aman bulakaptin samana diyapiqa, ¿manachu chay uraslla qamkunapis trabajashpa, surqongimanllapa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Chaymi chay farisiyukunaqa manana nimatapis atirqanllapachu kuntistayta. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Chaymandaqam Jisusqa chay kumbidadu runakunata rikarqan, mas allin iskañukunata akraptin, puntapi tiyanambaqllapa. Chaymi suq kumparasyunda rurashpa, nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Mayqan kumbidashuptin suq kasamyintu fyistamanqa, ama tiyaychu punta tiyanapiqa. Chaqa puntapi tiyaptikiqakish, ch'ayamunman suq kumbidashqan mas kamachikuq qamanda. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Chaykish chay mayqan kumbidashuqqa nishungiman: “Qoyri kay tiyanata kay suqta”, nishpa. Chaych'i ancha penqakushpa, ringiman tiyaq iki tiyanaman. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Chayri mayqan kumbidashuptinqa, iki tiyanapi tiyay. Chaymi chay mayqan kumbidashuq shamushpa nishungiman: “Yanasita (Yanasitu), shamuy kay mas allin punta tiyanaman”, nishpa. Chaymi chay mesapi wakin kaqkunaqa qambaq ninqallapa: “Paymi ancha baliq runa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Chaymi mayqan runa munashpa kamachikuq kaytaqa, suq diyaqa rin penqakuq. Piru chay umildi kaqqam suq diyaqa ancha rin kamachikuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Chaymandaqam chay kumbidakuq runata Jisusqa nirqan: —Rurashpa fyistataqa, ama yuyaychu: Yanasaykunata (Yanasuykunata), masaykunata, aylluykunata ichu imayuq bisinuykunatallam rini kumbidaq, nishpaqa. Chaqa paykunaqam qam kumbidashqaykishina kumbidashushpa, rinllapa kutichishuq. Chayshinaqam mana pitapis yanapaykangichu. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ashwanri suq fyistata rurashpaqa, kumbiday chay mana imayuqkunata, mankukunata, kujukunata, sarkukunata. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Chaymi chayshina chay mana imayuqkunata yanapashpaqa, ancha kushikushpa ringillapa tiyaq. Chaqa chay pubrikunaqam mana atinqachu pagarashuytaqa. Piru allin runakuna kawsamuptinmi, Dyusqa rin pagarashuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Chaymi Jisus nishqanda uyashpaqa, chay mesapi tiyaqkunamanda suqninqa Jisusta nirqan: —¡Ancha kushikunqa chay runa Dyuswan syilupi tandata mikuqqa! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Chaymi Jisusqa nirqan: —Suq runash ancha allin fyistata rurashpa, kumbidarqan ancha achka runakunata. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Chayshi mikunan uras ch'ayaptinqa, kriyadunda kach'arqan qayamunambaq chay kumbidashqangunata. Chayshi kriyadunqa rishpa nirqan: “Shamuyllapana mikunanchiq. Listunam mikunaqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Chayshina qayaptinqash, yumbay kumbidashqangunaqa nirqan: “Pirdunawayllapa. Manam atinillapachu riyta”, nishpa. Chay punta runa kumbidashqaqash nirqan: “Randishqam kani ch'akrata. Riqmi rini rikaq. Chaymi rrugayki pirdunawanayki”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Suqpisshi nirqan: “Randishqam kani sinku yuntas buyiskunata. Chaymi rini riq mallipaq. Chaymi rrugayki pirdunawanayki”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Suqpisshi nirqan: “Chayraqmi kasarashqa kani. Chayraykum mana atinichu riyta”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Chayshi kriyadu kutimushpa, chayshina patrunninda niptinqa, chay patrunninqa piñakushpa, nirqan: “Riy kallikunamanda das apamuq waq mana nimayuq runakunata, mankukunata, kujukunata, sarkukunata”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Chayshi kriyaduqa rishpa, chaykunata apamushpaqa, nirqan: “Patrunsitu, apamushqanam kani chay niwashqaykishina. Piru kanraqmi tiyanakunaqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Chayshi patrunqa kriyadundaqa nirqan: “Riy kallikunaman, ñangunaman. Ancha animachishpa, apamuy suq runakunatapis, kay wasiy undanan. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Piru manam ni mayqan waq punta kumbidashqayqa mikunqachu mikunaytaqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Chay tyimpupim ancha achka runakuna, warmikuna Jisuspa ikinda rirqanllapa. Chaymi payqa rishqanshina tikrakamushpa, yumbayta nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Mayqan noqaman shamuqqa ancha kuyawanqa maski yumbay kuyashqanmanda. Chayri mayqanniki noqata kuyawanaykimanda taytaykita, mamaykita, warmikita, wambraykikunata, masaykikunata, panikikunata ichu kikin kwirpuykita masta kuyashpaqam, mana balingichu yach'akuqniy kanaykipaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Chayri noqapi kriyishqaykirayku padisishpa, ichu suq kruspi munaptinllapa wanchishuytapis, allita kasuwashpaqa, noqapa allip yach'akuqniy ringi kaq; manaqa manam. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","’(Mayá, nishqaykillapa suq kumparasyunda:) Mayqanniki suq altu turrita munashpa ruraytaqa, puntata allita yuyangiman: ¿Aykataraq gastayman ushyanayqa? ¿Aypanmanchuraq qellayniy ichu mana? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Chaqa mana allita yuyashpa, simyintuta qallarishpaqam, mana atingimanchu ushyayta, faltaptin qellayniki. Chaymi yumbay rikashuqkuna asipashushpa ninmanllapa: ");
INSERT INTO qvcNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Kay runam qallarishqa suq turrita ruraq; piru manam atishqachu ushyayta”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","’Ichu mayqan gubyirnu munashpa pilyayta suq gubyirnuwanqa, manachu puntata allita yuyanman: ¿Kay 10.000 suldaduykunawanqa atiymanchu binsiyta paypa 20.000 suldadungunataqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Chaymi mana atishpa pilyaytaqa, karupillaraq kashpa, chay gubyirnuqa kach'anman rrimplasunda parlanambaq, ama pilyananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","(Chayshinar mayqanniki noqata munashpa kasuwaytaqa, puntata ancha allita yuyay: ¿Alliptachu munani kasuyta ichu mana? nishpa.) Chaqa mana dijashpa tukuy imaykitam, mana atingichu yach'akuqniy kaytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Chaymandaqam Jisusqa suq kumparasyunda rurashpa, kayshinapis nirqan: —Kach'iqam ancha allin. Piru lambaqyaptinqam, mana atinchiqchu allichayta kach'iyanambaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mananam balinchu nimapaq, ni wanupaq. Ashwanmi wichukunanchiqna balinqa. Chayri qamkuna rinriyuqkunaqa, allita uyawayllapa, nishpa. Nuta: Jisusta mana munaq kasuqqam chay mana baliq kach'ishina.  ");
INSERT INTO qvcNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Achka kuntribusyunda kubrakuqkuna, suq laya uchayuqkunapismi qemikarqanllapa, Jisusta uyanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Chayraykum farisiyu duktrinayuqkuna, Muysispa liyningunata yach'achikuqkunapis Jisusta penqashpa nirqanllapa: —Rikay, Jisusqam uchayuq runakunata ch'ayachishpa, paykunawan mikun, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Chaymi Jisusqa kay kumparasyunda rurarqan: ");
INSERT INTO qvcNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Mayá, qamkunamanda suqniki 100 wishayuq kashpa, suq wishayki chingaptinqa, ¿manachuraq chay 99 wishaykita pastupi dijashpa, ringiman maskaq chay suq wishaykita tarinaykikaman? ");
INSERT INTO qvcNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Chaymi chay wishaykita tarishpaqa, ancha kushikushpa umbrukushpana apamungiman. ");
INSERT INTO qvcNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kanan wasikiman ch'ayashpaqam, kumpañiruykikunata, bisinuykikunata tandashpa, ningiman: “¡Kay chingashqa wishaytam tarishqana kani! ¡Chayri kushikushunllapa!” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Chaymi allipta niykillapa, chayshinallam syilupipis. Dyuspi chay 99 kriyiqkunapaq syilupiqa ancha kushikunllapa. Piru suq mana allin runa ichu warmi uchangunata dijashpa, Dyuspina allipta kriyiptinqam, ashwan masta kushikunllapa syilupiqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Mayá, suq warmi dyis ancha baliq yuraq qellayniyuq kashpa, suq qellayninda wichushpaqa, ¿manachuraq michanda syindishpa, chay wasinda pichashpa, kuchun kuchun allita maskanman tarinangaman? ");
INSERT INTO qvcNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Chaymandaqam chayshina tarishpaqa, tandashpa yanasangunata, bisinangunata ninman: “Yanasitakuna, kushikushunllapa, kay wichushqay qellayniyta tarishqayrayku”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Chayshinallam syilupi Dyuspa anjilningunapis ancha kushikunllapa suq mana allin runa uchangunata dijashpa, Dyustana kasuptinqa. (Chayraykum chay uchayuqkunawanqa tandakani, Dyuspaq yach'achinaypaq), nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jisusqam nirqambis: —Suq runam ishkay churiyuq karqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Chay shullka churinmi taytanda nirqan: “Taytitu, qowaynari noqapaq kaq irinsyayta”, nishpa. Chaymi taytanqa chay ishkay churingunata ch'akrangunata animalningunata partirqanna. ");
INSERT INTO qvcNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Chaymandaqam wakin diyamandaqa, chay shullka churinqa irinsyanda limpu randikushpa, suq karu nasyunmanna rirqan. Waqpiqam tukuy laya mana allikunata rurashpa, chay qellayninda malgastashpa, limpuna ushyarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Chaymandaqam yumbay qellayninda ushyaptinqa, chay nasyumbiqa tukuy maypi ambrunana karqan. Chaymi payqa mallaqna purirqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Chayraykum manana nimanayta atishpaqa, suq patrunmanna rirqan, trabajuta maskaq. Chaymi chay patrunqa trabajuta qoshpa, kach'arqan asyindanman, kuchingunata qaranambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Chaypi qaraqshinaqam anchana mallaqnarqan. Chaymi kuchikunapa mikunan algarrubuta anchana munarqan mikuyta. Piru manam dijarqanllapachu mikunambaqqa. Nuta: Chay algarrubuqam suq plantapa puqoynin. Piru manam runakuna mikunanchu.  ");
INSERT INTO qvcNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Chaymi ancha yuyashpa nirqan: “Taytaypa wasimbiqam achka trabajadurkuna kan. Paykunaqam ancha allita mikunllapa. ¡Piru noqaqam kaypi mallaqnashpa wañuqna rini! ");
INSERT INTO qvcNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Kutirishaq taytayman. Ch'ayashpaqam nishaq: Taytitu, Dyusta, qamta mana kasushushpam, ancha uchata rurashqa kani. ");
INSERT INTO qvcNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Chaymi manana balinichu, churiki kanaypaqqa. Suq piyunnikitashinar ch'ayachiway”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Chayshina yuyashpaqam, chay karu nasyunmandaqa kutimurqanna taytanman. ’Chaymandaqam ch'ayaykaptinqa, taytanqa karupilla rikashpa, ancha llakipashpa, kallparqan tinguq. Tingushpaqam abrasashpa, mucharqan qaqllambi churindaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Churinqam nirqan: “Taytitu, Dyusta, qamta mana kasushushpam, uchata rurashqa kani. Chaymi manana balinichu, churiki kanaypaqqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Piru taytanqam qayashpa kriyadungunata kamachirqan: “Chay mas allin mudanata apamushpa, kay churiyta mudachiyllapa, surtijachiyllapa, sapatuchiyllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Chay mas gurdu mishiruta apamushpa, wanchiyllapa, fyistata rurashpa mikunanchiqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Chaqa kay churiyqam chingashpa, wañushqashina karqan. Piru kanan kutimushpaqam, kawsamushqashina”, nishpa. Chaymi fyistata rurashpa kushikurqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Piru chay kulaka churinqam ch'akrambi kashqa karqan. Chaymandaqam wasinman ch'ayaykashpaqa, uyarqan kunyalla fyistata rurashpa dansaykaptinllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Chaymi payqa suq kriyadunda qayashpa tapurqan: “¿Imam kan?” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Chay kriyadunqam nirqan: “Masaykim ch'ayamushqana. Chaymi taytaykiqa allilla ch'ayamushqanrayku, chay mas gurdu mishiruta wanchichishqa, fyistata ruranambaq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Chayta yach'ashpaqam, chay kulaka churinqa ancha piñakushpa, manana munarqanchu yaykuyta. Chaymi taytanqa lluqshishpa, ancha rrugarqan yaykunambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Piru payqam piñakushpa, taytanda kayshina nirqan: “Noqaqam ancha achka watakunata kaypi sirbiyki, tukuy imapi kasushushpa. Piru chayshina allita sirbishuptiypismi, mana nunka ni suq chibituta qowashqachu kangi, kumpañiruykunawan fyistata rurashpa kushikunaypaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Piru rikay, chay churiki partin qoshqaykita bandulira warmikunawan limpu ushyashpa kutimuptinqam, paypaqqa chay mas gurdu mishiruta wanchichishqa kangi”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Chaymi taytanqa nirqan: “Ijitu, qamqam tukuy tyimpu pullay kangi. Chaymi tukuy imaykunaqa qamba. ");
INSERT INTO qvcNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Piru kananqam ancha alli, kay fyistata rurashpa kushikunanchiq. Chaqa kay masaykiqam wañushqashina kashqanmanda, kananqa kutimushqana. Chingashqa kashqanmandam, tarishqana kanchiq”, nishpa. Nuta: Chayshinam Dyus ancha kushikun, suq uchayuq runa uchangunata dijaptin. Piru chay farisiyukunam chay kulaka churishina mana munarqanllapachu ch'ayachiyta chay uchakunata dijaqkunataqa.  ");
INSERT INTO qvcNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisusqam yach'akuqningunata kay kumparasyunda rurashpa nirqan: —Suq kapuq runam suq impliyadumbi ancha yuyakushpa numbrarqan, payna tukuy imanda randinambaq randikunambaq. Piru suq diyam wakin runakuna yach'arqan chay impliyadupaq: Patrunnimba kusasningunata, qellaynindam yanqakunapi gastaykan, nishpa. Chaymi chay patrunnindaqa chayshina rurashqambaq willarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Chaymi chay patrunqa chay impliyadundaqa qayashpa, nirqan: “Qambaqmi yach'ani. ¿Imatam rurashqa kangi? Mayá, chay kusasniykunapaq, qellayniypaq kwintata qoway. Mananam ringichu trabajaq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Chaymi chay impliyaduqa yuyarqan: “Patrunniy trabajuymanda qatiwaptinqa, ¿imanashaqraq? Chaqa ch'akrapi trabajanaypaqqam mana balinichu. Limush'nata mañakunaypaqqam penqakuni”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Chaymandaqam yuyarqan: “¡A, ya yach'aninam! Kaypiraq kashpa, suqkunata yanapashaq, mana trabajuyuq kaptiy, paykunana wasinman tandawanambaq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Chaymi chayshina yuyashpaqa, patrunninda dibiraqkunata, suqninda suqninda qayachishpa, tapurqan: “¿Aykatataq dibirangi patrunniytaqa?” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Chaymi suq dibirakuqqa nirqan: “100 barril asiytitam dibirani”, nishpa. Chaymi chay impliyaduqa chay runata nirqan: “Kaypim kay tratukushqayki dukumintu. Tiyashpa, das suq mushuq dukumintuta ruray, 50 barriltallana dibiranayki”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Chaymandaqam suq dibirakuqtapis tapurqan: “¿Qamqa, aykatataq dibirangi?” nishpa. Chaymi chay dibirakuqqa nirqan: “100 midida trigutam dibirani”, nishpa. Nuta: Kada mididach'i ch'usku kintal triguta piskaq.  Chaymi chay kriyaduqa paytapis nirqan: “Kaypi kay tratukushqayki dukumintu. Suq dukumintuta das allichay, 80 mididatallana dibiranayki”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Chaymi patrunninqa chayta yach'ashpa, chay malu impliyadumbaqqa nirqan: “Ay, chay impliyaduyqam ancha yach'ayniyuq kashqa, chayta ruranambaqqa”, nishpa. Chaymandaqam Jisusqa nirqan: —Kay mundupa kusasningunapi yuyakuqkunaqam Dyuspi yuyakuqkunamanda mas yach'ayniyuqkuna. Chaqa paykunapuram masta yanapanakunllapa qellayninwan. ");
INSERT INTO qvcNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Chaymi noqaqa kayshina niykillapa, kay mundupi imayki kaqwan suqkunata yanapay, yanasuyuq (yanasayuq) kanaykillapa. Chaymandaqam chay imaykillapaqa rin ushyakaq. Piru syilupiqam chay achka yanapashqaykikuna kushikushpa, shumaqta rinllapa ch'ayachishuq. ");
INSERT INTO qvcNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Chaqa mayqan ashlitata allita kwidaqqam, achkatapis allita rin kwidaq. Piru mayqan ashlitata mana allita kwidaqqam mas achkatapis mana allitachu rin kwidaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Chayshinam kay mundupa kusasningunata mana allikunapi qamkuna gastaptikiqa, Dyusqa mana rinchu qoshuqllapa chay mana ushyakaq imangunataqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kanan kay pachapi suqpa imangunata mana allita kwidaptikillapaqam, Taytanchiq Dyusqa mana qoshunqallapachu partikitaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Manam pipis atinchu ishkay patrundaqa kasuyta. Chaqa suq patrunnindam masta rin ch'iqniq; suqtaqam masta rin kuyaq. Ichu suqtalla ancha rin kasuq, suqtaqa mana. Chayshinallam mana atingillapachu Dyusta, qellayta pullata kuyaytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Chay farisiyu duktrinayuqkunaqam qellayta ancha munarqanllapa. Chaymi Jisus nishqanda uyashpaqa, ancha asiparqanllapa. Chaymi Jisusqa paykunata nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","—Qamkunaqam runakuna alabashunambaq, allin runa layapaq tukungillapa. Piru Tayta Dyusqam qamkunapa shunqoykitaqa allita riqsin: Qellaytallam munanllapa, nishpa. Chaymi Dyusqa qamkuna rurashqaykita millanashpa ch'iqnin. ");
INSERT INTO qvcNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Jisusmi kayshinapis nirqan: —Muysispa liyningunata, Dyuspaq rimaqkuna iskibrishqandapismi yach'akurqaykillapa Jwan Shutichikuq shamushqan tyimpukaman. Chay shamushqan tyimpumandapacham Dyuspa shumaq nutisyanda yach'achikuykani. Chaymi ancha achka munanllapa imashinapis syiluman yaykuyta. ");
INSERT INTO qvcNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Piru Muysispa liyningunaqam kanangaman ancha balin. Chaymi syiluwan kay pacha chingaptimbis, chay liykunaqa mana ni ashlita rinchu chingaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Dyuspaqqam mana balinchu suq runa akrakanambaq warminmandaqa. Chaymi suq runa warminmanda akrakashpa, suqta tandashpaqam, uchayuqna kidan. Chayshinallam chay warmi dijashqata mayqan tandaqpis uchayuqna. ");
INSERT INTO qvcNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Suq runam ancha kapuq karqan. Chaymi ancha shumaq ch'aniyuq mudanayuq puriq. Kanan tukuy diyam ancha allingunatalla mikuq. ");
INSERT INTO qvcNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Karqambismi suq pubri limush'niritu. Paymi Lasaru shutiq. Kanan ishqoyaykaq kwirpuyuqmi karqan. Chaymi usuraykarqan chay kapuqpa pungumbi. ");
INSERT INTO qvcNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Kanan chay Lasaruqam ancha munarqan chay kapuqpa mesanmanda ishkiq mikunata mikuyta undanambaq. Kanan allqokuna shamushpam, chay ishqoyninda lambiykarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Chaymandaqam chay pubri limush'nirituqa wañurqanna. Chaymi Dyuspa anjilninguna ispiritunda aparqan syiluman, Abrajamba ispiritunwan tiyanambaq. Chaymandaqam chay kapuqpis wañurqanna. Wañuptinqam paytapis pambarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Piru chay kapuqqam wañushqakunapa lugarninman rishpa, ancha padisirqan. Chaymi chayshina padisiykashpaqa, karumanda rikarqan Lasaruta, Abrajamba ladumbi tiyaykaqta. ");
INSERT INTO qvcNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Chaymi payqa jwirtita qayakushpa, nirqan: “Taytitu Abrajan, llakipawashpa, kamachiy chay Lasaruta, shamunambaq didumba puntanda yakitupi nuyuchishpa, qallituyta chirichinambaq. ¡Chaqa kay ninapim ancha padisiykani!” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abrajanqam nirqan: “Ijitu, yuyayri chay unay bidaykipi tukuy imayuq kashqaykita. Piru Lasaruqam tukuy imapi padisirqan. Kananqam payqa kaypi ancha kushikushpana tiyaykan. Piru qamqam padisiykangina. ");
INSERT INTO qvcNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Suq ancha jundu kibradam qamkunata noqaykunamanda akrawanchiq. Chaymi mana pipis atinchu kay chimbamanda chay chimbamanqa pasayta. Chay chimbamandapismi mana pipis atinchu kaymanqa pasamuyta”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Chaymi chay kapuq runaqa ancha rrugashpa nirqan: “Taytitu Abrajan, yush'ayku Lasaruta kach'ay aylluykunaman, ");
INSERT INTO qvcNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","chay sinku masaykunata willanambaq, ama kay kastiguman shamunanllapa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Chaymi Abrajanqa nirqan: “Masaykikunam atin liyiyta Muysis iskibrishqanda, Dyuspaq rimaqkuna iskibrishqandapis. Chaykunata liyishpa, kasunqallapa, washadu kananllapa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Chaymandaqam chay kapuqqa nirqan: “¡Taytitu, chaykunataqam mana rinllapachu kasuq! Piru suq alma kawsamushpa, paykunaman rikakuptinqam, kriyishpa, uchanllapata rinllapa dijaq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Piru Abrajanqam nirqan: “Paykuna mana kasushpa Muysis nishqanda, Dyuspaq rimaqkuna nishqandaqam, mana rinllapachu kasuq wañushqanmanda kawsamuqtapis”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisusmi kayshinapis yach'akuqningunata nirqan: —Ancha trabajusmi rin kaq, shumaqta kawsanaykillapa. Chaqa suqkunam rinllapa animachishuq, uchata ruranaykillapa. Piru paykunaqam ancha kastigadu rin kaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Chayri chay uchata rurachiqpaqqa mas alli kanman kungambi suq atun mulinu rumita watashpa, mar yakuman wichukunanllapa, ch'uqashpa wañunambaq, amaraq kay wambrituykunata uchata rurachiptin. ");
INSERT INTO qvcNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Chayri qamkuna kikiki kwidakayllapa, ama ni pitapis animachinayki uchata ruranambaq. Ashwanri kriyiq masiki mana allita rurashuptinqa, anyay, amana mas uchata ruranambaq. Piru uchangunata dijashpa, pirdunda mañashuptinqa, pirdunay. ");
INSERT INTO qvcNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Suq diyapi syiti bwiltasta mana allita rurashushpa, chaymanda chay syiti bwiltasta syintishpa, pirdunda mañashuptinqa, pirdunay, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yumbay chayta uyashpaqam, Jisuspa apustulningunaqa nirqan: —Yanapawayllapa, qambi mas allita yuyakunaypaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Chaymi Jisusqa paykunata nirqan: —Ashlitata noqapi kriyishpaqach'i, tukuy imata atingimanllapa rurayta. Chaqa kay ancha atun yura sikamuruta qamkuna kamachiptiki: “Pilakashpa, riy mar yakuman plantakaq”, niptikiqa, kasushushpa, allipta chayshina rin ruraq. ");
INSERT INTO qvcNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","—Amar palanganuqa kayllapachu. Ashwanri yuyayllapa: Dyuspaqqam mana baliq randishqa kriyadushinalla kani, nishpa. Mayá, yuyashunllapa: Suqniki kriyaduyuq kashpa, chay kriyaduyki yapukushpa, michikushpa, wasikiman ch'ayaptinqachuraq, ¿ningiman: “Pasashpa mesaman tiyay mikunayki”, nishpa? ");
INSERT INTO qvcNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Manam chayshinaqa ningimanchu. Ashwanmi kamachingiman: “Utqa yanukushpa, mandilnikita rurakushpa, mirindachiway. Chaymandaqa noqa mikuptiy upyaptiyraqmi, qambis atingi mikuyta, upyaytaqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Akasuchu qamkunaqa chay randishqa kriyaduykita chay ima kamachishqaykita ruraptinqa, “Dyusilupagi” ningimanllapa? Manám. ");
INSERT INTO qvcNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Chayshinallar qamkunapis Dyus kamachishushqanda rurashpa, yuyayllapa: “Mana baliq randishqa kriyadushinam kanchiqllapa. Chaqa Dyus niwashqanchiqtallam rurashqa kanchiq. Manam yuyashqachu kanchiq, masta rurananchiqpaqqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jisusmi Jirusalinman riqshinaqa, prubinsya Galiliyapa, prubinsya Samaryapa lindirunda pasaykarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Suq kasiriyuman ch'ayaykaptinqam, dyis ismuykaq kwirpuyuq runakuna shamurqan tinguq. Yaqqana tingushpaqam, karupilla shayashpa, ");
INSERT INTO qvcNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ancha jwirtita nirqanllapa: —¡Yach'achikuq Jisus, yush'ayku noqaykunatar llakipaway! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Chaymi Jisusqa paykunata rikashpa, nirqan: —Mayá, riyllapa kurakunaman, paykuna rikashushpa: “Kach'akashqanam kangi”, ninambaq. Chaymi chay runakunaqa kurakunaman riqshinaqa, limpu kach'akarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Chaymi suqninqa rikashpa: Kach'akashqanam kani, nishpaqa, Taytanchiq Dyusta ancha alabashpa, Jisusmanna kutirqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Chaymi Jisusman ch'ayashpaqa, ñawpambi qonqorikushpa, pachakaman qaqllanda ch'ayachishpa, ancha pagikurqan. Chay runaqam prubinsya Samaryamanda karqan. (Chay samaryanukunam isrraylinukunawan ancha ch'iqninakuqllapa.) ");
INSERT INTO qvcNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Chaymi Jisusqa nirqan: —Chay fiyu qeshyaymanda kach'akaqkunaqa ¿manachu dyis runakuna karqan? ¿Maypinataq chay nwibiqa? ");
INSERT INTO qvcNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Ima, kay furastirullachu kutimushqa, Dyusta alabanambaqqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Chaymandaqam Jisusqa chay runata nirqan: —Atarishpana riy. Noqapi yuyakushpam, kach'akashqana kangi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farisiyukunaqam Jisusta tapurqan: —¿Ima tyimputaq Dyusqa rin shamuq kamachikuqqa? nishpa. Chaymi Jisusqa paykunata nirqan: —Dyus runakunapa shunqombi kamachikuptinqam, mana ringillapachu atiq rikayta. ");
INSERT INTO qvcNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Manam pipis rinchu niq: “Kaypim, waq maypim Dyusqa kamachikuykan”, nishpaqa. Chaqa Dyusqam paypi yuyakuqkunapa shunqombi kamachikuykan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Chaymandaqam Jisusqa yach'akuqningunata nirqan: —Suq diyakunam ancha ringillapa munaq rikawayta. Piru manaraqmi ringillapachu rikawaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Chay diyakunapiqam wakingunaqa rinllapa nishuq: “¡Kaypinam Jisukristuqa!” ichu rin nishuqllapa: “¡Waqpim payqa!” nishpa. Piru chayshina nishuptinllapapis, ama kriyiyllapachu ni paykunawan riyllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Chaqa noqa Dyusmanda Shamuq Runam llipyaq rrilampagushina rini kutimuq. Manchu rrilampaguqa tukuy syilupi lliwyan kay ladumanda suq ladukaman. Chayshinallam noqa Dyusmanda Shamuq Runapis yumbay ladukunapi lliwyashpa, rini kutimuq. ");
INSERT INTO qvcNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Piru puntatam ancha rini padisiq. Chaqa kay tyimpupi runakunaqam mana baliqpaq rinllapa riqsiwaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","’Nuwipa tyimpumbi kawsaqkunashinam, noqa kutimunay tyimpupipis rinllapa kawsaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Chaqa chay Nuwipa tyimpumbiqam mikuykarqanllapa, upyaykarqanllapa. Wakinqam kasaraykarqan. ˻Wakinqam chinangunata kasarachiykarqan˼ chay Nuwi wambuq wasinman yaykunan diyakaman. Chaymandaqam ancha jwirtita tamyarqan. Chaymi runakuna warmikunaqa ch'uqashpa, limpu wañurqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Chay Lutpa tyimpumbi pasashqanshinam rin kaq. Chaqa chay tyimpupiqam runakunaqa mikuykarqan, upyaykarqan, tukuy imata randiykarqan, randikuykarqan, tarpukuykarqan, wasikuykarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Piru chay Sudumamanda Lut lluqshishqan diyaqam syilumanda ninakuna asufriwan ishkimushpa, chay runakunata, warmikunata limpu wanchirqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Chayshinallam rin kaq, noqa Dyusmanda Shamuq Runa syilumanda kutimuptiypis. ");
INSERT INTO qvcNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Chayri chay diyapiqa mayqan wasimba sawambi kaqqa amana yaykunqachu, imangunata surqonambaqqa. Chayshinallar ch'akrambi kaqkunapis amana wasinmanqa kutinqachu. ");
INSERT INTO qvcNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lutpa warminda pasashqandar yuyayllapa. Nuta: Chaqa payqam Sudumamanda kallpaykashpa, ikiman tikrakashpa, chapakurqan. Chaymi chaypilla das wañurqan. Liyiy Génesis 19.26ta  ");
INSERT INTO qvcNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Chayshinam mayqanniki noqata ñigawashpa bidaykita washanaykipaqqa, ringi chingaq tukuy tyimpupaq. Piru noqapi kriyishqaykirayku wanchishuptinllapam, noqa rini washashuq, tukuy tyimpu noqawan kawsanaykipaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Alliptam niykillapa, chay tyimpupi suq kamapilla ishkay puñuykaptinqam, Tayta Dyusqa suqta rin apaq, suqta rin dijaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Chayshinam ishkay warmikuna pulla kutakuykaptinqa, suqta rin apaq, suqta rin dijaq. ˻ ");
INSERT INTO qvcNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ishkay runa ch'akrambi kaykaptimbismi, suqta rin apaq, suqta rin dijaq.˼ ");
INSERT INTO qvcNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Chayshina niptinqam, chay yach'akuqningunaqa tapurqanllapa: —Taytitu, ¿maypitaq kay nishqaykiqa rin kaq? nishpa. Chaymi Jisusqa nirqan: —Suq wañushqa kaptinqam, chaypi shingukuna shutilla tandakashpa muyuykan, ¿manachu? (Chayshinallam chay tyimpupipis tukuy ima pasashqanda rikashpalla, das ringillapa yach'aq: Waqpim, nishpa.) ");
INSERT INTO qvcNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jisusmi suq kumparasyunda rurarqan, ama disanimakashpachu, Dyusman mañakunanllapa. Chaymi nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","—Suq llaqtapim karqan suq juyis. Chay juyismi mana rrispitaqchu ni Dyusta ni runa masingunata. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Chay llaqtapiqam suq biyudapis karqan. Payqam chay juyisman rishpa, suq dimandata rurarqan kuntrambaq. Chaymi kutin kutin juyisman rishpa nirqan: “Siñur juyis, kuntrawaqwan allin justisyata ruraway”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Piru chay juyisqam achka tyimputa chay biyudataqa mana kasurqanchu. Chaymandaqam kayshina yuyarqan: “Manam rrispitanichu ni Dyusta ni runa masiykunatapis. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Piru kay biyudaqam kutin kutin shamun piñachiwaq, dimandanda allichanaypaq. Chaymi yanapashpa allichashaq. Chaqa achka bwiltasta shamushpaqach'i, mana dijawanqachu samanaypaq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Chayshina nishpaqam, Jisusqa paykunata nirqan: —Allita yuyayllapa chay malu juyis nishqambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Piru Taytanchiq Dyusqam ancha allin. Chaymi mana unayashpachu, akrashqangunata dasna rin washaq, payman punchawnindin, tutapnindin mañakuptinllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Chaqa Dyusqam chay akrashqangunata das rin washaq. Piru noqa Dyusmanda Shamuq Runa kay pachaman kutimuptiyqam, ¿kanqachuraq noqapi yuyakuqkuna ichu mana? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Wakingunaqam yuyarqan: Noqam chay suqkunamanda Dyusta mas allita kasuni. Chaymi paykunaqa mana balinllapachu, nishpa. Chayraykum Jisusqa kay kumparasyunda rurarqan: ");
INSERT INTO qvcNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Ishkay runakunam rirqanllapa Dyuspa adurana wasinman, chaypi Dyusman mañakunanllapa. Suqqam farisiyu duktrinayuq karqan. Suqqam kuntribusyunda kubrakuq karqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Chay farisiyuqam shayashpa, nirqan: “Dyusitu, dyusilupagiri; manam chay uchayuq runakunashinachu kani. Chaqa wakingunaqam suwakunllapa, ichu rrispituyuq kashpapis, suqwan puñunllapa, ichu suq laya mana allikunata ruranllapa. Piru noqaqam mana paykunashinachu kani, ni kay runa kuntribusyunda kubrakuqshinachu kani. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Kanan kada simanam ishkay diyata ayunani. Tukuy ima ganashqaymandam dyismuyta qoyki”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","’Piru chay kuntribusyunda kubrakuqqam mana ni alli qemikashpachu, ni syiluman chapakushpachu, ashwan pichunda takashpa nirqan: “Dyusitu, llakipawayri. Chaqa noqaqam ancha uchayuq kani”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","’Chaymi noqaqa niykillapa, chay kuntribusyunda kubrakuqqam uchangunamanda pirdunaduna, kutirqan wasinmanqa. Piru Tayta Dyusmi chay farisiyutaqa mana pirdunarqanchu. Chaqa Dyusqam chay palanganutaqa ultimupi rin ruraq penqakunambaq. Piru chay umildi kaqkunataqam ancha kamachikuqpaq rin ruraq. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Wambritukunatam apamurqanllapa Jisusman, sawanllapapi makinda rurashpa, Dyusman mañakunambaq. Piru yach'akuqninguna chayta rikashpa, anyarqanllapa chay wambritukuna apamuqkunata (Jisusta ama piñachinanllapa). ");
INSERT INTO qvcNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Piru Jisusqa chay wambritukunata qayashpa, yach'akuqningunata nirqan: —Ama arkayllapachu. Dijayllapa chay wambritukunata, noqaman shamunambaq. Chaqa Tayta Dyus shumaqta kamachikuptinqam, kay wambritushina kaqkuna paywan rinllapa kawsaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Alliptam niykillapa, kay umildi wambritushina kaqkunallam Dyusta kasushpa, rin kawsaq paywanqa. Piru palanganukunaqam mana Dyuswan rinllapachu kawsaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Suq kamachikuq runam Jisusta kayshina tapurqan: —Allin yach'achikuq Taytitu, ¿imatam atini rurayta, Dyuswan tukuy tyimpu kawsanaypaqqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Chaymi Jisusqa nirqan: —¿Imaraykutaq niwangi: “Allin” nishpaqa? Tayta Dyusllam allinqa. Manam masqa kanchu. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Qamqam yach'angi Dyuspa Santu Librumbi kamachikushqambaq: “Warmiyuq kashpaqa, ama suq warmiwanqa puñuychu. Ama wanchikuychu. Ama suwakuychu. Ama yanqaqa pipaqpis llullakuychu. Taytaykita, mamaykita rrispitay”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Chayshina Jisus niptinqam, chay runaqa nirqan: —Tukuy kaykunatam wambraymandapacha kasushqa kani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Chayta uyashpaqam, Jisusqa nirqan: —Kaysitullam faltashungi ruranaykipaqqa. Tukuy ima kaqnikita randikushpa, chay mana nimayuqkunata qoy. Chayshina qoshpaqam, syilupi tukuy imayuq ringi kaq. Chaymandaqam shamuy, noqawan purinayki, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Chayta niptinqam, chay runaqa limpu malaganayarqan, ancha kapuq kashqanrayku. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Chaymi Jisusqa, ancha malaganayaqta rikashpaqa nirqan: —Ancha trabajusraq, kapuq runakuna Dyusta kasunanllapa, paywan kawsananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ancha trabajusraq kanman, chay atun animal kamillu awjap rinrinda pasanambaq. Piru mas trabajusmi kanman, suq kapuq runa Dyuswan kawsanambaqqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Chaymi chayta niptinqa, chay uyaqkunaqa tapurqan: —Chayshina kaptinqa, ¿pitaq atinman washakayta? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Chaymi paykunataqa nirqan: —Runakunallaqam mana nimatapis atinmanllapachu washakayta. Piru Taytanchiq Dyusmi atin washaytaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Chaymandaqam Pidruqa nirqan: —Taytitu, noqaykunaqam tukuy imayllapata dijashqallapana kani, qamwanna purinaypaqllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Chaymi Jisusqa nirqan: —Alliptam niykillapa, mayqan runa dijaq wasinda, taytanda, mamanda, masangunata, warminda, wambrangunata, Dyusta kasunambaq, ");
INSERT INTO qvcNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","chay dijashqambaq mas achkata rin ch'askiq kay mundupiqa. Piru manam chaytallachu rin ch'askiqqa. Ashwanmi syilupi tukuy tyimpu rin kawsaq Dyuswan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jisusmi yach'akuqningunatalla suq laduman apashpa, nirqan: —Kananqam anaq Jirusalinmanna rinchiq riq. Chaqa Dyuspaq rimaqkuna noqapaq yumbay nishqangunaqam Jirusalimbi rin kumpliq. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Chaypiqam furastiru runakunamanna rinllapa intrigakuwaq. Kanan mana baliqkunata niwashpam, rinllapa asipawaq. Suq lastima rurawashpam, rinllapa tuqapawaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Asutiwashpam, rinllapa wanchiwaq. Piru kimsa diyamandam rini kawsamuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Piru chayshina Jisus niptinqam, chay yach'akuqningunaqa mana intyindirqanchu: ¿Imapaqraq chayshinaqa nirqan? nishpa. Chaqa yuyayninllapa tutayaqpishina karqan. Chaymi mana atirqanllapachu intyindiyta. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jisus ch'ayaykaptinna Jiriku llaqtamanmi, suq sarku runa ñambi tiyashpa, limush'nata mañakuykarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Chaymi ancha achka runakuna chayta pasaykaqta uyashpaqa, tapurqan: —¿Imataq kashqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Chaymi paytaqa nirqanllapa: —Jisus Nasaritmanda kaqmi kayta pasaykan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Chaymi payqa ancha jwirtita qayakurqan: —¡Unay Dabidpa Karu Willkan Jisus, llakipawayri! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Chaymi Jisuspa ñawpanda riqkunaqa chay sarkutaqa anyarqanllapa uyaranambaq. Piru payqam ashwamba mas jwirtita qayakurqan: —¡Unay Dabidpa Karu Willkan, llakipawayri! nishpa. Nuta: “Unay Dabidpa Karu Willkanmi” munan niyta: “Dyus Akrashqan Washadur”, nishpa.  ");
INSERT INTO qvcNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Chaymi Jisusqa riykashqanmanda shayashpa, kamachirqan: —Riyllapa apamuy waq runata, nishpa. Ch'ayachiptinqam, Jisusqa tapurqan: ");
INSERT INTO qvcNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Imatam munangi ruranaypaq qambaqqa? nishpa. Chaymi chay runaqa nirqan: —Taytitu, munanim ñawiykunata kach'akachinayki chapakunaypaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Chaymi Jisusqa nirqan: —Noqapi allita kriyishqaykiraykum niyki, chapakuy, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Chayta niptinllam, chay runaqa chay uras atirqanna rikakuyta. Chaymi Tayta Dyusta ancha alabashpa, Jisuspa ikindana rirqan. Kanan yumbay rikaqkunapismi Taytanchiq Dyusta ancha alabarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisusmi Jiriku llaqtapa ch'awpinda pasaykarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Chay llaqtapim karqan suq ancha kapuq runa Sakiyu shutiq. Payqam kuntribusyunda kubrakuqkunapa kamachikuqnin karqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Chay Sakiyum ancha munarqan Jisusta rikayta. Lukismi ancha achka runa kaptin, takshita kashqanrayku, mana atirqanchu rikaytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Chaymi payqa Jisuspa ñawpanda kallpashpa, suq yura sikamuru shutiqman lluqshirqan, chayta pasaykaptin, rikanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Chayshina chay muntipi kaykaptinqam, Jisusqa chayta pasaqshina anaqman chapakushpa, paytaqa rikarqan. Chaymi Jisusqa nirqan: —Sakiyu, utqa ishkimuy, wasikipi pusadata qowanayki. Chaqa Taytay Dyusmi munan, qamwan kidanaypaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Chaymi Sakiyuqa utqaymaya ishkimushpa, kushikushpa aparqan wasinman. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Chayshina apaptinqam, yumbay chay rikaqkunaqa kayshina ancha rimatikurqanllapa: —Suq uchayuq runapa wasinmanmi Jisusqa rin kidaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kanan Sakiyuqam shayashpa, Jisusta nirqan: —Taytitu, tukuy imay kaqkunatam midya partita rini qoq chay mana nimayuqkunata. Mayqanda ingañashpa, imanda qoch'ishqa kashpapismi, ch'usku tantuta rini kutichiq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Chayshina niptinqam, Jisusqa nirqan: —Kananqam Tayta Dyusqa kay Sakiyuta wasimbi tiyaqkunata washashqana, chay unay Abrajanshina kriyishqanllaparayku. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Chaqa noqa Dyusmanda Shamuq Runaqam shamushqa kani chay chingashqa kaqkunata maskashpa, washanaypaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jisusta chay uyaykaqkunaqam yuyarqanllapa: Jisusqam Jirusalinman ch'ayaykanna. Chaymi dasna rinchiq rikaq paytaqa, shumaqta kamachiwaptinchiq, nishpa. Chaymi Jisusqa kay kumparasyunda rurashpa nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","—Suq kamachikuq runam suq karu kamachikuq nasyunman rirqan gubyirnupaq numbrananllapa, kutimushpa nasyunninman, chaypi gubyirnun kanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Piru manaraq rishpaqam, dyis kriyadungunata qayashpa, kadunuta qorqan suq qellay ancha baliqta. Chaymandaqam paykunata nirqan: “Kutimunaykaman kay qellayniyta trabajachiyllapa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Piru llaqta masingunam ch'iqnirqan paytaqa. Chaymi wakin runakunata ikinda kach'arqanllapa chay karu nasyunman, paypa kuntran kayshina rimanambaq: “Noqaykunaqam mana munanillapachu chay runa gubyirnuy kanambaqqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","’Piru chay kamachikuq runaqam kargunda ch'askirqan. Chaymanda kutimushpaqam, chay dyis kriyadun qellaynin qoshqandaqa qayachirqan tapunambaq: “¿Aykatam qellayniyta ganachishqallapa kangi?” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Chaymi chay punta kriyadunqa shamushpa nirqan: “Taytitu, kay qellaynikitaqam dyis tantus masta ganachishqa kani”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Chaymi chay kamachikuqninqa kriyadunda nirqan: “Ancha allin kriyaduymi kangi. Kay ashla qellayniyta allita trabajachiptikim, rini numbrashuq, dyis llaqtakunapa kamachikuqnin kanaykipaq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Chaymandaqam suqpis shamushpa nirqan: “Taytitu, qellaynikitaqam ganachishqa kani sinku tantus masta”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Chaymi chay patrunninqa paytapis nirqan: “Qamqam sinku llaqtakunapa kamachikuqnin ringi kaq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","’Chaymandaqam suqpis shamushpa nirqan: “Taytitu, kaypim qellayniki. Suq pañuypi qepishpam waqaychashqa kani. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Chaqa ancha wapu kashpam, suqkuna waqaychashqanda qamna tandangi. Suqkuna tarpukushqandam qamna kusichangi. Chaymi ancha manchashurqaq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Chayshina chay kriyadun niptinmi, chay patrunninqa kayshina nirqan: “Qamqam ancha malu kangi. Chay kikin shimikillam kundinashungi: ‘Uchayuqmi kangi’ nishpa. Qami niwaykangi wapu kashpa, suqkuna waqaychashqanda tandashqayta, suqkuna tarpukushqanda kusichashqayta. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Chayshina noqapaq yach'ashpaqa, ¿imaraykutaq chay qellayniytaqa mana rurarqaykichu bankuman, kutimushpaqa wach'ayniyuqta surqonayta?” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","’Chayshina nishpaqam, chaypi kaqkunata kamachirqan: “Chay malu kriyaduyta qellayta qoch'ishpa, chay dyis qellayniyuqta qoyllapa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Chaymi paykunaqa nirqanllapa: “Taytitu, piru chay suq kriyaduykiqam dyis qellayniyuqna. ¿Imapaqnamiri qellayniyuq kaqtaqa masta qoshaqllapa?” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Piru patrunninqam nirqan: “Uyawayllapa, yumbay chay imayuqkunam masta rinllapa ch'askiq. Chay mana nimayuqqam chay ashlita kaqninda rin pyirdiq (mana allita trabajachishqanrayku). ");
INSERT INTO qvcNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Waq kuntraykunapismi mana munanllapachu kamachikuqnin kanaypaqqa. Chayri paykunata kay ñawpayman apamushpa, wanchiyllapa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Chaykunata yach'achikushpaqam, Jisusqa ñawpanllapata anaq Jirusalinmanna rirqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Chaymi riqshinaqa, yaqqana ch'ayashpa Bitfaji llaqtaman, Bitanilla (Bitaniya) llaqtaman, chay Ulibu lumapa sirkambi kashpaqa, ishkay yach'akuqninda nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Riyllapa waq chimba kasiriyuman. Waqman ch'ayashpaqam, ringillapa tariq suq burritu watashqata. Chay burritupiqam manaraq ni pipis purishqachu. Chayta paskashpa, apamuyllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Piru mayqan nishuptinllapa: “¿Imapaqmi paskangillapa?” nishpaqa, niyllapa: “Siñurninchiqmi nisitan kay burrituta”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Chayshina kamachiptinqam, chay yach'akuqninguna rishpa, Jisus nishqanshina burritutaqa tarirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Chaymi apamunanllapa paskaykaptinqa, dwiñungunaqa tarishpa tapurqan: —¿Imapaqmi burrituyta paskaykangillapa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Chaymi paykunaqa nirqan: —Siñurninchiqmi nisitan. Chaymi apanillapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Chayshina dwiñunda nishpam, burritutaqa apamurqanllapa Jisusman. Chaymandaqam chay burritupa sawanman kapangunata rurashpa, Jisusta muntachirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Chaymandaqam yumbay paykunaqa Jisuspa ñawpanda rirqanllapa, kapangunata ñambi mandashpa, chay burritu sawanda rinambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Kanan Jisuspi kriyiqkunam ancha achka paypa pullan riykarqanllapa. Chaymi paykunaqa chay Ulibu lumapa bajadanman ch'ayaykashpaqa, ancha kushikushpa, ancha jwirtita kunyarqanllapa. Kanan paykunaqa yumbay chay milagrukunata rikashqanraykum, Dyusta ancha alabarqanllapa: ");
INSERT INTO qvcNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","—¡Biba biba! ¡Tayta Dyus ancha yanapanqa kay gubyirnunchiqta, paypa rrimplasun shamuykaqta! ¡Anaq syilupipisri ancha kushikushpa, Taytanchiq Dyusta alabanqallapa! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Chayshina Jisusta ancha alabaptinllapam, wakin farisiyu duktrinayuqkunaqa nirqan: —Yach'achikuq Taytitu, kay yach'akuqnikikunataqa anyashpa uyarachiy, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Chaymi Jisusqa nirqan: —Kay runakuna uyaraptinqach'i, rumikunana rinllapa alabawaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Chayshina Jirusalinman yaqqana ch'ayaykashpaqam, Jisusqa chay atun llaqtata chapashpa, waqashpa, nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","—¡Ay Jirusalimbi tiyaqkuna! Ancha allich'i kanman kay diyapi noqapaq intyindinaykillapa, ¿pim Jisukristu? nishpa. Chaqa noqam shamushqa kani yanapashuq, shumaqta kawsanaykillapa. Piru chaytaqam mana atingillapachu intyindiytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Suq diyam ancha ringillapa padisiq. Chay diyaqam kuntraykikunaqa rin kurralashuqllapa, murallata rurashpa. Chayshina kurralashushpam, ancha rin maqashuqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Kanan wasikillapatam pamba pamba bulashpa, rinllapa wanchishuqllapa. Chaymi llaqtaykipiqa mana nima rumi pirqashqataqa rinllapachu dijaq. Chaqa shamuptiy washashuqmi, qamkunaqa disprisyawashqa kangillapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jisukristu Tayta Dyuspa adurana wasinman yaykushpaqam, tarirqan tukuy imata randikuykaqkunata, randiykaqkunata. Chaymi paykunataqa qatiqshina nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","—Taytanchiq Dyusmi Santu Librumbi nin: “Adurana wasiyqam noqaman mañakunanllapa”, nishpa. Piru qamkunaqam ladrungunapa mach'aynindashina rurashqallapa kangi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Chaymandaqam Jisusqa tukuy diyakuna Dyuspa adurana wasimbi yach'achikuq. Piru kamachikuq isrraylinu kurakuna, Muysispa liyningunata yach'achikuqkunaqam, chay llaqtapa awturidarningunawan kunanakurqanllapa, Jisusta wanchinanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Piru achka runakunam Jisustaqa ancha allita uyaykarqan. Chaymi chay kuntraqkunaqa chay uyaqkunata manchashpa, mana nimatapis atirqanllapachu rurayta Jisustaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Jisusmi suq diyam Dyuspa adurana wasimbi shumaq nutisyanda yach'achikuykarqan. Chayshina ruraykaptinmi, ch'ayamurqanllapa kamachikuq isrraylinu kurakuna, Muysispa liyningunata yach'achikuqkuna, kamachikuq ansyanukunapis. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Paykunaqam Jisusta tapurqanllapa: —Mayá, niwayllapa. ¿Ima karguyuqtaq kangi? ¿Pitaq numbrashushqa, awturidar kashpa, kaykunata ruranayki? ");
INSERT INTO qvcNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Chayshina tapuptinllapaqam, Jisusqa paykunata nirqan: —Puntata noqapis suq tapunata tapushqaykillapa. Mayá, niwayllapa: ");
INSERT INTO qvcNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jwan Shutichikuqtaqa ¿pitaq numbrarqan, runakunata shutichinanqa? ¿Dyuschu kamachirqan, ichu runakunalla? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Chaymi suqnin suqnin paykunapura parlarqanllapa: —Niptinchiq: “Dyusmi numbrarqan Jwandaqa”, nishpaqach'i, niwashun: “Chayshina kaptinqa, qamkunaqa ¿imaraykutaq mana kriyirqaykichu paytaqa?” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Piru niptinchiq: “Runakunallam paytaqa kamachirqan”, nishpaqach'i, yumbay kay runakuna rumikunawan sitawaqninchiq wanchiwanchiqman. Chaqa paykunaqam ancha kriyinllapa: “Jwanqam Dyuspaq rimaq karqan”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Chaymi chayshina yuyashpaqa, Jisusta nirqanllapa: —Manam yach'anillapachu: Pim Jwandaqa kamachirqan shutichikunanqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Chayshina Jisusta niptinllapaqam, paypis nirqan: —Noqapismi mana nishqaykillapachu pi kamachiwaptinmi, kaykunata rurani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Chaymi Jisusqa suq kumparasyunda rurashpa, chay runakunata nirqan: —Suq runash ch'akrambi ubasta tarpushpa, partidaryukunata maskashpa, dijarqan chay tarpudunda rikanambaqllapa. Chaymandaqash payqa karuman rishpa, ancha unayarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Chayshi kusicha tyimpu ch'ayaptinqa, suq kriyadunda kach'arqan, chay partidaryunguna partinda qonambaq. Piru chay partidaryungunaqash chay kriyadundaqa mana nima ubasta qoshpachu, ashwan maqashpa, illaqtalla kach'arqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Chaymandaqash chay dwiñuqa suq kriyadunda kach'arirqan. Piru chay partidaryungunaqash chay kriyadutapis musyashpa, maqashpa, mana nimatapis qoshpachu, illaqtalla kach'arqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Chayshina ruraptinllapaqash, chay dwiñuqa suq kriyadundana kach'arirqan. Piru chay partidaryungunaqash chaytapis suq lastima chuqri chuqri maqashpa, qatirqan chay ch'akramanda. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Chaymandaqash chay wirta dwiñuqa nirqan: “¿Imatataq kananqa atini rurayta? Mayá, kay ancha kuyashqay churiyta kach'ashaq, partiyta apamunambaq. Paqta paytaqa shumaqta ch'ayachinqallapa”, nishpa. Chayshi chayshina nishpaqa, churindana kach'arqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Piru chay partidaryungunaqash seqamuqta rikashpaqa, kayshina parlarqanllapa: “Kay churinqam irinsyiru rin kaq. Chayri akullapa wanchiq, noqanchiqpaqna kay ch'akra kidanambaq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Chayshina parlashpaqash, chay ch'akramanda sawaman surqoshpa, chay dwiñupa churinda wanchirqanllapa. Chayshina nishpaqam, Jisusqa tapurqan: —Chay ch'akrapa dwiñun kutimushpaqa, ¿imataraq ruranqa chay partidaryungunataqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Chaymandaqam pay kikin nirqan: —Chay ch'akrapa dwiñun shamushpaqam, chay partidaryungunata rin wanchiq. Wanchishpaqam, suqkunatana ch'akrandaqa rin qoq trabajanambaq, nishpa. Nuta: Chay ch'akra dwiñuqam munan niyta Tayta Dyus. Chay malu partidaryukunaqam munan niyta isrraylinukunapa kamachikuqninguna.  Chayshina Jisus niptinqam, chay uyaqkunaqa nirqanllapa: —¡Amar chayshinaqa kanqachu! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Piru Jisusqam chay runakunata chapashpa nirqan: —Chayshina kanqa. Chaymi Dyuspa Santu Librumbi suq ancha baliq rumipaq kayshina nin: Albañilkuna wichukushqanllapa rumiqam kananqa simyintupa mas baliq rumin tikrakashqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Chaymi mayqan chay ancha baliq rumipa sawambi bulakaqqam piti piti rin kidaq; ichu chay rumi mayqamba sawan bulakashpaqa, limpu chankashpa, piti piti rin ruraq, nishpa. Nuta: Chay wichukushqa rumiqam Jisukristu. Chay piti piti ushyakaqqam paypi mana kriyiqkuna.  ");
INSERT INTO qvcNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Chay kamachikuq isrraylinu kurakuna, Muysispa liyningunata chay yach'achikuqkunawanmi intyindirqanllapa: Jisusqam chay kumparasyundaqa rurashqa, noqanchiqkunata kuntrawaqninchiq, nishpa. Chaymi chay uras munarqanllapa prisuyta Jisustaqa. Piru yumbay chay uyakuq runakunata manchashpam, mana pipis almitikarqanchu prisuytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Chaymi Jisusta kuntraqkunaqa ancha chaparqanllapa, paqta imapi imashina pandanman, nishpa. Chayshina yuyashpaqam, wakin runakunata pagarashpa nirqanllapa: —Jisusman rishpa, ancha allin kasuqkunashina tukushpa, allita uyay, imapi pandaptin, chaypaq tumbashpa, gubyirnupi dimandananchiq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Chaymi chay uyakuqkunaqa yanqa Jisusta nirqanllapa: —Yach'achikuq Taytitu, qamqam allip kaqtalla Dyuspaq yach'achikungi. Kanan qamqam mana ni pitapis sawachashpachu, allitalla rurangi. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Mayá, niwayllapa, ¿allichu Rrumapa gubyirnunda kuntribusyunda pagarananchiqllapa ichu mana? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Piru Jisusqam yach'arqan: Yanqam chayshinaqa tapuwaykanllapa prisuwananrayku, nishpa. Chaymi paykunataqa nirqan: —¿Imaraykutaq chayshinaqa tapuwangi? ");
INSERT INTO qvcNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Mayá, rikachiwayllapa suq qellayta. ¿Pipa rritratunda, shutindam rurashqallapa chay qellaypiqa? nishpa. Chaymi paykunaqa nirqanllapa: —Chay qellayqam mas kamachikuq gubyirnu Sesarpa rritratunwan, shutinwan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Chaymi Jisusqa paykunata nirqan: —Chayshina kaptinqa, chay mas kamachikuq gubyirnu Sesarpa kaqtaqa, payta qoyllapa. Dyuspa kaqtaqa, Dyusta qoyllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Chaymi chay uyakuqkunaqa, chay tapunakunawan tukuy runakunapa ñawpambi pandachiyta munashpaqa, mana nimatapis atirqanllapachu. Ashwanmi allita kuntistaptinqa, paykunaqa ancha ispantashqata, uyarapllana (uyarallana) kidarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Chaymandaqam wakin sadusiyu duktrinayuqkuna Jisus kaykashqanman ch'ayarqanllapa. Chay sadusiyukunaqam kriyinllapa: Wañushqakunaqam mana rinllapachu kawsamuq, nishpa. Chaymi Jisusta tapurqanllapa: ");
INSERT INTO qvcNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Yach'achikuq Taytitu, (unay tyimpupim) Muysisqa librumbi iskibrishpa, kamachikurqan, suq warmiyuq runa manaraq wambrayuq kashpa wañuptinqa, chay almapa masanna biyudawan kasaranqa, chay biyudapi wambrayuq kaptin, chay alma masamba wambran kanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Chaymi munanillapa tapushuyta: Suq ayllupish syiti ullqo masapura karqan. Chay syitimanda kulaka masanqash warmikurqanna. Piru manaraq wambrayuq kashpash wañurqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Chayshina wañuptinqash, chay almapa minur masanna biyudawanqa kasararqan. Paypisshi manaraq wambrayuq kashpa wañurqanna. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Chaymandaqash chay mas minur masanna biyudawanqa kasararqan. Paypisshi manaraq wambrayuq kashpa wañurqan. Chayshinash syitindin chay warmiwan kasararqanllapa. Piru manash ni mayqannimbis chay warmipiqa wambrakurqanchu. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Chaymandaqash warmipis wañurqanna. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Chayshina wañushqakuna allipta mushuqmanda kawsamuptinqach'i, ¿mayqannimba warminnaraqri kanman? Chaqa syitindimba warminshi kashqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","35","Chayshina tapuptinllapaqam, Jisusqa nirqan: —Manam ni mayqannimba warmin kanqachu. Chaqa syilupiqam manana ni warmiyuq ni runayuq rinchu kaq. Kay mundupillam runakunaqa churingunata kasarachin. Paykunapismi kasaranllapa. Piru Dyusta kasuqkuna mushuqmanda kawsamushpaqam, syilupiqa manana ni runayuqchu ni warmiyuqchu rinllapa kaq; ni chinangunata rinllapachu kasarachiq. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Chaqa kawsamushpaqam, syilupiqa Dyuspa wambrangunana kashpa, chay anjilningunashina manana nunka rinllapachu wañuq. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Arí, rinllapam kawsamuq. Chaqa kikin Muysismi yach'achikurqan: Wañuqkunam rin kawsamuq, nishpa. Payqam chay lumyaykaq sach'ata rikashpa, Dyus nishqanda kayshina uyarqan: “Kanangamanmi noqa Abrajamba, Isakpa, Jakubupa Dyusnin kani”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Chayshina Taytanchiq Dyus chay almakunapaq niptinmi, yach'anchiq: Chay almakunam Dyuspaq kawsaykanraq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Chayshina Jisus niptinqam, Muysispa liyningunata wakin yach'achikuqkunaqa nirqan: —Yach'achikuq Taytitu, ancha allitam nishqa kangi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Chaymi chay urasmandapacha manana pipis almitikarqanchu Jisusta tapuyta. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Chaymandaqam Jisusqa paykunatapis tapurqan: —Mayá, ¿pitaq Dyus Akrashqan Washadurqa? ¿Imaraykutaq chay Washadurpaqqa ningillapa: “Dabidpa karu willkanmi”, nishpaqa? ");
INSERT INTO qvcNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Chaqa kikin Dabidmi Salmus librumbi nin: Tayta Dyusmi Kamachikuqniyta nirqan: “Allin laduypi tiyay, ");
INSERT INTO qvcNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kuntrashuqkunata binsishpa, ch'akikipa waranman ruranaykaman (qamta kasushunanllapa)”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Chayshina chay Akrashqan Washadur chay Dabidpa karu willkan kaptinqa, ¿imaraykutaq kikin Dabid chay Washadurpaqqa nin: “Kamachikuqniy”, nishpaqa? Chayshinaqa ¿imashinataq Dabidpa karu willkanqa atin kayta, Kamachikuqnin niptinqa? ");
INSERT INTO qvcNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yumbay uyakuqkunapa ñawpambim Jisusqa yach'akuqningunata nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Allita uyawayllapa, ama Muysispa liyningunata yach'achikuqkunashinaqa kayllapachu. Chaqa paykunaqam ancha palanganu kashpa, gustanllapa rrastrakaykaq mudanangunata rurakuyta. Chaymandaqam plasakunaman rin, yumbay shumaqta napaykunanllapa. Kanan sinaguga wasikunaman rishpapismi, ancha gustanllapa ñawpaman pasashpa, kamachikuqkunapa tiyanangunapi tiyayta. Apaptinllapa mikuqpismi, ancha gustanllapa kamachikuqkunapa tiyanangunapi tiyayta. ");
INSERT INTO qvcNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Chayshina allingunapaq tukushpam, biyudakunapa wasingunata qoch'inllapa. Chaymandaqam ancha unayta Dyusman mañakunllapa, rikaqkuna ninambaq: “Paykunaqam Dyusta ancha aduranllapa”, nishpa. Chaymi mas kastigadu rinllapa kaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Dyuspa adurana wasimbim Jisus kapuqkunata rikarqan, ufrindanda kajungunaman wichuptinllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Chaypim rikarqambis suq ancha pubri biyudata, ishkay qellitay mana balurniyuqta wichuptin. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Chaymi Jisusqa nirqan: —Alliptam niykillapa, kay pubri biyudita qoshqanqam Dyuspaqqa ancha balin maski yumbay chay suqkuna qoshqanmanda. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Chaqa yumbaymi ufrindataqa qonllapa subraq qellayninda. Piru chay pubri biyuditaqam mikunanda randinambaq kaqta limpulla qorqan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Wakingunaqam Dyuspa adurana wasimbaq parlaykarqanllapa: —Rikay, ancha shumaqmi kay rumingunaqa. Kanan ancha shumaq rrigalukunatam qoshqallapa, shumaqyachinanllapa kay atun wasita, nishpa. Chaymi Jisusqa paykunata nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Suq diyam kay rikashqaykitaqa limpu rinllapa bulaq. Chay diyapiqam manana ni suq rumi patachaduqa rinchu kidaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Chaymi Jisusta kayshina tapurqanllapa: —Yach'achikuq Taytitu, ¿ima tyimpum kay nishqaykiqa rin kaq? ¿Imata rikashpam yach'ashaqllapa: Kay munduqam rin ushyakaqna, nishpaqa? ");
INSERT INTO qvcNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Chaymi Jisusqa nirqan: —Kwidakayllapa. Amar dijakayllapachu pipis ingañashunambaq. Chaqa achka llullakuqkunam shutiywan shamushpa, rinllapa nishuq: “Noqaqam Dyus Akrashqan Washadur kani. Kananqam chay diyaqa ch'ayamushqana washashunayllapa”, nishpa. Piru qamkunaqa amakish paykunataqa kasungillapachu. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kanan parlata uyashpa, chay maypish nasyungunapura pilyaykanllapa, chay maypish suq nasyumba ukumbi llaqta masipura pilyaykanllapa, nishpaqa, amakish manchangillapachu. Puntatam chayshina rin kaq, piru manaraqmi kay munduqa rinchu ushyakaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Chayshina nishpaqam, Jisusqa nirqambis: —Suq nasyumbi tiyaqkunaqam suq nasyumbi tiyaqkunawan rinllapa pilyaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Chay tyimpupiqam kay pachaqa ancha jwirtita rin kuyuq. Kanan ambruna, qeshyaykunam waqpi kaypi rin kaq. Syilupipismi manchaypaq siñakuna rin kaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Piru kay nishushqaykuna manaraq pasaptinmi, qamkunataqa ancha rinllapa qesachashuq. Sinaguga wasikunaman apashushpam, rinllapa dimandashuq, noqapi kriyishqaykirayku. Kanan rinmi karsilashuqllapa. Dimandashushpam, rinllapa apashuq gubyirnukunapa, prifiktukunapa ñawpanman. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Piru chayshina apashuptinllapaqam, ringillapa atiq noqapaq yach'achikuyta. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Chaymi paykuna tapushuptinqa, ama llakiyllapachu: ¿Ima nishparaq kuntistashaq? nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Chaqa noqam rini yanapashuqllapa, allita kuntistanayki, chay kuntrashuqkuna ama atinanllapa ni binsishuyllapata ni kuntistashuyllapata. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Piru qamkunataqam taytayki, mamayki, masaykikuna, aylluykikuna, yanasuykikunapis (yanasaykikunapis) rinllapa intrigakushuq kuntraykikunaman. Chaymi kuntraykikuna wakinnikitaqa rinllapa wanchishuq. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kanan achka runa, warmim rinllapa ch'iqnishuq, noqapi kriyishqaykirayku. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Piru kayta yach'ayllapa: Dyuspaqqam aqchaykikunaqa mana ni suqsitu rinchu chingaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Chaymi maychika imanachishuptimbis, noqapi mana shaykuq yuyakuptikiqa, suq bidapi rini washashuq, tukuy tyimpu kawsanaykillapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Piru rikaptikillapa furastiru suldadukuna kay Jirusalimbi tiyaqkunata kurralaptinllapam, yach'ayllapa: Ch'ayamushqanam tyimpu kay Jirusalinda chingachinanllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Chayri chayshina pasaptinqa, prubinsya Judiyapi kaqkunaqa qaqakunaman mitikanqallapa. Kay Jirusalin llaqtapi kaqkunapisri mitikanqallapa. Chay chunchapi kaqkunapisri kay Jirusalinmanqa amana shamunqallapachu. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Chaqa chay diyakunapiqam ancha padisiqllapa rin, Dyuspa Santu Librumbi nishqanshina. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Chay diyapiqa akakawraq chay (ukuyuq) pach'ayuq warmisitakuna, chay iti wambrituyuqkunaqa! Chaqa achka kastigukunam kay mundupiqa rin kaq. Chayshinallam kay Jirusalimbipis achka llakikuna rin kaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Wakingunatam atun kuchillukunawan rinllapa wanchiq. Wakingunataqam prisushpa, waqta, kayta karu nasyungunaman rinllapa apaq. Chay jwira runakuna binsishpam, kay Jirusalimbiqa ancha wapuyashpa rinllapa kamachikuq, Tayta Dyus qoshqan tyimpu ushyakanangaman. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Rupaypi, killapi, lusirukunapim siñakuna rin kaq. Kanan kay mundupa tukuy nasyunningunapi tiyaqkunaqam ancha llakishpa rinllapa niq: “¿Imananchiqtaq?” nishpa. Kanan mar yaku ancha fiyuta kunyashpa maqchikaptinmi, ancha manchashpa rinllapa niq: “¿Imaraq pasanqa?” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Chayshina tukuy ima kaptinmi, wakin runaqa: ¿Imataq kay mundupi rin pasaq? nishpa, ancha manchaywan rinllapa dismayaq. Chaqa syilupi Tayta Dyus tukuy ima rurashqambismi rin kuyuq. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Chaymandaqam noqa Dyusmanda Shamuq Runata ringillapa rikawaq, syilumanda pukutaypa ukumbi ancha pudirniyuq, ancha llipyashpa shamuykaqta. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Chayri yumbay kay nishushqayllapa qallariptinqa, kushikushpa, shayashpa, syiluman chapakuyllapa. Chaqa washashunay diyaqam ancha utqana rin ch'ayamuq. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kay kumparasyunda rurashpam, Jisusqa kayshinapis nirqan: —Yura igusta ichu suq laya muntikunata chapayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Chay muntikunapa rapranguna pallpamuqta rikashpaqam, yach'angillapana: Tamya tyimpumanmi yaykunchiqna, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Chayshina yumbay kay nishushqaykunata rikashpaqa, yuyayllapa: Tayta Dyusqam utqana rin shamuq, noqanchiqkunata shumaqta kamachiwananchiq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Alliptam niykillapa, yumbay kay nishushqaykunaqam rin kumpliq kay tyimpupi kawsaqkuna manaraq wañuptin. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Chaqa syiluwan kay pachaqam rin chingaq. Piru kay nishushqayqam mana nunka rinchu ushyakaq. Ashwanmi yumbay rin kumpliq. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Shunqoykipi allita yuyashpa kwidakayllapa, ama kwirpuyki munashqandalla ruranaykillapa. Ama mach'ayllapachu. Amakish kay pachapa imangunapiqa yuyangillapachu. Chaykish noqa qonqaylla shamushpa, tarishuyman mana allikunata ruraykaptikillapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Chaqa chay diyaqam kay mundupi yumbay tiyaqkunapaqqa suq trampa qonqaylla piskakuqshina rin kaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Chayri qamkunaqa listu kashpa, tukuy tyimpu Dyusman mañakuyllapa, chay diyapi yumbay kay nishushqaymanda washashunayllapa. Chaqa chayshina qamkuna kwidakaptikiqam, Tayta Dyus rin yanapashuq, chay diyapi mana nimapaq penqakushpa, ñawpayman prisintakanaykillapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jisusqam chay diyakunapiqa punchawqa Dyuspa adurana wasimbi yach'achikuq. Tutapqam Ulibu lumaman riq puñuq. ");
INSERT INTO qvcNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kada madrugadum achka runakuna Dyuspa adurana wasinman riqllapa, Jisusta uyaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Chay diyakunapim karqan chay Paskwa fyista. Chay fyistataqam pasaqllapa kachangakunata, suq laya mikunata mikushpa. Chay fyista yaqqana ch'ayaptinmi, ");
INSERT INTO qvcNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","chay kamachikuq isrraylinu kurakuna Muysispa liyningunata yach'achikuqkunawan tandanakushpa, uyaraplla (uyaralla) parlarqanllapa: —¿Imashinaraq Jisustaqa wanchinchiqmanllapa? nishpa. Lukismi chay fyistapi kaqkunata mancharqanllapa. (Jisusta wanchiptinchiqqach'i, achka runakuna kuntranchiq alsakanmanllapa, nishpa.) ");
INSERT INTO qvcNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Piru chay urasmi dyabluqa yaykurqan Judas Iskaryutiman. Chay Judasqam Jisuspa dusi apustulninmanda suqnin karqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Paymi rirqan parlaq kamachikuq isrraylinu kurakunawan, adurana wasimba kamachikuq suldadungunawambis: —¿Imashinataq atini intrigashuyta Jisustaqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Chaymi paykunata chayshina ufrisiptinqa, ancha kushikushpa, Judasta nirqanllapa: —Qellaytam qoshqaykillapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Chaymi Judasqa ari, nishpa, yuyarqan: ¿Ima urasraq alli Jisusta intrigakunayqa, mana kaptin achka runakuna? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Chay Paskwa fyistapa diyanqam ch'ayamurqanna. Chay qallarishqan diyapim suq uñitata wanchishpa, kachangakunawan mikurqanllapa, chay fyistata pasanambaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Chaymi Jisusqa Pidruta Jwanda nirqan: —Riyllapa allichaq mikunata, Paskwa fyistapi mikunanchiqllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Chaymi paykunaqa tapurqan: —¿Maypitaq munangi allichanayllapaqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Chaymi Jisusqa nirqan: —Waq Jirusalinman ch'ayaykashpam, ringillapa rikaq suq runa puyñumbi yakuta apaykaqta. Chayri chay runapa ikinda riyllapa wasi yaykushqangaman. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Chaymandaqa chay wasipa dwiñunda tapuyllapa: “Yach'achikuqmi nin: ¿Mayqan kwartuykipish yach'akuqniykunawan mikushaqllapa Paskwa mikunata?” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Chayshina niptikillapaqam, payqa wasimba altumbi suq atun kwartunda rin rikachishuqllapa tukuy imawan allichashqata. Chaypi allichayllapa Paskwa mikunanchiqtaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Chaymi Pidruwan Jwan rishpaqa, Jisus nishqanshina tarirqanllapa. Chaymi chay wasipina Paskwa mikunataqa allicharqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Chaymi chay uras ch'ayaptinqa, Jisusqa apustulningunawan mesapi tiyarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Chaymandaqam paykunata nirqan: —¡Manaraq padisishpam, ancha munashqa kani mikuyta kay Paskwa fyista mikunata qamkunawan! ");
INSERT INTO qvcNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Chaqa alliptam niykillapa, kay Paskwa mikunataqam kananllana qamkunawanqa rini mikuq. Mananam mastaqa rinichu mikuq syilupi kananchiqkaman. Waqpiqam Taytay Dyuspa pullan kashpana, mikurishunllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Chaymandaqam kupata piskashpa, Dyusman pagikushpa, nirqan: —Kay kupamanda yumbayniki upyayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Chaqa alliptam niykillapa, mananam mastaqa rinichu upyaq ubaskunapa yakundaqa, Taytay Dyuswan shamushpa, shumaqta kamachikunaykaman, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Chaymandaqam kachangata piskashpa, Dyusman pagikushpa, pitishpa, paykunata qoshpa, nirqan: —Kaymi kwirpuy. Chaqa intrigakanim wañunaypaq, qamkunata washashunaypaq. Chayri kayshina rurayllapa, noqata yuyawanaykillapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Chay Paskwa mikunata mikuptinllapaqam, kupatapis piskashpa nirqan: —Kay kupa binuqam yawarniy. Chaqa ich'ashpa yawarniytam, suq mushuq tratuta rini ruraq, qamkunata washashunaypaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Piru rikayllapa, chay runa intrigakuwaqqam pullay kay mesapi. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Chaqa Dyuspa Santu Librumbi nishqanshinam, noqa Dyusmanda Shamuq Runaqa rini wañuq. ¡Piru imananqaraqri chay intrigakuwaqqa! Ancha kastigadum rin kaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Chayshina Jisus niptinmi, apustulningunaqa suqnin, suqnin tapunakurqan: —¿Mayqanninchiqraq kanchiq chay intrigakuqqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Chaymandaqam chay dusi yach'akuqninguna anyanakurqanllapa: —Noqam mas kamachikuqqa kani. Suqqam bwilta nirqan: —Noqam mas kamachikuqqa kani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Chaypaqmi Jisusqa paykunata nirqan: —Chay suq nasyungunapa gubyirnungunam patrungunashina wapuyashpa, llaqta masingunata kamachinllapa. Chaymandaqam chay kamachikuqkunaqa alabakanllapa: “Llaqta masiykunatam ancha yanapani”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Piru qamkunaqa ama chayshinaqa kayllapachu. Ashwanri qamkunamanda chay mas kamachikuqqa suq umildi wambrashina ancha sirbikuq kanqa. Chayri chay kamachikuqqa suq kriyadushina qamkunata sirbishunqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mayá, yuyayllapa: ¿Pitaq mas kamachikuqqa, mesapi tiyaq ichu kriyadun? ¿Manachu mas kamachikuqqa mesapi tiyaq? Piru noqaqam qamkunapa kamachikuqniki kashpapis, suq kriyadushina tukuy imapi yanapaykillapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Qamkunaqam chay ñakashqaykunapi pullay kashqallapa kangi. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Chaymi Taytay Dyus awturidarta numbrawashqanshina, noqapis qamkunata numbrayki, kamachikuqkuna kanaykillapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Chayshinam numbraykillapa, kamachikunay tyimpupi noqawan pulla mesaypi mikunaykillapa, upyanaykillapa. Kanan kamachikunan trunukunapi ringillapa tiyaq, isrraylinukunapa dusi atun ayllungunata allita kamachinaykillapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jisusqam Pidrutapis nirqan: —Simun, Simun, dyablum qamkunata ancha munan mallipashuyta, triguta ishanaqshina. Chaymi Taytanchiq Dyusta nishqa: “Chay apustulkunata qoway mallipanaypaq, ¿qambichu allita kriyinllapa ichu mana?” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Chayshina kaptimbismi, Tayta Dyusta qambaq rrugashqa kani, ama tukuy tyimpu qonqawanayki. Chaymandaqar qamqa tukuy shunqoykiwan noqapi yuyakurishpa, yanapay kriyiq masikikunata, noqapi mas allita yuyakunanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Chayshina niptinqam, Simun Pidruqa nirqan: —Taytitu, noqam kaypi kani pullayki rinaypaq karsilman, ichu wanchishuptimbis, pullayki wañushaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Piru Jisusqam nirqan: —Uyaway Pidru, kaykish niyki, kay tutatam manaraq gallu kantaptin, qamqa kimsa kutinda ringi ñigawaq: “¿Pich'i Jisusqa? Noqaqam mana paytaqa riqsinichu”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Chaymi Jisusqa paykunata tapurqan: —Chay suq bwilta kach'ashuptiy rinaykillapa, alfurjaykita, qellaynikita, llanqekita dijashpaqa, ¿imaykichu faltashurqan? nishpa. Chaymi paykunaqa nirqan: —Manam nimapis faltawarqanllapachu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Kanan paykunatam nirqan: —Piru kananqam niykillapa, alfurjayuqqa alfurjanda apanqa. Qellayniyuqpis qellayninda apanqa. Chay mana atun kuchilluyuqqa kapanda randikushpa, suq atun kuchillunda randinqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Chaqa kananqam rinllapana qesachawaq, suq runa ancha malu ruraqtashina. Chaymi Dyuspa Santu Librumbi nishqanqa kumplinna. Chay librumbim noqapaq nin: “Mana allin runapaqshi rinllapa riqsiq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Chaymi chay apustulningunaqa nirqan: —Taytitu, kaypim kan ishkay atun kuchillukuna, nishpa. Chaymi Jisusqa nirqan: —Chayshinalla kanqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Chay tutaqam Jisusqa chay wasimanda lluqshishpa, yach'akuqningunata apashpa, rirqan Ulibu lumaman. Chaqa chay laya kustumbriyuqmi karqan. Nuta: Jitsimani wirtam chay Ulibu lumapi kidaq.  ");
INSERT INTO qvcNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Chayman ch'ayashpaqam, paykunata nirqan: —Dyusman mañakuyllapa, ama tyintadu kanaykillapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Chayshina nishpaqam, Jisusqa mas waqman rirqan 30 mitrustach'i. Chaypim payqa qonqorikushpa, Tayta Dyusman ");
INSERT INTO qvcNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","mañakushpa nirqan: —Taytitu, kay tukuy ñakaykunaqam noqapaqqa suq kupa ayaq yakushina. Munashpaqar kay ñakaykunamanda washaway. Piru amar noqa munashqayqa kanqachu. Ashwanri qam munashqaykishina kanqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Chay urasmi syilumanda suq anjil shamurqan Jisusta yanapanan, ama dismayanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Kanan tukuy chay llakikunawan masta mañakuptinmi, Jisustaqa limpu umbi pambarqan. Chaqa chay umbishqangunaqam yawarshina shuturqan allpaman. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Chaymandaqam chay mañakushqanmanda atarishpa, rirqan yach'akuqningunata rikaq. Chaymi ch'ayashpaqa, paykunata tarirqan puñuykaqta. Chaqa llakishpa, ancha shaykushqa kashpam, puñuykarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Chaymi paykunataqa nirqan: —¿Imaraykutaq puñuykangillapa? Atarishpana, Dyusman mañakuyllapa, ama tyintadu kanaykillapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Chayshina rimaykaptinmi, achka runakuna Jisus kaykashqanman ch'ayarqanllapa. Ñawpanllapataqam ch'ayarqan Judas. Chay Judasqam Jisuspa dusi yach'akuqningunamanda suqnin karqan. Paymi qemikashpa, Jisusta napaykurqan muchashpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Chaymi Jisusqa nirqan: —Judas, ¿ima chayshina muchawashpachu, noqa Dyusmanda Shamuq Runataqa intrigakuwangi kuntrawaqkunaman? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Chaymi Jisuspa apustulninguna chaykunata rikashpaqa, tapurqanllapa: —Taytitu, ¿atun kuchilluwanchu puntiyashaqllapa kay runakunata? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kanan suq apustulninqam atun kuchillunda surqoshpa, mas kamachikuq isrraylinu kurapa kriyadumba allin ladu rinrinda pitirqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Chaymi Jisusqa chayta rikashpaqa, nirqan: —Chaytallana. Amana maqayllapachu. Chayshina nishpaqam, chay kriyadupa rinrinman makinda rurashpa, das ashyachirqan (allinyachirqan). ");
INSERT INTO qvcNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Chaymandaqam Jisusqa chay kamachikuq kurakunata, Dyuspa adurana wasimba chay shamuq prisuq suldadungunata, tukuy chay kamachikuq ansyanukunatapis nirqan: —¿Ima qamkunaqachu atun kuchillukunawan, qerukunawan shamushqallapa kangi suq ladrundashina prisuwaq? ");
INSERT INTO qvcNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Noqaqam pullaykillapa kashqa kani tukuy diyakuna Dyuspa adurana wasimbi, ¿manachu? Chaypiqam qamkunaqa mana prisuwarqaykichu. Piru dyabluqam tutayaqpi mana allikunataqa ruran. Chaymi kay tuta shamushqallapa kangi, mana allikunata rurawaqqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Chaymandaqam Jisusta piskashpa, aparqanllapa chay mas kamachikuq isrraylinu kurapa wasinman. Kanan Pidruqam Jisuspa karu ikinda rirqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Chay tutaqam chay wasipa uku patyumbi ninata lumyachishpa, rridurnimbi tiyashpa mashakuykarqanllapa. Pidrupismi paykunapa pullan tiyashpa mashakuykarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Suq kriyadam Pidruta chaypi rikashpa, ancha chapashpa nirqan: —Kay runaqam Jisuswan puriq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Chayshina niptinqam, Pidruqam nirqan: —Warmisita, noqaqam mana Jisustaqa riqsinichu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Suq rratitumandaqam suqpis chapashpa, Pidrutaqa nirqan: —Qambismi paykunamanda suqnin kangi, nishpa. Chaymi Pidruqa paytapis nirqan: —Ay runa, noqaqam mana paykunamandachu kani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Chaymandaqam suq uramandach'i suq runa Pidrupaq nirqan: —Alliptam kay runaqa Jisuswan puriq. Chaqa paypismi prubinsya Galiliyamanda, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Chaymi Pidruqa chay runatapis nirqan: —Ay runa, ¿imatataq rimaykangi? Chay runapaqqam mana nimatapis yach'anichu, nishpa. Chayshina Pidru rimaykaptinmi, suq gallu kantarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Chay urasmi Jisusqa tikrakamushpa, Pidruta chaparqan. Chayshina chapaptinqam, Pidruqa das yuyarqan Jisukristu nishqanda: “Gallu manaraq kantaptinmi, qamqa kimsa kutinda ringi ñigawaq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Chay nishqanda yuyashpam, Pidruqa ancha syintishpa, sawaman lluqshishpa, ancha waqarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Kanan chay kwidakuqkunaqam ancha asipashpa, Jisusta maqarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Kanan ñawinda pambashpam, qaqllambi ancha maqashpa, nirqanllapa: —¡Mayá, yach'aq kashpaqa, rimay pitaq maqashungi! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Kanan suqnin suqnin tukuy ima mana allikunata rimashpa, paytaqa ancha musyarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Achikyaptinqam, isrraylinukunapa kamachikuq ansyanunguna, kamachikuq isrraylinu kurakuna, Muysispa liyningunata yach'achikuqkunapis suq lugarpi tandakarqanllapa. Chaymi chay Mas Kamachikuq Tandakaq Juyiskunapa ñawpanman Jisusta apamushpa, kayshina tapurqanllapa: ");
INSERT INTO qvcNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Mayá, niwayllapa, ¿Qamchu kangi Dyus Akrashqan Washadurqa? Chayshina tapuptinllapam, Jisusqa paykunata nirqan: —Ari niptiyqam, mana ringillapachu kriyiwaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Imata tapushuptiypismi, mana ringillapachu kuntistawaq, ni ringillapachu kach'awaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Piru noqa Dyusmanda Shamuq Runa kashpaqam, kananmandapacha Tayta Dyuspa allin ladumbi rini tiyaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Chayshina niptinmi, yumbay tapurqanllapa: —¿Chayshinaqachu qamqa Dyuspa Churin kangi? nishpa. Chaymi Jisusqa nirqan: —Arí, qamkuna nishqaykishinam kani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Chayshina niptinmi, paykunaqa nirqan: —¿Ima mastam munanchiq? Kananqam manana munanchiqchu mas tistigukunataqa. Chaqa uyanchiqna, pay kikin shiminwan chayta niwaptinchiq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Chay tyimpukunapim Rruma llaqtamanda kaqkuna achka nasyungunapi kamachikuqllapa. Chaymi isrraylinukunatapis suq rrumanu gubyirnu kamachiq. Chay gubyirnuqam shutiq Pilatu.  Chaymandaqam yumbay juyiskuna Jisustaqa aparqanllapa gubyirnu Pilatuman. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Chay Pilatupa ñawpambim juyiskunaqa llullakushpa, Jisusta kuntrashpa, kayshina rimarqanllapa: —Kay runataqam tarishqallapa kani llaqta masiy isrraylinukunata animachishpa, gubyirnunchiq Sesarta kuntribusyunda ama pagarananllapa. Payshi Dyus Akrashqan Washadur. Payshi suq gubyirnu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Chaymi Pilatuqa Jisusta tapurqan: —¿Qamchu isrraylinukunapa gubyirnunqa kangi? nishpa. Chaymi Jisusqa nirqan: —Arí, chay nishqaykishinam kani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Chayshina niptinqam, Pilatuqa chay kamachikuq isrraylinu kurakunata, yumbay chaypi kaqkunatapis nirqan: —Kay runapiqam noqaqa mana nima uchata tarinichu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Piru Pilatu chayshina niptinqam, paykunaqa mana munashpachu, ashwamba sh'uqyashpa nirqanllapa: —Tukuy kay prubinsya Judiyapim kay runaqa ingañaykan yumbay llaqta masiy isrraylinukunata, kuntranchiq alsakananllapa. Waq prubinsya Galiliyapim qallarishqa karqan. Kananqa rikay, kaypipis ingañakuriykan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Chay runakuna chayshina Galiliyata myintaptinllapaqam, Pilatuqa paykunata tapurqan: —¿Allipchu kay runaqa prubinsya Galiliyamanda? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Chaymi chay runakunaqa niptin: “Arí, payqam Galiliyamanda”, nishpa, Pilatuqa kamachikurqan, Jisusta apanambaqllapa Galiliyapa gubyirnun Irudisman. Chaqa chay diyakunapiqam Irudisqa Jirusalimbi kaykarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Chaymi Jisusta, ch'ayachiptinllapa, Irudisqa ancha kushikurqan. Chaqa payqam unaymandapacha Jisuspa famanda yach'ashpa, ancha yuyarqan: Ay, rikaymanri Jisusta suq milagruta ruraptin, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Chaymi Jisusta payman apaptinllapaqa, tukuy ima munashqanda tapurqan. Lukismi tapuptinqa, Jisusqa uyararqanlla. Manam nimatapis nirqanchu. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kanan chay Irudispa ñawpambiqam tandakashpa, chay kamachikuq isrraylinu kurakuna, Muysispa liyningunata yach'achikuqkunapis ancha kuntrarqanllapa Jisustaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Chaymi Irudisqa suldadungunawan Jisustaqa disprisyashpa, burrlarqanllapa. Kanan asipananraykum ancha shumaqta mudachirqanllapa suq gubyirnutashina. Chayshina mudachishpaqam, kach'arirqanna Pilatuman. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Chay diyapim Pilatuwan Irudisqa alliyarqanna. Chaqa kuntram kashqallapa karqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Chaymandaqam Pilatuqa kamachikuq isrraylinu kurakunata, suq awturidarkunata, achka runakunatapis tandashpa, ");
INSERT INTO qvcNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","nirqan: —Qamkunam kay runataqa noqaman apamushpa, niwashqallapa kangi: “Ingañaykanmi isrraylinukunata, kuntranchiq alsakananllapa”, nishpa. Chaymi noqa kikiy, kay ñawpaykillapapi tapushqa kani yach'anaypaq: ¿Allipchu chayshina ichu mana? nishpa. Piru manam nima dilituta paypiqa tarinichu. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Irudisman kach'aptiypismi, paypis mana nima dilituta tarishqachu. Chaymi kach'arimurqan noqaman. Rikayllapa, manam nima maluta rurashqachu wañunambaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Chayraykum asutichishpalla, rini kach'aq, nishpa. ˻ ");
INSERT INTO qvcNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kanan Pilatuqam chay Paskwa fyistapiqa kada wata suq prisuta kach'aq, isrraylinukuna rrugakuptinllapa.˼ ");
INSERT INTO qvcNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Piru chay runakunaqam mana munarqanllapachu, Jisusta kach'anambaqqa. Chaymi yumbaynin ancha jwirtita nirqanllapa: —¡Chay Jisusta wanchiy! ¡Barrabasta kach'ayqa! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Chay Barrabasqam Jirusalimbi tiyaqkunata animachishqa karqan, awturidarkunapa kuntran alsakananllapa. Kanan wanchikushqapismi karqan. Chaykunapaqmi paytaqa karsilashqallapa karqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Chaymi Pilatuqa suq kutinda nirirqan, Jisusta kach'anambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Piru paykuna mana munashpa Jisusta kach'anambaqmi, masta sh'uqyarqanllapa: —¡Kruspi klabay! ¡Kruspi klabay! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Chayshina niptinllapapismi, Pilatuqa suq kutindapis paykunata nirirqan: —Piru ¿ima malutamiri rurashqa? Noqaqam mana nima dilituta paypiqa tarinichu wañunambaqqa. Chaymi kastigachishpa rini kach'aq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Piru paykunaqam mana munarqanllapachu, Jisusta kach'anambaqqa. Chaymi mas jwirtita qayach'akushpa nirqanllapa: —¡Kruspi klabay, kruspi klabay! nishpa. Chayshinam rimarqanllapa, gustunllapata ruranangaman. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Chaymi Pilatuqa nish'karqanna: —Qamkuna munashqaykishina, Jisusqa wañunqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Chaymi Pilatuqa chay ancha wapu wanchikuq Barrabasta kach'ashpa, Jisusta intrigakurqan wanchinanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jisusta apaykashpa kruspi klabaqmi, tingunakurqanllapa suq runa Simun shutiqwan. Chay Simunqam Sirini llaqtamanda karqan. Payqam chuncha lugarkunamanda shamuykarqan. Chay Simundaqam Jisus apaykashqan krusta umbruchachirqanllapa, Jisuspa ikinda apanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Jisuspa ikindam ancha achka runakuna, warmikunapis rirqanllapa. Kanan chay warmikunam paypaq ancha llakishpa, waqashpa rirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Chaymi Jisusqa paykunata chapashpa, nirqan: —Jirusalinira warmisitakuna, noqapaqqa ama waqayllapachu. Ashwanri qamkunapaq, wawaykikunapaq waqayllapaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Chaqa rinmi ch'ayamuq waqana diyakuna. Chay diyakunapim wakinqa ancha padisishpa, rinllapa niq: “Ancha alliraq kashqa chay mana wach'aq warmikuna, chay mana nunka wawakushpa ñuñuchikuqkunapis. (Chaqa wambritunguna kashpach'i ancha padisiykanmanllapa)” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Chay diyapiqam runakunaqa qaqakunata rinllapa niq: “Sawayllapaman ishkiyllapa”. Lumakunatam rinllapa niq: “Pambawayllapa, ama tariwananllapa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Chaqa noqa mana nima uchayuq kaptiypismi, ancha padisichiwanllapa. Chayshina noqata rurawashpaqa, ¿imataraq qamkunataqa rurashunqallapa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Aparqanllapapismi ishkay ancha uchayuq prisukunata, kruspi klabashpa, Jisuspa pullan wanchinanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Chaymandaqam Kalabira shutiq lugarman ch'ayashpa, chaypina Jisusta kruspi klabarqanllapa. Chay ishkay prisutapismi pullan kruskunapi klabarqanllapa, suqta Jisuspa allin ladumbi, suqta ichuq ladumbi. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Kanan kruspina klabaykaptinllapam, Jisusqa mañakushpa, nirqan: —Taytitu, pirdunayri kay runakunata. Chaqa paykunaqa mana yach'ashpa: (Dyuspa Churindam wanchiykanchiq, nishpam,) kaykunata rurawaykanllapa, nishpa. Kanan chay suldadukunaqam swirtita rurarqan, Jisuspa mudananda partinakunanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Kanan chaypiqa achka runakuna Jisusta chapaykaptinmi, chay awturidarkuna ancha asipashpa nirqanllapa: —Suqkunatam washarqan. Mayá, Dyus Akrashqan Washadur kashpaqa, kananqa pay kikin washakanqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Chay suldadukunapismi Jisusta ancha asipashpa, qemikashpa, puchqo binuta apashpa, nirqanllapa: —Kayta upyay. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Mayá, isrraylinukunapa gubyirnun kashpaqa, qam kikiki washakay, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Chay kruspiqam Jisuspa umamba sawambi rurashqallapa karqan suq tablitata, grigu rimaypi, latin rimaypi, ibriyu rimaypi kayshina iskibrishqata: “Kay runaqam isrraylinukunapa gubyirnun”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Chaymandaqam chay ishkay kruspi kaqkunamanda suqninqa Jisusta musyashpa, nirqan: —Mayá, Dyus Akrashqan Washadur kashpaqa, qam kikiki washakashpa, noqaykunatapis washawayllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Piru chay suq uchayuqqam payta anyashpa, nirqan: —¡Uyaray! Kayshina padisiykashpa wañunanchiqqa, ¿ima, manachu Dyusta manchangi? ");
INSERT INTO qvcNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Allita yuyay, noqanchiqqam uchanchiqkunarayku ñakaykanchiq. Piru kay runaqam mana nima uchayuqchu ñakanambaqqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Chaymandaqam Jisusta nirqan: —Shamushpa kamachikuqqar, yuyawashpa, washaway, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Chaymi Jisusqa nirqan: —Alliptam niyki, kay diyamandapacham qamqa Taytay Dyuspa ancha shumaq lugarnimbi noqawan pulla ringi kaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Chay diya larrdusina kaptinmi, limpu tutayarqan las tres di la tardikaman. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Chaqa rupaymi wañurqan. Kanan Dyuspa adurana wasimba kurtinanqam anaqmanda ura manyakaman ch'awpi ch'awpi llikikarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Chay urasmi Jisusqa jwirtita rimashpa nirqan: —Taytitu, ispirituytar tandayna. Qamba makikipim mingayki, nishpa. Chayta nishpaqam wañurqanna. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Chaymi suldadukunapa kamachikuqnin yumbay chaykunata rikashpaqa, Dyusta kayshina alabarqan: —Allibraq kay runaqa mana nima uchayuqchu kashqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Chaypi kaqkunapismi chay pasashqanda rikashpa, yumbaynin ancha syintishpa, pichunda takashpa, wasinman kutirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Piru Jisuspa yumbay riqsishqanguna, chay warmikuna Galiliyamanda pullan shamuqkunapismi, karumanda rikarqanllapa tukuy ima chaypi pasashqanda. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Karqanmi suq ancha allin runa Jusi shutiq. Payqam prubinsya Judiyapa Arimatiya llaqtanmanda karqan. Chay Jusim chay Mas Kamachikuq Tandakaq Juyiskunamanda suqnin karqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Piru paypaqqam mana allichu karqan Jisusta wanchinanllapaqa. Chay Jusiqam unaymandapacha ancha munarqan Tayta Dyusta rikayta, yumbayta shumaqta kamachiptin. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Chaymi Jusiqa Pilatuman rishpa nirqan: —Yush'ayku, qoway Jisuspa kwirpunda, apanaypaq pambaq, nishpa. Chayshina mañaptinqam, Pilatuqa “arí” nirqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Chaymi Jusiqa krusmanda ishkichimushpa, suq ancha shumaq trapuwan Jisuspa kwirpunda liyashpa, apashpa, suq mach'ayshina sipulturapi pambarqan. Chay sipulturataqam suq luma qaqitapa pach'ambi kinraypa rurashqallapa karqan. Piru manaraqmi nima almata chaypiqa pambashqallapachu karqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Chayshinam Jisustaqa pambarqanllapa byirnis tardita, rupay yaqqana seqaptin, samana diya qallarinambaq urasna kaptin. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Pambaptinllapaqam, chay Galiliyamanda Jisuspa pullan shamuq warmikunaqa rirqanllapa chay pambakashqanman. Kanan allita rikarqanllapa Jisuspa kwirpunda kamakachishqanda. ");
INSERT INTO qvcNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Chaymi wasinman kutirishpaqa, mishki mutkinakunata allicharqanllapa, Jisuspa kwirpunda liyananllapa, ama ash'nanambaq. Chay samana diyapiqam samarqanllapa, Dyus kamachikushqanda kasushpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Simanapa qallarinan diya dumingum chay warmikunaqa Jisusta pambashqanman madrugadu rirqanllapa, chay allichashqan mishki mutkinata apashpa. Wakin warmikunapismi paykunawanqa rirqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Chay pambashqan lugarman ch'ayashpam, chay mach'ayshina sipulturataqa tarirqanllapa kich'ashqatana. Chay kirpashqan rumiqam suq ladumanna isqandaykarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Kanan kich'araqna kaptinqam, paykunaqa chay pambakashqanman yaykushpa, Jisuspa kwirpundaqa manana tarirqanllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Chaymi ancha manchashqata yuyaykaptinllapa, ladunllapapi diskwidu rikakurqan ishkay anjil ancha llipyaykaq mudanayuqkuna. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Chaymi chay warmikunaqa ancha manchashpa, pambaman kumurarqanllapa. Kanan chay anjilkunaqam nirqan: —¿Imaraykum maskaykangillapa chay kawsaqtaqa wañushqakunapa kay lugarnimbiqa? ");
INSERT INTO qvcNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Mananam kaypichu. Kawsashqanám. Yuyayllapa waq Galiliyapi kashpa, qamkunata nishushqanda. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Manchu nishurqanllapa: “Noqa Dyusmanda Shamuq Runatam rinllapa intrigakuwaq uchayuq runakunapa makinman, kruspi klabawashpa wanchiwananllapa. Chayshina rurawaptimbismi, kimsa diyamanqa rini kawsamuq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Chayshina niptinqam, chay warmikunaqa yuyarqanllapa Jisus nishqangunata. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Chaymandaqam paykunaqa chay pambakashqanmanda kutimushpa, yumbay rikashqanda parlachirqanllapa chay unsi apustulkunata, tukuy chay wakin kriyiq masingunatapis. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Chay famata apustulkunaman apaqkunaqam karqan: Marya Magdalamanda kaq, Jwana, Jakubupa maman Marya, suq warmikunapis. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Lukismi apustulkunaqa chay warmikuna nishqandaqa mana kriyishpachu yuyarqanllapa: Luka imach'i kay warmikunaqa kayshina niwananchiqqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Piru Pidruqam chay kashqanmanda lluqshishpa, kallpaylla rirqan chay pambashqanman. Chaymi ch'ayashpa, uku mach'ayshina sipulturaman chapakushpa, chay trapukunataqa suq ladupina kaqta rikarqan. Chayraykum ancha ispantashqata kutirqan chay wasi kashqanmanqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Chay dumingutallam Jisuspi ishkay kriyiqkuna Imawus llaqtaman riykarqan. Chay Jirusalinmandaqam unsi kilumitrusch'i karqan Imawuskamanqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Chay kriyiqkunaqam riykarqanllapa Jisus padisishqambaq parlashpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Chayshina ancha parlashpa, tapunakushpa riykaptinllapam, Jisusqa paykunaman qemikashpa, pullanllapa chay ñanda rirqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Piru paykunaqam pullan riqta rikashpapis, mana atirqanllapachu riqsiyta, pim pullanchiq riykan, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Chaymi Jisusqa paykunata tapurqan: —¿Imata parlaqshinam qamkunaqa riykangillapa? ¿Imapaqmi ancha llakingillapa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Chaymi suqnin Kliyufas shutiqqa Jisusta nirqan: —Yumbay runakunam yach'anllapa kay Jirusalimbi pasashqanda. ¿Ima qamqachu furastiru kangi, chaykunata mana yach'anaykiqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Chaymi Jisusqa tapurqan: —¿Imamir kashqa? nishpa. Paykunaqam nirqan: —Jisus Nasaritmanda kaqpaqmi parlaqshina riykanillapa. Paymi Dyuspa ñawpambi, runakunapa ñawpambipis ancha pudirniyuq rimaq karqan. Chaqa ancha ispantaypaq milagrukunatam rurarqan. Yach'achikurqambismi ancha shumaqkunata. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Paytamiri kamachikuq kurakuna, wakin awturidarninchiq kaqkunawan chay rrumanukunaman intrigakuptin, kruspi klabashpa wanchirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Piru noqaykunaqam yuyarqay: Paynam noqanchiq isrraylinukunataqa rin washawaqninchiq, nishpa. Manam yuyashqayllapachu kashqa. Chaqa kananwanqam kimsa diyana wañushqanqa. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Piru kanan madrugadum noqaykuna partiymanda wakin warmikuna rirqanllapa chay pambashqanman chapakuq. Chaymandaqam kutimushpaqa, ispantashqata dijawashqallapa. Chaqa niwarqanllapam, mananash kanchu kwirpunqa. Anjilkunatash rikarqanllapa. Chay anjilkunash nishqallapa: “Jisusqam kawsamushqana”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Chaymi wakin kriyiq masiykuna rirqan chay pambashqanman chapakuq, yach'ananllapa: Allipchu kawsamushqa ichu mana, nishpa. Paykunapismi kutimushpaqa niwarqanllapa: “Mananash kanchu kwirpunqa”, nishpa. Chaqa alliptam chay warmikunaqa rimarqanllapa. Piru Jisustaqam mana rikarqanllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Chayshina niptinllapam, Jisusqa paykunata nirqan: —¡A, mana jwisyuyuqkuna! ¿Ima manallachur qamkunaqa kriyingillapa Dyuspaq rimaqkuna nishqandaqa? ");
INSERT INTO qvcNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Chaqa Dyus Akrashqan Washadur syiluman rinambaqqam, puntata ñakanambaqraq karqan. ¿Manachu chayshina nirqan? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Chayshina nishpaqam, paykunata intyindichirqan Dyuspa Santu Librumbi paypaq yumbay nishqanda. Puntatam Muysis iskibrishqanda intyindichirqan. Chaymandaqam Dyuspaq chay suq rimaqkunapis iskibrishqanda intyindichirqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Chay Imawus llaqtaman ch'ayashpaqam, Jisusqa pasaqlla tukurqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Chaymi paykunaqa ancha rrugashpa, kayshina arkarqan: —Kidashunna noqaykunawan. Tardinám. Tutayaqnam rin, nishpa. Chayshina arkaptinllapaqam, “Mayá” nishpa, paykunawanna kidarqan. Chaymi Jisusqa paykunapa pullanna wasinman yaykurqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Chaymandaqam paykunawan mesapi tiyashpa, tandata piskashpa, Dyusta pagikurqan. Chaymandaqam chay tandata pitishpa, paykunata qorqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Chay urasmi paykunaqa atirqanllapana Jisusta riqsiyta. Piru Jisusqam paykunapa pullan kashqanmanda das chingarqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Chaymi paykunapura kayshina parlarqanllapa: —Manchu ñanda shamuqshina Dyuspa Santu Librunmanda parlachiwaptinchiqqa, shunqonchiqpi ancha kushikurqanchiq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Chayshina parlashpaqam, chay uraslla kutirqanllapa Jirusalinman. Chaymi ch'ayashpaqa, chay unsi apustulkunata wakin kriyiq masingunata tarirqanllapa tandanakushqata. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Chay wasipi kaqkunaqam puntata chay shamuqkunata nirqan: —Alliptam Siñurninchiq Jisusqa kawsamushqana. Chaqa Simun Pidrumanmi rikakushqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Chayshina niptinllapam, chay ishkay shamuqkunapis kayshina parlachirqan: —Ñandam pullayllapa riqshina noqaykunata parlachiwashqa. Tandata pitishqan urasmi paytaqa riqsishqallapa kani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Chayshina parlaykaptinllapam, Jisusqa qonqaylla ch'awpinllapapi rikakushpa, nirqan: —Bwinas nuchis, Dyusri qamkunata yanapashunqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Piru paykunaqam Jisusta rikashpaqa, ancha manchashpa, yuyarqanllapa: Almatach'i rikaykanchiqllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Piru Jisusqam paykunata nirqan: —¿Imaraykum manchangillapa? ¿Imaraykutaq noqapaqqa yuyangillapa, almach'i, nishpaqa? ");
INSERT INTO qvcNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Chapayllapa makiykunata, ch'akiykunata. Noqa kikiymi kani. Kwirpuyta malliyllapa. Rikay, aychayuq, tulluyuqmi kani. Suq almaqam mana chayshinachu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Chayshina nishpaqam, makingunata, ch'akingunata rikachirqan chapanambaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Piru paykunaqam ashla manchashpa, ashla kushikushpa, ispantashqata chapashpa, yaqqa mana atirqanllapachu kriyiyta. Chaymi Jisusqa nirqan: —¿Kanchu imitaykillapa mikunaypaq? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Chaymi paykunaqa suq pidasu piskadu kangashqata, abijapa suq panalnindapis qorqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Chaymi Jisusqa ch'askishpa, ñawpanllapapi mikurqan. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Chaymandaqam paykunata nirqan: —Manchu pullaykillapa kashpa, nishurqaqllapa: “Rinmi kumpliq noqapaq Muysispa librumbi yumbay nishqanguna, Dyuspaq chay suq rimaqkunapa librungunapi nishqanguna, Salmus librupi nishqangunapis”, nishpa. Chay nishushqayllapam kumplishqana. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Chaymandaqam Jisukristu paykunataqa ancha allita intyindichirqan Dyuspa Santu Librumbi nishqanda. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kanan paykunata nirqan: —Dyuspa Santu Librumbiqam noqapaqqa nin: Dyus Akrashqan Washadurqash wañushpa, kimsa diyamanda rin kawsamuq. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Chaymandaqam yach'akuqninguna Jirusalimbi qallarishpa, yumbay nasyungunaman rinllapa ch'ayaq, paypa shutimbi kayshina yach'achikushpa: “Chay mana allikunata rurashqaykipaq ancha syintishpa, Dyusmanna mañakuyllapa, pirdunashushpa, washashunanllapa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kananqam qamkuna tistiguykuna kangillapa, noqa rurashqaypaq parlanaykillapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Uyawayllapa, Taytay Dyus ufrisishushqandam rini kach'amuq qamkunamanqa. Piru shuyayllaparaqri kay Jirusalimbi, syilumanda chay pudirninda kach'amunaykaman, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Chaymandaqam Jisusqa chay apustulningunata Jirusalinmanda aparqan Bitanillaman (Bitaniyaman). Chaypim payqa makingunata alsashpa, Tayta Dyusman mañakurqan, paykunata yanapanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Chayshina mañakuykashpaqam, chay apustulningunapa ch'awpinmanda rirqanna syiluman. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Paykunaqam Jisusta adurashpa, ancha kushikushpa, chay kashqanllapamanda Jirusalinman kutirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kanan paykunaqam Dyuspa adurana wasinman rishpa, tukuy diya Dyusta alabaqllapa. Chayshina kanqa.");
INSERT INTO qvcNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Manaraq kay pacha kaptinmi, suq Rimaqqa karqanna. Chay Rimaqqam Dyuspa pullan kashpa, paypis Dyus karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Qallariypiqam payqa Tayta Dyuswan karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Chaymandaqam Tayta Dyusqa chay Rimaqwan syiluta, kay pachata, tukuy imandinda rurarqan. Chaqa Tayta Dyusqam mana nimatapis sapalanqa rurarqanchu. Ashwanmi chay Rimaqwan tukuy imataqa rurarqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Kanan chay Rimaqqam tukuy imata kawsachin. Payqam bidanchiqpaqqa suq Michashina. Chaqa paymi yach'achiwanchiq, allita rurashpa kawsananchiqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Kay pachapi uchata ruraqkunaqam tutayaqpishina. Piru chay Michashina kaqmi chay tutayaqpishina achikchakun, yumbayta yach'achishpa, chay uchakunata ama rurananllapa. Kanan chay uchata ruraqkunaqam chay Michashina kaqta kuntrashpapis, mana atishqallapachu binsiytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Suq runam Jwan Shutichikuq shutirqan. Paytam Dyus akrashqa karqan, chay Michashina kaqpaq yach'achikunambaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Chaymi chay Jwanqa chay Michashina kaqpaq yach'achikurqan, yumbay uyaqkuna chay Michapi yuyakunanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","9","Chaqa chay allip Michaqam shamurqan kay munduman, yumbay runakunata yach'achinambaq. Piru Jwanqam mana chay Michachu karqan. Payqam chay Michapaq yach'achikuqlla karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Chay Rimaq Michaqam kay munduta rurashqa karqan. Chaymandaqam kay munduman shamuptin, runakunaqa mana yach'arqanllapachu: Paymi kay munduta rurashqa, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Chaymi akrashqan nasyunman shamuptinqa, paykunaqa disprisyashpa, mana shumaqtachu ch'ayachirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Piru wakinnataqmi payta shumaqta ch'ayachishpa, paypi kriyirqanllapa. Chaymi paykunataqa akrarqan, Tayta Dyuspa wambranguna kanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Chaymi paykunaqa chay Rimaqpi kriyishpaqa, mushuqmanda nasishqashina kashqallapa. Chaqa paykunaqam mana mamanmandallachu nasirqan, ni nasirqanllapachu suq runa wambrayuq kanambaqqa. Ashwanmi Tayta Dyus kikin munashqa, paypi kriyishpa, mushuqmanda nasirinambaq, wambrangunana kanambaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kanan chay Rimaqqam runapaq tikrakashpa, pullayllapa puriq. Chaymi Taytanchiq Dyuspa chay sapalan Churinda rikarqanillapa ancha allin kaqta, ancha pudirniyuqta. Chaqa payqam ancha kuyawaqninchiq, allip kaqtalla yach'achikurqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Paypaqmi chay Jwan Shutichikuqqa ancha jwirtita rimashpa, kayshina nirqan: —Chay kamachikuqpaqmi qamkunata nishurqaqllapa: “Puntatam noqa nasishqa kani. Chaymandaraqmi chay Rimaqqa rin shamuq. Paymi noqamanda mas baliqqa. Chaqa noqa manaraq nasiptiymi, payqa unaymandapacha kawsashqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Chay ancha kuyawaqninchiq Rimaqmi tukuy imapi kutin kutin yumbayninchiqta ancha yanapawashqa kanchiq. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Chaqa Tayta Dyusmi Muysista akrarqan, liyningunata yach'achiwananchiq. Piru Jisukristutaqam kach'amurqan kuyawaqninchiq, allip kaqtalla Dyuspaq yach'achiwananchiq. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Taytanchiq Dyustaqam mana pipis nima tyimpu rikashqachu. Piru chay ancha kuyashqan sapalan Churinllam, Tayta Dyuspa pullan kawsashpa, kay pachaman shamushpa, niwashqa kanchiq, Taytambaq allipta yach'ananchiq. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Isrraylinukunapa awturidarningunam Jirusalinmanda wakin kurakunata, wakin yanapakuqnin libitakunatapis kach'arqanllapa, Jwan Shutichikuqta kayshina tapunanllapa: —Qamqa, ¿ima karguyuqmi kangi, yumbayta kayshina yach'achinaykiqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Chaymi Jwanqa mana nimata pakashpachu, nirqan: —Manam noqaqa Dyus Akrashqan Washadurchu kani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Chaymi chay shamuqkunaqa tapurqanllapa: —Chayshinaqa ¿ima karguyuqmi kangi? ¿Chay unay alma Eliyaschu kangi? nishpa. Piru Jwanqam nirqan: —Manam, nishpa. Chaymi tapurirqanllapa: —¿Dyuspaq chay shamunambaq rimaqchu kangi? nishpa. Jwanqam nirqan: —Manam paychu kani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Chaymi paykunaqa tapurirqanllapa: —Chayshinaqa ¿ima karguyuqmi kangi? Niwayllapar, chay kach'amuwaqta ninaypaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Chaymi Jwanqa Dyuspaq rimaq Isayiyas iskibrishqanda nirqan: —Noqam kani chay chuncha lugarkunapi kayshina qayakuq: “Bidaykillapata ñandashina shumaqta dirichuta allichayllapa, Siñurninchiqta shumaqta ch'ayachinaykillapa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Chay tapuqkunaqam farisiyu duktrinayuq kaqkunamanda shamushqallapa karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Chaymi nirqanllapa: —Chayshina Dyus Akrashqan Washadur mana kashpaqa, ni Eliyas kashpaqa, ni Dyuspaq chay suq rimaq kashpaqa, ¿imaraykutaq qamqa shutichikungiqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Chaymi Jwanqa paykunata nirqan: —Noqaqam yakuwanlla shutichikuni. Piru suq ancha kamachikuqmi shamushqa. Payqam qamkunapa ch'awpikipi puriykan. Piru paypaqqam mana yach'angillapachu: Dyus Akrashqan Washadurmi, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Noqaqam puntata shamushqa kani. Chaymandaraqmi payqa shamushqa. Piru noqamandaqam mas pudirniyuq. Chaymi noqaqa mana nimachu kani paypa ñawpambiqa. Chaqa manam balinichu, ni llanqemba watunda paskanaypaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Chayshinam Jwandaqa tapurqanllapa, rriyu Jurdamba waq ladu chimban Bitabara lugar shutiqpi. Chaqa chay chimbapim Jwanqa shutichikuykarqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Chaymandaqam qayandinqa, Jwan Shutichikuqqa Jisusta rikarqan, payman shamuykaqta. Chaymi kayshina nirqan: —Rikayllapa. Chaypinam Dyuspa Uñanqa. Paymi kay munduman shamushqa, wañushpa, runakunapa uchangunata pirdunanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Paypaqmi noqaqa niykarqay: “Rinmi shamuq suq runa. Paymi mas pudirniyuq noqamandaqa. Chaqa unay tyimpumandapacham noqa manaraq nasiptiy, payqa kashqana”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Manam noqaqa riqsirqaychu. Piru chayshina payta manaraq riqsishpapismi, noqaqa shamurqay, yakuwan shutichikuq, qamkuna isrraylinu masiykuna paypaq yach'anaykillapa: Rinnam shamuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Chay Jwan Shutichikuqqam nirqambis: —Dyusmi kach'amuwashpa, yakuwan shutichikunaypaq, kayshina niwarqan: “Santu Ispirituyta syilumanda shamuykaqta rikashpa, suq runapa sawambi tiyaptinmi, ringi yach'aq: Chay runam Santu Ispirituwan shutichikun”, nishpa. Piru manaraqmi yach'arqaychu: ¿Pim payqa? nishpa. Piru suq diya Jisusta shutichiykaptiymi, Dyuspa Santu Ispiritun suq palumitashina syilumanda urangumushpa, paypa sawambi tiyarqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Noqa kikiymi chaytaqa rikashqa kani. Chaymi tistigu kani. Chaqa allitam yach'ani: Jisukristum Dyuspa Churin, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Qayandinqam chay Jwan Shutichikuqpa ishkay yach'akuqnin paywan chaypi karirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Chaymi Jwanqa, Jisusta rikashpa pasaykaqta, chay ishkay yach'akuqninda nirqan: —Rikay, waq runaqam Dyuspa Uñan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Chayshina niptinqam, chay ishkay yach'akuqninguna uyarqan. Chaymi paykunaqa Jisuspa ikinda rirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Chaymandaqam Jisusqa ikiman chapakushpa, rikarqan chay ishkay sigiqkunata. Chaymi payqa tapurqan: —¿Imatam maskaykangillapa? nishpa. Paykunaqam nirqan: —Yach'achikuq Taytitu, ¿maypitaq tiyangi? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Chaymi paykunataqa Jisusqa nirqan: —Aku noqawan, tiyashqayta riqsinaykillapa, nishpa. Chaymi paykunaqa rishpa, rikarqanllapa chay maypi tiyashqanda. Las kwatru di la tardinach'i chay tiyashqanmanqa ch'ayarqanllapa. Chaymandaqam chaypina paywan tardiyarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Chay ishkay runamandaqam suqninqa karqan Andris. Payqam Simun Pidrupa masan karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Chay Andrisqam das rirqan maskaq chay masan Simunda. Chaymi masanda tarishpaqa, nirqan: —Misiyastam tarishqallapa kani, nishpa. (Paykunapa rimaynimbiqam “Misiyasqa” ichu “Kristuqa” munan niyta “Dyus Akrashqan Washadur”, nishpa.) ");
INSERT INTO qvcNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Chaymi Andrisqa chay uras masan Simunda apamurqan Jisusman. Chaymi Jisusqa chapashpa, nirqan: —Qamqam Junaspa churin Simun kangi. Piru kananqam ringi shutiq Sifas, nishpa. Chay Sifas shutiqqam rimaynimbiqa munan niyta “Pidru”. (Pidruqam munan niyta “rumi”.) ");
INSERT INTO qvcNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Qayandinqam Jisusqa munarqan riyta prubinsya Galiliyaman. Chaymandaqam tingunakurqan suq runa Filipi shutiqwan. Chaymi pay kashqanman ch'ayashpa nirqan: —Aku noqawan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Chay Filipiqam Bitsayda llaqtamanda karqan. Chaymi chay Andrispa, Pidrupa llaqta masin karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Kanan Filipiqam suq runa Natanayil shutiqman rishpa nirqan: —Tarishqallapanam kani Dyus Akrashqan Washadurta. Manchu chay unay Muysis librungunapi, Dyuspaq suq rimaqkunapis librungunapi kayshina iskibrirqan: “Dyus Akrashqan Washadurmi rin ch'ayamuq”, nishpa. Chay Washadurqam Nasarit llaqtamanda. Jusipa churinmi. Jisusmi shutin, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Piru Natanayilmi Filipitaqa nirqan: —¿Chay llaqta Nasaritmandaqa ima allindaq atinman ch'ayamuyta? Manam nimapis, nishpa. Chayshina Natanayil niptinmi, Filipiqa nirqan: —Aku rikaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Chaymi chay Natanayilqa Filipiwan Jisusmanna ch'ayamuykaptin, Jisusqa rikashpa, Natanayilpaq nirqan: —Kaypinám suq lijitimu isrraylinu. Payqam ancha kabalta riman. Manam llullakunchu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Chaymi Natanayilqa Jisusta nirqan: —¿Imashinataq riqsiwangi, chayshina niwanaykiqa? nishpa. Chaymi Jisusqa nirqan: —Manaraq Filipi qayashuptinmi, yura iguspa warambi kaykaptiki, rikashurqay, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Chayshina niptinqam, Natanayilqa nirqan: —Yach'achikuq Taytitu, qamqam Dyuspa Churin kangi. Qamqam nasyunninchiq Isrrayilpa gubyirnun kangi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Chayshina niptinqam, Jisusqa nirqan: —¿Chay yura iguspa warambi rikashushpa nishuptiychu, noqapiqa yuyakungi? Ringinam rikaq mas ispantaypaq milagrukunata ruraptiy, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Chaymandaqam paykunata nirqan: —Alliptam niykillapa, noqam Dyusmanda Shamuq Runa kani. Chaymi qamkunaqa ringillapa rikaq syiluta kich'araykaqta. Chaymandaqam ringillapa rikaq Dyuspa anjilningunata, noqamanda syiluman riykaqta, syilumanda noqaman shamuykaqta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kimsa diya pasaptinnam, chay prubinsya Galiliyapa Kaná llaqtambi rurarqanllapa suq kasamyintu fyistata. Chaypim karqan Jisuspa maman. ");
INSERT INTO qvcNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Chay fyistamanmi Jisusta, noqaykuna yach'akuqninda kumbidawarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Chay fyistapi binu ushyakaptinmi, mamanqa Jisusta nirqan: —Ijitu, ushyakashqanam binunqa. Yanapayri, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Chaymi Jisusqa mamanda nirqan: —Mamita, ¿imaraykutaq chayshinaqa niwangi? Manaraqmi ch'ayamunchu uras, milagrukunata ruranaypaqqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Chaymi mamanqa kasaraqkunapa kriyadungunata kayshina nirqan: —Waway yumbay nishushqanda rurayllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Chaypim karqan sayis payaskakuna rumimanda kaq. Chaqa chay isrraylinukunam yakuta tandaqllapa chay payaskakunapi, mayllakuna kustumbrinda rurananllapa. Kada payaskam 80 litrus a 100 litruskaman ukukuq. ");
INSERT INTO qvcNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Chaymi Jisusqa chay kriyadukunata nirqan: —Chay payaskakunaman undachiyllapa yakuta, nishpa. Chaymi paykunaqa kasushpa, ancha undachirqanllapa yakuta. ");
INSERT INTO qvcNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Chaymandaqam chayshina ruraptinllapaqa, Jisusqa paykunata kayshina nirqan: —Kananqa chay payaskakunamanda ashla surqoshpa, apashpa, sirbisyukunapa kamachikuqninda qoy, nishpa. Chaymi chay kriyadukunaqa Jisus nishqanshina rurarqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Piru chay sirbisyukunapa kamachikuqninqam mana yach'arqanchu: Maymandam apamunllapa kay binutaqa, nishpa. Kriyadukunallam yach'arqanllapa, paykuna kikin chay payaskamanda surqoshqanllaparayku. Chaqa chay yakuqam binupaqna tikrakashqa karqan. Chaymi chay kamachikuq sirbisyuqa mallishpa, ancha gustashpa, chay kasaraykaqta qayashpa, ");
INSERT INTO qvcNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","nirqan: —¡Kay binuqam ancha mishki! Yumbay runam kumbidashqangunataqa chay mas ch'aniyuq binuta puntata qonllapa. Chay allin binuta achkata upyaptinraqmi, chay mana ch'aniyuq binutaqa qonllapa. Piru qamqam ultimupaqraq kay mas allin binuykitaqa waqaychashqa kangi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Chayshina prubinsya Galiliyapa Kaná llaqtambim Jisusqa punta milagruta rurarqan, chay binuta rurashpa. Chayta rurashpam, payqa pudirniyuq kashqanda rikachikurqan. Chaymi noqaykuna yach'akuqningunaqa paypi kriyirqayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Chaymandaqam Jisusqa mamanwan, masangunawan, noqaykuna yach'akuqninwan chay Kaná llaqtamandaqa ura Kapirnawun llaqtaman rirqayllapa. Waq Kapirnawumbim wakin diyakunata tiyarqayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Paskwa fyista ch'ayaykaptinnam, Jisusqa rirqan Jirusalin llaqtaman. ");
INSERT INTO qvcNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Chaypim runakunata tarirqan Dyuspa adurana wasimba patyumbi buyiskunata, wishakunata, palumakunata randikuykaqta. Qellayta kambyakuqkunapismi chaypi kambyaykarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Chaymi Jisusqa chayta rikashpa, suq chikutita rurashpa, yumbay chay wishakunata, buyiskunata qatirqan Dyuspa adurana wasimba patyunmandaqa. Kanan chay qellayta kambyakuqkunapa qellayningunatam sh'ilya sh'ilya pambaman wichukurqan. Mesangunatapismi bularqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Chay palumata randikuqkunataqam nirqan: —Chay tukuy imaykikunata kaymanda surqoyllapa. Taytaypa wasindaqa ama plasatashinaqa rurayllapachu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Chayta rikashpaqam, noqaykuna yach'akuqninqa yuyarqayllapa Dyuspa Santu Librumbi Tayta Dyusta kayshina nishqanda: “Shumaq wasikita noqa ancha kuyashpam, suqkuna disprisyaptin, ancha piñakuni”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Chaymi chay mas kamachikuq isrraylinukuna Jisusta kayshina nirqanllapa: —¿Ima milagrutam atingi rurayta, rikashpa, yach'anayllapaqa: Taytanchiq Dyusmi qamta numbrashushqa, paypa kay adurana wasimbi kamachikunayki, nishpaqa? ");
INSERT INTO qvcNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Chaymi Jisusqa paykunata nirqan: —Kay wasita limpu bulaptikillapam, noqaqa kimsa diyapilla rurarishaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Chayshina Jisus niptinmi, chay kamachikuqkunaqa nirqanllapa: —Kwarinta y sayis watakunapim Dyuspa kay adurana wasindaqa rurarqanllapa. ¿Chaychu qamqa kimsa diyapilla ringi rurariq? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Piru Jisusqam chayshina rimashpaqa, kwirpumbaq rimarqanqa; manam Dyuspa adurana wasimbaqchu. ");
INSERT INTO qvcNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Chaymi wanchiptinllapa, mushuqmanda kawsamuptinqa, noqaykuna yach'akuqninqa chay nishqanda yuyarqayllapa. Chaymi noqaykunaqa Dyuspa Santu Librumbi nishqanda, Jisus nishqandapis kriyirqayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jisusmi Jirusalin Paskwa fyistapi kashpa, milagrukunata rurarqan. Chaymi achka runakuna paypi kriyirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Piru Jisusqam paykunapiqa mana yuyakurqanchu. Chaqa pay kikinmi riqsirqan yumbaypa shunqonda, ima layakunata yuyaykanllapa, nishpa. Chaymi mana nisisaryuchu karqan ni pipis ninambaq: Kay runakunaqam kayshina yuyaykanllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Karqanmi suq farisiyu duktrinayuq runa Nikudimu shutiq. Payqam isrraylinukunapa kamachikuqnin karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Chay Nikudimuqam suq tuta Jisusta rishpa watukuq, kayshina nirqan: —Yach'achikuq Taytitu, yach'anillapam qambaq: Tayta Dyusmi kach'amushushqa, noqaykunata yach'achiwanayki, nishpa. Chaqa Taytanchiq Dyus kach'amushushqa kaptinqam, atingi chay achka milagrukunata rurayta. Manaqa manam atingimanchu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Chayshina Nikudimu niptinmi, Jisusqa nirqan: —Alliptam niyki, suq runa mushuqmanda nasishpam, atin Tayta Dyuswan syilupi kawsaytaqa. Manaqa manam atinchu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Chaymi Nikudimuqa Jisusta kayshina tapurqan: —¿Imashinataq suq runaqa atinman mushuqmanda nasiriytaqa? Manam ni pipis atinmanchu mamamba pach'anman yaykuriyta, mushuqmanda nasinambaqqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Nikudimu chayshina niptinmi, Jisusqa nirqan: —Alliptam niyki, Tayta Dyuswan tukuy tyimpu pullan kawsanayki, puntata munan yakumanda, ispiritumanda nasinayki. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Chaqa yumbay runakuna mamanmanda nasishpaqam, kwirpunda ch'askinllapa. Piru Dyuspa Santu Ispiritunmi wakingunata yanapan, mushuqmanda nasirinambaq, chay Santu Ispirituta kasushpa kawsananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Chayri ama ispantaychu: “Mushuqmanda nasiriy”, nishuptiyqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Chaqa wayraqam tukuy ladumanda wayran. Piru qamkuna uyashpaqam, mana yach'angillapachu: ¿Maymandam shamun? ni ¿maymanmi rin? nishpaqa. Chayshinallam Dyuspa Santu Ispiritunmanda nasiqkunapis. (Chay Santu Ispirituta mana rikashpapis, yach'anllapa: Paymi yanapawaykan, nishpa.) ");
INSERT INTO qvcNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Chayshina Jisus niptinmi, Nikudimuqa mushuqmanda tapurirqan: —¿Imashinaraq kanqa chay layakunaqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Chaymi Jisusqa nirqan: —Isrraylinukunapa yach'achikuqnin kashpapischu, ¿mana yach'angi chaykunata? ");
INSERT INTO qvcNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Alliptam niyki, noqaqam yach'ashqayta, rikashqayta yach'achiykillapa. Piru qamkunaqam mana kriyiwangichu. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Chayshina kay pachapi rikashqaypaq parlachishuptiy, mana kriyiwashpaqa, ¿imashinataq kriyiwangiman, syilupi rikashqaypaq parlachishuptiyqa? ");
INSERT INTO qvcNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Manam ni pipis syiluman rishpaqa, kutimushqachu. Noqallam Dyusmanda Shamuq Runa kashpa, syilumandaqa shamushqa kani. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Unay tyimpupim chuncha lugarpi Muysisqa suq kulibrata jirrumanda rurashpa, suq qerupi alsarqan. Chayshinallam noqatapis suq kruspi rinllapa alsawaq, ");
INSERT INTO qvcNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","noqapi yumbay yuyakuqkuna ama chinganambaq, ashwan syiluman rishpa, tukuy tyimpu kawsanambaqllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Chaqa Tayta Dyusqam kay mundupi yumbay tiyaqkunata ancha kuyashpa, sapalan Churinda kach'amurqan wañunambaq, paypi yumbay kriyiqkuna ama chingananllapa; ashwan tukuy tyimpu kawsananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Chaymi Tayta Dyus kay munduman Churinda kach'amurqan, yumbayta chay kastigumanda washanambaq. Manam kach'amurqanchu, kay mundupi tiyaqkunata jusgashpa kastigananqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Chaymi Dyuspa Churimbi yuyakuqkunataqa Taytanchiq Dyusqa mana rinchu chingachiq. Piru paypi mana yuyakuqkunataqam rin chingachiq, sapalan Churimbi mana kriyishqanllaparayku. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Chaqa payqam kay mundumanqa shamushqa, Tayta Dyuspaq yach'achikunambaq. Chaymi suq michashina kashqa. Piru paypi mana kriyiqkunaqam mana munanllapachu michapishina kawsaytaqa. Chaqa uchangunata mana munashpa dijaytaqa, tutayaqpishina munanllapa kawsayta. Chaymi Taytanchiq Dyusqa paykunata rin kastigaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Chay mana allita ruraqkunaqam mana munanllapachu ni pipis yach'anambaq chay mana alli rurashqambaqqa. Chaymi chay michashina kaqta ch'iqnishpaqa, mana qemikanchu, ama ni pipis rikashpa yach'anambaq: “Ancha malutam ruraykan”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Piru suqkunaqam allip kaqta kasushpa, michapishina purinllapa. Chaymi tukuy runakuna rikashpa yach'anllapa: Taytanchiq Dyus munashqandam ruraykanllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Chaymandaqam Jisusqa noqaykuna yach'akuqninwan pullan prubinsya Judiyaman rirqayllapa. Chaypim suq tyimpupaq kidashpa, runakunata, warmikunata shutichirqayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jwan Shutichikuqpismi Inun llaqtapi shutichiykarqan runakunata, warmikunata, chaypi achka yaku kashqanrayku. Chay Inun llaqtaqam Salim llaqtapa ladumbi kidan. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Chayshinaqam karqan, Jwanda manaraq karsilaptinllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Chay tyimpupim Jwamba yach'akuqningunaqa suq isrraylinu masingunawan suq layata suq layata anyanakurqanllapa: —Tayta Dyusqam munan kayshina mayllakunanchiq, ama uchayuqkuna kananchiqllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Chaymandaqam Jwamba wakin yach'akuqningunaqa rirqanllapa payta niq: —Yach'achikuq Taytitu, rriyu Jurdamba chimbambim suq runa qamwan pulla karqan. Chay runapaqmi niwarqaykillapa: “Paytaqam Taytanchiq Dyus kach'amushqa”, nishpa. Kananqam chay runaqa achkatana shutichiykan. Achka runakuna, warmikunapismi paytana sigiykanllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Chayshina yach'akuqninguna niptinllapaqam, Jwanqa nirqan: —Tayta Dyus suq runata yanapaptinqam, imatapis atin rurayta. Manaqa manám. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Qamkuna kikikim uyawashqallapa kangi, noqa nishuptiy: “Manam noqaqa Dyus Akrashqan Washadurchu kani. Ashwanmi Taytanchiq Dyus kach'amuwashqa, chay Washadurninchiqmanda mas puntata shamunaypaq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kay kumparasyumbaq yuyayllapa: Suq runa kasarashpaqam, ancha kushikushpa riman. Chaymi chay runapa mas kuyashqan kumpañirumbis uyashpa, ancha kushikun. Jisusqam chay kasaraq runashina. Noqa chay runa kasaraqpa mas kuyashqan kumpañirun kani. Chaymi achka runa Jisusta sigiptinqa, ancha kushikuni. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Chaymi mas alli kanman, noqata dijawashpa, paytana masta siginambaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Chay runa syilumanda shamuqqam tukuy runakunamanda mas baliq. Piru suq runa kay pachamandalla shamuqqam kay pachapalla. Chaymi kay pachapa kusasningunapaq yach'achikun. Piru chay syilumanda kaqqam yumbay runakunamanda mas pudirniyuq. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Chaymi payqa syilupi rikashqanda, uyashqanda yach'achikun. Piru tukuy chaykunata yach'achiptimbismi, ancha achka runakuna mana kriyinllapachu paytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Piru paypi kriyiqkunaqam allita yach'anllapa: Tayta Dyusqam mana llullakunchu. Chaqa pay nishqanqam tukuy ima allip, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Taytanchiq Dyusqam Churinda syilumanda kach'amushpa, Santu Ispiritunda qon, tukuy imapi ancha allita yanapanan. Chaymi payqa Tayta Dyus rimashqandalla yach'achikun. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tayta Dyusqam Churinda ancha kuyan. Chaymi paypa makimbi rurashqa tukuy runakunata, warmikunata, tukuy ima kaqta, yumbayta kamachinambaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Chayraykum Taytanchiq Dyuspa Churimbi yuyakuqkunaqa tukuy tyimpu rinllapa kawsaq. Piru paypi mana yuyakuyta munaqkunaqam mana rinllapachu tiyaq syilupiqa. Ashwanmi Tayta Dyusqa ancha rin kastigaq paykunataqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farisiyu duktrinayuqkunam yach'arqanllapa: Chay Jisusqash Jwan Shutichikuqmanda mas achka runakunata shutichiykan, yach'achiykan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Piru manam Jisus kikinchu shutichikurqanqa. Ashwan noqaykuna yach'akuqningunam shutichikurqayqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Chaymi Jisusqa chay farisiyukuna parlashqanda yach'ashpa, (noqaykuna yach'akuqningunata apawashpa), prubinsya Judiyamanda lluqshirqanna, prubinsya Galiliyamanna rinambaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Chay Galiliyaman ch'ayanayllapaqam, prubinsya Samaryata pasaykarqayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Chaymi riqshinaqa chay prubinsya Samaryapa Sikar llaqtanman ch'ayarqayllapa. Chay llaqtaqam kidan chay unay Jusipa ch'akramba ladumbi. Chay ch'akrandaqam ch'askishqa karqan taytan Jakubumanda. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Chay Sikar llaqtapim ancha unay tyimpukunapi chay alma Jakubu suq pusuta rurashqa karqan. Chaymi Jisusqa riqshina shaykushpa, chay pusupa ladumbi samarqan. Chay urasqam larrdusinach'i karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Chaymi noqaykuna yach'akuqninqa chay pusupa ladumbi Jisusta dijashpa, chay Sikar llaqtaman rirqayllapa, mikunata randiq. Chaykamanqam suq samaryana warmi Sikarmanda lluqshishpa, chay pusuman rirqan yakupaq. Chaymi Jisusqa chay warmitaqa nirqan: —Warmisita, qowayri yakituta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Chaymi chay warmiqa nirqan: —Qam isrraylinu kashpaqa, ¿imashinataq noqa samaryana warmitaqa niwangi: “Yakuta qoway”, nishpaqa? Chaqa isrraylinukunaqam samaryanu kaqkunawanqa mana tandakaqllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Chayshina niptinqam, Jisusqa nirqan: —Taytanchiq Dyusmi suq ancha shumaq rrigaluta munan qoshuyta. Chaymi qam noqata riqsiwashpa: Kay runam Dyusmanda shamushqa, nishpaqach'i, kawsachikuq yakuta mañawanaykita qoshunaypaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Chayshina Jisus niptinqam, chay warmiqa nirqan: —Taytitu, kay pusuqam ancha jundu. Manam nimayuqchu kangi, surqonayki chay kawsachikuq yakutaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Qamqam mana mas baliqchu kangi chay punta agwilunchiq Jakubumandaqa, ¿manachu? Chaqa paymi qowashqallapa kay pusutaqa. Pay kikinmi wambrangunawan, animalningunapis kay pusumanda yakutaqa upyaqllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Chaymi Jisusqa nirqan: —Kay pusumanda mayqan upyaqqam rin yakunariq. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Piru noqa qoshqayta mayqan ch'askiwaqqam, alabis manana rinchu yakunaq. Chaqa chay qoshqayqam shunqombiqa suq pukyushina rin kaq. Chay pukyu layamandam ancha achka yakushina rin lluqshiq, tukuy tyimpu kawsanambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Chaymi warmiqa nirqan: —Taytitu, qowayri chay laya yakuta, amana yakunanaypaq, ni kayman shamunaypaq yakupaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Chaymi Jisusqa nirqan: —Riy apamuy qosaykita, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Chaymi warmiqa nirqan: —Manam qosayuqchu kani, nishpa. Chaymi Jisusqa nirqan: —Alliptam niwashqa kangi: “Manam qosayuqchu kani”, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Chaqa sinku kutindam kasarashqa kangi. Piru kananqam chay mushuq runaykiqa mana ni lijitimu qosaykichu. Chaymi allip kaqta niwashqaqa kangi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Chayshina niptinqam, chay warmiqa nirqan: —Taytitu, qamqachumash' Dyuspaq rimaq kangi. Chaymi kayta munani tapushuyta: ");
INSERT INTO qvcNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Unay agwiluy samaryanukunam kay altu lumaman shamushpa, Dyusta aduraqllapa. Piru qamkuna isrraylinukunaqam ningillapa: “Jirusalimbilla Dyustaqa adurashunllapa”, nishpa. (Chaymi tapuyki: ¿Mayqan lugarpim mas allin adurananchiq? nishpa.) ");
INSERT INTO qvcNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Chaymi Jisusqa chay warmita nirqan: —Warmisita, kay nishushqayta kriyiway; Rinmi ch'ayamuq tyimpu, mana ni kay lumaman shamushpa, ni Jirusalinman rishpa, qamkuna Dyusta aduranaykiqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Qamkuna Samaryamanda kaqkunaqam mana yach'angillapachu: Pitam aduranillapa, nishpaqa. Piru noqaykuna isrraylinukunaqam yach'anillapa: Pitam aduranillapa, nishpa. Chaqa Dyus Akrashqan Washadurqam Isrrayilmanda shamun. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Piru kananqam Dyuspi yuyakuqkunaqa tukuy shunqo payta allipta aduranqallapa, paypa Santu Ispiritun yanapaptin. Chaqa Tayta Dyusqam munan, yumbayniki chayshina paytalla aduranaykillapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Taytanchiq Dyusqam mana kwirpuyuqchu. Ashwanmi suq ispiritu. Chayri payta aduraqkunaqa mana rikashpapis, tukuy shunqo, tukuy ispiritunwan allipta aduranqallapa, Dyuspa Santu Ispiritun yanapaptin. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Chaymi chay warmiqa Jisusta nirqan: —Noqaqam yach'ani: Dyus Akrashqan Washadurmi rin shamuq. Payllam Misiyaspis shutin. Shamushpam, tukuy imata ancha klaruta rin yach'achiwaqninchiq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Chaymi Jisusqa payta nirqan: —Noqa qamwan parlaqmi chay Washadurqa kani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Chaymandaqam noqaykuna yach'akuqninqa Jisus kaykashqanman ch'ayashpaqa, tarirqayllapa suq warmiwan parlaykaqta. Chaymi ancha ispantashpa yuyarqayllapa: ¿Imata munashpam, chay samaryana warmiwanqa parlaykan? ¿Imapaqraq parlaykan? nishpa. Piru manam ni mayqanniypis almitikarqaychu tapuqqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Chaymandaqam chay warmiqa puyñunda dijashpa, llaqtanman yaykurqan, llaqta masingunata kayshina abisaq: ");
INSERT INTO qvcNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Akullapa rikaq suq runata. Chaqa payqam tukuy ima rurashqayta niwashqa. ¿Manachuraq pay Dyus Akrashqan Washadurqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Chaymi llaqta masingunaqa lluqshishpa, shamurqanllapa Jisusman. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Paykuna shamunangamanqam, noqaykunaqa Jisusta kayshina rrugarqayllapa: —Yach'achikuq Taytitu, kayta mikuy, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Piru Jisusqam niwarqanllapa: —Noqapaqam kan suq laya mikunay. Chaypaqqam mana yach'angillapachu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Chaymi noqaykuna suqniy suqniy kayshina parlarqayllapa: —¿Piraq apamushqa mikunandaqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Chaymi Jisusqa noqaykunata niwarqan: —Taytay Dyusmi tariyayta qowashqa, pay munashqanda ruranaypaq ushyanaykaman. Chay tariyaymi noqapa mikunayshinaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Qamkunaqam ningillapa: “Ch'usku killaraqmi faltan, syiga tyimpu ch'ayamunambaqqa”, nishpa, ¿manachu? Piru noqaqam niykillapa, tukuy laduman chapakushpa, intyindiyllapa: Achka runakuna, warmikunam listuna, noqapi yuyakunanllapa. Chaymi suq tarpudushina qarwamushqana kusichananchiqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Kusichapi trabajaqqam pagunda ch'askin, ¿manachu? Chayshinallam Dyuspaq yach'achikuqkunapis Dyusmanda pagunda rin ch'askiq. Dyuspi kriyiqkunam chay tandashqan granukunashinaqa. Chay kriyiqkunaqam tukuy tyimpu rinllapa kawsaq. Chaymi chay puntata yach'achiqkunaqa, chay ikita yach'achiqkunawan pulla rinllapa kushikuq. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Chaymi chay unay nishqanshina allipta kayshina niykillapa: “Suqmi tarpukun, suqmi kusichakun”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Chayshinallam suq runakuna noqapaq puntata yach'achikushpam, tarpukuqshina kashqallapa. Piru kanan qamkuna noqapaq masta yach'achikuptikim, noqapi kriyiptinllapaqam, alabis suq tarpukushqanda qamkunaqa kusichaykangi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Chay warmiqam llaqta masin samaryanukunawan parlaykarqan, “Chay runaqam tukuy ima rurashqayta niwashqa”, nishpa. Chaymi achka llaqta masinguna Jisuspi kriyirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Chay samaryanukunam shamushpa, Jisusta rrugarqanllapa, chay llaqtambi kidanambaq. Chaymi ishkay diyata chaypi kidarqayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kanan Jisusta uyashpaqam, mas samaryanukuna paypi kriyirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Chaymandaqam chay warmitaqa kayshina nirqanllapa: —Puntatam Jisuspi kriyirqayllapa, qam paypaq niwashqaykirayku. Piru kananqam noqaykuna kikiyna paytaqa uyashqallapa kani. Chaymi mas allitana yach'anillapa: Allibraq payqa yumbaypa Washadurninchiq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ishkay diyamandam Jisusqa noqaykunawan chay prubinsya Samaryamanda rishpa, prubinsya Galiliyamanna ch'ayamurqayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Paymi kayshina niwashqallapa karqan: “Dyuspaq rimaqtaqam kikin llaqta masingunaqa mana rrispitanllapachu”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Piru chay llaqta masin galiliyanukunaqam Jirusalimbi Paskwa fyistapi kashqallapa karqan. Chaymi Jisus chay fyistapi achka milagrukunata ruraptin, rikashqallapa karqan. Chaymi Galiliyaman ch'ayaptiyllapa, paykunaqa allita ch'ayachiwarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Chaymandaqam Jisusqa noqaykunawan chay prubinsya Galiliyapa Kaná llaqtanmanna kutimurqayllapa. Chay Kanapim Jisusqa yakuta binupaq tikrashqa karqan. Piru chaypi kaykaptiyllapam, gubyirnupa suq yanapakuqnimba churin ancha qeshyaq karqan Kapirnawun llaqtapi. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Chayshina qeshyaq kaptinqam, chay kamachikuq runaqa Jisuspaq yach'arqan: Judiyamandash kay prubinsya Galiliyaman ch'ayamushqa, nishpa. Chaymi payqa shamushpa, Jisusta chaypi tarishpa, ancha rrugarqan, Kapirnawunman rinambaq, churinda kach'akachiq. Chaqa churinqam anchayashpa, wañuykarqanna. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Chaymi Jisusqa payta nirqan: —Mana rikashpa siñakunata, milagrukunataqam, mana kriyiqllapachu ringi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Chaymi chay kamachikuq runaqa Jisusta nirqan: —Taytitu, akur das, wambray ama wañunambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Chaymi Jisusqa nirqan: —Riyna wambraykita rikaq. Payqam kach'akashqana. Mananám rinchu wañuq, nishpa. Chayraykum chay runaqa Jisus nishqanda kriyishpa, llaqtanmanna rirqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Yaqqana ch'ayaykaptinqam, kriyadunguna shamurqan chay runata tinguq. Chaymi tingushpaqa, nirqanllapa: —Churikiqam kach'akashqana. Mananám rinchu wañuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Chaymi kriyadungunataqa tapurqan: —¿Ima urasmi kach'akarqanqa? nishpa. Chaymi kriyadungunaqa nirqan: —Qayna a la una di la tardim jibriqa dijarqan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Chaymi chay kamachikuq runaqa intyindirqan: Chay urasmi Jisusqa niwarqan: “Churikiqam kach'akashqana. Mananám rinchu wañuq”, nishpa. Chaymi payqa yumbay ayllundin Jisuspina kriyirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Chayshina prubinsya Judiyamanda kutimushpam, chay milagru rurashqanwanqa, Jisusqa ishkay milagrutana rurashqa karqan prubinsya Galiliyapiqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Chaymandaqam Jisusqa Jirusalinmanna rirqan, llaqta masin isrraylinukunapa suq fyistanman. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Chay Jirusalin llaqtapa suq yaykunanmi “Wisha pungu” shutin. Chay pungupa ladumbim kan suq pusu. Chay pusuqam ibriyu rimaypiqa Bitisda shutin. Chay pusuqam sinku kurridurniyuq. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Chay pusupa ladumbim qeshyaqkuna, mana rikakuqkuna, kujukuna, wañushqashina kwirpuyuqkuna, usurashpa ˻shuyakuykarqanllapa, chay pusupi yaku kuyunangaman. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Chaqa Dyuspa suq anjilninmi tyimpun tyimpun shamushpa, chay pusupi kaq yakuta kuyuchiq. Chaymi mayqan qeshyaq chay pusuman puntata yaykuqqa chay qeshyayninmanda kach'akarqan, ima laya nanayniyuq kashpapis.˼ ");
INSERT INTO qvcNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Suq runa chay pusupa manyambi kaqmi 38 watas tukuyta qeshyaqlla karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jisusqam chay runata usuraykaqta rikashpaqa, yach'arqan achka watakunata qeshyaqlla kashqanda. Chaymi tapurqan: —¿Munangichu kach'akayta? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Chaymi chay qeshyaqqa nirqan: —Taytitu, manam pipis kanchu kay yakuman yaykuchiwanambaq kuyushqan urasqa. Chaymi kada kuyuptin, ñakanaykaman, suqkuna binsiwashpa, das yaykun yakumanqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Chayshina niptinqam, Jisusqa nirqan: —Atarishpa, paraykita tandashpa, apashpa, puriyna, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Chaymi chayta niptinlla, chay runaqa qeshyayninmanda kach'akashpa, paranda tandashpa, apashpa, rirqanna. Piru chay kach'akachishqan diyaqam samana diya karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Chaymi isrraylinukunapa wakin kamachikuqninqa chay runa kach'akashqata anyarqanllapa: —Kananqam samana diya. Manam allichu paraykita apanaykiqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Chaymi chay runaqa nirqan: —Kach'akachiwaq kikinmi kamachiwashqa: “Paraykita tandashpa puriyna”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Chaymi chay anyaqkunaqa tapurqanllapa: —¿Pitaq kamachishushqa, paraykita tandashpa rinaykiqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Piru chay runaqam mana yach'arqanchu: Pim kach'akachiwashqa, nishpaqa. Chaqa Jisusqam chay achka runakunamanda das akrakashpa, suq lugarmanna rishqa karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Chaymandaqam Jisusqa chay kach'akachishqan runata Dyuspa adurana wasimbi tarishpa, nirqan: —Allita uyaway, kaykish kach'akashqana kangi. Piru uchakunataqa amana rurariychu, ama masta ñakanaykipaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Chayshina Jisusta riqsishpaqam, chay runaqa chay kamachikuqkunaman rishpa, nirqan: —Jisusmi chay kach'akachiwaqqa kashqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Chaymi Jisus chayshina samana diyapi rurashqanrayku, chay kamachikuqkunaqa ancha kuntrashpa, yuyarqanllapana wanchiyta. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Piru Jisusqam paykunataqa nirqan: —Taytay Dyusmi kanangaman tukuy imata kwidaykan. Chayshinam trabajaykan. Chayraykum noqapis runakunata kwidashpa, kach'akachishpa trabajaykani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Chayta niptinqam, chay kamachikuq isrraylinukunaqa ashwamba munarqanllapa wanchiyta. Chaqa Jisusqa paykunapa liyninda mana kasushpam, samana diyapi trabajarqan. Kayshinapismi nirqan: “Dyusmi Taytay”, nishpa. Chaymi paykunaqa yuyarqan: Yanqam Dyus tukuykan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Chaymandaqam Jisusqa chay kuntraqkunata nirqan: —Alliptam niykillapa, noqa Dyuspa Churin kashpam, mana nimatapis noqa munashqaytaqa ruranichu. Ashwanmi Taytay rurashqanda rikashpa, chay layatalla noqapis rurani. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Taytayqam kuyawan. Chaymi tukuy ima rurashqangunata rikachiwan. Piru mas ispantaypaq kusaskunatam rin rikachiwaq. Chay rikachiwashqanda ruraptiyqam, qamkunaqa ancha ringillapa ispantaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Chaqa Taytayqam wañuqkunata kawsachin. Chayshinallam noqapis munashpa, mayqandapis atini kawsachiyta. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Taytay Dyusqam mana pitapis jusganchu. Payqam noqata numbrawashqa juyis kanaypaq, yumbayta jusganaypaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Chayshinam numbrawashqa, runakuna alabawanambaq, payta alabashqanshina. Piru mayqan runa mana baliqpaq riqsiwashpaqam, chay kach'amuwaq Tayta Dyustapis mana baliqpaq riqsiykan. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Alliptam niykillapa, mayqan runa nishqayta kasuwashpa, kach'amuwaq Taytaypi yuyakushpaqam, tukuy tyimpu rin kawsaq. Payqam manana sintinsyaduchu rin kaq, kastigadu kanambaqqa. Ashwanmi payqa wañunambaq kashqanmanda pasashqana suq laya bidaman, tukuy tyimpu kawsanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Alliptam niykillapa, Dyusta mana kasuqkunaqam wañushqa layashina. Piru kay tyimpumandapacham chay wañushqa layakunaqa noqa Dyuspa Churinda rinllapa uyawaq. Uyawashpa kasuwaqkunallam tukuy tyimpu rinllapa kawsaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Chaqa Tayta Dyus kikinmi yumbay kawsaqkunata kawsachin. Chayshinallam noqa Churindapis pudirninda qowashqa, kawsachikunaypaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Dyusmanda Shamuq Runam kani. Chaymi payqa juyispaq numbrawashqa, runakunata jusganaypaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Piru kayta uyashpaqa, ama yuyayllapachu: ¿Imashinaraq kanqa? nishpaqa. Chaqa suq diyam rin ch'ayamuq, wañuqkuna busniyta uyashpa ");
INSERT INTO qvcNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","kawsamunanllapa. Kanan allita ruraqkunaqam rin kawsamuq, tukuy tyimpu kawsanambaqllapa. Piru chay mana allita ruraqkunaqam rinllapa kawsamuq, kastigadu kanambaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Noqaqam sapalitayqa mana nimatapis atinichu rurayta. Ashwan Taytay Dyus niwashqanshinallam jusgakuni. Chaqa chay Taytay kach'amuwaq munashqanshinallam tukuy imata rurani; manam noqa munashqaytaqa. Chaymi ancha kabalta justisyata rurani. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Manam noqapa faburniytachu rimani. Noqalla faburniyta rimaptiyqach'i, mana balinmanchu. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Piru suq tistigupismi faburniytaqa riman. Kanan allitam yach'ani chay tistugupaqqa. Payqam noqapaqqa allip kaqtalla riman, nishpa. (Chaqa chay tistiguqam Taytay Dyus.) ");
INSERT INTO qvcNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Kanan qamkunaqam suqkunata kach'arqaykillapa, Jwan Shutichikuqta tapuq. Chaymi paypis allip kaqta noqapaq rimarqan. Manam llullakurqanchu. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Piru noqaqam mana nisitanichu, runakuna faburniyta rimanambaqqa. Qamkunallam chayshinaqa yuyangillapa. Chaymi chay Jwan Shutichikuq nishqanda niykillapa, noqapi kriyiptiki, washashunayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Chay Jwan Shutichikuqqam Dyuspaq allip kaqta yach'achishushpa, qamkunapaqqa suq michashina karqan. Chaymi paymanda yach'akushpaqa, qamkunaqa suq tyimpitupaq kushikushpa kawsarqaykillapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","’Chayshina Jwan noqapaq yach'achikuptinmi, atingillapa yach'ayta: Pim Jisukristu, nishpa. Piru Taytay Dyus yanapawaptin tukuy ima munashqanda ruranaypaqqam, mas allita atingillapa yach'ayta: Tayta Dyusmi Jisusta kach'amushqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Chaqa Taytanchiq Dyuspismi kach'amuwashpa, noqapaq rimashqa. Piru qamkunaqam chay rimashqandaqa mana uyashqallapachu kangi, ni payta rikashqallapachu kangi. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Kanan pay kach'amuwaptinmi, qamkunaqa noqapiqa mana kriyirqaykillapachu. Chaymi Dyus nishqandaqa mana kasushqallapachu kangi. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Qamkunaqam Dyuspa Santu Librunmandaqa ancha allita yach'akungillapa, yuyashpa: Chayta yach'akushpam, tukuy tyimpu rinchiq kawsaq, nishpa. Kanan chay Santu Libruta liyishpam, ringillapa yach'akuq noqapaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Piru qamkunaqam mana munangillapachu noqaman shamuyta, tukuy tyimpu kawsanaykillapaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Manam munanichu, qamkuna alabawanayki. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Chaqa noqaqam qamkunataqa riqsiykillapa: Dyustaqam mana kuyangillapachu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Noqaqam, Taytay kach'amuwaptin, paypa rrimplasun shamushqa kani. Piru qamkunaqam mana kasuwangillapachu. Piru suq runa shamushpa, pay munashqandalla yach'achishuptinqam, das kasungillapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kanan qamkunapura ancha alabanakungi. Piru manam munangillapachu sapalan Tayta Dyus alabashunanqa. Chayshina kashpaqa, ¿imashinataq ringillapa kriyiwaqqa? ");
INSERT INTO qvcNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Kayta yach'ayllapa: Awnki qamkuna fyirusyawaptikiqam, mana rinichu shimbishuq Taytaypiqa. Ashwanmi Muysis rin shimbishuqllapa: “Ancha malutam rurashqa kangi”, nishpa. Piru qamkunaqam Muysispi ancha yuyakungillapa: Paymi rin yanapawaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Chaymi Muysis iskibrishqanda allipta kriyishpaqa, noqatapis kriyiwangimanllapa. Chaqa paymi noqapaqqa kayshina iskibrirqan: “Dyusmi Washadurninchiqta rin kach'amuq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Piru Muysis librungunapi iskibrishqanda mana kriyishpaqam, ¿imashinataq nishushqaytaqa ringillapa kriyiwaq? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Jisusqam chayshina yach'achikushpa, ushyashpaqa, noqaykunawan rirqan chay ancha atun qoch'a Galiliyapa suq ladu chimbanman. Chay atun qoch'a Galiliyallam Tibiryaspis shutiq. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Chay rishqanmanmi ancha achka runakuna, warmikuna ikinda rirqanllapa. Chaqa Jisukristu qeshyaqkunata kach'akachiptinmi, paykunaqa rikashqallapa karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Chayshina Jisusta sigiptinllapam, payqa noqaykuna yach'akuqninwan rirqayllapa suq filaman. Chay filapim tiyarqayllapa samaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Chay diyakunapiqam noqaykuna isrraylinukunapa Paskwa fyistayllapa ch'ayamuykarqanna. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Kanan Jisusqam rridurninman chapakushpa, rikarqan chay achka runakuna, warmikuna payman shamushqanda. Chaymi Filipita tapurqan: —¿Maymandam atinchiq tandata randiyta, yumbay kaypi kaqkunata qarananchiqqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Chayshinaqam nirqan, Filipita mallipananrayku. Piru Jisusqam yach'arqanna: Noqam rini qaraq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Chayshina tapuptinmi, Filipiqa Jisusta nirqan: —Ni 200 dinaryukunawan ancha achka tandata randiptinchiqpis, mana aypanmanchu ni ashlita ashlita qarananchiq yumbay kaypi kaqkunata, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Chay Simun Pidrupa masan Andrispismi Jisuspa suq apustulnin karqan. Paymi kayshina nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Kaypim suq wambra sibadamanda sinku tanditayuq, ishkay piskadituyuq. Piru ¿chaysitullaqa aykamir aypanqa kaypi yumbay kaqkunapaqqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Chaymi Jisusqa noqaykuna yach'akuqninda kayshina niwarqanllapa: —Yumbay kaykunata tiyachiyllapa, nishpa. Chay lugarpiqam ancha qewa karqan. Chaymi yumbay chay runakuna, warmikuna, wambrakunaqa chay qewakunapi tiyarqanllapa. Paykunaqam 5.000ch'i ullqokunalla karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Chaymandaqam Jisusqa chay wambrapa tanditangunata piskashpa, Dyusman pagikushpa, noqaykuna yach'akuqninda qowarqanllapa, noqaykunana chaypi yumbay kaqkunata qonaypaqllapa. Chayshina rurashpam, chay ishkay piskaditutapis qowarqanllapa, chaypi yumbay kaqkunata qorinayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Chaymi yumbay mikushpa undaptinllapaqa, noqaykunata niwarqanllapa: —Subrashqan pidasukunata tandayllapa, ama nimapis qesachakanambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Chaymi noqaykunaqa chay sinku tanditakunamanda subrashqan pidasukunata tandashpaqa, dusi kanastas tukuyta undachirqayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Chayraykum chaypi kaqkunaqa Jisukristu chay milagru rurashqanda rikashpaqa, nirqanllapa: —Manchu unay tyimpukunapi Tayta Dyus ufrisirqan kach'amuyta suq ancha pudirniyuq rimaqta kay munduman. Allibraq kay Jisusqa chay ancha pudirniyuq rimaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Piru Jisusqam kwintata qokarqan: Kay runakunam piskawashpa, amalas rinllapa numbrawaq gubyirnumbaq, nishpa. Chaymi paykunamanda akrakashpa, suq lumapa sawanman rirqan, chaypi sapalan kanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Amsayaykaptinnam noqaykuna yach'akuqninqa chay Galiliya Atun Qoch'aman urangumurqayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Chaymi chay atun qoch'aman ch'ayashpaqa, yakupi puriq barkupi riykarqayllapa Kapirnawun llaqtaman. Nuta: Chay Kapirnawunqam chay atun qoch'apa suq ladu chimbambi karqan.  Chay riykashqayllapa urasqam tutana karqan. Piru Jisusqam manaraq noqaykunamanqa shamushqachu karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Chayshina riykaptiyllapam, ancha jwirtita wayrarqan. Chaymi chay atun qoch'api yakuqa waqman, kayman maqchikarqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Chaymi chay barkupa kumsanan palangunawan sinku ichu sayis kilumitrustana rishqallapa karqay. Chayshina chay atun qoch'apa ch'awpimbi kashpaqam, Jisusta rikarqayllapa, chay yakupa sawanda purishpa, noqaykunaman ch'ayaykaqtana. Chaymi noqaykunaqa ancha mancharqayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Piru Jisusqam niwarqanllapa: —¡Amar manchayllapachu; noqam kani! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Chaymi noqaykunaqa kushikushpa, Jisusta nirqayllapa: —Kay barkuman shamuy, nishpa. Chaymandaqam dasituna ch'ayarqayllapa chay chimba Kapirnawunmanqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Chaymi qayandinqa chay ancha achka runakuna, warmikuna chay suq chimbapi kidarqanllapa. Jisusta maskashpam, yuyarqanllapa: Chishiqam suq barkulla kaypiqa karqan. Chay barkupiqam Jisuspa yach'akuqningunalla rirqan. Piru Jisusqam mana rirqanchu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Chay tutamandam Tibiryas llaqtamanda wakin barkukuna ch'ayarqan chay 5.000 runakuna mikushqan lugarpa ladunman. Chaypiqam Jisukristu Dyusta pagikushpa, paykunata qarashqa karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Chaymi chay chimbapi mana tariwashpa ni Jisusta ni noqaykunata, achka runa, warmikunaqa Jisusta maskashpa, chay barkukunapina shamurqanllapa Kapirnawun llaqtamanna. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Chay maskawaqkunaqam chay chimba Kapirnawunman ch'ayamushpaqa, chaypi Jisusta tarirqanllapa. Chaymi kayshina tapurqanllapa: —Yach'achikuq Taytitu, ¿ima urastaq kaymanqa ch'ayamurqayki? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Chaymi Jisusqa paykunata nirqan: —Alliptam niykillapa, qamkunaqam sigiwangillapa; piru manam intyindingichu chay milagrukuna rurashqaytaqa. Ashwanmi tandata unda mikushpa sigiwangillapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Amar trabajayllapachu ushyakaq mikunapaqllaqa. Ashwan trabajayllapaqa tukuy tyimpu kawsachikuq mikunapaq. Chay kawsachikuq mikunatam noqa Dyusmanda Shamuq Runaqa rini qoshuqllapa. Chaqa Taytanchiq Dyusqam yanapawan, milagrukunata ruranay, yumbayniki yach'anaykillapa: Jisusmi Tayta Dyusmanda shamushqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Chayshina niptinmi, paykunaqa tapurqanllapa: —¿Imatam atinillapa rurayta, Dyus munashqanda ruranayllapaqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Chayshina tapuptinllapaqam, Jisusqa nirqan: —Tayta Dyusmi kach'amuwashqa, qamkunaman shamunaypaq. Chaymi munan noqapi kriyinaykillapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Chayshina niptinmi, paykunaqa tapurqanllapa: —¿Ima laya milagrutam atingi rurayta, chayta rikashpa, qambi kriyinayllapaqa? ¿Mayá, imatam ringi ruraq? ");
INSERT INTO qvcNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Chaqa unay agwilunchiqkunam chuncha lugarkunapi Dyus kach'amushqan manaya mikunata mikurqanllapa. Chay mikunapaqmi Dyuspa Santu Librumbiqa kayshina nin: “Taytanchiq Dyusmi syilumanda tandata paykunata qararqan”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Chaymi Jisusqa nirqan: —Alliptam niykillapa, Muysisqam mana qorqanchu agwilunchiqkunata syilumanda shamuq tandataqa. Ashwanmi Taytay Dyusqa paykunata qararqan. Kananmi payqa munan qoshuyta syilumanda shamuq allip kaq tandata. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Syilumanda chay kawsachikuq tandaqam suq runa. Chaqa payqam syilumanda shamushpa, yumbay runakunata tukuy tyimpupaq atin kawsachiyta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Chayshina niptinqam, paykunaqa nirqanllapa: —Chay laya tandataqar tukuy diya qowayllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Chaymi Jisusqa paykunata nirqan: —Noqam kani chay kawsachikuq tandaqa. Chaymi noqapi kriyiqqa mana nunka rinchu mallaqnaq shunqombiqa. Kanan noqapi yuyakuqqam manana nima tyimpu rinchu yakunaqpis shunqombiqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Piru nishushqayshina, qamkunaqam rikawashpapis, mana kriyingillapachu noqapiqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Piru Taytay qowashqan runakuna, warmikunaqam noqapi yuyakunllapa. Chaymi mana pitapis disprisyashpachu, noqapi yumbay yuyakuqkunata shumaqta rini ch'ayachiq. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Chaqa noqaqam syilumanda shamushqa kani, Taytay munashqanda ruranaypaq; manam noqa munashqaytachu. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Tayta Dyus kach'amuwaqmi munan chay qowashqan runakunata allita kwidanaypaq, ama ni suqnin chinganambaq. Ashwanmi munan jwisyu diyapi kawsachinaypaq, tukuy tyimpu kawsananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Chaqa Taytay kach'amuwaqmi munan mayqambis noqapi yuyakuqtaqa washashpa, tukuy tyimpu kawsachinaypaq. Chaymi noqaqa paykunata rini kawsachimuq jwisyu diyapi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jisukristu yach'achikuptin: “Noqam syilumanda shamuq tandaqa kani” niptinqam, achka isrraylinukuna piñakushpa, kayshina rimatikurqanllapa: ");
INSERT INTO qvcNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","—Kay Jisusqam Jusipa churin. Taytanda mamandaqam riqsinchiq, ¿manachu? Chayshinaqa ¿imaraykum nin: “Syilumandam shamushqa kani”, nishpaqa? ");
INSERT INTO qvcNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Chaymi Jisusqa paykunata nirqan: —Ama chayshinaqa rimatikuyllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Manam pipis atinchu pay kikinlla noqapi yuyakuytaqa. Ashwan Taytay kach'amuwaqmi yanapan runakunata, noqapi kriyinanllapa. Kanan noqapi kriyiqtaqam chay jwisyu diyapiqa rini kawsachiq. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Dyuspaq rimaqkunapa librungunapiqam kayshina nin: “Dyusqam yumbayta rin yach'achiq”, nishpa. Chaymi Taytanchiq Dyusta yumbay uyaqkuna, paymanda yumbay yach'akuqkunaqa noqapi yuyakunllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Manam pipis Tayta Dyustaqa rikashqachu. Noqa paymanda shamuqllam paytaqa rikashqa kani. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Chaymi allipta niykillapa, noqapi yuyakuqqam mushuq bidayuqna, tukuy tyimpupaq kawsanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Chaqa noqam kawsachikuq tandaqa kani. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Chay unay agwilunchiqkunaqam chuncha lugarkunapi mikurqanllapa Dyus kach'amushqan manaya mikunata. Chayshina mikushpapismi, tukuy tyimpuqa mana kawsarqanllapachu. Ashwanmi wañurqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Piru syilumanda shamuq tandaqam suq laya. Chaymi kay laya tandata mikuqkunaqa mana wañunqallapachu. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Kanan noqam kani chay syilumanda shamushqa kawsachikuq tandaqa. Chaymi mayqan kay tandata mikuqqa tukuy tyimpu rin kawsaq. Kay kwirpuymi chay kawsachikuq tandaqa. Chaymi noqa rini wañuq, runakunata, warmikunata washanaypaq, tukuy tyimpu kawsananllapaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Chay isrraylinukunaqam chayta uyashpaqa, piñakushpa, suqnin suqnin kayshina parlarqanllapa: —Kay runaqa ¿imashinam kwirpundaqa qarawashunllapa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Chaymi Jisusqa paykunata nirqan: —Alliptam niykillapa, kay kwirpuyta mana mikuptikillapa, yawarniyta mana upyaptikillapaqam, maychikapis mana ringillapachu kawsaq tukuy tyimpupaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Piru kwirpuyta mikuq, yawarniyta upyaqqam mushuq bidata ch'askin, tukuy tyimpupaq kawsanambaq. Chay mikuqtaqam noqaqa jwisyu diyapi rini kawsachiq. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Chaqa kwirpuyqam allip mikuna; yawarniyqam allip upyana. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Chaymi kwirpuyta mikushpa, yawarniyta upyashpa noqapi yuyakuqqa noqawan kawsan. Noqapismi paywan kawsani. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Chaqa Taytanchiq Dyusmi kawsan. Paymi kach'amuwashpa, noqatapis kawsachiwan. Chayshinallam kwirpuyta mikuqtapis noqa rini kawsachiq. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kay kwirpuymi chay tanda syilumanda shamuqqa. Allita yach'ayllapa: Chay unay agwilunchiqkuna Dyus kach'amushqan manaya mikunata mikushpapismi, mana kawsarqanllapachu tukuy tyimpupaqqa. Ashwanmi yumbay wañurqanllapa. Piru kanan kay qoshushqay tandata mikuqkunaqam tukuy tyimpupaqna rinllapa kawsaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisusqam chayshina yach'achikurqan Kapirnawun llaqtapa sinaguga wasimbi. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Chayshina Jisus yach'achikuptinmi, payta achka sigiqkunaqa suqnin suqnin kayshina parlarqanllapa: —Manam ni ashlita gustawanchu kay yach'achikushqanqa. Mayá, ¿piraq chay layakunataqa atinman kasuytaqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Piru chayshina uyaritap parlaptinllapapismi, Jisusqa allita yach'arqan. Chaymi chay rimaqkunataqa kayshina tapurqan: —¿Chay nishushqaypaqchu piñakungillapa? ");
INSERT INTO qvcNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Noqaqam Dyusmanda Shamuq Runa kani. Chaymi syiluman kutiriptiy, rikawashpaqa, ¿imataraq yuyangimanllapa? ");
INSERT INTO qvcNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Dyuspa Santu Ispiritunllam yumbanda kawsachin. Piru runakunallaqam mana nimatapis atinchu kawsachikuytaqa. Chaymi Dyuspaq yach'achiykillapa, chay nishushqayta kriyiptikillapa, Dyuspa Santu Ispiritun qamkunaman shamushpa, tukuy tyimpupaq kawsachishunanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Piru wakinnikiqam noqapiqa manaraq kriyingillapachu, nishpa. Chaqa qallarishqan diyamandapacham Jisusqa yach'arqanna: Mayqan runakunam noqapiqa mana rinllapachu kriyiq. Paykunamanda suqninmi noqataqa rin intrigakuwaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Chaymandaqam nirqambis: —Chayraykum nishushqallapa kani: “Manam pipis pay kikinllaqa atinchu noqapiqa kriyiyta. Ashwanmi Taytay Dyus animachiptin, noqapi atin kriyiytaqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Chaymi chay diyamandapacha paywan achka puriqkunaqa, yach'achikushqanda mana gustashpachu, paymanda akrakashpa, manana purirqanllapachu paywanqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Chaymi noqaykunata dusi yach'akuqninda tapuwarqanllapa: —¿Qamkunapischu noqamanda munangillapa akrakayta? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Chaymi Simun Pidruqa nirqan: —Taytitu, qamanda akrakashpaqa, ¿pimannamiri rishaqllapa? Chaqa qamllam yach'achiwangi, suq bidapi tukuy tyimpu kawsanayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Kay noqaykunaqam qambi yuyakushqallapa kani. Chaqa yach'anillapam: Qam Dyus Akrashqan Washadurqa kangi. Tayta Dyuspa Churinmi kangi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Chaymi Jisusqa niwarqanllapa: —Qamkuna dusitam akrashushqallapa kani. Piru suqnikiqam dyablupaq tikrakashqa kangi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Chayshinaqam Jisusqa nirqan Judas Iskaryutipaq. Chay Judaspa taytanqam Simun shutirqan. Nuta: Piru manam Simun Pidruchu karqanqa.  Chay Judasmi noqaykunamanda suqniy kashpapis, Jisusta intrigakunambaq karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Chaymandaqam Jisusqa prubinsya Galiliyapa llaqtangunapilla puriykarqan. Mananam munarqanchu prubinsya Judiyapi puriytaqa. Chaqa Judiyapiqam isrraylinukunapa kamachikuqninguna ancha munarqanllapa Jisusta wanchiyta. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Piru chay diyakunaqam arkacha wasikuna fyista sirkana karqan. Chaymi chay fyista ch'ayamuykaptinqa, ");
INSERT INTO qvcNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jisuspa masangunaqa payta yanqa nirqanllapa: —Kay prubinsya Galiliyamandaqa prubinsya Judiyaman riy, milagrukunata ruraptiki, waqpi qambi kriyiqkunapis chayta rikananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Chaqa mas famayuq munashpa kaytaqam, mana balinchu kay kasiriyukunapi pakakushpa, milagrukunata ruranaykiqa. Ashwanri Jirusalinman riy, yumbay runakunapa ñawpambi chay milagrukunata ruranayki, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Chayshinaqam burlashpa nirqanllapa. Chaqa manam ni masangunapis Jisuspiqa kriyirqanllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Chaymi Jisusqa masangunata nirqan: —Tayta Dyus siñalashqan tyimpuyqam manaraq ch'ayamushqachu. Piru qamkunaqam ima diyapis atingillapa riyta. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Chaqa Dyusta mana kasuqkunaqam qamkunataqa mana ch'iqnishungillapachu. Piru noqataqam ch'iqniwanllapa, mana alli rurashqangunapaq niptiy. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Chayri qamkunalla riyllapa waq fyistamanqa. Manaraqmi Dyus siñalashqan tyimpuyqa ch'ayamushqachu. Chaymi manaraq rinichu riq chay fyistamanqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Chayshina masangunata nishpaqam, payqa chay prubinsya Galiliyapilla kidarqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Chay masanguna chay fyistaman riptinqam, Jisuspis uyarapllana (uyarallana) Jirusalinmanqa rirqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Chaymi chay kuntraq isrraylinukunaqa Jisusta mana tarishpachu, chay fyistapiqa ancha maskarqanllapa: —¿Maypiraq chay runaqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kanan achka runakunaqam Jisuspaqqa uyaraplla (uyaralla) parlaqllapa. Wakinqam niqllapa: —Jisusqam ancha allin runa, nishpa. Piru wakinqam niqllapa: —Chay runaqam mana allinchu. Chaqa llaqta masinchiqkunatam ingañaykan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Piru Jisuspaq parlaqkunaqam, chay kamachikuqkunata manchashpa, mana nimatapis parlarqanllapachu suqkunapa ñawpambiqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Kanan ch'awpi fyistapina kaptinllapaqam, Jisusqa Dyuspa adurana wasinman rishpa, chaypi yach'achikurqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Chaymi chay kamachikuqkunaqa Jisusta uyashpaqa, ispantashqata kayshina nirqanllapa: —Kay runaqam mana ni suq yach'achikuqwan istudyashqachu. ¿Imashinataq ancha yach'ayniyuqqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jisusqam paykunata nirqan: —Kach'amuwaq niwashqandallam yach'achikuni; manam noqa yuyashqaytachu. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Chaymi mayqan runa Dyus munashqanda ruraqqa kay nishqaypaqqa atin yach'ayta: ¿Jisusqam Tayta Dyus munashqanda yach'achikuykan ichu pay munashqandalla yach'achikuykan? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Chaqa mayqan runa munashqandalla rimaqqam runa masin alabananraykulla yach'achikun. Piru Taytaymi noqataqa kach'amuwashqa, allip kaqtalla yach'achikunay. Chaymi ancha munani Taytay Dyusta yumban alabananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’¿Manachu Muysisqa Dyuspa liyningunata chay unay agwilunchiqkunata qorqan? Piru qamkunaqam mana munangillapachu kasuyta. ¿Imaraykutaq munangillapa wanchiwaytaqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Chaymi chay achka uyaqkunaqa tapurqanllapa: —¿Pim munan wanchishuytaqa? Dyablum lukuyachishushqa, chayshina rimanaykiqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Chaymi Jisusqa paykunata nirqan: —Samana diyapi suq byinda ruraptiyqam, qamkunaqa ispantashpa, piñakungillapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","23","Piru kay kumparasyumbi yuyashunllapa: Chay punta agwilunchiqkunam kwirpumbi chay siñalta rurarqanllapa. Chaymandaqam Muysispis liynimbi nirqan, kwirpunchiqpi chay siñalta rurananchiqllapa. Chaymi chay kustumbrita kumplinaykillapa, samana diyapi ullqo wambraykita aychanda kuchushpa, siñalashpaqa, qamkunapis trabajaykangillapa. Chayshina qamkuna trabajashpaqa, ¿imapaqmi piñakungillapa, suq runata nanayninmanda kach'akachiptiy samana diyapiqa? ");
INSERT INTO qvcNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Manaraq allita yach'ashpaqa, ama dasqa jusgayllapachu. Ashwan allita yach'ashpa, jusgayllapa: ¿Allichu chay rurashqanqa ichu mana? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Chayshina Jisus niptinmi, wakin jirusalinirukunaqa kayshina parlarqanllapa: —¿Manachuraq maskaykanllapa kay runata wanchinanllapa? ");
INSERT INTO qvcNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Rikayllapa, yumbaypa ñawpambim rimaykan. Manam pipis nimata ninchu. ¿Awturidarkunachuraq yach'anllapa: Allibmi kay Jisusqa Dyus Akrashqan Washadur, nishpa? ");
INSERT INTO qvcNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Piru Jisuspaqqam yach'anchiq: Nasaritmandam shamushqa, nishpa. Piru chay Washadur shamuptinqam, mana pipis yach'anqachu: Maymandam payqa shamun, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jisusqam chayta yach'ashpa, Dyuspa adurana wasimba patyumbi yach'achikuykashpa, kayshina jwirtita nirqan: —Qamkunaqam yuyangillapa: Jisustaqam riqsinchiq. Yach'anchiqmi maymanda shamushqa, nishpa. Piru manam alliptaqa yach'angillapachu. Manam ni riqsingillapachu chay kach'amuwaqtaqa. Chaqa gustuymandaqam mana shamushqachu kani. Ashwanmi suq allip kaqta rimaq kach'amuwashqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Chay kach'amuwaqtaqam noqaqa allita riqsini. Chaqa paymandam shamushqa kani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Chayshina niptinmi, Jisustaqa munarqanllapa prisuyta. Piru manaraqmi wanchinanllapa urasqa ch'ayamushqachu karqan. Chaymi mana pipis almitikarqanchu prisuytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Kanan achka runakunam paypi yuyakushpa, kayshina nirqanllapa: —Manam pipis atinmanchu rurayta kay Jisus rurashqan milagrukunataqa. Chaymi yach'anchiq: Jisukristum Dyus Akrashqan Washadurqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Chay runakuna uyaraplla (uyaralla) Jisuspaq chayshina parlaptinmi, farisiyu duktrinayuqkunaqa uyarqan. Chaymi kamachikuq isrraylinu kurakuna chay farisiyukunawan Dyuspa adurana wasimba suldadungunata kach'arqanllapa, Jisusta prisushpa apamunanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Chaymi Jisusqa payta uyaqkunata nirqan: —Ashla tyimpullanam qamkunawanqa rini kaq. Chaymandaqam chay kach'amuwaqmanna rini kutiriq. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Chaymi qamkunaqa ringillapa maskawaq. Lukismi manana ringillapachu tariwaq. Chaqa waqman riptiyqam, mana ringillapachu atiq ikiyta riytaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Chaymi isrraylinukunapa kamachikuqninguna paykunapura kayshina parlarqanllapa: —¿Maytanash kay runaqa rinqa, ama tarinanchiqllapaqa? ¿Akasuchu rin riq chay shikwa shikwa tiyashqan isrraylinukunaman? Chaqa paykunaqam suq nasyungunapi mana isrraylinu kaqkunawan tiyanllapa. ¿Chayshinaqachu rinqa, chay furastirukunata yach'achiq? ");
INSERT INTO qvcNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Imam munan niyta kay niwashqanchiqqa: “Maskawashpapismi, mana ringillapachu tariwaq. May kashqaymanqam mana ringillapachu atiq shamuytaqa”, nishpa? ");
INSERT INTO qvcNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Chay fyista ushyakanan diyaqam mas baliq diya karqan. Chay diyaqam Jisusqa shayashpa, ancha jwirtita nirqan: —Mayqan yakunaqqa noqaman shamunqa upyachinaypaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Chaqa Dyuspa Santu Librumbim kayshina nin: “Noqapi kriyiqkunapa shunqonmandaqam kawsachikuq yaku rin lluqshiq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jisusqam chayshina yach'achikurqan, intyindinanllapa: Jisuspi kriyiqkunam Dyuspa Santu Ispiritunda rinllapa ch'askiq, nishpa. Chaqa chay diyakunapiqam Jisus manaraq syiluman rishqachu karqan, waqpi llipyanambaq. Chaymi Dyuspa Santu Ispiritunqa paykunamanqa manaraq shamushqachu karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Chay achka runakunamanda wakinqam Jisusta chayshina niqta uyashpa, nirqanllapa: —Allibraq kay runaqa Dyuspaq chay shamunambaq rimaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Wakinqam nirqanllapa: —Kayqam Dyus Akrashqan Washadur, nishpa. Piru wakinnataqmi nirqanllapa: —Dyus Akrashqan Washadurqam mana atinchu kayta chay prubinsya Galiliyamandaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Chaqa Dyuspa Santu Librumbiqam nin: “Chay Washadurqam chay unay gubyirnu Dabidpa karu willkan rin kaq. Chaymi chay Dabidpa kikin Bilin llaqtambi rin nasiq”, nishpa. Nuta: Paykunaqam mana yach'arqanllapachu: Jisusmi Bilin llaqtambim nasirqan, nishpa.  ");
INSERT INTO qvcNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Chaymi chay wakin runakunaqa Jisuspaqqa suq layata yuyarqanllapa. Suqkunanataqmi suq layata yuyarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Wakinqam munarqanllapa prisuyta. Piru manam ni pipis prisurqanchu. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Chay suldadu riqkunaqam mana prisushpachu, kutirqanllapa isrraylinu kurakunapa chay kamachikuqningunaman, chay farisiyukunaman. Chaymi paykunaqa chay suldadukunata tapurqanllapa: —¿Imaraykutaq qamkunaqa mana apamurqaykichu Jisustaqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Chaymi chay suldadukunaqa nirqan: —¡Manam ni mayqan runapis chay runashinaqa rimashqachu! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Chaymi farisiyukunaqa chay suldadungunata nirqanllapa: —¿Ima, qamkunapischu dijakarqaykillapa ingañashunambaq? ");
INSERT INTO qvcNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Allita yuyayllapa, noqaykunamandaqam mana ni suq kamachikuq, ni suq farisiyu chay runapiqa kriyishqallapachu kani, ¿manachu? ");
INSERT INTO qvcNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ashwanmi Muysispa liyningunata chay mana yach'aqkunalla Jisuspiqa kriyinllapa. Chaymi paykunaqa kundinadu rinllapa kaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Piru chay farisiyukunamanda suqninmi chay Nikudimu karqan. Payqam suq tuta Jisusman rishqa karqan tapuq. Chaymi payqa chay farisiyu masingunata nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Liyninchiqmi kamachiwanchiq, amash dasqa pipaq nishunchu: “Uchayuqmi”, nishpaqa. Ashwanmi kamachiwanchiq, puntata allita uyananchiq, chayshina yach'ananchiq: ¿Allitachu rurashqa ichu mana? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Chaymi chay suq farisiyukunaqa nirqanllapa: —¿Ima qambischu galiliyanu kangi? Dyuspa Santu Librunda allita liyiy, yach'anayki: Dyuspaq rimaqkunaqam mana ni pipis Galiliyamandaqa shamushqachu, nishpa. Nuta: Piru liyiy Isaías 9.1ta.  ˻ ");
INSERT INTO qvcNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Chayshina nishpaqam, rirqanllapana wasingunaman. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Piru Jisusqam Ulibu lumamanna rirqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Qayandin tutamandam Dyuspa adurana wasinmanna kutirirqan. Chay diyam ancha achka runakuna Jisusman tandakarqanllapa. Chaymi payqa tiyashpa, paykunata yach'achirqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Chaypi yach'achikuykaptinmi, wakin farisiyu duktrinayuqkuna, Muysispa liyningunata wakin yach'achikuqkunapis suq warmita apamurqanllapa Jisusman. Chay warmitaqam tarishqallapa karqan suq runa mana rrispitun kaqwan puñuykaqta. Chaymi yumbaypa ñawpambi rurashpa, ");
INSERT INTO qvcNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jisusta nirqanllapa: —Yach'achikuq Taytitu, kay warmitam tarishqallapa kani suq runa mana rrispitun kaqwan puñuykaptin. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Muysispa liynimbiqam nin, kay laya warmikunata rumikunawan sitashpa, wanchinanchiq. Mayá, qamqa ¿imatam ningi? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Chayshinaqam yanqa tapurqanllapa, imapi pandaptin, chaypaq tumbashpa dimandananllapa. Chaymi Jisusqa pambaman kumurashpa, allpapi didunwan iskibrirqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Piru paykuna kutin kutin tapuptinllapaqam, kumuraykashqanmanda alsakashpa, nirqan: —Mayqanniki mana nima uchayuq kaqri puntata sitay kay warmitaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Chayshina nishpaqam kumurarirqan, allpapi iskibrinambaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Chayshina Jisus niptinqam, chay runakunaqa, uchayuq kashpa, penqakushpa, suqnin suqnin rirqanllapa. Puntataqam chay mayurkuna rirqanllapa. Chaymandaqam chay mas wambra runakunapis rirqanllapa. Chaymi chay warmillana kidarqan Jisuspa ñawpambi. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Chaymandaqam Jisusqa alsakarishpa, chay warmitallana rikarqan. Chaymi tapurqan: —¿Maypinataq chay dimandashuqkunaqa? ¿Mananachu pipis kan, shimbishunanqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Chaymi warmiqa nirqan: —Taytitu, mananam ni pipis kanchu, nishpa. Chaymi Jisusqa chay warmitaqa nirqan: —Noqapismi mana sintinsyaykichu wanchishunanllapaqa. Mayá, riyna. Kananmandaqa amanakish uchakunataqa rurangichu, nishpa.˼ ");
INSERT INTO qvcNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Chaymandaqam Jisusqa chaypi kaqkunata suq kutinda kayshina yach'achirirqan: —(Kay mundupi tiyaqkunaqam Dyuspi mana yuyakushpaqa, tutayaqpishina kawsaykanllapa.) Noqaqam Taytanchiq Dyuspaq yach'achikushpa, suq michashina kani paykunapaqqa. Chaymi mayqan runa noqapi yuyakushpaqa, achikpishinana rin kawsaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Chaymi wakin farisiyu duktrinayuqkunaqa Jisusta kayshina nirqan: —Qamllam faburnikita rimaykangi. Chayraykum chay nishqaykiqa mana nimapaq balinchu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Chaymi Jisusqa paykunata nirqan: —Noqalla faburniyta rimaptiypismi, chay nishqaykunaqa mana llullachu. Chaqa noqaqam yach'ani: Maymandam shamushqa kani, maymanmi kutirishaq, nishpa. Piru qamkunaqam mana yach'angillapachu: Maymandam shamushqa Jisus, ni maymanmi kutirinqa, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Qamkunaqam suqkunata chapashpa, yuyaynikimandalla jusgashpa, ningillapa: “Kay laya runam payqa”, nishpa. Piru noqaqam mana pitapis chayshinaqa jusganichu. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Jusgakushpaqam, kabalta jusgakuni. Chaqa manam sapalayqa jusgakunichu. Ashwanmi kach'amuwaq Taytaywan jusgakuniqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Qamkunapa liynikipiqam kayshina nin: “Ishkay tistigu chay layatalla rimaptinqam, balinna chay rimashqanqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Chayshinam noqapis noqa kikiypaq suq tistigu kani. Kach'amuwaq Taytaypismi noqapaq suq tistigu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Chaymi paykunaqa tapurqanllapa: —¿Maypitaq taytaykiqa? nishpa. Chaymi Jisusqa paykunata nirqan: —Noqata mana allita riqsiwashpa: Pim Jisukristu nishpaqam, Taytaytapis mana riqsingillapachu. Piru noqata allita riqsiwashpaqam, Taytaytapis riqsingimanllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Chayshinam Jisusqa rimarqan Dyuspa adurana wasimbi chay ufrindapaq kaq kajungunapa ladumbi. Piru manam pipis prisurqanchu. Chaqa manaraqmi prisunanllapa urasqa ch'ayamushqachu karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jisusmi kayshina nirirqan: —Noqaqam rinina riq. Riptiyqam qamkunaqa ringillapa maskawaq. (Piru mananam ringillapachu tariwaq.) May rishqaymanqam qamkunaqa mana atingillapachu riyta. Chaqa Tayta Dyusqam mana rinchu pirdunashuq uchaykikunataqa. Chaymi wañushpaqa, ringillapa chingaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Chayshina Jisus niptinqam, chay mas kamachikuq isrraylinukunaqa suqnin suqnin kayshina tapunakurqan: —¿Ima pay kikinllachu munashpa wanchikayta, niwanchiqllapa: “May rishqaymanqam mana atingillapachu riyta” nishpaqa? ");
INSERT INTO qvcNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Chaymi Jisusqa paykunata nirqan: —Qamkunaqam kay mundumanda kangi. Piru noqaqam mana kay mundumandachu kani. Ashwanmi anaq syilumanda kaniqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Chaymi noqapaq mana kriyishpa: Jisusqam Dyuspa Churin, nishpaqa, wañushpa ringillapa chingaq. Chaqa Taytanchiq Dyusqam mana rinchu pirdunashuqllapa uchaykikunamandaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Chaymi chayshina niptinqa, Jisusta tapurqanllapa: —¿Pitaq qamqa kangi? nishpa. Chaymi Jisusqa paykunata nirqan: —Qallarishqay diyamandapacham chaytaqa nishushqallapa kani. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Noqaqam qamkunata jusgashushpa, chay ima laya kashqaykillapata rini nishuq. Piru noqaqam chay kach'amuwaqta uyani. Chaymi pay nishqanshina allip kaqtalla yumbay runakunata, warmikunataqa nini. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Chayshina Jisus niptinqam, paykunaqa mana intyindirqanchu: Tayta Dyuspaqmi rimaykan, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Chaymi Jisusqa yumbay chaypi kaqkunata nirqan: —Noqa Dyusmanda Shamuq Runata (klabawashpa, suq krusman) alsawashparaqmi, ringillapa yach'aq: Allibmi Jisusqa Dyusmanda shamushqa, nishpaqa. Chaypim ringillapa yach'aqpis: Manam pay munashqandaqa rurashqachu. Ashwan Taytan nishqandallam rimashqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Taytay kach'amuwaqqam pullay. Manam sapalaytaqa dijawashqachu. Chaqa tukuy bidaypim pay munashqandalla rurani. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Chayshina Jisus niptinqam, achka runakuna, warmikuna paypina kriyirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jisusqam paypi kriyiq isrraylinukunataqa kayshina nirqan: —Nishushqaykunata mana shaykuq kasuwashpaqach'i, allip yach'akuqniykuna kangimanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Chayshina kasuwashpaqach'i, tukuy nishushqaypaq yach'angimanllapa: Allibmi kashqa, nishpa. Chay allip nishushqayta kasushpaqach'i, manana randishqa kriyadushinaqa kangimanllapachu. Ashwanch'i librina kangimanllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Chaymi paykunaqa nirqanllapa: —Abrajamba kastanguna kashpam, tukuy tyimpu libri kanillapa. Manam ni mayqamba randishqa kriyadunchu kashqallapa kani. Chayshinaqa ¿imaraykum niwangillapa: “Librinam kangimanllapa”, nishpaqa? ");
INSERT INTO qvcNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Chaymi Jisusqa paykunata nirqan: —Alliptam niykillapa, yumbay runa uchata ruraqkunaqam dyablupa kriyadunshina. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Kay kumparasyumbaq yuyashunllapa: Suq kriyaduqam mana tukuy tyimpupaqchu patrunnimba kriyadunqa rin kaq. Piru chay patrumba churinqam tukuy tyimpupaq taytamba churin rin kaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Chaymi noqa Dyuspa Churin washashuptiyqa, allipta uchaykimanda librina ringillapa kaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Allitam yach'ani: Abrajamba kastanguna kangillapa, nishpa. Piru wakinnikiqam yach'achishushqayta mana kriyiwashpa, munangillapa wanchiwayta. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Noqaqam rimani Taytay rikachiwashqanda. Piru qamkunaqam suq taytayki nishushqanda rurangillapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Chayshina Jisus niptinmi, wakin isrraylinukunaqa nirqanllapa: —Noqaykunapa taytayqam chay unay Abrajan, nishpa. Chaymi Jisusqa nirqan: —Chay Abrajanqam allita rurashpa kawsarqan. Chaymi qamkunaqa paypa kastan kashpaqa, payshina allita rurashpa kawsangimanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Piru qamkunaqam mana Abrajanshinachu kawsangillapa. Chaqa Tayta Dyus allip kaqta niwashqanda qamkunata nishuptiymi, munangillapa wanchiwayta. Piru Abrajanqam mana nunka chayshinaqa rurarqanchu. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Qamkunaqam suq laya taytayuq kangillapa. Chaymi chay mana alli taytaykipa rurananda qamkuna ruraykangillapa. Chayshina Jisus niptinmi, chay runakunaqa kayshina nirqanllapa: —Noqaykunaqam mana tarikuchu kanillapa. Ashwanmi Taytanchiq Dyuslla taytayllapaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Chaymi Jisusqa paykunata nirqan: —Qamkuna Tayta Dyuspa wambranguna allipta kashpaqach'i, noqataqa kuyawangimanllapa. Chaqa Tayta Dyus kach'amuwaptinmi, kay pachamanqa shamushqa kani. Manam noqapa yuyayniymandachu shamushqaqa kani. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Piru yach'achikuptiyqam, qamkunaqa mana munangillapachu uyawayta. Chaymi chay nishushqaytaqa mana atingillapachu intyindiwayta. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Chaqa qamkunapa taytaykiqam dyablu. Chaymi dyablu munashqanda munangillapa rurayta. Chaqa dyabluqam qallarishqan tyimpumandapacha matansyiru, ancha llulla likidu kashqa. Chaymi llullakushpalla purin. Manam nunka allip kaqtaqa rimanchu. Chaymi llullakuqkunaqa paypa wambranguna. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Chaymi noqa allip kaqta nishuptiyqa, qamkunaqa mana kriyiwangichu. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Noqa allitalla ruraptiyqa, ¿mayqannikim atingi niwayta: “Uchayuqmi kangi”, nishpaqa? Noqa mana llullakushpa, allip kaqtalla nishuptiyqa ¿imaraykutaq qamkunaqa mana kriyiwangichu? ");
INSERT INTO qvcNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Chaqa Tayta Dyuspa wambrangunaqam pay nishqanda kasunllapa. Piru qamkuna Tayta Dyuspa mana wambranguna kashpaqam, pay nishqandaqa mana munangillapachu kasuyta. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Chayshina Jisus niptinmi, chay isrraylinukunaqa nirqanllapa: —Noqaykunaqam allip kaqta kayshina rimanillapa: “Qamqam dyabluta kasuq samaryanu kangi”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Chaymi Jisusqa nirqan: —Noqaqam mana dyablutaqa kasunichu. Ashwanmi Taytay munashqanda rurashpa, payta alabani. Piru qamkunaqam mana nimatapis alabawangichu. Ashwanmi qamkunaqa disprisyawangi. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Noqaqam mana munanichu, qamkuna amalas alabawanaykiqa. Ashwanmi Taytay Dyus ancha munan, qamkuna alabawanayki. Chaqa paymi noqapa faburniy. Kanan paymi yumbayta rin jusgaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Allip kaqtallam niykillapa, yumbay rimashqayta kasuqkunaqam mana nunka rinllapachu wañuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","53","Chayshina Jisus niptinmi, chay ch'iqniq runakunaqa kayshina nirqanllapa: —¿Imapaqmi ningi qamta kasushuqkunash mana nunka rinllapachu wañuq, nishpaqa? Kananqam allitana yach'anillapa: Qamba kwirpuykipim dyablupa ispiritun tiyan, nishpa. Chaqa unay agwilunchiq Abrajanqam wañushqa. Dyuspaq yumbay rimaqkunapismi unay tyimpuna wañushqa. ¿Ima qamqachu yuyangi: Mas balidum kani chay unay agwilunchiq Abrajanmanda, nishpa? Chayshinaqachu ¿yuyangi: Yumbaymandam mas balidu kani, nishpa? ");
INSERT INTO qvcNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Chayshina niptinllapam, Jisusqa nirqan: —Manam noqa kikiyllaqa alabakanichu. Noqa kikiylla alabakashpaqam, mana nimapaq baliymanchu. Taytaymi noqataqa alabawan. Kanan qamkunapismi Taytaypaq ningillapa: “Paymi Dyusniy”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Chayshina nishpapismi, paytaqa mana riqsingillapachu. Piru noqaqam paytaqa riqsini. Chaymi “Manam Dyustaqa riqsinichu”, nishpaqa, qamkunashina llullakuq kayman. Piru noqaqam Taytay Dyusta allipta riqsishpa, pay nishqanda kasuni. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Chay unay agwilunchiq Abrajanqam ancha kushikurqan, yach'ashpa: Dyus Akrashqan Washadurmi rin shamuq, nishpa. Chaymandaqam chay Abrajanqa (wañushpa, syilupina kashpa) noqata rikawarqan syilumanda shamuqta. Chaymi ancha kushikurqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Chayshina Jisus niptinmi, chay ch'iqniq runakunaqa kayshina nirqanllapa: —Agwilunchiq Abrajanqam achka watakunana wañushqa. Piru qamqam manaraq ni 50 watayuqchu kangi. ¿Imapaqtaq ningi: “Abrajandam rikashqa kani”, nishpaqa? ");
INSERT INTO qvcNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Chaymi Jisusqa nirqan: —Allita uyawayllapa. Manaraq Abrajan kaptinmi, noqaqa tukuy tyimpu kashqa kani, nishpa. Nuta: Chayshinallam Tayta Dyuspis Muysista nishqa karqan. Éxodo 3.14.  ");
INSERT INTO qvcNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Chayshina Jisus niptinmi, chay runakunaqa ancha piñakushpa, rumikunata piskarqanllapa, sitashpa wanchinanllapa. Chaymi Jisusqa chay achka runakunapa ukumbi pakakushpa, Dyuspa adurana wasinmanda lluqshishpa, suq lugarmanna rirqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Suq lugarta pasaykashpam, Jisusqa suq sarku runata rikarqan. Chay runaqam sarkulla nasishqa karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Chaymi noqaykuna yach'akuqningunaqa chay runapaq kayshina tapurqayllapa: —Yach'achikuq Taytitu, kay runa sarkulla nasinambaqqa, ¿pitaq uchata rurarqan? ¿Paychu ichu taytanguna? nishpa. Nuta: Chay isrraylinukunam mana intyindishpa yuyarqanllapa: Yumbay qeshyaqkuna ichu pubrikuna uchata rurashqanrayku padisinllapa, nishpa.  ");
INSERT INTO qvcNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Chaymi Jisusqa noqaykunata niwarqan: —Manam ni chay runa ni taytanguna uchata rurashqanraykuchu sarkuqa kashqa. Ashwanmi sarkuqa nasishqa, Dyus yanapanambaq, rikaqkuna yach'ananllapa: Dyusmi ancha pudirniyuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Chaqa Dyusmi kach'amuwashqa, pay munashqanda ruranaypaq. Chaymi manaraq ushyakaptin tyimpuy, chayta ruraykani. Chaqa kay tyimpuqam punchawshinaraq. Piru rinmi ch'ayamuq suq tyimpu, manana pipis nimata atinan rurayta. Chay tyimpuqam tutapshina rin kaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Piru kay mundupi kashpaqam, runakunapa, warmikunapa michanshina kani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Chaymandaqam Jisusqa tuqayninwan allpata nuyuchishpa, chay sarku runapa ñawingunata implastarqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Chayshina rurashpaqam, Jisusqa nirqan: —Riy chay Siluwi pusuman mayllakuq, nishpa. Chay Siluwiqam ibriyu rimaypiqa munan niyta: “Kach'amushqa”, nishpa. Chaymi chay sarku runaqa rishpa, chay pusupi mayllakushpa, rikakurqanna. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Chay sarku runapa bisinunguna, suq runakunapismi payta rikashqallapa karqan limush'nata mañakuykaqta. Chaymi rikakuqtana rikashpaqa, nirqanllapa: —¿Manachuraq chay runa tiyashpa limush'nata mañakuq? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Suqkunapismi nirqanllapa: —Waqqar pay, nishpa. Wakinnataqmi nirqanllapa: —Waqqar chay runa limush'nata mañakuq laya. Piru manam paychu, nishpa. Piru chay runa sarku kashqanqam nirqan: —Noqam kani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Chaymi tapurqanllapa: —¿Imashinataq atingina rikakuytaqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Chaymi payqa nirqan: —Chay runa Jisus shutiqmi lluchkitakushpa, ñawiykunata implastashpa, kamachiwarqan: “Riy Siluwi pusuman mayllakuq”, nishpa. Chaymi noqaqa rishpa, chay pusupi mayllakushpa, rikakurqayna, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Chaymi chay runakunaqa chay sarkutaqa tapurqanllapa: —¿Maypinam chay Jisusqa? nishpa. Payqam nirqan: —Manam yach'anichu. Maypinach'iri, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Samana diyapim chay sarku runataqa Jisusqa lluchkitata rurashpa, implastashpa kach'akachishqa karqan. Chaymi chay runata aparqanllapa farisiyukunaman. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Paykunaman ch'ayaptinqam, tapurqanllapa: —¿Imashinataq sarku kashqaykimandaqa kananqa atingina rikakuyta? nishpa. Chaymi chay runaqa nirqan: —Suq runam ñawiykunapa sawanda lluchkitawan implastarqan. Chaymandaqam noqa ñawiykunata mayllashpaqa, atirqayna rikakuyta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Chayshina niptinqam, wakin farisiyukunaqa nirqan: —Chay runa kach'akachishuqqam samana diyata mana rrispitanchu. Chaymi payqa mana Dyusmandachu shamushqa, nishpa. Piru wakinnataqmi nirqan: —Suq uchayuq runa kashpaqach'i, kay milagrukunataqa mana atinmanchu rurayta, nishpa. Chayshinam paykunapura suq laya, suq layata parlarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Chaymi chay runa sarku kashqandaqa tapurirqanllapa: —¿Mayá, ima ningitaq qamqa chay kach'akachishuq runapaqqa? nishpa. Chaymi chay runaqa nirqan: —Noqaqam nini: Payqam Dyuspaq suq rimaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Piru chay kamachikuq isrraylinukunaqam mana kriyirqanllapachu: Chay runam sarku kashqanmanda rikakushqa, nishpaqa. Chaymi taytanda mamanda qayashpa, ");
INSERT INTO qvcNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","tapurqanllapa: —¿Kaychu wambrayki? ¿Alliptachu sarku nasirqan? Kananqa ¿imashinataq atinna rikakuyta? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Chaymi taytan mamanqa paykunata nirqan: —Arí, wambraymi. Alliptam sarku nasirqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Piru manam yach'anillapachu imashinam ichu pim kach'akachishqa, nishpaqa. Waqqar mayur runana. Paytar tapuyllapa, pay kikin nishunanllapa, imashinam rikakushqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Taytanwan mamanqam chayshinaqa nirqanllapa, chay kamachikuqkunata manchashpa. Chaqa chay kamachikuqkunaqam tandakashpa parlashqallapa karqan: “Mayqan runa ichu warmi: ‘Jisusmi Dyus Akrashqan Washadur’ niptinqa, sinaguga wasimanda qatishun”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Chaymi taytanwan mamanqa manchashpa: Qatiwashunch'i, nishpa, nirqanllapa: “Mayur runanam. Payta tapuyllapa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Chaymi chay runataqa qayarishpa, nirqanllapa: —Dyuspa ñawpambi juray: ¿Imashinam rikakushqa kangi? nishpa. Noqaykunaqam yach'anillapa: Chay Jisusqam uchayuq runa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Chaymi chay runaqa nirqan: —Manam noqaqa yach'anichu: Uchayuqchu Jisusqa ichu mana, nishpa. Piru kaytallam yach'ani: Sarku kashqaymandam rikakunina, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Chaymandaqam mushuqmanda tapurirqanllapa: —¿Imatam rurashurqan rikakunaykiqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Chaymi paykunataqa nirqan: —Nishurqaqllapanam, piru qamkunaqam mana munangillapachu uyawayta. Chayshinaqa ¿imapaqnamir munangillapa mushuqmanda nirishunayqa? ¿Qamkunapischu munangillapa yach'akuqninguna kayta? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Chayshina niptinqam, chay kamachikuqkunaqa chay runataqa ancha musyashpa nirqanllapa: —Qamqam kangi chay Jisuspa yach'akuqnin. Piru noqaykunaqam chay unay Muysispa librungunamanda yach'akunillapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Chaymi yach'anillapa: Dyusmi parlachirqan Muysista, nishpa. Piru chay mana baliq Jisuspaqqam mana yach'anillapachu ni maymandach'i shamushqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Chaymi chay runaqa paykunata nirqan: —¡Chayshinaqam mana nunka uyashqachu kani! Qamkunaqam mana yach'angillapachu: ¿Maymandam shamushqa chay runa? nishpa. Piru noqataqam yanapawashqa rikakunaypaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kanan noqanchiqkunam yach'anchiq: Dyusqam ucha ruraqkunataqa mana yanapanchu. Piru payta aduraqkunata, munashqanda ruraqkunataqam Dyusqa yanapan. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Manakish nunka uyashqachu kanchiq: Suq sarku nasiqtam suq runa kach'akachishqa, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Chaymi niykillapa, chay yanapawaq runa, Dyusmanda mana shamushpaqach'i, mana nima milagruta atinandachu rurayta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Chayshina niptinqam, chay kamachikuq runakunaqa nirqanllapa: —¿Ima qam ucha likidu nasiqchu noqaykunata munangi yach'achiwayta? nishpa. Chayshina nishpam, chay runataqa sinaguga wasimanda qatirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jisusmi yach'arqan chay runata sinaguga wasimanda qatishqanllapata. Chaymi chay runata tingushpaqa, kayshina tapurqan: —¿Qamqachu Dyuspa Churimbi kriyingi? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Chaymi payqa nirqan: —Taytitu, ¿pimir payqa? Mayá niwayri, paypi kriyinaypaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Chaymi Jisusqa nirqan: —Rikawashqam kangi. Noqam kani. Kayqar parlachiykayki, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Chaymi chay runaqa nirqan: —Arí, Taytitu. Qambim kriyini, nishpa. Chayshina nishpaqam, Jisuspa ñawpambi qonqorikurqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Chaymandaqam Jisusqa nirqan: —Noqaqam kay mundumanqa shamushqa kani, Dyuspaq mana intyindiqta yach'achinaypaq, paypaq allita yach'ananllapa. Piru chay yach'aq tukuqkunata jusgashpam, rini akraq chay yach'aqkunamanda, sarkukunashina kashpa, mana nimatapis intyindinambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Wakin farisiyukunaqam chaypi karqan. Chaymi chayshina Jisus niptin uyashpaqa, kayshina tapurqanllapa: —¿Qamchu niwangillapa: “Sarkukunashinam kangillapa”, nishpa? Manam sarkukunashinachu kanillapaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Chaymi Jisusqa chay farisiyukunata nirqan: —Yuyaynikipi sarkukunashina kashpaqach'i, mana yaqqa uchayuqchu kangimanllapa. Piru qamkuna kikikim ningillapa: “Allitam Dyuspaq yach'anillapa”, nishpa. Chaymi mas uchayuqna kangillapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’Alliptam niykillapa, suq runa wishakunapa kurralninman chay pungunda mana yaykushpa, ashwan sawanda yaykuqqam suq ladrun ichu suq saltiyadur. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Piru kurralpa pungunda yaykuqqam wishakunapa michidurnin. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Chaymi kurralpa pungunda kwidaqqa kich'an, chay michidur yaykunambaq. Yaykuptinqam, chay wishangunaqa michidurnimba busninda riqsin. Kanan paypismi wishangunata riqsishpa, kadunuta shutimbi qayashpa, surqon. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Chaymandaqam chay wishangunapa ñawpanda rin. Wishangunapismi chay michidurnimba busninda riqsishpa, ikinda rinllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Piru mana michidurnin kaqtaqam mana siginllapachu. Ashwanmi busninda mana riqsishpachu, manchashpa mitikanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisus chay kumparasyunda ruraptinqam, chay isrraylinukunaqa mana intyindirqanllapachu: imam munan niyta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jisusmi paykunata nirirqan: —Alliptam niykillapa, noqaqam wishakunapa yaykunan pungushina kani. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Piru yumbay chay puntata shamuq pandachikuq yach'achikuqqam ladrunshina, saltiyadurshina kashqallapa. Chaymi wishayshina kaqkunaqa paykunataqa mana kasurqanchu. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Noqam syilupa yaykuna pungunshina kani. Chaymi mayqan noqapi yuyakuqqa washadu kashpa, syiluman rin yaykuq. Payqam suq wisha qewata tariqshina rin kaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Suq ladrunqam shamun suwakuq, wanchikuq, chingachikuq. Piru noqaqam shamushqa kani, runakunata, warmikunata tukuy tyimpu ancha shumaqta kawsachinaypaq, tukuy bidambi ancha kushikunanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Noqaqam ancha allin michidurshina kani. Chaymi rini wañuq, runakunata, warmikunata washanaypaq. Chaqa paykunaqam wishaykuna. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Piru paguta ch'askiq michikuqqam mana lijitimu dwiñuchu. Chaymi chay atun kita animal lubu shamuqta rikashpaqa, wishakunata dijashpa, das mitikan. Chaymi chay lubuqa wishakunata rishpa piskaq mikunambaqqa, waqta kayta shikwan. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Chaqa chay michikuq pagu ch'askiqqam paguraykulla wishakunataqa michin. Chaymi mitikan, mana nimatapis llakishpachu, ¿chay wishakunachu chingan ichu mana? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","’Piru noqaqam ancha allin michidurshina kani. Taytay noqata riqsiwashqanshinam noqapis paytaqa riqsini. Chayshinallam runakunata, warmikunata ancha allita riqsini, wishaykuna kaptin. Achka runa, warmipismi noqata riqsiwan. Chaymi rini wañuq, paykunata washanaypaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Kanan suq nasyungunapipismi wambraykuna kan. Paykunapismi rinllapa kasuwaq. Chaymi paykunatapis rini apamuq, yumbay wishaykuna suq trupa tandadulla kananllapa, noqalla michidurnin kanaypaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Wishaykunapaqmi rini wañuq. Chaymi Taytayqa ancha kuyawan. Kanan wañushpaqam, mushuqmanda rini kawsamuq. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Piru manam pipis amalasqa rinchu wanchiwaq. Ashwan noqa kikiy munashpam, rini dijakaq wanchiwananllapa. Chaqa dirichuyuqmi kani wañushpa, kawsamunaypaq. Taytanchiq Dyusqam kach'amuwashqa, chayshina ruranaypaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Chayshina Jisus niptinmi, wakin isrraylinukunaqa paykunapura suq layata, suq layata rimarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Chaymi paykunamanda achka runakuna Jisuspaqqa nirqanllapa: —Payqam luku. Uku shunqombim dyablupa ispiritun. Chayri ama uyayllapachu paytaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Piru wakinnataqmi nirqanllapa: —Kay runapa shunqombi dyablupa ispiritun kaptinqach'i, kay ancha shumaqkunataqa mana rimanmanchu. Kanan chay dyabluqam sarkukunata mana atinmanchu chapachiyta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jirusalin llaqtapim unay tyimpukunapi Dyuspa adurana wasinda allichashqallapa karqan. Chaymandaqam Tayta Dyustana intrigashqallapa karqan. Chaymi watan watan, chayta yuyashpa, chiri tyimpupi suq fyistata rurarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Dyuspa adurana wasinmi achka kurridurniyuq karqan. Suq kurridurninmi Salumun kurridur shutiq. Chay fyistapi Jisukristu chay Salumun kurridurpi puriykaptinmi, ");
INSERT INTO qvcNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","wakin isrraylinukuna paypa rridurnimbi shayashpa, kayshina tapurqanllapa: —¿Ima tyimpukamanmi mana ringichu niwaqllapa: “Dyus Akrashqan Washadurmi kani” ichu mana, nishpaqa? Chayri Dyuspa chay Akrashqan Washadur kashpaqa, klaruta niwayllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Chaymi Jisusqa paykunata nirqan: —Nishushqallapanam kani. Piru manam munangillapachu kriyiwaytaqa. Noqaqam Taytay niwashqanda rurani. Chayta rikashpam, atingillapa yach'ayta: Jisusmi Dyusmanda shamushqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Piru qamkunaqam mana wishaykunachu kangillapa. Chaymi noqataqa mana kriyiwangillapachu. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Piru wishaykunaqam busniyta riqsishpa, sigiwanllapa. Noqapismi chay wishaykunataqa riqsini. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Chaymi noqaqa paykunata kawsachini, suq bidapi tukuy tyimpu kawsashpa, ama nunka chingananllapa. Chayshina paykunata washaptiyqam, mana pipis noqataqa rinchu qoch'iwaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Chaqa Taytayqam yumbaymanda mas pudirniyuq. Paymi wishaykunataqa qowashqa. Chaymi mana pipis atinchu qoch'iyta chay wishaykunataqa Taytaypa makinmandaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Noqaqam Taytaywanqa suqlla kanillapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Chayshina nishqambaqmi, chay isrraylinukunaqa rumikunata piskarqanllapa, Jisusta sitashpa, wanchinambaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Chaymi Jisusqa paykunata nirqan: —Taytay yanapawaptinmi, qamkunapa ñawpaykipi ancha achka runata, warmita yanapashqa kani. ¿Mayqan chay yanapashqaypaqmi ringillapa wanchiwaqqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Chaymi chay isrraylinukunaqa Jisusta nirqanllapa: —Manam rinillapachu wanchishuq chay allikunata rurashqaykiraykuqa. Ashwanmi rinillapa wanchishuqqa Taytanchiq Dyusta burlashqaykirayku. Chaqa qamqam suq runalla kashpa, “Dyusmi kani” ningi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","35","Chaymi Jisusqa paykunata nirqan: —Tayta Dyus kikinmi Santu Librumbi payta uyaqkunata nirqan: “Dyuskunam kangillapa”, nishpa, ¿manachu? Chaymi chayshina Dyuspa Santu Librun nishqandaqa mana atingillapachu ñigayta. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Kanan Tayta Dyusmi noqata akrawashpa, kay munduman kach'amuwashqa. Chaymi nini: “Dyuspa Churinmi kani”, nishpa. Chayshina niptiyqa, ¿imaraykutaq niwangillapa: “Dyustam burlaykangi”, nishpaqa? ");
INSERT INTO qvcNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Taytay munashqanda mana ruraptiyqa, ama kriyiwayllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Piru noqaqam pay munashqanda rurani. Chayri mana nimata noqata kriyiwashpapis, chay milagrukunata rurashqayrayku kriyiwayllapa: Dyusmi Jisuswan; Jisuspismi paywan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Chayshina Jisus niptinmi, mushuqmanda munarqanllapa prisushpa apayta. Piru manam atirqanllapachu piskaytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Chaymandaqam Jisusqa kutirqanna rriyu Jurdamba chay suq chimbanman. Chayman ch'ayashpaqam, chaypina kidarqan. Chay lugarqam karqan chay Jwan shutichikushqan lugar. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Kanan achka runakuna, warmikuna payman rishpam, kayshina nirqanllapa: —Allibraq chay Jwan Shutichikuqqa mana nima milagruta rurarqanchu. Piru kay runapaq tukuy ima nishqanqam allip kashqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Chaymi chay lugarpiqa achka runakuna, warmikuna Jisuspi kriyirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Suq runa Lasaru shutiqmi ancha qeshyaq karqan. Paymi panin Maryawan, panin Martawan Bitanilla (Bitaniya) kasiriyupi tiyarqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Chay Lasarupa panin Maryam Jisuspa ch'akingunata mishki mutkinawan pasashqa karqan. Chaymandaqam aqchanwan chakichishqa karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Chay warmikunam suq kach'akuta kach'arqanllapa, Jisusta kayshina ninambaq: —Taytitu, kuyashqayki Lasarum qeshyaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Chaymi chayshina niptinllapaqa, Jisusqa nirqan: —Chay nanaywanqam mana rinchu wañuq tukuy tyimpupaqqa. Ashwanmi chay nanayqa piskashqa, yumbay runa, warmi yach'anambaq: Jisuspa Taytanmi ancha pudirniyuq. Churin Jisuspismi ancha pudirniyuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Kanan Jisusqam ancha kuyarqan Martata, masan Maryata, turin Lasarutapis. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Piru chayshina kuyashpa, yach'ashpa: Lasarum ancha qeshyaq, nishpapismi, Jisusqa mana daschu rirqan paymanqa. Ashwanmi kidarqan ishkay diya masta chay kaykashqan lugarpilla. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Chaymandaqam noqaykuna yach'akuqninda niwarqanllapa: —Akullapa kutiriq prubinsya Judiyaman, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Chaymi noqaykunaqa Jisusta nirqayllapa: —Yach'achikuq Taytitu, amar rishunllapachu. Chaqa chayraqmi waq prubinsya Judiyamandaqa shamushqallapa kanchiq. Manchu waqpiqa chay isrraylinu masinchiqkunaqa munashqallapa sitashushpa wanchishuyta. ¿Chaychu munangi waqman kutiriyta? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Chaymi Jisusqa niwarqanllapa: —Punchawqam dusi urasniyuq, achikpi imatapis rurananchiqqa, ¿manachu? Chaymi punchawpi purishpaqa, mana rinchiqchu trumpisaq. Chaqa achikyaptinmi, atinchiq rikakuyta. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Piru tutayaqpi puriqqam trumpisan, bidambi mana micha kashqanrayku. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Chaymandaqam Jisusqa niwarqanllapa: —Kuyashqanchiq Lasaruqam puñuykanna. Piru noqam rini rikch'achiq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Chaymi Jisustaqa nirqayllapa: —Taytitu, chayshina puñushpaqam, pay kikinlla atinqa kach'akayta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Piru Jisusqam chayshinaqa nirqan, Lasaru wañushqana kaptin. Piru noqaykunaqam yuyarqayllapa: Payqam puñuypaq rimaykan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Chaymi Jisusqa ancha klaruta niwarqanllapa: —Lasaruqam wañushqana. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Piru ancham kushikuni waqpi mana kashqayrayku. Chaqa kananqam qamkunaqa mastana noqapi ringillapa yuyakuq. Mayá, akullapana rikaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Chayshina Jisus niptinmi, Tumas “Millisu” shutiq, yach'akuq masingunata niwarqanllapa: —Aku noqanchiqkunapis, Jisuspa pullan wanchiwananchiqllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jisus Lasaruman rishpaqam, ch'usku diya pambakashqambina ch'ayarqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Kanan chay Lasarupa kasiriyun Bitanillaqam (Bitaniyaqam) Jirusalimba ladumbi ishkay kilumitrus y midyupi kidan. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Chaymanmi achka isrraylinukuna rishqallapa karqan, Martata, Maryata kunswilaq turin Lasaru wañuqpaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Chaymandaqam Marta yach'ashpa: Jisus shamuykan, nishpaqa, wasinmanda lluqshishpa, rirqan tinguq. Piru Maryaqam wasimbilla kidarqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Chaymi Marta Jisusta tingushpaqa, nirqan: —Taytitu, kaypi kaptikiqach'i, turisituy Lasaruqa mana wañunandachu. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Piru noqaqam yach'ani: Tayta Dyusqam tukuy ima mañashqaykita rin qoshuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Chayshina niptinqam, Jisusqa nirqan: —Turiki Lasaruqam rin kawsamuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Chaymi Martaqa nirqan: —Arí, chaytaqam yach'ani: Wañuqkuna chay ultimu diyapi kawsamuptinmi, turisituyqa rin kawsamuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Chaymi Jisusqa Martataqa kayshina nirqan: —Noqam wañuqkunataqa kawsachimuni, tukuy tyimpu kawsanambaq. Chaymi noqapi kriyishpa wañuptinqa, rini kawsachimuq. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Kanan noqapi allipta kriyishpa kawsaqqam manana tukuy tyimpupaqchu rin wañuq. ¿Kriyingichu kay nishushqaytaqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Chaymi Martaqa nirqan: —Arí, Taytitu, noqam kriyini: Qami Dyuspa Churin, Dyus Akrashqan Washadurqa kangi, nishpa. Chaqa unay tyimpupim Dyusqa qambaq nirqan: “Churiymi rin shamuq kay munduman”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Chayshina nishpaqam, Martaqa rirqan masan Maryata apamuq. Chaymi uyaraplla (uyaralla) nirqan: —Siñurninchiq Jisusmi nin: Akush, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Chaymi Maryaqa das atarishpa, utqaymaya Jisusman rirqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jisusqam chay Bitanilla (Bitaniya) yaykunapilla kidashqa karqan. Chay lugarpim Martaqa payta tingushqa karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Chaymi chay kunswilaq isrraylinukunaqa Maryata das lluqshiqta rikashpaqa, yuyarqanllapa: Turin Lasaru pambakashqanmanmi rin waqaq, nishpa. Chaymi ikinllapata rirqanllapa kunswilaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Piru Maryaqam Jisus kaykashqanman ch'ayashpa, paypa ñawpambi qonqorikushpa, nirqan: —Taytitu, kaypi kaptikiqach'i, turiy Lasaruqa mana wañunandachu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Chaymi Jisus, rikashpa Maryata yumbay chay isrraylinu waqaykaqkunataqa, ancha llakishpa, malaganayarqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Chaymi kayshina tapurqan: —¿Maypitaq Lasarutaqa pambashqallapa kangi? nishpa. Chayshina tapuptinqam, paykunaqa nirqan: —Taytitu, aku rikaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jisusqam waqarqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Chayshina waqaptinmi, chay isrraylinukunaqa parlarqanllapa: —Rikay, Jisusqam Lasarutaqa ancha kuyashqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Piru wakinqam nirqanllapa: —Kay runaqam chay sarku runakunata atishqa chapachiyta. ¿Ima manachu atishqa Lasarutapis kach'akachiyta, ama wañunambaqqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jisusmi suq kutinda ancha llakirishpa, qemikarqan chay pambakashqan mach'ayshina sipulturaman. Yaykunandam suq atun rumiwan kirpashqallapa karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Chaymi Jisusqa nirqan: —Chay rumita ashuchiyllapa, nishpa. Chaymi chay almapa panin Martaqa kayshina nirqan: —Taytitu, millanaypaqnach'i ash'naykan. Chaqa kanan diyawanqam ch'usku diyana wañushqanqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Piru Jisusqam Martataqa nirqan: —Manchu nishurqay, “Kriyishpaqam ringi yach'aq: Dyusmi ancha pudirniyuq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Chaymi chaypi kaqkunaqa chay atun rumitaqa ashuchirqan. Chaymandaqam Jisusqa syiluman chapakushpa, nirqan: —Taytitu, kay mañashushqayta uyawashpam ringi ruraq. Chaymi pagikuyki. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Noqaqam yach'ani: Qamqam yumbay mañashushqayta rurangi, nishpa. Piru kayshinaqam pagikuyki, kay uyawaqkuna yach'ananllapa: Tayta Dyusmi Jisusta kach'amushqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Chayta nishpaqam, ancha jwirtita alma Lasaruta kayshina qayarqan: —¡Lasaru, chay ukumanda lluqshimuy! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Chaymi chay alma Lasaruqa tukuy kwirpun wangushqa trapuwan, qaqllan suq tukawan tukukushqa chay sipulturamanda lluqshimurqan. Chaymandaqam Jisusqa nirqan: —Chay wangushqanda paskayllapa purinambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jisukristu Lasaruta chayshina kawsachimuptinmi, chay isrraylinukuna Maryapa ikinda shamuqkunamanda achka chay milagruta rikashpa, Jisuspina kriyirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Piru wakingunaqam rishpa, farisiyu duktrinayuqkunata manyaqlla parlachirqan: —Kay milagrutam Jisusqa rurashqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Chaymi chay kamachikuq isrraylinu kurakuna chay farisiyukunawan, chay Mas Kamachikuq Juyiskunawan tandanakushpa, kayshina parlarqanllapa: —Mayá, ¿imatam atinchiqllapa rurayta? Chaqa chay runaqam ancha achka milagrukunata ruraykan. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Dijaptinchiqllapa chayshina ruranambaq, yumbay llaqta masinchiq isrraylinukuna paypi kriyishpaqam, manana rinllapachu kasuq rrumanukunataqa. Chaymi ancha achka rrumanukuna kay nasyunninchiqman shamushpa, noqanchiq isrraylinukunata wanchiwaqninchiq, Dyuspa kay santu adurana wasinda limpu rinllapa chingachiq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Chay watam chay isrraylinu kurakunamanda suqnin mas kamachikuq kura karqan. Payqam Kayfas shutirqan. Chaymi chay Kayfasqa chay farisiyukunata, chay suq kamachikuqkunata nirqan: —Qamkunaqam mana nimatapis yach'angillapachu. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Chaqa noqanchiqpaqqam mas alli suq runalla wañunambaq, yumbayninchiqta washawananchiq, ama nasyunninchiq chinganambaq. ¿Chaytaqachu mana intyindingillapa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Piru chay Kayfas chayshina rimashpaqam, mana kikin yuyaynindallachu rimaykarqanqa. Ashwanmi chay watapi mas kamachikuq kura kashpa, Dyus munashqanda rimaykarqanqa. Chaymi nirqan: “Jisukristum rin wañuq nasyunninchiqpi tiyaqkunata washawananchiq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Piru manam chay Isrrayil nasyunda washanambaqllachu wañurqanqa. Ashwanmi wañurqanqa, yumbay nasyunmanda Dyuspa wambrangunata tandanambaq, suq ayllulla kananchiqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Chay diyamandapacham chay isrraylinu awturidarkunaqa kunanakurqan, Jisusta wanchinambaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Chaymi Jisusqa chay ch'iqniq awturidarkunapa ñawpambiqa manana puriqchu. Ashwanmi chay prubinsya Judiyamandaqa rirqanna Ifrayin shutiq llaqtamanna. Waq Ifrayinqam suq chuncha lugarpa ladumbi kidan. Waqpim noqaykuna yach'akuqningunawan kidarqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Chaypi kaykaptiyllapam, ch'ayamuykarqanna isrraylinukunapa Paskwa fyistan. Chaymi achka runakuna, warmikuna tukuy ladumanda rirqanllapa Jirusalin llaqtaman. Waqpi mayllakunan kustumbringunata rurarqanllapa, amana uchayuq kashpa, Dyusta adurananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Waq Jirusalimbiqam chay isrraylinukunaqa Jisusta maskashpa, puriykarqanllapa. Chaymi Dyuspa adurana wasimbi kashpaqa, suqnin suqnin tapunakurqan: —¿Imatam yuyangillapa? ¿Shamunqachuraq fyistaman Jisusqa, ichuraq mana? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Chay kamachikuq isrraylinu kurakuna, chay farisiyukunawanqam yumbay llaqta masin isrraylinukunata kamachirqanllapa, maypipis Jisusta rikashpa, abisananllapa, chay uras rinanllapa prisuq. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Sayis diyas Paskwa fyista faltaptinraqmi, Jisusqa shamurqan chay Bitanilla (Bitaniya) llaqtaman. Chaypim tiyarqan chay kawsachishqan Lasaru. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Chaypim Jisuspaq mikunata rurarqanllapa. Kanan Lasaruqam Jisuswan mesapi kaqkunawan tiyaykarqanllapa. Panin Martaqam sirbiykarqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Chayshina sirbiykaptinmi, Maryaqa shamurqan ancha ch'aniyuq mishki mutkinata midyu litrutach'i apamushpa. Chay mishki mutkinaqam nardu puru plantamanda karqan. Chaywanmi Maryaqa Jisuspa ch'akingunata pasarqan. Chaymandaqam aqchangunawan chakichirqan. Kanan chay wasipiqam chay mishki mutkinata ancha mishkita mutkirqayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Chaypim karqan Simumba churin Judas Iskaryutipis. Paymi Jisuspa apustulnin kashpapis, Jisusta kuntraqkunaman intrigakunanna karqan. Chay Judasmi nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Imaraykutaq chay mishki mutkinata mana randikushqachu kanchiq, chay qellaywan pubrikunata yanapananchiq? Chaqa chayqam ancha ch'aniyuq. 300 dinaryu qellaymi balin, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Piru Judasqam mana alliptaqa pubrikunapiqa yuyarqanchu. Ashwanmi ladrun kashpa, chayshinaqa nirqan. Chaqa paymi ufrindakunataqa tandaq. Paypa makimbim ufrindata tandanan taligaqa karqan. Chaymi payqa ufrindakunamanda qellayta piskaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Chaymi Jisusqa Judasta nirqan: —Ama Maryataqa piñachiychu. Payqam chay mishki mutkinata waqaychashqa noqapaq. Kananqam ancha balin allichawanambaq, wañuptiy, pambawananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Pubrikunaqam qamkunawan tukuy tyimpu rinllapa kaq, paykunata yanapanaykillapa. Piru noqaqam manana tukuy tyimpupaqchu qamkunawanqa rini kaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Achka isrraylinukunam yach'arqanllapa: Jisusmi chay Bitanillapi (Bitaniyapi), nishpa. Chaymi paymanna shamurqanllapa, payta chay kawsamuq Lasarutapis rikananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Chaymi Lasaruta kawsaqtana rikashpaqa, ancha achka isrraylinukuna Jisuspi kriyishpa, chay kamachikuq isrraylinu kurakunamanda akrakarqanllapa. Chaymi chay kamachikuq kurakunaqa kunanakurqan, Lasarutapis wanchinanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ancha achka isrraylinukunam Jirusalin llaqtaman rirqanllapa chay Paskwa fyistaman. Paykunam yach'arqanllapa: Jisusqash qayandin rin ch'ayamuq kay Jirusalinman, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Chaymi palmirakunapa raprangunata kuchushpa, chaykunata apashpa, rirqanllapa Jisusta tinguq. Chayshina tingushpaqam, ancha jwirtita alabarqanllapa: —¡Biba Tayta Dyus! ¡Alabashunllapa Dyuspa rrimplasun shamuqta! ¡Alabashunllapa kay Isrrayilpa gubyirnunchiqta! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jisusqam suq burrituta apachimushpa, chay burrituta muntakushpa, Jirusalinman ch'ayarqan. Chayshina rurashpam, kumplirqan Dyuspa Santu Librumbi kayshina nishqanda: ");
INSERT INTO qvcNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Siyun llaqtapi tiyaqkuna, ama manchayllapachu. Kaypim washashuq gubyirnuykiqa suq burrituta muntakushpa, shamuykan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Piru noqaykuna yach'akuqningunaqam chay tyimpupiqa manaraq intyindirqayllapachu chay pasashqambaqqa. Piru Jisus kawsamushpa, syiluman riptinraqmi, yuyarqayllapa: Dyuspaq rimaqkunam Santu Librumbi iskibrishqana karqan yumbay chay pasashqambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Achka runam Jisusta rikashqallapa karqan, Lasaruta mach'ayshina sipulturamanda qayashpa kawsachimuptin. Chay rikaqkunaqam suqkunata kayshina ancha parlachishqa karqan: —Kaytam Jisusqa rurashqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Chaymi ancha achka runakuna, warmikuna lluqshirqanllapa tinguq. Chaqa yach'arqanllapanam chay milagruta rurashqambaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Chaymi farisiyu duktrinayuqkunaqa suqnin suqnin kayshina parlarqanllapa: —Qamkuna rikashqaykishinam, kananqa manana nimatapis atinchiqchu rurayta. Chaqa rikay, yumbaymi payta sigishpa, rinllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Jirusalin fyistaman riqkunawanmi wakin grisyanukunapis chay fyistaman rishqallapa karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Chay grisyanukunaqam Filipiman qemikarqanllapa. Chay Filipiqam prubinsya Galiliyapa Bitsayda llaqtanmanda karqan. Chay grisyanukunam Filipita rrugashpa, nirqanllapa: —Taytitu, munanillapam Jisuswan parlayta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Chaymi Filipiqa rishpa, chay grisyanukuna nishqambaq Andrista willarqan. Chaymi ishkandin rishpa, Jisusta chaypaq parlachirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Chayshina niptinmi, Jisusqa paykunata nirqan: —Rinnam ch'ayamuq uras wañunaypaq. Chaymandaqam Taytay Dyusqa ancha rin yanapawaq, yumbay yach'anambaq: Jisukristu Dyusmanda Shamuq Runa kashpam, ancha pudirniyuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Chaqa alliptam niykillapa, noqaqam suq trigushina kani. Chay trigu allpaman mana ishkishpa, mana pambakashpaqam, sapalan trigulla kidan. Piru pambakashpaqam wiñan. Chayshina wiñashpa, yurakushpa, puqoshpaqam, achkayan. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Chayshinallam suq runa noqata kuyawananmanda paypa bidanda masta kuyaqqa rin chingaq. Piru mayqan runa noqapi kriyishqanrayku kay mundupi bidanda pyirdiptinmi, paytaqa rini washaq, suq bidapi tukuy tyimpu kawsanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Chayri mayqan kasuwaqqa allita sigiwanqa. Chaqa chay kasuwaqqam chay may kashqaypi pullay rin kaq. Paytaqam Taytay Dyus rin alabaq, allita kasuwashqanrayku, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","(Jisusqam wañunan diya ch'ayamuykaptin, nirqambis:) —Kananqam ancha llakiwan kani. Piru manam atinichu Taytanchiq Dyusta niyta: “Taytitu washaway, ama ñakashpa wañunaypaq”, nishpaqa. Chaqa chayshina wañunaypaqmi shamushqaqa kani. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ashwanri nishaq: “Taytitu, qam munashqaykita ruray, qamtalla alabashunanllapa”, nishpa. Chaymi chay uras Tayta Dyus syilumanda qayakushpa, nirqan: —Munashqayta ruraykani alabawananllapa. Mastapis rini ruraq, masta alabawananllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Chaypi kaqkunaqam chay qayakuta uyashpaqa, nirqanllapa: —Syilupim lanyakuykan, nishpa. Wakinnataqmi nirqanllapa: —Dyuspa suq anjilninmi Jisusta parlachishqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Chaymi Jisusqa paykunata nirqan: —Chay qayakuqam mana noqapaqllachu. Ashwanmi uyashqallapaqa kanchiq, qamkuna yach'anayki: Tayta Dyusmi Jisusta parlachiykan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ch'ayamushqanam diya, Tayta Dyus paypi mana kriyiqkunata uchangunarayku kastiganambaq. Kananqam Dyusqa chay dyablutaqa binsishpa, rin qatiq, amana kay mundupi kamachikunambaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Noqata kay allpamanda alsawaptinllapaqam, yumbay runakunata rini kumbidaq, noqapi yuyakunanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Chaykunata nishpaqam, Jisukristuqa paykunata kayshina intyindichirqan: Suq kruspim rinllapa alsawaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Chayshina niptinqam, chay runakunaqa Jisusta nirqanllapa: —Dyuspa Santu Librumbim niwanchiqllapa: “Dyus Akrashqan Washadurqash tukuy tyimpu rin kawsaq”, nishpa. Chayshina Santu Libru niptinqa, ¿imaraykutaq qamqa niwangillapa: “Dyusmanda Shamuq Runatam rinllapa wanchiq”, nishpaqa? ¿Pitaq chay shamuq runaqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Chaymi Jisusqa paykunata nirqan: —Noqa Dyuspa michanqam suq tyimpupaqllana pullaykillapaqa rini kaq. Chayri achikchashuptiy, allita rurashpa kawsayllapa, ama tutayaqpishina purinaykillapa. Chaqa tutayaqpishina puriqqam mana yach'anchu: Maytam riykani, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Chayri noqa pullaykillaparaq kaptiy, noqapi yuyakuyllapa, qamkunapis michapishina kawsanaykillapa, nishpa. Jisusqam chayshina nishpaqa, suq ladumanna rirqan, amana chay runakunawan kanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Chaqa paykunapa ñawpambi achka milagrukunata ruraptimbismi, mana munarqanllapachu paypiqa yuyakuyta. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Chayshina mana kriyiptinllapaqam, kumplirqanna Dyuspaq chay rimaq Isayiyas Jisuspaq kayshina iskibrishqan: Taytitu, qambaq yach'achikuptiymi, mana pipis kriyiwashqachu. Manam ni pipis intyindishqachu: Qam ancha pudirniyuq kangi, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Chaymi chay isrraylinukunaqa mana atirqanllapachu Jisuspi yuyakuytaqa. Chaqa Isayiyasqam chay mana munaq kriyiqkunapaq kayshinapis iskibrishqa karqan: ");
INSERT INTO qvcNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Dyusqam paykunataqa qonqachishqa, angu shunqoyuq kanambaqllapa. Chaymi ima milagruta rikashpapis, noqapiqa mana yuyakunllapachu, paykunata washanaypaq, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Chaqa Dyuspa chay rimaq Isayiyasmi Jisusta ancha kamachikuqta, llipyaykaqta rikashqa karqan. Chaymi chayshina paypaq iskibrishqa karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Achka isrraylinukuna mana kriyiptimbismi, wakin isrraylinukuna awturidarnindin Jisuspi kriyirqanllapa. Piru mancharqanllapam: Chay farisiyukunach'i sinaguga wasimanda qatiwashunllapa, nishpa. Chaymi mana rimarqanllapachu: “Jisuspim kriyini”, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Chaqa mastam munarqanllapa, runakuna paykunata alabanambaq maski Dyusmanda. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jisusmi jwirtita rimashpa, nirqan: —Noqapi kriyiqqam mana noqapillachu kriyiykanqa. Ashwanmi Taytay Dyuspipis kriyiykanqa. Chaqa paymi kach'amuwashqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Chaymi mayqan noqata rikawaqqa chay kach'amuwaqtapis rikaykan. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Chaqa noqaqam kay mundupaqqa achikchakuq michanshina kani. Chaymi kay mundumanqa shamushqa kani, noqapi yuyakuqkuna tutayaqpishina ama chinganambaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Piru nishqayta mana kasuwaqtaqam noqaqa mana sintinsyanichu, kastigadu kanambaqqa. Chaqa manam shamushqachu kani, kay mundupi tiyaqkunata kastiganayqa. Ashwanmi shamushqaqa kani, paykunata washanaypaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Piru chay jwisyu diya ch'ayamuptinmi, nishqayta yach'ashpa mana kasuqtaqa Taytay Dyus rin kastigaq, chay nishqayta mana kasuwashqanrayku. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Chaqa noqaqam mana yuyashqaytachu yach'achikuniqa. Ashwanmi Tayta Dyus kach'amuwashqa, pay nishqandalla yach'achikunayqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Allitam kayshina yach'ani: Taytay Dyus kamachikushqanda kasuqkunam suq bidapi tukuy tyimpu rinllapa kawsaq, nishpa. Chaymi Taytay Dyus niwashqandalla yach'achikuniqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Paskwa fyista ch'ayamuykaptinnam, Jisusqa yach'arqan: Ch'ayamunnam wañunay diya, kay mundumanda Tayta Dyusman kutirinaypaq, nishpa. Kay mundupi Jisuspi kriyiqkunataqam payqa tukuy tyimpu ancha kuyarqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Piru dyabluqam Simumba churin Judas Iskaryutita yuyachishqa karqan, Jisusta intrigakunambaq kuntraqkunaman. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisusqam yach'arqan: Taytay Dyusmi noqata ancha pudirniyuqta rurawashqa. Paymanda shamushpam, paymanna rini kutiriq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Chaymi noqaykunawan mikuykashpa, mesapi tiyaykashqanmanda atarishpa, kapanda llushtikushpa, suq chakichikuq traputa sinturakurqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Chaymandaqam suq taksha pilankuman yakuta basyashpa, ch'akiyllapata mayllarqan. Mayllashpaqam, chay sinturakushqan trapuwan ch'akiyllapata chakichirqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Chaymandaqam Simun Pidrupa ch'akindana rirqan mayllaq. Chaymi Simun Pidruqa nirqan: —Taytitu, ¿qamchu ch'akiykunata ringi mayllaq? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Chaymi Jisusqa nirqan: —Noqa rurashqaytaqam manaraq atingichu intyindiyta. Chaymandaraqmi ringi intyindiqqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Chaymi Pidruqa Jisusta nirqan: —Taytitu, maychikapismi mana nunka balinmanchu, qam ch'akiykunata mayllanaykiqa, nishpa. Chaymi Jisusqa nirqan: —Noqa mana ch'akikita mayllaptiyqam, mana yach'akuqniychu ringi kaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Chayshina niptinraqmi, Simun Pidruqa nirqan: —Taytitu, amar ch'akiytallachu mayllayqa. Ashwanri makiykunata, umaytapis mayllayqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Chaymi Jisusqa kayshina nirqan: —Chayraq mayllakuqmi mana nisitanchu, tukuy kwirpunda mayllananqa. Chaqa tukuy kwirpunmi limpyu. Ch'akingunatallam balin mayllanambaqqa. Qamkunaqam yaqqa yumbayniki limpyu kangillapa; piru manam yumbaynikichu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Chayshinaqam Jisusqa nirqan, yach'ashpa: Pim rin intrigakuwaq kuntrawaqkunaman, nishpa. Chaymi nirqan “Manam yumbaynikichu limpyuqa kangillapa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Chayshina ch'akiyllapata mayllashpaqam, chay kapanda rurakurishpa, tiyarishpa mesaman, kayshina tapuwarqanllapa: —¿Intyindingillapachu: Imapaqraq Jisukristu ch'akiyllapata mayllashqa, nishpaqa? ");
INSERT INTO qvcNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Qamkunaqam niwangillapa: “Yach'achikuqniy” ichu “Kamachikuqniy”, nishpa. Chaytaqam allipta niwangillapa. Chaqa allibmi qamkunapa yach'achikuqniki, kamachikuqniki kani. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Piru chayshina kashpapismi, ch'akikillapata mayllashqa kani. Chayshinar qamkunapis suqniki suqniki ch'akikillapata mayllachinakuy. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Chaqa noqaqam allita rurashpa, kawsashqa kani. Chayri chay kawsashqayshina, qamkunapis shumaqta kawsayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Alliptam niykillapa, suq kriyaduqam mana atinchu kayta mas kamachikuq patrunninmandaqa. Suq kach'adupismi mana mas kamachikuqchu patrunninmandaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Kay nishushqayllapata intyindiwashpa, chayshina rurashpaqam, kushikushpa ringillapa kawsaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Chaytaqam mana yumbaynikipaqchu niykillapaqa. Chaqa qamkunata akrashushpaqam, allita riqsiykillapa. Piru rinmi kumpliq Dyuspa Santu Librumbi kayshina nishqan: “Noqawan pulla mikuqmi kuntraypaq tikrakashqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Chay nishushqayllapaqam manaraq kashqachu. Piru noqa kikiymi chaykunapaq niykillapa, chay nishushqayta rikashpa, kriyinaykillapa: Jisusmi Dyus Akrashqan Washadur, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Alliptam niykillapa, kach'ashqayta mayqan ch'ayachiqqam noqatashina ch'ayachiykan. Noqata ch'ayachiwaqqam kach'amuwaqtapis ch'ayachiykan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Chayshina nishpaqam Jisusqa ancha llakishpa, kayshina niwarqanllapa: —Alliptam niykillapa, qamkunamanda suqnikim ringi intrigakuwaq kuntrawaqkunaman, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Chaymi noqaykuna yach'akuqningunaqa chapanakurqayllapa. Chaqa manam yach'arqayllapachu: ¿Mayqanniypaqmi chayshinaqa niykan? nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Kanan Jisusqam noqata ancha kuyawarqan. Chaymi laditumbi isqandashpa, mikuykarqay. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Chaypi kaykaptiymi, Simun Pidruqa siñiyawarqan, Jisusta tapunaypaq: ¿Pish chay intrigakuqqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Chaymi noqaqa Jisusman isqandashpa, uyaritaplla tapurqay: —Taytitu, ¿pitaq chay intrigakushuqqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Chaymi Jisusqa niwarqan: —Noqam suq pidasu kachangata nuyuchishpa, chay intrigakuwaqtaqa rini qoq, nishpa. Chayshina niwashpaqam, suq pidasu kachangata mikunapi nuyuchishpa, Simumba churin Judas Iskaryutita qorqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Chay pidasu kachangata Jisus qoptinqam, Judasqa ch'askirqan. Piru chay urasmi dyabluqa Judaspa shunqonman yaykurqan. Chaymi Jisusqa paytaqa kayshina nirqan: —Chay ruranayki kaqtaqar utqana ruray, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Piru mesapi kaqkunaqam mana ni mayqanniypis intyindirqayllapachu: ¿Imapaqraq kayshinaqa nin? nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Wakinniyqam yuyarqayllapa: Judaspa makimbim chay taliga qellayqa. Chaych'i Jisusqa kach'aykan, kay fyistapaq imata randinambaq, ichuraq pubrikunata imata qonambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Chaymandaqam chay Judasqa chay pidasu kachangata mikushpaqa, chay kaykashqanmanda atarishpa, lluqshirqanna sawaman. Chay urasqam tutana karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Chayshina Judas sawaman lluqshiptinqam, Jisusqa nirqan: —Kay diyakunam Tayta Dyus noqapaq yumbayta rin yach'achiq: Noqamanda Shamuq Runam ancha allin, ancha pudirniyuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Chaqa noqa ancha allita rurashqayraykum, Taytay Dyusqa ancha alabadu rin kaq. Kanan Dyus kikinmi das yumbayta rin intyindichiq: Noqamanda Shamuq Runam ancha allin, ancha pudirniyuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Kuyashqay wambraykuna, mananam qamkunawanqa unaytachu rini kaq. Chayraykum ringillapa maskawaq. Piru isrraylinukunata nishqayshinam, qamkunatapis niykillapa, may rishqaymanqam mana atingillapachu riyta, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Chaymi kay mushuq kamachikushqayta niykillapa: Noqaqam ancha kuyaykillapa. Chayshinallar qamkunapis suqniki suqnikiwan kuyanakuyllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Chayshina qamkuna shumaqta kuyanakuptikiqam, chay rikashuqkunaqa rinllapa yach'aq: Alliptam paykunaqa Jisuspa yach'akuqninguna, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simun Pidrum Jisusta tapurqan: —Taytitu, ¿maymanmi ringi riq? nishpa. Chaymi Jisusqa nirqan: —May rishqaymanqam mana ringichu atiq ikiyta riytaqa. Chaymandaraqmi ringi sigiwaqqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Chayshina Jisus niptinqam, Pidruqa nirqan: —Taytitu, ¿imaraykutaq kananqa mana atinichu sigishuytaqa? Chaqa listum kani, qambi kriyishqayrayku wañunaypaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Chaymi Jisusqa nirqan: —¿Alliptachu qamqa listu kangi noqapi kriyishqaykirayku wañunaykiqa? Piru alliptam niyki, gallu manaraq kantaptinmi, kimsa kutinda ringi ñigawaq: “Manam riqsinichu Jisustaqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Amar llakiyllapachu ni manchayllapachu. Ashwanri Tayta Dyuspi yuyakushpaqa, noqapipis yuyakuyllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Taytay tiyashqambiqam kan ancha achka wasikuna. Mana kaptinqach'i, nishunayllapata. Noqam rishpa, mas wasikunata rurashaq qamkunapaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Chaymandaqam syilupi qamkunapaq chay lugarta allichashpa, rini kutimuq apashunayllapa, chay kashqaypi qamkunapis pullay kanaykillapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Qamkunaqam noqapaq yach'angillapana: Jisukristum waqmanmi rin, nishpa. Chaqa ñandapismi riqsingillapana. ");
INSERT INTO qvcNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Chayshina Jisus niptinqam, Tumasqa nirqan: —Taytitu, manam yach'anillapachu: Maymanmi ringi, nishpaqa. Chayshinaqa ¿imashinataq atinillapa yach'ayta: Mayqan ñandam rishaqllapa chay rishqaykimanqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Chaymi Jisusqa kayshina nirqan: —Dyusman riq ñanmi kani. Allip kaqmi kani. Kawsachikuqpismi noqa kani. Chaqa manam pipis pay kikinllaqa atinchu ch'ayayta Tayta Dyusmanqa. Noqaraykullam atingillapa ch'ayaytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Chaymi noqata riqsiwashpaqa, Taytaytapis riqsingillapa. Chaqa noqata rikawashpaqam, alabis paytapis rikaykangillapana, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Chaymi Filipiqa nirqan: —Taytitu, rikachiwayllapar Taytaykita, payta rikashpa, noqaykuna kushikunaypaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Chayshina tapuptinmi, Jisusqa Filipita nirqan: —¡Filipi, unaynam qamkunawanqa kani! ¿Ima, kanangamanchu manaraq riqsiwashqa kangi? Noqata rikawaqqam Taytaytapis rikashqana. Chayshinaqa ¿imaraykutaq niwangi: “Rikachiwayri Taytaykita”, nishpaqa? ");
INSERT INTO qvcNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Ima, manachu kriyingi: Jisusmi Taytanwan suqlla; Tayta Dyusmi Jisuswan suqlla, nishpaqa? Chaqa tukuy ima nishushqayqam mana noqapa yuyayniyllachu. Ashwanmi Taytay noqawan kashpa, yumbay chay rurashqaykunata pay kikin rurashqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Chayri kriyiwayllapa, Taytaywanmi suqlla kani. Paypismi noqawan suqlla. Piru mana munashpa kriyiwaytaqa, chay rurashqaykunata rikashpa, kriyiwayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Chaqa alliptam niykillapa, noqapi kriyiqkunaqam rurashqay layakunata rinllapa ruraq. Noqa Taytayman riptiymi, mas ispantaypaq milagrukunata rinllapa ruraq. ");
INSERT INTO qvcNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Chaymi shutiypi tukuy ima mañawashqaykita rini ruraq. Chayshina ruraptiyqam, ancha achka runa, warmi Tayta Dyusta rinllapa alabaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Mushuqmanda niriykillapa: Noqapa shutiypi tukuy ima mañawashqaykitam rini ruraq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Qamkuna noqata allipta kuyawashpaqar, kamachikushqayta rurayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Kanan noqaqam Taytayta rini mañaq, suq kunswilashuqta kach'amunambaq, qamkunapa pullayki tukuy tyimpu kanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Payqam Dyuspa Santu Ispiritun. Payqam allip kaqtalla qamkunata rin yach'achishuq. Piru noqapi mana kriyiqkunaqam paytaqa mana atinllapachu ch'askiyta shunqombiqa. Chaqa paytaqam mana rikanllapachu, ni riqsinllapachu. Piru qamkunaqam Santu Ispiritutaqa riqsingillapa, qamkunawan kashqanrayku. Kanan payqam qamkunapi tukuy tyimpu rin kawsaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Manam rinichu dijashuqllapa wakchatashinaqa. Ashwan qamkunamanmi rini kutimuq. ");
INSERT INTO qvcNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ashla tyimpumandaqam runakunaqa manana rinllapachu rikawaq. Piru qamkunaqam ringillapa rikariwaq. Chaqa noqa kawsamushqayraykum qamkunapis tukuy tyimpu ringillapa kawsaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Chay kawsamushqay diyapim qamkunaqa ringillapa yach'aq Taytaywan kashqayta, noqawan kashqaykillapata, noqapa ispirituy qamkunapa shunqoykipi kashqanda. ");
INSERT INTO qvcNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Kamachikushqayta kasuqqam allipta kuyawan. Chay kuyawaqtaqam Taytayqa kuyan. Noqapismi paytaqa kuyashpa, payman rini shamuq riqsiwanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Chaymi suq Judas (mana chay Judas Iskaryutichu), nirqan: —Taytitu, ¿imashinam noqaykunallaqa rinillapa rikashuqqa? ¿Imaraykutaq chay mana kriyiqkunapis mana rinllapachu rikashuqqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Chayshina tapuptinmi, Jisusqa chay allin Judasta nirqan: —Qamkuna kuyawashpaqam, nishqayta ringillapa kasuwaq. Kanan Taytayqam qamkunata rin kuyashuq. Chaymi noqaqa Taytaywan rini shamuq, qamkunawan pulla kawsanaypaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kay nishushqayqam mana noqapa yuyayniyllachu. Ashwan chay kach'amuwaq Taytay niwashqandallam noqaqa niykillapa. Piru mana kuyawaqqam chay nishqaytaqa mana kasunchu. ");
INSERT INTO qvcNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Yumbay kaykunatam pullaykillapa kashparaq, noqa kikiy niykillapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Piru Taytaymi rinna kach'amuq Santu Ispiritunda noqapa rrimplasuy, qamkunata yanapashushpa kunswilashunan. Chay Santu Ispiritunmi tukuy imata rin yach'achishuqllapa. Tukuy ima nishushqaytapismi rin yuyachishuqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Dyuspi mana kriyiqkunaqam mana noqashinaqa atinllapachu yanapashuyta, kushikushpa shumaqta kawsanaykillapa. Piru noqaqam rini yanapashuqllapa, kushikushpa kawsanaykillapa. Chaymi dispidikashpa niykillapa, ama nimata manchayllapachu ni llakiyllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Chaqa uyawashqam kangillapa, kayshina nishushqayta: “Rishpaqam rini kutimuq qamkunaman”, nishpa. Noqamandaqam Taytay mas kamachikuqqa. Chaymi qamkuna allipta kuyawashpaqa, Tayta Dyusman riptiyqa, dijuru kushikungimanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kaykunataqam nishushqallapa kani, manaraq nimapis pasaptin, kay nishushqayta rikashpa, noqapi yuyakunaykillapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Qamkunawanqam manana achkataqa rinichu parlaq. Chaqa kay mundupa kamachikuqnin dyabluqam shamuykanna. Piru payqam mana nima pudirniyuqchu, noqata kamachiwananqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ashwanmi Tayta Dyusta kasushpa, noqaqa rini wañuq, yumbay runakuna, warmikuna yach'ananllapa: Jisukristum Tayta Dyusta kuyashpa, kamachishqanda ruran, nishpa. Chaymandaqam nirqambis: —Atariyllapa. Akullapana, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jisusqam kayshinapis yach'achikurqan: —Noqaqam suq yura ubasshina kani. Taytayqam chay yura ubasta kwidaqshina. ");
INSERT INTO qvcNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Noqapi yuyakuqkunaqam chay yurapa allin rikrangunashina. Piru Taytayqam chay yurapa mana puqoq rikrangunataqa kuchun. Piru chay puqoq rikrangunataqam tirapashpa qoraykanshina. Chaqa paykunapa bidanmanda tukuy ima mana baliqkunata wichukuykan, mas shumaqta payta kasunanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Chaymi Dyus nishqanda yach'achishuptiyqa, qamkunaqa qoradushina kangillapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Noqaqam qamkunata tukuy imapi rini yanapashuq. Chayri noqapi tukuy shunqo yuyakushpa, kawsayllapa. Chaqa suq yura ubaspa rikran pitikashpaqam, manana atinchu puqoyta. Chayshinallam qamkunapis noqapi mana yuyakushpaqa, mana atingillapachu Dyus munashqanda rurashpa kawsaytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Noqaqam chay yurashina kani. Qamkunaqam chay yurapa rikrangunashina kangillapa. Chaymi noqapi yuyakuptikiqa, rini yanapashuq, allita rurashpa kawsanaykillapa, ancha puqoq yurashina kanaykillapa. Piru noqapi mana yuyakushpaqam, mana atingillapachu shumaqta kawsaytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Chaqa noqapi mana yuyakuqqam wichukushqa rin kaq. Tukuy jwirsandam limpu rin pyirdiq, suq yurapa rikran pitikashpa chakiqshina. Chay rikrandaqam ninapi rupachinllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Piru qamkuna noqapi yuyakushpa, nishushqayta kasuwaptikiqam, tukuy ima mañashqaykita Taytayqa rin qoshuqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kanan qamkuna allita rurashpa kawsaptikiqam, chay rikashuqkunaqa Dyusta rinllapa alabaq. Chaqa chayshina kawsashpa, ancha puqoq yurashina kashpaqam, allip yach'akuqniykuna ringillapa kaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Taytaymi noqata ancha kuyawan. Chayshinallam noqapis qamkunataqa ancha kuyayki. Chayshina kuyashuptiyqar, noqamandaqa ama akrakayllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Chaqa noqaqam Taytay Dyus niwashqanda kasuni. Chaymi paymandaqa mana akrakanichu. Chayshinallam qamkunapis kasuwashpaqa, mana nunka noqamandaqa ringillapachu akrakaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Chaykunataqam niykillapa, noqawan tukuy shunqo kushikunaykillapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Chaymi kayshina kamachiykillapa: Noqa kuyashushqayshinar, suqniki suqnikiwan kuyanakuyllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Suq runa yanasungunata (yanasangunata) ancha kuyashpaqam, wañunman washanambaq. Chay laya wañuqmi yumbay runamanda mas kuyakuqqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nishushqayta kasushpaqam, yanasuykuna (yanasaykuna) kangillapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mananam kriyadushinachu kangillapa. Chaqa suq kriyaduqam mana yach'anchu: Patrunniymi kay imata rin ruraq, nishpaqa. Piru noqaqam Taytay tukuy ima niwashqanda qamkunata nishushqa kani. Chaymi yanasuykunana (yanasaykunana) kangillapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Piru manam qamkunachu noqataqa akrawashqa kangi. Ashwanmi noqa qamkunata akrashushpa, numbrashushqa kani, rinaykillapa noqapa shumaq nutisyayta yach'achikuq, achka runa, warmi tukuy tyimpu noqapi yuyakunanllapa. Chayshina ancha puqoq yurashina kaptikillapaqam, noqapa shutiypi tukuy ima mañakushqaykita Tayta Dyusqa rin qoshuqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Chaymi niriykillapa, suqwan suqwan kuyanakunayki. ");
INSERT INTO qvcNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Noqapi mana kriyiqkunam ancha ch'iqniwanllapa. Chaymi qamkunatapis ch'iqnishungillapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Chaqa unaynam noqapi mana kriyiqkunamanda akrashushqallapa kani. Chaymi paykunashina manana ruraptikillapaqa, ch'iqnishungillapa. Piru qamkuna mana allita ruraptikiqach'i, paykunaqa kuyashungimanllapa uchayuq masingunatashina. ");
INSERT INTO qvcNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","21","Chaqa qamkunata nishushqayshinam: “Suq kriyadutaqa mana rrispitanllapachu maski patrunninmandaqa.” Chayshinallam qamkunatapis mana rinllapachu rrispitashuq maski noqamandaqa. Chaymi chay mana kriyiqkunaqa noqata qesachawashpa, qamkunatapis rinllapa qesachashuq. Chaqa noqapi mana kriyiqkunaqam kach'amuwaq Dyustapis mana riqsinllapachu yuyaynimbiqa. Chaymi qamkuna noqapi yuyakuptikiqa, qamkunatapis rinllapa qesachashuq. Piru kasuwaqkunaqam qamkunatapis rinllapa kasushuq. ");
INSERT INTO qvcNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Noqa mana shamuptiy yach'achikuqqach'i, chay qesachakuqkunaqa mana uchayuqchu kananda. Piru kananqam uchangunapaq yach'achiptiyqa, manana atinllapachu niyta: “Manam yach'arqaychu: Uchayuqmi kani, nishpaqa”. ");
INSERT INTO qvcNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Chaymi noqata ch'iqniwaqkunaqa Taytaytapis ch'iqniykanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kanan ispantaypaq milagrukunata paykunapa ñawpambi mana ruraptiyqach'i, mana uchayuqchu kanandallapa. Piru paykunaqam chay milagrukunata rikashpapis, noqata, Taytayta ch'iqniwanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Piru chayshinaqam pasashqa, kumplinambaq Dyuspa Santu Librumbi kayshina nishqan: “Mana nima uchayuq kaptiypismi, ch'iqniwarqanllapa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Piru noqaqam Tayta Dyusman rishpaqa, rini kach'amuq chay kunswilakuq Santu Ispiritunda. Paymi Dyusmanda shamushpa, allip kaqtalla rimashpa, noqapaq rin yach'achishuqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Qamkunapismi noqapaq ringillapa yach'achikuq. Chaqa qallarishqay diyamandapacham qamkunaqa pullay kashqallapa kangi. ");
INSERT INTO qvcNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jisusqam nirqambis: —Chaykunataqam nirqaqllapa, qamkuna padisishpapis, ama disanimakanayki. ");
INSERT INTO qvcNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Chaqa rinllapam qatishuq sinaguga wasikunamanda. Rinmi ch'ayamuq tyimpu, wanchishuqkuna kayshina yuyanan: Chay mana baliq Jisuspi kriyiqkunata wanchishpaqam, Taytanchiq Dyusta kasuykanchiq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Chaqa paykunaqam noqapi Taytaypi mana nunka yuyakushpa, chayshinaqa rinllapa wanchishuq. ");
INSERT INTO qvcNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Kayshinaqam niykillapa, chay qesachashunan uras ch'ayamuptin, yuyanaykillapa kay nishushqayta, nishpa. Jisusqam kayshinapis noqaykunataqa yach'achiwarqan: —Qamkunawan kaykashpam, manaraq yumbaytachu nishurqaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Kanan rininam kutiriq Taytay kach'amuwaqman. Piru qamkunaqam mana tapuwangichu: “¿Maymanmi ringi?” nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ashwanmi kaykunata nishuptiyllapaqa, ancha llakingillapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Piru ama llakiyllapachu. Allip kaqtam niykillapa. Qamkunapaqqam mas alli, kay mundumanda rinaypaq. Mana riptiyqam, chay kunswilashuq Santu Ispirituqa mana rinchu shamuq qamkunamanqa. Piru noqa rishpam, rini kach'amuq, qamkunaman shamunambaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Chaymi chay Santu Ispiritu shamushpaqa, kay mundupi uchayuqkunata rin yuyachiq: Ay, uchayuqmi kani, ninambaqllapa. Rinmi yuyachiqpis: Dyusmi ancha allin. Paymi rin jusgawaqninchiq, ninambaqllapa, ");
INSERT INTO qvcNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","yach'anambaqllapa: Jisuspi mana kriyishqayraykum, uchayuqna kani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Chayshina Taytay kashqanman kutiptiyqam, manana ringillapachu rikawaq. Piru ringillapam yach'aq: Jisukristum ñanninchiqshina, Dyusman rinanchiqllapaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ringillapapismi yach'aq: Tayta Dyusmi, ancha allita jusgashpa, kay mundupa kamachikuqnin dyabluta sintinsyashqana, kastigadu kanambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Jisusqam kayshinapis nirqan: —Kanmi masta qamkunata nishunaypaq. Piru kananqam mana ringillapachu atiq intyindiyta. ");
INSERT INTO qvcNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Piru Dyuspa Santu Ispiritun shamushpam, tukuy ima allip kaqta rin yach'achishuqllapa. Manam rinchu yach'achishuq pay yuyashqandaqa. Ashwanmi yumbay uyashqanda qamkunataqa rin intyindichishuq: Kaykunam rin pasaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Chay Santu Ispiritum noqataqa rin alabawaq. Kanan noqamanda uyashqandam rin yach'achishuqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Taytay Dyus tukuy ima yuyashqandam noqapis yach'ani. Chaymi chay yach'ashqayta Santu Ispiritupis rin yach'achishuqllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jisusqam kayshinapis nirqan: —Ashla diyamandaqam manana ringillapachu rikawaq. ˻Chaqa Taytaymannam rini kutiriq.˼ Piru ashla diyamandaqam mushuqmanda ringillapa rikariwaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Chaymi wakin noqaykuna yach'akuqningunaqa suqniy suqniy kayshina parlarqayllapa: —¿Imapaqmi kay layataqa niwanchiq? ¿Imam munan niyta: “Ashla diyamandaqam manana ringillapachu rikawaq. Chaqa Taytaymanmi rini kutiriq. Piru ashla diyamandaqam mushuqmanda ringillapa rikariwaq”, nishpa? ");
INSERT INTO qvcNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Imam munan niyta, “Ashla diyamanda”, nishpaqa? Manam intyindinichu chay nishqandaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Piru Jisusqam yach'arqanna noqaykuna parlashqaypaq. Chaymi niwarqanllapa: —Noqam nishushqallapa kani: “Ashla diyamandaqam manana ringillapachu rikawaq. Piru ashla diyamandaqam mushuqmanda ringillapa rikariwaq” nishpa. ¿Ima, kaypaqchu qamkunaqa tapunakuykangi? ");
INSERT INTO qvcNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Alliptam niykillapa, qamkunaqa ancha llakishpa, ringillapa waqaq. Piru noqata kuntrawaqkunaqam rinllapa kushikuq. Piru chayshina qamkuna ancha llakishpapismi, ringillapa kushikuq. ");
INSERT INTO qvcNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Suq warmi qeshyanan uras ch'ayamuptinqam, nanaywan ancha padisin. Piru wawitanda qeshyashpaqam, qonqanna nanashqandaqa. Chaqa kay mundupi wawitan nasiptinqam, anchana kushikun. ");
INSERT INTO qvcNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Chayshinam qamkunapis kananqa ancha llakingillapa. Piru kutimushpam, rini watukushuqllapa. Chay diyapiqam tukuy shunqo ancha ringillapa kushikuq. Mananam ni pipis atinqachu llakichishuytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Kanan chay diyapiqam manana nimatapis ringillapachu tapuwaq. Ashwanmi allipta niykillapa, shutiywan Taytay Dyusman ringillapa mañakuq. Chaymi payqa rin qoshuqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kanangamanmi mana nimatapis shutiywanqa Taytaymanqa mañakushqallapachu kangi. Paymanri mañakuyllapa, ch'askishpa, ancha kushikunaykillapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Kanangamanmi achka kumparasyunwan qamkunata yach'achishushqa kani. Piru suq tyimpupiqam manana chay kumparasyungunawanqa rinichu yach'achishuqllapa. Ashwanmi ancha klaruta rini yach'achishuqllapa Taytaypaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Chay tyimpupiqam Taytaymanqa ringillapa mañakuq noqapa shutiypi. Mananam nisisaryuchu rin kaq, noqalla qamkunapaq mañakunaypaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Chaqa qamkunaqam noqata kuyawashpa, yuyakungillapa: Jisukristum Tayta Dyusmanda shamushqa, nishpa. Chaymi Taytay Dyus ancha kuyashungillapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Tayta Dyusmandam kay munduman shamurqay. Piru kananqam kay munduta dijashpa, paymanna rini kutiriq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Chaymi noqaykuna yach'akuqningunaqa nirqayllapa: —Kananqam manana kumparasyunwanchu noqaykunataqa yach'achiwaykangi. Ashwanmi ancha klarutana niwaykangillapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Kananqam noqaykunaqa intyindinina: Qami tukuy imata yach'angi, nishpa. (Chaqa manaraq tapushuptiyllapam, qamqa yach'angina: Kayshinam rinllapa tapuwaq, nishpa.) Chaymi mana ni nisisaryuchu noqaykuna tapushunayqa. Chayraykum yach'anillapa: Dyusmi qamtaqa kach'amushushqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Chaymi Jisusqa kayshina niwarqanllapa: —¿Kananqachu allipta noqapi yuyakungillapa? ");
INSERT INTO qvcNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Kanalitanmi chay urasqa rinna ch'ayamuq. Chay uraspillam qamkunaqa waqta kayta ringillapa shikwakaq. Noqataqam sapalitayta ringillapa dijawaq. Piru manam sapalitayllachu rini kaq. Chaqa Taytaymi noqapa pullay. ");
INSERT INTO qvcNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Chaymi kaykunata nishushqallapa kani, noqapi allita yuyakushpa, ama nimata manchanaykillapa. Kay mundupi ringillapa padisiq. Piru noqapi yuyakushpa, animakayllapa. Chaqa noqaqam kay mundupi yumbay kuntrawaqkunata binsishqa kani. ");
INSERT INTO qvcNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Chaykunata nishpaqam, Jisusqa syiluman chapakushpa, kayshina mañakurqan: —Taytitu, chay wañunay urasqam ch'ayamuykanna. Chayri runakunata noqa Churikipaq intyindichiy: Jisukristum ancha allin ancha kamachikuq, nishpa. Chayshina willaptikiqam, noqapis paykunata atishaq yach'achiyta: Tayta Dyusmi ancha allin kamachikuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Qami numbrawashqa kangi, yumbayta kamachinaypaq, noqapi yumbay yuyakuqkunata tukuy tyimpupaq kawsachinaypaq. Chaqa paykunatam animachishqa kangi, noqapi yuyakunanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kanan qamllam allip Dyusqa kangi. Qam kikikim kach'amuwashqa kangi kay munduman. Chaymi qambi, noqapi yuyakuqkunaqa suq bidapi tukuy tyimpupaq rinllapa kawsaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Yumbay niwashqaykitam rurashqana kani, kay mundupi yumbay tiyaqkuna yach'ananllapa: Tayta Dyusmi ancha allin kamachikuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Taytitu, unayqam manaraq kay mundu kaptin, ancha baliq llipyaq kamachikuq kashpa, qamwan kawsarqay. Kanambisri ruray, chay unayshina karinaypaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Kay mundupi kawsaqkunamandam qam wakingunata akrashqa kangi, yach'akuqniykuna kanambaq. Chaymi paykunata qambaq yach'achishqa kani. Kanan paykunaqam qam nishqaykita kasushqallapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Chaymi kananqa paykunaqa yach'anllapa: Jisukristum tukuy imata ruran, yach'achikun, Tayta Dyus yanapaptin, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Chaqa qam niwashqaykitallam paykunataqa yach'achishqa kani. Chaymi noqapi allita yuyakushpa, kananqa yach'anllapana: Allibmi Tayta Dyus Churin Jisukristuta kach'amushqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Chaymi qamba kaqkunapaq ancha rrugayki. Chaqa paykunataqam noqata qowashqa kangi. Piru chay kuntrashuqkunapaqqam mana rrugaykichu. ");
INSERT INTO qvcNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Chaqa noqapa yumbay yach'akuqniykunaqam qambapis. Chayshinallam qamanda yumbay yach'akuqkunapis noqapa. Chayshina noqapa kashpam, paykunapis suqkunata intyindichinllapa: Jisukristum ancha allin kamachikuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Noqaqam kay mundumandaqa qamanna rini shamuq. Piru yumbay yach'akuqniyqam kay mundupilla rinllapa kidaq. Chaymi ancha allin Taytitu, qamta rrugayki noqapi yuyakuqkunata allita kwidanayki, suq ayllushina kuyanakushpa kawsananllapa, qam noqawan kawsashqanchiqshina. ");
INSERT INTO qvcNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Chaqa kay mundupi paykunapa pullanllapa kashpaqam, noqaqa chay qowashqayki yach'akuqniykunata kwidashqa kani, qam yanapawaptiki. Chaymi yumbay paykunamanda chay chinganambaq kaqlla rin chingaq, dyabluta kasushqanrayku. Chayshina chingaptinmi, qamba Santu Libruykipi nishqanqa rin kumpliq. ");
INSERT INTO qvcNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Kananqam qam kashqaykimanna rini kutimuq. Piru kay mundupiraq kashpaqam, kay yach'akuqniykunata yach'achini, noqa kushikushqayshina, paykunapis ancha kushikunambaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Chaymi noqaqa yach'achiwashqaykita paykunataqa yach'achishqana kani. Chayraykum chay mana munaq kriyiqkunaqa paykunataqa ancha ch'iqninllapa. Chaqa noqapi kriyiqkunapismi noqashinana yuyanllapa. Mananam yuyanllapachu chay mana kriyiqkunashinaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Piru manam rrugaykichu, paykunata kay mundumanda surqonaykipaqqa. Ashwanmi rrugaykiqa dyablumanda washanaykipaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Noqaqam mana kay mundumanda kaqkunashinachu yuyani. Chayshinallam noqapi kriyiqkunapis manana kay mundumanda kaqkunashinachu rinllapa yuyaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Yush'ayku paykunata akrashpa yach'achiy, qamtalla kasushunanllapa. Chaqa chay yach'achikushqaykiqam mana llullachu. Ashwanmi allip kaqlla. ");
INSERT INTO qvcNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Taytitu, qamqam kay munduman kach'amuwashqa kangi. Chayshinallam noqapis kay yach'akuqniykunata kay mundupi tiyaqkunaman kach'ashqa kani, noqapaq yach'achikunanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Chaqa paykunata washanaypaqmi noqa kikiy intrigakani wañunaypaq, paykunapis allip kaqpi kriyishpa, tukuy shunqo qaman intrigakananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Paykuna noqapaq yach'achikuptinmi, suqkunapis noqapi rinllapa yuyakuq. Chaymi mana kay kriyiqkunapaqllachu rrugaykiqa. Ashwanmi rruqaykiqa noqapi manaraq kriyiqkunapaqpis, ");
INSERT INTO qvcNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","yumbaynin qambi, noqapi kriyishpa, suq ayllushina kanambaqllapa, qam noqawan suq ayllushina kashqanchiqshina. Chayshina kuyanakushpa kawsaptinllapam, suqkuna paykunata rikashpa, rinllapa kriyiq: Taytanchiq Dyusmi Jisusta kach'amushqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Chaqa qam numbrawashqa kangi, ancha yach'ayniyuq kamachikuq kanaypaq. Chayshinallam noqapis kay yach'akuqniykunata numbrashqa kani, ancha yach'ayniyuq kamachikuqkuna kashpa, kuyanakushpa, suq kwirpushinalla kananllapa, qam noqawan kashqanchiqshina. ");
INSERT INTO qvcNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Kanan qamqam noqawan kashpa, ancha yanapawangi. Chayshinallam noqapis paykunawan kashpa, ancha yanapani, suqwan suqwan kuyanakushpa kawsananllapa. Chayshina shumaqta kawsaptinllapam, chay mana kriyiqkunapis yach'anqallapa: Alliptam Tayta Dyusqa Jisusta kay munduman kach'amushqa, nishpa. Yach'anqallapapismi: Tayta Dyusmi paypi kriyiqkunata ancha kuyan, Churin Jisusta kuyashqanshina, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Taytitu, ancham rruqaykipis, kay qowashqayki yach'akuqniykuna may kashqaypi, pullay kanambaqllapa. Rrugaykipismi yach'anambaqllapa: Tayta Dyusmi Churin Jisusta ancha kuyashpa, ancha alaban, nishpa. Chaqa kay munduta manaraq rurashpam, noqata ancha kuyawashqa kangi. ");
INSERT INTO qvcNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ancha allin Taytitu, qamta kuntrashuqkunaqam mana riqsishungichu. Piru noqaqam riqsiyki. Kanan yumbay kay yach'akuqniypismi yach'an: Taytanchiq Dyusmi Churin Jisusta kay munduman kach'amushqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Taytitu, noqam paykunataqa yanapashqa kani, qamta riqsishunambaq shunqonllapapi. Chayshinallam paykunata masta rini intyindichiq, suqkunata kuyanambaqllapa, noqata kuyawashqaykishina. Chaqa chayta paykuna intyindiptinqam, noqapa ispirituyqa paykunapa shunqombi rin kaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Chayshina Tayta Dyusman mañakushpaqam, Jisusqa noqaykuna yach'akuqningunawan rirqayllapa chay kibrada Sidrumba chimba ladunman. Chaypim karqan suq wirta. Chay wirtamanmi yaykurqayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Chay Judas Jisusta intrigakuqpismi riqsirqan chay wirtataqa. Chaqa Jisusqam achka bwiltasta noqaykunawan chaypiqa tandakashqa karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Chaypi kaykaptiyllapam, kamachikuq isrraylinu kurakuna, farisiyukunapis Dyuspa adurana wasinmanda suldadukunata kach'amurqan. Achka rrumanu suldadukunapismi paykunawanqa shamurqan. Yumbaymi shamurqanllapa lamparakunawan michakunawan, qerukunata, atun kuchillukunata piskakushpa. Chay runakunapa ñawpandaqam Judas Iskaryuti shamurqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Piru Jisusqam yach'arqanna: Kayshinam rin pasawaq, nishpa. Chaymi das ñawpaman rishpa, yumbayta tapurqan: —¿Pitam maskaykangillapa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Paykunaqam nirqan: —Jisus Nasaritmanda kaqtam maskaykanillapa, nishpa. Chaymi Jisusqa nirqan: —Noqam kani Jisus Nasaritmanda kaqqa, nishpa. Kanan chay suldadukunapa pullanmi chay intrigakuq Judasqa karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Chay uras Jisus “Noqam kani” niptinmi, chay runakunaqa ikip ikip rishpa, pachaman waqtakarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Chaymandaqam Jisusqa tapurirqan: —¿Pitam maskaykangillapa? nishpa. Chaymi paykunaqa nirirqanllapa: —Jisus Nasaritmanda kaqtam maskaykanillapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Chaymi Jisusqa paykunata nirirqan: —Nishushqallapanam kani: “Noqam kani”, nishpa. Noqata maskawashpaqa, kay suq runakunataqa dijayllapa rinambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Chayshina niptinmi, kumplirqan pay kikin kayshina nishqan: “Taytitu, chay qowashqayki sigiwaqkunamandaqam mana ni suqta dijashqachu kani chinganambaq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simun Pidruqam atun kuchilluyuq karqan. Chaymi payqa chay sinturakushqan kuchillunda baynanmanda surqoshpa, chay mas kamachikuq isrraylinu kurapa kriyadun Malku shutiqta machitiyashpa, allin ladu rinrinda pitirqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Chayta rikashpaqam, Jisusqa Pidruta nirqan: —Chay atun kuchilluykitaqa chay baynambina waqaychay. Taytaymi niwashqa, ancha ñakanaypaq. Chay ñakaykunaqam noqapaqqa upyanaypaq ancha ayaq yakushina. ¿Akasuchu mana rini ñakaq? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Chay rrumanu suldadukunam kamachikuqninwan tukuy isrraylinukunapa suldadungunawan Jisusta piskashpa, makingunata ch'aqnarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Chaymandaqam aparqanllapa Anaspa wasinman. Chaqa Anasqam Kayfaspa swigrun karqan. Kayfasqam chay tyimpupiqa mas kamachikuq isrraylinu kura karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Chay Kayfasmi chay mas kamachikuq isrraylinukunata nishqa karqan: “Noqanchiqkunapaqqam mas alli, suq runa wañunambaq, yumbay llaqta masinchiqkuna ama wañunanllapa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simun Pidrum suq yach'akuq masinwan Jisuspa ikinda rirqanllapa. Chay suq yach'akuqqam chay mas kamachikuq isrraylinu kurapa riqsishqan karqan. Chaymi payqa chay kurapa wasimba patyunman Jisuswan yaykurqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pidruqam sawa pungupilla kidarqan. Chaymi chay suq yach'akuq masinqa punguman shamushpa, purtira chinata rrugashpa, ukukaman Pidrutaqa aparqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Chaymi chay purtira chinaqa Pidrutaqa kayshina tapurqan: —¿Manachu qambis Jisuspa suq yach'akuqnin kangi? nishpa. Chaymi Pidruqa nirqan: —Manám, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kanan ancha chiri kaptinmi, chay kamachikuq kurapa kriyadunguna, wakin suldadukunawan shayashpa, ninapi mashakuykarqanllapa. Chaymi Pidrupis paykunapa pullan shayashpa, mashakuykarqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Chay mas kamachikuq isrraylinu kuraqam Jisusta tapurqan: —¿Pikunam yach'akuqnikiqa? ¿Imatam yach'achikushqa kangi? ");
INSERT INTO qvcNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Chaymi Jisusqa nirqan: —Noqaqam yumbaypa ñawpambi rimashqa kani. Kutin kutinmi sinaguga wasikunapi, Dyuspa adurana wasimbipis yach'achikushqa kani. Chaqa yumbay llaqta masinchiq isrraylinukunam chaykunapi tandakanllapa. Manam nimatapis pakakushpaqa, yach'achikushqachu kani. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Chayshinaqa ¿imaraykutaq tapuwangi noqataqa? Chay uyawaqkunata tapuyqa. Paykunam nishunqallapa chay yach'achikushqaytaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Chayshina Jisus niptinmi, suq suldadu chaypi kaqqa suq laputa Jisusta qoshpa, tapurqan: —¿Ima, chayshinachu mas kamachikuq kuranchiqta kuntistangi? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Chayshina niptinmi, Jisusqa nirqan: —Mana allita rimashqa kaptiyqa, niway ima malutam rimashqa kani, nishpa. Piru allip kaqta rimashqa kaptiyqa, ¿imapaqtaq maqawangiqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Chaymandaqam Anasqa Jisusta ch'aqnashqatalla kach'arqan chay mas kamachikuq kura Kayfasman. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pidru chaypilla shayashpa mashakuykaptinmi, kayshina tapurqanllapa: —¿Manachu qamqa chay runapa suq yach'akuqnin kangi? nishpa. Chaymi Pidruqa nirqan: —Manam noqaqa yach'akuqninchu kani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Chay kamachikuq kurapa suq kriyadunmi, chay kriyadupa rinrinda pitishqamba ayllun karqan. Payqam Pidruta tapurqan: —¿Akasuchu mana rikashushqa kani chay Jisuswan pulla kaptiki chay wirtapi? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Piru Pidruqam chayshina tapuptinqa, suq kutinda ñigarirqan. Chay urasllam suq gallu kantarqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Nuta: Chay tyimpukunapim Rruma llaqtamanda kaqkuna achka nasyungunapi, Isrrayilpipis kamachikurqanllapa. Isrrayilpa rrumanu gubyirnunqam Pilatu shutirqan.  Achikyaykaptinnam Kayfaspa wasinmanda Jisusta aparqanllapa rrumanu gubyirnu Pilatupa dispachunman. Piru manam yaykurqanllapachu chay dispachunmanqa. Chaqa kriyirqanllapa: Chay furastiru rrumanukunawan kashpa, mapa shunqoyuq rinchiq kidaq. Chayshina kidashpaqam, manana atinchiqmanchu mikuyta chay Paskwa fyistapi mikunataqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Chaymi chay gubyirnu Pilatuqa dispachunmanda lluqshishpa, paykunata tapurqan: —¿Ima malutam rurashqa kay runaqa, qamkuna payta kuntranaykiqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Chaymi paykunaqa nirqanllapa: —Kay runa mana maluta rurashqa kaptinqach'i, noqaykunaqa mana apamunaytachu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Chaymi Pilatuqa paykunataqa nirqan: —Qamkuna chay runata apashpa, liyniki nishqanshina justisyata rurayllapa, nishpa. Chayshina niptinqam, chay isrraylinukunaqa nirqan: —Qamkuna rrumanukunam mana dijawangillapachu wanchinayllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Chayshinam kumplirqan Jisus nishqanqa: “Kruspim rini wañuq”, nishpa. (Chaqa rrumanukunallam kruspi klabashpa wanchirqanllapa.) ");
INSERT INTO qvcNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Chaymi Pilatuqa yaykushpa dispachunman, Jisusta qayashpa, tapurqan: —¿Qamchu isrraylinukunapa gubyirnunqa kangi? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Chaymi Jisusqa tapurqan: —¿Kikin yuyaynikimandachu kayshinaqa tapuwangi, ichu suqkuna parlachishushqa kaptin? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Chaymi Pilatuqa nirqan: —Manam noqaqa isrraylinuchu kani, qambaq yach'anaypaqqa. Ashwan llaqta masiki isrraylinukuna, chay kamachikuq kurakunapismi qamtaqa intrigawashqallapa, kayshina tapushunaypaq: ¿Ima malutam rurashqa kangi? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Chaymi Jisusqa Pilatuta nirqan: —Suq lugarpim gubyirnuqa kani. Manam kay mundupichu. Kay mundupa gubyirnun kaptiyqach'i, kasuwaqkunaqa pilyanandallapa, ama intrigakuwanan chay llaqta masiy isrraylinukunaman. Lukismi mana kay mundupa kamachikuqninchu kani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Chayshina niptinqam, Pilatuqa tapurqan: —¿Chayshinaqachu gubyirnu kangi qamqa? nishpa. Chaymi Jisusqa nirqan: —Arí, qam nishqaykishinam gubyirnu kani. Noqaqam kay munduman shamushpa, nasishqa kani, allip kaqta yach'achikunaypaq. Chaymi chay allip kaqta kasuqkunaqa noqa nishqayta kasunllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Chayshina niptinmi, Pilatuqa tapurqan: —¿Imam chay allip kaqqa? nishpa. Chayshina tapushpaqam, chay Pilatuqa lluqshishpa sawaman, chay isrraylinukunata kayshina nirqan: —Manam nima dilituta paypiqa tarinichu. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Piru qamkunaqam kustumbriyuq kangillapa, Paskwa fyistapi suq prisuta kach'anaypaq. ¿Munangillapachu kay gubyirnuykita kach'anaypaq? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Chayshina niptinqam, yumbay sh'uqyarqanllapa: —¡Kay runataqa ama kach'aychu! ¡Ashwan Barrabasta kach'ayqa! nishpa. Chay Barrabasqam suq ladrun saltiyadur karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Chaymandaqam chay gubyirnu Pilatuqa kamachikurqan, Jisusta ancha fiyuta asutinanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Kanan chay rrumanu suldadukunaqam suq kuruna kasha likiduta rurashpa, Jisusta umachachirqanllapa. Kanan kapachirqanllapam suq granati kapata. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Chaymandaqam ñawpanman qemikashpa, yanqa burlashpa, niqllapa: —¡Biba, isrraylinukunapa gubyirnun! nishpa. Chayshina nishpaqam, qaqllambi maqaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Chaymandaqam Pilatuqa dispachunmanda lluqshirishpa, isrraylinukunata nirqan: —Rikayllapa, kay sawamanmi apamuni, qamkuna yach'anaykillapa: Gubyirnu Pilatuqam mana nima dilituta tarinchu paypiqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Chaymi Jisusqa sawaman lluqshirqan, chay kasha likidu kurunayuq, chay granati kapayuqna. Chaymandaqam Pilatuqa paykunata nirqan: —¡Mayá, kaypinam kay runaqa! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Chaymandaqam chay kamachikuq isrraylinu kurakunaqa Dyuspa adurana wasinda kwidaq suldadukunawan Jisusta rikashpaqa, ancha jwirtita kayshina sh'uqyarqanllapa. —¡Kruspi klabay, kruspi klabay! nishpa. Chaymi Pilatuqa nirqan: —Qamkuna apashpa, kruspi klabayllapa. Piru noqaqam paypiqa mana nima dilituta tarinichu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Chaymi chay kamachikuq isrraylinukunaqa Pilatutaqa nirqanllapa: —Noqaykunapaqam kan suq liy, Dyustaqa ama burlananchiqllapa. Piru kay runaqam “Dyuspa Churinmi kani”, nishqa. Chayri chay liy nishqanshina wañunqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Chayshina “Dyuspa Churinmi kani”, nishqanda uyashpaqam, Pilatuqa mastana mancharqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Chaymi payqa uku dispachunman Jisusta aparishpa, tapurirqan: —¿Maymandataq qamqa kangi? nishpa. Chayshina tapuptinqam, Jisusqa mana nimatapis nishpachu, uyararqanlla. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Chaymi Pilatuqa tapurqan: —¿Ima manachu nimatapis niwangi? ¿Manachu yach'angi, noqa Pilatum ancha kamachikuq kashpa, atini kruspi klabashuyta, ichu kach'ashuyta, nishpaqa? ");
INSERT INTO qvcNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Chaymi Jisusqa nirqan: —Tayta Dyus mana dijashuptinmi, mana nimatapis noqataqa atingimanchu rurawayta. Kaytapis yach'ay: Chay qaman intrigakuwaqmi mas uchayuqqa kidan qamandaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Chayshina niptinqam, Pilatuqa ancha munarqan kach'ayta, librina kanambaq. Piru chay isrraylinukunaqam nirqanllapa: —¡Kay runata kach'ashpaqam, mana gubyirnunchiq Sesarpa yanasunchu (yanasanchu) kangi! ¡Chaqa mayqan runa “gubyirnu kani” niqqam chay mas kamachikuq gubyirnu Sesarta kuntraykan! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Chaymi Pilatuqa chay runakuna nishqanda uyashpaqa kamachikurqan, Jisusta sawaman surqonambaq. Chaymandaqam Pilatuqa trunumbi tiyarqan, justisyata ruranambaq. Pilatupa chay trununqam karqan suq pamba Gabata shutiqpi. Chay Gabataqam ibriyu rimaypiqa munan niyta: “Rumikunawan allichadu pamba”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Yaqqana qallariptin chay Paskwa fyista diya, larrdusinach'i karqan. Chay urasmi Pilatuqa chay isrraylinukunata (piñachinambaq) nirqan: —¡Rikayllapa, kaypim gubyirnuykiqa! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Piru paykunaqam ancha jwirtita kayshina sh'uqyarqanllapa: —¡Wañunqa, wañunqa! ¡Kruspi klabay! nishpa. Chayshina niptinllapaqam, Pilatuqa yumbayta tapurqan: —¿Qamkunapa gubyirnuykitachu kruspi klabachishaq? nishpa. Chaymi chay kamachikuq kurakunaqa nirqanllapa: —¡Sesarllam gubyirnuyllapaqa! ¡Manam masqa kanchu! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Chaymi Pilatuqa paykunatana intrigarqan, kruspi klabananllapa. Chayraykum paykunaqa aparqanllapana Jisustaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jisusqam krusta umbrukushpa, Jirusalinmanda rirqan Kalabira shutiq lugarman. Chay lugarqam ibriyu rimaypiqa shutirqan Gulguta. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Chay lugarpinam Jisustaqa kruspi klabarqanllapa. Kanan ishkay runakunatapismi pullan klabarqanllapa, suqta ichuq ladumbi, suqta allin ladumbi. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Kanan Pilatuqam suq litriruta rurashpa, kach'arqan kruspa puntambi ruranambaq. Chay litrirupiqam kayshina nirqan: “Jisus Nasaritmanda kaqmi isrraylinukunapa Gubyirnun”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Chay Kalabira lugarqam Jirusalin llaqtapa ladumbilla kidan. Chaymi achka isrraylinukuna chay litrirutaqa liyirqanllapa. Chaqa chay litrirutaqam rurashqallapa karqan ibriyu rimaypi, grigu rimaypi, latin rimaypipis. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Chaypaqmi chay isrraylinukunapa kamachikuq kurangunaqa Pilatuta nirqanllapa: —Ama iskibriychu: “Isrraylinukunapa Gubyirnunmi”, nishpaqa. Ashwan iskibriyqa: “Payqam nirqan: ‘Noqam kani isrraylinukunapa Gubyirnun’ ”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Chaymi Pilatuqa nirqan: —Iskibrishqayqam chayshinana kidanqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Chaymandaqam chay suldadukunaqa Jisuspa trapunda ch'uskundin partinakurqanllapa. Kushmambaqqam suqnin, suqnin kayshina ninakurqan: “Kaytaqam noqa piskani, kaytaqam noqa piskani”, nishpa. Chaqa chayqam mana nima kusturayuqchu karqan. Suq awayllam karqan, anaq kunganmanda ura puntangaman. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Chaymi chay kushmapaqqa chay suldadukunaqa kayshinana parlarqanllapa: —Ama llikishpachu, swirtita rurashun, mayqanninchiqshi apanchiq, nishpa. Chayshina ruraptinllapaqam, kumplirqanna Dyuspa Santu Librumbi kayshina nishqan: “Paykunapuram mudanaykunata partinakurqanllapa. Kushmaypaqqam swirtiyarqanllapa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Chay kruspa ladumbim Jisuspa mamitanqa karqan. Chay mamitamba masambismi chaypi karqan. Kliyufaspa warmin Maryapis, chay suq Marya Magdalamanda kaqpismi chaypi karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Chaymi Jisusqa mamitamba ladumbi kuyashqan yach'akuqninda rikawashpa, kayshina nirqan: —Mamita, chay laduykipi shayaykaqmi wawaykiqa kanqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Chaymandaqam noqa yach'akuqnindapis kayshina niwarqan: —Chay mamaymi mamaykiqa kanqa, nishpa. Chaymi chay urasmandapacha mamitaypaqna riqsishpa, wasiymanna aparqay. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Chaymandaqam Jisusqa yach'ashpa: Tukuy imatanam kumpliykani, nishpaqa, Dyuspa Santu Librumbi nishqanda kumplinambaq kayshina nirqan: —Yakunanim, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Chaypim puchqo binu suq puyñu unda karqan chay suldadukuna upyanambaq. Chaymi paykunaqa suq ish'uputa chay puchqo binupi nuyuchishpa, suq barillapa puntambi rurashpa, shiminman qemirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Chay puchqo binuta chupashpaqam, Jisusqa nirqan: —Tukuy imatam kumplishqana kani, nishpa. Chaymandaqam kumurashpa, ispiritunda Dyusman mingashpa, wañurqanna. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Chay diyaqam karqan allichakananllapa Paskwa fyistapaqna. Chaymi isrraylinukunaqa mana munarqanchu samana diyapi kruskunapi wañushqakuna kidanambaqqa. Chaqa chay Paskwa fyistapi kaq samana diyaqam ancha santu diya karqan. Chaymi paykunaqa Pilatuta rrugarqanllapa, kamachikunan, chay kruspi kaqkunapa ch'angangunata pakinambaq, mas das wañuptinllapa, ashuchinanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Chaymi chay rrumanu suldadukuna shamushpa, Jisuspa ladumbi chay kruspi kaq runakunapa ch'angangunata pakirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Chaymandaqam Jisuspa kwirpunman rishpa, wañushqatana rikashpa, ch'angandaqa manana pakirqanllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Piru suq suldaduqam suq garruchawanshina Jisusta kustillambi tukshirqan. Chayshina tukshiptinqam, chay kustillanmanda yawar, yaku lluqshirqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","37","Chayshinam pasarqan, kumplinambaq Dyuspa Santu Librumbi kayshina nishqan: “Paypa tullundaqam mana rinllapachu pakiq”, nishpa. Chay Santu Librupim suq partipipis nin: “Chay tukshishqandam rinllapa rikaq”, nishpa. Jisusta chayshina ruraptinllapam, noqa kikiy rikarqay. Chaymi tistigu kashpa, allita yach'ashpa, allip kaqtalla iskibrini, qamkunapis Jisukristupi kriyinaykillapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Chaymandaqam suq runa Jusi shutiq rirqan gubyirnu Pilatuman. Chay Jusiqam Arimatiya llaqtamanda karqan. Jisuspa yach'akuqnin karqan. Piru chay kamachikuq isrraylinukunata manchashpam, uyaritaplla Jisuspi kriyishqa karqan. Paymi Jisuspa kwirpunda mañarqan, apanambaq pambaq. Pilatuqam nirqan: “Mayá, apay”, nishpa. Chaymi chay Jusiqa Jisuspa kwirpundaqa aparqanna pambaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikudimupismi Jusiwan rirqan. Chay Nikudimuqam Jisusman tutap rishqa karqan parlaq. Payqam aparqan 30 kilustach'i mishki mutkina pulbuta mirramanda, aluwismanda kaqta. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Chayshina Jisuspa kwirpunda apashpaqam, chay mirrawan chay aluwiswan mushuq traputa pasashpa, Jisuspa kwirpunda wangurqanllapa. Chaqa noqaykuna isrraylinukunam wañuqkunataqa chayshina pambanillapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jisusta chay wanchishqan lugarpa ladumbillam suq wirta karqan. Chay wirtapiqam suq mushuq mach'ayshina sipultura karqan. Chaypiqam manaraq pitapis pambashqallapachu karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kanan noqaykuna isrraylinukunapa samana diyayllapaqam yaqqana qallariykarqan. Chaymi mana munashpa samana diyapi trabajaytaqa, chay sirkapillana das pambarqanllapa Jisuspa kwirpundaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Simanapa qallarinan diya dumingum Marya Magdalamanda kaq ancha madrugadu salqa salqalla rirqan Jisus pambakashqanman. Ch'ayashpaqam, chay mach'ayshina sipulturataqa manana kirpadutachu tarirqan. Ashwanmi tarirqanqa chay rumitaqa isqandaykaqtana. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Chaymi chayshina chay sipultura kich'aduna kaptinqa, chay Maryaqa kallpamurqan abisawaqllapa. Chaymi ch'ayamushpaqa, Pidruta, noqata niwarqanllapa: —¡Jisuspa kwirpundaqam chay sipulturamandaqa surqoshqallapana! Manam yach'anillapachu maypinam rurashqallapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Chayshina niwaptinllapaqam, Simun Pidruwan noqa kallpaylla, rirqayllapa chay sipulturaman chapakuq. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Kallpashpaqam, Pidruta binsishpa, noqa mas puntata ch'ayarqay chay sipulturamanqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ch'ayashpaqam, noqaqa yaykunanman kumurashpa, ukuman chapakushpa, rikarqay chay trapu Jisuspa kwirpunda liyashqandallana. Piru noqaqam ukumanqa mana yaykurqaychu. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Chayshina chapaykaptiyqam, Simun Pidruqa ch'ayamurqanna ikiyta. Paymi ukuman das yaykurqan rikaq. Chaymi paypis rikarqan chay trapu Jisuspa kwirpunda liyashqandallana. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Chaymandaqam rikarqambis Jisuspa umanda wangushqan traputapis, suq ladupina rurashqata. Chaqa mananam pullachu karqan chay trapu kwirpunda liyashqanwanqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Chayshina Pidru yaykuptinqam, noqapis chay sipulturamanqa yaykurqanina. Yaykushpaqam, noqapis chay trapukunata rikarqay, suq ladupi suq ladupina kaqta. Chayta rikashparaqmi, noqaqa kriyirqay. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Piru noqaykunaqam manaraq intyindirqaychu Dyuspa Santu Librumbi kay nishqandaqa: Dyus Akrashqan Washadurmi wañushqanmanda rin kawsamuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Chaykunata rikashpaqam, kutirqayllapana pusadayllapaman. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Noqaykuna pusadayllapaman kutiptiyllapaqam, Magdalamanda kaq Maryaqa waqashpa, chay mach'ayshina sipulturapa sawa yaykunambi kidarqan. Chaypish kumurashpa, ukuman chapakurqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Chayshina chapakushpaqash, rikarqan ishkay ancha yuraq mudanayuq anjilkunata. Suqqash tiyaykarqan Jisuspa uman rurashqan ladupi; suqqash ch'akin kashqan ladupi. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Chayshi chay anjilkunaqa Maryata tapurqan: —Warmisita, ¿imapaqmi anchaqa waqaykangi? nishpa. Chayshi Maryaqa nirqan: —Siñurniypa kwirpundam apashqallapana. Manam yach'anichu, maypinam rurashqallapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Chayshina nishpaqash, Maryaqa ikiman chapakushpa, Jisusta rikarqan. Piru manash riqsirqanchu: Paymi Jisukristu, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Chaymandaqash Jisukristu tapurqan: —Warmisita, ¿imapaqmi anchaqa waqaykangi? ¿Pitam maskaykangi? nishpa. Chayshina tapuptinshi, Maryaqa nirqan: —Taytitu, Kamachikuqniypa kwirpunda qam apashqa kashpaqa, ¿maypitaq rurashqa kangi? Yush'ayku niway, rinaypaq apamuq. Chaqa Maryaqash yuyarqan: Kay runaqam kay wirtata kwidaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Chayshi Jisusqa nirqan: —¡Marya! nishpa. Chayshina shutimbi niptinraqshi, Maryaqa Jisusta riqsishpa, payman tikrakashpa, nirqan: —¡Rrabuni! nishpa. Chay palabra “Rrabuniqam” ibriyu rimaypiqa munan niyta: “Yach'achikuq Taytitu”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","(Chayshina nishpaqash, Maryaqa Jisuspa ñawpambi qonqorikushpa, ch'akingunapi piskakurqan.) Chayshi Jisusqa nirqan: —Ama piskawaychu. Chaqa manaraqmi Taytay Dyusmanqa rishqachu kani. Ashwan riy yach'akuqniykunata abisaq: “Jisukristum riykan Taytanman. Paypa Taytanqam noqanchiqkunapa Taytanchiqpis. Paypa Dyusninqam noqanchiqkunapa Tayta Dyusninchiqpis”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Chaymi Marya Magdalamanda kaqqa shamushpa, niwarqanllapa: —Siñurninchiq Jisustam rikashqa kani. Pay kikinmi niwashqa, shamunaypaq abisashuqllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Chay dumingullam noqaykunaqa tutap suq wasipi tandakarqayllapa. Chaymi kamachikuq isrraylinukunata manchashpa, chay wasipa pungunda alli kirpashpa, trankashqallapa karqay. Piru Jisusqam shamushpa, qonqaylla rikakurqan noqaykunapa ch'awpiyllapapi. Chayshina rikakushpaqam, noqaykunata napaykuwarqan: —Bwinas nuchis. Dyus yanapashunqallapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Chaymandaqam rikachiwarqanllapa makinda, kustillanda chay chuqrishqangunata. Chayshina Jisusta rikashpaqam, ancha kushikurqayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Chaymandaqam Jisusqa noqaykunata kayshina niriwarqan: —Dyus qamkunata yanapashunqa. Chaqa payqam kay pachaman kach'amuwashqanshina, noqapis kach'aykillapa, shumaq nutisyayta qamkunapis yach'achikunayki. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Chayshina niwashpallapaqam, Jisusqa yumbay noqaykunata pukawashpa, niwarqanllapa: —Dyuspa Santu Ispiritunda ch'askiyllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Chay Santu Ispiritu qamkunata yanapashuptinmi, wakin uchayuqkunata ringillapa niq: “Taytanchiq Dyusmi uchaykikunata pirdunashushqa”, nishpa. Chayshina niptikillapaqam, paykunaqa uchangunamanda pirdunadu rin kaq. Piru suq uchayuqkunata niptikillapa: “Tayta Dyusqam mana pirdunashushqachu”, nishpaqa, mana pirdunaduchu rin kidaq. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jisus noqaykunaman rikakushqan urasqam chay yach'akuq masiyllapa Tumas Millisuqa mana noqaykunawanchu karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Chaymi pay ch'ayamuptinqa, nirqayllapa: —Siñurninchiq Jisustam rikashqallapa kani, nishpa. Piru Tumasqam niwarqanllapa: —Manam kriyiykillapachu. Noqaqam makinda klabu ush'kushqanda rikashpa, diduywan llamkashpa, kustillambi makiywan llamkashparaq, chay niwashqaykitaqa kriyishaq. Manaqa manám, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Chaymandaqam 8 diyasmanda tutapina noqaykuna chay wasipina tandakashqa karirqayllapa. Chay bwiltaqam Tumaspis pullayllapa karqan. Punguta alli kirpashpam, trankashqa karqayllapa. Piru Jisusqam ch'awpiyllapaman yaykushpa, kayshina noqaykunata napaykuriwarqan: —Bwinas nuchis. Dyus yanapashunqallapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Chaymandaqam Tumasta nirqan: —Tumas, diduykita kay makiy klabu ush'kushqanman ruray. Kay ush'kushqa kustillaymambis makikita ruray kriyinayki: Alliptam kawsamushqana, nishpa. Ama mana kriyiq runaqa kaychu. Ashwan noqapi allipta kriyiy, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Chayshina Jisus niptinmi, Tumasqa paytaqa nirqan: —¡Qamir Kamachikuqniy, Dyusniy kangi! nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Chaymi Jisusqa Tumasta nirqan: —Qamqam rikawashparaq kriyingi. Piru chay mana rikawashpa kriyiqkunataqam Dyusqa masta rin yanapaq, kushikunanllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jisusmi noqaykunapa ñawpaypi suq laya ancha achka milagrukunatapis rurarqan. Piru yumbay chay milagru rurashqambaqqam mana iskibrishqachu kani kay librupiqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Piru wakin milagrukunapaqmi iskibrishqa kani, kriyinaykillapa: Jisusqam Dyus Akrashqan Washadurninchiq. Payllam Dyuspa Churimbis, nishpa, chayshina kriyishpa, tukuy tyimpu Dyuswan kawsanaykillapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","2","Chaymandaqam noqaykuna Jisuspa yach'akuqningunaqa tandakarqayllapa chay Tibiryas atun qoch'apa manyambi. Nuta: Chay qoch'allam Galiliya qoch'a, Jinisarit qoch'apis shutin.  Chaypim karqayllapa: Simun; payllam Pidrupis shutiq; Tumas Millisu, Natanayil. Payqam prubinsya Galiliyapa Kaná llaqtanmanda karqan. Noqaykuna Sibidiyupa ishkay churingunapismi chaypi karqayllapa. Ishkay mas apustul masiykunapismi chaypi karqan. Chayshina chay qoch'apa manyambi kaykaptiyllapam, Jisukristu noqaykunaman rikakumurirqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Piru manaraq rikakumuptinmi, Simun Pidruqa niwashqallapa karqan: —Noqam rishaq piskadukunata piskaq, nishpa. Chaymi nirqayllapa: —Noqaykunapisri qamwan akullapa, nishpa. Chayshina nishpaqam, lluqshishqallapa karqay yakupi puriq suq barkuman. Chayshinam chay tuta rirqayllapa piskaduta piskaq. Piru chay tutaqam yuraqashtin mana ni suq piskaduta piskarqayllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Chaymandaqam qayandin achikyaykaptinqa, Jisusta chay qoch'apa manyambi rikarqayllapa. Piru manam paytaqa riqsirqayllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Chaymandaqam Jisusqa kayshina tapuwarqanllapa: —Ijitukuna, ¿manachu nimata piskashqallapa kangi? nishpa. Chaymi noqaykunaqa nirqayllapa: —Manam ni suqsituta piskashqallapachu kani, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Chaymandaqam Jisusqa niwarqanllapa: —Atarrayaykita barkupa allin ladunman wichukuyllapa, piskadukunata tarinaykillapa, nishpa. Chay niwashqanshinam rurarqayllapa. Chaymi allipta manana atirqayllapachu atarrayataqa chutayta, ancha achka piskadukuna bulsachakaptin. ");
INSERT INTO qvcNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Chaymi noqa Jisuspa ancha kuyashqan yach'akuqninqa Simun Pidruta nirqay: —¡Waq runaqam Siñurninchiq Jisus! nishpa. Chayshina niptiyqam, Simun Pidruqa chay uraslla das mudananda rurakurqan. Chaqa payqam piskaduta piskananqa trusanwanlla kaykarqan. Chaymandaqam Pidruqa barkumanda brinkashpa yakuman, nadashpa Jisusman rirqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Chaymandaqam noqaykunapis barkupiqa chay qoch'apa manyanman ch'ayarqayllapa, atarrayata rrastrakushpa, unda piskadu kaptin. Chaqa chay barku kashqanmandaqam manyamanqa 100 mitrusch'i karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Chay barkumanda ishkishpaqam, chay manyapiqa tarirqayllapa puchu ninata. Chay ninapa sawambiqam suq piskadu karqan. Chaypa ladumbiqam tandapis karqan. ");
INSERT INTO qvcNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Chaymandaqam Jisusqa niwarqanllapa: —Chay piskadu piskashqaykita wakinda apamuyllapa, (kangashpa, mikunanchiq) nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Chaymi Jisusta uyashpaqam, Simun Pidruqa barkuman lluqshishpa, chay atarrayata rrastramurqan yakupa manyangaman. Chay atarrayapiqam karqan 153 atun piskadukuna. Piru achka piskaduyuq kashpapismi, chay atarrayaqa mana ni llikikarqanchu. ");
INSERT INTO qvcNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Chaymandaqam Jisusqa qayawarqanllapa: —Shamuyllapana mikunanchiq, nishpa. Chayshina niwaptinllapaqam, mana ni mayqanniyllapa tapurqayllapachu: “¿Pim kangi?” nishpaqa. Chaqa riqsirqayllapam: Payqam Siñurninchiq Jisukristu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Chaymandaqam noqaykunaman qemikashpa, tandata piskashpa, qowarqanllapa. Chayshinam piskadutapis qowarqanllapa mikunayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Kay bwiltawanqam noqaykunaqa kimsa kutindana Jisustaqa rikashqallapa karqay, chay kawsamushqan diyamanda. ");
INSERT INTO qvcNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ushyashpa mikuytaqam, Jisusqa Simun Pidruta kayshina tapurqan: —Junaspa churin Simun, ¿kay wakinmandaqachu qamqa masta kuyawangi? nishpa. Chaymi Pidruqa nirqan: —Taytitu, qam yach'angi kuyashushqayta, nishpa. Chaymi Jisusqa nirqan: —Noqapi chayraq kriyiqkunatar kwiday, suq michidur uñitangunata allita michiqshina, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jisusqam Pidruta suq kutinda tapurirqan: —Junaspa churin Simun, ¿alliptachu kuyawangi? nishpa. Chayshina tapuriptinqam, Pidruqa nirirqan: —Arí, Taytitu, qam yach'angi kuyashushqaytaqa, nishpa. Jisusqam nirirqan: —Noqapi kriyiqkunatar kwiday, suq michidur wishangunata allita michiqshina, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jisusqam suq kutindapis kayshina tapuririrqan: —Junaspa churin Simun, ¿alliptachu kuyawangi? nishpa. Chaymi kimsa kutinda chayshinalla tapuriptinqa, Pidruqa malaganayashpa, nirqan: —Taytitu, qam ancha allita yach'angi noqa kuyashushqaytaqa, nishpa. Chaymi Jisusqa nirirqan: —Noqapi kriyiqkunatar kwiday, suq michidur wishangunata ancha allita michiqshina. ");
INSERT INTO qvcNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Alliptam niyki, chuluraq kashpaqam, qamqa mudakushpa, may munashqaykita riq kangi. Piru byijuyaptikiqam, rikraykikunata chutaptiki, suqna mudachishushpa, rin apashuq mana munashqayki lugarman, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jisusqam chayshinaqa nirqan, yach'anayllapa: Kayshinam Pidruqa rin wañuq. Chayshina Dyusta ancha allita kasushpa wañuptinqam, suqkunapis Dyusta rin alabaq, nishpa. Chaymandaqam Pidrutaqa kayshina nirqan: —Shamuy, aku noqawan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Chayshina Jisus niptinmi, Pidruqa ikiman chapakushpa, noqa Jwanda rikawarqan. Noqam Jisuspa ancha kuyashqan yach'akuqninqa karqani. Chaymi Jisus chay Santa Mikunata noqaykunawan mikuptinqa, noqa ladumbi karqay. Chaypi kashpam, kayshina tapurqay: “Taytitu, ¿mayqan yach'akuqnikim rin intrigakushuq kuntrashuqkunamanqa?” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Chaymi Pidru rikawashpaqa, Jisusta noqapaq tapurqan: —Taytitu, ¿Jwandaqa imataq rin pasaq? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Chaymi Jisusqa nirqan: —Noqa munaptiyqach'i Jwan kawsanambaq kutimunay diyakamanqa, ¿ima kwintayuqtaq qamqa kangiman? Qamqa sigiwaylla, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Pidruta noqapaq chayshina niptinqam, chay parlataqa kriyiq masinchiqkunaqa das yach'arqan. Lukismi pandashpa yuyarqanllapa: Manash Jwanqa rinchu wañuq, nishpa. Piru Jisusqam mana noqapaqqa nirqanchu: “Manam rinchu wañuq”, nishpaqa. Ashwan payqam nirqanqa: “Kutimunay diyakaman noqa munaptiyqach'i Jwan kawsanambaqqa, ¿ima kwintayuqtaq qamqa kangiman?” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Chaymi Jisuspa yach'akuqnin kashpa, allip kashqandalla iskibrishqa kani kay librupiqa. ");
INSERT INTO qvcNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Piru Jisusqam ancha achka layakunatapis rurarqan. Chaymi tukuy chay rurashqangunapaq manyaqlla iskibriptiyqach'i, tukuy kay mundupiqa mana aypanmanchu yumbay librukunaqa. Chaytallam iskibriykillapa. Chayshina kanqa.");
INSERT INTO qvcNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Kuyashqay Tiyufilu, punta libruypim iskibrishurqaq Jisus rurashqanda, yach'achikushqanda, qallarishqan diyamandapacha, ");
INSERT INTO qvcNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","syiluman rishqan diyakaman. Paymi manaraq syiluman rishpa, akrarqan wakin runakunata, apustulninguna kanambaq. Paykunatam Santu Ispiritunwan yach'achirqan, pay munashqanda ruranambaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Kuntraq runakunam Siñurninchiq Jisusta wanchirqanllapa; piru kawsamushpaqam, pay kikin rikarimurqan chay apustulningunaman. Chaymandaqam 40 diyasta kutin kutin paykunaman shamurqan, pay kikinda rikashpa, ancha allita yach'ananllapa: Kawsamushqanam, nishpa. Kaytapismi apustulningunata yach'achirqan: —Ancha achka runa, warmim Taytanchiq Dyusta shumaqta rinllapa kasuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","5","Paymi chay apustulningunawan pulla kaykashparaq, yumbayta kamachirqan: —Amaraq lluqshiyllapachu Jirusalin llaqtamandaqa. Ashwanri shuyayllapa, Dyus ufrisishushqanda kumplinangaman. Jwan Shutichikuqqam yakuwanlla shutichikurqan. Piru qamkunata nishushqayshinam, ashla diyakunamanda Tayta Dyusqa Santu Ispiritunwan rin shutichishuqllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jisus manaraq riptin syilumanmi, chay apustulningunaqa kayshina tapurqanllapa: —¿Kananmandanachu ringi yanapawaqllapa, chay rrumanu runakunata binsinanchiq, noqanchiqkunata amana kamachiwananchiq? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Chaymi Jisusqa paykunata nirqan: —Chaytaqam Taytay Dyuslla yach'an, ima diya, ima urasmi chaytaqa rin ruraq, nishpa. Chaytaqam qamkunaqa mana atingillapachu yach'ayta. ");
INSERT INTO qvcNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Piru Dyuspa Santu Ispiritun qamkunaman shamushpam, pudirninda rin qoshuqllapa. Kanan pay qamkunata yanapashuptinmi, ringillapa noqapaq yach'achikuq kay Jirusalimbi, tukuy kay prubinsya Judiyapi, chay prubinsya Samaryapi, kay mundupa mas karu kuchungunapi, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Chaymandaqam yumbay chapaykaptinllapa, Jisusqa kay pachamanda alsakarqan, syiluman rinambaq. Chaymi riykaptinqa, pukutayna pambarqan. Mananam paytaqa rikarqanllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Chaymi anaq syiluman yumbay chapakuykaptinqa, ishkay yuraq bistiduyuq paykunaman rikarishpa, ");
INSERT INTO qvcNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","nirqanllapa: —Uyayllapa, galiliyanukuna, ¿imaraykutaq qamkunaqa chapakuykangi anaq syilumanqa? Waq Jisus syiluman riqqam rin kutirimuq. Chay rikashqaykishina riqtam, chayshinalla pay kikin syilumanda rin kutirimuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Chaymandaqam Ulibu lumamandaqa Jirusalinmanna kutirqanllapa. Chay Ulibu lumamandaqam Jirusalinmanqa 800 mitrusllach'i karqan. Chay isrraylinukunapa liyninqam kamachikurqan chayshina 800 mitruskamanlla samana diyapiqa purinanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Paykunaqam chay Jirusalinman ch'ayashpaqa, pusada wasipa altunman lluqshirqanllapa. Paykunaqam karqan: Simun Pidru, Jakubu, Jwan, Andris, Filipi, Tumas, Bartulu, Matiyu, suq Jakubupis. Chay suq Jakubuqam Alfiyupa churin karqan. Chaypiqam karqan suq Simun. Payqam karqan chay isrraylinu Kananista partidumanda. Chaypiqam karqambis suq Jakubupa masan Judas. (Payqam manam chay Judas Iskaryutichu karqan.) ");
INSERT INTO qvcNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Yumbay paykunam Tayta Dyuspi yuyakushpa, suq shunqolla kashpa, tandakaqllapa Jisuspa masangunawan, maman Maryawan, wakin warmikunawan, Dyusman mañakunanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Chay tyimpupim tandakarqanllapa 120 kriyiq masikuna. Chaymi paykunapa ch'awpimbi shayashpa, Pidruqa nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Kriyiq masitakuna, uyawayllapa. Dyuspa Santu Librumbi nishqanqam kumplishqana. Chaqa Dyuspa Santu Ispiritunmi chay unay gubyirnu Dabidta yanaparqan, chay Santu Librupi iskibrinambaq Jisusta intrigakuqpaq. Kay diyakunapim chay Judasqa chay suldadukunata aparqan rikachiq, Jisusta prisunanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Chay Judasqam noqanchiqkunapa suqninchiq kashpa, pullanchiq puriq. Chay imakunata ruraptinchiqmi, chaypi karqan. ");
INSERT INTO qvcNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Piru chay Judasmi mana allita rurashpa, Washadurninchiqta randikurqan. Chay qellay ch'askishqanwanqam randirqan suq ch'akrata. Chaymandaqam anaq altumanda umamba sawan ishkiptin, pach'an pach'yarqan, chunchulinguna shikwakashtin. ");
INSERT INTO qvcNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Chaymi Jirusalimbi tiyaqkuna chayta yach'ashpaqa, chay ch'akrataqa Asildamata shutichirqanllapa. Chayqam rimaynimbiqa munan niyta: “Yawar Pamba”. ");
INSERT INTO qvcNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Chay Santu Libru Salmuspim chay Judaspaq kayshina nin: Wasinqam wichukushqa, chunchana kidanqa. Mananam pipis wasimbiqa tiyanqachu, nishpa. Nimbismi: Suqnam ch'askinqa paypa kargundaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Kaypim noqanchiqkunawan tarikan allin runakuna. Jisukristu pullanchiq kaykaptinmi, kay runakunapis paywan purishqa, ");
INSERT INTO qvcNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","chay Jwan shutichishqan diyamandapacha syiluman rinan diyakaman. Allich'i kanman paykunamanda suqninda numbrananchiq, dusi apustulkuna karinanchiqllapa, paypis ninambaq: “Noqam Jisusta rikashqa kani wañushqanmanda kawsamushqata”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Chayshina yuyashpaqam, paykunamanda ishkay runakunata akrarqanllapa. Suqtam akrarqanllapa Jusita. Payllam Barsabas, Justupis shutiq. Suqtaqam akrarqan Matiyasta. ");
INSERT INTO qvcNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Chaymandaqam Dyusman kayshina mañakurqanllapa: —Taytitu, qamqam yumbay runakunapa shunqonda riqsingi. Chayri yach'achiwayllapa kay ishkaymanda mayqannindam akrashqa kangi, ");
INSERT INTO qvcNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Judaspa kargunda ch'askishpa, suq apustulna kashpa, noqaykunata yanapawanambaq. Chaqa chay Judasqam, uchanrayku kargunda dijashpa, rirqanna suq lugar paypaq kaqman. ");
INSERT INTO qvcNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Chayshina mañakushpaqam, paykunaqa surtiyarqanllapa. Swirtiqam Matiyaspi ishkirqan. Chaymi chay diyamandapacha Matiyasqa apustul karguyuqna kashpa, chay unsi apustulkunawan pullana purirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Jisuspi yumbay kriyiqkunam Pintikustis fyista ch'ayaptin, tandakarqan suq wasiman. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Chaypi kaykaptinllapam, qonqaylla uyarqanllapa ancha jwirti wayrashina kunyaqta anaq syilupi. Chay kunyaqqam shamushpa, chay wasiman undarqan. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kanan umangunapa sawambim qallu laya ninakunashina rikakurqan kadunupi. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Dyuspa Santu Ispiritunqam yumbay paykunapa shunqonman yaykushpa, undarqan. Chaymandaqam chay Santu Ispiritu rimachiptin, achka laya rimaykunapina rimarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Chay diyakunapim Jirusalinmanqa shamushqallapa karqan achka isrraylinukuna tukuy karu nasyungunamanda. Paykunaqam duktrinanda ancha allita kasuqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Kanan chay kunyaqta uyashpaqam, chay wasiman qemikarqanllapa. Chaypi uyashpa achka laya rimaykunapi rimaptinllapaqam, paykunaqa ispantashqata ancha yuyarqanllapa: ¿Imashinataq kay runakunaqa atinllapa rimayta kadunupa kikin rimayninchiqpiqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Kanan paykunaqam ancha ispantashqata suqnin suqnin nirqanllapa: —Ima kay rimaqkunaqam prubinsya Galiliyamanda ¿manachu? ");
INSERT INTO qvcNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Mana yach'akushpa nasyunninchiqkunapa rimayningunata, ¿imashinataq atinllapa rimayta kay achka rimayninchiqkunapiqa? ");
INSERT INTO qvcNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Chaqa kaypim kanchiq achka nasyungunamanda: Partiyamanda, Midyamanda, Ilanmanda, Misuputamyamanda, Judiyamanda, Kapadusyamanda, Puntumanda, Asyamanda, ");
INSERT INTO qvcNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frijyamanda, Panfilyamanda, Ijiptumanda, Afrikapa lugarningunamanda. Chay lugarkunaqam Sirini llaqtamanda mas waq ladumbi kidan. Rrumanukunapismi kay Isrrayilpi tiyanllapa. Chay rrumanukunapa wakin wambrangunaqam kay Isrrayilpi nasiqkuna. Wakin rrumanukunaqam noqaykuna isrraylinukunapaq tikrakashqa, duktrinayllapapi kriyishqanllaparayku. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Kambismi Krita nasyunmanda, Arabya nasyunmanda runakuna. Achka nasyungunamanda kashpapismi, ancha allita intyindinchiq kikin rimayninchiqkunapi Dyuspaq niwaptinchiqllapa: Tayta Dyusmi ancha shumaq milagrukunata rurashqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Yumbay paykunam ancha ispantashqata apustulkunata chaparqanllapa. Manam atirqanllapachu intyindiyta: —¿Imashinam atinllapa kaytaqa rurayta? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Piru wakinnataqmi burlashpa, yanqakunata kayshina rimarqanllapa: —Chay runakunaqam mach'ashqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pidruqam chay unsi apustulkunawan shayashpa ancha jwirtita rimarqan: —Isrraylinu masikuna, tukuy kay Jirusalimbi tiyaqkuna, allita uyawayllapa, kayta yach'anaykillapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Manam chay yuyashqaykichu kanillapa. Manam mach'ashqallapachu kani. Chaqa chayraqmi las nwibi. Manaraqmi punchawchu. ¿Chaychu mach'ashqa kaymanllapa? ");
INSERT INTO qvcNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ashwan kayshinaraqmi. Dyuspaq chay unay rimaq Juwilmi nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Taytanchiq Dyusmi nin: Ushyakanan tyimpu ch'ayamuptinmi, Santu Ispirituyta rini qoq yumbay laya runakunata. Chaymi wambraykikunaqa, ullqopis, warmipis noqa munashqayta rinllapa rimaq. Chulukunatam musqoypishina achka layakunata rini rikachiq. Byijukunatapismi rini rikachiq musqoynimbi. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Chay diyakunapim Santu Ispirituyta rini qoq chay kasuwaqkunata, ullqokuna warmikuna noqa nishqayta suqkunata ninambaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Anaq syilupipismi rurashaq mana rikashqanllapata, chaykunata rikashpa, ispantananllapa. Kay pachapipismi yawarta, ninata, qondayta rurashaq, runakuna rikashpa ispantananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Rupayqam rin wañuq. Killaqam yawarshina kulurniyuq rin tikrakaq. Chayshinam rin kaq yaqqana shamuptin runakunapa Washadurnin. Chaymandaqam pay shamuptinqa, suq ancha shumaq diya rin kaq. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Chay diyapim noqapi yumbay kriyiqkunata rini washaq, paykuna shutiyta myintashpa noqaman mañakushqanrayku, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Chayshina Dyus nishqanda nishpaqam, Pidruqa nirqan: —Isrraylinu masiykuna, kayta uyawayllapa: Taytanchiq Dyusmi chay Jisus Nasaritmanda kaqta akrarqan, manaraq wañushpa, ancha shumaq milagrukunata ruranambaq. Chay milagrukunatam ñawpaykillapapi rurarqan, rikashpa yach'anaykillapa: Allibmi Dyusqa paywan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Piru chaykunata rikashpapismi, qamkunaqa mana allikunata rurarqaykillapa. Jisusta intrigashuptinllapam, prisushpa aparqaykillapa chay mana allin runakunaman, paykuna kruspi klabashpa wanchinanllapa. Dyusmi unaymandapacha yach'arqan: Churiy Jisustam chayshina rinllapa wanchiq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Chayshina qamkuna wanchiptikipismi, Taytanchiq Dyusqa wañuyta binsishpa, Jisusta kawsachimurqan. Manam dijarqanchu wañushqalla kidanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Chaymi chay unay gubyirnu Dabidqa Jisus ninambaq kaqta kayshina iskibrirqan: Tukuy tyimpum Taytay Dyus pullay kashqa. Chayshina noqapa allin laduypi kaptinqam, mana pipis atinqachu manchachiwaytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Paypi yuyakushpa, tukuy shunqo ancha kushikushpam, payta alabashqa kani. Chaymi wañunaypaq kashpapis, mana nimata manchashpachu rini kawsaq. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Chaqa qamqam noqa kasushuqtaqa mana ringichu dijawaq, wañuqkunapa lugarnimbi ismunaypaqqa. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Yach'achiwashqam kangi, qamwan tukuy tyimpu kawsanaypaq. Kanan qam pullay kashpam, ancha ringi kushichiwaq. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Chaykunata yach'achishpaqam, Pidruqa nirqan: —Masitakuna, chayqam ancha klaru, noqanchiqkuna yach'ananchiq. Chay unay agwilunchiq Dabid wañuptinmi, pambarqanllapa. Chaqa paypa pantyunninqam kanangaman kay sirkanchiqpi. Chaypillam kwirpunqa. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Piru chay Dabidmi Dyuspaq rimaq kashpa, yach'arqan Dyus ufrisishqanda. Chaqa Dyusqam paytaqa kayshina ufrisishqa karqan: “Noqa kikiymi allipta niyki: Qamba karu willkaykimandam rin nasiq isrraylinukunapa Washadurninqa. Paymi rin kamachikuq qamshina”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Chaymi chay Dabidqa ancha unay tyimpupi Dyus Akrashqan Washadurpaq kayshina iskibrishqa karqan, payta rikashqa kanmanshina: Jisusqam mana rinchu kidaq wañuqkunapa lugarnimbiqa. Ashwanmi rin kawsamuq. Chaymi kwirpunqa mana rinchu ismuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Chay Dabid nishqanshinallam Tayta Dyusqa allipta Jisusta wañushqanmanda kawsachimushqa. Paytaqam noqaykuna kikiy ñawiyllapawan rikashqallapa kani. Chaymi tistigukuna kanillapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Chaymandaqam Tayta Dyusqa Jisusta aparqan anaq syiluman, paypa allin ladumbi tiyanambaq. Kanan Jisus Tayta Dyusmanda Santu Ispiritunda ch'askishpam, qowashqallapa ufrisiwashqanshina. Chaymi kay achka rimaykunata atinillapa rimayta. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Chay unay gubyirnu Dabid wañushpaqam, manaraq kawsamushqachu, syiluman rinambaqqa. Ashwan Dyus Akrashqan Washadurpaqmi kayshina iskibrirqan: Tayta Dyusmi Kamachikuqniyta nirqan: “Allin laduypi tiyay, kuntrashuqkunata binsishpa, ch'akikipa waranman ruranaykaman (qamta kasushunanllapa)”, nishpa.Nuta: Chay Dabidpa Kamachikuqninmi Jisusqa.  ");
INSERT INTO qvcNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Llaqta masi isrraylinukuna, allita uyawayllapa. Manchu qamkuna chay Jisusta kruspi klabachirqaykillapa. Piru Taytanchiq Dyusqam payta numbrashqa, Washadurninchiq, Siñurninchiq, kanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Chayshina Pidru niptinmi, yumbay chay uyaqkunaqa ancha malayakushpa syintirqanllapa. Chaymi Pidruta tukuy chay wakin apustulkunata tapurqanllapa: —¡Masitakuna! ¿Imatam kananqa atinillapa rurayta, washadu kanayllapaqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Chaymi Pidruqa paykunata nirqan: —Tukuy ima mana allikunata rurashqaykirayku syintishpa, chay uchaykikunata dijashpa, Jisukristupa shutimbi shutikuyllapa, Tayta Dyus uchaykillapata pirdunashunambaq. Chayshina ruraptikillapaqam, payqa Santu Ispiritunda rin qoshuqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Payqam chayta ufrisiwashqa kanchiq noqanchiqkunapaq, wambranchiqkunapaq, yumbay karupi kaqkunapaq, yumbay pay akrashqangunapaq. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Chayshina nishpam, Pidruqa masta yach'achishpa, paykunata kayshina ancha kunarqan: —Amar kayllapachu chay malu llaqta masinchiqkunashinaqa. Ashwanri washadu kayllapa, ama paykunawan kastigadu kanaykillapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Chayshina Pidru yach'achikuptinmi, chay kunashqanda kasuqkunaqa shutikurqanllapa. Chay diyaqam Jisuspi kriyiqkunamanqa kimsa mil mushuq kriyiqkuna tandakarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kanan yumbay paykunam ancha allita kasuqllapa chay dusi apustulkuna yach'achishqanda. Paykunapuram ancha shumaqta kawsashpa tandakaqllapa, Dyusman mañakunambaq, tandata pitishpa, pulla mikushpa, Santa Mikunata mikunambaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Chay dusi apustulkunam ancha achka milagrukunata ruraqllapa. Chayta rikaqkunaqam ancha ispantashqata chaparqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jisuspi yumbay kriyiqkunaqam ancha shumaqta kawsaqllapa. Tukuy ima kusasnimbismi yumbaypaq kaq. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Randikushpa wakin ch'akranda, wakin kusasnindapismi, chay qellaywanqa chay mas pubrikunata yanapaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Tukuy diyam Dyuspa adurana wasinman shumaqta tandanakuqllapa. Ancha umildi kashpam, kushikushpa, wasingunapipis tandanakushpa, tandata pitishpa, Santa Mikunata pulla mikuqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Kanan Taytanchiq Dyustam ancha alabaqllapa. Chayshina shumaqta kawsaptinllapam, yumbay rikaqkuna yuyaqllapa: Paykunaqam ancha allin runakuna, warmikuna, nishpa. Siñurninchiq Jisusmi diyapi diyapi mushuq kriyiqkunata washashpa, masta achkayachiq chay kriyiqkunataqa. ");
INSERT INTO qvcNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Suq diyam las tris di la tardi Pidruqa Jwanwan rirqanllapa Dyuspa adurana wasinman. Chay urasqam isrraylinukuna Dyusman mañakunan urasna karqan. ");
INSERT INTO qvcNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Dyuspa adurana wasimba suq yaykunanmi “Shumaq Pungu” shutiq. Chay pungupim suq kuju tiyaykarqan. Payqam nasishqan diyamandapacha mana ni atirqanchu shayayta. Chaymi ayllunguna tukuy diya chay kujuta apashpa, chay Shumaq Pungupi dijaqllapa, adurana wasiman yaykuqkunata limush'nata mañanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Chay kujuqam Pidruta Jwanda rikashpa Dyuspa adurana wasinman yaykuykaptinqa, rrugarqan: —Qowayllapár limush'nitata, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Chaymi paykunaqa kujuta chapashpa, Pidruqa nirqan: —Mayá, chapawayllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Chaymi kujuqa das chaparqan: Rinnam qowaq limush'nata, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Piru Pidruqam nirqan: —Manam nima qellayniyuqchu ni uruyuqchu kani. Piru kayshinam atini yanapashuyta: Jisukristu nasarinupa shutimbim niyki, atarishpa puriy, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pidruqa chayshina nishpa, allin ladu makinmanda rambashpa shayachiptinmi, chay kujupa ch'akinguna, ñudunguna jwirtina tikrakarqan. ");
INSERT INTO qvcNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Chaymi chay kujuqa shayashpa, brinkarqan. Chay urasmandapacham atirqanna puriyta. Kanan Dyusta ancha alabashpam, chay apustulkunapa pullan Dyuspa adurana wasinman yaykurqan. ");
INSERT INTO qvcNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Chayshina chay kuju purishpa, Dyusta alabaykaptinqam, yumbay chaypi kaqkuna ");
INSERT INTO qvcNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ancha ispantashqata chaparqan: ¿Imashinaraq kach'akashqaqa? nishpallapa. Chaqa chay kujutaqam unaymandapacha rikashqallapa karqan, chay Shumaq Pungupi limush'nata mañakuykaptin. ");
INSERT INTO qvcNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Chay kujum kach'akashpa, Pidruta, Jwandaqa manana dijarqanchu. Chaymi suq atun kurridurpi kaykaptinllapa, ancha achka runakuna ispantashqata paykunaman kallparqanllapa, chay kujuta rikanambaq. Chay kurridurmi shutiq “Gubyirnu Salumumba kurridurnin”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Chay runakunata rikashpam, Pidruqa nirqan: —Isrraylinu masikuna, ¿imaraykutaq ancha ispantashqata chapawangillapa? ¿Ima qamkunachu noqaykunapaq yuyangi: Ancha pudirniyuq kashpa, Dyusta kasuqkuna kashpam, paykuna kach'akachishqa chay kujutaqa, nishpa? ");
INSERT INTO qvcNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Manam chayshinachu. Ashwanmi unay agwilunchiq Abrajamba, Isakpa, Jakubupa Dyusnin kay kujutaqa kach'akachishqa. Chaqa Dyusqam Churin Jisusta numbrashqa karqan, ancha pudirniyuq kanambaq, paytalla kasunanchiqllapa. Piru qamkunaqam paytaqa aparqaykillapa awturidarkunaman. Chaymandaqam Gubyirnu Pilatu munaptin kach'aytapis, qamkunaqa mana munarqaykillapachu. ");
INSERT INTO qvcNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ashwanmi chay ancha allin mana nima uchayuq Jisusta disprisyashpa, qamkunaqa mañakurqayki, suq matansyiru runata kach'anambaq. ");
INSERT INTO qvcNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Chaymandaqam qamkunaqa wanchichirqaykillapa chay Jisus kawsachikuqtaqa. Piru Dyusqam paytaqa wañushqanmanda kawsachimurqan. Chayshina kawsachimuptinmi, noqaykunaqa rikashqallapa kani. Chaymi tistigunguna kanillapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Chayrayku Jisuspi kriyishpa “Kach'akay” niptiyllam, kay riqsishqayki kujuqa kach'akashpa, jwirsayuqna. ");
INSERT INTO qvcNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Masitakuna, yach'anim: Qamkuna mas kamachikuq runakunawan Jisusta wanchichirqaykillapa, mana yach'ashpa: Paymi Washadurninchiq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Chayta ruraptikillapam, Dyus nishqanqa kumplishqana. Chaqa unay tyimpupim Dyuspaq rimaqkuna Jisuspaq kayshina iskibrirqan: “Dyus Akrashqan Washadurmi ancha rin ñakaq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Chayri qamkunaqa mana allikunata dijashpana, Tayta Dyuspi yuyakuyllapa, chay uchaykikunamanda pirdunashunambaq. Chayshina Dyuspi kriyiptinchiqmi, payqa rin animachiwaqninchiq kushikunanchiq. ");
INSERT INTO qvcNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Rinmi kach'amuq Churin Jisukristuta. Chaqa manaraq kay mundu kaptinmi, Jisusta numbrashqa karqan, Washadurninchiq kanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Lukismi Jisusqa manaraq rinchu kutimuq. Ashwanmi syilupilla rin kaq, Tayta Dyus kay mundupi tukuy ima nishqanda kumplinangaman. Chaqa Dyusqam paypaq ancha allin rimaqkunawan unay tyimpukunapi chayshina nishqa karqan. ");
INSERT INTO qvcNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Chaymi Dyuspaq chay rimaq Muysisqa agwilunchiqkunata Jisuspaq kayshina nirqan: “Tayta Dyusmi nasyunninchiqpi rin nasichiq paypaq suq pudirniyuq rimaqta, noqata numbrawashqanshina. Chayri tukuy ima pay nishqanda kasuyllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Chay rimaqta mana kasuqkunataqam Dyusqa wambrangunamanda akrashpa, rin chingachiq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Chaymi chay unay rimaq Samwilpa tyimpunmandapacha, Dyuspaq yumbay rimaqkuna Jisus kay tyimpupi rurashqambaq rimashpa, iskibrirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Chaqa Tayta Dyus chay rimaqkunawan ufrisikushqanmi noqanchiqkunapaq kashqa. Noqanchiqkunata yanapawananchiq yuyashpam, Dyusqa suq tratuta rurarqan unay agwilunchiqkunawan. Chaymi Abrajanda nirqan: “Karu willkaykiwanmi kay mundupi yumbay runakunata rini yanapaq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Chaymi Tayta Dyus Churinda wañushqanmanda kawsachimushpa, puntata noqanchiqkunaman kach'amurqan yanapawananchiq, chay mana alli rurashqanchiqta dijashpa, paypi yuyakunanchiqllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pidru Jwanwan chay runakunata yach'achiykaptinmi, ch'ayarqanllapa isrraylinu kurakuna, sadusiyu duktrinayuqkuna, Dyuspa adurana wasimba suldadungunapa kamachikuqnimbis. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pidruqam Jwanwan kayshina yach'achikuykarqan: —Jisusqam wañushqanmanda, kawsamushqa. Chaymi yach'anchiq: Wañuqkunaqam rin kawsamuq, nishpa. Chaypaqmi chay ch'ayamuqkunaqa ancha piñakurqanllapa. (Chaqa chay sadusiyukunaqam kriyirqanllapa: Wañuqkunaqam mana rinllapachu kawsamuq, nishpa.) ");
INSERT INTO qvcNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Chaymi Pidruta Jwanda prisushpa, aparqanllapa karsilman. Chay diya tardina kaptinmi, karsilpi dijarqanllapa qayandin diyakaman. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Piru Pidru Jwanwan yach'achikuptinmi, ancha achka runakuna Jisuspi kriyishqallapa karqan. Chaymi Jisuspi kriyiqkunaqa ullqokunallach'i 5.000na karqan. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Chaymandaqam qayandin diyaqa tandakarqanllapa chay Jirusalinman Isrrayilpa kamachikuqninguna, kamachikuq ansyanukuna, Muysispa liyningunata yach'achikuqkunapis. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Chaypiqam karqambis mas kamachikuq isrraylinu kura Anas shutiq. Chay Anasqam ayllun Kayfaswan, Jwanwan, Alijandruwan, yumbay ullqo ayllungunawambis shamushqallapa karqan. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Yumbay chay awturidarkunaqam Pidruta, Jwanda karsilmanda apachimushpa, yumbaypa ch'awpinman pasachishpa, kayshina tapurqanllapa: —¿Pitaq qamkunataqa kamachishushqa, chay kujuta kach'akachinaykiqa? ¿Pipa shutinwanmi myintashpa, chaytaqa rurashqallapa kangi? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Chaymi Pidruqa, Dyuspa Santu Ispiritun ancha yanapaptin, nirqan: —Llaqta masiy isrraylinukunapa kamachikuqninguna, kamachikuq ansyanukunapis, ");
INSERT INTO qvcNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","qamkunaqam tapuwangillapa yach'anayki: Kay runa kujuqa ¿imashinam kach'akashqa? ¿Pim paytaqa yanapashqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Mayá, nishqaykillapa, yumbay llaqta masinchiq isrraylinukuna yach'ananllapa. Kay runa kujuqam kach'akashqa Jisukristu nasarinupa pudirninwan. Qamkunam nirqaykillapa, Jisusta kruspi wanchinanllapa. Piru Tayta Dyusqam wañushqanmanda paytaqa kawsachimurqan. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Albañilkunam mana baliq rumikunata wichukunllapa. Chayshinallam qamkunapis Jisustaqa wichukurqaykillapa. Piru Jisusqam kananqa wasipa iskinambi mas baliq rumishina. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Chaqa Dyusqam mana qowashqachu kanchiq suq laya washadurtaqa. Jisusllam atin washawayninchiqtaqa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Chayshina mana nimata manchashpachu allita rimaptinllapaqa, chay awturidarkunaqa ancha ispantashqata paykunata chaparqanllapa. Chaqa Pidruwan Jwanqam mana istudyashqachu karqan. Chaymi chay awturidarkunaqa kwintata qokarqanllapa: Kay mana baliq runakunaqam Jisuswan purishpa, ancha yach'akushqallapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kanan chay runa kujupismi paykunapa ñawpambi kach'akashqana shayaykarqan. Chaymi mana nimapaq atirqanllapachu kuntraytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Chaymi paykunaqa Pidruta, Jwanda sawaman surqorqan, chay awturidarkunalla tukuy imata parlananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Chaymandaqam paykunapura kayshina parlarqanllapa: —¿Imatam atinchiq rurayta kay runakunataqa? Chaqa kay Jirusalimbiqam yumbayna yach'anllapa: Chay kujutaqam paykuna kach'akachishqa, nishpa. Chaymi noqanchiqkunaqa mana atinchiqchu niyta “Yanqam”, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ashwan manchachishpalla, nutifikashunllapa, kananmandaqa amana pitapis willananllapa Jisuspa shutimbiqa, amana chay faman masta shikwakanambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Chayshina kunanakushpaqam, Pidruta Jwanda qayachirqanllapa. Chaymandaqam jurapashpa, kamachirqanllapa, amana pitapis parlachinambaq, ni yach'achinambaq, Jisuspa shutinda myintashpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Piru chayshina kamachiptimbismi, Pidruwan Jwanqa kayshina nirqan: —Mayá, allita yuyayllapa. ¿Imataq mas alli Tayta Dyuspaqqa? ¿Allichu qamkunata kasushunaypaq, ichu mas alli Dyusta kasunayllapa? ");
INSERT INTO qvcNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Chaqa noqaykunaqam mana nimatapis atinillapachu uyaraytaqa. Ashwanmi rikashqayllapata, uyashqayllapata rinillapa yach'achikuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Chayshina niptimbismi, chay awturidarkunaqa ancha jurapashpa, dijarqanllapana rinambaq. Chaqa chay kujuta kach'akachishqanraykum, yumbay runakuna Dyusta ancha alabarqanllapa. Chaymi chay awturidarkunaqa mana nimapaq atirqanllapachu kastigayta. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Chay kach'akashqa kujuqam masdi 40 watayuqna karqan. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pidruwan Jwanqam chay kamachikuq kurakunapa, chay kamachikuq ansyanukunapa dispachunmanda lluqshishpaqa, kriyiq masingunamanna rirqanllapa. Paykunataqam manyaqlla tukuy ima pasashqanllapata willarqan. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Chaymi yumbay chay kriyiq masinguna chayta yach'ashpaqa, tandanakushpa, kayshina Dyusman mañakurqanllapa: —Taytitu Dyus, qam rurashqa kangi anaq syiluta, kay pachata, mar yakuta, tukuy ima kaqkunata. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Qamqam Santu Ispirituykiwan rimachirqayki chay unay sirbishuq agwilunchiq Dabidta. Chaymi payqa qambaq rimaq kashpa, Santu Libruykipi kayshina iskibrirqan: ¿Imaraykutaq achka nasyungunapi tiyaqkunaqa ancha piñakushpa alsakanllapa Dyuspa kuntranqa? ¿Imaraykutaq chay runakuna, warmikunaqa yanqakunata yuyanllapa, Dyusta binsinanllapaqa? ");
INSERT INTO qvcNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Chaqa kay mundupa gubyirnungunam Dyuspa kuntran alsakarqanllapa. Kanan llaqtakunapa kamachikuqningunam tandakashpa, Tayta Dyuspa, Akrashqan Washadurpa kuntran alsakarqanllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Taytitu Dyus, allibraq chay Dabid iskibrishqanshina kashqa. Chaqa kay Jirusalin llaqtapi chay akrashqayki santu Churiki Jisustam kuntrarqanllapa. Chaymi chay gubyirnu Irudis, chay gubyirnu Punsyu Pilatuwan, furastirukunawan, isrraylinukunawan tandakarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Paykunam tandakashpa, rurarqan chay unay tyimpupi qam yach'ashqaykishina: “Churiytam rinllapa wanchiq”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Dyusitu, rikay, kananqam noqaykunatapis jurapawanllapa, qamta ama myintashushpa, yach'achikunayllapa. Chayri animuta qowayllapa, ama nimata manchashpa, qambaq yach'achikunayllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Pudirnikiwanri yanapawayllapa, qeshyaqkunata kach'akachinayllapa, santu Churiki Jisuspa shutimbi milagrukunata ruranayllapa, yumbay rikaqkuna yach'anambaq: Dyusmi ancha pudirniyuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ushyaptinllapa mañakuyta Dyusmanqam, chay tandakashqanllapa lugarqa ch'apsikarqan. Chay urasmi Dyuspa Santu Ispiritun paykunapa shunqonda undashpa, masta animachirqan, ama nimata manchashpachu, Dyus nishqanda rimananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jisuspi yumbay kriyiqkunam suq yuyayniyuqlla kaqllapa. Tukuy shunqo allipta kuyanakuqllapa. Chaymi mana niqllapachu: “Kay imayqam noqapalla” nishpaqa. Ashwanmi tukuy ima kaqninwan yumbaynin yanapanakuqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Kanan Jisuspa chay dusi apustulningunam ancha pudirniyuq kashpa, kayshina yach'achikuqllapa: “Siñurninchiq Jisusmi wañushqanmanda allipta kawsamushqa”, nishpa. Kanan Dyusqam ancha yanapaq paypi yumbay kriyiqkunata, shumaqta kawsananllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Paykunaqam mayqanninda iman faltaptinqa, wakin ch'akrayuq ichu mayqan wasiyuqqa randikushpa, qellayninda apaq chay dusi apustulkunaman. Paykunaqam chay mana nimayuqkunata qoqllapa. Chaymi paykunapiqa mana ni mayqan pubriqa karqanchu. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Chaypim karqan suq libita runa Jusi shutiq. Apustulkunaqam paypaq nishqa karqan: “Birnabi shutinqa”, nishpa. Rimaynimbiqam Birnabiqa munan niyta “Kunswilakuq”. Payqam yakupa ch'awpimbi isla allpa Chipripi nasishqa karqan. ");
INSERT INTO qvcNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Chay Birnabim suq ch'akranda randikushpa, qellayninda apamushpa, apustulkunata qorqan, paykunana kriyiq masingunata yanapanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Karqanmi suq runa Ananiyas shutiq. Warminqam Safira shutiq. Chay Ananiyasmi warminwan, suq ch'akranda randikushpa, ");
INSERT INTO qvcNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","wakin qellayta piskarqanllapa. Chaymandaqam Ananiyasqa wakindalla apashpa, apustulkunata qorqan, “Yumbaymi” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Chayshina llullakuptinmi, Pidruqa nirqan: —Uyay, Ananiyas. ¿Imaraykum dijarqayki dyabluta yaykunambaq shunqoykimanqa? Qamqam chay ch'akraykipa ch'aninda wakinda piskashpaqa, Dyuspa Santu Ispiritunda munarqayki ingañayta. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Ima manachu qamba kikikipa ch'akraykiqa kashqa? Randikuptikiqam, qellayqa qambana kashqa. ¿Imaraykum llullakushqaqa kangi? Chay layata llullakushpaqach'i, qamqa yuyarqayki: Runakunatallam rini ingañaq, nishpa. Manam chayshinachu kashqa. Ashwanmi Taytanchiq Dyusta munarqayki ingañayta. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Chayshina Pidru niptinmi, Ananiyasqa chayta uyashpa, chay uras pachaman bulakashpa wañurqanna. Chaymi chayta yach'ashpaqa, yumbay ancha mancharqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Chaymandaqam wakin wambra runakuna shamushpa, almataqa suq trapuwan liyashpana, aparqanllapa pambaq. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Chayshina kimsa uras pasashqambinam, chay almapa warminqa apustulkuna kashqanman yaykurqan. Piru payqam mana nimatapis yach'arqanchu: Qosaymi wañushqa, nishpaqa. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Chaymi Pidruqa paytapis tapurqan: —Safira, ¿allipchu chay prisyupaqlla ch'akraykitaqa randikurqayki? nishpa. Chaymi Safiraqa nirqan: —Arí. Chaysitupaqllam randikurqayllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Chayshina niptinmi, Pidruqa chay warmita nirqan: —¿Imapaqmi qosaykiwanqa kunanakushpa llullakushqallapa kangi, “Dyuspa Santu Ispiritunqam mana yach'anqachu”, nishpach'i? Uyay, chay qosaykita pambaqkunaqam shamuykanllapana. Nam kay pungumanna ch'ayamuykanllapa apashunambaq, qamtapis pambashuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Chayshina niptinllam, chay warmipis chay uras Pidrupa ñawpanman bulakashpa wañurqanna. Chaymi chay pambakuqkunaqa ch'ayamushpa, ukuman yaykushpa, chay warmitapis wañushqatana tarirqanllapa. Chaymi paytapis aparqanllapana pambaq runamba ladunman. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Chaymi Jisuspi kriyiqkunaqa, tukuy chay wakin runakunawan chayta yach'ashpaqa, ashwamba mancharqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Apustulkunaqam runakunapa ñawpambi achka milagrukunata ruraqllapa. Kanan Jisuspi yumbay kriyiqkunam Dyuspa adurana wasinman tandakaqllapa chay unay gubyirnu Salumumba kurridurnimbi. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Piru mana kriyiqkunaqam manchashpa, paykunawanqa mana tandakaqllapachu. Piru mana tandakashpapismi, ancha alabaqllapa Jisuspi kriyiqkunataqa. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Chayshinam ancha achka ullqokuna, warmikuna kriyirqanllapana Jisuspi. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kanan achka runakunam qeshyaqningunata wasinmanda surqoshpa, parakunapi kamakunapi apamushpa, ñangunapi shuyachiqllapa, Pidru chay ñanda pasaptin, ankisiya llandunllapis qeshyaqningunapa sawanda pasaptin, kach'akanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Asta chay sirka llaqtakunamandam achka runakunaqa Jirusalinman apamurqan qeshyaqningunata, dyablupa ispiritungunawan lukuyashqakunata, apustulkuna kach'akachinambaq. Kanan yumbay paykunataqam kach'akachirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Chaymi mas kamachikuq isrraylinu kura, sadusiyu duktrinayuq runakuna apustulkunata ancha imbidyarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Chaymi paykunataqa prisushpa, karsilman wichurqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Piru chay tutaqam Tayta Dyuspa suq anjilnin, karsilpa pungunda kich'ashpa, paykunata surqoshpa, nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Riyllapa Dyuspa adurana wasinman, chaypi shayashpa, yumbay runakunata yach'achiq, Jisuspi kriyishpa, kawsanambaqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Chayshina niptinqam, apustulkunaqa kasushpa, madrugadu Dyuspa adurana wasinman rishpa, waqpi yach'achikurqanllapa. Chaypina kaykaptinllapaqam, chay mas kamachikuq isrraylinu kura, yumbay paywan kaqkunapis mas pudirniyuq isrraylinukunata qayarqan, tandakashpa, Mas Kamachikuq Tandakaq Juyiskunana kashpa, Pidruta, Jwanda jusgananllapa. Yumbay chay kamachikuqkunaqam parlashpa, suldadukunata kach'arqanllapa, karsilmanda apamunanllapa chay apustulkunata. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Piru suldadukuna karsilman rishpaqam, manana tarirqanllapachu. Chaymi das kutimurqanllapa kayshina abisakuq: ");
INSERT INTO qvcNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—Karsiltaqam tarishqallapa kani alli kirpashqata. Chay kwidakuq suldadukunaqam karsilpa pungundaqa ancha allita kwidaykarqanllapa. Piru punguta kich'ashpaqam, manana ni pitapis ukupiqa tarirqayllapachu, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Chayshina niptinllapaqam, chay isrraylinu kurakunapa kamachikuqninqa, Dyuspa adurana wasimba suldadungunapa kamachikuqninwan, yumbay chay ancha kamachikuq kurakunawambis ancha yuyashpa, tapunakurqanllapa: —Chayshinaqa ¿imaraq pasanqa? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Chayshina parlaykaptinqam, suq runa ch'ayamushpa, nirqan: —Chay karsilashqaykillapa runakunaqam Dyuspa adurana wasimbi runakunata yach'achiykan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Chaymi suldadukunapa kamachikuqninqa suldadungunawan chay uras chay adurana wasiman rirqanllapa piskaq. Apustulkunata chaypi tarishpaqam, shumaqlla apamurqanllapa, mana maqashpallapachu. Chaqa chay suldadukunaqam mancharqanllapa: Kay apustulkunata maqaptinchiqqach'i, runakunaqa sitawanchiqman, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Chaymandaqam apustulkunata ch'ayachimushpaqa, shayachirqanllapa chay Mas Kamachikuq Tandakaq Juyiskunapa ñawpanman. Chaypi kaptinqam, chay kamachikuq kuraqa nirqan: ");
INSERT INTO qvcNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Manchu noqaykunaqa qamkunata ancha kamachishurqaq, amakish Jisuspa shutinda myintashpaqa yach'achikungichu, nishpa. Piru qamkunaqam mana kasuwashpachu, tukuy Jirusalin llaqtapi duktrinaykita yach'achikungillapa. Kanan ashwambam munangillapa wichupawayta chay Jisus wañushqambaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Chaymi Pidruqa chay wakin apustulkunawan nirqan: —Noqaykunapaqqam masta balin Dyusta kasunayllapa, runakunata kasunaymandaqa. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Manchu qamkunaqa Jisusta kruspi klabachishpa, wanchichirqaykillapa. Piru paytaqam Taytanchiq Dyus kawsachimushpa, ");
INSERT INTO qvcNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","anaq syilupi allin ladumbi tiyachishpa, ancha Kamachikuq Washadurninchiqta rurashqa. Chaymi uchanchiqkunata dijaptinchiqqa, payqa pirdunawaqninchiq washawanchiqllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Chay Jisus rurashqambaqmi Dyuspa Santu Ispiritun, noqaykunapis tistigukuna kanillapa. Chaqa Tayta Dyusmi chay Santu Ispiritunda payta kasuqkunata qowashqallapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Chay awturidarkunaqam chayta uyashpaqa, ancha piñakushpa, chay apustulkunataqa munarqanllapa wanchiyta. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Piru chay awturidarkunamanda suq farisiyu Gamayil shutiqmi ancha allin yach'achikuq karqan. Chaymi paytaqa yumbay runakuna ancha allita uyaqllapa. Chay Gamayilmi shayashpa kamachikurqan, suq rratitu apustulkunata sawaman surqonanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Chaymandaqam chay karguyuq masingunata nirqan: —Uyawayllapa, isrraylinu masiykuna. Allita yuyayllapa. Kwidawkish mana allitachu rurangimanllapa chay runakunata. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Yuyayllapa, manchu suq tyimpuqa chay runa Tiwdas nirqan, payshi ancha kamachikuq. Kanan paytaqam 400 runakuna kasurqanllapa. Chaymandaqam suq runakuna Tiwdasta wanchiptinllapa, chay 400 sigiqkuna waqta kayta shikwakarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Chaymandaqam suq tyimpu sinsuta ruraptin, alsakarqan suq kamachikuq Judas prubinsya Galiliyamanda. Paytapismi achka runakuna kasurqanllapa. Chaymandaqam chay Judasta wanchiptinllapaqa, payta sigiqkunapis waqta kayta shikwakarqanllapa. Mananam mastaqa tandakarqanllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Chaymi kayshina kunaykillapa: Dijayllapa chay runakunata. Ama mitikuyllapachu paykunamanqa. Chaqa chay duktrinan paykunapalla kaptinqam, das rin ushyakaq. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Piru paykuna Dyuspa duktrinanda yach'achikuykaptinqam, qamkunaqa mana atingillapachu chingachiyta. Allita yuyayllapa. Paqtakish Dyusta kuntraykangillapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Chay Gamayil nishqanda kasushpam, manana wanchirqanllapachu. Chaymi chay apustulkunata qayachishpa, suq lastima asutichishpa, kamachirqanllapa, amana masta Jisuspaq yach'achikunanllapa. Chaymandaqam paykunataqa kach'arqanllapana. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Chayshina asutiptimbismi, chay apustulkunaqa ancha kushikushpa, chay awturidarkunapa ñawpanmanda lluqshirqanllapa, yuyashpa: Tayta Dyusmi akrawashqa kanchiq, kayshina Jisuspaq yach'achikushpa, ñakananchiqpaq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kanan paykunaqam tukuy diyakuna Jisukristupaq masta yach'achikurqanllapa Dyuspa adurana wasimbi, achka wasikunapipis. ");
INSERT INTO qvcNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Chay tyimpuqam Jisuspi kriyiqkunaqa masta achkayaqllapa. Piru chay grigu rimaypi rimaqkuna piñakushpam, kayshina rimarqanllapa ibriyu rimaypi rimaq kriyiq masingunapaq: —Grigupi rimaq biyudakunatash tukuy diya mana allitachu mikunata partinllapa, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Chaymi chay dusi apustulkunaqa yumbay kriyiqkunata tandashpa nirqanllapa: —Noqaykunaqam Dyus nishqanda yach'achikuykani. Chaymi mana allichu, chay yach'achikuykashqayta dijashpa, mikunata partinayllapaqa. ");
INSERT INTO qvcNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Chayri masitakuna, qamkunamanda akrayllapa syiti allin yach'ayniyuq runakunata, Dyuspa Santu Ispiritunwan puriqkunata. Paykunata numbrayllapa, chay mikunata partinanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Noqaykunaqam tukuy diya Dyusman rinillapa mañakuq. Pay nishqanda rinillapa yach'achikuq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Chaypaqmi Jisuspi yumban kriyiqkunaqa nirqan: —Allibmi chay nishqaykillapaqa, nishpa. Chaymandaqam akrarqanllapa suq runa Istiban shutiqta. Payqam Tayta Dyuspi ancha yuyakuq. Paypa shunqombim Dyuspa Santu Ispiritun kawsaq. Paykunaqam akrarqambis Filipita, Prukuruta, Nikanurta, Timunda, Parminastapis. Akrarqambismi Nikulasta Antyukiya llaqtamanda kaqta. Paymi yach'akushqa karqan isrraylinukunapa duktrinanda. ");
INSERT INTO qvcNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Chaymandaqam chay syiti runakunata apamurqanllapa apustulkunaman. Paykunaqam sawambi makinda rurashpa, Dyusman mañakurqanllapa, tukuy imapi yanapanambaq. ");
INSERT INTO qvcNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Chayshinam Jisuspi kriyiqkunaqa Dyuspaq tukuy maypi masta masta yach'achikuqllapa. Chaymi Jirusalin llaqtapiqa paykunaqa masta achkayaqllapa. Chaqa asta isrraylinukunapa achka kurangunapismi Jisuspi kriyirqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Dyus yanapaptinmi, Istibanqa ancha pudirniyuq kashpa, achka milagrukunata rurarqan yumbaypa ñawpambi. ");
INSERT INTO qvcNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Piru wakin isrraylinukuna Istibanwan tandakashpam, taripanakurqan. Paykunaqam suq sinaguga wasimanda karqanllapa. Chay wasiqam shutiq Libri Randishqa Kriyadukunapa sinagugan, nishpa. Chay kuntraqkunaqam Sirini llaqtamanda, Alijandriya llaqtamanda, prubinsya Silisyamanda, chay prubinsya Asyamandapis karqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Piru Istibanqam Dyuspa Santu Ispiritunwan kashpa, ancha yach'ayniyuq karqan. Chaymi chay kuntraqkunaqa mana atirqanllapachu binsiyta paytaqa. ");
INSERT INTO qvcNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Chaymi pagararqanllapa wakin runakunata, llullakushpa ninambaqllapa: “Istibandam uyashqa kani, ancha fiyuta Muysispaq, Dyuspaq rimaptin”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Chayshina llullakuptinllapa uyashpam, achka runa, kamachikuq ansyanukuna, Muysispa liyningunata yach'achikuqkuna chay nishqanda kriyishpa, ancha piñakurqanllapa. Chaymi Istibanda piskashpa, rrastrakushpa, aparqanllapa Mas Kamachikuq Tandakaq Juyiskunapa ñawpanman. ");
INSERT INTO qvcNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Kanan aparqanllapapismi chay llullakuq tistigukunata, Istibambaq kayshina rimanambaqllapa: —Kay runaqam kutin kutin mana shaykuq ancha fiyukunata riman Dyuspa adurana wasimbaq, Muysispa liyningunapaqpis. ");
INSERT INTO qvcNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Chaqa noqaykunaqam kay Istibanda uyashqallapa kani kayshina niptin: Chay Jisus Nasaritmanda kaqshi Dyuspa adurana wasindaqa rin bulaq. Muysismanda yach'akushqanchiq kustumbrinchiqkunatash rin chingachiq, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Chaymi chay Mas Kamachikuq Tandakaq Juyiskuna, yumbay chaypi tiyaqkunawan chapashpa, rikarqanllapa Istibamba qaqllanda anjilshina llipyaykaqta. ");
INSERT INTO qvcNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Chay mas kamachikuq isrraylinu kuram Istibanda tapurqan: —¿Allipchur chayshina nishqa kangi? nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Chaymi Istibanqa nirqan: —Taytakuna, masitakuna, allita uyawayllapa. Ancha pudirniyuq llipyaykaq Tayta Dyusmi rikakurqan chay punta agwilunchiq Abrajanman, chay nasyun Misuputamyapi tiyaykaptin, manaraq Aran llaqtaman riptin tiyaq. ");
INSERT INTO qvcNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Kayshinam kamachirqan: “Llaqtaykita, yumbay aylluykikunata dijashpa, riy suq lugarman. Noqam rini rikachishuq maypim kidan chay lugarqa”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Chayshina Dyus niptinmi, Abrajanqa chay Kaldiya nasyunmanda lluqshishpa, rirqan Aran llaqtaman tiyaq. Chaymandaqam Abrajamba taytan wañuptinqa, Dyusqa chay Abrajandaqa kay Isrrayil nasyunninchiqman apamurqan. ");
INSERT INTO qvcNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Piru Dyusqam mana nima irinsyata ni suq pidasu ch'akritata qorqanchu Abrajandaqa. Payqam alayri kaypiqa tiyarqan. Mana qoshpapismi, Abrajandaqa kayshina ufrisirqan: “Wañuptikiqam, karu willkaykikunapaq kay pachaqa rin kaq”, nishpa. Chayshinam chay Abrajandaqa ufrisirqan, manaraq ni churiyuq kaptin. ");
INSERT INTO qvcNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Tayta Dyusqam chay unay agwilunchiq Abrajandaqa nirqambis: “Karu willkaykikunam kay llaqtamanda rishpa, suq nasyumbi suq furastirushina rinllapa tiyaq. Ñakaq randishqa kriyadukunam rinllapa kaq. Paykunatam ancha rinllapa qesachaq 400 wata tukuyta”. ");
INSERT INTO qvcNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","’Tayta Dyusqam Abrajandaqa nirqambis: “Piru kastigaqmi rini chay nasyumbi qesachakuqkunataqa. Chaymandaqam chay karu willkaykikunaqa, chay nasyunmanda lluqshishpa, rinllapa kasuwaq kay Isrrayilpi”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Chaymandaqam Dyusqa Abrajanwan suq tratuta rurarqan. Paytam kamachirqan, kwirpumbi siñalta ruranambaq, ama qonqanambaq chay tratu rurashqanda. Chaymi Abrajanqa churin Isak nasiptinqa, uchu diyasniyuq kaptinlla, kwirpumbi chay siñalta rurarqan. Chayshinallam Isakpis churin Jakubuta rurarqan. Chay Jakubupismi chayshinalla rurarqan dusi churingunata. Chay dusi churingunaqam nasyunninchiq Isrrayilpa chay dusi atun ayllungunapa taytanguna karqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Chay Jakubupa dusi churingunaqam punta agwilunchiqkuna karqan. Paykunaqam masan Jusita imbidyashpa randikurqanllapa, chay randiqkuna Ijiptu nasyunman apanambaqllapa. Piru Dyusqam Jusipa pullan karqan. ");
INSERT INTO qvcNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Chaymi Jusi ñakaptinqa, Tayta Dyus yumbay chay ñakashqanmanda washashpa, yanaparqan, yach'ayniyuq kashpa, allita kawsanambaq. Chayshina Dyus Jusita yanapaptinmi, chay Ijiptupa gubyirnun Farunqa ancha gustarqan. Chaymi Jusita numbrarqan, Ijiptupa gubyirnun kanambaq. Paytaqam nirqambis: “Tukuy ima kaqniyta, wasiykunapi yumbay tiyaqkunatapis qam kwiday”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Chaymandaqam Ijiptu nasyumbi Kanayan nasyumbipis ancha jwirti ambruna karqan. Chaymi mikunan mana aypaptin, chay punta agwilunchiqkunaqa ancha ñakarqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Chayshina ñakashpaqam, Jakubuqa yach'arqan: Ijiptupish kan trigu, nishpa. Chaymi chay punta bwiltata dyis churingunata Ijiptuman kach'arqan, triguta randinanllapa. Chay churingunaqam unay agwilunchiqkuna karqan. ");
INSERT INTO qvcNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Chaymandaqam suq kutinda kutiriptinllapa Ijiptuman, triguta randirinambaqqa, Jusiqa masangunata nirqan: “Noqam masayki Jusi kani”, nishpa. Chayshina masanguna Jusita riqsiptinqam, Ijiptupa gubyirnun Farunqa yach'arqan: Jusiqash isrraylinukunapa kastan, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Chaymandaqam Jusiqa chay masangunata nirqan: “Riyllapa apamuy taytanchiqta, yumbay ayllunchiqkunata”, nishpa. Chay tyimpupim 75 karqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Chayshinam karqan, Jakubu yumbay ayllundin riptin Ijiptuman tiyaq. Waqpinam achka watakunamanda payqa wañurqanna. Chaymandaqam tukuy chay punta agwilunchiqkunapis achka wambrangunata dijashpa, wañurqanllapa. ");
INSERT INTO qvcNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Jakubu wañuptinqam, kwirpunda aparqanllapa Sichin llaqtaman pambaq paypa pantyunnimbi. Chaqa Abrajanmi chay pantyundaqa randishqa karqan chay runa Jamurpa churingunamanda. ");
INSERT INTO qvcNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Tayta Dyusmi jurashpa, Abrajanda kayshina ufrisishqa karqan: “Suq nasyundam rini qoq karu willkaykikunata”, nishpa. Chay ufrisishqan tyimpu kumplinan kaykaptinmi, chay Ijiptu llaqtapiqa isrraylinukuna anchana achkayashqa karqan. ");
INSERT INTO qvcNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Chay tyimpupim Ijiptupiqa suq mushuq gubyirnu kamachikurqan. Payqam mana nimatapis yach'ashqachu karqan chay Jusipa allin famambaqqa, ancha unayna wañushqa kaptin. ");
INSERT INTO qvcNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Chay mushuq gubyirnuqam chay agwilunchiqkunataqa tukuy imapi ingañashpa, ancha qesachaq. Chaymi paykunataqa kamachirqan, ullqo wambritunguna nasiptin, wichukunanllapa wañunambaq. ");
INSERT INTO qvcNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","’Chayshina kamachikuptinmi, chay tyimpupi Muysis nasirqan. Paytaqam Dyusqa ancha kuyaq. Kanan taytanwan mamanqam kimsa killata wasimbi pakashpa, kriyarqan. ");
INSERT INTO qvcNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Chaymandaqam (chay gubyirnuta kasushpa) wichukuptinqa, chay gubyirnupa chinan chay wambrituta tarikushpa, tandashpa, wawandashina kriyarqan. ");
INSERT INTO qvcNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Chaymi Muysis wiñashpaqa, tukuy imata ijiptinu runakunashina yach'akurqan. Chaymi tukuy imata rimanambaq, ruranambaqqa ancha pudirniyuq karqan. ");
INSERT INTO qvcNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Chaymandaqam 40 watayuqna kashpaqa, Muysisqa munarqanna riyta isrraylinu kastanda watukuq. ");
INSERT INTO qvcNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Chaymi rishpaqa, rikarqan suq ijiptinu ancha maqaykaqta suq isrraylinuta. Chaymi Muysisqa chay isrraylinuta washashpa, wanchirqan chay ijiptinuta. ");
INSERT INTO qvcNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Chaqa Muysisqam yuyarqan: Isrraylinu masiykunach'i allita intyindinqallapa: Muysiswanmi Dyusqa rin yanapawaqninchiq, ama randishqa kriyadukuna kananchiqllapa, nishpa. Piru chay isrraylinu masingunaqam mana intyindirqanllapachu. ");
INSERT INTO qvcNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Qayandin diyaqam Muysisqa isrraylinukunaman kutirishpa, ishkayta tarirqan paykunapura pilyaykaqta. Chaymi munashpa alliyachiyta, paykunataqa nirqan: “Qamkunaqam llaqta masipura kangillapa. ¿Imapaqmi pilyaykangillapa? Ama pilyayllapachu”, nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","’Piru chay yanqa maqaqmi Muysista kumsashpa, nirqan: “¿Ima pitaq qamtaqa numbrashushqa, noqaykunapa kamachikuqniy, juyisniyllapa kanaykiqa? ");
INSERT INTO qvcNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Ima munangichu noqatapis wanchiwayta qayna chay ijiptinuta wanchishqaykishina?” nishpa. ");
INSERT INTO qvcNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Chayshina niptinmi, Muysisqa manchashpa, mitikarqan nasyun Madyan shutiqman. Chaypiqam kasarashpa, ishkay wambrayuqna karqan. Piru chaypiqam furastirushina tiyarqan. ");
INSERT INTO qvcNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Chaymandaqam 40 watas pasaptinna, Muysisqa chuncha lugar Sinayi urqqopa ladumbi kaykarqan. Chay chunchapim Dyuspa anjilninqa suq yura sach'api nina lumyaykaqpi Muysisman rikakurqan. ");
INSERT INTO qvcNT_vpl VALUES ("AC7_31","074_7