﻿USE sofia;
DROP TABLE IF EXISTS sofia.qva_vpl;
CREATE TABLE qva_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES qva_vpl WRITE;
INSERT INTO qva_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesús caran rey Davidpa ayllun. David caran Abrahampa ayllun. Chaymi Abrahampita galaycur Jesuspa unay aylluncuna caycuna caran: ");
INSERT INTO qva_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahampa wamran caran Isaac. Isaacpa wamran caran Jacob. Jacobpa wamran caran Judá y waquin wauguincunapis. ");
INSERT INTO qva_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judäpa wamrancunam caran Fareswan Zara. Paycunapa maman caran Tamar. Farespa wamran Esrom. Esrompa wamran Aram. ");
INSERT INTO qva_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arampa wamran Aminadab. Aminadabpa wamran Naasón. Naasonpa wamran Salmón. ");
INSERT INTO qva_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmonpa wamran caran Booz. Boozpa maman caran Rahab. Boozpa wamran caran Obed. Obedpa maman caran Rut. Obedpa wamran caran Isaí. ");
INSERT INTO qva_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaïpa wamran caran rey David. Rey Davidpa wamran caran Salomón. Salomón yuriran Uriaspa viudanchru. ");
INSERT INTO qva_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomonpa wamran Roboam. Roboampa wamran Abías. Abiaspa wamran Asa. ");
INSERT INTO qva_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asapa wamran Josafat. Josafatpa wamran Joram. Jorampa wamran Uzías. ");
INSERT INTO qva_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziaspa wamran Jotam. Jotampa wamran Acaz. Acazpa wamran Ezequías. ");
INSERT INTO qva_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequiaspa wamran Manasés. Manasespa wamran Amón. Amonpa wamran Josías. ");
INSERT INTO qva_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiaspa wamran caran Jeconías y waquin wauguincunapis. Jeconías yurinan wichan Israel runacunata Babilonia soldäducuna prësu charircur Babilonia naciunman aparan. ");
INSERT INTO qva_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Chaychrünam Jeconiaspa wamran Salatiel yuriran. Salatielpa wamran Zorobabel. ");
INSERT INTO qva_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabelpa wamran Abiud. Abiudpa wamran Eliaquim. Eliaquimpa wamran Azor. ");
INSERT INTO qva_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azorpa wamran Sadoc. Sadocpa wamran Aquim. Aquimpa wamran Eliud. ");
INSERT INTO qva_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudpa wamran Eleazar. Eleazarpa wamran Matán. Matanpa wamran Jacob. ");
INSERT INTO qva_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobpa wamran José Mariapa gosan caran. Mariana Jesuspa maman caran. Paymi Dios cachramungan Salvador caran. ");
INSERT INTO qva_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Chauraga Abraham cawanganpita pacha David cawangancama chrunca chruscu (14) generacion caran. David cawanganpita pacha Israel runacuna Babiloniaman apanan wichancama chrunca chruscu generacion caran. Babiloniaman apanganpita pacha Tayta Dios cachramungan Salvador yuringancama chrunca chruscu generacion caran. ");
INSERT INTO qva_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesús yurinanpag caynuy caran: Mariawan tiyananpag José parlashana caycaran. Ichanga mana majachacaranrächu. Manaräpis majachacar Santu Espiritupa munayninwan María gueshyag ricacuran. ");
INSERT INTO qva_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Gueshyag ricacaruptin Josëga ali runa car pitapis mana musyachilar jaguiriycuyta yarparan. ");
INSERT INTO qva_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ichanga jaguiriycunanpag yarpachracusha caycaptin Tayta Diospa angilnin Josëta suyñuyninchru niran: “Rey Davidpa ayllun José, mana manchacuypa Mariata majayquipag shuntay. Pay gueshyag ricacusha Santu Espíritu munayninpam. ");
INSERT INTO qva_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mariapa wamran olgum canga. Jutinta chrurapanqui Jesús jutin cananpag. Chaynuy jutin canga marcamasincunata juchäcunganpita perdunar salvananpag captinmi”. ");
INSERT INTO qva_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Chaynuy caran Tayta Diosninchi willacogninwan caynuy willacachingan cumplinanpämi: ");
INSERT INTO qva_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Doncëlla jipashmi gueshyag ricacunga y olgum wamran canga. Jutinta ‘Emanuel’ jutin cananpag chrurapäpäcunga”. (Emanuel ninanga “Tayta Dios noganchiwanmi caycan” ninanmi.) ");
INSERT INTO qva_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Chaynuy niptinmi José puñuycanganpita ricchapacarimur Tayta Diosninchipa angilnin ningannuyla Mariawan tiyaran. ");
INSERT INTO qva_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Mariawan José mana puñuranrächu olgu wamranta gueshyacungancama. Gueshyacururna chay wamrapa jutinta Jesús jutin cananpag José chruraparan. ");
INSERT INTO qva_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","2","Jesús yuriran Judea provincia Belén marcachrümi. Chay wichan Jerusalenchru rey Herodes caycaran. Chaymanmi inti yargamunan lädu naciunpita estrëllacunapita musyagcuna Jerusalenman chrayaran. Chrayaycurna tapucäriran: “Israel runacunapa mandagnin rey cananpag yureg wamra ¿maychrütag caycan? Marcäpitam ricapäcamushcä estrëllanta. Chaymi shapäcamushcä payta adoräpäcunäpag”. ");
INSERT INTO qva_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Chayta mayar rey Herodes pasaypa yarpachracuyman chrayaran. Chaynuy captinmi Jerusalén runacunapis pasaypa yarpachracuyman chrayapäcuran. ");
INSERT INTO qva_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Chaymi rey Herodisga cüracunapa mandagnincunata y Moisés escribingan leycunata yachrachegcunata gayaycachir tapuran: “¿Maychrütag Tayta Dios cachramunanpag cag Salvador yurinan casha?” ");
INSERT INTO qva_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Chauraga nipäcuran: “Judea provincia Belén marcachru yurinanpämi Tayta Diospa willacognin caynuy escribiran: ");
INSERT INTO qva_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Judá partichru Belén marca, gam jatusag marcacunapita tacsha marcala captiquipis gamchrümi Israel runacunapa mandagnin yuringa’ ”. ");
INSERT INTO qva_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Chauraga Herodes estrëllacunapita musyagcunata gayachiran pacaylapa parlananpag. Chrayaycuptinnam tapuran imaypitana chay estrëllata ricapäcungantapis. ");
INSERT INTO qva_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nircurna Belenman Herodes caynuy cachraran: “Chay marcaman aywaycur chay wamrata shumag ashipäcamuy. Tariycurga willapäcamanqui nogapis adorag aywanäpag”. ");
INSERT INTO qva_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Chaynuy niptinmi estrëllacunapita musyag runacuna aywapäcuran. Aywarcaptinna chay ricangan estrëllapis paycunapa ñaupagninta aywaran. Wamra caycangancag wasi altunman chrayaycurna ichricuycuran. ");
INSERT INTO qva_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Chaychru ichricuycogta ricarmi estrëllacunapita musyagcuna pasaypa cushicäriran. ");
INSERT INTO qva_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Chay wasiman yaycurna taripäcuran Jesusta y maman Mariata. Chaypitana Jesuspa ñaupagninman adorar gongurpacäriran. Nircurna öruta, inciensuta, y mïrra jutiyog perfümita jorgurir goycäriran. ");
INSERT INTO qva_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Paycunatam Tayta Diosninchi suyñuyninchru niran Herodiscagman manana cutipäcunanpag. Chaypita juc lädu camiñupana marcanman cuticäriran. ");
INSERT INTO qva_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Estrëllacunapita musyag runacuna marcanman cuticaräriptinnam Josëta suyñuyninchru Tayta Diosninchipa angilnin niran: “¡Sharcuy! Wamrata mamantinta Egiptuman gueshpichiy. Chaychru tiyanqui willacamungäcama. Rey Herodismi Jesusta ashichinga wañuchinanpag”. ");
INSERT INTO qva_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Chauraga José chacaypa Jesusta mamantinta pushacurcur Egiptuman aywacuran. ");
INSERT INTO qva_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Chaychru paycuna tiyaran Herodes wañungancama. Chaynuy pasaran willacogninwan Tayta Dios escribichingannuymi: “Egiptupitam Wamräta gayamushcä”. ");
INSERT INTO qva_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Estrëllacunapita musyag runacuna willag mana cutiptinna Herodes fiyupa rabyacuran. Chaymi Belén marcachru y estanciacunachru chayrag yurishapita asta ishcay watayogcama lapan olgu wamracunata soldäduncunawan wañuchichiran. Chaynuy rurachiran estrëllacunapita musyagcuna estrëllanta ricanganpita pacha chay junagcama yuparcurmi. ");
INSERT INTO qva_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Chaynuy cumpliran willacognin Jeremiaswan Tayta Dios escribichingannuymi: ");
INSERT INTO qva_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramá jutiyog marcachrümi mayacaran laquicur fiyupa wagangancuna. Raquelmi wamrancunapag wagaran. Wañushana captinmi pipis cuyapänanta mana munaranchu”. ");
INSERT INTO qva_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Egiptuchru José caycaptinmi Herodes wañuran. Chaymi suyñuyninchru Josëta Tayta Diosninchipa angilnin niran: ");
INSERT INTO qva_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Wamrata mamantinta pushacurcur Israelmanna cuticuy. Wamrata wañuchiyta munagcuna wañushanam”. ");
INSERT INTO qva_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Chauraga angel ningannuy Israelman wamrata mamantinta José cutichiran. ");
INSERT INTO qva_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Herodispa wamran Arquelao taytanpa truquin Judea provinciachru rey caycanganta musyarmi Judeaman cutiyta José manchacuran. Manchacuptinmi suyñuyninchru Tayta Diosninchipa angilnin niran Galilea provinciaman aywananpag. ");
INSERT INTO qva_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Chrayaycurna Nazaret jutiyog marcaman tiyananpag aywaran. Chaynuy pasaran Tayta Diospa willacognincuna “Pay Nazaret marcapitam” nipäcungan cumplinanpämi. ");
INSERT INTO qva_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Chay wichanmi Judea provinciachru chunyag jircaman Juan Bautista chrayaran. ");
INSERT INTO qva_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Chaychrümi Tayta Diospa willacuyninta willacuycar niran: “¡Juchayquicunapita wanacäriy y Tayta Dios munangannuy cawapäcuy! Tayta Diospa munayninchru canapag tiempo chrayaycämunnam”. ");
INSERT INTO qva_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Juan Bautistapag Tayta Diospa willacognin Isaiaswan caynuy nir willacachiran: “Chunyag jircachrümi juc runa fiyupa gayaraycar willacunga: ‘Mandag runa shamunanpag camiñucunata pichar camaricäringayquinuy camaricäriy Señurta chrasquicärinayquipag’ nir”. ");
INSERT INTO qva_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juan Bautistapa röpan camellupa agchanpita awasham caran y wachrcacunanpag cinturunninna garapita caran. Micuynin caran chucluscuna y uñuñuypa mishquincunalam. ");
INSERT INTO qva_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalenpita, Judea provinciachru cag may chay marcacunapitapis y Jordán mayu läduncunapitapis runacuna Juan cangancagman aywaran willacunganta mayananpag. ");
INSERT INTO qva_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Juchäcungancunata willapaptin Jordán mayuchru paycunata Juan bautizaran. ");
INSERT INTO qva_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ichanga chayman achca fariseo y saduceo runacuna bautizacunanpag shamogta ricarmi Juan Bautista niran: “¡Culebra casta runacuna! Gamcunata, ¿pitag nishushcanqui fiyupa castïgo aywaycämogman mana chrayapäcunayquipag canganta? ");
INSERT INTO qva_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Chayman mana chrayapäcunayquipag juchayquipita rasunpa wanacusha carga alita rurar cawapäcuy. ");
INSERT INTO qva_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ama yarpäpäcuychu: ‘Abrahampa ayllun captï Diosnï salvamanga’ nir. Gamcunata nï: Tayta Diosninchega cay rumicunatapis Abraham casta runaman ticrarachinmanmi. ");
INSERT INTO qva_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Jächa camarishanam caycan yüracunata cuchunanpag. Mana ali wayog yüracunataga sapipita cuchurir ninaman gaycunga. ");
INSERT INTO qva_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Juchayquicunapita wanacur yacuwan gamcunata bautizä. Nogapa guepätarag shamog runa ichanga nogapita mas munayniyogmi. Nogaga manam llanquinta apanaläpäpis välïchu. Payga Santu Espirituwan y ninawan bautizangapag. ");
INSERT INTO qva_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Payga urquëtan aptasham caycan y trïguta wayranga. Nircurmi trïguncagta wasinman chruranga. Y transancagtana rupachinga imaypis mana upeg ninachru”. ");
INSERT INTO qva_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jesús Galilea provinciapitam Jordán mayuman Juan bautizänanpag aywaran. ");
INSERT INTO qva_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Chrayaptin paytaga Juan bautizayta mana munaranchu. Niran: “Gammi nogata bautizämänayqui. Nogachu manam gamta bautizänä”. ");
INSERT INTO qva_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Chauraga Jesús niran: “Chaynuy ama yarpaychu. Chayta Tayta Dios munangantam ruraycanchi”. Chaynuy niptinmi Juan bautizaran. ");
INSERT INTO qva_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Bautizarcuptin yacupita Jesús jucla yargamuptinnam cielo quichracäcuran. Chaychrümi ricaran Tayta Diospa Espiritun palumatucular payman yarpaycämogta. ");
INSERT INTO qva_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Chaynuypis cielupita caynuy nimungan mayacämuran: “Paymi cuyay Wamrä. Paypitam noga cushisha caycä”. ");
INSERT INTO qva_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Chaypitanam chunyag jircaman Santu Espíritu Jesusta pusharan Satanás juchäcachiyta camananpag. ");
INSERT INTO qva_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Chaychrümi chruscu chrunca (40) junag y chruscu chrunca pagas micünila caran. Chaypitanam micanaran. ");
INSERT INTO qva_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Chaymi Satanás chrayaycur niran: “Diospa Wamran caycarga cay rumicunata tantacunaman ticrananpag niy”. ");
INSERT INTO qva_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Chaynuy niptin Jesús niran: “Tayta Dios escribichinganchru caynuymi niycan: ‘Manam tantata micularchu runacuna cawan sinöga Tayta Dios lapanta ningancunata cäsucurpis cawanmi’ ”. ");
INSERT INTO qva_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Chaypitanam Jerusalenman templo janan mas altunninman Jesusta Satanás pusharan. ");
INSERT INTO qva_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Chaychrünam payta niran: “Diospa Wamran caycarga caypita pampaman jegarpuy. Dios escribichinganchru niycan: ‘Angilnincunatam Tayta Dios cachramunga cuydashunayquipag’ y ‘Paycunam maquincunawan charishunqui ni chraquilayquitapis rumicunaman mana tacacunayquipag’ ”. ");
INSERT INTO qva_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Niptinmi Jesús niran: “Tayta Dios escribichinganchru caynuypis niycanmi: ‘Tayta Diosniquita quiquiqui munangayquita ama rurachiyta camaychu’ ”. ");
INSERT INTO qva_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Chaypitanam Jesusta Satanás altunnin jirca puntaman pusharan. Chaypitanam ricachiran may chay naciuncunata y chaychru imaycapis cagcunata. ");
INSERT INTO qva_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nircur niran: “Cay lapantam goycushayqui gongurpaycur nogata adorämaptiquega”. ");
INSERT INTO qva_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesús niran: “¡Aywacuy, Satanás! Tayta Dios escribichinganchru niycan: ‘Tayta Dioslata adoray y pay japalan mandanganta ruray’ ”. ");
INSERT INTO qva_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Chaynuy niptinmi Satanás aywacuran. Chaypitanam angilcuna chrayaycur Jesusta yanaparan. ");
INSERT INTO qva_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Juan Bautistata carcilman wichrganganta mayarmi Galilea provinciaman Jesús aywaran. ");
INSERT INTO qva_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Chaychrüna Nazaret marcapita Capernaum marcaman tiyag aywacuran. Chay marcaga caran Galilea lamar cantun, Zabulón y Neftalí partichrümi. ");
INSERT INTO qva_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Chay cumpliycaran chaynuy cananpag willacognin Isaiaswan Tayta Diosninchi escribichingannuy: ");
INSERT INTO qva_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zabulonpa y Neftalïpa marcancunachru tiyag runacunata ali willapata willapäpäcuran. Chay marca caran lamar cantunchru, Jordán mayupa jucag cantunchru y mana Israel runacuna tiyangan Galilea provinciachru. ");
INSERT INTO qva_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Yananyaypa mana ricagnuy lutanta rurag runacuna achquita ricagnuypis Tayta Diosninchipa ali willacuyninta mayapäcuran. Mana cäsucogcunamanmi inti achicyangannuy Tayta Diosninchipa ali willacuynin chrayaran”. ");
INSERT INTO qva_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Chay wichanpitanam Jesús willacuyta galaycuran: “¡Juchayquicunapita wanacäriy y Tayta Dios munangannuy cawapäcuy! Tayta Diospa munayninchru canapag tiempo chrayaycämunnam”. ");
INSERT INTO qva_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesús Galilea lamar cantunpa aywaycanganchru ishcay wauguicunata ricaran. Paycuna caran Simón y wauguin Andrés. Simonpa jucag jutin caran Pedro. Paycuna pescacog carmi lamarman redninta mashtarcaran. ");
INSERT INTO qva_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Paycunata Jesús niran: “Discïpulü canayquipag nogawan puriy. Pescäduta charingayquinuy Tayta Diospag runacunata shuntanayquipag yachrachishayqui”. ");
INSERT INTO qva_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Chaynuy niptinmi rednincunata jaguiriycur jucla Jesuswan aywacäriran. ");
INSERT INTO qva_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Chaypita mas wac läduchrüna ishcay wauguicunata ricaran. Paycuna caran Zebedeupa wamran Santiago y Santiagupa wauguin Juan. Paycunaga taytan Zebedeuwan büquinchru rednincunata shilparcaran. Chauraga paycunatapis Jesús gayaran. ");
INSERT INTO qva_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Gayaptinmi paycunapis jucla büquita y taytanta jaguiriycur Jesuswan aywacäriran. ");
INSERT INTO qva_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Chaypitanam intëru Galilea provinciachru Jesús puriran. Paycunapa shuntacänan wasicunachru yachrachiran y Tayta Diospa munayninpita ali willacuyninta willacuran. Chaynuypis tucuy nirag gueshyawan gueshyaycagcunata cuticächiran. ");
INSERT INTO qva_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Siria nacion marcacunachrüpis musyacaran gueshyagcunata Jesús cuticächinganta. Chaymi Jesuscagman apapäcuran tucuy nirag gueshyacunawan gueshyagcunata, diablupa munayninchru caycag runacunata, wañupay gueshyawan y chrancan ricran macllucashacunata. Chay gueshyagcunata lapantam Jesús cuticächiran. ");
INSERT INTO qva_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Achca runacuna Galilea provinciapita, Decápolis marcacunapita, Jerusalenpita, Judea provinciapita, y Jordán mayupa jucag lädunpita Jesusta gatiräpäcuran. ");
INSERT INTO qva_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Chay achca runacunata ricarmi Jesús jegaran lömaman. Jamaycuptinmi chayman discïpuluncuna shuntacäpäcuran. Chaypitana paycunata caynuy yachrachiran: ");
INSERT INTO qva_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Cushisham cawarcan Tayta Dioslaman imaypis yäracog runacunaga. Paycunam Tayta Diospa munayninchru cawarcan. ");
INSERT INTO qva_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Cushisham cawanga laquicogcunaga. Paycunatam Tayta Dios shoganga mana laquicunanpag. ");
INSERT INTO qva_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Cushisham cawanga mana runatucuypa cawagcunaga. Paycunam Tayta Diospita herenciata chrasquinga. ");
INSERT INTO qva_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Cushisham cawanga micanaypanuyrag y yacunaypanuyrag Tayta Dios munangannuy cawayta munagcunaga. Paycunatam Tayta Dios chay munangannuy ali rurayta yanapanga. ");
INSERT INTO qva_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Cushisham cawanga runamasinta cuyapagcunaga. Paycunatam Tayta Dios cuyapanga. ");
INSERT INTO qva_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Cushisham cawanga Tayta Dios munangannuyla cawagcunaga. Paycunaga Tayta Diospa ñaupagninmanmi chrayanga. ");
INSERT INTO qva_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Cushisham cawanga runamasin jauca cawananpag ashegcunaga. Paycunataga Tayta Dios ‘Wamrämi canqui’ ninga. ");
INSERT INTO qva_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Cushisham cawarcan Tayta Diosninchi munangannuy cawanganpita rabyapasha cagcunaga. Paycunaga Tayta Diospa munayninchrümi cawarcan. ");
INSERT INTO qva_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Cushicäriy runacuna ashlishuptiqui, rabyapäshuptiqui noga janan casquicurcur manacagcunata jitapäshuptiqui. ");
INSERT INTO qva_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Cushicäriy, jauca capäcuy. Cieluchru pasaypa shumag alitam Tayta Diospita chrasquipäcunqui. Gamcunata rabyapäshungayquinuylam Tayta Diospa unay willacognincunatapis rabyapäpäcuran. ");
INSERT INTO qva_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Gamcuna lapan runapag cachrinuymi carcanqui. Rumi cachri puchgog caycanganpita gamyacarurga mananam yapay puchgog cayman ticrannachu. Chaynuy carga mananam imapäpis alinachu. Imapäpis mana ali captinna jitariycärin. Jitariptinna runacuna jaruchraypa ushan. ");
INSERT INTO qva_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Chaynuypis gamcuna lapan runapag achquinuymi carcanqui altunnin jircachru marca captin lapan runa ricangannuy. ");
INSERT INTO qva_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Achquita ratarcachir cajon rurinman manam pipis chruraycunchu. Chaypa truquinga wasichru lapan caycagcunata achicyänanpämi maymanpis ricacagninman chruran. ");
INSERT INTO qva_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Runacuna ricananpag achqui sindiraycangannuy gamcunapis runacuna ricacushunayquipag alilata rurar cawapäcuy. Chaynuy cagta ricarnam cieluchru Taytayquita paycunapis alabäpäcunga. ");
INSERT INTO qva_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ama gamcuna yarpäpäcuychu Moisés escribingan leycunata o Diospa willacognincuna escribingancunata illacächinäpag shamungäta. Chaypa truquinga noga shamushcä paycuna escribingannuy lapanta cumplinäpämi. ");
INSERT INTO qva_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Rasunpam gamcunata nï: Cielo y cay pacha cangancamaga Moisés y Tayta Diospa willacognincuna escribingan manam imalanpis trucachicangachu. Chaypa truquinga escribingannuylam lapanpis pasanga. ");
INSERT INTO qva_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Chaynuy caycaptinga chay escribingancunachru maygalantapis pipis mana cäsucur y runacunatapis chayta mana cäsucunanpag yachrachirga Tayta Diospa munayninchru cagcunapitaga payta mana alipag Tayta Dios ricanga. Ichanga chay escribingancunachru ningancunata cäsucur y runacunatapis cäsucunanpag yachrachirga Tayta Diospa munayninchru cagcunapitaga payta alipag Tayta Dios ricanga. ");
INSERT INTO qva_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Gamcunata nï: Fariseo runacuna y Moisés escribingan leycunata yachracheg runacunapitaga gamcuna masrag Tayta Dios munangannuy cawapäcuy. Chaynuy mana cawarga Tayta Diospa munayninchru imaypis manam capäcunquichu. ");
INSERT INTO qva_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Unay castayquicunata caynuy ninganta mayapäcushcanquim: ‘Ama runamasiquita wañuchinquichu. Runamasinta wañucheg cäga juzgasham canga’. ");
INSERT INTO qva_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ichanga noga gamcunata nï: Yäracogmasinta rabyapag cagtapis Dios juzgangam, yäracogmasinta ashleg cagtapis cortichrümi juezcuna juzganga y yäracogmasinta manacagman chrurag cagtapis infiernumanmi gaycunga. ");
INSERT INTO qva_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","“Chaymi Tayta Diospag ofrendata apangayquichru pï yäracogmasiquitapis lïtupasha cangayquita yarparga altar ñaupagninman chruraycur jucla cutiy chay yäracogmasiquiman perdunta mañanayquipag. Nircurna ayway ofrendayquita Tayta Diospag chruranayquipag. ");
INSERT INTO qva_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Pipis quejacushuptiquega autoridäman manarag chrayalar arregläpäcuy. Mana arreglaptiquega juezmanmi apachishunqui. Chauraga jueznam wardiacunawan carcilman wichrgachishunqui. ");
INSERT INTO qva_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Rasunpam gamcunata nï: Chaypitaga yargamunqui lapan jaganta shumag pägapacurir-rämi. ");
INSERT INTO qva_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Unay caynuy ninganta mayapäcushcanquim: ‘Majayog caycar majayquiwannuy jucwan ama puñucuychu’. ");
INSERT INTO qva_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ichanga noga gamcunata nï: Pipis majayog warmita ricar munapälarpis maynam yarpayninchru juchäcushana. ");
INSERT INTO qva_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Chaymi derëchacag ñawiqui juchäcachishuptiquega ogtirir jitariycuy. Mas ali caycan chaynuy ruranayqui infiernuman gaycusha canayquipa truquinga. ");
INSERT INTO qva_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Chaynuypis derëchacag maquiqui juchäcachishuptiquega rogurir jitariycuy. Mas ali caycan chaynuy ruranayqui infiernuman gaycusha canayquipa truquinga. ");
INSERT INTO qva_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Chaynuypis unay caynuy nisha caran: ‘Pipis warminwan raquicarga raquicaycangan papilta firmapächun raquicangan musyacänanpag’. ");
INSERT INTO qva_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ichanga noga gamcunata nï: Pipis warminpita jucwan mana caycaptin raquicarga warminta adulterio juchaman chrayananpämi chruraycan. Chaynuypis runapita raquicasha warmiwan pipis majachacurga runacagmi adulterio juchata ruraycan”. ");
INSERT INTO qva_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Chaynuypis unay castayquicunata caynuy ninganta mayapäcushcanquim: ‘Tayta Diospag imatapis ruranayquipag jurasha carga mana gongaypa cumpliy’. ");
INSERT INTO qva_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ichanga noga gamcunata nï: Yanga ama pipis jurachunchu. Chaynuypis ama jurapäcuychu cielupa jutinchru. Cieloga Tayta Dios jamaräcunanmi. ");
INSERT INTO qva_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ni cay pachapa jutinchru ama jurapäcuychu. Cay pachaga Tayta Diospa chraquin chruraräcunanmi. Ama jurapäcuychu Jerusalenpa jutinchru. Chay marcata Tayta Dios acrasha mandagpa marcan cananpämi. ");
INSERT INTO qva_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Chaynuypis ama umayquipa jutinchru jurapäcuychu. Gamcuna manam agchayquita juclaylatapis yanamanpis ni yuragmanpis ticrachiyta puedipäcunquichu. ");
INSERT INTO qva_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Chaymi ‘au’ nisha captiquega chaynuy cachun y ‘mana’ nisha captiquega chaynuy cachun. ‘Au’ o ‘mana’ ningayquipita juraytarag munaptiqui Satanaspitam chay yarpaycuna shamun. ");
INSERT INTO qva_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Unay caynuy ninganta mayapäcushcanquim: ‘Pipis jucpa ñawinta jorguptinga quiquinpa ñawintapis jorguchun. Chaynuy jucpa quirunta jorguptinpis quiquinpa quiruntapis jorguchun’. ");
INSERT INTO qva_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ichanga noga gamcunata nï: Mana alita rurashuptiquega gamga payta ama mana alita ruraychu. Derëchacag cärayquichru lagyashuptiquega jucag cärayquitapis camapay. ");
INSERT INTO qva_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Pipis demandacushuptiqui chaychru rurin röpayquita guechruyta munashuptiquega janancag röpayquitapis cachrapariy apacunanpag. ");
INSERT INTO qva_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Guepinta pulan lëwacama apachishuptiquega pulan lëwa masta apapanqui. ");
INSERT INTO qva_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Imalatapis pipis mañacushuptiqui goycunqui. Chaynuy pipis imalatapis ‘Mañaycalämay’ nir mañacushuptiqui mañaycunqui. ");
INSERT INTO qva_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Chaynuypis unay caynuy ninganta mayapäcushcanquim: ‘Runamasiquita cuyay y chriquishogniquita chriquiy’. ");
INSERT INTO qva_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ichanga noga gamcunata nï: Chriquishogniquicunata cuyapäcuy. Tayta Diosta rugacäriy rabyapäshogniquicunapag. ");
INSERT INTO qva_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Chaynuypa cieluchru Taytayquipa wamran cangayquim musyacanga. Paymi intinta yargachimun ali y mana ali runacunapag. Chaynuypis tamyachimun ali ruragcunapag y mana ali ruragcunapag. ");
INSERT INTO qva_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Cuyanacungalayquiwan cuyanacuptiquega imatapis manam Tayta Dios goshunquichu. Chaynuyga impuesto cobragcunapis cuyanacungalanwanga cuyanacärinmi. ");
INSERT INTO qva_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Gamcuna quiquiquipurala saludanacur ¿ima alitatag rurarcanqui? Tayta Diosman mana yäracog runacunapis chaynuylaga rurapäcunmi. ");
INSERT INTO qva_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","“Chaymi gamcunapis alilata rurapäcunayqui cieluchru Taytayqui ali rurag cangannuy. ");
INSERT INTO qva_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Runacuna ricanalanpäga Dios munangannuy ama ruraychu. Chaynuy rurapäcuptiquega cieluchru Taytayqui imatapis shumag alita manam gopäcushunquichu. ");
INSERT INTO qva_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Pobricunata yanaparga waquin runacunanuyga ama pï maytapis musyachipäcuychu. Chaynuyga runatucog runacunalam rurapäcun. Paycuna shuntacäpäcunan wasicunachru y cällicunachrüpis pobricunata yanapanganta musyachipäcun waquincuna payta alabänalanpag cashala. Rasunpam gamcunata nï: Chaynuy capäcunganpita runacuna alabangalanmi canga. ");
INSERT INTO qva_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Gamcuna ichanga pobricunata yanaparga ama pitapis willapanquichu. ");
INSERT INTO qva_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Pitapis mana willapaypa pobricunata yanapay. Pacaylapa yanapangayquita ricarmi Tayta Diosniqui premiuta gopäcushunqui. ");
INSERT INTO qva_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Runacuna ricanalanpämi waquin runacunaga runatucur ichricuycur Tayta Diosta rugacärin, shuntacäpäcunan wasicunachru y cälli esquïnacunachrüpis. Gamcunaga ama paycunanuy capäcuychu. Rasunpam gamcunata nï: Paycunapäga chaynuy ruranganpita runacuna alabangalanmi canga. ");
INSERT INTO qva_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Gamcuna ichanga pipis mana ricashunayquipag wasiquiman yaycuycur puncuyquita wichrgacurir pacaylapa caycag Tayta Diosniquita rugacuy. Pacaylapa rugacungayquita ricarmi Tayta Diosniqui premiuta gopäcushunqui. ");
INSERT INTO qva_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Tayta Diosta rugacurga yaparir yaparir waquin runacunanuyga ama chaylataga rimapäcunquichu. Chay runacuna yarpäpäcun yaparir yaparir niptinga Tayta Dios mas mayananpag canganta. ");
INSERT INTO qva_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Gamcuna ama chay runacunanuy capäcunquichu. Manaräpis rugacuptiquim Tayta Diosniqui mayna musyaycanna ima pishiycäshungayquitapis. ");
INSERT INTO qva_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Gamcunaga Tayta Diosta caynuy rugacäriy: Cieluchru caycag Tayta Diosnï, gamta lapan shumag ricayculäshunqui. ");
INSERT INTO qva_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Lapanpis gampa munayniquichru cawapäcuchun. Cieluchru munangayqui ruracangannuy cay pachachrüpis ruracayculächun. ");
INSERT INTO qva_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Canan junag micapäcunäpag goycärilämay. ");
INSERT INTO qva_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Mana ali ruramagnïcunata perdunäpäcungänuy juchäcungäcunapitapis perdunaycärilämay. ");
INSERT INTO qva_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Juchäcuyman ama cachrariycärilämaychu. Chaypa truquinga chapaycärilämay Satanás juchäcachipäcamänanpita. Gampa munayniquichrümi imaycapis imaypis caycan. Chaynuy imaycamapis alabasha cayculay. Amén. ");
INSERT INTO qva_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Mana ali rurashungayquicunapita runamasiquita perdunaptiquega cieluchru Taytayqui gamcunatapis perdunäshunquim. ");
INSERT INTO qva_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Runamasiquita juchäcungancunapita mana perdunaptiquega Taytayqui gamcunatapis juchäcungayquicunapita manam perdunäshunquichu. ");
INSERT INTO qva_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ayünuchru gamcuna carga runatucogcunanuyga ama laquisha cärayquiwan capäcuychu. Chay runacunaga laquisha cäranwan capäcun ayunaycanganta waquin runacuna musyapäcunanpämi. Rasunpam gamcunata nï: Chaynuy capäcunganpita runacuna alabangalanmi canga. ");
INSERT INTO qva_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Gamcuna ichanga cärayquita mayllacurir shumag alichacurir ");
INSERT INTO qva_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","runacuna mana musyananpag ayunäpäcuy. Chay ayunäpäcungayquitaga pacaylapa caycag Tayta Diosnilayquim musyanan. Pacaylapa caycag Tayta Diosniqui premiuta gopäcushunqui. ");
INSERT INTO qva_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Cay pachaman gamcunalapag riquësata ama shuntapäcuychu. Chaytaga puyum ushan, ismuypam ushacan y wasiman yaycurir suwacunam apacun. ");
INSERT INTO qva_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Chaypa truquinga alilata rurarmi cieluman riquësayquita chruracognuy carcanqui. Cieluchrüga manam puyupis ushangachu, ni ismungachu ni wasiman yaycurir suwacuna apacungachu. ");
INSERT INTO qva_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Imaycayquipis alicagcuna caycanganmanmi yarpayniqui imaypis caycan. ");
INSERT INTO qva_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ñawiqui achquinuymi cuerpuyquipag caycan. Chaynuy ñawiqui ali captinga achquinuymi intëru cuerpuyquipag caycan. Chaynuypa ricanqui alicaglata ruranayquipag. ");
INSERT INTO qva_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ichanga ñawiqui imatapis mana ricaptinga intëru cuerpuyqui yananyagchrünuymi caycan. Gamchru achqui mana captinga ¡fiyupa yananyagchrünuymi caycanqui! Chauraga alicagta ruranayquipag mana ricanquichu. Ichanga chay yananyagchrünuy imatapis mana ricangayquinuy lutanta rurar cawaptiqui mana ali cawaymanmi chrayanqui. ");
INSERT INTO qva_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Manam pipis ishcay patron mandanganta ruranmanchu. Ishcay patrunniyog carga jucnincagta cuyanga y jucnincagtana rabyapanga. Jucnincagta cäsur shumag ruranga y jucnincagtana mana alipag ricanga. Chaynuylam guellaylapag yarparagcunaga Tayta Dios mandanganta mana rurapäcunchu. ");
INSERT INTO qva_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Chauraga noga gamcunata nï: Ama yarpachracäriychu: ‘¿Imatarag micushag? ¿Imatarag upushag? ¿Imatarag jaticushag?’ nir. ¿Manachu mas välin cawayniqui micuypitaga y cuerpuyqui röpapitaga? ");
INSERT INTO qva_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ricapäcuy pishgucuna imanuy cawangantapis. Paycuna manam murucunchu, ni cosechanchu ni pirwacunchu. Chaynuy captinpis cieluchru Taytayquim micuyta camaripan. Chay pishgucunapitapis gamcunam mas välipäcunqui. ");
INSERT INTO qva_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mayjina yarpachracurpis wañuy chrayaycämuptin ¿pirag juc junaglapis mas cawanman? ");
INSERT INTO qva_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Chaynuy caycaptinga ¿imanirtag gamcuna röpayquipag yarpachracunqui? Tantiyacäriy chracrachru waytacuna imanuy wiñangantapis. Chaycuna manam arupäcunchu ni puchcacärinchu. ");
INSERT INTO qva_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Chaynuy captinpis noga gamcunata nï: Chay waytacuna cuyaylapag cangannuyga manam rey Salomonpis rïcu cayninwan jaticungan röpancunapis cuyaylapag cashachu. ");
INSERT INTO qva_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Chracrachru canan caycag guewacuna wara rupachisha cananpag captinpis Tayta Dios guewacunata shumagmi wiñachin. ¡Janan shongula yäracog runacuna! Chaynuy guewacunatapis shumag wiñaycächirga gamcunataga masrämi röpayquicunata tarichishunqui. ");
INSERT INTO qva_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Chaynuy caycaptinga ama yarpachracäriychu: ‘¿Imatarag micushag? ¿Imatarag upushag? ¿Imatarag jaticushag?’ nir. ");
INSERT INTO qva_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mana Israel runacunam yarpachracärin chaycuna lapan cananpag. Cieluchru Taytayquega musyanmi ima pishïshungayquitapis. ");
INSERT INTO qva_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Imapäpis yarpachracunayquipa truquinga Tayta Diospa munayninchru cawayta y pay munangannuy cawayta yarpachracäriy. Chaynuy cawaptiquega ima pishïshungayquitapis Tayta Dios tarichishunquim. ");
INSERT INTO qva_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Gamcuna ¿imanirtag warapag cagta yarpachracärinqui? Warapag cagta jaguiripäcuy. Waraga cangam yarpachracunayquipag. Cada junagmi imapis mana ali pasan. ");
INSERT INTO qva_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Runamasiquita ama juzgapäcuychu Tayta Diospis mana juzgashunayquipag. ");
INSERT INTO qva_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Gamcuna chaynuy captiquega Tayta Diospis waquincunata juzgapäcungayquinuymi juzgapäcushunqui. ");
INSERT INTO qva_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Imanirtag yäracogmasiquipa ñawinchru astïlla caycagta ricapanqui? ¿Manachu musyanqui gampa ñawiquichrüga cullu caycanganta? ");
INSERT INTO qva_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Gampa ñawiquichrüpis cullu caycaptinga yäracogmasiquita manam ninquimanchu: ‘Ñawiquichru caycag astïllata jorgapäshayqui’. ");
INSERT INTO qva_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Yachragtucog! ¡Puntataga ñawiquichru cullu caycagtarag jorguy! Chayrämi shumag ricanqui yäracogmasiquipa ñawinchru astïlla caycagta jorgunayquipag. ");
INSERT INTO qva_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Diospa cagta algucunata ama gopäcuychu. Cuydädu rabyar caniypa usharärishunquiman. Chaynuypis perlasniquicunata cuchicunata ama jitapäpäcuychu. Jitapäpäcuptiquega jaruchraypapis jaruchrarärinmanmi. ");
INSERT INTO qva_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Mañacäriptiqui Tayta Dios chrasquishunquim. Imatapis ashir taripäcunquim. Puncuta tacacuptiqui quichrapäshunquim. ");
INSERT INTO qva_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mañacogcäga chrasquin. Ashegcäga tarin. Puncuta tacacuptinga quichrapasham canga. ");
INSERT INTO qva_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Maygayquitapis wamrayqui tantata mañacushuptiqui ¿rumita gonquimanchurag? ");
INSERT INTO qva_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Chaynuypis pescäduta mañacushuptiqui ¿culebrata gonquimanchurag? ");
INSERT INTO qva_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mayjina fiyu carpis ¿manachu wamrayquicunata alicagta gopäcunqui? Gamcunapis wamrayquicunata chaynuy gorcaptiquega cieluchru Taytayqui mañacäriptiqui alicagcunata masrämi gopäcushunqui. ");
INSERT INTO qva_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Chaymi waquin runacunapag alita rurapäcunayqui waquin runacuna gamcunapag alita rurapäcunanpag munapäcungayquinuy. Chaynuy rurarmi Moisés escribingan leycunata y Diospa willacognincuna escribingancunata cäsucuycanqui. ");
INSERT INTO qva_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“Gamcunaga cieluman chrayanayquipag quichrqui puncu caycagpanuy yaycapäcuy. Chaynuymi cieluman chrayanapag camiñupis sasa caycan. Chay puncupaga walcaglam yaycunga. Ichanga infiernuman chrayanapag puncoga anchum caycan. Chaynuy camiñupis anchum caycan. Chay puncupaga achcagmi yaycunga. ");
INSERT INTO qva_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Cuydacäriy Diospa willacognintucular runacunapita. Chay runacunaga atognuy fiyu caycarpis manshu üshanuymi chrayapäshunquipag. ");
INSERT INTO qva_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Diospa willacognintucog canganta musyapäcunqui imatapis ruranganta ricarmi. Musyapäcungayquinuypis cashacunapita pipis üvasta manam palanchu. Ni hïgusta wallancapita cosechanchu. ");
INSERT INTO qva_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ali yüracunaga alitam wayun y mana ali yüracunaga mana alitam wayun. ");
INSERT INTO qva_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ali yüracunaga mana alita manam wayunchu y mana ali yüracunaga alitaga manam wayunchu. ");
INSERT INTO qva_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Chaymi mana ali wayog yürataga cuchurir rupachipäcun. ");
INSERT INTO qva_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Chaymi Diospa willacognintucog canganta musyapäcunqui imatapis ruranganta ricar. ");
INSERT INTO qva_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Manam ‘Señor Jesús, Señor Jesús’ nimagcuna lapanchu Tayta Diospa munayninman chrayapäcunga. Sinöga cieluchru caycag Tayta Diosnï munangannuy cawagcunalam chrayapäcunga. ");
INSERT INTO qva_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Juiciu final junäga achcagmi nimanga: ‘Señor Jesús, Señor Jesús, gampa munayniquiwanmi Dios musyachimanganta willacärirä. Gampa munayniquiwanmi diablucunata runapita gargurä. Chaynuypis gampa munayniquiwanmi milagrucunata rurarä’. ");
INSERT INTO qva_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Chaynuy nimaptinpis nogaga caynuymi nishag: ‘Gamcunata imaypis manam reguishcächu. ¡Ñaupagnïpita aywacäriy, mana ali rurag runacuna!’ ");
INSERT INTO qva_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Pipis noga ningäta mayar cäsucamagcäga shumag yarpachracog runa chagachru cimientuta shumag ruraycur wasita sharcachegnuymi caycan. ");
INSERT INTO qva_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Fiyupa tamyaptin achca yacu chrarpamuptinpis y wasiman fiyupa wayra wayraptinpis chaga jananman shumag rurasha cimientuyog wasega manam juchrungachu. ");
INSERT INTO qva_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pipis noga ningäta mayar mana cäsucamagcäga yarpayniynag runa aguysha janalanman cimientuta ruraycur wasita sharcachegnuymi caycan. ");
INSERT INTO qva_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Fiyupa tamyaptin achca yacu chrarpamuptin y fiyupa wasiman wayra wayraptin aguysha jananchru sharcachisha wasi juchruriycun. Chauraga lapan ushacäcun”. ");
INSERT INTO qva_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesús yachrachiyta usharcuptin lapan runa pasaypa almirasha carcaran. ");
INSERT INTO qva_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Pay yachracheg lapan munayninwan. Manam Moisés escribingan leycunata yachrachegcunanuychu yachrachiran. ");
INSERT INTO qva_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Lömachru yachrachinganpita Jesús yarpamuptinmi achca runacuna guepanta gatiräpäcamuran. ");
INSERT INTO qva_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Chauraga gueri gueshyawan gueshyaycag runa Jesuscagman ashuycur ñaupagninman gongurpacuycur rugacuran: “Munarga cay gueshyäpita cuticaycachilämay, tayta” nir. ");
INSERT INTO qva_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Chauraga Jesús yataycuran: “Au, munämi. Cuticashanam caycanqui” nir. Niptin chay höra chay runapa gueri gueshyan cuticaran. ");
INSERT INTO qva_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nircurmi Jesús niran: “Ama pitapis willapanquichu noga cuticächingäta. Chaypa truquinga cüraman ayway cuticashana cangayquita ricashunayquipag. Y Moisés escribinganchru ningannuy ofrendata apanqui gueshyayquipita cuticashana cangayquita lapan musyananpag”. ");
INSERT INTO qva_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Chaypita Capernaum marcaman Jesús chrayaptinmi romänu soldäducunapa capitannin Jesusman aywaycur rugacuran: ");
INSERT INTO qva_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Tayta, uywaynïmi pasaypa gueshyaycar wasïchru jitaraycan. Manana cuyucunnachu y fiyupa nacaycan”. ");
INSERT INTO qva_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Chauraga Jesús niran: “Aywashag cuticächinäpag”. ");
INSERT INTO qva_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Chaynuy niptinmi capitan niran: “Tayta, Israel runa mana caycaptïga gam nogapa wasïman manam yaycunquimanchu. Chaymi rugacü uywaynï cuticänanpag caylapita niycunayquita. ");
INSERT INTO qva_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Quiquïpis mandamagnïpa munayninchrümi caycä. Chaynuy soldädücunapis nogapa munaynïchrümi caycan. Maygantapis ‘Ayway’ niptïga aywan. Jucninta ‘Shamuy’ niptï shamun. Uywaynïtapis ‘Cayta ruray’ niptï ruran”. ");
INSERT INTO qva_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Capitan chaynuy niptinmi Jesús almirasha quëdaran. Chaymi gatiragnincunata niran: “Rasunpam gamcunata nï: Paynuy lapan shongunpa yäracamag runata Israel runacunachru manam pitapis tarishcächu. ");
INSERT INTO qva_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Noga gamcunata nï: Achcagmi mana Israel runacuna carpis Tayta Diospa munayninman shapäcamunga inti yargamunan lädupita inti yaycunan lädupita intëru mundupitam. Chaychrünam cieluchru Abrahamwan Isaacwan y Jacobwan igual micapäcungapag. ");
INSERT INTO qva_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ichanga waquin Israel runacuna carpis Tayta Diospa munayninman manam chrayapäcungachu. Paycunaga pasaypa yananyagmanmi gaycusha capäcunga. Chaychrünam pasaypa wagar laquicuypita quiruntapis cachrupäcunga”. ");
INSERT INTO qva_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nircurnam capitanta Jesús niran: “Wasiquipa cuticuy. Yäracamangayquipita uywayniqui cuticasha cachun”. Chay ningan höram capitanpa uywaynin cuticaran. ");
INSERT INTO qva_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pedrupa wasinman Jesús aywaran. Chaychrümi tariran Pedrupa suedran calintürawan cämanchru jitaraycagta. ");
INSERT INTO qva_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Chaymi gueshyagpa maquinta Jesús yataycuran. Chauraga chay höra calintüraycangan illacäcuran. Cuticarcurnam sharcuran payta garananpag. ");
INSERT INTO qva_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pacha chacaycaptinnam Jesusman achca runacunata diablucunapa munayninchru caycagta apapäcamuran. Chaychrümi chay runacunapita diablucunata Jesús juc shimilawan garguran. Chaynuy tucuy gueshyawan gueshyaycagcunatapis cuticächiran. ");
INSERT INTO qva_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Chaynuy pasaran willacognin Isaiaswan Tayta Dios escribichingannuymi. Chay escribingan caynuy caran: “Paymi gueshyanchita apacusha” nir. ");
INSERT INTO qva_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Achca runacuna muyupaycuptinmi discïpuluncunata Jesús niran lamarpa jucag chimpanman pasapäcunanpag. ");
INSERT INTO qva_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Pasananpag caycaptinmi Jesusman ashuycur Moisés escribingan leycunata yachracheg runa niran: “Maestro, maypa aywaptiquipis gamwan purishämi”. ");
INSERT INTO qva_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Niptinmi Jesús niran: “Atogcunaga machrayniyogmi. Pishgucunapis gueshtayogmi. Noga Diospita shamusha Runapäga manam canchu maychru chrachraycunaläpäpis”. ");
INSERT INTO qva_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Chaypitanam jucnincag discïpulun niran: “Tayta, gamwan purinanchipag puntata taytätarag pampaycamushag”. ");
INSERT INTO qva_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Chauraga Jesús niran: “Gam nogawan puriy. Wañushacunataga waquin wañogcagcuna pampacärichun”. ");
INSERT INTO qva_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nircurna Jesús büquiman jegaran. Guepantana discïpuluncunapis jegapäcuran. ");
INSERT INTO qva_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Lamarta chimparcaptinmi fiyupa wayra wayrämuran. Chauraga chay wayrawan lamar yacu wacman cayman ichririr büquita tallpucächinanpäna caycaran. Jesús ichanga puñuycaran. ");
INSERT INTO qva_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Chauraga discïpuluncuna Jesusta ricchachipäcuran: “¡Tayta, tallpucänanchipäna caycanchi! ¡Salvaycärimay!” ");
INSERT INTO qva_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Chauraga Jesús niran: “Janan shongula yäracog runacuna, ¿Imanirtag mancharipäcunqui?” Nircur Jesús sharcurcur wayratawan yacuta piñaparan. Piñaparuptin wayrapis yacupis pasaypa chrawaran. ");
INSERT INTO qva_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Chauraga discïpuluncuna almirasha quiquinpura caynuy ninacäriran: “¿Pirag payga asta wayrapis lamarpis cäsunanpag?” ");
INSERT INTO qva_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Lamarpa jucag lädunman discïpuluncunawan Jesús chrayapäcuran. Chay caycaran Gadara partichru. Chaychrüna panteunpita ishcay runacuna yargapäcamuran. Chay runacuna diablucunapa munayninchru caycaran. Paycuna pasaypa manchacuypag captinmi pipis chay camiñupa mana pasaranchu. ");
INSERT INTO qva_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Chaymi chay ishcay runacuna fiyupa gaparaypa nipäcuran: “Diospa Wamran, ¿imatatag nogacunawan munanqui? ¿Manaräpis juiciu final captin nacachipäcamänayquipächu cayman shamushcanqui?” ");
INSERT INTO qva_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Paycuna caycanganpita mas wac lädunchrümi achca cuchicuna micurcaran. ");
INSERT INTO qva_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Chaymi diablucuna Jesusta rugacuran: “Cay runacunapita gargapäcamarga tagay cuchicunaman yaycunäpag cachrapaycalämay” nir. ");
INSERT INTO qva_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Chaynuy rugacuptin Jesús niran: “¡Aywacäriy!” Chauraga diablucuna runacunapita yargurcur yaycacaycäriran chay cuchicunaman. Chaymi chay cuchicunaga tunapa cörrir lamarman jegarpacaycäriran. Chaychrümi shengaypa cuchicuna wañupäcuran. ");
INSERT INTO qva_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Chayta ricaycurmi cuchi michegcunaga cörrila aywaran marcaman runacunata willananpag. Chrayaycurnam diablucunapa munayninchru cangan runacunawan y cuchicunawan ima pasangantapis willapäcuran. ");
INSERT INTO qva_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Willapäcuptinmi marcapita runacuna Jesusta ricapäcunanpag shapäcamuran. Chaychrüna Jesusta rugacäriran chaypita aywacunanpag. ");
INSERT INTO qva_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Chaypitanam büquiman Jesús jegaran. Nircurnam chay lamarpa pasaran jucag lädunchru marca caycagman. Chay caran tiyaycangan marca. ");
INSERT INTO qva_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Chaychrümi pulan cuerpun wañusha runata quirmawan Jesuscagman apapäcuran. Paycuna yäracäringanta tantiyarmi chay gueshyagta Jesús niran: “Ama manchariychu, hïju. Juchayquicunapita perdunashanam caycanqui”. ");
INSERT INTO qva_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Chaynuy niptinmi Moisés escribingan leycunata yachrachegcuna yarpachracäriran: “¡Chaynuy rimarga Tayta Diosta apärir rimaycan!” ");
INSERT INTO qva_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Chaynuy yarparcanganta tantiyarmi Jesús tapuran: “¿Imanirtag gamcuna lutanta yarparcanqui? ");
INSERT INTO qva_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Maygantag mas fäcil ninapag? ¿‘Juchayquicunapita perdunashanam canqui’ niychu o ‘Sharcuy. Puriy’ niychu? ");
INSERT INTO qva_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Canan musyachishayqui runata juchancunapita perdunänäpag noga Diospita shamusha Runa cay pachachru munayniyog cangäta”. Nircur pulan cuerpun wañusha runata niran: “¡Sharcuy! Quirmayquita apacurcur wasiquipa aywacuy”. ");
INSERT INTO qva_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Chaynuy niptinmi chay runa sharcurcur wasinpa aywacuran. ");
INSERT INTO qva_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Chayta ricarmi runacuna mancharisha Tayta Diosta alabaran runacunata chay munayninta gonganpita. ");
INSERT INTO qva_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Chaypita Jesús aywacur ricaran Mateo jutiyog runata Romapag impuestuta cobracunanchru jamaraycagta. Chaymi payta niran: “Discïpulü canayquipag nogawan aywashun”. Chauraga Mateo sharcurcur Jesuswan aywaran. ");
INSERT INTO qva_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Chaypita Mateupa wasinchrüna Jesús micuycaptin impuestuta cobrag runacuna y mana alipag ricasha runacunapis chrayaycur Jesuswanpis discïpuluncunawanpis jamacäriran. ");
INSERT INTO qva_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Chayta ricarmi fariseo runacuna Jesuspa discïpuluncunata tapuran: “¿Imanirtag impuesto cobragcunawan y mana alipag ricasha runacunawanpis maestruyqui micuycan?” ");
INSERT INTO qva_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Chaynuy ninganta mayarmi Jesús niran: “Sänu cagcunaga jampicogta manam munanchu sinöga gueshyagcunam. ");
INSERT INTO qva_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Tayta Dios escribichinganchru ninganta yachracärimuy: ‘Nogapag uywacunata pishtapäcungayquipitapis cuyapäcog capäcunayquitam mas munä’. Noga ali ruragcunata shuntanäpächu manam shamushcä, sinöga juchayogcunata shuntanäpämi shamushcä”. ");
INSERT INTO qva_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Juan Bautistapa discïpuluncuna Jesuscagman ashuycur tapupäcuran: “Nogacunapis y fariseo runacunapis ayunäpäcümi. ¿Imanirtag discïpuluyquicunaga mana ayunanchu?” ");
INSERT INTO qva_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Chaynuy tapuptinmi Jesús niran: “Casaracuyman gayachingancagcuna ¿laquishachurag canman chaychru casaracog caycaptinga? Chrayamungam höra casaracog runata apacunanpag. Chay apacuptin ichanga ayunäpäcunga. ");
INSERT INTO qva_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Manam pipis macwa röpata mushog träpuwan remendanchu. Träpoga guentir masmi macwa röpata rachricächin. ");
INSERT INTO qva_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Chaynuy manam pipis chayrag rurasha vïnuta auquisyasha ordiman wiñanchu. Auquisyasha ordiman wiñaptinga vïno pogur chay ordita pashtariycachinga. Chauraga vïnupis jichracäcunga y ordipis ushacäcunga. Chaymi mushog ordiman chayrag rurasha vïnuta wiñan. Chaynuypa ishcanpis ali quëdanga”. ");
INSERT INTO qva_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Chaynuy parlaycaptinmi autoridä chrayaycur Jesuspa ñaupagninman gongurpacuycur niran: “Warmi wamrämi chayrag wañurun, tayta. Paycagman aywaycur yataycuptiquega cawarimungam”. ");
INSERT INTO qva_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Chauraga jamaraycanganpita sharcurcur discïpuluncunawan y chay runawan Jesús aywaran. ");
INSERT INTO qva_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Aywarcaptinmi chrunca ishcay (12) wata yawar apaywan gueshyaycag warmi guepalanpa yaycuycur Jesuspa röpanpa cantunta yataycuran. ");
INSERT INTO qva_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Chaynuy ruraran “Jesuspa röpanta yataycularpis cuticäshämi” nir. ");
INSERT INTO qva_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yataycuptinmi ticraycur Jesús ricaran warmita. Chauraga niran: “Ama manchariychu, hïja. Yäracuyniquipam cuticashana caycanqui”. Chay höra chay warmi cuticasha caran. ");
INSERT INTO qva_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Chay autoridäpa wasinman Jesús chrayar taripäcuran müsicucuna carcagta y runacunapis fiyupa wagarcagta. ");
INSERT INTO qva_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Chauraga Jesús niran: “Puncuta yargacäriy. Wamra manam wañushachu caycan, sinöga puñucashalam caycan”. Jesús chaynuy ninganta mayar runacuna asicäriran. ");
INSERT INTO qva_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Puncuman lapan runacunata yargamunanpag niran. Chaypitana yaycuycur wamra chutaraycagpa maquinta yataycuran. Yataycuptinna wamra sharcamuran. ");
INSERT INTO qva_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Chaynuy cawarichingan willapa chay partichru cag lapan marcacunaman chrayaran. ");
INSERT INTO qva_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Chaypita aywacamuptinna Jesusta ishcay gapracuna gayaraycar gatiräpäcamuran: “¡Rey Davidpa ayllun, cuyapaycärilämay!” nir. ");
INSERT INTO qva_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Wasiman yaycuriptinnam chay gapracuna Jesuscagman ashuycäriran. Chauraga Jesús tapuran: “¿Criyipäcunquichu noga ñawiquicunata cuticächinäta?” “Au, tayta” nipäcuran. ");
INSERT INTO qva_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Chauraga Jesús gapracunapa ñawincunata yataycur niran: “Yäracamangayquipita ñawiqui cuticasha cachun”. ");
INSERT INTO qva_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Chaynuy niptinmi ñawin cuticaran. Chaypita piñapaypa Jesús niran: “Pitapis ama willapäpäcunquichu cuticächingäta”. ");
INSERT INTO qva_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Chaynuy niycaptinpis Jesús cuticächinganta chay partichru tiyagcunata pï maytapis willaparan. ");
INSERT INTO qva_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Chay gapracuna aywacurcaptinnam rimayta mana puedeg runata Jesuscagman pushapäcamuran. Chay runa diablupa munayninchru captinmi diablo müduyächisha casha. ");
INSERT INTO qva_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Müduyasha runapita diabluta Jesús garguruptin chay runa rimayta galaycuranna. Chayta ricarmi runacuna almirasha nipäcuran: “¡Manam imaypis Israel naciunchru caynuy ruragta ricarunchichu!” ");
INSERT INTO qva_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Fariseo runacunam ichanga nipäcuran: “Diablucunapa quiquin mandagninmi munayninta gosha diablucunata gargunanpag”. ");
INSERT INTO qva_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Chaypitanam achca marcacunapa shuntacänan wasicunaman chrayaran. Chaychrüna Tayta Diospa munayninpita ali willacuyta Jesús yachrachiran. Chaynuypis tucuy nirag gueshyawan gueshyaycagcunata cuticächiran. ");
INSERT INTO qva_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Chay runacuna pasaypa laquisha yarpachracular y ima ruraytapis mana puedir michegniynag üshanuy capäcuran. Chaynuy cagta ricarmi Jesús pasaypa laquicuran. ");
INSERT INTO qva_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Chaymi discïpuluncunata niran: “Cosëcha poguraycangannuymi Tayta Diospa willacuyninta chrasquicunanpag achca runacuna caycan. Chaynuy captinpis arogcuna walcagla cangannuy walcagla ali willacuyta willacogcunaga carcan. ");
INSERT INTO qva_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Chaymi cosëchapa dueñunta achca arogcunata cachramunanpag mañacognuy Tayta Diosta rugacärinayqui achca runacunata cachramunanpag ali willacuyta willacunanpag”. ");
INSERT INTO qva_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Chaypitanam Jesús chrunca ishcay (12) discïpuluncunata gayaycur munayninta goran runacunapita diablucunata gargunanpag y tucuy nirag gueshyacunawan gueshyaycagcunata cuticächinanpag. ");
INSERT INTO qva_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Chay chrunca ishcay (12) apostulcunapa jutincuna carcan: Simón (paypa jucag jutinmi caran Pedro), Simonpa wauguin Andrés, Zebedeupa wamran Santiago y wauguin Juan, ");
INSERT INTO qva_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, Mateo (payga Roma naciunpag impuestuta cobragmi caran), Alfeupa wamran Santiago, Tadeo, ");
INSERT INTO qva_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","“Celote” jutiyog Simón y Jesusta entregag Judas Iscariote. ");
INSERT INTO qva_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Chay chrunca ishcay discïpuluncunata cachrarmi Jesús caynuy paycunata niran: “Ama aywanquichu mana Israel runacunapa marcancunamanga, ni yaycapäcunquichu Samaria provinciachru caycag marcacunamanga. ");
INSERT INTO qva_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Chaypa truquinga aywapäcuy ogracasha üshanuypis Israel runacuna caycanganman. ");
INSERT INTO qva_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Aywaycur willapäcamuy Tayta Diospa munayninchru canapag tiempo chrayaycämungantana. ");
INSERT INTO qva_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Gueshyagcunata cuticächinqui. Wañushacunatapis cawarichimunqui. Gueri gueshyawan gueshyaycagcunatapis cuticächinqui. Runacunapita diablucunata gargunqui. Mana cobraypam gamcunata munaynïta goshcä. Chaymi pitapis mana cobrapäcunayquichu. ");
INSERT INTO qva_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Ama guellayta apapäcuychu. ");
INSERT INTO qva_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Chaynuypis ama mircapacäriychu y trucacunayquipag röpayquita ama apapäcuychu. Chaynuypis juc masta llanquiquita ni tucapiquitapis ama apapäcuychu. Arupacog runaga arunganpita micuyta chrasquinmi. ");
INSERT INTO qva_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“May marcaman chrayarpis ali runata ashipäcunqui. Nircurna chay runapa wasilanchru chaypita aywacäringayquicama pacharäpäcunqui. ");
INSERT INTO qva_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Chay runapa wasinman chrayar shumag saludacärinqui jauca cawapäcunanpag. ");
INSERT INTO qva_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ali chrasquishuptiquega nipäcungayquinuymi paypag jauca caway canga. Mana chrasquishuptiqui ichanga chay wasiyog cangannuylam canga. ");
INSERT INTO qva_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Chay runacuna gamtapis o willapangayquitapis mana chrasquishuptiquega chay wasipita o chay marcapita chraquiquichru lagacasha polvuta tapshirir aywacärinqui. ");
INSERT INTO qva_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Rasunpam gamcunata nï: Juiciu final junäga Sodoma y Gomorra marca runacuna castigasha canganpitapis chay marcachru tiyag runacuna mas fiyupam castigasha canga. ");
INSERT INTO qva_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ricapäcuy, gamcunata üshacunata atogman gaycognuymi cachraycä. Chaymi gamcuna culebranuypis mayag mayagla capäcunayqui y manshu palumanuypis umildi capäcunayqui. ");
INSERT INTO qva_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Cuydacärinqui runacunapita; Israel runacunapa autoridänincunamanmi apapäcushunqui y shuntacänan wasincunachrümi astipäcushunqui. ");
INSERT INTO qva_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nogapa janan gobernadurcunamanpis y reycunamanpis apapäcushunquim juzgasha canayquipag. Chaychrünam paycunapa ñaupagninchru y waquin mana Israel runacunapa ñaupagninchru nogapita willacärinqui. ");
INSERT INTO qva_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Autoridäcunaman apapäcushuptiquipis ama yarpachracärinquichu imata nipäcunayquipag ni imanaypa nipäcunayquipäpis. Nipäcunayqui höra chrayamuptin Tayta Diosmi imata nipäcunayquipäpis musyachishunqui. ");
INSERT INTO qva_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Quiquiquicunachu manam rimapäcunqui sinöga Tayta Diosniqui cachramungan Santu Espiritum gamcuna rimaycangayquinuypis parlanga. ");
INSERT INTO qva_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Wauguinmi jucag wauguinta wañuchinanpag entreganga. Taytannam wamranta entreganga. Wamrancunam taytanpa mamanpa contran sharcur entreganga wañuchisha cananpag. ");
INSERT INTO qva_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Noga janan lapan runacunam gamcunata chriquipäcushunqui. Ichanga wañungancama mana yamacaypa yäracamagcagmi salvacunga. ");
INSERT INTO qva_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Juc marcachru rabyapäshuptiquega juc marcaman gueshpicärinqui. Rasunpam gamcunata nï: Manarag lapan Israel naciunchru cag marcacunapa purimuptiquim noga Diospita shamusha Runa cutimushag. ");
INSERT INTO qva_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Manam maygan discïpulupis maestrunpita mas canchu. Uywaypis uywagnin runapita mas manam canchu. ");
INSERT INTO qva_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Discïpuloga maestrun canganmannuy chrayayta yarpangan alim. Uywaypis uywagnin canganmannuy chrayayta yarpangan alim. Chaymi wasiyognuy caycaptïpis chriquimar ‘Satanasmi payga’ niycamarga gamcuna castänuy caycagta chriquir imatarag nipäcushunqui. ");
INSERT INTO qva_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Runacunata ama manchacäriychu. Mana musyasha cagcunapis musyacangam y pacarasha cagcunapis musyacangam. ");
INSERT INTO qva_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Chaynuymi gamcunata pacaypa parlapäcungäcunatapis lapanta willacunqui. Puertata wichrgarcur pacaylapa parlapäcungätapis may chaychrüpis willacunqui. ");
INSERT INTO qva_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ama manchacärinquichu wañuchicog runacunata. Chay runacuna wañuchicog carpis espiritutaga manam wañuchingachu. Chaypa truquinga Tayta Diosta manchapacäriy. Paymi munayniyog caycan espirituntinta pitapis infiernuman gaycunanpag. ");
INSERT INTO qva_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Runacuna ishcay pishgucunata walca guellaylachru ranticärin. Mana cuestaptinpis Tayta Diosniqui mana munaptinga juclaylapis pampaman manam ishquinchu. Pishgucunatapis chaynuy ricaycarga gamcunataga masrämi Tayta Dios ricaycäshunqui. ");
INSERT INTO qva_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Chaynuypis paypäga agchayquicunapis yupashalam caycan. ");
INSERT INTO qva_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Chaymi gamcuna mana manchacärinayquichu. Gamcuna achca pishgucunapitapis masmi välipäcunqui. ");
INSERT INTO qva_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Runacunapa ñaupagninchru pipis nogaman yäracunganta willacuptinga nogapis cieluchru caycag Taytäpa ñaupagninchru paypa favurninmi sharcushag. ");
INSERT INTO qva_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ichanga runacunapa ñaupagninchru pipis nogaman yäracamanganta niegamaptin nogapis cieluchru caycag Taytäpa ñaupagninchru niegashämi. ");
INSERT INTO qva_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ama yarpäpäcuychu cay pachachru runacuna jauca cawananpag shamungäta. Chaypa truquinga chriquinacuy cananpämi shamushcä. ");
INSERT INTO qva_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Noga shamushcä olgu wamra taytanpa contran sharcunanpämi, warmi wamran mamanpa contran sharcunanpämi, lumchuynin suedranpa contran sharcunanpämi. ");
INSERT INTO qva_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Chaymi juc wasichru quiquinpurala contranacäringa. ");
INSERT INTO qva_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Nogata cuyamanganpita mas taytanta o mamanta cuyarga manam discïpulü canmanchu. Nogata cuyamanganpita mas olgu wamrancunata o warmi wamrancunata cuyarga manam discïpulü canmanchu. ");
INSERT INTO qva_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Wañunan captinpis noga munangänuyla mana cawarga discïpulü manam canmanchu. ");
INSERT INTO qva_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Noga janan wañuyta manchacogcäga mana ushacaypa cawayta manam taringachu. Noga janan wañogcagmi ichanga mana ushacaypa cawayta taringa. ");
INSERT INTO qva_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Gamcunata chrasquirga nogatam chrasquiycäman. Chaynuypis nogata chrasquimagcäga cachramag Taytätam chrasquiycan. ");
INSERT INTO qva_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Pipis juc runata Tayta Diospa willacognin caycaptin chrasquirga willacog premiuta chrasquingannuymi paypis chrasquinga. Chaynuypis juc runata Tayta Dios munangannuy cawaycaptin chrasquirga chay runa premiuta chrasquingannuymi chrasqueg runapis premiuta chrasquinga. ");
INSERT INTO qva_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Rasunpam gamcunata nï: Discïpulü canganpita juc pusillu yaculatapis pipis chacyarga paypis premiuntam chrasquinga”. ");
INSERT INTO qva_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Chrunca ishcay (12) discïpuluncunata Jesús yachrachiyta usharcurna chay partichru caycag marcacunapa aywaran Tayta Diospa willacuyninta willacunanpag y yachrachinanpag. ");
INSERT INTO qva_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Carcilchru caycarmi Juan Bautista mayaran milagrucunata Dios cachramungan Salvador ruraycanganta y Tayta Diosninchipa willacuyninta willacuycanganta. Chaymi discïpuluncunata cachraran ");
INSERT INTO qva_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","tapumunanpag: “¿Gamchu caycanqui Tayta Dios cachramungan Salvador, o juctarächu shuwaräpäcushag?” nir. ");
INSERT INTO qva_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tapuptinmi Jesús niran: “Cutipäcuy y Juanta willapäcuy ricarcangayquita y mayarcangayquita. ");
INSERT INTO qva_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Gapracuna ricannam. Wegrucuna purinnam. Gueri gueshyawan gueshyaycagcuna cuticashanam. Upacuna mayannam. Wañushacuna cawarimusham. Pobricunapis Tayta Diospa ali willacuyninta mayaycannam. ");
INSERT INTO qva_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Cushisham carcan mana cachrariypa nogaman yäracamar cawagcunaga”. ");
INSERT INTO qva_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Juan cachramungancuna cuticaräriptinmi runacunata Juanpita Jesús niran: “¿Chunyag jircaman imata ricagta aywapäcurayqui? ¿Segsita wayra cuyuchegta ricanayquipächu aywapäcurayqui? ");
INSERT INTO qva_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Chauraga ¿imata ricapäcunayquipätag aywapäcurayqui? ¿Fïnu röpan jatisha runata ricanayquipächu? Fïnu röpan jatisha runacunaga reycunapa wasincunalachrümi carcan. ");
INSERT INTO qva_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Chauraga ¿imata ricapäcunayquipätag aywapäcurayqui? ¿Diospa willacogninta ricapäcunayquipächu aywapäcurayqui? Gamcunata nï: Au. Tayta Diospa mas alinnincag willacogninta ricapäcunayquipämi aywapäcurayqui. ");
INSERT INTO qva_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juanpag Tayta Dios escribichinganchru nogapag niran: ‘Gampa puntayquita willacognïtam cachrashag camiñuta alichagnuypis runacunata gampag camaricachinanpag’. ");
INSERT INTO qva_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Rasunpam gamcunata nï: Lapan runacunapita Juanmi mas alinnincag. Chaynuy captinpis Tayta Diospa munayninchru lapancagcunam Juanpita mas ali caycan. ");
INSERT INTO qva_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","“Tayta Diospa willacognincuna, Moisés y Juan Bautista willacäriran Tayta Dios munayninchru charämänanchipag canganta. Juan Bautista willacunganpita pacha canancama Tayta Diospa munaynin maymanpis shumag chrayaycan. Chaynuy captinpis fiyu runacunaga manam munapäcunchu Tayta Diospa munaynin chrayananta. Chaypa truquinga imaycanuypapis illacächiyta munarcan. ");
INSERT INTO qva_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Elías shamunanpag canganta Diospa unay willacognin escribiran. Gamcuna chaynuy canganta chrasquicäriptiquega Juanmi shamuran escribirangan cumplinanpag. ");
INSERT INTO qva_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","¡Ningäta mayag cäga shumag tantiyacäriy! ");
INSERT INTO qva_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“¿Imamantag canan tiempo runata tincuchïman? Cay runacuna caycan pläzachru puclananpag jamarar waquin wamracunata caynuy gayarag wamracunanuymi: ");
INSERT INTO qva_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Majachacuy fiestata puclar tucapäcuptïpis manam dansapäcushcanquichu. Aya pampayta puclar cantacunata cantapäcuptïpis manam wagapäcushcanquichu’. ");
INSERT INTO qva_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Juan mana micuptin mana upuptin ‘Diablupa munayninchrümi payga caycan’ nipäcun. ");
INSERT INTO qva_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Noga Diospita shamusha Runa micuptï y vïnuta upuptï ‘Ricapäcuy, micuylapag upyaylapag caycan’ nipäcun. Chaynuypis ‘Juchasapa runacunawan y Romapag impuesto cobragcunawan puricog’ nipäcun. Ichanga Tayta Dios rasunpa yachrag cangan musyacan runacuna alita rurapäcuptin y pay munangannuy cawapäcuptinmi”. ");
INSERT INTO qva_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Mas milagrucunata rurangan marcacunachru tiyag runacunata juchancunapita mana wanacäringanpita Jesús piñaparan: ");
INSERT INTO qva_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“¡Cuyapaypämi capäcunqui, Corazín marcachru y Betsaida marcachru tiyag runacuna! Gamcunachru milagrucunata rurangänuy Tiro y Sidón marcacunachru milagrucunata ruraptïga maynam juchancunapita wanacurir Tayta Diosman yäracärinman caran. Juchancunata wanacäringan musyacänanpag cotenciapita rurasha röpata jaticurcur uchrpata maynam gaycacärinman caran. ");
INSERT INTO qva_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ichanga gamcunata nï: Juiciu final junäga Tiro y Sidón marca runacuna castigasha canganpitapis mas fiyupam castigasha capäcunqui. ");
INSERT INTO qva_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Capernaum marcachru tiyag runacuna, ¿gamcunaga Tayta Diospa ñaupagninman chrayaytachu yarparcanqui? Chaypa truquinga wañushacuna canganmanmi gaycusham capäcunqui. Gamcunachru milagrucunata rurangänuy Sodoma marcachru ruraptïga chaychru runacuna juchancunata jaguirinmanmi caran. Chaynuy ruraptin chay marca canancamam caycanman caran. ");
INSERT INTO qva_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ichanga gamcunata nï: Juiciu final junäga Sodoma partichru tiyag runacuna castigasha canganpita mas fiyupam castigasha capäcunqui”. ");
INSERT INTO qva_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Chay wichan Tayta Diosninchita Jesús niran: “Cieluchrüpis y cay pachachrüpis munayniyog caycag Taytä, gamta alabä pacarächingayquicunata yachragcunata manam musyachingayquipitam. Chaypa truquinga mana yachragcunatam musyachishcanqui. ");
INSERT INTO qva_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tayta, chaynuy cananta gammi munashcanqui”. ");
INSERT INTO qva_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Chaynuypis Jesús niran: “Taytämi lapantapis munaynïman chruramusha. Noga imanuy cangätapis shumäga Taytalämi musyan. Chaynuy pay imanuy cangantapis nogala shumag musyä y musyachingäcagcunalam musyapäcun”. ");
INSERT INTO qva_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Nogaman shapäcamuy fiyupa arur y lasag guepita apar uticashanuy caycagcuna. Nogam gamcunata jamachipäcushayqui. ");
INSERT INTO qva_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Töru arunanpag yüguta chrurapagnuymi gamcunata nogapa yachrachicuynïcunata yachraycächiy. Noga manshu uywanuymi cä y mana runatucogmi cä. Chaynuy carga jamayta taripäcunquim. ");
INSERT INTO qva_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Töruta yüguta chrurapagnuypis y guepita apanayquipag guepipagnuypis yachrachicuynïcunata yachracunayquipag manam sasachu”. ");
INSERT INTO qva_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Chay wichanmi sábado jamay junagchru trïgucuna cangan chracracunapa discïpuluncunawan Jesús pasarcaran. Chaymi discïpuluncunaga micanar trïguta palarir micapäcuran. ");
INSERT INTO qva_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Chaynuy ruranganta ricarmi fariseo runacuna Jesusta niran: “¡Ricay! Discïpuluyquicuna leycunata mana cäsucur sábado jamay junagchru trïguta palarcan”. ");
INSERT INTO qva_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Chauraga Jesús niran: “¿Gamcuna manachu liyipäcushcanqui juc cutinchru David yanagagnincunawan micanar pay imata rurangantapis? ");
INSERT INTO qva_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Pay Tayta Diosta mañacuna wasiman yaycuran. Nircurna yanagagnincunawan pay Tayta Diospag chruraraycag tantacunata micapäcuran. Chaynuy micapäcuran Moisés escribingan leycunachru chay tantacuna cüracunala micapäcunanpag caycaptinpis. ");
INSERT INTO qva_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Chaynuypis Moisés escribingan leycunachru niycan sabaduchru mana jamaycarpis templuchru cüracuna rurangancuna jucha mana canganta. ");
INSERT INTO qva_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Gamcunata nï: Templupita mas alicag caychru caycan. ");
INSERT INTO qva_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Gamcunaga manam tantiyanquichu Tayta Dios escribichinganchru ima ningantapis. Chayga niycan: ‘Nogapag uywacunata pishtapäcungayquipitapis cuyapäcog capäcunayquitam mas munä’. Chay escribiranganchru ima ningantapis tantiyarga mana juchäcog runata ama tumpanquimanchu caran juchayog canganta. ");
INSERT INTO qva_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Noga Diospita shamusha Runa munayniyog caycä sábado jamay junagchru runa rurananpag mana rurananpag cangantapis ninäpag”. ");
INSERT INTO qva_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Chaypita Jesús aywacur yaycuran chay marcachru shuntacäpäcunan wasiman. ");
INSERT INTO qva_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Chaychrümi macllucasha maquiyog runa canag. Chaymi fariseo runacuna “Leycunata mana cäsunchu” nipäcunanpag Jesusta tapupäcuran: “¿Leycuna ningannuy alichu canman sábado jamay junagchru gueshyaycag runata cuticächiy?” ");
INSERT INTO qva_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Chauraga Jesús niran: “Maygayquipapis sábado jamay junagchru üshayqui pözuman jegarpuptin ¿manachu jorgog aywanqui? ");
INSERT INTO qva_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿Manachu runacunaga mas välin üshapitapis? Chaynuy caycaptinga sábado jamay junagchru leycuna ningannuy alicagta ruranapag alim caycan”. ");
INSERT INTO qva_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nircur chay gueshyaycag runata niran: “¡Maquiquita mashtay!” Mashtariptinna jucag maquinnuy sänu ricacuran. ");
INSERT INTO qva_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Chay fariseo runacuna chay caycanganpita yargurirna Jesusta wañuchipäcunanpag rimanacäriran. ");
INSERT INTO qva_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Chauraga chaynuy yarpäpäcunganta musyaycur caycanganpita Jesús aywacuran. Aywacuptin achca runacuna guepanpa aywapäcuran. Chay runacunachru gueshyag captinga lapanta cuticächiran. ");
INSERT INTO qva_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Cuticarcachirna Jesús niran pitapis mana willapänanpag. ");
INSERT INTO qva_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Caynuy pasaycaran willacognin Isaiaswan Tayta Dios nichingannuymi: ");
INSERT INTO qva_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Caychrünam caycan mandangäta ruragnï. Paytam noga acrashcä. Cuyaynï captinmi paypita cushicü. Santu Espiritü paychrümi canga. Paymi may chay naciuncunachrüpis salvanäpag cagpita willacunga. ");
INSERT INTO qva_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Payga manam piwanpis lïtungachu ni gaparangachu. Chaynuypis cällicunachru gaparar manam puringachu. ");
INSERT INTO qva_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Runacuna, paquinaycag carrïsunuy caycagta pasaypa mana paquinanpag ricangannuymi paypis shumag cuydanga chay runacunata. Chaynuypis upinaycag michëruta mana upinanpag ricangannuymi paypis ricanga chay runacunata. Chaynuy canga salvananpag cagta runacuna tantiyacungancama. ");
INSERT INTO qva_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Chaynuypam may chay nacion runacunapis payman yäracäringa salvacärinanpag”. ");
INSERT INTO qva_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Chaypita gapra y rimayta mana puedeg runata Jesuscagman pushapäcamuran. Chay runa diablupa munayninchru caycaptin diablo gaprayächisha y müduyächisha casha. Chrayachiptinna ñawinta y shimintapis Jesús cuticächiran. Chauraga alina ricaran y rimaran. ");
INSERT INTO qva_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Chaynuy cuticächegta ricarmi runacuna almirasha nipäcuran: “¿Manachurag pay aywamunanpag cagta shuwaraycanganchi rey Davidpa ayllun?” ");
INSERT INTO qva_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Chayta mayar fariseo runacuna Jesuspag nipäcuran: “Tagay runata diablucunapa mandagnin Satanasmi munayninta gosha runacunapita diablucunata gargunanpag”. ");
INSERT INTO qva_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Chaynuy yarparcanganta tantiyarmi Jesús niran: “Juc nacion quiquinpura chriquinacur ushacanmi. Chaynuypis juc marca o juc ayllu chriquinacur mana quëdanchu. ");
INSERT INTO qva_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Chaynuypis quiquin Satanás caycarga ¿gargucunmanchurag quiquinta? Chaynuy captinga quiquinpura chriquinacunmanmi. ¿Imanuypatag munaynin quëdanman? ");
INSERT INTO qva_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Gamcuna nircanqui Satanaspa munayninwan diablucunata gargungäta. Chauraga gamcunapa discïpuluyquicunata ¿pitag munayninta goycan diablucunata gargunanpag? Chay runacunam gamcunata tantiyachishunqui lutanta yarparcangayquita. ");
INSERT INTO qva_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ichanga Tayta Diospa Espiritunpa munayninwan diablucunata noga garguptï musyacan Tayta Diospa munaynin gamcunaman chrayamungantana”. ");
INSERT INTO qva_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“¿Pirag yaycunman fiyupa callpayog runapa wasinman iman aycantapis suwacunanpag quiquinta manaräpis watarga? Wataycurmi ichanga iman aycantapis suwacuyta puedin. ");
INSERT INTO qva_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Mayganpis nogapa mana favurnï cäga conträmi caycan. Chaynuypis nogawan Tayta Diospag runacunata mana shuntagcäga masmi garguycan Tayta Diospita. ");
INSERT INTO qva_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Chaymi noga gamcunata nï: Tayta Dios lapan runacunatam juchäcunganpita y paypa contran lutancunata rimanganpita perdunanga. Ichanga Santu Espiritupag lutanta rimaptinga manam perdunangachu. ");
INSERT INTO qva_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Chaynuypis noga Diospita shamusha Runapag mana alita rimaptin perdunangam. Ichanga Santu Espiritupag mana alita rimaptinga cay pachachru ni jucag pachachrüpis manam perdunangachu. ");
INSERT INTO qva_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Yüra ali captinga musyanchi wayuyninpis ali canganta y yüra mana ali captinga musyanchi wayuyninpis mana ali canganta. Wayuyninpam reguinchi yüra ali canganta mana ali cangantapis. ");
INSERT INTO qva_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Culebra casta runacuna! ¿Imanuypatag gamcuna alita rimapäcunquiman quiquiquicuna fiyu caycarga? Gamcunaga lutanta yarpäpäcungalayquitam rimarcanqui. ");
INSERT INTO qva_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ali runaga alilatam ruran yarpayninchru alicagcunala captin. Fiyu runaga mana alilata ruran yarpayninchru mana alicunala captin. ");
INSERT INTO qva_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Chaymi gamcunata noga nï: Juiciu final junäga yanga rimangancunapitapis lapanmi juzgasha canga. ");
INSERT INTO qva_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Chaychrünam lapan ima parlangayquicunapitapis juzgar mana juchayog o juchayog cangayquitapis nishunqui”. ");
INSERT INTO qva_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Chaypitanam waquin fariseo runacuna y Moisés escribingan leycunata yachrachegcuna Jesusta nipäcuran: “Tayta Diosninchi rasunpa cachramushungayquita musyapäcunäpag milagru ruraycagta ricaytam munapäcü, maestro”. ");
INSERT INTO qva_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Chauraga Jesús niran: “Cay fiyu y Tayta Diosman mana yäracog runacunaga milagruta ruranätarag munarcan. Noga ima milagrutapis manam rurashächu. Ichanga willacog Jonaswan milagru cangannuy nogawanpis captinmi Tayta Dios rasunpa cachramanganta musyapäcungapag. ");
INSERT INTO qva_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonás quimsa junag y quimsa pagas jatuncaray pescädupa pachranchru cangannuy noga Diospita shamusha Runapis quimsa junag y quimsa pagas pamparäshag. ");
INSERT INTO qva_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ninivichru tiyag runacuna Tayta Diospa willacognin Jonás willacunganta mayar juchancunata wanacurir Tayta Diostana cäsucäriran. Jonaspita mas alicag noga caycaptïpis canan wichan runacunaga willacungäta manam chrasquicärinchu. Chaymi juiciu final junag Ninivichru tiyag runacuna sharcamunga canan wichan runacunata contran ninanpag. ");
INSERT INTO qva_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Salomonpa yachrachicuyninta mayananpämi Sabá naciunpita pacha reina warmi Jerusalenman shamuran. Salomonpita noga mas alicag captïpis canan wichan runacunaga willacungäta manam chrasquicärinchu. Chaymi juiciu final junag reina warmi sharcamunga canan wichan runacunata contran ninanpag. ");
INSERT INTO qva_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Runapita diablo yargurna chaqui jircacunapa purin maychrüpis tiyananpag ashir. Mana tariycurga ");
INSERT INTO qva_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","caynuy yarpan: ‘Cutishag maypitam yargamurä chaylaman’. Cutirnam tarin pichapacusha y chrurapacusha jäcuycag wasitanuy. ");
INSERT INTO qva_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Chaynuy caycagta tariycurmi paypita mas fiyu ganchris diablucunata shuntarcur chay runaman cutin payman yaycuycur tiyananpag. Chauraga chay runa unay canganpitapis mas peor ricacun. Chaynuymi pasanga canan wichan fiyu runacunatapis”. ");
INSERT INTO qva_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús chaychru runacunata yachraycächiptinrämi maman y wauguincuna paywan parlayta munar chayman chrayapäcuran. Paycuna punculachru quëdapäcuran. ");
INSERT INTO qva_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Juc runa Jesusta willaran: “Mamayquiwan wauguiquicuna puncuchru carcan. Gamwan parlayta munarcan” nir. ");
INSERT INTO qva_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Chaynuy willaptin Jesús chay runata niran: “¿Pitag mamä y pitag wauguïcuna?” ");
INSERT INTO qva_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nircurna discïpuluncunata ricärir niran: “Nogapaga paycunam mamänuy y wauguïcunanuy. ");
INSERT INTO qva_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Pipis cieluchru caycag Taytä munangannuy cawagcagmi nogapaga wauguïcunanuy, panïcunanuy y mamänuy”. ");
INSERT INTO qva_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Chay junaglam wasipita yargurcur Jesús aywaran Galilea lamar cantunman. Chaychrünam jamacuran yachrachinanpag. ");
INSERT INTO qva_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Chayman achca runacuna shuntacaptinmi lamar cantunchru caycag büquiman Jesús jegaran. Chaypitana jamacuycur yachrachimuran. Runacunana lamar cantunchru quëdaran. ");
INSERT INTO qva_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Chaypitanam achcata yachrachimuran imamanpis tincuchiypa. Caynuy niran: “Juc runa murog aywaran. ");
INSERT INTO qva_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Murur mashtaptin waquin murucuna camiñuman chrayaran. Chaytana pishgucuna shamur upshacarcäriran. ");
INSERT INTO qva_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Waquin muru shala shala allpaman chrayaran. Chaychru allpa achca mana captin chay muru rätu wiñamuran. ");
INSERT INTO qva_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Wiñamurpis fiyupa shanaptin shumag mana sapichacusha car chaquiriycuran. ");
INSERT INTO qva_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Waquincag muruna chrayaran cashacuna rurinman. Wiñamuptinpis cashapis wiñamur garwashtaycächir chaquichiran. ");
INSERT INTO qva_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Waquincag muruna chrayaran achca ali allpaman. Chaynuypa shumag gueshpiran. Waquin espïja wayuran pachracta cama (100). Waquinna wayuran sogta chruncata (60). Waquinna wayuran quimsa chruncata (30). ");
INSERT INTO qva_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","¡Ningäta mayag cäga shumag tantiyacäriy!” ");
INSERT INTO qva_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Discïpuluncuna Jesuscagman ashuycur tapupäcuran: “¿Imanirtag imamanpis tincuchiypa runacunata yachrachinqui?” ");
INSERT INTO qva_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Chaymi Jesús niran: “Gamcunata Tayta Diosmi tantiyarcächishunqui munayninpita pipis mana musyanganta. Waquincunatam ichanga Tayta Dios mana tantiyachinchu. ");
INSERT INTO qva_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Chaynuy captinga mayganpis yachracuyta munagtaga Tayta Dios yanapangam shumag yachrananpag. Mana yachracuyta munagcunatam ichanga yachrangalantapis Tayta Dios gongaycachinga. ");
INSERT INTO qva_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Chaymi noga yachrachï imamanpis tincuchiypa. Paycunaga ricaraycarpis manam ricanchu y mayaycarpis manam tantiyanchu. ");
INSERT INTO qva_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Chaynuy paycuna cagcunapanuymi Tayta Diospa willacognin Isaías escribinganta cumplisha caran: ‘Cay runacuna mayaycarpis manam tantiyanchu. Ricaraycarpis manam ricanchu. ");
INSERT INTO qva_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Imatapis mananam tantiyannachu. Rinrincunapis lutacashanuymi caycan. Ñawincunapis chapacashanuymi caycan. Chaynuy carcan mana ricapäcunanpag, mana mayapäcunanpag ni tantiyapäcunanpämi. Chaynuy paycuna carcan mana wanacunanpämi y Tayta Diospis paycunata mana salvanäpämi’. ");
INSERT INTO qva_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Gamcuna ichanga cushicärinquiman. Gamcunapa ñawiqui ricaycanmi y rinriqui mayaycanmi. ");
INSERT INTO qva_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Rasunpam gamcunata nï: Diospa unay willacognincuna y Tayta Dios munangannuy cawag unay runacunapis gamcuna ricarcangayquita ricaytam munapäcuran. Ichanga ricayta munarpis manam ricapäcuranchu. Chaynuypis mayarcangayquita mayayta munarpis manam mayapäcuranchu”. ");
INSERT INTO qva_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Mayapäcamay murucog runaman tincuchiypa yachrachingäta tantiyachiptï. ");
INSERT INTO qva_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tayta Diospa munayninchru cawanapag willacuyta willacuptin mana tantiyäga muru camiñuman chrayagnuymi caycan. Tantiyangalantapis Satanás shamur gongaycachin. ");
INSERT INTO qva_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Shala shala allpaman chrayag muroga Tayta Diospa ali willacuyninta cushisha runa chrasquicognuymi caycan. ");
INSERT INTO qva_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Cushisha chrasquicusha carpis achca allpa mana captin muru shumag mana sapichacusha car chaquegnuymi carcan. Paycuna Tayta Diospa willacuyninta chrasquicungan janan nacachiptin o rabyapaptin jaguiricärin. ");
INSERT INTO qva_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Cashacuna canganman chrayag muroga Tayta Diospa willacuyninta mayacog runacunanuymi caycan. Ichanga ruraynincunalapag y rïcuyänalanpag aläpa yarpachracärir Tayta Diospa willacuyninta gongariycärin. Chaynuypis Tayta Dios munangannuychu mana cawapäcun. ");
INSERT INTO qva_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ali allpaman murusha muroga Tayta Diospa willacuyninta mayacogcuna y tantiyacogcunanuymi caycan. Espïjacuna pachracta (100), sogta chruncata (60), quimsa chruncata (30) wayuptin shumag cosëcha cangannuy paycuna shumag Tayta Dios munangannuy cawapäcun”. ");
INSERT INTO qva_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Chaypitam mastapis Jesús tincuchiypa yachrachiran: “Tayta Diospa munayninga juc runa ali muruta chracraman murungannuymi caycan. ");
INSERT INTO qva_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Trïgu murusha caycaptinna chacaypa puñungancama chriquegnin aywaycur cebadillupa murunta gaycuriycur aywacuran. ");
INSERT INTO qva_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Wiñarcamur trïgu espïjayta galaycuptinna cebadillupis espïjayta galaycuran. ");
INSERT INTO qva_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Chauraga chracra arognin runacunaga dueñunman aywaycur nipäcuran: ‘¡Tayta, chracraman murungayqui muroga ali muruta caran! ¿Maypitatag cebadillupa murunga yaycusha?’ ");
INSERT INTO qva_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Chauraga dueñun niran: ‘Mayganpis chriquimagnïmi gaycusha canga’. Niptin chay arognincuna niran: ‘¿Alichu canman chay cebadilluta achrog aywapäcuptï?’ ");
INSERT INTO qva_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Chauraga dueñun niran: ‘Ama, ¡cebadilluta achrungayquichru trïgutapis achrurunquiman! ");
INSERT INTO qva_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Jina cosëchacama trïguwan igual wiñacuchun. Cosëchachrünam rutogcunata nishag cebadilluta puntata rutunanpag. Nircur manöju manöju watanga rupachisha cananpag. Chaypita trïgucagtana chruranga pirwacunaman’ ”. ");
INSERT INTO qva_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Mastapis Jesús tincuchiypa yachrachir caynuy willaparan: “Tayta Diospa munayninga ñäpuspa murunnuymi caycan. Chay ñäpuspa murunta chracranman juc runa murunmi. ");
INSERT INTO qva_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Chay muroga rasunpa pasaypa tacshalam. Wiñarnam ichanga huertachru plantacunapitapis mas jatunyan. Chaynuy jatun yüranuy captin pishgucunapis rämancunachru gueshtancunata ruran”. ");
INSERT INTO qva_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Chaynuypis levadüraman tincuchiypa Jesús willaparan: “Tayta Diospa munayninga caycan levadüranuymi. Juc warmi quimsa tupu harinaman levadürata gaycuptin lapan mäsata jacachingannuymi Tayta Diospa munaynin may chaymanpis chrayaycan”. ");
INSERT INTO qva_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Runacunata Jesús yachrachirmi imamanpis tincuchiypa imaypis yachrachiran. Imamanpis mana tincuchiypaga manam imaypis yachrachiranchu. ");
INSERT INTO qva_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Chaynuy yachrachiran willacogninwan Tayta Dios escribichingannuymi. Chay escribinganga caynuymi niran: “Imamanpis tincuchiypam runacunata yachrachishag. Pachata camanganpita pacha pipis mana tantiyangancunatam yachrachishag”. ");
INSERT INTO qva_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Lapan runacunata aywacunanpag nircurnam wasi ruriman Jesús yaycuran. Chaychrünam discïpuluncuna ashuycur nipäcuran: “Chracrachru cebadilluman tincuchiypa yachrachipäcamangayquita tantiyachipäcamay”. ");
INSERT INTO qva_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Chaymi Jesús niran: “Ali muruta murog runaga noga Diospita shamusha Runam caycä. ");
INSERT INTO qva_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Chracraga intëru pacham caycan. Ali muroga Tayta Diospa munayninchru cawagcunam caycan. Cebadilloga Satanaspa munayninchru cawag runacunam caycan. ");
INSERT INTO qva_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Chay cebadilluta murog chriquegninga Satanasmi caycan. Cosëchaga caycan juiciu finalmi. Cosëchata shuntagcunaga caycan angilcunam. ");
INSERT INTO qva_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Cebadilluta shuntarcur rupananpag ninaman gaycungannuymi juiciu final junagpis canga. ");
INSERT INTO qva_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Noga Diospita shamusha Runam angilnincunata cachramushag nogapa munaynïchru caycag runacunapita juchäcachegcunata y mana alicunata rurar cawagcunata acrananpag. ");
INSERT INTO qva_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Shuntarcurnam rupaycag hörnuman gaycunga. Chaychrünam wagar laquicuypita quiruntapis cachrupäcunga. ");
INSERT INTO qva_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mana juchäcur cawagcunam ichanga Tayta Diospa munayninchru inti fiyupa chichipangannuy pasaypa cushisha cawapäcunga. ¡Ningäta mayag cäga shumag tantiyacäriy! ");
INSERT INTO qva_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Tayta Diospa munayninga caycan chracrachru waca pamparaycagnuymi. Juc runa chracrapa puriycanganchru waca pamparaycagta tariran. Nircurna chay runa pasaypa cushisha chay jinalanman pacaycuran. Chaynuy rurarcurna aywaran lapan imaycantapis ranticog. Chay guellaywanna chay chracrata rantiran pampangan wacapis paypag cananpag. ");
INSERT INTO qva_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Chaynuypis Tayta Diospa munayninga caycan juc negocianti fïnu perlasta rantinanpag ashegnuymi. ");
INSERT INTO qva_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Alinnincag perlasta tariycurga lapan imaycantapis ranticuycur chay guellaywan chay fïnu perlasta rantegnuymi caycan. ");
INSERT INTO qva_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Chaynuypis Tayta Diospa munayninga caycan redta lamarman mashtaptin tucuy nirag pescäduta charimognuymi. ");
INSERT INTO qva_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Mashtangan redman pescäducuna yaycuruptin lamar cantunman jorgapäcamun. Chaychrüna pescacogcuna acrar alicagta canastaman wiñapäcun y mana alicagtana jitaripäcun. ");
INSERT INTO qva_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Chaynuymi canga juiciu final junagpis. Angilcunam aywamunga juchayogcunata mana juchäcogcunapita raquinanpag. ");
INSERT INTO qva_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Juchayog runacunatanam rupaycag hörnuman gaycunga. Chaychrünam wagar laquicuypita quiruntapis cachrupäcunga”. ");
INSERT INTO qva_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Nircurna Jesús tapuran: “¿Cay lapan yachrachingäcunata tantiyapäcushcanquichu?” “Aumi” nipäcuran. ");
INSERT INTO qva_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Chauraga Jesús niran: “Chaymi mayganpis Moisés escribingan leycunata yachracheg runaga Tayta Diospa munayninchru cawananpag yachracur juc runa wasinpita iman aycantapis unaycagcunata y mushogcagcunata jorgamognuymi caycan”. ");
INSERT INTO qva_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Chaynuy tincuchiypa yachrachiyta usharcurnam Jesús chaypita aywacuran. ");
INSERT INTO qva_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Marcanman chrayaycur shuntacäpäcunan wasichru yachrachiyta galaycuran. Chaychru yachrachiptinmi almirasha nipäcuran: “¿Chay lapanta payga maychrütag yachracusha? Chaynuypis ¿imanuypatag payga chay milagrucunata ruran? ");
INSERT INTO qva_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Payga manachu carpintëru Josëpa wamran? Chaynuypis paypa mamanga ¿manachu María? ¿Paypa wauguincuna manachu Santiago, José, Simón y Judas? ");
INSERT INTO qva_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Manachu panincunapis noganchiwan cay marcalachru lapan tiyapäcun? Chauraga ¿maychrütag payga chay lapanta yachracamusha?” ");
INSERT INTO qva_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Chaynuy nir chay runacuna payta manam chrasquicäriranchu. Chaymi Jesús niran: “Juc lädu marcacunachrüga Tayta Diospa willacogninta respitäpäcunmi. Ichanga quiquinpa marcamasincunapis ni quiquinpa familianpis mana respitäpäcunchu”. ");
INSERT INTO qva_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Chaymi chay marcachru payman mana yäracäriptin achca milagrucunata mana ruraranchu. ");
INSERT INTO qva_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Chay wichalanmi Galilea provinciapa mandagnin Herodes mayaran Jesús imaycatapis ruraycanganpita runacuna parlarcagta. ");
INSERT INTO qva_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Chaymi uywaynincunata Herodes niran: “Chay runaga Juan Bautistam cawarimusha canga. Chaymi milagrucunata rurananpag munayniyog caycan”. ");
INSERT INTO qva_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodes Juanta prësu charircachir watashata carcilman wichrgachisha caran. Chaynuy wichrgachiran Felipipa warmin Herodías janan. ");
INSERT INTO qva_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Herodista Juan nisha casha: “Leyninchichrüga manam alichu wauguiquipa warmin Herodiaswan tiyanayquipag”. ");
INSERT INTO qva_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Tayta Diospa willacognin Juan canganta lapan runacuna yarpäpäcuptinmi Herodes wañuchiyta munarpis runacunata manchacuran. ");
INSERT INTO qva_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Chaypita Herodispa diyanchru Herodiaspa jipash wawan lapan gayachingancunapa ñaupagninchru dansaran. Chaynuy rurangan Herodista pasaypa gustaran. ");
INSERT INTO qva_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Chaymi juraran imatapis jipash mañacungancagtaga gonanpag. ");
INSERT INTO qva_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Chauraga chay jipashga maman yachrachingannuyla Herodista niran: “Juc plätuchru Juan Bautistapa umanta caychru gomay”. ");
INSERT INTO qva_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Chaynuy niptinmi mandag Herodes pasaypa laquicuran. Lapan gayachimungan runacunapa ñaupagninchru jurasha carmi apamunanpag niran. ");
INSERT INTO qva_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nircurna mandaran carcilman Juanpa umanta cuchupäcamunanpag. ");
INSERT INTO qva_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Nircurna umanta juc plätuwan apaycur chay jipashta gopäcuran. Jipashna mamanta goycuran. ");
INSERT INTO qva_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Juanpa discïpuluncuna aywaycur cuerpunta apacäriran pampapäcunanpag. Pampaycärirna Jesusta willag aywapäcuran. ");
INSERT INTO qva_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesús chay willapata mayaycurmi chunyagnin jircaman büquiwan lamarpa aywacuran. Aywacuycanganta musyarmi chay marcacunapita runacuna chraquilapa gatiräpäcuran Jesús chrayananpag cagman. ");
INSERT INTO qva_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesús büquipita yargurna achca runacuna chaychru shuwararcagta ricar cuyaparan. Chaymi paycunachru gueshyag runacuna caycagta Jesús cuticächiran. ");
INSERT INTO qva_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pacha tardiyaptinna Jesuscagman discïpuluncuna ashuycur nipäcuran: “Pacha nagana tardiyaycanna. Chaynuypis cayga chunyag jirca. Cay runacunata nï marcacunaman micuy ranteg aywacärinanpag”. ");
INSERT INTO qva_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Chaynuy niptin Jesús niran: “Manam paycuna aywacärinmanchu. Gamcuna micuyta garapäcuy”. ");
INSERT INTO qva_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Chaynuy niptin discïpuluncuna nipäcuran: “Caychru chararcä pichga tantatawan ishcay pescädulatam”. ");
INSERT INTO qva_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Chauraga Jesús niran: “Cayman apamuy”. ");
INSERT INTO qva_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nircurna Jesús niran runacunata pashpaman jamacärinanpag. Chaypitanam pichga tantatawan ishcay pescäduta aptarcur cieluta Jesús ricärir Tayta Diosta rugacur agradecicuran. Nircurna partirir partirir discïpuluncunata chacyaran lapan runacunata aypunanpag. ");
INSERT INTO qva_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Chaymi sacsangancama lapan micapäcuran. Puchungancunata chrunca ishcay (12) canasta juntata discïpulucuna shuntapäcuran. ");
INSERT INTO qva_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Chaychru micogcunaga caran pichga waranganuy (5,000) olgucuna, warmicunata y wamracunata mana yupaypa. ");
INSERT INTO qva_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Chaypitana discïpuluncunata Jesús mandaran büquiman jegarcur lamarpa jucag chimpanman ñaupapäcunanpag. Discïpuluncuna aywacuptinmi chaychru cag runacunata despachacur Jesús quëdacuranrag. ");
INSERT INTO qva_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nircurnam jircaman jegaran Tayta Diosta quiquilan rugacunanpag. Pacha chacaycaptinna quiquilan chaychru caycaran. ");
INSERT INTO qva_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Chaycamaga büqui lamar cantunpita carutana aywaycaran. Chayta aywaycaptinna aywangancagpa fiyupa wayra shamur yacuta fiyupa sharcachiran. ");
INSERT INTO qva_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Chaypita pacha manaräpis waraptin yacu jananpa discïpuluncunacagman Jesús aywaran. ");
INSERT INTO qva_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Yacu jananpa aywaycagta ricaycurmi discïpuluncuna fiyupa mancharir gaparäpäcuran “¡Alma aywaycämun! ¡Achrachrau!” nir. ");
INSERT INTO qva_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Chauraga Jesús jucla niran: “¡Ama manchariychu! Nogam caycä”. ");
INSERT INTO qva_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Chauraga Pedro niran: “Tayta, gam caycarga noga yacu jananpa gamcagman shamunäpag niycalämay”. ");
INSERT INTO qva_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Chaynuy niptin Jesús niran: “Shamuy”. Chauraga büquipita yarpurir yacu jananpa Jesuscagman Pedro aywaran. ");
INSERT INTO qva_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Aywaycanganchrümi fiyupa wayra canganta mayar manchariran. Tallpucayta galaycurnam “¡Salvaycalämay, tayta!” nir gapararan. ");
INSERT INTO qva_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Chaynuy niptinmi Jesús jucla maquinpita chutarcur niran: “¡Gam janan shongula yäracog! ¿Imanirtag mana yäracamanquichu?” ");
INSERT INTO qva_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Chaypita büquiman jegarcaräriptin fiyupa wayra chrawaranna. ");
INSERT INTO qva_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Chayta ricaycurmi büquichru caycagcuna Jesuspa ñaupagninman gongurpacuycur nipäcuran: “¡Gam rasunpam Tayta Diospa Wamran caycanqui!” ");
INSERT INTO qva_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Galilea lamarta chimparcurnam chrayapäcuran Genesaretman. ");
INSERT INTO qva_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Chaychru tiyag runacuna Jesusta reguipäcuran. Reguiycärirna chay partichru runacunata lapanta musyachiran. Chauraga chay runacuna lapan gueshyagcunata apapäcuran. ");
INSERT INTO qva_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Chaychrüna Jesusta rugacäriran röpanpa cantulantapis yataycunanpag. Yataycogcäga lapan shumag cuticäpäcuran. ");
INSERT INTO qva_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Chaypitanam fariseucuna y Moisés escribingan leycunata yachrachegcuna Jerusalenpita chrayamur Jesuscagman ashuycur tapupäcuran: ");
INSERT INTO qva_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“¿Imanirtag discïpuluyquicuna unay runacunapa costumbrincunata mana cäsucärinchu? Maquincunata micunanpag mana mayllacärinchu”. ");
INSERT INTO qva_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Chauraga Jesús niran: “Gamcunapis ¿imanirtag Tayta Diospa mandamientunta cäsucärinayquipa truquinga costumbrilayquicunata mas cäsucärinqui? ");
INSERT INTO qva_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tayta Dios caynuymi niran: ‘Mamayquita y taytayquita respitay. Pipis mamanta o taytanta lïsogpag cäga wañuchisha cachun’. ");
INSERT INTO qva_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Gamcunaga yachraycächinqui maygan runapis taytanta mamanta yanapänanpa truquinga ‘Yanapänäpag cagcuna Tayta Dioslapämi lapan caycan’ nipäcunanpag. ");
INSERT INTO qva_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Chaynuy nir taytanta mamanta mana yanapäpäcunnachu. Chaynuy yachrachirmi gamcuna costumbrilayquita rurapäcunayquipag Tayta Diospa mandamientunta manacagman chrurapäcushcanqui. ");
INSERT INTO qva_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Musyagtucogcuna! Tayta Diospa willacognin Isaías rasunpam gamcunapag caynuy capäcunayquipag willacuran: ");
INSERT INTO qva_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Cay runacunaga shimilanpam respitäpäcaman; shongunchrüga juctam yarparcaycan. ");
INSERT INTO qva_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Adoräpäcamanganpis imapäpis manam välinchu. Yachrachipäcun “Cayga Diospa yachrachicuyninmi” nir. Yachrachingancunaga runacunapa mandamientulanmi’ ”. ");
INSERT INTO qva_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nircurnam runacunata gayaycur Jesús niran: “Cay ningäcunata shumag mayapäcuy. Nircur shumag tantiyacäriy. ");
INSERT INTO qva_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Manam shiminpa yaycunganchu runata juchäcachin, sinöga shiminpa yargamunganmi runata juchäcachin”. ");
INSERT INTO qva_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Chauraga discïpuluncuna Jesusta nipäcuran: “Musyanayquipag. Chay ningayquita mayar fariseo runacuna rabyacärisha”. ");
INSERT INTO qva_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesús niran: “Mana murungan jachrata sapircur jitaringannuymi cieluchru caycag Taytä fariseo runacunata jitaringa. ");
INSERT INTO qva_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Fariseucunataga ama cäsupaychu. Chaycunaga carcan juc gapra runa gapra masinta pushagnuymi. Chaymi juc gapra juc gapra masinta pushar pözuman ishcan jegarpapäcunga”. ");
INSERT INTO qva_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Chauraga Pedro niran Jesusta: “Chay ningayquicunata tantiyaycärichilämay”. ");
INSERT INTO qva_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús niran: “¿Gamcunapis manachu tantiyapäcunquirag? ");
INSERT INTO qva_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Manachu tantiyapäcunqui shiminpa yaycunganga pachranman chrayanganta y nircurna ishpacuptin yargunganta? ");
INSERT INTO qva_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ichanga shongunchru yarpangancunatam runa riman. Lutan rimangancunam runata juchäcachin. ");
INSERT INTO qva_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Runapa shongunpita lutan yarpaycuna yargamuptinmi wañuchin, majayog caycar majanwannuy jucwan puñucun, manaräpis casaracur majanwannuy puñucun, suwacun, casquicun y jucpa washanta riman. ");
INSERT INTO qva_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Chaycunata rurarmi runa juchäcun. Micunanpag maquinta mana mayllacunganchu manam juchäcachin”. ");
INSERT INTO qva_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Chaypitanam Jesús aywacuran Tiro y Sidón partiman. ");
INSERT INTO qva_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Chaychrümi chay partipita juc cananea casta warmi Jesuscagman gaparaycar chrayaran: “¡Tayta, rey Davidpa ayllun, cuyapaycalämay! ¡Warmi wamrätam diablo munayninchru chararan y fiyupa löcutächin!” nir. ");
INSERT INTO qva_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesús manam imatapis niranchu. Chaymi discïpuluncuna ashuycur Jesusta rugacäriran: “Chay warmi guepanchita gaparar aywaycämogta aywacunanpag ima munaycangantapis tapuyculay”. ");
INSERT INTO qva_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Chauraga Jesús niran: “Tayta Dios cachramasha ogracasha üshanuy caycag Israel runacunalata yanapänäpämi”. ");
INSERT INTO qva_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Niptinmi chay warmi Jesuspa ñaupagninman gongurpacuycur niran: “¡Tayta, cuyapaycalämay!” ");
INSERT INTO qva_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Chauraga Jesús niran: “Manam alichu canman wamracunata micuyninta guechrurir alguta garaycuptin. Chaynuypis manam alichu canman Israel runacunata cuyapänäpa truquinga gamta cuyapaptï”. ");
INSERT INTO qva_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Warmina niran: “Au, tayta. Algupis micunmi dueñun mësachru micuptin pampaman micuy shicwangantaga”. ");
INSERT INTO qva_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Chauraga warmita Jesús niran: “¡Rasunpam lapan shonguyquipa yäracaramänayqui! Chaymi yäracamangayquinuyla munangayqui cachun”. Chay hörapitanam chay warmipa wamran alina ricacuran. ");
INSERT INTO qva_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Chaypita aywacurnam Jesús chrayaran Galilea lamar cantunman. Nircurnam juc lömaman jegarcur jamacuran. ");
INSERT INTO qva_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Chaymi Jesuscagman achca runacuna shuntacaran. Chayman chrayachipäcuran wegrucunata, macllucunata, gapracunata, müducunata y mas gueshyagcunatapis. Chay gueshyagcunatam Jesuspa ñaupagninman chrurapäcuran. Chaytanam Jesús lapanta cuticächiran. ");
INSERT INTO qva_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Chaynuy cuticächinganta ricaycurmi runacuna pasaypa almirasha ricaräpäcuran müducuna rimaptin, macllucuna cuticaptin, wegrucuna puriptin y gapracuna ricaptin. Chaymi paycuna Israelpa Tayta Diosninta alabayta galaycapäcuran. ");
INSERT INTO qva_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Discïpuluncunata gayaycur Jesús niran: “Cuyapämi cay runacunata. Paycuna quimsa junagna caychru noganchiwan caycan; micunanpag imapis mana canchu. Micanaycagta manam cachrariyta munächu. Aywaycanganchru micuylapita wañucarpis wañucarunmanmi”. ");
INSERT INTO qva_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Discïpuluncuna niran: “Ichanga ¿maychrürag cay achca runacunapag micuyta taripäcamüman cay chunyag jircachru caycarga?” ");
INSERT INTO qva_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Chauraga paycunata Jesús tapuran: “¿Ayca tantatatag gamcuna chararcanqui?” Discïpuluncuna nipäcuran: “Ganchris tantatawan juc ishcay acapa pescädulatam”. ");
INSERT INTO qva_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Chauraga lapan runacunata pampaman jamacärinanpag niran. ");
INSERT INTO qva_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Jamaycäriptinnam ganchris tantatawan pescäduta aptarcur Tayta Diosta Jesús agradecicuran. Nircurnam partirir partirir discïpuluncunata chacyaran paycuna aypupäcunanpag. ");
INSERT INTO qva_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Chaymi lapan sacsangancama micapäcuran. Puchogcunatana ganchris canasta juntata shuntapäcuran. ");
INSERT INTO qva_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Chaychru micogcunaga caran chruscu waranganuy (4,000) olgucuna, warmicunata y wamracunata mana yupaypa. ");
INSERT INTO qva_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Lapan runacunata aywacunanpag niycurnam büquiman jegarcur discïpuluncunawan Magdala partiman Jesús aywacuran. ");
INSERT INTO qva_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Chayman fariseuwan saduceo runacuna chrayaycur lutanta rurachiyta munar Jesusta nipäcuran ima milagrulatapis rurananpag payta Dios rasunpa cachramunganta musyachinanpag. ");
INSERT INTO qva_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Chauraga Jesús niran: “Inti yaycuruptinna ‘Cieluchru garwanchruy ricacämuptin waraga usyangam’ nipäcunqui. ");
INSERT INTO qva_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Tutapa ‘Cielo garwanchruraptin y intuldaraptin canan junäga tamyangam’ nipäcunqui. Chaymi cielo imanuy cangantapis tantiyaycarga ¿imanirtag mana tantiyapäcunquichu canan wichan ima pasaycangantapis? ");
INSERT INTO qva_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Cay fiyu y Tayta Diosman mana yäracog runacunaga milagruta ruranätarag munarcan nogata Dios rasunpa cachramanganta musyachinanpag. Noga ima milagrutapis manam rurashächu. Ichanga willacog Jonaswan milagru cangannuy nogawanpis captinmi Tayta Dios rasunpa cachramanganta musyapäcungapag”. Chaynuy nircurmi chaypita Jesús aywacuran. ");
INSERT INTO qva_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Galilea lamarta chimparcärirnam Jesuspa discïpuluncuna yarpäpäcuran tantata apapäcunanpag canganta. ");
INSERT INTO qva_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesús niran: “Fariseo y saduceo runacunapa levadüranpita cuydacärinqui”. ");
INSERT INTO qva_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Niptin discïpuluncuna quiquinpura ninacäriran: “Tantata mana apamunganchipitam niycämanchi”. ");
INSERT INTO qva_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Chaynuy parlaycanganta tantiyarmi Jesús niran: “¡Janan shongula yäracog runacuna! ¿Imanirtag tanta mana canganpita parlarcanqui? ");
INSERT INTO qva_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Manarächu tantiyapäcunquirag? ¿Manachu yarpäpäcunqui pichga tantalapita pichga waranga (5,000) runacuna micapäcunanpag aypusha canganta y puchogcagtana ayca canastata shuntapäcungayquitapis? ");
INSERT INTO qva_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Chaynuypis ¿manachu yarpäpäcunqui ganchris tantalapita chruscu waranga (4,000) runacuna micunanpag aypusha canganta y puchogcagta ayca canastata shuntapäcungayquitapis? ");
INSERT INTO qva_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Imanirtag gamcuna mana tantiyapäcunquichu tantapita noga mana parlaycangäta? Fariseo y saduceo runacunapa levadüranpita cuydacäriy”. ");
INSERT INTO qva_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Chayrämi tantiyapäcuran tantapa levadüranpita mana cuydacärinanpag Jesús niycanganta sinöga fariseucunapa y saduceucunapa yachrachicuyninpita cuydacärinanpag niycanganta. ");
INSERT INTO qva_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Cesarea de Filipo marcapa partinman chrayaycurmi discïpuluncunata Jesús tapuran: “¿Noga Diospita shamusha Runapag pï cangätatag runacuna nipäcun?” ");
INSERT INTO qva_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Chauraga nipäcuran: “Waquin runacunaga nipäcun Juan Bautista cangayquitam. Waquinnam nipäcun Tayta Diospa willacognin Elías cangayquita. Waquinnam nipäcun willacog Jeremías o jucnin maygan willacogpis cangayquita”. ");
INSERT INTO qva_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Niptin paycunata Jesús niran: “Gamcunaga ¿pï cangätatag nipäcunqui?” ");
INSERT INTO qva_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Chauraga Simón Pedro niran: “Gamga Dios cachramungan Salvadurmi caycanqui, cawaycag Tayta Diospa Wamran”. ");
INSERT INTO qva_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Chauraga Jesús niran: “Cushicuy, Jonaspa wamran Simón. Chaynuy ninayquipäga manam runachu musyachishushcanqui, sinöga cieluchru caycag Taytämi musyachishushcanqui. ");
INSERT INTO qva_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nogapis gamta nï Pedro gaganuy cangayquita. Chaymi gaga jananman wasita runa sharcachingannuy gamwanmi yäracamag shuntacagcunata sharcachishag. Pipis ni wañuypis munayniyog manam cangachu yäracog shuntacagcunata illacächinanpag. ");
INSERT INTO qva_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Gamta goycushayqui Tayta Diospa munayninman yaycunapag llävita. Chaymi cay pachachru Tayta Diospa munayninman yaycunapag lläviptiqui cieluchrüpis llävishanam canga. Cay pachachru Tayta Diospa munayninman yaycunapag quichraptiquega cieluchrüpis quichrashanam canga”. ");
INSERT INTO qva_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nircurnam discïpuluncunata Jesús niran Dios cachramungan Salvador pay canganta pitapis mana willapänanpag. ");
INSERT INTO qva_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Chaypita pachanam discïpuluncunata Jesús willaparan Jerusalenman aywananpag canganta. Chaychru Israel mayor runacuna, cüracunapa mandagnincuna y Moisés escribingan leycunata yachrachegcuna fiyupa nacachinanpag canganta. Chaynuypis willaparan payta wañuchinanpag canganta. Ichanga quimsa junagtaga cawarimunanpag canganta. ");
INSERT INTO qva_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Chaynuy niptinmi juc läduman Pedro pushaycur piñapayta galaycuran: “¡Chaynuyga ama caycuchunchu, tayta! ¡Chaynuyga ama pasayculäshunquichu!” ");
INSERT INTO qva_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Chauraga Jesús muyurcur Pedruta niran: “¡Satanás, ñaupagnïpita ashucuy! Gam chapata chrurapaycämanqui. Gam manam munanquichu Tayta Dios munanganta ruranäta, sinöga munanqui runacuna munanganta ruranätam”. ");
INSERT INTO qva_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nircur discïpuluncunata Jesús niran: “Pipis discïpulü cayta munarga quiquin munangannuy ama cawachunchu. Chaypa truquinga wañunan captinpis noga munangänuyla cawachun. ");
INSERT INTO qva_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Noga janan wañuyta manchacogcäga mana ushacaypa cawayta manam taringachu. Noga janan wañogcagmi ichanga mana ushacaypa cawayta taringa. ");
INSERT INTO qva_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mana ushacaypa cawayman mana aywananpag caycaptinga ¿imapätag välin cay pachachru imaycayogpis cangan? Mana ushacaypa cawayman aywananpag ¿pägayta puedinmanchurag? ");
INSERT INTO qva_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Noga Diospita shamusha Runa angilnïcunawan y Taytäpa munayninwan cutimushag. Chaychrünam runacuna alita rurasha captinga nogapis alita goshäpag y mana alita rurasha captinga nogapis castigäshäpag. ");
INSERT INTO qva_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Rasunpam gamcunata nï: Caychru waquin caycagcuna manaräpis wañurmi noga Diospita shamusha Runa mandanäpag aywaycämogta ricapäcamanqui”. ");
INSERT INTO qva_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Chaypita sogta junag pasarcuptinna Pedrulata, Santiagulata y Santiagupa wauguin Juanlata pushacurcur Jesús jegaran chunyag altu jircaman. ");
INSERT INTO qva_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Chaychrümi paycunapa ñaupagninchru Jesús jucnuyman ticraran. Cäranpis intinuyrag chipiparan. Röpanpis yuragman ricacur achquimannuyrag ticraran. ");
INSERT INTO qva_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Chaychrümi Moisesta y Eliasta Jesuswan parlaycagta ricapäcuran. ");
INSERT INTO qva_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Chaymi Jesusta Pedro niran: “Tayta, ima alish caychru nogacuna carcä. Munaptiquega quimsa chuclata rurashag: jucta gampag, jucta Moisespag y jucta Eliaspag”. ");
INSERT INTO qva_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Chaynuy Pedro niycaptinrämi chipipaycag pucutay paycunata chapacuycuran. Chay pucutaypitana caynuy nimungan mayacämuran: “Payga cuyay Wamrämi. Paypita noga cushisha caycä. ¡Payta mayacäriy!” ");
INSERT INTO qva_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Chayta mayaycurmi discïpuluncunaga mancharisha gongurpacuycur uysucaycäriran cäranpis pampaman chrayangancama. ");
INSERT INTO qva_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Chaymi ashuycurir yataycur paycunata Jesús niran: “Sharcapäcuy. Ama manchacäriychu”. ");
INSERT INTO qva_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Niptin ricäripäcunanpäga pipis manana carannachu. Jesús quiquilanna caycaran. ");
INSERT INTO qva_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Chay jircapita cutircämurmi Jesús paycunata niran: “Ama pitapis willapäpäcunquichu ricapäcungayquicunata noga Diospita shamusha Runa wañungäpita cawarimungäcama”. ");
INSERT INTO qva_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Chauraga discïpuluncuna Jesusta tapuran: “¿Imanirtag Moisés escribingan leycunata yachrachegcuna nipäcun Tayta Dios cachramungan Salvador shamunanpag puntata Eliasrag shamunanpag canganta?” ");
INSERT INTO qva_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Niptinmi Jesús niran: “Rasunpam Elías puntata shamunga lapanta alichananpag. ");
INSERT INTO qva_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ichanga noga gamcunata nï Elías maynam shamushana canganta. Paycuna manam reguipäcushachu Elías canganta. Chaypa truquinga quiquincuna munangantam rurapäcusha. Chaynuylam noga Diospita shamusha Runatapis paycuna nacachipäcamanga”. ");
INSERT INTO qva_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jesús chaynuy niptinrämi Juan Bautistapag parlaycanganta discïpulucuna tantiyapäcuran. ");
INSERT INTO qva_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Runacuna shuntacasha caycanganman quimsa discïpuluncunawan Jesús chrayaran. Chayman chrayaptinmi juc runa paycagman ashuycurir ñaupagninman gongurpacuycur niran: ");
INSERT INTO qva_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Tayta, wamräta cuyapayculay. Wañupay gueshyam pasaypa nacachin. Chariptinnaga achca cutinam ninamanpis yacumanpis ratasha. ");
INSERT INTO qva_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Discïpuluyquicunaman apamuptïpis manam cuticächishachu”. ");
INSERT INTO qva_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Chauraga Jesús niran: “¡Yäracuyniynag ogracasha runacuna! ¿Imaycamarag gamcunawan caycäshag? ¿Imaycamarag gamcunata awantäshayqui? Cayman wamrata apamuy”. ");
INSERT INTO qva_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Chrayaycachiptinmi wamrachru caycag diabluta Jesús piñaparan. Chauraga wamrata jaguiriycur aywacuran. Chay hörapitanam wamra sänu ricacuran. ");
INSERT INTO qva_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Chaypita quiquilancuna caycarna discïpuluncuna ashuycur Jesusta tapupäcuran: “¿Imanirtag nogacuna chay diabluta garguyta mana puedipäcushcächu?” ");
INSERT INTO qva_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Chauraga Jesús niran: “Janan shongulayquipa yäracurmi garguyta mana puedipäcushcanquichu. Rasunpam gamcunata nï: Yäracuyniqui ñäpuspa murunnuylapis captinga cay jircata ‘caypita jucag chimpaman aywacuy’ niptiquipis ashungam. Gamcunapag manam imapis sasa canmanchu. ");
INSERT INTO qva_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Caynuy cag diablucunaga yargun ayunar Tayta Diosta rugacusharämi”. ");
INSERT INTO qva_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Galilea provinciachru discïpuluncunawan shuntacasha caycarmi Jesús niran: “Runacunapa maquinmanmi noga Diospita shamusha Runa entregasha cashag. ");
INSERT INTO qva_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Chay runacunam wañuchimanga. Wañuchimaptinpis quimsa junagtaga cawarimushämi”. Chaynuy niptinmi fiyupa laquicäriran. ");
INSERT INTO qva_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Chaypitanam Capernaumman discïpuluncunawan Jesús chrayaran. Chaychrümi templupag impuesto cobragcuna Pedruman ashuycur tapuran: “¿Maestruyqui impuestuta templupag päganmi, au?” ");
INSERT INTO qva_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Chauraga Pedro niran: “Au, päganmi”. Nircur wasiman Pedro yaycuptinna manarag tapuptinmi Jesús niran: “Simón, ¿gam imaninquitag? Mandag reycuna, ¿pitatag impuestuta cobran? ¿Quiquin castacunatachu o munayninchru caycag jäpa runacunatachu?” ");
INSERT INTO qva_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro niran: “Munayninchru cag jäpa runacunatam”. Jesuspis niran: “Au, quiquin castacunaga manam päganchu. ");
INSERT INTO qva_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ichanga mana rabyacärinanpag noganchipis impuestuta pägashun. Ayway ansuelata lamarman jitamuy. Chaychru puntacag pescäduta charimungayquipa shiminta quichrariptiquim guellay caycanga. Chay guellaywan nogapag y gampäpis impuestuta pägamuy”. ");
INSERT INTO qva_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Chaychrümi discïpuluncuna ashuycur Jesusta tapuran: “¿Pitag Tayta Diospa munayninchru mas alipag ricasha canga?” ");
INSERT INTO qva_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Chauraga Jesús juc wamrata gayaycur discïpuluncunapa chraupinman ichrichiran. ");
INSERT INTO qva_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Nircur niran: “Rasunpam gamcunata nï: Tayta Diospa munayninman chrayapäcunayquipäga wamracuna mana runatucog cangannuy gamcunapis capäcunayqui. ");
INSERT INTO qva_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Chaynuypis cay wamranuy cagcunam Tayta Diospa munayninchru alipag ricasha canga. ");
INSERT INTO qva_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Nogapa jutïchru cay wamratanuy pï wamratapis chrasquirga nogatam chrasquicarcämanqui. ");
INSERT INTO qva_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ichanga pitapis wamracunanuy nogaman yäracamagcagta juchäcachegcagtaga mas alim canman mulinu jatun rumita cuncanman wataparcur lamarman undinanpag jitarpuycuptin. ");
INSERT INTO qva_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Cuyapaypämi caycan cay pachachru juchäcachicogcuna! Chayga imaypis cangam. Ichanga ¡Cuyapaypag canga, pitapis juchata ruracheg runaga! ");
INSERT INTO qva_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Maquiqui o chraquiquipis juchäcachishuptiquega cuchurir jitariycuy. Ishcay chraquiyog o ishcay maquiyog caycagta imaypis mana upeg ninaman gaycusha canayquipa truquinga mas alim canman cutu maquila o cutu chraquilapis mana ushacaypa cawayman chrayaptiqui. ");
INSERT INTO qva_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Chaynuy ñawiquipis juchäcachishuptiquega ogtirir jitariycuy. Ishcay ñawiyog caycagta infiernuman gaycusha canayquipa truquinga mas alim canga juc ñawiyogla mana ushacaypa cawayman chrayaptiqui. ");
INSERT INTO qva_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Chay wamracunanuy caycag yäracogcunata manacagpag ama ricapäcuychu. Gamcunata nï: Paycunapa angilnincuna cieluchru caycag Taytäpa ñaupagninchrümi imaypis carcan. ");
INSERT INTO qva_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Noga Diospita shamusha Runa ogracasha caycagnuy juchäcogcunata salvanäpämi shamushcä. ");
INSERT INTO qva_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“¿Gamcuna imaninquitag? Juc runa pachrac (100) üshanpita jucta ograycurga ¿manachu waquincagta juc pachaman jaguiycur juc ogracasha caycagta asheg aywanman? ");
INSERT INTO qva_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Rasunpam gamcunata nï: Ashiycanganchru tariycurga mana ogracag üshancunapag cushicunanpa truquinga taringancag üshanpitam mas cushicun. ");
INSERT INTO qva_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Chaynuylam cieluchru caycag Tayta Diosniqui mana munanchu wamranuypis caycag yäracogcuna ni juclaylapis infiernuman aywananta. ");
INSERT INTO qva_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Tayta Diosman yäracogmasiqui imalachrüpis mana alita rurashuptiquega puntata quiquilanwan parlag ayway. Chaychru tantiyachinqui imata mana alita rurangantapis. Tantiyachiptiqui chrasquicuptinga perdunänacärinqui. ");
INSERT INTO qva_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tantiyachiptiquipis mana chrasquishuptiquega ishcay o quimsa yäracogmasiquita pushanqui juchäcunganpita tantiyachingayquita mayananpag. ");
INSERT INTO qva_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Paycunatapis mana cäsucuptinga yäracamag shuntacagcunata willapäcuy. Chaychrüpis tantiyachingancunata mana cäsucuptinga Tayta Diosman mana yäracog y impuesto cobrag runacunatanuyna ricapäcuy. ");
INSERT INTO qva_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Rasunpam gamcunata nï: Cay pachachru Tayta Diospa munayninman yaycunanpag llävipäcuptiqui cieluchrüpis llävishanam canga. Cay pachachru Tayta Diospa munayninman yaycunanpag quichrapäcuptiquega cieluchrüpis quichrashanam canga. ");
INSERT INTO qva_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Chaynuypis gamcunata nï: Cay pachachru ishcayqui rimanacurir cieluchru caycag Taytäta rugacäriptiquega mañacungayquita pay rurangam. ");
INSERT INTO qva_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ishcaylapis quimsalapis nogaman yäracogcuna shuntacanganchrüga nogapis chaychrümi caycä”. ");
INSERT INTO qva_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Chaypita Pedro ashuycur Jesusta tapuran: “Tayta, ¿yäracogmasï mana alita ruramaptin ayca cutitag perdunäman? ¿Ganchris cutichurag?” ");
INSERT INTO qva_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús niran: “Manam ganchris cutila nïchu. Sinöga ganchris chrunca ganchris (77) cuti perdunanqui. ");
INSERT INTO qva_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Tayta Diospa munaynin caycan juc rey uywayninta cuentata mañangannuymi. ");
INSERT INTO qva_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Chaynuy cobracuyta galaycuycaptinna yupaytapis mana atipäna jagan runata chrayachipäcuran. ");
INSERT INTO qva_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Chay runapa imanpis mana pägananpag captin rey niran quiquinta, warminta, wamrancunata y lapan imaycantintapis ranticuycunanpag. Chaynuypa jaganta pägayta galaycunanpag. ");
INSERT INTO qva_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Chaynuy niptin chay runaga reypa ñaupagninman gongurpacuycur rugacuran: ‘Shuwaycalämay, tayta, lapantam guellayniquitaga cuticachiläshayqui’. ");
INSERT INTO qva_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Chaynuy rugacuptin chay rey chay runata cuyaparan. Y lapan jaganta perdunaycur cachrariycuran. ");
INSERT INTO qva_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Cachrariycuptin aywacuycanganchru chay runa tincuran juc uywaymasinwan. Chay uywaymasin walcala jagan caran. Chaymi cuncapita lapiraran ‘¡Jagäta pägamay!’ nir. ");
INSERT INTO qva_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Chauraga chay uywaymasinga ñaupagninman gongurpacuycur rugacuran: ‘Shuwaycalämay, tayta, guellayniquitaga cuticachiläshayquim’ nir. ");
INSERT INTO qva_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Chaynuy rugacuptinpis mana munaranchu. Chaypa truquinga carcilman wichrgachiran jaganta pägangancama. ");
INSERT INTO qva_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Chaynuy ruranganta ricaycur waquin uywaymasincuna pasaypa laquipar rabyacäriran. Chaymi reyman aywaycur willapäcuran lapanta imanuy pasangantapis. ");
INSERT INTO qva_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Chauraga rey gayaycachimur chay runata niran: ‘¡Fiyu runa! Rugacamaptiqui lapan jagä cangayquita noga perdunashcä. ");
INSERT INTO qva_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Chaynuy noga cuyapaycaptïga gampis uywaymasiquita cuyapänayquim caran’. ");
INSERT INTO qva_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Rey fiyupa rabyacurna carcilman wichrgachiran. Chaychrüna wardia fiyupa castigaran lapan jaganta pägangancama. ");
INSERT INTO qva_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Chaynuymi gamcunawanpis cieluchru caycag Taytä ruranga lapan shonguyquipa yäracogmasiquicunata mana perdunaptiquega”. ");
INSERT INTO qva_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Chaynuy niyta usharcurnam Galileapita aywacur Jordán mayupa jucag lädun Judea partiman chrayaran. ");
INSERT INTO qva_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Paypa guepanta achca runacunam aywaran. Chaychrümi gueshyagcunatapis cuticächiran. ");
INSERT INTO qva_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Jesuscagmanmi fariseo runacuna aywaran. Chaychrümi lutanta rimachiyta munar tapupäcuran: “¿Moisés escribingan leycunachru niycan imalapitapis runa warminpita raquicänanpag cangantachu?” ");
INSERT INTO qva_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Chauraga Jesús niran: “¿Tayta Dios escribichinganta gamcuna manachu liyishcanqui galaycunanpita pacha camag Tayta Dios olgutapis warmitapis camanganta? ");
INSERT INTO qva_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Tayta Dios niran: ‘Chaymi runa taytanta mamanta jaguirin warminwan majachacänanpag. Y ishcan juc runanuylana capäcunga’. ");
INSERT INTO qva_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Chaynuypa ishcay runanachu mana canga sinöga juc runanuylana canga. Chaymi Tayta Dios majachangantaga runa ama raquichunchu”. ");
INSERT INTO qva_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Fariseo runacuna tapuran: “Chauraga ¿imanirtag Moisés escribiran raquicangan papilta goycuptinga warmin aywacunanpag canganta?” ");
INSERT INTO qva_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Chauraga Jesús niran: “Gamcuna mana cäsucog capäcuyniquipam warmiquipita raquicäpäcunayquipag Moisés niran. Ichanga galaycunanchru manam chaynuy cananpächu caran. ");
INSERT INTO qva_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Noga gamcunata nï: Pipis warminpita jucwan mana caycaptin raquicarga juc warmiwan majachacarga adulterio juchata ruraycan. Chaynuypis runapita raquicasha warmiwan pipis majachacurga runacagmi adulterio juchata ruraycan”. ");
INSERT INTO qva_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Chauraga discïpuluncuna niran: “Runa warminwan chaynuy cananpag caycaptinga mas ali caycan mana majachacay”. ");
INSERT INTO qva_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús niran: “Manam lapanchu gamcuna nircangayquita chrasquipäcunga. Waquincunam ichanga chaynuy canga. ");
INSERT INTO qva_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Waquincunaga yurisha majaynagla cawacunanpämi. Waquincunataga runamasinmi adrede majaynag cananpag capachipäcusha. Waquinnam ichanga capashanuypis majaynagla cawacun Tayta Dios munanganta rurananpag. Mayganpis cayta chrasquiyta camäpacurga majaynagla cawacuchun”. ");
INSERT INTO qva_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Chaypitana Jesuscagman wamracunata apapäcuran umanman maquinta chruraycur paycunapag Tayta Diosta rugacunanpag. Wamracunata apapäcamogcunata discïpuluncuna piñaparan. ");
INSERT INTO qva_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Chauraga Jesús niran: “Wamracuna nogaman aywacamuchun; ama amachäpäcuychu. Tayta Diospa munayninchru cawagcuna chay wamracunanuymi carcan”. ");
INSERT INTO qva_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Wamracunapa umanman maquinta chruraycur Tayta Diosta rugacurirmi chaypita aywacuran. ");
INSERT INTO qva_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Juc cutinchru juc mösu aywaycur Jesusta niran: “Maestro, ¿ima alitatag ruräman mana ushacaypa cawayta chrasquinäpag?” ");
INSERT INTO qva_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Chauraga Jesús niran: “¿Imanirtag tapumanqui ali ruraypita? Tayta Dioslam alega. Mana ushacaypa cawayman yaycuyta munarga mandamientuncunachru ningancunata cäsucuy”. ");
INSERT INTO qva_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Niptin chay mösu tapuran: “¿Mayganta?” Jesús niran: “Runamasiquita ama wañuchinquichu. Majayog caycar majayquiwannuy ama jucwan puñucunquichu. Ama suwacunquichu. Manacagpita ama pitapis tumpanquichu. ");
INSERT INTO qva_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Taytayquita mamayquita respitanqui. Quiquiqui cuydacungayquinuy runamasiquitapis cuyay”. ");
INSERT INTO qva_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mösu niran: “Chaycunataga lapantam cumplishcä. ¿Imatag pishiycäman cumplinäpag?” ");
INSERT INTO qva_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús niran: “Lapan shonguyquipa Tayta Diosta cäsucuyta munarga lapan imayquicunatapis rantiycuycur pobricunata aypumuy. Chaynuypa cieluman riquësayquita chruracognuymi caycanqui. Nircur shamuy, nogawan puriy discïpulü canayquipag”. ");
INSERT INTO qva_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Chayta mayar pasaypa rïcu car chay mösu fiyupa laquisha aywacuran. ");
INSERT INTO qva_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Chauraga discïpuluncunata Jesús niran: “Rasunpam gamcunata nï: ¡Sasam canga rïcu runacuna Tayta Diospa munayninman yaycunanpag! ");
INSERT INTO qva_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Yapay gamcunata nï: Aujapa ñawinpa camello pasanganpita mas sasa caycan rïcu runa Tayta Diospa munayninman yaycunanpag”. ");
INSERT INTO qva_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Chayta mayar discïpuluncuna pasaypa manchacar nipäcuran: “Chauraga ¿pirag salvacunga?” ");
INSERT INTO qva_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús paycunata ricärir niran: “Quiquilanpitaga runacuna manam salvacuyta puedipäcunchu. Tayta Dioslam pitapis salvan. Paypäga imapis manam sasachu”. ");
INSERT INTO qva_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Chauraga Pedro niran: “Nogacunaga lapan imaycäcunatapis jaguiriycärishcä gamwan puripäcunäpag. ¿Nogacunaga imatatag chrasquipäcushag?” ");
INSERT INTO qva_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús niran: “Rasunpam gamcunata nï: Cay pacha mushogna cananpag tiempo chrayamuptinnam noga Diospita shamusha Runa chipipaycag tronuchru juzganäpag jamacushag. Chaynuypis gamcuna discïpulü cangayquipita chrunca ishcay (12) tronucunachru jamacärinqui chrunca ishcay ayllupita mirag Israel runacunata juzganayquipag. ");
INSERT INTO qva_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ichanga noga raycu pipis wasinta, wauguincunata, panincunata, mamanta, taytanta, wamrancunata, chracrancunatapis jaguiriycamusha cagcunaga pachrac (100) cuti mastam chrasquipäcunga. Chaynuypis mana ushacaypa cawaytam chrasquipäcunga. ");
INSERT INTO qva_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","“Ichanga canan achcag puntacag cagcunaga guepacag canga. Achcag canan guepacag cagcunaga puntacag canga”. ");
INSERT INTO qva_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Tayta Diospa munaynin caycan chracrayog runa üvas chracranman arog aywananpag tutala mincayta asheg aywangannuymi. ");
INSERT INTO qva_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mincayta tariycur juc jornalta pägananpag parlarcur üvas chracranchru arunanpag cachraran. ");
INSERT INTO qva_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Las nuevimannuy yargur runacunata pläzachru aruyniynag carcagta tariran. ");
INSERT INTO qva_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Chauraga niran: ‘Gamcunapis üvas chracrächru arunayquipag aywapäcuy. Pägashayqui gänapäcunayquicagtam’. Chaynuy niptin paycunapis aywaran. ");
INSERT INTO qva_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Chay chracrayog runa yapay pulan junagmannuy y tardina mallway inti caycaptin mincay asheg aywaran. ");
INSERT INTO qva_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Chaypita nagana inti yaycunanpag caycaptinna pläzaman yapay cutiran. Chaychrüpis tariran aruyniynag caycag runacunata. Chauraga tapuran: ‘¿Imanirtag gamcuna caychru goyaylata arog mana aywar carcanqui?’ ");
INSERT INTO qva_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Chauraga runacuna nipäcuran: ‘Pipis manam mincacärimashachu arupänäpag’. Chaymi niran: ‘Gamcunapis ayway üvas chracrächru arupäcamunayquipag’. ");
INSERT INTO qva_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Pacha chacaycaptinna chracrayog runa arucheg runanta niran: ‘Lapan arogcunata gayaycamur pägay guepata arog yaycogcunapita galaycur tutapita yaycogcunacama’. ");
INSERT INTO qva_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nagana inti yaycunapäna caycaptin yaycog arogcuna shapäcamuran. Chaychrümi lapanpis juc jornalpita pägunta chrasquipäcuran. ");
INSERT INTO qva_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tutapita arogcuna pägunta chrasquirna yarpäpäcuran masta chrasquipäcunanpag canganta. Ichanga paycunapis juc jornal-lapita pägunta chrasquipäcuran. ");
INSERT INTO qva_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Juc jornal-lapita pägunta chrasquirna chracrayog runapag rimapäcuran: ");
INSERT INTO qva_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Guepata yaycamogcuna juc hörala arusha caycaptinpis fiyupa shanaychru goyächiy arusha carcaptïpis nogacunataga paycunatawan igual-la pägarcämanqui’. ");
INSERT INTO qva_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Chauraga chracrayog runa jucnincag runata niran: ‘Amïgo, ¿gamcunata manachu juc jornalpita päganäpag canganta nirä? Noga gamcunata manam engañaycächu. ");
INSERT INTO qva_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Cä päguyqui y aywacuy. Guepata arog yaycogtapis noga munä gamtawan igual pägayta. ");
INSERT INTO qva_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Noga musyämi guellaynïta imata ruraytapis. ¿O cuyapäcog cangäpitachu jamurpaycämanqui?’ ” ");
INSERT INTO qva_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Nircurmi Jesús niran: “Guepacagcunam puntacag canga y puntacagcunam guepacag canga”. ");
INSERT INTO qva_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jerusalenman aywarcanganchrümi chrunca ishcay (12) discïpuluncunata juc läduman gayaycur Jesús niran: ");
INSERT INTO qva_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ricapäcuy, Jerusalentam canan aywaycanchi. Chaychrümi noga Diospita shamusha Runa cüracunapa mandagnincunapa y Moisés escribingan leycunata yachrachegcunapa maquinman entregasha cashag. Paycunam wañuchisha canäpag ninga. ");
INSERT INTO qva_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nircurnam mana Israel runacunaman entregämanga nogata asipämänanpag, astimänanpag y crucificämänanpag. Ichanga quimsacag junäga cawarimusham cashag”. ");
INSERT INTO qva_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zebedeupa warminmi ishcan wamranta pushacurcur Jesuscagman ashuycuran. Nircur ñaupagninman gongurpacuran Jesusta rugacunanpag. ");
INSERT INTO qva_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Chaymi Jesús tapuran: “¿Imatatag munaycanqui?” Chauraga chay warmi niran: “Mandag cayman chrayarna cay ishcay wamräcunata jucagninta derëchayquiman y jucagninta ichogniquiman mandäshishunayquipag chrurayculanqui”. ");
INSERT INTO qva_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Chauraga ishcan discïpuluncunata Jesús niran: “Gamcunaga imata rugacamangayquitapis manam musyapäcunquichu. ¿Awantäpäcunquimanchurag nogata nacachimangannuy nacachipäcushuptiqui?” Paycuna nipäcuran: “Awantäpäcushämi”. ");
INSERT INTO qva_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesús niran: “Noga nacangänuymi gamcunapis nacapäcunquipag. Ichanga derëchäman o ichognïman chrurananpäga manam nogapitachu. Chaymanga Taytalämi maygantapis munanganta chruranga”. ");
INSERT INTO qva_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Chaynuy rugacunganpita chruncacag discïpuluncunaga ishcan wauguicunapag rabyacäriran. ");
INSERT INTO qva_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Chauraga lapanta gayaycur Jesús niran: “Musyapäcungayquinuypis mana Israel naciuncunachru mandagcunaga mandag cayninman atïnicuycur lapan runata mandan. ");
INSERT INTO qva_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Gamcunachrüga manam chaynuychu capäcunquiman. Gamcunachrüga maygayquipis mandag cayta munarga runamasiquipa uywayninnuy capäcunquiman. ");
INSERT INTO qva_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Gamcunachrüga maygayquipis mas alipag ricasha cayta munarga runamasiquipa uywayniquinuy capäcunquiman. ");
INSERT INTO qva_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Noga Diospita shamusha Runanuy capäcuy. Noga shamushcä manam mandangäta rurachinäpächu. Sinöga shamushcä mandanganta ruranäpämi y achcag runacuna raycu wañur jucpa munayninchru caycagta jorgunäpämi”. ");
INSERT INTO qva_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jericó marcapita aywacuptinna Jesuspa guepanta achca runacuna aywaran. ");
INSERT INTO qva_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ishcay gapra runacuna camiñu cantunchru jamaraycanganpita Jesús pasaycagta mayar gayacäriran: “¡Tayta, rey Davidpa ayllun, cuyapaycärilämay!” ");
INSERT INTO qva_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Chaynuy gayacuptin runacuna piñaparan upälacärinanpag. Piñapaptinpis masrämi gayaräpäcuran: “¡Tayta, rey Davidpa ayllun, cuyapaycärilämay!” ");
INSERT INTO qva_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Chauraga Jesús ichriycur gapra runacunata gayaycur tapuran: “¿Gamcunapag imata ruranätatag munarcanqui?” ");
INSERT INTO qva_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Paycuna nipäcuran: “Tayta, ñawïcunata cuticaycachilämay”. ");
INSERT INTO qva_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesús paycunata cuyapar ñawincunata yataycuran. Chauraga chay höra gapracunapa ñawin cuticaran. Chaypitana Jesusta gaticurcur aywacäriran. ");
INSERT INTO qva_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Discïpuluncunawan Jesús Jerusalenman nagana cercaycarna y Olivos lömachru caycag Betfagé marcaman chrayananpäna caycar ishcay discïpuluncunata cachraran. ");
INSERT INTO qva_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Paycunata niran: “Aywapäcuy tagay chimpa marcaman. Chrayalarnam taripäcunqui juc bürru wataraycagta. Chay bürrum manta wawantin caycan. Chayta pasquirir nogaman ishcanta apapäcamunqui. ");
INSERT INTO qva_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Pipis imatapis nishuptiquega ‘Señor Jesusmi nisitaycan’ nipäcunqui. ‘Chaypitanam jucla cutichimushag’ nipäcunqui. Chauraga runa jucla cachramunga”. ");
INSERT INTO qva_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Caynuy pasaran willacogninwan Tayta Dios escribichingannuymi: ");
INSERT INTO qva_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“¡Jerusalenchru tiyag runacuna, ricapäcuy! Mandagniqui Rey gamcunaman aywaycämun. Umildi runanuylam manta bürrun logasha aywaycämun. Bürrupa wawanta logasham aywaycämun”. ");
INSERT INTO qva_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Discïpuluncuna Jesús ningannuylam rurapäcuran. ");
INSERT INTO qva_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Mamantinta gatiycur cäpancunata ishcan bürrucunaman carunapäcuran. Nircurna manta bürruta Jesús logacuran. ");
INSERT INTO qva_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Achca runam caran. Chaychrümi Jesús pasananpag achcag runacuna cäpancunata camiñuman mashtaran. Chaynuypis waquinna yürapita cuchurir rämacunata mashtaran. ");
INSERT INTO qva_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Chaymi puntanta aywagcuna y guepanta aywagcunapis nipäcuran: “¡Rey Davidpa ayllun alabasha cayculächun! ¡Tayta Diosninchi cachramungan runa alabasha cayculächun! ¡Tayta Diosninchi alabasha cayculächun!” ");
INSERT INTO qva_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jerusalenman Jesús yaycuptinna lapan runacuna yargapäcamuran ima caycangantapis ricananpag. Tapupäcuran: “¿Pitag pay?” nir. ");
INSERT INTO qva_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Chauraga runacuna nipäcuran: “Payga Galileachru caycag Nazaret marcapita Tayta Diospa willacognin Jesusmi”. ");
INSERT INTO qva_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Templuman Jesús yaycuran. Nircurnam chaychru ranticurcagcunata y rantircagcunata gargamuran. Chaynuypis guellayta trucachegcunapa mësancunata y paluma ranticogcunapa sillëtancunatapis ticraypa usharan. ");
INSERT INTO qva_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Nircur niran: “Tayta Dios escribichinganchru niycan: ‘Wasïga canga nogata rugacamänanpämi’. Ichanga gamcuna suwapa machraynintanuy chrurarcanqui”. ");
INSERT INTO qva_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Templuchrümi gapracunapis y wegrucunapis Jesuscagman ashuycäriran. Paycunata lapantam cuticächiran. ");
INSERT INTO qva_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ichanga cüracunapa mandagnincuna y Moisés escribingan leycunata yachrachegcuna milagrucunata Jesús ruragta ricaycur y templuchru wamracuna “¡Rey Davidpa ayllun alabasha cayculächun!” negta mayar rabyacäriran. ");
INSERT INTO qva_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Chaynuy rabyacurmi Jesusta nipäcuran: “¿Mayanquichu chaycuna imata nircangantapis?” Chauraga Jesús niran: “Au, mayaycämi. ¿Ichanga gamcuna manachu liyishcanqui caynuy escribiraycanganta: ‘Acapa wamracunatawan chuchuycagcunatam camarishcanqui gamta alabäpäcushunayquipag’?” ");
INSERT INTO qva_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Chaynuy niycurnam jaguiriycur aywacuran Jerusalenpita Betania marcaman chaychru pachacunanpag. ");
INSERT INTO qva_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Warantin tuta Jerusalenman cutiycarmi Jesús micanaran. ");
INSERT INTO qva_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Chaymi hïgus yürata camiñupa cantunchru ricaycur aywaran wayuyninta ashinanpag. Ashir wayuyninta mana tariranchu. Öjalanta tariycurmi niran: “¡Cananpitaga imaypis ama wayunquinachu!” Niptin chay höra chay hïgus yüra chaquicäcuran. ");
INSERT INTO qva_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Chayta ricaycur discïpuluncuna almirasha Jesusta tapupäcuran: “¿Imanirtag chay hïgus yüra chay höra chaquicäcusha?” ");
INSERT INTO qva_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Chauraga Jesús niran: “Rasunpam gamcunata nï: Lapan shonguyquipa yäracur y ruracänanpag canganta yarpaptiquega manam caylachu ruracanga. Sinöga cay jircata: ‘¡Caypita aywacuy y lamarman jegarpuy!’ niptiquipis ningayquinuymi ruracanga. ");
INSERT INTO qva_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Lapan shonguyquipa yäracur imatapis Tayta Diosta rugacurga rugacungayquita chrasquinquim”. ");
INSERT INTO qva_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Chaypitana templuman Jesús yaycuran. Chaychru yachraycächiptinmi cüracunapa mandagnincuna y Israel mayor runacuna Jesusta tapupäcuran: “Gamga ¿ima munayniquiwantag chay lapanta rurashcanqui? ¿Pitag nishushcanqui chaycunata ruranayquipag?” ");
INSERT INTO qva_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Chauraga Jesús niran: “Nogapis gamcunata tapushayqui. Tapungäta nipäcamaptiquega nogapis ima munaynïwan rurangätapis nishayquim. ");
INSERT INTO qva_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Pitag Juanta cachramusha bautizänanpag? ¿Tayta Dioschu o runacunachu?” Chauraga quiquinpura caynuy parlanacäriran: “ ‘Tayta Diosninchim cachramusha’ nishaga, ‘¿Imanirtag mana criyipäcurayquichu?’ nimäshun. ");
INSERT INTO qva_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Chaynuypis manam nishwanchu ‘Runacuna cachramusha’. Runacunata manchacunchi. Paycuna criyipäcun Tayta Diospa willacognin Juan cangantam”. ");
INSERT INTO qva_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Chaymi nipäcuran: “Manam musyapäcüchu”. Chauraga Jesús niran: “Nogapis manam willashayquichu ima munaynïwan rurangätapis”. ");
INSERT INTO qva_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús tapuran: “¿Caypita gamcuna imatatag yarpäpäcunqui? Juc runapa ishcay wamrancuna caran. Chay wamrancunapita mayurcagta niran: ‘Hïju, canan junag üvas chracraman arog ayway’. ");
INSERT INTO qva_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Wamran niran: ‘¡Mana aywächu!’ Chaynuy nircurpis yarpachracurirga arog aywaran. ");
INSERT INTO qva_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Chaypita taytanga shulcacag wamrantana ashuycurir niran. Chauraga ‘Yä, tayta, aywashämi’ niran. Au niycarpis chay wamran manam aywaranchu. ");
INSERT INTO qva_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Chauraga ishcanpita ¿maygantag taytan munanganta ruraran?” Chaynuy niptin “Mayurcag wamranmi” nipäcuran. Jesús niran: “Rasunpam gamcunata nï: Romapag impuesto cobragcuna y mañösa warmicunapis Tayta Diospa munayninman yaycungam. Gamcunam ichanga mana yaycapäcunquichu. ");
INSERT INTO qva_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juan Bautistaga gamcunaman shamuran Tayta Dios munangannuy cawapäcunanpag yachrachinanpämi. Chayta manam criyipäcurayquichu. Ichanga chay impuesto cobragcunam y chay mañösa warmicunam criyipäcusha. Paycuna criyipäcunganta ricaycarpis gamcuna manam wanacärishcanquichu ni criyipäcushcanquichu”. ");
INSERT INTO qva_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Tincuchiypa willapangäta mayapäcamay: Juc chracrayog runa juc chracra üvasta plantaran. Nircurna guenchrachiran. Vïnuta maychru rurananpäpis rurachiran. Üvasta täpananpag törrita rurachiran. Nircurna arrendacuycur juc lädupa aywacuran. ");
INSERT INTO qva_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Cosëcha tiempo chrayaramuptinna uywaynincunata üvas arrindupita paypag cagta raquipämunanpag cachraran. ");
INSERT INTO qva_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Chrayaptinna üvas arrendagcunaga chay uywaycunata chariycur jucninta magapäcuran, jucagninta wañuchipäcuran y jucagnintana sagmaypa ushapäcuran. ");
INSERT INTO qva_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Chaynuy ruraycaptinpis chracrayöga puntacagchru cachranganpita masta uywaynincunata yapay cachraran. Paycunatapis chaynuyla rurapäcuran. ");
INSERT INTO qva_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Ultimutaga wamrantana cachraran ‘Wamrätaga respitäpäcungam’ nir. ");
INSERT INTO qva_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ichanga chay wamran chrayaycagta ricaycur chracra arrendagcuna parlanacäriran: ‘Tagaymi cay chracrawanga quëdanga. Wañuchishun noganchina cay chracrawan quëdananchipag’ nir. ");
INSERT INTO qva_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Chrayaruptinga chariycur üvas chracrapita jorgurir wañuchipäcuran. ");
INSERT INTO qva_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Chaynuy ruranganpita chay üvas chracrayog runaga chrayaycur chay arrendag runacunata ¿imata ruranantatag yarpäpäcunqui?” ");
INSERT INTO qva_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Chauraga nipäcuran: “Chay fiyu runacunataga mana cuyapaypam wañuchinga. Nircurnam tiempulanchru paypag cagta cosëchachru wayuyninta raquipagcagta arrendacuycunga”. ");
INSERT INTO qva_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesús niran: “¿Gamcuna Tayta Dios escribichinganchru caynuy ninganta manachu liyishcanqui? ‘Wasi ruragcuna “mana ali rumim” nir jitaringan rumim wasi cimientupag alinnincag rumiman ticrasha. Chaynuy cananpäga Tayta Diosninchim rurasha. Chaynuy rurasha captinmi almirasha caycanchi’. ");
INSERT INTO qva_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Chaymi gamcunata nï: Gamcuna Tayta Diospa munayninchru cagcunata manam mas mandapäcunquinachu. Chaypa truquinga Dios munanganta cäsucogcunam Tayta Diospa munayninchru cagcunata mandapäcunga. ");
INSERT INTO qva_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Pipis chay rumi jananman ratagcäga ushacangam. Chaynuy pipa jananmanpis chay rumi ratarga pasaypam ushacächinga”. ");
INSERT INTO qva_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Chaynuy tincuchiypa yachrachiptinmi cüracunapa mandagnincuna y fariseo runacuna tantiyapäcuran paycunapag Jesús chaynuy niycanganta. ");
INSERT INTO qva_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Chaymi runacunata manchacur prësu apayta munarpis mana apapäcuranchu. Chay runacuna Jesús Tayta Diospa willacognin cangantam criyipäcuran. ");
INSERT INTO qva_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Chaypitana yapay tincuchiypa Jesús yachrachir niran: ");
INSERT INTO qva_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Tayta Diospa munayninga caycan olgu wamran casaraptin juc rey fiestata ruranganmannuymi. ");
INSERT INTO qva_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Chay rey uywaynincunata cachraran gayachingancunata fiestaman aywamunanpäna willamog. Chay gayachingan runacuna mayganpis aywayta mana munamuranchu. ");
INSERT INTO qva_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Chaypita yapay waquin uywaynincunatana cachraran gayachingan runacunata ‘Töruncunata y weracag wäcancunatapis pishtarcachir micuyta rurachingan listuna caycan. Aywapäcuyna wamran casaraptin fiestachru micapäcunayquipag’ ninanpag. ");
INSERT INTO qva_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Chaynuy gayachiptinpis mayganpis mana cäsupäcamuranchu. Jucnincagna chracranman aywacuran. Jucnincagna negociunman aywacuran. ");
INSERT INTO qva_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Waquinna chay reypa uywaynincunata charircur ashlipäcuran y wañuchipäcuran. ");
INSERT INTO qva_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Chaynuy ruranganpita reyga fiyupa rabyacur soldäduncunata cachraran chay wañucheg runacunata wañuchimunanpag y marcantapis rupachimunanpag. ");
INSERT INTO qva_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nircur uywaynincunata niran: ‘Fiestachru micunapag lapanpis listunam caycan. Chay gayachingä runacunapag micunanpag mana shapäcamushachu paycunapag mana captinmi. ");
INSERT INTO qva_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Cananga cällicunapa aywapäcuy. Taringayquicag runacunata willapäcamuy fiestachru micog shapäcamunanpag’. ");
INSERT INTO qva_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Chauraga yargur cällichru taringan runata alita mana alitapis shuntaycur wasiman pushapäcuran. Chauraga wasi juntasha caran. ");
INSERT INTO qva_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Lapan gayachimungan runacunata ricananpag rey yaycur ricaran juc runata casarayman aywana röpanwan mana aywanganta. ");
INSERT INTO qva_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Chay runata niran: ‘Amïgo, ¿imanaypatag cayman yaycamushcanqui casaray fiestaman aywana röpayqui mana jatisha caycarga?’ Niptin chay runa imatapis mana rimacuranchu. ");
INSERT INTO qva_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Chauraga uywaynincunata rey niran: ‘Casaray fiestaman aywanan röpanwan mana aywamunganpita chraquipita maquipita manyaycur wagta pasaypa yananyaycagman jitariycuy. Chaychrünam pasaypa wagar laquicuypita quiruntapis cachrupäcunga’ ”. ");
INSERT INTO qva_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Nircurnam Jesús niran: “Tayta Diospa munayninchru achcag cananpag gayachisha captinpis walcaglam acrasha quëdanga”. ");
INSERT INTO qva_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Chaypita fariseo runacuna aywacäriran. Chaychrüna rimanacäriran imanuylapapis Jesusta lutanta parlachipäcunanpag, chaypita chay ningalanwanna tumpapäcunanpag. ");
INSERT INTO qva_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Chaynuy rimanacarcärirna cachraran fariseucunapa waquin discïpuluncunatawan Herodispa favurnin cag runacunata. Chaychrüna Jesusta nipäcuran: “Maestro, nogacuna musyapäcümi rasuncaglata ningayquita y Tayta Dios munangannuy shumag cawapäcunanpag rasunpa yachraycächingayquita. Runacuna imata niptinpis munapäcungannuychu manam gam yachrachinqui. ");
INSERT INTO qva_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nipäcamay yarpangayquita: ¿Alichu canman Romachru emperador Cesarpag impuestuta päganapag o mana päganapag?” ");
INSERT INTO qva_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Lutanta rimachiyta munarcanganta tantiyarmi Jesús niran: “¡Alitucogcuna! ¿Imanirtag lutanta rimachiyta munapäcamanqui? ");
INSERT INTO qva_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mä, ricachimay chay impuesto päganapag cag guellayta”. Chauraga denario jutiyog guellayta Jesusta gopäcuran. ");
INSERT INTO qva_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ricaycur Jesús niran: “¿Pipa cärantag y pipa jutintag caychru caycan?” ");
INSERT INTO qva_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Nipäcuran: “Emperador Cesarpam”. Chaymi Jesús niran: “Cesarpa cagtaga Cesarta goycuy. Tayta Diospa cagtaga Tayta Diosta goycuy”. ");
INSERT INTO qva_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Chaynuy niptinmi almirasha quëdapäcuran. Chaypitanam jaguiriycur aywacäriran. ");
INSERT INTO qva_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Chay junaglam saduceo runacuna Jesuscagman aywapäcuran tapupäcunanpag. Chay saduceucuna mana criyipäcuranchu runa wañunganpita cawarimunanpag canganta. Chaymi chaypita Jesusta tapupäcuran: ");
INSERT INTO qva_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Maestro, Moisés escribinganchru niycan: ‘Pipis wamraynagla wañuptin guepancag wauguin viudata shuntachun warminpag. Chaynuypam wamran chay wañog wauguinpanuyna canga’. ");
INSERT INTO qva_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Cay nogacunachrümi ganchris wauguicuna caran. Puntacagmi majachacurir manaräpis wamran captin wañuran. Wañuruptin guepancag wauguin tiyaran chay viudawan. ");
INSERT INTO qva_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Chay wauguinpis wamran manarag captin wañuran. Chauraga guepancag wauguin tiyaran chay viudawan. Paypis wañuran wamran manarag captin. Chaynuyla chay ganchris wauguincuna lapan wañuran. ");
INSERT INTO qva_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Chaypitana chay viudapis wañuran. ");
INSERT INTO qva_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Chauraga ganchris wauguiwan casarasha caycarga, wañushacuna cawarimuptin ¿mayganpa warmintag canga?” ");
INSERT INTO qva_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nipäcuptin Jesús niran: “Lutantam gamcuna yarparcanqui. Gamcuna manam musyapäcunquichu Tayta Dios escribichinganchru niycanganta y pay munayniyog canganta. ");
INSERT INTO qva_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Wañushacuna cawarimuptinga manam olgupis warmipis majachacunganachu. Chaypa truquinga gloriachru angilcunanuylanam majaynagla canga. ");
INSERT INTO qva_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Wañushacuna cawarimunanpag canganpitaga ¿Gamcuna manachu Tayta Dios escribichinganchru ninganta liyipäcushcanqui? Chaychru nin: ");
INSERT INTO qva_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Abrahampa, Isaacpa y Jacobpa Diosninmi noga caycä’. Tayta Diosga manam wañushacunapa Diosninchu sinöga cawaycagcunapa Diosninmi”. ");
INSERT INTO qva_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Chaynuy ninganta mayaycur chaychru caycag runacuna Jesús yachrachinganpita almirasha quëdapäcuran. ");
INSERT INTO qva_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Saduceo runacunata Jesús upälachinganta mayar fariseo runacuna rimanacärinanpag shuntacäpäcuran. ");
INSERT INTO qva_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Rimanacarcärirna Moisés escribingan leycunata yachracheg fariseo runa lutanta rimachiyta munar Jesusta tapuran: ");
INSERT INTO qva_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Maestro, Moisés escribingan leycunachru ¿maygan mandamientutatag mas cäsucushwan?” ");
INSERT INTO qva_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús niran: “ ‘Tayta Diosniquita lapan shonguyquipa y lapan yarpayniquiwan cuyay’. ");
INSERT INTO qva_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Cay mandamientum lapan mandamientupitapis mas cäsucunapag caycan. ");
INSERT INTO qva_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Cay mandamiento cangannuy juc mandamientupis canmi. Chay mandamiento nin: ‘Quiquiqui cuydacungayquinuy runamasiquitapis cuyay’. ");
INSERT INTO qva_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Cay ishcay mandamientuta cumplirga Moisés escribingan lapan mandamientucunata y Diospa willacognincuna escribingan lapan mandamientucunatapis cumpliycanquim”. ");
INSERT INTO qva_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseo runacuna chaychru shuntacasha caycaptilanrämi paycunata Jesús tapuran: ");
INSERT INTO qva_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“¿Gamcuna imatatag yarpäpäcunqui? ¿Pipa ayllunpitatag Dios cachramungan Salvador?” Nipäcuran: “Rey Davidpa ayllunpitam”. ");
INSERT INTO qva_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Chauraga Jesús niran: “¿Imanirtag quiquinpis David Santu Espíritu musyachiptin Dios cachramungan Salvadurta ‘Señor’ niran? David niran: ");
INSERT INTO qva_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Tayta Diosmi Señurnïta niran: Cay derëchacag lädüman jamacuy contrayqui cagcunata munayniquiman chruramungäcama’. ");
INSERT INTO qva_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Chauraga Dios cachramungan Salvadurta David ‘Señor’ niycaptinga ¿imanuypatag Dios cachramungan Salvador Davidpa ayllunpita canman?” ");
INSERT INTO qva_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Niptin manam pipis ima niytapis camäpacuranchu. Chay junagpita pacha pipis manana masta tapupayta almitirannachu. ");
INSERT INTO qva_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Chaypitanam runacunata y discïpuluncunata Jesús niran: ");
INSERT INTO qva_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Moisés escribingan leycunata yachrachegcuna y fariseo runacunam autoridäcunanuypis Moisés escribingan leycunata yachrarcächin. ");
INSERT INTO qva_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Chaynuy yachrarcächishuptiquega ¿imanirtag paycuna ninganta mana cäsucärinquichu? Ichanga paycuna cawangannuyga ama cawapäcuychu. Paycunaga rurananpag niycurpis juctam rurapäcun. ");
INSERT INTO qva_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Yachrachir paycunaga leypa jananman masta mastam yapaycan. Chay caycan fiyupa lasagta guepiparcur runamasincunata apachingannuy. Quiquincuna ichanga manam ni juc dëdulanwanpis yanapanchu. ");
INSERT INTO qva_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Paycunaga runacuna ricanalanpämi rurapäcun. Chararäpäcun Tayta Diospa mandamientuncuna escribishata cajitacunachru. Waquin runacunapita cajitacunata mas jatunta chararäpäcog Tayta Diosta cäsucog canganta runacuna ninan rayculam. Chaynuypis paycuna röpanpa chruscun cantunman paychayog bölacunata jirapäcun. Waquin runacunapita paychayog bölacunata mas jatunyarcachir chararäpäcog Tayta Diosta cäsucog canganta runacuna ninan rayculam. ");
INSERT INTO qva_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Micunanpag gayachiptinpis paycunaga punta puntamanrämi jamacuyta munapäcun. Shuntacänan wasicunachrüpis alinnin bancumanrag jamacuyta munapäcun. ");
INSERT INTO qva_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Pläzachru puripäcurpis pipis respëtuwan saludänanta paycunaga munapäcun. Chaynuypis munapäcun ‘Maestro’ nipäcunanta. ");
INSERT INTO qva_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Gamcunaga ama ashipäcuychu yachrachicog capäcungayquipita nipäcushunayquitaga. Juclaylam yachrachipäcushogniqui caycan. Lapayquipis gamcunaga chay wauguilam capäcunqui. ");
INSERT INTO qva_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Gamcunaga pitapis cay pachachru cagtaga ama ‘Tayta yachrachicog’ nipäcuychu. Yachrachicog Taytaga juclaylam. Pay cieluchrümi caycan. ");
INSERT INTO qva_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Chaynuypis gamcuna ama ashipäcuychu mandag capäcungayquipita nipäcushunayquitaga. Tayta Dios cachramungan Salvadurlam mandag caycan. ");
INSERT INTO qva_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Gamcunachru maygayquipis alipag ricasha cagcunaga lapayquipa uywayniquinuy cachun”. ");
INSERT INTO qva_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Pï maypis alitucog canganta ricachicogtaga Tayta Dios mana alimanmi chruranga. Ichanga pï maypis umillasha cagcunataga Tayta Dios alimanmi chruranga. ");
INSERT INTO qva_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“¡Moisés escribingan leycunata yachrachegcuna y fariseucuna, cuyapaypämi capäcunqui! ¡Lapayquipis yachragtucoglam carcanqui! Wasiman pipis mana yaycunanpag puncuta wichrgapagnuymi runacunata wichrgaparcanqui Tayta Diospa munayninman mana yaycunanpag. Gamcuna Tayta Diospa munayninman manam yaycurcanquichu y waquincunatapis yaycunanta amacharcanqui. ");
INSERT INTO qva_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“¡Moisés escribingan leycunata yachrachegcuna y fariseucuna, cuyapaypämi capäcunqui! ¡Lapayquipis yachragtucoglam carcanqui! Gamcuna viudacunapa wasincunata guechrurcanqui. Gamcuna runa ricashunalayquipämi Tayta Diosta may hörarag rugacurcanqui. Chaynuy rurapäcungayquipita fiyupa castïgutam chrasquipäcunqui. ");
INSERT INTO qva_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“¡Moisés escribingan leycunata yachrachegcuna y fariseucuna, cuyapaypämi capäcunqui! ¡Lapayquipis yachragtucoglam carcanqui! Gamcunaga may chaypapis aywapäcunqui fariseo cayman juclaylapis yaycunanpag yachrachegmi. Yachrachingayquita yachracurmi gamcuna lutan rurag capäcungayquipita paypis ishcay cuti mas lutan rurag canga. Chaypitam infiernuchru fiyupa castigasha canga. ");
INSERT INTO qva_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“¡Gapra caycar runacunata purichegnuypis lutanta yachrachegcuna, cuyapaypämi capäcunqui! Gamcuna nircanqui: ‘Pipis templupa jutinta jogarcur imatapis rurananpag nircur mana ruraptinpis manam imananpischu. Templo rurinchru caycag örupa jutinta jogarcur imatapis rurananpag negcagmi ichanga imaypis ruranan’. ");
INSERT INTO qva_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Mana tantiyacog y gapranuy runacuna! ¿Maygantag mas ali: öruchu o templuchu? Öro templuchru calarmi Tayta Diospag chrurasha car ali caycan. Chaymi örupitapis templo mas ali caycan. ");
INSERT INTO qva_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Chaynuypis gamcunaga runacunata yachrarcachinqui: ‘Altarpa jutinta jogarcur imatapis rurananpag nircur mana ruraptinpis manam imananpischu y altar jananchru chrurangan ofrendapa jutinta jogarcur imatapis rurananpag nirmi ichanga imaypis ruranan’ nir. ");
INSERT INTO qva_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Gapranuy runacuna! ¿Maygantag mas ali: ofrendachu o altarchu? Ofrenda altar jananman chrurasha calarmi Tayta Diospag chrurasha car ali caycan. Chaymi ofrendapitapis altar mas ali caycan. ");
INSERT INTO qva_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Altarpa jutinta jogarirga manam altarpa jutilantachu jogariycan sinöga altar jananchru chrurangan ofrendacunapa jutintapis jogariycanmi. ");
INSERT INTO qva_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Templupa jutinta jogarirga manam templupa jutilantachu jogariycan sinöga templuchru tiyag Tayta Diospa jutintapis jogariycanmi. ");
INSERT INTO qva_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Cielupa jutinta jogarirga Tayta Diospa tronunpa jutintapis jogariycan y jamacunan tronunpa jutinta jogarirga quiquin Tayta Diospa jutintapis jogariycan. ");
INSERT INTO qva_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“¡Moisés escribingan leycunata yachrachegcuna y fariseucuna, cuyapaypämi capäcunqui! ¡Lapayquipis yachragtucoglam carcanqui! Gamcuna yerbabuenapita, anispita, comïnuspita Tayta Diospag diezmuta raquircanqui. Chaynuy rurarpis manam cäsucurcanquichu mas cäsucunayquipag cag mandamientucunataga. Runamasiquiwanpis shumag cawapäcunquiman, runamasiquita cuyapäpäcunquiman y imata ruranayquipag ningayquitapis rurapäcunquiman. Chay mandamientucunata imaypis rurapäcunquiman. Chayta rurar diezmutapis mana gongaypa raquipäcunquiman. ");
INSERT INTO qva_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Gapra caycar runacunata purichegnuypis lutanta yachrachegcuna! Gamcunaga ichiclacag mandamientucunalata imaycanuypapis cäsucurcanqui. Mas cäsucunanpag cag mandamientucunataga mana cäsucur jaguiriycurcanqui. Chaynuy rurarga chuspintinta yacuta mana upunayquipag yacuta shuyshuriycur chuspita jitaringayquinuymi carcanqui y mana mayayla jatuncaray camelluta millpucurcognuymi carcanqui. ");
INSERT INTO qva_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“¡Moisés escribingan leycunata yachrachegcuna y fariseucuna, cuyapaypämi capäcunqui! ¡Lapayquipis yachragtucoglam carcanqui! Gamcunaga pusillupa y plätupa janalanta mayllashanuymi carcanqui. Chaymi pusillupa y plätupa rurin ganra cangannuyrag gamcunapis suwa cangayqui y pasaypa mana alita rurangayqui yarpayniquichru caycanrag. ");
INSERT INTO qva_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Gapranuy fariseucuna! Alilata rurar cawapäcunayquipäga puntata juchäcuycunatarag jaguiripäcuy. Chaynuy rurarga pusillupa y plätupa jananpis y rurinpis limpiu cananpänuymi rurinta mayllarcanqui. ");
INSERT INTO qva_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“¡Moisés escribingan leycunata yachrachegcuna y fariseucuna, cuyapaypämi capäcunqui! ¡Lapayquipis yachragtucoglam carcanqui! Gamcunaga yurag pintapasha nïchunuymi carcanqui. Nïchupa janan cuyaylapag captinpis rurinchrüga wañushapa tulluncuna junta y ismuycar caycan. ");
INSERT INTO qva_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Chaynuypis gamcuna runa ricashuptiqui mana musyayniquipam ali canganta yarpar rurarcanqui. Ichanga yachragtucog y lutancunalata rurag carcanqui. ");
INSERT INTO qva_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“¡Moisés escribingan leycunata yachrachegcuna y fariseucuna, cuyapaypämi capäcunqui! ¡Lapayquipis yachragtucoglam carcanqui! Gamcunaga Tayta Diospa willacognincuna pamparangan jananchru nïchuncunata rurarcanqui. Chaynuypis alilata rurag runacuna pamparangan nïchuncunata adornarcanqui. ");
INSERT INTO qva_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Chaychrünam nircanqui: ‘Chay wichan cawarga Tayta Diospa willacognincunata awillücuna wañuchiptin noganchega manam wañuchïshishwanchu caran’. ");
INSERT INTO qva_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Chaynuy nirmi quiquiquicuna tantiyacurcanqui Tayta Diospa willacognincunata wañuchegcunapa ayllun cangayquita. ");
INSERT INTO qva_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Chauraga ¡gamcunapis chay aylluyquicuna wañuchingannuy cananpis wañuchiyta ushapäcunquiman! ");
INSERT INTO qva_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“¡Culebra casta runacuna! Infiernuchru castigasha canayquipag cagpita ¿imanuyparag gueshpipäcunqui? ");
INSERT INTO qva_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Chaymi gamcunaman cachramushag Tayta Diospa willacognincunata, yachrag runacunata y yachrachegcunatapis. Gamcunaga chrasquicärinayquipa truquinga waquinta wañuchipäcunqui, crucificäpäcunqui, waquinta gamcunapa shuntacänayqui wasicunachru astipäcunqui, y waquintana gueshpiptinpis marcan marcan ashipäcunqui. ");
INSERT INTO qva_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Chaymi cay pacha camag pachapita lapan juchaynag runacunapa yawarnin jichranganpita gamcunaman castïgo chrayamunga. Chay jichrasha yawar caycan juchaynag Abelta wañuchingan pachapita asta Berequiaspa wamran Zacariasta wañuchingancama. Gamcunapa awilluyquicuna Zacariastam wañuchipäcuran templupawan altarpa chraupinchru. ");
INSERT INTO qva_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Rasunpam gamcunata nï: Chaynuy rurapäcunganpita canan wichan runacunapämi chay castïgo canga”. ");
INSERT INTO qva_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jesús niran: “¡Jerusalén runacuna! Gamcuna Tayta Diospa willacognincunata wañuchipäcushcanqui y cachramungan cagcunata sagmapäcushcanqui. Gamcunata achca cuti shuntayta munarä chipsancunata wallpa oglacunanpag shuntangannuymi. Ichanga gamcuna mana munapäcushcanquichu. ");
INSERT INTO qva_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Marcayqui jaguirisham y chunyaycagmi quëdanga. ");
INSERT INTO qva_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Gamcunata nï: Mananam yapay ricapäcamanquipänachu ‘¡Tayta Diosninchi cachramungan runa alabasha cayculächun!’ nipäcungayquicama”. ");
INSERT INTO qva_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Templupita Jesús yargamuran. Chaypita aywacuycaptinna Jesuscagman discïpuluncuna ashuycapäcuran templo canganchru wasicunata ricachipäcunanpag. ");
INSERT INTO qva_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Chauraga Jesús niran: “Cay lapanta gamcuna ricarcanqui, ¿au? Ichanga rasunpam gamcunata nï: Manam ni juc rumilapis canan pergaraycangannuyga quëdangachu. Lapanmi juchruchisha canga”. ");
INSERT INTO qva_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Chaypitana Olivos jutiyog lömachru Jesús jamaycuptin discïpuluncuna quiquilancuna caycarna tapuran: “Willapäcamay. Nipäcamangayquinuy ¿imaytag canga? ¿Cutimunayquipäna y cay pacha ushacänanpäna imatag canga?” ");
INSERT INTO qva_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Chauraga Jesús niran: “Cuydädu pipis engañarärishunquiman. ");
INSERT INTO qva_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Achcagmi nogatucular shapäcamunga: ‘Nogaga Tayta Dios cachramungan Salvador caycä’ nir. Chaynuy nirmi achcagta engañäpäcunga. ");
INSERT INTO qva_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Gamcuna mayapäcunqui guërra caycagta o ‘Guërrash caycan’ nipäcogta. Chayta mayarpis ama mancharipäcunquichu. Puntataga chaycunarämi canga. Ichanga cay pacha manarämi ushacangarächu. ");
INSERT INTO qva_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Juc naciunwan juc naciunmi y juc munayniyogwan juc munayniyogmi guërrachru canga. May chaychrüpis muchruy canga; terremötu canga. ");
INSERT INTO qva_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Chaynuy captinpis nacanapäna galaycunalanrämi warmi gueshyacunanpag nanaynin galaringannuymi canga. ");
INSERT INTO qva_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Chay wichan runacuna entregäpäcushunqui nacachishunayquipag y wañuchipäcushunayquipag. Lapan naciunchru runacunam noga janan chriquipäcushunqui. ");
INSERT INTO qva_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Chaynuy captinna nogaman yäracaycämanganpita achcag manana yäracamanganachu. Quiquinpuram autoridäcunapa maquinman entreganacäringa y chriquinacäringa. ");
INSERT INTO qva_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Chaynuypis Tayta Diospa willacognintucular runacuna ricacämunga. Achcagtam engañäpäcunga. ");
INSERT INTO qva_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Waranpa waranpa mas achca runacuna mana alita rurar cawapäcuptinmi achcag manana cuyanacäringanachu. ");
INSERT INTO qva_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nacarpis wañungancama mana yamacaypa yäracamagcagmi ichanga salvacunga. ");
INSERT INTO qva_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Tayta Diospa munayninman chrayanapag ali willacuynin may chaymanpis willacusha canga. Chaynuypa lapan naciunchru runacuna willacuyninta mayapäcunga. Chaypitana cay pacha ushacanga. ");
INSERT INTO qva_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Tayta Diospa willacognin Daniel escribingannuylam templo rurichru Tayta Diospag pasaypa millanaypag caycagta ricapäcunqui. (Cay escribingäta liyegcäga shumag tantiyacuchun.) ");
INSERT INTO qva_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Chaynuy captinna Judea provinciachru tiyagcuna jircacunaman gueshpicärichun. ");
INSERT INTO qva_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Wasin jananchru cagcunapis imanta jorgunalanpäpis ama yarpamuchunchu ni wasinman ama yaycuchunchu. ");
INSERT INTO qva_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Chracrachru caycagcunapis janancag röpanta jorgunalanpäpis wasinman ama cutimuchunchu. ");
INSERT INTO qva_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Chay junagcuna cuyapaypämi capäcunga chrichru warmicuna y chuchuycag wawayog warmicuna! ");
INSERT INTO qva_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Tayta Diosta rugacäriy tamya quilla wichan ni sábado jamay junag gueshpinayqui höra mana chrayamunanpag. ");
INSERT INTO qva_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Chay wichan fiyupam nacay canga. Tayta Dios camanganpita pacha manam imaypis chay nacaynuyga canrächu. Chaynuypis manam yapayga chaynuy nacaycuna canganachu. ");
INSERT INTO qva_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","“Tayta Diosninchi chay junagcunata rätu mana pasachiptinga pipis manam cawanmannachu. Acrashacuna Tayta Diosman yäracuycagcuna raycu ichanga rätu pasachinga. ");
INSERT INTO qva_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Pipis gamcunata ‘Ricay, caychru caycan Tayta Dios cachramungan Salvador’ o ‘Wacchru caycan Dios cachramungan Salvador’ nipäcushuptiquipis ama criyipäcunquichu. ");
INSERT INTO qva_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tayta Dios cachramungan Salvadurtucular y Tayta Diospa willacognintucular runacunam aywamunga. Chay runacunapis milagrucunata ruranga. Chaynuypa acrashacuna Tayta Diosman yäracuycagcunatapis engañayta munapäcunga. ");
INSERT INTO qva_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Manarag pasaptinmi gamcunataga willapashcä. ");
INSERT INTO qva_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Chauraga pipis: ‘Tayta Dios cachramungan Salvador chunyag jircachrümi caycan’ nipäcushuptiquipis ama aywapäcunquichu. Chaynuypis ‘Wasi rurichru pacaraycan’ nipäcushuptiquipis ama criyipäcunquichu. ");
INSERT INTO qva_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Inti yargamunan lädupita inti yaycunan läducama ilagu achicyanganta ricapäcungannuymi noga Diospita shamusha Runa cutimuptï lapan runacuna ricapäcunga. ");
INSERT INTO qva_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Wañusha uywa jitaragman wisculcuna shuntacaycagta ricapäcungannuymi noga Diospita shamusha Runa cutimungäta lapan runacuna musyapäcunga”. ");
INSERT INTO qva_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Cay fiyupa nacay junagcuna pasariycuptinnam intipis chacacäcunga y quillapis manana achicyanganachu. Estrëllacunapis cielupita shicwamunga y cieluchru munayniyogcunapis sicsicyanga. ");
INSERT INTO qva_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Chaychrünam cieluchru noga Diospita shamusha Runa aywamunäpag cag señalta ricapäcunga. Chayta ricarmi may chaychrüpis runacuna wagapäcunga. Chaypita noga Diospita shamusha Runata pucutay jananchru y chipipaycar pasaypa munaynïwan aywaycämogta ricapäcamanga. ");
INSERT INTO qva_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Chauraga cornëtata fiyupa tucarimuptinmi noga Diospita shamusha Runa angilnïcunata cachrashag acrangäcagcunata may chaypitapis shuntamunanpag. ");
INSERT INTO qva_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Hïgus yürata imanuypis canganta ricar tantiyacärinqui: Rämancuna verdiyayta y öjancuna chinliyta galaycuptin tamya quilla galaycunanpäna canganta musyapäcunqui. ");
INSERT INTO qva_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Chaynuylam chay ningäcuna pasaptin musyapäcunqui noga Diospita shamusha Runa cutimunäpäna caycangäta. ");
INSERT INTO qva_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Rasunpam gamcunata nï: Cay lapan chaynuy canga manaräpis canan wichan runacuna wañuptinmi. ");
INSERT INTO qva_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Cielupis y cay pachapis ushacangam. Noga ningäcunam ichanga mana ushacangachu. ");
INSERT INTO qva_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Pipis manam musyanchu imay junag ima höra chaycuna pasananpag canganta ni cieluchru caycag angilcunapis ni noga Diospa Wamranpis. Chaytaga quiquin Tayta Dioslam musyan. ");
INSERT INTO qva_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Noé cawanan wichan pasangannuymi noga Diospita shamusha Runawanpis pasanga. ");
INSERT INTO qva_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Chay wichan diluviu manaräpis captin asta Noé arcanman yaycungan junagcama runacunaga micur, upur y majachacur caycaran. ");
INSERT INTO qva_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ichanga ima pasanantapis lapan runacuna mana musyapäcuranchu. Chaymi mana musyangan junag diluviu chrayamuptin shengaypa lapan wañuran. Noga Diospita shamusha Runa cutimuptin chaynuylam canga. ");
INSERT INTO qva_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Chay junagmi chracrachru ishcay runacuna aruycagpita jucagninta apacunga y jucagninta jaguiriycunga. ");
INSERT INTO qva_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ishcay warmicuna agacuycagpita jucagninta apacunga y jucagninta jaguiriycunga. ");
INSERT INTO qva_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Gamcuna ichanga mayag mayagla carcay. Manam musyapäcunquichu imay junag Señurniqui shamunanpag cangantapis. ");
INSERT INTO qva_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Musyapäcungayquinuypis suwa ima höra yaycunanta musyarga wasiyog mayag mayaglam canman wasinman pitapis mana yaycachinanpag. ");
INSERT INTO qva_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Chaynuy gamcunapis mayag mayagla camaricusha carcay. Noga Diospita shamusha Runaga mana yarpangayqui höram cutimushag”. ");
INSERT INTO qva_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Patron illänanpäga yäracungan y shumag yachrag uywayninpa munayninmanmi waquincag uywayninta garananpag chruran. ");
INSERT INTO qva_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Cushicungam chay uyway lapan rurananpag ningancunata ruraycagta patrunnin tariptinga. ");
INSERT INTO qva_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Rasunpam gamcunata nï: Chaynuy alita ruranganpita patrunnin chay uywaypa munayninman chruranga lapan imaycantapis ricananpag. ");
INSERT INTO qva_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ichanga fiyu uyway carga ‘Patrunnï manarämi cutimungarächu’ nir ");
INSERT INTO qva_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","waquin uyway masincunata magayta y borrächucunawan shuntacaycur micacäriyta y upyacäriyta galaycuycan. ");
INSERT INTO qva_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Chaynuy caycaptin mana yarpangan junag y mana musyangan höra patrunnin cutimunga. ");
INSERT INTO qva_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Cutimurna patrunnin mana cuyapaypa castiganga y yachragtucogcuna castïguchru caycanganman chay uywaytapis chruranga. Chaychrünam pasaypa wagar laquicuypita quiruntapis cachrupäcunga. ");
INSERT INTO qva_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Tayta Diospa munayninman yaycunapag junag chrayamuptin casaray fiestaman yaycunanpag caynuy cangannuymi canga. Chrunca jipashcuna aceitiwan rupag michërunwan casaracog mösuta shuwarag aywapäcuran. ");
INSERT INTO qva_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pichgacag jipashcunaga mana yarpachracuypa camaricüni shuwaräpäcuran. Y pichgacag jipashcunaga shumag yarpachracurir camaricurcur shuwaräpäcuran. ");
INSERT INTO qva_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Camaricüni shuwarag jipashcunaga michërunta aparpis aceitita mana apapäcuranchu michërunman yapay wiñananpag. ");
INSERT INTO qva_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Camaricusha shuwarag jipashcuna ichanga michërunta aparpis botëllawan mas aceititapis aparan. ");
INSERT INTO qva_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Casaracog mösu mana chrayaptin shuwararcangalanchru lapan puñucäpäcuran. ");
INSERT INTO qva_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Puñucasha carcaptinna pulan pagasmannuyga caynuy gayacamungan mayacämuran: ‘¡Casaracog mösu aywaycämunnam! ¡Yargapäcamuy chrasquicärinayquipag!’ ");
INSERT INTO qva_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Chauraga lapan jipashcuna sharcurcur michërunta shumag camaricäriran chrasquicärinanpag. ");
INSERT INTO qva_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Chaychrümi camaricüni cag jipashcuna camaricusha cag jipashcunata niran: ‘Michërücunaman yapanäpag aceitiquita raquipäpäcamay. Michërücuna upinaycanna’. ");
INSERT INTO qva_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Chauraga camaricusha cag jipashcunaga niran: ‘Manam raquipäpäcümanchu. Gamcunata raquipäpäcuptïga nogacunapag pishinga y gamcunapäpis pishinga. Asta jucla aceite ranteg aywapäcuy quiquiquicunapa cananpag’. ");
INSERT INTO qva_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Chay pichgan jipashcuna aceite ranteg aywapäcungancamana casarag mösu chrayaran. Chrayaruptinna camaricusha caycag pichgacag jipashcuna casaragwan casaray fiestaman yaycapäcuran. Yaycaräriptinna puncuta wichrgariycamuran. ");
INSERT INTO qva_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Aceite rantimunganpita cutirna puncu wichrgaraycagta tariycur gayacäriran: ‘¡Tayta, tayta, puncuyquita quichrapaycalämay!’ nir. ");
INSERT INTO qva_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Chauraga casarag mösu nimuran: ‘Rasunpam gamcunata nï: Gamcunataga manam reguïchu’ ”. ");
INSERT INTO qva_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Chaynuy willaparcurna Jesús niran: “¡Gamcunaga mayag mayagla carcay! Manam musyapäcunquichu imay junag ni ima höra cutimunäpag cangantapis”. ");
INSERT INTO qva_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Tayta Diospa munaynin canga juc patron juc lädupa aywacur uywaynincunata gayaycur aruchinanpag guellayta aypungannuymi. ");
INSERT INTO qva_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Uywaynin imanuypis canganta ricapärir jucnincag uywayninta goran pichga waranga (5,000) öro guellayta, jucninta ishcay waranga (2,000) öro guellayta y jucnintana goran juc waranga (1,000) öro guellayta. Nircurna juc lädupa aywacuran. ");
INSERT INTO qva_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Pichga waranga guellayta chrasquegcäga jucla chayta aruchiyta galaycuran. Chaychrüna pichga waranga masta gänaran. ");
INSERT INTO qva_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ishcay waranga guellayta chrasquegcagpis ishcay waranga masta gänaran. ");
INSERT INTO qva_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Juc waranga guellayta chrasquegcag ichanga aywaran pampata uchrcog. Nircurna patrunnin aypungan guellayta pampaycamuran. ");
INSERT INTO qva_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Chaypita watacuna pasarcuptinna patrunnin cutimuran. Chaychrüna aypungan guellaynincuna imanuy cangantapis uywaynincunata tapuran. ");
INSERT INTO qva_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Puntata pichga waranga guellay chrasquegcag pichga waranga mas guellayta cutiycachinanpag apamur niran: ‘Tayta, ¡ricay! Pichga waranga guellayta gomangayquipita gänashcä pichga waranga masta’. ");
INSERT INTO qva_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Chauraga patrunnin niran: ‘Alim. Ali rurangayquipitam gam shumag ali y yäracuypag uywaynï canqui. Walcalawanpis alitam rurashcanqui. Cananga mas achcamanmi chrurashayqui. Gampis noganuy cushicuy’. ");
INSERT INTO qva_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Chaynuy ishcay waranga guellay chrasquegcagna niran: ‘Tayta, ¡ricay! Ishcay waranga guellayta gomangayquipita gänashcä ishcay waranga masta’. ");
INSERT INTO qva_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Chauraga patrunnin niran: ‘Alim. Ali rurangayquipitam gam shumag ali y yäracuypag uywaynï canqui. Walcalawanpis alitam rurashcanqui. Cananga mas achcamanmi chrurashayqui. Gampis noganuy cushicuy’. ");
INSERT INTO qva_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Juc waranga guellayta chrasquegcag uywayninga niran: ‘Tayta, noga musyämi mana cuyapäcog cangayquita. Gamga mana murungayquipitam cosechanqui y mana mashtangayquipitam palanqui. ");
INSERT INTO qva_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Chaymi gamta manchacur guellayniquita pampaycurä. Gomangayquinuyla guellayniqui caychru caycan’. ");
INSERT INTO qva_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Chauraga patrunnin niran: ‘¡Fiyu y guella uywaymi canqui! Gam musyarayquim mana murucungäpita cosechangäta y mana mashtangäpita palangäta. ");
INSERT INTO qva_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Chaynuy caycaptïga bancuman guellaynïta chruranquiman caran. Cutimurna interesnintinta guellaynïta shuntacüman caran’. ");
INSERT INTO qva_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nircurna chaychru caycag runacunata niran: ‘¡Guechrupäcuy chay waranga guellayta! ¡Nircur goycäriy chrunca waranga guellay chararagcagta! ");
INSERT INTO qva_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Chaymi charagcäga masta chrasquinga puchuy puchuy achcata chararänanpag. Mana charagcunam ichanga ichicla chararangalantapis guechrusha canga. ");
INSERT INTO qva_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Cay mana väleg uywaytaga wagta pasaypa yananyaycagman gargapäcuy. Chaychrünam pasaypa wagar laquicuypita quiruntapis cachrupäcunga’. ");
INSERT INTO qva_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Noga Diospita shamusha Runa chipipaycar y angilcunawan cutimurmi chipipaycag tronüman lapan munaynïwan jamacushag. ");
INSERT INTO qva_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Chaymannam may chay naciunpitapis lapan runacuna nogapa ñaupagnïman shuntacämunga. Chaychrünam jucninta jucnintapis raquishag cabracunapita üshacunata micheg raquingannuy. ");
INSERT INTO qva_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Chaychrünam nogaman yäracur üshanuy cagcunata derëchäman raquishag y mana yäracur cabranuy cagcunata ichognïman raquishag. ");
INSERT INTO qva_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Chaynuy raquircurnam derëchanchru cagcunata mandag Rey ninga: ‘Taytä cuyangancuna shapäcamuy. Yaycapäcuy munayninman. Chayta gamcunapag camarisha cay pachata camanan wichanmi. ");
INSERT INTO qva_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Micanaptïpis gamcunam micuyta gopäcamashcanqui. Yacunaptïpis gamcunam gopäcamashcanqui. Pachacuyta ashiptïpis gamcunam pachachipäcamashcanqui. ");
INSERT INTO qva_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Röpaynag captïpis gamcunam röpata gopäcamashcanqui. Gueshyaptïpis gamcunam jampipäcamashcanqui. Carcilchru captïpis gamcunam aywamushcanqui ricamänayquipag’. ");
INSERT INTO qva_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Chauraga Tayta Dios munangannuy rurag runacuna tapunga: ‘Tayta, micanar ¿imaytag purishcanqui micuyta gopäcunäpag? Yacunar ¿imaytag purishcanqui yacuta gopäcunäpag? ");
INSERT INTO qva_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Pachacuyta ¿imaytag ashishcanqui pachachipäcunäpag? Röpaynag ¿imaytag purishcanqui röpata gopäcunäpag? ");
INSERT INTO qva_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Imaytag gueshyashcanqui jampipäcunäpag o carcilchru cashcanqui ricag aywapäcamunäpag?’ ");
INSERT INTO qva_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Chaynuy nipäcuptinmi mandag Rey ninga: ‘Rasunpam gamcunata nï: Maygalantapis cay mana runatucog wauguïcunata panïcunata imalachrüpis yanapasha carga nogata yanapämagnuymi yanapäpäcushcanqui’. ");
INSERT INTO qva_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Nircurnam ichogninchru caycag runacunata ninga: ‘¡Lädupita ashucäriy! Gamcuna fiyupa nacanayquipämi caycan. Gamcuna aywanqui Satanaspag y diabluncunapag camarisha caycag infiernumanmi. ");
INSERT INTO qva_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Micanaptïpis gamcunaga manam micuyta gopäcamashcanquichu. Yacunaptïpis yacuta manam gopäcamashcanquichu. ");
INSERT INTO qva_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Pachacuyta ashiptïpis gamcunaga manam pachachipäcamashcanquichu. Röpaynag captïpis röpata mana gopäcamashcanquichu. Gueshyaptïpis y carcilchru captïpis ricamag manam shapäcamushcanquichu’. ");
INSERT INTO qva_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Chauraga paycunapis nipäcunga: ‘Tayta, nogacuna imaypis manam micanaycagta, yacunaycagta, pachacuyta ashiycagta, röpaynagta, gueshyaycagta, carcilchru caycagta ricapäcushcächu yanapäpäcunäpag’. ");
INSERT INTO qva_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Chauraga chay mandag Rey ninga: ‘Rasunpam gamcunata nï: Maygalantapis cay mana runatucog wauguïcunata panïcunata imalachrüpis mana yanapasha carga nogata mana yanapämagnuymi mana yanapashcanquichu’ ”. ");
INSERT INTO qva_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Chaynuy Jesús willaparcur niran: “Chay mana cuyapäcog runacunaga mana ushacag castïgumanmi aywapäcunga. Tayta Dios munangannuy ruragcunam ichanga mana ushacaypa cawayman aywapäcunga”. ");
INSERT INTO qva_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Willapayta usharcurna discïpuluncunata Jesús niran: ");
INSERT INTO qva_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Musyapäcungayquinuypis Pascua fiesta galaycunanpag ishcay junaglanam pishiycan. Chaychrümi noga Diospita shamusha Runa entregasha cashag crucificasha canäpag”. ");
INSERT INTO qva_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Chay junagcuna cüracunapa mandagnincuna y Israel mayor runacuna cüracunapa mas mandagnin Caifaspa wasinman shuntacaran. ");
INSERT INTO qva_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Chaychrümi parlanacäriran ima engäñulawanpis Jesusta prësu charircachir wañuchipäcunanpag. ");
INSERT INTO qva_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ichanga nipäcuran: “Ama charishunchu fiestachrüga. Chaychru charishaga runacuna rabyar contranchi sharcurunmanmi”. ");
INSERT INTO qva_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús Betania marcachru caycar “gueri gueshyag” nipäcungan Simonpa wasinchru caycaran. ");
INSERT INTO qva_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Chaymanmi juc warmi alabastrupita rurasha botëllanwan chrayaran. Chay botëllachru chranin väleg perfümim wiñararan. Nircurna mësa lädunchru Jesús caycagman ashuycurir umanman chay warmi perfümita gaycaparan. ");
INSERT INTO qva_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Discïpuluncuna chaynuy ruragta ricar rabyar nipäcuran: “¿Imapätag chay perfümita perdicächin? ");
INSERT INTO qva_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Chaypa truquinga ali canman caran ali preciuchru ranticunanpag. Nircurna chayta pobricunata aypunapag”. ");
INSERT INTO qva_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ninganta mayarmi Jesús niran: “¿Imanirtag cay warmita rabyarcächinqui? Cay warmi shumag alitam rurasha. ");
INSERT INTO qva_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Pobricuna yanapäpäcunayquipag gamcunachru imaypis caycangam. Nogam ichanga gamcunawan manana cashäpänachu. ");
INSERT INTO qva_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Cay warmi janäman perfümita gaycapämar camariycäman wañur pampacunäpänam. ");
INSERT INTO qva_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Rasunpam gamcunata nï: May chaychrüpis ali willacuyta willacunganchru cay warmi chaynuy ruranganpita parlapäcungam. Chaynuypam chay warmipita mana gongapäcungachu”. ");
INSERT INTO qva_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Chrunca ishcay (12) discïpulunpita jucnincag Judas Iscariote jutiyog cüracunapa mandagnincunaman aywaran. ");
INSERT INTO qva_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Chaychrümi paycunata niran: “¿Imatatag gamcuna gopäcamanqui Jesusta noga entregaptï?” Paycuna gopäcuran quimsa chrunca (30) yurag guellayta. ");
INSERT INTO qva_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Chay hörapita Judas yarpachracuran ima höra Jesusta entregänanpag cangantapis. ");
INSERT INTO qva_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Levadüraynag tantata micunan fiesta galaycunan junag discïpuluncuna Jesuscagman ashuycurir nipäcuran: “¿Maychrütag gampag camaripäcamushag Pascua cënata micunayquipag?” ");
INSERT INTO qva_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Pay niran: “Jerusalenman aywapäcuy. Chay runaman chrayaycur nipäcunqui: ‘Maestrum nin: Nogapag Tayta Dios chrurangan höram chrayaycämunna. Chaymi discïpulücunawan Pascua cënata wasiquichru micushag’ ”. ");
INSERT INTO qva_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jesús ningannuyla discïpuluncuna rurapäcuran. Y Pascua cënata camaripäcuran. ");
INSERT INTO qva_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Pacha chacaruptinna chrunca ishcay (12) discïpuluncunawan mësachru Jesús caycaran. ");
INSERT INTO qva_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Micurcarnam Jesús niran: “Rasunpam gamcunata nï: Gamcunapita jucniquim chriquimagnïcunaman entregämanga”. ");
INSERT INTO qva_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Paycuna pasaypa laquicäriran. Chaymi jucnin jucninpis Jesusta tapuyta galaycäriran: “¿Tayta, nogachurag caycä?” ");
INSERT INTO qva_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesús niran: “Plätuchru nogawan igual tantata ushmachisha cagmi chriquimagnïcunaman entregämanga. ");
INSERT INTO qva_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tayta Dios escribichinganchru ningannuylam noga Diospita shamusha Runa wañushag. Chay entregämag runam ichanga cuyapaypag canga. Chay runapag mas ali canman caran mana yurinanpag”. ");
INSERT INTO qva_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Chauraga chriquegninman entregänanpag caycag Judas tapuran: “¿Maestro, nogachurag caycä?” Niptin Jesús niran: “Quiquiquim nishcanqui”. ");
INSERT INTO qva_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Paycuna micurcanganchru tantata aptarcur Tayta Diosta Jesús agradecicuran. Nircurna partirir discïpuluncunata caynuy nir aypuran: “Cä, micapäcuy. Cayga cuerpümi”. ");
INSERT INTO qva_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nircur vïnuyog cöpata aptarcur Tayta Diosta agradecicurir discïpuluncunata goran: “Lapayqui cay cöpapita upupäcuy. ");
INSERT INTO qva_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Cay vïnoga yawarnïmi. Caywanmi runawan Tayta Dios conträtuta ruranga. Yawarnïmi jichrasha canga juchancunapita achcag perdunasha cananpag. ");
INSERT INTO qva_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Gamcunata nï: Yapayga manam vïnuta upushänachu Taytäpa munayninchru gamcunawan mushog vïnuta upungäcama”. ");
INSERT INTO qva_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Salmucunata cantarcärirnam Olivos lömaman aywacäriran. ");
INSERT INTO qva_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jesús niran: “Canan chacay noga janan nogaman yäracarcämangayquipita lapayqui jaguiriycärimanqui. Tayta Dios escribichinganchru niycan: ‘Üsha michegta wañuycachiptï üshancuna mashtacäcungam’. ");
INSERT INTO qva_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ichanga cawarircamur gamcunapita mas puntatam Galileaman aywashag”. ");
INSERT INTO qva_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedro payta niran: “Waquincag gamman yäracurcäshungayquipita jaguiriycärishuptiquipis nogaga manam imaypis jaguirishayquichu”. ");
INSERT INTO qva_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Pedruta Jesús niran: “Rasunpam gamta nï: Canan chacay manarag gällu cantaptinmi quimsa cutina reguimangayquita niegamanqui”. ");
INSERT INTO qva_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Chauraga Pedro niran: “¡Ishcanchita wañuchimänanchi captinpis manam niegashayquichu!” Lapan waquincag discïpuluncunapis chaynuylam nipäcuran. ");
INSERT INTO qva_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Chaypitana Jesús discïpuluncunawan Getsemaní jutiyog chracraman aywapäcuran. Chrayaycur discïpuluncunata niran: “Caylachru jamararcay Tayta Diosta washachru rugacamungäcama”. ");
INSERT INTO qva_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nircurna Pedruta y Zebedeupa ishcan wamrancunata pushacurcur aywaran. Chaychrüna pasaypa laquicuyta galaycuran. ");
INSERT INTO qva_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Jesús paycunata niran: “Wañupacusha nirag shongüman pasaypa laquicuy chrayaramun. Caylachru nogawan ricchaycar shuwararcämay”. ");
INSERT INTO qva_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nircurna mas wac läduman aywaran. Chaychrüna Tayta Diosta rugacunanpag gongurpacuycur uysucuycuran urcunpis pampaman tüpangancama. Caynuy rugacuran: “Taytalä, gam munarga cay nacanäpag caycagpita jorgaycalämay. Ichanga noga munangänuyga ama cachunchu, sinöga gam munangayquinuy cayculächun”. ");
INSERT INTO qva_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Chaypita quimsan discïpuluncuna caycangancagman cutiran. Paycunata puñucasha carcagta tariran. Pedruta niran: “¿Manachu juc höralapis nogawan ricchayta puedipäcushcanqui? ");
INSERT INTO qva_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ricchapäcuy y Tayta Diosta rugacäriy juchäcuyman mana chrayapäcunayquipag. Ali rurayta munarpis quiquiquicunalaga manam camäpacunquichu”. ");
INSERT INTO qva_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yapay cutiran Tayta Diosta rugacamunanpag. Caynuy rugacuran: “Tayta, nacanärag captinga gam munangayqui ruracächun”. ");
INSERT INTO qva_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Cutirpis discïpuluncunata yapay puñucasha caycagta tariran. Puñucäpäcuran ñawincuna manana ricchayta awantaptin. ");
INSERT INTO qva_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yapay paycunata jaguiycur quimsacag cutina Tayta Diosta rugacog aywaran. Chaychrüpis puntacagchru rugacungannuyla yapay rugacuran. ");
INSERT INTO qva_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Chaypitana discïpuluncuna cagman cutiycur niran: “¿Gamcuna cananpis puñuycanquirächu y jamaycanquirächu? Höra chrayamushana noga Diospita shamusha Runa juchäcog runacunapa maquinman entregasha canäpag. ");
INSERT INTO qva_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Sharcapäcuy, aywacushunna! Aywaycämunna entregämänanpag cag runa”. ");
INSERT INTO qva_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús parlaycaptinrämi Judas achca runacuna pushasha chrayaran. Judas caran chrunca ishcay (12) discïpuluncunapita jucnincag. Chay pushangan runacuna caran espädanwan garrutinwan. Cay runacunata cachrasha caran cüracunapa mandagnincuna y Israel mayor runacuna. ");
INSERT INTO qva_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Chayman manarag chrayarmi entregänanpag cag Judas chay runacunata niran: “Maygantapis muchaycungäcagmi canga. Paytam charipäcunqui” nir. ");
INSERT INTO qva_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Chrayaycurna Jesuscagman jucla ashuycur saludaran: “Maestro, ¿imanuylatag?” Nir muchaycuran. ");
INSERT INTO qva_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Chauraga Jesús niran: “Amïgo, ¿imamantag shamushcanqui?” Niptinna waquincag runacunaga Jesusta jucla prësu charipäcuran. ");
INSERT INTO qva_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Chaychrümi Jesuswan caycagcunapita jucnincag discïpulun espädanta jorgurir cüracunapa mas mandagninpa uywayninpa rinrinta roguriycuran. ");
INSERT INTO qva_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesús payta niran: “Chruraränanman espädayquita cutichiy. Pipis espädawan pelyagcäga espädawanmi wañuchisha canga. ");
INSERT INTO qva_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Gam manachu musyanqui Taytäta rugacuptïga washämänanpag chrunca ishcay (12) tröpa angilcunapita mas angilcunata cachramunanpag canganta? ");
INSERT INTO qva_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Chaynuy captinga Tayta Dios escribichinganchru ningancuna manam cumplingachu. Nogawan ima pasananpag cagpis maynam escribiraycanna”. ");
INSERT INTO qva_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nircurna chay runacunata Jesús niran: “¿Imanirtag gamcuna saltiador captïnuypis espädayquiwan y garrutiquiwan prësu charipäcamänayquipag shapäcamushcanqui? Waran warantag gamcunawan templuchru yachrachirä. Imaypis manam charipäcamarayquichu. ");
INSERT INTO qva_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Caynuy lapan ruracaycan Tayta Diospa willacognincuna escribipäcungan cumplinanpämi”. Chay höra lapan discïpuluncuna Jesusta jaguiriycur gueshpir aywacäriran. ");
INSERT INTO qva_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Prësu charegcuna Jesusta apapäcuran cüracunapa mas mandagnin Caifaspa wasinman. Chaychrümi Moisés escribingan leycunata yachrachegcuna y Israel mayor runacuna shuntacasha caycaran. ");
INSERT INTO qva_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro caru guepalanta Jesusta gatiraran cüracunapa mas mandagninpa wasinpa sawan ruricama. Chaychrünam templo cuydag wardiacunawan jamacuycuran imata rurapäcungantapis ricananpag. ");
INSERT INTO qva_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Cüracunapa mandagnincuna y Israel mayor autoridäcuna pilapis Jesuspa contran casquicuypa rimananpag ashircaran “wañuchisha cachun” nipäcunanpag. ");
INSERT INTO qva_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Achcag runacuna ashuycur Jesús imata ruranganta o parlanganta willapäcuptinpis juchanta manam taripäcuranchu. Ichanga ishcay runacuna ashuycur ");
INSERT INTO qva_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Jesuspag niran: “Cay runa nisha Tayta Diospa templunta juchrurcachir quimsa junagtaga yapay sharcarichinanpag canganta”. ");
INSERT INTO qva_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Chauraga cüracunapa mas mandagnin ichrircur Jesusta tapuran: “¿Imatapis manachu ninqui? ¿Imanirtag gampa contrayqui chaynuy nircäshunqui?” ");
INSERT INTO qva_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Niptinpis Jesús upälalam cacuran. Cüracunapa mas mandagnin niran: “Cawaycag Diospa ñaupagninchrümi caycanchi. Gamta nï rasunpa cagta willapäcamänayquita. ¿Gamchu Dios cachramungan Salvador y Diospa Wamran caycanqui?” ");
INSERT INTO qva_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús niran: “Gam nishcanqui. Gamcunatana nï: Cananpitaga noga Diospita shamusha Runata ricapäcamanqui imaycapäpis munayniyog Tayta Diospa derëchacag lädunchru mandanäpag jamaraycagtam. Chaynuypis ricapäcamanqui pucutay jananchru aywaycämogta”. ");
INSERT INTO qva_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Chauraga cüracunapa mas mandagnin rabyapita röpantapis rachririycur niran: “¡Cay runaga Tayta Diospa contran lutanta rimasha! ¡Imapänatag pitapis ashishun imata rurangantapis ninanpag! Gamcuna mayarärinquinam imata ningantapis. ");
INSERT INTO qva_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Cananga imanipäcunquitag?” Chaychru caycag autoridäcuna nipäcuran: “¡Juchayogmi! ¡Wañuchisha cachun!” ");
INSERT INTO qva_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Chaypita chaychru caycag runacuna cäranman togapäpäcuran y cutapäcuran. Waquinnam cäranchru lagyapäcuran. ");
INSERT INTO qva_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Y nipäcuran: “Tayta Dios cachramungan Salvador caycarga willacog car nimay: ¿Pitag magashushcanqui?” ");
INSERT INTO qva_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Chaycamaga sawan rurichru Pedro jamaraycaran. Chaymanmi uyway jipash ashuycurir niran: “Galileapita Jesuswan gampis puriycarayqui”. ");
INSERT INTO qva_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Chauraga lapan runacuna mayaycaptin Pedro niegar niran: “Manam musyächu imapita niycämangayquitapis”. ");
INSERT INTO qva_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Chaypita puncu yaycunaman aywacuran. Chaychrüpis juc uyway jipash ricaycur waquin runacunata niran: “Paypis Nazaretpita Jesuswan puriycaran”. ");
INSERT INTO qva_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Niptin Pedro jurar yapay niegaran: “¡Noga chay runataga manam reguïchu!” ");
INSERT INTO qva_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mas rätunmanna chaychru caycag runacuna ashuycur Pedruta nipäcuran: “¡Gampis paycunawan puregmi caycanqui! Rimacuyniquipis Galileacunapa niraycanmi”. ");
INSERT INTO qva_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Chauraga pay juraran: “¡Manam reguïchu chay runata! Casquicuptïga quiquï castigasha cashag”. Chaynuy niruptilannam gällu cantariycamuran. ");
INSERT INTO qva_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Chauraga Pedro yarparan Jesús ninganta: “Manarag gällu cantaptinmi quimsa cutina reguimangayquita niegamanqui”. Chay ninganta yarpacurcurmi Pedro chaypita yargurir pasaypa laquicur wagaran. ");
INSERT INTO qva_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pacha wararuptinna lapan cüracunapa mandagnincuna y Israel mayor runacuna shuntanacuycur rimanacäriran Jesús wañuchisha cananpag. ");
INSERT INTO qva_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Chaypitana Jesusta watacurcur apapäcuran. Nircurna gobernador Pilätuman entregäpäcuran. ");
INSERT INTO qva_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Chriquegnincunaman entregag Judas wañuchisha Jesús cananpag nipäcunganta mayaycur ima ruraytapis mana atiparna fiyupa laquicuran. Chaymi quimsa chrunca (30) guellay chrasquinganta cüracunapa mandagnincunata y Israel mayor runacunata cutiycachiran. ");
INSERT INTO qva_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Cutiycachirmi niran: “Juchaynag runa wañuchisha cananpag entregar juchäcushcämi”. Chauraga paycuna nipäcuran: “¡Imanuypis cacuy! ¡Nogacunata imata gocäriman!” ");
INSERT INTO qva_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Chauraga chrasquingan guellayta templuman jitariycur aywacuran. Aywacurcurna jurcacamuran. ");
INSERT INTO qva_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Cüracunapa mandagnincuna chay guellayta shuntarcur nipäcuran: “Cay guellaytaga manam taluchishwanchu ofrendacuna guellaymanga. Cay guellayga runapa preciunmi”. ");
INSERT INTO qva_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Rimanacarcärirna chay guellaywan “Mitupita manca rurag runapa chracran” nipäcunganta rantipäcuran jäpa runa wañuptin chayman pampapäcunanpag. ");
INSERT INTO qva_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Jesusta wañuchinanpag entregänanpag guellay päganganwan rantisha captinmi chay chracrata canancama nipäcun “Yawar Pampa”. ");
INSERT INTO qva_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Chaynuypa cumpliran willacognin Jeremiaswan Tayta Dios escribichingannuy: “Quimsa chrunca guellay caran Israel runacuna chay runa ayca cuestänanpag cangantapis chruranganmi. ");
INSERT INTO qva_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Chay guellaywanmi Tayta Dios nimangannuyla manca rurag runapa chracran nipäcunganta rantipäcuran”. ");
INSERT INTO qva_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Gobernadurpa ñaupagninchru captinna Jesusta tapuran: “¿Gamchu Israel runacunapa Reynin caycanqui?” Jesús niran: “Gam nishcanqui”. ");
INSERT INTO qva_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ichanga cüracunapa mandagnincunawan Israel mayor runacuna Jesuspa contran nipäcuptinpis pay imatapis manam niranchu. ");
INSERT INTO qva_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Chaymi Piläto tapuran: “¿Manachu mayanqui gampa contrayqui nircäshungayquita?” ");
INSERT INTO qva_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Chaynuy nircaptinpis Jesús manam imatapis rimarcuranchu. Chaymi Piläto imaniytapis mana camäpacuranchu. ");
INSERT INTO qva_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Chay Pascua fiestachru cada wata gobernador cachrareg juc prësuta maygantapis runacuna acranganta. ");
INSERT INTO qva_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Chaychru prësu wichrgaraycaran lapan runapita reguisha Barrabás jutiyog runa. ");
INSERT INTO qva_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Chayman runacuna gotucaramuptinna paycunata Piläto tapuran: “¿Mayganta cachrarinätatag gamcuna munapäcunqui: Barrabastachu o ‘Dios cachramungan Salvador’ nipäcungan Jesustachu?” ");
INSERT INTO qva_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Piläto musyaran cüracunapa mandagnincunawan Israel mayor runacuna envidiapita payman apapäcunganta. ");
INSERT INTO qva_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Piläto mandacunanchru juzgananpag jamaraycaptinmi warmin willacachiran caynuy ninanpag: “Chay juchaynag runata imatapis ama ruraychu. Chay runapa janan chacay fiyuta suyñushcä”. ");
INSERT INTO qva_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ichanga cüracunapa mandagnincuna y Israel mayor runacuna chaychru cag runacunata yachrachiran “Barrabás cachrarisha cachun y Jesús wañuchisha cachun” nipäcunanpag. ");
INSERT INTO qva_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Gobernador yapay tapuran: “¿Ishcanpita mayganta cachrarinätatag gamcuna munapäcunqui?” Paycuna nipäcuran: “¡Barrabasta!” ");
INSERT INTO qva_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Piläto tapuran: “Chauraga ‘Dios cachramungan Salvador’ ningan Jesustaga ¿imatatag rurashag?” Lapan nipäcuran: “¡Crucificächiy!” ");
INSERT INTO qva_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Chauraga Piläto niran: “Crucificasha cananpäga ¿imatatag mana alita rurasha?” Chaynuy niptinpis paycuna yapay gaparäpäcuran: “¡Crucificächiy!” ");
INSERT INTO qva_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Yarpangancunata Piläto rurayta mana tarirna y runacuna mas gaparayta galaycuptinna yacuta apachimuran. Chaywanna lapan ricararcaptin caynuy nir maquinta mayllacuran: “Nogaga manam juchayogchu cä cay runa wañunganpita. ¡Cananga gamcunapitanam!” ");
INSERT INTO qva_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Lapan runa nipäcuran: “Nogacuna y wamräcunam cay runa wañunganpita juchayog capäcushag”. ");
INSERT INTO qva_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Chauraga Piläto cachrariran Barrabasta. Nircurna Jesusta astircachir crucificäpäcunanpag cachrapariran. ");
INSERT INTO qva_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Chaypita gobernadurpa soldäduncuna “pretorio” jutiyog palaciuman Jesusta apapäcuran. Chaychrüna lapan soldäducunata pay cangancagman shuntaran. ");
INSERT INTO qva_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Jesuspa röpanta logtiparir puca cäpata aylluparan. ");
INSERT INTO qva_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Umanmanna cashapita awasha corönata jatiparan. Derëchacag maquinman bärata aptaparan. Nircurna ñaupagninman gongurpacuycur asipäpäcuran: “¡Vïva Israel runacunapa Reynin!” nir. ");
INSERT INTO qva_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Chaynuypis togapäpäcuran. Aptarangan bärawan umachru wirupäcuran. ");
INSERT INTO qva_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Chaynuy asiparcärirna ayllurangan puca cäpata jorgapariycur quiquinpa röpantana jatiparan. Nircurna crucificänanpag apacäriran. ");
INSERT INTO qva_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Chaypita yargurna tincupäcuran Cirene marcapita Simón jutiyog runawan. Paytanam Jesuspa cruzninta apachipäcuran. ");
INSERT INTO qva_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Gólgota ninganman chrayachipäcuran. Gólgota ninanga “Calavëra cacunan” ninanmi. ");
INSERT INTO qva_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Chaychrüna asgagwan talusha vïnuta Jesusta upunanpag gopäcuran. Ichanga malircur upuyta mana munaranchu. ");
INSERT INTO qva_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Crucificarcärirna soldäducuna Jesuspa röpancunata surtiyapäcuran quiquinpura raquipänacärinanpag. Chaynuypam Tayta Diospa willacognin caynuy escribingan cumpliran: “Quiquinpura raquipänacunanpämi röpäcunapag surtiyapäcuran”. ");
INSERT INTO qva_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nircurna chaychru jamacaycäriran payta täpapäcunanpag. ");
INSERT INTO qva_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Uman janaganmanna imapita wañungantapis escribisha letrëruta chrurapäcuran. Chay letrëruchrümi niran: “Cayga Israel runacunapa Reynin Jesusmi”. ");
INSERT INTO qva_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jesustawan ishcay saltiadurcunatapis crucificaran. Jucagtana derëchacag lädunman y jucagtana ichogcag lädunman. ");
INSERT INTO qva_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Chaypa pasagcunaga umanta awir Jesusta ashlipäcuran. ");
INSERT INTO qva_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Nipäcuran: “Gam templuta juchrurcachir quimsa junaglata sharcachinayqui caran. Tayta Diospa Wamran caycarga quiquiqui salvacuy y cruzpita yarpamuy”. ");
INSERT INTO qva_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Chaynuypis cüracunapa mandagnincuna, Moisés escribingan leycunata yachrachegcuna y Israel mayor runacuna Jesusta asipar niran: ");
INSERT INTO qva_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Juc runacunataga salvaran; quiquin ichanga salvacuyta mana puedinchu. Israel runacunapa Reynin caycarga cruzpita yarpamuchun. Chauraga payman criyishunmi. ");
INSERT INTO qva_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Pay Tayta Diosmanmi yäracuran. Chaynuypis niran: ‘Tayta Diospa Wamranmi cä’. Chauraga payta cuyarga canan höra Dios salvachun”. ");
INSERT INTO qva_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Chaynuyla paywan saltiadurcuna crucificaraycagcunapis payta ashlipäcuran. ");
INSERT INTO qva_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Pulan junagpita asta mallway inticama intëru pacha chacacäcuran. ");
INSERT INTO qva_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Inti mallwaychrünuy caycaptinmi Jesús fiyupa gayacuran: “Elí, Elí, ¿lama sabactani?” Chay ninanga caycan: “Diosnï, Diosnï, ¿imanirtag jaguiriycamashcanqui?” ninanmi. ");
INSERT INTO qva_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Chaychru cag waquin runacuna chay ninganta mayaycur nipäcuran: “Tayta Diospa willacognin Eliasta gayacuycan”. ");
INSERT INTO qva_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Chauraga chay höra jucnin cörrila aywaran esponjaman. Nircurna puchgog vïnuman ushmachiran. Chaytana gueru puntanman wataparcur Jesusta shoguchiran. ");
INSERT INTO qva_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ichanga waquincuna nipäcuran: “Chaynuyla cachun. Mä, ricashun Elías salvananpag shamogta”. ");
INSERT INTO qva_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Chaypita Jesús yapay fiyupa gapariran. Nircur wañuriycuran. ");
INSERT INTO qva_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Chay höram templo rurichru cortïna ishcayman janapita uraman rachricäcuran. Pachapis fiyupa sicsicyaran. Gagacunapis particäcuran. ");
INSERT INTO qva_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Sepultüracunapis quichracäcuran. Wañusha caycanganpita Tayta Dios munangannuy cawag runacunapis achcag cawarimuran. ");
INSERT INTO qva_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jesús cawarimuptinnam sepultürancunapita yargapäcamuran. Jerusalenman yaycuptinna achcag runacuna ricapäcuran. ");
INSERT INTO qva_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jesusta täpar capitan y paywan caycagcuna pacha cuyuregta y lapan ima pasaycangantapis ricapäcuran. Chaymi mancharir nipäcuran: “¡Rasunpam cay runaga Diospa Wamran casha!” ");
INSERT INTO qva_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Chaychrümi Galileapita pacha Jesuspa guepanta aywag achca warmicunapis carupita ricararcaran. Chay warmicunam Jesusta imachrüpis yanaparan. ");
INSERT INTO qva_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Chaychru caycaran María Magdalena, Santiagupa y Josëpa maman María y Zebedeupa wamrancunapa maman. ");
INSERT INTO qva_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nagana pacha chacaycaptinna José jutiyog rïcu runa chrayaran. Pay caran Arimatea marcapita. Paypis Jesuspa discïpulunmi caran. ");
INSERT INTO qva_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Paynam Pilätucagman aywaycur Jesuspa cuerpunta jorgucunanpag niran. Chauraga Jesuspa cuerpunta goycunanpag Piläto niran. ");
INSERT INTO qva_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Chaypitana Jesuspa cuerpunta jorgurcur lïnupita limpiu säbanaswan José wancuran. ");
INSERT INTO qva_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nircurna quiquinpag chagachru uchrcuchingan mushog sepultüraman pampaycuran. Jatuncaray rumiwan sepultürata chapaycachirna aywacuran. ");
INSERT INTO qva_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","María Magdalenawan jucag Mariam sepultüra chimpanchru jamaraycar quëdacäriran. ");
INSERT INTO qva_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Warantin sábado junag cüracunapa mandagnincuna y fariseo runacuna Pilätucagman aywapäcuran. ");
INSERT INTO qva_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Chaychru nipäcuran: “Tayta, yarpäpäcushcä cawaycar-rag chay casqui runa ‘Quimsa junagtaga cawarimushämi’ ninganta. ");
INSERT INTO qva_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Chaymi quimsa junagcama sepultürata täpachinquiman. Discïpuluncuna aywaycur Jesuspa cuerpunta suwacarärinman. Nircur runacunata cawarimusha canganta nirärinman. Runacunata cawaycar-rag chay runa engañangannuy cawarimusham discïpuluncuna nipäcuptinga runacuna mas criyipäcunga”. ");
INSERT INTO qva_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Piläto niran: “Chaychru caycan soldäducuna. Paycunawan aywapäcuy. Nircur sepultürata imaycanuypapis shumag seguräpäcamuy”. ");
INSERT INTO qva_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Chauraga aywaycur sepultürata seguräpäcamuran. Chaparag rumiman señalta chruraran sepultürata quichraptinga musyacänanpag. Nircurna soldäducunata täpananpag jaguipäcamuran. ");
INSERT INTO qva_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sábado jamay junag pasaruptinna semäna galarinan junag waraycaptinna María Magdalenawan jucag María Jesús pamparanganta ricag aywapäcuran. ");
INSERT INTO qva_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tayta Diosninchipa angilnin cielupita yarpamuptinmi mayänipita fiyupa pacha cuyuriran. Jesús pamparanganman chrayaycur sepultüra chaparag rumita cuchrpächiypa chay angel ashuchiran. Nircurna chay rumi jananman jamacuycuran. ");
INSERT INTO qva_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Chay angel ilagunuyrag chichipaycaran. Röpanpis rajunuyrag yurag caran. ");
INSERT INTO qva_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ricaycur soldäducunaga manchariypita sicsicyaycar upatasha wañushanuy ricacuran. ");
INSERT INTO qva_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Warmicunata angel niran: “Ama mancharipäcuychu. Noga musyämi crucificaypa wañusha Jesusta ashircangayquita. ");
INSERT INTO qva_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Manam caychrünachu caycan. Cawaycar-rag ningannuylam cawarimusha. Shapäcamuy chruraranganta ricapäcunayquipag. ");
INSERT INTO qva_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Jucla discïpuluncunata willag aywapäcuy: ‘Cawarimushanam. Gamcunapa puntayquitam Galileaman aywanga. Chaychrümi payta ricapäcunqui’. Chaytam gamcunata willanä caran”. ");
INSERT INTO qva_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Chay warmicuna mancharisha caycarpis sepultürapita jucla cushisha cörripäcuran discïpuluncunata willananpag. ");
INSERT INTO qva_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Chaychrümi warmicunata Jesús ricariparcur saludaran. Chauraga warmicuna Jesuscagman ashuycärir chraquinpita abrazacurir adoräpäcuran. ");
INSERT INTO qva_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Chauraga Jesús niran: “Ama mancharipäcuychu. Ayway; wauguïcunata panïcunata willamuy Galileaman aywapäcunanpag chaychrüna tincupäcunäpag”. ");
INSERT INTO qva_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Warmicuna cutipäcungancama täpag soldäducunapita waquincagcuna Jerusalenman aywaycur cüracunapa mandagnincunata willapäcuran lapan imanuy pasangantapis. ");
INSERT INTO qva_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Chay cüracunapa mandagnincuna Israel mayor runacunawan rimanacunanpag shuntacäpäcuran. Rimanacarcärirna soldäducunata achca guellayta gopäcuran. ");
INSERT INTO qva_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Nircur nipäcuran: “Gamcunaga ninqui: ‘Chacaypa puñucäpäcungäcamam discïpuluncuna aywarcamur Jesuspa cuerpunta suwacärisha’. ");
INSERT INTO qva_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Puñucäpäcungayquicama Jesuspa cuerpunta suwacäringanta gobernador musyaptinga nogacunam paywan parlashag gamcunata imatapis mana rurapäcushunayquipag”. ");
INSERT INTO qva_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Soldäducuna guellayta chrasquicarcärirga nipäcunanpag yachrachingannuyla nipäcuran. Chaynuy ninganmi canancamapis Israel runacunapa yarpayninchru caycan. ");
INSERT INTO qva_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jesuspa chrunca juc (11) discïpuluncuna Galileamanna aywar Jesuswan tincupäcunanpag ningan jircaman aywapäcuran. ");
INSERT INTO qva_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Chaychrümi Jesuswan tincur payta adoräpäcuran. Waquincunaga manam criyipäcuranrächu. ");
INSERT INTO qva_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesús paycunapa ñaupagninman ashuycur niran: “Tayta Dios nogata chruramasha cieluchru cagtapis y cay pachachru cagtapis lapanta munaynïchru charänäpämi. ");
INSERT INTO qva_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Lapan naciunchru cag runacunaman aywaycur discïpulü cananpag yachrachipäcamuy. Bautizäpäcunqui Tayta Diospa, Wamranpa y Santu Espiritupa jutinchru. ");
INSERT INTO qva_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Paycunata yachrachinqui lapanta gamcunata imata cäsucärinayquipag yachrachingäcunata. Nogaga gamcunawanmi waran waran cay pacha ushacangancama caycäshag”. Amén.");
INSERT INTO qva_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Caynuymi Jesuspa ali willacuynin galaycuran. Payga Tayta Dios cachramungan Salvadurmi y Tayta Diospa Wamranmi. ");
INSERT INTO qva_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Willacognin Isaías escribingan libruchrümi Tayta Diosninchi caynuy niran: “Gampa puntayquita willacognïtam cachrashag camiñuta alichagnuypis runacunata gampag camaricachinanpag”. ");
INSERT INTO qva_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Chunyag jircachrümi juc runa fiyupa gayaraycar willacunga: ‘Mandag runa shamunanpag camiñucunata pichar camaricäringayquinuy camaricäriy Señurta chrasquicärinayquipag’ nir”. ");
INSERT INTO qva_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Chaynuymi chunyag jircachru Juan Bautista ricacämuran. Willacuran: “Juchayquicunapita wanacur bautizacäriy. Chaynuy juchayquipita wanacuptiquim Tayta Dios perdunäshunqui”. ");
INSERT INTO qva_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Judea provinciapita y Jerusalenpita achca runacuna mayapäcunanpag yargapäcamuran. Juchäcungancunata willapaptin Jordán mayuchru Juan bautizaran. ");
INSERT INTO qva_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan Bautistapa röpan camellupa millwanpita awasham caran. Wachrcun garapita caran. Micuynin chucluscuna y uñuñuypa mishquin caran. ");
INSERT INTO qva_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Juan Bautista willacuran: “Nogapa guepäta nogapita mas munayniyogmi aywaycämun. Nogaga manam välïchu unchruycur llanquinpa watunta pascapänaläpäpis. ");
INSERT INTO qva_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Noga yaculawanmi gamcunata bautizashcä. Paymi ichanga Santu Espirituwan bautizäshunqui”. ");
INSERT INTO qva_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Chay wichan Galilea provinciachru caycag Nazaret marcapita Jesús chrayaran. Chrayaptinna Jordán mayuchru Juan bautizaran. ");
INSERT INTO qva_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yacupita yargamurna cielo quichracaycagta Jesús jucla ricaran. Y ricaran Santu Espíritu palumatucular payman yarpaycämogta. ");
INSERT INTO qva_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Cielupita caynuy nimungan mayacämuran: “Gamga cuyay Wamrämi caycanqui. Noga gampita cushisha caycä”. ");
INSERT INTO qva_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Chaypitanam Santu Espíritu chunyag jircaman Jesusta pusharan. ");
INSERT INTO qva_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Chaychrümi Jesús chruscu chrunca (40) junag chucaru uywacunawan iwal caran. Chaychru caycaptinmi Satanás juchäcachiyta camaran. Angilcunam chaychru payta yanaparcaran. ");
INSERT INTO qva_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Juanta carcilman wichrgaptin Galilea provinciaman Jesús aywaran Tayta Diospa willacuyninta willacunanpag. ");
INSERT INTO qva_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jesús chaychru niran: “Chrayamunanpag cag junag cumplishanam y Tayta Diospa munayninchru canapag tiempo chrayaycämunnam. Juchayquicunapita wanacäriy, Tayta Dios munangannuy cawapäcuy y ali willacuyninman yäracäriy”. ");
INSERT INTO qva_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesús pasaycaran Galilea lamar cantunpa. Chaychrümi Simonta y wauguin Andresta ricaran. Paycuna pescacog carmi lamarman redninta mashtarcaran. ");
INSERT INTO qva_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesús niran: “Discïpulü canayquipag nogawan aywashun. Pescäduta charingayquinuy Tayta Diospag runacunata shuntanayquipag yachrachishayqui”. ");
INSERT INTO qva_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Chaynuy niptinmi rednincunata jaguiriycur jucla Jesuswan aywacäriran. ");
INSERT INTO qva_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Mas wac läduchrüna Zebedeupa wamran Santiaguta y wauguin Juanta ricaran. Paycuna büquinchru rednincunata shilparcaran. ");
INSERT INTO qva_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jucla paycunatapis Jesús gayaran. Chauraga büquinchru taytan arogninwan caycagta jaguiriycur Jesuswan aywacäriran. ");
INSERT INTO qva_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Chaypitana Capernaum marcaman aywapäcuran. Sábado jamay junagna shuntacänan wasiman yaycuycur yachrachiyta Jesús galaycuran. ");
INSERT INTO qva_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Yachrachiptin runacuna almirasha ricaräpäcuran. Pay yachracheg lapan munayninwan. Manam Moisés escribingan leycunata yachrachegcunanuychu yachrachiran. ");
INSERT INTO qva_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Chay shuntacänan wasichrümi diablupa munayninchru caycag runa caycaran. Chay runa gaparir niran: ");
INSERT INTO qva_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“¡Nazaret marcapita Jesús! ¿Imatatag nogacunawan munanqui? ¿Ushacächipäcamänayquipächu shamushcanqui? Noga musyämi pï cangayquitapis. ¡Gam Dios cachramungan Runam caycanqui!” ");
INSERT INTO qva_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús chay diabluta caynuy piñaparan: “¡Upälacuy y cay runapita yarguy!” ");
INSERT INTO qva_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Chauraga diablo chay runata fiyupa tapsiriycur gaparir yarguran. ");
INSERT INTO qva_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Lapan runacuna mancharipäcuran y jucnin jucninpis ninacäriran: “¡Imatag cay! ¡Jucnuypa y lapan munayninwan yachrachin! ¡Mandaptin asta diablucunapis cäsun!” ");
INSERT INTO qva_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Chaynuy Jesús rurangan jucla intëru Galilea provinciapa mashtacaran. ");
INSERT INTO qva_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Shuntacänan wasipita Jesús yargurnam Santiaguwan y Juanwan Simonpa y Andrespa wasinman aywaran. ");
INSERT INTO qva_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simonpa suedran calintürawan cämanchru jitaraycaran. Chaynuy caycanganta jucla Jesusta willapäcuran. ");
INSERT INTO qva_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Chauraga ashuycur maquipita charircur sharcachiran. Chay höram calintüra illacäcuran y micuyta paycunata garayta galaycuran. ");
INSERT INTO qva_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Inti yaycuycaptinnam Jesuscagman achca gueshyagcunata y diablupa munayninchru caycagcunata apapäcamuran. ");
INSERT INTO qva_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Chay wasi puncuman chay marca runacuna achcag shuntacämuran. ");
INSERT INTO qva_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Chaychru Jesús tucuy nirag gueshyacunapita achcag runacunata cuticächiran. Achcag diablucunata garguran. Ichanga pï cangantapis musyaptin diablucunata Jesús mana rimachiranchu. ");
INSERT INTO qva_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Chaca chacala pacha manaräpis waraptin Jesús sharcuran. Nircur marcapita yarguran chunyagninman Tayta Diosta rugacunanpag. ");
INSERT INTO qva_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón y paywan cagcuna Jesusta ashipäcuran. ");
INSERT INTO qva_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tariycärirna nipäcuran: “Achca runacuna ashircäshunqui”. ");
INSERT INTO qva_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Pay niran: “Paycuna ashimaptinpis lädunchichru marcacunapa aywashun Tayta Diospa willacuyninta willacunäpag. Paypa willacuyninta willacunäpämi shamushcä”. ");
INSERT INTO qva_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Chaypita Jesús intëru Galilea provinciachru paycunapa shuntacänan wasicunachru Tayta Diosninchipa willacuyninta willacur y diablucunata runacunapita garguycar puriran. ");
INSERT INTO qva_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Gueri gueshyawan gueshyaycag runa Jesuspa ñaupagninman gongurpacuycur rugacuran: “Munarga cay gueshyäpita cuticaycachilämay”. ");
INSERT INTO qva_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Rugacuptin Jesús cuyaparan. Nircur yataycur niran: “Au, munämi. Cuticashanam caycanqui”. ");
INSERT INTO qva_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Niptin chay höra gueri gueshya aywacuptin sänu quëdaran. ");
INSERT INTO qva_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Cuticarcuptinna jucla aywacunanpag nir piñapaypa ");
INSERT INTO qva_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Jesús niran: “Ama pitapis willapanquichu noga cuticächingäta. Chaypa truquinga cüraman ayway cuticashana cangayquita ricashunayquipag. Y Moisés escribinganchru ningannuy ofrendata apanqui gueshyayquipita cuticashana cangayquita lapan musyananpag”. ");
INSERT INTO qva_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Niycaptinpis chay runa aywacurirga lapan runata ima cangantapis willapayta galaycuran. Chaymi Jesús marcamanpis yaycuyta mana puedegchu aläpa runacuna paycagman shuntacaptin. Chaypa truquinga chunyag jircalachru quëdacog. Chaychru captinpis pay caycangancagman intërupita achca runacuna aywapäcamog. ");
INSERT INTO qva_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Chaypita junagcuna pasaruptinna Capernaumman Jesús yapay cutiycuran. Chay marcachru cangan musyacaran. ");
INSERT INTO qva_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Chaychru caycanganta musyarmi achca runacuna chrayaran. Achca runacuna captinmi puncupis pasaypa mana jäcurannachu. Chaynuy achca caycaptinmi Tayta Diosninchipa willacuyninta Jesús willaparan. ");
INSERT INTO qva_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Chaychru willapaycaptinmi chruscu runacuna wintuypa pulan cuerpun wañusha runata chrayachipäcuran. ");
INSERT INTO qva_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Chaychru achca runacuna captinmi Jesuscagman apaycuyta mana puedipäcuranchu. Chauraga wasi jananman jegarcachir wasi jananta uchrcurir gueshyagta quirmanchru chrachraraycagta Jesuspa ñaupagninman yarpächipäcuran. ");
INSERT INTO qva_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Chay runacuna payman yäracäringanta tantiyarmi chay gueshyag runata Jesús niran: “Hïju, juchayquicunapita perdunashanam caycanqui”. ");
INSERT INTO qva_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Gueshyagta Jesús chaynuy niptinmi Moisés escribingan leycunata yachrachegcuna shongulanchru yarpachracäriran: ");
INSERT INTO qva_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Imanirtag cay runa chaynuy riman? ¡Chaynuy rimarga Tayta Diosta apärir rimaycan! Tayta Dioslam runapa juchanta perdunan”. ");
INSERT INTO qva_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Chaynuy yarparcanganta shongulanchru tantiyarmi Jesús tapuran: “¿Imanirtag chaynuy yarpäpäcunqui? ");
INSERT INTO qva_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Maygantag mas fäcil cay pulan cuerpun wañusha runata ninapag: ‘Juchayquicunapita perdunashanam caycanqui’ niychu, o ‘Sharcuy, quirmayquita apacurcur aywacuy’ niychu? ");
INSERT INTO qva_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Canan musyachishayqui runata juchancunapita perdunänäpag noga Diospita shamusha Runa cay pachachru munayniyog cangäta”. Nircur chay pulan cuerpun wañusha runata niran: ");
INSERT INTO qva_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Gamta nï: ¡Sharcuy! Quirmayquita apacurcur wasiquipa aywacuy”. ");
INSERT INTO qva_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Chay runa chay höra sharcur quirmanta apacurcur lapan ricararcaptin wasinpa aywacuran. Chayta ricaycur runacuna almirasha Tayta Diosta caynuy alabäpäcuran: “¡Imaypis manam caytanuyga ricashcanchichu!” ");
INSERT INTO qva_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Chaypitana Jesús yapay Galilea lamar cantunman aywaran. Pay cangancagman achca runacuna chrayag. Chay runacunata yachracheg. ");
INSERT INTO qva_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Chaypa pasaycarna Jesús ricaran Alfeupa wamran Levïta Romapag impuestuta cobracunanchru jamaraycagta. Jesús niran: “Discïpulü canayquipag nogawan aywashun”. Chauraga Leví paywan aywacäriran. ");
INSERT INTO qva_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Chaypitanam Jesús discïpuluncunawan Levïpa wasinchru micurcar tiyararcaran. Paycunawan Romapag impuesto cobragcuna y mana alipag ricasha runacunapis caycaran. Paycunaga Jesusta achcagmi gatiräpäcuran. ");
INSERT INTO qva_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Chaynuy micurcagta ricarmi Moisés escribingan leycunata yachracheg fariseucuna Jesuspa discïpuluncunata tapuran: “¿Imanirtag impuesto cobragcunawan y mana alipag ricasha runacunawan Jesús micun?” ");
INSERT INTO qva_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ninganta mayar Jesús niran: “Sänu cagcunaga jampicogta manam munanchu sinöga gueshyagcunam. Noga ali ruragcunata shuntanäpächu manam shamushcä, sinöga juchayogcunata shuntanäpämi shamushcä”. ");
INSERT INTO qva_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Juc cutinchru Juan Bautistapa discïpuluncuna y fariseucuna ayunarcaran. Chayta ricarmi runacuna aywaycur Jesusta tapupäcuran: “¿Imanirtag Juan Bautistapa discïpuluncuna y fariseucunapa discïpuluncuna ayunan y gampa discïpuluyquicunaga mana ayunanchu?” ");
INSERT INTO qva_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús niran: “¿Casarag mösu chaychru paycunawan caycaptinrag fiestaman gayachingan cagcuna ayunanmanchurag? Casarag mösu chaychru paycunawan caycaptinrag manam ayunanmanchu. ");
INSERT INTO qva_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ichanga chrayamungam casarag mösuta apacärinanpag. Chauraga ayunäpäcunga. ");
INSERT INTO qva_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Manam pipis macwa röpata mushog träpuwanga remendanchu. Remendaptinga mushog träpu guentir macwa röpata rachricächin y rachrisha caycag mas jatunyan. ");
INSERT INTO qva_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Chaynuy manam pipis chayrag rurasha vïnuta auquisyasha ordiman wiñanchu. Auquisyasha ordiman wiñaptinga vïno pogur chay ordita pashtariycachingam. Chauraga vïnupis jichracäcun y ordipis rachrir ushacäcun. Chaymi mushog ordiman chayrag rurasha vïnuta wiñan”. ");
INSERT INTO qva_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sábado jamay junagchru trïgucuna cangan chracracunapa discïpuluncunawan Jesús pasarcaran. Chaypa pasarcarmi discïpuluncuna trïguta palapäcuran. ");
INSERT INTO qva_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Fariseo runacuna Jesusta nipäcuran: “¡Ricay! ¿Imanirtag leycunata mana cäsucur sábado jamay junagchru trïguta palarcan?” ");
INSERT INTO qva_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Chauraga Jesús niran: “¿Gamcuna manachu liyipäcushcanqui juc cutinchru David yanagagnincunawan micanar pay imata rurangantapis? ");
INSERT INTO qva_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Cüracunapa mas mandagnin Abiatar caycangan wichan Tayta Diosta mañacuna wasiman David yaycuran. Nircur Tayta Diospag chruraraycag tantacunata micuran y yanagagcunatapis goran paycunapis micunanpag. Chaynuy micapäcuran Moisés escribingan leycunachru chay tantacuna cüracunala micapäcunanpag caycaptinpis”. ");
INSERT INTO qva_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Nircurpis Jesús niran: “Sábado jamay junag runa jananmi ruracaran. Manam runachu sábado janan ruracaran. ");
INSERT INTO qva_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Chaymi noga Diospita shamusha Runa munayniyog caycä sábado jamay junagchru runa rurananpag mana rurananpag cangantapis ninäpag”. ");
INSERT INTO qva_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Juc cutinchru shuntacäpäcunan wasiman Jesús yapay yaycuran. Chaychru caycänag jucnincag maquin macllucasha runa. ");
INSERT INTO qva_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Chaychru Jesusta ricaparcaran sábado jamay junagchru cuticächinanta “Leycunata mana cäsunchu” nipäcunanpag. ");
INSERT INTO qva_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Chauraga chay macllucasha maquiyog runata Jesús niran: “Runacunapa ñaupagninman ichricuy”. ");
INSERT INTO qva_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nircur runacunata Jesús tapuran: “¿Imatag sábado jamay junagchru ruranapag caycan: ali cagtachu o mana ali cagtachu? ¿wañuycagta salvaychu o ‘Wañucuchun’ niychu?” Ichanga paycuna imatapis mana rimacäriranchu. ");
INSERT INTO qva_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Chauraga muyuregninchru carcag runacunata Jesús rabyasha ricäriran. Nircur chay runacuna mana cäsucog y mana cuyapäcog canganpita laquicuran y chay gueshyag runata niran: “¡Maquiquita mashtay!” Mashtarcuptin maquin sänuna ricacuran. ");
INSERT INTO qva_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Chaypita yargurirna fariseo runacuna Herodispa favurnin cag runacunawan Jesusta wañuchinanpag rimanacäriran. ");
INSERT INTO qva_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Chaypita Jesús discïpuluncunawan lamar cantunman aywacäriran. Aywacuptin Galilea provinciapita achca runacuna gatiräpäcuran. Imaycatapis ruranganta musyarmi Judea provinciapita, Jerusalenpita, Idumea partipita, Jordán mayupa jucag lädunpita y Tiro y Sidón partipita achca runacuna payman aywapäcamuran. ");
INSERT INTO qva_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Jesús achca gueshyag runacunata cuticächisha captinmi lapan gueshyagcuna pay caycangan cagman imaycanuypapis yaycuycur yataycuyta munapäcuran gueshyancunapita cuticänanpag. Chaymi discïpuluncunata Jesús niran achca runacuna juntar tangarinanpita lamar cantunchru juc büquita listu charäpäcunanpag. ");
INSERT INTO qva_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Diablucunapa munayninchru caycag runacunapis Jesusta ricarga ñaupagninman gongurpacuycur gaparir nipäcuran: “¡Gamga Diospa Wamranmi caycanqui!” nir. ");
INSERT INTO qva_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Chaynuy niptinmi Jesús fiyupa olgüparan pay pï cangantapis mana rimapäcunanpag. ");
INSERT INTO qva_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Chaypita Jesús lömaman jegaran. Chaypitana pay munangancag runacunata chayman shuntacänanpag gayaran. Shuntacarcuptinna ");
INSERT INTO qva_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","chrunca ishcay (12) runacunata acraran paywan purinanpag y willacuyninta willacog cachrananpag. ");
INSERT INTO qva_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Paycunata munayninta goran gueshyagcunata cuticächinanpag y runacunapita diablucunata gargunanpag. ");
INSERT INTO qva_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Chay acrangancuna caycunam caran: Simón (paytam Jesusga “Pedro” jutita chruraran) ");
INSERT INTO qva_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","y Zebedeupa wamran Santiago y wauguin Juan. Chaynuypis Jesús paycunata niran “Boanerges”. Chay ninan caran “Räyupa Wamran” ninanmi. ");
INSERT INTO qva_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Chaypitam caran Andrés, Felipe, Bartolomé, Mateo, Tomás, Alfeupa wamran Santiago, Tadeo, “Celote” jutiyog Simón ");
INSERT INTO qva_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","y Jesusta entregag Judas Iscariote. ");
INSERT INTO qva_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Chaypita wasiman Jesús cutiruptinna yapay achca runacuna chaymanpis shuntacaran. Pay discïpuluncunawan ni micuytapis mana puedipäcuranchu. ");
INSERT INTO qva_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jesús löcuyasha canganta nipäcuptinmi aylluncuna pushacunanpag shapäcamuran. ");
INSERT INTO qva_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jerusalenpita chrayag Moisés escribingan leycunata yachrachegcuna niran: “Pay Satanaspa munayninchrümi caycan. Diablucunapa quiquin mandagninmi munayninta gosha diablucunata gargunanpag”. ");
INSERT INTO qva_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Chauraga Jesús paycunata gayaycur tincuchiypa niran: “¿Imanuypatag Satanasga quiquin Satanás caycarga gargucunga? ");
INSERT INTO qva_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Juc naciunchru quiquinpura chriquinacurga ushacanmi. ");
INSERT INTO qva_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Chaynuypis juc wasilachru juc ayllu tiyagcuna quiquinpura chriquinacurga ushacanmi. ");
INSERT INTO qva_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Chaynuylam Satanaspis quiquinpa contran sharcurga y quiquinpura chriquinacurga mana quëdanmanchu. Chaypa truquinga ushacanmanmi. ");
INSERT INTO qva_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Manam pipis fiyupa callpayog runapa wasinman iman aycantapis suwacunanpag manaräpis quiquinta watarga yaycuyta puedinchu. Wataycurmi ichanga iman aycantapis suwacuyta puedin. ");
INSERT INTO qva_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Rasunpam gamcunata nï: Runata juchäcunganpita y Tayta Diospa contran lutancunata rimanganpita Tayta Dios perdunangam. ");
INSERT INTO qva_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Santu Espiritupa contran lutanta rimagcunapämi ichanga imaypis perdon mana cangachu. Chaycunaga imaypis juchayoglam canga”. ");
INSERT INTO qva_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Chaynuy Jesús niran diablupa munayninchru canganta Moisés escribingan leycunata yachrachegcuna nipäcunganpitam. ");
INSERT INTO qva_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Chaymanmi Jesuspa maman wauguincunawan chrayaran. Ichanga punculachrümi quëdacäriran. Chaypitanam Jesusta gayachimuran. ");
INSERT INTO qva_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Chauraga Jesuspa muyuregninchru jamararcagcuna niran: “Mamayqui y wauguiquicunam puncuchru caycan. Ashircäshunqui”. ");
INSERT INTO qva_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Pay niran: “¿Pitag nogapa mamä y wauguïcuna?” ");
INSERT INTO qva_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nircur muyuregninchru jamararcagcunata ricärir niran: “Paycunam nogapa mamänuy y wauguïcunanuy. ");
INSERT INTO qva_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Pipis Tayta Dios munangannuy cawagcagmi wauguïcunanuy, panïcunanuy y mamänuy caycan”. ");
INSERT INTO qva_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Chaypita yapay lamar cantunchru Jesús yachrachiyta galaycuran. Achca runacuna paypa muyuregninchru captinmi büquiman Jesús jegaran chaypitana jamacuycur yachrachimunanpag. Büqui lamarchru caran y runacunaga lapanpis quëdaran lamar cantunchru. ");
INSERT INTO qva_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Chaypitana achcata imamanpis tincuchiypa yachrachiyta galaycuran. Yachrachirnam niran: ");
INSERT INTO qva_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Shumag mayapäcamay. Juc runa murog aywaran. ");
INSERT INTO qva_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Murur mashtaptin waquin murucuna camiñuman chrayaran. Chaytana pishgucuna shamur upshacarcäriran. ");
INSERT INTO qva_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Waquinna shala shala allpaman chrayaran. Chaychru allpa achca mana captin rätu wiñamuran. ");
INSERT INTO qva_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Yargamuptinpis allpachru shumag mana sapichacusha captin inti yargamur chaquiriycachiran. ");
INSERT INTO qva_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Waquin muru chrayaran cashacuna rurinman. Cashacuna wiñamur niticurcuptin garwashtaycälar wiñar mana wayurannachu. ");
INSERT INTO qva_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Waquin cag muruna ichanga ali allpaman chrayaran. Wiñamur ali wayuran. Waquin espïja wayuran quimsa chruncata (30), waquin espïja wayuran sogta chruncata (60) y waquinna wayuran pachracta (100)”. ");
INSERT INTO qva_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Chaynuy willaparcurnam Jesús niran: “¡Ningäta mayag cäga shumag tantiyacäriy!” ");
INSERT INTO qva_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Runacuna aywacäriptin Jesús quëdaran paywan puregcunalawanna y chrunca ishcay (12) discïpuluncunalawanna. Chaychru tapupäcuran chay yachrachingan ima ninan cangantapis. ");
INSERT INTO qva_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesús niran: “Gamcunata Tayta Diosmi tantiyarcächishunqui munayninpita pipis mana musyanganta. Waquincunatam ichanga imamanpis tincuchiypa yachrachï ");
INSERT INTO qva_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ricaycarpis mana ricagnuy cananpag y mayarpis mana tantiyagnuy cananpag. Chaynuypa juchanpita mana wanacunanpag y juchanpita Tayta Dios mana perdunänanpag”. ");
INSERT INTO qva_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesús niran: “¿Chay tincuchiypa yachrachingäta manachu tantiyapäcunqui? Chauraga ¿imanuypatag imamanpis tincuchiypa yachrachingäta tantiyapäcunqui? ");
INSERT INTO qva_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","“Muruta murogcäga tincun Tayta Diospa willacuyninta willacogmanmi. ");
INSERT INTO qva_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Waquin runacunam caycan camiñuman muru chrayagnuy. Chay runacuna Tayta Diospa willacuyninta mayaptinpis Satanás shamur gongariycachin. ");
INSERT INTO qva_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Waquin runacuna carcan shala shalanuy. Paycunaga Tayta Diospa willacuyninta mayar cushisham chrasquicärin. ");
INSERT INTO qva_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Shala shala captin muru shumag mana sapichacusha car chaquicäcungannuymi runacunapis Tayta Diospa willacuyninta chrasquicungan janan pipis nacachiptin o rabyapaptin jaguiriycärin. ");
INSERT INTO qva_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Waquin runacunanam cashacunaman murusha murunuy caycan. Paycunaga Tayta Diosninchipa willacuyninta mayapäcun. ");
INSERT INTO qva_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ichanga ruraynincunalapag, rïcuyänalanpag y imaycanpis canalanpag aläpa yarpachracur Tayta Diosninchipa willacuyninta gongariycärin. Chaynuypis Tayta Dios munangannuychu mana cawapäcun. ");
INSERT INTO qva_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ichanga canmi waquin runacuna Tayta Diosninchipa willacuyninta mayar chrasquicog. Paycunaga Tayta Diosninchipa willacuyninta chrasquicur pay munangannuy cawar muru ali allpaman murushanuy caycan. Chay murucuna waquin wayun quimsa chruncata (30) waquin sogta chruncata (60) y waquin pachracta (100)”. ");
INSERT INTO qva_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Caynuypis niran: “Manam pipis achquita cajon rurinman ni cäma rurinman chrurananpag apamunchu. Chaypa truquinga maymanpis ricacagninmanmi chruran achicyänanpag. ");
INSERT INTO qva_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Chaynuymi pacasha cagcuna musyacangam y mana musyasha cagcunapis musyacangam. ");
INSERT INTO qva_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","¡Ningäta mayag cäga shumag tantiyacäriy!” ");
INSERT INTO qva_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Mastapis niran: “Ningäcunata shumag yarpachracäriy. Ningäcunata tantiyangayquinuy Tayta Diospis tantiyachishunquipag. Y mastarämi tantiyachishunquipäpis. ");
INSERT INTO qva_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tantiyacogcäga mastam tantiyanga. Mana tantiyacogtaga ichicla tantiyangantapis gongächisham canga”. ");
INSERT INTO qva_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesús mastapis niran: “Tayta Diospa munaynin ricacun juc runa muruta chracraman murungannuymi. ");
INSERT INTO qva_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Murog runa puñuycaptinpis o ricchaycaptinpis, chacaypapis o junagpapis muru yargamun y wiñan. Murog runaga mana musyanchu muru imanuy wiñamungantapis. ");
INSERT INTO qva_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Allpa quiquilanpitam wiñachimun. Puntata wiñamun. Nircur espïjan yargamun. Wiñangan tupu wayuytana galaycun. ");
INSERT INTO qva_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Trïgu poguruptinna shuntan. Chaynuy ruran cosëcha chrayamuptinna”. ");
INSERT INTO qva_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Mastapis Jesús niran: “Tayta Diospa munayninta ¿imamantag o imawantag tincuchishwan? ");
INSERT INTO qva_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Tayta Diospa munayninga ñäpuspa murunnuymi caycan. Chay muru murusha car cay pachachru ima murupitapis mas tacshalam caycan. ");
INSERT INTO qva_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ichanga mururcusha wiñamurnaga huertachru plantacunapita mas jatunman wiñan. Jatun rämancuna lanturanganchru asta pishgucunapis gueshtancunata rurayta puedin”. ");
INSERT INTO qva_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Chaynuy imamanpis tincuchiypam runacuna tantiyapäcunganman tupu Jesús yachrachiran. ");
INSERT INTO qva_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Imamanpis mana tincuchiypaga imaypis manam yachrachiranchu. Discïpuluncunata ichanga yarichrürag lapanta tantiyacheg. ");
INSERT INTO qva_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Chay junagla pacha chacaycaptinna discïpuluncunata Jesús niran: “Acu, pasashun lamarpa jucag chimpanman”. ");
INSERT INTO qva_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Chauraga chaychru runacunata jaguiriycur Jesús caycangan büquiwan aywacäriran. Mas büquicunapis paywan aywaran. ");
INSERT INTO qva_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Lamarpa pasarcaptinmi fiyupa wayra galaycuran. Chauraga fiyupa wayraptin pulchagyar büquiman yacu yaycuptin cäsi tallpucaycächiranna. ");
INSERT INTO qva_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Chay höra büquipa guepacag puntanchru jaunacuycur Jesús puñucasha caycaran. Puñuycagta riccharcachir nipäcuran: “Maestro, ¿tallpucänanchipäna caycaptinpis manachu imapis gocushunqui?” ");
INSERT INTO qva_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Chauraga Jesús sharcurcur wayrata piñaparan y lamartana niran: “¡Chrawayna, ichriy!” Chauraga wayra chrawaran y lapanpis shumagna ricacuran. ");
INSERT INTO qva_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nircurna discïpuluncunata Jesús niran: “¿Imanirtag fiyupa manchacasha carcanqui? ¿Manarächu Diosman yäracunqui?” ");
INSERT INTO qva_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Chauraga paycuna fiyupa mancharisha quiquinpura ninacäriran: “¿Pirag payga asta wayrapis lamarpis cäsunanpag?” ");
INSERT INTO qva_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Lamarpa jucag lädunman chrayapäcuran. Chay caran Gadara jutiyog partina. ");
INSERT INTO qva_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Büquipita Jesús yarpurcuptin diablucunapa munayninchru caycag runa Jesuscagman aywamuran. Chay runa panteunpita yargamusha casha. ");
INSERT INTO qva_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Chay runa panteunchru tiyag. Payta pipis manam watayta ni cadinawanpis puedipäcuranchu. ");
INSERT INTO qva_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Runacuna achca cuti chraquinpita maquinpita cadinawan watangantapis rachriypa ushareg. Pipapis fuerzan manam caranchu chariptin imatapis mana rurananpag. ");
INSERT INTO qva_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Junagpapis chacaypapis jircacunapa panteuncunapa gaparaycar rumiwan cuchucuycar pureg. ");
INSERT INTO qva_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Carulapita Jesusta ricaycur cörrila aywaycur paypa ñaupagninman chay runa gongurpacuycuran. ");
INSERT INTO qva_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Gaparaypa niran: “Imaycapäpis munayniyog Diospa Wamran Jesús, ¿imatatag nogawan munanqui? ¡Diospa jutinchru rugacü: Ama nacaycachilämaychu!” ");
INSERT INTO qva_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Chaynuy niran Jesús caynuy ninganpitam: “¡Diablo, cay runapita yarguy!” ");
INSERT INTO qva_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Chauraga Jesús tapuran: “¿Imatag jutiqui?” nir. Chauraga niran: “Nogapa jutïga Legiunmi. Chaynuy jutï achcag capäcuptïmi”. ");
INSERT INTO qva_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nircur Jesusta pasaypa rugacuran chay partipita diablucunata mana gargunanpag. ");
INSERT INTO qva_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Cercala tunachrümi achca cuchicuna micuycar caycaran. ");
INSERT INTO qva_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Diablucuna Jesusta rugacäriran: “Wac cuchicunaman aywacärinäpag cachraycärimay. Cuchicunaman yaycapäcunäpag niycärimay” nir. ");
INSERT INTO qva_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Chauraga Jesús au niran yaycunanpag. Diablucuna runapita yargurcur chay cuchicunaman yaycacaycäriran. Chauraga cuchicuna ishcay waranganuy (2,000) caycag chay tunapita uranpa lamarcama cörripäcuran y chaychru shengaypa wañupäcuran. ");
INSERT INTO qva_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Chay cuchi michegcuna cörrir gueshpir marcachru tiyag runacunata y chracracunachru tiyag runacunata chaynuy pasaycanganta willag aywaran. Willapäcuptinmi runacuna ima pasangantapis ricananpag aywapäcuran. ");
INSERT INTO qva_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesuscagman chrayarna chay runata cuticashana ali yarpayninchrüna röpan jatishana jamaraycagta taripäcuran. Chay runaga achca waranga diablucunapa munayninchru casha caran. Chayta ricarmi runacuna manchacasha carcaran. ");
INSERT INTO qva_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Diablucunapa munayninchru casha cangan runata y cuchicunata ima pasangantapis ricagcunam waquincunata willapäcuran. ");
INSERT INTO qva_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Chauraga Jesusta rugapäcuran chay partipita aywacunanpag. ");
INSERT INTO qva_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Büquiman Jesús aywacunanpag jegaptinna chay diablucunapa munayninchru canganpita cuticag runa Jesusta rugacuran paywanpis aywacunanpag. ");
INSERT INTO qva_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ichanga Jesús mana munaranchu y niran: “Wasiquipa aylluyquicunaman cuticuy. Willapanqui Tayta Diosninchi gamwan imata rurangantapis y gamta cuyapäshungayquita”. ");
INSERT INTO qva_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Chay runa aywacur Decapolischru cag marcancunapa Jesús paywan imata rurangantapis willapayta galaycuran. Willapaptin lapan almirasha quëdapäcuran. ");
INSERT INTO qva_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Chaypita Jesús büquiwan lamarpa jucag chimpanman chrayaruptin achca runacuna shuntacämuran. Jesús lamar cantunchru quëdaran. ");
INSERT INTO qva_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Chaymanmi Jairo jutiyog runa chrayaran. Paymi caran shuntacäpäcunan wasichru mandag. Jesusta ricarur ashuycur ñaupagninman gongurpacuycuran. ");
INSERT INTO qva_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Caynuy nir rugacuran: “Warmi wamrä wañuycanna. Aywayculay; maquiquita jananman chrurayculay cuticänanpag y cawananpag”. ");
INSERT INTO qva_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Chauraga Jesús paywan aywaran. Aywaptin achca runacuna quichrquiypa quichrquir paywan aywaran. ");
INSERT INTO qva_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Chay achca runacunachru chrunca ishcay (12) watana yawar apaywan gueshyaycag warmi aywaycaran. ");
INSERT INTO qva_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Chay gueshyawan achca mëdicucunaman aywaran. Chay mëdicucuna pasaypa nacachiran. Jampicunanpag chararangalantapis lapanta usharan. Imanuypa jampicurpis mana cuticaranchu. Cuticänanpa truquinga mas gueshyaran. ");
INSERT INTO qva_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jesuspita rimagta mayarmi guepanpa runacunapa chraupinpa yaycuycur Jesuspa röpanta yataycuran. ");
INSERT INTO qva_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Yarparan: “Jesuspa röpalantapis yataycurga cuticäshämi” nir. ");
INSERT INTO qva_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Yataycuptin chay höra yawar apaynin chrawacäcuran. Chauraga cuerpunchru gueshyapita cuticasha cangantana mayacuran. ");
INSERT INTO qva_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Chay höra munayninwan pipis cuticanganta tantiyacurir muyurcur runacunata Jesús tapuran: “¿Pitag röpäta yataycusha?” ");
INSERT INTO qva_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Chauraga discïpuluncuna nipäcuran: “Ricaycanqui quichrquiypa quichrquir achca runa aywaycanganchru aywaycangayquita. Chaynuy aywaycashachu tapumanqui: ‘¿Pitag tüpamasha?’ nir”. ");
INSERT INTO qva_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ichanga muyuregninchru caycag runacunata Jesús ricapaycaran pï yataycungantapis musyananpag. ");
INSERT INTO qva_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Chauraga chay warmi cuticasha canganta musyar manchariypita sicsicyaycar Jesuspa ñaupagninman aywaycur gongurpacuycuran. Nircurna willaran paypa röpanta yataycur cuticanganta. ");
INSERT INTO qva_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesús niran: “Hïja, yäracuyniquipam cuticashana caycanqui. Cananga cushishana y cuticashana aywacuy”. ");
INSERT INTO qva_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesús parlaycaptinrämi mandag Jairupa wasinpita runacuna chrayaycur Jairuta niran: “Wamrayqui wañushanam. Maestruta wasiman amana pushaynachu”. ");
INSERT INTO qva_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesús chay willagcunata mana cäsuypa shuntacäpäcunan wasichru mandagta niran: “Ama manchariychu. Gamga yäracuy”. ");
INSERT INTO qva_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jairupa wasinman Jesús aywarna pipis aywananta mana munaranchu. Pedruta, Santiaguta y Santiagupa wauguin Juanta pushacurcular aywaran. ");
INSERT INTO qva_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Shuntacäpäcunan wasichru mandagpa wasinman chrayar achca runa büllata rurarcagta y achca runa gaparayparag wagarcagta tariran. ");
INSERT INTO qva_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yaycurir niran: “¿Imanirtag chayjinanpa wagarcanqui? Wamra manam wañushachu sinöga puñucashalam caycan”. ");
INSERT INTO qva_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Jesús niptin runacuna asicäriran. Ichanga chaychru caycag lapan runacunata gargariycamur wamrapa taytanta mamanta y paywan aywagcunata pushacurcur wamra caycangancagman yaycuran. ");
INSERT INTO qva_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Chaychrüna wamrata maquinpita charircur niran: “Talita, cumi”. (“Talita, cumi” ninganga “Wamra, gamta nï: Sharcuy” ninanmi.) ");
INSERT INTO qva_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Niptin wamra chay höra sharcurcur puriran. Chay wamra chrunca ishcay (12) watayognam caycaran. Chaychru caycag runacuna pasaypa almirasha carcaran. ");
INSERT INTO qva_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Paycunata pitapis mana willapänanpag Jesús fiyupa niran. Nircurna wamrata micuyta garananpag niran. ");
INSERT INTO qva_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Chaypita aywacurna Jesús marcanman aywaran. Discïpuluncunapis paywan aywaran. ");
INSERT INTO qva_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sábado jamay junagna shuntacänan wasichru yachrachiyta galaycuran. Mayagcuna achcag almirasha tapupäcuran: “¿Maychrütag cay chayjinanpa yachracusha? ¿Maypitatag chay yachrangancunata jorgamusha y imanuypatag milagrucunata ruran? ");
INSERT INTO qva_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Manachu cayga carpintëru? ¿Manachu Mariapa wawan y Santiagupa, Josëpa, Judaspa y Simonpa wauguin? ¿Panincunapis manachu noganchiwan caychru tiyan?” Chaynuy nirmi Jesusta mana chrasquicäriranchu. ");
INSERT INTO qva_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ichanga Jesús niran: “Juc lädu marcacunachrüga Tayta Diospa willacogninta respitäpäcunmi. Ichanga quiquinpa marcamasincunapis ni quiquinpa aylluncunapis ni quiquinpa familianpis mana respitäpäcunchu”. ");
INSERT INTO qva_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Chaychru manam ima milagrutapis rurayta puediranchu; juc ishcay gueshyagcunalatam yataycur cuticächiran. ");
INSERT INTO qva_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Pay almirasha caycaran marca masincuna payman mana criyinganpita. Jesús puriran marcacunapa runacunata yachraycächir. ");
INSERT INTO qva_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesús chrunca ishcay (12) discïpuluncunata gayaycur ishcaypa cama cachraran. Munayninta goran runacunapita diablucunata gargunanpag. ");
INSERT INTO qva_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Paycunata niran imatapis mana apananpag ni mircapanta ni guepinta ni guellayninta. Niran tucapilanta apananpag. ");
INSERT INTO qva_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Llanquilanta jaticärinanpag niran. Trucacunanpag röpantapis mana apapäcunanpag niran. ");
INSERT INTO qva_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Chaynuypis niran: “Maychrüpis juc wasiman chrayarga chaypita aywacäringayquicama chay wasilachru pacharäcärinqui. ");
INSERT INTO qva_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","May marcachrüpis mana chrasquipäcushuptiquega ni mayayta mana munapäcushuptiquega chaypita chraquiquichru lagacasha polvuta tapshirir aywacärinqui. Chay canga paycuna mana chrasquicärishungayquipita Dios castigänanpag canganta tantiyacärinanpag”. ");
INSERT INTO qva_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Chauraga discïpuluncuna willacuraycar runacuna juchanpita wanacurir Tayta Dios munangannuyna cawananpag niycar aywapäcuran. ");
INSERT INTO qva_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Chaynuypis runapita diablucunata garguran. Achcagta gueshyagcunata aceitita lushipärir cuticächiran. ");
INSERT INTO qva_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Rey Herodes mayaran Jesús imaycatapis ruranganta. Chaynuy mayaran may chaymanpis Jesús imaycatapis rurangan chrayaptin. Waquin runacuna nipäcuran Juan Bautista cawarimunganta. Cawarimusha car milagrucunata rurananpag munayniyog canganta. ");
INSERT INTO qva_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Waquinna nipäcuran Tayta Diosninchipa willacognin Elías canganta. Waquin nipäcuran juc willacog unay willacogcunanuy canganta. ");
INSERT INTO qva_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Chay lapanta mayarmi Herodes niran: “Chay canga Juan Bautistam. Noga payta cuncanta cuchuypam wañuchichirä. Cananga cawarimusha”. ");
INSERT INTO qva_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herodiaspa jananmi Juan Bautistata Herodes prësu charichisha caran. Nircur carcilchru wichrgachisha caran. Herodías Felipipa warminmi caran. Felipe Herodispa wauguinmi caran. Wauguin Felipipa warmin Herodías caycaptinpis warminpag Herodes pushacusha caran. ");
INSERT INTO qva_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Herodes Juan Bautistata carcilchru wichrgachisha caran Juan Bautista Herodista “Leyninchichrüga manam alichu wauguiquipa warmin Herodiaswan tiyanayquipag” nisha captin. ");
INSERT INTO qva_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Chaypitam Herodías Juan Bautistata rabyaparan y wañuchiyta munaran. Ichanga mana puediranchu. ");
INSERT INTO qva_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodes Juan Bautistata manchacuran ali rurag y juchaynag runa canganta musyarmi. Chaymi amacharan pipis payta wañuchinanta. Imata niptinpis imata yarpachracuytapis mana puedegchu. Juan Bautista imata ningantapis Herodes cushisha mayaparag. ");
INSERT INTO qva_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Rey Herodispa diyan chrayamuran Herodías Juan Bautistata wañuchichiyta munaycaptilan. Chay diyanchrümi fiestata rurachir autoridäcunata, soldäducunapa mas mandagnincunata y Galileachru tiyag respitädu runacunatapis gayachiran. ");
INSERT INTO qva_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Lapan micurcaptin Herodiaspa jipashnin yaycuycur dansaran. Chay dansangan Herodista pasaypa gustaran y paywan micurcagcunatapis gustaran. Chaymi jipashta Herodes niran: “Mañacamay; ima munangayquitapis noga goycushayquim”. ");
INSERT INTO qva_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Pay juraran: “Lapan mañacamangayquitam goycushayqui. ‘Pulan nacion munayniquichru caycagta raquipaycamay’ nimaptiquipis raquipaycushayquim”. ");
INSERT INTO qva_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Chauraga maman cagman aywaycur chay jipash tapuran: “¿Imatatag mañacüman?” nir. Maman niran: “Juan Bautistapa umanta goycushunayquipag mañacuy”. ");
INSERT INTO qva_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Chauraga rey Herodes caycanganman jipash jucla cutiycur niran: “Canan höra munä Juan Bautistapa umanta plätuchru gomänayquitam”. ");
INSERT INTO qva_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Rey Herodes pasaypa laquicuran. Lapan gayachingancuna mayaycaptin jurasha carmi mañacuycanganta niegayta mana puediranchu. ");
INSERT INTO qva_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Chauraga juc soldäduta jucla cachraran Juanpa umanta apamunanpag. Soldädu carcilman aywaycur Juanpa umanta rogumuran. ");
INSERT INTO qva_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Nircurna plätuwan apaycur jipashta entregaran. Jipashna mamanta entregaycuran. ");
INSERT INTO qva_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Chaynuy ruranganta Juanpa discïpuluncuna mayaycur Juanpa cuerpunta apacäriran pampapäcunanpag. ");
INSERT INTO qva_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Chaypitana apostulnincuna Jesuswan shuntacaran. Chaychrüna imata rurapäcungantapis y yachrachipäcungantapis willaparan. ");
INSERT INTO qva_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesús niran: “Shapäcamuy; nogalanchi juc lädu chunyagninman aywashun chaychru jamapärinanchipag”. Chaynuy aywapäcuran achca runa captin ni micunanpäpis tiempo mana captinmi. ");
INSERT INTO qva_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Chaypitana Jesús apostulnincunawan chunyagninman büquiwan aywacäriran. ");
INSERT INTO qva_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Aywaycagta ricar achcag reguipäcuran. Chauraga lapan marcacunapita runacuna Jesús chrayananpag cag chunyag jircaman manaräpis chrayaptin chraquilapa cörrir chrayapäcuran. ");
INSERT INTO qva_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Büquipita yarpurcurna achca runacuna chaychru carcagta tariran. Paycuna michegniynag üsha caycangannuy captin cuyaparan. Chaychru paycunata achcata yachrachiran. ");
INSERT INTO qva_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pacha tardiyaruptinna ashuycur discïpuluncuna Jesusta nipäcuran: “Pacha tardiyaycanna y imapis mana cangan jircachrümi caycanchi. ");
INSERT INTO qva_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","‘Aywacäriyna’ niy cay runacunata cercachru estanciacunapa y cercachru marcacunapa micuyninta ranteg aywacärinanpag”. ");
INSERT INTO qva_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Chauraga Jesús niran: “Gamcuna paycunata micuyta gopäcuy”. Discïpuluncuna nipäcuran: “Caychica runata micuyta gopäcunäpag ishcay pachrac jornal runa gänanganwan rantipäcamuptïpis mana aypangachu”. ");
INSERT INTO qva_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús niran: “¿Ayca tantatatag chararcanqui? Ricapäcamuy”. Ricaycurna nipäcuran: “Caycan pichga tanta y ishcay pescädulam”. ");
INSERT INTO qva_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Chauraga niran runacunata raquircur raquircur pashpaman jamachinanpag. ");
INSERT INTO qva_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Runacuna pachrac cama (100) y pichga chrunca cama (50) jamacäriran. ");
INSERT INTO qva_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Chauraga Jesús pichga tantata y ishcay pescäduta aptarcur cieluta ricärir Tayta Diosta rugacur agradecicuran. Nircurna tantata partirir partirir discïpuluncunata chacyaran lapan runacunata aypunanpag. Chaynuy ishcan pescädutapis aypuran. ");
INSERT INTO qva_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Lapan sacsangancama micapäcuran. ");
INSERT INTO qva_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Puchupacungancunata tantatawan pescäduta chrunca ishcay (12) canastata shuntapäcuran. ");
INSERT INTO qva_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Chaychru micogcuna caran pichga waranga (5,000) olgucunam. ");
INSERT INTO qva_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Chay höra discïpuluncunata Jesús niran büquiman jegarcur Betsaida marcaman ñaupapäcunanpag. Pay quëdaran chaychru cag runacunata despachäpacur. ");
INSERT INTO qva_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Despachapacurirna jircaman jegaran Tayta Diosninchita rugacamunanpag. ");
INSERT INTO qva_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pacha chacaycaptinna discïpuluncuna aywaycangan büqui lamar chraupintana aywaycaran. Jesús quiquilan jircachru quëdaran. ");
INSERT INTO qva_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jesús ricaran büquita wayra cutichimuptin nacar discïpuluncuna aywarcagta. Wallpa wagay höranuy caycaptin paycuna cagman yacu jananpa Jesús aywaran. Nircur chaypa pasacunan caran. ");
INSERT INTO qva_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Lamar jananpa puregta ricar alma canganta yarpäpäcur fiyupa mancharir gapachracäriran. Ichanga Jesús jucla niran: “¡Ama mancharipäcuychu! Nogam caycä”. ");
INSERT INTO qva_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Chaynuy nir büquiman jegarcuptin wayrapis jucla chrawaran y discïpuluncuna pasaypa almirasha ricacäpäcuran. ");
INSERT INTO qva_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Chaynuy almirasha ricacuran Jesús tantawan milagru ruranganta mana tantiyarmi. Jesús pï cangantapis manam tantiyayta puedipäcuranchu. ");
INSERT INTO qva_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Chay lamarta pasarna Genesaret partiman chrayapäcuran. Chaychrüna büquinta lamar cantunman watapäcuran. ");
INSERT INTO qva_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Büquipita Jesús yarpuriptin runacuna jucla payta reguipäcuran. ");
INSERT INTO qva_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Chauraga lapan partipa jucla runacuna cörrir aywapäcuran y gueshyagcunata Jesusman apapäcamuyta galaycapäcuran. “Jesús chaychru caycanmi” niptin mayar Jesús cagman gueshyagcunata quirmawan apapäcamuran. ");
INSERT INTO qva_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jesús maymanpis chrayangancagchrüga marcacunachrüpis y estanciacunachrüpis camiñuman gueshyagcunata chruraycur rugapäcuran chaypa Jesús pasaptin röpanpa cantulantapis yataycunanpag. Jesuspa röpanpa cantulantapis yataycogcuna cuticaran. ");
INSERT INTO qva_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Fariseucuna y Moisés escribingan leycunata yachrachegcunawan Jesús cagman shuntacäpäcuran. Chay yachrachegcuna Jerusalenpita chrayapäcamusha caycaran. ");
INSERT INTO qva_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Chaychrümi Jesuspa juc ishcay discïpuluncuna maquinta mana mayllacular micuycagta ricar jamurpäpäcuran. ");
INSERT INTO qva_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Fariseucuna y Israel runacunaga unay runacunapa costumbrincunata cumpleg. Maquinta manarag mayllacurga imatapis manam micogchu. ");
INSERT INTO qva_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Mercädupita cutircamur mayllacünilaga manam micogchu. Mas juc costumbricunatapis cumpleg. Väsuncunata, järrancunata, broncipita mancancunata mayllag y cämancunatapis tagshag.) ");
INSERT INTO qva_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Chaymi fariseucuna y Moisés escribingan leycunata yachrachegcuna Jesusta tapupäcuran: “¿Imanirtag discïpuluyquicuna unay runacunapa costumbrincunata mana cäsur maquincunata mana mayllacular micapäcun?” ");
INSERT INTO qva_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Chauraga Jesús niran: “¡Yachragtucogcuna! Tayta Diospa willacognin Isaías rasunpam gamcunapag caynuy capäcunayquipag willacuran: ‘Cay runacunaga shimilanpam respitäpäcaman; shongunchrüga juctam yarparcaycan. ");
INSERT INTO qva_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Adoräpäcamanganpis imapäpis manam välinchu. Yachrachipäcun “Cayga Diospa yachrachicuyninmi” nir. Yachrachingancunaga runacunapa mandamientulanmi’. ");
INSERT INTO qva_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Gamcuna Tayta Dios mandanganta jaguiriycur runacunapa costumbrilantam rurarcanqui”. ");
INSERT INTO qva_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Chaynuypis niran: “Tayta Dios ninganta jaguiriycärinqui costumbrilayquicunata cäsupäcunayquipag. ");
INSERT INTO qva_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés niran: ‘Mamayquita y taytayquita respitay’ y ‘Pipis mamanta o taytanta lïsogpag cäga wañuchisha cachun’. ");
INSERT INTO qva_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Gamcunaga yachraycächinqui maygan runapis taytanta o mamanta yanapänanpa truquinga ‘Yanapayta manam puedïchu imaycäpis Corbán caycan’ nipäcunanpag. (Corbanga ‘Tayta Dioslapag cag’ ninanmi.) ");
INSERT INTO qva_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Chaynuy nir runata yachraycächinqui mamanta o taytanta mana yanapänanpag. ");
INSERT INTO qva_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Chaynuypa gamcunaga Tayta Diosninchipa yachrachicuyninta manacagman chrurar jucniqui jucniquipis costumbrilayquicunata willapänacärinqui. Chaynuyla mas waquintapis rurarcanqui”. ");
INSERT INTO qva_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Chaypitana yapay runacunata gayaycur Jesús niran: “Lapayqui shumag mayapäcamay y tantiyapäcuy: ");
INSERT INTO qva_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Manam shiminpa yaycunganchu runata juchäcachin, sinöga shiminpa yargamunganmi runata juchäcachin. ");
INSERT INTO qva_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","¡Ningäta mayag cäga shumag tantiyacäriy!” ");
INSERT INTO qva_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Chay achca runacunata Jesús jaguiricurnam wasiman yaycuran. Chaychrünam discïpuluncuna tapupäcuran chay yachrachingancunapita tantiyachinanpag. ");
INSERT INTO qva_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesús niran: “¿Gamcunapis manachu tantiyapäcunquirag? ¿Manachu tantiyapäcunqui imatapis micunganga mana juchäcachinganta? ");
INSERT INTO qva_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Micunganga shongunmanchu manam yaycun sinöga pachranmanmi y chaypitana pasacun”. (Chaywan niran lapan micunacäga runata mana juchäcachinganta.) ");
INSERT INTO qva_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Mastapis niran: “Shiminpa yargamunganmi ichanga runata juchäcachin. ");
INSERT INTO qva_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Runapa shongunpitam lutan yarpaycuna yargamuptinmi manaräpis casaracur majanwannuy puñucun, suwacun, wañuchin, majayog caycar majanwannuy jucwan puñucun, ");
INSERT INTO qva_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","malag, jucpa contran mana alita ruran, engañan, viciucunalaman yarparan, envidioso, jucpa washanta riman, yachragtucun y mana yarpachracog. ");
INSERT INTO qva_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Chay lapan lutan yarpaycuna runapa shongunpita yargamogmi runata juchäcachin”. ");
INSERT INTO qva_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Chaypita Jesús Tiro partiman y Sidón partiman aywaran. Chaychru canganta pipis mana musyananta munarmi juc wasiman yaycucuycuran. Ichanga pacacuyta mana puediranchu. ");
INSERT INTO qva_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Chaychru Jesús canganta musyaycurmi juc warmi Jesuscagman aywaycur ñaupagninman gongurpacuycuran. Chay warmipa wamrantam diablo munayninchru chararan. ");
INSERT INTO qva_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Chay warmi Israel castachu manam caran sinöga Sirofenicia partipitam caran. Paymi Jesuscagman aywaycur rugaran wamranpita diabluta gargunanpag. ");
INSERT INTO qva_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesús niran: “Puntata wamracunarag micucurcuchun. Manam alichu canman paycunata guechrurir algucunata garaycusha”. ");
INSERT INTO qva_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Chay warmi niran: “Au, tayta. Ichanga wamracuna shicwapacunganta mësa chraquinchru cag algucunapis micunmi”. ");
INSERT INTO qva_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesús niran: “Chaynuy ningayquipita mana laquicuypana aywacuy. Wamrayquipita diablo yargushanam caycan”. ");
INSERT INTO qva_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Chay warmi wasinman chrayarna wamranta alina cämanchru chrachraraycagta tariran. Diablo yargucushanam caycaran. ");
INSERT INTO qva_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús Tiro partipita yargur Sidón partipa pasaran. Decápolis partipa pasar Galilea lamarman chrayapäcuran. ");
INSERT INTO qva_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Chaymanmi pushapäcuran mana mayag y rimayta mana puedeg runata. Y Jesusta rugapäcuran chay upata yataycunanpag. ");
INSERT INTO qva_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Chauraga Jesús quiquilanta juc läduman pusharcur upapa rinrinman dëdunta jatiran. Nircur dëdunta togayninwan ushmarcachir gallunta yataycuran. ");
INSERT INTO qva_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nircur cieluta ricärir jämayninta cachrarir: “¡Efata!” niran. (Efata ninanga “¡Quichracay!” ninanmi.) ");
INSERT INTO qva_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Chauraga chay höra upapa rinrin quichracaran y shimin pascacaran. Shumagna rimayta galaycuran. ");
INSERT INTO qva_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Cuticarcachirna Jesús pitapis mana willapänanpag niran. Mana willapänanpag mas niptinpis pï maytapis mas willaparan. ");
INSERT INTO qva_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Chaynuy Jesús ruranganpita lapan pasaypa almirasha car nipäcuran: “¡Imaycatapis alitam ruraycan! ¡Upacunatapis mayachin y mana rimagcunatapis rimachin!” ");
INSERT INTO qva_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Chay wichan yapay achca runacuna Jesús cagman shuntacaptin micapäcunanpag imapis mana caranchu. Chaymi discïpuluncunata gayaycur niran: ");
INSERT INTO qva_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Cuyapämi cay runacunata. Paycuna quimsa junagna caychru noganchiwan caycan; micunanpag imapis mana canchu. ");
INSERT INTO qva_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Wasinpa cama micanaycagta cachraptïga aywaycangalanchru wañucarpis wañucarunmanmi. Paycuna waquinga carupitam aywapäcamusha”. ");
INSERT INTO qva_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Discïpuluncuna nipäcuran: “¿Imanuypatag micuyta goshun chunyag jircachru caycarga?” ");
INSERT INTO qva_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesús tapuran: “¿Ayca tantatatag gamcuna chararcanqui?” Niptin “Ganchrista” nipäcuran. ");
INSERT INTO qva_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Chauraga lapan runacunata pampaman jamacärinanpag niran. Nircur ganchris tantata aptarcur Tayta Diosta Jesús agradecicurir partirir partirir discïpuluncunata chacyaran runacunata aypupäcunanpag. ");
INSERT INTO qva_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Chaynuy juc ishcay acapala pescäduta charäpäcungantapis Jesús aptarcur Tayta Diosta rugacur agradecicuran. Chaytapis aypupäcunanpag niran. ");
INSERT INTO qva_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Lapan sacsangancama micapäcuran. Puchungancunatana ganchris canasta juntata shuntapäcuran. ");
INSERT INTO qva_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Chaychru micogcunaga chruscu waranganuy (4,000) caran. Micuyta usharcäriptinna lapan runacunata aywacunanpag niran. ");
INSERT INTO qva_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Chaypitanam Jesús discïpuluncunawan büquiman jegarcur Dalmanuta jutiyog partiman aywacuran. ");
INSERT INTO qva_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Chayman fariseucuna chrayaycur Jesuswan lïturan. Lutanta rurachiyta munar Tayta Diosninchi rasunpa cachramunganta musyapäcunanpag Jesús ima milagrutapis rurananpag nipäcuran. ");
INSERT INTO qva_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Chauraga Jesús fiyupa laquicurir niran: “¿Imanirtag cay runacuna milagrutarag ruranäta munapäcun? Rasunpam gamcunata nï: Ima milagrupis manam ruracangachu”. ");
INSERT INTO qva_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nircurna chay runacunata jaguiriycur büquiman jegarcur lamarpa jucag cantunman aywacäriran. ");
INSERT INTO qva_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Chay aywarmi tantata apayta gongapäcusha casha. Büquichru juc tantalata chararcasha. ");
INSERT INTO qva_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesús niran: “Mayapäcamay; fariseo runacunapa y Herodispa levadüranpita cuydacärinqui”. ");
INSERT INTO qva_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Niptin discïpuluncuna quiquinpura parlarcaran: “Tantata mana chararanganchipitam niycämanchi”. ");
INSERT INTO qva_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Discïpuluncuna parlaycanganta tantiyacurir Jesús niran: “¿Imanirtag parlarcanqui tanta mana canganpita? ¿Manachu tantiyacärinquirag? ¿Upachu capäcunqui mana tantiyapäcunayquipag? ");
INSERT INTO qva_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Gamcunaga ñawiyog caycarpis mana ricagnuymi carcanqui? ¿Rinriyog carpis mana mayagnuymi carcanqui? ¿Manachu yarpäpäcunqui? ");
INSERT INTO qva_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Pichga tantata pichga waranga (5,000) runacunata aypuptï ¿ayca canasta juntatatag puchupacungancunata shuntapäcurayqui?” Paycuna nipäcuran: “Chrunca ishcaytam (12)”. ");
INSERT INTO qva_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Chaynuypis ganchris tantata chruscu waranga (4,000) runacunata aypuptï ¿ayca canasta juntatatag puchupacungancunata shuntapäcurayqui?” Nipäcuran: “Ganchrista”. ");
INSERT INTO qva_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jesús niran: “¿Manarächu tantiyapäcunquirag?” ");
INSERT INTO qva_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Chaypita discïpuluncunawan Jesús Betsaida marcaman chrayaran. Chaymanna pushapäcuran juc gapra runata. Nircur rugapäcuran gaprata yataycunanpag. ");
INSERT INTO qva_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesús chay gapra runata maquipita janchracurcur marcapita jorguran. Chaychrüna togayninwan gaprapa ñawinta ushmachiran. Nircurna yataycur tapuran ricanganta o mana ricanganta. ");
INSERT INTO qva_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Gapra ricayta galaycurna niran: “Ricaycä runacunata. Purircag yüranuy carcaycan”. ");
INSERT INTO qva_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesús yapay gaprapa ñawinta yataycuran. Chauraga shumag ricärir alina ricaran. ");
INSERT INTO qva_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Chauraga wasinman aywacunanpag Jesús niran. Ichanga niran: “Marcaman ama yaycuychu”. ");
INSERT INTO qva_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Chaypita Jesús discïpuluncunawan Cesarea de Filipupa caseriuncunaman aywaran. Aywarcanganchrümi discïpuluncunata Jesús tapuran: “¿Pï cangätatag nogapag runacuna nipäcun?” ");
INSERT INTO qva_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Paycuna nipäcuran: “Waquin nipäcun Juan Bautista cangayquita. Waquinnam nipäcun Elías cangayquita. Y waquin nipäcun Tayta Diospa maygan willacogninpis cangayquita”. ");
INSERT INTO qva_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jesús niran: “¿Gamcunaga pï cangätatag nipäcunqui?” Pedro niran: “Gamga Tayta Dios cachramungan Salvadurmi caycanqui”. ");
INSERT INTO qva_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nircurnam Jesús niran paypita pitapis mana willapänanpag. ");
INSERT INTO qva_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Chaypita pachanam Jesús willaparan Diospita shamusha Runaga fiyupa nacananpag canganta. Chaynuypis Israel mayor runacuna, cüracunapa mandagnincuna y Moisés escribingan leycunata yachrachegcuna contran sharcunanpag canganta. Niran wañuchinanpag canganta y quimsa junagtaga cawarimunanpag canganta. ");
INSERT INTO qva_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Chaytaga mana pacaypam niran. Chauraga juc läduman quiquilanta Jesusta Pedro pusharcur piñapayta galaycuran. ");
INSERT INTO qva_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesús discïpuluncunacagman muyurcamur Pedruta piñaparan: “¡Satanás, ñaupagnïpita ashucuy! Gam manam munanquichu Tayta Dios munanganta ruranäta sinöga munanqui runacuna munanganta ruranätam”. ");
INSERT INTO qva_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nircur discïpuluncunata y runacunata gayaycur niran: “Pipis discïpulü cayta munarga quiquinpa shongun munangalannuyga ama cawachunchu. Chaypa truquinga wañunan captinpis noga munangänuy imaypis cawachun. ");
INSERT INTO qva_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Pipis quiquilanpita salvacuyta munagcäga manam salvacungachu. Ichanga noga janan y ali willacuy janan wañurpis wañuptinga salvacungam. ");
INSERT INTO qva_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mana ushacaypa cawayman mana aywananpag caycaptinga ¿imapätag välin cay pachachru imaycayogpis cangan? ");
INSERT INTO qva_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mana ushacaypa cawayman aywananpag ¿pägayta puedinmanchurag? ");
INSERT INTO qva_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Pipis nogapita y ali willacuynïpita cay juchasapa runacunapa y Tayta Diosta jaguiregcunapa ñaupagninchru pengacuptinga noga Diospita shamusha Runapis Taytäpa chipipayninwan y Diospita angilcunawan cutimur paypa pengacushämi”. ");
INSERT INTO qva_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesús caynuypis niran: “Rasunpam gamcunata nï: Caychru waquin caycagcuna manarämi wañungarächu Tayta Diospa munaynin lapan munayninwan chrayamogta ricangancama”. ");
INSERT INTO qva_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Chaypita sogta junag pasarcuptin Pedruta, Santiaguta y Juanta pushacurcur Jesús altunnin jircaman jegaran. Chaychrümi paycuna ricaycaptin jucnuyman ticraran. ");
INSERT INTO qva_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Röpanpis chipipaycag yurag ricacuran. Chaynuyga pipis mayjina tagsharpis manam yuragyächinchu. ");
INSERT INTO qva_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Chaychrümi ricapäcuran Moisés y Elías ricariparcur Jesuswan parlaycagta. ");
INSERT INTO qva_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pedro niran Jesusta: “Maestro, ima alish caychru nogacuna carcä. Cananga quimsa chuclacunata rurapäcushag: jucta gampag, jucta Moisespag, jucta Eliaspag”. ");
INSERT INTO qva_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Discïpuluncuna fiyupa manchacasha carcaran. Chaymi Pedro imaniytapis mana niyta puedir chaynuy rimariran. ");
INSERT INTO qva_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Chaymannam pucutay ricarimur paycuna jananman ichriran. Chay pucutay rurinpitanam nimuran: “Payga cuyay Wamrämi. Payta mayacäriy”. ");
INSERT INTO qva_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Chaypita yapay ricärirga paycunawan pitapis mana ricapäcuranchu. Jesusta quiquilantana ricapäcuran. ");
INSERT INTO qva_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Chay jircapita yarparcämurna Jesús paycunata niran ricangancunata pitapis mana willapänanpag Diospita shamusha Runa wañunganpita cawarimungancama. ");
INSERT INTO qva_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Chaynuy ricangancunata pitapis mana willaparanchu. Ichanga quiquinpura yarpachracäriran “Wañungäpita cawarimushämi” ninganpita. ");
INSERT INTO qva_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Chaypitana paycuna Jesusta tapuran: “¿Imanirtag Moisés escribingan leycunata yachrachegcuna nipäcun Tayta Dios cachramungan Salvador shamunanpag puntata Eliasrag shamunanpag canganta?” ");
INSERT INTO qva_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesús niran: “Rasunpam Elías puntata shamunga lapanta alichananpag. Chaynuy captinpis Tayta Diosninchi escribichinganchru niycan noga Diospita shamusha Runa nacachisha y mana alipag ricasha canäpag canganta. ");
INSERT INTO qva_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ichanga noga nï Elías shamushana canganta. Paytaga munanganta maynam rurapäcushana imanuypis pasananpag Tayta Dios escribichinganchru escribisha cangannuyla”. ");
INSERT INTO qva_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jircapita cutipäcamurnam waquincag discïpuluncunaman aywar achca runacuna muyuparaycagta y Moisés escribingan leycunata yachrachegcuna paycunata lïtupaycagta tariran. ");
INSERT INTO qva_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jesusta ricar jucla lapan almiraran y cörripäcuran saludänanpag. ");
INSERT INTO qva_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesús tapuran: “¿Imapitatag gamcuna paycunawan lïturcanqui?” ");
INSERT INTO qva_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Chaychru caycag jucnincag runa niran: “Maestro, diablo upayächingan wamräta apamushcä. ");
INSERT INTO qva_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","May chaychru charirpis chay diablum wamräta pampaman sagtan. Pushgayta japchuchin, quiruntapis cachruchin; nircur guerucasha quëdan. Chaymi discïpuluyquicunata rugacushcä chay diabluta wamräpita gargunanpag. Ichanga manam puedipäcushachu”. ");
INSERT INTO qva_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesús niran: “¡Yäracuyniynag runacuna! ¿Imaycamarag gamcunawan caycäshag? ¿Imaycamarag gamcunata awantäshayqui? Chay wamrata cayman apamuy”. ");
INSERT INTO qva_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Chauraga Jesuspa ñaupagninman chay wamrata apapäcuran. Chaymi Jesusta ricarir wamrata diablo fiyupa tapshirir pampaman sagtariycuran. Chauraga chay mösu pushgayta japchuycar pampachru gochrparan. ");
INSERT INTO qva_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Wamrapa papäninta Jesús tapuran: “¿Imaypita pachatag caynuy wamrayqui caycan?” Papänin niran: “Tacsha canganpita pacham. ");
INSERT INTO qva_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Achca cuti chay diablo wañuchiyta munar ninamanpis yacumanpis sagtasha. Imalatapis rurayta puedirga yanapaycärilämay, cuyapaycärilämay”. ");
INSERT INTO qva_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús niran: “¡Imanirtag ninqui ‘puedirga’! Criyiptiquega lapanmi puedican”. ");
INSERT INTO qva_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Chauraga wamrapa taytan gaparir niran: “Noga criyïmi. Yanapaycalämay masta criyinäpag”. ");
INSERT INTO qva_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Achca runacuna shuntacaycämogta ricarmi chay wamrachru caycag diabluta Jesús jucla piñaparan: “¡Upayächeg y mana rimacheg diablo! Noga mandä: ¡Cay wamrapita yarguy! ¡Cananpitaga imaypis cay wamraman ama yapay yaycuynachu!” ");
INSERT INTO qva_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Chauraga chay diablo gaparir chay wamrata pasaypa tapshirir yarguran. Yargurna wañushatanuy cachrariran. Achcag yarpäpäcuran wañushana canganta. ");
INSERT INTO qva_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ichanga maquipita charircur Jesús chay wamrata sharcachiran. Y chay wamra ichrircuran. ");
INSERT INTO qva_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Chaypitana Jesús juc wasiman yaycuran. Chaychrünam discïpuluncuna quiquilanta tapuran: “¿Imanirtag nogacuna chay diabluta garguyta mana puedipäcushcächu?” ");
INSERT INTO qva_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesús niran: “Cay nirag diablutaga gargunchi Tayta Diosninchita rugacur-rämi y ayunar-rämi”. ");
INSERT INTO qva_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Chaypita aywacurnam Galilea provinciapa pasapäcuran. Ichanga discïpuluncunata yachrachiptin Jesús mana munaranchu pipis musyananta chaypa pasarcanganta. Paycunata caynuy nir Jesús willapaycaran: “Noga Diospita shamusha Runam runacunapa maquinman entregasha cashag. Chay runacunam wañuchipäcamanga. Ichanga quimsa junagtaga cawarimushämi”. ");
INSERT INTO qva_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Paycunaga Jesús ningancunata manam tantiyapäcuranchu y tapuyta manchacäriran. ");
INSERT INTO qva_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Capernaum marcaman chrayapäcuran. Wasichru caycarna discïpuluncunata Jesús tapuran: “Camiñupa shamur ¿imapita parlartag pelya pelya aywarcämurayqui?” ");
INSERT INTO qva_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mayganpis mas alipag ricasha cananpag canganpita pelya pelya parlasha carmi paycuna imatapis mana rimacäriranchu. ");
INSERT INTO qva_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Chauraga Jesús jamaycur chrunca ishcay (12) discïpuluncunata niran: “Maygayquipis mas alipag ricasha cayta munarga pï maypapis uywayninnuy cachun”. ");
INSERT INTO qva_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nircurna juc wamrata lapanpa chraupinman pushamur ichrichiran. Nircur chay wamrata margarcur niran: ");
INSERT INTO qva_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Nogapa jutïchru cay wamratanuy pï wamratapis chrasquegcäga nogatam chrasquiycäman. Nogata chrasquimarga manam nogalatachu chrasquiycäman sinöga cachramagnïtapis chrasquiycanmi”. ");
INSERT INTO qva_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Discïpulun Juan niran: “Maestro, nogacuna ricapäcushcä juc runata gampa munayniquiwan diablucunata garguycagta. Noganchiwan mana pureg captin amachäpäcushcä”. ");
INSERT INTO qva_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesús niran: “Ama amachäpäcuychu. Pipis nogapa munaynïwan milagruta rurag cäga manam conträ rimangachu. ");
INSERT INTO qva_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Pipis contranchi mana carga favurninchim caycan. ");
INSERT INTO qva_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Rasunpam gamcunata nï: Pipis gamcunata juc pusillu yaculatapis discïpulü cangayquipita chacyäpäcushuptiquega paypis premiutam chrasquinga”. ");
INSERT INTO qva_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Pitapis wamracunanuy nogaman yäracamagcagta juchäcachegcagtaga mas alim canman mulinu jatun rumita cuncanman wataparcur lamarman jitarpuycuptin. ");
INSERT INTO qva_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","“Maquiqui juchäcachishuptiquega roguriycuy. Infiernuman ishcan maquiquiwan gaycusha canayquipa truquinga mas ali caycan rogu maquila mana ushacaypa cawayman chrayanayquipag. Infiernuchru ninaga imaypis manam upingachu. ");
INSERT INTO qva_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Infiernuchrüga curucunapis manam wañunchu. Ni ninapis manam upinchu. ");
INSERT INTO qva_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Chraquiqui juchäcachishuptiquega roguriycuy. Infiernuman ishcan chraquiquiwan gaycusha canayquipa truquinga mas ali caycan cutu chraquila mana ushacaypa cawayman chrayanayquipag. ");
INSERT INTO qva_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Infiernuchrüga curucunapis manam wañunchu. Ni ninapis manam upinchu. ");
INSERT INTO qva_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ñawiqui juchäcachishuptiquega ogtiriycuy. Infiernuman ishcan ñawiquiwan gaycusha canayquipa truquinga mas ali caycan juc ñawiyogla Tayta Diospa munayninman chrayanayquipag. ");
INSERT INTO qva_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Infiernuchrüga curucunapis manam wañunchu. Ni ninapis manam upinchu. ");
INSERT INTO qva_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Lapanmi ninawan rupachishanuy canga. ");
INSERT INTO qva_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Cachrega alim. Cachri gamyacaruptinga ¿imanuypatag yapay puchgogman ticrachinqui? Gamcuna cachri mana gamyag cangannuy capäcuy; runa masiquiwan jauca cawapäcuy”. ");
INSERT INTO qva_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Capernaumpita Jesús aywacur Judea provinciaman chrayaran. Nircurna pasaran Jordán mayu chimpanman. Chaychrüpis achca runacuna yapay shuntacaran. Costumbrin cangannuy Jesús yapay yachrachiran. ");
INSERT INTO qva_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Waquin fariseucuna Jesús cagman ashuycur lutanta rimachiyta munar tapupäcuran: “¿Moisés escribingan leycunachru niycan runa warminpita raquicänanpag cangantachu?” ");
INSERT INTO qva_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesús niran: “Moisés raquicaypita ¿imatatag niran?” ");
INSERT INTO qva_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Fariseucuna nipäcuran: “Moisés escribiran raquicangan papilta firmapaycuptinga warmin aywacunanpag canganta”. ");
INSERT INTO qva_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Chauraga Jesús niran: “Moisés gamcunapag chaynuy niran gamcuna mana cäsucog capäcuptiquim. ");
INSERT INTO qva_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ichanga galaycunanchru cay pachata camar ‘Tayta Diosninchi olguta y warmita camaran’. ");
INSERT INTO qva_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Chaymi runa taytanta mamanta jaguirin warminwan majachacänanpag. ");
INSERT INTO qva_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Y ishcan juc runanuylana capäcunga’. Chaynuypa ishcay runanachu mana canga sinöga juc runanuylana canga. ");
INSERT INTO qva_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Chaymi Tayta Dios majachangantaga runa ama raquichunchu”. ");
INSERT INTO qva_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Chaypita wasichru caycarna discïpuluncuna chay yachrachinganpita Jesusta yapay tapupäcuran. ");
INSERT INTO qva_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesús niran: “Pipis warminpita raquicarga juc warmiwan majachacarga puntacag warminpa contran adulterio juchata ruraycan. ");
INSERT INTO qva_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Warmi runanpita raquicarga juc runawan majachacarga adulterio juchata ruraycan”. ");
INSERT INTO qva_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Chaypitana wamracunata Jesús cagman apapäcuran wamracunata yataycur Tayta Diosta rugacunanpag. Wamracunata apapäcamogcunata discïpuluncuna piñaparan. ");
INSERT INTO qva_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Chaynuy piñapaycagta ricar Jesús rabyar niran: “Wamracuna nogaman aywacamuchun; ama amachäpäcuychu. Tayta Diospa munayninchru cawagcuna chay wamracunanuymi carcan. ");
INSERT INTO qva_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Rasunpam gamcunata nï: Wamranuy mana yäracog cäga manam Tayta Diospa munayninman yaycungachu”. ");
INSERT INTO qva_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nircurnam chay wamracunata jucta jucta margacurcur paycunapa jananman maquinta chruraycur paycunata yanapänanpag Tayta Diosninchita rugacuran. ");
INSERT INTO qva_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Chaypita Jesús aywacunanpäna caycaptin juc runa cörriypa chrayaycur ñaupagninman gongurpacuycur tapuran: “Ali maestro, ¿imatatag ruräman mana ushacaypa cawayta chrasquinäpag?” ");
INSERT INTO qva_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús niran: “¿Imanirtag ‘Ali’ nimanqui? Manam pipis ali canchu; Tayta Dioslam alega. ");
INSERT INTO qva_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Gam musyanquinam mandamientuncunata: ‘Runa masiquita ama wañuchiychu. Majayog caycar majayquiwannuy ama jucwan puñucuychu. Ama suwacuychu. Manacagpita pitapis ama tumpaychu. Pitapis ama engañaychu. Taytayquita mamayquita respitay’ ”. ");
INSERT INTO qva_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Chay runa niran: “Maestro, wamra cangäpita pacham chay lapanta cumplishcä”. ");
INSERT INTO qva_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús cuyapar ricärir niran: “Jucrämi pishïshunqui cumplinayqui: Lapan imayquicunatapis ranticuycur pobricunata aypumuy. Chaynuypa cieluman riquësayquita chruracognuymi caycanqui. Nircur shamuy; nogawan puriy discïpulü canayquipag”. ");
INSERT INTO qva_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Chayta niptin chay runapa cäran jucagyätäcuran. Pasaypa rïcu car fiyupa laquisha aywacuran. ");
INSERT INTO qva_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Chauraga Jesús muyuregninchru caycag runacunata ricärir discïpuluncunata niran: “¡Sasam canga rïcu runacuna Tayta Diospa munayninman yaycunanpag!” ");
INSERT INTO qva_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jesús ningancunata mayar discïpuluncuna almirasha quëdaran. Chauraga Jesús yapay niran: “Amïgucuna, ¡sasam caycan pipis Tayta Diospa munayninman yaycunanpag! ");
INSERT INTO qva_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Aujapa ñawinpa camello pasanganpita mas sasa caycan rïcu runa Tayta Diospa munayninman yaycunanpag”. ");
INSERT INTO qva_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Chayta mayar discïpuluncuna mas almirasha quiquinpura tapunacäriran: “Chauraga ¿pirag salvacunga?” ");
INSERT INTO qva_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ricärir Jesús niran: “Quiquilanpitaga runacuna manam salvacuyta puedipäcunchu. Tayta Dioslam pitapis salvan. Paypäga imapis manam sasachu”. ");
INSERT INTO qva_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pedro caynuy niyta galaycuran: “Nogacunaga lapan imaycäcunatapis jaguiriycärishcä gamwan puripäcunäpag”. ");
INSERT INTO qva_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús niran: “Rasunpam gamcunata nï: Pipis noga janan y ali willacuy janan wasinta, wauguincunata, panincunata, mamanta, taytanta, wamrancunata o chracrancunata jaguiriycamusha cagcunaga ");
INSERT INTO qva_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","cay pachachru pachrac (100) cuti masta wasita, wauguincunata, panincunata, mamanta, wamrancunata y chracracunata chrasquipäcunga. Ichanga runacuna payta rabyapangam. Y Tayta Diospa ñaupagninman chrayar mana ushacaypa cawaytam chrasquinga. ");
INSERT INTO qva_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ichanga canan achcag puntacag cagcunaga guepacag canga. Achcag canan guepacag cagcunaga puntacag canga”. ");
INSERT INTO qva_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Chaypitana Jerusalenpa aywar discïpuluncunapa ñaupagninta Jesús aywaycaran. Discïpuluncuna almirasha carcaran y guepanta aywagcuna manchariycar aywarcaran. Chaynuy aywarcaptinmi juc läduman chrunca ishcay (12) discïpuluncunata gayaycur ima pasananpag cangantapis niran: ");
INSERT INTO qva_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Canan Jerusalenpa aywaycanchi. Chaychrümi noga Diospita shamusha Runata cüracunapa mandagnincunapa y Moisés escribingan leycunata yachrachegcunapa maquinman entregasha cashag. Paycunam wañuchisha canäpag nipäcunga y mana Israel runacunapa maquinman entregäpäcamanga. ");
INSERT INTO qva_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nogata asipäpäcamanga, togapäpäcamanga, astipäcamanga y wañuchipäcamanga. Ichanga quimsa junagtaga cawarimushag”. ");
INSERT INTO qva_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zebedeupa wamrancuna Santiaguwan Juan ashuycur Jesusta nipäcuran: “Maestro, rugaculäshayqui. Ama ‘ama’ nimaychu”. ");
INSERT INTO qva_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Chauraga Jesús tapuran: “Gamcunapag ¿imata ruranätatag munapäcunqui?” ");
INSERT INTO qva_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Paycuna nipäcuran: “Mandag cayman chrayar jucnïta derëchacag läduyquiman y jucagnïta ichogcag läduyquiman chruraycärilämanqui mandäshipäcunäpag”. ");
INSERT INTO qva_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesús niran: “Gamcunaga manam musyanquichu imata rugacärimangayquitapis. ¿Gamcuna awantäpäcunquimanchurag nogata nacachimangannuy nacachipäcushuptiqui? ¿Pasamänanpag caycanganta gamcuna pasapäcunquimanchurag?” ");
INSERT INTO qva_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Paycuna nipäcuran: “Au, awantäpäcushämi”. Jesús niran: “Rasunpam gamcunapis noga nacangänuy nacapäcunqui y pasamangannuy pasapäcushunqui. ");
INSERT INTO qva_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ichognïman y derëchäman nogachu manam jamachishag sinöga jamachisha canga mayna acrasha caycagcunalanam”. ");
INSERT INTO qva_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Rugacunganta mayar chrunca cag discïpuluncuna Santiagupäwan Juanpag rabyacuran. ");
INSERT INTO qva_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Chauraga discïpuluncunata gayaycur Jesús niran: “Gamcuna musyapäcungayquinuypis mana Israel naciuncunachru mandagcunaga mandag cayninman atïnicuycur runacunata mandan. ");
INSERT INTO qva_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Gamcunachrüga ama chaynuy canmanchu. Chaypa truquinga maygayquipis mandag cayta munarga waquinpa uywayninnuy canman. ");
INSERT INTO qva_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Gamcunachru maygayquipis mas alipag ricasha cayta munarga waquinpa uywayniquinuy canman. ");
INSERT INTO qva_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Chaynuypis noga Diospita shamusha Runa manam shamushcä mandangäta waquin rurananpächu. Sinöga shamushcä waquin mandanganta ruranäpag y achcag runacuna raycu wañur jucpa munayninchru caycagta jorgunäpämi”. ");
INSERT INTO qva_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Chaypitana Jericó marcaman chrayapäcuran. Jericöpita discïpuluncunawan Jesús y mas achca runacunawan yarguycaptinna Timeupa wamran gapra Bartimeo limusnata mañacuycar camiñuchru jamaraycaran. ");
INSERT INTO qva_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nazaretpita Jesús pasaycagta mayar chay gapra gaparir gayacuran: “¡Jesús, rey Davidpa ayllun, cuyapaycalämay!” ");
INSERT INTO qva_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Achcag runacuna piñaparan upälacunanpag. Piñapaptinpis masrag gayacuran: “¡Rey Davidpa ayllun, cuyapaycalämay!” ");
INSERT INTO qva_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Chauraga Jesús ichriycur niran: “Gayapäcamuy”. Gayamurna gaprata nipäcuran: “¡Valurchacuy! ¡Sharcuy! Gayaycäshunqui”. ");
INSERT INTO qva_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Chauraga cäpanta jitariycur saltar Jesuscagman ashuycuran. ");
INSERT INTO qva_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesús tapuran: “¿Gampag imata ruranätatag munaycanqui?” Chauraga gapra niran: “¡Maestro, ñawï ricanantam munä!” ");
INSERT INTO qva_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús niran: “Aywacuyna; yäracuyniquipam cuticashana caycanqui”. Chay höram gaprapa ñawin cuticaran. Cuticarcuptinna Jesusta gaticurcur aywacuran. ");
INSERT INTO qva_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Discïpuluncunawan Jesús Jerusalenman nagana cercaycarna y Olivos lömachru caycag Betfagé y Betania marcacunaman chrayananpäna caycar ishcay discïpuluncunata cachraran. ");
INSERT INTO qva_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Paycunata niran: “Aywapäcuy tagay chimpa marcaman. Chrayarna marca yaycunachru taripäcunqui pipis manarag logacungan manta bürru wataraycagta. Chayta pasquirir apapäcamunqui. ");
INSERT INTO qva_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Pipis ‘¿imanirtag chaynuy rurarcanqui?’ nipäcushuptiquega nipäcunqui: ‘Señor Jesusmi nisitaycan. Mas rätuman cutirachimunga’ ”. ");
INSERT INTO qva_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Discïpuluncuna aywar wasi puncu cällichru manta bürru wataraycagta taripäcuran. Nircurna pasquipäcuran. ");
INSERT INTO qva_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Chaychru waquin caycagcuna tapupäcuran: “¿Imatatag rurarcanqui? ¿Imapätag bürruta pasquircanqui?” ");
INSERT INTO qva_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Paycuna nipäcuran imanuypa ninanpag Jesús ningannuyla. “Chauraga apay” nipäcuran. ");
INSERT INTO qva_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Chaypitana Jesús cagman manta bürruta apapäcuran. Chaychrüna cäpancunata bürruman carunarcuptin Jesús logacuran. ");
INSERT INTO qva_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Logasha aywaptinnam achcag runacuna camiñuman cäpancunata mashtapäcuran. Waquincuna chracracunachru cangan yürapa rämancunata cuchurir camiñuman mashtapäcuran. ");
INSERT INTO qva_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jesuspa puntanta y guepanta aywagcuna cushicur nipäcuran: “¡Tayta Diosninchi alabasha cayculächun! ¡Tayta Diosninchi cachramungan runa alabasha cayculächun! ");
INSERT INTO qva_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Alabasha cachun unay ayllunchi David mandanganta mandananpag shamog! ¡Tayta Diosninchi alabasha cayculächun!” ");
INSERT INTO qva_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jerusalenman Jesús chrayarna templuman aywaran. Chaychru lapanta ricapacurirna tardina captin chrunca ishcay discïpuluncunawan Betania marcaman aywacäriran. ");
INSERT INTO qva_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Warantin Betania marcapita aywaycarna Jesús micanaran. ");
INSERT INTO qva_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Chauraga carupita achca öjayog hïgus yüra caycagta ricaran. Chrayaycur ashuycuran wayuynin caycanganta ricananpag. Ichanga öjalanta tariran; wayuyninta mana. Wayuynin mana caranrächu tiempun mana captin. ");
INSERT INTO qva_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Chauraga hïgus yürata Jesús niran: “¡Cananpitaga imaypis mananam pipis wayuyniquita micungachu!” Chaynuy ninganta discïpuluncuna mayaran. ");
INSERT INTO qva_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Chaypita Jerusalenman chrayarna templuman Jesús yaycuran. Chaychrünam ranticogcunata y rantegcunatapis garguran. Guellay trucachegcunapa mësantapis y paluma ranticogcunapa sillëtantapis ticraypa usharan. ");
INSERT INTO qva_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Chaynuypis runacunata amacharan templo puncupa imaycanwanpis pasananta. ");
INSERT INTO qva_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Chaypitana caynuy nir yachrachiran: “Tayta Diosninchi escribichinganchru niycan: ‘Wasïga canga may chay nacion runacuna nogata rugacamänanpämi’. Ichanga gamcuna suwapa machrayninmannuy chrurapäcushcanqui”. ");
INSERT INTO qva_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jesús yachrachinganta runacuna almiräpäcuptinmi cüracunapa mandagnincuna y Moisés escribingan leycunata yachrachegcuna payta manchacäriran. Chauraga pay ruranganta mayaycurmi wañuchiyta imanuypapis ashipäcuran. ");
INSERT INTO qva_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pacha chacaruptinna Jesús discïpuluncunawan chay marcapita aywacäriran. ");
INSERT INTO qva_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Warantin tuta pasarna hïgus yürata ricapäcuran sapipita chaquisha caycagta. ");
INSERT INTO qva_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Chauraga imata ningantapis yarpärir Jesusta Pedro niran: “Maestro, ricay. Maldiciunangayqui hïgus yüra chaquisha”. ");
INSERT INTO qva_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús niran: “Tayta Diosman yäracäriy. ");
INSERT INTO qva_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Rasunpam gamcunata nï: Pipis cay jircata ‘Aywacuy y lamarman jegarpamuy’ nir lapan shongunpa chaynuy pasananpag canganta criyiptin yarpangannuymi canga. ");
INSERT INTO qva_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Chaymi noga nï: Tayta Diosta rugacurga criyinqui chrasquisha cangayquitanuyna. Chaynuy criyirga rasunpam chrasquipäcunqui rugacungayquita. ");
INSERT INTO qva_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Chaynuypis Tayta Diosta rugacuycangayqui höra piwanpis jagayächinacusha carga perdunay. Chaynuy perdunaptiquega gamcunatapis juchäcungayquipita cieluchru Taytayqui perdunäshunquim. ");
INSERT INTO qva_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Runamasiquita mana perdunaptiquega cieluchru Taytayqui gamcunatapis juchäcungayquicunapita manam perdunäshunquichu”. ");
INSERT INTO qva_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Chaypitana Jerusalenman cutipäcuran. Templuchru Jesús puriycaptin payman shapäcamuran cüracunapa mandagnincuna, Moisés escribingan leycunata yachrachegcuna y Israel mayor runacuna. ");
INSERT INTO qva_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Jesusta tapupäcuran: “Gamga ¿ima munayniquiwantag chay lapanta rurashcanqui? ¿Pitag nishushcanqui chaycunata ruranayquipag?” ");
INSERT INTO qva_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús niran: “Nogapis gamcunata tapushayqui. Tapungäta nipäcamaptiquega nogapis ima munaynïwan rurangätapis nishayquim. ");
INSERT INTO qva_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nipäcamay: ¿Pitag Juanta cachramusha bautizänanpag, Tayta Diosninchichu o runacunachu?” ");
INSERT INTO qva_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Chauraga quiquinpura caynuy parlanacäriran: “ ‘Tayta Diosninchim cachramusha’ nishaga ‘¿Imanirtag mana criyipäcurayquichu?’ nimäshun. ");
INSERT INTO qva_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Chaynuypis manam nishwanchu ‘Runacuna cachramusha’ ”. Paycuna runacunata manchacäreg. Lapan criyipäcuran Juan rasunpa Tayta Diospa willacognin cangantam. ");
INSERT INTO qva_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Chaymi nipäcuran: “Manam musyapäcüchu”. Chauraga Jesús niran: “Nogapis manam willashayquichu ima munaynïwan rurangätapis”. ");
INSERT INTO qva_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesús tincuchiypa caynuy nir willapayta galaycuran: “Juc runa juc chracra üvasta plantaran. Nircurna guenchrachiran. Vïnuta maychru rurananpäpis rurachiran. Üvasta täpananpag törrita rurachiran. Nircurna arrendacuycur juc lädupa aywacuran. ");
INSERT INTO qva_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Cosëcha galaycuptinna juc uywayninta üvas chracra arrindunpita raquipämunanpag cachraran. ");
INSERT INTO qva_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Chay uyway chrayaptin pasaypa magarcärir jinaylata garguriran. ");
INSERT INTO qva_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Chauraga juc uywaynintana cachraran. Chay uywaytapis umanta paquircärir ashlipäcuran. ");
INSERT INTO qva_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Chaypita mas juc uywayninta cachraran. Chaytaga wañuchipäcuran. Chaypitapis mas achcatarag cachraran. Paycunata waquinta magapäcuran y waquintana wañuchipäcuran. ");
INSERT INTO qva_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Juclaylana quëdaran. Chay caran cuyay wamran. Ultimuta chay cuyay wamrantana cachraran: ‘Wamrätaga respitäpäcungam’ nir. ");
INSERT INTO qva_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ichanga chracra arrendagcuna quiquinpura parlanacäriran: ‘Tagaymi cay chracrawanga quëdanga. Wañuriycachishun noganchi cay chracrawan quëdacunanchipag’. ");
INSERT INTO qva_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Chaynuy nir chariycur wañuriycärichiran. Nircur üvas chracrapita juc läduman jorgurir jitariycäriran. ");
INSERT INTO qva_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“¿Gamcuna imatatag yarpanqui üvas chracrapa dueñun chay runacunata rurananpag canganta? Aywaycur chay chracra arrendagcunata wañuchinga y juctana chay üvas chracrata arrendaycunga. ");
INSERT INTO qva_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Gamcuna Tayta Diosninchi escribichinganchru caynuy ninganta manachu liyishcanqui? ‘Wasi ruragcuna “mana ali rumim” nir jitaringan rumim wasi cimientupag alinnincag rumiman ticrasha. ");
INSERT INTO qva_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Chaynuy cananpäga Tayta Diosninchim rurasha. Chaynuy rurasha captinmi almirasha caycanchi’ ”. ");
INSERT INTO qva_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Chauraga chay mandagcunaga paycunapa contran Jesús tincuchiypa rimaycanganta tantiyar prësu charichiyta munapäcuran. Ichanga Jesuspa favurnin achcag runacuna captin manchacur aywacäriran. ");
INSERT INTO qva_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Chaypita Jesuscagman waquin fariseucunata y Herodispa favurnin cag runacunata cachraran ali shimilanpa lutanta rimachinanpag. ");
INSERT INTO qva_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Chay runacuna aywaycur nipäcuran: “Maestro, nogacuna musyapäcümi runacuna rimanganta mana cäsur rasun caglata parlangayquita. Runacuna munangalantachu manam yachrachinqui sinöga gamga yachrachinqui rasuncagtam Dios munangannuy cawanapag. ¿Alichu canman Romachru emperador Cesarpag impuestuta päganapag o mana päganapag? ¿Impuestuta pägashwanchu o manachu?” ");
INSERT INTO qva_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Alitucular parlapaycanganta tantiyarmi Jesús niran: “¿Imanirtag lutanta rimachiyta munapäcamanqui? Ricanäpag guellayta apamuy”. ");
INSERT INTO qva_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Guellayta apapaptin Jesús niran: “¿Pipa cärantag y pipa jutintag caychru caycan?” Nipäcuran: “Emperador Cesarpam”. ");
INSERT INTO qva_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Chauraga Jesús niran: “Cesarpa cagtaga Cesarta goycuy. Tayta Diospa cagtaga Tayta Diosta goycuy”. Chaynuy ninganwan almirasha quëdapäcuran. ");
INSERT INTO qva_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Chaypita saduceo runacuna Jesuscagman aywapäcuran. Chay runacuna nipäcog wañushacuna mana cawarimunanpag canganta. Chaymi Jesusta tapupäcuran: ");
INSERT INTO qva_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Maestro, noganchipag Moisés escribinganchru niycan warmiyog runa wamraynag wañuptin viudawan wauguin tiyananpag. Chaynuypam wamrancuna chay wañog cag runapa wamrannuyna canga. ");
INSERT INTO qva_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Juc cutinchru ganchris wauguicuna caran. Mayurcag majachacuran y wamraynagla wañuran. ");
INSERT INTO qva_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Chauraga shulca cagna viudanwan majachacuran. Paypis wamraynagla wañuran. Chaynuy quimsa cag wauguinwanpis pasaran. ");
INSERT INTO qva_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Chaynuyla ganchrisnin wauguicuna chay warmiwan tiyaran. Ichanga mayganpapis wamran mana caranchu. Chaypitana warmipis wañuran. ");
INSERT INTO qva_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Chauraga wañushacuna cawarimuptinga ¿mayganpa warmintag canga ganchrisnin chay warmiwan majachacusha caycarga?” ");
INSERT INTO qva_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesús niran: “Manam musyapäcunquichu Tayta Dios escribichinganta ni pay munayniyog canganta. Chaymi gamcuna lutanta yarparcanqui. ");
INSERT INTO qva_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wañunganpita cawarimurga pipis manam majachacungachu. Paycuna cieluchru caycag angilcunanuylanam canga. ");
INSERT INTO qva_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Wañushacuna cawarimunanpag canganpitaga ¿Moisés escribinganchru rupaycag shirapita niycanganta gamcuna manachu liyipäcushcanqui? Moisesta Tayta Diosninchi niran: ‘Abrahampa, Isaacpa y Jacobpa Diosninmi noga caycä’. ");
INSERT INTO qva_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Tayta Dios manam wañushacunapa Diosninchu sinöga cawaycagcunapa Diosninmi. Gamcuna lutantam yarparcanqui”. ");
INSERT INTO qva_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Moisés escribingan leycunata yachracheg runaga paycuna parlanganta mayaran. Jesús ali contestanganta mayaycurmi chay runa ashuycur tapuran: “¿Maygan mandamientutatag mas cäsucushwan?” ");
INSERT INTO qva_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús niran: “Caynuymi nin mas cäsucunapag cag mandamiento: ‘Israel runacuna mayapäcuy: Tayta Diosninchega juclaylam. ");
INSERT INTO qva_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tayta Diosniquita lapan shonguyquipa, lapan yarpayniquiwan y lapan callpayquiwan cuyay’. ");
INSERT INTO qva_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Chaynuypis juc mas caycanmi: ‘Quiquiqui cuydacungayquinuy runamasiquitapis cuyay’. Cay ishcan mandamientucuna mas cäsucunapag mandamientucuna caycan”. ");
INSERT INTO qva_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Moisés escribingan leycunata yachracheg runa niran: “Alitam nishcanqui, maestro. Rasunpa nishcanqui juclayla Tayta Dios canganta y mana mas juc Dios canganta. ");
INSERT INTO qva_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Y Tayta Diosta lapan shongunchipa, lapan yarpayninchiwan, lapan callpanchiwan cuyay y quiquinchi cuydacunganchinuy runamasinchita cuyay mas välin uywacunata pishtarcur rupachiypitaga”. ");
INSERT INTO qva_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Leycunata yachracheg chaynuy ali niptinmi Jesús niran: “Tayta Diospa munayninman chrayanayquipag cercachrünam caycanqui”. Chaypitanaga pipis manana imatapis tapupayta almitirannachu. ");
INSERT INTO qva_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús templuchru yachraycächirmi tapuran: “¿Imanirtag Moisés escribingan leycunata yachrachegcuna nipäcun rey Davidpa ayllunpita Dios cachramungan Salvador canganta? ");
INSERT INTO qva_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Santu Espíritu musyachiptin quiquin Davidpis niran: ‘Tayta Diosmi Señurnïta niran: Cay derëchacag lädüman jamacuy contran cagcunata munayniquiman chruramungäcama’. ");
INSERT INTO qva_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Chauraga Dios cachramungan Salvadurta David ‘Señor’ niycaptinga ¿imanuypatag Dios cachramungan Salvador Davidpa ayllunpita canman?” Chaychru achca caycag runacuna Jesús yachrachiptin cushisha mayapäcuran. ");
INSERT INTO qva_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús yachrachir niran: “Moisés escribingan leycunata yachrachegcunapita cuydacäriy. Paycunaga chraqui puntancama sotänasha puripäcun. Pläzacunachru pipis respëtuwan saludänanta munapäcun. ");
INSERT INTO qva_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Shuntacänan wasicunachru alinnin bancumanrag jamacuyta munapäcun. Micunanpag gayachiptinpis punta puntamanrämi jamacuyta munapäcun. ");
INSERT INTO qva_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Viudacunapa wasincunata guechrurcan. Paycuna runa ricanalanpämi Tayta Diosta may hörarag rugacurcan. Chaynuy rurapäcunganpita fiyupa castïgutam chrasquipäcunga”. ");
INSERT INTO qva_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Chaypita Jesús jamaraycaran Diospag ofrendata wiñacunan lädunchru runacuna guellayninta chayman gaycogta ricaraycar. Chaychrümi achcag rïcu runacuna achca guellayta chayman gaycuycaran. ");
INSERT INTO qva_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Chayman juc pobre viudapis chrayaran. Paypis ofrendanta ishcayla cobri guellaynilanta gaycuran. ");
INSERT INTO qva_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Chauraga discïpuluncunata Jesús gayaycur niran: “Rasunpam gamcunata nï: Cay pobre viuda lapanpitapis mas ofrendanta gaycusha. ");
INSERT INTO qva_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Lapanpis ofrendanta gaycapäcusha puchupangan guellayninta. Ichanga viuda pobre caycarpis chayla rantipacunanpag caycaptinpis lapan guellayninta gaycusha”. ");
INSERT INTO qva_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Templupita Jesús yargaramuptin jucnin discïpulun niran: “¡Maestro, ricay, cuyaylapag rumicuna y shumag jatuncaray wasicuna!” ");
INSERT INTO qva_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesús niran: “Cay lapan shumag jatun wasicuna ricaycangayqui lapan juchruchisha car manam ni juc rumilapis canan pergaraycangannuyga quëdangachu”. ");
INSERT INTO qva_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Chaypita templo chimpanchru Olivos jutiyog lömaman aywapäcuran. Chaychru Jesús jamaycuptinnam Pedro, Santiago, Juan y Andrés quiquilancuna caycarna tapupäcuran: ");
INSERT INTO qva_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Willaycärimay ¿imaytag ningayquicuna canga? Y lapan cananpäga ¿puntata imatag canga?” ");
INSERT INTO qva_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús niran: “Cuydädu pipis engañarärishunquiman. ");
INSERT INTO qva_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Achcagmi nogatucular shapäcamunga: ‘Nogaga Tayta Dios cachramungan Salvador caycä’ nir. Chaynuypa achca runacunata engañäpäcunga. ");
INSERT INTO qva_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Gamcuna mayapäcunqui guërra caycagta o ‘Guërrash caycan’ nipäcogta. Chayta mayarpis ama mancharipäcunquichu. Puntataga chaycunarämi canga. Ichanga cay pacha manarämi ushacangarächu. ");
INSERT INTO qva_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Juc naciunwan juc naciunmi y juc munayniyogwan juc munayniyogmi guërrachru canga. May chaychrüpis terremötu canga; muchruy canga. Chaynuy captinpis nacanapäna galaycunalanrämi warmi gueshyacunanpag nanaynin galaringannuy canga. ");
INSERT INTO qva_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Quiquiquicuna cuydacäriy. Israel runacunapa autoridänincunamanmi entregäpäcushunqui. Shuntacänan wasicunachrümi magapäcushunqui. Noga janan reycunaman y gobernadurcunamanmi apapäcushunqui juzgasha canayquipag. Chaynuypa nogapita paycunata willacärinqui. ");
INSERT INTO qva_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Cay pacha manaräpis ushacaptin may chay naciunchrüpis ali willacuynin willacusham canga. ");
INSERT INTO qva_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Autoridäcunaman entregäpäcushuptiqui imata nipäcunayquipag cagtapis ama yarpachracäriychu. Chay höra nipäcuy Tayta Dios musyachipäcushungayquita. Manam gamcunachu nipäcunqui sinöga Santu Espiritum ninga. ");
INSERT INTO qva_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Wauguinmi jucag wauguinta wañuchinanpag entreganga. Taytannam wamranta entreganga. Wamrancunam taytanpa mamanpa contran sharcur entreganga wañuchisha cananpag. ");
INSERT INTO qva_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Noga janan lapan runacunam gamcunata chriquipäcushunqui. Ichanga nacarpis wañungancama mana yamacaypa yäracamagcagmi salvacunga. ");
INSERT INTO qva_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Diospag pasaypa millanaypag mana cananpag cagchru caycagta ricar Judea provinciachru cagcuna jircacunapa gueshpicärichun. (Cay escribingäta liyegcäga shumag tantiyacuchun.) ");
INSERT INTO qva_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Wasin jananchru cagcunapis imanta jorgunalanpäpis ama yarpamuchunchu ni wasinman ama yaycuchunchu. ");
INSERT INTO qva_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Chracrachru caycagcunapis janancag röpanta jorgunalanpäpis ama cutimuchunchu. ");
INSERT INTO qva_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Chay junagcuna cuyapaypämi capäcunga chrichru warmicuna y chuchuycag wawayog warmicuna. ");
INSERT INTO qva_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Tayta Diosta rugacäriy tamya quillacuna chaycuna mana cananpag. ");
INSERT INTO qva_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","“Chay junagcuna fiyupa nacaymi canga. Tayta Dios camanganpita pacha manam imaypis chay nacaynuyga canrächu. Chaynuyga imaypis mananam canganachu. ");
INSERT INTO qva_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tayta Diosninchi chay junagcunata rätu mana pasachiptinga pipis manam cawanmannachu. Acrashacuna Tayta Diosman yäracuycagcuna raycu ichanga rätu pasachisha. ");
INSERT INTO qva_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Pipis gamcunata ‘Ricay, caychru caycan Tayta Dios cachramungan Salvador’ o ‘Ricay, wacchru caycan Dios cachramungan Salvador’ nipäcushuptiqui ama criyipäcunquichu. ");
INSERT INTO qva_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tayta Dios cachramungan Salvadurtucular y Tayta Diospa willacognintucular runacunam aywamunga. Chay runacunapis milagrucunata ruranga. Chaynuypa acrashacuna Tayta Diosman yäracuycagcunatapis engañayta munapäcunga. ");
INSERT INTO qva_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Cuydacärinqui. Manarag pasaptinmi gamcunataga lapanta willapashcä. ");
INSERT INTO qva_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Chay fiyupa nacay junagcuna pasaruptinna intipis chacacäcunga y quillapis mana achicyanganachu. ");
INSERT INTO qva_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Estrëllacunapis cielupita shicwamunga y cieluchru munayniyogcunapis sicsicyanga. ");
INSERT INTO qva_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Noga Diospita shamusha Runapis pucutay jananchru chipipaycar pasaypa munaynïwan aywaycämogta ricapäcamanga. ");
INSERT INTO qva_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nogam angilcunata cachrashag acrangäcunata may chaypitapis shuntamunanpag. ");
INSERT INTO qva_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Hïgus yürata imanuypis canganta ricar tantiyacärinqui: Rämancuna verdiyayta y öjancuna chinliyta galaycuptin tamya quilla galaycunanpäna canganta musyapäcunqui. ");
INSERT INTO qva_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Chaynuylam chay ningäcuna pasaptin musyapäcunqui noga Diospita shamusha Runa cutimunäpäna caycangäta. ");
INSERT INTO qva_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Rasunpam gamcunata nï: Cay lapan chaynuy canga manaräpis canan wichan runacuna wañuptinmi. ");
INSERT INTO qva_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Cielupis y cay pachapis ushacangam. Noga ningäcunam ichanga mana ushacangachu. ");
INSERT INTO qva_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Pipis manam musyanchu imay junag ima höra chaycuna pasananpag canganta ni cieluchru caycag angilcunapis ni noga Diospa Wamranpis. Chaytaga Tayta Dioslam musyan. ");
INSERT INTO qva_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ichanga mayag mayagla y ricag ricagla carcay. Manam musyapäcunquichu imay cananpag cangantapis. ");
INSERT INTO qva_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Chay caycan juc wasiyog juc lädupa aywacur wasinta ricananpag uywaynincunata jaguipangannuy y imata rurapäcunanpäpis tantiyachingannuy, puerta quichrapagnintapis tantiyachingannuy mayag mayagla caycänanpag. ");
INSERT INTO qva_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mayag mayagla carcay. Gamcuna manam musyapäcunquichu wasiyog ima höra chrayamunantapis: chacaypachush, pulan pagaschush, wallpa wagaychush o waraycaptinchush. ");
INSERT INTO qva_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Cuydädu mayänipita aywamur puñuycagta tarirushunquiman. ");
INSERT INTO qva_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Gamcunata niycangäta lapan runacunatam niycä: Mayag mayagla carcay”. ");
INSERT INTO qva_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pascua fiestapag y chaychru levadüraynag tantata micunanpag ishcay junaglana pishiycaran. Cüracunapa mandagnincuna y Moisés escribingan leycunata yachrachegcuna parlanacäriran ima engäñulawanpis Jesusta prësu charircachir wañuchipäcunanpag. ");
INSERT INTO qva_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ichanga nipäcuran: “Ama charishunchu fiestachrüga. Chaychru charishaga runacuna rabyar contranchi sharcurunmanmi”. ");
INSERT INTO qva_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús caycaran Betania marcachru “gueri gueshyag” nipäcungan Simonpa wasinchru. Pay mësachru jamaraycaptinmi juc warmi alabastrupita rurasha botëllawan perfümin aptasha chrayaran. Nircurmi botëllapa shiminta paquirir Jesuspa umanman gaycaparan. Chay perfümi nardupita püru carmi fiyupa cuestag. ");
INSERT INTO qva_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Chaychru waquincuna rabyacäriran y quiquinpura ninacäriran: “¿Imapätag pampata rurar jichran chay perfümita? ");
INSERT INTO qva_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Chayta ranticushwan caran quimsa pachrac (300) junag runa gänanganpita maslachrümi. Nircur chayta pobricunata aypushwan caran”. Chaynuy nirmi chay warmita jamurpäpäcuran. ");
INSERT INTO qva_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesús niran: “Jina rurachun. ¿Imanirtag rabyarcächinqui? Nogapag alitam rurasha. ");
INSERT INTO qva_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Pobricuna gamcunawan imaypis caycangam. Yanapayta munarga imaypis yanapäpäcunquipämi. Nogam ichanga gamcunawan manana cashäpänachu. ");
INSERT INTO qva_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Cay warmega puedingantam rurasha. Payga cawaycaptilä gaycapämar camarisha wañuptï pampapäcamänanpämi. ");
INSERT INTO qva_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Rasunpam gamcunata nï: May chaychrüpis ali willacuyta willacunganchru cay warmi chaynuy ruranganpita parlapäcungam. Chaynuypam chay warmipita mana gongapäcungachu”. ");
INSERT INTO qva_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariote Jesuspa chrunca ishcay (12) discïpulunpita jucnincagmi cüracunapa mandagnincunaman aywaycur Jesusta entregänanpag parlaran. ");
INSERT INTO qva_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Chay ninganta mayaycärir paycuna cushicäriran y pägananpag nipäcuran. Chaypitana Judas yarpachracuran ima höra Jesusta entregänanpag cangantapis. ");
INSERT INTO qva_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Levadüraynag tantata micunan fiesta galaycunan junag y Pascua fiestapag carnita pishtanan junag discïpuluncuna Jesusta tapuran: “¿Maychrütag gampag camaripäcamushag Pascua cënata micunayquipag?” ");
INSERT INTO qva_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Chauraga ishcay discïpuluncunata caynuy nir cachraran: “Jerusalenman aywapäcuy. Chaychrünam tincupäcunqui juc runa wacuywan yacuta apaycagta. Paypa guepalanta aywapäcunqui. ");
INSERT INTO qva_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Wasinman yaycuptin wasiyogta nipäcunqui: ‘Maestrum nin: ¿Maychrütag caycan cuarto discïpulücunawan Pascua cënata micupäcunäpag?’ ");
INSERT INTO qva_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Chauraga pay ricachishunqui wasipa altucag pïsunchru jatun cuartuta chaychru cënanapag chrurapacushalatana. Chaychru cënata camaricärinqui micunanchipag”. ");
INSERT INTO qva_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Discïpuluncuna Jerusalenman aywar Jesús ningantanuyla lapantapis tariran. Chay wasichrünam Pascua cënata camaricäriran. ");
INSERT INTO qva_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pacha chacaycaptinnam chrunca ishcay (12) discïpuluncunawan chayman Jesús chrayaran. ");
INSERT INTO qva_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mësachru micuycarnam Jesús niran: “Rasunpam gamcunata nï: Gamcunapita jucniquim nogawan micuycagpita chriquimagnïcunaman entregämanga”. ");
INSERT INTO qva_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Chauraga lapan laquicuyta galaycäriran y jucnin jucninpis Jesusta tapupäcuran: “¿Nogachurag caycä?” nir. ");
INSERT INTO qva_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesús niran: “Gamcunapita jucniqui nogawan chay plätulapita tantata ushmaycächegmi. ");
INSERT INTO qva_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tayta Dios escribichinganchru ningannuylam noga Diospita shamusha Runa wañushag. ¡Entregämag runa ichanga cuyapaypämi canga! Chay runapag mas ali canman caran mana yurinanpag”. ");
INSERT INTO qva_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Chaypita paycuna micurcanganchru tantata aptarcur Tayta Diosta Jesús agradecicuran. Agradecicurirna tantata partirir paycunata caynuy nir aypuran: “Cä. Cayga cuerpümi”. ");
INSERT INTO qva_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nircur vïnuyog cöpata aptarcur Tayta Diosta agradecicuran. Agradecicurirna paycunata goran. Y lapan upupäcuran. ");
INSERT INTO qva_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesús niran: “Cay vïnoga yawarnïmi. Caywanmi runawan Tayta Dios conträtuta ruranga. Achcag raycu yawarnïmi jichrasha canga. ");
INSERT INTO qva_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Rasunpam gamcunata nï: Yapayga manam vïnuta upushänachu Tayta Diospa munayninchru mushog vïnuta upungäcama”. ");
INSERT INTO qva_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Chaypita salmucunata cantarcur Olivos lömaman aywacäriran. ");
INSERT INTO qva_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesús niran: “Gamcuna lapayquim jaguiriycärimanqui. Tayta Diosninchi escribichinganchru niycan: ‘Üsha michegta wañuycachiptï üshancuna mashtacäcungam’. ");
INSERT INTO qva_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ichanga cawarircamur gamcunapita mas puntatam Galileaman aywashag”. ");
INSERT INTO qva_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedro payta niran: “Waquin cag jaguirishuptiquipis nogaga manam jaguirishayquichu”. ");
INSERT INTO qva_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesús niran: “Rasunpam gamta nï: Canan chacay manarag ishcay cuti gällu cantaptinmi quimsa cutina reguimangayquita niegamanqui”. ");
INSERT INTO qva_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Niptinpis Pedro fiyupa niran: “¡Ishcanchita wañuchimänanchi captinpis manam niegashayquichu!” Lapan waquincag discïpuluncunapis chaynuylam nipäcuran. ");
INSERT INTO qva_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jesús discïpuluncunawan Getsemaní jutiyog chracraman aywapäcuran. Chrayaycur Jesús discïpuluncunata niran: “Caychru jamararcay Tayta Diosta rugacamungäcama”. ");
INSERT INTO qva_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nircur Pedruta, Santiaguta y Juanta pushacurcur aywaran. Chaychrümi fiyupa laquicuyta galaycuran. ");
INSERT INTO qva_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Niran: “Wañupacusha nirag shongüman pasaypa laquicuy chrayaramun. Caylachru ricchaycar shuwararcämay”. ");
INSERT INTO qva_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nircur mas wac läduman aywaran. Chaychrüna urcunpis pampaman tüpangancama gongurpacuycur Tayta Diosta rugacuran chay nacananpag cag höraman camacaptinga mana chrayananpag. ");
INSERT INTO qva_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tayta Diosta rugacur caynuy niran: “Papä, gampäga imapis manam sasachu. Nacanäpag caycagpita jorgaycalämay. Ichanga noga munangänuyga ama cachunchu, sinöga gam munangayquinuy cayculächun”. ");
INSERT INTO qva_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Chaypita quimsan discïpuluncuna caycangancagman cutiran. Paycunata puñucasha carcagta tariran. Pedruta niran: “Simón, ¿puñuycanquichu? ¿Manachu juc höralapis ricchayta puedishcanqui? ");
INSERT INTO qva_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ricchapäcuy y Tayta Diosta rugacäriy juchäcuyman mana chrayapäcunayquipag. Ali rurayta munarpis quiquiquicunalaga manam camäpacunquichu”. ");
INSERT INTO qva_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yapay cutiran. Chaychrüpis chay rugacungannuyla rugacuran. ");
INSERT INTO qva_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tayta Diosta rugacunganpita cutir discïpuluncunata yapay puñucasha caycagta tariran. Puñucäpäcuran ñawincuna manana ricchayta awantaptin. Paycuna imaniytapis mana camäpacäriranchu. ");
INSERT INTO qva_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Quimsacag cutichru cutimurna niran: “¿Gamcuna cananpis puñuycanquirächu y jamaycanquirächu? ¡Ricchapäcuyna! Höra chrayamushana noga Diospita shamusha Runa juchäcog runacunapa maquinman entregasha canäpag ");
INSERT INTO qva_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Sharcapäcuy; aywacushunna! Aywaycämunna entregämänanpag cag runa”. ");
INSERT INTO qva_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Chay höra discïpuluncunawan Jesús parlaycaptinrämi Judas achca runacuna pushasha chrayaran. Judas caran chrunca ishcay (12) discïpuluncunapita jucnincag. Chay runacuna espädanwan y garrutincunawan chrayaran. Chay runacuna cachrasha caran cüracunapa mandagnincuna, Moisés escribingan leycunata yachrachegcuna y Israel mayor runacuna. ");
INSERT INTO qva_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Chayman manarag chrayarmi entregänanpag cag Judas chay runacunata caynuy niran: “Maygantapis muchaycungäcagmi canga. Paytam charipäcunqui. Nircur mana cachrarilar prësu apapäcunqui”. ");
INSERT INTO qva_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Chaymi chrayamur Jesús cagman Judas jucla ashuycur “Maestro” nir muchaycuran. ");
INSERT INTO qva_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Chauraga Jesusta jucla prësu chariran. ");
INSERT INTO qva_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ichanga chaychru caycag jucnincag discïpulun espädanta jorgurir cüracunapa mas mandagninpa uywayninpa rinrinta roguriycuran. ");
INSERT INTO qva_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesús chay runacunata tapuran: “¿Imanirtag gamcuna saltiador captïnuypis espädayquiwan y garrutiquiwan prësu charipäcamänayquipag shapäcamushcanqui? ");
INSERT INTO qva_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Waran warantag gamcunawan templuchru yachrachirä. Imaypis mana charipäcamarayquichu. Ichanga chaynuy cachun Tayta Diosninchi escribichinganchru ningancuna cumplinanpämi”. ");
INSERT INTO qva_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Lapan discïpuluncuna Jesusta jaguiriycur gueshpir aywacäriran. ");
INSERT INTO qva_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Juc mösula säbanaswan wancusha guepanta gatiraran. Chayta charipäcuran. ");
INSERT INTO qva_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ichanga säbanasta jitariycur chay mösu garapachrala gueshpir aywacuran. ");
INSERT INTO qva_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Chaypita Jesusta apapäcuran cüracunapa mas mandagninman. Chaymanmi lapan cüracunapa mandagnincuna, Israel mayor runacuna y Moisés escribingan leycunata yachrachegcuna shuntacasha caycaran. ");
INSERT INTO qva_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro caru guepalanta Jesusta gatiraran cüracunapa mas mandagninpa wasinpa sawan ruricama. Chaychrüna templo cuydag wardiacunawan ninachru mashacuycar jamasha quëdacuran. ");
INSERT INTO qva_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Cüracunapa mandagnincuna y Israel mayor autoridäcuna pilapis Jesuspa contran rimananpag ashircaran “Wañuchisha cachun” nipäcunanpag. Ichanga pitapis mana taripäcuranchu. ");
INSERT INTO qva_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Jesuspa contran achcag runacuna casquicur rimaptinpis manam mayganpis juc yarpaylaga nipäcuranchu. ");
INSERT INTO qva_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Waquincuna ichrircur Jesuspa contran casquicuypa nipäcuran: ");
INSERT INTO qva_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nogacuna caynuy negta mayapäcushcä: ‘Runacuna cay templo ruranganta juchrurcachir quimsa junagtaga juctana sharcarachishag runacunawan mana rurachiypa’ ninganta”. ");
INSERT INTO qva_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Chaynuy nipäcuptinpis manam waquin ningancunaman tincuranchu. ");
INSERT INTO qva_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Chauraga cüracunapa mas mandagnin chraupichru jamaraycanganpita ichrircur Jesusta tapuran: “¿Imatapis manachu ninqui? ¿Imanirtag gampa contrayqui chaynuy nircäshunqui?” ");
INSERT INTO qva_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ichanga Jesús upälala cacuran. Chaymi cüracunapa mas mandagnin yapay tapuran: “¿Gamchu Tayta Dios cachramungan Salvador caycanqui? ¿Alabasha caycag Tayta Diospa Wamranchu caycanqui?” ");
INSERT INTO qva_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús niran: “Au, nogam caycä. Gamcuna noga Diospita shamusha Runata ricapäcamanquipag imaycapäpis munayniyog Tayta Diospa derëchacag lädunchru mandanäpag jamaraycagta y pucutay jananchru aywaycämogtam”. ");
INSERT INTO qva_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Chauraga cüracunapa mas mandagnin pasaypa rabyangan musyacänanpag röpantapis rachririran. Nircur niran: “¿Imapänatag mas testïgutapis ashishun? ");
INSERT INTO qva_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Gamcuna mayapäcushcanquina Diospa contran lutanta rimanganta. Cananga ¿imanipäcunquitag?” Chauraga lapan chaychru shuntaraycag autoridäcuna juc yarpayla nipäcuran wañuchisha cananpag. ");
INSERT INTO qva_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Chaychru waquincuna Jesusta togapayta galaycapäcuran y ñawinta bendaycur caynuy nir magapäcuran: “Willacog car nimay: ¿Pitag magashushcanqui?” Templo cuydag wardiacunapis payta lagyapäcuran. ");
INSERT INTO qva_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro sawanchru caycaran. Chayman cüracunapa mas mandagninpa uywaynin jipashcunapita jucnincag chrayaran. ");
INSERT INTO qva_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pedro ninachru mashacuycagta ricapärirmi chay jipash niran: “Gampis puriycashcanqui Nazaretpita Jesuswan”. ");
INSERT INTO qva_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Niptin Pedro niegaran: “Imapita niycämangayquitapis noga manam musyächu ni manam tantiyächu”. Nircur yaycuna puertaman yargamuran y gällu cantaran. ");
INSERT INTO qva_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Pedruta chay uyway jipash ricar chaychru caycag runacunata yapay niran: “¡Cay runapis paycunawan puregmi!” ");
INSERT INTO qva_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Chauraga Pedro yapay niegaran. Mas rätunta chaychru caycag runacuna Pedruta yapay niran: “Galileapitam canquipis. Rasunpam gamga paycunawan pureg canqui”. ");
INSERT INTO qva_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Chaynuy niptinmi Pedro juraran: “¡Noga manam reguïchu chay niycämangayqui runata! Casquicuptïga quiquï castigasha cashag”. ");
INSERT INTO qva_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Chay höra gällu yapay cantariycuran. Chauraga Pedro yarparan Jesús caynuy ninganta: “Manaräpis ishcay cuti gällu cantaptinmi quimsa cutina reguimangayquita niegamanqui”. Chay ninganta yarparcurmi Pedro wagaran. ");
INSERT INTO qva_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pacha waraycaptinna cüracunapa mandagnincuna, Israel mayor runacuna, Moisés escribingan leycunata yachrachegcuna y Israel mayor autoridäcuna lapan shuntacaran parlanacärinanpag. Chaypitana watarcur Jesusta apachipäcuran Pilätuman entregänanpag. ");
INSERT INTO qva_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Chaychrüna Piläto tapuran: “¿Gamchu Israel runacunapa Reynin canqui?” Jesús niran: “Gam nishcanqui”. ");
INSERT INTO qva_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Chaychrümi cüracunapa mandagnincuna Jesuspa contran imaycatapis nipäcuran. ");
INSERT INTO qva_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Piläto yapay Jesusta tapuran: “¿Manachu imatapis ninqui? Ricay, imaycatash contrayquita nircäshunqui”. ");
INSERT INTO qva_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ichanga Jesús masta mana rimacuranchu. Chauraga Piläto imaniytapis mana camäpacuranchu. ");
INSERT INTO qva_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pascua fiestachru cada wata Piläto cachrareg juc prësuta maygantapis cachrarinanpag runacuna ninganta. ");
INSERT INTO qva_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Chay wichan Barrabás jutiyog runa wañucheg masincunawan Romapa autoridänincunapa contran sharcunganpita prësu wichrgaraycaran. ");
INSERT INTO qva_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Runacuna chrayaycur Pilätuta nipäcuran imaypis costumbrin cangannuy rurananpag. ");
INSERT INTO qva_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Piläto niran: “¿Gamcuna munapäcunqui Israel runacunapa Reyninta cachrarinätachu?” ");
INSERT INTO qva_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Piläto tantiyaran cüracunapa mandagnincuna envidiapita Jesusta payman apapäcunganta. ");
INSERT INTO qva_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ichanga cüracunapa mandagnincuna runacunata yachrachiran: “Barrabasta cachrariy” nipäcunanpag. ");
INSERT INTO qva_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Piläto tapuran: “¿Imatatag rurashag ‘Israel runacunapa Reynin’ nipäcungayquitaga?” ");
INSERT INTO qva_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Chay runacuna gaparir nipäcuran: “¡Crucificächiy!” ");
INSERT INTO qva_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Piläto niran: “¿Imatatag mana alita rurasha?” Chauraga chay runacuna masrag gaparir nipäcuran: “¡Crucificächiy!” ");
INSERT INTO qva_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Chauraga runacunawan ali quëdayta munar Barrabasta Piläto cachrariran. Nircurna Jesusta astircachir crucificasha cananpag entregaycuran. ");
INSERT INTO qva_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Chaypita soldäducuna “pretorio” jutiyog palaciuman Jesusta aparan. Chaymanna lapan soldäducuna shuntacäpäcuran. ");
INSERT INTO qva_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Nircur yanataycag azul cäpata jatipäpäcuran. Cashapita awasha corönata jatipäpäcuran. ");
INSERT INTO qva_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Jatiparcärir gaparir nipäcuran: “¡Vïva Israel runacunapa Reynin!” ");
INSERT INTO qva_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Chaypita soldäducuna Jesusta umachru bärawan wirupäcuran y togapapäcuran. Respitagtucur ñaupagninman gongurpacäriran. ");
INSERT INTO qva_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Chaynuy asiparcärirmi jatipangan yanataycag azul cäpata jorgaparcur quiquinpa röpantana Jesusta jatipäpäcuran y crucificänanpag apacäriran. ");
INSERT INTO qva_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Cirene marcapita Simón jutiyog runa Alejandrupa y Rufupa papänin chracrapita chrayaycämuran. Chaypita paytana cruzta apachipäcuran. ");
INSERT INTO qva_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jesusta apapäcuran Gólgota ninganman. Gólgota ninanga “Calavëra cacunan” ninanmi. ");
INSERT INTO qva_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Chaychrüna mïrra jutiyog perfümiwan vïnuta talurcachir Jesusta upunanpag gopäcuran. Ichanga Jesús upuyta manam munaranchu. ");
INSERT INTO qva_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nircurna Jesusta crucificäpäcuran. Crucificarcurna soldäducuna Jesuspa röpanta mayganpis gänag cag apacunanpag surtiyapäcuran. ");
INSERT INTO qva_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Crucificangan höra caran tutapa las nuevinuy. ");
INSERT INTO qva_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Chaypitana imapita wañuchisha cangantapis letrëruta chrurapäpäcuran. Chay letrëruchru escribiraran: “Israel runacunapa Reynin” nir. ");
INSERT INTO qva_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jesuspa läduncunaman crucificaran ishcay saltiadurcunatapis. Jucnin cagta derëcha cag lädunman y jucagtana ichog cag lädunman. ");
INSERT INTO qva_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Chay cumpliran Tayta Dios escribichinganchru ningannuylam: “Paytapis fiyu runatanuymi runacuna ricapäcunga” ningan. ");
INSERT INTO qva_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Jesús crucificaraycangan cagpa runacuna pasag ashlir y umanta awir y nipäcog: “¡Templuta juchrurcachir quimsa junaglachru sharcacheg, ");
INSERT INTO qva_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","quiquiqui salvacuy y cruzpita yarpamuy!” ");
INSERT INTO qva_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Chaynuyla cüracunapa mandagnincunapis y Moisés escribingan leycunata yachrachegcunapis asipar quiquinpura ninacuran: “Juctaga salvaran; quiquin ichanga salvacuyta mana puedinchu. ");
INSERT INTO qva_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","¡Tayta Dios cachramungan Salvador, Israel runacunapa Reynin cruzpita bäjamuchun ricananchipag y criyinanchipag!” Lädunchru crucificaraycag runacunapis ashlipäcuran. ");
INSERT INTO qva_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Pulan junagpita mallway inticama intëru pacha chacacäcuran. ");
INSERT INTO qva_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Chay höram Jesús fiyupa gaparir niran: “Eloi, Eloi, ¿lama sabactani?” Chay ninanga “Diosnï, Diosnï ¿imanirtag jaguiriycamashcanqui?” ninanmi. ");
INSERT INTO qva_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Chaychru cag waquin runacuna ninganta mayaycur nipäcuran: “Tayta Diospa willacognin Eliasta gayacuycan”. ");
INSERT INTO qva_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Chauraga jucnin runa esponjata puchgog vïnuman ushmarcachir gueruman chrurarcur Jesuspa shiminman shogunanpag caynuy nir ashuycachiran: “Mä, ricashun Eliasta cruzpita bäjachimunanpag shamogta”. ");
INSERT INTO qva_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ichanga Jesús fiyupa gapararir wañuriycuran. ");
INSERT INTO qva_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Y Templuchru cortïnapis janapita uraman rachricäcuran. ");
INSERT INTO qva_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Soldäducunapa capitannin Jesuspa ñaupagninchru caycaran. Jesús imanuy wañungantapis ricar niran: “¡Rasunpam cay runaga Diospa Wamran casha!” ");
INSERT INTO qva_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Chaynuypis chaychru waquin warmicuna carulapita ricararcaran. Paycunawanmi caycaran María Magdalena, shulca cag nipäcungan Santiagupa y Josëpa maman María y Salomëpis. ");
INSERT INTO qva_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Galileachru Jesús caycaptin chay warmicunam payta gatiräpäcuran y yanapäpäcuran. Chaynuypis chaychru caycaran Jesuswan iwal Jerusalenman aywag mas achcag warmicunapis. ");
INSERT INTO qva_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Chay junag caran sábado jamay junagpag camaricuna tardi. Chaymi tardina captin ");
INSERT INTO qva_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Arimatea marcapita José Pilätucagman mana manchacuypa aywaran Jesuspa cuerpunta pampananpag cachrapänanpag rugacog. José caran respitasha Israel mayor autoridämi. Paypis shuwaraycaran Tayta Diospa munaynin chrayamunanpag cangantam. ");
INSERT INTO qva_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Piläto almirasha quëdaran Jesús wañushana canganta mayar. Chaypitana wañushana o manarag wañunganta tapunanpag capitanta gayachiran. ");
INSERT INTO qva_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Jesús wañushana caycanganta capitan willaycuptinna Piläto mandaran Jesuspa cuerpunta Josëta entregänanpag. ");
INSERT INTO qva_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Chauraga lïnupita säbanasta rantircamur Jesuspa cuerpunta bäjarcachimur chay tëlawan José wancuran. Chaypitana chagachru uchrcusha sepultüraman chruraran. Nircur sepultürata jatun rumiwan chapaycuran. ");
INSERT INTO qva_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena y Josëpa maman María mayman chrurangantapis ricararan. ");
INSERT INTO qva_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sábado jamay junag pasariptin María Magdalena, Santiagupa maman María y Salomëpis shumag perfümita Jesuspa cuerpunman gaycapänanpag rantimuran. ");
INSERT INTO qva_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Semäna galarinan junag tuta inti chayrag yargaycämuptin Jesús chrurarangan sepultüraman aywapäcuran. ");
INSERT INTO qva_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Aywar quiquinpura caynuy ninacäriran: “¿Pirag sepultüra chaparag rumita ashuchipämäshun?” ");
INSERT INTO qva_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ichanga ricärinanpäga chaparag jatuncaray rumi ashuchishana caycänag. ");
INSERT INTO qva_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Sepultüra rurinman yaycur derëcha cag läduchru juc mösu yurag largu röpasha jamaraycagta ricapäcuran. Chayta ricar warmicuna manchacäpäcuran. ");
INSERT INTO qva_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Chay mösu niran: “Ama mancharipäcuychu. Gamcuna ashircanqui crucificaypa wañusha Nazaretpita Jesusta. Pay cawarishanam. Mananam caychru cannachu. Ricapäcuy mayman chrurapäcungantapis. ");
INSERT INTO qva_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Aywapäcuy y willapäcuy discïpuluncunata y Pedruta: ‘Pay gamcunapita mas puntatam Galileaman aywaycan. Chaychrümi nipäcushungayquinuyla ricapäcunqui’ ”. ");
INSERT INTO qva_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Chauraga warmicuna jucla cörriypa sepultürapita manchacasha sicsicyaycar aywacäriran. Manchariylawan imatapis pitapis mana willapäcuranchu. ");
INSERT INTO qva_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Semäna galarinan junag tuta Jesús cawarircamur puntata María Magdalenata ricariparan. Paypitam Jesús ganchris diablucunata garguran. ");
INSERT INTO qva_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Paymi willag aywaran Jesuswan pureg laquisha y wagaycar carcag discïpuluncunata. ");
INSERT INTO qva_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","María willaptin Jesús cawanganta mayar y pay ricanganta niptin mana criyipäcuranchu. ");
INSERT INTO qva_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Chaypitanam Jesús jucnuyna ishcay discïpuluncuna aywaycagta camiñuchru ricariparan. ");
INSERT INTO qva_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Paycuna aywaycur waquincunata willaran. Ichanga paycunatapis manam criyipäcuranchu. ");
INSERT INTO qva_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Chaypitana mësachru jamararcaptin Jesús chrunca juc (11) discïpuluncunata ricariparan. Chaychrüna cawarimushata payta ricapäcunganta willaptin mana criyipäcunganpita y mana chrasquicäringanpita piñaparan. ");
INSERT INTO qva_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jesús niran: “Intëru mundupa aywapäcuy lapan runacunata ali willacuynïta willapäcunayquipag. ");
INSERT INTO qva_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Pipis criyimagcäga y bautizacogcäga salvasham canga. Mana criyimagcagmi ichanga castigasha canga. ");
INSERT INTO qva_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nogaman criyimagcunaga milagrucunata rurangam paycunata Dios rasunpa cachramunganta musyacänanpag. Jutïchru diablucunata gargunga y juc idiomacunatapis rimanga. ");
INSERT INTO qva_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Culebrata aptaptinpis, venënuta upuptinpis manam imanangapischu. Gueshyagcunapa jananman maquinta chrurarpis cuticächingam”. ");
INSERT INTO qva_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Discïpuluncunawan parlayta usharcuptinmi Señor Jesús cieluman apasha caran y Tayta Diospa derëchacag lädunman jamacuran mandananpag. ");
INSERT INTO qva_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Discïpuluncuna may chaypapis Jesuspa willacuyninta willacog yargapäcuran. Willacäriptin Señor Jesús yanaparan y rasunpa canganta musyapäcunanpag milagrucunata rurachiran. Amén.");
INSERT INTO qva_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Noga Lucas cay libruta Jesuspitam escribï. Jesús willacuyta galaycunganpita pacham lapan rurangancunata apostulnincuna ricaran. Ricangancunata willacärinanpämi apostulnincunata Jesús niran. Paycuna willacäriptinmi mayagcuna Jesuspita achcag escribipäcusha. Chaymi nogapis, shumag yarpachracurir, cay libruta escribï, galaycunganpita pacha imanuy cangantapis shumag tapucurir. Chaynuypam gam, Teófilo, musyanqui yachrachishungayquicuna rasuncag canganta. ");
INSERT INTO qva_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Israel naciunchru Herodes mandanan wichanmi juc cüra Zacarías jutiyog caycaran. Paymi caran Abías jutiyog cürapa ayllun. Zacariaspa warminmi caran Elisabet. Paypa taytanpis cüram caran. ");
INSERT INTO qva_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Paycunaga Tayta Dios mandangancunata rurarmi imaypis alilata rurapäcog. Chaymi paycunapäga mana ali runa canganta pipis mana nipäcogchu. ");
INSERT INTO qva_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ishcanpis chachanam capäcuran. Chachayaynincama Elisabetpa wawan manam caranchu. ");
INSERT INTO qva_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Chaypitam Zacariaspa y paynuy cüracagcunapapis turnun chrayamuptinna templuchru Tayta Dios mandanganta rurapäcunanpag Jerusalenman aywapäcuran. ");
INSERT INTO qva_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Chaychrümi imaypis rurangannuy surtiyapäcuran maygan cürapis templuman incienso rupacheg yaycunanpag. Chaymi Zacariaspag suerti yargamuran. ");
INSERT INTO qva_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Chauraga Zacarías templo ruriman yaycuycur inciensuta rupachingancama lapan runacuna templo puncuchru Diosta rugacurcaran. ");
INSERT INTO qva_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Templuchru inciensuta rupaycächiptinmi altarpa derëchacag lädunchru Tayta Diospa angilnin Zacariasta ricariparan. ");
INSERT INTO qva_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Chaymi chay angilta ricaycur Zacarías fiyupa manchacaran. ");
INSERT INTO qva_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Chauraga angel niran: “Zacarías, ama manchariychu. Rugacungayquitam Tayta Dios mayashushcanqui. Chaymi warmiqui Elisabetpa olgu wamran canga. Paypa jutinmi Juan canga. ");
INSERT INTO qva_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Wamrayqui yuriptinmi pasaypa cushicunqui. Chaynuypis lapan runacunam cushicunga. ");
INSERT INTO qva_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Tayta Diospag wamrayqui alita ruragmi canga. Chaymi payta alipag ricanga. Pay manam vïnuta ni ima shincachicogtapis upungachu. Manaräpis yurirmi Santu Espiritupa munayninchrüna canga. ");
INSERT INTO qva_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","17","“Chaynuy captinmi achcag Israel runacuna juchancunapita wanacur Tayta Dios munangannuy cawapäcunga. Chaynuypis runacunata yächinga wasinchrüpis cuyanacur cawananpag. Mana cäsucogcunata yächinga Tayta Dios munangannuyna cawapäcunanpag. Chaynuypam runacunata camaricachinga Dios cachramungan Salvador shamuptin shumag chrasquicärinanpag”. ");
INSERT INTO qva_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Angel chaynuy niptinmi Zacarías tapuran: “¿Imanuypatag musyäman nimangayquicuna rasunpa cananpag canganta? Nogacunaga chachanam capäcü. Chaynuy carcaptïga ¿imanuypatag wamrä canman?” ");
INSERT INTO qva_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Chaymi angel niran: “Tayta Diospa willacognin Gabrielmi cä. Paymi cachramasha cay ali willacuyta gamta willanäpag. ");
INSERT INTO qva_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Tiempun chrayamuptin cay willangäcunaga lapanpis cumplingam. Ningäcunata mana chrasquimangayquipitam cananga manana rimanquinachu warmiqui gueshyacungancama”. ");
INSERT INTO qva_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Chaycamam templo puncuchru runacuna shuwararcaran: “¿Imanirtag cay höracama Zacarías mana yargamunchu?” ninacur. ");
INSERT INTO qva_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Chaymi templupita yargamur rimayta mana puedir shuwararcagcunata sëñasyaylapana parlaparan. Chauraga shuwararcagcuna yarpäpäcuran templo rurichru imapis ricaripanganta. ");
INSERT INTO qva_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Chauraga templuchru rurananpag cagcunata usharcurnam wasinpana Zacarías cuticuran. ");
INSERT INTO qva_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Chaypitanam warmin Elisabet gueshyag ricacur pichga quillantin wasilanchru cacuran. ");
INSERT INTO qva_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Cushicurmi niran: “Tayta Diosmi nogata cuyapämasha. Cananpitaga wawaynag cangäpita runacuna mananam jamurpämanganachu”. ");
INSERT INTO qva_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Elisabet gueshyag ricacunganpita sogta quillatanam angel Gabrielta Galilea provinciachru Nazaret marcaman doncëlla Mariata watucunanpag Tayta Dios cachraran. Mariam parlashana caycaran Davidpa ayllun Josëwan majachacunanpag. ");
INSERT INTO qva_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Chrayaycurmi angel niran: “¡María! ¡Tayta Diospa cuyayninmi caycanqui! Gamwanmi imaypis canga”. ");
INSERT INTO qva_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Chaynuy niptinmi María yarpachracuran: “¿Imanirtag chaynuy niman?” nir. ");
INSERT INTO qva_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Chauraga angel niran: “María, ama manchariychu. Gamta Tayta Dios cuyashushpayquim acrashushcanqui. Gamwanmi imaypis canga. ");
INSERT INTO qva_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Cananpitaga gueshyagmi ricacunqui. Yureg wawayqui olgum canga. Paypa jutinmi canga Jesús. ");
INSERT INTO qva_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Munayniyog captinmi runacuna nipäcunga Diospa Wamran canganta. Paytam unay ayllun Davidtanuy mandag cananpag Tayta Dios chruranga. ");
INSERT INTO qva_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Paypa munayninchrümi Israel runacuna imaycamapis capäcunga. Pay munayniyog canganga imaypis manam ushacangachu”. ");
INSERT INTO qva_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Chauraga María tapuran: “Runawan manarag majachacuptïga ¿imanuypatag gueshyag ricacüman?” ");
INSERT INTO qva_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Niptinmi angel niran: “Santu Espíritu gamman shamuptinmi Tayta Diospa munayninwan gueshyag ricacunqui. Chaymi yureg wawayquita juchaynag canga y ‘Diospa Wamran’ nipäcunga. ");
INSERT INTO qva_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Chaynuymi aylluyqui Elisabetpis, chacwanna caycar, wawayog canga. Paytam runacuna ‘Mana wachray yachrag’ nipäcuran. Sogta quillanam pay gueshyag caycan. ");
INSERT INTO qva_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tayta Diospäga manam imapis sasachu”. ");
INSERT INTO qva_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Chauraga María niran: “Nogaga Diosnïpa munayninchrümi caycä. Chauraga pay willacachimushungayquinuy cachun”. Chaynuy nircuptinmi angel aywacuran. ");
INSERT INTO qva_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Angel ninganpita warantincuna María jucla aywaran Judea provincia altunchru caycag marcaman Elisabetta watucunanpag. ");
INSERT INTO qva_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zacariaspa wasinman chrayaycur Elisabetta saludaran. ");
INSERT INTO qva_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","42","Saludaptinmi Elisabetpa pachranchru wamranpis cuyuriran. Chauraga Santu Espiritupa munayninwanmi Elisabet cushicur fiyupa niran: “María, ¡lapan warmicunapitam Tayta Dios gamta acrashushcanqui! Gueshyag caycangayqui wawayquita paymi imaypis yanapanga. ");
INSERT INTO qva_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Dios cachramungan Salvadurpa maman caycar watucamänayquipäga ¿pitag cä noga? ");
INSERT INTO qva_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Saludämangayquita mayaycur gueshyag caycangä wawäpis cushicuypita cuyurisham. ");
INSERT INTO qva_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","¡Tayta Dios nishungayquicunata chrasquicungayquipitam gam cushisha cawaycanqui!” ");
INSERT INTO qva_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Chauraga María niran: “Lapan shongüpam Tayta Diosta alabä. ");
INSERT INTO qva_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Salvacog Tayta Dios nogapag rurangancunapitam cushicü. ");
INSERT INTO qva_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Umildi uywaynin captïpis alipag ricamasha. Cananpitaga lapan runacunam nogapag imaycamapis nipäcunga: ‘Chay warmega Tayta Diospa cuyayninmi caran’ nir. ");
INSERT INTO qva_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Munayniyog Tayta Diosmi nogapag imatapis alicagcunata rurasha. Paynuyga manam pipis canchu. ");
INSERT INTO qva_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tayta Diosga imaypis cuyapanmi munangannuy ruragcunataga. ");
INSERT INTO qva_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Lapan munayninwan ruraran. Runatucogcuna yarpangancunatam manacagman chruranga. ");
INSERT INTO qva_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mandag canganpita nacion mandagcunatapis gargungam. Mana runatucogcunatam ichanga ali cayman chruranga. ");
INSERT INTO qva_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Muchruychru cagcunatam ali cawayman chruranga. Mana cuyapäcog rïcucunatanam ichanga mana imatapis camaripanganachu. ");
INSERT INTO qva_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Pay mandanganta rurag Israel runacunata cuyaparmi mana gongaypa yanapanga. ");
INSERT INTO qva_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Imaycamapis chaynuy cuyapänanpämi Abrahamta y paypita miragcunatapis promitiran”. Chaynuy nirmi Tayta Diosta María alabaran. ");
INSERT INTO qva_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Elisabetcagchru quimsa quillanuy goyarcurnam wasinpana María cuticuran. ");
INSERT INTO qva_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabetpa quillan ayparamuptinnam olgu wamrata gueshyacuran. ");
INSERT INTO qva_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Chayta musyaycurnam aylluncuna y reguinacungancunapis Tayta Dios payta ali yanapanganpita cushicäriran. ");
INSERT INTO qva_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Chaymi pusag junagniyog wamra caycaptin Zacariaspa wasinman paycuna aywapäcuran wamranta circuncidächinanpag. Chaychrümi taytanpa jutinta chrurapayta munapäcuran. ");
INSERT INTO qva_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Chauraga maman niran: “¡Manam chaynuychu jutin canga! Juanmi jutin canga”. ");
INSERT INTO qva_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Elisabet chaynuy niptinmi waquin runacuna nipäcuran: “Chay jutiyöga aylluyquicunachru manam pipis canchu”. ");
INSERT INTO qva_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Chauraga ima jutita chrurapänanpäpis sëñasyaylapa Zacariasta tapupäcuran. ");
INSERT INTO qva_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tapuptinmi pay mañacuran tacshala tablata chaychru escribinanpag. Nircurna chaychru escribiran: “Juan jutin canga” nir. Zacariaspis wamranpa jutin Juan cananta munaptinmi chaychru cag runacuna mancharishanuy ricacuran. ");
INSERT INTO qva_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Chauraga chay höram Zacarías rimayta galaycur Tayta Diosta alabaran. ");
INSERT INTO qva_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Chaycunata ricaycur lapan reguinacungancuna manchacasha ricacäriran. Chaynuy canganpita pï maypis intëru chay marcacunachrümi parlapäcuran. ");
INSERT INTO qva_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Chayta mayagcuna yarpachracäriran: “¡Cay wamra wiñar ima caymanrag chrayanga!” nir. Y runacuna parlangannuylam chay wamrata Tayta Dios shumag yanaparan. ");
INSERT INTO qva_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Chauraga Santu Espiritupa munayninwan parlarmi pay musyachinganta Zacarías niran: ");
INSERT INTO qva_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Tayta Dios alabasha cachun. Payga salvamänanchipänam caycan. ");
INSERT INTO qva_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Mandanganta ruragnin Davidpa aylluncunapita munayniyog salvador yuringa. ");
INSERT INTO qva_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Chaynuy cananpämi Tayta Diospa unay willacognincunawan musyachimaranchi. ");
INSERT INTO qva_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Chaynuypis musyachimaranchi chriquimagninchicunapita jorgamänanchipag canganta. ");
INSERT INTO qva_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Abrahamta y unay ayllunchicunatapis cuyaparan. Chaynuypis promitingancunata manam gongashachu. ");
INSERT INTO qva_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Abrahamtam promitiran ");
INSERT INTO qva_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","chriquimagninchicunapita jorgamänanchipag, mandanganta mana manchacuypa rurananchipag, ");
INSERT INTO qva_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","y waran waran pay munangannuy juchaynaglana cawananchipag”. ");
INSERT INTO qva_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Zacarías chaynuy niyta usharcurmi wamrantana niran: “Tayta Dios cachramungan Salvadurta chrasquicärinanpag willacuptiquim runacuna musyapäcunga Tayta Diospa willacognin cangayquita. ");
INSERT INTO qva_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Gammi tantiyachinqui juchancunapita Tayta Dios perdunar runacunata salvananpag canganta. ");
INSERT INTO qva_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Runacunata cuyaparmi Tayta Dios Salvadurta cachramunga. ");
INSERT INTO qva_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Chaymi Dios cachramungan Salvador shamur juchäcuychru cawagcunata tantiyachinga juchancunapita wanacur ali cawaychrüna cawapäcunanpag”. ");
INSERT INTO qva_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Chaynuymi wamranta Zacarías niran. Chay wamranga wiñaran y Dios munangannuy cawananpag ali yachracuran. Tayta Diospa willacuyninta Israel runacunata willapayta galaycungancama chunyag jircacunalachru tiyaran. ");
INSERT INTO qva_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Belén marcachrümi Jesús yuriran. Chay wichan Augusto César achca naciuncunapa mandagnin caycaran. Mandag caycarmi chay naciuncunachru lapan runacuna censacärinanpag mandaran. ");
INSERT INTO qva_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Cirenio jutiyog runa Siria provinciachru gobernador caycaptinmi chay puntacag censacuy caran. ");
INSERT INTO qva_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Chaymi lapan runacuna marcanman cama censacärinanpag aywapäcuran. ");
INSERT INTO qva_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Chaymi warmin Mariawan Josëpis Galilea provinciachru Nazaret marcapita Judea provinciachru Belén marcaman censacärinanpag aywapäcuran. Chayman aywapäcuran Josëpa ayllun mandag David chaychru yurisha captinmi. Chay junagcuna pachrayogmi María caycaran. ");
INSERT INTO qva_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Belenchru caycaptinnam Mariata gueshyacunanpag nanaynin chariran. ");
INSERT INTO qva_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Maychrüpis pachacärinanpag mana captinmi guechpa wawanta uywacuna puñucunan machraylachru gueshyacuran. Inchranawan wancurcurmi jinalanman chrachraycachiran. ");
INSERT INTO qva_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Belén marca lädunchrümi üshayogcuna üshancunata chacaypa täparcaran. ");
INSERT INTO qva_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Chaymanmi Tayta Diospa angilnin mayänipita achicyaypa achicyar ricaripaptin üsha täpagcuna fiyupa mancharipäcuran. ");
INSERT INTO qva_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Chaymi angel niran: “Ama mancharipäcuychu. Gamcunapämi ali willacuyta apamushcä. Chayta mayarmi lapan runacuna cushicäringa. ");
INSERT INTO qva_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Dios cachramungan Salvadurmi Davidpa marcanchru yurisha. Paymi runacunata salvanga. ");
INSERT INTO qva_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Paytam taripäcunqui uywacuna puñucunan machraychru inchranawan wancusha caycagta. Chaynuy tarirmi cay niycangä rasun canganta musyapäcunqui”. ");
INSERT INTO qva_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Chaynuy niycaptinmi mayänipita chay angilpa lädunchru mas achca angilcuna Tayta Diosta caynuy alabaycar ricacämuran: ");
INSERT INTO qva_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“¡Cieluchru Tayta Dios adorasha cachun! ¡Cay pachachrüpis Tayta Diospag ali cangan runacunapag ali caway cachun!” ");
INSERT INTO qva_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Chaypita angilcuna cieluman cuticaräriptinna üsha täpagcuna jucnin jucninpis ninacäriran: “Tayta Dios willachimanganchinuy ricamunanchipag acu aywashun Belenman”. ");
INSERT INTO qva_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Chaynuy nir lapan apurädu aywapäcuran. Chrayarnam Josëta, Mariata y itintapis uywacuna puñucunan machraychru carcagta taripäcuran. ");
INSERT INTO qva_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nircurna üsha täpagcuna runacunata willaparan itipita angel willangancunata. ");
INSERT INTO qva_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Chaynuy willapaptinmi lapan mayagcuna imaniytapis mana camäpacäriranchu. ");
INSERT INTO qva_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Marianam paycuna ningancunata shongulanchru imaypis yarpararan. ");
INSERT INTO qva_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Angel willangannuy ricaycurmi üsha täpagcuna Tayta Diosta agradecicur alabaycar cuticäriran. ");
INSERT INTO qva_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Chaypita pusag junagniyog caycaptinmi imaypis rurapäcungannuy itita circuncidächiran. Chaychrümi María manarag gueshyag captin angel ningannuyla itipa jutinta chruraparan. Chay junagpitanam chay wamrapa jutin Jesús caran. ");
INSERT INTO qva_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","María gueshyacunganpita chruscu chrunca (40) junagtanam Josëwan aywaran Jerusalén templuman Moisés escribingan leycunata cumplinanpag. Itintapis templuman apapäcuran Tayta Diospa munayninman chrurapäcunanpag. ");
INSERT INTO qva_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Chayta ruraran “Tayta Diospa munayninman chrurapäcuy lapan guechpa olgu wamrayquicunata” nir Moisés escribingan leycunanuylam. ");
INSERT INTO qva_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Warmicuna gueshyacunganpita Diospag ofrendata apananpag caynuymi Moisés escribiran: “Ishcay cullcuycunata o ishcay pülla palumacunata carpis apanqui”. Chaymi Mariapis chay escribirangannuy ofrendata templuman aparan. ");
INSERT INTO qva_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","Chay wichanmi Jerusalenchru Simeón jutiyog runa tiyaran. Paymi alilata rurar Tayta Diosta alabar cawag. Chaynuypis Tayta Dios cachramungan Salvador chrayamunanta shuwaraycaran. Dios cachramungan Salvadurta shuwaraycaran Israel runacuna nacaycanganpita jorgunanpag. Santu Espiritupa munayninchrümi Simeón caran. Chaynuypis Santu Espiritum Simeonta musyachiran Dios cachramungan Salvadurta ricaycur-rag wañunanpag canganta. ");
INSERT INTO qva_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","28","Simeonta Santu Espíritu templuman pushaptinmi Mariawan José itilatarag Jesusta chayman apaycagta ricaran. Chayman paycuna aywapäcusha casha Moisés escribingan leycunata chaychru cumplipäcunanpag. Chauraga chay itita margarcurnam Tayta Diosta alabaran: ");
INSERT INTO qva_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","“Tayta Dios, cananga cumplishcanquinam nimangayquita. Cananga ricashcänam cachramungayqui salvadurta. Ricangächrünaga wañucushänapis. ");
INSERT INTO qva_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","May chaychrüpis tiyag runacuna musyapäcungam cay wamrata gam cachramungayquita. ");
INSERT INTO qva_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Chaymi mana Israel runacunapis musyapäcunga runacunata salvanayquipag canganta. Chaynuy captinmi gamta alabäpäcushunqui ‘¡Ima alirag Israel runacunata Tayta Dios acraran chay ayllupita Salvadurninchi yurinanpag!’ nir”. ");
INSERT INTO qva_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeón chaynuy ningancunata mayarmi Josëwan María imaniytapis mana camäpacäriranchu. ");
INSERT INTO qva_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Chauraga Tayta Diosta Simeón rugacuran paycunata shumag yanapänanpag. Nircur Mariata niran: “Cay wamrata Tayta Dios cachramusha captinmi waquin Israel masinchicunapis mana ushacaypa cawayta taripäcunga y waquincagna infiernuman aywapäcunga. Tayta Diospa willacuyninta pay willacuptinmi chay willacuypa contran achcag rimapäcunga. ");
INSERT INTO qva_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Chaynuypam musyacanga runacuna yarpangan ali mana ali canganpis. Chaynuy pasaptinmi gampa shonguyqui tucsishanuyrag nananga”. ");
INSERT INTO qva_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Templuchru caycaran Tayta Diospa willacognin Ana jutiyog chacwanpis. Paypa taytanmi caran Fanuel, Aser ayllupita. Paymi wamra jipashla caycar runawan tiyaran. Runawan majachacunganpita ganchris watalatam majan wañuran. ");
INSERT INTO qva_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Chaymi pay pusag chrunca chruscu (84) wata viuda caran. Pagas junagmi Tayta Diosta templuchru rugacog. Chaynuypis ayunar Diosta adorag. ");
INSERT INTO qva_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Chay höra itilarag Jesús caycangancagman Ana chrayaycurnam payta ricar Tayta Diosta agradecicuran. Chaynuypis Jesuspita willaparan Tayta Dios cachramungan Salvadurta shuwararcag runacunata. ");
INSERT INTO qva_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Tayta Dios escribichingannuy templuchru cumplircurnam Josëwan María cuticäriran Galilea provinciachru Nazaret marcanman. ");
INSERT INTO qva_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Chay wamra callpayog wiñaran. Yarpayniyog caran y Tayta Dios payta ali ricaran. ");
INSERT INTO qva_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jesuspa taytanwan maman cada wata Jerusalenman Pascua fiestaman aywachräpäcog. ");
INSERT INTO qva_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Chaymi Jesús chrunca ishcay (12) watayog caycaptinna paywanpis chay fiestaman aywapäcuran. ");
INSERT INTO qva_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Chay fiesta usharuptinnam taytanwan maman marcanpana cuticäriran. Jerusalenchru Jesús quëdacunganta manam musyapäcuranchu. ");
INSERT INTO qva_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Chaymi waquin runacunawan Jesús aywaycanganta yarpar juc junagna aywarcaran. Chaypita aylluncunachru y reguinacungancunachrüpis Jesusta ashir manam taripäcuranchu. ");
INSERT INTO qva_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mana tariycurmi cutipäcuran Jerusalenman chaychru ashipäcunanpag. ");
INSERT INTO qva_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Cutinganpita warantin junagrämi templuchru yachracheg runacunawan tapunacur jamaraycagta Jesusta taripäcuran. ");
INSERT INTO qva_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Chauraga lapan mayagcuna almirasha carcaran ali yarpaysapa captin tapungancunata ali yachraptin. ");
INSERT INTO qva_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Chauraga chaychru tariycurmi taytanwan maman ima ruraytapis mana camäpacäriranchu. Chaypitana maman niran: “¿Imanirtag cayta rurarärimanqui? Nogacuna fiyupa laquicur gamta ashipäcushcä”. ");
INSERT INTO qva_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Chaynuy niptin Jesús niran: “¿Imanirtag ashircämanqui? ¿Manachu tantiyapäcushcanqui Taytäpa wasinchru caycangäta?” ");
INSERT INTO qva_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Chaynuy niptin paycunaga mana tantiyapäcuranchu imapita niycangantapis. ");
INSERT INTO qva_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nircur Jesuswanna Nazaretman cuticäriran. Chaychrümi taytanwan maman mandangancunata Jesús ruraran. Ichanga lapan pasangancunata shongulanchru maman yarpararan. ");
INSERT INTO qva_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús wiñaran y mas yarpayniyog ricacuran. Chaynuypis Tayta Dios y runacuna payta mas ali ricaran. ");
INSERT INTO qva_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Zacariaspa wamran Juan chunyag jircachru caycaptinmi Tayta Dios niran willacuyninta willacunanpag. Chay wichanmi Tiberio César chrunca pichga (15) watana lapan naciunpa mandagnin caycaran. Chaynuypis Poncio Piläto Judea provinciachru gobernador caycaran. Herodisnam Galilea provinciachru mandag caycaran. Herodispa wauguin Felipe Iturea partichru y Traconite partichru mandag caycaran. Chaynuymi Lisaniaspis Abilinia partichru mandag caycaran. Jerusalenchrünam Anaswan Caifás lapan cüracunapa mandagnin caycaran. ");
INSERT INTO qva_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Chaymi Jordán mayu cantuncunachru cag marcacunapa caynuy willacuycar Juan puriran: “Juchayquicunapita wanacur bautizacäriy. Chaynuy juchayquipita wanacuptiquim Tayta Dios perdunäshunqui”. ");
INSERT INTO qva_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Juan chaynuy willacunanpämi Tayta Diospa willacognin Isaías caynuy escribiran: “Chunyag jircachrümi juc runa fiyupa gayaraycar willacunga: ‘Mandag runa shamunanpag camiñucunata pichar camaricäringayquinuy camaricäriy Señurta chrasquicärinayquipag’ nir. ");
INSERT INTO qva_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Chaynuy rurapäcuy ragracunata pampachagnuy, jircacunata pampachagnuy, wicsu camiñucunata derechagnuy y shala camiñucunata pichagnuy. ");
INSERT INTO qva_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Juchayquicunapita chaynuy wanacäriptiquim lapan runacuna musyapäcunga Tayta Dios salvashunayquipag canganta”. ");
INSERT INTO qva_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Achca runacuna bautizacärinanpag shamuptinmi Juan imaypis niran: “¡Culebra casta runacuna! Gamcunata, ¿pitag nishushcanqui fiyupa castïgo aywaycämogman mana chrayapäcunayquipag canganta? ");
INSERT INTO qva_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Chayman mana chrayapäcunayquipag juchayquipita rasunpa wanacusha carga alita rurar cawapäcuy. Ama yarpäpäcuychu: ‘Abrahampa ayllun captï Diosnï salvamanga’ nir. Gamcunata nï: Tayta Diosninchega cay rumicunatapis Abraham casta runaman ticrarachinmanmi. ");
INSERT INTO qva_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Jächa camarishanam caycan yüracunata cuchunanpag. Chaymi mana ali wayog yüracunata sapipita cuchurir ninaman gaycunga”. ");
INSERT INTO qva_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Juan chaynuy niptinmi runacuna tapupäcuran: “Chauraga ¿imatatag rurapäcüman?” ");
INSERT INTO qva_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Chaynuy niptinmi niran: “Ishcay trucana röpayog carga jucagcag röpayquita goycunqui röpaynag cagta. Chaynuypis micuyniyog carga raquipaycunqui micuyniynag cagta”. ");
INSERT INTO qva_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Chaynuylam impuestuta cobragcunapis, bautizacunanpag shamur, tapupäcuran: “Maestro, nogacunaga ¿imatatag rurapäcüman?” nir. ");
INSERT INTO qva_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Chauraga Juan niran: “Cobranayquipag canganpita mastaga ama cobrapäcunquichu”. ");
INSERT INTO qva_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Chaynuylam soldäducunapis tapuran: “Nogacunaga ¿imatatag rurapäcüman?” nir. Chaymi Juan niran: “Ama pipa guellaynintapis guechrupäcuychu. Chaynuy ama pipäpis manacagtaga rimapäcuychu. Arungayquipita chrasquingalayquiwan cawapäcuy”. ");
INSERT INTO qva_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Chauraga Dios cachramungan Salvador cay pachaman shamunanpag canganta shuwarag runacuna yarpachracäriran: “¿Juanchurag Dios cachramungan Salvador?” nir. ");
INSERT INTO qva_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Chaymi paywan caycag runacunata Juan niran: “Yaculawan gamcunata bautizä. Nogapita mas munayniyog runa ichanga shamunga. Nogaga manam välïchu llanquincunapa watunta pascapänaläpäpis. Payga Santu Espirituwan y ninawan bautizangapag. ");
INSERT INTO qva_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Payga urquëtan aptasham caycan y trïguta wayranga. Nircurmi trïgucagta wasinman chruranga. Y transancagtana rupachinga imaypis mana upeg ninachru”. ");
INSERT INTO qva_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Chaynuymi Juan Tayta Diospa willacuyninpita tucuynuypa runacunata yachrachiran. ");
INSERT INTO qva_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Chaynuypis Juanga mandag Herodista piñaparan Felipipa warmin Herodiaswan tiyaptin. Mastapis Juanga piñaparan mas achca mana alicunata ruranganpitapis. ");
INSERT INTO qva_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Chaypis Herodisga mas mana alita rurar-rag Juanta carcilman wichrgachiran. ");
INSERT INTO qva_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Carcilman Juan manarag yaycur runacunata bautizaycaptinmi Jesuspis chrayaran bautizacunanpag. Bautizacurcur Diosta rugacuycaptinmi cielo quichracäcuran. ");
INSERT INTO qva_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Chaychrümi Jesusman Santu Espíritu paluma nirag yarpamuran. Chaynuypis cielupita caynuy nimungan mayacämuran: “Gamga cuyay Wamrämi caycanqui. Noga gampita cushisha caycä”. ");
INSERT INTO qva_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Quimsa chrunca (30) watayognuyna caycarmi Jesús willacuyta galaycuran. Paypäga runacuna yarparan Josëpa wamran cangantam. Josëna Elïpa wamran caran. ");
INSERT INTO qva_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí caran Matatpa wamran. Matat caran Levïpa wamran. Leví caran Melquipa wamran. Melqui caran Janapa wamran. Jana caran Josëpa wamran. ");
INSERT INTO qva_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José caran Matatiaspa wamran. Matatías caran Amospa wamran. Amós caran Nahumpa wamran. Nahúm caran Eslipa wamran. Esli caran Nagaipa wamran. ");
INSERT INTO qva_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai caran Maatpa wamran. Maat caran Matatiaspa wamran. Matatías caran Semeipa wamran. Semei caran Josëpa wamran. José caran Judäpa wamran. ");
INSERT INTO qva_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá caran Joanapa wamran. Joana caran Resapa wamran. Resa caran Zorobabelpa wamran. Zorobabel caran Salatielpa wamran. Salatiel caran Neripa wamran. ");
INSERT INTO qva_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri caran Melquipa wamran. Melqui caran Adipa wamran. Adi caran Cosampa wamran. Cosam caran Elmodampa wamran. Elmodam caran Erpa wamran. ");
INSERT INTO qva_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er caran Josuëpa wamran. Josué caran Eliezerpa wamran. Eliezer caran Jorimpa wamran. Jorim caran Matatpa wamran. ");
INSERT INTO qva_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat caran Levïpa wamran. Leví caran Simeonpa wamran. Simeón caran Judäpa wamran. Judá caran Josëpa wamran. José caran Jonanpa wamran. Jonán caran Eliaquimpa wamran. ");
INSERT INTO qva_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim caran Meleapa wamran. Melea caran Mainanpa wamran. Mainán caran Matatapa wamran. Matata caran Natanpa wamran. ");
INSERT INTO qva_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán caran Davidpa wamran. David caran Isaïpa wamran. Isaí caran Obedpa wamran. Obed caran Boozpa wamran. Booz caran Salmonpa wamran. Salmón caran Naasonpa wamran. ");
INSERT INTO qva_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón caran Aminadabpa wamran. Aminadab caran Arampa wamran. Aram caran Esrompa wamran. Esrom caran Farespa wamran. Fares caran Judäpa wamran. ");
INSERT INTO qva_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá caran Jacobpa wamran. Jacob caran Isaacpa wamran. Isaac caran Abrahampa wamran. Abraham caran Tarëpa wamran. Taré caran Nacorpa wamran. ");
INSERT INTO qva_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor caran Serugpa wamran. Serug caran Ragaupa wamran. Ragau caran Pelegpa wamran. Peleg caran Heberpa wamran. Heber caran Salapa wamran. ");
INSERT INTO qva_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala caran Cainanpa wamran. Cainán caran Arfaxadpa wamran. Arfaxad caran Sempa wamran. Sem caran Noëpa wamran. Noé caran Lamecpa wamran. ");
INSERT INTO qva_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec caran Matusalenpa wamran. Matusalén caran Enocpa wamran. Enoc caran Jaredpa wamran. Jared caran Mahalaleelpa wamran. Mahalaleel caran Cainanpa wamran. ");
INSERT INTO qva_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán caran Enospa wamran. Enós caran Setpa wamran. Set caran Adanpa wamran. Y Adán caran Tayta Dios camangan. ");
INSERT INTO qva_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","Jordán mayupita Santu Espiritupa munayninchrüna Jesús cutimuran. Chruscu chrunca (40) junag payta chunyag jircapa pushararan. Satanás chaychru juchäcachiyta camaran. Chay junagcuna micünila caran y chaypitana micanaran. ");
INSERT INTO qva_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Chaymi Satanás niran: “Diospa Wamran caycarga cay rumita tantaman ticrananpag niy”. ");
INSERT INTO qva_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Chaynuy niptin Jesús niran: “Tayta Dios escribichinganchru caynuymi niycan: ‘Manam tantata micularchu runacuna cawan sinöga Tayta Dios lapan ningancunata cäsucurpis cawanmi’ ”. ");
INSERT INTO qva_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Nircurmi Jesusta Satanás altu jirca puntaman pusharan. Chaypitanam may chay naciuncunata ricärichiran. ");
INSERT INTO qva_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Nircurmi niran: “Gongurpaycur nogata adorämaptiquega cay naciuncunata y chaychru cagcunatam goycushayqui. Lapanta noga chrasquishcä munangäcagta pitapis goycunäpämi”. ");
INSERT INTO qva_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Chaynuy niptinmi Jesús niran: “¡Satanás, nogapita ashucuy! Tayta Dios escribichinganchru caynuymi niycan: ‘Tayta Dioslata adoray y pay japalan mandanganta ruray’ ”. ");
INSERT INTO qva_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Chaypitanam Jerusalenman templo janan mas altunninman Jesusta Satanás pusharan. Chaychrünam payta niran: “Diospa Wamran caycarga caypita pampaman jegarpuy. ");
INSERT INTO qva_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Dios escribichinganchru caynuymi niycan: ‘Angilnincunatam Tayta Dios cachramunga cuydashunayquipag’ ");
INSERT INTO qva_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","y ‘Paycunam maquincunawan charishunqui ni chraquilayquitapis rumicunaman mana tacacunayquipag’ ”. ");
INSERT INTO qva_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Niptinmi Jesús niran: “Dios escribichinganchru caynuymi niycan: ‘Tayta Diosniquita quiquiqui munangayquita ama rurachiyta camaychu’ ”. ");
INSERT INTO qva_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Chauraga Satanás juchäcachiyta mana puedirnam yapay cutimunancama payta jaguiriycur aywacuran. ");
INSERT INTO qva_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Chaypitam Santu Espiritupa munayninwanna Galilea provinciaman Jesús cutiran. Chrayaptinna chay marcacunachru paypita runacuna willapänacäriran. ");
INSERT INTO qva_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Chay marcacunachru cag shuntacäpäcunan wasicunachru Jesús yachrachiptinmi lapan runacuna “Ali runam payga” nipäcuran. ");
INSERT INTO qva_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Chaypitanam Jesús aywaran unay tiyangan Nazaret marcaman. Chaymi imaypis rurangannuy sábado jamay junagchru shuntacänan wasiman yaycuran. Chaychrünam runacunapa ñaupagninman Tayta Dios escribichinganta liyimunanpag aywaran. ");
INSERT INTO qva_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Chaychru liyimunanpämi Tayta Diospa willacognin Isaías escribingan libruta chacyaran. Chauraga liyimuran: ");
INSERT INTO qva_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Tayta Diospa Espiritun nogachrümi. Paymi acramasha pobre runacunaman ali willacuyta apanäpag. Chaynuypis cachramasha jucpa munayninchru caycag runacunata jorgunäpag canganta willanäpag, gapracunapa ñawinta cuticächinäpag, jucpa munayninchru nacag runacunata jorgunäpag, ");
INSERT INTO qva_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","y Tayta Diospa munayninchru ali cawapäcunanpag cag tiempo chrayamungantana willacunäpag”. ");
INSERT INTO qva_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Chaynuy liyircurnam libruta wichrgarcur shuntacäpäcunan wasichru yanapag runata Jesús cutiycachiran. Cutiycachir jamacuycuptinmi chaychru caycag runacuna payta ricararcaran. ");
INSERT INTO qva_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Chaymi Jesús niran: “Chay liyimungäta unay escribiran noga ruranäpag cagcunapämi. Chay escribirangannuy cumpliycangäta gamcuna ricarcanquinam”. ");
INSERT INTO qva_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jesuspag lapan shumag parlapäcuran y almirasha carcaran imaycapitapis shumag parlanganpita. Quiquinpura tapunacäriran: “¿Manachu payga Josëpa wamran?” nir. ");
INSERT INTO qva_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Chauraga Jesús niran: “Cay rimay cangannuy següru gamcuna caynuy nimayta yarparcanqui: ‘Jampicog caycarga quiquiquirag jampicuy’. Chaynuypis nimayta yarparcanqui: ‘Mä, Capernaumchru milagruta rurangayquita mayapäcungänuy cay quiquiquipa marcayquichrüpis milagruta ruray’ ”. ");
INSERT INTO qva_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nircurnam niran: “Rasunpam gamcunata nï: Tayta Diospa willacogninga quiquinpa marcanchru manam chrasquishachu caycan. ");
INSERT INTO qva_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Rasunpam gamcunata nï: Tayta Diospa willacognin Elías cawanan wichan Israel naciunchru achca viudacuna caran. Quimsa wata sogta quillantin mana tamyaptin lapan marcacunachru muchruy caran. Achca viudacuna captinpis Eliasta Tayta Dios mana cachraranchu maygan Israel naciunchru tiyag viudatapis yanapämunanpag. Chaypa truquinga Sidonchru cag Sarepta jutiyog marcachru tiyag viudalaman yanapänanpag cachraran. ");
INSERT INTO qva_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Chaynuypis Tayta Diospa willacognin Eliseo cawanan wichan Israel naciunchru achcag caran gueri gueshyawan gueshyaycagcuna. Chay gueshyawan achcag gueshyaycaptinpis Eliseo mana cuticächiranchu maygantapis. Siria naciunpita Naamanta ichanga cuticächiran”. ");
INSERT INTO qva_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Chaynuy ninganta mayaycur shuntacänan wasichru lapan caycagcuna fiyupa rabyacäriran. ");
INSERT INTO qva_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nircurnam marcapita jorgurcur Jesusta apapäcuran gagapa cantunman chaypita tangaripäcunanpag. Paycunapa marcan caycaran chay gaga janan patachru. ");
INSERT INTO qva_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tangariyta munapäcuptinpis runacunapa chraupinpita yargurirmi Jesús aywacuran. ");
INSERT INTO qva_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Chaypitam Galilea provinciachru cag Capernaum marcaman Jesús aywaran. Chaychrümi sábado jamay junagcuna runacunata yachrachiran. ");
INSERT INTO qva_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Yachrachiptin runacuna almirasha ricaräpäcuran. Pay yachracheg lapan munayninwan. ");
INSERT INTO qva_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Chay shuntacäpäcunan wasichrümi diablupa munayninchru caycag runa caycaran. Paymi fiyupa gapararan: ");
INSERT INTO qva_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“¡Nazaret marcapita Jesús! ¿Imatatag nogacunawan munanqui? ¿Ushacächipäcamänayquipächu shamushcanqui? Nogaga musyämi pï cangayquitapis. ¡Gam Tayta Dios cachramungan Runam caycanqui!” ");
INSERT INTO qva_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Chaynuy niptinmi diabluta Jesús piñaparan: “¡Upälacuy y cay runapita yarguy!” nir. Chaynuy niptinmi lapan runacunapa ñaupagninman chay runata sagtariycular imatapis mana ruraylapa diablo yarguran. ");
INSERT INTO qva_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Chauraga runacuna manchacasha jucnin jucninpis ninacäriran: “¡Ima munayniyogtag payga ninganta cäsur diablucunapis yargun!” ");
INSERT INTO qva_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Jesús rurangancunata mayar chay partipaga lapan marcacunachru runacuna parlag. ");
INSERT INTO qva_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Chauraga shuntacäpäcunan wasipitanam Jesús aywaran Simonpa wasinman. Chrayarmi Simonpa suedran fiyupa calintürawan gueshyaycagta tariran. Chaymi chaychru caycag runacuna Jesusta rugacäriran payta cuticächinanpag. ");
INSERT INTO qva_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Chaymi Jesús ashuycur calintürata piñaparan. Piñapaptin calintüra aywacuran. Chauraga chay höra chaychru caycag runacunata jucla gararan. ");
INSERT INTO qva_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Chaypita inti yaycuycaptinnam tucuy nirag gueshyawan gueshyaycagcunata Jesusman apapäcamuran. Chay gueshyagcunata yataycuptinmi lapanpis cuticäpäcuran. ");
INSERT INTO qva_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Chaynuymi achcag runacunatapis diablucuna caynuy gaparpaycar jaguiriycur aywacäriran: “¡Gamga Diospa Wamranmi caycanqui!” nir. Chauraga Dios cachramungan Salvador canganta musyapäcuptinmi diablucunata Jesús piñaparan mana rimacärinanpag. ");
INSERT INTO qva_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Chaypita pacha wararcuptinnam marcapita Jesús chunyagnin jircaman aywaran. Chauraga runacuna ashipäcur pay caycangancagman chrayapäcuran. Chaychru tariycur rugapäcuran paycunacagpita mana aywacunanpag. ");
INSERT INTO qva_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Chaymi Jesús niran: “Waquin marcacunachrüpis Tayta Diospa munayninpita ali willacuyta willacunämi caycan. Chaypämi Tayta Dios cachramasha”. ");
INSERT INTO qva_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Chauraga intëru Israel naciunchrümi runacunapa shuntacänan wasicunachru Diospa ali willacuyninta Jesús willacuran. ");
INSERT INTO qva_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","2","Diospa ali willacuyninta Genesaret lamar cantunchru achca runacunata yachraycächirmi ishcay büquicuna lamar cantunchru jinayla caycagta Jesús ricaran. Pescacogcuna büquincunapita yargurir rednincunata tagsharcaran. ");
INSERT INTO qva_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesús yachrachingancunata mayayta munarmi achca runacuna pay cangancagchru quichrquiypa quichrquir carcaran. Chaymi Simonpa büquinman Jesús jegarcur Simonta niran cantunpita mas ruriscaman büquinta apananpag. Chauraga büquiman jamaycurna chaypita runacunata yachrachiran. ");
INSERT INTO qva_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yachrachiyta usharcurnam Simonta niran: “Cananga büquiquita apapäcuy mas chraupiman. Nircur chaychru redniquicunata mashtay”. ");
INSERT INTO qva_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Chaynuy niptin Simón niran: “Maestro, waraylata pescacuycarpis manam ni juclaylatapis charipäcushcächu. Gam nimaptiqui, mä, yapay rednïcunata mashtapäcushag”. ");
INSERT INTO qva_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Chaynuy nirmi rednincunata mashtar achca pescäducunata rednincunapis rachrinangancama charipäcamuran. ");
INSERT INTO qva_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Chaymi jucag büquichru paywan pescacur caycag runacunata maquinwan sëñasyaypa yanapänanpag gayapäcuran. Paycuna chrayaycärirna ishcan büquincunaman pescäducunata büquincunapis tallpunangancama shuntapäcuran. ");
INSERT INTO qva_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Chaychrümi caycaran Zebedeupa wamrancuna Santiaguwan Juan. Paycunam caran Simonwan pescacur puregcuna. Achca pescäducunata charirmi lapanpis fiyupa manchacashanuy ricacäriran. Chaymi Jesuspa ñaupagninman gongurpacuycur Simón Pedro niran: “Juchasapa runam cä, tayta. Nogapita aywacuy”. Niptinmi Jesús niran: “Ama manchariychu. Cananpitaga pescäduta charingayquinuy Tayta Diospag gamcuna runacunatana shuntapäcunqui”. ");
INSERT INTO qva_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Chaynuy niptinmi lamar cantunman büquincunata chutariycur y lapan imancunatapis chaychru jaguiriycur Jesuswan aywacäriran. ");
INSERT INTO qva_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesús juc marcachru caycaptinmi gueri gueshyawan pasaypa gueshyaycag runa chrayaran. Chay runaga Jesuspa ñaupagninman gongurpacuycur rugacuran: “Munarga cay gueshyäpita cuticaycachilämay, tayta”. ");
INSERT INTO qva_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Chauraga Jesús yataycuran: “Au, munämi. Cuticashanam caycanqui” nir. Niptin chay höra gueri gueshya aywacuran. ");
INSERT INTO qva_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nircurnam piñapaypa Jesús niran: “Ama pitapis willapanquichu noga cuticächingäta. Chaypa truquinga cüraman ayway cuticashana cangayquita ricashunayquipag. Y Moisés escribingan leycunachru ningannuy ofrendata apanqui gueshyayquipita cuticashana cangayquita lapan musyananpag”. ");
INSERT INTO qva_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Cuticächinganta pipis musyananta mana munaycaptinpis may chaychrüpis masmi musyacaran. Chaymi achca runacuna paycagman aywapäcuran yachrachingancunata mayapäcunanpag y gueshyancunapita cuticächisha capäcunanpag. ");
INSERT INTO qva_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ichanga chunyagninmanmi Jesús aywachrag Tayta Diosta rugacunanpag. ");
INSERT INTO qva_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Juc wasichru runacunata Jesús yachraycächiptinmi chaychru jamararcaran Moisés escribingan leycunata yachrachegcunawan fariseucuna. Paycuna shapäcamuran Galilea provinciapita, Judea provinciapita y Jerusalenpitapis. Tayta Diospa munayninwanmi Jesús caycaran gueshyagcunata cuticächinanpag. ");
INSERT INTO qva_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Chaymanmi runacuna quirmawan pulan cuerpun wañusha runata apapäcamuran. Chrayaycachirmi imaycanuypapis Jesuspa ñaupagninman yaycachiyta munapäcuran. ");
INSERT INTO qva_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Achca runacuna chaychru captinmi wasi puncupa yaycachiyta mana puedipäcuranchu. Chaymi wasi jananman jegachipäcuran. Nircur wasi jananta uchrcurcärir quirmantinta Jesuspa ñaupagninman cachrarpapäcuran. ");
INSERT INTO qva_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Chauraga payman yäracäringanta tantiyar chay gueshyaycag runata Jesús niran: “Juchayquicunapita perdunashanam caycanqui”. ");
INSERT INTO qva_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Chauraga Dios escribichinganta yachrachegcunawan fariseucuna yarpachracäriran: “¿Pitag cay runa juchancunapita runacunata perdunänanpag? Dioslam munayniyog caycan runacunata perdunänanpag. ¡Chaynuy rimarga Tayta Diostam apäriycan!” nir. ");
INSERT INTO qva_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Chauraga chaynuy yarparcanganta tantiyarmi Jesús tapuran: “¿Imanirtag chaynuy yarparcanqui? ");
INSERT INTO qva_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Maygantag mas fäcil ninapag? ¿‘Juchayquicunapita perdunashanam canqui’ niychu o ‘Sharcuy. Puriy’ niychu? ");
INSERT INTO qva_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Canan musyachishayqui runata juchancunapita perdunänäpag noga Diospita shamusha Runa cay pachachru munayniyog cangäta”. Nircur chay pulan cuerpun wañusha runata niran: “Gamta nï: ¡Sharcuy! Quirmayquita apacurcur wasiquipa aywacuy”. ");
INSERT INTO qva_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Chauraga lapan ricararcaptinmi chay höra sharcur chrachrarangan quirmanta apacurcur Tayta Diosta alabaycar wasinpa aywacuran. ");
INSERT INTO qva_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Chaymi lapan runacuna almiräpäcuran, Tayta Diosta alabäpäcuran y mancharisha capäcuran. Ninacäriran: “¡Pay rurangantanuyga manam imaypis ricashcanchichu!” nir. ");
INSERT INTO qva_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Chay wasipita Jesús aywaycanganchrümi Leví jutiyog runata impuesto cobracunanchru jamaraycagta ricaran. Chaymi Jesús niran: “Discïpulü canayquipag nogawan puriy”. ");
INSERT INTO qva_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Chauraga cobraycanganta jaguiriycur Jesuswan Leví puriran. ");
INSERT INTO qva_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Wasinchrüna Jesuspag Leví micuyta yanucachiran. Chaychrümi impuestuta achcag cobragcuna y achcag runacunapis Jesuswan Levïwan micurcaran. ");
INSERT INTO qva_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Chay runacunawan Jesús caycagta ricaycurmi Moisés escribingan leycunata yachrachegcunawan fariseucuna Jesuspa discïpuluncunata tapupäcuran: “¿Imanirtag gamcuna impuesto cobragcunawan y mana alipag ricasha runacunawanpis micapäcunqui y upupäcunqui?” ");
INSERT INTO qva_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Niptin Jesús niran: “Sänu cagcunaga jampicogta manam munanchu sinöga gueshyagcunam. ");
INSERT INTO qva_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Noga ali ruragcunata shuntanäpächu manam shamushcä. Sinöga shamushcä juchayogcunata shuntanäpag, paycuna juchancunapita wanacur Dios munangannuy rurananpag”. ");
INSERT INTO qva_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Chaypitanam Jesusta tapupäcuran: “Juan Bautistapa discïpuluncunawan fariseucunapa discïpuluncunaga imaypis ayunäpäcun y Tayta Diostapis rugacärin. Gampa discïpuluyquicunam ichanga micur upular cacun” nir. ");
INSERT INTO qva_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Chauraga Jesús niran: “¿Casarag mösu chaychru paycunawan caycaptinrag fiestaman gayachingan cagcunata ayunächinmanchurag? ");
INSERT INTO qva_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ichanga chrayamungam casarag mösuta apacärinan höra. Chaynam ichanga ayunäpäcunga”. ");
INSERT INTO qva_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Chaynuy nirmi Jesús caynuy willaparan: “Manam pipis macwacag röpata remendananpag mushogcag röpapita träpu rachrinchu. Chaynuy rurarga mushog röpata rachriycächinmi. Y chay mushog röpapita rachrisha träpoga macwa röpachrüga manam camarangachu. ");
INSERT INTO qva_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Chaynuy manam pipis chayrag rurasha vïnuta auquisyasha ordimanga wiñanchu. Auquisyasha ordiman wiñaptinga vïno pogur chay ordita pashtariycachinmi. Chauraga vïnupis jichracäcun, ordipis rachrir ushacäcun. ");
INSERT INTO qva_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Chaymi mushog ordiman chayrag rurasha vïnuta wiñan. Chaynuy ruraptinga vïnupis jichrangachu ni ordipis rachricangachu. ");
INSERT INTO qva_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Chaynuy manam pipis pogusha vïnuta malircur chayrag rurasha cagtaga upuyta munannachu. Paycuna nipäcun: ‘Pogusha vïno mas ali’ ”. ");
INSERT INTO qva_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sábado jamay junagchrümi trïgucuna cangan chracracunapa discïpuluncunawan Jesús pasarcaran. Discïpuluncuna trïgucunata palarcur maquinchru cuparir micapäcuran. ");
INSERT INTO qva_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Chaymi fariseucuna niran: “¿Imanirtag leycunata mana cäsucur sábado jamay junagchru trïguta palarcanqui?” ");
INSERT INTO qva_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Chauraga Jesús niran: “¿Gamcuna manachu liyipäcushcanqui juc cutinchru David yanagagnincunawan micanar pay imata rurangantapis? ");
INSERT INTO qva_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tayta Diosta mañacuna wasiman David yaycuran. Nircur Tayta Diospag chruraraycag tantacunata charircur micuran y yanagagcunatapis goran paycunapis micunanpag. Chaynuy micapäcuran Moisés escribingan leycunachru chay tantacuna cüracunala micapäcunanpag caycaptinpis”. ");
INSERT INTO qva_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nircur Jesús niran: “Noga Diospita shamusha Runa munayniyog caycä sábado jamay junagchru runa rurananpag mana rurananpag cangantapis ninäpag”. ");
INSERT INTO qva_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Chaypita juc sábado jamay junagchrünam shuntacäpäcunan wasiman yachrachinanpag Jesús yaycuran. Chaychrümi juc runa derëchacag maquin macllucasha caycaran. ");
INSERT INTO qva_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Chauraga Moisés escribingan leycunata yachrachegcunawan fariseucuna Jesusta ricaparcaran sábado jamay junagchru cuticächinanta “Leycunata mana cäsunchu” nipäcunanpag. ");
INSERT INTO qva_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Chaynuy yarparcanganta tantiyarmi macllucasha maquiyog runata Jesús niran: “Sharcuy y runacunapa ñaupagninman ichricuy”. Chaynuy niptinmi chay runa sharcurcur ichrircuran. ");
INSERT INTO qva_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nircur paycunata Jesús niran: “Tapushayqui: ¿Imatag sábado jamay junagchru ruranapag caycan: ali cagtachu o mana ali cagtachu? ¿wañuycagta salvaychu o ‘Wañucuchun’ niychu?” ");
INSERT INTO qva_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Chaypita muyuregninchru carcag runacunata ricärir maquin macllucasha caycag runata niran: “¡Maquiquita mashtay!” Mashtarcuptin maquin sänuna ricacuran. ");
INSERT INTO qva_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Sábado jamay junagchru chaynuy cuticächiptinmi Jesusta chriquegcuna fiyupa rabyacäriran. Nircur parlanacäriran Jesusta imanuy imata rurapäcunanpäpis. ");
INSERT INTO qva_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Chaypita juc chacayna altu jircaman Diosta rugacunanpag Jesús aywaran. Chaychrümi Tayta Diosta rugacuycar wararan. ");
INSERT INTO qva_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pacha wararcuptinnam lapan discïpuluncunata gayaran. Nircur paycunapita chrunca ishcay (12) runacunata acraran. Jesús paycunata niran “apostulcuna”. ");
INSERT INTO qva_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Paycunam caran: Simón (paytam Jesusga “Pedro” jutita chruraparan), Simonpa wauguin Andrés, Santiago, Juan, Felipe, Bartolomé, ");
INSERT INTO qva_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Alfeupa wamran Santiago, “Celote” jutiyog Simón, ");
INSERT INTO qva_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Santiagupa wamran Judas, y Jesusta ranticogcag Judas Iscariote. ");
INSERT INTO qva_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jircapita apostulnincunawan Jesús yarpamurnam juc patachru achcag discïpuluncunata y achcag runacunatapis shuntacasha caycagta taripäcuran. Chay runacunam shapäcamusha casha lapan Judea provinciapita, Jerusalenpita, lamarpa cantunpa Tiro y Sidón marcacunapitapis. Paycunam Jesús parlanganta mayayta munar y gueshyancunapita cuticasha cayta munar shuntacäpäcuran. ");
INSERT INTO qva_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Diablo nacaycächingan runacunatapis cuticächiran. ");
INSERT INTO qva_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Munayninwan cuticächiptinmi gueshyancunapita cuticasha capäcunanpag lapanpis Jesusta yatayta munapäcuran. ");
INSERT INTO qva_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Chauraga discïpuluncunata ricärirmi Jesús niran: “Cushisham cawarcanqui, pobricuna. Gamcunam Tayta Diospa munayninchru cawarcanqui. ");
INSERT INTO qva_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Cushisham cawarcanqui, canan micanaycagcuna. Gamcunaga sacsasham canquipag. “Cushisham cawarcanqui, canan wagaycagcuna. Gamcunaga asicärinquipämi. ");
INSERT INTO qva_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Cushicäriy noga Diospita shamusha Runa raycu runacuna chriquishuptiqui, gargushuptiqui y ashlishuptiqui y fiyu cangayquita nipäcushuptiquipis. ");
INSERT INTO qva_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Cushicäriy, chay junag jauca capäcuy. Cieluchru pasaypa shumag alitam Tayta Diospita chrasquipäcunqui. Gamcunata rabyapäshungayquinuylam Tayta Diospa unay willacognincunatapis unay cag ayllun rabyapäpäcuran”. ");
INSERT INTO qva_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Nircur Jesús niran: “¡Rïcucuna cuyapaypämi capäcunqui! Gamcunaga imaycayquipis captin cushishana carcanqui. ");
INSERT INTO qva_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“¡Sacsashana caycagcuna, cuyapaypämi capäcunqui! Gamcunaga micunayquipämi. “¡Cushisha caycagcuna, cuyapaypämi capäcunqui! Gamcunaga fiyupa laquicurmi wagapäcunquipag. ");
INSERT INTO qva_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“¡Lapan runacunapita alabasha caycagcuna, cuyapaypämi capäcunqui! Gamcunanuylam unay cag awilluncunapis Diospa willacognintucog alabag”. ");
INSERT INTO qva_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Gamcuna mayaycämagcunatam ichanga nï: Chriquishogniquicunata cuyapäcunqui. Chriquishogniquicunapag alita rurapäcunqui. ");
INSERT INTO qva_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Imapis mana ali pasashunayquipag nishogniquicunapag bendiciunta Diosta rugacärinqui y ashlishogniquicunapag Diosta rugacärinqui. ");
INSERT INTO qva_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Pipis lagyashuptiquega jucag cärayquitapis camapay. Chompayquita guechrushuptiquega camisayquitapis cachrapariy apacunanpag. ");
INSERT INTO qva_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Runacuna imalatapis mañacushuptiqui goycärinqui. Chaynuy imatapis guechrurcur apacuptin ama ‘Cutichimay’ ninquichu. ");
INSERT INTO qva_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Waquin runacunapag alita rurapäcunayqui waquin runacuna gamcunapag alita rurapäcunanpag munapäcungayquinuy. ");
INSERT INTO qva_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Cuyanacungalayquiwan cuyanacuptiquega ¿ima alitatag ruraycanqui? Juchasapa runacunapis cuyanacungalanwanga cuyanacärinmi. ");
INSERT INTO qva_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Alicagcunalawan ali cawarga ¿ima alitatag rurarcanqui? Juchasapa runacunapis chaynuylaga cawapäcunmi. ");
INSERT INTO qva_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Yanapäshognilayquicunata imachrüpis yanaparga ¿ima alitatag ruraycanqui? Fiyu runacunapis imatapis chrasquinan rayculaga yanapagnincunalataga yanapanmi. ");
INSERT INTO qva_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","36","“Tayta Diosga cuyapanmi mana agradecicogcunata y juchasapacunatapis. Tayta Diosniqui cuyapäcog cangannuy gamcunapis cuyapäcog capäcuy. Chaymi gamcunaga chriquishogniquicunata cuyapäcuy. Paycunapag alicunalata rurapäcuy. Imatapis mañaycurga ama yarpäpäcuychu pägashunayquitaräga. Chaynuy carga pasaypa shumag alitam Tayta Diospita chrasquipäcunqui y munayniyog Tayta Diospa wamrannam carcanqui. ");
INSERT INTO qva_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Runamasiquita ama juzgapäcuychu Tayta Diospis mana juzgashunayquipag. Jucpäga ama nipäcuychu ‘Payga juchayogmi’ nir Diospis gampag mana ninanpag. Pitapis perdunäpäcuy Diospis perdunäshunayquipag. ");
INSERT INTO qva_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Runamasiquita yanapay. Chaymi yanapangayquinuyla imatapis chrasquinquipag chucuy chucuyta, llipay llipayta, jichray jichrayta. Runamasiquita yanapangayquinuylam gamcunatapis Tayta Diosninchi yanapäshunquipag”. ");
INSERT INTO qva_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Caynuypis Jesús niran: “¿Gapra runa gapra masinta pushanmanchurag? Pushaycanganchru ¿manachurag pözuman ishcan jegarparärinman? ");
INSERT INTO qva_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Manam maygan discïpulupis maestrunpita mas canchu. Payta ali yachrachircuptin ichanga maestrunnuy canga. ");
INSERT INTO qva_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“¿Imanirtag yäracogmasiquipa ñawinchru astïlla caycagta ricapanqui? ¿Manachu musyanqui gampa ñawiquichrüga cullu caycanganta? ");
INSERT INTO qva_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Gampa ñawiquichrüpis cullu caycaptinga yäracogmasiquita manam ninquimanchu: ‘Yäracogmasï, ñawiquichru caycag astïllata jorgapäshayqui’. ¡Yachragtucog! ¡Puntataga ñawiquichru cullu caycagtarag jorguy! Chayrämi shumag ricanqui yäracogmasiquipa ñawinchru astïlla caycagta jorgunayquipag. ");
INSERT INTO qva_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ali yüracunaga mana alita manam wayunchu y mana ali yüracunaga alitaga manam wayunchu. ");
INSERT INTO qva_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Wayuyninpam reguinchi yüra ali canganta mana ali cangantapis. Cashacunapita pipis hïgusta manam palanchu. Ni üvasta wallancapita cosechanchu. ");
INSERT INTO qva_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ali runaga alilatam ruran yarpayninchru alicagcunala captin. Fiyu runaga mana alilatam ruran yarpayninchru mana alicunala captin. Runaga yarpäpäcungalantam riman. ");
INSERT INTO qva_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“¿Imanirtag gamcuna ‘Señor Jesús, Señor Jesús’ nipäcamanqui, noga ningäta mana cäsucuycarga? ");
INSERT INTO qva_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Canan tantiyachipäcushayqui nogaman aywamur ningäta mayar cäsucamag runa imanuy cangantapis. ");
INSERT INTO qva_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Rurita uchrcuycur chagachru cimientuta shumag ruraycur wasita sharcacheg runanuymi caycan. Achca yacu chrarpamur saytaptinpis shumag rurasha wasega manam juchrunchu. ");
INSERT INTO qva_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ningäcunata mayaycar mana cäsucamagcagmi ichanga cimientuynag wasita sharcacheg runanuy caycan. Achca yacu chrarpamur saytaptin cimientuynag wasi juchruriycun. Chauraga lapan ushacäcun”. ");
INSERT INTO qva_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Runacunata chaynuy parlapayta usharcur Capernaum marcaman Jesús aywaran. ");
INSERT INTO qva_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Chaychrümi juc capitanpa cuyay uywaynin gueshyar wañuycaranna. ");
INSERT INTO qva_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Chauraga Jesuspita parlapäcunganta chay capitan mayaycurmi Jesusman Israel mayor runacunata cachraran: “Rugacaycamuy aywamunanpag y uywaynïta cuticaycachinanpag” nir. ");
INSERT INTO qva_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Chaymi paycuna chrayaycärir Jesusta rugacäriran: “Capitanpa uywayninta cuticaycachilay. Capitanga ali runam. ");
INSERT INTO qva_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Marcamasinchicunawanpis payga alim. Chaynuy ali carmi shuntacänanchi wasitapis sharcachisha”. ");
INSERT INTO qva_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Chaynuy rugacuptinmi paycunawan Jesús aywaran. Capitanpa wasinman Jesús chrayananpag caycaptinnam chay capitan Jesusta caynuy ninanpag amïguncunata cachraran: “Tayta, ama wasïman aywaycalämunquichu. Israel runa mana caycaptïga gam nogapa wasïman manam yaycunquimanchu. ");
INSERT INTO qva_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Chaymi quiquïga mana shamushcächu gammanpis. Rugacü uywaynï cuticänanpag caylapita niycunayquita. ");
INSERT INTO qva_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Quiquïpis mandamagnïpa munayninchrümi caycä. Chaynuy soldädücunapis nogapa munaynïchrümi caycan. Maygantapis ‘Ayway’ niptïga aywan. Jucninta ‘Shamuy’ niptï shamun. Uywaynïtapis ‘Cayta ruray’ niptï ruran”. ");
INSERT INTO qva_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Capitan chaynuy niptinmi Jesús almirasha quëdaran. Chaymi achcag gatiragnincunata niran: “Gamcunata nï: Paynuy lapan shongunpa yäracamag runata Israel runacunachru manam pitapis tarishcächu”. ");
INSERT INTO qva_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Chaynuy niptinmi capitan cachrangancuna wasiman cutiycur chay uyway cuticashana caycagta taripäcuran. ");
INSERT INTO qva_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Chaypitana discïpuluncunawan Naín marcaman Jesús aywaran. Paycuna aywaptinmi achcag runacunapis aywapäcuran. ");
INSERT INTO qva_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Marcaman yaycuycarna Jesús ricaran wañusha runata pampananpag aparcagta. Chay apaycangan ayaga caran viudapa juclayla wawanmi. Chaymi achcag runacunapis pampäshinanpag aywarcaran. ");
INSERT INTO qva_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Viuda fiyupa wagaptinmi cuyapar Jesús niran: “Ama wagaychu”. ");
INSERT INTO qva_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nircur apaycagcunaman ashuycur quirmanta yataycuran. Chauraga ayata apagcuna ichriycäriptin wañusha caycag mösuta Jesús niran: “¡Mösu, gamta nï: Sharcuy!” ");
INSERT INTO qva_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Chaynuy niptinmi wañusha caycag mösu jamarcamur parlayta galaycuran. Nircur Jesús chay viudata niran: “Cä wawayqui”. ");
INSERT INTO qva_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Chayta ricaycur lapan runacuna manchacasha quëdapäcuran. Nircurnam Tayta Diosta alabar caynuy nipäcuran: “Tayta Diospa munayniyog willacogninmi noganchiman chrayamusha. ¡Tayta Diosmi payta cachramusha yanapämänanchipag!” nir. ");
INSERT INTO qva_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Chaymi Judea provinciachru y lädun marcacunachrüpis Jesús rurangancuna musyacaran. ");
INSERT INTO qva_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jesús rurangancunatam Juan Bautistapa discïpuluncuna Juanta willaran. ");
INSERT INTO qva_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Chauraga ishcaycag discïpuluncunata Jesusman tapumunanpag cachraran: “¿Gamchu caycanqui Tayta Dios cachramungan Salvador, o juctarächu shuwaräpäcushag?” nir. ");
INSERT INTO qva_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Chauraga Juan cachrangancuna Jesuscagman chrayar payta tapupäcuran: “Juanmi musyayta munaycan: ‘¿Gamchu caycanqui Tayta Dios cachramungan Salvador, o juctarächu shuwaräpäcushag?’ ” ");
INSERT INTO qva_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Chay höra Jesús achca gueshyagcunata cuticächiran, runacunapita diablucunata garguran y gapracunatapis cuticächiran. ");
INSERT INTO qva_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Chay gueshyagcunata cuticarcachir Jesús niran: “Cutipäcuy y Juanta willapäcuy ricapäcungayquita y mayapäcungayquita. Gapracuna ricannam. Wegrucuna purinnam. Gueri gueshyawan gueshyaycagcuna cuticashanam. Upacuna mayannam. Wañushacuna cawarimusham. Pobricunapis Tayta Diospa ali willacuyninta mayaycannam. ");
INSERT INTO qva_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Cushisham carcan mana cachrariypa nogaman yäracamar cawagcunaga”. ");
INSERT INTO qva_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Juan cachramungancuna cuticaräriptinmi runacunata Juanpita Jesús niran: “¿Chunyag jircaman imata ricagta aywapäcurayqui? ¿Segsita wayra cuyuchegta ricanayquipächu aywapäcurayqui? ");
INSERT INTO qva_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Chauraga ¿imata ricapäcunayquipätag aywapäcurayqui? ¿Fïnu röpan jatisha runata ricanayquipächu? Fïnu röpan jatisha runacunaga munanganta rurar reycunapa wasincunalachrümi carcan. ");
INSERT INTO qva_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Chauraga ¿imata ricapäcunayquipätag aywapäcurayqui? ¿Diospa willacogninta ricapäcunayquipächu aywapäcurayqui? Gamcunata nï: Au. Tayta Diospa mas alinnincag willacogninta ricapäcunayquipämi aywapäcurayqui. ");
INSERT INTO qva_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juanpag Tayta Dios escribichinganchru nogapag niran: ‘Gampa puntayquita willacognïtam cachrashag camiñuta alichagnuypis runacunata gampag camaricachinanpag’. ");
INSERT INTO qva_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Gamcunata nï: Lapan runacunapita Juanmi mas alinnincag. Chaynuy captinpis Tayta Diospa munayninchru lapancagcunam Juanpita mas ali caycan”. ");
INSERT INTO qva_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Lapan runacuna y Roma impuestuta cobragcuna Jesús ninganta mayaycur tantiyapäcuran Dios ali rurag canganta Juan paycunata bautizasha captin. ");
INSERT INTO qva_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Fariseucunawan Moisés escribingan leycunata yachrachegcunam ichanga Tayta Dios ningancunata chrasquicuyta manam munaranchu mana bautizacushachu car.) ");
INSERT INTO qva_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“¿Imamantag canan tiempo runata tincuchïman? ");
INSERT INTO qva_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Cay runacuna caycan pläzachru puclananpag jamarar waquin wamracunata caynuy gayarag wamracunanuymi: ‘Majachacuy fiestata puclar tucapäcuptïpis manam dansapäcushcanquichu. Aya pampayta puclar cantacunata cantapäcuptïpis manam wagapäcushcanquichu’. ");
INSERT INTO qva_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Juan Bautista tantata mana micuptin y vïnuta mana upuptin ‘¡Diablupa munayninchrümi payga caycan!’ nipäcunqui. ");
INSERT INTO qva_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Noga Diospita shamusha Runa micuptï y vïnuta upuptï ‘Ricapäcuy, micuylapag upyaylapag caycan’ nipäcunqui. Chaynuypis ‘Juchasapa runacunawan y Romapag impuesto cobragcunawan puricog’ nipäcunqui. ");
INSERT INTO qva_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ichanga Tayta Dios rasunpa yachrag cangan musyacan runacuna alita rurapäcuptin y pay munangannuy cawapäcuptinmi”. ");
INSERT INTO qva_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Chaypitam fariseo runa wasinman Jesusta pusharan chaychru paywan micapäcunanpag. Wasinman chrayaycachirmi mësacagman jamachiran. ");
INSERT INTO qva_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Chayman Jesús aywanganta musyaycurmi chay marcachru tiyag mañösa warmi aywaran. Alabastrupita rurasha botëllawan perfümita aparan. ");
INSERT INTO qva_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jesuspa ñaupagninman ichriycur wagapaptinmi Jesuspa chraquinman weguin shuturan. Chay shutungantanam agchanwan chaquichiparan. Nircur Jesuspa chraquinta muchaycur apangan perfümita gaycaparan. ");
INSERT INTO qva_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Chayta ricaycurmi fariseo runa caynuy yarparan: “Diospa willacognin carga Jesús tantiyanmanmi mañösa warmi yataycanganta”. ");
INSERT INTO qva_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Chaynuy yarpaycanganta musyarmi fariseo runata Jesús niran: “Simón, willashayqui”. Chaynuy niptinmi payga niran: “Mä willamay, maestro”. ");
INSERT INTO qva_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Chauraga jagatucusha runacunaman Simonta y chay mañösa warmita tincuchirmi Jesús niran: “Ishcay runacunam juc runapa jagan caran. Jucnin jagan caran ishcay wata arur gänangannuy. Jucagna jagan caran ishcay quilla arur gänangannuy. ");
INSERT INTO qva_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Chay runacuna jagan canganta pägayta mana puediptin ishcantapis mana cobrarannachu. Canan nimay. ¿Maygancagtag chay guellayniyog runata mas cuyanman?” ");
INSERT INTO qva_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Chauraga Simón niran: “Mas achca jagancag runam”. Niptinmi Jesús niran: “Alim yarpayniqui”. ");
INSERT INTO qva_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Chauraga warmita ricärir Simonta Jesús niran: “Ricay cay warmita. Chaynuy rurasha juchasapa canganpita perdunasha carmi. Costumbrinchi caycaptinpis wasiquiman yaycamuptï gamga manam yacuta gomashcanquichu chraquïta mayllacunäpag. Cay warmim ichanga chraquïman weguin shutungantapis agchanwan chaquichipämasha. ");
INSERT INTO qva_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Costumbrinchi captinpis yaycamuptï manam muchamarayquichu. Paymi ichanga yaycamunganpita pacha mana uticaypa chraquïta muchasha. ");
INSERT INTO qva_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Umämanpis manam aceitita gaycapämashcanquichu. Paymi ichanga chraquïman perfümita gaycapämasha. ");
INSERT INTO qva_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Cay warmega juchasapa canganpita perdunasha carmi cuyamar chaynuy ruraycäman. Waquincunaga manam chaynuy cuyacog canchu”. ");
INSERT INTO qva_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nircur chay warmita niran: “Lapan juchayquicunapita perdunashanam caycanqui”. ");
INSERT INTO qva_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Chaymi mësacagchru jamararcag runacuna quiquinpura caynuy ninacäriran: “¿Pitag payga runapa juchancunata perdunänanpag?” ");
INSERT INTO qva_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Chauraga Jesús niran chay warmita: “Yäracuyniquipam salvasha caycanqui. Cananga cushishana aywacuy”. ");
INSERT INTO qva_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Chaypitanam chrunca ishcay (12) discïpuluncunawan Jesús marcan marcan Tayta Diospa munayninpita ali willacuyta willacuycar puriran. ");
INSERT INTO qva_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Paywanmi aywapäcuran diablupa munayninpita jorgungan warmicuna y gueshyanganpita cuticächingan warmicuna. Chay warmicunam Jesusta y discïpuluncunata imancunapis canganpita yanaparan. Chaychrümi caran María Magdalena jutiyog warmi. Paypitam ganchris diablucunata gargusha caran. ");
INSERT INTO qva_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Chaynuypis capäcuran Herodispa yanapagnin Cuzapa warmin Juana, Susana y mas warmicunapis. ");
INSERT INTO qva_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Chauraga marcacunapita achca runacuna Jesuscagman shamur shuntacarcuptinmi Jesús tincuchiypa caynuy willaparan: ");
INSERT INTO qva_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Juc runa murog aywaran. Muruta mashtaptin waquin murucuna camiñuman chrayaran. Chauraga runacuna chay camiñupa purir murucunata jaruchraran. Chaynuy pishgucunapis shamur chay murucunata upshacarcäriran. ");
INSERT INTO qva_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Waquin muru shala shala allpaman chrayaran. Chaychru wiñarcamur ümidu mana captin chaquicäcuran. ");
INSERT INTO qva_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Waquinna chrayaran cashacuna wiñaycämog rurinman. Cashacunawan wiñamur garwashtaycälar chaquicäcuran. ");
INSERT INTO qva_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mas waquincagna ichanga ali allpaman chrayaran. Chaycuna ali wiñamur juc espïjalachru pachracta (100) wayuran”. Chaynuy willaparcur Jesús fiyupa niran: “¡Ningäta mayagcäga shumag tantiyacäriy!” ");
INSERT INTO qva_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Chaypita discïpuluncuna tapupäcuran chay yachrachingan ima ninan cangantapis. ");
INSERT INTO qva_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Chauraga Jesús paycunata niran: “Gamcunata Tayta Diosmi tantiyarcächishunqui munayninpita pipis mana musyanganta. Waquincunatam ichanga imamanpis tincuchiypa yachrachï ricaycarpis mana ricagnuy cananpag y mayarpis mana tantiyagnuy cananpag. ");
INSERT INTO qva_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Chay willapangäcunaga caynuymi caycan: Muroga Tayta Diospa ali willacuyninnuymi. ");
INSERT INTO qva_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Camiñoga caycan waquin runacunapa shongunnuymi. Chay runacuna Tayta Diospa willacuyninta mayaptinpis Satanás shamur gongariycachin. Chaymi Diosman mana yäracurga salvaciunta mana taripäcunganachu. ");
INSERT INTO qva_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Shala shala allpaga caycan waquin runacunapa shongunnuymi. Murupa sapinchru allpa mana captin chaquingannuymi Diospa ali willacuyninta cushisha chrasquicurpis juc tiempula criyipäcun. Chauraga fiyupa nacar jaguiriycärin. ");
INSERT INTO qva_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Cashacuna rurinchru cag allpaga caycan waquin runacunapa shongunnuymi. Diospa willacuyninta mayarpis mas yarpachracärin warantincuna ruraynincunalapag, rïcuyänalanpag, y munangannuy cawapäcunalanpag. Chaymi chay runacuna Tayta Dios munangannuychu mana cawarcan. ");
INSERT INTO qva_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ali allpaga caycan waquincag runacunapa shongunnuymi. Diospa willacuyninta ali shongunpa chrasquicur mana cachrariypam payman yäracärin. Chaymi ali allpachru muru wiñarcamur shumag wayungannuy Tayta Dios munangannuyla mana yamacaypa shumag cawapäcun”. ");
INSERT INTO qva_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Chaynuy nircurmi discïpuluncunata niran: “Manam pipis achquita ratachinchu imawanpis chapaycunanpag, ni cäma rurinman chrurananpag. Chaypa truquinga, ricacagninmanmi chruran yaycog runacunata achquipänanpag. ");
INSERT INTO qva_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Chaynuylam pacasha cagcuna musyacangam y mana musyasha cagcunapis musyachingam. ");
INSERT INTO qva_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Yachrachinayquipäga ningäcunata shumag mayapäcamay. Mayamagcunaga yachranganpitapis masmi yachracunga. Mana mayamagcunam ichanga ichicla yachrangalantapis gongaycäringa”. ");
INSERT INTO qva_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Chaypita Jesús caycangancag wasiman mamanwan wauguincuna chrayaran. Achca runacuna captinmi pay caycangancagman yaycuyta mana puedipäcuranchu. ");
INSERT INTO qva_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Chaymi juc runa Jesusta willaran: “Puncuchru mamayquiwan wauguiquicuna shuwararcäshunqui” nir. ");
INSERT INTO qva_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Chaynuy niptinmi Jesús niran: “Diospa willacuyninta mayar cäsucogcunam mamänuy y wauguïnuy carcan”. ");
INSERT INTO qva_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Juc cutinchrümi discïpuluncunawan büquiman yaycur Jesús niran: “Acu, pasashun lamarpa jucag chimpanman”. Chaynuy nir büquiwan aywaran. ");
INSERT INTO qva_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Lamarta pasarcangancama Jesús puñucäcuran. Puñucasha cangancama lamarman fiyupa wayra wayrämuran. Chauraga büquiman yacu juntayta galaycuran y tallpucächinanpäna caycaran. ");
INSERT INTO qva_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Chaynuy captin Jesusta ricchachipäcuran: “¡Maestro, maestro! ¡Tallpucänanchipäna caycanchi!” nir. Chaymi Jesús sharcurcur wayratawan yacuta piñaparan. Piñaparuptinmi wayrapis yacupis chrawaran y lapanpis shumagna ricacuran. ");
INSERT INTO qva_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nircur discïpuluncunata niran: “¿Imanirtag mana yäracärimanquichu?” Chauraga mancharisha y almirasha car quiquinpura ninacäriran: “¿Pirag cay runaga? Pay mandaptin wayrapis yacupis payta cäsun” nir. ");
INSERT INTO qva_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Chaypita Gerasa jutiyog partiman chrayapäcuran. Chay caran Galilea provincia chimpanchrümi. ");
INSERT INTO qva_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Büquipita Jesús yarpuruptinmi marcapita cag runa shamuran. Chay runam diablucunapa munayninchru caycaran. Unaypita pacha garapachrala puricuran wasichrüpis mananam tiyagnachu. Chaypa truquinga panteunlachrümi cacogpis. ");
INSERT INTO qva_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Chay runata achca cutim munanganta diablo rurachiran. Maquinta y chraquinta cadinawan watapäcog. Watapäcuptinpis cadinata rachriricogmi. Chaypitana chunyag jircacunaman diablo garguriycog. Chauraga chay runata Jesús niran: “¡Diablo, chay runapita yarguy!” Chaynuy niptinmi ñaupagninman gongurpacuycur gapararan: “Imaycapäpis munayniyog Diospa Wamran Jesús, ¿imatatag nogawan munanqui? Gamta rugacü: ¡Ama nacaycachilämaychu!” nir. ");
INSERT INTO qva_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Chauraga Jesús chay runata tapuran: “¿Imatag jutiqui?” nir. Niptinmi: “Nogapa jutïga Legiunmi” niran. Chaynuy niran achca diablucuna payman yaycusha captinmi. ");
INSERT INTO qva_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Chaymi chay diablucuna Jesusta rugacäriran wanwanyaycag ragraman mana garpunanpag. ");
INSERT INTO qva_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Chauraga janaganchru achca cuchicuna captinmi rugacäriran cuchicunaman yaycacaycärinanpag. Chauraga Jesús au niran yaycunanpag. ");
INSERT INTO qva_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Chaymi diablucuna runapita yargurcur chay cuchicunaman yaycacaycäriran. Chauraga cuchicuna löcutar chay tunapita uranpa lamarcama cörripäcuran y chaychru shengaypa wañupäcuran. ");
INSERT INTO qva_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Chauraga cuchi michegcuna chayta ricaycur cörrir gueshpir marcachru tiyag runacunata y chracracunachru tiyag runacunata chaynuy pasaycanganta willag aywaran. ");
INSERT INTO qva_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Willapäcuptinmi runacuna ima pasangantapis ricananpag aywapäcuran. Jesuscagman chrayapäcurmi chay diablucunapita cuticag runata taripäcuran Jesuspa ñaupagninchru jamaraycagta. Ali yarpayninchrüna car röpan jatishana caycaran. Chayta ricaycurmi runacuna manchacäpäcuran. ");
INSERT INTO qva_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Chaychrümi waquin ricag runacuna willaran diablucunapa munayninchru canganpita imanuypa chay runa cuticangantapis. ");
INSERT INTO qva_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Chaymi pasaypa manchacur chaypita aywacunanpag Gerasa partichru tiyag lapan runacuna Jesusta rugacäriran. Chauraga büquiman jegarcur Jesús cutiran. ");
INSERT INTO qva_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Manarag aywacuptinmi chay diablucunapita cuticag runa Jesusta rugacuran paywan aywacärinanpag. Ichanga Jesús quëdacunanpag niran: ");
INSERT INTO qva_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Wasiquiman cuticuy. Chaychru willacuy Tayta Dios gamwan imata rurangantapis”. Chaynuy niptinmi marcapa aywar runacunata willaparan Jesús paywan imata rurangantapis. ");
INSERT INTO qva_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Gerasa partipita Jesús cutiptinmi shuwararcag runacuna cushisha chrasquicäriran. ");
INSERT INTO qva_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Chaymanmi Jairo jutiyog runa chrayaran. Paymi shuntacäpäcunan wasichru mandag caran. Paypam juclayla warmi wamran wañuycaranna. Chay wamran chrunca ishcay (12) watayog caycaran. Chaymi Jesuspa ñaupagninman wamran cuticächeg aywananpag gongurpacuycur rugacuran. Chauraga Jesús aywaycaptinmi achca runacuna quichrquipa quichrquir payta gatiräpäcuran. ");
INSERT INTO qva_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Chaymi runacunapa chraupinchru chrunca ishcay (12) watana yawar apaywan gueshyaycag warmipis aywaycaran. Sänu cayta munarmi chay warmi lapanta usharan mëdicucunata pägananpag. Imanuypa jampicurpis manam cuticaranchu. ");
INSERT INTO qva_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Chauraga Jesuspa guepanpa yaycuycur röpanpa cantunta yataycuran. Chaymi chay höra yawar apaynin chrawariycuran. ");
INSERT INTO qva_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Chauraga Jesús niran: “¿Pitag yataycamasha?” Chaychru lapanpis “Manam noga yatashcächu” nipäcuptinmi Pedro niran: “Maestro, quichrquipa quichrquir aywaycashaga maygan yatashungayquitapis ¿imanuyparag musyashwan?” ");
INSERT INTO qva_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Chaynuy niptinpis Jesús yapay niran: “Musyämi mayganpis yataycamar munaynïwan cuticasha canganta”. ");
INSERT INTO qva_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Chauraga chay warmi pacacuyta mana camäpacurmi Jesuspa ñaupagninman sicsicyaycar gongurpacuycuran. Nircur lapan mayaycaptin imanir yataycunganta y chay höra cuticasha canganta willacuran. ");
INSERT INTO qva_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Chauraga Jesús niran: “Yäracuyniquipam cuticashana caycanqui. Cananga cushishana aywacuy”. ");
INSERT INTO qva_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesús chaynuy rimaycaptinrag mandag Jairupa wasinpita juc runa chrayaycur Jairuta caynuy willaran: “Wamrayqui wañushanam caycan. Maestruta wasiman amana pushaynachu”. ");
INSERT INTO qva_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Chaynuy negta mayarmi Jesús niran: “Ama manchacuychu. Gamga yäracuy. Yäracuptiquega wamrayqui cawarimungam”. ");
INSERT INTO qva_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Chauraga Jairupa wasinman chrayaycurmi chay wañusha wamrapag wagarcagta ricar Jesús niran: “Ama wagapäcuychu. Chay wamraga manam wañushachu caycan, sinöga puñucashalam caycan”. Wamra wañusha caycanganta musyarmi chaychru cag runacuna payta asiparan. Chaymi wamra wañusha caycangancagman Jesús yaycachiran Pedruta, Juanta, Santiaguta y wamrapa taytantapis mamantinta. Waquincagcuna yaycunantam ichanga mana munaranchu. ");
INSERT INTO qva_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nircur wañusha caycag wamrata maquipita charircur Jesús niran: “¡Jipash, sharcuy!” ");
INSERT INTO qva_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Chaynuy niptin wañusha caycag wamra chay höra cawarircamur jucla sharcuran. Chauraga Jesús mandaran chay wamrata micuyta garananpag. ");
INSERT INTO qva_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Wamran cawarimunganta ricaycur taytan maman almirasha ricacäpäcuran. Chay jipashta cawarichimunganta pitapis mana willapäcunanpag Jesús fiyupa niran. ");
INSERT INTO qva_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Chaypita chrunca ishcay (12) discïpuluncunata gayaycur munayninta Jesús goran runapita tucuy nirag diablucunata gargunanpag y gueshyagcunata cuticächinanpag. ");
INSERT INTO qva_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nircurna paycunata Tayta Diospa munayninpita willacärinanpag y gueshyaycagcunata cuticächipäcunanpag cachraran. ");
INSERT INTO qva_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Paycunata niran: “Imatapis ama apapäcunquichu ni tucapiquita ni guepiquita ni mircapayquita ni guellayniquita ni trucacunayquipag röpayquitapis. ");
INSERT INTO qva_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","May wasiman pachacurpis chaylachru pacharäcärinqui juc marcapa aywacäringayquicama. ");
INSERT INTO qva_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","May marcachrüpis mana chrasquipäcushuptiquega chaypita chraquiquichru lagacasha polvuta tapshirir aywacärinqui. Chay canga paycuna mana chrasquicärishungayquipita Dios castigänanpag canganta tantiyacärinanpag”. ");
INSERT INTO qva_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Chauraga discïpuluncuna aywaran. Marcan marcan purirmi maychrüpis Tayta Diospa ali willacuyninta willacärimuran y gueshyagcunatapis cuticächipäcuran. ");
INSERT INTO qva_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Galileachru rey Herodisga Jesús lapan imaycatapis ruraycanganta mayaran. Waquinga “Juanmi cawarimusha” nircaran. Waquinna “Willacog Eliasmi yapay yurimusha” nircaran. Waquinnam “Unay willacogcunam mayganpis cawarimusha” nircaran. Chaymi imata yarpachracuytapis mana puediranchu. ");
INSERT INTO qva_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodisnam niycaran: “Juantaga quiquïmi umanta roguchiypa wañuchichishcä. Chay runaga imatapis ruraycanganta mayaycä. ¿Pirag canman pay?” Chaymi imanuypapis Jesuswan tincuyta munaran. ");
INSERT INTO qva_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Willacäringanpita discïpuluncuna cutiycamurmi Jesusta willaparan lapan rurangancunata. Chaypita paycunata pushacurcur Betsaida marcapa cercanman Jesús aywaran. ");
INSERT INTO qva_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Chaypa aywapäcunganta musyaycur guepanta achca runacuna aywapäcuran. Pay cangancagman chrayaräriptin Jesús paycunata chrasquicuran. Nircur Tayta Diospa munayninpita yachrachiran. Chaynuymi gueshyaycagcunatapis cuticächiran. ");
INSERT INTO qva_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Chaymi pacha tardiyaptinna discïpuluncuna Jesusta nipäcuran: “Imapis mana cangan jircachrümi caycanchi. ‘Aywacäriyna’ niy cay runacunata cercachru estanciacunapa y cercachru marcacunapa pachacärinanpag y micuyninta ranteg aywacärinanpag”. ");
INSERT INTO qva_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Chauraga Jesús niran: “Gamcuna paycunata micuyta gopäcuy”. Chaynuy niptinmi discïpuluncuna nipäcuran: “Caychru chararcä pichga tantatawan ishcay pescädulatam. Micuy ranteg mana aywapäcurga ¿imatatag caychica runacunataga micunanpag garapäcushag?” ");
INSERT INTO qva_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Chaychru pichga waranganuy (5.000) olgucuna caycaran. Chauraga discïpuluncunata Jesús niran: “Lapan runacunata pichga chruncata cama (50) jamachiy”. ");
INSERT INTO qva_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Chaynuy niptinmi chaychru cagcunata lapanta jamachipäcuran. ");
INSERT INTO qva_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Chauraga Jesús pichga tantata y ishcay pescäduta aptarcur cieluta ricärir Tayta Diosta rugacur agradecicuran. Nircurna partirir partirir discïpuluncunata chacyaran lapan runacunata aypupäcunanpag. ");
INSERT INTO qva_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Chaymi sacsangancama lapan micapäcuran. Y puchogcunata chrunca ishcay (12) canastata discïpulucuna shuntapäcuran. ");
INSERT INTO qva_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Juc junagmi discïpuluncunawan caycar Jesusga Diosta japalan rugacuran. Rugacuyta usharcur paycunata tapuran: “¿Pï cangätatag nogapag runacunaga nipäcun?” ");
INSERT INTO qva_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Chauraga discïpuluncuna nipäcuran: “Waquin nipäcun Juan Bautista cangayquita, waquinnam nipäcun Elías cangayquita, y waquincagnam nipäcun maygan unay Diospa willacogninpis wañunganpita cawarimusha cangayquita”. ");
INSERT INTO qva_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Chaypita yapay tapuran: “Gamcunaga ¿pï cangätatag nipäcunqui?” Chauraga Pedro niran: “Gamga Tayta Dios cachramungan Salvadurmi caycanqui”. ");
INSERT INTO qva_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Nircurnam Jesús niran chaypita pitapis mana willapänanpag: ");
INSERT INTO qva_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","“Noga Diospita shamusha Runa fiyupa nacachisharämi cashäpag. Israel mayor runacuna, cüracunapa mandagnincuna y Moisés escribingan leycunata yachrachegcuna conträ sharcunga. Nircur wañuchipäcamanga. Chaypita quimsa junagtaga cawarimusham cashag” nir. ");
INSERT INTO qva_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nircur chaychru cag lapan runacunata y discïpuluncunata niran: “Pipis discïpulü cayta munarga quiquinpa shongun munangalannuyga ama cawachunchu. Chaypa truquinga wañunan captinpis noga munangänuy imaypis cawachun. ");
INSERT INTO qva_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Pipis quiquilanpita salvacuyta munagcäga manam salvacungachu. Ichanga noga janan wañurpis wañuptinga salvacungam. ");
INSERT INTO qva_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mana ushacaypa cawayman mana aywananpag caycaptinga ¿imapätag välin cay pachachru imaycayogpis cangan? ");
INSERT INTO qva_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Pipis nogapita y ali willacuynïpita pengacuptinga noga Diospita shamusha Runapa chipipaynïwan, Taytäpa chipipayninwan y Diospita angilcunapa chipipayninwan cutimurmi noga Diospita shamusha Runa paypita pengacushag. ");
INSERT INTO qva_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Rasunpam gamcunata nï: Caychru waquin caycagcunaga manarag wañur Tayta Diospa munayninwan mandanganta ricanga”. ");
INSERT INTO qva_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Chaypita pusag junagtanuyman juc altu jircaman Diosta rugacunanpag Jesús jegaran. Chaypa aywar pusharan Pedruta, Juanta y Santiaguta. ");
INSERT INTO qva_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Diosta Jesús rugacuycaptinmi cäranpis jucnuyman ticraran y röpanpis yurag chipipaycagman ricacuran. ");
INSERT INTO qva_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Mayänipita Moiseswan Elías ricacarcamurmi Jesuswan parlapäcuran. ");
INSERT INTO qva_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Shumag chipipaycagpa chraupinchrümi quimsan parlarcaran Jerusalenchru Jesús wañunanpag canganta. ");
INSERT INTO qva_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Chay höram ishcay discïpulo masincunawan Pedro fiyupa puñunarcarpis riccharcaran. Chaychrümi chay ishcay runacunawan Jesús chipipaycar parlarcagta ricapäcuran. ");
INSERT INTO qva_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Chauraga chay runacuna illacäcuptinnam mana yarpachracuypa Pedro niran: “Maestro, ima alish caychru nogacuna carcä. Cananga quimsa chuclacunata rurapäcushag: jucta gampag, jucta Moisespag y jucta Eliaspag”. ");
INSERT INTO qva_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Chaynuy parlaycaptin pucutay aywamur chapacurcuptinmi discïpulucuna fiyupa manchacäpäcuran. ");
INSERT INTO qva_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Chauraga pucutay rurinpitam nimuran: “¡Payga cuyay Wamrämi! ¡Payta mayacäriy!” nir. ");
INSERT INTO qva_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nimuptin quiquilanna Jesús ricacuran. Discïpuluncuna chay ricanganta chay wichan pitapis manam willaparanchu. ");
INSERT INTO qva_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Warantin junag chay puntapita cutipäcamuptinna achcag runacuna Jesusta taripacäriran. ");
INSERT INTO qva_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Chauraga runacuna caycanganpitam juc runa fiyupa nimuran: “¡Cuyapayculay cay juclayla wamräta, maestro! ");
INSERT INTO qva_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Diablum chariycur mayänipita gaparächin, gochrpachin, pushgaytapis agtuchin. Fiyupam nacachin. Manam cachrarinchu. ");
INSERT INTO qva_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Diabluta gargupäcunanpag discïpuluyquicunata rugacuptïpis manam garguyta puedipäcushachu”. ");
INSERT INTO qva_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Chaymi Jesús niran: “¡Yäracuyniynag ogracasha runacuna! ¿Imaycamarag gamcunawan caycäshag? Wamrayquita apamuy”. ");
INSERT INTO qva_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Chauraga Jesuspa ñaupagninman chay wamra aywaycaptinna pampaman diablo sagtariycuran. Chauraga wamrata gochrpaycächiran. Chaymi wamrapita aywacunanpag diabluta Jesús piñaparan. Chauraga wamrata cuticächiran. Nircur chay wamrapa papäninta Jesús niran: “Cä wamrayqui”. ");
INSERT INTO qva_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Chauraga Tayta Diospa munayninwan diabluta gargunganta ricarmi lapan almiräpäcuran. Chaynuy lapan rurangancunapita lapan cushisha carcaptinmi discïpuluncunata Jesús niran: ");
INSERT INTO qva_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Noga Diospita shamusha Runata runacuna entregäpäcamanga chriquegnïcunapa maquinmanmi. ¡Cay ningäta shumag mayapäcuy! ¡Nircur ama gongäpäcuychu!” ");
INSERT INTO qva_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Chauraga Jesús ninganta paycuna manam tantiyapäcuranchu. Paycuna tantiyananta Tayta Dios mana munaranchu. Chaynuypis chay ninganpita tapuyta manchacäriran. ");
INSERT INTO qva_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Mayganpis mas alipag ricasha cananpag canganpita fiyupa parlapäcuran. ");
INSERT INTO qva_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Chaynuy carcanganta tantiyarmi ñaupagninman Jesús juc wamrata ichrichiran. ");
INSERT INTO qva_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Nircur niran: “Nogapa jutïchru cay wamrata chrasquegcäga nogatam chrasquiycäman y nogata chrasquimagcäga cachramagnïtapis chrasquiycanmi. Chaymi pï maypis mana runatucogcag mas alipag ricasha canga”. ");
INSERT INTO qva_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Chauraga discïpulun Juan niran: “Maestro, nogacuna ricapäcushcä juc runata gampa munayninwan diablucunata garguycagta. Noganchiwan mana pureg captinmi amachäpäcushcä”. ");
INSERT INTO qva_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Chauraga Jesús niran: “Ama amachäpäcuychu. Pipis contranchi mana carga favurninchim caycan”. ");
INSERT INTO qva_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Cieluman cuticunanpäna junagcuna chrayaycämuptinnam ima pasananpag captinpis Jerusalenman Jesús aywaran. ");
INSERT INTO qva_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Aywaycarnam runacunata cachracuran Samaria provinciachru cag juc marcaman, chaychru pachacärinanpag wasi asheg. ");
INSERT INTO qva_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Chauraga chay marcachru runacuna Jerusalenpa aywaycanganta musyar chrasquicuyta manam munapäcuranchu. ");
INSERT INTO qva_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Chaynuy mana chrasquicäriptinmi Santiaguwan Juan nipäcuran: “¿Elías rugacungannuy Tayta Diosta rugacärïmanchu cielupita shamog ninawan cay runacunata ushacächinanpag?” ");
INSERT INTO qva_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Chauraga paycunata Jesús piñaparan caynuy nir: “Gamcuna mana musyanquichu chaynuypa nipäcunayquipag pï yarpaycachishungayquitapis. ");
INSERT INTO qva_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Manam runacunata ushacächinäpächu cay pachaman noga Diospita shamusha Runa shamushcä, sinöga runacunata salvanäpämi”. Chaynuy niycur juc marcapana aywacäriran. ");
INSERT INTO qva_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Chaynuy aywarcaptinmi juc runa Jesusta niran: “Maypa aywaptiquipis gamwan purishämi”. ");
INSERT INTO qva_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Niptinmi Jesús niran: “Atogcunaga machrayniyogmi. Pishgucunapis gueshtayogmi. Noga Diospita shamusha Runapäga manam canchu maychru chrachraycunaläpäpis”. ");
INSERT INTO qva_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Chaypita juc runata Jesús niran: “Discïpulü canayquipag nogawan aywashun”. Niptin chay runa niran: “Tayta, gamwan purinanchipag puntata taytätarag pampaycamushag”. ");
INSERT INTO qva_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Chauraga Jesús niran: “Wañushacunataga waquin wañogcagcuna pampacärichun. Gam ichanga aywar Tayta Diospa munayninpita willacunqui”. ");
INSERT INTO qva_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Chaynuymi juc runapis niran: “Nogapis gamwan puriytam munä, tayta. Ichanga wasïchru cagcunatarag willaycamushag aywananchipag”. ");
INSERT INTO qva_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Chauraga Jesús niran: “Pipis guepapa ricaraycar töruwan yapyagcäga mana ali yapyagmi. Chaynuypis puntata cawangannuy cawayta munagcunaga Tayta Dios munayninman mana chrayangachu”. ");
INSERT INTO qva_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Chaypita Jesús acraran ganchris chrunca ishcay (72) discïpuluncunata. Nircur ishcayta cama cachraran aywananpag cag marcacunaman. ");
INSERT INTO qva_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Chaymi Jesús niran: “Cosëcha poguraycangannuymi Tayta Diospa willacuyninta chrasquicunanpag achca runacuna caycan. Chaynuy captinpis arogcuna walcagla cangannuy walcagla ali willacuyta willacogcunaga carcan. Chaymi cosëchapa dueñunta achca arogcunata cachramunanpag mañacognuy Tayta Diosta rugacärinayqui achca runacunata cachramunanpag ali willacuyta willacunanpag. ");
INSERT INTO qva_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Aywapäcuy. Gamcunata üshacunata atogman gaycognuymi cachraycä. ");
INSERT INTO qva_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ama apapäcunquichu guellayniquicunata, jacuyquicunata, ni llanquiquicunatapis. Piwanpis camiñuchru tincurga parlar ama tiyaräcärinquichu. ");
INSERT INTO qva_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Pipa wasinman chrayarpis wasiyogta nipäcunqui: ‘Cay wasichru ali caway cachun’. ");
INSERT INTO qva_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Chay wasiyog chrasquishuptiquega nipäcungayquinuymi paypag ali caway canga. Mana chrasquishuptiquega paypäga manam ali caway cangachu. ");
INSERT INTO qva_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Chay chrasquishogniquicunapa wasilanchru pacharäcärinqui. Garashungayquitaga imalatapis micapäcunqui. Arupacog runa arunganpita chrasquingannuymi gamcunapis willacungayquipita chrasquinquipag. Wasin wasin pachacuyta ama ashipäcunquichu. ");
INSERT INTO qva_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“May marcamanpis chrayaptiqui runacuna chrasquishuptiquega chaychru imalatapis garashungalayquita micacärinqui. ");
INSERT INTO qva_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Chay marcachru gueshyaycagcunata cuticächipäcunqui. Cuticarcachir lapan mayananpag Tayta Diospa munaynin gamcunaman chrayamungantana nipäcunqui. ");
INSERT INTO qva_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ichanga may marcamanpis chrayaptiqui runacuna mana chrasquishuptiquega cälliman yargurcur ninqui: ");
INSERT INTO qva_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Chraquïcunaman lagacag allpatapis tapsipäcü fiyu capäcungayqui musyacänanpag. Ima captinpis Tayta Diospa munaynin gamcunaman chrayamunganta musyapäcuy’. ");
INSERT INTO qva_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Gamcunata ni: Juiciu final junäga Sodoma marca runacuna castigasha canganpita chay marcachru tiyag runacuna mas fiyupam castigasha canga. ");
INSERT INTO qva_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“¡Cuyapaypämi capäcunqui, Corazín marcachru y Betsaida marcachru tiyag runacuna! Gamcunachru milagrucunata rurangänuy Tiro y Sidón marcacunachru milagrucunata ruraptïga maynam juchancunapita wanacurir Tayta Diosman yäracärinman caran. Chaynuypis juchäcunganpita laquicur cotenciapita rurasha röpata jaticärinmanmi caran. Chaynuy laquicur uchrpamanpis maynam jamacärinman caran. ");
INSERT INTO qva_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ichanga juiciu final junäga Tiro y Sidón marca runacuna castigasha canganpitapis mas fiyupam castigasha capäcunqui. ");
INSERT INTO qva_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Capernaum marcachru tiyag runacuna, ¿gamcunaga Tayta Diospa ñaupagninman chrayaytachu yarparcanqui? Chaypa truquinga wañushacuna canganmanmi gaycusham capäcunqui”. ");
INSERT INTO qva_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Chaynuy nircurmi discïpuluncunata niran: “Gamcunata mayashogniquicunaga nogatapis mayaycämanmi. Gamcunata mana chrasquicushogniquicunaga nogatapis manam chrasquimanchu. Nogata mana chrasquimagcäga Taytätapis manam chrasquicuycanchu”. ");
INSERT INTO qva_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Chaypita ganchris chrunca ishcay (72) cachrangancuna willacunganpita cushisha Jesuscagman cutipäcamuran: “¡Runacunapita diablucunata jutiquichru garguptï yargusham, tayta!” nir. ");
INSERT INTO qva_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Chauraga Jesús niran: “Au, nogapis ricashcämi cielupita räyunuy Satanás rataycämogta. ");
INSERT INTO qva_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Gamcunataga munaynïtam goshcä culebracuna, alacrancuna canishuptiquipis mana imatapis rurashunayquipag. Chaymi diablucunata garguptiquipis mana ichripäshunquipächu. ");
INSERT INTO qva_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ichanga ama cushicäriychu diablucunapa munayninta manacagman chrurar gargungayquipita. Chaypa truquinga cushicäriy jutiquicuna cieluchru escribiraycanganpita”. ");
INSERT INTO qva_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Chaychru Santu Espiritupa munayninwan cushicurmi Tayta Diosninchita Jesús niran: “Cieluchrüpis y cay pachachrüpis munayniyog caycag Taytä, gamta alabä pacarächingayquicunata yachragcunata manam musyachingayquipitam. Chaypa truquinga mana yachragcunatam musyachishcanqui. Tayta, chaynuy cananta gammi munashcanqui”. ");
INSERT INTO qva_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Chaynuypis Jesús niran: “Taytämi lapantapis munaynïman chruramusha. Noga imanuy cangätapis shumäga Taytalämi musyan. Chaynuy pay imanuy cangantapis nogala shumag musyä y musyachingäcagcunalam musyapäcun”. ");
INSERT INTO qva_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Chaypitam discïpuluncunata niran: “Ricaycangayquita ricagcunaga cushisha cachun. ");
INSERT INTO qva_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Gamcunata nï: Diospa unay willacognincuna y unay reycuna gamcuna ricarcangayquita ricaytam munapäcuran. Ichanga ricayta munarpis manam ricapäcuranchu. Chaynuypis mayarcangayquita mayayta munarpis manam mayapäcuranchu”. ");
INSERT INTO qva_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Juc cutinchrümi Moisés escribingan leycunata yachracheg runa lutanta rimachiyta munar Jesusta tapuran: “Maestro, ¿imatatag ruräman mana ushacaypa cawayta chrasquinäpag?” ");
INSERT INTO qva_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Chaynuy niptin Jesús niran: “¿Imatatag tantiyanqui Tayta Dios escribichingan libruta liyir?” ");
INSERT INTO qva_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Chauraga chay yachrag runa niran: “Cieluman runa aywananpäga Tayta Dios escribichinganchru caynuymi niycan: ‘Tayta Diosniquita lapan shonguyquipa, lapan callpayquiwan y lapan yarpayniquiwan cuyay. Lapan shonguyquipa Tayta Dios munanganta ruranayquipag imaypis yarpachracäriy. Y quiquiqui cuydacungayquinuy runamasiquitapis cuyay’ ”. ");
INSERT INTO qva_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Chaynuy niptin Jesús niran: “Alitam nishcanqui. Chay ningayquicunata rurarga mana ushacaypa cawanqui”. ");
INSERT INTO qva_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Chaynuy niptinmi chay yachrag runa alipag ricananta munar Jesusta yapay tapuran: “Runamasïta cuyarga ¿maygantatag cuyapäman?” ");
INSERT INTO qva_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Chauraga Jesús caynuy willaparan: “Juc runa aywaycaran Jerusalenpita Jericó marcaman. Aywaycaptin suwacuna payta magapäcuran. Nircur jatirangan röpanta y guepintapis guechrurir wañushatanuy jaguiriycur aywacäriran. ");
INSERT INTO qva_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Chay camiñupa aywaycaran juc cüra. Chaychru wañushanuy jitaraycagta ricaycarpis mana ricagtucular pasacuran. ");
INSERT INTO qva_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Chaypita cürapa sacristanninpis runa jitaraycangancagman chrayaran. Paypis mana ricagtucular pasacuran. ");
INSERT INTO qva_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Samaria runapis chay camiñupa aywamuran. Israel runacuna Samaria runacunawan chriquinacuycarpis chay Samaria runa ichanga chaynuy jitaraycagta ricaycur cuyaparan. ");
INSERT INTO qva_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Chaymi aceitiwan y vïnuwan jampircur träpucunawan wataparan. Nircurna quiquin logarangan bürrunman logarcachir pachacuna wasiman aparan chaychru shumag jampinanpag. ");
INSERT INTO qva_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Chaypita warantin tuta chay cuyapag runa aywacuran. Aywacurna wasiyogta pägaran ishcay junag arur gänangantanuy: ‘Gueshyagnïta ricapaycälanqui, tayta. Masta gastaptiquipis cutimurnam pägaläshayqui’ nir”. ");
INSERT INTO qva_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jesús chaynuy willapayta usharcur chay yachrag runata tapuran: “¿Chay quimsan runacunapita maygancagtag suwacuna magapäcungan jitaraycag runamasinta cuyaparan?” ");
INSERT INTO qva_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Chaynuy niptin chay yachrag runa niran: “Cuyapäcog runam, tayta”. Chaymi Jesús niran: “Chauraga gampis chay runanuyla runamasiquita cuyapar yanapay”. ");
INSERT INTO qva_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Chaypita discïpuluncunawan Jesús aywar chrayaran juc tacsha marcaman. Chaychrümi Marta jutiyog warmipa wasinman Jesús chrayaptin payta chrasquicuran. ");
INSERT INTO qva_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martapa ñañan María, Jesús yachrachingancunata mayayta munarmi, Jesuspa ñaupagninman tiyacuycuran. ");
INSERT INTO qva_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martam ichanga wasichru ruraynincunata ruraycaran. Chaymi achca ruraynincuna captin Jesusta niran: “¿Manachu yarpachracunqui ruraynïcunata ñañä quiquiläta jaguiparimanganta? ¡Niyculay yanapämänanpag, tayta!” ");
INSERT INTO qva_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Chaymi Jesús niran: “Marta, gam rurayniquicunalapämi aläpa yarpachracuycanqui. ");
INSERT INTO qva_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Chaypa truquinga Tayta Dios ningancunata yachracunayquipag mas yarpachracunquiman. Mariam ichanga ali yarpayniyog car yachrachingäcunata mayaycäman. Chaynuy yachracunantaga manam pipis amachanmanchu”. ");
INSERT INTO qva_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Chaypita juc cutinchrümi Tayta Diosta Jesús rugacuycaran. Rugacuyta usharcuptin jucnincag discïpulun Jesusta niran: “Juan Bautista discïpuluncunata yachrachingannuy nogacunatapis Diosta rugacärinäpag yachraycärichilämay”. ");
INSERT INTO qva_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Chauraga Jesús niran: “Tayta Diosta rugacur caynuymi nipäcunayqui: ‘Cieluchru caycag Tayta Diosnï, gamta lapan shumag ricayculäshunqui. Lapanpis gampa munayniquichru cawapäcuchun. Cieluchru munangayqui ruracangannuy cay pachachrüpis ruracayculächun. ");
INSERT INTO qva_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Waran waran micapäcunäpag goycärilämay. ");
INSERT INTO qva_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mana ali ruramagnïcunata perdunäpäcuptï juchäcungäcunapitapis perdunaycärilämay. Juchäcuyman ama cachrariycärilämaychu. Chaypa truquinga chapaycärilämay Satanás juchäcachipäcamänanpita’ ”. ");
INSERT INTO qva_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nircur Diosta imaypis rugacunapag Jesús caynuy willaparan: “Juc runa pulan pagas höra amïgunpa wasinman aywaran: ‘Amïgo, quimsa tantayquita mañacushayqui. ");
INSERT INTO qva_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Juc amïgümi wasïman pachacamusha. Manam imaläpis canchu garaycunäpag’. ");
INSERT INTO qva_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Chaynuy rugacuptin amïgun nimuran: ‘Ama fastidiamaychu. Puertäpis trancashanam. Noga wamräcunapis cämachrünam caycä. Mananam sharcamümannachu tantata gonäpag’. ");
INSERT INTO qva_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Gamcunata nï: Amïgun caycar sharcamuyta mana munarpis yapar yaparir mañacuptinga gongam. ");
INSERT INTO qva_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Gamcunata nï: Mañacäriptiqui Tayta Dios goshunquim. Imatapis ashir taripäcunquim. Puncuta tacacuptiqui quichrapäshunquim. ");
INSERT INTO qva_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mañacogcäga chrasquin. Ashegcäga tarin. Puncuta tacacuptinga quichrapasham canga. ");
INSERT INTO qva_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Maygayquitapis wamrayqui pescäduta mañacushuptiqui ¿culebrata gonquimanchurag? ");
INSERT INTO qva_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Chaynuypis runtuta mañacushuptiqui ¿alacranta gonquimanchurag? ");
INSERT INTO qva_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mayjina fiyu carpis ¿manachu wamrayquicunata alicagta gopäcunqui? Gamcunapis wamrayquicunata chaynuy gorcaptiquega cieluchru Taytayqui mañacäriptiqui Santu Espirituta masrämi gopäcushunqui”. ");
INSERT INTO qva_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Juc cutinchrümi müdu runapita diabluta Jesús garguran. Diablo aywacuruptinnam chay runa parlayta galaycuran. Chayta ricaycur waquin runacuna almirasha ricacuran. ");
INSERT INTO qva_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Chauraga waquincag runacunanam nipäcuran: “Diablucunapa quiquin mandagnin Satanasmi Jesusta munayninta gosha diablucunata gargunanpag”. ");
INSERT INTO qva_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Lutanta rurachiyta munar waquinnam Jesusta nipäcuran: “Tayta Diosninchi rasunpa cachramushungayquita musyapäcunäpag, mä, juc milagruta ruray”. ");
INSERT INTO qva_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Chauraga mana alita yarpangancunata musyar Jesús niran: “Juc nacion quiquinpura chriquinacur ushacanmi. Chaynuymi juc wasichru tiyagcunapis quiquinpura chriquinacur ushacan. ");
INSERT INTO qva_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Chaynuylam Satanaspis quiquinpura chriquinacurga ¿imanuypatag munaynin quëdanman? Gamcuna nircaycanqui diablucunata Satanaspa munayninwan gargungäta. ");
INSERT INTO qva_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Satanaspa munayninwan diablucunata garguptï ¿pipa munayninwantag gamcunapa discïpuluyquicuna diablucunata garguycan? Chay runacunam gamcunata tantiyachishunqui lutanta yarparcangayquita. ");
INSERT INTO qva_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tayta Diospa munayninwan diablucunata garguptïmi musyapäcunqui Tayta Diospa munaynin gamcunaman chrayamungantana. ");
INSERT INTO qva_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Juc callpayog runa garrutinwan wasinta täpaptin manam imantapis suwa apangachu. ");
INSERT INTO qva_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Chaynuy täpaycaptinpis paypita mas callpayog runa shamurga garrutinta guechrurirmi wasinpita imantapis apacunga. ");
INSERT INTO qva_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Mayganpis nogapa mana favurnï cäga conträmi caycan. Chaynuypis nogawan Tayta Diospag runacunata mana shuntagcäga masmi garguycan Tayta Diospita. ");
INSERT INTO qva_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Runapita diablo yargurna chaqui jircacunapa purin maychrüpis tiyananpag ashir. Mana tariycurga caynuy yarpan: ‘Cutishag maypitam yargamurä chaylaman’. ");
INSERT INTO qva_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Cutirnam tarin pichapacusha y chrurapacusha wasitanuy. ");
INSERT INTO qva_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Chaynuy caycagta tariycurmi paypita mas fiyu ganchris diablucunata shuntarcur chay runaman cutin payman yaycur tiyapäcunanpag. Chauraga chay runa unay canganpitapis mas peor ricacun”. ");
INSERT INTO qva_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesús chaynuy parlaycaptinrämi runacunapa chraupinpita juc warmi nimuran: “¡Diospa willacognin cangayquipita ima cushisharag mamayqui caycan!” ");
INSERT INTO qva_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Chaynuy niptin Jesús niran: “Mamä cushicunganpitapis mas cushisha caycan Tayta Dios ninganta chrasquicur cäsucogcuna”. ");
INSERT INTO qva_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Chaymi runacuna Jesús cangancagman shuntacaptin caynuy willaparan: “Canan wichan runacunaga fiyum capäcun. Tayta Diosninchi rasunpa cachramanganta musyapäcunanpag milagruta ruranätarämi munapäcun. Noga ima milagrutapis manam rurashächu. Ichanga Jonaswan milagru cangannuy nogawanpis captinmi Tayta Dios rasunpa cachramanganta musyapäcungapag. ");
INSERT INTO qva_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nínive runacuna ricacunanpag imanuymi Jonasta Tayta Dios ruraran, chaynuymi noga Diospita shamusha Runatapis pasachinga canan wichan runacuna ricacunanpag. ");
INSERT INTO qva_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Salomonpa yachrachicuyninta mayananpämi Sabá naciunpita pacha reina warmi Jerusalenman shamuran. Salomonpita noga mas alicag captïpis canan wichan runacunaga willacungäta manam chrasquicärinchu. Chaymi juiciu final junag reina warmi sharcamunga canan wichan runacunata contran ninanpag. ");
INSERT INTO qva_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ninivichru tiyag runacuna Tayta Diospa willacognin Jonás willacunganta mayar juchancunapita wanacurir Tayta Diostana cäsucäriran. Jonaspita mas alicag noga caycaptïpis canan wichan runacunaga willacungäta manam chrasquicärinchu. Chaymi juiciu final junag Ninivichru tiyag runacuna sharcamunga canan wichan runacunata contran ninanpag”. ");
INSERT INTO qva_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Chaypita Jesús niran: “Manam pipis achquita ratachinchu pacarächinanpag, ni cajon rurinman chruraycunanpag. Chaypa truquinga maymanpis ricacagninmanmi chruran yaycog runacunata achicyäpänanpag. ");
INSERT INTO qva_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lapanta achicyänanpag runacuna achquita sindingannuylam nogapis willacuycä lapan runacuna musyapäcunanpag. Pipis ali shonguyog cäga willacungäcunata tantiyar chrasquicärinmi. Mana ali shonguyogcagmi ichanga willacungäcunata mana tantiyar mana chrasquicärinchu. ");
INSERT INTO qva_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Waquin runacuna ‘Tayta Dios munangannuymi cawaycä’ niycarpis manam rasunpachu Tayta Dios munangannuy cawarcan. Chay runacunanuy carärinquiman. ");
INSERT INTO qva_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Willacungäcunata rasunpa chrasquicurga achquiwan lapanta ricangayquinuymi lapantapis shumag tantiyapäcunqui”. ");
INSERT INTO qva_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesús parlayta usharcuptinnam juc fariseo runa pusharan wasinchru micapäcunanpag. Chrayaycurmi mësacagman Jesús jamacuran. ");
INSERT INTO qva_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Micunanpag manam maquinta mayllacuranchu fariseo runacunapa costumbrin cangannuyga. Chaymi pushag fariseo runa mayacasha Jesusta ricapaycaran. ");
INSERT INTO qva_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Chaymi Jesús niran: “Gamcunaga pusillupa y plätupa jananta mayllar rurinta mana mayllagnuymi carcanqui. Chaymi pusillupa y plätupa rurinchru ganra cangannuy suwa cangayqui y juchacunata rurangayqui shonguyquichru caycan. ");
INSERT INTO qva_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Mana tantiyacogcuna! ¿Manachu musyanqui Tayta Dios cuerpuyquita camar shonguyquitapis ruranganta? ");
INSERT INTO qva_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Gamcunaga pobricunata yanapay. Chaynuy ruraptiquirämi pusillupa rurin mayllasha cangannuy shonguyquipis Tayta Diospag ali canga. ");
INSERT INTO qva_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“¡Fariseucuna, cuyapaypämi capäcunqui! Gamcuna yerbabuenapita, rüdapita, lapan micunacag jachracunapita Tayta Diospag diezmuta raquircanqui. Chaynuy rurarpis runamasiquiwan mana shumag cawapäcunquichu ni Tayta Diosta cuyapäcunquichu. Chay mandamientucunata imaypis rurapäcunquiman. Chayta rurar diezmutapis mana gongaypa raquipäcunquiman. ");
INSERT INTO qva_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“¡Fariseucuna, cuyapaypämi capäcunqui! Shuntacänan wasicunachru alinnin bancumanrag jamacuyta munapäcunqui. Chaynuypis pläzachru pipis respëtuwan saludänanta gamcuna munapäcunqui. ");
INSERT INTO qva_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“¡Cuyapaypämi capäcunqui! Runa wañusha pamparaycag mana musyacagnuymi carcanqui. Mana musyarpis runacuna chay pamparangan jananpa purircan”. ");
INSERT INTO qva_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Chayta mayar Moisés escribingan leycunata yachrachegpis niran: “Chaynuy nirga nogacunatapis gayaparcämanquim, maestro”. ");
INSERT INTO qva_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Niptin Jesús niran: “¡Moisés escribingan leycunata yachrachegcuna, chaynuylam gamcunapis cuyapaypämi capäcunqui! Yachrachir gamcunaga leypa jananman masta mastam yapaycanqui. Chaymi caycan fiyupa lasagta guepircur runamasincunata apachingayquinuy. Quiquiquicuna ichanga manam ni juc dëdulayquiwanpis yanapanquichu. ");
INSERT INTO qva_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“¡Cuyapaypämi capäcunqui! Unay cag awilluyquicuna wañuchingan Diospa willacognincuna pamparangan jananchru gamcunaga nïchuncunata rurarcanqui. ");
INSERT INTO qva_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Paycuna Diospa willacognincunata wañuchiran y gamcunaga nïchuncunata rurarcan. Chaynuy rurar gamcuna runacunata musyachinqui awilluyquicuna paycunata wañuchinganta. Chaynuypis ‘Alita rurapäcuran wañuchinanpag’ negnuymi carcanqui. ");
INSERT INTO qva_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Chaynuy captinmi Tayta Diospa Yachragnin niran: ‘Cachramushag willacognïcunata y apostulnïcunatapis. Waquincunatam wañuchipäcunga y waquincagcunatanam rabyapäpäcunga’. ");
INSERT INTO qva_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Chaymi cay pacha camag pachapita lapan Tayta Diospa willacognincunapa yawarnin jichranganpita canan wichan runacunaman castïgo chrayamunga. ");
INSERT INTO qva_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Chay jichrasha yawar caycan Abelta wañuchingan pachapita asta Zacariasta wañuchingancama. Zacariasmi wañuchisha caran altarpawan templupa chraupinchru. Gamcunata nï: Chaynuy rurapäcunganpita canan wichan runacunapämi chay castïgo canga”. ");
INSERT INTO qva_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“¡Cuyapaypämi capäcunqui, Moisés escribingan leycunata yachrachegcuna! Wasiman pipis mana yaycunanpag llävita charicuycognuymi runacunata amacharcanqui Tayta Dios escribichinganta mana yachracärinanpag. Chaynuylam quiquiquicunapis Tayta Dios escribichinganta mana yachracärinquichu”. ");
INSERT INTO qva_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Chaynuy niptin Dios escribichinganta yachrachegcunawan fariseucuna rabyacarcäriran. Chaypitana Jesusta chriquir tapupäcuran, imatapis mana alita rimachiyta munapäcur. ");
INSERT INTO qva_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Jesús chaynuy parlaycaptinmi waranganpa runacuna wasi puncuman llimi llimirag shuntacäpäcuran. Chauraga discïpuluncunalata Jesús niran: “Fariseo runacunapa levadüranpita cuydacärinqui. Paycuna yachragtucog cangannuy mana yachragtucärinquichu. ");
INSERT INTO qva_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Mana musyasha cagcuna musyacangam y pacarasha cagcunapis musyacangam. ");
INSERT INTO qva_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Chaynuymi gamcuna pacaypa parlapäcungayquicunapis mayacanga. Puertata wichrgarcur pacaylapa parlapäcungayquipis may chaychrüpis willacunqui. ");
INSERT INTO qva_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Cuyaynïcuna, ama manchacärinquichu pipis wañuchiyta munapäcushuptiqui. Wañuchirpis chay runacuna espirituyquitaga manam wañuchingachu. ");
INSERT INTO qva_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Chaypa truquinga Tayta Dioslatam manchacärinayqui. Paymi munayniyog wañuchishunayquipag y infiernuman gaycushunayquipag. Paytam ichanga rasunpa manchacärinquimanga. ");
INSERT INTO qva_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Runacuna ishcay pishgucunata walca guellaylachru ranticärin. Chaynuy captinpis Dios manam gonganchu ni juclaylatapis. Pishgucunatapis chaynuy ricaycarga gamcunataga masrämi Tayta Dios ricaycäshunqui. ");
INSERT INTO qva_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Chaynuypis paypäga agchayquicunapis yupashalam caycan. Chaymi gamcuna mana manchacärinayquichu. Gamcuna achca pishgucunapitapis masmi välipäcunqui. ");
INSERT INTO qva_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Gamcunata nï: Runacunapa ñaupagninchru pipis nogaman yäracamanganta willacuptinga Diospa angilnincunapa ñaupagninchru noga Diospita shamusha Runapis paypa favurninmi sharcushag. ");
INSERT INTO qva_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Runacunapa ñaupagninchru pipis nogaman yäracamanganta niegamaptinmi ichanga Diospa angilnincunapa ñaupagninchru noga Diospita shamusha Runapis niegashag. ");
INSERT INTO qva_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Mayganpis noga Diospita shamusha Runapa contran lutanta rimaptinga Tayta Dios perdunangam. Santu Espiritupa contran lutanta rimaptinmi ichanga Tayta Dios mana perdunangachu. ");
INSERT INTO qva_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Chaymi shuntacäpäcunan wasicunaman, juezcunaman y waquin autoridäcunaman apapäcushuptiquipis ama yarpachracärinquichu: ‘¿Imatarag nishag?’ nir. ");
INSERT INTO qva_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Chay höram Santu Espíritu yachrachishunqui imata ninayquipäpis”. ");
INSERT INTO qva_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Runacunapa chraupinpita juc runa nimuran Jesusta: “Wauguïta niycuy herenciäta raquipämänanpag, maestro”. ");
INSERT INTO qva_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Chauraga Jesús niran: “Amïgo, chaynuy nimänayquipäga manam juezniquichu ni alfasyayquichu noga cä”. ");
INSERT INTO qva_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nircur runacunata niran: “Ama malag capäcuychu. Ali cawayga manam imaycayogpis captiquirächu caycan”. ");
INSERT INTO qva_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Chaymi Jesús willaparan: “Juc rïcu runa murunganpita achcata cosecharan. ");
INSERT INTO qva_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Chauraga chay rïcu runa yarpachracuran: ‘Cananga ¿cay achca micuynïcunata maymantag chrurashag? Wasï manam jäcunnachu micuynïcunata pirwanäpag’. ");
INSERT INTO qva_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Chaynuy yarpachracuycanganchru niran: ‘Canan pirwacuna wasïta juchrurcachir jucta mas jatuncarayta sharcachishag. Nircurmi chayman lapan shuntangä micuynïcunata y imäcunatapis chrurashag. ");
INSERT INTO qva_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Chaynuy chruracuycuptïga achca watapämi micuynïcuna canga. Chaynuy chruracuycurnam micur upur cushishala cawashag’. ");
INSERT INTO qva_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Chaynuy yarpachracuycaptin Tayta Dios niran: ‘¡Mana ali yarpayniyog runa! ¡Canan chacaymi wañunqui! Lapan chrurangayquicunaga ¿pipärag canga?’ ” ");
INSERT INTO qva_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jesús chaynuy parlayta usharcurmi niran: “Chay wañog rïcu runa manacagpag cosëchanta shuntangannuymi malagcunaga wañur Tayta Diospita mana imatapis chrasquingachu”. ");
INSERT INTO qva_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Nircur discïpuluncunatapis Jesús niran: “Chauraga noga gamcunata nï: Ama yarpachracäriychu ‘¿Imatarag micushag? ¿Imatarag jaticushag?’ nir. ");
INSERT INTO qva_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mas välin cawayniqui micuypitaga y cuerpuyqui röpapitaga. ");
INSERT INTO qva_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ricapäcuy pishgucuna imanuy cawapäcungantapis. Paycunaga manam murucunchu, cosechanchu, ni pirwacunchu. Chaynuy caycaptinpis Tayta Diosmi micuyta camaripan. Chay pishgucunapitaga gamcuna Tayta Diospäga masmi välipäcunqui. ");
INSERT INTO qva_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mayjina yarpachracurpis ¿wañuy chrayamuptin pirag juc junaglapis mas cawanman? ");
INSERT INTO qva_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Chaynuy chaylatapis rurayta mana puediycarga laquicungalanwanga mana pipis taringachu röpatapis ni micuytapis. ");
INSERT INTO qva_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Tantiyacäriy chracrachru waytacuna imanuy wiñangantapis. Chaycuna manam arupäcunchu ni puchcacärinchu. Chaynuy niptinpis noga gamcunata nï: Chay waytacuna cuyaylapag cangannuyga manam rey Salomonpis rïcu cayninwan jaticungan röpancunapis cuyaylapag cashachu. ");
INSERT INTO qva_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Chracrachru canan caycag guewacuna wara rupachisha cananpag captinpis Tayta Dios guewacunata shumagmi wiñachin. ¡Janan shongula yäracog runacuna! Chaynuy guewacunatapis shumag wiñaycächirga gamcunataga masrämi röpayquicunata tarichishunqui. ");
INSERT INTO qva_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Chaymi gamcunaga mana yarpachracärinayquichu imata micapäcunayquipag ni imata upupäcunayquipäpis. ");
INSERT INTO qva_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Mana Israel casta lapan runacunam yarpachracärin chaycuna cananpag. Cieluchru Taytayquega musyanmi ima pishïshungayquitapis. ");
INSERT INTO qva_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Imapäpis yarpachracunayquipa truquinga Tayta Diospa munayninchru cawayta yarpachracäriy. Chaynuy cawaptiquega ima pishïshungayquitapis Tayta Dios tarichishunquim”. ");
INSERT INTO qva_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Cuyaynïcuna, walcala carpis, ama laquicäriychu. Gamcunatam Tayta Diosniqui acrapäcushushcanqui imaycamapis paypa munayninchru cawapäcunayquipag. ");
INSERT INTO qva_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Chaynuy captinga imayquicunapitapis waquincagta ranticuycur chay guellaywan pobricunata yanapäpäcuy. Chaynuy rurarmi cieluman riquësayquita chruracognuy carcanqui. Chaychrüga manam imaypis ushacangachu, suwapis apangachu ni puyupis ushangachu. ");
INSERT INTO qva_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Imaycayquipis alicagcuna caycagman yarpayniqui imaypis canga. ");
INSERT INTO qva_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Camaricusha mayag mayagla achquinwan carcay noga cutimuptï chrasquicärimänayquipag. Patrunnin casaracuy fiestapita cutimunanta shuwararcag uywaycunanuyla nogatapis shuwaräpäcamay. Puertata jucla quichrapänanpag chay uywaynincuna shuwaranga. ");
INSERT INTO qva_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Chaynuy patrunta shuwaragcunapäga pasaypa cushicuymi canga. Rasunpam gamcunata nï: Paycunata mësaman jamaycachir quiquinmi sirvinga. ");
INSERT INTO qva_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ima hörapis cutimungam: pulan pagas o wallpa wagay hörapis. Mayag mayagla cutimunanta shuwararcänan. Chaynuy carcagta tariptinmi pasaypa cushicuy paycunapag canga. ");
INSERT INTO qva_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Musyapäcungayquinuypis suwa ima höra yaycunanta musyarga wasiyog mayag mayaglam canman wasinman pitapis mana yaycachinanpag. ");
INSERT INTO qva_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Chaynuy gamcunapis mayag mayagla camaricusha carcay. Noga Diospita shamusha Runaga mana yarpangayqui höram cutimushag”. ");
INSERT INTO qva_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Chauraga Pedro tapuran: “Tayta, chaynuy yachrachingayquega ¿nogacunalapächu o lapan runacunapäwanchu?” ");
INSERT INTO qva_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Niptin Señor Jesús niran: “Patron illänanpäga yäracungan y shumag yachrag uywayninpa munayninmanmi waquincag uywayninta garananpag chruran. ");
INSERT INTO qva_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Cushicungam chay uyway lapan rurananpag ningancunata ruraycagta patrunnin tariptinga. ");
INSERT INTO qva_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Rasunpam gamcunata nï: Chaynuy alita ruranganpita patrunnin chay uywaypa munayninman chruranga lapan imaycantapis ricananpag. ");
INSERT INTO qva_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ichanga uyway ‘Patrunnï manarämi cutimungarächu’ nir munayninchru caycag runacunata y warmicunata magayta galaycuycan y micuyta, upyacuyta y machrayta galaycun. ");
INSERT INTO qva_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Chaynuy caycaptin mana yarpangan junag y mana musyangan höra patrunnin cutimunga. Cutimurna patrunnin mana cuyapaypa castiganga y mana yäracungan cagcuna castïguchru caycanganman chay uywaytapis chruranga. ");
INSERT INTO qva_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","48","“Mana musyayninpa juc uyway mana alita ruraptinga patrunnin manam aläpachu castiganga. Ichanga patrunnin ninganta musyaycar mana mayacuypa mana camaricusha captin y lutanta ruraptin patrunnin fiyupa castiganga. Chauraga pipis achcata chrasquegcagtaga Diosmi mas cuentata mañanga. ");
INSERT INTO qva_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Cay pachaman noga shamushcä chrasquicamagcuna salvasha cananpag y mana chrasquicamagcuna juzgasha cananpämi. ¡Maynapis galaycunmanna! ");
INSERT INTO qva_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Chaynuy cananpäga fiyupa nacarcachimar-rämi chriquimagnïcuna wañuchipäcamanga. Lapanpis manarag cumpliptinmi fiyupa laquicuycä. ");
INSERT INTO qva_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“¿Yarpäpäcuychu cay pachachru runacuna jauca cawananpag shamungäta? Gamcunata nï: Manam. Noga shamushcä ishcayman runacunata raquinäpämi. ");
INSERT INTO qva_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Cananpitaga juc wasichru pichga tiyarga quimsacagmi ishcaycagta chriquinga y ishcaycagmi quimsacagta chriquinga. ");
INSERT INTO qva_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Chaynuy carmi juc wasichru chriquinacäringa. Taytan chriquinga olgu wamranta y wamranna chriquinga taytanta. Maman chriquinga warmi wamranta y wamranna chriquinga mamanta. Suedran chriquinga lumchuyninta y lumchuynin chriquinga suedranta”. ");
INSERT INTO qva_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Chaymi Jesús niran runacunata: “Inti yaycunancagpa pucutay ricacämuptinga jucla nipäcunqui ‘Tamyananpag canganta’, y nipäcungayquinuylam tamyan. ");
INSERT INTO qva_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Inti yargamunancag derëchacag lädupita wayra shamuptinga ‘Fiyupam shananga’ nipäcunqui, y nipäcungayquinuylam shanan. ");
INSERT INTO qva_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Mana tantiyacogcuna! Cieluta ricar y cay pachata ricar imanuy cananpag cangantapis musyaycarga ¿imanirtag mana tantiyapäcunquichu canan wichan ima pasaycangantapis? ");
INSERT INTO qva_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“¿Imanirtag quiquiquicuna mana juzgapäcunquichu alicagcunata? ");
INSERT INTO qva_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Pipis quejacushuptiquega autoridäman manarag chrayalar arregläpäcuy. Mana arreglaptiquega juezmanmi apachishunqui. Chauraga jueznam wardiacunawan carcilman wichrgachishunqui. ");
INSERT INTO qva_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Gamcunata nï: Chaypitaga yargamunqui lapan jaganta shumag pägapacurir-rämi”. ");
INSERT INTO qva_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Chay höram runacuna Jesusta willaran: “¡Galilea runacuna templuchru Diospag uywacunata pishtarcaptinmi soldäduncunata Piläto mandaran chay runacunata wañuchinanpag!” ");
INSERT INTO qva_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Chauraga Jesús niran: “Wañuchisha capäcuptin ama yarpäpäcuychu waquin Galilea runacunapita chay wañog runacuna mas juchayog canganta. ");
INSERT INTO qva_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Manam Tayta Diospa castïgunwanchu paycuna chaynuy wañusha. Gamcunam ichanga juchayquicunapita mana wanacurga Tayta Diospa castïgunwan infiernuchru nacapäcunqui. ");
INSERT INTO qva_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Chaynuypis Siloé ninganchru törre juchrur chrunca pusag (18) runacunata wañuchiran. Chauraga ama yarpäpäcuychu Jerusalenchru tiyag waquin runacunapita chay wañog runacuna mas juchayog canganta. ");
INSERT INTO qva_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Manam Tayta Diospa castïgunwanchu paycunapis chaynuy wañusha. Gamcunam ichanga juchayquicunapita mana wanacurga Tayta Diospa castïgunwan infiernuchru nacapäcunqui”. ");
INSERT INTO qva_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Chaymi mana cäsucog runata mana wayog hïgusman tincuchiypa Jesús niran: “Juc runapa chracranchrümi caran hïgus. Chay hïgus yüra cangancagman aywar mana tariranchu juc hïguslatapis. ");
INSERT INTO qva_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Chauraga niran chracran arogta: ‘Quimsa watanam shamü cay yürapita hïgus palag y manam ni juclaylatapis tarishcächu. Cuchurir cay chracrapita jucla jitariy. Mana wayogtaga ¿imapätag manacagpäga chracrachrüpis chararäshun?’ ");
INSERT INTO qva_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Chaynuy niptin chracran arog niran: ‘Shuwaycushun juc wata mas, tayta. Chrulpata gaycuycur-rag uryashag. ");
INSERT INTO qva_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Chaynuy ruraptïga pagta wayunmanpis. Chaychru mana wayuptinga ichanga cuchurir jitariycushunpag’ ”. ");
INSERT INTO qva_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Juc sábado jamay junagchrümi shuntacäpäcunan wasichru Jesús yachraycächiran. ");
INSERT INTO qva_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Chaychrümi caycaran diablo curcuyächingan warmi. Paymi derechacayta mana puediranchu. Chaynuy carmi chrunca pusag (18) watana nacaycaran. ");
INSERT INTO qva_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Chay warmita ricarmi gayaycur Jesús niran: “Cananga curcuyasha cangayquipita cuticashanam caycanqui”. ");
INSERT INTO qva_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Chaynuy nir yataycuptin chay höra cuticaran. Cuticarcurna chay warmi Tayta Diosta alabaran. ");
INSERT INTO qva_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Chauraga sábado jamay junagchru Jesús cuticächisha captin chay shuntacäpäcunan wasichru mandag rabyacuran. Chaymi runacunata niran: “Sogta junagmi caycan runacuna arunanpag. Chay junagcunachru shapäcamunqui cuticasha cayta munarga. ¡Sábado jamay junagchrüräga ama shapäcamunquichu!” ");
INSERT INTO qva_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Chauraga Jesús niran: “¡Yachragtucogcuna! Sábado jamay junag captinpis gamcunaga töruyquita bürruyquita ¿manachu pasquircur yacuta upucheg gatipäcunqui? ");
INSERT INTO qva_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Chrunca pusag (18) watanam cay warmita curcuyaycachir Satanás nacachisha. Uywayquicunatapis sábado jamay junagchru chaynuy cuyapaycaptiquega ¿manachu sábado jamay junag caycaptinpis cay Israel warmitapis cuyapashwan?” ");
INSERT INTO qva_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Chaynuy niptinmi chriquegnincuna pasaypa pengacäriran. Waquin runacunam ichanga cushicäriran ali rurangancunata ricar. ");
INSERT INTO qva_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nircur Jesús niran: “¿Imanuytag Tayta Diospa munaynin? Y Tayta Diospa munayninta ¿imamantag tincuchïman? ");
INSERT INTO qva_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Tayta Diospa munayninga huertanman juc runa ñäpuspa murunta murungannuymi caycan. Chay murungan wiñamur yüranuy chrayan. Pishgucuna shamur rämancunachrüna gueshtancunata ruran”. ");
INSERT INTO qva_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Nircur Jesús caynuypis niran: “Tayta Diospa munayninta ¿imamantag tincuchishwan? ");
INSERT INTO qva_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Tayta Diospa munayninga caycan levadüranuymi. Juc warmi quimsa tupu harinaman levadürata gaycuptin lapan mäsata jacachingannuymi Tayta Diospa munaynin may chaymanpis chrayaycan”. ");
INSERT INTO qva_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Chaypita Jerusalenpa Jesús aywarmi marcacunachru y estanciacunachrüpis runacunata yachraycächir aywaran. ");
INSERT INTO qva_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Chaychrümi juc runa tapuran: “Tayta, ¿walcaglachu salvacunga?” Chaymi Jesús niran: ");
INSERT INTO qva_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Gamcuna salvacunayquipag quichrqui puerta caycagpanuy imanuypapis yaycapäcuy. Gamcunata nï: Achcag yaycuyta munarpis chay puertapaga yaycuyta mana puedipäcungachu. ");
INSERT INTO qva_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","“Wasipa dueñun puertanta wichrgacarcamuptin gamcuna puncuchru caycagcuna caynuy nir tucacunquim: ‘Puertayquita quichrapaycalämay, tayta’. Chauraga pay nishunqui: ‘Gamcuna maypita cangayquitapis manam musyächu’. ");
INSERT INTO qva_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Chaymi gamcuna nipäcunqui: ‘¿Imanirtag maypita cangätapis manam musyanquichu? Micur upurmi puriranchi. Y marcäcunachrüpis yachraycächir purirayqui’. ");
INSERT INTO qva_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Chauraga yapaymi nishunqui: ‘Gamcuna maypita cangayquitapis manam musyächu. ¡Nogapita aywacäriy, mana ali rurag lapayqui runacuna!’ ");
INSERT INTO qva_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Tayta Dios munayninpita gamcuna yargusha car Abraham, Isaac, Jacob y Tayta Diospa willacognincunapis Diospa munayninchru caycagta ricar pasaypa wagar laquicuypita quiruyquitapis cachrupäcunqui. ");
INSERT INTO qva_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Mana Israel runacuna carpis Tayta Diospa munayninman shapäcamunga inti yargamunan lädupita inti yaycunan lädupita intëru mundupitam. Chaychrünam Diospa munayninchru micapäcungapag. ");
INSERT INTO qva_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","¡Shumag yarpachracäriy! Waquin ultimuta cagcuna puntata capäcunga. Waquinnam puntata carpis ultimuta capäcunga”. ");
INSERT INTO qva_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Chay höra waquin fariseucuna chrayaycurmi Jesusta nipäcuran: “¡Caypita aywacuy! Herodismi wañuchiyta munaycäshunqui”. ");
INSERT INTO qva_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Chauraga Jesús niran: “Chay atog nirag runata willamuy: ‘Juc ishcay junaglana diablucunata runacunapita gargushag y gueshyagcunatapis cuticächishag. Quimsacag junagna lapan ruranäpag cagcunata ushashag’. ");
INSERT INTO qva_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Canan junag, wara y warap waran aywacunä. Diospa willacogninga Jerusalenpita juc läduchru manam wañunmanchu”. ");
INSERT INTO qva_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jesús niran: “¡Jerusalén runacuna! Gamcuna Tayta Diospa willacognincunata wañuchipäcushcanqui y cachramungan cagcunata sagmapäcushcanqui. Gamcunata achca cuti shuntayta munarä chipsancunata wallpa oglacunanpag shuntangannuymi. Ichanga gamcuna mana munapäcushcanquichu. ");
INSERT INTO qva_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Marcayqui jaguirisha quëdanga. Gamcunata nï: Mananam ricapäcamanquipänachu ‘¡Tayta Diosninchi cachramungan runa alabasha cayculächun!’ nipäcungayquicama”. ");
INSERT INTO qva_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Chaypitana sábado jamay junagchru Jesús aywaran mandag fariseupa wasinman micog. Chaychru waquin fariseucuna ricararcaran Jesús imata rurananpag cagtapis. ");
INSERT INTO qva_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","3","Intëru cuerpun jacapäcuycag runata Jesús ricarmi Moisés escribingan leycunata yachrachegcunatawan fariseucunata tapuran: “Sábado jamay junagchru ¿gueshyagcunata cuticächishwanchu o manachu?” nir. ");
INSERT INTO qva_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Imatapis mana rimacäriptinmi gueshyaycag runata Jesús yataycuran cuticänanpag. Cuticarcachirna niran: “Cananga aywacuyna”. ");
INSERT INTO qva_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nircur fariseucunata niran: “Maygayquipapis sábado jamay junagchru wamrayqui o töruyqui pözuman jegarpuptin ¿manachu jucla jorgog aywanqui?” ");
INSERT INTO qva_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Chaynuy niptinpis manam imatapis rimacäriranchu. ");
INSERT INTO qva_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Chaychrümi waquin runacuna, lapanpitapis runatucur, aywapäcuran mësachru alinnincag jamacunanmanrag. Chayta ricaycur Jesús chay runacunata niran: ");
INSERT INTO qva_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","“Pipis casaracuy fiestaman gayachishuptiqui mësachru alinnincag jamacunanmanga ama jamacärinquichu. Gamcunapita mas respitädu runa chrayamuptin: ‘Chaypita ashucuy pay jamacunanpag’ nishuptiqui pengaytucusham chaychru jamaraycangayquipita ashucärinqui. ");
INSERT INTO qva_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mësachru alinnincag jamacunayquipa truquinga shuwaranqui gayachishogniqui: ‘Caylaman jamacuy’ nishunayquitarag. Chaynuy jamachishuptiquim chaychru gamwan jamaragcuna ali respitäshunqui”. ");
INSERT INTO qva_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Chaynuy nirmi Jesús niran: “Mayganpis runatucogcunaga pengaymanmi chrurasha canga. Mana runatucogcunam ichanga alipag ricasha canga”. ");
INSERT INTO qva_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nircur wasinman pushag runatapis Jesús niran: “Micapäcunayquipag pitapis gayachirga ama gayachinquichu cuyanacungayquita, wauguiquita, aylluyquita ni rïcucag vecïnuyquita. Chaynuy ruraptiquega garangayquinuylam paycunapis garashunqui. ");
INSERT INTO qva_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Chaypa truquinga gayachinqui pobricunata, macllucunata, wegrucunata y gapracunata. ");
INSERT INTO qva_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Paycunaga manam ni imanuypapis cutichishunquichu. Chaynuy rurangayquipitaga Tayta Diosmi cutichishunqui juchaynag runacuna cawarimungan junag”. ");
INSERT INTO qva_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Chaymi mësachru jamaraycanganpita Jesusta juc runa niran: “¡Ima cushisharag canga Tayta Diospa munayninchru Dios camaringan micuyta micogcuna!” ");
INSERT INTO qva_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Chaynuy niptin Jesús payta niran: “Juc runa achca runacunata willacachiran wasinman micog shapäcamunanpag. ");
INSERT INTO qva_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Chay micunan höra chrayamuptinna uywayninta cachraran micunanpag shamog runacunata ‘¡Shamuy! Micuy listunam caycan’ nir willamunanpag. ");
INSERT INTO qva_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Chay uyway willag chrayaptin jucnin niran: ‘Manam aywashächu. Rantingä chracra ricagrämi aywashag. Nogapita ama jagayayculächunchu’. ");
INSERT INTO qva_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Jucagna niran: ‘Manam aywashächu. Pichga yunta törucunatam rantishcä. Chaymi ali o mana ali arunganta musyanäpag arog aywaycä. Nogapita ama jagayayculächunchu’. ");
INSERT INTO qva_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Y mas jucagcagna niran: ‘Chayrämi majachacushcä. Chaymi mana aywashächu’. Chaynuy nir lapan gayachingan runacuna aywayta mana munaranchu. ");
INSERT INTO qva_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Chauraga chay cachrangan uyway cutiycur patrunninta willaran runacuna imanuy nipäcungantapis. Chaynuy willaptin patrunnin fiyupa rabyacuran. Nircurna uywayninta niran: ‘Cällicunapa aywaycur jucla pushamuy pobricunata, macllucunata, gapracunata y wegrucunatapis’. ");
INSERT INTO qva_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Chauraga patrunnin ninganta rurarcurna uywaynin niran: ‘Rurashcänam lapan nimangayquicunata, tayta. Nimangayquinuy pushamusha caycaptïpis mësacagman manarämi runacuna juntanrächu’. ");
INSERT INTO qva_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Chayna patrunnin niran: ‘Camiñucunapa y chracracunapapis aywarcur chaychru taringayqui runacunata imaycanuypapis pushamuy wasï juntasha cananpag. ");
INSERT INTO qva_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Puntata gayachimungäcunaga micuy rurachingäta mayganpis mananam micungachu’ ”. ");
INSERT INTO qva_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Achca runacuna gatiräpäcuptinmi Jesús niran: ");
INSERT INTO qva_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Mayganpis discïpulü cayta munarga taytanta, mamanta, warminta, wamrancunata, wauguincunata y panincunata cuyanganpita mas nogata cuyamächun. ");
INSERT INTO qva_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Discïpulücunaga wañunan captinpis noga munangänuyla imaypis cawachun. Chaynuy mana cawarga manam discïpulü canmanchu. ");
INSERT INTO qva_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Discïpulü caycanganpita yargucogcunaga wasi rurayta galaycaycachir mana ushachegnuymi carcan. Pipis wasita rurananpäga shumagrämi yarpachracärin chay wasita ushachinanpag gastun aypänanpag canganta o mana aypänanpag cangantapis. ");
INSERT INTO qva_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Cimientuta ruraycular jaguiriptinga lapan ricagcuna payta jamurpanga: ");
INSERT INTO qva_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Chay runaga puedegnuypis wasi rurayta galaycachisha mana ushachinanpag’ nir. ");
INSERT INTO qva_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Maygan naciunpis juc naciunwan manarag pelyar ¿manachu puntataga mandagnincuna shumagrag yarpachracärin chrunca waranga (10.000) soldädulanwan ishcay chrunca waranga (20.000) soldäducunata vincinanpag o mana vincinanpag cangantapis? ");
INSERT INTO qva_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Pelyayta mana puedinan captinga jucagcag mandag caruchru caycaptilanrämi willacogninta cachran: ‘Shumag arregläshun manana pelyaylapa’ nir willananpag. ");
INSERT INTO qva_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Chaynuyla maygayquipis imaycayquitapis mana jaguirirga discïpulü manam canquimanchu. ");
INSERT INTO qva_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Puchgog cachrega alim. Rumi cachri puchgog caycanganpita gamyacarurga mananam yapay puchgog cayman ticrannachu. ");
INSERT INTO qva_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Chaynuy carga mananam alinachu allpapäpis chrulpapäpis. Chaynuy captinga jitaricunnam. ¡Ningäta mayagcäga shumag tantiyacäriy!” ");
INSERT INTO qva_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Impuesto cobracogcunawan juchasapa runacunapis Jesús yachrachinganta mayapäcunanpag aywapäcuran. ");
INSERT INTO qva_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Chayta ricar fariseucunawan Moisés escribingan leycunata yachrachegcuna Jesusta jamurpar nipäcuran: “¿Imanirtag cay runaga juchasapa runacunata chrasquin y paycunawan shuntacaycur micun?” ");
INSERT INTO qva_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Chaynuy nipäcuptinmi Jesús tantiyachiran: ");
INSERT INTO qva_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Pipis pachrac (100) üshanpita jucta ograycurga ¿manachu waquincagta juc pachaman jaguiycur taringancama juc ogracasha caycagta jucla asheg aywan? ");
INSERT INTO qva_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tariycur cushisham apricurcur apacun. ");
INSERT INTO qva_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Wasinman chrayaycurnam vecïnuncunatawan reguinacungancunata shuntaycur cushisha willapan: ‘¡Ograngä üshätam tarimushcä!’ nir”. ");
INSERT INTO qva_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nircur Jesús niran: “Chay runa cushicungannuy isgun chrunca isgun (99) runacuna Tayta Dioswan ali cawagcunapag cushicäringanpita masrämi cieluchru cagcuna cushicärin juclaylapis juchasapa runa juchancunapita wanacur Diosta cäsucuptin. ");
INSERT INTO qva_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Chaynuy pï warmipis chrunca guellayninpita jucta ograycurga achquita ratarcachirmi jucla wasinta pichapacun ograngan guellayta taringancama ashinanpag. ");
INSERT INTO qva_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ashiycanganchru tariycurga vecïnancunata y reguinacungancunatapis shuntaycur cushisha willapan: ‘¡Ograngä guellaynïtam tarishcä!’ nir. ");
INSERT INTO qva_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Chaynuymi Tayta Diospa angilnincunapis cushicärin juc runalapis juchancunapita wanacur Tayta Diosta cäsucuptin”. ");
INSERT INTO qva_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Mastapis Jesús niran: “Juc runapa ishcay olgu wamrancuna caran. ");
INSERT INTO qva_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Shulcacag wamran papäninta niran: ‘Papä, herenciäta gomänayquipag cagcunata raquipaycamayna’. Chaynuy niptin papänin ishcan wamranta raquipaycuran. ");
INSERT INTO qva_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Chaypita juc ishcay junaglatana shulcacag wamran lapan chrasquingancunata ranticuycuran. Nircur chay guellaywan aywacuran caru marcaman. Chaychrüna munanganta rurar lapan guellayninta manacagcunachru usharan. ");
INSERT INTO qva_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Guellayninta ushangalantana chay marcachru muchruy galaycuran y chay mösu micanayta galaycuran. ");
INSERT INTO qva_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Chauraga chaychru cag runaman arupacuyta asheg aywaran. Chay runa chracranchru cuchinta michinanpag chrasquiran. ");
INSERT INTO qva_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Cuchita michirna pasaypa micanar cuchita garangantapis micuyta munaran. Chaynuy micanaptinpis micuy mana captin pipis mana gararanchu. ");
INSERT INTO qva_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Chauraga yarpachracuran: ‘Papänïpa uywaynincunaga sacsagpag micushachrar carcan, noga caychru micanaypita wañuycaptï. ");
INSERT INTO qva_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Caynuy micanar canäpag truquinga papänïcagpa cuticushag. Chrayaycurga caynuymi nishag: Papä, perdunaycalämay. Gomangayquicunata manacagchru ushar juchäcushcämi. Manam gam munangayquinuychu ni Tayta Dios munangannuychu rurashcä. ");
INSERT INTO qva_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Cananpitaga wamrayquitanuynaga ama ricamaychu; sinöga uywayniquitanuylana ricamay’. ");
INSERT INTO qva_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Chaynuy yarpachracurirna papänincagpa cuticuran. “Chaymi carulatarag aywaycämogta ricaycur papänin cushicur cörrila aywaycur abrazacurcuran. ");
INSERT INTO qva_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Chay wamran niran: ‘¡Perdunaycalämay, papä! Gomangayquicunata manacagchru ushar juchäcushcämi. Manam gam munangayquinuychu ni Tayta Dios munangannuychu rurashcä. Cananpitaga ama wamrayquitanuy ricamaychu, sinöga uywayniquitanuyla ricamay’. ");
INSERT INTO qva_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Chaynuy niycaptinpis papänin uywaynincunata niran: ‘Mas alicag röpata jucla jorgapäcamuy trucacunanpag. Chaynuypis sortïjata y zapatuta jaticunanpag jorgapäcamuy. ");
INSERT INTO qva_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nircur werannin turituta pishtapäcuy fiestata rurananchipag. ");
INSERT INTO qva_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","¡Cay wamräga wañunganpita cawarimungannuymi! ¡Ogracashanuy canganpitam cutimusha!’ Chaynuy nir cushicuypita fiestata rurapäcuran. ");
INSERT INTO qva_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Chaycamaga mayurcag wamran chracrachru caycaran. Chaypita cutimur wasiman chrayaycarna wasinchru fiesta caycagta mayaran. ");
INSERT INTO qva_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Chauraga juc uywayninta gayaycur tapuran wasinchru imata rurarcangantapis. ");
INSERT INTO qva_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tapuptin uywaynin niran: ‘Wauguiquim cutimusha. Chaymi papäniqui pishtachisha werannin turituta wauguiqui ali cutimunganpita cushicur’. ");
INSERT INTO qva_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Chaynuy willaptin fiyupa rabyar wasinman yaycuyta mana munaranchu. Chauraga papänin aywaycur rugaran wasiman yaycunanpag. ");
INSERT INTO qva_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Chauraga papäninta niran: ‘Gam musyangayquinuypis achca watanam mana yarguypam gamta yanapaycä lapan nimangayquicunata rurar. Chaynuy yanapaycaptï manam imaypis nogata gomashcanquichu ni juc cabralatapis amïgücunawan fiestata rurar micapäcunäpag. ");
INSERT INTO qva_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","¡Cay wamrayqui mañösa warmicunawan guellayniquita usharcur cutiycamuptinmi ichanga pishtachishcanqui werannin turituta!’ ");
INSERT INTO qva_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Chauraga taytan niran: ‘¡Au! Gamga mana yargucuypam nogawan caycanqui. Chaymi lapan imaycäcunapis gamlapäna caycan. ");
INSERT INTO qva_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Cay wauguiqui wañushanuy canganpitam cawarimusha. Ogracashanuy canganpitam cutimusha. Chaynuy caycaptinga fiestata rurar cushicushun’ ”. ");
INSERT INTO qva_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Chaymi discïpuluncunata Jesús willaparan: “Juc uywayninta patrunnin chruraran imaycanpäpis munayniyog cananpag. Chaypitana chay patrunta runacuna willaran imaycancunatapis yangajina rurar chay uywaynin ushaycanganta. ");
INSERT INTO qva_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Chayta musyaycurna patrunnin gayachimuran. Nircurna niran: ‘Runacuna gampag rimapäcun imaycäcunatapis yangajina ushaycangayquitam. Cananga willamay lapan imata rurangayquitapis. Cananpitaga mananam imaycäcunapäpis munayniyognachu canquipag’. ");
INSERT INTO qva_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Chauraga chay runa yarpachracuran: ‘¿Imatarag canan rurashag patrunnï gargamaptinga? Manam callpä canchu chracrachru arunäpag. Limusnata mañacuytapis pengacümi. ");
INSERT INTO qva_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Patrunnï gargamaptin runacuna chrasquimänanpag ¡cananga caynuy rurashag!’ ");
INSERT INTO qva_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Chaynuy yarpachracurir patrunninpa jagancag runacunata juc jucla gayaycachimur puntacagta tapuran: ‘¿Aycatag patrunnïpa jagan caycanqui?’ ");
INSERT INTO qva_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Chaynuy tapuptin niran: ‘Paypa jagan caycä ishcay pachrac (200) läta aceitim’. Chauraga chay runa niran: ‘Caychru caycan päganayquipag cag väli. ¡Jamacuy! Canan höra juc välita ruray pachrac (100) läta aceitilatana päganayquipag’. ");
INSERT INTO qva_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Chaypita jucnincagtana tapuran: ‘Gamga ¿aycatag jagan caycanqui?’ Chay runa niran: ‘Paypa jagan caycä ishcay waranga (2.000) arröba trïgum’. Chaynuy niptin niran: ‘Canan escribishun waranga pichga pachrac (1.500) arröba trïgulatana päganayquipag’. ");
INSERT INTO qva_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Chaynuy uyway ruranganta musyaycur patrunga alabar niran: ‘Chay runaga mana alita rurarpis shumag yarpaysapam quiquin alichu cananpäga’ nir”. Chaynuy willaparcur Jesús niran: “Tayta Diosman mana yäracogcunaga yachranmi quiquin ali cawananpag runamasinwan amistä rurayta. Tayta Diosman yäracogcunapitaga masmi quiquinpag imatapis ashiyta yachran. ");
INSERT INTO qva_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Gamcunaga cay pachachru lapan taringayqui guellayta ushay amïgucunata ashir yanapar. Chaynuypam cieluman aywaptiqui Tayta Diosga mana ushacag ali cawayta tarichishunquipag. ");
INSERT INTO qva_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Walcalata charangayquiwan runamasiquita yanaparga achcata chararpis yanapanquipämi. Mana yanapäcog carga achcata chararpis manam yanapanquipächu. ");
INSERT INTO qva_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Cay pachachru ushacagla cagtapis mana shumag cuydaycaptiquega ¿Tayta Dios yäracushunquimanchurag cieluchru fiyupa ali cagta? ");
INSERT INTO qva_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Jucpa imantapis maquiquichru caycagta ushacurcuptiquega ¿Tayta Dios yäracushunquimanchurag töcashunayquipag cagta goycushunayquipag? ");
INSERT INTO qva_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Manam maygan uywaypis ishcay patron mandanganta ruranmanchu. Ishcay patrunniyog carga jucnincagta cuyanga y jucnincagtana rabyapanga. Jucnincagta cäsur shumag ruranga y jucnincagtana mana alipag ricanga. Chaynuylam guellaylapag yarparagcunaga Tayta Dios mandanganta mana rurapäcunchu”. ");
INSERT INTO qva_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Chay yachrachingancunata mayaycurmi fariseucuna, guellaylapag wañur, Jesusta asipäpäcuran. ");
INSERT INTO qva_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Chauraga Jesús niran: “Gamcuna runacunapa ñaupagninchru ali tucäriptiquipis Tayta Dios musyanmi gamcunapa shonguyqui imanuy cangantapis. Chaymi imanuypis cangayquita mana musyar runacuna respitäshuptiquipis Tayta Diospäga chay ali tucungayquicuna mana ali caycan. ");
INSERT INTO qva_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Juan Bautista willacuyta galaycungancamam Moisés y Tayta Diospa willacognincuna escribingancuna carcan. Cananga Tayta Diospa munayninpita willacuyta willacuycan. Juan Bautista willacunganpitaga lapanmi Tayta Diospa munayninchru imanuypapis yaycuyta munarcan. ");
INSERT INTO qva_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Imanuy captinpis Moisés y Tayta Diospa willacognincuna escribingancunaga cumplingam. Cay pacha y cielo ushacaptinpis lapanmi cumplinga. ");
INSERT INTO qva_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Pipis warminpita raquicarga juc warmiwan majachacarga adulterio juchata ruraycan. Chaynuypis runapita raquicasha warmiwan pipis majachacurga runacagmi adulterio juchatam ruraycan”. ");
INSERT INTO qva_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Chaypitana Jesús caynuy willaparan: “Juc rïcu runa caran ali röpacunalata jaticog. Chaynuypis waran waran amïguncunawan fiestata rurar ali micuycunalata micapäcog. ");
INSERT INTO qva_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Chay rïcu runapa wasin puncuchru juc pobre runa Lázaro jutiyog jamararan. Lazarupa intëru cuerpunta gueri ushaycaran. ");
INSERT INTO qva_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Pay rïcu runapa mësanpita micuy shicwagtapis micuyta munaran. Y chaychru algucunapis Lazarupa guerinta llagwaparan. ");
INSERT INTO qva_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Lázaro wañuruptinna angilcuna apapäcuran Abraham caycangancagman. Y rïcu runa wañurcuptinna aylluncuna pampapäcuran. ");
INSERT INTO qva_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","“Chaypitana rïcu runapa alman nacaran wañushacuna canganchru. Chay nacaycanganchru carupita ricaran Lazaruta Abrahampa lädunchru caycagta. ");
INSERT INTO qva_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Chauraga rïcu runa gayacuran: ‘Tayta Abraham, cuyapaycalämay. Lazaruta cachraycalämuy dëdunta ushmarcachir shimïta ushmachipämänanpag. Fiyupam nacaycä cay ninachru rupar’. ");
INSERT INTO qva_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Chaynuy niptin Abraham niran: ‘Yarpay gam imaycayogpis car ali cawangayquita. Lazarunam ichanga pobre car fiyupa nacaran. Chaymi cananga pay cushisha caychru caycan y gamna chaychru nacaycanqui. ");
INSERT INTO qva_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Chaynuypis jatuncaray wanwanyaycag ragram raquiycämanchi. Chaymi gam cangayquicagman pipis pasamuyta munarpis mana puedinchu. Chaynuy gampis mana puedimunquichu noga caycangäcagman pasamuyta’. ");
INSERT INTO qva_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Chaynuy niptin rïcu runa niran: ‘Tayta Abraham, papänïpa wasinman Lazaruta cachrayculay. ");
INSERT INTO qva_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Chaychru pichgarämi wauguïcuna caycan. Paycunaman willag aywayculächun cay nacayman mana shapäcamunanpag’. ");
INSERT INTO qva_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Chauraga Abraham niran: ‘Paycuna chararanmi Moisés y waquin Diospa willacognincuna escribingancunata. Chaycunata cäsucärichun’. ");
INSERT INTO qva_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Chay rïcu runa niran: ‘Tayta Abraham, charararpis chaytaga manam cäsucäringachu. Juc runa wañunganpita cawarircur willacuptinmi ichanga juchancunapita wanacurir Diosta cäsucäringa’. ");
INSERT INTO qva_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Chaynuy niptin Abraham niran: ‘Moisés y waquin willacogcuna escribingancunata mana cäsucuycarga wañunganpita cawarircur willacog cutiptinpis manam cäsucäringachu’ ”. ");
INSERT INTO qva_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Nircurna discïpuluncunata Jesús niran: “Juchäcachicogcuna imaypis cangam. Paycunaga, ¡cuyapaypämi capäcun! ");
INSERT INTO qva_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Diosman chayrag yäracuycagcunata manaräpis juchäcachiptin mas alim canman chay runapa cuncanman mulinu rumita wataparcur lamarman jitarpuycuptin. ");
INSERT INTO qva_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Gamcunapis juchäcachicog runacunanuy cuydädu carärinquiman. “Diosman yäracog masiqui imatapis mana alita rurashuptiquega mana alita ruraycanganta shumag tantiyachinqui. Juchäcunganpita tantiyacur wanacuptinga perdunanqui. ");
INSERT INTO qva_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Pipis mana alita rurarcur ‘Perdunaycalämay’ nishuptiquega perdunanqui. Juc junagchru ganchris cutipis mana alita rurarcur ‘Perdunaycalämay’ nishuptiquega perdunanqui”. ");
INSERT INTO qva_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Apostulnincuna Jesusta niran: “Yanapaycalämay Tayta Diosman mas yäracärinäpag” nir. ");
INSERT INTO qva_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Chauraga Jesús niran: “Ñäpuspa murunnuylapis yäracuyniquicuna captinga cay yürata ‘Sapicarcur lamarman jawicämuy’ niptiquipis jawicämungam”. ");
INSERT INTO qva_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Pï patrunpis, uywaynincuna arunganpita o michinganpita chrayaptin ¿acäsu ‘Jucla jamacuy micunayquipag’ nipäcunchu? ");
INSERT INTO qva_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Chaypa truquinga lapanpis nipäcun: ‘Yanucamuyrag garamänayquipag. Noga micuyta usharcuptïrämi gamga micunqui’. ");
INSERT INTO qva_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Chaynuy mandanganta ruraycaptinpis manam pipis ‘Gracias’ niylapis nipäcunchu chay uywayninta. ");
INSERT INTO qva_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","“Uywaycunanuylam gamcunapis carcanqui. Chaymi Tayta Dios munangancunata rurarpis ama yarpanquichu pipis ‘Alitam rurashcanqui’ nishunayquita. Chaypa truquinga nipäcuy: ‘Nogacunaga Tayta Diospa uywayninmi carcä. Chaymi pay munangalanta rurapäcushcä’ ”. ");
INSERT INTO qva_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jerusalenpa aywarmi Jesús pasaran Samaria y Galilea provincia cantunpa. ");
INSERT INTO qva_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tacsha marcaman chrayananpag caycaptinmi gueri gueshyawan gueshyaycag chrunca runacuna payta ricaran. Chaymi carulapitana gayacuran: ");
INSERT INTO qva_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","“¡Jesús, maestro, cuyapaycärilämay!” nir. ");
INSERT INTO qva_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Chaymi paycunata ricar Jesús niran: “Aywapäcuy cüracunaman sänu cangayquita ricashunayquipag”. Chaynuy niptin aywarcangalanchrüna gueshyanpita cuticäpäcuran. ");
INSERT INTO qva_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Chaymi cuticashana caycanganta ricaycur chruncapita jucnincag runa cutiran Jesuscagman Tayta Diosta fiyupa alabaycar. ");
INSERT INTO qva_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Chrayaycurnam Jesuspa ñaupagninman gongurpacuycuran “¡Gracias, tayta!” nir. Chay cuteg runaga caran Samariapitam. ");
INSERT INTO qva_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Chaymi Jesús niran chaychru cag runacunata: “Gueri gueshyapita cuticasha cagcunaga ¿manachu chrunca capäcuran? ¿Maytag waquincagcunaga? ");
INSERT INTO qva_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Cay runalam, Israel runa mana caycarpis, cutimusha Tayta Diosta alabänanpag”. ");
INSERT INTO qva_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nircur chay runata niran: “Sharcur aywacuyna. Yäracuyniquipam cuticashana caycanqui”. ");
INSERT INTO qva_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Jesusta fariseucuna tapupäcuran imay Tayta Diospa munaynin chrayamunanpag canganta. Chaynuy tapuptin niran: “Tayta Diospa munayninga pipis ricananpärächu manam shamunga. ");
INSERT INTO qva_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Manam pipis ningachu: ‘Chaychrümi caycan’ o ‘Wacchrümi caycan’. Chaypa truquinga Tayta Diospa munaynin gamcunachrünam caycan”. ");
INSERT INTO qva_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Nircur discïpuluncunata Jesús niran: “Juc junäga gamcuna fiyupam munanquipag noga Diospita shamusha Runa cutiycämogta ricamayta. Ichanga manam ricamanquipächu. ");
INSERT INTO qva_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Pipis ‘Chaychrümi wacchrümi Diospita shamusha Runa caycan’ nipäcushuptiquipis ama cäsupäcunquichu ni aywapäcunquichu. ");
INSERT INTO qva_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Noga Diospita shamusha Runa cutimuptïmi ichanga lapan runacuna ricapäcamanga. Cieluchru ilagu juc cuchrunpita juc cuchruncama tilapyagta ricangannuymi nogatapis cutimuptï ricapäcamanga. ");
INSERT INTO qva_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Chaynuy manarag captinmi puntata runacuna chriquimar fiyupa nacachipäcamanga. ");
INSERT INTO qva_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Noga Diospita shamusha Runa cutimunä junagpis runacuna capäcunga Noé cawanan wichan cawapäcungannuymi. ");
INSERT INTO qva_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Micur, upyar, majachar, majachacur runacuna carcaran büquiman Noé yaycungan junagcama. Büquiman mana yaycogcunaga lapan wañupäcuran fiyupa tamyar cay pachaman yacu juntaptin. ");
INSERT INTO qva_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Chaynuypis Tayta Diospa castïgun mayänipita shamunanpag canganta mana musyar Lot cawanan wichanpis runacuna micur, upyar, rantir, ranticur, murucur y wasitapis rurar carcaran. ");
INSERT INTO qva_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Sodoma marcapita Lot yarguruptinna cielupita tamyamuran azufriyog nina. Chaychru lapan runacuna rupaycar wañupäcuran. ");
INSERT INTO qva_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Chaycuna mayänipita pasangannuymi noga Diospita shamusha Runapis mayänipita cutimushag. ");
INSERT INTO qva_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Chay junäga wasin jananchru cagcunapis imancunapis wasinchru car imanta jorgunalanpäpis ama yarpamuchunchu. Chaynuyla chracrachru caycagcunapis wasinman ama cutichunchu. ");
INSERT INTO qva_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Yarpäpäcuy Lotpa warmin imanuy wañungantapis. ");
INSERT INTO qva_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Pipis quiquilanpita salvacuyta munagcäga manam salvacungachu. Ichanga wañurpis wañuptinga salvacungam. ");
INSERT INTO qva_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Gamcunata nï: Cutimungä chacay juc cämalachru ishcag puñuycagcunapita jucagninta apacunga y jucagninta jaguiriycunga. ");
INSERT INTO qva_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ishcay warmicuna agacuycagpita jucagninta apacunga y jucagninta jaguiriycunga. ");
INSERT INTO qva_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Chaynuy chracranchru ishcay runacuna aruycagcunapita jucagninta apacunga y jucagninta jaguiriycunga”. ");
INSERT INTO qva_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Discïpuluncuna Jesusta tapupäcuran: “¿Maychrütag?” Jesús niran: “Wañusha uywa jitaragman wisculcuna shuntacaycagta ricapäcungannuymi noga Diospita shamusha Runa cutimungäta lapan runacuna musyapäcunga”. ");
INSERT INTO qva_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Mana yamacaypa Diosta rugacärinanpag discïpuluncunata Jesús yachrachiran: ");
INSERT INTO qva_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Juc marcachru Diosta ni runacunatapis mana manchacog juez caran. ");
INSERT INTO qva_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Chay marcachru juc viuda warmipis tiyaran. Chay warmi jucwan lïtunacusha casha. Paymi juezman aywaran ‘Lïtunacungäta arreglaycalämay, tayta’ nir. ");
INSERT INTO qva_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Chaynuy yapar yaparir aywaptinpis juez mana cäsuranchu. Nircurna chay juez yarpachracurir niran: ‘Diosta mana manchacurpis ni runacunata mana manchacurpis cay warmipa demandunta jucla arregläshag. Mana arreglaptïga ima hörapis cutiycämungam fastidiamänanpag’ ”. ");
INSERT INTO qva_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","7","Chaynuy willaparcurmi Jesús niran: “Chay juez mana ali caycarpis viuda lïtunacunganta arreglaranmi. Chaynuy arreglaycaptinga yäracognincuna rugacungancunata Tayta Dios masmi yanapanga. Manam manacaglapächu pagas junag Tayta Diosta rugacäringa. ");
INSERT INTO qva_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Rugacogcagtaga Tayta Dios mana shuwarächiypam yanapanga. Chaynuy captinpis waquin runacunaga payman manana yäracunganachu. Noga Diospita shamusha Runa cay pachaman cutimur ¿runacunata tarishächurag nogaman yäracarcaycämagtarag?” ");
INSERT INTO qva_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Juc cutinchrümi quiquin ali canganta y waquincuna mana mas ali canganta yarpagcunata Jesús caynuy willaparan: ");
INSERT INTO qva_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ishcay runacuna aywaran templuman Diosta rugacunanpag. Jucnin caran fariseo y jucagna caran impuesto cobrag. ");
INSERT INTO qva_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Chay fariseucäga ichricuycur rugacuran: ‘Gracias, Tayta Dios. Gamta agradecicü waquincag runacunanuy mana cangäpitam. Paycunaga capäcun malag, mana ali rurag, majayog caycar majanwannuy jucwan puñucog. Chaynuypis manam nogaga tagay impuesto cobrag runanuychu cä. ");
INSERT INTO qva_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nogaga ayunä ishcay cuti semänachru. Chaynuylam imaypis diezmüta apä templuman’ nir. ");
INSERT INTO qva_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Impuesto cobragcagna ichanga carulachru ichricuycuran. Payga juchasapa car cielumanpis ricäriylapis mana ricäriranchu. Chaypa truquinga fiyupa laquicur niran: ‘Cuyapaycalämay, Tayta Dios. Nogaga juchasapa runam cä’. ");
INSERT INTO qva_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Chaymi impuestuta cobragcäga wasinman cutiran juchanpita perdunashana. Fariseucagtam ichanga Tayta Dios mana perdunaranchu. Chaymi pipis ali tucogcagtaga Tayta Dios pengayman chruranga. Juchasapa canganta tantiyacogcagtam ichanga ali cayman chruranga”. ");
INSERT INTO qva_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Chaypitana iti wamracunatapis Jesuscagman apapäcuran wamracunata yataycur Diosta rugacunanpag. Chaynuy apapäcamogta ricarmi discïpuluncuna piñaparan. ");
INSERT INTO qva_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Chaynuy amachaptinpis wamracunata Jesús gayaran shapäcamunanpag. Nircurnam discïpuluncunata niran: “Wamracuna nogaman aywacamuchun; ama amachäpäcuychu. Tayta Diospa munayninchru cawagcuna chay wamracunanuymi carcan. ");
INSERT INTO qva_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Rasunpam gamcunata nï: Pipis Tayta Diospa munayninchru cawananpag yaycuyta munarga wamracunanuy shumag yäracur chrasquicärichun. Chaynuy mana chrasquicurga pipis manam yaycungachu Tayta Diospa munayninman”. ");
INSERT INTO qva_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mandagcunapita jucnincag Jesusta niran: “Ali maestro, ¿imatatag ruräman mana ushacaypa cawayta chrasquinäpag?” ");
INSERT INTO qva_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Chauraga Jesús niran: “¿Imanirtag ‘Ali’ nimanqui? Manam pipis ali canchu; Tayta Dioslam alega. ");
INSERT INTO qva_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Gam musyanquinam mandamientuncunata: ‘Majayog caycar majayquiwannuy ama jucwan puñucuychu. Runamasiquita ama wañuchiychu. Ama suwacuychu. Manacagpita pitapis ama tumpaychu. Taytayquita mamayquita respitay’ ”. ");
INSERT INTO qva_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Niptin chay runa niran: “Wamra cangäpita pacham chay lapanta cumplishcä”. ");
INSERT INTO qva_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Chayta mayar Jesús niran: “Jucrämi pishïshunqui cumplinayqui: Lapan imayquicunatapis ranticuycur pobricunata aypumuy. Chaynuypa cieluman riquësayquita chruracognuymi caycanqui. Nircur shamuy; nogawan puriy discïpulü canayquipag”. ");
INSERT INTO qva_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Chayta mayar pasaypa rïcu car fiyupa laquicuran. ");
INSERT INTO qva_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Payta ricar Jesús niran: “¡Sasam caycan rïcu runacuna Tayta Diospa munayninman yaycunanpag! ");
INSERT INTO qva_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Aujapa ñawinpa camello pasanganpita mas sasa caycan rïcu runa Tayta Diospa munayninman yaycunanpag”. ");
INSERT INTO qva_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Chaynuy niptinmi mayagcuna tapupäcuran: “Chauraga ¿pirag salvacunga?” nir. ");
INSERT INTO qva_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Niptin Jesús niran: “Quiquilanpitaga runacuna manam salvacuyta puedipäcunchu. Tayta Dioslam pitapis salvan. Paypäga imapis manam sasachu”. ");
INSERT INTO qva_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Chauraga Pedro niran: “Nogacunaga lapan imaycäcunatapis jaguiriycärishcä gamwan puripäcunäpag”. ");
INSERT INTO qva_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Niptin Jesús niran: “Au. Rasunpam gamcunata nï: Pipis Tayta Diospa munaynin raycu wasinta, warminta, wauguincunata, panincunata, mamanta, taytanta y wamrancunata jaguiriycamusha cagcunaga cay pachachru achca cuti masta chrasquipäcunga. Y Tayta Diospa ñaupagninman chrayar mana ushacaypam cawayta chrasquinga”. ");
INSERT INTO qva_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Chaypitam chrunca ishcay (12) discïpuluncunata juc läduman gayaycur Jesús niran: “Cananga Jerusalenmanmi aywaycanchi. Chaychrümi noga Diospita shamusha Runapag willacogcuna escribingannuy lapan cumplinga. ");
INSERT INTO qva_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Mana Israel runacunamanmi entregäpäcamanga. Paycunam asipämanga, ashlimanga y togapämanga. ");
INSERT INTO qva_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Chaynuypis astircamar wañuchimanga. Wañuchimanganpita quimsa junagtaga cawarimushämi”. ");
INSERT INTO qva_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Chaynuy niptin discïpuluncuna manam tantiyayta puedipäcuranchu imapita niycangantapis. ");
INSERT INTO qva_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jericó marcaman Jesús yaycuycaptinna camiñuchru juc gapra runa limusnata mañacuycar jamaraycaran. ");
INSERT INTO qva_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Chauraga achca runacuna aywarcagta mayarmi chay gapra runa tapucuran imanir achca runacuna pasaycanganta musyananpag. ");
INSERT INTO qva_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Tapucuptin willapäcuran: “Nazaretpita Jesusmi pasaycan” nir. ");
INSERT INTO qva_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Willaycuptinna gayacuran: “¡Rey Davidpa ayllun Jesús, cuyapaycalämay!” nir. ");
INSERT INTO qva_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Chaymi ñaupagninta aywaycagcuna chay gaprata piñaparan upälacunanpag. Chaynuy piñapaptinpis masrämi gayacuran: “¡Rey Davidpa ayllun, cuyapaycalämay!” nir. ");
INSERT INTO qva_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Chauraga Jesús ichricuycuran. Nircur mandaran ñaupagninman pushamunanpag. Cercanchru captinna tapuran: ");
INSERT INTO qva_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“¿Gampag imata ruranätatag munaycanqui?” nir. Chauraga gapra niran: “Tayta, ñawï ricanantam munä”. ");
INSERT INTO qva_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Niptin Jesús niran: “¡Ricayna! Yäracuyniquipam cuticashana caycanqui”. ");
INSERT INTO qva_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Chauraga chay höram gaprapa ñawin cuticaran. Cuticarcurnam Jesuspa guepanpa Tayta Diosta alabaraycar aywaran. Chayta ricaycur lapan runacuna Tayta Diosta alabäpäcuran. ");
INSERT INTO qva_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","3","Jericó marcachrümi tiyaran Zaqueo jutiyog rïcu runa. Paymi impuesto cobragcunapa mandagnin caran. Jericó marcapa achca runacunawan Jesús pasaptinmi tacshala car ricayta mana puediranchu. ");
INSERT INTO qva_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Chaymi cörrila ñaupaycur jegaran juc yüraman, Jesús pasaycagta ricananpag. ");
INSERT INTO qva_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Chaypa pasaycarmi Jesús altupa ricäringanchru Zaqueuta yürachru caycagta ricaran. Nircur niran: “Zaqueo, jucla yarpamuy. Canan wasiquichrümi quëdanä caycan”. ");
INSERT INTO qva_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Chauraga Zaqueo jucla yarparcamur Jesusta cushisha wasinman pusharan. ");
INSERT INTO qva_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Chayta ricaycur lapan runacuna Jesusta jamurparan: “Juchasapa runapa wasinman quëdananpag aywasha” nir. ");
INSERT INTO qva_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Wasinchrünam ichrircur Zaqueo Señor Jesusta niran: “Chararangäpita pulantam imätapis pobricunata raquipaycushag, tayta. Chaynuy pipa imantapis guechrungäcunapita chruscu cuti mastam cutichishag”. ");
INSERT INTO qva_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Chaynuy niptin Jesús niran: “Cananga salvashanam caycanqui gam y wasiquichru tiyagcunapis. Abraham yäracungannuymi gampis Tayta Diosman yäracuycanquina. ");
INSERT INTO qva_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Noga Diospita shamusha Runa juchasapa runacunata salvanäpämi shamushcä”. ");
INSERT INTO qva_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jerusalenman Jesús aywaycaptinnam runacuna yarpäpäcuran Tayta Diospa munayninman lapanta jucla chrurananpag canganta. Chaynuy mana canganta tantiyachinanpämi Jesús rïcu runaman tincuchiypa caynuy willaparan: ");
INSERT INTO qva_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Juc rïcu runa aywaran caru juc lädu naciunman mandag cayta chrasquircamur cutimunanpag. ");
INSERT INTO qva_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Manarag aywar chrunca uywaynincunata gayachiran. Nircur jucninta jucnintapis aypuran achca guellayta: ‘Cutimungäcama cay guellayta aruycächinqui’ nir. ");
INSERT INTO qva_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Chaynuy nircur aywacuptin marcamasincuna payta chriquir guepanta cachraran caynuy nipäcamunanpag: ‘Manam chay runata mandagnï cananpag munapäcüchu’. ");
INSERT INTO qva_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Chaynuy marcamasincuna mana munaycaptinpis mandag cayta chrasquiran. Chaypita marcanman cutiycurna gayachiran guellaynin chararag uywaynincunata guellaynin aycatana mirangantapis musyananpag. ");
INSERT INTO qva_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Chauraga puntata shamogcag niran: ‘Guellayniqui mirasha chrunca cuti mastam, tayta’. ");
INSERT INTO qva_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Chauraga mandagnin niran: ‘¡Ali uywaymi gam caycanqui! Walcalawanpis ali cangayquipitam chrunca marcapa mandagnin canayquipag chrurashayqui’. ");
INSERT INTO qva_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Jucagpis shamur niran: ‘Guellayniqui mirasha pichga cuti mastam, tayta’. ");
INSERT INTO qva_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Paytapis niran: ‘Pichga marcapa mandagnin canayquipämi gamta chrurashayqui’. ");
INSERT INTO qva_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Chaynuypis jucag uywaynin shamur niran: ‘Caychru caycan guellayniqui, tayta. Pañueluwan guepircurmi chruraycurä. ");
INSERT INTO qva_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Gamga shuntanqui mana chrurangayquipita y cosechanqui mana murungayquipitam. Chaymi fiyu cangayquita manchacur chruraycurä’. ");
INSERT INTO qva_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","Chauraga patrunnin caynuy niran: ‘¡Fiyu runam gam caycanqui! Quiquiquipa shimilayquipitam juzgashayqui. Fiyu cangäta musyaycarga, mana chruraycar shuntangäta y mana muruycar cosechangäta musyaycarga ¿imanirtag guellaynïta mana chrurarayquichu bancuman, cutiycamur mirashatana shuntacunäpag?’ ");
INSERT INTO qva_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Chaymi niran chaychru caycag runacunata: ‘¡Guechrupäcuy chararaycangan guellaynïta! ¡Nircur goycuy chrunca cuti mas guellay mirachegcagta!’ ");
INSERT INTO qva_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Chaynuy niptin nipäcuran: ‘Payga maynam chararaycan chrunca cuti masta, tayta’. ");
INSERT INTO qva_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nipäcuptin patrunnin niran: ‘Achcata chararagcäga mastam chrasquinga. Walcalata chararagcagtam ichanga chararangalantapis guechrusha canga. ");
INSERT INTO qva_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","¡Mandag canäta mana munar chriquimagnïcunataga cayman apaycamur noga ricaycaptï wañuchipäcuy!’ ” ");
INSERT INTO qva_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Chaynuy willaparcurmi Jerusalenpa Jesús aywacuycaranna. ");
INSERT INTO qva_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Olivos lömachru caycag Betfagé y Betania marcacunaman chrayananpäna caycar ishcay discïpuluncunata cachraran. ");
INSERT INTO qva_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Paycunata niran: “Aywapäcuy wac chimpachru caycag marcaman. Chrayarnam marca yaycunachru taripäcunqui pipis manarag logacungan manta bürru wataraycagta. Chayta pasquirir apapäcamunqui. ");
INSERT INTO qva_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Chaychru pipis ‘¿Bürruta imanirtag pasquiycanqui?’ nishuptiquega nipäcunqui ‘Señor Jesusmi nisitaycan’ ”. ");
INSERT INTO qva_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Chauraga discïpuluncuna aywar Jesús ningannuyla taripäcuran. ");
INSERT INTO qva_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Chaypita manta bürruta pasquircaptinmi dueñuncuna tapuran: “¿Imapätag bürrüta pasquiycanqui?” ");
INSERT INTO qva_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Chaynuy niptinmi nipäcuran: “Señor Jesusmi nisitaycan”. ");
INSERT INTO qva_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Chaypitana Jesús cagman manta bürruta apapäcuran. Chaychrünam cäpancunata carunarcur chariparan Jesús logacunanpag. ");
INSERT INTO qva_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Chaymi Jesús aywaycangancag camiñumanpis cäpancunata mashtapäcuran. ");
INSERT INTO qva_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Chauraga Olivos lömapa yarpurcaptinnam achca discïpuluncuna pasaypa cushicur Diosta alabäpäcuran lapan milagrucunata ricapäcunganpita: ");
INSERT INTO qva_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“¡Tayta Dios cachramungan runa alabasha cayculächun! ¡Mandamagninchi alabasha cayculächun! ¡Jauca caway cieluchru cayculächun! ¡Cieluchru Tayta Dios alabasha cayculächun!” nir. ");
INSERT INTO qva_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Chauraga chaychru caycag fariseucuna runacunapa chraupinpita niran: “Piñapay discïpuluyquicunata upälacärinanpag, maestro”. ");
INSERT INTO qva_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Chaynuy nipäcuptinmi Jesús niran: “Paycuna upälacäriptinga rumicunapis rimarir Tayta Diosta alabangam”. ");
INSERT INTO qva_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jerusalén cercaman chrayarna ricärir chay marcachru tiyag runacunapag Jesús wagaran ");
INSERT INTO qva_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","caynuy nir: “Ali cawayta apaycämungäta canan junaglapis tantiyarga alim cawapäcunquiman. Chaynuy caycaptinpis manam tantiyapäcunquichu. ");
INSERT INTO qva_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Chaymi gamcunapag chrayamunga nacanayquipag cag junagcuna. Chriquishogniquicuna intërupa muyupaycärishuptiquega manam maypapis gueshpipäcunquinachu. ");
INSERT INTO qva_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Wamrantiquitam wañuchipäcushunqui. Wasiquicunatapis lapantam juchruchiypa ushanga. Manam ni juc rumilapis pergaraycar quëdangachu. Chaynuymi canga Tayta Dios salvashunayquipag shamunganta mana cäsucungayquipita”. ");
INSERT INTO qva_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jerusalenman Jesús chrayaycurnam templuman yaycuycur chaychru ranticurcagcunata garguran. ");
INSERT INTO qva_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Gargurmi paycunata niran: “Tayta Dios escribichinganchru niycan: ‘Wasïga canga nogata rugacamänanpämi’. Ichanga gamcuna suwapa machrayninmannuy chrurapäcushcanqui”. ");
INSERT INTO qva_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nircurnam templuchru waran waran Jesús yachrachiran. Chaymi cüracunapa mandagnincuna, Moisés escribingan leycunata yachrachegcuna y autoridäcunapis Jesusta wañuchiyta imanuypapis ashipäcuran. ");
INSERT INTO qva_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Lapan runacuna Jesús yachrachingancunata shumag mayapäcuptinmi ima ruraytapis mana camäpacuranchu. ");
INSERT INTO qva_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Chaypitam templuchru runacunata Jesús yachraycächiptin y Diospa ali willacuyninta willacuycaptin cüracunapa mandagnincuna, Moisés escribingan leycunata yachrachegcuna y Israel mayor runacuna chrayapäcuran. ");
INSERT INTO qva_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Jesusta tapupäcuran: “Gamga ¿ima munayniquiwantag chay lapanta rurashcanqui? ¿Pitag nishushcanqui chaycunata ruranayquipag?” ");
INSERT INTO qva_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Chaynuy tapuptin Jesús niran: “Nogapis gamcunata tapushayqui. Nipäcamay: ");
INSERT INTO qva_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Pitag Juanta cachramusha bautizänanpag, Tayta Dioschu o runacunachu?” ");
INSERT INTO qva_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Chauraga quiquinpura caynuy parlanacäriran: “ ‘Tayta Diosninchim cachramusha’ nishaga ‘¿Imanirtag mana criyipäcurayquichu?’ nimäshun. ");
INSERT INTO qva_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Chaynuypis manam nishwanchu ‘Runacuna cachramusha’. Chaynuy nishaga sagmaycälarmi lapan runacuna wañuchimäshun. Criyipäcun Tayta Diospa willacognin Juan cangantam”. ");
INSERT INTO qva_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Chaymi nipäcuran: “Manam musyapäcüchu pï cachramungantapis”. ");
INSERT INTO qva_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Chauraga Jesús niran: “Nogapis manam willashayquichu ima munaynïwan rurangätapis”. ");
INSERT INTO qva_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jesús tincuchiypa willapayta galaycuran: “Juc runa juc chracra üvasta plantaran. Nircurna arrendacuycur juc lädupa aywacuran chaychru goyänanpag. ");
INSERT INTO qva_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Chauraga cosëcha galaycuptinna juc uywayninta üvas chracra arrendacunganpita shuntamunanpag cachraran. Chay uyway chrayaptin pasaypa magarcärir jinaylata garguriycäriran. ");
INSERT INTO qva_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Chaynuy jinayla cutiycuptin chay runaga yapay cachraran juc uywayninta. Chaytapis ashlircärir y magarcärir jinaylata garguriycäriran. ");
INSERT INTO qva_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Chaypita yapay cachraran juc uywayninta. Chaytapis magaypa usharcärir garguriycäriran. ");
INSERT INTO qva_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Chauraga chracrapa dueñun yarpachracuran: ‘¿Canan imatatag rurashag? Cachrashag cuyay wamräta. Paytaga pagta respitäpäcunman’. ");
INSERT INTO qva_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Chay chracrayogpa cuyay wamran aywaycämogta ricar arrendagcuna rimanacäriran: ‘Tagaymi cay chracrawanga quëdanga. Wañuriycachishun cay chracra noganchipäna quëdananpag’. ");
INSERT INTO qva_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Chay chracrapita jorgaycärir wañuchipäcuran. “Gamcuna ¿imatatag yarpäpäcunqui chay runacunawan chracrapa dueñun rurananta? ");
INSERT INTO qva_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Aywanga y wañuchinga chay runacunata y juctana chay chracrata arrendaycunga”. Chay ninganta mayar nipäcuran: “¡Chaynuyga ama cayculächunchu!” ");
INSERT INTO qva_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Chaymi paycunata ricärir Jesús niran: “Chaynuy gamcunawanpis cananta mana munarga Tayta Diosninchi escribichinganchru caynuy ninganta ¿imatatag tantiyapäcunqui? ‘Wasi ruragcuna “mana ali rumim” nir jitaringan rumim wasi cimientupag alinnincag rumiman ticrasha’. ");
INSERT INTO qva_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Pipis chay rumi jananman ratagcäga ushacangam. Y pipa jananmanpis chay rumi ratarga pasaypam ushacächinga”. ");
INSERT INTO qva_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Chaynuy niptinmi Moisés escribingan leycunata yachrachegcuna y cüracunapa mandagnincuna tantiyapäcuran paycunapa contran Jesús tincuchiypa rimaycanganta. Chaymi chay höra prësu charichiyta munapäcuran. Chaynuy munarpis runacunata manchacärir Jesusta prësu manam charichiranchu. ");
INSERT INTO qva_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Chaymi autoridäman apachipäcunan casha Jesuscagman runacunata cachrapäcuran alitucular mana alita rimachinanpag. ");
INSERT INTO qva_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Chrayaycärirmi chay runacuna Jesusta niran: “Maestro, musyapäcümi parlarpis yachrachirpis rasuncaglata ningayquita. Runacuna imata niptinpis manam paycuna munangannuychu gam yachraycächinqui sinöga pitapis alitam yachraycächinqui Dios munangannuy cawapäcunanpag. ");
INSERT INTO qva_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Alichu canman Romachru emperador Cesarpag impuestuta päganapag o mana päganapag?” ");
INSERT INTO qva_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Chauraga lutanta rimachinanpag tapuycanganta tantiyar Jesús niran: ");
INSERT INTO qva_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mä, ricachimay guellayta”. Chayta ricaycurmi niran: “¿Pipa cärantag y pipa jutintag cay guellaychru caycan?” Nipäcuran: “Emperador Cesarpam”. ");
INSERT INTO qva_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Chaymi Jesús niran: “Cesarpa cagtaga Cesarta goycuy. Tayta Diospa cagtaga Tayta Diosta goycuy”. ");
INSERT INTO qva_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jesús chaynuy niptin runacunapa ñaupagninchru imatapis lutanta rimachiyta mana puedipäcuran. Almirasha quëdarcur upälacäriran. ");
INSERT INTO qva_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Waquin saduceo runacuna Jesuscagman aywapäcuran. Chay saduceucuna mana criyipäcuranchu runa wañunganpita cawarimunanpag canganta. ");
INSERT INTO qva_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Chaymi Jesusta tapupäcuran: “Maestro, noganchipag Moisés escribingan leycunachru caynuymi nin: ‘Juc runa wamraynag wañuptin viudanwan jucag wauguin tiyachun. Chaynuypam wamrancuna chay wañogcag runapa wamrannuyna canga’. ");
INSERT INTO qva_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Juc cutinchru ganchris wauguicuna caran. Mayurcag juc warmiwan tiyaran. Pay manarag wamran captin wañuran. ");
INSERT INTO qva_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Chauraga shulcacag wauguinna chay viudawan tiyaran. Paypis wamran manarag captin wañuran. ");
INSERT INTO qva_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Chaypita mas shulcancagna chay viudawan tiyaran. Paypis wañuran wamran manarag captin. Chaynuyla lapan wauguincuna chay viudawan tiyaran. Y wamraynagla lapanpis wañuran. ");
INSERT INTO qva_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Chaypitana chay viudapis wañuran. ");
INSERT INTO qva_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Chauraga wañushacuna cawarimuptinga ¿mayganpa warmintag canga, lapan wauguinwan tiyasha caycaptinga?” ");
INSERT INTO qva_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","35","Chauraga Jesús niran: “Cay pachalachrümi runacuna majachacärin. Dios acrangan runacuna wañunganpita cawarircamurnaga cieluchru manam majachanganachu ni majachacäringanachu. ");
INSERT INTO qva_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Cieluchrüga angilcunanuyna car mana wañog canga. Tayta Dios cawarichimunganpitam paypa wamrancuna canga. ");
INSERT INTO qva_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Wañushacuna cawarimunanpag canganpitaga Moisespis tantiyachiranmi. Rupaycag shirapita escribinganchru pay niran Tayta Diosga Abrahampa, Isaacpa y Jacobpa Diosninmi canganta. ");
INSERT INTO qva_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Tayta Dios manam wañushacunapa Diosninchu sinöga cawaycagcunapa Diosninmi. Paypäga lapanpis cawaycanmi”. ");
INSERT INTO qva_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Chauraga Moisés escribingan leycunata yachrachegcuna waquin nipäcuran: “¡Alitam nishcanqui, maestro!” ");
INSERT INTO qva_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Chaypitanaga pipis manana imatapis tapupayta almitirannachu. ");
INSERT INTO qva_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Paycunatana Jesús tapuran: “¿Imanirtag runacuna yarpäpäcun Tayta Dios cachramungan Salvador rey Davidpa ayllunpita canganta? ");
INSERT INTO qva_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Quiquin Davidpis escribingan Salmos libruchru niran: Tayta Diosmi Señurnïta niran: Cay derëchacag lädüman jamacuy ");
INSERT INTO qva_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","contrayqui cagcunata munayniquiman chruramungäcama. ");
INSERT INTO qva_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Chauraga Dios cachramungan Salvadurta David ‘Señor’ niycaptinga ¿imanuypatag Dios cachramungan Salvador Davidpa ayllunpita canman?” ");
INSERT INTO qva_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Lapan runacuna mayapararcaptinmi discïpuluncunata Jesús niran: ");
INSERT INTO qva_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Moisés escribingan leycunata yachrachegcunapita cuydacäriy. Chraqui puntancama sotänasha puripäcun. Pläzacunachru pipis respëtuwan saludänanta munapäcun. Shuntacänan wasicunachru alinnin bancumanrag jamacuyta munapäcun. Micunanpag gayachiptinpis punta puntamanrämi jamacuyta munapäcun. ");
INSERT INTO qva_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Chaynuypis viudacunapa wasincunata guechrurcan. Paycuna runa ricanalanpämi Tayta Diosta may hörarag rugacurcan. Chaynuy rurapäcunganpita fiyupa castïgutam chrasquipäcunga”. ");
INSERT INTO qva_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Chaypitam templuchru Jesús ricapaycaran rïcucuna guellayninta Diospag ofrendata wiñacunan gaycurcagta. ");
INSERT INTO qva_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Chaychrümi ricaran viudatapis ishcayla guellayninta gaycuycagta. ");
INSERT INTO qva_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jesús niran: “Cay pobre viudaga lapanpitapis mastam gaycusha. ");
INSERT INTO qva_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Lapanpis gaycusha puchupangancag guellaynintam Tayta Diospag. Ichanga viuda pobre caycarpis chayla rantipacunanpag caycaptinpis lapan guellayninta gaycusha”. ");
INSERT INTO qva_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Templuchru cuyaylapag caycag rumicunapita y templo cuyaylapag cananpag goycungan adornucunapitapis waquin discïpulucuna parlarcaran. Chaymi Jesús niran: ");
INSERT INTO qva_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Cay lapan ricarcangayqui ushacänanpag cag junag chrayamungam. Manam pergasha rumicuna ni juclaylapis canan caycangannuyga quëdangachu. Ushagpag juchruchisham canga”. ");
INSERT INTO qva_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Chauraga tapupäcuran: “Maestro, ningayquicunaga ¿imaytag canga? Chaynuy cananpäga ¿puntata imatag canga?” ");
INSERT INTO qva_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Chaymi Jesús niran: “Achcagmi nogatucular shapäcamunga: ‘Tayta Dios cachramungan Salvador caycä’ nir. Chaynuypis nipäcushunqui: ‘Tiempo chrayamushanam cay pacha ushacänanpag’. Chaynuy nishuptiquipis gamcuna paycunawan ama puripäcunquichu. ");
INSERT INTO qva_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","May chay naciuncunachrüpis guërra captin y wañuchinacuy captin ama mancharipäcunquichu. Puntataga chaycunarämi canga. Ichanga cay pacha manarämi ushacangarächu”. ");
INSERT INTO qva_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Mastapis niran: “Juc naciunwan juc naciunmi y juc munayniyogwan juc munayniyogmi guërrachru canga. ");
INSERT INTO qva_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","May chaychrüpis fiyupa terremötu canga, muchruy canga y gueshyacunapis canga. Chaynuypis cieluchru ricacämunga manchariypag imaycacunapis. ");
INSERT INTO qva_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Chaycuna manarag captinmi gamcunata rabyapar prësu charipäcushunqui. Shuntacänan wasicunachru juzgapäcushunqui y carcilcunaman wichrgapäcushunqui. Nogapa janan reycunamanpis y gobernadurcunamanpis apapäcushunquim juzgasha canayquipag. ");
INSERT INTO qva_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Chay höra nogapita paycunata willacärinqui. ");
INSERT INTO qva_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ama yarpachracärinquichu juzgashungayqui höra tapushuptiqui imata nipäcunayquipäpis. ");
INSERT INTO qva_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nogam shumag tantiyachishayqui imata nipäcunayquipäpis. Chaymi maygan chriquishogniquicunapis ima niytapis mana camäpacungachu, ni ‘Mana alim parlashcanqui’ nipäcushunquipischu. ");
INSERT INTO qva_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Taytayquicuna, wauguiquicuna, aylluyquicuna y amïguyquicunapis gamcunata entregäpäcushunqui. Chaynuypis waquinniquicunataga wañuchipäcushunquim. ");
INSERT INTO qva_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Noga janan lapan runacunam gamcunata chriquipäcushunqui. ");
INSERT INTO qva_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Chaynuy rurapäcushuptiquipis ama laquicärinquichu. Ima pasashuptiquipis Tayta Dios manam gongäshunquichu. ");
INSERT INTO qva_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mana yamacaypa yäracur Tayta Diospa ñaupagninman chrayapäcunqui. ");
INSERT INTO qva_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Jerusalén ushacänanpäna caycanganta musyapäcunqui soldäducuna muyuparaycagta ricarmi. ");
INSERT INTO qva_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Chauraga Judea provinciachru caycagcuna jircacunaman gueshpicärichun. Chaynuy Jerusalenchru caycagcunapis marcapita gueshpir aywacärichun. Chracrachru caycagcunapis marcaman ama cutichunnachu. ");
INSERT INTO qva_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Chay junagcuna castigasham canga runacuna. Chaynuypam Tayta Dios escribichingancuna lapanpis cumplinga. ");
INSERT INTO qva_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Chay junagcuna cuyapaypämi capäcunga chrichru warmicuna y chuchuycag wawayog warmicuna. Intëru Israel naciunman Diospa castïgun chrayaptin runacuna fiyupam laquicäringa. ");
INSERT INTO qva_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Waquincunatam wañuchipäcunga y waquincagtanam caru naciuncunaman apapäcunga. Mana Israelcag runacunam Jerusalenta munayninchru chararanga tiempun cumplingancama. ");
INSERT INTO qva_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Inti, quilla y estrëllacunapis manchariypag juc niragmanmi ticranga. Cay pachachrünam lapan runacuna manchacuywan turbatanga lamar yacu bunyaypa bunyar fiyupa gaparaptin. ");
INSERT INTO qva_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Cieluchru munayniyogcuna sicsicyaptin runacuna: ‘¿Imanuyrag cay pacha canga?’ nir mancharir wañucäcunga. ");
INSERT INTO qva_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Chaychrümi noga Diospita shamusha Runata pucutay jananchru chipipaycar pasaypa munaynïwan aywaycämogta ricapäcamanga. ");
INSERT INTO qva_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Chay ningänuyla lapanpis ruracaycagta galaycuptinga cushicärinqui. Musyapäcunquinam nacaycunapita jorgunäpäna caycanganta”. ");
INSERT INTO qva_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Nircur tincuchiypa Jesús tantiyachiran: “Hïgus yürata y lapan yüracunatapis imanuypis canganta ricapäcunqui. ");
INSERT INTO qva_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Öjancuna chinliyta galaycuptin tamya quilla galaycunanpäna canganta quiquiquicuna musyapäcunquinam. ");
INSERT INTO qva_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Chaynuylam chay ningäcuna pasaptin musyapäcunqui Tayta Diospa munaynin cutimunanpag caycanganta. ");
INSERT INTO qva_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Rasunpam gamcunata nï: Cay lapan chaynuy canga manaräpis canan wichan runacuna wañuptinmi. ");
INSERT INTO qva_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Cielupis y cay pachapis ushacangam. Noga ningäcunam ichanga mana ushacangachu. ");
INSERT INTO qva_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mana yarpangayqui höra mayänipita noga cutimur gamcunata tarirüman mana alicunata ruraycagta, shincasha caycagta y imaycayogpis canayquipag yarpachracur gongämasha caycagta. ");
INSERT INTO qva_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Chaynuypis lapan runacunata juzganäpämi cutimushag. ");
INSERT INTO qva_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Tayta Diosta imaypis rugacärinayqui nacaycunata awantänayquipag. Imaypis listula carcänayqui noga chrayamunäpag. Chaymi castigasha canayquipa truquinga noga Diospita shamusha Runapa ñaupagnïman cushisha chrayapäcamunquipag”. ");
INSERT INTO qva_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Templuchru Jesús junagpa yachrarcachir chacaypana Olivos jutiyog lömaman aywachrag chaychru pachacunanpag. ");
INSERT INTO qva_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Chaymi templuman yachrachinanpag tutala cutiptinna runacuna aywapäcog yachrachicuyninta mayapäcunanpag. ");
INSERT INTO qva_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Levadüraynag tantata micapäcunan Pascua fiestam chrayaycämuranna. ");
INSERT INTO qva_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Cüracunapa mandagnincunawan Moisés escribingan leycunata yachrachegcuna rimanacäriran imanuypapis Jesusta wañuchinanpag. Ichanga runacunata manchacäriran. ");
INSERT INTO qva_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Chaynuy yarparcaptinmi Satanás yaycuran Judas Iscariotipa shongunman. Judas Jesuspa chrunca ishcay (12) discïpulunpita jucnincagmi caran. ");
INSERT INTO qva_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Paymi cüracunapa mandagnincunaman y templo cuydag wardiacunapa mandagnincunaman aywaycur paycunaman Jesusta entregänanpag parlaran. ");
INSERT INTO qva_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Chauraga cushicärirmi rimanacäriran Judasta pägapäcunanpag. ");
INSERT INTO qva_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","“Aumi” nir runa mana cangan höra Jesusta paycunaman entregänanpag Judas shuwararan. ");
INSERT INTO qva_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Levadüraynag tantata micunan fiesta junag chrayamuptinna Pascua fiestapag carnita runacuna pishtapäcog. ");
INSERT INTO qva_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Chaymi Jesús cachraran Pedrutawan Juanta: “Pascua fiestachru micunanchipag cënata camaricamuy” nir. ");
INSERT INTO qva_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Chauraga paycuna tapupäcuran: “Tayta, ¿maychrütag camaripäcamushag?” nir. ");
INSERT INTO qva_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Chaynuy niptinmi Jesús niran: “Jerusalenman chrayarnam tincupäcunqui juc runa wacuywan yacuta apaycagta. Chay runapa guepalanpa aywapäcunqui. Wasiman yaycuptin gamcunapis yaycapäcunqui. ");
INSERT INTO qva_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Chaychrümi wasiyogta nipäcunqui: ‘Maestro tapuycäshunqui: ¿Maychrütag caycan cuarto discïpulücunawan Pascua cënata micupäcunäpag?’. ");
INSERT INTO qva_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Chaynuy nipäcuptiquim ricachishunqui wasipa altucag pïsunchru chrurapacusha jatun cuartuta. Chay cuartuchru cënata camaricärinqui micunanchipag”. ");
INSERT INTO qva_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Chaymi paycuna aywar Jesús ningannuyla taripäcuran. Y chaychru Pascua cënata camaripäcuran. ");
INSERT INTO qva_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Chauraga cënay höra chrayamuptinnam apostulnincunawan Jesús jamacäriran micapäcunanpag. ");
INSERT INTO qva_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Chaychrümi Jesús niran: “Cushicümi cay Pascua cënata gamcunawan micur. Manaräpis wañurmi gamcunawan cay cënata micuyta munarä. ");
INSERT INTO qva_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Gamcunawan mananam cay Pascua cënata micushänachu Tayta Diospa munayninwan cay pachaman yapay cutimungäcama”. ");
INSERT INTO qva_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Chauraga vïnuyog cöpata jogarcurmi Tayta Diosta agradecicuran. Nircur discïpuluncunata niran: “Caypita lapayqui upupäcuy. ");
INSERT INTO qva_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Yapayga manam vïnuta upushänachu Tayta Diospa munaynin chrayangancama”. ");
INSERT INTO qva_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Chaynuypis tantata aptarcur Tayta Diosta agradecicuran. Nircurnam partirir paycunata caynuy nir aypuran: “Cayga cuerpümi. Gamcuna raycum nogata wañuchimanga. Cay tantata micunqui gamcuna raycu wañuchimanganta yarpänayquipag”. ");
INSERT INTO qva_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Chaynuylam micuyta usharcärir vïnuyog cöpata aptarcurpis niran: “Cay cöpachru caycag vïnoga yawarnïmi. Gamcuna raycu jichrasha captin caywanmi runawan Tayta Dios mushog conträtuta ruranga. ");
INSERT INTO qva_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Chriquimagnïcunaman entregämänanpag cag runapis noganchiwanmi cay mësachru caycan. ");
INSERT INTO qva_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tayta Dios munangannuymi noga Diospita shamusha Runa wañunäpämi caycä. ¡Entregämag runa ichanga cuyapaypämi canga!” ");
INSERT INTO qva_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Chaynuy niptinmi jucnin jucninpis discïpuluncuna tapunacäriran: “¿Mayganchirag chay entregag caycanchi?” nir. ");
INSERT INTO qva_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Chaypitam mandag cayta guechrunacur discïpulucuna jucnin jucninpis ninacurcaran. ");
INSERT INTO qva_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Chaymi Jesús niran: “Nacion mandagcuna shongun munangannuymi mandapäcun. Chaynuy mandaptinpis ‘Ali rurag runam payga’ nipäcun. ");
INSERT INTO qva_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Gamcunaga ama paycunanuy capäcuychu. Chaypa truquinga maygayquipis mas alipag ricasha carga umildicagcunanuy canquiman. Chaynuy maygayquipis mandag carga uywaynuyla canquiman. ");
INSERT INTO qva_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Musyapäcunquim patruncuna mësachru micuptin uywaynincuna sirvinganta. Nogaga uywaynuylam gamcunapag caycä. Chaymi gamcunapis uywaynuyla capäcunayqui. ");
INSERT INTO qva_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Imanuy nacaptïpis gamcuna nogawanmi imaypis cashcanqui. ");
INSERT INTO qva_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Chaymi gamcunata chrurashayqui mandag capäcunayquipag, taytä nogata mandag canäpag chruramangannuy. ");
INSERT INTO qva_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Chaymi mandangäcagchru gamcuna nogawan micapäcunqui y upupäcunqui. Chaynuypis tronucunachru jamacärinqui chrunca ishcay ayllupita mirag Israel runacunata juzganayquipag”. ");
INSERT INTO qva_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Chaypitam Jesús niran: “Pedro, Satanasmi Tayta Diosta mañacusha trïguta tapshegnuypis mana alicunata gamcunata rurachipäcushunayquipag. ");
INSERT INTO qva_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Chaymi gampag Diosta rugacushcä Satanás munanganta rurachishuptiquipis nogaman yapay yäracunayquipag. Yapay yäracurnam yäracog masiquicunata shacyächinayqui paycunapis nogaman yäracamänanpag”. ");
INSERT INTO qva_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Chaynuy niptinmi Pedro niran: “Carcilman apashushpayquega nogatapis apamächun, tayta. Gamta wañuchirga nogatapis wañuchimächun”. ");
INSERT INTO qva_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Chauraga Jesús niran: “Pedro, canan chacay manarag gällu cantaptinmi quimsa cutina reguimangayquita niegamanqui”. ");
INSERT INTO qva_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Chaypita discïpuluncunata Jesús tapuran: “Guellayniynagta, jacuynagta y llanquiynagta willacärinayquipag cachraptï ¿imalapis pishïshurayquichu?” Chauraga nipäcuran: “Manam imapis pishïmaranchu, tayta”. ");
INSERT INTO qva_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","37","Chauraga Jesús niran: “Tayta Dios escribichinganchru nogapag ningannuylam runacuna fiyu runa cangäta yarpar chriquipäcamanga. Chaymi cananga jacuyogcäga jacunta apachun, guellayniyog cäga guellayninta apachun, y espädaynag cäga jacunta ranticuycur espädata rantichun”. ");
INSERT INTO qva_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Chauraga discïpuluncuna nipäcuran: “Caychru caycan ishcay espädacuna, tayta”. Niptin Jesús niran: “¡Ningätapis gamcuna manam tantiyapäcamanquichu!” ");
INSERT INTO qva_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Chaypitam Jesús imaypis aywachrangannuy Olivos jutiyog lömaman aywaran y discïpuluncuna guepanta aywapäcuran. ");
INSERT INTO qva_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Chayman chrayaycurnam discïpuluncunata niran: “Tayta Diosta rugacäriy juchäcuyman mana chrayapäcunayquipag”. ");
INSERT INTO qva_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Chaynuy nircur mas wac läduman aywaran. Chaychrünam gongurpacuycur Diosta rugacuran: ");
INSERT INTO qva_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tayta, gam munarga cay nacanäpag caycagpita jorgaycalämay. Ichanga noga munangänuyga ama cachunchu, sinöga gam munangayquinuy cayculächun”. ");
INSERT INTO qva_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Chaynuy laquicur rugacuycaptinmi juc angel chrayaycur shacyächiran mana laquicunanpag. ");
INSERT INTO qva_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Chaynuy fiyupa laquicur Jesús lapan shongunpa Diosta rugacuycaptinmi südayninpis yawarnuyrag pampaman shuturan. ");
INSERT INTO qva_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Diosta chaynuy rugacunganpita sharcurcur discïpuluncunacagman cutiycur Jesús tariran paycuna laquicuypita puñucasha carcagta. ");
INSERT INTO qva_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Chauraga Jesús niran: “¿Imanirtag puñurcanqui? Sharcapäcuy. Tayta Diosta rugacäriy juchäcuyman mana chrayapäcunayquipag”. ");
INSERT INTO qva_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Chaynuy parlaycaptinrämi Judas achca runacuna pushasha chrayaran. Judas caran chrunca ishcay (12) discïpuluncunapita jucnincag. Chrayarcurnam Jesusman ashuycuran payta muchaycunanpag. ");
INSERT INTO qva_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Chauraga Jesús niran: “Judas, ¿gamga juc muchaycuylawanchu noga Tayta Diospita shamusha Runata entregämanqui?” ");
INSERT INTO qva_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Chaymi Jesusta prësu apacärinanpag canganta tantiyar paywan caycagcuna tapupäcuran: “Tayta, ¿tucsipäcushächu paycunata?” ");
INSERT INTO qva_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Chaynuy nir jucnincag discïpulun cüracunapa mas mandagninpa uywayninpa derëchacag rinrinta roguriycuran. ");
INSERT INTO qva_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Chaymi Jesús niran: “¡Ama chaynuy ruraychu!” Nircur uywaypa rinrinta yataycur cuticächiran. ");
INSERT INTO qva_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesusta prësu apananpag shamogcuna caran cüracunapa mandagnincuna, templo cuydag wardiacunapa mandagnincuna y Israel mayor runacuna. Paycunatam Jesús niran: “¿Imanirtag gamcuna saltiador captïnuypis espädayquiwan y garrutiquiwan shapäcamushcanqui? ");
INSERT INTO qva_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Waran warantag gamcunawan templuchru carä. Imaypis mana charipäcamarayquichu. Ichanga höra chrayamusha gamcunapis y Satanaspis munangayquicunata rurapäcunquipag”. ");
INSERT INTO qva_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Chauraga Jesusta prësu charircur cüracunapa mas mandagninpa wasinman apapäcuran. Payta prësu apacuptinmi Pedro caru guepalanta gatiraran. ");
INSERT INTO qva_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Chaymi sawan rurichru ninata ratarcachir runacuna mashacurcaran. Chayman yaycurirmi Pedrupis paycunawan mashacuycaran. ");
INSERT INTO qva_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Chaymi juc uyway jipash, Pedro mashacuycagta ricaraycanganchru niran: “Cay runapis Jesuswanmi puriran”. ");
INSERT INTO qva_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Chayta mayaycurmi Pedro niegaran: “Nogaga payta manam reguïchu”. ");
INSERT INTO qva_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mas rätuntanam juc runapis payta ricaycur niran: “Gampis paywan puregmi caycanqui”. Niptinmi Pedro niran: “Manam”. ");
INSERT INTO qva_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Chaypita juc höratanuy jucna niran: “Rasunpam cay runaga paywan caycasha. Galilea runam canpis”. ");
INSERT INTO qva_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Chaynuy niptinmi Pedro niran: “Manam musyächu imapita niycämangayquitapis”. Pedro chaynuy niycaptinrämi gällu cantamuran. ");
INSERT INTO qva_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Chauraga Señor Jesús muyurcur ricäriptinmi Pedro jucla yarparan Jesús caynuy ninganta: “Canan chacay manarag gällu cantaptinmi quimsa cutina reguimangayquita niegamanqui”. ");
INSERT INTO qva_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Chauraga Pedro wagtaman yargurir pasaypa laquicur wagaran. ");
INSERT INTO qva_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Chaypitanam prësu chararag runacuna asipar Jesusta magapäcuran. ");
INSERT INTO qva_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ñawinta chaparcur lagyapäcuran: “Willacog car nimay: ¿Pitag lagyashushcanqui?” ");
INSERT INTO qva_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Chaynuy nir tucuyta ashlipäcuran. ");
INSERT INTO qva_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pacha wararcuptinnam Israel mayor runacunapis, cüracunapa mandagnincunapis y Moisés escribingan leycunata yachrachegcunapis shuntacäpäcuran. Chaymanna Jesusta apaycur tapupäcuran: ");
INSERT INTO qva_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Willapäcamay. ¿Rasunpachu gam Tayta Dios cachramungan Salvador caycanqui?” Chauraga Jesús niran: “ ‘Dios cachramungan Salvadurmi cä’ niptïpis gamcunaga manam criyimanquipächu. ");
INSERT INTO qva_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Gamcunata tapuptïpis manam willamanquipächu. ");
INSERT INTO qva_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Cananpitaga noga Diospita shamusha Runa jamacushag imaycapäpis munayniyog Tayta Diospa derëchacag lädunchru mandanäpag”. ");
INSERT INTO qva_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Chaypita lapan runacuna tapupäcuran: “Chauraga ¿gam Diospa Wamranchu caycanqui?” Chaynuy niptinmi Jesús niran: “Gamcuna nircanqui noga cangäta”. ");
INSERT INTO qva_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Chauraga paycuna nipäcuran: “¡Imapänatag pitapis ashishun paypita willamänanchipag! Quiquinpa shiminpita chayta mayashcanchina”. ");
INSERT INTO qva_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Chaypitana chaychru cag lapan runacuna sharcurcur Pilätucagman Jesusta apapäcuran. ");
INSERT INTO qva_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Chaychrünam Pilätuta nipäcuran: “¡Cay runata taripäcushcä mana alicunata yachraycächegtam! Manam munanchu impuestuta runacuna pägapäcunanta. Chaynuypis niycan Tayta Dios cachramungan Salvador canganta y nogacunapa mandagnï canganta. Chaynuy mandagtucur puregcäga wañuchisha cachun”. ");
INSERT INTO qva_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Chaymi Jesusta Piläto tapuran: “¿Gamchu Israel runacunapa Reynin canqui?” Jesús niran: “Gam nishcanqui”. ");
INSERT INTO qva_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Chauraga Piläto niran cüracunapa mandagnincunata y chaychru shuntacasha runacunatapis: “Manam ima juchantapis tarïchu cay runapata”. ");
INSERT INTO qva_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Chaynuy niptin paycunaga masrag nipäcuran: “¡Manam! ¡Mandagninchipa contran sharcapäcunanpämi yachrachisha! Galilea provinciachru yachrachingannuylam canan cay Judea provinciachrüpis yachraycächin”. ");
INSERT INTO qva_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Chayta mayar paycunata Piläto tapuran: “¿Rasunpachu Galileapita cay runa?” nir. ");
INSERT INTO qva_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","“Au, Galileapitam” nipäcuran. Chaymi Galilea provinciapa gobernadurnin Herodes captin “Herodisrag juzgachun Jesusta” nir paycagman Jesusta apachiran. Chay junagcuna Jerusalenchrümi Herodes caycaran. ");
INSERT INTO qva_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jesuspita parlangancunata mayarmi unaypitana Herodes ricayta munaran milagruta ruraycagta. Chaymi Jesusta ricaycur cushicuran. ");
INSERT INTO qva_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Chaychru yapar yaparir Herodes tapuptinpis Jesús manam imatapis rimacuranchu. ");
INSERT INTO qva_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Chaychrümi cüracunapa mandagnincunawan Moisés escribingan leycunata yachrachegcunapis Jesuspa contran fiyupa nipäcuran. ");
INSERT INTO qva_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Chauraga Herodes y soldäduncunawan Jesusta asipäpäcuran. Jatipäpäcuran mandagpa röpantanuy. Nircurnam cutichipäcuran Pilätucagman. ");
INSERT INTO qva_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Chay junagpitanam Herodiswan Piläto puntata chriquinacunganpita alina ricanacäriran. ");
INSERT INTO qva_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Jesusta chrayachiptinnam Piläto gayachiran cüracunapa mandagnincunata, autoridäcunata y waquin runacunatapis. ");
INSERT INTO qva_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Chaychrünam paycunata niran: “Gamcuna cay runata apapäcamushcanqui: ‘Cay runaga runacunata yachraycächin mandagninchipa contran sharcapäcunanpag’ nir. Ricarcaptiqui tapur manam ima juchantapis contran nipäcungayquinuyga tarishcächu. ");
INSERT INTO qva_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Chaynuymi Herodispis mana tarishachu ima juchantapis. Chaymi cayman cutichimusha. Tantiyacäriy. Wañuchisha cananpag manam ima juchanpis canchu. ");
INSERT INTO qva_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Chaymi payta astircachir cachrariycushag”. ");
INSERT INTO qva_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Cada watam Pascua fiestachru juc prësuta Piläto cachrarinan caran. ");
INSERT INTO qva_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Chauraga Jesusta cachrariyta munaptin lapan gaparpaypa nipäcuran: “¡Wañuchiy paytaga! ¡Barrabasta ichanga cachrariycuy!” nir. ");
INSERT INTO qva_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barrabás carcilchru wichrgaraycaran Jerusalenchru Romapa autoridänincunapa contran sharcunganpita y runata wañuchinganpitam.) ");
INSERT INTO qva_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Chaymi Piläto yapay runacunata niran Jesusta cachrarinanpag. ");
INSERT INTO qva_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Niptinpis masrämi gaparpaypa nipäcuran: “¡Crucificächiy! ¡Crucificächiy!” nir. ");
INSERT INTO qva_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Chauraga Piläto yapay niran: “¿Imatatag mana alita rurasha? Manam tarïchu ima juchantapis wañuchisha cananpag. Astircachirmi cachrariycushag”. ");
INSERT INTO qva_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","25","Chaynuy niptinpis runacuna masrag gaparaypa nipäcuran crucificächinanpag. Chauraga Jesusta runacunaman Piläto entregaycuran crucificasha cananpag. Runacuna munapäcungannuylam Barrabasta cachrariran Romapa autoridänincunapa contran sharcusha y runata wañuchisha caycaptinpis. ");
INSERT INTO qva_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Chaypita Jesusta crucificänanpag aparcaptinmi chracrapita chrayaycämog Cirene marcapita Simonta charipäcuran. Chauraga Jesús apaycangan cruzta paytanam umruchiran Jesuspa guepanpa apananpag. ");
INSERT INTO qva_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Achca runacunam Jesuspa guepanta aywapäcuran. Chaychrümi achca warmicunapis laquicuypita wagaraycar aywapäcuran. ");
INSERT INTO qva_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Chaymi wagaycag warmicunata Jesús niran: “Jerusalén warmicuna, ama nogapäga wagapäcuychu. Chaypa truquinga nacanayquipag canganpita wagapäcuy wawayquicunapag y quiquiquicunapag. ");
INSERT INTO qva_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Fiyupa nacaycunam chrayamunga. Chaymi laquicuypita runacuna nipäcunga: ‘¡Ima cushisharag carcan wawaynag warmicuna!’ ");
INSERT INTO qva_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Chaychrümi runacuna nacayta mancharir puntacunatapis: ‘¡Janäcunaman juchrumuy jucla wañupäcunäpag!’ nipäcunga. ");
INSERT INTO qva_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nogatapis caynuy nacaycächimarga ¡ima fiyuparag gamcunataga nacachipäcushunqui!” ");
INSERT INTO qva_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Crucificänanpag Jesusta apar ishcay juchasapa runacunatapis apapäcuran Jesuspa lädunman crucificänanpag. ");
INSERT INTO qva_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Calavëra ninganman chrayaycärichirmi Jesusta cruzman clävapäcuran. Apapäcungan juchasapa runacunatapis crucificaran jucnincagta Jesuspa derëchancagman y jucagtana ichognincagman. ");
INSERT INTO qva_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Chay höram Jesús niran: “Taytalä, cay crucificämag runacunata perdunayculay. Manam musyapäcunchu imata ruraycangantapis”. Soldäducunanam Jesuspa röpancunata mayganpis apacärinanpag surtiyapäcuran. ");
INSERT INTO qva_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Chaychru runacuna ricararcaptin autoridäcuna Jesusta asiparan caynuy nir: “Juctaga salvaran. Cananga, mä, Dios cachramungan Salvador, Dios Acrangancag carga quiquin salvacuchun”. ");
INSERT INTO qva_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Chaynuylam soldäducunapis asipar Jesusta shoguchiran puchgog vïnuta: ");
INSERT INTO qva_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Israel runacunapa Reynin carga, mä, quiquiqui salvacuy” nir. ");
INSERT INTO qva_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Uman janaganman letrëruta chrurapäcuran caynuy escribishata: “Cayga Israel runacunapa Reyninmi” nir. Chayga escribiraycaran griego, latín y hebreo rimaycunachrümi. ");
INSERT INTO qva_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Chaypitana jucag crucificaraycag runa olgüpar niran: “Gam Dios cachramungan Salvador carga, mä, chaypita salvacuy. Nircur nogacunatapis caypita salvapäcamay”. ");
INSERT INTO qva_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Chaynuy niptinmi jucnincag olgüparan: “Gampis paynuy nacaycarga ¿manachu Diosta manchacunqui? ");
INSERT INTO qva_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Noganchega juchanchicunapitam nacaycanchi. Paypaga manam ima juchanpis canchu”. ");
INSERT INTO qva_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nircur Jesusta niran: “Jesús, mandag canayquipag cutimur yarpämanqui”. ");
INSERT INTO qva_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Niptinmi Jesús niran: “Rasunpam gamta nï: Cananmi nogawan Taytäpa ñaupagninchru canquipag”. ");
INSERT INTO qva_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Chauraga pulan junagpita mallway inticama inti mana achicyaptin intëru pacha chacacäcuran. Chay höra templo rurinchru cortïnapis pulanpa rachricäcuran. ");
INSERT INTO qva_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Chaypitam Jesús fiyupa niran: “¡Taytalä! ¡Almäta munayniquimanmi chruraycämü!” Nircur wañuriycuran. ");
INSERT INTO qva_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Chauraga chaycunata ricaycurmi soldäducunapa capitannin Tayta Diosta alabaran: “¡Rasunpam cay runaga juchaynag casha!” nir. ");
INSERT INTO qva_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Chayta ricaycurmi lapan ricapaycagcunaga fiyupa laquicur pëchunta cutar aywacuran. ");
INSERT INTO qva_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jesuswan reguinacogcunam y Galileapita payta gatirag warmicunapis carulapita ima pasangantapis ricararcaran. ");
INSERT INTO qva_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Juc runam caran Dios munangannuy cawag y Tayta Diospa munaynin chrayananpag canganta shuwarag. Paypa José jutin caran. Chay runapa marcan caran Judea provinciachru Arimatea. Paypis caran Israel mayor autoridämi. Waquin autoridäcuna Jesusta wañuchinanpag parlanacäriptinpis payga manam chaynuychu yarparan. ");
INSERT INTO qva_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Paymi Pilätuta rugacuran Jesuspa cuerpunta cruzpita jorgurcur pampag apananpag. ");
INSERT INTO qva_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Piläto auniptinmi Jesuspa cuerpunta cruzpita jorgurcur lïnupita awasha säbanaswan wancuran. Nircur manarag pipis pampacungan gagachru uchrcusha sepultüraman pampag aparan. ");
INSERT INTO qva_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Chay höra sábado jamay junag galaycunanpänam caycaran. ");
INSERT INTO qva_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galileapita Jesuswan shamog warmicuna Josëta gatiraran Jesuspa sepultüran maychru cangantapis musyapäcunanpag. Chaychru ricapäcuran Jesuspa cuerpunta imanuy chrurangantapis. ");
INSERT INTO qva_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Chaypita wasinman cutiycärir camaricäriran perfümita Jesuspa cuerpunman gaycapänanpag. Camaricurcurnam Tayta Dios escribichinganchru ningannuy sábado jamay junag captin jamapäcuran. ");
INSERT INTO qva_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Chaypita semäna galarinan junag tuta chaca chacala Jesús pamparangancagman, camaringan perfümita apacurcur warmicuna aywapäcuran. ");
INSERT INTO qva_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Chrayapäcunanpäga sepultüra chaparag rumi juc läduman ashuchisha caycänag. ");
INSERT INTO qva_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Chayman yaycur manam taripäcurannachu Jesuspa cuerpunta. ");
INSERT INTO qva_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Chaymi manchacasha ricacur ima ruraytapis mana camäpacäriranchu. Chaynuy carcaptinmi ishcay runacuna chipipaycag röpasha paycunapa ñaupagninchru ricacuran. ");
INSERT INTO qva_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Chaymi paycunata ricaycur pasaypa mancharir gongurpacaycäriran. Chauraga chay runacunanam nipäcuran: “¿Imanirtag wañushacuna cangancagchru cawarimushana caycagta ashircanqui? ");
INSERT INTO qva_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Yarpäpäcuy Galilea provinciachru caycar Diospita shamusha Runata juchasapa runacunapa maquinman entregasha cananpag canganta nipäcushungayquita. ¿Manachu chaychru nipäcushushcanqui Diospita shamusha Runata crucificaypa wañuchipäcuptinpis quimsa junagtaga cawarimunanpag canganta?” ");
INSERT INTO qva_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Chaynuy niptinmi Jesús chaynuy ningancunata paycuna yarpäpäcuran. ");
INSERT INTO qva_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Chaymi Jesús pamparangancagpita cutiycärir willaran chrunca juc (11) apostulcunata y chaychru cag runacunatapis. ");
INSERT INTO qva_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Chay willapagcunaga caran María Magdalena, Juana, Santiagupa maman María y paycunawan aywag warmicuna. ");
INSERT INTO qva_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Warmicuna chaynuy willapäcuptinpis löcutaycanganta yarpar apostulcuna manam criyipäcuranchu. ");
INSERT INTO qva_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pedrum ichanga cörriypa aywaran Jesusta pampapäcungancagman. Pamparangancagta arcaycurmi säbanaslatana ricaran. Chaylatana tariycurmi almirasha cuticuran. ");
INSERT INTO qva_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Chay junagmi Jesuspa ishcay discïpuluncuna aywarcaran Emaús marcaman. Emaús caran Jerusalenpita ishcay lëwanuy. ");
INSERT INTO qva_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Paycunaga Jesús wañunganpita parlaraycar aywarcaran. ");
INSERT INTO qva_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Chaynuy parlaraycar aywarcaptinmi Jesús taripaycur paycunawan iwal aywaran. ");
INSERT INTO qva_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Chaynuy paycunawan aywaycaptinpis manam tantiyapäcuranchu Jesús canganta. ");
INSERT INTO qva_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Chaymi Jesús tapuran: “¿Imapita parlartag aywarcanqui?” Chaynuy niptin laquisha ichricaycäriran. ");
INSERT INTO qva_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Chauraga Cleofas jutiyog runa niran: “Pascua fiestaman shamog runacunapis chaypitaga lapanmi musyapäcun cay junagcuna Jerusalenchru ima pasangancunatapis. ¿Manachu gam musyanqui?” ");
INSERT INTO qva_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Niptinmi Jesús tapuran: “¿Imatag casha?” nir. Paycuna nipäcuran: “Nazaret marcapita Jesusmi Tayta Diospa willacognin caran. Paymi Tayta Diospa munayninwan alicunata rurar Tayta Dios ningancunata lapan runacunata willaparan. Chay ningancunam y rurangancunam pï maypäpis ali caran. ");
INSERT INTO qva_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Paytam cüracunapa mandagnincunawan lapan autoridäcuna Pilätuman entregäpäcusha crucificaypa wañuchinanpag. ");
INSERT INTO qva_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nogacuna yarpäpäcurä chriquimagninchicunapa munayninpita pay jorgamänanchipag canganta. Canan junagwanga quimsa junagnam wañungan. ");
INSERT INTO qva_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Canan tuta nogacunawan cag waquin warmicuna manchacächipäcamasha. Paycunam Jesusta pampapäcungancagman chaca chacala aywar cuerpunta mana taripäcushanachu. Chaypita wasiman cutiycamur willapäcamasha Jesús cawarimunganta. Angilcuna ricariparcur paycunata Jesús cawarimunganta willasha. ");
INSERT INTO qva_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Chauraga waquincag discïpuluncunapis pamparangancagman aywar warmicuna willacungannuylam Jesuspa cuerpunta mana taripäcushachu. Chaynuypis Jesús cawarimusha caycagta manam ricapäcuranchu”. ");
INSERT INTO qva_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","26","Chaymi paycunata Jesús niran: “Dios cachramungan Salvador wañunganpita cawarimur Diospa ñaupagninman cutinanpäga nacananrämi caran. ¿Imanirtag gamcuna mana tantiyapäcunquichu? ¿Imanirtag sasatarag criyipäcunqui Tayta Diospa willacognincuna ningancunatapis?” ");
INSERT INTO qva_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Chaynuy nirmi paycunata tantiyachiran quiquinpag imanuy escribiraycangantapis. Chaynuy yarpächiran Moisés escribingan leycunapita galaycur Diospa willacognincuna escribingancama. ");
INSERT INTO qva_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Chaymi Emaús marcaman chrayaycärirna paycunapita Jesús pasagtucuran. ");
INSERT INTO qva_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pasacuyta munaptinmi payta quëdachipäcuran: “Pacha chacaycannam. Caylachrüna quëdacushun” nir. Chaynuy niptinmi Jesús paycunawan quëdacuran. ");
INSERT INTO qva_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Chaypita mësacagman Jesús jamaycurnam tantata aptarcur Tayta Diosta agradecicuran. Nircurna partir partircur paycunata aypuran. ");
INSERT INTO qva_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Chauraga chay höram Jesús canganta reguipäcuran. Jesús canganta reguiräriptinnam illacäcuran. ");
INSERT INTO qva_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Illacaruptinnam quiquinpura caynuy ninacäriran: “¡Jesusmi casha! ¡Rasuntachrar camiñuchru Tayta Dios escribichinganta parlapämanganchi höra shongunchipis cushicuran!” ");
INSERT INTO qva_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Chauraga chay höra jucla Jerusalenman cuticäriran. Chrayaycurnam chrunca juc (11) apostulcunata y waquin discïpuluncunatapis taripäcuran. ");
INSERT INTO qva_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Chrayaycäriptinnam paycunata apostulcuna caynuy willaparan: “¡Rasunpam Señor Jesús cawarimusha! ¡Simontapis ricaripasham!” ");
INSERT INTO qva_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Niptinnam paycunapis willaparan camiñuchru ima pasangancunatapis, y tantata Jesús partingan höra payta reguipäcungantapis. ");
INSERT INTO qva_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Chaynuy parlarcaptinmi mayänipita Jesús paycunapa chraupinchru ricacuran: “Jauca cawapäcuy” nir. ");
INSERT INTO qva_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Chauraga paycuna alma canganta yarpar fiyupa manchacäpäcuran. ");
INSERT INTO qva_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Chauraga Jesús niran: “¿Imanirtag manchacasha carcanqui? ¿Imanirtag noga cangäta mana criyipäcunquichu? ");
INSERT INTO qva_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ricapäcuy maquïta y chraquïtapis. Nogam caycä. Yatapäcamay. Yarpäpäcungayquinuypis manam almachu cä. Almaga aychaynag y tulluynagmi”. ");
INSERT INTO qva_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Chaynuy nir ricachiran maquinta y chraquintapis. ");
INSERT INTO qva_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Chauraga pay canganta ricaycur lapan cushicäriran. Chaynuy cushicurpis manarämi criyipäcuranchu. Chaynuy mana criyiptinmi Jesús tapuran: “¿Imalapis micunäpag caycanchu?” nir. ");
INSERT INTO qva_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Chaynuy niptinmi juc partin cancasha pescädutawan urunguypa mishquinta micunanpag gopäcuran. ");
INSERT INTO qva_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Chaytam paycuna ricaycaptin micuran. ");
INSERT INTO qva_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Micucurcurnam niran: “Moisés, Tayta Diospa willacognincuna y salmucunata escribegcunapis lapanmi escribipäcuran nogata ima pasamänanpag cagpita. Gamcunawan caycar willarä lapan chay escribiraycangancuna cumplinanpag canganta. Chay willangänuylam pasamasha”. ");
INSERT INTO qva_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Chaynuy nirmi Tayta Dios escribichingancunata tantiyachiran. ");
INSERT INTO qva_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nircur niran: “Noga Dios cachramungan Salvador wañunäpag y wañungäpita quimsa junagta cawarimunäpag cangan escribiraycanmi. ");
INSERT INTO qva_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","48","Musyapäcungayquinuypis chay escribirangannuylam lapanpis pasasha. Chaymi nogapa jutïchru runacunata willapänayqui juchacunapita wanacunanpag. Chaynuypam Tayta Dios perdunanga juchäcungancunata. Jerusalenpita galaycur may chaypapis aywar lapan runacunata chaynuy willapanqui. ");
INSERT INTO qva_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nogam gamcunaman Taytä promitingan Santu Espirituta cachramushag. Ichanga Jerusalenlachru shuwararcay Diospa munayninta cielupita chrasquipäcungayquicama. Santu Espirituta chrasquingayquicama. Chrasquicurnam Diospa munayninwanna capäcunqui”. ");
INSERT INTO qva_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Chaypita apostulnincunata Jerusalenpita Betaniaman Jesús pusharan. Chaychru caycarna maquinta jogarcur paycunata yanapänanpag Tayta Diosta rugacuran. ");
INSERT INTO qva_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Chaynuy paycunapag rugacuycarnam aywacuran y cielumanna apacuran. ");
INSERT INTO qva_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Chaychru apostulcuna Jesusta adorarcärirmi Jerusalenman cushisha cuticäriran. ");
INSERT INTO qva_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tayta Diosta alabänanpag waran waran templuman aywapäcog. Amén.");
INSERT INTO qva_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Imapis manarag captin Willacog caycarannam. Chay Willacüga Tayta Dioswanmi caycaran. Diosmi caran. ");
INSERT INTO qva_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Imapis manarag captin Willacog Tayta Diosninchiwanmi caycaran. ");
INSERT INTO qva_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Lapan imaycatapis paywanmi Tayta Dios camachiran. Lapan imaycapis cagcuna pay mana captinga manam camashachu canman caran. ");
INSERT INTO qva_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Paychrümi caway caycaran. Chay cawaymi achquinuy lapan runapag caran. ");
INSERT INTO qva_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Achqui yananyagchru achicyaycan. Achquita yananyag upichiyta mana puedishachu. ");
INSERT INTO qva_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Juan jutiyog runatam Tayta Diosninchi cachramuran. ");
INSERT INTO qva_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Paytam cachramuran achquinuypis caycag runapita willacunanpag y willacungancunata lapan criyipäcunanpag. ");
INSERT INTO qva_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan manam achquinuypis caycag runachu caran. Sinöga achquinuypis caycag runapita willacunanpämi cachramuran. ");
INSERT INTO qva_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Achquinuy caycag runa cay pachaman shamuran runacunapag achquinuy cananpämi. ");
INSERT INTO qva_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Pay cay pachachru caran. Cay pachata paywan Tayta Dios camachisha caycaptinpis cay pachachru cagcuna pï pay cangantapis manam reguipäcuranchu. ");
INSERT INTO qva_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Pay quiquinpa naciunninman shamuran. Ichanga chaychru runacuna payta manam chrasquicäriranchu. ");
INSERT INTO qva_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ichanga chrasquicog y yäracog runacunataga Tayta Diospa wamrancuna cananpag pay chruraran. ");
INSERT INTO qva_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tayta Diosninchipa wamrancuna caran manam maman taytan munayninpachu sinöga Tayta Dios munayninpam. ");
INSERT INTO qva_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Willacogmi runaman ticraran y nogacunachru tiyaran. Pay Tayta Diospa japalan Wamranmi. Chaymi payta ricar quiquin Tayta Diosta ricagnuyna capäcurä. Pay shumag cuyapag y Tayta Diospita rasuncaglata willacog. ");
INSERT INTO qva_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Paypitam Juan caynuy willacuran: “Paypämi noga nirä: ‘Nogapa guepäta shamogcäga nogapita mas munayniyogmi. Noga manaräpis captï maynam caycaranna’ ” nir. ");
INSERT INTO qva_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Jesucristo pasaypa cuyapämashpanchim pay yanapämashcanchi. Pay yaparir yaparirmi yanapämashcanchi. ");
INSERT INTO qva_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Leynincunataga Moiseswanmi Tayta Dios willacachiran. Jesucristum ichanga Tayta Diospa cuyacuyninta y paypa rasuncag willacuyninta tantiyachimashcanchi. ");
INSERT INTO qva_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Manam pipis Tayta Diosta ricashachu. Japalan Wamranmi paypita musyachimashcanchi. Paymi Dios y paymi imaypis Taytanwan caycan. ");
INSERT INTO qva_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusalenpita Israel runacunapa autoridänincuna cüracunata y Leví casta runacunata Juan pï cangantapis tapumunanpag cachrapäcuran. ");
INSERT INTO qva_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Chauraga Juan rasuncagta niran: “Noga manam Tayta Dios cachramungan Salvadurchu cä”. ");
INSERT INTO qva_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Niptin yapay tapupäcuran: “Chauraga ¿pitag caycanqui? ¿Tayta Diospa unay willacognin Eliaschu?” Juan niran: “Manam paychu cä”. Chauraga yapay tapupäcuran: “Chauraga ¿shamunanpag cag Diospa willacogninchu caycanqui?” Niran: “Manam”. ");
INSERT INTO qva_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nipäcuran: “Chauraga ¿pitag caycanqui, ari? Nogacuna pï cangayquitapis willapäcunämi cachrapäcamagnï autoridäcunata. Nipäcamay pï cangayquitapis”. ");
INSERT INTO qva_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juan niran: “Tayta Diospa willacognin Isaías nogapämi caynuy niran: Nogaga caycä chunyag jircachru fiyupa gayaraycar willacognuymi: ‘Mandag runa shamunanpag camiñucunata pichar camaricäringayquinuy camaricäriy Señurta chrasquicärinayquipag’ nir”. ");
INSERT INTO qva_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Juanta tapunanpag fariseo runacuna cachrangancuna ");
INSERT INTO qva_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","tapuran: “Ni Tayta Dios cachramungan Salvador, ni Elías, ni shamunanpag cag willacogpis mana caycarga ¿imanirtag bautizanqui?” ");
INSERT INTO qva_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan niran: “Nogaga bautizä yacuwan. Ichanga gamcunachru juc caycagta gamcuna manam reguipäcunquichu. ");
INSERT INTO qva_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Pay shamunga nogapa guepätarämi. Noga manam välïchu llanquinpa watunta pascapänaläpäpis”. ");
INSERT INTO qva_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Cay lapan pasaran Betaniachrümi. Chay caran Jordán mayupa jucag lädunchru. Chaychrümi runacunata Juan bautizaycaran. ");
INSERT INTO qva_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Warantin junag Juan ricaran Jesusta paycagman ashuycuycagta. Ricarmi niran: “¡Paymi Diospa Carnin! ¡Paymi lapan runapa juchan perdunan! ");
INSERT INTO qva_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Paypämi noga nirä: ‘Nogapa guepäta shamogcäga nogapita mas munayniyogmi. Pay noga manaräpis captï maynam caycaranna’ nir. ");
INSERT INTO qva_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Noga quiquïpis manam musyarächu pï cangantapis. Ichanga yacuwan bautizaycarä Israel runacuna musyananpag”. ");
INSERT INTO qva_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Juan mastapis niran: “Santu Espirituta ricashcä palumatucular cielupita yarpaycämogta. Chaypita paypa jananman ichregta. ");
INSERT INTO qva_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Noga manarämi musyarächu pï cangantapis. Ichanga yacuwan bautizänäpag cachramag nimasha caran: ‘Pimanmi Santu Espíritu cielupita yarparcamur ichriycagta ricanqui paymi Santu Espirituwan bautizan’. ");
INSERT INTO qva_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nogaga ricashcänam. Chaymi gamcunata willä pay Tayta Diospa Wamran canganta”. ");
INSERT INTO qva_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Warantin junag Juan ishcay discïpuluncunawan yapay chaychru caycaran. ");
INSERT INTO qva_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jesús pasaycagta ricar Juan niran: “¡Ricapäcuy! ¡Paymi Diospa Carnin!” ");
INSERT INTO qva_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Chauraga Juan chaynuy ninganta mayaycur ishcan discïpuluncuna Jesusta gaticurcur aywacäriran. ");
INSERT INTO qva_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesús muyurcunganchru gatiraycagta ricar tapuran: “¿Imatatag ashircanqui?” nir. Paycuna nipäcuran: “Rabí (chay ninan ‘maestro’ ninanmi), ¿maychrütag tiyaycanqui?” ");
INSERT INTO qva_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesús niran: “Acu, reguichishayqui”. Chauraga aywapäcuran. Ricapäcuran maychru tiyangantapis. Tardi las cuatru captinna Jesuswan chaychru quëdacäriran. ");
INSERT INTO qva_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Juan ninganta mayag y Jesusta gaticurcur pureg jucnincag caran Simón Pedrupa wauguin Andrés. ");
INSERT INTO qva_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Chaypita Andrés wauguin Simonta tariran y niran: “¡Taripäcushcä Tayta Dios cachramungan Salvadurta!” (“Tayta Dios cachramungan Salvador” ninan “Cristo” ninanmi.) ");
INSERT INTO qva_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Chaypitana Andrés pusharan wauguin Simonta Jesuscagman. Ricaycurna Jesús niran: “Simón, gam Juanpa wamranmi caycanqui. Cananpitaga Cefasnam jutiqui canga”. (“Cefas” y “Pedro” “gaga” ninanmi.) ");
INSERT INTO qva_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Warantinna Galilea provinciapa Jesús aywayta yarparan. Felipita tarirna niran: “Nogawan aywashun”. ");
INSERT INTO qva_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe caran Betsaida marcapitam. Andreswan Pedrupis chay marcalapitam caran. ");
INSERT INTO qva_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipe asheg aywaran Natanaelta. Chaychrünam niran: “¡Tincupäcushcä Moisés leycunata escribinganchru y Tayta Diospa willacognincuna escribinganchru ningannuy runawan! Payga Josëpa wamran Nazaretpita Jesusmi”. ");
INSERT INTO qva_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael niran: “¿Nazaretpita ima alipis yargamunmanchurag?” Felipe niran: “Acu, aywashun ricanayquipag”. ");
INSERT INTO qva_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Aywaycämogta ricar Natanaelpag Jesús niran: “Tagay runaga rasunpam Israel runa. Payga rasun caglata imatapis riman”. ");
INSERT INTO qva_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Chauraga Natanael tapuran: “¿Imanuypatag gam reguimanqui?” Jesús niran: “Gamta ricashcä manaräpis Felipe gayashuptiqui hïgus yüra chraquinchru jamaraycagta”. ");
INSERT INTO qva_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael niran: “¡Maestro, gam Diospa Wamranmi caycanqui! ¡Gam Israel runacunapa mandagnin Reymi caycanqui!” ");
INSERT INTO qva_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús niran: “¿Criyimanqui hïgus yüra chraquinchru jamaraycagta ricangäta ningaläpitachu? Cananpitaga masmi imaycatapis ricanquipag”. ");
INSERT INTO qva_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Chaynuypis Jesús niran: “Rasunpam gamcunata nï: Gamcuna cielo quichraraycagta ricapäcunquipag. Noga Diospita shamusha Runacagpita Tayta Diospa angilnincuna cieluman jegaycagta y yarpaycämogta ricapäcunqui”. ");
INSERT INTO qva_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Chaypita quimsa junagta Caná marcachru casaray fiesta caran. Caná caran Galilea provinciachru. Chaychrümi Jesuspa mamanpis caycaran. ");
INSERT INTO qva_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesús y discïpuluncunapis chay fiestamanmi gayachisha capäcuran. ");
INSERT INTO qva_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Chaychru vïno ushacäcuran. Ushacaruptin Jesusta maman niran: “Vïnun ushacashana”. ");
INSERT INTO qva_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesús mamanta niran: “¿Imanirtag chayta nimanqui? Manarämi hörä chrayamunrächu”. ");
INSERT INTO qva_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Maman sirvicogcunata niran: “Pay nishungayquicunata rurapäcuy”. ");
INSERT INTO qva_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Chaychru caycaran rumipita rurasha sogta urpucuna. Chay urpucuna caran yacuta wiñananpag Israel runacunapa costumbrin cangannuy maquinta mayllacärinanpag. Chay urpucunamanmi yaycog ganchris chrunca (70) litro yacu y waquinmannam yaycog pichga chrunca (50) litro yacu. ");
INSERT INTO qva_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús sirvicogcunata niran: “Lapan urpucunaman yacuta wiñapäcuy”. Chauraga urpuman juntangancama yacuta wiñapäcuran. ");
INSERT INTO qva_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jesús niran: “Cananga ichiclata jorgurir mayor sirvicogman apapäcuy”. Ningannuy apapäcuran. ");
INSERT INTO qva_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Chaymi yacupita ticrasha vïnuta mayor sirvicog maliran. Mana musyaranchu maypita apangantapis. (Yacuta jorgurcur apag sirvicogcuna ichanga musyaran.) Chay vïnuta malircurna casarag mösuta gayaycur ");
INSERT INTO qva_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","niran: “Lapan runacuna puntata alicag vïnutam jichracun. Gayachimusha runacuna machraruptinrämi mana alicag vïnutaga jichracun. Gam ichanga alicag vïnuta cay hörapärag chrurashcanqui”. ");
INSERT INTO qva_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Chay milagruta Galilea provincia Caná marcachru ruranganmi galaycunan milagrun caran. Chay milagruta ruraran payta Dios rasunpa cachramunganta musyacänanpag. Chaywanmi munayniyog canganta musyachicuran. Discïpuluncuna payman criyipäcuran. ");
INSERT INTO qva_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Chaypitanam mamanwan, wauguincunawan y discïpuluncunawan Jesús Capernaum marcaman aywacäriran. Chaychru ishcay quimsa junag goyäpäcuranrag. ");
INSERT INTO qva_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Israel runacunapa Pascua fiestan chrayaycämuptinnam Jerusalenman Jesús aywaran. ");
INSERT INTO qva_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Chrayarnam runacuna templuchru törucunata, üshacunata, palumacunata ranticurcagta tariran y guellay trucacheg runacuna jamararcagta tariran. ");
INSERT INTO qva_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Chaynuy tariycurmi cordilpita asticunata rurarcur üshantinta töruntinta templupita Jesús lapanta garguran. Guellayta trucachegcunapa guellaynintapis mashtariran y mësancunatapis ticpariran. ");
INSERT INTO qva_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nircur paluma ranticogcunata niran: “¡Caycunata jorgapäcuy! ¡Taytäpa wasinta mercädutanuy amana rurapäcuychu!” ");
INSERT INTO qva_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Chauraga discïpuluncuna yarpäpäcuran Tayta Dios escribichinganchru caynuy ninganta: “Imaycanuypapis gampa wasiquita respitächishämi”. ");
INSERT INTO qva_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Israel runacunapa autoridänincuna tapupäcuran: “¿Ima munayniyogtag canqui cay lapanta ruranayquipag? Mä, milagruta ruray munayniyog cangayquita musyapäcunäpag”. ");
INSERT INTO qva_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Nipäcuptin Jesús niran: “Cay templuta juchruchipäcuy. Quimsa junagtaga sharcarachishämi”. ");
INSERT INTO qva_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Israel runacunapa autoridänincuna nipäcuran: “Cay templuta chruscu chrunca sogta (46) watatam sharcachipäcuran. ¿Y gam quimsa junaglata sharcarichinqui?” ");
INSERT INTO qva_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Chaynuy templupag parlarpis Jesusga quiquinpa cuerpunpag parlaycaran. ");
INSERT INTO qva_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Chaymi Jesús wañunganpita cawarircamuptin discïpuluncuna yarpäpäcuran chaynuy ninganta. Y Tayta Diosninchi escribichinganchru Jesuspita escribiraycanganta y Jesús ninganpis rasuncag canganta criyipäcuran. ");
INSERT INTO qva_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jerusalenchru Pascua fiestachru Jesús caycaptin milagrucunata ruraran payta Dios rasunpa cachramunganta musyacänanpag. Milagrucunata ruragta ricar achca runacuna payman criyipäcuran. ");
INSERT INTO qva_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ichanga Jesús chay runacunaman manam yäracuranchu lapan runacuna imanuy caycangantapis musyar. ");
INSERT INTO qva_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Pay manam runa imata yarpangantapis pï willanantapis ashiranchu pay quiquinmi musyag pipis imata yarpaycangantapis. ");
INSERT INTO qva_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Juc fariseo runam caran Nicodemo jutiyog. Payga Israel runacunapa autoridäninmi caran. ");
INSERT INTO qva_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Paymi chacaylapa Jesús watucog aywaran. Chaychrümi niran: “Maestro, manam pipis gamnuy milagrucunata ruranchu paywan Tayta Dios mana captinga. Chaymi musyapäcü yachrachipäcamänayquipag Tayta Dios cachramushungayquita”. ");
INSERT INTO qva_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesús niran: “Rasunpam gamta nï: Pipis yapay mana yurirga Tayta Diospa munayninman manam chrayangachu”. ");
INSERT INTO qva_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemo tapuran: “¿Imanuypatag runacuna yapay yurinman auquisna caycarga? ¿Cutinmanchurag mamanpa pachranman yapay yurimunanpag?” ");
INSERT INTO qva_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús niran: “Rasunpam gamta nï: Pipis yacuwan y Santu Espiritupa munayninwan yapay mana yurirga manam Tayta Diospa munayninman chrayangachu. ");
INSERT INTO qva_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Pipis mamanpita taytanpita yuregcäga runalam. Espiritupita yuregcäga espiritum. ");
INSERT INTO qva_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Gamcuna ama almiräpäcuychu yapay yuripäcunayquipag ningäpita. ");
INSERT INTO qva_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Wayra maypapis munanganpam wayran. Wayrämogta mayarpis manam musyanquichu maypita shamungantapis ni maypa aywangantapis. Chaynuylam Santu Espiritupita yapay yurisha runacunapis caycan”. ");
INSERT INTO qva_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Niptinmi Nicodemo niran: “¿Imanuypatag chaynuy canman?” ");
INSERT INTO qva_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Chauraga Jesús niran: “Israel runacunapa yachrachegnin gam caycarga ¿manachu chayta tantiyanqui? ");
INSERT INTO qva_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Rasunpam gamta nï: Musyapäcungätam ricapäcungätam willapaycä. Chaynuy captinpis gamcunaga nipäcungäta mana criyipäcunquichu. ");
INSERT INTO qva_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Cay pachachru cagpita willapaptïpis mana criyiycämarga ¿imanuypatag criyipäcunqui cieluchru cagpita willapaptï? ");
INSERT INTO qva_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Manam pipis cieluman aywashachu sinöga cielupita shamoglam. Chay caycä noga Diospita shamusha Runalam. ");
INSERT INTO qva_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Moisés chunyag jircachru culebrata gueruman chruraycur ichrichingannuy noga Diospita shamusha Runapis gueruman chruraycur ichrichisharämi cashag. ");
INSERT INTO qva_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Chaynuy canga nogaman yäracamagcäga mana ushacaypa cawananpag”. ");
INSERT INTO qva_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Tayta Diosninchi runacunata pasaypa cuyaparmi japalan Wamranta cachramuran payman lapan yäracogcäga castïguman mana aywananpag sinöga mana ushacaypa cawananpag. ");
INSERT INTO qva_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tayta Diosninchega Wamranta manam runacuna castigasha cananpächu cachramuran sinöga pay cayninpa salvasha cananpämi. ");
INSERT INTO qva_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Tayta Diospa japalan Wamranman yäracogcäga castïguman manana aywananpänam caycan. Mana yäracogcagmi ichanga castïguman aywananpäna caycan. ");
INSERT INTO qva_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Mana yäracogcunaga castigasha cananpänam caycan. Paycunaga Jesús cay pachaman achquinuy cananpag shamusha captinpis mana chrasquicärishachu. Chaypa truquinga mana alita rurayninpa yananyagmannuypis juchata rurar cawapäcunanpag aywayta munapäcusha. ");
INSERT INTO qva_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mana alita ruragcunaga achquinuypis caycagta Jesusta chriquipäcun y achquinuy captin chrasquicuyta mana munapäcunchu mana alita ruraycangancuna mana musyacänanpag. ");
INSERT INTO qva_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Tayta Dios munangannuy cawagcagmi ichanga achquimannuypis ashuycun lapan pay munangannuy rurangancuna ricacänanpag. ");
INSERT INTO qva_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Chaypitanam Jesuswan discïpuluncuna Judea partiman aywapäcuran. Chaychrümi discïpuluncunawan goyäpäcuran y runacunata bautizaran. ");
INSERT INTO qva_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juan Bautista Enón partichru bautizaran. Chay caran Salim cercanchru. Chaychru bautizaran achca yacu captinmi. Runa aywagcäga bautizasha caran. ");
INSERT INTO qva_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Chay caran Juanta manaräpis carcilman wichrgaptinmi. ");
INSERT INTO qva_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Chaychrümi Juanpa discïpuluncuna Israel runawan purificaciunpita rabyachinacuyta galaycapäcuran. ");
INSERT INTO qva_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Chaymi Juanman aywapäcur willapäcuran: “Maestro, Jordán mayupa jucag lädunchru gamwan cangan runa y paypita willacungayqui cananga bautizaycan y lapan runacuna gatirarcan”. ");
INSERT INTO qva_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juan niran: “Manam pipis imatapis charanchu Tayta Diosninchipita mana chrasquisha carga. ");
INSERT INTO qva_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Gamcuna mayashcanquim ‘Noga Tayta Dios cachramungan Salvadurchu manam cä. Sinöga paypa ñaupagninta paypita willacunäpag cachramashalam cä’ ningäta. ");
INSERT INTO qva_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Casaray fiestachru casaraycag mösupam casarag jipashga. Casarag mösu parlaptin lädunchru caycag amïgun cushicungannuymi nogapis pasaypa cushicü. ");
INSERT INTO qva_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Cananga nogata mananam ricäripäcamanganachu. Paymannam runacuna aywapäcunga”. ");
INSERT INTO qva_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Cielupita shamogmi pï maypitapis mas munayniyog caycan. Cay pachachru cäga cay pachalapam. Y cay pachalapitam rimanpis. Cielupita shamogmi pï maypitapis mas munayniyog caycan. ");
INSERT INTO qva_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ricanganta y mayanganta willacuptinpis pipis manam chrasquicärinchu. ");
INSERT INTO qva_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Chrasquicogcunam ichanga Tayta Diosninchi ningan rasuncag canganta niycan. ");
INSERT INTO qva_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tayta Diosninchi cachramungan runaga Tayta Dios ningalantam riman. Chaynuy riman Tayta Dios payta juntagpag Santu Espiritunta gonganpitam. ");
INSERT INTO qva_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tayta Diosninchi Wamranta cuyanmi. Chaymi imaycatapis paypa munayninman chrurasha. ");
INSERT INTO qva_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Tayta Diospa Wamranman yäracogcäga mana ushacaypanam cawayta chrasquisha. Wamranta mana cäsucogcagmi ichanga mana ushacaypa cawayta mana chrasquingachu. Chaypa truquinga Tayta Diosninchipa fiyupa castïguntam chrasquinga. ");
INSERT INTO qva_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Fariseo runacunam musyapäcuran Juan Bautistapa discïpuluncuna canganpita Jesuspa discïpuluncuna mas canganta y Jesús mas achca discïpulucunata bautizaycanganta. ");
INSERT INTO qva_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Manam Jesuschu bautizaran sinöga discïpuluncunam.) ");
INSERT INTO qva_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Chayta mayaycurmi Jesús Judeapita Galileaman cutiran. ");
INSERT INTO qva_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Galileaman aywar Samaria provinciaparämi pasapäcunan caran. ");
INSERT INTO qva_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Chrayapäcuran Samariachru cag Sicar jutiyog marcaman. Chay caran Jacob wamran Josëta gongan chracra cercan. ");
INSERT INTO qva_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Chaychrümi caran Jacob yacuta jorgunan pözun. Jesús uticasha chrayaycur chay pözu cantunman jamaycuran. Chay caran pulan junagnuy. ");
INSERT INTO qva_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Chayman chrayaran Samaria warmi yacuta jorgunanpag. Chauraga Jesús niran: “Yaculayqui”. ");
INSERT INTO qva_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Chay caran marcaman discïpuluncuna micuyta ranteg aywapäcungancama.) ");
INSERT INTO qva_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Yacuta mañacuptinmi Samaria warmi niran: “¿Imanirtag gam Israel runa caycar Samaria warmi caycaptï yacuta mañacamanqui?” Chaynuy niran Israel runacuna Samaria runacunawan mana ali ricanacurmi. ");
INSERT INTO qva_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesús niran: “Tayta Dios goshunayquipag cagta y pï yacuta mañacuycäshungayquita musyarga gampis mañacunquimanmi. Mañacuptiqui cawachicog yacutam pay goshunquiman”. ");
INSERT INTO qva_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Chay warmi niran: “Tayta, yacuta jorgunayquipag imayquipis mana caycaptinga y pözupis ruri caycaptinga ¿maychrütag chay cawachicog yacu caycan? ");
INSERT INTO qva_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ayllü Jacobmi cay pözuta jaguipäpäcamasha. Cay pözupitam quiquinpis wamranpis y uywancunapis yacuta upuran. ¿Gam paypita mas munayniyogchu caycanqui?” ");
INSERT INTO qva_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Niptinmi Jesús niran: “Cay pözupita yacuta upog cäga yapaymi imaypis yacunanga. ");
INSERT INTO qva_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Noga gongä yacuta upogcagmi ichanga imaypis mas mana yacunangachu. Noga yacuta gongäga pucyupita yacu yargamognuypis runachru ticranga mana ushacaypa cawaymanmi”. ");
INSERT INTO qva_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Warmi niran: “Tayta, chay yacuta gomay mana yapay yacunänäpag ni cay pözumanpis yacuman mana aywamunäpag”. ");
INSERT INTO qva_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús niran: “Ayway, runayquita pushacurcur cayman cutimuy”. ");
INSERT INTO qva_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Chay warmi niran: “Manam runä canchu”. Jesús niran: “Mana runayog cangayquita alitam nishcanqui. ");
INSERT INTO qva_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Gam pichga runatanam charashcanqui. Canan charangayquicäga manam runayquichu. Rasuncagtam nishcanqui”. ");
INSERT INTO qva_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Chayta mayar warmi niran: “Tayta, musyä gam Tayta Diospa willacognin caycangayquita. ");
INSERT INTO qva_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Unay ayllü samaritänucunaga cay jircachrümi Tayta Diosta adoräpäcog. Gamcuna, Israel runacunaga nircanqui Jerusalenmi Tayta Diosta adoräpäcunäpag”. ");
INSERT INTO qva_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús niran: “Criyimay, warmi, naganam höra chrayamungana cayman mana aywaycamur ni Jerusalenman mana aywaycur Taytäta adoräpäcunayquipag. ");
INSERT INTO qva_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Gamcuna manam musyapäcunquichu pita adoräpäcungayquitapis. Nogacunam ichanga musyapäcü pita adoräpäcungätapis. Salvacion shamun Israel runacunapitam. ");
INSERT INTO qva_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Naganam höra chrayamungana. Chay höram rasunpa Taytäta adoragcunaga Santu Espíritu munangannuy y Diospita rasuncag cangannuy adoräpäcunga. Chaynuy adoräpäcunantam Taytä munan. ");
INSERT INTO qva_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Tayta Diosga Espiritum. Chaymi payta adoragcunaga Santu Espíritu munangannuy y Diospita rasuncag cangannuy adoräpäcunan”. ");
INSERT INTO qva_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Chay warmi niran: “Noga musyämi Tayta Dios cachramungan Salvador (pay ‘Cristo’ ninanmi) shamunanpag canganta. Pay chrayamurnam lapanta tantiyachimäshun”. ");
INSERT INTO qva_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús niran: “Chayga nogam caycä. Pay quiquinmi gamwan parlaycan”. ");
INSERT INTO qva_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Chay warmiwan chaychru parlarcaptilanmi discïpuluncuna chrayapäcuran. Warmiwan Jesús parlaycagta ricarmi discïpuluncuna almirasha quëdapäcuran. Ichanga manam mayganpis tapupäcuranchu imata niycangantapis o imapita chay warmiwan parlaycangantapis. ");
INSERT INTO qva_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Chauraga chay warmi wacuyninta jaguiriycur marcaman aywaran. Chaychrüna runacunata niran: ");
INSERT INTO qva_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Shapäcamuy ricapäcunayquipag. Juc runam imata rurangäcunatapis lapanta nimasha. ¿Manachurag pay Tayta Dios cachramungan Salvador?” ");
INSERT INTO qva_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Chauraga Jesusta ricapäcunanpag marcapita runacuna aywarcämuran. ");
INSERT INTO qva_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Chaycamaga discïpuluncuna Jesusta nipäcuran: “Maestro, micucurcuyna, ari”. ");
INSERT INTO qva_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Jesús niran: “Nogapa micuynï caycan gamcuna mana reguipäcungayqui micuymi”. ");
INSERT INTO qva_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Chauraga discïpuluncuna quiquinpura caynuy ninacäriran: “¿Pirag micuyta micunanpag apapämusha?” ");
INSERT INTO qva_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesús niran: “Nogapa micuynïga cachramagnï munanganta ushanäcama ruraymi caycan. ");
INSERT INTO qva_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Gamcuna nircanqui: ‘Chruscu quillarämi cosëchapag pishiycan’. Ichanga noga nï: Ricapäcuy wiñaycag chracracunata. Cosechanapag pogushanam caycan. ");
INSERT INTO qva_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Cosëchachru arogcunaga pägunta chrasquiycannam. Cosëchachru shuntangan cagcunaga mana ushacaypa cawananpämi caycan. Chay caycan murogcuna y cosechagcuna ishcan cushicärinanpämi. ");
INSERT INTO qva_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Runa rimangannuypis: ‘Jucmi murun y jucmi cosechan’. ");
INSERT INTO qva_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Y nogam gamcunata mana murupäcungayquiman cosechag cachrashcä. Juc runacunam arupäcusha y gamcunam juc runacuna arupäcunganta cosechapäcushcanqui”. ");
INSERT INTO qva_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Chay marcapita achcag runacuna Jesusman criyipäcuran chay warmi “Lapan ima rurangätapis nimasha” ninganpita. ");
INSERT INTO qva_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Chauraga Samaria runacuna chrayaycur Jesusta rugapäcuran paycunacagchru goyänanpag. Chaynuy rugapäcuptinmi pay chaychru ishcay junag goyaran. ");
INSERT INTO qva_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Chaychru quiquin ninganta mayar mas achca runacuna criyipäcuran. ");
INSERT INTO qva_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Chay warmita nipäcuran: “Cananga criyipäcümi. Manam gam nipäcamangalayquipitachu sinöga quiquïcunam ninganta mayapäcushcä y musyapäcü lapan runacunata salvananpag canganta”. ");
INSERT INTO qva_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Chay ishcay junag goyarcurmi Galileaman Jesús aywaran. ");
INSERT INTO qva_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Quiquin Jesús caynuy niran: “Tayta Diospa willacogninga quiquinpa marcanchru manam respitashachu caycan”. ");
INSERT INTO qva_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galileaman chrayaycuptin chay partichru cagcuna shumag chrasquipäcuran. Paycunapis Jerusalenchru Pascua fiesta captin aywar ricapäcusha casha Jesús lapanta imata rurangantapis. ");
INSERT INTO qva_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesús cutiran Galileachru Caná marcaman. Chaychrümi yacuta vïnuman ticrachiran. Capernaum marcachrümi juc autoridäpa wamran gueshyaycar caycaran. ");
INSERT INTO qva_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jesús Judeapita Galileaman chrayasha canganta musyaycur chay autoridä payman aywaran. Chaychrümi Jesusta rugacuran wasinman aywaycur wamran wañunanpäna caycagta cuticächinanpag. ");
INSERT INTO qva_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesús niran: “Milagruta mana ricarga gamcuna manam criyipäcunquipächu”. ");
INSERT INTO qva_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Chay autoridä runa niran: “Tayta, jucla aywayculay wamrä manaräpis wañungancama”. ");
INSERT INTO qva_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Chauraga Jesús niran: “Wasiquiman cuticuyna. Wamrayqui cuticashanam caycan”. Chauraga chay runa Jesús ninganta criyir wasinpa cuticuran. ");
INSERT INTO qva_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Wasinman cutiycaptinna uywaynincuna taripaycämur niran: “¡Tayta, wamrayqui cuticashanam caycan!” ");
INSERT INTO qva_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Chauraga pay tapuran ima hörapita ali cayta galaycungantapis. Nipäcuran: “Ganyan pulan junag muyurpusha höra mananam calintürashanachu”. ");
INSERT INTO qva_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Chay wamrapa taytan yarparan Jesús chay höra: “Wamrayqui cuticashanam caycan” ninganta. Chauraga pay y wasinchru lapan cagcunawan Jesusman criyipäcuran. ");
INSERT INTO qva_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Caywanga ishcay cutinam Judeapita Galileaman cutiycar milagruta Jesús ruraran. Chay milagruta ruraran payta Dios rasunpa cachramunganta musyacänanpag. ");
INSERT INTO qva_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Chaypitana Jerusalenchru Israel runacuna fiestata rurapäcuran. Chay fiestaman Jesuspis aywaran. ");
INSERT INTO qva_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalenchru “Üshacuna” jutiyog puerta cercanchru juc pözu caran. Chay pözupa hebreo rimaychru “Betesda” jutin caran. Chay pözu cantunchru caran pichga ramädacuna. ");
INSERT INTO qva_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Chay ramädacunachrümi achca gueshyagcuna, gapracuna, wegrucuna y wañusha chraquiyog runacuna caycaran. Chay runacuna shuwararcaran pözuchru yacu cuyurinanta. ");
INSERT INTO qva_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Chaychru yacutam avëces angel yarparcamur cuyucheg. Chay cuyuchisha yacuman mayganpis puntata yaycogcäga ima gueshyanpitapis cuticag. ");
INSERT INTO qva_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Chaychrümi juc runa quimsa chrunca pusag (38) watana gueshyaycag caycaran. ");
INSERT INTO qva_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Chay runa quiscatäraycagta Jesús ricarmi y achca watana chaynuy caycanganta musyaycur tapuran: “¿Cuticasha cayta munanquichu?” nir. ");
INSERT INTO qva_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Chay gueshyag niran: “Tayta, manam pïnïpis canchu yacu cuyuriptin yacuman yaycachimänanpag. Yaycunäpag aywaycaptïpis jucmi puntata yaycuriycun”. ");
INSERT INTO qva_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús niran: “¡Sharcuy! Quirmayquita jogarcuy y apacurcur aywacuy”. ");
INSERT INTO qva_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Chay höram runa cuticaran, quirmanta jogarcuran y puriyta galaycuran. Chay caran sábado jamay junag. ");
INSERT INTO qva_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Chay cuticag runata Israel runacunapa autoridänincuna niran: “Cananga sábado jamay junagmi quirmayquita manam apanquimanchu”. ");
INSERT INTO qva_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Chay runa niran: “Cuticächimagnï runam ‘Quirmayquita jogarcuy y apacurcur aywacuy’ nimasha”. ");
INSERT INTO qva_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Chay runacuna tapupäcuran: “¿Pitag ‘Quirmayquita jogarcuy y apacurcur aywacuy’ nishushcanqui?” ");
INSERT INTO qva_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Chay runa mana musyaranchu pï cuticächingantapis chaychru achca runacuna captin. ");
INSERT INTO qva_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Chaypita chay cuticächingan runata templuchru Jesús tariran. Chaychru niran: “Cuticasha caycarnaga cananga amana mas juchäcuynachu cangayquipita mas peurman chrayanayquipita”. ");
INSERT INTO qva_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Chay runa Israel runacunapa autoridänincunaman aywaycur Jesús cuticächinganta willaran. ");
INSERT INTO qva_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Sábado jamay junagchru chaynuy ruraptinmi chay autoridäcuna Jesusta rabyapäpäcuran y wañuchiyta munapäcuran. ");
INSERT INTO qva_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ichanga Jesús niran: “Taytä imaypis aruycanmi. Chaynuymi nogapis aruycä”. ");
INSERT INTO qva_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Chaynuy niptinmi autoridäcuna Jesusta wañuchiyta mas munapäcuran. Chaynuy wañuchiyta munapäcuran manam pay sábado jamay junagta mana cäsucungalanpitachu sinöga “Diosmi Taytä” niptin pay Dioswan iwal canganta ninganpitam. ");
INSERT INTO qva_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesús niran: “Rasunpam gamcunata nï: Diospa Wamranga imatapis manam quiquilanpitaga rurayta puedinchu. Pay ruran Taytan ruraycanganta ricangalantam. Taytan rurangantam Wamranpis ruran. ");
INSERT INTO qva_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Taytanga Wamranta cuyanmi. Chaymi lapan ruranganta ricachin. Mas alicunatarämi ricachinga gamcuna almirasha quëdanayquipag. ");
INSERT INTO qva_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Wañushacunata Taytan cawarichimur cawachingannuymi Wamranpis cawachinga pitapis munangancagtaga. ");
INSERT INTO qva_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","“Taytanga manam pitapis juzgangachu sinöga Wamranpa munayninmanmi chrurasha pitapis juzgananpag. ");
INSERT INTO qva_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Chaynuy chrurasha Taytanta respitangannuyla paytapis lapan respitänanpämi. Wamranta mana respitagcäga cachramognin Taytantapis manam respitanchu. ");
INSERT INTO qva_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Rasunpam gamcunata nï: Noga ningäta cäsucamagcäga y pï nogata cachramanganman criyegcäga mana ushacaypanam cawaycan y mananam castigashanachu canga. Ichanga wañushanuy caycanganpita mana ushacaypa cawaymanna chrayasha. ");
INSERT INTO qva_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Rasunpam gamcunata nï: Naganam höra chrayamungana. Chay höram wañushanuy cagcuna Tayta Diospa Wamran ninganta mayanga. Mayacogcäga cawangam. ");
INSERT INTO qva_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Taytan quiquin cayninpa cawaycan. Chaynuypis Wamranta quiquin cayninpa cawananpag gosha. ");
INSERT INTO qva_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Chaynuypis noga Diospita shamusha Runa captï juzganäpag munayninta gomasha. ");
INSERT INTO qva_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Caypita ama almiräpäcuychu. Höra chrayamungam lapan wañushacuna pay ninganta mayapäcunanpag. ");
INSERT INTO qva_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Chaychrümi wañushacuna cawarimunga. Alita rurasha cagcunaga mana wañuypana cawapäcunanpag cawarimunga. Mana alita rurasha cagcunaga cawarimunga castïguman aywananpag. ");
INSERT INTO qva_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Noga manam quiquiläpitaga imatapis rurächu. Taytä nimangannuylam juzgä. Quiquï munangalätachu manam rurä sinöga cachramag Taytä munangalantam. Chaynuy captin juzgar ningäcäga rasuncagmi. ");
INSERT INTO qva_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Nogala quiquïpag willacuptïga manam imapäpis välinchu. ");
INSERT INTO qva_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Jucmi noga raycu willacun. Musyämi nogapita willacunganga rasuncag canganta. ");
INSERT INTO qva_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Gamcuna Juan Bautistaman nogapita tapog cachrapäcurayqui. Juan willamuran rasunpa caglata. ");
INSERT INTO qva_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nogapita juc runarächu manam willacunan. Chaynuy nï gamcuna salvaciunta taripäcunayquipämi. ");
INSERT INTO qva_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan Bautista willacur pay caran michëru rupar achicyangannuymi. Achquin achicyanganchru juc rätu cushisha capäcunalayquipämi caran. ");
INSERT INTO qva_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Nogapa favurnï willacungan Juanpitapis mas väleg caycanmi. Taytä ruranäpag cagcunata gomangancunaga cumplinäpämi caycan. Chaycunam musyacächin Taytä nogata cachramanganta. ");
INSERT INTO qva_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Chaynuy cachramag Taytäpis nogapa favurnï willacun. Gamcuna pay willacunganta imaypis manam mayapäcushcanquichu ni paytaga ricapäcushcanquichu. ");
INSERT INTO qva_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Chaynuypis Taytä ningancunata gamcuna mana chrasquicärinquichu. Chaynuy carcanqui Taytä cachramungan runaman mana criyipäcurmi. ");
INSERT INTO qva_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Gamcunaga Tayta Dios escribichinganta shumag tantiyanayquipag liyircanqui chaychru mana ushacaypa cawayta tariyta yarpar. Chay escribichingancunachru nogapitam willacuycan. ");
INSERT INTO qva_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ichanga gamcuna mana ushacaypa cawayta tarinayquipag nogaman aywamuyta mana munapäcunquichu. ");
INSERT INTO qva_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Nogaga manam runacuna alabämänantachu ashiycä. ");
INSERT INTO qva_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ichanga noga gamcunata reguïmi; Tayta Diosta mana cuyag cangayquita musyämi. ");
INSERT INTO qva_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Noga Taytä cachramaptinmi shamushcä. Paypita shamusha captïpis gamcuna mana chrasquipäcamanquichu. Quiquinpa yarpayninwan shamog runacunatam ichanga chrasquircanqui. ");
INSERT INTO qva_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Imanuypam gamcuna nogaman yäracärinqui quiquiquipurala alabänacuycarga juclayla Diospita ali ricasha cayta mana ashiycarga? ");
INSERT INTO qva_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Ama yarpäpäcuychu Taytäpa ñaupagninchru gamcuna juchayog cangayquita ninäpag canganta. Gamcunata juchayog capäcungayquita nipäcushunqui yäracäringayqui quiquin Moisesmi. ");
INSERT INTO qva_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moisés nogapitam escribisha caran. Chaynuy caycaptinga Moisesta criyiycarga nogatapis criyipäcamanquiman. ");
INSERT INTO qva_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Gamcuna Moisés escribingan leycunata mana criyiycarga ¿imanuyparag noga ningäcunata criyipäcunquiman?” ");
INSERT INTO qva_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Chaypitanam Jesús Galilea lamarpa chimpacag lädunman pasaran. Chay lamarlatam “Tiberias lamar” nipäcog. ");
INSERT INTO qva_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Milagrucunata rurar gueshyagcunata cuticächegta ricarmi achcag runacuna gatiräpäcuran. Chay milagrucunata ruraran payta Dios rasunpa cachramunganta musyacänanpag. ");
INSERT INTO qva_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Chaychrünam lömaman jegaycur discïpuluncunawan Jesús jamacäriran. ");
INSERT INTO qva_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Israel runacunapa Pascua fiestan nagana chrayaycämuranna. ");
INSERT INTO qva_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesús ricäringanchru achca runacuna gatiragta ricarmi Felipita Jesús niran: “¿Maypitatag caychica runacunapag tantata rantimushun?” ");
INSERT INTO qva_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Niran: “Felipe, mä, imanimänäshi” nir. Quiquin Jesús musyarannam imata rurananpag cangantapis. ");
INSERT INTO qva_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipe niran: “Ishcay pachrac junag runa gänanganwan rantimushapis ichiclata chrasquinanpäpis tanta manam aypangachu”. ");
INSERT INTO qva_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Andrés jucnincag discïpulun y Simón Pedrupa wauguin niran: ");
INSERT INTO qva_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Caychru juc wamra cebadapita pichga tantata y ishcay pescäduta chararaycan. Ichanga ¿imatag cay caychica runacunapäga?” ");
INSERT INTO qva_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesús niran: “Jamacunanpag lapanta nipäcuy”. Chaychru achca guewa caran. Chaymanmi jamacäriran. Chaychru pichga waranganuy (5,000) olgucuna caran. ");
INSERT INTO qva_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesús tantacunata aptarcur Tayta Diosta agradecicuran. Nircur chacyaran jamaraycagcunata aypunanpag. Chaynuyla pescäduwanpis ruraran. Micapäcuran sacsangancama. ");
INSERT INTO qva_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Lapan sacsaruptinna discïpuluncunata Jesús niran: “Puchungancunata lapanta shuntamuy imapis mana perdinanpag”. ");
INSERT INTO qva_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Chauraga discïpuluncuna cebada pichga tantapita micunanpag runacunata gonganpita puchupacungancunata chrunca ishcay (12) canasta juntata shuntapäcuran. ");
INSERT INTO qva_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Jesús chay milagru ruranganta ricaycurmi runacuna nipäcuran: “Rasunpam cay runa cay pachaman shamunanpag cag Diospa willacognin caycan”. ");
INSERT INTO qva_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Rey cananpag runacuna imaycanuypapis pushayta munapäcunganta tantiyarmi Jesús yapay jircaman aywacuran chaychru quiquilan cananpag. ");
INSERT INTO qva_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Pacha chacaycaptinnam Jesuspa discïpuluncuna lamar cantunman yarpapäcamuran. ");
INSERT INTO qva_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Nircurna büquiman jegarcur Capernaumman chrayapäcunanpag lamarta chimpayta galaycapäcuran. Pacha chacashana caycaran. Ichanga Jesús paycuna cagman manarag yarpamuranrächu. ");
INSERT INTO qva_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Chaychrümi fiyupa wayrämuptin lamar fiyupa pulchagyaran. ");
INSERT INTO qva_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nagana pichga o sogta kilömetrunuyta aywarcarnam yacu jananpa aywamur büquiman cercaycämogta Jesusta ricapäcuran. Ricar manchacäpäcuran. ");
INSERT INTO qva_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pay niran: “¡Nogam caycä! ¡Amana mancharipäcuychu!” ");
INSERT INTO qva_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Chauraga büquiman cushisha jegachipäcuran. Chaypitana chay höra aywarcangan marcaman chrayapäcuran. ");
INSERT INTO qva_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Warantinna chay jucag läduchru quëdag runacuna juclayla caycag büquiwan discïpulucuna aywacunganta tantiyapäcuran y paycunawan Jesús mana aywanganta musyapäcuran. ");
INSERT INTO qva_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Chaycamaga Tiberias marcapita mas juc büquicuna chrayaran Señor Jesús Tayta Diosta agradecicuriptin tantata micapäcungan cercanman. ");
INSERT INTO qva_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Chauraga Jesús ni discïpuluncuna mana canganta ricarmi runacuna büquicunaman jegarcur Capernaumman Jesusta ashipäcunanpag aywapäcuran. ");
INSERT INTO qva_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Paycuna lamarpa jucag lädunman chrayarna Jesusta taripäcuran. Nircurna tapupäcuran: “Maestro, ¿imaytag cayman aywamurayqui?” ");
INSERT INTO qva_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesús niran: “Rasunpam gamcunata nï: Gamcuna ashircämanqui manam imanir milagru rurangäta tantiyarchu sinöga sacsagpag micupäcungalayquipitam. ");
INSERT INTO qva_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ama arupäcuychu ushacag micuylapäga sinöga imaypis mana ushacag y mana ushacaypa cawachicog micuypag arupäcuy. Noga Diospita shamusha Runam chay micuyta goshayqui. Chaypämi Tayta Dios nogata acramasha”. ");
INSERT INTO qva_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Chauraga tapupäcuran: “¿Imatatag rurapäcüman Tayta Dios munanganta rurapäcunäpag?” nir. ");
INSERT INTO qva_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús niran: “Tayta Dios munan pay cachramungan runaman yäracärinayquitam”. ");
INSERT INTO qva_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Chauraga tapupäcuran: “¿Ima milagrutapis ruranquimanchu nogacuna ricapäcunäpag y criyipäcunäpag? ¿Imatatag ruranqui? ");
INSERT INTO qva_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Unay ayllunchicuna chunyag jircachru ‘manä’ jutiyog micuyta micapäcuran. Tayta Diosninchi escribichinganchru ningannuypis: ‘Cielupita tantata micunanpag goran’ ”. ");
INSERT INTO qva_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesús niran: “Rasunpam gamcunata nï: Moiseschu manam gamcunata cielupita tantata gopäcushurayqui sinöga Taytämi cielupita rasunpa cag tantataga gorcäshunqui. ");
INSERT INTO qva_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tayta Diospa tantanga caycan cielupita yarpamogmi. Chay tantam runata mana ushacaypa cawaycächin”. ");
INSERT INTO qva_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Paycuna nipäcuran: “Tayta, chay tantata imaypis goycärilämay”. ");
INSERT INTO qva_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesús niran: “Nogam runa cawacheg tanta caycä. Nogaman aywamog cäga imaypis manam micanangachu. Nogaman criyimagcäga imaypis manam yacunangachu. ");
INSERT INTO qva_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ichanga ningänuypis ricamasha caycarpis gamcunaga manam yäracarcämanquichu. ");
INSERT INTO qva_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Taytä nogapag acrangancagcunaga lapanpis nogamanmi aywamun. Nogaman aywamogcagtaga pitapis manam gargushächu. ");
INSERT INTO qva_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Noga cielupita aywamushcä manam quiquï munangäta ruranäpächu sinöga cachramagnï Taytä munanganta ruranäpämi. ");
INSERT INTO qva_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Cachramag Taytäga nogapag acrangancagcunataga ni juclaylatapis ogranäta manam munanchu. Chaypa truquinga últimu junag cawarichimunätam munan. ");
INSERT INTO qva_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Taytä munan pï Wamran canganta tantiyagcäga y payman criyegcäga mana ushacaypa cawanantam. Y noganam últimu junag cawarichimushag”. ");
INSERT INTO qva_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","“Nogam cielupita aywamog tanta caycä” ninganpita Israel runacunapa autoridänincuna Jesusta jamurpayta galaycäriran. ");
INSERT INTO qva_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Nipäcuran: “Cay Jesús ¿manachu Josëpa wamran? Noganchi reguinchi taytanta mamanta. ¿Imanirtag cananga cielupita aywamunganta niycan?” ");
INSERT INTO qva_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Chauraga Jesús niran: “Amana rimapäcuychu. ");
INSERT INTO qva_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Pipis manam nogaman aywamunmanchu cachramagnï Taytä mana pushamuptinga. Nogaman aywamogcagtaga últimu junag cawarichimushämi. ");
INSERT INTO qva_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Tayta Diospa willacognincuna escribinganchrüpis nin: ‘Tayta Diosmi lapanta tantiyachinga’. Chaymi Taytäta lapan mayagcäga y paypita yachracogcäga nogaman aywamun. ");
INSERT INTO qva_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Manam pipis Taytäta ricashachu. Taytätaga ricasha Diospita aywamogcaglam. ");
INSERT INTO qva_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Rasunpam gamcunata nï: Payman criyegcäga mana ushacaypanam cawaycan. ");
INSERT INTO qva_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","“Nogam runa cawacheg tanta caycä. ");
INSERT INTO qva_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Gamcunapa unay aylluyquicuna ‘manä’ jutiyog micuyta chunyag jircachru micuran. Chayta micurpis wañupäcuranmi. ");
INSERT INTO qva_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Caymi cielupita aywamog tanta. Chayta micogcäga manam wañungachu. ");
INSERT INTO qva_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nogam cielupita aywamusha y cawaycag chay tanta caycä. Chay tantata micogcäga mana ushacaypam cawanga. Gonäpag cag tantaga aychämi. Chayta goshag cay pachachru runacuna cawananpag”. ");
INSERT INTO qva_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Israel runacunapa autoridänincuna jucnin jucninpis fiyupa rimanacuyta galaycäriran: “¿Imanuypatag chay runa aychanta gomäshun micunanchipag?” ");
INSERT INTO qva_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesús niran: “Rasunpam gamcunata nï: Noga Diospita shamusha Runapa aychäta mana micurga y yawarnïta mana upurga manam cawapäcunquichu. ");
INSERT INTO qva_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Aychäta micogcäga y yawarnïta upogcäga mana ushacaypanam cawaycan. Y nogam últimu junag cawarichimushag. ");
INSERT INTO qva_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nogapa aychämi rasunpa cag micuyga y yawarnïmi rasunpa cag yacoga. ");
INSERT INTO qva_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nogapa aychäta micogcagmi y yawarnïta upogcagmi nogawan juc runanuyla imaypis cawaycan y nogapis paywan juc runanuyla imaypis cawaycä. ");
INSERT INTO qva_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Cawachicog Taytämi cachramasha. Pay cayninpam noga cawaycä. Chaynuylam pipis nogata micamagcäga noga caynïpa cawanga. ");
INSERT INTO qva_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Caymi cielupita aywamog tanta. Chay tantaga manam unay aylluyquicuna micungan manänuychu. Chayta micurpis wañupäcuranmi. Ichanga chay tantata micogcagmi mana ushacaypa cawanga”. ");
INSERT INTO qva_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Cay lapanta Jesús yachrachiran Capernaumchru shuntacäpäcunan wasichrümi. ");
INSERT INTO qva_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Chaynuy yachrachinganta mayar Jesuspa achcag discïpuluncuna nipäcuran: “Cay niycanganta manam chrasquishwanchu. Chayta ¿pirag cäsunga?” ");
INSERT INTO qva_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Discïpuluncuna quiquinpura rimarcanganta tantiyacurir Jesús tapuran: “¿Ningä rabyachipäcushunquichu? ");
INSERT INTO qva_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Chauraga imanipäcunquimanrag noga Diospita shamusha Runa unay cangäman cutegta ricar? ");
INSERT INTO qva_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Espiritum runata cawachin. Runachu manam cawachin. Noga ningäga Espiritum y cawaymi. ");
INSERT INTO qva_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ichanga waquinniquicuna manarämi criyipäcunquirächu”. Jesús galaycunanpita pacham musyaran pïcuna mana criyinanpag canganta y pï chriquegninman entregänanpag canganta. ");
INSERT INTO qva_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jesús niran: “Chaynuy captinmi noga nirä: ‘Taytä munaptinrämi pipis nogaman aywamunga’ ”. ");
INSERT INTO qva_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Chaypita achcag discïpuluncuna Jesusta jaguiriycur paywan manana puripäcurannachu. ");
INSERT INTO qva_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jesús tapuran chrunca ishcay (12) discïpuluncunata: “¿Gamcunapis aywacuytachu munarcanqui?” ");
INSERT INTO qva_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Chauraga Simón Pedro niran: “Tayta, ¿pimantag nogacuna aywapäcüman? Gam yachrachipäcamangayquega mana ushacaypa cawapäcunäpämi caycan. ");
INSERT INTO qva_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nogacunaga criyipäcushcänam y musyapäcümi gam Tayta Dios cachramungan Runa cangayquita”. ");
INSERT INTO qva_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesús niran: “Nogam gamcuna chrunca ishcayniquita (12) acrashcä. Ichanga gamcunapita jucniqui Satanasmi”. ");
INSERT INTO qva_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesús chaynuy niran Judaspämi. Pay caran Simón Iscariotipa wamranmi. Judasmi chrunca ishcay (12) discïpuluncunapita jucnin carpis Jesusta chriquegninman entregänanpag caycaran. ");
INSERT INTO qva_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Chaypitanam Galilea provinciachru cag marcacunapa Jesús puriran. Judeachru cayta mana munaranchu Israel runacunapa autoridänincuna wañuchinanpag ashiptin. ");
INSERT INTO qva_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ramäda fiesta chrayaycämuranna. Chay caran Israel runacunapa fiestan. ");
INSERT INTO qva_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Chauraga wauguincuna Jesusta niran: “Caychru ama quëdacuychu. Judea provinciata ayway chaychru discïpuluyquicunapis imata rurangayquitapis ricashunayquipag. ");
INSERT INTO qva_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Reguisha cayta munarga pipis manam imatapis pacaylapa ruranchu. ¡Cay rurangayquitanuy lapan ricaycaptin ruray!” ");
INSERT INTO qva_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jesuspa wauguincuna chaynuy niran Tayta Dios cachramungan Salvador canganta mana criyirmi. ");
INSERT INTO qva_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesús niran: “Manam hörä chrayamunrächu. Gamcunapäga ima hörapis alim. ");
INSERT INTO qva_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tayta Diospa contran runacuna gamcunataga manam chriquipäcushunquichu. Nogatam ichanga chriquipäcaman mana ali rurangancunata niptï. ");
INSERT INTO qva_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Gamcunala chay fiestaman aywapäcuy. Noga manam aywashächu; manarämi hörä chrayamunrächu”. ");
INSERT INTO qva_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Chaynuy nircur Galileachru quëdacuran. ");
INSERT INTO qva_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Wauguincuna fiestaman aywaräriptinrämi pitapis mana musyachiypa Jesuspis aywaran. ");
INSERT INTO qva_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Israel runacunapa autoridänincuna Jesusta fiestachru ashirmi nipäcuran: “¿Maychrürag chay runa caycan?” nir. ");
INSERT INTO qva_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Chay runacunachru achcag paypita mana mayacayla parlapäcuran. Waquin nipäcuran: “Jesús ali runam”. Waquinna nipäcuran: “Manam. Runacunatam engañaycan”. ");
INSERT INTO qva_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ichanga Israel runacunapa autoridänincunata manchacur manam pipis runa mayayga Jesuspita rimapäcuranchu. ");
INSERT INTO qva_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ramäda fiesta pulanchru caycaptin Jerusalén templuman Jesús yaycuran. Nircurnam chaychru yachrachiyta galaycuran. ");
INSERT INTO qva_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Israel runacunapa autoridänincuna almirasha nipäcuran: “Mana estudiasha caycarga ¿imanuypatag cay runa shumag yachran?” ");
INSERT INTO qva_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús niran: “Noga yachrachingäga manam quiquiläpitachu sinöga cachramagnï Tayta Dios yachrachimanganmi. ");
INSERT INTO qva_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Yachrachingäcuna Diospita canganta musyayta munarga Dios munangannuy cawapäcuy. Chaynuypam tantiyapäcunqui quiquïpa yarpayläpita mana yachrachingäta. ");
INSERT INTO qva_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Pipis quiquilanpita parlarga jucpita ali ricasha caylatam ashiycan. Ichanga cachramognin ali ricasha cananpag ashegcäga rasuncagtam niycan. Payga manam manacagta rimanchu. ");
INSERT INTO qva_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“¿Manachu rasunpa gamcunata leycunata escribinganta Moisés gopäcushurayqui? Chaynuy captinpis manam maygayquipis cäsupäcunquichu. ¿Imanirtag wañuchiyta munapäcamanqui?” ");
INSERT INTO qva_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Chauraga runacuna nipäcuran: “¡Gamtaga diablupa munayninchru caycanquim! ¿Pitag wañuchiyta munaycäshunqui?” ");
INSERT INTO qva_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús niran: “Gamcunaga lapayqui almiräpäcunqui sábado jamay junagchru juc cutila milagruta rurangäpita. ");
INSERT INTO qva_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisés circunciciunta rurapäcunayquipag nipäcushurayqui. (Moisés yachrachiptinpis chay costumbri caran unay aylluyquicunapam.) ¿Gamcuna manachu sábado jamay junagchrüpis runata circuncidarcanqui? ");
INSERT INTO qva_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Gamcuna Moisés escribingan leycunata cumplir sábado junagchrüpis olgu wamrata circunciciunta ruraycarga ¿imanirtag sábado junagchru intëru cuerpun gueshyaycag runata cuticächingäpita nogata rabyapäpäcamanqui? ");
INSERT INTO qva_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Amana juzgapäcuychu manaräpis shumag musyarga. Juzgarga juzgapäcuy juzganayquipag cagpita”. ");
INSERT INTO qva_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Chauraga Jerusalenchru waquin tiyagcuna parlapäcuran: “¿Manachu cay runataga wañuchinanpag ashircan? ");
INSERT INTO qva_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Chaychru caycan, äri. Lapanpa ñaupagninchru parlaycan; pipis imatapis mana ninchu. ¿Autoridäcunapis Tayta Dios cachramungan Salvador cangantachurag yarparcan? ");
INSERT INTO qva_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Noganchi musyanchim maypita shamungantapis. Ichanga Tayta Dios cachramungan Salvador shamuptin manam pipis musyangachu maypita cangantapis”. ");
INSERT INTO qva_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Chayta mayaycur templuchru Jesús yachraycächinganpita fiyupa nimuran: “¡Chauraga gamcuna nogata reguipäcamanqui y musyapäcunqui maypita shamungätapis! Ichanga noga manam quiquiläpitachu shamushcä. Sinöga shamushcä juc yäracuypag cachramaptinmi. Payta gamcuna manam reguipäcunquichu. ");
INSERT INTO qva_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Noga payta reguï paypita aywamusha carmi. Paymi nogata cachramasha”. ");
INSERT INTO qva_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Chauraga prësu chariyta munapäcuran. Ichanga pipis manam charipäcuranchu höran manarag chrayamuptin. ");
INSERT INTO qva_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Achcagmi payman criyipäcuran. Y nipäcuran: “Tayta Dios cachramungan Salvador shamur ¿cay runapita maschurag milagruta ruranga payta Dios rasunpa cachramunganta musyacänanpag?” ");
INSERT INTO qva_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariseucuna Jesuspita runacuna rimanganta mayapäcuran. Chayta mayaycurmi paycuna y cüracunapa mandagnincuna templo cuydag wardiacunata Jesusta prësu charimunanpag cachrapäcuran. ");
INSERT INTO qva_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesús niran: “Noga gamcunawan manam achca tiempuchu cashag. Noga cuticushänam cachramagnï cagman. ");
INSERT INTO qva_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Gamcuna ashipäcamanquim. Ichanga manam taripäcamanquichu. Noga cangäcagman gamcuna manam aywayta puedipäcunquichu”. ");
INSERT INTO qva_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Chauraga Israel runacuna quiquinpura tapunacäriran: “¿Maymanrag cay aywacunga mana tarinanchipag? ¿Juc lädu naciunchru tiyag Israel runacunamanchurag aywanga mana Israel runacunata yachrachinanpag? ");
INSERT INTO qva_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Imaninantatag ‘Ashipäcamanqui; ichanga manam taripäcamanquichu’ y ‘Mana aywayta puedipäcunquichu noga cangäcagman’ niycan?” ");
INSERT INTO qva_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ramäda fiesta ushanan junagmi mas alicag junag caran. Chay junag Jesús ichrircur fiyupa niran: “Mayganpis yacunarga nogaman aywamuchun y upuchun. ");
INSERT INTO qva_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nogaman criyegcagpitaga Tayta Dios escribichinganchru ningannuypis: ‘Shongunpita cawaycag yacum mayunuypis yargamunga’ ”. ");
INSERT INTO qva_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Chaynuy nirmi Jesús tantiyachiran payman yäracogcuna Santu Espirituta chrasquicunanpag canganta. Chay wichanga Santu Espíritu manam chrayamuranrächu Jesús cieluman yapay manarag cutisha captin. ");
INSERT INTO qva_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Chay runacunachru waquin cag runacuna chay ninganta mayar nipäcuran: “Rasunpa cay runam shamunanpag cag Diospa willacognin casha”. ");
INSERT INTO qva_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Waquin nipäcuran: “Paymi Tayta Dios cachramungan Salvador”. Y waquinnam nipäcuran: “Tayta Dios cachramungan Salvador Galileapitachu manam shamunga. ");
INSERT INTO qva_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tayta Diosninchi escribichinganchrüga niycan rey Davidpa ayllunpita Tayta Dios cachramungan Salvador yurinanpag cangantam. Y Davidpa marcan Belenpita cananpag cangantam”. ");
INSERT INTO qva_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Chaymi Jesuspa janan runacuna ishcayman quimsaman raquicaran. ");
INSERT INTO qva_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Waquincuna prësu chariyta munapäcuran. Ichanga mayganpis manam chariranchu. ");
INSERT INTO qva_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Templo cuydag wardiacuna fariseo runacuna y cüracunapa mandagnincuna caycanganman cutipäcuran. Cutiptin tapupäcuran: “¿Imanirtag Jesusta prësu mana apapäcamushcanquichu?” ");
INSERT INTO qva_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Templo cuydag wardiacuna nipäcuran: “¡Manam imaypis chaynuyga runa parlashachu!” ");
INSERT INTO qva_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Chauraga fariseucuna nipäcuran: “¿Gamcunatapis criyichipäcushushcanquichu? ");
INSERT INTO qva_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Mandagcunapis o fariseo runacunapis paymanchu criyisha? ");
INSERT INTO qva_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ichanga chay leyta mana tantiyag runacunaga Tayta Diospa castïgunwanmi nacanga”. ");
INSERT INTO qva_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemo jutiyog fariseo runa juc cutinchru Jesusta ricag aywasha casha. Chaychru niran: ");
INSERT INTO qva_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Leyninchicuna ningannuy manaräpis runa imatapis ningancamaga y pay imatapis ruranganta musyanganchicamaga manam condenashwanchu”. ");
INSERT INTO qva_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Paycuna nipäcuran: “¿Gampis Galilea runachu canqui? ¡Tayta Dios escribichinganta liyiy shumag tantiyanayquipag! ¡Chaychrümi musyanqui Galileapita Diospa willacognin mana yargamunanpag canganta!” ");
INSERT INTO qva_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Chaypitanam wasinman cama lapan aywacäriran. ");
INSERT INTO qva_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesús ichanga Olivos lömaman aywaran. ");
INSERT INTO qva_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Warantin tutana templuman cutiran. Chaymannam lapan runacuna chrayapäcuran. Chauraga jamaycur pay yachrachiyta galaycuran. ");
INSERT INTO qva_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Chaymanmi Moisés escribingan leycunata yachrachegcuna y fariseo runacuna juc warmita apapäcuran. Chay warmita taripäcusha caran gosanpita juc runawan puñuycagta. Chay warmita chaychru caycagcunapa ñaupagninman ichrichipäcuran. ");
INSERT INTO qva_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Nircur Jesusta nipäcuran: “Maestro, cay warmita taripäcamusha gosanpita juc runawan puñuycagta. ");
INSERT INTO qva_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Leychrüga Moisés niycämanchi cay nirag warmitaga rumiwan sagmaycälar wañuchinapag cananpämi. Gamga ¿imaninquitag?” ");
INSERT INTO qva_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Chaynuy tapupäcuran Jesusta lutanta rimachiyta munapäcurmi chay rimanganwan “Lutanta nishcanqui” nipäcunanpag. Chaynuy tapuptinmi unchruycur pampachru Jesús dëdunwan escribiran. ");
INSERT INTO qva_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Yaparir yaparir tapupäcuptinnam ichrircur Jesús niran: “Gamcunachru maygayquipis juchaynag cäga, mä, chay warmita sagmayta galaycuchun”. ");
INSERT INTO qva_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Chaynuy nircurmi unchruycur pampachru dëdunwan yapay escribiran. ");
INSERT INTO qva_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Chay ninganta mayaycurmi jucpa cama aywacuyta galaycäriran. Puntata aywacuyta galaycäriran mas auquincuna cagmi. Lapan aywacaräriptin warmilawanna Jesús quëdaran. ");
INSERT INTO qva_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ichrircur Jesús chay warmita niran: “¿Maytag chay runacuna? ¿Manachu mayganpis castigasha canayquipag nishushcanqui?” ");
INSERT INTO qva_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Chay warmi niran: “Manam mayganpis, tayta”. Jesús niran: “Nogapis manam castigasha canayquipag nishayquichu. Cananga aywacuy y mas ama juchäcuynachu”. ");
INSERT INTO qva_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Chaypitanam yapay runacunata Jesús niran: “Noga runacunapäga achquim caycä. Nogawan puregcäga manam yananyagchrünuychu puringa sinöga cawachicog achquitam chrasquinga”. ");
INSERT INTO qva_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Fariseo runacuna nipäcuran: “Gam quiquilayquipitam willacuycanqui. Chay willacungayqui manam välinchu”. ");
INSERT INTO qva_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesús niran: “Willacungä välinmi quiquiläpag willacuptïpis. Chay välin maypita shamungätapis y mayman aywangätapis noga musyaptï. Gamcunam ichanga mana musyapäcunquichu maypita shamungätapis ni mayman aywangätapis. ");
INSERT INTO qva_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Gamcuna juzgapäcunqui runa yarpangannuylam. Noga pitapis manam juzgächu. ");
INSERT INTO qva_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Noga juzgar quiquilächu manam juzgaycä. Sinöga cachramagnï Taytäwanmi juzgarcä. Chauraga juzgangä rasuncagmi caycan. ");
INSERT INTO qva_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Gamcunapa leyniquichru escribiraycan ishcay runa chaynuyla niptinga willacungan rasuncag canganta. ");
INSERT INTO qva_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Noga quiquïmi quiquïpag testïgu caycä. Jucag testïgu cachramagnï Taytämi”. ");
INSERT INTO qva_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Chauraga tapupäcuran: “¿Maychrütag taytayqui caycan?” Jesús niran: “Gamcunaga nogata manam reguipäcamanquichu. Taytätapis manam reguipäcunquichu. Nogata reguimarga Taytätapis reguipäcunquimanmi”. ");
INSERT INTO qva_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesús chaynuy niran templuchru yachraycächirmi. Pay caycaran ofrendata shuntacuna chrurarangan cagchrümi. Ichanga manam pipis payta prësu chariranchu höran manarag chrayamuptin. ");
INSERT INTO qva_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesús yapay niran: “Noga aywacuptï gamcuna ashipäcamanquim. Ichanga juchalayquichrümi wañupäcunqui. Noga aywangäcagmanga gamcuna manam chrayayta puedipäcunquichu”. ");
INSERT INTO qva_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Israel runacuna nipäcuran: “¿Acäsu wañuchicuytachu yarpaycan y chaychu pay aywanancagman aywayta mana puedinanchita niycan?” ");
INSERT INTO qva_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesús niran: “Gamcunaga cay uralapitam capäcunqui. Nogaga janapitam cä. Gamcunaga cay pachapitam capäcunqui. Nogaga manam cay pachapitachu cä. ");
INSERT INTO qva_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Chaymi gamcunata nirä juchalayquicunachrümi wañupäcunqui. Pï cangätapis mana criyirga juchalayquicunachrümi wañupäcunqui”. ");
INSERT INTO qva_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Chauraga tapupäcuran: “¿Pitag gam canqui?” Jesús niran: “Pï cangätapis galaycunanpitam willashcä. ");
INSERT INTO qva_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Achcam caycan noga gamcunapita ninäpag y achcam gamcunapita juzganäpag caycan. Nogata cachramagcäga rasuncagtam nin. Chaymi runacunata noga ningäcäga caycan cachramagnï ninganta mayangänuyla”. ");
INSERT INTO qva_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Paycuna manam tantiyapäcuranchu Taytanpita niycanganta. ");
INSERT INTO qva_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Chaymi Jesús niran: “Noga Diospita shamusha Runata crucificaycur ichrichingan hörarämi tantiyapäcunqui noga pï cangätapis. Quiquiläpita imatapis manam rurächu sinöga Taytä ninäpag cangalantam niycä. ");
INSERT INTO qva_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nogata cachramagnïga nogawanmi caycan. Taytä manam quiquiläta jaguirimanchu noga imaypis pay munangalanta ruraptï”. ");
INSERT INTO qva_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jesús chaynuy niptinmi achcag payman criyipäcuran. ");
INSERT INTO qva_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Payman Israel runacuna criyegcagcunata Jesús niran: “Yachrachingänuyla imaypis cawarga rasunpam discïpulücuna capäcunqui. ");
INSERT INTO qva_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Chaynuy cawarmi tantiyapäcunqui rasuncagta. Y rasuncagmi jucpa munayninpita jorgapäcushunqui”. ");
INSERT INTO qva_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Paycuna nipäcuran: “Nogacuna Abrahampa ayllunmi capäcü. Imaypis nogacuna pipa munayninchrüpis manam capäcushcächu. ¿Imanirtag nircämanqui jucpa munayninchrüna manana capäcunäpag canganta?” ");
INSERT INTO qva_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús niran: “Rasunpam gamcunata nï: Pipis juchäcular cawarga juchapa munayninchrümi esclävunuy caycan. ");
INSERT INTO qva_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Juc esclävu runaga juc aylluchru manam imaycamapis cangachu. Juc ayllupa wamranmi ichanga imaycamapis chay ayllula caycan. ");
INSERT INTO qva_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ichanga Tayta Diospa Wamran juchäcuypita jorgushuptiquega juchapa munayninchrünachu manam rasunpa canqui. ");
INSERT INTO qva_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Musyämi Abrahampa ayllun capäcungayquita. Ichanga wañuchiyta munapäcamanqui noga willacungäta mana chrasquicamayta munarmi. ");
INSERT INTO qva_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Noga rimä Taytä ricachimangancunatam. Chaynuy gamcunapis taytayquipita mayapäcungayquitam rurarcanqui”. ");
INSERT INTO qva_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Paycuna nipäcuran: “¡Abrahammi taytäcuna!” Ichanga Jesús niran: “Rasunpa Abrahampa ayllun carga pay cawangannuy cawapäcunquiman. ");
INSERT INTO qva_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Rasun cagta Tayta Dios yachrachimangantam willapashcä. Chaynuy captinpis gamcuna wañuchiyta munarcämanqui. Abrahamga imaypis chaynuychu manam ruraran. ");
INSERT INTO qva_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Gamcuna rurarcanqui taytayqui rurangannuylam”. Paycuna nipäcuran: “Nogacunaga manam churipacuychu cä. Nogacunapäga juclaylam Taytäcuna. Chayga Diosmi”. ");
INSERT INTO qva_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesús niran: “Tayta Dios rasunpa taytayqui captinga nogata cuyapäcamanquimanmi. Noga paypitam shamushcä y caychru caycä. Noga quiquiläpitachu manam shamushcä sinöga Tayta Diosmi cachramasha. ");
INSERT INTO qva_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Imanirtag gamcuna mana tantiyapäcunquichu ningäcunata? Willacungäta chrasquiyta mana munarmi ningäcunata mana tantiyapäcamanquichu. ");
INSERT INTO qva_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Gamcunapa taytayquega Satanasmi. Gamcuna paypam capäcunqui y pay munangantam rurayta munarcanqui. Unaypita pacham payga runa wañucheg. Imaypis rasuncagpa contran caycan. Payga imaypis manam rasuncagtaga rimanchu. Rimarga casquicunmi casquilata rimag car. Chaynuy carmi casquicogcunapa taytan. ");
INSERT INTO qva_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","“Ichanga noga rasuncagta niptï gamcuna mana criyipäcamanquichu. ");
INSERT INTO qva_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Noga juchaynagmi cä. Juchayog captïga, mä, maygalayquipis nipäcamay. Rasuncagta niycaptïga criyipäcamanquiman. ");
INSERT INTO qva_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Tayta Diospita cagcunaga ningancunata mayacunmi. Tayta Diospita mana carmi gamcuna mayacuyta mana munapäcunquichu”. ");
INSERT INTO qva_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Chauraga Israel runacuna nipäcuran: “¡Rasuncagtam nircä gam Samaria runa y diablupa munayninchru caycangayquita!” ");
INSERT INTO qva_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesús niran: “Manam diablupa munayninchrüchu caycä. Chaypa truquinga noga Taytäta respitämi. Gamcuna ichanga nogata mana respitäpäcamanquichu. ");
INSERT INTO qva_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Noga runacuna ali ricamänantachu manam ashiycä. Sinöga jucmi ashiycan. Paymi juzgangaga. ");
INSERT INTO qva_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Rasunpam gamcunata nï: Willacungäta cäsucamagcäga manam wañungachu”. ");
INSERT INTO qva_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Chay Israel runacuna nipäcuran: “Cananga shumag musyapäcü diablupa munayninchru caycangayquita. Abraham y Tayta Diospa willacognincuna wañushanam. Chaynuy caycaptinpis gam niycanqui: ‘Willacungäta cäsucamagcäga manam wañungachu’. ");
INSERT INTO qva_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Acäsu gam caycanqui taytäcuna Abrahampita mas munayniyogchu? Pay wañushanam y willacogcunapis wañushanam. ¿Pï cangayquitatag gam yarpanqui?” ");
INSERT INTO qva_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesús niran: “Noga quiquï alabacuptïga alabacungä manam välinchu. Quiquin ‘Diosnï’ nipäcungayqui Taytämi nogataga alabäman. ");
INSERT INTO qva_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Gamcuna manam reguipäcunquichu. Nogam ichanga reguï. ‘Noga manam reguïchu’ nirga gamcunanuymi casquicuycäman. Nogam ichanga rasunpa reguï y ningancunata cäsucü. ");
INSERT INTO qva_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Gamcunapa unay aylluyquicuna Abraham fiyupam cushicuran cay pachaman shamuptï ricamänanpag captin. Ricaranmi y cushicuranmi”. ");
INSERT INTO qva_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Chay Israel runacuna Jesusta nipäcuran: “Manarämi ni pichga chruncapis (50) watayqui canrächu y ¿‘Abrahamta ricashcä’ niycanqui?” ");
INSERT INTO qva_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesús niran: “Rasunpam gamcunata nï: Noga cä Abraham manaräpis captinmi”. ");
INSERT INTO qva_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Chauraga Jesusta sagmapäcunanpag rumita aptacäriran. Chauraga Jesús pacacuran y yarguran templupita. ");
INSERT INTO qva_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesús chaypa pasaycarmi yuringanpita pacha gapra runata ricaran. ");
INSERT INTO qva_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jesusta discïpuluncuna tapupäcuran: “Maestro, ¿imanirtag cay runa gapra yurisha? ¿Mamanpa y taytanpa juchanpitachu o quiquinpa juchanpitachu?” ");
INSERT INTO qva_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesús niran: “Manam quiquinpa ni mamanpa ni taytanpa juchanpitachu sinöga payta cuticächiptï munayninwan Tayta Dios ruranganta runacuna ricapäcunanpämi. ");
INSERT INTO qva_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Junag cangancama rurananchim cachramagnï Tayta Dios rurananpag cagcunata. Chacay chrayamuptin mananam pipis aruyta puedinganachu. ");
INSERT INTO qva_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Cay pachachru cangäcamaga runacunapag achquinuymi caycä”. ");
INSERT INTO qva_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Chaynuy nircurmi Jesús pampaman togaycur mituta ruraran. Nircurna gaprapa ñawinta lushiparan. ");
INSERT INTO qva_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Chaypita niran: “Ayway, Siloé pözuchru mayllacamuy”. (Siloé ninanga “Cachramusha” ninanmi.) Chay gapra aywaycur mayllacamuran. Chaypita ñawin cuticashana cutimuran. ");
INSERT INTO qva_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Chauraga vecïnuncuna y payta limusnata mañacuycagta ricagcuna nipäcuran: “¿Manachu cay jamacuycur limusnata mañacog gapra runa?” ");
INSERT INTO qva_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Waquincuna nipäcuran: “Au, paymi”. Waquincunanam nipäcuran: “Manam paychu. Ichanga pay niragmi”. Ichanga quiquin niran: “Au, nogam caycä”. ");
INSERT INTO qva_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Chauraga tapupäcuran: “¿Imanuypatag ñawiqui cuticasha?” ");
INSERT INTO qva_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Pay niran: “Jesús jutiyog runam mituta rurarcur ñawïman lushipämasha. Nircur nimasha: ‘Siloé pözuchru ñawiquita mayllacamuy’. Aywaycur mayllacaramuptïnam ñawï cuticasha”. ");
INSERT INTO qva_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Chauraga tapupäcuran: “¿Maychrütag chay runaga caycan?” Pay niran: “Manam musyächu”. ");
INSERT INTO qva_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Pushapäcuran fariseo runacunaman gapra canganpita cuticasha runata. ");
INSERT INTO qva_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jesús mituta rurangan junag y ñawinta cuticächingan junag sábado jamay junagmi caran. ");
INSERT INTO qva_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Fariseo runacunapis yapay tapupäcuran imanuypa ñawin cuticangantapis. Pay niran: “Ñawïmanmi mituta lushipämaran. Nircur mayllacurä y ricaycäna”. ");
INSERT INTO qva_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Waquin fariseucuna nipäcuran: “Chay runaga manam sábado jamay junagta respitanchu. Manam Tayta Diospitachu canman”. Waquincuna nipäcuran: “¿Imanuypatag juchäcog carga cay milagrucunata ruranman?” Chaynuy nir paycunapis manam chay yarpaylachu caran. ");
INSERT INTO qva_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Chauraga yapay tapupäcuran gapra canganpita cuticasha runata: “Ñawiquita cuticaycächiptinga gam paypita ¿ima ninquitag?” Chaynuy tapupäcuptinmi caynuy niran: “Tayta Diospa willacogninmi”. ");
INSERT INTO qva_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Israel runacunapa autoridänincunaga rasunpa gapra canganta y cuticasha canganta manam criyipäcuranchu mamanta y taytanta gayachimungancama. ");
INSERT INTO qva_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Chaychrüna caynuy tapupäcuran: “¿Cay runa wamrayquichu? Nipäcamay: ¿Rasunpachu gapra yuriran? ¿Imanuypatag cananga ricanna?” nir. ");
INSERT INTO qva_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Maman y taytan nipäcuran: “Musyapäcümi wamrä canganta y gapra yuringanta. ");
INSERT INTO qva_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ichanga manam musyapäcüchu imanuypa ricangantapis ni musyapäcüchu pï cuticächingantapis. Quiquinta tapupäcuy. Payga auquis runanam. Pay willapäcushunqui”. ");
INSERT INTO qva_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Maman y taytan Israel runacunapa autoridänincunata manchacurmi chaynuy nipäcuran. Paycuna parlanacusha caran pipis “Jesusga Tayta Dios cachramungan Salvadurmi” negcagtaga shuntacänan wasipita gargunanpag. ");
INSERT INTO qva_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Chayta manchacurmi maman y taytan nipäcuran: “Payga auquis runanam. Quiquinta tapupäcuy”. ");
INSERT INTO qva_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Gapra canganpita cuticasha runata Israel runacunapa autoridänincuna yapay gayachimuran. Nircur nipäcuran: “Diospa jutinchru rasuncagta willapäcamay. Musyapäcümi chay cuticächishogniqui runa juchäcog canganta”. ");
INSERT INTO qva_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Pay niran: “Juchäcog canganta manam musyächu. Nogaga musyä gapra cangäta y canan ricangätam”. ");
INSERT INTO qva_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Yapay tapupäcuran: “¿Imatatag rurashushcanqui? ¿Imatatag rurasha cuticächishunayquipag?” ");
INSERT INTO qva_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Chay runa niran: “Maynam nishcä. Ichanga mana cäsupämanquichu. ¿Imanirtag yaparir yaparir ninäta munapäcunqui? ¿Gamcunapis paypa discïpulucuna caytachu munarcanqui?” ");
INSERT INTO qva_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Chauraga ashlipäcuran y nipäcuran: “Gammi chay runapa discïpulun caycanqui. Nogacunaga Moisespa discïpuluncunam capäcü. ");
INSERT INTO qva_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Musyapäcümi Moiseswan Tayta Dios parlanganta. Ichanga chay runa maypita shamungantapis mana musyapäcüchu”. ");
INSERT INTO qva_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Chay runa niran: “¿Imanuytag chayga? Gamcuna mana musyapäcunquichu maypita shamungantapis. Nogata ichanga ñawïta cuticächimasha. ");
INSERT INTO qva_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Shumagmi musyanchi juchäcogcunataga Tayta Diosninchi mana cäsupanganta. Pay cäsupan adoragnintam y pay munanganta ruragcunatam. ");
INSERT INTO qva_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Pacha galaycunganpita pacha manam mayashcanchichu yuringanpita pacha gapra runata pipis cuticächinganta. ");
INSERT INTO qva_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Chay runa Tayta Diospita mana shamusha carga manam imatapis ruranmanchu”. ");
INSERT INTO qva_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Chauraga nipäcuran: “¿Gamga juchasapa yuriycarchu nogacunata yachrachipäcamanqui?” Nircur Israel runacunapa shuntacänan wasipita garguripäcuran. ");
INSERT INTO qva_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesús mayaran chay cuticächingan runata shuntacänan wasipita gargunganta. Tariycurna tapuran: “¿Gam criyinquichu Diospita shamusha Runaman?” ");
INSERT INTO qva_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Pay niran: “Tayta, nimay pitag chay runa noga payman criyinäpag”. ");
INSERT INTO qva_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesús niran: “Payta ricashcanquinam. Gamwan parlaycagmi pay”. ");
INSERT INTO qva_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Chauraga Jesuspa ñaupagninman gongurpacuycuran y niran: “Au, criyïmi, Tayta”. ");
INSERT INTO qva_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesús niran: “Noga cay pachaman shamushcä runa imanuypis canganta ricachinäpämi. Chaynuypa gapracuna ricananpag y ricagcuna gaprayänanpag”. ");
INSERT INTO qva_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ninganta mayaycur paywan chaychru caycag waquin fariseucuna nipäcuran: “¿Nogacunapis gapranuy cangätachu yarpanqui?” ");
INSERT INTO qva_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Chauraga Jesús niran: “Gapracunanuy carga juchayogchu manam capäcunquiman. Ichanga gamcuna nircanqui gapranuypis mana cangayquita. Chaynuy nirga juchayogmi carcanqui”. ");
INSERT INTO qva_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesús niran: “Rasunpam gamcunata nï: Üsha cunchraman puertapa mana yaycog cäga y juc lädupa yaycog cäga suwam y fiyu runam. ");
INSERT INTO qva_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Puertapa yaycog cagmi ichanga üshapa michegnin. ");
INSERT INTO qva_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Cuydagnin cunchra puertata quichrapan. Üshacuna michegpa shiminta mayan. Michegnin jutinpa cama üshancunata gayan. Chaypitana cunchrapita pushan. ");
INSERT INTO qva_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Lapan yargaramuptinna michegnin ñaupagninta aywan y üshancuna shiminta reguir guepanta aywapäcun. ");
INSERT INTO qva_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Jäpa captinga manam gatiranchu. Gatiränanpa truquinga shiminta mana reguir gueshpirmi aywacärin”. ");
INSERT INTO qva_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús chaynuy tincuchiypa willaparan. Ichanga paycuna mana tantiyaranchu imata niycangantapis. ");
INSERT INTO qva_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jesús yapay niran: “Rasunpam gamcunata nï: Nogaga caycä üsha yaycunanpag cunchrapa puertannuymi. ");
INSERT INTO qva_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nogapa puntäta shamusha cäga lapanpis suwam y fiyu runam. Ichanga üshacuna manam cäsupashachu. ");
INSERT INTO qva_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nogam puertanuy caycä. Noga cagpa yaycogcäga salvacungam. Yaycog yargamog üsha ali guewata taregnuymi canga. ");
INSERT INTO qva_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Suwaga shamun suwacunalanpag, wañuchinalanpag y ushacächinalanpämi. Nogam ichanga shamushcä mana ushacaypa shumag cawayta tarinanpag. ");
INSERT INTO qva_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Nogam ali micheg caycä. Ali michïga üshancuna raycum wañunga. ");
INSERT INTO qva_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Päganan raycula michegcäga atog shamogta ricar üshacunata jaguiriycur gueshpicun. Gueshpicun mana michegnin car y quiquinpa mana captin. Chauraga atog üshata chariptin waquin intërupa mashtacar aywacun. ");
INSERT INTO qva_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Chay runaga gueshpin päganan raycula carmi manam üshacuna raycu carchu. ");
INSERT INTO qva_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Nogam ali michïga cä. Reguïmi üshäcunata y nogapa cäga reguimanmi ");
INSERT INTO qva_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Taytä nogata reguimangannuy y noga Taytäta reguingänuy. Chaymi üshäcuna raycu wañushag. ");
INSERT INTO qva_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Caycanmi üshäcuna cay cunchrapita juc läduchru. Chaycunatapis shuntamunämi. Paycuna ningäcunata mayar cäsucärimangam. Lapan juclaylachrüna gotucasha canga y juc michegnilanwanna canga. ");
INSERT INTO qva_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Taytä cuyaman paycuna raycu wañunäpag y cawarimunäpag captin. ");
INSERT INTO qva_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nogata pipis manam wañuchimanchu sinöga quiquï munaynïpam wañushag. Noga wañunämi y munayniyogmi cä cawarimunäpag. Chaynuy ruranäpämi Taytä nimasha”. ");
INSERT INTO qva_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jesús ninganta mayarmi Israel runacuna juc yarpayman juc yarpayman yapay chrayapäcuran. ");
INSERT INTO qva_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Paycunapita achcag nipäcuran: “¿Imanirtag cäsupäpäcunqui? Pay diablupa munayninchrümi caycan. Y löcuyasham caycan”. ");
INSERT INTO qva_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Waquin ichanga nipäcuran: “Pipis diablupa munayninchru carga manam chaynuy ninmanchu. ¿Diabloga gapra runata cuticächinmanchu?” ");
INSERT INTO qva_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tamya quilla wichan Jerusalenchru templo fiestata rurarcaran. ");
INSERT INTO qva_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesús templuchru caycar “Salomón” jutiyog ramädachru puriycaran. ");
INSERT INTO qva_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Chaychrümi Israel runacunapa autoridänincuna Jesusta muyupaycur tapupäcuran: “¿Imaycamatag rasuncagta willapäcamänayquipag shuwaräpäcushayqui? Tayta Dios cachramungan Salvador carga jucla willapäcamay”. ");
INSERT INTO qva_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesús niran: “Maynam gamcunata willashcä. Manam criyipäcamanquichu. Taytäpa munayninwan rurangäcunam musyacächin pï cangätapis. ");
INSERT INTO qva_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ichanga gamcuna nogapa üshacuna mana carmi mana criyipäcamanquichu. ");
INSERT INTO qva_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Üshäcunaga shimïta mayaman y noga paycunata reguï. Y paycuna gatiräpäcaman. ");
INSERT INTO qva_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nogam mana ushacaypa cawayta goshag. Manam imaypis wañungachu y manam pipis quïtamangachu. ");
INSERT INTO qva_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Taytämi chayta gomasha. Paymi pï maypitapis munayniyog. Paypita manam pipis paycunata jorguyta puedingachu. ");
INSERT INTO qva_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Taytäwan nogaga juclaylam capäcü”. ");
INSERT INTO qva_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Israel runacunapa autoridänincuna rumita yapay jogarcapäcuran Jesusta sagmapäcunanpag. ");
INSERT INTO qva_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesús niran: “Ricarcaptiquim Taytäpa munayninwan alicagcunata achcata rurashcä. ¿Mayganpitatag sagmayta munarcämanqui?” ");
INSERT INTO qva_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Israel runacunapa autoridänincuna nipäcuran: “Alicunata rurangayquipitaga manam sagmapäcushayquichu sinöga Tayta Diospa contran lutanta rimangayquipita. Gam runala caycarpis Diostucuycanqui”. ");
INSERT INTO qva_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesús niran: “Escribichinganchru Dios niran: ‘Gamcunaga dioscunam caycanqui’. ");
INSERT INTO qva_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Musyanchim Tayta Dios escribichinganchru ninganta mana niegananchipag canganta. Tayta Dios willacuyninta mayagcunataga ‘Gamcunaga dioscunam carcanqui’ nisha. ");
INSERT INTO qva_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Taytä nogata acrarcamar cay pachaman cachramasha. Chauraga ¿imanirtag ‘Diospa Wamranmi cä’ ningäpita Tayta Diospa contran lutanta rimangäta nircanqui? ");
INSERT INTO qva_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Taytä rurananpag cagcunata noga mana ruraptïga ama criyipäcamaychu. ");
INSERT INTO qva_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ichanga chaycunata ruraptïga nogaman mana criyimarpis rurangäcunata ricaycarga criyipäcunquiman. Chaynuypa shumag musyapäcunqui Taytä nogawan juc runanuyla caycanganta y noga Taytäwan juc runanuyla caycangäta”. ");
INSERT INTO qva_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yapay prësu charichiyta munapäcuptin Jesús gueshpir aywacuran. ");
INSERT INTO qva_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Chaypitana Jordán mayupa jucag lädunman Jesús cutiran y chaychrüna quëdacuran. Chaychrümi puntata Juan Bautista runacunata bautizaran. ");
INSERT INTO qva_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Pay cangan cagman achcag runacuna aywapäcuran y nipäcuran: “Juan Bautista milagruta mana rurasha payta Dios rasunpa cachramunganta musyacänanpag. Chaynuy captinpis Juan cay runapita ningancunaga lapanpis rasunpa cagmi”. ");
INSERT INTO qva_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Chaychru achcag Jesusman criyipäcuran. ");
INSERT INTO qva_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betania marcapita Lázaro jutiyog runa gueshyaycaran. Chaychru tiyaran María y Mariapa ñañan Marta. ");
INSERT INTO qva_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Mariam Señor Jesuspa chraquinman perfümita gaycapaycur agchanwan chaquichiparan. Mariapa turin Lázaro gueshyasha caran.) ");
INSERT INTO qva_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Chaymi ishcan panicuna Jesuscagman caynuy ninanpag cachracuran: “Tayta, cuyanacungayqui Lázaro gueshyaycan” ninanpag. ");
INSERT INTO qva_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Chaynuy willaptinmi Jesús niran: “Lazaruta chay gueshya charisha manam wañungalanchru quëdananpächu, sinöga Tayta Dios munayniyog cangan y Diospa Wamran munayniyog cangan musyacänanpämi”. ");
INSERT INTO qva_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Martata ñañan Mariatawan y Lazaruta Jesús cuyaran. ");
INSERT INTO qva_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lázaro gueshyaycanganta musyar chay caycanganchru Jesús ishcay junag mas quëdacuran. ");
INSERT INTO qva_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Chaypitana discïpuluncunata Jesús niran: “Acu, yapay aywashun Judeaman”. ");
INSERT INTO qva_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Discïpuluncuna nipäcuran: “Maestro, ganyancunarätag chaychru cag Israel runacunapa autoridänincuna sagmaypa wañuchiyta munapäcushushcanqui. ¿Chaynuy caycaptinchu yapay aywayta munaycanqui?” ");
INSERT INTO qva_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesús niran: “Musyanganchinuypis juc junag ishcay chrunca hörayogmi. Chaymi junagpa purirga cay pachachru achqui captin runa mana mitcanchu. ");
INSERT INTO qva_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ichanga chacaypa purir achqui mana captin runa mitcan”. ");
INSERT INTO qva_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nircurnam discïpuluncunata Jesús niran: “Amïgunchi Lázaro puñucasham caycan. Aywä; riccharachimushag”. ");
INSERT INTO qva_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Discïpuluncuna nipäcuran: “Tayta, puñucasha carga sänangam”. ");
INSERT INTO qva_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Lázaro wañusha canganta Jesús niptinpis discïpuluncunaga mana tantiyar puñucasha caycangantam yarpäpäcuran. ");
INSERT INTO qva_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Chauraga Jesús discïpuluncunata shumag niran: “Lazaroga wañusham caycan. ");
INSERT INTO qva_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Noga cushicü Lázaro cangan cagchru mana cangäpita. Chaynuy cangan mas ali caycan gamcuna criyipäcunayquipag. Pay cagman acu aywashun”. ");
INSERT INTO qva_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Chauraga Milïshu nipäcungan Tomasmi discïpulumasincunata niran: “Noganchipis aywashun Jesuswan wañunanchipag”. ");
INSERT INTO qva_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Betaniaman chrayar Jesús tariran chruscu junagna Lázaro pamparaycanganta. ");
INSERT INTO qva_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania marcapita Jerusalenman cerca quimsa kilömetrunuylam captin ");
INSERT INTO qva_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","achcag Israel runacuna Martatawan Mariata turin wañunganpita yanagänanpag aywapäcusha caran. ");
INSERT INTO qva_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jesús nagana chrayaycanganta musyarmi taripag Marta aywaran. María ichanga wasichru quëdaran. ");
INSERT INTO qva_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta Jesusta niran: “Tayta, caychru captiquega turï manam wañunmanchu caran. ");
INSERT INTO qva_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ichanga musyämi cananpis Tayta Diosta imata rugacuptiquipis goshunayquipag canganta”. ");
INSERT INTO qva_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesús niran: “Turiqui cawarimungam”. ");
INSERT INTO qva_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta niran: “Au, noga musyämi últimu junagchru wañushacuna cawarimuptin paypis cawarimunanpag canganta”. ");
INSERT INTO qva_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesús niran: “Nogam wañushacunata cawarichimog y cawacheg caycä. Nogaman criyegcäga wañurpis cawangam. ");
INSERT INTO qva_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Lapan cawagcuna y nogaman criyimagcuna imaypis manam wañungachu. ¿Chayta criyinquichu?” ");
INSERT INTO qva_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta niran: “Au, tayta. Noga criyïmi gam Tayta Dios cachramungan Salvador y Diospa Wamran cangayquita. Y cay pachaman shamunanpag cag cangayquita”. ");
INSERT INTO qva_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Chaynuy nircurmi Marta ñañan Mariata gayag cutiran. Chrayaycurna pacaylapa niran: “Maestro caychrünam caycan. Gayaycäshunqui” nir. ");
INSERT INTO qva_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Chaynuy niptin María jucla sharcurcur payman aywaran. ");
INSERT INTO qva_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús manarag marcaman yaycuranrächu. Martawan tincungalanchrürämi caycaran. ");
INSERT INTO qva_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","María jucla sharcurcur yargogta ricapäcurmi turin pamparanganman wagag aywaycanganta yarpar paywan wasichru yanagag Israel runacuna guepanta aywapäcuran. ");
INSERT INTO qva_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jesús cagman María chrayar ricaycur ñaupagninman gongurpacuycur niran: “Tayta, caychru captiquega turï manam wañunmanchu caran”. ");
INSERT INTO qva_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Mariata y paywan aywamog Israel runacunata wagaycagta ricarmi Jesuspis fiyupa laquicuran. ");
INSERT INTO qva_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Jesús paycunata tapuran: “¿Mayninchrütag pamparaycan?” nir. Paycuna nipäcuran: “Acu, aywashun ricanayquipag, tayta”. ");
INSERT INTO qva_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesús wagaran. ");
INSERT INTO qva_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Israel runacuna nipäcuran: “Ricay, pasaypa cuyanacurunag”. ");
INSERT INTO qva_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ichanga waquincuna nipäcuran: “Gapra runatapis cuticaycächirga ¿manachurag Lazarutapis mana wañunanpag cuticächinman caran?” ");
INSERT INTO qva_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yapay pasaypa laquisham Jesús ashuycuran Lázaro pamparangan cagman. Chay chagachru machraymi caran. Yaycunan jatun rumiwan chapararan. ");
INSERT INTO qva_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesús niran: “Chaparaycag rumita ashuchipäcuy”. Lazarupa panin Marta niran: “Tayta, fiyupanachrar asyaycan. Chruscu junagnam pamparaycan”. ");
INSERT INTO qva_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesús niran: “¿Manachu nirä nogaman criyirga Tayta Dios munayniyog canganta ricanayquipag?” ");
INSERT INTO qva_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Chauraga chaparaycag rumita ashuchipäcuran. Jesús cieluta ricärir niran: “Tayta, agradecicamü rugacungäta mayamangayquipita. ");
INSERT INTO qva_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Noga musyämi imaypis mayamangayquita. Ichanga caychru caycag runacuna raycum niycä. Chaynuypa gam cachramangayquita criyipäcunanpag”. ");
INSERT INTO qva_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Chaynuy nircurna fiyupa gayacuran: “¡Lázaro, yargamuy!” ");
INSERT INTO qva_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Chauraga wañusha caycag cawarircamur yargamuran maquin chraquin watasha y cäran wancusha. Jesús niran: “Pasquipäpäcuy purinanpag”. ");
INSERT INTO qva_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Chaynuy ruranganta ricaycurmi Mariata yanagänanpag aywag Israel runacuna Jesusman achcag criyipäcuran. ");
INSERT INTO qva_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Waquin cagnam ichanga fariseo runacunaman aywaran Jesús imata rurangantapis willananpag. ");
INSERT INTO qva_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Chauraga fariseo runacuna y cüracunapa mandagnincuna Israel mayor autoridäcunata shuntaycachimur nipäcuran: “¿Imatatag rurashun? Cay runa achca milagrucunata ruraycan payta Dios rasunpa cachramunganta musyachinanpag. ");
INSERT INTO qva_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Jaguiricushaga lapan runacuna payman criyipäcunga. Chaynuy captin Romapa mandagnincuna aywamunga templunchita juchruchinanpag y naciunninchita ushacächinanpag”. ");
INSERT INTO qva_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Chauraga Caifás paycunapita jucnincag chay wata cüracunapa mas mandagnin caycar niran: “¡Gamcunaga manam imatapis musyapäcunquichu! ");
INSERT INTO qva_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ni gamcunaga yarpachracärinquichu intëru nacion ushacänanpa truquin juc runala Israel runacunapa truquin wañunanpag gamcunapag ali canganta”. ");
INSERT INTO qva_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Caifás niran manam quiquilanpitachu sinöga cüracunapa mas mandagnin chay wata captinmi Tayta Diosninchi payta parlachiran Jesús Israel runacunapa truquin wañunanpag canganta. ");
INSERT INTO qva_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Manam chay Israel runacunalapächu sinöga intëruchru Tayta Diosninchipa wamrancuna mashtacasha shuntacänanpämi. ");
INSERT INTO qva_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Chauraga chay junagpitanam Israel mayor autoridäcuna rimanacäriran Jesusta wañuchipäcunanpag. ");
INSERT INTO qva_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Chaymi Jesús Israel runacuna ricaynaga manana purirannachu. Chaymi caycanganpita discïpuluncunawan Jesús chunyag jirca cercanchru caycag Efraín jutiyog marcaman aywacuran chaychru goyänanpag. ");
INSERT INTO qva_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nagana Israel runacunapa Pascua fiestan chrayaycämuranna. Chaymi manarag fiesta chrayamuptin achca runacuna marcancunapita Jerusalenman aywarcaran purificacärinanpag. ");
INSERT INTO qva_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jesusta ashircaran. Templuchru carcarna jucnin jucninpis tapunacäriran: “¿Imatatag yarpäpäcunqui? ¿Fiestaman Jesús shamungachurag o manachurag?” nir. ");
INSERT INTO qva_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Fariseo runacunawan cüracunapa mandagnincuna maynam runacunata nisha casha Jesús maychrüpis canganta musyarga prësu charichipäcunanpag willananpag. ");
INSERT INTO qva_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pascua fiestapag sogta junag pishiycaptin Jesús aywaran Betania marcaman. Chaychrümi Lázaro tiyaran; Jesús paytam wañunganpita cawarichimusha caran. ");
INSERT INTO qva_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Chaychrümi Jesús chrayanganpita cushicur cënata rurapäcuran. Marta garacuycaran. Lazaruna mësachru Jesuswan micurcaran. ");
INSERT INTO qva_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","María chranin cuestag perfümita apamuran. Chay caran nardupita medio litrunuy. Chay perfümitam Jesuspa chraquinman gaycaparan. Nircurmi agchanwan chaquichiparan. Chay perfümi wasi junta asyaran. ");
INSERT INTO qva_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Chauraga discïpulun Judas Iscariote Jesusta entregag niran: ");
INSERT INTO qva_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“¿Imanirtag cay perfümita mana ranticushcanchichu? Ranticushwan caran quimsa pachrac (300) junagcuna arur runa gänanganchrünuy. Nircur chayta pobricunata aypushwan caran”. ");
INSERT INTO qva_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas pobricunata cuyaparchu manam niran sinöga suwa carmi. Paymi guellay wardacuna cäjata chararag caran. Chayman gaycapäcunganpita jorguchrag carmi. ");
INSERT INTO qva_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesús niran: “Jina rurachun. Chay perfümita chrurarächisha wañuptï gaycapämänanpämi. ");
INSERT INTO qva_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Pobricunaga imaypis gamcunawanmi caycangapag. Nogam ichanga gamcunawan manana cashäpänachu”. ");
INSERT INTO qva_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Achcag Israel runacuna musyapäcuran Jesús Betania marcachru caycanganta. Chayman aywapäcuran manam Jesusta ricanalanpächu sinöga pay cawarichimusha Lazarutapis ricapäcunanpämi. ");
INSERT INTO qva_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Chaymi cüracunapa mandagnincuna parlapäcuran Lazarutapis wañuchipäcunanpag. ");
INSERT INTO qva_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Lazaruta cawarichimunganpitam achcag Israel runacuna autoridänincunapita aywacuycaran y Jesusman criyipäcuran. ");
INSERT INTO qva_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Achcag runacuna Jerusalenman aywapäcusha casha Pascua fiestapag. Warantin mayapäcuran Jesús chay marcaman chrayananpag canganta. ");
INSERT INTO qva_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Chauraga palmera jachrapa rämanta cuchupäcuran. Chaywan Jesusta chrasquicunanpag runacuna caynuy nir gaparpaycar yargapäcamuran: “¡Tayta Diosninchi alabasha cayculächun! ¡Tayta Diosninchi cachramungan runa alabasha cayculächun! ¡Israel runacunapa mandagnin Rey alabasha cayculächun!” nir. ");
INSERT INTO qva_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesús tariran juc manta bürruta y chayta logacuran Tayta Diosninchi escribichinganchru caynuy ningannuyla: ");
INSERT INTO qva_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Jerusalenchru tiyagcuna, ama manchacuychu. Ricapäcuy, Reyniqui manta bürritun logashalam aywaycämun”. ");
INSERT INTO qva_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Chaynuy ruranganta galaycunanchrüga discïpuluncuna manam tantiyapäcuranchu. Jesús cieluman aywacuruptinrämi tantiyapäcuran paypag rurangancuna Tayta Dios escribichinganchru ningannuyla caycanganta. ");
INSERT INTO qva_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lázaro pamparaycagta yargamunanpag gayangan y wañunganpita cawarichimungan höra achca runacunam Jesuswan caran. Chay runacunam ricapäcunganta willacäreg. ");
INSERT INTO qva_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Chaymi runacuna Jesusta chrasquicog yargapäcamuran chay milagru ruranganta mayaycärir. Chay milagruta ruraran payta Dios rasunpa cachramunganta musyacänanpag. ");
INSERT INTO qva_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ichanga fariseucuna jucnin jucnin ninacäriran: “Caynuypa imatapis manam rurashunchu. Ricapäcuy, ¡lapan runacuna payman aywacurcan!” ");
INSERT INTO qva_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Fiestachru Diosta adoränanpag aywag runacunachrümi juc ishcay mana Israel runacunapis aywapäcusha casha. ");
INSERT INTO qva_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Cay runacuna Felipiman ashuycapäcuran. Felipe Galilea marca Betsaidapita caran. Paytam chay runacuna rugapäcuran: “Jesustam reguiyta munarcä, tayta” nir. ");
INSERT INTO qva_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Rugacäriptinmi Felipe Andrescagman aywaycur willaran. Chaypitana ishcan aywaycur Jesusta willaran. ");
INSERT INTO qva_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Chauraga Jesús niran: “Höra chrayamushanam nogapa wañuynï cayninpa noga Diospita shamusha Runa munayniyog cangäta Dios runacunata musyachinanpag. ");
INSERT INTO qva_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Rasunpam gamcunata nï: Trïgu pampaman shicwar mana wiñamurga chaylachrümi quëdan. Allpaman chrayagcagmi ichanga wiñamur achcata wayun. ");
INSERT INTO qva_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Quiquin munangannuy cawagcuna mana ushacaypa cawayman mana chrayangachu. Quiquin munangannuy cay pachachru mana cawagcunaga mana ushacaypa cawaymanmi chrayanga. ");
INSERT INTO qva_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Pipis mandangäta rurayta munarga nogawan aywacuchun. Chay mandangäta ruräga noga cangäcagchrümi canga. Pipis mandangäta ruragcagtaga Taytä alipämi ricanga. ");
INSERT INTO qva_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Canan höra fiyupa laquicuy charimasha. ¿Cananga imatatag nishag? ¿‘Tayta, pasamänanpag cagcunapita salvaycamay’ nishächu? Ichanga noga chaynuy wañunäpämi shamushcä. ");
INSERT INTO qva_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tayta, gam munayniyog cangayquita runacunata musyachiy”. Chauraga cielupita mayacämuran: “Munayniyog cangäta runacunata musyachishcänam y yapaymi paycunata musyachishag”. ");
INSERT INTO qva_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Chaychru caycag runacuna chayta mayaycur räyu canganta nipäcuran. Waquinna nipäcuran: “Angilmi payta gayacamusha”. ");
INSERT INTO qva_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesús niran: “Manam noga mayanäpächu gayacamusha sinöga gamcuna mayapäcunayquipämi gayacamusha. ");
INSERT INTO qva_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Cananmi cay pachachru runacuna juzgasha canga y cananmi gargusha canga runata munayninchru chararag Satanaspis. ");
INSERT INTO qva_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nogata crucificashata pampapita jogarcarärimaptinna runacunata nogacagman shuntashag”. ");
INSERT INTO qva_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Chaynuy nirmi Jesús tantiyachiran imanuypa wañunanpag cangantapis. ");
INSERT INTO qva_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Runacuna nipäcuran: “Tayta Diosninchi escribichingan musyachipäcaman Dios cachramungan Salvador imaycamapis cawananpag cangantam. Gam, ¿imanirtag niycanqui Diospita shamusha Runa crucificasha pampapita jogarcusha cananpag canganta? ¿Pitag chay Diospita shamusha Runa caycan?” ");
INSERT INTO qva_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesús niran: “Achquinuypis caycag gamcunawanrämi caycangapag. Achqui cangancama puripäcuy manaräpis yananyay chrayamungancama. Yananyaypa puregcäga maypa aywangantapis manam musyanchu. ");
INSERT INTO qva_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Achquinuypis gamcunachru caycangäcama criyipäcamay gamcunapis achquinuypa wamran capäcunayquipag”. Chaynuy nircurna Jesús aywacuran. Chaypitana runacuna mana musyapäcuranchu maychru cangantapis. ");
INSERT INTO qva_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Achca milagrucunata Jesús rurasha Dios payta rasunpa cachramunganta musyachinanpag. Ricarcaptin milagrucunata ruraptinpis payman mana criyipäcuranchu. ");
INSERT INTO qva_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Chaynuy caran Tayta Diosninchipa willacognin Isaías escribingan cumplinanpag: “Tayta Dios, willacuyninchita runacuna manam criyipäcushachu. Munayniquiwan milagrucunata ruranganta manam criyipäcushachu”. ");
INSERT INTO qva_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Chauraga paycuna criyiyta mana camäpacuranchu. Mana criyegcunapag Isaías mastapis caynuy escribiran: ");
INSERT INTO qva_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Tayta Diosmi ñawinta gaprayächisha y yarpayninta upatacächisha mana ricapäcunanpag y mana tantiyapäcunanpag, payman mana yäracärinanpag y pay mana perdunänanpag”. ");
INSERT INTO qva_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías chaynuy escribiran Jesús munayniyog canganta ricasha carmi. Chaymi paypita chaynuy niran. ");
INSERT INTO qva_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Chaynuy captinpis Israel runacunapa achcag autoridänincuna Jesusman criyipäcuran. Criyipäcunganta runa mayayga mana rimacäriranchu shuntacänan wasipita fariseucuna gargunanta manchacur. ");
INSERT INTO qva_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Tayta Diospita ali ricasha cananpa truquinga paycunaga mas munapäcuran runacunapita ali ricasha caytam. ");
INSERT INTO qva_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Fiyupa Jesús niran: “Nogaman criyegcäga manam nogalatachu criyiman; cachramagnï Taytämanpis criyiycanmi. ");
INSERT INTO qva_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nogata ricamagcäga cachramagnï Taytätapis ricaycanmi. ");
INSERT INTO qva_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Noga achquinuypis carmi cay pachaman shamushcä nogaman criyegcäga yananyaychrünuy mana quëdananpag. ");
INSERT INTO qva_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Ningäcunata mayasha caycar mana cäsucamaptinga noga manam castigäshächu. Runacunata manam castigänäpächu shamushcä sinöga salvanäpämi. ");
INSERT INTO qva_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Pipis nogapa conträ cagta y ningäcunata mana cäsucamagcagta juzgananpag caycannam. Noga willacur ningäcunam últimu junag castïguman chruranga. ");
INSERT INTO qva_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nogaga manam quiquiläpitachu niycä sinöga cachramag Taytämi nimasha imatapis ninäpag. ");
INSERT INTO qva_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Noga musyämi Taytä ninganga mana ushacaypa cawaypag canganta. Chaymi noga niycä Taytä nimangannuyla”. ");
INSERT INTO qva_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Manaräpis Pascua fiesta captin Jesús musyaranna cay pachapita Taytancagman aywacunanpag höra chrayamunganta. Cay pachachru yäracognincunata cuyar wañungancama pay cuyaran. ");
INSERT INTO qva_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Paycuna micungancama Simón Iscariotipa wamran Judaspa shongunman Satanás mayna autoridäcunaman Jesusta entregänanpag yarpayta chrurasha casha. ");
INSERT INTO qva_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesús musyaranmi lapan imaycatapis maquinman Taytan chruranganta. Chaynuypis musyaran paypita aywamunganta y payman cutinanpag canganta. ");
INSERT INTO qva_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Chaynuy canganta musyarmi Jesús cënaycanganpita sharcurcur janancag röpanta jorgurir toallata cheglaman watacuran. ");
INSERT INTO qva_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Chaypitana lavatoriuman yacuta tacshircur discïpuluncunapa chraquinta mayllaparan. Nircurna cheglanchru watarangan toallawan chaquichiparan. ");
INSERT INTO qva_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Chraquinta mayllapänanpag caycaptinmi Simón Pedro niran: “Tayta, ¿gamchu nogapa chraquïta mayllapämanqui?” ");
INSERT INTO qva_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesús niran: “Canan gam manam tantiyanquichu imanir ruraycangäta; chaypitaran tantiyanqui”. ");
INSERT INTO qva_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedro niran: “Imaypis manam dëjacushächu chraquïta mayllapämänayquita”. Jesús niran: “Mana mayllapaptïga nogapachu manam gam canqui”. ");
INSERT INTO qva_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simón Pedro niran: “Chauraga, Tayta, chraquilätaga ama mayllapämaychu; maquïtapis umätapis mayllapaycalämay”. ");
INSERT INTO qva_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesús niran: “Chayrag armacushaga limpium carcaycan; manam yapay armacunmanchu sinöga chraquilantam mayllacunman. Gamcunaga limpium carcanqui. Ichanga manam lapayquichu”. ");
INSERT INTO qva_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Pï entregänantapis musyarmi niran: “Manam lapayquichu limpiu carcanqui”. ");
INSERT INTO qva_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Discïpuluncunapa chraquinta mayllaparcurna röpan jorgunganta jaticurcur mësaman yapay jamacuran. Nircurna niran: “¿Tantiyapäcunquichu imanir chaynuy rurangäta? ");
INSERT INTO qva_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Gamcuna ‘Maestro’ y ‘Tayta’ nircämanqui. Chayta alitam nircanqui; chaynuymi cä. ");
INSERT INTO qva_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Maestro y Tayta caycar chraquiquicunata mayllapaycaptïga gamcunapis quiquiquipura mayllapänacärinayqui. ");
INSERT INTO qva_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Gamcunapis noganuy rurapäcunayquipämi chaynuy gamcunata rurashcä. ");
INSERT INTO qva_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Rasunpam gamcunata nï: Uywayga patrunninpita mas manam canchu. Chaynuylam cachra aywagpis cachragninpita mas manam canchu. ");
INSERT INTO qva_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Cay ningäcunata musyarga y rurarga cushisham cawapäcunqui. ");
INSERT INTO qva_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Manam lapayquipächu niycä. Noga musyämi mayganta acrangätapis. Ichanga Tayta Dios caynuy escribichingan cumplinanmi: ‘Nogawan micogmi conträ sharcusha’. ");
INSERT INTO qva_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Cay ningäcuna manarag pasaptinmi canan niycä. Ningänuyla pasaptinna musyapäcunqui noga pï cangätapis. ");
INSERT INTO qva_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Rasunpam gamcunata nï: Cachrangäcunata chrasquicogcunaga nogatam chrasquicaycäman. Nogata chrasquimagcunaga cachramagnïtapis chrasquiycan”. ");
INSERT INTO qva_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Chaynuy nircurmi Jesús pasaypa laquisha niran: “Rasunpam gamcunata nï: Gamcunapita jucniquim chriquimagnïcunaman entregämanga”. ");
INSERT INTO qva_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Chauraga discïpuluncuna mayganpag ningantapis mana musyar jucnin jucnin ricapänacuyta galaycäriran. ");
INSERT INTO qva_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jesuspa lädunchrümi paypa cuyay discïpulun caycaran. ");
INSERT INTO qva_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simón Pedro sëñasyaran mayganpag parlaycangantapis Jesusta tapunanpag. ");
INSERT INTO qva_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Pay Jesuscagman ashuycur tapuran: “Tayta, ¿pitag?” nir. ");
INSERT INTO qva_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesús niran: “Juc partin tantata ushmarcachir gongäcagmi”. Y tantata ushmarcachir Simón Iscariotipa wamran Judasta aptaparan. ");
INSERT INTO qva_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Chay tantata chrasquiruptinnam Judasman Satanás yaycuran. Y Jesús niran: “Ruranayquipag cagtaga jucla ruray”. ");
INSERT INTO qva_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Mayganpis chaychru cënarcagcuna manam tantiyaranchu imanir chaynuy niycangantapis. ");
INSERT INTO qva_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas guellay chararag captinmi waquin yarpäpäcuran fiestapag rantipacamog o pobricunata imalatapis goycog Jesús cachraycanganta. ");
INSERT INTO qva_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Tantata chrasquircurnam Judas yargur aywacuran. Chay caran pacha chacashanam. ");
INSERT INTO qva_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas yargur aywaruptinmi Jesús niran: “Cananmi noga Diospita shamusha Runa munayniyog cangä musyacanga y noga caynïpa Tayta Dios munayniyog cangan musyacanga. ");
INSERT INTO qva_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Noga Diospita shamusha Runa Tayta Dios munayniyog canganta musyachiptï noga munayniyog cangäta Tayta Diospis musyachinga. Chayta juclam ruranga. ");
INSERT INTO qva_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Wamränuy cagcuna, gamcunawan walca tiempulanam cashag. Gamcuna ashipäcamanquim. Canan gamcunatapis nï Israel runacunapa autoridänincunata ningänuylam: ‘Noga aywangämanga manam aywayta puedipäcunquichu’. ");
INSERT INTO qva_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Cay mushog mandamientuta nishayqui: ‘Jucniqui jucniquipis cuyanacärinqui. Cuyanacärinqui jucniqui jucniquipis noga gamcunata cuyangänuy’. ");
INSERT INTO qva_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Jucniqui jucniquipis cuyanacäriptiqui pï maypis tantiyanga nogapa discïpulü cangayquita”. ");
INSERT INTO qva_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedro tapuran Jesusta: “Tayta, ¿maypatag aywanqui?” Jesús niran: “Noga aywangä cagman manarämi cananga aywanquimanrächu. Chaypitanam ichanga aywanquipag”. ");
INSERT INTO qva_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedro niran: “Tayta, ¿imanirtag canan mana aywämanchu? Gam raycu wañunäpag listum caycä”. ");
INSERT INTO qva_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesús niran: “¿Rasunpachu noga raycu wañunayquipag listu caycanqui? Rasunpam gamta nï: Manarag gällu cantaptinmi quimsa cutina reguimangayquita niegamanqui”. ");
INSERT INTO qva_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Gamcuna ama laquicäriychu. Tayta Diosman yäracäriy y nogamanpis yäracärimay. ");
INSERT INTO qva_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Taytäpa wasinga jatunmi jäcuycan tiyanapag. Mana jäcuptinga ‘Gamcuna tiyanayquipag camarimushag’ nïmanchu manam caran. ");
INSERT INTO qva_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Aywacurirna gamcunapag camarishag. Nircurna cutimushag pushanäpag noga cangäcagchru gamcunapis capäcunayquipag. ");
INSERT INTO qva_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Gamcuna musyanquim may camiñupa noga aywangäcagman chrayanayquipag cangantapis”. ");
INSERT INTO qva_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomás niran Jesusta: “Tayta, manam musyapäcüchu mayman aywangayquitapis. ¿Imanuypatag musyapäcüman maygan camiñu cangantapis?” ");
INSERT INTO qva_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús niran: “Nogam camiñu, rasuncag y cawacheg caycä. Nogalam caycä Taytäcagman pipis chrayananpag. ");
INSERT INTO qva_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nogata reguipäcamanquim. Reguimar Taytätapis reguipäcunquim. Cananpitanam reguipäcunqui y ricapäcushcanquinam”. ");
INSERT INTO qva_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Felipe niran: “Tayta, Taytayquita ricachipäcamay. Chaylatam munarcä”. ");
INSERT INTO qva_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesús niran: “Felipe, unaypitanatag gamcunawan caycä; ¿manarächu reguimanquirag? Nogata ricamagcäga Taytätapis ricashanam. ¿Imanirtag nimanqui Taytäta ricachinäpag? ");
INSERT INTO qva_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Manachu criyinqui noga Taytäwan juc runanuyla caycangäta y paypis nogawan juc runanuyla caycanganta? Noga gamcunata ningäcuna manam quiquiläpitachu sinöga nogawan juc runanuyla imaypis cawag Taytämi ruraynincunata ruraycan. ");
INSERT INTO qva_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Criyipäcamay noga Taytäwan juc runanuyla caycangäta y paypis nogawan juc runanuyla caycanganta. Mana criyimarga rurangäcunata ricaycarga criyipäcamay. ");
INSERT INTO qva_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Rasunpam gamcunata nï: Nogaman yäracamagcäga noga rurangänuymi ruranga. Y Taytä cagman aywacuriptïna asta mastam ruranga. ");
INSERT INTO qva_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nogapa jutïchru Taytäta rugacäriptiquega rugacungayquita rurashämi. Chaynuy rurashag Wamran janan Taytä munayniyog cangan musyacänanpag. ");
INSERT INTO qva_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Imatapis rurashämi nogapa jutïchru rugacäriptiquega. ");
INSERT INTO qva_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Nogata cuyamarga lapan ningäcunata cäsucärimanquim. ");
INSERT INTO qva_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nogapa truquï yanapäshunayquipag Santu Espirituta gamcunaman cachramunanpag Taytäta rugacushag. Paymi imaypis gamcunawan canga. ");
INSERT INTO qva_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Chay Espiritum rasuncagta willacunga. Tayta Diospa contran runacunaga Santu Espirituta chrasquiyta manam puedinchu payta mana ricar y mana reguir. Gamcunam ichanga payta reguipäcunqui gamcunawan cawaptin y gamcunawan juc runanuyla cananpag captin. ");
INSERT INTO qva_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Wacchayashachu manam quëdapäcunqui. Gamcunaman cutimushämi. ");
INSERT INTO qva_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Nogaman mana yäracamagcunaga mananam ricapäcamanganachu. Gamcunam ichanga ricapäcamanqui. Noga cawaycaptïga cawapäcunquim. ");
INSERT INTO qva_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Chay junagmi tantiyapäcunqui Taytäwan juc runanuyla caycangäta y gamcuna nogawan juc runanuyla caycangayquita y noga gamcunawan juc runanuyla caycangäta. ");
INSERT INTO qva_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Ningäcunata chrasquicur cäsucüga rasunpam cuyaman. Cuyamagtaga Taytäpis cuyanga y nogapis cuyashämi. Chaynuypis cuyamagwan ricachicushämi”. ");
INSERT INTO qva_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Chauraga Judas tapuran: “Tayta, ¿imanirtag nogacunalawan ricachicunqui y waquin runacunawan mana?” (Chay Judas mana Judas Iscariotichu caran.) ");
INSERT INTO qva_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesús niran: “Pipis cuyamarga ningäcunata cäsucunmi. Cäsucamagtaga Taytä cuyangam. Y Taytäwan nogam payman aywapäcamushag y paywan cawashag. ");
INSERT INTO qva_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nogata mana cuyamag cäga manam ningäcunata cäsucunchu. Y ningäcunata mayangayquicunaga manam quiquïpa yarpayniläpitachu sinöga cachramagnï Taytäpitam caycan. ");
INSERT INTO qva_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Chaycunata niycä gamcunawan caycangäcamam. ");
INSERT INTO qva_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ichanga nogapa truquï yanapäshunayquipag Santu Espirituta Taytä gamcunaman cachramunanpag cag lapanta yachrachipäcushunqui y noga lapanta ningäcunata yarpächipäcushunqui. ");
INSERT INTO qva_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Jauca cawayta jaguipä. Jauca cawaynïta goycü. Ichanga jauca cawayta jaguipä manam nogaman mana yäracamagcunanuychu. Ama laquicäriychu ni manchacäriychu. ");
INSERT INTO qva_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mayapäcamashcanquinam aywacunäpag y gamcunawan canäpag cutimunäpag ningäta. Payga nogapita mas munayniyogmi. Chaymi rasunpa cuyamarga Taytäcagman aywacuptï cushicärinquiman. ");
INSERT INTO qva_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Manaräpis pasaptinmi gamcunata chayta canan niycä ningäcunanuy pasaptinga criyipäcunayquipag. ");
INSERT INTO qva_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Gamcunawan mananam aläpa parlashänachu. Runata munayninchru chararag Satanás aywaycämunnam. Nogapag payga ima munayninpis manam canchu. ");
INSERT INTO qva_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Chaynuymi canan Taytäta cuyangäta lapan runacuna musyapäcunanpag y pay nimangannuyla lapantapis rurangäta musyapäcunanpag. “Sharcapäcuy. Acu, caypita aywacushunna”. ");
INSERT INTO qva_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesús niran: “Nogam caycä rasunpa cag üvas yüranuy. Taytänam üvas yüra uryagnuy caycan. ");
INSERT INTO qva_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Payga maygan rämapis mana wayuptinga cuchuriycunmi. Wayog cagtam ichanga mas wayunanpag y limpiu cananpag Taytä shumag rämapan. ");
INSERT INTO qva_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Gamcuna limpiunam carcanqui ningäcunata chrasquicungayquipita. ");
INSERT INTO qva_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nogawan juc runanuyla imaypis cawapäcuy noga gamcunawan juc runanuyla imaypis cawangänuy. Ima rämapis yüranpita raquicarga quiquilanpita manam wayuyta puedinchu. Chaynuylam gamcunapis nogawan juc runanuyla imaypis mana cawarga räma mana wayungannuy munangänuy cawayta mana puedipäcunquichu. ");
INSERT INTO qva_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Noga üvas yüranuymi cä. Gamcunanam rämacunanuy carcanqui. Pipis nogawan juc runanuyla imaypis cawagcäga y noga paywan juc runanuyla imaypis cawaptï räma ali wayungannuy munangänuymi ali cawapäcunga. Nogapita raquicarga ima ruraytapis manam puedipäcunquichu. ");
INSERT INTO qva_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Pipis nogawan juc runanuyla imaypis mana cawagcäga rämanuy jitarisham canga. Jitarisha car räma chaquingannuy y shuntarcur ninaman gaycuycur rupachishanuymi canga. ");
INSERT INTO qva_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Gamcuna nogawan juc runanuyla imaypis cawarga y yachrachingäcunata imaypis cäsucurga munangayquita mañacäriy. Mañacäriptiquega Tayta Dios goshunquim. ");
INSERT INTO qva_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Munangänuy ali cawarga discïpulücunam rasunpa carcanqui. Chaynuy cawaptiquim Taytä ali ricasha canga. ");
INSERT INTO qva_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Gamcunata noga cuyä Taytä nogata cuyamangannuy. Nogawan juc runanuyla imaypis cawapäcuy gamcunata cuyanäpag. ");
INSERT INTO qva_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ningäcunata cäsucamaptiquega nogawanmi juc runanuyla imaypis cawapäcunqui gamcunata cuyanäpag. Chaynuylam nogapis Taytä nimangancunata cäsucuptï paywan juc runanuyla imaypis cawapäcü pay cuyamänanpag. ");
INSERT INTO qva_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Chaynuy gamcunata niycä noga cushisha cangänuy gamcunapis cushisha capäcunayquipämi y gamcunapis pasaypa cushisha capäcunayquipämi. ");
INSERT INTO qva_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Gamcunapag cay mandamientü caycan: Jucniqui jucniquipis cuyanacäriy gamcunata noga cuyangänuy. ");
INSERT INTO qva_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Runa amïguncunata rasunpa cuyarga asta paycuna janan wañurpis wañunmi. ");
INSERT INTO qva_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Lapan ningäcunata rurapäcuptiquega gamcuna amïgümi capäcunqui. ");
INSERT INTO qva_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Gamcunata mananam uywaytanuynachu ricä. Uywayga patrunnin imata rurangantapis manam musyanchu. Gamcuna amïgümi capäcunqui Taytä imata nimangantapis gamcunata willaptï. ");
INSERT INTO qva_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Gamcunachu manam nogata acrapäcamarayqui sinöga nogam gamcunata acrarä. Gamcunata cachraycä aywanayquipag y Tayta Diospa willacuyninta willacäriptiqui runacuna nogaman yäracärimänanpag y chay willacungayquita chrasquingan imaypis paycunachru cananpag. Chaynuypis nogapa jutïchru rugacäriptiqui lapanta Taytä gopäcushunayquipag. ");
INSERT INTO qva_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Caytam gamcunata mandä: Jucniqui jucniquipis cuyanacur cawapäcuy. ");
INSERT INTO qva_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Tayta Diospa contran runacuna rabyapäshuptiqui yarpäpäcuy nogata puntata rabyapämanganta. ");
INSERT INTO qva_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Gamcuna Tayta Diospa contran runacunanuy capäcuptiquega paycunanuy capäcuptiqui cuyapäcushunquimanmi. Ichanga nogam gamcunata paycunanuy cagpita acrashcä. Chaymi gamcunata rabyapäpäcushunqui paycunanuy mana captiqui. ");
INSERT INTO qva_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Yarpäpäcuy caynuy ningäta: ‘Uywaycunaga patrunninpita mas manam canchu’. Chaymi nogata rabyapämasha cagcunaga gamcunatapis rabyapäshunqui. Noga ningäcunata cäsucamasha cagcunaga gamcuna ningayquitapis cäsucushunquim. ");
INSERT INTO qva_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Noga jananmi chay lapanta rurapäcushunqui y paycuna cachramagnï Taytäta mana reguirmi. ");
INSERT INTO qva_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Noga mana aywamuptïga ni mana willapaptïga juchaynagmi capäcunman caran. Canan ichanga paycuna niyta mana puedipäcunchu: ‘Manam juchäcärishcächu’. ");
INSERT INTO qva_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nogata rabyapämagcäga Taytätapis rabyapaycanmi. ");
INSERT INTO qva_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Paycunachru pipis mana rurangan milagrucunata mana ruraptïga juchaynagmi capäcunman caran. Ichanga ima rurangätapis ricasha caycarpis nogata y Taytätapis rabyapäpäcaman. ");
INSERT INTO qva_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Chaycuna chaynuy pasaycan Tayta Dios escribichinganchru caynuy ningan cumplinanpämi: ‘Manacagpitam rabyapämasha’. ");
INSERT INTO qva_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Yanapäshunayquipag Santu Espirituta Taytä cagpitam cachramushag. Pay rasuncagta willacog Espiritum y Taytäpita shamunga. Shamur nogapitam willapäpäcushunqui. ");
INSERT INTO qva_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Gamcunapis galaycunganpita pacha nogawan purisha caycarga nogapita willacärinqui. ");
INSERT INTO qva_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Chay lapanta gamcunata niycä nogaman yäracärimayta mana jaguiripäcunayquipag. ");
INSERT INTO qva_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Shuntacäpäcunan wasipitapis gargapäcushunquim. Juc junag chrayamunga pipis wañuchipäcushunayquipag. Wañurcächishushpayqui Tayta Dios mandanganta rurapäcunganta yarpäpäcunga. ");
INSERT INTO qva_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Chaynuy rurapäcunga Taytätapis ni nogatapis mana reguirmi. ");
INSERT INTO qva_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Chaynuy niycä ningänuy pasaptinna chaycunata gamcunata ningäta yarpäpäcunayquipag. “Noga gamcunawan carmi galaycunapita pacha chayta mana nirächu. ");
INSERT INTO qva_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Canan ichanga cachramagnïmannam aywacuycä y maygayquipis maypa aywangätapis mana tapupäcamanquichu. ");
INSERT INTO qva_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Chaypa truquinga chaynuy ningäpita laquicuyman chrayarärinqui. ");
INSERT INTO qva_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ichanga rasuncagta gamcunata nishayqui: Gamcunapag mas ali canga noga aywacuptï. Noga mana aywacuptïga yanapäshunayquipag cag gamcunaman manam shamungachu. Noga aywacurmi ichanga cachramushag. ");
INSERT INTO qva_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Pay shamurnam Diospa contran runacunata tantiyachinga pï juchayog canganta, pï juchaynag canganta y pita juchanpita Tayta Dios juzgananpag canganta. ");
INSERT INTO qva_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","¿Pitag juchayog? Runacuna juchayog carcan nogaman mana criyimanganpita. ");
INSERT INTO qva_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","¿Pitag juchaynag? Juchaynäga nogam caycä Taytä cagman aywacungäpita y gamcuna manana ricapäcamangayquipita. ");
INSERT INTO qva_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","¿Pitag juzgasha canga? Runacunata Dios juzgananpag canga runata munayninchru chararag Satanás juzgasha canganpita. ");
INSERT INTO qva_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Achcarämi gamcunata ninäpag caycan. Ichanga canan manarämi nishayquichu; gamcunapäga canga aläpam. ");
INSERT INTO qva_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Rasuncagta willacog Santu Espíritu shamurnam ichanga lapanta shumag tantiyachipäcushunqui. Pay manam quiquilanpitachu ninga sinöga Diospita mayangancunatam ninga. Chaynuypis ima pasananpag cangantapis musyachinga. ");
INSERT INTO qva_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Nogapita musyangantam musyachipäcushunqui. Chaynuy musyachipäcushunqui noga munayniyog cangä musyacänanpag. ");
INSERT INTO qva_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Taytä lapan chararanganga nogapawanmi. Chaymi nirä Santu Espíritu nogapata chrasquinanpag canganta y chaytana gamcunata musyachipäcushunayquipag canganta. ");
INSERT INTO qva_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Wara wichancuna mananam ricapäcamanquinachu. Chaypita warantincuna yapaymi ricamanqui”. ");
INSERT INTO qva_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Niptin waquin discïpuluncuna quiquinpura tapunacäriran: “Chaynuy nir ¿imatarag niycämanchi? ‘Wara wichanga manam ricapäcamanquinachu’ nircurga. ‘Chaypita warantincuna yapaymi ricamanqui’ niycämanchi. Chaynuypis ‘Taytä cagman aywacuptïmi’ niycämanchi. ");
INSERT INTO qva_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Imaninantatag ‘Wara wichancuna manana ricapäcamanquinachu’ niycämanchi? Manam tantiyanchichu imata parlaycangantapis”. ");
INSERT INTO qva_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Discïpuluncuna tapunanta tantiyarmi Jesús niran: “Noga nishcä: ‘Wara wichancuna mananam ricapäcamanquinachu. Chaypita warantincuna yapaymi ricapäcamanqui’. ¿Chaypitachu gamcuna quiquiquipura tapunacurcanqui? ");
INSERT INTO qva_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Rasunpam gamcunata nï: Wagapäcunquim y laquicärinquim; Tayta Diospa contran runacunaga cushicäringam. Gamcuna laquicäriptiquipis laquicuyniqui cushicuymanmi ticranga. ");
INSERT INTO qva_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Juc warmi gueshyacunanpag höran chrayamuptinna nanayta mayan. Wamran yurircuptinnam ichanga cushicur nanaytapis gongaycun. ");
INSERT INTO qva_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Chaynuy cananga gamcunapis laquicurcanqui. Ichanga cutimushämi. Chaychrümi ricamar gamcuna cushicärinqui. Chaynuy cushisha caycangayquipita manam pipis laquicachishunquinachu. ");
INSERT INTO qva_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Chay junäga mananam imapitapis tapupäcamanquinachu. “Rasunpam gamcunata nï: Jutïchru Taytäta imatapis mañacuptiquega pay goshunquim. ");
INSERT INTO qva_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Canancamaga gamcuna jutïchru manarämi Taytäta imatapis mañacushcanquirächu. Mañacäriy; chrasquipäcunquim cushicärinayquipag. ");
INSERT INTO qva_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Chaycunata imamanpis tincuchiypa nishcä. Chrayamunganam höra imamanpis tincuchiypa gamcunata mana ninäpag. Chaypa truquinga tantiyapäcunayquipag Taytäpita gamcunata nishayqui. ");
INSERT INTO qva_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Chay junag nogapa jutïchru Taytäta rugacärinqui. Noga manam nïchu gamcunapag noga Taytäta rugacunäpag canganta. ");
INSERT INTO qva_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Gamcunata quiquin Taytä cuyapäcushunquim. Pay cuyashunqui nogata cuyapäcamangayquipitam. Y cuyapäcushunqui noga paypita shamungäta criyipäcungayquipitam. ");
INSERT INTO qva_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Taytäcagpitam yargamushcä cay pachaman shamunäpag. Cananga cay pachapita yargucuycä Taytäcagman cuticunäpag”. ");
INSERT INTO qva_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Discïpuluncuna niran: “Cananmi ichanga tantiyapäcunäpag imamanpis mana tincuchiypa shumag nircämanqui. ");
INSERT INTO qva_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Cananga tantiyapacü lapanta musyangayquita y pipis mana mas tapucushunayquita. Chaynuy captinmi nogacuna criyipäcü Tayta Diospita shamungayquita”. ");
INSERT INTO qva_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús niran: “¿Cananga criyipäcunquinachu? ");
INSERT INTO qva_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Höra chrayamushanam quiquiläta jaguiriycamar wacagpa caycagpa mashtacar aywacärinayquipag. Ichanga quiquilächu manam caycä sinöga Taytä nogawanmi caycan. ");
INSERT INTO qva_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Gamcunata chaynuy niycä gamcuna nogawan juc runanuyla cayniquipa jauca cawapäcunayquipämi. Cay pachachru nacapäcunquim. Ichanga valurchacäriy; cay pachata munayninchru chararag munayniyogcunata vincishcänam”. ");
INSERT INTO qva_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Chaycunata nircurnam Jesús cieluta ricärir niran: “Tayta, hörä chrayamushanam. Munayniyog cangäta runacunata musyachiy gam munayniyog cangayquita runacunata musyachinäpag. ");
INSERT INTO qva_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Gammi lapan runapag munayniyog canäpag chruramashcanqui nogapag acrangayqui cagcunata mana ushacaypa cawayman chruranäpag. ");
INSERT INTO qva_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Mana ushacaypa caway caycan gamla rasuncag Diosta reguiymi y cachramungayqui Jesucristuta reguiymi. ");
INSERT INTO qva_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Cay pachachru gam munayniyog cangayquita runacunata musyachishcänam ruranäpag nimangayquicunata rurar. ");
INSERT INTO qva_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Cananga, Tayta, cay pachata manarag camar munayniyog cangänuy cananpis ñaupagniquichru munayniyog cayculäshag. ");
INSERT INTO qva_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Gampa contrayqui runacunapita acrarcur nogapa discïpulücuna cananpag gomangayquicunata pï cangayquitapis musyachishcänam. Paycuna gampam caran y nogata goycamashcanqui. Paycuna gampa willacuyniquita cäsucärisham. ");
INSERT INTO qva_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","8","Gomangayqui willacuyniquita paycunata willapaptï chrasquicurmi cananga musyapäcun lapan gomangayquicunaga gampita shapäcamunganta. Tantiyapäcusha rasunpa gampita aywamusha cangäta y gam nogata cachramasha cangayquita criyipäcusha. ");
INSERT INTO qva_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Noga paycunapämi rugacü. Manam gampa contrayqui runacunapächu rugacü sinöga gomangayquicunapämi. Paycunapag rugacü gampa canganpita. ");
INSERT INTO qva_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nogapa cäga gampam y gampa cäga nogapam. Noga munayniyog cangäta paycuna musyarcächin. ");
INSERT INTO qva_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nogaga cay pachachru mananam cashänachu. Paycunam ichanga cay pachachru sïguipäcunga. Nogaga gammannam shacamushag. Juchaynag Tayta, gomangayqui munayniquiwan paycunata cuydayculay. Cuydayculay noganchi canganchinuy paycunapis juc runanuyla cananpag. ");
INSERT INTO qva_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Cay pachachru paycunawan caycar noga paycunata gomangayqui munayniquiwan cuydarämi. Paycunapita manam mayganpis ogracaranchu. Jucmi ichanga ogracasha carna ogracaran. Chaynuy caran Dios escribichingan cumplinanpämi. ");
INSERT INTO qva_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Cananga aywacamü gam cangayquicagmanna. Caynuy niycä cay pachachru caycangäcamala paycunapis noga cushisha cangänuy cushisha capäcunanpag. ");
INSERT INTO qva_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Gampa willacuyniquita paycunata willapashcä. Willapasha captïmi noga gampa contran runacunanuy mana captï paycunapis chay runacunanuychu mana carcan. Chaypitam chay runacuna paycunata rabyaparcan. ");
INSERT INTO qva_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Gamta noga cay pachapita shuntacunayquipächu manam rugacü. Sinöga paycunata Satanaspita cuydaycunayquipämi. ");
INSERT INTO qva_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Gampa contrayqui runacunanuy noga mana captïmi chay runacunanuychu paycunapis mana capäcun. ");
INSERT INTO qva_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Gamlapag capäcunanpag paycunata acrayculay y willacuyniqui ningannuy paycunata cawaycachilay. Willacuyniquega rasuncagmi. ");
INSERT INTO qva_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Runacunaman nogata cachramangayquinuylam paycunatapis runacunaman cachraycä. ");
INSERT INTO qva_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Paycuna raycu gamlapag canäpag noga quiquï acracuycä gamlapag capäcunanpag paycunapis acrasha cananpag y willacuyniqui ningannuy paycunapis cawananpag. ");
INSERT INTO qva_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Manam paycunalapächu gamta rugacamü. Sinöga paycuna willacunganta mayar yäracamagcunapäwanmi rugacamü. ");
INSERT INTO qva_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Rugacü paycuna lapan juc runanuyla cananpag; Tayta, gam nogawan juc runanuyla cangayquinuy y noga gamwan juc runanuyla cangänuy paycunapis noganchiwan juc runanuyla cananpag. Chaynuy capäcuptinmi mana yäracamagcuna criyipäcunga gam cachramangayquita. ");
INSERT INTO qva_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Munayniquita gomangayquinuy paycunatapis munaynïta goshcä noganchi juc runanuyla canganchinuy paycunapis juc runanuyla capäcunanpag. ");
INSERT INTO qva_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Noga paycunawan juc runanuyla cä y gam nogawan juc runanuyla canqui paycunapis juc runanuyla capäcunanpag. Chaynuypa mana yäracamagcuna tantiyapäcunga gam nogata cachramangayquita y nogata cuyamangayquinuy paycunatapis cuyangayquita. ");
INSERT INTO qva_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tayta, nogata gomangayquicagcuna noga cangäcagchru nogawan canantam munä munayniyog cangäta ricapäcunanpag. Munayniquita gomarayqui gam cuyamashpayqui. Cuyamarayqui manaräpis cay pacha camacaptinmi. ");
INSERT INTO qva_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ali rurag Tayta, cay pachachru caycag runacuna manam gamta reguipäcushunquichu. Nogam ichanga gamta reguï. Y paycuna musyanmi gam nogata cachramangayquita. ");
INSERT INTO qva_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Pï cangayquitapis paycunata tantiyachishcämi. Sïguishämi tantiyachiyta nogata cuyamangayquinuy paycunapis waquincunata cuyapäcunanpag y noga paycunawan juc runanuyla canäpag”. ");
INSERT INTO qva_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Chaycunata nircurnam Jesús discïpuluncunawan yargapäcuran Cedrón jutiyog ragrapa jucag chimpanman aywapäcunanpag. Chaychrümi olivos yüracuna wiñangan chracra caran y paycuna chayman yaycapäcuran. ");
INSERT INTO qva_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jesusta entregag Judaspis chay chracrata reguiranmi. Chaychru achca cutim Jesús discïpuluncunawan gotucäpäcuran. ");
INSERT INTO qva_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Chaymanmi Judas chrayaran achca soldäducunata y cüracunapa mandagnincuna y fariseucuna mandangan wardiacunata pushacurcur. Paycunam aywapäcuran achquincunawan y espädancunawanpis. ");
INSERT INTO qva_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ima pasananpag cangantapis musyaycarmi chay runacunacagman Jesús aywaran. Nircur tapuran: “¿Pitatag ashircanqui?” nir. ");
INSERT INTO qva_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Chauraga nipäcuran: “Nazaret marcapita Jesustam”. Jesús niran: “Nogam caycä”. Jesusta entregänanpag caycag Judaspis paycunawan caycaran. ");
INSERT INTO qva_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesús “Nogam caycä” niptin chay runacuna guepapaypa cutir ratapäcuran. ");
INSERT INTO qva_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesús yapay tapuran: “¿Pitatag ashircanqui?” nir. Nipäcuran: “Nazaret marcapita Jesustam”. ");
INSERT INTO qva_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesús yapay niran: “Noga cangäta maynam nishcä. Nogata ashimarga cay waquincunata jaguiricuy”. ");
INSERT INTO qva_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Chaynuy caran quiquin Jesús caynuy ningan cumplinanpämi: “Nogata gomangayquicunata juctapis manam ograshcächu”. ");
INSERT INTO qva_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Chauraga Simón Pedro espädanta jorgurir cüracunapa mas mandagninpa Malco jutiyog uywayninpa derëchacag rinrinta roguriycuran. ");
INSERT INTO qva_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesús niran Pedruta: “¡Espädayquita chruraräcunanman chruray! Taytä nacanäta munaptinga listum caycä nacanäpag”. ");
INSERT INTO qva_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Chauraga soldäducuna mandagninwan y Israel runacunapa wardiancuna Jesusta chariycärir watapäcuran. ");
INSERT INTO qva_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nircurnam puntata Anaspa wasinman apapäcuran. Anás caran Caifaspa suedrunmi. Chay wata Caifasga cüracunapa mas mandagnin caycaran. ");
INSERT INTO qva_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Cay quiquin Caifasmi Israel runacunapa autoridänincunata niran lapan marcapa truquin juc runala wañunanpag mas ali cananpag canganta. ");
INSERT INTO qva_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedruwan jucag discïpulunmi Jesusta gatiraran. Jucag discïpulunmi cüracunapa mas mandagninwan reguinacusha car Jesuswan wasipa sawannin ruricama yaycuran. ");
INSERT INTO qva_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedrum ichanga puncu yaycunalachru quëdaran. Chaymi reguisha cag discïpulo yargarcamur parlaran puertachru cuydag warmiwan. Nircurnam Pedruta yaycachiran. ");
INSERT INTO qva_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Chaymi puertachru cuydag jipash Pedruta tapuran: “¿Manachu chay runapa jucnincag discïpulun gampis caycanqui?” Pedro niran: “Manam”. ");
INSERT INTO qva_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Gasaptinmi uywaycunawan templo cuydag wardiacuna ninata ratarcachir ichrisha mashacurcaran. Chaychrümi Pedrupis ichrisha mashacuycaran. ");
INSERT INTO qva_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Cüracunapa mas mandagninna Jesusta tapuran imata yachrachinganta y discïpuluncuna pï cangantapis. ");
INSERT INTO qva_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesús niran: “Noga rimashcä lapan runa mayaycaptinmi. Imaypis yachrachishcä shuntacänan wasicunachrümi y templuchrümi, Israel runacuna shuntacänanchrümi. Chaymi imatapis pacaypa mana nishcächu. ");
INSERT INTO qva_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Imanirtag nogata tapumanqui? Tapuy mayamagnïcunata. Paycuna nichun imata ningätapis. Paycunam musyan imata ningätapis”. ");
INSERT INTO qva_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesús chaynuy niruptinmi jucnincag wardia Jesusta caynuy nir lagyaran: “¿Chaynuychu ninqui cüracunapa mas mandagninta?” ");
INSERT INTO qva_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesús niran: “Mana ali nisha captïga niy imata mana alita ningätapis. Mana alita mana nisha caycaptïga ¿imanirtag magamanqui?” ");
INSERT INTO qva_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Chaypitana Jesusta watashata Anás apachiran cüracunapa mas mandagnin Caifás cagman. ");
INSERT INTO qva_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Nina rupaycagchru Pedro mashacuycaptin tapupäcuran: “¿Manachu chay runapa jucnincag discïpulun gampis caycanqui?” Pedro caynuy nir niegaran: “Manam”. ");
INSERT INTO qva_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Chaypitana cüracunapa mas mandagninpa uywaynincunapita jucnincag tapuran: “¿Gamta manachu ricashcä olivos yüracuna wiñangan chracrachru paywan caycagta?” Chay tapog caran cüracunapa mas mandagninpa uywayninpa rinrinta Pedro rogunganpa ayllunmi. ");
INSERT INTO qva_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedro yapay niegaran. Chay höra gällu cantariycamuran. ");
INSERT INTO qva_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Jesusta apapäcuran Caifaspa wasinpita Pilätupa palaciunman. Payga Romapa gobernadurninmi caran. Pacha warayta galaycuycaranna. Israel runacunapa autoridänincuna chay palaciuman mana yaycapäcuranchu. Yaycurga paycunata juchäcachinman caran. Yaycurga leynin ningannuy Pascua micuyta mana micapäcunmanchu caran. ");
INSERT INTO qva_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Chaymi yargurcur Piläto tapuran: “¿Cay runa imatatag mana alita rurasha?” ");
INSERT INTO qva_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Nipäcuran: “Alita rurag captinga gamman manam apapäcamümanchu caran”. ");
INSERT INTO qva_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Chauraga Piläto niran: “Gamcuna apacäriy y leyniquicuna ningannuy juzgapäcuy”. Israel runacunapa autoridänincuna nipäcuran: “Israel runacunaga manam pitapis wañuchinanpag munayniyogchu”. ");
INSERT INTO qva_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Chaynuypa cumpliran Jesús imanuypa wañunanpag ningan. ");
INSERT INTO qva_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Palaciunman Piläto yapay yaycuran. Nircur Jesusta gayaycur tapuran: “¿Gamchu Israel runacunapa Reynin canqui?” ");
INSERT INTO qva_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesús niran: “¿Chaynuy tapumanqui quiquilayquipitachu o juc nogapita nipäcushuptiquichu?” ");
INSERT INTO qva_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Piläto niran: “Nogaga manam Israel runachu cä. Marca masiquicunawan cüracunapa mandagnincunam nogaman apachimushushcanqui. ¿Imatatag rurashcanqui?” ");
INSERT INTO qva_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesús niran: “Cay pachachru rey canäpächu nogaga manam caycä. Cay pachachru mandag canäpag captinga canmanmi Israel runacunapa autoridänincunaman mana apamänanpag runäcuna pelyananpag. Ichanga cay pachachru rey canäpächu nogaga manam caycä”. ");
INSERT INTO qva_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Chauraga Piläto tapuran: “¿Chauraga gamchu rey caycanqui?” Jesús niran: “Gam nishcanqui: Reymi cä. Noga yurishcä y cay pachaman shamushcä rasuncagta willacunäpämi. Pï maypis rasuncagta chrasquicuyta munagcuna noga ningäta chrasquicäringa”. ");
INSERT INTO qva_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Piläto niran: “¿Imatag rasuncäga?” Chaynuy tapurcur despächunpita Piläto yapay yarguran Israel runacunapa autoridänincunaman. Nircur niran: “Ima juchantapis cay runapata noga manam tarïchu. ");
INSERT INTO qva_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ichanga gamcunapa costumbriquicuna caycan Pascua fiestachru juc prësuta cachrarinäpag. ¿Munapäcunquichu Israel runacunapa Reyninta cachrarinäta?” ");
INSERT INTO qva_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Lapan yapay gaparir nipäcuran: “¡Ama chaytaga sinöga Barrabasta!” Barrabás caran saltiadurmi. ");
INSERT INTO qva_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Chauraga Piläto jucwan Jesusta astichiran. ");
INSERT INTO qva_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Soldäducunam cashapita awasha corönata Jesuspa umanman jatipäpäcuran. Nircur yanataycag azul cäpata jatipäpäcuran. ");
INSERT INTO qva_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Chaypita ashuycur Jesusta nipäcuran: “Vïva Israel runacunapa Reynin”. Nir cäranchru lagyapäcuran. ");
INSERT INTO qva_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Despächunpita Piläto yapay yargurcur niran: “Ima juchantapis mana taringäta musyapäcunayquipag canan jorgachimushag”. ");
INSERT INTO qva_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Chauraga Jesús yargamuran cashapita rurasha corönan jatisha y yanataycag azul cäpan jatisha. Piläto niran: “¡Caychru caycan cay runa!” ");
INSERT INTO qva_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Cüracunapa mandagnincunawan templo cuydag wardiacunapis Jesusta ricaycur gaparir nipäcuran: “¡Crucificächiy! ¡Crucificächiy!” Piläto niran: “Chauraga apacäriy, gamcuna crucificäpäcuy. Noga paypa ima juchantapis manam tarïchu”. ");
INSERT INTO qva_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Israel runacunapa autoridänincuna nipäcuran: “Nogacunachru ley canmi. Pay Diospa Wamran canganta ninganpita chay leynïcuna ningannuy wañuchisham canan”. ");
INSERT INTO qva_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Diospa Wamran canganta ninganta mayar Piläto mas manchariran. ");
INSERT INTO qva_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Piläto palaciunman cutiycur Jesusta tapuran: “¿Gam maypitatag canqui?” nir. Jesús manam imatapis rimacuranchu. ");
INSERT INTO qva_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Piläto niran: “¿Manachu imatapis nimanqui? ¿Manachu musyanqui crucificächinäpag o cachrarinäpäpis munayniyog cangäta?” ");
INSERT INTO qva_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesús niran: “Gampa munayniquiman Tayta Dios mana chruramaptinga manam ima munayniquipis canmanchu caran. Chaymi entregämag gampitapis mas juchayog carcan”. ");
INSERT INTO qva_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Chay hörapitam Jesusta Piläto cachrariyta ashiran. Ichanga Israel runacunapa autoridänincuna gaparir nipäcuran: “Cay runata cachrarirga gam emperador Cesarpa contranmi caycanqui. Pipis rey tucurga emperador Cesarpa contranmi caycan”. ");
INSERT INTO qva_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Chaynuy nipäcunganta mayar Piläto jorgachimuran Jesusta. Nircurnam “Läja rumicunawan chrurasha” jutiyogman aywaycur mandacunanman jamacuran. (Chay partipa hebreo rimaychrüga “Gabata” jutin caran.) ");
INSERT INTO qva_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Chay caran pulan junagnuy juc junag Pascua fiestapa sabadunpag pishiycaptin. Piläto Israel runacunapa autoridänincunata niran: “¡Caychru caycan Reyniqui!” ");
INSERT INTO qva_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Paycuna gaparir nipäcuran: “¡Wañuchun! ¡Wañuchun! ¡Crucificächiy!” nir. Piläto tapuran: “¿Reyniquita crucificächinätachu munapäcunqui?” Cüracunapa mandagnincuna nipäcuran: “¡Nogacunapaga juc rey manam canchu! ¡Emperador Cesarlam reynïcuna!” ");
INSERT INTO qva_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Chauraga Jesusta Piläto paycunata entregaycuran crucificasha cananpag. Chaypitana apacäriran. ");
INSERT INTO qva_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesús yarguran cruznin umrusha “Calavëra cacunan” ninganman. (Hebreo rimaychrüga chayta Gólgota nipäcun.) ");
INSERT INTO qva_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Chaychrümi crucificäpäcuran. Paywan ishcay runacunata jucta cada lädunman crucificaran. Jesús chraupichru crucificasha quëdaran. ");
INSERT INTO qva_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Piläto escribichiran juc letrëruta. Chay letrëruchru niran: “Nazaretpita Jesús, Israel runacunapa Reynin” nir. Chaytana cruzman chrurachiran. ");
INSERT INTO qva_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Achcag Israel runacuna chay letrëruta liyipäcuran Jesús crucificarangan marca cercalanchru captin. Chay letrëru escribiraran hebreo, latín y griego rimaychru. ");
INSERT INTO qva_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Chaymi Israel runacunapa cürancunapa mandagnincuna Pilätuta nipäcuran: “ ‘Israel runacunapa mandagnin reymi’ nirga ama escribirächunchu sinöga ‘Israel runacunapa mandagnin rey cä’ pay ninganta escribichiy”. ");
INSERT INTO qva_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Piläto niran: “Escribingäga escribisha cachun”. ");
INSERT INTO qva_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jesusta crucificarcärirna paypa röpanta chaychru cag chruscu soldäducuna aypunacäriran. Rurinchru cag jatirangan röpan pasagla janapita uraman awasha caran. ");
INSERT INTO qva_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Chaymi chay soldäducuna quiquinpura ninacäriran: “Chaytaga ama rachrishunchu sinöga surtiyashun mayganchipis apacunanchipag”. Chaynuypa cumpliran Tayta Dios escribichinganchru caynuy escribirangan: “Quiquinpura röpäta raquinacäriran. Jucnin röpätana surtiyapäcuran”. Chaynuy chay soldäducuna rurapäcuran. ");
INSERT INTO qva_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesús crucificarangan lädunchrümi maman, mamanpa ñañan, Cleofaspa warmin María y María Magdalena caycaran. ");
INSERT INTO qva_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesús mamanta ricar y paypa lädunchru cuyangan discïpulun caycagta ricar niran: “Chaychru wawayqui caycan”. ");
INSERT INTO qva_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nircur discïpuluntapis niran: “Chaychru mamayqui caycan”. Chay hörapitanam chay discïpulun mamantanuy wasinchru ricaran. ");
INSERT INTO qva_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Chaypita lapan cumplishana canganta Jesús musyarna Tayta Diosninchi escribichinganchru escribirangan cumplinanpag Jesús niran: “Yacunaycä”. ");
INSERT INTO qva_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Chaychrümi juc järra junta puchgog vïno caycaran. Chaywan esponjata ushmarcachir hisöpu gueruman chrurarcur Jesús shogunanpag ashuycachipäcuran. ");
INSERT INTO qva_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Chay vïnuta shogurcurna Jesús niran: “Lapannam cumplisha caycan”. Nircurnam wañuran. ");
INSERT INTO qva_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Sábado jamay junag diawarda galaycunanpäna caycaptinmi Israel runacunapa autoridänincuna mana munapäcuranchu pipis crucificaraycar quëdananta. Chaymi Pilätuta rugacäriran crucificaraycagcunapa chrancancunata paquircur cruzpita jorgunanpag. ");
INSERT INTO qva_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Chaymi soldäducuna aywaycur Jesuswan crucificaraycag runacunapa chrancancunata ishcanpata paquipäcuran. ");
INSERT INTO qva_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jesusman ashuycur wañushatana taripäcuran. Chaymi paypa chrancanta manana paquipäcurannachu. ");
INSERT INTO qva_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ichanga lapsha pachranpa jucnin soldädu lanzawan Jesusta tucsiran. Chauraga yawarwan yacu jucla yargamuran. ");
INSERT INTO qva_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Cayta willacun quiquin ricagmi. Rasuncagtam niycan. Gamcuna criyipäcunayquipag pay musyan rasuncagta niycanganta. ");
INSERT INTO qva_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Chay lapan chaynuy pasaran Tayta Diosninchi escribichingan cumplinanpämi: “Manam ni juc tullulanpis paquishachu canga”. ");
INSERT INTO qva_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Tayta Dios escribichinganchru jucnin läduchru niycan: “Tucsegcunam ricapäcunga tucsisha caycagta”. ");
INSERT INTO qva_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Chaypitam Arimatea marcapita José jutiyog runa Pilätuta rugacuran Jesuspa cuerpunta pampag apananpag. Israel runacunapa autoridänincunata manchacur pay pacaylapa Jesuspa discïpulun caran. Piläto “Apacuy” niptinnam José aywaycur Jesuspa cuerpunta pampananpag aparan. ");
INSERT INTO qva_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Chaynuy Nicodemupis quimsa arröba mïrra y aloe ninganta apacurcur aywaran. Paymi juc cutinchru chacaypa Jesuscagman parlananpag aywaran. ");
INSERT INTO qva_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Nircurna Jesuspa cuerpunman chay perfümita gaycapaycur lïnupita tëlacunawan wancupäcuran. Chaynuy rurapäcuran runata pampananpag Israel runacunapa costumbrin cangannuy. ");
INSERT INTO qva_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesusta crucificäpäcungan lädunchru huerta caran. Chaychrümi mushog sepultüra caran. Chay sepultüraman manarämi pitapis pampapäcuranrächu. ");
INSERT INTO qva_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Chaymanmi sepultüra cercachru y nagana Israel runacuna jamanan sábado galaycunanpäna captin Jesuspa cuerpunta pampapäcuran. ");
INSERT INTO qva_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Semäna galarinan junag María Magdalena chaca chacala Jesús pamparaycangan cagman aywaran. Chrayarna tariran sepultüra chaparag rumi ashuchisha caycagta. ");
INSERT INTO qva_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Chauraga cörrila aywaran Simón Pedro y Jesús cuyangan discïpulun caycanganman. Chaychrüna willaran: “¡Señor Jesuspa cuerpuntam sepultürapita apacärisha! ¡Manam musyapäcüchu mayman chrurapäcungantapis!” nir. ");
INSERT INTO qva_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Willaptin Pedro y Jesús cuyangan discïpulun Jesús pamparangan cagman aywapäcuran. ");
INSERT INTO qva_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ishcan cörrila aywapäcuran. Jucag discïpulo Pedrupita mas cörriran. Chaynuypa mas puntata chrayaran Jesús pamparangan cagman. ");
INSERT INTO qva_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Chaychrünam punculapita anaycur ricaran tëlacuna chruraraycagta. Ichanga mana yaycuranchu. ");
INSERT INTO qva_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Guepanta Pedro chrayaycur ruriman yaycuran. Paypis tëlacunata chaychru chruraraycagta ricaran. ");
INSERT INTO qva_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Chaynuypis Jesuspa uman wancurangan tëlatapis ricaran jucag tëlacunapita yarichru pillusha caycagta. ");
INSERT INTO qva_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Chaypitarämi puntata chrayagcag discïpulupis ruriman yaycuran. Chaycunata ricaycur Jesús cawarimunganta criyiran. ");
INSERT INTO qva_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Manam tantiyapäcuranrächu Tayta Dios escribichinganchru wañunganpita cawarimunanpag escribiranganta. ");
INSERT INTO qva_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Chaypitanam chay discïpulucuna wasinman cuticäriran. ");
INSERT INTO qva_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","María ichanga pamparangan puncuchru wagaycar quëdacuran. Wagaycanganchru uytiycur ruriman anaycuran. ");
INSERT INTO qva_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Chaychrümi ishcay angilcuna yurag röpashata María ricaran. Jucag jamaraycaran Jesuspa uman cangan cagchru y jucagna jamaraycaran chraquin cangan cagchru. ");
INSERT INTO qva_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Chay angilcunam Mariata tapuran: “Warmi, ¿imanirtag wagaycanqui?” nir. Pay niran: “Señurnïpa cuerpuntam apacärisha. Manam musyächu mayman chrurapäcungantapis”. ");
INSERT INTO qva_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Chaynuy nircur muyurcunganchru Jesusta ricaran. Ichanga manam reguiranchu pay canganta. ");
INSERT INTO qva_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesús tapuran: “Warmi, ¿imanirtag wagaycanqui? ¿Pitatag ashiycanqui?” nir. Chauraga pay chay chracrachru arog runa canganta yarpar María niran: “Tayta, apasha carga willaycamay mayman chruramungayquitapis apacamunäpag”. ");
INSERT INTO qva_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Chauraga Jesús niran: “¡María!” Muyurcur pay hebreo rimaychru niran: “¡Raboni!” (Chay ninan “maestro” ninanmi.) ");
INSERT INTO qva_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús niran: “Ama charimaychu. Manarämi Taytä cagman jegärächu. Ichanga wauguïcunacagman ayway willamuy Taytäman y gamcunapa Taytayquiman, Diosnïman y gamcunapa Diosniquiman jegaycangäta”. ");
INSERT INTO qva_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Chauraga discïpulucunaman María Magdalena aywar Señor Jesusta ricanganta y ningancunatapis paycunata willaran. ");
INSERT INTO qva_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Chay semäna galarinan junag chacay discïpuluncuna Israel runacunapa autoridänincunata manchacur shuntacaycur puertata wichrgacuycur carcaran. Chaychru carcaptinmi chraupinchru Jesús ricarir saludaran: “Jauca cawapäcuy” nir. ");
INSERT INTO qva_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Chaynuy nir maquinta y lapsha pachranta ricachiran. Señor Jesusta ricaycur discïpuluncuna pasaypa cushicäriran. ");
INSERT INTO qva_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Chaypitana Jesús yapay niran: “Jauca cawapäcuy. Taytä cachramangannuy gamcunatapis cachraycä”. ");
INSERT INTO qva_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nircur pücarir niran: “Santu Espirituta chrasquipäcuy. ");
INSERT INTO qva_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Pitapis juchanpita perdunäpäcuptiquega perdunasham canga. Pitapis mana perdunäpäcuptiquega manam perdunashachu canga”. ");
INSERT INTO qva_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Chrunca ishcaypita (12) jucnincag discïpulun Milïshu nipäcungan Tomás manam caranchu Jesús paycunacagman chrayangan höra. ");
INSERT INTO qva_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Waquincag discïpuluncuna Tomasta nipäcuran: “¡Señor Jesusta ricapäcushcä!” Tomás niran: “Maquinchru clävus yaycunganta mana ricarga, chayman dëdüta mana jatirga y lapsha pachranpa tucsinganman maquïta mana jatirga manam criyishächu”. ");
INSERT INTO qva_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Pusag junag pasarcuptinna discïpuluncuna wasiman yapay shuntacaran. Chaychrüga Tomás caycaran. Puertan wichrgasha caycaran. Ichanga Jesús yaycuran. Nircurna chraupinman ichriycur caynuy saludaran: “¡Jauca cawapäcuy!” ");
INSERT INTO qva_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tomasta niran: “Dëduyquita cayman chruray y maquïta ricay. Maquiquita ashuycachimuy lapsha pachrä tucsisha caycagman jatiy. ¿Imanirtag mana criyinquichu? ¡Criyinquiman!” ");
INSERT INTO qva_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Chauraga Tomás niran: “¡Señurnï, Tayta Diosnï!” ");
INSERT INTO qva_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús niran: “¿Ricaycamar-rächu criyinqui? ¡Mana ricaycämar criyegcunaga cushisham caycan!” ");
INSERT INTO qva_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesús achca milagrucunatam discïpuluncuna ricaycaptin ruraran. Chaycunata ruraran payta Dios rasunpa cachramunganta musyacänanpag. Chay milagrucunaga lapanchu manam cay libruchru escribiraycan. ");
INSERT INTO qva_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Cay waquincunam ichanga escribiraycan Jesús Tayta Dios cachramungan Salvador canganta y Diospa Wamran canganta criyipäcunayquipag. Payman criyirna pay cayninpa mana ushacaypa cawayta chrasquipäcunayquipag. ");
INSERT INTO qva_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Chaypita Tiberias jutiyog lamar cantunchru discïpuluncunata Jesús yapay ricariparan. Caynuymi caran: ");
INSERT INTO qva_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Shuntacasha carcaran Simón Pedro, Milïshu nipäcungan Tomás, Galilea provinciachru Caná marcapita Natanael, Zebedeupa wamrancuna y Jesuspa ishcay mas discïpuluncuna. ");
INSERT INTO qva_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simón Pedro niran: “Pescacogmi aywaycä”. Paycuna nipäcuran: “Nogacunapis gamwan aywashag”. Chauraga aywapäcuran. Büquiman jegapäcuran. Ichanga chay chacay juctapis mana pescacäriranchu. ");
INSERT INTO qva_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nagana pacha waraycaptinna lamar cantunchru Jesús ricacämuran. Ichanga discïpuluncuna Jesús canganta manam musyapäcuranchu. ");
INSERT INTO qva_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesús tapuran: “Wamracuna, ¿charirärinquichu?” Discïpulucuna nipäcuran: “Manam”. ");
INSERT INTO qva_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesús niran: “Derëcha läduman redniquita mashtapäcuy y pescäduta charipäcunquim”. Ningannuy rurapäcuran. Chaypita redninta chutayta mana puedipäcuranchu achca pescäducuna captin. ");
INSERT INTO qva_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Chauraga cuyangan discïpulun Jesusta reguiycur Pedruta niran: “¡Payga Señor Jesusmi!” “Señor Jesusmi” ninganta mayaycur Simón Pedro röpaynagla caycanganpita röpanta jaticuran. Nircur lamarman jegarpurcur cantucama nadyaypa aywaran. ");
INSERT INTO qva_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Waquin discïpuluncuna ichanga büquiwan pescädu junta redninta garashchracurcur lamar cantuncama chrayapäcuran. Lamarpita cantunman caran pachrac (100) metrunuy. ");
INSERT INTO qva_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Cantuman chrayaycurna ricapäcuran shansha jananchru pescädu chruraraycagta y tantata. ");
INSERT INTO qva_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesús niran: “Chayrag charipäcamungayquipita juc ishcay pescäduta apapäcamuy”. ");
INSERT INTO qva_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simón Pedro büquiman jegarcur lamar cantuncama red junta jatusag pescäduntinta garashchrämuran. Chaychru caran pachrac pichga chrunca quimsa (153) pescäducuna. Chaychica pescädu caycaptinpis red manam rachricaranchu. ");
INSERT INTO qva_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesús niran: “Micunanchipag shapäcamuyna”. Señor Jesús canganta musyarmi maygan discïpulunpis pï cangantapis tapuyta mana camaycäriranchu. ");
INSERT INTO qva_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesús ashuycurna tantata y pescäduta paycunata goran. ");
INSERT INTO qva_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Wañunganpita cawarircamur chaywanga quimsa cutinam discïpuluncunata Jesús ricariparan. ");
INSERT INTO qva_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Micuyta usharcurnam Jesús tapuran Simón Pedruta: “Juanpa wamran Simón, ¿paycuna cuyapäcamanganpitapis gam maschu cuyamanqui?” Pedro niran: “Au, tayta, gam musyanquim cuyangäta”. Jesús niran: “Nogaman yäracamagcuna üshanuypis caycagcunata cuyday”. ");
INSERT INTO qva_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yapay tapuran Pedruta: “Juanpa wamran Simón, ¿cuyamanquichu?” Pedro niran: “Au, tayta, gam musyanquim cuyangäta”. Jesús niran: “Üshäcunata cuyday”. ");
INSERT INTO qva_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Quimsa cutina Jesús tapuran: “Juanpa wamran Simón, ¿cuyamanquichu?” Cuyanganta quimsa cutina tapuptin Pedro laquisha niran: “Gam lapantapis musyanquim, tayta. Gam musyanquim cuyangäta”. Jesús niran: “Üshäcunata cuyday. ");
INSERT INTO qva_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Rasunpam gamta nï: Mösularag carga quiquilayqui röpayquita jaticurayqui maypapis munangayquipa aywanayquipag. Auquinna car ichanga maquiquita mashtaranqui y jucna röpayquita jatipäshunqui y mana munangayquipam apashunqui”. ");
INSERT INTO qva_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Chaynuy nirmi Jesús tantiyachiran imanuypa Pedro wañunanpag canganta y chaynuy wañuyninpa Tayta Diosninchi ali ricasha cananpag musyachiran. Nircurnam Pedruta niran: “Nogawan puriy”. ");
INSERT INTO qva_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Muyurcunganchru Pedro ricaran Jesús cuyangan discïpulun aywaycämogta. Chay discïpulunmi cënapäcuptin Jesuspa lädunchru casha caran y paymi tapusha caran: “Tayta, ¿pitag contrayquicunaman entregäshunqui?” nir. ");
INSERT INTO qva_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pedro ricar Jesusta tapuran: “Tayta, paytaga ¿imatag pasanga?” ");
INSERT INTO qva_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús niran: “Cutimungäcama pay cananta noga munaptïpis ¿gamta imata gocushunqui? Gam nogawan puriy”. ");
INSERT INTO qva_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Chaymi Jesusman yäracogcunachru cuentu mashtacaran chay discïpulunga imaypis mana wañunanpag canganta. Ichanga Jesús manam niranchu imaypis mana wañunanpag canganta. Jesús niran: “Cutimungäcama pay cananta noga munaptïpis ¿gamta imata gocushunqui?” ");
INSERT INTO qva_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Chay quiquin discïpulunmi caycunata willacun y escribisha. Musyapäcümi willacungancuna rasuncag canganta. ");
INSERT INTO qva_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Caycanrämi Jesús mas rurangancuna. Jucpa cama lapanta escribicaptinga tantiyaynïpita cay pachapis manam aypanmanchu escribingan librucunata chrurananpag. Amén.");
INSERT INTO qva_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tayta Teófilo, puntacag librüchrüga escribirä galaycunanpita pacha asta cieluman aywacungan junagcama Jesús lapan rurangancunapita y yachrachingancunapita. ");
INSERT INTO qva_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Jesús manaräpis cieluman aywacurmi acrangan apostulnincunata Santu Espirituwan niran imata rurapäcunanpäpis canganta. ");
INSERT INTO qva_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Wañunganpita cawarircamur rasunpa cawaycangan musyacänanpag apostulnincunata cawaycar cangannuy caycanganta ricachicuran. Pay chruscu chrunca junag achca cuti ricachicuran y Tayta Diospa munayninpita willaparan. ");
INSERT INTO qva_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Apostulnincunawan caycarmi paycunata Jesús niran Jerusalenpita mana aywacärinanpag. Niran: “Tayta Dios promiticungan Santu Espirituta shuwaräpäcuy. Chaypita gamcunata maynam nirä. ");
INSERT INTO qva_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Juan Bautista rasunpam yacuwan bautizaran. Gamcunam ichanga Santu Espirituwan bautizasha capäcunquipag. Chaynuy cananpag manam achca junagcunachu pasanga”. ");
INSERT INTO qva_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Chaychru shuntacasha caycagcuna Jesusta tapuran: “Tayta, ¿cananpitachu cay Israel nacion gampa munayniquichrüna canga?” ");
INSERT INTO qva_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesús niran: “Gamcunaga manam musyapäcunayquichu imay junag ni ima höra chaycuna cananpag cangantapis. Taytalämi chaycunata ima höra pasananpag cangantapis ninanpag munayniyog caycan. ");
INSERT INTO qva_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ichanga Santu Espíritu gamcunaman shamuptinmi munayninta chrasquipäcunqui. Chrasquircurnam Jerusalenchru, intëru Judea y Samaria provinciacunachru y may chay caru naciuncunachrüpis nogapita musyangayquita willacärimunqui”. ");
INSERT INTO qva_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Niyta usharcuptinnam paycuna ricararcaptin Jesús altupana jogarcusha caran. Altuchrüna pucutay chapacurcuptin paycuna manana ricapäcurannachu. ");
INSERT INTO qva_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Cieluman Jesús aywacuycanganta ricararcaptinmi mayänipita ishcay runacuna yurag röpashacama paycunacagchru ricacämuran. ");
INSERT INTO qva_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Paycunata niran: “Galilea runacuna, ¿imanirtag cieluta ricararcanqui? Gamcunawan caycanganpita cieluman apacusha caycag Jesús imanuymi apasha caycan chaynuylam yapay quiquin cutimunga”. ");
INSERT INTO qva_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Chauraga Olivos jutiyog lömapita apostulnincuna Jerusalenman cutipäcuran. Chaypita Jerusalenman juc kilömetrunuyla captinmi cercala caran. ");
INSERT INTO qva_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Marcaman chrayaycärirnam pacharangan wasipa altucag pïsunman jegapäcuran. Paycunam caran Pedro, Juan, Santiago, Andrés, Felipe, Tomás, Bartolomé, Mateo, Alfeupa wamran Santiago, Simón “Celote” nipäcungan y Santiagupa wamran Judas. ");
INSERT INTO qva_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Chay wasichrümi imaypis Tayta Diosta rugacärinanpag warmicunawan, Jesuspa maman Mariawan y paypa wauguincunawan paycuna shuntacäpäcog. ");
INSERT INTO qva_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Chay junagcunam Jesusman yäracogcuna pachrac ishcay chruncanuy (120) shuntacasha caycaran. Paycunatam Pedro niran: ");
INSERT INTO qva_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Wauguicuna panicuna, Judaspag Santu Espíritu Davidwan escribichingan cumplinan caran. Jesusta prësu charipäcunanpag Judas reguichiran. ");
INSERT INTO qva_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Pay nogacunanuylam apóstol caran y Tayta Diosninchi mandanganta rurapäcunäpag paypis chrurasha caran”. ");
INSERT INTO qva_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Judas pasaypa mana alita ruranganpita pägangan guellaywanmi chracrata rantiran. Chay chracrachrümi janapita uraman uman turpaypa jegarpuran pachranpis pashtagpag y aglinnincunapis mashtacagpag. ");
INSERT INTO qva_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jerusalenchru lapan tiyagcuna chaynuy pasanganta musyaycur chay chracrapa jutinta chrurapäpäcuran Acéldama jutin cananpag. Paycunapa rimayninchrüga “Yawar pampa” ninanmi.) ");
INSERT INTO qva_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Salmo libruchru niycan: ‘Wasin jaguirisha cachun. Chaychru pipis ama tiyachunchu’. Chaynuypis niycan: ‘Pay rurananpag cagta jucna rurachun’ ”. ");
INSERT INTO qva_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Nircurna niran: “Caychru caycan Señor Jesús noganchiwan canganpita pacha pureg runacuna. ");
INSERT INTO qva_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Paycuna casha runacuna bautizacunanpag Juan willacunganpita asta Jesús cieluman aywacungan junagcamam. Chaymi paycunapita jucninta acrananchi noganchiwan purinanpag. Paypis Jesús cawarimusha caycagta ricanganta willacunanpag”. ");
INSERT INTO qva_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Chauraga ishcay runacunata acrapäcuran. Jucagninpa jutin caran José. Payta nipäcog Barsabás y nipäcog Justo. Jucagninpa jutinmi caran Matías. ");
INSERT INTO qva_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Paycunapag Señor Jesusta rugacurmi nipäcuran: “Tayta, gam lapan runapa yarpaynin imanuy cangantapis musyaycarga cay ishcanpita mayganta acrangayquitapis musyachipäcamay. ");
INSERT INTO qva_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Payna Judaspa truquin apóstol canga y Tayta Diosninchi mandanganta rurananpag cagta ruranga. Judasga apóstol cayta jaguiriycur aywananpag cagman aywacushana”. ");
INSERT INTO qva_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nircurnam surtiyapäcuran. Chauraga Matiaspag yargamuran. Chaynuypa chrunca jucnin (11) caycanganman chrunca ishcaynin (12) apostulcuna cananpag yapacaran. ");
INSERT INTO qva_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentecostés fiesta junag chrayaruptin Jesusman lapan yäracogcuna juc pachalachru shuntacasha carcaran. ");
INSERT INTO qva_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Chaychru jamararcarmi fiyupa wayranuy gaparir cielupita aywaycämogta mayänipita mayapäcuran. Chay fiyupa gaparir shamogmi paycuna caycangan wasiman juntagpag chrayaran. ");
INSERT INTO qva_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Chaychrünam nina rupaycar ichriregtanuy jucninman cama ichregta ricapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Chaychrünam Santu Espirituta lapan chrasquipäcuran. Nircurna jucninpacama Santu Espíritu rimachingan tupu mana yachrangan idiomacunachru rimaran. ");
INSERT INTO qva_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tayta Diosninchita adorag Israel runacunam may chay naciuncunapitapis Jerusalenchru tiyaran. ");
INSERT INTO qva_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Chaynuy rimaycanganta mayar chayman runacuna shuntacäpäcuran. Chaychrümi jucninpis jucninpis quiquinpa idiomanchru rimarcagta mayar imata yarpachracuytapis mana atipäpäcuranchu. ");
INSERT INTO qva_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Pasaypa almirasha nipäcuran: “Cay rimaycag lapan runacunaga ¿manachu Galilea runacuna? ");
INSERT INTO qva_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Paycuna imanuypatag yuringanchipita pacha rimanganchi idiomanchita jucninchi jucninchitapis parlapämänanchipag yachran? ");
INSERT INTO qva_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Caychru caycanchi Partiapita, Mediapita, Elampita, Mesopotamiapita, Judeapita, Capadociapita, Pontupita, Asiapita, ");
INSERT INTO qva_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigiapita, Panfiliapita, Egiptupita, Libiachru cag Cirene marcapa cercancunapita. Chaynuypis caycan fiestaman Romapita shamog runacuna. Waquinninchicunaga yuringanchipita pacha Israel castam caycanchi. Y waquinninchicunaga Israel casta canapäna yaycucushanam caycanchi. ");
INSERT INTO qva_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Chaynuy Cretapitapis Arabiapitapis shamogcuna caychru caycanchi. Ichanga Tayta Dios almiraypag ruranganta willapämanganchita quiquinchipa idiomanchichrümi mayaycanchi”. ");
INSERT INTO qva_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Chaymi almirasha y ima yarpaytapis mana atipar quiquinpura parlapäcuran: “¿Imatag caychru pasaycan?” nir. ");
INSERT INTO qva_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Chauraga burlacur waquincunaga nipäcuran: “Caycunaga shincasham carcan”. ");
INSERT INTO qva_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Chauraga Pedro chrunca jucnin (11) apostulcunawan ichrircur fiyupa niran: “Israel runacuna y Jerusalenchru tiyag lapan runacuna gamcuna cayta musyapäcunquiman y ningäcunata shumag mayapäcamay. ");
INSERT INTO qva_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Manam gamcuna yarpäpäcungayquinuychu, las nuevilarag caycaptinga ¿imanuypatag paycuna shincasha capäcunman? ");
INSERT INTO qva_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Chaypa truquinga Tayta Diospa willacognin Joel ningannuylam canan ruracaycan. Paymi caynuy niran: ");
INSERT INTO qva_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Tayta Diosninchi caynuy nin: Pacha ushacänan junagcuna Santu Espirituta cachramushag lapan runacunaman. Olgu wamrayquicunam y warmi wamrayquicunam musyachingäcunata willacäringa. Mösucunapis ricaripächingäcunatam ricanga. Auquincunatapis suyñuyninchru musyachishag. ");
INSERT INTO qva_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Chay wichanmi noga mandangäta ruragcunaman olgumanpis warmimanpis Santu Espirituta cachramushag. Chaynuypam paycuna musyachingäcunata willacäringa. ");
INSERT INTO qva_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Cieluchru señalcunata ricacächimushag. Pachachrüpis señalcunata ricacächimushag; yawarta, ninata y pucutaynuy goshtita. ");
INSERT INTO qva_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Inti chacacäcunga; quilla yawar nirag ricacäcunga. Chaynuy canga Señor juzganan junag manarag chrayamuptinmi. Chay junäga shumag alim canga. ");
INSERT INTO qva_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Y Tayta Diosninchita rugacogcäga salvasham canga’. ");
INSERT INTO qva_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Israel runacuna, cay ningäta mayapäcamay: Quiquiquicuna musyapäcungayquinuypis Tayta Diosninchim gamcunachru Nazaret marcapita Jesuswan munayninta y milagrucunata rurachiran. Chaynuypa pay Tayta Diosninchi cachramunganta musyachimaranchi. ");
INSERT INTO qva_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Payta gamcunaman entregäpäcushurayqui. Chaypitanam gamcuna fiyu runacunawan crucificaypa wañuchichipäcurayqui. Chay lapan caran Tayta Dios chaynuy cananpag nisha captinmi. Chaytaga unaypitanam musyaran. ");
INSERT INTO qva_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ichanga Jesusta Tayta Diosninchi wañunganpita cawarichimusha. Pay pamparangalanchrüga manam quëdanmanchu caran. ");
INSERT INTO qva_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Chaynuy cananpag captinmi David Jesuspag niran: ‘Ñaupagnïchrümi Tayta Diosta imaypis ricashcä. Pay derëchacag lädüchru captinmi imatapis mana manchacüchu. ");
INSERT INTO qva_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Chaypitam shongü cushicusha. Cushicuypitam cantashcä. Tayta Diosta shuwaraycar cawashag. ");
INSERT INTO qva_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Sepultüralachru manam jaguiriycamanquichu. Cuyayniqui captïmi cuerpü ismunanta pamparangalächrüga manam jaguirinquichu. ");
INSERT INTO qva_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Yachrachimashcanqui imatapis alita rurar cawanäpag. Gam nogawan captiquim cushishala cawaycä’. ");
INSERT INTO qva_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Israel masïcuna, gamcunata rasunpam niycä unay rey Davidpita. Pay wañuranmi y pampapäcuranmi. Pay mayninchru pamparangantapis canancama reguiycanchim. ");
INSERT INTO qva_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","David Tayta Diospa willacogninmi caran. Chaymi pay musyaran miragnincunapita jucninta maygantapis rey cananpag chrurananpag canganta Tayta Diosninchi juranganta. ");
INSERT INTO qva_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Chaynuy captin pay maynam Tayta Dios imata rurananpag cagtapis tantiyar Dios cachramungan Salvador cawarimunanpag canganta niran. Chaynuypis niran pay sepultüralachru mana jaguiriycusha y pamparangalanchru ayan mana ismunanpag canganta. ");
INSERT INTO qva_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Tayta Diosninchi chay quiquin Jesustam cawarichimusha. Cawarircamuptin payta lapäcunam ricapäcushcä. ");
INSERT INTO qva_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jesusta Tayta Diosninchi cieluman pushacurcurna derëchacag lädunman jamachisha lapanpag munayniyog cananpag. Tayta Diosninchi promitingan Santu Espirituta chrasquircurnam pay nogacunaman mashtamusha. Mashtamuptin juc idiomacunachru parlapäcungätam gamcuna mayapäcushcanqui y ricapäcushcanqui. ");
INSERT INTO qva_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Wañuruptin Davidchu manam cieluman apasha caran. Ichanga Jesuspita Davidpis niranmi: ‘Tayta Diosmi Señurnïta niran: Cay derëchacag lädüman jamacuy ");
INSERT INTO qva_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","contran cagcunata munayniquiman chruramungäcama’. ");
INSERT INTO qva_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Israel runacuna, lapayqui cayta rasunpa canganta musyapäcunquiman. Cay quiquin Jesusta cruzchru wañuchipäcungayquitam munayniyog Señor cananpag y Tayta Dios cachramungan Salvador cananpag Tayta Diosninchi chruraran”. ");
INSERT INTO qva_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Chauraga chaychru shuntacasha caycagcuna chay ninganta mayar fiyupa laquicur Pedruta y waquin apostulcunata tapupäcuran: “Israel masïcuna, chauraga ¿imatatag rurapäcüman?” nir. ");
INSERT INTO qva_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedro niran: “Tayta Diosninchi perdunäshunayquipag juchayquicunapita wanacäriy y Jesucristupa jutinchru bautizacäriy. Chayrämi gamcunata Santu Espirituta gopäcushunquipag. ");
INSERT INTO qva_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Chay promitinganga gamcunapämi, miragniquicunapämi y may chay caruchrüpis tiyagcunapämi caycan. Tayta Diosninchi pitapis acrangancagcunapämi caycan”. ");
INSERT INTO qva_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Tucuynuypa Pedro anyanacur niran: “¡Chay juchäcog runacunapita ashucäriy salvacärinayquipag!” ");
INSERT INTO qva_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Chauraga Pedro willapanganta criyegcunaga bautizacäriran. Chaynuypa chay junag Jesusman yäracogcunaman chay quimsa waranganuy (3,000) bautizacogcuna yapacaran. ");
INSERT INTO qva_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Paycunam apostulcuna yachrachingancunata imaypis yachracäreg. Waquin yäracogcunawan juc shongunuyla capäcunanpag gotucäpäcog. Shuntanacuycur micapacäreg. Tayta Diosninchita rugacäreg. ");
INSERT INTO qva_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Apostulcuna milagrucunata Tayta Diosninchipa munayninwan ruragta ricar lapan runacunam manchacasha carcaran. ");
INSERT INTO qva_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jesusman yäracogcuna lapan juc shongunuyla charangancunata nisitangan tupu raquipänacäreg. ");
INSERT INTO qva_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Chaynuy rurapäcog chracrancunata y imaycancunatapis ranticuycur chay guellayta nisitanganman tupu lapan raquipänacur. ");
INSERT INTO qva_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Waran waranmi templuman shuntacäpäcog. Wasincunachrüpis shuntacaycur cushisha shacya shacyala micapacäreg. ");
INSERT INTO qva_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Paycunaga Tayta Diosta alabäpäcog. Lapan runacunam paycunata ali ricapäcog. Waranpa waranpam runacuna salvasha caycagcunata waquin yäracogcunaman Señor Jesús yapag. ");
INSERT INTO qva_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Juc cutinchru Juanwan Pedro Tayta Diosta rugacuna höra templuman jegapäcuran. Chay höra caran mallway höra. ");
INSERT INTO qva_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Chay templo puncuchrümi juc runa yuringanpita pacha puriyta mana puedeg caycaran. Chay runatam waran waran apapäcog templuchru “Cuyaylapag” jutiyog puncuman. Chay puncuchru templuman yaycogcunata limusnata mañacunanpag. ");
INSERT INTO qva_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Juanwan Pedro templuman yaycunanpäna caycagta ricarmi chay mana puriyta puedeg runa limusnata mañacuran. ");
INSERT INTO qva_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Chauraga shumag ricapäpäcuran. Nircur Pedro niran: “¡Ricärimuy!” ");
INSERT INTO qva_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Niptin chay runaga ricäriran imalatapis goycunanta yarpar. ");
INSERT INTO qva_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pedro niran: “Manam guellaynïpis ni örüpis canchu; ichanga charangaläta goycushayqui. ¡Nazaret marcapita Jesucristupa munayninwan sharcuy y puriy!” ");
INSERT INTO qva_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Chaynuy nir derëchacag maquinpita charircur ichrircachiran. Ichrircachiptinna chay höra chraqui moguncunapis sänu ricacuran. ");
INSERT INTO qva_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Chauraga puriyta mana puedeg runa saltar ichrircur puriyta galaycuran. Nircurna paycunawan puriycarna saltaycar Tayta Diosta alabaycar templuman yaycuran. ");
INSERT INTO qva_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Lapan runacuna puriycagta y Tayta Diosninchita alabaycagta ricapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Reguipäcuran “Cuyaylapag” jutiyog templo puncuchru limusnata mañacog runa canganta. Chaynuy pasanganpita runacuna mancharisha y almirasha ricaräpäcuran. ");
INSERT INTO qva_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Chay puriyta mana puedeg runa cuticarurna Juantawan Pedruta mana cachrariranchu. Chayta ricarmi runacuna almirasha “Salomón” jutiyog ramädachru caycagman cörripäcamuran ricananpag. ");
INSERT INTO qva_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Chayta ricaycur runacunata Pedro niran: “Israel runacuna, ¿imanirtag gamcuna almirasha carcanqui? ¿Imanirtag quiquïcunapa munaynïcunawan o juchaynag capäcuynïpa cutichicächisha caycagtanuypis ricaparcämanqui? ");
INSERT INTO qva_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abrahampa, Isaacpa, Jacobpa y unay Israel castanchipa Tayta Diosninmi Jesusta chruraran imatapis pay mandanganta rurag cananpag y lapan runacuna shumag ali ricananpag. Paytam gamcuna autoridäcunapa maquinman chrurapäcurayqui y Piläto cachrariyta munaptinpis gamcuna mana munar paypa ñaupagninchru niegapäcurayqui. ");
INSERT INTO qva_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Dioslapag cagta y Alilata Ruragcagta cachrarinanpag nipäcunayquipa truquinga gamcuna runamasinta wañucheg runata cachrarinanpag nipäcurayqui. ");
INSERT INTO qva_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Chaynuypam gamcuna wañuchipäcurayqui mana ushacaypa cawayman apamagninchi runata. Chaynuy captinpis Tayta Diosninchi cawarichimuran. Cawarircamuptin payta lapäcunam ricapäcushcä. ");
INSERT INTO qva_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Cay ricarcangayqui y reguipäcungayqui runaga Jesusman yäracäriynïpam cuticasha caycan. Payman yäracäriynïpam ricapäcungayquinuypis cay runata shumag cuticächisha. ");
INSERT INTO qva_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Israel masïcuna, musyämi gamcuna y autoridäniquicuna rasunpa mana musyayninpa Jesusta wañuchipäcunganta. ");
INSERT INTO qva_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Unaynam lapan willacogcunawan Tayta Dios willacachiran cachramungan Salvador nacananpag canganta. Chay willacachinganmi chaynuypa cumpliran. ");
INSERT INTO qva_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Chaymi cananga juchayquicunapita wanacurir Tayta Diosninchita cäsucärinayqui juchayquicunapita perdunäshunayquipag. Chaynuypa Señurninchi Tayta Dios cushisha cawachipäcushunquipag. ");
INSERT INTO qva_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Chaynuypis Jesusta gamcunaman cachramungapag. Paytam Tayta Diosninchi gamcunapag chruraranna pay cachramungan Salvador cananpag. ");
INSERT INTO qva_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ichanga Jesús cieluchrürämi canga Tayta Diosninchi imaycatapis quiquin munangannuy cananpag lapantapis chrurangancama. Chaynuy cananpag cangantaga unay willacognincunawannam pay willacachiran. ");
INSERT INTO qva_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moisés niran unay Israel castanchicunata: ‘Señurninchi Tayta Diosmi aylluyquipita juc runata chruranga noganuy Diospa willacognin cananpag. Imata nipäcushuptiquipis gamcunaga payta cäsucärinqui. ");
INSERT INTO qva_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Pipis chay willacogta mana cäsucogcäga Israel runacunapita raquircur wañuchisham canga’. ");
INSERT INTO qva_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Lapan willacogcunam Samuelpita galaycur canan wichan caynuy pasananpag willacäriran. ");
INSERT INTO qva_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Tayta Diosninchi gamcunapag promitinganta willacognincunawan willacachiran. Chaynuypis gamcunapämi unay castanchicunawan Tayta Diosninchi conträtuta rurangan. Chaychrümi Abrahamta Tayta Diosninchi niran: ‘Gampita miragmi intëru pachachru runacunata bendiciunta gonga’. ");
INSERT INTO qva_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Jesusta Tayta Diosninchi mandanganta rurag cananpag chrurarcurpis payta gamcunamanmi puntata cachramuran bendiciunninta gopäcushunayquipag. Chay bendiciunnin caran juchäcuyta jaguiripäcunayquipämi”. ");
INSERT INTO qva_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Juanwan Pedro chaychru willacurcaptinrämi cüracuna, templuta cuydag wardiacunapa capitannin y saduceucuna chrayaran. ");
INSERT INTO qva_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Paycuna rabyasha carcaran Juanwan Pedro runacunata Jesús wañunganpita cawarimusha captin runacunapis cawarimungam nir yachrachinganpita. ");
INSERT INTO qva_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Chaynuy yachrachinganpita Juantawan Pedruta prësu charircur tardina captin warantincama carcilman wichrgaycäriran. ");
INSERT INTO qva_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ichanga willacungancunata mayagcunaga Jesusman achcagmi criyipäcuran. Chaychru lapan criyegcuna olgucuna caran pichga waranganuy (5,000). ");
INSERT INTO qva_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Warantin Jerusalenchru shuntacaran Israel runacunapa autoridänincuna, Israel mayor runacuna y Moisés escribingan leycunata yachrachegcuna. ");
INSERT INTO qva_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Chaychrümi caycaran cüracunapa mas mandagnin Anás, Caifás, Juan, Alejandro y cüracunapa mas mandagninpa aylluncuna. ");
INSERT INTO qva_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Chaychrünam Juantawan Pedruta carcilpita apapäcamunanpag niran. Chrayaycachiptinna chraupincunaman ichriycachir tapuran: “¿Ima munayniquiwantag o pipa munayninwantag gamcuna chaycunata rurapäcushcanqui?” nir. ");
INSERT INTO qva_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Chauraga Santu Espiritupa munayninchru car Pedro niran: “Israel runacunata mandagcuna y Israel mayor runacuna, ");
INSERT INTO qva_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","gamcuna tapurcämanqui gueshyag runata alita rurapäcungäpita y musyayta munarcanqui imanuypa cuticasha cangantapis. ");
INSERT INTO qva_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Lapayqui gamcuna y lapayqui Israel runacuna musyapäcuy cay lapayquipa ñaupagniquichru caycag runa Nazaretpita Jesucristupa munayninwan cuticasha canganta. Gamcuna pay quiquin Jesustam crucificaypa wañuchipäcurayqui. Chaytanam Tayta Diosninchi cawarichimusha. ");
INSERT INTO qva_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Gamcuna wasi ruragcuna ‘mana ali rumim’ nir jitaripäcungayqui ruminuy Jesusmi caycan. Ichanga pay ticrasha cimientupag alinnincag rumimannuy. ");
INSERT INTO qva_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Paypita jucga manam pipis salvamäshunchu. Cay pachachru juctaga salvamänanchipag Tayta Diosninchi manam chrurashachu”. ");
INSERT INTO qva_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Mana estudiasha runacuna caycarpis mana manchacuypa ishcan apostulcuna willacäregta ricarmi autoridäcuna almiräpäcuran. Chaynuypis tantiyapäcuran Jesuspa discïpuluncuna capäcunganta. ");
INSERT INTO qva_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Chaychru cuticächingan runa paycunawan ichriraptinmi contran ima niytapis mana camäpacäriranchu. ");
INSERT INTO qva_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Nircurna chaychru carcanganpita puncuman jorguchiran. Quiquincunaga quiquinpura jucagnin jucagnin rimanacuycar quëdacäriran. ");
INSERT INTO qva_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Nipäcuran: “¿Imatatag rurashun cay runacunata? Lapan Jerusalén runacuna musyan milagru rurapäcunganta. Chayta mana niegayta puedinchichu. ");
INSERT INTO qva_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ichanga cay milagru jucnin jucninman pimanpis mana chrayananpag chrunca chrunca nishun Jesuspita mana pitapis willapananpag”. ");
INSERT INTO qva_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Chaymi apostulcunata gayaycachimur manana mas Jesuspita rimacunanpag ni yachrachinanpag nipäcuran. ");
INSERT INTO qva_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Nipäcuptinmi Juanwan Pedro nipäcuran: “Shumag yarpachracäriy: Alichu canman Tayta Diosninchipag ¿payta cäsucunäpa truquinga gamcunata cäsucuptï? ");
INSERT INTO qva_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ichanga nogacuna ricapäcungäta y mayapäcungätaga pitapis willapäpäcunämi”. ");
INSERT INTO qva_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Manana mas rimacärinanpag autoridäcuna yapay niran. Nircurna cachrariycäriran. Paycuna imapita castigänanpäpis mana taripäcuranchu milagruta ruranganpita lapan runacuna Tayta Diosninchita alabäpäcuptin. ");
INSERT INTO qva_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Chay milagruwan cuticag runaga chruscu chrunca (40) watayogpita masnam caycaran. ");
INSERT INTO qva_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Cachrariycuptinna Juanwan Pedro yäracogmasincunaman aywapäcuran. Chrayaycurnam cüracunapa mandagnincuna y Israel mayor runacuna ima ningantapis willapäpäcuran. ");
INSERT INTO qva_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Lapanta willaparcuptinmi Tayta Diosta lapan caynuy rugacäriran: “Imaycapäpis munayniyog Tayta Dios, gammi camashcanqui cielutapis, cay pachatapis, lamartapis y lapan chaychru cagcunatapis. ");
INSERT INTO qva_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Gam Santu Espirituta nirayqui mandangayquita rurag unay ayllü David caynuy ninanpag: ‘¿Imanirtag fiyupa rabyasha carcaran mana Israel runacuna? ¿Imanirtag Israel runacuna manacagcunata rurayta yarpäpäcuran? ");
INSERT INTO qva_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Cay pachachru mandag reycuna y nacion mandagcuna shuntacäpäcuran Tayta Diosninchipa contran y pay cachramungan Salvadurpa contran sharcapäcunanpag’. ");
INSERT INTO qva_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Rasunpam cay Jerusalenchru Herodes, Poncio Piläto, mana Israel runacuna y Israel runacuna mandangayquita rurag Jesuspa contran sharcapäcunanpag shuntacaran. Chay Jesustam cachramurayqui Salvador cananpag. ");
INSERT INTO qva_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Paycunaga chay lapanta rurapäcusha unaypita pacha munayniquiwan imanuy cananpäpis yarpangayquinuylam. ");
INSERT INTO qva_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Tayta Dios, ricay cananpis cay autoridäcuna juraparcämanganta. Mandangayquita rurag carcaptïga cananga valurta goycärilämay willacuyniquita mana manchacuypa willacärinäpag. ");
INSERT INTO qva_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Chaynuypis munayniquiwan gueshyagcuna cuticasha canman y milagrucunapis mandangayquita rurag Jesuspa munayninwan ruracasha canman”. ");
INSERT INTO qva_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tayta Diosta rugacuyta usharcuptin shuntacasha carcangan wasi cuyuriran. Chauraga Santu Espiritupa munayninchru lapan ricacuran. Chaypitana mana manchacuypa Tayta Diospa willacuyninta willacäriran. ");
INSERT INTO qva_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jesusman yäracogcuna lapanpis juc shongunuyla capäcuran. Mayganpis imaycantapis manam quiquilanpag canganta yarpäpäcogchu. Sinöga lapanpag canganta yarpäpäcog. ");
INSERT INTO qva_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Señor Jesús cawarimushana caycagta ricapäcunganpita apostulcunaga mana manchacuypa willacäreg. Tayta Diosninchi imaycachrüpis lapanta shumag yanapag. ");
INSERT INTO qva_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Paycunachrüga manam mayganpis pishïpacog caranchu. Mayganpapis chracran wasin captinga ranticuycur chay guellayta apapäcog. ");
INSERT INTO qva_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Nircurna chay guellayta apostulcunaman chruraycäreg mayganpis pishïpacuptinga paycunana aypunanpag. ");
INSERT INTO qva_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Chaynuymi ruraran José jutiyog runapis. Pay Leví casta Chipre islapitam caran. Apostulcuna jutipäpäcuran Bernabé jutin cananpag. “Bernabé” ninanga caran “shogacog” ninanmi. ");
INSERT INTO qva_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Cay runapa caran juc chracran. Chay chracranta ranticuycur guellayta apostulcunaman chruraycuran. ");
INSERT INTO qva_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Chaychrümi caran juc runa Ananías jutiyog. Paymi warmin Safirawan chracranta ranticäriran. ");
INSERT INTO qva_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ichanga cay runa warminwan yachrachinacurir chracran ranticungan guellayta raquiran. Nircur waquincaglatana apostulcunaman chruraycuran: “Caylachrümi chracräta ranticushcä” nir. ");
INSERT INTO qva_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pedro niran: “Ananías, ¿imanirtag munanganta Satanás rurarärichishunqui chracra ranticungayqui guellaypita waquinta raquicurir waquilantana entregar Santu Espirituta casquipänayquipag? ");
INSERT INTO qva_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Chay chracraga manachu quiquiquipa caran? Ranticuycaptiquinaga ¿guellaypis manachu quiquiquipa caran? ¿Imanirtag yarpashcanqui chaynuy rurayta? Gam runacunatachu manam casquipashcanqui sinöga Tayta Diostam”. ");
INSERT INTO qva_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Chay ninganta mayar Ananías wañusha ratariycuran. Chaynuy wañunganta musyagcäga lapan fiyupa mancharipäcuran. ");
INSERT INTO qva_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Chayman mösucuna chrayaycurmi Ananiaspa cuerpunta wancurcur pampananpag apacäriran. ");
INSERT INTO qva_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Chaypita quimsa höratanuy ima pasangantapis mana musyayninpa Ananiaspa warmin chrayaran. ");
INSERT INTO qva_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Chrayaptin Pedro tapuran: “Nimay, ¿cay preciuchrüchu gamcuna chracrayquita ranticärishcanqui?” Chauraga Safira niran: “Au, chaychrümi”. ");
INSERT INTO qva_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pedro niran: “¿Imanirtag gamcuna yachrachinacärishcanqui Tayta Diospa Santu Espiritunta casquipayta munapäcunayquipag? Ricay, runayquita pampananpag apagcunapis pampaycur cutirärimunna. Cananga gamtanam apapäcushunqui”. ");
INSERT INTO qva_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Niptin chay höra Pedrupa ñaupagninman Safira wañusha ratariycuran. Yaycur mösucuna wañushatana taripäcuran. Chaypitana runanpa lädunman pampananpag apacäriran. ");
INSERT INTO qva_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Yäracog lapan shuntacagcuna y chaynuy canganta mayagcunaga lapan fiyupa mancharipäcuran. ");
INSERT INTO qva_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Tayta Diospa munayninwan apostulcuna runacunachru achca milagrucunata rurag. Jesusman yäracogcuna imaypis shuntacäpäcog “Salomón” jutiyog ramädaman. ");
INSERT INTO qva_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Paycunawan runacuna manana shuntacagnachu. Ichanga runacuna paycunata shumag alipag ricapäcog. ");
INSERT INTO qva_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Chaynuy captinpis achcag olgupis warmipis Señor Jesusman yäracäriran. Chaynuypana Jesucristuman yäracogcuna mas achcayaran. ");
INSERT INTO qva_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Apostulcuna milagruta ruraptinmi runacunaga gueshyagcunata cämanwan o quirmawan cällicunaman jorgapäcamog Pedro pasaptin lantuylanpis maygalanmanpis chrayananpag. ");
INSERT INTO qva_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Cercachru cag marcacunapitapis gueshyagcunata y diablucuna nacachingancunatapis apacurcurmi Jerusalenman runacuna shapäcamog. Chay apangan gueshyagcunata apostulcuna lapantam cuticächiran. ");
INSERT INTO qva_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Cüracunapa mas mandagnin y paywan pureg saduceo runacuna pasaypa chriquiyta galaycäriran. ");
INSERT INTO qva_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Chaymi apostulcunata prësu charircachir carcilman wichrgachipäcuran. ");
INSERT INTO qva_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ichanga Tayta Diosninchipa angilnin chacaypa chrayaycur carcel puertacunata quichrarir jorgarcamur niran: ");
INSERT INTO qva_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Aywapäcuy templuman. Chaychru ichriycur lapan runacunata willapanqui mana ushacaypa cawaypita”. ");
INSERT INTO qva_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Chay ninganta mayar tutala templuman yaycuycur yachrachiyta galaycapäcuran. Cüracunapa mas mandagnin y paywan caycagcunam lapan Israel mayor autoridäcunawan shuntacäpäcuran. Nircurnam wardiacunata cachraran apostulcunata carcilpita pushamunanpag. ");
INSERT INTO qva_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ichanga wardiacuna carcilman chrayar manam taripäcuranchu. Cutiycurna caynuy willapäcuran: ");
INSERT INTO qva_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Carcilta shumag wichrgaraycagtam taripäcushcä. Wardiacunatapis carcel puertachru shumag cuydarcagtam taripäcushcä. Ichanga carcel puncuta quichrarir yaycur manam pitapis taripäcushcächu”. ");
INSERT INTO qva_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Chay ninganta mayar templo cuydag wardiacunapa capitannin y cüracunapa mandagnincunapis imanuy cananpag cagtapis mana tantiyarmi quiquinpura tapunacäriran. ");
INSERT INTO qva_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Chaynuy carcaptinmi juc runa chrayaycur niran: “¡Gamcuna carcilman wichrgapäcungayqui runacunaga templuchrüna runacunata yachrarcächin!” ");
INSERT INTO qva_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Chauraga wardiacunapa capitanninga wardiacunata pushacurcur apostulcunata asheg aywaran. Ichanga tariycur runacuna sagmananta manchacur mana magaypam pushapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Pusharna chrayachipäcuran lapan Israel mayor autoridäcuna shuntacasha caycagman. Cüracunapa mas mandagnin niran: ");
INSERT INTO qva_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Gamcunata chrunca chrunca nipäcurä chay runapita mana mas yachrachipäcunayquipag. Nircaptïpis gamcuna Jerusalenchru lapan runata yachrachicuyniquipita yachrarärichinqui. Nircurpis nogacunata jitaparcämanqui chay runa wañunganpita”. ");
INSERT INTO qva_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Niptin Pedruwan waquin apostulcunapis nipäcuran: “Runacunata cäsucunäpa truquinga nogacuna Tayta Diosninchitam cäsucärinä. ");
INSERT INTO qva_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Gamcuna Jesusta crucificaypa wañuchipäcusha captiquipis unay castanchipa Tayta Diosninmi cawarichimusha. ");
INSERT INTO qva_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Paytam Tayta Diosninchi pushacurcur derëchacag lädunman chrurasha mandamagninchi y salvadurninchi cananpag. Chaynuypa lapan Israel runacuna juchanpita wanacuptin juchäcungancunapita perdunanga. ");
INSERT INTO qva_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Cayta nogacuna musyarmi nircä. Caypitaga Santu Espiritupis musyanmi. Chay Santu Espiritutam Tayta Diosninchi payta cäsucogcunaman chrurasha”. ");
INSERT INTO qva_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Chaynuy nipäcunganta mayarmi autoridäcuna pasaypa rabyacur wañuchiyta munapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ichanga chay autoridäcunachrümi caycaran juc fariseo Gamaliel jutiyog runa. Pay Moisés escribingan leycunata yachracheg y lapan runacunam payta respitäpäcog. Paymi ichrircur niran rätula puncuman apostulcunata jorgunanpag. ");
INSERT INTO qva_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Jorgurcuptinna chaychru caycag autoridäcunata niran: “Israel runacuna, cay runacunata imatapis manarag rurar shumag yarpachracäriy. ");
INSERT INTO qva_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Pasag watacuna Teudas jutiyog runa yachrag runa canganta alabacur puriptinmi runacuna chruscu pachracnuy (400) gatiraran. Ichanga cay runata wañuchipäcuran. Wañurachiptin gatiragnincuna wacpa caypam mashtacar aywacäriran. ");
INSERT INTO qva_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Chaypitana censacuy canan wichan Galilea provinciapita Judaspis runacunata shuntaran gatiränanpag. Ichanga paytapis wañuchipäcuptin lapan gatiragnincuna mashtacar aywacäriran. ");
INSERT INTO qva_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Chaymi cananga gamcunata noga yächï cay runacunata jaguiriycärinayquipag y paycunata imatapis mana rurapäcunayquipag. Chay runacuna runapa yarpaynilanta rurapäcuptinga gongacäcungam. ");
INSERT INTO qva_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Tayta Diospita captinmi ichanga vinciyta mana puedipäcunquichu. Shumag yarpachracäriy. Cuydädu Tayta Diospa contran sharcurcanquiman”. ");
INSERT INTO qva_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Chay ningancunata cäsucurmi apostulcunata gayaycachimur astichiran y Jesuspita pasaypa mana rimacunanpag nipäcuran. Nircur cachrariycäriran. ");
INSERT INTO qva_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Apostulcuna Israel mayor autoridäcunapa ñaupagninpita cushisha aywacäriran. Paycuna cushisha carcaran Jesús janan chaynuy nacananpag Tayta Diosninchi chrurasha captin. ");
INSERT INTO qva_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Amacharcaptinpis paycunaga mana chrawaypa waran waran templuchru wasicunachru yachrachipäcog y ali willacuypita willapäpäcog. Chay willacuynin caran Jesús Tayta Dios cachramungan Salvador cangan. ");
INSERT INTO qva_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Chay wichancuna Jesusman yäracogcuna masna achcayaran. Chaychrümi griego rimag yäracogcuna hebreo rimag yäracogcunata jamurpäpäcuran. Chaynuy jamurparan griego rimag viudacunata cawananpag waran waran shumag mana aypunganpita. ");
INSERT INTO qva_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Chrunca ishcaynin apostulcuna Jesusman yäracogcunata shuntaycur nipäcuran: “Manam alichu canman nogacuna Tayta Diospa willacuyninta willacurcangäta jaguiriycur mësacunaman sirvinäpag chruracaptï. ");
INSERT INTO qva_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Wauguicuna panicuna, caychru gamcunapita ganchris runacunata acrapäcuy alipag ricasha cag, tantiyag y Santu Espiritupa munayninchru cagcunata paycunatana cay aruyman chrurapäcunäpag. ");
INSERT INTO qva_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nogacunaga Tayta Diosninchita mana yamacaypa rugacärishag y paypa willacuyninta willacärishag”. ");
INSERT INTO qva_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Chay parlapäcungan lapanpag ali captinmi acrapäcuran Jesusman shumag yäracog y Santu Espiritupa munayninchru cag Estebanta. Chaymanna acrapäcuran Felipita, Procoruta, Nicanurta, Timunta, Parmenasta y Antioquiapita Nicolasta. Nicolasga unaynam Israel casta cayman yaycucuran. ");
INSERT INTO qva_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Nircur chay acrangan ganchris wauguicunata apostulcunacagman pushapäcuran. Chaychrüna paycunapag Tayta Diosninchita rugacärir apostulcuna runacunapa umanman maquinta chruraycur imata rurapäcunanpäpis nipäcuran. ");
INSERT INTO qva_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Tayta Diosninchipa ali willacuynin Jerusalenchru mashtacaran y chaychru yäracogcuna canganpitaga masna achcayaran. Chaynuy achcag cüracunapis Jesuspa yachrachicuynincunata cäsucäriran. ");
INSERT INTO qva_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Tayta Diosninchi shumag yanapaptin paypa munayninwan Esteban milagrucunata runacunachru rurag. ");
INSERT INTO qva_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Waquin runacuna Estebanwan fiyupa parlapäcuran. Chaychru caran “Cachrarisha esclävucuna” jutiyog shuntacänan wasipita, Cirene marcapita y Alejandría marcapita runacuna. Chaynuypis caran Cilicia provinciapita y Asia provinciapita runacuna. ");
INSERT INTO qva_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Estebanta Santu Espíritu shumag parlachiptinmi chay runacuna ima niytapis mana camäpacäriranchu. ");
INSERT INTO qva_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Chaymi chay runacuna waquincunata casquicunanpag pägaran: “Moisespa y Tayta Diosninchipa contranmi lutanta Esteban rimasha” nipäcunanpag. ");
INSERT INTO qva_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Chaynuy niptin Estebanta rabyacheg runacuna Jerusalenchru runacunata, Israel mayor runacunata y Moisés escribingan leycunata yachrachegcunata rabyacachiran. Chauraga Estebanta chariycärir Israel mayor autoridäcuna shuntacasha caycanganman apapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Chaymanmi runacunata pushapäcuran casquicur nipäcunanpag: “Cay runaga Diosta adoräna templupa y Moisés escribingan leycunapa contran mana chrawaypa parlaycan. ");
INSERT INTO qva_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Cay runa nisha chay Nazaret marcapita Jesús templuta juchruchinanpag canganta y Moisés ningannuy imatapis rurananchipag canganta jucnuyman ticrachinanpag. Chaynuy parlanganta quiquïcunam mayapäcushcä”. ");
INSERT INTO qva_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Chauraga chaychru jamaraycag autoridäcuna y paycunawan jamaraycagcuna ricararcanganchru Estebanpa cäranta angilpa cärantanuy ricapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Estebanta cüracunapa mas mandagnin tapuran: “¿Rasunpachu cay runacuna nipäcungannuy gam rimashcanqui?” ");
INSERT INTO qva_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Esteban niran: “Israel masïcuna y taytacuna, mayapäcamay: Chipchipyaycag Tayta Diosninchi unay castanchi Abrahamta Mesopotamia partichru caycaptin Haranman manaräpis aywacuptin ricariparan. ");
INSERT INTO qva_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Chaychrümi niran: ‘Marcayquita y aylluyquicunata jaguiriycur aywacuy. Nogam mayman aywanayquipäpis ricachishayqui’. ");
INSERT INTO qva_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Chauraga caldeo runacuna tiyangan partita jaguiriycur Harán marcaman aywacuran. Taytan wañuruptinna Tayta Diosninchi pushamuran caychru gamcuna tiyarcaycangayquicagman. ");
INSERT INTO qva_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ichanga quiquinpag cananpag manam ni juc japarcuy chracralatapis goranchu. Ichanga wamran manarag captinpis promitiran miragnincunata goycunanpag y paycunapäna cananpag. ");
INSERT INTO qva_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Chaynuypis Tayta Diosninchi niran miragnincuna jäpa naciunchru jäpanuypis tiyapäcunanpag. Chaychru tiyarnam chruscu pachrac (400) wata chaychru runacunapa esclävun pasaypa nacachisha capäcunga. ");
INSERT INTO qva_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Tayta Diosninchi niran: ‘Noga castigäshämi chay naciunta esclävutanuy chararanganpita. Chaypitanam yargapäcamunga. Nircurnam caychru nogata adoräpäcamanga’. ");
INSERT INTO qva_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Conträtuta rurar Abrahamta Tayta Diosninchi niran circuncidächicunanpag y olgu wamrancuna yuriptin paycunatapis circuncidänanpag. Chaymi yuringanpita pusag junagtaga Abraham wamran Isaacta circuncidaran. Chaynuyla Isaacpis wamran Jacobta circuncidaran y Jacobpis wamrancunata circuncidaran. Chay chrunca ishcay wamrancunapitam Israel runacuna mirasha. ");
INSERT INTO qva_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Unay castanchi Jacobpa wamrancunam wauguin Josëta chriquipar ranticaycäriran Egiptuman apacärinanpag. Ichanga Tayta Diosninchi manam jaguiriranchu. ");
INSERT INTO qva_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Nacaychru captinpis Tayta Diosninchim salvaran. Imaycachrüpis tantiyachiran Egiptupa reynin faraón ali ricananpag. Paymi Josëta chruraran Egiptuchru y faraonpa palaciunchru runacunata mandananpag. ");
INSERT INTO qva_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Chay wichan Egipto naciunchru y Canaanchrüpis muchruy y fiyupa laquicuy caran. Chay unay castanchicunapa micunanpag imapis mana caranchu. ");
INSERT INTO qva_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Egiptuchru trïgu canganta musyar wamrancunata Jacob cachraran rantimunanpag. Paycunam unay castanchicuna caran. ");
INSERT INTO qva_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ishcaycag cutinchru chrayaptinna wauguincunawan José reguichicuran. Chaynuypis faraón Josëpa aylluncuna canganta musyaran. ");
INSERT INTO qva_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Chaypita taytanta y lapan aylluncunata Egiptuman José gayachimuran. Lapanga caran ganchris chrunca pichga (75) runacuna. ");
INSERT INTO qva_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Chaynuypa Jacob Egiptuman tiyananpag aywaran. Chaychrüna wañuran. Y unay castanchicunapis chaychrüna wañupäcuran. ");
INSERT INTO qva_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Paycunapa ayantana Siquem marcaman apapäcuran. Pampapäcuran Abraham rantingan sepultüraman. Chay sepultürata Abraham guellayninwan rantiran Hamor jutiyog runapa wamranpita. ");
INSERT INTO qva_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Abrahamta Tayta Diosninchi promitingan nagana cumplinanpäna caycaptin Israel runacuna Egiptuchru achcamanna mirasha caycaran. ");
INSERT INTO qva_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Chay wichan juc runana Egiptuchru rey cananpag yaycuran. Chay rey mana reguiranchu José pï cangantapis. ");
INSERT INTO qva_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Israel castanchicunata chay rey sacrilapa wamrancunata yuregcagtaga wañucunanpag jaguirichiran. ");
INSERT INTO qva_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Chay wichan Moisés yuriran. Pay shumag cuyaylapag wamram caran. Taytancuna wasilanchru quimsa quilla uywaran. ");
INSERT INTO qva_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Moisesta jitariycuptinna faraonpa jipashnin shuntarcur quiquinpa wamrantanuy uywacuran. ");
INSERT INTO qva_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Chaynuypa Moisesta Egipto runacuna yachrangannuy yachrananpag yachrachipäcuran. Shumag ali rimay yachrag y munayniyog runam pay caran. ");
INSERT INTO qva_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Chruscu chrunca (40) watayog caycarna Israel aylluncunata watucog aywayta Moisés yarparan. ");
INSERT INTO qva_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ichanga juc Egipto runa Israel runata magaycagta ricar favurnin sharcur chay runata wañuriycachiran. ");
INSERT INTO qva_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisés yarparan Israel aylluncunata esclävu canganpita salvananpag Tayta Diosninchi payta acranganta paycuna tantiyacunanta. Ichanga paycuna manam tantiyapäcuranchu. ");
INSERT INTO qva_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Warantin junag Moisés tariran ishcay Israelmasincuna pelyaycagta. Raquiyta y perdunächinacuyta munar paycunata niran: ‘Gamcuna chay ayllula caycarga ¿imanirtag pelyarcanqui?’ ");
INSERT INTO qva_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Chauraga magagcag runaga Moisesta tangarir niran: ‘Gamta ¿pitag nogacunapa mandagnï y jueznï canayquipag chrurashushcanqui? ");
INSERT INTO qva_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Egipto runata ganyan wañuchingayquinuychu nogatapis wañuchimayta munaycanqui?’ ");
INSERT INTO qva_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Chay ninganta mayar gueshpir aywacuran. Madián partiman chrayarna jäpanuy chaychru tiyaran. Majachacuptinna ishcay wamrancuna caran. ");
INSERT INTO qva_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Chruscu chrunca (40) wata pasarcuptinna Sinaí jutiyog chunyag jircapa cercanchru cashayog jachrachru nina ratariycagchru juc angel Moisesta ricariparan. ");
INSERT INTO qva_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Chayta ricar Moisés ima ruraytapis mana camäpacuranchu. Shumag ricananpag ashuycuycaptin Tayta Diosninchi chaypita nimuran: ");
INSERT INTO qva_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Nogam unay castayquicunapa Diosnin cä. Nogam cä Abrahampa, Isaacpa y Jacobpa Diosnin’. Ninganta mayar Moisés manchariypita sicsicyar manana mas ricäriyta munarannachu. ");
INSERT INTO qva_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Chauraga Tayta Diosninchi niran: ‘Garachraquicuy. Caycangayqui pampachrümi noga caycä. ");
INSERT INTO qva_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Egiptuchru Israel runacuna imanuy nacaycangantapis shumagmi ricashcä. Laquicuypita gapararcanganta mayarmi yarpamushcä paycunata chaypita jorgunäpag. Cananga gamta Egiptuman cachrashayqui’. ");
INSERT INTO qva_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Israel runacuna Moisesta ricayta mana munar nipäcuran: ‘¿Pitag nishushcanqui mandagnïcuna y jueznïcuna canayquipag?’ Chaynuy nircaptinpis Tayta Diosninchi cachraran paycunapa mandagnin cananpag y Egiptupita jorgamunanpag. Chayta nichiran jachrachru ricaripangan angilwan. ");
INSERT INTO qva_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moisesmi milagrucunata rurarcur Egipto naciunpita unay Israelmasinchicunata jorgamuran. Chaynuy Puca Lamarchru y chruscu chrunca (40) wata chunyag jircachru caycarpis milagrucunata ruraran. ");
INSERT INTO qva_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Cay quiquin Moisesmi Israelmasinchicunata niran: ‘Gamcunapa aylluyquipitam Tayta Diosninchi noganuy willacognin cananpag chruranga. Gamcunaga payta cäsucäriy’. ");
INSERT INTO qva_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Cay Moisesmi Israel runacunawan chunyag jircachru shuntacasha caran. Paymi unay castanchicunawan y Sinaí jircachru parlangan angilwan caran. Paymi imaypis mana gongacänanpag cag willacuycunata Tayta Diosninchipita chrasquiran noganchita pasamänanchipag. ");
INSERT INTO qva_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ichanga unay castanchicuna Moisesta mana cäsucäriyta munapäcuranchu. Chaypa truquinga Egiptuman cuticuyta munapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Aaronta nipäcuran: ‘Juc dioscunata rurapäpäcamay pusharämänanchipag. Manam musyanchichu Egiptupita jorgamagninchi Moisesta ima pasangantapis’. ");
INSERT INTO qva_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Chay junagcuna juc becerro niragta quiquincuna rurapäcuran. Nircurna uywacunata pishtarcur chay ïdulupa ñaupagninchru rupachipäcuran. Chaypita cushicur ïdulupag fiestata rurapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Chauraga Tayta Diosninchi paycunata jaguiriycuran cieluchru estrëllacunata adoränanpag. Chay caran Diospa willacognincunapa librunchru caynuy escribirangannuy: ‘Israel runacuna, chruscu chrunca (40) wata chunyag jircachru caycar ¿gamcuna nogapag uywacunata pishtarcur rupachipäcushcanquichu? ");
INSERT INTO qva_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Chaypa truquinga Moloc jutiyog diospa carpanta y Refán jutiyog diospa estrëllanta apapäcurayqui. Chay ïdulucunata quiquiquicunam rurapäcurayqui adoräpäcunayquipag. Chaynuy rurapäcungayquipitam Babilonia naciunpita mas caruman gargushayqui’. ");
INSERT INTO qva_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Chunyag jircachru unay castanchicunapa tabernäculo jutiyog jatun carpan caran. Chay carpachru caran Israel runacunawan Tayta Diosninchi rurangan conträto. Chay carpa rurasha caran Moisesta Tayta Diosninchi imanuypis rurapäcunanpag ricachingannuyla. ");
INSERT INTO qva_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Chay tabernäculuta unay castanchicuna taytancunapita chrasquipäcuran. Paycuna Josuëwan mana Israel runacunapa marcancunaman yaycur chayta apapäcog. Chaychru tiyag runacunatanam paycuna tiyananpag Tayta Diosninchi garguran. Chaychrüna tabernäculupis caran rey David cawanan wichancama. ");
INSERT INTO qva_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Davidta Tayta Diosninchi ali ricaran. Chaymi Jacob adorangan Tayta Diosninpag templuta sharcachinanpag David mañacuran. ");
INSERT INTO qva_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ichanga Salomonrämi chay templuta Tayta Diospag sharcachiran. ");
INSERT INTO qva_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Chaynuy captinpis pï maypitapis mas munayniyog Tayta Diosninchi manam tiyanchu runa rurangan templuchrüga. Chay unay willacognin Tayta Diosninchi ninganta caynuy niran: ");
INSERT INTO qva_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Cieloga mandar jamaräcunämi. Cay pachaga chraquï jaruräcunanmi. ¿Imanuy wasitarag nogapag sharcachipäcunqui? ¿Mayninrag jamacunäpag cag parti canga? ");
INSERT INTO qva_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Noga quiquïmi cay lapanta camashcä’ ”. ");
INSERT INTO qva_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Chaynuy nircurpis Esteban niran: “Gamcunaga imaypis mana mayacogmi carcanqui. Tayta Diospa contran runacuna, paypa willacuyninta mana mayagnuymi carcanqui. Mayaycarpis manam chrasquicärinquichu. Santu Espiritupa contran imaypis carcanqui. Unay castayquicunanuylam gamcunaga carcanqui. ");
INSERT INTO qva_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Unay castayquicuna Tayta Diospa lapan willacognincunata rabyapäpäcuran. Paycunam wañuchipäcuran alilata ruragcag shamunanpag canganta willacogcunatapis. Chay alilata ruragcag sharamuptinna gamcuna entregäpäcushcanqui wañuchisha cananpag. ");
INSERT INTO qva_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","¡Gamcunaga leycunata manam cäsucärishcanquichu, angilcunawan gamcunaman apachimusha caycaptinpis!” ");
INSERT INTO qva_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Esteban ninganta mayarmi chaychru cagcuna pasaypa rabyacäriran. Rabyapita quiruncunatapis cachrupäcuran. ");
INSERT INTO qva_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Santu Espiritupa munayninchru caycar Esteban cieluta ricärir chipipaycagta Tayta Diosta ricaran. Chaynuypis derëchacag lädunchru Jesús mandananpag ichriraycagta ricaran. ");
INSERT INTO qva_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Chauraga niran: “¡Cielo quichraraycagta y Tayta Diospa derëchacag lädunchru Diospita shamusha Runa ichriraycagta ricaycä!” ");
INSERT INTO qva_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Chauraga paycuna fiyupa gaparir rinrincunata chapacuycur Estebanman cörricaycäriran. ");
INSERT INTO qva_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Chaypitana marcapita jorgupäcuran sagmananpag. Estebanpa contran rimasha cagcuna payta sagmananpag quiquincunapa janancag röpancunata jorgurir Saulo jutiyog runata paytacäriran. Nircurna Estebanta sagmapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Runacuna sagmarcaptinmi Jesusta Esteban caynuy rugacuran: “Señor Jesús, munayniquimanna almäta shuntayculay”. ");
INSERT INTO qva_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Nircurna gongurpacuycur fiyupa niran: “¡Señor, sagmaycämanganpita cay runacunata perdunayculay!” Chaynuy niycur wañuran. ");
INSERT INTO qva_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulupis chaychru caycaran “Alim wañurcächinqui” nir. Chay junagpita pachanam Jerusalenchru yäracog shuntacagcunata runacuna pasaypa rabyapäpäcuran. Chaymi Jerusalenpita Jesusman yäracogcuna Judea y Samaria provinciacunaman lapan aywacäriran. Apostulcunam ichanga mana aywacäriranchu. ");
INSERT INTO qva_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Y Estebanpa cuerpuntana Tayta Diosninchita adorag waquin runacuna laquicuypita wagar pampag apapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulo yäracog shuntacagcunata fiyupa rabyapar wasin wasin yaycurir warmitapis olgutapis garashchraypa jorgamog carcilman apachinanpag. ");
INSERT INTO qva_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ichanga Jerusalenpita aywacogcuna may chaymanpis chrayangan tupu Jesuspa ali willacuyninta willacäreg. ");
INSERT INTO qva_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipe caran paycunapita jucnincag. Pay aywacuran Samaria provinciachru cag juc marcaman. Chaychrüna Tayta Dios cachramungan Salvadurpita willacuran. ");
INSERT INTO qva_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Felipe rimangantam mayapäcuran y milagrucuna rurangantapis ricapäcuran. Chaychrümi willacungancunatapis lapan shumag mayapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Chaynuypis achcagpitam fiyupa gaparir diablucuna yargur aywacuran. Chaynuypa pulan cuerpun wañushacuna y wegrucuna sänu quëdapäcuran. Chay milagrucunata ruraran payta Dios rasunpa cachramunganta musyacänanpag. ");
INSERT INTO qva_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Chaynuy rurasha captinmi chay marcachru tiyagcuna cushicäriran. ");
INSERT INTO qva_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Chay marcachrümi caran juc runa Simón jutiyog. Unaypita pacham chay runa brujeriata rurag. Chaynuy car imatapis ruraptinmi Samaria runacuna paypita almirasha caran. Chaynuypa chay runa yachrag canganta ricachicuran. ");
INSERT INTO qva_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Payta lapanmi tacshapis jatunpis shumag mayag. Paycuna nipäcog: “Cay runaga Tayta Diospita shamusha car Tayta Diosnuy munayniyog”. ");
INSERT INTO qva_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Lapanpis payta shumag mayag brüju cayninwan achca wata paycunata almirasha charanganpita. ");
INSERT INTO qva_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ichanga Felipe Tayta Diospa munayninpita y Jesús Tayta Dios cachramungan Salvador canganpita willapanganta chrasquicurna olgupis warmipis bautizacäriran. ");
INSERT INTO qva_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Quiquin Simonpis criyiran. Bautizacurirna Felipiwan puriran. Felipe milagrucunata ruragta ricar almirasha gatiraran. ");
INSERT INTO qva_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Chaypita Jerusalenchru caycag apostulcuna mayapäcuran Tayta Diosninchipa willacuyninta Samaria provinciachru runacuna chrasquicäringanta. Chaymi Juantawan Pedruta cachrapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Chrayaycurna chay chrasquicogcunapag Tayta Diosninchita rugacäriran paycunapis Santu Espirituta chrasquipäcunanpag. ");
INSERT INTO qva_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Paycunaman mayganmanpis manarämi Santu Espíritu yarpamuranrächu. Bautizacärisha casha Señor Jesuspa jutilanchrürämi. ");
INSERT INTO qva_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Juanwan Pedro paycunapa umanman maquinta chruraycur Tayta Diosninchita rugacuptinmi paycuna Santu Espirituta chrasquipäcuran. ");
INSERT INTO qva_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Chay chrasquicogcunapa umanman apostulcuna maquinta chruraycur Tayta Diosninchita rugacuptin Santu Espíritu shamogta ricarmi apostulcunata Simón guellayta goyta munaran. ");
INSERT INTO qva_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Niran: “Nogatapis chay munayniquita gomay pipa umanmanpis maquïta chruraycur rugacuptï Santu Espirituta chrasquicunanpag”. ");
INSERT INTO qva_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Chauraga Pedro niran: “¡Gam guellaynintiqui castïguman gaycusham canqui imata ruranayquipäpis chrurashunayquipag Tayta Diosninchipa munayninta guellayniquiwan rantiyta yarpangayquipita! ");
INSERT INTO qva_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Gam Tayta Diosninchi munangannuychu mana yarpaycanqui. Chaymi nogacuna rurangänuy gam mana ruranquimanchu. ");
INSERT INTO qva_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Chay mana alita yarpaycangayquipa truquinga Tayta Diosninchita rugacuy pagta chay mana ali yarpayniquipita perdunäshunquimanpis. ");
INSERT INTO qva_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Noga ricä envidioso captiqui castigasha canayquipag canganta. Chaynuypis gamta ricä mana ali ruraylata rurayman atipacuycagta”. ");
INSERT INTO qva_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simón niran: “Chauraga nogapag Tayta Diosta rugacäriy chay yarpangäcunapita nipäcamangayquinuy imatapis mana ruramänanpag”. ");
INSERT INTO qva_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Señor Jesús cawarimushana caycagta ricapäcunganpita willacarcärirna y paypa ali willacuyninta willacarcärirna aywapäcuran Samaria provinciachru waquin marcacunamanpis willacärinanpag. Chaypitanam cuticäriran Jerusalenman. ");
INSERT INTO qva_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Chaypita Tayta Diosninchipa angilnin Felipita niran: “Sharcuy. Nircur ayway Jerusalenpita Gaza marcaman yarpog camiñupa”. (Chay camiñoga chunyagmi caycan.) ");
INSERT INTO qva_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Chauraga Felipe sharcurcur aywaran. Aywaycanganchrüna camiñuchru Etiopía nacion runawan tincuran. Pay capasha runam caran. Pay caran Etiopiachru reinapa tesorërunmi. Pay Jerusalenman Tayta Diosninchita adorag aywasha casha. ");
INSERT INTO qva_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Chaypitana naciunninman cuticuycaran cärrunchru jamasha Diospa willacognin Isaías escribingan libruta liyiraycar. ");
INSERT INTO qva_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Felipita Santu Espíritu niran: “Ayway y ashuycuy chay cärruman”. ");
INSERT INTO qva_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Felipe cörriypa ashuycur chay Etiopía runa Diospa willacognin Isaías escribingan libruta liyiycagta mayaran. Chauraga tapuran: “¿Chay liyiycangayquita gam tantiyanquichu?” ");
INSERT INTO qva_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Etiopía runa niran: “¿Imanuypatag tantiyashag pipis mana tantiyaycächimaptinga?” Nircurna cärrunman jegarcur lädunman jamacunanpag Felipita niran. ");
INSERT INTO qva_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Tayta Diosninchi escribichinganchru liyiycangan caynuymi niran: “Wañuchinanpag üshata apangannuymi payga apasha caran. Millwanta rutuptin üsha mana gaparaypa cangannuymi payga upälala caran. ");
INSERT INTO qva_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Pengayman chrurasha caran. Quiquin munangannuy rurapäcuran. Paypa wamralanpis manam canchu cay pachachru cawananpag caycagta wañuchipäcusha captin”. ");
INSERT INTO qva_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Chay Etiopía runa Felipita tapuran: “Niycalämay, ¿pipätag niycan caychru cay willacog? ¿Quiquinpächu o jucpächu?” ");
INSERT INTO qva_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Chaymi Felipe chay Etiopía runa liyiycangan Jesucristupag escribiraycanganta tantiyachiran. Chaypita Jesucristupa ali willacuyninta willaparan. ");
INSERT INTO qva_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Chaypita aywarcanganchru yacu canganman chrayaycur chay Etiopía runa niran: “Caychru yacu caycan. ¿Noga imanirtag mana bautizacümanchu?” ");
INSERT INTO qva_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Chauraga Felipe niran: “Lapan shonguyquipa Jesucristuman criyiptiquega au bautizacunquimanmi”. Chay runa niran: “Criyïmi Jesucristo Tayta Diospa Wamran canganta”. ");
INSERT INTO qva_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Chauraga cärruta ichrichinanpag niran. Nircurna yacu cangancagman Etiopía runawan Felipe yarpupäcuran. Chaychrüna Felipe bautizaran. ");
INSERT INTO qva_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Yacu canganpita jegarcämuptinna Felipita Tayta Diospa Santu Espiritun mayänipita apacuran. Chauraga chay Etiopía runa manana ricarannachu. Mana ricarpis chay runa pasaypa cushisha aywacuran. ");
INSERT INTO qva_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipe Azoto jutiyog marcachru ricacaran. Chaypitana marcan marcan Jesucristupa ali willacuyninta willacuycar puriran Cesarea marcaman chrayangancama. ");
INSERT INTO qva_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Chaycamaga Saulo Jesucristuman yäracogcunata wañuchinanpag juracuycar cüracunapa mas mandagninman aywaran. ");
INSERT INTO qva_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Paypitana ordincunata jorgamuran Damasco marcachru shuntacänan wasicunaman chrayananpag. Chaychru Jesucristo yachrachingannuy cawagcunata tarirga warmitapis olgutapis Jerusalenman prësu apananpag. ");
INSERT INTO qva_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ichanga Damascuman aywar chrayaycaptinna mayänipita achqui cielupita Sauluman chilapyämuran. ");
INSERT INTO qva_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Chauraga Saulo pampaman rataran. Chaychrünam caynuy nimogta mayaran: “Saulo, Saulo, ¿imanirtag nogata rabyapämanqui?” ");
INSERT INTO qva_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saulo tapuran: “¿Pitag caycanqui, tayta?” Chauraga nimuran: “Rabyapaycämangayqui Jesusmi noga cä. Quiquiquim mana alita ruracuycanqui picata töru saytar nanächicungannuypis”. ");
INSERT INTO qva_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Saulo mancharisha sicsicyaycar niran: “¿Imata ruranätatag munanqui, tayta?” Jesús niran: “Sharcuy y marcaman yaycuy. Chaychrünam imata ruranayquipäpis nishunqui”. ");
INSERT INTO qva_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Gayacamunganta mayarpis Sauluwan aywagcuna pitapis manam ricapäcuranchu. Pitapis mana ricarmi ima niytapis mana camäpacäriranchu. ");
INSERT INTO qva_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulo pampachru jitaraycanganpita sharcurcur ricachracuringanchrüga imatapis mana ricaranchu. Chauraga maquipita janchraypa Damasco marcaman pushapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Chaychru quimsa junag gaprayasha caran. Chaynuypis quimsa junag micüni y upüni caran. ");
INSERT INTO qva_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damascuchrümi tiyaran Jesucristuman yäracog Ananías jutiyog runa. Paytam Señor Jesucristo ricariparcur niran: “¡Ananías!” Pay niran: “Caychru caycä, Señor”. ");
INSERT INTO qva_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Señor Jesucristo niran: “Sharcuy y ayway ‘Derëcha’ jutiyog cälliman. Judaspa wasinchru tapucunqui Tarso marcapita Saulo jutiyog runapag. Chaychrümi Tayta Diosta pay rugacuycan. ");
INSERT INTO qva_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Rugacaycämanganchrümi ricasha Ananías jutiyog runa yaycuycur umanman maquinta chruraycur ñawin yapay ricananpag Tayta Diosta rugacuycagta”. ");
INSERT INTO qva_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananías niran: “Señor, chay runa imanuy cangantapis y Jerusalenchru gamman yäracogcunata mana alita rurangancunapita achcagmi willapäpäcamasha. ");
INSERT INTO qva_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Caymanpis shamusha cüracunapa mandagnincunapa ordinninwanmi gamta adoragcagcunataga lapanta prësu apananpag”. ");
INSERT INTO qva_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ichanga Señor Jesucristo niran: “Ayway, chay runata nogam acrashcä mana Israel runacunata, reycunata y Israel runacunata nogapa willacuynïta willapänanpag. ");
INSERT INTO qva_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Paytam noga musyachishag noga janan fiyupa nacananpag canganta”. ");
INSERT INTO qva_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananías aywaran Saulo caycangan wasiman. Yaycurirna Saulupa umanman maquinta chruraycur niran: “Waugui Saulo, aywaycämuptiqui ricaripäshogniqui Señor Jesusmi cachramasha ñawiqui yapayna ricananpag y Santu Espiritupa munayninchrüna canayquipag”. ");
INSERT INTO qva_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Chay höra ñawinpita pescädupa escämannuy shicwaran. Y ñawin yapayna ricaran. Sharcuruptinna bautizasha caran. ");
INSERT INTO qva_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Chaypita micuptinna callpancunapis chrayamuran. Damascuchru tiyag Jesucristuman yäracogcunawan ishcay quimsa junag goyaranrag. ");
INSERT INTO qva_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Chaypitanam Jesucristo Tayta Diospa Wamran canganta shuntacänan wasicunachru Saulo willacuran. ");
INSERT INTO qva_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Chaymi lapan mayagcunaga almirasha caynuy nipäcuran: “¿Manachu Jerusalenchru Jesusta adoragcunata cay runaga fiyupa chriquipag? ¿Manachu pay quiquin caymanpis shamusha Jesusta adoragcunata prësu charircur cüracunapa mandagnincunaman apananpag?” ");
INSERT INTO qva_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ichanga Saulo mana manchacuypa shumagna tantiyachiran Jesús Tayta Dios cachramungan Salvador canganta. Chaymi Damascuchru tiyag Israel runacuna yachrachinganta mayar ima yarpaytapis mana camäpacäriranchu. ");
INSERT INTO qva_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Chaypita tiempo pasarcuptinna Israel runacuna rimanacäriran Sauluta wañuchinanpag. ");
INSERT INTO qva_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ichanga chayta Saulo musyaran. Wañuchipäcunanpag pagas junag marca yarguna puertachru shuwaräpäcuran. ");
INSERT INTO qva_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Chayta musyaycurmi discïpuluncuna Sauluta juc jatun canastaman wiñaycur marca muyureg jatun pergapa pagaspa yarpuchipäcuran gueshpicunanpag. ");
INSERT INTO qva_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulo Jerusalenman chrayaycur Jesucristuman yäracogcunawan shuntacayta munaran. Ichanga lapan payta manchacäriran. Paycuna mana criyipäcuranchu paypis Jesucristuman yäracunganta. ");
INSERT INTO qva_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Chaynuy captinpis Bernabé apostulcunaman Sauluta pusharan. Chaychrüna paycunata willaparan aywaycanganchru Señor Jesucristuta ricanganta y Sauluwan parlanganta. Chaynuypis willaparan Damascuchru mana manchacuypa Jesucristupa willacuyninta Saulo willacunganta. ");
INSERT INTO qva_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Chaynuypa Saulo paycunawan Jerusalenchru puriran. Pay pitapis mana manchacuypa Señor Jesucristupita willacuran. ");
INSERT INTO qva_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Griego rimayta parlag Israel runacunawanpis fiyupa parlapäcog. Ichanga cay runacuna imanuypapis wañuchiyta ashipäcuran. ");
INSERT INTO qva_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Chaynuy caycanganta musyarmi wauguicuna Cesarea marcaman Sauluta pushapäcuran. Chaypitana Tarso marcaman despachäpäcuran. ");
INSERT INTO qva_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Chaypitanam yäracog shuntacagcuna Judea, Galilea y Samaria provinciacunachru jaucana y Tayta Dios munangannuyna mas cawapäcuran. Chay runacuna Señor Jesucristuta manchapacuypa cawapäcuran. Y Santu Espíritu yanapaptinna mas achcayäpäcuran. ");
INSERT INTO qva_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pedro wauguicunata panicunata watucur puriycanganchrümi Lida marcachru Jesucristuman yäracogcunamanpis yarpuran. ");
INSERT INTO qva_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Chaychrümi tariran Eneas jutiyog runata. Paymi intëru cuerpun wañushanuy captin pusag wata cämalanchru jitararan. ");
INSERT INTO qva_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Chauraga Pedro niran: “Eneas, Jesucristum cuticaycächishunqui. ¡Sharcuy! ¡Cämayquita shuntay!” Chauraga jucla sänuna sharcuran. ");
INSERT INTO qva_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Lida marcachru y Sarón partichru achcag tiyagcuna sänuna caycagta ricar Jesucristuman yäracäriran. ");
INSERT INTO qva_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Chay wichanmi Jesucristuman yäracog Tabita jutiyog warmi Jope marcachru tiyaran. Griego rimaychrüga Tabita ninan Dorcas ninanmi. Cay warmi imatapis alita rurar y pishïpacogcunata yanapar cawag. ");
INSERT INTO qva_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Chay junagcuna Dorcas gueshyaran y wañuran. Wañuruptin armarcachir wasipa altucag pïsunchru cuartuman ayanta apapäcuran chutananpag. ");
INSERT INTO qva_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jope marcapita Lida marcaman cercala caycaran. Jesucristuman yäracogcuna chaychru Pedro caycanganta musyar ishcay runacunata cachrapäcuran caynuy ninanpag: “Jucla apurädu aywashun”. ");
INSERT INTO qva_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Chauraga Pedro paycunawan aywaran. Chrayaycuptinmi pushapäcuran Dorcas chutaraycangan cuartuman. Chaychrümi Dorcas yanapangan viudacuna wagar Pedruman ashuycapäcuran. Nircurnam Dorcas cawaycar-rag rurapangan rurincag y janancag röpancunata ricachipäcuran. ");
INSERT INTO qva_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Chauraga Pedro chaychru caycagcunata puncuman lapanta jorgariycamur gongurpacuycur Tayta Diosninchita rugacuran. Nircurna wañusha caycagman muyurcur niran: “¡Tabita, sharcuy!” Chauraga ricachracariycamuran. Pedruta ricarna tiyarcuran. ");
INSERT INTO qva_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedro maquinpita charircur ichrircachiran. Chaypita Jesusman yäracogcunata y viudacunata gayarcur Dorcas cawaycagtana ricachiran. ");
INSERT INTO qva_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Dorcasta Pedro cawarichimunganta intëru Jope marcachru musyapäcuran. Chaynuypa Señor Jesucristuman achcag yäracäriran. ");
INSERT INTO qva_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pedro chay marcachru achca junagmi goyaran. Pachararan suela rurag Simonpa wasinchru. ");
INSERT INTO qva_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Cesarea marcachrümi tiyaran juc runa Cornelio jutiyog. Pay “Italiano” jutiyog batallunchru jucnincag capitanmi caran. ");
INSERT INTO qva_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Pay Tayta Dios munangannuy cawag. Chaynuypis wasinchru tiyagcunawan Tayta Diosta manchapacäreg. Pay pishïpacog Israelcunata achca guellaywan yanapag y Tayta Diosninchita imaypis rugacog. ");
INSERT INTO qva_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Juc cutinchru mallway intinuy caycaptin Corneliuta Tayta Diosninchipa angilnin ricariparan. Chay ricaripaptinmi angilta Cornelio shumag ricaran. Paycagman yaycuycur caynuy niran: “¡Cornelio!” ");
INSERT INTO qva_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cornelio angilta ricaraycar y pasaypa mancharisha tapuran: “¿Imatag, tayta?” nir. Niptinmi angel niran: “Tayta Diosninchi mayashushcanquim rugacungayquita. Pobricunata yanapangayquitapis ricasham. ");
INSERT INTO qva_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Jope marcaman Simón jutiyog runata pushamunanpag ishcay quimsa runacunata cachray. Paypa jucag jutinmi Pedro. ");
INSERT INTO qva_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Pay pacharaycan juc runa Simón jutiyog suela ruragpa wasinchrümi. Paypa wasin caycan lamar cantunchrümi”. ");
INSERT INTO qva_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Parlangan angel aywacuruptinna Cornelio gayaran wasinchru ishcay uywaynincunata y Tayta Diosninchi munangannuy cawag soldäduta. Chay soldädu waquin soldäducunapitapis Cornelio munangantam rurag. ");
INSERT INTO qva_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Paycunata angel lapan ningancunata willaparcur Jope marcaman cachraran. ");
INSERT INTO qva_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Warantinna pulan junagnuy caycaptin Cornelio cachrangan runacuna Jope marcaman cercaycaptin pacharangan wasipa jananman Pedro jegaran Tayta Diosninchita rugacunanpag. ");
INSERT INTO qva_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pedro pasaypa micanaycaran. Ichanga micuyta yanucungancama ");
INSERT INTO qva_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","cielo quichracaycagta ricaran. Chaypita jatuncaray jacunuy chruscun puntanpita warcuypa pachaman yarpaycämogta ricaran. ");
INSERT INTO qva_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Chay jacuchrümi chruscun chraquinpa pureg tucuy nirag uywacuna, lashtaypa puregcuna y päregcunapis caycaran. ");
INSERT INTO qva_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Chaychrümi mayaran caynuy nimogta: “Pedro, sharcuy. Pishtarcur micuy”. ");
INSERT INTO qva_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Chauraga Pedro niran: “Manam, Tayta. Manam imaypis micushcächu mana micunapag cag uywacunataga”. ");
INSERT INTO qva_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Yapay nimuran: “Tayta Dios ali micunapag ningantaga ama mana micunapag niychu”. ");
INSERT INTO qva_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Chaynuy quimsa cuti caran. Chaypitanam cieluman jucla chay jacunuy cutichisha caran. ");
INSERT INTO qva_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pedro chay lapan ricangancuna imapag cananpag cangantapis yarpachracuycaptin maychru Simonpa wasin cangantapis tapucuylapa Cornelio cachrangan runacuna wasi puncuman chrayapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Chaychrünam tapucäriran Simón jutiyog Pedro nipäcungan runa chaychru pacharanganta o mana pacharangantapis. ");
INSERT INTO qva_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Chay ricanganpita Pedro yarpachracuycaptinrämi Santu Espíritu niran: “Quimsa runacuna ashiycäshunqui. ");
INSERT INTO qva_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Sharcuy, yarpuy y mana yarpachracuypa paycunawan ayway. Nogam paycunata cachramushcä”. ");
INSERT INTO qva_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pedro yarpurcur chay runacunata niran: “Nogam caycä chay ashircangayqui runa. ¿Imapätag ashircämanqui?” ");
INSERT INTO qva_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Paycuna niran: “Aywarcämü Capitan Cornelio cachrapäcamasha captinmi. Payga Tayta Dios munangannuy rurag y Tayta Diosta manchapacog runam. Paytaga Israel runacuna alipämi rican. Tayta Diosninchipa angilnin gamta paypa wasinman pushashunayquipämi nisha. Chaychrüna gam ninayquipag cagta niptiqui mayapäcushunquipag”. ");
INSERT INTO qva_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Chauraga Pedro yaycachiran chay wasiman. Chaychrüna paycunapis pachacäriran. Warantinna Pedro paycunawan aywaran. Aywaptinnam Jopipita waquin wauguicunapis paywan aywaran. ");
INSERT INTO qva_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Warantinna Cesarea marcaman chrayapäcuran. Chaychru Cornelio paycunata shuntachimungan aylluncunawan y cuyanacungancunawan shuwararan. ");
INSERT INTO qva_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pedro wasinman chrayaptinna Cornelio yargamuran chrasquicunanpag. Nircur ñaupagninman gongurpacuycur adoraran. ");
INSERT INTO qva_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ichanga Pedro caynuy nir Corneliuta sharcachiran: “¡Sharcuy! Nogapis gamnuy runalam cä”. ");
INSERT INTO qva_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Chaypitanam parlaraycar yaycapäcur tariran achca runacuna shuntacasha carcagta. ");
INSERT INTO qva_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Chauraga Pedro niran: “Gamcuna musyanquim Israel runacuna mana Israel runacunawanga mana shuntacänanpag ni wasinmanpis mana yaycunanpag leynïcunachru ninganta. Chaynuy captinpis Tayta Diosmi tantiyachimasha mana Israel runacunamanpis chrayanäpag y paycunawanpis gotucänäpag. ");
INSERT INTO qva_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Chaymi gayachimaptiqui jucla mana tapupaypa shamushcä. Canan willapäcamay imapag gayachipäcamangayquitapis”. ");
INSERT INTO qva_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelio niran: “Chruscu junagnam pasasha cay mallway höranuy cay wasichru Tayta Diosninchita rugacuycaptï chipipaycag röpasha runa ñaupagnïchru ricaripämangan. ");
INSERT INTO qva_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Chaychrümi nimaran: ‘¡Cornelio! Tayta Diosninchi mayasham rugacungayquita. Chaynuypis ricasham pobre runacunata yanapangayquita. ");
INSERT INTO qva_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Cachracuy Jope marcaman Pedro nipäcungan Simonta pushamunanpag. Pay pacharaycan suela rurag Simonpa wasinchrümi. Chay wasin caycan lamar cantunchrümi’. ");
INSERT INTO qva_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Chaymi jucla cachramushcä pushamushunayquipag. Chauraga gam shalämushcanqui. Cananga caychru lapäcuna carcä y Tayta Diospis caychrümi caycan. Nogacunata nipäcamänayquipag Señor nishungayquita nipäcamay mayapäcunäpag”. ");
INSERT INTO qva_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pedro niran: “Cananga tantiyä Tayta Diosninchi rasunpa pï maytapis jucnuy jucnuy mana ricanganta. ");
INSERT INTO qva_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Chaypa truquinga lapan naciunchru pay munangannuy y payta manchapacuypa cawagcunataga chrasquinmi. ");
INSERT INTO qva_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Tayta Diosninchi Israel runacunaman willacuyta chrayachiran. Chay ali willacuyninta Jesucristuwan willacachiran runacuna paywan jauca cananpag. Jesucristum lapan runacunapa Señurnin. ");
INSERT INTO qva_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Gamcuna musyapäcunquim runa bautizacunanpag canganta Juan willacunganpita pacha Israel runacunapa marcanchru Galileapita galaycur ima pasangantapis. ");
INSERT INTO qva_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Musyapäcunquim Nazaret marcapita Jesús munayniyog cananpag Santu Espirituta Tayta Diosninchi payman chruranganta. Alita rurar y Satanaspa munayninchru caycag runacuna gueshyanganta cuticächir puringanta. Chay lapanta ruraran Tayta Diosninchi paywan captinmi. ");
INSERT INTO qva_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Nogacuna ricapäcushcä Jerusalenchru y Israel runacunapa marcanchru Jesucristo imata rurangantapis. Chaypitanam cruzman clävaycur wañuchipäcuran. ");
INSERT INTO qva_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ichanga quimsa junagtaga Tayta Diosninchi cawarichimuran. Nircurna ricarichimuran nogacuna ricapäcunäpag. ");
INSERT INTO qva_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Lapan runacunachu manam payta ricaran sinöga unayna nogacunata Tayta Diosninchi acrangan runacunalam ricapäcurä ricangäta pitapis willapäpäcunäpag. Wañusha canganpita cawarircamuptin nogacunam paywan micapäcurä upupäcurä. ");
INSERT INTO qva_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Pay nogacunata chruramaran Israel runacunata willapäpäcunäpag cawaycagcunatapis wañushacunatapis juzgananpag payta Tayta Diosninchi chruranganta. ");
INSERT INTO qva_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Tayta Diospa lapan willacognincuna Jesuspita willacäriranna. Paycuna nipäcuran pipis payman yäracogcäga juchancunapita perdunasha cananpag Jesucristo wañunanpag canganta”. ");
INSERT INTO qva_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pedro chaynuy parlaycaptinrämi chaychru willacunganta mayarpaycag runacunaman Santu Espíritu lapanman chrayaran. ");
INSERT INTO qva_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Pedruwan aywag Israel casta yäracogcuna almirasha quëdapäcuran mana Israel runacunatapis Santu Espirituta gosha captin. ");
INSERT INTO qva_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Paycunatapis mayapäcuran mana yachrangan idiomacunachru rimarcagta y Tayta Diosninchita alabarcagta. ");
INSERT INTO qva_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Chaymi Pedro niran: “Noganchinuy paycunapis Santu Espirituta chrasquisha caycaptinga ¿imanirtag paycunapis yacuwan mana bautizashachu canman?” ");
INSERT INTO qva_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Nircurna niran Jesucristupa jutinchru bautizasha capäcunanpag. Chaypitanam Pedruta rugapäcuran ishcay quimsa junaglapis paycunawan goyänanpärag. ");
INSERT INTO qva_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Apostulcuna y Judeachru caycag wauguicunapis panicunapis musyapäcuran mana Israel runacunapis Tayta Diosninchipa willacuyninta chrasquicäringanta. ");
INSERT INTO qva_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ichanga Jerusalenman cutiycuptin Israel casta yäracogcuna Pedruta ");
INSERT INTO qva_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","tapupäcuran: “¿Imanirtag mana Israel runacunapa wasinman yaycushcanqui? Chaynuypis ¿imanirtag paycunawan micushcanqui?” nir. ");
INSERT INTO qva_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Nipäcuptinmi galaycunanpita pacha imanuy cangantapis Pedro willaparan: ");
INSERT INTO qva_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Jope marcachru caycar Tayta Diosninchita rugacuycangächrümi cielupita juc jatuncaray jacunuy chruscun puntanpita warcuypa nogacagman yarpaycämogta ricarä. ");
INSERT INTO qva_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Shumag ricaycunäpäga caycänag chruscun chraquinpa pureg uywacuna, chucaru uywacuna, lashtaypa puregcuna y päregcunapis. ");
INSERT INTO qva_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Y mayarä caynuy nimogta: ‘Pedro, sharcuy. Pishtarcur micuy’. ");
INSERT INTO qva_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Noga nirä: ‘Manam, Tayta. Manam imaypis micushcächu mana micunapag cag uywacunataga’. ");
INSERT INTO qva_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Cielupita yapay nimaran: ‘Tayta Dios ali micunapag ningantaga ama mana micunapag niychu’. ");
INSERT INTO qva_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Chaynuy quimsa cuti caran. Chaypitana cieluman lapanta cutichisha caran. ");
INSERT INTO qva_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Chay höram Cesarea marcapita quimsa runacuna nogata ashimar carcangä wasiman chrayapäcamuran. ");
INSERT INTO qva_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Santu Espiritum nimaran mana manchacuypa paycunawan aywanäpag. Cay sogta wauguicunapis nogawanmi aywaran. Lapämi chay runapa wasinman yaycapäcurä. ");
INSERT INTO qva_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Chaychrümi willapäpäcamaran wasinchru juc angel ichriraycagta ricanganta. Chay angel niran: ‘Cachracuy Jope marcaman Pedro nipäcungan Simonta pushamunanpag. ");
INSERT INTO qva_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Paymi nishunqui gam y lapan wasiquichru tiyagcunawan imanuypa salvacärinayquipäpis’. ");
INSERT INTO qva_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Willapayta galaycuptïna noganchiman chrayamungannuyla paycunamanpis Santu Espíritu chrayaran. ");
INSERT INTO qva_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Chaychrümi noga yarparä Señor Jesucristo caynuy ninganta: ‘Juan Bautistaga yacuwanmi bautizaran. Gamcunam ichanga Santu Espirituwan bautizasha capäcunqui’. ");
INSERT INTO qva_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Chauraga Tayta Diosninchi paycunatapis noganchitanuyla Señor Jesucristuman yäracunganchipita Santu Espirituta goycaptinga ¿pitag cä noga Tayta Diosninchita amachänäpag?” ");
INSERT INTO qva_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Chaynuy niruptinnam Jerusalenchru yäracogcuna upälacäriran. Nircurnam Tayta Diosninchita alabäpäcuran: “¡Cananga Tayta Diosninchi mana Israel runacunatapis nisha juchancunapita wanacuptinga mana ushacaypa cawayman chrayananpag!” ");
INSERT INTO qva_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Estebanta wañuruptinnam Jesucristuman yäracogcunata rabyapaptin mashtacar waquincuna gueshpicäriran Fenicia partiman, Chipre partiman y Antioquía marcaman. Chaychrünam Israel runacunalata Jesucristupa ali willacuyninta willaparan. ");
INSERT INTO qva_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ichanga Chipripita y Cirene marcapita Jesucristuman waquin yäracogcuna Antioquiaman chrayar mana Israel runacunatapis Señor Jesuspa ali willacuyninta willaparan. ");
INSERT INTO qva_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Chaynuy willapänanpag Tayta Diosninchim yanaparan. Chaynuypam unay criyingancagcunata jaguiriycur Señor Jesucristumanna achcag yäracäriran. ");
INSERT INTO qva_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Chaynuy pasangancuna Jerusalenchru yäracog shuntacagcunaman willapa chrayaptinmi Antioquiaman Bernabëta cachrapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Chrayarna yäracogcunata Tayta Diosninchi yanapaycagta ricar Bernabé cushicuran y lapan shongunpa Señor Jesucristuman yäracur imaypis cawananpag lapanta shacyächiran. ");
INSERT INTO qva_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bernabé ali runam caran. Pay Santu Espiritupa munayninchrümi y Jesucristumanmi shumag yäracog caran. Chaynuypa Jesucristuman yäracogcunaman achcag yapacaran. ");
INSERT INTO qva_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Chaypitam Bernabé Tarso marcaman aywaran Sauluta ashimunanpag. ");
INSERT INTO qva_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Tariycurna Antioquiaman pushamuran. Chaychrünam juc wata yäracog shuntacagcunawan caycar achcag runacunata yachrachiran. Chaychrürämi runacuna Jesucristuman yäracogcunata “Cristiano” nir jutipäpäcuran. ");
INSERT INTO qva_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Chay wichancunam Jerusalenpita Tayta Diospa willacognincuna Antioquiaman aywapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Chaychrümi paycunapita jucnincag ichrircur Agabo jutiyog runa Santu Espíritu rimachiptin niran intëru pachachru muchruy cananpag canganta. Chay muchruyga Claudio emperador Romachru caycaptinmi caran. ");
INSERT INTO qva_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Chauraga Antioquiachru Jesucristuman yäracogcuna rimanacäriran cangan tupu shuntarcärir Judea provinciachru tiyag wauguicunaman panicunaman apachipäcunanpag. ");
INSERT INTO qva_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Chaynuy rurarcärirna Bernabëwan Saulo Judea provinciachru mayor wauguicunata entregänanpag apapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Chay wichancuna rey Herodes Jesucristuman waquin yäracogcunata charichiran magachinanpag. ");
INSERT INTO qva_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Chaychrümi apóstol Juanpa wauguin Santiaguta espädawan wañuchichiran. ");
INSERT INTO qva_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Chaynuy rurapäcungan Israel runacunapag ali canganta ricarmi Pedrutapis charichiran. Chayta ruraran levadüraynag tantata micuna fiesta junagcunam. ");
INSERT INTO qva_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Prësu charircachirna carcilman Pedruta wichrgachiran. Chaychrünam chrunca sogta (16) soldäducunata chruraran chruscuman cama raquicaycur cuydananpag. Yarparan Pascua fiesta ushayrag lapan runacunapa ñaupagninman apachimunanpag. ");
INSERT INTO qva_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Soldäducunana carcilman Pedruta wichrgarcärirna täparcaran. Ichanga yäracog shuntacagcuna paypag Tayta Diosninchita lapan shongunpa rugacurcaran. ");
INSERT INTO qva_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Warantinna Herodes lapan runapa ñaupagninman jorgamunan caran. Carcilchru Pedro puñuycaran ishcan maquinpita cadinasha ishcay soldäducunapa chraupinchru. Waquin soldäducunanam carcel puncuta täparcaran. ");
INSERT INTO qva_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Chaymanmi mayänipita Tayta Diosninchipa angilnin chrayaran. Chrayaruptinmi carcel achicyacäcuran. Angilna jucag lädunchru Pedruta yataycur riccharcachir niran: “¡Jucla sharcuy!” Chay höra Pedrupa maquincuna cadinawan wataraycag cachracäcuran. ");
INSERT INTO qva_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Angel niran: “¡Wachrcacuy! ¡Nircur jucla llanquiquita jaticuy!” Ningannuyla Pedro ruraran. Angel niran: “¡Janancag röpayquita jaticurcur guepaläpa shamuy!” ");
INSERT INTO qva_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pedro yarguran angilpa guepalanpa. Manam tantiyaranchu angel rasunpa ruraycanganta. Sinöga yarparan suyñuycangalanta. ");
INSERT INTO qva_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Pasapäcuran puntacag soldäducunata y guepancag soldäducunata. Cälliman yarguna fierro puertaman chrayaräriptinna quiquilanpita puerta quichracäcuran. Yargurcur cällipa aywarcaptinna angel mayänipita illacäcuran. ");
INSERT INTO qva_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Pedro cällichru rasunpa caycanganta tantiyacurirna niran: “Cananmi si rasunpa musyä Tayta Dios nogaman angilninta Herodispa munayninpita y nacanäpag caycagta Israel runacuna shuwararcanganpita salvamänanpag cachramunganta”. ");
INSERT INTO qva_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Cay lapanpita tantiyacurirna Pedro aywaran Juanpa maman Mariapa wasinman. Juanpa jucag jutinmi caran Marcos. Chaychrümi achca shuntacaycur Pedrupag Tayta Diosninchita rugacurcaran. ");
INSERT INTO qva_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Chrayaycur puncuta Pedro tucacuran. Chauraga uyway Rode jutiyog jipash pï cangantapis ricananpag yargamuran. ");
INSERT INTO qva_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pedrupa rimacuyninta reguiycurmi pasaypa cushicur puertata quichrananpa truquinga ruriman cörriran Pedro puncuchru caycanganta willananpag. ");
INSERT INTO qva_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Willaptinmi nipäcuran: “¡Löcayaycanquichri!” Nipäcuptinpis pay rasunpa canganta niran. Paycuna nipäcuran: “Angilninmi canman”. ");
INSERT INTO qva_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Chaycamaga Pedro yaparir yaparir puertata tucacuran. Puertata quichrarir pay canganta ricaycur manchacäpäcuran. ");
INSERT INTO qva_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ichanga Pedro maquinwan sëñasyaran upälacärinanpag. Nircur willaparan Tayta Diosninchi imanuypa carcilpita jorgamungantapis. Nircur niran: “Cay pasamanganpita willapay Santiaguta y waquin wauguicunata panicunata”. Chaypita yargurirna juc lädupa aywacuran. ");
INSERT INTO qva_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Pacha wararcuptinnam soldäducuna ima ruraytapis mana camäpacäriranchu Pedruta ima pasangantapis mana tantiyar. ");
INSERT INTO qva_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodes niran maychrüpis tarimunanpag. Mana taripäcuptinnam shumag tapucurir Pedruta täpag soldäducunata jitaparan. Nircurna niran chay soldäducunata wañuchinanpag. Chaypitana Herodes Judea provinciapita Cesarea marcaman aywacuran chaychru tiyananpag. ");
INSERT INTO qva_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodes fiyupa rabyasha caycaran Tiro y Sidón marca runacunawan. Chaymi chay runacuna rimanacäriran jauca cawapäcunanpag Herodisman parlag aywapäcunanpag. Ichanga manaräpis aywapäcur Herodispa yanapagnin Blastuwan amistäta rurapäcuran. Payna Herodiswan parlaran Tiro y Sidón runacunawan jauca cawapäcunanpag. Chaynuy rurapäcuran Tiro y Sidón runacuna Herodes cangan partipita micuyta apapäcuptinmi. ");
INSERT INTO qva_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Chauraga Herodes jitaparan juc junagchrürag paycunawan parlananpag. Chay parlanan junagmi jaticuran achca runacunapa ñaupagninchru canancag röpanta. Nircurnam mandananpag jamacunanman jamaycur niran. ");
INSERT INTO qva_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ninganta mayaycurmi runacuna gaparir nipäcuran: “¡Cay rimaycämog runaga manam runalachu! ¡Payga Diosmi!” ");
INSERT INTO qva_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Chay höra Tayta Diosninchipa angilnin fiyupa gueshyachiran Herodista Tayta Diosta mana respitar apäringanpita. Chaypitam Herodes curu ushaypa wañuran. ");
INSERT INTO qva_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ichanga Tayta Diosninchipa willacuyninta may chaychrüpis willacäriptin Jesucristuman yäracogcuna canganpitaga masna achcayaran. ");
INSERT INTO qva_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bernabëwan Saulo Jerusalenchru lapan rurananpag cagta usharcurna Antioquiaman cutipäcuran Marcos jutiyog Juanta pushacurcur. ");
INSERT INTO qva_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioquiachru yäracog shuntacagcunachrümi caran Diospa willacognincuna y yachrachegcunapis. Paycuna caran Bernabé, “Yana Runa” nipäcungan Simón, Cirenipita Lucio, Manaén y Saulo. Manaén wiñasha caran mandag Herodiswan iwal. ");
INSERT INTO qva_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Juc cutinchru Tayta Diosninchita alabarcaptinmi y ayunarcaptinmi Santu Espíritu niran: “Bernabëtawan Sauluta chrurapämay noga munangäta rurapämänanpag”. ");
INSERT INTO qva_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Chauraga Tayta Diosninchita rugacarcärir y ayunarcärir jananman maquinta chruraycur Tayta Diosninchita rugacäriran. Nircurnam paycunata despachäpäcuran. ");
INSERT INTO qva_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Santu Espíritu cachraptinna Bernabëwan Saulo Seleucia marcaman aywaran. Chaypitana büquiwan Chipre islaman aywapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Salamina marcachru büquicuna ichricunanman chrayaycurnam Israel runacunapa shuntacänan wasicunachru Tayta Diosninchipa ali willacuyninta willacäriran. Juanpis yanapänanpag paycunawanmi caycaran. ");
INSERT INTO qva_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Intëru Chipre jutiyog islapa pasarna chrayapäcuran Pafos marcaman. Chaychrümi Israel castapita Barjesús jutiyog brüjuta taripäcuran. Tayta Diospa willacognintucog caran. ");
INSERT INTO qva_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Cay brüju Chipre islachru mandagnin Sergio Paulupa yanapagnin caran. Cay mandag shumag yachrag caran. Paypis Tayta Diospa ali willacuyninta mayayta munarmi Bernabëtawan Sauluta gayachimuran. ");
INSERT INTO qva_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Chay brüjuta griego rimaychrüga “Elimas” nipäcog. Cay brüjum Bernabëpawan Saulupa contran sharcur Jesucristupa yachrachicuyninta Sergio Paulo chrasquinan caycaptin amacharan. ");
INSERT INTO qva_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Saulupa jucag jutin caran Pablo. Paymi Santu Espiritupa munayninchru car chay brüjuta ricärir ");
INSERT INTO qva_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","niran: “¡Casqui, lutancunata rurag, Satanás munanganta rurag! ¡Ali ruraycunapa contran! Gam Tayta Diospa yachrachicuyninta mana aliman chruraycanqui. ¡Chayta amana ruraychu! ");
INSERT INTO qva_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Cananga Tayta Diosninchi castigäshunqui. Gapram ricacunqui. Juc tiempucama achicyag intita mana ricanquichu”. Chay höraman Elimas pasaypa yananyagchru ricacuran. Jinalanchru muyunyacachraycar ashiran maquipita janchraypa pilapis pushananpag. ");
INSERT INTO qva_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gaprayanganta ricarmi Sergio Paulo chay ali willacuyman criyiran. Almirasha quëdaran Jesucristupa ali willacuyninpita. ");
INSERT INTO qva_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pafos marcapita büquiwan yanapagnincunawan Pablo Panfilia provinciachru caycag Perge marcaman aywapäcuran. Ichanga Juan chaychru jaguiycur Jerusalenman cuticuran. ");
INSERT INTO qva_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pergepitana Pisidia provinciapa cercanchru Antioquía marcaman aywapäcuran. Chaychrünam sábado jamay junag shuntacäpäcunan wasiman yaycuycur jamacäriran. ");
INSERT INTO qva_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Moisés escribingan leycunata y Tayta Diospa willacognincuna escribinganta chaychru liyircuptinna chay shuntacänan wasichru mandagcuna Pablutawan Bernabëta jucwan nichiran: “Israel masïcuna, cay runacuna shacyäcunanpag imalatapis ninayquipag captinga jucla nimuy”. ");
INSERT INTO qva_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Chauraga Pablo ichrircur upälacärinanpag maquinwan sëñasyaran. Nircur niran: “Israel runacuna y Tayta Diosninchi manchapacog mana Israel runacuna, mayapäcamay. ");
INSERT INTO qva_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel runacunapa Diosninmi unay Israel runacunata acraran. Paycunatam Egipto naciunchru jäpanuy tiyarcaptin jatun nacion cangancama mirachiran. Nircurnam munayniyog cayninwan chay naciunpita jorgamuran. ");
INSERT INTO qva_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Paycunatam Tayta Diosninchi imanuy captinpis chunyag jircachru chruscu chrunca (40) watanuy cuydaran. ");
INSERT INTO qva_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Chaynuypis Canaán partinchru caycag ganchris naciuncunata illacächiran paycunata goycunanpag. ");
INSERT INTO qva_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Israel castacuna Egiptuman chrayanganpita Canaán partinchru marcacunata chrasquinanpag chrayangancama chruscu pachrac pichga chrunca (450) watanuy caran. “Chaypitanam jueznincunata Tayta Diosninchi chruraparan asta willacog Samuelcama. ");
INSERT INTO qva_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Chaypitana rugacäriran juc reypa munayninchrüna capäcunanpag. Chauraga Cispa wamran Saulta chruscu chrunca wata (40) reynin cananpag Tayta Diosninchi chruraparan. Cis caran Benjaminpa castanpitam. ");
INSERT INTO qva_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Chaypitanam Saulta rey caycanganpita jorguriycur Davidtana rey cananpag chruraran. Davidpämi Tayta Diosninchi niran: ‘Noga munangänuytam Isaïpa wamran Davidta tarishcä. Pay noga munangänuymi imatapis ruraycan’. ");
INSERT INTO qva_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Cay Davidpa miragninpita jucnincag yuregmi Jesús caran. Paytam Tayta Diosninchi promitingannuyla Israel runacunata salvananpag cachramuran. ");
INSERT INTO qva_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jesús manarag willacuyta galaycuptinmi Juan Bautista Israel runacunata willaparan juchancunapita wanacärinanpag y bautizacärinanpag. ");
INSERT INTO qva_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Juan nagana aruyninta ushaycarna niran: ‘Manam gamcuna yarpäpäcungayquinuychu noga caycä. Ichanga nogapa guepäta jucmi aywaycämun. Nogaga paypa sandalialantapis pascapänäpag manam alichu cä’. ");
INSERT INTO qva_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Abrahampita mirag Israel masïcuna y Tayta Diosninchita manchapacog mana Israel runacuna: salvacunapag ali willacuy noganchipämi caycan. ");
INSERT INTO qva_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalenchru tiyagcuna y autoridänincunapis manam Jesús Salvador canganta musyapäcuranchu. Chaynuypis Tayta Diospa willacognincuna escribinganta manam tantiyapäcuranchu cada sábado jamay junagchru shuntacänan wasicunachru liyiptinpis. Chaynuy mana tantiyarmi willacogcuna escribingannuyla Jesús wañuchisha cananpag nipäcuran. ");
INSERT INTO qva_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Wañuchisha cananpag paypa ima juchantapis mana tariycarmi Pilätuta nipäcuran wañuchisha cananpag. ");
INSERT INTO qva_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Chaypita pay imanuypis cananpag escribirangannuyla cumplipäcuptin cruzpita jorgurcur pampapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ichanga wañunganpita Tayta Diosninchi cawarichimuran. ");
INSERT INTO qva_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Galileapita Jerusalenman aywaptin yanagagnincunata Jesús achca cutim ricariparan. Cananga paycunam Jesús cawarimushata ricapäcunganpita Israel runacunata willaparcan. ");
INSERT INTO qva_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Chaymi nogacuna gamcunata cay ali willacuyta willapaycä: Unay castanchicunata Tayta Diosninchi promitingantam ");
INSERT INTO qva_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","paycunapita mirag captinchi noganchichrüna cumplisha Jesusta Salvador cananpag chrurar. Cayta rurasha ishcaycag Salmuchru caynuy escribiraycangannuymi: ‘Gam Wamrämi caycanqui. Canan noga Taytayqui cangäta nishcä’. ");
INSERT INTO qva_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Jesucristuta wañunganpita cawarircachimur yapay mana wañunanpag canganta Tayta Diosninchi niran: ‘Gamcunatam Davidta promitingä bendiciuncunata goshayqui’ nir. ");
INSERT INTO qva_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Chaypita juc Salmuchrüpis niycan: ‘Cuyayniqui captïmi cuerpü ismunanta pamparangalächrüga manam jaguirinquichu’. ");
INSERT INTO qva_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Rasunpaga cawanan wichan David Tayta Diosninchi mandanganta ruraran. Wañuruptinna espiritun taytan cangancagman aywaran. Cuerpunna pamparangalanchru ismur ushacaran. ");
INSERT INTO qva_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Tayta Diosninchi cawarichimungan Jesuspam ichanga cuerpun mana ismuranchu. ");
INSERT INTO qva_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Israel masïcuna, musyapäcunayqui: Nogam musyaycächï Jesús juchayquicunapita perdunäpäcushunayquipag canganta. ");
INSERT INTO qva_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Moisés escribingan leycunachru mana perdunasha cag juchayquicunatam cananga payman yäracurga perdunasha canquipag. ");
INSERT INTO qva_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Cuydädu Tayta Diospa willacognincuna caynuy escribingan gamcunaman chrayaramunman. Chay escribingan caynuymi niycan: ");
INSERT INTO qva_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘¡Gamcuna jamurpäcogcuna! Mancharipäcunquim y illacäpäcunquim. Cawanayqui wichan imata ruranäpag cagta pipis willapäshuptiquipis gamcuna pasaypa manam criyipäcunquichu’ ”. ");
INSERT INTO qva_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pablo y Bernabé chay shuntacänan wasipita yargarcämuptinna rugapäcuran jucag sabadupis yapay willapänanpag. ");
INSERT INTO qva_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Shuntacäpäcungan ushacaruptinna Pabluwan Bernabé aywacuptin Israel runacuna y Israelcunanuy cananpag yaycog runacunapis paycunata gaticurcur aywapäcuran. Chaychrümi paycunata shacyächiran Tayta Diosninchi cuyapanganta imaypis mana gongapäcunanpag. ");
INSERT INTO qva_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Chaypita jucnincag sábado jamay junagpis runacuna lapan marca yupay Tayta Diospa willacuyninta mayapäcunanpag shuntacaran. ");
INSERT INTO qva_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Chaynuy achcag shuntacanganta ricaycur Israel runacuna envidiacur Pablo ninganpa contran nipäcuran. Chaynuypis Pabluta ashlipäcuran. ");
INSERT INTO qva_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Chauraga Pabluwan Bernabé mana manchacuypa nipäcuran: “Puntata gamcuna Israel runacunatarämi Tayta Diospa willacuyninta willapänä caran. Gamcuna mana chrasquiyta munapäcuptiquega y mana ushacaypa cawayta mana munapäcuptiquega aywacärishag mana Israel runacunamanmi. ");
INSERT INTO qva_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tayta Diosninchi chaynuy rurapäcunäpag cachrapäcamarmi caynuy nimasha: ‘Mana Israel runacunapag achquinuy canayquipämi gamta chrurashcä. Gammi may chaymanpis ali willacuyta apanqui runacuna salvacärinanpag’ ”. ");
INSERT INTO qva_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Chaynuy parlanganta mayarmi mana Israel runacuna cushicur nipäcuran Tayta Diospa willacuynin shumag ali canganta. Chaynuypam mana ushacaypa cawayman chrayananpag Tayta Diosninchi acrangancagcuna paypa willacuyninta criyipäcuran. ");
INSERT INTO qva_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Chaynuypam Tayta Diospa willacuynin chay partipa willacusha caran. ");
INSERT INTO qva_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ichanga Israel runacuna parlaran Tayta Diosta manchapacog y alipag ricasha warmicunawan y chay marcachru cag alipag ricasha runacunawan. Paycunata shimita goran Pabluta y Bernabëta rabyapäpäcunanpag. Chaypitana chay partipita gargapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Chauraga paycuna chay marcachru Israel runacuna Tayta Diosninchipa ali willacuyninta mana chrasquipäcunganpita pay castigänanpag canganta tantiyacärinanpag chraquinchru lagacasha allpatapis tapshipäcuran. Chaypitana Iconio marcaman aywacäriran. ");
INSERT INTO qva_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ichanga Jesucristuman yäracogcunaga cushisha y Santu Espiritupa munayninchru capäcuran. ");
INSERT INTO qva_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Antioquiachru pasangannuy Iconiuchrüpis pasaran. Pabluwan Bernabé Israel runacuna shuntacäpäcunan wasiman yaycuycur willapaptinmi achcag Israel runacuna y mana Israel runacunapis criyipäcuran. ");
INSERT INTO qva_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ichanga Jesucristuman mana yäracog Israel runacuna mana Israel runacunata shimita goran yäracogcagcunapag lutanta yarpäpäcunanpag. ");
INSERT INTO qva_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Chaychrümi apostulcuna achca tiempurag goyaran. Tayta Diosninchiman yäracur pitapis mana manchacuypa pay cuyapanganta willaparan. Chay willacäringan rasunpa canganta runacuna musyananpämi Bernabëta y Pabluta milagrucunata rurananpag Tayta Diosninchi munayninta goran. ");
INSERT INTO qva_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ichanga chay marcachru runacuna ishcayman raquicasha carcaran. Waquinna Israel runacunapa favurnin y waquinna apostulcunapa favurnin. ");
INSERT INTO qva_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Chauraga contrancag Israel runacuna y mana Israel runacuna autoridäcunawan rimanacäriran apostulcunata magapäcunanpag y sagmapäcunanpag. ");
INSERT INTO qva_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ichanga Pabluwan Bernabé chayta musyaycur Listraman, Derbiman y muyuregnin marcacunaman gueshpicäriran. Chay marcacuna caran Licaonia distrïtuchru. ");
INSERT INTO qva_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Chay marcacunachrüna Jesucristupa ali willacuyninta willacäriran. ");
INSERT INTO qva_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra marcachrümi mana puriyta puedeg runa caran. Chay runa yuringanpita pacha wegru car imaypis manam puriranchu. ");
INSERT INTO qva_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Chay runam Pablo parlanganta mayaparaycar tiyaraycaran. Pablo ricäringanchru ricar cuticänanpag canganman yäracuycanganta tantiyaran. ");
INSERT INTO qva_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Chaymi fiyupa niran: “¡Sharcuy y derëchu ichrircuy!” Chauraga saltar puriyta galaycuran. ");
INSERT INTO qva_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pablo chaynuy ruranganta ricaycurmi runacuna Licaonia rimaychru gaparir nipäcuran: “¡Dioscunam runatucular noganchiman yarpamusha!” ");
INSERT INTO qva_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bernabëpag nipäcuran Zeus jutiyog dios canganta. Y Pablupäna willacog captin Hermes jutiyog dios canganta nipäcuran. ");
INSERT INTO qva_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Marca yaycunachru Zeusta adoränanpag wasichru cüram törucunata y millwapita rurasha walgacunata puncuman apamuran. Chay cüram y runacunam Bernabëtawan Pabluta adorayta munar paycunapag chay törucunata pishtayta munapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ichanga Pabluwan Bernabé chaynuy rurananpag caycagta tantiyacurirga röpanta rachririycäriran. Nircur runacunapa chraupinman caynuy gaparaycar yaycacaycäriran: ");
INSERT INTO qva_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“¡Taytacuna! ¿Imanirtag chaynuy rurarcanqui? Nogacunapis gamcunanuy runalam capäcü. Nogacuna gamcunata ali willapata willaparcä manacag dioscunata jaguiriycur cawaycag Tayta Diosta adoräpäcunayquipämi. Paymi cieluta, cay pachata, lamarta y chaychru lapancagcunata camaran. ");
INSERT INTO qva_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Unay wichanmi lapan mana Israel runacunata imanuy cawacunanpäpis Tayta Diosninchi cachrapariran. ");
INSERT INTO qva_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Imaypis alilata rurasha pay pï cangantapis musyapäcunayquipag. Paymi tamyachimun y cosëchata gopäcushunqui ali micusha y cushisha cawapäcunayquipag”. ");
INSERT INTO qva_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Chaynuy nirpis sasatam tantiyachipäcuran paycunata mana adoränanpag y törucunata mana pishtananpag. ");
INSERT INTO qva_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Chayman Antioquiapita y Iconiupita Israel runacuna chrayaycur runacunata shimita goran. Chauraga rumiwan Pabluta sagmapäcuran. Wañusha canganta yarpar garashchraypa marcapita jorgurir jitariycäriran. ");
INSERT INTO qva_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ichanga jitarangancagman Jesusman yäracogcuna shuntacaruptin Pablo sharcamuran. Nircurna yapay chay marcaman yaycuran. Warantinna Derbe marcapa Bernabëwan aywacäriran. ");
INSERT INTO qva_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Jesucristupa ali willacuyninta Derbe marcachru willacäriran. Chaychru achcagta Jesucristuman yäracunanpag yachrachipäcuran. Nircurna Listraman, Iconiuman y Pisidiachru cag Antioquiaman cutipäcuran. ");
INSERT INTO qva_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Chay marcacunachru Jesucristuman yäracogcunata shacyächiran Jesucristupa yachrachicuynincunata shumag y mana yamacaypa criyipäcunanpag. Chaynuypis nipäcuran Tayta Diospa munayninman chrayanapag nacachisharag canapag canganta. ");
INSERT INTO qva_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Chaynuypis cada marcachru yäracog shuntacagcunaman mayor wauguicunata chrurapäcuran. Nircurna ayunar Tayta Diosninchita rugacurir Jesucristuman yäracogcunata lapanta yäracungan Jesucristupa maquinman cuydananpag chruraran. ");
INSERT INTO qva_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pisidia provinciapa pasarna Panfilia provinciaman chrayaran. ");
INSERT INTO qva_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Perge marcachru Jesucristupa willacuyninta willacurirna Atalia marcaman aywapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Chaypitanam Antioquiaman büquiwan cuticäriran. Chaychrümi ali willacuyta willacur purinanpag Bernabëwan Pablo Tayta Diosninchipa maquinman cuydananpag chrurasha caran. Chay willacur purinanpag chrurangantanam paycuna ushapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Antioquía marcaman chrayarnam yäracog shuntacagcunata shuntaycur willaparan Tayta Diosninchi paycunawan imata rurangantapis. Chaynuypis willaparan mana Israel runacagcunapis yäracärinanpag Jesucristupa ali willacuyninta willapänanpag Tayta Diosninchi yanapanganta. ");
INSERT INTO qva_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pabluwan Bernabé Jesucristuman yäracogcunawan achca quillam chaychru goyäpäcuran. ");
INSERT INTO qva_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Chay wichan Judea provinciapita Antioquiaman waquin wauguicuna aywaran. Chaychrüna wauguicunata panicunata yachrachiyta galaycäriran: “Moisés ningan costumbrinuy mana circuncidacurga manam salvacärinquichu” niran. ");
INSERT INTO qva_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pabluwan Bernabé chay yachrachegcunawan fiyupa rabyachinacäriran. Chaypitana Pabluta Bernabëta y mas waquincunata acrapäcuran Jerusalenman aywaycur apostulcunawan y mayor wauguicunawan chay janan parlag aywapäcunanpag. ");
INSERT INTO qva_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Chauraga Antioquiachru yäracog shuntacagcuna paycunata cachraptin Fenicia Samaria particunapa pasar willaparan mana Israel runacunapis unay costumbrinta Tayta Diosninchiman yäracärinanpag jaguiringanta. Chayta mayar achcag wauguicuna panicuna cushicäriran. ");
INSERT INTO qva_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pabluwan Bernabé Jerusalenman chrayaruptinnam chaychru yäracog shuntacagcuna, apostulcuna y mayor wauguicuna chrasquicäriran. Chaychrünam Pabluwan Bernabé willapäpäcuran Tayta Diosninchi paycunawan imata rurangantapis. ");
INSERT INTO qva_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ichanga Jesucristuman criyisha fariseucunapita waquincuna nipäcuran: “Jesucristuman yäracog mana Israel runacunaga circuncidächicunmanrag. Chaynuypis Moisés escribingan leycunata cumplipäcunanpag mandapäcunquimanrag”. ");
INSERT INTO qva_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Chauraga apostulcuna y mayor wauguicuna chaypita parlapäcunanpag shuntacaran. ");
INSERT INTO qva_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Chaychru may rätu rimanacarcäriptinmi Pedro ichrircur niran: “Wauguicuna, gamcuna musyapäcunquim ali willacuyta mana Israel runacunata willapänäpag y chaynuypa Jesucristuman yäracunanpag puntatana gamcunapita Tayta Dios acramanganta. ");
INSERT INTO qva_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Runa imata yarpangantapis musyag Tayta Dios paycunatapis chrasquiycanganta musyachiran noganchitanuyla Santu Espirituta paycunatapis goyninpam. ");
INSERT INTO qva_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Tayta Diosninchega paycunatapis ni noganchitapis manam juc niragtachu ricamanchi. Paycunatapis Jesucristuman yäracuptinmi juchancunata perdunasha. ");
INSERT INTO qva_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Chauraga ¿Imanirtag Tayta Diosta apärir Jesucristuman yäracogcunata mana rurayta puedinganta rurachiyta munarcanqui? Chaytaga unay castanchicunapis noganchipis manam cumpliyta puedishcanchichu. ");
INSERT INTO qva_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Chaypa truquinga noganchi musyanchi Señor Jesús cuyapämashpanchi paycunatanuy noganchitapis salvamanganchita”. ");
INSERT INTO qva_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Chauraga lapan upälacaycäriran. Chaynam Bernabëwan Pablo mana Israel runacuna ricaycaptin Tayta Diosninchi paycunawan milagrucunata rurachinganta willaparan. ");
INSERT INTO qva_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Willapayta usharcuptinna Santiago niran: “Wauguicuna, mayapäcamay. ");
INSERT INTO qva_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón willamashcanchi imanuypa puntata mana Israel runacunaman chrayaycur Tayta Diosninchi paycunapita runacunata salvananpag acranganta. ");
INSERT INTO qva_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Caycuna caycan Tayta Diospa willacognincuna ningan caynuy escribirangannuylam: ");
INSERT INTO qva_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘ “Chaypitanam cutimushag Davidpa wasin juchrusha caycagta sharcachinäpag. ");
INSERT INTO qva_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Chaynuypa rurashag waquin runacuna y noga acrangä mana Israel runacunapis nogaman yäracuyta ashipäcunanpag”. ");
INSERT INTO qva_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Chaynuy nin Tayta Diosninchi. Pay unaypita pachanam chaycunata musyachiran’. ");
INSERT INTO qva_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Chaynuy captinga noga nï: Mana Israel runacuna Tayta Diosninchimanna yäracurcaycagcunata imatapis chapata ama chrurapäshunchu. ");
INSERT INTO qva_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ichanga paycunaman cartata apachishun ïdulucunata chrurapangan aychata mana micapäcunanpag, olgupis warmipis jucwan jucwan mana puñucunanpag, jurcacuypa wañusha uywapa aychanta y yawarta mana micapäcunanpag. ");
INSERT INTO qva_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Unaypita pachanam Moisés escribingan leycunapita yachrachinanpag cada marcachru runa caycan. Chayta cada sábado jamay junagcunam shuntacänan wasicunachru liyircan”. ");
INSERT INTO qva_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Chauraga apostulcuna, mayor wauguicuna y yäracog lapan shuntacagcuna rimanacurcanganchru yarpäpäcuran paycunapita maygantapis acraycur Antioquiaman Pabluwan Bernabé cutiptin paywan aywananpag. Acrapäcuran Silastawan Judasta. Judaspa jucag jutin caran Barsabás. Paycunam chaychru wauguicunapita shumag alipag ricasha caran. ");
INSERT INTO qva_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Paycunawanmi caynuy escribisha cartata apachipäcuran: “Nogacuna apostulcuna y mayor wauguicuna wauguiquicuna car Antioquía marcachru Siria y Cilicia partichru cag mana Israel wauguicunapag panicunapag salüdüta apachimü. ");
INSERT INTO qva_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Musyapäcushcämi caypita waquincuna mana cachrarcämuptïpis gamcunaman rabyachishushpayqui lutancunata yarpächipäcushunayquipag aywapäcamunganta. ‘Circuncidacäriy y Moisés escribingan leycunatarag cumplipäcuy’ nipäcushunayquipag. ");
INSERT INTO qva_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Chaymi lapäcuna rimanacäringächru yarpäpäcushcä nogacunapita maygantapis acrayta gamcunacagman cuyanacäringä Bernabëwan Pablo aywamuptin cachrapäcamunäpag. ");
INSERT INTO qva_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Bernabëwan Pablum Señor Jesucristo raycu wañuytapis mana manchapäcuranchu. ");
INSERT INTO qva_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Chaymi gamcunaman Judastawan Silasta cachraycämü. Paycunam gamcunata chaycunapita cangantanuyla willapäcushunqui. ");
INSERT INTO qva_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Santu Espiritupag y nogacunapäpis ali caycan nipäcunäpag cagpita masta rurapäcunayquipag manana nipäcunäpäna. ");
INSERT INTO qva_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ïduluta chrurapangan aychata ama micapäcuychu. Chaynuypis yawarta y jurcacuypa wañusha uywapa aychanta ama micapäcuychu. Chaynuy jucwan jucwan ama puñuychu. Cay lapanta cumplirga alitam rurapäcunquipag. Shumag cawapäcuy”. ");
INSERT INTO qva_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Chaypita despidicurirna Antioquiaman aywapäcuran. Chrayaycurna chaychru wauguicunata panicunata shuntaycur cartata entregaran. ");
INSERT INTO qva_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Chay cartata liyirna cushicäriran chaynuypa paycunata shacyächiptin. ");
INSERT INTO qva_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judaswan Silaspis Tayta Diospa willacognincuna carmi may rätu parlar wauguicunata panicunata anyar shacyächiran. ");
INSERT INTO qva_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Chaychru goyarcäriptinnam wauguicuna panicuna jauca cawapäcunanpag Judastawan Silasta despachäpäcuran cachrapäcamunganman cuticärinanpag. ");
INSERT INTO qva_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Silasmi ichanga paypag ali captin chaychru quëdacuran. ");
INSERT INTO qva_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pabluwan Bernabëpis chaychru quëdacuran. Chaychrüna achcag caycagcunawan Jesucristupa ali willacuyninta yachrachipäcuran y willacäriran. ");
INSERT INTO qva_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Chaychru goyarcärirnam Bernabëta Pablo niran: “Acu, cutishun Jesucristupa ali willacuyninta willapanganchi marcacunachru wauguicunaman panicunaman imanuy carcangantapis watucamunanchipag”. ");
INSERT INTO qva_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabé pushayta munaran Juanta. Paypa jucag jutin caran Marcos. ");
INSERT INTO qva_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Marcos Panfiliachru Pabluta Bernabëtawan jaguiriycur cuticamuran. Chaynuypa ali willacuyta willacäsheg mana aywaranchu. Chaynuy cuticamusha captinmi Pablupäga Marcusta pushay mana alichu caran. ");
INSERT INTO qva_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Chaymi Pabluwan Bernabé fiyupa rabyachinacurir raquicaran. Bernabëna Marcusta pushacurcur Chipriman büquiwan aywacuran. ");
INSERT INTO qva_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pablunam Silasta acraran. Aywapäcunanpänam wauguicunaga panicunaga Tayta Diosninchi cuydananpag rugacäriran. ");
INSERT INTO qva_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Siria y Cilicia particunapa pasarna yäracog shuntacagcunata shacyächiran. ");
INSERT INTO qva_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Chaypitana Derbe y Listra marcacunaman chrayapäcuran. Listra marcachrümi tiyaran Jesucristuman yäracog Timoteo jutiyog runa. Paypa maman caran Jesucristuman yäracog Israel warmi. Taytan ichanga griego runa caran. ");
INSERT INTO qva_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Listrachru y Iconio marcacunachru wauguicuna panicuna Timoteo ali canganpita parlapäcog. ");
INSERT INTO qva_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pablo Timoteuwan aywayta munarmi pusharan Timoteuta. Ichanga manaräpis pushar circuncidacachiranrag chaychru tiyag Israel runacuna mana jamurpänanpag. Chaynuy rurachiran taytan griego runa canganta musyapäcuptinmi. ");
INSERT INTO qva_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Lapan marcacunapa pasarmi Jerusalenchru apostulcuna y mayor wauguicuna carta apachinganchru ningannuyla rurapäcunanpag nipäcuran. ");
INSERT INTO qva_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Chauraga yäracog shuntacagcuna Jesucristupa yachrachicuynincunata masna criyipäcuran. Chaynuypa waranpa waranpa masna achcayäpäcuran. ");
INSERT INTO qva_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Santu Espíritu Asia provinciachru willacärinanta mana munaruptinmi Frigia y Galacia partipa pasacäriran. ");
INSERT INTO qva_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Misia parti tincogman chrayaycärir Bitinia provinciaman aywayta munapäcuran. Ichanga Jesucristupa Espiritun chayman aywananta mana munaranchu. ");
INSERT INTO qva_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Misia partipa pasacärirna yarpupäcuran Troas marcaman. ");
INSERT INTO qva_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Chaychrünam chacaypa suyñuyninchru Pablo ricaran Macedonia provinciapita ichricuycur runa caynuy rugacaycämogta: “Shamuy Macedoniaman yanapaycärimänayquipag”. ");
INSERT INTO qva_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pablo chaynuy rugacuycagta ricaruptin yarpäpäcurä willacuyninta chaychru willacärinäpag Tayta Diosninchi munanganta. Chaymi jucla camaricärirä Macedoniaman aywapäcunäpag. ");
INSERT INTO qva_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Chauraga Troas marcachrüna büquiman jegapäcurä. Nircurna Samotracia islaman derëchu aywapäcurä. Warantinna Neápolis marcaman chrayapäcurä. ");
INSERT INTO qva_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Chaypitana Filipos marcaman chrayapäcurä. Chay marcaga caran Roma runacuna tiyangan marcam. Chay marca caran Macedonia provinciapa puntacag distrïtunchru. Chay marcachrümi nogacuna juc ishcay junagrag goyäpäcurä. ");
INSERT INTO qva_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sábado jamay junag mayu cantunman marcapita yargapäcurä. Nogacuna yarpäpäcurä maynilanchrüpis Israel runacuna shuntacaycur Tayta Diosninchita rugacurcanganta. Chaychrümi warmicuna shuntacasha caycagta taripäcurä. Paycunatam jamacuycur Jesucristupa ali willacuyninta willapäpäcurä. ");
INSERT INTO qva_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Chay warmicunachrümi jucnincagpa jutin caran Lidia. Pay Tiatira marcapita caran. Morädu fïnu tëlacunata ranticog. Pay Tayta Diosninchita adorag. Pablo rimangancunata shumag tantiyananpag Tayta Diosninchim payta yanaparan. Chaypitanam Jesucristuman yäracuran. ");
INSERT INTO qva_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Chaypita wasinchru tiyagcunawan bautizacurirna rugapäcamaran: “Rasunpa Jesucristuman yäracungäta musyaycarnaga shapäcamuy wasïchru pachachinäpag” nir. Chaynuy nirmi imaycanuypapis quëdachipäcamaran. ");
INSERT INTO qva_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Juc cutinchru Tayta Diosta rugacunacagman aywarcangächru diablupa munayninchru caycag jipashwan tincupäcurä. Chay jipash diablupa munayninwan adivinarmi uywacognincunapag achca guellayta gänag. ");
INSERT INTO qva_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Chay jipashmi Pabluta y nogacunata gaparaypa caynuy nir gatiräpäcamaran: “¡Cay runacunaga imaycapäpis munayniyog Dios mandanganta ruragcunam! ¡Paycunam gamcunata willarcäshunqui imanuypa salvacärinayquipag cangantapis!” ");
INSERT INTO qva_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Chaynuy achca junag gatiräpäcamaptinmi Pablo rabyacur jipashchru caycag diabluta niran: “¡Jesucristupa munayninwan gamta nï: Cay jipashpita yarguy!” Chauraga chay höra jipashpita diablo yargur aywacuran. ");
INSERT INTO qva_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ichanga chay jipashpa uywagnincuna guellayta chay jipash mana gänachinan captinna Pablutawan Silasta charipäcuran. Nircurna pläzachru autoridäcuna caycagman apapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Chaychrüna juezcunaman caynuy nir chrayachipäcuran: “Cay runacuna Israel runacuna carmi marca masinchicunata rabyaycächin. ");
INSERT INTO qva_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Yachrarcächin noganchi roma runacuna mana chrasquinanchipag ni rurananchipag cag costumbricunata”. ");
INSERT INTO qva_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Chauraga paycunapa contran chaychru caycag runacunapis sharcapäcuran. Juezcunanam janancag röpancunata jorgurcachir bärawan wiruchiran. ");
INSERT INTO qva_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Fiyupa wirurcachirna carcilman wichrgachiran. Nircurna carcel cuydagta shumag cuydananpag nipäcuran. ");
INSERT INTO qva_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Chaynuy niruptinmi carcel cuydag mas ruricag carcilman apaycur “cepo” ninganman chraquinta amurcachir wichrgaycäriran. ");
INSERT INTO qva_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Pulan pagasmannuyga Pabluwan Silas Tayta Diosninchita rugacurcaran y cantacunata paypag cantarcaran. Chaynuy ruranganta waquincag prësucuna mayapararcaran. ");
INSERT INTO qva_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Chaynuy carcaptinmi fiyupa mayänipita temblur asta carcilpa cimientuncunatapis cuyurichiran. Chay höram carcilpa lapan puertancuna quichracäcuran y lapan prësucuna watarangan cadinacunapis pascacäcuran. ");
INSERT INTO qva_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Carcel cuydag riccharcamur ricärinanpäga carcilpa lapan puertancuna quichrasha caycaran. Chauraga prësucuna gueshpinganta yarpar espädanta jorguran wañuchicunanpag. ");
INSERT INTO qva_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Wañuchicuyta munaptinmi Pablo fiyupa gayacuran: “¡Ama imatapis ruracuychu! ¡Caychrümi lapäcuna caycä!” ");
INSERT INTO qva_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Chauraga carcel cuydag runaga achquita mañacurir cörrila yaycur manchariypita sicsicyaycar Silaspawan Pablupa ñaupagninman gongurpacuycuran. ");
INSERT INTO qva_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Nircurna carcilpita jorgurir tapuran: “Taytacuna, ¿imatatag ruräman salvacunäpag?” ");
INSERT INTO qva_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Paycuna nipäcuran: “Señor Jesusman yäracuy. Yäracurga gam salvasham canqui. Wasiquichru tiyagcunapis yäracärirga salvasham capäcunga”. ");
INSERT INTO qva_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Nircurnam payta y wasinchru cagcunata Jesucristupa ali willacuyninpita willaparan. ");
INSERT INTO qva_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Chay höram chacaypa Pabluta y Silasta däñasha caycagta chay carcel cuydag runa mayllaparan. Nircurna pay y lapan wasinchru tiyagcunapis bautizasha caran. ");
INSERT INTO qva_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Chaypitana wasinman pushaycur micuyta gararan. Pay y lapan wasinchru tiyagcuna cushisha carcaran Tayta Diosninchimanna yäracäringanpita. ");
INSERT INTO qva_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Warantinna juezcuna wardiacunata carcel cuydagman caynuy nir cachraran: “¡Chay runacunata cachrariycamuy!” ");
INSERT INTO qva_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Chaymi carcel cuydag niran Pabluta: “Juezcuna nimasha gamcunata cachrariycunäpäna. Cananga jaucana aywacäriy”. ");
INSERT INTO qva_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ichanga wardiacunata Pablo niran: “Nogacuna Roma runa carcaptïpis runa ricay wirupäcamasha manaräpis shumag nogacunata tapupäcamänan casha. Nircur carcilman wichrgapäcamasha. Cananga ¿pacaypachu cachrariyta munarcäman? ¡Manam! Quiquincunarag shamuchun jorgapäcamänanpag”. ");
INSERT INTO qva_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Chaynuy ninganta wardiacuna willaran juezcunata. Roma runa canganta musyaycur juezcuna mancharipäcuran. ");
INSERT INTO qva_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Chauraga juezcuna aywapäcuran Pablutawan Silasta perdunta mañapäcunanpag. Nircurna carcilpita jorgarcärir rugapäcuran chay marcapita aywacärinanpag. ");
INSERT INTO qva_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Carcilpita yargurcärirna Pabluwan Silas Lidiapa wasinman aywacäriran. Chaychru wauguicunawan panicunawan tincupäcuran. Shacyarcachirna chaypita aywacäriran. ");
INSERT INTO qva_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pabluwan Silas aywarcarna Anfípolis y Apolonia marcacunapa pasapäcuran. Nircurna Tesalonicaman chrayapäcuran. Chaychrümi Israel runacunapa shuntacänan wasi caran. ");
INSERT INTO qva_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pablo imaypis aywachrangannuy shuntacäpäcunan wasiman aywaran. Quimsa semäna cada sábado paycunata Tayta Diosninchi escribichingan ningannuy willaparan. ");
INSERT INTO qva_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Chaychru tantiyachiran Tayta Dios cachramungan Salvador wañunanpärag canganta. Nircur cawarimunanpag canganta. Niran: “Cay willapaycangä quiquin Jesusmi Tayta Dios cachramungan Salvador”. ");
INSERT INTO qva_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Chaymi waquin Israel runacuna Pablo ninganta criyir payman y Silasman aywacäriran. Chaynuypis Tayta Diosninchita adorag achcag mana Israel runacuna y alipag ricasha achcag warmicuna criyir Pabluman y Silasman aywacäriran. ");
INSERT INTO qva_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ichanga Israel runacuna envidiacur cällicunachru puricog fiyu runacunata shuntaran. Chay runacuna mas achca runacunata shuntarcur chay marcachru runacunata rabyanächiran. Chaynuypis Jasonpa wasinman Pablutawan Silasta ashir rabyasha aywapäcuran charircur rimanacuycag runacunaman entregänanpag. ");
INSERT INTO qva_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Chaychru mana tariycärirna Jasontawan waquin wauguicunata autoridäcunaman caynuy gaparpaycar garashchraypa apapäcuran: “¡Cay runacunam intëru munduchru runacunata rabyanächipäcusha! ¡Cananga caymanna aywarärimun runacunata rabyanächipäcunanpag! ");
INSERT INTO qva_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","¡Jasonmi chay runacunata wasinman chrasquisha! ¡Lapan paycuna emperadurpa leynincunata mana cäsucärinchu! ¡Nircan Jesús rey canganta!” ");
INSERT INTO qva_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Chaynuy nipäcuptinmi runacuna y autoridäcuna rabyanäpäcuran. ");
INSERT INTO qva_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ichanga Jasón y waquincunapis garantiata chruraycuptin cachrariycäriran. ");
INSERT INTO qva_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Chacaypana jucla Pablutawan Silasta wauguicuna panicuna Berea marcaman cachrapäcuran. Chrayaycärirnam Israel runacunapa shuntacänan wasiman aywapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Cay marcachru Israel runacunaga mas cuyapäcogmi caran. Manam Tesalónica marcachru Israel runacunanuychu caran. Paycunaga Jesucristupa willacuyninta shumagmi chrasquicäriran. Rasunpa canganta musyapäcunanpag Tayta Diosninchi escribichinganwan waran waran shumag tincuchipäcog. ");
INSERT INTO qva_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Chaymi achcag Israel runacuna Jesucristuman yäracäriran. Mana Israel alipag ricasha warmicunapis y mana Israel runacunapis achcagmi Jesucristuman yäracäriran. ");
INSERT INTO qva_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Tesalonicachru Israel runacuna Berea marcachrüpis Tayta Diosninchipa willacuyninta Pablo willacuycanganta mayar chaymanpis aywaran runacunata rabyanächinanpag. ");
INSERT INTO qva_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Chauraga jucla wauguicuna panicuna Pabluta lamar cantunman jorgupäcuran juc lädupa aywacunanpag. Silaswan Timoteunam Bereachru quëdapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pabluta yanagagcuna aywapäcuran Atenas marcacama. Chaypitana shumag yachrachisha Bereaman cutipäcamuran Silas y Timoteo imanuypapis jucla Pablucagman aywapäcunanpag. ");
INSERT INTO qva_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pablo Atenas marcachru Silasta y Timoteuta shuwaraycarmi achca ïdulucunata chay marcachru caycagta ricar pasaypa laquicuran. ");
INSERT INTO qva_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Chaymi shuntacäpäcunan wasiman aywaycur Israel runacunata y Tayta Diosninchi adorag mana Israel runacunata Jesucristupa willacuyninpita willaparan. Chaynuy pläzachru gotucagcunatapis waran waran willaparan. ");
INSERT INTO qva_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Chaynuy “epicúreo” y “estoico” jutiyog yachrag runacunapis paywan parlapäcuran. Waquinna niran: “Cay yachragtucog ¿Imatarag riman?” Waquinna niran: “Jäpa runapa diosnincunapitanuytag cay runaga willacuycan”. Chaynuy niran Jesucristupa ali willacuyninta Pablo willacuptin y wañushacuna cawarimunanpag cagpita willacuptin. ");
INSERT INTO qva_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Chauraga Areópago jutiyog shuntacänanman Pabluta pushaycur tapupäcuran: “¿Mushog willacuyta willacuycangayquita nogacunata willapäpäcamanquimanchu? ");
INSERT INTO qva_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Gam parlaycanqui imaypis mana musyapäcungäpita. Chay imaninantapis musyaytam munarcä”. ");
INSERT INTO qva_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Atenas runacuna y chaychru tiyag jäpa runacunapis mushog willapa captinga chaylatam mayayta o willapänanta munapäcun.) ");
INSERT INTO qva_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Chaymi Pablo Areópago jutiyog shuntacänanchru paycunapa chraupinpita ichriycur niran: “¡Atenas runacuna! Noga ricashcä gamcuna dioscunata imaypis manchapacog capäcungayquita. ");
INSERT INTO qva_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Diosniquicunata adoracärinayquicagpa ricapacuyta puriycarmi ricashcä juc altarta. Chay altarchrümi ricashcä caynuy escribiraycagta: ‘Cayga mana reguisha diospämi’ negta. Mana reguirpis chay Diostam adorarcanqui. Chay Diospitam noga willapaycä. ");
INSERT INTO qva_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Cay pachata y lapan chaychru cagcunatapis camag Tayta Diosmi cielupäpis y cay pachapäpis munayniyog. Pay manam runa rurangan capillacunachrüchu tiyan. ");
INSERT INTO qva_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Pay manam munanchu pipis imatapis camaripänanta. Chaypa truquinga paymi cawachimanchi, cawananchipag wayrata y imaycatapis gomanchi. ");
INSERT INTO qva_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","“Paymi juc runalapita intëru pachachru tiyananpag lapan casta runata mirachisha. Paymi unayna chrurasha lapan casta runata maychru y chaychru imaypita imaycama tiyananpäpis. ");
INSERT INTO qva_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Tayta Diosninchi chaynuy ruraran runacuna payta ashipäcunanpag. Capaschri imanuypapis ashirga tarinman. Rasunpaga Tayta Diosninchi mayganchipitapis caruchrüchu manam caycan. ");
INSERT INTO qva_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Tayta Diosmi cawachimanchi y purichimanchi. Juc ishcay marcamasiqui ningannuypis: ‘Lapanchipis Tayta Diosninchi camanganpitam canchi’. ");
INSERT INTO qva_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Chauraga Tayta Diosninchi camanganpita caycarga ama yarpäshunchu ïdulucunanuy örupita, guellaypita, rumipita runacuna yarpangannuyla rurangannuy Tayta Diosninchi canganta. ");
INSERT INTO qva_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Unay runacuna mana musyayninpa chaynuy yarpäpäcuptinpis paycunata Tayta Diosninchi manam castigaranchu. Cananmi ichanga lapanta niycan intëruchru may chaychrüpis juchancunapita wanacärinanpag. ");
INSERT INTO qva_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Tayta Diosninchi maynam juc junagta acrasha acrangan runawan lapan runata imanuypis juzgananpag cangannuy juzgachinanpag. Chay runa acrasha canganta lapanta Tayta Diosninchi musyachisha pay wañurcuptin cawarichimuyninpa”. ");
INSERT INTO qva_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Wañunganpita cawarimunganta niptinmi waquin runacunana asiparan y waquinna nipäcuran: “Chaypita yapaychrüpis willapaycärilämanqui”. ");
INSERT INTO qva_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Chauraga paycunata chaychru jaguiriycur Pablo aywacuran. ");
INSERT INTO qva_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ichanga waquincuna paywan puriraycanganchru criyipäcuran. Chay criyegcunachru caran Dionisio jutiyog runa. Pay caran Areopaguchru shuntacag mayor runam. Chaynuypis criyegcunapita chaychru caycaran Dámaris jutiyog warmi y mas juccunapis. ");
INSERT INTO qva_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Chaypitana Atenas marcapita Corinto marcaman Pablo aywacuran. ");
INSERT INTO qva_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Chaychrümi tincuran Israel casta Aquila jutiyog runawan. Pay Ponto jutiyog provinciapita caran. Aquila warmin Priscilawan chayrag Italiapita chrayamusha caycaran. Paycuna chaypita aywacärimusha caycasha emperador Claudio Romapita lapan Israel castacagcunaga aywacunanpag nisha captin. Chayman Pablo watucog aywaran. ");
INSERT INTO qva_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Pablupis paycunanuy toldëra rurayta yachrarmi paycunawan tiyaran toldërata rurar. ");
INSERT INTO qva_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Pablo cada sábado jamay junagchru Israel runacunapa shuntacänan wasiman aywachrag. Chaychrünam Israel runacunata y mana Israel runacunata willapag y tantiyacheg. ");
INSERT INTO qva_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silaswan Timoteo Macedonia provinciapita chrayaruptinnam Pablo lapan aruyninta jaguiriycur Jesucristupa willacuyninta willacuylaman chruracaran. Chaynuypis Israel runacunata tantiyachiran Jesús Tayta Dios cachramungan Salvador canganta. ");
INSERT INTO qva_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ichanga Pablupa contran sharcur ashlipäcuran. Chauraga chaynuy capäcunganpita Tayta Diosninchi castigänanpag canganta tantiyacärinanpag röpanta tapshirir niran: “Quiquiquicunam juchayog capäcunqui Tayta Diosninchi castigäpäcushunayquipag. Chaypita noga manam juchayognachu cä. Cananpitaga mana Israel runacunamannam Jesucristupa willacuyninta willapänäpag aywashag”. ");
INSERT INTO qva_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Chaypita yargur Ticio Justo jutiyog runapa wasinman Pablo aywacuran. Pay Tayta Diosninchi adorag runam caran. Paypa wasin caran chay shuntacänan wasi lädulanchru. ");
INSERT INTO qva_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Chay shuntacänan wasichru mandag Crispo wasinchru lapan tiyagcunawan Señor Jesucristumanna yäracäriran. Corintuchru runacunapis Pablo yachrachinganta mayagcäga Jesucristuman achcag yäracuran. Chay yäracogcuna bautizasha caran. ");
INSERT INTO qva_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Juc chacaymi suyñuyninchru Pabluta Señor Jesucristo niran: “Ama manchacuychu. Nogapa willacuynïta willacuy. Ama upälacuychu. ");
INSERT INTO qva_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Noga gamwanmi imaypis caycä. Imata rurashunayquipag charishuptiquipis imatapis manam rurapäcushunquichu. Cay marcachru achcam nogaman yäracärimänanpag carcan”. ");
INSERT INTO qva_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Chauraga juc wata sogta quillan Corintuchru Pablo quëdaran paycunata Tayta Diosninchipa willacuyninta yachraycächir. ");
INSERT INTO qva_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Galión jutiyog runa Acaya provinciapa mandagnin caycaptin lapan Israel runacuna Pablupa contran sharcapäcuran. Contran sharcurnam Pabluta Galión juzgananpag apapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Galionta nipäcuran: “Cay runaga imanuypapis runacunata yachraycächin ley ninganpitaga jucnuypa Tayta Diosta adoränapag”. ");
INSERT INTO qva_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pablo rimananpag caycaptin Israel runacunata Galión niran: “Lutanta rurasha captinga o pasaypa imatapis mana alita rurasha captinga gamcuna Israel casta nimangayquicunata shumagmi mayäman. ");
INSERT INTO qva_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Yachrachicuyniquicunalapita, juticunalapita y leyniquicunalapita caycaptinga quiquiquicuna arregläpäcuy. Chaycunapitaga noga manam juzgayta munächu”. ");
INSERT INTO qva_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Nircurna chaypita Israel runacunata garguran. ");
INSERT INTO qva_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Chauraga shuntacänan wasichru mandag Sostenista lapan chariycur Galionpa ñaupagninchru magapäcuran. Chaynuy rurapäcuptinpis Galionta manam imapis gocuranchu. ");
INSERT INTO qva_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pablo Corinto marcachru achca junagrämi quëdaran. Chaypitana wauguicunapita panicunapita despidicurir Priscilawan y Aquilawan iwal Cencrea marcaman aywacuran. Chaychrünam agchanta rutuchicuran Tayta Diosninchita promitinganta cumplinanpag. Chaypitanam Priscilawan y Aquilawan Siria provinciaman büquiwan aywapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Éfeso marcaman chrayaycur Priscilatawan Aquilata jaguiriran. Chaychru cangancama shuntacänan wasiman aywaran Israel runacunawan Jesucristupa willacuyninpita willapänanpag. ");
INSERT INTO qva_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Paycuna Pabluta rugapäcuran chaychru goyänanpärag. Ichanga mana munaranchu. ");
INSERT INTO qva_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Sinöga paycunapita caynuy nir despidicuran: “Imaycanuypapis aywanämi Jerusalenman fiesta chrayamunanpag caycagchru canäpag. Tayta Diosninchi munaptinga yapaymi cutimushag”. Nircurna Pablo Éfeso marcapita büquiwan aywacuran. ");
INSERT INTO qva_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Cesarea marcaman chrayaycurna Jerusalenman aywaran chaychru yäracog shuntacagcunata watucunanpag. Chaypitana Antioquía marcaman aywacuran. ");
INSERT INTO qva_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Tiempo pasarcuptinna yapay Galacia y Frigia particunapa marcan marcan Jesucristuman yäracogcunata shacyächinanpag aywaran. ");
INSERT INTO qva_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Chay wichan Éfeso marcaman Israel runa Apolos jutiyog chrayaran. Pay Alejandría marcapita caran. Chaynuypis shumag parlayta y Tayta Diosninchi escribichinganta shumag yachraran. ");
INSERT INTO qva_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Pay Señor Jesucristo yachrachingannuy cawananpag shumag yachrachisha caycaran. Juan Bautista bautizangalanpita yachrarpis cushisha ashac ashacla Jesucristupita shumag yachracheg. ");
INSERT INTO qva_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Shuntacänan wasichru Apolos mana manchacuypa Jesucristupita willacuran. Priscilawan Aquila mayaycur Apolusta wasinman pushaycur Tayta Diosninchipa yachrachicuynincunata shumag tantiyachipäcuran. ");
INSERT INTO qva_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Acaya provinciaman pasayta munaptin chaychru wauguicuna panicuna pasananpag shacyächipäcuran. Chrayaptin chaychru cag yäracogcuna shumag chrasquinanpag cartata rurapäpäcuran. Acayaman chrayaycurna shumag yachrachiran Tayta Diosninchi cuyapanganpita Jesucristuman yäracogcunata. ");
INSERT INTO qva_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Chaychrümi Jesucristuman mana yäracog Israel runacunata lapan mayarcaptin mana manchaypa niran Tayta Diosninchi escribichinganchru ningannuy Jesús Tayta Dios cachramungan Salvador canganta. ");
INSERT INTO qva_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Corintuchru Apolos cangancama altu partipa pasar Pablo chrayaran Éfeso marcaman. Chaychru Jesucristuman yäracuycagtana runacunata tariran. ");
INSERT INTO qva_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Paycunata tapuran: “Gamcuna Jesucristuman yäracurna ¿Santu Espirituta chrasquipäcurayquichu?” Paycuna nipäcuran: “Imaypis manam Santu Espíritu canganta musyapäcushcächu”. ");
INSERT INTO qva_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pablo tapuran: “Chauraga ¿ima bautismutatag chrasquipäcurayqui?” Nipäcuran: “Juan Bautista yachrachingan bautismutam”. ");
INSERT INTO qva_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pablo niran: “Juan Bautistaga runacunata bautizaran juchancunapita wanacurir Dios munangannuy cawananpag. Ichanga niran paypa guepanta shamogcagman yäracärinanpag. Chaynuy niran Jesucristuman yäracärinanpämi”. ");
INSERT INTO qva_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Chayta mayarcur Señor Jesuspa jutinchru bautizacäriran. ");
INSERT INTO qva_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pablo paycunapa umanman maquinta chruraycur Tayta Diosninchita rugacuptin Santu Espíritu paycunaman chrayaran. Mana yachrangan idiomacunachru rimapäcuran y Tayta Diosninchi musyachingancunata willacäriran. ");
INSERT INTO qva_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Paycuna lapan chrunca ishcaynuymi (12) caran. ");
INSERT INTO qva_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pablo quimsa quillana aywachraycaran shuntacänan wasiman. Chaychrümi mana manchacuypa Jesucristupa ali willacuyninta willacuran. Paycunata Tayta Diospa munaynin imanuy canganpita willaparan y tantiyachiran. ");
INSERT INTO qva_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Waquincunaga yachrachingancunata adrede mana criyipäcuranchu. Chaypa truquinga shuntacänan wasichru shuntacasha runacuna mayaycaptin Jesucristupa yachrachicuynincunapa contran rimapäcuran. Chauraga Pablo paycunata jaguiriycur Jesucristuman yäracogcunata Tirano jutiyog runapa localninman pushacuran. Chaychrünam waran waran Jesucristupa willacuyninpita willaparan. ");
INSERT INTO qva_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Chaynuy ruraran ishcay wata. Chaynuypa Asia provinciachru Israel casta y mana Israel castacunapis Señor Jesucristupa willacuyninta achcag mayapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Chaychrünam Tayta Diosninchi milagrucunata Pabluwan ruracheg. ");
INSERT INTO qva_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Pabluman tüpag pañuelucunatapis o mandilcunatapis gueshyagcunaman apapäcuran. Chaywanna gueshyanpita cuticäpäcuran y diablucunapis paycunapita yarguran. ");
INSERT INTO qva_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Waquin Israel runacunapis pureg diablucunata runapita garguycar. Paycunapis Señor Jesuspa jutinchru garguyta munar diablucunata nipäcuran: “Pablo willacungan Jesucristupa jutinchru cay runapita yarguy”. ");
INSERT INTO qva_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Chaynuy rurapäcog Esceva jutiyog Israel runapa ganchris wamrancunam. Escevaga caran cüracunapa mandagninmi. ");
INSERT INTO qva_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Juc cutichru diablo paycunata niran: “Noga reguïmi Jesusta. Y musyämi Pablo pï cangantapis. Gamcunaga ¿pitag carcanqui?” ");
INSERT INTO qva_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Chaynuy nirmi diabluwan caycag runa löcutar Escevapa wamrancunaman cörricuycuran. Fiyupa fuerzanwan lapanta fiyupa magaran. Yawaryaycar garapachrala gueshpir chay wasipita aywacäriran. ");
INSERT INTO qva_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Efesuchru tiyag runacunachru Israel casta y mana Israel castacunapis lapanmi musyapäcuran. Chaypita lapanmi mancharipäcuran. Chay pasaptin Señor Jesusta mas alipag ricapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Chaynuypis Jesucristuman yäracushana cagcuna achcag chrayapäcamuran lapan mayaycaptin brujeriacuna ruranganta willacuycar. ");
INSERT INTO qva_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Brujeria ruragcunapis achcag brujeria ruracunan libruncunata shuntarcur lapan ricararcaptin rupachipäcuran. Ayca cuestangantapis yupaptin chay librucuna cuestaran pichga chrunca waranga (50,000) yurag guellay. ");
INSERT INTO qva_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Chaynuypa Jesucristupa willacuyninta may chaychrüpis willacurcaran y payman yäracogcuna masna achcayarcaran. ");
INSERT INTO qva_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Chaynuy pasaruptin Pablo yarparan Macedonia y Acaya provinciacunapa pasar Jerusalenman aywayta. Chaychru carcurna Romaman imanuypapis aywayta. ");
INSERT INTO qva_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Pablo Asia provinciachru goyangancama Macedonia provinciaman ishcay yanapagnincunata cachraran. Chay yanapagnincuna caran Timoteo y Erasto. ");
INSERT INTO qva_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Chay wichanmi Efesuchru achcag runacuna fiyupa rabyacäriran Jesucristo yachrachingannuy cawaypita Pablo willacuptin. ");
INSERT INTO qva_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Chaynuy rabyacuyta galaycachiran Demetrio jutiyog runam. Pay yurag guellaypita imatapis rurag. Chaynuy car yurag guellaypita rurag Artemisa jutiyog ïdulupa tacsha capillanta nirag. Chaywanmi Demetriuwan arogcuna achca guellayta gänapäcog. ");
INSERT INTO qva_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Chaynuy arognincunata y ruragmasincunata shuntarcurmi niran: “Taytacuna, gamcuna musyapäcunquim caycunata rurar ali gänanganchita. ");
INSERT INTO qva_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ichanga gamcuna ricarcanquim y mayarcanquim Pablo jutiyog runa ‘Runa rurangan dioscunaga manam dioscunachu’ nir yachraycächinganta. Chaynuy yachrachir criyichisha achca runacunatam. Chaynuy rurasha manam cay Éfeso marcalachrüchu sinöga cäsi intëru Asia provinciachrümi. ");
INSERT INTO qva_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Chaynuy yachrachiptin noganchipag manam alichu canga. Cay lapan ranticunanchipag ruranganchipis manacaglapämi canga. Artemisa diosninchipa templuntapis manacagman chrurarpis chrurarärinmanmi. Cay Asia provinciachru y intëru munduchru adorarcarpis payta mananapis adorärärinmanmi”. ");
INSERT INTO qva_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Chaynuy ninganta mayarmi fiyupa rabyar nipäcuran: “¡Vïva efesio runacunapa Artemisan!” ");
INSERT INTO qva_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Chaynuy captin runacuna pasaypa ima yarpaytapis mana camäpacäriranchu. Chaymi Gayuta y Aristarcuta charircur garashchracurcur achca runacuna estadiuman cörripäcuran. Gayuwan Aristarco Macedonia provinciapita caran. Chaynuypis ishcan yanagaran Pabluta. ");
INSERT INTO qva_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Chayman Pablo chay runacunawan parlananpag yaycuyta munaran. Ichanga Jesucristuman yäracogcuna amacharan mana yaycunanpag. ");
INSERT INTO qva_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Asiapa autoridänincunachru Pabluwan reguinacungan runacuna caran. Paycunapis jucwan Pabluta rugacachiran chayman mana jaticänanpag. ");
INSERT INTO qva_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Chay shuntacanganchru jucta jucta gaparir nipäcuran. Runacuna pasaypa ima yarpaytapis mana camäpacäriranchu. Chaychru achcag runacuna mana musyapäcuranchu imapag chayman shuntacangantapis. ");
INSERT INTO qva_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Israel runacuna Alejandruta chay lapan runacunapa ñaupagninman yaycachipäcuran paycunapa favurnin rimamunanpag. Nircurna chay runacunapita waquincuna imapita chaynuy caycangantapis tantiyachipäcuran. Chaypitanam rimamunanpag Alejandro maquinwan sëñasyämuran lapan upälacärinanpag. ");
INSERT INTO qva_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ichanga Alejandro Israel runa canganta musyarmi ishcay höranuy lapan caynuy nir gaparäpäcuran: “¡Vïva efesio runacunapa Artemisan!” ");
INSERT INTO qva_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Marcapa mas mandag autoridänin runacunata imanuypapis upälarcachirmi niran: “¡Éfeso runacuna! May chay runacunapis munayniyog Artemisapa templunta y adoränanpag cielupita rumi ratamunganta cay marca cuydananpag canganta musyapäcunmi. ");
INSERT INTO qva_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Chaytaga pipis manam niegayta puedinchu. Upälacäriy. Shumagrag yarpachracäriy imata rurapäcunayquipäpis. ");
INSERT INTO qva_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Gamcuna pushapäcamungayqui runacunaga manam Artemisapa templunpita suwacärishachu ni diosninchi Artemisapa contran lutanta rimapäcushachu. ");
INSERT INTO qva_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ichanga Demetrio y paywan arogcuna pitapis demandacuyta munaptinga juezcuna canmi. Chaychru ishcanpis arregläpäcuchun. ");
INSERT INTO qva_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ichanga gamcuna jucta imatapis parlayta munaptiquega parlacänan autoridäcuna lapan runacunawan shuntacaycur rimanacuptin. ");
INSERT INTO qva_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Canan junag lapan pasangancunawan noganchipag Roma autoridäcuna paycunapa contran sharcuycanganchita yarpar demandämashwanmi. Chaypita tapumashaga noganchi ¿imatatag nishunpag cay lapan pasanganpita?” ");
INSERT INTO qva_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Chaynuy nircurna chay runacunata aywacärinanpäna niran. ");
INSERT INTO qva_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Runacuna gaparparcanganpita aywacaräriptinnam Jesucristuman yäracogcunata gayaycachimur Pablo shacyächiran. Nircurna paycunapita despidicurir Macedonia provinciaman aywacuran. ");
INSERT INTO qva_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Chaychrüna chay marcacunachru Jesucristuman yäracogcunata watucurir shumag shacyarcachirna Grecia provinciaman pasaran. ");
INSERT INTO qva_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Chaychrümi quimsa quilla goyaran. Siria provinciaman büquiwan aywananpag camaricuycarnam Israel runacuna paypa contran rimanacäringanta musyaran. Chauraga Pablo Macedoniapana Siriaman aywayta yarparan. ");
INSERT INTO qva_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Payta yanagaran Berea marcapita Pirrupa wamran Sópater, Tesalónica marcapita Aristarcuwan Segundo, Derbe marcapita Gayo, Timoteo y Asia provinciapita Tiquicuwan Trófimo. ");
INSERT INTO qva_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Paycuna ñaupaycur Troas marcachru shuwaräpäcamaran. ");
INSERT INTO qva_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Levadüraynag tantata micuna fiesta junagcuna pasariptinna Filipos marcapita büquiwan yargapäcurä. Chaypita pichga junagtaga Troas marcachru ñaupagcagcunata taripäpäcurä. Chaychru ganchris junag quëdapäcurä. ");
INSERT INTO qva_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Semäna galaycunan junagmi shuntacäpäcurä Santa Cënata micapäcunäpag y chaychrümi Jesucristuman yäracogcunata Pablo willapaycaran. Warantin tuta aywacunan captinmi pulan pagascama chaychru parlaran. ");
INSERT INTO qva_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Shuntacasha capäcurä altucag pïsu cuartuchrümi. Chaychrümi achca michërucuna sindiraran. ");
INSERT INTO qva_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Chaychrümi Eutico jutiyog mösu ventänachru jamaraycaran. Pablo may rätu parlaptinmi chay mösu pasaypa puñunar puñucasha quimsacag pïsupita pampaman jegarpamuran. Chaypita wañushata jorgarcapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Chauraga Pablo yarpurcur mösu jananman wegucuycur abrazacurcuran. Nircur wauguicunata panicunata niran: “¡Ama wagapäcuychu! Cawaycanmi”. ");
INSERT INTO qva_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Chaypitana Pablo yapay altuman jegaran. Santa Cënata y micuytapis micurcärirna Pablo pacha warangancama parlaran. Chaypitana aywacuran. ");
INSERT INTO qva_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Chay mösuta cawaycagta pushapäcuran. Chaynuy pasanganpitam lapanpis pasaypa cushicäriran. ");
INSERT INTO qva_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Nogacuna Pabluta shuntapäcunäpag Asonman büquiwan ñaupapäcurä. Pay yarpangannuy chraquilapa Asonman aywaran. ");
INSERT INTO qva_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Nogacunawan Asonchru Pablo tincuran. Chaypitanam büquiman jegarcur Mitilene marcaman aywacärirä. ");
INSERT INTO qva_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Chaypita yargurnam warantinga Quío jutiyog isla chimpaman chrayapäcurä. Chaypita juc junag masta Samos jutiyog islaman chrayapäcurä. Troguilio ninganchru puñuycur yapay juc junagta Mileto jutiyog marcaman chrayapäcurä. ");
INSERT INTO qva_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Chaynuy rurapäcurä Pablo chaynuy cananta munasha captinmi. Pay Efesuman aywayta mana munaranchu Asiachru quëdayta mana munar. Pay imanuypapis Jerusalenman Pentecostés fiesta galaycunan junagpag chrayayta munaran. ");
INSERT INTO qva_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Mileto marcachru caycar Efesuchru yäracog shuntacagcunapa mayor wauguincunata Pablo gayachimuran. ");
INSERT INTO qva_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Chrayapäcuptinna niran: “Gamcuna musyapäcunquim cay Asia provinciaman chrayamungä junagpita pacha imanuy cangätapis. ");
INSERT INTO qva_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mana olgutucuypam wagarpis Señor Jesucristo mandanganta rurashcä. Israel runacuna imata rurayta munapäcamaptinpis nacarpis Jesucristo munangantam rurashcä. ");
INSERT INTO qva_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ichanga mana jaguiriypam gamcunata alicagcunata willapashcä y runa shuntacanganchru y wasiquicunachrüpis gamcunata yachrachishcä. ");
INSERT INTO qva_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Israel runata mana Israel runatapis anyashcä juchancunapita wanacurir Tayta Diosninchi munangannuy cawananpag y Señor Jesucristuman yäracärinanpag. ");
INSERT INTO qva_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Cananga Santu Espíritu pushamaptinmi Jerusalenman aywaycä. Ichanga chaychru ima pasamänantapis manam musyächu. ");
INSERT INTO qva_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ichanga may marcaman chrayaptïpis Santu Espíritu willaycäman carcilchru wichrgaränäpag y nacanäpag canganta. ");
INSERT INTO qva_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Noga manam cawayta yarpänachu. Imanuy captinpis ruranäpag cagta cumplinäcama rurashag y willacuyninchru Tayta Diosninchi cuyamanganchita Señor Jesús willacunäpag chruramanganta cumplinäcama rurashag. ");
INSERT INTO qva_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Noga musyämi Tayta Diospa munayninpita willapangäcagcunaga manana yapay lapayqui ricapäcamänayquipag canganta. ");
INSERT INTO qva_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","27","Cananga gamcuna mayapäcamay: Nogaga lapantam gamcunata willapashcä Tayta Diosninchi imata rurananpag cangantapis. Willapangäta gamcuna mana chrasquicäriptiquega Tayta Diosninchi castigäpäcushuptiquipis noga mananam juchayognachu cä. ");
INSERT INTO qva_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","“Ichanga cuydacärinqui. Jesucristuman yäracogcunatapis cuydapäcunqui. Gamcunata Santu Espiritum üsha michegtanuypis Tayta Diosman yäracog shuntacagcunata cuydapäcunayquipämi chrurapäcushushcanqui. Tayta Dios payman yäracogcunata quiquin Wamran yawarninta jichrayninpam salvaran. ");
INSERT INTO qva_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Musyämi noga aywacuptïga lutan yachrachegcuna fiyu atognuypis shamunanpag canganta. Paycunam lutanta yachrachir Jesucristuman yäracogcunata pantacächinga. ");
INSERT INTO qva_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Chaynuy runacuna quiquiquicunapitam sharcamunga lutancunata yachrachiptin waquin yäracogcuna paycunawan purinanpag. ");
INSERT INTO qva_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Chaynuy mana cananpag cuydacäriy. Yarpäpäcuy quimsa wata chacaypapis junagpapis weguïpawan lapayquita anyangäta. ");
INSERT INTO qva_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Cananga Tayta Diosninchipa maquinman gamcunata chruraycä y willacuyninchru cuyamanganchita ninganman gamcunata chruraycä. Chay willacuyninta cäsucurga Tayta Diosninchi munangannuymi cawapäcunqui. Paymi munayniyog caycan payman lapan yäracogcunata promitingancunata gamcunatapis gopäcushunayquipag. ");
INSERT INTO qva_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Manam pipa guellaynintapis ni öruntapis ni röpantapis munapashcächu. ");
INSERT INTO qva_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Quiquiquicunam musyapäcunqui chaypa truquinga nisitangäcunapag y nogawan cagcunapag quiquï arungäta. ");
INSERT INTO qva_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Chaynuy arucärir pishïpacogcunata yanapänayquipag imaycachrüpis noga gamcunata yachrachishcämi. Señor Jesús caynuy ninganta yarpämi: ‘Chrasquegcag cushicunanpa truquinga goycogcagmi cushicun’ ”. ");
INSERT INTO qva_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Niycurna Pablo gongurpacuycur lapan paycunawan Tayta Diosninchita rugacäriran. ");
INSERT INTO qva_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Lapan wagapäcuran, Pabluta abrazapäcuran y muchaycäriran. ");
INSERT INTO qva_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","“Cananpitaga mananam ricapäcamanquinachu” ninganpita lapan fiyupa laquisha carcaran. Chaypitanam büquicama lapan aywapäcuran despachacärinanpag. ");
INSERT INTO qva_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Wauguicunata chaychru jaguiycurna büquiwan derëchu Cos islaman aywapäcurä. Warantinna Rodas marcaman aywapäcurä. Chaypitana Pátara marcaman chrayapäcurä. ");
INSERT INTO qva_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Patarachru taripäcurä Fenicia partiman büqui aywaycagta. Chay büquiman jegarcurna aywacärirä. ");
INSERT INTO qva_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Siriaman aywacärirna Chipre islata ricapäcurä. Pasacäriptïna ichog lädücunachru quëdaran. Büqui carganta jaguinan captinmi Tiro marcaman chrayapäcurä. ");
INSERT INTO qva_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Jesucristuman yäracogcunata chaychru ashipäcurä. Tariycurna ganchris junag paycunawan chaychru goyäpäcurä. Santu Espíritu chay yäracogcunata musyachiptin Jerusalenman mana aywananpag Pabluta nipäcuran. ");
INSERT INTO qva_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Chaypita ganchris junagtaga aywacärirä. Lapan wauguicuna warmincunawan wamrancunawan marca yaycunacama chrurapäcamaran. Chaychrünam lamar cantunchru gongurpacuycur Tayta Diosninchita rugacärirä. ");
INSERT INTO qva_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Lapäcuna despidinacarcärirna büquiman jegapäcurä. Paycunapis wasinman cama cuticäriran. ");
INSERT INTO qva_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tiro marcapita Tolemaida marcaman lamarninpa aywapäcurä. Chaychru wauguicunawan panicunawan tincur saludäpäcurä. Nircurna paycunawan juc junag goyäpäcurä. ");
INSERT INTO qva_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Warantin yargurna chrayapäcurä Cesarea marcaman. Chaychrünam Felipipa wasinman chrayaycur pachacärirä. Paymi Jesucristupa ali willacuyninta willacog caran. Chaynuypis apostulcunapa ganchris yanapagnincunapita pay jucnincag caran. ");
INSERT INTO qva_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Felipipa chruscu jipash wamrancuna caran. Paycuna Tayta Dios musyachinganta willacäriran. ");
INSERT INTO qva_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Chaychru achca junagna goyarcaptï Judea provinciapita Agabo jutiyog Diospa willacognin chrayamuran. ");
INSERT INTO qva_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Nogacunacagman chrayaycamurnam Pablupa cinturunninwan maquinta chraquinta watacurcur niran: “Santu Espiritum niycan Jerusalenchru Israel runacuna cay cinturunpa dueñunta caynuy watarcur mana Israel runacunaman entregänanpag canganta”. ");
INSERT INTO qva_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Chayta mayaycur nogacunapis Cesareachru cagcunapis Pabluta rugapäcurä Jerusalenman mana aywananpag. ");
INSERT INTO qva_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ichanga Pablo niran: “¿Imanirtag wagapäcunqui y nogatapis laquinächipäcamanqui? Noga camaricusham caycä Señor Jesús janan Jerusalenchru wataränäpag. Chaynuypis camaricusham caycä pay janan wañunäpag”. ");
INSERT INTO qva_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ningäcunata mana cäsupäcamaptinna: “Tayta Diosninchi munaptinga lapanpis pasachun” nir jaguiriycärirä. ");
INSERT INTO qva_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Chaypita junagcuna pasariptin camaricärirä. Nircurna Jerusalenman aywacärirä. ");
INSERT INTO qva_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Jesucristuman Cesareachru waquin yäracogcunawan aywapäcurä. Paycuna pushapäcamaran Chipre islapita Mnasón jutiyog runapa wasinman. Mnasón unaypita pachana Jesucristuman yäracog runa caran. Paymi pachachipäcamänan caran. ");
INSERT INTO qva_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Jerusalenman chrayaräriptï wauguicuna panicuna cushisha chrasquipäcamaran. ");
INSERT INTO qva_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Warantin Pablo nogacunawan Santiago watucog aywaran. Chrayapäcunäpäga chaychrümi mayor wauguicunapis lapan carcänag. ");
INSERT INTO qva_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pablo lapanta saludaran. Nircurna manyapita shumag willaparan Tayta Diosninchi imata mana Israel runacunachru paywan rurangantapis. ");
INSERT INTO qva_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Willapanganta mayaycärir Tayta Diosninchita alabäpäcuran. Chaypita Pabluta nipäcuran: “Waugui, Israel runacuna waranganpam Jesucristuman yäracurcan. Lapan paycuna mana gongaypa Moisés escribingan leycunata cumplircan. ");
INSERT INTO qva_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Willapasha juc lädu marcancunachru tiyag lapan Israel runacunata Moisés escribingan leycunata jaguirinanpag yachraycächingayquita. Chaynuypis willapasha olgu wamracunata mana circuncidänanpag ni costumbrinchicunata mana rurapäcunanpag niycangayquita. ");
INSERT INTO qva_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","“Gam chrayamungayquita musyapäcungam. ¿Chauraga imatarag ruranquiman? ");
INSERT INTO qva_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ali canman caynuypa ruranayqui: Cay noganchichru caycan chruscu runacuna Tayta Diospag promësanta cumplinanpag caycagcuna. ");
INSERT INTO qva_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Paycunata pushacurcur paycunawan iwal purificacäriy. Agchanta rutuchicunanpag ofrendanta pägapay. Chaynuypam tantiyapäcunga gampag nipäcungan rasunpa mana canganta. Chaypa truquinga tantiyapäcunga gampis Moisés escribingan leycunata cumpliycangayquita. ");
INSERT INTO qva_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","“Ichanga mana Israel casta caycar Jesucristuman yäracushana cagcunaman cartachru yarpäpäcungäta apachipäcushcänam ïdulucunata chrurapangan aychata, yawarta, jurcacuypa wañusha uywapa aychanta mana micunanpag, olgupis warmipis jucwan jucwan mana puñucunanpag”. ");
INSERT INTO qva_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Chauraga chruscun runacunata Pablo pusharan. Warantinna paycunawan iwal purificacuran. Chaypitanam templuman yaycuran imay junag purificacuyta ushananpag canganta willananpag. Chay junag ofrendanta chruscun chrurapäcunan caran. ");
INSERT INTO qva_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Nagana ganchris junag cumplinanpäna caycaptin Asia provinciapita Israel runacuna templuchru Pablo caycanganta ricaycur runacunata shimita gor rabyanächiran. Chauraga Pabluta charicarcäriran. ");
INSERT INTO qva_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Gaparaypa nipäcuran: “¡Israel runacuna, yanapäpäcamay! Cay runam Israel runacunapa, Moisés escribingan leycunapa y cay templupa contran lapan runacunata may chaypapis yachrachir puriycan. Chaynuypis mana respitar Tayta Diospa templunman mana Israel runacunata yaycachisha”. ");
INSERT INTO qva_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Chaynuy nipäcuran Éfeso marcapita Trofimuwan Pablo chay marcachru purircagtana ricasha carmi. Trofimoga mana Israel runam caran y payta Pablo templuman yaycachinganta yarpäpäcuran. ");
INSERT INTO qva_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Chauraga marcachru achcag runacuna rabyacäriran. Nircur cörripäcuran shuntacäpäcunanpag. Chaypitana Pabluta chariycur garashchraypa templupita jorgapäcamuran. Nircurna templupa puertancunata jucla wichrgapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Chaychru magaycälar wañuchipäcunanpäna caycaptin Roma soldäducunapa comandantinta willapäcuran Jerusalenchru runacuna rabyacur gaparpaycanganta. ");
INSERT INTO qva_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Chauraga soldäduncunata y capitannincunata comandante shuntaran. Nircurna jucla cörriypa chay runacuna shuntacasha caycanganman aywapäcuran. Soldäducunatawan comandantita ricar magarcanganpita Pabluta cachrariycäriran. ");
INSERT INTO qva_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Chay comandantinam chrayaycur Pabluta charircachir ishcay cadinawan watachiran. Chaypitana tapuran pï chay runa canganta y imata ruranganta. ");
INSERT INTO qva_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Waquincuna nipäcuran jucta y waquinna jucta. Chaynuy gaparaypa nipäcuptin comandante imatapis mana tantiyayta puediranchu. Chauraga Pabluta cuartelman apachiran. ");
INSERT INTO qva_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Cuartel grädaman chrayaycachirna runacuna chariycur mana magananpag soldäducuna Pabluta apriypa gueshpichipäcuran. ");
INSERT INTO qva_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Achca runacunam gaparaycar guepanta aywapäcuran: “¡Wañuchisha cachun!” nir. ");
INSERT INTO qva_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Cuartelman yaycachinan caycaptinna comandantita Pablo niran: “¿Gamwan parlämanchu?” Comandante niran: “¿Griego rimayta yachranquichu? ");
INSERT INTO qva_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","¿Manachu gam canqui chay Egipto runa juc cutinchru gobiernupa contran sharcur chruscu waranga (4,000) runa wañuchegcunata pushacurcur chunyag jircapa yargamog?” ");
INSERT INTO qva_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pablo niran: “Nogaga Israel runam cä. Cilicia provincia alipag ricasha Tarso marcapitam cä. Rugacushayqui; cay runacunawan parlarishag”. ");
INSERT INTO qva_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Chay comandante “Au” niran. Pablo ichricuran grädaman. Maquinwanna sëñasyaran runacuna upälacärinanpag. Lapan upälaräriptinna hebreo rimaychru caynuy niran: ");
INSERT INTO qva_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Israel masïcuna y taytacuna, juchayog mana cangäta nimuptï mayaycärimay”. ");
INSERT INTO qva_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Hebreo rimayninchru Pablo rimanganta mayarmi lapanpis pasaypa upälacäriran. Chauraga Pablo niran: ");
INSERT INTO qva_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Noga Israel runam cä. Cilicia provincia Tarso marcachrümi yurishcä. Ichanga cay Jerusalenchrümi wiñashcä. Unay castanchicunapa leynin ninganta Gamalielmi shumag yachrachimasha. Tayta Diosninchi munangannuy lapan shongüpa rurarmi gamcuna canan wichan rurapäcungayquinuy rurashcä. ");
INSERT INTO qva_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Jesucristo yachrachingannuy cawagcunatam wañuchinäpag unay rabyapag cä. Warmitapis olgutapis charircur carcilman wichrgacheg cä. ");
INSERT INTO qva_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Cay rurangäcunata cüracunapa mas mandagnin y lapan Israel mayor autoridäcunam musyan. Paycunam Damascuchru Israel masinchicunapag ordinta gomaran. Chaymi aywarä chaychru cagcunatapis chariycur watashata Jerusalenman apaycamur castigächinäpag. ");
INSERT INTO qva_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Ichanga Damascuman aywar chrayaycaptïna pulan junagnuy caycaptin mayänipita achqui cielupita nogaman chilapyämuran. ");
INSERT INTO qva_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Chauraga pampaman ratarä. Chaychrünam caynuy nimagta mayarä: ‘Saulo, Saulo, ¿imanirtag nogata rabyapämanqui?’ ");
INSERT INTO qva_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Chauraga tapurä: ‘¿Pitag caycanqui, tayta?’ nir. Chauraga nimaran: ‘Rabyapaycämangayqui Nazaretpita Jesusmi cä’. ");
INSERT INTO qva_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Nogawan aywagcuna achquita ricarpis parlapämangantaga manam mayapäcuranchu. ");
INSERT INTO qva_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Noga tapurä: ‘¿Imatatag ruräman, tayta?’ Señor Jesús nimaran: ‘Sharcuy y ayway Damasco marcaman. Chaychrünam ima rurayman chrurashunayquipäpis nishunqui’. ");
INSERT INTO qva_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Chay chilapyämog achqui gaprayächimasha captinmi nogawan aywagcuna Damasco marcaman maquipita janchraypa pushapäcamaran. ");
INSERT INTO qva_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Chaychrümi tiyaran Ananías jutiyog runa. Paymi Moisés escribingan leycunata lapan shongunpa cumpleg caran. Damascuchru tiyag Israel runacuna pay ali runa cangantam rimapäcog. ");
INSERT INTO qva_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ananías nogacagman aywaycamur ñaupagnïman ichriycur nimaran: ‘Waugui Saulo, cananpita ñawiqui yapaynam ricanga’. Chay höra ñawï yapay alina ricacuran. Chauraga payta ricaräna. ");
INSERT INTO qva_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Nircurmi nimaran: ‘Unay castanchicunapa Tayta Diosninmi gamta acrashushcanqui pay rurayta munanganta musyanayquipag, Alilata Ruragcagta ricanayquipag y quiquin parlamunganta mayanayquipag. ");
INSERT INTO qva_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Cananga gammi lapan ricangayquita y mayangayquita pï maytapis Jesucristupita willapanqui. ");
INSERT INTO qva_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Cananga ¿imatatag shuwaraycanqui? Sharcuy; bautizacamuy. Payta rugacuy mayllacungayquinuypis juchayquicunapita perdunäshunayquipag’. ");
INSERT INTO qva_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Jerusalenman cutiycur Tayta Diosninchita templuchru rugacuycaptïmi Señor Jesucristo ricaripämaran. ");
INSERT INTO qva_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Chaychrümi ricaycaptï nimaran: ‘Apuracuy. Jerusalenpita jucla yarguy. Nogapita willacungayquita paycunaga manam chrasquipäcushunquichu’. ");
INSERT INTO qva_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Noga nirä: ‘Señor, paycuna musyanmi shuntacänan wasicunaman aywaycur gamman yäracogcunata carcilman apangäta y magangäta. ");
INSERT INTO qva_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Gampita willacog Estebanta wañuchipäcuptinpis noga chaychrümi caycarä “¡Alitam rurarcanqui!” nir. Wañuchegcunapa janancag röpantapis nogam charararä’. ");
INSERT INTO qva_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ichanga Señor Jesucristo nimaran: ‘Jucla ayway. Gamta cachraycä mana Israel runacuna caruchru tiyanganmanmi’ ”. ");
INSERT INTO qva_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Chay ningancama chay runacuna imatapis mana nipäcuranchu. Chaypitana ichanga rabyar gaparir nipäcuran: “¡Cay runa wañuchisha cachun! ¡Amana cawachunnachu!” nir. ");
INSERT INTO qva_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Chaynuy gaparir janancag röpancunatapis tapshipäcuran y altupa allpatapis polvuy polvur jitapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Comandante soldäduncunata cuartel ruriman Pabluta apaycunanpag niran. Chaychrüna soldäduncunata niran: “Astipäcuy imanir runacuna contran chaynuy gaparäpäcungantapis willacunanpag”. ");
INSERT INTO qva_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Astinanpag watararcächiptinna chaychru caycag capitanta Pablo tapuran: “¿Roma runa caycaptin y autoridäcuna manaräpis juzgaptin alichu canman gamcuna astipäcuptiqui?” ");
INSERT INTO qva_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Chaynuy niruptinmi capitan comandantiman aywaycur niran: “Cay runaga Roma runa carunag. Cananga ¿Imatatag ruranqui?” ");
INSERT INTO qva_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Chay comandante Pablucagman aywaycur tapuran: “Nimay, ¿Roma runachu caycanqui?” Pablo niran: “Au”. ");
INSERT INTO qva_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Comandante niran: “Roma runa canäpag achca guellayrämi nogataga cuestämasha”. Niptin Pablo niran: “Nogaga yuringäpita pacham cä”. ");
INSERT INTO qva_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Chauraga Pabluta astinanpag caycagcuna paypita jucla ashucäriran. Quiquin comandantipis Roma runa Pablo canganta musyar watachinganpita manchariran. ");
INSERT INTO qva_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Warantinna comandante imapita Israel runacuna Pabluta tumpanganta shumag musyayta munar Pabluta cachrariran. Chaypita cüracunapa mandagnincunata y lapan Israel mayor autoridäcunata shuntachimuran. Nircurna lapanpa ñaupagninman Pabluta pushachimuran. ");
INSERT INTO qva_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Israel mayor autoridäcunata ricärir Pablo niran: “Israel masïcuna, canancamalaga ali yarpaynïwanmi cawashcä. Chaytaga Tayta Diosninchi musyanmi”. ");
INSERT INTO qva_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Chauraga cüracunapa mas mandagnin Ananías Pablupa cercanchru caycagcunata Pabluta shimichru magananpag niran. ");
INSERT INTO qva_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Chauraga Pablo niran: “¡Runatucog! Magachimangayquipita gamtaga Tayta Diosninchim castigäshunqui. Chaychru gam jamaraycanqui ley ningannuy juzgamänayquipämi. Manam ley mana ninganta rurachinayquipächu”. ");
INSERT INTO qva_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Chaychru cagcuna nipäcuran: “¿Imanirtag chaynuy ashlinqui Tayta Diosninchi acrangan cüracunapa mas mandagninta?” ");
INSERT INTO qva_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pablo niran: “Israel masïcuna, noga manam musyashcächu pay cüracunapa mas mandagnin canganta. Tayta Diosninchi escribichinganchrüga niycan: ‘Marcayquichru mandagniquita ama ashliychu’ ”. ");
INSERT INTO qva_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Chaychru cagcuna waquin saduceo y waquin fariseo canganta tantiyacurir autoridäcunapa ñaupagninchru Pablo fiyupa niran: “Israel masïcuna, noga fariseum cä. Fariseupa ayllunmi cä. Gamcuna juzgarcämanqui wañushacuna cawarimunanpag cagta criyingäpitam”. ");
INSERT INTO qva_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Chaynuy Pablo niruptinmi fariseucuna saduceucunawan lïtuyta quiquinpura galaycäriran. Chauraga ishcayman raquicäpäcuran. ");
INSERT INTO qva_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Saduceucunaga nipäcun wañushacuna mana cawarimunanpag canganta. Angilcuna y almacuna mana canganta. Fariseucuna ichanga cay lapan canganta nipäcun. ");
INSERT INTO qva_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Lapan gaparir nipäcuran. Moisés escribingan leycunata yachracheg fariseo runacunapis ichrircur waquin nipäcuran: “Cay runa manam imatapis mana alitaga rurashachu. Cay runataga pagta alma o angel parlapasha”. ");
INSERT INTO qva_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Lïtuyta mas galaycapäcuptinnam comandantega manchariran Pabluta wañuchipäcunanta yarpar. Chaymi soldäducunata gayachimuran chay runacunapita jorgurcur cuartelman yapay cutichinanpag. ");
INSERT INTO qva_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Chay chacay Señor Jesucristo Pabluta ricaripaycur niran: “Ama manchariychu. Cay Jerusalenchru nogapita willacungayquinuymi Romachrüpis willacunqui”. ");
INSERT INTO qva_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Warantin junag waquin Israel runacuna rimanacäriran Pabluta wañuchinanpag. Jurapäcuran manaräpis Pabluta wañuchirga mana micapäcunanpag ni upupäcunanpag. ");
INSERT INTO qva_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Chay rimanacäreg runacuna chruscu chruncapita (40) mas caran. ");
INSERT INTO qva_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Chaypita aywapäcuran cüracunapa mandagnincunaman y Israel mayor runacunaman nipäcunanpag: “Nogacuna jurapäcushcä Pabluta manaräpis wañuchirga mana micapäcunäpag ni upupäcunäpag. ");
INSERT INTO qva_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Cananga gamcuna y waquin Israel mayor autoridäcuna comandantita nipäcuy shumag juzganayquipag tumpala gamcunaman Pabluta apachimunanpag. Nogacunaga camaricushalanam caycäshag manaräpis chrayachimuptin wañuchipäcunäpag”. ");
INSERT INTO qva_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ichanga Pablupa paninpa olgu wamran chayta mayaran. Chay mayangantana Pabluta willananpag cuartelman aywaran. ");
INSERT INTO qva_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Chauraga Pablo jucnincag capitanta gayaycur niran: “Cay mösuta comandantiman pushay musyanganta willananpag”. ");
INSERT INTO qva_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Capitan chay mösuta comandantiman pushaycur niran: “Prësu caycag Pablum gayaycamar rugacamasha cay mösuta gamman pushamunäpag. Paymi willashunqui imata mayangantapis”. ");
INSERT INTO qva_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Comandantina maquipita chay mösuta janchracurcur juc läduman pusharan. Chaychrüna tapuran: “¿Imatag willamänayquipag caycan?” ");
INSERT INTO qva_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Chay mösu niran: “Israel runacunam rimanacärisha wara Pabluta Israel mayor autoridäcunaman shumag juzgananpag tumpala pushachipäcushunayquipag. ");
INSERT INTO qva_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Amam cäsupanquichu. Chaychru cagcunapita chruscu chruncapita (40) masmi runacuna pacacusha shuwararcan Pabluta wañuchipäcunanpag. Paycuna jurapäcusha Pabluta manaräpis wañuchirga mana micunanpag ni upunanpag. Cananga camaricushalana carcan. Gam ninalayquitanam shuwararcan”. ");
INSERT INTO qva_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Chauraga chay mösuta comandante niran: “Willamangayquita pitapis ama willapanquichu”. Nircur chay mösuta aywacunanpag niran. ");
INSERT INTO qva_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Chauraga comandante chaychru caycag capitancunapita ishcayta gayaycachimur niran: “Cesareaman chacaypa las nueve aywapäcunanpag camaricuy ishcay pachrac (200) soldäducunata chraquipa aywananpag, ganchris chrunca (70) soldäducunata caballu logasha aywananpag y ishcay pachrac (200) soldäducunata lanzawan aywananpag. ");
INSERT INTO qva_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Chaynuypis Pablo logacunanpag caballucunata camariy. Shumag alita Judea provinciapa mandagnin Felixman pushay”. ");
INSERT INTO qva_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Paycunawanmi caynuy escribisha cartata apachiran: ");
INSERT INTO qva_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Yachrag tayta mandag Félix, noga Claudio Lisias gampag salüdücunata apaycächimü: ");
INSERT INTO qva_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Israel runacunam cay runata charipäcusha. Nircurnam wañuchipäcunanpag carcasha. Ichanga Roma runa canganta musyaycur soldäducunawan aywaycur cachrarichimurä. ");
INSERT INTO qva_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Imapita tumpapäcungantapis musyayta munar Israel mayor autoridäcuna shuntacasha caycanganman pusharä. ");
INSERT INTO qva_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Chaychrünam tumpagnincuna nipäcuran quiquincunapa leynincunata mana cumpliycanganta. Chaynuy captin manam juchayog canganta tarishcächu wañuchisha cananpänuy ni carcilchru wichrgaränanpänuy. ");
INSERT INTO qva_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ichanga Israel runacuna Pabluta wañuchinanpag rimanacäringanta willamaptinmi gamman jucla apaycächimü. Chay tumpagnincunatapis nishcä gampa ñaupagniquichru imata ninanpag cagtapis nipäcunanpag. ");
INSERT INTO qva_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Soldäducuna chaynuy rurananpag chrasquingannuyla chacaypa Pabluta Antípatris marcaman apapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Warantinna caballu logasha cagcuna Pabluwan aywaran. Waquincunam ichanga cuartelman lapan cuticärimuran. ");
INSERT INTO qva_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Cesareaman chrayaycurna mandag Felixta cartata goycur Pablutapis entregaycuran. ");
INSERT INTO qva_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Cartata liyircurna mandag Félix may provinciapita cangantapis Pabluta tapuran. Cilicia provinciapita canganta musyaycur niran: ");
INSERT INTO qva_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","“Tumpashogniquicuna chrayamuptinrämi imatapis nimanquipag”. Chaypitana Herodispa palaciun canganman chruraycur cuydapäcunanpag niran. ");
INSERT INTO qva_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Chaypita pichga junag pasarcuptinna cüracunapa mas mandagnin Ananías ishcay quimsa Israel mayor runacunawan y Tértulo jutiyog abogäduwan Cesarea marcaman chrayaran. Paycuna Pabluta imapita tumparcangantapis nipäcunanpag mandag gobernador Felixpa ñaupagninman chrayapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Pabluta pusharärimuptinna imapita tumpapäcungantapis Felixta Tértulo niyta galaycuran: “Yachrag tayta Félix, gamta agradecicärï jauca cawapäcungäpita. Gracias, ali shumag yarpayniquiwan cay naciunchru alicunata rurachishcanqui. ");
INSERT INTO qva_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Cay lapan rurachingayquicunata imaypis cushisha maychrüpis chrasquicärï. ");
INSERT INTO qva_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","“Ichanga tiempuyquita aläpa mana perdichinäpag rugacü ali shonguyquipa juc rätula mayaycärimänayquita. ");
INSERT INTO qva_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Cay runaga fiyu gueshya may chaypapis puwariycar puringannuymi Israel runacunata may chaychrüpis rabyanächir chriquinacaycächin. Chaynuypis Nazaretpita Jesuspa discïpuluncunachru munayniyog caycan. ");
INSERT INTO qva_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Chaynuy templutapis respitayta mana munashachu. Chaypitam prësu charircur leynïcuna ningannuy juzgayta munapäcurä. ");
INSERT INTO qva_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ichanga comandante Lisias aywarcamur pelyanpawan quïtariycärimasha. ");
INSERT INTO qva_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Nircurmi nipäcamasha gampa ñaupagniquiman aywaycamur imapita tumparcangätapis nipäcunäpag. Gam quiquiqui tapurmi Pablupita lapanta musyanqui imapita payta demandarcangätapis”. ");
INSERT INTO qva_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Chaychru cag Israel runacunapa autoridänincunapis chaynuylam nipäcuran. ");
INSERT INTO qva_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Nipäcuptinmi mandag gobernador Pabluta sëñasyaran rimacunanpag. Chauraga Pablo nimuran: “Noga musyämi achca watana cay naciunchru juez cangayquita. Chaymi manacagcunata tumpapäcamanganta ali shongüwan nimushag. ");
INSERT INTO qva_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Quiquiquipis tapupacäriy. Chayrämi chrunca ishcay (12) junag caycan Jerusalenman Tayta Diosninchita adoränäpag chrayamungä. ");
INSERT INTO qva_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Manam templuchru ni shuntacänan wasicunachru ni Jerusalenchrüpis piwanpis lïtuycagta ni pitapis rabyaycächegtachu tarimasha. ");
INSERT INTO qva_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Cay runacuna imapita tumparcämangantapis mä jorgapäcamächun. ");
INSERT INTO qva_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","“Ichanga willashayqui: Jesucristo imanuypis cawanapag yachrachingannuy cawaptïmi paycuna lutan yachrachicuycunata yachracungäcunata yarpäpäcun. Cay yachrachicuycuna ningannuymi taytäcuna adorangan Tayta Diosta adorä. Chaynuypis criyïmi Moisés escribingan lapan leycunaman y Diospa willacognincuna lapan escribingancunaman. ");
INSERT INTO qva_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nogapis paycuna criyingannuymi ali ruragta y mana ali ruragtapis lapan wañushacunata Tayta Dios cawarichimunanpag canganta criyï. ");
INSERT INTO qva_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Chaymi imaycanuypapis ali yarpaynïwan Tayta Diospag y runacunapäpis cawaycä. ");
INSERT INTO qva_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Achca watacuna juc läduchru cangäpita cananga aywamushcä Israel marcamasïcunapag limusnata gonäpag y Diospag ofrendacunata gonäpag. ");
INSERT INTO qva_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Chaymi templuchru purificacusha caycagta Asia provinciapita Israel runacuna taripäcamaran. Taripäcamaran manam achca runacunawan caycagtachu ni pitapis büllata ruraycächegtachu. ");
INSERT INTO qva_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Chay runacuna cayman shamunman imatapis mana alita rurasha captïga ñaupagniquichru nipäcamänanpag. ");
INSERT INTO qva_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Sinöga caychru caycagcuna quiquincuna nipäcamächun Israel mayor autoridäcunapa ñaupagninchru imapitapis juchayog cangäta tarimasha captinga. ");
INSERT INTO qva_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Paycunapa ñaupagninchru caycar fiyupa caynuy ningalämi caycan: ‘Canan nogata gamcuna juzgarcämanqui wañushacuna cawarimunanpag canganta criyingäpitam’ ”. ");
INSERT INTO qva_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Jesucristo imanuypis cawanapag yachrachicuycunata Félix shumagna musyaycaran. Chaymi juc junagpärag jitapar niran: “Comandante Lisias chrayamurnam caypita masta willamaptin gamcunata arregläpäcushayqui”. ");
INSERT INTO qva_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Nircurna capitanta Félix niran Pablo wichrgaränanpärag canganta. Ichanga niran chaychru cachrarisha cananpag y mana amachasha cananpag amïguncuna imalawanpis chrayaptin tincunanpag. ");
INSERT INTO qva_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Chaypita junagcuna pasarcuptinna Félix Israel casta warmin Drusilawan chrayaran. Chaypitana Félix gayachimuran Pabluta. Chaychrünam Jesucristuman yäracunapag canganta Pablo willacuptin mayapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ichanga mana juchäcuypa cawaypita, shumag tantiyacurir imatapis ruraypita y juiciu finalpita willapaptin Félix mancharir niran: “Cananga aywacuyrag. Juc junagpärämi yapay gayashayqui”. ");
INSERT INTO qva_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Nircur Félix achca cuti gayachiran parlananpag Pablo pägananta ashir. ");
INSERT INTO qva_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Chaynuy ishcay wata pasaran. Chaypitana Félix mandag gobernador caypita yargucuran. Paypa truquin Porcio Festo jutiyog runa yaycuran. Félix Israel runacunawan ali cayta munar Pabluta prësu jaguiriran. ");
INSERT INTO qva_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festo Judea provinciachru mandag gobernador cananpag chrayaran. Chaypita quimsa junagtaga Cesarea marcapita Jerusalenman aywaran. ");
INSERT INTO qva_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Chaychrünam cüracunapa mandagnincuna y Israel castacunachru mas mandag autoridäcuna Pablupa contran Festuman demanduta chrurapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Rugapäcuran paycuna raycu Pabluta Jerusalenman pushachinanpag. Paycuna yarpäpäcusha caran Jerusalenman aparcaptilan pacacuycur camiñuchru Pabluta wañuchipäcunanpag. ");
INSERT INTO qva_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ichanga Festo niran Pablo Cesareachru prësuränanpärag canganta y quiquin chayman warantincuna aywananpag canganta. ");
INSERT INTO qva_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Pay niran: “Chaymi autoridäniquicuna Cesareaman nogawan aywanman chay runa imatapis mana alita rurasha captinga chaychru nipäcunanpag”. ");
INSERT INTO qva_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festo Jerusalenchru caran pusag o chrunca junagnuy. Nircurna Cesareaman cutimuran. Warantinna despächunchru mandananpag jamacunanman tiyacuran. Chaypitana niran Pabluta pushapäcamunanpag. ");
INSERT INTO qva_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pablo chrayaruptinna Jerusalenpita aywag Israel runacunapa autoridänincuna ashuycur manacagcunata tumpar nipäcuran: “Pasaypa mana alitam rurasha” nir. Ichanga tumpapäcungan mayganpis manam rasunpachu caran. ");
INSERT INTO qva_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pablo declaracur niran: “Noga manam imatapis lutanta rurashcächu, Israel runacunapa leyninpa contran ni templupa contran ni Romachru mandag emperadurpa contran”. ");
INSERT INTO qva_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ichanga Festo Israel runacuna alipag ricananta munar Pabluta tapuran: “¿Jerusalenman aywayta munanquichu tumparcäshungayquipita chaychru noga juzganäpag?” ");
INSERT INTO qva_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pablo niran: “Roma emperadurmi gamta chrurashushcanqui pitapis juzganayquipag. Chaymi caycä gampa despächuyquichru juzgamänayquipag. Caychrümi noga juzgasha canä. Gam shumag musyangayquinuypis Israel runacunapag imatapis manam contranta rurashcächu. ");
INSERT INTO qva_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Imatapis wañunäpänuy lutanta rurasha captïga wañuyta manam manchächu. Ichanga tumpapäcamangannuy rasunpa mana captinga pipis manam munayniyogchu Israel runacunaman entregämänanpag. Chaypa truquinga quiquin emperador juzgamächun”. ");
INSERT INTO qva_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Chauraga Festo yächegnincunawan rimanacurir niran: “Emperador juzgashunayquita munaycaptiquega emperadurmanmi aywanqui”. ");
INSERT INTO qva_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Chaypita junagcuna pasarcuptinna rey Agripa y Berenice aywaran Cesareaman Festuta watucärinanpag. ");
INSERT INTO qva_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Chaychru achca junagcuna goyäpäcuptinmi imapita Pablo demandasha canganta reyta Festo willaparan: “Félix juc runata prësuraycagta jaguiriycusha. ");
INSERT INTO qva_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Jerusalenchru caycaptïmi cüracunapa mandagnincunawan Israel mayor runacuna nogaman chay runapag demanduta chruramusha noga sentencianäpag. ");
INSERT INTO qva_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Chaymi noga nirä Roma autoridä pitapis demandagnin manaräpis cära a cära imapita demandangantapis mana niptinga pimanpis entregasha mana cananpag. Chaynuypis nirä demandasha runa manaräpis declaracuptinga entregasha mana cananpag. ");
INSERT INTO qva_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","“Chaymi paycuna cayman aywarärimuptin warantinga jucla despächüman aywarä arreglänäpag. Nircur gayachimurä chay prësu caycag runata. ");
INSERT INTO qva_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Chay demandagcuna ichriycur pasaypa lutantam rurasha ninanpag cagta yarpangänuychu manam nipäcuran. ");
INSERT INTO qva_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Chaypa truquinga Pablupa contran nipäcuran paycuna Diosta imanuy adoranganpita. Chaynuypis nipäcuran wañusha caycag Jesús jutiyog runalapita. Chay runapag Pablo cawaycanganta niran. ");
INSERT INTO qva_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Chay ningancunapita ima ruraytapis mana camäpacurmi Pabluta tapurä Jerusalenchru juzgasha cananpag aywananpag o mana aywananpäpis. ");
INSERT INTO qva_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Pay niran manchapacuypag emperador juzgananpag prësuränanpärag canganta. Chauraga nirä Romaman apachingäcama prësu wichrgaraycänanpärag”. ");
INSERT INTO qva_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Chauraga Festuta Agripa niran: “Nogapis amalä chay runa ninganta mayäman”. Festo niran: “Waratämi mayanqui”. ");
INSERT INTO qva_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Warantinna Agripawan Berenice shumag chichipaycar shuntacäpäcunan jatun wasiman mandag soldäducunawan y chay marcachru autoridäcunawan chrayapäcuran. Chaymanna Pabluta Festo pushachimuran. ");
INSERT INTO qva_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Chrayaycachiptinna niran: “Rey Agripa y nogacunawan lapayqui cayman shuntacag shamog taytacuna. Chay runa caychru caycan. Jerusalenchru caycaptï lapan Israel runacuna paypa contran y cay Cesareachru caycaptïpis paypa contran nogaman demanduta chruramusha. Paycuna gaparpayparag nircäman cay runa wañuchishana cananpag. ");
INSERT INTO qva_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ichanga nogapa yarpaynïpitaga wañuchisha cananpänuy imatapis manam rurashachu. Pay quiquinmi nisha manchapacunganchi emperador juzgananpag canganta. Chaymi yarpashcä paycagman apachiyta. ");
INSERT INTO qva_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ichanga Señurnï emperadurman Pablupita shumag escribinäpag mana canchu. Chaymi gamcunaman payta pushamushcä. Rey Agripa, masga gamman pushamushcä payta tapurcuptiquina mayangäta escribinäpag. ");
INSERT INTO qva_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Manam alichu canman imapita demandasha cangantapis mana niypa prësuraycag runata emperadurman apachiptï”. ");
INSERT INTO qva_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Chauraga Agripa niran Pabluta: “Imapita caychru cangayquitapis willapäcamay”. Chauraga Pablo maquinta jogarcur declaracur niran: ");
INSERT INTO qva_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Rey Agripa, cushisham caycä gampa ñaupagniquichru rimamunäpag captin. Canan nimushag gam musyanayquipag imapita Israel runacuna manacagcunata tumpapäcamanganta. ");
INSERT INTO qva_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Gamga shumagmi musyanqui Israel runacunapa imanuy costumbrincuna cangantapis y imapita lïtupäcungätapis. Chaymi rugacushayqui nimungäcunata shumag mayaycamänayquita. ");
INSERT INTO qva_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Lapan Israel runacunam musyapäcun marcächru y Jerusalenchru mösu cangäpita pacha paycunawan imanuypis cawangäta. ");
INSERT INTO qva_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Paycunaga unaypita pacham musyapäcun. Niyta munarga nipäcuchun. Fariseo runam carä. Pipitapis fariseo runacunam mas cumplipäcun Moisés escribingan leycunata. ");
INSERT INTO qva_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","“Cananga cayman juzgamänanpag aparäriman unay castanchicunata Tayta Dios promitinganman yäracungäpitam. ");
INSERT INTO qva_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Chacaypapis junagpapis mana jaguiriypam Tayta Diosta adorarcar chrunca ishcay castanchicuna shuwararcan chay promitingan cumpliycagta ricananpag. Rey Agripa, chay yäracungäta shuwaraptïmi Israel runacuna tumparcäman. ");
INSERT INTO qva_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","¿Imanirtag gamcuna mana criyipäcunquichu wañushacunata Tayta Diosninchi cawarichimunanpag canganta? ");
INSERT INTO qva_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Noga quiquïmi Nazaret marcapita Jesuspa contran imatapis rurayta yarparä. ");
INSERT INTO qva_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Chay yarpangänuymi Jerusalenchru rurarä. Cüracunapa mandagnincuna mandamaptin Jesucristuman yäracogcunata achcagta carcilman wichrgachirä. Wañuchipäcuptinpis ‘Alim ruraycanqui’ nirä. ");
INSERT INTO qva_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Shuntacänan wasicunachru achca cuti paycunata castigächirä Jesusta niegapäcunanpag. Paycunata pasaypa rabyaparmi juc lädu nacion marcacunamanpis rabyapar ashimunäpag aywarä. ");
INSERT INTO qva_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Chaynuy ruranäpämi cüracunapa mandagnincuna ordinwan mandamaptin Damasco marcaman aywaycarä. ");
INSERT INTO qva_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Rey Agripa, camiñuta aywaycaptïmi pulan junagnuy caycaptin inti achicyanganpitapis mas fiyupa nogaman cielupita achicyämogta ricarä. Chaynuy nogawan aywaycagcunamanpis achicyämogta ricarä. ");
INSERT INTO qva_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Chauraga lapäcuna pampaman ratapäcurä. Y hebreo rimaychru caynuy nimagta mayarä: ‘Saulo, Saulo, ¿imanirtag nogata rabyapämanqui? Chaynuy rurarga picata saytag törunuypis quiquiquim nanächicunqui’. ");
INSERT INTO qva_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Chauraga nirä: ‘¿Pitag caycanqui, tayta?’ Chaymi Señor Jesús nimaran: ‘Noga rabyapaycämangayqui Jesusmi cä. ");
INSERT INTO qva_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ichanga sharcuy. Gamta ricaripashcä gam nogapag imatapis ruranayquipag y musyanayquipag chruranäpämi. Chaynuy musyarmi canan ricamangayquicunata y ricamänayquipag cagcunata willacunqui. ");
INSERT INTO qva_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Israel runacunaman y mana Israel runacunaman gamta cachraycä. Chaypitanam paycunapa maquinpita gamta jorgushayqui. ");
INSERT INTO qva_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Paycunaman cachraycä tantiyachinayquipag yananyagpita achicyagman yargognuy juchäcuycunata jaguiriycur alina cawapäcunanpag. Y Satanaspa munayninchrüna mana capäcunanpag sinöga Tayta Diospa munayninchrüna capäcunanpag. Chaynuypis cachraycä nogaman yäracamaptin juchancunapita perdunasha cananpag y Tayta Diosninchi acrangan runacunacagchru capäcunanpag’. ");
INSERT INTO qva_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Cielupita ricariparcamar nimaptinmi noga cäsucushcä, rey Agripa. ");
INSERT INTO qva_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Chaymi puntata Damascuchru cagcunata Jesucristupa willacuyninta willaparä. Nircur Jerusalenchru cagcunata y Judea partichru cagcunatapis willaparä. Chaypitana mana Israel runacunatapis Jesucristupa willacuyninta willaparä juchancunapita wanacurir Tayta Diosninchita cäsucärinanpag. Chaynuypa alilata rurar juchancunapita wanacungan musyacänanpag. ");
INSERT INTO qva_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Chayta willacungäpitam Israel runacuna templuchru chariycamar wañuchiyta munapäcamaran. ");
INSERT INTO qva_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ichanga canancamalaga Tayta Diosninchi yanapaycäman auquistapis wamratapis lapanta Jesucristupita willacunäpag. Diospa willacognincuna ningalanta y Moisés ningalantam ima pasananpag cagtapis nishcä. Manam juctaga imatapis nishcächu. ");
INSERT INTO qva_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Paycuna escribipäcuran Tayta Dios cachramungan Salvador wañunanpag canganta, wañurpis pay puntata cawarimunapag canganta y Israel runacuna y mana Israel runacunapis salvacunanpag ali willacuyninta willacunganta”. ");
INSERT INTO qva_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pablo chaynuy declaracuptinmi Festo gaparir niran: “¡Pablo, gam löcuyasham caycanqui! Aläpa yachracurmi löcuyaycanqui”. ");
INSERT INTO qva_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ichanga Pablo niran: “Manam löcuchu caycä, yachrag tayta Festo. Juiciuwanmi rimaycämü. Lapan ningäcuna rasunpa cagmi. ");
INSERT INTO qva_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Cay lapan nimungäpita rey Agripa musyanmi. Chaymi mana manchacuypa paypa ñaupagninchru niycämü. Noga rasunpam musyä cay lapanpita pay musyanganta. Cay lapan manam maychrüpis cuchrunchru pacaylapachu ruracasha. ");
INSERT INTO qva_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Rey Agripa, ¿gam criyinquichu Tayta Diosninchipa willacognincuna ninganta? Noga musyämi criyingayquita”. ");
INSERT INTO qva_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agripa niran: “¿Yarpanqui ningalayquiwan Jesucristuman yäracachimaytachu?” ");
INSERT INTO qva_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pablo niran: “Canan jucla o chaypitarag captinpis Tayta Diosninchita rugacuycä gampis y caychru mayamagcunapis Jesucristuman noganuy yäracärinayquipag. Ichanga gamcuna ama noganuy cadinasha capäcunquimanchu”. ");
INSERT INTO qva_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Chauraga rey Agripa, gobernador Festo, Berenice y chaychru lapancagcuna jamararcanganpita ichrircapäcuran. ");
INSERT INTO qva_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Nircurna yariman chaypita aywaycärir quiquinpura ninacäriran: “Cay runa imatapis manam rurashachu wañuchisha cananpag ni carcilchrüpis wichrgaränanpag”. ");
INSERT INTO qva_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Y Agripa niran Festuta: “Emperador juzgananpag quiquin mana nisha captinga cay runa cachrarisham canman caran”. ");
INSERT INTO qva_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Italiaman apachipäcamänanpag rimanacarcärirna Pabluta y waquin prësucunata Julio jutiyog capitanman entregaran. Pay caran “Augusto” jutiyog batallunchru. ");
INSERT INTO qva_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Chauraga Adramitio marcapita shamog büquiman jegapäcurä. Chay büqui Asia provinciachru büqui ichrinan marcacunaman yargunanpäna caycaran. Chay büquiwanna yargapäcurä. Chaychru nogacunawan Aristarco caycaran. Pay caran Macedonia provinciachru Tesalónica marcapitam. ");
INSERT INTO qva_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Warantinna Sidón marcaman chrayapäcurä. Chaychrümi Pabluta 