﻿USE sofia;
DROP TABLE IF EXISTS sofia.qupNT_vpl;
CREATE TABLE qupNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES qupNT_vpl WRITE;
INSERT INTO qupNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kay killkami Jesukristumanta riman. Pay wawayarirka ali kamachik David wañupa miraykunamanta. David karka Abraham wañupa miraykunamanta. ");
INSERT INTO qupNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham Isaakpa yayanmi karka. Isaak Jakobpa yayanmi karka. Jakob Judapa yayanmi karka, chaymanta wawkinkunapapas. ");
INSERT INTO qupNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá Farespa Sarapa yayanmi karka, maman karka Tamar. Fares Esrompa yayanmi karka. Esrom Arampa yayanmi karka. ");
INSERT INTO qupNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram Aminadabpa yayanmi karka. Aminadab Naasonpa yayanmi karka. Naasón Salmonpa yayanmi karka. ");
INSERT INTO qupNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón Boospa yayanmi karka, maman Rahab karka. Boos Obedpa yayanmi karka, maman Rut karka. Obed Isaipa yayanmi karka. ");
INSERT INTO qupNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí atun apu Davidpa yayanmi karka. Chay atun apu David Salomonpa yayanmi karka. Salomonpa maman manara Davidpa warmin kashpanra Uriaspa warminmi karka. ");
INSERT INTO qupNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón Roboampa yayanmi karka. Roboam Abiaspa yayanmi karka. Abias Asapa yayanmi karka. ");
INSERT INTO qupNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa Josafatpa yayanmi karka. Josafat Jorampa yayanmi karka. Joram Usiaspa yayanmi karka. ");
INSERT INTO qupNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usias Jotampa yayanmi karka. Jotam Akaspa yayanmi karka. Akas Esekiaspa yayanmi karka. ");
INSERT INTO qupNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekias Manasespa yayanmi karka. Manasés Amonpa yayanmi karka. Amón Josiaspa yayanmi karka. ");
INSERT INTO qupNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josias Jekoniaspa wawkinkunapapas yayanmi karka. Chay uras Babilonia llaktamanta runakuna yaya rukunchi wañukunata watashpankuna aparkakuna llaktankunama, chaypi chay runakunapa munashkankunata rurashpa kawsanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Chay apirishka kahushkankunapi Jekonias warminta chichuchirka kari wawata. Chay wawaka Salatiel karka. Salatiel Sorobabelpa yayanmi karka. ");
INSERT INTO qupNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sorobabel Abiudpa yayanmi karka. Abiud Eliakimpa yayanmi karka. Eliakim Asorpa yayanmi karka. ");
INSERT INTO qupNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor Sadokpa yayanmi karka. Sadok Akimpa yayanmi karka. Akim Eliudpa yayanmi karka. ");
INSERT INTO qupNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud Eleasarpa yayanmi karka. Eleasar Matanpa yayanmi karka. Matán Jakobpa yayanmi karka. ");
INSERT INTO qupNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakob Josepa yayanmi karka. José Mariapa kusanmi karka. Maria Jesuspa mamanmi karka. Chay Jesustami rimarkakuna Kristu, chayka ninayan Yaya Diospa Kachashkan Kishpichik. ");
INSERT INTO qupNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Yaya rukunchi Abrahammanta pacha atun apu Davidkama chunka chusku kuti mirashka runakunami karkakuna. Atun apu Davidmanta pacha yaya rukunchi wañukunata Babilonia llaktama apashkankunakama chunka chusku kuti mirashka runakunami karkakuna. Paykunata chay Babilonia llaktama apashkankunamanta pacha Kristu wawayarishkankama chunka chusku kuti mirashka runakunami karkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kunan kwintanayani imashnami Jesukristu wawayarirka. Manara wawayarihushpan paypa maman Maria Josewa kwintashka karka kasarananpa. Manara Joseka pushahushpanra Yaya Diospa Espíritun yanapashpan Mariaka chichuna kiparirka. ");
INSERT INTO qupNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Maria chichu kashkanta yachashpan Joseka manana munarkanachu payta pushanata warminrayku. Ali rurak runa kashpan mana munarkachu tukuy chay llaktapi kawsak runa masinkunapa puntankunapi Mariata pinkachichinata. Chayrayku yuyarirka nima pita rimashpan payta sakinata. ");
INSERT INTO qupNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Chasna yuyarihushkanpi shuk tuta muskuyninpi Yaya Diospa angelka rimarka: José, ñawpa atun apu Davidpa miraymanta kashpayki Yaya Dios munan mana pinkarishpa Mariata pushanaykipa. Chay wiksanpi kahushkanka kanmi Yaya Diospa Espíritun yanapashpan Mariaka chichuna kiparishkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Payka shuk kari wawata wawayanka. Ña wawayashpan shutiyachinki Jesusta nishpa. Chasna Jesús rimashkanka kishpichikmi. Chasna kashpan chay angelka rimashpa katirka: Payka runakunata uchankunamanta kastigana kahushkakunamanta kishpichinka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Chaywa paktarirka Yaya Diospa ñawpa rimashkanka imashnami paypa yachayninwa yachachik Yaya Dios payta yuyachishpan rimarka kasna: ");
INSERT INTO qupNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Shuk shipas chichunkami, shuk kari wawata wawayanka. Wawayashpan shutiyachinka Emanuel nishpa. Emanuel ninayan Yaya Dios ñukanchiwa. Chasna Yaya Dios rimashkanshina Mariaka shuk kari wawata wawayanan karka. ");
INSERT INTO qupNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Chay angel rimashkanwasha Joseka puñushkanmanta likcharishpan Mariata pusharka warminrayku, imashnami Yaya Diospa angelka rimarka. ");
INSERT INTO qupNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pushashkanwasha manara kawsarkachu warminwashina wawayanankama. Mariaka wawayashpan chay wawanta shutiyachirka Jesús. ");
INSERT INTO qupNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Atun apu Herodes Judea allpapi kamachihushkan uras Belén llaktapi Jesuska wawayarirka. Chay Belén llaktaka Judea allpa chawpipi, apukunapa kawsana Jerusalén llakta kuchupi karka. Jesús wawayarishpanna inti llukshinan kuskamanta istrillata yachak runakuna Jerusalén llaktama shamurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Paktashpankuna chaypi kawsak runakunata rimarkakuna: Karu llaktanchimanta rikushkanchi shuk suma punchahlla rikurik istrilla llukshishkanta. Chayta rikushpanchi yachashkanchi shuk kari wawa wawayarishkanta kankuna israel runakunata kamachinanpa. Chayraykumi shamushkanchi chay wawayarishkata mañashpa kushichinanchipa. ¿Maypitaya chay wawayarishka atun apuka? ");
INSERT INTO qupNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Chayta uyashpan atun apu Herodeska yapa mancharishpan tsala tukurka. Chay Jerusalenpi kawsak runakunapas yapa mancharirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Chaypina chay Herodeska kayachirka tukuy saserdotekunapa apunkunata, Moisespa killkashkanta yachachikkunatapas. Paykunata tapurka: Kankuna Yaya Diospa shiminta yachachinkichi. Ñukatapas rimawaychi ¿maykan llaktapita wawayarinka Yaya Diospa Kachanan Kishpichikka? ");
INSERT INTO qupNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Chaypina chay yachakkunaka aynirkakuna: Kay Judea allpa chawpipi Belén llaktapimi wawayarinka. Chasnami ñawpa Yaya Diospa yachayninwa yachachikka Yaya Diospa rimashkanta killkarka maykanmi pasanan karka: ");
INSERT INTO qupNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Judea allpapi Belén llaktamanta achka atun llaktakuna tiyashpanpas chay uchilla Belén llaktaka mana kanchu mana valikshina. Chay Belenpimi shuk wawaka wawayarinka ali kamachik kananpa. Paymi kankuna akllashkayni israel runakunata alita yachachinka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Chayta uyashpan Herodeska pakalla kayachirka chay istrillata yachakkunata. Paykunata tapurka: ¿Ima urasta chay istrillaka llukshirka? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Paykuna aynishpankuna Herodeska rimarka: Kunanka riychi chay Belén llaktama. Chaypi maskaychi chay wawata. Payta tarishpaykichika rimak shamuwaychi ñukapas payta kushichik rinaynipa. ");
INSERT INTO qupNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Chasna llullachishpa rimashpanmi chay istrillata yachakkunaka Jerusalenmanta llukshirkakuna chay Belén llaktama rinankunapa. Rihushpankuna kutikashka rikurkakuna chay llaktankunapi rikushkankuna istrillata. Chay istrillaka paykunapa puntankunapi rirka. Chasna rishpan Jesuspa kahushkan wasi kuskapi shayarirka. ");
INSERT INTO qupNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Paykunaka chay istrillata rikushpankuna yapa kushikurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Chaymanta chay wasipi yaykuk rishpankuna rikurkakuna Maria wawanwa kahukta. Chaypina paykunaka chay wawata kunkurishpa mañashpa kushichirkakuna kanka Yaya Diosmanta shamushkami kanki nishpa. Chaypi apamushkankuna kahunta paskashpankuna yapa chaniyuta surkurkakuna, orota, dioskunarayku rupachina wikita, mishkinlla asnak kaspi wikita mirra shutiyuta. Tukuy chaykunata kurkakuna wawa Jesusta kushichinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Chaymanta Yaya Dioska paykunata puñushkankunapi rimarka mana kutinankunapa Herodesma. Chayrayku paykunaka Yaya Diospa rimashkanta kasushpankuna llaktankunama kutirkakuna shuk ñampitana. ");
INSERT INTO qupNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Chay yachak runakuna llaktankunama kutishkankunawasha Yaya Diospa angelka Joseta muskuyninpi rimarka: Herodeska maskankami kay wawata wañuchinanpa. Chayrayku utkalla atarishpayki kay wawata mamanwa pakta pushay Egipto allpama. Chay allpapi kipariychi kankunata rimanaynikama kutinaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Chasna chay angelka rimashpan Joseka atarishpan wawata mamanwa pakta pusharka Egipto allpama. Chaypi kawsarkakuna apu Herodes wañunankama. ");
INSERT INTO qupNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Chasna paktarishka Yaya Diospa ñawpa rimashkanka, imashnami paypa yachayninwa yachachik Yaya Dios payta yuyachishpan rimarka kasna: Chay Egipto allpamanta Wawaynita kayarkani shamunanpa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Chay apu Herodeska yankamanta chaparka chay yachakkunata. Kunanka ñukata llullachiwashkakuna nishpa yuyarirka. Chayrayku yapa piñarirka. Chaypina timputa yuparka ima urasmi chay istrillaka puntiru rikurishka karka, imashnami chay yachakkunaka rimarkakuna. Chaywasha suntalunkunata Belén llaktama, kuchunpi kahuk uchilla llaktakunamapas kacharka tukuy manara ishkay watayu kari wawastukunata wañuchinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Chasna chay wawakunata wañuchishpankuna Yaya Diospa yachayninwa yachachik Jeremiaspa ñawpa killkashkan paktarirka. Payka killkarka maykanmi pasanan karka Belén llakta kuchupi, Ramá shutiyu llaktapi kasna nishpa: ");
INSERT INTO qupNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ramá llaktapi yapa llakiywa kaparishpa wakahukkunata uyankakuna. Israel runakuna wakanahun wawankuna wañuchiy tukushkankunarayku. Mana nima pi atipankachu paykunata kushillayachinata. ");
INSERT INTO qupNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodes wañushkanwasha Yaya Diospa angelka chay Egipto allpapi Joseta puñuhushkanpi rimarka: ");
INSERT INTO qupNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Atariy, chay wawata mamanwa pakta pushay. Kutiychi Israel allpaykichima. Chay wawata wañuchinayak runakunaka ñami wañushkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Chaypina Joseka angelta kasushpan chay wawata mamanwa pakta pusharka Israel allpanchima. ");
INSERT INTO qupNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ñampipi rihushpankuna Joseka yachashpan Herodespa wawan Arkelao Judea allpapi kamachik kananta, mancharka Judeama rinata. Yaya Dios muskuyninpi rimashpan Galilea allpamana rirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Chaypi paktashpankuna rirkakuna Nasaret llaktapi kawsanankunapa. Yaya Diospa yachayninwa ñawpa yachachikkuna rimarkakuna maykanmi pasanan karka: Nasaret llaktapi kawsashkanrayku paytaka shutiyachinkakuna Nasareno nishpa. Chayraykumi Jesustaka shutiyachirkakuna Nasareno. ");
INSERT INTO qupNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tukuy chaykuna unay pasashkanwasha Juanka rirka Judea allpapi chunlla chakishka allpama. Chaypi shamushka runakunata Yaya Diospa shiminta yachachirka. Achka runakunata bawtisashkanrayku payta shutiyachirkakuna Bawtisak Juan nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Chaypi Juanka rimarka: Ñami kallarihun Yaya Diospa ali kamachinanka kay allpapi. Chayrayku alita yuyarishpaykichi tukuy millaypa rurashkaykichita sakiychi payta kasunaykichipana nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Chay Juan shamunanmantami ñawpa Yaya Diospa yachayninwa yachachik Isaias wañuka killkarka: Chunlla chakishka allpapimi shuk runa sinchita rimashpa yachachinka kasna: Imashnami shuk anchu ñampita alichanchi, atun apu shamushpan purinanpa, chasnashina shunkuykichita alichariychi. Millaypata rurashpa kawsashkaykichita sakiychi. Yaya Diospa Kachanan Kishpichik kankunapi kawsak shamunka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juanpa churarishkanka shuk pukripa churarinanshinami karka, wiwa kamillupa willmanmanta awarishka. Sinturunka karamantalla karka. Mana mikupayarkachu ñukanchipa mikunanchitashina. Mikupayarka upyapayarka imatachari taripayarka chay chunlla chakishka allpapi, atun muru chilikkunata, mapa mishkitapas. ");
INSERT INTO qupNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Chaypina tukuy Judea allpapi llaktakunamanta, Jerusalén llaktamantapas, Jordán yaku mayanmantapas achka runakuna shamurkakuna Juanpa yachachihushkanta uyanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Chayta uyashpankuna uchankunata musyashpankuna rimarkakuna. Chasna rimashkankunawasha Juanka paykunata chay Jordán yakupi bawtisarka. ");
INSERT INTO qupNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Chaymanta fariseokuna saduseokunapas rirkakuna bawtisarinankunapa. Juanka paykunata rikushpan rimarka: Machakuyashina runakuna kankichi yachachinaykichiwa runakunata pantachichishpa yuyayninkunata waklichikkuna. ¿Pita kankunata rimashka ña kuchuyamuhushkan Yaya Diospa manchaypa kastigananmanta chasnalla kishpinaykichipa? ");
INSERT INTO qupNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Manara bawtisarihushpaykichira alitana ruraychi rikuchinaykichipa Yaya Diosta kasuk kanaykichita. ");
INSERT INTO qupNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ama rimariychichu yaya rukunchi Abraham wañupa miraymantami kanchi, chayrayku Yaya Dioska kishpichinka ñukanchikunata nishpa. Yaya Dios munamaka, kay rumikunamanta rurama yaya ruku Abrahampa mirayninta. ");
INSERT INTO qupNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Rikuychi, shuk tarpu kaspi mana alita muyuyashpanka amunka sapinpi achawa kuchushpan ninapi rupachin. Chasnallatatami Yaya Dioska tukuy mana ali rurak runakunataka wichunka ninama rupanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Kankuna millaypata rurashkaykichita amirishpa sakishpaykichika ñukaka yakullawami bawtisashkaykichi Yaya Diosta katinaykichipa. Ñukamanta ashwan yachayyu runami shamunka. Paymantaka ñukaka mana yapa yachayyuchu kani. Paypa puntanpi nima imata atipanichu rimanata. Payka kankunata Yaya Diospa Espiritunta kushpami shunkuykichita aliyachinka. Ninawa rupachihushkashina uchaykichita pichanka payta kushilla katinaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yuyariychi, sarata triguta pallashpanchi tullunmanta muyuntana wishkunchi. Chay muyuntaka wakaychanchi, tullunkunataka ninapi rupachinchi. Chay shamuhuk runaka chasnallatata ruranka. Paymi tukuy kirikkunataka siluma pushanka. Mana kirikkunataka nina mana wañukma kachanka nishpa yachachirka Bawtisak Juanka. ");
INSERT INTO qupNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Chay uras Jesuska yuyarirka Juan bawtisawachun nishpan Galilea allpamanta Jordán yakuma rirka. Chaypi Jesuska Juanta tapurka payta bawtisananpa. ");
INSERT INTO qupNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Chasna tapushpanna Juanka payta mana bawtisanayarkachu. Kan ñukata bawtisawanayki imata, ñukata tapuk shamuwanki kanta bawtisanaynipa nishpa rimarka Juanka. ");
INSERT INTO qupNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Chaypina Jesuska aynirka: Tukuy Yaya Dios ñukanchita kamachishkanta kasunanchi tiyan. Chayrayku kanmi bawtisawanayki tiyan nishpa. Chaypira Juanka payta bawtisarka. ");
INSERT INTO qupNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Bawtisarishkanwasha Jesuska yakumanta llukshirka. Chaypi siluka paskarishpan Jesuska rikurka Yaya Diospa Espiritunta shuk wiwa mukukushina paypi uraykumuhushkanta. ");
INSERT INTO qupNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Chaypina silumanta Yaya Diospa rimashkanta uyarkakuna: Kay Jesuska munashkayni wawaynimi. Paymi sumakta kushichiwan nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Chaymanta Jesús bawtisarishkanwasha Yaya Diospa Espiritunka payta pusharka chunlla chakishka allpama. Chayma pusharka supayka kamananpa, shutipachu Yaya Diosllata kasun nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Chaypi Jesuska mana mikushpa karka chusku chunka punchata, chusku chunka tutata. Chaywasha yapa yarkarka. ");
INSERT INTO qupNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Chaypi supayka Jesusta kayllayashpan kamarka shutipachu Yaya Diosllata kasun nishpa. Shutipa Yaya Diospa Wawan kashpaykika rimay kay rumikunata pan tukunanpa, chayta mikunaykipa. ");
INSERT INTO qupNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Chaypina Jesuska aynirka: Nima imashna rurashanchu. Yaya Diospa killkachishkanpi riman: Mana mikunawallachu runaka kawsan. Ashwan Yaya Diospa rimashkanta kasushpanmi kawsanka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Chaymanta supayka Jesusta pusharka Yaya Diospa munashkan Jerusalén llaktama. Chaypi Yaya Diospa wasin awama sikachirka. ");
INSERT INTO qupNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Chaypina Jesusta rimarka: Shutipa Yaya Diospa Wawan kashpaykika saltay kay awamanta allpama. Yaya Diospa killkachishkanpi riman: Yaya Dioska angelkunata kachanka kanta kuyranankunapa. Paykunami makinkunapi kanta alita kuyrankakuna mana nima rumipi waktarinaykipa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Chaypina Jesuska aynirka: Nima imashna rimawashpayki saltashanchu. Yaya Diospa killkachishkanpi kaytapas nin: Ama Yaya Diosta yanka kamankichu yachanaykipa payka yanapawankachu manachu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Chaymanta supayka Jesusta pusharka yapa awa urku awama. Chay urku awamanta tukuy kay allpapi kamachik atun apukuna kamachinan allpakunata, suma atipak kanankunata, yapa suma rikurihushkankunata rikuchirka. ");
INSERT INTO qupNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Chaypina rimarka: Ñukata kunkurishpa mañawashpaykika tukuy kay rikuhushkaykita kushkayki nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Chaypina Jesuska aynirka: Nima imashna kanta kunkurishpa mañashanchu. Ñukamanta anchuriy Satanás supaykunapa apun. Yaya Diospa killkachishkanpi nin: Yayaykichi Diosllata kunkurishpa mañaychi. Payllata kasushpa kawsaychi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Chasna Jesús sinchita Yaya Diospa yachayninwa rimashpan supayka anchurirka. Chaypina Yaya Diospa angelkunaka Jesusta kayllayarkakuna yanapanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Chaymanta Jesuska yachashpan Bawtisak Juanta karselpi churashkankunata, Galilea allpama kutirka. ");
INSERT INTO qupNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Galileapi Nasaret kikin llaktanmanta llukshishpan Kapernaum llaktama kawsananpa rirka Galilea allpallapillatata. Chay llaktaka karka Galilea kucha mayanpi, chay chunka ishkay israel runakunapa ayllunkunamanta Sabulonpa, Neftalipa miraykunapa allpankunapi. ");
INSERT INTO qupNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Chayma rishpan Jesuska paktachirka Yaya Diospa yachayninwa ñawpa yachachik Isaiaska killkashkanta kasna nishpa: ");
INSERT INTO qupNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Tukuy kankuna Galilea allpapi kawsak Yaya Diosta mana kasuk, Galilea atun kucha mayanpi, Jordán yaku mayanpipas kahuk Sabulonpa, Neftalipa miraykunapa allpankunapi chapurishka kawsakkuna, uyaychi Yaya Dios kankunarayku rimashkanta kasna: ");
INSERT INTO qupNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Tukuy chay runakuna mana alita rurashpa amsapishina kawsakkunaka Yaya Diospa yachayninta atun suma punchayaktashina rikunkakuna. Chay runakuna wañunankunata yapa manchashpa kawsahushpankuna yapa suma punchayachiktashina Yaya Diospa ali shiminta kishpichinanmanta uyankakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Chaymanta pacha Jesuska kallarirka yachachinata: Ñami kallarihun Yaya Diospa ali kamachinanka kay allpapi. Chayrayku tukuy mana ali rurashkaykichita sakiychi payta kasunaykichipana nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Chaymanta Galilea kucha mayanpi rihushpan Jesuska ishkay runa wawkipura kahukta rikurka. Paykunaka redinkunata yakupi kacharihurkakuna. Karkakuna Simón Pedro shutiyu wawkin Andreswa. ");
INSERT INTO qupNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Chaypina Jesús rimarka: Shamuychi, katiwaychi. Ñuka kankunata yachachisha. Imashnami kunankama challwata apishpa kawsashkankichi, chasnashinami kunanmanta pacha runakunatana yachachishpa purinkichi paykunapas Yaya Diosta kasunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Chasna rimashkanllapi chay rediyak runakunaka redinkunata sakishpa Jesustana katirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Chaymanta astalla chay kucha mayanta rihushpankuna Jesuska rikurka Sebedeopa wawankuna Santiago wawkin Juanwa pakta kahukkunata. Botinkunapi yayanwa redinkunata rimintahurkakuna. Chaypi Jesuska chay ishkay runakunatapas kayarka paywa pakta purinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Chaypina atarishpankuna yayankunata botinpi sakishpa Jesuswa pakta rirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Chaymanta Jesuska runankunawa tukuy chay Galilea allpa llaktakunapi yachachishpa purirka tukuy chay israel runa masinchikunapa tantarinankuna wasikunapi. Chaypi yachachirka kay suma ali shimita Yaya Diospa ali kamachinan kay allpapi ña kallarishkanmanta. Chasna yachachihushpan Jesuska runakunata tukuy unkuyninkunamanta parisinankunamantapas ampipayarka. ");
INSERT INTO qupNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Chay Siria allpa llaktakunapi achkata rimarkakuna Jesuspa yachachihushkanmanta, unkushkakunata ampihushkanmantapas. Chayrayku Jesusma aparkakuna chikan chikan unkuyyukunata, nanayyu runakunata, supay yaykushka runakunatapas, kunkaymanta sinchiyarik kuchparik unkushkakunata, chakichik unkuyyukunatapas. Tukuy chay unkushkakunata Jesuska ampirka. ");
INSERT INTO qupNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Chaymanta achka runakuna Galilea allpapi llaktakunamanta, Chunkallakta shutiyumanta, Judea allpapi llaktakunamanta, Judeallapillatata Jerusalén llaktamanta, Jordán yaku chimpamantapas Jesusta katirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Chaymanta Jesuska chay achka runakunata rikushpan shuk luma awapi sikarka. Chaypi tiyarishpan payta katihukkunaka kayllayarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Chaypina Jesuska paykunata yachachirka kasna nishpa: ");
INSERT INTO qupNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Kushilla kankichi yuyarishpa kawsashpaykichika Yaya Dios mana yanapawashpanka nima imata atipanichu ruranata nishpa. Yaya Diosmi kankunata yanapanka wiñayparayku paypa ali kamachihushkanpi kawsanaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kushilla kankichi llakiywa kahushpaykichika. Yaya Diosmi kankunata sinchikuchinka. Uchaykichimanta llakirishpaykichika Yaya Dios kankunata llakichishpa yanapanka. ");
INSERT INTO qupNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kushilla kankichi mana piñarishpa, nima rimanakushpa kawsashpaykichika. Yaya Dioska chay mushu ruranan allpapimi kankunata churanka chaypi kawsanaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kushilla kankichi yarkahukshina upyanayahukshina Yaya Diospa munashkanta ruranayashpaykichika. Yaya Diosmi kankunata yanapanka paypa munashkanta rurashpa kawsanaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kushilla kankichi tukuy runa masikichita yuyashpa llakichishpa kawsashpaykichika. Yaya Dioska kankunatapas yuyashpanmi llakichinka. ");
INSERT INTO qupNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kushilla kankichi ali yuyayyu runakuna kashpaykichika. Yaya Diosta riksinkichi. ");
INSERT INTO qupNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kushilla kankichi shukwa shukwa alichak runakuna kashpaykichika. Yaya Dios kankunata alita rikunka wawaynikuna kankichi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Kushilla kankichi runakuna kankunata chiknishpa yanka parisichishpankuna Yaya Diospa munashkanta alita rurashpa kawsahushkaykichirayku. Chasna parisihushpaykichi Yaya Dios kankunata yanapanka wiñayparayku paypa ali kamachihushkanpi kawsanaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kushilla kankichi runakuna yankamanta millaypata kankunamanta rimashpankuna kankunata chiknishpa parisichishpankuna ñukaranti llullapi churashpa rimashpankuna. ");
INSERT INTO qupNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Chasnami ñawpa Yaya Diospa rimashkanta yachachikkunatapas chiknishpankuna parisichirkakuna. Chayrayku, kankunatapas parisichihushpankuna kushikuychi. Shuk puncha silupi paktashpaykichi Yaya Dios kankunata atunta kushichinanta yachashpaykichi kushikuychi. ");
INSERT INTO qupNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Imashnami kachiwa kachiyachinchi mikunata ali kananpa, chasnallatata kankunaka runa masikichita yachachishpa yanapankichi mana uchata ruranankunapa. Chamu kachika manami alichu kachiyachinanpa mikunata. Chasnataka apishpa wichunchi kanchama chaypina runakuna sarunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","15","Chaymanta shuk lamparinta apichishpanchi churanchi mesa awapi tukuy wasita punchayachinanpa. Chay apichirishkata mana churanchichu shuk kahun ukupi. Chaymantapas shuk llakta urku awapi kahukka mana atipanchu pakanata, tukuy runakuna rikunahun. Chay llaktatashinami chay lamparintashinami runa masikichika kankunata rikunkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Chasna kashpaykichika alikunallata rurashpa kawsaychi, tukuy runa masikichi rikushpankuna silupi kawsak Yaya Diosta agradesishpa kushichinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yaya Dioska ñawpa yaya rukunchikunata yachachirka kamachishkankunata kasushpa kawsanankunapa. Tukuy chayta Yaya Diospa yachayninwa yachachikkuna killkarkakuna. Ñukaka shamushkanimi tukuy chay killkashkankunapi rimashkanta ruranaynipa. Manami shamushkanichu kankunata rimanaynipa chay killkashkankunata manana kasushpa kawsanaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Alita uyawaychi. Tukuy chay Yaya Diospa yachachishkanta kankuna alita kasunaykichi tiyan kay allpa kay silu chinkarinankama. Tukuy rimashkanka paktarinkami. Nima shuk paypa shiminka yanka nishpa kanchu. ");
INSERT INTO qupNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kankuna mana imananchu nishpa shuklla Yaya Diospa kamachishkanta mana kasushpaykichika chaymanta shuk runakunatapas chasnallatata ruranankunapa yachachishpaykichika Yaya Diospa kamachinanpi tukuymanta mana valikchu kankichi. Ashwan Yaya Diospa kamachishkanta alita kasushpa kawsashpaykichika chaymanta chasnallatata runa masikichita yachachishpaykichika Yaya Diospa kamachinanpi tukuymanta ashwan valik kankichi. ");
INSERT INTO qupNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kankunata rimani, Moisespa killkashkanta yachachikkunamanta, fariseokunamantapas Yaya Diospa kamachishkanta ashwan alita paktachinaykichi tiyan. Paykuna paktachinanchi tiyan nishpa rimashpankunapas manami tukuy shunkunkunamanta pacha paktachinahunchu. Paykunamanta mana ashwan alita paktachik kashpaykichika manami Yaya Diospa kamachishkan tukushpa ali kamachihushkanpi kawsankichichu. ");
INSERT INTO qupNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yaya Dios ñawpa yaya rukunchikunata rimarka: Ama runa masikichita wañuchiychichu. Wañuchishpaykichika apumi kankunatapas kastiganan tiyan. ");
INSERT INTO qupNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kunan ñuka kankunata rimani, runa masikichita piñarishkaykichillawa kastigay tukunkichi. Chaymanta runa masikichita piñarishpa kamishpaykichika saserdotepa tantarishkan apunkuna kankunata ashwanta kastiganan tiyan. Chaymanta maykanpas runa masinta kushway wañunki nishpa yuminkashpanka nina mana wañukma kachay tukunka. ");
INSERT INTO qupNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Yaya Diospa wasinpi shuk imata kunayahushpaykika payta kushichinaykipa, kunkaymanta runata piñachishkaykita yuyarishpaykika manara kunayahushkaykita churahushpayki alichakriy chay piñachishkayki runawa. Chaywasha kutiy kunayahushkaykita Yaya Diosta kunaykipa. ");
INSERT INTO qupNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Shuk runata liwihushkaykimanta pay piñarishpan kanta apuma pushahushpanka manarapas paktahushpaykichira alichaychi mana apuka kanta liwishkaykimanta kastigananpa. Apupi mana atipashpayki alichanata runantami kunka karselpi churananpa. ");
INSERT INTO qupNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Chaymantaka manami llukshinkichu tukuy liwishkaykita paganaykikama. ");
INSERT INTO qupNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Kankuna yachankichi Yaya Dios ñawpa yaya rukunchikunata rimashkanta: Nima maykan warmiyu kari shuk warmiwa musayachun. Kusayu warmipas ama musayachun shuk kariwa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kunan ñuka kankunata rimani, maykanpas shukpa warminta munarishpa rikushpanka ñami yuyayninpi uchata rurashka. ");
INSERT INTO qupNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ñawiki rikushpan kanta uchata rurachinayashpanka ñawikita surkuhukshina sakiy mana uchata ruranaykipa. Ashwan ali kama shuk ñawillawa siluma rinaykipa, mana ishkanti ñawikiwa ninama wichuy tukunaykipa. ");
INSERT INTO qupNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Makiki uchata rurachinayahushpanka chay makikitaka pitihukshina sakiy mana uchata ruranaykipa. Ashwan ali kama shuk makillawa siluma rinaykipa mana ishkay makikiwa ninama rinaykipa. ");
INSERT INTO qupNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ñawpa yaya rukunchikunata rimarkakuna: Kasarashka kahushpayki warmikita sakinayashpaykika konsehuma riy killkachinaykipa kay warmitaka manami munaninachu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kunan ñuka kankunata rimani, warmiki mana shuk runawa musayashpanka ama sakiychu. Chay warmiwa alita kawsahushkaykita sakishpaykika uchatami ruranka shuk runawa. Shuk warmi sakirishkata warmiyahushpaykika uchatami ruranki. Warmipas kari sakirishkawa kawsahushpanka uchatami ruran. ");
INSERT INTO qupNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Kankuna yachankichi Yaya Dios ñawpa yaya rukunchikunata rimashkanta: Runakunapa puntankunapi shuk ruranaykichita rimashpaykichi Yaya Diospa rikushkanpi paktachinaynita rimani nishpa, ama llullashpa rimaychichu. Ashwan ñukata rimawashkaykichita paktachinaykichi tiyan nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kunan ñuka kankunata rimani, mana llullashpa tukuy uras shutipallata rimanaykichi tiyan. Chayrayku nima ima uras runakunapa puntankunapi rimahushkaykichita kirichinayashpa chay kirichinaykichi rimanakunawa rimaychichu. Yanka yuyarinkichi mana Yaya Diospa shutinta chay kirichinaykichi rimanakunapi churashpaykichika mana paktachishkaykichimanta mana yapa kastigay tukunaykichita. Chasna yuyaykichipi pantachishpaykichimi kankunata rimani: Nima siluta churashpa kirichina rimanakunawa rimaychichu, siluka Yaya Diospa kawsanan kashkanrayku maymantami tukuyta kamachin. ");
INSERT INTO qupNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nima allpata churashpa kirichina rimanakunawa rimaychichu, kay allpaka Yaya Diospa kamachinan kashkanrayku. Nima Jerusalenta churashpa kirichina rimanakunawa rimaychichu, atun apu Yaya Diospa munashkan llaktan kashkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nima kankuna kikinta churashpa kirichina rimanakunawa rimaychichu. Nima chukchaykichita atipankichichu yanayachinata nima yurayachinata tukuy uras chasnalla kiparinanpa, Yaya Dioslla kankunata rurashkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kankuna rimashpaykichika ari nishpa, ari kachun. Rimashpaykichika mana nishpa, mana kachun. Chay ari chay mana nishkaykichimanta ashwanta kirichinayashpa rimanakunaka millaypakunata rurachik supaypa yuyachishkanmi kan. ");
INSERT INTO qupNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Kankuna yachankichi ñawpa yaya rukunchikunata rimashkankunata: Shuk runa piñarishpan runa masinpa ñawinta waklichishpanka apuka paytapas chasnallatata kastiganan tiyan. Chaymanta shuk runa piñarishpan runa masinpa kirunta pakishpanka apuka payta chasnallatata kastiganan tiyan nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kunan ñuka kankunata rimani, ama rantipaychu shuk runa kanta millaypata rurashpanka. Uyaykipi sakmashpanka ama rantipaychu. Kutikashka sakmashpanpas ama piñarinkichu, ashwan alichay paywa. ");
INSERT INTO qupNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Chaymanta shuk runa kanta kichunayashpanka kamisaykita, kan ñukata liwiwashkanki, kamisayki raktata kuway nishpanka shuk kamisaykitapas kichunayashpanka sakiy, ama piñariychu payta. ");
INSERT INTO qupNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Shuk suntalu kanta rimashpanka shuk llasha wankurishkata mana pagashpa apanaykipa shuk waranka purina tuputa, ama piñariychu payta. Ari, apashami, munashpaykika ishkay waranka purina tuputapas apasha nishpa rimay. ");
INSERT INTO qupNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Imaykita kanmanta tapuk runata mana mitsashpa kuy. Imaykita prestananpa shamuk runata mana mitsashpa prestay. ");
INSERT INTO qupNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Kankuna yachankichi ñawpa yaya rukunchikunata rimashkankunata: Runa masikichita yuyaychi. Kankunata chiknik runakunataka chikniychi. ");
INSERT INTO qupNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kunan ñuka kankunata rimani, kankunata chiknik runakunataka yuyaychi. Shuk runakuna kankunata wañuchinayashpankunaka Yaya Diosta mañaychi paykunarayku. ");
INSERT INTO qupNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Chasna alita kawsashpaykichika silupi kawsak Yaya Diospa wawankunami kankichi, payshina yuyak kahushkaykichirayku. Paymi intita llukshichin alita rurak runakunarayku, mana alita rurak runakunaraykupas tukuy runakunata chasnalla yuyashpa yanapananpa. Chasnallatata tamyatapas kachan yanapananpa tukuy runakunata chasnalla. ");
INSERT INTO qupNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Yachanchi llullachik runakunapas ayllunkunata yuyanankunata. Kankuna chasnallatata aylluykichikunallata yuyashpaykichika paykunamanta mana ashwan alitachu rurahunkichi. Paykunashina rurashpalla kawsashpaykichika imamantata Yaya Dioska kankunata kushichinka. ");
INSERT INTO qupNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kankuna aylluykichillawa kwintak kashpaykichika shuk runakunawa mana kwintashpaykichika chay Yaya Diosta mana kirikkunamanta mana ashwan alitachu rurahunkichi. Paykunapas yuyashkankuna runa masinkunallawami kwintanahun. ");
INSERT INTO qupNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Imashnami silupi kawsak Yayanchi Dioska tukuy runakunata yuyan, chasnashina kankunapas tukuy runakunata yuyanaykichi tiyan. ");
INSERT INTO qupNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Kankuna runa masikichita yanapashpaykichika ama yuyariychichu, tukuy runakuna chay yanapashkaynita rikushpankuna rimankakuna yapa alita rurak runa kanaynita nishpa. Chasna tukunaykichillapa runa masikichita yanapashpaykichika silupi kawsak Yaya Dioska rurashkaykichimanta kankunata manami kushichinkachu. ");
INSERT INTO qupNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Chayrayku, shuk nima imayuta yanapashpaykika ama nima pita rimaychu. Ama ruraychu chay yanka nishpa rimak runakunashina. Paykunaka tantarinankuna wasikunapi ñampikunapipas shukma shukma rimashpa purinahun tukuy runakuna yachashpankuna nima imayu runakunata yanapashkankunata paykunata atunyachinankunapa. Alita uyawaychi. Chasna yanapak runakunataka Yaya Dioska mananami kushichinkachu. Runakuna paykunata kushichishkankunallawa kiparinkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nima imayu runakunata yanapashpaykika ama nima pita rimaychu, nima yuyashkayki amiguykita kwintaychu yanapashkaykimanta. ");
INSERT INTO qupNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Chunllalla rurashpaykika Yaya Dioska chay nima pi yachashkan rurashkaykita rikushpan alita rurashkaykimanta kanta kushichinka. ");
INSERT INTO qupNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Kankuna Yaya Diosta mañahushpaykichika ama ruraychichu chay yanka nishpa rimak runakunashina, maykankunami kirichinayanahun alita kasukmi kani nishpa. Paykunaka tantarina wasikunapi, ñampikunapipas tukuy runakuna rikuhushkankunapi shayarishpankuna Yaya Diosta mañanahun. Chasna ruranahun runa masinkuna paykunata rikushpankuna rimanankunapa, chay Yaya Diosta mañak runa alita kasukmi nishpa. Alita uyawaychi. Chasna rurak runakunataka Yaya Dioska mananami kushichinkachu. Runakuna paykunata kushichishkankunallawa kiparinkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Yaya Diosta mañanayashpaykika kwartuykipi yaykuy. Punkuta tapashpa sapallayki Yaya Diosta mañay. Payka kanwa tantaylla kashpan tukuy rimashkaykita uyanmi. Chasna nima pi yachashkan mañashkaykita rikushpan alita mañashkaykimanta kanta kushichinka. ");
INSERT INTO qupNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ama chay mana israel runakunashina mañaychichu. Paykunaka yanka diosninkunata mañanahun chay shimikunallata achka kuti rimashpa. Chasna mañashpankuna yuyarinahun diosninkuna paykunata ashwan alita uyanankunata. ");
INSERT INTO qupNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kankunaka Yaya Diosta mañahushpaykichika ama paykunashina ruraychichu. Manarapas Yaya Diosta mañahushpaykichira paymi yachan tukuy munahushkaykichita. ");
INSERT INTO qupNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Chayrayku kasna rimashpa mañaychi: Yaya Dios, kanllami kanki yayanchika. Silupi kawsak kashpayki yanapay tukuy runakuna kan yapa ali kanaykita yuyanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kay allpata ali kamachinaykita ruray. Imashnami silupi munashkaykita ruranahun, yanapay chasnallatata kay allpapipas runakuna munashkaykita rurashpa kawsanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Karan puncha ñukanchita kuy mikunanchita. ");
INSERT INTO qupNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Llakichiy ñukanchita mana alita rurashkanchikunamanta. Imashnami ñukanchikuna runa masinchikunata llakichinchi mana alita ñukanchita rurashkankunamanta, chasnallatata ñukanchitapas llakichiy. ");
INSERT INTO qupNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Anchuchiy ñukanchita supaymanta. Ama sakiychu pantachichisha nishpa pay ñukanchita sinchita kamashpan mana alikunata rurananchipa. Ashwan kishpichiy ñukanchita tukuy mana alikunamanta. Chasna kachun. ");
INSERT INTO qupNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kankuna runa masikichikunata llakichishpaykichika kankunata mana alita rurashkankunamanta, silupi kawsak Yayanchimi kankunatapas tukuy millaypata rurashkaykichimanta llakichinka. ");
INSERT INTO qupNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kankuna runa masikichita mana llakichishpaykichika Yayanchika manami kankunataka llakichinkachu uchaykichikunamanta. ");
INSERT INTO qupNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Kankuna Yaya Diosta yuyarishpa maykan punchami mana mikushpa kahushpaykichika ama uyaykichika llakirishkashina kachun, chay yanka nishpa rimak runakunapashina. Yapa munashpankuna tukuy runakuna yachanankunapa yarkay wiksa chishiyahushkankunata llakirishka uyayu tukunahun. Alita uyawaychi. Chasna rurak runakunataka Yaya Dioska mananami kushichinkachu. Runakuna paykunata kushichishkankunallawa kiparinkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Mana mikushpa Yaya Diosta mañahushpaykichika uyaykichita alita mayllaychi, chukchaykichita alita ñakchariychi kushilla rikurinaykichipa, nima pi yachananpa mana mikushpa kahushkaykichita. Yaya Dioslla yachachun chasna kahushkaykichita. Chay nima pi yachashkan rurashkaykichita rikushpan alita rurashkaykichimanta kankunata kushichinka. ");
INSERT INTO qupNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Kay allpapira kawsahushpaykichi ama imaykichikunata mirachishpa kawsaychichu. Shuk imakunata kumehenkunaka mikunahun, shuk imakunaka ismunahun. Chaymanta shuwakunapas wasikichipi yaykushpankuna imaykichikunata apanahun. ");
INSERT INTO qupNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ashwan Yaya Diosta alita kasushpa kawsaychi tukuy chay silupi kahuk sumakunata apinaykichipa. Chaypi nima shukta kumehen mikunchu, nima shuk ismunchu, nima shuwakuna yaykunahunchu apanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Chayrayku alita yuyariychi imatata ashwanta munankichi. Imaykichikunata mirachishpa kawsahushpaykichika chayllatami yuyarinkichi tukuy shunkuykichimanta pacha. Yaya Diospa munashkanta rurashpa kawsahushpaykichika tukuy shunkuykichimanta pacha payllatami yuyankichi. ");
INSERT INTO qupNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","Ñawinchika ñukanchirayku punchata rikuchikmi. Ñawikichi ali kashpanka alita rikuk punchapi purihushkashina kawsankichi. Ñawikichi mana ali kashpanka amsapi purihushkashina kawsankichi. Tukuy kankunapi punchata rikuchikshina tukuyta alita riksichik asirtachik kashkaka waklishpa amsashina tukushka kashpanka nima imata asirtashpa yapa manchaypa amsa tutapi purihushkashinami kawsankichi. ");
INSERT INTO qupNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Nima maykan kamachishkan runa atipanchu chay ratulla ishkay patroyninrayku tarawanata. Shukllata kasunan tiyan. Shuk patroyninta kasushpanka shuktaka mana kasunkanachu. Kankunaka chay tarawak runashinami kankichi. Kullkita munashpalla kawsashpaykichika manami atipankichinachu Yaya Diosta kasushpa kawsanata. ");
INSERT INTO qupNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Chayraykumi kankunata rimani, ama muspariychichu, ¿imatashi mikusha, imatashi upyasha kawsanaynipa? nishpa. Kawsananchimi mikunamanta ashwan valik kan. Chasnallatata ama yuyariychichu ¿imatashi churarisha? nishpa. Aychanchimi churarinamanta ashwan valik kan. ");
INSERT INTO qupNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Rikuychi, imashnami pishkukunaka pawashpa kawsanahun. Paykunaka nima shuk muyuta tarpunahunchu mikunankunapa. Paykunapaka nima tampunkunaka tiyanchu pallashkankunata wakaychanankunapa. Mana nima shuk muyuta tarpushpankunapas silupi kawsak Yaya Diosmi paykunataka achka muyukunata kun mikunankunapa. Ashwan kankunataka Yaya Dioska pishkukunamanta pasatami yuyan, tukuy munashkaykichita kun. ");
INSERT INTO qupNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Chaymantapas kawsanaykichita yapa yuyarishpaykichipas nima shuk urata atipankichichu mirachinata. ");
INSERT INTO qupNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Mana nima chayta atipashpaykichika ¿imaraykuta musparinkichi imawami llachapaynita rantisha nishpa? Rikuychi chay suma sisakunata, imashnami wiñanahun. Paykunaka nima tarawanahunchu, nima puchkanahunchu llachapankunarayku. Mana tarawashpankunapas suma churarishkashina kanahun. ");
INSERT INTO qupNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ñawpa atun apu Salomón wañupa yapa suma ali churarishkanmanta chay sisakunaka ashwan alita rikurinahun. ");
INSERT INTO qupNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kiwakunaka chakirinalla, rupachinalla kashpankunapas Yaya Dios suma sisayukunata ruran. Chayta rikushpaykichi ¿imaraykuta mana kirinkichichu Yaya Dios kankunataka ashwan alita kuyrananta? ");
INSERT INTO qupNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Yaya Dioska kiwa sisakunamanta kankunataka ashwantami yuyan. Chayrayku ama musparishpa kawsaychichu, imatashi mikusha, imatashi upyasha, imatashi churarisha nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Yaya Diosta mana riksik runakunami chasna yuyaywa kawsanahun. Kankunaka ama paykunashina kawsaychichu. Ashwan kankunapaka tiyanmi alita kuyrak silupi kawsak Yayaykichi Dios. Paymi alita yachan imakunami pishin kankunapaka. ");
INSERT INTO qupNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Chayrayku tukuy shunkuykichimanta pacha munaychi Yaya Dios kankunata kamachinanta, paypa munashkanta rurashpa kawsanatapas. Chasna kawsashpaykichimi payka tukuy munashkaykichitapas kankunata kunka. ");
INSERT INTO qupNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Tukuy puncha Yaya Dios yanapak kashpan ama yapa yuyarishpa rimaychichu kayaka imashi pasawanka nishpa. Kayantimapas Yaya Diosta yuyashpaykichika payka yanapankallami. Chasna kashpan ama musparishpa yuyariychichu kayarayku, kayawasharaykupas. ");
INSERT INTO qupNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ama shuk runa masikichimanta rimaychichu payka mana alichu kan nishpa. Chasna rimashpaykichika Yaya Dioska kankunamantapas rimanka paykunaka mana alichu kanahun nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Imamantachari kankuna runa masikichimanta rimankichi payka mana alichu kan nishpa chaymantallatatami Yaya Dioska kankunamantapas rimanka paykuna mana alichu kanahun nishpa. Imashnami kankuna munankichi runa masikichi kastigay tukunanta, chasnallatatami kankunapas kastigay tukunkichi. Maykantachari kankuna chapankichi runa masikichi rurananpa chaymantallatatami Yaya Dioska kankunatapas tapunka. ");
INSERT INTO qupNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","5","Runa masikichipa ñawinpi shuk uchilla susyastu tiyamaka, shuk ratu rikunkichima. Ashwan kankunaka kikin ñawikichipi ashwan atun susya tiyamaka, mana rikunkichimachu. Ñawikichipi ashwan atun susya tiyamaka runa masikichipa ñawinpi kahukmanta, mana alichu kama payta rimanaykichipa ñawikimanta susyata surkushara nishpa. Chasna rurankimaka kan kikintami llullachirinkima. Ashwan puntiru kan kikinpa ñawikimantara chay atun susyata surkuy. Chaymanta alita rikushpayki runa masikipa ñawinmanta chay uchillastu susyata surkuy. Chasnallatata puntiru kan kikinpa uchaykita sakinayki tiyan. Chaypirami atipankichi runa masikita kunanata paypa uchanta sakinanpa. ");
INSERT INTO qupNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Chaymanta Yaya Diospa shiminta ama yachachiychichu mana kasunayak runakunata. Chasna runakuna allkukunashina, kuchikunashina mana yuyayyuchu kanahun. Paykunata yachachishpaykichika yapa chaniyu wallkata kuchikunarayku wichuhukshina kankichima kuchikunaka saru saru ruranankunapa. Chasnallatata shuk runakuna Yaya Diospa shiminta mana munanahunchu, nima uchillastuta. Paypa shiminka yapa chaniyushina kashpanpas paykuna mana valichishpa asichinahun. Kankunata chiknishpa piñarinahun. Chayrayku maykankunami Yaya Diospa shiminta munanahun, paykunallata yachachiychi. ");
INSERT INTO qupNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yaya Diosta tapushpaykichika payka munashkaykichita kunkami. Maskashpaykichika Yaya Diosta, payta tarinkichimi. Silupi yaykunayashpa punkunpi kayashpaykichika Yaya Dioska paskankami. ");
INSERT INTO qupNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Maykanmi tapun, paytaka kunkami. Maykanmi maskan, tarinkami. Maykanmi punkupi kayan, payraykuka paskankami. ");
INSERT INTO qupNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Alita yuyariychi. Wawaykichi panta tapushpanka kankunaka mana rumita kunkichimachu mikunanpa. ");
INSERT INTO qupNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Challwata tapushpanka mana machakuyata kunkichimachu mikunanpa. ");
INSERT INTO qupNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kankuna mana alita rurashpa kawsakkuna kashpaykichipas wawaykichita alikunallata kunkichi. Ashwan silupi kawsak Yayanchika kankunata alikunallatami kunka payta tapushpaykichika. ");
INSERT INTO qupNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Kankuna munashpaykichika runa masikichi kankunarayku alita ruranankunapa, ashwan kankunara paykunarayku alita ruraychi. Chasnallatata Moisespa killkashkanta yachachikkuna, Yaya Diospa yachayninwa yachachikkunapas ñawpamanta pacha ñukanchita yachachirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Kankuna ñañu punkutashina yaykuychi. Achka runakuna paykuna kikinpa munashkankunallata rurashpa kawsanahun. Paykuna anchu punkutashina yaykushpa anchu ñampipi purihukshina kanahun. Chay anchu ñampipi purihukshina kashpankuna nina mana wañukma paktankakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Chaymanta mana achka runakunachu Yaya Diospa munashkanta rurashpa kawsanahun. Paykunaka ñañu punkutashina yaykushpa ñañu ñampipi purihukshina kashpankuna parisishpa kawsanahun. Chay ñañu ñampipi purihukshina kashpankuna Yaya Diospa kawsananpi paktankakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Kankunaka alita kuyrariychi llullachishpa yachachikkunamanta. Paykunaka Yaya Diospa rimashkanta alita yachachihunchi nishpa Yaya Diosta alita kasukshina rikurinahun. Chasna kashpanpas mana tukuy shunkunkunamanta pachachu payta katinahun. Chayrayku mana ali yuyayyu kashpankuna kankunata pantachichinkakuna manana payta kasushpa kawsanaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Chasna llullachik runakunataka kawsanankunamantami riksinkichi. Rikuychi, millaypa kasha kaspika mana muyuyamachu ali muyuta. Chinikunaka mana muyuyamachu mishki mikuna muyuta. ");
INSERT INTO qupNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Shuk ali kaspika ali muyullata muyuyan. Millaypa kaspika mana mikuypa millaypa muyuta muyuyan. ");
INSERT INTO qupNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ali kaspika mana atipanchu muyuyanata millaypa muyuta. Nima millaypa kaspika atipanchu muyuyanata ali muyuta. ");
INSERT INTO qupNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tukuy millaypa tarpukunataka pitishpa ninama wichunchi, mana alita muyuyashkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Chayrayku yachachikkunata kawsanankunamantami riksinkichi ali yachachikkunachu kanahun manachu. ");
INSERT INTO qupNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Maykankunami Yayayni Jesús, Yayayni Jesús yanka nishpa rimanahun, Yaya Diosta mana tukuy shunkunkunamanta pacha katihushpankunaka chaykunaka Yaya Diospa kamachishkan tukushpa paypa ali kamachihushkanpi manami kawsankakunachu. Ashwan maykankunami ruranahun Yayaynipa munananta, chaykunallami kamachihushkanpi kawsankakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ñuka shamuhushkayni puncha rimasha, maykankunami siluma rinkakuna, maykankunami mana rinkakunachu. Chay puncha achka runakuna rimawankakuna: Yayayni Jesús, Yayayni Jesús, ñukanchimi kanpa shutikipi yachachirkanchi, kanpa shutikita rimashpa supaykunata llukshichirkanchi. Chaymanta kanpa shutikita rimashpa atun yachaywa achka ruranakunata rurashkanchi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Chaypina paykunata aynisha: Kankunaka yanka llullashpa shutinipi rimarkankichi. Mana ñukata katiwashkankichichu. Millaypata rurakkuna kashpaykichi mana runaynikunachu kankichi. Chasna kashpaykichi anchuriychi ñukamanta nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Maykanmi rimashkaynita alita kasushpa kawsan, chaymi shuk alita yuyarik runashina kan. Chay runaka luma awapi uchkukunata allashpan orkonta sumakta shayachishpan wasinta rurashka. ");
INSERT INTO qupNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Sinchita tamyashpan yaku untayka shamushpan sinchi wayra wasinta waktashpan mana urmankachu, luma awapi orkonkunaka sumakta shayachirishka kashkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Maykanmi rimashkaynita mana kasunchu, chaymi shuk mana alita yuyarik runashina kan. Payka wasinta ruran tiyupi, mana yapa ukuta allashpan urkunkunata shayachin. ");
INSERT INTO qupNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Sinchita tamyashpan yaku untayka shamushpan wayraka chay wasita waktashpan utkalla urman. Chasna urmashpan paki paki tukun. ");
INSERT INTO qupNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Jesús yachachishkanta tukuchishpan tukuy runakuna mancharishpankuna paykunapura rimarkakuna: Kay Jesuska Yaya Diospa yachayninwami yachachin. Tukuy kay Moisespa killkashkanta yachachikkunamanta yapa alitami ñukanchita yachachin nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesuska chay lumamanta uraykumuhushpan achka runakuna payta katirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Chasnallapi shuk aycha ismuchik unkuyyu runaka, nima pita kayllayanata atipashpantata Jesusta kayllayarka. Puntanpi kunkurishpan rimarka: Yaya Jesús, yachani ampinata atipawanaykita. Kanrayku ali kashpan kay unkuynimanta ampiway, ampirishpayni kuti atipanaynipa tantaylla kawsanata aylluynikunawa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Chaypina Jesuska chay runataka makinwa llankashpan nirka: Ari, munanimi. Ñami ampirishkanki. Chasna nishkanllawa chay runaka tukuy unkuyninmanta ampirishka karka. ");
INSERT INTO qupNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Chaymantapas rimarka: Ama nima pita kwintankichu kanta ampishkaynimanta. Kunanka saserdotellama riy ampirishkaykita rikunanpa. Chaymanta ñawpa Moisespa killkashkanpi kamachishkatashina ruray, Yaya Diosta kunayki kashkata apashpa churak rinki. Chasna rurashkaykimantami tukuy runakuna yachankakuna unkushkaykimanta ampirishkaykita. ");
INSERT INTO qupNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kapernaum llaktapi paktashpan shuk kapitan Jesusta kayllayarka. Payka Roma llaktamanta suntalunkunata kamachik karka. Chaypi Jesusta tapurka yanapananpa: ");
INSERT INTO qupNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Yachachik, shuk runaynimi wasinipi yapa unkushkalla kawsan. Mana kuyurinata atipanchu. Yapa nanaywa parisishpa kawsan. ");
INSERT INTO qupNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Chaypi Jesuska aynirka: Wasikima rishpayni paytaka ampisha. ");
INSERT INTO qupNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Chaypina chay kapitanka Jesusta aynirka: Yachachik, ñukaka mana nima imachu kani wasinipi yaykunaykipa. Kaymantalla rimashpayki atipankimi runaynita ampinata. ");
INSERT INTO qupNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ñukapapas tiyanmi apuynikuna kamachiwanankunapa. Paykuna kamachiwashpankuna kasunayni tiyan. Chasnallatata ñuka suntaluynikunata kamachishpayni paykunapas kasuwanankuna tiyan. Shuk suntaluta maymapas rinanpa rimashpayni kunalla kasushpa rin. Shukta kayashpayni utkalla kasushpan shamun. Chaymanta shuk runaynita imatapas rurananpa rimashpaynika kunalla ruran. Chasnallatatami shuk shimillawa atipanki anchuchinata unkuyta chay runaynimanta. ");
INSERT INTO qupNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Chay kapitan chasna rimashpan Jesuska yapa kushikurka. Chaymanta tukuy chay katihukkunata rimarka: Kankunata rimani, tukuy israel masinikunamanta nima maykan ñukata tukuy shunkunmanta pacha kiriwashkanta tarishkanichu kay romano runatashina. Ñukanchi israel runakuna Yaya Diospa akllashkankuna kashpanchitata kankunaka mana kay runashinachu kiriwankichi. ");
INSERT INTO qupNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Chayrayku kankunata rimani, shuk punchami Yaya Dioska tukuy payta kirikkunallata, mana israel runakuna kashpankunapas tantachinka inti llukshinamanta, inti yaykunamantapas. Chaypi ñawpa yaya rukunchikuna Abrahamwa, Isaakwa, Jakobwa pakta Yaya Diospa kamachinan mushu mundupi tiyarinkakuna mikunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ñukanchi israel runakuna Yaya Diospa akllashkankuna kashpanchipas Yaya Diospa kamachinankuna kananchipa, achka kankunamanta ñukata mana kirishkankunarayku manchaypa amsamami wichuy tukunkakuna. Chaypi sinchita parisishpa wakankakuna, piñaywa kirunkunata kanirinkakuna nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Chaypina kapitanta rimarka: Tukuy shunkuykimanta pacha ñukata kiriwashkaykirayku runaykita ampishkani. Chayrayku kutiy wasikima nishpa. Chasna rimashkanllapi chay romano kapitanpa runanka ña ampirishka karka. ");
INSERT INTO qupNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Chaymanta Jesuska Pedropa wasinma rirka. Chaypi Pedropa warminpa mamanta tarik rirka kalinturawa sirihukta. ");
INSERT INTO qupNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Chaypina Jesuska chay warmipa makinta llankashpan kalinturanka pasapurka. Chay ratulla payka atarishpan Jesusta runankunatapas upyachirka kararka. ");
INSERT INTO qupNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ña amsayahushkanpi achka supay yaykushka runakunata pushamurkakuna Jesusma. Chaypi Jesuska shuk rimashkanllawa chay supaykunataka llukshichirka. Unkushka runakunatapas tukuyta ampirka. ");
INSERT INTO qupNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Chasna Yaya Diospa yachayninwa yachachik Isaias ñawpa paymanta killkarka: Pay kikin parisishpan nanaykunata, unkuyninchikunamanta ampiy tukushunchi. Tukuy ima nanaykunamanta ñukanchita aliyachinka nishpa. Chay killkashkanpi rimashkanshina Jesuska runakunata tukuy unkuykunamanta ampirka. ");
INSERT INTO qupNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Shuk puncha kutikashka achka runakuna Jesuspa kuchunpi tantarirkakuna. Jesuska paykunata rikushpan runankunata rimarka: Akuychi chimpashunchi kay kuchata nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Manara botipi yaykuhushpankunara Moisespa killkashkanta shuk yachachik Jesusta kayllayashpan rimarka: Yachachik, maytapas rishpayki kanta katisha nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesuska payta aynirka: ¿Imata yuyarishpaykita katinayawanki? Rimashkaykichi, mahaskunapa tiyan uchkunkunaka. Pishkukunapapas tiyan wasinkunaka maypimi kawsanahun. Ñuka Yaya Diospa Kachashkan Runaka mana wasiyuchu kani maypimi samasha. ");
INSERT INTO qupNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Chaypina Jesusta shuk katik runa payta rimarka: Yachachik, kanwa rinayashpaynipas manara atipanichu kunallaka. Yayaynita munanira kuyranata wañunan punchakama. Paypa aychanta allarishka urku uchkupi churashpa tapashkayniwasha kanwa risha. ");
INSERT INTO qupNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Chasna rimashpan Jesuska mana munarkachu. Kunalla aku ñukawa rishu. Sakiy Yaya Diospa shiminta mana kasunayak runakunaka wañushkankunata urku uchkupi churashpa tapanankunapa. Yayayki wañushpanka paykunami paypa aychanta uchkupi churashpa tapankakuna nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Chasna kwintashkankunawasha Jesuska runankunawa pakta shuk botipi uraykurkakuna kuchata chimpanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Chimpahushkankunapi kunkaymanta atun wayra shamurka. Chay wayraka yapa sinchita wayrahushpan atun ulaskuna shayarirkakuna. Botinkunapi yakuka untarihushpan ña tikranayarkakuna. Chay yaku wayrawa yapa ulasyahushpanpas Jesuska botipi puñurayahurka. ");
INSERT INTO qupNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Chaypina paypa runankunaka yapa mancharishpankuna likchachirkakuna Jesusta. ¡Yaya Jesús, kishpichiy ñukanchita! ¡Ñami tikrahunchi! ");
INSERT INTO qupNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesuska aynirka: ¿Imaraykuta chasna yapa mancharihunkichi? ¿Kunankamachu manara tukuy shunkuykichimanta pacha ñukapi sinchikunkichi? Chaymanta Jesuska atarishpan chay wayrata yakutapas sinchi shimiwa rimarka: ¡Kasillayay wayra! ¡Kasillayay ulas! Chasna rimashkanllawa pasarirka wayraka, ulaspas mana ulasyarkanachu. ");
INSERT INTO qupNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Chaypi runankunaka yapa mancharishpa tapunakurkakuna paykunapura: Pishi kan kay runaka. Rimashkanllawa wayra yakupas kasushpa kasillayanahun. ");
INSERT INTO qupNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Chaymanta chay atun kuchata chimpashpankuna Jesuska runankunawa paktarkakuna Gadara llakta kuchupi. Paktashpankuna ishkay supayyashka runakuna kallpashpa kayllayarkakuna. Paykuna kawsapayanahun urku uchkupi, maypimi wañushkakunata churashka karkakuna chaypi. Supayyashka kashpankuna yapa piñaywa manchaypa karkakuna, chayrayku nima pi atipapayanahunchu chay ñampita purinata. ");
INSERT INTO qupNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Chay ishkay runa Jesusta kayllayashpankuna sinchita kaparishpa rimarkakuna: Yaya Diospa Wawan Jesús, amara ñukanchita kastigayrachu. Manara chay kastigana punchaka paktarishkarachu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Mana karupichu achka kuchikunaka mikuhlla karkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Chaypina chay runakunapi kawsak supaykunaka Jesusta tapurkakuna: Kay runakunamanta ñukanchita llukshichihushpaykika kachay ñukanchita chay kuchikunapi kawsananchipa. ");
INSERT INTO qupNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesuska aynirka: Ariya alimi, riychi. Chasna rimashkanllawa chay supaykunaka chay ishkay runakunamanta llukshishpankuna kuchikunapina yaykuk rirkakuna. Chasnallapi tukuy chay kuchikunaka waykuma kallpashpa pultyarkakuna lumamanta yakuma. Chaypina chinkarirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Chayta rikushpankuna kuchikunata kuyrak runakunaka yapa mancharirkakuna. Manchaywa kallparkakuna llaktankunama. Chaypi paktashpankuna tukuy runa masinkunata kwintarkakuna imashnami Jesuska chay supayyashka runakunata ampishka nishpa. Kuchikuna yakupi chinkarishkankunamantapas kwintarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Chayta uyashpankuna tukuy chay llaktapi kawsak runakunaka llaktankunamanta llukshishpankuna Jesusta rikuk rirkakuna. Payta rikushpankuna rimarkakuna: Yachachik, munanchi llukshinaykipa kay allpanchimanta, tukuy kuchinchikunata chinkachishkaykirayku nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Chaymanta Jesuska runankunawa botipi uraykushpankuna kuti chay atun kuchata chimparkakuna. Chaypi paktarkakuna paypa llaktanma. ");
INSERT INTO qupNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Chaypina shuk runakuna shuk chakichik unkuyyu runata llanchamanpi apamurkakuna Jesusma. Chay unkushkata apamuk runakunaka tukuy shunkunkunamanta pacha kirishpankuna yuyarirkakuna Jesús chay unkushkata ampinanta nishpa. Chaypi Jesuska paykunata rikushpan kirihushkankunata yacharka. Manara ampihushpan chay unkushkata rimarka: Sinchikuriy wawki, tukuy uchaykikunamanta llakichirishkami kanki nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Chayta uyashpankuna Moisespa killkashkanta shuk yachachikkuna yapa piñarishpa yuyarirkakuna, kay runaka rimashkanwa Yaya Diosta yapa piñachihun. Yaya Diosshina tukunayashpa kay unkushkata rimashka tukuy uchankunamanta llakichihushkanta. ");
INSERT INTO qupNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesuska yuyarihushkankunata yachashpan paykunata rimarka: ¿Imaraykutaya chasna yuyarihunkichi ñukamanta? ");
INSERT INTO qupNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kay runataka rimashkanimi uchaykikunamanta llakichirishkami kanki nishpa. Chasna rimashpayni mana yachankichichu shutipa llakichishkachu manachu nishpa. Ñuka kay unkushkata rimaynima atariy, puriy nishpa. Pay alita purishpanna yachankichima ñuka payta ampishkaynita. ");
INSERT INTO qupNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Yachanaykichipa ñuka Yaya Diospa Kachashkan Runa paypa yachayninwa runakunata uchankunamanta llakichinaynita kay allpapi, kunalla kay unkushkata ampisha. Chasna rimashpan chay unkushkata rimarka: Atariy. Llanchamaykita apishpayki kutiy wasikima. ");
INSERT INTO qupNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jesús chasna rimashpan chay runaka ampirishka atarirka, llanchamanta apishpan wasinma kutirka. ");
INSERT INTO qupNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Chayta rikushpankuna runakunaka yapa mancharirkakuna. Yaya Diosta kushichishpa rimarkakuna: Yaya Dios, kushikunchimi kay runata atun yachaykita kushkaykirayku unkushkakunata ampinanpa. ");
INSERT INTO qupNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Chaymanta Jesuska llaktanmanta llukshishpan purihushkanpi ñuka Mateota rikuwarka. Kullkita kobrana wasipi tiyarishpayni impuestuta kobrapayarkani romano tukuymanta atun apurayku. Chaypina Jesuska rikuwashpan rimawarka: Mateo, shamuy katiway. Chasna rimawashpan atarishpayni Jesusta katirkanina. ");
INSERT INTO qupNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Chaymanta Jesusta payta katihukkunawa pakta pusharkani wasinima chaypi mikunanchipa. Chaypi mikuhushpanchi achka Roma llaktarayku impuestuta kobrak masinikuna, chaymantapas shuk millaypata rurak runakuna shamurkakuna, ñukanchiwa pakta tiyarishpankuna mikunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Chaypina fariseokunaka rikuhurkakuna Jesusta ñukanchi millaypata rurak runakunawa pakta mikuhushkanta. Chaypina payta katikkunata tapurkakuna: ¿Imaraykuta kankunata yachachikka impuestuta kobrakkunawa, paykunashina mana alita rurak runakunawapas mikuhun? ");
INSERT INTO qupNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesús chayta uyashpan paykunata yachachirka shuk yuyarinawa: Rikuychi, alikunaka mana munanahunchu ampikta. Ashwan unkushkakunami ampikta munanahun ampirinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Yuyariychi imatata Yaya Dioska rimanayan killkachishkanpi kasna nishpan: Manami munanichu wiwakunata wañuchishpa kuwanaykichita ñukata kushichiwanaykichipa, ashwan munanimi runa masikichita llakichishpa yanapanaykichita. Chasna kashpanmi ñukaka mana shamushkanichu yanapanaynipa maykanmi riman mana uchayuchu kani nishpa. Ashwan shamushkanimi uchayukunata yanapanaynipa Yaya Diostana kasunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Chaymanta Bawtisak Juanta katikkunaka Jesusta kayllayashpankuna tapurkakuna: Ñukanchi, fariseokunapas achka punchakuna mana mikushpa Yaya Diosta mañanchi. Ashwan kanta katikkunaka karan puncha mikunahunlla. ¿Imaraykutaya mana ñukanchishina shuk shuk punchakuna mana mikushpa Yaya Diosta mañanahunchu? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesuska paykunata aynirka: Rikuychi, shuk musuka warmiyahushpanka kayan tukuy ayllunkunata kushilla tantarishpa paywa pakta mikunankunapa. ¿Chasnaka chay kayashkankunaka llakirishkachu kanahuma? Mana. Ashwan shuk puncha kuntrankunaka chay mushu warmiyahushkata anchuchishpankuna chay puncha shuti yapa llakirishpa shuk punchakuna mana mikunkakunachu nishpa. Chasna Jesuska rimarka pay kikin chay mushu warmiyahushkashina kashkanta yuyachishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Chaymanta Jesuska ashwanta paykunata asirtachinayashpan rimarka: Shuk yapa likirishka mawka kamisata mana rimintanchimachu shuk mushu llachapawa. Chasna chay mushuwa rimintashpanchika mawkaka ashwantami likirin. ");
INSERT INTO qupNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Chasnallatatami mushu vinu putskurihushkata mana churanchimachu shuk mawka karamanta rurarishka bulsapi. Chay vinu urtiyashpan putskurihushpanka mawka karaka tukyashpan vinuka talirin. Ishkanti mana valinahunnachu. Chayrayku mushu vinuta mushu karamanta rurarishka bulsapi churanchi. Chasnaka ishkantimi mana waklinkachu. Ñukaka Yaya Diospa mushu shimintami yachachihuni. Ñawpa yaya rukuykichikunaka mana chasnachu yachachipayarkakuna. Kankunaka katinaykichi tiyan kay mushu yachachihushkaynitana. Mana atipankichichu chapuchinata chay ñawpa yachakushkaykichiwa. ");
INSERT INTO qupNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesús chay runakunata yachachihushkanllapi, ñukanchi israel runakunapa shuk tantarinanchi wasipi kamachik payta kayllayarka. Payka Jesuspa puntanpi kunkurishpa tapurka: Kunalla wawaynika wañushka. Chasna wañushka kashpanpas kanka ñukawa wasinima rishpaykika makikiwa llankashpaykimi wawaynika kawsarinka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesuska atarishpan ñukanchi runankunawa pakta chay apupa wasinma rirka. ");
INSERT INTO qupNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Chasna rihushkanchipi, shuk unkushka warmi Jesusta washanmanta kayllayarka. Payka chunka ishkay watata unkushka karka. Tukuy uras yawar paymanta urmapayan. Chay warmika Jesuspa washanmanta churarishkanta llankarka. ");
INSERT INTO qupNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Jesuspa churarishkanpa shiminllata llankashpaynimi ampirisha nishpa yuyarirka. ");
INSERT INTO qupNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Chasna chay warmika yuyarishpa llankashpan Jesuska washanma tikrarishpan payta rikurka. Chaypina llakichishpan rimarka: Pani, kushikuy. Tukuy shunkuykimanta pacha kiriwashkaykirayku ampirishka kanki. Chayllata rimashpan chay unkushka warmika ampirirka. ");
INSERT INTO qupNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Chasna ampishkanwasha Jesuska paktarka chay kamachikpa wasinpi. Chaypi achka runakuna sinchita kaparishpa wakahurkakuna. Kenata pukuk runakunaka chaparkakuna chay wañushkata urku uchkupi churashpa tapak rinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Tukuy paykunata rikushpan Jesuska rimarka: Llukshiychi kaymanta. Kay shipaska manami wañushkachu, puñuhunmi. Chasna rimashpan tukuy chay runakunaka Jesusta asichirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Chaypina Jesuska tukuy chay runakunata kanchama llukshichirka. Chaymanta yaykushpan chay shipasta makinmanta apirka. Chaypina chay shipaska atarirka. ");
INSERT INTO qupNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Chaymanta tukuy chay llaktakunapi kawsak runakunaka Jesús chay shipasta kawsachishkanmanta yacharkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesús chay apupa wasinmanta llukshishpan ishkay wisku runakuna sinchita kayashpa katirkakuna: ¡Davidpa Miraymanta Kishpichik, llakichiy ñukanchita! nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesús shuk wasima yaykushpan chay ishkay wiskukunapas yaykurkakuna. Kayllayashpankuna Jesuska paykunata tapurka: ¿Kirinkichichu ñuka kankunata ampinaynita? Ari yachachik, kirinchimi nishpa aynirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Chaypina Jesuska ñawinkunata llankashpan rimarka: Tukuy shunkuykichimanta pacha kiriwashkaykichirayku ampirishka kiparinkichi. ");
INSERT INTO qupNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Chasna rimashpan chay ishkay runakunaka alitana rikurkakuna. Chaypina Jesuska paykunata alita kunarka: Nima pita kwintankichichu ñuka kankunata ampishkaynimanta. ");
INSERT INTO qupNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Chasna kunashpanpas paykunaka kwintak rirkakuna tukuy chay llaktakunapi kawsak runakunata imashnami Jesuska paykunata ampishka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Chay ishkay runakuna llukshishkankunawasha shuk runata Jesusma apamurkakuna. Chay runaka supay yaykushka kashpan mana atiparkachu rimanata. ");
INSERT INTO qupNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesuska supayta chay runamanta llukshichishpan chaypira chay runaka atiparka rimanata. Chayta rikushpankuna chay runakunaka mancharishpankuna rimarkakuna paykunapura: Nima ima uras rikushkanchichu chasna ampik runata kay Israel allpanchipi. ");
INSERT INTO qupNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Chaypina fariseokunaka rimarkakuna: Kay ampik runaka supaykunapa apunpa yachayninwa supaykunata llukshichin nishpa. Jesusta chiknishpankuna chasna rimarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Chaymanta Jesuska shuk llaktama shuk llaktama purirka tantarinankuna wasikunapi runakunata yachachinanpa kay suma ali shimita Yaya Diospa ali kamachinan kay allpapi ña kallarishkanmanta. Chasna yachachihushpan Jesuska runakunata tukuy unkuykunamanta parisinakunamantapas ampipayarka. ");
INSERT INTO qupNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jesuska chay achka runakunata rikuhushpan paykunata llakichirka, paykuna mana amuyu shikwarishka sampayashka obehakunashina kashpankuna. ");
INSERT INTO qupNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Chaypina ñukanchita rimarka: Kay runakuna ña pallanapa pukushka muyukunashina kahunkuna. Chasna kashpanpas Yaya Diospa shiminta yachachikkunaka mana achkachu kanahun muyuta pallahukshina runakunata Yaya Diosrayku tantachinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Chayrayku Yaya Diosta mañaychi, paypa wawankunata tukuy llaktakunama kachananpa, runakunata yachachik rinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Chaymanta Jesuska ñukanchi chunka ishkay akllashkan runankunata kayashpan rimarka: Kunan ñuka Yaya Diospa yachayninta kankunata kusha tukuy supaykunata llukshichinaykichipa runakunamanta. Chaymantapas atipankichi ampinata runakunata tukuy unkuykunamanta parisinakunamantapas nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jesús apostolnikuna kankichi nishpa chunka ishkay akllashkanpa shutinkunaka karkakuna: Simón, maykantami Jesuska shutiyachirka Pedro; Andrés Simonpa wawkin; Santiago Juanpas Sebedeopa wawankuna; ");
INSERT INTO qupNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","4","Felipe, Bartolomé, Tomás, ñuka Mateo. Ñawpa karkani impuestuta kobrak romano tukuymanta atun apurayku. Chaymanta Santiago Alfeopa wawan; Tadeo, Simón, maykantami rimapayarkakuna Selote. Chaymantapas Judas Iskariote, maykanmi chaywasha Jesusta apichinan karka. ");
INSERT INTO qupNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesuska ñukanchi chunka ishkay akllashkankunata shuk shuk llaktakunama kachahushpan rimarka: Riychi israel masinchikunapa llaktankunallapi. Ama riychichu mana israel runakunapa llaktankunamaka, nima Samaria allpa llaktakunapi yaykunkichichu. ");
INSERT INTO qupNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Israel masinchikunallata yachachik riychi. Paykunaka mana amuyu obehakuna pantashkashinami kahunkuna. ");
INSERT INTO qupNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Rishpaykichi rimaychi ñami kallarihun Yaya Diospa ali kamachinanka kay allpapi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Chasna yachachihushpaykichi unkushkakunata ampiychi, wañushkakunata kawsachiychi, aycha ismuchik unkuyyu runakunata ampiychi, supay yaykushka runakunamanta supaykunata llukshichiychi. Yaya Dios kankunata yachayninwa yanapashpanmi tukuy chaykunata atipankichi ruranata. Yaya Dios kankunata yanka yanapashkanrayku, kankunapas nima imata tapunkichichu chay ampishkaykichi runakunamanta. ");
INSERT INTO qupNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Chay ñampita rihushkaykichipi nima kullkita apaychichu, ");
INSERT INTO qupNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","nima bulsata, nima ashwan shuk churarinaykichita, nima chakikichirayku ashwan shuk churarinaykichita, nima ashwan shuk tulaykichita apankichichu. Chay churarishkaykichillawa riychi. Runakunata yanapashpaykichi yachachishpaykichi paykunapas kankunata karanankuna tiyan. ");
INSERT INTO qupNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Maykan llaktapi paktashpaykichi maskaychi shuk wasi amuta, maykanmi kankunata ali yuyaywa kayanka. Paypa wasinpi kipariychi shuk llaktama rinaykichi punchakama. ");
INSERT INTO qupNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Chay runapa wasinpi yaykuhushpaykichi saludaychi tukuy chay wasipi kawsak runakunata. ");
INSERT INTO qupNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Paykuna kankunata alita kayashpankunaka Yaya Dios paykunata yanapanka. Mana alita kayashpankunaka Yaya Dios mana paykunata yanapankachu. ");
INSERT INTO qupNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Chay runakuna wasinkunapi mana kayashpankunaka nima rimashkaykichita uyanayashpankunaka llukshiychi chay wasimanta chay llaktamantapas. Llukshihushpaykichi rimaychi Yaya Dios kankunata kastigankami, mana paypa shiminta uyanayashkaykichirayku nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Alita uyawaychi. Shuk punchami Yaya Dioska tukuy runakunata tapunka rurashkankunamanta. Chay tapunan punchami Yaya Dioska ñawpa Sodoma llaktapi Gomorra llaktapi kawsak runakunata kastigashkanmanta pasatami chay mana kasunayak runakunata kastiganka. ");
INSERT INTO qupNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Chaymanta Jesuska rimarka: Rikuychi, ñuka kankunata kachani obehakunatashina sacha allkukuna chawpipi. Chayrayku yapa yachaywa, ali yuyayllawa kawsaychi. ");
INSERT INTO qupNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Kuyrariychi kankunata chiknik runakunamanta. Paykuna kankunata apishpa apukunama pushankakuna kastigachinankunapa. Tantarinankuna wasikunapi yaykushpaykichika kankunata asutichinkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ñukamanta yachachishkaykichiraykumi chay runakunaka kankunata apishpankuna apunkunama pushankakuna. Shukkunata kankunamanta ashwan atun apukunamapas pushankakuna. Chasna apirishka tukushpaykichi tukuy paykunata, mana israel apukunatapas yachachishkaynita riksichinaykichi tiyan. ");
INSERT INTO qupNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Chay apukunama kankunata pushashpankunaka ama mancharinkichichu, imatashi rimasha, imashnashi aynisha nishpa. Yaya Diospa Espiritunmi kankunata chay uras yuyachinka imatami rimanaykichi tiyan nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Pay kankunata yuyachishpanmi atipankichi tukuy apukunata ayninata. Manami kankuna kikinpa yuyaykichimantachu rimankichi. ");
INSERT INTO qupNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Chay parisina punchakuna chiknik runakunaka kikin wawkinkunata yanka llullashpa apukunama pushankakuna wañuchichinankunapa, chaymantapas yayakuna wawankunata. Wawakuna yapa piña tukushpankuna yayankunata apichinkakuna wañuchichinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tukuy runakuna kankunatapas chikninkakunami ñukata kasushpa kawsahushkaykichirayku. Kankunata chiknishpankunapas wañunaykichi punchakama ñukata kirishpa kawsashpaykichika Yaya Diosmi kankunata chay atun kastigananmanta kishpichinka paywa pakta silupi kawsanaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Shuk llaktapi kawsak runakuna kankunata wañuchinayashpankunaka chay llaktamanta mitikuychi shuk llaktama. Alita uyawaychi. Manarapas kankuna tukuy kay Israel allpanchi llaktakunapi yachachishpaykichira ñuka Yaya Diospa Kachashkan Runa kuti shamusha. ");
INSERT INTO qupNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Nima shuk katik runa payta yachachikmanta ashwan yachanchu. Nima shuk runa patronmanta ashwan kamachikchu kan. ");
INSERT INTO qupNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Shuk katik runa payta yachachikshina tukushpan kushilla kama. Chaymanta shuk runa patronshina tukushpan kushilla kama. Ñuka ali yachachik kashpaynipas shuk runakuna chikniwashpankuna rimawanahun supaykunapa apun Beelsebú kanaynita. Ñukamanta chasna llullashpa rimashpankuna kankuna katiwak runaynikunamanta ashwan millaypata rimankakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ama manchaychichu chay kankunata chiknik runakunata. Rikuychi, nima ima pakalla rimashkaka, nima pakalla rurashkaka pakalla kiparinkachu. Tukuy yuyayta shunkunchipi pakahushkanchita Yaya Dioska shuk punchami tukuy runakunata riksichinka. ");
INSERT INTO qupNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Chasnallatatami kankunallata tutapi pakalla rimashkaynita tukuy runakunata mana pakashpa rimaychi. Chasnallatata chunllalla yachachishkaynita kankunana sinchita tukuy runakunata yachachiychi. ");
INSERT INTO qupNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ama manchaychichu kankunata wañuchinayak runakunata. Paykuna wañuchishpankunapas mana atipanahunchu kankunata nina mana wañukma kachanata. Yaya Diosllami atipan tukuy mana ali rurak runakunata wañushkankunawasha nina mana wañukma kachanata. Chayrayku Yaya Diosllata manchaychi, payllata kasushpa kawsaychi. ");
INSERT INTO qupNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Yuyariychi pishkukunapi. Mana yapa chaniyu kashpankuna ishkaystuta atipanchi rantinata shuk kullkistullawa. Chasna mana yapa chaniyu kashpankunapas nima shuk wañunchu Yaya Dios mana munashpanka. ");
INSERT INTO qupNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Yaya Dios kankunatapas alita kuyran. Pishkukunamanta ashwan pasatami kankunata yuyan. Kankunata yuyashpan alita riksin. Nima shuk uchilla chukcha umaykichipi tiyashkaka paymanta kishpinchu. Chayrayku ama manchaychichu nima pita nima imatapas. ");
INSERT INTO qupNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Jesús yachachihushkanllapi rimarka: Maykan runami mana pinkashpa ñukamanta runakunapa puntankunapi riman Jesusta katik kani nishpa, paymantaka ñukapas silupi kawsak Yayayni Diospa puntanpimi rimasha kay runata riksinimi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ashwan maykanmi runa masinkunapa puntanpi pinkashpa ñukamanta riman payta mana riksinichu nishpa, paymantaka ñukapas silupi kawsak Yayayni Diospa puntanpi rimasha kay runata mana riksinichu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ama yuyariychichu ñuka kay allpama shamushkaynirayku runakuna kushilla shuk yuyayllawana kawsanankunata. Ashwan shamushkaynirayku mana shiminita kasunayak runakuna kankuna ñukata kasuk runakunawa chikninakushkashina manana shuk yuyayllawa kawsankakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kunanmanta pacha shuk wasipi kawsak ayllupura ñukaranti manana shuk yuyayllawa kushilla kawsankakunachu. Chasna kashpan shuk wawa yayanta, shuk shipas mamanta, shuk nuera swegranta chiknishpa kawsankakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ñukata katishpa kawsahushkaykichirayku kikin aylluykichi kankunata chikninkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Mana ñukata yayaykichimanta mamaykichimanta wawaykichimantapas ashwan alita yuyawashpaykichika manami ñukata katikkunachu kankichi. ");
INSERT INTO qupNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kasuwashkaykichirayku runakuna kankunata yapa chiknishpa parisichinkakuna. Chasna parisichishpankunapas wañuchinayashpankunapas alita kasuwashpa katiwanaykichi tiyan. Chasna parisichinankunata mana awantanayashpaykichika manami ñukata katikkunachu kankichi. ");
INSERT INTO qupNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Munashkaykichillata rurashpa kawsashpaykichika manami nima ima uras Yaya Dioswa wiñaypa kawsankichichu. Ñukata kasuwahushpaykichi kankunata wañuchishpankunapas Yaya Dioswami wiñaypa kawsankichi. ");
INSERT INTO qupNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Maypipas kankunata wasinkunapi yaykuchishpankunaka ñukatami yaykuchiwanahun. Ñukata yaykuchiwashpankunaka kachamuwashka Yayayni Diostapas yaykuchinahun. ");
INSERT INTO qupNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kankuna shiminita yachachik rishpaykichi shukkuna kankunata yaykuchinkakuna. Paypa kachashkan kashkaykichirayku Yaya Dioska paykunata kankunatashina rimanka alita rurashkankichi nishpa. Chaymanta ali rurak runakuna kashpaykichi shukkuna kankunata yaykuchinkakuna. Paykunatapas kankunatashina Yaya Dioska rimanka alita rurak runakuna kankichi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Maykanmi shuk ñukata chayra katiwak runata suma chiri yakullatapas upyachishpanka ñukata katiwahushkanrayku, chay runataka Yaya Diosmi chasna rurashkanmanta kushichinka. ");
INSERT INTO qupNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesús ñukanchi chunka ishkay runankunata chasna yachachishkanwasha purirka tukuy Galilea allpa llaktakunapi Yayan Diospa shiminta yachachinanpa. ");
INSERT INTO qupNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Chay uras Bawtisak Juanka karselpi kahurka. Chaypi Kristupa rurahushkankunata yachashpan ishkay payta katikkunata Kristuma kacharka. ");
INSERT INTO qupNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Chaypina payta tapurkakuna: ¿Kanchu kanki maykantami Yaya Dios kachanan karka? Manapika ¿shuktachu chapashunchi? ");
INSERT INTO qupNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesuska paykunata aynirka: Riychilla, Juanta kwintak riychi tukuy uyahushkaykichita, tukuy rikuhushkaykichitapas. ");
INSERT INTO qupNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Rimak riychi: Wiskukunaka mushumanta rikunahun. Mana purinata atipakkunapas mushumanta purinahun. Aycha ismuchik unkuyyukunapas ampirishka kanahun. Mana uyanata atipakkunapas mushumanta uyanahun. Wañushkakunapas kuti kawsarinahun. Nima imayu runakuna Yaya Diospa suma ali shiminta runakunata kishpichinanmanta uyahunkuna. ");
INSERT INTO qupNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Chaymanta Juanta rimaychi: Maykanmi mana sampayashpa ñukata kiriwan, chayka kushillami kanka. ");
INSERT INTO qupNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Chasna rimashpan Juanpa kachashkan runankunaka kutirkakuna Juanta rimanankunapa. Kutishkankunawasha Jesuska chaypi kahukkunata Juanmanta rimarka: Kankunaka chunlla chakishka allpama rishpaykichi ¿imashna runatata rikunayarkankichi? ¿Shuk muspa yuyayyu runatachu rikunayarkankichi? Mana chasnatachu rikuk rirkankichi. ");
INSERT INTO qupNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Shuk suma churarishka runatachu rikuk rirkankichi? Mana chasnatachu rikuk rirkankichi. Suma churarishka kahukkunaka apukunapa wasinkunapimi kawsanahun. ");
INSERT INTO qupNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Chasna kashpan ¿imata rikunayashpaykichitaya rirkankichi? ¿Yaya Diospa yachayninwa shuk yachachiktachu rikunapa rirkankichi? Kankunata rimani, ari, chayraykumi rirkankichi. Mana chasna runallatachu rikunapa rirkankichi. Yaya Diospa yachayninwa ñawpa yachachikkunamanta ashwan yachaktami rikuk rirkankichi. ");
INSERT INTO qupNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Chay Juanmanta kasna killkarishka kan ñawpa Yaya Diospa rimashkanka: Ñukaka shuk runata kachasha runakunata shiminita rimananpa. Payka manarapas kanta kachahushpayni runakunata kanmanta rimak rinka shunkunkunata alichashpankuna alita kanta kayanankunapa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Alita uyawaychi. Ñawpamanta pacha tukuy kay allpapi kawsak runakunamanta Juanka ashwan alita runakunata kunarka. Chasna Juan tukuy yachachikkunamanta ashwan yachak kashpanpas maykanmi Yaya Diospa kamachishkan tukushpa paypa ali kamachihushkanpi kawsan, mana yachak kashpanpas chaymi Juanmanta pasa kan. ");
INSERT INTO qupNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","Ñawpamanta pacha Bawtisak Juan yachachinankama Moisés wañu tukuy Yaya Diospa yachayninwa yachachikkunapas Yaya Diospa ali kamachinan kay allpapi paktarinanmanta rimarkakuna. Bawtisak Juan shamushkanmanta pacha kunankama runakuna atipashkankunata ruranahun Yaya Diospa ali kamachinanpi kawsanankunapa. Maykankunami sinchikurinahun shunkunkunamanta pacha, paykunallami Yaya Diospa kamachishkankuna tukushpa ali kamachihushkanpi kawsankakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Mana kirishpaykichipas Juanmi kan, maykanmantami Yaya Dioska killkachishkanpi riman: Manara Kishpichikka shamuhushpanmi shuk yachayniwa yachachik Eliasshina rimak shamunka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tukuy kay yachachihushkaynikunata alita uyashpa yachakuychi. ");
INSERT INTO qupNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Imashnata kankunata yachachinima. Imashna rimanakunawashi kankunata yachachinima. Kankunaka ñampipi tiyarishpa pukllahuk wawakunashina kankichi. Paykunaka pukllak wawa masinkunata kaparishpa rimanahun: ");
INSERT INTO qupNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ñukanchi kenata pukushpanchipas kankuna mana baylashkankichichu. Chaymanta llakiypata takishpanchipas mana wakashkankichichu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","19","Chasna nima pita kasunayak wawakunashina kashpaykichi nima Bawtisak Juanta, nima ñukata kasunayashkankichichu. Juanka Yaya Diosta yuyashpan shuk shuk punchakuna mana mikushkachu, nima upyashkachu. Chasna kashpanpas payta rimarkankichi, supay yaykushkami kanki nishpa. Chaymanta ñukana Yaya Diospa Kachashkan Runa shamurkani. Payta yuyashpayni mikuni upyani. Ñukataka rimawankichi mikuysiki upyaysikimi kanki, mana ali rurak runakunapa, Roma atun llaktarayku impuestuta kobrakkunapa amigunmi nishpa. Chasna rimashpaykichipas ñukanchi Yaya Diosta kasushpa tukuyta alillata rurahushpanchi rikuchinchi Yaya Diospa suma yachayninwa kahushkanchita. ");
INSERT INTO qupNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Chaymanta Jesuska yachachik rirka chay llaktakunapi, maypimi puntiru rishpan atun yachaywa achka ruranakunata rurarka. Chaypi kawsak runakuna Jesús atun yachaywa rurashkankunata rikushpankunatata Yaya Diosta mana kasunayashkakunachu. Chayrayku Jesuska paykunata piñarishpan rimarka: ");
INSERT INTO qupNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ay kankuna Korasín llaktapi kawsak runakuna. Ay kankuna Betsaida llaktapi kawsak runakuna. ¡Imashna kastigushi kankunarayku kanka! Kankunawa kashpayni atun yachaywa achka ruranakunata rurashpaynipas kankunaka Yaya Diosta mana kasunayashkankichichu. Chay Yaya Diospa mana akllashkan Tiro llaktapi, Sidón llaktapi kawsakkuna rikunahuma karka atun yachaywa rurashkaynikunata, paykunaka Yaya Diosta kasunahuma karka. Chay urasllapi paykunaka yapa pinkaywa llakirishpankuna wakanahuma karka, millaypa rurahushkankunata sakishpankuna alitana ruranankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Chayrayku kastiganan puncha Yaya Dioska chay Tiropi Sidonpi kawsak runakunamanta kankuna Korasinpi Betsaidapi kawsak runakunata ashwan sinchitami kastiganka. ");
INSERT INTO qupNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kankuna Kapernaum llaktapi kawsak runakuna, ¿imaraykuta yuyarinkichi Yaya Dios ñukanchita siluma pushanka nishpa? Mana chasnachu. Nina mana wañukmami rinaykichi tiyan. Atun yachaywa achka rurashkaynikunata rikushpaykichipas mana kiriwashkankichichu. Ñawpa Sodoma llaktapi chay atun yachaywa ruranakunata ruraynima karka, chaypi kawsak runakunaka kiriwanahuma karka, llaktankunaka mana chinkarimachu karka. ");
INSERT INTO qupNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Chayrayku kankunata rimani, Yaya Dios kastiganan puncha kankunata Sodoma llaktapi kawsak runakunamanta ashwan sinchitami kastiganka. ");
INSERT INTO qupNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Chay uraslla Jesuska Yayan Diosta kushichishpan rimarka: Munashkayni Yayayni, yapa alimi kanki. Kanmi kay allpapi silupipas atun yachaykiwa kamachik kanki. Kushikunimi mana yachakchu kani nishpa yuyarik runakunallata tukuy yachaykita asirtachishkaykirayku. Tukuy chay yachak kanankunata yuyarik runakunata mana asirtachishkankichu yachaykita. ");
INSERT INTO qupNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ari Yayayni, kan kikin munashkaykirayku chasna rurashkanki nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yayanta chasna rimashkanwasha, tukuy chay runakunata yachachirka: Yayaynimi tukuyta kuwarka ñukalla tukuyta kamachik kanaynipa. Payllami yuyaynita yachashpan ñukata alita riksiwan. Kankunaka manami alitachu riksiwankichi. Yaya Diospa Wawan kashpayni ñukallami alita riksini imashnami Yayayni Dioska nishpa. Maykankunallatami ñuka riksichisha, paykunallami Yayayni Diosta riksinkakuna. Mana ñuka riksichishpaynika Yayayni Diostaka manami nima pi riksinkachu. ");
INSERT INTO qupNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Tukuy kankuna chay achka kamachirishka kashkata paktachinayashpa nitirishkashina, yapa llashata aparihukshina sampayashka kahushpaykichi shamuychi ñukama kankunata samachinaynipa. ");
INSERT INTO qupNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ñuka kankunata yachachishkaynitana kasushpa kawsaychi. Ñukata katishpaykichi yachakuychi. Mana piñachu kani, ali shunku, mana atunyanayashpachu kani. Chayrayku ñukama shamushpaykichi ñukata kasuwashpaykichika samahukshina kushilla kawsankichi. ");
INSERT INTO qupNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kamachishkaynika ali kan kankunarayku. Maykantami kankunata rimashkani ruranaykichipa chayka manami kankunarayku kanchu shuk llasha nitihukshina. Ñuka kankunata yanapashpaynimi tukuy rimashkaynita atipankichi ruranata. ");
INSERT INTO qupNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Shuk samana puncha Jesuska ñukanchiwa pakta trigu tarpurishkakuna chawpita rirka. Chaypina ñukanchika yarkashpanchi shuk shuk trigu muyuta pallarkanchi mikunanchipa. ");
INSERT INTO qupNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Chayta fariseokuna rikushpankuna piñarishpa Jesusta rimarkakuna: Rikuy, samana puncha kashpanpas kanwa purihukkunaka trigu muyuta pallahunkuna mikunankunapa. Chasna pallahushpankuna Moisespa killkashkan kamachishkata, samana punchapi ama tarawaychichu nishkanta mana kasuhunkunachu. ");
INSERT INTO qupNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Chasna rimashpankuna Jesuska paykunata aynirka: ¿Manachu leyishkankichi, ñawpa yaya rukunchi Davidka, paywa purikkunapas yarkashpankuna imashnata rurarkakuna? ");
INSERT INTO qupNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Davidka Yaya Diospa wasinpi yaykushpan Yaya Diosta rikuchinankunapa mesapi churarishka pankunata apishpan mikurka Yaya Diosrayku rurarishkata. Paywa purikkunatapas kurka mikunankunapa. Chay panka mana karkachu payrayku, nima paywa purikkunaraykuchu, ashwan ñukanchi israel runakunapa saserdotenchikunaraykullami karka. Runankuna yarkashpankuna chay panta mikushpankunapas Yaya Dioska mana uchatashina rikushpa paykunata mana kastigarkachu. ");
INSERT INTO qupNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Chasnallatata ¿manachu leyishkankichi ñawpa Moisespa killkashkanpi, imashnami saserdotekuna Yaya Diospa wasinpi karan puncha samana punchapas tarawanahun? Chasna samana puncha paypa wasinpi tarawashpankunapas Yaya Diospa rikushkanpi mana uchata ruranahunchu. ");
INSERT INTO qupNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kankunata rimani, chay Yaya Diospa wasinmanta ñukami ashwan ali kani. ");
INSERT INTO qupNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Yaya Dios killkachishkanpi riman: Kankuna wiwaykichikunata wañuchishpa rupachinkichi ñukata kushichiwanaykichipa. Chay wiwaykichita rupachishkaykichimanta ashwan munani runa masikichita llakichishpa yanapanaykichipa. Chasna Yaya Dios rimashpanpas kankunaka mana asirtashkankichichu. Alita asirtankichimaka, manami kay ñukawa purikkunata rimankichimachu uchatami rurahunkichi, shuk shuk trigu muyuta pallashkaykichirayku samana punchapi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yaya Dioska ñuka paypa Kachashkan Runata yachayninta kuwashka kankunata rimanaynipa imakunami ali kan samana puncha ruranaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Chaymanta Jesuska rishpan shuk tantarina wasipi yaykurka. ");
INSERT INTO qupNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Chaypi tiyarka shuk chakirishka makiyu runa. Chaypina fariseokuna Jesusta chiknishpa rikurayarkakuna, pay shuk mana rurananchi kashkata ruramachu manachu nishpa payta uchachinankunapa. Pantachichinayashpankuna Jesusta tapurkakuna: ¿Chasnachu Moisespa killkashkanpi ñukanchita riman, shuk unkushkata ampinanchipa samana punchapi? ");
INSERT INTO qupNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesuska paykunata aynirka: Rikuychi, samana puncha kashpanpas shuk obehaykichi uchkupi urmamaka, kankunaka obehaykichita llakichishpami surkunkichima. ");
INSERT INTO qupNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Shuk runa obehamanta ashwan valikmi kan. Chayrayku Yaya Dioska munan, samana puncha kashpanpas runa masinchita llakichishpa yanapananchipa. ");
INSERT INTO qupNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Chasna paykunata rimashpan Jesuska chay chakirishka makiyu runata rimarka: Makikita chutachiy nishpa. Chay runaka Jesusta kasushpan chakirishka makinta chutachirka. Chasna chutachishpan makinka ampirishka kiparipurka chay shuk ali makinshina. ");
INSERT INTO qupNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Jesús samana punchapi chay runata ampishkanrayku fariseokunaka chay tantarina wasimanta llukshishpankuna paykunapura kwintarkakuna imashnashi Jesusta wañuchinchima nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesús yachashpan fariseokuna payta wañuchinayahushkankunata chay llaktamanta llukshirka. Llukshishpanna achka runakuna payta katirkakuna. Jesuska tukuy unkushkakunata ampipayarka. ");
INSERT INTO qupNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Chaymanta chay ampishkan runakunata rimarka: Nima pita kwintankichichu ñuka kankunata ampishkaynita nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Chasna rurashpan paktachirka ñawpa Yaya Diospa yachayninwa yachachik Isaiaspa killkashkan Yaya Dios paymanta rimashkanta: ");
INSERT INTO qupNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Rikuychi kay kasuwak runaynita. Ñukami paytaka yuyashpa akllashkani. Paymi yapa kushichiwan. Espirituynimi paytaka yanapanka. Paymi tukuy kay allpapi kawsak runakunata shutipata yachachinka shunkunkunaka alicharishka tukunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Payka nima piwa piñanakunkachu, nima pita sinchi shimiwa kaparishpa rimankachu, llaktakunapi purihushpan runakunata mana piñachinkachu. ");
INSERT INTO qupNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Paymi ñañu ramashina pakirinalla kashkata mana pakinkachu. Wañunalla ninashina kashkata mana wañuchinkachu. Ashwan llakichishpa yanapanka llakiypa kawsak runakunata, mana yapa shunkunkunamanta pacha ñukata kirihukkunata. Chasna yanapashpa katinka tukuy mana ali kashkata winsinankama, tukuy parti runakunata yanapanankama mana alita rurashpa kawsahushkankunamanta kishpichiy tukunankunapa, mana munakkunataka kastigashpa anchuchinankama. ");
INSERT INTO qupNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Chayrayku tukuy kay allpapi kawsak runakuna kushikushpankuna payta chapankakuna kishpichirishka kanankunapa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Chaymanta Jesusma pusharkakuna shuk supay yaykushka runata. Chay runaka mana atiparkachu rikunata nima rimanata. Chaypina Jesuska payta ampishpan atiparka rikunata rimanatapas. ");
INSERT INTO qupNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Chayta rikushpankuna tukuy runakunaka yapa mancharishpa tapunakurkakuna: Kay runachari chapahushkanchi ñawpa atun apu Davidpa Miraymanta Kishpichik kan nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Chayta fariseokuna uyashpankuna Jesusta mana kirishpankuna rimarkakuna: Jesuska kay runamanta supaykunata atipashka llukshichinata, supaykunapa apun Beelsebú yachayninta kushkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesuska chay fariseokunapa yuyarihushkankunata yachashpan paykunata rimarka: Shuk llaktapi kawsak runakuna chikninakushpa makanakushpankunaka paykunapurami wañunakunahuma. Chasnallatatami shuk wasipi kawsak runakuna chikninakushpa makanakushpankunaka shikwarinahuma. ");
INSERT INTO qupNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Chasnallatata supaykunapa apun maykantami Satanás Beelsebupas ninchi paypa kamachinankunata shuk runamanta llukshichimaka, supaypura piñanakushpankuna paykuna kikin rurahushkankunata waklichinahuma. Chasnashpankunaka imashnataya Satanaska alita kamachima. ");
INSERT INTO qupNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kankuna rimankichi supaykunapa apun Beelsebupa yachayninwa kay runamanta supaykunata llukshichishkaynita. Chasna rimashpaykichi ¿pita yanapan kankunata katik runakunata supaykunata runakunamanta llukshichinankunapa? ¿Paykunapas Satanaspa yachayninwa supaykunata runakunamanta llukshichinahunchu? Kankunaka alita yachankichimi Yaya Dios paykunata yanapananta. Chayraykumi paykuna kikin rikuchinahun kankuna yankamanta rimawahushkaykichita. ");
INSERT INTO qupNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Yaya Diospa Espíritun yanapawashpanmi supaykunata llukshichini. Chay rurashkaynita rikushpaykichi yachankichi Yaya Diospa ali kamachinan chawpikichipi ña kallarishkanta. ");
INSERT INTO qupNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Rikuychi. Shuk sinchi runapa wasinmanta manara amunta watashpankuna nima pi atipamachu shuwanata nima imata. Chasna chay sinchi runata watashpanrami tukuy paypa tiyapushkanta atipama kichunata. Chasnallatata ñukapas, Yaya Diospa yachayninllawami atipani supaykunapa apunta winsinata supaykunata llukshichinaynipa runakunamanta. ");
INSERT INTO qupNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Kankuna mana kiriwashpaykichika chikniwahunkichimi. Runakunata ñukamanta alita yachachishpa mana yanapawashpaykichika pantachichishpa ñukamanta anchuchinkichi. ");
INSERT INTO qupNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Chayrayku kankunata rimani, Yaya Dioska runakunata tukuy mana alita rurashkankunamanta, mana alita rimashkankunamantapas llakichinkami. Chasna kashpanpas manami llakichinkachu Yaya Diospa Espiritunmanta llullashpa paypa yachayninka supaykunapa apunpa yachayninmi nishpa rimakkunataka. ");
INSERT INTO qupNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Maykan runami piñarishpan millaypata riman ñuka Yaya Diospa Kachashkan Runamanta, paytaka Yaya Dioska llakichinkami. Maykanmi Yaya Diospa Espiritunmanta llullashpa riman paypa yachaynin supaykunapa apunpa yachayninmi nishpa, chaytaka Yaya Dioska manami llakichinkachu, nima kawsahushkanpi, nima wañushkanwasha. ");
INSERT INTO qupNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Shuk kaspita muyunmanta riksinchi. Muyunkuna ali kashpankunaka riksinchimi ali kaspi kananta. Muyunkuna mana ali kashpankunaka riksinchimi mana ali kaspi kananta. ");
INSERT INTO qupNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kankuna machakuyashina runakuna kankichi, yachachinaykichiwa runakunata pantachichishpa yuyayninkunata waklichikkuna. Shunkuykichika mana ali kashpan mana atipankichichu alikunata rimanata. Imatami shuk runaka yuyarin shunkun ukupi, chaytami riman. ");
INSERT INTO qupNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ali runaka shunkunpi ali yuyarishkantami riman. Mana ali runaka shunkunpi mana ali yuyarishkantami riman. ");
INSERT INTO qupNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Kankunata rimani, Yaya Dioska kastiganan punchami tukuy runakunata tapunka, tukuy mana ali shimikunata rimashkankunamanta. ");
INSERT INTO qupNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Yaya Dioska tukuy rimashkaykichita yachan. Chayrayku rimashkaykichi ali kashpanka kankunata ali runa kanki nishpa rimanka. Rimashkaykichi mana ali kashpanka kankunata sinchitami kastiganka. ");
INSERT INTO qupNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Jesús yachachihushpan fariseokuna, Moisespa killkashkanta yachachikkuna uyarkakuna. Chaypina rimarkakuna: Yachachik, yachanayanchi kan shutipachu Yaya Diosmanta shamushkanki manachu nishpa. Chayrayku munanchi rikunata shuk nima ima uras rikushkanchita Yaya Diospa yachayninwa ruranaykita nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesuska paykunata aynirka: Kankuna Yaya Diosta mana kirinayak kashpaykichimi mana ali rurak runakuna kashpaykichi Yaya Diospa yachayninwa ruranaynita rikunayankichi. Munashpaykichipas manami rurashanchu. Chayllatami rikunkichi Yaya Dios chay ñawpa paypa yachayninwa yachachik Jonaspa pasashkantashinami ñukawa rurananta. ");
INSERT INTO qupNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ñawpa Jonasta shuk saltonshina atun challwa millpurka. Chaypina payka chay challwapa wiksanpi kimsa punchata, kimsa tutata karka. Chaymanta chay challwaka Jonastaka kiwnarka. Chasnashinami ñuka Yaya Diospa Kachashkan Runa kimsa punchata, kimsa tutata allpa ukupi kashkaynimanta kawsarimusha. ");
INSERT INTO qupNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Chay ñawpa Nínive llaktapi kawsak runakuna yapa millaypata rurashpa kawsapayarkakuna. Jonaska paykunata yachachishpanmi tukuy uchata ruranata sakirkakuna Yaya Diosta alita kasushpana kawsanankunapa. Yaya Diospa kastiganan punchapi chay ñawpa Nínive llaktapi kawsak runakunami paypa puntanpi kankunamanta mana alita rurashkaykichita rimankakuna. Ñukaka Jonasmanta ashwan atun yachayyu kashpaynipas mana kiriwanayankichichu. ");
INSERT INTO qupNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Chaymanta ñawpa karu llaktamanta shuk kamachik warmi shamurka Jerusalenma chay atun yachayyu Salomonta uyananpa. Ñukaka Salomonmanta ashwan atun yachayyu kashpaynipas kankunaka manami uyawanayankichichu. Chayrayku Yaya Diospa kastiganan punchapi chay kamachik warmika Yaya Diospa puntanpi kankunamanta mana alita rurashkaykichita rimanka. ");
INSERT INTO qupNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Chaymanta Jesuska paykunata rimarka: Shuk runamanta shuk supay llukshishpanka yaku illa allpakunapimi purin, maskashpa maypimi kawsanka nishpa. Mana maypi samananta tarishpanka yuyarishpa riman: ");
INSERT INTO qupNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Kutishara chay llukshishkayni runamallatata nishpa. Kutishpan chay runata tarikrin shuk wasi suma chusha picharishkatashina. ");
INSERT INTO qupNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Chaypi kanchis paymanta ashwan millaypata rurak supay masinkunata pushakrin. Tukuy paykuna chay runapi yaykushpankuna paywa kawsanahun. Chasnami chay runaka ashwan millaypakunata rurashpa kawsan. Kankunaka yapa millaypata rurak kashpaykichimi chay achka supay yaykushka runashina kankichi. ");
INSERT INTO qupNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús chay runakunata yachachihushkanpi paypa wawkinkuna mamanwa pakta chay wasima paktamurkakuna. Paykunaka Jesuswa kwintanayashpankuna wasi washamantalla payta kayachirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Chaypina shuk runaka Jesusta rimarka: Mamaykimi wawkikikunawa kanchapi chapahunkuna kanwa kwintanankunapa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Chaypi Jesuska chay runata rimarka: Mana mamaynillatachu kikin wawkinikunallatachu yuyani. ");
INSERT INTO qupNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Chaymanta ñukanchikunata makinwa rikuchishpan tukuy runakunata rimarka: Kaykunami mamaynikuna, wawkinikunapas. ");
INSERT INTO qupNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Maykanmi ruran silupi kawsak Yayayni Diospa munashkanta, paymi kan wawkinishina, paninishina, mamaynishina. ");
INSERT INTO qupNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Chay punchalla Jesuska chay wasimanta llukshishpan tiyarik rirka kucha mayanpi. ");
INSERT INTO qupNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Chaypi tiyahushpan achka runakuna payta kayllayarkakuna. Chayrayku Jesuska shuk botipi yaykurka tiyarishpan paykunata yachachinanpa. Chasna yachachihushpan tukuy chay runakuna kucha mayanmanta payta uyarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Chaypina Jesuska chay achka runakunata Yaya Diospa shiminta shuk yachachinakunawa yachachirka kasna nishpa: Akuychi yuyarishunchi, shuk runa arus muyuta tarpuk rirka chakranpi. ");
INSERT INTO qupNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Chaypi chay tarpuk runaka arus muyukunata wichashpa rirka wiñanankunapa. Shuk muyukunaka urmarkakuna ñampipi. Chay ñampipi urmashkataka pishkukuna mikurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Shuk muyukunaka urmarkakuna llapcha allpa samantasapapi. Shuk ratu tukyarirkakuna chay muyukunaka, llapcha allpa kashkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Chaypi yapa intishpan arus wiñahukka wañurirka, mana ankunka yaykunata atipashpan samantapi. ");
INSERT INTO qupNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Shuk muyukunaka urmarkakuna kashasapa allpapi. Chay kashakunaka arus muyukunamanta ashwan utkalla wiñarkakuna. Chasna utkalla wiñahushpan chay kashakunaka nitirkakuna chay arus wiñahukta. Chayrayku aruska mana muyuyarkachu. ");
INSERT INTO qupNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Shuk muyukunaka urmarkakuna ali allpapi. Alita wiñashpankuna sumakta muyuyarkakuna. Shukkunaka muyuyarkakuna shuk pachak muyukunata. Shukkunaka muyuyarkakuna sokta chunka muyukunata. Shukkunaka muyuyarkakuna kimsa chunka muyukunata. ");
INSERT INTO qupNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Tukuy kay yachachihushkaynikunata alita uyashpa yachakuychi. ");
INSERT INTO qupNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Chaymanta ñukanchika payta kayllayashpanchi tapurkanchi: ¿Imaraykuta runakunata chay yachachinakunawa yachachinki? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesuska ñukanchita aynirka: Kankunallata Yaya Dios yachachihun nima pi yachashkanta, imashnami paypa ali kamachinanka kay allpapi. Mana kasunayak runakunataka Yaya Dioska manami yachachinchu. ");
INSERT INTO qupNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tukuy payta kasukkunatami Yaya Dioska sumakta yanapanka ashwanta asirtanankunapa. Mana kasunayakkunataka uchillastu yachashkankunata kunkachinkami. ");
INSERT INTO qupNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Tukuy chay runakunata yachachishpaynipas mana asirtanahunchu. Tukuy ali rurashkaynikunata rikushpankunapas mana yachanahunchu imaraykumi chaykunataka rurani nishpa. Chayrayku mana yapa asirtaypa yachachinakunallawa paykunataka yachachini. ");
INSERT INTO qupNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ñawpa Yaya Diospa yachayninwa yachachik Isaias killkarka Yaya Diosta mana kasunayak runakuna tiyananta. Kasnami Isaiaska Yaya Diospa rimashkanta killkarka: Kay runakunaka ali yachachishkakunata uyashpankunapas manami asirtanahunchu. Ali rurashkaynita rikushpankunapas nima imata asirtanahunchu, imaraykumi chayta rurani nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kay runakunapa yuyayninkuna taparishka kanahun. Ñawinkunaka taparishkashina kashpankuna rurashkaynita mana rikunahunchu. Rinkrinkunaka taparishkashina kashpankuna rimashkaynita mana uyanahunchu. Chasna tukushpankuna manana atipanahunchu uchankunamanta yuyarishpankuna llakirinata, ñuka llakichishpayni paykunata aliyachinaynipa. ");
INSERT INTO qupNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Chaymanta Jesuska ñukanchi runankunallata rimarka: Tukuy kankuna kushilla kankichi, rurashkaynikunata rikushpaykichi asirtashkaykichirayku. Kushilla kankichi yachachihushkaynikunata uyashpaykichi kasushkaykichirayku. ");
INSERT INTO qupNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Alita uyawaychi. Ñawpa Yaya Diospa yachayninwa yachachikkuna, chaymanta achka ali rurak runakunapas yapa riksinayawarkakuna. Paykunaka mana atiparkakunachu riksiwanata, manara kay allpama shamushkaynirayku. Kunanka kankuna ña riksiwashkankichi. Chayrayku yapa kushikuychi. ");
INSERT INTO qupNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Kunan uyaychi imatami yachachinayan chay muyuta tarpuk runawa yachachishkaynika. ");
INSERT INTO qupNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Achka runakunami mana asirtakchu kanahun. Chasna kashpankunami ñampipi chakishka allpapi urmashka muyukunashina kanahun. Chasna runakunaka Yaya Diospa ali kamachinan kay allpapi ña kallarishkanmanta shimita uyashpankunapas manami asirtanahunchu. Supayka shamun Yaya Diospa shiminta shunkunkunamanta kunkachinanpa. ");
INSERT INTO qupNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Chaymanta shuk runakunaka Yaya Diospa shiminta kushilla uyanahun. Chay runakunaka samantasapapi wiñak muyukunashinami kanahun. ");
INSERT INTO qupNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Mana ukupi sapiyushina kashpankuna shuk ratullami Yaya Diosta kushilla katinahun. Kirishkankunarayku runa masinkuna asichishpa parisichihushpankuna nanayta llakiyta musyashpankuna sakinahunna Yaya Diosta katinata. ");
INSERT INTO qupNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Chaymanta shuk runakunaka sumakta shunkunkunamanta pacha Yaya Diospa shiminta munanahun. Chasna alita munashpankunapas yapa kullkillata munashpankuna paykuna kikin munashkankunallata rurashpa kawsashpankuna kunkarinahun Yaya Diospa shiminta. Chasna runakunaka muyukuna kashasapapi urmashka nima ima uras muyuyakkunashina kanahun. ");
INSERT INTO qupNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ashwan shuk runakunaka yapa sumaktami shunkunkunamanta pacha Yaya Diospa rimashkanta asirtashpa kasunahun. Paykunaka Yaya Diosta yuyashpalla kawsanahun. Chasna kashpankunami muyukuna ali allpapi wichashkashina kanahun. Paykunaka shuk muyumanta shuk pachak muyuta muyuyakshinami kanahun, shukkunaka sokta chunka muyuta muyuyakshinami kanahun, shukkunaka kimsa chunka muyuta muyuyakshinami kanahun. ");
INSERT INTO qupNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Chaymanta Jesuska chay achka runakunata shuk yachachinata rimashpa yachachirka kasna nishpa: Yuyariychi imashnami Yaya Diospa ali kamachinanka kay allpapi. Shuk runa chakranpi ali trigu muyukunata tarpushkata rikuychi. ");
INSERT INTO qupNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Shuk tuta tukuy puñuhushkankunapi kuntranka chay tarpushka chakrama rirka millaypa muyukunata chay tarpurishkakunapi shikwachinanpa. ");
INSERT INTO qupNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Chay trigu muyukuna wiñashpan ña muyuyahushkanpi chay millaypa kiwakunapas sumakta wiñarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Chaypina chay chakrayu runapa runankunaka amunta rimarkakuna: Patrón, kan ali trigu muyukunatami tarpurkanki. Maymantataya chay millaypa kiwakunaka wiñahunkuna nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Chay chakrapa amunka rimarka: Chikniwak runami chay millaypa kiwakunataka tarpushka nishpa. Chaypi runankunaka patroyninta tapurkakuna: ¿Munankichu chay kiwakunata pitik rinanchipa? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Chaypi patroyninka aynirka: Mana. Pitihushpaykichika chay millaypa kiwakunata, trigutapas pitinkichimi. ");
INSERT INTO qupNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Sakiychi parihulla wiñanankunapa pallananchi punchakama. Trigu muyu pukushpanka ñukami kachasha pallak runakunata, chay millaypa kiwakunataka pitishpankuna tantachishpa rupachinankunapa. Chaywasharami trigu muyuta pallashpankuna wakaychana wasinipi churankakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Chaymanta Jesuska chay runakunata kaytapas yachachirka kasna nishpa: Yuyariychi imashnami Yaya Diospa ali kamachinanka kay allpapi. Mostasa muyuta rikuychi. Tukuy muyukunamanta ashwan uchillastumi kan. Shuk runa chakranpi tarpushpanka shuk uchilla tarpukunamanta ashwan atuntami wiñan. Shuk kaspishinami atunta ramayan. Chaypi pishkukunaka shamunahun, wasinstukunatapas ruranahun. Chasna rimashpan Jesuska yuyachirka puntiru shukkunalla Yaya Diospa kamachishkankuna tukunankunata, chaymanta kirikkunaka achka tukunankunata. Chasna kashpan shukkuna kushilla paykuna chawpipi kawsak shamunahun. ");
INSERT INTO qupNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Chaymanta Jesuska kuti yachachihushpan chay runakunata rimarka: Yuyariychi imashnami Yaya Diospa ali kamachinanka kay allpapi. Levadurata rikuychi. Shuk warmi panta rurahushpan kimsa mati harinapi uchillastu levadurata yakuwa chapurishkata churan. Chaywa chapushpan tukuy harinaka panrayku alita punkin. ");
INSERT INTO qupNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesuska achka yachachinakunawa tukuyta chay runakunata yachachirka. Nima ima uras rimarkachu kuska asirtana shimikunata. ");
INSERT INTO qupNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ñawpa Yaya Diospa yachayninwa yachachikka killkarka, imashnami Jesuska yachachinka nishpa. Chay killkashkanpika kasnami riman: Ñukaka chikan chikan yachachinakunawami runakunata yachachisha pakalla kashkakunata. Yaya Dios kay allpata rurashkanmanta pacha mana nima pi yachashkankunatachu yachachisha nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Chaymanta Jesuska chay achka runakunata kutinankunapa rimashkanwasha yaykurka shuk wasipi. Chaypi ñukanchi payta kayllayashpanchi tapurkanchi chay millaypa kiwa chakrapi wiñashkamanta yachachishkanta asirtachinanpa. ");
INSERT INTO qupNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Chaypina Jesuska rimarka: Ñuka Yaya Diospa Kachashkan Runami shuk chakrayu runa ali muyukunata tarpukshinami kani. ");
INSERT INTO qupNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kay allpaka chakraynishinami. Yaya Diospa ali kamachihushkanpi kawsak payta kasuk runakunami chay ali muyukunashina kanahun. Supaypa kamachishkankunata kasuk runakunaka chay mana ali kiwakunashinami kanahun. ");
INSERT INTO qupNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Supayka chay millaypa kiwakunataka shikwachik runashinami. Kay allpa tukurinaka chay trigu muyuta pallana punchashinami. Angelkunaka chay trigu muyukunata pallak runakunashinami kanahun. ");
INSERT INTO qupNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Imashnami millaypa kiwakunata pichashpa rupachinchi ninapi, chasnallatatami kay allpa tukurihushpan Yaya Dioska tukuy uchasapa runakunataka nina mana wañukpi rupachinka. ");
INSERT INTO qupNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ñuka Yaya Diospa Kachashkan Runami angelkunata kachasha, kamachinaynipi mana ali rurak runakunata, runa masinkunata uchata rurachikkunatapas tantachinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tukuy paykunata tantachishpankunami ñukaka wichusha nina mana wañukma. Chaypimi paykunaka sinchita parisishpa wakankakuna, piñaywa kirunkunata kanirinkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Chaymanta tukuy maykankunami Yaya Diospa munashkanta rurashpa kawsanahun, paykunaka Yaya Diospa kamachinan mushu mundumami rishpankuna inti sumakta punchayachihukshina rikurinkakuna. Tukuy kay yachachihushkaynikunata alita uyashpa yachakuychi nishpami yachachirka Jesuska. ");
INSERT INTO qupNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Chaymanta Jesuska kuti yachachihushpan rimarka: Yuyariychi imashnami Yaya Diospa ali kamachinanka kay allpapi. Shuk yapa valik oro pamparishkata rikuychi. Shuk runa allpapi pakashka yapa valik orota tarirka. Chay tarishkantaka chayllapi kuti pampashpa sakirka. Chaypi yapa kushikushpa kutishpan tukuy tiyapushkanta rantichirka. Chay kullkiwana rantirka chay oroyu allpata. ");
INSERT INTO qupNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Chaymanta Yaya Diospa ali kamachinanka shuk yapa achka valik perlashinami. Shuk wirakucha maskashpa purirka atun yapa valik yura wallkashina rikunayu perlata. ");
INSERT INTO qupNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Chaypi achka valik atun yura perlata tarishpan tukuy tiyapushkankunata rantichirka. Chay kullkiwana rantik rirka chay yapa valik perlata. ");
INSERT INTO qupNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Chaymantapas Yaya Diospa ali kamachinanka kay allpapi shuk atun yakupi aysay tukuhushka redishinami kan. Rediyak runakunata yuyariychi. Rediyashpankuna chikan chikan challwakunata apinahun. ");
INSERT INTO qupNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Chaymanta redinkunata tiyuma aysashpankuna challwakunata akllanahun. Tukuy ali challwakunataka tasankunapi churanahun mana ali challwakunataka yakumami wichunahun. ");
INSERT INTO qupNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Chasnallatatami kay mundu tukurihushkanpi, chay challwakunata akllak runakunashina angelkunaka runakunata akllankakuna. Mana kasuk runakunataka anchuchinkakunami Yaya Diosta alita katik runakunamanta. ");
INSERT INTO qupNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Chay mana kasuk runakunataka nina mana wañukmami wichunkakuna. Chaypimi sinchita parisishpa wakankakuna, piñaywa kirunkunata kanirinkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yachachinankunata tukuchihushpan Jesuska ñukanchita tapurka: ¿Asirtankichichu kay yachachihushkaynikunata? nishpa. Chaypina aynirkanchi: Ari, asirtanchimi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Chaypi Jesuska ñukanchita rimarka: Rikuychi, shuk wasi amu achka mushu mawka charishkankunata wakaychakta. Chay charishkankunamanta maykantachari munan chayta surkun. Chay wasi amuka Yaya Diospa killkachishkanta yachachikshina kan, maykanmi Yaya Diospa ali kamachinan kay allpapi ña kallarishkanmanta yachachishkaynita alita yachakurka. Chasna runaka yachan kay mushu yachachishkaynita, ñawpa Yaya Diospa yachachishkantapas runakunata yachachinata. ");
INSERT INTO qupNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Chaymanta Jesuska tukuy chay yachachinakunata rimashkanwasha chay llaktamanta llukshirka. ");
INSERT INTO qupNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Chasna rishpan kikin llaktanpi paktarka. Chaypina tantarinankuna wasipi Yaya Diospa shiminta yachachirka. Chasna yachachihushkanta uyashpankuna tukuy chay runakunaka mancharishpankuna nirkakuna: ¿Maypitaya kay runaka chay tukuyta yachakushka? ¿Imashnataya ruran mana atipaypakunata? ");
INSERT INTO qupNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Manachu kay runaka karpintirupa wawan? ¿Manachu mamanka Maria, wawkinkunaka Santiago, José, Simón, Judas? ");
INSERT INTO qupNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Paninkunaka manachu kay llaktanchipi kawsanahun? ¿Pitaya payta yachachishka chay tukuyta yachananpaka? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Chasna yuyarishpankuna chay llaktanmantalla kashpankunapas Jesusta mana kasunayarkakunachu. Chayrayku Jesuska paykunata rimarka: Tukuy Yaya Diospa yachayninwa yachachiktaka kikin llaktanpika, kikin wasinpika manami ayllunkunaka kasunahunchu. Shuk llaktakunapimi yachachishpan runakunaka alita kasunahun nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Chasna llaktanpi kawsak runakuna payta mana kirishkankunarayku Jesuska kikin llaktanpi mana achkatachu atun yachaywa ruranakunata rurarka. ");
INSERT INTO qupNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Chay punchakunapi Galilea allpapi kamachik apu Herodeska uyarka Jesús achka mana atipaypakunata rurahushkanta. ");
INSERT INTO qupNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Chaypi Herodeska runankunata yanka rimarka: Chay Jesuska wañuchishkayni Bawtisak Juanchari wañushkanmanta kawsarimushka. Chayraykumi atipan Yaya Diospa yachayninwa ruraypakunata ruranata nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Kay Herodeska ñawpa Juanta kadenakunawa watashpan karselpi churarka, wawkin Felipepa warmin Herodias chasna munashkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Manara Juanka karselpi churay tukushpanra apu Herodes chay wawkinpa warminta apishkanraykumi Juanka payta kunarka Yaya Dioska mana munanchu kachuykiwa kawsanaykipa nishpa. Chayta rimashkanraykumi Herodeska Juanta karselpi churarka. ");
INSERT INTO qupNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodeska piñarishpan Juanta wañuchichinayashpanpas runakunata manchashpan mana atiparkachu. Tukuy runakuna yacharkakuna Juan Yaya Diospa yachayninwa yachachik kananta. ");
INSERT INTO qupNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Chay punchakuna Herodespa wawayarishkan puncha paktashpan fiestata rurarka. Chaypi Herodiaspa shipas wawanka sumakta baylarka tukuy kayashkan runakunapa rikuhushkanpi. Chayta rikuhushpan Herodeska yapa kushikurka. ");
INSERT INTO qupNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Chayrayku chay shipasta tukuy runakunapa uyahushkankunapi rimarka shutipa paktachinanpa: Imatachari tapuwanki, chayta kushkayki nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Chay shipaska mamanta tapuk rirka: ¿Imatata tapusha? nishpa. Mamanka Juanta wañuchichinayashpan wawanta kunarka Herodesta tapunanpa, Bawtisak Juanpa umanta shuk kallanapi churashpa kuway yachanaynipa shutipa pitichichishkaykita nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Chasna tapushpan Herodeska sinchita llakirirka. Achka kayashkan runakunapa rikushkankunapi rimashkanraykumi kamachirka Juanpa umanta pitishpa kunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Shuk suntalunkunata kamachirka, karselma rishpankuna Juanta wañuchishpa umanta pitinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Chasna pitishkankunawasha shuk kallanapi apamushpankuna chay shipasta kurkakuna. Chaymanta chay shipaska mamantana kurka. ");
INSERT INTO qupNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Chayta yachashpankuna Juanpa runankunaka paypa aychanta apashpankuna urku uchkupi churashpa tapak rirkakuna. Churashkankunawasha Jesusta rimak rirkakuna Juan wañushkanmanta. ");
INSERT INTO qupNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesuska Juanta wañuchishkankunata yachashpan chay llaktamanta llukshishpan sapallan rirka shuk botipi chunlla chakishka allpama. Chasna Jesús rihushkanta achka runakuna yachashpankuna tukuy llaktakunamanta kucha mayanta kallpashpa payta katirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesuska botimanta llukshihushpan achka runakunata rikurka. Paykunata rikushpan llakichirka. Chasna llakichishpanmi chay apashkankuna unkushkakunata ampirka. ");
INSERT INTO qupNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Chaymanta ña tutayahushpan ñukanchika Jesusta kayllayashpanchi rimarkanchi: Ñami chishiyashkanchi. Kaypika manami nima shuk runa kawsanchu. Tukuy kay runakunata kachay, llaktankunama rishpankuna mikunankunata rantinankunapa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Chaypi Jesuska ñukanchita aynirka: Mana munanichu rinankunapa. Kankuna karaychi paykunata. ");
INSERT INTO qupNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Chaypi ñukanchi aynirkanchi: Pichka panstu, ishkay challwastullami tiyan ñukanchipaka. ");
INSERT INTO qupNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesuska ñukanchita aynirka: Apamuychi ñukama. ");
INSERT INTO qupNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kushpanchi Jesuska tukuy chay runakunata kamachirka pastuyu allpapi tiyarinankunapa. Chaymanta chay pichka panta, ishkay challwata apishpan siluma rikushpan Yayan Diosta agradesirka. Agradesishkanwasha chay pankunataka pakishpa pakishpa ñukanchita kurka. Chaypina ñukanchikunaka chaypi kahukkunata mikunankunapa kurkanchi. ");
INSERT INTO qupNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Chay achka runakunaka mikurkakuna saksanankunakama. Mikushkankunawasha ñukanchikunaka puchurishkanta tantachirkanchi chunka ishkay tasa untakta. ");
INSERT INTO qupNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Chay mikuk karikunaka pichka waranka karkakuna. Achka warmikuna wawakunapas mikurkakuna, paykunataka mana yuparkanchichu. ");
INSERT INTO qupNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Chaymanta Jesuska ñukanchikunallata rimarka: Ñuka tukuy kay runakunata wasinkunama kutinankunapa rimanaynikama, kankunaka botipi kucha chimpama riychi. ");
INSERT INTO qupNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Chay runakuna rishkankunawasha Jesuska sapallan shuk urku awama sikarka Yayan Diosta mañananpa. Tutayanankamami payka sapallan chaypi karka. ");
INSERT INTO qupNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Jesús chay urkupi kanankama ñukanchika botipi ña chawpi kuchapi rihurkanchi. Chasna chimpahushpanchi puntanchimanta yakuka yapa sinchita wayrawa ulasyarka. Botinchita ulaska wayraka sinchita waktarka. ");
INSERT INTO qupNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ña pakarihushpan Jesuska yaku awata purishpa ñukanchita kayllayak shamurka. ");
INSERT INTO qupNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Jesusta yaku awata purihushkanta rikushpanchi mana riksirkanchichu. Yapa mancharishpa kaparirkanchi: ¡Ay, almatami rikuhunchi! ");
INSERT INTO qupNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Chasna kaparihushpanchi Jesuska ñukanchita rimarka: Sinchikuriychi. Ñukami kani, ama manchariychichu. ");
INSERT INTO qupNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Chaypi Pedroka aynirka: Kan Jesús kashpaykika rimaway kanma rinaynipa, yaku awata purishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesuska aynirka: Shamuy ñukama. Chayta uyashpan Pedroka botimanta uraykushpan Jesusma rirka yaku awata purishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Chasna rihushkanpi yaku awapi musyarka sinchi wayra paypi waktarihushkanta. Chaypi mancharirka. Chasna mancharihushpan kallarirka yaku ukuta yaykunata. Chaypi sinchita kaparishpa rimarka: ¡Kishpichiway Yaya Jesús! nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Chay ratulla makinmanta apishpan Jesuska nirka: Imaraykuta mana tukuy shunkuykimanta pacha ñukata kiriwankichu sinchikurinaykipa. ");
INSERT INTO qupNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ña Pedro Jesuswa botipi uraykuhushkankunapi chay sinchi wayraka pasarirka. ");
INSERT INTO qupNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Chaypi ñukanchi botipi kahukkunaka Jesuspa puntanpi kunkurishpanchi nirkanchi: Shutipami Yaya Diospa Wawan kanki nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Chay sinchi wayra pasarishpanna chay kucha chimpama Genesaret allpapi Jesuswa pakta paktarkanchi. ");
INSERT INTO qupNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Chaypi kawsak runakunaka Jesusta riksishpankuna tukuy runakunata rimashpa purirkakuna ñami Jesuska paktamushka nishpa. Chayta yachashpankuna unkushkakunata Jesusma apamurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Chay unkushkakunaka Jesusta rimarkakuna: Churarishkaykipa shiminllatami llankanayanchi ampirinanchipa nishpa. Chasna rimashpankuna Jesuska chay unkushkakunata churarishkanpa shiminta llankachishpan ampirka. ");
INSERT INTO qupNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Chaymanta fariseokuna, Moisespa killkashkanta yachachikkunapas Jerusalén llaktamanta rishpankuna Jesusta kayllayarkakuna tapunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Chaypi paykunaka nirkakuna: ¿Imaraykutaya runaykikunaka yaya rukunchikuna wañupa rurashkankunata mana kasunahunchu? Ñukanchi yuyarinchi manara mikuhushpanchi makinchita yakuwa ukuchinanchi tiyan mana uchayu kananchipa. ¿Imaraykuta runaykikunaka mana chasna ruranahunchu? ");
INSERT INTO qupNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Chaypi Jesuska paykunata aynirka: Kankunaka Yaya Diospa kamachishkanta mana kasushpaykichimi yaya rukuykichi wañupa rurashkankunallata kasushpa kawsankichi. Imaraykuta chasna rurankichi. ");
INSERT INTO qupNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kasnami Yaya Dioska kamachin: Yayaykichita mamaykichita yuyashpa kasushpa kawsaychi nishpa. Chaymanta: Maykanmi yayanta mamanta chiknishpa riman mana ali kananta, chay runataka apuykichimi wañuchinan tiyan nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Chasna Yaya Dios rimashpanpas kankunaka chikantami yachachihunkichi. Runakunata rimankichi yayaykichipa mamaykichipa pishihushpanpas mana yanapanaykichi tiyan rimashpaykichi kankunata yanapanayni kullkitaka Yaya Diostami kushkani. Chayraykumi manana tiyawannachu kankunata yanapanaynipa nishpa. Chasna yaya rukuykichi wañupa rurashkanllatami rurashpa kawsahushkaykichirayku Yaya Diospa kamachishkankunata mana kasuhunkichichu. ");
INSERT INTO qupNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ali runakuna kanchi nishpa yuyarishpaykichipas llulla runakunami kankichi. Yaya Diospa yachayninwa yachachik Isaias wañuka alita rimarka kankunamanta Yaya Diospa ñawpa rimashkanta kasna: ");
INSERT INTO qupNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Kay runakunaka shiminkunallawami yuyawanahun. Manami tukuy shunkunkunamanta pachachu yuyawanahun. ");
INSERT INTO qupNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Runakunapa kamachishkankunata rimashkaynitashina yachachishpankuna yankami ñukata mañana wasipi tantarinahun kushichiwanankunapa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Chasna rimashpan Jesuska shuk runakunatana kayarka payta kayllayanankunapa. Paykunata rimarka: Alita uyawaychi asirtanaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Imata mikushpaykichipas manami uchata rurankichichu. Shunkuykichipi millaypata yuyarishkaykichita rimashpaykichimi shuti uchata rurankichi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Chaymanta ñukanchika payta kayllayashpanchi rimarkanchi: ¿Yachankichu chay fariseokuna rimashkaykita uyashpankuna piñarishkankunata? ");
INSERT INTO qupNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","Chaypina Jesuska aynirka: Ama llakiriychichu chay fariseokunaka piñarihushpankuna. Paykunaka Yaya Diospa kamachishkanta mana alita asirtashpankunami mana yachak runakunata pantachichinahun. Wawkikuna panikuna rikuychi. Tarpushpanchi shuk muyuta, chaypi millaypa kiwakunapas wiñanahun. Kankunaka millaypa kiwakunata surkushpaykichimi wichunkichi. Chasnallatatami Yaya Dioska mana ali yachachikkunataka kastiganka. Paykunaka wisku runakuna wisku masinkunata pushahukshinami kanahun. Chasna kashpankunami ishkanti uchkupi urmankakuna nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Chaymanta Pedroka Jesusta rimarka: Chay yachachishkaykita ashwan alita ñukanchita asirtachiy nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Chaypi Jesuska aynirka: ¿Kankunapas manarachu asirtankichi chay rimashkaynita? ");
INSERT INTO qupNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Tukuy mikunami mikushpanchika wiksanchima rin. Chaymanta llukshin aychanchimanta. Imatapas mikushpanchika manami uchatachu ruranchi. ");
INSERT INTO qupNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Maykantami rimanchi shunkunchipi yuyarishkanchimanta shamun. Chaymi shuti uchayachin. ");
INSERT INTO qupNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Shuk runa manara millaypata rurahushpanra shunkunpi yuyarin chay millaypata rurananpa. Chaymanta tukuy chay millaypakunata ruran. Chay millaypa ruranakuna kanahun: Shuk runata chiknishpa wañuchina, shuk warmiyu kari shuk warmiwa musayana, shuk kusayu warmi shuk kariwa musayana, chaymanta tukuywa musayanakuna, shuwana, llullana, runa masinta chiknishpa kamina. ");
INSERT INTO qupNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Shuk runa chay mana alikunata rurashpan uchayan. Mana makinchita yakuwa ukuchishpa mikushpanchika manami uchayanchichu. ");
INSERT INTO qupNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesuska chay llaktamanta llukshishpan rirka Tiro, Sidón llaktakunama. ");
INSERT INTO qupNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Chaypi shuk warmika Jesusta kayllayarka. Chay warmika ñawpa Kanaán allpapi kawsak runakunamanta kashpan mana israel warmichu karka. Payka Jesusta kayllayahushpan kaparishpa rimarka: ¡Yachachik, Davidpa Miraymanta Kishpichik, llakichiway! Shipas wawaynipimi supayka yaykushpan payta yapa parisichihun nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesuska chayta uyashpanpas nima imata aynirkachu. Chaypina Jesusta kayllayashpanchi rimarkanchi: Chay warmita rimay kaymanta anchurinanpa, yapami ñukanchita kaparishpa apanakuhun nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesuska chay warmita aynirka: Yaya Dioska kachawashkami israel runa masinikunallata yanapanaynipa. Paykunami obeha chinkarishkashina kawsahunkuna nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Chayta uyashpan chay warmika Jesuspa puntanpi kunkurik rirka kasna nishpa: Yachachik, yanapaway. ");
INSERT INTO qupNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Chaypi Jesuska aynirka: Manarapas chikan runakunata aliyachihushpaynira israel masinikunatarami yanapanayni tiyan. Manami alichu shuk runa mikunata wawankunamanta kichushpa allkukunata karananpa. ");
INSERT INTO qupNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Chasna Jesús rimashpan chay warmika aynirka: Ari yachachik, chasna kashpanpas allkukunapa amun mesapi mikuhushpanka mikunanmanta wicharishkatami allkukunapas mikunahun. ");
INSERT INTO qupNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Chaypi Jesuska rimarka: Pani, maytukuytata shunkuykimanta pacha kiriwanki. Chayrayku shipas wawaykitaka ñami ampishkani. Chay ratulla chay shipaska ampirirka. ");
INSERT INTO qupNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Chaymanta Jesuska ñukanchikunawa chay llaktakunamanta llukshishpan Galilea kucha mayanpi paktarka. Chaypi shuk urku awama sikashpan tiyarik rirka. ");
INSERT INTO qupNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Chay urku awapi kahushpanchi achka runakuna achka unkushkakunata apamushpankuna Jesuspa puntanpi churak shamurkakuna. Mana purinata atipakkunata, wiskukunata, waklishka makiyu waklishka chakiyu runakunata, mana rimanata atipakkunatapas, chaymanta ashwan achka unkushkakunata apamurkakuna. Chaypina Jesuska tukuy chay unkushkakunata ampirka. ");
INSERT INTO qupNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Chasna ampirishpankuna mana rimanata atipakkuna kallarirkakuna rimanata. Waklishka makiyu waklishka chakiyu runakunapas aliyarkakuna. Mana purinata atipakkunapas alita purirkakuna. Wiskukunapas atiparkakuna rikunata. Chayta rikushpankuna tukuy runakuna mancharishpankuna ñukanchi israel runakunapa Yayanchi Diosta kushichirkakuna, Yaya Dios, kanmi tukuyta atipak kanki nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Chaymanta Jesús ñukanchita kayashpan rimarka: Llakichinimi kay runakunata. Ñami kimsa punchata ñukanchita katihunkuna. Mikuna illa kay runakunaka. Manami kachanayanichu mana mikushpa wasinkunama kutinankunapa. Chasna mana mikushpa rishpankunaka pakta ñampi chawpipi lismayanahuma nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ñukanchika Jesusta nirkanchi: ¿Imashnataya kay tukuy achka runakunaraykuka tarinchima mikunata? Kaypika nima shuk runa kawsanchu. ");
INSERT INTO qupNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesuska ñukanchita tapurka: ¿Masna pantata charinkichi? Ñukanchika aynirkanchi: Kanchis panllami, chaymanta masna challwastukuna. ");
INSERT INTO qupNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Chaypina Jesuska chay runakunata rimarka allpapi tiyarinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Chaymanta chay pankunata, challwastukunatapas apishpan Yayan Diosta agradesirka. Chaymanta paki paki rurashpan ñukanchita kurka chay tiyahuk runakunata kunanchipa. ");
INSERT INTO qupNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Chasna kushpanchi chay runakuna tukuy mikurkakuna saksanankunakama. Mikushkankunawasha puchurishkatana tantachishpanchi kanchis tasata untachirkanchi. ");
INSERT INTO qupNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Chay mikuk karikunami chusku waranka karkakuna. Achka warmikuna, wawakunapas mikurkakuna, paykunataka mana yuparkanchichu. ");
INSERT INTO qupNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Chaywashami Jesuska chay runakunata rishara nishpan ñukanchiwa pakta shuk botipi uraykushpan chimparkanchi Magdala shutiyu llaktama. ");
INSERT INTO qupNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Chaymanta fariseokuna saduseokunawa parihu Jesusta kayllayashpankuna yapa runakunata riksichinayashpankuna mana Yaya Diospa kachashkan kananta tapurkakuna: Ñukanchirayku ruray Yaya Diospa yachayninwa shuk nima ima uras rikushkanchita. ");
INSERT INTO qupNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Chasna tapushpankuna Jesuska paykunata aynirka: Kankunaka inti pukanlla yaykuhushkata rikushpaykichi rimankichi kayaka ali punchami tukunka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Chaymanta shuk puncha tutamanta puyu pakarihushpan rimankichi ñami punchaka waklishka nishpa. Alita tukuy chaykunata yachashpaykichipas rurashkaynikunata rikushpaykichika ¿manachu asirtankichi imaraykumi chaykunata rurashkani? ");
INSERT INTO qupNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kankunaka Yaya Diosta mana kasushpaykichimi mana ali yuyayyu runakuna kankichi. Tapuwashpaykichipas Yaya Diospa yachayninwa rurashkaynita rikuchinaynipa, manami rurashanchu yanka rikunaykichipaka. Kayllatami rikunkichi, imashnami Yaya Dioska ñawpa paypa yachayninwa yachachik Jonasta kimsa punchamanta wañuymanta kishpichirka, chasnallatatami kuti ruranka ñukawa. Chasna rimashkanwasha paykunata sakishpan shuk partima rirka. ");
INSERT INTO qupNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Chaymanta ñukanchi Jesuspa runankunaka kucha chimpama paktashpanchi yuyarirkanchi panta apanata kunkashkanchita. ");
INSERT INTO qupNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Chaypina Jesuska ñukanchita rimarka: Alita yuyariychi. Kuyrariychi fariseokunapa saduseokunapa levaduramanta. ");
INSERT INTO qupNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Chasna Jesús levaduramanta rimashpan maykanwami chapushpa panta punkichinchi ñukanchipura tapunakurkanchi: Panta mana apamushkanchiraykumi chasna ñukanchita rimahun. ");
INSERT INTO qupNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Chaypi Jesuska rimahushkanchita uyashpan rimarka: ¿Imaraykuta chasna kankunapura tapunakunkichi? Mana chay panta kunkashkaykichimantachu kankunata rimahuni. Kankunaka manachu ñukapi sinchikurinkichi. ");
INSERT INTO qupNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Manarachu asirtankichi pichka panwa pichka waranka runakunata karashkaynita? ¿Manachu yuyarinkichi masna tasatami untachirkankichi chay mikuna puchurishkanta? ");
INSERT INTO qupNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Chaymanta ¿manachu yuyarinkichi kanchis panwa chusku waranka runakunata karashkaynita? Chaymanta ¿manachu yuyarinkichi masna tasatami tantachirkankichi chay mikuna puchurishkanta? Tukuy uras chasnallatata atipani ruranata. ");
INSERT INTO qupNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Imaraykuta kankunaka mana alita asirtankichichu? Manami panmantachu rimahuni. Kutikashka rimani, kuyrariychi fariseokunapa saduseokunapa levaduramanta nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Chaypirami ñukanchika asirtarkanchi chay Jesuspa rimahushkanta. Manami kikin panta punkichik levaduramantachu rimahurka, ashwan fariseokunapa saduseokunapa waklichik yachachinankunamantami ñukanchita rimarka. ");
INSERT INTO qupNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Chaymanta Sesarea Filipo shutiyu llaktapi paktashpanchi Jesuska ñukanchita tapurka: Runakuna kwintahushpankuna ¿pimi kani ninahuntaya? ");
INSERT INTO qupNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Chaypi ñukanchika aynirkanchi: Shukkunaka ninahunmi Bawtisak Juanchari wañushkanmanta kawsarishka kanaykita. Shukkunaka ninahunmi Yaya Diospa yachayninwa ñawpa yachachik Eliaschari kanaykita, maykanmi kuti shamunan karka. Shukkunaka ninahunmi Yaya Diospa yachayninwa ñawpa yachachik Jeremiaschari wañushkanmanta kawsarishka kanaykita. Mana kashpaka Yaya Diospa yachayninwa shuk ñawpa yachachikchari kawsarishka kanaykita nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Chaymanta ñukanchitana tapurka: Kankunaka, ¿pimi kani ninkichitaya? ");
INSERT INTO qupNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Chaypi Simón Pedro shutiyuka aynirka: Kanmi kanki kawsa Yaya Diospa Wawan, paypa Kachashkan Kishpichik. ");
INSERT INTO qupNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Chasna Simón Pedro rimashpan Jesuska payta rimarka: Kushilla kanki Simón, Jonaspa wawan. Chaytaka manami runachu kanta riksichishka, ashwan Yayayni Dios silupi kawsakmi riksichishka. ");
INSERT INTO qupNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ñukami kanta rimani, kanmi kanki Pedro. Pedro nishkanka rumimi. Chasna kashpan Jesuska rimashpa katirka: Tukuy shunkuykimanta pacha ñukata kiriwashkaykirayku sinchi rumishinami kanki. Kan yachachishpayki achka runakunata yanapasha paykunapas ñukapi sinchikurishka kiriwanankunapa. Chasna shuk wasihuk runashina kankunawa wasinita rurahushpayni kantami churasha chay wasita sinchikuchik rumishina kanaykipa. Tukuy kiriwakkuna shuk sumakta rurarishka wasishina kashpaykichi nima wañuna atipankachu tukuchinata. ");
INSERT INTO qupNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kanta churasha kay allpapi kamachihushkaynirayku punkupi kuyrahuk runashina kanaykipa. Shuk runata rimashpayki uchaykika llakichirishkami kan nishpa, Yaya Diospas ari, chasna kachun ninkami. Shuk runata rimashpayki uchaykika mana llakichirishkachu kan nishpa, Yaya Diospas ari, chasna kachun ninkami. ");
INSERT INTO qupNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Chasna Pedrota rimashkanwasha Jesuska ñukanchita nirka: Ama nima pita rimankichirachu ñuka Yaya Diospa Kachashkan Kishpichik kanaynita. ");
INSERT INTO qupNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Chaymanta pacha Jesuska ñukanchita alita asirtachishpa rimarka: Ñuka Jerusalenma rinayni tiyan. Chaypimi ñukanchita kamachik israel masinchi rukukuna, saserdotekunapa apunkuna, Moisespa killkashkanta yachachikkunapas yapa chikniwashpankuna parisichiwankakuna. Paykunaka chikniwashpami wañuchiwankakuna. Chasna wañuchiwashpankunapas kimsa punchamantami kawsarisha. ");
INSERT INTO qupNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Chayta uyashpankuna Pedroka Jesusta chaynikstuma pushashpan rimarka: Yaya Jesús, chaytaka ama rimaychu. Yaya Dioska manami munamachu chasna pasanaykipa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Chayta uyashpan Jesuska tikrarishpan Pedrota rimarka: Anchuriy ñukamanta, supaykunapa apunshina rimahunki. Llullachinayawahunkimi Yaya Diosta mana kasunaynipa. Manami Yaya Diospa munashkantachu rimawahunki, ashwan runapa yuyarinanllatami rimawahunki nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Chaymanta Jesuska tukuy ñukanchikunata rimarka: Kankuna ñukata katinayawashpaykichika ama kankuna kikin munashkaykichita ruraychinachu. Kankunata chiknik runakuna piñarishpa wañuchinayahushpankunapas ñukallata katiwaychi. ");
INSERT INTO qupNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Maykanmi wañuyta manchashpan sakiwan, chayka wiñaypami wañunka. Maykanmi ñukata katiwahushpan chikninata wañuyta parisin, chayka wiñaypami Yaya Dioswa kawsak rinka. ");
INSERT INTO qupNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Imata valin shuk runa tukuy kay mundupi tiyashkata apinanpa. Tukuy chaykunata apishpanpas wiñaypami wañunka. Masna kullkitapas kunayashpaykichika manami atipankichichu rantinata chay wiñaypa Yaya Dioswa kawsanataka. ");
INSERT INTO qupNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ñuka Yaya Diospa Wawan silumanta angelkunawa shamuhushpayni suma chuyahlla rikurishpami shamusha Yayaynipa yachayninwa. Chay urasmi mana alita rurak runakunataka kastigasha. Chaymanta kasuwak runakunataka rimasha ñukawami silupi kawsankichi. ");
INSERT INTO qupNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Alita uyawaychi. Shuk kankunamanta kaypi kahukkunaka manara wañuhushpaykichira ñuka Yaya Diospa Kachashkan Runata rikuwankichimi wañushkaynimanta kawsarimushpayni kay allpapi kamachik tukunaynita. ");
INSERT INTO qupNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Chaymanta Jesuska sokta punchamanta Pedrowa, Santiagowa, paypa wawkin Juanwapas sikarka shuk atun urku awama. ");
INSERT INTO qupNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Chay urkupi kahushpankuna chay kimsa runankunaka Jesusta chuyahlla chikanyashkanta rikurkakuna. Uyanka intishina punchayachirka. Churarishkanpas yura chuyahlla sintihushkashina rikurirka. ");
INSERT INTO qupNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Chay kimsa runankunaka rikurkakuna ñawpa yachachikkuna Moisesta, Eliastapas Jesuswa kwintahukkunata. ");
INSERT INTO qupNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Chayta rikushpan Pedroka mancharishpa rimarka: Yaya Jesús, alitami kaypi kahunchi. Munashpaykika rurashu kimsa tampukunata, shukta kanrayku, shuktaka Moisesrayku, shuktaka Eliasrayku nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Chasna Pedroka rimahushkanpi shuk chuyahlla rikurik puyuka paykunata arkamurka. Chay puyu ukumanta uyarkakuna Yaya Diospa rimahushkanta: Kay Jesuska munashkayni Wawaynimi. Paymi ñukata sumakta kushichiwan. Kasuychi payta. ");
INSERT INTO qupNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Chayta uyashpankuna chay kimsa Jesuspa runankunaka mancharishpankuna allpapi kunkurishpa kumurirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Chaypina Jesuska kayllayashpan paykunata llankashpan rimarka: Atariychi, ama manchariychichu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Paykunaka atarishpankuna Jesusta sapallantana rikurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Chay urkumanta uraykuhushpankunana Jesuska paykunata rimarka: Kay urkupi rikushkaykichitaka ama nima pita kwintankichirachu, ñuka Yaya Diospa Kachashkan Runa wañushkaynimanta kawsarimunaynikama. ");
INSERT INTO qupNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Chaypina chay kimsa runankunaka Jesusta tapurkakuna: ¿Imaraykutaya Moisespa killkashkanta yachachikkunaka rimanahun, manara Yaya Diospa Kachanan Kishpichikka shamuhushpanrami Yaya Diospa yachayninwa ñawpa yachachik Eliasra kuti shamunka nishpa? ");
INSERT INTO qupNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesuska paykunata aynirka: Shutipami riman, puntiru Elias kuti yachachik shamunka runakuna kawsayninkunata alicharinankunapa Yaya Dioswa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ñuka kankunata rimani, Eliaska ñami shamushka. Runakuna manami riksirkakunachu payta. Chasna mana riksishpankunami parisichishpa payta wañuchirkakuna. Chasnallatatami ñuka Yaya Diospa Kachashkan Runa kashpayni ñukatapas parisichishpa wañuchiwankakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Chasna Jesús rimahushpanrami chay runankunaka asirtarkakuna Eliasmanta rimahushkanwa Bawtisak Juanmanta paykunata rimahushkanta. ");
INSERT INTO qupNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Chaymanta Jesuska chay kimsa runankunawa urkumanta uraykumushpan achka runakuna kahushkanpi paktamurkakuna. Chaypi shuk runaka Jesusta kayllayashpan puntanpi kunkurishpan rimarka: ");
INSERT INTO qupNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Yachachik, wawaynita llakichishpayki ampipay. Yapa achkatami parisipahun. Maypipas kahushpan sinchiyarishpa allpama urman. Achka kuti ninapi yakupipas urmapan. ");
INSERT INTO qupNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Kay wawaynita apamurkani runaykikunama. Paykunaka mana atipashkakunachu ampinata. ");
INSERT INTO qupNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Chaypi Jesuska tukuy runakunata rimarka: Mana ali yuyayyu runakuna, kankunaka manami sinchikunkichichu ñukapi. Ima uraskamataya kankunawa kiparishpa yachachishkaykichi. Apamuychi kayma chay unkushkata. ");
INSERT INTO qupNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Chay wawata pushamushpankuna Jesuska chay unkuchik supayta sinchi shimiwa kamachirka ¡llukshiy kay wawamanta! nishpa. Chay ratulla chay wawaka ampirishka kiparirka. ");
INSERT INTO qupNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Chaymanta tukuy ñukanchi Jesuspa runankuna shuk parti paywa tantarishpanchi tapurkanchi: ¿Imaraykutaya mana ñukanchika atipashkanchichu chay supayta llukshichinata chay wawamanta? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Chaypina Jesuska ñukanchita aynirka: Kankunaka manami tukuy shunkuykichimanta pacha kiriwankichichu. Chayraykumi mana atipashkankichichu chay supayta llukshichinata chay wawamanta. Alita uyawaychi. Uchillastullatapas Yaya Diosta kirinkichimaka, rimankichima kay urkuta anchuriy chaymanta nishpa, chay urkuka rimashkaykichita kasushpanmi anchurima. Yaya Diosta tukuy shunkuykichimanta pacha kirinkichimaka, payka yanapamami tukuy imata atipanaykichipa ruranata. ");
INSERT INTO qupNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Chasna supaytaka atipankichi runamanta llukshichinata mana mikushpa mañashpalla Yaya Diosta nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Chaymanta Jesuska ñukanchiwa pakta Galilea allpapi purihushpan ñukanchita rimarka: Ñuka silumanta shamushka runa kashpaynipas chikniwak runakunami apichiwashpankuna parisichishpa wañuchiwankakuna. Chasna wañuchiwashpankunapas kimsa punchamantami Yaya Dios kawsachiwanka. Chayta uyashpanchi yapa llakirirkanchi. ");
INSERT INTO qupNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Chaymanta Jesús ñukanchiwa pakta rishpan Kapernaum llaktapi paktarkanchi. Chaypi shuk runakuna Yaya Diospa wasinrayku kullkita kobrakkuna kashpankuna Pedrota kayllayashpa tapurkakuna: ¿Kankunata yachachik Jesuska manachu pagan Yaya Diospa wasinrayku? ");
INSERT INTO qupNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Chasna tapushpankuna Pedroka aynirka: Ari, paypas paganmi nishpa. Chaymanta Pedro chay wasipi yaykushpan manara nima imata rimashpanra Jesuska payta tapurka: ¿Imatata yuyarinki Simón? Rimaway ¿pitata kullkita pagachinahun atun apukunaka, kikin llaktankunamanta runa masinkunatachu, shuk allpamanta runakunatachu? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Chaypi Pedroka aynirka: Shuk allpamanta runakunatami pagachinahun nishpa. Chaypi Jesuska rimarka: Chayrayku chay apukunapa kikin llaktankunamanta runa masinkunaka mana nima shuk imata paganankuna tiyanchu. ");
INSERT INTO qupNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ñuka Yaya Diospa Wawan kashpayni Yayayni Diospa wasinrayku mana paganayni tiyanchu. Mana paganayni kashpanpas nima pita piñachinanchipa, akuychi pagashunchi. Antsilukriy kuchama. Chay puntiru challwata apishpay kimi shiminpi kullkita tarinki. Chayta pagakriy ñukarayku kanraykupas. ");
INSERT INTO qupNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Chay uras Jesús Pedrowa kwintahushpan ñukanchi payta kayllayashpanchi tapurkanchi: Yachachik, Yaya Dios tukuy runakunata kamachishpan ¿pitaya ñukanchimanta ashwan yachayyu kanka? ");
INSERT INTO qupNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Chasna tapushpanchi Jesuska shuk wawata kayashpan chawpinchipi shayachirka. Payta rikuchishpan ñukanchita yachachirka: ");
INSERT INTO qupNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Alita uyawaychi. Kankuna shuk wawashina mana yachayyuchu kani nishpa yuyarishpa kawsaychi. Mana sakishpaykichika yuyarinata runa masinikunamanta ashwan yachayyu kani nishpa, manami Yaya Diospa kamachishkan tukushpa paypa ali kamachihushkanpi kawsankichichu. ");
INSERT INTO qupNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kay wawashina mana yachayyuchu kani nishpa yuyarishpaykichika Yaya Diospa kamachihushkanpi tukuymanta ashwan yachayyu kankichi. ");
INSERT INTO qupNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Chaymanta maykanmi ñukata yuyawashpan shuk wawata yuyashpa wasinpi yaykuchin, chayka ñukatami yaykuchiwan nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Chaymanta Jesuska rimarka: Maykanmi shuk wawa chayra katiwahukta uchata rurachin, paytaka Yaya Diosmi chaymanta ashwan sinchita kastiganka. Ashwan ali kama, kunkanpi atun rumiwa watashpa wichuy tukushpan chawpi yakupi chinkarinanpa. ");
INSERT INTO qupNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ay kay allpapi Yaya Diosta mana kasukkuna, yapa tukuyta uchata rurachinayashkankunarayku. Tukuy uras chasna uchata rurachinayakkuna tiyashpanpas ay, maykankunami uchata rurachikkuna kanahun. ¡Imashna kastigushi paykunarayku kanka! ");
INSERT INTO qupNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Chayrayku imapas kanta uchata rurachinayashpanka sakiy. Makiki chakiki kanta uchata rurachinayashpanka pitishpa wichushkashina sakiy. Mana ishkanti makikiwa, ishkanti chakikiwa nina mana wañukma rinaykipa, ashwan alimi kama, shuk makillawashina shuk chakillawashina Yaya Diospa kawsananpi yaykunaykipa. ");
INSERT INTO qupNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Chaymanta ñawikiwa imatapas rikushpayki uchata ruranayashpaykika ñawikita surkushkashina sakiy. Mana ishkanti ñawikiwa nina mana wañukma rinaykipa, ashwan ali kama, shuk ñawillawashina silupi Yaya Dioswa kawsak rinaykipa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Chaymanta Jesuska yachachihushpan nirka: Rikuychi, nima shuk wawastuta, nima shuk chayra katiwak runata chikniychichu. Kay rimahushkaynita alita uyaychi: Paykunapa angelkunaka silupimi tukuy uras Yaya Diospa puntanpi kanahun. ");
INSERT INTO qupNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ñuka Yaya Diospa Wawanka shamushkanimi tukuy runakunata sinchi kastigananmanta kishpichinaynipa. ");
INSERT INTO qupNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Imashnata yuyarinkichi? Shuk runapa shuk pachak obehankuna tiyama. Chay shuk pachak obehankunamanta shuklla chinkarishpan ¿imatata rurama? ¿Manachu chay iskun chunka iskunta sakishpan chay shuklla chinkarishkata maskak rinma? ");
INSERT INTO qupNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Alita uyawaychi. Chay shuk chinkarishka obehanta tarishpanka chay achka mana chinkarishka obehankunamanta ashwantami kushikuma. ");
INSERT INTO qupNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Chasnallatatami silupi kawsak Yayanchika tukuy wawankunata alita yuyan. Chayraykumi payka mana munanchu nima shuk chayra katiwak runa paymanta chinkarishpa nina mana wañukma rinanpa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Chaymanta Jesuska yachachirka imashnami shuk kirik masinchita llakichinanchi tiyan nishpa. Kasnami nirka: Shuk kirik masikichi kanta mana alita rurashpanka sapallayki rishpayki payta kunay. Kanta ari nishpanka alita alichashpa llakichinakuychi, chasnami kutikashka alitana paywa kawsankichi. ");
INSERT INTO qupNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mana rimashkaykita uyashpanka ishkay kimsa kirik wawkikunawa pakta alichak riychi. Chasna ishkay kimsa kirikkunapa rikushkanpi chay mana alita rurak runata kunashpaykichi tukuy yachankakuna shutipa rimashkaykichita. ");
INSERT INTO qupNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Chay runaka kunashkaykichita mana uyashpanka Yaya Diosta kasuk masikichikunata tantachishpa rimaychi paykunapas yachanankunapa. Paykunatapas mana uyanayashpanka Yaya Diosta mana kirik runatashinana rikuychi. ");
INSERT INTO qupNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Alita uyawaychi. Kankuna shuk runata rimashpaykichi uchaykika mana llakichirishkachu kan nishpa, Yaya Diospas ari, chasna kachun ninkami. Shuk runata rimashpaykichi uchaykika llakichirishka kan nishpa, Yaya Diospas ari, chasna kachun ninkami. ");
INSERT INTO qupNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Alita uyawaychi. Kankuna ishkaymanta shuk yuyayllawa mañawashpaykichika Yaya Dios shuk imapi yanapananpa, payka kankunata yanapankami. ");
INSERT INTO qupNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ñukata kiriwashpaykichi ishkaymanta kimsamanta tantarishpaykichi chaypi kankunawa pakta kahuni. ");
INSERT INTO qupNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Chaypi Pedroka kayllayashpan Jesusta tapurka: Yachachik, shuk runa masini achka kuti mana alita rurawashpanka ¿masna kutitaya payta llakichinayni tiyan? ¿Kanchis kutichu llakichisha? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Chaypina Jesuska aynirka: Mana rimashkaykichu kanchis kutilla llakichinaykipa. Rimashkayki kanchis chunka kuti kanchiskama llakichinayki tiyan. Mana yupashpa achka kuti llakichiylla. ");
INSERT INTO qupNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Chaymanta ashwanta asirtachishpa rimarka: Yuyariychi imashnami Yaya Diospa ali kamachinanka kay allpapi. Rikuychi shuk yachayyu patrón runankunata kushkanwa rurashkankunamanta tapunayashkata. ");
INSERT INTO qupNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ña tapunata kallarishpan shuk payta liwik runata pushamurkakuna. Payka chay patronta yapa achka, mana nima ima uras pagaypata waranka kullkita liwirka. ");
INSERT INTO qupNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Chay liwik runa nima kullkiyuchu karka liwishkanta pagananpa. Chayrayku chay patronka runankunata rimarka: Mana paganata atipashpan kay runataka warminti, tukuy wawankunatapas, tukuy paypa tiyapushkantapas rantichik riychi. Chay rantichishkaykichi kullkita ñukata kuwaychi paypa liwinmanta nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Chasna rimashpan chay liwik runaka chay patronpa puntanpi kunkurirka. Yapa llakirishpan rimarka: Patroyni, ama piñariwaychu. Chapaway. Mana unayashpachu tukuy liwishkaynita pagashkayki. ");
INSERT INTO qupNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Chasna yapa atunta tapushkanrayku chay patronka chay runanta llakichishpan rimarka: Kutiy ña wasikima. Tukuy liwiwashkaykimanta kanta llakichini. Kunanka manana liwiwankinachu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Chay llakichirishka runa llukshishpan shuk runa masinwa tinkunakurka. Chay tinkunakushkan runaka payta shuk uchillastu kullkita liwirka. Chaypina chay llakichirishka runana yapa piñarishpan chay uchillastu payta liwik runataka kunkanmanta apishpan sipinayarka. Payta rimarka: Kunalla pagaway tukuy liwiwahushkaykita nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Chasna rimashpan chay liwik runaka paypa puntanpi kunkurishpan rimarka: Ama piñariwaychu. Chapaway. Tukuy liwishkaynitami pagashkayki nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Yapa sinchita tapuhushpanpas chay sipinayak runaka mana munarkachu uyanata. Chay liwihuk runa masintaka karselma churachirka tukuy liwishkanta paganan punchakama. ");
INSERT INTO qupNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Chay runata karselpi churachishkanta runa masinkuna rikushpankuna yapa llakirishpankuna chay patrontana rimak rirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Chaypina payka chay llakichishkan runanta kayachishpan rimarka: Kanka yapa millaypa runami kanki. Sinchita tapuwashkaykiraykumi chay achka mana pagaypa waranka kullkita liwiwashkaykimanta llakichirkani. ");
INSERT INTO qupNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kanta llakichishkaynishina kanpas llakichinkima karka runa masikita nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Chaypina chay patronka yapa piñarishpan kamachirka chay runatapas karselpi churanankunapa tukuy liwihushkanta paganan punchakama. ");
INSERT INTO qupNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Chaymanta ñukanchita rimashpa katirka: Chay patrón millaypa rurak runanta kastigashkanshinami Yaya Dios kankunatapas kastiganka, mana runa masikichikunata tukuy shunkuykichimanta pacha llakichishpaykichika. ");
INSERT INTO qupNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Tukuy chaykunata yachachishkanwasha Jesuska Galilea allpamanta llukshishpan Judea allpama rirka, chay Jordán yaku chimpama. ");
INSERT INTO qupNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Chaypi achka runakuna payta katirkakuna. Jesuska chay uras achka unkushkakunata ampirka. ");
INSERT INTO qupNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Chaymanta fariseokuna Jesusta kayllayashpankuna pantachichinayashpa tapurkakuna: ¿Alichu kama kusan warminta sakinanpa shuk imastumantalla, maykantami mana alita ruramachu? ");
INSERT INTO qupNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Chasna tapushpankuna Jesuska aynirka: ¿Manachu Yaya Diospa killkachishkanpi leyishkankichi runata rurashpan Yaya Dios karita warmita rurashkanta? ");
INSERT INTO qupNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Yaya Dios chasna karita warmita rurashpan rimarka: Tukuy karikuna yayanta mamanta sakinankuna tiyan warminwana tantaylla kawsanankunapa. Paykunaka tantarishpankuna shuk runashinallami kanahun nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Chasna Yaya Dios paykunata tantachishpan shuk runashinalla kanahun, manana ishkay runashinachu kanahun. Chayrayku mana alichu nima shuk runa warminta sakinanpa. ");
INSERT INTO qupNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Chasna Jesús yachachihushpanmi chay fariseokunaka tapurkakuna: Chasna kashpanka ¿imaraykutaya Moiseska kamachirka shuk kari warminta sakinayashpan apunkunapa puntanpi warminta shuk sakina killkata kushpan atipama sakinata nishpa? ");
INSERT INTO qupNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Chaypina Jesuska rimarka: Kankuna mana Yaya Diosta kasunayashpaykichi Moiseska rimarka shuk sakina killkata kushpa atipankichi sakinata warmikichita nishpa. Ñawpamanta pachami Yaya Dioska mana munarkachu sakinakunaykichita. ");
INSERT INTO qupNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ñuka kankunata rimani warmikichita ama sakiychichu. Atipankichi warmikichita sakinata, shuk kariwa musayashkanraykulla. Mana chasna rurashpan warmikita sakishpaykichika uchatami rurankichi. Chaymanta shuk warmita apishpaykichika uchatami rurankichi. Chay sakishka warmita pushak karipas uchatami ruran. ");
INSERT INTO qupNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Chaypina ñukanchika payta rimarkanchi: Yaya Dios mana munashpanka warminchita sakinanchipa, ashwan alichari kama shuk runa mana warmiyananpa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Chasna rimashpanchi Jesuska ñukanchita aynirka: Mana tukuy runachu asirtankakuna kay rimahushkaynita. Ashwan maykankunallatami Yaya Dioska asirtachin, chaykunami yachankakuna imamantami rimahuni. ");
INSERT INTO qupNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tiyan achka runakuna chasna mana warmiyu kawsanankunapa. Shuk karikunaka wawayarinahunmi mana shuk warmiwa tupanata atipakkuna. Chayrayku mana warmiyanahunchu. Shuk karikunaka chasna tukunahun, paykunata kapashkankunarayku. Chasna tukushpankuna mana warmiyanahunchu. Shukkunaka mana warmiyanahunchu Yaya Diospa kamachishkankunalla kanankunapa. Maykankunami kay rimashkaynita asirtanahun, asirtashkankunashina kawsanahuchun nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Chaymanta shuk runakuna wawankunata Jesusma pushamurkakuna, Jesús llankashpan paykunarayku Yaya Diosta mañananpa. Chayta rikushpanchi ñukanchika piñarishpa paykunata arkahurkanchi Jesusta mana kayllayanankunapa kasna nishpa: Ama chay wawastukunataka Jesusma pushamuychichu. ");
INSERT INTO qupNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Chasna piñarihushpanchi Jesuska ñukanchita rimarka: Ama arkaychichu chay wawakunata ñukama pushamunankunapa. Maykankunami kay wawakunashina ñukata kiriwanahun, chaykunallami Yaya Diospa kamachishkan tukushpa paypa ali kamachihushkanpi kawsankakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Chasna rimashpan Jesuska tukuy chay wawakunata kuyashpan Yayan Diosta mañarka paykunarayku. Chaymanta llukshishpan rirka. ");
INSERT INTO qupNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Chaymanta shuk runa Jesusta kayllayashpan tapurka: Yachachik, ¿ima ali ruranatata ruranayni tiyan Yaya Dioswa wiñaypa kawsanaynipa? ");
INSERT INTO qupNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Chasna tapushpan Jesuska rimarka: ¿Imaraykuta tapuwahunki maykanmi ali kan ruranapa? Yaya Diosllami ali kan. Paywa kawsak rinayashpaykika Yaya Diospa kamachishkankunata alita kasushpa kawsay. ");
INSERT INTO qupNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Chay runaka tapurka: ¿Maykan kamachishkakunatata paktachinayni tiyan? nishpa. Chasna tapushpan Jesuska rimarka: Ama runa masikita wañuchiychu. Ama shuk warmiwa musayaychu. Ama shuwaychu. Ama nima maykan runamanta nima imata llullashpa rimaychu. ");
INSERT INTO qupNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Yayaykita mamaykita yuyashpa kushichishpa kawsay. Chaymanta kan kikinta yuyahukshina tukuy runa masikikunata yuyay. Tukuy chayta kasushpa kawsanayki tiyan nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Chay runaka rimarka: Tukuy chay Yaya Diospa kamachishkantaka kasushpami kawsashkani. ¿Imatata ashwan pishiwan ruranaynipa? ");
INSERT INTO qupNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Chaypina Jesuska aynirka: Yaya Diospa munashkanta alita ruranayashpaykika rantichikriy tukuy imaykikunata. Chay kullkitaka nima imayu runakunata kuy. Chasna rurashpaykimi silupi achka imayushina tukunki. Chasna rurashkaykiwasha shuti katiway. ");
INSERT INTO qupNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Chayta uyashpan chay runaka yapa llakirishpa wasinma kutirka. Yapa achka imayu kashpan mana munarkachu tukuy imankunata rantichishpa kunata. Chayrayku yapa llakirirka. ");
INSERT INTO qupNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Chay runa llakirishka rishpanna Jesuska ñukanchita rimarka: Alita uyawaychi. Kullkinllapi yuyarihuk runakunaka manami Yaya Diospa kamachishkan tukushpa paypa ali kamachihushkanpi kawsankakunachu. ");
INSERT INTO qupNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kutikashka rimani kankunata, shuk atun wiwa kamilluka manami atipamachu pasanata shuk aguha uchkunstuta. Chasnallatatami shuk kullkiyu runaka kullkinllata munashpanka mana atipanchu Yaya Diospa kamachishkan tukushpa paypa ali kamachihushkanpi kawsanata nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Chayta uyashpanchi mancharishpa tapunakurkanchi: Chasna kashpanka ¿pishi atipanka Yaya Diospa kamachinanpi yaykunata? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Chaypina Jesuska ñukanchikunata rikushpan rimarka: Manami nima shuk runa atipamachu pay kikinlla Yaya Diospa kamachinanpi yaykunata. Yaya Diosllami atipan runakunata kishpichishpa yaykuchinata. ");
INSERT INTO qupNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Chaypina Pedroka rimarka: Ñukanchika sakishkanchimi tukuy ñukanchipa tiyashkakunata kanta katinanchiranti. ¿Imatata Yaya Dios ñukanchita kunka? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesuska ñukanchita aynirka: Alita uyawaychi. Yaya Dios kay allpapi tukuyta mushuta rurashpanmi ñuka paypa Kachashkan Runami kutikashka shamusha suma yachayniwa tukuy runakunata kamachinaynipa. Chasna suma kamachik tukushpaynimi ñukata katiwahushkaykichirayku kankunatapas churasha ñukawa pakta kamachikkuna kanaykichipa. Chaypina chay chunka ishkay yaya rukunchikuna wañuta tukuy paykunamanta mirashka israel masinchikunawa pakta kawsashkankunamanta tapushpaykichi rimankichi pimi kishpinka pimi kastigarinka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Chaymanta Jesuska rimarka: Shuk runa ñukata katiwahushkanrayku wasinta, wawkinkunata, paninkunata, yayanta, mamanta, wawankunata, chakrankunata sakishpanka paytaka Yaya Dioska tukuy ima sakishkanmanta ashwantami kunka. Chay yuyawak runaka wañushkanwasha wiñaypatami Yaya Dioswa silupi kawsanka. ");
INSERT INTO qupNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Achka runakuna maykankunami kay allpapi kawsahushkanchipi runa masinkunapa rikushkanpi tukuymanta ashwan valichirishka kanahun, paykunami Yaya Diospa rikushkanpi tukuymanta ashwan mana valikchu kankakuna. Achka runakuna maykankunami kay allpapi kawsahushkanchipi runa masinkunapa rikushkanpi tukuymanta ashwan mana valikchu kanahun, paykunami Yaya Diospa rikushkanpi tukuymanta ashwan valichirishka kankakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Chaymanta Jesuska rimashkanta ashwan alita asirtachinanpa chay runakunata yachachirka: Akuychi yuyarishunchi imashnami Yaya Diospa ali kamachinanka kay allpapi. Rikuychi, shuk patronpa tiyapurka shuk atun uva chakran. Shuk puncha tutamanta payka llukshirka runakunata maskananpa, uva chakranpi tarawachinanpa. ");
INSERT INTO qupNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Runakunata tarishpan rimarka: Tukuy puncha chishiyakta chakraynipi tarawashpaykichika kankunata pagasha shuk puncha valishkata nishpa. Paykunaka ari nishpankuna tarawak rirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tutamantara kahushpan intika, chay patronka kutikashka maskak rirka ashwan runakunata. Plasapi achka mana tarawanayu runakunata rikurka. ");
INSERT INTO qupNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Paykunata rimarka: Kankunapas uva chakraynipi tarawak riychi. Tarawashkaykichimanta kankunata pagasha nishpa. Chasna rimashpan paykunapas tarawak rirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Chay chakrayu runaka chawpi puncha, chaymanta chishipi kutikashka maskak rirka runakunata tarawachinanpa. Kuti runakunata tarishpan kacharka chakranpi tarawanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ña chishiyahushpan kutikashka plasama rirka maskananpa runakunata tarawachinanpa. Plasapi kutikashka mana tarawanayu runakunata rikurka. Paykunata tapurka: ¿Imaraykuta tukuy puncha kaypi kankichi nima imata rurashpa? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Chasna tapushpan paykunaka aynirkakuna: Nima pi ñukanchita tarawananchipa maskashkachu nishpa. Chaypina chay patronka rimarka: Kankunapas uva chakraynipi tarawak riychi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Chaymanta tutayahushpanna chay patronka paypa runanta rimarka: Tukuy tarawashka runakunata kayashpayki pagay. Ashwan washa shamushkakunamanta kallarishpa tukuyta pagay nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Chaypina shuk uralla tarawak runakunata pagarka tukuy puncha tarawashkatashina. ");
INSERT INTO qupNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Chayta rikushpankuna tutamanta pacha tarawashkakunaka yuyarirkakuna, ñukanchita ashwanta paganka tukuy puncha tarawashkanchirayku nishpa. Chasna yuyarishpankunapas shuk puncha tarawashkankunamantalla pagay tukurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Chayrayku piñarishpankuna patronmanta yuyarirkakuna mana ali pagak patrón kananta. ");
INSERT INTO qupNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Chaypi payta rimarkakuna: ¿Imaraykuta ñukanchita kay washa tarawak shamushka runakunawa parihullata paganki? Paykuna shuk urallata tarawashkakuna. Ñukanchika tukuy puncha inti rupata awantashpa tarawashkanchirayku ashwanta paganayki tiyan. ");
INSERT INTO qupNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Chasna piñarishpa rimashpankuna chay patronka shukta rimarka: Amigu, ñukaka manami kanta llullachihunichu. ¿Manachu kwintashkanchi tukuy puncha tarawashkaykirayku shuk puncha valishkata paganaynipa? ¿Imashnataya kunan ashwanta munanki paganaynipa? ");
INSERT INTO qupNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Chay kushkayni kullkita apashpa riy. Ñuka paganayani washa shamushkakunatapas kankunawa parihullata. ");
INSERT INTO qupNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ñukapa kullkini kashpan munashkaynita rurani. Kanka matsankarashpaykika shukkunaka kanshinallatata kullkita apashkankunarayku, mana alitachu yuyarinki. ¿Piñarihunkichu ñuka ali shunku kashpayni mana mitsashpachu shukkunatapas kantashina kushkaynirayku? ");
INSERT INTO qupNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Chasnallatatami maykankunami kay allpapi kawsahushkanchipi runa masinkunapa rikushkanpi tukuymanta ashwan mana valikchu kanahun, paykunami Yaya Diospa rikushkanpi tukuymanta ashwan valichirishka kankakuna. Maykankunami kay allpapi kawsahushkanchipi runa masinkunapa rikushkanpi tukuymanta ashwan valichirishka kanahun, paykunami Yaya Diospa rikushkanpi tukuymanta ashwan mana valikchu kankakuna nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Chaypina Jesuska achka runakunawa pakta Jerusalén llaktama rihushpan ñukanchi chunka ishkay runankunata chaynikstuma pushashpan rimarka: ");
INSERT INTO qupNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Ñami yachankichi Jerusalén llaktama rihushkanchita. Chaypi chiknik runakunaka ñuka Yaya Diospa Kachashkan Runata apiwankakuna, saserdotekunapa apunkunata, Moisespa killkashkanta yachachikkunatapas kuwankakuna. Chaypina paykunaka tantarishpankuna shuk yuyayllawa wañuchiwanayankakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Chasna wañuchiwanayashpankuna romano runakunata kuwankakuna. Paykuna yapa asichiwankakuna, waktawankakuna, chaywasha kruspi klabawashpankuna wañuchiwankakuna. Chasna wañuchiwashpankunapas kimsa punchamantami kawsarimusha. ");
INSERT INTO qupNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Chaymanta Sebedeopa warmin ishkay Jesusta katik wawankunawa Jesusta kayllayarkakuna. Sebedeopa wawankuna Santiago, Juan karkakuna. Chay warmika Jesusta tapunayashpan puntanpi kunkurirka. Chaypina Jesuska payta tapurka: ");
INSERT INTO qupNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","¿Imatata munanki ruranaynipa? nishpa. Payka aynirka: Kan tukuy runakunata kamachihushpayki kay ishkay wawaynikunata karan shukta kuchuykipi tiyachipay tukuymanta ashwan alita kanwa pakta kamachinankunapa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesuska aynirka: Kankunaka mana alita yachashpaykichi chayta tapuwahunkichi. Ñukaka achkatami parisinayni tiyan wañunaynikama. ¿Atipankichimachu ñukashina awantanata chay tukuy parisinakunata wañunaykichikama? Chasna rimashpan paykunaka aynirkakuna: Ari, atipashunmi awantanata. ");
INSERT INTO qupNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Chaypina Jesuska rimarka: Ari, kankunapas ñukashina achkata parisinaykichi tiyan. Chasna parisishpaykichipas ñukaka manami akllashanchu nima pita maykanmi kuchuynipi tiyarishpa kamachinka. Yayayni Diosllami akllanka, maykankunami kuchuynipi tiyarishpa kamachinkakuna nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Chasna chay warmi ishkay wawankunarayku tapushpan ñukanchi chunka runankunana uyashpanchi piñarirkanchi, chay ishkay wawkikuna ñukanchimanta ashwan atun tukunayashkankunarayku. ");
INSERT INTO qupNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Chasna piñarihushkanchita rikushpan Jesuska ñukanchita kayashpan rimarka: Kankunaka alita yachankichi, kay allpapi atun allpakunapi kamachik atun apukuna kamachinanpi kawsak runakunata yapa manchachishpankuna sinchita kamachishkankunata. Kamachinanpi kawsak runakunata mana yuyashpa parisichishpa kasuchinahun. ");
INSERT INTO qupNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kankuna Yaya Diospa shiminta kasukkunaka, ama chasna kanayaychichu. Shukkunamanta pasa kanayashpaykichika tukuy runa masikichikunata yanapashpa kawsaychi. ");
INSERT INTO qupNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kankuna tukuymanta ashwan yachak kanayashpaykichika tukuy runa masikichikunata kasushpa kawsaychi. ");
INSERT INTO qupNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ñuka Yaya Diospa Kachashkan Runapas manami shamushkanichu kay allpama runakuna sirviwanankunapa. Ashwan shamushkanimi tukuy runakunata yanapanaynipa. Shamushkanimi achka runakunaranti wañushpayni kastigarina kashkankunamanta kishpichinaynipa. ");
INSERT INTO qupNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesuska ñukanchiwa pakta Jerikó llaktamanta llukshishpan achka runakuna katirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Chaypina ishkay wisku runakuna ñampi mayanpi tiyahurkakuna. Paykunaka Jesús pasahushkanta uyashpankuna sinchita kaparishpa rimarkakuna: ¡Yaya Jesús, Davidpa Miraymanta Kishpichik, ñukanchita llakichiy! ");
INSERT INTO qupNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Chasna sinchita kaparishpankuna Jesuswa purik runakunaka killarishpankuna rimarkakuna: Chunllayaychi nishpa. Chay wiskukunaka mana kasushpachu ashwan sinchita kaparirkakuna: ¡Yaya Jesús, Davidpa Miraymanta Kishpichik, ñukanchita llakichiy! ");
INSERT INTO qupNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Chaypina Jesuska rihushkanmanta shayarishpan chay ishkay wisku runakunata kayashpan tapurka: ¿Imatata munankichi kankunarayku ruranaynipa? ");
INSERT INTO qupNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Chaypina paykunaka aynirkakuna: Yaya Jesús, ñawinchita ampiy rikunanchipa. ");
INSERT INTO qupNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Chasna rimashpankuna Jesuska paykunata llakichishpan ishkantipa ñawinkunata llankarka. Chayllawa kunkaymanta rikurkakunana. Paykunaka ampirishpankuna Jesustana katirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Jesuska ñukanchiwa pakta Jerusalén llaktama rihushpan Betfagé llakta mayanpi paktarkanchi. Chay uchilla llaktaka karka Jerusalén kuchupi, Olivos shutiyu urku pampapi. Chay mayanpi paktashpanchi Jesuska ñukanchikunamanta ishkayta kacharka kasna nishpa: Riychi chay rikuhushkanchi llaktama. Chaypi paktashpaykichimi tarinkichi shuk burru warmi watarishkata malta wawanwa pakta. Chay mamanta paskashpaykichi wawanwa pakta apamuychi. ");
INSERT INTO qupNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Shuk runa kankunata mitsashpan tapushpanka ¿imaraykutaya kay burruta apahunkichi? nishpa, payta rimaychi Yayanchi Jesusmi munahun awanpi tiyarishpa rinanpa. Kunanllatatami kutichik shamushu nishpa rimankichi. ");
INSERT INTO qupNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Chayka pasashka ñawpa Yaya Diospa yachayninwa yachachikpa kasna nishkanka paktarinanpa: ");
INSERT INTO qupNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Jerusalén llaktapi kawsak runakunata rimaychi: Rikuychi, atun apuykichimi ña shamuhun kankunata kishpichinanpa. Yapa yachak apu kashpanpas mana yachak runashina llashata apak burrupa wawan maltapa awanpi tiyarishpa shamuhun nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Chaypina chay ishkay runankunaka Jesús kamachishkanshina chay burruta apak rirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Chay burruta wawanti Jesusma apamushpankuna ñukanchika burrupa awanpi churarinanchita mantarkanchi. Chay awapi Jesuska tiyarishpan rirka Jerusalenpi yaykunanpa. ");
INSERT INTO qupNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Chasna Jesús rihushpan achka runakuna payta kushichishpa katirkakuna. Shukkunaka paypa puntanpi rishpankuna kamisankuna awapi churarishkankunata Jesuspa puntanpi rihushkan ñampipi mantarkakuna. Shukkunaka chipati pankakunata pitishpa mantarkakuna ñampita sumayachishpa Jesusta shuk atun aputashina kushichinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Chaypina Jesuspa puntanpi rihuk runakuna, washanmanta katik runakunapas yapa kushikushpa kaparirkakuna: ¡Akuychi kushichishunchi kay ñawpa atun apu Davidpa Miraymanta Kishpichikta! Yaya Diospa alita rikushkan yanapashkan runami kan. Yaya Diospa munashkanta rurananpa kachashkan kashpanmi shamuhun. ¡Akuychi kushichishunchi awa silupi kawsak Yaya Diosta! nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesús Jerusalén llaktapi yaykuhushpan chaypi kawsak runakuna yapa mancharishpankuna tapurkakuna: ¿Pitaya kay runaka? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Jesuswa purihuk runakuna rimarkakuna: Kay runaka Yaya Diospa yachayninwa alita yachachik Jesusmi. Payka Galilea allpapi kahuk Nasaret llaktamanta runami nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Chaypi Jesuska Yaya Diospa wasinpi yaykurka. Chay wasipi puntiru atun pampa kincharishkapi achka rantichihuk runakuna, rantihuk runakunapas karkakuna. Chaymanta tiyarka kullkita kampyakkuna. Tukuy chaykunata rikushpan Jesuska kullkita kampyakkunapa mesankunata, wiwa mukukukunata rantichikkunapa mesankunatapas pultyachi pultyachi rurashpan amunkunata kamachirka llukshinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Chasna rurashpan Jesuska rimarka: Yaya Diospa killkachishkanpi riman: Kay wasinika ñukata mañanankuna wasinimi kan nishpa. Kankunaka kay Yaya Diospa wasinta shuwakunapa kushilla tantarinata rurashkankichi. Chasna Jesuska rimashpan paykuna chaypi achkata kobrashpa kullkita kampyahushkankunarayku rantichihushkankunarayku shuwakunashina kanankunata yuyachirka. ");
INSERT INTO qupNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Chaymanta Jesús chay wasillapi kahushpanra wisku runakuna, waklishka chakiyu runakuna payta kayllayarkakuna. Chaypina Jesuska paykunata llakichishpan ampirka. ");
INSERT INTO qupNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Chay saserdotekunapa apunkuna, Moisespa killkashkan kamachishkata yachachikkunapas chay mana atipaypakunata rurashkanta rikushpankuna piñarirkakuna. Chaymanta ashwan piñarirkakuna, wawakuna Yaya Diospa wasinpi kaparihushkankunarayku akuychi kushichishunchi kay ñawpa atun apu Davidpa Miraymanta Kishpichikta nishpa. Chayta uyashpankuna saserdotekuna piñarishpa Jesusta rimarkakuna: ");
INSERT INTO qupNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","¿Manachu uyanki chay wawakuna rimahushkankunata? ¿Imaraykuta munanki chasna kanta kushichishpa rimanankunata? nishpa. Chaypina Jesuska rimarka: Ari, paykunata uyahunimi. ¿Manachu leyishkankichi Yaya Diospa killkachishkanpi kasna nikta? Kanmi Yaya Dios, uchilla wawakunata, chuchuk llullukunatapas yuyachinki kanta kushichishpa takinankunapa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Chayta rimashpan Jesuska chay runakunata sakirkana. Jerusalenmanta llukshishpan Betania llaktama rirka chaypi puñunanpa. ");
INSERT INTO qupNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kayantima tutamantalla Betania llaktamanta Jerusalenma kutihushpan Jesusta yarkayka apirka. ");
INSERT INTO qupNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ñampi mayanpi shuk igu kaspita rikurka. Chayta kayllayarka muyunta mikunayashpan. Chay uras chay kaspika mana muyuyuchu karka, pankankunallata tarirka. Chaypina Jesuska chay igu kaspita rimarka: Kunanmanta pacha manana muyuyankinachu. Chasna rimashpanlla chay igu kaspika kunkaymanta chakirirka. ");
INSERT INTO qupNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Chayta rikushpanchi mancharishpa Jesusta tapurkanchi: ¿Imashnataya rimashkaykillawa kay igu kaspika kunkaymanta chakirishka? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesuska ñukanchita aynirka: Alita uyawaychi. Kankunapas alita kirishpaykichika atipankichimi ñukashina ruranata. Yaya Diosta tapushpaykichika ama yuyarinkichichu uyawankachu manachu nishpa. Ashwan tukuy shunkuykichimanta pacha kirishpaykichi yuyariychi paymi shutipa uyawanka nishpa. Chasna kirishpaykichimi mana shuk igu kaspillatachu atipankichi chakichinata. Ashwan kay urkutapas rimankichimaka kaymanta warankarishpayki atun yakuma chinkariy nishpa, kay urkuka warankarimami. ");
INSERT INTO qupNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tukuy shunkuykichimanta pacha Yaya Diosta kirishpa mañashpaykichimi payka tukuy mañashkaykichita kankunata kunka. ");
INSERT INTO qupNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Chasna yachachishkanwasha Jesuska Jerusalén llaktapi Yaya Diospa wasinpi yaykurka. Chaypi yachachihushkanpi saserdotekunapa apunkuna, ñukanchita kamachik israel masinchi rukukunapas Jesusta kayllayashpankuna tapurkakuna: ¿Pita kanta kamachishka chasna yachachinaykipa? ¿Pita kanta kamachishka tukuy rurahushkaykikunata ruranaykipa? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Chasna tapushpankuna Jesuska rimarka: Ñukapas kankunata tapuni ¿pita Juanta kacharka bawtisananpa? ¿Yaya Dioschu shuk runachu payta kachamurka? Ayniwashpaykichika ñukapas rimashkaykichi pimi kachawashka nishpa. Chasna Jesús paykunata tapushpan chay runakunaka shukwa shukwa tapunakurkakuna imatami ayninkakuna nishpa. Aynishpanchika Yaya Diosmi Juanta kacharka nishpa, Jesuska ñukanchita rimankami Yaya Dios payta kachashka kashpanka ¿imaraykutaya Juanta mana kasushkankichichu? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Chaymanta aynishpanchika pay kikinllami yuyarishpa Juanka yachachirka nishpa, tukuy runakuna yapa piñarinkakuna. Paykunaka kirinahun kay Juan wañuka Yaya Diospa yachayninwa yachachik kashkanta. ");
INSERT INTO qupNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Chasna tapunakushpankuna chay runakunaka Jesusta aynirkakuna: Mana yachanchichu pimi Juanta kachashka nishpa. Chaypina Jesuska aynirka: Chasna kashpanka ñukapas mana rimashkaykichichu pimi kamachiwashka tukuy kaykunata ruranaynipa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Chaymanta Jesús chay saserdotekunapa apunkunata, ñukanchita kamachik israel masinchi rukukunatapas rimarka: ¿Ima ninkichita kay kwintanaynimanta? Shuk runa ishkay musu wawayu karka. Shuk puncha shuk wawanta rimarka: Kunalla uva chakraynipi tarawakriy nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Chasna yayan kamachishpan chay musu wawanka aynirka: Mana rinayanichu nishpa. Ashwan shuk ratumanta kutikashka yuyarishpan tarawak rirka yayanta kushichinanpa. ");
INSERT INTO qupNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Chaymanta chay runaka shuk wawantana kamachirka uva chakranpi tarawak rinanpa. Payka chay ratulla ari nishpa rimarka kunalla risha. Chaymanta mana tarawak rirkachu. ");
INSERT INTO qupNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Kunan tapushkaykichi: Chay ishkay wawankunamanta ¿maykanta yayanpa munashkanta rurarka? nishpa. Chasna tapushpan aynirkakuna: Chay tarawak rishka musu wawanmi yayanpa munashkanta rurarka nishpa. Chaypina Jesuska paykunata rimarka: Alita ayniwashkankichi. Kankuna yuyarinkichi chay romano tukuymanta atun apurayku impuestuta kobrakkuna, puta warmikunapas uchasapakuna kanankunata. Alita uyawaychi. Paykunami kankunamanta ashwan utkalla Yaya Diospa kamachishkan tukushpa paypa ali kamachihushkanpi kawsankakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Chay Bawtisak Juanka shamushka kankunata yachachinanpa, tukuy uchaykichikunata sakishpa Yaya Diostana kasushpa kawsanaykichipa. Kankunaka payta mana kirirkankichichu. Chay impuestuta kobrakkunaka, puta warmikunapas uchankunamanta llakirishpami sakirkakuna. Paykunaka chaymanta Yaya Diospa shiminta alita uyashpa kasurkakuna. Kankuna chayta rikushpaykichipas manami Yaya Diospa shiminta kirishpa kasuwashkankichichu. ");
INSERT INTO qupNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Chaymanta Jesuska kutikashka shuk yachachinawa yachachirka: Kunan shukta yachachishkaykichi. Tiyarka shuk chakrayu runa. Chay runaka chakranpi uva wiñarishkakunata tarpuchishkanwasha kinchachirka. Chaymanta chakranpi shuk atun batanta rurarka, chaypi uva muyukunata sarushpa chawanankunapa. Chaymanta shuk yapa awa wasita rurachirka awamanta shuk runa tukuyta kuyrananpa chakranta, mana nima pi chay tarpunpa muyunkunata shuwananpa. Chaymanta chay amunka uva chakranta shuk tarawak runakunata kurka amunshina pichashpa kuyranankunapa. Chasna kushpan rimarka: Pallashpaykichi tukuy muyunkunamanta chawpita kuwankichi. Chasna rimashpan chay amunka rirka shuk karu llaktamana. ");
INSERT INTO qupNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Chaymanta pallana timpu paktarishpan chay amunka shuk runankunata kacharka chay chakranpi tarawakkunata rimak rinanpa: Patroyninchimi ñukanchita kachashka uva muyuta pallashkaykichimanta chawpita payrayku apananchipa. ");
INSERT INTO qupNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Chaypina chay chakrata kuyrak runakunaka patronpa kachashkan runankunata apishpankuna shukkunata makarkakuna, shukkunataka wañuchirkakuna, shukkunataka rumikunawa tuksi tuksi rurarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mana nima imata kachashpankuna chay chakra amuka kutikashka ashwan achka runankunata kacharka. Paykunatapas chay tarawakkunaka chasnallatata rurarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Chaymanta chakra amuka shuklla wawantana kacharka, yuyarishpan kay wawaynitaka manchashpankunami kasunkakuna nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Chaypina chay tarawakkunaka amunpa wawanta rikushpankuna kwintarkakuna paykunapura: Rikuychi, kay shamuhuk runami chakra amupa wawan. Yayan wañushpan kay chakraka payraykumi kiparinka. Akuychi kunalla wañuchishunchi tukuy kay uva chakraka ñukanchipana kananpa. ");
INSERT INTO qupNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Chasna kwintashpankuna chay amunpa wawanta apirkakuna. Chaymanta uva chakra washama pushashpankuna wañuchirkakuna payta. ");
INSERT INTO qupNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jesuska chasna yachachishkanwasha chay chiknik runakunata tapurka: Chay chakra amuka rishpan ¿imanachimashi chay wañuchik runakunata? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Paykunaka aynirkakuna: Chay amuka tukuy chay yapa millaypa tarawakkunata mana llakichishpachu wañuchima. Chaymanta chakranta shuk tarawakkunatana kuma, maykankunami pallana uras tukuy pallashkankuna uvata chawpinakushpa amunta chay chawpita kunahuma. ");
INSERT INTO qupNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","43","Chasna aynishpankuna Jesuska rimarka: Ñuka kankunata rimani mana munawashkaykichirayku Yaya Dioska manami munannachu paypa kamachishkankuna kanaykichipa. Shuk chikan runakunatanami kayanka paypa kamachishkankuna kanankunapa. Paykunami shuti Yaya Diosta kasushpa kawsankakuna. Kankunaka Yaya Diospa ñawpa killkachishkanta leyishpaykichipas manarachu asirtankichi. Kasna riman: Shuk runa wasinta rumimanta rurashpan tarawak runankunaka shuk ali sinchi rumita mana munashpankuna mayanpi churarkakuna mana alichu nishpankuna. Chay rumitaka wasinta rurak runaka akllashpan churarka chay wasinpi shuk orkonshina sinchikuchik kananpa. Chasnashinami Yaya Dioska akllashkan runawa ruranka. Ñukanchika chayta rikushpanchi yapa alimi kan nishpa rimanchi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Chay akllashkan rumipi takakta tukushpaykichika tulluykichi pakiktami urmankichi. Chay atun rumi awaykichipi urmashpanka machuyakta nitishpa pulbu wañunkichi nishpa. Chasna rimashpa Jesuska yuyachinayarka imashnami paypa yachachishkanta chaymantapas payta mana munakkunaka tukunkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Chaypina chay saserdotekunapa apunkuna, fariseokunapas Jesuspa yachachihushkanta uyashpankuna paykunapura kwintarkakuna: Payka ñukanchimanta yuyarishpan chasna uyachishpa yachachihun. Chay mana ali rurak tarawakkunashina kananchita, chaymanta chay rumipi takarik runashina kananchita nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Paykuna yapa piñarishpankuna Jesusta apinayarkakuna wañuchinankunapa. Chasna ruranayashpankunapas runakunapa piñarinankunata manchashpankuna mana payta apirkakunachu. Tukuy runakuna yuyarishkakuna Jesús Yaya Diospa yachayninwa yachachik kananta. ");
INSERT INTO qupNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Chaymanta Jesuska kutikashka chay runakunata shuk yachachinakunawa yachachirka: ");
INSERT INTO qupNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Yuyariychi imashnami Yaya Diospa ali kamachinanka kay allpapi. Rikuychi shuk atun apuka musu wawan warmiyahushkanrayku kushikuna mikunata rurashkanta. ");
INSERT INTO qupNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Payka runankunata kacharka tukuy kayashkan runakunata kayak rinankunapa. Kayashpankunapas mana shamunayarkakunachu. ");
INSERT INTO qupNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Mana shamunayashpankuna chay apuka shuk runankunatana kayashpan rimarka: Tukuy kayashkayni runakunata rimak riychi: Patroynika ñami wakrankunata, wirayachishkan wiwankunatapas wañuchishka. Mikunaka ñami yanushka kahun. Kunalla chay kasarahushkapi mikunata mikuk shamuychi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Chasna rimak rishpankuna chay kayashkankunaka manana shamunayarkakunachu. Shukka chakranma rirka. Shukka imankunata rantichinanpa rirka. ");
INSERT INTO qupNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Shukkunaka chay apupa runankunata apishpankuna makarkakuna wañuchinankunakama. ");
INSERT INTO qupNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Chayrayku chay apuka yapa piñarishpan suntalunkunata kacharka chay wañuchik runakunata wañuchinankunapa, llaktankunatapas rupachinankunapa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Chaymanta chay runankunata rimarka: Kasarashkapi mikunaka ñami chayashka. Chay kayashkayni runakunaka mana alita rurashkankunamanta mananami wasinipika yaykunkakunachu. ");
INSERT INTO qupNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Chayrayku anchu ñampikunama rishpaykichi rikushkaykichi runakunata kayaychi, kasarahushkapi mikunata mikuk shamunankunapa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Chasna rimashpan paypa runankunaka ñampikunapi purihuk runakunata kayak rirkakuna kasarahushkapi mikunankunapa. Ali rurak, mana ali rurak runakunatapas kayashpankuna chay apupa atun wasinpi achka runakuna tantarirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Chaypi chay apuka yaykushpan kayashkan runakunata kwintachirka. Chaypi shukta rikurka kasarana kushikunarayku churarinata mana churarishkata. ");
INSERT INTO qupNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Payta rikushpan rimarka: Amigu, ¿imaraykuta mana kasarana kushikunarayku churarinata churarishpa yaykushkankichu? nishpa. Chay runaka nima imata ayninata atipashpan pinkarishpan chunlla kiparirka. ");
INSERT INTO qupNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Chaypina chay apuka mesama mikunata apak runankunata rimarka: Kay runata chakinta makinta alita watashpa chay manchaypa amsama wichuychi. Chaypi sinchita parisishpa wakanka, piñaywa kirunkunata kanirinka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Chasnallatata Yaya Dios achka runakunata kayashka paypa runankuna kanankunapa. Achka runakuna kayay tukushka kashpankunapas shuk shukkunalla kayashkanta kasushpankuna shamunahun Yaya Diosma. ");
INSERT INTO qupNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jesús yachachishkanwasha fariseokunaka llukshishpankuna tantarishpa paykunapura kwintarkakuna: Akuychi, Jesusta pantachichishunchi shuk mana ayniypata tapunawa. Mana alita aynishpanka apunchikunata rimashunchi payta apishpankuna kastiganankunapa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Chayta ruranayashpankuna fariseokunaka paykunata katik runakunata, chaymanta Herodespa partidunta katikkunatapas kacharkakuna alishina tukushpa Jesusta pantachichinayashpa paywa kwintanankunapa kasna nishpa: Yachachik, yachanchi mana llullachishpachu shutipa kashkata rimanki. Tukuy runakunata alita yachachinki Yaya Diospa munashkanta rurashpa kawsanankunapa. Kanmi mana manchashpachu nima shuk runata, nima apukunata tukuyta kuskata yachachinki. ");
INSERT INTO qupNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kunanka rimay ñukanchita imashnata yuyarinki. ¿Alichu manachu ñukanchi israel runakuna chay romano tukuymanta atun aputa impuestuta pagananchipa? ¿Yaya Dios munanchu pagananchipa manachu? ");
INSERT INTO qupNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Chasna tapushpankuna Jesuska yacharka payta apichinayashpa rimashkankunata. Ari, pagananchi tiyan nishpa aynimaka ñukanchi israel runakunamanta apukunata rimak rinahuma payta kastiganankunapa. Mana alichu pagananchipa nishpa aynimaka romano apunchita rimak rinahuma. Chayrayku Jesuska rimarka: Kankunaka mana ali yuyayyu runakunachu kankichi. ¿Imaraykuta apichiwanayashpa tapuwankichi? ");
INSERT INTO qupNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Rikuchiwaychi chay paganaykichi kullkita. Chasna nishpan shuk kullkita payta rikuchirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesuska chay kullkita rikushpan paykunata tapurka: ¿Pipa almantata rikunkichi kay kullkipi? ¿Pipa shutinta kay kullkipi killkarishka kan? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Paykunaka aynirkakuna: Romano tukuymanta atun apupami. Chasna aynishpankuna Jesuska paykunata rimarka: Chay atun apupa kashkantaka kuychi amunta. Maykanmi Yaya Diospa kan, kuychi payta. Yaya Dios ñukanchikunata rurashkanrayku ñukanchikunapa amunchi kan. Chayrayku tukuy shunkuykichimanta pacha payta yuyashpa kawsaychi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Chasna yapa yachayninwa aynishkanta uyashpankuna chay pantachichinayak runakunaka yapa mancharishpankuna chunllalla anchurirkakuna Jesusmanta. ");
INSERT INTO qupNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Chaymanta chay punchallatata shuk saduseokunaka Jesuswa kwintak rirkakuna. Paykunaka yachachinahun wañushkanchimanta manana kawsarimushunchinachu nishpa. Chayrayku paykuna Jesusta tapurkakuna: ");
INSERT INTO qupNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Yachachik, ñawpa Moisés wañuka kasna yachachirka: Shuk warmiyu runa manara nima shuk wawayu kashpan wañushpanka wawkinka kachuynin mashintuta warmiyanan tiyan chay mashintuka atipananpa wawayanata. Chaypina kari wawata wawayashpanka chay wawkin wañupa wawanshina kanan tiyan nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kunan kanta kwintanayanchi: Kay llaktanchipi tiyarka kanchis wawkikuna. Shuk puncha puntiru wawkika warmiyarka. Chay wawkika nima shuk wawayu kashpanra wañurka. ");
INSERT INTO qupNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Pay wañushpan shuk wawkinna kachuyninta warmiyarka. Paypas wañurka nima shuk wawayu kashpanra. Chaypina shuk wawkinna chay kachuyninta warmiyarka. Paypas nima shuk wawayu kashpanra wañurka. Chaymanta shuk wawkinna chay kachuyninta warmiyarka. Paypas chasnallatata mana wawayuchu wañurka. Chasnallatata shukllankama shukllankama chay kanchis wawkikuna chay warmillatata warmiyashpankuna karan shuk mana wawayuchu wañurka. ");
INSERT INTO qupNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Chasna tukuy kusankuna wañushkankunawasha chay warmipas wañurkana. ");
INSERT INTO qupNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kunanka rimay ñukanchita. Chay kanchis wawkikuna chay warmillata warmiyarkakuna. Wañushka runakuna kawsarimushpankuna chay kanchis wawkikunamanta ¿maykanpa warminshi kama? ");
INSERT INTO qupNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Chasna tapushpankuna Jesuska paykunata aynirka: Kankuna kikintami llullachirinkichi, wañushkakuna kawsarinankunata mana kirishkaykichirayku. Yachashpaykichitata Yaya Diospa killkachishkanta mana asirtankichichu. Chaymanta Yaya Diostapas mana riksinkichichu, wañushkakunata kawsachinata atipakta. ");
INSERT INTO qupNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Yaya Dios wañushka runakunata kawsachimushkanwasha nima shuk kari warmiyankanachu, nima shuk warmi kusayankanachu. Silupi kawsak angelkunashinami tukuy kawsankakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","¿Manachu leyishkankichi Yaya Diospa killkachishkanta? Chaypi riman wañushkakuna kawsarinankunamanta kasna: ");
INSERT INTO qupNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ñuka kani Yaya Dios, maykantami Abraham, Isaak, Jakob kushichiwanahun nishpa. Chasna Yaya Dios rimashpan yachanchi chay yaya rukunchikuna wañushpankunapas paywa pakta kawsa kahushkankunata. Kawsakunallami Yaya Diosta kushichinahun, wañushkakunaka mana payta kushichinahunchu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Chayta uyashpankuna saduseokunaka chunlla kiparirkakuna. Jesús chasna alita yachachishkanrayku chay runakuna yapa mancharirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Chaymanta fariseokunaka yachashpankuna Jesús saduseokunata chunllayachishkanta, payta tapunankunapa tantarirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Shuk paykunamanta Moisespa killkashkan kamachishkakunata yachachik kashpan Jesusta pantachichinayashpan tapurka: ");
INSERT INTO qupNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Yachachik, Yaya Diospa tukuy kamachishkankunamanta, ¿maykantaya ashwan ali kan? ");
INSERT INTO qupNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","38","Chayta tapushpan Jesuska aynirka: Chay tukuymanta ashwan ali kamachishkanka riman tukuy shunkuykimanta pacha Yayayki Diosta yuyashpa munashpa kawsay. Payta yuyahushpayki alikunata yuyarishpa rurashpa kawsay nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Chaymanta chay ishkaynin kamachishkanka chasnashinallatatami riman runa masikita yuyay kan kikitashina nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kay ishkaymi tukuy kamachishkakunamanta puntiru kanan tiyan. Chaymantallami tukuy Yaya Diospa kamachishkankunata, Yaya Diospa shiminta yachachikkunapa yachachishkankunatapas asirtananchi tiyan. ");
INSERT INTO qupNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","Fariseokuna tantarishka kahushkankunallapi Jesuska paykunata tapurka: Kankunaka ¿imatataya yuyarinkichi Yaya Diospa Kachanan Kishpichikmanta? ¿Maykan runapa miraymantataya? nishpa. Chasna tapushpan fariseokunaka aynirkakuna: Payka ñawpa atun apu David wañupa miraymantami kan nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Chaypina Jesuska paykunata rimarka: Davidpa miraymanta kashpanka ¿imaraykuta Yaya Diospa Espíritun yuyachishpan Davidka rimarka payta kamachik kananta kasna nishpa? ");
INSERT INTO qupNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Yaya Dioska kamachiwakta rimarka: Tiyariy kuskayni parti kamachinaykipa ñukawa pakta, tukuy kanta chiknik runakunata winsinaynikama kanta kasunankunapana nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","David Yaya Diospa Kachanan Kishpichikta kamachiwak nirka. Chay uras ña kawsa paymanta pasa kashpan David unay wañushkanwasha paypa miraymantallatata kashpan manami atipanchu runalla kanata. ");
INSERT INTO qupNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Chasna Jesús yachachihushpan chay fariseokunaka nima imata ayninata atipashpankuna chunlla kiparirkakuna. Chaymanta pacha nima shuk runa Jesusta tapunayarkakunanachu. ");
INSERT INTO qupNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Chaymanta Jesús chay fariseokunata yachachishkanwasha chay tantarishka runakunata, ñukanchikunatapas yachachirka: ");
INSERT INTO qupNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ñawpamanta pacha Moisespa killkashkan kamachishkakunata yachachikkuna, fariseokunapas tantarina wasipi tiyarinahun chay kamachishkanta yachachinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Chayrayku, paykuna Yaya Diospa shiminta kankunata yachachishpankuna alita rurashpa kasuychi. Alita yachachishpankunapas paykuna kikin mana ruranahunchu yachachishkankunashina. Kankunaka ama paykunashina ali shimita yanka yachakushpa kawsaychichu. ");
INSERT INTO qupNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Chay fariseokunaka shuk patronkuna runankunata llasha kargata apachihukshinami kanahun. Kankunata yuyayninkunamanta achka kamachinankunata yachachinahun. Kankunarayku kanahun atun llasha kargashina. Chasna kankunata yachachishkankunawa nitishkashina rurahushpankunapas nima shuk uchillastuta yanapanahunchu kankunata. ");
INSERT INTO qupNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Paykunaka tukuyta ruranahun runa masinkuna rikunankunallapa, Yaya Diosta alita kasukmi nishpa yuyarinankunapa. Yaya Diospa shiminta shuk shukta suni ñañu karakunapi killkanahun. Chaykunata urintinkunapi makinkunapi watanahun. Churarishkankuna shimita sumayachinahun. Chasna churarishkankunawa Yaya Diosta alita kasuk kani nishpa yanka rikuchinayashpa purinahun. ");
INSERT INTO qupNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Fiestakunapi, tantarina wasikunapipas paykunaka tukuymanta suma tiyarinakunapi munanahun tiyarinata runa masinkuna paykunata aputashina rikuhushkankunata rikuchishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ñampikunapi plasakunapi purihushpankuna yapa munanahun tukuy runakuna paykunata yuyashpankuna ali yachachik nishpa saludanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Yaya Diosllami kankunata kuskata yachachin. Chayrayku ama munaychichu runakuna kankunata yachachik nishpa rimanankunapa. Kankunaka wawkipurallami kankichi. Ñukallami kankunata yachachik kani. ");
INSERT INTO qupNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Chaymanta kay allpapi nima pita Yaya Diostashina yuyashpa Yayayni nishpa rimaychichu. Yayanchi Diosllatami yuyanaykichi tiyan, payllata kasunkichi. Yaya Dios shukllami, maykanmi silupi kawsan. ");
INSERT INTO qupNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Chaymanta ama munaychichu runa masikichikuna kankunata rimanankunapa kanmi kanki ñukata kamachik nishpa. Ñukallami Yaya Diospa Kachashkan Kishpichikka kankunata kamachik kani. ");
INSERT INTO qupNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Maykanmi kankunamanta ashwan kamachik kan payka tukuy runa masinkunata sumakta yanapak kanan tiyan. ");
INSERT INTO qupNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kankuna kikinmanta yuyarinkichima, ñuka tukuy runa masinikunamanta ashwan yachakmi kani nishpa. Chasna atun tukunayashpaykichika Yaya Diosmi kankunata mana alichu nishpa pinkachinka. Kankuna runa masikichikunamanta mana atun tukunayashpa paykunata yuyashpa yanapashpaykichika Yaya Diosmi sumakta kankunata atunyachinka. ");
INSERT INTO qupNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Chaypina Jesuska fariseokunata rimarka: Ay fariseokuna, Moisespa killkashkanta yachachikkunapas, ¡imashna kastigushi kankunarayku kanka! Yaya Diosta mana kasunayashpaykichipas alita kasukshina tukunkichi. Llullachiysikikunami kankichi. Runakunata arkankichi Yaya Diospa kamachishkankuna tukushpa paypa ali kamachihushkanpi mana kawsanankunapa. Kankunaka manami Yaya Diospa kamachishkankuna tukunkichichu. Chaymanta Yaya Diospa kamachishkankuna tukunayak runakunata arkankichi. ");
INSERT INTO qupNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","15","Ay Moisespa killkashkanta yachachikkuna, fariseokunapas, ¡imashna kastigushi kankunarayku kanka! Llullachiysikikunami kankichi. Yakuta allpata purinkichi shuk runallata maskashpa yachachinaykichipa kankunata katinanpa. Chaymanta chay kankunata katik runa kankunamanta ashwanta uchata rurachinkichi kankunamanta pasa nina mana wañukpi atunta kastigarishka kananpa. ");
INSERT INTO qupNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ay kankuna, ¡imashna kastigushi kankunarayku kanka! Wiskushina mana rikunata atipak kashpaykichi shukkunata ñampita purichinayankichi. Llullashpa yachachinkichi: Shuk runa rimahushkanta kirichinayashpa Yaya Diospa wasinta churashpa kirichina rimanakunawa rimashpanka mana shutipa kashpanpas Yaya Dioska payta mana kastigankachu. Yaya Diospa wasinpi kahuk orota churashpa kirichina rimanakunawa rimashpanka mana shutipa kashpan Yaya Dioska shuti payta kastiganka. ");
INSERT INTO qupNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Chasna llullachishpa yachachishpaykichi mana ali yuyayyu, mana asirtak runakunami kankichi. ¿Maykanta ashwan ali kan, Yaya Diospa wasinchu, chay wasipi tiyak orochu? Chay oroka Yaya Diospa wasinpi churashparami Yaya Diospa kan. Chayrayku Yaya Diospa wasinka chay churashka oromanta ashwan ali kan. ");
INSERT INTO qupNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Chaymanta kankuna llullashpa yachachinkichi: Shuk runa rimahushkanta kirichinayashpa Yaya Diospa wasinpi wiwakunata wañuchishpa rupachina tuchpashinata churashpa kirichina rimanakunawa rimashpanka mana shutipa kashpanpas Yaya Dioska payta mana kastigankachu. Chay tuchpashinapi Yaya Diosrayku churashkankunata churashpa kirichina rimanakunawa rimashpanka mana shutipa kashpan Yaya Dioska shuti payta kastiganka. ");
INSERT INTO qupNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Chayta yachachishpaykichi nima imata asirtak runakunami kankichi. ¿Maykanta ashwan ali, chay wiwakunata rupachina tuchpashinachu, chay tuchpashinapi Yaya Diosrayku churashkaykichichu? Chay kushkaykichika chay tuchpashinapi churashka kashpanrami Yaya Diosrayku kan. Chayrayku churashkaykichikunamanta tuchpashinaka ashwan alimi. ");
INSERT INTO qupNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Shuk runa rimahushkanta kirichinayashpa Yaya Diospa wasinpi wiwakunata rupachina tuchpashinata churashpa kirichina rimanakunawa rimashpanka mana chay tuchpashinallatachu yuyachishpa riman, ashwan tukuy chay tuchpashinapi churashkakunatapas. ");
INSERT INTO qupNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Shuk runa rimahushkanta kirichinayashpa Yaya Diospa wasinta churashpa kirichina rimanakunawa rimashpanka mana chay wasinllatachu yuyachishpa riman, ashwan Yaya Dios chay wasinpi kawsahushkantapas. ");
INSERT INTO qupNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Shuk runa rimahushkanta kirichinayashpa siluta churashpa kirichina rimanakunawa rimashpanka mana silullatachu yuyachishpa riman, ashwan maymantami Yaya Dios kamachin chaytapas, chaymanta Yaya Dios kikintapas. Chayrayku imatapas rimashpaykichika tukuy uras shutipallata rimaychi. ");
INSERT INTO qupNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ay Moisespa killkashkanta yachachikkuna, fariseokunapas, ¡imashna kastigushi kankunarayku kanka! Llullachiysikikunami kankichi. Tukuy tarpushkaykichimanta pallashkaykichi uchillastu pankakunamantapas chunkamanta shukta Yaya Diosta kunkichi. Chasna Yaya Diospa kamachishkanta shuk parti paktachishpaykichipas chay ashwan ali kasna nishkan kamachishkankunata mana paktachinkichichu: Alillata rurashpa rimashpa kawsaychi. Runa masikichita llakichishpa kawsaychi. Yaya Diosllata tukuy shunkuykichimanta pacha kirishpa alita kasuychi nishpa. Chay kamachishkankunataka paktachinaykichi tiyan chay shukkunawa pakta. ");
INSERT INTO qupNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kankunaka mana alita asirtashpaykichi wisku runa shukkunata ñampita purichikshinami kankichi. Shuk uchillastu siputuchi upyanaykichipi chinkarishpan shushunkichi mana millpunaykichipa. Chaymanta nima imata yuyarishpa shuk yapa atun animalta millpunkichi. Chasnashinami kankunaka tukuy ñawpa yaya rukuykichikuna wañupa rimashkankunata kasunkichi. Maykantami Yaya Dioska ashwanta munan, chaytaka nima yuyarinkichichu. ");
INSERT INTO qupNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ay Moisespa killkashkanta yachachikkuna, fariseokunapas, ¡imashna kastigushi kankunarayku kanka! Llullachiysikikunami kankichi. Tukuy rurashkaykichiwa alita rikurishpaykichipas shunkuykichipika millaypa yuyayyu kankichi, shukkunapa ima tiyapushkanta llullachishpa shuwakuna, tukuy imakunata munakkuna, mitsakkuna. Pusilluta, kallanata washanllata mayllak runakunashina kankichi, ukunta susyata sakinkichi. ");
INSERT INTO qupNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Wisku runakunashina nima imata asirtak fariseokuna, puntiru shunkuykichita alichaychi. Chaymanta aliyashka shunkuykichi kashpan alikunallatana ruraychi. ");
INSERT INTO qupNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ay Moisespa killkashkanta yachachikkuna, fariseokunapas, ¡imashna kastigushi kankunarayku kanka! Llullachiysikikunami kankichi. Shuk yurawa pintarishka rumiwa taparishka wañushkakunata churana uchkushinami kankichi. Kanchamantaka sumakta rikurishpanpas ukupika wañushkapa tullunkunawa millanayaypa ismukunawa untakta kan. ");
INSERT INTO qupNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Chasnashinami kankunapas runakunapa rikushkanpi Yaya Diospa kamachishkanta alita kasukshina rikurishpaykichipas yuyaykichipika yapa millaypata yuyarishpa llullachiysikikunami kankichi. ");
INSERT INTO qupNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ay Moisespa killkashkanta yachachikkuna, fariseokunapas, ¡imashna kastigushi kankunarayku kanka! Llullachiysikikunami kankichi. Chay Yaya Diospa yachayninwa yachachikkunapa aychanta churashkankunata sumayachinkichi paykunata yuyakkunashina tukushpa. Chay ñawpa alita rurashpa kawsak runakunata yuyarinaykichi rumikunata pantiyunpi sumayachinkichi. ");
INSERT INTO qupNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Chaymanta rimankichi: Ñukanchi ñawpa yaya rukunchikuna kawsashkan uras kawsanchima karka, manami paykunata yanapanchimachu karka Yaya Diospa yachayninwa yachachikkunata wañuchinata nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Chasna yaya rukunchikuna nishpa rimashpaykichimi kankuna kikin rimankichi chay wañuchik runakunapa miraykuna kanaykichita paykunashina millaypa yuyayyukuna. ");
INSERT INTO qupNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kankunapas shutipa kashkata yachachikkunata wañuchinayashpalla kawsashpaykichimi yaya rukuykichikunapa ucha ruranankuna pishishkata paktachinkichi. ");
INSERT INTO qupNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Machakuyashina runakuna kankichi, yachachinaykichiwa runakunata pantachichishpa yuyayninkunata waklichikkuna. ¿Imashnashi kishpinkichi chay nina mana wañukmanta? ");
INSERT INTO qupNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Chayrayku ñuka kankunama kachasha Yaya Diospa yachayninwa yachachikkunata, ali yachayyukunata, Yaya Diospa shiminta alita yachakushka yachachikkunata kankunata yachachinankunapa. Kankuna millaypa yuyayyu runakuna kashpaykichi shukkunata wañuchinkichi. Shukkunata kruspi klabashpa wañuchinkichi. Shukkunata chiknishpa tantarinaykichi wasikunapi makankichi. Chaymanta paykunata shuk llaktamanta shuk llaktama kallpachishpa chiknishpa parisichinkichi. ");
INSERT INTO qupNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ñawpamanta pacha kunankama yaya rukuykichikuna alita paykunata yachachishpa kawsak runakunata wañuchishkakuna. Chay ali rurak runa Abelta wawkinka wañuchirka. Chaymanta yaya rukuykichikuna wañuka achkata wañuchirkakuna, Berekiaspa wawan Sakariasta wañuchishkankunakama. Yaya Diospa wasinpi wiwakunata rupachina tuchpashinapa kuchunpi kahushpanpas wañuchirkakuna. Kankuna chasnalla katishkaykichirayku tukuy chay ñawpa wañuchishkakunamantapas uchayu kankichi. ");
INSERT INTO qupNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Alita uyawaychi. Kankuna tukuy chay ñawpamanta pacha mana ali ruranakunata yachashpaykichipas mana yachakushpaykichi chasnallatata rurankichi. Chayrayku Yaya Dios kankunata sinchitami kastiganka. ");
INSERT INTO qupNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Chaymanta Jesuska Jerusalén llaktapi kawsak runakunata yapa llakishpan rimarka: Ay Jerusalenpi kawsak runakuna, yapa llakini kankunarayku. Ñawpamanta pacha Yaya Diospa yachayninwa paypa shiminta yachachikkunata wañuchik kankichi. Yaya Dios kachashkan runakunatapas rumikunawa tuksishpa wañuchik kankichi. Kunanka ñuka achka kuti kankunata wañuymanta arkanayashkani, imashnami shuk atallpa wawankunata rikran ukupi tantachishpan arkan wañuymanta. Sumakta kankunata arkanayashpaynipas manami munawashkankichichu. ");
INSERT INTO qupNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Rikuychi, kunanka kankunata sakishpayni llaktaykichika chunllami kiparinka. ");
INSERT INTO qupNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Chaymanta kankunata rimani, shuk puncha rimawankichi Yaya Diospa yanapashkan ali runami kanki. Yaya Diospa munashkanta ruranaykipa kachashkan kashpaykimi shamuhunki nishpa. Kunanmanta pacha chasna rimawanaykichi punchakama mananami rikuwankichichu. ");
INSERT INTO qupNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Chayta yachachishkanwasha Jesuska Yaya Diospa wasinmanta llukshirka. Rihushkanpi ñukanchi kayllayashpanchi rimarkanchi: Rikuy kay suma ali rurarishka Yaya Diospa wasinta. ");
INSERT INTO qupNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Chasna rikuchishpanchi Jesuska rimarka: Kunan rikuchiwahunkichi kay sumakta rurarishka wasikunata. Alita uyawaychi. Chiknik runakunami urmachik shamunkakuna tukuy kay suma rikuhushkaykichita. Urmachishpankuna nima shuk rumi awapura rurarishkaka kiparinkachu. ");
INSERT INTO qupNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Chaymanta Jesuska ñukanchiwa pakta Olivos urkuma rirka. Chaypi tiyarishpan sapallanchi kahushkanchipi payta kayllayashpanchi tapurkanchi: Yachachik, ¿ima urastaya Yaya Diospa wasintaka urmachinkakuna? ¿Imata rikushpanchita yachanchima kutimunayki ña paktarihushkanta? ¿Imashnata yachanchima kay allpa tukurinan ña paktarihushkanta? ");
INSERT INTO qupNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Chaypina Jesuska ñukanchita rimarka: Alita yuyariychi, mana nima pi kankunata llullachinanpa. ");
INSERT INTO qupNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Manara kutimuhushpaynira achka runakuna shamunkakuna kasna nishpa: Ñukami kani Yaya Diospa Kachashkan Kishpichik. Chasna llullashpankunami achka runakunata kirichinkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Uyashpaykichika runakuna chikninakushpa kaypi chayma wañunakuhukkunata, ama mancharinkichichu. Tukuy chaykunami pasanan tiyan. Wañunakushpa kawsahushpankunapas chay uras kay allpaka manarami tukurinkarachu. ");
INSERT INTO qupNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Shuk shimita rimakkuna shuk shimita rimakkunawa chikninakushpankuna wañunakunkakuna. Shuk allpapi kawsak runakunaka shuk allpapi kawsak runakunawa sinchita chikninakushpankuna wañunakunkakuna. Chaymanta achka llaktakunapi sinchi yarkay tiyanka. Tukuy partimi allpaka sinchita kuyunka. ");
INSERT INTO qupNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tukuy chaykuna kanka kallarinanlla. Chaywasha ashwan sinchi llakiypa punchakunami kankakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Chaypina kankunata chiknik runakunaka apukunapi pushashpankuna rimankakuna parisichinankunapa. Kankunamanta shukkunata wañuchinkakuna. Ñukata kirishpa kawsashkaykichirayku tukuy llaktakunapi achka runakuna kankunata chikninkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Chay uras achka runakunaka manana munankakunanachu kirishpa kawsanata. Chaymanta shukwa shukwa chikninakushpankuna apunkunapi paykunapura yanka millaypata shukmanta shukmanta rimankakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Yaya Diospa yachayninwa yachachik kani nishpa achka llullachishpa yachachikkuna tiyanka. Paykuna achka runakunata llullachinkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Achka runakuna yapa millaypakunata rurashpa kawsashpankuna kay allpapi millaypa ruranakunata yapa mirachinkakuna. Chayrayku achka Yaya Diosta kirikkunapas manana yuyanakushpachu kawsankakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kankuna wañunaykichi punchakama alita ñukallata kirishpa kawsashpaykichika Yaya Dios kankunata kishpichinka paywa pakta silupi kawsanaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kankunaka tukuy kay allpapi kay suma ali shimita yachachinaykichi tiyan Yaya Diospa ali kamachinan kay allpapi ña kallarishkanmanta tukuy runakuna yachanankunapa. Chasna yachashpankuna manana atipankakunachu rimanata mana yachashkanichu nishpa. Chaypirami kay allpapa tukurinanka kanka. ");
INSERT INTO qupNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ñawpa Yaya Diospa yachayninwa yachachik Daniel killkarka: Yaya Diosta chiknik runaka Yaya Diospa wasinpi yapa millaypata ruranka nishpa. Chay killkashkanpi pasananta rikushpaykichi leyishkaykichita yuyariychi alita asirtanaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Chaypina kankuna Judea allpapi kawsakkunaka utkalla urkukunama mitikuychi. ");
INSERT INTO qupNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Wasi awapi kahushpaykichika chaymantalla utkalla mitikuychi. Ama wasikichipi yaykunkichinachu kankunapa imaykichi tiyashkanta apanaykichipa. Utkalla mitikunaykichi tiyan. ");
INSERT INTO qupNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Chakraykichipi tarawahushpaykichika chaymantalla mitikuychi. Amana wasikichima kutiychinachu churarinaykichita apanaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Chasna mitikuhushkaykichi punchakunapi yapa llakiypa kanka chay chichu warmikunarayku chay llullu wawayu warmikunaraykupas. ");
INSERT INTO qupNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kankunaka Yaya Diosta mañaychi ama chiri tamya punchakuna, nima samana puncha mitikunaykichi punchaka paktananpa. ");
INSERT INTO qupNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Chay punchakunapi tukuy runakuna sinchita parisinkakuna. Yaya Dios kay allpata rurashkanmanta pacha manami chasna sinchi llakina tiyarkachu. Nima chaywasha chasna llakina tiyankanachu. ");
INSERT INTO qupNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Yaya Dioska tukuy akllashkan runakunata yuyashkanrayku chay llakina punchakunata uchillayachinka. Mana uchillayachimaka, nima shuk runa wañuymanta kishpimachu. ");
INSERT INTO qupNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Chay punchakunapi maykanpas kankunata rimankakuna: Rikuychi, kaypimi chaypimi Yaya Diospa Kachashkan Kishpichikka. Chasna rimashpankunapas ama paykunata kiriychichu. ");
INSERT INTO qupNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Chay punchakunapi achka runakuna llullachishpa purinkakuna ñukami Yaya Diospa Kachashkan Kishpichik kani nishpa. Shukkunaka llullachishpa rimankakuna ñukami Yaya Diospa yachayninwa yachachik kani nishpa. Paykunaka achka suma mana atipaypakunata, atun yachaywa runakuna nima ima uras rikushkankunata rurankakuna. Chayta rurashpankuna Yaya Diospa akllashkankunatapas llullachinayankakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Chay uras yuyariychi ña kankunata rimashkaynita chasna llullachik runakuna paktanankunata. ");
INSERT INTO qupNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Shuk runakuna kankunata rimashpankunaka chaypimi Yaya Diospa Kachashkan Kishpichikka, payta rikuk riychi chunlla chakishka allpapi nishpa, ama riychichu. Shukkunaka kankunata rimashpankuna rikuk shamuychi kaypimi pakashka nishpa, ama kiriychichu. ");
INSERT INTO qupNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ñuka Yaya Diospa Kachashkan Runa kutikashka shamuhushpayni tukuy runakunami rikuwankakuna. Imashnami shuk ilampa silupi shuk partimanta shuk partima kunkaymanta chuyahlla rikurin, chasnashinami ñukapas shamusha. ");
INSERT INTO qupNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Maypimi wañushkakunaka sirihunkuna, chaypimi ullawankakunaka tantarinahun. Chasnashinami runakuna millaypa ruranankunata yapa mirachishpankuna millanayaypa ismushina tukushpankuna kastigay tukunkakuna. Chayka mana pakallachu kanka ashwan tukuyrayku yachaypa rikuypa kanka. ");
INSERT INTO qupNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Chaymanta Jesuska ñukanchita yachachihushkanllapi rimarka: Sinchi parisina puncha tukushpanna intika amsayanka. Killaka manana punchayachinkachu. Istrillakuna silumanta urmankakuna. Silupi tukuy punchayachikkuna sinchita kuyurinkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Chaypina ñuka Yaya Diospa Kachashkan Runa manarapas kutimuhushpaynira shuk imata silupi rikuchisha. Chayta rikushpankunami tukuy kay allpapi kawsak runakuna sinchita mancharishpa wakankakuna. Chaypina rikuwankakuna puyukuna awapi shamuhushkaynita, suma chuyahlla Yaya Diospa atun yachayninwa. ");
INSERT INTO qupNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Chaypina angelkunata kamachisha atun trompetankunata sinchita pukushpankuna tukuy partimanta akllashkaynikunata tantachinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Shuk igu kaspita rikushpa yachakuychi. Paypa yakunka ramankunapi sikashpan achkata pankayahushpan yachankichi verano timpu kananta. ");
INSERT INTO qupNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Chasnashinami tukuy kay rimashkaynita rikushpaykichi yachankichi ñuka ña shamunalla kahushkaynita. ");
INSERT INTO qupNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Alita uyawaychi. Kunan kay punchakunapi kawsak runakunaka manara wañushpankunara tukuy kay rimahushkaynita rikunkichi. ");
INSERT INTO qupNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kay siluka allpapas tukurinankuna tiyan. Tukuy rimashkaynika manami chasnalla pasankachu, shutipami paktarinan tiyan. ");
INSERT INTO qupNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ima punchami ima urasmi kutimusha, chaytaka Yaya Diosllami yachan. Nima shuk runa, nima silupi kawsak angelkuna yachanahunchu. Nima ñuka Yaya Diospa kikin Wawan kashpaynipas mana yachanichu ima urasmi kutimusha nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ñuka Yaya Diospa Kachashkan Runa kuti shamunayni uras kanka imashnami ñawpa Noé kawsashkan uras karka. ");
INSERT INTO qupNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Manara Yaya Dios allpata yakuwa untachishpanra tukuy runakuna kunkaylla mikushpa, upyashpa, warmiyashpa kawsapayarkakuna. Noeka chay atun lanchanpi yaykunan punchakama chasnalla kawsapayarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Chay runakuna nima yuyarihushkankunapi Yaya Dioska allpata yakuwa untachishpan tukuy chinkarirkakuna. Chasnallatatami ñuka Yaya Diospa Kachashkan Runa kutimuhushpayni nima yuyarihushkankunapi runakunaka kullunkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Chay uras ishkay runakuna chakranpi tantaylla tarawashpa kahushpankuna angelkuna shukta pushankakuna, shuktaka sakinkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ishkay warmi shuk batanllapi kutahushpankuna angelkuna shukta pushankakuna, shuktaka sakinkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Mana yachankichichu ima urasmi ñuka Amuykichi kutikashka shamusha nishpa. Chayrayku shamunaynikama yuyashpalla chapawaychi. ");
INSERT INTO qupNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Alita asirtaychi. Wasi amuka yachashpanka ima urasmi tutapi shuwaka shamunanta, mana puñushpachu uyashpalla chapama. Chasna chapashpan chay shuwak runaka nima imata shuwamachu chay wasimanta. ");
INSERT INTO qupNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Chayrayku kankunapas tukuy uras alicharishka chapawaychi. Kankuna nima yuyarihushkaykichipi ñuka Yaya Diospa Kachashkan Runaka shamusha. ");
INSERT INTO qupNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Chaymanta Jesuska ñukanchita yachachishpalla katirka: Shuk patrón shuk llaktama rinanpa, shuk ali yuyayyu tukuy uras alita paktachik runanta kamachirka tukuy paypa runankunata tarawachinanpa, chaymanta mikuna uras alita karananpa. ");
INSERT INTO qupNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Chay runanka kushillami kanka patroynin kutimushpan paypa kamachishkanta alita paktachishpa kahushkanpi tarik shamushpanka. ");
INSERT INTO qupNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Alita uyawaychi. Chasna alita kasuk runanta patroyninka churanka tukuy ima tiyapushkanta kuyrak kananpa. ");
INSERT INTO qupNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ashwan chay kamachik runanka millaypa yuyayyu kamaka yuyarima, patroynika mana utka kutimunkachu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Chasna yuyarishpan kallarima tarawak masinkunata makashpa parisichinata. Pay kikin machak runakunawa tantarishpan sumakta mikuma upyama. ");
INSERT INTO qupNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Chasna rurashpa kahushkanpi, mana yuyarihushkanpi patroyninka kutimuma. ");
INSERT INTO qupNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Chaypina chay runanta sinchita kastigama. Chasnallatata Yaya Dioska payta mana kasuk, millaypa yuyayyu runata mana llakichishpan tukuy llullachik runakunawa parihu nina mana wañukpi kastiganka. Chaypina chay runaka sinchita parisishpa wakanka, piñaywa kirunkunata kanirinka. ");
INSERT INTO qupNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yuyariychi imashnami Yaya Diospa ali kamachinanka kay allpapi paktachirinka tukuy chay rimashkaynishina pasahushkan uras. Rikuychi chunka shipaskunata. Chunka shipaskuna, kusayahuk warmipa amigankuna lamparinkunata apashpankuna tinkuk rirkakuna kasarahushkan musuta wasinma pushanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Chay chunka amigankunamanta pichka alita yuyarik karkakuna, pichka nima imata yuyarikchu karkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Chay pichka mana alita yuyarik shipaskunaka lamparinkunata apashpankuna mana kerosenta aparkakunachu kutikashka untachinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Chay pichka alita yuyarik shipaskunaka lamparinkunata apashpankuna butillankunapi kerosenta aparkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Chaypina kasarak musuka yapa unayashpan shamunanpa, chay chunka shipaskunaka chapahushkankunapi yapa sampayashpankuna puñurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ña chawpi tuta kahushpan uyarkakuna shuk runa karumanta kaparihushkanta: ¡Ñami musuka shamuhunna! ¡Payta tinkuk riychi! nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Chaypina chay shipaskunaka utkalla atarishpankuna lamparinkunata alicharkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Chay pichka nima imata yuyarikkunaka chay pichka yuyarik amigankunata rimarkakuna: Lamparinchikunapa kerosenka ñami tukurishka. Kuychi ñukanchitapas shuk uchillastu kerosenstuta. ");
INSERT INTO qupNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Chasna tapushpankuna chay pichka alita yuyarik shipaskunaka rimarkakuna: Kerosenchimanta kushpanchika ñukanchiraykupas pishinkami, tukuy lamparinchikunaka wañunka. Kerosenta munashpaykichika utkalla rantik riychi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Mana kunayashpankuna chay pichka nima imata yuyarikkunaka kerosenta rantik rirkakuna. Rinankunakama kasarak musuka paktamurka. Chaypina paywa pakta chay pichka alita yuyarik amigankunaka kasarana mikuna wasipi yaykurkakuna. Tukuy yaykushpankunana wasi punkuta taparkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Chaywasha chay pichka nima imata yuyarik amigankunaka paktamurkakuna. Punkuta waktashpankuna kasarak musuta kayarkakuna: ¡Musu, musu, paskay punkuta ñukanchipas yaykunanchipa! ");
INSERT INTO qupNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Chaypina payka ukumanta rimarka: Kankunaka manami kayashkaynichu kankichi, manami kankunata riksinichu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Chasna kwintashkanwasha Jesuska ñukanchita rimarka: Kankuna mana yachankichichu ima urasmi, ima punchami kutimusha nishpa. Chayrayku alita tukuy uras alicharishka chapawanaykichi tiyan. ");
INSERT INTO qupNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Chaymantapas Yaya Diospa ali kamachinanka kay allpapi paktachirishpan kasnami kanka: Shuk patrón karu llaktama rinayashpan paypa runankunata kayashpan kullkinta kurka mirachipunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Shuk runanta pichka waranka kullkita kurka. Shuktaka ishkay waranka kullkita kurka. Shuktaka shuk waranka kullkita kurka. Kimsanti runankunata atipanankuna tuputa kurka. Chay kullkita kushpanna shuk karu llaktama rirka. ");
INSERT INTO qupNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Chaypina chay pichka warankata apishka runanka chay kullkiwa tarawashpan mirachirka pichka waranka ashwanta. ");
INSERT INTO qupNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Chasnallatata chay ishkay warankata apishka runanpas tarawashpan ishkay warankata mirachirka. ");
INSERT INTO qupNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Chaymanta chay shuk warankata apishka runanka chay kullkiwa mana tarawanayashpan chay kullkita allpapi pamparka. ");
INSERT INTO qupNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Chaymanta unayma chay patronka kutimurka. Chaypina kullkinta kushkan runankunata tapurka maytukuytata mirachishkakuna nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Chaypina pichka waranka kullkita apishka runanka chunka warankata apamushpan patroyninta rimarka: Patroyni, kutichishkayki kay pichka waranka kuwashkayki kullkita. Chaymanta kushkayki kay pichka waranka mirachishkaynitapas nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Chay mirachishka kullkita kushpanna patronka rimarka: Alitami rurashkanki. Kanmi kasuwak alita paktachik runayni kanki. Chay uchillastu kushkayni kullkiwa alita tarawashkanki. Chayrayku ashwanta kushkayki chaywa tarawanaykipa. Kunanka wasinipi yaykuy ñukawa pakta kushikunaykipa. ");
INSERT INTO qupNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Chaypina chay ishkay waranka kullkita apik runanka patroyninta kayllayashpan rimarka: Patroyni, ñukata kuwashkanki ishkay warankata tarawachinaynipa. Kunanka chaytami kanta kutichini. Chaymanta kay mirachishkayni ishkay warankatapas kushkayki nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Chasna chusku waranka kullkita kushpanna patronka rimarka: Alitami rurashkanki. Kanmi kasuwak alita rurak runa kanki. Chay uchillastuta kushkayni kullkiwa alita tarawashkanki. Chayrayku ashwanta kushkayki chaywa tarawanaykipa. Kunanka wasinipi yaykuy ñukawa pakta kushikunaykipa. ");
INSERT INTO qupNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Chaymanta shuk waranka kullkita apik runanka patroyninta kayllayashpan rimarka: Patroyni, ñuka alita kanta riksini, sinchita tarawachik patrón kanaykita. Kanka shuk runapa tarpushkankunamanta pallanki. Chikan runapa mirachishkanta apinki. ");
INSERT INTO qupNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Sinchi kamachik kanaykita manchashpayni kuwashkayki kullkita allpapi pampashkani. Kay shuk waranka kullki kuwashkaykillatata kutichishkayki. ");
INSERT INTO qupNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Chasna kushpanna patroyninka rimarka: Kanka mana ali yuyayyu yapa killaysiki runaynimi kanki. Ñuka shuk runapa tarawashkanmanta pallanaynita, chikan runapa mirachishkanta apinaynita yuyarinki. ");
INSERT INTO qupNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Chasna kashpan ¿imaraykuta kullkinita mana churarkankichu kullkita mirachina wasipi chaypi mirachipanankunapa? Ñuka kutimushpayni kullkinita mirashkantapas surkuynima karka. ");
INSERT INTO qupNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Chasna rimashpan patronka chaypi kahuk runakunata kamachirka: Chay shuk waranka kullkita kushkayni runata kichushpaykichi kuychi chay chunka waranka kullkiyu runata. ");
INSERT INTO qupNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Maykan runami charishkanwa atipashkanwa alita ruran payka ashwanta kuy tukunkami tiyapushkan puchurinankama achkata atipak kanankama. Maykan runami uchillastu charishkanwa uchillastu atipashkanwa mana alita ruran payka chay uchillastu tiyapushkantapas atipashkantapas kichuy tukunkami. ");
INSERT INTO qupNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Chayrayku chay nima imarayku valik runata chay manchaypa amsama wichuychi. Chaypina sinchita parisishpa wakanka, piñaywa kirunkunata kanirinka. ");
INSERT INTO qupNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Chaymanta Jesuska ñukanchita yachachishpalla katirka: Ñuka Yaya Diospa Kachashkan Runa shuk puncha tukuy angelkunawa pakta suma yachayniwa kutimusha tukuy runakunata kamachinaynipa. Chasna shamushpayni suma chuyahlla kamachina tiyarinaynipi tiyarisha. ");
INSERT INTO qupNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Chaypi tiyarishpayni tukuy allpakunamanta runakuna puntaynipi tantarinkakuna. Imashnami shuk runa obehankunamanta kabrakunata shuk partipi churananshina, chasnallatata ñukapas runakunawa rurasha. ");
INSERT INTO qupNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Akllashkayni runakunataka kuskayni parti churasha. Mana akllashkayni runakunataka llukini partimi churasha. ");
INSERT INTO qupNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Chaypina ñuka atun apu kashpayni kuskayni parti churashkayni runakunata rimasha: Yayayni kankunata alita rikushpan aliyachishkanrayku shamuychi Yaya Diospa ali kamachinan mushu mundupi ñukawa pakta kamachinaykichipa. Chay kamachinan mushu mundupi kawsanaykichipa Yaya Dios kay allpata rurashkanmanta pacha kankunarayku wakaycharka. ");
INSERT INTO qupNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ñuka yarkaywa kahushpayni kankuna karawarkankichi. Yakunayashpayni upyachiwarkankichi. Mana riksishkaykichi runa kashpaynipas paktamushpayni wasikichipi kayawashpaykichi samachiwarkankichi. ");
INSERT INTO qupNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Churarinayni pishiwashpan kankuna kuwarkankichi churarinaynipa. Unkushka kahushpayni kuyrawarkankichi. Karselpi kahushpayni rikuk riwarkankichi. ");
INSERT INTO qupNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Chasna rimashpayni paykunaka tapuwankakuna: Yaya Jesús, ¿ima urastaya yarkaywa kahushpayki kanta kararkanchi? ");
INSERT INTO qupNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Ima urastaya llaktanchipi paktashpayki mana riksishkanchi runa kashpayki wasinchipi kanta kayashpa samachirkanchi? ¿Ima urastaya churarinaykika pishishpan kanta kurkanchi churarinaykipa? ");
INSERT INTO qupNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Ima urastaya unkushka kahushpayki karselpi kahushpayki kanta pasyarkanchi? ");
INSERT INTO qupNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Chasna tapuwashpankuna ñukaka atun kamachik kashpayni paykunata rimasha: Alita uyawaychi. Kankunaka nima imayu runata yanapashpaykichi ñukatami yanapawashkankichi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Chaymanta llukini parti churashkayni runakunata rimasha: Ñukamanta anchuriychi, Yaya Diosmi kankunata kastiganka. Nina mana wañukma riychi. Yaya Dios chay ninataka rurashka tukuy supaykunarayku kamachinankunawa pakta chaypi wiñayparayku kastigarishka kanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ñuka yarkaywa kahushpayni mana karawarkankichichu. Yakunayashpayni nima yakuta kuwarkankichichu. ");
INSERT INTO qupNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mana riksishkaykichi runa kashpayni paktamushpayni wasikichipi mana kayawarkankichichu samanaynipa. Churarinayni pishiwashpan nima imata kuwarkankichichu churarinaynipa. Unkushka kahushpayni karselpi kahushpayni nima ima uras rikuk riwarkankichichu. Chayrayku Yaya Dios kankunata kastiganka. ");
INSERT INTO qupNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Chasna rimashpayni tapuwankakuna: Yaya Jesús, ¿ima urastaya yarkaywa kashpayki kanta mana kararkanchichu? ¿Ima urastaya yakunayashpayki kanta mana yakuta kurkanchichu? ¿Ima urastaya llaktanchipi paktashpayki mana riksishkanchi runa kashpayki wasinchipi kanta mana kayarkanchichu? ¿Ima urastaya churarinaykika pishishpan kanta mana kurkanchichu churarinaykipa? ¿Ima urastaya unkushka kahushpayki karselpi kahushpayki kanta mana rikuk rirkanchichu? ");
INSERT INTO qupNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Chasna tapuwashpankuna ñuka rimasha: Imashnami mana nima imayu runata mana yanapashkankichichu, chasnashinami ñukatapas mana yanapawashkankichichu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Chay mana alita rurak runakunaka nina mana wañukmami rinankuna tiyan. Yaya Diosta kasushpa kawsak runakunami siluma wiñaypa kawsak rinankuna tiyan. ");
INSERT INTO qupNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tukuy chaykunata yachachishkanwasha Jesuska ñukanchita rimarka: ");
INSERT INTO qupNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Kankuna yachankichi Paskua punchakunarayku ishkay punchallana pishinanta. Manara chay punchakuna kallarihushpanra chiknik runakuna ñuka Yaya Diospa Kachashkan Runata apunkunama pushawankakuna. Paykunata kuwankakuna kruspi klabachishpa wañuchiwanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Jesús chayta ñukanchita rimahushpan chay punchallatata saserdotekunapa apunkuna ñukanchita kamachik israel masinchi rukukunawa pakta saserdotekunapa atun apu Kaifaspa wasinpi tantarirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Paykuna yuyarirkakuna llullachishpa Jesusta apichishpankuna wañuchichinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Chasna ruranata munashpankunapas paykunapura rimarkakuna: Mana Paskua punchakunapi wañuchichishunchichu, kay Jerusalenpi kahuk runakuna ñukanchita mana piñay tukunanchipa. Chayrayku manara chay punchakuna paktarihushpanra apichishunchi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Betania llaktapi kawsarka shuk runa Simón shutiyu. Paytami Jesuska ñawpa aycha ismuchik unkuymanta ampirka. ");
INSERT INTO qupNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jesús Simonpa wasinpi mikuhushpan shuk warmi yaykurka. Chay warmika apamurka yura rumimanta rurarishka butillapi yapa chaniyu mishkinlla asnak perfumita. Jesusta kayllayashpan umanpi chay mishkinlla asnak perfumita talirka. ");
INSERT INTO qupNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Chayta rikushpanchi piñarishpa rimarkanchi: ¿Imaraykushi kay warmika chay mishkihlla asnak perfumita usuchihun? ");
INSERT INTO qupNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ashwan ali kama karka, chay perfumita rantichishpan chay apishkan kullkiwa nima imayu runakunata yanapananpa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús chayta uyashpan rimarka: ¿Imaraykuta piñarishpaykichi kay warmita pinkachihunkichi? Chay perfumita umaynipi talishpan alitami rurashka. ");
INSERT INTO qupNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nima imayu runakunaka tukuy urasmi kankunawa kawsankakuna. Ñukataka mananami tukuy uras rikuwankichinachu. ");
INSERT INTO qupNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kay warmika chay mishkihlla asnak perfumita aychaynipi talishka, wañushpayni aychaynika alicharishka kananpa urku uchkupi churashpa tapanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Alita uyawaychi. Tukuy maypipas runakuna kay ali shimita ñuka runakunata kishpichinaynimanta yachachishpankuna kay warmipa rurashkanmantapas rimankakuna. Payka ñukata yapa yuyawashpan chasna rurawashka. Chasna kashpan tukuy runakuna paymantapas alita yuyarinkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ñukanchi Jesuspa chunka ishkay runankunamanta shuk karka Judas Iskariote shutiyu. Payka kullkiranti Jesusta apichinayashpan saserdotekunapa apunkunata rimak rirka: ");
INSERT INTO qupNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ñuka rimashkaykichi imashnami Jesusta atipankichi apinata nishpa. ¿Masnatata pagawankichi? Chasna Judas rimashpan paykunaka aynirkakuna: Kimsa chunka kullkita kanta kushu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Chay kullkita apishkan urasmanta pacha Judaska yuyarirka imashnami Jesusta apichichinka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Chay Paskua punchakunapi ñukanchi israel runakuna mikunchi pan mana punkichishkata, chaymantapas shuk obeha maltata. Chay Paskua kallarinan punchapi ñukanchika payta kayllayashpanchi tapurkanchi: ¿Maypita munanki alichashpa obeha maltata kusananchipa, Paskua punchakunapi mikunanchipa? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Chaypina Jesuska ñukanchita aynirka: Jerusalén llaktama riychi chay riksishkayni runapa wasinma. Chaypi payta rimankichi: Ñukanchita yachachikmi kanta riman, wañunayni puncha ñami paktarihun. Chayrayku wasikipi runaynikunawa Paskua punchapi mikunata mikunayani nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Chasna Jesús rimashkanshina, ñukanchika chay Paskua punchapi mikunanchipa rurak rirkanchi. ");
INSERT INTO qupNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ña tutayahushpanna Jesuska tukuy ñukanchi chunka ishkay runankunawa pakta mesa muyukta siririshpa kahurkanchi mikunanchipana. ");
INSERT INTO qupNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Chay mikuhushkanchipi Jesuska rimarka: Alita uyawaychi. Chikniwak runakuna apiwankakuna wañuchiwanankunapa. Shuk kankunamantami apichichiwanka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Chasna rimashkanta uyashpanchi ñukanchika yapa llakirirkanchi. Chaypi Jesusta tapurkanchi shukllankama shukllankama: Yaya Jesús, ¿pitaya ñukanchimanta chasna rurama? ¿Ñukachu apichichishkayki? Mana kaynima ñuka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Chasna tapushpanchi Jesuska aynirka: Ñukawa parihu kay kallanapi panninta ukuchishpan mikuhukmi kuntraynikunata apichichiwanka. ");
INSERT INTO qupNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Imashnami Yaya Dios ñawpamanta killkachirka ñukamanta, chasnashinami ñuka Yaya Diospa Kachashkan Runaka wañunayni tiyan. Wañuna kashpaynipas chay apichichiwak runarayku llakirini, yapa parisinan tiyan. Ashwan ali kama karka, mana wawayarima karka. ");
INSERT INTO qupNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jesuspa rimashkanta uyashpan Judaska, maykanmi kuntrankunata apichinayarka, payta tapurka: Yachachik, ¿ñukachu apichishkayki? nishpa. Chasna tapushpan Jesuska aynirka: Ari, kanmi kanki nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mikuhushpanchira Jesuska panta apishpan Yaya Diosta agradesirka. Chay panta pakishpa pakishpa ñukanchita kurka. Chasna kuhushkanpi rimarka: Kay panta mikuychi. Kay panka aychaynishinami kan. Kayta mikushpaykichi yuyariychi, ñuka wañushpayni kankunata kishpichinaynita. ");
INSERT INTO qupNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Chaymanta shuk pusillu vinuta apishpan Yaya Diosta agradesirka. Chay pusilluta ñukanchita kuhushpan rimarka: Tukuy kankuna kay vinuta upyaychi. ");
INSERT INTO qupNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kay vinuka yawarnishinami kan. Wañushpayni yawarni shuturishpan Yaya Dios achka runakunata uchankunamanta llakichishpan kishpichinka. Kay yawarni shuturinanwa Yaya Dios runakunarayku paywa alichananta paktachin. ");
INSERT INTO qupNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kankunata rimani, ñukaka manami kutikashka kay allpapi kushilla kankunawa tantarishpa kay vinuta upyashanachu. Ña wañushami. Ashwan shuk puncha Yaya Diospa ali kamachinan mushu mundupi shuk mushu vinutana kankunawa upyahukshina tantaylla kushilla kashunchi. ");
INSERT INTO qupNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Chasna Jesuska rimashkanwasha takirkanchi salmokunata. Chaymanta rirkanchina Olivos urkuma. ");
INSERT INTO qupNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Chaypina Jesuska rimarka: Yaya Diospa killkachishkanpi ñukanchita riman: Obehankunata kuyrak runata wañuchisha. Chayrayku tukuy obehankuna shikwarinkakuna nishpa. Chay killkapi rimashkanshina, kay tuta tukuy kankuna kuntraynikunata manchashpaykichi sakiwankichi. ");
INSERT INTO qupNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Wañushkayniwasha Yaya Dios kawsachiwashpan ñukara kankunamanta ñawpashpa Galilea allpama risha. ");
INSERT INTO qupNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Chasna Jesuspa rimashkanta uyashpan Pedroka aynirka: Tukuy katik masinikuna mancharishpa kanta sakishpankunapas ñukaka nima ima uras sakishkaykichu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Chaypina Jesuska Pedrota rimarka: Alita uyaway. Kay tuta manarapas atallpa kantahushpan kimsa kuti mana riksiwanaykita rimanki. ");
INSERT INTO qupNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedroka sinchita rimashpan nirka: Kanwa parihu wañunayni kashpanpas wañusha, manami rimashanchu kanta mana riksinaynita nishpa. Chasnallatata tukuy ñukanchikunapas payta rimarkanchi. ");
INSERT INTO qupNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Chaymanta Jesuska ñukanchiwa pakta chay olivos tarpu kinchama, Getsemaní shutiyuma rirka. Chaypi paktashpanchi Jesuska rimarka: Kayllapi tiyarishpa chapawaychi, chaynikstupi rishpayni Yaya Diosta mañanaynikama nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Chasna rimashkanwasha Pedrota, Sebedeopa ishkay wawankunatapas pusharka chaynikstuma. Chaypina Jesuska wañunanta yuyarishpan mancharishpa yapa llakirishpan paykunata rimarka: ");
INSERT INTO qupNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Wañunaynita yuyarishpayni shunkuynipi yapa llakirini wañuhushkashina. Kankuna mana puñushpa kayllapi kipariychi. Yaya Diosta mañaychi yanapawananpa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Chasna rimashkanwasha chaynikstuma rirka, kunkurishpa kumurirka umanka allpapi tupanankama. Kumurishpa Yayan Diosta mañarka: A Yayayni, atipashpaykika kishpichiway mana sinchita parisinaynipa. Chasna tapushpaynipas ama ñukapa munashkaynita ruraychu, ashwan kanpa munashkaykillata ruray nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Chasna Yayan Diosta mañashkanwasha Jesuska chay kimsa runankunama kutirka. Puñushkakunata tarishpan Pedrota rimarka: ¿Manachu nima shuk urastuta atipashkankichi mana puñushpa ñukawa pakta Yaya Diosta mañanata? ");
INSERT INTO qupNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mana sampayashpa Yaya Diosta mañaychi supay kankunata mana uchata rurachinanpa. Kankunaka munankichi Yaya Diosta mañanata. Chasna munashpaykichipas sapallaykichika mana atipankichichu, shunkuykichipi yapa sampayashka kashpaykichi. Chayrayku Yaya Diosta mañaychi shunkuykichita sinchikuchinanpa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Chaymanta kutikashka Yayan Diosta mañak rirka: A Yayayni, parisinaynimanta mana arkanata munashpaykika kaypi kahuni munashkaykita ñukawa ruranaykipa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Chay kimsa runankunama kutishpan kutikashka tarik rirka puñurayahukkunata, paykuna yapa puñuywa kahushkankunarayku. ");
INSERT INTO qupNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Puñuhushkakunallata sakishpan Jesuska kimsaynin kuti Yayan Diosta chasnallatata mañak rirka. ");
INSERT INTO qupNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Chaymanta runankunama kutishpan paykunata rimarka: ¿Kunankamachu puñuhunkichi? Ñami paktarishka ñuka Yaya Diospa Kachashkan Runa uchasapa runakunamanta apiy tukunaynipa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Atariychi, akuychi. Ñami shamuhun chay apichichiwak runaka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús rimahushkanllapi paypa runan Judaska achka runakunata pushamushpan shamurka. Paykunaka ishkay wiluyu sablikunata, kaspikunatapas apamushpankuna Jesusta apik shamurkakuna. Paykuna saserdotekunapa apunkunamanta, ñukanchita kamachik israel masinchi rukukunamanta kamachirishka karkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judaska chay runakunata pusharka alita yachachishpa: Maykan runatami muchasha, chaymi kanka Jesuska. Payta apishpa pushankichi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Chaypina Jesusta kayllayashpan rimarka: Yachachik, shamushkanimi saludanaynipa kanta nishpa payta mucharka. ");
INSERT INTO qupNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Muchashpanna Jesuska rimarka: Amigu, apichiwanayashpaykika apichiway nishpa. Chaypina chay runakunaka Jesusta apirkakuna pushanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Chayta rikushpan Jesuspa shuk runan sablinta apishpan saserdotekunapa atun apupa shuk runanta sumakta pitishpa wañuchisha nishpa pitihushpan rinkrinllata pitirka. ");
INSERT INTO qupNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Chasna pitishpan Jesuska rimarka: Wakaychay sablikita. Sabliwa makanakuk runakunaka sabliwallatatami wañunankuna tiyan. ");
INSERT INTO qupNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Manachu yachanki Yayayni Diosta tapushpaynika payka chunka ishkay waranka angelkunata kachamuma arkawanankunapa? ");
INSERT INTO qupNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Chasna arkawanahumaka ¿imashnataya paktarima ñawpa Yaya Diospa killkachishkanka ñuka wañunaynimanta? Manami paktarimachu. Chayrayku Yaya Diosta mana tapunayanichu arkawananpa wañuymanta. ");
INSERT INTO qupNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Chaywasha chay apik runakunatana Jesuska rimarka: ¿Imaraykutaya sablikunawa kaspikunawapas shamushkankichi apiwanaykichipa? ¿Wañuchik shuwa runachu kani? Tukuy puncha Yaya Diospa wasinpi kankunawa pakta kahushpayni yachachirkani. ¿Imaraykuta mana chaypi apiwarkankichichu? ");
INSERT INTO qupNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Yaya Diospa yachayninwa yachachikkuna ñawpa killkarkakuna kasna apiwanaykichita. Chay killkashkankunapi rimashkankunashina, shutipata kunanka apiwahunkichi wañuchichiwanaykichipa nishpa. Chaypina tukuy ñukanchi paypa runankuna yapa mancharishpanchi Jesusta sapallanta sakishpa mitikurkanchi. ");
INSERT INTO qupNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Chay apik runakunaka Jesusta saserdotekunapa atun apu Kaifaspa wasinma pusharkakuna. Paypa wasinpi Moisespa killkashkanta yachachikkuna, ñukanchita kamachik israel masinchi rukukunawa pakta tantarishka kahurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Jesusta pushashpankuna Pedroka karullapi katishpan chay atun apupa wasin pampan kincharishkapi yaykurka. Yaya Diospa wasinta kuyrakkunapas chay pampapi tiyahlla kahurkakuna. Pedroka paykunapa kuchunpi tiyarik rirka, rikunayashpan imatashi Jesusta rurankakuna nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Chay wasi ukupi saserdotekunapa apunkuna tukuy paykunawa pakta tantaylla yuyarishpa kamachik masinkuna chiknik runakunata maskarkakuna llullashpa millaypata Jesusmanta rimanankunapa. Yapa munarkakuna Jesusta wañuchinata. ");
INSERT INTO qupNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Chaypina achka runakuna llullashpa millaypata Jesusmanta rimashpankunapas karan shuk chikanta rimashpan nima imata tarirkakunachu Jesusta atipanankunapa wañuchinata. Chaywashana ishkay runakuna paktamushpankuna chasnallatata yanka millaypata Jesusmanta rimarkakuna: ");
INSERT INTO qupNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Kay Jesusmi rimarka: Ñuka Yaya Diospa atun wasinta urmachishpayni kimsa punchapi atipani kutikashka ruranata nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Chasna rimashpankuna Kaifaska shayarishpan Jesusta tapurka: ¿Manachu nima imata ayninki? ¿Manachu uyanki kanta uchachishpa rimahushkankunata? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Chaypina Jesuska chunlla uyarka. Nima imata aynishpan chay saserdotekunapa atun apuka kutikashka rimarka: Silupi kawsak Yaya Diospa shutinpi kanta rimani, mana llullashpa rimay ¿kanchu kanki chapahushkanchi Yaya Diospa Kachanan Kishpichik, Yaya Diospa Wawan? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Chaypina Jesuska aynirka: Ari, shutipami rimanki. Kunan ñukapas kankunata rimani, ñuka Yaya Diospa Kachashkan Runata rikuwankichi tukuyta atipak Yayayni Diospa kuskan partipi tiyahushkaynita. Chasnallatata rikuwankichi puyu awapi kutikashka shamuhushkaynita nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Chaypina chay saserdotekunapa atun apu Kaifaska yapa piñarishpan pay kikinpa kamisan awapi churarishkanta likirka kasna nishpa: Kay runapa chasna rimashkanka Yaya Diostami yapa piñachihun. Manana ashwan payta uchachik runakunata maskashunchinachu. Tukuy kankunami uyashkankichi paypa piñachinan shimikunata. ");
INSERT INTO qupNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Imatata yuyarinkichi? nishpa. Chay kamachik masinkuna aynirkakuna: Uchayumi, wañunan tiyan nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Chaypina Jesusta chiknishpankuna uyanpi tyukarkakuna sakmarkakuna. Shukkunaka kaspiwa payta waktarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Asichishpankuna rimarkakuna: Kan Yaya Diospa Kachashkan Kishpichik kashpaykika rimay pimi kanta waktashka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Chay wasi ukupi Jesusta asichihushkankunapi Pedroka chay wasi pampan kincharishkapi tiyahurka. Chaypi shuk atun aputa yanapak warmi kayllayashpan rimarka: Kanpas Galileamanta Jesuswa pakta purik kanki nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Chasna rimashpan Pedroka tukuy chay runakuna uyashkankunapi aynirka: Manami yachanichu pimantami rimawahunki nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Chaymanta Pedroka chay wasi punkuma rirka. Chaypi shuk yanapak warmi payta rikuhushpan shukkunata rimarka: Kay runaka Nasaretmanta Jesuswa purikmi karka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Chaypina Pedroka kutikashka llullashpa Yaya Diospa shutinpi rimarka: Ñukaka manami riksinichu chay runata nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Shuk ratumanta chaypi kahuk runakuna Pedrota kayllayashpankuna rimarkakuna: Shutipami kanpas chay runawa purik kanki. Galilea runakunashina chikannayak shimita rimahushkaykirayku riksinchi kanpas Jesusta katik kashkaykita nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Chasna rimashpankuna Pedroka sinchita rimarka: Yaya Dios kastigawachun mana shutipata rimashpayni. Manami riksinichu chay runata nishpa. Chasna rimahushkanllapi atallpaka kantarka. ");
INSERT INTO qupNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Chayta uyashpan Pedroka yuyarirka Jesuspa rimashkanta, manarapas atallpa kantahushpanra kimsa kuti rimanki mana riksiwanaykita nishpa. Chayta yuyarishpan Pedroka kanchama llukshishpan yapa llakirishpa sinchita wakarka. ");
INSERT INTO qupNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Chaymanta ña pakarishpan tukuy saserdotekunapa apunkuna, tukuy ñukanchita kamachik israel masinchi rukukunawa shuk yuyayllawa kwintarkakuna Jesusta wañuchinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Chaypina Jesusta watashpankuna pusharkakuna chay romano apu Pilatoma. ");
INSERT INTO qupNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jesusta wañuchichinankunapa pushahushkankunata Judaska rikushpan yuyarirka payta apichichishpan mana alita rurashkanta. Chayrayku llakirishpan Jesusta apinankunapa riksichishkanmanta apishkan kullkita kutichik rirka. Chay saserdotekunapa apunkunata, ñukanchita kamachik israel masinchi rukukunatapas rimarka: ");
INSERT INTO qupNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Mana alitachu rurashkani, chay mana uchayu runata kullkita apinayniranti kankunata riksichishkani wañuchinaykichipa. Paykunaka aynirkakuna: Chayka kanpa uchaykimi. Ñukanchirayku mana imananchu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Chasna rimashkankunata uyashpan Judaska chay kullkita Yaya Diospa wasinpi wichurka. Chaymanta llukshishpan kaspipi sikashpan shuk waskawa kunkanpi watarishpan saltashpan wañurka. ");
INSERT INTO qupNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Chay saserdotekunapa apunkuna chay wichushka kullkita apishpankuna rimarkakuna: Kay kullkika shuk runata wañuchinapa apichishkanrayku apishka kullkimi. Chayrayku mana alichu churananchipa ofrendapi. ");
INSERT INTO qupNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ashwan ali kama kay kullkiwa shuk uchilla urku allpata rantinanchipa, shuk allpakunamanta runakuna wañushpankuna uchkuta rurachishpanchi chaypi churashpa tapanankunapa. Chasna paykunapura kwintashpankuna mankakunata rurak runapa allpanta rantirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Chay kullkiwa rantishkankunarayku kunankama chay allpapa shutinka kiparishka Yawar Allpa. ");
INSERT INTO qupNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Chasna ñawpa Yaya Diospa yachayninwa yachachik Jeremiaspa kasna rimashkanka paktarirka: Israel masinikuna kimsa chunka kullkillata chay runata chanichishpankuna apinankunapa kurkakuna. Chay kullkita kuti apishpa mankakunata rurak runamanta allpata rantirkakuna Yaya Dios kamachishkanshina nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Chaymanta Jesusta pusharkakuna romano apu Pilatoma. Chaypi payka Jesusta tapurka: ¿Shutipachu kanki israel masikikunapa Atun Apu? nishpa. Chasna tapushpan Jesuska aynirka: Ari, shutipami rimanki. ");
INSERT INTO qupNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Chay saserdotekunapa apunkuna, ñukanchita kamachik israel masinchi rukukuna achka millaypakunata paymanta rimahushkankunapi Jesuska chunllalla uyarayarka. ");
INSERT INTO qupNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Chayrayku Pilatoka Jesusta tapurka: ¿Manachu uyanki tukuy kay runakuna kanmanta millaypata rimahushkankunata? ");
INSERT INTO qupNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesuska nima imata aynirkachu. Chayrayku Pilatoka ¿imaraykushi mana apirishka runashina ayninchu kishpinanpa? nishpa yuyarishpan mana yacharkachu imatami ruranka. ");
INSERT INTO qupNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Karan wata Paskua punchakuna romano apu Pilatoka kacharipayarka shuk runata karselpi kahukta. Ñukanchi israel runakunata tapupayarka akllananchipa, maykan runatami kacharinka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Chay uras karselpi karka shuk runa Barrabás shutiyu. Tukuy yacharkakuna yapa millaypata rurak runa kashkanta. ");
INSERT INTO qupNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Chaypina Pilatoka chay achka tantarishka runakunata tapurka: ¿Maykan runatata munankichi kacharichinaynipa? ¿Barrabastachu kacharichisha? ¿Kay Yaya Diospa Kachashkan Kishpichik nishkankuna Jesustachu kacharichisha? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Apu Pilatoka alita yacharka, Jesusta chiknishpankuna yankamanta wañuchichinayashkankunata. Chayrayku chasna tapurka. ");
INSERT INTO qupNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Apu Pilatoka kamachinan tiyarinanpi tiyahushkanpi paypa warmin kacharka shuk runanta rimak rinanpa: Ama nima imata ruraychu chay mana uchayu runata. Kayna tutapi paymanta manchaypata muskushkani nishpa. Chayrayku Pilatoka mana munarkachu payta wañuchichinata. ");
INSERT INTO qupNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Chasna kashpanpas saserdotekunapa apunkunaka, ñukanchita kamachik israel masinchi rukukunapas chay achka tantarishka runakunata yuyachishpa rimarkakuna: Pilatota rimaychi Barrabasta kacharinanpa, Jesustana wañuchichinanpa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Chaypina apu Pilatoka kutikashka tapurka: ¿Pitata munankichi kacharichinaynipa? nishpa. Chay tantarishka runakunaka kaparirkakuna: ¡Barrabasta kacharichiy! nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Apu Pilatoka paykunata tapurka: ¿Imatata rurasha kay Jesuswa, Yaya Diospa Kachashkan Kishpichik nishkankunawa? Chasna tapushpan tukuy runakuna kaparishpa aynirkakuna: ¡Kruspi klabashpa wañuchichiy! ");
INSERT INTO qupNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Apu Pilatoka paykunata rimarka: ¿Ima millaypatataya rurashka? Chaypi paykunaka kutikashka ashwan sinchita kaparirkakuna: ¡Kruspi klabashpa wañuchichiy! ");
INSERT INTO qupNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Chay runakuna yapa piñarishpa kaparishpankuna Pilatoka nima imapi atipashpan chunllayachinata, yakuta apamunankunapa kamachirka. Chay yakuwa makinta mayllarka tukuy runakunapa rikushkanpi. Chaypi paykunata rimarka: Ñukaka makinita mayllani yachanaykichipa kay runa wañushpanka mana uchayu kanaynita, kankunami uchayu kankichi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Chasna rimashpan tukuy chay runakunaka aynirkakuna: Chay runa mana uchayu kashpan yanka wañuchiy tukushpanka Yaya Dios ñukanchita tukuy wawanchikunawa pakta kastigachun nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Chaypina Pilatoka Barrabasta kacharichirka. Jesustana kara waskawa asutichirka yawarnin llukshinankama. Chaywasha kamachirka shuk kruspi klabashpa wañuchinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Chaypina suntalukunaka Jesusta pusharkakuna apu Pilatopa wasinma. Chaypi tukuy suntalu masinkunata tantachirkakuna, Jesusta asichinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Jesusta llatanachishpankuna kamachik atun apupa puka churarinatashina churachirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Kashamanta llawtuta rurashpankuna atun apupa tawasampatashina umanpi churarkakuna. Kuska makinpi apichirkakuna shuk barata. Payta asichishpankuna pukllachishpa puntanpi kunkurirkakuna kasna nishpa: ¿Shamushkankichu israel runakunapa atun apu? ");
INSERT INTO qupNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Payta tyukashpankuna chay kushkankuna barata apishpa umanpi waktarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Chasna pukllachishkankunawasha chay puka churarinata llatanachishpankuna pay kikinpa churarinantana churachirkakuna. Chaymanta payta pusharkakuna shuk kruspi klabashpa wañuchinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Jesusta pushahushkankunapi kruspi klabashpa wañuchinankunapa, shuk runa Simón shutiyuta tinkurkakuna. Chay Simonka karka Sirene llaktamanta. Suntalukunaka payta kamachirkakuna Jesuspa krusninta markananpa. ");
INSERT INTO qupNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Rishpankuna chay Gólgota lumapi paktarkakuna. Gólgota ninayan wañushkapa uman luma. ");
INSERT INTO qupNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Chaypina suntalukunaka Jesusta upyachinayarkakuna aya wikiwa chapurishka vinuta. Jesuska chayta kamashpan mana upyanayarkachu. ");
INSERT INTO qupNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Chaypina suntalukunaka Jesusta kruspi klabarkakuna. Chaywasha Jesuspa churarinankunata chawpinakunankunapa swirtinkunata kamarkakuna pishi apanka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Chaywasha tiyarirkakuna chayllapi Jesusta kuyranankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jesuspa uman awapi shuk killkarishkata ratarkakuna tukuy runakuna yachanankunapa imaraykumi wañuchishkakuna nishpa. Chay killkarishkapi rimarka: Kay Jesuska israel runakunapa atun apumi kan nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jesusta wañuchihushkankuna uras ishkay wañuchik shuwakunatapas karan shukta shuk kruspi klabarkakuna chaypi wañunankunapa, shukta kuskan parti, shukta llukin parti. ");
INSERT INTO qupNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Achka runakuna Jesusta rikuk rirkakuna. Paykuna mana kirishpankuna Yaya Diospa Wawan kananta, umankunata kuyuchishpankuna payta asichirkakuna: ");
INSERT INTO qupNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Kanmi rimashkanki Yaya Diospa atun wasinta urmachishpayki kimsa punchapi kutikashka ruranaykita. Kunanka kan kikinta kishpichiriy. Shutipa Yaya Diospa Wawan kashpaykika chay krusmanta uraykumuy nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Chasnallatata saserdotekunapa apunkuna, Moisespa killkashkanta yachachikkunapas, ñukanchita kamachik israel masinchi rukukunapas payta asichishpa rimarkakuna paykunapura: ");
INSERT INTO qupNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Payka achka runakunata kishpichishka. Kunanka pay kikinta mana atipanchu kishpichirinata. Ñukanchi israel runakunapa atun apunchi kashpanka kay krusmanta uraykumuchun. Chaypira kirishunchi payta. ");
INSERT INTO qupNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Payka rimarkami Yaya Diospa Wawan kananta. Rimarka Yaya Dios payta tukuy imapi yanapananta. Yaya Dios shutipa payta yuyashpanka kunalla chay krusmanta uraykuchichun. ");
INSERT INTO qupNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Chasna asichishpankuna chay ishkay kruskunapi klabarishka wañuchik shuwakunapas Jesusta asichirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Jesús kruspi klabarishka kahushkanpi chawpi punchamanta pacha kimsa urakama amsayarka. ");
INSERT INTO qupNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Chay urasllatata Jesuska sinchita kaparishpa rimarka arameo shimipi: Elí, Elí, lema sabaktani nishpa. Chay rimashkanka ninayan: Yayayni Dios, Yayayni Dios, ¿imaraykutaya sapallaynita sakiwashkanki? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Chasna kaparishkanta uyashpankuna chaypi kahukkunaka rimarkakuna: Kay runaka Eliastami kayahun, chay ñawpa Yaya Diospa yachayninwa yachachikta nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Chaypina shuk runa kallpashpa rirka utkuta apak rinanpa. Chayta shuk suni kaspi puntapi watashpan agru vinupi ukuchishpan Jesuspa shiminpi tupachirka, tsunkashpan upyananpa. ");
INSERT INTO qupNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Shukkuna asichishpa rimarkakuna: Aku rikushunchi, shutipachu Eliaska shamunka payta kishpichinanpa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Chaypina kutikashka Jesuska sinchita kaparirka. Chasna kaparishpa wañurka. ");
INSERT INTO qupNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jesús wañushkan uraslla Yaya Diospa wasin ukupi Yaya Dioswa tinkunakuna kwartuta arkak rakta llachapaka awamanta pacha pitikta likirirka. Allpaka sinchita kuyurirka. Atun rumisapa urkukunapas partirirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Wañushkakunapa taparishkan uchkukunaka paskarirkakuna. Achka Yaya Diosta kirik wañushka runakunaka kawsarirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jesús kawsarishkanwasha chay kawsarishka runakunaka Jerusalén llaktapi yaykurkakuna. Chaypi achka runakuna paykunata rikurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Allpa sinchita kuyurihushpan tukuy manchaypakunata rikushpankuna kapitanka Jesusta kuyrak suntalunkunawa pakta yapa mancharirkakuna: Shutipami kay runaka Yaya Diospa Wawan kashka nishpa rimarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Jesús kruspi klabarishka kashpan Galileamanta pacha payta katishpa yanapak warmikuna karumantalla rikurayarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Chay rikuk warmikuna achka karkakuna. Paykunamanta shuk karka Magdalamanta Maria. Shuk karka Santiagopa Josepa maman Maria shutiyu. Shuk karka Sebedeopa wawankunapa maman. ");
INSERT INTO qupNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Chaymanta tutayahushpanna shuk achka kullkiyu runa José shutiyu Jesús kruspi wañushkanpi paktamurka. Chay Joseka karka Arimatea llaktamanta. Paypas Jesusta katikmi karka. ");
INSERT INTO qupNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Jesús wañushkanta rikushpan Joseka Pilatota tapuk rirka Jesuspa aychanta urku uchkupi churashpa tapak rinanpa. Chasna tapushpan Pilatoka suntalunkunata kamachirka kunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Chaypina Joseka Jesuspa aychanta shuk mushu yura llachapawa wankurka. ");
INSERT INTO qupNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Alita wankushpan aparkakuna shuk mushu allarishka urku uchkupi churashpa tapanankunapa. Chay urku uchkuta Joseka rurachirka pay kikinpa rantishkan allpapi. Jesuspa aychanta chay uchkupi churashkankunawasha atun rumiwa sumakta taparkakuna. Chaypi sakirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Chay uchku taparishka kuchupi Magdalamanta Maria shuk Mariawa pakta tiyarishpa rikurayarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kayantima ñukanchi israel runakunapa samananchi puncha karka. Chay puncha saserdotekunapa apunkuna, fariseokunawa pakta Pilatota rikuk rirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Chaypina payta rimarkakuna: Apu, ñukanchi yuyarinchi chay llullachik runapa rimashkanta. Payka kawsa kashpanra rimarka: Wañushkayniwasha kimsa punchamanta kawsarisha nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Chayrayku kanta tapunchi, kimsa punchata suntaluykikuna Jesuspa aychanta churashkankuna uchku punkuta kuyranankunapa, paypa runankuna tutapi shamushpankuna paypa aychanta mana apanankunapa. Apashkankunawasha rimanahuma Jesuska ñami kawsarishka nishpa. Chasna llullashpankuna kutikashka tukuy runakunata ashwanta llullachinahuma nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Chaypina Pilatoka paykunata aynirka: Chaykaya suntalukunaka. Pushaychi. Chay wañushkapa aychan churarishka uchku punkuta alita kuyraychi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Chaypina chay apunchikunaka suntalukunawa pakta rirkakuna punkarawa sumakta ratachinankunapa chay uchku punkupa rumiwa taparishkata, nima pi anchuchinanpa. Chaypi suntalukunata sakirkakuna alita kuyranankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Chaymanta samana puncha kayantima pakarihushpan Magdalamanta Maria shuk Mariawa pakta chay wañushkapa aychan churarishkata rikuk rirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Chay warmikuna rihushkankunapi kunkaymanta sinchi allpa kuyuy tiyarka, Yaya Diospa angel silumanta uraykumushpan chay uchku punkuta tapak rumita anchuchishkanrayku. Anchuchishpanna awanpi tiyarirka. ");
INSERT INTO qupNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Chay angelka chuyahlla ilampashina rikurirka. Tukuy churarinan karka suma yura, ñawinchita rantipak chuya. ");
INSERT INTO qupNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Chay angelta rikushpankuna chay kuyrak suntalukuna yapa mancharishpankuna chukchurishpa wañushkashina urmarkakuna allpama. ");
INSERT INTO qupNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Chaypina chay warmikuna paktashpankuna chay angelka rimarka: Ama manchariychichu. Yachani shamushkaykichita maskanapa kruspi klabarishka Jesusta. ");
INSERT INTO qupNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kruspi wañushpanpas ñami kawsarishka rimashkanshina. Rikuk shamuychi maypimi churarkakuna. Payka manami kaypinachu, ñami llukshishka. ");
INSERT INTO qupNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Rikushkaykichiwasha utkalla rimak riychi paypa runankunata: Yaya Jesús ña kawsarishka. Galilea allpama manara rishpaykichira payra rinka. Kankunapas riychi. Chaypimi payta rikunkichi nishpa. Chayllatami kankunata rimani. ");
INSERT INTO qupNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Chaypina chay ishkay warmikunaka mancharishpankunapas yapa kushikurkakuna. Kushikushpa kallparkakuna Jesuspa runankunata rimanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Rihushkankunapi Jesuska paykunata rikurishpan saludarka. Paykunaka kayllayashpankuna kumurishpa chakinta ukllarishpankuna payta yapa kushichirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Chaypina Jesuska paykunata rimarka: Ama manchariychichu. Kunalla rimak riychi wawkinikunata Galilea allpapi llaktakunama rinankunapa. Chaypimi rikuwankakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Chaymanta chay warmikuna Jerusalén llaktama rihushpankuna chay kuyrak suntalukunapas chay llaktallapitata paktarkakuna. Paykunaka saserdotekunapa apunkunata kwintarkakuna tukuy pasashkakunata. ");
INSERT INTO qupNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Chaypina chay apunkunaka ñukanchita kamachik israel masinchi rukukunapas tantarishpankuna kwintarkakuna imatami rurankakuna nishpa. Kwintashkankunawasha chay suntalukunata achka kullkita pagarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Pagashpa rimarkakuna: Kankuna tukuy maykantapas rimanaykichi tiyan: Tutapi puñuhushpanchi Jesuspa runankuna aychanta apashkakuna nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Chayta apu Pilatoka yachashpan kankunata kastiganayashpanka ñukanchi rimashu kankunata mana kastigananpa. ");
INSERT INTO qupNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Chay suntalukunaka llullanankunapa ari nishpankuna achka kullkita apirkakuna. Chaymanta chay llullata rimashpankuna mirachishpa mirachishpa tukuy israel masinchikuna yacharkakuna. Kunan punchakama Jesuspa runankuna aychanta apashkakuna nishpa rimashkakunata uyanchi. ");
INSERT INTO qupNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Chaymanta chay chunka shuk runankuna Galilea allpama rirkakuna, Jesús rimashkan urkuma. ");
INSERT INTO qupNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Chaypi paktashpankuna Jesusta rikurkakuna. Payta rikushpankuna puntanpi kunkurishpa kushichirkakuna. Shukkunaka yuyayninkunapi rimarkakuna paychari manachu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Chaypina Jesuska paykunata kayllayashpan rimarka: Yaya Dios churawashka kay allpapi silupipas shuklla kamachik kanaynipa. ");
INSERT INTO qupNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Chayrayku tukuy kay allpapi kawsak runakunata yachachik riychi paykunapas ñukata katikkuna tukunankunapa. Chay ñukata katiwak runakunata bawtisaychi runakunata rikuchinankunapa Yaya Diosta, ñuka Wawanta, Yaya Diospa Espiritunta kasukkuna tukushkankunata. ");
INSERT INTO qupNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Chaymantapas chay kiriwak runakunata tukuy yachachishkaynikunata yachachiychi paykunapas alita kasukkuna kanankunapa. Kankunata rimani, ñukaka mana anchurishpachu tukuy puncha kankunawa kahuni kay allpa tukurinan punchakama.");
INSERT INTO qupNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ñuka Markus killkani suma ali shimita Yaya Diospa Wawan Jesukristumanta. Payka uchanchikunamanta kishpichikmi kan. ");
INSERT INTO qupNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ñawpa manara Jesukristu shamuhushpanra Yaya Diospa yachayninwa yachachik Isaiaska killkarka kasna Yaya Dios Wawanta rimashkanta: Ñukaka shuk runata kachasha runakunata shiminita rimananpa. Payka manarapas kanta kachahushpayni runakunata kanmanta rimak rinka shunkunkunata alichashpankuna alita kanta kayanankunapa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Chaymantapas Isaiaska killkarka chay yachachik runamanta: Chunlla chakishka allpapi shuk runa sinchita rimashpa yachachinka kasna: Imashnami shuk anchu ñampita alichanchi, atun apu shamuhushpan purinanpa, chasnashina shunkuykichita alichariychi. Millaypata rurashpa kawsashkaykichita sakiychi. Yaya Diospa Kachanan Kishpichik kankunapi kawsak shamunka nishpa yachachinka. Tukuy chayta killkarka Isaiaska Yaya Diospa rimashkanta. ");
INSERT INTO qupNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Imashnami Isaiaska killkarka ñawpa, chasnashinami kunan Yaya Dioska kachashka shuk yachachik Juan shutiyuta. Chay yachachikka chunlla chakishka allpapi yachachirka runakunata: Kunanmanta pacha tukuy millaypa rurashkaykichitaka amirishpa sakiychi. Yaya Diospa rimashkanta kasushpana kawsaychi. Chasna rurahushkaykichita rikuchishpa bawtisariychi. Chaypina Yaya Dioska kankunata uchaykichimanta llakichinkami. ");
INSERT INTO qupNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tukuy Judea allpa llaktakunamanta Jerusalén llaktamantapas achka runakuna shamurkakuna Juanpa yachachishkanta uyanankunapa. Chasna uyashpankuna musyarirkakuna uchayu kashkankunata. Chaypina tukuy uchankunata rimashpankuna Juanka paykunata bawtisarka chay Jordán yakupi. ");
INSERT INTO qupNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juanka mana suma churarishkachu karka. Shuk pukripa churarinanshina, imashnami ñawpa Yaya Diospa yachayninwa yachachik Eliaspas churaripayarka, chasnallatatami Juanpa churarinanpas wiwa kamillupa willman puchkashkawa awarishka karka. Sinturunka karamantami karka. Mana mikupayarkachu ñukanchishina. Mikupayarka chaypi kawsak chilikkunata, upyapayarka mapa mishkita. ");
INSERT INTO qupNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yachachipayarka runakunata: Ñukamanta ashwan yachayyu runami shamunka. Paymantaka ñukaka mana yapa yachayyuchu kani. Paypa puntanpi nima imata atipanichu rimanata. ");
INSERT INTO qupNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ñukaka yakuwami kankunata bawtisashkani. Payka kankunata Yaya Diospa Espiritunta kushpami shunkuykichita aliyachinka. ");
INSERT INTO qupNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Chaymanta Jesuska Galilea allpapi kahuk Nasaret llaktamanta llukshishpan Jordán yakuma rirka. Chay yakupi Juanka Jesusta bawtisarka. ");
INSERT INTO qupNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yakumanta llukshihushpan Jesuska rikurka siluka paskarihushkanta, chaymantapas Yaya Diospa Espiritunka shuk wiwa mukukushina paypi uraykumuhushkanta. ");
INSERT INTO qupNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Chasnallapi Yaya Dioska silumanta rimarka: Kanmi kanki munashkayni Wawayni. Kanmi sumakta kushichiwanki nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jesuska bawtisarishkanwasha Yaya Diospa Espiritunka payta pusharka chunlla chakishka allpama. ");
INSERT INTO qupNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Chay allpapi Jesuska chusku chunka punchata sapallan karka. Chaypi supaykunapa apunka payta llullachinayashpa karka. Chaypi achka manchaypa animalkuna chawpipi kahurka. Yaya Diospa angelkunaka payta kuyrashpa karkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Apu Herodeska Juanta karselpi churashkanwasha Jesuska kutirka Galilea allpapi llaktakunama Yaya Diospa suma ali shiminta yachachinanpa. ");
INSERT INTO qupNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Chaypi rimarka: Ñami paktarishka Yaya Diospa rimashkan timpuka. Ñami kallarihun paypa ali kamachinanka kay allpapi. Chayrayku alita yuyarishpaykichi tukuy millaypa rurashkaykichita sakiychi. Yaya Diospa suma ali shimintana kasushpa kawsaychi. ");
INSERT INTO qupNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesuska Galilea kucha mayanpi rihushpan rikurka Simonta wawkin Andreswa kahushkata. Paykuna challwakunata apihurkakuna redinkunawa. ");
INSERT INTO qupNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Chaypi Jesuska paykunata kayarka: Shamuychi. Katiwaychi. Ñuka kankunata yachachisha. Imashnami challwata apishpa kawsashkankichi, chasnashinami kunanmanta pacha runakunatana yachachishpa purinkichi paykunapas Yaya Diospa wawankuna tukunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Chay ratulla redinkunata sakishpankuna Jesustana katirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Chaymanta astalla chay kucha mayanta rihushpankuna Jesuska rikurka Sebedeopa wawankunata Santiagota wawkin Juantapas, botinkunapi redinkunata rimintahukkunata. ");
INSERT INTO qupNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Paykunatapas katiwaychi nirka Jesuska. Chaypina atarishpankuna yayan Sebedeota, yanapakkunatapas sakimurkakuna Jesuswa pakta purishpa kawsanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Chaymanta Jesuska chay chusku runankunawa chay Galilea kucha mayanpi kahuk Kapernaum llaktapi paktarkakuna. Samana puncha yaykurkakuna israel masinchikunapa tantarina wasipi, maypimi tantarishka kahurkakuna Yaya Diospa shiminta yachakunankunapa. Chaypina Jesuska paykunata yachachirka. ");
INSERT INTO qupNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Chay runakunaka yachachishkanta uyashpankuna mancharishpa rimarkakuna paykunapura: Kay Jesuska Yaya Diospa yachayninwami yachachin. Tukuy kay Moisespa killkashkanta yachachikkunamanta yapa alitami ñukanchikunata yachachin. ");
INSERT INTO qupNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Chay tantarina wasipi kahuk runakuna chawpipi shuk supay yaykushka runa tiyarka. Chay runaka Jesusta uyashpan sinchita kaparirka: ");
INSERT INTO qupNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","¡Jesús, Nasaret llaktamanta runa, ama ñukanchita kayllayaychu! ¿Shamushkankichu ñukanchita wichunaykipa ninapi wiñaypa parisinanchipa? Ñuka riksini kanta Yaya Diosmanta shamushka runa kanaykita nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesuska chay runapi kawsak supayta sinchi shimiwa piñashpa rimarka: Chunllayay. Llukshiy kay runamanta. ");
INSERT INTO qupNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Chaypina chay supayka kaparishpan chay runata sinchita chukchuchishpan sakirka. ");
INSERT INTO qupNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Chayta rikushpankuna tukuy runakunaka mancharishpankuna tapunakurkakuna: ¿Pitaya kay runaka? Atun yachayninwa shuk mushu shimita yachachin. Supaykunatapas kamachin. Kamachishpan kasunahun. ");
INSERT INTO qupNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Chay uraslla tukuy Galilea allpa llaktakunapi kawsak runakuna Jesuspa rurashkanmanta yacharkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Chay tantarina wasimanta llukshishpankuna Jesuska Santiagowa Juanwa Simonpa, Andrespa wasinma rirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Chay wasipi Simonpa warminpa maman kalinturawa unkushka sirihurka. Jesuska yaykushpan chay wasipi, ayllunkunaka rimarkakuna unkushkanmanta. ");
INSERT INTO qupNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Payka chay unkushkata kayllayarka. Makinmanta apishpan atarichirka. Chay ratulla kalinturanka pasarka. Ampirishpanna tukuy chaypi kahukkunata upyachirka kararka. ");
INSERT INTO qupNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ña inti yaykuhushkanpi runakunaka tukuy unkushkakunata, supay yaykushka runakunatapas apamurkakuna Jesusma. ");
INSERT INTO qupNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tukuy chay llaktapi kawsakkuna tantarimurkakuna chay Simonpa wasin punkupi. ");
INSERT INTO qupNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Chaypina Jesuska achka unkushkakunata ampirka chikan chikan unkuykunamanta. Chaymantapas achka supaykunata kamachirka chunllalla llukshinankunapa chay runakunamanta. Chay supaykunaka riksishpankuna Yaya Diospa Wawan kashkanta, Jesuska rimarka nima imata rimanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kayantima ña punchayahushkanpi manara inti llukshimuhushpanra Jesuska atarishpan chay llaktamanta llukshishpan chunlla kahushkama rirka Yayan Diosta mañananpa. ");
INSERT INTO qupNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Jesús chayma rishpan Simonka paywa kahukkunapas likcharishpankuna illata rikurkakuna. Chayrayku ñampikunama maskanapa rirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tarishpankuna rimarkakuna: Tukuy runakunami kanta maskahunkuna nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Chaypina Jesuska rimarka: Akuychi rishunchi shuk llaktakunama chaypipas Yaya Diospa shiminta yachachinaynipa. Chayraykumi shamushkani kay allpama chasna yachachishpa purinaynipa. ");
INSERT INTO qupNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Chaymanta Jesuska runankunawa purirka tukuy chay Galilea allpa llaktakunapi, tukuy chay israel masinchikunapa tantarina wasikunapi runakunata yachachirka. Chaymantapas achka runakunamanta supaykunata llukshichirka. ");
INSERT INTO qupNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Shuk puncha shuk aycha ismuchik unkuyyu runaka nima pita kayllayanata atipashpantata Jesusta kayllayarka. Kunkurishpan rimarka: Yachani ampinata atipawanaykita. Kanrayku ali kashpanka kay unkuynimanta ampiway, ampirishpayni kuti atipanaynipa tantaylla kawsanata aylluynikunawa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Chaypina Jesuska llakichishpan mana llankaypata makinwa llankashpan rimarka: Ari, munanimi. Ñami ampirishka kanki. ");
INSERT INTO qupNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Chay ratulla unkuyninmanta ampirishpan aychanka alina kiparirka. ");
INSERT INTO qupNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ña Jesuska sakihushpan chay ampishkan runata sumakta kunarka: ");
INSERT INTO qupNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Nima pita kwintankichu kanta ampishkaynimanta. Ashwan saserdotellama riy ampirishkaykita rikuchinaykipa. Chaymantapas Yaya Diosta kunayki kashkata apashpayki churak rinki, ñawpa Moisespa killkashkanpi kamachishkashina. Chasna rurashkaykimantami tukuy runakuna yachankakuna unkushkaykimanta ampirishkaykita nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Chasna kunashpanpas chay ampirishkaka Jesús payta ampishkanta tukuy runakunata kwintak rirka. Chayrayku Jesuska manana atiparkachu nima maykan llaktapi kunkaylla yaykunata. Chasna kashpan chay llaktakunamanta karuyarka nima pi kawsahushkama. Chasna karuyashpanpas tukuy llaktakunamanta runakunaka payma shamurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Masna punchamantalla Jesuska kutirka Kapernaum llaktama. Chaypina shuk wasipi paktashpan tukuy runakuna yacharkakuna ña chaypi kahushkanta. ");
INSERT INTO qupNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Chasna yachashpankuna achka runakuna utkalla tantarirkakuna chay Jesuspa paktashkan wasipi. Kichkikta punkumanta pacha karkakuna, nima pi atipaypa yaykunata. Chasna kahushkankunapi Jesuska Yayan Diospa shiminta yachachirka. ");
INSERT INTO qupNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Chay yachachihushkanpi chusku runakuna paktamurkakuna. Apamurkakuna llanchamapi shuk aychan chakirishka runata. ");
INSERT INTO qupNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Chay wasipi achka runakuna kichkikta kahushpankunana mana atiparkakunachu yaykunata. Chayrayku sikarkakuna iskalunta chay parihu washayu wasi awama. Chay wasi washata awamanta paskashpankuna Jesús kahushkan kuska chay unkushkata llanchamanpi uraykuchirkakuna ampinanpa payta. ");
INSERT INTO qupNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesuska paykunata rikushpan yacharka shunkunkunamanta pacha kirihushkankunata chay runata ampinanta. Chayrayku payta rimarka: Wawki, tukuy uchaykikunamanta llakichirishkami kanki. ");
INSERT INTO qupNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Chaypi tiyarka Moisespa killkashkanta yachachikkuna. Jesús chasna chay runata rimashkanta uyashpankuna shunkunkunapi piñarishpa yuyarirkakuna: ");
INSERT INTO qupNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","¿Imashnata yuyarin kay runaka rimananpa chasna? ¿Imashnata ñukanchishina runaka llakichima uchanchikunamanta? Yaya Diosllami atipan llakichinata uchanchikunamanta. Chay runaka Yaya Diosshina tukunayashpan Yaya Diosta piñachihun nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesuska chay yuyarihushkankunata yachashpan paykunata tapurka: ¿Imaraykuta chasna yuyarihunkichi? ");
INSERT INTO qupNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kay runataka rimashkanimi uchaykikunamanta llakichirishkami kanki nishpa. Chasna rimashpayni mana yachankichichu shutipa llakichishkachu manachu nishpa. Ñuka kay runata rimaynima atariy, llanchamaykita apishpayki puriy nishpa, pay alita purishpanna yachankichima ñuka payta ampishkaynita. ");
INSERT INTO qupNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Yachanaykichipa ñuka Yaya Diospa Kachashkan Runa paypa yachayninwa kay allpapi runakunata uchankunamanta llakichinaynita, kunalla kay unkushkata ampisha nishpa rimarka Jesuska. ");
INSERT INTO qupNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Chaymanta chay runata rimarka: Kunanka atariy. Llanchamaykita apishpayki kutiy wasikima. ");
INSERT INTO qupNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Chaypina chay runaka utkalla atarimushpan llanchamanta apishpan llukshimurka chay wasimanta. Tukuy chay runakunaka rikushpankuna kushikushpa rimarkakuna: Yaya Dios, suma ali yachakmi kanki. Nima ima uras chasna rurashkaykita rikushkanchichu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Chaymanta Jesuska kutikashka rirka chay Galilea kucha mayanma. Chaypi achka runakuna payta kayllayashpankuna paykunata yachachirka. ");
INSERT INTO qupNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Yachachishkanwasha chay kucha mayanta rihushpanna rikurka Alfeopa wawan Leví shutiyuta. Chay Levika ñukanchi israel masinkunata impuestuta kobrapayarka chay romano tukuymanta atun apurayku. Jesuska Levita kobranan wasipi tiyahushkanta rikushpan rimarka: Leví shamuy, katiway. Chay ratulla Levika atarishpan Jesusta katirka. ");
INSERT INTO qupNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Achka runakuna Leviwa tantaylla Jesusta katirkakuna. Chaymanta Levika kayarka Jesusta runankunawa pakta paypa wasinpi mikunankunapa. Mikuhushpankuna achka impuestuta kobrakkuna, shuk mana ali rurak runakunapas paykunawa tantaylla chay wasillapi mikuhurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Moisespa killkashkanta yachachikkuna, fariseokunapas Jesusta rikushpankuna chay mana ali rurak runakunawa tantaylla mikuhukta, washancharkakuna. Chaypi Jesuspa runankunata tapurkakuna: ¿Imaraykutaya kankunata yachachikka mikun tantaylla impuestuta kobrakkunawa, paykunashina mana ali rurak runakunawapas? ");
INSERT INTO qupNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Chay rimahushkankunata uyashpan Jesuska rimarka: Alikunaka mana munanahunchu ampikta. Ashwan unkushkakunami ampikta munanahun ampirinankunapa. Chasnallatata ñukaka mana shamushkanichu yanapanaynipa maykanmi mana uchayuchu kani nishpa riman. Ashwan shamushkanimi uchayukunata yanapanaynipa Yaya Diostana kasunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Shuk punchakuna Juanpa runankuna, fariseokunapa runankunapas mana mikupayanahunchu Yaya Diosta mañanankunapa. Chaymanta shuk runakuna Jesusta kayllayashpankuna tapurkakuna: Juanpa runankuna, fariseokunapa runankunapas shuk punchakuna mana mikunahunchu. ¿Imaraykutaya runaykikunaka mana sakinahunchu mikunata nima shuk puncha? ");
INSERT INTO qupNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesuska paykunata aynirka: Shuk musuka warmiyahushpanka kayan tukuy ayllunkunata kushilla tantarishpa mikunankunapa mushu warmiyahushkawa. Chasna chay warmiyahuk runawa kushilla tantarihushkankunapi nima pi atipanchu mana mikushpa kanata. ");
INSERT INTO qupNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Chay mushu warmiyahuktami kuntrankuna anchuchishpankuna chay urasmi mana mikushpa llakirinkakuna nishpa. Chasna Jesuska rimarka pay kikin chay mushu warmiyahushkashina kashkanta yuyachishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","22","Chaymanta kutikashka Jesuska yachachirka: Nima maykan rimintamachu mawka kamisanta shuk mushu kintiyak llachapawa. Maykanchari chasna mushu llachapawa rimintashpanka taksashpa kintiyashpan ashwan atunta likiripuma. Chasnallatatami mushu vinu putskurihushkataka mana untachinchimachu shuk mawka karamanta rurarishka bulsapi wakaychanapa. Chasna vinu shuk mawka karamanta bulsapi untachishpanchika karata tukyachishpan talirin. Chayrayku mushu vinu putskurihushkata mushu karamanta bulsapi untachinanchi tiyan, nima kara likirinanpa, nima vinu talirishpa usunanpa. Imashnami mana churanchimachu shuk mushu llachapata shuk mawka churarinapi, nima mushu vinuta mawka karapi churanchimachu, chasnashinami mana atipankichichu katinata ñawpa yaya rukunchikuna yachachishkankunata, ñukapa mushu yachachihushkaynitapas. Chasna ishkantita katinayahushpaykichika mana atipankichichu katinata nima maykanta. ");
INSERT INTO qupNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Shuk samana punchapi Jesuska runankunawa pakta trigu tarpukuna chawpita rihurkakuna. Chay chakrakunapi rihushpankuna runankunaka shuk shuk trigu muyukunata chipi chipi pakishpa pallarkakuna mikunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Chaypina shuk fariseokunaka Jesusta rimarkakuna: Rikuy runaykikuna samana punchapi rurahushkankunata. ¿Manachu yachankichi Yaya Diospa killkachishkanpi kamachishkanta samana punchapika mana tarawananchipa? ");
INSERT INTO qupNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Jesuska aynirka: ¿Manachu leyishkankichi chay ñawpa yaya rukunchi atun apu Davidmanta? Chay uras Abyatar shutiyu Yaya Diospa wasinpi tarawak saserdotekunapa atun apunkuna karka. Davidka runankunawa pakta yarkashpankuna Yaya Diospa wasinpi yaykurkakuna mikunata maskanankunapa. Chaypi Davidka chay Yaya Diosta rikuchinankunapa mesapi churarishka pankunata mikurka Yaya Diosrayku rurarishkata. Chaymantapas runankunata kurka mikunankunapa. Chay pankunaka mana paykuna mikunankunapachu karka. Yaya Dios kamachirka saserdotekunalla mikunankunapa. Chasna mikushpankunapas Yaya Dioska mana uchatashina rikushpan paykunata mana kastigarkachu. ¿Imaraykuta kankunaka runaynikunata piñarishpa uchatami rurahunkichi nishpa rimahunkichi? ");
INSERT INTO qupNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Chaymanta Jesuska yachachishpalla katirka: Yaya Dios yapa yuyashpan runakunata, chay samana punchata rurarka. Payka mana yapa yuyarinchu samana punchataka, ashwan ñukanchikunata llakichishpan yuyan. Chayrayku munan samananchipa samana punchapi payta yuyarinanchipa. ");
INSERT INTO qupNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ñuka paypa Kachashkan Runa kashpayni Yaya Dios yachayninta kuwashka kankunata rimanaynipa maykankunami ali kanahun samana punchapi ruranaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Kutikashka Jesuska yaykurka shuk tantarina wasipi. Chay wasipi tiyarka shuk chakirishka makiyu runa. ");
INSERT INTO qupNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Chaypina chay chiknik runakuna rikurayarkakuna Jesuska ampinkachu manachu samana punchapika nishpankuna. Ampishpanka yuyarirkakuna rimak rinankunapa apunkunata. ");
INSERT INTO qupNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Chaypina Jesuska llakichishpan nirka chay chakirishka makiyu runata: Atariy, runakunapa chawpinkunapi shayariy. ");
INSERT INTO qupNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Chaymantana nirka chay chiknik fariseokunata: Kankunata tapuni, Yaya Diosta kasushpanchika ¿imatata ashwan ruranchima samana punchapika, alitachu, millaypatachu? ¿Alichu kama shuk unkushkata ampinanchipa samana punchapi, manapika sakinchimachu wañunanpa? Chasna Jesús rimashpan chay runakunaka chunlla uyarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Chaypina Jesuska chay runakunata piñarishpa chunlla rikurka. Chay unkushkata mana llakichihushkankunarayku atunta llakirirka. Chaypina chay unkushkata rimarka: Makikita chutachiy. Chay runaka makinta chutachishpan ampirishka kiparipurka. ");
INSERT INTO qupNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Chaymanta chay fariseokunaka chay wasimanta llukshishpankuna apu Herodesta katikkunata utkalla rimak rirkakuna Jesuspa rurashkanmanta. Chaypi tantarishpa yuyarirkakuna imashna rurashpashi Jesusta wañuchinchima nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Chaymanta Jesuska anchurimushpan runankunawa rirka Galilea kucha mayanma. Achka runakuna Galilea allpapi llaktakunamanta payta katirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Achka llaktakunapi kawsak runakuna Jesús mana atipaypa sumakunata Yaya Diospa yachayninllawa rurashkankunata yachashpankuna maskak rirkakuna payta. Chay uraypi Judea allpapi llaktakunamanta, chaypillatata kahuk Jerusalén llaktamantapas, Idumea allpamantapas achka runakuna shamurkakuna. Chay Jordán yaku chimpamanta, chay anakpi Tiro llaktamanta, Sidón llaktamantapas achka runakuna rirkakuna Jesusma. ");
INSERT INTO qupNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Chaypina Jesuska achka unkushkakunata ampishpan ashwan achka payta kayllayarkakuna. Tankanakushpa rirkakuna, payta llankashpankuna ampirinankunapa. Runakuna yapa nitirihushpankuna Jesuska runankunata kamachirka shuk botita apak rinankunapa, chaypi kishpinanpa. ");
INSERT INTO qupNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Manara chay botipi uraykuhushpan achka supay yaykushka runakuna rirkakuna payma. Puntanpi kunkurishpankuna kaparirkakuna: ¡Kanmi kanki Yaya Diospa Wawan! ");
INSERT INTO qupNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Chasna kaparishpankuna Jesuska kamachishpan rimarka: Chunllayaychi. Ama nima pita rimaychichu ñuka Yaya Diospa Wawan kanaynita. Chasna rimashpan chunllayarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Chaymanta Jesuska urkuma sikashpan tukuy chay achka runakunamanta shukkunallata kayarka paywa pakta rinankunapa. Chaypina kasushpankuna payta katirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Chay urkupi paktashpankunana Jesuska chay payta katikkunamanta akllarka chunka ishkay runakunata paywa pakta purinankunapa. Chaymantapas paykunata akllarka kachananpa Yaya Diospa shiminta yachachinankunapa. Apostolnikuna kankichi, kachanayni runakuna nishpa rimarka. ");
INSERT INTO qupNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Chaymanta paykunata rimarka Yaya Dios yanapashpan supaykunata runakunamanta llukshichinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Chay chunka ishkay akllashkankunapa shutinkunaka karkakuna: Simón, maykantami Jesuska shutiyachirka Pedro, ninayan rumi. ");
INSERT INTO qupNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Shukka Santiago, shukka karka wawkin Juan, Sebedeopa wawankuna. Kay ishkaykunataka Jesuska shutiyachirka Boanerges, chayka ninayan rayupa wawankuna, sinchita rimak runakuna, tukuy shunkunkunamanta pacha Yaya Diospa munananta utkalla rurak runakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Shukka Andrés, shukka Felipe, shukka Bartolomé, shukka Mateo, shukka Tomás, shukka Alfeopa wawan Santiago, shukka Tadeo, shukka shuk Simón, maykantami rimapayarkakuna Selote. Kay Simonka manara Jesusta katik kashpanra ñukanchita kamachik romano tukuymanta atun aputa piñarikkunawa tantarishka kapayarka. ");
INSERT INTO qupNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Shukka Judas Iskariote, maykanmi chaywasha Jesusta apichinan karka. ");
INSERT INTO qupNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Chaymanta Jesuska yaykurka shuk wasipi runankunawa pakta. Chaypipas achka runakuna tantarirkakuna. Chayrayku nima mikunata atiparkakunachu. ");
INSERT INTO qupNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Chayta yachashpankuna Jesuspa ayllunkunaka rirkakuna payta apishpa pushanankunata yuyarishpankuna. Paykunapura kwintarkakuna muspachari tukushka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Chaymantapas Moisespa killkashkanta yachachikkunaka Jerusalén llaktamanta shamushpankuna Jesusmanta rimarkakuna: Supaykunapa apun Beelsebú kamachihun kay runata. Supaykunapa apunpa yachayninwami Jesuska supaykunata kamachin runakunata sakinankunapa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Chaypina Jesuska chay paymanta mana alita rimahukkunata kayashpan yachachirka: ¿Supaykunapa apuka wichumachu aylluntaka? Nima ima uras atipamachu wichunata. ");
INSERT INTO qupNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Makanakuhushpankunaka llaktapi kawsakpura, chasnaka llampu tukurinahumami. ");
INSERT INTO qupNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Chasnallatata shuk runakuna shuk wasillapi kawsakkuna makanakuhushpankunaka paykunaka llampumi tukurinahuma. ");
INSERT INTO qupNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Chasnallatatami supaykunapas paykunapura makanakuhushpankunaka tukurinahumami. ");
INSERT INTO qupNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Rikuychi, shuk sinchi runa alita wakaychan wasinta nima pi shuwananpa imankunata. Shuk runa ashwan sinchi paymanta shamushpanka paymi atipan wasi amuta watashpan imankunata shuwanata. Chasnashinami supaykunaka kamachinahun shuk wasi amushina runakunata. Nima maykan paykunamanta kichumachu mana ashwan yachayyu kashpanka. Ñukami shamushkani Yaya Diospa yachayninwa runakunata kishpichinaynipa tukuy supaykunamanta. ");
INSERT INTO qupNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Alita uyawaychi. Yaya Dioska runakunata tukuy uchankunamanta, tukuy payta millaypata rimashkankunamantapas llakichinkami. ");
INSERT INTO qupNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Shuk runa Yaya Diospa Espiritunta chiknishpa millaypata rimashpanka chasna runataka Yaya Dioska manami llakichinkachu nima kishpichinkachu wiñayparayku. ");
INSERT INTO qupNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Chasna Jesuska paykunata rimarka paymanta rimahushkankunarayku supaykunapa apumi payta kamachihun nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesuska manara tukuchihushpan rimanata, paypa maman, wawkinkunapas paktak shamurkakuna. Achka runakuna kahushkankunarayku kanchapi kiparishpankuna shuk runata kacharkakuna Jesusta kayak rinanpa. ");
INSERT INTO qupNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jesuspa kuchunpi tiyahukkunaka payta rimarkakuna: Mamayki wawkikikunapas kanchapi chapahunkuna kanwa kwintanankunapa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Chaypi Jesuska aynirka: Mana mamaynillatachu kikin wawkinikunallatachu yuyani. ");
INSERT INTO qupNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Chaymanta kuchunpi kahukkunata rikushpan nirka: Kankunatapas yuyanimi mamayni wawkinikunatashina, Yayaynipa munashkanta rurahushkaykichirayku. ");
INSERT INTO qupNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Maykanmi ruran Yayayni Diospa munashkanta, paymi kan wawkinishina, paninishina, mamaynishina. ");
INSERT INTO qupNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Shuk puncha Jesuska rirka kutikashka yachachinanpa runakunata Galilea kucha mayanpi. Chaypi achka runakuna tantarihushpankuna Jesuska shuk boti yakupi kahukpi uraykushpan tiyarirka, chay botimanta paykunata ashwan alita yachachinanpa. ");
INSERT INTO qupNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Chaymanta Jesuska yachachirka Yayan Diospa shiminta shuk yachachinakunawa. ");
INSERT INTO qupNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Chasna yachachihushkanpi rimarka: Akuychi yuyarishunchi shuk muyukunapi. Shuk puncha shuk runa arus muyuta tarpuk rirka. ");
INSERT INTO qupNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Chaypina chay tarpukka arus muyukunata wichashpa rirka wiñanankunapa. Shuk muyukunaka urmarkakuna ñampipi. Chay ñampipi urmashkakunataka pishkukunana mikurkakuna llamputa. ");
INSERT INTO qupNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Shuk muyukunaka urmarkakuna llapcha allpa samantasapapi. Shuk ratu tukyarirkakuna chay muyukunaka. ");
INSERT INTO qupNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Chawpi puncha yapa intishpan arus wiñahukka wañurirka, mana ankunka yaykunata atipashpan samantapi. ");
INSERT INTO qupNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Shuk muyukunaka urmarkakuna kasha kiwa chawpipi. Kashawa pakta wiñahushpan chay kashaka llampu tapashpan wañuchirka chay arus wiñahukta. ");
INSERT INTO qupNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Shuk muyukunaka urmarkakuna ali allpapi. Alita wiñashpan sumakta muyuyarka. Shukkunaka muyuyarkakuna kimsa chunka muyukunata. Shukkunaka muyuyarkakuna sokta chunka muyukunata. Shukkunaka muyuyarkakuna shuk pachak muyukunata. ");
INSERT INTO qupNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kay yachachihushkaynita alita uyashpa yachakuychi. ");
INSERT INTO qupNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Chay achka runakuna kutishkankunawasha Jesuspa kuchunpi kahukkunaka chay chunka ishkay runankunawa pakta kiparishkakunaka Jesusta tapurkakuna: ¿Imatata yachachinayashkanki ñukanchita chay muyukunamanta rimashkaykiwa? ");
INSERT INTO qupNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesuska aynirka: Kankunallata Yaya Dios yachachihun nima pi yachashkanta, imashnami paypa ali kamachinanka kay allpapi. Mana payta kasunayak runakunataka mana yapa asirtaypa yachachinakunawa yachachini. ");
INSERT INTO qupNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Chay runakuna Yaya Diospa munananta mana ruranayakkunataka yachachini mana yapa asirtaypa yachachinakunallawa. Chasna yachachini ali rurashkaynikunata rikushpankunapas mana yachanankunapa imaraykumi chayta rurani. Paykunata mana alita asirtaypakunata yachachini, yachachishkaynita uyashpankunapas mana asirtanankunapa. Chaymantapas chasna yachachini manana uchankunamanta llakirishpankuna Yaya Diosta kasunankunapa, Yaya Dios paykunata mana llakichinanpa. ");
INSERT INTO qupNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Chaymanta Jesuska runankunata rimarka: ¿Shutipachu mana asirtankichi yachachishkaynita? Kay yachachishkaynita mana asirtashpaykichika imashnataya asirtankichima shuk yachachinaynikunataka. ");
INSERT INTO qupNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Yaya Diospa shiminta yachachik chay muyuta tarpuk runashinami. ");
INSERT INTO qupNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Shuk runakuna mana asirtakchu kanahun. Paykunaka chay ñampi chakishka allpapi urmashka muyukunashinami kanahun. Yaya Diospa shiminta uyanahun. Chaymanta supay shamushpan chay uyashkan shimita kunkachin. ");
INSERT INTO qupNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Shuk runakunaka kushilla uyanahun Yaya Diospa shiminta. Paykunaka chay samantasapapi wiñak muyukunashinami kanahun. ");
INSERT INTO qupNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Mana ukupi ankuyushina kashpankuna shuk ratullami Yaya Diosta kushilla katinahun. Yaya Diospa shiminta kirishkankunarayku runa masinkunaka paykunata parisichihushpankuna nanayta llakiyta musyashpankuna sakinahunna Yaya Diosta katinata. ");
INSERT INTO qupNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Shuk runakunaka kashasapapi wiñak muyukunashinami kanahun. ");
INSERT INTO qupNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Yaya Diospa shiminta munashpankunapas paykuna kikin munashkankunallata yuyarishpa kawsanahun. Chaymantapas yapa kullkillata munashpa, tukuy rikushkankunata munarishpa kawsanahun. Chasna chay tukuy yuyarinakunaka kunkachinahun Yaya Diospa shiminta wiñaypa. ");
INSERT INTO qupNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Shuk runakunana shunkunkunamanta pacha Yaya Diospa shiminta kasushpa kawsanahun. Paykunaka chay ali allpapi wiñak muyukunashinami kanahun. Chay tarpu alita muyuyakshina kashpankunami rikuchinahun ali kawsahushkankunawa Yaya Diosta mana sakishpa alita katihushkankunata. Shukkunaka shuk muyumanta kimsa chunka muyuta muyuyakshinami kanahun, shukkunaka sokta chunkata, shukkunana shuk pachakta. ");
INSERT INTO qupNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesuska paykunata lamparinmantapas yachachirka: Shuk lamparintaka apichishpa nima pi churamachu kawitu ukupi. Churanchimi kawitu awapi, lamparin tiyachinapi, alita punchayachinanpa. ");
INSERT INTO qupNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Chasnashinami Yaya Diospa shiminta yachachishkaynika puntiru pakallashina kashpanpas runakunarayku mana pakallachu kiparinka. Runakuna puntiru mana asirtashkankunata chaymanta tukuyta asirtankakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kay yachachihushkaynita alita uyashpa yachakuychi. ");
INSERT INTO qupNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Chaymanta Jesuska rimarka: Alita uyaychi kay rimanaynita. Shuk parti Yaya Diospa shiminta asirtashpaykichika chaymanta kasushpaykichika chay tupullatatami Yaya Dioska kankunata paypa shiminta ashwanta asirtachinka. ");
INSERT INTO qupNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Maykanmi Yaya Diospa shiminta uchillastuta asirtashpan kasushpa kawsan, paytami Yaya Dioska ashwanta asirtachinka. Maykanmi uchillastuta asirtashpantata mana kasushpa kawsanchu, paytami Yaya Dioska kunkachinka tukuyta manana nima imata asirtananpa. ");
INSERT INTO qupNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Chaymantapas Jesuska paykunata rimarka: Yuyariychi imashnami Yaya Diospa ali kamachinanka kay allpapi. Chakranpi muyukunata wichashpa tarpuk runata rikuychi. ");
INSERT INTO qupNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Chay muyukunata tarpushpanna sakin wiñananpa. Kutishpan wasinma puñukrin, puñushkanmanta atarin. Chasna kawsan masna punchakunata. Payka mana yachanchu imashnami wiñan chay muyuka. ");
INSERT INTO qupNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Allpaka pay kikinlla wiñachin. Puntiru tukyarin tarpuka, chaymanta wiñan, sisan, muyuyan, pukun. ");
INSERT INTO qupNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ña pukushpan muyunkunaka amunka payrayku pallachin. ");
INSERT INTO qupNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Chaymanta Jesuska rimarka: ¿Ima yachachinawashi ashwanta kankunata asirtachinima imashnami Yaya Diospa ali kamachinanka? ");
INSERT INTO qupNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Yuyariychi imashnami mostasa muyustuka chakrapi tarpushpanchi wiñan. Chay muyustuka tukuymanta ashwan uchillastumi. ");
INSERT INTO qupNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Chayta tarpunchi. Uchillastumanta wiñashpan tukuy tarpukunamanta ashwan atun tukun. Chaypi pishkukunaka ramankunapi tiyarinahun, wasinstukunata ruranahun. ");
INSERT INTO qupNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Achka chasna yachachinakunawa Jesuska chay runakunata yachachirka, Yaya Diospa shiminta asirtanata atipashkankunakamalla. ");
INSERT INTO qupNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Chay achka yachachinakunawa mana kuska asirtaypata yachachipayarka chay runakunata. Runankunallata tantachishpan tukuy chaykunata alita asirtachipayarka. ");
INSERT INTO qupNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ña tutayahushpanna Jesuska runankunata rimarka: Akuychi rishunchi kucha chimpama. ");
INSERT INTO qupNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Chay achka runakunata sakimushpankuna paypa runankunaka Jesusta pusharkakuna shuk botipi chimpama. Shuk runakunapas shuk botinkunapi parihu rirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Ña chimpahushpankuna kunkaymanta sinchi wayraka paykunata apirka. Yapa sinchita wayrahushpan atun ulaska shayarirka. Chay ulaska waktashpan yakuka botipi untarirka. Ña tikrahushpan mancharishpankuna likchachik rirkakuna Jesusta boti sikipi llachapakunapi puñuhukta. Yachachik, ¿manachu mancharinki ña tikrahushkanchita? ¡Yanapay ñukanchita! ");
INSERT INTO qupNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Atarishpan Jesuska chay wayrata ulastapas rimarka: ¡Kasillayay wayra! ¡Kasillayay ulas! Chay rimashkanllawa pasarirka wayraka ulaspas, manana ulasyarkanachu. ");
INSERT INTO qupNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Chay sinchi wayra ulaspas pasashkanwasha Jesuska runankunata rimarka: ¿Imaraykuta mancharinkichi? ¿Manarachu sinchikunkichi ñukapi? ");
INSERT INTO qupNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Chasna Jesuska rimashpan runankunaka tapunakurkakuna paykunapura: ¿Pishi kay runaka? Shuk rimashkanllawa wayrata ulastapas kasillayachishka. ");
INSERT INTO qupNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Chay atun kuchata chimpashpankuna Gerasa llakta kuchupi paktarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Chaypi paktashpankuna Jesuska sikashpan shuk supayyashka runa kayllayak shamurka. ");
INSERT INTO qupNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Chay runaka kawsarka urku rumi allarishka uchkukunapi, maypimi wañushkakuna churarishka karkakuna. Chay supayyashka karitaka nima pi atiparkachu apishpa watashpa charinata, nima sinchi kadenawa. ");
INSERT INTO qupNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Apishpa makinta chakintapas kadenawa watashpankunapas piti piti rurashpa ripayan. Nima pi atiparkachu winsinata. ");
INSERT INTO qupNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Punchapi tutapipas kaparishpa puripayan wañushkakunata churashkankuna rumi allarishka uchkukunapi, urkukuna chawpipipas. Pay kikinta rumikunawa waktarishpa puripayan. ");
INSERT INTO qupNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Chaypi karumanta Jesusta rihukta rikurka. Payta rikushpan kallparka puntanpi kunkurik rinanpa. ");
INSERT INTO qupNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Chaypi Jesuska chay runapi kawsak supayta sinchita rimarka: Millaypa supay, llukshiy kay runamanta. Chay supayka sinchita kaparishpan aynirka: Jesús tukuymanta atun yachayyu Yaya Diospa Wawan ¿imaraykuta ñukama shamushkanki? Tapuni kanta Yaya Diospa uyashkanpi amara kastigawayrachu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Chasna rimashkanwasha Jesuska tapurka: ¿Ima shutita kanki? Chay supayka aynirka: Shutinika kanmi Warankakuna, achka kashkanchirayku. ");
INSERT INTO qupNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Chaymanta chay supaykunaka Jesusta sinchita tapurkakuna mana paykunata wichunanpa chay Gerasa allpamanta. ");
INSERT INTO qupNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Chay urku kuchupi achka kuchikuna mikuhlla kahurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Chay supaykuna runapi kahukkunaka Jesús paykunata wichuhushpan tapurkakuna: Kachay ñukanchita kuchikunapi kawsananchipa. ");
INSERT INTO qupNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Alimi, yaykuychi kawsanaykichipa nishpa Jesuska rimarka. Chaypi supaykunaka chay runamanta llukshirkakuna kuchikunapina kawsanankunapa. Chaypina chay ishkay waranka kuchikunaka kunkaymanta waykuma kallpashpa pultyarkakuna lumamanta yakuma. Chaypina chinkarirkakuna wiñaypa chay kuchapi. ");
INSERT INTO qupNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Chay kuchita kuyrakkunaka mancharishpa llaktama kallpashpankuna tukuy rikushkankunata chay llaktapi, llakta mayanpipas kawsak runakunata kwintak rirkakuna. Chayta uyashpankuna achka runakuna rikuk rirkakuna urkuma, shutipachu kuchikuna chinkarishkakuna manachu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesús kahushkan urkupi paktashpankuna Jesuspa kuchunpi chay karita tarik rirkakuna, suma churarishka ali yuyaywana tiyahukta, maykanmi achka waranka supaykunawa kawsapayarka. Chay karita ali kahushkanta rikushpankuna mancharirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Chaypi Jesuspa rurashkanta rikushka runakunaka washa shamuhukkunata kwintarkakuna kasna nishpa: Jesuska kamachirka supaykunata chay karimanta llukshinankunapa. Chaymanta sakirka supaykunata kuchikunapi yaykunankunapa. Chaypina chay kuchikunaka kay urkumanta yakuma saltashpankuna chinkarishkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Chasna kwintashkankunata uyashpankuna tukuy runakuna mancharishpankuna Jesusta rimarkakuna chay allpankunamanta llukshinanpa. ");
INSERT INTO qupNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesuska botipi uraykushpanna chay aliyachishkan runaka payta tapurka: Ñukapas rinayani kanwa pakta nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesuska mana munashpan chay runata rimarka: Kutiy wasikima. Aylluykikunata kwintakriy, imashnami Yaya Dioska llakichishpan aliyachishka kanta. ");
INSERT INTO qupNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Chasna rimashpan chay runaka rirka Dekápolis shutiyuma, ninayan chunka llakta. Chaypi paktashpan kwintashpa kwintashpa purirka karan llaktapi Jesuska alita aliyachiwashka supaykunamanta nishpa. Chayta uyashpankuna tukuy chay runakunaka kushikurkakuna, imashnashi chay Jesús tukuymanta atun yachayyuka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Chaymanta Jesuska runankunawa kutirkakuna botinkunapi chay kucha chimpama. Chaypi paktashpankuna kutikashka achka runakuna Jesuspa kuchunpi tantarirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Chasna tantarishkankunapi shuk kari Jairo shutiyu paktamurka. Payka chaypi kawsak israel masinchikunapa tantarina wasipi kamachik karka. Jesusta rikushpan puntanpi kunkurik rirka. ");
INSERT INTO qupNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Chasna kunkurishpan sinchita tapurka: Yachachik, yanapaway. Warmi wawayni ña wañuhun. Makikiwa llankashpayki ampik ripay mana wañunanpa. ");
INSERT INTO qupNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Chaypina Jesuska paywa pakta rirka. Chay achka runakuna rihushkankunata rikushpankuna yapa tankanakushpa paykunawa pakta rirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Chay runakuna chawpipi shuk unkushka warmipas rihurka. Chunka ishkay watata tukuy uras yawar paymanta urmapayan. ");
INSERT INTO qupNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Chay warmika ampirinayashpan achka ampikkunama ripayan. Parisishpa kawsapayan. Tukuy ima tiyapushkanta kushpanpas nima pi atiparkachu payta ampinata. Mana atipashpan ampirinata ashwan yapa unkushka tukurka. ");
INSERT INTO qupNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Manara Jesusma rihushpan yacharka atun ampik kananta. Chasna yuyarishpan payka chay achka runakunawa pakta rihushpan pakalla Jesuspa washanmanta kayllayarka churarishkanta llankananpa. Churarishkanta llankashpaynillami ampirisha nishpa yuyarirka. ");
INSERT INTO qupNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Chasna llankashkanllapi yawarnin urmahushkaka pitirirka. Payka aychanpi musyarka chay unkuymanta ampirishkanta. ");
INSERT INTO qupNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesuspas musyarka shuk runa churarishkanta llankashkanmantalla ampirishkanta. Chasnallapi tikrarishpan tukuy runa katihukkunata rikushpan tapurka: ¿Pita llankawashka? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Chaypi paypa runankunaka aynirkakuna: ¿Imaraykutaya tapunki pimi llankawashka nishpa? ¿Manachu rikunki achka nitinakushpa kahushkanchita? ");
INSERT INTO qupNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Chasna rimashpankunapas Jesuska shukllankama shukllankama rikurka payta llankashkata tarinankama. ");
INSERT INTO qupNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Chaypi chay warmika yachashpan imashnami ampirishka, yapa mancharishpan chukchurishpa Jesuspa puntanpi kunkurik rirka. Chasna kunkurishpan tukuy payta pasashkanta kasna nishpa rimarka: Unaymanta pacha unkushka kashkaynirayku kanta llankashkani ampirinaynipa. Chasna llankashpaynillami kay unkuymanta ampirishkani. ");
INSERT INTO qupNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Chaypina Jesuska rimarka: Panini, ñuka kanta ampinaynita yuyarishpa ñukama shamushkaykirayku ñami ampirishka kanki. Kunanka kushillana wasikima kutiy, ñami sumakta ampirishkanki. ");
INSERT INTO qupNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesuska chasna rimahushkanllapi chay tantarina wasipi kamachik Jairopa shuk runankunaka wasinmanta shamurkakuna payta rimanankunapa: Wawaykika ñami wañushka. Ama yankamanta pushaychu kay yachachikta. ");
INSERT INTO qupNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Chasna rimashpankunatata Jesuska chay runakunata mana kasushpan chay wawapa yayanta rimarka: Ama llakinkichu. Ñukallapi sinchikuy. ");
INSERT INTO qupNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Chaymanta Jesuska pay kikinpa runankunata rimarka: Kankunaka kayllapi kipariychi. Kimsa runankunallata, Pedrota, Santiagota, Juanta pusharka Jairopa wasinma. ");
INSERT INTO qupNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Chay kamachikpa wasinpi paktak rishpankuna achka runakuna tantarishka kahukkunata rikurkakuna, kaparishpa wakahukkunata uyarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Chay wasipi yaykuhushpan Jesuska paykunata rimarka: ¿Imaraykuta chasna kaparishpa wakahunkichi? Kay wawaka manami wañushkachu, puñuhunmi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Chasna rimashpan payta asichirkakuna. Chaypi Jesuska tukuy chay wasipi kahukkunata llukshichirka. Chay wawapa yayanwa, mamanwa, chay kimsa runankunallawa chay wañushkapa kwartunpi yaykurka. ");
INSERT INTO qupNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Chay wawata makinmanta apishpan ñukanchi israel runakunapa shimipi rimarka: Talita kumi. Chayka ninayan warmi wawa, atariy. ");
INSERT INTO qupNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Chasna rimashkanllawa chay chunka ishkay watayu warmi wawaka atarimushpan kallarirka purinata. Runakunaka atunta mancharirkakuna wañushkanmanta atarishkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Tukuy parti kwintanayashpankunapas Jesuska sumakta kunarka mana nima pita kwintanankunapa. Chaymanta chay wawapa yayanta mamantapas rimarka: Wawaykichita karaychi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Chaymanta chay Galilea kucha mayanmanta llukshishpan Jesuska kikin llaktanma rirka. Runankunaka payta katirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Samana puncha paktashpan chaypi kawsak israel masinchikunapa tantarina wasipi yaykurkakuna. Chaypi Jesuska Yaya Diospa shiminta alita yachachirka. Chasna yachachihushpan achka runakuna uyashpankuna tapunakurkakuna: ¿Maypishi kay runaka kay suma rimanakunata yachakushka? ¿Imashnashi chasna atun yachayyu tukushka? ¿Imashnashi atipan tukuy chay atun yachaywa ruranakunata ruranata? ");
INSERT INTO qupNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Payta wawamanta pacha riksinchi. Payka karpintirumi, Mariapa wawanmi, Santiagopa, Josepa, Judaspa, Simonpa wawkinmi. Paninkunapas ñukanchiwa kawsanahun nishpa. Chasna riksishkankunarayku mana munarkakunachu payta kasunata, rikushkankunapi wiñashkanta yuyarishpankuna. ¿Imashnata ñukanchikunamanta yachak kanka? nishpa rimarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Chasna yuyarihushkankunata yachashpan Jesuska paykunata rimarka: Ñawpamanta pacha yaya rukunchikunaka rimapayanahun kasna: Yaya Diospa yachayninwa yachachikta tukuy parti runakuna uyashpankuna alita kasunahun. Kikin llaktanllapi mana munanahunchu kasunata. Payta riksikkuna ayllunkunapas mana payta kasunata munanahunchu. Chasnallatatami kankunapas ñukata riksiwashpaykichi mana kasunayawankichichu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Paykunaka mana kirinayashpankuna Yaya Diospa kachashkan kananta, Jesuska mana atiparkachu paykunata yanapashpa atun yachaywa ruranakunata ruranata. Shuk unkushkakunallata makinta paykunapi churashpan ampirka. ");
INSERT INTO qupNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Payka yapa llakirirka mana payta kirishkankunarayku. Chaymanta kuchu llaktakunapi purirka Yayan Diospa shiminta yachachinanpa. ");
INSERT INTO qupNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Shuk puncha Jesuska chay chunka ishkay akllashkan runankunata kayarka ishkay ishkayta kachananpa, Yaya Diospa shiminta yachachinankunapa. Chaymantapas paykunata yachayninta kurka supaykunata runakunamanta llukshichinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Paykunata kamachirka: Ñampita rihushpaykichi nima imata apaychichu, nima bulsaykichita, nima mikunaykichita, nima kullkikichita. Munashpaykichika shuk tulata apaychi urkitarinaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Chakikichipi churarishkaykichillawa, shuk churarinata churarishkaykichillawa riychi. Ama ashwan shuk churarinaykichitaka apankichichu. ");
INSERT INTO qupNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Chaymantapas paykunata kunarka: Shuk llaktapi paktashpaykichi shuk runa kankunata wasinpi kayashpan chay wasillapi kipariychi shuk llaktama rinaykichikama. ");
INSERT INTO qupNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Maykan llaktapimi Yaya Diospa shiminta mana uyanayashpankuna nima kankunata wasinkunapi kayanayashpankuna chasna llaktamantaka llukshiychi. Llukshihushpaykichi rimaychi: Yaya Diosmi kankunataka kastiganka, paypa shiminta mana uyanayashkaykichirayku. Chasna rimaychi yachanankunapa imamantami kastigay tukunkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Chaymanta chay runankunaka ishkay ishkay rishpankuna yachachirkakuna runakunata mana alita rurahushkaykichitaka sakiychi Yaya Diostana kasunaykichipa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Chaymantapas achka runakunamanta supaykunata llukshichirkakuna, achka unkushkakunata aseitewa kakushpa Yaya Diosta mañashpa ampirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Chay llaktakunapi kawsak runakuna tukuy Jesuspa rurahushkankunamanta kwintapayanahun. Chasna chay allpapi kamachik apu Herodespas paymanta kwintahushkankunata uyarka. Chay runakunaka tapunakurkakuna ¿pishi chay Jesuska? nishpa. Shukkunaka yanka nirkakuna: Chay Jesuska Bawtisak Juanchari wañushkanmanta kawsarimushka. Chayraykumi yachayninka tiyan mana atipaypakunata rurananpa. ");
INSERT INTO qupNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Shukkunaka nirkakuna: Chay karika ñawpa Yaya Diospa yachayninwa yachachik Eliaschari, maykanmi kuti shamunan karka. Shukkunaka nirkakuna: Chay karika ñawpa Yaya Diospa yachayninwa yachachikshinami kan. ");
INSERT INTO qupNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Chasna rimashkankunata uyashpan chay Herodeska mancharishpan pantachishpa rimarka: Chay karika Bawtisak Juanmi, maykantami kunkanta pitichishpa wañuchichirkani. Paymi wañushkanmanta kawsarimushka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Chasna chay apu Herodeska rimarka, chay Juanta wañuchichishkanta yuyarishpan. Manarapas Juanta wañuchichishpanra Herodeska wawkin Felipepa warminta apirka warminrayku. Chay warmipa shutinka karka Herodias. Herodeska wawkinpa warminta apishkanrayku Juanka payta kunarka Yaya Dioska mana munanchu kachuykiwa chasna kawsanaykipa nishpa. Chasna Juan kunashkanrayku Herodiaska yapa piñarishpan payta chiknishpan wañuchichinayarka. Warminta kasushpan Herodeska makinta chakintapas watachishpan Juanta karselpi churachirka. Chasna rurashpanpas payta sumakta tapachirka karselpi mana Herodiaska wañuchichinanpa. Pay yachapayarka Juan ali rurak runa kananta, chaymantapas tukuy shunkunmanta pacha Yaya Diosta kasuk kananta. Herodeska Juanta karselpi tapachishpanpas yapa payta uyanayarka. Achka kuti shunkunpi mancharishpanpas paypa kunashkanta uyanayarka. ");
INSERT INTO qupNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Shuk puncha Herodeska fiestata rurarka, wawayarishkan puncha paktarishkanrayku. Kayachirka tukuy Galilea allpa llaktakunapi kamachik runankunata, tukuy kapitankunatapas, tukuy kullkiyukunatapas upyanankunapa mikunankunapa paywa pakta. ");
INSERT INTO qupNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Chay fiestapi Herodiaspa shipas wawanka paykunapa chawpinkunapi sumakta baylarka. Baylahushkanta sumakta gustarkakuna. Apu Herodeska kushikushpan chay shipasta rimarka: Alita baylashpayki kushichiwashkanki. Chayrayku kanta rimani: Tapuway imatachari munanki, ñukami kushkayki. ");
INSERT INTO qupNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Imatachari tapuwanki chayta kushkayki. Munashpaykika chawpi kamachihushkayni allpata kushkayki. Tukuy kay runakuna uyahushkankunapi chayta rimani shutipa paktachinaynita nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Chaypi chay shipaska llukshishpan mamanta tapuk rirka: ¿Imatashi tapuynima? nishpa. Mamanka aynirka: Tapuy Bawtisak Juanpa umanta pitishpan kanta kunanpa. ");
INSERT INTO qupNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Utkalla chay shipaska kutishpan Herodesta rimarka: Kunalla munani Bawtisak Juanpa umanta kuwanaykipa. Shutipa pitichishkaykita rikunaynipa kallanapi churashpayki kuway. ");
INSERT INTO qupNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Chayta uyashpan Herodeska yapa llakirirka. Llakirishpantata tukuy kayashkankunapa uyashkankunapi rimashkanrayku mana munarkachu llullachinata. ");
INSERT INTO qupNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Chayrayku chay ratulla kacharka shuk runanta Bawtisak Juanpa umanta pitishpan apamunanpa. ");
INSERT INTO qupNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Chasna kachashpan chay runanka rirka karselma, maypimi Juanka taparishka karka. Chaypina kunkanta pitishpan apamurka umanta shuk kallanapi shipasta kunanpa. Payna mamanta kuk rirka. ");
INSERT INTO qupNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Chaymanta chay Juanpa runankunaka, yachashpankuna Herodes wañuchichishkanta, Juanpa aychanta apak rirkakuna allarishka urku uchkupi churashpa tapanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Chaymanta chay chunka ishkay Jesuspa apostolninkunaka kutimushpankuna mushumanta tantarirkakuna Jesuswa. Chasna tantarishpankuna paypa yachayninllawa atipaypakunata rurashkankunata yachachishkankunatapas Jesusta kwintarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Chasna kwintahushkankunapi achka runakuna paykunapi paktarkakuna. Shukkuna kutihushpankuna shukkunaka paktarkakuna. Jesuska paypa runankunapas mana atiparkakunachu samanata, nima mikunata, achka runakuna shamuhushkankunarayku. Chayta rikushpan Jesuska runankunata rimarka: Akuychi samak rishunchi maypimi mana runaka tiyanchu chaypi. ");
INSERT INTO qupNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Chaypina paykunalla botipi rirkakuna chunllama. ");
INSERT INTO qupNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Achka runakuna rihushkankunata rikurkakuna. Chaypina tukuy llaktakunamanta kallpashpa kucha mayanta rishpankuna paykunara puntiru paktarkakuna, maypimi samanapa rihurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesuska botimanta llukshihushpan achka runakuna tantarishka kahukkunata rikurka. Paykunata rikushpan llakirirka mana nima pi tiyashkanrayku Yaya Diospa shiminta paykunata yachachinanpa. Mana amuyu obehakuna ñampita pantachishpa purihukkunashinami karkakuna. Chasna paykunata llakichishpan achkata Yaya Diosmanta asirtachishpa yachachirka. ");
INSERT INTO qupNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ña chishiyahushpan runankunaka Jesusta kayllayashpankuna rimarkakuna: Ñami chishiyahunchi. Kaypika manami nima shuk runa kawsanchu paymanta mikunata rantinanchipa. ");
INSERT INTO qupNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kay achka runakunata kachay, kay kuchullapi kahuk llaktakunama rishpankuna mikunankunata rantinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesuska aynirka: Kankuna karaychi kay runakunata. Paykunaka aynirkakuna: ¿Imashnata tarinchima chasna achka mikunata chay tukuy runakunata karananchipaka? Tarishpanchipas munanchimami yapa achka kullkita chay achka runakunarayku mikunata rantinanchipa. Munanchimami shuk runa pusak killata tarawashpan ganashkan kullkita nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesuska tapurka: ¿Masna panta tiyan kankunapa? Rikuk riychi yachanaykichipa. Rikuk rishpankuna aynirkakuna: Pichka panstu, ishkay challwastullami tiyan. ");
INSERT INTO qupNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Chaymanta Jesuska rimarka: Runakunata rimak riychi allpapi tiyarinankunapa shuk muntun shuk muntun. ");
INSERT INTO qupNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","41","Chasna muntun muntun tiyarishpankuna Jesuska chay pichka panta, chay ishkay challwatapas apishpan siluma rikushpan mañarka: Yayayni Dios, agradesini kanta kay mikunata kushkaykirayku nishpa. Chaymanta chay pankunata, challwakunatapas paki paki rurashpan runankunata kurka chay achka runakunata karanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tukuy runankunawa pakta saksakta mikurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","44","Chay runakuna mikuhukkuna karkakuna pichka waranka karikuna, mana yupashpa warmikunata wawakunatapas. Mikushkankunawasha chunka ishkay tasata untachirkakuna pan challwawa chapu puchurishkata. ");
INSERT INTO qupNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Chaymanta Jesuska runankunata rimarka: Kankunaka puntapi riychi, ñukaka washami shamusha. Chimpahuychi botipi Betsaida llaktama. Ñukaka kiparishara kay runakunata wasinkunama kachanaynikama. ");
INSERT INTO qupNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ña chay runakunata kachashkanwasha shuk urku awama sikarka Yayan Dioswa kwintananpa. ");
INSERT INTO qupNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ña tutayahushpanna Jesuspa runankunaka kucha chawpipi kahurkakuna, Jesuska sapallan allpapi kiparirka. ");
INSERT INTO qupNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Chay kucha chawpipi runankunaka sinchita kawihushpankunatata mana atiparkakunachu chimpanata, sinchi wayraka puntankunamanta shamuhushkanrayku. Jesús chasna kahushkankunata rikushpan ña pakarihushkanpi yaku awata purishpan paykunata kayllayarka. Runankunaka kuskata pasahuktashina rikurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Chasna yaku awata purishpa rihukta rikushpankuna yapa mancharirkakuna. Mancharishpankuna kaparirkakuna: ¡Ay! ¿Imataya chayka shamuhun? Almachari. Chaypina Jesuska rimarka: Sinchikuriychi. Ñukami kani, ama manchariychichu. ");
INSERT INTO qupNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Chaypina Jesuska botinkunapi uraykurka. Chasna uraykuhushkanllapi chay sinchi wayraka pasarirka. Chaypi runankunaka yapa mancharishpankuna rimarkakuna: ¿Imashnataya kay Jesuska wayrata pasachin? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Jesús panta mirachishkanta rikushpankunatata shunkunkunapi manara shutipa yuyarirkakunachu Yaya Diospa Wawan kananta. ");
INSERT INTO qupNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Chay kuchata chimpashpankuna Genesaret allpa mayanpi paktarkakuna. Llutarishpankuna botinkunata watarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Chaymanta sikahushkankunallapi chaypi kawsak runakunaka Jesusta riksirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Chasna payta riksishpankuna karan wasikunapi rimashpa rimashpa kallparkakuna ñami Jesuska paktamushka nishpa. Chaypina kallarirkakuna unkushkakunata llanchamankunapi apamunata, maypimi Jesuska kahurka chayma. ");
INSERT INTO qupNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Maypipas Jesús paktashpan uchilla llaktakunapi, atun llaktakunapi, wasikunapi, runakuna tantarina plasakunapipas, chaypi runakunaka unkushkakunata apapayanahun. Chaypina Jesusta tapurkakuna kay unkushkakunata yanapashpa churarishkayki shimillata llankachiy ampirinankunapa nishpa. Chaypina tukuy llankakkunaka ampirirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Jesús Genesaret allpa mayanpi kahushpanra fariseokuna, Jerusalén llaktamanta shamushka shuk Moisespa killkashkanta yachachikkunapas chaypi tantarirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Paykunaka rikurkakuna Jesuspa shuk runankuna ñukanchi israel runakunapa shuk kamachishkakunata mana kasushkankunata. Paykunaka mana makinkunata suma chuya yakupi mayllarishpachu mikurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Chay fariseokunaka tukuy ñukanchi israel runakunapas manara mikuhushpanchi makinchikunata shuk suma chuya yakupi mayllarinchi, chasna rurashpanchi Yaya Dioska ñukanchita alicharishka kananchita rikun nishpa. Chayta rurapayanchi ñawpa yaya rukunchikuna wañupa rurashkanta achka kamachishkankunata alita katishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Chasnallatata yaya rukunchikuna wañushina merkadumanta shamushpanchi manara mikuhushpanchi suma chuya yakuwa mayllaripayanchi, chasna rurashpanchilla atipanchi Yaya Dioswa kwintanata nishpa. Chaymantapas tiyan achka kamachishkakunaka, maykankunatami yaya rukunchi wañukunamanta yachakushpanchi kasupayanchi. Shukkuna kanahun imashnami manara mikuhushpanchi suma chuya yakuwa mayllananchi tiyan tukuy pusillunchikunata, mukawakunata, tinahanchikunata, mankanchikunata, irmankanchikunata, tiyarinanchikunatapas. ");
INSERT INTO qupNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Chasna kashpan chay fariseokunaka, chay Moisespa killkashkanta yachachikkunapas Jesusta tapurkakuna: ¿Imaraykuta runaykikunaka mana katihunkunachu yaya rukunchikuna wañupa rurashkankunata? ¿Imaraykuta makinkunata chuya yakupi mana mayllarishpa mikunahun? ");
INSERT INTO qupNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesuska aynirka: Chay Yaya Diospa yachayninwa ñawpa yachachik Isaiaska kasna kankuna llullachiysikikunamanta Yaya Diospa rimashkanta killkarka: Kay runakunaka shiminkunallawami yuyawanahun. Manami tukuy shunkunkunamanta pachachu yuyawanahun. ");
INSERT INTO qupNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Runakunapa yachachishkankunallata katishkankunaraykumi yankamanta ñukata mañana wasipi tantarinahun kushichiwanankunapa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Chasnami kankunaka kankichi. Yaya Diospa kamachishkanta sakishpaykichi ñawpa yaya rukuykichikunapa yachachishkankunallata katihunkichi. ");
INSERT INTO qupNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Chaymantapas Jesuska rimarka: Ñawpa yaya rukuykichikunapa yachachishkankunallata kasuhushpaykichimi Yaya Diospa kamachishkantaka mana kasunayankichichu. ");
INSERT INTO qupNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moiseska Yaya Diospa kamachishkanta kasna killkarka: Yayaykichita mamaykichita yuyashpa kasushpa kawsaychi. Chaymantapas killkarka: Maykanmi yayanta mamanta chiknishpa riman mana ali kanankunata, chasna runataka apuykichimi wañuchichinan tiyan nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Chasna Yaya Dioska kamachishpantata kankunaka chikanta yachachihunkichi. Runakunata rimankichi: Shuk runa mamanta yayanta pishihushpantata mana kumachu, Yaya Diosta tukuy kullkinta kushkanranti. Chaymanta mamanta yayanta rimama kankunata kunayni kullkita ñami Yaya Diosrayku kushkani nishpa. Chasna runaka alitami rurahun nishpa rimankichi. ");
INSERT INTO qupNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Chasna rimashpaykichimi yachachinkichi wawakuna manana yayankunata yanapanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Yaya Diospa kamachishkanta sakinkichi manana ruranaykichipa. Chayranti yaya rukuykichikuna wañupa yachachishkankunatana yachachinkichi runakuna chaykunatana kasunankunapa. Chasnashinami achka Yaya Diospa kamachishkankunatapas sakishpaykichi chikantana yachachinkichi nishpa Jesuska chay fariseokunata, chay shuk yachachikkunatapas rimarka. ");
INSERT INTO qupNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Chaymanta chay achka runakunata kayashpan Jesuska kutikashka paykunatana rimarka: Alita uyawaychi yachakunaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kankunaka rimankichi: Makinchita chay ñawpa kamachishkankunashina mana mayllashpanchika ña uchata rurahunchi nishpa. Ñukaka kankunata rimani: Makikichita mana mayllashpa mikushpaykichipas mana uchata rurankichichu. Ashwan shunkuykichipi mana ali yuyarihushkaykichita rurashpaykichimi shuti uchata rurankichi. ");
INSERT INTO qupNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Tukuy kay yachachihushkaynita alita uyashpa yachakuychi. ");
INSERT INTO qupNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Chasna rimashkanwasha Jesuska chay runakunata sakimushpan shuk wasipi yaykurka. Chaypi paypa runankunaka payta tapurkakuna: ¿Ima ninayashkankitaya chay yachachishkaykiwa? ");
INSERT INTO qupNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Jesuska paykunata aynishpan rimarka: ¿Kankunapas manachu asirtashkankichi chay rimashkaynita? Tukuy mikushkanchika wiksanchima rin. Chaymanta llukshin aychanchimanta. Mana yaykunchu shunkunchipika yuyayninchita waklichinanpa. Chayrayku mana mayllashpa mikushpaykichipas mana uchata rurankichichu. Chay rimashkanwami ninayan: Tukuy mikunami ali kan. ");
INSERT INTO qupNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Chaymanta Jesuska rimashpalla katirka: Shunkuykichipi kahuk mana ali yuyarishkaykichita rurashpaykichi shuti uchayankichi. ");
INSERT INTO qupNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Manara millaypata rurahushpaykichira shunkuykichipi yuyarinkichi chay millaypata ruranaykichipa. Chaymanta tukuy chay millaypakunata rurankichi. Chay millaypa ruranakuna kanahun: Shuk warmiyu kari shuk warmiwa musayana, shuk kusayu warmi shuk kariwa musayana, chaymanta tukuywa musayanakuna, shuk runata chiknishpa wañuchina, shuwana, shuk runakunapata munarishpa kawsana, tukuy millaypakunata rurashpa kawsana, shukkunata llullachishpa kawsana, munashkanchillata rurashpa kawsana, tukuy rikushkanchita munarishpa kawsana, mana alita yuyarishpa shukkunata washanchashpa kawsana, ñukami kani shuk runakunamanta ashwan alita rurak runa nishpa kawsana, chaymantapas tukuy mana alita yuyarishpa kawsana. ");
INSERT INTO qupNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tukuy chasna ruranakunami ucha kanahun. Shunkuykichipi millaypa yuyarishkaykichita rurashpaykichimi tukuy chaykunata rurankichi. Manami uchata rurankichichu, makikichita mana mayllashkaykichirayku. ");
INSERT INTO qupNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Chaymanta Jesuska runankunawa pakta kay Israel allpanchimanta llukshishpan Tiro llakta kuchuma rirkakuna. Chaypi paktashpankuna shuk wasipi yaykurkakuna runakuna paktashkankunata mana yachanankunapa. Chasna rurashpankunapas shuk ratulla tukuy runakuna yacharkakuna Jesuska chay wasipi kahushkanta. ");
INSERT INTO qupNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Chaypi shuk mana israel warmipas Jesusmanta yacharka. Payka Sirofenisiamanta warmi karka. Chay warmipa shipas wawanpi supay yaykushka karka. Mamanka Jesús chay wasipi kahushkanta yachashpan wasima yaykushpan puntanpi kunkurik rirka. Chaypi Jesusta tapurka: Yachachik, wawaynimanta supayta llukshichiy nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Chaypi Jesuska chay warmita rimarka: Manara chikan runakunata ampishpaynira israel runa masinikunatara yanapanayni tiyan. Alita yuyariy. Manara allkunchikunata karashpanchimi puntiru wawanchikunatara karanchi saksanankunapa. Manami paykunata mikunankunata kichunchichu allkunchikunata karananchipa. ");
INSERT INTO qupNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Chaypi chay warmika mana payta sakishpan aynirka: Ari yachachik, alita rimashkanki puntiru wawanchikuna mikunankuna tiyan nishpa. Chasna kashpanpas wawanchikuna mikuhushpankuna allkunchikuna wicharishkakunata mikunahun. Chikan runakunamanta warmi kashpaynipas kay shipas wawaynita ampipay nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Chaypina Jesuska aynirka: Alitami rimawashkanki. Chayrayku kunanka wasikima kutiy, ñami wawaykimanta chay supayta llukshichishkani. ");
INSERT INTO qupNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Chay warmika wasinma kutishpan shipas wawanta alitana puñunanpi tiyahukta rikuk rirka, ña chay supayka paymanta llukshishkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Chaymanta chay Tiro llakta kuchumanta llukshishpankuna Jesuska runankunawa Sidón llaktama rirkakuna. Chaymanta Galilea kucha mayanma kutirkakuna, Dekápolis shutiyu allpama. ");
INSERT INTO qupNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Chaypi paktashpan shuk runakuna shuk runata mana uyanata, nima rimanata atipakta Jesusma aparkakuna. Chaypi Jesusta tapurkakuna makinta churashpa chay runata ampinanpa. ");
INSERT INTO qupNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","34","Chaypina Jesuska payta pusharka chay achka tantarishka runakunamanta kinkrayma. Chaypi atunta samashpan awama rikushpan makinwa chay runata rinkrinpi tupachirka. Llawsanwa makinta ukuchishpan chay runapa kallunpi tupachirka. Chaymanta Jesuska rimarka: Efata. Chay ninayan paskariy. ");
INSERT INTO qupNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Chasna rimashkanllawa chay mana uyak nima rimanata atipak runapa rinkrinta kalluntapas ampirka. Chaypina chay runaka alina karka, alitana uyarka, alitana rimarka. ");
INSERT INTO qupNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Chaymanta Jesuska chay ampishkanta rikuk runakunata rimarka, nima pita kwintanankunapa chay karita ampishkanmanta. Chasna rimashpantata mana kasushpa ashwanta kwintarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Atunta mancharishpa kushikushpankuna rimarkakuna: Rikuychi kay Jesuspa rurashkanta tukuy yapa ali kananta. Mana uyak runatapas ampin, mana rimanata atipaktapas rimachin. ");
INSERT INTO qupNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Shuk puncha kutikashka achka runakuna Jesuswa tantarirkakuna. Chaypina mikunankunaka tukurishpan yarkaywa kahurkakuna. Chasna kahushkankunata rikushpan Jesuska paypa runankunata kayashpan rimarka: ");
INSERT INTO qupNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Llakichini kay runakunata. Ña kimsa punchata katiwahunkuna, mana tiyanchu nima ima mikunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Karu llaktankunamanta shamushkakuna. Chayrayku mana karashpa wasinkunama kachashpaynika yarkaywa sampayashpankuna wañunayankakuna ñampita rihushkankunapi. ");
INSERT INTO qupNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Chaypi runankunaka Jesusta aynirkakuna: ¿Imatata karanchima paykunata kay nima maykan kawsahushkanpika? Kaypika mana kawsanchu nima shuk runa paymanta mikunata rantinanchipa. ");
INSERT INTO qupNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Chaypina Jesuska paykunata tapurka: ¿Masna panta tiyan kankunapa? Paykunaka aynirkakuna: Kanchis panllami tiyan. ");
INSERT INTO qupNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Chaymanta Jesuska rimarka tukuy chay runakunata tiyarinankunapa allpapi. Chaypina chay kanchis pankunata apishpan Yayan Diosta agradesirka. Chasna agradesishkanwasha paki paki rurashpan chay panta runankunata kurka chay achka runakunata karanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Chaymantapas masna uchilla challwakunapas tiyarka. Chaytapas Jesuska chasnallatata rurarka. Yayan Diosta agradesishpan runankunata kurka chay achka runakunata karanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Chasna karashpankuna tukuy saksakta mikurkakuna. Mikushkankunawasha pan challwa puchurishkata kanchis tasata untachirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Chay achka runakuna mikushkakunaka karkakuna chusku waranka parti. Mikushkankunawasha Jesuska paykunata rimarka: Wasikichima kutiychi. ");
INSERT INTO qupNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Chaymantana paypa runankunawa shuk botipi uraykushpankuna Dalmanuta allpama rirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Fariseokunaka shamushpankuna Jesusta tapurkakuna: Shutipa Yaya Diospa kachashkan kashpaykika ñukanchirayku ruray Yaya Diospa yachayninwa shuk nima ima uras rikushkanchita. Chasna tapurkakuna yapa runakunata riksichinayashpankuna mana Yaya Diospa kachashkan kananta. ");
INSERT INTO qupNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Mana chay runakunaka kirinayashpankuna Jesuska llakirishpan atunta samashpan pay kikinlla nirka: ¿Imaraykushi kay runakunaka Yaya Diospa yachayninwa ruranaynita rikunayanahun? Chay tapukkunatana rimarka: Kankunata rimani, tapuwashpaykichipas Yaya Diospa yachayninwa rurashkaynita rikuchinaynipa, manami rurashanchu. ");
INSERT INTO qupNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Chaypina washayamushpan chunllalla paykunata sakimurka. Chaymanta runankunawa pakta shuk botipi uraykurka chay kuchata chimpanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Chay runankunaka kuchata chimpahushpankuna yuyarirkakuna kunkamushkanchimi pankunata apamunata. Shuk panllatami apahunchi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Chaypina Jesuska sumakta kunashpan yachachirka: Alita uyawaychi, ama munaychichu fariseokunapa nima Herodesta katikkunapa levadurata. ");
INSERT INTO qupNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Chasna Jesús levaduramanta rimashpan maykanwami chapushpa panta punkichinchi chay runankunaka rimarkakuna paykunapura: Mana achka panta apamushkanchiraykumi chasna ñukanchita rimahun. ");
INSERT INTO qupNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesuska chasna rimahushkankunata yachashpan rimarka: ¿Imaraykuta kankunapura pan mana tiyanchu nihunkichi? Mana chay panta kunkashkaykichimantachu kankunata rimahuni. ¿Manarachu atipankichi asirtanata? ¿Manachu yuyayyu kankichi? ");
INSERT INTO qupNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Manachu rikushkankichi rurashkaynita? ¿Manachu uyashkankichi yachachishkaynita? ");
INSERT INTO qupNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Manarachu asirtankichi pichka panllawa pichka waranka runakunata karashkaynita? ¿Masna tasatata untachirkankichi puchurishkata? Paykunaka aynirkakuna: Chunka ishkay tasatami untachirkanchi. ");
INSERT INTO qupNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Chaymanta Jesuska rimarka: Kutikashka karashpaynika kanchis panwa chusku waranka runakunata, ¿masna tasatata untachirkankichi puchurishkata? Paykunaka aynirkakuna: Kanchis tasatami untachirkanchi. ");
INSERT INTO qupNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Chaypi Jesuska rimarka: ¿Manarachu asirtankichi Yaya Diospa yachayninwa kahushkaynita? ");
INSERT INTO qupNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Chaymanta Jesuska runankunawa rishpan Betsaida llaktapi paktarkakuna. Chaypi Jesusma pushamurkakuna shuk wisku runata. Jesusta tapurkakuna chay wiskuta llankashpan ampinanpa. ");
INSERT INTO qupNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Chaypina Jesuska chay wisku runata makinmanta apishpan chay llakta kanchama pusharka. Chaypi llawsanwa makin puntata ukuchishpan chay wiskupa ñawinta llankarka. Chaypina Jesuska tapurka: ¿Atipankichu rikunata? ¿Imakunatata rikunki? ");
INSERT INTO qupNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Chay wiskuka aynirka: Ari, rikunimi runakunata purihukkunata; mana yapa alitachu rikuhuni, kaspikunatashinami rikuhuni. ");
INSERT INTO qupNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Kutikashka ñawinta llankarka. Chay llankashkanllawa chay runaka alina kiparirka. Tukuy imatapas shutillatana rikurka. ");
INSERT INTO qupNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Chaymanta Jesuska chay runata kunashpan wasinma kacharka: Kuskata wasikima kutiy. Ama kay llakta chawpita pasankichu. ");
INSERT INTO qupNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Chaymanta Jesuska runankunawa purishpa rirka chay Sesarea Filipo shutiyu llaktama. Chay ñampita rihushpankuna Jesuska runankunata tapurka: Runakuna kwintashpankuna ¿pimi kani ninahuntaya? ");
INSERT INTO qupNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Paykunaka aynirkakuna: Shukkunaka ninahunmi Bawtisak Juanchari wañushkanmanta kawsarishka kanaykita. Shukkunaka ninahunmi ñawpa Yaya Diospa yachayninwa yachachik Eliaschari kanaykita, maykanmi kuti shamunan karka. Shukkunaka ninahunmi shuk ñawpa Yaya Diospa yachayninwa yachachikchari kawsarishka kanaykita. ");
INSERT INTO qupNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Chaymanta paykunatana tapurka: ¿Kankunaka pimi kani niwankichitaya? Pedroka aynirka: Kanmi kanki Yaya Diospa Kachashkan Kishpichik. ");
INSERT INTO qupNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Chaypina Jesuska rimarka: Ama nima pita rimankichirachu ñuka Yaya Diosmanta shamushkaynita. ");
INSERT INTO qupNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Chaymanta Jesuska paypa runankunata yachachirka: Ñuka Yaya Diospa Kachashkan Runa yapa parisinayni tiyan. Ñukanchita kamachik israel masinchi rukukuna, saserdotekunapa apunkunapas, Moisespa killkashkanta yachachikkunapas yapa chikniwashpankuna parisichiwankakuna. Chasna chikniwashpankuna wañuchiwankakuna. Wañuchiwashpankunapas kimsa punchamantami kawsarisha. ");
INSERT INTO qupNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Chay parisinanmanta shutillata Jesuska rimarka nima pakashpa. Chasna uyashpankuna Pedroka Jesusta chaynikstuma pushashpan rimarka: Ama chasna rimaychu Yachachik. ");
INSERT INTO qupNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Chaypina Jesuska tikrarishpan runankunata rikushpan piñashpa Pedrota rimarka: Anchuriy ñukamanta supaykunapa apunshina rimak. Chasna rimawashpaykimi mana Yaya Diospa munashkantachu rimawahunki, ashwan runapa yuyarinanllatami rimawahunki. ");
INSERT INTO qupNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Chaymanta Jesuska runankunata, payta katihuk runakunatapas kayashpan rimarka: Kankuna ñukata katinayawashpaykichika ama kankuna kikin munashkaykichita ruraychinachu. Kankunata chiknik runakuna piñarishpa wañuchinayahushpankunapas ñukallata katiwaychi. ");
INSERT INTO qupNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Maykanmi wañuyta manchashpan sakiwan, chayka manana atipanchu ñukawa wiñaypa kawsanata. Maykanmi mana sakishpa ñukata katiwahushpan chaymantapas Yaya Diospa suma ali shiminta yachachihushpan chikninata wañuytapas parisin, chayka wiñaypami Yaya Dioswa kawsanka. ");
INSERT INTO qupNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Imata valin shuk runa tukuy kay mundupi tiyashkata apinanpa? Tukuy chaykunaka mana yanapanchu wañuymanta kishpinanpa. ");
INSERT INTO qupNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Masna kullkitapas kunayashpaykichika manami atipankichichu rantinata chay wiñaypa Yaya Dioswa kawsanata. ");
INSERT INTO qupNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Shuk kankunamanta kay millaypata rurak, mana kiriwak runakunapa puntanpi pinkarima ñukata katiwahushkanta rimanata, chaymantapas shiminita yachachinata. Chasna runataka ñuka Yaya Diospa Kachashkan Runapas kay allpama kutikashka shamushpayni rimasha mana ñukapa kananta. Chay punchaka Yaya Diospa paypa atun yachayninwa tukuy paypa angelkunawa pakta kutikashka shamusha. ");
INSERT INTO qupNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Chaymanta Jesuska rimarka: Alita uyawaychi. Shuk kankunamanta kaypi kahukkunaka manara wañuhushpaykichira rikunkichimi Yaya Dios atun yachayninwa kay allpapi kamachihushkanta. ");
INSERT INTO qupNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Sokta punchamanta Jesuska shuk atun urku awama sikarka. Kimsa runankunallata pusharka Pedrota, Santiagota, Juantapas. Chay urkupi kahushpankuna Jesús chikanyahushkanta rikurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Churarishkanka utkumanta yapa yura, mana rikuypa suma chuya tukurka. ");
INSERT INTO qupNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Chaypina chay kimsa runankunaka rikurkakuna chay ñawpa yachachikkuna Eliasta, Moisestapas Jesuswa kwintahukkunata. ");
INSERT INTO qupNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Paykunata rikushpankuna yapa mancharirkakuna. Chaypi Pedroka Jesusta rimarka: Yachachik, alitami kaypi kahunchi. Kunanka aku rurashu kimsa tampukunata, shukta kanrayku, shuktaka Moisesrayku, shuktaka Eliasrayku. Pedroka yapa mancharishpan chasna rimarka. ");
INSERT INTO qupNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Chasnallapi shuk puyuka llantuyachishpan llantupina kiparirkakuna. Chay puyu chawpimanta Yaya Diospa rimahushkanta uyarkakuna: Kay Jesusmi munashkayni Wawayni kan. Kasuychi payta. ");
INSERT INTO qupNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Shuk ratumanta chay kimsa runankunaka alita rikushpankuna Jesusta sapallantana rikurkakuna. Nima Elias, nima Moisés tiyarkanachu. ");
INSERT INTO qupNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Chay urkumanta uraykumuhushpankuna Jesuska paykunata kunarka: Kay urkupi rikushkaykichita ama nima pita kwintankichirachu ñuka Yaya Diospa Kachashkan Runa wañushkaynimanta kawsarinaynikama. ");
INSERT INTO qupNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Chayrayku paykunaka manara nima pita kwintarkakunarachu. Chasna Jesús wañushkanmanta kutikashka kawsarimunanta rimashkanta uyashpankuna runankunaka mana asirtashpankuna tapunakurkakuna: ¿Ima ninayantaya chay rimashkanwa? ");
INSERT INTO qupNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Chaypina Jesusta tapurkakuna: ¿Imaraykutaya Moisespa killkashkanta yachachikkunaka rimanahun, manara chay chapahushkanchi Yaya Diospa Kachanan Kishpichikka shamuhushpanra ñawpa yachachik Eliasrami shamunka nishpa? ");
INSERT INTO qupNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Jesuska paykunata aynirka: Shutipami chay Yaya Diospa yachayninwa ñawpa yachachikka rimarka: Manarapas Yaya Diospa Kachanan Kishpichikka shamuhushpanra shuk ñawpa Yaya Diospa yachayninwa yachachik Eliasshinami shamunka. Tukuy runakunatami yachachinka shunkunkunata alicharinankunapa chay Kishpichiktana kasunankunapa nishpa. Ñukaka kankunata rimani, ñami shamushka chay Eliasshina yachachikka. Runakuna mana payta riksishpankuna chiknishpa parisichishkakuna. Chasnallatatami ñukamanta Yaya Diospa ñawpa killkachishkanpi riman: Yaya Diospa Kachanan Runa yapa parisinan tiyan. Runakunaka paytapas mana kasunayashpankuna parisichishpa wañuchinkakuna nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Chaymanta Jesuska chay kimsa runankunawa urkumanta uraykumuhushpankuna chay shuk runankuna kahushkankunapi paktak rirkakuna. Chasna paktashpankuna achka runakuna muyukta kahukkunata tarik rirkakuna. Chaypipas Moisespa killkashkanta shuk yachachikkunaka rimanakurkakuna Jesuspa runankuna kiparishkakunawa. ");
INSERT INTO qupNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Chasnallapi Jesusta rikushpankuna tukuy kallpamurkakuna tinkunankunapa, sumakta payta yuyashpankuna. Rikuychi Jesús paktamuhukta nishpa rimarkakuna. Paktashpankuna rimarkakuna: ¿Ñachu shamushkanki Yachachik? ");
INSERT INTO qupNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ñami shamushkani aynishpan Jesuska paykunata tapurka: ¿Imatata runaynikunawa rimanakuhunkichi? ");
INSERT INTO qupNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Shuk runa chaypi kahukka aynirka: Yachachik, wawaynitami apamushkani. Supay yaykushka kahushpanmi mana atipanchu rimanata. ");
INSERT INTO qupNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Maypipas kahushpan chay supayka wawaynita apishpan allpama urmachin. Putsku shiminmanta llukshin, kirunkunatapas trak trak kanirin. Lismayachishpan sinchiyarishkana kiparin. Runaykikunata rimashkani chay supayta wawaynimanta llukshichinankunapa. Manami atipashkakunachu. ");
INSERT INTO qupNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Chaypi Jesuska tukuy runakunata rimarka: Mana ñukapi sinchikuk runakuna, ima uraskamataya kankunawa kiparishpa yachachishkaykichi. Apamuychi chay wawata. ");
INSERT INTO qupNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Chaymanta chay wawata Jesusma aparkakuna. Chaypina chay supayka Jesusta rikushpan chukchuchishpan chay wawata allpapi urmachirka. Chay wawaka kuchpari kuchpari tukushpan putsku shiminmanta llukshirka. ");
INSERT INTO qupNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Chaypina Jesuska chay wawapa yayanta tapurka: ¿Maytukuy unaytata chasna kawsan kay wawaykika? Yayanka aynirka: Wawastumanta pachami chasna kawsan. ");
INSERT INTO qupNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Chay supayka wawaynita wañuchinayashpa achka kuti ninapi yakupipas urmachishka. Chayrayku kanta mañani atipashpaykika llakichishpayki ampipay. ");
INSERT INTO qupNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Chaypi Jesuska aynirka: ¿Imaraykuta ninki atipashpaykika? Tukuytami atipani ruranata ñukapi sinchikurikraykuka. ");
INSERT INTO qupNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Chaypina chay wawapa yayanka llakiywa rimarka: Ñukaka chayra kirihuni kanta. Chayrayku yanapaway ashwan shunkuynimanta pacha kanpi sinchikurinaynipa. ");
INSERT INTO qupNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesuska rikushpan yapa achka runakuna tantarihushkankunata, chay mana uyanata nima rimanata atipachik supayta sinchi shimiwa kamachirka: Millaypa supay, kay wawamanta llukshiy alita uyananpa, alita rimananpana. Ama kuti killachinkinachu kay wawata. ");
INSERT INTO qupNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Chaypina chay supayka kaparishpan chay wawata kuchpachishpa urmachirka. Chaywasha llukshishpan wañushkatashina sakirka. Chayta rikushpankuna chay runakunaka rimarkakuna: Ñami wañushka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Chasnallapi Jesuska makinmanta apishpan chay wawata atarichirka. Chaypina chay wawaka shayarimurka. ");
INSERT INTO qupNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Chaymanta Jesuska shuk wasipi yaykuk rirka. Chaypi runankunallawa kahushpan payta tapurkakuna: ¿Imaraykutaya mana atipashkanchichu ñukanchika chay supayta llukshichinata chay wawamanta? ");
INSERT INTO qupNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesuska aynirka: Sinchimi kan chasna supaykunata llukshichinapaka. Yaya Diosta kasushpa sumakta mañashpanchirami atipanchi llukshichinata chasna supaykunataka. ");
INSERT INTO qupNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Jesuska runankunawa chay llaktakunamanta llukshishpan Galilea allpa chawpita rirkakuna. Jesuska mana munarkachu nima pi yachananpa Galileapi kahushkanta, runankunallata yachachihushkanrayku. Chaypina runankunata rimarka: Ñuka Yaya Diospa Kachashkan Runa kashpaynipas chikniwak runakunami apichiwashpankuna parisichishpa wañuchiwankakuna. Chasna wañuchiwashpankunapas kimsa punchamantami kawsarisha. ");
INSERT INTO qupNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Chasna Jesuska alita rimashpantata paypa runankunaka mana asirtarkakunachu. Mana asirtashpankunatata mancharishpankuna mana payta tapurkakunachu. ");
INSERT INTO qupNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","Ñampipi rihushpankuna Jesuspa runankunaka tapunakurkakuna paykunapura: ¿Pishi ashwan yachak kan ñukanchipuramanta? nishpa. Kapernaum llaktapi paktashpankuna shuk wasipi yaykurkakuna. Ña wasipi kahushpankuna Jesuska paykunata tapurka: ¿Imatataya tapunakushpa shamuhurkankichi ñampipi? Chaypina pinkarishpankuna mana aynirkakunachu nima imata. ");
INSERT INTO qupNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Chaymanta Jesuska tiyarishpan chay chunka ishkay runankunata kayarka payta kayllayanankunapa. Kayllayashpankuna rimarka: Shutipa kankunapuramanta shuk ali kanayashpanka Yaya Diospa rikushkanpi, ama munachun kamachik tukunata, ashwan tukuy runa masinkunata yanapashpalla kawsanan tiyan. ");
INSERT INTO qupNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Chaypina Jesuska shuk wawata makinmanta apishpan chawpinkunapi shayachirka. Chay wawata ukllarishpan runankunata nirka: ");
INSERT INTO qupNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Maykanmi yuyawashpan shuk wawata yuyashpa wasinpi yaykuchin, chayka ñukatami yaykuchiwan. Maykanmi ñukata yaykuchiwan, chayka kachawak Yayayni Diostapas yaykuchinmi. ");
INSERT INTO qupNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Chaypi Juanka nirka: Yachachik, shuk runata rikushkanchimi supaykunata llukshichihukta, Jesuspa yachayninwami llukshichini nishpa. Mana ñukanchiwa pakta purik kashpan chay runata kunashkanchi manana chasna rurananpa. ");
INSERT INTO qupNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Chaypina Jesuska nirka: Ama chasna rimaychichu chay runata. Maykan runami yachayniwa chasna supaykunata llukshichin, chay runaka manami rimankachu mana ali kanaynita. ");
INSERT INTO qupNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Maykankunami ñukanchikunata mana chikninahunchu, chaykunaka ñukanchita ashwan yanapanahunmi. ");
INSERT INTO qupNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Maykanmi kankunata yakullatapas upyachishpanka ñuka Yaya Diospa Kachashkan Kishpichikta katiwahushkaykichirayku chay runataka Yaya Diosmi chasna rurashkanmanta kushichinka. ");
INSERT INTO qupNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ñukaka kankunata rimani: Maykanmi shuk wawa chayra katiwahukta uchata rurachin, paytaka Yaya Diosmi chaymanta ashwan sinchita kastiganka. Ashwan ali kama, kunkanpi atun rumiwa watashpa wichuy tukushpan chawpi yakupi, mana chay wawata uchata rurachinanpa. ");
INSERT INTO qupNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Imapas kanta uchata rurachinayashpanka sakiy. Makiki kanta uchata rurachinayashpanka pitishkashina mana kasushpa sakiy. Mana ishkanti makikiwa chay nina mana wañukma rinaykipa, ashwan alimi kama shuk makiyullashina Yaya Dioswa kawsanaykipa. ");
INSERT INTO qupNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Chakiki kanta uchata rurachinayashpanka pitishkashina mana kasushpa sakiy. Mana ishkanti chakikiwa chay nina mana wañukma rinaykipa, ashwan alimi kama shuk chakiyullashina Yaya Dioswa kawsanaykipa. ");
INSERT INTO qupNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","Chaymanta ñawikiwa imatapas rikushpayki uchata ruranayashpaykika ñawikita surkushkashina sakiy. Mana ishkanti ñawikiwa chay nina mana wañukma rinaykipa, ashwan ali kama shuk ñawiyullashina Yaya Diospa kamachishkan tukushpa paypa ali kamachihushkanpi kawsanaykipa. ");
INSERT INTO qupNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Mana yankachu kankunata rimashkani chay sinchi shimikunata. Imashnami ñukanchi aychata kachiwa alichanchi, ninapi chayachinchi mikunanchipa, alita wakaychananchipapas, chasnashinami Yaya Dioska kankunata ninashina parisinakunawa alichanan tiyan alillata rurashpa kawsanaykichipana. ");
INSERT INTO qupNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Shukwa shukwa yuyanakushpa kawsashpaykichika ali kachiwa kachincharishkashinami kankichi. Shuk ali kachi chamu tukushpan manana nima imarayku valinnachu. Chayrayku kuyrariychi yuyanakushpa, kushilla, shuk yuyayllawa kawsanaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Chay Kapernaum llaktamanta llukshishpankuna Jesuska runankunawa Judea allpama rirka. Chaymanta rirkakuna Jordán yaku chimpama. Chaypi paktashpankuna kutikashka achka runakuna tantarishpankuna Yaya Diospa shiminta yachachirka imashnami yachachipayan. ");
INSERT INTO qupNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Chaypi shuk fariseokunaka Jesusta pantachichinayashpankuna Yaya Diospa shiminmanta chikanta rimananpa nishpa, payta tapurkakuna: Shuk karika warminta sakishpanka ¿alichu kama? ");
INSERT INTO qupNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Payka aynirka: ¿Imatata Moiseska kankunata yachachirka? ");
INSERT INTO qupNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Paykunaka aynirkakuna: Moiseska ñukanchita yachachirkami, shuk karika warminta sakinayashpanka apunkunapa puntanpi shuk sakina killkata kushpanrami atipama sakinata nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesuska paykunata aynirka: Kankuna yapa millaypa shunkuyu kashpaykichimi Yaya Diosta mana kasunayashpaykichi Moiseska chasna kamachishkata killkarka. ");
INSERT INTO qupNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Puntiru Yaya Dioska siluta, punchata, allpata, tukuy imakunatapas rurahushpan karita warmitapas rurarka. ");
INSERT INTO qupNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ñawpamanta pacha kasnami killkarishka kan: Yaya Dios karita warmita rurashkanrayku tukuy kari shuk warmita apishpan yayanta mamanta sakinan tiyan warminwana tantaylla kawsananpa. ");
INSERT INTO qupNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Chasna tantanakushpankuna shuk aychashinallana kanahun Yaya Diospa rikushkanpika. Manana ishkaynachu kanahun nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Chasna Yaya Dios paykunata tantachishkanrayku mana alichu nima karika warminta, warmipas kusanta sakinanpa. ");
INSERT INTO qupNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Wasinkunama kutishpankuna runankunaka Jesusta chay rimashkanmanta tapurkakuna: ¿Imatataya yachachinayashkanki chay rimashkaykiwa? ");
INSERT INTO qupNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesuska aynirka: Shuk kari warminta sakishpanka shuk warmitana warmiyashpanka chasnaka uchatami ruran. ");
INSERT INTO qupNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Chasnallatatami shuk warmipas kusanta sakishpan shuk runatana kusayashpanka chasnaka uchatami ruran. ");
INSERT INTO qupNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Chaymanta shuk yayakunaka wawankunata Jesusma apamurkakuna, makinwa llankashpan Yaya Diosta paykunarayku mañananpa. Jesuspa runankunaka rikushpankuna piñarishpa paykunata arkarkakuna mana Jesusta kayllayanankunapa kasna nishpa: Ama wawaykichikunata Jesusma apamuychichu. Paytami killachinkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","15","Chayta rikushpan Jesuska piñarishpan rimarka: ¿Imaraykuta chasna rimankichi? Ashwan kayaychi wawakunata ñukama shamunankunapa. Ama chay wawakunata arkaychichu. Wawakunashina ñukapi sinchikuk ñukata kiriwak runakunallami Yaya Diospa kamachishkan tukushpa paypa ali kamachihushkanpi kawsankakuna. Alita uyawaychi. Maykanmi mana wawakunashina ñukata yuyawashpa kasuwan, chayka manami Yaya Diospa kamachishkan tukushpa paypa ali kamachihushkanpi kawsankachu. ");
INSERT INTO qupNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Chasna rimashpan Jesuska wawakunata shukllankama shukllankama kuyashpa markarka. Makinwa llankashpan rimarka Yayan Dios paykunata yanapashpa kushichinanta. ");
INSERT INTO qupNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesuska runankunawa shuk llaktama rihushpan shuk karika kallpashpa Jesuspa puntanpi kunkurik shamurka. Chaypi tapurka: Ali yachachik, rimaway ¿imashna rurashpaynita atipaynima Yaya Dioswa wiñaypa kawsanata? ");
INSERT INTO qupNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesuska aynirka: ¿Imaraykuta rimawanki ali kanaynita? Mana nima shuk ali runa tiyanchu. Yaya Diosllami ali kan. ");
INSERT INTO qupNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kanka ñami yachanki Yaya Diospa kamachishkankunata: Ama runa masikita wañuchiychu. Ama shuk warmiwa musayaychu. Ama shuwaychu. Nima pimanta llullashpa rimaychu. Ama nima pita llullachiychu. Yayaykita mamaykita yuyashpa kasushpa kawsay nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Chaypi chay karika aynirka: Yachachik, wawamanta pacha tukuy chay Yaya Diospa kamachishkanta kasushpa kawsashkani. ");
INSERT INTO qupNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Chaypina Jesuska payta kuyashpa rikushpan nirka: Alitami rurashkanki. Ashwan shukta Yaya Dioska munan ruranaykipa. Rantichikriy tukuy imaykikunata. Chay kullkitaka nima imayu runakunata kuy. Chasna rurashpaykimi silupi achka imayushina tukunki. Chasna rurashkaykiwasha shuti katiway. ");
INSERT INTO qupNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Chasna Jesús rimashpan chay runaka yapa llakirirka. Yapa achka imayu kashpan mana munarkachu tukuy imankunata rantichishpa kunata. Chayrayku llakirishpa wasinma kutirka. ");
INSERT INTO qupNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesuska washanma rikushpan runankunata rimarka: Maytukuy sinchita kan kay kullkiyukunaraykuka Yaya Diospa kamachishkankuna tukunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Chay shimita uyashpankuna runankunaka mancharirkakuna. Chaypi Jesuska kutikashka nirka: Wawkinikuna, sinchimi kan Yaya Diospa kamachishkan tukunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Shuk atun wiwa kamilluka manami atipamachu pasanata shuk aguhapa uchkunstuta. Chasnallatatami shuk runaka kullkinllapi yuyarishpanka manami atipankachu Yaya Diospa kamachishkan tukushpa paypa ali kamachihushkanpi kawsanata. ");
INSERT INTO qupNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Chasna Jesús rimashpan runankunaka ashwanta mancharishpankuna tapunakurkakuna: Chasna kashpanka ¿pishi atipanka kishpichiy tukunata Yaya Diospa ali kamachihushkanpi kawsananpa? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Chaypi Jesuska alita rikushpan paykunata nirka: Nima pi atipanchu kishpichirinata pay kikinta. Yaya Diosllami atipan runakunata kishpichinata paypa ali kamachihushkanpi kawsanankunapa. Payllami yachayninwa atipan tukuyta ruranata. ");
INSERT INTO qupNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Chaypina Pedroka rimarka: Ñukanchika sakishkanchimi tukuy ñukanchipa tiyashkanta kanta katinanchiranti. ");
INSERT INTO qupNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Jesuska aynirka: Alita uyawaychi. Shuk runa ñukata katiwahushkanrayku, ñuka kishpichik kanaynita yachachihushkanrayku wasinta, wawkinkunata, paninkunata, turinkunata, ñañankunata, mamanta, yayanta, wawankunata, chakrankunatapas sakishpanka Yaya Diosmi payta kunka sakishkanmanta ashwan achka wasinkunata, wawkinkunata, paninkunata, turinkunata, ñañankunata, mamankunata, wawankunata, chakrankunatapas. Kay allpapi kawsahushpaykichira chasna kuy tukuna kashpaykichipas chayka kankami runakuna kankunata chiknishpa parisichihushkankunapi. Chaymanta chay chapahushkaykichi mushu mundupi wiñaypa Yaya Dioswa kawsankichina. ");
INSERT INTO qupNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kunanka shukkuna maykankunami paykuna kikinkunamanta yuyarinahun, tukuymanta ashwan ali kanankunata, shuk punchami paykunaka yapa pinkarinkakuna. Shukkunaka maykankunami runakunapa rikushkanpi mana ali kanankunata rikurinahun, paykunataka Yaya Diosmi rimanka yapa ali kanankunata. ");
INSERT INTO qupNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jerusalén llaktama rihushpankuna Jesuska runankunata ñawparka. Paykunaka washanlla mancharishpa llakirishpa katirkakuna, Jerusalenpi kawsak runakunaka Jesusta chikninankunata yuyarishpankuna. Shuk payta katikkunapas manchaywa katirkakuna. Chaypina Jesuska chay chunka ishkay runankunata chaynikstuma pushashpan rimarka payta wañuchinankunamanta. ");
INSERT INTO qupNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Kasnami nirka: Ñami yachankichi Jerusalén llaktama rihushkanchita. Chaypi chiknik runakunaka ñuka Yaya Diospa Kachashkan Runata apiwankakuna saserdotekunapa apunkunata, Moisespa killkashkanta yachachikkunatapas kuwanankunapa. Chaypina paykunaka tantarishpankuna shuk yuyayllawa ñukata wañuchiwanayankakuna. Chasna wañuchiwanayashpankuna romano runakunata kuwankakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Paykunaka yapa asichiwankakuna, tyukawankakuna, sinchita asutiwankakuna, chaymanta wañuchiwankakuna. Chasna wañuchiwashpankunapas kimsa punchamantami kawsarisha. ");
INSERT INTO qupNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Chaypi Sebedeopa wawankuna Santiago Juanpas Jesusta kayllayashpankuna rimarkakuna: Yachachik, kanta tapunayanchi ¿atipankimachu ñukanchita yanapanata shuk imawa? ");
INSERT INTO qupNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Payka aynirka: Rimawaychi ¿imawata munankichi yanapanaynita? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Paykunaka tapurkakuna: Kan tukuy runakunata suma atun yachaykiwa kamachihushpayki ñukanchita tiyachiy kuchuykipi ñukanchipas kanwa pakta parihu kamachinanchipa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesuska aynirka: Kankunaka mana alita yachashpaykichi chayta tapuwahunkichi. Ñukaka achkatami parisinayni tiyan wañunaynikama. Imashnami bawtisarishpanchi yakuka awanchipi taparik shamun, chasnashinami parisinakunaka ñukapi tapakta shamunka wañuhushkaynipi. ¿Atipankichimachu ñukashina awantanata chay tukuy parisinakunata wañunaykichikama? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Paykunaka aynirkakuna: Ari, atipashunmi awantanata. Jesuska rimarka: Ari, kankunapas ñukashina achkata parisinaykichi tiyan. ");
INSERT INTO qupNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Chasna parisishpaykichipas ñukaka manami akllashanchu pimi kuchuynipi tiyarik kanka ñukawa pakta atun kamachik kananpa. Yayayni Diosllami akllanka maykankunami kuchuynipi tiyarik kankakuna nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Chaymanta chay chunka Jesusta katik masinkunaka uyashpankuna Santiago Juanpas paykunamanta pasa tukunayashkankunata, paykunata yapa piñarirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Chasna piñarihushkankunata rikushpan Jesuska tukuy paykunata kayashpan rimarka: Kankunaka alita yachankichi, kay allpapi atun allpakunapi kamachik atun apukuna kamachinanpi kawsak runakunapa amunkuna kanankunata yuyarinahun. Runakunata yapa manchachishpankuna sinchita kamachinahun. Kamachinanpi kawsak runakunata mana yuyashpankuna parisichishpa kasuchinahun kamachik kani nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kankuna Yaya Diospa shiminta kasukkunaka, ama chasna kanayaychichu. Shukkunamanta pasa kanayashpaykichika tukuy runa masikichikunata yanapashpa kawsaychi. ");
INSERT INTO qupNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kankuna tukuymanta ashwan yachak kanayashpaykichika tukuy runa masikichikunata kasushpa kawsaychi. ");
INSERT INTO qupNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ñuka Yaya Diospa Kachashkan Runapas kay allpama shamushpayni mana shamushkanichu runakuna sirviwanankunapa. Ashwan shamushkanimi tukuy runakunata yanapanaynipa. Shamushkanimi achka runakunaranti wañushpayni kastigarina kashkankunamanta kishpichinaynipa. ");
INSERT INTO qupNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Chaymanta Jesuska runankunawa, achka runakunawapas rishpan Jerikó llaktapi paktak rirkakuna. Chay Jerikó llaktamanta llukshihushpankuna shuk wisku runa ñampi mayanpi tiyahurka. Payka Timeopa wawan, Bartimeo shutiyu karka. Wisku kashkanrayku pasahukkunata kullkita tapushpa kapayan. ");
INSERT INTO qupNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Achka runakuna pasahushpankuna kwintahushkankunamanta yacharka Nasaretmanta Jesús chaypi pasahushkanta. Chayta uyashpan sinchita kaparishpa rimarka: ¡Jesús, Davidpa Miraymanta Kishpichik, llakichiway! ");
INSERT INTO qupNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Chasna sinchita kaparishpan achka runakunaka killarishpankuna chunllayay nirkakuna. Chasna nishpankunatata payka ashwan sinchita kaparirka: ¡Davidpa Miraymanta Kishpichik, llakichiway! ");
INSERT INTO qupNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Chaypina Jesuska rihushkanmanta shayarishpan nirka: Chay runata pushamuychi. Chaypi chay wisku runata kayashpankuna nirkakuna: Sinchikuy. Atariy. Jesusmi kanta kayahun. ");
INSERT INTO qupNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Chay ratulla chay wiskuka awaniru churarinanta allpama wichumushpan utkalla Jesusta kayllayak rirka. ");
INSERT INTO qupNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Chaypina Jesuska tapurka: ¿Imatata munanki kanrayku ruranaynipa? Chay wiskuka aynirka: Yachachik, ñawinita ampipay atipanaynipa rikunata. ");
INSERT INTO qupNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Chaypina Jesuska aynirka: Ñukapi sinchikurishkaykiraykumi ampirishkanki. Kunanka riylla. Chasna rimashkanllawa Bartimeoka atiparka rikunata. Kushikushpana Jesusta katirka. ");
INSERT INTO qupNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Chaypi Jesuska runankunawa Jerusalén llaktama rihushpan shuk urku Olivos shutiyu mayanpi paktarkakuna. Chay urkuka karka Betfagé, Betania llaktakunapa kuchunpi. Chay Olivos urku mayanpi paktashpankuna Jesuska runankunamanta ishkayta kacharka kasna nishpa: ");
INSERT INTO qupNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Chay rikuhushkaykichi llaktama riychi. Chaypi paktashpaykichi tarinkichi shuk malta burru watarishkata, maykanpimi nima shuk runa purishkarachu. Chay malta burruta paskashpaykichi apamuychi. ");
INSERT INTO qupNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Shuk runa kankunata mitsashpan tapushpanka ¿imaraykutaya apahunkichi kay burruta? nishpa, payta rimaychi: Yayanchi Jesusmi munahun awanpi tiyarishpa rinanpa. Kunanllatatami kutichik shamushu nishpa rimankichi. ");
INSERT INTO qupNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Paykunaka rishpankuna paypa nishkanshina shuk malta burru watarishkata shuk wasi punku mayanpi tarik rirkakuna. Chayta paskarkakuna apanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Chasna paskahushpankuna chaypi kahuk runakunaka nirkakuna: ¿Imatata rurahunkichi? ¿Imaraykuta paskahunkichi chay malta burruta? ");
INSERT INTO qupNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Chaypi paykunaka aynirkakuna Jesuspa rimashkantashina. Chayta uyashpankuna chay runakunaka apaychi nirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Chaymanta chay malta burruta Jesusma aparkakuna. Chay burru awapi churarinankunata mantarkakuna. Chay awapi Jesuska tiyarishpan rirka. ");
INSERT INTO qupNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Achka runakuna payta rikushpankuna kushikushpa churarinankunata puntanpi mantarkakuna. Shukkunaka chipati pankakunata pitishpankuna puntanpi mantarkakuna ñampita sumayachishpa atun aputashina yaykuchinankunapa. Chay churashkankuna awata Jesuska burrupi tiyashpa rirka. ");
INSERT INTO qupNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Chay Jerusalén llaktama rihushpankuna chay Jesuspa puntanpi rihuk runakuna, washanmanta katik runakunapas yapa kushikushpa kaparirkakuna: ¡Akuychi payta kushichishunchi! Yaya Diospa alita rikushkan yanapashkan runami kan. Yaya Diospa munashkanta rurananpa kachashkan kashpanmi shamuhun. ");
INSERT INTO qupNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Yaya Diosmi payta yuyashpan yachayninta kushpan kachamushka ñukanchikunata alita kamachinanpa ñawpa yaya rukunchi atun apu Davidshina. Akuychi kushichishunchi awa silupi kawsak Yaya Diosta. ");
INSERT INTO qupNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Chaypi chay achka runakuna kushikushpa kaparishpankuna Jesuska chay Jerusalén llaktapi yaykurka. Chay llaktapi yaykushpan Yaya Diospa wasinma rirka. Chay wasipi yaykushpan tukuyta muyukta rikurka. Chaymanta ña chishiyahushpanna chunka ishkay runankunawa kuchupi kahuk Betania llaktama rirka. ");
INSERT INTO qupNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kayantima Jesuska runankunawa chay Betania llaktamanta llukshishpan yarkaywa karka. ");
INSERT INTO qupNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Chasna yarkaywa kahushpan karumanta shuk igu kaspi pankayuta rikurka. Chayta rikushpan alita rikunanpa kayllayarka, pakta muyuyu kahun nishpa. Chaypi paktashpan nima shuk muyuta tarirkachu, mana muyuyanan uraschu karka. ");
INSERT INTO qupNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Chasna mana muyuyuta rikushpan Jesuska chay igu kaspita nirka: Nima ima uras kuti muyuyankichu. Nima maykan muyuykita kutikashka mikunkachu. Chasna Jesuspa rimashkanta tukuy runankunaka uyarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Chaymanta Jesuska tukuy runankunawa rishpan Jerusalén llaktapi paktak rirkakuna. Chaypi Yaya Diospa wasinpi yaykurka. Chay wasipi puntiru atun pampa kincharishkapi achka rantichihuk runakuna, rantihuk runakunapas karkakuna. Chaymanta tiyarka kullkita kampyakkuna. Tukuy chaykunata rikushpan Jesuska kullkita kampyakkunapa mesankunata, wiwa mukukukunata rantichikkunapa mesankunatapas pultyachi pultyachi rurashpan amunkunata tukuy rantik runakunawa pakta kamachirka llukshinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Chaymantapas Jesuska manana munarkachu nima pi shuk ima rantichinakunawa chay Yaya Diospa wasinta pitikta pasanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Chaypina yachachirka kasna nishpa: Yaya Dioska killkachishkanpi riman: Kay wasinika tukuy llaktakunamanta runakuna ñukata mañanankuna wasinimi kan nishpa. Kankunaka kay Yaya Diospa wasinta shuwakunapa kushilla tantarinatashina rurashkankichi. Chasna Jesuska rimashpan paykuna chaypi achkata kobrashpa kullkita kampyahushkankunarayku rantichihushkankunaraykupas shuwakunashina kanankunata yuyachirka. ");
INSERT INTO qupNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Chayta uyashpankuna saserdotekunapa apunkuna, Moisespa killkashkanta yachachikkunapas tapunakurkakuna paykunapura: ¿Imashna rurashpashi wañuchinchima kay runata? nishpa. Chay chiknik runakuna payta wañuchinayashpankunatata mancharkakuna chasna ruranata, achka runakuna yachachihushkanta yapa munashkankunarayku. ");
INSERT INTO qupNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ña tutayahushpanna runankunawa chay Jerusalén llaktamanta llukshirka, imashnami tukuy uras rurapayanahun. ");
INSERT INTO qupNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kayantima tutamanta kutihushpankuna Jerusalén llaktama, ñampipi chay Jesús rimashkan igu kaspita rikurkakuna sapinmanta pacha chakirishkata. ");
INSERT INTO qupNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Chay igu kaspi mana muyuyuta rikushpan Pedroka Jesuspa rimashkanta yuyarirka. Chaypina Jesusta rimarka: Yachachik, rikuy kay igu kaspita, maykantami kayna rimarkanki chakirichun nishpa. Kunanka ña chakirishka. ");
INSERT INTO qupNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Chaypi Jesuska aynirka: Yaya Diosta kiriychi. ");
INSERT INTO qupNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kankunata rimani, tukuy shunkuykichimanta pacha Yaya Diosta kirishpaykichimi kankunapas atipankichima ñukashina ruranata. Kay urkuta rimankichima, kaymanta warankarishpayki atun yakuma chinkariy nishpa. Tukuy shunkuykichimanta pacha Yaya Diosta kirishpa chayta rimashpaykichika kay urkuka warankarimami. Ama yuyariychichu warankarinkachu manachu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Chayrayku kankunata rimani, imatapas tukuy shunkumanta pacha Yaya Diosta tapushpa ña apishkanimi nishpa kirishpaykichika kuy tukunkichimi. ");
INSERT INTO qupNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Chaymanta manara Yaya Diosta mañahushpaykichi runa masikichita mana ali rurashkankunamanta llakichinaykichi tiyan. Shuk runa masiki kanta chiknihushpanpas imatapas kanta ruray tukushpaykika manana yuyariynachu. Chasna rurashpaykimi Yaya Diospas kanta uchaykikunamanta llakichinka, manana yuyarinkanachu. ");
INSERT INTO qupNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Chaymanta ña Jerusalén llaktama kutishpankuna kuti Yaya Diospa wasinpi yaykurkakuna. Chay ukupi purihushpankuna saserdotekunapa apunkuna, Moisespa killkashkanta yachachikkuna, ñukanchita kamachik israel masinchi rukukunapas Jesusta kayllayarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Chaypi payta tapurkakuna: ¿Pita kanta kamachishka chay rantichihuk runakunata wichunaykipa kay Yaya Diospa wasinmanta? ¿Pita kanta kamachishka chasna yachachinaykipa? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Chaypi Jesuska aynirka: Ñukapas shukta tapushkaykichi. Alita ayniwashpaykichika ñukapas rimashkaykichi pimi kachawashka. ");
INSERT INTO qupNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Pitaya Juantaka kacharka bawtisananpa? ¿Yaya Dioschu, pay kikinchu yuyarishpa shamurka? Ayniwaychi. ");
INSERT INTO qupNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Chaypi chay runakunaka tapunakurkakuna paykunapura imatami ayninkakuna nishpa. Yaya Diosmi Juantaka kacharka nishpanchika Jesuska ñukanchita rimankami, Yaya Dios payta kachashka kashpanka ¿imaraykutaya payta mana kasushkankichichu? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Aynishpanchika pay kikinllami yuyarishpa Juanka yachachirka nishpa, tukuy runakuna yapa piñarinkakuna. Paykunaka kirinahun kay Juan wañuka shutipa Yaya Diospa yachayninwa yachachik kashkanta. ");
INSERT INTO qupNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Chasna tapunakushpankuna Jesusta aynirkakuna: Mana yachanchichu pimi Juanta kacharka nishpa. Chaypina Jesuska aynirka: Chasna kashpanka ñukapas mana rimashkaykichichu pimi kachawashka tukuy kaykunata ruranaynipa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Chaymanta Jesuska tukuy chay runakunata shuk yachachinawa yachachirka kasna nishpa: Tiyarka shuk chakrayu runa. Chay runaka chakranpi uva wiñarishkakunata tarpuchishkanwasha rumikunawa muyukta kinchachirka. Chaymanta shuk atun batanta rurarka chaypi uva muyukunata sarushpa chawanankunapa. Chaymanta rumikunawa shuk yapa awa wasistuta rurachirka shuk runa awamanta rikushpan chakranta kuyrananpa, mana nima pi chay tarpunpa muyunkunata shuwananpa. Chaymanta chay amunka uva chakranta shuk tarawak runakunata kurka amunshina pichashpa kuyranankunapa. Chasna kushpan rimarka: Kay uva chakraynita pichashpa kuyrapankichi kutimunaynikama. Pallashpaykichi tukuy muyunkunamanta chawpita kuwankichi. Chasna rimashpan chay amunka shuk karu llaktama rirka. ");
INSERT INTO qupNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ña chay uvakunata pallanankuna uras paktarishpan chay amunka shuk runanta kacharka chay chakranpi tarawahukkunata rimak rinanpa patronchimi kachawashka uva muyukunata pallashkaykichimanta chawpita kuwanaykichipa payrayku apanaynipa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Chay runaka uva muyuta apanapa rishpan chay tarawakkunaka mana nima shukta kurkakunachu. Makashpankuna shinallata kacharkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Chaymanta chay patroyninka kuti shuk runantana kacharka uva muyukunata tapuk rinanpa. Paytapas chasnallatata mana kasushpankuna millaypata rimashpa pinkachirkakuna. Chaymanta umanpi waktashpa yawarsapata kacharkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Chasna kashpanpas kuti shuk runantana kacharka. Chaytaka wañuchirkakunana. Chaymanta mana sakishpa ashwan runankunata kacharka. Shukkunataka makarkakuna, shukkunataka wañuchirkakunana. ");
INSERT INTO qupNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Chaymanta shuklla kiparirka, tukuy shunkunmanta pacha shuklla munashkan kari wawanllana. Chaypina payta kacharka yuyarishpan kay wawaynita shuti manchashpankuna kasunkakuna nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Payta rikushpankunana chay tarawakkunaka kwintarkakuna paykunapura: Rikuychi, kay shamuhuk runami chakra amupa wawan. Yayan wañushpan kay chakraka payraykunami kiparinka. Akuychi kunalla wañuchishunchi, tukuy kay uva chakraka ñukanchipana kananpa. ");
INSERT INTO qupNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Chaypina payta apishpankuna wañuchirkakuna. Wañuchishkankunawashana chakra mayanma wichurkakuna. Chasna Jesuska payta chiknik runakunataka ñawpa Yaya Diospa kachashkan yachachikkunata rurashkankunamanta payta wañuchinankunamantapas uyachishpa yachachirka. ");
INSERT INTO qupNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Chaymanta Jesuska nirka: Kunanka yuyariychi. ¿Imanachimashi wañuchik runakunataka chay chakra amuka? Kankunata rimani, chay uva chakrama kutishpanka chay tarawakkunataka wañuchinkami. Chaywasha chay chakrantaka kunkami shuk runakunatana. ");
INSERT INTO qupNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Chaymanta Jesuska shuk yachachinawa chasnallatata yachachishpalla katirka: ¿Manachu yachakushkankichi alita Yaya Diospa ñawpa killkachishkanta? Kasnami nin: Shuk runa wasinta rumimanta rurashpan tarawak runankunaka shuk ali sinchi rumita mana munashpankuna mayanpi churarkakuna mana alichu nishpankuna. Chay rumitaka wasinta rurak runaka akllashpan churarka chay wasinpi shuk orkonshina sinchikuchik kananpa. ");
INSERT INTO qupNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Chasnallatatami Yaya Dioska akllashkan runawa ruranka. Ñukanchika chayta rikushpanchi yapa alimi kan nishpa rimanchi. ");
INSERT INTO qupNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Chaypina Jesusta chiknik runakunaka yapa piñarishpankuna kwintarkakuna paykunapura: Jesuska kay rimahushkanwa rimay tukuhunchi chay runakuna mana amunta kasunayakkunatashina. Chasnallatatami kay rimahushkanwa rimay tukuhunchi chay ali rumita wichuk runakunatashina nishpa. Chayrayku piñarishpankuna Jesusta apichinayarkakuna wañuchichinankunapa. Chasna ruranayashpankunapas chay achka Jesusta uyak runakunata manchashpankuna Jesusta sakishpankunana kutirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Chaymanta ñukanchi israel runakunapa apunchikunaka Jesusta chiknishpa wañuchichinayashpankuna fariseokunata, apu Herodesta katikkunatapas Jesusma kacharkakuna payta shuk nima ayniypata tapunawa pantachichinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Chay kachashkan runakunaka Jesuspi paktashpankuna alishina tukushpa nirkakuna: Yachachik, yachanchi mana llullachishpa shutipa kashkata rimanaykita. Tukuy runakunata alita yachachinki Yaya Diospa munashkanta rurashpa kawsanankunapa. Kanmi mana manchashpachu nima shuk runata, nima apukunata, tukuyta kuskata yachachinki. Kunanka ñukanchita rimay. ¿Alichu manachu ñukanchi israel runakunaka chay romano tukuymanta atun aputa impuestuta pagananchipa? ¿Yaya Dios munanchu pagananchipa manachu? Kutikashka tapuk shamushpankuna ¿paganchimachu manachu? ");
INSERT INTO qupNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesuska chay runakuna alishina tukushpa payta apichinayahushkankunata riksirka. Ari, pagananchi tiyan nishpa aynimaka, ñukanchi israel runakunamanta apukunata rimak rinahuma payta kastiganankunapa. Mana alichu pagananchipa nishpa aynimaka, romano apunchita rimak rinahuma payta kastigananpa. Chasna yuyarihushkankunata riksishpan paykunata aynirka: ¿Imaraykuta apichiwanayashpa tapuwankichi? Rikuchiwaychi chay paganaykichi kullkita. ");
INSERT INTO qupNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Chasna nishpan shuk kullkita payta rikuchirkakuna. Chay kullkita Jesuska rikushpan nirka: ¿Pipa almantata kay kullkipi rikunkichi? ¿Pipa shutinta kay kullkipi killkarishka kan? Paykunaka aynirkakuna: Romano tukuymanta atun apupami. ");
INSERT INTO qupNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Chasna aynishpankuna Jesuska paykunata rimarka: Chay atun apupa kashkantaka kuychi amunta. Maykanmi Yaya Diospa kan, kuychi payta. Yaya Dios runakunata rurashkanrayku paykunapa amun kan. Chayrayku tukuy shunkuykichimanta pacha payta yuyashpa kawsaychi. Chasna yapa yachaywa aynishkanta uyashpankuna chay runakunaka yapa mancharirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Chaymanta shuk saduseokuna Jesuswa kwintak rirkakuna. Paykunaka yachachinahun wañushpanchi manana kawsarishunchinachu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Chayrayku Jesusta kayllayashpankuna tapurkakuna: Yachachik, ñawpa Moisés wañuka ñukanchirayku killkarka: Shuk warmiyu runa manara wawayu wañushpanka wawkinna chay kachuynin mashintuta warmiyanan tiyan atipananpa wawayanata. Chaypina kari wawata wawayashpanka chay wawkin wañupa wawanshina kanan tiyan nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kunan kanta kwintanayanchi: Tiyarka kanchis wawkikuna. Shuk puncha puntiru wawkika warmiyarka. Manara nima shuk wawayu kashpanra wañurka. ");
INSERT INTO qupNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Chaymanta Moisespa killkashkanta kasushpan ishkaynin wawkina kachuynin mashintuta warmiyarka. Chay wawkipas chasnallatata nima shuk wawayu wañurka. Chaymanta kimsaynin wawkina chay kachuyninllatata warmiyarka. Paypas chasnallatata nima shuk wawayuchu wañurka. ");
INSERT INTO qupNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Chay shuk wawkikunapas chay warmillata warmiyarkakuna. Tukuy paykuna nima shuk wawayuchu wañurkakuna. Chaymanta chay warmipas wañurkana. ");
INSERT INTO qupNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kunanka ñukanchita rimay. Chay kanchis wawkikuna chay warmillatata warmiyarkakuna. Wañushka runakuna kawsarimunankuna uras chay kanchis wawkikunamanta ¿maykanpa warminshi kama? ");
INSERT INTO qupNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Chaypina Jesuska aynirka: Kankuna kikintami llullachirinkichi, wañushkakuna kawsarinankunata mana kirishkaykichirayku. Yaya Diospa killkachishkanta yachashpaykichitata manami asirtankichichu. Yaya Diostapas mana riksinkichichu, yachayninwa wañushkakunata kawsachikta. ");
INSERT INTO qupNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wañushkakunaka kawsarimushpankuna nima shuk kari warmiyankanachu, nima shuk warmi kusayankanachu. Silupi kawsak angelkunashinami tukuy kawsankakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Yaya Dios wañushkakunata kawsachinanta yachakunaykichipa ¿manachu leyishkankichi ñawpa Moisespa killkashkanta? Yaya Dios payta shuk uchilla kaspi sintihukmanta kasna rimarka: Ñuka kani Yaya Dios, maykantami Abraham, Isaak, Jakob kushichiwanahun nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Chasna Yaya Dios chay uras ña wañushka yaya rukunchikunamanta rimashpan yachanchi wañushpankunapas paywa pakta kawsa kahushkankunata. Kawsakunallami Yaya Diosta kushichinahun, wañushkakunaka mana payta kushichinahunchu. Chayrayku kankunata rimani, manana kawsarimushunchinachu nishpaykichika llullachirishka kankichi. ");
INSERT INTO qupNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Chaypi Moisespa killkashkanta shuk yachachik kayllayashpan chay saduseokuna Jesuswa rimanakuhushkankunata uyarka. Jesuspa alita aynihushkanta uyashpan payta tapurka: ¿Maykantaya tukuy Yaya Diospa kamachishkankunamanta ashwan ali kan? ");
INSERT INTO qupNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesuska aynirka: Chay tukuy Yaya Diospa kamachishkankunamanta ashwan ali kamachishkanka kan: Alita uyawaychi Yaya Diospa akllashkan runakuna. Yayanchi Dioska shukllami kan. Mana tiyanchu shuk ashwan paymantaka. ");
INSERT INTO qupNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Pay shuklla Yaya Dios kashpan tukuy shunkuykimanta pacha payta yuyashpa munashpa kawsay. Payta yuyahushpayki alikunata yuyarishpa rurashpa kawsay. Tukuy atipanaykiwa payrayku kawsay nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Chaymanta chay ishkaynin Yaya Diospa kamachishkanka kasnami nin: Runa masikita yuyay kan kikitashina. Kay ishkaymi tukuy Yaya Diospa kamachishkankunamanta ashwan ali kanahun kasunaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Chaypi chay runaka aynirka: Alimi Yachachik. Shutipatami rimashkanki shuk Yaya Diosllami tiyan, manami ashwan shuk Yaya Dioska tiyanchu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Chaymanta yachanchi, ñukanchi Yaya Diosta tukuy shunkunchimanta pacha yuyashpanchika chaymantapas runa masinchikunata ñukanchi kikintashina yuyashpanchika chasna shuti Yaya Diosta alita kushichinchi. Yaya Diosta runa masinchitapas yuyanaka wiwakunata wañuchishpa rupachinamanta, imatapas Yaya Diosta kuna kashkanchimanta ashwan alimi. ");
INSERT INTO qupNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Chay Moisespa killkashkanta yachachikka chasna alita aynishpan Jesuska rimarka: Chasna alita yuyarishkaykirayku uchillastu pishin Yaya Diospa kamachishkan tukunaykipa. Chasna tukuyta alita aynishkanta uyashpankuna nima maykan munarkanachu pantachichinayashpa Jesusta tapunata. ");
INSERT INTO qupNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Chaymanta Jesuska Yaya Diospa wasinpi chay achka runakuna tantarishkakunata yachachihushkanpi tapurka: ¿Imashna yuyarishpankunataya Moisespa killkashkanta yachachikkunaka yachachinahun, Yaya Diospa Kachanan Kishpichik atun apu David wañupa miraymanta kananta? ");
INSERT INTO qupNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Yaya Diospa Espíritun chay David wañuta yuyachishpan chay shamunan kishpichikta yuyarishpa rimarka: Yaya Dioska chay kamachiwakta rimarka: Tiyariy kuskayni parti kamachinaykipa ñukawa pakta, tukuy kanta chiknik runakunata winsinaynikama kanta kasunankunapana nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David kikin Yaya Diospa Kachanan Kishpichikta yuyarishpa kamachiwak nirka. Chay uras ña kawsa paymanta pasa kashpan David unay wañushkanwasha paypa miraymantallatata kashpan manami atipanchu runalla kanata. Tukuy chay achka chaypi kahuk runakunaka kushikushpa chay ali yachachihushkanta uyarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Chaymanta Jesuska yachachihushkanllapi rimarka: Ama kankunaka chay Moisespa killkashkanta yachachikkunamanta llullachirishka kaychichu. Paykunaka yapa munanahun tukuy runakuna paykunata aputashina saludanankunapa. Chayrayku suma suni churarishkankunawa purinahun, ñampikunapi plasakunapi runakuna saludanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Tantarinanchi wasikunapi, mikunakunapipas tukuymanta suma tiyarinakunapi tiyarinahun, runa masinkuna paykunata aputashina rikunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Mana pinkashpa mashintukunata tukuy imankunata llullachishpa tapunahun paykuna kikinrayku, Yaya Diosta kushichinaykichipa kunaykichi tiyan nishpankuna. Mana ali rurak kashkankunata pakanankunapa tantarinanchi wasikunapi ali rurak runakunashina Yaya Diosta unayta mañanahun. Chasna kashpankuna Yaya Dioska paykunataka tukuy runakunamanta ashwan sinchitami kastiganka. ");
INSERT INTO qupNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Shuk puncha Jesuska chay Yaya Diospa wasin punkupi tiyahurka. Kuchunpi tiyarka shuk kullkita churana kaha. Chaypi runakunaka Yaya Diosta kushpa kullkinkunata churahurkakuna. Chaypi Jesuska chay runakuna kullkinkunata churahukkunata rikuhurka. Achka kullkiyu runakuna achka kullkita churahurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Chasnapi shuk mashintu nima imayu paktamurka. Paypas chay kahapi ishkay kullkinstuta churarka. ");
INSERT INTO qupNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Chaypina Jesuska runankunata kayashpan nirka: Rikuychi. Kay mashintu nima imayuka chay ishkay kullkinstuta churashpan Yaya Diospa rikushkanpi tukuy churahuk runakunamanta ashwantami kushka. ");
INSERT INTO qupNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tukuy kay achka kullkiyu runakunaka kullkinkuna puchurishkanmantalla kushkakuna. Chay mashintu nima imayuka tukuy tiyapushkanta Yaya Diosta kushka, maykanwami mikunanta rantinan karka. Chayrayku payka Yaya Diosta ashwanta kushichin. ");
INSERT INTO qupNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Chay Yaya Diospa wasinmanta Jesuska runankunawa llukshishpan shuk runanka nirka: Yachachik, rikuy kay atun Yaya Diospa wasinta. Imashna suma rumikunawa rurarishkata kan. ");
INSERT INTO qupNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Chaypina Jesuska aynirka: Ama kay suma atun wasikunata rikushpa kushikuychichu. Kunallapami rikuhunkichi. Kuntraykichikunami tukuy kay wasikunata urmachik shamunkakuna. Nima shuk wasi, nima shuk rumi awapura rurarishkaka kiparinkachu. ");
INSERT INTO qupNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Chaymanta Jesuska runankunawa Olivos urkuma rirka. Chay urkuka karka Yaya Diospa wasin chimpapura. Chay urkupi paktashpankuna tiyarirkakuna. Chaypi Pedro, Santiago, Juan, Andrés Jesusta kayllayashpankuna pakalla tapurkakuna: ");
INSERT INTO qupNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Yachachik, ¿ima urastaya Yaya Diospa wasinta urmachinkakuna? ¿Imata rikushpanchita yachanchima chay puncha paktarihushkanta? ");
INSERT INTO qupNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesuska aynirka: Kuyrariychi nima pi kankunata llullachinanpa. ");
INSERT INTO qupNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Manara kutimuhushpaynira achka runakunami shamunkakuna, kankunata llullachishpa rimankakuna ñukami kani Yaya Diospa Kachashkan Kishpichik nishpa. Chasna llullashpankunami achka runakunata kirichinkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Uyashpaykichika runakuna chikninakushpa kaypi chayma wañunakuhukkunata ama mancharinkichichu. Tukuy chaykunami pasanan tiyan. Wañunakushpa kawsahushpankunapas chay uras kay allpaka manarami tukurinkarachu. ");
INSERT INTO qupNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Shuk shimita rimakkuna shuk shimita rimakkunawa chikninakushpankuna wañunakunkakuna. Shuk allpapi kawsak runakuna shuk allpapi kawsak runakunawa chikninakushpankuna wañunakunkakuna. Tukuy parti allpa kuyuyka tiyanka, chaymantapas sinchi yarkay. Tukuy chaykuna kanka kallarinanlla. Chaywasha ashwan manchaypakunami tiyanka. ");
INSERT INTO qupNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Yuyaywa kaychi. Chiknik runakunaka kankunata apishpa pushankakuna apukunama kastigachinankunapa. Tantarinaykichi wasikunapi kankunata asutichinkakuna. Ñukata katiwahushkaykichiraykumi chiknik runakunaka kankunata apishpa pushankakuna atun apukunamapas. Chasna apirishka tukushpaykichi tukuy paykunata yachachishkaynita riksichinaykichi tiyan. ");
INSERT INTO qupNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Manara kay allpa tukurihushpanra tukuy allpakunapi kawsak runakunata Yaya Diospa suma ali shiminta runakunata kishpichinanmanta yachachinaykichi tiyan. ");
INSERT INTO qupNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Chay apukunama kankunata pushashpankunaka ama mancharinkichichu, imatashi rimasha, imashnashi aynisha nishpa. Yaya Diospa Espiritunmi kankunata chayllapi yuyachinka imatami rimanaykichi tiyan. Paypa yachachishkantami rimanaykichi tiyan, manami kankuna kikinpa yuyaykichimantachu rimankichi. ");
INSERT INTO qupNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Chay parisina punchakuna chiknik runakunaka kikin wawkinkunata yanka llullashpa apukunama pushankakuna wañuchichinankunapa, chaymantapas yayakuna wawankunata. Wawakuna yapa piña tukushpankuna yayankunata apichinkakuna wañuchichinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tukuy runakuna kankunatapas chikninkakunami ñukata kasushpa kawsahushkaykichirayku. Kankunata chiknishpankunapas wañunaykichi punchakama ñukata kirishpa kawsashpaykichika Yaya Diosmi kankunata chay atun kastigananmanta kishpichinka paywa pakta silupi kawsanaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yaya Diosta chiknik runaka Yaya Diospa wasinpi yapa millaypata rurashkanta rikushpaykichi kay leyishkaykichi shimita yuyariychi alita asirtanaykichipa. Chaypina tukuy kankuna Judea allpa llaktakunapi kawsakkunaka utkalla urkukunama mitikuychi. ");
INSERT INTO qupNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Wasi awapi kahushpaykichika chaymantalla utkalla mitikuychi. Ama ukuma uraykuychinachu shuk imaykichi tiyashkanta apanaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Chakraykichipi tarawahushpaykichika chaymantalla mitikuychi. Ama wasikichima kutiychinachu shuk churarinaykichita apak rinaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Chasna mitikuna punchakunapi, yapa llakiypa kanka chay chichu warmikunarayku, chay llullu wawayu warmikunaraykupas. ");
INSERT INTO qupNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Yaya Diosta mañaychi chay mitikunaykichi punchakuna mana chiri tamya punchakuna kananpa. ");
INSERT INTO qupNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Chay punchakunapi tukuy runakuna sinchita parisinkakuna. Yaya Dioska allpata rurashkanmanta pacha manami chasna sinchi parisina tiyarkachu. Nima chaywasha chasna sinchi parisinakunaka tiyankanachu. ");
INSERT INTO qupNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Yaya Dioska tukuy akllashkan runakunata yuyashkanrayku chay parisina punchakunataka uchillayachinkami. Mana chasna uchillayachimaka, nima shuk runa wañuymanta kishpimachu. ");
INSERT INTO qupNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Chaymanta yachachishpalla katirka: Chay punchakuna shuk runakuna kankunata rimankakuna rikuychi, kaypimi chaypimi Yaya Diospa Kachashkan Kishpichikka nishpa. Chasna rimashpankunapas ama kiriychichu. ");
INSERT INTO qupNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Chay punchakunapi achka runakuna llullachishpa purinkakuna ñukami Yaya Diospa Kachashkan Kishpichik kani nishpa. Shukkunaka llullachishpa rimankakuna ñukami Yaya Diospa yachayninwa yachachik kani nishpa. Paykunaka achka suma mana atipaypakunata, atun yachaywa runakuna nima ima uras rikushkankunata rurankakuna tukuy runakunata llullachinankunapa. Yapa munankakuna kankuna Yaya Diospa akllashkankunatapas pantachichinata. ");
INSERT INTO qupNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Chayrayku yuyaywa kaychi. Ña kunanka kankunata chasna llullachik runakuna tiyananmanta rimashkani. Chay rimashkaynita yuyariychi paktarishpan mana llullachiy tukunaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Chaypi Jesuska runankunata yachachishpalla katirka kasna nishpa: Tukuy chay parisina punchakuna tukurishkanwasha intika amsayanka, killapas manana punchayachinkanachu. ");
INSERT INTO qupNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Istrillakunaka silumanta urmankakuna. Tukuy silupi punchayachikkuna sinchita kuyurinkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Chaypina tukuy runakunaka ñukata Yaya Diospa Kachashkan Runata rikuwankakuna puyukuna chawpipi Yaya Diospa atun yachayninwa, intishina suma chuyahllapi shamuhushkaynita. ");
INSERT INTO qupNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Chasna shamuhushpaynimi angelkunata kachasha tukuy kankuna Yaya Diospa akllashkankunata tukuy partimanta tantachinankunapa ñukawana kawsanaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Shuk igu kaspita rikushpa yachakuychi. Paypa yakunka ramankunapi sikashpan achkata pankayahushpan yachankichi veranoka ña paktarihushkanta. ");
INSERT INTO qupNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Chasnashinami tukuy kay rimashkaynika paktarihukta rikushpaykichi yachankichi ña shamunalla kahushkaynita. ");
INSERT INTO qupNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Kankunata rimani, kunan kay punchakunapi kawsak runakunaka manara wañuhushpankunara tukuy kay rimashkayni paktarihukta rikunankuna tiyan. ");
INSERT INTO qupNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kay siluka kay allpapas tukurinkakunami. Ashwan tukuy rimashkaynika manami chasnalla pasankachu, shutipami paktarinan tiyan. ");
INSERT INTO qupNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ima punchami ima urasmi kutimusha, chaytaka Yaya Diosllami yachan. Nima shuk runa, nima silupi kawsak angelkuna yachanahunchu. Nima ñuka Yaya Diospa kikin Wawan yachanichu ima urasmi kutimusha. ");
INSERT INTO qupNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Chayrayku yuyaywa kawsaychi, tukuy uras alita Yaya Diosta kasushpa. Manami yachankichichu ima urasmi kutimusha. ");
INSERT INTO qupNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kasnashinami kanka: Shuk runa rinma shuk karu llaktama. Manara llukshihushpanra tukuy runankunata karan shukta rimama: Kanka kayta ruranki. Kanka kay shukta ruranki nishpa. Chay wasinta kuyraktana rimama: Alita kuyrapanki kay wasinita kutimunaynikama. Chasna nishpa runankunata sakima. ");
INSERT INTO qupNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kankunaka chay wasi amupa runankunashinami tukuy uras ali yuyaywa kawsanaykichi tiyan. Mana yachankichichu imashnapimi shamusha, tutayahushkapichu, chawpi tutachu, atallpa kantahushkapichu, pakarinapichu. Mana yachashpaykichi ima urasmi kutimusha, chayrayku tukuy uras rimashkaynita alita kasushpa kawsaychi. ");
INSERT INTO qupNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kayta kankunata rimani, shamuhushkayni uras mana kankunata tarinaynipa millaypata rurashpa kawsahushkaykichita. ");
INSERT INTO qupNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kay kankunata rimashkaynika tukuyraykumi kan: Ñukallata kasushpa kawsaychi. ");
INSERT INTO qupNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Karan wata ñukanchi israel runakunaka tantaripayanchi kay Paskua punchakunapi. Chay punchakunapi yuyaripayanchi ñawpa yaya rukunchikunata Yaya Dios kishpichishkanta chay Egipto allpamanta. Chay punchakunapi mikupayanchi pan mana punkichirishkata. Chay tantarinarayku ishkay puncha pishihushpanra saserdotenchikunapa apunkuna, Moisespa killkashkanta yachachikkunapas Jesusta chiknishpankuna munarkakuna llullachishpa apichinata wañuchichinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Chasna ruranata munashpankunapas paykunapura rimarkakuna: Paskua punchakunapi mana wañuchichishunchichu kay Jerusalenpi kahuk runakuna mana ñukanchita piñarishpa wañuchinayanankunapa. Chayrayku chay punchakunaka mana paktarihushpanra payta apichishunchi. ");
INSERT INTO qupNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesuska Betania llaktama rishpan aycha ismuchik unkuymanta ampishkan Simonpa wasinpi yaykurka. Paypa wasinpi mikuhushpankuna shuk warmi yaykurka. Chay warmika yura rumimanta rurarishka butillapi apamurka yapa chaniyu mishkinlla asnak perfumita. Chay butillapa kunkanta pakishpan chay mishkinlla asnak perfumita Jesuspa umanpi talirka. ");
INSERT INTO qupNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Chaypina shuk runakuna Jesuswa pakta mikuhukkunaka piñarirkakuna. Paykunapura kwintarkakuna: ¿Imaraykushi kay warmika usuchihun kay mishkihlla asnak perfumita? ");
INSERT INTO qupNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Chay perfumita rantichima karka shuk wata tarawashpan kullkita apinan tuputa apima karka, chaywa nima imayu runakunata yanapananpa. Chasna chay runakunaka piñarishpankuna chay warmita yankamanta mana alita yuyarishpankuna rimarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Chaypina Jesuska chay piñarihukkunata nirka: Ama chasna rimaychichu. ¿Imaraykuta piñarishpaykichi kay warmita pinkachihunkichi? Kay perfumita umaynipi talishpan alitami rurashka. ");
INSERT INTO qupNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nima imayu runakunaka tukuy urasmi kankunawa kawsankakuna. Ima uraspas paykunataka yanapaypallami kankichi. Ñukataka manana tukuy uras rikuwankichinachu. ");
INSERT INTO qupNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kay warmika tukuy atipashkanta ñukarayku rurashka. Chay suma mishkihlla asnak perfumita aychaynipi talishka, wañushpayni aychaynika alicharishka kananpa urku uchkupi churashpa tapanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Alita uyawaychi, tukuy maypipas runakuna Yaya Diospa suma ali shiminta runakunata kishpichinanmanta yachachishpankuna kay warmipa rurashkanmantapas rimankakuna. Kay warmika yapa yuyawashpan chasna rurashka. Chasna kashpan tukuy runakuna paymantapas alita yuyarinkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Chaymanta shuk Jesuspa chunka ishkay runankunamanta Judas Iskariote shutiyuka saserdotekunapa apunkunata rimananpa rirka: Munashpaykichika yanapashkaykichi Jesusta apinaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Chasna Judas rimashpan chay apukunaka kushikushpankuna rimarkakuna: Jesusta apinanchipa yanapashpaykika kanta kullkita pagashumi. Chaymanta Judaska kallarirka Jesusta chapanata, imashna rurashpami apichichinka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Chay Paskua punchakunapi ñukanchi israel runakunaka mikunchi pan mana punkichishkata. Kallarinan punchapi Yaya Diospa ñawpa rurashkanta yuyarishpa wañuchinchi shuk obeha maltakunata, wasinchipi kawsakkunawa pakta mikunanchipa. Chaypina runankunaka Jesusta tapurkakuna: ¿Maypita munanki alichanapa rinanchipa chaypi obeha maltata kusashpanchi Paskua mikunata mikunanchipa? ");
INSERT INTO qupNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Chaypina Jesuska ishkay runankunata akllashpan rimarka: Chay Jerusalén llaktama riychi. Chaypimi shuk runawa tinkunakunkichi, shuk mankapi yakuta apahukwa. Chay runata katinkichi. ");
INSERT INTO qupNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Maykan wasipimi yaykun, kankunapas chaypi yaykunkichi. Chaypi wasi amuta rimankichi: Ñukanchita yachachikmi tapun, ¿maypitaya chay kwartuykika alichananchipa tukuy runankunawa chaypi mikuk shamunanpa? ");
INSERT INTO qupNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Chay wasi amuka rikuchinkami shuk atun kwartuta ishkaynin kawitu awama suma alicharishkata. Chaypi mikunanchipa kusaychi. Chasna rimashpan Jesuska chay ishkay runankunata kacharka. ");
INSERT INTO qupNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Paykunaka rishpankuna Jerusalén llaktapi paktarkakuna. Chaypi tukuyta Jesuspa rimashkantashina tarik rirkakuna. Tukuyta alicharkakuna chay Paskua punchakunapi mikunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ña tutayahushpanna Jesuska chay chunka ishkay runankunawa chay wasipi paktamurka. ");
INSERT INTO qupNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Chaypi mesa muyukta siririrkakuna mikunankunapa. Mikuhushkankunapi Jesuska paykunata rimarka: Alita uyawaychi. Shuk kankunamanta ñukawa pakta mikuhukmi apichiwanka chiknik runakuna wañuchiwanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Chasna rimashpan runankunaka yapa llakirirkakuna. Chaypina Jesusta shukllankama shukllankama tapurkakuna: Yachachik ¿pitaya ñukanchimanta chasnaka rurama? ¿Ñukachu apichichishkayki? Mana kaynima ñuka. ");
INSERT INTO qupNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Chaypi Jesuska aynirka: Kankuna chunka ishkaymanta shuk, maykanmi ñukawa parihu kay kallanapi panninta ukuchin, chaymi apichichiwanka. ");
INSERT INTO qupNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Imashnami Yaya Dios ñawpamanta pacha killkachirka ñukamanta, chasnallatatami ñuka Yaya Diospa Kachashkan Runaka wañunayni tiyan. Wañuna kashpaynipas chay apichichiwak runarayku llakirini, yapa parisinan tiyan. Payraykuka ashwan ali kama karka, mana wawayarima karka. ");
INSERT INTO qupNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mikuhushpankunara Jesuska shuk panta apishpan Yaya Diosta agradesirka. Chay panta pakishpa pakishpa karan shuk runanta kurka. Chasna kuhushkanpi nirka: Kay panka aychaynishinami kan. Kay panta mikushpaykichi yuyariychi ñuka wañushpayni kankunata kishpichinaynita. ");
INSERT INTO qupNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Chaymanta shuk pusillu vinuta apishpan Yaya Diosta agradesirka. Agradesishkanwasha shukllankama shukllankama upyanankunapa kurka. ");
INSERT INTO qupNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Paykunata nirka: Kay vinuka yawarnishinami kan. Wañushpayni yawarni shuturishpan Yaya Dios achka runakunata uchankunamanta llakichishpan kishpichinka. Chay yawarnini shuturinanwa Yaya Dios runakunarayku paywa alichananta paktachin. ");
INSERT INTO qupNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Alita uyawaychi, ñukaka manami kutikashka kay allpapi kushilla kankunawa tantarishpa kay vinuta upyashanachu. Ña wañushami. Ashwan shuk puncha Yaya Diospa ali kamachinan mushu mundupi shuk mushu vinuta kankunawa upyahukshina tantaylla kushilla kashunchi. ");
INSERT INTO qupNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Chasna Jesús rimashkanwasha shuk Salmokunata takirkakuna. Takishkankunawasha Olivos urkuma rirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Chaypi Jesuska rimarka: Yaya Diospa killkachishkanpi ñukanchikunamantami riman: Obehankunata kuyrak runata wañuchisha. Chasna kashpan tukuy obehankunaka shikwarinkakuna nishpa. Chay killkachishkanpi rimashkanshina tukuy kankuna kay tuta kuntraynikunata manchashpaykichi sakiwankichi. ");
INSERT INTO qupNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Wañushkayniwasha Yaya Dios kawsachiwashpan ñukara kankunamanta ñawpashpa Galilea allpama risha. ");
INSERT INTO qupNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Chaypina Pedroka nirka: Tukuy kay katik masinikunaka mancharishpa kanta sakishpankunapas ñukaka manami sakishkaykichu. ");
INSERT INTO qupNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesuska payta aynirka: Kanta rimani, kay tuta manarapas atallpaka ishkay kuti kantahushpanra kimsa kuti rimanki mana riksiwanaykita. ");
INSERT INTO qupNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Chaypi Pedroka kuti rimarka: Shutipa rimani, kanwa parihu wañunayni kashpanpas kanwa pakta wañusha, manami rimashanchu kanta mana riksinaynita nishpa. Chasnallatata chay shuk runankunapas rimarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Chaymanta rishpankuna olivos tarpu kincha Getsemaní shutiyupi paktarkakuna. Chaypi Jesuska runankunata nirka: Kayllapi tiyarishpa chapawaychi, chaynikstupi rishpayni Yaya Diosta mañanaynikama. ");
INSERT INTO qupNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Chasna rimashkanwasha Pedrota, Santiagota, Juanta, chay kimsallata chaynikstuma pusharka. Chaypina Jesuska wañunanta yuyarishpan sinchi manchay apirka. ");
INSERT INTO qupNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Chay kimsa runankunata nirka: Wañunaynita yuyarishpayni shunkuynipi yapa llakirini wañuhushkashina. Kankunaka kayllapi mañashpa kipariychi, ama puñunkichichu. ");
INSERT INTO qupNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Chasna rimashkanwasha Jesuska chaynikstuma rirka. Kunkurishpan umanka allpapi tupanankama kumurirka. Chaypi Yayan Diosta mañarka payrayku ali kashpanka chay parisishpa wañunanmanta kishpichinanpa. ");
INSERT INTO qupNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kasna nishpa mañarka: Yayaynistu, kanka tukuy munashkaykita atipanki ruranata. Kanta mañani, kishpichiway, mana chasna sinchita parisinaynipa. Chasna tapushpaynipas ama ñukapa munashkaynita ruraychu, ashwan kanpa munashkaykillata ruray. ");
INSERT INTO qupNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Chasna Yaya Diosta mañashkanwasha runankunama kutishpan puñurayahukkunata tarik rirka. Chaypi Pedrota nirka: Simón, ¿puñuhunkichu? ¿Manachu atipashkanki nima shuk urastuta mana puñushpa mañashpa kanata? ");
INSERT INTO qupNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Tukuy runankunatana nirka: Mana sampayashpa Yaya Diosta mañaychi, supay mana kankunata munachinanpa mana ali munashkaykichita ruranaykichipa. Kankunaka yapa munankichi Yaya Diosta mañanata. Chasna munashpaykichipas sapallaykichika mana atipankichichu, shunkuykichipi yapa sampayashka kashpaykichi. Chayrayku Yaya Diosta mañaychi shunkuykichita sinchikuchinanpa. ");
INSERT INTO qupNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Chasna rimashkanwasha kutikashka chaynikstuma rishpan chasnallatata Yayan Diosta mañak rirka. ");
INSERT INTO qupNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Runankunama kutishpan chasnallatata puñurayahukkunata tarik rirka, yapa puñuywa kahushkankunarayku. Kutikashka likchachishpan paykunaka mana yacharkakunachu imatami ayninkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kimsaynin kuti chaynikstuma rirka Yayanta mañananpa. Kutikashka kutishpan paykunata nirka: ¿Kunankamachu puñuhunkichi? Ña chayllami. Ñami paktarishka ñuka Yaya Diospa Kachashkan Runata chay uchasapa runakuna apiwanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Atariychi, akuychi. Ñami shamuhun chay apichichiwak runaka. ");
INSERT INTO qupNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Chasna Jesús rimahushpanra paypa runan Judaska chay kincharishkapi paktamurka. Paywa pakta achka runakuna kaspikunawa, ishkay wiluyu sablikunawa shamurkakuna Jesusta apinankunapa. Paykunaka saserdotekunapa apunkunamanta, Moisespa killkashkanta yachachikkunamanta, ñukanchita kamachik israel masinchi rukukunamantapas kamachirishka karkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Manara paktahushpankunara Judaska chay apikkunata rimarka: Maykan runatami muchasha, chaymi kanka Jesuska. Payta apishpaykichi alita kuyrashpa pushaychi mana kishpinanpa. ");
INSERT INTO qupNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judaska paktashpan Jesusta kayllayashpan rimarka: Yachachik, shamushkanimi kanta saludanaynipa nishpa payta mucharka. ");
INSERT INTO qupNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Chaypina chay achka runakunaka payta apirkakuna pushanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Chaypi Jesuspa shuk runan sablinta apishpan saserdotekunapa atun aputa shuk yanapak runanta sumakta pitishpa wañuchisha nishpa pitihushpan rinkrinllata pitirka. ");
INSERT INTO qupNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Chaypina Jesuska chay apik runakunata nirka: ¿Imaraykutaya sablikunawa kaspikunawapas shamushkankichi apiwanaykichipa? ¿Wañuchik shuwa runachu kani? ");
INSERT INTO qupNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tukuy puncha Yaya Diospa wasinpi kankunawa pakta kahushpayni yachachirkani. ¿Imaraykuta mana chaypi apiwarkankichichu? Yaya Diospa ñawpa killkachishkanpi ñukamanta riman apiy tukunaynita. Chay killka rimashkanshina shutipa kunanka apiwahunkichi. ");
INSERT INTO qupNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Chaypi tukuy runankunaka Jesusta sapallanta sakishpankuna kallpa mitikurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Shuk musullana llatan katarinanllawa pillurishpa Jesusta katihurka. Paytapas apinayarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Chasna ña apihushkankunapi chay musupas katarinanta sakishpan llatan mitikurka. ");
INSERT INTO qupNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Chaymantana chay apik runakunaka Jesusta pusharkakuna saserdotekunapa atun apuma. Chay atun apuwa tukuy saserdotekunapa apunkuna, ñukanchita kamachik israel masinchi rukukuna, Moisespa killkashkanta yachachikkunapas tantarishka kahurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedroka karullapi katishpan washankunalla chay atun apupa wasin pampan kincharishkapi yaykurka. Chay pampapi Yaya Diospa wasinta shuk kuyrakkunaka tiyahlla kahurkakuna nina kuchupi kunushpa. Pedropas chaypillatata tiyarik rirka. ");
INSERT INTO qupNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Chay wasi ukupi saserdotekunapa apunkuna, tukuy paykunawa pakta tantaylla yuyarishpa kamachik masinkuna chiknik runakunata maskarkakuna llullashpa millaypata Jesusmanta rimanankunapa. Yapa munarkakuna payta wañuchichinata. Yapa munashpankunapas nima imata millaypata rurashkanta tarirkakunachu. ");
INSERT INTO qupNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Achka runakuna llullashpa millaypata Jesusmanta rimashpankunapas mana tiyarkachu ishkay chasnallata rimakkuna. Karan shuk chikanta rimashpankuna nima imata tarirkakunachu atipanankunapa payta wañuchichinata. ");
INSERT INTO qupNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Chaypina shukkunaka shayarirkakuna llullashpa rimanankunapa: ");
INSERT INTO qupNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Ñukanchika uyashkanchimi kay Jesús rimahukta: Ñukaka kay runakunapa rurashkan Yaya Diospa wasinta urmachisha. Chaymanta kimsa punchapi ñukaka rurasha shukta, mana runakunapa rurashkankunatashinanachu. ");
INSERT INTO qupNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Chasna rimahushpankunapas kutikashka mana parihuchu chasnallata rimarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Chaypina chay saserdotekunapa atun apuka chawpinkunapi shayarishpan Jesusta rimarka: ¿Manachu nima imata ayninki? ¿Manachu uyanki kanta uchachishpa rimahushkankunata? ");
INSERT INTO qupNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Chaypi Jesuska chunlla uyarka, nima imata aynirkachu. Kutikashka chay apuka tapurka: ¿Kanchu kanki chapahushkanchi Yaya Diospa Kachashkan Kishpichik, paypa kikin Wawan? ");
INSERT INTO qupNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Chaypi Jesuska aynirka: Ñukami kani. Chasna kashpan ñuka Yaya Diospa Kachashkan Runata rikuwankichi tukuyta atipak Yaya Diospa kuskan partipi tiyahushkaynita, paywa pakta kamachinaynipa. Chaymanta rikuwankichi puyu chawpipi kutikashka shamuhushkaynita. ");
INSERT INTO qupNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Chasna Jesuspa rimashkanta uyashpan chay atun apuka yapa piñarishpan pay kikinpa kamisan awapi churarishkanta likishpan nirka: Manana munanchinachu ashwan shuk payta uchachikta. ");
INSERT INTO qupNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Uyashkanchi kay runaka Yaya Dioswa parihuyashpa rimashkanta. Chasna rimashpanmi Yaya Diosta yapa piñachihun. ¿Imatata yuyarinkichi? Chaypina tukuy rimarkakuna: Uchayumi, wañunan tiyan nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Chayllapi shukkunaka Jesusta chiknishpankuna uyanpi tyukarkakuna. Shukkunaka Jesuspa ñawinta tapashpankuna uyanpi sakmarkakuna. Chasna sakmahushpankuna asichishpa tapurkakuna: Kunanka rimay, shutipa Yaya Diospa Wawan kashpaykika ¿pita kanta sakmashka? nishpa. Payta kuyrakkunatana kushpankuna paykunapas Jesusta waktarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedroka saserdotekunapa atun apupa wasin pampapi kahurka. Chasnapi atun aputa shuk yanapak warmi shamurka. ");
INSERT INTO qupNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pedrota nina kuchupi tiyahukta rikushpan chay warmika payta kayllayashpan nirka: Kanpas chay Nasaretmanta Jesuswa pakta purihurkanki. ");
INSERT INTO qupNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedroka aynirka: Manami riksinichu chay runataka. Nima yachanichu pimantami rimawahunki. Chasna nishpan Pedroka llukshirka chay pampamanta punkuma. Chasnallapi shuk atallpaka kantarka. ");
INSERT INTO qupNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Chay warmika kutikashka Pedrota rikushpan rimarka chaypi kahukkunata: Kay runapas Jesuswa purikmi karka. ");
INSERT INTO qupNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Chaypi Pedroka kutikashka aynirka: Shutipami kankunata rimani, manami riksinichu chay runata nishpa. Astalla unaystupi chaypi kahukkunaka Pedrota kutikashka nirkakuna: Shutipami kanpas Jesuswa purik kanki, Galileamanta runashina rimahushkaykirayku. ");
INSERT INTO qupNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Chaypina Pedroka sinchita nirka: Yaya Dios kastigawachun mana shutipata rimashpaynika. Shutipami rimani kankunata, ñukaka manami riksinichu chay runataka. ");
INSERT INTO qupNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Chasnallapi kutikashka atallpaka kantarka. Chaypi Pedroka yuyarirka Jesuspa rimashkanta manara ishkay kuti atallpaka kantahushpanra kimsa kuti rimanki mana riksiwanaykita nishpa. Chayta yuyarishpan Pedroka yapa llakirishpan sinchita wakarka. ");
INSERT INTO qupNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Chaymanta tutamantastulla saserdotekunapa apunkuna, ñukanchita kamachik israel masinchi rukukuna, Moisespa killkashkanta yachachikkuna, tukuy paykunawa pakta tantaylla yuyarishpa kamachik masinkunapas shuk yuyayllawa karkakuna. Chaypina Jesusta watashpa pushashpankuna chay romano apunchi Pilatotana kurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Chaypi Pilatoka Jesusta tapurka: ¿Shutipachu israel masikikunapa Atun Apu kanki? Jesuska aynirka: Ari, shutipami rimanki. ");
INSERT INTO qupNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Chay saserdotekunapa apunkunaka yapa Jesusta wañuchichinayashpankuna Pilatota yankana rimarkakuna achkata Jesusta uchachishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Chaypi Pilatoka kutikashka Jesusta nirka: Kay runakunaka kanta yapa uchachishpa rimahunkuna ¿manachu ayninkima? ");
INSERT INTO qupNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesuska nima imata aynirkachu. Chaypina Pilatoka yuyarirka ¿imaraykushi mana shuk apirishka runashina ayninchu kishpinanpa? nishpa. Mana yacharkachu imatami ruranka. ");
INSERT INTO qupNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Karan wata chay Paskua punchakuna Pilatoka kacharipayarka shuk karselpi kahuk runata. Ñukanchi israel runakunata tapupayarka pitami kacharinka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Chay karselpi achka romano runakunata piñarishpa wañuchik runakuna karkakuna. Shuk paykunamanta karka Barrabás. ");
INSERT INTO qupNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Chaypina Jerusalenpi chay achka tantarishka kahuk runakunaka Pilatoma rirkakuna tapunankunapa: Imashnami karan wata kacharinki shuk runa karselpi kahukta, chasnallatata kunanpas shukta kachariy. ");
INSERT INTO qupNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Pilatoka yacharka chay saserdotekunapa apunkuna Jesusta chiknishpankuna yankamanta wañuchichinayashkankunata. Paykuna yapa munashkakuna runakuna paykunallata kasunankunapa. Chayrayku chay apukunata tapurka: ¿Manachu munankichi kacharinaynipa kay Jesusta, kankuna israel runakunapa Atun Apuykichi nishkankunata? ");
INSERT INTO qupNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Chaypina chay saserdotekunapa apunkunaka chay achka runakunata yuyachishpa rimarkakuna: Pilatota rimaychi Barrabasta kacharinanpa. Chay runakunaka kasushpankunana kaparirkakuna: ¡Barrabasta kachariy! ");
INSERT INTO qupNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatoka kutikashka tapurka chay achka runakunata: ¿Imatata munankichi ruranaynipa kay runata, maykantami ñukanchi israel runakunapa apunchi nishpa rimankichi? ");
INSERT INTO qupNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Paykunaka sinchita kaparishpa aynirkakuna: ¡Kruspi klabashpa wañuchichiy! ");
INSERT INTO qupNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatoka aynirka: ¿Ima millaypatataya rurashka? Chaypi paykunaka kutikashka ashwan sinchita kaparirkakuna: ¡Kruspi klabashpa wañuchichiy! ");
INSERT INTO qupNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Chaypina Pilatoka Barrabasta kacharirka, mana chay runakunaka payta piñarinankunapa. Jesustana kirukunawa rurarishka karawa asutichirka. Chaywasha suntalunkunata kurka kruspi klabashpa wañuchinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Chaymanta chay suntalukunaka Jesusta pusharkakuna Pilatopa atun kamachinan wasima. Chay wasi chawpipi pampa tiyashkapi tukuy suntalu masinkunata tantachirkakuna Jesusta asichinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","18","Payta shuk puka llachapa atun apupa churarinantashina churachirkakuna. Umanpi churarkakuna atun apupa tawasampatashina kashamanta rurarishkata. Chasna churashpankuna payta shuk atun aputashina saludashpa asichirkakuna: ¿Shamushkankichu israel runakunapa atun apu? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Asishpa Jesuspa umanpi kaspiwa waktarkakuna, tyukarkakuna uyanpi. Puntanpi kunkurishpankuna makinta apishpa shuk atun aputashina mucharkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Chasna pukllachishkankunawasha chay puka llachapa churachishkankunata llatanachishpankuna pay kikinpa churarinantana churachirkakuna. Chaymanta pusharkakuna kruspi klabashpa wañuchinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jesusta pushahushpankuna kruspi klabashpa wañuchinankunapa, chay ñampipi shuk runa Simón shutiyuta tinkurkakuna. Chay Simonka Sirene llaktamanta karka, Alejandropa, Rufopa yayan. Chakranmanta kutimuhurka. Chay suntalukunaka pasahukta rikushpankuna payta kamachirkakuna Jesuspa krusninta markananpa. ");
INSERT INTO qupNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Chasna Jesusta pushashpankunana chay Gólgota lumapi paktak rirkakuna. Gólgota ninayan wañushkapa uman luma. ");
INSERT INTO qupNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Chaypina Jesusta vinu mirra kaspipa aya wikinwa chapurishkata upyachinayarkakuna mana nanayta musyananpa. Chaytaka Jesuska mana upyanayarkachu. ");
INSERT INTO qupNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Ña intika awastupi kahushpan Jesusta kruspi klabarkakuna. Chay suntalukunaka Jesuspa churarishkankunata chawpinakunankunapa swirtinkunata kamarkakuna pishi apanka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Chaypina Jesuspa krusninpi shuk killkarishkata ratachirkakuna tukuy runakuna yachanankunapa imaraykumi Jesusta wañuchishkakuna. Chay killkarishkapi nirka: Kay runaka israel runakunapa atun apumi kan nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jesusta wañuchihushkankuna uras ishkay wañuchik shuwakunatapas karan shukta shuk kruspi klabarkakuna chaypi wañunankunapa. Shuk krusta shayachirkakuna kuskan parti, shuktaka llukin parti. ");
INSERT INTO qupNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Chasnami Yaya Diospa ñawpa killkachishkanpi rimashkanka paktarirka kasna nishkaka: Chay Yaya Diospa Kachashkan Runataka shuk wañuchik runatashinami wañuchinkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Chaypi achka runakuna Jesusta rikuk rirkakuna. Mana kirishpankuna Yaya Diospa Kachashkan Kishpichik kananta, umankunata kuyuchishpankuna payta asichirkakuna: Kanmi rimashkanki Yaya Diospa atun wasinta urmachishpayni kimsa punchapimi kutikashka rurasha nishpa. ");
INSERT INTO qupNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Kunanka chay krusmanta uraykumushpayki kan kikinta kishpichiriy nishpa rimarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Chay saserdotekunapa apunkunapas, Moisespa killkashkanta yachachikkunapas chasnallatata asichishpa nirkakuna: Payka achka runakunata ampishpan kishpichishka. Kunanka pay kikinta mana atipanchu kishpichirinata. ");
INSERT INTO qupNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Shutipa Yaya Diospa Kachashkan Kishpichik ñukanchi israel runakunapa atun apunchi kashpanka kay krusmanta uraykumuchun. Chasna rikushpanchirami paytaka kirishunchi. Chay ishkay kruskunapi klabarishka runakunapas chasnallatata Jesusta asichirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Chawpi punchamanta pacha kimsa urata tukuy chay allpapi amsayarka. ");
INSERT INTO qupNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Chay kimsaynin ura amsa kahushkanpi Jesuska kikin arameo shiminpi sinchita kaparirka: Eloi, Eloi, lema sabaktani. Chayka ninayan Yayayni Dios, Yayayni Dios, ¿imaraykutaya sapallaynita sakiwashkanki? ");
INSERT INTO qupNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Chasna kaparishkanta uyashpankuna chaypi kahukkunaka rimarkakuna: Uyaychi. Eliastami kayahun, chay ñawpa Yaya Diospa yachayninwa yachachikta. ");
INSERT INTO qupNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Chaypi shuk runaka kallpashpa rirka shuk suni kaspipa puntanpi utkuta watananpa. Chayta agru vinupi ukuchishpan Jesuspa shiminpi tupachirka tsunkashpa upyananpa. Chasnahushpan nirka: Akuychi rikushunchi, shutipachu Eliaska shamunka payta krusmanta uraykuchinanpa. ");
INSERT INTO qupNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Chaypina Jesuska sinchita kaparishpan wañurka. ");
INSERT INTO qupNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Chay wañushkan uraslla Yaya Diospa wasin ukupi Yaya Dioswa tinkunakuna kwartuta arkak rakta llachapaka awamanta pacha pitikta likirirka. ");
INSERT INTO qupNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Chaypi chay romano suntalukunapa kapitanka Jesuspa puntanpi rikushpa kahurka. Chay kapitanka Jesusta kaparishpa wañuhushkanta rikushpan rimarka: Shutipami kay runaka Yaya Diospa Wawan kashka. ");
INSERT INTO qupNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Achka warmikunapas karumantalla Jesusta rikushpa karkakuna. Paykunamanta karkakuna Magdalamanta Maria, Salomé, Santiagopa Josepa maman Mariapas. Kay Santiagoka ashwan musu karka chay Jesuspa runan Santiagomanta. ");
INSERT INTO qupNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jesuska manara wañuhushpanra Galilea allpapi kahushpan chay warmikunaka payta yanapashpa paywa pakta puripayarkakuna. Shuk achka warmikunapas paywa pakta rirkakuna Jerusalén llaktama payta yanapanankunapa. Paykunapas karumantalla Jesús wañuhushkanta rikushpa kahurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Tiyarka shuk runa José shutiyu Arimatea llaktamanta. Chay Joseka ñukanchi israel runakunata kamachik tantaylla yuyarishpa israel apunchikunamanta shuk karka. Payka ali apu karka. Yaya Diosta yuyak kashpan yapa chaparka paypa ali kamachinan kay allpapi paktarinanta. Ña tutayahushpan chay Joseka yapa munashpan Pilatopa wasinpi yaykuk rirka Jesuspa aychanta tapunanpa. Manara chay tuta samana punchaka kallarihushpanra yapa munarka Jesuspa aychanta allarishka urku uchkupi churashpa tapanata. ");
INSERT INTO qupNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Chasna Jesuspa aychanta tapushpan Pilatoka mana kirirkachu Jesús chasna utkalla wañushkanta. Chayrayku suntalukunapa kapitanta kayashpan tapurka: ¿Shutipachu ña wañushka? ");
INSERT INTO qupNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Chay kapitanka ari nishpan Pilatoka suntalunkunata kamachirka Jesuspa aychanta Joseta kunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Chaypina Joseka shuk suma yura llachapata rantik rirka. Chaywasha Jesús kruspi klabarishkata uraykuchishpankuna paypa aychanta chay llachapawa pillurka. Chasna wankushkanwashana aparka shuk mushu allarishka urku uchkupi churashpa tapananpa. Chay uchkupi churashpanna punkuntaka shuk atun rumiwa taparka. ");
INSERT INTO qupNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Chaypina Magdalamanta Mariaka, Josepa maman Mariapas rikushpa kahurkakuna yachanankunapa, maypimi Jesuspa aychanka churarishka kahun. ");
INSERT INTO qupNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Chay samana puncha pasashka tutapi kimsa warmikuna, Magdalamanta Maria, Josepa maman Mariawa, Salomewa shuk mishkinlla asnak aseiteta rantik rirkakuna chaywa Jesuspa aychanta kakunankunapa mana asnananpa. ");
INSERT INTO qupNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Chay samana puncha kayantima, domingo tutamanta, ña intika llukshihushkanpi Jesuspa aychanta churashkapi paktak rirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Rihushkankunapi tapunakurkakuna: ¿Pitaya ñukanchirayku anchuchinka chay atun rumitaka uchku punkumanta? ");
INSERT INTO qupNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Chaypi alita rikushpankuna chay atun rumita ña anchuchirishkatana rikurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Chay uchkupi yaykushpankuna Jesuspa aychanta kakunankunapa, chaypi shuk angelta suma yura suni churarishkata rikurkakuna kuskan parti tiyahukta. Payta rikushpankuna yapa mancharirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Chasnallapi chay angelka paykunata nirka: Ama manchariychichu. Maskahunkichimi Nasaretmanta Jesusta, kruspi klabashpa wañuchishkankunata. Ñami kawsarishka. Rikuk shamuychi, maypimi churay tukushka kahurka. Manami kaypinachu. ");
INSERT INTO qupNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kunanka paypa runankunata kwintak riychi, Pedrota ashwan kwintaychi Jesús kawsarishkanta. Jesús kankunata rimashkanshina payra kankunamanta ñawpashpa Galilea allpama rinka. Chayma rishpaykichimi tinkunakunkichi nishpa paykunata rimankichi. ");
INSERT INTO qupNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Chasna chay angelka rimashpan chay kimsa warmikunaka yapa mancharishpankuna chukchurishpa kallpa mitikurkakuna. Manchaywa kutishpankuna chay rikushkankunata nima pita kwintarkakunachu. ");
INSERT INTO qupNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Chay samana punchawasha tutamanta Jesuska kawsarishkanwasha puntiru Magdalamanta Mariatara rikurirka. Chay Mariamanta ñawpa kanchis supaykunata llukshichirka. ");
INSERT INTO qupNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mariaka Jesús kawsarishkata rikushpan kwintak rirka Jesuswa pakta purishka masinkunata. Paykunaka llakiywa wakashpa kahurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mariapa kwintashkanta uyashpankuna Jesuska ñami kawsarimushka, kawsarishkata rikushkanimi nishkanta, mana kirirkakunachu. ");
INSERT INTO qupNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mariata rikurishkanwasha Jesuska ishkay runankunata ñampita rihushkankunapi rikurirka. ");
INSERT INTO qupNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Paykunaka Jerusalén llaktama kutishpankuna chaypi kiparishka masinkunata kwintak rirkakuna Jesús kawsarishkata rikushkankunata. Chasna rimashpankunapas mana paykunata kirirkakunachu. ");
INSERT INTO qupNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Chaymanta shuk puncha Jesuska chunka shuk runankunata rikurirka mesa muyukta siririshpa mikuhushkankunapi. Chaypi rimarka: ¿Imaraykutaya mana kirinayashkankichichu chay rikuwashka runakunata? Paykuna kawsarishkaynimanta kwintashpankunapas mana kirishkankichichu. Yapa mana kirinayak runakuna kankichi. ");
INSERT INTO qupNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Chaymantapas rimarka: Tukuy kay allpapi kawsak runakunata yachachik riychi kay Yaya Diospa suma ali shiminta runakunata kishpichinanmanta. ");
INSERT INTO qupNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Maykankunami chay yachachihushkaykichita kirinahun, chaymantapas bawtisarinahun, chaykunaka kishpichiy tukunkakunami. Maykankunami mana kirinahunchu, paykunaka wiñayparayku kastigarishka kankakuna. ");
INSERT INTO qupNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kankuna Yaya Diosta kirik kashpaykichi atipankichi Yaya Diospa yachayninwa runakuna nima ima uras rikushkankunata ruranata. Runakunapi yaykushka supaykunata atipankichi llukshichinata. Chaymantapas mana yachashkaykichi shimikunatapas rimankichimi. ");
INSERT INTO qupNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Shuk machakuyata apishpaykichi kanishpanpas mana imanachinkachu. Shuk sulimanta upyashpaykichipas mana imanachinkachu. Yaya Diosta mañashpa shuk unkushkakunapi makikichita churashpaykichi ampirinkakunami. ");
INSERT INTO qupNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Chayta rimashkanwasha Yayan Dioska Jesusta siluma pusharka. Silupi Jesuska Yaya Diospa kuskan parti tiyarik rirka paywa pakta tukuyta kamachik kananpa. ");
INSERT INTO qupNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Siluma rishkanwasha Jesusta katikkunaka tukuy parti paymanta yachachik rirkakuna. Jesuska paykunata yanaparka runakuna nima ima uras rikushkankunata ruranankunapa, tukuy yachanankunapa chay yachachihushkankunaka shutipa ali kananta. Chayllatami ñuka Markus kwintani.");
INSERT INTO qupNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Munashkayni Teófilo, ñuka Lukas kayta killkani kanrayku alita yachanaykipa Jesuspa rurashkanmanta, yachachishkanmantapas. Achka runakuna Jesuspa rurashkankunata rikushpa kallarinanmanta pacha killkarkakuna. Paykunaka tukuy chayta ñukanchita yachachirkakuna. Paykuna karkakuna Yaya Diospa shiminta yachachikkuna. Ñukapas tukuyta kallarishkanmanta pacha alita yachakushpayni ali kama killkanaynipa nishpa kanrayku killkani. ");
INSERT INTO qupNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Chasnami yachanki kanta yachachishkankunata shutipa kashkanta. ");
INSERT INTO qupNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ñawpa Judea allpapi apu Herodes kamachik kashpan chaypi shuk saserdote Sakarias shutiyu kawsapayarka. Pay karka chay muntun saserdote Abias wañupa shutinta shutiyachishka tantaylla tarawak saserdotekunamanta. Warminpa shutin karka Isabel, paypas saserdotekunapa miraymanta karka. ");
INSERT INTO qupNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Yaya Diospa rikushkanpi ali karkakuna, tukuy paypa kamachishkanta alita kasushpa kawsapayarkakuna. Chayrayku nima pi atiparkachu paykunata uchachinata nima imapi. ");
INSERT INTO qupNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Isabelka machura kashpan paykuna mana wawayuchu karkakuna. Chaymantapas ña ruku karkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Karan wata karan saserdotekunapa ayllun akllarishka karka, shuk punchakuna Yaya Diospa wasinpi mañashpa wiwakunata wañuchishpa Yaya Diosrayku rupachinankunapa. Chay punchakuna paktarishpan Sakariaska ayllunkunawa pakta Yaya Diospa wasinpi runakunarayku mañarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Paykuna imashnami rurapayarkakuna saserdotepura akllarkakuna shukta Yaya Diospa wasin ukuma yaykunanpa chay Yaya Diosta mañana kwartupi. Chaypi payka mishkihlla asnak wiki chapurishka insienso nishkata rupachishpan kushniyachinan karka Yaya Diosta kushichinanpa. Chay puncha Sakariaska akllarishka karka Yaya Diosta mañana kwartupi yaykunanpa. ");
INSERT INTO qupNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Chay wikita rupachihushkanpi achka runakuna kanchapi Yaya Diosta mañashpa karkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Chaypi Yaya Diospa kachashkan angelka Sakariasta rikurik shamurka wikita rupachina tuchpashinapa kuskan parti. ");
INSERT INTO qupNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Chay angelta rikushpan Sakariaska yapa mancharirka. ");
INSERT INTO qupNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Chaypi angelka rimarka: Ama manchariychu. Yaya Dios uyashka mañashkaykita. Warmiki Isabelka shuk kari wawata wawayanka, maykantami shutiyachinkichi Juan. ");
INSERT INTO qupNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Wawayarishkanrayku yapa kushillami kanki. Chasnallatata achka runakunapas kushikunkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Yaya Diospa rikushkanpika atun yachayyumi kanka. Manami nima ima uras upyankachu urti upyanakunata. Manara wawayarihushpan Yaya Diospa Espiritunka paypi yaykunka kawsahushkanpi tukuypi yuyachinanpa. ");
INSERT INTO qupNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ña wiñashpan payka achka israel runa masinkunata yachachinka Yaya Diosta alita kirinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Payka Yaya Diospa kachanan Kishpichikmanta puntiru rinka, paypa shamunanmanta rimananpa. Ñawpa Yaya Diospa yachayninwa yachachik Eliasshina atun yachayyu yachachik kanka. Chasna yanapanka yayakuna wawankunawa chikninakushpa kawsashkankunata sakishpa yuyanakushpana kawsanankunapa. Yaya Diosta mana kasuk runakunata yachachinka alitana kasunankunapa. Chasna runakunata alichanka Yaya Diospa Kachanan Kishpichik paykunawa kawsak shamunanpa. ");
INSERT INTO qupNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Chasna chay angelka rimashkanwasha Sakariaska payta tapurka: ¿Imashnata yachasha rimawashkaykika shutipa kananta? Ñuka kani ruku, warminipas paya. ");
INSERT INTO qupNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Chasna Sakarias tapushpan angelka aynirka: ¿Imashna kashpataya mana kiriwankichu? Ñukami kani Gabriel, Yaya Diospa puntanpi shayarishpa kani paypa kamachinanta kasushpa. Yaya Dioska kachawashkami chay ali shimita kanta rimanaynipa. ");
INSERT INTO qupNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Chay rimashkaynita mana kirishkaykirayku kunanmanta pacha mana atipankichu rimanata wawayki wawayarinankama. Imashnami ñukaka rimashkani, chasnami paktarinan tiyan. ");
INSERT INTO qupNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Chay angelka Sakariaswa Yaya Diospa wasinpi kwintahushkanpi chay kanchapi kahuk achka runakunaka Sakariasta chapahurkakuna. Unayta chapahushpankuna yuyarirkakuna ¿imaraykuta chay ukupi yapa unayan? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sakariaska Yaya Diospa wasin ukumanta llukshimuhushpan mana atiparkachu rimanata. Chayrayku yacharkakuna chay wasi ukupi shuk imata muskuypishina rikushkanta. Mana rimanata atipashpan makinwa umanwa paykunata asirtachirka imashnami chay ukupi paywa pasashkanta. Chaymanta pacha mana rimanata atipak kiparirka. ");
INSERT INTO qupNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Yaya Diospa wasinpi mañanan punchakuna tukurishpan Sakariaska wasinma kutirka. ");
INSERT INTO qupNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kutishkanwasha warmin Isabelka chichurkana. Ña chichu kashpan pichka killakama wasinmanta mana llukshirkachu. ");
INSERT INTO qupNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Yuyarishpan nirka: Kunanka Yaya Dioska yapa alitami rurashka ñukapi runakuna manana pinkachiwanankunapa, mana wawayu kashkaynirayku. ");
INSERT INTO qupNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Isabel ña sokta killa chichu kashpan Yaya Dioska angel Gabrielta Nasaret llaktama kacharka. Chay Nasaret llaktaka Galilea allpapi karka. ");
INSERT INTO qupNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Chay llaktapi kawsapayarka shuk shipas Maria, manara karita riksik. Josewa kwintashka karka kasarananpa. Joseka ñawpa kawsak atun apu Davidpa miraymanta karka. Chaypi angelka Mariawa kwintak rirka. ");
INSERT INTO qupNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mariapa wasinpi yaykushpan rimarka: Shamushkani kanwa kwintanaynipa. Yaya Diospa akllashkan warmimi kanki, paymi kanwa kahun. Tukuy warmikunamanta kantami Yaya Dioska alita yuyashka. ");
INSERT INTO qupNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Angel chasna rimashpan Mariaka mancharirka. ¿Ima shimitataya kwintak shamuhun chasna saludawananpa? nishpa yuyarirka. ");
INSERT INTO qupNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Chaypi angelka nirka: Maria, ama manchariychu. Yaya Dioska kanta yuyashpan akllashka. ");
INSERT INTO qupNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Alita uyay. Chichunkimi. Chaymanta shuk kari wawata wawayanki, maykantami shutiyachinki Jesús. ");
INSERT INTO qupNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Payka atun yachayyumi kanka. Runakuna paymanta rimankakuna tukuyta atipak Yaya Diospa Wawanmi nishpa. Tukuyta kamachik Yaya Diosmi payta ñawpa yaya rukun Davidtashina atun aputa ruranka. ");
INSERT INTO qupNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Paymi kamachinka kankuna israel runakunata wiñayparayku. Paypa ali kamachinanka mana tukurinkachu nima ima uras. ");
INSERT INTO qupNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Chayta uyashpan Mariaka angelta nirka: Ñukaka manara kawsashkanirachu shuk kariwa. ¿Imashnataya chasnaka chichusha? ");
INSERT INTO qupNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Chaypi angelka aynirka: Yaya Diospa Espiritunmi tukuyta atipak kashpan puyushina kanma shamunka. Chasnamantami chichu kiparinki. Chayrayku chay wawamanta, maykanmi wawayarinka, Yaya Diospa munananllata rurashpa kawsak, Yaya Diospa Wawanmi nishpa rimankakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Awilayki Isabelpas paya kashpantata chichumi kahun, maykantami machura nishkakuna. Kunanka ñami sokta killa chichu kahun. ");
INSERT INTO qupNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Yaya Diosmi tukuy imatapas atipan ruranata. ");
INSERT INTO qupNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Chasna rimashpan Mariaka arí nirka, kaypi kahuni Yaya Diospa munashkanta ruranaynipa. Pay munashkanta ñukawa rurachun, imashnami rimashkanki chasna. Chasna rimashkanwasha angelka paymanta anchurirka. ");
INSERT INTO qupNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Chay punchakunalla Mariaka utkalla rirka ayllun Isabelta pasyananpa. Isabelka kusan Sakariaswa shuk llaktapi Judea allpa urkukuna chawpipi kawsahurka. ");
INSERT INTO qupNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sakariaspa wasinpi paktashpan Mariaka yaykuhushpan Isabelta saludarka. ");
INSERT INTO qupNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","42","Chasna saludahushpan Isabelpa wawanka wiksan ukupi sinchita kuyurirka. Chaypina Yaya Diospa Espíritun Isabelta tukuypi yuyachishpan payka kushikushpan Mariata sinchita rimarka: Yaya Diosmi kanta tukuy warmikunamanta akllashka kushichinanpa, wawaykitapas yapa kushichinka. ");
INSERT INTO qupNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ñukaka nima imachu kani kay atun apuynipa mamanka ñukama pasyak shamuwananpa. ");
INSERT INTO qupNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Saludashkaykita uyashkaynillawa, wiksayni ukupi wawaynika sumakta kushikushpan kuyurishka. ");
INSERT INTO qupNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tukuy Yaya Diospa rimashkanka paktarinkami nishpa kirishkaykirayku payka kanta atuntami kushichinka. ");
INSERT INTO qupNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Chaypi Mariaka rimarka: Shunkuynimanta pacha Yaya Diosta rimani kanmi kanki yapa ali. ");
INSERT INTO qupNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Yaya Dios kishpichiwashkanrayku yapa kushilla kani. ");
INSERT INTO qupNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nima ima kashpaynipas pay yuyawashpan rikuwashka. Kunanmanta pacha runakunaka rimawankakuna Yaya Diospa kushichishkanmi kanki nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Pay atun yachayninwa ñukata rurawashka Wawanpa maman kanaynipa. Paymi yapa ali kan. ");
INSERT INTO qupNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tukuy uras payta kasukkunata yuyashpa llakichishpan rikun. ");
INSERT INTO qupNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Pay atun yachayninwa rurashkanta rikuchirka. Shuk runakuna alimi kani nishpa rimashpankunapas shunkunkunapi mana ali yuyayyu kashpankuna payka yuyayninkunata waklichinka. ");
INSERT INTO qupNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Atun kamachikkunatapas kamachik kashkankunamanta anchuchinka, mana yapa yachakkunata atunyachinka paypa wawankuna kanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Maykankunami paypa yachachinanta shutipa munanahun, paykunata alita yachachinka pay kikin Yaya Dios kananta riksinankunapa. Maykankunami Yaya Diospa yachachinanta mana yapa munanahunchu, paykunataka mana yachachinkachu payta riksinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Imashnami ñawpa yaya rukunchi wañukuna Abrahamta, paypa mirayninkunatapas rimarka, chasnami ñukanchi payta katik israel runakunata yanapanka. Llakichinanta rimashkanta yuyarishpan kunanka paktachihun. ");
INSERT INTO qupNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariaka kimsa killata Isabelpa wasinpi kawsashkanwasha kutirkana wasinma. ");
INSERT INTO qupNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Wawayanan puncha paktarishpan Isabelka kari wawata wawayarka. ");
INSERT INTO qupNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Chayta yachashpankuna tukuy ayllunkuna kuchupi kawsakkunapas payta rikuk rirkakuna. Yaya Dios payta alita yanapashkanta rikushpankuna kushikurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Pusak punchamanta pitirkakuna kari wawapa ishpanan kara puntastuta. Chayta israel runakuna rurapayanahun ñawpamanta pacha, ninayan shutipa Yaya Diosta katinankunata. Chasna rurashpankuna ayllunkunaka shutiyachinayarkakuna yayanpa shutinta Sakarias kanka nishpa, imashnami israel runakuna rurapayanahun ñawpamanta pacha. ");
INSERT INTO qupNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mamanka mana munarkachu yayanpa shutinta shutiyachinata, chayrayku rimarka: Shutinka kankami Juan. ");
INSERT INTO qupNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Chaypi nirkakuna: ¿Imashnata chasnaka kanka? Tukuy ñukanchika ayllunchipa shutinkunallata shutiyachinchi. Nima shuk aylluyki tiyanchu Juan shutiyuka. ");
INSERT INTO qupNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Chasna nishpankuna yayanta makinkunawa rikuchishpa tapurkakuna: ¿Ima shutita kanka? ");
INSERT INTO qupNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Chaypi Sakariaska shuk tablastuta tapushpan killkarka shutinka kankami Juan nishpa. Chayta rikushpankuna tukuy mancharirkakuna ¿imashnataya chayka? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Chasnallapi Sakariaska kuti atiparka rimanata. Chaypi kallarirka Yaya Diosta kushichinata kanmi tukuymanta ashwan atun kanki nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Chaypi ayllunkuna kuchupi kawsakkunapas yapa mancharirkakuna. Tukuy Judea allpa urkukunapi kawsak runakuna chayta uyashpankuna paykunapura kwintarkakuna Yaya Diospa rurashkanmanta. ");
INSERT INTO qupNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tukuy uyashka runakuna shunkunkunapi yuyarishpa tapunakurkakuna paykunapura: ¿Imashnashi tukunka chay wawaka wiñashpanka? Chaymanta yacharkakuna Yaya Dios shutipa paywa kananta. ");
INSERT INTO qupNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Mushumanta rimanata kallarihushkan uras Juanpa yayan Sakariaska, Yaya Diospa Espíritun payta tukuypi yuyachishpan pasanan kananta rimarka kasna: ");
INSERT INTO qupNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Yaya Dios ñukanchi israel runakunarayku kachanka shuk kishpichikta. Chayrayku akuychi tukuyta atipak Yaya Diosninchita kushichishpa agradesishunchi. ");
INSERT INTO qupNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ñawpa Yaya Diosta kasuk Davidpa miraymanta Yaya Dios kachamunka atun yachayyu kishpichikta. ");
INSERT INTO qupNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ñawpamanta pacha kaytami Yaya Diospa yachayninwa yachachikkunata chay kachanan kishpichikmanta rimarkakuna kasna nishpa: ");
INSERT INTO qupNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Paymi kishpichinka ñukanchita tukuy kuntranchikunamanta, tukuy ñukanchita chiknikkunamantapas. ");
INSERT INTO qupNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Yaya Dios ñawpa yaya rukunchikunata yapa llakiywa kahushkankunata rikushpan rimarka llakichishpan yanapananta. Chaymantapas rimarka ñawpa yaya rukunchi Abrahamta rimashkanta mana kunkarinanta, ashwan shutipa paktachinanta kasna nishpa: ");
INSERT INTO qupNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Kishpichirishkami kankichi kuntraykichikunamanta, kushikushpa, nima pita manchashpa, munashkaynita rurashpa kawsanaykichipa. Kawsanaykichikama rikushkaynipi alillata rurashpa, ñukata kasushpa kawsankichi. ");
INSERT INTO qupNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Chayta rimashkanwasha Sakariaska rimashpalla katirka: Kanka, wawayni, shutipa Yaya Diospa Espiritunwa rimakmi kanki. Runakunata rimanki Yaya Diospa Kachanan Kishpichik shamunanmanta. Chayrayku shunkunkunata alicharishpa, tukuy mana alita rurashkankunata sakishpa, alitana runa masinkunawa kawsanankuna tiyan. ");
INSERT INTO qupNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Chaymantapas ñukanchi israel runakunata yachachinki, imashnami Yaya Dios mana alita rurashkanchikunata llakichishpan ñukanchikunata supaypa kamachinanmanta kishpichinka. ");
INSERT INTO qupNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Yayanchi Dios ñukanchita yuyashpan llakichishpan kachanka Kishpichikta ñukanchirayku. Inti punchayachihukshina silumanta ñukanchima shamunka. ");
INSERT INTO qupNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Mana alita rurashpa amsapishina kawsak, wañunankunata yapa manchashpa kawsak runakunarayku kishpichikta kachanka yachachinanpa riksichinanpa imashnami kushilla kawsashunchi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Chaymanta chay wawaka Yaya Diosta alita riksishpan sinchikurishpa wiñarka. Wiñashpan chunlla chakishka allpapi kawsarka israel masinkunata yachachinata kallarinankama. ");
INSERT INTO qupNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Chay punchakuna Augusto romano tukuymanta atun apu karka, romano runakunapa israel runakunapapas. Pay tukuy kamachinanpi kawsakkunata kamachirka, shutinkunata rimashpankuna killkachik rinankunapa. Yachanayarka masna runakunami tiyan nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Chay runakunapa shutinkunata killkachina karka puntiru killkachinan. Chay uras apu Sirenio shutiyu Siria allpapi kawsak runakunata kamachipayarka. ");
INSERT INTO qupNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Tukuymanta atun apu Augustopa kamachishkanta kasushpa, tukuy runakuna kutirkakuna kikin llaktankunama, maypimi ñawpa yaya rukunkuna kawsapayarkakuna, chaypi killkachik rinankunapa shutinkunata. ");
INSERT INTO qupNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Joseka ñawpa atun apu Davidpa miraymanta kashpan Davidpa llaktan Belenma rinan karka. Chasna kashpan Joseka Nasaret llakta Galilea allpamanta llukshishpan Judea allpama rirka David wañupa kawsashkan Belén llaktama. ");
INSERT INTO qupNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Mariaka Josewa kasaranan kashpan paywa pakta rirka shutinkunata killkachinankunapa. Chay uras Mariaka Yaya Dios rimashkanshina chichu karka. ");
INSERT INTO qupNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Belén llaktapi paktashpankuna nima shuk wasita tarirkakunachu puñunankunapa. Achka runakuna kashkanrayku wasikuna mana paktarkakunachu. Wiwakuna tampupi yaykurkakuna. Chaypina wawayananka paktarishpan Mariaka puntiru kari wawanta wawayarka. Chay wawanta llachapawa pillushpan wiwata karana kanuwapi churarka. ");
INSERT INTO qupNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Chay tutapi Belén llakta kuchullapi obehata kuyrak runakuna tiyarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Chaypi Yaya Diospa shuk angelka paykunata rikurik shamurka. Paykunapi muyukta Yaya Diospa yachaynin suma chuyahlla rikurirka. Chayta rikushpankuna yapa mancharirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Chaypina angelka rimarka: Ama manchariychichu. Suma shimita kankunata rimanayani Yaya Diosmanta. Kay shimita yachashpankuna tukuy runakunami kushikunkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kunalla kay tuta David wañupa llaktan Belenpi kankunata Kishpichikka wawayarishka. Paymi chapahushkaykichi Yaya Diospa Kachanan Kishpichik, tukuymanta atun apu. ");
INSERT INTO qupNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kunan riychi chay wawata riksinaykichipa. Kasnata tarishpaykichi yachankichi pay kananta: Shuk wiwa wasipi shuk llullu wawa pillurishkata wiwata karana kanuwapi sirihukta tarik rinkichi. ");
INSERT INTO qupNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kunkaymanta chay angel rikurihushkanllapi achka angelkuna rikurik shamurkakuna. Yaya Diosta kushichishpa nirkakuna: ");
INSERT INTO qupNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Yaya Dios, awa silupi kawsak, tukuymanta atun yachayyu ali kanki. Allpapipas kanahuchun suma yuyayyu runakuna. Payta yuyakkunata Yaya Dios aliyachinka, ali yuyayyu kushilla kawsanankunapa paykunapura. ");
INSERT INTO qupNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Chasna rimashkankunawasha angelkunaka siluma kutirkakuna. Chaypina obehata kuyrakkuna paykunapura kwintarkakuna: Akuychi rikuk rishunchi Belén llaktama Yaya Dios ñukanchita rimashkanta rikunanchipa. ");
INSERT INTO qupNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Chay uraslla kallpashpa rirkakuna. Wiwapa tampunpi paktashpankuna Mariata Josewa tarik rirkakuna, chaymantapas llullu wawastuta wiwata karana kanuwapi sirihukta. ");
INSERT INTO qupNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Chay wawata rikushpankuna angelka chay wawastumanta rimashkanta kwintarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Tukuy chay rimashkankunata uyakkuna mancharirkakuna ¿imashna wawataya chayka? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mariaka tukuy chay shimikunata yuyayninpi wakaychashpa yuyarirayarka. ");
INSERT INTO qupNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Chay obehata kuyrakkunaka kushilla kutirkakuna Yaya Diosta kushichishpa: Yaya Dios, uyashkanchi, rikushkanchi tukuy ali rurashkaykita. Imashnami rimashkanki tukuyta paktachishkanki. Kanmi kanki ashwan ali tukuymanta. ");
INSERT INTO qupNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Chay wawaka ña pusak punchayu kashpan ishpanan kara puntastuta pitirkakuna, imashnami israel runakuna rurapayanahun kunankama. Payta shutiyachirkakuna Jesús, imashnami angelka rimarka manara Maria chichu kahushpanra chasna. ");
INSERT INTO qupNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Chaymanta imashnami ñawpa Moisespa killkashkanpi rimashka, kari wawa wawayarishkanwasha ruranankunapa, Mariaka chusku chunka punchata wasinpi kiparirka. Chasna punchakunapi warmikuna mana atipapayanahunchu Yaya Diospa wasinpi yaykunata. Chay punchakuna paktarishpanna chay wawata Jerusalenma aparkakuna Yaya Diospa wasinpi Yaya Diosta rikuchinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Yaya Diospa kamachishkan karka: Tukuy puntiru kari wawa wawayarishkata ñukata rikuchinaykichi tiyan, kayka kahun kanta sirvinanpa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Chasnallatata killkarishka karka: Yayankuna apanan tiyan ishkay yura wiwa mukukuta, mana tiyashpanka uchpa wiwa mukukuta Yaya Diosta yuyashpa kunankunapa nishpa. Chayrayku Jesuspa yayankuna Jerusalenma rirkakuna tukuy Yaya Diospa kamachishkanta paktachinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","Chay punchakuna kawsarka Jerusalenpi shuk ruku Simeón shutiyu. Chay rukuka Yaya Diosta yuyashpa kasushpa kawsarka. Paykuna israel runakunata kishpichikta chapashpa kawsarka. Yaya Diospa Espíritun paypi kashpan kasna yuyachirka: Kan manara wañushpayki rikunayki tiyan Yaya Dios Kishpichikta kachashkanta nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Chasnallapi Yaya Diospa Espíritun yuyachishpan Simeonka Yaya Diospa wasinma rirka. Chaypillatata Jesuspa yayankunapas Yaya Diospa kamachishkanta paktachishpa wawanstuta aparkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeonka kayllayashpan wawata markashpan Yaya Diosta kushichishpa rimarka: ");
INSERT INTO qupNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Amuyni, kanmi kanki tukuymanta yapa atun. Rimawashkaykita ñami paktachishkanki. Kunan shuti kushilla wañusha. ");
INSERT INTO qupNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kunan ñuka kikin ñawiniwa kachashkayki Kishpichikta rikushkani. ");
INSERT INTO qupNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Tukuy allpakunamanta runakuna Kishpichik kananta yachankakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Payka ali punchayachikshina kashpan tukuy runakunata riksichinka imashnami kanta yuyashpa kawsankakuna. Payranti tukuy runakuna ñukanchi israel runakunata valichinkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Chasna Simeón Jesusmanta rimashkanta uyashpankuna maman yayan mancharirkakuna ¿imashnataya chayka kanka? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Chaypina Simeonka paykunata rimarka Yaya Dios yanapashpa paykunata kushichinanta. Chaymanta Jesuspa maman Mariata shuk shimita Yaya Diosmanta rimarka: Achka israel masinchikuna kay wawata chiknishpankuna Yaya Diosmanta wichurishka kankakuna. Shukkunaka payta yuyashpa kirishpankuna Yaya Dios paykunata uchankunamanta llakichishpan yanapanka payta kushichishpa kawsanankunapa. Yaya Dios chay wawapi yachayninta rikuchihushkanta achka runakuna mana kirishpankuna payta wichunkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Chaymanta wawayki tukuy runakunapa yuyayninkunata riksichinka. Kanka shunkuykipi waktashkashina nanayta musyanki, yapakta wawaykirayku llakishpayki. ");
INSERT INTO qupNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Chaypillatata kahurka shuk paya Yaya Diospa yachayninwa rimak Ana shutiyu. Payka Fanuelpa wawan, Aser wañupa miraymanta karka. Payka shipaslla kashpan kusayarka. Kusayashpan kanchis watamanta kusanka wañurka. ");
INSERT INTO qupNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Chay urasmanta pacha mashintu kashpan ña pusak chunka chusku watayu karka. Tukuy uras Yaya Diospa wasinpi kapayan, achka kuti mana mikushpa Yaya Diosta mañashpa kawsapayan. Tutapi punchapipas Yaya Diosta kushichipayan. ");
INSERT INTO qupNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Chay Yaya Diospa yachayninwa rimak warmi Ana tinkurka Simeonta, Mariawa Josewa kwintahushkata. Simeonpa rimashkanta uyashpan kayllayak shamurka Yaya Diosta agradesinanpa. Chaymanta chay wawa Jesusmanta rimak rirka tukuy israel masinkunata, maykankunami Jerusalén llaktata kishpichikta chapahurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Chaymanta tukuy Yaya Diospa killkachishkanpi kamachishkanta paktachishpankuna yayan maman Jesuswa pakta kutirkakuna Galilea allpama, Nasaret kikin llaktankunama. ");
INSERT INTO qupNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Chaypi kawsahushpankuna chay wawaka alita wiñarka. Yaya Dios payta yanapashpan suma yuyayyu yapa yachayyu tukurka. ");
INSERT INTO qupNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Karan wata Jesuspa yayankuna Jerusalenma ripayanahun chaypi Paskua punchakunata pasanankunapa. Chay Paskua punchakunata Yaya Dios kamachishkan karka yuyarinankunapa, imashnami pay ñawpa yaya rukunkunata Egiptomanta kishpichirka. ");
INSERT INTO qupNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ña Jesús chunka ishkay watayu kashpan paykunawa pakta Jerusalenma rirka chay punchakunata pasananpa, imashnami ñawpamanta pacha rurapayanahun chasna. ");
INSERT INTO qupNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Chay punchakuna tukurishpanna Maria Josewa pakta kutirkakuna, mana yachashpankuna wawa Jesuska Jerusalenpi kiparishkanta. ");
INSERT INTO qupNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ñachari rishka runa masinchikuna chawpipi nishpa yuyarirkakuna. Chasna yuyarishpankuna shuk punchata purirkakuna. Chaymanta ayllunkuna chawpipi riksishkankuna chawpipipas payta maskarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mana tarishpankuna Jerusalenmallatata kutimurkakuna chaypi maskanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kimsa puncha maskashpankuna Yaya Diospa wasinpi payta tarik rirkakuna, yachachikkunapa chawpinkunapi tiyahukta. Paykunata uyashpa tapushpa kahurka. ");
INSERT INTO qupNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tukuy runakuna payta uyashpankuna yachayninwa aynihushkanta mancharirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Jesuspa yayan maman kunkaymanta payta rikushpankuna kushikurkakuna. Mamanka nirka: Ay, wawayni. ¿Imaraykuta chasna rurashkanki ñukanchita? Yayayki ñukapas yapa llakishpa kanta maskashkanchi. ");
INSERT INTO qupNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Chaypi Jesuska aynirka: ¿Imaraykuta yapa maskawashkankichi? ¿Manachu yachankichi Yayayni Diospa wasinpi kanayni kashkata? ");
INSERT INTO qupNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Yayanka mamanka chay rimashkanta mana asirtarkakunachu. ");
INSERT INTO qupNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Mamanka tukuy chay rimashkanta yuyayninpi wakaycharka. Chaymanta Jesuska paykunawa pakta Nasaret llaktama kutirka. Chaypi alita wiñarka, yayankunata kasushpa tukuypi. ");
INSERT INTO qupNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Tukuy uras ashwan yachak alita asirtak tukushpa wiñarka. Yaya Dios runakunapas payta yuyarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Jesús ña rukuyashpan romano Tiberio tukuymanta atun apu karka. Chay Tiberioka ña chunka pichka watata kamachishpan Judea allpapi Ponsio Pilato shutiyu apu karka. Galilea allpapi Herodes apu karka. Iturea allpapi Trakonite allpapi Herodespa wawkin Felipe apu karka. Abilinia allpapi Lisanias apu karka. Tukuy chay allpakunapi apukunata romano tukuymanta atun apu Tiberio kamachipayan. ");
INSERT INTO qupNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Saserdotekunapa atun apunkuna Anás Kaifaswa karkakuna. Chay uras Sakariaspa wawan Juan chunlla chakishka allpapi kawsarka. Chaypi kahushpan Yaya Dioska payta rimarka kallarinanpa yachachinata. ");
INSERT INTO qupNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Chasna rimashpan Juan tukuy Jordán yaku mayanpi runakunata yachachishpa purirka kasna rimashpa: Kunanmanta pacha tukuy millaypa rurashkaykichitaka amirishpa sakiychi. Yaya Diospa rimashkanta kasushpana kawsaychi. Chasna rurahushkaykichita rikuchishpa bawtisariychi. Chaypina Yaya Dioska kankunata uchaykichimanta llakichinkami. ");
INSERT INTO qupNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ñawpa Juan manara wawayarihushpanra Yaya Diospa yachayninwa yachachik Isaias Juanmanta killkarka: Chunlla chakishka allpapi shuk runa sinchita rimashpa yachachinka kasna: Imashnami shuk anchu ñampita alichanchi atun apu shamuhushpan purinanpa, chasnashina shunkuykichita alichaychi. Millaypata rurashpa kawsashkaykichita sakiychi Yaya Diospa Kachanan Kishpichikwa alita kawsanaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Anchu ñampita rurashpanchi waykukunata allpawa untachishpa parihuyachinchi. Lumakunata wichushpa parihuyachinchi. Wistu ñampikunata kuskayachinchi. Kaspikunata pitishpa wichunchi. Chasnashina shunkuykichita alichaychi tukuy mana alikunamanta. ");
INSERT INTO qupNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Chasna rurashpaykichimi tukuy runakuna yachankakuna imashnami Yaya Dios runakunata kishpichin nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Achka runakuna bawtisarinankunapa Juanma shamurkakuna. Chaypina Juan paykunata riksishpan mana ali yuyayyu kashkankunata rimarka: Machakuyashina runakuna kankichi, mana ali yuyayyu waklichikkuna. ¿Pita kankunata rimashka chasnalla kishpinaykichipa Yaya Diospa manchaypa kastigananmanta? ");
INSERT INTO qupNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Alitana ruraychi Yaya Diosta kasuk kanaykichita rikuchinaykichipa. Ama yanka rimaychichu yaya rukunchi Abraham wañupa miraymantami kanchi, chayrayku Yaya Dioska ñukanchikunata kishpichinka nishpa. Yaya Dios munamaka, kay rumikunamanta yaya ruku Abraham wañupa mirayninta rurama. ");
INSERT INTO qupNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Rikuychi. Shuk tarpu kaspi mana alita muyuyashpanka amunka sapinpi achawa kuchushpan ninapi rupachin. Chasnallatatami Yaya Dioska tukuy mana ali rurak runakunataka kastigankami. ");
INSERT INTO qupNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Chayta uyashpankuna runakunaka Juanta tapurkakuna: Chasna kashpanka ¿Imatata rurashunchi Yaya Diospa kastigananmanta kishpinanchipaka? ");
INSERT INTO qupNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Chaypi Juanka aynirka: Pipachari tiyan ishkay churarinanka, maykanpachari mana tiyapunchu, chaytaka kuy shuk churarinata. Chasnallatata pipachari tiyan mikunanka, kuy mana tiyapuhukta. ");
INSERT INTO qupNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Romano tukuymanta atun apurayku impuestuta kobrakkunapas paktamurkakuna bawtisarinankunapa. Juanta tapurkakuna: Yachachik, ñukanchita rimay ¿imatata rurashunchi Yaya Diospa kastigananmanta kishpinanchipa? ");
INSERT INTO qupNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Chaypi Juanka aynirka: Amana yapa kullkita kobraychinachu. Imashnachari apukuna kamachinahun, chasnalla kobraychi. ");
INSERT INTO qupNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Shuk suntalukunapas tapuk shamurkakuna: Ñukanchika ¿imatata rurashunchi Yaya Diospa kastigananmanta kishpinanchipa? Paykunatapas Juanka aynirka: Amana kichuychinachu nima pita nima imata, nima manchachishpa, nima llullachishpa, nima yanka uchachishpa. Chay kankunata pagashkankunawa kushilla kawsaychi. ");
INSERT INTO qupNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tukuy chaypi kahuk runakunaka Juanpa rimahushkanta uyashpankuna yuyarirkakuna, kaychari chapahushkanchi Yaya Diospa Kachanan Kishpichikka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Chaypi Juanka tukuy chay runakunata rimarka: Ñukaka yakuwami kankunata bawtisani. Shukmi shamunka ashwan yachayyu ñukamanta. Paymantaka ñukaka mana yapa yachayyuchu kani. Paypa puntanpi nima imata atipanichu rimanata. Payka kankunata Yaya Diospa Espiritunta kushpami shunkuykichita aliyachinka. Ninawa rupachihushkashina uchaykichita pichanka payta kushilla katinaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yuyariychi. Sarata, triguta pallashpanchi tullunmanta muyuntana wishkunchi. Chay muyuntaka wakaychanchi, tullunkunataka ninapi rupachinchi. Chay shamuhuk runaka chasnallatata ruranka. Paymi tukuy Yaya Diosta kirikkunataka siluma apanka. Mana kirikkunataka nina mana wañukmami wichunka. ");
INSERT INTO qupNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Chaymantapas ashwan shimikunawa chaypi kahukkunata kunashpa Yaya Diospa suma ali shiminta runakunata kishpichinanmanta rimarka. ");
INSERT INTO qupNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Apu Herodestapas sinchi shimiwa kunarka, wawkinpa warmin Herodiaswa kawsashkanrayku, chaymanta achka shuk mana alita rurahushkankunaraykupas. ");
INSERT INTO qupNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Chasna rimashpan Herodeska payta karselpi churarka. Chasna rurashkanwa mana ali rurashkankunata ashwanta mirachirka. ");
INSERT INTO qupNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Herodes Juanta manara karselpi churashpanra Juanka achka runakunata bawtisahurka. Chay uras Jesustapas bawtisarka. Chaypina Jesús Yayan Diosta mañahushpan siluka paskarirka. ");
INSERT INTO qupNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Chaypi Yaya Diospa Espiritunka wiwa mukukushina uraykumurka Jesuswa kawsananpa. Silumanta Yaya Dioska rimarka: Kanmi kanki munashkayni wawayni. Kanmi sumakta kushichiwanki nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesuska kimsa chunka watayu kashpan kallarirka Yaya Diospa shiminta yachachinata. Runakuna yuyarirkakuna paymi kan Josepa wawan nishpa. José Elipa wawanmi karka. ");
INSERT INTO qupNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí Matatpa wawanmi karka. Matat Levipa wawanmi karka. Leví Melkipa wawanmi karka. Melki Janapa wawanmi karka. Jana Josepa wawanmi karka. ");
INSERT INTO qupNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José Matatiaspa wawanmi karka. Matatias Amospa wawanmi karka. Amós Nahumpa wawanmi karka. Nahúm Eslipa wawanmi karka. Esli Nagaipa wawanmi karka. ");
INSERT INTO qupNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai Maatpa wawanmi karka. Maat Matatiaspa wawanmi karka. Matatias Semeipa wawanmi karka. Semei Josekpa wawanmi karka. Josek Judapa wawanmi karka. ");
INSERT INTO qupNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá Joananpa wawanmi karka. Joanán Resapa wawanmi karka. Resa Sorobabelpa wawanmi karka. Sorobabel Salatielpa wawanmi karka. Salatiel Neripa wawanmi karka. ");
INSERT INTO qupNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri Melkipa wawanmi karka. Melki Adipa wawanmi karka. Adi Kosampa wawanmi karka. Kosam Elmadampa wawanmi karka. Elmadam Erpa wawanmi karka. ");
INSERT INTO qupNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er Josuepa wawanmi karka. Josué Elieserpa wawanmi karka. Elieser Jorimpa wawanmi karka. Jorim Matatpa wawanmi karka. Matat Levipa wawanmi karka. ");
INSERT INTO qupNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leví Simeonpa wawanmi karka. Simeón Judapa wawanmi karka. Judá Josepa wawanmi karka. José Jonampa wawanmi karka. Jonam Eliakimpa wawanmi karka. ");
INSERT INTO qupNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim Meleapa wawanmi karka. Melea Menapa wawanmi karka. Mena Matatapa wawanmi karka. Matata Natanpa wawanmi karka. Natán Davidpa wawanmi karka. ");
INSERT INTO qupNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David Isaipa wawanmi karka. Isaí Obedpa wawanmi karka. Obed Boospa wawanmi karka. Boos Salapa wawanmi karka. Sala Naasonpa wawanmi karka. ");
INSERT INTO qupNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón Aminadabpa wawanmi karka. Aminadab Adminpa wawanmi karka. Admin Arnipa wawanmi karka. Arni Esrompa wawanmi karka. Esrom Farespa wawanmi karka. Fares Judapa wawanmi karka. ");
INSERT INTO qupNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá Jakobpa wawanmi karka. Jakob Isaakpa wawanmi karka. Isaak Abrahampa wawanmi karka. Abraham Tarepa wawanmi karka. Taré Nakorpa wawanmi karka. ");
INSERT INTO qupNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakor Serugpa wawanmi karka. Serug Ragaupa wawanmi karka. Ragau Pelegpa wawanmi karka. Peleg Heberpa wawanmi karka. Heber Salapa wawanmi karka. ");
INSERT INTO qupNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala Kainanpa wawanmi karka. Kainán Arfaxadpa wawanmi karka. Arfaxad Sempa wawanmi karka. Sem Noepa wawanmi karka. Noé Lamekpa wawanmi karka. ");
INSERT INTO qupNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek Matusalenpa wawanmi karka. Matusalén Enokpa wawanmi karka. Enok Jaredpa wawanmi karka. Jared Mahalaleelpa wawanmi karka. Mahalaleel Kainanpa wawanmi karka. ");
INSERT INTO qupNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainán Enospa wawanmi karka. Enós Setpa wawanmi karka. Set Adanpa wawanmi karka. Adán Yaya Diospa rurashkan runami karka. ");
INSERT INTO qupNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Bawtisarishkanwasha Jesuska paypi kawsak Yaya Diospa Espíritun payta yuyachishpan Jordán yakumanta kutirkana. Chay Espiritunka payta yuyachirka chunlla chakishka allpama rinanpa. ");
INSERT INTO qupNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Chaypi chusku chunka punchata karka. Chay punchakuna supayka Jesusta kayllayashpan kamarka shutipachu Yaya Diosllata kasun nishpa. Tukuy chay chusku chunka puncha Jesuska mana mikurkachu. Ña tukurinan punchakuna yapa yarkarka. ");
INSERT INTO qupNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Chaypina supayka rimarka: Shutipa Yaya Diospa Wawan kashpaykika kay rumita rimay pan tukunanpa, chayta mikunaykipa. ");
INSERT INTO qupNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Chaypi Jesuska aynirka: Nima imashna rurashanchu. Yaya Diospa killkachishkanpi riman: Mana mikunawallachu runaka kawsan nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Chaypi supayka Jesusta urku awama pushashpan kunkaymanta yuyayninllapi tukuy kay allpapi kamachik atun apukuna kamachinan allpakunata rikuchirka. ");
INSERT INTO qupNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Chaymanta rimarka: Kanta kusha tukuy chay allpakunata, tukuy chaypi suma kahukkunatapas, maykantami ñukata kuwashka karka. Chayraykumi maykantachari munani, chayta kuni. ");
INSERT INTO qupNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kunkurishpayki mañawashpaykika tukuy kamachishkaynita rurashpaykika tukuytami kanta kusha chaypi kamachik kanaykipa. ");
INSERT INTO qupNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Chasna supay rimahushpan Jesuska mana munashpan rimarka: Nima imashna rurashanchu. Yaya Diospa killkachishkanpi riman: Yaya Diosllata kunkurishpa mañaychi. Payllata kasushpa kawsaychi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Chaymanta supayka Jesusta Jerusalén llaktama pusharka. Yaya Diospa wasin awama sikachirka. Chaymanta rimarka: Kan Yaya Diospa Wawan kashpaykika kaymanta allpama saltay. ");
INSERT INTO qupNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Yaya Diospa killkachishkanpi nin: Yaya Dioska angelkunata kachanka kanta kuyranankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Paykunami makinkunapi kanta alita kuyrankakuna, mana nima rumipi waktarinaykipa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Chaypi Jesuska aynirka: Nima imashna rimawashpayki saltashanchu. Yaya Diospa killkachishkanpi kaytapas nin: Ama Yaya Diosta yanka kamankichu yachanaykipa payka yanapawankachu manachu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Chasna Jesús mana kasunayashpan supayka manana yacharkanachu imashnami payta llullachinka nishpa. Chayrayku Jesusmanta anchurimurkana shuk punchakama. ");
INSERT INTO qupNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","15","Chaymanta chay chunlla chakishka allpamanta Jesuska Galilea allpapi llaktakunama kutirka. Yaya Diospa Espíritun paypi kashpan yapa yachayyu karka. Tukuy llaktakunapi tantarina wasikunapi Yaya Diospa shiminta yachachipayan. Runakuna payta uyashpankuna tukuy rimarkakuna kay runaka yapa alimi kan nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Chaymanta Jesuska wiñashkan Nasaret llaktanma kutirka. Samana puncha tantarina wasipi yaykurka, imashnami pay wiñay rurapayan chasna. Chaypi runakuna chawpipi shayarirka Yaya Diospa killkachishkanta leyinanpa. ");
INSERT INTO qupNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Chaypina payta kurkakuna Yaya Diospa yachayninwa yachachik Isaiaspa killkashkanta. Chay killkata paskashpan leyirka kasna nishkata: ");
INSERT INTO qupNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Yaya Diospa Espiritunmi ñukawa kan. Yaya Diosmi akllawashka nima imayu runakunata, llakiywa kawsak runakunata paypa suma ali shiminta runakunata kishpichinanmanta yachachinaynipa. Kachawashkami watarishkashina kawsahuk runakunata kishpishka kankichi nishpa rimanaynipa, mana rikunata atipakkunatapas yanapanaynipa kuti rikunankunapa, parisihuk runakunata parisichiy tukuhushkankunamanta kishpichinaynipa. ");
INSERT INTO qupNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Yaya Dios kachawashka runakunata rimanaynipa kunanka llakichiy tukunankunata. ");
INSERT INTO qupNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jesuska leyinata tukuchishpan chay killkata kuti wankurka. Chaymanta shuk runa chay tantarina wasipi yanapakta kutichishpan tiyarirka chay wasipi kahukkunata yachachinanpa. Tukuy runakuna payllata rikushpa chaparkakuna imatami rimanka. ");
INSERT INTO qupNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Chaypina rimarka: Kunanmi kay killkarishkaka paktarishka. Ñukami kani, maykanmantami riman. ");
INSERT INTO qupNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Chaypi tukuy runakuna alita rimarkakuna paymanta. Mancharishpa tapunakurkakuna: ¿Maypishi kay runaka kay suma rimanakunata yachakushka? ¿Imashnashi chasna atun yachayyu tukushka? ¿Manachu kayka Josepa wawan? ¿Imashnataya chasna tukushka? ");
INSERT INTO qupNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesuska paykunata aynirka: Kankunaka rimankichi kay yaya rukunchipa rimananta: Ampinata yachashpaykika kan kikita ampiy nishpa. Chasnallatata rimawankichi: Tukuy imata Kapernaum llaktapi rurashkaykita uyashkanchi. Chasnallatata kunan ruray kikin llaktaykipipas Yaya Diosmanta shamushka kanaykita yachananchipa. ");
INSERT INTO qupNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Alita uyawaychi. Nima shuk Yaya Diospa yachayninwa yachachikta kikin llaktanpika alita yuyanahunchu. ");
INSERT INTO qupNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Chasna kananta ñawpamanta pacha rikunchi. Elias yachachihushkan uras kikin allpanpi achka mashintukuna yarkaywa parisihukkuna tiyashpanpas Yaya Dioska Eliasta mana paykunama kacharkachu yanapananpa. Ashwan payta kacharkami mana israel warmi mashintuma chay warmillata yanapananpa. Chay warmika kawsarka mana israel runakunapa llaktan Sareptapi, Israel allpa anakpi Sidón llakta mayanpi. Chay uras kimsa wata sokta killata mana tamyarkachu. Chasna mana tamyashpan tarpunkunaka mana wiñarkakunanachu. Chayrayku tukuy Israel allpapi sinchi yarkay tiyarka. ");
INSERT INTO qupNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Chasnallatata ñawpa Yaya Diospa yachayninwa yachachik Eliseo kawsashkan uras kikin allpanpi achka runakuna aycha ismuchik unkuywa kahushpankunapas nima shukta Eliseoka ampirkachu. Siria allpapi shuk kamachik mana israel runa Naamán shutiyu chay unkuywa kahushpan payllata ampirka. ");
INSERT INTO qupNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Chaypina tukuy chay tantarina wasipi kahukkunaka Jesuspa rimashkanta uyashpankuna yapa piñarirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Atarishpankuna Jesusta chay llaktamanta llukshichirkakuna. Chay llaktaka urku waykuyahushkanpi rurarishka kashpan Jesusta chay urku awama pusharkakuna chaymanta tankanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Chaypina Jesuska chay achka runakunapa chawpinkunata pasashpa llukshirka. ");
INSERT INTO qupNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nasaret llaktamanta llukshishpan Jesuska Kapernaum llaktama rirka Galilea allpapillatata. Chaypi samana puncha tantarina wasipi yaykurka runakunata yachachinanpa. ");
INSERT INTO qupNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Chay runakunaka yachachishkanta uyashpankuna mancharishpa paykunapura rimarkakuna: Kay Jesuska Yaya Diospa shiminta yachachin Yaya Dios kikin ñukanchita rimahushkashina. ");
INSERT INTO qupNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Chay runakuna chawpipi shuk supay yaykushka runa tiyarka. Jesusta uyashpan supayka chay runata sinchita rimachirka: ");
INSERT INTO qupNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Jesús, Nasaret llaktamanta runa, ama ñukanchima kayllayaychu. ¿Shamushkankichu ñukanchita wichunaykipa ninapi wiñaypa parisinanchipa? Ñuka riksini kanta Yaya Diosmanta shamushka runa kanaykita. ");
INSERT INTO qupNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Chayllapi Jesuska sinchi shimiwa supayta piñarka: Chunllayay. Llukshiy kay runamanta. Chasnallapi chay supayka runakuna chawpipi chay runata allpama urmachishpan nima imanachishpan paymanta llukshirka. ");
INSERT INTO qupNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Chayta rikushpankuna tukuy runakuna mancharishpa paykunapura tapunakurkakuna: ¿Ima rimanataya kayka? Tukuy rimashkanta kasunahun. Kay runaka atun yachayyu kashpan supaykunata rimashkanllawa runamanta llukshichin. ");
INSERT INTO qupNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Chaymanta tukuy Galilea allpapi kawsak runakuna Jesuspa rurashkanmanta yacharkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Chay tantarina wasimanta llukshishpan Jesuska Simonpa wasinpi yaykuk rirka. Chaypi Simonpa warminpa mamanka sinchi kalinturawa puñunanpi sirihurka. Chaypina Jesusta payrayku tapurkakuna ampipay nishpankuna. ");
INSERT INTO qupNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Chaymanta Jesuska kayllayashpan chay unkushkapa kuchunpi kumurishpa sinchita rimarka kalinturanka pasananpa. Chay rimashkanllapi kalinturanka pasarka. Chasna kalinturanka pasashkan ratulla payka atarishpan Jesusta tukuy wasinpi kahukkunatapas mikunata kararka. ");
INSERT INTO qupNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ña intika yaykuhushkanpi runakunaka tukuy unkushkakunata Jesusma pushamurkakuna. Chaypi Jesuska karan shukta makinwa llankashpan ampirka. ");
INSERT INTO qupNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Chasnallatata achka supay yaykushka runakunamanta supaykunata llukshichirka. Chay supaykunaka kaparishpa rimarkakuna: ¡Kanmi kanki Yaya Diospa kikin Wawan! nishpa. Chasna kaparishpankuna Jesuska sinchi shimiwa piñarka. Paykuna yachashpankuna Yaya Diospa Kachashkan Kishpichik kananta Jesuska mana munarkachu chasna rimanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ña pakarimuhushpan Jesuska chay llaktamanta llukshishpan chunlla kahushkama rirka Yayan Diosta mañananpa. Chayma rishpan achka runakuna payta maskarkakuna. Kahushkanpi paktak rishpankuna mana munarkakunachu nima mayma rinanta, ashwan munarkakuna paykunallawa kananta. ");
INSERT INTO qupNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Chaypina Jesuska rimarka: Shuk llaktakunapipas rinayni tiyan kay suma ali shimita yachachinaynipa Yaya Diospa ali kamachinan kay allpapi ña kallarishkanmanta. Chayraykumi kay allpama kachay tukushkani. ");
INSERT INTO qupNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Chaymanta Jesuska tukuy chay allpapi yachachishpa purirka Yaya Diospa shiminta israel runakunapa tantarinankuna wasikunapi. ");
INSERT INTO qupNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Shuk puncha Jesús Genesaret kucha mayanpi kahushpan achka runakuna tantarirkakuna Yaya Diospa shiminta uyanankunapa. Yapa achka runa kashkanrayku tankanakushpa kichkikta Jesuswa pakta kahurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Chaypina Jesuska rikurka ishkay botikunata tiyupi llutachirishkakunata. Challwata apikkuna botinkunamanta llukshishpankuna redinkunata mayllahurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Chaypi Jesuska Simonpa botinpi uraykushpan Simonta nirka: Aku astallastu chawpiyashu. Chaymanta Jesuska botipi tiyarishpan chay achka runakunata yachachirka. ");
INSERT INTO qupNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yachachinata tukuchishpan Simonta rimarka: Chawpiyachiy botikita ashwan chawpima. Chaypi redikichita kachariychi challwata apinaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Chasna nishpan Simonka aynirka: Yachachik, kunan tuta pakarikta rediyashpanchipas nima shuk challwata apishkanchichu. Chasna kashpanpas kunan kan rimawashkaykirayku kuti mushumanta kacharishu redinchita nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Jesuspa rimashkanta kasushpankuna redinkunata kacharirkakuna. Chaypina yapa achka challwata apirkakuna redinkuna likirinayanankama. ");
INSERT INTO qupNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Chay tukuy challwata rikushpankuna shuk botipi kahuk rediyak masinkunata umankunawa kayarkakuna yanapanankunapa. Chaypi tukuymanta ishkanti botinkunata challwawa untachirkakuna. Botinkunaka yapa untakta kashpan tikranalla karkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Jesusta kasushkankunarayku achka challwata apishkankunata rikushpankuna Simón Pedroka, tukuy paywa kahukkunapas yapa mancharirkakuna. Chasnallatata shuk botipi kahuk Simonwa tantaylla rediyakkuna Santiago, Juanpas, Sebedeopa wawankuna yapa mancharirkakuna. Chaypina Pedroka Jesuspa puntanpi kunkurishpan rimarka: Yaya Jesús, anchuriy ñukamanta. Kanmi kanki ucha illa. Ñukaka uchasapami kani. Chaypina Jesuska Simonta rimarka: Ama manchariychu. Imashnami challwata apishpa kawsashkanki, chasnashinami kunanmanta pacha, ñukata katiwahushpayki runakunata yachachinki paykunapas Yaya Diosta kasunankunapa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Chaymanta botinkunata allpama sikachishpankuna tukuy paykunapa tiyashkanta sakishpankuna Jesuswa pakta rirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Shuk puncha Jesús shuk llaktapi kahushpan shuk aycha ismuchik unkuyyu runaka paktamurka. Mana atipashpanpas chay unkuywa runakunata kayllayanata, Jesusma shamurka. Payta rikushpan puntanpi kunkurishpan tapurka: Yaya Jesús, yachani ampinata atipawanaykita. Ali kashpan kanrayku kay unkuymanta ampiway, ampirishpayni kuti atipanaynipa tantaylla kawsanata aylluynikunawa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Chaypina Jesuska makinwa llankashpan rimarka: Ari, munanimi. Kunanka ampirishkami kanki. Ña atipanki aylluykikunawa tantaylla kawsanata. Chasna nishkanllawa chay runaka chay unkuymanta ampirishka karka. ");
INSERT INTO qupNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Chaymantapas rimarka: Ama nima pita rimankichu kanta ampishkaynimanta, ashwan saserdotellama rikuchik rinki ampirishkaykita. Moisespa killkashkanpi kamachishkashina Yaya Diosta kunayki kashkata apashpa churak rinki, tukuy runakuna ampirishkaykita yachanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Chasna Jesús kunashpanpas chay ampirishkaka tukuy runakunata ampirishkanmanta kwintak rirka. Chaypi achka runakuna tantaripayanahun payta uyanankunapa, unkuykunamantapas ampirinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Chayrayku Jesuska anchuripayan nima pi tiyahushkama Yayan Diosta mañananpa. ");
INSERT INTO qupNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Shuk puncha Jesuska yachachihurka shuk wasipi. Chaypi shuk fariseokuna, Moisespa killkashkanta shuk yachachikkunapas tiyahlla kahurkakuna. Paykunaka tukuy Galilea allpapi llaktakunamanta, tukuy Judea allpapi llaktakunamanta, Judeapi kahuk Jerusalén llaktamantapas shamurkakuna. Chaypi Jesuska Yaya Diospa yachayninwa kashpan achka unkushkakunata ampirka. ");
INSERT INTO qupNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Chaypina shuk runakuna apamurkakuna aychan chakirishka runata llanchamanpi sirihushkata Jesusma. Chay runaka mana atipapayanchu kuyurinata. Paykuna yuyarirkakuna, wasi ukuma yaykuchishpanchi Jesuspa puntanpi churashunchi chaypi ampinanpa payta nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Chasna yuyarishpankunatata mana atiparkakunachu yaykuchinata, yapa achka runa tiyashkanrayku. Chayraykuna iskalunta sikarkakuna chay parihu washayu wasi awama. Chaypi sapiramanta rurarishka tablastukunata anchuchishpankuna llanchamanpi sirihushkata chay awamanta uraykuchirkakuna achka runakuna chawpipi Jesuspa puntanpi. ");
INSERT INTO qupNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Chayta rikushpan Jesuska yacharka paykuna yuyarihushkankunata, Jesuska atipama ampinata nishpa. Chaypina chay runata rimarka: Wawki, tukuy uchaykikunamanta llakirishkami kanki nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Chaymanta chay Moisespa killkashkanta yachachikkuna, chay fariseokunapas piñarishpankuna yuyarirkakuna: ¿Pitaya kay runaka chasna rimananpaka? Chasna rimahushpanmi Yaya Diosta piñachihun. Nima pi atipamachu runakunata uchankunamanta llakichinata. Yaya Diosllami atipan llakichinata uchanchikunamanta. ");
INSERT INTO qupNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesuska chasna yuyarihushkankunata yachashpan rimarka: ¿Imaraykutaya chasna yuyarihunkichi shunkuykichipi? ");
INSERT INTO qupNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Kay runataka rimashkanimi uchaykikunamanta llakichirishkami kanki nishpa. Chasna rimashpayni mana yachankichichu shutipachu llakichiy tukushka manachu nishpa. Ñuka kay unkushkata rimaynima atariy, puriy nishpa. Pay alita purishpanna yachankichima ñuka payta ampishkaynita. ");
INSERT INTO qupNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Yachanaykichipa ñuka Yaya Diospa Kachashkan Runa paypa yachayninwa kay allpapi runakunata uchankunamanta llakichinaynita kunalla kay runata ampisha. Chasna nishpan chay unkushkatana rimarka: Kanta rimani atariy. Llanchamaykita apishpayki kutiy wasikima. ");
INSERT INTO qupNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Chasna rimashkanllawa chay aychan chakirishka runaka atarishpan llanchamanta apishpan Yaya Diosta takishpa, kushikushpa wasinma kutirka. ");
INSERT INTO qupNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Chasna rikushpankuna tukuy chaypi kahukkunaka Yaya Diosta atunyachishpa kushichirkakuna. Yapa mancharishpa rimarkakuna: Kunan punchami rikushkanchi yapa sumata, nima ima uras rikushkanchita. ");
INSERT INTO qupNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Chaywasha Jesuska chay llaktamanta llukshishpan impuestuta kobrakta Leví shutiyuta rikurka. Chay impuestuta kobrapayan romano tukuymanta atun apurayku. Levika kobranan wasipi tiyahurka. Payta rikushpan Jesuska rimarka: Leví, shamuy, katiway nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Chay ratulla Levika atarishpan tukuy imanta sakishpan Jesustana katirka. ");
INSERT INTO qupNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Chaywasha Levika Jesusrayku shuk atun mikunata wasinpi rurarka payta yuyashkanta rikuchinanpa. Chay mikunarayku achka impuestuta kobrak masinkuna, ashwan shuk runakunapas chay wasipi tantarishka kahurkakuna. Chay runakuna Jesuspas runankunawa pakta tantaylla mikunankunapa mesa muyukta sirihurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Chayta rikushpankuna fariseokunaka, Moisespa killkashkanta yachachikkunapas Jesuspa runankunata chiknishpankuna tapurkakuna: ¿Imaraykuta kankunaka chay mana alita rurak runakunawa, impuestuta kobrakkunawapas tantaylla mikuhunkichi upyahunkichi? ");
INSERT INTO qupNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Chaypi Jesuska aynirka: Alikunaka mana munanahunchu ampikta. Ashwan unkushkakunami ampikta munanahun ampirinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Chasnallatata ñukaka mana shamushkanichu yanapanaynipa maykanmi riman mana uchayuchu kani nishpa. Ashwan shamushkanimi uchayukunata yanapanaynipa Yaya Diostana kasunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Chasna Jesús yachachihushpan runakuna chiknishpankuna rimarkakuna: Bawtisak Juanpa runankuna, fariseokunapa runankunapas achka kuti mana mikupayanahunchu Yaya Diosta yuyarishpa mañanankunapa. Ashwan kanpa runaykikunaka mana chasnanahunchu, kushilla kashpankuna mikunahunlla upyanahunlla. ¿Imaraykutaya chasnanahun? ");
INSERT INTO qupNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Chasna rimahushpankuna Jesuska aynirka: Shuk musu warmiyahushpanka kayan tukuy ayllunkunata. Kushilla tantarishpa mikunahun mushu warmiyahushkawa pakta. Chasna chay warmiyahuk runawa kushilla tantarihushkankunapi nima pi atipanchu mana mikushpa kanata. ");
INSERT INTO qupNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Shuk puncha kuntrankunaka chay mushu warmiyashkata pushak shamushpankuna chay uraska llakirinkakunami. Llakirishpankunaka mana mikunayankakunachu nishpa. Chasna Jesuska rimarka pay kikin chay mushu warmiyashkashina kashkanta yuyachishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Chaymanta Jesuska shuk yachachinawa yachachishpa katirka: Nima maykan runa llaktanchipi kawsak mushu kamisanmanta pitinchu shuk pitistuta, chaywa mawka kamisanta rimintananpa. Chasna rurashpanpas mana alichu kiparinka, nima mushu nima mawka kamisanka aliyapunkachu. ");
INSERT INTO qupNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","38","Chasnallatatami mushu vinu putskurihushkataka mana churanchichu mawka karamanta rurarishka bulsapi apananchipa. Chay uva yakuka urtiyahushpan putskurin, mawka karamanta rurarishka bulsaka tukyashpan vinuka talirin, chay bulsapas manana valinnachu. Chayrayku mushu vinuta mushu karamanta rurarishka bulsapi churanchi. ");
INSERT INTO qupNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ñukaka mushu shimitami yachachihuni. Ñawpa yaya rukuykichikunapa yachachishkankunaka mana chasnachu kan. Maykanmi paykunapa yachachishkankunata kasunayashpanka manami ñukapataka kasunayankachu, ñawpamanta pacha ñukanchita yachachishkankunaka alimi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Shuk samana punchapi Jesuska runankunawa pakta trigu tarpurishkakuna chawpita rirkakuna. Chaypi runankunaka shuk shuk trigupa puntanta pakishpa, muyunta wishkushpankuna mikurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Chayta rikushpankuna shuk fariseokuna piñarishpa paykunata tapurkakuna: ¿Imaraykuta kay samana punchapika tarawashpa pakihunkichi trigu muyuta mikunaykichipa? ¿Manachu yachankichi Yaya Diospa kamachishkanta samana punchapika mana tarawananchipa? ");
INSERT INTO qupNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Chasna rimahushkankunata uyashpan Jesuska aynirka: ¿Manachu leyishkankichi ñawpa atun apu David wañuka paywa kahukkunapas yarkashpankuna imashnata rurarkakuna? ");
INSERT INTO qupNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Yaya Diospa wasinpi yaykushpan Yaya Diosta rikuchinankunapa mesapi churarishka pankunata apirka mikunanpa Yaya Diosrayku rurarishkata. Paywa purishpa kahukkunatapas kurka mikunankunapa. Chay pankunaka mana paykuna mikunankunapachu karka. Yaya Dios kamachirka saserdotekunalla mikunankunapa. Chasna mikushpankunapas Yaya Dioska chaytaka mana uchatashina rikushpan paykunata mana kastigarkachu. Chayrayku kankunapas runaynikunata mana atipankichichu rimanata uchatami rurashkankichi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Chaymantapas Jesuska nirka: Yaya Dioska ñuka paypa Kachashkan Runata yachayninta kuwashka kankunata rimanaynipa imakunami ali kanahun samana punchapi ruranaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Shuk samana puncha Jesuska tantarina wasipi yaykurka runakunata yachachinanpa. Chaypi tiyarka shuk runa kuska makin chakirishka. ");
INSERT INTO qupNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Chaypina Moisespa killkashkanta yachachikkuna, fariseokunapas rikushpa kahurkakuna, Jesuska ampinkachu manachu nishpankuna payta uchachinankunapa samana punchapi mana rurana kashkata rurashkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesuska yuyarihushkankunata yachashpan chay chakirishka makiyuta rimarka: Atariy, chawpinchipi shayarik shamuy. Chay runaka atarishpan chawpinkunapi shayarik rirka. ");
INSERT INTO qupNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Chaypina Jesuska shukkunata rimarka: Kankunata tapuni, Yaya Diosta kasushpanchika ¿imatata ashwan ruranchima samana punchapika, alitachu millaypatachu? ¿Alichu kama shuk unkushkata ampinanchipa samana punchapi, manapika sakinchimachu wañunanpa? ");
INSERT INTO qupNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Chasna nishpan Jesuska kuchunpi muyukta kahukkunata rikushpan chay runata rimarka: Chutachiy makikita nishpa. Chasna makinta chutachishpan ampirishka kiparipurka. ");
INSERT INTO qupNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Chaypi shukkunaka Jesusta yapa piñarishpankuna paykunapura tapunakurkakuna: ¿Imanachinchimashi kay runata? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Chay punchakuna Jesuska urku awama sikarka Yayan Diosta mañananpa. Chaypi tukuy tuta Yayanta mañarka. ");
INSERT INTO qupNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ña pakarihushpan payta katikkunata kayarka paykunamanta chunka ishkayta akllananpa. Chaymanta chay akllashkankunata rimarka: Kankunami apostolnikuna kankichi, kachanayni runakuna. Kankunata kachasha shiminita yachachinaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Chay akllashkankunapa shutinkunaka karkakuna: Simón, maykantami Jesuska shutiyachirka Pedro, Andrés Simonpa wawkin, Santiago, Juan, Felipe, Bartolomé, ");
INSERT INTO qupNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, shuk Santiago Alfeopa wawan, chaymanta shuk Simón, maykantami rimapayanahun Selote. ");
INSERT INTO qupNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Shukka karka Judas Santiagopa wawan, chaymanta shuk Judas Iskariote shutiyu, maykanmi chaywasha Jesusta apichinan karka. ");
INSERT INTO qupNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Chay chunka ishkay runankunata akllashkanwasha Jesús paykunawa pakta chay urkumanta uraykumurkakuna shuk pampama. Chaypi tantarirkakuna achka payta katihukkunapas. Chaymantapas achka runakuna tukuy Judea allpamanta, Judeapi kahuk Jerusalén llaktamantapas, atun yaku mar mayanmanta, Tiro llaktamanta, Sidón llaktamantapas Jesusma shamurkakuna yachachihushkanta uyanankunapa, unkushkakunapas ampirinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Supay unkuchishka runakunatapas Jesuska ampirka. ");
INSERT INTO qupNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yapa yachayninwa tukuy unkushkakunata ampihushkanta rikushpankuna tukuy chaypi kahukkuna payta llankanayarkakuna ampirinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesuska runankunata rikushpan rimarka: Kankuna kushilla kankichi, Yaya Dios mana yanapawashpanka nima imata atipanichu ruranata nishpa yuyarishpa kawsahushkaykichirayku. Yaya Diosmi kankunata yanapanka wiñayparayku paypa ali kamachihushkanpi kawsanaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kushilla kankichi yarkahukshina Yaya Diospa munashkanta ruranayashpa kawsahushkaykichirayku. Yaya Diosmi kankunata yanapanka paypa munashkanta rurashpa kawsanaykichipa. Chasnallatata kushilla kankichi kunan wakashpa kawsahushkaykichirayku, shuk urasmi asinkichi. ");
INSERT INTO qupNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kushilla kankichi runakuna kankunata chiknishpankuna tantarinaykichi wasikunamanta wichuy tukushpaykichi kamiy tukushpaykichi washanchashpa rimay tukushpaykichi ñuka Yaya Diospa Kachashkan Runata katiwahushkaykichirayku. ");
INSERT INTO qupNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Chasnallatatami ñawpa chay chiknik runakunapa yaya rukunkuna wañuka Yaya Diospa rimashkanta yachachikkunata chiknishpankuna parisichirkakuna. Kunan kankunatapas chasnallatata parisichihushpankuna atunta kushikuychi. Shuk punchami silupi Yaya Dios kankunata atunta kushichinka tukuy chayta parisishkaykichirayku. ");
INSERT INTO qupNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Chaymanta shukkunatana rimarka: Ay kankuna kullkiyu runakuna, ¡imashna kastigushi kankunarayku kanka! Ñami kushilla kawsashkankichi. ");
INSERT INTO qupNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ay kankuna kunan saksashkashina kahukkuna, ¡imashna kastigushi kankunarayku kanka! Saksashkashina kahushkaykichimanta yarkaywashinana kankichi. Ay kankuna, maykankunami kunanka kushilla asihunkichi, ¡imashna kastigushi kankunarayku kanka! Asihushkaykichimanta llakirishpana wakankichi. ");
INSERT INTO qupNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ay kankuna, maykankunamantami tukuy runakuna ali kanaykichita rimanahun paykunapa uyanayashkankunallata yachachishkaykichirayku. ¡Imashna kastigushi kankunarayku kanka! Ñawpa chay runakunapa yaya rukunkuna wañupas llullashpa yachachikkunata ali kanankunata rimarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jesuska yachachishpalla katihushpan rimarka: Kunan kankuna, kiriwak runakuna kashpaykichimi yachachishkaykichi. Kankunata chiknik runakunata yuyaychi. Kankunata piñarihushpankunapas alita ruraychi paykunata. ");
INSERT INTO qupNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kankunata millaypata rimakkunata rimaychi Yaya Dios kankunata yanapashpa kushichichun nishpa. Kankunata kamikkunarayku Yaya Diosta mañapuychi. ");
INSERT INTO qupNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Shuk runa kanta makahushpan uyaykipi sakmashpanka ama rantipaychu. Kutikashka sakmashpanpas ama piñarishpa rantipaychu, ashwan alichay paywa. Chaymanta shuk runa kanta awaniru churarishkaykita kichunayashpanka kamisaykitapas kichunayashpanka sakiy. Ama piñariychu payta. ");
INSERT INTO qupNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Maykanpas imaykita tapuhushpanka kuy. Maykanpas imaykita apashpanka ama rimaychu kutichiway nishpa. Chasna rurashpaykichimi riksinkakuna Yaya Diospa wawankuna kanaykichita. ");
INSERT INTO qupNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kankuna runa masikichikunata yuyashpa alita rurashpa kawsaychi, imashnami kankunapas munankichi paykuna kankunata yuyashpa alita rurashpa kawsanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Yachanchi llullachik runakunapas ayllunkunataka yuyanankunata. Kankuna chasnallatata aylluykichikunallata yuyashpaykichika paykunamanta mana ashwan alitachu rurahunkichi. Paykunashina rurashpalla kawsashpaykichika ¿imamantata Yaya Dioska kankunata kushichinka? ");
INSERT INTO qupNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Yuyanakuk masikichillawa yanapanakushpaykichika uchata rurakkunashinalla kawsankichi. Chasna kawsashpaykichika ¿imamantata Yaya Dios kankunata kushichinka? ");
INSERT INTO qupNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Chaymanta kankuna kutichik runallata shuk imaykichita prestashpaykichika ¿imamantata Yaya Dios kankunata kushichinka? Uchata rurakkunapas kutichik masinkunallata shuk shuk kullkinkunata prestanahun, yuyarishpa ashwanta paykunamanta apinata. ");
INSERT INTO qupNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ñuka kankunata rimani, kankunata chiknik runakunata yuyanaykichi tiyan. Chaymantapas alita ruranaykichi tiyan runa masikichikunarayku. Chaymantapas shuk runa shuk imaykichita tapushpanka prestanaykichi tiyan nima chapashpa chayta kutichinanpa. Chasna rurashpaykichika Yaya Dios kankunata sumakta kushichinka. Paymi kan ali shunku, mana agradesikkunata, millaypa rurakkunatapas chasnalla yuyan. Chasna kankunapas Yaya Diosshina yuyashpa kawsashpaykichimi atun yachayyu Yaya Diospa wawankuna kankichi. ");
INSERT INTO qupNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Imashnami Yaya Dioska tukuy runakunata llakichishpa yuyan, chasnallatata kankunapas, paypa wawankuna kashpaykichi payshina llakichik kaychi. ");
INSERT INTO qupNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Chaymanta Jesuska ashwanta yachachishpa katirka: Yaya Dioska mana kanta kastigananpa, ama rimankichu shuk runa masikichimanta payka mana alichu kan nishpa. Yaya Dioska kankunata nina mana wañukma mana kachananpa, ama rimankichichu uyachikshina shukkunamanta Yaya Diosmi kanta kachanka nina mana wañukma nishpa. Tukuy runa masikichita llakichinaykichi tiyan. Chasna runa masikichita llakichishpaykichika Yaya Diospas kankunata llakichinka. ");
INSERT INTO qupNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Maykanpami tiyan imankunaka, pishihukkunata mana mitsashpa kuychi. Chasna mana mitsashpa kushpaykichika Yaya Diospas kankunata ashwan achkatami kunka. Kankuna runa masikichita rurashkaykichishina, chasnallatata Yaya Dioska kankunatapas ruranka. ");
INSERT INTO qupNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Chaymanta Jesuska chaypi kahukkunata shuk yachachinawa rimarka: Shuk wiskuka wisku masinta pushahushpanka ¿atipamachu alita purichinata? Shuk uchku allarishka kashpan ¿manachu chaypi ishkanti urmanahuma? Chasnallatata maykanmi Yaya Diospa shiminta mana alita asirtanchu, mana atipanchu kankunata yachachinata. ");
INSERT INTO qupNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nima maykan yachakuk payta yachachikmanta ashwan yachak kanchu. Chasna kashpanpas tukuyta alita yachakushpan payta yachachikshinallatata kanka. ");
INSERT INTO qupNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","Runa masikipa ñawinpi shuk uchilla susyastu tiyamaka, shuk ratu rikunkichima. Ashwan kankunaka kikin ñawikichipi ashwan atun susya tiyamaka, mana rikunkichimachu. Ñawikichipi ashwan atun susya tiyamaka runa masikichipa ñawinpi kahukmanta, mana alichu kama payta rimanaykichipa ñawikimanta susyata surkushara nishpa. Chasna rurankimaka kan kikintami llullachirinkima. Ashwan puntiru kan kikinpa ñawikimantara chay atun susyata surkuy. Chaymanta alita rikushpayki runa masikipa ñawinmanta chay uchillastu susyata surkuy. Chasnallatata puntiru kan kikinpa uchaykita sakinayki tiyan. Chaypirami atipankichi runa masikita kunanata paypa uchanta sakinanpa. ");
INSERT INTO qupNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Chaymanta Jesuska shuk yuyayta rimarka: Tarputa yuyariychi. Ali tarpuka mana millaypatachu muyuyan. Chasnallatata millaypa tarpupas mana alitachu muyuyan. ");
INSERT INTO qupNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Karan tarputa muyuyananmanta riksinchi. Papayu mana muyuyamachu kasha muyuta. Champiraka mana muyuyamachu papayuta. ");
INSERT INTO qupNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Chasnami kan runakunawapas. Ali yuyayyu runaka ali shimikunallatami riman, alikuna shunkunpi kashkanrayku. Millaypa yuyayyu runaka millaypakunallatami riman. Chay millaypa yuyaykunaka shunkunpi kashpan millaypakunaka shunkunpi mirashpan shiminka riman. ");
INSERT INTO qupNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Imaraykuta kankunaka karan uras rimawankichi Yaya Jesús, Yaya Jesús, kamachishkaynita mana kasushpaykichitata? ");
INSERT INTO qupNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kunan rimashkaykichi maykanmi ñukama shamushpan shiminita alita uyan, kamachishkaynitapas kasun, payka kasnami kan: ");
INSERT INTO qupNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Shuk runa sumakta wasinta lumapi rurarka, allpata ukuta allashpan orkonkunata shayachirka. Chaymanta atun untay shamurka. Chay wasita mana imanachirkachu, alita rurashka kashkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Maykan runami shiminita uyashpanpas kamachishkaynita mana kasunchu, payka kasnami kan: Shuk runa wasinta tiyupi rurarka. Mana ukuta allashpan orkonkunata shayachirka. Chaymanta untay shamushpan chay wasita shuk ratu urmachirka. Llampu warankarishpan tukuyta wichurka. ");
INSERT INTO qupNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Chay achka runakunata yachachishkanwasha Jesuska Kapernaum llaktama rirka. ");
INSERT INTO qupNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Chay llaktapi shuk kapitan tiyarka Roma llaktamanta. Paypa tiyarka shuk yuyashkan runan sinchita unkushka, ña wañunalla karka. ");
INSERT INTO qupNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Chay kapitanka Jesusmanta uyarka achka unkushkakunata ampihushkanta. Chayta yachashpan israel runakunata kamachik rukukunamanta shukkunata kacharka Jesusta kayak rinankunapa runanta ampinanpa. ");
INSERT INTO qupNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Paktak rishpankuna Jesusta ali shunkuwa tapurkakuna: Yachachik, ali kama chay kapitanta yanapanaykipa. ");
INSERT INTO qupNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Payka Romamanta runa kashpanpas ñukanchi israel runakunata alita yuyashpan tantarinanchi wasita rurachishka. ");
INSERT INTO qupNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Chasna rimashpankuna Jesuska paykunawa pakta rirka chay kapitanpa wasinma. Ña kuchuyahushpankuna chay kapitanka shuk amigunkunata kacharka Jesusta rimanankunapa: Yachachik, amigunchi kapitanmi riman: Ñukamanta yapa pasa kashpayki imaraykuta wasinima shamuhunki. Ama shamuychu. Puntaykipi nima imachu kani wasinima shamunaykipa. ");
INSERT INTO qupNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Chayrayku mana ñuka kikin rishkanichu kanta kayanaynipa. Chaymantalla shuk shimita rimay runaynika ampirinanpa. ");
INSERT INTO qupNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ñukapapas tiyanmi apuynikuna kamachiwanankunapa. Paykuna kamachiwashpankuna kasunayni tiyan. Chasnallatata ñuka suntaluynikunata kamachishpayni paykunapas kasuwanankuna tiyan. Maykan suntaluynitami riy nishpaynika payka rinmi. Shukta shamuy nishpaynika shamunmi. Maykan runaynikunatapas kayta rurapaychi nishpaynika paykunaka kasushpankuna ruranahun. Chasnallatatami kanka shuk shimillawa atipanki anchuchinata unkuyta kay runaynimanta. ");
INSERT INTO qupNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Chasna chay kapitanpa rimashkanta rimashpankuna Jesuska yapa kushikurka. Chaymanta tukuy chay katihukkunama tikrarishpan rimarka: Kankunata rimani, tukuy israel masinikunamanta nima maykan tukuy shunkunmanta pacha kiriwashkanta tarishkanichu kay romano runatashina. Ñukanchi israel runakuna Yaya Diospa akllashkankuna kashpanchitata kankunaka mana kay runashinachu kiriwankichi. ");
INSERT INTO qupNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Chasna Jesús rimashpanna chay kapitanpa kachashkan runakunaka kutirkakuna. Kapitanpa wasinpi paktashpankuna chay unkushkata tarirkakuna ña ampirishkatana. ");
INSERT INTO qupNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jesuska chay kapitanpa runanta ampishkanwasha runankunawa pakta Naín llaktama rirka. Achka runakunapas paykunawa pakta rirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Chay llakta kuchupi paktahushpankuna shuk wañushkata apahukkunata rikurkakuna allarishka urku uchkupi churashpa tapanankunapa. Chay wañushkaka shuk mashintupa shuklla wawan karka. Achka runakuna chay llaktamanta chay mashintuwa pakta rihurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Chayta rikushpan Jesuska sinchita llakirishpan chay mashintuta rimarka: Ama wakaychu. ");
INSERT INTO qupNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Chasna nishpan chay wañushkata sirichishpa apahushkankunata kayllayashpan apik rirka. Chaypina wañushkata apahukkunaka shayarirkakuna. Chaypi Jesuska chay wañushkata rimarka: Musu, atariy. ");
INSERT INTO qupNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Chasna nishkanllapi chay wañushka musuka kawsarirka. Tiyarishpan kallarirka rimanata. Chaypina Jesuska kawsachishkan musuta mamantana kurka. ");
INSERT INTO qupNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Chayta rikushpankuna tukuy chaypi kahukkuna yapa mancharirkakuna. Yaya Diosta kushichishpa rimarkakuna: Tukuymanta ashwan atunmi kanki, kay yachaykiwa rimak runata ñukanchima kachamushkaykirayku. Chaymanta rimarkakuna: Yaya Diosmi shamushka ñukanchi paypa akllashkan runankunata yanapananpa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Tukuy Judea allpapi kawsak runakuna, chay Judeawa pakta kahuk allpakunapi kawsakkunapas yacharkakuna Jesús chay wañushkata kawsachishkanta. ");
INSERT INTO qupNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Bawtisak Juan apirishka kashpan runankunaka kwintapayanahun Jesuspa tukuy rurahushkankunata. Chayta yachashpan Juanka ishkay runankunata kayarka. ");
INSERT INTO qupNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Paykunata Jesusma kacharka tapunankunapa: ¿Kanchu chapahushkanchi Yaya Diospa Kachanan Runa kanki? Manapika ¿shuktachu chapashunchi? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Juanpa kachashkankunaka Jesusma paktashpankuna payta tapurkakuna: Bawtisak Juan ñukanchita kachashka kanta tapunanchipa: ¿Kanchu chapahushkanchi Yaya Diospa Kachanan Runa kanki? Manapika ¿shuktachu chapashunchi? ");
INSERT INTO qupNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Chay uras Jesuska achka runakunata unkushka kahushkankunamanta parisinankunamantapas ampirka. Supay yaykushka runakunatapas aliyachirka. Achka wiskukunapa ñawinkunata aliyachirka alitana rikunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Chay tukuy runakunata ampishkanwasha Juanpa runankunata rimarka: Juanta kwintak riychi tukuy rikushkaykichita, tukuy uyashkaykichitapas. Wiskukuna mushumanta rikunahun. Mana purinata atipakkunapas mushumanta purinahun. Aycha ismuchik unkuyyukunapas ampirishka kanahun. Mana uyanata atipakkunapas mushumanta uyanahun. Wañushkakunapas kuti kawsarinahun. Nima imayu runakuna Yaya Diospa suma ali shiminta runakunata kishpichinanmanta uyahunkuna. ");
INSERT INTO qupNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kushillami kanka maykanmi mana sakishpa katiwan nishpa Jesuska Juanpa kachashkan runankunata rimarka. ");
INSERT INTO qupNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Paykuna kutishkankunawasha Jesuska chaypi kahukkunata Juanmanta rimarka: Kankunaka chunlla chakishka allpama rishpaykichi ¿imashna runatata rikunayarkankichi? ¿Shuk muspa yuyayyu runatachu rikunayarkankichi? Mana chasnatachu rikuk rirkankichi. ");
INSERT INTO qupNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Shuk suma churarishka runatachu rikuk rirkankichi? Mana chasnatachu rikuk rirkankichi. Suma churarishka kahukkunaka apukunapa wasinkunapimi kawsanahun. ");
INSERT INTO qupNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Chasna kashpan ¿imata rikunayashpaykichitaya rirkankichi? ¿Yaya Diospa yachayninwa shuk yachachiktachu rikunapa rirkankichi? Kankunata rimani, ari, chayraykumi rirkankichi. Mana chasna runallatachu rikunapa rirkankichi, Yaya Diospa yachayninwa ñawpa yachachikkunamanta ashwan yachaktami rikunapa rirkankichi. ");
INSERT INTO qupNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Chay Juanmanta kasna killkarishka kan ñawpa Yaya Diospa rimashkanka: Ñukaka shuk runata kachasha runakunata shiminita rimananpa. Payka manarapas kanta kachahushpayni runakunata kanmanta rimak rinka shunkunkunata alichashpankuna alita kanta kayanankunapa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ñukaka kankunata rimani, ñawpamanta pacha tukuy kay allpapi kawsak runakunamanta Juanmi ashwan sumakta Yaya Diospa shiminta yachachik kan. Chasna Juan tukuy yachachikkunamanta ashwan yachak kashpanpas maykanmi Yaya Diospa kamachishkan tukushpa paypa ali kamachihushkanpi kawsan, mana yachak kashpanpas chaymi Juanmanta pasa kan. ");
INSERT INTO qupNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Juanpa yachachihushkanta uyashpankuna achka runakuna romano tukuymanta atun apurayku impuestuta kobrakkunapas yacharkakuna Yaya Dios payta yuyachishpan yapa alita rimashkanta. Chayrayku munarkakuna Juan paykunata bawtisananpa. ");
INSERT INTO qupNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Fariseokuna, Moisespa killkashkanta yachachikkunapas mana munashkakunachu Yaya Dios paykunata yanapananpa. Chayrayku mana Juanma rirkakunachu bawtisarinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Chaypina Jesuska yachachishpalla katirka: Kankuna Yaya Diosta mana kasunayak runakuna ¿imawashi kankunata yachachinima? ");
INSERT INTO qupNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kankunaka ñampipi tiyarishpa pukllak wawakunashinami kankichi. Paykunaka shuk wawa masinkunata kaparishpa rimanahun: Ñukanchi kenata pukushpanchipas mana baylashkankichichu. Chaymanta llakiypata takishpanchipas mana wakashkankichichu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","34","Chasna nima pita kasunayak wawakunashina kashpaykichi nima Bawtisak Juanta, nima ñukata kasunayashkankichichu. Juan mana tukuy runakunashina panta mikushpan nima vinuta upyashpan rimankichi supay yaykushka kananta. Chaymanta ñukana Yaya Diospa Kachashkan Runa shamushkani, upyani, mikuni. Ñukataka rimawankichi: Kanka mikuysiki upyaysikimi kanki, mana ali rurakkunapa, romano tukuymanta atun apurayku impuestuta kobrakkunapapas amigunmi kanki nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Chasna rimashpaykichipas ñukanchi Yaya Diosta kasushpa tukuyta alillata rurahushpanchi rikuchinchimi paypa suma yachayninwa kahushkanchita. ");
INSERT INTO qupNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Chaymanta shuk fariseo Simón shutiyu Jesusta kayarka wasinpi mikuk rinanpa. Chay fariseopa wasinpi ña yaykushpan Jesuska mesa mayanpi siririrka mikunanpa, imashnami mikupayanahun chasna. ");
INSERT INTO qupNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Chay llaktapi tiyarka shuk mana alita kawsak warmi. Chay warmika Jesús fariseopa wasinpi paktashkanta yachashpan payma rirka. Shuk yura rumimanta rurarishka butillapi mishkinlla asnak perfumita apashpan Jesusta kayllayarka. ");
INSERT INTO qupNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jesuspa washanmanta kayllayashpan chakin parti kunkurishpan wakarka. Ñawin yakuwa chakinta ukuchishpan mayllarka. Chaymanta chukchanllawa chakinta chakichishpan mucharka. Chaymantapas perfumita Jesuspa chakinpi talirka. ");
INSERT INTO qupNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Chayta rikushpan Jesusta kayak fariseoka yuyarirka kay runa Yaya Diospa yachayninwa yachachik kashpanka yachama karka kay warmika mana alita kawsak kananta. ");
INSERT INTO qupNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesuska fariseopa yuyayninta yachashpan nirka: Simón, kanta shuk shimita rimanayani. Chaypi fariseoka aynirka: Ari yachachik, rimaway. ");
INSERT INTO qupNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesuska rimarka: Ishkay runakuna kullkita patronta liwirkakuna. Shuk liwirka pichka pachak kullkita, shukka liwirka pichka chunka kullkita. ");
INSERT INTO qupNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Chaymanta patronka tapushpan kutichinankunapa, mana atiparkakunanachu kutichinata. Mana atipashpankuna kutichinata, ishkantita patronka rimarka: Liwiwashkaykichita manana pagawankichinachu nishpa. Kunanka rimaway ishkanti llakichirishkankunamanta ¿maykanta ashwanta patronta yuyama? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simonna aynirka: Ñuka yuyarini maykanmi ashwan kullkita liwirka, chaymi ashwanta patronta yuyama. Jesusna rimarka: Alitami ayniwashkanki. ");
INSERT INTO qupNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Chasna nishpan chay warmita rikushpan Simonta nirka: ¿Rikushkankichu kay warmi rurawahushkanta? Wasikipi yaykuhushpayni kanka mana yakuta kuwashkankichu chakinita mayllanaynipa. Kay warmika ñawin yakuwa chakinita mayllapashka, chaywasha chukchanwa chakichipashka. ");
INSERT INTO qupNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kanka saludanakushpanchi mana muchawashkankichu. Kay warmika yaykushkaynimanta pacha chakinita muchapashka. ");
INSERT INTO qupNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kanka nima aseiteta umaynipi taliwashkankichu. Kay warmika yapa suma mishkihlla asnak perfumita chakinipi talipashka. ");
INSERT INTO qupNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Chayrayku kanta rimani, payka yachan tukuy uchankunata llakichinaynita. Chayrayku yapa yuyawashpan chakinita mayllapashka. Kanka yuyarinki uchillastu uchaynika nishpa. Chasna yuyarishpaykimi uchillastu uchakunamantalla llakichiy tukushkanki. Chayrayku mana yapa yuyawankichu. ");
INSERT INTO qupNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Chasna nishpan chay warmitana rimarka: Uchaykikunamanta llakichirishkami kanki nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Chaypina Jesuswa pakta kayay tukushka runakunaka paykunapura tapunakurkakuna: ¿Pitaya kay runaka, uchankunamanta chasna llakichinanpaka? ¿Yaya Diosshinachu tukunayan? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesuska chay warmita ashwan rimarkalla: Kanmi tukuy shunkuykimanta pacha kiriwashkanki. Chayrayku tukuy uchaykikunamanta llakichishkani. Kushilla wasikima riy nima pita manchashpa. ");
INSERT INTO qupNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","2","Chaymanta Jesuska achka llaktakunapi purirka, Yaya Diospa suma ali shiminta yachachishpa Yaya Diospa ali kamachinan kay allpapi ña kallarishkanmanta. Chay chunka ishkay akllashkan runankunaka paywa pakta rirkakuna, chaymantapas shuk warmikuna. Chay warmikunatami manara paywa purihushpankuna Jesuska unkushka kahushkankunamanta ampirka, supay yaykushkankunamantapas aliyachirka. Shukka karka Magdalamanta Maria, maykanmantami Jesuska kanchis supaykunata llukshichirka. ");
INSERT INTO qupNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Shukka karka Kusapa warmin Juana. Chay Kusaka karka apu Herodespa wasinpi kamachik. Shukka karka Susana. Chaymanta ashwan achka warmikunapas Jesusta katirkakuna. Paykuna tukuy ima tiyapushkankunawa Jesusta yanaparkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Achka llaktakunamanta runakuna Jesusma tantarimurkakuna. Chaypi Jesuska paykunata yachachihushpan kasna rimarka: ");
INSERT INTO qupNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Akuychi yuyarishunchi. Shuk runa llukshirka tarpunanpa arus muyukunata wichashpa. Chasna tarpushpan shuk muyukunaka ñampipi urmarkakuna. Runakunaka awanta purishpankuna pulbuchirkakuna. Chaypina pishkukunana mikurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Shuk muyukunaka llapcha allpa samantasapapi urmarkakuna, shuk ratu tukyarirka. Chakishka allpaka kashkanrayku llampu wañurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Shuk muyukunaka kasha kiwa chawpipi urmarkakuna. Chay kashawa pakta wiñahushpan llampu tapashpan wañuchirka. ");
INSERT INTO qupNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Shuk muyukunaka suma allpapi urmarkakuna. Chay muyuka wiñashpankuna achkata muyuyarka. Shuk muyumantalla shuk pachak muyustukuna mirarka. Chasna nishpan Jesuska sinchita rimarka: Kay yachachishkaynita alita uyashpa yachakuychi. ");
INSERT INTO qupNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Chayta uyashpankuna runankunaka Jesusta tapurkakuna: Chay yachachishkaykika ¿ima ninayantaya? ");
INSERT INTO qupNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Chaypi Jesuska paykunata aynirka: Kankunallata Yaya Dios yachachihun nima pi yachashkanta, imashnami paypa ali kamachinanka kay allpapi. Shukkunatami yachachini chasna mana yapa asirtaypa yachachinakunawa. Uyashpankunapas mana asirtankakunachu. Rikushpankunapas mana yachankakunachu imaraykumi chayta rurani nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Chaymanta rimarka: Chay yachachishkaynika kasnami ninayan: Muyuka ninayanmi Yaya Diospa shimin. ");
INSERT INTO qupNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Muyu ñampipi urmashkaka ninayanmi: Shuk runakuna Yaya Diospa shiminta uyanahun alita. Chaymanta supayka shamushpan chay Yaya Diospa shimin uyashkankunata kunkachin. Chasnaka manana kasunahunchu kishpishka kanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Muyu samantasapapi urmashkaka ninayanmi: Shuk runakuna Yaya Diospa shiminta kushilla uyanahun. Chay muyukunaka wiñarishpan mana sumakta ankuyashkachu kanahun. Chasnashinami chay runakunaka shuk ratulla Yaya Diosta kushilla katinahun. Chaymanta ima kamanakunapas paykunata Yaya Diosmanta anchuchin manana payta kasunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Muyukuna kashasapapi urmashkaka ninayanmi: Shuk runakuna Yaya Diospa shiminta munashpankunapas mana sakinayanahunchu ñawpa kawsashkankunata. Paykuna kay allpapi kawsanankunapa munashkankunallata yuyarishpa musparinahun. Yuyarinahun kay mundupi imankuna tiyashkankunallata, kullkillata munashpa, imankunata mirachinayashpa, chaymanta paykuna kikinllata kushichinankunapa yuyarishpa kawsanahun. Chay runakunaka tarpu mana muyuyakshina kashpankuna Yaya Diospa shiminta kunkarinahun. ");
INSERT INTO qupNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Shuk muyukuna, ali allpapi urmashkaka ninayanmi: Shuk runakuna ali yuyaywa Yaya Diospa shiminta shunkunkunapi wakaychanahun. Chaymantapas mana sampayashpa kasushpankuna alikunata yuyarishpa rurashpa kawsanahun. ");
INSERT INTO qupNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Nima pi lamparinta apichishpan shitik awarishka tasawa tapamachu, nima kawitu ukuma tiyachimachu. Ashwan tiyachinchimi lamparin tiyachina awapi chay wasipi yaykuhukkunata punchayachinanpa. ");
INSERT INTO qupNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Chasnallatata Yaya Diospa shimin yachachishkaynika lamparinshina punchayachin runakunata. Puntiru mana asirtashkankunata chaymanta tukuyta asirtankakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Chayrayku alita uyaychi rimanaynita. Maykanmi alita uyashpan Yaya Diospa shiminta kasun, payka ashwan suma yuyaytami kuy tukunka. Maykanmi Yaya Diospa shiminta uyashpan mana kasunayanchu, payka uchillastu uyashkankunatapas kunkachiy tukunka. ");
INSERT INTO qupNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Chaymanta Jesuspa maman wawkinkunapas paktamurkakuna paypa kahushkanpi. Yapa achka runakuna chaypi kahushkankunarayku mana atiparkakunachu kayllayanata. ");
INSERT INTO qupNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Chaypi Jesusta rimarkakuna: Mamayki wawkikikunapas kahunkunami kanchapi, kanta chapahunkuna kwintanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Chasna rimashpankuna Jesuska aynirka: Yaya Diospa shiminta uyashpa kasukkunami mamaynishina wawkinikunashina kanahun. ");
INSERT INTO qupNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Shuk puncha Jesuska runankunata rimarka: Akuychi chimpashunchi kay kuchata. Botipi uraykushpankuna chimpahurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Chimpahushkankunapi Jesuska puñushpa rihurka. Chaypi sinchi wayra shamurka, atun ulaskuna shayarirkakuna kucha tapakta. Botinkunapi yakuka untarihushpan, ña tikranayahurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Chaypina runankuna yapa mancharishpankuna Jesusta likchachishpankuna rimarkakuna: ¡Yachachik, ñami tikrahunchi! Chaypi Jesuska likcharishpan wayrata, atun ulasta sinchi shimiwa rimarka: ¡Kasillayay wayra! ¡Kasillayay ulas! Chasna rimashkanllawa pasarirka wayraka, ulaskunapas, manana ulasyarkanachu. ");
INSERT INTO qupNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Chasna pasachishkanwasha Jesuska runankunata rimarka: ¿Ñukawa kahushpaykichitatachu mancharinkichi? Sinchikuychi ñukapi. Chasna uyashpankuna runankunaka yapa mancharishpa tapunakurkakuna paykunapura: ¿Pishi kay runaka? Rimashkanllawa wayra yakupas kasushpa kasillayanahun. ");
INSERT INTO qupNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jesuska runankunawa pakta chay kuchata chimpashpankuna Gerasa allpama paktarkakuna. Gerasa karka Galilea allpa chimpapi. ");
INSERT INTO qupNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Paktashpankuna Jesuska botimanta allpama sikahushpan tinkunakurka chay llaktamanta shuk supayyashka runawa. Chay runaka llatan kawsapayan. Mana wasipi kawsapayanchu, wañushkakunata churana urku uchkupi kawsapayan. ");
INSERT INTO qupNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Jesuska chay supayyashka runata rikushpan paypi kahuk supayta rimarka: Llukshiy kay runamanta nishpa. Chasnallapi chay runaka Jesuspa puntanpi kunkurik shamurka, sinchita kaparishpan nirka: ¡Ay tukuymanta atun yachayyu Yaya Diospa Wawan Jesús! ¿imaraykuta ñukama shamushkanki? Kanta tapuni amara kastigawayrachu. Unaymanta pacha chay runaka achka supaykunawa kawsapayan. Runakuna achka kuti makinta chakinta kadenakunawa sumakta watashpankunapas supaykuna payta sumakta amuyashpankuna kadenata pitishpan mitikupayan nima runa tiyashkama. ");
INSERT INTO qupNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Chaypina Jesuska tapurka: ¿Ima shutita kanki? Supayyashka kashpan kasna aynirka: Shutinika kanmi Warankakuna nishpa. Yapa achka supaykuna paypi kashkankunarayku chasna aynirka. ");
INSERT INTO qupNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Chay uras chay supaykunaka Jesusta tapurkakuna: Ama ñukanchita kachankichu chay manchaypa uchkuma, maypimi taparishka kashunchi. ");
INSERT INTO qupNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Chay urkupi achka kuchikuna mikuhlla kahurkakuna. Supaykunaka tapurkakuna: Ñukanchita kachay kawsananchipa chay kuchikunapi. Alimi, yaykuychi kawsanaykichipa nishpa rimarka Jesuska. ");
INSERT INTO qupNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Chaypina chay supaykunaka chay runamanta llukshirkakuna kuchikunapina kawsanankunapa. Chay kuchikunaka kunkaymanta tukuy waykuma kallpashpankuna pultyarishpa yakuma urmarkakuna. Chaypina tukuy chinkarirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Chasna pasahushkakunata rikushpankuna chay kuchita kuyrakkunaka mancharirkakuna. Chaymanta llaktama kallparkakuna tukuy wasikunapi rimak rinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Chaypina runakunaka shamurkakuna rikunankunapa shutipachu kuchikuna chinkarishkakuna manachu nishpa. Jesús kahushkanpi paktashpankuna chay runa, maykanmantami supaykunaka llukshishkakuna, suma churarishka, ali yuyaywana Jesuspa kuchunpi tiyahukta tarirkakuna. Chasna payta rikushpankuna mancharirkakuna. ¿Imanachishkashi kay runata? nishpa yuyarirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Chay Jesuspa rurashkanta rikuk runakunaka kwintarkakuna, imashnami chay runaka supaykunamanta ampirishka. ");
INSERT INTO qupNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Chaymanta tukuy Gerasa allpapi kawsak runakuna mancharishpankuna Jesusta rimak shamurkakuna: Anchuriy ñukanchimanta. Chasna nishpankuna Jesuska botipi uraykushpan runankunawa pakta kutirka. ");
INSERT INTO qupNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Chasna rihushpankuna chay ampirishka runaka Jesuswa rinayarka. Ñukapas rinayani kanwa nishpa rimarka. Jesuska mana munashpan nirka: Llaktaykima kutiy rimak rinaykipa imashnami Yaya Dioska kanta ampishka nishpa. Chasna rimashpan chay runaka llaktanma kutishpan tukuy runakunata kwintak rirka Jesuska ñami ampiwashka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesuska Gerasa allpamanta kucha chimpama kutirka. Chaypi paktashpan achka runakuna payta chapahurkakuna kushikushpa tinkunankunapa. Ali yuyaywa payta kayarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Chaypi tantarina wasipi shuk kamachik Jairo shutiyu Jesusta kayllayak shamurka. Chay Jairopa shuklla warmi wawan chunka ishkay watayu wañuhurka. Chay runaka Jesuspa puntanpi kunkurik shamurka. Chaypi rimarka: Yachachik, kanta tapuni wasinima rinaykipa. ");
INSERT INTO qupNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Shuklla warmi wawayni ña wañuhun. Jesuska Jairowa pakta rihushpan achka runakuna tankanakushpa kichkikta paykunawa pakta rihurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Chay runakunapa chawpinpi shuk unkushka warmipas rihurka. Chunka ishkay watata paymanta tukuy uras yawarka urmapayan. Nima pi atipapayanchu chay warmita ampinata. Tukuy imankunata tukuchirka ampikkunata pagashpan. ");
INSERT INTO qupNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Chay warmika Jesuspa washanmanta kayllayashpan churarishkan shimi puntata llankarka. Chasna llankashkanllapi yawarnin urmahushkaka pitirirka. ");
INSERT INTO qupNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Chaypi Jesuska rimarka: ¿Pitaya llankawashka? Karan shuk rimarka: Ñukaka kanta mana llankashkanichu. Chaypi Pedroka rimarka: Yaya Jesús, kay tukuy runakuna muyukta tankanakushpa kahushpankunami kanta llankashkakuna. ¿Imaraykutaya tapunki ñukanchita pita llankawashka nishpa? ");
INSERT INTO qupNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Chasna aynishpankuna Jesuska rimarka: Musyani yachayniwa ampishkaynita. Chayrayku yachani, maykanmi llankawashka chaytami ampishkani. ");
INSERT INTO qupNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Chaymanta chay ampirishka warmika Jesús ña yachashka nishpan chukchurishpa kayllayak shamurka. Jesuspa puntanpi kunkurik shamushpan tukuypa uyashkanpi rimarka: Yapa unkushka kashpaynimi churarishkaykita llankashkani. Chay llankashkaynillawami ampirishkani. ");
INSERT INTO qupNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Chaypi Jesuska rimarka: Panini, ñuka kanta ampinaynita yuyarishpa ñukama shamushkaykirayku ñami ampirishka kanki. Kushilla riy. Ama manchankichu. ");
INSERT INTO qupNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesús chasna rimahushkanllapira chay tantarina wasipi kamachik Jairopa shuk runan wasinmanta payta rimak shamurka: Ña wawaykika wañushka. Ama yankamanta pushamuychu kay yachachikta. ");
INSERT INTO qupNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Chayta uyashpan Jesuska Jairota rimarka: Ama mancharinkichu. Ñukallapi sinchikuy. Chasna ñukapi sinchikushpayki wawaykika kishpichiy tukunka. ");
INSERT INTO qupNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Wasinpi paktashpankuna Jesuska mana munarkachu tukuy yaykunankunapa. Pedro, Juan, Santiago, chay wawapa yayankuna, paykunalla paywa pakta yaykurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tukuy wañushkata rikunapa shamuhukkunaka kanchapi sinchita kaparishpa wakahurkakuna. Paykunata Jesuska rimarka: Ama wakaychichu. Kay warmi wawaka manami wañushkachu, puñuhunmi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Shutipa wañushka kashkata yachashpankuna Jesusta asichirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jesuska chay wawapa kwartunpi yaykushpan wañushkata makinmanta apishpan sinchita rimarka: Shipas, atariy. ");
INSERT INTO qupNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Chasna rimashkanllapi chay wañushka shipaska kawsarishpa atarimurka. Chaypina Jesuska rimarka: Karaychi. ");
INSERT INTO qupNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Chayta rikushpankuna chay shipaspa yayan mamanpas yapa kushikurkakuna. Chaypina Jesuska paykunata rimarka: Ama rimankichichu nima pita kay wawaykichita wañushkanmanta kawsachishkaynita nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Shuk puncha Jesuska chay chunka ishkay runankunata tantachishpan yachayta kurka atipanankunapa runakunamanta supaykunata llukshichinata, unkushkakunatapas ampinata. ");
INSERT INTO qupNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Chaymanta paykunata rimarka: Yachachik riychi Yaya Diospa ali kamachinan kay allpapi ña kallarishkanmanta. Unkushkakunatapas ampinkichi. ");
INSERT INTO qupNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kachahushkanpi rimarka: Rihushpaykichi ama apankichichu nima tulata, nima bulsaykichita, nima mikunaykichita, nima kullkikichita. Shuk churarishkaykichillawa riychi. ");
INSERT INTO qupNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Shuk wasipi yaykushpaykichika chay wasillapi kipariychi shuk llaktama rinaykichikama. ");
INSERT INTO qupNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Shuk llaktapi paktashpaykichi chay runakuna Yaya Diospa shiminta mana uyanayashpankunaka kankunata mana kayankakunachu wasinkunapi. Chasna rurashpankunaka chay llaktamanta llukshiychi kasna nishpa: Yaya Dios kankunataka kastigankami, paypa shiminta mana uyanayashkaykichirayku. Chasna rimaychi yachanankunapa imamantami kastigay tukunkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jesús chasna rimashpan chay runankunaka llukshirkakuna. Tukuy llaktakunama rishpankuna Yaya Diospa suma ali shiminta Jesukristu runakunata kishpichinanmanta yachachishpa, unkushkakunatapas ampishpa purirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Apu Herodeska chay uras Galilea allpapi kamachik kashpan tukuy imashnami Jesús rurahushkanta uyashpan mana yacharkachu imatami yuyarinka. Shukkunaka Jesusmanta rimarkakuna: Chay Jesuska Bawtisak Juanchari, wañushkanmanta kuti kawsarimushka. ");
INSERT INTO qupNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Shukkunaka rimarkakuna: Chay runaka ñawpa Yaya Diospa yachayninwa yachachik Eliaschari, maykanmi kuti shamunan karka Kishpichikka manara shamuhushpan. Shukkunaka rimarkakuna: Shuk ñawpa Yaya Diospa yachayninwa yachachikkunamantachari kawsarimushka. ");
INSERT INTO qupNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodeska rimarka: Ñuka kikinmi kamachirkani Juanpa umanta pitinankunapa. ¿Paychu kawsarimushka? ¿Pishi kan chay runaka? Paymanta runakunaka kwintawanahun achka alikunata rurashkanta nishpa. Chayrayku yapa Jesusta rikunayarka. ");
INSERT INTO qupNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kutimushpankuna chay chunka ishkay Jesuspa apostolninkunaka payta kwintak shamurkakuna imatami rurashkakuna. Chaypi Jesuska paykunallata pushashpa rirka samanankunapa nima pi kawsahushkama Betsaida llakta kuchupi. ");
INSERT INTO qupNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Chayta yachashpankuna achka runakuna Jesusta katirkakuna. Katihushkakunata Jesuska kushilla kayashpan yachachirka Yaya Diospa ali kamachinan kay allpapi ña kallarishkanmanta. Chaymantapas tukuy chaypi unkuywa kahushkakunata ampirka. ");
INSERT INTO qupNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ña chishiyahushpan chay chunka ishkay runankunaka payta kayllayashpankuna rimarkakuna: Kachay kay achka runakunata, kay kuchullapi kahuk llaktakunama rishpankuna puñunankunata mikunankunata maskak rinankunapa. Kaypika manami nima shuk runa kawsanchu. ");
INSERT INTO qupNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Chaypi Jesuska aynirka: Kankuna karaychi kay runakunata. Paykunaka aynirkakuna: Pichka panstu, ishkay challwastulla tiyan ñukanchipaka. Mana kaystullaka paktankachu kay tukuy runakunaraykuka. ¿Rantik rinchimachu ashwanta? ");
INSERT INTO qupNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Chaypi karkakuna pichka waranka parti runakuna. Chaymanta Jesuska runankunata nirka: Paykunata rimaychi tiyarinankunapa, karan shuk muntun pichka chunka pichka chunka. ");
INSERT INTO qupNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jesuspa rimashkanta kasushpankuna runankunaka tukuy chay runakunata chasna tiyachirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Chaypina Jesuska chay pichka panta ishkay challwatapas apishpan siluma rikushpan Yayan Diosta agradesirka. Agradesishkanwasha chay mikunata paki paki rurashpan runankunata kurka chay runakunata karanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tukuy saksakta mikurkakuna. Chaywasha puchurishkankunata tantashpankuna chunka ishkay tasata untachirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Shuk puncha Jesuska chunlla kahushkapi Yayan Diosta mañarka. Runankunalla paywa pakta kahurkakuna. Chaypina paykunata tapurka: Runakuna kwintahushpankuna ¿pimi kani ninahuntaya? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Chaypi paykunaka aynirkakuna: Shukkunaka ninahunmi Bawtisak Juanchari wañushkanmanta kawsarishka kanaykita. Shukkunaka ninahunmi, Yaya Diospa yachayninwa ñawpa yachachik Eliaschari kanaykita, maykanmi kuti shamunan karka. Ashwan shukkunaka ninahun, shuk ñawpa Yaya Diospa yachayninwa yachachikchari wañushkanmanta kawsarishka kanaykita. ");
INSERT INTO qupNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Chaypi Jesuska paykunatana tapurka: Kankunaka ¿pi kanaynitata yuyarinkichi? Chayllapi Pedroka aynirka: Kanmi kanki Yaya Diospa Kachashkan Kishpichik. ");
INSERT INTO qupNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pedro chasna nishpan Jesuska paykunata rimarka: Nima pita chayta rimankichirachu. ");
INSERT INTO qupNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Chaymantapas rimarka: Ñuka Yaya Diospa Kachashkan Runaka achkata parisinayni tiyan. Ñukanchita kamachik israel masinchi rukukuna, saserdotekunapa apunkuna, Moisespa killkashkanta yachachikkunapas chikniwashpankuna wañuchiwankakuna. Wañushpaynipas kimsa punchamantami Yaya Dioska kawsachiwanka. ");
INSERT INTO qupNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Chaymanta tukuy payta katihuk runakunatana rimarka: Kankuna katiwanayashpaykichika ama kankuna kikin munashkaykichita ruraychinachu. Chiknik runakuna kankunata piñarishpa wañuchinayahushpankunapas karan puncha ñukallata mana sakishpa katiwaychi. ");
INSERT INTO qupNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Maykanmi wañuyta manchashpan sakiwan, manana atipanchu ñukawa wiñaypa kawsanata. Maykanmi mana sakishpa katiwahushpan chikninata wañuytapas parisin, chayka wiñaypami Yaya Dioswa kawsanka. ");
INSERT INTO qupNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Imata valin shuk runa tukuy kay mundupi tiyashkata apinanpa? Tukuy chaykunaka mana yanapanchu wiñaypa ñukawa kawsananpa. ");
INSERT INTO qupNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Chasnallatata maykanmi runakunapa puntanpi pinkan ñukata katiwahushkanta rimanata, shiminitapas yachachinata, chay runataka ñukapas, kay allpama kutimuhushpayni rimasha mana ñukapa kananta. Chay punchaka ñuka Yaya Diospa Kachashkan Runaka shamusha punchahlla rikurishpa, paypa atun yachayninwa paypa angelkunawa pakta. ");
INSERT INTO qupNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Alita uyawaychi. Shuk kankunamanta kaypi kahukkunaka manara wañuhushpaykichira Yaya Dios kay allpapi kamachihushkanta rikunkichimi. ");
INSERT INTO qupNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Pusak puncha chasna rimashkanwasha Jesuska Pedrota, Juanta, Santiagotapas pushashpan shuk urku awama sikarka Yayan Diosta mañananpa. ");
INSERT INTO qupNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mañahushkanllapi uyanka chikanyamurka, intishina punchayachirka. Churarishkanpas yura chuyahlla sintihukshina rikurirka. ");
INSERT INTO qupNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Chaypina ishkay runakuna rikurik shamurkakuna Jesuswa kwintanankunapa. Chaykunaka karkakunami ñawpa yachachikkuna Moisés Eliaspas. ");
INSERT INTO qupNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Yaya Diospa kachashkan suma chuyahlla kahushka chawpipi rikurishpankuna kwintahurkakuna imashnami Jesuska Yaya Diospa munashkanta paktachishpa Jerusalenpi wañunka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro paywa kahukkunapas yapa puñunayaywa kashpankunapas likcharishka kiparirkakuna. Chaypi Jesús suma chuyahlla kahushkata rikurkakuna, chay ishkay runakunatapas paywa pakta shayahukkunata rikurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Chay ishkay runakuna Jesusmanta anchurihushpankuna Pedroka yapa suma kahushkankunata rikushpan mancharishpa rimarka: Yachachik, alitami kaypi kahunchi. Ruranchima kimsa tampustuta, shukta kanrayku, shukta Moisesrayku, shukta Eliasrayku nishpa. Payka mana alita yuyarishpan chasna rimarka. ");
INSERT INTO qupNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Chasna rimahushkanllapi puyuka llantuyachishpan llantupina kiparirkakuna. Chay puyu ukupi yaykuhushpankuna mancharirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Chay puyu ukumanta uyarkakuna Yaya Diospa rimahushkanta: Kaymi kan Wawaynika. Paytami akllashkani kankunama kachanaynipa. Payllata kasuychi. ");
INSERT INTO qupNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Chasna rimashkanwashalla Jesusta sapallan kahukta rikurkakuna. Chaymanta paykunaka nima pita rimarkakunarachu maykantami rikushkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Chay kayantima urkumanta uraykumuhushpankuna achka runakuna Jesusta tinkuk rirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Chaypi kahukkunapa chawpinkunamanta shuk runaka sinchita rimashpan tapurka: Yachachik, kanta tapunayani llakichinaykipa wawaynita. Payka shuklla wawaynimi. ");
INSERT INTO qupNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Paypi shuk supay yaykushpan kunkaymanta kaparichin. Payta chukchuchin, putsku shiminmanta llukshinankama. Yapa nanaykunata parisichin, wawaynita mana sakinayanchu. ");
INSERT INTO qupNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Runaykikunataka ñami tapushkani supayta llukshichipanankunapa wawaynimanta. Chasna tapushpaynipas mana atipashkakunachu llukshichinata. ");
INSERT INTO qupNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Chaypi Jesuska aynirka: Mana ali yuyayyu runakuna, kankunaka manami sinchikunkichichu ñukapi. ¿Ima uraskamanataya kankunata yachachishpalla kiparisha? Chaymanta wawapa yayanta rimarka: Wawaykita apamuy ñukama nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Chay wawaka kayllayahushpan supayka allpama urmachishpan yapa kuchpachirka. Chaypi Jesuska supayta sinchi shimiwa kamachirka llukshinanpa chay wawamanta. Chasna chay wawata ampirka. Ña ampishpan yayanta kurka. ");
INSERT INTO qupNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tukuy chaypi kahukkunaka yapa kushikurkakuna, Yaya Diospa suma atun yachaywa rurashkanta rikushpankuna. Chasna kushikushpankuna Jesús yachayninwa rurashkanta rikushpankuna payka runankunata rimarka: ");
INSERT INTO qupNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Kay rimanaynita alita shunkuykichipi wakaychaychi. Ñuka Yaya Diospa Kachashkan Runa kashpaynipas chikniwak runakunaka apichiwashpankuna parisichishpa wañuchiwankakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Alita rimashpa yachachishpantata runankunaka mana asirtarkakunachu chasna pasananta. ¿Imatashi chasna nishka? nishpa yuyarirkakuna. Yaya Dios yuyayninkunata tapachirka, chay Jesuspa yachachishkanta manara asirtanankunapa. Chaymanta pinkarkakuna Jesusta tapunata rimashkanmanta. ");
INSERT INTO qupNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Chaymanta Jesuspa runankunaka paykunapura rimanakurkakuna, pishi ashwan yachayyu kan paykunamanta nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesuska yuyarihushkankunata yachashpan shuk wawata makinmanta apishpan paypa kuchunpi shayachirka. ");
INSERT INTO qupNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Chaypi runankunata rimarka: Maykanmi yuyawashpan shuk wawata yuyashpan wasinpi yaykuchin, chayka ñukatami yaykuchiwan. Maykanmi ñukata yaykuchiwan, paymi kachawak Yayayni Diostapas yaykuchin. Chayrayku maykanmi tukuy kankunamanta ashwan mana valikshina kan, paymi yapa valik kan. ");
INSERT INTO qupNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Chaymanta Juanka rimarka: Yachachik, shuk runata rikushkanchi shuk runamanta supayta llukshichihukta, Jesús atipachiwashpan kanta kamachini llukshiy nishpa. Payka mana ñukanchiwa purikchu kan. Chayrayku rimarkanchi ama chasna rurankichu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Chaypina Jesuska payta rimarka: Ama chasna rimaychichu chay runata. Maykanmi kankunata mana chikninchu, chayka kankunata sumakta yanapahun. ");
INSERT INTO qupNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Chaypina Jesús siluma kutinan punchakuna ña paktarihushpan payka nima imata manchashpan Jerusalenma rirka. ");
INSERT INTO qupNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Samaria allpapi paktashpankuna Jesuska ishkay runankunata kacharka shuk llaktama wasita maskanankunapa, chaypi puñunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Chay llaktapi kawsak runakunaka Jesusta mana yaykuchinayarkakunachu, Jerusalenma rihushkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jesuspa runankunaka Santiago Juanpas chayta rikushpankuna nirkakuna: Yachachik ¿munankichu rimananchipa silumanta nina urmananpa kay llaktapi kawsak runakunata rupachinanpa? ");
INSERT INTO qupNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Chasna nishpankuna Jesuska tikrarishpan chay ishkantita piñashpa rimarka: Kankunaka mana yachankichichu imashnami shunkuykichika kanahun. Ñuka mana shamushkanichu runakunata wañuchinaynipa, ashwan kishpichinaynipami shamushkani. ");
INSERT INTO qupNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Chaymanta shuk llaktamana rirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ñampita rihushkankunapi shuk runa kayllayashpan Jesusta rimarka: Maytapas rishpayki kanta katinayani nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Chaypi Jesuska aynirka: ¿Imatata yuyarishpayki katinayawanki? Kankunata rimani, mahaskunapa tiyan uchkunkunaka, maypimi kawsanahun. Pishkukunapapas tiyan wasinstukunaka, maypimi samanahun. Ñuka Yaya Diospa Kachashkan Runapaka mana nima ima tiyawanchu maypimi samasha. ");
INSERT INTO qupNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Chaymanta shuk runata Jesuska rimarka: Ñukata katiway. Payka aynirka: Yachachik, chapawankira yayayni wañushkata urku uchkupi churanaynikama. Chaywasha shuti kanwa risha. ");
INSERT INTO qupNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Chayta rimashpan Jesuska aynirka: Yaya Diospa shiminta mana kasunayakkunaka wañushkakunashina kashpankuna paykuna chay wañushkakunataka urku uchkupi churashpa tapanahuchun. Kanka runakunata yachachikriy Yaya Diospa ali kamachinan kay allpapi ña kallarishkanmanta nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Chaymanta shuk runaka Jesusta rimarka: Yachachik, ñukapas kanta katinayani. Chapawankira aylluynikunata rimak rishara kanwa rinaynita. ");
INSERT INTO qupNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Chasna nishpan Jesuska aynirka: Shuk runa kanuwanpi kawishpa rihushpanka manami washanma rikushpa rinmachu. Chasna rihumaka, shuk ratu kaspipi takarishpan tikrama. Chasnallatatami shuk runa ñukata katiwahukka tukuy shunkunmanta pacha munashpa katiwanan tiyan. Ñawpa rurashkaykitashina ruranayashpaykika chasnaka manami valinkichu Yaya Diospa ali kamachihushkanpi kawsanaykipa. ");
INSERT INTO qupNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Chaymanta yachachishkanwasha Jesuska yuyarirka achka llaktakunama rinata. Manarapas rihushpan kanchis chunka runakunata akllashpan kacharka paymanta puntiru rinankunapa. Ishkay ishkayta kacharka runakunata yachachinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kachahushpan rimarka: Rikuychi, shuk atun chakrapi tarpu muyukuna pukushka kashpanka achka runakunata munanchi utkalla pallanankunapa, mana ismunanpa. Chasnallatata achka kay allpapi kawsak runakuna Yaya Diospa shiminta uyashpankuna kirinkakuna. Chasna kashpanpas mana achka yachachikkuna tiyanchu. Chayrayku Yaya Diosta mañaychi kachananpa ashwan paypa shiminta yachachikkunata. ");
INSERT INTO qupNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kunan riychi. Kankunata kachahuni obeha wawakunatashina pumakuna chawpipi. Achka llaktakunapi purishpaykichi runakunaka kankunata chikninkakuna. Chayrayku ñukapi sinchikuychi. ");
INSERT INTO qupNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Rihushkaykichipi ama apaychichu bulsata, kullkita, nima chakikichirayku ashwan shuk churarinata. Ñampipi shuk runata tinkushpaykichika ama shayarinkichichu kwintanaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Shuk wasipi yaykushpaykichi chay wasipi kahushkakunata puntiru rimankichi Yaya Dios kankunata yanapachun wiñaypata kushilla kawsanaykichipa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Chasna kushilla kawsanata munashpankunaka Yaya Dios chay rimashkaykichita paykunarayku paktachinkami. Mana munashpankunaka Yaya Dios paykunarayku mana paktachinkachu. ");
INSERT INTO qupNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Maykan wasipimi kankunata kayanahun, chay wasillapi kipariychi. Ama puñuk riychichu shuk wasipi shuk wasipi. Imatachari karanahun upyachinahun, chayta mikuychi upyaychi. Shuk tarawak runaka munanmi pagay tukunata. Paykunaka chay mikunawami kankunata paganahun, Yaya Diospa shiminta yachachishkaykichirayku. ");
INSERT INTO qupNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Shuk llaktapi paktashpaykichi shuk runakunapas kankunata kayankakuna. Imatapas kankunata karahushpankunaka mikuychilla. ");
INSERT INTO qupNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Chaypi unkushka kahukkunata ampiychi. Yachachihushpaykichi rimaychi ñami kallarihun Yaya Diospa ali kamachinanka kay allpapi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Shuk llaktapi paktashpaykichi chaypi kawsak runakuna kankunata mana yaykuchinayashpankunaka kanchama llukshishpaykichi rimankichi: ");
INSERT INTO qupNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Yaya Dios kankunata kastigankami, paypa shiminta mana uyanayashkaykichirayku. Ñukanchita mana yaykuchinayashpaykichipas kay rimananchita alita uyaychi ñami kallarihun Yaya Diospa ali kamachinanka kay allpapi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kankunata rimani, Yaya Dios shuk puncha sinchita kastiganan tiyan chay llaktapi kawsak runakunata. Ñawpa Sodoma llaktapi millaypata rurak runakunamanta pasatami Yaya Dioska paykunata kastiganka. ");
INSERT INTO qupNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jesuska rimashpalla katirka: Ay kankuna Korasín llaktapi kawsak runakuna. Ay kankuna Betsaida llaktapi kawsak runakuna. ¡Imashna kastigushi kankunarayku kanka! Kankunawa kashpayni atun yachaywa achka ruranakunata rurashpaynipas kankunaka Yaya Diosta mana kasunayashkankichichu. Chay Yaya Diospa mana akllashkan Tiro llaktapi, Sidón llaktapi kawsakkuna rikunahuma karka atun yachaywa rurashkaynikunata, Yaya Diosta kasunahuma karka. Chay urasllapi paykunaka yapa pinkaywa llakirishpankuna wakanahuma karka, millaypa rurahushkankunata sakishpankuna alitana ruranankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Yaya Dioska kastiganan punchapi Tiro, Sidón llaktakunapi kawsak runakunamanta kankuna Korasín, Betsaida llaktakunapi kawsak runakunata ashwan sinchita kastiganka. ");
INSERT INTO qupNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kankuna Kapernaum llaktapi kawsak runakuna ¿imaraykuta yuyarinkichi Yaya Dios ñukanchita siluma pushanka nishpa? Mana chasnachu. Nina mana wañukmami rinaykichi tiyan, ñukata mana kiriwashkaykichirayku. ");
INSERT INTO qupNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Chaymanta Jesuska kachanan runankunata kutikashka rimarka: Maykanpas kankunata uyashpankunaka ñukatapas uyawanahun. Maykanpas rimahushkaykichita mana uyanayanchu, ñukatapas mana uyanayawanchu. Chasnallatata ñukata mana kasunayak runaka kachamuwashka Yaya Diostapas mana kasunchu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Chaymanta chay kanchis chunka ishkay Jesuspa kachashkan runankuna achka llaktakunapi yachachishpa purirkakuna. Chaypina yapa kushilla kutishpankuna Jesusta kwintarkakuna: Yaya Jesús, kan ñukanchita atipachishpayki rimashpanchi supaykunapas ñukanchita kasushpankuna runakunamanta llukshishkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Chasna chay runankuna kwintashpankuna Jesuska rimarka: Ari, ñuka kankunata atipachishpaynimi supaykunata winsishkankichi. Chasnashpaykichi rikushkani supaykunapa atun apunkunata rayushina silumanta urmahushkata. ");
INSERT INTO qupNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Chay supaykuna machakuya uputinti sulimanwa waklichikshina kankunata shunkuykichipi waklichinayanahun. Ñuka kankunata atipachishkani tukuy supaykunata winsinaykichipa, kankunata mana imanachinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Yapa achkata kushikunkichi supaykunata runakunamanta llukshichishkaykichirayku. Kankunata rimani, ashwanta kushikuychi shutikichika silupi killkarishka kashkankunarayku wiñaypa Yaya Dioswa kawsanaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Chasna chay runankunata rimashpan Yaya Diospa Espíritun Jesusta sumakta kushichirka. Chaypina Yayan Diosta rimarka: Yayayni, yapa alimi kanki. Atun yachaykiwa silupi allpapipas kamachikmi kanki. Kushikunimi mana yachakchu kani nishpa yuyarik runakunallata yachaykita asirtachishkaykirayku. Chay yachak kanankunata yuyarik runakunata mana asirtachishkankichu yachaykita. Ari Yayayni, kan kikin munashkaykirayku chasna rurashkanki. ");
INSERT INTO qupNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yayanta chasna mañashkanwasha runankunata rimarka: Yayaynimi rimawarka ñukalla tukuyta kamachinaynipa. Payllami ñukata alita riksiwan. Kankunaka manami alitachu riksiwankichi. Chaymantapas Yaya Diospa Wawan kashpayni ñukallami payta alita riksini imashnami kan. Maykankunallatami ñuka riksichini, paykunallami Yayayni Diosta riksinkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Chaymanta runankunallawana kahushpan rimarka: Kushilla kankakuna kankunashina rurahushkaynita rikukkuna, yachachihushkaynita uyakkunapas. ");
INSERT INTO qupNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kankunata rimani, ñawpa Yaya Diospa yachayninwa yachachikkuna, achka apu wañukunapas ruranaynita yapa rikunayarkakuna, yachachinaynita yapa uyanayarkakuna. Tukuy paykunaka mana rikuwashpankunara mana uyawashpankunara wañurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Chaymanta shuk puncha Moisespa killkashkanta shuk yachachikka Jesusta kayllayashpan tapurka: Yachachik ¿imata rurashpaynita atipaynima Yaya Dioswa silupi wiñaypa kawsanata? ");
INSERT INTO qupNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesuska aynirka: Chay ñawpa Yaya Diospa killkachishkanpi ¿imatata ruranaykipa riman? ");
INSERT INTO qupNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Chay runaka aynirka: Tukuy shunkuykimanta pacha Yayayki Diosta sumakta yuyashpa, sumakta munashpa kawsanayki tiyan. Payta yuyahushpaykika alikunata yuyarishpa rurashpa kawsanayki tiyan. Chaymantapas runa masikikunata yuyay kan kikitashina nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Chaypina Jesuska aynirka: Alitami ayniwashkanki. Tukuy rimawashkaykita rurashpaykika Yaya Dioswa silupi wiñaypa kawsak rinkimi. ");
INSERT INTO qupNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Chay yachachikka runa masinta mana yuyahushpanpas yuyanata munakshina tukushpan Jesustana tapurka: ¿Maykan runataya kan runa masinika payta yuyanaynipa? ");
INSERT INTO qupNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Chaypina Jesuska yuyayninmanta shuk kwintuwa yuyachishpa aynirka: Shuk runa Jerusalén llaktamanta Jerikó llaktama rirka. Ñampipi rihushpan shuwakuna payta tinkurkakuna. Chaypi tukuy paypa tiyapushkanta kichurkakuna churarishkankunatapas. Kaspiwa waktashpankuna lismayachishpa wañushkatashina sakimurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Chay uraslla shuk saserdote shamuhurka chay ñampillatata. Rikuhushpan chay makashka runa wañuhukta, mana yanapanayashpan karullata pasarka. ");
INSERT INTO qupNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Chaymanta Yaya Diospa wasinpi saserdoteta shuk yanapak pasarka chay ñampillatata. Pay ñawpa kawsak Levipa miraymanta karka. Wañushkatashina rikushpan karullata pasarka. ");
INSERT INTO qupNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Chaymanta Samariamanta runa shamurka chay ñampillatata. Chay lismayashkata rikuhushpan yapa llakichirka. ");
INSERT INTO qupNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kayllayashpan chay runata, uchillastu vinuta uchillastu aseitewa chapushpan pitirishkankunata kakurka ampirinanpa. Chaymanta llachapawa wankupurka. Atarichishpan sikachirka pay kikinpa burrun awapi. Shuk puñuna wasima pushashpan sirichik rirka kuyrananpa. ");
INSERT INTO qupNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kayantima chay Samariamanta runa shuk llaktama rihushpan wasi amuta kullkita pagashpan rimarka: Kuyrapanki kay unkushka runata. Kay kullki kushkaynimanta ashwanta gastashpaykika kutimushpayni kutichishkayki nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Chaypina Jesuska chay yachachikta tapurka: Kunanka yuyariy. Chay kimsa runakunamanta ¿maykanta chay shuwakuna lismayachishkata yuyak runa karka? ");
INSERT INTO qupNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Chaypina chay runaka aynirka: Chay llakichishpan yanapak runami makarishka runata sumakta yuyarka. Chasna aynishpan Jesuska rimarka: Kanpas chay yanapak runashina tukuy runa masikikunata yanapashpa kawsay. ");
INSERT INTO qupNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús runankunawa ñampita rihushpan shuk uchillastu llaktapi paktarka. Chaypi shuk warmi Marta shutiyu Jesusta kushikushpa wasinpi yaykuchirka. ");
INSERT INTO qupNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martapa tiyarka shuk ñañan Maria shutiyu. Mariaka Jesuspa chakin kuchupi tiyahurka yachachihushkanta uyananpa. ");
INSERT INTO qupNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Chaykama Martaka mikunata yanuhurka Jesusta karananpa. Achkata tarawashpa musparihurka. Chaypina Martaka Jesusta rimarka: Yachachik ¿manachu llakichiwanki? Ñañaynika sakishka tukuyta sapallayni ruranaynipa. Rimay payta yanapak shamuwananpa. ");
INSERT INTO qupNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Chasna nishpan Jesuska aynirka: Marta, Marta, musparishpa kahunki chay tukuy imakunata ruranaykipa. ");
INSERT INTO qupNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tarawanaykimanta ashwan ali kama, yachachihushkaynita yachakunaykipa. Mariaka alita yachakuhun. Mana munanichu yachakuhushkanta sakinanpa. Kay yachakuhushkantaka nima pi kichunkachu. ");
INSERT INTO qupNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Shuk puncha Jesuska Yayan Diosta mañahurka. Mañanata tukuchishpan shuk runan kayllayashpa rimarka: Yaya Jesús, ñukanchitapas yachachiy Yaya Diosta mañanata imashnami Bawtisak Juanka runankunata yachachirka. ");
INSERT INTO qupNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Chasna tapushpan Jesuska rimarka: Mañahushpaykichi kasna ninkichi: Yaya Dios, kanllami kanki yayanchika. Yanapay tukuy runakuna kanta yapa ali kanaykita yuyanankunapa. Kay allpata ali kamachinaykita ruray. ");
INSERT INTO qupNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Karan puncha ñukanchita kuy mikunanchita. ");
INSERT INTO qupNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Yaya Dios, ñukanchita llakichiy mana alita rurashkanchikunamanta. Chasnallatata ñukanchipas runa masinchikunata llakichinchi tukuy ñukanchita mana alita rurashkankunamanta. Ama sakiychu supay ñukanchita pantachichisha nishpa sinchita kamashpan mana alikunata rurananchipa, ashwan kishpichiy ñukanchita tukuy millaypakunamanta. ");
INSERT INTO qupNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesuska ashwanta asirtachinayashpan shuk yachachinata rimarka: Akuychi yuyarishunchi. Shuk munashkayki amigu tiyashpanka chawpi tutapi wasinma tapuk rinkima: Wawkinistu, shuk uchillastu mikunaykita kuway. ");
INSERT INTO qupNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kunalla shuk wawki karumanta wasinipi paktamushka. Mana tiyawanchu mikunaynika karanaynipa. ");
INSERT INTO qupNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Payka wasin ukumanta rimama: Ama killachiwaychu. Punkuka sumaktami taparishka. Wawaynikunaka puñuhunkunami ñukawa. Mana atipanichu nima imata kanta kunata. ");
INSERT INTO qupNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Kankunata rimani: Yuyashkan amigun kashpantata mana kushpanka ¿manachu atarishpan kuma maykantami munahun mana ashwanta killachiy tukunanpa? ");
INSERT INTO qupNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Chayta yuyachishpa rimani, munashkaykichita tapuychi Yaya Diosta, payka kankunata kunkami. Yaya Diosta maskashpaykichika payta tarinkichimi. Paypa kamachinanpi yaykunayashpa punkupi kayahukshina kashpaykichi Yaya Dioska kankunata yaykuchinkami. ");
INSERT INTO qupNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Maykanmi tapun, paytaka kunkami. Maykanmi maskan, tarinkami. Maykanmi punkupi kayan, payraykuka paskankami. ");
INSERT INTO qupNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Shuk wawa yayanta challwata tapushpanka yayanka mana kumachu shuk machakuyata mikunanpa. ");
INSERT INTO qupNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Chasnallatata shuk lulunta tapushpanka lulunranti mana kumachu uputintita mikunanpa. ");
INSERT INTO qupNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kankuna mana alita rurashpa kawsakkuna kashpaykichipas wawaykichita alikunallata kunkichi. Ashwan silupi kawsak Yayanchi Dios suma ali shunkuyuta tapushpaykichika kankunata paypa Espirituntami kunka. ");
INSERT INTO qupNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Shuk puncha Jesuska shuk runamanta supayta llukshichihurka. Chay runaka supay paypi kashkanrayku mana atiparkachu rimanata. Supayka chay runamanta llukshishpan chay runaka mushumanta rimarkana. Chayta rikushpankuna runakunaka mancharirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Shukkunaka rimarkakuna: Kayka supaykunapa apun Beelsebupa yachayninwami supaykunata llukshichin. ");
INSERT INTO qupNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Shukkunaka yapa runakunata riksichinayashpankuna Yaya Diospa mana kachashkan kananta Jesusta tapurkakuna: Ñukanchirayku ruray Yaya Diospa yachayninwa shuk nima ima uras rikushkanchita nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesuska yuyarihushkankunata yachashpan rimarka: Maykan llaktakunapi apukunapura chikninakushpa wañunakuhushpankunaka chaypi kawsak runakunaka llampumi tukurinkakuna. Chasnallatatami shuk wasipi kawsakpura chikninakushpa makanakuhushpankunaka chasnaka shikwarinahumi. Supayka mana wichumachu supay masinkunata shikwarinankunapa paykunapura. ");
INSERT INTO qupNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Chasnallatata supaykunapa apun paypa kamachishkankunawa piñanakushpankuna paykuna kikin rurahushkankunata waklichinahuma. Chasnashpankuna ¿imashnataya payka alita kamachima? Kankuna niwankichi Beelsebupa yachayninwami supaykunata llukshichin nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Chasna kashpanka ¿pita kankunata katikkunataka yanapan supaykunata runakunamanta llukshichinankunapa? ¿Paykunapas Beelsebupa yachayninwachu supaykunata runakunamanta llukshichinahun? Kankunaka alitami yachankichi Yaya Dios paykunata yanapananta. Chayraykumi paykuna kikin rikuchinahun kankuna yankamanta rimawahushkaykichita. ");
INSERT INTO qupNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Yayayni Diospa yachayninwami supaykunata llukshichini. Chay rurashkaynita rikushpaykichi yachankichi Yaya Diospa ali kamachinan chawpikichipi ña kallarishkanta. ");
INSERT INTO qupNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Rikuychi. Shuk sinchi runa sumakta alicharishka kashpanka lansanwa wasinta sumakta kuyran, tukuy imankunata sumakta wakaychan mana shuwanankunapa nima imata. ");
INSERT INTO qupNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Shuk paymanta ashwan sinchi runa shamushpanmi payta winsishpan lansanta kichunka, maypimi pay sinchikurishka kahurka. Tukuy ima tiyahushkata apashpan paywa pakta kahukkunawa chawpinakun. Chasnallatata ñukami kani chay winsik runashina, chayrayku supaykunata llukshichihuni. ");
INSERT INTO qupNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Kankuna mana kiriwashpaykichika chikniwahunkichimi. Runakunata ñukamanta alita yachachishpa mana yanapawashpaykichika pantachichishpa ñukamanta anchuchinkichi. ");
INSERT INTO qupNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jesuska shuk yachachinata yachachihushpan kasna nirka: Shuk supay shuk runamanta llukshishpanka yaku illa allpakunapi purin maskashpa maypimi kawsanka nishpa. Mana maypi samananta tarishpanka yuyarin kutishara chay llukshishkayni runamallatata nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kutishpanna chay runata tarikrin shuk wasi suma chusha picharishkatashina. ");
INSERT INTO qupNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Chayta rikushpan kanchis paymanta ashwan millaypata rurak supay masinkunata kayakrin chaypillatata kawsak shamunankunapa. Pushamushpan chay runapina yaykunahun kawsanankunapa. Chaymantana chay runaka ñawpamanta ashwan millaypakunatana rurashpa kawsan. Kankunaka yapa millaypata rurak kashpaykichimi chay achka supay yaykushka runashina kankichi. ");
INSERT INTO qupNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesús chay shimikunata rimahushpan shuk warmi chawpinkunamanta kaparishpa rimarka: ¡Kushilla kachun, maykan warmimi kanta wawayashpa chuchuchishpa wiñachirka! ");
INSERT INTO qupNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Payka aynirka: Ashwan kushilla kankakuna, maykankunami Yaya Diospa shiminta uyanahun kasunahun. ");
INSERT INTO qupNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Achka runakuna paypa kuchunpi tantarishpankuna Jesuska rimarka: Kankuna kay punchakunapi kawsak runakuna mana ali yuyayyukunachu kankichi. Yaya Diospa yachayninwa ruranaynita rikunayankichi. Chasna tapuwashpaykichipas manami rurashanchu. Kayllatami rikunkichi, imashnami Yaya Dios chay ñawpa paypa yachayninwa yachachik Jonás wañuta kacharka yachachinanpa, chasnallatatami ñukatapas kachawashka. ");
INSERT INTO qupNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Imashnami Jonaska Nínive llaktapi kawsakkunata mana alita rurashkankunata rikuchirka, chasnallatatami ñuka Yaya Diospa Kachashkan Runa kay punchakunapi kawsak runakunata millaypa rurashkankunata rikuchini. ");
INSERT INTO qupNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ñawpa shuk atun apu warmi yapa karu llaktamanta shamurka, atun apu Salomón yapa yachaywa rimahushkanta uyananpa. Ñukaka Salomonmanta ashwan atun yachayyu kashpaynipas manami kiriwanayankichichu. Chayrayku Yaya Diospa kastiganan puncha chay karu llaktamanta atun apu warmika atarishpan kankuna kay punchakunapi kawsak runakunamanta uchata rurashkankichi nishpa Yaya Diospa puntanpi rimanka. ");
INSERT INTO qupNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Chasnallatata Yaya Diospa kastiganan punchapi Ninivepi kawsak runakunaka kay punchakunapi kawsak runakunata atarishpa uchata rurashkankichi nishpa rimankakuna. Chay runakunaka Jonaspa rimashkanta uyashpankuna kallarirkakuna alita ruranatana. Ñukaka Jonasmanta ashwan atun yachayyu kashpaynipas manami kirinayawankichichu. ");
INSERT INTO qupNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Chaymantapas Jesuska nirka: Nima pi lamparinta apichishpan pakashpa churamachu kawitu ukupi. Ashwan churanchima awapi lamparín tiyachinapi chay wasipi yaykuhukkunata punchayachinanpa. ");
INSERT INTO qupNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ñawiki kanrayku punchata rikuchikmi. Ñawiki ali kashpanka alita rikuk punchapi purihushkashina kawsanki. Ñawiki mana ali kashpanka amsapi purihushkashina kawsanki. ");
INSERT INTO qupNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Chayrayku alita kuyrariy tukuy kanpi punchata rikuchikshina tukuyta alita riksichik asirtachik kashkaka mana waklishpa amsashina tukushka kananpa. ");
INSERT INTO qupNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tukuy yuyaykika shunkuykika punchashina ali kashpanka tukuy kawsaykika ali kanka, imashnami shuk lamparin suma puncha rikuchihushkashina. ");
INSERT INTO qupNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Chasna rimashkanwasha shuk fariseo Jesusta kayarka wasinpi mikuk rinanpa. ");
INSERT INTO qupNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Manara mikuhushpankuna israel runakuna makinkunata mayllaripayanahun. Jesuska makinta mana mayllarishpa mikuhushpan chay fariseoka rikurayarka. ");
INSERT INTO qupNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jesuska chay fariseopa mana alita yuyarihushkanta yachashpan nirka: Rikuychi, kankuna fariseokunaka tukuy rurashkaykichiwa alita rikurishpaykichipas shunkuykichipika millaypa yuyayyu kankichi, shukkunapa ima tiyapushkanta llullachishpa shuwakuna. Pusilluta kallanata washanllata mayllak runakunashina kankichi, ukunta susyata sakinkichi. ");
INSERT INTO qupNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mana ali yuyayyu runakunami kankichi. ¿Manachu yachankichi Yaya Dioska mana aychanchillata rurashkanta? Payka rurashka tukuy yuyayninchitapas. ");
INSERT INTO qupNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Chayrayku shunkuykichita yuyaykichita alichashpaykichi charishkaykichimanta nima imayukunata ali yuyaywa kuychi. Chasna rurashpaykichirami shuti ali kankichi Yaya Diospa rikushkanpika. ");
INSERT INTO qupNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ay fariseokuna, ¡imashna kastigushi kankunarayku kanka! Kulantru, ali kiwa, tukuy mikuna yuyukunamantapas chunkamanta shukta Yaya Diosta kunkichi. Chasna Yaya Diospa kamachishkanta shuk parti paktachishpaykichipas chay ashwan ali kasna nishkan kamachishkankunata mana paktachinkichichu: Alillata rurashpa rimashpa kawsaychi. Runa masikichita yuyashpa yanapaychi. Yaya Diostapas yuyashpa kawsaychi nishpa. Chay kamachishkankunataka paktachinaykichi tiyan chay shukkunawa pakta. ");
INSERT INTO qupNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ay fariseokuna, ¡imashna kastigushi kankunarayku kanka! Tantarinanchi wasikunapi munankichi tukuymanta suma tiyarinakunapi tiyarinata, runakuna kankunata aputashina rikuhushkankunata rikuchishpa. Ñampikunapi plasakunapi purishpaykichi yapa munankichi tukuy runakuna kankunata aputashina saludanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ay fariseokuna, ¡imashna kastigushi kankunarayku kanka! Llullachiysikikunami kankichi. Wañushkakunata churashpa kanchamanta mana riksiypa sumakta tapashka uchkushinami kankichi. Mana rikuchinkichichu ukupi millaypa kahushkaykichita. Runakunaka awanta purishpa pasanahuma, mana yachanahumachu imami ukupi tiyahun. ");
INSERT INTO qupNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Chasna nishpan Moisespa killkashkanta shuk yachachikka rimarka: Yachachik, chasna rimashpayki ñukanchitapas piñahukshinami mana ali kashkanchita rimahunki. ");
INSERT INTO qupNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Chaypi Jesuska aynirka: Ay Moisespa killkashkanta yachachikkuna, ¡imashna kastigushi kankunaraykupas kanka! Shuk patrón runankunata llasha kargata apachihukshinami kankichi. Yaya Diospa shiminta yachachihushpaykichika yuyaykichimanta achka kamachinakunata yachachinkichi Yaya Diospatashina kasunankunapa. Chasna yachachishkaykichiwa nitishkashina rurahushpaykichipas nima shuk uchillastuta paykunata yanapankichichu. ");
INSERT INTO qupNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Ay, imashna kastigushi kankunarayku kanka! Ñawpa yaya rukuykichi wañukuna Yaya Diospa yachayninwa paypa shiminta yachachikkunata wañuchirkakuna. Kankunaka paykunapa aychanta churashkankunata sumayachinkichi. ");
INSERT INTO qupNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Chasna rurashkaykichiwa rikuchinkichi, ñawpa yaya rukuykichikunapa rurashkankuna ali kananta nihukshina kanaykichita. Paykuna Yaya Diospa yachayninwa yachachikkunata wañuchirkakuna. Kankunaka paykunapa aychanta churashkankunata sumayachinkichi. ");
INSERT INTO qupNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Chayraykumi Yaya Dioska atun yachayyu kashpan rimarka: Kachashami yachayniwa yachachikkunata, chaymantapas apostolnikunata. Shukkunataka chiknishpa wañuchinkakuna, shukkunataka parisichinkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Yaya Dioska munduta rurashkanmanta pacha kunankama runakunaka achka paypa yachayninwa yachachikkunata chiknishpankuna wañuchirkakuna. Abelta ali runa kashpantata wawkinka wañuchirka. Chaymanta pacha runakunaka Yaya Diospa yachayninwa achka yachachikkunata wañuchirkakuna. Chaywasha Sakariastana Yaya Diospa wasinpi wiwakunata rupachina tuchpashina kuchupi kahushpanpas wañuchirkakuna. Kunan kankunapas tukuy paykunapa mana alita rurashkankunata yachashpaykichipas chasnalla rurashpa katinkichi. Chayraykumi Yaya Dioska manana chapankachu tukuy chaykunamanta kastigananpa. Kankunataka atuntami kastiganka. ");
INSERT INTO qupNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ay Moisespa killkashkanta yachachikkuna ¡imashna kastigushi kankunarayku kanka! Mana alita yachachishpaykichi runakunata arkankichi shutipa ali kashkata yachanankunapa. Kankuna kikin mana munashkankichichu uyanata, imashnami Yaya Diosta riksinkichi. Chasna kashpaykichi Yaya Diosta riksinayak runakunatapas pantachinkichi payta mana riksinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesuska chasna rimashpan Moisespa killkashkanta yachachikkuna, fariseokunapas yapa piñarishpankuna kallarirkakuna achkata tapunata. ");
INSERT INTO qupNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Chasna tapurkakuna Jesús shuk shimita pantachishpa rimananpa, chaymanta payta uchachishpankuna apunkunana wañuchichinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Jesús yachachihushkanpi achka waranka runakuna tantarirkakuna. Kichkikta shayarishpankuna tankanakushpa paykunapura kahurkakuna. Chasna tantarishpankunapas Jesuska puntiru runankunallata rimarka: Kuyrariychi fariseokunapa yuyayninkunamanta. Paykunaka rimanahun Yaya Diosta alita kasunankunata. Chasna rimashpankunapas manami alitachu ruraspa kawsahunkuna. Chasna mana ali yuyayyu kashpankuna runakunata yachachinahun paykunashina llullachikkuna tukunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nima shuk rimashkanchika, rurashkanchika pakalla kiparinkachu. Tukuy yuyayta shunkunchipi pakahushkanchitaka Yaya Dios tukuy runakunata riksichinka. ");
INSERT INTO qupNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Chasna kashpan pakalla rimashkaykichita tukuy yachankakuna. Wasi ukupi punkuta tapashpa alimanta rimashkaykichita wasi awamanta kaparishkatashinami tukuy uyankakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Munashkayni wawkinikuna paninikuna, kankunata rimani, ama manchaychichu aychaykichillata wañuchinata atipak runakunata. Manami ashwanta kankunata atipanahunchu ruranata. ");
INSERT INTO qupNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ñukaka kankunata rimani pitami manchanaykichi tiyan. Kankunata wañuchishkankunawasha nina mana wañukma wichunata atipak Yaya Diosta, payta shuti manchaychi. ");
INSERT INTO qupNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Yuyariychi pishkukunapi. Mana yapa chaniyu kashpankuna pichka pishkustukunata ishkay kullkistullawa atipanchi rantinata. Chasna kashpankunapas Yaya Dioska mana kunkarinchu nima shukta paykunamanta. ");
INSERT INTO qupNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Yaya Dios kankunatapas alita kuyran. Pishkukunamanta ashwan pasatami kankunata yuyan. Kankunata yuyashpan alita riksin. Nima shuk uchilla chukcha umaykichipi tiyashkaka paymanta kishpinchu. Chayrayku ama manchaychichu nima pita nima imatapas. ");
INSERT INTO qupNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Kunan kankunata rimani, maykan runami mana pinkashpa ñukamanta riman runa masinkunapa puntankunapi ñukami Jesusta katik kani nishpa, paymantaka ñuka Yaya Diospa Kachashkan Runapas angelkunapa puntanpi Yaya Diosta rimasha kay runata riksinimi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Maykanmi runa masinkunapa puntanpi pinkashpa ñukamanta payta mana riksinichu nishpanka ñukapas angelkunapa puntanpi kay runata mana riksinichu nishpa Yaya Diosta rimasha. ");
INSERT INTO qupNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Maykan runami piñarishpan millaypata riman ñuka Yaya Diospa Kachashkan Runamanta, paytaka Yaya Dioska llakichinkami. Maykan runami Yaya Diospa Espiritunmanta piñarishpan millaypata riman, chaytaka Yaya Dioska manami llakichinkachu. ");
INSERT INTO qupNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Chiknik runakuna kankunata apishpa pushankakuna tantarina wasikunapa apunkunama, llaktaykichipa apukunamapas. Chasna apiy tukushpaykichipas mana yapa yuyarishpa kaychichu ¿imashnashi aynisha? ¿imatashi rimasha? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Chay urasmi Yaya Diospa Espiritunka kankunata yuyachinka imashnami rimankichi. ");
INSERT INTO qupNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Chaypi chay achka runakunapa chawpinkunamanta shuk runa Jesusta rimarka: Yachachik, kanmi kanki atun yachayyu. Chasna kashpan wawkinita rimapay chawpinakunanchipa yayayni wañupa charishkanta. ");
INSERT INTO qupNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesuska mana munashpan aynirka: Runa masini, mana shamushkanichu shuk apushina kankunata yanapanaynipa rimanakushpa kahushkaykichipi alichanaykichipa, nima yayayki wañupa charishkanta chawpinakunaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tukuy runakunatana rimarka: Alita yuyariychi. Ama imaykichita mirachinayashpa kawsaychichu. Runapaka achka iman tiyahushpanpas mana kushillachu kawsama kay mundupi. ");
INSERT INTO qupNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Chaymanta chaypi kahukkunata yachachinanpa Jesuska kwintarka: Tiyarka shuk runa achka imayu. Shuk wata chakrankunapi tarpunkunaka yapa achkata muyuyarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Chay runaka yuyarirka ¿imatashi ruraynima? Mana tiyawanchu ashwan wasinika pallashkaynita wakaychanaynipa. ");
INSERT INTO qupNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Payka yuyarishpan nirka: Ña yachani imashnami rurasha. Kay uchilla wakaychana wasinikunata urmachishara ashwan atun wakaychana wasikunata ruranaynipa. Chaypi tukuy pallashkaynikunata ashwan ima tiyawashkakunatapas wakaychasha. ");
INSERT INTO qupNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Chaymanta ñuka kikinta rimasha: Kunanka tiyanmi achka wakaychashkaynikunaka achka watarayku. Chayrayku samashanllana. Mikushpa upyashpa kushilla kawsasha. Manana tiyawanchu nima imamanta yuyarishpa kanaynipa. ");
INSERT INTO qupNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Chaypi Yaya Dioska payta rimarka: Kanka yuyay illa runami kanki. Kunan tutallami kawsaykita kichushkayki. Wakaychahushkaykika ¿piraykushi kanka? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Chasnami kan, maykanmi pay kikinraykulla tukuy imankunata wakaychan. Yaya Diospa rikushkanpika nima imayushinami kan. ");
INSERT INTO qupNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Chaymanta Jesuska runankunata rimarka: Kankunata rimani, ama yanka muspariychichu ¿imatashi mikushu kawsananchipa, imatashi churarishu? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kawsananchimi mikunamanta ashwan valik kan. Chasnallatata aychanchimi churarinanchimanta ashwan valik kan. ");
INSERT INTO qupNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Yuyariychi pishkukunapi. Paykunaka nima shuk muyuta tarpunahunchu mikunankunapa. Paykunapaka nima tampunkunaka tiyanchu pallashkankunata wakaychanankunapa. Mana nima shuk muyuta tarpushpankunapas Yaya Diosmi paykunataka kun mikunankunata. Pishkukunamanta pasatami Yaya Dioska kankunata yuyan. Payka kankunata tukuy munashkaykichitami kun. ");
INSERT INTO qupNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Chaymantapas kawsanaykichita yapa yuyarishpaykichipas nima shuk urata atipankichichu mirachinata. ");
INSERT INTO qupNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nima uchillastuta atipashpaykichi mirachinata kawsaykichita ¿imaraykutaya musparinkichi shuk imakunaraykuka? ");
INSERT INTO qupNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Rikuychi chay suma sisakunata, imashnami wiñanahun. Paykuna nima tarawanahunchu, nima puchkanahunchu llachapankunarayku. Mana tarawashpankunapas suma churarishka kanahun. Ñawpa atun apu Salomonpa yapa suma ali churarishkanmanta chay sisakunaka ashwan alita rikurinahun. ");
INSERT INTO qupNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kiwakunaka chakirinalla rupachinalla kashpanpas Yaya Dioska suma sisayukunata ruran. Chayta rikushpa ¿imaraykuta mana kirinkichichu Yaya Dioska kankunata ashwan alita kuyrananta? ");
INSERT INTO qupNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Chayrayku ama musparishpa maskaychichu mikunaykichita upyanaykichita. Nima yapa yuyarishpa kawsaychichu. ");
INSERT INTO qupNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Yaya Diosta mana kasuk runakuna tukuy chaykunallata yuyarishpa kawsanahun. Kankunaka ama paykunashina kawsaychichu. Ashwan kankunapaka tiyanmi alita kuyrak yanapak Yayaykichi Dios. Paymi yachan tukuy ima munahushkaykichitaka. ");
INSERT INTO qupNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kankunaka tukuy shunkuykichimanta pacha Yaya Dios kankunata kamachinanta munashpa kawsaychi. Chasna kawsashpaykichimi tukuy munashkaykichitapas Yaya Dioska kankunata kunka. ");
INSERT INTO qupNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Munashkayni obehakunashinami kankichi. Mana achka kashpaykichipas ama manchaychichu nima imata. Yaya Diosmi kankunata yuyashpan munan paywa pakta wiñayparayku ali kamachihushkanpi kawsanaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yaya Dios ñukanchita yuyashpan kankunapas runa masikichita yuyashpa yanapashpa kawsaychi. Kullkikichi mana tiyashpanka rantichik riychi charishkaykichita. Chay kullkiwa nima imayu runakunata yanapaychi. Chasna rurashpaykichimi silupi apinaykichi sumakunata mirachinkichi. Chaypi charishkaykichika mana mawkayankachu, nima tukurinkachu. Chaypika shuwakuna mana yaykunahunchu, kumehenkunapas mana mikunahunchu. ");
INSERT INTO qupNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Chayrayku alita yuyariychi imatata ashwanta munankichi. Imaykichikunata mirachishpa kawsahushpaykichika chayllatami yuyarinkichi tukuy shunkuykichimanta pacha. Yaya Diospa munashkanta rurashpa kawsahushpaykichika tukuy shunkuykichimanta pacha payllatami yuyankichi. ");
INSERT INTO qupNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Jesuska runankunata rimashpalla katirka: Rikuychi, shuk patrón kasaranan fiestamanta wasinma kutimushpan runankunaka kayashkanta uyashpankuna utkalla punkuta paskanahun payta yaykuchinankunapa. Chay runankuna alicharishka payta chapanahuma, paktashpan utkalla yaykuchinankunapa. Chasnashina kankunapas alicharishka chapawaychi kutimunaynita lamparín sintichishkawashina. ");
INSERT INTO qupNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kushilla kankakuna maykankunatami patronka shamushpan payta chapashpa kahukkunata tarin. Alita uyawaychi. Paykunata tiyachinka, pay kikin alicharishpa paykunata karananpa. ");
INSERT INTO qupNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Patronka chawpi tutapi, mana kashpaka pakarinapi paktamushpan kushilla kankakuna maykankunatami payka alita chapashpa kahukkunata tarik shamun. ");
INSERT INTO qupNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kankuna alita yachankichi, wasi amuka yachashpan ima urasmi shuwaka shamunka, mana puñushpachu uyashpalla chapama wasinpi mana shuwaka yaykunanpa. ");
INSERT INTO qupNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Chasnashina kankunapas tukuy uras alicharishka chapawaychi. Kankuna nima yuyarihushkaykichipi ñuka Yaya Diospa Kachashkan Runaka shamusha. ");
INSERT INTO qupNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Chay uras Pedroka tapurka: Yaya Jesús ¿chay yachachinawa ñukanchillatachu yachachishkanki? Mana kashpaka ¿tukuyraykuchu rimashkanki? ");
INSERT INTO qupNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Chaypi Jesuska aynirka: Shuk patrón shuk llaktama rinanpa shuk ali yuyayyu tukuy uras alita rurak runanta kamachirka tukuy runan masinkunata tarawachinanpa. Chaymanta rimarka mikuna uras paykunata alita karananpa. ");
INSERT INTO qupNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Chay runanka kushillami kanka patroynin kutimushpan paypa kamachishkanta alita paktachishpa kahushkanpi tarik shamushpanka. ");
INSERT INTO qupNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Alita uyawaychi. Chasna alita kasuk runanta patroyninka churanka tukuy ima tiyapushkanta kuyrak kananpa. ");
INSERT INTO qupNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Chay kamachishkan runanka millaypa yuyayyu kamaka, yuyarima patroynika unayahunra, mana utka shamunkachu nishpa. Chasna yuyarishpan kallarima chay tarawak runakunata, warmikunatapas makashpa parisichinata. Pay kikinlla mikushpa, upyashpa machashpa kawsama. ");
INSERT INTO qupNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Chasna mana alita rurashpa kawsashpan mana nima yuyarihushkanpi patroyninka kunkaymanta paktama. Chasna tarik shamushpan chay kamachishkan runantaka sinchita kastigama, imashnami tukuy mana kasuk runakunaka kastigay tukunahun chasna. ");
INSERT INTO qupNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Shuk runaka yachashpantata patronpa munashkanta mana rurashpanka yapatami kastigay tukunka. ");
INSERT INTO qupNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Maykan runachari mana alita yachashpan mana alita rurashka, chayka mana yapatachu kastigay tukunka. Achka yachayta kuy tukushkataka, achkatami Yaya Dioska tapunka ¿yachashkaykita rurashpa kawsashkankichu? nishpa. Chasnallatata achkata kuyrananpa kuy tukushkataka, paytaka Yaya Dioska tapunka ¿alita rurashkankichu maykantami kamachishkani? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jesuska yachachishpalla katirka: Ñukaka shamushkanimi ninawa rupachihukshina tukuy mana ali kashkata kulluchinaynipa. Yapa munaynima chay ninaka ña sintishpa rupachishpa kahushkatashina rikunata. ");
INSERT INTO qupNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Chasna kashpanpas yapa parisishpa wañunaynira tiyan. Chayta paktachinaynikama yapa manchayta llakiyta parisihuni. ");
INSERT INTO qupNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ama yuyariychichu ñuka kay allpama shamushkaynirayku runakuna kushilla shuk yuyayllawana kawsanankunata. Kankunata rimani, shamushkaynirayku runakuna manana shuk yuyayllawa kawsankakunachu. ");
INSERT INTO qupNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kunanmanta pacha shuk wasipi kawsak ayllupura ñukaranti manana shuk yuyayllawa kushilla kawsankakunachu. Pichkamanta kimsa ishkayta chikninkakuna manana shuk yuyayllawa kawsashpankuna. Mana kashpaka ishkay kimsata chikninkakuna manana shuk yuyayllawa kawsashpankuna. ");
INSERT INTO qupNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Shuk mana kiriwak yaya kiriwak wawanta chikninka. Mana kiriwak wawa kiriwak yayanta chikninka. Shuk mana kiriwak mama kiriwak wawanta chikninka. Mana kiriwak wawa kiriwak mamanta chikninka. Shuk mana kiriwak swegra kiriwak nueranta chikninka. Mana kiriwak nuera kiriwak swegranta chikninka. ");
INSERT INTO qupNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Chaymanta Jesuska tukuy chaypi kahukkunata rimarka: Inti yaykuhushpan wayra shamuhushpan puncha amsayashpan chay uras ninkichi tamyankami nishpa. Chasnami kan. ");
INSERT INTO qupNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Chasnallatatami uraymanta sinchita wayraka shamuhushpanka rimankichi rupa kanka nishpa. Chasnami kan. ");
INSERT INTO qupNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mana ali yuyayyu runakuna, yachakshina tukunkichi nima imata yachashpaykichitata. Siluta allpata rikushpaykichi yachankichi punchaka chasna tukuhukta. Rurahushkaynikunataka rikushpaykichi ¿imaraykuta mana asirtanayankichichu imatami ninayan, imashna punchakunapimi kawsahunkichi nishpa? ");
INSERT INTO qupNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Imaraykuta mana munankichichu yuyarinata kankuna kikin, maykanmi ali, maykanmi mana alichu ruranaykichipa? ");
INSERT INTO qupNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Karan kankuna mana kasushkankichichu Yaya Diospa kamachishkanta. Chayrayku tukuy kankuna Yaya Dioswa alichanaykichi tiyan. Yuyariychi. Shuk runata liwihushpayki payta mana pagashkaykirayku kanta apuma pushama. Ñampipi rihushpaykichi alichay chay kanta pushahukwa. Mana paywa alichashpaykika apupi kanta kastigachinka. Chay apuka runankunatami kunka paykuna kanta karselpi churanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kanta rimani, chaymantaka manami llukshinkichu, tukuy liwishkaykita paganaykikama. Chay rimashkanwami Jesuska yachachinayarka: Manara Yaya Diospa atun kastiganan puncha paktarihushpanra uchata rurananchimanta anchurishpanchi Yaya Diostana tapunanchipa ñukanchita llakichinanpa. ");
INSERT INTO qupNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Chay urasllatata shuk runakuna Jesusta kayllayamushpankuna rimarkakuna: Galileamanta shuk runakuna wiwakunata wañuchihushpankuna Yaya Diosrayku rupachinankunapa, romano apu Pilatoka paykunata wañuchichirka. Chasna wañuchiy tukushpankuna yawarninkunaka wiwakunapa yawarwa chapurirka. ");
INSERT INTO qupNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesuska paykunata aynirka: Kankunaka yuyarinkichichari, chay Galileamanta runakunaka chasna kastigarishpa wañushkankunata tukuy Galileapi kawsak runakunamanta ashwan millaypata rurak kashkankunarayku. ");
INSERT INTO qupNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mana chasnachu. Kankunata rimani, millaypata yuyarishpa rurashpa kawsahushkaykichita mana sakishpaykichika kankunapas chasnallatatami kastigarishpa wañunkichi. ");
INSERT INTO qupNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Chaymantapas Jerusalén llaktapi Siloé yaku mayanpi rurarishka torreka urmashpan chunka pusak runakunata nitirka. Chasna wañushpankuna yuyarinkichichari tukuy Jerusalenpi kawsak runakunamanta ashwan millaypata rurak kashkankunata. ");
INSERT INTO qupNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mana chasnachu. Kankunata rimani, millaypata yuyarishpa rurashpa kawsahushkaykichita mana sakishpaykichika kankunapas chasnallatatami kastigarishpa wañunkichi. ");
INSERT INTO qupNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Chasna nishpan shuk yachachinawa yachachishpalla katirka: Shuk runa igu muyuta chakranpi tarpurka. Chasna tarpushpan sakirka wiñananpa. Unaymanta rikunanpa rirka tarpushkaynika muyuyashkachari nishpa. Chasna rishpan mana tarirkachu nima shuk muyuta. ");
INSERT INTO qupNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Chasna rikushpan chakranta kuyrakta rimarka: Kunanwa kimsaynin wata shamuhuni kay iguta rikunapa. Tukuy uras mana muyuyashkatachu tarishkani. Kuchuy. ¿Imaraykuta valin chasna tarpu mana muyuyakka? Yankamanta kaspi masinkunata yakuta kichuhun. ");
INSERT INTO qupNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Chasna nishpan chay tarpu kuyrakka aynirka: Patroyni, kay watallata sakipay. Ñukaka sapinpi allpata pulbushpayni atallpa ismakunawa chapushpa churashara. ");
INSERT INTO qupNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Chaywachari muyuyanka. Mana muyuyashpanka kuchushami wichunaynipa. Ari nishpan patronka sakirka. Chasnashinami Yaya Dioska mana shuk ratulla kastiganchu. Ñukanchita yapa yuyashpan yanapan. Chasna yanapashpanpas payta mana kasushpanchika shutipami kastigay tukushunchi. ");
INSERT INTO qupNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Shuk samana puncha Jesuska shuk tantarina wasipi yachachihurka. ");
INSERT INTO qupNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Chaypi tiyarka shuk warmi, maykanmi chunka pusak watata unkushka karka, supay yaykushkanrayku. Chay warmipa washanka kumu karka, mana atiparkachu nima ima uras kuskayanata. ");
INSERT INTO qupNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Payta rikushpan Jesuska kayarka. Payta kayllayashpan rimarka: Pani, ñami unkushka kahushkaykimanta ampirishka kahunki. ");
INSERT INTO qupNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Chaymanta chay warmita makinwa llankarka. Llankashkanllawa chay warmipa washanka kuska tukurka. Chaypina chay warmika Yaya Diosta atunyachishpa kushichirka. ");
INSERT INTO qupNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Chayta rikushpan tantarina wasipi kamachikka piñarirka Jesús samana punchapi ampishkanrayku. Chaypina tukuy chaypi kahukkunata rimarka: ¿Manachu sokta puncha tarawanapa kan? Chay punchakunapi shamuychi kankunata ampinanpa. Ama shamuychichu samana punchapika. ");
INSERT INTO qupNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Chaypina Jesuska rimarka: Kankunaka mana ali yuyayyukunachu kankichi. Kankunapa burruykichi wakraykichi watarishkata ¿manachu paskankichima yakuta upyachinaykichipa samana punchapika? ");
INSERT INTO qupNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","¿Manachu Yaya Dios kay warmita ashwanta llakichin? Kay warmika Abrahampa miraymantami, Yaya Diospa akllashkan runakunamanta. Supay payta unkuchishpan chunka pusak wata watarishkashina karka. ¿Manachu ali pay watarishkashina kashkanmanta samana punchapi kishpichinaynipa? ");
INSERT INTO qupNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Chasna rimashpan Jesuspa kuntrankunaka pinkarishka kiparirkakuna. Ashwan tukuy runakuna Jesuspa achka suma rurashkankunata rikushpankuna kushikurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Chaymanta Jesuska rimarka: Yaya Diospa ali kamachinanka kay allpapi ¿imawashi parihu kama? ¿Ima yachachinawashi kankunata asirtachinima? ");
INSERT INTO qupNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Yuyariychi mostasa muyuta. Shuk runa chakranpi tarpushpan uchillastu kashpanpas wiñan chillka kaspishina tukunankama. Chasna atun tukushpan pishkukuna ramankunapi tiyarinahun, wasinstukunata ruranahun. ");
INSERT INTO qupNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Chaymanta Jesuska rimarka: Yaya Diospa ali kamachinanka kay allpapi ¿ima yachachinawashi kankunata asirtachinima? ");
INSERT INTO qupNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Levadurata yuyariychi. Shuk warmi panta rurahushpan kimsa mati harinapi uchillastu levadurata yakuwa chapurishkata churan. Chaywa chapushpan tukuy harinaka panrayku alita punkin. ");
INSERT INTO qupNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesuska Jerusalenma rihushpan yachachirka atun llaktakunapi, uchilla llaktakunapipas, maytami pasarka. ");
INSERT INTO qupNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Chaypi shuk runa payta tapurka: Yachachik ¿shutipachu masnalla kishpinkakuna Yaya Diospa kastigananmanta silupi yaykunankunapa? Chaypi Jesuska aynirka: ");
INSERT INTO qupNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Manami chasnalla yaykuypachu Yaya Diospa kawsananpika, kichki punkuta yaykuhukshinalla yaykunkichi. Chayrayku tukuy atipashkaykichita ruraychi yaykunaykichipa. Kankunata rimani, achkami yaykunayankakuna chay Yaya Diospa kawsananpi. Chasna kashpanpas manami atipankakunachu. ");
INSERT INTO qupNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Yaya Dios shuk wasi amushina kashpan shuk puncha kasnami kanka: Amun atarishpan wasin punkuta tapanka. Kanchapi kahushpaykichika rimankichi: Amigu, paskay punkuykita ñukanchipas yaykunanchipa. Wasi amuka ukumanta ayninka: Mana riksinichu kankunata, pikunachari kankichi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Chaypi kankunaka rimankichi: Mikupayarkanchi, upyapayarkanchi kanwa pakta. Kanmi yachachipayarkanki puntanchipi. ");
INSERT INTO qupNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Chaypina payka ayninka: Ñami rimashkani kankunata, mana riksinichu pikunachari kankichi. Tukuy kankuna mana ali rurakkuna anchuriychi ñukamanta. ");
INSERT INTO qupNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Chasna wichurishka kahushpaykichi sinchita parisishpa wakankichi, piñaywa kiruykichikunata kanirinkichi. Yaya Diospa ali kamachinan mushu mundupi yaya rukunchi wañukuna Abrahamta, Isaakta, Jakobta, tukuy ñawpa Yaya Diospa yachayninwa yachachikkunatapas chaypi kahukkunata rikunkichi. Kankunaka wichurishka kahushkaykichita yachankichi. ");
INSERT INTO qupNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Inti llukshinamanta, inti yaykunamanta, anakmanta, uraymanta runakuna tantarinkakuna Yaya Diospa ali kamachinan mushu mundupi paywa pakta kushilla mikunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Chasna kashpan maykankunami kay allpapi kawsahushkanchipi runa masinkunapa rikushkanpi tukuymanta ashwan mana valikchu kanahun, paykunamantami shukkuna Yaya Diospa rikushkanpi tukuymanta ashwan valichirishka kankakuna. Maykankunami kay allpapi kawsahushkanchipi runa masinkunapa rikushkanpi tukuymanta ashwan valichirishka kanahun, paykunamantami shukkuna Yaya Diospa rikushkanpi tukuymanta ashwan mana valikchu kankakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Chay uras shuk fariseokuna Jesusta kayllayashpankuna rimarkakuna: Apu Herodeska kanta wañuchichinatami munan. Chayrayku utkalla kaymanta llukshishpayki riy. ");
INSERT INTO qupNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Chaypi Jesuska aynirka: Rimak riychi chay mana ali yuyarikta, ñuka tukuy Yaya Diospa kamachiwashkanta ruranaynikamami kawsasha. Runakunamantami supaykunata llukshichinaynira tiyan, unkushkakunatapas ampinaynira tiyan. ");
INSERT INTO qupNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kunan puncha, kayapas, ashwan shuk punchakunapas Yayayni Diospa kamachiwashkanta rurashpa purisharami. Mana kaypichu wañuchiwankakuna. Ñawpamanta pacha Yaya Diospa yachayninwa yachachikkunataka wañuchipayarkakuna Jerusalén llaktapi. Chayraykumi ñukapas wañuchiy tukunayni tiyan Jerusalenpillatata. ");
INSERT INTO qupNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ay Jerusalenpi kawsak runakuna, yapa llakini kankunarayku. Ñawpamanta pacha Yaya Diospa yachayninwa paypa shiminta yachachikkunata wañuchipayankichi. Chaymanta Yaya Dios kankunama kachashkan runakunatapas tukuy uras rumikunawa tuksishpa wañuchipayankichi. Ñukaka achka kuti kankunata wañuymanta arkanayashkani, imashnami shuk atallpa wawankunata rikran ukupi tantachishpan arkan wañuymanta. Chasna kankunata arkanayashpaynipas mana munashkankichichu. ");
INSERT INTO qupNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Rikuychi, kunan kankunata sakishpayni llaktaykichipi chunlla kiparinka. Kankunata rimani, manami rikuwankichinachu alicharishka kanaykichi punchakama. Chay urasmi rimawankichi: Yaya Diospa yanapashkan ali runami kanki. Yaya Diospa munashkanta ruranaykipa kachashkan kashpaykimi shamuhunki nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Shuk samana punchapi Jesuska rirka mikunanpa shuk fariseo apupa wasinma. Chaypi shuk fariseokunaka Jesusta shuk kamachishkata mana kasunanta tarinayashpankuna payta pakallamanta ñawinkunata sipuyachishpa rikurayarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Chaypi Jesuspa puntanpi shuk punkirishka runa kahurka. ");
INSERT INTO qupNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Payta rikushpan Jesuska Moisespa killkashkanta yachachikkunata, fariseokunatapas tapurka: ¿Imashnata yachachin Moisespa killkashkanka? ¿Samana punchapika unkushkakunata atipanchimachu ampinata manachu? ");
INSERT INTO qupNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Chay runakunaka chunlla uyarkakuna. Mana aynishpankuna Jesuska chay unkushka runata llankashpan ampirka. Chaymanta rimarka wasinma kutinanpa. ");
INSERT INTO qupNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Chaypi kahukkunatana rimarka: Kankunapa wawaykichi, wakraykichi uchkupi urmashpanka ¿manachu llukshichinkichima samana puncha kashpantata? ");
INSERT INTO qupNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Chasna tapushkanta uyashpankuna nima imata atiparkakunachu ayninata. ");
INSERT INTO qupNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Chay fariseopa wasinpi mikunapa yaykushpankuna kayarishkakunaka ashwan ali tiyarinakunata akllarkakuna tiyarinankunapa. Chayta rikushpan Jesuska paykunata shuk yachachinawa kasna yachachirka: ");
INSERT INTO qupNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Shuk runa kanta kasarana fiestama kayashpanka ama tiyarik riychu tukuymanta ashwan ali tiyarinapi. Chaypi tiyarishpaykika kanpa washayki shuk ashwan munashkan runa shamuma. ");
INSERT INTO qupNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Chasna kashpan chay kayak amuka kantaka rimama: Kay tiyarinamanta anchuriy, kay runa tiyarinanpa. Chasna nishpanka pinkarishpayki washama tiyarik rinkima. ");
INSERT INTO qupNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ashwan ali kama, kanta kayashpankuna kan washama tiyarinaykipa. Chasna rurashpayki kanta kayak amuka shamushpanka rimama: Amiguyni, ashwan ali tiyarinapi tiyarik shamuy nishpa. Chaypi shuti tukuy kanwa tiyahukkunaka yachankakuna munashkan runa kanaykita. ");
INSERT INTO qupNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kankuna kikinmanta yuyarinkichima tukuy runa masinikunamanta ashwan yachakmi kani nishpa. Chasna atun tukunayashpaykichika Yaya Diosmi kankunata mana alichu nishpa pinkachinka. Kankuna runa masikichikunamanta mana atun tukunayashpa paykunata yuyashpa yanapashpaykichika Yaya Diosmi sumakta kankunata atunyachinka. ");
INSERT INTO qupNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Chaymanta Jesuska payta kayak runata rimarka: Shuk atun mikunarayku kayashpaykika ama kayankichu munashkayki runakunallata, nima aylluykikunallata, nima kuchuykipi kullkiyu kawsakkunallata. Chasna kayashpaykika paykunapas chasnallatatami kantapas kushichishpa kayankakuna. Chasna rurashkaykimanta kay allpapi ña pagarishkashina tukunki. Nima ima kiparinchu Yaya Dios kanta kushichinanpaka. ");
INSERT INTO qupNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ashwan ali kama mikunarayku kayanaykipa nima imayukunata, makin pitirishkakunatapas, tulawa purikkunatapas, wiskukunatapas. ");
INSERT INTO qupNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Paykuna kanta mana atipanahunchu nima imata kutichinata. Yaya Diosllami chayta kutichinka tukuy kirishpa wañushkakuna kawsarinan punchapi. Chasna kashpan kushillami kanki. ");
INSERT INTO qupNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Chay Jesuspa yachachishkanta uyashpan chay mesapi mikuhuk runakunamanta shukka Jesusta rimarka: Kushillami kanka maykanmi kayashka kan Yaya Diospa ali kamachinan mushu mundupi kushikuna tantarinapi mikunanpa. ");
INSERT INTO qupNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Chayta uyashpan Jesuska shuk yachachinawa aynirka: Shuk runaka shuk atun mikunata rurarka. Runankunata kacharka achka runakunata kayananpa, wasinpi mikuk shamunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ña mikuna uras paktarishpan shuk runanta kacharka chay kayarishka runakunata rimak rinanpa: Shamuychi. Ñami tukuy alicharishka kahun. ");
INSERT INTO qupNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Chasna kayashpan tukuy aynirkakuna: Manami atipanchichu rinata. Shuk nirka: Kunallami shuk chakrata rantishkani. Chayta rikuk rinayni tiyan. Patroykita rimakriy llakichiwananpa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Shukka nirka: Kunallami chunka wakrata rantishkani. Rikuk rinayni tiyan alikunachu manachu. Patroykita rimakriy llakichiwananpa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Kuti shukpas nirka: Kunallami kasarashkani. Chayraykumi mana atipanichu llukshinata. ");
INSERT INTO qupNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ni maykan kayashkankuna kasushpanna chay runanka kutirka. Tukuyta patronta rimak rirka, imashnami payta rimashkakuna. Patroyninka chayta uyashpan piñarishpan rimarka: Kunanka utkalla kayakriy llaktapa ñampikunapi tiyahukkunata, tukuy nima imayu runakunata, mana purinata atipakkunatapas, waklishka aychayu runakunatapas, wiskukunatapas nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Patroyninta kasushpan chay runanka kayak rirka shuk runakunatana. Kutimushpan patronta nirka: Ñami kanpa kamachishkaykita paktachishkani. Chasna kashpanpas tiyanrami chusha tiyarinakunaka. ");
INSERT INTO qupNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Chaypi patronka kuti rimarka: Shuk ñampikunamana riy. Chaypi kahukkunata rimay mana pinkashpa shamunankunapa, wasinika untakta kananpa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kankunata rimani: Chay kayay tukushka mana shamushka runakunaka manami mikunkakunachu chay alichashkayni suma mikunata ñukawa pakta. ");
INSERT INTO qupNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Chay fariseopa wasinpi mikushkanwasha Jesús llukshishpan achka runakuna payta katirkakuna. Chaypi Jesuska tikrarishpan paykunata rimarka: ");
INSERT INTO qupNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Katinayawahushpaykichika ñukata yuyawanaykichi tiyan tukuy aylluykichikunamanta pasata. Chaymantapas kankuna kikin munanaykichita sakinaykichi tiyan ñukapa munanaynitana ruranaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ñukata katiwahushkaykichirayku runakunapa parisichishkankunata awantanaykichi tiyan. Maykanmi mana parisinayanchu ñukashina, chayka manami runaynichu kanka. ");
INSERT INTO qupNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Shuk wasita rurakmanta yuyariychi. Shuk runa atun wasita ruranayashpanka alita yuyarin imakunatami chay wasirayku munan nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Mana alita yuyarishpanka chayra wasita kallarihushkanllapi mana tukuchinata atipashpan sakinan tiyan. Chasna kashpan tukuy payta rikuk runakunaka asichishpa rimankakuna: ");
INSERT INTO qupNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Rikuychi chay runata. Pay kikinta llullachirishpa kallarishka wasinata. Kunanka mana atipanchu tukuchinata. ");
INSERT INTO qupNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Chasnallatata shuk atun apumanta yuyariychi. Shuk allpapi kamachik atun apuwa munahumaka wañunakunata. Manara llukshishpanra alita yuyarima, chay apuka ishkay chunka waranka suntalunwa shamuhushpanka chunka waranka suntaluyniwa atipaynimachu payta winsinata manachu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mana atipashpan chay apuka kuntran chayra karupi shamuhushpan payma kachama shuk suntalunta tapunanpa, mana wañunakushpa alichanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Chasnashina kankunapas alita yuyarinaykichi tiyan katiwankichichu manachu nishpa. Mana tukuy imaykichita sakishpa katiwashpaykichika manami atipankichichu runaynikuna kanata. ");
INSERT INTO qupNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","35","Yuyariychi kachimantapas. Kachika ali kan. Chamu tukushpanka manana valinchu nima imarayku. Wichunchima. Chasnashinami kankunapas Yaya Diospa shiminta mana kasushpaykichika chamu kachishina kankichi, mana valinkichichu runa masikichita yanapanaykichipa. Yaya Diospa shiminta kasushpaykichika ali kachishinami kankichi yanapanaykichipa tukuy runakunata. Kay yachachihushkaynita alita uyashpa yachakuychi. ");
INSERT INTO qupNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Jesús yachachihushpan achka runakuna payta kayllayarkakuna uyanankunapa. Shuk runakuna karkakuna romano tukuymanta atun apurayku impuestuta kobrakkuna, shuk mana alita rurakkunapas. ");
INSERT INTO qupNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Chayta rikushpankuna fariseokunaka, Moisespa killkashkanta yachachikkunapas washanchashpa rimarkakuna: Kay runaka uchasapakunata yuyashpan paykunawa pakta mikun. Chasnaka mana alichu. ");
INSERT INTO qupNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Chaypi Jesuska paykunata shuk yachachinawa kasna yachachirka: ");
INSERT INTO qupNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Kankunamanta shukpa tiyama shuk pachak obeha. Shuk chinkarimaka ¿manachu chay iskun chunka iskunta pastupi sakishpan maskak rinma chay shuk chinkarishkata tarinankama? ");
INSERT INTO qupNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tarishpan ¿manachu sumakta kushikushpan apishpan markama? ");
INSERT INTO qupNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Chaymanta wasinma paktashpan riksishkankunata, kuchunpi kawsakkunatapas tantachishpan rimama: Kushikuychi ñukawa. Ñami tarishkani chinkarishka obehaynita nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kankunata rimanimi: Shuk chinkarishkata tarishpaykichika atunta kushikunkichi. Chasnallatatami silupi kawsakkuna kushikunkakuna, shuk rua mana alita rurashkankunata sakishpan Yaya Diostana kasunanpa. Iskun chunka iskun runakuna alita rurak runa kani yanka nishpa kawsakkunamanta mana yapa kushikunkakunachu. ");
INSERT INTO qupNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Shuk warmipa chunka kullkikuna tiyamaka. Chay chunka kullkikunamanta shuk chinkaripumaka ¿manachu lamparinta sintichishpan maskama kawitu ukupi sumakta pichashpan tarinankama? ");
INSERT INTO qupNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Chasna tarimaka, amigunkunata paypa kuchunpi kawsakkunata kayashpan rimama: Chay kullki chinkaripashkata ñami tarishkani. Chayrayku tukuy kankuna ñukawa pakta sumakta kushikuychi. ");
INSERT INTO qupNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kankunata rimani: Chasnashinami Yaya Diospa angelkunaka kushikunkakuna, shuk runa mana alita rurashkankunata sakishpan Yaya Diostana kasunanpa. ");
INSERT INTO qupNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesuska shuk yachachinawa yachachishpalla katirka: Shuk kullkiyu runa ishkay wawayu karka. ");
INSERT INTO qupNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Washaniru wawanka yayanta rimarka: Yayayni, shuk puncha tukuy kanpa tiyashkanmanta chawpichishpa ñukata wawkinitapas kunaykita kunalla kuway. Chasna rimashpan yayanka tukuy ima charishkanta chawpita kurka karan shuk wawanta. ");
INSERT INTO qupNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Manana yapa unaymantachu chay washaniru wawanka tukuy ima tiyashkanta rantichishpan kullkita tantachishpan rirka shuk karu chikan runakunapa allpama. Chaypi mana ali ruranakunata rurashpan kullkinta llampu tukuchirka. ");
INSERT INTO qupNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Llampu tukuchishpan chay llaktakunapi kawsak runakunarayku sinchi yarkay paktarka. Chaypi paypas yapa yarkaywa karka. ");
INSERT INTO qupNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Chasna kashpan shuk chaypi kawsak runama tapuk rirka payta tarawachinanpa. Chay runaka payta kacharka kuchinkunata kuyrananpa. ");
INSERT INTO qupNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Yapa yarkaywa kashpan kuchi mikunata mikunayarka. Chasna munashpanpas nima chayta payta karanayarkakunachu. ");
INSERT INTO qupNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Chaypi yuyarirka: Yayaynipa runankunapaka achka mikuna tiyan. Ñukaka kaypi yarkaywa wañuhuni. ");
INSERT INTO qupNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Kunalla yayaynima kutishara. Paktashpayni rimak risha: Yayayni, kanmanta anchurishpayni manami alitachu rurashkani. Chaymantapas manami Yaya Diospa munashkantachu rurashpa kawsashkani. ");
INSERT INTO qupNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Chayrayku amana yuyawaynachu wawaykitashina. Shuk runaykitashina tarawachiway nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Chasna yuyarishpan chay musuka yayanma kutirka. Ña paktahushpan yayanka karullapi rikushpan riksirka. Sumakta llakichirka, kallpashpa tinkuk rirka. Wawanta ukllarishpan mucharka. ");
INSERT INTO qupNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Chaypi wawanka rimarka: Yayayni, kanta mana alitachu rurashkani. Chaymantapas manami Yaya Diospa munashkantachu rurashpa kawsashkani. Amana yuyawaynachu wawaykitashina nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Yayanka paypa rimahushkanta mana kasushpan runankunata rimarka: Utkalla suma churarinata apak riychi payta churachinaykichipa. Chasnallatata makinpi anilluta churachiychi, chakinpipas sapatuta churachiychi. ");
INSERT INTO qupNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Chaymanta apak riychi wira wakra wawata wañuchinaykichipa, mikuhushpa tukuymanta sumakta kushikunanchipa. ");
INSERT INTO qupNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kay wawaynika wañushka kashkanmantashina kawsarimushka, unay chinkarishkanmanta kunan ña rikurik shamushka. Chasna sumakta kushikushpan atun fiestata rurarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Chay fiestata rurahushpankuna puntiru wawanka chakranpi kahurka. Wasima kutimushpan uyarka bombota, kenata, tukuy kushilla kahukkunata. ");
INSERT INTO qupNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Chaypi shuk runanta kayashpan tapurka: ¿Ima fiestata rurahunkuna? ");
INSERT INTO qupNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Chay runanka aynirka: Wawkikimi kutimushka. Ali paktamushkanrayku yayaykika atun mikunata rurashka, wira wakra wawata wañuchichishka karananpa. ");
INSERT INTO qupNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Chasna uyashpan chay wawkinka yapa piñarirka. Mana yaykunayarkachu wasipi. Paktashkanta yachashpan yayanka wasimanta llukshirka payta kayananpa. ");
INSERT INTO qupNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Chaypi chay ruku wawanka aynirka: Yayayni, maytukuy watakunata kanta yanapashkani. Kamachishkaykita nima ima uras killashkanichu. Chasna rurashpaynitata nima ima uras kuwashkankichu nima shuk obehastuta kushikushpa amiguynikunawa mikunaynipa. ");
INSERT INTO qupNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kunanka chay shuk kanpa wawaykika mana ali warmikunawa kawsashpan kullkikita llampu tukuchishpan paktamushka. Payraykuka wira wakra wawata wañuchishkanki. ");
INSERT INTO qupNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Chasna nishpan yayanka rimarka: Wawaynistu, kanka tukuy urasmi ñukawa kahunki. Tukuy tiyawahushkaka kanpapas kan. ");
INSERT INTO qupNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Chay wawkikika wañushkashina kashkanmantami paktamushka. Chinkarishka kashkanmanta paktamushka. Chasna kashpan ¿manachu yapa kushikushpa kay fiestata ruranchima? ");
INSERT INTO qupNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Kutikashka Jesuska runankunata yachachishpan rimarka: Shuk kullkiyu runapa tiyarka shuk runan, maykanmi payrayku tukuyta rurapayan. Shuk puncha shuk runakunaka chay runanmanta payta rimarkakuna: Chay kamachinanpa churashkayki runaykika kullkikitami yanka gastahun mana valikkunallapi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Chaypi patronka chay runanta kayarka. Kayashpan rimarka: Kanmanta uyashkani llullachiwahushkaykita. Manana munaninachu ñukarayku tukuyta rurak kanaykipa. Kunanka rikuchiway tukuy rurashkaykimanta killkashkaykita. ");
INSERT INTO qupNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Chaypi chay runanka yuyarirka: ¿Imashnata rurasha kunanka? Patroynika llukshichiwahun manana payrayku tukuyta rurak kanaynipa. Mana ursayuchu kani sinchita tarawashpa kawsanaynipa. Pinkaypami kanka kullkita tapushpa purihushpaynika. ");
INSERT INTO qupNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Kunan ñami yuyarishkani imashnami rurasha runakuna yaykuchiwanankunapa wasinkunapi. ");
INSERT INTO qupNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Chasna yuyarishpan patroyninta liwikkunata shukllankama shukllankama kayarka. Puntiruta tapurka: ¿Maytukuytata liwinki patroynita? ");
INSERT INTO qupNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Chay runaka aynirka: Liwinimi shuk pachak bidón aseiteta. Chaypina chay patronpa runanka rimarka: Ñuka yanapashkayki. Apiy chay liwiyki killkata. Utka tiyarishpayki killkay pichka chunka tupullata. Ñukapas chasnallatata killkasha chay patroynipa liwichinan killkapi parihu kanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Chasnallatata shuktapas tapurka: Kanka, ¿maytukuytata liwinki? Payka aynirka: Shuk pachak kostal arustami liwini. Chaypi chay patronpa runanka rimarka: Apiy chay liwiyki killkata, pusak chunka tupullatana killkay. Ñukapas chasnallatata killkasha chay patroynipa liwichinan killkapi parihu kanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Patronka chay runan rurahushkanta yachashpan rimarka: Chay llullachik runaynika yuyaysapami, alita yuyarishpa rurak runa. Jesuska chay yachachinata tukuchishpan runankunata rimarka: Mana alita rurak runakuna Yaya Diosta kasukkunamanta ashwan alita yuyarinahun, imatami ruranankuna tiyan runa masinkunawa alita kawsanankunapa. Mana chasna kachun. ");
INSERT INTO qupNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Kankunata rimani: Kay allpapi achka runakunata mana alita rurachik kullkiwa imakunawapas kankunaka runa masikichikunata yanapaychi kankunata yuyanankunapa. Chasna rurashpa kawsashpaykichika imaykichi manana yanapak kashpan kay allpapi kawsanaykichi tukurinan uras yaykuchiy tukunkichimi wiñayparayku Yaya Dioswa kawsanaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Maykanmi uchillastuwa alita ruran, chasnallatatami achkawapas alita ruranka. Maykanmi uchillastuwa mana alita ruranchu, chasnallatatami achkawapas mana alitachu ruranka. ");
INSERT INTO qupNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kay mundumanta imakunawa mana alita rurashpaykichika ¿imashnataya Yaya Diospa kunayashkanta kuy tukunkichima? ");
INSERT INTO qupNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Chaymanta runa masikichi kankunapi sakishkanwa paypa munashkantashina mana rurashpaykichika ¿Yaya Dioska kankunata kunayashkanta kumachu? Manami kumachu. ");
INSERT INTO qupNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nima maykan kamachishkan runa atipamachu ishkay patroyninrayku chay ratulla tarawanata. Shukllata kasunan tiyan. Shuk patroyninta kasushpanka shuktaka mana kasunkanachu. Chasnashinami kankunapas imaykichillata yuyarishpa kawsashpaykichika manana atipankichinachu Yaya Diosta kasushpa kawsanata. ");
INSERT INTO qupNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Chasna uyashpankuna chay yapa kullkita munak fariseokunaka Jesusta asichirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Chaypi Jesuska nirka: Kankuna mana ali rurak runakuna kashpaykichimi runakunata llullachishpa kirichinkichi yapa ali rurahuk runakuna kanaykichita. Chasna rurashpaykichipas Yaya Dioska tukuy yuyarihushkaykichita alita riksinmi. Maykantami runakuna yuyarinahun yapa ali kashkata, Yaya Dioska chaytaka chikninmi. ");
INSERT INTO qupNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ñawpamanta pacha Bawtisak Juan yachachinankama Moisespa killkashkanlla, chaymanta Yaya Diospa yachayninwa shuk yachachikkunapa killkashkankunalla tiyarka yachanaykichipa imashnami alita kawsananchi tiyan Yaya Diospa rikushkanpi. Kunanka Juan yachachishkanmanta pacha kankunata yachachinchina kay suma ali shimita Yaya Diospa ali kamachinan kay allpapi ña kallarishkanmanta. Chasna kashpanmi achka runakuna atipashkankunata ruranahun Yaya Diospa ali kamachinanpi kawsanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kay silu allpapas shuk puncha chinkarinkami. Yaya Diospa rimashkanmantaka nima shuk shimi chinkarinkachu. Tukuy paktarinan tiyan. ");
INSERT INTO qupNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Maykan kari warminta sakishpan shuk warmitana warmiyashpanka uchatami ruran Yaya Diospa rikushkanpika. Chasnallatatami maykan kari shuk sakiy tukushka warmita warmiyashpanka uchata ruran. ");
INSERT INTO qupNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesuska shuk yachachinawa yachachishpalla katirka: Tiyarka shuk yapa kullkiyu runa. Chay runaka suma churarinallata churaripayan. Karan puncha atun suma mikunata rurachishpa kushilla kawsapayan. ");
INSERT INTO qupNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Chaymanta tiyarka shuk runa nima imayu Lásaro shutiyu. Chay runaka llagawa llampu aychanka ismushka karka. Chay kullkiyupa wasin punkupi tiyaripayan mikunanmanta shuk parti urmashpan ñukapas mikunaynipa nishpa. Chaypi tiyarishpan allkukunaka payta kayllayapayanahun aychan ismushkata llawkanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Shuk puncha chay nima imayuka wañurka. Angelkuna paytaka aparkakuna siluma yaya ruku Abrahampa kuchunpi tukuy parisishkanmanta samananpa. Chaymanta kullkiyu runapas wañurka. Paytaka wañushkakunapa churana uchkupi churashpa taparkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Wañushkakunata wakaychanapi yapa parisihushpan karumanta rikurka Lasarota Abrahamwa pakta kahushkanta. ");
INSERT INTO qupNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Chasna rikushpan Abrahamta kaparishpa tapurka: Yaya Abraham, llakichiway ñukatapas. Yapami rupawa kaypi parisihuni. Kachapay Lasarota yakuwa ukuchishpa makin wawapa puntanwa kalluynita chiriyachiwananpa. ");
INSERT INTO qupNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Chasna nishpan Abrahamka aynirka: Wawayni, yuyariy. Allpapi kawsahushpaykira tukuy munashkaykita Yaya Dios kanta kushka. Kunanka chaykunaka ñami tukurishkakuna. Lasaroka yapa parisishpa allpapi kawsarka. Chayrayku kunanka kay ali kawsanapi kushillayachiy tukushka. Kanka kunanka nanaywa llakiywa parisihunki. ");
INSERT INTO qupNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Chaymantapas ñukanchi kankunawa mana tinkunakunanchipa shuk atun waykumi tiyan. Maykankunami munanahun kaymanta kankunama rinata mana atipanahunchu, nima chaymanta kanwa kahukkuna atipanahunchu shamunata kayma. ");
INSERT INTO qupNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Chaypina chay kullkiyu wañuka rimarka: Chasna kashpanka yaya Abraham, kanta tapuni, Lasarota kachapay yayaynipa wasinma. ");
INSERT INTO qupNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Chaypi pichka wawkinikuna kahunkuna. Paykunata sinchita kunak richun paykunapas kay yapa llakiyta nanayta parisinama mana shamunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Chaypi Abrahamka aynirka: Paykunaraykuka tiyanmi Moisespa killkashkankuna, Yaya Diospa yachayninwa shuk yachachikkunapapas. Chaykunata kasunahuchun. ");
INSERT INTO qupNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Chay kullkiyu wañuka kuti aynirka: Ari yaya Abraham, chay wawkinikuna Yaya Diospa killkachishkanta mana kasunayanahunchu. Ashwan wañushkakunamanta shukka kawsarishpan paykunama rinma, chaypirami shuti uyashpankuna kasunkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Chasna aynishpan Abrahamka rimarka: Mana kasushpankunaka Moisespa killkashkanta, nima Yaya Diospa yachayninwa shuk yachachikkunapa killkashkanta, manami kasunkakunachu nima shuk wañushka runa kawsarishkata. ");
INSERT INTO qupNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Chaymanta Jesuska runankunata rimarka: Tukuy uras tiyankami uchata rurachinayak runakunaka. Chasna kashpanpas ¡ay, imashna kastigushi kanka chay uchata rurachik runakunarayku! ");
INSERT INTO qupNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Maykanmi runa masinta uchata rurachin, paytaka Yaya Diosmi sinchita kastiganka. Ashwan ali kama, atun rumiwa kunkanmanta watashpa atun kucha chawpipi wichunapa chaypi chinkarinanpa. ");
INSERT INTO qupNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Alita kuyrariychi kankuna kikin uchata mana ruranaykichipa. Shuk kirik masiki mana alita rurashpanka payta rimay mana chasna rurashpa katinanpa. Mana alita rurashkanmanta llakirishpa llakichiway nishpanka llakichiy. ");
INSERT INTO qupNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Chasnallatata shuk puncha kanchis kuti kanta millaypata rurashpanka karan kuti kanta rimak shamuma: Kunanka sakini millaypa rurashkaynikunata, llakichiway nishpa. Chay kanchis kuti payta chasnalla llakichinkilla. ");
INSERT INTO qupNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Chasna Jesús yachachishpanna apostolninkunaka payta tapurkakuna: Ñukanchita yanapay ashwan alita kanpi sinchikunanchipa. ");
INSERT INTO qupNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Chaypi Jesuska aynirka: Ñukapi sinchikunaykichika shuk uchilla mostasa muyushina uchillastullapas kamaka, kay kaspita rimankichima: Kaymanta anchuriy, kuchapi wiñakriy nishpa. Chay ratulla chay kaspika kasuma. ");
INSERT INTO qupNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Chaymanta Jesuska runankunata rimarka: Nima maykan patrón runanta rimamachu, chakranpi tarpushkanwasha, wakrankunata kuyrashkanwasha kutimushpan: Tiyarik shamuy mesapi mikunaykipa. ");
INSERT INTO qupNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ashwan paytaka rimama: Mikunaynita yanupak shamuy. Chaymanta karaway, upyachiway. Mikushkayniwasha upyashkayniwasha kanka mikunki. ");
INSERT INTO qupNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Tukuy kamachishkanta kasushkanrayku chay patronka runanta agradesimachu? Mana. Runan kashpan paypa tarawanan kan patronta sirvinanpa. ");
INSERT INTO qupNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Chasnallatata kankunapas, paktachishpaykichi tukuy Yaya Diospa kamachishkanta, rimaychi: Rurashkanchi maykantami Yaya Dios munashka rurananchipa chayllata. ");
INSERT INTO qupNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesuska Jerusalenma rihushpan shuk parti Samaria allpa Galilea allpawa tupanakushka mayanta rihurka. ");
INSERT INTO qupNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Shuk uchilla llaktapi paktana kahushkanpi, chunka runakuna aycha ismuchik unkuywa kahukkunawa tinkunakurka. Chay unkushkakunaka mana kayllayanata atipashpankuna karullapi shayarirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Chaymantalla kaparishpa tapurkakuna: ¡Yaya Jesús, ñukanchita llakichiy! nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesús paykunata rikushpan nirka: Saserdotekunama riychi, karaykichita rikushpankuna rimanankunapa ampirishkachu manachu nishpa. Paykunaka kasurkakuna. Chayma rihushkankunapi ampirishka karkakuna unkushka kahushkankunamanta. ");
INSERT INTO qupNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Shukka ña ali kashkanta rikushpan Yaya Diosta sinchi shimiwa kushichishpa kutimurka. ");
INSERT INTO qupNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesuspa puntanpi kunkurik shamurka, allpakama kumurishpa payta ampishkanrayku agradesirka. Payka karkami Samariamanta runa. ");
INSERT INTO qupNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Shukllata rikushpan Jesuska tapurka: ¿Kunanka shukkunakaya? ¿Manachu chunka ampiy tukushkankichi unkushka kahushkaykichimanta? ¿Maypitaya kahunkuna chay iskunkunaka? ");
INSERT INTO qupNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Imashnataya kay mana israel runalla kutimushka Yaya Diosta agradesishpa kushichinanpa? ");
INSERT INTO qupNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Chaypina chay runata rimarka: Atarishpayki wasikima riy. Ñukapi sinchikushkaykiraykumi ña kishpishka kahunki. ");
INSERT INTO qupNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Chaymanta fariseokunaka Jesusta tapurkakuna: ¿Ima urasta Yaya Diospa ali kamachinanka kay allpapi kallarinka? Jesuska aynirka: Yaya Diospa ali kamachinan paktarihushkanka manami rikuypachu. ");
INSERT INTO qupNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mana atipanchichu rimanata kaypimi, chaypimi Yaya Dios kamachihun nishpa. Kamachihushkanta mana rikushpaykichipas paypa ali kamachinan chawpikichipi ña kallarishka. ");
INSERT INTO qupNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Chaymanta runankunallata rimarka: Shuk puncha paktarinkami, maypimi yapa rikunayankichi shuk punchallapas ñuka Yaya Diospa Kachashkan Runa ña kamachik kanaynita. Chayta rikunata munashpaykichipas manami atipankichichu. ");
INSERT INTO qupNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Chay urasmi kankunata llullachinayashpa rimankakuna: Kaykaya Yaya Diospa Kachashkan Runaka. Chaymami Yaya Diospa Kachashkan Runaka nishpa. Chasna nishpankunapas ama rinkichichu rikunaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Imashnami ilampaka rikurin kayma chayma tukuy siluta punchayachishpa, chasnashinami ñuka Yaya Diospa Kachashkan Runaka kuti shamusha. ");
INSERT INTO qupNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Chay puncha manara paktahushpanra achkata parisinayni tiyan. Kunan kawsak runakuna chiknishpa mana valiktashina wichuwankakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ñuka Yaya Diospa Kachashkan Runa kuti shamushpayni ñawpa Noé kawsashkan urasshina kanka, runakuna kunkaylla kawsahushkankunapi kunkaymanta kastigay tukunkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noé kawsashkan uras runakunaka kunkaylla mikushpa upyashpa warmiyashpa kawsapayarkakuna Noé chay atun lanchapi yaykunan punchakama. Chasnallapi atun untay paktashpan tukuy chinkarirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Chasnallatata tukurka Lot shutiyu kawsashkan uraspas. Sodoma llaktapi kawsak runakuna kunkaylla mikupayarkakuna, upyapayarkakuna, rantipayarkakuna, rantichipayarkakuna, tarpupayarkakuna, wasikunata rurapayarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lotka chay Sodoma llaktamanta llukshishpan nina asufriwa tamyashina silumanta urmarka. Chay ninaka tukuy runakunata wañuchirka. ");
INSERT INTO qupNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Chasnashinami kanka Yaya Diospa kastiganan punchaka, ñuka Yaya Diospa Kachashkan Runa kuti shamushpayni. ");
INSERT INTO qupNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Chay puncha wasi awapi kahushpaykichika chaymantalla mitikuychi. Imaykikunaka wasi ukupi tiyahushpanka amana yaykunkichichu apak rinaykichipa. Chasnallatata chakraykichipi tarawahushpaykichika chaymantalla mitikuychi. Amana kutiychinachu wasiykichima. ");
INSERT INTO qupNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Yuyariychi imashnami Lotpa warminka ñawpa wañurka. Chay warmika imankunallapi yuyarishpa mana utkallachu mitikurka kishpinanpa. Chayraykumi wañurka. ");
INSERT INTO qupNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Maykanmi Yaya Diospa munashkanta kasushpa kawsan, chayka wañuchiy tukushpanpas Yaya Dioswa wiñaypa kawsanka. ");
INSERT INTO qupNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Kankunata rimani: Chay uras ishkay runakuna tutapi shuk tulltullapi kashkankunamanta, shukllami pushay tukunka wiñayparayku, shukka sakirishka kanka. ");
INSERT INTO qupNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Chasnallatata ishkay warmikuna parihu kutahushkankunamanta shukllami pushay tukunka, shukka sakirishka kanka. ");
INSERT INTO qupNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ishkay runakuna chakrapi tarawashpankuna shukllami pushay tukunka, shukka sakirishka kanka. ");
INSERT INTO qupNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Chasna rimashkanta uyashpankuna runankunaka tapurkakuna: Yaya Jesús, ¿maypita chasna kanka? Chaypi Jesuska aynirka: Maypimi wañushkakunaka kahunkuna, chaypimi ullawankakunaka tantarinahun. Chasnashina runakuna millaypa ruranankunata yapa mirachishpankuna millanayaypa ismushina tukushpankuna kastigay tukunkakuna. Chayka mana pakallachu kanka ashwan tukuyrayku yachaypa rikuypa kanka. ");
INSERT INTO qupNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Chaymanta Jesuska runankunata shuk yachachinawa yachachirka mana sampayashpa Yaya Diosta mañanankunapa kasna nishpa: ");
INSERT INTO qupNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Shuk llaktapi tiyarka runakuna mana alita rurashkankunamanta alichak apu. Chay alichak apuka mana manchapayanchu Yaya Diosta, nima runakunata. Yapa piña karka. ");
INSERT INTO qupNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Chay llaktapillatata kawsapayarka shuk mashintu warmi. Chay mashintuka chay alichak apuma ripayarka payta tapunanpa: Ñukata yanapaway. Chikniwakta kayashpayki rimay, munahushkaynita mana yanka kichuwananpa. ");
INSERT INTO qupNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Achka kuti rishpanpas chay apuka payta mana kasunayarkachu. Chay warmika mana sampayashpa payta tapushpalla katishpan chay apuka yuyayninllapi nirka: Ñukaka mana manchanichu nima Yaya Diosta, nima runa masinikunata paykunata kasunaynipa. ");
INSERT INTO qupNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Chasna kashpanpas chay warmika yapa killachiwahushkanrayku kunanka kasunayni tiyan. Payta mana yanapashpaynika yapami killachiwanka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Chayta kwintashpan Jesuska rimarka: Chay alichak apuka Yaya Diosta mana manchak kashpanpas rimarka chay warmita yanapananpa. ");
INSERT INTO qupNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kankunaka Yaya Diospa akllashkan runakuna kashpaykichi payta punchapi tutapipas mañashpaykichi chay apumanta ashwanta mana unayashpachu kankunata yanapanka. ");
INSERT INTO qupNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kankunata rimani: Alita mañashpaykichika Yaya Dioska kushikushpa nima unayashpachu kankunata yanapanka. Ñuka Yaya Diospa Kachashkan Runa kutikashka kay allpama shamushpayni ¿tarishanchari kirik runakunata, maykankunami mana sakishpa Yaya Diospi sinchikushpa mañanahun? ");
INSERT INTO qupNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Chaypi shukkuna tiyarka mana alita yuyarikkuna. Paykunaka tukuymanta ashwan ali kanankunata yuyarishpa kawsarkakuna. Paykunata Jesuska shuk yachachinawa kasna yachachirka: ");
INSERT INTO qupNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ishkay runakuna rirkakuna Yaya Diospa wasinpi mañanankunapa. Shukka karka fariseo, shukka karka Roma llaktarayku impuestuta kobrak. ");
INSERT INTO qupNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Chay fariseo shayarishpan pay kikinlla ali kananta yuyarishpa Yaya Diosta mañarka kasna: A Yaya Dios, kanta agradesini, mana runa masinikunashina kahushkaynirayku. Mana kanichu paykunashina shuwaysiki, uchata ruraysiki, shukpa warminwa musayak. Nima kanichu kay impuestuta kobrakshina. ");
INSERT INTO qupNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ñukaka karan semana ishkay punchata kanta kushichishpa mana mikunichu. Chaymantapas karan chunkata ganashkaynimanta shukta kanrayku kuni nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Chay impuestuta kobrakka pinkashpan karullapi shayarirka. Yapa uchasapa kananta yuyarishpan kumurishpa pichunta waktashpa Yaya Diosta mañarka: Yaya Dios, llakichiway. Yapa uchasapa kani. Uchaynikunamanta pichaway nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kankunata rimani: Chay impuestuta kobrakka uchankunamanta llakichirishkana wasinma kutirka. Chay fariseotaka Yaya Dioska manami llakichirkachu. Kankuna kikinmantalla yuyaykichipi atun tukunayashpaykichika Yaya Diosmi kankunata mana alichu kankichi nishpa pinkachinka. Kankuna runa masikichikunamanta mana atun tukunayashpa paykunata yuyashpa yanapashpaykichika Yaya Diosmi kushikushpa kankunata atunyachinka. ");
INSERT INTO qupNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Jesús yachachihushpan yayankunaka llullu wawankunatapas payma aparkakuna, llankashpan paykunarayku Yayan Diosta mañananpa. Chasna rikushpankuna Jesuspa runankunaka piñarishpa paykunata arkarkakuna Jesusta mana kayllayanankunapa, kay wawastukunata Jesusma ama apamuychichu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Chaypi Jesuska yayankunata wawankunanti kayashpan runankunata rimarka: Ama arkaychichu chay wawakunata ñukama apamunankunapa. Wawakunashina ñukapi sinchikuk runakunallami Yaya Diospa kamachishkan tukushpa paypa ali kamachihushkanpi kawsankakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Alita uyawaychi. Maykanmi wawakunashina ñukata yuyawashpa mana kasuwan, chayka manami Yaya Diospa kamachishkan tukushpa paypa ali kamachihushkanpi kawsankachu. ");
INSERT INTO qupNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Chaymanta shuk apu Jesusta tapurka: Ali yachachik, rimaway ¿imashna rurashpaynitaya atipaynima Yaya Dioswa wiñaypa kawsanata? ");
INSERT INTO qupNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesuska aynirka: ¿Imaraykuta rimawanki ali kanaynita? Mana nima shuk runa tiyanchu ali. Yaya Diosllami ali kan. ");
INSERT INTO qupNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kanka ñami yachanki Yaya Diospa kamachishkankunata: Ama shuk warmiwa musayaychu. Ama runa masikita wañuchiychu. Ama shuwaychu. Nima pimanta llullashpa rimaychu. Yayaykita mamaykita yuyashpa kushichishpa kawsay nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Chaypi chay apuka aynirka: Tukuy chay Yaya Diospa kamachishkankunata wawamanta pacha kasushpa kawsashkani. ");
INSERT INTO qupNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Chayta uyashpan Jesuska rimarka: Alitami rurashkanki. Shuk imastullami kasunaykipa pishin. Rantichikriy tukuy imaykikunata. Chay kullkitaka nima imayu runakunata kuy. Chasna rurashpaykimi silupi achka imayushina tukunki. Chasna rurashkaykiwasha shuti katiway. ");
INSERT INTO qupNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Chayta uyashpan chay runaka sinchita llakirirka. Yapa achka kullkiyu kashpan mana munarkachu tukuy imankunata rantichishpa kunata. ");
INSERT INTO qupNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Chasna llakirishkata rikushpan Jesuska rimarka: Maytukuy sinchita kan kullkiyukunaraykuka Yaya Diospa kamachishkankuna tukunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Shuk atun wiwa kamilluka manami atipamachu pasanata shuk aguha uchkustuta. Chasnashinami shuk runaka kullkinllapi yuyarishpanka manami atipankachu Yaya Diospa kamachishkan tukunata. ");
INSERT INTO qupNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Chaypi kahukkunaka chayta uyashpankuna rimarkakuna: Chasna kashpanka ¿pita atipama kishpichiy tukunata Yaya Diospa ali kamachihushkanpi kawsananpa? ");
INSERT INTO qupNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Chaypi Jesuska paykunata rimarka: Nima pi atipanchu kishpichirinata pay kikinta. Yaya Diosllami atipan runakunata kishpichinata paypa ali kamachihushkanpi kawsanankunapa. Payllami atipan tukuyta ruranata yachayninwa. ");
INSERT INTO qupNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Chaypi Pedroka Jesusta rimarka: Ñukanchika sakishkanchimi tukuy imanchikunata kanta katinanchipa. ");
INSERT INTO qupNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Chaypi Jesuska runankunata rimarka: Alita uyawaychi. Shuk runa Yaya Diospa kamachishkan tukushkanrayku wasinta, warminta, wawkinkunata, yayankunata, wawankunata sakishpanka kay allpapi kawsahushpanra Yaya Diosmi tukuy ima sakishkanmanta ashwanta kunka. Chaymanta chay chapahushkanchi mushu mundupi wiñaypa Yaya Dioswa kawsankana. ");
INSERT INTO qupNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesuska chay chunka ishkay runankunata chaynikstuma pushashpan rimarka: Ñami yachankichi Jerusalén llaktama rihushkanchita. Chaypimi paktarinka, maykantami Yaya Diospa yachayninwa yachachikkunaka ñawpa killkarkakuna ñuka Yaya Diospa Kachashkan Runamanta. ");
INSERT INTO qupNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Chikniwak runakunaka apiwankakuna romano runakunata kuwanankunapa. Paykuna asichiwankakuna, pukllachishpa parisichiwankakuna, asishpa tyukawankakuna, sinchita asutiwankakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Asutiwashkankunawasha wañuchiwankakuna. Chasna wañuchiwashpankunapas kimsa punchamantami kawsarimusha. ");
INSERT INTO qupNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Chasna nishkanta runankunaka mana asirtarkakunachu. Paykunarayku mana asirtaypa shimikuna karkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesuska Jerikó llaktata kayllayahushpan shuk wisku runa ñampi mayanpi tiyahukta rikurka. Payka runakuna pasahukkunata kullkita tapuhurka. ");
INSERT INTO qupNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Achka runakuna pasahukkunata uyashpan chay wiskuka tapurka: ¿Imaraykutaya chay tukuy pasahunkichi? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Shukkunaka rimarkakuna: Nasaretmanta Jesusmi pasahun. ");
INSERT INTO qupNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Chayta uyashpan chay wiskuka sinchita kaparishpa rimarka: ¡Jesús, Davidpa Miraymanta Kishpichik, llakichiway! ");
INSERT INTO qupNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Chaypi chay Jesuspa puntanpi rihuk runakunaka arkashpa chunllayay nirkakuna. Chasna rimashpankunapas payka ashwan sinchita kaparirka: ¡Davidpa Miraymanta Kishpichik, llakichiway! ");
INSERT INTO qupNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Chasna kaparishkanta uyashpan Jesuska shayarishpan rimarka: Chay wiskuta ñukama apamuychi. Ña kuchunpi kashpan payta tapurka: ");
INSERT INTO qupNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","¿Imatata munanki kanrayku ruranaynipa? Chay wiskuka aynirka: Yaya Jesús, ñawinita ampipay rikunaynipa. ");
INSERT INTO qupNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesuska aynirka: Ari, kunallami rikunki. Ñukapi sinchikushpaykimi ampirishkanki. ");
INSERT INTO qupNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Chasna rimashkanllawa chay wiskuka atiparkana rikunata. Ampirishkanrayku Yaya Diosta atunyachishpa kushichishpa Jesusta katirka. Chayta rikushpankuna tukuy runakunapas Yaya Diosta atunyachishpa kushichirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ña Jerikopi yaykushpan Jesuska chay llakta chawpita rihurka. ");
INSERT INTO qupNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Chaypi kawsahurka shuk yapa kullkiyu runa Sakeo shutiyu. Payka impuestuta kobrakkunapa apun karka. ");
INSERT INTO qupNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Chay runaka yapa munarka Jesusta riksinata. Chay llaktata pasahushkanta yachashpan munarka kayllayanata. Chasna munashpanpas uchillastu kashpan mana atiparkachu rikunata, yapa achka runakuna kahushkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Chasna kashpan Jesuspa rinan ñampita kallpashpa ñawparka runakunapa puntanma. Chaypi shuk kaspipi sikarka, Jesús pasahushkanta atipananpa rikunata. ");
INSERT INTO qupNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesús chayta pasahushpan awama rikuhushpan Sakeota rimarka: Sakeo, utkalla uraykuy. Kunan puncha wasikipi kiparinayni tiyan. ");
INSERT INTO qupNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Chaypi Sakeoka utkalla uraykumurka. Kushikushpa Jesusta wasinpi yaykuchirka. ");
INSERT INTO qupNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Chayta rikushpankuna runakunaka Jesusta washanchashpa paykunapura rimarkakuna: ¿Imashnata Jesuska yaykun chasna uchata ruraysikipa wasinpi? ");
INSERT INTO qupNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Chasna rimashpankuna Sakeoka shayarishpan Jesusta rimarka: Yachachik, rikuy, tukuy imayni tiyawashkakunamanta chawpita nima imayukunata kusha. Maykankunamantami ñawpa llullachishpa kullkita tapushkani, chaykunataka kutichishami chusku kuti ashwanta. ");
INSERT INTO qupNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesuska payta aynirka: Kunan puncha shuti kankuna kay wasipi kawsak runakuna kishpichirishka kankichi nishpa. Chaymanta chaypi kahukkunata rimarka: Kay runa mana alita rurak kashpanpas ñukanchishina Abrahampa miraymantami kan. ");
INSERT INTO qupNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ñuka Yaya Diospa Kachashkan Runa shamushkani chasna mana ali rurashkankunawa chinkarishkashina kahukkunata maskanaynipa, uchayukunata nina mana wañukma rina kahushkankunamanta kishpichinaynipa. ");
INSERT INTO qupNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jesuska Sakeopa wasinpi kashpan ña kahurka kamachikkuna kawsashkan Jerusalén llakta kuchupi. Runakunaka rimashkanta uyahushpankuna yuyarirkakuna: Ñami rihun Jerusalenma kamachik tukunanpa. Yaya Diospa ali kamachinan kay allpapi ñami kallarihun nishpa. Pantachishpa yuyarishkankunata riksishpan Jesuska paykunata shuk yachachinawa pay kikinmanta yachachirka: ");
INSERT INTO qupNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Tiyarka shuk runa apupa ayllun. Payka rirka karu allpama chaypi kawsak atun apu payta aputa rurananpa, chasna apu tukushpan kikin allpanpi kamachinanpa nishpa. Runankunata rimarka apu tukushkanwasha kutimunanta. ");
INSERT INTO qupNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Manara llukshishpan chunka paypa runankunata kayashpan karan shuk runanta chay tupullata yapa valik kullkita kuhushpan rimarka: Kay kullkiwa rantishpa rantichishpa mirachipanki shamunaynikama. Chasna karan runanta rimashpan chay apu tukunapa rihukka rirka. ");
INSERT INTO qupNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Chay allpapi llaktakunamanta runa masinkunaka payta chiknishpankuna paypa washanta shuk runakunata kacharkakuna chay atun aputa rimak rinankunapa: Mana munanchichu chay runaka apunchi tukunanpa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Mana munashpankunatata payka apunkuna tukurka. Chaymanta llaktanma kutirka. Paktashpan shuk runanta kacharka, pushak rinanpa maykankunatami kullkinta kushpa sakirka. Yachanayarka maytukuytami karan shuk runan mirachishka chay kullkimanta. ");
INSERT INTO qupNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Puntiru runanka paktashpan rimarka: Patroyni, kullkikita mirachishkani chunka kuti ashwanta kanrayku. ");
INSERT INTO qupNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Chaypina chay patronka aynirka: Alita rurashkanki, ali runayni kanki. Kay uchillastu kushkayniwa sumakta tarawashkaykirayku churashkayki chunka llaktakunata kamachipanaykipa. ");
INSERT INTO qupNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Shuk runanpas rimak shamurka: Patroyni, kullkikita mirachishkani pichka kuti ashwanta kanrayku. ");
INSERT INTO qupNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Paytapas aynirka: Kanka kamachipanki pichka llaktakunata. ");
INSERT INTO qupNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Chaymanta shukna rimak shamurka: Patroyni, kaykaya kullkikika. Sumakta llachapawa wankushpayni wakaychashkani kanrayku. ");
INSERT INTO qupNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Yapa kanta manchashpayni kay kullkita mana llankashkanichu. Shukkuna tarawashkanmanta kanka yanka kullkita apinki. Shukkuna tarpushkankunamanta kanka pallanki. ");
INSERT INTO qupNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Chaypina chay apuka rimarka: Kanka millaypa yuyayyu runa kanki. Kan kikin rimashkaykimanta kastigarinki. Ñuka sinchi kamachik kanaynita, shukkunapa tarawashkanmanta kullkita apinaynita, shukkunapa tarpushkankunamanta pallanaynita yuyarinki. ");
INSERT INTO qupNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Chasna kashpanka ¿imaraykuta kullkinita mana churashkankichu kullkita mirachina wasipi, chaypi mirananpa? Chaypi churankima karka uchillastullapas mirashkawa pakta apinima karka. ");
INSERT INTO qupNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Chaymanta chaypi kahukkunata rimarka: Payta kichuychi chay kushkayni kullkita. Chay chunka kuti mirachik runata kuychi. ");
INSERT INTO qupNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Paykunaka aynirkakuna: Patrón, payka ña achka kullkita apishka. ");
INSERT INTO qupNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Chay apuka aynirka: Kankunata rimani, maykanmi alita rurak runayni kan, paytaka kunimi ashwanta. Killaysiki runaka uchillastu tiyapushpanpas kichuy tukunkami. ");
INSERT INTO qupNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kunanka chay kuntraynikunata pushak ripaychi. Mana munashkankunarayku ñuka apu tukunaynita kay puntaynipi apamushpa wañuchiychi. ");
INSERT INTO qupNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Chasna nishpa yachachishkanwasha Jesuska Jerusalenma rirka. ");
INSERT INTO qupNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","30","Jerusalenma rihushkanpi Jesuska paktarka Betfagé llakta, Betania llakta kuchupi. Chay llaktakunaka shuk urku Olivos shutiyu kuchupi karkakuna. Ña paktahushpan chay Olivos urku mayanpi, Jesuska ishkay runankunata nirka: Riychi chay rikuhushkaykichi llaktama. Chaypi paktashpaykichi tarinkichimi shuk malta burru watarishkata, maykanpimi nima shuk runa purishkarachu. Chay malta burruta paskashpaykichi apamuychi. ");
INSERT INTO qupNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Shuk runa kankunata mitsashpa tapushpanka ¿imaraykutaya paskahunkichi? nishpa, payta kasna rimaychi: Yayanchi Jesusmi munahun awanpi tiyarishpa rinanpa. Kunanllatatami kutichik shamushu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Chasna Jesús nishpan chay ishkay runankunaka rirkakuna. Paypa rimashkantashina tarik rirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ña chay malta burruta paskahushpankuna amunkunaka tapurkakuna: ¿Imaraykuta paskahunkichi chay burruta? ");
INSERT INTO qupNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Paykunaka aynirkakuna: Yaya Jesusmi munahun. ");
INSERT INTO qupNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Chaymanta Jesusma apashpa rirkakuna. Chaypi paktashpankuna churarinankunata burrupa awanpi mantashpankuna Jesusta tiyachirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Chasna Jesús rihushpan puntanpi runakunaka churarinankunata ñampipi mantarkakuna, imashnami rurapayanahun shuk atun aputa kushilla yaykuchinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ña Jerusalenta kayllayahushpankuna Olivos urkuta uraykuhushpankuna Jesusta chay achka katihuk runakunaka yapa kushikushpankuna kaparishpa Yaya Diosta agradesirkakuna: ¡Yaya Dios, kay Jesús atun yachaykita rikuchishpa tukuy ali rurashkanta rikushkanchi! ");
INSERT INTO qupNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Payka kanpa yanapashkayki ali runami kan. Kanpa munashkaykita rurananpa kachashkayki atun apunchi kashpanmi shamuhun. Ñami tukuyta alichashkanki kushilla paywa kawsananchipana. Kanta kushichinchi awa silupi kawsak Yaya Dios. ");
INSERT INTO qupNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Chaypi shuk fariseokuna chay runakunapa chawpinkunapi kahukkuna rimarkakuna: Yachachik, rimay kay kanta katik runakunata chunllayanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Chaypi Jesuska aynirka: Kankunata rimani, kaykuna chunllayashpankunaka rumikunanami kaparinkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","42","Jesús Jerusalén kuchupi paktashpan llaktata rikushpan wakarka. Chay llaktapi kawsakkunarayku wakashpa rimarka: Imashna alishi kama karka, kay punchallapas asirtankichima ñuka Yaya Dioswa alichashka kushilla kawsayta kuk kanaynita kushillana kawsanaykichipa. Kunankama mana munashpaykichi asirtanata, Yaya Dios kankunamanta kichushka asirtana yuyayta manana asirtanaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","44","Mana munashpaykichi asirtanata Yaya Dios kachawashkanta kankunata kishpichinaynipa, kunanmanta pacha achkata parisinaykichi tiyan. Parisina punchakuna paktarishpankuna kuntraykichikunaka llaktaykichi muyukta allpata lumayachinkakuna chaypi pakashpa wañunakushpa kankunata winsinankunapa. Tukuy kankunata winsishpa wañuchinkakuna. Tukuy wasikichikunatapas waklichishpa urmachinkakuna. Nima shuk rumi awapura rurarishkaka kiparinkachu. ");
INSERT INTO qupNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jerusalenpi paktashpan Jesuska Yaya Diospa wasinpi yaykurka. Chay wasipi puntiru atun pampa kincharishkapi achka rantichik runakuna karkakuna. Chayta rikushpan Jesuska piñarishpan llamputa llukshichirka. ");
INSERT INTO qupNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Llukshichihushpan paykunata rimarka: Yaya Dioska killkachishkanpi riman: Kay wasinika ñukata mañanankuna wasinimi kan nishpa. Kankunaka kay Yaya Diospa wasinta shuwakunapa kushilla tantarinata rurashkankichi. Chasna Jesuska rimashpan paykuna chaypi achkata kobrashpa rantichihushkankunarayku shuwakunashina kanankunata yuyachirka. ");
INSERT INTO qupNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Chaymanta pacha tukuy punchakuna Jesuska Yaya Diospa wasinpi yachachipayan. Achka runakuna payta uyashpankuna saserdotekunapa apunkuna, Moisespa killkashkanta yachachikkunapas, chay llaktapa apunkunapas maskarkakuna, imashna rurashpami payta wañuchinkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Chasna yuyarishpankunatata mana atiparkakunachu payta wañuchinata, tukuy uras achka runakuna paypa yachachihushkanta yapa uyanayashpa chayllapi kahushkankunarayku. ");
INSERT INTO qupNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","2","Shuk puncha Jesuska Yaya Diospa wasinpi runakunata yachachirka Yaya Dios runakunata kishpichinanmanta. Chaypi saserdotekunapa apunkuna, Moisespa killkashkanta yachachikkunapas, paykunata kamachik israel masin rukukunapas tapuk shamurkakuna: Ñukanchita rimay ¿pita kanta kamachishka tukuy chay rurashkaykikunata ruranaykipa? ¿Pita kanta kamachishka kasna yachachinaykipa? ");
INSERT INTO qupNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Chaypina Jesuska aynirka: Ñukapas shuk imata tapushkaykichi. Ayniwaychi. ");
INSERT INTO qupNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Pita Juanta kamachirka bawtisananpa? ¿Yaya Dioschu runakunachu? ");
INSERT INTO qupNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Chaypi paykunapura tapunakurkakuna: Yaya Diosmi Juanta kacharka nishpanchika Jesuska ñukanchita rimankami: Yaya Dios payta kachashka kashpanka ¿imaraykutaya payta mana kasushkankichichu? ");
INSERT INTO qupNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Aynishpanchika runakuna rimashpankuna Juanka yachachirka nishpa, tukuy runakuna piñarishpankuna ñukanchita rumiwa tuksishpa wañuchinkakuna. Paykunaka kirinahun chay Juan wañuka Yaya Diospa yachayninwa yachachik kashkanta. ");
INSERT INTO qupNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Chasna tapunakushpankuna Jesusta aynirkakuna: Mana yachanchichu pimi Juanta kacharka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Chaypina Jesuska aynirka: Chasna kashpanka ñukapas mana rimashkaykichichu pimi kamachiwashka tukuy kaykunata ruranaynipa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Chaymanta Jesuska tukuy chay runakunata shuk yachachinawa yachachirka kasna: Tiyarka shuk chakrayu runa. Chay runaka chakranpi achka uva wiñarishkakunata tarpuchirka. Chaymanta chakranta shuk tarawak runakunata kurka amunshina pichashpa kuyranankunapa. Chasna kushpan rimarka: Kay uva chakraynita pichashpa kuyrapankichi shamunaynikama. Pallashpaykichi tukuy muyunkunamanta chawpita kuwankichi. Chasna rimashpan chay amunka rirka shuk karu llaktama, chaypi unayta kawsananpa. ");
INSERT INTO qupNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ña chay uvakunata pallana uras paktarishpan chay amunka shuk runanta kacharka chay chakranpi tarawahukkunata rimak rinanpa: Patronchimi kachawashka uva muyukunata pallashkaykichimanta chawpita kuwanaykichipa payrayku apanaynipa nishpa. Chay runanka uva muyuta apanapa rishpan mana kurkakunachu payta nima shukta. Makashpankunalla chay runata kacharkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Chaymanta chay patronka shuk runantana kacharka uva muyukunata tapuk rinanpa. Paytapas makashpankuna millaypata rimashpa pinkachishpankuna shinallata kacharkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kimsaynin runantana kacharka. Paytapas chasnallatata mana alitachu rurarkakuna. Makashpankuna aychan liki likita kacharkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Chaymantana chakra amuka yuyarirka ¿imashnashi ruraynima? nishpa. Kachashara shuklla munashkayni wawaynita. Payta rikushpankunachari manchashpankuna kasunkakuna nishpa. Chaymanta wawantana kacharka. ");
INSERT INTO qupNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Payta rikushpankuna chay tarawak runakunaka kwintarkakuna paykunapura: Payka kay chakra amupa wawanmi. Yayan wañushpan kay chakraka payraykunami kiparinka. Akuychi kunalla wañuchishunchi, tukuy kay uva chakraka ñukanchipana kananpa. ");
INSERT INTO qupNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Chaypina chay chakramanta llukshichishpankuna payta wañuchirkakuna. Chasna kwintashkanwasha Jesuska tapurka: ¿Imanachimashi chay chakra amuka chay wañuchik runakunata? ");
INSERT INTO qupNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Chay uva chakranma rishpan chay tarawakkunataka wañuchinkami. Chaywasha chay chakrantaka kunkami shuk runakunatana nishpa. Yachachishkanta uyashpankuna rimarkakuna: Yaya Dioska ama chasna rurachun ñukanchiwa. ");
INSERT INTO qupNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesuska paykunata rikushpan pay kikin rumishina kananta yuyarishpan rimarka: ¿Ima ninayantaya kasna Yaya Diospa ñawpa killkachishkanka? Shuk runa wasinta rumimanta rurashpan tarawak runankunaka shuk ali sinchi rumita mana munashpankuna mayanpi churarkakuna mana alichu nishpankuna. Chay rumitaka wasinta rurak runaka akllashpan chay wasinpi churarka shuk orkonshina sinchikuchik kananpa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Chay akllashkan rumipi takakta tukushpaykika tulluyki pakiktami urmanki. Chay atun rumi awaykipi urmashpanka machuyakta nitishpa pulbu wañunki. ");
INSERT INTO qupNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Chasna Jesús yachachishpan chay saserdotekunapa apunkuna, Moisespa killkashkanta yachachikkunapas alita asirtarkakuna, paykuna amunta mana kasunayakkunashina kanankunata uyachishkanta, chaymantapas chay ali rumita wichukkunashina chay rumipi takarikkunashina kanankunata uyachishkanta. Chayrayku yapa piñarishpankuna Jesusta chay ratulla apinayarkakuna wañuchichinankunapa. Chasna ruranayashpankunapas Jesusta mana apirkakunachu runakunata manchashkankunarayku. Pakta wañuchiy tukunchima nishpa yuyarirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Jesusta yapa romano aputa apichichinata munashpankuna chay payta chiknik runakunaka chaymanta pacha maskarkakuna, imamantami payta apinkakuna nishpa. Chasna kashpan shuk runakunata Jesusma kacharkakuna, alishina tukushpa payta llullachishpa pantachichinankunapa. Chasna rurashpa munarkakuna romano aputa Jesusmanta millaypata rimak rinata. ");
INSERT INTO qupNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Chay llullachik runakunaka Jesuspi paktashpankuna alishina tukushpa payta rimarkakuna: Yachachik, yachanchi tukuy uras runakunata rimanaykika yachachinaykika shutipa kananta, mana manchashpa nima pita. Alita yachachinki runakunata Yaya Diospa munashkanta rurashpa kawsanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ñukanchita rimay ¿alichu manachu ñukanchi israel runakunaka chay romano tukuymanta atun aputa impuestuta pagananchipa? ¿Yaya Dioska munanchu pagananchipa manachu? ");
INSERT INTO qupNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesuska yacharka mana ali yuyarishkankunata. Ari, pagananchi tiyan nishpa aynimaka, israel apukunata rimak rinahuma payta kastiganankunapa. Mana alichu pagananchipa nishpa aynimaka, romano aputa rimak rinahuma payta kastigananpa. ");
INSERT INTO qupNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Chasna kashpan paykunata rimarka: Rikuchiwaychi shuk kullkita. Chaymanta shuk kullkita apishpan tapurka: ¿Pipa almantata rikunkichi kay kullkipi? ¿Pipa shutinta kay kullkipi killkarishka kan? Paykunaka aynirkakuna: Romano tukuymanta atun apupami. ");
INSERT INTO qupNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Chasna aynishpankuna Jesuska paykunata rimarka: Chay atun apupa kashkantaka kuychi amunta. Maykanmi Yaya Diospa kan, kuychi payta. Yaya Dios ñukanchikunata rurashkanrayku ñukanchikunapa amunchi kan. Chayrayku tukuy shunkuykichimanta pacha payta yuyashpa kawsaychi. ");
INSERT INTO qupNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Chasna chay llullachik runakuna mana atiparkakunachu Jesusta pantachichinata nima shuk shimita, runakuna chawpipi rimashpan. Yapa yachayninwa aynishkanta uyashpankuna mancharishpankuna chunlla uyarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Chaymanta shuk saduseokuna Jesusta kayllayarkakuna. Paykunaka kirinahun wañushkakuna manana kawsarinkakunachu nishpa. Chayrayku Jesusta rimarkakuna: ");
INSERT INTO qupNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Yachachik, ñawpa Moisés wañuka ñukanchirayku killkarka: Shuk warmiyu runa manara wawayu wañushpanka wawkinna chay kachuynin mashintuta warmiyanan tiyan chay warmita wawayachinanpa wawkinranti. Chaymanta chay warmin kari wawata wawayashpanka chay wawkin wañupa wawanshina kanan tiyan nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kunan kanta kwintanayanchi: Tiyarka kanchis wawkikuna. Shuk puncha puntiru wawkika warmiyarka. Mana nima shuk wawayu kashpanra wañurka. ");
INSERT INTO qupNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Chaymanta Moisespa killkashkan kamachishkata kasushpan ishkaynin wawkina kachuynin mashintuta warmiyarka. Chay wawkipas chasnallatata wañurka. ");
INSERT INTO qupNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Chaymanta kimsaynin wawkina chay kachuynin mashintuta warmiyarka. Paypas wañurka. Chasnallatata shukllankama shukllankama chay kanchis wawkikuna chay warmillatata warmiyashpankuna karan shuk mana wawayuchu wañurka. ");
INSERT INTO qupNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Chaymanta chay warmipas wañurkana. ");
INSERT INTO qupNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kunanka rimay ñukanchita. Chay kanchis wawkikuna chay warmillatata warmiyarkakuna. Wañushkakuna kawsarimushpankuna chay kanchis wawkikunamanta ¿maykanpa warminshi kama? ");
INSERT INTO qupNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Chaypi Jesuska aynirka: Kay allpallapimi karikunaka warmiyanahun, warmikunapas kusayanahun. ");
INSERT INTO qupNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Maykankunami Yaya Diospa rikushkanpi ali kanahun wañushkankunamanta kawsarinankunapa paypa ruranan mushu mundupi yaykunankunapa, paykunaka mana warmiyankakunanachu, warmikunapas mana kusayankakunanachu. ");
INSERT INTO qupNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Chaypika manami nima pi wañunkanachu. Chayrayku manana warmiyashpa kawsankakunachu miranankunapa. Paykunaka kankakunami angelkunashina mana wañukkuna. Yaya Diospa wawankunami kankakuna wañushkankunamanta kawsarimushkankunarayku. ");
INSERT INTO qupNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Runakuna wañushkankunamanta kuti kawsarinankunata Moisés wañupas yachachirka. Chay uchilla kaspi sintihukmanta Yaya Dios payta kasna rimashkanta killkarkan: Ñuka kani Yaya Dios, maykantami Abraham, Isaak, Jakob kushichinahun nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yaya Dios chasna rimashkanrayku yachanchi chay yaya rukukuna wañushpankunapas paywa pakta kawsa kahushkankunata. Kawsakunallami Yaya Diosta kushichinahun, wañushkakunaka payta mana kushichinahunchu. Yaya Diosraykuka tukuy paykuna wañushpankunapas kawsallami kanahun. ");
INSERT INTO qupNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Chasna aynishkanta uyashpankuna Moisespa killkashkanta shuk yachachikkunaka Jesusta nirkakuna: Sumakta rimashkanki. Suma yachachik kanki. ");
INSERT INTO qupNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Chaymanta pacha chay Jesusta pantachichinayak saduseokuna manana munarkakunachu tapunata ashwanta. ");
INSERT INTO qupNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Chaymanta Jesuska chay yachachik runakunata tapurka: ¿Imashna yuyarishpaykichitaya yachachinkichi Yaya Diospa Kachanan Kishpichikka atun apu David wañupa miraymanta kanka nishpa? ");
INSERT INTO qupNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","David kikin chay Kishpichikmanta rimashpan killkarka chay killka Salmospi: Yaya Dioska chay kamachiwakta rimarka: Tiyariy kuskayni parti kamachinaykipa ñukawa pakta, tukuy kanta chiknik runakunata winsinaynikama kanta kasunankunapana nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David Yaya Diospa Kachanan Kishpichikta kamachiwak nirka. Chay uras ña kawsa paymanta pasa kashpan David unay wañushkanwasha paypa miraymantallatata kashpan manami atipanchu runalla kanata. ");
INSERT INTO qupNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Chasna tapushpan Jesuska tukuy chaypi kahuk runakunapa uyahushkankunapi runankunata rimarka: ");
INSERT INTO qupNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Ama kankunaka chay Moisespa killkashkanta yachachikkunamanta llullachirishka kaychichu. Paykunaka yapa munanahun tukuy runakuna paykunata aputashina saludanankunapa. Chayrayku suma suni churarishkankunawa purinahun runakuna ñampikunapi plasakunapi saludanankunapa. Tantarina wasikunapi, fiestakunapipas tukuymanta suma tiyarinakunapi tiyarinahun, runa masinkuna paykunata aputashina rikuhushkankunata rikuchishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Paykuna kikinrayku mana pinkashpa mashintukunata tukuy imankunata llullachishpa tapunahun, Yaya Diosta kushichinaykichipa kunaykichi tiyan nishpankuna. Mana ali rurak kashkankunata pakanankunapa, tantarina wasikunapi ali rurak runakunashina Yaya Diosta unayta mañanahun. Chasna kashpankuna Yaya Dioska paykunataka tukuy runakunamanta ashwan sinchitami kastiganka. ");
INSERT INTO qupNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesuska Yaya Diospa wasinpi runankunata chasna rimahushpan rikurka yapa kullkiyu runakuna kullkinkunamanta Yaya Diosta kushpa kahapi churahushkankunata. ");
INSERT INTO qupNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Chaymantapas rikurka shuk mashintu nima imayu ishkay kullkinstuta churahushkanta. ");
INSERT INTO qupNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Chaypi rimarka: Rikuychi. Kay mashintu nima imayuka chay ishkay kullkinstuta churahushpan Yaya Diospa rikushkanpi tukuy chay achka kullkiyu runakunamanta ashwantami kushka. ");
INSERT INTO qupNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tukuy paykunaka achka kullkinkunamanta puchurishkata kushkakuna. Kay mashintuka tukuy tiyapushkanta Yaya Diosta kushka, maykanwami mikunanta rantinan karka. Chayrayku payka Yaya Diosta ashwanta kushichishka. ");
INSERT INTO qupNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Chaypi shukkunaka rimahurkakuna Yaya Diospa wasinmanta: Suma rumikunawa, Yaya Diosta kushkakunawa yapa suma rurarishka rikurin nishpa. Chaypi Jesuska rimarka: ");
INSERT INTO qupNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Tukuy kay rikuhushkaykichika shuk punchami urmachiy tukunka. Nima shuk wasi, nima shuk rumi awapura rurarishkaka kiparinkachu. ");
INSERT INTO qupNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Chaypi runankunaka Jesusta tapurkakuna: Yachachik ¿ima urastaya Yaya Diospa wasinta urmachinkakuna? ¿Imata rikushpanchita yachanchima chay puncha paktarihushkata? ");
INSERT INTO qupNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesuska aynirka: Alita yuyariychi nima pi kankunata llullachinanpa. Achka runakunami yanka nishpa rimak shamunkakuna: Ñukami kani Yaya Diospa Kachashkan Kishpichik nishpa. Shukkunaka rimankakuna: Ñami paktarihun Yaya Diospa Kachashkan Kishpichik kutimunan punchaka nishpa. Chasna rimashpankunapas ama paykunata kiriychichu. ");
INSERT INTO qupNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Uyashpaykichika runakuna chikninakushpankuna wañunakushpa kawsahukkunata, ama mancharinkichichu. Tukuy chaykunami puntiru pasanan tiyan. Runakuna wañunakushpa kawsahushpankunapas chay uras kay allpaka manarami tukurinkarachu. ");
INSERT INTO qupNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jesuska yachachishpalla katirka: Shuk shimita rimakkuna shuk shimita rimakkunawa chikninakushpankuna wañunakunkakuna. Shuk allpapi kawsak runakunaka shuk allpapi kawsak runakunawa sinchita chikninakushpankuna wañunakunkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tiyankami sinchi allpa kuyuykuna. Tukuy partimi sinchi yarkay tiyanka, chaymantapas achka utkalla shukma shukma chimpak sinchi unkuykuna. Silupi manchaypata nima ima uras rikushkankunata rikunkakuna runakunaka. ");
INSERT INTO qupNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Manara chaykuna tiyashpan kankunata chiknishpa parisichinkakuna, apinkakuna karselpi churachinankunapa. Chiknik runakuna kankunata uchachishpa tantarina wasikunama pushankakuna. Chaymanta karselpi churachinkakuna. Ñukata katiwahushkaykichirayku kankunata apishpa atun apukunama pushankakuna kastigachinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Chasna ruray tukuhushpaykichi achka uyahushkankunapi atipankichi ñukamanta rimanata. ");
INSERT INTO qupNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Tukuy chayta uyashpaykichi ama yuyarishpa kaychichu imatashi aynisha nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Chay urasmi kushkaykichi yachayta alita ayninaykichipa. Nima maykan kuntraykichi atipankachu kankunata ayninata. ");
INSERT INTO qupNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Chay uraska kankunata yapa chikninkakuna. Yayaykichi, wawkikichipas, shuk aylluykichipas, amiguykichipas apukunama pushankakuna kankunamanta llullashpa rimanankunapa. Chasna rurashpankuna apukunaka kankunamanta shukkunata wañuchinkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tukuy runakuna kankunata chikninkakuna ñukata katiwahushkaykichirayku. ");
INSERT INTO qupNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Chasna kashpanpas Yaya Dios kankunata alita kuyrashpan manami atipankakunachu paymanta anchuchishpa chinkachinata. ");
INSERT INTO qupNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Imatapas kankunata rurashpankuna mana sakishpa ñukapi sinchikuychilla. Chasna shuti kishpishpa Yaya Dioswa wiñaypa kawsak rinkichi. ");
INSERT INTO qupNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Jesuska yachachishpalla katirka: Kay Jerusalén llakta muyukta achka suntalukunata rikushpaykichi yachankichi ña urmachinalla kahukkunata. ");
INSERT INTO qupNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","22","Chay punchakunaka Yaya Diospa sinchi kastiganan punchakunami. Chay urasmi Yaya Dioska tukuy killkachishkan shiminkunata paktachinka. Chay punchakunapi kankuna Judea allpapi kawsakkuna urkukunama utkalla mitikuychi. Kankuna Jerusalén llaktapi kahukkunaka chaymantalla mitikuychi. Chakraykichipi kahushpaykichika manana Jerusalenma kutiychinachu. ");
INSERT INTO qupNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Chasna mitikuna punchakunapi yapa llakiypa kanka chay chichu warmikunarayku, chay llullu wawayu warmikunaraykupas. Tukuy kay israel allpapi kawsak runakuna yapakta parisinkakuna. Yaya Dios paykunata yapa piñaywami kastiganka. ");
INSERT INTO qupNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Wañunakuhushkankunapi shukkunaka sabliwa wañuchiy tukunkakuna, shukkunataka apishpankuna pushankakuna tukuy allpapi chikan chikan runakuna chawpipi kawsanankunapa. Mana israel runakuna kay Jerusalenta urmachishpankuna amuyankakuna Yaya Diospa rimashkan puncha paktarinankama. ");
INSERT INTO qupNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jesús runankunata yachachishpalla katirka: Kutimunayni puncha kuchuyahushpan intipi, killapi, istrillakunapi manchaypami rikurinka. Chaymanta kay allpapi atun yaku mar atunta ulasyashpan manchaypa uyarinka. Tukuy kay allpapi kawsak runakuna yapa mancharinkakuna, imashi tukuhunchi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Chay uras tukuy silupi punchayachikkuna sinchita kuyurinkakuna. Chay manchaypa pasahukta rikushpankuna runakuna lismayankakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Chasna tukushpankuna ñuka Yaya Diospa Kachashkan Runa puyu chawpipi suma chuyahlla Yaya Diospa atun yachayninwa shamuhushkaynita rikunkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Chasna manchaypa punchakuna paktarishpankuna kankunata kishpichinayni punchaka utkallami paktarinka. Chayta yachashpaykichi chay punchakunapi manana manchashpa sumakta kushikushpa chapawaychi. ");
INSERT INTO qupNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Chasna nishpan shuk yachachinawa yachachishpalla katirka: Shuk igu kaspita, chaymanta shuk kaspikunatapas rikushpa yachakuychi. ");
INSERT INTO qupNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Achkata mushumanta pankayahushkankunata rikushpaykichika yachankichi veranoka ña kuchuyahushkanta. ");
INSERT INTO qupNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Chasnashinami tukuy kay rimashkayni paktarihukta rikushpaykichi yachankichi Yaya Dios mushu munduta rurashpan chaypi ali kamachinanka ña paktarihushkanta. ");
INSERT INTO qupNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Alita uyawaychi. Kay punchakunapi kawsak runakunaka manara wañushpankuna tukuy kay rimashkaynika paktarinan tiyan. ");
INSERT INTO qupNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kay siluka, kay allpapas chinkarinkakunami. Tukuy rimashkayni shimikunamantaka nima shuk chinkarinkachu. Tukuy paktarinan tiyan. ");
INSERT INTO qupNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Tukuy kay rimashkaynita uyashpaykichi alita kuyrariychi, shamushpayni alicharishka kanaykichipa. Chay puncha mana yuyarishkaykichipi kunkaymanta paktanka. Chasna kashpan ama kawsaychichu aychaykichi munashkanllata maskashpa. Chasna kawsashpaykichika kankichimi imashnami shuk animalka kunkaymanta shuk tukllapi urman. Ama kawsaychichu machashpa, tukuy munashkaykichillata yuyarishpa. Chasna kawsashpaykichika shamunayni puncha kankunarayku wañuyka kanka, imashnami tukuy kay allpapi kawsakkunaraykupas paktamunka. ");
INSERT INTO qupNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mana chasna tukunaykichipa tukuy uras Yaya Diosta mañashpa yuyaywa kawsaychi, alita payta kasushpa. Chasna kawsashpaykichika tukuy chay pasana kahushkanpi mana sakiwashpa sinchikunkichi. Chasna sinchikushpaykichika tukuy chaykunamanta kishpishka kankichi. Ñuka Yaya Diospa kachashkan runapa puntanpi mana manchashpa shayarinkichi. ");
INSERT INTO qupNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Karan puncha Jesuska Yaya Diospa wasinpi yachachipayan. Tutapi Olivos shutiyu lumama ripayan chaypi puñunanpa. ");
INSERT INTO qupNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Karan puncha achka runakuna tutamantastulla Yaya Diospa wasinma ripayanahun payta uyanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ña Paskua punchakuna kallarinanpa masna punchallana pishihurka. Karan wata israel runakunaka chay Paskua punchakunarayku tantaripayanahun. Chay punchakuna yuyaripayanahun Yaya Dios paykunata Egipto allpamanta kishpichishkanta, mikupayanahun pan mana punkichirishkata. ");
INSERT INTO qupNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Chay punchakuna ña paktarihushpan saserdotekunapa apunkuna, Moisespa killkashkanta yachachikkunapas maskarkakuna, imashna rurashpashi apinchima Jesusta wañuchinanchipa nishpa. Achka runakuna payta katihushkankunata rikushpankuna mancharkakuna pakta ñukanchita wañuchinahuma nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Chaypi supayka Judas Iskariotepa shunkunpi yaykurka. Chay Judaska Jesuspa chunka ishkay runankunamanta shuk karka. ");
INSERT INTO qupNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Payka saserdotekunapa apunkunama, Yaya Diospa wasinta kuyrakkunamapas rirka, paykunawa kwintananpa imashna rurashpami Jesusta apichichinka. ");
INSERT INTO qupNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Chasna kwintak rishpan paykunaka kushikurkakuna. Shuk yuyayllawa kashpankuna rimarkakuna: Kanta kullkita kushunchi Jesusta apinanchipa yanapahushkaykirayku. ");
INSERT INTO qupNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Chaypi Judaska arí nirka. Chaymanta maskarka imashnami Jesusta mana runakunapa rikushkanpi apichichinka. ");
INSERT INTO qupNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ña chay puntiru Paskua punchaka paktarishpan mikupayanahun pan mana punkichirishkata. Chaymantapas chay punchaka wañuchipayanahun obeha maltata mikunankunapa, imashnami ñawpamanta pacha rurapayanahun. Chasna yuyaripayanahun Yaya Dios paykunata kishpichishkan punchata. ");
INSERT INTO qupNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Chay punchapi Jesuska kacharka Pedrota, Juantapas, rurak riychi mikunata Paskua punchapi mikunanchipa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Chasna rimashpan paykuna tapurkakuna: ¿Maypita munanki rurak rinanchipa? ");
INSERT INTO qupNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Chaypi Jesuska paykunata aynirka: Chay Jerusalén llaktapi paktashpaykichi shuk runata tinkunkichi shuk mankapi yakuta apahukta. Chay runata katiychi. Maykan wasipimi yaykun chaypi paywa pakta yaykuychi. ");
INSERT INTO qupNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Chaypi wasi amuta rimankichi: Ñukanchita yachachikmi yachanayan, maypimi payka kay Paskua mikunata ñukanchiwa mikunka. ");
INSERT INTO qupNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Chay wasi amuka rikuchinkami shuk atun kwartuta ishkaynin kawitupi sumakta alicharishkata. Chaypi mikunata ruraychi. ");
INSERT INTO qupNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Paykunaka rishpankuna tukuyta Jesuspa rimashkantashina tarik rirkakuna. Chaypi mikunata rurarkakuna Paskua punchapi mikunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ña mikuna uras paktarishpan Jesús chunka ishkay apostolninkunawa pakta mesa muyukta siririrkakuna mikunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Chaypi Jesuska rimarka: Maytukuyta munashkani kay Paskua mikunata kankunawa mikunata, manara wañunayni paktarihushpan. ");
INSERT INTO qupNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kankunata rimani, kay Paskua mikunata manami kuti kankunawa mikushanchu Yaya Diospa ali kamachinan mushu mundu kallarinankama. Chaypimi Paskua tantarinanchipi yuyarishkanchika kishpichiy tukunamanta alita paktachirishka kanka, sumakta kishpichiy tukushkaykichirayku. ");
INSERT INTO qupNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Chasna nishpan Jesuska shuk pusillu vinuta apishpan Yayan Diosta agradesishkanwasha rimarka: Apishpaykichi shukma shukma pasachishpa karan shuk upyaychi. ");
INSERT INTO qupNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kankunata rimani, ñukaka manami kutikashka kay allpapi kushilla kankunawa tantarishpa kay vinuta upyashannachu. Ña wañushami. Yaya Diospa ali kamachinanka mushu mundupi kallarishpan chaypira shuti kuti kushilla tantarishunchi. ");
INSERT INTO qupNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Chay vinuta kushkanwasha pantana apirka. Yayan Diosta agradesishkanwasha panta pakishpa pakishpa paykunata kurka. Chasna kuhushpan nirka: Kay panka aychaynishinami kan. Tukuy uras tantarishpaykichi shuk panta pakinakushpa mikuhushpaykichika yuyariychi ñuka kankunaranti wañushkaynita kishpichinaynipa. ");
INSERT INTO qupNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ña mikushkankunawasha chasnallatata shuk pusillu vinuta apishpan rimarka: Kay vinuka yawarnishinami kan. Wañushpayni yawarnika shuturishpan Yaya Dios kankunata uchaykichimanta llakichishpan kishpichinka. Wañuhushpayni tukuy kay mushu alichanawa rimashkaynita paktachisha. ");
INSERT INTO qupNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kunan maykanmi apichiwanka chay runaka chawpinchipimi kahun. ");
INSERT INTO qupNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ñawpa ñukamanta rimashkashinami kunanka paktarihun. Ñuka Yaya Diospa Kachashkan Runaka wañunayni tiyan. Chasna kashpanpas ay chay runa apichiwak ¡imashna kastigushi payrayku kanka! ");
INSERT INTO qupNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Chaypi runankunaka mancharishpa tapunakurkakuna paykunapura: ¿Maykanshi ñukanchimanta Jesusta apichinka? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Chasna Jesuswa tantaylla mikuhushpankuna runankunaka kallarirkakuna rimanakunata paykunapura, maykanshi paykunamanta ashwan yachayyu kamachik kananta runakunaka rimanahuma. ");
INSERT INTO qupNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Chaypi Jesuska paykunata rimarka: Kay allpapi kamachikkuna runakunata sinchita kamachinahun. Chasna kashpankuna munanahun runakuna paykunata rimanankunapa runakunata alita yanapakkuna nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kankunaka ama chasna apukunashina kaychichu. Maykanmi kankunamanta ashwan atun apu kanayan, payka shuk wawashina kasuk tukuchun. Maykanmi kankunata kamachik kan, payka tukuypi yanapak tukuchun. ");
INSERT INTO qupNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kay allpapi kamachik runakuna mikunankunapa tiyarinahun runankuna paykunata karanankunapa. Ñukaka kankunarayku mana chasna apushinachu kani, ashwan shuk runa apunta mikunata karakshinami kani. ");
INSERT INTO qupNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kankunami ñukawa tukuy uras kamay tukushkaynikunapi kashkankichi. ");
INSERT INTO qupNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","Chayrayku imashnami Yayayni ñukata apu tukunaynipa rimawashka, ñukapas kankunata rimani apukuna tukunaykichipa. Chay ali kamachinayni mushu mundupi ñukawa pakta mesaynipi mikunkichi upyankichipas. Chaymanta kankunata suma kamachina tiyarinakunapi tiyachisha, chay chunka ishkay israel ayllukunamanta mirashka israel masikichikunata kamachinaykichipa. Chasna kamachik tukushpaykichimi paykunata rimankichi alitachu manachu rurashkakuna nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Chaymanta Jesuska Pedrota rimarka: Simón, alita uyaway. Supaykunapa apumi yapa kankunata kamanata munashpan Yaya Dioska ari nishka. Imashnami shuk shushunawa kuyuchishpa mana alikunata surkunchi, chasnashinami kankunaka kamay tukunkichi sakiwankichichu manachu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ñukaka kanrayku Yaya Diosta mañashkanimi, kanta yanapananpa mana sakiwanaykipa. Kan ñukata kutikashka katiwashpayki sinchikuchiy kirik masikikunata, paykunapas ñukata alita katiwanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Chaypi Simonka nirka: Yaya Jesús, kanta karselpi tapashpankunaka chayma kanwa pakta rinayani. Kanta wañuchishpankunaka ñukapas kanwa pakta wañusha. ");
INSERT INTO qupNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Chasna rimashpan Jesuska aynirka: Pedro, rimashkayki, kunan tutami manara atallpa kantahushpan kanka kimsa kuti llullashpa rimanki Jesusta mana riksinichu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Chaymanta Jesuska runankunata rimarka: Yuyariychi shiminita yachachinaykichipa kachashkayni punchakunata. Chay uras kankunata rimashkani nima imata apanaykichipa, nima bulsata, nima kullkita, nima sapatuta. Chasna rishpaykichi ¿shuk imaka pishirkachu kankunarayku? Paykunaka aynirkakuna: Mana nima ima ñukanchita pishirkachu. ");
INSERT INTO qupNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Chaypina paykunata rimarka: Kunan shuti manana chasnallachu rinkichi. Maykanpachari tiyan bulsan, kullkin, chayka purihushkanpi munashkanrayku apachun. Maykanpachari mana tiyanchu sablinka, payka kamisanta rantichishpan sablinta rantichun. Kamisaykichimanta ashwanta munankichi sablikichita, tukuy parti kuntraykichikuna tiyashkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kankunata rimani, kunalla Yaya Diospa killkachishkanpi ñukamanta killkarishkaka paktarinka kasna nishkaka: Shuk millaypa rurak runatashina payta wañuchinkakuna. Chasnashinami paktarihun ñukarayku. ");
INSERT INTO qupNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Chaymanta rimarkakuna: Yaya Jesús, kaypimi tiyan ishkay sablinchikuna. Chaypina Jesuska aynirka: Chaylla kachun. ");
INSERT INTO qupNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Mikushkankunawasha Jesuska chay wasimanta llukshishpan Olivos shutiyu urkuma rirka, imashnami wiñay rurapayan. Chasna rishpan paypa runankunaka katirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Chaypi paktashpankuna Jesuska nirka: Mañaychi Yaya Diosta, sinchita kamay tukuhushpaykichi mana sakinaykichipa ñukapi sinchikunata. ");
INSERT INTO qupNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Chasna rimashpan Jesuska paykunamanta anchurirka astalla karunikstupi. Chaypi kunkurishpan Yayan Diosta mañarka: ");
INSERT INTO qupNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Yayayni, munashpaykika kishpichiway mana chasna sinchita parisinaynipa. Chasna tapushpaynipas ama ñukapa munashkaynita ruraychu, ashwan kanpa munashkaykillata ruray. ");
INSERT INTO qupNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Chasna mañahushkanpi silumanta shuk angel rikurik shamurka sinchikuchinanpa. ");
INSERT INTO qupNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesuska yapa parisinanta yuyarishpa sinchi manchayta musyashpan Yayan Diosta ashwan sinchita mañarka. Umpinka yawarshina tukushpa allpama shuturirka. ");
INSERT INTO qupNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Chasna Yayan Diosta mañashkanwasha atarirka runankunama kutinanpa. Chaypi paykunata tarik rirka puñuhukkunata. Yapa llakiywa sampayashpankuna puñuy apishpan puñuhurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Chaypi rimarka: ¿Imaraykuta puñuhunkichi? Atarishpaykichi Yaya Diosta mañaychi mana sakinaykichipa ñukapi sinchikunata, sinchita kamay tukuhushpaykichi. ");
INSERT INTO qupNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús chayra rimahushkanpi achka runakunaka paktamurkakuna. Chay runakunapa puntanpi Jesuspa chunka ishkay runankunamanta Judas shutiyu rirka. Jesusta kayllayak shamushpan payta saludahushpan mucharka. ");
INSERT INTO qupNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Chaypi Jesuska rimarka: Judas ¿ñuka Yaya Diospa Kachashkan Runata muchashpaykichu apichiwanki? ");
INSERT INTO qupNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jesuswa kahukkunaka chasna pasahukta rikushpankuna tapurkakuna: Yaya Jesús ¿wañunakushunchichu sabliwa? ");
INSERT INTO qupNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Chasna nishpankuna Jesuspa shuk runan sablinta apishpan saserdotekunapa atun apupa shuk runanta sumakta pitishpa wañuchisha nishpa pitihushpan kuska parti rinkrinta pitirka. ");
INSERT INTO qupNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Chaypi Jesuska rimarka: Sakiychi. Chaykamalla. Chasna nishpan chay runapa rinkrinta llankashpan ampirka. ");
INSERT INTO qupNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Saserdotekunapa apunkuna, Yaya Diospa wasinta kuyrakkunapas, paykunata kamachik israel masin rukukunapas shamurkakuna Jesusta apichinankunapa. Chay runakunata Jesuska rimarka: ¿Imaraykutaya sablikunawa kaspikunawapas shamushkankichi apiwanaykichipa? ¿Wañuchik shuwa runachu kani? ");
INSERT INTO qupNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Tukuy puncha Yaya Diospa wasinpi kankunawa kahushpayni ¿imaraykutaya mana chaypi apiwashkankichichu? Tuta kashpanmi kunan apiwanaykichi ura paktarishka. Kunan Yaya Dios sakin amsaka punchata winsikshina supaykunapa apun munashkanta rurananpa. ");
INSERT INTO qupNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jesusta apishpankuna saserdotekunapa atun apupa wasinma pusharkakuna. Chasna pushashpankuna chaypi yaykuchirkakuna. Pedroka karullapi katirka. ");
INSERT INTO qupNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Chay wasi kincharishka pampan chawpipi kuyrakkunaka ninata sintichishpankuna muyukta tiyarirkakuna. Chaypillatata Pedropas paykunapa chawpinpi tiyarik rirka. ");
INSERT INTO qupNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Chaypi shuk chay aputa yanapak warmika payta nina kuchupi tiyahushkata alita rikushpan rimarka: Kay runapas Jesuswa pakta purikmi kan. ");
INSERT INTO qupNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Chasna nishpan Pedroka llullachishpa aynirka: Manami paytaka riksinichu. ");
INSERT INTO qupNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Unaystumanta kuti shuk runa payta rikushpan rimarka: Kanpas chay runapa runankunamantallatatami kanki. Pedroka aynirka: Manami paykunamantachu kani. ");
INSERT INTO qupNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Shuk uramanta shukna rimarka: Kay runapas shutipami Jesuswa purik kan, paypas Galileamanta runa kashkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Chaypi Pedroka aynirka: Pimantachari rimahunki manami yachanichu. Chasna rimahushkanllapi atallpaka kantarka. ");
INSERT INTO qupNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Chaypi Jesuska tikrarishpan Pedrota rikurka. Chasna rikushkanllapi Pedroka yuyarirka Jesuspa nishkanta: Kunan tuta manara atallpa kantahushpanra kanka kimsa kuti rimanki manami riksinichu payta nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Chasna yuyarishpan Pedroka kanchama llukshishpan yapa llakirishpan sinchita wakarka. ");
INSERT INTO qupNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Chaymanta Jesusta kuyrak runakunaka asichishpankuna waktarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ñawinta tapashpankuna uyanpi waktashpa tapurkakuna: Yaya Diospa yachayninwa kashpaykika rimay pita kanta waktashka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Chasna payta waktashpankuna achka mana alikunata paymanta rimashpa payta asichirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ña pakarihushpan israel runakunata kamachik israel masin rukukuna, saserdotekunapa apunkunapas, Moisespa killkashkanta yachachikkunapas tantarirkakuna. Chay tantarishkankunama Jesusta pusharkakuna, maypimi paykunaka apupura tantaylla yuyarishpa kwintanahun. Chaypi payta tapurkakuna: ");
INSERT INTO qupNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Rimay ñukanchita ¿kanchu kanki chapahushkanchi Yaya Diospa Kachanan Kishpichikka? Chaypi Jesuska aynirka: Rimashpaynika chay Kishpichik kani nishpa, mana kiriwankichichu. ");
INSERT INTO qupNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ñuka kankunata shuk imata tapuynimaka, mana ayniwankichimachu. ");
INSERT INTO qupNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kunanmanta pacha ñuka Yaya Diospa Kachashkan Runa tukuyta atipak Yaya Diospa kuchunpi tiyarisha tukuy runakunata kamachinaynipa. ");
INSERT INTO qupNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Chayta uyashpankuna yapa piñarishpa tapurkakuna: ¿Shutipachu chasna rimahunki Yaya Diospa Wawan kanaykita? Jesuska aynirka: Ari, ñukami kani rimashkaykichishina. ");
INSERT INTO qupNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Chayta uyashpankuna paykunaka rimarkakuna: Kunan shuti manana munanchichu nima shuk runata paymanta ashwan millaypata rimak shamunanpa payta wañuchichinanchipa. Ñukanchi kikin uyashkanchi pay kikin mana llakichiypa rimashkanta nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Chaymanta tukuy chay tantarishkakunaka atarishpankuna Jesusta romano apu Pilatoma pusharkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Chaypi Jesusta uchachishpa rimarkakuna: Kay runaka israel masinchikunata yachachishka apunkunata mana kasunankunapa. Chayraykumi payta apishpa pushamushkanchi. Paymi rimarka: Romano tukuymanta atun aputa ama impuestuta kunkichichu nishpa. Chaymantapas rimarka: Yaya Diospa Kachashkan Kishpichik, Atun Apuykichimi kani nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Chaypi Pilatoka Jesusta tapurka: ¿Shutipachu kanki israel masikikunapa Atun Apu? Jesuska aynirka: Ari, ñukami kani rimashkaykishina. ");
INSERT INTO qupNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Chaymanta Pilatoka saserdotekunapa apunkunata, tukuy chaypi kahukkunata rimarka: Ñukaka mana tarinichu nima shuk millaypa rurashkanta kay runapata. ");
INSERT INTO qupNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Chasna rimashpan chaypi kahukkunaka ashwan sinchita llullashpa Jesusmanta rimarkakuna: Kay runaka tukuy israel runa masinchikunata yachachishka apunchikunata mana kasunanchipa. Kallarishka Galilea allpapi, kunanka kay Judea allpapipas runakunata yachachishpa kahurka. ");
INSERT INTO qupNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Chasna uyashpan Pilatoka tapurka: ¿Kay runaka Galileamantachu kan? ");
INSERT INTO qupNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ari nishpankuna Pilatoka yachashpan Herodeska Galilea allpapi kamachik apu kashkanta, payma kacharka. Herodeska chay punchakunaka Jerusalenpi kahurka. ");
INSERT INTO qupNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jesusta rikushpan Herodeska kushikurka. Paymanta uyashpan unaymanta pacha payta rikunayarka. Yuyarirka kunanchari ñukapas atun yachaywa shuk nima ima uras rikushkaynita Jesuspa rurananta rikusha nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Chaypi Jesusta achkata tapurka. Unayta tapunata katishpanpas Jesuska nima imata aynirkachu. ");
INSERT INTO qupNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Saserdotekunapa apunkuna, Moisespa killkashkanta yachachikkunapas chaypi kashpankuna payta uchachishpalla kahurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Jesús nima imata aynishpan Herodeska suntalunkunawa payta pukllachishpa asichirkakuna. Asichishpa atun apupa suma churarinantashina churachirkakuna. Chaymanta Pilatomallatata pusharkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Chay puncha Herodeska Pilatowa ali amigu tukurkakuna, ñawpaka kuntrakunashina kapayarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","14","Chaymanta Pilatoka saserdotekunapa apunkunata, chay Jerusalén llaktapi kamachikkunata, tukuy chaypi kahukkunatapas tantachishpa rimarka: Kay runata pushamushpaykichi rimak shamuwashkankichi: Payka runakunata yachachishpa purin apuykichikunata ama kasuychichu nishpa. Ñukaka alita yachanaynipa kankunapa puntaykichipi tapushkani. Ña rikushkankichi maykanmantami mana alita rimawashkankichi, nima shuk millaypa rurashkanta tarishkanichu. ");
INSERT INTO qupNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodespas nima shuk millaypata tarishkachu. Chasna kashpan kuti ñukanchima kachashka. Kay runaka nima imata rurashkachu ñuka wañuchichinaynipa. ");
INSERT INTO qupNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kunanka asutishpalla kacharichisha. ");
INSERT INTO qupNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Karan wata ña chay Paskua punchakuna paktarimuhushpankuna Pilatoka shuk karselpi kahukta kacharichipayan. Chasna kashpan chay wata Jesusta kacharichinayarka. ");
INSERT INTO qupNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Chasna rimashpan tukuy chaypi kahukkunaka piñarishpa kaparirkakuna: ¡Payta wañuchiy! ¡Barrabasta kacharichiy! ");
INSERT INTO qupNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Chay Barrabaska runakunata chay llaktapi kamachik apukunata mana kasunankunapa rimashpa yuyachishkanrayku shuk runata wañuchishkanraykupas karselpi kahurka. ");
INSERT INTO qupNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatoka Jesusta kacharinayashpan kuti rimarka paykunata. ");
INSERT INTO qupNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Chaypi ashwan sinchita kaparirkakuna: ¡Kruspi klabashpa wañuchichiy! ¡Payta kruspi klabashpa wañuchichiy! ");
INSERT INTO qupNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Chaypi Pilatoka kimsaynin kuti rimarka: ¿Ima millaypatataya rurashka? Nima shuk millaypata rurashkanta paypi tarinichu wañuchichinaynipaka. Chayrayku asutichishpalla kacharichisha. ");
INSERT INTO qupNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Chasna nishpan ashwan sinchita kaparishpankuna rimarkakuna: ¡Kruspi klabashpa wañuchichiy! Yapa sinchita kaparishpankuna Pilatoka ari, wañuchichishami nirka. ");
INSERT INTO qupNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Chasna mana sakishpa tapushpankuna Pilatoka suntalunkunata kamachirka Jesusta kruspi klabashpa wañuchinankunapa, paykuna munashkankunatashina. ");
INSERT INTO qupNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Chay karselpi kahuk Barrabasta, apukunawa kuntra kashpantata shukkunata wañuchishka kashpanpas paytaka kacharichirka. Jesustana paykuna munashkankunatashina ruranankunapa kurka. ");
INSERT INTO qupNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ña suntalukuna Jesusta pushahushkankunapi kruspi klabashpa wañuchinankunapa, chay ñampipi apirkakuna shuk runata Jesuspa krusninta markachinankunapa. Chay runaka karka Sirene llaktamanta Simón shutiyu. Chay Simonka chakranmanta Jerusalenma kutimuhurka. Payta Jesuspa krusninta markachishpankuna Jesuspa washan apashpa rirka. ");
INSERT INTO qupNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Achka runakuna Jesusta katirkakuna. Achka warmikunapas katihushpankuna payrayku llakiywa kaparishpa wakarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesuska chay warmikunata rikushpan rimarka: Jerusalén llaktamanta warmikuna, ama ñukarayku wakaychichu. Shuk parisina punchakuna paktarinkakuna, chaypi kankuna wawaykichikunawa yapa parisinaykichi tiyan. Chayta yuyarishpa kankunarayku wawaykichiraykupas wakaychi. ");
INSERT INTO qupNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Chay parisina punchakuna paktarishpan runakuna rimankakuna: Kushilla kankichi machura warmikuna, chaymanta kankuna maykankunami nima ima uras wiksayu kashkankichi, nima chuchuchishkankichichu. ");
INSERT INTO qupNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Chay uras tukuy runakuna yapa wañunayashpankuna urkukunata rimankakuna: Awanchipi urmaychi nishpa. Lumakunata rimankakuna: Ñukanchita tapaychi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ñuka mana uchayu runa kashpaynitata yapa sinchita parisinayni tiyan, kankuna uchayu kashpaykichi ashwanta parisinaykichi tiyan. ");
INSERT INTO qupNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Chay suntalukunaka Jesusta wañuchinankunapa pushahushpankuna ishkay wañuchik runakunatapas pusharkakuna paywa pakta wañuchinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Wañushkapa uman shutiyu lumapi paktashpankuna Jesusta kruspi klabarkakuna. Chay ishkanti wañuchik runakunatapas karan shukta shuk kruspi klabarkakuna wañunankunapa. Shuk krusta shayachirkakuna Jesuspa kuskan parti, shuktaka llukin parti. ");
INSERT INTO qupNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Klabahushpankuna Jesuska rimarka: Yayayni, llakichiy paykunata kay mana alita rurahushkankunamanta. Mana yachanahunchu imatami rurahunkuna. Chaypina chay suntalukunaka swirtinkunata kamarkakuna pishi paykunamanta apanka Jesuspa churarinanta nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Tukuy chaypi kahukkunaka rikuhlla kahurkakuna. Israel apukunapas asichishpa rimarkakuna: Shukkunata kishpichirka. Shutipa Yaya Diospa akllashkan kashpanka paypa Kachashkan Kishpichik kashpanka pay kikinta kishpichirichun. ");
INSERT INTO qupNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Suntalukunapas asichishpa payma kayllayashpankuna agru vinuta upyachishpa rimarkakuna: ");
INSERT INTO qupNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Israel runa masikikunapa Atun Apu kashpaykika kan kikinta kishpichiriy. ");
INSERT INTO qupNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jesuspa uman awapi ratachirishka karka shuk killkarishka tablapi kasna nishpa: Kay runaka israel runakunapa Atun Apumi. ");
INSERT INTO qupNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Chay ishkanti wañuchik runa klabarishkankunamanta shukka Jesusta asichishpa rimarka: ¿Manachu Yaya Diospa Kachashkan Kishpichik kanki? Shutipa kishpichik kashpaykika kan kikinta kishpichiriy, ñukanchitapas kishpichiy. ");
INSERT INTO qupNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Chaypi chay shukka Jesusta asichihukta aynirka: Kanpas payshina kruspi klabarishka kashpayki ¿imaraykuta chasna rimanki? ¿Manachu Yaya Diosta manchanki? ");
INSERT INTO qupNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ñukanchi shuti kuskanchipi kastigarishka kahunchi, mana alita rurashkanchirayku. Kay runaka nima shuk millaypata rurashkachu. ");
INSERT INTO qupNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Chasna chay wañuchik masinta rimashpan Jesustana rimarka: Kan atun apu tukushpayki ñukatapas yuyariwanki. ");
INSERT INTO qupNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Chaypina Jesuska payta rimarka: Kunan punchami ñukawa pakta suma kushilla kawsanaynipi kanki. ");
INSERT INTO qupNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Jesús kruspi klabarishka kahushkanpi chawpi punchamanta pacha kimsa urakama intika amsayashpan tukuy chay allpapi amsa tukurka. Chaypina Yaya Diospa wasin ukupi Yaya Dioswa tinkunakuna kwartuta arkak rakta llachapaka awamanta pacha pitikta likirirka. ");
INSERT INTO qupNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Chasnapi Jesuska sinchita kaparishpa rimarka: ¡Yayayni, kaykaya makikipi kani, ñami wañuhuni! Chasna nishpan Jesuska wañurka. ");
INSERT INTO qupNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tukuy chasna pasashkanta rikushpan suntalukunapa kapitanka Yaya Diosta kushichishpan rimarka: Kay runaka shutipami mana uchayuchu kashka. ");
INSERT INTO qupNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tukuy chaypi tantarishka runakunaka tukuy chay pasashkata rikushpankuna mancharishpa mana alita rurashkankunata yuyarishpankuna Jerusalenma kutirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Tukuy Jesusta riksishkakunaka, Galilea allpamanta payta katik warmikunapas karumantalla tukuyta rikurayarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Chaypi tiyarka shuk apu José shutiyu, alita rurak, ali runa. Payka Judea allpapi kahuk Arimatea llaktamanta karka. Israel runakunata kamachik tantaylla yuyarishpa israel apukunamanta shuk karka. Yapa chaparka Yaya Diospa ali kamachinan kay allpapi paktarinanta. Apu masinkunaka Jesusta wañuchinata munahushpankuna Joseka mana munarkachu. ");
INSERT INTO qupNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Payka Pilatoma rishpan Jesuspa aychanta tapurka urku uchkupi churashpa tapananpa. ");
INSERT INTO qupNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pilato ari nishpan Joseka Jesuspa aychanta krusmanta uraykuchishpan suma yura llachapawa wankurka. Chaymanta Jesuspa aychanta aparka shuk mushu allarishka urku uchkupi churashpa tapananpa. Chaypika nima shuk wañushkata churashka kahurkarachu. ");
INSERT INTO qupNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Paskua punchakunarayku alichanankuna puncha karka. Samana punchaka chay tuta ña kallarinan karka. ");
INSERT INTO qupNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galileamanta Jesusta katik warmikunaka Joseta katirkakuna rikunankunapa, maypimi Jesuspa aychanta churanka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kutishpankuna wasinkunama suma mishkinlla asnak aseitekunata rurarkakuna chaywa Jesuspa aychanta samana punchawasha kakunankunapa. Samana puncha samarkakuna Yaya Dios kamachishkanshina. ");
INSERT INTO qupNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Domingo, semana kallarina puncha manara alita punchayahushpanra chay warmikunaka suma mishkinlla asnak aseiteta rurashkankunata apashpa rirkakuna Jesuspa aychanta churashpa tapashkankunama. ");
INSERT INTO qupNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Chaypi paktashpankuna chay uchkupa punkunta rumiwa taparishkaka paskarishkatana tarik rirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Uchku ukuma yaykushpankuna Jesuspa aychanta mana tarirkakunachu. ");
INSERT INTO qupNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Mana tarishpankuna mancharirkakuna. ¿Imanashkataya? nishpankuna mana yacharkakunachu imatami yuyarinkakuna. Chasna yuyarihushkankunapi ishkay suma chuyahlla churarishka runakuna kuchunkunapi shayahukta rikurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Paykunata rikushpankuna chay warmikunaka ashwanta mancharishpa kumurirkakuna. Chaypi chay ishkay runakunaka rimarkakuna: ¿Imaraykuta kawsahukta maskahunkichi wañushkakunata churanapi? ");
INSERT INTO qupNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Jesuska manami kaypichu. Ñami kawsarishka. ¿Ñachu kunkarishkankichi Jesuspa yachachishkanta Galileapira kahushpaykichi kasna rimashkanta?: Ñuka Yaya Diospa Kachashkan Runata chiknik runakunaka apiwashpankuna kruspi klabashpa wañuchiwankakuna. Chasna wañuchiwashpankunapas kimsa punchamantami kuti kawsarinayni tiyan nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Chasna chay ishkay angelkunapa rimashkankunata uyashpankuna chay warmikunaka Jesuspa rimashkanta yuyarirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Chaymanta kutishpankuna Jesuspa chunka shuk apostolninkunata, shuk paypa runankunatapas tukuy rikushkankunata rimak rirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Chay warmikunaka karkakuna: Magdalamanta Maria, Juana, Santiagopa maman Maria, chaymanta ashwan shuk warmikunapas. ");
INSERT INTO qupNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Chay Jesuspa apostolninkunaka chayta uyashpankuna musparishpami yanka rimahunkichi nishpa mana kirirkakunachu. ");
INSERT INTO qupNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Mana kirishpankunatata Pedroka atarishpan Jesuspa aychanta churashkankunama kallpa rirka. Paktak rishpan uchku ukuma kumurishpan rikurka. Chaypi rikurka Jesusta pillushkankuna llachapallata. Jesuspa aychanka manana tiyarkachu. ¿Imanashkataya? nishpa yuyarirka. Chaymanta kutirkana. ");
INSERT INTO qupNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Chay punchallatata ishkay Jesuspa runankuna Emaús llaktama rihurkakuna. Chay Emaús llakta karka Jerusalenmanta chunka shuk kilometro, ishkay ura purina tupu. ");
INSERT INTO qupNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Tukuy Jesuspa pasashkanmanta kwintashpa rihurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Chasna kwintashpa rihushpankuna Jesuska paykunata kayllayashpan parihu rirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Payta rikushpankunatata mana atiparkakunachu riksinata Jesús kananta. ");
INSERT INTO qupNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Chaypi Jesuska paykunata tapurka: ¿Imamantata kwintashpa rihunkichi? Chasna tapushpan llakirishpa shayarirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Chaypi Kleofas shutiyu aynirka: Kay punchakunapi Jerusalenpi pasashkata tukuy yachanahun. Chasna kashpan ¿kanllachu tukuy chaykunata mana yachanki? ");
INSERT INTO qupNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Chaypi Jesuska tapurka: ¿Imataya pasashka? nishpa. Paykunaka aynirkakuna: Chay Nasaret llaktamanta Jesuswa pasashkantami yuyarishpa kahunchi. Payka Yaya Diospa yachayninwa yachachik karka. Yaya Diospa rikushkanpi, tukuy runakunapa rikushkanpipas atun yachaywa rimak alikunata rurak karka. ");
INSERT INTO qupNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Saserdotenchikunapa apunkuna, ñukanchita kamachikkunapas payta apishpankuna romano aputa kurkakuna wañuchichinanpa. Chasna kushpankuna kruspi klabashpa wañuchirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ñukanchika yuyarirkanchi ñukanchi israel runakunata romano runakunamanta kishpichinanta. Kunan ña kimsa puncha kahu chasna payta wañuchishkankunaka. ");
INSERT INTO qupNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Chaymantapas ñukanchipuramanta shuk warmikunaka ñukanchita kwintashpankuna manchachirkakuna. Pakarihushkanpi Jesuspa aychanta churashkankunama rishpankuna aychanta mana tarirkakunachu. ");
INSERT INTO qupNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Chaymanta kutimushpankuna angelkunata rikushkankunamanta kwintak shamurkakuna. Chay angelkunaka paykunatashi rimarkakuna Jesuska kawsahumi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Chasna nishpankuna shuk ñukanchiwa purihukkunaka Jesuspa aychanta churashkankunama rishpankuna illata tarik rirkakuna imashnami warmikunaka rimarkakuna. Jesustaka manami rikurkakunachu. ");
INSERT INTO qupNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Rimahushkankunata uyashpan Jesuska paykunata rimarka: Kankunaka mana asirtak runakunachu kankichi. Yapa unayankichi kirinaykichipa Yaya Diospa yachayninwa ñawpa yachachikkunapa rimashkankunata. ");
INSERT INTO qupNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Manachu yachankichi, Yaya Diospa Kachashkan Kishpichikka manara atun apu tukushpan tukuy chaykunata parisinan kashkata? ");
INSERT INTO qupNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Chasna rimashpan Jesuska yachachihurka chay ishkay runankunata tukuy Yaya Diospa killkachishkanpi paymanta killkarishka kashkata. Kallarishpan Moisespa killkashkankunawa, chaymanta Yaya Diospa yachayninwa shuk yachachikkunapa killkashkankunamantapas yachachirka. ");
INSERT INTO qupNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Chasna Jesuska yachachihushkanpi llakta mayanpi paktarkakuna, maymami rihurkakuna. Jesuska ashwan chaynikma rihukshina tukurka. ");
INSERT INTO qupNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Chaypi chay ishkay runankuna mana munarkakunachu Jesús paykunamanta anchurinanpa. Rikuy, ña tutayahunchi. Ñukanchiwa kipariy nishpa rimarkakuna. Chasna yapa tapushpankuna Jesuska wasinkunapi yaykushpan paykunawa kiparirka. ");
INSERT INTO qupNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Mesa mayanpi sirihushpankuna mikunankunapa, Jesuska panta apishpan Yayan Diosta agradesirka. Chaymanta panta pakishpan paykunata kurka. ");
INSERT INTO qupNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Chasnallapi ñawinkunaka paskarishkashina tukurka. Chaypira Jesús kananta riksirkakuna. Chasnallapi kunkaymanta illa tukurka, payta mana rikurkakunanachu. ");
INSERT INTO qupNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Chasna chinkarishpan paykunapura kwintarkakuna: Ñampipi shamuhushpanchi Yaya Diospa shiminta alita asirtachishpa yachachihushkanpi ¿manachu shunkunchika kushilla tukurka? ");
INSERT INTO qupNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Chasnallapi atarishpankuna Jerusalenma kutirkakuna. Paktashpankuna Jesuspa runan masinkunata tantarishkata tarirkakuna, ashwan Jesuswa shuk purik masinkunatapas. ");
INSERT INTO qupNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Chay ishkay paktashka runakuna manara nima imata rimahushpankuna chaypi tantarishka kahukkunaka paykunata rimarkakuna: Yaya Jesuska shutipami kawsarishka. Simón payta rikushka. ");
INSERT INTO qupNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Chasna rimashkankunata uyashpankuna chay ishkay Jesuspa runan masinkunapas kwintarkakuna imashnami Jesuska paykunata ñampipi Yaya Diospa shiminta yachachirka, chaymantapas imashnami panta pakishpan payta riksirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Chasna rimahushkanllapi kunkaymanta Jesuska chawpinkunapi rikurirka. Paykunata saludashpan rimarka: Yaya Dios kankunata kushillayachichun mana manchashpa kawsanaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Chaypi paykunaka yapa mancharishpa yuyarirkakuna shuk almatami rikuhunchi. ");
INSERT INTO qupNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Chaypina Jesuska rimarka: ¿Imaraykuta mancharinkichi? Ñukami kani. ¿Imaraykuta mana kirinayankichichu ñuka kanaynita? ");
INSERT INTO qupNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Llankawashpaykichi makinita chakinitapas rikuychi. Ñukallatatami kani. Almaka mana aychayuchu kan, nima tulluyuchu ñukashina. ");
INSERT INTO qupNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Chasna nishpan makinta chakinta paykunata rikuchirka. ");
INSERT INTO qupNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Paykuna kushilla mancharishka kahushkankunapi manara kirihushpankuna Jesuska tapurka: ¿Tiyanchu mikunaka? ");
INSERT INTO qupNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Chaypi payta kurkakuna shuk piti challwa kusarishkata mikunanpa. ");
INSERT INTO qupNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Challwata apishpan rikuhushkankunallapi mikurka mana alma ninankunapa. ");
INSERT INTO qupNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Chaymanta Jesuska paykunata rimarka: Kankunawa pakta kahushpaynira kasna kankunata rimarkani: Moisespa killkashkanpi, Yaya Diospa yachayninwa shuk yachachikkunapa killkashkanpi, Salmos killkapipas ñukamanta killkarishkaka tukuy paktarinan tiyan. ");
INSERT INTO qupNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Chasna nishpan paykunata asirtachirka tukuy chay Yaya Diospa killkachishkankunata. ");
INSERT INTO qupNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Asirtachishpan rimarka: Killkarishkapi nin Yaya Diospa Kachashkan Kishpichikka wañunan tiyan. Chaymantapas wañushkanwasha kimsa punchamanta kuti kawsarinan tiyan. ");
INSERT INTO qupNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Chaymanta kamachishkan runankuna Jerusalenpi kallarishpankuna pay munashkanshina tukuy allpakunapi runakunata rimanankuna tiyan, mana ali rurashkankunata sakishpa Yaya Diostana kasunankunapa, Yaya Dios paykunata uchankunamanta llakichinanpa. ");
INSERT INTO qupNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kankunaka tukuy rurashkaynita rikushkankichi, tukuy rimashkaynita uyashkankichi. Chasna kashpan tukuy runakunata chayta yachachik riychi. ");
INSERT INTO qupNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Kankunata rimashkaykichi, ñukami Yaya Diospa Espiritunta kankunama kachasha Yayayni rimashkanshina. Kunanka kankuna kay llaktallapi kipariychi chay kankunata sinchikuchik Yaya Diospa Espiritunta silumanta kankunapi kachanaynikama. ");
INSERT INTO qupNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Chaypina Jesuska runankunata Jerusalén llaktamanta pusharka Betania llakta kuchuma. Chaypi paktashpankuna makinta alsashpan paykunata rimarka Yaya Dios yanapashpa paykunata kushichinanta. ");
INSERT INTO qupNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Chasna paykunata rimahushkanpi rikuhushkankunallapi Yaya Dios payta siluma aparka. ");
INSERT INTO qupNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Chasna paykunamanta anchurishpan runankunaka kunkurishpa payta mañashpa kushichirkakuna. Chaymanta sumakta kushikushpa Jerusalenma kutirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Chaymanta pacha tukuy uras Yaya Diospa wasinpi tantarishpankuna payta atunyachishpa kushichirkakuna. Chayllatami Jesuspa runankuna kwintawashkankunata killkashkani.");
INSERT INTO qupNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Manara nima ima tiyashpanra ñukanchi runakunata Yaya Diospa yuyayninta riksichik Kristuka ña tiyarka. Payka Yayan Dioswami karka chasnallatata Yaya Diosmi karka. ");
INSERT INTO qupNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ñawpamanta pachami Yaya Dioswa karka. ");
INSERT INTO qupNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Chay Yaya Diospa yuyayninta riksichik Kristutami payka tukuy ima tiyashkakunata rurachirka. Mana nima ima pay kikinlla rurarishkachu, ashwan tukuyta Yaya Dioska chay yuyayninta riksichik Kristutami rurachirka. ");
INSERT INTO qupNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Chaymanta payllami ñukanchi runakunata Yaya Dioswa kushilla kawsayta kun. Chaymantapas ñukanchita riksichin imashnami ali ruranakunaka Yaya Diospa rikushkanpika. Chasna ali ruranakunata riksichishkanraykumi ñukanchi runakunarayku punchashina kan. ");
INSERT INTO qupNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ali ruranakunata mana riksishpanchi amsapishina kawsanchi. Kristuka punchashina kashpanmi shamushka amsapishina kawsahukkunata riksichinanpa imashnami ali ruranakunaka Yaya Diospa rikushkanpi. Shuk runa masinchikuna payta mana kasunayashpankunapas manami atipashkakunachu chay punchashina kahukta winsinata. ");
INSERT INTO qupNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Yaya Dios shuk runa Juan shutiyuta akllashpan kamachirka chay punchashina kahukmanta yachachinanpa. Chasna yachachinanpami Juanta kamachirka tukuy ñukanchi runakuna uyashpanchi shunkunchimanta pacha Kristupina sinchikunanchipa. ");
INSERT INTO qupNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juanka manami Kristu punchashina kahukchu karka, ashwan payka Kristu punchashina kahukmantami yachachik karka. ");
INSERT INTO qupNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Chay Yaya Diospa yuyayninta riksichik Kristumi shutipa punchashina karka tukuy ñukanchi runakunarayku. Paymi shamunan karka tukuy ñukanchi runakunata riksichinanpa imashnami ali ruranakunaka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tukuy uras kay allpapi kahushpanpas Yaya Dioska payta runakunata rurachishka kashpanpas runakunaka mana riksinayarkakunachu. ");
INSERT INTO qupNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Pay runa tukushpan ñukanchi israel masinkunapi paktarka. Chasna kikin israel runa masinchi kashpanpas payta mana riksinayarkakunachu, chaymantapas mana yaykuchinayarkakunachu. ");
INSERT INTO qupNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Tukuy maykankunami payta yuyashpanchi shunkunchipi yaykuchirkanchi amunchi kananpa, paykunataka Kristumi yanapashka Yaya Diospa wawankuna tukunanchipa. ");
INSERT INTO qupNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Manami Yaya Diospa wawankuna tukushkanchichu shuk warmi kusanmanta chichushpan nima shuk runa chasna munashkanraykuchu. Ashwan Yaya Dios munashpanmi shuk mushu kawsayta kushpan paypa wawankuna tukushkanchi. ");
INSERT INTO qupNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Chay Yaya Diospa yuyayninta riksichik Kristuka ñukanchishina runami tukurka. Pay kawsarka ñukanchiwa. Yuyaysiki llakichiysiki kashpan tukuyta rurarka ñukanchita uchanchikunamanta kishpichinanpa Yaya Diosta riksinanchipa. Chaymantapas ñukanchi runakunata shutipa kashkata riksichik karka. Atun suma yachayyu kahushkanta riksishkanchi. Chay atun yachaynintaka Yaya Diosmi Kristuta kurka shuklla yuyashkan Wawan payshina Yaya Diosllatata kashkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Paymantami Juanka rimashpan ñukanchita yachachirka kasna nishpa: Chay Kristumantami rimashkani kasna nishpayni: Ñuka yachachinata sakishkayniwasha ñukamanta ashwan atun yachayyumi yachachinka. Manarapas wawayarishpaynira payka ña tiyarka. Chayraykumi paymanta rimani, ñukamanta ashwan atun yachayyu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Yaya Dioska ñukanchita yuyaysiki uchanchikunamanta llakichiysiki kashpanmi ñukanchi paypi sinchikuk runakunata yanapashka atunta kushikushpa kawsananchipa. ");
INSERT INTO qupNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ñawpa Yaya Dioska Moisés wañuta killkarishkata kurka ñukanchi runakunata riksichinanpa kamachishkankunata, yachananchipa imashnami alita kawsashunchi. Chaymanta Wawan Jesukristutana kachashpan paywa tukuyta rurarka ñukanchita uchanchikunamanta kishpichinanpa paytana riksinanchipa. Chaymantapas Wawanta kacharka ñukanchita shutipa kashkata riksichinanpa. ");
INSERT INTO qupNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Manami ashwan shuk runaka Yaya Diosta rikushkachu. Shukllami payta rikushka. Paymi kan shuklla Wawan Jesukristu payshina Yaya Diosllatata. Shuk yuyayllawa kashpankunami ñukanchita riksichirka imashnami Yaya Dioska. ");
INSERT INTO qupNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Alita yuyariychi Bawtisak Juanpa rimashkanta Yaya Diospa Wawan Jesukristumanta. Paymanta yachachihushpan ñukanchi israel runakunapa apunchikuna Jerusalén llaktamanta kacharkakuna Juanta tapunankunapa. Chay tapuk runakunaka saserdotekuna karkakuna. Paykunapa tarawanan kan ñukanchi israel runakunapa uchanchikunamanta Yaya Dioswa alichakkuna. Shukkunaka levitakuna karkakuna. Paykunapa tarawanan kan Yaya Diospa wasinpi yanapanankunapa. Juanpi paktashpankuna tapurkakuna: ¿Chapahushkanchi Yaya Diospa Kachanan Kishpichikchu kanki? ");
INSERT INTO qupNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Chaypi Juanka aynirka: Ama chasna rimawaychichu. Ñukaka manami Yaya Diospa Kachanan Kishpichikchu kani. ");
INSERT INTO qupNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Kutikashka tapurkakuna: ¿Ashwan pitaya kanki? ¿Yaya Diospa yachayninwa ñawpa yachachik Eliaschu kanki, maykanmi kutikashka shamunan karka? Juanka aynirka: Mana. Yapa yachanayashpankuna pimi kan Juanka kuti tapurkakuna: ¿Kanchu kanki chapahushkanchi Moisés wañushina Yaya Diospa yachayninwa yachachik? Chaypi payka aynirka: Mana paychu kani nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kuti tapurkakuna: ¿Pitaya kanki? Ñukanchita kachak runakuna yachanayanahun pimi kanki nishpa. Paykunata rimak rinanchipa ñukanchita rimay ¿pimi kanki nishpataya kan kikinmanta yuyarinki? ");
INSERT INTO qupNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juanka aynirka: Ñukami kani shuk runa chunlla chakishka allpapi runakunata Yaya Diospa shiminta sinchita yachachik kasna nishpa: Millaypata rurashkaykichita llakirishpaykichi sakiychi Yaya Diospa Kachanan Kishpichik kankunapi kawsak shamunanpa. Chasnami Yaya Diospa yachayninwa ñawpa yachachik Isaias wañuka ñukamanta killkarka. ");
INSERT INTO qupNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Shuk chaypi kahukkunana fariseokunapa kachashkan runakuna tapurkakuna: Mana chapahushkanchi Yaya Diospa Kachanan Kishpichik kashpaykika nima Yaya Diospa yachayninwa yachachik Elias kashpaykika nima chapahushkanchi Moisesshina yachachik kashpaykika ¿imaraykutaya runakunata bawtisanki? ");
INSERT INTO qupNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Chaypina aynirka: Ñukaka runakunata uchankunata yuyachishpa yakullawa bawtisani. Kushikuychi ñukamanta ashwan yachayyu ña ñukanchiwa pakta kahushkanrayku. Kunanka manara payta riksinkichirachu. ");
INSERT INTO qupNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Manarami kallarihunrachu yachachinata. Ñuka yachachinata sakishkayniwasha payna yachachinka. Yapa yachayyu kashpan ñukaka paymantaka mana yachayyuchu kani. Paypa puntanpika nima imata atipanichu rimanata. ");
INSERT INTO qupNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Chasna Juanka yachachirka Jordán yaku mayanpi Jerusalén llaktamanta chimpa partima Betania llaktapi. Chaypillatata runakunata Jordán yakupi bawtisarka. ");
INSERT INTO qupNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Chasna yachachishkanwasha kayantima Juanka Jesusta rikurka shamuhushkanta. Chaypi rimarka: Rikuychi shamuhushkata, paymi kan Yaya Diospa akllashkan runa uchanchikunarayku wañunanpa. Ñawpamanta pacha obeha maltakunata wañuchipayanahun Yaya Dios uchanchikunamanta llakichinanpa. Kunanka paymi tukuy ñukanchi runakunapa uchanchikunarayku shuk obeha maltashina wañuchiy tukunka Yaya Dios uchanchikunata llakichinanpa. ");
INSERT INTO qupNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Paymantami kankunata rimashkani yachachihushpayni kasna: Ñuka yachachinata sakishkayniwasha payna yachachinka. Manarapas wawayarihushpaynira payka ñawpamanta pacha ña tiyarka. Chayrayku ñukamanta ashwan yachayyumi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ñuka kikinpas puntiru payta mana riksirkanichu pimi kan nishpa. Chasna kashpanpas shamushkanimi kankuna israel masinikunata paymanta yachachinaynipa. Kankunata uchaykichikunata yuyachishpa yakuwa bawtisani. Chayta rurani shunkuykichipi alicharishpaykichi maykanmi shamunan kashkata riksinaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Chaymantapas Juanka payta riksishkanmanta rimarka: Rikushkanimi Yaya Diospa Espiritunta silumanta shuk wiwa mukukushina paypi uraykumuhushkanta. Payllapimi kiparirka chay Yaya Diospa Espiritunka. ");
INSERT INTO qupNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Puntiru ñukaka mana yacharkanichu pimi chay runaka nishpa. Chasna kashpanmi yakupi bawtisanaynipa kamachiwak Yaya Dioska rimawarka: Maykanpimi rikunki Espirituyni uraykumushpan paypi kiparishkanta, paymi runakunata Espirituynita kunka. Kan runa masikikunata uchankunata yuyachishpa yakullawami bawtisanki. Pay shuti Espirituynita runakunata kushpa shunkunkunata aliyachinka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ñukaka ñami rikushkani, rikushpayni yachachishkani pay Yaya Diospa Wawan kananta nishpa Juanka rimarka. ");
INSERT INTO qupNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Chaymanta kayantima Juanka kutikashka chaymallatata rirka. Chay uras ñuka, wawki Andrespas payta katik runakuna kashpanchi chaypi paywa pakta kahurkanchi. ");
INSERT INTO qupNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Chaypina Juanka Jesusta pasahushkata rikushpan rimarka: Rikuychi paymi kan Yaya Diospa akllashkan runa uchanchikunarayku wañunanpa. Shuk obeha maltashina wañuchiy tukunka Yaya Dios ñukanchikunata uchanchikunamanta llakichinanpa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ñukanchi ishkay payta katik runakuna chay rimashkanta uyashpanchi Jesustana katirkanchi. ");
INSERT INTO qupNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Chaypi Jesuska tikrarishpan ñukanchita rikushpan tapurka: ¿Imatata munankichi? nishpa. Ñukanchina rimarkanchi: Yachachik ¿maypita kawsanki? ");
INSERT INTO qupNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesuska ñukanchita aynirka: Shamuychi riksinaykichipa maypimi kawsani. Chasna rimashpan rirkanchi rikunanchipa maypimi kawsahurka. Chaypina paywa kiparirkanchi ña chishiyahushkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andreswa pakta chaypi kiparirkanchi. Payka Simonpa wawkin karka. Juan Jesusmanta rimashkanta uyashpanchi Jesustana katirkanchi. ");
INSERT INTO qupNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andreska Jesusta riksishkanwasha wawkin Simontana maskanapa rirka. Tarishpan wawkinta rimarka: Chapahushkanchi Yaya Diospa Kachanan Kishpichiktami tinkushkanchi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Chaymanta Andreska wawkin Simonta pushamurka Jesusma. Jesuska Simonta rikushpan rimarka: Kanmi kanki Simón, Juanpa wawan. Kunanka shutikika kankami Kefas nishpa. Kefas arameo shimimanta pasachishpa griego shimipi kan Pedro, chayka ninayan rumi. ");
INSERT INTO qupNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Chaymanta kayantima Jesuska ñukanchiwa pakta Galilea allpama ña rinanchipa kahushkapi Felipeta tinkurka. Chaypi payta rimarka: Katiway nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipeka Galilea allpapi Betsaida shutiyu llaktamantami karka. Andrés Pedropas chay llaktamantallatatami karkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipeka Jesusta riksishkanwasha Natanaeltana maskanapa rirka. Payta tarishpan rimarka: Tinkushkanchimi maykanmantami Moisés wañuka ñawpa killkarka. Chaymantapas maykanmantami Yaya Diospa yachayninwa shuk yachachikkunapas ñawpa killkarkakuna. Chay runapa shutinka kanmi Jesús, payka Josepa wawanmi Nasaret llaktamanta nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Chayta uyashpan Natanaelka aynirka: Imashnata ali runaka tiyanka Nasaret llaktamantaka. Chaypi Felipeka aynirka: Shamuy kan kikin riksinaykipa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesuska Natanael payta kayllayamuhushkata rikushpan rimarka: Kaykaya shuk ali israel masinchika Yaya Diosta alita kasuk mana llullachik runaka. ");
INSERT INTO qupNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaelka chaypi tapurka: ¿Imashnataya riksiwanki chasna kanaynita? Jesuska aynirka: Manarapas Felipe kanwa igu kaspi ukupi kwintahushpanra yuyarishkaykita riksishkani. ");
INSERT INTO qupNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaelka mancharishpan rimarka: Yachachik, kanmi kanki Yaya Diospa Wawan, ñukanchi israel runakunapa Atun Apunchi. ");
INSERT INTO qupNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Chaypi Jesuska aynirka: Ña kanka riksiwashkanki pimi kani igu kaspi ukupi kanta rikushkani nishkaynimantalla. Ñuka kanta rimani chay rikushkaykimanta ashwan mana atipaypakunata rurashkaynikunatami rikunki. ");
INSERT INTO qupNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Chaymantapas Jesuska rimarka: Alita uyawaychi. Nima ima uras rikushkaykichitami rikunkichi Yaya Diosmanta kashkaynita yachanaykichipa. Rikunkichimi siluka paskarishkata, angelkuna ñuka Yaya Diospa Kachashkan Runamanta sikahushkankunata, chaymantapas ñukapi uraykuhushkankunata nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Chaymanta ishkay punchawasha tiyarka shuk kasarana fiesta Kaná llaktapi Galilea allpapi. Jesuspa maman chay fiestapi kahurka. ");
INSERT INTO qupNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesuspas ñukanchi runankunawa pakta chaypi kahurka chay fiesta amun kayashkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Chay fiestapi upyahushkanchi vinuka tukurirka. Tukurishkata rikushpan mamanka Jesusta rimak shamurka: Mana tiyannachu vinuka. ");
INSERT INTO qupNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Chaypi Jesuska aynirka: Mamayni, ama chasna rimawaychu imatami rurasha. Ñuka kikinmi yachani imatami ruranayni tiyan. Manarami Yayaynika rimawashkarachu imatami rurasha. ");
INSERT INTO qupNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Chaypi mamanka rimak rirka chay fiesta amuta yanapak runakunata: Wawaynika kankunata kamachishpanka kasuychi. ");
INSERT INTO qupNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Chay fiesta amupaka tiyarka sokta tinahakuna rumimanta rurarishka chaypi yakuta churanankunapa. Chasna tinahakunapi kahuk yakuwami mayllaripayanchi, Yaya Diospa rikushkanpi ali tukunanchipa nishpa yuyarishpanchi. Chay fiesta amupa karan tinahanka pichka chunka, kanchis chunka parti butilla yakuwa untaripayan. Chay tinahakunaka chushakunami karkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Chaypi Jesuska yanapak runakunata rimarka: Untachiychi yakuta kay tinahakunapi nishpa. Paykunaka chay tinahakunapa shiminkunakama yakuta untachirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Chaymanta Jesuska rimarka: Kunanka chay tinahakunamanta wishishpaykichi uchillallata apaychi fiesta amupa kamachishkan runa kamananpa. Paykunaka aparkakuna chay runama. ");
INSERT INTO qupNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Chay runaka yakumanta vinu tukushkata kamarka. Mana yacharkachu maymantami chay vinuka. Chay wishik runakunallami yacharkakuna chay vinuka yakumanta tukushkanta. Chay fiesta amupa kamachishkan runaka vinuta kamashpan chay warmiyahuk runata kayarka. ");
INSERT INTO qupNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Shamushpan payta nirka: Puntirumi tukuy kayashkanchi runakunata upyachinchi ali vinuta. Ña achkata upyashkankunawashami upyachinchina mana yapa ali vinuta. Kanka ¿imaraykutaya wakaychashkanki kay ali vinutaka kunankama? ");
INSERT INTO qupNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Chay yakumanta vinuta Jesuska rurashpan chaypi runakuna nima ima uras rikushkankunata Yaya Diospa yachayninwa puntiru rurashkanta rikuchirka. Chayta rurarka Galilea allpapi kahuk Kaná llaktapi. Chay rurashkanwa Jesuska atun yachak kananta riksichirka. Chayta rikushpanchi ñukanchi paypa runankunaka kirirkanchi Yaya Diospa kachashkan kananta. ");
INSERT INTO qupNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Chaywasha Jesuska mamanwa wawkinkunawa ñukanchi paypa runankunawa pakta Kapernaum llaktama rirkanchi. Chay llaktapi masna punchakunallata karkanchi. ");
INSERT INTO qupNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Karan wata ñukanchi israel runakuna tantaripayanchi Yaya Dios Egipto allpamanta yaya rukunchi wañukunata ñawpa llukshichishkanmanta payta agradesinanchipa. Ña paktarihushpan tantarinanchi Paskua punchakuna Jesuspas chay punchakunarayku Jerusalén llaktama rirka. ");
INSERT INTO qupNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Chaypi paktashpan Yaya Diospa wasin kincha ukupi tarik rirka achka runakuna wakrakunata, obehakunata, wiwa mukukukunatapas rantichihushkakunata. Shukkunaka chaypi karkakuna chikan kullkikunata ñukanchi israel runakunapa kullkinchikunawa kampyanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Chasna rurahushkankunata rikushpan Jesuska waskakunata apishpan kawpurka asutinrayku. Chaywa chaypi kullkita kampyahukkunata tukuy rantichihukkunatapas obehankunawa pakta, wakrankunawa pakta llukshichirka. Kullkita kampyahukkunapataka mesankunata tankashpan tukuy kullkinkunata shikwachirka. ");
INSERT INTO qupNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Wiwa mukukuta rantichihukkunataka rimarka: Kaymanta kay wiwaykichikunata llukshichiychi. Ama Yayaynipa wasinta rantichina wasita ruraychichu. ");
INSERT INTO qupNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Chayta rikushpanchi ñukanchi paypa runankunaka yuyarirkanchi Salmos killkapi killkarishkata paktachihushkanta. Chaypimi kasna nin: Wasikita yapa alichanata munashpayni wañunayni tiyan nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Chaypi ñukanchi israel runakunapa apunchikuna Jesusta tapurkakuna: ¿Kasna rurashpayki pimi kani nishpataya kan kikinmanta yuyarinki? Yaya Diospa kamachishkan runa kashpaykika Yaya Diospa yachayninwa nima ima uras rikushkanchita rurashpayki ñukanchita rikuchiy. ");
INSERT INTO qupNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesuska aynirka: Kay Yaya Diospa wasinta urmachishpa waklichiychi. Chaywasha ñukaka kimsa punchapi atarichisha kay wasita. ");
INSERT INTO qupNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Chayta uyashpankuna rimarkakuna: ¿Imashnataya rimanki kimsa punchapi atarichisha nishpa? Chusku chunka sokta watata tarawashkakuna kay Yaya Diospa wasinta ruranankunapa. Kunankama manara paktachinahunrachu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Chay Yayan Diospa wasinmanta rimahushkanka payta wañuchishpankuna kimsa punchamanta kawsarinanmantami rimarka. ");
INSERT INTO qupNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Chayrayku Yaya Dios payta wañushkanmanta kawsachishkanwasha ñukanchi runankunaka chasna rimashkanta yuyarirkanchi. Yaya Diospa killkachishkanta yachakushpanchi chaymantapas Jesuspa rimashkanta yuyarishpanchi shutipa kanankunata yacharkanchi Jesús chaykunata paktachishkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesús Paskua punchakunarayku Jerusalén llaktapi kahushpanra achka runa masinchikuna atun yachaywa nima ima uras rikushkanchita rurahushkanta rikushpankuna Yaya Diospa kachashkan kananta kirirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Chasna kashpanpas Jesuska mana ashwanta paykunata rimarkachu pay kikinmanta pimi kan nishpa. Tukuy ñukanchi runakunapa shunkunchikunata riksik kashpan chay runakuna mana shunkunkunamanta pacha paypi sinchikuhushkankunata yacharka. ");
INSERT INTO qupNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Payka mana munarkachu nima maykan runa payta rimak shamunanpa. Pay kikinllami runakunapa shunkunkunata riksirka. ");
INSERT INTO qupNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Tiyarka shuk runa Nikodemo shutiyu. Payka karka fariseo. Fariseokuna atipashkankunata ruranahun Moisés wañupa killkashkan kamachishkakunata alita paktachinankunapa. Chaymantapas Nikodemoka karka ñukanchi israel runakunapa apunchikunawa pakta apullatata. ");
INSERT INTO qupNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Chay runaka shuk tuta pakalla Jesusta pasyak rirka. Chaypi paktashpan rimarka: Yachachik, yachanchi Yaya Diospa kachashkan ñukanchita yachachik kanaykita. Yaya Dios kanta yanapashpanllami atipanki tukuy chay nima ima uras rikushkanchita ruranata. ");
INSERT INTO qupNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Chaypi Jesuska aynirka: Alita uyaway. Maykanmi mana mushumanta wawayarinchu, chayka manami Yaya Diospa kamachishkan tukushpa paypa ali kamachihushkanpi kawsankachu. ");
INSERT INTO qupNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Chayta uyashpan Nikodemoka tapurka: ¿Imashnataya shuk ruku runaka atipama mushumanta wawayarinata? Manami atipanchu mamanpa wiksanpi kutikashka yaykunata wawayarinanpa. ");
INSERT INTO qupNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesuska aynirka: Alita uyaway. Maykanmi runamanta wawayarishpan mana chasnallatata Yaya Diospa Espiritunmanta mushu runa tukushpanka payka manami Yaya Diospa kamachishkan tukushpa paypa ali kamachihushkanpi kawsankachu. ");
INSERT INTO qupNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Maykanmi runamanta wawa tukushka chayka runallatatami kan. Chasnallatata maykanmi Yaya Diospa Espiritunmanta mushu runa tukushka, chayka Yaya Diospa Espiritunpa kushkan kawsayyumi kan. ");
INSERT INTO qupNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Tukuymi mushumanta wawayarinaykichi tiyan nishpa rimashkaynita uyashpayki ama yuyarishpalla kipariychu. ");
INSERT INTO qupNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Wayrata yuyariy. Kunkaymanta maymantapas wayran. Mana yachanchichu maypimi kallarishka chaymantapas maypimi pasarinka nishpa. Mana wayrata asirtashpanchipas wayrashkanta uyanchimi. Chasnashinami runakunaka mana asirtashpankunapas imashnami Yaya Diospa Espíritun shuk runata mushuyachishkanta, chay runa mushu tukushkantaka yachanahunmi. ");
INSERT INTO qupNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Chaypi Nikodemoka kutikashka tapurka: ¿Imashnataya chayka? ");
INSERT INTO qupNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesuska aynirka: ¿Kanka ñukanchi israel runakunata yachachik kashpaykitatachu mana yachanki imamantami rimahuni? ");
INSERT INTO qupNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Alita uyaway. Ñuka runaynikunawa pakta yachashkanchitami rikushkanchitami yachachinchi. Chasna shutipa kashkata yachachishpanchipas kankuna apunchikuna mana munankichichu kirinata. ");
INSERT INTO qupNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ñuka kankunata kay allpapi pasahushkanmanta rimashpayni mana kiriwankichichu. ¿Imashnataya kiriwankichima silupi pasahushkanmanta yachachinimaka? Manami kirinkichimachu. ");
INSERT INTO qupNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nima maykan runa siluma sikashkachu chaypi kawsashpan silupi pasahushkanmanta yachakunanpa. Ñuka Yaya Diospa Kachashkan Runallami silupi kawsashpayni kay allpama shamushkani. Ñukallami kankunata atipani tukuy chaykunamanta yachachinata. ");
INSERT INTO qupNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Ñawpa Moisés wañuka chunlla chakishka allpapi bronsemanta machakuyata kaspipi watashpan shayachirka. Yaya rukunchi wañukunaka chay warkurihushkata rikushpankuna wañunankuna kashkankunamanta kishpirkakuna. Chasnashinami ñuka Yaya Diospa Kachashkan Runatapas alsawankakuna. Runakunaka ñuka alsashkankuna runapi sinchikushpankunaka wiñayparayku chinkarinankuna kashkankunamanta kishpinkakuna wiñaypa Yaya Dioswa kawsanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Yaya Dioska ñukanchi runakunata yapa yuyashpan shuklla Wawanta payshina Yaya Diosllatata kay allpama kacharka uchanchikunarayku wañunanpa. Chasna Wawanta kachashpanmi tukuy paypi sinchikukkunaka manana anchurishka paymanta wiñaypa parisishunchichu, ashwan paywana wiñaypa kawsashunchi. ");
INSERT INTO qupNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Yaya Dioska manami Wawantaka kay allpama kacharkachu ñukanchi runakunata kastigananpa. Ashwan paytaka kacharkami uchanchikunarayku wiñaypa kastigarina kashkanchimanta kishpichinanpa. ");
INSERT INTO qupNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Maykan runami Yaya Diospa Wawanpi sinchikun payka manami kastigarinkachu. Maykan runami mana sinchikunchu paypa Wawanpi, payka ñami kastigarishka kan, shuklla Wawanpi payshina Yaya Diosllatata kashkapi mana sinchikushkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kasna kan imashnami runakuna kastigarishka tukurkakuna: Chay punchashina ali ruranakunata riksichik runami kay allpama shamushpan payta mana kasunayashpankuna chiknirkakuna. Amsapishina kawsashpankuna uchata rurashpalla katirkakuna. Rurashkankunaka millaypa kashkanrayku chay mana ali kawsanata ashwan munarkakuna chay ali kawsanamanta. ");
INSERT INTO qupNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tukuy millaypata rurak runakunaka mana munanahunchu uchankunata riksinata. Chayrayku chay punchashina ali ruranakunata riksichik Kristuta chikninahun. Mana munanahunchu paypi sinchikunata pay mana riksichinanpa imashna millaypami rurashkankunaka. ");
INSERT INTO qupNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Tukuy ñukanchi Yaya Diospa munashkanta rurak runakunaka mana manchanchichu runa masinchikuna rurahushkanchikunata rikunankunapa. Ñukanchika punchata munanchi runa masinchikuna Yaya Diosta kasushpa kawsahushkanchikunata riksinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Chaywasha Jesuska ñukanchi runankunawa Jerusalén llaktamanta llukshishpanchi shuk partima rirkanchi chay Judea allpallapillatata. Chaypi Jesús runakunata bawtisahushpan masna punchakunata kiparirkanchi. ");
INSERT INTO qupNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Chay uras Juanpas bawtisahurka Judea allpamanta ashwan anakpi Enón shutiyu achka yaku wawakuna umapi, Salim llakta kuchupi, chaypi achka yaku tiyashkanrayku. Runakuna chayma rirkakuna, Juanpa rimashkanta uyashpankuna bawtisarinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Chay uras Juanka karselpi manara churay tukushkarachu kahurka. ");
INSERT INTO qupNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Chaypi payta katik runakunaka shuk israel runa masinchiwa rimanakurkakuna imashna rurashpami uchankunamanta mayllarishkashina Yaya Diospa rikushkanpi kankakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Paykunaka Juanta rimak rirkakuna: Yachachik, maykanmi kanwa karka Jordán yaku chimpapi, maykanmantami ñukanchita rimarkanki, payka kunanka bawtisahumi. Chaymantapas tukuy runakuna paytana katihunkuna. ");
INSERT INTO qupNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Chayta uyashpan Juanka paykunata rimarka: Yaya Dios payta yanapashkanraykumi runakuna katinahun. ");
INSERT INTO qupNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kankuna kikin uyashkankichi shutillata rimashkaynita kasna nishpayni: Ñukaka manami kanichu Yaya Diospa Kachanan Kishpichik, ashwan Yaya Diosmi kamachiwarka runakunata paymanta yachachinaynipa pay kikin manara yachachishpanra nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ñukami kani shuk amigunta warmiyachik runashina. Shuk runa warmiyanayashpan paypa amigun warmita tapukrin. Ari nishpanka chay warmiwa amigunta kasarachin. Chay amigunka chay warmita mana tapunchu pay kikinrayku ashwan tapunmi amigunrayku. Chay warmiyak runa kasarahushpan amigunka atuntami kushikun warmiyahushkan warmiwa kushilla kwintahushkanta uyashpan. Ñuka chay amigunta warmiyachik runashina kashpayni kunanka atunta kushikuhuni runakuna paytana katihushkankunamanta rimawahushpaykichi. Ñami paktachishkani Yaya Dios kamachiwashkanta. ");
INSERT INTO qupNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Kunanka ashwan ashwan runakunaka paytana uyanahuchun. Ñukataka sakiwanahuchun nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Chay runa silumanta shamushkaka tukuymanta ashwan yachakmi kan. Ñukanchi kay allpapi kawsak runakunaka allpapi tiyashkakunallata yachanchi, chaykunamantalla rimanchi. Silumanta shamushka runaka chaypi tiyashkakunatapas riksin. Chayraykumi payka tukuymanta ashwan yachak kan. ");
INSERT INTO qupNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Silupi rikushkantami uyashkantami riman. Chasna shutipa kashkata rimashpanpas achka runakuna payta mana kirinahunchu. ");
INSERT INTO qupNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Shuk runa paypa rimashkanta kirishpanka yachankami shutipa kashkata rimashkanta. Payka kasna runa masinkunata rimahukshinami kan: Yaya Dioska rimashkanta paktachikmi kan nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Yaya Dios paypa kachashkan runata mana mitsashpachu Espiritunta kun. Chayrayku paypa rimashkantami runakunata riman. ");
INSERT INTO qupNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Yayan Dioska Wawantaka yuyanmi. Chayraykumi payta tukuymanta kamachikta rurarka. ");
INSERT INTO qupNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Maykan runami Yaya Diospa Wawanta kirishpa kawsan payka wiñaypami Yaya Dioswa kawsanka. Maykan runami Yaya Diospa Wawanta mana kasushpa kawsanchu, payka manami Yaya Dioswa kawsankachu ashwan paypa kastiganan runami kiparinka. ");
INSERT INTO qupNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Jesús runakunata yachachinata kallarishpan fariseokuna uyarkakuna Bawtisak Juanta katihushkankunamanta ashwan achka runakuna Jesusta katihushkanchikunata. Chaymantapas uyarkakuna Jesús paymanta ashwan achka runakunata bawtisahushkanta. Chasna uyashpankunapas manami Jesuschu bawtisarka ashwan ñukanchi runankunami bawtisarkanchi. Jesuska fariseokuna paymanta uyashkankunata yachashpan chay kawsanankuna Judea allpamanta llukshirkanchi Galilea allpama kutinanchipa. ");
INSERT INTO qupNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Chasna Jesuswa kutihushpanchi Samaria allpa chawpita pitikta rirkanchi. Ñukanchi israel runakuna chaypi kawsak runakunawa mana kwintak kashpanchipas Yaya Dios munashkanrayku kay allpata pasananchi tiyan nishpa rirkanchi. ");
INSERT INTO qupNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ña Samaria allpata pasahushpanchi shuk llakta Sikar shutiyu mayanpi paktarkanchi. Chay llaktaka Jakob wañupa wawan José wañuta allpata kushkan mayanpimi karka. ");
INSERT INTO qupNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Chaypi tiyarka shuk poso allpa ukumanta tukyarik yakuwa. Chay yakuta Jakobka allpata allashpan rumiwa kinchashkanrayku Jakobpa poson nirkakuna. Karuta purishkanchirayku yapa sampayashka kashpan Jesuska chay poso mayanpi tiyarirka. Chasna uras manara chawpi punchachu karka. ");
INSERT INTO qupNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ñukanchi runankunaka llaktama rirkanchi mikunata rantinanchipa. Rishkanchiwasha paktarka shuk samaritano warmi yakuta wishinanpa. Chaypi chay warmita Jesuska tapurka: Kuway yakuta nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ñukanchi israel runakuna samaritano runakunawa mana kwintak kashkanchirayku chay warmika Jesusta aynirka: ¿Imashnataya kanka israel runa kashpaykitata yakuta tapuwanki ñuka samaritano warmitaka? ");
INSERT INTO qupNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Chaypi Jesuska aynirka: Kan yachankimaka Yaya Dios runakunata kunayahushkanta, chaymantapas pimi kanta yakuta tapuhukka, ñukatami wiñaypa tukyarik yakuta tapuwankima. Chasna tapuwankimaka ñukami kanta kuynima. ");
INSERT INTO qupNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Chaypi chay warmika aynirka: Nima imawa yakuta wishinaykipa tiyanchu. Kay posopika ukupimi yakuka. ¿Maymantata yakuta kuwankima? ");
INSERT INTO qupNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ñawpa yaya rukunchi Jakob wañuka kay posota ñukanchirayku sakirka. Payka kay posomanta upyarka wawankunawa achka wiwankunawa pakta. Ñukanchipas kay posomantallatata upyahunchi, kunankama yakuka mana tukurinchu. ¿Kanchu kanki yaya rukunchi Jakobmanta ashwan yachak ñukanchita wiñaypa tukyarik yakuta kunaykipa? ");
INSERT INTO qupNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Chaypi Jesuska aynirka: Tukuy kay yakuta upyak runakunaka kutikashkami yakunayankakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ñuka yakuta kushkaynita upyashpankunaka mananami yakunayankakunachu. Shuk runata chay yakuta kushpaynika paypi mana tukurik tukyarik yakushina tukunka wiñaypa kawsananpa, manana nima ima payta pishinkanachu. ");
INSERT INTO qupNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Chasna Jesús rimashkanta uyashpan chay warmika rimarka: Chay yakuta kuway manana yakunayanaynipa, manana wishinaynipa kay yakuta. ");
INSERT INTO qupNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesuska rimarka: Kusaykita kayakriy, chaymanta kutikashka shamunki. ");
INSERT INTO qupNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Chay warmika aynirka: Mana tiyawanchu kusaynika. Jesuska rimarka: Alitami rimawashkanki manami kusaynika tiyawanchu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kanka pichka kusayumi kashkanki. Kunanka maykan runawami kawsahunki chayka manami kusaykichu. Chayrayku rimawashkaykika shutipami. ");
INSERT INTO qupNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Chay warmika rimarka: Yaya Diospa yachayninwa yachachikmi kanki. ");
INSERT INTO qupNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Chasna kashpayki yuyarishkaykita rimay. Ñukanchi samaritano runakunapa yaya rukunchi wañukunaka Yaya Diosta mañapayarkakuna kay rikuhushkayki urkupi. Kankuna israel runakunaka rimankichi Jerusalenpimi runakuna Yaya Diosta mañanankuna tiyan nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Chaypi Jesuska aynirka: Kay rimashkaynita kiriy. Nima rinaykichi tiyannachu chay urkuma nima ñukanchi Jerusalenma rinanchi tiyannachu. Kunan ña paktarihun Yaya Diosta tukuy parti mañashpa kushichinaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kankunaka mana yachankichichu pitami mañankichi. Runakuna ñukanchikunamanta kishpichirina kashpankuna ñukanchi israel runakunami yachanchi pitami mañanchi. ");
INSERT INTO qupNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kunan ña runakuna tukuy shunkunkunamanta pacha Yaya Diosta kushichishpa mañankakuna. Yaya Diospa Espíritun paykunata yanapashpanmi yuyachishkanshina Yaya Diosta kushichishpa mañankakuna. Chasna tukuy shunkunkunamanta pacha mañak runakunatami munan Yaya Dioska. ");
INSERT INTO qupNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Payka mana ñukanchishina aychayu kashpan paytaka mana rikunchichu. Payka tukuyta atipakmi kan. Chasna mana runashina kashpanmi Yaya Diospa Espíritun ñukanchikunata yuyachishpanlla yachanchi imashnami tukuy shunkunchimanta pacha payta kushichishpa mañanchi. Chasnallami payta mañashpa shutipa kushichinchi. ");
INSERT INTO qupNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Chaypi chay warmika rimarka: Ñuka yachani chapahushkanchi Yaya Diospa Kachanan Kishpichikka shamunanta, maykantami rimanchi Kristu. Pay shamushpanmi tukuyta ñukanchita asirtachinka. ");
INSERT INTO qupNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesuska aynirka: Ñuka kanwa kwintakmi chay rimahushkayki runaka kani. ");
INSERT INTO qupNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Chasna kwintahushkankunapi ñukanchi runankunaka paktarkanchi. Jesús shuk warmiwa kwintahushkanta rikushpanchi mancharirkanchi. Chasna mancharishpanchipas nima maykan tapunayarkanchichu: ¿Imatata chay warmita tapunki? ¿Imamantata chay warmiwa kwintahunki? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Chaypi kahushkanchipi chay warmika yakuta wishinan tinahanta sakishpan kallpa rirka llaktanma runakunata kayak rinanpa. ");
INSERT INTO qupNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Shamuychi, tinkunakushkanimi shuk runawa. Aku rikuk rishunchi. Payka tukuy kawsashkaynitami rimawashka. Aku rikuk rishunchi, ¿manachari Yaya Diospa Kachanan Kishpichikchu? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Chasna chay warmi rimashpan runakuna llaktankunamanta llukshishpankuna Jesusta rikunankunapa rirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Manarapas chay runakuna paktamushpankuna ñukanchika Jesusta karanayarkanchi: Yachachik, mikuy. ¿Imaraykuta mana mikunayankichu? ");
INSERT INTO qupNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Payka ñukanchita aynirka: Ñukapaka ñami tiyan mikunaynika. Kankunaka chay mikunaynitaka manami riksinkichichu. ");
INSERT INTO qupNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Chaypi ñukanchipura tapunakurkanchi: Apamushkakunachari mikunata. ");
INSERT INTO qupNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Chasna tapunakuhushpanchi Jesuska ñukanchita rimarka: Mikunaynishinami kan ñukata kachawakpa munashkanta paktachishpayni. Paypa munashkanta rurashpayni mikushkashina kushilla yuyani. ");
INSERT INTO qupNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Shuk rimana kan kasna: Tarpushkanchiwasha chusku killamanta muyunkunata pallanchi nishpa. Kankunapas chay rimanashinallatata yuyarihunkichi. Ñukaka kankunata rimani, rikuychi chay achka runakuna shamuhushkakunata. Paykunaka ña Yaya Diosta kasunankunapami kahunkuna. Paykunata rikuhunimi pukushka muyukunashina chapahushkankunata pallananchipa. ");
INSERT INTO qupNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Paykunata Yaya Diospa shiminta yachachishpanchi shutipa paymanta kanaynita kirinkakuna. Kirishpankuna wiñaypa Yaya Dioswa kawsankakuna. Chasna kashpanmi yachachishkanchimanta pagay tukushkashina kashunchi. Ñawpa paykunata yachachikkuna karkakuna shuk muyukunata tarpuk runakunashina. Ñukanchi chay muyukunata pallak runakunashinami kanchi. Chasna kashpanchimi tukuy parihu atunta kushikushunchi. ");
INSERT INTO qupNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kankunapi tiyan shuk rimana kasna nishpa: Shuk runa tarpun muyukunata chakranpi shuk runana chaykunata pallan nishpa. Chay rimanaka shutipami. ");
INSERT INTO qupNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ñukami kankunata kamachishkani mana tarpushkaykichi muyukunata pallanaykichipa. Shuk runakuna sinchita chakranpi tarawashpankunapas pichashpankuna tarpushpankunapas mana pallashkakunachu, kankunana pallankichi. Kay samaritano runakunata yachachikkunami kashkakuna sinchita chakranpi tarawak runakunashina. Kankunana paykunata mana yachachishpaykichipas kasuwashkankunatana rikushpaykichi pallak runakunashina kankichi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Achka chay Sikar llaktapi kawsak samaritano runakuna Jesuspi sinchikurkakuna chay warmi tukuy kawsashkaynitami rimawashka nishpa kwintak rishkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Paykuna Jesuspi paktamushpankuna payta yapa munashpankuna kipariy ñukanchiwa nishpa rimarkakuna. Chasna rimashpankuna Jesuswa pakta ishkay punchata paykunawa kiparirkanchi. ");
INSERT INTO qupNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Chasna kiparishpanchi ashwan achka samaritano runakuna pay kikinpa yachachishkanta uyashpankuna kirirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Chaypi chay warmita rimarkakuna: Kunanka kirinchimi mana kan ñukanchita rimashkaykiraykuchu ashwan kirishkanchimi ñukanchi kikin kay runapa yachachishkanta uyashkanchirayku. Kunan yachanchi pay shutipa tukuy runakunata Kishpichik kananta. ");
INSERT INTO qupNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ishkay punchata Samaria allpapi kahushkanchiwasha Galilea allpama rirkanchi. ");
INSERT INTO qupNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Chay kikin allpanma rirkanchi Jesuska rimashka kashpanpas kasna: Shuk runa Yaya Diospa yachayninwa yachachiktaka pay kikinpa llaktanpi runa masinkunaka mana yachaktashinami rikunahun nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Chasna mana alita payta rikunankunata yuyarishpanpas Jesús Galilea allpanpi paktashpan tukuy chay llaktanpi runa masinkuna payta alita rikurkakuna. Jerusalén llaktama Paskua punchakunata pasanapa rishkankunapi Jesús tukuy mana atipaypakunata rurashkanta rikurkakuna. Chayrayku kutishpankuna alita yaykuchirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesús Galilea allpapi rihushpan Kaná llaktapi paktak rirka. Chay llaktapimi payka chayra yachachinata kallarihushpan yakumanta vinuta rurarka. Chay Kaná llaktamanta chawpi puncha parti purina tupupi Kapernaum llaktaka kahurka Galilea allpallapillatata. Chaypi tiyarka shuk kamachik atun apupa churashkan. Paypa wawan unkushka karka. ");
INSERT INTO qupNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Chay apuka Jesús Judea allpamanta Galilea allpapi paktashkanta yachashpan payta rikunapa rirka. Jesuspi paktamushpan yapa munarka payta wasinma pushanata wawanta ampinanpa. Yapa wañunalla kashpan Jesusta rimarka: Kanka atipankimi unkushkata ampinata. Shamupay llaktaynima wawaynita ampinaykipa. ");
INSERT INTO qupNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Chaypi Jesuska aynirka: Kankunaka tukuy uras munankichi atun yachaywa nima ima uras rikushkaykichita rurashkaynita rikunata. Mana rikushpaykichika mana kirinkichichu. ");
INSERT INTO qupNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Chay apuka aynirka: Aku utkalla manarapas wawaynistuka wañushpanra. ");
INSERT INTO qupNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Chaypi Jesuska rimarka: Kutiy wasikima, wawaykika ampirishkami. Chay apuka Jesuspa rimashkanta kasushpan wasinma kutirka. ");
INSERT INTO qupNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Chasna wasinma kutihushpan kamachinan runakunaka payta tinkunapa shamurkakuna kasna nishpa: Ñami wawaykika ampirishka. ");
INSERT INTO qupNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Chay apuka tapurka: ¿Ima urata wawaynika aliyanata kallarishka? Paykunaka aynirkakuna: Kaynami chawpi puncha kinkrayashkapi kalinturanta pasachishka. ");
INSERT INTO qupNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Chaypi chay apuka yuyarirka chasna uras Jesús payta rimashkanta, wawaykika ñami ampirishka nishpa. Chasna wawan ampirishpan chay apuka tukuy ayllunkunanti Jesuspi sinchikurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Chay wawata ampishpan nima ima uras rikushkanchita Jesuspa ishkaynin rurashkan karka runakunata yachayninta rikuchinanpa. Chaytaka rurarka Judea allpamanta Galilea allpapi paktashkanchiwasha. ");
INSERT INTO qupNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Chaymanta masna punchakunapi ñukanchi israel runakunapa shuk tantarina Jerusalenpi tiyarka kushikushpa Yaya Dios ñukanchita yanapashkanta yuyarinanchipa. Chayrayku Jesuska Jerusalenma rirka. ");
INSERT INTO qupNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalén llaktapa kincharishkanpi shuk punku tiyarka obehakunapa punku shutiyu. Chay punku mayanpi shuk yaku karka Betsata shutiyu. Chay yaku mayanpi pichka wasikuna tiyarka unkushkakuna chaypi kanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Chaypi achka unkushkakuna karkakuna, wiskukuna, waklishka chakiyukuna, aycha chakirishkakunapas, chay yaku kuyurishpan yaykushunchi ampirinanchipa nishpa yuyarikkuna. ");
INSERT INTO qupNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Chay unkushkakunamanta shuk tiyarka kimsa chunka pusak watata unkushka. ");
INSERT INTO qupNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesuska chay unkushkata rikushpan unaymanta pacha unkushka kashkanta yachashpan payta tapurka: ¿Munankichu ampirinata? ");
INSERT INTO qupNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Chay unkushkaka aynirka: Manami nima maykan tiyanchu kay yaku kuyurihushpan churawananpa chaypi ampirinaynipa. Karan kuti rihushpayni shukkunarami satirinahun manara paktahushpayni. ");
INSERT INTO qupNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Chayta uyashpan Jesuska llakichishpan rimarka: Atariy, llanchamaykita apishpayki riy. ");
INSERT INTO qupNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Chay runaka chay ratulla ampirirka. Chasna ampirishpan llanchamanta patarichishpan apashpa alitana purishpa rirka. Chay punchaka ñukanchi israel runakunapa samananchi punchami karka. ");
INSERT INTO qupNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Chaypi apunchikunaka chay ampirishka runata rimarkakuna: Kunan kan samana puncha. Mana atipankichu llanchamaykita apanata. ");
INSERT INTO qupNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Chay runaka aynirka: Maykanmi ampiwashka paymi rimawashka: Llanchamaykita apishpayki riy nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Chay runapa rimashkanta uyashpankuna apunchikunaka tapurkakuna: ¿Pita kanta rimashka: Llanchamaykita apishpayki riy nishpa? ");
INSERT INTO qupNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Chay runaka mana yacharkachu pimi karka chay payta ampik runaka. Chaypi achka runakuna kashpankuna Jesuska payta ampishkanwasha runakuna chawpipi yaykushpan manana riksiypanachu karka. ");
INSERT INTO qupNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Chay apunchikuna tapushkankunawasha Jesuska chay runata maskashpan Yaya Diospa wasinpi kahushkata tarirka. Chaypi payta rimarka: Uyaway, kunanka ña ampirishkanki. Mana kuti uchata ruraynachu, mana chay unkushkaykimanta ashwan tukunaykipa. ");
INSERT INTO qupNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Chasna Jesús rimashpan chay runaka apunchikunata rimak rirka: Jesusmi ampiwashka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Chasna Jesús samananchi punchapi ampishkanrayku chay apunchikunaka payta wañuchinayarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Chaypi Jesuska rimarka: Yayaynika mana samashpachu tukuy urasmi alikunata ruran. Ñukapas chasnallatatami rurani. ");
INSERT INTO qupNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Chayta uyashpankuna apunchikunaka piñarirkakuna. Payta wañuchinayarkakuna samananchi puncha mana rurananchipa kamachirishka kashkata mana kasushkanrayku. Chaymantapas ashwan wañuchinayarkakuna kikin Yayaynimi Yaya Dioska nishpa rimashpan ñukapas Yaya Diosmi kani nishpa rimahukshina tukushkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesuska rimarka: Alita uyawaychi. Ñuka Yaya Diospa Wawanka, ñuka kikin munayka mana atipanichu nima imata ruranata. Yayaynipa rurahushkanta yachashpami tukuy uras chasnallatata rurani. Tukuy imatapas Yayaynipa rurahushkantashinallami ñuka Wawanpas rurani. ");
INSERT INTO qupNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Yayaynika ñukata yuyawashpanmi tukuy rurahushkanta riksichiwan. Chaymanta ashwan atun mana atipaypakunatami ruranaynipa ñukata riksichiwanka kankuna rurashkaynikunata rikushpaykichi mancharishpa kiparinaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Imashnami Yaya Dioska wañushkashina kawsak mana payta riksik runakunata kushilla paywa kawsayta kun, chasnallatatami ñuka Wawanpas chasna kawsayta kuni maykankunatami munani. ");
INSERT INTO qupNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Chaymantapas Yaya Dioska ñuka Wawantami tukuy yachayninta kuwashka runakunata tapunaynipa imashna kawsashkankunamanta, chaymantapas rimanaynipa pimi kastigarinka pimi wiñaypa paywa kawsanka nishpa. Pay kikinka manami nima maykanta tapunkachu: Kanka ¿imashnata kawsashkanki? nishpa. Ñuka Wawantami chasna ruranaynipa kamachiwashka. ");
INSERT INTO qupNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Chayta ruranaynipami payka yachayninta kuwashka, tukuy runakuna tukuymanta yachak kanaynita rikushpankuna paytashina kushichiwanankunapa. Maykan runami ñuka Yaya Diospa Wawanta mana kushichinchu, chayka manami Yayayni Dios ñukata kay allpama kachawakta kushichinchu. ");
INSERT INTO qupNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Alita uyawaychi. Maykan runami alita uyashpan rimashkaynita kasun, chaymanta Yaya Dios kachawashkanta kirin, paymi chay kirishkanmanta pacha wiñaypa Yaya Dioswa kawsanka. Chay runaka manami kastigarinkachu ashwan chay kastigarina kashkanmantami kishpichiy tukushkana wiñaypa Yaya Dioswa kawsananpa. Paymi wañushkashina kashkanmanta kawsarishkashinana tukushka. ");
INSERT INTO qupNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Alita uyawaychi. Kunanmanta pacha wañushkashina kahuk runakunaka ñuka Yaya Diospa Wawanpa shiminta uyankakuna. Maykankunami uyashpankuna kasuwanahun, paykunaka chay kasushkankunamanta pacha wiñaypami Yaya Dioswa kawsankakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Yaya Dioska wiñaypa kawsayyumi. Chaymantapas payllatatami chay paypa wiñaypa kawsayninta kukmi kan. Ñuka Wawantapas kuwashka payshina wiñaypa kawsayyu kanaynipa, ñukapas chasnallatata paypa wiñaypa kawsayninta runakunata kunaynipa. ");
INSERT INTO qupNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Chaymanta ñuka Wawan runa masikichi kashpayni Yaya Dioska yachayninta kuwashka payranti tukuy runakunata kawsashkankunamanta tapunaynipa, chaymantapas rimanaynipa pimi kastigarinka pimi wiñaypa Yaya Dioswa kawsanka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Kay rimahushkaynita uyashpaykichi ama yuyarishpa kipariychichu. Shuk punchami tukuy wañushkakunaka pamparishkankunamanta churarishka kahushkankunamantapas uyankakuna ñuka Yaya Diospa Wawan kayahushkaynita paykunata. ");
INSERT INTO qupNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Chay urasmi wañushkakunaka kawsarishpankuna llukshinkakuna pamparishkankunamanta churarishka kahushkankunamantapas. Kawsashpankunara alita rurashkakunataka yaykuchishami wiñaypa Yaya Dioswa kawsanankunapa, mana alita rurashkakunataka kachashami wiñaypa parisinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Yaya Dios kamachiwashpanmi rimani, kanmi kastigarinki, kanmi kishpinki nishpa. Ñuka munay manami atipaynimachu nima imata ruranata. Chasna Yaya Diospa munashkanshina rimashpayni chay rimashkaynika alillami kan. Ñuka kikin munashkaynitaka manami ruranichu ashwan Yaya Dios kay allpama kachawakpa munashkantami rurani. ");
INSERT INTO qupNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Jesuska apunchikunata yachachishpalla katirka: Ñukalla rimaynimaka Yaya Diosmanta kanaynita atipankichima ñukamanta rimanata llullachihumi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Mana ñukallachu chasna ñuka kikinmanta rimani. Yaya Diospas paymanta kanaynita riman. Yachani ñukamanta rimashkanka shutipami. ");
INSERT INTO qupNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Juanma kacharkankichi ñukamanta yuyarishkanta tapunaykichipa. Paymi kankunata shutipata ñukamanta rimashka, Yaya Diospa Kachashkan Kishpichik nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ñuka mana munanichu nima maykan runa ñukamanta rimananpa pimi kani nishpa. Chasna Juan ñukamanta yachachishkanta rimani kankunata yanapanaynipa, kirishpaykichi atun kastigumanta kishpinaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juanka shuk lámpara sintihushpan punchayachikshina karka. Paypa rimashkanka amsata punchayachikshina kashpan payta uyashpaykichi shuk ratu kushikushkankichi. ");
INSERT INTO qupNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Juan alita ñukamanta rimashpanpas rurashkaynikunaka Juanmanta ashwan pasatami rikuchinahun Yaya Diosmanta kanaynita. Runakuna Yaya Diospa kamachiwashkanta rurashkaynikunata rikushpankunami shutipa paypa kachashkan kanaynita riksinahun. ");
INSERT INTO qupNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Chaymantapas ñukata kachawak Yaya Dios kikinpas ñukamanta paypa kachashkan kanaynita riman. Shiminta kankunaka nima ima uras uyashkankichichu, nima payta rikushkankichichu imashnami kan nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Uyashkaykichi shiminta shunkuykichipi manami wakaychankichichu ñuka Yaya Diospa Kachashkan Runata mana kirishkaykichirayku. ");
INSERT INTO qupNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kankunaka tukuy uras Yaya Diospa shimin killkarishka kashkata yachakunkichi. Yuyarinkichi, chasna rurashpanchimi yachashunchi imashna rurashpami wiñaypa Yaya Dioswa kawsashunchi nishpa. Chay yachakuhushkaykichi killkarishkakunapi ñuka chay kawsayta kukmantami riman. ");
INSERT INTO qupNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Chasna kashpanpas kankunaka manami munankichichu kasuwanata shutipa wiñaypa Yaya Dioswa kawsanaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Kankuna mana munawashpaykichipas ñukarayku mana imananchu. Manami maskanichu runakuna kushichiwanankunata. ");
INSERT INTO qupNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Kankunata riksishpaynimi yachani Yaya Diosta mana yuyak kanaykichita. ");
INSERT INTO qupNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yayayni Dios kikin kachawashpanmi ñuka shamushkani runakunata payta riksichinaynipa imashnami kan. Paypa kachashkan kashpaynipas kankunaka mana munawankichichu. Shuk runa pay kikin munay shamumaka chaytami shuti kankunaka munankichima. ");
INSERT INTO qupNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kankunapura yapa munankichi shukta shukta kushichinakushpa kawsanata, kanka yachakmi kanki nishpa. Mana ashwan maskankichichu shuklla Yaya Dios kankunata rimananpa ali runami kanki nishpa. Chasna kashkaykichirayku manami atipankichichu kiriwanata. ");
INSERT INTO qupNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ñukaka mana rimak rishanchu Yayaynita kankunamanta mana kiriwashkakunachu nishpa. Moisesmi rimak rinka kankunamanta. Yanka yuyarinkichi Moisés wañupa killkashkanta paktachishkanchiraykumi wiñaypa kawsashunchi Yaya Dioswa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moisés shamunaynimanta killkashpan paypa killkashkanta kirinkichimaka ñukatapas kiriwankichimami. ");
INSERT INTO qupNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Moisespa killkashkanta mana kirishpaykichimi ñukapa rimashkaynitapas mana kirinkichichu. ");
INSERT INTO qupNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Chaymanta Jesuska kutikashka ñukanchi runankunawa pakta Galilea allpapi kashpan chay Galilea kuchata chimparkanchi. Chay kuchapa shuk shutinka karka Tiberias kucha. ");
INSERT INTO qupNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","3","Chaypi paktashpanchi shuk urkuma sikarkanchi. Chaypi tiyarirkanchi. Achka runakuna yaku mayanta muyurishpankuna ñukanchita katirkakuna. Atun yachaywa mana ampiypa unkushkakunata Jesús ampishkanta rikushpankuna payta katirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Chay uras mana achka punchachu pishirka ñukanchi israel runakunapa Paskua punchakuna kallarinanpa. ");
INSERT INTO qupNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Chay urkupi kahushpanchi Jesuska rikushpan achka runakuna payma shamuhukkunata rikurka. Chaypi Felipeta tapurka: ¿Maymantataya kay tukuy runakunaraykuka mikunata rantishunchi? ");
INSERT INTO qupNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesuska yachashpantata imashnami chay runakunata karanka, chasna Felipeta tapurka yachananpa tukuyta atipak kashkanta yuyarinchu manachu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Chaypi Felipeka aynirka: Achka kullkitami munanchima mikunata rantinanchipa chay tukuy runakunata karananchipa. Shuk runa pusak killapi ganashkan kullkiwa mikunata rantinchimaka nima chay paktamachu karan runata uchillastuta kunanchipa. ");
INSERT INTO qupNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Chaypi Jesuspa shuk runan Pedropa wawkin Andrés rimarka: ");
INSERT INTO qupNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Kaypimi tiyan shuk wawa. Paypa tiyan pichka pan nima imayukunapa mikunan trigumanta rurarishka, chaymantapas ishkay challwa. Kay uchillastuka imashi paktanka kay tukuy runakunaraykuka. ");
INSERT INTO qupNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Chaypi pastuyu allpa tiyashpan Jesuska aynirka: Rimaychi kay runakunata tiyarinankunapa. Kasushpankuna rimarkakuna tiyarinankunapa. Chaypi tukuy tiyarirkakuna. Karkakuna pichka waranka karikuna, mana yupashpa warmikunata nima wawakunata. ");
INSERT INTO qupNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Chaypi Jesuska chay pankunata apishpan Yaya Diosta agradesirka. Chasna agradesishkanwasha chay pankunata paki paki rurashpan runakunata kurka mikunankunapa. Chasnallatata challwatapas kurka saksakta mikunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Saksakta mikushkankunata rikushpan ñukanchi runankunata rimarka: Tantaychi tukuy chay puchurishkakunata mana usunankunapa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Chaypina chay pichka panmanta puchurishkakunata tantarkanchi chunka ishkay tasa untakta. ");
INSERT INTO qupNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Runakunaka chasna atun yachaywa nima ima uras rikushkanchita Jesuspa rurashkanta rikushpankuna rimarkakuna: Paymi kan chapahushkanchi Yaya Diospa yachayninwa yachachik Moisés wañushina, maykanmi shamunan karka kay allpama nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesuska chay runakuna payta mana munakta pushanayahushkankunata apunkunarayku musyashpan anchurirka. Kutikashka urku awama sikashpan sapallanna rirka. ");
INSERT INTO qupNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Chaymanta ña tutayahushpan ñukanchi Jesuspa runankuna kucha mayanma uraykurkanchi. ");
INSERT INTO qupNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Chaypi paktashpanchi ña tuta tukurka. Jesús ñukanchipi mana paktamushpan shuk botipi yaykurkanchi Kapernaum llaktama chimpananchipa. ");
INSERT INTO qupNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Chasna chay atun kuchata chimpahushpanchi yakuka yapa ulasyarka sinchi wayrawa. ");
INSERT INTO qupNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ña chimpahushpanchi pichka sokta kilometro chawpillapi Jesusta rikurkanchi yaku awata purishpa shamuhushkanta. Payta mana riksishpanchi mancharirkanchi. ");
INSERT INTO qupNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Chaypi Jesuska ñukanchita rimarka: Ñukami kani, ama manchariychichu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Jesusta botipi yaykuchinayahushpanchi musyarkanchi ña paktashkanchita maymami chimpahurkanchi. ");
INSERT INTO qupNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Chay panta mikuk runakuna chayllapi kiparirkakuna. Kayantima alita yuyarishpankuna panta mikushkankuna puncha shuklla boti chaypi tiyashkata yuyarirkakuna. Chaymantapas yuyarirkakuna ñukanchi Jesuspa runankuna sapallanchi chay shuklla botipi rishkanchita chaymanta Jesuska mana ñukanchiwa rishkanta. ");
INSERT INTO qupNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Chasna yuyarihushkankunapi Tiberias llaktamanta achka botikuna paktarkakuna maypimi Jesús Yaya Diosta agradesishkanwasha panta mikurkakuna chay kuchupi. ");
INSERT INTO qupNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Mana Jesusta nima ñukanchi runankunata rikuhushpankuna chaypi tantarishka kahuk runakuna botikunapi yaykushpankuna Kapernaum llaktama chimparkakuna Jesusta maskanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Chay runakuna chimpapi paktashpankuna Jesusta tarirkakuna. Chaypi tapurkakuna: Yachachik, ¿imashnataya shamushkanki kayma? ");
INSERT INTO qupNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesuska mana aynishpa tapushkankunata rimarka: Alita uyawaychi, kankuna aychaykichillata saksachinata munashpaykichi maskawankichi mikushkaykichirayku saksanaykichikama. Mana maskawankichichu atun yachaywa nima ima uras rikushkaykichita rurashkayniwa rikuchishkaynita asirtashkaykichirayku. ");
INSERT INTO qupNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ama maskashpa kawsaychichu tukurik mikunallata, ashwan maskaychi kankunata wiñaypa Yaya Dioswa kawsayta kuk mikunata. Chay mikunatami kuni ñuka Yaya Diospa Kachashkan Runa. Chasna kunaynipami ñukata kachawashka. ");
INSERT INTO qupNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Chaymanta tapurkakuna: ¿Imatata rurananchi tiyan Yaya Diospa munashkanta rurananchipa? ");
INSERT INTO qupNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesuska aynirka: Sinchikuychi ñuka paypa kachashkan runapi. Chayllatami Yaya Dioska munan. ");
INSERT INTO qupNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Chaypi tapurkakuna: ¿Maykan nima ima uras rikushkanchita atun yachaywa rurashpaykita kirinchima Yaya Diospa kachashkan kanaykita? ¿Maykantaya ruranaykikunaka? ");
INSERT INTO qupNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ñawpa yaya rukunchi wañukuna mana mikunata tariypa chunlla chakishka allpapi purishpa kawsahushpankuna karan puncha silumanta manata saksakta mikurkakuna. Kasnami killkarishka kan: Payka silumanta mikunata kacharka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesuska aynirka: Alita uyawaychi. Mana kashkachu Moisés, maykanmi yaya rukunchi wañukunata kushka silumanta mikunata. Yayaynillami silumanta mikunata kun, maykanmantami shutipa kawsankichi. ");
INSERT INTO qupNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Chay mikuna, maykantami Yaya Dioska kun, chayka silumanta shamushkami, runakunata wiñaypa Yaya Dioswa kawsayta kukmi. ");
INSERT INTO qupNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Chaypina paykunaka rimarkakuna: Yachachik, chay mikunata ñukanchita tukuy uras kuy. ");
INSERT INTO qupNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesuska aynirka: Ñukami kani chay wiñaypa Yaya Dioswa kawsayta kuk mikunamanta rimahushkaynika. Ñukapi sinchikuk runakuna nima ima uras shunkunkunapi yarkaywashina kankakunachu chaymantapas nima ima uras yakunayaytashina musyankakunachu. ");
INSERT INTO qupNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Kankunaka rikuwashpaykichipas ñukapi mana sinchikunayankichichu imashnami ña kankunata rimarkani. ");
INSERT INTO qupNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","38","Tukuy maykankunamantami Yayaynika rimashka ñukapa kanankunapa, paykunaka ñukapi sinchikunahun. Yayaynipa munashkanta rurashpa kawsahushpayni ñukapi sinchikuhukkunata manami rimashanchu kanta mana munanichu nishpa. Silumanta shamushkani ñukata kachawakpa munashkanta ruranaynipa. Mana shamushkanichu ñuka kikinpa munashkaynita ruranaynipa. ");
INSERT INTO qupNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ñukata kachawakmi munan karan kuwashkan runata alita kuyranaynipa. Mana munanchu nima shukta paykunamanta chinkachinaynipa. Ashwan munan paykunata kawsachinaynipa mundu tukurinan puncha. ");
INSERT INTO qupNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Munanmi tukuy ñukata rikushpankuna ñukapi kirik runakuna wiñaypa paywa kawsanankunapa. Mundu tukurinan puncha ñuka paykunata kawsachishami. ");
INSERT INTO qupNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Chasna rimashkanta uyashpankuna chaypi kahuk shuk apunchikunaka millaypata Jesusmanta rimarkakuna paykunapura. Payta piñarirkakuna ñuka kani silumanta mikunashina nishpa rimashkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Paykunapura kwintarkakuna: Paymi kan Josepa wawan Jesús. Riksinchi yayanta mamantapas. ¿Imashnataya nin silumantami shamushkani nishpa? ");
INSERT INTO qupNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesuska paykunata rimarka: Sakiychi chasna mana ali rimanaykichita. ");
INSERT INTO qupNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nima maykan atipanchu ñukapi sinchikushpa kasuwanata Yaya Dios ñukata kachawak mana yanapashpanka. Chay kasuwakkunataka kawsachishami mundu tukurinan puncha. ");
INSERT INTO qupNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Yaya Diospa yachayninwa ñawpa yachachikpa killkashkanpi riman: Yaya Dios tukuy runakunata yachachinka nishpa. Tukuy maykankunami Yaya Diospa yachachishkanta uyanahun yachakunahun, paykunami ñukapi sinchikushpa kasuwanahun. ");
INSERT INTO qupNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Chayta rimashpayni mana rimanayanichu shuk runa Yaya Diosta rikushkanta. Paytaka nima shuk runa rikushkachu. Ñuka Yaya Diosmanta shamushkallami payta rikushkani. ");
INSERT INTO qupNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Alita uyawaychi. Maykan runami ñukapi sinchikun payka Yaya Diospa kawsayninwami kan. ");
INSERT INTO qupNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ñuka kani silumanta mikunashina chay Yaya Dioswa kawsayta kuk. ");
INSERT INTO qupNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Yaya rukunchikuna chunlla chakishka allpapi manata mikurkakuna. Chasna silumanta mikuna nishkankunata mikushpankunatata wañurkakuna. Manami chay wiñaypa Yaya Dioswa kawsayta tarirkakunachu. ");
INSERT INTO qupNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ñukaka kankunata rimani shuk mikunamanta. Maykanchari chay silumanta mikunata mikun wiñayparayku Yaya Dioswa kawsanka. ");
INSERT INTO qupNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ñukami kani chay silumanta mikunashina Yaya Dioswa kawsayta kuk. Maykanmi chay mikunata mikun wiñayparayku paywa kawsanka. Chay mikunaka kanmi ñuka kikinpa aychayni. Runakunarayku wañushpayni chayta kusha Yaya Dioswa kawsanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Chasna uyashpankuna chay apunchikunaka shukwa shukwa rimanakurkakuna paykunapura: ¿Imashnataya kay runaka kuma mikunanchipa pay kikinpa aychantaka? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Chaypi Jesuska paykunata rimarka: Alita uyawaychi. Mana mikushpaykichika ñuka Yaya Diospa Kachashkan Runapa aychaynita, chaymantapas mana upyashpaykichika yawarnita manami shutipa kawsayyuchu kankichi. ");
INSERT INTO qupNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Maykan runami aychaynita mikun yawarnitapas upyan, payka shutipa kawsayyumi wiñaypa Yaya Dioswa kawsananpa. Ñukami payta kawsachisha mundu tukurinan puncha. ");
INSERT INTO qupNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ñukapa aychaynika shutipa mikunami, yawarnipas shutipa upyanami. ");
INSERT INTO qupNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Maykan runami mikun aychaynita, upyan yawarnita, payka wiñaypami ñukawa pakta kawsan. Ñukapas paywa pakta wiñaypa kawsani. ");
INSERT INTO qupNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tukuyta kawsayta kuk Yaya Dios ñukata kachawashka. Paymi ñukata kawsayta kuwashka ñukapas kunaynipa maykankunami aychaynita mikunahun. Imashnami ñuka kawsani Yayaynimanta, chasnallatatami aychaynita mikukkuna kawsanahun ñukamanta. ");
INSERT INTO qupNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kay aychaynika shutipa mikunami silumanta. Chay mikunaka manami kanchu yaya rukuykichi wañukunapa mikushkankuna manashina. Paykunaka mikushpankunatata wañurkakuna. Maykanmi silumanta shutipa mikunata mikun payka wiñayparaykumi Yaya Dioswa kawsanka. ");
INSERT INTO qupNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Chasna nishpa Jesuska runakunata yachachirka Kapernaum llaktapi tantarinanchi wasipi. ");
INSERT INTO qupNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Chasna yachachishkanta uyashpankuna Jesusta achka katikkuna kwintarkakuna paykunapura: Chay yachachishkanka sinchimi kan. Pikunashi atipankakuna chayta kasunata. ");
INSERT INTO qupNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesuska musyashpan mana alita rimahushkankunata tapurka: ¿Kay rimahushkaynillachu kankunata killachin? ");
INSERT INTO qupNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Imashnashi tukunkichima ñuka Yaya Diospa Kachashkan Runaka, maymantami shamushkani chaymallatata sikahushkaynita rikunkichimaka? ");
INSERT INTO qupNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Kankunata rimani, Yaya Diospa Espiritunmi kan shutipa kawsayta kuk. Runakunaka manami atipanahunchu chay Yaya Dioswa kawsayta kunata. Yaya Diospa Espíritun yuyachiwashpanmi kankunata yachachini. Paymi runakunata rimashkaynita yuyachishpa Yaya Dioswa kawsay mana tukurikta kun. ");
INSERT INTO qupNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kankunamanta shukkuna tiyan rimashkaynita mana kirikkuna. Chasna Jesuska rimarka puntirumanta pacha yachashpan pikunami payta mana kasunkakunachu, chaymantapas pimi payta apichinka. ");
INSERT INTO qupNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jesuska rimashpalla katirka: Chayta yachashpayni kankunata rimarkani nima pi ñukapi sinchikushpa kasuwamachu Yaya Dios payta mana yanapashpanka. ");
INSERT INTO qupNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Chasna rimashkanmanta pacha achka katik runakuna payta manana katirkakunachu. Kutirkakunana maymantami shamurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Chaypi Jesuska ñukanchi chunka ishkay runankunata tapurka: ¿Kankunapas ñukata sakiwanayankichichu? ");
INSERT INTO qupNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Pedroka aynishpan rimarka: Yachachik, nima pi tiyanchu ashwan katinanchipa. Kanllami ñukanchita rimanki imashnami Yaya Dioswa mana tukurik kawsayta tarinchi. ");
INSERT INTO qupNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ñukanchika rimashkaykita kirirkanchi chaymantapas yachashkanchi Yaya Diospa kachashkan munashkanllata rurak runa kanaykita. ");
INSERT INTO qupNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesuska aynirka: Ñukami kankunata akllashkani chunka ishkayta runaynikuna kanaykichipa. Ñuka kikin kankunata akllashka kashpaynipas shuk kankunamanta kuntrayni kanka, supayta kasuk. ");
INSERT INTO qupNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Chasna Jesuska Simón Iskariotepa wawan Judasmanta rimarka. Pay ñukanchiwa pakta chay chunka ishkay Jesuspa runankunamanta kashpanpas payta apichinan karka. Tukuy chayta Jesuska Kapernaum llaktapi ñukanchi israel runakunapa tantarinanchi wasipi yachachirka. ");
INSERT INTO qupNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Chaymanta Jesuska Galilea allpapi shuk llaktama shuk llaktama purishpa yachachishpa kawsarka. Judea allpama mana kutinayarkachu chaypi apunchikuna payta wañuchinata munahushkankunarayku. ");
INSERT INTO qupNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","3","Karan wata ñukanchi israel runakuna tantaripayanchi ñawpa yaya rukunchikuna chunlla chakishka allpapi purishpa kawsahushkankunapi tampustukunapi kawsashkankunata yuyarinanchipa. Mana achka puncha pishihushpan chay tampu shutiyu punchanchikunarayku wawkinkuna Jesusta rimarkakuna: Ama kay nima imata ruraypa allpapi kipariychu. Judea allpama riy tukuy kanta katikkuna yachaykiwa rurashkaykikunata rikunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Riksirishka runa kanayashpaykika ama kaypi pakallashina yachaykiwa rurashkaykita rikuchiychu. Ashwan Jerusalén llaktama riy tukuy runakunapa rikushkankunapi ruranaykipa. ");
INSERT INTO qupNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Chasna rimarkakuna paykunapas mana kirishpankuna Yaya Diospa Kachashkan Kishpichik kananta. ");
INSERT INTO qupNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Chaypi Jesuska rimarka: Rinayni punchaka manara paktarihunchu Yaya Dios manara rimawahushkanrayku rinaynipa. Kankuna rinaykichipaka ali kan ima punchapas. ");
INSERT INTO qupNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kankunataka Yaya Diosta mana kasuk runakunaka mana chikninahunchu. Ñukata shuti chikniwanahun mana alita rurahushkankunata paykunata rikuchihushkaynirayku. ");
INSERT INTO qupNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kankunaka riychi chayma. Ñukaka kankunawa manami rishanchu. Yaya Dios mana rimawahunrachu rinaynipa. ");
INSERT INTO qupNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Chasna rimashpan Jesuska Galilea allpapi kiparirka. ");
INSERT INTO qupNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Wawkinkuna tampu shutiyu punchakunarayku Jerusalén llaktama llukshishkankunawasha Jesuspas rirka ñukanchi runankunallawa. Mana rirkachu achka runakuna rikuhushkapi chayma rihushkanta mana yachanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Apunchikuna apinayashpankuna payta maskarkakuna. Nima pi paymanta yachashpan ¿maypita kahun chay runaka? nishpa payta maskarkakuna tantarinapi. ");
INSERT INTO qupNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Tukuy runakuna Jesusmanta pakalla kwintarkakuna paykunapura. Shukkunaka rimarkakuna: Chay runaka ali runami kan nishpa. Shukkunaka mana ali runachu, runakunata llullachikmi nishpa rimarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Apunchikunata manchashpankuna nima maykan paymanta rimarkachu achka runakunapa uyashkankunapi. ");
INSERT INTO qupNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Chusku punchata Jerusalén llaktapi tantarishpa katihushkanchipi, chusku puncha pishihushpan tukurinanpa Jesuska Yaya Diospa wasinpi yaykurka yachachinanpa. ");
INSERT INTO qupNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yachachishkanta uyashpankuna apunchikuna mancharirkakuna paykunashina Yaya Diospa shiminta alita yachak kashkanrayku. Mana asirtashpankuna rimarkakuna paykunapura: ¿Imashnataya yachakushka kay runaka chasna alita yachachinanpa? Manaya ñukanchika payta yachachishkanchichu. ");
INSERT INTO qupNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesuska paykunata aynirka: Yachachishkaynika mana ñuka yuyaynimantachu. Ñukata kachawakmi chasna yachachinaynipa kamachiwashka. ");
INSERT INTO qupNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Maykan runachari munan Yaya Diospa shiminta kasunata, paymi yachanka yachachishkaynika Yaya Diosmanta kananta, mana ñuka yuyaynimantachu. ");
INSERT INTO qupNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Maykan runachari pay kikinpa yuyayninmanta yachachin, paymi munan runa masinkuna payta alita yachachinki nishpa kushichinankunapa. Maykanmi mana munanchu runa masinkuna pay kikinta kushichinankunapa, ashwan munanmi payta kachak Yaya Diosta kushichinankunapa, payllami shutipa kashkata yachachin, mana runa masinkunata llullachinchu. ");
INSERT INTO qupNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ñawpa yachachik Moisés wañupa killkashkanpi kankunata yachachin imashnami Yaya Dios munan kawsanaykichipa. Chasna kashpanpas nima maykan kankunamanta yachachishkanta kasunkichichu. Chasna kankuna kikin mana kasukkuna kashpaykichi ¿imaraykutaya ñukata wañuchiwanayankichi? ");
INSERT INTO qupNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Chaypina payta aynirkakuna: Kanka musparihunkimi ¿Pita kanta wañuchinayan? ");
INSERT INTO qupNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesuska paykunata rimarka: Shuk runallata samana punchapi ampishkaynimanta ñukata piñariwankichi. ");
INSERT INTO qupNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Yuyariychi kankuna kikin ñawpamanta pacha rurahushkaykichita. Moisespa killkashkan kamachishkata kasushpaykichi kari wawaykichipa ishpanan kara puntastuta pitinkichi pusak puncha wawayarishkanwasha. Samana puncha kashpanpas chayta rurankichi. Manara Moisés wawayarishpanra yaya rukunchi Abraham wañu kawsashkanmanta pacha tukuy israel runakuna chasna ruranchi. ");
INSERT INTO qupNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Shuk kari wawa wawayarishkanwasha pusak puncha paktarishpan ishpanan kara puntastuta pitinkichilla samana puncha kashpanpas chasna pitinanchipa Moisespa killkashkan kamachishkata kasunaykichipa. Chasna rurashpaykichi samana puncha kashpanpas ¿imaraykuta ñukata piñariwankichi samana punchapi shuk runata ampishkaynirayku? ");
INSERT INTO qupNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ama yanka shuk runamanta millaypata yuyariychichu, ashwan yuyariychi imashnami Yaya Dios munan yuyarinaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Chaypi shukkuna Jerusalenpi kawsakkuna tapunakurkakuna: ¿Mana kay Jesusta apunchikunaka wañuchinayashpa kawsanahun? ");
INSERT INTO qupNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Chayka kaypi rimahun tukuy ñukanchikuna chawpinchipi. Nima maykan payta rimanchu. Apunchikunaka yuyarinahunchari shutipa chapahushkanchi Yaya Diospa Kachanan Kishpichik kananta. ");
INSERT INTO qupNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Yachanchi Yaya Diospa Kachanan Kishpichik shamushpan nima pi yachankachu pikunami yayankunaka. Kay runamantaka yachanchi pikunami yayankunaka. Chasna kashpan ¿kay runa kamachu Yaya Diospa Kachashkan Kishpichik? ");
INSERT INTO qupNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesuska Yaya Diospa wasinpi yachachihushpan rimahushkankunata uyashpan sinchita rimarka: Kankuna yuyarinkichi ñukata riksiwashkaykichita, chaymantapas pikunami yayaynikunaka. Ñuka kankunata rimani manami riksiwankichichu. Nima Yaya Dios ñukata kachawaktapas riksinkichichu. Payka manami nima pita llullachinchu. Chasna mana llullachik kashpanmi ñukata kay allpama kachawashka. Manami shamushkanichu ñuka kikin munay. ");
INSERT INTO qupNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Chasna Yaya Dios ñukata kachawashpan ñukallami payta alita riksini paymanta kashkaynirayku. ");
INSERT INTO qupNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Chayta uyashpankuna apunchikunaka payta apinayarkakuna. Chasna kashpanpas mana atiparkakunachu payta apinata. Manara Yaya Dioska munashkachu chay uras wañunanpa. ");
INSERT INTO qupNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Apunchikuna Jesusta wañuchinayashpankunapas achka runakuna paypi sinchikurkakuna. Alita rimarkakuna paykunapura: Yachanchi chapahushkanchi Yaya Diospa Kachanan Kishpichikka shamushpan achka nima ima uras rikushkanchita rurashkanwa Yaya Diospa atun yachayninwa kahushkanta rikuchinka. Manami tiyanchu ashwan yachak runaka kay Jesusmanta. ");
INSERT INTO qupNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariseokuna uyashpankuna Jesusmanta rimahushkankunata saserdotekunapa apunkunawa pakta kacharkakuna Yaya Diospa wasinta kuyrak runakunata paykuna Jesusta apinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Chaypi Jesuska tukuy runakunata rimarka: Mananami achka punchakunatanachu kankunawa kasha. Ñami paktarihun ñukata kachawakma kutinaynipa. ");
INSERT INTO qupNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Chayma rishpaynimi kankunaka maskawankichi. Chasna maskawashpaykichipas manami tariwankichichu. Kankunaka mana atipankichichu rinata maytami ñukaka risha. ");
INSERT INTO qupNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Chaypi apunchikuna tapunakurkakuna paykunapura: ¿Maytataya rinma ñukanchi payta mana atipananchipa tarinata? ¿Rinkachu karuma maypimi shuk israel masinchikunaka kawsanahun chikan runakuna chawpipi chaypi mana ñukanchikunamanta runakunata yachachinanpa? ");
INSERT INTO qupNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Imatata rimanayan kasna nishpan maskawashpaykichipas manami tariwankichichu, chaymantapas maymami ñukaka risha manami atipankichichu rinata nishpa? ");
INSERT INTO qupNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Chay tantarinanchi tukurinan punchami tukuy chay punchakunamanta ashwan ali kan. Chay punchapi Jesuska kutikashka runakunapa puntanpi shayarishpan sinchita rimarka: Maykan runami shunkunpi yakunayayta musyahuk runashina kan, payka sinchikuchun ñukapi saksakta upyashkashina kushilla kananpa. ");
INSERT INTO qupNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Maykanmi ñukapi sinchikun, paymanta llukshin wiñaypa tukyarik shutipa kawsayta kuk yakushina imashnami Yaya Diospa killkachishkanpi riman. ");
INSERT INTO qupNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Chaywa payka rimanayarka Yaya Diospa Espiritunmanta, maykantami ñukanchi paypi sinchikukkunata chaymanta kunan karka. Chay uras Jesuska manara wañushkarachu karka nima kawsarimushkarachu karka Yayanma kutinanpa. Chayrayku Yaya Diospa Espiritunta manara kacharkachu ñukanchipi kawsananpa. ");
INSERT INTO qupNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesuspa yachachishkanta uyashpankuna shuk runakunaka rimarkakuna: Kay runaka chapahushkanchi Moisés wañushina Yaya Diospa yachayninwa yachachikmi kan. ");
INSERT INTO qupNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Shukkunaka rimarkakuna: Paymi kan chapahushkanchi Yaya Diospa Kachanan Kishpichik. Chaymanta shukkunaka rimarkakuna: Mana, mana Yaya Diospa Kachanan Kishpichikchu kan. Chay Kishpichik kamaka manami shamumachu Galilea allpamanta. ");
INSERT INTO qupNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Yaya Diospa killkachishkanpi riman chay Kishpichik atun apunchi David wañupa miraymanta kananta. Chaymantapas riman Davidpa kawsashkan Belén llaktamanta kananta nishpa rimarkakuna mana alita Jesusmanta yachashpankuna. ");
INSERT INTO qupNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Chay runakuna Jesusmanta mana shuk yuyaywallachu karkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Shukkunaka payta apinayarkakuna. Chasna kashpanpas mana atiparkakunachu apinata. ");
INSERT INTO qupNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Chaymanta chay Yaya Diospa wasinta kuyrakkuna Jesusta mana apashpachu kutirkakuna fariseokunama saserdotekunapa apunkunamapas. Chaypi paykunata tapurkakuna: ¿Imaraykutaya chay runataka mana apamushkankichichu? ");
INSERT INTO qupNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Chay kuyrakkunaka aynirkakuna: Payka yapa alita yachachikmi. Mana tiyanchu nima shuk runa payshina yachaywa rimakka. ");
INSERT INTO qupNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Chaymanta chay fariseokuna rimarkakuna: ¿Kankunatapas chay runaka llullachishkachu? ");
INSERT INTO qupNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Tukuy apunchikunamanta ñukanchi fariseokunamantapas mana tiyanchu nima shuk payta kirik. ");
INSERT INTO qupNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Chay mana yachak runakunalla Moisés wañupa killkashkanta mana asirtakkuna kirinahun. Paykunami Yaya Diospa kastiganan runakuna kanahun. ");
INSERT INTO qupNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Chaypi shuk fariseo Nikodemo shutiyu shuk tuta Jesusma rishkanrayku paykunata rimarka: ");
INSERT INTO qupNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Moisespa killkashkanta kasushpanchi mana atipanchichu kastiganata shuk runata manara alita yachashpanchi imatami rurashka. Uchayu kananta alita yachashpanchirami payta kastiganchi. ");
INSERT INTO qupNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Chaypi Nikodemota aynirkakuna: ¿Kanpaschu kanki Galilea allpamanta runa chasna rimanaykipa? Yaya Diospa shiminta yachakuy yachanaykipa mana nima shuk Yaya Diospa yachayninwa yachachik Galilea allpamanta tiyanchu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Chasna kwintashkankunawasha tukuy kutirkakuna wasinkunama. ");
INSERT INTO qupNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Fariseokuna wasinkunama kutishpankuna Jesuska Olivos urkuma rirka. ");
INSERT INTO qupNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kayantima pakarihushkanpi Yaya Diospa wasinma kutirka. Chaypi paktashpanchi achka runakuna payta kayllayarkakuna. Chasna payta kayllayashpankuna tiyarirka yachachinanpa. ");
INSERT INTO qupNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Chaypi Moisés wañupa killkashkanta yachachikkuna fariseokunawa pakta shuk warmita pushamurkakuna shuk kariwa musayahukta tarishkankunata. Paktashpankuna churarkakuna tukuy runakuna rikunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Chaypi Jesusta rimarkakuna: Yachachik, kay warmita tarishkanchi shuk kariwa musayahukta. ");
INSERT INTO qupNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisespa killkashkanpi riman chasna warmikunata rumiwa tuksishpa wañuchinanchipa. ¿Kanka, imashnata yuyarinki? ");
INSERT INTO qupNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Chay mana ayniypata tapurkakuna yapa munashpankuna payta apinata. Chasna tapushkankunata Jesuska aynima karka wañuchiychi nishpa, ñukanchikunata winsishka romano apunchikunapa kamachishkanta mana kasumachu karka kasna nishkata: Israel runakuna mana atipanahunchu nima pita kastigashpa wañuchinata nishpa. Chaymantapas Jesuska llakichiychi nishpa aynima karka, Yaya Dios Moisesta killkachishkanta mana kasumachu karka. Chayrayku chasna payta tapushpankuna mana uyashkashina kumurishpan makin wawawa allpapi killkarayarka. ");
INSERT INTO qupNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Paykuna mana sakishpankuna tapunata Jesuska shayarishpan rimarka: Maykanmi kankunamanta ucha illa kan, payra tuksichun puntiru rumiwa. ");
INSERT INTO qupNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Chaymanta kuti kumurishpan katirka allpapi killkashpa. ");
INSERT INTO qupNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Paypa rimashkanta uyashpankuna washapuralla llukshirkakuna. Puntiru rirkakuna rukukuna chaymanta musukunana. Tukuy llukshishpankuna Jesús chay warmi puntanpi kahukllawana kiparirka. ");
INSERT INTO qupNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Chaypi Jesús shayarishpan chay warmita rikurka. Chaymanta tapurka: Pani, ¿maypitaya kahunkuna chay runakunaka? ¿Nima shukchu kanta tuksinayashka? ");
INSERT INTO qupNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Chay warmika aynirka: Nima pi, yachachik. Jesuska payta rimarka: Chasna kashpanka ñukapas mana rimanichu kanta kastiganankunapa. Kunanka kutiy. Manana uchata ruraynachu. ");
INSERT INTO qupNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Chaymanta Jesús kiparishpan Yaya Diospa wasinpi kuti runakunata yachachirka kasna nishpa: Ñukami runakunaraykuka punchashina kani. Maykankunami ñukata katiwanahun mana kawsankakunanachu amsapishina Yaya Diosta mana riksishpa. Ñuka punchatashina riksiwashkankunarayku yachankakuna imashnami ali ruranakunaka Yaya Diospa rikushkanpi. Chasna ñukata riksiwashpankuna wiñaypa Yaya Dioswa kawsankakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Chaypi fariseokunaka rimarkakuna: Kanlla kan kikinmanta rimanki punchashina kanaykita, chayrayku rimashkaykika mana valinchu. Mana tiyanchu ashwan shuk chasnallatata kanmanta rimakka. ");
INSERT INTO qupNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesuska aynirka: Ñuka yachani maymantami shamushkani maymami risha. Chayrayku ñukalla ñuka kikinmanta rimashpaynipas shutipami kan. Kankunaka manami yachankichichu maymantami shamushkani maymami risha. ");
INSERT INTO qupNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kankunaka kikin yuyaykichikunamanta runa masikichikunata uchachinkichi. Ñukaka manami kawsanichu runakunata uchayu kanki nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Runakunata rimashpaynipas uchayu kanki nishpa, rimashkaynika shutipami, manami yanka nishpachu kan. Chasna rimashpayni mana ñukallachu uchayu kanki nishpa rimani, ashwan kachawak Yayayniwa pakta chasna rimanchi. Chayrayku rimashkaynika shutipami. ");
INSERT INTO qupNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Katihushkaykichi Moisés wañupa killkashkanpi kasna nin: Ishkay runa shuk runamanta apupa puntanpi chasnalla rimashpankunaka shutipa kan nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ñukamanta tiyan ishkay chasnalla rimakkuna. Ñuka kani shuk ñuka kikinmanta rimak, chaymanta Yayayni ñukata kachawakpas chasnallatata ñukamanta riman. ");
INSERT INTO qupNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Chasna Jesuska rimashpan tapurkakuna: ¿Maypita kahun yayaykika? Jesuska aynirka: Kankunaka nima ñukata nima Yayaynita riksinkichichu. Ñukata riksiwankichimaka Yayaynitapas riksinkichimami karka. ");
INSERT INTO qupNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Tukuy chayta Jesuska Yaya Diospa wasinpi yachachishpan rimarka. Payka kahurka maypimi kullkita churanankunaka karkakuna. Chaypi tukuy runakunapa rikushkankunapi yachachishpan nima pi payta apirkachu, manara Yaya Dios munashkanrayku apinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Chaymanta Jesuska kutikashka payta chiknik runakunata rimarka: Ñukaka kankunata sakishami. Rishpayni kankunaka maskawankichi, ¿maypitaya chay kishpichikka? nishpa mana tariwankichichu. Ashwan, wañushpaykichi uchaykichimanta mana llakichirishkachu wañunaykichi tiyan. Yaya Dioska ñukata mana kirishkaykichimanta kankunata mana llakichinkachu. Chayrayku manami atipankichichu rinata maymami ñukaka risha. ");
INSERT INTO qupNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Chayta uyashpankuna apunchikuna rimarkakuna paykunapura: ¿Imatataya rimanayan, maymami risha kankunaka mana atipankichichu rinata nishpa? Rimanayanchari pay kikin wañuchirinayashkanmanta. ");
INSERT INTO qupNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Chaypi Jesuska rimarka: Kankunaka kay allpamantami kankichi, ñukaka awamantami kani. Kankunaka uchayu runakunami kankichi, ñukaka mana uchayuchu kani. ");
INSERT INTO qupNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ñukami kani wiñaypa kawsak Yaya Dios. Kankuna pay kanaynita mana kirishpaykichika Yaya Dios uchaykichikunamantaka manami llakichinkachu. Chayrayku kankunata rimashkani wañushpaykichi uchaykichikunamanta manami llakichirishkachu wañunkichi. ");
INSERT INTO qupNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Chaypi payta asikshina tapurkakuna: ¿Pitaya kanki kanka? Jesuska aynirka: Kankunata shutipa kashkata rimashpaynipas mana kiriwankichichu. ¿Imaraykutaya kankunawa kwintani? ");
INSERT INTO qupNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ñukapa tiyawan achka kankunamanta rimanaynipa, chasnaykichimanta kastigarishka kanaykichipa. Rimashkaynita mana kirishpaykichipas shutipami kan. Ñukata kachawak shutipata rimak kashpanmi rimashkaynika shutipami, paypa rimawashkanllata runakunata rimashkaynirayku. ");
INSERT INTO qupNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Chasna Jesús rimashpan apunchikunaka mana asirtarkakunachu, pay ñukata kachawak nishpan Yayan Diosmanta rimashkanta. ");
INSERT INTO qupNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Chayrayku Jesuska paykunata rimarka: Kankuna kruspi alsawashpaykichi Yayayni Diospa Kachashkan Runata, chaypirami riksiwankichi ñuka Yaya Dios kanaynita. Chaymantapas yachankichi nima imata ñuka kikin yuyaynimanta rurashkaynita, ashwan Yayaynipa yachachiwashkanllata kasushkaynita. ");
INSERT INTO qupNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ñukata kachawak tukuy uras ñukawa kahun. Mana nima ima uras sapallaynita sakiwashkachu, payta tukuy uras rurashkayniwa kushichishkaynirayku. ");
INSERT INTO qupNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Chasna Jesuska rimashpan achka runakuna paypi sinchikurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Chaypi shuk apunchikunapas Yaya Diosmanta kashkanta yuyarishpankuna Jesús paykunata rimarka: Rimashkaynita yuyarishpa kasushpa kawsaychi. Chasna kawsashpaykichi shutipa ñukata katiwakkunami kankichi. ");
INSERT INTO qupNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Yachachishkaynita kasushpaykichika riksiwankichimi shutipa kashkata rimak kanaynita. Chasna kanaynita riksiwashpaykichimi kishpichirishka kankichi manana shuk mana ali patronpa kamachishkanshina kawsanaykichipa llullakunata kirishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Paykunaka aynirkakuna: Ñukanchi kawsanchi kunkaylla yaya rukunchi Abraham wañupa miraymanta kashkanchirayku. Payshina shuklla Yaya Diosta kasushpanchi nima ima uras tiyashkachu shuk runa ñukanchita kamachik shamunanpa. ¿Imaraykutaya kanka rimanki ñukanchika kashunchi kishpichirishka? ¿Pimantataya kishpichirishka kanchima? ");
INSERT INTO qupNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesuska paykunata aynirka: Alita uyawaychi. Uchata rurashpa katishpaykichika uchata rurachikpa kamachishkanllatana ruranaykichi tiyan, mana munashpaykichipas. ");
INSERT INTO qupNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Chasna shukpa kamachishkan kashpaykichi manami Yaya Diospa wawankunachu kankichi. Wawankunallami paywa wiñaypa kawsankakuna. Mana wawankuna kashpaykichika manami atipankichichu paywa wiñaypa kawsanata. ");
INSERT INTO qupNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ñuka Yaya Diospa Wawan kashpayni atipani kamachirishka kahushkaykichimanta kankunata kishpichinata. Ñuka kankunata kishpichishpaynimi shutipa kishpichirishka kankichi. ");
INSERT INTO qupNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ñuka yachani ñawpa yaya rukunchi Abraham wañupa miraymanta kanaykichita. Chasna kashpanpas kankunaka rimashkaynita mana uyanayashkaykichirayku wañuchiwanayankichi. ");
INSERT INTO qupNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ñuka rimani maykantami Yayaynika rimawashka, kankunaka rurankichi maykantami yayaykichika riman. ");
INSERT INTO qupNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Chaypi payta aynirkakuna: Yaya rukunchi Abraham wañupa miraymanta kashpanchi payshina shuklla Yaya Diosta kasunchi. Jesuska paykunata rimarka: Shutipa Abrahamshina kankichimaka payshinami alillata rurankichima. ");
INSERT INTO qupNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Abrahamka nima ima uras shuk alita rimak runata wañuchinayarkachu. Kankunaka Yaya Diosmanta uyashkayni shutipa kashkata rimak kashpaynipas wañuchiwanayankichi. ");
INSERT INTO qupNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kankuna kankichi chikan yayayu. Rurankichi maykantami yayaykichika ruran. Chaypi payta aynirkakuna: Ñukanchipa yayanchika shukllami. Yaya Diosllami yayanchika. Mana kanchichu shuk yayamanta wawakunashina. ");
INSERT INTO qupNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesuska aynirka: Yaya Dios yayaykichi kamaka ñukata yuyawankichimami paymanta kashkaynirayku. Pay kachawashpanmi shamushkani. Manami shamushkanichu ñuka kikin yuyaynimanta. ");
INSERT INTO qupNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Imaraykuta mana asirtankichichu rimahushkaynita? Kankunata rimani, manami asirtankichichu mana alita shiminita uyanayashkaykichirayku. ");
INSERT INTO qupNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Yayaykichika supaykunapa apunmi. Paypa wawankuna kashpaykichi tukuy munashkanta ruranayankichi. Yaya Dios runata rurashkanmanta pacha supayka runata wañuchik kan. Tukuy shutipa kashkata piñarin shunkunmanta pacha llullachik kashkanrayku. Chasna shunkunmanta pacha llullachik kashpanmi llullallata riman. Paymi llullaysiki, tukuy llullaka paymantami. ");
INSERT INTO qupNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ñuka shutipa kashkata rimak kashpayni manami kiriwankichichu. ");
INSERT INTO qupNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Pita kankunamanta atipan uchata rurashkaynita rimak rinata? Nima pi atipanchu. Shutipa kashkata rimak kashpayni ¿imaraykuta mana kiriwankichichu? ");
INSERT INTO qupNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Maykan runami Yaya Diospa wawan kan, paypa shiminta kasunmi. Kankunaka shiminta mana kasunkichichu mana paypa wawankuna kashkaykichirayku. ");
INSERT INTO qupNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Jesuspa rimashkanta uyashpankuna apunchikunaka payta rimarkakuna: Ñukanchika alita rimanchi Samaria allpamanta runashina kanki supay yaykushka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Chaypi Jesuska aynirka: Mana supay yaykushka runachu kani. Ashwan Yayaynita kushichishpallami kawsani. Chasna kashpaynipas kankunaka millaypallata rimawankichi. ");
INSERT INTO qupNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ñuka mana maskanichu runakuna ali kanki nishpa rimawanankunapa. Chasna kashpanpas tiyan shuk maykanmi munan runakuna kushichiwanankunapa. Paymi shuk puncha rimanka rurashkaynika alichu manachu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Alita uyawaychi, maykan runami rimashkaynita kasun, chayka manami wañunkachu. ");
INSERT INTO qupNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Chaypi apunchikunaka aynirkakuna: Yaya rukunchi Abrahamka wañurka, chaymantapas Yaya Diospa yachayninwa ñawpa yachachikkuna tukuy wañurkakuna. ¿Imashnataya kanka rimanki, maykan runami shiminita kasun, payka manami wañunkachu nishpa? Kunan shuti yachanchi supay yaykushka runa kanaykita. ");
INSERT INTO qupNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Yaya rukunchi Abraham wañurka. Yaya Diospa yachayninwa ñawpa yachachikkunapas tukuy wañurkakuna. ¿Kanka paykunamanta pasachu kanki? ¿Pi kanaykitataya yuyarinki? ");
INSERT INTO qupNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesuska aynirka: Rimaynimaka ñuka kikinmanta atun yachayyu kani nishpa, rimashkaynika manami valimachu. Yayaynimi chasna atun yachayyu kanaynita riman, maykantami kankunaka rimankichi Yaya Diosninchi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Chasna rimashpaykichipas payta mana riksinkichichu. Ñuka shuti payta riksini. Mana riksinichu nishpa rimaynimaka kankunashina llullaysiki kaynima. Chasna payta riksishpaynimi shiminta kasuni. ");
INSERT INTO qupNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ñawpa kawsak yaya rukunchi Abraham atunta kushikurka allpama shamunaynita rikunanta yachashpan. Shamushkaynita rikushpan kushikurka. ");
INSERT INTO qupNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Chayta uyashpankuna apunchikuna Jesusta rimarkakuna: ¿Imashnataya ñawpa Abraham kawsashkanta rikushkanki? Manara kankichu nima pichka chunka watayu. ");
INSERT INTO qupNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesuska paykunata aynirka: Alita uyawaychi, Abraham manara wawayarishpanra ñuka chasnalla kawsa Yaya Dios karkani. ");
INSERT INTO qupNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Chasna Jesuska runa kashpanpas Yaya Dios kananta rimashpan rumikunata apirkakuna payta tuksishpa wañuchinankunapa. Chaypi Jesuska pakashpan Yaya Diospa wasinmanta llukshirka. ");
INSERT INTO qupNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesuska Yaya Diospa wasinmanta llukshishkanwasha ñukanchi runankunawa purishpan wawayarishkanmanta pacha wisku runata rikurkanchi. ");
INSERT INTO qupNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Chaypi Jesusta tapurkanchi: Yachachik, ¿imamantataya kay runaka wisku wawayarishka, yayankunapa uchanmantachu, pay kikinpa uchanmantachu? ");
INSERT INTO qupNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Chaypi Jesuska ñukanchita aynirka: Chasna wisku wawayarishkanka mana kanchu pay kikinpa uchanmanta nima yayankunapa uchankunamantachu. Payka wisku wawayarishka Yaya Dios atun yachayninwa ampishpan runakunata rikuchinanpa. ");
INSERT INTO qupNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kawsa kahushpanchira kachawak Yaya Diosta kasushpa kamachishkankunata rurananchi tiyan. Wañushkanchiwasha nima imata atipashunchichu ruranata. ");
INSERT INTO qupNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Yaya Diosta mana kasuk runakuna chawpipi kahushpaynira paykunarayku punchashina ali ruranakunata riksichikmi kani. ");
INSERT INTO qupNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Chasna rimashkanwasha Jesuska allpapi tyukashpan allpawa chapushpan wiskupa ñawinpi kakurka. ");
INSERT INTO qupNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Chaymanta rimarka: Mayllakriy ñawikita runakunapa rurashkan Siloé yaku tantarinapi. Chay Siloé ninayan kachashka. Chaypi mayllarik rirka chay wiskuka. Mayllarishpan chay wiskuka ampirirka. Ña rikushpanna wasinma kutirka. ");
INSERT INTO qupNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Chay kuchunpi kawsakkuna, ñawpa kullkita tapuhushkanta rikukkunapas tapunakurkakuna: ¿Mana kay tiyarishpa kullkita tapupayarka? ");
INSERT INTO qupNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Shukkunaka rimarkakuna: Ari, paymi. Shukkunaka: Mana paychu, payshina rikurishpanpas nishpa rimarkakuna. Chay wisku ampirishkaka rimarka: Ari, ñukami kani. ");
INSERT INTO qupNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Chaypi payta tapurkakuna: ¿Imashnamantataya kunanka ña atipanki rikunata? ");
INSERT INTO qupNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Paykunata aynirka: Chay Jesús shutiyu runami llawsanta allpawa chapushkanwa ñawinipi kakushpan rimawarka: Mayllakriy runakunapa rurashkan Siloé yaku tantarinapi nishpa. Chayma rishpayni ñawinita mayllarkani, chay ratulla rikurkanina. ");
INSERT INTO qupNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Chaymantapas payta tapurkakuna: ¿Maypita chay kanta ampik runaka? Payka aynirka: Mana yachanichu maypichari kahun nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Jesús llawsanta allpawa chapushpan samana punchapi chay wiskuta ampirka. Chay puncha nima pi atipapayanchu imata ruranata. Chayrayku chay ampirishkata fariseokunama pusharkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Paykunapas payta tapurkakuna: ¿Imashnamantata kunanka atipanki rikunata? Chay ampirishkaka aynirka: Chay ampiwak runaka llawsanta allpawa chapushkanwa ñawinipi kakurka. Chayta mayllak rirkani. Kunanka rikuknami kani. ");
INSERT INTO qupNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Shuk fariseokunaka rimarkakuna: Chay kanta ampik runaka manami Yaya Diosmantachu mana samashkanrayku samana punchapi. Shukkunaka paykunamanta rimarkakuna: Uchasapa kamaka mana ruranata atipamachu karka tukuy chay nima ima uras rikushkanchita atun yachaywa rurashkankunata. Chasnamanta mana shuk yuyayllawachu karkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Kutikashka chay ampirishkata tapurkakuna: Rimashkanki pay kanta ampishkanta. Chasna kashpanka ¿imatata kanka yuyarinki paymanta? Ñukaka yuyarini payka Yaya Diospa yachayninwa rurak runa kananta nishpa aynirka. ");
INSERT INTO qupNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Chaypi chay apunchikunaka mana kirishkakunachu ñawpa wisku kashkanta. Chayrayku yayankunata kayachirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Paktashpankuna paykunatapas tapurkakuna: ¿Kayka kanchu kikin wawaykichi? ¿Shutipachu wisku wawayarirka? Chasna kashpan ¿imashnamantataya kunanka rikuk tukushka? ");
INSERT INTO qupNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Chaypi yayankunaka aynirkakuna: Ari, kikin wawanchimi. Shutipami wisku wawayarirka. ");
INSERT INTO qupNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Mana yachanchichu imashnamantami rikuk tukushka, nima yachanchichu pimi payta ampishka. Pay kikinta tapuychi. Ñami ruku kan. Paymi kankunata rimanka. ");
INSERT INTO qupNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Chasna rimarkakuna manchashpankuna tantarinanchi wasimanta wichuy tukunankunata. Manara Jesús chay wiskuta ampishpan apunchikunaka runakunata rimarkakuna: Maykan runakunami Jesusmanta rimanahun: Chapahushkanchi Yaya Diospa Kachanan Kishpichik kan nishpa, chay runakunatami tantarinanchi wasimanta wichushunchi. ");
INSERT INTO qupNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Chayta yachashpankuna yayankunaka rimarkakuna: Pay kikinta tapuychi. Ñami ruku kan. Paymi kankunata rimanka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Chaypi apunchikunaka wisku ampirishkata kayachirkakuna kuti shamunanpa. Paktamushpan rimarkakuna: Kunan shuti Yaya Diospa puntanpi mana llullashpa shutipata rimay chay ampiwashka runa nishkaykimanta. Ñukanchi yachanchi chay runaka uchasapa kananta. ");
INSERT INTO qupNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Chay ampirishka runaka aynirka: Mana yachanichu uchayuchu manachu nishpa. Ñukaka yachanimi wisku kashkaynita, kunanka rikuninami. ");
INSERT INTO qupNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Chaypi kutikashka payta tapurkakuna: ¿Imashnata rurarka kanta ampinanpa wisku kashkaykimanta? ");
INSERT INTO qupNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Chay wisku ampirishkaka aynirka: Ñami kankunata rimashkani. Rimashpaynipas manami kiriwankichichu. ¿Imaraykuta munankichi kutikashka rimanaynipa? ¿Kankunapas payta katinata munankichichu? ");
INSERT INTO qupNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Chayta uyashpankuna yapa piñarishpa millaypata rimarkakuna. Chaymantapas rimarkakuna: Kanka kasunki chasna runata, ñukanchika ali yachachik Moisés wañupa killkashkan Yaya Diospa kamachishkanllata kasunchi. ");
INSERT INTO qupNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Moisesmanta yachanchi Yaya Dios payta rimashkanta. Chay runamantaka nima imata yachanchichu. Nima yachanchichu maymantachari shamushka. ");
INSERT INTO qupNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Chay wisku ampirishkaka aynirka: ¿Imashnataya chasnaka kanka? ¿Ñukanchimanta pasa Yaya Diospa shiminta yachakukkuna kashpaykichitatachu mana yachankichi maymantami shamushka chay ñukata mana atipaypata rurashpa ampiwashka runaka? ");
INSERT INTO qupNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Alita yachanchi Yaya Dioska mana uyanchu uchayu runakunataka, ashwan uyanmi, maykankunami payllata kushichishpa paypa munashkanta rurashpa kawsanahun. ");
INSERT INTO qupNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nima ima uras uyashkanchichu shuk runa wisku wawayarishka ampirishkanmanta. ");
INSERT INTO qupNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Chay runa mana Yaya Diosmanta kamaka manami atipamachu karka kay mana atipaypata ruranata. ");
INSERT INTO qupNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Chaypi shuk runa wisku wawayarishpan uchamanta chasna tukushkanta yuyarishpankuna payta rimarkakuna: Wawayarishkaykimanta pacha uchasapami kanki. Chasna kashpaykika ¿imashnataya ñukanchi yachachikkunataka yachachinayanki? Chasna rimashpankuna tantarina wasimanta wichurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Chasna wichushkankunata yachashpan Jesuska payta maskananpa rirka. Chay wisku ampirishkata tarishpan tapurka: ¿Sinchikunkichu Yaya Diospa Kachashkan Runapi? ");
INSERT INTO qupNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Chaypina aynirka: Rimaway wawki, ¿pitaya chay runaka paypi sinchikunaynipa? ");
INSERT INTO qupNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesuska aynirka: Ñami rikushkanki chay runataka, ñukami kani maykanwami kwintahunki. ");
INSERT INTO qupNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Chaypina paypa puntanpi kunkurirka. Kunkurishpan rimarka: Kunan shuti kanpi sinchikuni shutipa Amuyni kanki. ");
INSERT INTO qupNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesuska rimarka: Ñukaka kay allpama shamushkani runakunata riksichinaynipa imashnami kanahun Yaya Diospa rikushkanpi. Tiyan shuk mana alita rurak runakuna wiskushina Yaya Diospa shiminta mana riksikkuna. Chay runakunata yachachishpa yanapashami alita rikuk runakunashina Yaya Diospa shiminta riksik tukunankunapa. Shuk runakuna tiyan alita rikuk runakunashina Yaya Diospa shiminta riksik kanankunata yuyarikkuna. Paykunaka shutipa wiskushinami Yaya Diospa shiminta mana asirtashpa kiparinkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Chayta uyashpankuna kuchunpi kahuk fariseokunaka tapurkakuna: ¿Kanka rimankichu ñukanchipas wiskushina kahushkanchita? ");
INSERT INTO qupNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesuska paykunata aynirka: Shuk wiskushina kankichimaka Yaya Diospa shiminta mana riksishpa, nima pi kankunamanta mana ali kashkaykichita rimak rinmachu. Kankunaka mana asirtashpaykichipas rikuk runakunashina kanchi Yaya Diospa shiminta riksik nishpa rimankichi. Chasna yanka rimashkaykichirayku uchaykichika manana llakichiypanachu. ");
INSERT INTO qupNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","2","Fariseokuna yuyarinahun runa masinchikunata yachachik kashpanchi obehakunata kuyrak runashina paykunata kuyrak kanchi nishpa. Jesuska chasna yuyarishkankunata riksishpan paykunata kasna yachachishpa katirka: Alita uyawaychi. Rikuychi shuk kuyrak amuta obehankunawa. Obehakunapa tiyan shuk samanankuna kincharishkaka shuk punkuyulla. Chay punkuta yaykuk runaka kikin kuyrakmi. Maykankunami mana chay punkuta yaykunahunchu, ashwan shuk partita sikashpa yaykunahun, chaykunaka kanahunmi shuwakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Chay samanankuna kincha punkupi tiyan shuk kuyrak runa. Payka chay obehakunata kuyrakraykulla paskan. Chay kuyrak runaka yaykushpan obehankunata karan shukta shutinkunapi kayan. Paypa shiminta uyashpankuna kushikushpa kasunahun riksishkankunarayku. Chay kuyrak runaka obehankunata kayashpan chushama llukshichin. ");
INSERT INTO qupNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ña tukuy llukshishpankuna obehankunapa puntankunapi purin. Paykuna payta katinahun, shiminta riksishkankunarayku. ");
INSERT INTO qupNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Mana riksishkankunataka manami katinahunchu, ashwan paymanta mitikunahun, shiminta mana riksishkankunarayku. ");
INSERT INTO qupNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Chasna Jesuska rimashpan mana shutillatachu payta chiknik runakunata yachachirka. Paykunaka mana asirtarkakunachu imatami chay rimashkanwa yachachinayarka. ");
INSERT INTO qupNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jesuska paykunata yachachishpalla katirka: Alita uyawaychi. Ñukami kani obehakunapa samanankuna kincha punkushina. ");
INSERT INTO qupNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ñukamanta puntiru achka llullachishpa yachachikkuna shamushkakuna. Mana punkuta yaykushpankunami mana kanahunchu kikin obehakunata kuyrakkuna. Kanahunmi obehata shuwakunashina. Runakunata llullachishpa chinkachinahun. Obehaynikunaka ñukata alita riksiwashpankuna manami paykunataka kasushkakunachu. ");
INSERT INTO qupNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ñukami kani obehakunapa samanankuna kincha punkushina. Maykankunami yaykunahun, paykunataka wañuymanta kishpichishami. Chasna alita wakaycharishka tukushpankuna mana manchashpa yaykunahun llukshinahun, tukuy munashkankunata kushilla kawsanankunapa tarinahun. ");
INSERT INTO qupNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Obehata shuwakunaka shamunahun kichunapa, wañuchinapa, chinkachinapa. Chasnashinami mana alita yachachikkunaka runakunata ruranahun. Ashwan ñukaka shamushkanimi runakunata mana tukurik nima ima uras riksishkankuna shutipa kawsayta kunaynipa. ");
INSERT INTO qupNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ñukami kani alita obehankunata kuyrak runashina. Ali kuyrak runaka obehankunata yapa yuyashpan wañushanpas paykunata kishpichinaynipa nishpa wañuma. ");
INSERT INTO qupNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Maykanmi kullkita ganananllapa obehakunata kuyran, payka puma shamuhushpan sakin. Paykunamanta mitikun, mana kikin amun kashkanrayku. Pumaka obehakunata apinapa shamuhushpan paykunata shikwachin tukuy partima. ");
INSERT INTO qupNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Chay kuyrakka mitikun, kullkita ganananllapa kuyrahushkanrayku. Mana obehakunata kuyranchu, paykunata yuyashkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ñukami kani runaynikunarayku shuk alita obehankunata kuyrak runashina. Riksinimi pikunami runaynikunaka. Karan shukta yuyashpayni alita riksini. Chasnallatatami runaynikunapas alita ñukata riksiwanahun. ");
INSERT INTO qupNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Imashnami Yayayni Dios ñukata riksiwan, chaymantapas imashnami ñuka payta riksini, chasnallatatami ñukapas runaynikunawa alita riksinakuni. Paykunata kishpichinaynipami wañusha. ");
INSERT INTO qupNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Chaymantapas imashnami obehankunata kuyrak runapa tiyama chikan obehankuna shuk parti shuk kinchapi, chasnashinami ñukapapas shuk parti tiyawan shuk runaynikuna mana israel runakunamantachu. Paykunatapas yachachinayni tiyan kasuwanankunapa. Yachachishkaynita uyashpankuna kasuwankakuna. Tukuy partimanta runaynikunata tantachinayni tiyan tantaylla kawsanankunapana ñuka sapallana kuyrak kanaynipa. ");
INSERT INTO qupNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","18","Paykunata kishpichishpa wañusha. Wañushkaynimanta kawsarisha. Nima pi atipawankachu wañuchinata, ashwan ñuka kikin munay wañusha. Chasnallatatami ñuka kikin munay kawsarimusha. Yayayni Diosmi kachawashka chasna wañunaynipa chaymantapas kawsarimunaynipa. Chasna payta kasuhushkaynirayku ñukata yapa yuyawan. ");
INSERT INTO qupNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Chasna Jesuspa rimashkanta uyashpankuna apunchikunaka kutikashka mana shuk yuyaywallachu karkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Achka rimarkakuna: Kay runaka supay yaykushka muspa runami kan. Mana valinchu payta uyananchipa. ");
INSERT INTO qupNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Shukkunaka rimarkakuna: Nima maykan runa supay yaykushka kamaka payshina rimamachu. Chasna supay yaykushka runa kamaka mana atipamachu karka wiskuta ampinata. ");
INSERT INTO qupNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","23","Chiri killakuna paktashkan uras Jerusalén llaktapi shuk tantarina tiyarka. Tantarishka kahurkakuna kushikushpa yuyarinankunapa Yaya Diospa wasinta kuntrankuna ñawpa urmachishkankunamanta kuti alichashkankunata. Jesuspas Jerusalenpi kahurka. Yaya Diospa wasinpimi karka punku mayanpi Salomón shutiyu wasipi. Chiri kashpan chaypi puririrka. ");
INSERT INTO qupNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Chaypi apunchikuna payta muyukta shayarishpankuna tapurkakuna: ¿Imaraykuta mana kuskata rimankichu pimi kanki? Yaya Diospa Kachashkan Kishpichik kashpaykika ñukanchita kuskata rimay. ");
INSERT INTO qupNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesuska paykunata aynirka: Ñami kankunata rimashkani, manami kiriwankichichu. Yayayni atun yachayninta kuwashkanrayku rurahushkaynikunata rikushpaykichi atipankichi yachanata pimi kani. ");
INSERT INTO qupNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kankuna mana munankichichu kiriwanata, mana obehaynikuna kashkaykichirayku. ");
INSERT INTO qupNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Obehaynikunaka shiminita riksinahun. Ñukapas paykunata riksinimi. Paykunata kayashpayni katiwanahun. ");
INSERT INTO qupNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ñuka paykunata Yaya Dioswa mana tukurik kawsayta kuni. Manami rinkakunachu ñukamanta anchurishka wiñaypa parisinankunapa. Nima pi atipanchu ñukapi kirikkunata kichuwanata. ");
INSERT INTO qupNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yayayni paykunata kuwashka. Nima pi paytaka atipanchu kichunata tukuymanta ashwan atun yachayyu kashkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ñukapas Yayayniwa tukuypi shuk yuyayllawa parihu yachayyu kanchi. ");
INSERT INTO qupNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Chasna Jesús rimashpan kutikashka apunchikunaka rumikunata apirkakuna payta tuksishpa wañuchinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Chasna wañuchinayahushkankunapi Jesuska paykunata rimarka: Kankuna rikushkankichi Yayaynipa yachayninwa alikunata rurashkaynita. ¿Maykan chay ali rurashkaynikunamantata wañuchinayawankichi? ");
INSERT INTO qupNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Chaypi apunchikunaka aynirkakuna: Manami kanta rumiwa wañuchinayahunchichu alita rurashkaykimanta. Kanta wañuchinayahunchimi runa kashpaykitata Yaya Diosmi kani nishpa rimashkaykirayku. Chasna tukuy runakunamanta pasa Yaya Diosshina kanayashpaykimi kanta wañuchinayahunchi. ");
INSERT INTO qupNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Chaypi Jesuska aynirka: Alita yuyariychi yachakushkaykichi ñawpa Yaya Diospa killkachishkanta. Chay killkachishkanpi apunchikuna wañuta kasna nin: Kankunata rimani ñukashina dioskuna kanaykichita. ");
INSERT INTO qupNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Yaya Dios kikin chasna rimashpan nima pi atipanchu rimanata mana ali kananta. Chay runakunamanta akllashkan apukuna wañuta rimarka payshina kanankunata. ");
INSERT INTO qupNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ñuka paykunamanta pasa kani Yayayni Dios ñukallata akllashkanrayku kay allpama kachawananpa tukuy munashkanta paktachinaynipa. Runakunamanta akllashkan apunchikuna wañuta rimashpan payshina kanankunata, ashwan atipani ñuka rimanata Yaya Diospa Wawanmi kani nishpa. ¿Imaraykuta chasna rimashpayni piñariwankichi millaypata rimanki nishpa? ");
INSERT INTO qupNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Yayaynipa kamachiwashkanta mana rurashpaynika chay uras shuti ama kiriwaychichu Yayayni Diospa kachashkan kanaynita. ");
INSERT INTO qupNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Yayayni Diosmanta kani rimashpayni mana kiriwashpaykichipas Yayaynipa kamachishkanta rurashkaynita rikushpaykichi kiriwaychi Yaya Diospa kachashkan kanaynita. Chasna rikushkaykichirayku kiriwaychi yachanaykichipa ñuka Yayayniwa, Yayayni ñukawa shuk yuyayllawa kahushkanchita. ");
INSERT INTO qupNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Chasna rimashpan Jesusta kutikashka apinayarkakuna. Chaypi paykunamanta payka kishpimurka. ");
INSERT INTO qupNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Chasna kishpishkanwasha Jordán yaku chimpama kutirka maypimi Juanka bawtisapayarka. Chayllapi kiparirka. ");
INSERT INTO qupNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Achka runakuna payta rikuk shamurkakuna. Chaypi rimarkakuna paykunapura: Juanka mana rurapayarkachu atun yachaywa nima ima uras rikushkanchikunata kay Jesusshina. Chasna kashpanpas tukuy kay runamanta rimashkanka shutipami. ");
INSERT INTO qupNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Chaypi achka runakuna Jesusta kirik tukurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Tiyarka Jesuspa shuk yuyashkan runa Lásaro shutiyu. Payka sinchita unkushka karka. Ishkay paninkunawa pakta Judea allpapi kahuk Betania llaktapi kawsarka. Paypa paninkunaka karka Marta shukka Maria. ");
INSERT INTO qupNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Chay Mariami masna punchakunamanta Jesuspa chakinpi talina karka mishkinlla asnak perfumita, chaymanta chukchanwa chakichina karka paypa chakinta. ");
INSERT INTO qupNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lásaro unkushka kashpan chay paninkunami shuk runata kacharkakuna Jesusta kayak shamunanpa: Kanpa kikin amiguyki Lasaromi wañuhun nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Chayta uyashpan Jesuska aynirka: Chay amiguynika manami unkushkachu wañunanpa, ashwan Yaya Dios atun yachayninta rikuchinanpami, chaymantapas ñuka Yaya Diospa Wawan atun yachaynita rikuchinaynipa. ");
INSERT INTO qupNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","6","Jesuska Lasarota paninkunanti yapa yuyashpanpas Lásaro unkushka kashkanta yachashpan mana utkallachu chayma rirka. Chay kahushkanllapi ishkay puncha ashwan kiparirka. ");
INSERT INTO qupNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Chaymanta ñukanchi paypa runankunata rimarka: Akuychi kutikashka Judea allpama rishunchi. ");
INSERT INTO qupNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Chaypi payta rimarkanchi: Yachachik, Judea allpapi apunchikuna kanta rumiwa tuksishpa wañuchinayashkakuna. Ama kuti chayma riychu. ");
INSERT INTO qupNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Jesuska aynirka: Karan shuk punchapa tiyan chunka ishkay uras. Chunka ishkay uras manara pasashpanka manara tutayanrachu. Chasnashinami Yayayni Diospa munashkanta manara paktachihushpaynika ñukata mana wañuchiwankakunarachu. Punchapi purihushpaykichi mana takarinkichichu, punchayachik rikuchihushkanrayku. Tutapi purihushpaykichika takarinkichimi, mana puncha tiyashkanrayku. Chasnashinami ñukata katiwashpaykichi Yaya Diospa munashkanta rurashpa punchapi purihukshina alita kawsankichi. Mana ñukawa pakta kawsashpaykichika amsapishina purishpa pantankichi. ");
INSERT INTO qupNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Astalla unaystumanta rimarka: Chay amigunchi Lasaroka samahumi, atarichik rishara. ");
INSERT INTO qupNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","13","Jesuska wañushkata samahumi nishpa rimarka. Ñukanchi yuyarirkanchi kawsa runa puñuhuktashina. Chayrayku aynirkanchi: Yachachik, puñuhushpanka ampirinkami. ");
INSERT INTO qupNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Chaypina Jesuska ñukanchita kuskata rimarka: Lasaroka ña wañushkami. ");
INSERT INTO qupNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Yapa munashpayni ashwanta yachakunaykichipa ñukapi sinchikunata, kushikunimi wañuhushpan mana chaypi kashkaynirayku. Kunanka akuychina payta rikuk rishunchi. ");
INSERT INTO qupNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Chaypi chay chunka ishkay Jesuspa runan masinchi Tomás, maykantami rimapayarkakuna ishkay wawayarishka, ñukanchita rimarka: Akuychi, ñukanchipas rishunchi yachachikwa pakta wañunanchipa. ");
INSERT INTO qupNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Betania llaktama rishpanchi shukkuna Jesusta rimarkakuna ña chusku puncha Lasaropa aychanka urku uchkupi taparishka kahushkanta. ");
INSERT INTO qupNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Chay Betania llaktaka karkami Jerusalén kuchupi chawpi ura purishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Achka israel masinchikuna Jerusalenmanta rirkakuna Martata Mariata turin wañushkanmanta llakihushkankunapi sinchikuchinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta Jesuspa paktahushkanta yachashpan tinkunapa shamurka. Mariaka wasillapi kiparirka mana yachashpan Jesús paktahushkanta. ");
INSERT INTO qupNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Chaypina Martaka Jesusta tinkushpan rimarka: Yachachik, kan kaypi kankima karka, turinika mana wañumachu karka. ");
INSERT INTO qupNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Kunanpas yachani Yaya Dios tukuy tapushkaykita rurananta. ");
INSERT INTO qupNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Chaypi Jesuska Martata aynirka: Turikika kuti kawsarinkami. ");
INSERT INTO qupNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Chaypi Martaka rimarka: Ari, yachani kay mundu tukurihushpan turinika tukuy wañushkakunawa pakta kawsarimunanta. ");
INSERT INTO qupNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesuska aynirka: Ñukami kani wañushkakunata kawsachik, runakunata wiñaypa Yaya Dioswa kawsayta kuk. Maykan runami ñukapi sinchikun, payka wañushpanpas kawsanmi. ");
INSERT INTO qupNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Maykan runami ñukapi sinchikushpa kawsan, payka wañushpanpas nima ima uras ñukamanta anchurishka kankachu. ¿Kirinkichu kay rimashkaynita? ");
INSERT INTO qupNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Martaka Jesusta aynirka: Ari, kirinimi chapashkanchi Yaya Diospa Kachanan Kishpichik kanaykita. Yaya Diospa Wawanmi kanki, maykanmantami Yaya Dios rimarka kay allpama shamunanta. ");
INSERT INTO qupNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Chasna rimashkanwasha Martaka ñañan Mariata kayak rirka. Alimanta rinkrinpi rimarka: Ñukanchita yachachikmi shamuhun, kantami kayahun. ");
INSERT INTO qupNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Chasna rimashkata uyashpanlla utkalla atarirka Jesusma shamunanpa. ");
INSERT INTO qupNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús ñukanchi runankunawa manara chay llaktankunapi paktahurkanchirachu. Maypimi Martaka ñukanchita tinkuk shamurka chayllapi karkanchi. ");
INSERT INTO qupNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Chay wasinpi Jerusalenmanta israel masinchikuna Mariata llakihushkanpi sinchikuchishpa kahurkakuna. Kallpa rishkanta rikushpankuna yuyarirkakuna Lasaropa aychanta churashkankuna uchkuma wakananpa rihushkanta. Chasna yuyarishpankuna payta katirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Chasna Mariata katihushpankuna paywa pakta Jesusta tinkuk shamurkakuna. Chaypi Mariaka Jesuspa puntanpi kunkurishpan rimarka: Yachachik, kan kaypi kankima karka, turinika mana wañumachu karka. ");
INSERT INTO qupNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesús Mariata paywa pakta kahuk runakunata wakahushkankunata rikushpan llakirirka, wañuyta shunkunpi piñarirka. ");
INSERT INTO qupNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Chaypina paykunata tapurka: ¿Maypita payta churashkankichi? Paykunaka aynirkakuna: Chaypimi churashkanchi. Akuychi rikuk rishunchi. ");
INSERT INTO qupNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Chasna rimashpankuna Jesús paykunawa pakta llakirishpan wakarka. ");
INSERT INTO qupNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Wakahushkanta rikushpankuna paykunapura rimarkakuna: Rikuychi maytukuytata Lasarota yuyarka. ");
INSERT INTO qupNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Shukkuna rimarkakuna: Pay ampirka wisku wawayarishkata. Lásaro manara wañushpanra ¿imaraykutaya mana ampishkachu? ");
INSERT INTO qupNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Lasaropa aychanta churashkankuna uchkupi paktahushpanchi Jesús kutikashka shunkunpi wañuyta piñarirka. Chay churashkankunaka karka shuk urku uchkupi. Punkunka atun rumiwa taparishka karka. ");
INSERT INTO qupNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Chaypi Jesuska runakunata rimarka: Anchuchiychi chay punkuta tapak rumita. Chayta uyashpan wañushkapa panin Martaka rimarka: Yachachik, kunanka ña millaypata asnan, ña chusku puncha chay uchkupi kahushkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Chaypina Jesuska rimarka: Ña kanta rimashkani, ñukapi sinchikushpayki Yaya Diospa atun yachayninta rikunkimi. ");
INSERT INTO qupNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Chayta uyashpankuna shukkunaka chay uchku punkuta tapak rumita anchuchirkakuna. Jesuska siluma rikushpan rimarka: Yayayni, kanta agradesinimi tapushkaynita uyashkaykirayku. ");
INSERT INTO qupNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yachanimi tukuy uras tapushkaynita ruranaykita. Chasna yachashpaynipas sinchita rimashpa kanta agradesishkani kay runakuna uyanankunapa. Yapa munani kachawashkaykita kirinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Chayta rimashkanwasha Jesuska sinchita kayarka: ¡Lásaro, llukshimuy chay uchkumanta! ");
INSERT INTO qupNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Chay wañushkaka llukshimurkana. Paypa makin chakin pillurishka karkakuna ñañu llachapawa, uyan pillurishka karka llachapawa. Chaypina Jesuska rimarka: Paskaychi pillurishkanta rinanpa. ");
INSERT INTO qupNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Chasna Lasarota kawsachishkanta rikushpankuna Mariawa pakta achka shamushka israel masinchikuna Jesuspi sinchikurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Shukkunaka fariseokunama rirkakuna tukuy Jesuspa rurashkanta kwintanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Chasna rimashkankunata uyashpankuna saserdotekunapa apunkunaka tukuy paykunawa pakta tantaylla yuyarishpa kwintak atun apunchikunata kayachirkakuna tantarinankunapa. Tantarishpankuna paykunapura Jesusmanta kwintarkakuna: ¿Imatataya rurashunchi? Chay runaka atun yachaywa achka nima ima uras rikushkanchikunata rurahun. ");
INSERT INTO qupNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Shuk imata rurananchi tiyan manana chaykunata rurashpa kawsananpa. Chasna rurashpa katishpanka tukuy runakunami payta kasunkakuna, Yaya Diospa Kachashkan Kishpichikmi kuntranchikunamanta kishpichinanpa nishpa. Chasna kashpan ñukanchikunata winsishka romano runakuna piñarishpankuna waklichinkakuna Yaya Diospa wasinta, chaymantapas wañuchinkakuna tukuy ñukanchi israel runakunata. ");
INSERT INTO qupNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Chay wata Kaifaska saserdotekunapa atun apu kashpan tukuy chay apunchikunamanta ashwan atun apumi karka. Chaypi payka chay shukkunata rimarka: Kankunaka nima imata yachankichichu. ");
INSERT INTO qupNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Yuyariychi, ashwan ali kama shuk runalla tukuy runakunaranti wañunanpa, mana tukuy ñukanchi israel runakuna wañunanchipa. ");
INSERT INTO qupNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Chasna rimashkanka mana pay kikin yuyayninmantachu karka. Chay wata saserdotekunapa atun apu kashpan Yaya Dios payta yuyachirka Jesús ñukanchi israel runakunaranti wañunanmanta rimananpa. ");
INSERT INTO qupNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Chaymantapas yuyachirka manami ñukanchi israel runakunarantillachu wañunanmanta rimananpa, ashwan wañushpan tukuy partimanta Yaya Diospa wawankunata shuk ayllullatashina rurananta rimananpa. ");
INSERT INTO qupNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Chasna Kaifás rimashkanmanta pacha apunchikuna shuk yuyayllawa yuyarirkakuna imashnami ima urasmi Jesusta wañuchichinkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Chayta yachashpan Jesuska manana purirkanachu achka israel masinchikuna rikushkankunapi. Ñukanchiwa pakta chay llaktakunamanta llukshirka. Shuk llakta Efraín shutiyuma rirkanchi. Chay llaktaka chunlla chakishka allpa mayanpi karka. Chaypi kiparirkanchi. ");
INSERT INTO qupNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ñukanchi israel runakunapa Paskua punchakuna kuchupi kashpan achka llaktakunamanta israel masinchikuna Jerusalén llaktama rirkakuna tantarinankunapa. Chay tantarina manara paktarihushpanra paktarkakuna Yaya Diospa kamachishkanshina alicharinankunapa. Mayllaripayanahun atipanankunapa yaykunata chay tantarinapi. ");
INSERT INTO qupNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Chaypi kashpankuna Jesusta maskashpa purirkakuna. Yaya Diospa wasinpi tapunakushpa kahurkakuna paykunapura: ¿Imashnata kankunaka yuyarinkichi Jesusmanta, shamunkachu kay tantarinapi manachu? ");
INSERT INTO qupNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Puntiru paktashpankuna fariseokuna saserdotekunapa apunkunapas kamachirkakuna, maykan runapas Jesusta rikushpanka rimak rinankunapa apinankunapa payta. ");
INSERT INTO qupNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Paskuarayku sokta puncha pishihushpanra Jesuska ñukanchiwa pakta kuti Betania llaktama rirka. Chay llaktapi Lasaroka kawsarka, maykantami Jesuska wañushka kashkanmanta kawsachirka. ");
INSERT INTO qupNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Payta kawsachishkanrayku Jesuspa amigunkuna shuk atun mikunata rurarkakuna payta kushichinankunapa. Chaypi tantarishpanchi Martaka mikunata churanata yanaparka. Lásaro chaypi ñukanchiwa pakta mikuhurka. ");
INSERT INTO qupNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Chasnapi Mariaka apamurka shuk butilla perfumita yapa chaniyuta. Chay perfumika nardo shutiyu anku yaku karka. Chayta talirka Jesuspa umanmanta chakinkama. Chasna talishpan chakichirka chukchanllawa. Tukuy wasi mishkihlla asnarka. ");
INSERT INTO qupNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Chaypina chay Jesuspa chunka ishkay runan masinchi Judas Iskariote, maykanmi payta apichina karka kasna rimarka: ");
INSERT INTO qupNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","¿Imaraykuta chay perfumita mana kimsa pachak denariospi rantichishkanchichu? Apinchima karka maykantami shuk runaka shuk watata tarawashpan ganan, chay kullkiwa mana imayu runakunata yanapananchipa. ");
INSERT INTO qupNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judaska mana chayta rimashkachu mana imayu runakunata yanapananpa. Chayta rimashkami pay kikin kullkita shuwanata munashkanrayku. Kullkinchita wakaychak kashpan wakaychana kahamanta shuwapayan. ");
INSERT INTO qupNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesuska paypa rimashkanta uyashpan rimarka: Ama chay panita chasna rimaychu. Payka wakaychashkami talinanpa wañunayni kuchupi kashkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Nima imayu runakunaka tukuy urasmi kankunawa kawsankakuna. Ñukataka mananami tukuy uras rikuwankichinachu. ");
INSERT INTO qupNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Israel masinchikuna Jesús Betaniapi kahushkanta yachashpankuna chayma shamurkakuna. Mana shamurkakunachu Jesusllata rikunankunapa, ashwan Lasarotapas rikunankunapami shamurkakuna, maykantami Jesús wañushka kashkanmanta kawsachirka. ");
INSERT INTO qupNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Achka runakuna Lasarota rikunapa shamushpankuna saserdotekunapa apunkunaka yuyarirkakuna Lasarotapas wañuchichinata. ");
INSERT INTO qupNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Jesús Lasarota kawsachishkanmantami achka israel runa masinchikuna Yaya Diospa Kachashkan Kishpichik kananta kirirkakuna. Chasna kashpan chay apukuna Lasarotapas wañuchichinayarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Chay kayantima Jesuska rihurka Jerusalén llaktama. Achka runakuna Paskua tantarina punchakunarayku chaypi kahushpankuna Jesús paktahushkanta yacharkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Chaypi chipati pankakunata pallashpankuna llukshirkakuna chay pankakunata kuyuchishpa Jesusta atun aputashina tinkunankunapa. Payta tinkushpankuna kushikushpa kaparirkakuna: ¡Ñukanchita kishpichiy! Yaya Diospa yanapashkan ali runami kanki. Yaya Diospa munashkanta ruranaykipa kachashkan kashpaykimi shamuhunki. Ñukanchi israel runakunapa atun apunchimi kanki. ");
INSERT INTO qupNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesuska shuk malta burruta tinkushpan awanpi sikashpan tiyarirka. Chasna paktachirka ñawpa killkarishkata. ");
INSERT INTO qupNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Kasna nin: Manana nima imata manchaychinachu Sión urku Jerusalén llaktapi kawsak runakuna. Rikuychi, atun apuykichimi ña shamuhun kankunata kishpichinanpa. Shamuhunmi shuk burru maltapa awanpi tiyarishpa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ñukanchi Jesuspa runankunaka chay uras manara asirtashkanchirachu Jesús chay rurashkanwa ñawpa killkarishkata paktachihushkanta. Jesús tukuymanta atun apu tukunanpa siluma sikashkanwashara asirtarkanchi. Chay uras yuyarirkanchina chasna paymanta killkarishka kashkanta, chaymanta killkarishkashina paypi paktarishkanta. ");
INSERT INTO qupNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jesús manara Jerusalén llaktama rihushpan Lasarota kawsachishkanta rikuk runakuna shukkunatana kwintak rirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Chay nima ima uras rikushkanchita atun yachaywa rurashkanta uyashpankuna chay achka runakuna Jesusta tinkuk shamurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Chasna achka rihushkankunata rikushpankuna fariseokunaka paykunapura rimarkakuna: Chay runata apichinanchipa yuyarishkanchika yanka nishpami kashka. Rikuychi, tukuy runakuna payta katihunkuna. ");
INSERT INTO qupNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Chay Paskua punchakunarayku Jerusalén llaktama rishpankuna israel masinchikunawa pakta shuk griego runakunapas rirkakuna. Ñukanchikunawa pakta munarkakuna chay tantarinapi ñukanchipa Yaya Diosninchita kushichishpa mañanata. ");
INSERT INTO qupNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Chay griego runakunaka Jesuspa chunka ishkay runan masinchi Felipeta kayllayarkakuna. Felipe karka Galilea allpapi kahuk Betsaida llaktamanta. Chaypi payta tapurkakuna: Wawki, Jesustami riksinayanchi. Ñukanchita riksichiy. ");
INSERT INTO qupNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Tapushkankunata uyashpan Felipeka Jesuspa chunka ishkay runan masinchi Andresta rimak rirka. Chaymanta ishkanti Jesusta rimak shamurkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Chaypi Jesús paykunata rimarka: Shuk allpamanta runakuna ñukata riksinata munawanankunata rimawankichi. Chayta uyashpayni yachani kunan shuti ña punchaka paktarishkanta Yayayni Dios runakunata rikuchinanpa ñuka paypa Kachashkan Runa yapa ali kanaynita. ");
INSERT INTO qupNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Alita uyawaychi. Shuk muyu allpapi ismunan tiyan wiñananpa. Wiñashpan miranmi. Mana ismushpanka mana miranchu, muyulla kan. Ismushpanka wiñashpan muyuyan. Muyuyashpan achkata miranka. Chasnashinami ñuka wañunayni tiyan kawsarimushpayni achka runakunata uchankunamanta kishpichinaynipa. Mana wañushpaynika nima pi atipankachu Yaya Diospa kawsananpi yaykunata. ");
INSERT INTO qupNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Chaymanta maykan runami pay kikinpa munashkanta rurashpa kawsan, chayka yankami kawsan. Manami nima ima uras Yaya Dioswa kawsankachu. Maykan runami kay allpapi kawsahushpanra pay kikinpa munashkanta sakin Yaya Diospa munashkantana rurashpa kawsananpa, chayka wiñaypami Yaya Dioswa kawsanka. ");
INSERT INTO qupNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Maykan runami munashkaynita rurashpa kawsan, payka ñukashina kawsanan tiyan. Maykan runami chasna ñukata katiwan, maypipas kashpayni chaypimi paypas kanka. Maykan runakunami munashkaynita rurak kanahun, paykunatami Yayaynika kushikushpan atunyachinka. ");
INSERT INTO qupNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Kunanka atunta mancharihuni. ¿Imatataya rurasha? ¿Alichu kama tapunaynipa: Yayayni, kishpichiway mana chasna parisinaynipa nishpa? Chasnaka manami alichu kama. Chasna parisinaynipami shamushkani. ");
INSERT INTO qupNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Yayayni, kay parisinayniwa runakunata ñukapi rikuchiy yapa ali atun yachayyu kanaykita. Chasnallapi uyarkanchi silumanta rimahushkata: Ñami runakunata kanpi rikuchishkani yapa ali atun yachayyu kanaynita, chasnallatatami kutikashka rikuchisha. ");
INSERT INTO qupNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Jesuswa pakta kahuk runa masinchikuna chay rimashkata uyashpankuna paykunapura kwintarkakuna: Rayushina uyarishka. Shukkunaka rimarkakuna: Shuk angelmi payta rimashka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesuska chaypi paykunata rimarka: Chasna uyashkaykichika mana karkachu ñukarayku, ashwan karkami kankunata yanapananpa Yaya Diosmanta kanaynita kirinaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Kunanka Yaya Dioska manana chapanchu tukuy runakunapa uchankunarayku atun kastiguta paktachinanpa. Kunanka ñami supaykunapa apunta tukuy runakunata kamachik kashkanmanta wichunata kallarinka. ");
INSERT INTO qupNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ñukata allpamanta awama alsawashpankuna tukuy partimanta runakunata munachisha riksiwanankunapa, chaymantapas yanapasha ñukapi sinchikunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Chasna rimashkanwa yachachinayarka imashnami wañunka. ");
INSERT INTO qupNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Chaypi kahuk runa masinchikunaka wañunanmanta rimashkanta uyashpankuna aynirkakuna: Yaya Diospa killkachishkanmanta yachanchi chapahushkanchi Yaya Diospa Kachanan Kishpichik wiñaypa kawsananta. ¿Imashnataya kanka ñukanchita rimanki Yaya Diospa Kachashkan Runa kashpayki kanta allpamanta awama alsashpankuna wañunaykita? Chasna kashpan manami Yaya Diospa Kachashkan Runachu kanki. ");
INSERT INTO qupNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Chasna shuk killkarishkakunata mana alita asirtashpankuna manana paypi sinchikunayashpankuna Jesuska paykunata rimarka: Manana tiyannachu timpuka kankunata asirtachinaynipa. Ñuka punchashina kahukka shuk ratullami yachachishpa kankunawa kasha. Imashnami punchaka tukuyta alita rikuchin, chasnashinami ñukapas kankunata shutipa kashkata riksichishkani. Chayrayku manara kankunata sakishpayni yachachishkaynimanta asirtashkaykichita kirishpa alita rurashpa kawsaychi, mana supayka shunkuykichipi llullachishpan chay asirtashkaykichita kichunanpa. Asirtashkaykichita kichushpanka mananami nima ima uras kuti asirtankichichu. Chasna kashpan amsapishina purishpa kawsankichi, mana yachashpa maytami rinkichi. ");
INSERT INTO qupNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ñuka punchashina kahuk kankunawa kahushpaynira ñukapi sinchikuychi kankunapas ñukashina punchayachik tukunaykichipa. Chasna rimashkanwasha Jesuska paykunata sakishpan pakarkana paykunamanta. ");
INSERT INTO qupNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Chay runakunaka atun yachaywa achka nima ima uras rikushkanchita rurashkanta rikushpankunapas chaymantapas yachachishkanta uyashpankunapas Jesuspi mana sinchikunayarkakunachu. ");
INSERT INTO qupNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Chaywa Yaya Diospa yachayninwa ñawpa yachachik Isaias wañupa rimashkanka paktarirka. Payka chay runakuna mana kirinankunamanta rimarka kasna: Yaya Dios, runakunaka mana munashkakunachu yachachishkanchita kirinata. Mana atipaypakunata rurashkaykita rikushpankunapas mana asirtashkakunachu chay rurashkaykiwa yachachinayashkaykita nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Chay runakunaka mana munashpankuna Jesusta kirinata Isaias wañupa shuk killkashkanka paykunapi paktarirka kasna nishkaka: ");
INSERT INTO qupNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Yaya Dios ñawinkunata tapachishka mana rikunankunapa. Yuyayninkunata tapachishka mana asirtanankunapa. Yaya Dios kasna nin: Chasna paykunata rurashkani taparishka ñawiyukunashina taparishka yuyayyukunashina kanankunapa. Mananami munanichu uchankunamanta llakirishpankuna ñukata kasuwanankunata, mana paykunata llakichishpayni kuti aliyachinaynipa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Chaykunatami Isaias wañuka ñawpa killkarka rikushpan Jesús yapa ali atun yachayyu tukunanta. ");
INSERT INTO qupNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Isaias chasna killkashpanpas chay apunchikunamanta achka Jesuspi kirirkakuna. Chasna kashpanpas fariseokunata manchashpankuna kirishkankunata mana rimarkakunachu. Mana munarkakunachu chay kamachik masinkuna paykunata tantarina wasimanta wichunankunapa. Chasna wichuy tukushpankunaka manana atipanahumachu paykunawa pakta tantarinata. ");
INSERT INTO qupNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Mana yuyarirkakunachu imashnami atipanahuma Yaya Diospa rikushkanpi ali kanata. Yapa munarkakuna runa masinkuna ali kanki nishpa rimanankunata. ");
INSERT INTO qupNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Chaypina Jesuska sinchita rimarka: Maykanmi ñukapi sinchikun, payka chasnallatatami sinchikun Yayaynipipas, maykanmi ñukata kay allpama kachawashka. ");
INSERT INTO qupNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Maykanmi ñukata rikuwan, chayka ñukata kachawaktapas rikunmi. ");
INSERT INTO qupNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ñuka runakunarayku punchashina kashpayni kay allpama shamushkani ñukapi sinchikukkuna mana amsapishina kiparinankunapa uchata rurashpa. ");
INSERT INTO qupNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Shuk runa rimashkaynita mana kasushpanka manami ñukachu payta kastigasha. Ñukaka kay allpama shamushkanimi runakunata uchata rurak kanankunamanta kishpichinaynipa. Manami shamushkanichu uchankunamanta kastiganaynipa. ");
INSERT INTO qupNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Maykan runami ñukata mana munawanchu, chaymantapas rimashkaynita mana kasunayanchu, paymi ña kastigarishka kan. Kay rimashkaynimantalla kastigarishka kananta yachan. Kay mundu tukurinan uras kay rimashkaynillatata uyashpan kastigarinanta yachanka, wiñaypa Yaya Diosmanta anchurishka kananta. ");
INSERT INTO qupNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kasna rimashkaynika manami ñuka kikin yuyaynimantachu. Ashwan Yayayni, maykanmi ñukata kachawashka tukuyta rimawarka imatami yachachisha. ");
INSERT INTO qupNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Yachani Yayaynipa shiminka runakunata riksichinanta imashnami wiñaypa paywa kawsankakuna. Chayta yachashpayni tukuy Yayaynipa rimawashkanta kankunata alita yachachini. ");
INSERT INTO qupNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pishihushpanra shuk puncha Paskua punchakuna paktarinankunapa Jesús yacharka ña wañunanta. Yacharka ña kay allpata sakinanta Yayanwana silupi tantaylla kawsak rinanpa. Tukuy uras Yaya Diosta mana kasuk runakuna chawpipi kawsak ñukanchi runankunata yapa yuyapayan. Kunanka ñukanchita yapa yuyashkanta rikuchinan karka ñukanchiranti wañushpan. ");
INSERT INTO qupNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jesús Paskua puncha ñukanchiwa tutapi mikuhushpan supaykunapa apunka ña yaykushka karka Judaspa shunkunpi. Payta yuyachirka Jesusta apichinanpa. Chay Judaska Simón Iskariotepa wawan karka. ");
INSERT INTO qupNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","4","Jesús yacharka Yayan Diosmanta shamushkanta, paymallatata kutinanta. Chaymantapas yacharka Yayanka payta atun yachayninta kushkanta tukuymanta atun kamachik kananpa. Chasna yachashpan mikuhushkanchimanta atarirka, awaniru kamisanta llatanarka. Chaymanta shuk llachapawa wiksanpi watarirka. ");
INSERT INTO qupNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Yakuta mukawapi talishpan kallarirka chakinchikunata mayllanata. Karan shukpa chakinta mayllashkanwasha llachapa watarishkanwa chakichirka. ");
INSERT INTO qupNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Chaypina Pedropi paktarka chakinkunata mayllananpa. Mancharishpan Pedroka rimarka: Amuyni, ¿kanchu chakinita mayllawanki? ");
INSERT INTO qupNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesuska payta aynirka: Manara asirtankirachu rurahushkaynita. Shuk punchami alita asirtanki. ");
INSERT INTO qupNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedroka Jesusta rimarka: Nima ima uras chakinita sakishanchu mayllawanaykipa. Jesuska payta aynirka: Ñuka chakikita mana mayllashpaynika manami atipankichu ñukawa pakta kawsanata. ");
INSERT INTO qupNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Chasna uyashpan Pedroka rimarka: Amuyni, chasna kashpan ama chakinillata mayllawaychu ashwan umaynitapas makinitapas mayllaway. ");
INSERT INTO qupNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesuska aynirka: Maykanmi mushu armashka payka mana munanchu kuti armak rinata. Payka chakinllatami mayllanata munan. Tukuy aychanka ñami alita mayllarishka. Kankunaka ña alita mayllarishkashinami kankichi. Shukllami kankunamanta mana mayllarishkashinachu kan. ");
INSERT INTO qupNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesuska ña yacharka pimi payta apichinka. Chayrayku rimarka manami tukuy kankunachu mayllarishkashina kankichi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Chasna chakinchikunata mayllashkanwasha kuti churarirka awaniru kamisanta. Mesama kutishpan ñukanchita rimarka: ¿Asirtankichichu kay rurashkayniwa yachachinayashkaynita? ");
INSERT INTO qupNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Kankunaka Yachachik, Amuyni niwankichi. Alimi kan. Ñukami kani. ");
INSERT INTO qupNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Chasna kankunata Yachachik Amuykichi kashpaynipas chakikichita mayllashkani. Kankuna parihu runaynikuna kashpaykichi ashwan kankuna munay yanapanakunaykichi tiyan, karan shuk amun kamachishkanshina shukwa shukwa kankunapura. Chaymanta shuk kirik masikichi mana alita rurashpanka payta yanapanaykichi tiyan kutikashka alita rurashpa kawsananpa. Chaymantapas llakichinakushpa kawsanaykichi tiyan, Yaya Dios uchaykichitapas llakichishpan alita mayllarishkashina kanaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Imashnami ñuka kankunata rurashkayniwa rikuchishkani, chasnashina kankunapas ruraychi shukwa shukwa. ");
INSERT INTO qupNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Alita uyawaychi. Nima shuk runan patroyninmanta pasa kanchu. Shuk kachashkan runa mana kanchu payta kachak runamanta pasa. Chasnashinami kankunapas mana ñukamanta pasa kankichichu. Imatami rurani ñukaka, kankunapas ruranaykichi tiyan. ");
INSERT INTO qupNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tukuy chay rurashkaynita kunan ña asirtashkankichi. Kunanka chay asirtashkaykichita ruraychi. Chayta paktachishpa kawsashpaykichika kushillami kankichi. ");
INSERT INTO qupNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Yayayni kankunata kushillayachinka nishpa rimashpayni manami tukuy kankunata kushillayachinanmantachu rimani. Riksinimi imashna runakunatami akllashkani. Chasna kashpan yachani shuk kankunamanta mana ali yuyayyu kananta. Paktarinan tiyan imashnami killkarishka kan: Maykanmi ñukawa pakta mikupayarka chayka kuntrayni tukushka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Kunan manara paktarishpanra chayta kankunata rimashkani, ña paktarishpan yachanaykichipa Yaya Diosmanta kashkaynita. ");
INSERT INTO qupNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Alita uyawaychi. Ama llakiriychichu. Kankunatami akllashkani tukuy partima kachanaynipa. Maykan runami shuk kankunata wasinpi yaykuchin, payka ñukatapas yaykuchiwanmi. Ñukata yaykuchiwashpan kachamuwashka Yaya Diostapas yaykuchinmi. ");
INSERT INTO qupNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Chasna rimashkanwasha Jesuska shunkunmanta pacha llakirirka. Chaypi ñukanchi runankunata rimarka: Alita uyawaychi. Shuk kankunamanta ñukata apichiwanka. ");
INSERT INTO qupNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ñukanchi mancharishpanchi rikunakurkanchi. Mana yacharkanchichu pimantami chasna rimarka. ");
INSERT INTO qupNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ñuka Jesuspa yapa munashkan runan kuchunpi mikuhurkani. ");
INSERT INTO qupNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Chaypi kahushpayni Pedroka makinwa rikuchiwarka Jesusta tapunaynipa pimantami chasna rimahurka. ");
INSERT INTO qupNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ashwanta Jesusta kayllayashpayni alimanta tapurkani: Amuyni, ¿pimantata chasna rimahunki? ");
INSERT INTO qupNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesuska ayniwarka: Maykantami kay piti panta ukuchishpayni kusha, paymi kanka. Chasnallapi vinupi panta ukuchishpan Simón Iskariotepa wawan Judasta kurka. ");
INSERT INTO qupNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Chay pan pitita apishkan ratulla supaykunapa apunka paypa shunkunpi yaykushpan sumakta amuyarka. Chayta yachashpan Jesuska payta rimarka: Yuyarishkaykita utkalla rurakriy. ");
INSERT INTO qupNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ñukanchi paykunawa pakta mikuhukkunaka mana asirtarkanchichu imamantami chasna rimahurka. ");
INSERT INTO qupNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas kullkinchita wakaychak kashpan ñukanchimanta shukkuna yuyarirkanchi, Jesuska paytachari rimashka rantikriy nishpa tantarina punchakunapi mikunanchipa, mana kashpaka nishkachari nima imayu runakunata kullkita kukriy nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Chasna panta apishkanwasha Judaska llukshirkana. Chay uras ña tutana karka. ");
INSERT INTO qupNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas llukshishkanwasha Jesuska ñukanchita rimarka: Kunanka tukuy runakuna rikunkakuna ñuka Yaya Diospa Kachashkan Runa yapa ali atun yachayyu kanaynita paykunaranti wañushpayni. Yaya Dios chasna wañunaynipa kachawashka. Chayrayku runakuna rikushpankuna paykunaranti wañushkaynita, Yaya Diospas yapa ali atun yachayyu kananta riksinkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Chasna ñuka Yaya Diospa Kachashkan Runa runakunata rikuchishpayni paypa ali atun yachayyu kananta, Yaya Diospas runakunata riksichinka payshina ali atun yachayyu kanaynita. Mana unayankachu mana atipaypa kashkata rurashpa chasna kanaynita runakunata riksichinanpa. ");
INSERT INTO qupNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Wawkinikuna, manana unaytachu kankunawa kasha, shuk ratustulla kiparisha. Kankunamanta rishpayni ñukata maskawankichi. Imashnami apunchikunata puntiru rimarkani, chasnallatatami kunanka kankunata rimani: Mana atipankichichu rinata maymami ñukaka risha. ");
INSERT INTO qupNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Kunanka kankunarayku shuk mushu kamachinata sakihuni: Yuyanakushpa kawsaychi shukwa shukwa kankunapura. Imashnami ñukaka kankunata yapa yuyani, chasnallatata kankunapura alita yuyanakuychi. ");
INSERT INTO qupNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Chasna yuyanakushpa kawsahushkaykichimanta runa masikichikunaka riksinkakuna shutipa ñukata katik kahushkaykichita. ");
INSERT INTO qupNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Chaypina Pedroka Jesusta tapurka: Amuyni, ¿maymataya rinki? Jesuska aynirka: Maymami rihuni mana kunallaka atipawankichu katinata. Chaywasharami shuti katiwanki. ");
INSERT INTO qupNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedroka rimarka: Amuyni, ¿imaraykuta mana atipashanchu kunalla katinata? Wañushanpas kanta kishpichinaynipa. ");
INSERT INTO qupNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesuska payta aynirka: ¿Shutipachu kishpichiwanaykipa wañunayanki? Kanta rimani, manarapas atallpaka kantahushpanra kimsa kutimi llullachishpa rimanki mana riksiwanaykita. ");
INSERT INTO qupNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Chaymantana tukuy ñukanchita rimarka: Wañushpayni ama manchariychichu nima llakiriychichu. Tukuy uras Yayayni Diospi sinchikuychi chasnallatata ñukapipas. ");
INSERT INTO qupNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Yayaynipa kawsananpi tiyan achka wasikuna. Chayma risha alichanaynipa wasikichikunarayku. Mana chasna kamaka manami kankunata chayta rimaynimachu karka. ");
INSERT INTO qupNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Kaymanta rishpayni alichak risha wasikichikunarayku. Chaywasha kutimusha kankunata pushanaynipa ñukawa pakta kawsanaykichipa. Yapa munani kankunapas kanaykichipa maypimi ñukaka kasha chaypi. ");
INSERT INTO qupNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ña kankunaka riksinkichimi ñampita maytami ñukaka risha. ");
INSERT INTO qupNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Chaypina Tomaska Jesusta rimarka: Amuyni, mana yachanchichu maytami rinki. ¿Imashnataya riksishunchi ñampitaka? ");
INSERT INTO qupNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesuska aynirka: Ñukami kani shuklla Yaya Diospi paktak ñampishina. Maykanmi ñukata katiwan, payllatami riksichisha imashnami Yayayni Dioska shutipa kan. Ñukallami kani Yayayni Diosta riksichik, chaymantapas wiñaypa paywa kawsayta kuk. Nima pi atipanchu Yayayni Diospi paktanata mana ñukata katiwahushpanka. ");
INSERT INTO qupNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kankunaka shutipa ñukata riksiwashpaykichika Yayaynitapas riksinkichimi. Kunanmanta pacha payta riksinkichimi ña rikushkaykichirayku. ");
INSERT INTO qupNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Felipeka aynirka: Amuyni, Yayaykita ñukanchita rikuchiy. Chayllatami munanchi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesuska payta aynirka: Felipe, ¿unayta kankunawa kahushpaynitatachu kunankama ñukata mana riksiwanki? Maykanmi ñukata rikuwan, payka rikuhumi Yayaynitapas. ¿Imaraykuta tapuwanki Yayaynita rikuchinaynipa? ");
INSERT INTO qupNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Manachu kirinki ñuka Yayayniwa shuk yuyayllawa kahushpanchi shukllashina kahushkanchita? Manami ñuka kikin yuyaynimantachu kankunata yachachishkani. Tukuy uras ñukawa kahuk Yayayni Dioska munashkanta rurachiwan. ");
INSERT INTO qupNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kiriwaychi Yayayniwa shuk yuyayllawa kahushkanchita. Mana chayta kirinayashpaykichika rurashkaynita rikushpaykichi kiriwaychi. ");
INSERT INTO qupNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Alita uyawaychi, tukuy ñukapi sinchikukkunami ñukashina rurashpa kawsankakuna. Mana chayllachu. Ñuka Yayaynima kutishpayni ashwan atun mana atipaypakunatami rurankichi. ");
INSERT INTO qupNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Tukuy maykantami munashkaynitashina tapuwankichi ñuka rurashami Yayayni ali atun yachayyu kananta runakunata rikuchinaynipa. ");
INSERT INTO qupNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ñuka munashkaynitashina tapuwashpaykichika tukuy tapuwashkaykichita rurashami. ");
INSERT INTO qupNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ñukata yuyawashpaykichika kamachishkaynikunata paktachinkichimi. ");
INSERT INTO qupNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Chasna yuyawashkaykichita rikuchiwashpaykichimi Yayaynita tapusha ñukaranti kankunata sinchikuchik Espiritunta kachananpa tukuy uras kankunawa kananpa. ");
INSERT INTO qupNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Espiritunta kachananpa tapusha, maykanmi kankunata tukuy shutipa kashkata riksichinka. Yayayni Diosta mana riksik runakuna chay Espiritunta manami riksinahunchu payta mana rikushkankunarayku. Chayrayku mana atipanahunchu payta shunkunkunapi yaykuchinata. Kankunaka payta riksinkichimi kankunawa kahushkanrayku. Shunkuykichipimi kawsan, nima ima uras kankunamanta anchurinkachu. ");
INSERT INTO qupNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ñukaka manami kankunata wakchatashina sakishkaykichichu. Kutimushami kankunawa kanaynipa. ");
INSERT INTO qupNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ñami wañunayni punchaka paktarishka. Ñukata mana riksik runakunaka manana rikuwankakunachu. Kankunallami rikuwankichi. Ñuka wiñaypa kawsa kahushkaynirayku kankunapas wiñaypa kawsankichi. ");
INSERT INTO qupNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Yaya Diospa Espíritun kankunapi paktashpan yachankichi ñuka Yayayniwa shuk yuyayllawa kahushkaynita. Chaymantapas yachankichi ñuka kankunawa shuk yuyayllawa kahushkaynita, kankunapas ñukawa. ");
INSERT INTO qupNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Maykan runami kamachishkaynita shunkunpi wakaychashpan kasun, payllami shutipa yuyawan. Maykanmi ñukata yuyawan, Yayaynipas payta yuyankami. Ñukapas payta yuyashami, chaymantapas yanapashami alita riksiwananpa. ");
INSERT INTO qupNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Chaypi chay chunka ishkay Jesuspa runan masinchi Judas, mana Iskariotepa wawanchu, Jesusta tapurka: Amuyni, ¿imaraykuta ñukanchillata riksichirinki pimi kanki? ¿Imaraykuta Yaya Diosta mana riksikkunatapas mana riksichirinkichu pimi kanki? ");
INSERT INTO qupNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesuska aynirka: Ñukaka riksichirishami pimi kanaynita yuyawak runallata. Maykan runami yuyawan payka yachachishkaynita kasun. Chasna yuyawak runata Yayaynipas yuyankami. Chaymantapas Yayayniwa pakta paypa shunkunpi kawsak shamushu. ");
INSERT INTO qupNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mana yuyawak runataka manami riksichirinichu pimi kani, yachachishkaynita mana kasunayashkanrayku. Manami ñuka kikin yuyaynimantachu kankunata chayta yachachini. Yayayni Diosmi kachawashka chasna yachachinaynipa. ");
INSERT INTO qupNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Tukuy kaykunata kankunata yachachihuni kankunawa kahushpaynira. ");
INSERT INTO qupNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Yayayni Dioska ñukaranti kankunata yanapak Espiritunta kachanka. Chay Espiritunka kankunata yachachishkaynita yuyachinka, chaymantapas yachachishpa tukuyta asirtachinka. ");
INSERT INTO qupNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ñuka rishpayni kankunata sinchikuchisha mana manchashpa nima musparishpa kushilla kawsanaykichipa. Mana kankunata llullachishpachu yanapani kushilla kawsanaykichipa, imashnami Yaya Diosta mana kasuk runakunaka ruranahun. Ashwan shutipami kankunata shunkuykichipi kushillayachisha. Chayrayku rinaynimanta rimashpayni ama llakiriychichu nima manchariychichu. ");
INSERT INTO qupNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ña uyashkankichi kankunata rimashkaynita, ñukaka rishami, chaymantapas kankunama kutimusha nishpa. Shutipa yuyawankichimaka kushikunkichimami karka yachashpaykichi Yayaynima rinaynita. Yayayni ñukamanta ashwan atun yachayyu kashpan ñuka payma rishpayni atipasha ashwan alita kankunata yanapanata. ");
INSERT INTO qupNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Manara rihushpaynira kankunata chayta rimani, paktarishpan yachanaykichipa rimashkaynika shutipa kashkata. ");
INSERT INTO qupNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","31","Kunanka manana achkata kankunata yachachishkaykichinachu. Shuk ratullami kankunawa kahuni. Ñami shamuhun tukuy Yaya Diosta mana kasuk runakunata kamachik supaykunapa apunka. Mana ñukata atipawashpantata nima imata ruranata ñuka munay sakini wañuchichiwananpa. Chasna wañushpayni Yayaynipa kamachiwashkanta kasusha tukuy runakuna payta yuyahushkaynita yachanankunapa. Kunan atariychi. Akuychi rishunchi. ");
INSERT INTO qupNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Shuk parti Yaya Diospa ñawpa killkachishkanpi riman israel runakuna Yaya Diospa tarpushkan uva waskashina kanankunata.Chayta yachashpan Jesuska ñukanchita yachachishpalla katirka: Kankuna yuyarinkichi Yaya Diospa runankuna kanaykichita, israel runakuna kashkaykichirayku. Manami chasnachu. Ashwan ñukapi sinchikushpaykichimi Yaya Diospa runankuna kankichi. Manami tukuy ñukanchi israel runakunachu kanchi Yaya Diospa tarpushkan ali uva waskashina. Ñukami kani chay tarpushkan ali uva waskashina. Yayaynika chay uva tarpupa amunshinami. ");
INSERT INTO qupNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kankunaka ramaynikunashinami kankichi. Mana muyuyak ramataka amunka pitinkami. Muyuyak ramataka alichankami ashwanta muyuyananpa. ");
INSERT INTO qupNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kankunaka kankichimi chay alichashkan alita muyuyak ramaynikunashina. Yachachishkaynita kasushpaykichi Yaya Dios kankunata aliyachirka. ");
INSERT INTO qupNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Chasna kashpaykichi mana sakishpa ñukawa pakta kawsaychi. Chasna kawsashpaykichimi ñukapas kankunawa pakta kawsasha. Shuk rama mana sapinwa pakta kahushpanka manami atipanchu muyuyanata. Chasnashinami kankunapas mana atipankichichu alita rurashpa kawsanata, mana ñukawa pakta kawsahushpaykichika. ");
INSERT INTO qupNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ñukami kani ali uva waskashina. Kankunaka kankichimi ramaynikunashina. Ñukawa pakta kawsashpaykichi ñukapas kankunawa pakta kawsashpayni achka alikunata rurashpa kawsankichi. Ñukamanta anchurishka kashpaykichi tukuy rurahushkaykichika yankami. ");
INSERT INTO qupNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Shuk rama manana waskanmanta yakuta aysashpanka wañunmi. Chasna shuk uva waskapa raman chakirishpan amunka pitinmi. Chaymanta chakirishkakunata tantachishpan rupachinna. Chasnashinami kankuna mana ñukawa pakta kawsahushpaykichika chay mana valik ramakunashinami wichurishka kankichi. ");
INSERT INTO qupNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Chasna kashpan mana sakishpa ñukawa pakta kawsaychi. Yachachishkaynita shunkuykichipi wakaychashpaykichi kasuychi. Chasna kawsashpaykichimi tukuy imatapas tapushkaykichita Yaya Dios kankunarayku rurankami. ");
INSERT INTO qupNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ñukata kasushpa tukuy alikunata rurashpa kawsashpaykichi shutipa ñukata kirikkunami kankichi. Chasna alita rurashpa kawsashpaykichi runa masikichikuna yachankakuna Yaya Dios yapa ali kananta. ");
INSERT INTO qupNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ñuka kankunata yuyani imashnami Yayaynika ñukatapas yuyawan. Chayrayku tukuy uras ñukawa pakta kawsaychi mana sakishpa kankunata yuyanaynipa. ");
INSERT INTO qupNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kamachishkaynita kasushpa kawsashpaykichika kankunata mana sakishpa yuyashkaykichi. Ñukapas Yayaynipa kamachishkanta kasushpa kawsashkani. Chasna kawsashpayni paypas ñukata mana sakishpachu yuyawan. ");
INSERT INTO qupNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Tukuy chayta kankunata rimani, kasushpaykichi ñukashina atunta kushikunaykichipa. Yapa munani chay atun kushikunaykichita nima ima arkananpa. ");
INSERT INTO qupNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Kasna kankunata kamachini: Imashnami ñukaka kankunata yuyani, chasnallatata kankunapas yuyanakushpa kawsaychi shukwa shukwa. ");
INSERT INTO qupNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Shuk munashkanchi runata wañuna kashkanmanta kishpichinanchipa wañushpanchi payta shutipa yuyashkanchita rikuchinchi. Mana atipanchichu payta yapa yuyashkanchita ashwan alita rikuchinata. Ñukaka kankunata kishpichinaynipa wañushpayni shutipa yuyashkaynita rikuchisha. ");
INSERT INTO qupNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kankuna kamachishkaynita paktachishpaykichimi munashkayni runakuna kankichi. ");
INSERT INTO qupNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Manana kankunata rimashkaykichinachu kamachinayni runaynikuna nishpa. Ashwan rimashkaykichimi munashkayni runakuna. Shuk patronpa kamachinan runaka mana yachanchu imaraykumi patroyninka kamachin. Kankunataka tukuyta yachachishkani, maykantami Yayaynika rimawashka. Chayrayku kankunata rimani munashkayni runakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Chasna tukushkaykichika mana kanchu kankuna ñukata munawashkaykichirayku. Ashwan ñuka kankunata munashpaynimi munashkayni runakuna tukushkankichi. Chasna kankunata akllashkani, kasuwashpaykichi ñukashina ali tukunaykichipa. Chaymantapas akllashkani runa masikichikunata Yaya Diospa shiminta yachachinaykichipa, paykunamantapas shukkuna ñukapi kirinankunapa. Chasna kasushpa yachachishpa kawsashpaykichika manami yankachu kanka. Yachachishkaykichimanta katiwakkunapas wiñaypa Yaya Dioswa kawsankakuna. Yapa munani alita kasuwak tukunaykichipa Yaya Dios tukuy munashkaynitashina tapushkaykichita rurananpa. ");
INSERT INTO qupNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Chayrayku kankunata kuti rimani: Yuyanakushpa kawsaychi shukwa shukwa kankunapura. ");
INSERT INTO qupNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jesuska ñukanchi runankunata yachachishpalla katirka: Mana riksiwak runakunaka kankunata chiknishpankuna ama manchariychichu. Yuyariychi ñukata puntiru chikniwashkankunata. ");
INSERT INTO qupNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kankunaka manami kankichichu ñukata mana riksiwak runakunashina. Ñukami kankunata akllashkani mana riksiwak runakunamanta manana paykunashina kawsanaykichipa. Paykunashina kankichimaka yuyanahumami. Manana paykunashina kahushkaykichiraykumi chay runa masikichikunaka kankunata chikninahun. ");
INSERT INTO qupNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Yuyariychi kankunata rimashkaynita kasna: Shuk runan manami patroyninmanta pasa kanchu. Chasnashinami kankunaka manami ñukamanta pasa kankichichu. Ñukata wañuchinayashpa katiwashpankuna kankunatapas chasnallatatami wañuchinayashpa katinkakuna. Ñukapa rimashkaynita mana kasushpankuna kankunapa rimashkaykichitapas mana kasunkakunachu. ");
INSERT INTO qupNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ñukata kachawakta mana riksishpankuna ñukata kasuwashkaykichirayku chasna kankunata rurankakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ñuka kay allpama shamushkani runakunata yachachinaynipa imashnami Yaya Diosta riksinkakuna. Yachachishkaynita mana kasunayashpankuna uchayu kanahun. Ñuka mana yachachik shamuynima karka paykunaka manami uchayuchu kanahuma karka. Kunanka yachachishkaynita uyashpankunapas mana chayta kasushpankuna uchankunata manana llakichiypanachu kan. ");
INSERT INTO qupNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ñukata chikniwashpankuna Yayaynitapas chikninahunmi. ");
INSERT INTO qupNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ñuka achka nima maykan atipashkanta chawpinkunapi rurashkani. Chay rurashkaynikunata rikushpankunapas ñukata Yayaynitapas chiknishkakuna. Chayrayku uchayu kanahun. Chay mana atipaypakunata mana ruraynima karka mana uchayuchu kanahuma. ");
INSERT INTO qupNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Chay runakuna ñukanchita chikninahun Yaya Diospa shimin ñawpa killkarishkaka paykunapi paktarinanpa. Kasna nin: Ñukata yankamanta chikniwarkakuna nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ñuka Yayaynima rishpayni kankunarayku kachasha kankunata sinchikuchik Yaya Diospa Espiritunta. Payka Yayaynimantami kan tukuy shutipata mana llulla kashkata riksichik. Kay allpapi kawsak runakunata Yaya Diospa Kachashkan Kishpichik kanaynita riksichinka. ");
INSERT INTO qupNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kankunapas runa masikichikunata chayta riksichiychi, runakunata yachachishkaynimanta pacha ñukawa pakta kawsashkaykichirayku. ");
INSERT INTO qupNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ñami kankunata rimashkani shuk runakuna kankunata chikninankunamanta. Chaymanta rimashkani kankunata sinchikuchik Yaya Diospa Espiritunta kachanaynitapas. Tukuy chaykunata rimashkani ñukapi sinchikunaykichipa, ñukamanta mana anchurinaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Israel masinchikunaka kankunata tantarina wasikunamanta wichunkakuna manana paykunawa tantarinaykichipa. Mana chayllatachu kankunata rurankakuna. Ashwan paykunata wañuchishpanchi Yaya Diosta kushichinchi nishpa yuyarishpankuna shuk puncha kankunamanta shukkunata wañuchinkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Chasna kankunata rurankakuna, mana ñukata nima Yayaynitapas riksishkankunarayku. ");
INSERT INTO qupNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Chasna rimani paykuna kankunata chiknishpankuna ña rimashkaynita yuyarinaykichipa. Kunankama kankunawa kahushpayni runakuna ñukallata chikniwashkakuna. Chayrayku yachachinata kallarishkaynimanta pacha manara rimashkanirachu kankunata chikninankunamanta. ");
INSERT INTO qupNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Kunanka ñami risha ñukata kachawak Yayaynima. Chasna kashpanpas nima pi kankunamanta tapuwankichichu: ¿Maymata rinki? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Rinaynimanta kankunata rimashpayni shunkuykichika llakiywa kichkirishkami kahun. ");
INSERT INTO qupNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Chasna llakiywa kichkirishka kahushpaykichipas kuskata kankunata rimani: Alimi kankunarayku Yayaynima rinaynipa. Mana rishpaynika kankunata sinchikuchik Yaya Diospa Espiritunka mana shamunkachu kankunapi kawsananpa. Ñuka rishpayni shuti payta kankunama kachasha. ");
INSERT INTO qupNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Chasna shamushpan payka runakunata riksichinka imami kan uchaka, chaymanta imashnami Yaya Diosta kasushpa alita kawsanankuna tiyan. Chaymantapas riksichinka uchakunamanta kastigu tiyananta. ");
INSERT INTO qupNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Uchamanta riksichinka, ñukata mana kirina, ñukapi mana sinchikuna, uchapa sapin kananta. ");
INSERT INTO qupNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Chaymanta ali kawsanata riksichinka ñuka tukuy uras Yayayni Diosta kasushpa kawsahushkaynirayku payma rishkaynita yuyachishpa. Chayma rishpayni kankunaka manana ñukata rikuwankichinachu. ");
INSERT INTO qupNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Chaymantapas payka riksichinka uchakunamanta kastigu tiyananta Yaya Diosta mana kasuk runakunata kamachik supaykunapa apun ña kastigarishka kashkanta rikuchishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ñukapa achka rimanayni tiyawahushpanpas kunan mana ashwanta kankunata rimashanchu. Kankunata ashwanta rimashpaynika manami atipankichichu asirtanata. Chayrayku manara tukuyta yachachishkaykichirachu. ");
INSERT INTO qupNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Yaya Diospa Espíritun shamushpan kankunata shuti riksichinka tukuy shutipa kashkata. Chaymantapas kankunata yuyachinka tukuyta ñukamanta yachanaykichipa. Tukuy yachachishkaynita kankunata asirtachinka. Nima imata pay kikinpa yuyayninmanta yuyachinkachu. Ashwan Yaya Diosmanta uyashkanllatami kankunata riksichinka. Chaymantapas riksichinka imashnami pasanka silupi allpapi. ");
INSERT INTO qupNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Kankunata ñukamanta uyashkanta riksichishpan ñuka atun suma yachayyu kanaynita asirtachinka. ");
INSERT INTO qupNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tukuy imatami Yayayni Dioska riman chaytami ñukapas rimani shuk yuyayllawa kashkanchirayku. Chayrayku kankunata rimashkani Espiritunka ñukapa rimashkaynita kankunata asirtachinka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jesuska rimashpalla katirka: Shuk ratumantami manana rikuwankichinachu. Chaymanta unaystumantami kutikashka rikuwankichi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Chasna Jesús rimashpan ñukanchi paypa chunka ishkay runankunamanta shukkunaka tapunakurkanchi: ¿Imatataya ñukanchita rimanayan Yayaynima risha chaymantapas shuk ratumantami manana rikuwankichinachu, chaymanta unaystumantami kutikashka rikuwankichi nishpa? ");
INSERT INTO qupNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Imatataya ñukanchita rimanayan unaystumanta nishpa? Mana asirtanchichu imamantami rimahun. ");
INSERT INTO qupNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Chasna ñukanchi kwintahushkanchita rikushpan Jesuska musyarirka payta tapunayahushkanchita. Chaypi ñukanchita rimarka: Kankunata rimashkani unaystumantami manana rikuwankichinachu, chaymanta shuk ratumantami kutikashka rikuwankichi nishpa. ¿Chasna rimashkaynimantachu tapunayawahunkichi? ");
INSERT INTO qupNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Alita uyawaychi. Ñuka wañushpayni kankunaka sinchita llakishpa wakankichi. Chasna kahushpaykichi mana ñukapi kirikkunaka kushilla kankakuna. Kankunaka llakiywa kahushpaykichipas chaymanta kushikunkichimi. ");
INSERT INTO qupNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Yuyariychi shuk warmi wawayahushkanmanta. Chay warmika wawayahushpan manchayta nanayta parisin. Wawayashkanwasha manchayta nanayta parisishkanta kunkarin. Wawanta rikushpan atunta kushikun. ");
INSERT INTO qupNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Chasnashinami kunanka kankunapas manchaywa llakirinkichi. Chasna kahushpaykichipas kutikashka kankunata rikuk shamushpayni atuntami kushikunkichi. Chasna kushikushpaykichi nima pi atipankachu kankunata kutikashka llakiypi churanata. ");
INSERT INTO qupNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","24","Kunankama ñukallata tapushkankichi yanapanaynipa. Manara nima imata kuskata Yaya Diosta tapushkankichirachu. Kuti kankunama shamushpayni manana nima imata ñukata tapuwankichinachu. Yaya Dios kikintanami tapunkichi. Munashkaynitashina tapushpaykichika paymi kankunata tukuypi yanapanka kushikushpalla kawsanaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Chaymanta rimarka: Tukuy kay yachachishkaynikunata manara shutillatachu yachachishkani. Shuk punchami manana chasnalla yachachishkaykichinachu. Chay uras shutillatanami Yaya Diosmanta kankunata yachachisha alita yachanaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Chay punchamanta pacha munashkaynitashina kankuna kikinna Yaya Diosta tapunkichi. Chasna kankuna kikin tapushpaykichimi mana munankichinachu ñuka kankunarayku payta tapunaynipa. ");
INSERT INTO qupNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Yaya Diosmi kankunata yuyan ñukata yuyawahushkaykichirayku chaymantapas paymanta shamushkaynita kirishkaykichirayku. ");
INSERT INTO qupNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ñuka Yayayni Diosmanta llukshirkani kay allpama shamunaynipa. Kunanka kay allpata sakihuni paymallatata kutinaynipa. ");
INSERT INTO qupNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Chasna Jesuspa rimashkanta uyashpanchi rimarkanchi: Kunan shuti asirtaypata rimahunki, manana rimahunkinachu pakashpa rimahukshina. ");
INSERT INTO qupNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Tapunakuhushkanchita mana uyashpaykipas ñukanchita rimashkanki. Chayrayku kunan tukuy imata yachak kahushkaykita yachanchi. Manara tapuhushpanchira yuyarihushkanchita riksinki. Chayrayku Yaya Diosmanta shamushka kashkaykita kirinchi. ");
INSERT INTO qupNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Chasna rimashkanchita uyashpan Jesuska aynirka: Kankunaka nima kunan ñukapi yapa alitarachu kirihunkichi. ");
INSERT INTO qupNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ñami wañunaynika paktarihun. Chay urasmi kankunaka karan shuk llaktaykichima kutishpa shikwarinkichi. Ñukataka sapallaynitami sakiwankichi. Chasna kashpanpas manami sapallaynichu kahuni, Yayaynika ñukawa kahushkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Manara paktarishpanmi tukuy chayta kankunata rimahuni, paktarishpan mana mancharinaykichipa. Munani kushilla kanaykichipa, runaynikuna kahushkaykichirayku. Yaya Diosta mana kasuk runakuna chawpipi kawsahushpaykichira manchayta nanayta llakiyta parisinkichi. Chasna kashpanpas sinchikuriychi yuyarishpaykichi ñuka parisishpayni winsishkaynita millaypata rurachikta. ");
INSERT INTO qupNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesuska yachachishkanta tukuchishpan siluma rikushpan Yayanta mañarka: Yayayni, ñami wañunayni punchaka paktarishka. Runakunata kishpichinaynipa wañushpayni paykunata rikuchiy ñuka wawayki yapa ali kanaynita. Chasna wañunaynipa kachawashpayki paykunaranti wañushpayni ñukapas runakunata yapa ali kanaykita rikuchisha. ");
INSERT INTO qupNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kan kuwashkanki atun yachayta tukuy runakunata kamachik kanaynipa. Chasna atun yachayyu kashpayni wiñaypa kanwa kawsayta kusha maykankunatami akllashkanki ñukapi sinchikunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Chay kawsayka rimanayan kanta riksishpa riksishpa rishpankuna shuklla shutipa Yaya Dios kashkaykita, ñuka kachashkayki kishpichik wawaykitapas. ");
INSERT INTO qupNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ñuka kay allpapi kawsashpayni tukuy kamachiwashkaykita paktachishkani. Chasna rurashpayni runakunata atun ali yachayyu kanaykita rikuchishkani. ");
INSERT INTO qupNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kunanka Yayayni, churaway kuchuykipi. Kutikashka tukuymanta ashwanta atunyachishpa kushichiway, kuti kanaynipa imashnami karkani manara kay allpaka tiyahushpanra. ");
INSERT INTO qupNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ñukata kuwashkayki runaynikunata yachachishkani pimi kanki nishpa. Chay tukuy kanta mana riksik runakunamanta ñukapi sinchikushpankuna paykunata kuwashkanki. Kanpa kashpankuna kunan ñukata kuwashkanki. Shimikita kirishpankuna alita kasushpa kawsanahun. ");
INSERT INTO qupNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","8","Paykunatami rimawashkaykita yachachishkani. Rimashkaynita uyashpankuna shunkunkunapi wakaychashkakuna. Yachashkakuna shutipa kanmanta shamushkaynita. Chaymantapas kirirkakuna ñukata kachawashkaykita. Chayrayku kunanka yachanahun tukuy yachachishkaynika kanmanta kashkanta. ");
INSERT INTO qupNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Paykunaraykumi kanta mañani. Manami mañanichu kanta mana riksinayak runakunarayku. Mañanimi wawaykikunaraykulla, maykankunatami kuwashkanki. ");
INSERT INTO qupNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tukuy kanpa wawaykikuna ñukata kasuwanahun. Chasnallatatami tukuy ñukata kasuwakkuna wawaykikuna kanahun. Runa masinkuna rikushpankuna runaynikunata yanapahushkaynita alita rurashpa kawsanankunapa, paykunaka riksinkakuna yapa ali kanaykita. ");
INSERT INTO qupNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Kunanmanta pacha ñukaka manana kawsashannachu uchata rurak runakuna chawpipi. Kutikashka kanwa kawsanaynipa rishpayni kuwashkayki runaynikunaka uchata rurak runakuna chawpipi kiparinkakuna. Yayayni, ucha illa atun yachayyu kanki. Chay atun yachaykiwa, maykantami ñukatapas kuwarkanki, chaywa runaynikunata kuyray mana uchata ruranankunapa. Paykunata yanapay shuk yuyayllawa kanankunapa, imashnami kanpas ñukawa shuk yuyayllawa kanki. ");
INSERT INTO qupNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Paykunawa kay allpapi kahushpaynira kuwashkayki yachaykiwa kuyrashkani. Chasna alita kuyrashpayni nima pi paykunamanta chinkarishkachu. Ñawpa killkarishkaka paktarinanpa shukllami chinkarishka, maykanmi kanmanta karupi wiñaypa parisina kan. ");
INSERT INTO qupNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Kunanka risha maypimi kahunki. Kay allpapi kawsahushpaynira chasna runaynikunarayku kanta mañani kushikushpalla kawsanankunapa, imashnami ñukapas atunta kushikushpa kawsani. ");
INSERT INTO qupNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Paykunata shimikita yachachishkani. Mana shimikita kasuk runa masinkuna paykunata chikninahun, wawaykikuna tukushpankuna manana paykunawa shuk ayllushina kashkankunarayku. Kanta mana kasukkunawa mana kanahunchu shuk ayllushina, imashnami ñukapas mana paykunawa shuk ayllushinachu kani. ");
INSERT INTO qupNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Runaynikunarayku mañashpayni manami kanta tapunichu uchata rurak runakunapa chawpinkunamanta anchuchinaykipa. Kanta mañani paykunata kuyranaykipa supayka millaypata mana rurachinanpa. ");
INSERT INTO qupNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Paykunaka mana kanahunchu kanta mana kasuk runakunashina, imashnami ñukapas mana paykunashinachu kani. ");
INSERT INTO qupNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Yayayni, rimashkaykika shutipa kashkata riksichikmi kan. Kanta kasuk runakunata shimikita tukuy uras ashwanta yachachiy manana uchata ruranankunapa, ashwan munashkaykillata rurashpa kawsanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ñukata kachawashkanki kay kanta mana riksik runakunata kawsanayniwa yachachinayniwa kanta alita riksichinaynipa. Kunan ñuka paykunata kachani chasnallatata ruranankunapa. ");
INSERT INTO qupNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ñuka munashkaykita paktachishpa wañusha paykunata uchankunamanta kishpichinaynipa. Chasna wañusha paykuna shutipa kashkata riksichik shimikita uyashpa kawsashpankuna ñukashina munashkaykita rurashpa kawsanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Mana mañanichu paykunaraykulla. Mañanimi shukkunaraykupas, maykankunami paykunapa yachachishkankunata uyashpankuna ñukapi sinchikunkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tukuy paykunarayku tapuni shuk yuyayllawa kanankunapa. Chaymantapas mañani ñukanchiwapas shuk yuyayllawa kanankunapa, imashnami kanpas ñukawa shuk yuyayllawa kanki. Mañanimi chasna kanankunapa, kanta mana riksik runakuna paykunata shukllashina rurashkaynita rikushpankuna kirinankunapa kan shutipa kachawashkaykita. ");
INSERT INTO qupNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Kan ali yuyayta atun yachayta ñukata kuwashkanki. Chasnallatatami ñukapas runaynikunata ali yuyayta atun yachayta kushkani. Chayta paykunata kushkani shuk yuyayllawa shukwa shukwa kanankunapa, imashnami ñukanchipas shuk yuyayllawa kanchi. ");
INSERT INTO qupNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ñuka paykunawa, kan ñukawa shuk yuyayllawa kanchi runaynikuna shuk yuyayyullashina tukunankunapa. Munani chasna tukunankunapa kanta mana riksik runakuna paykunata shukllashina rurashkaynita rikushpankuna kan shutipa kachawashkaykita yachanankunapa, chaymantapas yachanankunapa ñukata yuyawashkaykishina runaynikunatapas yuyanaykita. ");
INSERT INTO qupNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Yayayni yapa yuyawanki. Chayrayku manara kay allpata rurashpaykira ali yuyayta atun yachayta kuwashkanki kanwa pakta tukuypa amun kanaynipa. Yapa munani kuti kanpi kashpayni kuwashkayki runaynikunaka ñukawa kanankunapa. Munani tukuymanta ashwanta atunyachiwashkaykita kushikushpa wiñayparayku rikunankunapa. ");
INSERT INTO qupNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Yayayni, tukuypi alita rurakmi kanki. Mana alita rurak runakuna manami kanta riksinahunchu. Ñuka shuti tukuy uras kanta alita riksini. Runaynikunapas alita yachanahun kan kachawashkaykita. ");
INSERT INTO qupNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Paykunata riksichishkani atun yachayyu yapa paykunata yuyak kanaykita, chaymantapas katishami chasna kanaykita riksichishpa. Chayta rurani paykunapas yuyanakushpa shukwa shukwa kawsanankunapa, chaymantapas runa masinkunata yuyashpa imashnami kan ñukata yuyawanki. Chasna kawsashpankuna ñuka tukuy uras paykunawa kasha. Chasna nishpa Jesuska Yayanta ñukanchi runankunarayku mañarka. ");
INSERT INTO qupNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Mañashkanwasha Jesuska ñukanchi chunka shuk runankunawa pakta chay mikushkanchi wasimanta llukshirka. Jerusalén llaktamanta rirkanchi chay kuchupi kahuk wayku Sedrón shutiyu chimpama. Chaypi tiyarka shuk chakra tarpu kaspikunawa. Chay chakrapi yaykurkanchi. ");
INSERT INTO qupNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Chaypi achka kuti tantaripayanchi. Chasna kashpan Judas, pimi Jesusta apichinan karka, chay chakrata riksirka. ");
INSERT INTO qupNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Chaypi kahushpanchi Judaska achka suntalukunawa Yaya Diospa wasinta kuyrakkunawapas paktamurka. Saserdotekunapa apunkuna fariseokunapas chay kuyrakkunata Judaswa kacharkakuna. Ña tuta kashpan lamparinkunawa, chaymantapas llachapata mapawa armachishkata watashpa kaspipi sintichishkakunawa paktamurkakuna. Apamurkakuna lansankunata sablinkunata. ");
INSERT INTO qupNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesuska yachashpan tukuy imashnami payka pasanka, paykunata tinkuk rirka. Chaypi tinkuk rishpan tapurka: ¿Pitata maskahunkichi? ");
INSERT INTO qupNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Paykunaka aynirkakuna: Nasaretmanta runa Jesustami maskahunchi. Jesuska rimarka: Ñukami kani nishpa. Payta apichihuk Judaspas chay apik runakunawa pakta kahurka. ");
INSERT INTO qupNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesuska ñukami kani nishpa rimashpan chay apik runakunaka washankunama kutirishpa allpama urmarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Chaypi Jesuska kutikashka tapurka: Rimawaychi ¿pitata maskahunkichi? Paykuna kutikashka rimarkakuna: Nasaretmanta runa Jesustami. ");
INSERT INTO qupNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesús kuti aynirka: Ñami rimashkani ñukami kani. Ñukata maskawahushpaykichika kay katiwahuk runakunata sakiychi rinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Chasna Jesuska rimarka Yayanta mañashpan rimashkanshina paktarinanpa: Kuwashkayki runaynikunata alita kuyrashpayni nima pi chinkarishkachu nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Chaypina Pedropa shuk sablin tiyashpan sumakta pitishpa wañuchisha nishpa pitihushpan shuk runa Malko shutiyupa kuskan parti rinkrinta pitirka. Chay rinkrin pitiy tukushka runaka saserdotenchikunapa atun apupa runanmi karka. ");
INSERT INTO qupNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Chaypi Jesuska Pedrota rimarka: Churay chay sablikita maypimi kahurka. Yayayni munan wañuchiwanankunapa. Chasna kashpan mana munanichu nima pi kishpichiwananpa. ");
INSERT INTO qupNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Chasna Jesuska Pedrota rimashpan chay suntalukunapa apunkunaka kamachirkakuna Jesusta apishpa watanankunapa. Jesusta watashpankuna chay suntalukunaka chay Yaya Diospa wasinta kuyrakkunawa pakta pusharkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Chay wata Kaifás saserdotenchikunapa atun apu karka. Rukun Anaska chay uras paykunapa atun apu kashkanmanta llukshishka kashpanpas apulla karka. Chayrayku Jesusta puntiru pusharkakuna Anaspa wasinma saserdotenchikunapa atun apu Kaifaspa rukun kashkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Chay Kaifasmi manara Jesusta apishpankuna tantaylla yuyarishpa kwintak atun apunchikunata kunarka kasna: Ashwan ali kama shuk runalla tukuy runakunaranti wañunanpa, mana tukuy ñukanchi israel runakuna wañunanchipa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jesusta Anasma pushashpankuna ñukapas Pedropas katirkanchi. Jesusta apikkuna payta pushashpa rishpankuna ñukaka washalla yaykurkani chay apupa wasin pampan rumikunawa rurarishka wasikunawa kincharishkapi. Saserdotekunapa atun apupa riksiwashkan kashpayni mana arkawarkakunachu yaykunaynipa. ");
INSERT INTO qupNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedroka punku mayanpi kiparirka. Mana ñukawa pakta yaykushpan punkuma kutirkani. Chay atun apupa riksishkan kashpayni punkuta kuyrak warmiwa kwintak rirkani Pedrota yaykuchinaynipa. Chasna kwintashpayni payta yaykuchirkani. ");
INSERT INTO qupNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Chaypi punkuta kuyrak warmika Pedrota tapurka: ¿Manachu kanki chay apishkanchi runawa purik? Pedroka payta aynirka: Manami chay runawa purikchu kani nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Chiri kashpan chay atun apunchipa runankuna Yaya Diospa wasinta kuyrakkunapas chay kincharishkapi shinkikunawa ninarkakuna. Muyukta shayarishpankuna kunuhurkakuna. Pedropas paykunawa pakta kunuhurka. ");
INSERT INTO qupNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Jesusta Anaspa puntanpi shayachishpankuna chay puntiru saserdotenchikunapa atun apu kashkanmanta llukshishkaka payta tapurka: ¿Imashna kashpaykitaya runakunaka kanta katinahun? ¿Imamantata yachachinki? ");
INSERT INTO qupNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesuska payta aynirka: Ñuka nima ima uras pakalla yachachishkanichu. Tukuy uras runakunapa rikushkankunapi tantarina wasikunapi Yaya Diospa wasinpipas yachachishkani. ");
INSERT INTO qupNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Chasna kashpan ¿imaraykutaya ñuka sapallaynita tapuwahunki? Tapuy yachachishkayni runakunata imatami yachachishkani. Paykunami rimashkaynita yachanahun. ");
INSERT INTO qupNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Chasna Jesuska chay atun aputa mana alita tapushkanta rimashpan shuk chaypi shayahuk Yaya Diospa wasinta kuyrak runa payta waktarka: ¿Chasnachu ayninchi saserdotenchikunapa atun aputaka? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesuska aynirka: Rimashkaynika mana ali kashpanka rimaway imatami mana alitachu rimashkani. Rimashkaynika ali kashpanka ¿imaraykutaya waktawashkanki? ");
INSERT INTO qupNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Chasna Jesuska rimashpan Anaska payta kacharka ishkanti makin watarishkata saserdotenchikunapa atun apu Kaifasmana. ");
INSERT INTO qupNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Anás Jesusta tapuhushpanra Pedroka kahurkara kunushpa nina kuchupi. Chaypi chay atun apupa runankunaka payta tapurkakuna: ¿Manachu kanki chay apishkanchi runawa pakta purik? Pedroka kuti aynirka: Manami chay runawa purikchu kani nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Chay atun apupa runankunamanta shuk runan Malkopa ayllun karka, maykanpatami Pedroka rinkrinta pitirka. Payka kuti Pedrota tapurka: ¿Manachu kanta rikushkani apishkanchi runawa pakta chay tarpu kaspikuna chakrapi? Chaypimi kanta rikurkani. ");
INSERT INTO qupNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Kuti Pedroka aynirka: Manami chay runata riksinichu nishpa. Chasna rimahushkanllapi atallpaka kantarka. ");
INSERT INTO qupNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Pakarihushkanpi apunchikunaka Jesusta aparkakuna Kaifaspa wasinmanta romano apunchipa atun kamachinan wasima. Romano runakuna ñukanchi israel runakunata winsishpankuna chaypi churarkakuna shuk paykunamanta ñukanchikunata kamachik runata. Chaypi paktashpankuna apunchikuna manami romano apunchipa wasinpichu yaykurkakuna. Yaykunahuma karka chay mana israel runapa wasinpi, mana paktachinahumachu karka ñukanchi israel runakunapa kasunanchi killkarishkakunata. Chay wasipi yaykunahuma karka mana atipanahumachu karka ñukanchi israel runa masinkunawa tantarinata Paskua punchakunata pasanankunapa. ");
INSERT INTO qupNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Chasna kashpan chay romano apunchi Pilatoka wasinmanta llukshirka paykunawa kwintananpa. Paykunata tapurka: ¿Imatata kay runaka rurashka? ");
INSERT INTO qupNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Chaypi paykunaka aynirkakuna: Kay runa millaypata mana rurak kamaka, manami kanma pushamunchimachu karka. ");
INSERT INTO qupNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatoka paykunata aynirka: Kankunapa kamachishka killkapi riman imashnami kastiganaykichi tiyan shuk millaypata rurak runata. Chayta kasushpa kankuna kikin kay runata kastigaychi. Apunchikuna aynirkakuna: Kankuna romano runakuna mana munankichichu nima pita kastigashpa wañuchinanchipa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Romano runakuna millaypata rurakkunata kruspi klabashpa wañuchipayanahun. Chayrayku Jesusta romano apunchima pushashpankuna wañuchichinanpa, Jesuspa rimashkanka paktarirka imashnami wañunka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Apunchikunawa kwintashkanwasha Pilatoka kuti wasinpi yaykurka. Chaypi Jesusta kayashpan tapurka: ¿Shutipachu kanki israel masikikunapa Atun Apu? ");
INSERT INTO qupNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesuska aynirka: ¿Kan kikin yuyaynikimantachu chayta tapuwanki? Mana kashpaka ¿shukkunachu ñukamanta chasna rimashkakuna? ");
INSERT INTO qupNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatoka rimarka: Ñukaka manami kanichu israel runa. Kan kikinpa allpaykimanta runa masikikuna saserdotekunapa apunkuna kanta kuwashkakuna. ¿Ima millaypatata rurashkanki? ");
INSERT INTO qupNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesuska aynirka: Ñukaka mana kanichu kay allpapi kamachik apukunashina. Kay allpapi apukunashina kamachinimaka runaynikuna kuntraynikunawa makanakunahuma apukuna mana apiwanankunapa. Mana kay allpapi kamachik apukunashinachu kani paykunashina kamachinaynipa. ");
INSERT INTO qupNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Chaypi Pilatoka tapurka: Atun apu kanki, ¿manachu? Jesuska aynirka: Ari, alita rimawashkanki atun apu kanaynita nishpa. Ñuka kay allpapi wawayarishpayni shamushkani runakunata shutipa kashkata rimanaynipa. Maykankunami yachachishkayni shutipa kashkata kirinahun, paykunaka ñukata kasushpa kawsanahun. ");
INSERT INTO qupNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatoka aynirka: Mana yachanichu imarami chay shutipa kashkaka. Chasna rimahushkanllapi kutikashka kanchama llukshirka apunchikunawa kwintananpa. Chaypi apunchikunata rimarka: Ñukaka mana tarinichu millaypa rurashkanta kay runapata. ");
INSERT INTO qupNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Chaymanta tukuy chaypi tantarishka kahuk runakunata rimarka: Karan wata Paskua punchakunapi shuk kastigachihushkayni runata kacharichinaynipa tapushkaykichita kacharichipayani. Chasna kashpan ¿munankichichu kay wata kay atun apuykichita kacharichinaynipa? ");
INSERT INTO qupNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Chaypi kaparishpa aynirkakuna: ¡Mana paytaka kacharichiychu! ¡Barrabasta kacharichiy! Barrabaska romano runakunata piñarik karka. Chasna kashpan runakunata wañuchishpa kawsapayarka. ");
INSERT INTO qupNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Chay achka runakuna mana munashpankuna Jesusta kacharichinanpa Pilatoka suntalunkunata kamachirka Jesusta asutinankunapa shuk kirukunawa rurarishka karawa. Chasnami shuk mana alichaypa uchayu runata manarapas kruspi klabashpankuna rurapayanahun. ");
INSERT INTO qupNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Chasna asutishpankuna chay suntalukunaka kashamanta llawtuta rurashpankuna atun apupa tawasampatashina umanpi churarkakuna. Chaymantapas shuk atun apupa puka churarinanta asichishpa churachirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Payta shuk atun aputashina kayllayashpankuna asichishpa saludarkakuna: ¿Shamushkankichu israel runakunapa Atun Apu? Chasna nishpankuna uyanpi sakmarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Chaypi kutikashka Pilatoka llukshirka wasinmanta apunchikunawa kwintananpa kasna nishpa: Rikuychi, kay runata llukshichihushkaynita. Puntaykichipi churahuni yachanaykichipa manami kay runapi tarishkanichu nima shuk mana ali rurashkanta nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Chaypi Jesuska kanchama llukshirka chay kashamanta rurarishka tawasampatashina umanpi churachishkankunawa, chay atun apupa suma puka churachishkankunawa. Payta rikuchishpa Pilatoka rimarka: Kaykaya rikuychi kay runata nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Kanchama llukshishkata rikushpankuna saserdotekunapa apunkuna Yaya Diospa wasinta kuyrakkunapas kaparirkakuna: ¡Kruspi klabashpa wañuchichiy! ¡Kruspi klabashpa wañuchichiy! Pilatoka aynirka: Kankuna apaychi kruspi klabanaykichipa. Ñukaka manami tarinichu nima shuk millaypa rurashkanta kay runapata. ");
INSERT INTO qupNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Chaypi apunchikuna payta rimarkakuna: Ñukanchipa tiyan shuk kamachina. Chay kamachinanchipi riman: Maykan runami yanka riman Yaya Diosmi kani nishpa, chay runaka wañunan tiyan. Kay Jesuska Yaya Diospa Wawanmi kani yanka nishpa rimashkanrayku wañunan tiyan. ");
INSERT INTO qupNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilatoka chasna Jesús Yaya Diospa Wawanmi kani nishkanta uyashpan yapa mancharirka. ");
INSERT INTO qupNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Kutikashka wasinpi yaykushpan Jesusta kayachishpan tapurka: ¿Maymantataya kanki? nishpa. Jesuska chunlla uyarka. ");
INSERT INTO qupNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Chasna mana aynishpan Pilatoka payta rimarka: ¿Manachu ñukata ayniwanki? Ñuka munashpaynika kamachinima kanta kruspi klabashpankuna wañuchinankunapa. Chaymantapas munashpaynika kamachinima kanta kacharinankunapa. ¿Manachu chayta yuyarinki? ");
INSERT INTO qupNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Chaypi Jesuska aynirka: Yaya Dios mana munamaka nima imata atipawankimachu ruranata. Chasna kashpan maykanmi kanta kuwarka, payka kanmanta ashwan uchayumi kan. ");
INSERT INTO qupNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Chaymanta pacha Pilatoka ashwanta maskarka payta kishpichinanpa. Mana munashpankuna apunchikunaka kaparirkakunalla: ¡Kan kishpichishpaykika chay runata mana kankichu romano tukuymanta atun apuykita kasuk! Ñukanchi israel runakuna kankunapa winsishkaykichi kanchi. Chasna kashpan maykan runa masinchipas kay Jesusshina atun apunchi kanayan ñukanchikunata kankunamanta kishpichinanpa, chayka romano tukuymanta atun apuykipa kuntranmi kan. ");
INSERT INTO qupNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilatoka chasna rimashkankunata uyashpan kamachirka Jesusta apak rinankunapa. Chaymanta tiyarirka chay tiyarinapi maypimi apirishka runakunata tapupayan. Chay tiyarinaka karka shuk rumikunamanta suma rurarishka chushapi, hebreo shimipi Gabata shutiyu. ");
INSERT INTO qupNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Shuk puncha pishihushpanra Paskua punchakunarayku chawpi puncha parti Jesusta Pilatopa puntanpi churarkakuna. Pilatoka yacharka chay apukunaka mana shutipa yuyarishkankunata Jesús israel runakunata kishpichik atun apunkuna kananta. Shutipa apunkuna kananta yuyarinahuma karka, manami payta kunahumachu karka. Chayta yachashpan apunchikunata pukllachishpa rimarka: Kaykaya rikuychi Atun Apuykichita. ");
INSERT INTO qupNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Chasna rimashpan apunchikunaka kaparirkakuna: ¡Wañuchichiy! ¡Wañuchichiy! ¡Kruspi klabachiy! Pilatoka paykunata aynirka: ¿Imashnataya yuyarinkichi? ¿Ñuka kankunata winsishka romano runakunamanta kashpayni munankichichu kankuna kikinpa Atun Apuykichita wañuchichinaynipa? Chaypi saserdotekunapa apunkunaka aynirkakuna: Ñukanchipa mana tiyanchu ashwan atun apunchika, romano tukuymanta atun apuykimi ñukanchipapas atun apunchika. ");
INSERT INTO qupNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Chaypi Pilatoka ari nishpanna Jesusta paykunata kurka kruspi klabachinankunapa. Pilatoka apunchikunata ari nishpan klabachinankunapa suntalunkunaka Jesusta aparkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Krusninta markachishpankuna apashpa rirka chay Jerusalén llaktamanta kanchama. Payta pusharkakuna Wañushkapa Uman shutiyu lumama. Hebreo shimipi shutinka kan Gólgota. ");
INSERT INTO qupNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Chaypina Jesusta kruspi klabarkakuna, chaymantapas ishkay runakunata karan shukta shuk kruspi chaypi wañunankunapa. Chay runawa pakta kruskunata shayachishpankuna Jesusta chay ishkay runakuna chawpinkunapi churarkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Chasna Jesús kruspi klabarishkata shayachishpankuna Pilatoka shuk killkarishkata churachirka: Kayka Jesús Nasaretmanta israel runakunapa Atun Apunkunami nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jesusta Jerusalén llakta mayanpi kruspi klabashpa wañuchihurkakuna. Chay atun llakta kuchupi kashpan achka israel runa masinchikuna chay kruspi churashkankuna killkarishkata leyirkakuna. Kimsa shimikunapi killkarishka karka, hebreo, latino, griego shimipi. ");
INSERT INTO qupNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Chaypi saserdotenchikunapa apunkunaka chay killkarishkata leyishpankuna Pilatota rimarkakuna: Ama killkachiychu israel runakunapa Atun Apunkuna nishpa. Kasna killkachiy: Kay runaka rimarka: Ñukami kani israel runakunapa atun apunkuna nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatoka paykunata aynirka: Maykantami killkachishkani, chayka chasnalla kiparinan tiyan. ");
INSERT INTO qupNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Suntalukunaka Jesusta kruspi klabashkankunawasha llatanachishkankuna churarinankunata apirkakuna. Likishpankuna chay chusku suntalukuna karan shuk shuk pitikunata paykuna kikinrayku aparkakuna. Ukupi churarinanllata mana likirkakunachu. Chay churarinanka muyukta awarishka karka. Mana sirarishkachu karka. ");
INSERT INTO qupNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Chasna suma rurarishka kashpan suntalukunaka kwintarkakuna paykunapura: Ama likishunchichu. Akuychi swirtinchita kamashunchi pishi apanka nishpa. Chasnapi Yaya Diospa ñawpa killkachishkanka paktarirka kasna nishkaka: Churarinaynita likishpankuna karan shuk runa shuk pitikunata aparka. Ukupi churarinaynitaka apishpankuna swirtinkunata kamarkakuna pishi apanka nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Chay Jesuspa krusnin mayanpi chusku payta katik warmikuna kahurkakuna. Shuk karka Jesuspa maman, shukka mamanpa ñañan. Chaymanta karka Kleofaspa warmin Maria shutiyu, shukka karka Magdala llaktamanta Maria shutiyu. ");
INSERT INTO qupNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesuska mamanta ñukatapas rikushpan kuchunpi kahushkanchita, mamanta ñukata ñawinwa rikuchishpa rimarka: Paymi kiparin wawaykishina. ");
INSERT INTO qupNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Chaymantapas ñukata mamanmanta rimawarka: Paymi kiparin mamaykishina nishpa. Chasna rimawashpan Jesuspa mamanta pusharkani chay urasmanta pacha wasinipi kawsananpa. ");
INSERT INTO qupNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Chaymanta Jesús yachashpan tukuy Yayan Diospa kamachishkanta ña paktachihushkanta rimarka: Upyanayanimi nishpa. Chasna rimarka ñawpa Yaya Diospa shuk killkachishkanka paktarinanpa. ");
INSERT INTO qupNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Chaypi tiyarka shuk uchilla tinaha agru vinuwa. Chay vinuwa shuk suni kaspipi watarishka utkuta upyachirkakuna. Chayta Jesuspa shiminpi tupachirkakuna upyananpa. ");
INSERT INTO qupNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesuska chay agru vinuta tsunkashpa upyashpan sinchita rimarka: Yayayni, ñami tukuy kamachiwashkaykita paktachishkani nishpa. Chasna rimashkanwasha umanta warkuchishpan pay munay wañurka. ");
INSERT INTO qupNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Jesuska kruspi wañushpan Paskua punchakunarayku alicharinankuna puncha karka. Chay Paskua punchakuna kallarinan punchaka tukuy samana punchakunamanta ashwan atun samana puncha kapayan. Chay atun samana puncha kallaripayan ña intika yaykuhushkanpi. Mana munarkakunachu chay puncharayku kruspi wañushka runakunapa aychankunaka chayllapi kiparinankunapa. Chayrayku apunchikunaka Pilatota tapurkakuna kruspi klabarishkakunapa chakinkunata pakichinanpa utkalla wañunankunapa. Chaymantapas tapurkakuna chasna utkalla wañushpankuna aychankunata chay chishillapi krusmanta uraykuchinankunapa. ");
INSERT INTO qupNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Chasna tapushkankunarayku Pilatoka suntalunkunata kacharka chakinkunata pakinankunapa. Puntiru chay ishkay Jesuswa pakta kruspi klabarishkakunapa chakinkunatara pakik rirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jesusta kayllayashpankuna chakinta pakinankunapa rikurkakuna ña wañushka kahushkanta. Chayrayku chakinta mana pakirkakunachu. ");
INSERT INTO qupNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ashwan shuk suntalu kushtillan partipi lansawa tuksirka. Chasnallapi yawarka yakuka llukshirka. ");
INSERT INTO qupNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Tukuy chaykunata ñuka Juan kikin ñawiniwa rikurkani. Shutipa rikushkaynita rimani kankunapas Jesukristupi sinchikurinaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Imashnami Yaya Diospa ñawpa killkachishkanpi riman: Mana nima shuk tulluta payta pakinkakunachu nishpa. Chasnashinami paktarirka. Chayrayku suntalukunaka nima shuk Jesuspa tullunta pakirkakunachu. ");
INSERT INTO qupNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Chaymantapas shuk parti Yaya Diospa ñawpa killkachishkanpi riman: Shuk puncha atunta llakirishpa yuyarinankuna tiyan payta tuksishkankunata nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Chaypi tiyarka shuk apunchi José shutiyu Arimatea llaktamanta. Payka Jesusta kirik runa karka. Chasna kashpanpas mana munarkachu nima pi yachananpa apu masinkunata manchashkanrayku. Chay runaka Pilatoma rirka tapunanpa Jesuspa aychanta allarishka urku uchkupi churashpa tapananpa. Pilatoka arí nishpan Jesuspa aychanta apak rirka churashpa tapak rinanpa. ");
INSERT INTO qupNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Chay fariseo Nikodemopas Joseta yanapak rirka. Paymi karka maykanmi shuk tutapi Jesuswa kwintananpa shamurka. Chay runaka paktashpan kimsa chunka kilo parti mishkinlla asnak yapa chaniyu wikita apamurka. Chay wikika mirra kaspipa áloe kaspipa wikinwa chapurishka karka. ");
INSERT INTO qupNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Chaypi Joseka Nikodemowa Jesuspa aychanta chay wikipi armachishkan ñañu llachapawa wankurkakuna. Chasna ñukanchi israel runakuna wañushkakunawa rurapayanchi chaymanta urku uchkupi churashpa tapananchipa. ");
INSERT INTO qupNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesusta kruspi klabashkankuna parti tiyarka shuk chakra tarpu kaspikunawa. Chay chakrapi tiyarka shuk urku maypimi shuk parti allarishka karka wañushkakunata churashpa tapananchipa. Mushu uchku kashpan chaypi manara wañushkakunata churahurkakunarachu. ");
INSERT INTO qupNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Jesús wañushkan mayanllapi kashkanrayku chaypi utkalla paypa aychanta churashpa taparkakuna, atun samananchi puncha ña kallarinan kashkanrayku. ");
INSERT INTO qupNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Samana puncha kayantima manara alita pakarihushpanra Magdalamanta Maria rikunapa rirka Jesuspa aychanta urku uchkupi churashkankunata. Chaypi paktashpan rikurka churashkankuna punku atun rumiwa taparishkaka anchuchirishka kahushkata. ");
INSERT INTO qupNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Uchku ukuma illata rikushpan kallpa shamurka rimananpa maypimi Pedro ñukapas Jesuspa yapa yuyashkan runan kahurkanchi. Chaypi ñukanchita rimarka: ¡Ñukanchita yachachikpa aychantami churashkankuna uchkumanta apashkakuna! Kunanka manami yachanchichu maypimi churashkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Chasna rimashkanta uyashpanchi Pedro ñukapas kallpa rirkanchi Jesuspa aychanta churashkankuna uchkuma. ");
INSERT INTO qupNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ishkanti parihu kallparkanchi. Ñuka Pedromanta ashwan sinchita kallpashpayni puntiru paktarkani. ");
INSERT INTO qupNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Chay churashkankuna uchkupi paktashpayni kumurishpa punkunmantalla ukuma rikurkani. Payta wankushkankuna llachapallata rikurkani. ");
INSERT INTO qupNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Washaynilla Pedropas paktamurka. Payka ñukata pasamuwashpan Jesuspa aychanta churashkankunakama yaykurka. Chaypi paypas Jesusta wankushkankuna ñañu llachapallata rikurka. ");
INSERT INTO qupNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Chaymantapas rikurka Jesuspa umanta wankushkankuna llachapata. Manami chay shuk wankushkankuna llachapawa pakta karkachu. Shuk parti kahurka suma alicharishka. ");
INSERT INTO qupNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Chasna Pedro churashkankuna uchkupi yaykushpan ñukapas yaykurkani. Jesusta wankushkankuna llachapata aychan illata rikushpayni kawsarishkanta kirirkani. ");
INSERT INTO qupNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Chay uras manara asirtarkanchirachu Yaya Diospa ñawpa killkachishkanta: Payka wañushkanmanta kawsarinan tiyan nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Chayta rikushkanchiwasha chay wasimallatata kutirkanchi. ");
INSERT INTO qupNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pedro ñuka Jesuspa aychanta churashkankuna uchkuma kallpa rishpanchi Mariaka washata katimurka. Ñukanchi kutishpanchi payka uchku mayanpi kaparishpa wakashpa kiparirka. Chasna wakahushpan kumurishpa ukuma rikurka. ");
INSERT INTO qupNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Chaypi rikurka ishkay angelkuna yura churarishkakunata. Maypimi Jesuspa aychanta churarkakuna chaypi tiyarishka kahurkakuna. Shukka uman parti tiyahurka, shukka chakin parti. ");
INSERT INTO qupNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Chaypi chay ishkay angelkunaka payta tapurkakuna: ¿Imaraykuta wakahunki? Payka aynirka: Apashkakunami ñukanchita yachachikpa aychanta. Mana yachanichu maypichari churashkakuna. ");
INSERT INTO qupNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Chasna rimashpan tikrarirka. Chaypi shuk runata rikurka. Mana yacharkachu chay runa Jesús kananta. ");
INSERT INTO qupNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Chaypi Jesuska payta tapurka: Pani, ¿imaraykuta wakahunki? ¿Pitata maskahunki? nishpa. Payka chay tarpu kaspikunata kuyrak runa kananta yuyarishpan payta rimarka: Turi, kan paypa aychanta apashpaykika rimaway maypimi churashkanki, chaymanta apak rinaynipa. ");
INSERT INTO qupNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Chaypi Jesuska shutinpi rimarka Maria nishpa. Shutinta uyashpan alita tikrarishpan rikurka. Jesusta riksishpan hebreo shimipi rimarka: Yachachik, kanchu kanki nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Maria makinta apik rishpan Jesuska payta rimarka: Kachariway. Mana arkawaychu Yayaynima rinaynipa. Manara payma rishkanirachu. Kanka riylla, wawkinikunata rimakriy Yayaynima ña rina kahushkaynita. Ñukapa Yayaynika kankunapapas Yayaykichimi. Ñukapa Yaya Diosnika kankunapapas Yaya Diosnikichimi. ");
INSERT INTO qupNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Chasna Jesuspa rimashkanta uyashpan chay Maria Magdala llaktamanta warmika ñukanchi Jesuspa runankunata rimak shamurka payta rikushkanta. Chaymantapas ñukanchita rimarka Jesuspa tukuy rimashkanta. ");
INSERT INTO qupNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Chay samana puncha kayantima tutayahushpan ñukanchi Jesuspa runankunaka shuk wasipi tantarishka kahurkanchi. Apunchikunata manchashpanchi punkuta sumakta taparkanchi. Chay suma taparishkanchi wasipi yaykushpan Jesuska chawpinchipi shayarishpan rimarka: Yaya Dios kankunata kushillayachichun mana manchashpa kawsanaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Chasna rimashkanwasha ñukanchita makinta kushtillantapas rikuchirka, litrankunata rikushpanchi pay kananta riksinanchipa. Ñukanchita yachachik kananta riksishpanchi atunta kushikurkanchi. ");
INSERT INTO qupNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Chaypi Jesuska kutikashka rimarka: Yaya Dios kankunata kushillayachichun mana manchashpa kawsanaykichipa. Yayayni Dioska ñukata kachawashka payta mana riksik runakunata kawsanayniwa yachachinayniwa payta riksichinaynipa. Kunan ñuka kankunata kachani chasnallatata ruranaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Chasna rimashkanwasha ñukanchi parti pukurka kasna nishpa: Kay kachahushkayni Yaya Diospa Espiritunta shunkuykichipi yaykuchiychi. ");
INSERT INTO qupNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Chasna Yaya Diospa yachayninwa kashpaykichi paypa yuyarishkanta riksinkichi. Chasna kashpan maykan runakunatami rimankichi uchaykichikunamanta llakichirishka kankichi nishpa, paykunataka Yaya Dioska uchankunamanta llakichinkami. Maykan runakunatami rimankichi uchaykichikunamanta mana llakichirishkachu kankichi nishpa, paykunataka Yaya Dioska manami uchankunamanta llakichinkachu. ");
INSERT INTO qupNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jesús ñukanchita chasna rikurishpan Tomaska mana chaypichu karka. Paypas ñukanchi chunka ishkay Jesuspa runankunamanta karka maykantami rimapayanchi ishkay wawayarishka. ");
INSERT INTO qupNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tomaska ñukanchipi paktamushpan payta rimarkanchi: Ñukanchita yachachiktami rikushkanchi nishpa. Payka ñukanchita mana kirishpan aynirka: Mana rikushpaynika klabu makinpi yaykushka uchkuta kushtillanpi tuksishkankuna uchkuta, chaymantapas mana llankashpaynika manami kawsarishkanta kirishanchu. ");
INSERT INTO qupNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Shuk semanamanta kuti chay wasipi tantarirkanchi. Chaypi Tomaspas ñukanchiwa pakta kahurka. Punku sumakta taparishka kashpanpas Jesuska kutikashka yaykurka. Chawpinchipi shayarishpan rimarka: Yaya Dios kankunata kushillayachichun mana manchashpa kawsanaykichipa nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Chaymanta Tomasta rimarka: Makinita alita rikuk shamuy. Makikita satiy kay klabu yaykushkapi. Chaymantapas tuksiwashkankuna kushtillaynipi makikita satiy. Ama kaychu mana kirik runakunashina. Wañushkaynimanta kawsarishkaynita kiriy. ");
INSERT INTO qupNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Chaypi Tomaska payta riksishpan rimarka: Amuyni kanki, Yaya Diosnimi kanki nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Chasna uyashpan Jesuska kutikashka payta rimarka: Rikuwashpaykirami kawsarimushkaynita kirishkanki. Kushilla kankakuna maykan runakunami mana rikuwashpankunapas kawsarimushkaynita kirinahun. ");
INSERT INTO qupNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Kay killkapi mana killkashkanichu Jesuspa tukuy rurashkanta. Killkashkaynimanta ashwan achka nima ima uras rikushkanchita rurashka ñukanchi paypa runankunata Yaya Diospa yachayninwa kahushkanta rikuchinanpa. ");
INSERT INTO qupNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Tukuy maykantami killkashkani, killkashkanimi Jesús Yaya Diospa Kachashkan Kishpichik kananta kirinaykichipa, chaymantapas Yaya Diospa Wawan kananta. Kankunarayku killkashkani kirishpaykichi Yaya Dios munashkanshina shutipa kawsayta tarinaykichipa. ");
INSERT INTO qupNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Chaymanta kanchis ñukanchi Jesuspa runankunaka Galilea allpama kutirkanchi. Chaypi shuk parti Tiberias kucha mayanpi kahushpanchi Jesuska kutikashka ñukanchita rikurirka. ");
INSERT INTO qupNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Chaypi kahurkanchi Simón Pedro shutiyu, shukka Tomás maykantami rimapayanchi ishkay wawayarishka, shukka Natanael Galileapi kahuk Kaná llaktamanta runa, chaymanta ñuka wawkiniwa Sebedeopa wawankuna, chaymantapas ishkay ashwan Jesuspa runankuna karkanchi. ");
INSERT INTO qupNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Pedroka ñukanchita rimarka: Rediyak rishara nishpa. Chasna rimashkanta uyashpanchi aynirkanchi: Ñukanchipas rinayanchimi kanwa. Chasna paywa rishpanchi botipi uraykurkanchi. Pakarikta rediyashpanchipas nima shuk challwata apirkanchichu. ");
INSERT INTO qupNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ña pakarihushkapi botillapi kahushpanchira shuk runata yaku mayanpi shayahukta rikurkanchi. Ñukanchika mana yacharkanchichu Jesús kananta. ");
INSERT INTO qupNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Payka ñukanchita tapurka: Wawkikuna, ¿mana apishkankichi challwata? Ñukanchika aynirkanchi: Mana, nima shukta apishkanchichu. ");
INSERT INTO qupNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Chasna rimashpanchi payka aynirka: Redikichita kachariychi botikichipa kuskan parti. Chaypimi apinkichi. Payta kasushpanchi redinchita kacharirkanchi. Chaypi achka challwakunata wishishpanchi mana atiparkanchichu redinchita uraykuchinata. ");
INSERT INTO qupNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Chaypi Jesusta riksishpayni Pedrota rimarkani: Payka ñukanchita yachachikmi nishpa. Chasna rimashkaynita uyashpan Pedroka tarawananpa llatanashkan churarinanta churarishpan yakupi saltarka waytashpa Jesusta tinkuk rinanpa. ");
INSERT INTO qupNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Botinchi shuk pachak metro tiyu mayanmanta chawpipi kashpan ñukanchi botinchipi kiparikkunaka redinchita achka challwakunawa aysachishpa tiyu mayanpi paktarkanchi. ");
INSERT INTO qupNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Botinchimanta tiyuma llukshishpanchi shuk shinkikunawa nina sintihushkata rikurkanchi. Chay nina awapi challwaka chayahurka. Chaymanta tiyarka pan. ");
INSERT INTO qupNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Chaypi ña Pedropas tiyu mayanpi paktarka. Jesús parti rina kashpanchi payka ñukanchita rimarka: Kunalla apishkaykichi challwakunamanta shukkunata apamuychi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Chayta uyashpan Pedroka botinchipi uraykushpan redita challwakunanti tiyu mayanma aysamurka. Chay redipi kahurkakuna shuk pachak pichka chunka kimsa atun challwakuna. Yapa achka challwakuna kashpankunapas redinchika mana likirirkachu. ");
INSERT INTO qupNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesuska chaypi ñukanchita rimarka: Mikuk shamuychi nishpa. Ña ñukanchita yachachik kashkanta yachashpanchi nima pi munarkanchichu tapunata ¿pita kanki? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesuska panta apishpan ñukanchita kayllayashpan kurka mikunanchipa, chaymanta challwatapas. ");
INSERT INTO qupNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Kayka kimsaynin kuti karka Jesús wañushkanmanta kawsarimushkanwasha ñukanchita rikurishkanka. ");
INSERT INTO qupNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Mikushkanchiwasha Jesuska Pedrota ñawpa shutinpi rimashpan tapurka: Juanpa wawan Simón ¿kanka yuyawankichu ashwan kay shuk runaynikunamanta? Pedroka aynirka: Ari Amuyni, kan yachanki kanta yuyahushkaynita. Chaypi Jesuska nirka: Imashnami obehakuna shuk kuyrakta munanahun mana pantanankunapa nima chinkarinankunapa chasnashinami runaynikunapas shuk kuyrakta munanahun. Kanka kuyray ñukapi sinchikuk runakunata. ");
INSERT INTO qupNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Chaymanta kutikashka tapurka: Juanpa wawan Simón ¿kanka yuyawankichu ashwan kay shuk runaynikunamanta? Pedroka kutikashka chasnallatata aynirka: Ari Amuyni, kan yachanki kanta yuyahushkaynita. Chaypi Jesuska kutikashka rimarka: Kuyray ñukapi sinchikuk runakunata. ");
INSERT INTO qupNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Chaymanta kimsaynin kuti Pedrota tapurka: Juanpa wawan Simón, ¿kanka yuyawankichu ashwan kay shuk runaynikunamanta? Kimsaynin kuti payta yuyawankichu nishpa tapushkanta uyashpan Pedroka yapa llakirishpan aynirka: Amuyni, tukuyta yachak kashpayki kanta yuyahushkaynita yachanki. Chaypi Jesuska kutikashka payta aynirka: Kuyray ñukapi sinchikuk runakunata. ");
INSERT INTO qupNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Alita uyaway. Musu kashkayki uras churarishkaykita wataripayarkanki purihushkaykipi kanta mana arkananpa. Chasna munashkaykita puripayarkanki. Ashwanta rukuyashpayki makikita alsanki kanta llakichinankunapa. Shukkunana kanta watashpankuna mana llakichishpa apirishkata pushankakuna maymami mana rinayankichu. ");
INSERT INTO qupNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Chaytaka rimarka asirtachinanpa imashnami Pedroka parisishpa wañunan karka. Chasna Yaya Diosta kasushkanrayku wañushpan runakunata rikuchinan karka Yaya Diosta yapa yuyashkanta. Chaymanta Jesuska payta rimarka: Ñukata kirishpalla katiway nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedroka tikrarishpan ñukata rikuwarka washa shamuhushkaynita. Ñuka Jesuspa yapa yuyashkan runan karkani. Manara Jesús wañushpanra paywa pakta mikuhushkanchi uras paypa kuchunpi kahushpayni tapurkani: Amuyni, ¿pita kanta apichinka? nishpa. ");
INSERT INTO qupNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ñukata rikuwashpan Pedroka Jesusta ñukamanta tapurka: Amuyni, ¿imashnata payka tukunka? ");
INSERT INTO qupNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Chaypi Jesuska payta aynirka: Munashpaynika pay kawsananta kutimunayni punchakama ¿imaraykuta yachanayki tiyan? Kanka ñukapi kirishpa katiwaylla. ");
INSERT INTO qupNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Chasna rimashpan Jesuspa chunka ishkay runankunamanta shuk runan masinikuna paykunapura rimarkakuna: Manashi Juanka wañunkachu nishpa. Jesuska mana chayta rimashpanpas chasna yuyarirkakuna. Payka rimahurkami: Munashpaynika pay kawsananta kutimunayni punchakama ¿imaraykuta yachanayki tiyan kanka? nishpa. Chayllata killkachishkani ñuka Juan Jesuspa runan. ");
INSERT INTO qupNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Chayllata killkachiwashka chay rikushkanta. Ñukanchi kirik masinkunaka yachanchimi paypa rimashkanka shutipa kananta. ");
INSERT INTO qupNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Tiyan achka Jesuspa rurashkankuna maykantami mana killkashkanchichu. Tukuyta shukllankama shukllankama killkanchima karka yuyarini killkashkanchi killkakunaka mana paktanahumachu karka kay allpapi.");
INSERT INTO qupNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ñuka Lukas kan Teofilorayku killkani: Munashkayni Teófilo: Ñuka puntiru killkashkaynipi kanta killkarkani Jesuspa tukuy rurashkanta, yachachishkantapas, kallarishkanmanta pacha siluma sikanankama. Kunan kutikashka killkahuni. ");
INSERT INTO qupNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Jesuska manara siluma sikahushpan payta katikkunata akllarka paypa shiminta yachachinankunapa tukuy runakunata. Yaya Diospa Espíritun Jesusta yachachishpan chay akllashkan runankunata kamachirka imatami ruranankuna tiyan. Chaymantana Yaya Dioska Wawanta siluma sikachirka. ");
INSERT INTO qupNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Wañushkanwasha kawsarishpan manara siluma sikahushpanra Jesuska chusku chunka punchata runankunata rikurirka. Chasna rikurishpan achka chikan chikan rurashkanwa paykunata riksichirka wañushkanmanta shutipa kawsarishka kananta. Chaymantapas katirkalla rimashpa imashnami Yaya Diospa ali kamachinanka kay allpapi nishpa. ");
INSERT INTO qupNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Chasna paypa runankunawa tantaylla kahushpanra Jesuska paykunata rimarka: Kutishpaykichi Jerusalenma ama llukshinkichirachu. Chayllapi chapaychi Yaya Diospa Espíritun paktanankama, Yaya Dios ñawpa rimashkanshina, maykantami ñukapas kankunata rimarkani. ");
INSERT INTO qupNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Bawtisak Juanka yakuwa runakunata bawtisarka. Ashwan shuk punchakunamantami Yaya Dioska kankunata paypa Espiritunta kushpa shunkuykichita aliyachinka. ");
INSERT INTO qupNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Shuk puncha runankunaka kutikashka Jesuswa pakta kahushpankuna tapurkakuna: Yaya Jesús, ¿kunanchu kanka Israel allpanchipi atun apunchi tukunki? Imashnami ñawpa atun apunchikuna ñukanchikunata tukuy kuntranchikunata winsishpa alita kamachipayarkakuna, chasnallatata ¿kunanchu ñukanchikunata kishpichishpa kamachinki? ");
INSERT INTO qupNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Chasna tapushpankuna Jesuska aynirka: Kankunaka chaytaka mana yachanaykichi tiyanchu. Yaya Diosmi yachayninwa ñukata atun aputa rurawanka, ima punchachari pay munan. ");
INSERT INTO qupNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Chasna kashpanpas Yaya Diospa Espíritun shamushpan kankunata ashwan yachayta kunka sinchi kanaykichipa, ñukamanta rimakkuna. Chasna kashpaykichimi Jerusalén llaktapi tukuy Judea allpapipas ñukamanta rimankichi. Chaymanta Samaria allpama tukuy parti kay allpapi ñukamanta rimak rinkichi. ");
INSERT INTO qupNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Chasna rimashkanwasha paykuna rikuhushkankunallapi Jesuska kallarirka awayanata siluma. Rikuhushkankunapi puyuka arkarka payta, manana atiparkakunanachu rikunata. ");
INSERT INTO qupNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Chasna sikahushkanta rikuhushpankuna kunkaymanta ishkay runakuna yura churarishkakunaka kuchunkunapi rikurirkakuna. ");
INSERT INTO qupNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Chaypina rimarkakuna: Galileamanta runakuna, ¿imaraykuta awama rikurayahunkichi? Ñami Jesuska siluma sikashka. Chay Jesusllatata, maykantami Yaya Dioska siluma sikachishka, imashna rihushkanta rikushkankichi, chasnallatatami kuti shamunka kay allpama. ");
INSERT INTO qupNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Chaypina Jesuspa akllashkan apostolkunaka Olivos urkumanta kutimurkakuna Jerusalén llaktama. Chay urkuka Jerusalén kuchupi karka, samana puncha purina tupullapi. ");
INSERT INTO qupNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jerusalenpi paktashpankuna shuk wasipi yaykurkakuna, awaniru kawitupi sikashpankuna tantarirkakuna. Chaypi kahurkakuna Pedro, Juan, Santiago, Andrés, Felipe, Tomás, Bartolomé, Mateo, Alfeopa wawan Santiago, Simón, maykantami rimapayanahun Selote, chaymanta Santiagopa wawan Judas. ");
INSERT INTO qupNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tukuy paykuna shuk yuyayllawa tantaripayanahun Yaya Dioswa kwintanankunapa. Chasnallatata paykunawa tantarishka karkakuna Jesuspa wawkinkuna, maman Mariapas, ashwan shuk warmikunapas. ");
INSERT INTO qupNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Chay punchakunapi shuk pachak ishkay chunka Jesusta kirik runakuna tantarishka kahurkakuna Yaya Dioswa kwintanankunapa. Shuk puncha Pedroka shayarirka rimananpa: ");
INSERT INTO qupNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Wawkinikuna paninikuna, ñawpa killkarishkaka paktarinan karka. Yaya Diospa Espíritun ñawpa atun apunchi Davidta Judasmanta killkachirka, maykanmi Jesusta apichirka. ");
INSERT INTO qupNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judaska ñukanchiwa pakta Jesuspa akllashkan karka Yaya Diospa shiminta rimashpa purinanchipa. ");
INSERT INTO qupNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Jesusta apichishkanrayku apishkan kullkita kutichishpan chaywa shuk allpata rantirkakuna. Chaymanta Judaska wañuchirinayashpan awamanta uray sinka partikta chunchulin shikwakta urmashpan wañurka. ");
INSERT INTO qupNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jerusalenmanta runakuna chayta yachashpankuna Judaspa kutichishkan kullkiwa rantishkankuna allpata Yawar Allpa nishpa shutiyachirkakuna. Paykunapa shiminkunapi Aséldama ninahun. ");
INSERT INTO qupNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Salmos killkapi Judasmanta kasna killkarishka kan: Chay mana ali rurakpa wasinka chusha kiparinka. Nima pi chaypi kawsankachu. Chaymantapas riman: Shuk runana chay wañushka runapa tarawananta ruranan tiyan nishpa. ");
INSERT INTO qupNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Chasna kashpan kay kirikkunamanta shuk runa yaykunan tiyan Judasranti ñukanchishina Jesuspa kachashkan runan tukunanpa. Payka kanan tiyan shuk runa, maykanmi Juan Jesusta bawtisashkanmanta pacha ñukanchiwa pakta tukuy Jesuspa rurashkankunata rikushka, tukuy yachachishkankunata uyashka, chaymantapas maykanmi Jesuspa wañushkanta, kawsarishkanta, siluma sikashkantapas rikushka. Chay runaka Jesuspa kawsarishkanta ñukanchishina rikushkanrayku ñukanchiwa pakta runakunata rimak tukunan tiyan. ");
INSERT INTO qupNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pedro chasna rimashpan chay tantarishka runakunaka ishkay runakunata akllarkakuna paykunamanta shuklla akllarishka kananpa. Shuk karka José, paypa shuk shutinka Barsabás, shuk shutinpas Justo karka. Chaymanta shukka karka Matias. ");
INSERT INTO qupNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Chasna shutinkunata killkashkankunawasha Yaya Diosta mañarkakuna kasna nishpa: Yaya Dios, kanmi tukuy shunkunchita riksinki. Ñukanchita rikuchiy kay ishkay runakunamanta maykantata akllashkanki Judasranti shimikita yachachik runa tukunanpa. Judaska uchata rurashkanrayku manana ñukanchiwa pakta kanmanta yachachinnachu. Wañushpan rirka maypimi parisinka wiñaypata. ");
INSERT INTO qupNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Mañashkankunawasha ishkay rumistukunawa swirtinkunata kamarkakuna yachanankunapa maykantami Yaya Dioska akllashka. Chasna rurashpankuna Matiaska akllarishka karka. Chay punchamanta pacha Matiaska chay chunka shuk Jesuspa shiminta yachachik apostolkunawa pakta apostolllatata tukurka. ");
INSERT INTO qupNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pichka chunka puncha Jesuspa kawsarishkanmanta israel runakunapa Pentekostés shutiyu puncha karka. Chay punchapi tukuy Jesusta kirikkuna tantarishka kahurkakuna shuk wasillapi. ");
INSERT INTO qupNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kunkaymanta sinchita silumanta uyarimuhukta uyarkakuna sinchi wayratashina. Chay tantarishka kahushkankuna wasipi tapakta uyarkakuna. "