﻿USE sofia;
DROP TABLE IF EXISTS sofia.qulNT_vpl;
CREATE TABLE qulNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES qulNT_vpl WRITE;
INSERT INTO qulNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucristo Abrahampaj Davidpajpiwan mirayninmanta carkan. Cayka Jesucristopaj abueloncuna: ");
INSERT INTO qulNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham Isaacpaj tatan carkan, Isaactaj Jacobpaj tatan, Jacobtaj Judapaj waukencunapajpiwan tatan. ");
INSERT INTO qulNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judataj Farespaj tatan carkan, Zarapajpiwan. Tamartaj mamancu carkan. Fares Esrompaj tatan carkan, Esromtaj Arampaj tatan, ");
INSERT INTO qulNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramtaj Aminadabpaj tatan, Aminadabtaj Naasonpaj tatan, Naasontaj Salmonpaj tatan. ");
INSERT INTO qulNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón Boozpaj tatan carkan, mamantaj Rahab. Booz Obedpaj tatan carkan, Ruttaj Obedpaj maman, Obedtaj Isaipaj tatan, ");
INSERT INTO qulNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaitaj gobernaj rey Davidpaj tatan, rey Davidtaj Salomonpaj tatan, Salomonpaj mamantaj Uriaspaj warmin carkan. ");
INSERT INTO qulNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón Roboampaj tatan carkan, Roboamtaj Abiaspaj tatan, Abiastaj Asapaj tatan, ");
INSERT INTO qulNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asataj Josafatpaj tatan, Josafattaj Jorampaj tatan, Joramtaj Uziaspaj tatan, ");
INSERT INTO qulNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziastaj Jotampaj tatan, Jotamtaj Acazpaj tatan, Acaztaj Ezequiaspaj tatan, ");
INSERT INTO qulNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequiastaj Manasespaj tatan, Manasestaj Amonpaj tatan, Amontaj Josiaspaj tatan, ");
INSERT INTO qulNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiastaj Jeconiaspaj waukencunapajpiwan tatan carkan, Babiloniaman Israel runacunata preso apaskancu tiempopi. ");
INSERT INTO qulNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Chaymantataj Jeconías Salatielpaj tatan carkan, Salatieltaj Zorobabelpaj tatan, ");
INSERT INTO qulNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabeltaj Abiudpaj tatan, Abiudtaj Eliaquimpaj tatan, Eliaquimtaj Azorpaj tatan, ");
INSERT INTO qulNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azortaj Sadocpaj tatan, Sadoctaj Aquimpaj tatan, Aquimtaj Eliudpaj tatan. ");
INSERT INTO qulNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud Eleazarpaj tatan carkan, Eleazartaj Matanpaj tatan, Matantaj Jacobpaj tatan, ");
INSERT INTO qulNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobtaj Josepaj tatan, Josetaj Mariapaj kosan. Mariataj Jesuspaj maman carkan, churin Jesucristotaj Mesías. ");
INSERT INTO qulNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Chay jinamanta Abrahammanta Davidcama chunca tawayoj abuelocuna carkancu. Davidmanta Israel runacuna Babiloniaman preso apaska caskancucama chunca tawayoj abuelocuna carkancu. Israel runacunata preso apaskancumanta Cristopaj naciskancama waj chunca tawayoj abuelocuna carkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucristopaj naciskan cay jina carkan: Maman María Josewan parlaska carkancu casaracunancupaj. Manaraj cusca tiyachcajtincu, Mariaka onkojña carkan Santo Espiritupaj atiyninwan. ");
INSERT INTO qulNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kosan José sumaj justo runa caspa, mana munarkanchu Mariata sut'inta wijch'uyta. Chayraycu pacallamanta sakerpayayta pensarkan, María onkojña caskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ajinataña pensajtintaj, Señorpaj angelnin Joseman moskoyninpi riqhurerkan, nerkantaj: “José, Davidpaj miraynin, ama manchachicuychu Mariawan casaracuyta, imaraycuchus chay wawaka Santo Espiritumanta. ");
INSERT INTO qulNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","María churinta onkocojtin, sutichanqui Jesusta, imaraycuchus pay llajtanta juchancunamanta salvanka.” ");
INSERT INTO qulNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tucuy caycuna pasarkan, Señor Diospaj profetanpaj niskan junt'acunanpaj: ");
INSERT INTO qulNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Manaraj kharita rejsej sipas onkojyanka, churiyoj canka, sutichankacutaj Emanuelta.” (Niyta munan: “Dios nokanchiswan.”) ");
INSERT INTO qulNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Puñuskanmanta rijch'arispataj, José angelpaj niskanman jina ruwarkan, Mariawantaj casaracaporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Chaywanpas mana esposocuna jina juntochu puñorkancu María churinta onkocunancama. Josetaj suticharkan Jesusta. ");
INSERT INTO qulNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Judea provinciapi caj Belenpi Jesús nacerkan, gobernaj Herodes chaypi gobernachcajtin. Koyllurcunamanta yachajcuna inti llojsimuy ladomanta Jerusalenman chayamorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Tapucorkancutaj: —¿Maypitaj judiocunapaj reynin nacin? Inti llojsimuynejpi paypaj koyllurninta ricuycu, chayraycu payta adoraj jamuycu. ");
INSERT INTO qulNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Gobernaj Herodestaj tucuy Jerusalenpi cajcunapiwan chayta uyarispa, ni imanayta aterkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Sacerdotecunapaj tucuy jefencunata leymanta yachachejcunatawan wajachispa, taporkan: —¿Maypitaj Cristo nacinan carkan? ");
INSERT INTO qulNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Paycunataj contestarkancu: —Judea provinciapi caj Belenpi. Ajinata Diospaj profetan escriberkan: ");
INSERT INTO qulNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Kan, Judeapi caj Belén, manami sinchi mana casurana jinachu canqui Judeapaj athun llajtancuna chaupinpi, imaraycuchus uj curaj gobernaj kanmanta llojsenka. Pay Israel llajtayta sumajta michenka.’ ");
INSERT INTO qulNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herodestaj pacallamanta koyllurcunamanta yachajcunata wajaspa, allinta taporkan ima rato chay koyllur paycunaman riqhuriskanta. ");
INSERT INTO qulNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Belenman paycunata cachaspataj, nerkan: —Puriychis, chay wawamanta allinta yachamuychis. Tarispataj willawanquichis nokapas adoramunaypaj. ");
INSERT INTO qulNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Chay jina willaskawan yachajcuna puripojtincutaj, chay ricuskancu koyllur ñaupakencuta purerkan, wawa maypichus cachcarkan chaycama; chaypitaj sayaycorkan. ");
INSERT INTO qulNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Yachajcuna koyllurta sayaycuskanta ricuspa, sinchita cusicorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Wasiman yaycuspa, wawata maman Mariatawan tariparkancu. Konkoriycuspataj, wawata adorarkancu. Cajoncitoncuta quicharaspa, korita, inciensota, mirratawan korkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Dios moskoynincupi willarkan ama Herodesman cutinancupaj. Chayraycu wajninta llajtancuman cutiporkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Yachajcuna ripojtincuña, Señorpaj angelnin Joseman moskoyninpi riqhurispa, nerkan: “Jatariy, wawata mamantawan pusaricuspa, Egipto nacionman escapay ujtawan kanman willanaycama, imaraycuchus Herodes wawata masc'achenka wañuchinanpaj.” ");
INSERT INTO qulNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josetaj jatarispa, wawata mamantawan chay tutapacha Egiptoman pusaporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Chaypi camorkan Herodes wañunancama. Chayka pasarkan Señor Diospaj profetanpaj niskan junt'acunanpaj: “Egiptomanta Churiyta wajarkani.” ");
INSERT INTO qulNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Gobernaj Herodestaj yachajcunapaj engañaskanta reparacuspa, phiñacorkan. Cacharkantaj Belenpi campocunantinpi caj tucuy khari wawacunata wañuchimunancupaj iscay watayojmanta uranejman, Jesuspaj naciskan chay tiempomanta yachajcunapaj willaskanman jina. ");
INSERT INTO qulNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ajinata junt'acun profeta Jeremiaspaj escribiskan: ");
INSERT INTO qulNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramá llajtapi sinchi wakay athun llaquiycunapiwan carkan. Raquel wakarkan churincuna wañuchiskaña caskanmanta, manataj sonkochaska cayta munarkanchu.” ");
INSERT INTO qulNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodes wañupojtintaj, Egiptopi Señorpaj angelnin Joseman moskoypi nerkan: ");
INSERT INTO qulNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Jatariy, wawata mamantawan pusaricuspa, Israelman cutipuy. Wawata wañuchiy munajcuna wañurapuncuña.” ");
INSERT INTO qulNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Chhicataj José jatarispa, wawata mamantawan Israelman pusaporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Josetaj uyarerkan Arquelao Judeapi gobernachcaskanta tatan Herodespaj cuentanmanta. Chayraycu chayman puriyta manchachicorkan. Dios Joseman moskoyninpi willajtintaj, Galileaman puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nazaretman chayaspataj, chaypi tiyacorkan, profetacunapaj niskancu junt'acunanpaj: “Jesuska nazareno sutichaska canka.” ");
INSERT INTO qulNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Chay p'unchaycunapi Judeapi caj ch'usaj lugarpi Juan Bautista riqhurerkan. ");
INSERT INTO qulNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Willaskanpi nerkan: “¡Diosman cutiricuychis! ¡Diospaj gobiernonka kayllapiña cachcan!” ");
INSERT INTO qulNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Juanmanta Diospaj profetan Isaías escriberkan: “Ch'usaj lugarpi uj runa wajach'aconka: ‘Señor jamuchcan. Sonkoyquichista paypaj waquichiychis recto ñanta jina.’ ” ");
INSERT INTO qulNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juanpaj p'achantaj camello millmamanta carkan, karamanta cinturonwan chumpiycuska. Miqhunantaj carkan langosta niska athun t'inti, t'aja misq'ipiwan. ");
INSERT INTO qulNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Runacuna Jerusalenmanta, tucuy Judea provinciamanta, Jordán kayllacunamantawan jamorkancu uyarej. ");
INSERT INTO qulNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Juantaj juchancu willacojcunata bautizarkan Jordán mayupi. ");
INSERT INTO qulNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Achqha fariseocunata saduceocunatawan bautizachicoj jamojta ricuspa, nerkan: “¡Pallicunapaj miraynin! ¿Pitaj kancunaman nerkasunquichis Diospaj jamoj castigonmanta escapacunayquichista? ");
INSERT INTO qulNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Allinta causaychis, Diosman cutiriskayquichis sut'inta ricuchicunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Amataj ninacuychischu: ‘Nokanchiska Abrahampaj wawancuna canchis’ nispaka. Segurayquichis, Dioska cay rumicunatapas Abrahampaj wawancunaman tucuchinman. ");
INSERT INTO qulNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Jacha listoña, sach'acunata saphinmantapacha p'atanapaj. Tucuy sach'ata mana allin urejtaka p'ataspa ninaman wijch'uncu. Chay jinata Dios castigasunquichis. ");
INSERT INTO qulNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ciertota noka unullawan bautizayquichis, Diosman cutiriskayquichis ricuchicunanpaj. Nokamanta waj jamuchcan, paycajka Santo Espirituwan ninapiwan bautizasunquichis. Payka nokamanta astawan atiyniyoj; paypaj ñaupakenpi ni imapaschu cani, ni abarcanta pascaranallaypajpas. ");
INSERT INTO qulNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Pay maquinpi wayrachinata apamuchcan, trigota limpiochaspa trojenpi wakaychananpaj, yurantataj mana jayc'aj wañoj ninawan ruphachipunanpaj.” ");
INSERT INTO qulNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jesús Galileamanta Jordán mayuman purerkan, Juanwan bautizachicoj. ");
INSERT INTO qulNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Juantaj ni imaraycu Jesusta bautizayta munarkanchu: —Astawanpas noka kanpaj bautizaskayqui canay. Kantaj jamunqui nokaman bautizachicoj —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesustaj contestarkan: —Cunanka ruwallay, Diospaj tucuy mandacuskancunata junt'ananchispaj. Juantaj casucorkan. ");
INSERT INTO qulNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesús bautizachicuspa unumanta llojsichcajtin, janaj pacha quicharacorkan. Ricorkantaj Diospaj Espíritun pay pataman paloma jina uraycamuchcajta. ");
INSERT INTO qulNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Janaj pachamantataj Dios nimorkan: “Caymi munaska Chureyka. Payta ajllani.” ");
INSERT INTO qulNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Chaymanta Santo Espíritu Jesusta ch'usaj lugarman pusarkan, chaypi supay pruebata ruwananpaj. ");
INSERT INTO qulNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jesustaj tawa chunca p'unchayta tawa chunca tutatawan mana miqhuska caspa, yarekachicorkan. ");
INSERT INTO qulNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Chaypacha supay Jesusman chimpaycorkan pruebata ruwananpaj. Nerkantaj: —Sichus ciertopuni Diospaj Churin canqui chayka, cay rumicunata t'antaman tucuchiy. ");
INSERT INTO qulNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesustaj contestarkan: —Escrituraka nin: ‘Mana miqhunallawanchu runaka causanka, manachayri Diospaj siminmanta llojsej tucuy palabrancunawan.’ ");
INSERT INTO qulNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Chaymanta supay santocaj Jerusalén llajtaman pusarkan; templo pataman astawan altocaj lugarman llojsichispa, ");
INSERT INTO qulNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","nerkan: —Sichus ciertopuni Diospaj Churin canqui chayka, caymanta wijch'uycucuy; imaraycuchus Escrituraka nin: ‘Dios angelnincunata cachamonka cuidanasunquichispaj. Maquincuwan jap'isunquichis rumicunaman mana tacacunayquipaj.’ ");
INSERT INTO qulNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesús contestarkan: —Escrituraka nillawanchistaj: ‘Ama Señor Diosniyquita pruebata ruwanquichu.’ ");
INSERT INTO qulNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Chaymanta supay uj athun loma pataman pusarkan. Chaymanta cay pachapi caj tucuy nacioncunata athun sumaj caynincunatawan ricuchispa, ");
INSERT INTO qulNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","nerkan: —Noka tucuy cayta koskayqui, konkoriycuspa adorawanqui chayka. ");
INSERT INTO qulNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Chaypacha Jesús nerkan: —Puriy caymanta, Satanás. Escrituraka niwanchis: ‘Señor Diosnillayquita adoranqui; pay sapallanta sirvinqui.’ ");
INSERT INTO qulNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Chhicataj supay Jesusmanta ithiricaporkan. Angelcunataj jamuspa sirverkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jesús Juan Bautista carcelpi caskanta uyarispa, Galileaman purerkan. ");
INSERT INTO qulNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nazaret llajtamanta llojsipuspa, Capernaum llajtaman puriporkan, Galilea kocha cantoman, Zabulón Neftalí lugarnejman, ");
INSERT INTO qulNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Señor Diospaj profetan Isaiaspaj escribiskan junt'acunanpaj: ");
INSERT INTO qulNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zabulón, Neftalí lugarcunapi, Jordán mayu chimpapi, kocha cantopi tiyajcuna, Galileapi caj waj dios adorajcunapiwan, ");
INSERT INTO qulNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","chay runacuna, tutayajpi jina tiyajcuna, uj athun c'anchayta riconkacu. Chay c'anchay wañuy llanthucunapi tiyajcunaman c'anchayconka.” ");
INSERT INTO qulNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Chhicamantapacha Jesús willayta kallarerkan: “Diosman cutiricuychis, imaraycuchus Diospaj gobiernon kayllapiña” nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesús Galilea kocha cantonta purichcaspa, iscay waukentinta ricorkan. Ujnin Simón Pedro sutiyoj carkan, ujnintaj Andrés. Paycuna challwiru carkancu; challwacunata jap'inancupaj llicata kochaman cachaycuchcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesús paycunata nerkan: —Jamuychis, nokawan puriychis. Nokataj runacunata Diosman pusamojta ruwaskayquichis, imaynatachus challwata jap'ej cachcanquichis jinata. ");
INSERT INTO qulNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Chhicapacha llicancuta sakerpayaspa, Jesuswan puriporkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Juch'uytawan ñaupajman purispa, Jesús waj iscay waukentinta ricorkan: Santiagota Juantawan, Zebedeopaj churincunata. Botepi tatancuwan llicata jallch'aspa cachcajtincu, Jesús wajarkan. ");
INSERT INTO qulNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Chhicapacha boteta tatancutawan sakerpayaspa, Jesuswan puriporkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús tucuy Galileanejpi purerkan, sinagoga wasicunapi yachachispa, Diospaj gobiernonmanta sumaj evangeliota willaspa. Alliyacherkantaj runacunata tucuy ima onkoycunamanta nanaycunamantawan. ");
INSERT INTO qulNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Chayraycu enteron Siria provinciapi parlarkancu Jesús atiyniyoj caskanta. Pusamorkancutaj tucuy ima onkoywan ñac'arejcunata, sajra espirituyojcunata, t'ucuyojcunata, such'ucunatawan; Jesustaj alliyacherkan. ");
INSERT INTO qulNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Achqha runacuna Galileamanta, Decapolismanta, Jerusalenmanta, Judeamanta, Jordán mayu chimpamanta Jesusta katerkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesús achqha runata ricuspa lomaman llojserkan. Tiyaycojtin, discipuloncuna payman chimpaycorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jesustaj yachachiyta kallarerkan nispa: ");
INSERT INTO qulNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Cusicuyniyojmi ‘Diosta necesitani, juchayoj cani’ nejcunaka. Paycunapaj Diospaj gobiernon canka. ");
INSERT INTO qulNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Cusicuyniyojmi juchancunamanta llaquiska cajcunaka. Dios paycunata cusichenka. ");
INSERT INTO qulNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Cusicuyniyojmi humilde sonkoyojcunaka. Dios paycunaman prometicuskan jallp'ata konka. ");
INSERT INTO qulNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Cusicuyniyojmi Diospaj niskanta ruwayta munajcunaka, yarekaska unumanta ch'aquiska jina. Dios yanapanka munaskancuta ruwanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Cusicuyniyojmi ujcunata qhuyapayajcunaka. Dios paycunata qhuyapayanka. ");
INSERT INTO qulNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Cusicuyniyojmi limpio sonkoyojcunaka. Paycuna Diosta riconkacu. ");
INSERT INTO qulNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Cusicuyniyojmi sonko tiyaycuchejcunaka. Paycuna Diospaj wawan cankacu. ");
INSERT INTO qulNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Cusicuyniyojmi Diospaj niskanman jina ruwaskancumanta ñac'arichiskacunaka. Paycunapaj Diospaj gobiernon canka. ");
INSERT INTO qulNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Cusicuyniyojmi canquichis, kancuna insultaska, chejniska, kancuna contra tucuy imata llullacuspa parlajtincu. ");
INSERT INTO qulNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Cusicuychis, contento caychis; janaj pachapi athun premiota jap'ekanquichis. Ajinallatataj Diosmanta willaj ñaupaj profetacunata chejnispa ñac'aricherkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Kancuna runacunapaj cachi jina canquichis. Ch'apajyawajchis chayri, ¿imaynatataj cachinchawajchis? Manaña sirviwajchischu; calleman wijch'uska cawajchis runacuna sarunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Kancuna runacunapaj c'anchaynin canquichis. Loma patapi ruwaska llajtaka mana pacaska cayta atinchu. ");
INSERT INTO qulNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nillataj lamparata jap'ichispaka, cajonwan c'umpiycuncuchu; manachayri alto patapi churancu, wasipi tucuy cajcunata c'anchananpaj. ");
INSERT INTO qulNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ajinallatataj kancunapas runacunapaj ñaupakenpi lámpara jina c'anchaychis. Paycunapas allin ruwaskayquichista ricuspa, janaj pachapi caj Tatayquichista alabanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ama yuyaychischu Moisespaj leyninta profetacunapaj yachachiskantapas chincachej jamuskaytaka; manachayri tucuyninta junt'aj jamuni. ");
INSERT INTO qulNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Segurayquichis, janaj pacha cay pachapas tucucunancama, mana ni uj letrapas ni uj puntollapas leymanta chincankachu tucuynin junt'acunancama. ");
INSERT INTO qulNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Pillapas mana casucunmanchu juch'uycaj leyllatapas, ajinallatataj yachachinman chayka, Diospaj gobiernonpi sinchi juch'uy canka. Pillapas casucojka ajinallatataj yachachejka, Diospaj gobiernonpi athunyachiska canka. ");
INSERT INTO qulNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Niyquichis, leymanta yachachejcunamanta fariseocunamantawan nejtin Diosta mana astawan sumajta casucunquichischu chayka, Diospaj gobiernonman mana yaycunquichischu. ");
INSERT INTO qulNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Kancuna uyarerkanquichis abueloyquichiscunaman niskata: ‘Ama wañuchinquichu. Pillapas wañuchejka juchachaska canka.’ ");
INSERT INTO qulNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nokataj niyquichis, pillapas wauken contra phiñacojka, juchachaska canka. Pichus waukenta insultajpas, Athun Asambleapi juchachaska canka. Pichus sinchita phiñaricuspa, waukenta ‘sonso’ ninman chayka, nina lauray infiernopi castigaska canka. ");
INSERT INTO qulNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Altarman ofrendayquita apaspa waukeyquita ofendiskayquita yuyariwaj chayka, ");
INSERT INTO qulNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","altarpaj ñaupakenpi ofrendayquita sakespa, cutiriy, waukeyquiwanraj allinyacuy. Chaymanta cutimuspataj, ofrendayquita Diosman koy. ");
INSERT INTO qulNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Pipas juchayquimanta demandaspa juezman apachichcasunquiman chayka, ñanpi purichcaspallaraj paywan allinyacuy, ama autoridadman entreganasunquipaj. Mana jina cajtenka, autoridadka guardianwan carcelman wisk'achisunqui. ");
INSERT INTO qulNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Segurayqui, carcelmanta mana llojsinquichu, lliujta paganayquicama. ");
INSERT INTO qulNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Kancuna uyarerkanquichis cay ñaupaj niskata: ‘Ama adulterio juchata ruwanquichu.’ ");
INSERT INTO qulNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nokataj niyquichis, pillapas uj warmita munapayan chayka, ñapas sonkonpi adulterio juchata ruwanña. ");
INSERT INTO qulNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Ajina ari, paña lado ñawiyqui juchaman urmachejtenka, orkhospa wijch'uy. Allinmi ujnin partella cuerpoyquimanta chincananka, tucuy cuerpoyqui infiernoman wijch'uska canantapachaka. ");
INSERT INTO qulNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ajinallatataj, paña maquiyqui juchaman urmachejtenka, p'atakaska wijch'uy. Allinmi ujnin partella cuerpoyquimanta chincananka, tucuy cuerpoyqui infiernoman wijch'uska canantapachaka. ");
INSERT INTO qulNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ñaupajta nillarkancutaj: ‘Pillapas warminmanta divorciacojka, divorcio papelta kochun.’ ");
INSERT INTO qulNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nokataj niyquichis, adulterio juchapi mana cachcajtin, pillapas warminmanta divorciacojka warminta adulterio juchaman urmachinman. Divorciaska warmiwan casaracojka adulterio juchata ruwallantaj. ");
INSERT INTO qulNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Uyarillarkanquichistaj cay ñaupaj niskata: ‘Juramentowan Diosman prometicuskayquichista junt'anayquichis.’ ");
INSERT INTO qulNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nokataj niyquichis, amapuni juranquichischu janaj pacharaycu, chayka Diospaj tronon; ");
INSERT INTO qulNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ni cay pacharaycupas, chayka Diospajta; nitaj Jerusalenraycupas, chayka athun Reypaj llajtan; ");
INSERT INTO qulNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","nillataj umayquichisraycupas, imaraycuchus mana atiwajchischu uj chujchallayquichistapas yurajman ni yanaman tucuchiyta. ");
INSERT INTO qulNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Verdad cajtenka, ‘arí’ ninayquichis. Mana verdad cajtintaj, ‘mana’ ninayquichis. Chayman yapajtiyquichiska, mana allinchu. ");
INSERT INTO qulNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Cay ñaupaj niskata uyarerkanquichis: ‘Ñawimanta ñawita, quirumanta quiruta.’ ");
INSERT INTO qulNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nokataj niyquichis, sajra runawanka ama vengacuychischu. Paña lado uyayquipi t'ajllejtenka, uj lado uyayquita kollaytaj. ");
INSERT INTO qulNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Pipas quejasunquiman p'achayquita kechunasunquipaj chayka, sacoyquitawan kopuy. ");
INSERT INTO qulNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Pillapas uj kilometrota k'epinta apachisunquiman chayka, iscay kilometrota apapuy. ");
INSERT INTO qulNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Pillapas mañacojmanka koy; “ayniriway” nejmantaj, ama “mana” niychu. ");
INSERT INTO qulNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Cay ñaupaj niskata uyarillarkanquichistaj: ‘Amigoyquita munacuy, chejnicojniyquitataj chejniy.’ ");
INSERT INTO qulNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nokataj niyquichis, enemigoyquichiscunata munacuychis. Maldicicojcunata bendiciychis; chejnicojcunatapas allin cajta ruwaychis. Ñac'arichicojcunapaj Diosmanta mañapuychis oracionpi. ");
INSERT INTO qulNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ajinata ruwaspaka, janaj pachapi cachcaj Tatayquichispaj wawan caskayquichista ricuchichcanquichis. Payka sajra runapaj allin runapajpas intita c'anchachimun. Ajinallatataj parachimun tucuypaj, allin runapaj sajra runapajpas. ");
INSERT INTO qulNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kancuna munacojcunallata munacuwajchis chayri, ¿imatataj Diosmanta jap'ekawajchisri? ¿Manachu juchasapacunapas quiquillantataj ruwancu? ");
INSERT INTO qulNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Waukeyquichiscunallata saludawajchis chayri, ¿ima allintataj ruwawajchisri? ¿Manachu waj dios adorajcunapas quiquillantataj ruwancu? ");
INSERT INTO qulNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Sumaj cabal mana juchachana jina caychis, janaj pachapi caj Tatayquichis cabal mana juchachana jina ajinata. ");
INSERT INTO qulNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Religionniyquichis ama runapaj ricunallanta ruwanquichischu. Jinata ruwanquichis chayka, janaj pachapi caj Tatayquichis mana ni imata kosunquichischu. ");
INSERT INTO qulNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Necesitajcunaman yanapanquichis chayka, ama tucuy runacunaman willaracunquichischu iscay uya runacuna jinaka. Paycunaka sinagoga wasicunapi callecunapipas jinata ruwancu, paycunamanta allinta parlanancupaj. Segurayquichis, Diosmanta mana imatapas jap'ekankacuchu. ");
INSERT INTO qulNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Necesitajcunaman yanapaspaka, ama ni piman willanquichu ni sinchi amigoyquimanpas. ");
INSERT INTO qulNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ch'inllamanta ruway. Chhicataj tucuy ruwaskayquita ricoj Tatayqui premioyquita kosunqui. ");
INSERT INTO qulNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Oracionta ruwaspaka ama iscay uya runacuna jinallaka ruwanquichischu. Paycunaka sinagoga wasicunapi plaza esquinacunapi sayaycuspa, oracionta ruwancu runa ricunallanpaj. Segurayquichis, Diosmanta mana imatapas jap'ekankacuchu. ");
INSERT INTO qulNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kancajtaj, Diosman oracionta ruwanayquipajka, wasiyquiman yaycuy; puncuyquita wisk'aycuspa, sapayqui kanwan cachcaj Tatayquiman oracionta ruway. Pacapi ruwaskayqui oracionta uyarej Tatayquitaj sut'inta kosunqui. ");
INSERT INTO qulNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Diosman oracionta ruwaspaka, ama achqha palabrata cutirispa cutirispa parlanquichu verdadero Diosta mana rejsej runa jinaka. Paycunaka pensancu achqha parlaskancuwan Dioswan uyarichicuyta. ");
INSERT INTO qulNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kancunaka ama paycuna jina ruwanquichischu, imaraycuchus Dios Tatayquichiska necesitaskayquichiscunata yachanña, manaraj mañachcajtiyquichis. ");
INSERT INTO qulNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kancunaka cay jinata oracionta ruwaychis: ‘Janaj pachapi cachcaj Tataycu, sutiyqui yupaychaska cachun. ");
INSERT INTO qulNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Gobiernoyqui jamuchun; munayniyqui ruwaska cachun, imaynatachus janaj pachapi, ajinallatataj cay pachapipas. ");
INSERT INTO qulNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Sapa p'unchaypaj t'antaycuta cunan kowaycu. ");
INSERT INTO qulNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Juchaycuta perdonawaycu, imaynatachus nokaycu contra juchallicojtapas perdonaycu jinata. ");
INSERT INTO qulNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ama tentacionman urmachiwaycuchu, astawanpas tucuy mana allincunamanta librawaycu. Kanpajta gobiernoyqui, tucuy atiyniyqui, tucuy gloriayquipas wiñaypaj wiñayninpaj. Ajina cachun.’ ");
INSERT INTO qulNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Kancuna contra juchallicojcunata perdonanquichis chayka, janaj pachapi caj Tatayquichis kancunatapas perdonallasunquichistaj. ");
INSERT INTO qulNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mana perdonanquichis chayka, Dios Tatayquichis manallataj juchayquichiscunata perdonasunquichischu. ");
INSERT INTO qulNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ayunaspaka ama llaquiska uya caychischu, iscay uya runacuna jinaka. Paycunaka llaquiska uyancuta ricuchicuncu, runacuna ayunaskancuta yachanancupaj. Segurayquichis, runapaj alabaskallanta jap'ekankacu. ");
INSERT INTO qulNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kancajtaj, ayunaspaka uyayquita uphacuy, allinta jallch'acuy, ");
INSERT INTO qulNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","runacuna ayunaskayquita ama reparanancupaj. Kanwan cachcaj Dios Tatallayqui ayunaskayquita yachanka, paytaj premioyquita kosunqui. ");
INSERT INTO qulNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ama cay pachapi khapajyaychischu. Caypeka thuta miqhun, tucuy ima khorwarin, suwapas suwan. ");
INSERT INTO qulNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Astawanka janaj pachapi tantaychis khapaj canayquichispaj. Chaypeka mana thuta miqhunchu, ni ima khorwarinchu, nitaj pipas suwanchu. ");
INSERT INTO qulNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Maypichus khapaj cayniyquichis cachcan, chayllapitaj sonkoyquichispas cachcan. ");
INSERT INTO qulNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ñawiyquichis c'anchay jina cuerpoyquichispaj. Ñawiyquichis allin cajtin, tucuy cuerpoyquichis c'anchayniyoj canka. ");
INSERT INTO qulNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mana allin cajtenka, tucuy cuerpoyquichis tutayajpi canka. Chay kanpi caj c'anchay tutayapojtenka, ¡imayna yana tutayajrajchá canka mana creej sonkoyquipeka! ");
INSERT INTO qulNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Iscay patronta mana pipas sirviyta atinmanchu, imaraycuchus ujninta chejnenka, ujnintataj munaconka. Ujcajman junt'anka, ujcajmantataj ni ima importankachu. Mana aticunchu Diosta kolketawan sirvinaka. ");
INSERT INTO qulNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Cayta niyquichis, causanayquichismanta, miqhunayquichismanta, ujyanayquichismanta, p'achallicunayquichismantapiwan ama llaquicuychischu. Causayka astawan valin miqhunamanta nejtenka, cuerpopas p'achamanta nejtenka. ");
INSERT INTO qulNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Khawariychis, jalaycachaj pisketocuna mana tarpuncuchu nitaj ajthapincuchu, ni trojepi tantancuchu. Chaywanpas janaj pachapi caj Dios Tatayquichis miqhunata kon. Kancunaka astawan valinquichis pisketocunamanta nejtenka. ");
INSERT INTO qulNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kancuna sinchita afanacuspari, ¿atiwajchischu cusca metrollatapas yapacuyta alto canayquichispaj? ");
INSERT INTO qulNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“¿Imaraycutaj p'achamanta llaquicunquichis? Khawariychis campopi t'icacunapaj wiñaskanta. Mana llanc'ancuchu, nitaj phuchcancuchu. ");
INSERT INTO qulNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Chaywanpas niyquichis, Salomonpas tucuy khapaj cayninwan manapuni ujnin t'ica jinallapas p'achallicorkanchu. ");
INSERT INTO qulNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kora cunan wiñachcan, pakarintaj ruphachiska canka. Sichus Dios koratapas sumajta p'achallin chayka, ¡astawanraj kancunacajtaka p'achallisunquichis, pisi creeyniyoj runacuna! ");
INSERT INTO qulNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Chayraycu ama llaquicuychischu, ‘¿imatataj miqhusaj, ujyasaj, p'achallicusaj?’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Diospi mana creejcuna tucuy caycunamantaka afanacuncu. Kancunapajka can uj Tatayquichis, payka ima necesitaskayquichista yachanña. ");
INSERT INTO qulNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ñaupajtaka Diospaj gobiernonpi afanacuychis, paypaj munaskanta ruwaspa. Chhicataj tucuy ima necesitaskayquichista Diosmanta jap'ekanquichis yapaskata. ");
INSERT INTO qulNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ama llaquicuychischu pakarin p'unchaymantaka. Pakarenka waj llaquicuycunata apamonka. Sapa p'unchay imaymana llaquicuycunata apamun. ");
INSERT INTO qulNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ama ujcunata juchachaychischu, Dios kancunata mana juchachanasunquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Imaynatachá ujcunata juchachanquichis, jinallatataj Dios kancunata juchachasunquichis. Kancuna ima medidawanchus ujcunata midinquichis, chay medidallawantaj Dios midisunquichis. ");
INSERT INTO qulNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Imaraycutaj waukeyquipaj ñawinpi ichhuta khawanqui, nitaj reparacunquichu ñawiyquipi raqhu c'aspi cachcaskanta? ");
INSERT INTO qulNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Imaynatataj atrevicunqui waukeyquiman niyta: ‘Waukéy, dejaway ñawiyquimanta ichhu orkhojta’ nispa? ");
INSERT INTO qulNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Iscay uya! Ñaupajta ñawiyquimantaraj chay raqhu c'aspita orkhoy, chhica ichhuta allinta ricunqui, waukeyquipaj ñawinmanta orkhonayquipajka. ");
INSERT INTO qulNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Diospaj cajnincunata ama alkocuna jina runacunaman konquichischu. Kancuna contra cutirincuman ch'ajwapayanasunquichispaj. Nitaj perla jina Diospaj cajnincunata qhuchicuna jina runacunaman konquichischu, paycunaka saruwasincuman. ");
INSERT INTO qulNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Mañacuychis, Diostaj kosunquichis. Masc'aychis, tarinquichistaj. Puncuta tacaychis, quicharasunquichistaj. ");
INSERT INTO qulNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mañacojka jap'ekan; masc'ajtaj tarin; puncuta tacajtapas quicharan. ");
INSERT INTO qulNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“¿Mayken tatataj canman wawan t'antata mañacojtin rumita kojri? ");
INSERT INTO qulNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Challwata mañacojtinpas pallita kojri? ");
INSERT INTO qulNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kancuna sajra runa cayniyquichiswanpas allin cajta wawayquichisman koyta yachanquichis chayka, astawanraj janaj pachapi caj Tatayquichiska sumajcunata konka mañacojcunamanka. ");
INSERT INTO qulNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Imaynatachus ujcuna kancunapaj ruwanancuta munanquichis, ajinallatataj kancunapas paycunapaj ruwaychis. Chayta Dios mandan Moisespaj leyninpi profetancunapaj escribiskancupipas. ");
INSERT INTO qulNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“C'ullcu puncunta yaycuychis. Ancho puncu ancho ñanpiwan chincayman pusancu, achqhayojtaj chayninta purincu. ");
INSERT INTO qulNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Causayman pusaj puncoka, causayman purej ñanpas c'ullcumi, manataj facilchu purinapaj. Pisillataj cancu chayninta purejka. ");
INSERT INTO qulNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Cuidacuychis ‘Diosmanta parlani’ nej llulla profetacunamanta. Sumaj oveja jina jamuncu, uqhuncupitaj paycunaka sajra animal jina cancu. ");
INSERT INTO qulNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ruwaskancupi paycunata rejsinquichis. Uvataka mana qhichca sach'amantachu pallancu, ni higotapas khepu sach'amantachu. ");
INSERT INTO qulNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ajina ari, allin sach'aka sumaj urita kon; mana allin sach'ataj mana allin urita kon. ");
INSERT INTO qulNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Sumaj sach'aka mana atinchu mana allinta uriyta, mana allin sach'ataj mana atinchu sumajta uriyta. ");
INSERT INTO qulNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Sapa mana allin urej sach'ataka p'ataspa ninaman wijch'uncu. ");
INSERT INTO qulNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kancunaka ruwaskancupi runacunata rejsinquichis. ");
INSERT INTO qulNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Mana tucuy ‘¡Señor, Señor!’ niwajcunachu janaj pacha gobiernomanka yayconkacu, manachayri janaj pachapi cachcaj Tataypaj munayninta ruwajcunalla yayconkacu. ");
INSERT INTO qulNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Juicio p'unchaypi achqhayoj niwankacu: ‘Señor, Señor, nokaycu sutiyquipi parlarkaycu, sutiyquipi sajra espiritucunata katerkorkaycu, sutiyquipitaj achqha milagrocunatapas ruwarkaycu.’ ");
INSERT INTO qulNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Chhicataj contestasaj: ‘Ni jayc'aj kancunata rejsiyquichischu. ¡Nokamanta puriychis, mana allin ruwajcuna!’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Pillapas uyariwaspa niskayta ruwajka, allin yachayniyoj. Payka kaka patapi wasinta ruwaj runa jina. ");
INSERT INTO qulNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Paramojtin, mayu junt'amojtin, sinchita chay wasi contra wayramojtin, waseka mana urmanchu kaka patapi ruwaska caskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pillapas uyariwaspa mana niskayta ruwajka, mana allin yachayniyoj runa jina. Payka ako patapi wasinta ruwaj runa jina. ");
INSERT INTO qulNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Paramojtin, mayu junt'amojtin, sinchita wayramojtin, chay waseka urmapun; ch'usajta ñut'ucapun.” ");
INSERT INTO qulNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesús parlayta tucojtin, tucuy runacuna chay jinata yachachiskanmanta musphararkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Imaraycuchus autoridadninwan yachacherkan, manataj leymanta yachachejcuna jinallachu. ");
INSERT INTO qulNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesús lomamanta urakamojtin, achqha runa paywan cusca purerkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Uj lepra onkoyniyoj runa Jesusman chimpaycorkan. Konkoriycuspa, mañacorkan nispa: —Señor, munaspaka alliyachiway. ");
INSERT INTO qulNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesús llanqhaycuspa, nerkan: —Munani, alliyaska cay. Runataj chhicapacha alliyaporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesús nerkan: —Uyariway, ama ni piman willanquichu. Puriy, sacerdoteman ricuchicamuy. Ofrendata koy Moisespaj mandacuskanman jina, tucuy runa alliyaskaña caskayquita yachanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesús Capernaum llajtaman yaycojtin, uj capitán romano chimpaycuspa rogarkan. ");
INSERT INTO qulNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Nerkantaj: —Señor, wasiypi uywacuskay onkoska, such'uyapun, sinchi nanaycunata sufrichcan. ");
INSERT INTO qulNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús contestarkan: —Purisaj, alliyachimusaj. ");
INSERT INTO qulNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Capitantaj contestarkan: —Señor, mana nokaka wasiyman yaycunayquipaj jinachu cani. Nillay, uywacuskayka niskayquiwan alliyaponka. ");
INSERT INTO qulNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Noka quiquiy curajcunapaj mandonpi cani. Jinallatataj soldadoycuna mandoypi can. Ujninta ‘puriy’ nini, purin. Ujnintataj ‘jamuy’ nini, jamun. Uywacuskayta imallatapas ‘ruway’ nejtiy, ruwan. ");
INSERT INTO qulNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesús chayta uyarispa muspharkan. Katejnin runacunata khawarispataj, nerkan: —Segurayquichis, cay jina athun creeyniyoj runata mana Israelpipas tarinichu. ");
INSERT INTO qulNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Niyquichis, inti llojsimuynejmanta, inti yaycuynejmantawan achqhayoj jamuspa, janaj pacha Diospaj gobiernonpi tiyayconkacu Abrahamwan, Isaacwan, Jacobpiwan miqhunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Diospaj gobiernonpi canancu carkan chaycunataj tutayajman wijch'uska cankacu; chaypi wakankacu, nanaymanta quiruncuta c'ariris nispa c'uturacuspa. ");
INSERT INTO qulNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Chaymanta Jesús capitanman nerkan: —Wasiyquiman puripuy, creeskayquiman jina ruwaska cachun. Uywacuskantaj chhicapacha alliyaporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesús Pedropaj wasinman purerkan. Chaypitaj Pedropaj suegranta calenturawan onkoskata tariparkan puñunapi. ");
INSERT INTO qulNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesús maquinmanta llanqhaycojtin, calenturan thaniporkan. Paytaj jatarispa, paycunata atendiyta kallarerkan. ");
INSERT INTO qulNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ch'isiyaycuytaña achqha sajra espirituyojcunata Jesusman apamorkancu. Jesustaj ujta parlarkospalla sajra espiritucunata katerkorkan. Alliyachillarkantaj tucuy onkoskacunata. ");
INSERT INTO qulNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Cayka pasarkan profeta Isaiaspaj niskan junt'acunanpaj: “Pay quiquin qhuyay cayninchiscunata kechorkan, onkoyninchiscunatataj aparkan.” ");
INSERT INTO qulNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesús achqha runata muyurejpi ricuspa, discipuloncunaman nerkan: “Kocha chimpaman puriychis.” ");
INSERT INTO qulNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Leymanta yachachej uj runa Jesusman chimpaycuspa, nerkan: —Yachachej, kanwan puriyta munani maytachá purinqui chayta. ");
INSERT INTO qulNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesustaj contestarkan: —Zorrocunapaj jutc'uncu can tiyanancupaj, pisketocunapajpas tapancu can; nokapajri ni maypi wasi canchu samaricunaypaj. ");
INSERT INTO qulNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ujnin discípulon nerkan: —Señor, permitiwayraj ñaupajta tataytaraj p'ampaycamunayta. ");
INSERT INTO qulNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesustaj nerkan: —Nokawan puriy. Wañuskacuna wañuskancunata p'ampachuncu. ");
INSERT INTO qulNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesús discipuloncunawan boteman yaycuspa puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kochapi purichcajtincu, sinchi athun wayra jatarerkan. Ajinamanta boteman unu junt'aycuspa uqhuman chincaycuchipuchcarkan. Jesustaj puñupuska. ");
INSERT INTO qulNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Discipuloncuna rijch'achimorkancu, nispa: —¡Señor, salvawaycu! ¡Unuman chincaycapuchcanchisña! ");
INSERT INTO qulNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesús nerkan: —¿Imaraycutaj sinchita manchachicunquichis? Pisi creeyniyoj canquichis. Sayariytawantaj wayrata kochatawan c'amispa, thaniycucherkan. ");
INSERT INTO qulNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Paycunataj musphaspa ninacuchcarkancu: —¿Imayna runataj cayri, wayrapas kochapas c'amejtin, casunancupajri? ");
INSERT INTO qulNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Gadara jallp'aman, Galilea kocha chimpaman chayarkancu. Iscay sajra espirituyoj runacuna sepulturanejmanta llojsimuspa, Jesusman chimpaycorkancu. Sinchi sajra caskancuraycu, chaynin ñanta ni pipas pasayta aterkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Wajach'acuspa, nerkancu: —¡Jesús, Diospaj Churin! ¿Ima ruwanayquitaj nokaycuwan? ¿Nokaycu ñac'arichejchu jamunqui, manaraj ñac'arinaycu tiempopi? ");
INSERT INTO qulNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Carupachapi achqha qhuchicuna miqhuchcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Sajra espiritucunataj Jesusta rogarkancu: —Katerkonawayquichis cajtenka, qhuchicunaman yaycojta dejawaycu. ");
INSERT INTO qulNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesustaj nerkan: —Puriychis —nispa. Sajra espiritucunaka runacunamanta llojsipuspa, qhuchicunaman yaycuraporkancu. Qhuchicunataj sayaj khata pataman phawaspa, kochaman chhokaycucorkancu, chaypitaj miquicuspa wañurarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Qhuchi michejcunataj chayta ricuspa, llajtaman phawaspa willamorkancu tucuy ima pasaskanta sajra espirituyoj runacunamanta. ");
INSERT INTO qulNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Chay llajtamanta tucuy runa llojsimorkancu Jesús cachcaskan lugarman. Taripaspataj rogarkancu chay lugarmanta puripunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesús boteman yaycuspa kocha chimpaman puriporkan. Chayaporkantaj llajtanman. ");
INSERT INTO qulNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Chaypitaj uj such'u runata apamorkancu, callapupi wantuspa. Jesús creeynincuta ricuspa, onkoskaman nerkan: —Animacuy, wawáy; juchayquicuna perdonaskaña. ");
INSERT INTO qulNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Leymanta yachachejcunataj pensarkancu: “Payka niskanwan Diosta phiñachin.” ");
INSERT INTO qulNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesús cay jinata pensaskancuta yachaspa, taporkan: —¿Imaraycutaj mana allinta pensanquichis? ");
INSERT INTO qulNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Maykentaj astawan fácil ninari: ‘Juchayquicuna perdonaska’, icha ‘Jatariy, puripuy’ ninachu? ");
INSERT INTO qulNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Noka ricuchiskayquichis Tataj Churenka atiyniyoj caskanta, cay pachapi juchacunata perdonananpaj. Such'uman nerkan: —Kanta niyqui, jatariy. Puñunayquita okharispa, wasiyquiman puripuy. ");
INSERT INTO qulNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Such'utaj sayarispa, wasinman puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Chayta ricuspa, runacunaka mancharicorkancu. Diostataj alabarkancu cay jina atiyta runaman koskanmanta. ");
INSERT INTO qulNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Chaymanta Jesús puripuspa, Mateota ricorkan Romapaj impuesto cobrana lugarpi tiyachcajta. Payta nerkan: —Nokawan puriy. Mateotaj sayarispa paywan puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jesús Mateopaj wasinpi miqhuchcarkan. Miqhuchcajtin, achqha impuesto cobraj runacuna waj juchasapacunapiwan chayamuspa, Jesuswan discipuloncunapiwan cusca mesapi tiyaycorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Chayta ricuspa, fariseocuna discipulocunata taporkancu: —¿Imaraycutaj yachachejniyquichis impuesto cobrajcunawan juchasapacunapiwan miqhun? ");
INSERT INTO qulNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesús chayta uyarispa, nerkan: —C'uchicunaka medicota mana necesitancuchu, manachayri onkoskacunalla. ");
INSERT INTO qulNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Puriychis, cay Escriturata yachakamuychis: ‘Qhuyapayacojta munani, mana religión junt'ajllatachu.’ Mana ‘sumaj runa cani’ nejcunata wajajchu jamuni, manachayri juchasapacunallata. ");
INSERT INTO qulNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Juan Bautistapaj discipuloncuna Jesusman chimpaycuspa taporkancu: —Nokaycu fariseocunapiwan sinchita ayunaycu. Discipuloyquicunari ¿imaraycutaj mana ayunancuchu? ");
INSERT INTO qulNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús paycunaman nerkan: —¿Atincumanchu casamientoman invitaskacuna llaquiska cayta, novio paycunawan cachcajtinri? Chaywanpas, tiempo jamonka novio paycunamanta kechuska cananpaj; chhica ayunankacu. ");
INSERT INTO qulNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Mana pipas mauc'a p'achataka mosojwan remendanchu, imaraycuchus mosoj remiendoka mauc'a p'achata astawan athunta lliq'ipunman. ");
INSERT INTO qulNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nitaj mosoj vinota mauc'a kara botaman jich'aycuncumanchu, imaraycuchus mosoj vinoka mauc'a botata t'ojachinman. Vinotaj jich'arparicunman, kara botapas lliq'icapunman. Chayraycu mosoj vinotaka mosoj karaman jich'aycuna, ajinapi iscaynincu sumajta canancupaj.” ");
INSERT INTO qulNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesús parlachcajtinraj, judiocunapaj uj jefen chayamuspa, ñaupakenpi konkoriycuspa nerkan: —Ususiy cunitan wañuporkan. Kan jamuwaj, maquiyquitataj pay pataman churawaj chayka, causaripunman. ");
INSERT INTO qulNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesustaj sayarispa, discipuloncunawan jefewan cusca puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Uj warmi chunca iscayniyoj wataña yawar apaywan onkoska carkan. Chay warmitaj khepanejmanta Jesusman chimpaycuspa, p'achanpaj cantonta llanqhaycorkan. ");
INSERT INTO qulNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Chay warmi pensarkan: “P'achallantapas llanqharisaj chayka, alliyapusaj” nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesustaj cutirispa, warmita ricuspa, nerkan: —Animacuy, wawáy. Alliyachiska canqui creeskayquiraycu. Chhicamantapacha alliyaporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jesús judiocunaj jefenpaj wasinman chayaspa, ricorkan música tocajcuna listoña caskancuta p'ampaj purinancupaj. Achqha runacunataj kaparispa wakarachcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jesús paycunata nerkan: —Caymanta llojsiychis. Cay wawaka mana wañuskachu, puñuchcallan. Runacunataj Jesuspaj niskanmanta asicorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jesús runacunata llojsichispa, wasi uqhuman yaycorkan. Maquinmanta wawata jap'iycojtin, wawaka sayariporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Chay ruwaskantaj tucuynejpi yachacorkan. ");
INSERT INTO qulNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesús chaymanta puripuchcajtintaj, iscay ñausacuna khepanta katerkancu wajach'acuspa: —¡Davidpaj Churin, qhuyapayawaycu! ");
INSERT INTO qulNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesús wasiman chayajtin, ñausacunaka chimpaycorkancu. Jesustaj paycunata taporkan: —¿Creenquichischu atiyniyoj caskayta, cayta ruwanaypaj? Paycunataj nerkancu: —Arí, Señor, creeycu —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jesustaj ñawincuta llanqhaycuspa, paycunata nerkan: —Creeskayquichisman jina ruwaska cachun. ");
INSERT INTO qulNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Wajmanta ricucaporkancu. Jesustaj paycunata sinchita nerkan: —Ama ni piman cayta willanquichischu. ");
INSERT INTO qulNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Paycunataj llojsiytawan, Jesuspaj ruwaskanta tucuynejpi willararkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Alliyaska ñawiyojcuna llojsipuchcajtillancuraj, sajra espiritupaj jup'ayachiskan runata Jesusman pusamorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesús sajra espirituta katerkojtin, jup'aka parlaporkan. Runacunataj musphararkancu: —¡Ni jayc'ajpas Israelpi cay jinaka cajchu! —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Fariseocunataj nerkancu: —Cay runaka sajra espiritucunaj jefenpaj atiyninwan waj sajra espiritucunata katerkon. ");
INSERT INTO qulNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús tucuy llajtacunata estanciacunatawan purerkan sinagogacunapi yachachispa, Diospaj gobiernonmanta sumaj evangeliota willaspa, tucuy ima onkoskacunata nanaskacunatapas alliyachispa. ");
INSERT INTO qulNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Achqha runacunata ricuspa, paycunata qhuyapayarkan. Paycuna cachcarkancu llaquiska, sakerpayaska, mana michejniyoj ovejacuna jina. ");
INSERT INTO qulNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Discipuloncunaman nerkan: —Ciertopuni, achqha ajthapinaka, llanc'ajcunataj pisilla. ");
INSERT INTO qulNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Chayraycu kancunaka ajthapinapaj Dueñonmanta mañaychis llanc'ajcunata cachamunanpaj okharejta. ");
INSERT INTO qulNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesús chunca iscayniyoj discipuloncunata wajarkan. Paycunamantaj atiyta korkan sajra espiritucunata katerkonancupaj, tucuy imawan onkoskacunata nanayniyojcunatapas alliyachinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Chunca iscayniyoj apostolcunapaj sutincu caycuna: ñaupajka Simón, Pedro niska, wauken Andrespiwan; Zebedeopaj churincuna Santiago Juanpiwan; ");
INSERT INTO qulNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, Romapaj impuesto cobraj Mateo, Alfeopaj churin Santiago, Tadeo, ");
INSERT INTO qulNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón cananeo niska, Jesusta vendiycoj Judas Iscariotepiwan. ");
INSERT INTO qulNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús chay chunca iscayniyoj apostolnincunata cacharkan nispa: “Ama yaycunquichischu mana judiocunapaj llajtancunaman, nitaj Samaria runacunapaj llajtancunamanpas, ");
INSERT INTO qulNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","manachayri Israelpi caj oveja jina chincaska runacunaman puriychis. ");
INSERT INTO qulNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Puriychis, willaramuychis Diospaj gobiernon kayllamuskantaña. ");
INSERT INTO qulNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Onkoskacunata alliyachiychis, wañuskacunata causarichiychis, lepra onkoyniyojcunata alliyachiychis, runacunamanta sajra espiritucunata katerkoychis. Kancunaman kasilla atiyta koyquichis, kancunapas kasilla ruwanquichis. ");
INSERT INTO qulNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Ama apaychischu kolketa, korita, cobretapas, ");
INSERT INTO qulNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","nillataj miqhuna apana saquillata, ni cambiacunapaj p'achata, ni iscay abarcacunata, ni bastontapas, imaraycuchus llanc'ajka derechoyoj miqhuchiska cananpaj. ");
INSERT INTO qulNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“May llajtamanpas estanciacunamanpas chayaspaka, sumaj runata masc'aychis. Paypaj wasinpi alojacuychis pasapunayquichiscama. ");
INSERT INTO qulNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Wasiman yaycuspa, saludaychis: ‘Diospaj sonko tiyaycuynin kancunawan cachun’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Wasipi cajcuna sumaj runacuna cajtenka, Diospaj sonko tiyaycuyninwan bendiciska cankacu. Sajra runacuna cajtincutaj, mana bendiciskachu cankacu. ");
INSERT INTO qulNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mayllapipas mana jap'ekayta ni uyariytapas munasunquichischu chayka, chay lugarmanta llojsipuychis. Chaquiyquichispi caj polvotapas thalaraychis paycuna contra. ");
INSERT INTO qulNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Segurayquichis, juicio p'unchaypeka chay llajtapaj astawan ñac'ariy canka Sodomamanta Gomorramantawan nejtenka. ");
INSERT INTO qulNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“¡Uyariychis! Cunanka ovejacunata jina cachachcayquichis lobo jina sajra runacunapaj chaupinman. Palli jina allin yuyayniyoj caychis, paloma jinataj mana dañota ruwaspa. ");
INSERT INTO qulNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Cuidacuychis, autoridadcunaman entregasunquichis, sinagogacunapi bajtasunquichis. ");
INSERT INTO qulNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nokaraycu gobernajcunapaj ñaupakenman apaska canquichis. Jinapi nokamanta willaranquichis paycunaman, waj dioscunayoj runacunamanpas. ");
INSERT INTO qulNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Autoridadcunaman entregajtincu, ama llaquicuychischu, ‘¿Imanasajtaj cunanri?’ nispaka, nitaj pensaychischu imaynata ninayquichista. Chay ratopi Dios imatacha kosunquichis, chayta parlaychis. ");
INSERT INTO qulNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Mana kancunachu parlanquichis, manachayri Tatayquichispaj Santo Espíritun parlachisunquichis. ");
INSERT INTO qulNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Uj wauke waukenta entreganka wañuchiska cananpaj. Uj tatapas wawan contra, wawacunapas tatancu contra sayarenkacu wañuchinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nokaraycu tucuypaj chejniskan canquichis. Pichari tucucuycama fiel cajlla, salvaska canka. ");
INSERT INTO qulNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mayken llajtallapipas chejnisunquichisman chayka, waj llajtamanñataj escapaychis. Segurayquichis, manaraj Israel llajtacunapi willarayta tucuchcajtiyquichis, Tataj Churenka jamonka. ");
INSERT INTO qulNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ni mayken discipulopas yachachejninmanta nejtin astawan curajchu, nitaj uywaskapas patronninmanta nejtenka. ");
INSERT INTO qulNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Discipuloka contentacunan yachachejnin jina caskanwan, uywaskapas patronnin jina caskanwan. Wasiyojtapas ‘Beelzebú supay’ nichcaspaka, ¡imatarajchá nenkacu wasiyojpaj familiantaka! ");
INSERT INTO qulNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ama runacunata manchacuychischu. Tucuy pacaska sut'inchaconka, yachaconkataj. ");
INSERT INTO qulNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tucuy imata tutayajpi kancunaman niskayta, sut'i p'unchaypi niychis. Pacapi niskaytapas, altos patamanta wajach'acuychis. ");
INSERT INTO qulNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Cuerpota wañuchejcunata ama manchaychischu; imaraycuchus almayquichistaka mana infiernoman wijch'uyta atincumanchu. Astawanka Diosta manchacuychis. Payka cuerpota wañuchispa, almayquichista infiernoman wiñaypaj wijch'uycuyta atinman. ");
INSERT INTO qulNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“¿Manachu iscay pisketota vendincu uj kolkellapi? Chaywanpas Dios Tatayquichis mana nejtenka, ni uj pisketollapas jallp'aman urmakanmanchu. ");
INSERT INTO qulNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ajinallatataj umayquichispi caj chujchayquichiscunapas ujmanta uj yupaska. ");
INSERT INTO qulNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ajinaka ama manchacuychischu. Kancunaka Diospaj astawan valinquichis achqha pisketocunamanta nejtenka. ");
INSERT INTO qulNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Pillapas runacunapaj ñaupakenpi nokapaj caskanta willacojtenka, nokapas janaj pachapi cachcaj Tataypaj ñaupakenpi nokapaj caskanta nillasajtaj. ");
INSERT INTO qulNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pillapas runacunapaj ñaupakenpi negawajtaka, nokapas janaj pacha Tataypaj ñaupakenpi negallasajtaj. ");
INSERT INTO qulNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“¿Pensanquichischu cay pachapi caj runacuna allinpi canancupaj jamuskayta? Manami, manachayri chejninaska cayta ch'ajwaytawan apamuni. ");
INSERT INTO qulNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nokaka partiraj jamuni churita tatan contra, ususita maman contra, khachunitataj suegran contra. ");
INSERT INTO qulNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ajinaka enemigoyquichis sapa ujpaj canka quiquin parienteyquichismanta. ");
INSERT INTO qulNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Pichus nokata munacuwaytapacha tata mamanta astawan munacun chayka, mana nokapajta canmanchu. Ajinallatataj pichus nokata munacuwaytapacha churinta ususinta astawan munacun chayka, mana nokapajta canmanchu. ");
INSERT INTO qulNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Pichus wañunancama sufrispapas nokawan purejka, nokapajta canka. ");
INSERT INTO qulNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Causaynillanta salvayta munajka, chincachenka; nokaraycu causayninta chincachejka, salvaconka. ");
INSERT INTO qulNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Pichus kancunata jap'ekajka, nokata jap'ekawan; nokata jap'ekajtaj, cachamuwaj Tatayta jap'ekan. ");
INSERT INTO qulNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Pichus uj profetata jap'ekajmanka, Diosmanta parlaj caskanraycu, Dios kollankataj imaynatachus uj profetanman kon jinata. Pichus sumaj runata jap'ekajmanka, sumaj caskanraycu, Dios kollankataj imaynatachus sumaj runaman kon jinata. ");
INSERT INTO qulNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Maykenpas wawa jina humilde creyentecunaman, nokawan purej caskanraycu, uj vaso chiri unullatapas konman chayka, segurayquichis, Dios payman bendicionta kollankataj premiota jina.” ");
INSERT INTO qulNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesús chunca iscayniyoj discipuloncunata yachachiyta tucuchaspa, waj llajtacunaman puriporkan yachachej, evangeliota willaj. ");
INSERT INTO qulNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan Bautista carcelpi cachcajtin, payman willarkancu Cristo ruwachcaskanmanta. Chayraycu iscay discipuloncunata Jesusman cacharkan, ");
INSERT INTO qulNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","tapunancupaj: “¿Kanchu canqui jamunan carkan chay, icha wajtachu suyasajcu?” nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesús contestarkan: “Puriychis, Juanman willamuychis ricuskayquichista uyariskayquichistawan: ");
INSERT INTO qulNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ñausacuna ricucuncu, such'ucuna purincu, lepra onkoyniyojcuna alliyancu, rojt'ucuna uyarincu, wañuskacuna causarincu, pobrecunamantaj salvación evangelio willaraska. ");
INSERT INTO qulNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","¡Cusicuyniyojmi nokapi confiacuskanta mana chincachicojka!” ");
INSERT INTO qulNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Juanpaj discipuloncuna cutipojtincu, Jesús Juanmanta parlayta kallarerkan nispa: “¿Imatataj ch'usaj pampapi ricumorkanquichis? ¿Wayrapaj chuqui cuyuchiskantachu? ");
INSERT INTO qulNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mana chayri, ¿imatataj khawaj llojserkanquichis? ¿Sumaj fino p'achayoj runatachu? Kancuna yachanquichis, fino p'achayojcunaka gobernajcunapaj wasincunapi tiyancu. ");
INSERT INTO qulNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Imatapunitaj khawaj llojserkanquichis? ¿Uj Diosmanta parlaj profetatachu? Arí, ciertotapuni niyquichis, profetamantapas Juan astawan curajraj. ");
INSERT INTO qulNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juanmanta Escriturapi cay jinata nin: ‘Noka willajniyta ñaupakeyquita cachamuni, runacunapaj sonkonta waquichipunasunquipaj ñanta jina.’ ");
INSERT INTO qulNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Segurayquichis, tucuy runacuna uqhupi Juan Bautistamanta astawan curaj mana canchu. Chaywanpas, Diospaj gobiernonpi astawan juch'uy cajka, Juanmanta astawan curajraj. ");
INSERT INTO qulNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Juan Bautistapaj jamuskanmantapacha cunancama Diospaj gobiernon ñac'arin; runacuna callpancuwan chincachiyta munarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Profetacuna Moisespaj leyninpas Diospaj gobiernonmanta willarkancu Juanpaj jamunancamalla. ");
INSERT INTO qulNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Sichus kancuna Juanmanta niskata creeyta munanquichis chayka, Elías jamunan carkan chay profetaka Juanmi. ");
INSERT INTO qulNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Uyarejcunaka, allinta uyariychis. ");
INSERT INTO qulNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“¿Imamantaj cunan tiempo runacunata rijch'achisaj? Rijch'acun plazapi wawamasincuta wajach'aspa pujllaj wawacunaman: ");
INSERT INTO qulNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Pinquilluta tocaycu, kancunataj mana tusunquichischu. Taquiycu llaquichicojta jina, kancunataj mana wakanquichischu’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Chayta nini, imaraycuchus Juan Bautista jamuspa ni miqhunchu ni ujyanchu. Kancunataj ninquichis: ‘Sajra espirituyoj’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Chaymanta Tataj Churenka jamun, paycajtaj miqhun ujyantaj. Kancunataj ninquichis: ‘Sinchi miqhoj, ujyajtaj, mana allin runacunapaj Romapaj impuesto cobrajcunapajpiwan amigon’ nispa. Chaywanpas Diospaj yachaynenka tucuy ruwaynincunapi ricuchicun.” ");
INSERT INTO qulNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jesús milagrocunata ruwaskan llajtacunapi caj runacunata c'amiyta kallarerkan, imaraycuchus manapuni juchancumanta Diosman cutiricuskacuchu. Chayraycu Jesús nerkan: ");
INSERT INTO qulNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“¡Ay, Corazín llajtapi caj runacuna! ¡Ay, Betsaida llajtapi caj runacuna! Achqha milagrocunata ricorkanquichis. Sichus kancuna uqhupi chay quiquin ruwaskay milagrocuna Tiro llajtapi Sidón llajtapipas ruwacunman carkan chayka, may tiempoña Diosman cutirincuman carkan, uchphawan khachka p'achatawan churacuspa, Diosman cutiricuskancuta ricuchicunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Niyquichis, juicio p'unchaypeka Tiropi Sidonpi caj runacuna castigo sufriskancumantapas astawan sinchi athun castigo kancunapaj canka. ");
INSERT INTO qulNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","¡Kancunarí, Capernaum llajtapi caj runacuna! ¿Creenquichischu janaj pachacama pusaska canayquichista? ¡Kancunaka uqhu infiernocama chhokaycuska canquichis! Sodoma llajtapichus kancuna uqhupi ruwaskay milagrocuna ruwacunman carkan chayka, chay llajtaka cunancama canman carkan. ");
INSERT INTO qulNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Chayraycu niyquichis, juicio p'unchaypeka Sodomapi caj runacuna castigo sufriskancumantapas astawan sinchi athun castigo kancunapaj canka.” ");
INSERT INTO qulNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Chay p'unchaycunapi Jesús nerkan: “Janaj pachapaj cay pachapajpiwan Señor Diosnin, Tatáy, yachayniyojcunamanta yuyayniyojcunamantapas caycunata pacaskayquimanta alabayqui, wawa jina cajcunamantaj ricuchinqui. ");
INSERT INTO qulNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Arí, Tatáy, ajinata kan munanqui. ");
INSERT INTO qulNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Tatay tucuy imata kowan. Mana pipas yachanchu pichus Churi caskantaka, manachayri Dios Tatalla yachan. Nitaj pipas yachanchu pichus Dios Tata caskanta, manachayri Churillan yachan, picunamanchus Churin rejsichiyta munan chaycunapiwan. ");
INSERT INTO qulNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Nokaman jamuychis tucuy salvacionta masc'aspa sayc'uskacuna, jucha k'epiriskacuna; nokataj samachiskayquichis. ");
INSERT INTO qulNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nokawan puriychis yugoska jina. Nokamantataj yachakaychis, imaynatachus pacienciayoj cani, humilde sonkoyojtaj. Jinapi almayquichispaj samacuyta tarinquichis. ");
INSERT INTO qulNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nokapaj churaskay yugo fácil, koskay k'epipas apanayquichispaj jina sujalla.” ");
INSERT INTO qulNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Samana p'unchay Jesús discipuloncunapiwan trigo chajra uqhunta purichcarkancu. Discipuloncuna yarekachicuspa, trigo urita pallarkancu. Maquincuwan khakospataj, miqhuchcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Fariseocuna chayta ricuspa, Jesusta taporkancu: —¿Imaraycutaj discipuloyquicuna samana p'unchaypi mana ruwanata ruwachcancuri? ");
INSERT INTO qulNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesús contestarkan: —¿Manachu leerkanquichis imatachus David compañancunapiwan yarekachicuspa ruwaskancuta? ");
INSERT INTO qulNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Diospaj wasinman yaycuspa, Diosman koska caj t'antacunata miqhorkancu. Chay t'antacunata mana miqhunanchu carkan pay ni paywan cajcunapas, manachayri sacerdotecunalla. ");
INSERT INTO qulNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Icha, ¿manachu Moisespaj leyninpi leerkanquichis, samana p'unchaypi sacerdotecuna templopi sirvispa mana juchallicuskancuta, mana samaspa chaywanpas? ");
INSERT INTO qulNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Niyquichis, caypi astawan curaj cachcan templomanta nejtenka. ");
INSERT INTO qulNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kancunaka mana entendinquichischu cay Escritura niy munaskanta: ‘Qhuyapayacojta munani, mana religión junt'ajllatachu.’ Sichus entendiwajchis carkan chayka, mana juchachawajchischu carkan mana juchayojcunataka. ");
INSERT INTO qulNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Allin ari, Tataj Churenka atiyniyojmi samana p'unchaymantapas. ");
INSERT INTO qulNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesús chaymanta puripuspa, chaypi caj sinagoga wasiman yaycorkan. ");
INSERT INTO qulNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Chaypi uj runa carkan ch'aquiska maquiyoj. Runacunataj juchachayta munaspa, Jesusta taporkancu: —¿Aticunchu samana p'unchaypi onkoskata alliyachina? ");
INSERT INTO qulNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesustaj contestarkan: —¿Maykentaj kancunamanta ovejayoj caspa, samana p'unchaypi ujnin ovejan phujyuman urmaycojtin, mana purispa orkhomunmanchu? ");
INSERT INTO qulNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¡Uj runaka astawan valorniyojmi uj ovejamanta nejtenka! Chayraycu aticun samana p'unchaycunapi alliyachinaka. ");
INSERT INTO qulNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Chay runaman nerkan: —Maquiyquita jaywariy. Maquinta jaywarejtintaj, uj lado c'uchi maquin jina alliyaska caporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Fariseocunataj llojsipuspa, paycunapura parlanacorkancu imaynata Jesusta wañuchinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Chayta yachaspa, Jesús puriporkan. Achqha runataj khepanta purichcarkancu. Jesús tucuy onkoskacunata alliyacherkan. ");
INSERT INTO qulNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Paycunatataj mandarkan ama paymanta ni piman willanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Chay jinapi profeta Isaiaspaj Jesusmanta niskanta junt'acorkan: ");
INSERT INTO qulNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Caypi cachcan ajllaska, munaska sirvejniy. Paypi cusicuni. Payman Espirituyta kosaj, pay tucuy nacionpi caj runacunaman justo salvacionta willanka. ");
INSERT INTO qulNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mana churanaconkachu, nitaj wajach'aconkachu; nillataj pipas callecunapi alto vozwan niskanta uyarenkachu. ");
INSERT INTO qulNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Chuqui jina débil runacunata mana p'aquenkachu, nitaj aypha mecha jina débil runacunata wañuchenkachu, justo cayninwan gobernanancama. ");
INSERT INTO qulNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nacioncunapi caj runacuna salvacionta suyaspa, paypi confiaconkacu.” ");
INSERT INTO qulNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Sajra espiritupaj ñausayachiskan jup'ayachiskan runata Jesusman pusarkancu. Jesustaj khawachiporkan, parlachiporkantaj. ");
INSERT INTO qulNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tucuy muspharaspa, tapucorkancu nispa: “¿Caychu Davidpaj Churin canman?” ");
INSERT INTO qulNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Chayta uyarispa, fariseocunaka nerkancu: “Cay runaka Beelzebú niska sajra espiritucunaj jefenpaj atiyninwan waj sajra espiritucunata katerkon.” ");
INSERT INTO qulNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesustaj chay parlachcaskancuta yachaspa, nerkan: “Uj nación achqhaman partiskaka, paycama ñut'ucun. Ajinallatataj uj llajta chayri uj familia partiska cajtin, mana astaqui junto canmanchu. ");
INSERT INTO qulNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ajinallatataj supay Satanaspas quiquin supayta katerkon chayka, pay quiquin particun. ¿Imaynatataj chhicari atiynin callanmanpuniri? ");
INSERT INTO qulNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kancuna ninquichis noka sajra espiritucunata supaypaj atiyninwan katerkoskayta. Jina cajtinri, ¿pitaj discipuloyquichiscunaman atiyta kon sajra espiritucunata katerkonancupaj? Chayraycu paycuna quiquin ricuchicuncu kancuna pantaska caskayquichista. ");
INSERT INTO qulNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Noka Diospaj Espiritunwan sajra espiritucunata katerkoni chayka, niyta munan: Diospaj gobiernonka kancunaman chayamunña. ");
INSERT INTO qulNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ni pipas uj callpayoj runapaj wasinman yaycunmanchu cajnincunata kechunanpaj, mana ñaupajta payta wataycuspaka. Chaymantaraj kechuyta atinman. ");
INSERT INTO qulNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Pichus mana nokawan cajka, noka contra. Pitajchus mana nokawan pallajpas, t'acaran. ");
INSERT INTO qulNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Chayraycu niyquichis, Dios runacunata perdonan tucuy ima juchancumanta tucuy mana allin parlaskancumantapas, chaywanpas Santo Espíritu contra parlajcunataka mana perdonankachu. ");
INSERT INTO qulNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Dios perdonankaraj canpas Tatapaj Churin contra parlajcunataka. Chaywanpas, Santo Espíritu contra parlajtaka mana perdonankachu ni cunan tiempopipas ni jamoj tiempopipas. ");
INSERT INTO qulNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Allin cuidaska sach'aka allinta urenka; mana allin cuidaskaka mana allinta urenka. Sach'aka uriyninmanta rejsichicun. ");
INSERT INTO qulNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Pallipaj miraynin runacuna! ¿Imaynatataj allinta parlawajchis, sajra runacuna cachcaspari? Sonkoyquichispi junt'a cajmanta simiyquichiska parlan. ");
INSERT INTO qulNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ajinallatataj sumaj runaka sonkonpi sumaj cajcunamanta sumajta parlan; mana allin runarí mana allin sonkonpi cajmanta parlan. ");
INSERT INTO qulNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nokataj niyquichis, juicio p'unchaypeka tucuy runacuna cuentata konkacu tucuy mana allin parlaskancumanta. ");
INSERT INTO qulNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Chayraycu quiquin parlaskayquichiswan juchachaska canquichis; sut'inchaska canka juchayojchus icha mana juchayojchus caskayquichis.” ");
INSERT INTO qulNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Fariseocuna leymanta yachachejcunapiwan Jesusman nerkancu: —Yachachej, uj ruwaskayqui milagrota ricuyta munaycu. ");
INSERT INTO qulNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesustaj contestarkan: —Cay sajra mana casucoj runacuna uj milagrota mañancu. Manataj waj milagrota riconkacuchu, manachayri Jonasllamanta. ");
INSERT INTO qulNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Imaynatachus Jonás athun challwapaj wijsanpi carkan quimsa p'unchayta quimsa tutatawan, ajinallatataj Tataj Churenka quimsa p'unchayta quimsa tutatawan p'ampaska canka. ");
INSERT INTO qulNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Juicio p'unchaypi Nínive llajtayoj runacuna causarimuspa, cay tiempopi causachcaj runacunata juchachankacu; imaraycuchus Nínive llajtayoj runacuna Jonaspaj willaskanta uyarispa, Diosman cutirerkancu. Jonasmanta nejtinpas astawan curajmi caypi cachcan. ");
INSERT INTO qulNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Juicio p'unchaypi causarimuspa, uraynej nacionmanta gobernaj warmi cay tiempopi causachcaj runacunata juchachanka; imaraycuchus payka carumanta jamorkan gobernaj Salomonpaj yachaynin uyarej. Salomonmanta nejtinpas astawan yachayniyojmi caypi cachcan. ");
INSERT INTO qulNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Sajra espíritu uj runamanta llojsin chayka, ch'aqui lugarcunata purin, samacunata masc'aspa. Mana tarispataj, pensan: ");
INSERT INTO qulNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‘Maymantachus llojsimuni chay wasiman cutipusaj.’ Chayaspataj chay runata taripan uj wasi pichaska jallch'askata jina. ");
INSERT INTO qulNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Chhicataj purispa kanchis espiritucunata tantaycun paymanta nejtinpas astawan sajracunata. Tucuynincu tantaycucuspa, yaycuncu chay runapi tiyanancupaj. Chay runataj ñaupaj caskanmanta nejtenka, astawan mana allinchu capun. Ajinallatataj pasanka cay sajra runacunawanka.” ");
INSERT INTO qulNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús runacunaman parlachcajtinraj, maman waukencunapiwan chayamorkancu, Jesuswan parlayta munaspa. Jawallapi quedacuskancuraycu, ");
INSERT INTO qulNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","uj runa Jesusman willarkan: —Mamayqui waukeyquicunapiwan jawapi cachcancu, kanwantaj parlayta munancu. ");
INSERT INTO qulNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesustaj willaj runaman contestarkan: —¿Pitaj mamayri, picunataj waukeycunari? ");
INSERT INTO qulNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Discipuloncunata maquinwan ricuchispa, nerkan: —Caycuna mamayka waukeycunapas. ");
INSERT INTO qulNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Maykenpas janaj pachapi cachcaj Tataypaj munayninta ruwajlla waukeyka, panaypas, mamaypas. ");
INSERT INTO qulNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Chay p'unchaypacha Jesús wasimanta llojsispa, kocha cantopi tiyaycorkan. ");
INSERT INTO qulNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Achqha runa tantacamorkancu. Chayraycu Jesús boteman yaycuspa tiyaycorkan. Runacunataj kocha cantopi cachcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jesús ejemplocunawan yachachiyta kallarerkan. Paycunamantaj nerkan: “Uj runa llojserkan tarpoj. ");
INSERT INTO qulNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tarpuchcajtintaj, waquin mujucuna ñan pataman t'acacorkan. Pisketocunataj chayamuspa pallacaporkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Waquin mujucuna pisi jallp'ayoj rumi pampaman t'acacorkan. Rato wiñarimorkan, chaywanpas pisi jallp'ayoj caskanraycu mana saphichayta aterkanchu. ");
INSERT INTO qulNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ruphaytaj ch'aquichiporkan, mana saphiyoj caskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Waquintaj qhichcacuna uqhuman t'acacorkan. Qhichcacunataj wiñarispa sipiycuspa, makaporkancu, nitaj urerkanchu. ");
INSERT INTO qulNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Waquin mujucunataj sumaj jallp'aman t'acacorkan. Chay mujucunacajtaj allinta urerkancu. Waquin pokorkan pachajta, waquin sojta chuncata, waquintaj quimsa chuncata. ");
INSERT INTO qulNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","¡Uyarejcunaka, entendiychis!” ");
INSERT INTO qulNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Discipuloncuna Jesusman kayllaycuspa, taporkancu: “¿Imaraycutaj ejemplocunawan runacunaman parlanqui?” ");
INSERT INTO qulNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesús paycunaman contestarkan: “Kancunamanka Dios gobiernonmanta mana yachaskacunata sut'inchasunquichis; wajcunamantaj, mana. ");
INSERT INTO qulNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Diospaj palabranta entendejka astawan entendenka; mana entendejmantataj pisi entendiskanpas kechuska canka. ");
INSERT INTO qulNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Chayraycu ejemplocunawan parlani. Paycunaka khawachcaspa mana ricuncuchu, uyarichcaspapas mana uyarincuchu, ni entendincuchu. ");
INSERT INTO qulNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ajinapi paycunawanka profeta Isaiaspaj niskan junt'acun: ‘Uyarichuncupas, mana entendenkacuchu. Khawachuncupas, mana riconkacuchu. ");
INSERT INTO qulNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Imaraycuchus cay runacunapaj umanka mana yuyayniyoj jina, ninrincupas ñawincupas tapaska cachcan, mana ricunancupaj ni uyarinancupaj, ni entendinancupaj, mana nokaman cutimunancupaj, nokataj mana alliyachinaypaj.’ ");
INSERT INTO qulNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Kancunacajka cusicuyniyoj canquichis, imaraycuchus ñawiyquichis ricun, ninriyquichispas uyarin. ");
INSERT INTO qulNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Segurayquichis, achqha profetacuna sumaj runacunapas kancunapaj ricuskayquichista ricuyta munarkancu, manataj ricorkancuchu. Kancunapaj uyariskayquichista uyariyta munarkancu, manataj uyarerkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Uyariychis, ari, imatachus niyta munan tarpuskamanta ejemploka. ");
INSERT INTO qulNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Picunachus janaj pacha Diospaj gobiernonmanta willaskata uyarispa mana entendincuchu chayka, ñan patapi t'acaska muju jina cancu, imaraycuchus supay jamuspa, sonkonpi tarpuska cajta kechun. ");
INSERT INTO qulNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Rumi uqhuman t'acaska muju jina runacunataj Diospaj palabranta uyarispa cusicuywan jap'ekancu. ");
INSERT INTO qulNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Chaywanpas mana sumaj saphiyoj jina caspa, mana aguantancuchu. Evangeliota creeskancuraycu pruebacuna chejnicuycunapiwan jamojtin, creeynincuta chincachicapuncu. ");
INSERT INTO qulNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Qhichca uqhuman t'acaska muju jina runacunataj Diospaj palabranta uyarincu. Chaywanpas negocioncupi sinchita afanacuspa, khapajyayta munaskancupiwan paycunata engañan. Tucuy caycuna Diosmanta uyariskancuta wañuchin, nitaj paycunapi uriyta atinchu. ");
INSERT INTO qulNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Sumaj jallp'api t'acaska muju jina runacunacajtaj, Diospaj palabranta uyarispa, entendincu. Sumaj urej jina sumaj causayniyoj cancu. Imaynatachus uj mujucuna pachajta urerkancu, ujcunataj sojta chuncata, ujcunataj quimsa chuncata, ajina cancu sumaj jallp'api tarpuskacunaka.” ");
INSERT INTO qulNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Waj ejemplowan Jesús yachacherkan nispa: “Janaj pacha Diospaj gobiernonka sumaj mujuta tarpoj runaman rijch'acun. ");
INSERT INTO qulNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tucuy puñuchcajtincutaj, uj chejnicoj jamuspa trigo uqhupi millay korata tarpuycuspa, puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Trigo wiñamojtin, millay korapas wiñamullarkantaj. Trigowan cusca urichcajtinña, millay korata rejserkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Llanc'ajnincuna purispa, chajrayojman willarkancu nispa: ‘Señor, ¿manachu sumaj mujuta tarporkanqui? ¿Imaynamantataj riqhurimun millay korari?’ ");
INSERT INTO qulNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Chajrayojtaj contestarkan: ‘Mayken chejnicojchari chaytaka ruwan.’ Llanc'ajnincunataj taporkancu: ‘¿Munanquichu chay millay korata t'iraramunaycuta?’ ");
INSERT INTO qulNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Paytaj nerkan: ‘Ama. Millay korata t'iraraspaka, trigotawan t'irarawajchis. ");
INSERT INTO qulNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Dejallaychis trigowan cusca wiñajta, ajthapinacama. Chhicaraj ajthapejcunata cachasaj, ñaupajta millay korata montón montonta wataycuspa ninapi ruphachinancupaj, trigocajtataj trojeypi wakaychanancupaj.’ ” ");
INSERT INTO qulNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús cuentallarkantaj cay ejemplota: “Diospaj gobiernonka uj mostaza mujuta tarpuycuskaman rijch'acun. ");
INSERT INTO qulNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tucuynin mujumanta nejtin sinchi juch'uy caspapas, wiñaspaka astawan athun tucun huertapi tucuy sach'acunamanta nejtenka. Athun sach'a cajtin, pisketocunapas jamuspa ramancunapi tapachacuncu.” ");
INSERT INTO qulNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Cuentallarkantaj cayta: “Diospaj gobiernonka levaduraman rijch'acun. Uj warmi quimsa medida levadurata jac'uman chhajruycojtin, tucuynin masata pokochin.” ");
INSERT INTO qulNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesús tucuy cay ejemplocunawan runacunaman parlarkan. Mana ejemplowanka mana parlarkanchu. ");
INSERT INTO qulNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ajinapi profetapaj niskan junt'acorkan: “Ejemplocunawan parlasaj; Dios cay pachata ruwaskanmantapacha pacapi cajcunata willasaj.” ");
INSERT INTO qulNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Runacunata cacharparispa, Jesús wasiman yaycorkan. Discipuloncunataj chimpaycuspa, mañarkancu kora ejemplota sut'inchananpaj. ");
INSERT INTO qulNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesús paycunaman contestarkan: “Sumaj mujuta tarpojka Tataj Churin. ");
INSERT INTO qulNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Chajrataj runacuna. Sumaj mujutaj Diospaj gobiernonpi cajcuna, millay korataj supaywan cajcuna. ");
INSERT INTO qulNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Millay korata tarpojka supay, ajthapina tiempotaj cay pacha tucucuynin, ajthapejcunataj angelcuna. ");
INSERT INTO qulNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Imaynatachus millay korata ajthapispa ninapi ruphachincu, jinallatataj pasanka cay pacha tucucuypeka. ");
INSERT INTO qulNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Tataj Churin angelnincunata cachamonka, juchaman urmachejcunata, mana allin runacunatawan ajthapejta. ");
INSERT INTO qulNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Wijch'uyconkacu nina lauraj infiernoman. Chaypitaj wakarankacu, quiruncuta nanaymanta c'ariris nispa c'uturacuspa. ");
INSERT INTO qulNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Diospaj niskanta casucojcunataj inti jina c'ancharenkacu Dios Tatancupaj gobiernonpi. Uyarejcunaka, entendiychis. ");
INSERT INTO qulNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Diospaj gobiernonka jallp'api pacaska kolkeman rijch'acun. Uj runa chayta tarispa, chay quiquinpi wajmanta pacaycun. Cusiska purispataj, tucuy cajninta venderkospa, chay jallp'ata rantin. ");
INSERT INTO qulNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Jinallatataj Diospaj gobiernonka sumaj perlacuna masc'aj runaman rijch'acun. ");
INSERT INTO qulNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Uj sinchi valorniyoj perlata tarispataj, puripun. Tucuy cajninta venderkospa, chay perlata rantin. ");
INSERT INTO qulNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Diospaj gobiernonka rijch'acullantaj kochapi tucuy ima challwa jap'ej llicaman. ");
INSERT INTO qulNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Llica junt'aña cajtenka, challwirucuna playaman orkhoncu. Tiyaycuspataj, challwata ajllancu, sumajnincunata canastaman, millaynincunatataj wijch'uncu. ");
INSERT INTO qulNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Jinallatataj pasanka cay pacha tucucuypeka. Angelcuna llojsimonkacu mana allinnincunata allincuna uqhumanta ajllanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Mana allin runacunata nina lauraj infiernoman wijch'uyconkacu. Chaypitaj wakarankacu, quiruncutataj nanaymanta c'ariris nispa c'uturaconkacu.” ");
INSERT INTO qulNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesús uyarejcunata taporkan: —¿Kancunari tucuy caycunata entendinquichischu? —Arí, Señor —contestarkancu paycunaka. ");
INSERT INTO qulNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Chhicataj Jesús paycunata nerkan: —Jayc'ajchus Diospaj gobiernonmanta uj leymanta yachachej yachachejtenka, uj wasiyoj runaman rijch'acun, wakaychaskanmanta mosoj cajcunata mauc'a cajcunatawan orkhoyta yachajman. ");
INSERT INTO qulNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesús ejemplocunawan yachachiyta tucuchaspa, chaymanta puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Quiquin llajtanman chayapuspa, sinagoga wasipi yachachiyta kallarerkan. Runacunataj musphararkancu nispa: —¿Maypitaj cayri tucuy yachaskanta yachakamun, imaynata milagrocuna ruwaytapas? ");
INSERT INTO qulNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Manachu cayri carpinteropaj churin, Mariataj maman? ¿Manachu Santiagopaj, Josepaj, Simonpaj, Judaspajpiwan wauken? ");
INSERT INTO qulNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Panancunari manachu nokanchis uqhupi tiyancu? ¿Maymantataj payri tucuy cayta yachan? ");
INSERT INTO qulNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Chayraycu mana casurarkancuchu. Jesustaj paycunata nerkan: —Tucuy lugarpi Diosmanta willaj profetataka sumajta jap'ekancu, manataj quiquin llajtancajpeka ni quiquin wasinpipas. ");
INSERT INTO qulNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Mana creeskancuraycu, chaypeka mana achqha milagrocunata ruwarkanchu. ");
INSERT INTO qulNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Chay quiquin tiempopi, Galileapi gobernaj Herodes Jesusmanta parlajta uyarerkan. ");
INSERT INTO qulNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Sirvejnincunata nerkan: “Chayka Juan Bautista, causarimun. Chayraycu chay jina atiyniyojka, milagrocunata ruwananpaj.” ");
INSERT INTO qulNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ñaupajña Herodeska Juanta jap'icherkan. Cadenawan wataycuchispataj, carcelman wisk'aycucherkan wauken Felipepaj warmin Herodiasraycu. ");
INSERT INTO qulNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Juan Herodesman: “Waukeyquipaj warminwan mana tiyaycuyta atinquichu” niska. ");
INSERT INTO qulNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Chayraycu Herodeska Juanta wañuchiyta munarkan. Chaywanpas runacunata manchacorkan, imaraycuchus tucuy runa creerkancu Juanka Diosmanta parlaskanta. ");
INSERT INTO qulNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herodespaj p'unchayninpitaj Herodiaspaj ususin tusorkan tucuy invitaskacunapaj ñaupakenpi, chaytaj Herodesman sinchi sumaj yuyacorkan. ");
INSERT INTO qulNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Chayraycu Herodeska juramentowan prometicorkan imatapas mañajtin konanpaj. ");
INSERT INTO qulNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Sipastaj mamanpaj yuyaychaskan caspa, Herodesman nerkan: —Juan Bautistapaj umanta uj platopi koway. ");
INSERT INTO qulNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Gobernaj Herodestaj llaquicorkan. Chaywanpas invitaskancunapaj ñaupakenpi juramentowan prometicuskanraycu, mandarkan konancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Mandarkan carcelpi Juan Bautistapaj umanta cuchokanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Uj platopi apaspataj, sipasman korkancu, paytaj mamanman korkan. ");
INSERT INTO qulNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Juanpaj discipuloncunataj chayarkancu. Cuerponta apapuspataj, p'ampamporkancu. Chay pasaymantataj Jesusman willamorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesustaj chayta uyarispa, chaymanta waj lugarman botepi sapallan puriporkan. Runacunataj chayta yacharkospa, llajtacunamanta llojsispa, chaquipi purerkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesús botemanta llojsichcaspa, achqha runacunata ricorkan. Qhuyapayaspa, onkoskacunata alliyacherkan. ");
INSERT INTO qulNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ch'isiyaycuytataj discipuloncuna chimpaycuspa nerkancu: —Ch'isiña, caytaj ch'usaj lugar. Runacunata cachapullayña, estanciacunapi miqhunata ranticunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesustaj paycunaman nerkan: —Mana puripunancuchu; kancuna miqhunata koychis. ");
INSERT INTO qulNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Paycunataj nerkancu: —Mana nokaycupaj canchu, manachayri phichka t'antalla iscay challwallapiwan. ");
INSERT INTO qulNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesús paycunata nerkan: —Cayman apamuychis. ");
INSERT INTO qulNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Mandarkantaj runacunata pasto patapi tiyaranancupaj. Phichka t'antata iscay challwatawan maquinpi jap'iycuspa, janaj pachata khawarerkan. Diosman graciasta kospa, t'antacunata parterkan. Discipuloncunaman jaywarkan, paycunataj runacunaman jaywararkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tucuynincu miqhorkancu sajsanancucama, puchorkanraj canpas. Chaytataj okharerkancu chunca iscayniyoj canasta junt'ataraj. ");
INSERT INTO qulNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Miqhojcunaka phichka waranka jina kharicuna carkancu, warmicunata mana yupaspa ni wawacunatapas. ");
INSERT INTO qulNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Chaymanta Jesús discipuloncunata boteman yaycucherkan, ñaupajta pasanancupaj kocha chimpaman, chaycamataj payka runacunata cachapuchcarkan. ");
INSERT INTO qulNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Cacharpayaspataj, Jesús lomaman llojsiporkan sapan oracionta ruwaj. Ch'isiyaycojtintaj chaypi sapan cachcarkan. ");
INSERT INTO qulNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Chaycamataj botepi discipuloncuna kocha chaupitaña purichcarkancu. Oladacuna boteta bajtachcarkancu; paycuna contra wayrarkan. ");
INSERT INTO qulNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Pakariyamuytataj Jesús paycuna ladoman kocha patanta jamuchcarkan. ");
INSERT INTO qulNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Discipuloncuna kocha patanta jamojta ricuspa, mancharicorkancu. Wajach'acorkancutaj manchacuymanta: —¡Uj cucuchi! —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jesús paycunaman parlapayarkan, nispa: —¡Callpachacuychis! Noka cani, ama manchacuychischu. ");
INSERT INTO qulNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pedrotaj contestarkan: —Señor, kan canqui chayka, niway cay kocha patanta kanman jamunaypaj. ");
INSERT INTO qulNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesustaj nerkan: —Jamuy —nispa. Pedrotaj botemanta urakaspa, kocha patanta Jesusman puriyta kallarerkan. ");
INSERT INTO qulNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Sinchi wayrata reparaspa, mancharicorkan. Unuman ña chincaycapuchcaspataj, wajach'acuyta kallarerkan: —¡Señor, salvaway! —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Chaypacha Jesús maquinmanta jap'ispa, payta nerkan: —¡Pisi creeyniyoj! ¿Imaraycutaj iscayrayanqui? ");
INSERT INTO qulNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Boteman yaycupojtincu, wayra thaniporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Botepi cajcunataj Jesuspaj ñaupakenpi konkoriycuspa payta nerkancu: —¡Ciertopuni kan canqui Diospaj Churin! ");
INSERT INTO qulNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kocha chimpaman pasaspa, Genesaretman chayarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Chay lugarniyojcunataj Jesusta rejserkorkancu, tucuy chay lugarpitaj yachacorkan. Chayraycu tucuy onkoskacunata payman apamorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Jesustataj rogarkancu p'achanpaj cantollantapas onkoskacuna llanqharinancupaj. Tucuy llanqharejcunataj alliyachiska carkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Waquin fariseocuna leymanta yachachejcunapiwan Jerusalenmanta chayamuspa, Jesusman chimpaycuspa taporkancu: ");
INSERT INTO qulNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Imaraycutaj discipuloyquicuna ñaupaj abuelonchiscunapaj costumbrenta p'aquincu? ¿Imaraycutaj paycunari maquincuta mana mayllacuncuchu miqhunancupaj? ");
INSERT INTO qulNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesús contestarkan: —¿Imaraycutaj kancunapas Diospaj mandacuskanta p'aquinquichis costumbreyquichiscunata ruwanayquichisraycu? ");
INSERT INTO qulNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Dioska mandarkan: ‘Tata mamayquita respetanqui.’ Chaymanta: ‘Pichus tatanta chayri mamanta maldicejka, wañuchun.’ ");
INSERT INTO qulNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kancunataj ninquichis: ‘Pillapas tatanta chayri mamanta ninman: Mana yanapayta atiyquichu, imaraycuchus tucuy cajniyta Diosmanña kopuni, nispa chayka, ");
INSERT INTO qulNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","manaña obligaskachu yanapananpaj tatanta ni mamantapas.’ Ajinapi kancunaka Diospaj mandacuskanta p'aquinquichis, costumbreyquichista ruwanayquichisraycu. ");
INSERT INTO qulNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Iscay uya runacuna! Profeta Isaías kancunamanta allinta nerkan: ");
INSERT INTO qulNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Cay runacunaka simillancuwan honrawancu, sonkoncutaj carupi nokamanta cachcan. ");
INSERT INTO qulNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Imapajpas sirvinchu adorawaskancoka. Yachachiskancutaj runacunapaj mandacuskancunalla. ");
INSERT INTO qulNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jesús runacunata wajaspa nerkan: —Uyariychis, entendiychistaj. ");
INSERT INTO qulNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Siminta yaycoj runataka mana khellichanchu, ni ima miqhuy, manachayri siminmanta llojsej. ");
INSERT INTO qulNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Discipuloncuna Jesusman chimpaycuspa, taporkancu: —¿Yachanquichu fariseocuna niskayquita uyarispa phiñacuskancuta? ");
INSERT INTO qulNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesustaj contestarkan: —Mayken sach'apas Tataypaj mana tarpuskanka, saphinmantapacha t'iraska canka. ");
INSERT INTO qulNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Fariseocunata dejaychis. Paycunaka ñausacuna cancu, waj ñausacuna pusaj. Uj ñausa waj ñausata pusan chayka, iscaynincu jutc'uman urmayconkacu. ");
INSERT INTO qulNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pedrotaj Jesusman nerkan: —Cay niskayquita sut'inchawaycu. ");
INSERT INTO qulNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesustaj nerkan: —¿Manarajchu kancunapas entendinquichis? ");
INSERT INTO qulNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Manachu entendinquichis siminta yaycojka wijsaman yaycuskanta, chaymantataj llojsipuskanta? ");
INSERT INTO qulNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Simimanta llojsejcajtaj sonkomanta jamun; chaytaj khellichan. ");
INSERT INTO qulNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Runapaj sonkonmanta llojsejka caycuna: mana allin pensaycuna, runa wañuchiycuna, adulterio jucha ruwaycuna, mana casaraspa tiyaycuna, suwacuycuna, llullacuycuna, insultaycunapiwan. ");
INSERT INTO qulNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Caycunaka runata khellichan. Maqui mayllacuna costumbreta mana junt'aspa miqhoyka mana sonkota khellichanchu. ");
INSERT INTO qulNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesús chaymanta llojsispa, Tiroman Sidonmanpiwan puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Chaypi tiyaj uj cananea warmi kayllaycorkan wajach'acuspa: —¡Señor, rey Davidpaj Churin, qhuyapayaway! ¡Ususiy sajra espirituyoj! ");
INSERT INTO qulNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesustaj ni imata contestarkanchu. Discipuloncunataj payman chimpaycuspa, rogarkancu: —‘Puripuy’ niy chay warmita; imaraycuchus khepanchista jamun wajach'acuspa. ");
INSERT INTO qulNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesús warmita nerkan: —Dioska cachamuwan Israel llajtapi caj oveja jina chincaska runacunallaman. ");
INSERT INTO qulNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Chaywanpas warmeka Jesuspaj ñaupakenpi konkoriycuspa, rogarkan: —¡Señor, yanapariway! ");
INSERT INTO qulNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesustaj contestarkan: —Mana allinchu wawacunapaj t'antanta kechuspa alkocunaman konaka. ");
INSERT INTO qulNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Warmitaj nerkan: —Arí, Señor, alkocunapas wasiyojpaj mesanmanta urmakaj ñut'ucunataka miqhullancutaj. ");
INSERT INTO qulNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesús payman nerkan: —Warmi, creeyniyqui sinchi athun. Munaskayquiman jina ruwaska cachun. Chhicamantapacha ususenka alliyaporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús chaymanta llojsipuspa, Galilea kocha cantoman chayarkan. Uj lomaman llojsispataj tiyaycorkan. ");
INSERT INTO qulNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Achqha runacuna Jesusman tantacorkancu. Pusamorkancu cojocunata, ñausacunata, mana maquiyojcunata, jup'acunata, waj achqha onkoskacunatawan. Jesuspaj ñaupakenpi churarkancu, paytaj alliyacherkan. ");
INSERT INTO qulNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Runacunataj muspharaspa khawarkancu jup'acuna parlajta, mana maquiyojcuna alliyaskata, cojocuna purichcajta, ñausacunapas ricucojta. Israelpaj Diosnintataj alabayta kallarerkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesús discipuloncunata wajaspa nerkan: —Cay runacunata qhuyapayani. Quimsa p'unchayña caypi nokawan cancu; ni ima miqhunancu canchu. Manataj munanichu mana miqhuskata wasincuman cachapuyta, ñanpi yuyaynincu ama chincananpaj. ");
INSERT INTO qulNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Discipuloncunataj nerkancu: —¿Imaynatataj achqha runapaj miqhunata tarichuwan cay mana runayoj lugarpi? ");
INSERT INTO qulNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesús paycunata taporkan: —¿Jayc'a t'antayquichistaj can? Paycuna contestarkancu: —Kanchis t'anta, uj chhican challwitacunapiwan. ");
INSERT INTO qulNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jesustaj runacunata mandarkan pampapi tiyaranancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kanchis t'antata challwacunatawan maquinpi jap'ispa, Diosman graciasta korkan. Partiraspataj, discipuloncunaman korkan. Paycunataj runacunaman jaywararkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tucuynincu miqhorkancu sajsanancucama. Chaywanpas puchoj ñut'uncunata kanchis canastata junt'acherkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Miqhojcunataj tawa waranka kharicuna carkancu, mana yupaspa warmicunata ni wawacunatapas. ");
INSERT INTO qulNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jesús runacunata cachapuspa, boteman yaycupuspa, Magadán lugarman puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseocuna saduceocunapiwan Jesusman purerkancu, juchaman urmachiyta munaspa. Mañarkancutaj milagrota ruwananpaj, ricuchinanpaj Diosmantapuni jamuskanta. ");
INSERT INTO qulNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesustaj contestarkan: “Ch'isiña, janaj pacha puca cajtin, kancuna ninquichis: ‘Sumaj p'unchay canka pakarin’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Tutamanta janaj pacha puca cajtin phuyuwan tapaska cajtintaj, ninquichis: ‘Cunanka mana allin p'unchay canka’ nispa. Kancunaka janaj pachapi cajcunata khawaspa imayna p'unchay cananta yachanquichis chayri, ¿imaynatataj cay tiempopi señalcunata mana reparayta yachanquichischu? ");
INSERT INTO qulNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Cay sajra mana casucoj runacuna uj milagrota mañancu. Chaywanpas mana waj milagrota riconkacuchu, manachayri Jonaspaj milagrollanta.” Sakerpayaspataj, puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Discipuloncuna uj lado kocha cantoman pasaspa, t'antata apanancuta konkapuskacu. ");
INSERT INTO qulNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesús paycunata nerkan: —Khawariychis, fariseocunapaj saduceocunapajpiwan levadurancumanta cuidacuychis. ");
INSERT INTO qulNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Discipuloncunataj parlanacorkancu: —¡T'antata mana apamunchischu! —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús chayta reparaspa paycunata nerkan: —¿Imaraycutaj ninquichis t'antayquichis mana caskanta? Pisi creeyniyoj canquichis. ");
INSERT INTO qulNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Manarajchu entendinquichis, ni yuyapunquichischu phichka t'antamanta phichka waranka runacunaman miqhuchiskayta, jayc'a canastatataj okhariskayquichistapas? ");
INSERT INTO qulNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Nillatajchu yuyanquichis kanchis t'antamanta tawa waranka runacunaman miqhuchiskayta, jayc'a canastatataj okhariskayquichista? ");
INSERT INTO qulNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Imaynataj mana reparacunquichischu noka mana t'antamantachu parlachcaskayta? Fariseocunapaj saduceocunapajpiwan levadurancumanta cuidacuychis. ");
INSERT INTO qulNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Chhicaraj entenderkancu Jesuska mana t'anta levaduramantachu ‘cuidacuychis’ niskanta, manachayri fariseocunapaj saduceocunapajpiwan yachachicuynincumanta. ");
INSERT INTO qulNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Cesarea de Filipo llajtaman chayaspa, Jesús discipuloncunata taporkan: —Runacunari, ¿pi niwancutaj nokatari? ");
INSERT INTO qulNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Discipuloncunataj contestarkancu: —Waquincuna nincu ‘Juan Bautista’, waquincunataj ‘Elías’, waquincunataj ‘Jeremías chayri waj profeta.’ ");
INSERT INTO qulNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jesús paycunata tapullarkantaj: —Kancunari, ¿pi niwanquichistaj? ");
INSERT INTO qulNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Pedrotaj contestarkan: —Kanka Cristo canqui, causachcaj Diospaj Churin. ");
INSERT INTO qulNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesustaj payta nerkan: —Cusicuyniyoj canqui, Simón, Jonaspaj churin. Ni mayken runachu caytaka ricuchisunqui, manachayri janaj pachapi caj Tatay. ");
INSERT INTO qulNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nokataj niyqui, kan Pedro canqui. Cay kaka patapitaj iglesiayta ruwasaj. Infiernopaj atiyninpas mana atipankachu iglesiaytaka. ");
INSERT INTO qulNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Janaj pacha gobiernopaj llavencunata kanman koskayqui. Cay pachapi wataskayqui, janaj pachapi wataskallataj canka. Cay pachapi pascaraskayqui, janaj pachapi pascaraskallataj canka. ");
INSERT INTO qulNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Discipuloncunatataj mandarkan ama ni piman willanancupaj pay Cristo caskanta. ");
INSERT INTO qulNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Chaymantapacha Jesús discipuloncunaman sut'inchayta kallarerkan pay Jerusalenman purinanta, llajtapaj jefencunataj, sacerdotecunapaj jefencuna, leymanta yachachejcunapiwan sinchita ñac'arichinancuta, wañuchinancutawan, quimsa p'unchaymantataj causaripunanta. ");
INSERT INTO qulNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pedrotaj Jesusta wajnejman pusarkospa, parlapayayta kallarerkan nispa: —¡Señor, amapuni Dios munachunchu cay pasanasunquita! ");
INSERT INTO qulNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesustaj cutirispa Pedrota nerkan: —¡Supay Satanás, ithiriy nokamanta! Urmachinaman churawanqui. Kan mana pensanquichu Diospaj pensaskanta jina. Kanka runacuna jinalla pensanqui. ");
INSERT INTO qulNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Chaymanta Jesuska discipuloncunaman nerkan: —Maykenchus nokawan puriyta munan chayka, paycama konkacuchun. Sufrispapas nokawan purichun wañunancama. ");
INSERT INTO qulNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Causaynillanta salvayta munajka chincachenka; nokaraycu causayninta chincachejka, salvaconka. ");
INSERT INTO qulNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Imapajtaj runaman sirvenka cay pachapi khapajyaskan, alman mana salvaska cajtinri? ¿Runari jayc'atataj paganman almanta salvananpaj? ");
INSERT INTO qulNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tataj Churenka jamonka Tatanpaj sumaj glorianwan angelnincunapiwan; chhica sapa ujman ruwaskancuman jina koponka. ");
INSERT INTO qulNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Segurayquichis, waquin caypi cajcunamanta mana wañonkacuchu Tataj Churinta gobernaj jamojta ricunancucama. ");
INSERT INTO qulNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Sojta p'unchaymanta Jesús Pedrota, Santiagota, Santiagopaj wauken Juantawan pusaricorkan. Paycunawantaj athun lomaman puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Chaypi paycunapaj ñaupakenpi Jesús waj jinaman tucorkan, uyan inti c'anchayman jina, p'achantaj sinchi yuraj c'anchay jina. ");
INSERT INTO qulNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Moisés Eliaspiwan riqhurerkancu Jesuswan parlachcaj. ");
INSERT INTO qulNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pedrotaj Jesusta nerkan: —Señor, ¡allin caypi cachcaycu! Munanqui chayka, quimsa ramarata ruwasaj: ujta kanpaj, ujta Moisespaj, ujtataj Eliaspaj. ");
INSERT INTO qulNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Parlachcajtinraj, c'anchachcaj phuyu tapaycuspa llanthuycorkan. Phuyumantataj Dios parlamorkan, nerkantaj: ‘Caymi munaska Chureyka, ajllaskaytaj. Payta uyariychis.’ ");
INSERT INTO qulNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Cayta uyarispa, discipuloncuna manchariska pampacama c'uñuycorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesús paycunaman chimpaycorkan. Llanqhaycuspataj nerkan: —Sayariychis, ama mancharicuychischu. ");
INSERT INTO qulNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Khawarispataj Jesusllata ricorkancu, manaña ni pitapas. ");
INSERT INTO qulNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Lomamanta urakamuchcaspa, Jesús mandarkan: —Cay ricuskayquichista ama ni pimanpas willanquichischu, Tataj Churin wañuskamanta causarinancama. ");
INSERT INTO qulNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Discipuloncunataj Jesusta taporkancu: —¿Imaraycutaj leymanta yachachejcuna nincu Eliasraj ñaupajta jamunantari? ");
INSERT INTO qulNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesús contestarkan: —Cierto Elías ñaupajta jamunanka, paytaj tucuy imata jallch'anka. ");
INSERT INTO qulNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nokataj niyquichis, Eliaska jamunña. Paycunataj mana rejsispa, munaynincuman jina payta ñac'aricherkancu. Ajinallatataj Tataj Churintapas ñac'arichenkacu. ");
INSERT INTO qulNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Chhicaraj discipuloncunaka reparacorkancu Jesús Juan Bautistamanta parlaskanta. ");
INSERT INTO qulNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Runacuna cachcaskancuman chayajtincu, uj runa Jesusman chimpaycorkan. Ñaupakenpi konkoriycuspataj nerkan: ");
INSERT INTO qulNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Señor, churiyta qhuyapayaripuway. T'ucu sinchita ñac'arichichcan. Achqha cuti ninaman unuman urmaycun. ");
INSERT INTO qulNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Discipuloyquicunaman pusarkani, manataj alliyachiyta aterkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesustaj contestarkan: —¡Ay, sajra mana creeyniyoj runacuna! ¿Jayc'ajcamataj kancunawan cachcasajri? ¿Jayc'ajcamataj aguantaskayquichisri? Chay waynata cayman pusamuychis. ");
INSERT INTO qulNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesús sajra espirituta c'amejtin, chay waynamanta llojsiporkan. Chhicamantapacha alliyaporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Discipuloncunataj Jesusman chimpaycuspa, sapallanta taporkancu: —¿Imaraycutaj nokaycuri sajra espirituta mana katerkoyta aterkaycuchu? ");
INSERT INTO qulNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesús paycunaman nerkan: —Imaraycuchus kancunaka pisi creeyniyoj canquichis. Segurayquichis, creeyniyquichischus uj juch'uy mostaza muju jinallapas canman chayka, cay lomata: ‘Ithiriy chaymanta, puriytaj kochaman’ nejtiyquichis, lomaka purinman. Kancunapajka mana imapas mana aticoj canmanchu. ");
INSERT INTO qulNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Chaywanpas cay jina sajra espiritutaka imawanpas katerkoyta atiwajchischu, manachayri oracionwan ayunopiwan. ");
INSERT INTO qulNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jesús discipuloncunawan cusca Galileapi purichcaspa, paycunaman nerkan: —Tataj Churenka runacunaman entregaska canka. ");
INSERT INTO qulNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Wañuchenkacu, quimsa p'unchaymantataj causarimponka. Discipuloncunataj chayta uyarispa, sinchita llaquicorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesús discipuloncunapiwan Capernaum llajtaman chayajtincu, templopaj impuesto cobrajcuna Pedroman purerkancu, taporkancutaj: —¿Manachu yachachejniyquichis templopaj impuestota pagan? ");
INSERT INTO qulNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedrotaj contestarkan: —Arí, pagan. Pedro wasiman yaycojtintaj, Jesús payman nerkanpacha: —Kanri, ¿ima ninquitaj, Simón? Cay pachapi gobernajcuna ¿pimantataj impuestota cobrancu? ¿Quiquin nacionniyoj caj familiacunamantachu, icha waj llajtayojcunamantachu? ");
INSERT INTO qulNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedrotaj contestarkan: —Waj llajtayojcunamanta —nispa. Jesustaj nerkan: —Arí, jina cajtin, quiquin nacionniyoj cajtenka, mana pagananchu. ");
INSERT INTO qulNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Chaywanpas ama rimanancupaj, kochaman anzuelaj puriy. Ñaupajcaj orkhoskayqui challwapaj siminpi uj kolketa tarinqui. Chaylla munaconka nokamanta kanmantawan impuesto paganapaj. Apaspa, pagamuy. ");
INSERT INTO qulNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Chay cutillataj discipuloncuna Jesusman chimpaycuspa, taporkancu: —¿Pitaj Diospaj gobiernonpi curajri? ");
INSERT INTO qulNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesustaj uj wawata wajaspa, paycunapaj chaupincupi sayaycuchispa, ");
INSERT INTO qulNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","nerkan: —Segurayquichis, kancunachus mana humilde sonkoyojman tucuwajchis wawacuna jina chayka, Diospaj gobiernonmanka mana yaycuwajchischu. ");
INSERT INTO qulNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Pillapas cay wawa jina humilde sonkoyojman tucojka, chaymi Diospaj gobiernonpeka astawan curaj canka. ");
INSERT INTO qulNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Pipas nokapaj sutiypi cay wawata jina jap'ekajka, nokata jap'ekawan. ");
INSERT INTO qulNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Maykellanpas nokapi creej humilde juch'uycitocunamanta ujninta juchaman urmachejpajka, allin canman paypaj cuncanman athun cutana rumita wataycuspa, athun kochaman wijch'uycunancoka. ");
INSERT INTO qulNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Ay, cay pachapi achqha juchaman urmachejcuna callankacupuni! Chaywanpas, ¡ay pobre runa wajcunata juchaman urmachejka! ");
INSERT INTO qulNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Chayraycu maquiyquichus chaquiyquichus juchaman urmachisunqui chayka, p'atakaspa caruman wijch'upuy. Allinrajmi salvaska causanayqueka uj maquiyoj chayri uj chaquiyojllapas, iscaynin maquiyoj iscaynin chaquiyoj mana wañoj nina infiernoman wijch'uska canayquitapachaka. ");
INSERT INTO qulNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ñawiyquichus juchaman urmachisunqui chayka, orkhospa caruman wijch'upuy. Allinrajmi salvaska causanayqueka uj ñawiyojllapas, iscaynin ñawiyoj mana wañoj nina infiernoman wijch'uska canayquitapachaka. ");
INSERT INTO qulNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ama desprecianquichu maykennincutapas nokapi creej juch'uycunata. Niyquichis, janaj pachapi paycunapaj angelnincuna Tataypaj ñaupakenpipuni cachcancu. ");
INSERT INTO qulNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Tataj Churenka chincaskacunata salvaj jamun. ");
INSERT INTO qulNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“¿Imaynataj yuyacusunquichis? Uj runa pachaj ovejayoj caspa, ujnin ovejan chincajtin, ¿manachu iskon chunca iskonniyojta lomapi sakerpayaspa, chincaska ovejata masc'aj purinman? ");
INSERT INTO qulNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Segurayquichis, chincaska ovejanta tarispaka astawan sinchitaraj cusicunman, iskon chunca iskonniyoj mana chincaska ovejancunamanta cusicuytapachaka. ");
INSERT INTO qulNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ajinallatataj janaj pachapi cachcaj Tatayquichiska mana munanchu ni maykellanpas cay juch'uycunamanta chincananta. ");
INSERT INTO qulNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Waukeyquichus kan contra juchallicun chayka, sapanpi payman parlapayay juchanta reparachispa. Chay niskayquita casuconka chayka, waukeyquiwan allinpiña canqui. ");
INSERT INTO qulNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mana casusunqui chayka, ujtapas chayri iscayojtapas wajay, iscay chayri quimsa testigopas juchanta sut'inchanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nillataj paycunatapas casojtinri, tantaska creyentecunaman willay. Ni Diospaj tantaskantapas casojtenka, mana Diospi creej runa jina cachun, uj juchasapa runa jina. ");
INSERT INTO qulNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Segurayquichis, cay pachapi wataskayquichis janaj pachapi wataskallataj canka. Cay pachapi pascaraskayquichistaj janaj pachapi pascaraskallataj canka. ");
INSERT INTO qulNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Cayta niyquichis, cay pachapi iscayoj kancunamanta uj sonkolla imatapas oracionpi mañacunquichis chayka, janaj pachapi cachcaj Tatay kancunapaj ruwanka. ");
INSERT INTO qulNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mayllapipas sutiypi iscayoj chayri quimsayoj tantacuncu chayka, chay chaupincupi noka cachcani. ");
INSERT INTO qulNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pedrotaj Jesusta taporkan: —Señor, noka contra juchallicojta, ¿jayc'a cutitataj perdonasaj? ¿Kanchis cutitachu? ");
INSERT INTO qulNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesustaj contestarkan: —Mana kanchis cutillata niyquichu, manachayri kanchis chunca kanchis cuticama. ");
INSERT INTO qulNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Janaj pacha Diospaj gobiernonka rijch'acun uj gobernaj llanc'ajnincunamanta cuenta mañajman. ");
INSERT INTO qulNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Cuentata mañayta kallarichcajtin, ujninta pusamorkancu achqha millón manuta. ");
INSERT INTO qulNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Chay llanc'ajnin mana imawan pagayta atejtintaj, gobernajka mandarkan pay warminwan, wawancunawan, tucuy cajnincunapiwan cusca vendiska cananta, jinapi pagaska cananpaj. ");
INSERT INTO qulNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Llanc'ajnintaj gobernajpaj ñaupakenpi konkoriycuspa, payta rogarkan: ‘Señor, pacienciariway, lliujta pagapullaskayqui.’ ");
INSERT INTO qulNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Gobernajtaj payta qhuyapayaspa, perdonaporkan, libretataj cachariporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Chaymanta llojsipuspataj, chay llanc'ajka waj llanc'ajmasinwan tuparkan, uj chhican manu payman carkan. Cuncanmanta jap'ispa yaka siperkan nispa: ‘¡Manuchacuwaskayquita pagaway!’ ");
INSERT INTO qulNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Llanc'ajmasintaj paypaj ñaupakenpi konkoriycuspa, rogarkan: ‘¡Pacienciariway, lliujta pagapullaskayqui!’ ");
INSERT INTO qulNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Paytaj mana munarkanchu, astawanpas carcelman wisk'aycucherkan manunta paganancama. ");
INSERT INTO qulNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Waj llanc'ajmasincunataj chayta ricuspa, sinchita llaquicorkancu. Purispataj, gobernajman willamorkancu tucuy ima pasaskanta. ");
INSERT INTO qulNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Gobernajtaj wajachimuspa payta nerkan: ‘¡Sajra llanc'aj! Nokaka rogawaskayquiraycu tucuy manuchacuwaskayquita perdonarkayqui. ");
INSERT INTO qulNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kanpas llanc'ajmasiyquita qhuyapayanayqui carkan, imaynatachus noka qhuyapayayqui jinata.’ ");
INSERT INTO qulNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Gobernajka phiñacuspa, mandarkan castiganancupaj tucuy manuchacuskanta paganancama.” ");
INSERT INTO qulNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jesús nillarkantaj: —Kancunawanpas jinallatataj ruwanka janaj pacha Tatayka, sapa uj kancuna tucuy sonkowan hermanoyquichista mana perdonajtiyquichiska. ");
INSERT INTO qulNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesús caycunata nispa, Galileamanta Judea provinciaman puriporkan. Inti llojsimuy lado Jordán mayuman chayaporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Achqha runacuna Jesuspaj khepanta jamorkancu. Chaypitaj onkoskacunata alliyacherkan. ");
INSERT INTO qulNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Waquin fariseocuna Jesusman kayllaycorkancu. Juchaman pantachinancupaj taporkancu: —¿Leyman jina imallamantapas casaraska runa esposanmanta divorciacuyta aticunmanchu? ");
INSERT INTO qulNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesús paycunata contestarkan: —¿Manachu Diospaj palabranpi leenquichis cay pachapaj kallariyninpi Dios kharita warmitawan ruwaskanta? ");
INSERT INTO qulNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Diostaj nerkan: ‘Chayraycu khareka tata mamanta sakeponka esposanwan juntacunanpaj, iscaynincutaj uj runa jinalla cankacu.’ ");
INSERT INTO qulNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ajinaka manaña iscaychu cancu, manachayri ujlla. Chayraycu Diospaj juntaskanta runaka ama wijch'uchichunchu. ");
INSERT INTO qulNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Paycunataj taporkancu: —¿Imaraycutaj Moisés mandarkan esposaman divorcio papelta kospa cacharipunata? ");
INSERT INTO qulNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesustaj nerkan: —Khoru sonkoyoj caskayquichisraycu, Moiseska esposamanta divorciacunanta permiterkan. Kallariypeka mana jinachu carkan. ");
INSERT INTO qulNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nokataj niyquichis, esposan mana adulterio juchata ruwachcajtin, pillapas esposanmanta divorciacuspa waj warmiwan casaracun chayka, adulterio juchata ruwan. ");
INSERT INTO qulNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Discipuloncunataj nerkancu: —Casaraska runa warminwan chay jina canan cajtenka, mana convininchu casaracunaka. ");
INSERT INTO qulNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesustaj contestarkan: —Mana tucuychu entendincuman caytaka, manachayri picunatachus Dios entendiyta yanapan chaycunalla. ");
INSERT INTO qulNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Mana tucuy kharichu casaracuyta atin. Imaraycuchus ujcunaka mana casaracunapaj jinachu nacincu, ujcunatataj runacuna capancu mana casaracunancupaj, ujcunataj Diospaj gobiernonpi sirvinancuraycu mana casaracuncuchu. Jina cayta atejka, jina cachun. ");
INSERT INTO qulNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Wawacunata Jesusman pusamorkancu, maquincunata paycuna pataman churaspa oración ruwananpaj. Discipuloncunataj wawa apamojcunata c'amiyta kallarerkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesús nerkan: —Ama jarc'aychischu wawacuna nokaman jamunanta, imaraycuchus Diospaj gobiernonka wawa jina cajcunapaj. ");
INSERT INTO qulNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Wawacuna pataman maquincunata churaspa, bendicerkan. Chay lugarmantataj puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Uj wayna Jesusman purispa, taporkan: —Yachachej, ¿ima allintataj ruwanay wiñay causayniyoj canaypaj? ");
INSERT INTO qulNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesustaj nerkan: —¿Imaraycutaj allincajmanta tapuwanqui? Ujlla allenka, chaytaj Dioslla. Salvación causayman yaycuyta munanqui chayka, Diospaj mandaskancunata casucuy. ");
INSERT INTO qulNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Paytaj nerkan: —¿Maykencunata? Jesús payta nerkan: —‘Ama wañuchinquichu, adulterio juchata ama ruwanquichu, ama suwacunquichu, ama pimantapas llullata ninquichu. ");
INSERT INTO qulNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Tata mamayquita respetay, runamasiyquitataj munacuy kan quiquiyquita jina’. ");
INSERT INTO qulNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Waynataj nerkan: —Tucuy chaycunata junt'aniña. ¿Imarajtaj faltawan? ");
INSERT INTO qulNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesustaj payman nerkan: —Cabal mana juchachana jina runa cayta munaspaka, puriy, cajniyquita vendimuy, chay kolketataj pobrecunaman kopuy. Ajinamanta janaj pachapi khapaj cayniyqueka canka. Chhicamanta jamuspa, nokawan puriy. ");
INSERT INTO qulNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Waynataj chayta uyarispa, llaquiska puriporkan, imaraycuchus payka sinchi khapaj carkan. ");
INSERT INTO qulNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jesús discipuloncunaman nerkan: —Segurayquichis, khapajcunaka ñac'ayta yayconkacu Diospaj gobiernonmanka. ");
INSERT INTO qulNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ujtawan niyquichis, camelloraj agujapaj ninrinta astawan facilta pasanman, uj khapaj runa Diospaj gobiernonman yaycunanmantaka. ");
INSERT INTO qulNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Cayta uyarispa, discipuloncunaka astawanraj musphararkancu, nerkancutaj: —¿Chhicari pillataj salvaska cayta atinman? ");
INSERT INTO qulNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús paycunata khawarispa, contestarkan: —Runapaj mana aticojka, Diospaj aticun. ");
INSERT INTO qulNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pedrotaj nerkan: —Nokaycu tucuy imaycuta sakempuycu kanwan purinaycupaj. ¿Imatataj jap'ekasajcuri? ");
INSERT INTO qulNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesustaj paycunaman contestarkan: —Segurayquichis, tucuy imapas mosojyachiska canan tiempo chayamojtin, Tataj Churin sumaj glorioso trononpi tiyaycojtin, kancuna, nokawan purejcuna, chunca iscayniyoj tronocunapi tiyaycullanquichistaj, chunca iscayniyoj Israelpaj miraynincunata juzganayquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Tucuy runa nokaraycu wasincuta, waukencunata, panancunata, tatanta, mamanta, wawancunata, jallp'ancutapas sakejcunaka pachaj cuti yapaskata wiñay causaytawan jap'ekankacu. ");
INSERT INTO qulNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Cunan ñaupajpi cajcunamantaka, Diospaj gobiernonpi achqhayoj khepapi cankacu. Cunan khepapi cajcunamantataj, achqhayoj ñaupajpi cankacu. ");
INSERT INTO qulNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Diospaj gobiernonka rijch'acun uj haciendapaj patronninman. Tutamanta llojserkan uva chajranpi llanc'ajcunata minc'aj. ");
INSERT INTO qulNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Minc'askan llanc'ajcunawan arreglarkan sapa p'unchaymanta uj kolketa pagananpaj. Chaymantataj uva chajranman paycunata cacharkan llanc'anancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Iskon horata jina ujtawan llojsispa, plazapi mana ima ruwanayoj runacunata ricorkan. ");
INSERT INTO qulNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Paycunatataj nerkan: ‘Kancunapas puriychis, uva chajraypi llanc'amuychis. Cabalta pagaskayquichis.’ Paycunataj purerkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Cusca p'unchayta ujtawan llojserkan llanc'ajcunata masc'aj. Quimsa hora tardetaña llanc'ajcunata minc'allarkantaj. ");
INSERT INTO qulNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Phichka hora tardetapas ujtawan plazaman llojserkan. Chaypi taripallarkantaj mana ima ruwanayoj runacunata. Taporkantaj: ‘¿Imaraycutaj kancuna caypi cachcanquichis p'unchay entero mana llanc'aspa?’ ");
INSERT INTO qulNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Contestarkancu: ‘Mana pipas minc'awancuchu.’ Patrontaj paycunaman nerkan: ‘Kancunapas uva chajrayman llanc'aj puriychis.’ ");
INSERT INTO qulNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ch'isiyaycuytaña, patronka llanc'achej encargadoman nerkan: ‘Llanc'ajcunata wajay. Pagarapuy khepa yaycojcunamanta kallarispa, ñaupajta yaycojcunacama.’ ");
INSERT INTO qulNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Inti yaycuchcajtinña llanc'aj yaycojcuna jamuspa, sapa uj jap'ekacorkancu uj p'unchay pagota. ");
INSERT INTO qulNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Chaymanta ñaupajta llanc'aj yaycojcunaman tupajtin, astawan jap'ekanancuta pensarkancu. Sapa uj jap'ekallarkancutaj uj p'unchay pagollata. ");
INSERT INTO qulNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pagota jap'ekaytawantaj, patrón contra rimarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Nerkancutaj: ‘Caycunaka ch'isillataña chayamuncu, llanc'ancutaj uj horallataña. Kantaj nokaycuman jina caskallantataj pagaranqui. Nokaycoka p'unchay ch'isiyajta ruphayta aguantaspa llanc'aycu.’ ");
INSERT INTO qulNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Patrontaj ujnin paycunaman contestarkan: ‘Amigo, mana ni ima engañotachu ruwachcayqui. ¿Manachu arreglaskanchisman jina pagapuyqui? ");
INSERT INTO qulNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Jap'icuy pagoyquita, puripuytaj. Khepata yaycoj llanc'ajman kanman jinallatataj pagayta munani. ");
INSERT INTO qulNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Derechoy can, kolkeywan ima munaskay ruwanaypaj. Icha, ¿sumaj caskaywanchu envidiacunqui?’ ");
INSERT INTO qulNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Ajinaka khepapi cajcuna, ñaupajpi cankacu. Cunan ñaupajpi cajcunataj, khepapi cankacu. ");
INSERT INTO qulNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesús Jerusalenman purichcaspa, chunca iscayniyoj discipuloncunata uj ladoman pusaspa, nerkan: ");
INSERT INTO qulNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Ricunquichis jina, cunanka Jerusalenman purichcanchis. Chaypi Tataj Churin sacerdotecunapaj jefencunaman leymanta yachachejcunamanpiwan entregaska canka, wañuchinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Waj llajtayojcunaman entregankacu burlacunancupaj, c'upanancupaj, chacataycunancupaj. Quimsa p'unchaymantataj causarimponka. ");
INSERT INTO qulNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zebedeopaj warmin churincunawan Jesusman chimpaycuspa, ñaupakenpi konkoriycorkan uj favorta mañacunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesustaj taporkan: —¿Imatataj munanqui? Paytaj nerkan: —Niy ari, gobiernoyquipi cay iscay churiy ujnin paña ladoyquipi, ujnintaj llok'e ladoyquipi tiyaycunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesús contestarkan: —Kancuna mana yachanquichischu imata mañaskayquichista. ¿Ñac'ariyta atiwajchischu ñac'arinay cachcan chayta c'allcu ujyanata jina? Paycunataj nerkancu: —Atisajcu. ");
INSERT INTO qulNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesús contestarkan: —Kancuna chay c'allcu ujyanata ujyanquichis, chaywanpas paña ladoypi llok'e ladoypiwan tiyaycunata konaka mana tupawanchu, manachayri picunapajchus Tatay waquichin chaycunallaman koska canka. ");
INSERT INTO qulNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Chayta uyarispa, waj chunca discipulocuna chay iscay waukecuna contra phiñacorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesús wajaspa paycunata nerkan: —Yachanquichis jina, nacioncunapi jefecunaka gobernancu mana qhuyapayacuspa. Athun autoridadcunapas munaskancuta runacunawan ruwancu. ");
INSERT INTO qulNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kancuna uqhupeka mana jina cananchu. Manachayka, kancuna uqhupi athun cay munajka tucuyta sirvej canan. ");
INSERT INTO qulNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ajinallatataj maykellanpas kancunamanta ñaupajpi cay munajka sirviente canan. ");
INSERT INTO qulNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ajinallatataj Tataj Churenka mana sirvichicojchu jamun, manachayri sirvej, preciota jina causayninta koj, achqha runa salvaska cananpaj. ");
INSERT INTO qulNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Paycuna Jericó llajtamanta llojsejtincu, achqha runacuna Jesusta katerkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Iscay ñausacuna ñan patapi tiyachcarkancu. Jesús pasachcaskanta uyarispa, wajach'acorkancu: —¡Señor, Davidpaj Churin, qhuyapayawaycu! ");
INSERT INTO qulNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Runacunataj c'amerkancu jup'allanancupaj. Paycunarí astawan wajach'acorkancu: —¡Señor, Davidpaj Churin, qhuyapayawaycu! ");
INSERT INTO qulNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesustaj sayaycuspa, ñausacunata wajarkan. Taporkantaj: —¿Imatataj ruwanayta munanquichis? ");
INSERT INTO qulNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Paycunataj contestarkancu: —Señor, munaycu ñawiycu ricucunanta. ");
INSERT INTO qulNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesús paycunata qhuyapayaspa, ñawincuta llanqhaycorkan. Chhicapacha ñausacunaka ricucaporkancu, Jesuswantaj puriporkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jerusalenman kayllachcajtincuña, Betfagé juch'uy llajtaman Olivos loma chimpaman chayaspa, Jesús iscay discipulonta cacharkan, ");
INSERT INTO qulNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","nerkantaj: —Chimpa llajtaman puriychis. Chayman yaycuspataj, asnota wataskata tarinquichis, uñantawan. Chay asnota pascaraspa, aysamuychis. ");
INSERT INTO qulNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Pipas imata tapusunquichis chayka, niychis: ‘Señor necesitan. Chaymanta cutichipusunqui’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Cayka pasarkan profetapaj cay jinata escribiskan junt'acunanpaj: ");
INSERT INTO qulNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Niychis Sión llajtapi caj runacunaman: ‘Khawariy, Reyniyquichis kancunaman jamun humilde sonkoyoj, asno sillapi, cargana asnopaj uñanpi.’ ” ");
INSERT INTO qulNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Discipulocunataj purispa, Jesuspaj mandacuskanman jina ruwarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","China asnota uñantinta aparkancu. P'achancuta caronaycojtincu, Jesús sillaycorkan. ");
INSERT INTO qulNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Achqha runa carkan. Waquinnincu p'achancuta ñanpi mast'arkancu, waquintaj palma raphicunata p'atamuspa mast'arkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Khepanta ñaupakenta purejcuna wajach'acorkancu: —¡Alabaska cachun tatanchis rey Davidpaj Churin! ¡Bendiciska cachun Señorpaj sutinpi jamoj! ¡Alabaska cachun janaj pachapi cachcaj Dios! ");
INSERT INTO qulNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesús Jerusalenman yaycojtin, tucuy runacuna pitucorkancu. Achqhayojtaj tapucorkancu: —¿Pitaj cayri? —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Runacunataj contestarkancu: —Diospaj profetan Jesús, Galileapi caj Nazaretmanta. ");
INSERT INTO qulNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesús temploman yaycuspa, tucuy vendejcunata rantejcunatawan jawaman wijch'orkorkan. Kolke cambiajcunapaj mesancuta paloma vendejcunapaj sillancunatawan tijrararkan. ");
INSERT INTO qulNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Paycunatataj nerkan: —Escriturapi nin: ‘Waseyka oración ruwana wasimi.’ Kancunataj suwacunapaj jutc'unta ruwapunquichis. ");
INSERT INTO qulNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jesús templopi cachcajtintaj, ñausacuna cojocunapiwan chimpaycorkancu, paytaj alliyacherkan. ");
INSERT INTO qulNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Sacerdotecunapaj jefencuna leymanta yachachejcunapiwan Jesuspaj milagrocuna ruwaskanta ricorkancu. Templopitaj wawacuna: “¡Alabaska cachun rey Davidpaj Churin!” nispa wajach'acuskancuta uyarispa, phiñaricorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jesusman nerkancu: —¿Uyarinquichu caycuna imatachus nichcaskancuta? Jesustaj paycunaman contestarkan: —Arí, uyarini. ¿Manachu kancuna Escriturapi leenquichis caymanta parlaskanta? Nin: ‘Juch'uycunapaj, ñuñuchcaj wawacunapajpiwan taquiskancuwan alabachicunqui.’ ");
INSERT INTO qulNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Paycunata sakerpayaspataj, Betaniaman puriporkan korpachacoj. ");
INSERT INTO qulNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","K'ayantin tutamanta Jerusalenman cutispa, Jesús yarekachicorkan. ");
INSERT INTO qulNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ñan patapi uj higo sach'ata ricuspa, chimpaycorkan. Chay higotaj mana uriyoj carkan, raphicunayojlla. Higo sach'atataj nerkan: —Ama jayc'ajpas urinquiñachu. Higo sach'ataj chhicapacha ch'aquiporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Discipuloncunataj chayta ricuspa, musphararkancu. Taporkancutaj Jesusta: —¿Imaraycutaj higo sach'a chhicapacha ch'aquerkapun? ");
INSERT INTO qulNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesustaj contestarkan: —Segurayquichis, creeyniyquichis canman, amataj iscayrayawajchischu chayka, mana cay higo sach'awan ruwaskallaytachu ruwawajchis, manachayri cay lomata ‘Chaymanta ithiriy, kochaman chhokaycucuy’ nejtiyquichis, ajina ruwacunman. ");
INSERT INTO qulNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kancuna creeywan canquichis chayka, tucuy imata oracionpi mañacuskayquichistaka jap'ekanquichis. ");
INSERT INTO qulNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesús temploman yaycorkan. Chaypi cachcajtintaj, sacerdotecunapaj jefencuna llajtapaj jefencunapiwan chimpaycuspa, taporkancu: —¿Ima autoridadwantaj caycunata ruwanqui? ¿Pitaj autorizasunqui? ");
INSERT INTO qulNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesustaj contestarkan: —Nokapas ujta tapullaskayquichistaj. Contestawanquichis chayka, nokapas nillaskayquichistaj ima autoridadwanchus cayta ruwaskayta. ");
INSERT INTO qulNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Pitaj Juanta bautizananpaj cachamorkan, Dioschu icha runacunachu? Paycunapurataj ninacorkancu: “Sichus ‘Dios cachamorkan’ nisunchis chayka, payka niwasunchis: ‘¿Imaraycutaj payta mana creerkanquichischu?’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Manallataj niyta atinchischu runacuna payta cachamuskanta, imaraycuchus runacunata manchacunchis. Paycunaka creencu Dios Juanta cachamuskanta Diosmanta parlajta.” ");
INSERT INTO qulNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ajinapitaj Jesusman contestarkancu: —Mana yachaycuchu —nispa. Chhicari Jesús paycunata contestarkan: —Nillataj nokapas willaskayquichischu ima autoridadwanchus caycunata ruwaskayta. ");
INSERT INTO qulNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús paycunata taporkan: —¿Ima ninquichistaj cay ejemplomanta? Uj runa iscay churiyoj carkan. Ujninmantaj nerkan: ‘Churíy, cunan uva chajrayman llanc'aj puriy.’ ");
INSERT INTO qulNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Churintaj contestarkan: ‘Mana puriyta munanichu.’ ‘Mana’ niskanmanta sonkonta nanachicuspa, llanc'aj puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tatataj ujnin churinman quiquillantataj nerkan. Churintaj contestarkan: ‘Arí, señor, noka purisaj.’ Nitaj purerkanchu. ");
INSERT INTO qulNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Maykentaj cay iscayninmanta tatanpaj munaskanta ruwan? Paycunataj contestarkancu: —Ñaupajcaj —nispa. Jesustaj nerkan: —Segurayquichis, Romapaj impuesto cobrajcuna, millay warmicunapiwan Diospaj gobiernonman ñaupajta yayconkacu kancunamanta nejtenka. ");
INSERT INTO qulNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juan Bautista jamorkan imayna canayquichista yachachinasunquichispaj; kancunataj mana creerkanquichischu. Astawanpas impuesto cobrajcuna millay warmicunapiwan, arí, creerkancu. Kancunataj tucuy cayta ricuspapas, mana creerkanquichischu. Nitaj juchayquichiscunata sakerkanquichischu. ");
INSERT INTO qulNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Waj ejemplota uyariychis: Haciendayoj runa uva chajrata tarpuspa, muyuntinta wisk'aycorkan. Vino ruwana lugarta waquicherkan. Uj torreta ruwarkan chay patamanta khawanapaj. Llanc'ajcunaman arrendaycuspataj, caruman puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Uva pallana tiempotaj uywaskancunata cachamorkan llanc'ajcunamanta payman tupaskanta apachinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Chaywanpas llanc'ajcunaka cachamuskacunata jap'erkancu, waquinninta c'uparkancu, ujcunata wañucherkancu, ujcunatataj rumiwan chhokarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Chajrayoj patrontaj astawan uywaskancunata cachamorkan ñaupajmanta nejtenka. Llanc'ajcunari tucuynincuta jinallatataj ruwarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Khepataña churinta cachamorkan, pensaspa: ‘Churiycajtaka respetankacupunichari’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Llanc'ajcunataj churinta jamojta ricuspa, rimanacorkancu: ‘Cayka herenciata jap'enka. Wañuchisunchis, chajranwantaj quedacapusunchis' nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Jap'ispa, uva chajra jallp'amanta wijch'uspa, wañuchiporkancu.” ");
INSERT INTO qulNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Cunanri, uva chajrayoj cutimuspa, ¿imanankataj chay llanc'ajcunata? ");
INSERT INTO qulNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Contestarkancu: —Chay sajra llanc'ajcunataka mana qhuyapayaspa wañurachenka. Chajrantataj waj llanc'ajcunaman konka, pallana tiempo chayamojtin payman tupaskanta kopunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesustaj nerkan: —¿Manachu jayc'ajpas Escriturata leerkanquichis? Ajinata nin: ‘Wasi ruwajcunapaj mana casuraskancu rumeka wasipaj astawan importante tucun. Caytataj Señor ruwan, muspharananchispaj jina.’ ");
INSERT INTO qulNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Chayraycu niyquichis, Dios gobiernonta kechusunquichis, paypaj munayninta ruwajcunamantaj koponka, uvata pallaspa kopojcunaman jina. ");
INSERT INTO qulNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Rumimantataj niyquichis, pillapas chay rumi pataman urmajka, ñut'uska canka; rumichus pipaj patamanpas urmanka chayka, ñut'uta ruwanka. ");
INSERT INTO qulNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Sacerdotecunapaj jefencunaka fariseocunapiwan Jesuspaj chay ejemplo cuentaskanta uyarispa, reparacorkancu paycunamanta parlaskanta. ");
INSERT INTO qulNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Chhicataj Jesusta jap'iyta munarkancu. Chaywanpas runacunata manchacorkancu, imaraycuchus runacunaka creerkancu Jesús Diosmanta parlaskanta. ");
INSERT INTO qulNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús ejemplocunawan ujtawan parlayta kallariycullarkantaj. Nerkantaj: ");
INSERT INTO qulNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Diospaj gobiernonka rijch'acun uj gobernaj churinta casarachinanpaj fiestata ruwajman. ");
INSERT INTO qulNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Uywaskancunata cacharkan invitaskancunata wajamunanpaj, paycunataj mana jamuyta munarkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Waj uywaskancunata cacharkan nispa: ‘Invitaskacunaman niychis miqhuy listoña caskanta. Wira wacaycunata waj wira animalniycunatawan ñac'achiniña. Tucuy ima listoña. Casarana wasiman jamullachuncuña.’ ");
INSERT INTO qulNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Paycunataj mana casorkancuchu. Ujnin chajranta puriporkan, ujnintaj negocioncunaman. ");
INSERT INTO qulNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Waquincunataj gobernajpaj uywaskancunata jap'ispa, ñac'aricherkancu wañuchinacama. ");
INSERT INTO qulNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Gobernajtaj chayta uyarispa sinchita phiñacorkan, soldadoncunatataj cacharkan chay runa wañuchejcunata wañuchinancupaj, llajtancutataj canaycunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Uywaskancunatataj nerkan: ‘Tucuy ima listoña casarachinaypaj. Ñaupaj invitaskaycunaka mana jamunancupaj jinachu carkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Puriychis, ari, athun callecunata. Tucuy taripaskayquichista casaranaman wajamuychis.’ ");
INSERT INTO qulNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Uywaskacunataj callecunata purerkancu, tantamorkancutaj tucuy taripaskancuta, allincunata, mana allincunata. Ajinata casarana wasiman runacunata junt'aycucherkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Gobernajtaj invitaskacunaman yaycorkan. Uj runata ricorkan mana casarana p'achayojta. ");
INSERT INTO qulNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nerkantaj: ‘Amigo, ¿imaynatataj cayman yaycumorkanqui mana casarana p'achayojri?’ Paytaj ch'inlla carkan. ");
INSERT INTO qulNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Chhicataj gobernajka mesapi sirvejcunaman nerkan: ‘Wataycuychis chaquincunata maquincunatawan. Jawa tutayajman wijch'uychis. Chaypi wakanka, quiruncunata c'uturaconka.’ ");
INSERT INTO qulNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Imaraycuchus achqhayoj wajaska cancu, chaywanpas pisilla ajllaskacunaka.” ");
INSERT INTO qulNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Chay pasayta, fariseocuna purerkancu, rimanacorkancutaj, parlaskanpi pantajtin Jesusta juchachanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ajinata paycunamanta cajcunata Herodespaj partidonmanta cajcunatawan cacharkancu Jesusta nimunancupaj: —Yachachej, parlaskayqui cierto caskanta yachaycu. Runapaj parlaskanta mana manchaspa, nitaj runapaj rijch'ayninta khawaspa, verdadta yachachinqui Diospaj munaskanman jina causanancuta. ");
INSERT INTO qulNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Niwaycu ari, ¿allinchu icha manachu impuesto pagana Roma gobiernoman? ");
INSERT INTO qulNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesustaj paycuna iscay uya caskancuta yachaspa, nerkan: —¡Iscay uyacuna! ¿Imaraycutaj pantachiwayta munanquichis? ");
INSERT INTO qulNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Impuesto pagana kolketa ricuchiwaychis. Uj kolketa jaywarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ricuspa, Jesús taporkan: —¿Pipaj uyantaj, pipaj sutintaj cay kolkepi escribiska cachcan? ");
INSERT INTO qulNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Contestarkancutaj: —Gobernaj Cesarpajta. Jesustaj paycunata nerkan: —Cesarpaj cajtaka, Cesarman koychis. Diospaj cajtataj, Diosman koychis. ");
INSERT INTO qulNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Chayta uyarispa, musphararkancu. Sakerpayaspataj, puriporkancu, ");
INSERT INTO qulNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Chay p'unchayllapitaj waquin saduceocuna Jesusman jamorkancu. Saduceocunaka nincu wañuskamanta causarina mana caskanta. Chayraycu cay ejemplowan Jesusta taporkancu: ");
INSERT INTO qulNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Yachachej, Moisés nerkan: ‘Uj runa mana wawayoj wañojtin, wauken viudanwan casaranan, ajinapi wañojpaj wawan cananpaj.’ ");
INSERT INTO qulNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Caypi nokaycu uqhupi, kanchis waukentin carkancu. Curaj waukencu casaracorkan. Mana wawayoj wañupojtin, viudan waukenwan quedaporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ajinallataj khepacajwan pasarkan, quimsacajwanpas, ajinallatataj kanchisnintinwan. ");
INSERT INTO qulNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tucuynincu wañupojtincutaj, warmeka wañupullarkantaj. ");
INSERT INTO qulNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Cunanri, kanchisnintin paywan casaracojcuna causarimojtincu, ¿maykenpaj warmintaj cankari? ");
INSERT INTO qulNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesús paycunaman contestarkan: —Kancunaka pantaska canquichis. Mana Escrituracunata entendinquichischu, ni Diospaj atiynintapas. ");
INSERT INTO qulNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Causarimuspaka, kharicuna warmicunapas mana casaraconkacuchu, imaraycuchus janaj pachapi caj angelcuna jina cankacu. ");
INSERT INTO qulNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Wañuskacuna causarinamanta ¿manachu leerkanquichis Dios quiquin niskanta? ");
INSERT INTO qulNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Dios nin: ‘Noka cani Abrahampaj, Isaacpaj, Jacobpaj Diosnin.’ ¡Dioska mana wañuskacunapaj Diosninchu, manachayri causajcunapaj Diosnin! ");
INSERT INTO qulNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Runacunataj chayta uyarispa, Jesuspaj yachachiskanmanta musphararkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Fariseocuna tantacorkancu, Jesús saduceocunata jup'allachiskanta yachaspa. ");
INSERT INTO qulNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Paycunamanta ujnin, leymanta yachachej, pantachiyta munaspa taporkan: ");
INSERT INTO qulNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Yachachej, ¿maykentaj mandamientocunamanta astawan importanteri? ");
INSERT INTO qulNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús payta nerkan: —‘Señor Diosniyquita munacunqui tucuy sonkoyquiwan, tucuy almayquiwan, tucuy yuyayniyquipiwan.’ ");
INSERT INTO qulNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Chaycajmi ñaupajcajka, astawan importante waj mandamientocunamanta nejtinpas. ");
INSERT INTO qulNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Iscaycajtaj ñaupajcajman rijch'acun. Nin: ‘Runamasiyquita munacunqui kan quiquiyquita jina.’ ");
INSERT INTO qulNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Chay iscay mandamientocunapi tucuy Moisespaj leynincuna profetacunapaj yachachiskancunapas junt'acun. ");
INSERT INTO qulNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseocuna tantaska cachcajtincuraj, ");
INSERT INTO qulNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesús paycunata taporkan: —¿Ima ninquichistaj Mesías Cristomanta? ¿Pipaj mirayninmantataj nacin? Contestarkancutaj: —Davidpaj mirayninmanta —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Chhicataj Jesús paycunata nerkan: —¿Imaraycutaj David payta ‘Señor’ nerkan, Santo Espiritupaj yachachiskanman jinari? Davidka nerkan: ");
INSERT INTO qulNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Señor Dios Señorniyman nerkan: Paña ladoypi tiyaycuy chejniycojniyquicunata atipanaycama.’ ");
INSERT INTO qulNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Imaynatataj Cristo Davidpaj miraynin canman, David quiquin ‘Señorníy’ nejtinri? ");
INSERT INTO qulNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mana pipas contestayta aterkanchu, ni imallatapas. Chhica p'unchaymantapacha manaña pipas atrevicorkanchu astawan imamanta tapuytapas. ");
INSERT INTO qulNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Chay pasaymanta Jesús runacunaman discipuloncunamanpiwan nerkan: ");
INSERT INTO qulNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Leymanta yachachejcuna fariseocunapiwan Moisespaj leyninta yachachinancupaj oficioyoj cancu. ");
INSERT INTO qulNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Chayraycu casucuychis, tucuy niskancunatataj ruwaychis. Amataj paycuna jina caychischu. Paycunaka parlallancu, manataj ruwancuchu. ");
INSERT INTO qulNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Mana okhariy atina llasa k'epita runacunaman k'epirichincu; paycunataj ni uj dedollawanpas yanapayta munancuchu. ");
INSERT INTO qulNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Paycunaka imatapas ruwancu runapaj ricunallanpaj. Mat'incupi, brazoncupi, ancho cintacunapi Escrituramanta escribiskata apancu. Athuchaj flecocunayoj p'achacunata churacuncu. ");
INSERT INTO qulNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Fiestacunapipas ñaupajpipuni honorwan tiyayta munancu, ajinallatataj sinagogacunapipas. ");
INSERT INTO qulNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Callecunapi tucuy respetowan ‘yachachej’ nispa saludanata munancu. ");
INSERT INTO qulNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Kancunaka ama ‘yachachej’ nichicuyta munaychischu, imaraycuchus tucuyniyquichis hermanocama canquichis. Ujllami Yachachejniyquichiska, chaytaj Cristo. ");
INSERT INTO qulNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ama pitapas ‘tata’ ninquichischu cay pachapi, imaraycuchus ujllami Tatayquichiska, chaytaj janaj pachapi cachcaj Dios. ");
INSERT INTO qulNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nillataj ‘mandacoj jefe’ nichicuychischu, imaraycuchus Cristo sapallami Jefeyquichiska. ");
INSERT INTO qulNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kancuna uqhumanta curaj cajka ujcunata sirvichun. ");
INSERT INTO qulNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Pay quiquin athunchacojka humillachiska canka; humillacojcajtaj athunyachiska canka. ");
INSERT INTO qulNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“¡Ay kancuna, leymanta yachachejcuna, fariseocuna, iscay uyacuna! Diospaj gobiernon puncuta wisk'anquichis ujcuna mana yaycunancupaj. Ni kancunapas yaycunquichischu, nillataj yaycuy munajcunata yaycojta dejanquichischu. ");
INSERT INTO qulNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Ay kancuna, leymanta yachachejcuna, fariseocuna, iscay uyacuna! Viudacunamanta tucuy cajnincunata wasintawan kechunquichis; mana reparachicunayquichispajtaj unayta oracionta ruwanquichis. Chayraycu kancunataka Dios astawan castigasunquichis. ");
INSERT INTO qulNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“¡Ay kancuna, leymanta yachachejcuna, fariseocuna, iscay uyacuna! Kancunaka kochanta jallp'antapas purinquichis uj runallatapas religionniyquichisman creechinayquichispaj. Creechispataj, iscay cuti castiganapajraj tucuchinquichis kancunamanta nejtenka. ");
INSERT INTO qulNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“¡Ay kancuna, ñausa cachcaspa pusay munajcuna! Ninquichis: ‘Pillapas prometicuspa templorayculla juramentota ruwajtenka, mana imananchu. Templopaj korinraycu juramentota ruwajka, junt'ananpuni.’ ");
INSERT INTO qulNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Mana yuyayniyoj sonso ñausacuna! Maykencajtaj astawan importante, ¿korichu icha templochu, chay temploraycu chay kori Diosllapaj cajtinri? ");
INSERT INTO qulNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nillanquichistaj: ‘Pipas prometicuspa altarrayculla juramentota ruwajtenka, mana imananchu. Altarpi caj ofrendaraycu juramentota ruwajka, junt'ananpuni.’ ");
INSERT INTO qulNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Ñausacuna! Maykencajtaj astawan importante, ¿ofrendachu icha altarchu, chay altarraycu chay ofrenda Diosllapaj cajtinri? ");
INSERT INTO qulNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Pipas altarraycu juramentota ruwajka mana altarraycullachu juran, manachayri tucuy altar patapi cajraycu. ");
INSERT INTO qulNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Pipas temploraycu juramentota ruwajka mana temploraycullachu juran, manachayri chaypi tiyaj Diosraycu. ");
INSERT INTO qulNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Janaj pacharaycu juramentota ruwajka mana Diospaj trononraycullachu juran, manachayri chaypi tiyacoj Diosraycu. ");
INSERT INTO qulNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“¡Ay kancuna, leymanta yachachejcuna, fariseocuna, iscay uyacuna! Kancuna chuncamanta ujninta konquichis yerba buenamanta, anismanta, cominomantapas. Chaywanpas leypaj importante yachachicuskanta mana casunquichischu: sumaj justo cayta, qhuyapayacuyta, fiel caytawan. Chaycunata ruwanayquichis carkan, diezmota koyta mana konkapuspa. ");
INSERT INTO qulNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Ay kancuna, ñausa cachcaspa pusay munajcuna! Ch'uspita suysunquichis, camellotataj okoycunquichis. ");
INSERT INTO qulNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“¡Ay kancuna, leymanta yachachejcuna, fariseocuna, iscay uyacuna! Kancunaka vasota platotapas patallanta limpiochanquichis, uqhuyquichistaj suwacuywan mana chanin causaywan junt'achiska cachcanquichis. ");
INSERT INTO qulNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Ñausa fariseocuna! Ñaupajta vasopaj uqhunta mayllaychis, ajinapi patanpas limpio canka. ");
INSERT INTO qulNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“¡Ay kancuna, leymanta yachachejcuna, fariseocuna, iscay uyacuna! Kancunaka yuraj pintaska sepulturacuna jina patallan munaycito canquichis, uqhuntaj aya tullucunawan, tucuy millay asnaycunawan junt'ataj. ");
INSERT INTO qulNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Jina kancunaka canquichis, patanka sumaj rijch'acunquichis runacunapaj ñaupakenpi; uqhuyquichistaj mana allin caywan engañocunawan junt'a cachcanquichis. ");
INSERT INTO qulNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“¡Ay kancuna, leymanta yachachejcuna, fariseocuna, iscay uyacuna! Kancunaka profetacunapaj sepulturancunata ruwanquichis, ajinallatataj sumaj runacunapaj sepulturancunata munayta jallch'anquichis. ");
INSERT INTO qulNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ninquichistaj: ‘Sichus abuelonchiscunapaj tiemponpi nokanchis cachuwanchis carkan chayka, profetacunata wañuchiyta mana yanapachuwanchu carkan’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Chaywanka kancuna quiquiyquichis willacunquichis profetacunata wañuchejcunapaj churincu caskayquichista. ");
INSERT INTO qulNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Kancuna abueloyquichiscunapaj kallariskanta tucuchallaychisña! ");
INSERT INTO qulNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“¡Pallicuna, pallipaj miraynincuna! ¿Imaynatataj infierno castigomanta escapawajchisri? ");
INSERT INTO qulNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Chaypaj profetacunata, yachajcunata, yachachejcunatawan cachamusaj. Chaywanpas kancunaka waquinnincuta wañuchinquichis, waquinnincutataj chacatanquichis, waquinnincutataj sinagogacunapi c'upanquichis, katiycachanquichistaj llajtamanta llajta. ");
INSERT INTO qulNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ajinaka tucuy cay sumaj runacunata wañuchiskayquichismanta, kancunaman castigoka jamonka, justo Abelmantapacha Berequiaspaj churin Zacariascama. Payta wañucherkanquichis altarwan santo lugarwan chaupipi. ");
INSERT INTO qulNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Segurayquichis, cay tucuy ima ruwaskayquichismanta castigo jamonka kancuna cunan tiempopi causachcaj runacunaman. ");
INSERT INTO qulNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“¡Jerusalén runacuna, profetacunata wañuchejcuna, Diospaj palabran willaj cachamuskancunata rumiwan chhokaspa wañuchejcuna! ¡Jayc'a cuti munarkani noka kancunawan tantaycucuyta, imaynatachus wallpa rijran uqhupi chiullincunata tantaycun ajinata, manataj munarkanquichischu! ");
INSERT INTO qulNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Khawariychis, wasiyquichis wijch'uska canka. ");
INSERT INTO qulNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Niyquichis, manaña ricuwanquichischu, ‘Alabaska cachun Señorpaj sutinpi jamojka’ ninawayquichis tiempocama.” ");
INSERT INTO qulNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesús templomanta llojsispa puripuchcarkanña. Discipuloncunataj Jesusman chimpaycuspa, templo munay ruwaska caskanta ricucherkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesustaj paycunata nerkan: —¿Ricunquichischu cay athun wasicunata? Segurayquichis, mana ni uj rumipas uj rumi patapi quedankachu. Tucuy ñut'u urmachiska canka. ");
INSERT INTO qulNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Olivos lomaman puriporkancu. Jesús tiyaycorkan; discipuloncunataj tapunancupaj chimpaycorkancu: —Tucuy cay pasananmanta yachayta munaycu. ¿Ima señaltaj canka cutimunayqui p'unchaymanta, mundopaj tucucunanmantawan? ");
INSERT INTO qulNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesús paycunata contestarkan: —Cuidacuychis mana pipas engañanasunquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Imaraycuchus achqhayoj jamonkacu, ‘Noka cani Cristo’ nispa. Achqhayojtataj engañankacu. ");
INSERT INTO qulNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kancuna guerracunamanta parlajta uyarispa ama manchacuychischu. Caycunaka cananpuni. Pero manaraj tucucuyrajchu. ");
INSERT INTO qulNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Gobiernopura nacionpura makanaconkacu. Achqha lugarpitaj jallp'a qharcatenka, yarekaycunataj canka. ");
INSERT INTO qulNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tucuy caycunataj nanaycuna kallariyllaraj. ");
INSERT INTO qulNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Kancunata entregasunquichis ñac'arichinasunquichispaj, wañuchisunquichistaj. Tucuy runacunataj nokaraycu chejnisunquichis. ");
INSERT INTO qulNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Jakay tiempopi achqhayoj creeynincuta chincachiconkacu. Chejninaconkacu, vendiycunaconkacu. ");
INSERT INTO qulNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Achqha llulla profetacuna riqhurimonkacu, achqha runacunata engañankacu. ");
INSERT INTO qulNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Sinchi sajrayay yapacuskanraycu curaj parte runacuna mana munacuyniyoj caponkacu. ");
INSERT INTO qulNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pichari tucucuycama firme cajlla salvaska canka. ");
INSERT INTO qulNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Diospaj gobiernonmanta sumaj noticiayoj evangelio tucuy cay pachaman willaska canka, tucuy runacuna yachanancupaj. Chhicaraj mundo tucuconka. ");
INSERT INTO qulNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Profeta Daniel escriberkan santo lugar sinchicaj khellichaska cananmanta. (¡Pipas cayta leejka entendichun!) Chayta ricuspa, ");
INSERT INTO qulNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Judeapi cajcuna lomacunaman escapachuncu. ");
INSERT INTO qulNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Wasi patapi cachcajka amaña wasiman yaycuchunchu imatapas okharispa apananpaj. ");
INSERT INTO qulNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Chajrapi cachcajka amaña wasinman cutichunchu p'achanta orkhojka. ");
INSERT INTO qulNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Chay p'unchaycunapi, ay onkoj warmicuna, ñuñuchcaj wawayojcunapas! ");
INSERT INTO qulNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Oracionpi Diosmanta mañacuchcaychis, escapacunayquichis mana chiri tiempopi ni samana p'unchaypi tupananpaj. ");
INSERT INTO qulNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Chay p'unchaycunapeka athun ñac'ariy canka. Chay jina ñac'areyka mana carkanchu Dios cay pachata ruwaskanmantapacha cunancama, nitaj jayc'ajpas jinaka cankañachu. ");
INSERT INTO qulNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Señor Dios chay ñac'ariy tiempota mana ñaupajta tucuchanmanchu chayka, ni pipas salvacunmanchu. Astawanri Dios munaskan ajllaskancunaraycu chay tiempota tucuchanka. ");
INSERT INTO qulNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Chay p'unchaycunapi pipas nisunquichisman: ‘¡Khawaychis, caypi Cristo cachcan!’ chayri ‘¡Khawaychis, jakaypi cachcan!’ nispa chayka, ama creenquichischu, ");
INSERT INTO qulNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","imaraycuchus falso cristocuna llulla profetacunapiwan jamonkacu. Athun milagrocunata señalcunatawan ruwankacu engañanancupaj; Diospaj ajllacuskancunantinta engañankacu, aticojtenka. ");
INSERT INTO qulNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Cuidacuychis, willayquichisña manaraj pasachcajtin. ");
INSERT INTO qulNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Chayraycu sichus nisunquichisman: ‘Khawariychis, chaypi Cristo cachcan ch'usaj lugarpi’ nispa chayka, ama puriychischu. Nisunquichisman: ‘Khawariychis, caypi pacaska cachcan’ nispa chayka, ama creenquichischu. ");
INSERT INTO qulNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Imaynatachus rayo tucuy janaj pachata c'anchan, ajina canka Tataj Churin cutimojtin. ");
INSERT INTO qulNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Maypichus wañuska canka, chayman gallinazocunaka tantaconkacu. ");
INSERT INTO qulNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ñac'ariy tiempo tucucojtin jina, inti tutayayconka, quillapas manaña c'anchamonkachu. Koyllurcunataj janaj pachamanta urmakaramonkacu. Janaj pachapi caj atiyniyojcuna qharcatenkacu. ");
INSERT INTO qulNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Chaymanta janaj pachapi Tataj Churinpaj señalninta riconkacu. Tucuy runacuna cay pachapi sinchi manchacuywan wakarankacu. Riconkacutaj Tataj Churinta janaj pachamanta phuyupi jamuchcajta athun atiyninwan sumaj glorioso c'anchayninwan. ");
INSERT INTO qulNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Chaypacha Dioska angelnincunata cachamonka tucuy cay pachamanta janaj pachamantapas ajllacuskancunata tantaycuchinanpaj, cornetata callpawan tocachejtin jina. ");
INSERT INTO qulNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Higo sach'amanta yachakaychis: Ima ratochus c'allmancuna k'omeryamun, raphincuna ch'ijchiramun chhica, yachanquichisña k'oñi tiempo kayllachamuchcaskanta. ");
INSERT INTO qulNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ajinallatataj kancunapas chay tucuy ima pasajtin, yachanquichis cutimunay p'unchayka kayllallapiña caskanta. ");
INSERT INTO qulNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Segurayquichis, tucuy chay imacuna canka, cunan tiempo runa causachcajtinraj. ");
INSERT INTO qulNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Janaj pacha cay pachapas tucuconka, palabraycunacajtaj mana chincankachu junt'acunancama. ");
INSERT INTO qulNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Chay cutimunay p'unchayta chay horata mana pipas yachanchu, ni angelcuna, ni Tataj Churinpas, manachayri Dios Tatalla yachan. ");
INSERT INTO qulNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Imaynachus Noepaj tiemponpi carkan, jinallataj canka, Tataj Churin cutimojtenka. ");
INSERT INTO qulNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Unu juicio ñaupajta, Noé boteman yaycunancama runacunaka miqhuchcarkancu, ujyachcarkancu, casarachcarkancutaj. ");
INSERT INTO qulNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Mana suyaskancu rato unu juicio jamorkan, tucuytaj wañurarkancu. Jinallataj canka, Tataj Churin cutimojtenka. ");
INSERT INTO qulNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Jakay p'unchaypeka iscay runacuna chajrapi cachcankacu: ujnenka okhariska canka, ujnintaj sakeska. ");
INSERT INTO qulNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Iscay warmicuna cutachcankacu: ujnenka okhariska canka, ujnintaj sakeska. ");
INSERT INTO qulNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Kancunaka rijch'achcaychis; imaraycuchus mana yachanquichischu ima rato Señorniyquichis cutimunanta. ");
INSERT INTO qulNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Yachaychis cayta: Sichus wasiyoj yachanman ima horata suwa jamunanta chayka, mana puñuspa suyanman, nitaj wasinmanta suwachicunmanchu. ");
INSERT INTO qulNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kancunapas waquichiska cachcaychis; imaraycuchus mana yuyaskayquichis rato Tataj Churenka jamonka. ");
INSERT INTO qulNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“¿Pitaj fiel yuyayniyoj mayordomo canman? Chayman patronnin encargan, wasinpi cajcunaman miqhunata konanpaj. ");
INSERT INTO qulNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Cusicuyniyoj canka cay mayordomo, patronnin ajinata ruwachcajta taripanka chayka. ");
INSERT INTO qulNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Segurayquichis, cay jina mayordomotaka patronnin tucuy khapaj caynin khawajta churanka. ");
INSERT INTO qulNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Sichus chay mayordomo mana allin canman, sonkonpitaj ninman: ‘Patronneyka manaraj chayamonkachu.’ ");
INSERT INTO qulNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Chhicataj llanc'ajcunata kharita warmitapas makayta kallarinman, sinchitataj miqhunman, ujyanman, machaycunmantaj chayka, ");
INSERT INTO qulNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","mana suyaska p'unchaypi ni yachaska horapi patronnenka chayamonka. ");
INSERT INTO qulNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Chhicataj sinchita castiganka, mana creeyniyoj iscay uya runacunata jina. Chhicataj wakanka, nanaymantataj quiruncunata c'ariris nispa c'uturaconka. ");
INSERT INTO qulNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Diospaj gobiernonka chunca sipascunaman rijch'acun. Paycunaka mechero c'anchaynincuta okharispa, casaracoj noviota taripaj purerkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Phichka paycunamanta mana yuyayniyoj carkancu, phichkacajtaj yuyayniyoj. ");
INSERT INTO qulNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Mana yuyayniyojcunaka mechero c'anchaynincuta apaspa, mana wajpi aceiteta apacorkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Yuyayniyojcunataj botellancupi mechero c'anchaynincupi ima aceiteta apacorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Novio mana uskhayta chayamojtin, tucuynincu puñuywan atipachicuspa puñuraporkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Chaupi tutata wajach'acojta uyarerkancu: ‘¡Novio jamuchcanña; llojsimuychis jap'ekaj!’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tucuynin sipascunataj jatarerkancu, mechero c'anchaynincuta waquichicunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Phichka mana yuyayniyojcunataj phichka yuyayniyojcunaman nerkancu: ‘Uj chhican aceiteta koriwaycu, imaraycuchus c'anchayniycu wañupuchcanña.’ ");
INSERT INTO qulNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Yuyayniyoj sipascunataj contestarkancu: ‘Mana koyquichismanchu, nokaycupajpas kancunapajpas mana pisinanpaj. Astawanpas vendejcunaman puriychis, kancunapaj ranticamuychis.’ ");
INSERT INTO qulNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Jakay phichka sipascuna aceiteta ranticuchcanancucama, novioka chayamorkan. Waquichiska cajcunataj paywan casamientoman yaycorkancu, puncutataj wisk'aycaporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Chay pasaytataj mana yuyayniyoj sipascunaka chayamorkancu, puncutataj tacarkancu: ‘¡Señor, Señor, quichariwaycu!’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Paytaj contestamorkan: ‘¡Mana rejsiyquichischu!’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jesús nillarkantaj: “Kancunapas rijch'achcaychis, imaraycuchus mana yachanquichischu ni ima p'unchay ni ima hora cutimunayta.” ");
INSERT INTO qulNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Diospaj gobiernonka cayta ruwaj runaman rijch'acun. Chay runa waj nacionman puripunanpaj llanc'ajnincunata wajaspa, kolkenta cuidanancupaj korkan. ");
INSERT INTO qulNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ujninman phichka waranka kolketa korkan, ujmantaj iscay warankata, ujcajmantaj warankata. Sapa ujman korkan atiskancuman jina. Chhicataj puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Phichka waranka kolketa jap'ekajka negociota ruwaspa uj chay chhicatawan miracherkan. ");
INSERT INTO qulNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ajinallatataj iscay waranka jap'ekajka iscay warankatawan miracherkan. ");
INSERT INTO qulNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Uj waranka jap'ekajtaj jallp'ata jutc'uspa, patronninpaj kolkenta pacaycorkan. ");
INSERT INTO qulNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Unaymanta cutimuspataj, patronnincoka paycunamanta cuentata mañarkan. ");
INSERT INTO qulNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ñaupajta phichka waranka kolketa jap'ekajka chayamorkan. Patronninman uj phichka warankatawan korkan nispa: ‘Señor, kan phichka warankata kowarkanqui; cay phichka warankatawan mirachini.’ ");
INSERT INTO qulNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Patronnintaj payta nerkan: ‘May allin, sumaj fiel llanc'aj canqui. Uj chhicanpi fiel caskayquiraycu, astawan achqhata koskayqui cuidanayquipaj. Yaycuy, nokawan cusicuy.’ ");
INSERT INTO qulNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Iscay waranka jap'ekajka chayamullarkantaj, nispa: ‘Señor, iscay warankata kowarkanqui; cay iscay warankatawan mirachini.’ ");
INSERT INTO qulNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Patronnintaj nerkan: ‘May allin, sumaj fiel llanc'aj canqui. Uj chhicanpi fiel caskayquiraycu, astawan achqhata koskayqui cuidanayquipaj. Yaycuy, nokawan cusicuy.’ ");
INSERT INTO qulNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Uj waranka jap'ekajka patronninman chayamullarkantaj, nispa: ‘Señor, kanta rejsiyqui cumplichej caskayquita, mana tarpuskayquita ajthapej, mana t'acaskayquita okharej. ");
INSERT INTO qulNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Chayraycu manchacorkani, purispataj jallp'api kolkeyquita pacaycuni. Cayka, kanpaj cajta jap'ekapuy.’ ");
INSERT INTO qulNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Patronnintaj contestarkan: ‘Sajra kella canqui. Yachanqui mana tarpuskayta ajthapej caskayta, mana t'acaskayta okharejtaj. ");
INSERT INTO qulNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Jina cajteyka bancoman churanayqui carkan, cutimuspa kolkeyta miraynintawan orkhocapunaypaj.’ ");
INSERT INTO qulNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Chaypi cajcunamantaj nerkan: ‘Chay waranka kolketa kechuychis; chunca waranka kolkeyojman koychis. ");
INSERT INTO qulNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Pipajchari can, chaymanka astawanraj koska canka puchojpajwan cananpaj; mana cajniyojmantari uj chhican cajninpas kechuska canka. ");
INSERT INTO qulNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Chay mana sirvej llanc'ajtataj jawaman wijch'uychis tutayajman; chaypi wakaspa nanaymanta quiruncunata c'ariris nispa c'uturaconka.’ ");
INSERT INTO qulNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Tataj Churin sinchi c'anchaywan atiyninpiwan jamonka. Tucuy angelnincuna paywan cachcajtincu, sumaj glorioso trononpi tiyayconka. ");
INSERT INTO qulNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tucuy nacioncunamanta runacunaka paypaj ñaupakenpi tantaconkacu. Paytaj ujcunata ujcunamanta ajllaspa, t'ipekanka, imaynatachus michejka ovejacunata cabracunamanta t'ipekan. ");
INSERT INTO qulNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ovejacunata pañannejman churanka, cabracunatataj llok'ennejman. ");
INSERT INTO qulNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Pañannejpi cajcunata Rey Churi nenka: ‘Kancuna jamuychis, Tataypaj bendiciskancuna. Diospaj gobiernonman yaycuychis, cay pachata ruwaskanmantapacha kancunapaj waquichiskanman. ");
INSERT INTO qulNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Yarekaska cajtiy, miqhuchiwarkanquichis; unumanta ch'aquiska cajtiy, ujyachiwarkanquichis; waj llajtayoj runa jina purejtiy, korpachawarkanquichis. ");
INSERT INTO qulNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","P'achay tucucojtin, kancuna kowarkanquichis; onkoska cajtiy, watucuwarkanquichis; carcelpi cajtiy, jamorkanquichis khawariwaj.’ ");
INSERT INTO qulNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Justocunataj taponkacu: ‘Señor, ¿jayc'ajtaj yarekaskata ricorkayquichis, korkayquichistaj miqhunata? chayri ¿jayc'ajtaj ricorkayquichis unumanta ch'aquiskata, korkayquichistaj unu ujyanata? ");
INSERT INTO qulNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Jayc'ajtaj waj llajtayoj runata jina ricorkayquichis, korpacharkayquichistaj? ¿Jayc'ajtaj mana p'achayojta ricorkayquichis, korkayquichistaj? ");
INSERT INTO qulNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Jayc'ajtaj onkoskata ricorkayquichis, chayri carcelpi cajtiyquipas, jamorkaycutaj khawarej?’ ");
INSERT INTO qulNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Rey Churitaj contestanka: ‘Segurayquichis, tucuy ima ruwaskayquichis ujnin humilde hermanoycunapaj ruwaspaka, noka quiquiypaj ruwarkanquichis.’ ");
INSERT INTO qulNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Chaymantataj llok'ennejpi cajcunata Rey Churi nenka: ‘Nokamanta ithiricuychis, maldiciskacuna. Puriychis wiñay lauraj nina infiernoman, supaypaj angelnincunapajpiwan waquichiska cajman. ");
INSERT INTO qulNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yarekaska cajtiy, kancuna mana miqhuchiwarkanquichischu; unumanta ch'aquiska cajtiy, mana unuta kowarkanquichischu. ");
INSERT INTO qulNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Waj llajtayoj runa jina purejtiy, mana korpachawarkanquichischu. P'achay tucucojtin, mana kowarkanquichischu; onkoska carcelpitaj cajtiy, mana waturiwarkanquichischu.’ ");
INSERT INTO qulNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Chhicataj paycuna taponkacu: ‘Señor, ¿jayc'ajtaj ricorkayquichis, yarekaskata, unumanta ch'aquiskata, waj llajtayoj runata jina, mana p'achayojta, onkoskata, chayri carcelpi cajta manataj yanaparkayquichischu?’ ");
INSERT INTO qulNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Rey Churitaj contestanka: ‘Segurayquichis, ujnin humilde runacunapaj tucuy imata mana ruwanquichischu chayka, nokapajpas manallataj ruwarkanquichischu.’ ");
INSERT INTO qulNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Chaycunataj wiñay castigoman puriponkacu, justocunataj wiñay causayman.” ");
INSERT INTO qulNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tucuy chayta niy pasayta, Jesús discipuloncunaman nerkan: ");
INSERT INTO qulNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Kancunaka yachanquichis iscay p'unchaymanta Pascua cananta. Tataj Churinta entregankacu chacatanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Jakay tiempopi sacerdotecunapaj jefencuna, llajtapaj jefencunapiwan curaj sacerdote Caifaspaj wasinpi tantacorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Rimanacorkancu ima engañowanpas Jesusta jap'ispa wañuchinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Nerkancutaj: —Ama fiesta ratoka, runacuna mana pitucunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús Betaniapi cachcarkan, lepra onkoskamanta alliyaj Simonpaj wasinpi. ");
INSERT INTO qulNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Chaypitaj uj warmi chimpaycorkan, alabastro niska rumi frascopi junt'ata sinchi valorniyoj sumaj k'apayniyoj perfumeta apamuspa. Jesús miqhunanpaj cachcajtin, payka perfumewan Jesuspaj umanman jich'aycorkan. ");
INSERT INTO qulNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Discipuloncunataj chayta ricuspa, phiñacorkancu, paycunapurataj ninacorkancu: —¿Imaraycutaj cay jina precioyoj perfumeta usuchichcan? ");
INSERT INTO qulNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Achqha kolkepi vendimunman carkan pobrecunata yanapanapaj. ");
INSERT INTO qulNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús chayta uyarispa, paycunata nerkan: —¿Imaraycutaj cay warmita thutupayanquichis? Nokapaj cay ruwaskanka allin. ");
INSERT INTO qulNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Pobrecunaka kancunawanpuni cachcancu; nokaka mana tucuy tiempochu kancunawan casaj. ");
INSERT INTO qulNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Cay warmeka perfumewan cuerpoyta jawispa, waquichiwan p'ampaska canaypaj. ");
INSERT INTO qulNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Segurayquichis, mayllapipas tucuy cay pachapi evangeliota willarajtincu, willacullankataj cay warmipaj ruwaskanka, paymanta yuyarinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Chunca iscayniyojmanta ujnin discípulo Judas Iscariote sutiyoj carkan. Paytaj purispa, sacerdotecunapaj jefencunata tariparkan. ");
INSERT INTO qulNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Paycunaman nerkan: —¿Jayc'a kolketataj kowanquichisman, kancunaman Jesusta entreganaypaj? Paycunataj preciota churarkancu, quimsa chunca kolketa. ");
INSERT INTO qulNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Chhicamantapacha Judaska masc'arkan imaynata paycunaman Jesusta entregananpaj. ");
INSERT INTO qulNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pascua fiesta kallarina p'unchaypi, mana levadurayoj t'anta miqhuna p'unchay, discipuloncuna Jesusman chimpaycuspa taporkancu: —¿Maypitaj Pascua cenata waquichinaycuta munanqui? ");
INSERT INTO qulNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Paytaj contestarkan: —Puriychis llajtaman, uj runapaj wasinman, niychistaj: ‘Yachachej nin: Horay kayllachamunña; wasiyquita purisaj discipuloycunawan Pascuata ruwaj.’ ");
INSERT INTO qulNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Discipulocunataj Jesuspaj mandacuskanman jina ruwarkancu. Pascua cenata waquicherkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ch'isiyaycuytataj Jesús chunca iscayniyoj discipuloncunawan miqhoj tiyaycorkan. ");
INSERT INTO qulNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Miqhuchcaspataj paycunata nerkan: —Segurayquichis, ujnin kancunamanta vendiycuwanka. ");
INSERT INTO qulNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Paycunataj sinchita llaquicorkancu. Uj ujcunataj tapunacuyta kallarerkancu: —Señor, ¿nokachu caymanri? —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesustaj paycunata contestarkan: —Pichus nokawan cusca uj platopi t'antata chapuspa miqhuchcan, chay vendiycuwanka. ");
INSERT INTO qulNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tataj Churenka pasachcan paymanta escribiskaman jina. ¡Ay, jakay vendiycucojka! Allin canman carkan pay mana nacinanka. ");
INSERT INTO qulNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Chhicari vendiycoj Judas Jesusta taporkan: —Yachachej, ¿nokachu caymanri? Jesustaj contestarkan: —Arí, kan ninquiña. ");
INSERT INTO qulNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Miqhuchcajtincuraj, Jesús maquincunawan t'antata jap'ispa, Diosman graciasta korkan. T'antata partispataj paycunaman jaywarkan: —Miqhuychis, cayka cuerpoymi —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Vasota jap'ispataj Diosman graciasta kospa, paycunaman jaywarkan, nispa: —Tucuyniyquichis cay vasomanta ujyaychis. ");
INSERT INTO qulNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Cayka yawarniymi achqha runapaj juchancunata perdonanapaj jich'aska, caywan Diospaj mosoj compromison seguraska canka. ");
INSERT INTO qulNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Niyquichis, manaña vinota ujyasajchu, jakay p'unchaypi Diospaj gobiernonpi kancunawan mosoj vinota ujyanaycama. ");
INSERT INTO qulNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Himnota taquiy pasayta Olivos lomaman puriporkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jesús paycunata nerkan: —Tucuy kancuna cunan tuta sakerpayawanquichis. Jinata nin Escriturapi: ‘Michejta wañuchisaj, ovejacunataj t'acaraska cankacu.’ ");
INSERT INTO qulNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Causariskay pasaymanta, kancunamantapas ñaupajta Galileaman purisaj. ");
INSERT INTO qulNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedro Jesusman nerkan: —Tucuynincu sakerpayasunquichisman chaypas, nokacajka manapuni. ");
INSERT INTO qulNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesús Pedroman nerkan: —Segurayqui, cunan tutapacha, manaraj gallo iscay cutita wajach'acuchcajtin, kan quimsa cutita negawanqui. ");
INSERT INTO qulNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro nillarkantaj: —Kanwan cusca wañunay cajtinpas, mana negaskayquichu. Jinallatataj tucuynincu nerkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jesús Getsemaní niska huertoman chayaspa, discipuloncunaman nerkan: —Caypi tiyachcaychis oracionta ruwamunaycama. ");
INSERT INTO qulNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pedrota, Santiagota, Juantawan pusarkan. Jesustaj sinchita llaquicuyta kallarerkan. ");
INSERT INTO qulNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Paycunatataj nerkan: —Sinchi llaquiska cachcani wañunaycama. Caypi suyawaychis, rijch'achcaychistaj. ");
INSERT INTO qulNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ñaupajman purispataj konkoriycorkan. Mat'in pampaman tupanancama c'uñuycuspa oracionpi mañacorkan: “Tatáy, aticunman chayka, libraway ñac'arinay ama chayamunanpaj. Amataj nokapaj munayniychu cachun, manachayri kanpaj munayniyqui ruwacuchun.” ");
INSERT INTO qulNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Cutimuspataj discipuloncunata puñurachcajta tariparkan. Pedrota nerkan: —Simón, ¿puñuchcanquichu? ¿Manachu uj horallatapas rijch'ayta atinqui? ");
INSERT INTO qulNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Rijch'aychis, oracionta ruwaychis, ama tentacionman urmanayquichispaj. Allin cajta ruwayta munachcanquichis, chaywanpas mana callpayojchu canquichis. ");
INSERT INTO qulNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ujtawan purispa, oracionpi mañacorkan: “Tatáy, ñac'arinaypuni cajtenka, kanpaj munayniyqui ruwaska cachun” nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Cutimuspataj, discipuloncunata puñurachcajta tariparkan. Puñuyta mana aguantayta aterkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Paycunata sakespa, puriporkan. Quimsacaj cuti quiquillantataj mañacorkan. ");
INSERT INTO qulNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Chaymanta cutimuspataj, discipuloncunaman nerkan: —¿Puñuchcanquichisrajchu? ¿Samachcanquichisrajchu? ¡Chayllaña cachun! Hora chayamunña Tataj Churin juchasapa runacunaman entregaska cananpaj. ");
INSERT INTO qulNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Jatariychis, jacuchis! Nokata vendiycuwajka jamuchcanña. ");
INSERT INTO qulNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús parlachcajtillanraj, Judas chayamorkan, ujnin chunca iscayniyoj discipuloncunamanta. Paywantaj achqha runa espadacunayoj c'aspicunayoj jamorkancu, Jesusta jap'inancupaj. Paycuna jamorkancu, sacerdotecunapaj jefencuna llajtapaj jefencunapajpiwan cachamuskan. ");
INSERT INTO qulNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jesusta vendiycoj Judas yachachiska imaynata ricuycuchinanpaj: “Maykentachus noka much'aycusaj, chay canka. Payta jap'inquichis” nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Jesusta chimpaycuspa, nerkan: —¡Imaynalla, Yachachejníy! Much'aycorkantaj. ");
INSERT INTO qulNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesustaj payman nerkan: —Amigo, imachus ruwanayquita ruway. Judaswan jamojcunataj chimpaycuspa, Jesusta jap'erkancu apanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jesuswan cajcunamanta ujnin espadanta orkhospa, curaj sacerdotej uywaskanpaj ninrinta cuchokarkan. ");
INSERT INTO qulNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesús payta nerkan: —Espadayquita wakaychay. Espadata okharejcunaka espadallawantaj wañuchiska cankacu. ");
INSERT INTO qulNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Manachu yachanqui, Tataymantachus yanapanawanta mañacuyman chayka, payka cunanpacha chunca iscayniyoj tropa angelnincunata cachamuwanman? ");
INSERT INTO qulNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ajina cajtinri, ¿imaynatataj Escriturapaj niskan junt'acunman? ");
INSERT INTO qulNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Chhicapacha Jesús runacunata taporkan: —¿Imaraycutaj espadacunawan c'aspicunawan nokata jap'ej jamunquichis, uj suwapas cayman jinari? Sapa p'unchay templopi yachachispa, kancunawan cusca cachcarkani, jayc'ajpas jap'iwarkanquichischu. ");
INSERT INTO qulNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tucuy caycunaka pasan profetacunapaj Escriturapi niskancu junt'acunanpaj. Chhicapacha discipuloncuna Jesusta sakerpayaspa, tucuynincu escapacorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jesusta presochaspa, curaj sacerdote Caifaspaj wasinman pusarkancu, chaypitaj tantaska cachcarkancu curaj sacerdote, leymanta yachachejcuna, llajtapaj jefencunapiwan. ");
INSERT INTO qulNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedrotaj Jesusta carullamanta katispa, curaj sacerdotepaj wasi pationcama yaycorkan. Chaypi templo guardiajcunawan tiyaycorkan, imachus pasananta suyaspa. ");
INSERT INTO qulNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Athun Asambleapi sacerdotecunapaj jefencuna waj jefencunapiwan tantacuspa, Jesús contra llulla willajcunata masc'achcarkancu payta wañuchinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Achqha llulla willajcuna Jesús contra parlarkancu; chaywanpas mana ima juchatapas wañuchinancupaj tarerkancuchu. Khepataña iscay llulla willajcuna jamorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Nerkancutaj: —Cay runaka nerkan: ‘Diospaj templonta urmachisaj, quimsa p'unchaymantataj sayarichisaj’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Curaj sacerdotetaj sayarispa, Jesusman nerkan: —¿Manachu imatapas contestanqui? ¿Imataj cay kan contra nichcaskancu? ");
INSERT INTO qulNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesustaj ch'inlla carkan. Curaj sacerdotetaj payman nerkan: —Causachcaj Diospaj sutinpi mandayqui, niwaycu: ¿Kanchu Cristo, Diospaj Churin canqui? ");
INSERT INTO qulNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesustaj contestarkan: —Kan chayta ninqui. Niyquichis, Tataj Churinta ricunquichis tucuy atiyniyoj Diospaj paña ladonpi tiyachcajta, janaj pacha phuyucunapi jamuchcajta. ");
INSERT INTO qulNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Curaj sacerdotetaj phiñacuskanta ricuchinanpaj p'achancunata lliq'irpayaspa, nerkan: —¡Cay runapaj parlaskanka Diosta phiñachin! ¿Imapajñataj astawan willajcunata munanchisri? Kancuna Dios contra parlaskanta uyarinquichisña. ");
INSERT INTO qulNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Ima ninquichistaj? Paycunataj contestarkancu: —¡Juchayojpuni, wañuchun! —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Chaymanta Jesuspaj uyanpi thutkatarkancu, c'uparkancutaj. Ujcunataj uyapi makarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Nerkancutaj: —Kan Cristo caspaka, niwaycu pi makaskasunquita. ");
INSERT INTO qulNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedro chay wasi patiopi tiyachcajtin, uj uywaska sipas chimpaycuspa, nerkan: —Kanpas Galilea llajtayoj Jesuswan purejllataj canqui. ");
INSERT INTO qulNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedro tucuynincupaj ñaupakenpi negacorkan: —Mana rejsinichu, nitaj yachanichu imatachus niwaskayquita. ");
INSERT INTO qulNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Puncunejman puripojtin, waj uywaska sipas ricuspa ujcunaman nerkan: —Caypas Nazaret llajtayoj Jesuswan purej. ");
INSERT INTO qulNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pedrotaj ujtawan negacorkan, juramentowan: —Chay runata mana rejsinichu —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Uj ratomantataj chaypi cajcuna chimpaycorkancu, Pedromantaj nerkancu: —Cierto, kanka paycunamanta ujnin canqui. Parlaskayquipas paycunaman rijch'acun. ");
INSERT INTO qulNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pedrotaj juramento ruwayta kallarerkan maldiciytawan nispa: —¡Manapuni rejsinichu chay runataka! Chay ratopacha galloka wajach'acorkan. ");
INSERT INTO qulNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pedrotaj chayta uyarispa Jesuspaj niskanta yuyaricorkan: “Manaraj gallo iscay cutita wajach'acuchcajtin, kanka quimsa cutitaña negawanqui.” Pedrotaj chaymanta llojsipuspa, sonko nanaywan unu parayta wakaycorkan. ");
INSERT INTO qulNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pakariyamuyta, sacerdotecunapaj tucuy jefencuna llajtapaj jefencunapiwan rimanacorkancu Jesusta wañuchinapaj. ");
INSERT INTO qulNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jesusta wataskata apaspa, Roma gobernaj Pilatoman entregarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Vendiycoj Judas, Jesusta wañunanpaj juchachaskancuta ricuspa, sonkonta nanachicuspa, quimsa chunca kolketa cutichiporkan sacerdotecunapaj jefencunaman llajtapaj jefencunamanpiwan. ");
INSERT INTO qulNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Nerkantaj: —Juchallicuni mana juchayoj runata kancunaman entregaspa wañuchichinayquichispaj. Paycunataj contestarkancu: —Chay, ¿imataj nokaycuman importawancu? ¡Chayka kanpaj juchayqui! ");
INSERT INTO qulNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judastaj templo uqhuman kolketa chhokaspa puriporkan, sipicamorkantaj. ");
INSERT INTO qulNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Sacerdotecunapaj jefencunataj chay kolketa okharispa, nerkancu: —Cay kolkeka yawarwan khellichaska, mana atichuwanchu ofrenda kolkewan cusca wakaychaytaka. ");
INSERT INTO qulNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Chhicataj rimanacorkancu, chay kolkewan T'uru Manca Ruwajpaj Jallp'an niskata rantinancupaj, waj llajtayojcunata p'ampanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Chayraycu chay lugarka cunan p'unchaycama Yawar Jallp'a sutiyoj capun. ");
INSERT INTO qulNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ajinata junt'acorkan profeta Jeremiaspaj niskan: “Quimsa chunca kolketa jap'erkancu, Israel runacunapaj precio churaskancuta. ");
INSERT INTO qulNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Chay kolkewantaj T'uru Manca Ruwajpaj Jallp'anta ranterkancu, Señor Diospaj mandawaskanman jina.” ");
INSERT INTO qulNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesusta gobernaj Pilatopaj ñaupakenman pusarkancu. Pilatotaj taporkan: —¿Kanchu judiocunapaj Reynin canqui? Jesustaj contestarkan: —Kan chayta ninqui. ");
INSERT INTO qulNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Sacerdotecunapaj jefencuna llajtapaj jefencunapiwan juchachachcajtincu, Jesuska mana imatapas contestarkanchu. ");
INSERT INTO qulNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Chayraycu Pilato tapullarkantaj: —¿Manachu uyarinqui kan contra tucuy ima nichcaskancuta? ");
INSERT INTO qulNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesustaj ni uj palabrallatapas contestarkanchu, chayraycutaj Pilato sinchita muspharkan. ");
INSERT INTO qulNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Sapa Pascua fiestapi gobernajka uj presota cacharej carkan runacunapaj ajllaskanman jina. ");
INSERT INTO qulNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Chay tiempopi tucuy runacunapaj rejsiskan Barrabás sutiyoj preso cachcarkan. ");
INSERT INTO qulNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Runacuna tantaska cachcajtincu, Pilato taporkan: —¿Pitataj cacharinayta munanquichis, Barrabastachu icha Cristo niska Jesustachu? ");
INSERT INTO qulNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Chayta nerkan, envidiallamanta Jesusta entregaskancuta yachaspa. ");
INSERT INTO qulNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato juzgana sillapi tiyachcajtin, warmin cachamorkan willajta: “Ama imatapas ruwaychu chay justo runataka, imaraycuchus kayna ch'isi moskoyniypi sinchita ñac'arini paypaj causanraycu.” ");
INSERT INTO qulNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Sacerdotecunapaj jefencuna llajtapaj jefencunapiwan runacunata yachaycucherkancu mañanancupaj Barrabasta cachariska cananpaj, Jesustataj wañuchiska cananpaj. ");
INSERT INTO qulNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilato ujtawan taporkan: —¿Maykentataj cacharinayta munanquichis? Paycunataj contestarkancu: —¡Barrabasta! —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatotaj paycunata taporkan: —¿Imanasajtaj cay Cristo niska Jesuswanri? Tucuynincu wajach'acorkancu: —¡Chacataska cachun! —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato paycunata nillarkantaj: —¿Ima mana allintataj ruwan? Paycunataj sinchita wajach'acorkancu: —¡Chacataska cachun! —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato mana ima ruwayta atejtin, runacuna astawan astawan ch'ajwarachcarkancu. Chayraycu Pilato unuta apachicamuspa, tucuypaj ñaupakenpi maquincunata majchicorkan, nispa: —Cay runa wañunanmantaka mana noka juchayojchu cani, kancuna juchayoj canquichis. ");
INSERT INTO qulNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tucuy runacuna contestarkancu: —¡Wañuskan nokaycupaj wawaycupajpiwan juchaycu cachun! ");
INSERT INTO qulNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Chhicataj Pilato Barrabasta cachariporkan; Jesustataj sinchita bajtachispa, chacatanancupaj entregaporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Gobernajpaj soldadoncuna Jesusta aparkancu palacio gobierno wasiman. Chaypi tucuy soldadocuna tantacorkanu. ");
INSERT INTO qulNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","P'achanta orkhospa, uj morado katanata churaycorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Umanmantaj qhichcacunamanta ruwaska coronata churaycorkancu, paña maquinmantaj uj vara bastonta. Chaypacha ñaupakenpi konkoriycuspa burlacorkancu, nerkancutaj: —¡Judiocunapaj Reynin causachun! —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Payta thutkatarkancu, caskan vara bastonwantaj umapi c'uparkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Paymanta burlacuy pasayta, morado katanata orkhopuspa, quiquin p'achanta churaporkancu. Apaporkancutaj chacataska cananpaj. ");
INSERT INTO qulNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Chaymanta llojsipuspa, Cirene llajtayoj Simón sutiyoj runawan tuparkancu; obligarkancutaj Jesuspaj cruzninta apananpaj. ");
INSERT INTO qulNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Gólgota sutiyoj juch'uy loma pataman chayarkancu. (Gólgota niyta munan: “Calavera Lugar.”) ");
INSERT INTO qulNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Chaypitaj jayakewan chhajruskata c'allcu vinota Jesusman ujyacherkancu. Jesustaj malliycuspa, mana ujyayta munarkanchu. ");
INSERT INTO qulNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Chacataycuspañataj, soldadocuna sortearkancu Jesuspaj p'achanta partinacunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Chhicataj chaypi tiyaycuspa khawachcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Cruzpi, Jesuspaj uman patapi uj letrero escribiskata churarkancu: “Cayka Jesús, judiocunapaj Reynin” nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jesuswan cusca iscay suwacunata chacatallarkancutaj, ujninta pañannejpi ujnintataj llok'ennejpi. ");
INSERT INTO qulNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Chayninta pasajcuna umancuta maywispa, insultarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Nerkancutaj: —¡Kan, Diospaj templonta urmachispa quimsa p'unchaypi ruwarkoj, cunanka kan quiquiyqui salvacuy! ¡Diospaj Churin canqui chayka, chay cruzmanta urakay! ");
INSERT INTO qulNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ajinallatataj sacerdotecunapaj jefencuna, leymanta yachachejcuna, llajtapaj jefencunapiwan nerkancu: ");
INSERT INTO qulNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Wajcunata salvarkan, pay quiquintaj mana salvacuyta atinchu. Israelpaj Reynin chayka, cunanpacha cruzmanta urakamuchun, paypitaj creesunchis. ");
INSERT INTO qulNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Diosman atenicorkan. Cunanka Dios munacun chayka, cacharichun ari. ‘Diospaj Churin cani’ niwarkanchis. ");
INSERT INTO qulNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Jinallatataj Jesuswan cusca chacataska suwacunapas insultarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Chaupi p'unchaymanta chaupi tardecama tucuy cay pacha tutayaycorkan. ");
INSERT INTO qulNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Chaupi tardetataj, Jesús callpawan wajach'acuspa nerkan: “Elí, Elí, ¿lema sabactani?” (Chaytaj niyta munan: “Diosníy, Diosníy, ¿imaraycutaj sakerpariwanquiri?”) ");
INSERT INTO qulNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Waquin chaypi cajcuna uyarispa, nerkancu: —¡Uyariychis, Eliasta wajachcan! ");
INSERT INTO qulNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Chaypacha ujnin runa phawaspa, vinagreman esponjata chaporkan. C'aspiman churaycuspataj, korkan ch'umuycunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Waquincunataj nerkancu: —Dejallay. Ricusunchis, ichapas Elías jamuspa salvanka. ");
INSERT INTO qulNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesustaj callpawan wajach'acuspa, wañuporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Chaypacha templopi cortina iscayman lliq'icorkan, janajmanta urayman. Cay pacha qharcaterkan, kakacunataj partiracorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Sepulturacunapas quicharacorkancu. Diospi achqha creejcuna wañuskamanta causarimorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Paycunataj sepulturancunamanta llojsiramorkancu. Jesuspaj causarimuskan pasayta, Jerusalén santo llajtaman yaycorkancu. Chaypitaj achqha runacuna ricorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Capitán romano paywan cajcunapiwan Jesusta khawachcaspa, ricorkancu jallp'a qharcatejta, tucuy ima pasachcaskantawan. Sinchi manchariskataj nerkancu: —¡Ciertopuni cay runaka Diospaj Churin! ");
INSERT INTO qulNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Chaypitaj achqha warmicuna cachcarkancu carullamanta khawaspa. Paycunaka Galileamantapacha jamorkancu Jesusta yanapaspa. ");
INSERT INTO qulNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Paycuna uqhupitaj carkan María Magdalena, Santiagopaj Josepajpiwan maman María, Zebedeoj churincunapaj mamancupiwan. ");
INSERT INTO qulNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ch'isiyaycuchcajtinña, uj khapaj runa, Arimatea llajtayoj José jamorkan, creyentellataj Jesuspi. ");
INSERT INTO qulNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pilatoman jamuspa, Jesuspaj cuerponta mañarkan. Pilatotaj mandarkan konancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josetaj uj limpio fino sabanawan Jesuspaj cuerponta p'istuycorkan. ");
INSERT INTO qulNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Churaycorkantaj kaka jutc'uska mosoj sepulturapi. Puncunta athun rumiwan tapaycuspataj, puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Sepulturapaj ñaupakenpitaj María Magdalena waj Mariapiwan tiyachcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","K'ayantin, samana p'unchaypi, sacerdotecunapaj jefencuna fariseocunapiwan Pilatoman purerkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Nerkancutaj: —Señor, yuyariycu chay llulla runa causachcasparaj niskanta: ‘Quimsa p'unchaymanta causarisaj’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Chayraycu manday ari, quimsa p'unchaycama sepulturata allinta cuidanancupaj, discipuloncuna ama jamuspa ayata suwanancupaj. Chaymantataj nincuman: ‘Wañuskamanta causarimun’ nispa. Chay llullaka ñaupaj llullacuskanmanta nejtinpas astawan mana allinchu canman. ");
INSERT INTO qulNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatotaj paycunata nerkan: —Chay, cuidaj soldadocuna can. Puriychis, atiskayquichisman jina sepulturata seguramuychis. ");
INSERT INTO qulNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Paycunataj purispa, sepulturata allinta seguraycorkancu. Tapaska rumita selloycuspa, soldadocunata sakerkancu cuidachcajta. ");
INSERT INTO qulNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Samana p'unchay pasajtin, semana kallariy p'unchay sut'iyamuyta, María Magdalena, waj Mariapiwan purerkancu sepultura khawaj. ");
INSERT INTO qulNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Señorpaj angelnin janaj pachamanta uraycamuskanraycu, jallp'a sinchita qharcaterkan. Angeltaj sepulturaman chimpaycuspa, tapaska rumita tijrarpayarkan, chay patapitaj tiyaycorkan. ");
INSERT INTO qulNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Angel rayopaj c'anchaynin jina carkan, p'achantaj rit'i jina yuraj. ");
INSERT INTO qulNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Soldadocunataj chayta ricuspa, mancharicuymanta qharcaterkancu. Wañuska jina wijch'ucorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Angel warmicunaman nerkan: —Ama manchacuychischu. Yachani Jesusta masc'achcaskayquichista, chacataska carkan chayta. ");
INSERT INTO qulNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mana caypichu, niskanman jina causaripunña. Jamuychis, khawaycuychis maypichus Señor churaska carkan chayta. ");
INSERT INTO qulNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Puriychis, cunanpacha discipuloncunaman willamuychis: ‘Causarimpunña, ñaupakeyquichista Galileaman purenka. Chaypi ricunquichis.’ Chayta noka kancunaman ninay carkan. ");
INSERT INTO qulNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Warmicunataj sepulturamanta puriporkancu, manchariska cusiskataj. Phawarkancu discipuloncunaman willaj. ");
INSERT INTO qulNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Jina purichcajtincu, Jesús paycunaman riqhurispa, saludarkan. Paycunataj chimpaycuspa, Jesusta adorarkancu chaquincunata mark'aycuspa. ");
INSERT INTO qulNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesustaj paycunaman nerkan: —Ama manchacuychischu. Puriychis, waukeycunaman willamuychis: ‘Galileaman purichuncu, chaypi ricuwankacu.’ ");
INSERT INTO qulNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Warmicuna purichcajtillancuraj, sepulturata cuidaj waquin soldadocuna llajtaman purispa, sacerdotecunapaj jefencunaman willamorkancu tucuy cay pasaskanta. ");
INSERT INTO qulNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Chay jefecunataj waj jefencunawan parlaj purerkancu rimanacunancupaj. Soldadocunamantaj achqha kolketa korkancu. ");
INSERT INTO qulNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Nerkancutaj: —Kancunaka niychis: ‘Discipuloncuna tutapi jamuspa, Jesuspaj cuerponta suwancu puñuchcanaycucama’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Gobernaj chayta yachajtenka, nokaycu paywan parlasajcu mana imananasunquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Soldadocunataj kolketa jap'ekaytawan yachachiskancuman jina parlarkancu. Chay niskancoka cunan p'unchaycama judiocuna uqhupi willacun. ");
INSERT INTO qulNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Chunca ujniyoj discipuloncuna Galileaman purerkancu, Jesuspaj niskan lomaman. ");
INSERT INTO qulNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jesusta ricuytawan adorarkancu, waquincunataj iscayrayarkancu chaywanpas. ");
INSERT INTO qulNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesús paycunaman chimpaycuspa nerkan: —Dios tucuy atiyta kowan janaj pachapi cay pachapipas. ");
INSERT INTO qulNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Chayraycu tucuy nacioncunapi caj runacunaman puriychis. Willamuychis discipuloycuna canancupaj, Dios Tata, Dios Churi, Dios Santo Espiritupaj sutinpi bautizaspa. ");
INSERT INTO qulNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Kancunaman tucuy mandaskayta casucuyta yachachimuychis. Nokataj tuta p'unchay kancunawan cachcani cay pacha tucucunancama. Ajina cachun.");
INSERT INTO qulNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Diospaj Churin Jesucristomanta sumaj evangelio cay jinata kallarin. ");
INSERT INTO qulNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Diospaj profetan Isaías escriberkan Dios Churinta cachamunanmanta: “Kanmanta ñaupajta willajniyta cachamuni, runacunapaj sonkonta waquichinanpaj ñanta jina. ");
INSERT INTO qulNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ch'usaj lugarpi uj runa alto vozwan willaconka: ‘Señor jamuchcan. Sonkoyquichista waquichiychis recto ñanta jina.’ ” ");
INSERT INTO qulNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ajinata Juanka ch'usaj lugarpi bautizachcaspa willararkan: “Diosman cutiricuspa bautizachicuychis, juchayquichiscunata Dios perdonananpaj” nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Judeapi caj tucuy provinciamanta Jerusalén llajtamantapas achqha runacuna uyarej jamuchcarkancu. Juan juchancu willacojcunata bautizarkan Jordán mayupi. ");
INSERT INTO qulNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juanpaj p'achantaj camello millmamanta carkan, karamanta cinturonwan chumpiycuska, miqhunantaj langosta niska athun t'inticuna t'aja misq'ipiwan. ");
INSERT INTO qulNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Pay willarkan: “Khepayta jamuchcan nokamanta astawan atiyniyoj. Paypaj ñaupakenpi ni imapaschu cani, abarcanta pascaranallaypajpas. ");
INSERT INTO qulNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nokaka unullawan bautizachcayquichis. Paycajtaj Santo Espirituwan bautizasunquichis” nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Chay p'unchaycunapi Jesús Galileapi caj Nazaret llajtamanta llojserkan. Juantaj payta bautizarkan Jordán mayupi. ");
INSERT INTO qulNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Unumanta llojsiytawan, Jesús ricorkan janaj pacha quicharacuchcajta, Santo Espiritutataj paloma jina uraycamuchcajta. ");
INSERT INTO qulNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Diospaj voznin janaj pachamanta nimorkan: “Kan munaska Chureyka canqui, nokapaj ajllaskay.” ");
INSERT INTO qulNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Chay pasayta Santo Espíritu Jesusta ch'usaj lugarman pusarkan. ");
INSERT INTO qulNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Chaypi cachcarkan sajra animalcunawan tawa chunca p'unchayta. Supay Satanás tucuy imata ruwachcarkan Jesusta juchallichinanpaj, nitaj aterkanchu. Diospaj angelnincunataj Jesusta sirverkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Juan Bautistata carcelaycojtincu, Jesús Galilea provinciaman purerkan Diospaj evangelionta willananpaj. ");
INSERT INTO qulNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Nerkantaj: “Diospaj gobiernon kayllallapiña. Cunan Diospaj ajllaskan tiempo chayamunña. Chayraycu juchayquichiscunata sakespa Diosman cutiricuychis, paypaj evangelionta creeychis” nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesús Galilea kocha cantonta purichcaspa, Simonta paypaj wauken Andrestawan ricorkan. Paycunaka challwa jap'inancupaj llicata kochaman cachaycuchcarkancu, imaraycuchus challwiru carkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesustaj paycunata nerkan: —Nokawan puriychis, nokataj runacunata Diosman pusamojta ruwaskayquichis, imaynatachus challwata jap'ej cachcanquichis jinata. ");
INSERT INTO qulNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Chhicapacha llicancuta sakerpayaspa, Jesuswan puriporkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Uj chhicallantaraj ñauparispa, Jesús Zebedeopaj churincunata, Santiagota wauken Juantawan ricorkan. Botepi llicancuta jallch'aspa cachcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesustaj wajarkan discipuloncuna canancupaj. Ajinapi paycunaka tatancu Zebedeota llanc'ajcunatawan botepi sakepuspa, Jesuswan puriporkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesús discipuloncunawan Capernaum llajtaman chayarkan. Samana p'unchaypi Jesús sinagoga wasiman yaycuspa runacunata yachachiyta kallarerkan. ");
INSERT INTO qulNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Uyarejcunataj chay jina autoridadwan yachachiskanmanta muspharkancu, imaraycuchus leymanta yachachejcuna mana jinatachu yachacherkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Chay sinagoga wasipi uj runa carkan, paytaj sajra espirituyoj wajach'acorkan: ");
INSERT INTO qulNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¡Nazaret llajtayoj Jesús! ¿Imapaj meticuwanquichis? ¿Tucuchanawayquichispajchu jamunqui? Allinta rejsiyqui pichus caskayquita. Kanka Diospaj Santon canqui. ");
INSERT INTO qulNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús sajra espirituta c'amerkan: —¡Jup'allay! ¡Llojsiy paymanta! —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Sajra espiritutaj runata t'ucuta jap'icherkan. Sinchi callpawan wajach'acuspataj, paymanta llojsiporkan. ");
INSERT INTO qulNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tucuy ricojcunataj musphararkancu, tapunacorkancutaj: —¿Imataj cayri? ¡Sinchi autoridadwan yachachin! ¡Sajra espiritucunawanpas casuchicun! —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Chaypacha tucuy Galilea provinciapi Jesusmanta yachacorkan. ");
INSERT INTO qulNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesús sinagoga wasimanta llojsispa, Santiagowan Juanpiwan Simonpaj Andrespajwan wasinman purerkan. ");
INSERT INTO qulNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simonpaj suegran sinchi calenturawan puñunapi cachcarkan. Chayta Jesusman willarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesustaj onkoskaman chimpaycuspa, maquinmanta jap'ispataj, jataricherkan. Chhicapacha calenturamanta alliyaporkan, paycunatataj atendiyta kallarerkan. ");
INSERT INTO qulNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ch'isiyaycuytataj tucuy onkoskacunata sajra espirituyoj cajcunatawan Jesusman pusamorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Llajtapacha wasi puncuman tantacamorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesustaj achqhayojta tucuy ima onkoyniyojcunata alliyacherkan. Achqhayojmantataj sajra espiritucunata katerkorkan. Sajra espiritucunataj Jesusta rejserkancu. Chayraycu Jesús paycunata mana parlacherkanchu. ");
INSERT INTO qulNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tutapiraj Jesús jatarispa, ch'usaj lugarman oracionta ruwananpaj llojserkan. ");
INSERT INTO qulNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simontaj uj discipuloncunapiwan Jesusta masc'aj llojserkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Taripaspataj nerkancu: —Tucuy masc'achcasunquichis —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesustaj contestarkan: —Cay kaylla llajtacunaman purisunchis evangeliota willaraj. Chaypaj cay pachaman jamuni. ");
INSERT INTO qulNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ajinamanta Jesús tucuy Galileanejpi purichcaspa, sinagoga wasicunapi evangeliota willaraj, sajra espiritucunatapas katerkoj. ");
INSERT INTO qulNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Uj lepra onkoyniyoj runa Jesusman chimpaycuspa, konkoriycuspataj nerkan: —Munanqui chayka, onkoyniymanta alliyachiwayta atinqui —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús qhuyapayaspa llanqhaycorkan. Nerkantaj: —Munani. ¡Alliyaska cay! —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jesús chayta nejtin jina, alliyaporkan. ");
INSERT INTO qulNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesustaj cachapuspa, sinchita mandarkan: ");
INSERT INTO qulNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—¡Uyariy! Ama pimanpas cayta willanquichu. Jerusalenman puriy, sacerdotemantaj ricuchicamuy alliyaskaña caskayquita, limpiochacuna costumbreta ruwanayquipaj. Moisespaj mandacuskanman jina ofrendata apamuy, ajinapi tucuy yachanancupaj alliyaskaña caskayquita. ");
INSERT INTO qulNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Paytaj llojsiytawan, tucuynincuman willaracaporkan chay pasaskanta. Chayraycu Jesuska pacallamantaña llajtacunaman yaycoj, astawanpas ch'usaj lugarcunapi puriycachaj; chaywanpas runacunaka tucuynejmanta payman jamoj cancu. ");
INSERT INTO qulNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Khepantin p'unchaycuna Jesuska Capernaum llajtaman cutimorkan. Runacunataj wasipiña caskanta yachaytawan, ");
INSERT INTO qulNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","puncu jawanejpi achqhayoj tantaycucamorkancu. Chayraycu mana lugar carkanchu ni mayninta yaycunapaj. Jesustaj evangeliota willarkan. ");
INSERT INTO qulNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Jinata Jesús parlachcajtin, tawayoj uj such'uta wantuspa payta chayachimorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Achqha runa caskanraycu, Jesusman chimpaycuchiyta mana aterkancuchu. Chayraycu wasi patanta jutc'uspa, puñunapi such'uta cachaycorkancu Jesuspaj ñaupakenman. ");
INSERT INTO qulNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesustaj paycunapaj creeynincuta ricuspa such'uta nerkan: —Wawáy, juchayquicuna perdonaskaña. ");
INSERT INTO qulNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Leymanta yachachejcuna chaypi tiyarachcaspa, sonkoncupi pensachcarkancu: ");
INSERT INTO qulNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Imaraycutaj cay runa jinata parlayta atrevicunri? ¡Parlaskancunawan Diosta phiñachichcan! Dioslla juchataka perdonayta atin” nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesuska jinata pensaskancuta reparaspa nerkan: —¿Imaraycutaj jinata pensachcanquichis? ");
INSERT INTO qulNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Onkoskaman ninari ¿maykentaj astawan fácil: ‘Juchayqui perdonaskaña’, icha ‘Jatariy, puñunayquita okharispa puripuy’ ninachu? ");
INSERT INTO qulNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Noka ricuchiskayquichis Tataj Churenka atiyniyoj cay pachapi juchata perdonananpaj caskanta. Chhicataj such'uman nerkan: ");
INSERT INTO qulNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Kanta niyqui, jataricuy, puñunayquita okharispa wasiyquiman puripuy —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Chhicapacha tucuypaj ñaupakenpi such'oka jatariporkan, puñunanta okharispataj llojsiporkan. Tucuy runacunataj musphararkancu. Diosta alabaspataj nerkancu: —¡Ni jayc'aj cay jinata ricorkanchischu! ");
INSERT INTO qulNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesús Galilea kocha cantoman ujtawan purerkan. Runacuna payman chimpaycojtincu, yachacherkan. ");
INSERT INTO qulNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pasapuspataj, Alfeopaj churin Levita ricorkan Romapaj impuesto cobrana chhicapi tiyachcajta. Payta nerkan: —Jacu, nokawan puriy —nispa. Sayarispataj Levika Jesuswan puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Levipaj wasinpi Jesús discipuloncunapiwan miqhuchcarkancu; impuesto cobrajcunawan waj juchasapacunapiwan cusca tiyachcarkancu. Achqhayoj Jesusta katerkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Paycunawan miqhuchcajta ricuspataj, leymanta yachachejcuna fariseocunapas discipuloncunata taporkancu: —¿Imaraycutaj yachachejniyquichis impuesto cobrajcunawan juchasapacunapiwan miqhun? —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Chayta uyarispa, Jesús paycunaman nerkan: —C'uchicunaka medicotaka mana necesitancuchu, manachayri onkoskacunalla. Juchasapacunata wajaj jamuni, mana ‘sumaj cani’ nejcunatachu. ");
INSERT INTO qulNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Uj cuti Juan Bautistapaj fariseocunapajpiwan discipuloncuna ayunachcarkancu. Waquin runacunataj Jesusman purispa nerkancu: —Juanpaj fariseocunapajpiwan discipuloncuna ayunancu. ¿Imaraycutaj discipuloyquicunari mana ayunancuchu? ");
INSERT INTO qulNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Paycunamantaj Jesús contestarkan: —¿Atincumanchu ayunayta casamientoman invitaskacuna, novio paycunawan cachcajtinri? ");
INSERT INTO qulNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Chaywanpas tiempo jamonka novio paycunamanta kechuska cananpaj. Chhica ari, ayunankacu. ");
INSERT INTO qulNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Mana pipas mauc'a p'achataka mosojwan remendanchu, imaraycuchus mosoj remiendoka mauc'a p'achata astawan athunta lliq'ipunman. ");
INSERT INTO qulNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nitaj mosoj vinota mauc'a kara botaman jich'aycuncumanchu, imaraycuchus mosoj vinoka mauc'a botata t'ojachinman. Vinotaj jich'arparicuman, kara botapas lliq'icapunman. Chayraycu mosoj vinotaka mosoj karaman jich'aycuna. ");
INSERT INTO qulNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Samana p'unchay Jesús trigo chajra uqhunta purichcarkan. Discipuloncunataj purichcaspa, trigo urita pallayta kallarerkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Fariseocunataj Jesusta taporkancu: —Uyariy, ¿imaraycutaj discipuloyquicuna samana p'unchaypi chayta ruwachcancu? Chayka leyninchisman jina mana ruwanachu. ");
INSERT INTO qulNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesustaj nerkan: —¿Manachu jayc'ajpas leerkanquichis imatachus David compañancunapiwan yarekachicuspa ruwaskancuta? ");
INSERT INTO qulNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiatar curaj sacerdote cachcajtin, David Diospaj wasinman yaycuspa, Diospaj wakaychaska t'antata miqhorkan compañancunapiwan. Leyman jina chay t'antataka sacerdotecunalla miqhunancu carkan. ");
INSERT INTO qulNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesús fariseocunaman nillarkantaj: —Samana p'unchayka runaj allinninpaj churaska, mana runachu samana p'unchaypaj allinninpaj churaskaka. ");
INSERT INTO qulNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Chaypaj Tataj Churenka atiyniyojllataj samana p'unchaymantapas. ");
INSERT INTO qulNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesús ujtawan sinagoga wasiman yaycorkan. Chaypitaj uj ch'aquiska maquiyoj runa carkan. ");
INSERT INTO qulNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jesusta khawachcarkancu, “¿Samana p'unchaypi alliyachenkachu, manachu?” nispa, chayman jina juchachanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesús ch'aquiska maquiyoj runata nerkan: —Jatariy, chaupipi sayaycuy —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Taporkantaj ujcunata: —¿Imacajtataj ruwana samana p'unchaypi: allin cajtachu icha mana allin cajtachu? ¿Alliyachinachu icha jinallachu wañupunan? Paycunataj ch'inlla carkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jinataj Jesuska phiñaska paycunata khawarkan, llaquiskataj chay rumi sonko runacuna mana entendiyta munaskancumanta. Ch'aquiska maquiyoj runatataj nerkan: —Maquiyquita jaywariy —nispa. Maquinta jaywarejtintaj, alliyaska caporkan. ");
INSERT INTO qulNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Chaymanta fariseocuna llojsipuspa, Herodespaj partidonpi cajcunawan yachachinacorkancu Jesusta imaynata wañuchinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Galileamanta achqha runa katejtincu, Jesús discipuloncunawan puriporkan Galilea kocha cantoman. ");
INSERT INTO qulNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jesuspaj athun milagrocuna ruwaskanta yachaspa, achqhayoj khawaj jamorkancu Judeamanta, Jerusalenmanta, Idumeamanta, Tiromanta, Sidonmanta, inti llojsimuy mayu lado Jordanmantawan. ");
INSERT INTO qulNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Chayraycu Jesús discipuloncunata nerkan: —Uj boteta waquichiychis, cay achqha runa mana mat'iycamunawancupaj —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jesús achqhayojta alliyacherkan; chayraycu tucuy onkoskacuna chimpaycorkancu payta llanqhaycunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Sajra espiritucuna Jesusta ricuspa, ñaupakenpi konkoriycuspa wajach'acorkancu: —¡Kan Diospaj Churin canqui! —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesustaj sajra espiritucunata c'amerkan mana jinata parlanancupaj tucuynincupaj ñaupakenpi. ");
INSERT INTO qulNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesús lomaman llojsispa, picunatachus apostolninpaj munarkan chaycunata wajarkan ajllananpaj. Paywan tantaycucojtincu, ");
INSERT INTO qulNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","chunca iscayniyojta ajllarkan paywan canancupaj, evangeliota willarajta cachananpaj. Chaycunaman suticharkan apostolta. ");
INSERT INTO qulNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Atiyninta korkan sajra espiritucunata katerkonancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Caycunaka cancu chay chunca iscayniyoj: Simón, Pedro niska; ");
INSERT INTO qulNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedeopaj churincuna Santiago Juanpiwan, paycunata Boanerges nispa suticharkan, (niyta munan: “Rayo Suenaypaj Churincuna”); ");
INSERT INTO qulNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés, Felipe, Bartolomé, Mateo, Tomás, Alfeopaj churin Santiago, Tadeo, cananista partidomanta Simón, ");
INSERT INTO qulNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Jesusta vendiycoj Judas Iscariotepiwan. ");
INSERT INTO qulNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jesús discipuloncunapiwan uj wasiman puriporkancu. Ujtawan achqha runa tantaycucamorkancu. Chayraycutaj ni miqhuytapas aterkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jesuspaj parientencunataj ima pasachcaskanta yachaytawan, Jesusta pusapoj jamorkancu, locoyapuskanta pensaspa. ");
INSERT INTO qulNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Leymanta yachachejcuna Jerusalenmanta jamuspa Jesusmanta nerkancu: “Beelzebú niska supay, sajra espiritucunapaj jefen, cay runamanka atiyninta kon, waj sajra espiritucunata katerkonanpaj” nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesús paycunata wajarkan, uj ejemplowan entendichinanpaj: “¿Imaynatataj supay Satanasri quiquin supay Satanasta katerkonman? ");
INSERT INTO qulNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Uj nacionpi caj runacuna uj ujcuna contra achqhaman partiska cajtincoka, chay nacionka mana astaqui canmanchu. ");
INSERT INTO qulNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ajinallatataj uj wasipi familiantin chejninacuspaka, mana astaqui junto cancumanchu. ");
INSERT INTO qulNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ajinallatataj supay Satanaspas iscayman tucunman chayka, mana atiynin canmanchu, tucucapunman. ");
INSERT INTO qulNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Ni pipas uj callpayoj runapaj wasinman yaycunmanchu cajnincunata kechunanpaj, mana payta ñaupajta wataycuspaka. Chaymantaraj cajnincunata kechuyta atinman. ");
INSERT INTO qulNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Segurayquichis, Dios runataka perdonanman tucuy juchanmanta mana allin niskancunamantawan. ");
INSERT INTO qulNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Chaywanpas Santo Espíritu contra parlajtaka ni jayc'aj perdonankachu, manachayri wiñaypaj castigaska canka.” ");
INSERT INTO qulNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ajinata Jesús nerkan, imaraycuchus paycuna nerkancu Jesusta sajra espirituyoj nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesuspaj maman waukencunapiwan jawallaman chayamuspa, Jesusta wajacherkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jesuspaj muyuntinpi tiyarachcajcunataj willarkancu: —Mamayqui waukeyquicunapiwan jawapi cachcancu, masc'achcasunquichis. ");
INSERT INTO qulNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesustaj contestarkan: —¿Picunataj cancu mamay waukeycunari? ");
INSERT INTO qulNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Paypaj muyuntinpi tiyarachcajcunata khawarispataj nerkan: —Mamayka waukeycunapas caycunami. ");
INSERT INTO qulNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Pillapas Diospaj munayninta ruwajlla waukey, panay, mamaypas. ");
INSERT INTO qulNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ujtawan Jesús Galilea kocha cantopi yachachiyta kallarerkan. Chayman achqha runa tantacorkancu Jesuspaj parlaskanta uyarinancupaj. Chayraycu Jesús boteman yaycuspa tiyaycorkan. Runacunataj kocha cantopi quedacorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jesús ejemplocunawan achqha imacunata yachachichcaspa, nerkan: ");
INSERT INTO qulNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Uyariychis: Uj runa llojserkan tarpoj. ");
INSERT INTO qulNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tarpuchcajtintaj, waquin mujucuna ñan pataman t'acacorkan. Pisketocunataj chayamuspa pallacaporkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Waquintaj pisi jallp'ayoj rumi pampaman t'acacorkan. Rato wiñarimorkan chaywanpas, ");
INSERT INTO qulNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","rumi uqhupi mana saphichayta atiskanraycu, ruphay ch'aquichiporkan. ");
INSERT INTO qulNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Waquintaj qhichca uqhuman t'acacorkan. Qhichcacunataj wiñarispa sipiycorkan. Ajinapi mana urerkanchu. ");
INSERT INTO qulNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Waquin mujucajtaj sumaj jallp'aman t'acacorkan. Chay mujucunataj allinta wiñarkancu. Urerkancutaj sumajta: waquin quimsa chuncata, waquin sojta chuncata, waquintaj pachajta.” ");
INSERT INTO qulNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jesús nillarkantaj: “¡Uyarejcunaka, entendiychis!” nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Chhicamantataj Jesús sapan cachcajtin, chaypi caj runacuna chunca iscayniyoj discipuloncunapiwan taporkancu: “Chay ejemplo, ¿ima niytataj munan?” nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesustaj contestarkan: “Kancunamanka Diospaj gobiernonmanta sut'inchasunquichis mana yachaskacunata. Wajcunacajmantaj ejemplocunallawan tucuy imata parlachcani, ");
INSERT INTO qulNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","khawachcaspa mana ricunancupaj, uyarichcaspapas mana entendinancupaj, ni Diosman cutirinancupaj, nitaj perdonaska canancupaj.” ");
INSERT INTO qulNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesús discipuloncunata nerkan: “¿Manachu cay ejemplota entendinquichis? ¿Imaynatataj, ari, waj ejemplocunata entendiwajchis? ");
INSERT INTO qulNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Chay tarpojka Diospaj palabranta willaj. ");
INSERT INTO qulNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ñan pataman caj mujoka cay runacuna jina: Diospaj palabranta uyarejtincu jina, supay Satanás jamuspa uyariskancuta sonkoncumanta orkhopun. ");
INSERT INTO qulNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Rumi chaupipi pisi jallp'api tarpuska muju jina cajcunataj Diospaj palabranta uyarispa cusicuywan jap'ekancu. ");
INSERT INTO qulNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Mana saphiyoj jina caspataj, uj ratollapaj Diospaj palabranta creencu. Pruebacuna chejnicuycunapiwan jamojtintaj, creeynincuta chincachicapuncu. ");
INSERT INTO qulNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Qhichca uqhupi caj muju jina cajcunataj Diospaj palabranta uyarispa, ");
INSERT INTO qulNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","negocioncupi kolketa ganayta sinchita pensaspa, imaymanacunawan khapajyayta munaspa, engañaska cancu. Tucuy chaycunawantaj Diospaj palabranta konkapuncu, manataj urincuchu. ");
INSERT INTO qulNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Sumaj jallp'api caj muju jina cajcunacajtaj Diospaj palabranta uyarispa, sumajta jap'ekancu. Imaynatachus uj mujoka quimsa chuncata urin, waquintaj sojta chuncata, waquintaj pachajta, ajinallatataj cay sumaj jallp'api caj muju jina runacunaka sumajta urincu.” ");
INSERT INTO qulNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesús nillarkantaj: “C'anchayta jap'ichispaka, mana mesa uqhumanchu churancu, nitaj catre uqhumanchu, manachayri alto pataman, tucuyta c'anchananpaj. ");
INSERT INTO qulNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Jinallatataj tucuy pacaska cajka yachaconka, sut'inchaconkataj. ");
INSERT INTO qulNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kancuna, uyarejcuna, entendiychis.” ");
INSERT INTO qulNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jesús nillarkantaj: “Allinta uyariychis. Kancuna ima medidawanchus ujcunata midinquichis, chay medidallawantaj Dios midisunquichis, astawan yapaskataraj. ");
INSERT INTO qulNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Diospaj palabranta entendejka astawan entendenka. Mana entendejmantataj pisi entendiskanpas kechuska canka” nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesús nillarkantaj: “Diospaj gobiernonka mujuta tarpoj runaman rijch'acun. ");
INSERT INTO qulNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tarpoj puñuchcajtinpas rijch'achcajtinpas, quiquillantataj p'unchaypipas tutapipas mujoka wiñachcan. Tarpojtaj ni yachanchu imaynata muju wiñamuskanta. ");
INSERT INTO qulNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Jallp'aka payllamanta wiñachimun. Ñaupajtaka wiñan, chaymanta t'ican, llulluspataj uriycun. ");
INSERT INTO qulNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Uri pokojtintaj, runaka pallapun, imaraycuchus ajthapina tiempo chayamunña.” ");
INSERT INTO qulNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesús nillarkantaj: “¿Imamantaj rijch'acunman Diospaj gobiernonri? ¿Imawantaj rijch'achiyman? ");
INSERT INTO qulNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Jallp'api tarpuska mostaza mujuwan. Chay mujoka astawan juch'uycito tucuy mujumanta nejtenka. ");
INSERT INTO qulNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Chaywanpas tarpuskaña cajtenka, athunta wiñan. Astawan athunta ramachacun huertapi caj tucuy sach'acunamanta nejtinpas. Pisketocunapas ramancunapi tapachacuncu.” ");
INSERT INTO qulNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Achqha cay jina ejemplocunawan Jesús evangeliota yachacherkan maycamachus entendiy atinancucama. ");
INSERT INTO qulNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ejemplocunallawan yachachej; discipuloncunacajllaman tucuy imata sut'inchaj. ");
INSERT INTO qulNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Chay p'unchay ch'isiyaycojtintaj, Jesús discipuloncunaman nerkan: —Jacuchis kocha chimpaman —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Discipuloncuna runacunata sakespa Jesusta pusaporkancu tiyachcaskan botepi. Waj botecunapas compañallarkancutaj. ");
INSERT INTO qulNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Purichcajtincu, sinchi athun wayra jatarispa unuta boteman junt'aycuchimorkan. ");
INSERT INTO qulNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesustaj sanwanapi k'emiycucuspa botepaj khepannejpi puñuchcarkan. Rijch'arichispa nerkancu: —¡Yachachej! ¡Unuman chincaycuchcanchisña! ¿Manachu importasunqui? —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Paytaj rijch'arispa wayrata c'amerkan: —¡Amaña wayraychu! —nispa Kochatataj nerkan: —¡Ama khallacuychu! —nispa. Manañataj wayrarkanchu, kochapas manaña khallacorkanchu. ");
INSERT INTO qulNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Discipuloncunamantaj nerkan: —¿Imaraycutaj mancharicunquichisri? ¿Manarajchu creeyniyoj canquichis? —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Paycunataj sinchita mancharicuspa, ninacorkancu: —¿Imayna runataj cayri? Wayrapas kochapas c'amejtin, payta casuncu —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kocha chimpa Gerasa jallp'aman puriporkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesús botemanta urakajtin jina, uj sajra espirituyoj runa payman chimpaycorkan. Cay runa panteonmanta llojsimuska, ");
INSERT INTO qulNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","imaraycuchus chaypi tiyachcarkan. Ni pi sujetayta aterkanchu ni cadenawanpas. ");
INSERT INTO qulNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Achqha cutiña maquincunata chaquincunatapiwan cadenacunawan watarkancu. Paytaj t'ipiraj ñut'uta. Ni pipas dominayta aterkanchu. ");
INSERT INTO qulNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tuta p'unchay panteonpi lomacunapipas kaparispa puriycachaj, rumicunawan pay quiquin tacacuspa. ");
INSERT INTO qulNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Carumanta Jesusta ricuytawan, sajra espirituyoj runaka phawaspa jamorkan, Jesuspaj ñaupakenpitaj konkoriycorkan. ");
INSERT INTO qulNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Wajach'acuspa nerkan: —¡Sinchi athun Diospaj Churin Jesús, ama meticuwaychu! ¡Diospaj sutinpi mañacuyqui, ama ñac'arichiwaychu! ");
INSERT INTO qulNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ajinata chay runa nerkan Jesuspaj mandacuskanraycu: —¡Sajra espíritu, llojsiy cay runamanta! ");
INSERT INTO qulNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesustaj payta taporkan: —¿Imataj sutiyqui? —nispa. Contestarkantaj: —Legión suteyka, imaraycuchus achqhayoj caycu. ");
INSERT INTO qulNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Chay sajra espiritucunaka Jesusmanta mañacuchcarkancu: —Ama katerkowanquichischu cay jallp'amanta —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kaylla lomapi achqha qhuchicuna korata miqhuchcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Sajra espiritucunataj Jesusmanta mañacorkancu: —Qhuchicunaman yaycojta dejawaycu. ");
INSERT INTO qulNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesús permisota kojtin, sajra espiritucuna runamanta llojsispa, qhuchicunaman yaycurarkancu. Iscay waranka qhuchicuna carkancu. Chaycunataj sayaj khata patamanta kochaman chhokaycucorkancu. Chaypitaj miquicuspa, wañuporkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Qhuchi michejcunataj escapaspa, ima pasaskanmanta willamorkancu llajtapi caj runacunaman campopi cajcunamanpas. Runacunataj jamorkancu, ima pasaskanta ricunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesusman chayaspa, chay achqha sajra espirituyoj runata ricorkancu, p'achayojta, sumaj yuyayninpi tiyacuchcajta. Chayta ricuspataj, mancharicorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Chay ricojcunataj willararkancu chay sajra espirituyoj runamanta qhuchicunamantapiwan ima pasaskanta. ");
INSERT INTO qulNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Chhicamanta Jesusta rogayta kallarerkancu jallp'ancumanta ripunanta. ");
INSERT INTO qulNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesús boteman cutimojtin, chay sajra espiritucunamanta libraska runaka rogarkan, Jesuswan puripunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesustaj quedacunanpaj mandaspa, nerkan: —Wasiyquiman puripuy, parienteyquicunaman willaramuy tucuy imata Señorpaj kanwan ruwaskanta, imaynatachus Dios kanta qhuyapayaskanta. ");
INSERT INTO qulNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Runataj puriporkan; Decápolis niska llajtacunanejpi cajcunaman willararkan Jesús payta alliyachiskanta. Tucuy runacunataj musphararkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ujtawan Jesús botepi chimpajtin, kocha cantopi cachcajtin, payman achqha runacuna tantaycucamorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Chaypi cachcajtin, sinagogapaj uj jefen chayarkan, Jairo sutiyoj. Jesusta ricuspa ñaupakenpi konkoriycucorkan. ");
INSERT INTO qulNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Sinchita rogacorkan: —Ususiy wañunayapuchcan. Jamuy, maquiyquita payman churaycuripuway alliyaspa causananpaj. ");
INSERT INTO qulNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesús paywan purichcajtin, achqha runa katicorkancu, mat'iycorkancutaj muyuntinmanta. ");
INSERT INTO qulNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Chay achqha runa uqhupi uj warmi cachcarkan, chunca iscayniyoj wataña yawar apaywan onkoska. ");
INSERT INTO qulNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Achqha medicocunawan jampichicuspa, tucuy cajninta gastaska tucuchanancama; chaywanpas mana alliyaskachu, astawan sinchiyaporkan, sinchita ñac'ariska. ");
INSERT INTO qulNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Chay warmi Jesusmanta uyarispa, runacuna uqhupi jamorkan. Khepannejmanta chimpaycuspataj, Jesuspaj p'achanta llanqhaycorkan. ");
INSERT INTO qulNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Imaraycuchus pensarkan: “Sichus p'achallantapas llanqhaycusaj chayka, alliyachiska casaj” nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Chhicapacha reparacorkan yawar apay onkoymanta alliyapuskanta. ");
INSERT INTO qulNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesustaj reparacorkan atiyninwan uj runata alliyachiskanta. Khepanejta khawarispataj taporkan: —¿Pitaj p'achayta llanqhaycuwan? —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Discipuloncunataj payta nerkancu: —Khawariy, achqha runa tucuynejmanta mat'iycuchcasunquichis, kantaj tapucunqui: ‘¿Pitaj llanqhaycuwan?’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesustaj tucuynejta khawarichcarkan, payta llanqhaycojta ricunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Alliyachiskaña caskanta yachaspa, manchacuymanta qharcatispataj, chay warmeka Jesuspaj ñaupakenpi konkoriycucorkan. Chaymantataj imaynachus caskanta willarkan. ");
INSERT INTO qulNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesustaj nerkan: —Wawáy, creeskayquiraycu alliyachiska canqui. Puripuy sonko tiyaycuska, alliyachiskaña canqui. ");
INSERT INTO qulNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesús parlachcajtinraj, sinagogapaj jefen Jairopaj wasinmanta willaj jamorkancu: —Ususiyqui wañupunña. ¿Imapajñataj yachachejta molestanqui? —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Chay niskancuta uyarispa, Jesús Jairoman nerkan: —Ama manchacuychu. Creellay —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jesuska ujcunata sakerpayaspa, Pedrota, Santiagota, Santiagopaj wauken Juantapiwan pusarkan. ");
INSERT INTO qulNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Sinagogaj jefenpaj wasinman chayaspa Jesús ricorkan runacunata ch'ajwarachcajta, llaquiska wakarachcajta, kaparichcajta ima. ");
INSERT INTO qulNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yaycuspataj paycunaman nerkan: —¿Imaraycutaj cay jinata ch'ajwanquichis, wakanquichistaj? Chay wawaka mana wañuskachu, puñuchcallan —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Chay niskanmanta Jesusta asipayarkancu. Jesustaj tucuyta jawaman katerkospa, tata mamanta quimsantin discipuloncunatawan pusaycorkan wañuskapaj cuartonman. ");
INSERT INTO qulNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Maquinmanta jap'iycuspa, nerkan: —Talita, cumi —nispa. (Cayka niyta munan: “Juch'uycita, kanta niyqui, jatariy.”) ");
INSERT INTO qulNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Chhicapacha juch'uycitaka jatariporkan purerkantaj. Chunca iscayniyoj watayoj carkan. Runacunataj musphararkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesustaj paycunata sinchita mandarkan caymanta ni piman willanancuta. Chaymanta mandarkan juch'uycitaman miqhunata konancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesús discipuloncunawan Nazaretman cutiporkan. ");
INSERT INTO qulNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Samana p'unchay sinagoga wasipi yachacherkan. Achqha uyarejcunataj muspharaspa nerkancu: —Cay runari, ¿maypitaj chay tucuyta yachakan? ¿Maymantataj cay yachaynincunari milagrocuna ruwaskanpas? ");
INSERT INTO qulNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Manachu cay runaka carpintero, Mariapaj churin? Waukencunataj Santiago, José, Judas, Simón, panancunapas caypi nokanchiswan tiyancu. Chayraycu Jesusta mana casurarkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesustaj nerkan: —Diosmanta willaj profetataka tucuynejpi sumajta jap'ekancu, manataj quiquin llajtanpi cajcunaka, ni parientencunapas, ni wasinpi cajcunapas. ");
INSERT INTO qulNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Mana creeskancuraycu chaypeka mana achqha milagrocunata ruwayta aterkanchu, astawanpas waquin onkoskallata alliyacherkan maquinta paycunaman churaspa. ");
INSERT INTO qulNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesuska muspharkan paypi mana creeskancumanta. Kaylla llajtacunanejman purispa, yachachichcarkan. ");
INSERT INTO qulNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesús chunca iscayniyoj discipuloncunata wajaspa, iscaymanta iscay cachayta kallarerkan. Paytaj atiyta korkan sajra espiritucunata katerkonancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Paycunatataj mandarkan ñannincupaj mana apanancuta miqhuna apana saquillata, ni t'antata, ni kolketa, manachayri uj bastonllata. ");
INSERT INTO qulNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Churacunancu abarcatawan, manataj cambiacunapaj p'achata apanancuchu. ");
INSERT INTO qulNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nerkantaj: —Mayken wasimanpas chayaspaka, chayllapi quedacuychis waj llajtaman pasapunayquichiscama. ");
INSERT INTO qulNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mayllapipas mana jap'ekayta ni uyariyta munasunquichischu chayka, chay lugarmanta llojsipuychis. Chaquiyquichispi caj polvotapas thalaraychis paycuna contra, mana allin caskancuta ricuchinayquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Discipuloncunataj llojsispa willararkancu: —Juchayquichiscunata sakespa, Diosman cutiricuychis —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Achqha sajra espiritucunata katerkorkancu. Achqha onkoskacunatapas aceitewan jawispa alliyacherkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Tucuynejpi caj runacunapaj Jesusmanta parlaskancuta uyarispa, gobernaj Herodes nerkan: —Juan Bautista causarimun. Chayraycu atiyniyoj chay milagrocunata ruwananpajka. ");
INSERT INTO qulNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ujcunataj nerkancu: —Profeta Eliasmi cayka. Ujcunataj nerkancu: —Payka Diosmanta willaj ñaupaj profetacuna jina. ");
INSERT INTO qulNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodes paymanta uyarispa nerkan: —Uman cuchokachiskay Juan cunanka causarimun —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Chayta nerkan, imaraycuchus payka Juan Bautistata jap'ichispa cadenawan watachispa, carcelman churacherkan Herodías niska warminpaj causanraycu. Chay Herodiaska Herodespaj wauken Felipepaj warmin carkan. Chay cuñadanwantaj Herodeska casaracorkan. ");
INSERT INTO qulNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Juanka Herodesman niska: “Mana waukeyquipaj warminwan tiyayta atinquichu” nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Chayraycu Herodías Juanta chejnerkan, wañuchiytataj munachcarkan, nitaj aterkanchu. ");
INSERT INTO qulNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodes yacharkan Juan uj sumaj justo santo runa caskanta. Chayraycu Juanta manchacorkan, manataj munarkanchu warmin Herodías Juanta wañuchinanta. Herodeska iscayrayachcaspapas, ganaswan Juanta uyarej. ");
INSERT INTO qulNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodeska p'unchayninpi achqha miqhunata waquicherkan fiestata ruwananpaj. Wajarkan mandacojnincunata, comandantencunata, Galilea provinciapi caj jefe cajcunatawan. Chay p'unchaypi Herodiaspaj suyaskan tiempoka chayamorkan. ");
INSERT INTO qulNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodiaspaj ususin fiestaman yaycuspa paycunapaj tusorkan. Tususkantaj Herodesman paywan cajcunamanpas sinchita gustarkan. Chayraycu Herodeska sipasman nerkan: —¿Imatataj munanqui? Mañacuskayquita koskayqui. ");
INSERT INTO qulNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ujtawan ujtawan jurarkan ima mañacuskanpas koska cananta, gobernaskan nacionpaj cuscannintapas. ");
INSERT INTO qulNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Sipastaj llojsispa mamanta tapumorkan: —¿Imatataj mañacuyman? —nispa. Mamanri nerkan: —Juan Bautistapaj umanta mañacuy —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Chaypacha sipaska cutirispa, Herodesmanta mañacorkan: —Munani cunanpacha Juan Bautistapaj umanta uj platopi konawayquita —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herodestaj sinchita llaquicorkan. Chaywanpas tucuy invitaskacunapaj ñaupakenpi juramentowan prometicuskanraycu, mana aterkanchu “mana” niyta. ");
INSERT INTO qulNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Chhicapacha uj soldadota carcelman cacharkan Juanpaj umanta apamunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Soldadotaj purispa Juanpaj umanta cuchokamorkan. Platopi apamuspataj, sipasman korkan, paytaj mamanman. ");
INSERT INTO qulNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Juanpaj discipuloncuna chayta uyarispa, jamorkancu ayata apaj p'ampampunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Chay pasayta, Jesuspaj apostolnincuna cutimuspa Jesuswan tantaycucorkancu tucuy ruwaskancumanta yachachiskancumantawan willanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesustaj nerkan: —Jamuychis. Jacu purisunchis ch'usaj lugarman samaricoj. Ni miqhunancupaj tiemponcu carkanchu, imaraycuchus achqha runa jamuchcarkancu, purichcarkancutaj. ");
INSERT INTO qulNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Chhicataj Jesús apostolnincunawan uj botepi waj chhicaman puriporkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Chaywanpas achqhayoj puripuchcajta ricorkancu, Jesusta rejserkorkancutaj. Chhicataj tucuy llajtacunamanta jakaynejman phawararkancu. Chayarkancutaj, manaraj Jesús discipuloncunapiwan chayachcajtincu. ");
INSERT INTO qulNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesús botemanta llojsispa, achqha runata ricorkan. Paycunata qhuyapayarkan, mana michejniyoj ovejacuna jina caskancumanta. Achqhamantataj yachachiyta kallarerkan. ");
INSERT INTO qulNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ch'isiyaycuytataj discipuloncuna Jesusman chimpaycuspa nerkancu: —Ch'isiña, nitaj pipas tiyanchu cay lugarpeka. ");
INSERT INTO qulNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Runacunata cachapullayña kayllapacha wasicunaman llajtitacunamanpas miqhunata ranticamunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesustaj nerkan: —Kancuna miqhunata koychis —nispa. Paycunataj nerkancu: —¿Nokaycu rantej purinaycutachu munanqui? Miqhunata konapajka achqha kolke munacun, iscay pachaj p'unchaypi ganaska kolke jina. ");
INSERT INTO qulNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesustaj taporkan: —¿Jayc'a t'antataj capusunquichis? Khawarimuychis. Yachaspataj willarkancu: —Phichka t'anta iscay challwitapiwan. ");
INSERT INTO qulNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Chaymanta Jesús mandarkan chay achqha runa grupo grupo tiyarananpaj, pasto patapi. ");
INSERT INTO qulNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ajinamanta tiyaycorkancu, waquin grupocuna pachajniyoj, waquin phichka chuncayoj. ");
INSERT INTO qulNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesustaj chay phichka t'antata chay iscay challwitatawan jap'ekaspa, janaj pachata khawarispa Diosman graciasta korkan. T'antata partispa, discipuloncunaman jaywarkan runacunaman jaywaranancupaj. Ajinallatataj challwitata partispa kollarkantaj. ");
INSERT INTO qulNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tucuynincu miqhorkancu sajsanancucama. ");
INSERT INTO qulNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Chay partiska t'antacunamanta challwitacunamantawan puchojcunata chunca iscayniyoj canasta junt'ata okharerkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Miqhojcunataj phichka waranka kharicuna carkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Chaymanta Jesús discipuloncunata boteman yaycucherkan Betsaida llajtaman purinancupaj. Kocha chimpaman paymanta ñaupajta purinancuta munarkan, chay achqha runata cacharpayachcanancama. ");
INSERT INTO qulNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Cacharpayaspataj, Jesús lomaman llojsiporkan oración ruwaj. ");
INSERT INTO qulNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tutayaycuytataj discipuloncuna botepi cachcarkancu kocha chaupipiña; Jesustaj sapallan lomapi cachcarkan. ");
INSERT INTO qulNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ricorkantaj paycunata tucuy callpancuwan palawan unuta khachichcajta sayc'unancucama, imaraycuchus paycunanejman sinchita wayramorkan. Pakariyayta Jesús unu patanta purispa paycunaman chimpaycorkan. Pasarpayachcarkantaj ladoncuta. ");
INSERT INTO qulNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Unu patanta purichcajta ricuspa, discipuloncuna creerkancu cucuchi caskanta. Chayraycu wajach'acorkancu, ");
INSERT INTO qulNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","imaraycuchus tucuynincu payta ricuspa mancharicorkancu. Jesustaj paycunata parlapayaspa nerkan: —¡Callpachacuychis! ¡Noka cani, amaña manchacuychischu! ");
INSERT INTO qulNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jesús boteman yaycojtin jina, manaña wayrarkanchu. Paycunataj sinchita muspharkancu, ");
INSERT INTO qulNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","imaraycuchus miqhuna koskan milagrota ricuspapas, Jesusmanta mana entenderkancuchu, yuyaynincu ayphayaska caskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kochata chimpaspa, Jesús discipuloncunawan Genesaret jallp'aman chayarkan. Kocha cantopitaj boteta watarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Botemanta urakajtincu jina, Jesusta rejserkorkancupacha. ");
INSERT INTO qulNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Jinataj tucuynejmanta purispa, puñunacunapi onkoskacunata apamuyta kallarerkancu Jesús cachcaskan lugarman. ");
INSERT INTO qulNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Estanciacunaman, llajtacunaman, campocunamanpas mayllamanpas pay chayajtin, onkoskacunata apamuspa callecunapi churaj cancu. Jesusmantataj mañacoj cancu p'acha cantollantapas llanqharinancupaj. Tucuy llanqhaycojcunataj alliyaska carkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Fariseocuna waquin leymanta yachachejcunapiwan Jerusalenmanta chayaspa, Jesusman chimparkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Paycuna ricorkancu Jesuspaj waquin discipuloncuna mana maquincuta mayllacuspa miqhuskancuta. Ajinapitaj judiocunapaj costumbrencuta mana casorkancuchu. Chayraycu discipulocunapaj rimarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Fariseocuna tucuy judiocunapiwan abueloncunapaj costumbrencuta casucuspa, mana imatapas miqhojchu cancu maquincuta costumbrencuman jina mana mayllacuspaka. ");
INSERT INTO qulNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Mercadomanta cutimuspa, mana miqhojchu cancu maquincuta mana mayllacuspaka. Ajina achqha costumbrecuna carkan: vasocuna mayllana, jarro mayllana, fierro mancacuna mayllana, catrepas mayllana.) ");
INSERT INTO qulNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Chayraycu fariseocuna leymanta yachachejcunapiwan Jesusta taporkancu: —¿Imaraycutaj discipuloyquicuna abuelonchiscunapaj costumbrenta mana casucuncuchu? ¿Imaraycutaj miqhuncu mana maquincuta mayllacuspari? ");
INSERT INTO qulNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesustaj paycunata nerkan: —¡Iscay uya runacuna! Profeta Isaías kancunamanta escribispa allinta nerkan: ‘Cay runacuna simillancuwan alabawancu. Sonkoncutaj carupi nokamanta cachcan. ");
INSERT INTO qulNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Imapajpas sirvinchu culto ruwawaskancoka, yachachiskancutaj runacunapaj mandacuskallan.’ ");
INSERT INTO qulNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kancunaka Diospaj mandacuskanta mana casucunquichischu, runacunapaj costumbrellanta ruwanayquichisraycu. ");
INSERT INTO qulNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Nillarkantaj: —Costumbreyquichiscunapi purinayquichispaj, mana Diospaj mandacuskantaka casucunquichischu. ");
INSERT INTO qulNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moiseska nerkan: ‘Tata mamayquita respetay.’ Nillarkantaj: ‘Tatantapas chayri mamantapas mana respetaspa maldicejka, wañuchun’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kancunataj ninquichis, uj churi tatanta chayri mamantapas ninman: ‘Mana imawanpas yanapayquimanchu; tucuy capuyneyka corbán’ nispa. (Corbán niyta munan: “Diosman ofreciskaña.”) ");
INSERT INTO qulNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kancunaka yachachinquichis pipas chayta nispa nejka, tatanta chayri mamantapas yanapananpaj mana obligaska caskanta. ");
INSERT INTO qulNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Chaywantaj Diospaj mandacuskanta mana valorniyojman tucuchinquichis. Chay costumbrecunallatataj wawayquichiscunaman yachachinquichis. Achqha chay jina costumbrecunatataj ruwanquichis. ");
INSERT INTO qulNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesús runacunata wajaspa nerkan: —Tucuyniyquichis uyariwaychis, entendiwaychistaj. ");
INSERT INTO qulNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Runataka sonkonmanta llojsej khellichan, manataj ni ima miqhuy siminta yaycojchu. ");
INSERT INTO qulNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","¡Uyarejcunaka, entendiychis! —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesús runacunata sakespa, wasiman yaycorkan. Chaypitaj discipuloncuna chay yachachiskanmanta taporkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesustaj nerkan: —¿Kancunapas manachu entendinquichis miqhuna mana khellichaskanta? ");
INSERT INTO qulNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Mana khellichayta atinchu, imaraycuchus mana sonkonmanchu yaycun, manachayri wijsallaman, chaymantataj llojsipun. Chay niskanwan Jesús niyta munarkan tucuy ima miqhuna allin caskanta. ");
INSERT INTO qulNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nillarkantaj: —Runapaj sonkonmanta llojsejcaj runataka khellichan. ");
INSERT INTO qulNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Runacunapaj sonkonmantaka llojsin caycuna: mana allin pensaycuna, mana casaraska tiyaycuna, suwacuycuna, runata wañuchiycuna, ");
INSERT INTO qulNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","adulterio jucha ruwaycuna, runapaj cajnin munapayaycuna, sajra ruwaycuna, engañaycuna, viciopi causaycuna, payllapaj canan munaycuna, simi apaycachaycuna, pay pay wapu tucuycuna, sonso caycunapas. ");
INSERT INTO qulNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tucuy chay mana allincuna runapaj sonkonmanta llojsimun. Chaycunacajtaj runata khellichan. ");
INSERT INTO qulNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesús chaymanta llojsispa, Tiro llajtaman puriporkan. Uj wasiman yaycorkan; manataj ni pi yachanancuta munarkanchu chaypi cachcaskanta. Chaywanpas mana pacacuyta aterkanchu. ");
INSERT INTO qulNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Chaypacha uj warmi Jesús chayaskanta yacharkan. Cay warmipaj ususintaj sajra espirituyoj carkan. Jamuspa, Jesuspaj ñaupakenpi konkoriycucorkan. ");
INSERT INTO qulNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Chay warmeka waj nacionniyoj carkan, naciska Sirofeniciapi. Rogacorkan wawanmanta sajra espirituta katerkonanpaj. ");
INSERT INTO qulNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesustaj nerkan: —Wawacunaraj ñaupajta miqhuchuncu. Manami allinchu wawacunapaj t'antanta kechuspa, alkocunaman karaycoyka. ");
INSERT INTO qulNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Warmitaj contestarkan: —Arí, Señor. Chaywanpas alkocunaka wawacuna mesamanta pampaman ñut'itocuna urmakachiskancuta miqhuncu. ");
INSERT INTO qulNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesustaj nerkan: —Allinta ninqui. Sumajta niskayquiraycu puripullay. Ususiyquimantaka sajra espiritoka llojsipunña. ");
INSERT INTO qulNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Wasinman cutipuspataj, ususinta tariparkan siricuchcajta, sajra espiritutaj llojsipuskaña. ");
INSERT INTO qulNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús Tiro llajtamanta cutiporkan. Sidón llajtanta Decápolis niska llajtancunatapas pasaspa, Galilea kochaman chayarkan. ");
INSERT INTO qulNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Uj ajllu parlaj rojt'u runata payman pusamorkancu. Jesusta rogarkancu, maquinta chay runaman churaspa payta alliyachinanpaj. ");
INSERT INTO qulNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesustaj chay runata wajnejman pusarkan. Chaypitaj Jesús dedoncunata chay runapaj ninrincunaman churaycorkan. Maquinta thokaychaspa, runapaj kallunta llanqhaycorkan. ");
INSERT INTO qulNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Janaj pachata khawarispataj, athunmanta samarkorkan. Nerkantaj: “¡Efata!” nispa. (Niyta munan: “¡Quicharacuy!”) ");
INSERT INTO qulNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Chhicapacha ninrin quicharacorkan, kalluntaj pascaracorkan. Allinta parlaporkan. ");
INSERT INTO qulNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesustaj nerkan: —Ama pimanpas cayta ninquichischu. Jinata mandacuchcajtinpas, astawan willarachcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Uyarejcunaka sinchita musphararkancu: “Tucuy imata allinta ruwan. ¡Rojt'ucunata uyarichin, jup'acunatapas parlachin!” nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Uj p'unchay ujtawan achqha runacuna Jesusman tantacamorkancu. Ni ima miqhunancu carkanchu. Jesús discipuloncunata wajaspa nerkan: ");
INSERT INTO qulNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Cay runacunata qhuyapayani. Quimsa p'unchayña nokawan cachcancu, nitaj ni ima miqhunancu canchu. ");
INSERT INTO qulNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mana miqhuskata wasincuman cachapuyman chayka, ñanpi yuyaynincu chincapunman. Waquincunaka carumanta jamuncu. ");
INSERT INTO qulNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Discipuloncunataj payta nerkancu: —¿Imaynatataj cay ch'usaj lugarpi caycunaman miqhunata kochuwan? ");
INSERT INTO qulNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesustaj paycunata taporkan: —¿Jayc'a t'antayquichistaj can? Paycunataj nerkancu: —Kanchis —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesustaj mandacorkan runacunata tiyarachinancupaj. Chay kanchis t'antata jap'ispataj, Diosman graciasta korkan. Partispataj discipuloncunaman korkan jaywaramunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Callarkantaj uj iscay challwitacuna. Diosman graciasta kospa, mandallarkantaj jaywaranancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tucuynincu miqhorkancu sajsanancucama. Puchojnincunawantaj kanchis canastata junt'acherkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Miqhojcunataj tawa waranka jina carkancu. Jesustaj cacharpayaporkan. ");
INSERT INTO qulNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Discipuloncunawan boteman yaycuspataj, Dalmanuta jallp'aman puriporkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Fariseocuna jamuspa, Jesuswan churanacorkancu. Jinapi Jesusmanta mañarkancu milagrota ruwananpaj, ichapas Diosmanta caskanta ricuchinanpaj. ");
INSERT INTO qulNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesustaj llaquiska samarkospa nerkan: —¿Imaraycutaj cay runacuna milagrota mañan? Segurayquichis, mana ni ima milagrota ruwasajchu cay runacunapaj. ");
INSERT INTO qulNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Sakerpayaspataj, boteman yaycuspa uj lado kocha chimpaman cutiporkan. ");
INSERT INTO qulNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Discipuloncunaka miqhunata apayta konkapuskacu, botepitaj uj t'antallancu carkan. ");
INSERT INTO qulNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesustaj paycunata nerkan: —Uyariychis, fariseocunapaj Herodespajpiwan levaduranmanta cuidacuychis —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Discipulocunataj ninacorkancu: —T'antata mana apamunchischu, chayraycu jinata niwanchis —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús chayta reparaspa paycunata nerkan: —¿Imaraycutaj nichcanquichis mana t'antayquichis caskanta? ¿Manarajchu entendinquichis? ¿Sinchi wisk'askachu yuyayniyquichis? ");
INSERT INTO qulNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Manachu ñawiyquichis ricun? ¿Manachu ninriyquichis uyarin? ");
INSERT INTO qulNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Manachu yuyapunquichis phichka t'antata phichka waranka runaman koskayta? ¿Jayc'a canasta junt'atataj puchojninta okharerkanquichis? Paycunataj contestarkancu: —Chunca iscayniyojta —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Nillarkantaj: —Kanchis t'antata tawa waranka runacunaman korkani, chay puchojta ¿jayc'a canasta junt'atataj okharerkanquichis? Contestarkancutaj: —Kanchista —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jesustaj nerkan: —¿Manarajchu entendinquichis? ");
INSERT INTO qulNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jesús discipuloncunawan Betsaida llajtaman chayamorkan. Runacunataj Jesusman uj ñausata apamuspa, rogarkancu llanqhaycunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesustaj ñausata maquinmanta jap'iycuspa, llajta cantoman pusarkorkan. Ñawincunata thokayninwan jok'ochaspa, pay pataman maquinta churaspa, taporkan: —¿Ricunquichu imallatapas? —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ñausataj khawarispa nerkan: —Runacunata ricuni sach'acuna purichcajta jina. ");
INSERT INTO qulNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesustaj ujtawan ñausapaj ñawincunaman maquincunata churarkan. Alliyaskaña caspa tucuy imata allinta ricorkan. ");
INSERT INTO qulNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesustaj wasinman cachapuspa nerkan: —Ama llajtaman yaycuychu, nitaj pimanpas willaychu, llajtapi cajcunaman. ");
INSERT INTO qulNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesús discipuloncunawan Betsaidamanta llojsispa, Cesarea de Filipopi caj estanciacunaman puriporkan. Ñanta purichcaspataj Jesús discipuloncunata taporkan: —¿Runacuna pi niwancutaj nokatari? ");
INSERT INTO qulNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Paycunataj contestarkancu: —Waquin nincu ‘Juan Bautista’, waquincunataj ‘Elías’, waquincunataj ‘waj profetachari’ —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jesús paycunata taporkan: —Kancunari, ¿pi niwanquichistaj nokata? Pedrotaj nerkan: —Kanka Cristo canqui —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesustaj paycunata mandarkan, ama ni piman chayta willanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesús discipuloncunaman yachachiyta kallarerkan ñac'arinanmanta. Llajtapaj jefencuna, curaj sacerdotecuna, leymanta yachachejcuna Tataj Churinta chejnispa, wañuchinancuta yachachichcarkan. Quimsa p'unchaymantataj causarimonka. ");
INSERT INTO qulNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Paycunaman chayta sut'inta willajtin, Pedro Jesusta wajnejman pusarkospa c'amiyta kallarerkan. ");
INSERT INTO qulNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesustaj cutirispa, discipuloncunata khawarispa Pedrota nerkan: —¡Supay Satanás, ithiricuy nokamanta! Kan mana pensanquichu Diospaj pensaskanta jina. Kanka runacuna jinalla pensanqui. ");
INSERT INTO qulNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Runacunata discipuloncunatawan wajaspa nerkan: —Sichus maykenpas nokawan puriyta munan chayka, konkacuchun paycama. Sufrispapas, nokawan purichun wañunancama. ");
INSERT INTO qulNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Causaynillanta salvayta munajka chincachenka; nokaraycu salvación evangelioraycutaj causayninta chincachejka salvaconka. ");
INSERT INTO qulNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Cay pachapi khapajyaskan, ¿imapajtaj runamanri sirvenka, alman mana salvaska cajtinri? ");
INSERT INTO qulNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Runari jayc'atataj pagayta atinman almanta salvananpaj? ");
INSERT INTO qulNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Maykellanpas nokamanta palabraymantawan juchasapa runacunapaj ñaupakenpi p'enkacun chayka, noka, Tataj Churin, paymanta p'enkacullasajtaj jayc'ajchus Dios Tataypaj glorioso atiyninwan santo angelcunapiwan cutimusaj chhica. ");
INSERT INTO qulNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesús nillarkantaj: —Segurayquichis, waquin caypi cajcunamanta mana wañonkacuchu Diospaj gobiernon atiyninwan chayamuskanta ricunancucama. ");
INSERT INTO qulNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Sojta p'unchaymanta, Jesús Pedrota, Santiagota, Juantawan uj athun lomaman pusarkan. Ñaupakencupitaj Jesús waj jinaman tucorkan. ");
INSERT INTO qulNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","P'achancunapas yuraj rit'i c'anchaj jina tucorkan. Mana ni pipas t'ajsaspa, jinata yurajyachinmanchu. ");
INSERT INTO qulNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Jesustataj Eliaswan Moiseswan parlachcajta ricorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pedro nerkan: —Yachachej, ¡allin caypi cachcaycu! Quimsa ramaracunata ruwasajcu: ujta kanpaj, ujta Moisespaj, ujtataj Eliaspaj. ");
INSERT INTO qulNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Discipuloncunaka sinchita mulljacorkancu. Pedrotaj mana yacharkanchu ima parlaskanta. ");
INSERT INTO qulNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Chaymanta phuyu uraycamuspa paycunata kataycorkan. Phuyumantataj parlamojta uyarerkancu: “Caymi munaska Chureyka. Payta uyariychis” nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Chhicapacha tucuynejta khawarispa, mana ni pita ricorkancuchu, manachayri Jesús sapallanta. ");
INSERT INTO qulNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Lomamanta urakampuchcajtincu, Jesús discipuloncunata mandarkan: —Chay ricuskayquichista ama ni piman willanquichischu, wañuskamanta causarimunaycama. ");
INSERT INTO qulNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Manataj ni piman willaspa, paycunapuralla tapunacorkancu: “¿Imataj chay ‘wañuskamanta causarimunari’?” nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Jesusta taporkancu: —¿Imaraycutaj leymanta yachachejcuna nincu Elías Cristomanta ñaupajta jamunanta? ");
INSERT INTO qulNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesustaj nerkan: —Cierto Eliaska ñaupajta jamunan, paytaj tucuy imata jallch'anka. ¿Imaraycutaj Escriturapi nin Tataj Churin sinchita ñac'arinanta, millarpayaskataj cananta? ");
INSERT INTO qulNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nokataj niyquichis, Eliaska jamunña. Paytapas ima munaskancuta sufrichincu, Escriturapaj niskanman jina pasananpaj. ");
INSERT INTO qulNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jesuska cutipuspa discipuloncunata tariparkan achqha runa chaupipi. Waquin leymanta yachachejcuna paycunawan churanacuchcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jesusta ricuytawan, tucuy runacuna Jesusmanta musphaspa, cusicuywan payta saludaj phawarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesustaj taporkan: —¿Imamantataj chay tucuyta parlachcanquichis? —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Achqha runamanta ujnin nerkan: —Yachachej, sajra espiritupaj jup'ayachiskan churiyta kanman pusamuni. ");
INSERT INTO qulNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Maypichari payta jap'in chayka pampaman wijch'un. Phusokota llausata suruchispa, quiruncunata c'aririchispa wañuskata jina ruwan. Discipuloyquicunata mañacorkani wawaymanta sajra espirituta katerkonancupaj, manataj aterkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesustaj nerkan: —¡Ay, mana creeyniyoj runacuna! ¿Jayc'ajcamataj kancunawan casajri? ¿Jayc'ajcamataj aguantaskayquichisri? Chay waynata cayman pusamuychis. ");
INSERT INTO qulNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Pusamojtincutaj, sajra espíritu Jesusta ricuspa waynata t'ucuwan jap'icherkan. Waynataj pampapi khochparkan, phusokotataj ulthorkan. ");
INSERT INTO qulNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesús waynapaj tatanta taporkan: —¿Jayc'ajmantañataj cay jina cachcanri? Tatantaj nerkan: —Wawitamantapacha. ");
INSERT INTO qulNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Sajra espiritoka achqha cuti ninaman unumanpas chhokaycun wañuchinanpaj. Sichus imata ruwayta atiwaj chayka, qhuyapayawaycu, yanapariwaycutaj. ");
INSERT INTO qulNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesustaj payta nerkan: —Kan ninqui, ‘Sichus atiwaj’ nispa. Noka niyqui, ¡Diospi creejpajka tucuy ima aticun! ");
INSERT INTO qulNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nejtin jina waynapaj tatanka wajach'acorkan: —¡Diospi creeni! ¡Yanapariway astawan creenaypaj! —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Achqha runa tantacamuchcajta ricuspataj, Jesús sajra espirituta c'amerkan nispa: —Jup'ayachej rojt'uyachej sajra espíritu, noka mandayqui: ¡Paymanta llojsiy, amataj ujtawan payman yaycunquiñachu! ");
INSERT INTO qulNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Sajra espiritutaj waynata kaparichispa sinchita t'ucuta jap'ichispa, llojsiporkan. Waynataj wañuska jina carkan. Achqhayoj nichcarkancu: “Wañupun” nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesustaj maquinmanta jap'ispa, jataricherkan. Waynataj sayarerkan. ");
INSERT INTO qulNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jesús wasiman yaycojtin, discipuloncuna sapallanpi taporkancu: —¿Imaraycutaj nokaycu mana aterkaycuchu chay sajra espirituta katerkoytari? ");
INSERT INTO qulNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Paycunaman nerkan: —Cay jina sajra espiritutaka imawanpas katerkoyta atiwajchischu, manachayri oracionwan ayunopiwan. ");
INSERT INTO qulNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Chaynejmanta llojsispataj, Galilea llajtanejta puriporkancu. Jesuska ni pi yachananta munarkanchu. ");
INSERT INTO qulNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Discipuloncunata yachachichcarkan nispa: —Tataj Churenka runacunaman entregaska canka, wañuchenkacutaj. Quimsa p'unchaymantataj causarimponka. ");
INSERT INTO qulNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Paycunataj Jesuspaj niskanta mana entenderkancuchu, tapuytataj manchacorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Capernaum llajtaman chayarkancu. Wasipi caspataj, Jesús discipuloncunata taporkan: —¿Imamantataj churanacuchcarkanquichis ñanta jamuchcaspari? —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ch'inllataj carkancu. Ñanta jamuchcaspa paycunaka churanacuchcarkancu maykenchus paycunamanta curaj caskanmanta. ");
INSERT INTO qulNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesús tiyaycuspa, chunca iscayniyoj discipuloncunata wajaspa nerkan: —Maykenpas ñaupajpi cay munajka, tucuyninmanta khepapi canan, tucuyta sirvej. ");
INSERT INTO qulNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Uj wawata chaupincuman churaycuspa mark'aricuspataj, paycunata nerkan: ");
INSERT INTO qulNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Pichus cay wawata jina sutiypi jap'ekajka, nokata jap'ekawan. Nokata jap'ekajtaj, cachamuwajniyta jap'ekan. ");
INSERT INTO qulNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juan Jesusta nerkan: —Yachachej, uj runata ricumuycu sutiyquipi sajra espiritucunata katerkojta. Mana nokanchiswan purichcaskanraycu, jarc'aycu. ");
INSERT INTO qulNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesustaj nerkan: —Ama jarc'aychischu. Pipas sutiypi milagro ruwajka, mana noka contra parlanmanchu. ");
INSERT INTO qulNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mana nokanchis contra cajka nokanchiswan. ");
INSERT INTO qulNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Pillapas sutiypi uj vaso unuta kosunquichis Cristopaj caskayquichisraycu chayka, segurayquichis, Dios chay unuta koskanmanta payman bendicionta cutichiponka. ");
INSERT INTO qulNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Nillarkantaj: —Maykellanpas nokapi creej juch'uycitocunamanta ujninta juchaman urmachejpajka, allin canman cuncanman athun cutana rumita wataycuspa, athun kochaman wijch'uycunancoka. ");
INSERT INTO qulNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Maquiyquichus juchaman urmachisunqui chayka, p'atakay. Allinraj ch'ulla maquiyojpas wiñay causayman yaycunayqui, iscaynin maquintin mana wañoj nina infiernoman purinayquitapachaka. ");
INSERT INTO qulNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Chaypeka mana jayc'aj wañoj ninapi wiñaypaj sufrenkacu. ");
INSERT INTO qulNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Chaquiyquichus juchaman urmachisunqui chayka, p'atakallaytaj. Allinraj ch'ulla chaquiyojpas wiñay causayman yaycunayqui, iscaynin chaquintin infiernoman wijch'uycuska canayquitapachaka. ");
INSERT INTO qulNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Chaypeka mana jayc'aj wañoj ninapi wiñaypaj sufrenkacu. ");
INSERT INTO qulNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ñawiyquichus juchaman urmachisunqui chayka, orkhorkocuy. Allinraj ch'ulla ñawiyojpas Diospaj gobiernonman yaycunayqui, iscaynin ñawintin infiernoman wijch'uycuska canayquitapachaka. ");
INSERT INTO qulNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Chaypeka curucunaka mana wañonkacuchu, ni ninapas. ");
INSERT INTO qulNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Tucuynincu waquichiska cankacu ñac'ariycunawan ninawan jina. ");
INSERT INTO qulNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Cacheka sumaj; ch'apajyapunman chayri, ¿imaynatataj ujtawan cachinchacunman? ¿Imapajtaj sirvinman? Kancunapi cachun cachi. Uj ujcunawanpas allinpi causaychis. ");
INSERT INTO qulNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Capernaummanta llojsispataj, Jesús Judea llajtaman, inti llojsimuy Jordán mayu chimpaman puriporkan. Chaypi ujtawan runacuna payman tantacorkancu. Jesustaj ujtawan yachachiyta kallarerkan imaynatachus yachachej jinata. ");
INSERT INTO qulNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Jesusman fariseocuna chimpaycorkancu. Parlaskanpi juchaman pantachinancupaj taporkancu: —¿Aticunmanchu casaraska khari esposanmanta divorciacunanpaj? ");
INSERT INTO qulNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesustaj nerkan: —¿Imatataj Moisés mandarkasunquichis? ");
INSERT INTO qulNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Fariseocunataj contestarkancu: —Moisés nerkan: ‘Divorciacoyka aticunman, esposanman divorcio papelta kospa.’ ");
INSERT INTO qulNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesustaj paycunaman nerkan: —Moiseska chayta escriberkan khoru sonkoyoj caskayquichisraycu. ");
INSERT INTO qulNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Mundo kallariypeka Escriturapi nin: ‘Dios kharita warmitawan ruwarkan. ");
INSERT INTO qulNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Chayraycu khareka tata mamanta sakeponka esposanwan juntacunanpaj, ");
INSERT INTO qulNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","iscaynincutaj uj runa jinalla cankacu.’ Ajinaka manaña iscaychu cancu, manachayri ujllaña. ");
INSERT INTO qulNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Chayraycu Diospaj juntaskanta ama runaka wijch'uchunchu. ");
INSERT INTO qulNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Wasipiña cajtin, discipuloncuna Jesusta taporkancu divorciomanta. ");
INSERT INTO qulNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Paycunaman nerkan: —Pillapas esposanmanta divorciacuspa waj warmiwan casaracun chayka, ñaupaj esposan contra adulterio juchata ruwan. ");
INSERT INTO qulNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Sichus esposacaj kosanta sakespa waj khariwan casaracun chayka, paypas adulterio juchata ruwallantaj. ");
INSERT INTO qulNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Wawacunata Jesusman pusamorkancu, maquinta churaspa bendicinanpaj. Discipuloncunataj pusamojcunata c'amiyta kallarerkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesustaj c'amiskancuta ricuspa phiñacorkan, paycunata nerkan: —Ama jarc'aychischu wawacuna nokaman jamojta, imaraycuchus Diospaj gobiernonka wawacuna jina cajcunapaj. ");
INSERT INTO qulNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Segurayquichis, pipas Diospaj gobiernonta mana jap'ekanchu uj wawa jina chayka, mana Diospaj gobiernonman yayconkachu. ");
INSERT INTO qulNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Paytaj wawacunata mark'aricuspa maquincunata wawacuna pataman churaspa, bendicerkan. ");
INSERT INTO qulNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesús puripunanña cachcajtin, uj runa phawamuspa paypaj ñaupakenpi konkoriycorkan. Taporkantaj: —Allin Yachachej, ¿imatataj ruwanay wiñay causayniyoj canaypaj? —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesustaj contestarkan: —¿Imaraycutaj ‘allin’ niwanqui? Dioslla allenka. ");
INSERT INTO qulNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kan yachanqui Diospaj mandaskancunata: ‘Ama adulterio juchata ruwanquichu, ama runata wañuchinquichu, ama suwacunquichu, ama pimantapas llullata ninquichu, ama engañanquichu, tata mamayquita respetay’. ");
INSERT INTO qulNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Chay runataj nerkan: —Yachachej, waynamantapacha tucuy caycunata junt'ani. ");
INSERT INTO qulNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús munacuywan khawarispa, nerkan: —Chaywanpas ujtaraj ruwanayqui. Puriy, tucuy imayquita vendimuy, chay kolketataj pobrecunaman koy. Jinamanta janaj pachapi khapaj cayniyqueka canka. Chaymanta jamuspa, nokawan puriy. ");
INSERT INTO qulNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Chayta uyarispa runaka ujinayaycuspa, llaquiska riporkan, sinchi khapaj caskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesustaj tucuynejta khawarispa discipuloncunaman nerkan: —¡Khapajcunaka Diospaj gobiernonman ñac'ayta yayconkacu!. ");
INSERT INTO qulNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Discipulocunaka chay niskanmanta muspharkancu. Jesustaj ujtawan nerkan: —Wawaycuna, khapaj caynincupi confiajcunaka imaymanaspa ñac'ayta yayconkacu Diospaj gobiernonman. ");
INSERT INTO qulNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Camelloraj agujapaj ninrinta astawan facilta pasanmanpas, uj khapaj runa Diospaj gobiernonman yaycunantapachaka. ");
INSERT INTO qulNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Chayta uyarispa astawanraj musphararkancu, tapunacorkancutaj: —¿Chhicari pillataj salvaska cayta atinman? ");
INSERT INTO qulNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesustaj paycunata khawarispa nerkan: —Runapaj mana aticojka, Diospaj aticun, imaraycuchus Diospajka tucuy ima aticun. ");
INSERT INTO qulNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Chaymanta Pedro nerkan: —Nokaycoka tucuy imaycuta sakespa kanwan purichcaycu. ");
INSERT INTO qulNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesustaj nerkan: —Segurayquichis, pillapas wasinta, waukencunata, panancunata, tatanta, mamanta, wawancunata, chayri chajrancunata nokaraycu salvación evangelioraycu sakenman chayka, ");
INSERT INTO qulNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","cunan cay pachapi pachaj cuti yapaskata jap'ekanka wasicunata, waukecunata, panacunata, mamacunata, wawacunata, chajracunata, sufriycuna cajtinpas. Janaj pachapitaj wiñaypaj salvaska causayta jap'ekanka. ");
INSERT INTO qulNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Cunan ñaupajpi cajcunamantaka achqhayoj khepapi cankacu Diospaj gobiernonpi, khepapi cajcunamantataj achqhayoj ñaupajpi cankacu. ");
INSERT INTO qulNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Discipuloncuna mulljariska manchariskataj Jesuspaj khepanta Jerusalenman purichcarkancu. Ujtawantaj Jesús chunca iscayniyoj discipuloncunata wajnejman pusarkan. Willayta kallarerkan imachus payta pasananmanta. Paycunaman nerkan: ");
INSERT INTO qulNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Ricuchcanquichis Jerusalenman purichcaskanchista. Chaypi Tataj Churin curaj sacerdotecunaman leymanta yachachejcunamanpas vendiycuska canka. Paycunataj wañunanpaj juchachaspa, waj llajtayojcunaman entregankacu. ");
INSERT INTO qulNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Burlaconkacu, thutkatankacu, makankacu, wañuchenkacutaj. Quimsa p'unchaymantataj causariponka.” ");
INSERT INTO qulNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zebedeopaj churincuna, Santiago Juanpiwan, Jesusman chimpaycuspa nerkancu: —Yachachej, uj favorta ruwanawayquichista munaycu —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesustaj paycunata taporkan: —¿Imatataj kancunapaj ruwanayta munanquichisri? ");
INSERT INTO qulNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Paycunataj nerkancu: —Sumaj glorioso gobiernoyquipi tiyayta munaycu, ujniycu paña ladoyquipi, ujniycutaj llok'e ladoyquipi. ");
INSERT INTO qulNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesustaj nerkan: —Kancunaka mana yachanquichischu imatachus mañacuskayquichista. ¿Ñac'ariyta atiwajchischu imaynatachus noka ñac'arisaj chayta? ¿Jap'ekawajchischu bautismo jap'ekanaytapas? ");
INSERT INTO qulNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Paycunaka nerkancu: —Arí, atisajcu —nispa. Jesustaj paycunata nerkan: —Arí, jap'ekanquichis. Kancuna ñac'arinquichis. Sufrispataj wañunquichis noka jina. ");
INSERT INTO qulNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Chaywanpas paña ladoypi llok'e ladoypi tiyana konaka mana nokamantachu, manachayri picunapajchus waquichiska cachcan, chaycunaman koska canka. ");
INSERT INTO qulNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Chayta uyarispa, waj chunca discipuloncunaka Santiagopaj Juanpajpiwan phiñacorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesustaj paycunata wajaspa nerkan: —Kancuna yachanquichis, waj dioscunata adoraj runacuna uqhupi jefecuna mana qhuyapayaywan dueñochacuspa mandacuncu, ‘Derechoyoj cani’ nispa. Athun autoridadcunapas runacunawan munaskancuta ruwancu. ");
INSERT INTO qulNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Chaywanpas kancuna uqhupeka mana jina cananchu, manachayri kancuna uqhumanta athun atiyniyoj cay munajka tucuyta sirvej canan. ");
INSERT INTO qulNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Pillapas kancunamanta ñaupajpi cay munajka tucuypaj sirvienten canan. ");
INSERT INTO qulNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Jinallatataj nokapas, Tataj Churin, mana sirvichicojchu jamuni, manachayri sirvej, causayniytataj koj achqhayojta salvanaypaj. ");
INSERT INTO qulNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesús discipuloncunawan Jericó llajtaman chayarkan. Chaymanta achqha runawan llojsichcajtincu, Timeopaj churin Bartimeo ñan patapi tiyacuchcarkan. Payka ñausa caskanraycu runacunamanta limosnata mañacoj. ");
INSERT INTO qulNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nazaret llajtayoj Jesús chaynejta purichcaskanta uyarispataj, wajach'acorkan: —¡Jesús, Davidpaj miraynin, qhuyapayariway! ");
INSERT INTO qulNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Achqha runataj payta c'amerkancu: —¡Jup'allay! —nispa. Paytaj astawan wajach'acorkan: —¡Davidpaj miraynin, qhuyapayariway! ");
INSERT INTO qulNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Chayta uyarispataj, Jesús sayaycuspa, nerkan: —Payta wajamuychis —nispa. Ñausata wajamuspataj, nerkancu: —¡Animacuy, sayariy! Wajachcasunqui. ");
INSERT INTO qulNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Paytaj katananta chhokaspa, ujta saltaspa Jesusman chimparkan. ");
INSERT INTO qulNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesustaj payta taporkan: —¿Imatataj ruwanayta munanqui? —nispa. Ñausataj nerkan: —Yachachej, khawatatachinawayquita munani. ");
INSERT INTO qulNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesustaj nerkan: —Puripuy. Creeskayquiraycu alliyachiska canqui. Chhicapacha ñausaka ricucaporkan. Jesuswantaj puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jerusalenman kayllapiña cachcaspa, Betfagé, Betania llajtacuna kayllapi, Jesús iscay discipuloncunata Olivos loma chimpaman cachaspa, ");
INSERT INTO qulNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","nerkan: —Chimpa llajtaman puriychis. Chayman yaycuspataj, manaraj cargana malta asnota pascaraspa aysamuychis. ");
INSERT INTO qulNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Pipas tapusunquichis: ‘¿Imapajtaj asnota pascarachcanquichis?’ nispa chayka, payta niychis: ‘Señor necesitan. Cutichipusunqui.’ ");
INSERT INTO qulNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Chay iscay discipulocunataj purispa, callepi asnota tariparkancu uj puncu kayllapi wataskata. Pascararkancutaj. ");
INSERT INTO qulNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Chaypi cajcunataj taporkancu: —¿Imatataj ruwachcanquichis? ¿Imapajtaj asnota pascarachcanquichis? —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Paycunataj nerkancu Jesuspaj niskanman jina. Chaypi cajcunataj aysachipullarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jesusman apamorkancu. P'achancuta caronaycojtincutaj, Jesús sillaycorkan. ");
INSERT INTO qulNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Achqhayoj runa p'achancuta ñanpi mast'arkancu. Waquintaj palma raphicunata p'ataspa, ñanpi mast'arkancu chay patanta purinanpaj. ");
INSERT INTO qulNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Khepanta ñaupakenta purejcuna wajach'acuyta kallarerkancu: —¡Alabaska cachun, bendito Señorpaj sutinpi jamoj! ");
INSERT INTO qulNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Bendito jamoj gobierno, tatanchis Davidpaj gobiernon! ¡Alabaska cachun janaj pachapi caj Dios! ");
INSERT INTO qulNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ajinata Jesús Jerusalenman templomanpas yaycorkan. Tucuy imata khawaraspataj, chunca iscayniyoj discipuloncunawan Betaniaman puriporkan, ch'isiña caskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","K'ayantintaj Betaniamanta llojsispa Jesús yarekachicorkan. ");
INSERT INTO qulNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Carumanta uj higo sach'ata raphicunayojta ricuspa, urinta masc'aspa chimpaycorkan. Chay higotaj mana uriyoj carkan, raphicunayojlla, mana urinan tiempochu caskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jesús higo sach'aman nerkan: —¡Jayc'ajpas ni pipas uriyquita miqhonkañachu! Discipuloncunataj uyarerkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jerusalenman chayaspataj, Jesús discipuloncunawan temploman yaycorkan. Vendejcunata rantejcunatawan ricuspa, katerkamorkan. Kolke cambiajcunapaj mesancunata, paloma vendejcunapaj sillancunatawan tijrararkan. ");
INSERT INTO qulNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Manataj pasacherkanchu ni imata apanancuta templo uqhunta. ");
INSERT INTO qulNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Paycunaman yachacherkan: —Escriturapi nin: ‘Waseyka oración ruwana wasi canka tucuy nacioncunapaj.’ Kancunataj suwacunapaj jutc'unta ruwapunquichis. ");
INSERT INTO qulNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Sacerdotecunapaj jefencuna leymanta yachachejcunapiwan chayta uyarispa, imaynata Jesusta wañuchinancupaj masc'arkancu. Manchacorkancutaj imaraycuchus tucuy runa muspharachcarkancu Jesuspaj yachachiskanmanta. ");
INSERT INTO qulNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ch'isiyaycuyta Jesús discipuloncunapiwan llajtamanta llojsiporkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","K'ayantin tutamanta llajtaman cutichcaspa, chay higo sach'ata ricorkancu saphintin ch'aquipuskanta. ");
INSERT INTO qulNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pedrotaj Jesuspaj niskanta yuyarispa nerkan: —¡Yachachej, khawariy! ¡Maldiciskayqui higo sach'aka ch'aquipuska! —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesustaj paycunata nerkan: —Diospi creeychis. ");
INSERT INTO qulNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Segurayquichis, pillapas cay lomata ninman: ‘¡Caymanta okharicuy, kochaman wijch'uycucuy!’ nispa sonkonpi mana iscayrayaspa, niskan ruwacunanta creenman chayka, ajina canman. ");
INSERT INTO qulNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Chayraycu niyquichis, tucuy imata kancuna oracionpi mañacuspa jap'ekaskayquichistaña creenquichis chayka, jap'ekanquichis. ");
INSERT INTO qulNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Oracionpi mañacuchcaspa, yuyarinquichis pipas kancuna contra jucha ruwaskanta chayka, perdonaychis. Kancuna perdonanquichis chayka, Dios Tatayquichis perdonallasunquichistaj. ");
INSERT INTO qulNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Mana perdonanquichischu chayka, janaj pachapi caj Dios Tatayquichis manallataj kancunatapas perdonasunquichischu. ");
INSERT INTO qulNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jesús discipuloncunawan ujtawan Jerusalenman cuterkan. Jesús templo patiopi purichcajtin, sacerdotecunapaj jefencuna, leymanta yachachejcuna, llajtapaj jefencunapiwan chimparkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Nerkancutaj: —¿Ima autoridadwantaj caycunata ruwanqui? ¿Pitaj autorizasunqui ruwanayquipaj? ");
INSERT INTO qulNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesustaj contestarkan: —Ujta noka tapullaskayquichistaj. Sichus cutichiwanquichis chayka, noka willallaskayquichistaj ima autoridadwan ruwaskayta. ");
INSERT INTO qulNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Pitaj Juanta cachamorkan bautizananpaj? ¿Dioschu icha runacunachu? Niwaychis. ");
INSERT INTO qulNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Paycunapurataj ninacorkancu: “Sichus ‘Dios cachamorkan’ nisunchis chayka, Jesús niwasunchis: ‘¿Imaraycutaj payta mana creerkanquichischu?’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Manallataj niyta atinchischu runacuna payta cachamuskanta.” Runacunaka creerkancu Juan Diospaj profetan caskanta. Chayraycu paycuna runacunata manchacorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Jesusman nerkancu: —Mana yachaycuchu —nispa. Jesustaj nerkan: —Ni nokapas willaskayquichischu ima autoridadwanchus caycunata ruwaskayta. ");
INSERT INTO qulNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesuska ejemplocunawan parlayta kallarispa, nerkan: “Uj runa jallp'anpi achqha uvata tarporkan. Muyuntinta wisk'aycucherkan. Jutc'uta ruwarkan uvata ch'irwananpaj. Uj torreta ruwarkan, chay patamanta khawananpaj. Llanc'ajcunaman arrendaycuspataj, caruta puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Uva pallana tiempotaj uj uywaskanta cachamorkan payman tupaskanta apachinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Llanc'ajcunataj payta jap'ispa makaspa, jinapachallata cachaporkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Patronka waj uywaskanta cachamullarkantaj. Paytataj umanta phatacherkancu. Insultaspataj cachaporkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Wajtañataj cachamullarkantaj. Chaytataj wañucherkancu. Cachamullarkantaj achqha runacunatawan. Llanc'aj runacunataj waquincunata c'uparkancu, waquincunatataj wañucherkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Patronpaj sinchi munaskan ch'ulla churin carkanraj. Chay churinta cacharkan pensaspa: ‘Churiycajtaka respetankacupunichari’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Chay llanc'ajcunataj paycunapura ninacorkancu: ‘Cay churenka tatanpaj jallp'anta jap'enka. Jacuchis, wañuchimusun, nokanchistaj dueño capusunchis’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Jap'ispataj wañuchiporkancu. Wijch'orkorkancutaj uva chajra jallp'amanta.” ");
INSERT INTO qulNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Chaymantataj Jesús taporkan: “¿Imanankataj patronri chay llanc'ajcunatari? Cayta ruwanka: jamuspa, chay llanc'ajcunata wañurachenka, jallp'antataj wajcunaman arrendanka. ");
INSERT INTO qulNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“¿Manachu Diospaj palabranpi leerkanquichis? Jinata nin: ‘Wasi ruwajcunapaj mana casuraskancu rumeka astawan importante tucun wasipaj. ");
INSERT INTO qulNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Chayta ruwarkan Señorka, muspharananchispaj jina.’ ” ");
INSERT INTO qulNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Chay Israel jefecunaka Jesusta jap'iyta munarkancu. Reparacorkancu paycuna contra cay ejemplo caskanta. Chaywanpas runacunata manchacuskancuraycu, sakerpayaspa puriporkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Chejnicojcuna waquin fariseocunata Herodespaj partidonmanta cajcunatawan Jesusman cacharkancu, parlaskanpi pantajtin Jesusta juchachanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Paycunataj jamuspa nerkancu: —Yachachej, yachaycu parlaskayqui verdad caskanta. Runapaj parlaskanta mana manchaspa, nitaj runapaj rijch'ayninta khawaspa, verdadta yachachinqui Diospaj munaskanman jina causanancuta. ¿Allinchu icha manachu impuesto pagana Roma gobiernoman? ¿Pagananchischu icha manachu? ");
INSERT INTO qulNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesustaj paycunapaj iscay uya caskancuta yachaspa, nerkan: —¿Imaraycutaj pantachiyta munawanquichis? Apamuwaychis kolketa khawanaypaj. ");
INSERT INTO qulNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Payman jaywajtincu, Jesús taporkan: —¿Pipaj uyantaj pipaj sutintaj cay kolkepi escribiska cachcan? —nispa. Contestarkancutaj: —Gobernaj Cesarpajta —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Chayraycu Jesús nerkan: —Cesarpaj cajtaka Cesarman koychis, Diospaj cajtataj Diosman koychis —nispa. Chay jina niskanmanta muspharkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Waquin saduceocuna Jesusman jamorkancu. Saduceocunaka nincu wañuskamanta causarina mana caskanta. Chayraycu cay ejemplowan Jesusta taporkancu: ");
INSERT INTO qulNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Yachachej, Moisespaj escribiskanpi niwanchis: ‘Uj runa casaracuspa mana wawayoj wañupunman chayka, paypaj wauken viudawan casaracuchun, ajinapi wañojpaj wawa cananpaj.’ ");
INSERT INTO qulNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Cunantaj kanchis waukentin carkancu. Curajcaj casaracorkan, mana wawayojtaj wañuporkan. ");
INSERT INTO qulNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Chaymanta wañojpaj sullc'an viudanwan casaracullarkantaj. Paypas mana wawayoj wañupullarkantaj. Chaypaj sullc'anwanpas jinallatataj pasarkan. ");
INSERT INTO qulNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Jinataj kanchisnintin chay viudawan casaracorkancu, nitaj maykennincupajpas wawancu carkanchu. Khepaman chay warmeka wañupullarkantaj. ");
INSERT INTO qulNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Cunanri, kanchisnintin casaracojcuna causarimojtincu, ¿maykenpaj warmintaj cankari? ");
INSERT INTO qulNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesustaj nerkan: —Kancuna pantaska canquichis, imaraycuchus Diospaj palabranta mana entendinquichischu ni Diospaj atiyninta rejsinquichischu. ");
INSERT INTO qulNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Causarimuspaka mana casaraconkacuchu, nillataj casarachenkacuchu. Janaj pachapi caj angelcuna jina cankacu. ");
INSERT INTO qulNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","¿Manachu Moisespaj libronpi leerkanquichis wañuskacuna causarinancumanta? Dios laurachcaj sach'itamanta parlamorkan: ‘Noka cani Abrahampaj, Isaacpaj, Jacobpaj Diosnin’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","¡Dioska mana wañuskacunapaj Diosninchu, manachayri causajcunapaj Diosnin! Chayraycu kancunaka sinchita pantanquichis. ");
INSERT INTO qulNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Chay parlaskata uyarispa, uj leymanta yachachej repararkan Jesús allinta contestaskanta. Chimpaycuspataj taporkan: —Diospaj tucuynin mandaskanmanta, ¿maykentaj astawan importanteri? —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesustaj nerkan: —Diospaj tucuy mandaskanmanta ñaupajka caymi: ‘¡Israel runacuna, uyariychis! Señor Diosninchiska ch'ulla Señor. ");
INSERT INTO qulNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Señor Diosniyquita munacuy tucuy sonkoyquiwan, tucuy almayquiwan, tucuy yuyayniyquiwan, tucuy callpayquicunapiwan.’ ");
INSERT INTO qulNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Iscaycajtaj caymi: ‘Runamasiyquita munacuy kan quiquiyquita jina.’ Caycunamanta astawan importante mandamientoka mana canchu. ");
INSERT INTO qulNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Leymanta yachachejka Jesusman nerkan: —Yachachej, allinta ninqui. Dioska ujlla. Paymanta wajka mana canchu. ");
INSERT INTO qulNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Uj runa Señor Diosninta munacun tucuy sonkonwan, tucuy yuyayninwan, tucuy callpancunawan, runamasintataj pay quiquinta jina munacun chayka, astawan valorniyoj tucuy ofrendacunamanta tucuy sacrificiocunamanta nejtinpas. ");
INSERT INTO qulNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Sumaj yuyaywan contestaskanta uyarispataj, Jesuska nerkan: —Diospaj gobiernonmanta mana carupichu cachcanqui. Manañataj ni pipas Jesusta astawan tapuyta atrevicorkanchu. ");
INSERT INTO qulNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús templopi yachachichcaspa nerkan: —¿Imaynatataj leymanta yachachejcuna nincu, ‘Cristoka Davidpaj mirayninmanta’ nispa? ");
INSERT INTO qulNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Santo Espiritupaj pusaskan David quiquin nerkan: ‘Señor Dios Señorniyman nerkan: Paña ladoypi tiyaycuy enemigoyquicunata atipanaycama.’ ");
INSERT INTO qulNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Imaynatataj Cristo Davidpaj miraynin canman? David quiquin nin, ‘Señorníy’ nispa. Chaypi caj achqha runacunataj cusiywan uyarerkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús yachachichcaspa nerkan: “Leymanta yachachejcunamanta cuidacuychis. Paycunaman gustan pampacama p'achayoj purina, importante runa jina. Munancutaj tucuy respetowan saludanata plazacunapi. ");
INSERT INTO qulNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Sinagogapitaj masc'ancu alabanacaj tiyanata tiyanancupaj. Fiestacunapipas alabanacaj lugarta masc'ancu miqhunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Chaywanpas viudacunamanta wasincuta kechuncu. Chay ruwaskancu mana reparachicunancupajtaj, unayta oracionta ruwancu. Paycunata Dioska astawan castiganka.” ");
INSERT INTO qulNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Uj cuti templopi ofrenda churana ñaupakenpi Jesús tiyachcarkan, ofrenda churajcunata khawaspa. Khapajcuna achqha kolketa churachcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Khawachcajtintaj, uj pobre viuda chayaspa, iscay kolkecitocunata churarkan. ");
INSERT INTO qulNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesustaj discipuloncunata wajaspa nerkan: —Segurayquichis, cay pobre viudaka astawan churan tucuy ofrenda churajcunamanta nejtenka. ");
INSERT INTO qulNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tucuynincu puchojnillanta koncu. Cay warmitaj pobre cayninwanpas causananpaj caj tucuy kolkecitonta churapun. ");
INSERT INTO qulNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesús templomanta llojsichcajtin, ujnin discípulo nerkan: —¡Yachachej, khawariy cay munay rumicunata, cay munay wasicunatapas! ");
INSERT INTO qulNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesustaj nerkan: —¿Ricunquichu cay athun wasicunata? Mana ni uj rumipas uj rumi patapi quedankachu. Tucuy urmachiska canka. ");
INSERT INTO qulNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Templowan khawanacuy, Olivos niska lomapi Jesús tiyaycorkan. Tiyacuchcajtintaj, Pedro, Santiago, Juan, Andrespiwan sapallanpi taporkancu: ");
INSERT INTO qulNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Willanawayquichista munaycu, ¿jayc'ajtaj caycuna pasanka? ¿Ima señaltaj canka tucuy caycuna junt'acunanpaj? ");
INSERT INTO qulNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesustaj paycunaman nerkan: “Cuidacuychis mana pipas engañanasunquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Achqhayoj jamonkacu, ‘Noka cani Cristo’ nispa, achqhayojtataj engañankacu. ");
INSERT INTO qulNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Kancuna guerracunamanta parlajta uyarispa, ama manchacuychischu. Caycunaka cananpuni. Chaywanpas manaraj tucucuyrajchu. ");
INSERT INTO qulNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Llajtapura makanaconkacu, nacionpura guerrata ruwankacu. Achqha lugarpitaj jallp'a qharcatenka, yarekaycunataj canka. Caycunataj nanaycuna kallariyllaraj. ");
INSERT INTO qulNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Kancunacama cuidacuychis, imaraycuchus autoridadcunaman apasunquichis, sinagogapitaj bajtasunquichis. Gobernajcunapaj ñaupakenman apaska canquichis nokaraycu. Jinapi nokamanta paycunaman willaranquichis. ");
INSERT INTO qulNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Manaraj tucucunan cachcajtin, evangelio tucuy nacioncunapi willaraska canan. ");
INSERT INTO qulNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Apamusunquichis autoridadcunaman entreganapaj. Chhica ama ninquichischu ‘imanasajtaj’ nispa. Chay ratopi Dios imatacha kosunquichis, chayta parlaychis, imaraycuchus mana kancunapaj parlayniyquichistachu parlachcanquichis, manachayri Santo Espiritupaj koskanta. ");
INSERT INTO qulNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Uj wauke waukenta entreganka wañuchiska cananpaj. Uj tatapas wawanta vendiyconka wañuchiska cananpaj. Wawacunapas tatancu contra tuconkacu wañuchinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nokaraycutaj tucuypaj chejniskan canquichis. Pichari tucucuycama fiel cajlla salvaska canka. ");
INSERT INTO qulNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Chay sajra millay khellicajta santo lugarpi ricuspa, Judeapi cajcuna lomacunaman escapachuncu. (Pipas cayta leejka entendichun.) ");
INSERT INTO qulNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Wasi patapi cachcajka amaña wasinman yaycuchunchu imatapas okharispa apananpaj. ");
INSERT INTO qulNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Chajrapi cachcajka amaña cutichunchu katananta okharejka. ");
INSERT INTO qulNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Ay, llaquiy ari, chay p'unchaycunapi onkoj warmipaj, ñuñuchcaj wawayojpajpas! ");
INSERT INTO qulNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Oracionpi Diosmanta mañacuychis mana chiri tiempopi cay pasananpaj. ");
INSERT INTO qulNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Chay p'unchaycunapeka ñac'ariy canka. Chay jina ñac'areyka mana carkanchu Dios cay pachata ruwaskanmantapacha cunancama, nitaj jayc'ajpas chay jinaka cankañachu. ");
INSERT INTO qulNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Señor Dios chay ñac'ariy tiempota mana tucuchanmanchu chayka, ni pipas salvacunmanchu. Astawanri Dios munaskan ajllaskancunaraycu, chay tiempota tucuchanka. ");
INSERT INTO qulNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Chay p'unchaycunapi pipas nisunquichis: ‘¡Khaway, caypi Cristo cachcan!’ chayri ‘¡Jakaypi cachcan!’ nispa chayka, ama creeychischu. ");
INSERT INTO qulNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Falso cristocuna llulla profetacunapas jatarenkacu. Milagrocunata señalcunatawan ruwankacu engañanancupaj; Diospaj ajllacuskancunantinta engañanka, aticojtenka. ");
INSERT INTO qulNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","¡Cuidacuychis! Tucuy cayta willayquichisña, manaraj pasachcajtin. ");
INSERT INTO qulNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Chay p'unchaycunapi ñac'ariy pasayta inti tutayaycaponka, quillapas manaña c'anchamonkachu. ");
INSERT INTO qulNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Koyllurcuna urmakaramonka. Janaj pachapi caj atiycuna qharcatenka. ");
INSERT INTO qulNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Chaymantataj Tataj Churinta phuyupi riconkacu athun atiyninwan sumaj glorioso c'anchayninwan jamuchcajta. ");
INSERT INTO qulNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Chaypacha Dioska angelnincunata cachaspa, tucuy cay pachamanta janaj pachamantapas ajllacuskancunata tantaycuchimonka. ");
INSERT INTO qulNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Higo sach'amanta yachakaychis: Ima ratochus c'allmancuna k'omeryamun, raphincuna ch'ijchiramun, chhica yachanquichisña k'oñi tiempo kayllachamuchcaskanta. ");
INSERT INTO qulNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ajinallatataj kancunapas cay tucuy ima pasajtin, yachanquichis Tataj Churinpaj cutimunan p'unchayka kayllapiña caskanta. ");
INSERT INTO qulNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Segurayquichis, tucuy chay imacunaka canka, cunan tiempo runa causachcajtincuraj. ");
INSERT INTO qulNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Janaj pacha cay pachapas tucuconka; chaywanpas palabraycunaka mana chincankachu junt'acunancama. ");
INSERT INTO qulNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Chay p'unchayta chay horata mana pipas yachanchu, ni angelcuna ni Tataj Churinpas. Dios Tatalla yachan. ");
INSERT INTO qulNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Kancunaka rijch'achcaychis, oracionta ruwaspa listo suyachcaychis. Mana yachanquichischu ima ratochus chayamunayta. ");
INSERT INTO qulNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Cayka cay jina: Uj wasiyoj runaka caruman purinanpaj, wasinmanta manaraj llojsichcaspa, runancunaman llanc'anata kon sapa uj ruwachcananpaj. Puncu khawajtapas mandan cuidachcananpaj cutimunancama. ");
INSERT INTO qulNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Chayraycu rijch'achcaychis. Mana yachanquichischu jayc'aj patrón chayamunanta, tutayaycuytachus, chaupi tutatachus, gallo wajaytachus, chayri p'unchayamuytachus. ");
INSERT INTO qulNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Konkaylla jamonka. Chayraycu rijch'achcaychis, ama puñuchcajta taripanasunquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kancunaman nispaka, tucuyman nini: ¡Rijch'achcaychis!” ");
INSERT INTO qulNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pascua fiestapaj iscay p'unchayllaña cachcajtin, mana levadurayoj t'anta miqhuna tiempo carkan. Sacerdotecunapaj jefencuna leymanta yachachejcunapiwan pacallamanta rimanacorkancu imaynamanta Jesusta jap'ichispa wañuchichinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ninacorkancutaj: —Ama fiesta ratoka jap'ichisunchu, runacuna ama pitucunancupaj —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Betania llajtapi Jesús cachcarkan, lepra onkoymanta alliyaska Simonpaj wasinpi. Chaypi miqhuchcajtintaj, uj warmi chayamorkan, alabastro niska rumi frascopi junt'ata nardomanta k'apayniyoj perfumeta apamuspa, sinchi valorniyojta. Frascopaj cuncanta p'aquispataj, chay perfumewan Jesuspaj umanman jich'aycorkan. ");
INSERT INTO qulNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Waquin chaypi cajcunataj phiñacuspa, paycunapura ninacorkancu: —¿Imaraycutaj cay jina valorniyoj perfumeta usuchichcan? ");
INSERT INTO qulNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Uj quimsa pachaj kolkepi vendicunman carkan, chay kolketa pobrecunaman konapaj. Jinata nispa, chay warmi contra thutorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesustaj nerkan: —Dejallaychis. ¿Imaraycutaj thutupayanquichis? Nokapaj cay ruwaskanka allinmi. ");
INSERT INTO qulNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Pobrecunaka kancunawanpuni cachcancu. Jayc'ajpas munaspaka, allinta paycunapaj ruwayta atinquichis. Nokaka mana tucuy tiempochu kancunawan casaj. ");
INSERT INTO qulNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Cay warmeka atiskanta ruwan. Perfumewan jawiwan, cuerpoyta manaraj p'ampachcawajtincu. ");
INSERT INTO qulNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Segurayquichis, mayllapipas tucuy cay pachapi evangelio willacojtin, cay warmipaj ruwaskan willacullankataj paymanta yuyarinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Chunca iscayniyoj discipuloncunamanta ujnin carkan Judas Iscariote niska. Payka sacerdotecunapaj jefencunawan parlaj purerkan imaynata paycunaman Jesusta entregananpaj. ");
INSERT INTO qulNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Chayta uyarispa paycunaka sinchita cusicorkancu. Judasmantaj prometicorkancu kolketa konancupaj. Jinataj Judaska masc'ayta kallarerkan imaynata Jesusta vendiycunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pascua ñaupaj p'unchaypi, mana levadurayoj t'anta miqhuna p'unchaypi Pascuapaj mut'uta wañuchinancu carkan. Chay p'unchaypi discipuloncuna Jesusta taporkancu: —¿Maypitaj munanqui Pascua cenata waquichimunaycuta? —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jinataj iscay discipuloncunata cachaspa, nerkan: —Llajtaman puriychis. Chaypi uj unu p'uyñu apachcaj runata taripanquichis. Payta katiychis. ");
INSERT INTO qulNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Yaycuskan wasipitaj wasiyoj runata niychis: ‘Yachachej nin: ¿Maypitaj nokapaj cuarto cachcan discipuloycunawan Pascua cenata miqhunaypaj?’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Paytaj wasipaj altosninpi uj athun cuartota ricuchisunquichis, waquichiskataña. Chaypi Pascua cenata nokanchispaj waquichimuychis. ");
INSERT INTO qulNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Iscay discipuloncunataj llajtaman chayaspa Jesuspaj niskanman jina tariparkancu. Chaypi waquicherkancu Pascua cenata miqhunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tutayaycojtintaj, Jesús chunca iscayniyoj discipuloncunawan chayaycamorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Miqhuchcajtincutaj, Jesús nerkan: —Segurayquichis, nokawan miqhuchcaj kancunamanta ujnin vendiycuwanka. ");
INSERT INTO qulNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Paycunataj llaquiska ujmanta uj Jesusta tapuyta kallarerkancu: —¿Nokachu cani? ¿Nokachu cani? —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesustaj paycunata nerkan: —Kancuna chunca iscayniyoj discipuloycunamanta ujnin cachcan. Payka nokawan cusca uj platollapi t'antata chapuchcan. ");
INSERT INTO qulNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Cierto, Tataj Churenka Escrituraman jina purinan can. Chaywanpas, ¡ay, llaquiy, chay pobre runa nokata vendiycuwaj! Allin canman carkan chay runapaj mana nacinanka. ");
INSERT INTO qulNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Miqhuchcajtincutaj, Jesús t'antata okharispa Diosman graciasta korkan. T'antata partispa, paycunaman jaywarkan. Nerkantaj: —Miqhuychis, cayka cuerpoy —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Vasotapas jap'ispa Diosman graciasta kospa, paycunaman jaywarkan. Tucuynincutaj chay vasomanta ujyarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesús nerkan: —Cayka yawarniy, achqha runapaj jich'aska, caywan Diospaj mosoj compromison seguraska canka. ");
INSERT INTO qulNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Segurayquichis, manaña vinota ujyasajchu, jakay p'unchaypi Diospaj gobiernonpi mosoj vinota ujyanaycama. ");
INSERT INTO qulNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Himno taquiy pasayta Olivos lomaman puriporkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Discipuloncunamantaj Jesús nerkan: —Tucuy kancuna cunan tuta sakerpayawanquichis. Cayka canka Escriturapaj niskanman jina: ‘Michejta wañuchisaj, ovejacunataj t'acaraska cankacu.’ ");
INSERT INTO qulNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Causarispataj, kancunamantapas ñaupajta Galileaman purisaj. ");
INSERT INTO qulNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedrotaj Jesusta nerkan: —Tucuynincu sakerpayasunquichisman chaypas, nokacajka mana —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesustaj Pedrota nerkan: —Segurayqui, cunan tutapacha, manaraj gallo iscay cutita wajach'acuchcajtin, kan quimsa cutita negawanqui. ");
INSERT INTO qulNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pedroka atipacuspa astawan nerkan: —Kanwan cusca wañunay cajtinpas, mana negaskayquichu. Jinallatataj tucuynincu nerkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jesús Getsemaní niska huertoman chayaspa, discipuloncunaman nerkan: —Caypi tiyachcaychis oracionta ruwamunaycama. ");
INSERT INTO qulNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pusarkan Pedrota, Santiagota, Juantawan. Jesustaj sinchi mana aguantay llaquicuyta kallarerkan. ");
INSERT INTO qulNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Paycunatataj nerkan: —Sinchi llaquiska cachcani wañunaycama. Caypi quedacuychis, rijch'achcaychistaj. ");
INSERT INTO qulNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Chhicapacha Jesús ñaupajman purispataj, konkoriycorkan. Mat'in pampaman tupanancama c'uñuycuspa, oracionpi mañacorkan sichus aticunman chayka, ñac'arina ama chayamunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nerkantaj: “Munaska Tatáy, kanpajka tucuy ima aticun. Cay ñac'ariymanta libraway, amataj nokapaj munayniychu cachun, manachayri kanpaj munayniyqui ruwacuchun” nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Cutimuspataj, discipuloncunata puñurachcajta tariparkan. Pedrota nerkan: —Simón, ¿puñuchcanquichu? ¿Manachu uj horallatapas rijch'ayta atinqui? ");
INSERT INTO qulNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Rijch'aychis, oracionta ruwaychis ama tentacionman urmanayquichispaj. Allin cajta ruwayta munachcanquichis, chaypajri mana callpayojchu canquichis. ");
INSERT INTO qulNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ujtawan purispa, oracionpi mañacorkan ñaupaj mañacuskanta jina. ");
INSERT INTO qulNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ujtawan cutimuspataj, discipuloncunata puñurachcajta tariparkan. Puñuyta mana aguantayta aterkancuchu. Paycunataj ni ima niytapas aterkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Quimsacaj cutipi cutimuspa paycunata nerkan: —¿Puñuchcanquichisrajchu? ¿Samachcanquichisrajchu? ¡Chayllaña cachun! Chay chhica hora chayamunña, Tataj Churin juchasapa runacunaman entregaska cananpaj. ");
INSERT INTO qulNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Jatariychis, jacuchis! Ña jamuchcanña nokata vendiycojka. ");
INSERT INTO qulNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús parlachcajtinraj, Judas chayamorkan. Payka ujnin chunca iscayniyoj discipulocunamanta carkan. Paywantaj achqha runa espadacunayoj c'aspicunayoj jamorkancu. Sacerdotecunapaj jefencuna, leymanta yachachejcuna, llajtapaj jefencunapiwan runacunata cachamorkancu Jesusta jap'inancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jesusta vendiycoj Judas yachachiska imaynata ricuycuchinanpaj: “Maykentachus noka much'asaj, chay canka. Payta jap'inquichis. Allinta cuidaspa apanquichis” nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Chayaspa jina, Jesusman chimpaycuspa nerkan: —¡Yachachej! —Nispataj, much'aycorkan. ");
INSERT INTO qulNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Jinataj runacunaka Jesusta jap'erkancu, presotataj apaporkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Discipuloncunamanta ujnin espadanta orkhospa, uj runapaj ninrinta cuchokarkan. Chay runataj curaj sacerdotepaj uywaskan carkan. ");
INSERT INTO qulNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesustaj runacunaman nerkan: —¿Imaraycutaj espadacunawan c'aspicunawan nokata jap'ej jamunquichis, uj suwapas cayman jinari? ");
INSERT INTO qulNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Sapa p'unchay kancunawan cachcarkani templopi yachachispa. Manataj jap'iwarkanquichischu. Chaywanpas ajina canan Diospaj palabran junt'acunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Discipuloncunataj Jesusta sakerpayaspa, tucuynincu escapaporkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Uj wayna sabanallawan kataycucuspa, Jesuspaj khepanta purichcarkan. Payta jap'ejtincutaj, ");
INSERT INTO qulNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","sabanata sakerpayaspa k'arapacha escapaporkan. ");
INSERT INTO qulNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Curaj sacerdotecunaj jefenpaj ñaupakenman Jesusta pusarkancu. Chaypitaj Israel jefecuna tucuynincu tantacorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedrotaj Jesusta carullamanta katispa, curaj sacerdotepaj wasi pationcama yaycorkan. Nina kayllapi k'oñicuspa templo guardiajcunawan cusca tiyaricuchcarkan. ");
INSERT INTO qulNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Athun Asambleapi tantacuspataj, sacerdotecunapaj jefencuna, waj jefecunapiwan Jesús contra willajcunata masc'achcarkancu payta wañuchinancupaj. Chaywanpas ni imata tarerkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Achqha llulla testigocuna Jesús contra parlarkancu, chaywanpas niskancoka waj waj carkan. ");
INSERT INTO qulNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Waquin llulla testigocunaka jefecunapaj ñaupakencupi nerkancu: ");
INSERT INTO qulNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Nokaycu Jesusta uyarerkaycu nejta: ‘Noka cay runapaj ruwaskan templota urmachisaj. Quimsa p'unchaypitaj waj templota ruwasaj, mana runacunapaj ruwaskanta jinachu’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Chaywanpas niskancoka mana quiquinchu carkan. ");
INSERT INTO qulNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Curaj sacerdote tucuynincupaj chaupincupi sayaycuspa, Jesusta taporkan: —¿Manachu imatapas contestanqui? ¿Imataj cay kan contra nichcaskancu? —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesustaj ch'inlla carkan, nitaj ni imata contestacorkanchu. Wajmanta Jesusta tapullarkantaj: —¿Kanchu Cristo, bendito Diospaj Churin canqui? ");
INSERT INTO qulNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús nerkan: —Arí, noka cani. Kancunataj ricuwanquichis Tucuy Atiyniyoj Diospaj paña ladonpi tiyachcajta, janaj pachamanta phuyupi jamuchcajtapas. ");
INSERT INTO qulNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Chay niskanta uyarispataj, curaj sacerdoteka p'achancunata lliq'erkan phiñacuskanta ricuchinanpaj. Nerkantaj: —Manaña astawan testigota necesitanchischu. ");
INSERT INTO qulNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kancuna uyarinquichisña cay jinata parlaskanwan Diosta phiñachiskanta. Kancuna, ¿ima ninquichistaj? Tucuynincutaj Jesusta wañuchinapaj juchacharkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Waquintaj Jesusta thutkatayta kallarerkancu. Uyanta kataycuspataj, makaspa nerkancu: —Niy, ¿pitaj makasunqui? —nispa. Guardiajcuna Jesusta uyanpi tacarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro chay wasi patiopi cachcajtin, curaj sacerdotepaj uywaskan sipas jamorkan. ");
INSERT INTO qulNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pedrota nina kayllapi k'oñicuchcajta ricuspa, payta khawarispa nerkan: —Kanpas Nazaret llajtayoj Jesuswan purichcarkanqui. ");
INSERT INTO qulNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedrotaj nerkan: —Mana rejsinichu, ni yachanichu imatachá parlachcanquipas —nispa. Chayta nispataj, puncunejman llojserkan. Chhicataj gallo wajach'acorkan. ");
INSERT INTO qulNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Chay uywaska sipastaj ujtawan khawarispa, chaypi cajcunaman nerkan: —Cay runaka Jesuswan purej —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedrotaj ujtawan Jesusta negarkan. Uj ratomanta chaypi cajcunaka ujtawan Pedrota nerkancu: —Cierto, kanka ujnin paycunamanta canqui, Galileamanta canquipas. ");
INSERT INTO qulNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pedrotaj jurayta kallarerkan maldiciytawan, nispa: —¡Manapuni rejsinichu pimantachus parlachcanquichis chay runataka! ");
INSERT INTO qulNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Chhicapacha ujtawan galloka wajach'acorkan. Pedrotaj chayta uyarispa Jesuspaj niskanta yuyaricorkan: ‘Manaraj gallo iscay cutita wajach'acuchcajtin, kanka quimsa cutita negawanqui' nispa. Chayta yuyarispataj, qhuyayta wakarkan. ");
INSERT INTO qulNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pakariyamuyta sacerdotecunapaj jefencuna, llajtapaj jefencuna, leymanta yachachejcunapiwan Athun Asambleapi tucuynincu tantaycucuspa, Jesusta wataskata aparkancu Pilatoman entreganancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato Jesusta taporkan: —¿Kanchu judiocunapaj Reynin canqui? Jesustaj nerkan: —Kan ninqui, jinapuni —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Sacerdotecunapaj jefencuna imaymanamanta Jesús contra parlachcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Chayraycu Pilato ujtawan tapullarkantaj: —¿Manachu imatapas contestanqui? ¡Uyariy, imaymanamanta juchachachcasunquichis! ");
INSERT INTO qulNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesustaj ni chaywanpas contestarkanchu. Chayraycutaj Pilatoka muspharkan. ");
INSERT INTO qulNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Sapa Pascuapi Pilatoka costumbrenman jina cacharej ujnin presota, maykentachus runacuna mañaskancuta. ");
INSERT INTO qulNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Chay tiempopitaj uj runa, Barrabás sutiyoj, carcelpi preso cachcarkan, uj ch'ajwaypi ujcunawan cusca runata wañuchej. ");
INSERT INTO qulNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Achqha runa tantacamuspataj, Pilatomanta mañayta kallarerkancu costumbreman jina ruwacunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatotaj paycunata taporkan: —¿Judiocunapaj Reynintachu cacharinayta munanquichis? —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilatoka reparacorkan sacerdotecunapaj jefencuna envidiacuspa Jesusta payman entregaskancuta. ");
INSERT INTO qulNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Sacerdotecunapaj jefencunaka runacunata pituspa, yachaycucherkancu Barrabascajta cacharichinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatotaj paycunata ujtawan taporkan: —¿Imanasajtaj judiocunapaj Reynin niskawanri? ");
INSERT INTO qulNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Runacunataj wajach'acorkancu: —¡Chacataska cachun! —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatotaj tapullarkantaj: —¿Imatataj mana allinta ruwanri? —nispa. Paycunataj astawan wajach'acorkancu: —¡Chacataska cachun! —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatotaj runacunawan allinpi cayta munaspa, Barrabasta cachariporkan. Ñaupajta Jesusta bajtanancupaj mandarkan, chaymantataj soldadocunaman entregarkan chacatanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Soldadocuna gobierno wasi patioman Jesusta pusaycorkancu. Chaypitaj tucuy soldadomasincunata wajarkancu tantacunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Jesusta reyta jina morado katanata churaycorkancu. Qhichcamanta coronata ruwaspa, umanman churaycorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Payta asipayaspa burlacuyta kallarerkancu: —¡Judiocunapaj Reynin causachun! —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Umapi c'uparkancu, thutkatarkancutaj, konkoriycuspataj adorayta yanacorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Chay jina burlacuy pasayta, chay morado katanata orkhopuspa paypaj p'achanta churaycuporkancu. Apaporkancu chacatanapaj. ");
INSERT INTO qulNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Cirenemanta Simón, Alejandropaj Rufopajpiwan tatancu, campomanta chayamuchcajtin, soldadocuna jap'ispa mandarkancu Jesuspaj cruzninta apananpaj. ");
INSERT INTO qulNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Gólgota sutiyoj lugarman Jesusta aparkancu. (Gólgota niyta munan: “Calavera Lugar.”) ");
INSERT INTO qulNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Chaymanta Jesusman mirrayoj vinota ujyachiyta munarkancu, Jesustaj mana ujyarkanchu. ");
INSERT INTO qulNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Jesusta chacataspa, soldadocuna paypaj p'achancunata partinacunancupaj sortearkancu, imatachus sapa uj apacunancuta yachanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Chacataycojtincu, iskon hora carkan. ");
INSERT INTO qulNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Letrerota churarkancu imamantachus wañuchiskancumanta: “Judiocunapaj Reynin” nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jesuswan cusca chacatallarkancutaj iscay suwacunata, ujninta pañannejpi ujnintataj llok'ennejpi. ");
INSERT INTO qulNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Chaywan junt'acorkan Escriturapaj niskan: “Juchasapacunawan yupaska.” ");
INSERT INTO qulNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Chayninta pasajcunapas umancuta maywispa, insultarkancu, cay jinata nispa: —¡Bah, kan, Diospaj templonta urmachej, quimsa p'unchaypitaj ruwarkoj! ");
INSERT INTO qulNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Kan quiquiyqui salvacuy, cruzmanta urakamuy. ");
INSERT INTO qulNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ajinallatataj sacerdotecunapaj jefencuna leymanta yachachejcunapiwan Jesusmanta burlacuspa, nerkancu: —Wajcunata salvarkan, pay quiquintaj mana salvacuyta atinchu. ");
INSERT INTO qulNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","¡Cristo, Israelpaj Reynin, cunan cruzmanta urakay ricunaycupaj, creenaycupajtaj! Ajinallatataj chacataska cajcunaka burlacorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Chaupi p'unchaymanta chaupi tardecama, tucuy cay pacha tutayaycorkan. ");
INSERT INTO qulNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Chaupi tardetataj Jesús callpawan wajach'acuspa nerkan: “Eloi, Eloi, ¿lema sabactani?” nispa. (Cay niyta munan: “Diosníy, Diosníy, ¿imaraycutaj sakerpariwanqui?”) ");
INSERT INTO qulNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Waquin chaypi cajcunamanta payta uyarispa nerkancu: —Uyariychis, profeta Eliasta wajachcan. ");
INSERT INTO qulNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ujnin runataj phawaspa vinagreman esponjata chaporkan. C'aspiman churaspataj, korkan ch'umuycunanpaj. Nerkantaj: —Dejallaychis. Ricusunchis, ichapas Elías jamuspa apakanka —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesustaj callpawan wajach'acuspa, wañuporkan. ");
INSERT INTO qulNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Templo uqhupi athun cortinantaj iscayman lliq'icorkan, janajmanta urayman. ");
INSERT INTO qulNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jesuspaj ñaupakenpi uj capitán romano sayachcarkan. Imaynata wañupuskanta ricuspataj, nerkan: —Ciertopuni cay runaka Diospaj Churin —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Waquin warmicunataj carumanta khawachcarkancu. Paycuna uqhupi cachcarkancu María Magdalena, sullc'acaj Santiagopaj Josepajpiwan mamancu María, Salomepiwan. ");
INSERT INTO qulNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jesús Galileapiraj cachcajtin, chay warmicuna paywan purichcaspa sirverkancu. Cachcallarkancutaj waj achqha warmicuna Jesuswan Jerusalenman purejcunamanta. ");
INSERT INTO qulNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Samana p'unchaypaj waquichicuna p'unchay ch'isiyaycuchcajtin, ");
INSERT INTO qulNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Arimatea llajtayoj José Pilatoman purerkan. Chay Joseka Athun Asambleapi importante carkan. Payka Diospaj gobiernonta suyachcallajtaj. Mana mancharicuspa, Pilatomanta Jesuspaj cuerponta mañarkan. ");
INSERT INTO qulNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatoka Jesús wañuskaña caskanmanta muspharkan. Chayraycu capitanta wajaspa taporkan jayc'ajmanta wañupuskanta. ");
INSERT INTO qulNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Wañuskaña caskanta yachaspataj, Joseman permisota korkan Jesuspaj cuerponta apakapunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josetaj fino sabanata rantimuspa, Jesusta cruzmanta apakarkan. Sabanapi p'istuycuspa, kaka jutc'uska sepulturaman churaycorkan. Puncutataj rumiwan tapaycorkan. ");
INSERT INTO qulNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalenataj Josepaj maman Mariapiwan ricorkancu maypichus Jesús churaska caskanta. ");
INSERT INTO qulNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Samana p'unchay pasajtin, María Magdalena, Santiagopaj maman María, Salomepiwan sumaj k'apayniyoj perfumecunata rantimorkancu Jesuspaj cuerponta jawimunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Semana kallariy p'unchayta sinchi tutamanta inti llojsimuchcajtin, chay warmicunaka Jesuspaj sepulturanman purerkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Paycunataj tapunacuchcarkancu: —¿Pitaj sepultura tapaska rumita quicharapuwasun? —nispa. ");
INSERT INTO qulNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Khawarispa ricorkancu quicharaskaña caskanta. Chay may athun tapaskancu rumi manaña churaskancu chhicapichu carkan. ");
INSERT INTO qulNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Sepulturaman yaycuspataj, pañanejpi ricorkancu uj waynata tiyachcajta, yuraj p'achayojta. Chayta ricuspataj mancharicorkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Waynataj paycunata nerkan: —Ama manchacuychischu. Nazaret llajtayoj Jesusta masc'achcanquichis, chacataska carkan chayta. Payka causarimpunña, mana caypichu. Khawaychis churaskancu lugarta. ");
INSERT INTO qulNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Puriychis, discipuloncunaman Pedromanpiwan willamuychis: ‘Jesús ñaupakeyquichista Galileaman purenka. Chaypi ricunquichis niskasunquichisman jina.’ ");
INSERT INTO qulNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Warmicunataj sepulturamanta llojsispa phawarkancu, mancharicuymanta qharcatispa. Nitaj pimanpas ni imata nerkancuchu manchacuskancuraycu. ");
INSERT INTO qulNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Semana kallariy p'unchayta tutamanta causarimuspa, Jesuska ñaupajta María Magdalenaman riqhurerkan. Unayña Galileapiraj cachcaspa, Jesuska paymanta kanchis sajra espirituta katerkoska. ");
INSERT INTO qulNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Payka Jesuspaj discipuloncunaman willaj purerkan. Paycunataj llaquiska wakachcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","“Jesús causariskaña, ricuni” nispa warmipaj niskanta uyarispataj, mana creerkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Cay pasaymanta iscay discipuloncuna campoman purichcajtincu, Jesús paycunaman riqhurerkan waj jinata. ");
INSERT INTO qulNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Paycunataj cutimuspa waj discipuloncunaman ricuskancuta willarkancu. Ni paycunatapas creellarkancutajchu. ");
INSERT INTO qulNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Khepantin mesapi miqhunancupaj tiyacuchcajtincu, Jesús chunca ujniyoj discipuloncunaman riqhurerkan. Payta causarimuskanta ricojcunata mana creeskancuraycu, paycunata c'amirarkan mana creeskancumanta, khoru sonkoyoj caskancumantawan. ");
INSERT INTO qulNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jesuska paycunaman nerkan: “Tucuy cay pachata puriychis. Tucuy runacunaman salvación evangeliota willaramuychis. ");
INSERT INTO qulNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Pichus creejka bautizachicojtaj, salvaska canka; mana creejcunataj juchachaska cankacu. ");
INSERT INTO qulNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Creejcunaka caycunata ruwankacu: sutiypi sajra espiritucunata katerkonkacu; waj mosoj idiomacunata parlankacu; ");
INSERT INTO qulNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","pallipas, venenopas mana imanankachu; onkoskacunaman maquincuta churaspa alliyachenkacu.” ");
INSERT INTO qulNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Señor paycunata parlapayay pasayta janaj pachaman okhariska caporkan, Diospaj paña ladonpitaj tiyaycaporkan. ");
INSERT INTO qulNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Discipuloncunataj tucuynejpi puriporkancu evangeliota willaraj. Señortaj yanapachcarkan, milagrocunata ruwaskancuwan willaskancu verdad caskanta ricuchispa. Ajina cachun.");
INSERT INTO qulNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Sinchi respetaska Teófilo, nokaycu uqhupi ima pasaskancunamanta achqhayoj escriberkancu, ");
INSERT INTO qulNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Jesuspaj naciskanmantapacha ricojcuna yachachiwaskanchisman jina. Paycunataj Diosmanta jap'ekarkancu evangeliota willaranancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nokapas Jesuspaj naciskanmantapacha tucuy ima pasaskanta sumajta tapurani, allin yuyaywan sumaj ordenpi escribimunaypaj, ");
INSERT INTO qulNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","yachachiskasunquichis cierto caskanta yachanayquipaj. ");
INSERT INTO qulNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Judea provinciapi Herodes gobernachcajtin, Abiaspaj gruponmanta uj sacerdote carkan Zacarías sutiyoj. Warmin Isabeltaj Aaronpaj mirayninmanta carkan. ");
INSERT INTO qulNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Iscaynincu Diospaj ñaupakenpi justo carkancu, casucojtaj Señorpaj tucuy mandacuskanta. Chayraycu ni pipas ni imamanta juchachayta atinmanchu carkan. ");
INSERT INTO qulNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mana wawancu carkanchu, imaraycuchus Isabel mana onkojyayta atejchu. Iscaynincutaj sinchi machu payaña carkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Uj p'unchay Zacariaspaj gruponman tuparkan Dios adorana templopi sirvinanpaj. ");
INSERT INTO qulNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Sacerdotecunapaj costumbrenman jina sorteota ruwarkancu. Sorteopitaj Zacariasman tuparkan, santo lugarpi Señorman inciensota k'osnichinanpaj. ");
INSERT INTO qulNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","K'osnichichcajtintaj, tucuy runa jawanejpi oracionta ruwachcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ajinapi Señorpaj uj angelnin Zacariasman riqhurerkan, incienso altarpaj pañannejpi sayachcaj. ");
INSERT INTO qulNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Angelta ricuspa Zacarías mulljacorkan, mancharicorkantaj. ");
INSERT INTO qulNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Angeltaj payta nerkan: —Ama mancharicuychu, Zacarías. Dios oracionniyquita uyarin. Warmiyqui Isabel uj churiyoj canka, Juanta sutichanqui. ");
INSERT INTO qulNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","May cusiska canqui naciskanmanta, achqhayojtaj cusiconkacu. ");
INSERT INTO qulNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Imaraycuchus churiyqueka Señorpaj ñaupakenpi athun canka. Mana vinota ni ima machachejta ujyankachu. Manaraj nacichcajtin, Santo Espirituwan junt'a canka. ");
INSERT INTO qulNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Israel nacionmanta achqhayojta Señor Diosnincuman cutichenka. ");
INSERT INTO qulNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Cay Juanka, Señor jamojtinraj, profeta Eliaspaj atiyninwan Diospaj Espiritunwantaj purenka, tatacunata wawancunawan allinyachinanpaj, mana casucojcuna casucuyta yachakanancupaj. Jinamanta runacunata waquichenka Señorta jap'ekanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacarías angelta taporkan: —¿Imaynatataj yachasaj cay junt'acunanta? Nokaka machulaña cani, warmiypas awichaña. ");
INSERT INTO qulNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Angeltaj contestarkan: —Noka Gabriel cani, Diospaj mandaska sirvejnin. Pay cachamuwan cay sumaj noticiata kanman willanaypaj. ");
INSERT INTO qulNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Cunantaj niskayta mana creeskayquiraycu, jup'a tucunqui cunanmanta churiyqui nacinancama, cay niskay junt'acunancama. ");
INSERT INTO qulNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Chaycamataj runacunaka jawapi Zacariasta suyachcarkancu, mana uskhayta llojsimuskanmanta tapunacuspa. ");
INSERT INTO qulNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Llojsimuspataj, mana parlayta aterkanchu. Chayraycu, “Imachá santo lugarpi payman riqhurin” nerkancu. Zacariastaj manaña parlayta atispa, señascunallawanña entendicherkan. ");
INSERT INTO qulNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zacariastaj sirviyta tucuspa, wasinman cutiporkan. ");
INSERT INTO qulNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Chay pasaymanta warmin Isabel onkojyaporkan. Phichka quillata wasinmanta mana llojserkanchu, sonkonpi pensaspa: ");
INSERT INTO qulNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Señor cayta ruwawan, runacuna manaña desprecianawancupaj” nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Isabel sojta quilla onkojña cajtin, Dios ángel Gabrielta cacharkan Galileapi caj Nazaret llajtaman, ");
INSERT INTO qulNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","manaraj kharita rejsej sipas Mariaman. Paytaj casaracunanpaj parlaska carkan Josewan, gobernaj Davidpaj mirayninmanta. ");
INSERT INTO qulNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Angeltaj María cachcaskan lugarman yaycuspa nerkan: —¡Saludayqui, Diospaj ajllaskan! Señor kanwan cachcan —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Angelpaj niskanta uyarispataj, María mulljacorkan, muspharkantaj, “¿Ima niytataj munan?” nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Angeltaj payta nerkan: —Ama manchacuychu, María, Dios favorninwan kanta bendicisunqui. ");
INSERT INTO qulNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Cunan onkojyanqui: uj churiyoj canqui, sutichanqui Jesusta. ");
INSERT INTO qulNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Pay athun canka, sinchi athun Diospaj Churin. Señor Dios gobernajta churanka, ñaupaj gobernaj Davidta jina. ");
INSERT INTO qulNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Israel nacionta wiñaypaj gobernanka; gobiernontaj mana jayc'aj tucucuyniyoj canka. ");
INSERT INTO qulNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","María angelta taporkan: —Mana khariwan caspa, ¿imaynatataj wawayoj cayman? ");
INSERT INTO qulNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Angeltaj contestarkan: —Santo Espíritu sinchi athun Diospaj atiyninwan kanman jamonka uj phuyu jina. Chayraycu chay naciska wawapaj sutenka Santo, Diospaj Churin canka. ");
INSERT INTO qulNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Parienteyqui Isabelpas awicha cayninpi wawayoj canka. Mana wawayoj cay atej niskancupas sojta quilla onkojña. ");
INSERT INTO qulNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Diospajka tucuy ima aticun. ");
INSERT INTO qulNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","María nerkan: —Diospaj niskan ruwaska cachun niwaskayquiman jina, imaraycuchus noka Señorpaj sirvejnin cani. Angeltaj riporkan. ");
INSERT INTO qulNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Chay p'unchaycuna María uskhayta purerkan uj llajtaman, loma lomayoj Judea provinciaman. ");
INSERT INTO qulNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Chayaspataj, Zacariaspaj wasinman yaycuspa Isabelta saludarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mariapaj saludaskanta Isabel uyarejtin, wijsanpi wawa cuyurerkan. Isabeltaj Santo Espirituwan junt'a caporkan. ");
INSERT INTO qulNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Chhicataj alto vozwan parlaspa nerkan: —¡Tucuy warmicunamanta nejtin Diospaj astawan bendiciskan canqui, churiyquipas bendiciska! ");
INSERT INTO qulNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Pitaj noka cani, Señorniypaj maman watunawanpaj? ");
INSERT INTO qulNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Saludawaskayquita uyarejtiy jina, waway cusicuywan wijsay uqhupi cuyurin. ");
INSERT INTO qulNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","¡May cusicuyniyoj canqui, Señorpaj niskan junt'acunanta creeskayquiraycu! ");
INSERT INTO qulNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mariataj nerkan: “Almay Señorpaj athun cayninta alaban, ");
INSERT INTO qulNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","espirituytaj Salvawaj Diosniypi cusicun, ");
INSERT INTO qulNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","imaraycuchus Dios khawariwan humilde sirvejninta. Cunanmanta tucuy runa cusiska niwankacupuni, ");
INSERT INTO qulNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tucuy Atiyniyoj Dios athun musphaycunata nokapaj ruwaskanraycu. ¡Payka Santo! ");
INSERT INTO qulNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Dioska pay respetajcunata qhuyapayallanpuni. ");
INSERT INTO qulNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Tucuy atiyninwan ruwan, piturparispa pay pay wapu tucojcunapaj ruway munaskancuta. ");
INSERT INTO qulNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Gobernajcunata urmachin, humillacojcunata athunyachin. ");
INSERT INTO qulNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Yarekaskacunaman tucuy imata kon, khapajcunatataj mana imayojta cachapun. ");
INSERT INTO qulNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ajllaska Israel llajtanta yanaparkan, qhuyapayacuywan mana konkanchu. ");
INSERT INTO qulNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ajinata prometicuska ñaupaj abuelonchiscunaman, Abrahamman, paypaj miraynincunamanpiwan.” ");
INSERT INTO qulNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María quimsa quillata Isabelwan cachcarkan, chaymanta wasinman cutiporkan. ");
INSERT INTO qulNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Isabelpaj onkocunan tiempo junt'acojtin, churiyoj caporkan. ");
INSERT INTO qulNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kayllamasincuna parientencunapas Señor Dios payta qhuyapayaskanta yachaspa, cusicorkancu; chayraycu purerkancu Isabelta felicitaj. ");
INSERT INTO qulNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Pusaj p'unchayniyojta wawata aparkancu circuncisión costumbreta ruwanancupaj. Tatanpaj sutin Zacariasta churayta munarkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mamantaj nerkan: —Mana. Juan sutin canan. ");
INSERT INTO qulNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Paycunataj nerkancu: —Familiayquipi mana pipas canchu chay sutiyojka. ");
INSERT INTO qulNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Chhicataj wawapaj tatanta señaswan taporkancu yachanancupaj ima sutitachus churay munaskanta. ");
INSERT INTO qulNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tatantaj escribinanpaj tablata mañaspa, escriberkan: “Sutenka Juan” nispa. Tucuynincutaj musphararkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Chhicapachataj Zacarías wajmanta parlaporkan, Diostataj alabarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tucuy kayllamasincunataj mulljaricorkancu. Tucuynejpi loma lomayoj Judea provinciapi willanacorkancu chay pasaskanmanta. ");
INSERT INTO qulNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tucuy uyarejcunataj sonkoncupi nerkancu: “¿Imataj canka cay wawari?” nispa, imaraycuchus Señor Dios atiyninta ricucherkan paypaj allinninpaj. ");
INSERT INTO qulNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Juanpaj tatan, Zacarías, Santo Espirituwan junt'a cachcaspa, Diospaj sutinpi parlarkan: ");
INSERT INTO qulNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“¡Israelpaj Señor Diosnin alabaska cachun, imaraycuchus runancunata salvaj jamun! ");
INSERT INTO qulNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Atiyniyoj Salvadorta cachamuwanchis, Dios casucoj sirvejnin Davidpaj mirayninmanta. ");
INSERT INTO qulNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Diospaj santo profetancuna willaskacu Dios ñaupajña prometicuskanta: ");
INSERT INTO qulNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","enemigonchiscunamanta tucuy chejnicojninchiscunamantawan salvanawanchista, ");
INSERT INTO qulNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ñaupaj abuelonchiscunata qhuyapayacunanta, santo compromisonta mana konkapuspa. ");
INSERT INTO qulNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Cay ari, chay promesa Dios juramentowan tatanchis Abrahamwan ruwaskanka, ");
INSERT INTO qulNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","enemigonchismanta libranawanchista, Diosllata sirvinanchispaj mana ni imata manchacuspa, ");
INSERT INTO qulNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Diospaj ñaupakenpi justo mana juchayoj cananchispaj tucuy p'unchay causananchiscama. ");
INSERT INTO qulNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Kanri, wawitáy, sinchi athun Diospaj profetan niska canqui. Señorpaj ñaupakenta purinqui ñanta waquichispa, ");
INSERT INTO qulNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","runacunaman willaspa Dios juchancunata perdonananta salvanantawan. ");
INSERT INTO qulNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Diosninchis athun qhuyapayacuyninpi janaj pachamanta c'anchayta apamuwanchis uj mosoj p'unchaymanta, ");
INSERT INTO qulNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","laja tutayajpi tiyajcunaman c'anchayta konanpaj, sonko tiyaycuypi pusanawanchispaj.” ");
INSERT INTO qulNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Wawa Juan wiñachcarkan, astawan callpayoj espiritunpi. Ch'usaj lugarpitaj tiyarkan, Israel runacunaman rejsichicunan p'unchaycama. ");
INSERT INTO qulNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Chay p'unchaycunapi gobernaj Augusto César mandacorkan tucuy runa yupaska canancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Cay ñaupajcaj yupaytaj carkan Cirenio gobernachcajtin Siria nacionpi. ");
INSERT INTO qulNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Tucuy puripunancu carkan quiquin llajtancuman yupachicoj. ");
INSERT INTO qulNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Chayraycutaj Joseka Galileapi caj Nazaret llajtamanta llojsispa, puriporkan Judeapi caj Belenman, maypichus abuelon gobernaj David naciskanman, Davidpaj miraynin caskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Mariawan purerkan yupachicunancupaj. Mariataj Josewan comprometiska cachcarkan casaracunanpaj, paytaj onkojña carkan. ");
INSERT INTO qulNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Belenpi cachcajtincutaj, onkocunan p'unchay chayamorkan. ");
INSERT INTO qulNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Chaypi ñaupaj churinta onkocaporkan. Pañalcunawan wawanta p'istuycuspataj, uywaman karanapi siriycucherkan, paycunapaj alojamiento mana caskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Belén kayllapi michejcuna tutapi ovejata michichcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Señorpaj uj angelnin paycunaman riqhurimorkan. Señorpaj sumaj glorioso c'anchaynintaj paycunaman c'anchaycorkan. Chayraycu paycuna sinchita mancharicorkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Angeltaj paycunaman nerkan: “Ama manchacuychischu, imaraycuchus sumaj noticiacunata apamuyquichis tucuy runacuna cusicunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Cunan Davidpaj llajtanpi uj salvador nacipusunquichis; chayka Mesías niska Cristo, Señor. ");
INSERT INTO qulNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Imaynata rejsinayquichispaj, cay señalka: kancuna pañalcunawan p'istuska wawata tarinquichis, uywaman karanapi sirichcajta” nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Chhicapacha janaj pachamanta achqha angelcuna riqhurimorkancu, Diosta alabaspataj nerkancu: ");
INSERT INTO qulNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“¡Janaj pachapi Dios alabaska cachun! ¡Cay pachapitaj sonko tiyaycuy cachun Diospaj qhuyapayaskan runacunapaj!” ");
INSERT INTO qulNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Angelcuna janaj pachaman cutipojtincu, michejcuna ninacorkancu: —¡Jacuchis Belenman! Ricumusunchis ima pasaskanta Señor Dios willawaskanchista. ");
INSERT INTO qulNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Uskhayta purispa, Mariata, Joseta, uywaman karanapi sirichcaj wawatawan tarerkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ricuspataj, chay wawamanta angelpaj niskanta willarkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Uyarejcunataj michejcunapaj niskanmanta musphararkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","María tucuy ima uyariskanta sonkonpi wakaycharkan, yuyachcarkantaj. ");
INSERT INTO qulNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Michejcunataj cutiporkancu, tucuy ricuskancumanta, uyariskancumanta, angelpaj niskanman jina pasaskanmantawan Diosta honrawan gloriawan alabaspa. ");
INSERT INTO qulNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Pusaj p'unchayniyojta wawata circuncisión costumbreta ruwarkancu. Sutintataj churarkancu, Jesusta, manaraj onkoj cachcajtin Mariaman angelpaj niskanman jina. ");
INSERT INTO qulNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moisespaj leyninman jina José Mariapiwan limpiochacunancu p'unchaycuna junt'acojtintaj, Jerusalenman wawata aparkancu Señor Diosman entreganancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Chayta ruwarkancu, Diospaj leyninpi cay jina escribiska caskanraycu: “Tucuynin ñaupaj chureka Señor Diosllaman entregaska canka.” ");
INSERT INTO qulNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Iscay palomata temploman apallarkancutaj, Diospaj leyninman jina ofrendata konancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jerusalenpi tiyacorkan uj runa, Simeón sutiyoj. Justo runa carkan, Diosta adoraj, Israel runacunapaj salvacionnincuta suyaspa. Santo Espíritu Simeonwan cachcarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Chay Santo Espiritutaj Simeonman willarkan manaraj wañupuchcaspa Diospaj cachamuskan Cristota ricunanta. ");
INSERT INTO qulNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Chayraycu Santo Espíritu payta temploman pusarkan. Chay rato José Mariapiwan wawa Jesusta temploman apamorkancu, ley mandaskanta junt'anancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeonka wawata ichuricuspa, Diosta alabarkan nispa: ");
INSERT INTO qulNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Cunan, Señor, promesayqueka niwaskayquiman jina junt'acun. Chayraycu sonko tiyaska wañupuyta atini. ");
INSERT INTO qulNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Imaraycuchus salvacionta ricuniña. ");
INSERT INTO qulNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Chay ruway kallariskayquita tucuy runacuna ricuyta atincuman. ");
INSERT INTO qulNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Chay salvacionka nacioncunata c'anchayconka. Payraycu Israel llajtayqueka honrayoj canka.” ");
INSERT INTO qulNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jesuspaj tata maman musphararkancu Simeonpaj niskanta uyarispa. ");
INSERT INTO qulNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeón wawata bendicerkan, nerkantaj Jesuspaj maman Mariaman: —Uyariy, cay wawataka Dios churan Israelpi caj achqhayoj urmanancupaj chayri sayarinancupaj. Payka uj señal canka, achqhayojtaj mana jap'ekankacuchu. ");
INSERT INTO qulNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ajinapi achqhayojpaj sonkopi pensaskancu sut'inchaconka. Tucuy caycunataj espadawan allaska jina sonkoyquita nanachisunqui. ");
INSERT INTO qulNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Chaypi cachcallarkantaj uj warmi, Ana sutiyoj, Diospaj sutinpi parlaj, Fanuelpaj ususin, Aserpaj mirayninmanta. Sinchi awichaña carkan. Sinchi sipasita casaracuska, kosanwantaj kanchis watallata tiyaska. ");
INSERT INTO qulNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Pusaj chunca tawayoj wataña viuda caska, templomanta mana llojsipuspa tuta p'unchay Señorta sirvej, ayunaspa oracionta ruwaspa. ");
INSERT INTO qulNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Chhicapacha Ana riqhurimuspa, Diosman graciasta koyta kallarerkan. Wawa Jesusmantataj willarkan tucuy Jerusalenpi caj salvacionninta suyajcunaman. ");
INSERT INTO qulNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Tucuy imata Señorpaj leyninman jina junt'aspataj, Galileapi caj Nazaret llajtancuman cutiporkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Wawataj astawan callpayoj, astawan yachayniyojtaj wiñachcarkan, Diospaj bendicionnincunawan. ");
INSERT INTO qulNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jesuspaj tata maman sapa wata purej cancu Jerusalenman Pascua fiestaman. ");
INSERT INTO qulNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ajinata Jesús chunca iscayniyoj watayoj cachcajtin, tata maman pusarkancu Pascua fiestaman purinapuni caskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pascua pasayta wasiman cutipuchcajtincu, wawa Jesús Jerusalenpi quedacaporkan, tata mamanpaj mana reparaskan. ");
INSERT INTO qulNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Jesús runa uqhupi purichcaskanta yuyaspa, uj p'unchay puriymantaña Jesusta watucorkancu. Parientencuna rejsiskancuna ima uqhupi masc'arkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mana tarispataj, Jerusalén llajtacama cuterkancu, chaypi masc'anancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Quimsa p'unchaymanta Jesusta tarerkancu templopi, leymanta yachachejcuna chaupinpi tiyachcajta, paycunata uyarispa tapuspataj. ");
INSERT INTO qulNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tucuy uyarejcunataj muspharachcarkancu yachayniyoj caskanmanta contestaskancunamantapiwan. ");
INSERT INTO qulNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tata maman Jesusta ricuspa, mulljaricorkancu. Mamantaj payta nerkan: —Wawáy, ¿imaraycutaj cayta ruwawanquichis? Tatayqui nokapiwan llaquiska masc'ayquichis. ");
INSERT INTO qulNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesustaj contestarkan: —¿Imaraycutaj masc'awarkanquichis? ¿Manachu yachanquichis Tataypaj wasinpi canayta? ");
INSERT INTO qulNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Paycunataj mana entenderkancuchu chay niskanta. ");
INSERT INTO qulNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Chaymanta tata mamanwan Nazaretman puriporkan; chaypitaj tucuy imapi casucuspa causarkan. Mamantaj sonkonpi tucuy caycunata yuyachcarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesustaj cuerpopi yachaypipas wiñachcallarkanpuni, Dioswan runacunawanpas munachicuspa. ");
INSERT INTO qulNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Gobernaj Tiberio César chunca phichkayoj wataña gobernachcajtin, Poncio Pilato gobernachcarkan Judea provinciapi, Herodestaj Galilea provinciapi, Herodespaj wauken Felipetaj Itureapi Traconitepi ima, Lisaniastaj Abiliniapi. ");
INSERT INTO qulNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás Caifaspiwan curaj sacerdotecuna carkancu. Chay tiempopi Dios Zacariaspaj churin Juanta parlapayarkan ch'usaj lugarpi cachcajtin. ");
INSERT INTO qulNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jordán mayu ladopi tucuynejman Juan purerkan. Runacunaman willaraspa nerkan: —Juchayquichiscunata sakespa Diosman cutiricuychis. Bautizachicuychis, Dios juchayquichiscunata perdonananpaj —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Chaywan junt'acorkan Diospaj profetan Isaiaspaj escribiskan: “Ch'usaj lugarpi uj runa wajach'aconka: ‘Señor jamuchcan. Sonkoyquichista waquichiychis recto ñanta jina. ");
INSERT INTO qulNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tucuy wayk'ocuna junt'achiska canka, tucuy orkocuna lomacunapas pampayachiska. K'ewi ñancuna rectoyachiska, moko moko ñancunapas pampachaska canka. ");
INSERT INTO qulNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tucuy runacunataj riconkacu Diosmanta jamoj salvacionta.’ ” ");
INSERT INTO qulNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Runacuna Juanman purichcarkancu bautizachicunancupaj. Paycunaman Juan nerkan: “¡Pallicunapaj miraynin! ¿Pitaj nerkasunquichis Diospaj jamoj castigonmanta libracunayquichista? ");
INSERT INTO qulNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Allinta causaychis, Diosman cutiriskayquichis sut'ita ricuchicunanpaj. Amataj ninacuychischu: ‘Nokanchiska Abrahampaj wawancuna canchis’ nispaka. Segurayquichis, Dios cay rumicunatapas tucuchiyta atin Abrahampaj wawancunaman. ");
INSERT INTO qulNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Jachapas listoña sach'acunata saphinmantapacha p'atanapaj. Tucuy mana allin urej sach'ataka p'ataspa, ninaman wijch'una. Ajinata Dios castigasunquichis.” ");
INSERT INTO qulNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Juanpaj niskanta uyarispa, taporkancu: —¿Imatataj ruwasajcu? —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juantaj nerkan: —Iscay p'achayoj cajka ujninta mana p'achayojman kochun. Ajinallatataj miqhunayoj cajpas mana miqhunayojman kochun. ");
INSERT INTO qulNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Waquin Romapaj impuesto cobrajcunapas bautizachicoj jamullarkancutaj. Juanta taporkancu: —Yachachej, ¿imatataj nokaycu ruwasajcu? ");
INSERT INTO qulNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juan nerkan: —Leyman jina cobraychis, ama yapaskataka. ");
INSERT INTO qulNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Soldadocuna tapullarkancutaj: —Nokaycurí, ¿imatataj ruwasajcu? Juan paycunata nerkan: —Ama pimantapas ni imanta kechuychischu, nitaj pitapas kasimanta tumpaychischu amenazaspa. Contentacuychis pagoyquichiswan. ");
INSERT INTO qulNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Chayta uyarispataj, runacunaka sonkoncupi pensarkancu: “¿Manachu Juanri Cristo canman?” nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Juantaj tucuy runacunaman nerkan: “Ciertopuni noka unullawan bautizayquichis. Chaywanpas nokamanta uj astawan atiyniyoj jamuchcan. Paypaj ñaupakenpi ni imapaschu cani, abarcancunata pascaranallaypajpas. Paycaj Santo Espirituwan ninapiwan bautizasunquichis. ");
INSERT INTO qulNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Maquinpi wayrachinata apamuchcan, trigota limpiochaspa trojenpi wakaychananpaj, yurantataj mana jayc'aj wañoj ninawan ruphachipunanpaj.” ");
INSERT INTO qulNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Cay jinamanta achqha cunaycunawan Juan sumaj evangeliota willarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Juanka gobernaj Herodestapas c'amillarkantaj wauken Felipepaj warmin Herodiaswan tiyapuskanmanta, tucuy mana allincuna ruwaskanmantawan. ");
INSERT INTO qulNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herodestaj uj mana allintawan ruwarkan, Juanta carcelman wisk'aycuchispa. ");
INSERT INTO qulNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Juan manaraj carcelman wisk'aycuska cachcaspa, achqhayoj jamojcunata bautizachcajtin, Jesús jamuspa bautizachicullarkantaj. Oracionta ruwachcajtin, janaj pacha quicharacorkan. ");
INSERT INTO qulNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Santo Espiritutaj uj paloma jina Jesusman urakamorkan. Janaj pachamanta Dios parlamorkan: —Kancajka munaska Churiy canqui, ajllaskay —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús quimsa chunca watayoj jina Diospaj evangelionta willarayta kallarerkan. Runacunapaj pensaskancuman jina, Jesuska Josepaj churin, Josetaj Elipaj churin, ");
INSERT INTO qulNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","paytaj Matatpaj churin, paytaj Levipaj churin, paytaj Melquipaj churin, paytaj Janapaj churin, paytaj Josepaj churin, ");
INSERT INTO qulNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","paytaj Matatiaspaj churin, paytaj Amospaj churin, paytaj Nahumpaj churin, paytaj Eslipaj churin, paytaj Nagaipaj churin, ");
INSERT INTO qulNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","paytaj Maatpaj churin, paytaj Matatiaspaj churin, paytaj Semeipaj churin, paytaj Josecpaj churin, paytaj Judapaj churin, ");
INSERT INTO qulNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","paytaj Joananpaj churin, paytaj Resapaj churin, paytaj Zorobabelpaj churin, paytaj Salatielpaj churin, paytaj Neripaj churin, ");
INSERT INTO qulNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","paytaj Melquipaj churin, paytaj Adipaj churin, paytaj Cosampaj churin, paytaj Elmadampaj churin, paytaj Erpaj churin, ");
INSERT INTO qulNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","paytaj Jesuspaj churin, paytaj Eliezerpaj churin, paytaj Jorimpaj churin, paytaj Matatpaj churin, ");
INSERT INTO qulNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","paytaj Levipaj churin, paytaj Simeonpaj churin, paytaj Judapaj churin, paytaj Josepaj churin, paytaj Jonampaj churin, paytaj Eliaquimpaj churin, ");
INSERT INTO qulNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","paytaj Meleapaj churin, paytaj Menapaj churin, paytaj Matatapaj churin, paytaj Natanpaj churin, ");
INSERT INTO qulNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","paytaj Davidpaj churin, paytaj Isaipaj churin, paytaj Obedpaj churin, paytaj Boozpaj churin, paytaj Salapaj churin, paytaj Naasonpaj churin, ");
INSERT INTO qulNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","paytaj Aminadabpaj churin, paytaj Adminpaj churin, paytaj Arnipaj churin, paytaj Esrompaj churin, paytaj Farespaj churin, paytaj Judapaj churin, ");
INSERT INTO qulNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","paytaj Jacobpaj churin, paytaj Isaacpaj churin, paytaj Abrahampaj churin, paytaj Tarepaj churin, paytaj Nacorpaj churin, ");
INSERT INTO qulNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","paytaj Serugpaj, churin, paytaj Ragaupaj churin, paytaj Pelegpaj churin, paytaj Heberpaj churin, paytaj Salapaj churin, ");
INSERT INTO qulNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","paytaj Cainanpaj churin, paytaj Arfaxadpaj churin, paytaj Sempaj churin, paytaj Noepaj churin, paytaj Lamecpaj churin, ");
INSERT INTO qulNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","paytaj Matusalenpaj churin, paytaj Enocpaj churin, paytaj Jaredpaj churin, paytaj Mahalaleelpaj churin, paytaj Cainanpaj churin, ");
INSERT INTO qulNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","paytaj Enospaj churin, paytaj Setpaj churin, paytaj Adanpaj churin, paytaj Diospaj churin carkan. ");
INSERT INTO qulNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús Jordán mayumanta puriporkan Santo Espirituwan junt'a. Santo Espiritutaj Jesusta ch'usaj lugarman pusarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Chaypitaj tawa chunca p'unchayta supay Jesusta pruebaman churarkan. Jesús chay p'unchaycuna ni imata miqhuskanraycu yarekachicaporkan. ");
INSERT INTO qulNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Supaytaj nerkan: —Sichus Diospaj Churinpuni canqui chayka, cay rumita t'antaman tucuchiy. ");
INSERT INTO qulNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesustaj contestarkan: —Escrituraka nin: ‘Mana miqhunallawanchu runaka causanka, manachayri Diospaj tucuy palabrancunawan.’ ");
INSERT INTO qulNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Chaymanta supay Jesusta athun loma pataman pusarkan. Uj ratopi tucuy cay pachapi caj nacioncunata ricuchispa, ");
INSERT INTO qulNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","nerkan: —Kanman autoridadta koskayqui tucuy cay nacioncunata mandanayquipaj, tucuy cay nacioncunapaj khapaj caynintawan. Caycunaka nokapajta, chayraycu pimanchus munani chayman koyta atini. ");
INSERT INTO qulNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ñaupakeypi konkoriycucuspa adorawanqui chayka, cay tucuy ima kanpajta canka. ");
INSERT INTO qulNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesustaj contestarkan: —Escrituraka nin: ‘Señor Diosnillayquita adoranqui. Pay sapallanta sirvinqui.’ ");
INSERT INTO qulNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Chaymanta supay Jesusta Jerusalenman pusarkan. Templo patapi astawan alto cajman llojsichispa, nerkan: —Sichus Diospaj Churinpuni canqui chayka, caymanta pampaman wijch'uycucuy, ");
INSERT INTO qulNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","imaraycuchus Escrituraka nin: ‘Dios angelnincunata cachamonka cuidanasunquipaj mana nanachicunayquipaj. ");
INSERT INTO qulNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Maquincuwan jap'isunquichis rumicunaman mana tacacunayquipaj.’ ");
INSERT INTO qulNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús contestarkan: —Escrituraka nillantaj: ‘Ama Señor Diosniyquita pruebaman churanquichu’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Supay ni imaynamanta Jesusta juchallichiyta atispa, carunchacaporkan pisi tiempopaj. ");
INSERT INTO qulNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús Galileaman cuterkan, Santo Espiritupaj atiyninwan junt'a. Tucuynejpi payllamanta parlaj cancu. ");
INSERT INTO qulNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Tucuynej sinagoga wasicunapi yachachejtin, tucuy runacuna alabarkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesús paypaj wiñaskan Nazaret llajtaman purerkan. Samana p'unchaypi sinagoga wasiman yaycorkan costumbrenman jina. Escriturata leenanpaj sayarerkan. ");
INSERT INTO qulNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Profeta Isaiaspaj escribiskan librota korkancu leenanpaj. Librota quicharispataj, tarerkan cay jinata: ");
INSERT INTO qulNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Señorpaj Espíritun nokapi cachcan, imaraycuchus ajllawan, sumaj noticiata pobrecunaman apanaypaj. Dios cachamuwan presocunaman cachariska canancuta willanaypaj, ñausacunata khawatatachinaypaj, ñit'iskacunatawan libranaypaj, ");
INSERT INTO qulNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Señorpaj bendiciskan watata willaranaypaj.” ");
INSERT INTO qulNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jesús librota wisk'aycuspa, wakaychajman jaywapuspa, tiyaycorkan. Tucuy chaypi cajcunataj payta khawachcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Paytaj parlayta kallarerkan: —Cunanpacha cay Escritura junt'acun ñaupakeyquichispi —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jesusmanta tucuynincu sumajta parlarkancu. Musphararkancutaj sumaj t'icachcajta parlaskanmanta. Tapunacorkancutaj: —¿Manachu cayri Josepaj churin? ");
INSERT INTO qulNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesustaj nerkan: —Niwanquichischari cay niskata: ‘Médico, kan quiquiyqui jampicuy.’ Nillawanquichistajchari: ‘Capernaumpi ruwaskayquicunata uyariycu; chayta cay jallp'ayquipi ruwallaytaj.’ ");
INSERT INTO qulNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jesús nillarkantaj: —Segurayquichis, ni mayken profetapas allin jap'ekaskachu quiquin llajtanpeka. ");
INSERT INTO qulNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ciertotapuni, Israelpi achqha viudacuna carkancu Eliaspaj tiemponpi. Quimsa wata sojta quillayojta mana paraskanraycu, yarekay carkan tucuynej nacioncunapi. ");
INSERT INTO qulNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Eliastaj ni mayken Israelpi caj viudamanchu cachaska carkan, manachayri Sidón llajta kaylla Sareptapi caj uj viudallaman. ");
INSERT INTO qulNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Callarkancutaj Israelpi achqha leprawan onkoska runacuna profeta Eliseopaj tiemponpi. Mana ni mayken alliyarkanchu, manachayri Siria llajtayoj Naamanlla. ");
INSERT INTO qulNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Chayta uyarispa, sinagoga wasipi tucuy cajcuna sinchita phiñaricorkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Sayarispa, llajtamanta Jesusta katerkorkancu. Llajtapaj loma patanman aparkancu, chaymanta barrancoman chhokaycunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Jesustaj paycunapaj chaupinta pasaspa, puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesús Galileapi caj Capernaum llajtaman puriporkan. Samana p'unchaypitaj sinagoga wasipi runacunata yachachichcarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Runacunataj muspharkancu atiyninwan yachachiskanmanta. ");
INSERT INTO qulNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Sinagoga wasipi uj runa sajra espirituyoj carkan. Paytaj sinchita wajach'acorkan: ");
INSERT INTO qulNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Dejawaychis, Nazaret llajtayoj Jesús! ¿Imapaj meticuwanquichis? ¿Tucuchanawayquichispajchu jamunqui? Allinta rejsiyqui pichus caskayquita. Kancajka Diospaj Santon canqui. ");
INSERT INTO qulNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesustaj sajra espirituta c'amerkan: —¡Jup'allay, llojsiy paymanta! —nispa. Sajra espiritutaj runata tucuypaj ñaupakenpi pampaman chhokaspa, paymanta llojserkan mana imanaspalla. ");
INSERT INTO qulNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tucuynincu mancharicuspa, ninacorkancu: —¿Ima atiyniyoj palabracunataj cayri? Cay runaka tucuy atiyninwan sajra espiritucunatapas katerkospa, llojsichin. ");
INSERT INTO qulNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Tucuynejpitaj Jesusmanta parlarkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesús sinagoga wasimanta llojsispa, Simonpaj wasinman yaycorkan. Simonpaj suegran sinchi calentura onkoywan cachcarkan. Jesusta rogarkancu alliyachinanpaj. ");
INSERT INTO qulNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesustaj onkoskaman c'umuycuspa, onkoyta c'amerkan. Calentura onkoytaj pasaporkan. Chhicapacha payka jatarispa, paycunata atendiyta kallarerkan. ");
INSERT INTO qulNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Inti yaycuyta, imaymana onkoywan onkoskacunata Jesusman apamorkancu. Jesustaj sapa ujman maquinta churaspa, alliyacherkan. ");
INSERT INTO qulNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Achqhayoj onkoskacunamanta sajra espiritucuna llojsiporkancu kaparispa: —¡Kancajka Diospaj Churin canqui! Jesustaj sajra espiritucunata c'amerkan, manataj parlacherkanchu, imaraycuchus yacharkancu Jesús Cristo caskanta. ");
INSERT INTO qulNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","K'ayantintaj sut'iyamuyta Jesús llajtamanta llojsispa, uj ch'usaj lugarman puriporkan. Runacuna payta masc'arkancu. Taripaspataj, jarc'ayta munarkancu mana ripunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jesustaj paycunata nerkan: —Diospaj gobiernonmanta evangeliota willamunallaytaj waj llajtacunaman. Chaypaj cachamuska cani. ");
INSERT INTO qulNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ajinata Jesuska evangeliota willarachcarkan Judeapi caj sinagogacunapi. ");
INSERT INTO qulNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Uj cuti Genesaret kocha cantopi Jesús cachcajtin, runacuna sinchita mat'iycorkancu, Diospaj palabranta uyariyta munaspa. ");
INSERT INTO qulNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Playapi Jesús iscay ch'usaj botecunata ricorkan, imaraycuchus challwirucuna urakaskacu llicancuta t'ajsaj. ");
INSERT INTO qulNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesuska Simonpaj botenman yaycuspa, mañarkan kocha cantonejmanta ithirichinancupaj. Chay botepi tiyaycuspataj, runacunaman yachacherkan. ");
INSERT INTO qulNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Parlayta tucuchaspa, Simonta nerkan: —Astawan uqhunejman boteta apay. Unuman llicayquichiscunata cachaycuychis challwata jap'inayquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón contestarkan: —Yachachej, tuta entero llanc'aycu, nitaj uj challwatapas jap'iycuchu. Chaywanpas niwaskayquiraycu llicacunata unuman cachaycusaj. ");
INSERT INTO qulNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Wijch'uycuspataj, achqha challwata jap'erkancu; llicancupas lliq'iracuchcarkanña. ");
INSERT INTO qulNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Waj botepi cachcaj challwirumasincutataj maquincuwan wajarkancu yanapaj jamunancupaj. Jamojtincutaj, iscaynin botecunaman challwacunata junt'acherkancu. Llasa caymanta unupi tiyaycuchcarkanña. ");
INSERT INTO qulNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Chayta ricuspa, Simón Pedro Jesuspaj ñaupakenpi konkoriycuspa nerkan: —¡Señor, ithiricuy nokamanta! ¡Nokaka juchasapa runalla cani! —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simontaj tucuy paywan cajcunapas mancharicorkancu achqha challwacunata jap'iskancumanta. ");
INSERT INTO qulNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ajinallatataj Zebedeopaj churincuna, Santiago Juanpiwan, mancharicorkancu. Paycunataj Simonpaj challwirumasin carkancu. Jesustaj Simonman nerkan: —Ama mancharicuychu. Cunanmantapacha challwata jina runacunata jap'inqui —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Chaymanta botencuta jallp'aman aysarkospa, tucuy imata sakerparipuspa Jesuswan puriporkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Uj p'unchay Jesús uj llajtapi cachcajtin, lepra onkoyniyoj runa chayamorkan. Jesusta ricuspa, pampacama c'umuycuspa mañacorkan: —Señor, munanqui chayka, alliyachiwayta atinqui. ");
INSERT INTO qulNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesús llanqhaycuspa nerkan: —Munani. ¡Alliyaska cay! —nispa. Chhicapacha alliyaska carkan. ");
INSERT INTO qulNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesustaj nerkan: —Ama pimanpas willanquichu. Jerusalenllaman puriy, sacerdoteman ricuchicamuy alliyaskaña caskayquita. Limpiochaj costumbreta ruwaspa, ofrendata koy Moisespaj mandacuskanman jina. Ajinamanta tucuy yachankacu alliyaskayquita. ");
INSERT INTO qulNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Chaywanpas tucuynejpi runacuna Jesusmanta uyarerkancu. Achqhayoj jamuchcarkancu uyarej, onkoynincumanta jampichicunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jesustaj sapallan ch'usajnejman puripoj oracionta ruwananpaj. ");
INSERT INTO qulNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Uj p'unchay Jesús yachachichcajtin, achqha fariseocuna leymanta yachachejcunapiwan tiyaspa uyarichcarkancu. Paycunaka jamorkancu tucuy Galileapi Judeapi caj llajtacunamanta, Jerusalén llajtamantapiwan. Diospaj atiynin Jesuspi carkan onkoskacunata alliyachinanpaj. ");
INSERT INTO qulNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ajinapi uj runacuna chayamorkancu, uj such'uta callapupi wantuspa. Chay such'utataj wasi uqhuman wantuycuyta munarkancu Jesuspaj ñaupakenman. ");
INSERT INTO qulNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Mana ni mayninta yaycuyta aterkancuchu achqha runa caskanraycu. Chayraycu wasi pataman aparkorkancu. Wasi patanta jutc'uspa, chayninta cachaycorkancu Jesuspaj ñaupakenman tucuy runapaj chaupinpi. ");
INSERT INTO qulNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesustaj paycunapaj creeynincuta ricuspa, such'uta nerkan: —Amigo, juchayquicuna perdonaskaña. ");
INSERT INTO qulNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Chaymanta leymanta yachachejcuna fariseocunapiwan pensachcarkancu: “¿Pitaj cay runari, palabrancunawan Diosta phiñachiyta atrevicunanpaj? Dioslla juchataka perdonayta atin” nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesús cay jinata pensaskancuta reparaspa, taporkan: —¿Imaraycutaj jinata pensanquichis? ");
INSERT INTO qulNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Onkoskaman ninari ¿maykentaj astawan fácil: ‘Juchayqui perdonaska cachun’, icha ‘Jatariy, puñunayquita okharispa, puriy’ ninachu? ");
INSERT INTO qulNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Noka ricuchiskayquichis Tataj Churenka atiyniyoj caskanta juchata perdonananpaj. Such'uman nerkan: —Kanta niyqui, jataricuy, puñunayquita okharispa, wasiyquiman puripuy —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Chhicapachataj tucuypaj ñaupakenpi such'oka jatariporkan. Puñunanta okharicuspa Diosta alabaspataj, wasinman puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tucuy runacunataj musphaspa Diosta alabarkancu. Manchariskataj nerkancu: —Cunan musphanacunata ricunchis —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Chaymanta Jesús llojsispa, ricorkan Romapaj uj impuesto cobrajta, Leví sutiyojta, impuesto cobrana lugarpi tiyachcajta. Jesús payta nerkan: —Jacu nokawan —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levika tucuy imata sakerpayaytawan, jatarispa Jesuswan puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Khepamantaj Leví wasinpi achqha miqhunata waquicherkan Jesusta honrananpaj. Chaypi achqha Romapaj impuesto cobrajcuna waj runacunapiwan tiyarachcarkancu paycunawan miqhuspa. ");
INSERT INTO qulNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Fariseocuna leymanta yachachejcunapiwan Jesús contra thutuspa, Jesuspaj discipuloncunata nerkancu: —¿Imaraycutaj kancuna impuesto cobrajcunawan juchasapacunapiwan miqhunquichis ujyanquichistaj? ");
INSERT INTO qulNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesustaj contestarkan: —C'uchicunaka mana medicota necesitancuchu, manachayri onkoskacunalla. ");
INSERT INTO qulNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mana ‘Sumaj cani’ nejcunata wajajchu jamuni, manachayri juchasapacunallata, Diosman cutiricunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jesusta nerkancu: —Juanpaj fariseocunapajpas discipuloncuna sinchita ayunancu, oracioncunatapas sinchita ruwancu. Discipuloyquicunataj miqhuncu ujyancu, nitaj ayunancuchu. ");
INSERT INTO qulNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesustaj contestarkan: —¿Kancunari ayunachiwajchischu casamientoman wajaskacunata, novio paycunawanraj cachcajtinri? ");
INSERT INTO qulNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Chaywanpas tiempo jamonka novio paycunamanta kechuska cananpaj; chhica ayunankacu. ");
INSERT INTO qulNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nillarkantaj cay ejemplota: —Ni pipas mosoj p'achamanta lliq'ekaspa, mauc'a p'achaman remendanmanchu. Chay jinata ruwajtin, mosoj remiendoka mauc'ata lliq'inman. Nitaj mosoj remiendoka mauc'api sumajchu canman. ");
INSERT INTO qulNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nillataj pipas mosoj vinota jich'aycunmanchu mauc'a kara botamanka, imaraycuchus mosoj vinoka mauc'a botata t'ojachinman, vinotaj jich'arparicunman, kara botapas lliq'icapunman. ");
INSERT INTO qulNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Chayraycu mosoj vinotaka mosoj karaman jich'aycuna. ");
INSERT INTO qulNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ni pipas unayniyoj vinota ujyajka mosoj vinota munanmanchu, ‘Unayniyojka astawan sumaj’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Uj samana p'unchaypi Jesús discipuloncunapiwan trigo chajra uqhunta purichcarkancu. Discipuloncunataj trigo urita pallaspa, maquincuwan khakospa miqhuchcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Waquin fariseocuna Jesusta taporkancu: —¿Imaraycutaj kancuna cayta ruwanquichis samana p'unchay ley contra? —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesustaj contestarkan: —¿Manachu leerkanquichis imatachus David compañancunapiwan yarekachicuspa ruwaskancuta? ");
INSERT INTO qulNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","David Diospaj wasinman yaycuspa, sacerdotecunallapaj miqhuna t'antata, Diospaj wakaychaskata, miqhorkan compañancunapiwan. ");
INSERT INTO qulNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nillarkantaj: —Tataj Churenka atiyniyojmi samana p'unchaymantapas —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Waj samana p'unchaypi Jesús sinagoga wasiman yaycuspa, yachachiyta kallarerkan. Chaypi uj runa carkan, paña maquin ch'aquiska mana cuyurej. ");
INSERT INTO qulNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Leymanta yachachejcuna fariseocunapiwan Jesusta khawachcarkancu, ‘¿Samana p'unchaypi alliyachenkachu, manachu?’ nispa, chayman jina juchachanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesustaj pensaskancuta yachaspa, ch'aquiska maquiyojta nerkan: —Jatariy, chaupipi sayaycuy —nispa. Runataj jatarispa sayaycorkan. ");
INSERT INTO qulNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesustaj ujcunaman nerkan: —Ujta tapuriskayquichis: ¿Imacajtataj ruwana samana p'unchaypi, allincajtachu icha mana allincajtachu? ¿Alliyachinachu icha jinallachu wañupunan? ");
INSERT INTO qulNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Tucuynincuta khawarispataj chay ch'aquiska maquiyoj runata nerkan: —Maquiyquita jaywariy —nispa. Runataj maquinta jaywarerkan. Maquintaj alliyaska caporkan. ");
INSERT INTO qulNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ujcunari sinchita phiñacorkancu. Tapunacorkancu imaynata Jesús contra ruwanancuta. ");
INSERT INTO qulNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Chay p'unchaycunapi Jesús uj lomaman sekarkan oracionta ruwaj. Chaypitaj tuta entero Diosman oracionta ruwarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","P'unchayajtintaj, discipuloncunata wajarkan. Paycunamanta chunca iscayniyojta ajllarkan apostolnincuna canancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Caycunataj carkan: Simón, Pedro niska; Simonpaj wauken Andrés; Santiago, Juan, Felipe, Bartolomé, ");
INSERT INTO qulNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Alfeopaj churin Santiago; celote partidomanta Simón, ");
INSERT INTO qulNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Santiagopaj wauken Judas, Jesusta vendiycoj Judas Iscariotepiwan. ");
INSERT INTO qulNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús paycunawan lomamanta urakamuspa uj pampapi quedacorkan. Chaypi achqha paywan purejcuna waj runacunapiwan cachcarkancu Judeapi caj llajtacunamanta, Jerusalén llajtamanta, athun kocha kayllanej Tiro llajtamanta, Sidón llajtamantapiwan. Jesusta uyarej chayamorkancu, onkoynincumanta jampichicunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Sajra espiritucunapaj sufrichiskancunapas alliyachiska carkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ajinapi tucuy runacuna Jesusta llanqhariyta munachcarkancu, atiyninwan tucuyta alliyachiskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesús discipuloncunata khawarispa nerkan: “Cusicuyniyojmi canquichis, pobrecunaka, imaraycuchus Diospaj gobiernonka kancunapaj. ");
INSERT INTO qulNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Cusicuyniyojmi canquichis, yarekaskacunaka, imaraycuchus sajsachiska canquichis. “Cusicuyniyojmi canquichis, wakajcunaka; khepamanka asicunquichis. ");
INSERT INTO qulNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Cusicuyniyojmi canquichis, kancuna chejniska, wich'orkoska, insultaska, despreciaska cajtiyquichis millay runacunata jina, Tataj Churinpaj causanraycu. ");
INSERT INTO qulNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Sinchita cusicuychis. Cuentata kona p'unchaypi cusiywan junt'a caychis, imaraycuchus kancunaka uj athun premiota jap'ekanquichis janaj pachapi. Jinallatataj ñaupaj runacuna Diosmanta willaj profetacunata ñac'arichej cancu. ");
INSERT INTO qulNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“¡Ay, kancuna khapajcuna, cusicuyniyquichis tucuconkaña! ");
INSERT INTO qulNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“¡Ay, kancuna cunan sajsaskacuna, yarekaska canayquichis jamonkaña! “¡Ay, kancuna cunan asicojcuna, llaquicuymanta wakanayquichis chayamonkaña! ");
INSERT INTO qulNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“¡Ay, kancuna, tucuy runapaj alabaskancuna! Ajinallatataj ñaupaj abueloyquichiscuna ruwaj cancu llulla profetacunawanka. ");
INSERT INTO qulNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Kancuna uyariwajcunaman niyquichis: Munacuychis kancuna contra cajcunata. Allinta ruwaychis kancunata chejnejcunaman. ");
INSERT INTO qulNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Sumajta parlapayaychis kancunamanta millay parlajcunata. Diosmanta mañapuychis kancunata insultajcunapaj. ");
INSERT INTO qulNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Pillapas uyayquipi t'ajllejtenka, uj lado uyayquitawan ricuchiy. Pillapas katanayquita kechojtenka, p'achayquitawan kopuy. ");
INSERT INTO qulNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Pillapas kanmanta imatapas mañacojtenka, koy. Imayquitapas kechojtenka, ama mañacapuychu. ");
INSERT INTO qulNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Imaynatachus runacuna kancunawan ruwanancuta munanquichis, ajinallatataj kancunapas paycunawan ruwaychis. ");
INSERT INTO qulNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Sichus kancunata munacojcunallata munacunquichis chayri, ¿ima allintataj ruwanquichis? Chaytaka juchasapacunapas ruwallancutaj. ");
INSERT INTO qulNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Allin ruwajcunallapaj allinta ruwajtiyquichisri, ¿ima allintataj ruwanquichis? Ajinallatataj juchasapacunapas ruwancu. ");
INSERT INTO qulNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ayninquichis, paycunamanta imallatapas jap'ekayta pensaspa chayri, ¿ima allintataj ruwanquichis? Juchasapacunapas ayninacullancutaj imallatapas jap'ekayta pensaspa. ");
INSERT INTO qulNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kancuna munacunayquichis chejnicojcunataka, allinta ruwanayquichis. Ayninayquichis ni imata jep'ekayta suyaspa. Chayta ruwaspaka, Diospaj wawancuna caskayquichista ricuchichcanquichis. Ajina causaskayquichisraycu janaj pachapi athun premioyquichista jap'ekanquichis. Dioska qhuyapayacojpuni mana graciasta kojcunawan sajra runacunawanpas. ");
INSERT INTO qulNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Imaynatachus Dios Tatayquichis tucuy runacunata qhuyapayan, ajinallatataj kancunapas qhuyapayaychis. ");
INSERT INTO qulNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ama juchachaychischu, Dios mana juchachanasunquichispaj. Ama ‘Castigaska canqui’ niychischu, Dios mana castiganasunquichispaj. Runacunata perdonaychis, Dios perdonanasunquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Koychis ujcunaman, Diostaj kancunaman kosunquichis cay jinata: saquillayquichispi allin midiskata, mat'iycuskata, thalaycuskata, phullchichcajta. Kancuna ima medidawanchus ujcunata midinquichis, chay medidallawantaj Dios midisunquichis.” ");
INSERT INTO qulNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús cay ejemplowan parlarkan: “¿Acaso uj ñausa waj ñausata pusanmanchu? ¿Manachu iscaynincu jutc'uman urmayconkacu? ");
INSERT INTO qulNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ni mayken yachakajpas yachachejninmanta nejtenka astawan yachanmanchu. Estudiayta tucuchasparaj, yachachejnin jina canka. ");
INSERT INTO qulNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“¿Imaraycutaj waukeyquipaj ñawinpi caj ichhuta khawanqui, nitaj reparacunquichu ñawiyquipi raqhu c'aspi caskanta? ");
INSERT INTO qulNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Imaynatataj atrevicunqui waukeyquiman niyta: ‘Waukéy, dejaway ichhuta ñawiyquimanta orkhojta’ nispa? ¡Iscay uya!, ñaupajta chay ñawiyquimantaraj raqhu c'aspita orkhoy. Chhica allinta ricunqui ichhuta waukeyquipaj ñawinmanta orkhonayquipaj. ");
INSERT INTO qulNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Sumaj sach'aka mana mana allintaka urinmanchu. Manallataj mana sumaj sach'aka allintaka urinmanchu. ");
INSERT INTO qulNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Sapa sach'aka uriyninmanta rejsichicun. Higotaka mana qhichca sach'amantachu pallanchis, ni uvatapas qhichcamantachu. ");
INSERT INTO qulNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ajinallatataj sumaj runaka sonkonpi sumaj cajcunamanta sumajta parlan. Mana allin runari mana allin sonkonpi cajmanta mana allinta parlan, imaraycuchus sonkonpi junt'a cajmanta simenka parlan. ");
INSERT INTO qulNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“¿Imaraycutaj ‘Señorníy, Señorníy’ niwanquichis, manataj niskayta ruwanquichischu? ");
INSERT INTO qulNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Niskayquichis pimanchus rijch'acun pichus nokaman jamuspa uyariwan, niskaytataj ruwan chayta. ");
INSERT INTO qulNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Rijch'acun uj wasi ruwaj runaman. Ñaupajta uqhuta asp'erkan, rumita taripanancama. Chay rumi patapi cimientota churarkan. Mayu junt'amojtin, callpawan wasita unu tankajtin, waseka mana imanacorkanchu, imaraycuchus rumi patapi allin ruwaska carkan. ");
INSERT INTO qulNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pichus uyariwaspa, mana niskayta casucunchu chayka, rijch'acun ako patapi mana cimientoyoj wasi ruwaj runaman. Mayu junt'amojtin, callpawan wasita unu tankajtin, chay wasi urmaporkan, ch'usajta ñut'ucaporkan.” ");
INSERT INTO qulNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesús runacunaman parlayta tucuchaspa, Capernaum llajtaman puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Chaypi tiyarkan uj capitán romano. Paypaj sinchi munaska uywacuskan onkoska wañunayachcarkanña. ");
INSERT INTO qulNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Capitanka Jesusmanta parlajta uyarispa, judiocunapaj jefencunata cacharkan Jesusta roganancupaj uywacuskanta alliyachej jamunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Jefecunataj Jesusman chimpaycuspa sinchita rogaspa, nerkancu: —Cay capitanka yanaparinayqui jina. ");
INSERT INTO qulNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Payka nacionninchista munacuspa, sinagoga wasinchista ruwachipuwanchis. ");
INSERT INTO qulNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jesús paycunawan purerkan. Wasi kayllapiña cachcajtincutaj, capitán amigoncunata cachamorkan Jesusman ninancupaj: “Señor, amaña molestacuychu. Mana imapaschu cani wasiyman yaycunayquipajka. ");
INSERT INTO qulNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Chayraycu mana atrevicunichu noka quiquiy jamuspa kanta masc'aj. Astawanpas nillay, uywacuskayka niskayquiwan alliyaponka. ");
INSERT INTO qulNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Noka quiquiy curajcunapaj mandonpi cani. Ajinallatataj soldadoycuna mandoypi cancu. Ujninta ‘Puriy’ nejtiy, purin; ujnintataj ‘Jamuy’ nejtiy, jamullantaj. Uywacuskayta imallatapas ‘Ruway’ nejtiy, ruwan. ");
INSERT INTO qulNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesús chayta uyarispa, muspharkan. Katejnin runacunata khawarispa, nerkan: —Segurayquichis, cay jina athun creeyniyoj runata mana Israel runacuna uqhupipas tarinichu. ");
INSERT INTO qulNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Cachaskacunataj wasiman cutipuspa, onkoskata alliyaskataña tariparkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Chaymanta Jesús Naín llajtaman purichcarkan, discipuloncunawan achqha runacunapiwan. ");
INSERT INTO qulNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Llajta kayllaman chayaspa, ricorkan ayata p'ampanapaj apachcajta. Uj viudapaj chay ch'ulla churillan caska. Achqha runacuna compañachcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Señortaj viudata ricuspa, qhuyapayarkan. Nerkantaj: —Ama wakaychu —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jesús callapuman chimpaycuspa, llanqhaycorkan. Apajcuna sayaycorkancu, Jesustaj wañuskaman nerkan: —Wayna, kanta niyqui: ¡Jatariy! ");
INSERT INTO qulNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Chhicataj wañuska tiyarimuspa, parlayta kallarerkan. Jesustaj mamanman koporkan. ");
INSERT INTO qulNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Cayta ricuspataj, tucuy mancharicorkancu. Diostataj alabayta kallarerkancu. Nerkancutaj: —Athun profeta nokanchis uqhupi riqhurin. Dios jamun llajtanta yanapaj —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Tucuy Judeapi cantocunantinpi Jesuspaj ruwaskan yachacorkan. ");
INSERT INTO qulNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juanpaj discipuloncuna payman tucuy ima pasaskanta willarkancu. Juantaj paycunamanta iscayojta wajaspa, ");
INSERT INTO qulNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","cacharkan Jesusta tapunancupaj: “¿Kanchu canqui jamunan carkan chay, icha wajtachu suyasajcu?” nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Juanpaj cachaskancunataj Jesusman chimpaycuspa nerkancu: —Juan Bautista cachamuwancu tapojta: ‘¿Kanchu canqui jamunan carkan chay, icha wajtachu suyasajcu?’ ");
INSERT INTO qulNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Chhicapacha Jesús achqha onkoyniyojcunata, ñac'ariyniyojcunata, sajra espirituyojcunata, ñausacunatawan alliyacherkan. ");
INSERT INTO qulNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Chayraycu Jesús Juanpaj cachaskancunaman contestarkan: —Cutipuychis, Juanman willamuychis ricuskayquichista uyariskayquichistawan. Willaychis ñausacuna ricucuskancuta, such'ucuna puririskancuta, lepra onkoyniyojcuna alliyaskancuta, rojt'ucuna uyariskancuta, wañuskacuna causariskancuta, pobrecunamantaj salvación evangelio willaraska caskanta. ");
INSERT INTO qulNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","¡Cusicuyniyojmi nokapi creeyninta mana chincachicojka! ");
INSERT INTO qulNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Juanpaj cachaskancuna cutipojtincu, Jesús Juanmanta runacunaman parlayta kallarerkan, nispa: “¿Imatataj ch'usaj pampapi ricumorkanquichis? ¿Wayrapaj chuqui cuyuchiskantachu? ");
INSERT INTO qulNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Manachayri, ¿imatataj ricumorkanquichis? ¿Uj allin fino p'achalliska runatachu? Kancuna yachanquichis allin p'achayojcuna, cusiskalla causajcuna, gobernajcunapaj wasincunapi tiyaskancuta. ");
INSERT INTO qulNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Imatapunitaj ricumorkanquichis? ¿Uj profetata? Arí, uj profetamantapas astawan curajtaraj. ");
INSERT INTO qulNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juancajka Escriturapaj cay jina niskan: ‘Noka willajniyta ñaupajta cachamuni, runacunata waquichipunasunquipaj ñanta jina.’ ");
INSERT INTO qulNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nokataj niyquichis, tucuy runacuna uqhupi Juanmanta astawan curaj mana canchu. Chaywanpas Diospaj gobiernonpi astawan juch'uy cajka, Juanmantapas astawan athunraj. ");
INSERT INTO qulNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","“Juanta tucuy uyarejcuna, Romapaj impuesto cobrajcunapas paywan bautizachicorkancu. Ajinata rejserkancu Dios justo caskanta. ");
INSERT INTO qulNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Fariseocunari leymanta yachachejcunapas Juanwan mana bautizachicorkancuchu. Ajinamanta despreciarkancu Dios paycunapaj ruway munaskanta.” ");
INSERT INTO qulNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesús nillarkantaj: “¿Imamantaj rijch'achisaj cunan tiempo runacunata? ¿Imamantaj rijch'acun? ");
INSERT INTO qulNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Rijch'acun plazapi tiyaycuspa pujllaj wawacuna wawamasincuta wajach'acojcunaman: ‘Tocarkaycu pinquilluta, kancunataj mana tusorkanquichischu. Taquerkaycu llaquinata jina, kancunataj mana wakarkanquichischu.’ ");
INSERT INTO qulNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Juan Bautista jamun, paytaj ni t'antata miqhunchu ni vinota ujyanchu. Kancunataj paymanta ninquichis: ‘Sajra espirituyoj’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Chaymanta Tataj Churincaj jamun, paytaj miqhun, ujyantaj. Kancunataj paymanta ninquichis: ‘Sinchi miqhoj, ujyajtaj, mana allin runacunapaj Romapaj impuesto cobrajcunapajpiwan amigon’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Diospaj yachaynenka ricuchicun wawancunapaj ruwaskancupi.” ");
INSERT INTO qulNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Uj fariseo Jesusta wajarkan miqhuchinanpaj. Wasiman yaycuspataj, mesapi tiyachcarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Chay llajtapi uj millay causayniyoj warmi carkan. Pay uyarerkan chay fariseopaj wasinpi Jesús miqhuchcaskanta. Chayraycu jamorkan rumi frasquitopi junt'a sumaj k'apayniyoj perfume apariska. ");
INSERT INTO qulNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Wakaspa Jesuspaj chaquin kayllapi tiyaycorkan. Wakayninwan Jesuspaj chaquincunata mayllaspa, chujchanwan ch'aquicherkan. Chaquincunata much'achcarkan; sumaj k'apayniyoj perfumewantaj jich'aycorkan. ");
INSERT INTO qulNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Jesusta wajaj fariseo Simón chayta ricuspa, pensarkan sonkonpi: “Sichus cay runa Diospaj profetan canman chayka, reparacunman imayna runachus llanqhaskanta, uj millay causayniyoj warmi caskantapas” nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Chayraycu Jesús fariseoman nerkan: —Simón, niyta munayqui. Fariseotaj contestarkan: —Yachachej, nillaway. ");
INSERT INTO qulNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús nerkan: —Uj kolke arrendaj runaman iscayoj manu carkancu. Ujnin manu carkan phichka pachaj, ujnintaj phichka chunca. ");
INSERT INTO qulNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Mana pagayta atejtincutaj, iscayninta perdonaporkan. Cunan niway: ¿Maykennincutaj astawan munaconkacu? ");
INSERT INTO qulNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón contestarkan: —Yuyacuwan astawan perdonaskan runacaj. Jesustaj nerkan: —Allinta ninqui. ");
INSERT INTO qulNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Warmita khawarispataj, Jesús Simonta nerkan: —¿Ricunquichu cay warmita? Wasiyquiman yaycumojtiy, mana chaquiypaj unuta kowarkanquichu. Cay warmitaj wakayninwan chaquiycunata mayllawaspa, chujchanwan ch'aquichiwan. ");
INSERT INTO qulNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mana much'awanquichu, paytaj yaycumuskaymantapacha chaquiycunata much'aycucuchcawan. ");
INSERT INTO qulNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Umayman aceiteta mana churawanquichu, paytaj perfumewan chaquiycunata jich'aycun. ");
INSERT INTO qulNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Chayraycu niyqui, paypaj achqha juchancuna perdonaska, sinchita munacuskanraycu. Pichari pisilla perdonaskaka pisillata munacun. ");
INSERT INTO qulNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Chaymanta warmita nerkan: —Juchayquicunaka perdonaskaña —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Paywan invitaskacunataj sonkoncupi tapucuyta kallarerkancu: —¿Pitaj cayri, juchacunatapas perdonaj? ");
INSERT INTO qulNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesús warmiman nillarkantaj: —Creeskayquiraycu salvaska canqui. Puripuy sonko tiyaska. ");
INSERT INTO qulNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Chaymanta Jesús chunca iscayniyoj apostolnincunawan Diospaj gobiernonmanta evangeliota willaspa, achqha llajtaman estanciacunamanpiwan purerkan. ");
INSERT INTO qulNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Paywan cusca purillarkancutaj sajra espiritucunamanta onkoycunamanta alliyachiska warmicuna: María Magdalena, paymanta Jesús kanchis sajra espirituta katerkoska; ");
INSERT INTO qulNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Juana, Cuzapaj warmin, (chay Cuzataj Herodespaj mayordomon carkan); Susanapiwan. Chaycuna achqha warmicunapiwan Jesusta yanaparkancu cajnincuwan. ");
INSERT INTO qulNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Llajtacunamanta Jesusman achqhayoj jamorkancu. Achqha runa tantaycucojtincu, Jesús cay ejemplowan parlaspa nerkan: ");
INSERT INTO qulNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Uj runa tarpoj llojserkan. Tarpuchcajtintaj, waquin muju ñan pataman t'acacorkan. Saruwasiska carkan, pisketocunataj pallacaporkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Waquintaj rumi uqhuman t'acacorkan. Wiñarimuspataj, wañuporkan ch'aqui jallp'a caskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Waquintaj qhichca uqhuman t'acacorkan. Qhichcacunataj wiñarispa sipiycorkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Waquintaj sumaj jallp'aman t'acacorkan. Wiñarkan, sumajtataj urerkan, pachajcama uj mujumanta.” Tucuchaspataj, alto vozwan nerkan: “¡Uyarejcunaka, entendiychis!” nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jesuspaj discipuloncuna taporkancu: “¿Ima niytataj munan cay ejemplori?” ");
INSERT INTO qulNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesustaj nerkan: “Kancunamanka Dios gobiernonmanta mana yachaskacunata sut'inchasunquichis. Wajcunamantaj tucuy imata ejemplocunallawan parlachcani, khawachcaspa mana ricunancupaj, uyarichcaspapas mana entendinancupaj.” ");
INSERT INTO qulNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Chay ejemploka cayta niyta munan: Mujoka Diospaj palabran. ");
INSERT INTO qulNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ñan patapi t'acaska mujutaj Diospaj palabranta uyarej runacuna. Chaypacha supay jamuspa, sonkoncumanta uyariskancuta orkhocapun, mana creenancupaj nitaj salvaska canancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Rumi pampapi t'acaska mujutaj Diospaj palabranta uyarispa cusicuywan jap'ekajcuna. Chaywanpas mana saphiyoj caskancuraycu, pisi ratollapaj Diospaj palabranta creencu. Pruebacuna jamojtintaj, urmapuncu. ");
INSERT INTO qulNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Qhichca uqhupi t'acaska mujutaj Diospaj palabranta uyarejcuna. Cay pachapi caj imaymanacunamanta llaquiska caspa, khapajyayta munaspa, mundopaj cusicuyninpi purispa, juch'uymanta juch'uy atipachicuncu, nitaj sumajta urincuchu. ");
INSERT INTO qulNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Sumaj jallp'api t'acaska mujutaj Diospaj palabranta uyarispa sumajta jap'ekajcuna, casucojcunataj. Creeskancupi firme quedacuspataj, sumaj causayta apancu, sumaj urita jina.” ");
INSERT INTO qulNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jesús nillarkantaj: “C'anchayta jap'ichispaka, mana ima uqhupichu churancu, nitaj catre uqhumanchu; manachayri mesa pataman c'anchaytaka churancu, yaycojcuna c'anchayta ricunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Jinallatataj tucuy pacaska cajcunaka sut'inchaconka, yachaconkataj. ");
INSERT INTO qulNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Jina ari, allinta uyariychis. Diospaj palabranta entendejka astawan entendenka. Mana entendejmantataj pisi entendiskan kechuska canka.” ");
INSERT INTO qulNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesuspaj maman waukencunapiwan jamorkancu. Payman mana chimpayta aterkancuchu achqha runa caskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Uj runa Jesusman willarkan: —Mamayqui waukeyquicunapiwan jawapi cachcancu, kanwan tupayta munancu. ");
INSERT INTO qulNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesustaj contestarkan: —Picunachus Diospaj palabranta uyarispa casucuncu, chaycunacaj mamay waukeycunapas. ");
INSERT INTO qulNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Uj p'unchay Jesús uj boteman yaycuspa, discipuloncunata nerkan: —Jacuchis kocha chimpaman. Puriporkancutaj. ");
INSERT INTO qulNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Kochata pasachcajtincu, Jesús puñuporkan. Purichcajtincu, uj sinchi athun wayra jatarerkan. Ajinamanta boteman unu junt'aycuspa uqhuman chincaycuchipuchcarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Chayraycu Jesusta rijch'acherkancu: —¡Yachachej! ¡Yachachej! Chincaycuchcanchisña unuman —nispa. Paytaj rijch'arispa, wayrata c'amerkan, kochatapas. Wayrataj chhicapacha thaniporkan. ");
INSERT INTO qulNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jesús discipuloncunata nerkan: —¿Maytaj creeyniyquichisri? —nispa. Paycunataj mancharicuspa, muspharkancu. Ninacuchcarkancutaj: —¿Imayna runataj cayri? Wayrapas kochapas c'amejtin, casuncu —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Chayarkancu Gerasa jallp'aman, Galilea kocha chimpaman. ");
INSERT INTO qulNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesús botemanta urakajtin jina, uj sajra espirituyoj runa llajtamanta llojsimuspa, Jesusman chimpaycorkan. Unayña p'achanta mana churacorkanchu, ni wasipi tiyarkanchu, manachayri panteonllapi. ");
INSERT INTO qulNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jesusta ricuspataj, ñaupakenpi konkoriycorkan. Wajach'acuspa nerkan: —¡Sinchi athun Diospaj Churin Jesús, ama meticuwaychu! ¡Mañacuyqui, ama ñac'arichiwaychu! ");
INSERT INTO qulNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Chayta nerkan, Jesús sajra espirituta runamanta katerkochcaskanraycu. Achqha cuti sajra espiritoka chay runata dueñochacorkan. Runacunataj maquincunata chaquincunatawan cadenawan wataj cancu, paytaj t'ipiraj cadenataka. Sajra espiritutaj ch'usaj lugarman escapachej. ");
INSERT INTO qulNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesús taporkan: —¿Imataj sutiyqui? Paytaj contestarkan: —Legión suteyka —nispa. Chayta nerkan, achqha sajra espíritu payman yaycuskancuraycu. ");
INSERT INTO qulNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Chay sajra espiritucunataj Jesusmanta mañacorkancu: —¡Ama mana tucucoj sinchi uqhu jutc'uman cachawaycuchu! —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Achqha qhuchitaj chay loma kayllapi miqhuchcarkancu. Sajra espiritucuna Jesusmanta mañacorkancu: —Dejallawaycu chay qhuchicunaman yaycunaycuta. Jesustaj permisota korkan. ");
INSERT INTO qulNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Sajra espiritucunataj runamanta llojsispa qhuchicunaman yaycorkancu. Qhuchicunataj sayaj khata pataman phawaspa, kochaman chhokaycucorkancu. Chaypitaj miquicuspa wañurarkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Qhuchi michejcunataj chayta ricuspa, phawaraspa willamorkancu llajtapi campopipas cajcunaman. ");
INSERT INTO qulNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Runacuna llojsimorkancu ima pasaskanta ricunancupaj. Chayaspataj ricorkancu sajra espirituyoj runata Jesuspaj ñaupakenpi tiyachcajta, p'achayojta, sumaj yuyayninpi. Chayta ricuspa mancharicorkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ricojcunataj jamojcunaman willarkancu chay runa imaynatachus sajra espiritumanta alliyachiska caskanta. ");
INSERT INTO qulNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gerasamanta tucuy runacuna Jesusta rogarkancu puripunanpaj, imaraycuchus sinchita manchacorkancu. Jesustaj boteman yaycuspa, cutiporkan. ");
INSERT INTO qulNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Sajra espiritucunamanta alliyachiska runataj Jesusta rogarkan paywan puripunanpaj. Jesús nerkan quedapunanpaj: ");
INSERT INTO qulNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Wasiyquiman cutipuy. Willamuy tucuy imata Dios kanwan ruwaskanta —nispa. Paytaj puriporkan enteron llajtaman willaspa imatachus Jesús paywan ruwaskanta. ");
INSERT INTO qulNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesús kocha chimpaman cutipojtintaj, chaypi caj runacuna cusicuywan jap'ekarkancu, imaraycuchus tucuynincu Jesusta suyachcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ajinapi chayamorkan uj runa, Jairo sutiyoj, sinagogapaj jefen. Jesuspaj ñaupakenpi konkoriycuspa mañacorkan wasinman purinanpaj. ");
INSERT INTO qulNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Paypaj ch'ulla ususin, chunca iscayniyoj watayoj jina, wañunayachcarkanña. Jesús purichcajtintaj, achqha runa katicuspa sinchita mat'iycorkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Paycuna uqhupi uj warmi cachcarkan, chunca iscayniyoj wataña yawar apaywan onkoska. Achqha medicocunawan jampichicuspa, tucuy cajninta gastaska tucuchanancama; mana pipas alliyachiyta atiskachu. ");
INSERT INTO qulNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Cay warmi khepanejmanta Jesusman chimpaycuspa p'achanpaj cantonta llanqhaycojtin, chaypacha yawar apaynin sayarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesustaj taporkan: —¿Pitaj llanqhaycuwan? —nispa. Mana pipas willajtin, Pedro nerkan: —Yachachej, runacuna ñit'imusunqui; tucuynejmanta tankasunquichis. ");
INSERT INTO qulNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesustaj nichcallarkanpuni: —Pichá llanqhawan. Reparani nokamanta atiy llojsiskanta. ");
INSERT INTO qulNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Chay warmitaj mana pacacuyta atispa, qharcatispa Jesuspaj ñaupakenpi konkoriycorkan. Tucuy runapaj ñaupakenpi sut'inchacorkan imapajchus Jesusta llanqhaskanta, chaypachataj alliyaskantawan. ");
INSERT INTO qulNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesustaj nerkan: —Wawáy, creeskayquiraycu alliyaska canqui. Sonko tiyaska puripuy. ");
INSERT INTO qulNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesús parlachcajtinraj, Jairopaj wasinmanta uj runa jamorkan nispa: —Ususiyqui wañupunña. Amaña Yachachejta molestaychu. ");
INSERT INTO qulNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesustaj chayta uyarispa Jairota nerkan: —Ama manchacuychu; creellay, ususiyqueka alliyaska caponka —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Wasiman chayaspataj, pusaycorkan Pedrota, Juanta, Santiagota, wañuskapaj tata mamallantawan. ");
INSERT INTO qulNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tucuynincu llaquiska wakachcarkancu. Jesús paycunata nerkan: —Ama wakaychischu. Cay wawaka mana wañuskachu, manachayri puñuchcallan. ");
INSERT INTO qulNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Tucuynincu wawa wañuska caskanta yachaspa, Jesusmanta asiracorkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jesustaj maquinmanta jap'iycuspa alto vozwan nerkan: —¡Juch'uycita, sayariy! —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Causarispataj, sayariporkan. Jesús mandarkan miqhunata konancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tata mamantaj muspharachcarkancu. Jesustaj mandacorkan ama ni piman willanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús chunca iscayniyoj discipuloncunawan tantaycucuspa, atiyta korkan sajra espiritucunata katerkonancupaj, onkoskacunatapas alliyachinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Cacharkan Diospaj evangelionta willarajta, onkoskacunatapas alliyachinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jesús nerkan: —Ñanpaj ama imatapas apacuychischu, ni bastonta, ni miqhuna apana saquillata, ni t'antata, ni kolketa, nillataj cambiacunapaj p'achatapas. ");
INSERT INTO qulNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Mayken wasimanpas chayaspaka, chayllapiña quedacuychis pasapunayquichiscama. ");
INSERT INTO qulNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mayllapipas mana jap'ekayta munasunquichischu chayka, chay lugarmanta llojsipuychis. Chaquiyquichispi caj polvotapas thalaraychis paycuna contra, mana allin caskancuta ricuchinayquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Llojsispataj tucuynin estanciacunata purerkancu, salvacionta willaspa, onkoskacunata alliyachispa. ");
INSERT INTO qulNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herodes Jesuspaj tucuy ima ruwaskanta uyarispa, mana ima niyta aterkanchu, imaraycuchus waquincuna nichcarkancu: “Juan Bautista causarimun” nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Waquintaj nichcarkancu: “Elías ujtawan riqhurimun” nispa. Waquintaj nerkan: “Mayken ñaupaj profetachá causarimun” nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodestaj nerkan: —Noka quiquiy Juanpaj umanta cuchokacherkani. ¿Pitaj cay canman, chay jina parlajta uyarinaypajri? Chayraycu Herodeska Jesusta ricuytapuni munachcarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Apostolnincuna cutimuspa, Jesusman willarkancu tucuy ima ruwaskancumanta. Jesustaj paycunata pusaporkan Betsaida llajtaman. ");
INSERT INTO qulNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Chayta yachaspa, runacuna katerkancu. Jesustaj paycunata jap'ekaspa, Diospaj gobiernonmanta parlapayarkan, onkoskacunatataj alliyacherkan. ");
INSERT INTO qulNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ch'isiyachcajtinña chunca iscayniyoj discipuloncuna chimpaycuspa, Jesusta nerkancu: —Runata cachapullayña. Kaylla estanciacunaman llajtitacunamanpas puripuchuncu korpachacunancupaj, miqhunatapas ranticunancupaj. Cay lugarpeka mana imapas canchu. ");
INSERT INTO qulNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesustaj nerkan: —Kancuna miqhunata koychis —nispa. Paycunataj contestarkancu: —Phichka t'anta iscay challwitallapiwan capuwanchis, tucuy cay runapaj miqhunata rantej puriycuman chhicallachari. ");
INSERT INTO qulNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kharicunalla yupaska phichka waranka jina carkancu. Jesús discipuloncunaman nerkan: —Cay runacunata tiyaycuchiychis phichka chunca runata jina sapa uj grupopi. ");
INSERT INTO qulNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ajinata ruwaspa, tucuynincuta tiyaycucherkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesús chay phichka t'antata iscay challwitatawan maquinpi jap'ekarkan. Janaj pachata khawarispataj Diosman graciasta korkan. Partispataj, discipuloncunaman korkan, runacunaman jaywaramunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tucuynincu miqhorkancu sajsanancucama. Puchojnintataj chunca iscayniyoj canasta junt'ata okharerkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Uj p'unchay Jesús sapallan oracionta ruwachcarkan. Discipuloncuna paywan cachcajtincu, Jesús taporkan: —Runari, ¿pi niwancutaj nokatari? ");
INSERT INTO qulNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Discipuloncunataj contestarkancu: —Waquin nincu, ‘Juan Bautista’; waquintaj, ‘Elías’; waquintaj, ‘mayken ñaupaj profetachá causarimun.’ ");
INSERT INTO qulNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jesús paycunata tapullarkantaj: —Kancunari, ¿pi niwanquichistaj? Pedrotaj contestarkan: —Kanka Diosmanta Cristo canqui. ");
INSERT INTO qulNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesús nerkan: —Ama cayta ni piman willanquichischu. ");
INSERT INTO qulNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jesús nillarkantaj: —Tataj Churenka sinchita ñac'arenka. Leymanta yachachejcuna, sacerdotecunapaj jefencuna, llajtapaj jefencunapas chejnenkacu, wañuchenkacutaj. Chaywanpas quimsa p'unchaymanta causarimponka. ");
INSERT INTO qulNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Tucuy runamantaj nerkan: —Maykenchus nokawan puriyta munan chayka, konkacuchun pay quiquin. Sapa p'unchay sufrispapas, nokawan purichun wañunancama. ");
INSERT INTO qulNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Causaynillanta salvayta munajka chincachenka; nokaraycu causayninta chincachejka salvaconka. ");
INSERT INTO qulNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Cay pachapi khapajyaskan, ¿imapajtaj runamanri sirvenka, almantaj mana salvaska cajtinri? ");
INSERT INTO qulNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Pillapas nokamanta palabraycunamantawan p'enkacojmantaka, nokapas, Tataj Churin, paymanta p'enkacullasajtaj, jayc'ajchus cay pachaman cutimusaj chhica Dios Tataypaj glorioso atiyninwan, angelnincunapiwan. ");
INSERT INTO qulNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Segurayquichis, waquin caypi cajcunamanta mana wañonkacuchu Diospaj gobiernonta ricunancucama. ");
INSERT INTO qulNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Chay niskan pusaj p'unchaymanta jina, Jesús lomaman llojserkan oracionta ruwaj. Pusarkantaj Pedrota, Santiagota, Juantawan. ");
INSERT INTO qulNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jesús oracionta ruwachcajtin, uyanpaj rijch'aynin waj jinaman tucorkan. P'achancunapas yuraj lliphipejman tucorkan. ");
INSERT INTO qulNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Moisés Eliaspiwan riqhurerkancu Jesuswan parlachcaj. ");
INSERT INTO qulNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","C'anchay uqhupi parlachcarkancu Jesús Jerusalenpi wañunanmanta. ");
INSERT INTO qulNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro paywan cajcunapiwan, puñuywan aysachicuspapas, rijch'achcarkancu. Ricorkancutaj Jesuspaj c'anchay glorianta chay iscay runatawan. ");
INSERT INTO qulNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Moiseswan Eliaswan ripuchcajtincu, Pedro Jesusman nerkan: —Yachachej, ¡allin caypi cachcaycu! Quimsa ramarata ruwasajcu: ujta kanpaj, ujta Moisespaj, ujtataj Eliaspaj. Mana yacharkanchu ima parlachcaskanta. ");
INSERT INTO qulNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Parlachcajtin, phuyu paycunata tapaycorkan. Phuyu uqhupi cachcaspa, mancharicorkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Phuyu uqhumantataj Dios Tatapaj niskanta uyarerkancu: “Cayka ajllaskay Churiy. Payta uyariychis.” ");
INSERT INTO qulNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ch'inyapojtin, Jesús sapallantaña ricorkancu. Paycunataj ch'inlla caporkancu, ricuskancuta mana piman willaspa. ");
INSERT INTO qulNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","K'ayantin lomamanta urakampojtincu, achqha runa Jesusta taripaj jamorkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Chay uqhumanta ujnin runa alto vozwan nerkan: —Yachachej, cay ch'ulla wawayta khawaripuway. ");
INSERT INTO qulNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Sajra espíritu jap'in, kaparichin, t'ucuta jap'ichin, simimanta phusokota ulthuchin, ñac'arichin, nitaj cachariyta munanchu. ");
INSERT INTO qulNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Discipuloyquicunata mañarkaniña sajra espirituta katerkonancupaj, manataj aterkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesustaj nerkan: —¡Ay, sajra mana creeyniyoj runacuna! ¿Jayc'ajcamataj kancunawan casajri? ¿Jayc'ajcamataj aguantaskayquichisri? Chay churiyquita cayman pusamuy. ");
INSERT INTO qulNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Wayna chimpamuchcajtin, sajra espíritu pampaman urmachispa t'ucuwan jap'icherkan. Jesustaj sajra espirituta c'amerkan; waynata allinyachispataj, tatanman koporkan. ");
INSERT INTO qulNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tucuy runa musphararkancu Diospaj chay jina athun atiyninmanta. Muspharachcajtincutaj, Jesús discipuloncunaman nerkan: ");
INSERT INTO qulNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Cayta allinta uyariychis, amataj konkaychischu: Tataj Churenka runacunaman entregaska canka. ");
INSERT INTO qulNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Discipuloncunataj Jesuspaj niskanta mana entenderkancuchu, imaraycuchus Dios manaraj koskachu entendinancupaj. Manchacorkancutaj Jesusta tapuyta. ");
INSERT INTO qulNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Discipulocuna churanacuyta kallarerkancu maykennincutaj curaj cananmanta. ");
INSERT INTO qulNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesús chayta reparaspa, uj wawata ladonpi sayachispa, ");
INSERT INTO qulNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","nerkan: —Pichus cay wawata sutiypi jap'ekajka, nokata jap'ekawan. Nokata jap'ekajtaj, cachamuwajniyta jap'ekallantaj. Kancuna uqhupi mana imapas cajka astawan athun canka. ");
INSERT INTO qulNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Juan Jesusta nerkan: —Yachachej, uj runata ricumuycu sutiyquipi sajra espiritucunata katerkojta. Mana nokanchiswan purichcaskanraycu, jarc'aycu. ");
INSERT INTO qulNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús contestarkan: —Ama jarc'aychischu. Pichus mana nokanchis contra cajka, nokanchiswan cachcan. ");
INSERT INTO qulNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jesús janaj pachaman llojsipunan p'unchay kayllamojtin, mana imata manchaspa Jerusalenman puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Samarianejta purichcajtincutaj, uj discipuloncunata ñaupajta cacharkan korpachacunancupaj waquichejta. ");
INSERT INTO qulNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Samaria llajtayojcunataj mana jap'ekayta munarkancuchu, Jerusalenman purichcaskanta yuyaspa. ");
INSERT INTO qulNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Juan Santiagopiwan chayta yachaspa, Jesusta nerkancu: —Señor, ¿munanquichu janaj pachamanta ninata urakachimunaycuta, cay runacunata ruphaycuchinapaj? ");
INSERT INTO qulNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesús paycunata c'amerkan. ");
INSERT INTO qulNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Waj llajtamantaj puriporkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Purichcajtincu, uj runa Jesusman nerkan: —Señor, kanwan purisaj maytachá purinqui chayta. ");
INSERT INTO qulNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús contestarkan: —Zorrocunapaj can jutc'uncu tiyanancupaj, pisketocunapajpas can tapancu. Nokapajri ni maypi wasi canchu samaricunaypaj. ");
INSERT INTO qulNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesús waj runaman nerkan: —Nokawan purisun. Paytaj contestarkan: —Permitiwayraj, ñaupajta tataytaraj p'ampaycamunayta —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesustaj nerkan: —Wañuskacuna wañuskancuta p'ampachuncu. Kancajka puriy, Diospaj evangelionta willamuy. ");
INSERT INTO qulNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ujnintaj Jesusta nerkan: —Señor, kanwan puriyta munani. Ñaupajtataj permitiwayraj familiaymanta despidicamunayta. ");
INSERT INTO qulNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús contestarkan: —Pillapas aradota jap'ispa khepanejllata khawajka, mana sirvinchu Diospaj gobiernonpi llanc'ajpaj. ");
INSERT INTO qulNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Chaymanta Señor ajllarkan kanchis chunca iscayniyoj discipuloncunatawan. Paycunatataj iscaymanta iscay cacharkan paypaj ñaupakenta purinancupaj tucuy llajtaman, maycunamanchus purinan carkan chayman. ");
INSERT INTO qulNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Paycunaman nerkan: “Ciertopuni ajthapinaka achqha, llanc'ajcunataj pisilla. Chayraycu ajthapinapaj Dueñonmanta mañaychis llanc'ajcunata cachamunanpaj okharejta. ");
INSERT INTO qulNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Puriychis, khawariychis. Ovejata jina cachachcayquichis lobo jina sajra runacunapaj chaupinman. ");
INSERT INTO qulNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ama apaychischu miqhuna apana saquillata, ni kolke churanata, ni iscay abarcacunatapas. Ñanpi ama piwanpas tardaychischu, uskhayta saludaspa pasapuychis. ");
INSERT INTO qulNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Mayken wasimanpas chayaspaka, saludaychis: ‘Sonko tiyay cachun cay wasipi tiyajcunapaj’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Wasipi cajcuna sonko tiyayniyoj allin runacuna cajtincoka, saludaskayquichiska junt'aconka; mana allin runacuna cajtincutaj, mana junt'aconkachu. ");
INSERT INTO qulNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Wasipi jap'ekaska caspa, chaypi quedacuychis. Imatachus kosunquichis, chayta miqhuychis, ujyaychispas, imaraycuchus llanc'aj runaka pagaska canan. Ama wasimanta wasi puriycachaychischu. ");
INSERT INTO qulNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","May llajtamanpas chayajtiyquichis jap'ekasunquichis chayka, miqhuychis imatachus jaywaskasunquichista. ");
INSERT INTO qulNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Chaypi onkoska cajtin, alliyachiychis. Willaychis: ‘Cunan Diospaj gobiernon kancunaman kayllachamusunquichis’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Chayajtiyquichis mana jap'ekasunquichischu chayka, callecunaman llojsipuychis nispa: ");
INSERT INTO qulNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘¡Chaquiycupi caj polvotapas thalaraycu kancuna contra! Cayta yachaychis, kancunaman Diospaj gobiernon kayllachamusunquichisña.’ ");
INSERT INTO qulNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Noka niyquichis, juicio p'unchaypeka Sodoma llajta castigo sufriskanmantapas astawanraj castigo canka chay llajtapajka.” ");
INSERT INTO qulNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jesús nillarkantaj: “¡Ay, Corazín llajtapi caj runacuna! ¡Ay, Betsaida llajtapi caj runacuna! Achqha milagrocunata ricorkanquichis. Sichus Tiro llajtapi Sidón llajtapi chay quiquin milagrocuna ruwacunman carkan chayka, may tiempoña Diosman cutirincuman carkan, uchphawan khachka p'achawan churacuspa Diosman cutiricuskancuta ricuchicunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Chayraycu juicio p'unchaypeka Tiro Sidón llajtayoj runacuna castigo sufriskancumantapas, astawan castigo canka kancunapajka. ");
INSERT INTO qulNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","¡Kancuna, Capernaum llajtapi caj runacuna! ¿Creenquichischu janaj pachacama pusaska canayquichista? ¡Kancunaka infiernocama chhokaycuska canquichis!” ");
INSERT INTO qulNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jesús discipuloncunaman nerkan: “Pichus kancunata uyarejka, nokata uyariwan. Pichus kancunata chejnejka, nokata chejniwan. Nokata chejnejtaj cachamuwaj Diosta chejnin.” ");
INSERT INTO qulNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Chay kanchis chunca iscayniyoj cachaskacuna cusiska cutimorkancu nispa: —¡Señor, sajra espiritucunantin casuwancu, sutiyquipi katerkojtiycu! ");
INSERT INTO qulNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesustaj paycunaman contestarkan: —Arí, noka supay Satanasta ricorkani janaj pachamanta rayo jina urmakamojta. ");
INSERT INTO qulNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Noka atiyta koyquichis tucuy enemigopaj callpanta atipanayquichispaj, pallicunata alacrancunatapas sarojtiyquichis mana imananasunquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Chaywanpas ama cusicuychischu sajra espiritucuna kancunata casuskanmanta, manachayri cusicuychis janaj pachapi sutiyquichis escribiska caskanmanta. ");
INSERT INTO qulNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Chhicapacha Jesús Santo Espiritupaj cusichiskanwan junt'a, nerkan: “Tatáy, janaj pachapaj cay pachapaj Señornin Dios, alabayqui, yachayniyojcunamanta yuyayniyojcunamantapas cay yachachiycunata pacaskayquiraycu, wawa jina cajcunamantaj ricuchiskayquimanta. Arí, Tatáy, ajinata munanqui. ");
INSERT INTO qulNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Tucuy imata Tatay kowan. Mana pipas yachanchu pichus Churi caskanta, manachayri Dios Tatalla. Nitaj pipas yachanchu pichus Dios Tata caskanta, manachayri Churilla, picunamanchus Churi rejsichiyta munan chaycunallapiwan.” ");
INSERT INTO qulNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Discipuloncunaman cutirispataj, paycunallaman nerkan: “Cusicuyniyoj cancu ricuskayquichista ricojcunaka. ");
INSERT INTO qulNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Niyquichis, achqha profetacuna gobernajcunapiwan kancunapaj ricuskayquichista ricuyta munarkancu, manataj ricorkancuchu. Uyariskayquichista uyariyta munarkancu, nillataj uyarerkancuchu.” ");
INSERT INTO qulNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Uj leymanta yachachej Jesuswan parlaj purerkan, yachayninta pruebata ruwananpaj. Jesusta taporkan: —Yachachej, ¿imata ruwaspataj wiñay causayniyoj casaj? ");
INSERT INTO qulNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesustaj contestarkan: —¿Imataj leypi escribiska cachcan? ¿Imatataj leenqui? ");
INSERT INTO qulNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Paytaj contestarkan: —Señor Diosniyquita munacunqui tucuy sonkoyquiwan, tucuy almayquiwan, tucuy callpayquicunawan, tucuy yuyayniyquipiwan. Runamasiyquitataj munacunqui kan quiquiyquita jina. ");
INSERT INTO qulNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesustaj nerkan: —Allinta ninqui. Chayta ruwaspa, causanqui. ");
INSERT INTO qulNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Paytaj allinpi llojsiyta munaspa taporkan: —¿Pitaj runamasiyri? ");
INSERT INTO qulNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesús contestarkan: —Uj runa Jerusalenmanta Jericoman uraycuchcajtin, salteajcuna jap'erkancu. Tucuy imanta p'achantawan kechuspa makaspataj, cusca wañuskata sakerparerkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Uj sacerdote chay quiquin ñanta purichcallarkantaj. Ricuspataj, wajninta pasaporkan. ");
INSERT INTO qulNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ajinallatataj uj levita chay lugarman chayarkan. Ricuspa, wajninta pasapullarkantaj. ");
INSERT INTO qulNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Uj Samaria llajtayoj sumaj runa quiquin ñanta purichcallarkantaj. Chay nanaska runata ricuspataj qhuyapayarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Chimpaycuspa, aceitewan vinowan nanaskancunata jampiycorkan, vendaycorkantaj. Uywanpi sillaycuchispa, alojacuna wasiman pusarkan. Chaypitaj cuidarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","K'ayantintaj Samaria llajtayoj runaka iscay kolketa wasiyojman kospa nerkan: ‘Cay runata cuiday. Astawan gastanqui chayka, noka pagapuskayqui cutimuspa’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Cunanka niway: Chay quimsamanta, ¿maykentaj rijch'acusunqui nanaskapaj runamasin? ");
INSERT INTO qulNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Paytaj contestarkan: —Maykenchus payta qhuyapayaj. Jesustaj nerkan: —Arí, puriy. Quiquinta ruwamuy. ");
INSERT INTO qulNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús purichcaspa uj llajtaman chayarkan. Chaypitaj uj warmi, Marta sutiyoj, wasinpi jap'ekarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Paypaj ñañan Mariataj Jesuspaj chaquincuna kayllapi tiyacuspa, willaskanta uyarichcarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martataj ruwanancunawan atipachicuchcarkan. Chayraycu Jesusman chimpaycuspa nerkan: —Señor, ¿manachu llaquicunqui ñañay sapallayta tucuy ruwanata sakeycuwaskanmanta? Niy, ari, yanapawachun. ");
INSERT INTO qulNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jesustaj contestarkan: —Marta, Marta, achqha ruwanacunawan afanaska cachcanqui. ");
INSERT INTO qulNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ujlla astawan necesarioka. Mariaka allincajta ajllacun. Chaytaka mana pipas kechonkachu. ");
INSERT INTO qulNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Uj cuti Jesús oracionta ruwachcarkan. Tucuchajtintaj, ujnin discípulon nerkan: —Señor, Diosman oración ruwacuyta yachachiwaycu, imaynatachus Juanpas discipuloncunata oración ruwacuyta yachacherkan jinata. ");
INSERT INTO qulNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesustaj nerkan: —Oracionta ruwaspaka niychis: ‘Janaj pachapi cachcaj Tataycu, sutiyqui yupaychaska cachun. Gobiernoyqui jamuchun. Munayniyqui ruwaska cachun, imaynatachus janaj pachapi, ajinallatataj cay pachapipas. ");
INSERT INTO qulNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Sapa p'unchaypaj t'antata kowaycu. ");
INSERT INTO qulNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Juchaycuta perdonawaycu, imaraycuchus nokaycupas contra ruwajcunata perdonaycu. Ama tentacionman urmachiwaycuchu, astawanpas librawaycu sajramanta. ");
INSERT INTO qulNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesús nillarkantaj: —Kancunamanta ujnin chaupi tutata amigonpaj wasinman purispa ninman: ‘Amigóy, quimsa t'antata ayniriway. ");
INSERT INTO qulNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Uj amigoy chayamun, nitaj imaypas jaywarinaypaj canchu’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Chay amigonka manachuna wasi uqhumanta nimunmanchu: ‘Ama molestawaychu, puncuy wisk'askaña, wawaycuna nokapas puñunapiña caycu. Mana jatarimuymanchu konaypaj’ nispaka. ");
INSERT INTO qulNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Niyquichis, amigon caskanraycu amapas jatarimuchunchu konanpaj, chaywanpas sinchita mañacuskanraycu jatarimonkapuni; konkataj tucuy necesitaskanta. ");
INSERT INTO qulNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ajinaka noka niyquichis: Mañacuychis, Diostaj kosunquichis. Masc'aychis, tarinquichistaj. Puncuta tacaychis, quicharasunquichistaj. ");
INSERT INTO qulNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mañacojka jap'ekan; masc'ajtaj tarin; puncuta tacajtapas quicharancu. ");
INSERT INTO qulNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“¿Mayken tatataj canman, wawan t'antata mañajtin rumita kojri, challwata mañajtinpas pallita kojri, ");
INSERT INTO qulNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","chayri runtuta mañajtinpas alacranta kojri? ");
INSERT INTO qulNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kancunallapas sajra runa cayniyquichiswan, allin cajta wawayquichisman koyta yachanquichis chayka, ¡astawanraj janaj pachapi caj Tatayquichiska Santo Espirituta konka mañacojcunamanka! ");
INSERT INTO qulNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesús jup'ayachej sajra espirituta uj runamanta katerkochcarkan. Sajra espíritu llojsejtincamataj, jup'aka parlayta kallarerkan. Runacunataj caymanta musphararkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Waquintaj nerkancu: “Cay runaka Beelzebú niska sajra espiritucunaj jefenpaj atiyninwan waj sajra espiritucunata katerkon” nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Wajcunataj Jesusta pantachiyta munaspa uj milagrota ruwananta mañarkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesús pensaskancuta yachaspa, paycunata nerkan: “Tucuy nación achqhaman partiskaka, paycama ñut'ucun. Ajinallatataj uj wasipi caj familiantin chejninacuspaka, mana astaqui junto cancumanchu. ");
INSERT INTO qulNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ajinallatataj supay Satanaspas iscayman tucunman chayri, ¿imaynatataj chhicari atiynin callanmanpuniri? Cayta niyquichis, ‘Beelzebupaj atiyninwan sajra espiritucunata katerkon’, niwaskayquichisraycu. ");
INSERT INTO qulNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Jina canman chayri, ¿pitaj discipuloyquichiscunaman atiyta kon sajra espiritucunata katerkonancupaj? Chayraycu ricuchicunquichis pantaska caskayquichista. ");
INSERT INTO qulNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Sichus noka Diospaj atiyninwan sajra espiritucunata katerkoni chayka, niyta munan Diospaj gobiernonka kancunaman chayamuskantaña. ");
INSERT INTO qulNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Callpayoj runa, allin armaska, wasinta khawajtenka, tucuy iman cajpas allin wakaychaska. ");
INSERT INTO qulNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Chaywanpas paymanta astawan callpayoj jamuspa atipanman chayka, confiaskan armacunata cajnincunatapiwan kechunman, jap'icapunmantaj. ");
INSERT INTO qulNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Pichus mana nokawan cajka, noka contra. Pitajchus nokawan mana pallajka, t'acaran. ");
INSERT INTO qulNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Sajra espíritu uj runamanta llojsin chayka, ch'aqui lugarcunata purin samacunata masc'aspa. Mana tarispataj, nin: ‘Cutipusaj maymantachus llojsimuni chay wasiyman.’ ");
INSERT INTO qulNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Chayaspataj, chay runata taripan uj wasi pichaska jallch'askata jina. ");
INSERT INTO qulNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Chhicataj purispa, paymanta nejtinpas astawan sajra kanchis espiritucunata tantaycun. Tantaycuspataj, chay runaman pusaycun. Chay runataj ñaupaj caskanmanta nejtenka astawan sajra capun.” ");
INSERT INTO qulNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Chaycunata Jesús parlachcajtin, uj warmi runacuna chaupipi alto vozwan nerkan: —¡Cusicuyniyojmi pi warmichus onkocusunqui, wiñachisunquitaj chayka! ");
INSERT INTO qulNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesús nerkan: —¡Astawanpas Diospaj niskanta uyarispa casucojcuna cusicuyniyojka cancu! ");
INSERT INTO qulNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Achqha runa tantacamuchcajtincu, Jesús parlayta kallarerkan: “Cunan tiempopi causachcaj runacunaka sajra caspa, milagrota mañancu. Manataj waj milagrota riconkacuchu, manachayri Jonasllamanta. ");
INSERT INTO qulNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Imaynatachus Jonás Nínive llajtayoj runacunaman señal carkan, ajinallatataj Tataj Churenka cay tiempopi causachcaj runacunaman señal canka. ");
INSERT INTO qulNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Juicio p'unchaypi causarimuspa, uray llajtamanta gobernaj warmi cay tiempopi causachcaj runacunata juchachanka. Payka carumanta jamorkan gobernaj Salomonpaj yachaynin uyarej. Salomonmanta nejtinpas, caypi cachcan astawan yachayniyoj. ");
INSERT INTO qulNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Juicio p'unchaypi Nínive llajtayoj runacuna causarimuspa, cay tiempopi causachcaj runacunata juchachankacu, imaraycuchus Nínive llajtayoj runacuna Jonaspaj willaskanta uyarispa, Diosman cutirerkancu. Jonasmanta nejtinpas, astawan curaj caypi cachcan. ");
INSERT INTO qulNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Ni pi c'anchayta jap'ichispaka, pacaycunchu, nillataj cajonwan c'umpiycunchu, manachayri altopi churan, wasiman yaycojcuna c'anchaypi canancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ñawiyquicuna c'anchay jina cuerpoyquipaj; ñawiyqui allin cajtin, tucuy cuerpoyqui c'anchayniyoj canka. Mana allin cajtinri, cuerpoyqui tutayajpi canka. ");
INSERT INTO qulNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Cuidacuychis, kanpi caj c'anchay ama tutayachunchu. ");
INSERT INTO qulNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tucuy cuerpoyqui c'anchay cajtin, mana ni ima tutayaj cajtin, tucuy imata sut'ita ricunqui, lámpara c'anchaywan jina.” ");
INSERT INTO qulNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesús parlayta tucojtintaj, uj fariseo wajarkan wasinpi miqhunanpaj. Wasinman yaycuspataj, tiyaycorkan miqhunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Costumbreman jina Jesús maquinta mana mayllacojtin, fariseo waj jinata khawarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Señortaj nerkan: —Kancuna fariseocunaka vasota platotapas patallanta limpiochanquichis. Sonkoyquichistataj mana allinwan, suwacuspa ima jap'iskayquichiswan junt'achinquichis. ");
INSERT INTO qulNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Mana yuyayniyojcuna! ¿Manachu yachanquichis patanta uqhuntapas Dios ruwaskanta? ");
INSERT INTO qulNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Limosnata koychis uqhu sonkoyquichispaj qhuyapayayninwan. Ajinapi tucuy ima limpio canka. ");
INSERT INTO qulNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“¡Ay, kancuna fariseocuna! Diezmota konquichis yerba buenamanta, rudamanta, tucuy verduramantawan. Recto causayta, Diosta munacuytawan konkapunquichis. Chayta ruwanayquichis carkan, mana diezmota koyta konkapuspa. ");
INSERT INTO qulNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“¡Ay, kancuna fariseocuna! Sinagogacunapi ñaupajpi alabanacaj tiyayta munanquichis. Callecunapi tucuy respetowan saludanata munanquichis. ");
INSERT INTO qulNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“¡Ay, kancuna! ¡Mana riqhurej sepulturacuna jina canquichis, patantataj runacuna purincu mana yachaspa! ");
INSERT INTO qulNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ujnin leymanta yachachej contestarkan: —Yachachej, cayta nispaka, nokaycutapas ofendiwanquichis. ");
INSERT INTO qulNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesustaj nerkan: —¡Ay kancunapas, leymanta yachachejcuna! Kancuna ujcunaman mana apay atinata k'epichinquichis, kancunataj ni uj dedollayquichiswanpas yanapaycurinquichischu. ");
INSERT INTO qulNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“¡Ay kancuna, profetacunapaj sepulturancunata ruwajcuna! Abueloyquichiscuna paycunata wañucherkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Chay ruwaskayquichiswan ricuchicunquichis quiquincama caskayquichista, imaraycuchus paycuna profetacunata wañucherkancu, kancunataj sepulturancuta ruwanquichis. ");
INSERT INTO qulNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Chayraycu Dios yachayninpi nin: ‘Profetacunata apostolcunatawan noka cachamuskayquichis. Paycunatataj waquinta wañuchinquichis, waquintataj ñac'arichinquichis.’ ");
INSERT INTO qulNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Cay tiempopi causachcaj runacunamanta Dios cuentata mañanka tucuy profetacunata wañuchiskancumanta, cay pacha ruwacuskanmantapacha. ");
INSERT INTO qulNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abelta wañuchiskanmantapacha Zacariasta wañuchiskancucama Dios cuentata mañanka cay tiempopi causachcaj runacunamanta. Zacariasta wañucherkancu altarwan santo lugarwan chaupipi. ");
INSERT INTO qulNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“¡Ay, leymanta yachachejcuna, yachaypaj llaventa jap'icapojcuna! Kancuna quiquiyquichis mana yaycunquichischu, jarc'anquichistaj yaycuy munajcunata.” ");
INSERT INTO qulNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesús caycunata parlayta tucuchajtin, leymanta yachachejcuna fariseocunapiwan sinchita phiñaricorkancu. Jesusta molestayta kallarerkancu tucuy imamanta tapuspa; ");
INSERT INTO qulNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","imaraycuchus juchapi urmachiyta munachcarkancu, imallamantapas payta juchachanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Waranka waranka runacuna tantacamorkancu sarunacunancucama. Chaymanta Jesús parlayta kallarerkan. Ñaupajta discipuloncunaman nerkan: “Cuidacuychis fariseocunapaj levaduranmanta; niyta munani iscay uya caynincumanta. ");
INSERT INTO qulNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tucuy pacaska cajcunapas sut'inchaconka, yachaconkataj. ");
INSERT INTO qulNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Tucuy ima tutayajpi niskayquichiska, sut'i p'unchaypi uyariconka; imatachus pacapi wasita wisk'aycuspa niskayquichispas, wasi patamanta wajach'aconka. ");
INSERT INTO qulNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Amigoycuna, kancunaman niyquichis: Ama manchaychischu cuerpota wañuchejcunata. Chaymanta mana imatapas ruwayta atincumanchu. ");
INSERT INTO qulNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Noka niskayquichis pitachus manchacunayquichista: Diosta manchacuychis. Pay wañuchispa, infiernoman wijch'uycuyta atin. ");
INSERT INTO qulNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“¿Manachu phichka pisketota vendincu iscay kolkellapi? Chaywanpas Dios mana maykennincutapas konkapunchu. ");
INSERT INTO qulNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Yachaychis, umayquichispi chujchayquichispas ujmanta uj yupaska. Ajinaka ama manchacuychischu; kancunaka Diospaj astawan valinquichis achqha pisketocunamanta nejtenka. ");
INSERT INTO qulNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Noka niyquichis, pillapas runacunapaj ñaupakenpi nokapaj caskanta willacojtin, nokapas Diospaj angelnincunapaj ñaupakenpi nokapaj caskanta nillasajtaj. ");
INSERT INTO qulNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pillapas runacunapaj ñaupakenpi negawajtaka, nokapas Diospaj angelnincunapaj ñaupakenpi negallasajtaj. ");
INSERT INTO qulNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Pillapas noka, Tataj Churin, contra parlanman chayka, Dios perdonanman. Santo Espíritu contra parlajcajtaka, Dios mana perdonankachu. ");
INSERT INTO qulNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Kancunata sinagogaman, juezman, jefecunaman ima apajtenka, ama ninquichischu: ‘Imanasajtaj cunanri’ nispaka, ni imaynata ninayquichistapas, ");
INSERT INTO qulNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","imaraycuchus parlanayquichis rato Santo Espíritu yachachisunquichis imatachus parlanayquichista.” ");
INSERT INTO qulNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Uj runa Jesusta nerkan: —Yachachej, waukeyta nipuway herenciata partinawanpaj. ");
INSERT INTO qulNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesustaj contestarkan: —Amigo, ¿pitaj churawarkan juezta jina chayri partejta jinapas? ");
INSERT INTO qulNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nillarkantaj: —Cuidacuychis tucuy imata kancunalla jap'iycuy munanamanta, imaraycuchus runapaj causaynenka manami cajnincunapichu. ");
INSERT INTO qulNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Chhicataj cayta nerkan: “Uj khapaj runa carkan, jallp'anpitaj achqhata uricherkan. ");
INSERT INTO qulNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Chay khapaj runa pensarkan: ‘¿Imanasajtajri? Manaña maypi ajthapiskayta wakaychayta atinichu. ");
INSERT INTO qulNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Cayta ruwasaj: Trojeycunata pascaraspa, astawan athuncunata ruwasaj. Chaypi ajthapiskayta tucuy cajniycunatawan tantasaj. ");
INSERT INTO qulNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nisajtaj: Cunanka achqhaña capuwan, sumaj wakaychaska achqha watapaj. Samaricusaj, miqhuspa ujyaspa cusicusaj’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Diostaj payta nerkan: ‘¡Mana yuyayniyoj runa! Cunan ch'isipacha wañunqui. Chay achqha tantaskayquiri, ¿pipajchá canka?’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ajinami pasan piwanchus payllapaj khapajyajwanka, Diospaj ñaupakenpitaj mana imayoj.” ");
INSERT INTO qulNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jesús discipuloncunaman nerkan: “Cayta niyquichis, ama ‘imanasajtaj’ ninquichischu causanayquichismanta, miqhunayquichismanta, p'achallicunayquichismantapas. ");
INSERT INTO qulNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Causayka astawan valin miqhunamanta nejtenka, cuerpopas astawan valin p'achamanta nejtenka. ");
INSERT INTO qulNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pisketocunata khawariychis, mana tarpuncuchu nitaj ajthapincuchu, ni trojencu canchu. Chaywanpas Dios miqhunata kon. Kancunaka piskocunamanta nejtinpas astawan valinquichis. ");
INSERT INTO qulNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Kancuna sinchita afanacuspari, ¿atiwajchischu yapacuyta cuscan metrollatapas? ");
INSERT INTO qulNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Chayllatapas mana ruwayta atispari, ¿imaraycutaj llaquicunquichis chay tucuy imamantari? ");
INSERT INTO qulNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Khawariychis t'icacunapaj wiñaskanta: mana llanc'ancuchu nitaj phuchcancuchu. Chaywanpas niyquichis, Salomonpas tucuy khapaj cayninwan manapuni ujnin t'ica jinallapas p'achallicorkanchu. ");
INSERT INTO qulNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Sichus Dios koratapas chay jinata p'achallin, cunan wiñachcan, pakarintaj ruphachiska canka chayka, astawanraj kancunata p'achallisunquichis, pisi creeyniyoj runacuna. ");
INSERT INTO qulNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Chayraycu ama llaquicuychischu miqhunata ujyanata masc'aspa. ");
INSERT INTO qulNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Diospi mana creejcuna tucuy caycunamantaka afanacuncu. Kancunapajka can uj Tatayquichis, payka yachanña imacunatachus necesitaskayquichista. ");
INSERT INTO qulNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Diospaj gobiernonpi afanacuychis, tucuy caycunatapas jap'ekallanquichistaj. ");
INSERT INTO qulNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ovejaycuna, pisilla canquichis, chaywanpas ama manchacuychischu. Qhuyapayacoj Tatayquichis kosunquichis gobiernonpi canayquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Cajniyquichista vendiychis; necesitajcunaman koychis. Ruwaychispuni mana mauc'acoj saquillata jina. Mana tucucoj khapaj cayniyquichista wakaychaychis janaj pachapi. Chaymanka mana suwa yaycunchu, nitaj thutapas miqhunchu. ");
INSERT INTO qulNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Maypichus khapaj cayniyquichis cachcan, chayllapitaj sonkoyquichispas cachcan. ");
INSERT INTO qulNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Waquichiska, p'achalliska, c'anchayniyquichispas jap'ichiska cachcaychis. ");
INSERT INTO qulNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Casamientomanta patronnincupaj cutimunanta suyaj runacuna jina cachcaychis, chayamuspa puncuta tacamojtin quicharanayquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Rijch'aspa patronnincupaj cutimunanta suyajcunaka sinchi cusiska cankacu. Chay patrón mesanpi tiyaycuchispa, pay quiquin miqhunata jaywanka. ");
INSERT INTO qulNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Chaupi tutapas pakariyamuytapas chayamuspa paycunata rijch'achcajta taripanka chayka, cusicuyniyoj cankacu. ");
INSERT INTO qulNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Yachaychis cayta: Sichus wasiyoj ima horata suwa jamunanta yachanman chayka, mana puñuspa suyanman, manataj suwachicunmanchu. ");
INSERT INTO qulNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kancunapas waquichiska cachcaychis, imaraycuchus mana yuyaskayquichis rato Tataj Churenka jamonka.” ");
INSERT INTO qulNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pedrotaj taporkan: —Señor, cay niskayqui ¿nokallaycupajchu, icha tucuypajchu? ");
INSERT INTO qulNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Señortaj contestarkan: “¿Mayken mayordomotaj yuyaywan, fiel, sumajta khawaj? Chaycajta patronnin churan wasinpi cajcunaman miqhunata konanpaj. ");
INSERT INTO qulNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Cusicuyniyoj canka cay mayordomo, patronnin ajinata ruwachcajta taripanka chayka. ");
INSERT INTO qulNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Segurayquichis, cay jina mayordomotaka patronnin tucuy khapaj cayninta khawajta churanka. ");
INSERT INTO qulNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Chay mayordomochus sonkonpi ninman: ‘Patronneyka manaraj chayamonkachu’ nispa. Chhicataj llanc'ajcunata kharita warmitapas makayta kallarinman, sinchitataj miqhunman ujyanman machanancama chayka, ");
INSERT INTO qulNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","mana suyaskan p'unchaypi ni yachaskan horapi chayamonka patronnenka. Sinchita castiganka mana allin mayordomotaka, mana casucoj runacunata jina. ");
INSERT INTO qulNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Uywaska runa patronninpaj munayninta yachachcaspa, mana waquichicunchu nitaj munayninta ruwanchu chayka, sinchi castigaska canka. ");
INSERT INTO qulNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pichus mana yachaspalla castiganapaj jina ruwan chayka, pisi castigaska canka. Achqha jap'ekajmantaka, achqhata mañanka; achqha jap'ejka, achqhamanta cuentata konan canka. ");
INSERT INTO qulNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Noka jamuni cay pachapi ninata jap'ichej. ¡Mayta munayman chay nina laurachcanallantaña! ");
INSERT INTO qulNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ñac'arinayraj cachcan sinchi pruebata; llaquiska cachcani junt'acunancama. ");
INSERT INTO qulNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Pensanquichischu cay pachaman sonko tiyaycuy apamuskayta? Manami, nokapi creeskancuraycu chejninacunata apamuni. ");
INSERT INTO qulNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Cunanmantapacha uj familiapi phichkayoj tiyajka partiska canka, quimsa iscay contra, iscaytaj quimsa contra. ");
INSERT INTO qulNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tataka churin contra canka, churitaj tatan contra; mamaka ususin contra canka, ususitaj maman contra; suegraka khachunin contra canka, khachunitaj suegran contra.” ");
INSERT INTO qulNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesús nillarkantaj: “Kancuna inti yaycuypi phuyuta ricuspa, ‘Paranka’ ninquichis. ");
INSERT INTO qulNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Uray ladomanta wayramojtintaj, ‘K'oñi canka’ ninquichis. ");
INSERT INTO qulNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Iscay uyacuna! Janaj pachapipas cay pachapipas cajcunata khawaspa, imayna tiempo cananta yachanquichis chayri, ¿imaynatataj cunan tiempopi ima pasachcaskanta mana reparacunquichischu? ");
INSERT INTO qulNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“¿Manachu kan quiquiyqui justo cajta reparacuwaj? ");
INSERT INTO qulNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Pipas quejasunqui chayka, juezpajman purichcaspallaraj, paywan allinyacapuy mana juezman entreganasunquipaj, jueztaj guardiajman, guardiajtaj carcelpi wisk'aycusunquiman. ");
INSERT INTO qulNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Niyqui, mana llojsimuyta atiwajchu tucuy manuyquita paganayquicama.” ");
INSERT INTO qulNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Chay p'unchaycunapi runacuna Jesusman willaj jamorkancu. Pilato waquin Galilea runacunata wañuchicherkan, yawarnincuta Diosman ofreciskancu animalcunapaj yawarninwan chhajruchispa. ");
INSERT INTO qulNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús paycunata taporkan: “¿Pensanquichischu chay Galilea runacuna astawan juchayoj caskancuta tucuynin Galilea runacunamanta nejtin? ");
INSERT INTO qulNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mana jinachu. Kancunapas mana Diosman cutirejtiyquichiska, wañullanquichistaj. ");
INSERT INTO qulNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Siloepi torre urmaspa chunca pusajniyoj runata wañucherkan. ¿Creenquichischu paycuna astawan juchayoj caskancuta Jerusalenpi waj tiyacojcunamanta nejtin? ");
INSERT INTO qulNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mana jinachu. Kancunapas mana Diosman cutirejtiyquichiska, wañullanquichistaj.” ");
INSERT INTO qulNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Nillarkantaj cay jinata: “Uj runapaj uj higo sach'an carkan uva huertanpi. Urinta pallaj purispataj, mana uriyojta tariparkan. ");
INSERT INTO qulNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Huertata cuidajninman nerkan: ‘Quimsa watataña jamuni cay higo sach'api urita masc'aj, manataj urita taripanichu. P'atapuy ari. ¿Imapajtaj cay sach'a yankhapaj jallp'ata usuchenka?’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Cuidajninri nerkan: ‘Patronníy, ¿manachu cay watatawan callanmanraj? Chajmasaj, wanuchasajtaj. ");
INSERT INTO qulNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Sichus urenka chayka, allin canka; manapuni urejtintaj, p'atapunqui.’ ” ");
INSERT INTO qulNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Uj cuti, sinagoga wasipi Jesús yachachichcarkan samana p'unchaypi. ");
INSERT INTO qulNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Chaypitaj uj warmi cachcarkan chunca pusajniyoj wata onkoska. Uj sajra espíritu khoputa purichiska, manaña rectota sayayta atipuskachu. ");
INSERT INTO qulNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ricuspa Jesús wajarkan, nerkantaj: —Warmi, onkoyniyquimanta cachariskaña canqui. ");
INSERT INTO qulNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Maquincunata pay pataman churajtin, chhicapacha warmeka rectota sayarispa, Dios Tatata alabayta kallarerkan. ");
INSERT INTO qulNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Sinagoga wasipi caj jefe phiñacorkan, Jesús samana p'unchaypi chay warmita alliyachiskanmanta. Runacunaman nerkan: —Sojta p'unchay can llanc'anapaj; chay p'unchaycunapi jampichicoj jamuychis, ama samana p'unchaypeka. ");
INSERT INTO qulNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Señortaj nerkan: —¡Iscay uyacuna! ¿Manachu maykenpas samana p'unchaypi bueyta asnotapas pascaraspa apanquichis unuta ujyachimunapaj? ");
INSERT INTO qulNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Abrahampaj miraynin cay warmeka, paytataj supay Satanás wataska chunca pusajniyoj watataña cay onkoywan. ¿Manachu samana p'unchaypi pascarana canman? ");
INSERT INTO qulNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesús cayta nejtin, p'enkapi ricucorkancu chejnicojcunaka. Runacunataj cusiracorkancu Jesuspaj athun ruwaskanta ricuskancumanta. ");
INSERT INTO qulNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesús nillarkantaj: “Diospaj gobiernonri, ¿imamantaj rijch'acun? ¿Imawantaj rijch'achiyman? ");
INSERT INTO qulNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mostazapaj juch'uy mujitonwan. Uj runa cay mujitota jallp'anpi tarpojtin, wiñan sach'a canancama. Pisketocunapas ramancunapi tapachacuncu.” ");
INSERT INTO qulNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesús nillarkantaj: “Diospaj gobiernonta, ¿imawantaj rijch'achiyman? ");
INSERT INTO qulNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Levadurawan. Uj warmi levadurata quimsa chunca libra jac'uman chapuycojtin, tucuynin masa pokon.” ");
INSERT INTO qulNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jerusalenman purichcaspa, yachacherkan llajtacunapi estanciacunapi ima. ");
INSERT INTO qulNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Uj runa nerkan: —Señor, ¿pisillachu salvacuncu? Paytaj contestarkan: ");
INSERT INTO qulNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Afanacuychis c'ullcu puncunejta yaycunayquichispaj. Achqhayoj yaycuyta munankacu, manataj atenkacuchu. ");
INSERT INTO qulNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Wasiyoj jatarispa puncuta wisk'ajtinña, kancunaka jawapi wajaspa puncuta tacanquichis: ‘¡Señor, quichariwaycu!’ nispa. Paytaj nisunquichis: ‘Mana rejsiyquichischu, maymantachá canquichis.’ ");
INSERT INTO qulNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Kancunataj ninquichis: ‘Kanwan cusca miqhorkaycu, ujyarkaycutaj; calleycupi yachacherkanqui’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pay nillasunquichistaj: ‘Ña niyquichisña, mana rejsiyquichischu, maymantachá canquichis. ¡Caymanta puriychis, mana allin ruwajcuna!’ ");
INSERT INTO qulNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Yachanquichis Abraham, Isaac, Jacob, tucuy profetacunatawan Diospaj gobiernonpi caskancuta, kancunataj jawapi wijch'uska ricucunquichis. Chhicataj infiernopi kancuna wakanquichis, nanaymanta c'ariris nispa c'uturacunquichis. ");
INSERT INTO qulNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Wajcunataj jamonkacu wichay, uray, inti llojsiy, inti yaycuy ladocunamanta, Diospaj gobiernonpi tiyaycuspa miqhunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Chhica cunan khepapi cajcuna ñaupajpi riqhurenkacu, cunan ñaupajpi cajcunataj khepapi riqhurenkacu. ");
INSERT INTO qulNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Waquin fariseocuna chayamuspa, Jesusta nerkancu: —Herodes wañuchiyta munachcasunqui. Puripuy caymanta. ");
INSERT INTO qulNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesustaj contestarkan: —Puriychis, chay atojman willamuychis: ‘Khawariy, cunan pakarinpas nokaka sajra espiritucunata katerkosaj, onkoskacunatapas alliyachisaj. Minchhataj ruwanayta tucuchasaj.’ ");
INSERT INTO qulNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Cunan, pakarin, minchhapas ruwanay can. Uj profetaka Jerusalenpi wañunan. ");
INSERT INTO qulNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“¡Jerusalén runacuna, profetacunata wañuchejcuna, Diospaj palabran willacoj cachamuskacunata rumiwan chhokaspa wañuchejcuna! ¡Jayc'a cuti kancunata tantaycuyta munarkani, imaynatachus wallpa rijran uqhupi chiullincunata tantaycun jinata, manataj munarkanquichischu! ");
INSERT INTO qulNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Khawariychis, wasiyquichis wijch'uska canka. Niyquichis, manaña ricuwanquichischu: ‘¡Alabaska cachun Señorpaj sutinpi jamojka!’ ninawayquichis p'unchaycama. ");
INSERT INTO qulNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Samana p'unchaypi Jesús miqhoj yaycorkan uj fariseo jefepaj wasinman. Waj fariseocunataj khamisiyachcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Chaypi uj punquiska runa Jesuspaj ñaupakenpi cachcarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesús leymanta yachachejcunata fariseocunatawan taporkan: —Samana p'unchaypi, ¿onkoskata alliyachinachu, icha manachu? ");
INSERT INTO qulNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Paycunataj ch'inlla carkancu. Chhicari onkoskata alliyachispa, cachaporkan. ");
INSERT INTO qulNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Fariseocunaman nerkan: —¿Maykenniyquichistaj wawanpas wacanpas phujyuman urmaycojtin, manachu chay ratopacha orkhomunman, samana p'unchay cachcajtinpas? ");
INSERT INTO qulNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Manataj contestayta aterkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Invitaskacuna sumaj tiyanacunallata ajllaskancuta ricuspa, Jesús yuyaycharkan: ");
INSERT INTO qulNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Casamientoman invitaska caspaka, ama ñaupajpi tiyaycunquichu. Kanmanta astawan importantepas chayamunan canman, ");
INSERT INTO qulNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","invitacojtaj nisunquiman: ‘Chay tiyanayquita payman koy’ nispa. Kantaj p'enkacuspa khepaman puripunayqui canman. ");
INSERT INTO qulNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Chayraycu invitaska caspaka, khepapi tiyacuy. Invitacojtaj jamuspa nisunquiman: ‘Amigóy, ñaupajpi tiyacuy’ nispa. Ajinapi respetaska canqui invitaskacunapaj ñaupakencupi. ");
INSERT INTO qulNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Pillapas pay quiquin importante yuyacojka, humillaska canka; humillacojtaj athunyachiska canka. ");
INSERT INTO qulNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesús invitacojman nillarkantaj: —Jayc'ajchus miqhunapaj cenapajpas invitaspaka, ama invitanquichu amigoyquicunata, waukeyquicunata, parienteyquicunata, ni ladoyquipi tiyaj khapajcunatapas. Paycunaka invitaspa, cutichipullasunquichismantaj. ");
INSERT INTO qulNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Manachayri kan invitacuspaka, pobrecunata, such'ucunata, cojocunata, ñausacunatawan invitay. ");
INSERT INTO qulNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ajinapi cusicuyniyoj canqui. Paycuna mana cutichiyta atisunquichischu. Justo runacuna causariskancu p'unchaypi cutichiska canqui. ");
INSERT INTO qulNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Chayta uyarispa, uj mesapi tiyaj Jesusman nerkan: —¡Cusicuyniyoj cankacu Diospaj gobiernonpi athun miqhunapi miqhojcunaka! ");
INSERT INTO qulNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesustaj nerkan: —Uj runa athun miqhunata waquichispa, achqha runacunata invitarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Miqhuna waquiskaña cachcajtin, uywaskanta cacharkan invitaskacunaman willamojta: ‘Jamullaychisña, ña waquichiskaña’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tucuynincu mana jamuyta munarkancuchu. Uj nerkan: ‘Cunallan jallp'ata rantini; chayta khawaj purinay. Rogayqui, sakerillaway’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ujnintaj nerkan: ‘Cunallan phichka yunta bueycunata rantini; chayta yanarimunay. Rogayqui, sakerillaway’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ujcajtaj nerkan: ‘Cunallanraj casaracuni. Mana jamuyta atiymanchu' nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Uywaskantaj cutimuspa, cay tucuy imata patronninman willarkan. Chhicari patronka phiñaricorkan, uywaskantataj nerkan: ‘Cunanpacha puriy callecunata plazacunatapas. Cayman apamuy pobrecunata, such'ucunata, ñausacunata, cojocunatapas.’ ");
INSERT INTO qulNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Cutimuspataj uywaskanka nerkan: ‘Señor, ña mandawaskayquita ruwaniña. Chaywanpas lugar canraj.’ ");
INSERT INTO qulNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Chhicari patronnenka uywaskanta nerkan: ‘Puriy ñancunata llajta cantocunatawan. Wajcunata pusamuypuni; yaycumuchuncu wasiy junt'a cananpaj. ");
INSERT INTO qulNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Niyquichis, cay miqhunapi ni maykenpas jakay ñaupaj invitaskacunamanta miqhonkacuchu.’ ");
INSERT INTO qulNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Achqha runa Jesuswan purichcarkancu, paytaj cutirispa nerkan: ");
INSERT INTO qulNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Maykenpas nokaman jamun chayka, manataj astawan munacuwanchu tatanmanta, mamanmanta, warminmanta, churincunamanta, waukencunamanta, panancunamanta, pay quiquinmantapas nejtenka, mana discípuloy cayta atinmanchu. ");
INSERT INTO qulNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Pichus wañunancama sufrispapas mana nokawan purejka, mana discípuloy cayta atinmanchu. ");
INSERT INTO qulNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Maykennillayquichispas uj torreta ruwayta munaspa, ¿manachu tiyaycuspa kolkentaraj yupanka, yachananpaj aypanmanchu manachu ruwayta tucuchananpaj chayta? ");
INSERT INTO qulNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Mana chayka, cimientota kallariycuspa mana tucuchayta atipojtin, tucuy ricojcuna burlacuspa asipayayta kallarincuman. ");
INSERT INTO qulNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Nincuman: ‘Cay runaka ruwayta kallariycun, manataj tucuchayta atipunchu’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ajinallatataj uj gobierno guerraman waj gobierno contra purinanpaj, ¿manachu ñaupajta khawarinman, atenkachus manachus atipayta chunca waranka soldadowan, ujcajtaj iscay chunca waranka soldadowan jamuchcajtin chayta? ");
INSERT INTO qulNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mana atej jina caspaka, carupiraj enemigon cachcajtin, cachanka allinyapunapaj parlapayajta. ");
INSERT INTO qulNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ajina ari, pillapas tucuy capuyninta mana sakejka, mana discípuloy cayta atinmanchu. ");
INSERT INTO qulNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Cacheka sumaj. Ch'apajyanman chayri, ¿imaynatataj ujtawan cachinchacunman? ¿Imapajtaj sirvinman? ");
INSERT INTO qulNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mana jallp'apaj ni wanupaj sirvinmanñachu, manachayka wijch'unallapajña. Uyarejcunaka, entendiychis.” ");
INSERT INTO qulNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Romapaj impuestota tucuy cobrajcuna juchasapacunapiwan Jesusman chimpaycorkancu uyarinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Fariseocuna leymanta yachachejcunapiwan thutuspa, nerkancu: —Cayka juchasapacunata jap'ekan, paycunawantaj miqhun. ");
INSERT INTO qulNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jesustaj cay jinata nerkan: ");
INSERT INTO qulNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Maykenniyquichistaj pachaj ovejayoj caspa, ujnin chincarkojtin, iskon chunca iskonniyojta sakerpayaspa, ¿manachu masc'aj puriwajchis tarinayquichiscama? ");
INSERT INTO qulNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Taripuspataj cusiska k'epiricuwajchis. ");
INSERT INTO qulNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Wasiman chayachispataj, amigoyquichiscunata llajtayquichispi cajcunatawan tantaycuwajchis. Niwajchistaj: ‘Nokawan cusicuychis, chincaska ovejayta taricapuni’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Cayta niyquichis: Ajinallatajmi janaj pachapi athun cusicuy can uj juchasapallapas Diosman cutirejtenka, iskon chunca iskonniyoj ‘mana juchayoj cani’ nej runacunamanta nejtenka. ");
INSERT INTO qulNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Pi warmitaj chunca kolkenmanta ujninta chincachin chayka, c'anchayta jap'ichispa wasinta pichaspataj, ¿manachu masc'anman tarinancama? ");
INSERT INTO qulNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tarispataj, tantaycunman amigancunata llajtanpi cajcunatawan; ninmantaj: ‘Nokawan cusicuychis, chincaska kolketa taricapuni’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Cayta niyquichis, ajinallatataj Diospaj angelnincuna cusicuncu, uj juchasapallapas Diosman cutiricuskanmanta.” ");
INSERT INTO qulNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesús cayta nillarkantaj: “Uj runapaj iscay churin carkan. ");
INSERT INTO qulNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Sullc'acaj tatanman nerkan: ‘Tatáy, herencia tupawaskanta kopuway’ nispa. Tatancutaj sapa ujman imachus tupaskanta koporkan. ");
INSERT INTO qulNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Khepantin p'unchaycunataj sullc'acaj churi herencianta vendirapuspa, chay kolkewantaj caruta puriporkan waj nacionman. Jakaypitaj tucuy kolkenta tucucharkan mana allinta causaspa. ");
INSERT INTO qulNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Lliujtaña tucuchapojtin, chay nacionpi athun yarekay carkan. Paytaj yarekaska puriycacharkan. ");
INSERT INTO qulNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Chayraycu uj llajtayoj runamanta llanc'anata mañacorkan. Paytaj qhuchi michejta campoman cacharkan. ");
INSERT INTO qulNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Sinchita yarekachicuspa, qhuchicunapaj miqhunanta miqhuyta munarkan. Manataj pipas ni imata jaywarejchu cancu. ");
INSERT INTO qulNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Pensayta kallarerkan: ‘Tataypaj wasinpi llanc'ajcunaka achqha miqhunayoj cancu, nokataj caypi yarekaymanta wañunayachcani. ");
INSERT INTO qulNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Tataypaj wasinman cutipusaj, nisajtaj: Tatáy, juchallicuni Dios contra kan contrapas. ");
INSERT INTO qulNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Manaña churiyquipaj jinachu cani. Llanc'ajniyquicunata jina ricuway’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ajinataj sayariytawan tatanpaj wasinman cutiporkan. “Carullapiraj cachcajtin, tatanka payta ricorkan. Qhuyapayacuspataj, taripaj phawarkan. Mark'aycuspataj much'aycorkan. ");
INSERT INTO qulNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Churintaj nerkan: ‘Tatáy, juchallicuni Dios contra kan contrapas. Manaña churiyquipaj jinachu cani.’ ");
INSERT INTO qulNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Tatantaj uywaskancunata mandarkan: ‘Uskhayta astawan sumajnin p'achata orkhomuspa p'achalliycuychis. Uj sortijata dedonman churaychis; zapatotapas churaychis. ");
INSERT INTO qulNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Wiracaj waca uñata apamuspa ñac'aychis. ¡Miqhusunchis, sumajta cusicusunchis! ");
INSERT INTO qulNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Cay chureyka wañuska jina carkan, cunantaj causarimpunmanpas jina. Chincaska carkan, cunantaj tariska.’ Ajinamanta sumajta cusicuyta kallarerkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Chaycamataj curaj churin chajrapi cachcarkan. Wasi kayllaman chayamuspataj, uyarerkan tusunapaj jina tocaskata. ");
INSERT INTO qulNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ujnin uywaskata wajaspa, taporkan ima pasachcaskanta. ");
INSERT INTO qulNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Uywaskataj nerkan: ‘Waukeyqui cutimpun; tatayquitaj wiracaj waca uñata ñac'achin, waukeyqui allin c'uchilla chayampuskanmanta’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Chaymanta curaj chureka sinchita phiñacorkan; mana yaycuyta munarkanchu. Ajinaka tatan llojsimuspa rogarkan yaycunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tatanman nerkan: ‘Nokaka achqha watata sirviyqui, casuspallapuni. Nitaj jayc'ajpas uj cabritallatapas kowanquichu, amigoycunawan miqhuspa cusiricunaypaj. ");
INSERT INTO qulNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Cunantaj cay churiyqui, mana allin warmicunawan kolkeyquita tucuchamuspa chayamojtintaj, wiracaj waca uñata paypaj ñac'achipunqui.’ ");
INSERT INTO qulNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Tatantaj nerkan: ‘Churíy, kanka nokallawanpuni cachcanqui. Tucuy ima cajniytaj kanpajta. ");
INSERT INTO qulNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Cunanka athun fiestata ruwananchis, cusicunanchis, imaraycuchus waukeyqueka wañuska jina carkan, cunantaj causarimpunmanpas jina; chincaska carkan, cunantaj taricapunchis.’ ” ");
INSERT INTO qulNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús discipuloncunaman nillarkantaj: “Uj khapaj runa carkan. Payman willaj jamorkancu: ‘Mayordomoyqui mana allintachu khawachcan’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Patronnin wajaspa, nerkan: ‘¿Imatataj kanmanta uyarichcani? Llanc'askayquimanta cuentata koway. Manaña astawan mayordomoyñachu canqui’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Mayordomotaj pensarkan: ‘¿Imanasajtaj cunanri? Patronniy wijch'orkowan. Mana callpay canchu chajrapi llanc'anaypajka, mañacuytapas p'enkacuni. ");
INSERT INTO qulNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Yachaniña ima ruwanayta, patrón wijch'uwajtin runacuna wasincuman wajanawancupaj’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Chaymanta patronninpaj manun runacunata wajarkan ujmanta uj. Ujninta taporkan: ‘¿Jayc'a manutaj patronniyman canqui?’ ");
INSERT INTO qulNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Paytaj contestarkan: ‘Pachaj barril aceite manu cani.’ Mayordomotaj nerkan: ‘Cay documentoyquita apacapuy; tiyaycuy, wajta ruway phichka chuncallamantaña.’ ");
INSERT INTO qulNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ujtañataj taporkan: ‘Kanrí, ¿jayc'a manutaj canqui?’ Paytaj contestarkan: ‘Pachaj arroba trigo.’ Mayordomotaj nerkan: ‘Cay documentoyquita apacapuy; wajta ruway pusaj chuncallamantaña.’ ");
INSERT INTO qulNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Patrontaj alabarkan mana allin mayordomota, sinchi yuyayniyoj caskanmanta. Mana creejcunaka cajnincunawan astawan yuyayniyoj cancu creejcunamanta nejtenka. ");
INSERT INTO qulNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Cayta niyquichis, cay sajra pachapaj kolkenwan amigocunata jap'iychis, kolkeyquichis tucucojtin janaj pachapi wiñaypaj jap'ekaska canayquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Uj chhicanpi justota ruwajka, achqhapipas justota ruwallantaj. Uj chhicanpi mana justota ruwajka, achqhapipas manallataj justotachu ruwan. ");
INSERT INTO qulNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Cay sajra pachapi caj imancunawan mana justota ruwajmanri, ¿pitaj janaj pachapi caj imacunata confianka? ");
INSERT INTO qulNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Wajpaj cajninwan mana justo cajtiyquichis, ¿pitaj kosunquichisman kancunapaj cajtari? ");
INSERT INTO qulNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Iscay patronta mana pipas sirviyta atinmanchu. Imaraycuchus ujninta chejninman, ujnintataj munacunman. Ujcajman junt'anman, ujcajmantataj ni ima importanmanchu. Mana aticunmanchu Diosta kolketawan sirvinaka.” ");
INSERT INTO qulNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Cayta uyarispa, kolkella munacoj fariseocuna Jesusta asipayarkancu burlacuspa. ");
INSERT INTO qulNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesús paycunaman nerkan: “Kancuna sumaj runaman rijch'acunquichis, sumaj causayniyoj runacunapas cawajchis jina. Chaywanpas Dios sonkoyquichista rejsin. Cay pachapi runacunapaj ‘allin’ nispa khawaskancuta Dios millacun. ");
INSERT INTO qulNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Moisespaj leynin profetacunapaj escribiskancupiwan Juancama carkan junt'anapaj. Chhicamanta, sumaj noticiacuna willacun Diospaj gobiernonmanta. Tucuynincuta callpachan yaycunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Janaj pacha cay pachapas tucucuyta atin, leycajtaj mana tucunmanchu, manaraj junt'acuspaka. ");
INSERT INTO qulNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Uj kosa esposanmanta divorciacuspa wajwan casaracun chayka, adulterio juchata ruwan. Pillapas divorciaska warmiwan casaracojtaj, adulterio juchata ruwallantaj. ");
INSERT INTO qulNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Uj khapaj runa carkan, sinchi fino p'achawan p'achallicoj. Sapa p'unchay sumaj fiestata ruwaj tucuy ima sumaj miqhunacunawan. ");
INSERT INTO qulNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Callarkantaj uj runa mana imayoj, Lázaro sutiyoj, llaga entero. Khapaj runapaj puncunpi tiyacuchcarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Cay runataj khapajpaj mesanmanta urmakaj puchucunawan sajsayta munarkan. Alkocunapas chimpaycuspa, llagancunata llajwaj cancu. ");
INSERT INTO qulNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Uj p'unchay Lázaro wañuporkan. Angelcunataj pusacaporkancu Abrahampajman, paraíso niskaman. Khapaj runapas wañupullarkantaj, paytataj p'ampaporkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","“Uqhu pachapitaj sinchita sufrichcaspa, carumanta Abrahamta Lazarotawan ricorkan. ");
INSERT INTO qulNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Chhicaraj wajach'acorkan: ‘¡Tatáy Abraham, qhuyapayaway! Lazarota cacharimuway. Dedon puntallantapas unupi jok'ocharispa, kalluyta thasnuriwachun. Nina lauraypi sinchita ñac'arichcani.’ ");
INSERT INTO qulNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abrahamtaj contestarkan: ‘Churíy, yuyaricuy causachcasparaj tucuy imayoj caskayquita, Lazarotaj ñac'ariskanta. Cunanka Lazaroka caypi cusiska cachcan, kantaj chaypi ñac'arichcanqui. ");
INSERT INTO qulNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Chaywanpas uj athun wayk'o can chaupinchispi. Chayraycu caymanta chayman puriy munajcuna mana atincumanchu, nillataj chaymanta cayman jamuy munajcunapas atincumanchu.’ ");
INSERT INTO qulNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Khapaj runataj contestarkan: ‘Tatáy Abraham, mañacuyqui tataypaj wasinman Lazarota cacharipunawayquipaj. ");
INSERT INTO qulNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Chaypi phichka waukeycuna can. Paycunaman willamuchun, paycunapas ama cay ñac'arina lugarman jamunancupaj.’ ");
INSERT INTO qulNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abrahamtaj nerkan: ‘Moisespaj profetacunapaj escribiskan maquincupi can. ¡Chayta uyarispa casuchuncu!’ ");
INSERT INTO qulNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Paytaj nerkan: ‘Arí, tatáy Abraham, chaywanpas sichus uj wañuska causarispa paycunaman riqhurinman chayka, paycunaka Diosman cutirincuman.’ ");
INSERT INTO qulNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abrahamtaj nerkan: ‘Moisespaj profetacunapajpiwan escribiskanta mana casucuncuchu chayka, nillataj creencumanchu wañuskamanta causarejtapas.’ ");
INSERT INTO qulNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús discipuloncunaman nerkan: “Juchaman urmachicojcunaka callankapuni. ¡Ay, ujcunata juchaman urmachej runaka! ");
INSERT INTO qulNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Allin canman paypaj, cutana rumita cuncanman warcuycuspa kochaman wijch'uycunancoka, cay ujnin juch'uycunata juchaman urmachinantapachaka. ");
INSERT INTO qulNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡Cuidacuychis! “Hermanoyqui juchallicojtin, c'amiy; juchanmanta cutiricojtintaj, perdonapuy. ");
INSERT INTO qulNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Uj p'unchaypi kanchis cutitapas kan contra juchallicuspa, kanchis cutillatataj jamunman ‘Manaña juchallicusajchu’ nispa chayka, perdonapuy.” ");
INSERT INTO qulNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Apostolcuna Señormanta mañarkancu: —Kowaycu astawan creeyta. ");
INSERT INTO qulNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Señortaj nerkan: —Creeyniyquichischus uj mostaza muju jinallapas canman, chhicataj cay sach'ata niwajchis: ‘T'iracuy, athun kochapi sayaycuspa saphichacuy’ nispa chayka, sach'aka casusunquichisman. ");
INSERT INTO qulNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ujnin kancunapaj uywacuskayquichis llanc'askanmanta chayri animalcunata khawaskanmanta cutimojtin, ¿niwajchischuri, ‘Yaycumuy, miqhoj tiyaycuy’ nispa? ");
INSERT INTO qulNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mana, astawanka niwajchis: ‘Waquichipuway miqhunaypaj. Jaywaway miqhunata ujyanatapas tucunaycama. Chaymantaraj kanpas miqhunqui ujyanquitaj’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nillataj graciasta konchu patronka, uywaskan jinata ruwajtenka. ");
INSERT INTO qulNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ajinallatataj kancunapas Diospaj tucuy mandacuskancunata junt'aspaka, ninayquichis: ‘Ni imapaschu canchis, imaraycuchus ruwanallanchista junt'anchis.’ ");
INSERT INTO qulNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesús Jerusalenman purichcaspa, Samariapaj Galileapajpiwan chaupinta pasarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Uj llajtaman chayachcajtin, chuncayoj leprawan onkoskacuna Jesuswan tupaj llojsimorkancu. Paycunataj carullapi sayaycuspa, ");
INSERT INTO qulNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","wajach'acamorkancu: —¡Yachachej, Jesús, qhuyapayawaycu! ");
INSERT INTO qulNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Paycunata ricuspa, Jesús nerkan: —Puriychis, sacerdotecunaman ricuchicamuychis. Paycunataj purichcajtillancuraj, alliyachiska ricucorkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ujnin alliyachiska ricucuspa, cutimorkan. Alto vozwantaj Diosta alabarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesuspaj ñaupakenpi konkoriycorkan. Pampacama c'umuycuspa graciasta korkan. Chay runataj Samaria llajtayoj carkan. ");
INSERT INTO qulNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesustaj nerkan: —¿Manachu chuncayoj carkanquichis alliyachiskacunari? ¿Maypitaj iskoncajri? ");
INSERT INTO qulNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Cay Samaria llajtayoj runallachu Diosta alabaj cutimun? ");
INSERT INTO qulNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Chay runaman nerkan: —Sayariy, puripuy. Creeskayquiraycu alliyachiska canqui. ");
INSERT INTO qulNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fariseocuna taporkancu: —Diospaj gobiernon ¿jayc'ajtaj chayamonka? —nispa. Jesús paycunata contestarkan: —Diospaj gobiernonka manami ricuna jinachu jamonka. ");
INSERT INTO qulNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mana niyta atenkacuchu: ‘Caypi cachcan’, chayri ‘jakaypi cachcan’ nispaka. Imaraycuchus Diospaj gobiernonka kancuna uqhupiña cachcan. ");
INSERT INTO qulNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Discipuloncunaman nerkan: —P'unchaycuna chayamonka, kancuna Tataj Churinpaj quedamunanta munanquichis ujnin p'unchayllatapas, nitaj quedaconkachu. ");
INSERT INTO qulNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Chay p'unchaycunapi waquincuna nenkacu: ‘Caypi cachcan’, chayri ‘Chaypi cachcan’ nispa. Ama purinquichischu, nitaj katinquichischu. ");
INSERT INTO qulNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Imaynatachus rayo c'anchan tucuy janaj pachata, ajina canka Tataj Churinpaj cutimunan p'unchayka. ");
INSERT INTO qulNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ñaupajtaka noka, Tataj Churin, sinchita sufrinay cachcan; cay tiempopi causachcaj runa mana jap'ekawankachu. ");
INSERT INTO qulNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Imaynatachus Noepaj tiemponpi pasarkan, ajinallatataj Tataj Churinpaj cutimunan p'unchaypeka pasanka. ");
INSERT INTO qulNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noepaj tiemponpi runacuna miqhuchcarkancu, ujyachcarkancu, casarachcarkancutaj Noé barcoman yaycunan p'unchaycama. Unu juicio chayamojtintaj, tucuynincu wañurarkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lotpaj tiemponcunapipas ajinallatataj pasarkan. Runacunaka miqhuchcarkancu, ujyachcarkancu, rantichcarkancu, vendichcarkancu, tarpuchcarkancu, wasicunatapas ruwachcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lot Sodoma llajtamanta llojsimojtinña, janaj pachamanta azufreyoj nina paramorkan. Tucuynincutaj wañurarkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Jinallataj canka Tataj Churin riqhurimunan p'unchaypeka. ");
INSERT INTO qulNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Jakay p'unchaypi wasi patapi cachcajka ama wasinman yaycuchunchu imatapas orkhomunanpaj; chajrapi cachcajka ama wasinman cutimuchunchu. ");
INSERT INTO qulNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Yuyaricuychis Lotpaj warminmanta. ");
INSERT INTO qulNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Niyquichis, pipas causayninta salvayta munajka, chincachenka; causayninta chincachejtaj, salvaconka. ");
INSERT INTO qulNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Chay tutapi iscayoj puñuchcankacu uj puñunapi: ujnin apaska canka, ujnintaj sakeska. ");
INSERT INTO qulNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Iscay warmicuna junto cutachcankacu: ujnin apaska canka, ujnintaj sakeska. ");
INSERT INTO qulNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Iscay kharicuna chajrapi llanc'achcankacu: ujnin apaska canka, ujnintaj sakeska. ");
INSERT INTO qulNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Discipuloncunataj cayta uyarispa taporkancu: —Señor, ¿maypitaj pasanka chay? Paytaj contestarkan: —Maypichus wañuska cachcan, chayman gallinazocunaka tantaconkacu. ");
INSERT INTO qulNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús uj ejemplowan yachacherkan mana chiriyaspa oración ruwanata. ");
INSERT INTO qulNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nerkan: “Uj llajtapi uj juez carkan, mana respetarkanchu runacunata ni Diostapas. ");
INSERT INTO qulNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Callarkantaj chay llajtapi uj viuda; achqha cutita quejacoj purej juezpajman ‘Justiciata ruwariway’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Jueztaj achqha tiempota mana uyariyta munarkanchu. Chaywanpas yuyaricuspa nerkan: ‘Diostapas mana manchanichu, ni runatapas respetanichu. ");
INSERT INTO qulNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Chaywanpas, cay viuda sinchita molestawaskanraycu, justiciata ruwasaj, ama sapa cuti jamuspa pacienciayta tucuchanawanpaj.’ ” ");
INSERT INTO qulNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Señor nillarkantaj: “Cayta nerkan mana allin juezka. ");
INSERT INTO qulNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Allin ari, ¿manachu Diosri ajllaskancuna tuta p'unchay paymanta mañacojtincu, justiciata ruwanka? ¿Suyachicullankapunichu? ");
INSERT INTO qulNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Niyquichis, mana suyachicuspa justiciata ruwanka. Chaywanpas Tataj Churin jamuspa, ¿taripankarajchu paypi creejcunata cay pachapi?” ");
INSERT INTO qulNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Allin caskancuta creecuspa wajcunata despreciajcunaman, Jesús cay ejemplota nerkan: ");
INSERT INTO qulNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Iscay runacuna temploman purerkancu oracionta ruwaj. Ujnin carkan fariseo, ujnintaj Romapaj impuesto cobraj. ");
INSERT INTO qulNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseoka sayaycuspa oracionta ruwaj cay jinata: ‘Diosníy, graciasta koyqui mana waquincuna jinachu caskaymanta: suwacoj, mana allin ruwaj, adulterio jucha ruwaj, nitaj chay impuesto cobraj runa jinachu. ");
INSERT INTO qulNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Noka iscay cutita ayunani semanapi; tucuy ganaskaymanta diezmoyta koni’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Impuesto cobrajcajtaj altarmanta carullapi sayaycuspa, ni janaj pachatapas khawariyta atrevicorkanchu. Pechollanta tacacuchcarkan ‘Diosníy, qhuyapayariway; juchasapa cani’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Niyquichis, cay impuesto cobrajka wasinman cutiporkan Diospaj perdonaskan, fariseocajtaj mana perdonaska carkan. Pillapas pay quiquin athunchacojka humillachiska canka; humillacojcajtaj athunyachiska canka.” ");
INSERT INTO qulNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Wawacunata Jesusman pusarkancu bendicinanpaj. Discipuloncunataj chayta ricuspa, apamojcunata c'amerkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesustaj wawacunata wajaspa discipuloncunaman nerkan: —Ama jarc'aychischu wawacuna nokaman jamunancuta, imaraycuchus Diospaj gobiernonka wawa jina cajcunapaj. ");
INSERT INTO qulNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Segurayquichis, pipas wawa jina Diospaj gobiernonta mana jap'ekanchu chayka, mana Diospaj gobiernonman yayconkachu. ");
INSERT INTO qulNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Uj jefe Jesusta taporkan: —Allin Yachachej, ¿imatataj ruwasaj wiñay causayniyoj canaypaj? —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesustaj nerkan: —¿Imaraycutaj “allin” niwanqui? Mana pipas allenka canchu. Dioslla allenka. ");
INSERT INTO qulNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Mandamientocunata yachanquiña: ‘Ama adulterio juchata ruwanquichu, ama wañuchinquichu, ama suwacunquichu, ama pimantapas llullata ninquichu, tata mamayquita respetanqui.’ ");
INSERT INTO qulNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Runataj nerkan: —Tucuy caycunata waynamantapacha junt'ani. ");
INSERT INTO qulNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Uyarispataj Jesús nerkan: —Chaywanpas ujtaraj ruwanayqui. Tucuy imayquita vendimuy, chay kolketataj pobrecunaman kopuy. Jamuspataj, nokawan puriy, jinamanta janaj pachapi khapaj cayniyqueka canka. ");
INSERT INTO qulNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Chayta uyarispa, runaka sinchita llaquicorkan, sinchi khapaj caskanmanta. ");
INSERT INTO qulNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Runata llaquiska puripojta ricuspa, Jesús nerkan: —¡Khapajcunaka ñac'ayta yayconkacu Diospaj gobiernonmanka! ");
INSERT INTO qulNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Camelloraj agujapaj ninrinta astawan facilta pasanmanpas, uj khapaj Diospaj gobiernonman yaycunantapachaka. ");
INSERT INTO qulNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Chayta uyarispa, taporkancu: —¿Chhicari pillataj salvaska cayta atinman? ");
INSERT INTO qulNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesustaj contestarkan: —Runacunapaj mana aticojka, Diospaj aticun. ");
INSERT INTO qulNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedro nerkan: —Señor, nokaycu tucuy imaycuta sakemuycu kanwan purinaycupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesús nerkan: —Segurayquichis, pillapas wasinta, warminta, tatanta, mamanta, wawancunatapas Diospaj gobiernonraycu saken chayka, ");
INSERT INTO qulNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","cay pachapi astawan achqhataraj jap'ekanka, khepamantaj wiñay causayta jap'ekanka. ");
INSERT INTO qulNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Chunca iscayniyoj discipuloncunata wajaspa, Jesús nerkan: “Cunanka Jerusalenman purisunchis. Chaypi Tataj Churinmanta profetacunapaj tucuy escribiskancu junt'aconka. ");
INSERT INTO qulNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Waj llajtayoj runacunaman entregankacu, paymanta burlaconkacu, insultankacu, thutkatankacu. ");
INSERT INTO qulNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Bajtankacu, wañuchenkacutaj. Quimsa p'unchaymantataj causariponka.” ");
INSERT INTO qulNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Discipuloncunataj mana entenderkancuchu, ni yacharkancuchu imamanta parlachcaskanta, imaraycuchus mana entendinancu jina carkan. ");
INSERT INTO qulNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesús Jericó llajtaman chayachcajtinña, uj ñausa ñan patapi tiyachcarkan limosnata mañacuspa. ");
INSERT INTO qulNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Achqha runa pasajta uyarispa, taporkan ima pasaskanta. ");
INSERT INTO qulNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Payman nerkancu Nazaret llajtayoj Jesús chayninta pasachcaskanta. ");
INSERT INTO qulNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ñausataj wajach'acorkan: —¡Jesús, Davidpaj Churin, qhuyapayariway! ");
INSERT INTO qulNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ñaupajta purejcunataj c'amerkancu jup'alla cananpaj. Chaywanpas payka astawan wajach'acorkan: —¡Davidpaj Churin, qhuyapayariway! ");
INSERT INTO qulNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesús sayaycuspa, ‘Pusamuychis’ nerkan. Chayamojtintaj, taporkan: ");
INSERT INTO qulNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Imatataj kanpaj ruwanayta munanqui? Ñausataj contestarkan: —Señor, ricuyta munani. ");
INSERT INTO qulNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesustaj nerkan: —¡Ricuy! Creeskayquiraycu alliyachiska canqui. ");
INSERT INTO qulNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ñausataj chaypacha ricucorkan. Jesuswantaj puriporkan, Diosta alabaspa. Tucuy runacuna chayta ricuspa, Diosta alaballarkancutaj. ");
INSERT INTO qulNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesús Jericó llajtaman yaycuspa chaupinta pasarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Chaypi tiyarkan uj khapaj runa, Zaqueo sutiyoj, Romapaj impuesto cobrajcunapaj jefen. ");
INSERT INTO qulNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jesusta ricuyta munarkan. Juch'uy runa caspataj, mana ricuyta aterkanchu achqha runa caskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ñaupajman phawaspa, uj sicómoro niska sach'aman sekarkorkan chay sach'amanta Jesusta ricunanpaj, imaraycuchus Jesús chayninta pasanan carkan. ");
INSERT INTO qulNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesús chayninta pasachcaspa, sach'ata khawarispa, Zaqueota ricorkan. Nerkantaj: —Zaqueo, uskhayta urakamuy. Cunanka wasiyquipi canay. ");
INSERT INTO qulNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Chhicapacha Zaqueo urakamorkan, cusicuywantaj wasinman Jesusta pusaycorkan. ");
INSERT INTO qulNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Chayta ricuspa, tucuy thutorkancu Jesús contra, “Juchasapapaj wasinpi alojacun” nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zaqueotaj sayarispa, Señorman nerkan: —Señor, tucuy capuyniymanta cuscanta pobrecunaman kopusaj. Pimantapas engañowan suwani chayka, tawa cuti astawan cutichipusaj. ");
INSERT INTO qulNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesús payman nerkan: —Cunan salvación cay wasiman chayamun, cay runapas Abrahampaj miraynillantaj. ");
INSERT INTO qulNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tataj Churenka chincaska runacunata masc'aj salvajtaj jamun. ");
INSERT INTO qulNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jerusalén llajta kayllapiña cachcajtin, Jesuspaj niskanta uyarejcuna yuyarkancu Diospaj gobiernon chayamunantaña. Chayraycu Jesús cay ejemplota nerkan: ");
INSERT INTO qulNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Allin familiamanta uj khapaj runa carkan. Caru llajtaman puriporkan, chaypi gobiernopaj nombramientota jap'ekaj. Chaymanta cutimorkan gobernananpaj. ");
INSERT INTO qulNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Manaraj purichcaspataj, chunca llanc'ajnincunata wajarkan; sapa ujman achqha kolketa korkan. Nerkantaj: ‘Cay kolkewan negociota ruwaychis cutimunaycama’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Quiquin llajtayoj runacunataj payta chejnispa, khepanta comisionta cacharkancu, pay contra ninancupaj: ‘Mana payta munaycuchu gobiernoycupaj’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Chaywanpas payka gobiernopaj nombraska, llajtanman cutimorkan. Chayamuspataj, llanc'ajnincunata wajacherkan, kolke koskanmanta sapa ujmanta jayc'a mirachiskancuta yachananpaj. ");
INSERT INTO qulNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ujnin chayamuspa nerkan: ‘Señor, kolkeyquita mirachini chunca cutitawan.’ ");
INSERT INTO qulNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Gobernajtaj nerkan: ‘May allin llanc'aj canqui. Pisillawan allin ruwaj caskayquiraycu, chunca llajta gobernajta churaskayqui’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ujnintaj chayamuspa nerkan: ‘Señor, kolkeyquita mirachini phichka cutitawan’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Payta nillarkantaj: ‘Kan canqui phichka llajtata gobernaj’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ujcajtaj chayamuspa nerkan: ‘Señor, cay kolkeyqueka; uj pañuelopi wakaychaporkayqui. ");
INSERT INTO qulNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Junt'achej caskayquiraycu kanta manchacuyqui; imaraycuchus mana kanpaj cajta jap'inqui, maypipas mana tarpuskayquimantataj ajthapinqui.’ ");
INSERT INTO qulNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Gobernajtaj nerkan: ‘Kanka mana allin llanc'aj canqui. Parlaskayquiwan juchachayqui. Junt'achej caskayta yacharkanqui, mana nokapaj cajta jap'ekapuskayta, maypipas mana tarpuskaytapas ajthapicapuskayta. ");
INSERT INTO qulNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Koskay kolketa, ¿imaraycutaj bancoman mana churapuwarkanquichu? Cutimuspa kolkeyta miraynintawan orkhocapuyman carkan.’ ");
INSERT INTO qulNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Chaypi cajcunamantaj nerkan: ‘Kechuychis chay kolketa paymanta, koychistaj chunca cuti astawan mirachejman.’ ");
INSERT INTO qulNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Paycunataj nerkancu: ‘Señor, ¡paypajka canña, chunca cuti astawan!’ ");
INSERT INTO qulNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Gobernajtaj nerkan: ‘Niyquichis, pipajchá astawan can, chaymanka astawan koska canka; pipajchari mana canchu, chaymantaka uj chhican capuskanpas kechuska canka. ");
INSERT INTO qulNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Cunanka mana gobernaj canay munajcunata cayman pusamuychis, nokapaj ñaupakeypitaj wañurachiychis.’ ” ");
INSERT INTO qulNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Chayta nispataj, Jesús Jerusalenman purichcallarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Betfagé, Betania llajtacuna kayllaman, Olivos niska loma chimpaman chayaspa, Jesús iscay discipuloncunata cacharkan. ");
INSERT INTO qulNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Nerkantaj: —Puriychis chimpa llajtaman. Chayman yaycuspataj, manaraj cargana malta asnota wataskata tarinquichis. Chay asnota pascaraspa aysamuychis. ");
INSERT INTO qulNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Pipas tapusunquichisman: ‘¿Imapajtaj asnota pascarachcanquichis?’ nispa chayka, payta niychis: ‘Señorninchis necesitan.’ ");
INSERT INTO qulNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Chay iscay discipulocunataj purispa, Jesuspaj niskanman jina tarerkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Asnota pascarachcajtincutaj, dueñoncuna taporkancu: —¿Imaraycutaj pascarachcanquichis? ");
INSERT INTO qulNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Paycuna contestarkancu: —Señorninchis necesitan —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","P'achancuta caronaycuspa, Jesusman apamuspataj, sillaycucherkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesús purichcajtintaj, runacuna p'achancuta ñanpi mast'arkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Olivos loma uraymanña kayllachachcajtincu, tucuy discipuloncuna cusicuywan wajach'acuspa, Diosta alabayta kallarerkancu tucuy milagro ricuskancumanta. ");
INSERT INTO qulNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Nerkancutaj: —¡Alabaska cachun Señorpaj sutinpi jamoj Reyka! ¡Janaj pachapi cajcunaman sonko tiyaycuy cachun! ¡Dios alabaska cachun! ");
INSERT INTO qulNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Chhicataj runacuna chaupipi caj waquin fariseocuna nerkancu: —Yachachej, discipuloyquicunata c'amiy. ");
INSERT INTO qulNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesustaj contestarkan: —Niyquichis, caycuna ch'inyajtincoka, rumicuna wajach'aconkacu. ");
INSERT INTO qulNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jesús Jerusalén kayllaman chayaspa, llajtata ricuspa, Jerusalén runacunamanta wakarkan, ");
INSERT INTO qulNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","nispa: “¡Cunan p'unchayllapipas sonko tiyaycuy kojta entendiwajchis! Cunantaj kancunamanta pacaska cachcan, manataj entendiyta atinquichischu. ");
INSERT INTO qulNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ñac'ariy p'unchaycuna jamonka; chejnicojniyquichiscuna muyuycusunquichis; tucuynejmanta atacasunquichis. ");
INSERT INTO qulNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Cay llajtata thuniyconkacu ñut'u canancama. Ni uj rumillapas uj rumi patapi cankachu. Kancunatataj wañurachisunquichis, Diospaj salvaj jamuskanta mana reparaskayquichisraycu.” ");
INSERT INTO qulNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Chay pasayta, Jesús temploman yaycuspa vendejcunata katerkamuyta kallarerkan. ");
INSERT INTO qulNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Nerkantaj: —Escriturapi nin: ‘Waseyka oración ruwana wasi canka.’ Kancunataj suwacunapaj jutc'unta tucuchipunquichis. ");
INSERT INTO qulNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Sapa p'unchaytaj Jesús templopi yachachichcarkan. Sacerdotecunapaj jefencuna, leymanta yachachejcuna, llajtapaj jefencunapiwan imaynallamantapas payta wañuchiyta munachcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Chaywanpas mana imanayta aterkancuchu, imaraycuchus tucuy runacuna Jesuspaj niskanta allinta uyarichcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Uj p'unchay Jesús templopi runacunaman yachachichcarkan; salvaska canancupaj evangeliota willachcarkan. Jinallapi sacerdotecunapaj jefencuna, leymanta yachachejcuna, llajtapaj jefencunapiwan chayamuspa, nerkancu: ");
INSERT INTO qulNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","—¿Ima autoridadwantaj caycunata ruwanqui? ¿Pitaj cay autoridadta kosunqui? ");
INSERT INTO qulNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesús contestarkan: —Nokapas kancunata ujta tapullaskayquichistaj. Niwaychis: ");
INSERT INTO qulNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Pitaj Juanta cachamorkan bautizananpaj? ¿Dioschu icha runacunachu? ");
INSERT INTO qulNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Paycunapurataj ninacorkancu: “Sichus ‘Dios cachamorkan’ nisunchis chayka, Jesús niwasunchis: ‘¿Imaraycutaj payta mana creerkanquichischu?’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Manallataj niyta atinchischu runacuna payta cachamuskanta, cay runacuna rumiwan chhokaspa wañuchiwachuwan, imaraycuchus paycunaka creencu Dios Juanta cachamuskanta, Diosmanta parlajta.” ");
INSERT INTO qulNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Runacunata manchacuspa, contestarkancu: —Mana yachaycuchu pi Juanta cachamuskanta bautizananpaj. ");
INSERT INTO qulNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesustaj nerkan: —Nillataj nokapas willaskayquichischu ima autoridadwan caycunata ruwaskayta. ");
INSERT INTO qulNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jesús runacunaman ejemplocunawan parlayta kallarispa, nerkan: “Uj runa jallp'anpi achqha uvata tarporkan. Llanc'ajcunaman arrendaycuspataj, caruta puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Uva pallana tiempotaj uj uywaskanta cachamorkan payman tupaskanta apachinancupaj. Llanc'ajcunataj jap'ispa makaspataj, jinapachata cachaporkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Patronka ujtawan cachamullarkantaj. Payta millaycunata nispa, makaspataj, jinapachata cachapullarkancutaj. ");
INSERT INTO qulNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ujtawan cachamullarkantaj. Llanc'ajcunataj yawarllata nanachispa, chajramanta katerkorkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Patronka pensarkan: ‘¿Imatataj ruwasaj? Munaska churiyta cachasaj, ichapas respetankacu’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Llanc'ajcunataj payta ricuspa ninacorkancu: ‘Cayka herenciata jap'enka. Wañuchisunchis, nokanchistaj dueño capusunchis’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ajinata uva chajra jallp'anmanta wijch'orkospa, wañuchiporkancu.” Jesús taporkan: “¿Imanankataj patronri paycunata? ");
INSERT INTO qulNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Purispa, chay llanc'ajcunata wañurachiponka, jallp'antataj wajcunaman arrendanka.” Chayta uyarispa, nerkancu: —¡Jayc'ajpas chayka pasachunchu! ");
INSERT INTO qulNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesús paycunata khawarispa nerkan: —Cay Escriturapi niska ¿imatataj niyta munan?: ‘Wasi ruwajcunapaj millarpariskancu rumeka astawan importante tucun wasipaj.’ ");
INSERT INTO qulNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Pillapas chay rumi pataman urmajka ñut'uska canka; rumichus pipaj patanmanpas urmanka chayka, polvota ruwanka. ");
INSERT INTO qulNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Chayta uyarispataj, sacerdotecunapaj jefencuna leymanta yachachejcunapiwan Jesusta jap'iyta munarkancu chhicapacha. Reparacorkancu paycuna contra cay ejemplo caskanta. Chaywanpas runacunata manchacorkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Cacharkancu khamisiyajcunata, allin runaman rijch'acuspa Jesusta parlakachinancupaj, imallatapas pantaskanta jap'ispa gobernajman entreganancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Paycuna taporkancu: —Yachachej, yachaycu parlaskayqui cierto caskanta. Runapaj parlaskanta mana manchaspa, nitaj runapaj rijch'ayninta khawaspa, verdadta yachachinqui Diospaj munaskanman jina causanancuta. ");
INSERT INTO qulNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Cunan kan niwaycu: ¿Allinchu icha manachu impuesto pagana Roma gobiernoman? ");
INSERT INTO qulNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesustaj paycunapaj iscay uya caskancuta yachaspa, nerkan: ");
INSERT INTO qulNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Apamuwaychis uj kolketa khawanaypaj. ¿Pipaj uyantaj, pipaj sutintaj cay kolkepi escribiska cachcan? Contestarkancu: —Gobernaj Cesarpajta —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesús paycunaman nerkan: —Cesarpaj cajtaka, Cesarman koychis; Diospaj cajtataj, Diosman koychis. ");
INSERT INTO qulNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Runacunapaj ñaupakenpi Jesús allinta contestaskanraycu, mana jap'iyta aterkancuchu. Contestaskanmanta muspharaspa ch'inlla caporkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Waquin saduceocuna Jesusman jamorkancu. Saduceocunaka nincu wañuskamanta causarina mana caskanta. Chayraycu cay ejemplowan Jesusta taporkancu: ");
INSERT INTO qulNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Yachachej, Moisespaj escribiskanpi niwanchis: ‘Uj runa casaracuspa mana wawayoj wañupunman chayka, paypaj wauken viudanwan casaracuchun, ajinapi wañojpaj wawa cananpaj.’ ");
INSERT INTO qulNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Cunantaj kanchis waukentin carkancu. Curajcaj casaracorkan, mana wawayojtaj wañuporkan. ");
INSERT INTO qulNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Katekenpas, ");
INSERT INTO qulNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","quimsacaj waukenpas chay viudawan casaracullarkancutaj; jinataj kanchisnintin chay viudawan casaracorkancu, wañuraporkancutaj. Nitaj maykennincupajpas wawancu carkanchu. ");
INSERT INTO qulNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Khepanta chay warmeka wañupullarkantaj. ");
INSERT INTO qulNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Cunanri, kanchisnintin causarimojtincu, ¿maykenpaj warmintaj cankari? ");
INSERT INTO qulNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesustaj nerkan: —Cay pachapi runacuna casaracuncu, casarachincutaj. ");
INSERT INTO qulNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Chaywanpas causarimuypeka janaj pachaman chayajcunaka mana casaraconkacuñachu, ");
INSERT INTO qulNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","imaraycuchus chaypi manaña wañuy canchu. Angelcuna jina cankacu. Causariskancuraycu Diospaj wawancuna cankacu. ");
INSERT INTO qulNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Quiquin Moisés laurachcaj sach'itamanta escribiskanpi yachachiwanchis wañuskacuna causarinanta. Chay escribiskanpi nin: ‘Señorka Abrahampaj, Isaacpaj, Jacobpajpas Diosnin.’ ");
INSERT INTO qulNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","¡Diostaj mana wañuskacunapaj Diosninchu, manachayri causajcunapaj Diosnin! Diospajka tucuy causachcancu. ");
INSERT INTO qulNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Waquin leymanta yachachejcuna nerkancu: —Allinta ninqui, Yachachej —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Manaña imatapas taporkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús paycunata taporkan: —¿Imaynatataj nincu: ‘Cristoka Davidpaj mirayninmanta’ nispa? ");
INSERT INTO qulNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David quiquin nin Salmo libropi: ‘Señorninchis Dios Señorniyman nerkan: Paña ladoypi tiyaycuy ");
INSERT INTO qulNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","enemigoyquicunata atipanaycama.’ ");
INSERT INTO qulNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Imaynatataj Cristo Davidpaj mirayninmanta canman, sichus David quiquin ‘Señorníy’ nichcajtinri? ");
INSERT INTO qulNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tucuy runa uyarichcajtincu, Jesús discipuloncunaman nerkan: ");
INSERT INTO qulNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Cuidacuychis leymanta yachachejcunamanta. Paycunaman gustan pampacama p'achayoj purina importante runa jina. Munancutaj respetowan saludanata plazacunapi, sinagogapitaj ñaupajpi alabanacaj tiyanata masc'ancu tiyanancupaj. Fiestacunapipas alabanacaj lugarta masc'ancu miqhunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Chaywanpas viudacunamanta tucuy cajnincuta wasincutapas kechuncu. Mana reparachicunancupajtaj unayta oracionta ruwancu. Paycunaka astawan castigota jap'ekankacu.” ");
INSERT INTO qulNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús khawachcarkan ofrenda churanaman khapajcuna kolke churaskancuta. ");
INSERT INTO qulNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ricullarkantaj uj pobre viuda iscay kolkecitota churajta. ");
INSERT INTO qulNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Chhicataj nerkan: —Segurayquichis, cay pobre viudaka astawan churan tucuy ofrenda churajcunamanta nejtenka. ");
INSERT INTO qulNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Imaraycuchus tucuypas puchojnillanta koncu. Cay warmitaj pobre cayninwan causananpaj caj lliuj kolkecitonta churapun. ");
INSERT INTO qulNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Waquin parlachcarkancu templo sumaj jallch'aska caskanmanta, munay rumincunamanta, adornoncunamantawan. Chayta uyarispa, Jesús nerkan: ");
INSERT INTO qulNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Chayamonka p'unchaycuna; chaypi cay tucuy ricuchcaskayquichis ñut'uska canka; ni uj rumipas uj rumi patapi cankañachu. ");
INSERT INTO qulNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Discipuloncuna Jesusta taporkancu: —Yachachej, ¿jayc'ajtaj caycuna pasanka? ¿Imataj señal canka tucuy caycuna junt'acunanpaj? ");
INSERT INTO qulNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús contestarkan: “Cuidacuychis mana pipas engañanasunquichispaj. Achqhayoj jamonkacu, ‘Noka cani Cristo’ nispa, ‘Cunanka jamunan tiempo’ nispa. Kancunaka ama casucuychischu. ");
INSERT INTO qulNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kancuna guerracunamanta revolucioncunamantawan parlajta uyarispa, ama manchacuychischu. Caycunaka cananpuni, chaywanpas manaraj tucucuy chayamunrajchu. ");
INSERT INTO qulNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","“Llajtapura nacionpura makanaconkacu guerrawan. ");
INSERT INTO qulNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Achqha lugarpitaj jallp'a qharcatenka. Cay pachapi yarekaycuna onkoycunapiwan canka, janaj pachapitaj mulljachicoj jinacuna athun señalcunapiwan riqhurenkacu. ");
INSERT INTO qulNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Caycuna manaraj pasachcajtin, jap'isunquichis, ñac'arichisunquichistaj. Sinagogapi juchachasunquichis, carcelman churasunquichis, gobiernocunamantaj entregasunquichis nokapajta caskayquichisraycu. ");
INSERT INTO qulNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ajinapi nokamanta willarayta atinquichis. ");
INSERT INTO qulNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ñaupajtaka ama pensaychischu imatachus contestanayquichista. ");
INSERT INTO qulNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Noka yachayta koskayquichis parlanayquichispaj. Enemigoyquichiscunaka mana atipayta nitaj cutichicuytapas atenkacuchu. ");
INSERT INTO qulNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Chaywanpas tatayquichischus, waukeyquichischus, parienteyquichischus chayri amigoyquichischus entregasunquichis. Waquinniyquichista wañuchisunquichis. ");
INSERT INTO qulNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tucuy runa chejnisunquichis nokapajta caskayquichisraycu. ");
INSERT INTO qulNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Chaywanpas umayquichismanta ni uj chujchallapas chincankachu. ");
INSERT INTO qulNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","¡Pacienciawan creeskayquichispi firme caychis salvacunayquichispaj! ");
INSERT INTO qulNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Jerusalenta soldadocunawan muyuycuskata ricuspa, yachaychis ñut'uskaña cananta. ");
INSERT INTO qulNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Judeapi cachcajcuna lomaman escapacuychis; Jerusalenpi cachcajcuna llojsipuychis; campopi cachcajcuna ama llajtaman cutiychischu. ");
INSERT INTO qulNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Chay castigo p'unchaycunapi tucuy Escrituracuna junt'aconka. ");
INSERT INTO qulNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Ay, llaquiy ari, chay p'unchaycunapi onkoj warmipaj ñuñuchcaj wawayojpajpas! Imaraycuchus cay pachapi athun ñac'ariy canka. Jinallatataj Dios cay llajtayojcunata sinchita castiganka. ");
INSERT INTO qulNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Waquincunaka guerrapi wañonkacu; waquincunatataj presota apankacu waj llajtacunaman. Waj llajtayoj runacuna Jerusalenta dueñochaconkacu, paycunapaj tiemponcu junt'acunancama. ");
INSERT INTO qulNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Intipi, quillapi, koyllurcunapipas señalcuna canka. Cay pacha llajtacunapitaj runacuna ni ima ruwayta atispa manchariconkacu athun kochapaj lak'acuskan oladancunapaj sinchi suenayninwan. ");
INSERT INTO qulNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Runacuna manchacuywan wañunayankacu, cay pachata tucuy ima pasananta pensaspa. Janaj pachapi caj atiycuna qharcatenka. ");
INSERT INTO qulNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Chaymanta Tataj Churinta riconkacu phuyupi jamuchcajta athun atiyninwan glorioso c'anchayninwan. ");
INSERT INTO qulNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Cay tucuy pasayta kallarejtin, animacuychis; callpachacuspa khawariychis; salvaska canayquichisña cachcan.” ");
INSERT INTO qulNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Cayta nillarkantaj: “Higo sach'ata mayken sach'atapas khawariychis. ");
INSERT INTO qulNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Maypachachus raphincuna ch'ijchiramojtin, yachanquichis k'oñi tiempo kayllachamuchcaskantaña. ");
INSERT INTO qulNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ajinallatataj kancunapas cay tucuy ima pasajtin, yachanquichis cutimunay p'unchay kayllallapiña caskanta, Dios gobernananpaj. ");
INSERT INTO qulNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Segurayquichis, tucuy cay imacunaka canka cunan tiempo runa causachcajtinraj. ");
INSERT INTO qulNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Janaj pacha cay pachapas tucuconka; palabraycunacajka mana pasankachu junt'acunancama. ");
INSERT INTO qulNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Cuidacuychis, sonkoyquichista ama khoruyachiychischu viciocunawan, machaycunawan, causayniyquichispaj afanacuycunapiwan, chay juicio p'unchay mana konkay jap'inasunquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Uj trampa jina jamonka cay pachapi caj tucuy runacunaman. ");
INSERT INTO qulNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Listo cachcaychis, tucuy tiempo oracionta ruwaspa, caycunamanta escapanayquichispaj, allinpi riqhurinayquichispaj Tataj Churinpaj ñaupakenpi.” ");
INSERT INTO qulNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","P'unchaypeka Jesús templopi yachachej, tutapitaj Olivos niska lomapi cachcaj. ");
INSERT INTO qulNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tucuy runacunataj tutamantapacha temploman jamorkancu payta uyarinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Kayllaña carkan mana levadurayoj t'anta miqhuna p'unchaycuna, Pascua fiesta sutiyoj. ");
INSERT INTO qulNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Sacerdotecunapaj jefencuna leymanta yachachejcunapiwan runacunata manchachicuspa, masc'arkancu imaynamantapas Jesusta wañuchinapaj. ");
INSERT INTO qulNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Supay Satanás yaycorkan Judas Iscarioteman, ujnin chunca iscayniyoj discipulocunamanta. ");
INSERT INTO qulNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judas purerkan parlaj sacerdotecunapaj jefencunawan, templopi caj waj autoridadcunawan ima, imaynata Jesusta paycunaman entregananpaj. ");
INSERT INTO qulNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Paycunataj cusicorkancu; prometicorkancu kolketa Judasman konancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judastaj chayta aceptaspa, masc'ayta kallarerkan imaynata Jesusta entregananpaj mana runacuna caskan rato. ");
INSERT INTO qulNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Mana levadurayoj t'anta miqhuna p'unchay chayamorkan. Chay p'unchaypi Pascuapaj mut'uta wañuchinancu carkan. ");
INSERT INTO qulNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesús Pedrota Juantawan cacharkan, nispa: —Puriychis, waquichimuychis Pascua cenata miqhunanchispaj. ");
INSERT INTO qulNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Paycunataj taporkancu: —¿Maypitaj waquichinaycuta munanqui? ");
INSERT INTO qulNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús contestarkan: —Llajtaman puriychis. Chaypi uj unu p'uyñu apachcaj runata taripanquichis. Payta katiychis wasinman yaycunancama. ");
INSERT INTO qulNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Wasiyoj runata niychis: ‘Yachachej nin: ¿Nokapaj wasi maypitaj cachcan, discipuloycunawan Pascua cenata miqhunaypaj?’ ");
INSERT INTO qulNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Paytaj uj athun cuartota ricuchisunquichis wasipaj altosninpi, jallch'askataña. Chaypi nokanchispaj waquichimuychis. ");
INSERT INTO qulNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Paycunataj llojsispa, Jesuspaj niskanman jina tariparkancu. Chaypi waquicherkancu Pascua cenata miqhunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Miqhuna hora chayajtintaj, Jesús apostolnincunapiwan mesapi tiyaycorkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jesús nerkan: —¡Maytapuni munarkani cay Pascua cenata kancunawan miqhuyta, manaraj wañuchcaspa! ");
INSERT INTO qulNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Niyquichis, manaña Pascua cenata kancunawan ujtawan miqhusajchu, Diospaj gobiernonpi tucuy ima junt'acunancama. ");
INSERT INTO qulNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Vasota jap'ispa, Diosman graciasta kospa nerkan: —Jap'iychis cayta, sapa ujniyquichis ujyaychis. ");
INSERT INTO qulNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Manaña uvamanta ujyasajchu jakay p'unchay Diospaj gobiernon jamunancama. ");
INSERT INTO qulNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","T'antata jap'ispa, Diosman graciasta kospa parterkan; paycunamantaj korkan: —Cayka cuerpoy, kancunaraycu wañuyman entregaska. Cayta ruwaychis nokamanta yuyaricuspa —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Cena pasayta, t'antata jinallatataj vasota jap'ispa, nerkan: —Cay vasoka mosoj compromiso, kancunaraycu jich'aska, yawarniywan ruwaska. ");
INSERT INTO qulNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Cunanka vendiycuwaj runa nokawan mesapi cachcan. ");
INSERT INTO qulNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tataj Churenka Diospaj niskanman jina purichcan. ¡Ay jakay vendiycojka! ");
INSERT INTO qulNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Chhicataj tapunacuyta kallarerkancu: “¿Pitaj canman chay vendiycoj?” nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Discipuloncuna churanacuchcarkancu maykennincuchus astawan importante canancumanta. ");
INSERT INTO qulNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesús paycunaman nerkan: “Waj nacioncunapi gobernajcuna mandacuncu mana qhuyapayaywan dueñochacuspa; autoridadcunapas quiquin munaskancuta ruwaspa nincu: ‘Allinniyquichispaj ruwachcaycu’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kancuna mana jinachu canayquichis. Kancunamanta astawan importante cajka, sullc'a jina cachun; mandacojtaj sirvej jina cachun. ");
INSERT INTO qulNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Pitaj astawan importanteri? ¿Mesapi tiyaspa miqhojchu chayri miqhunata sirvejchu? ¿Manachu mesapi tiyaspa miqhoj? Chaywanpas noka kancuna uqhupi sirvej jina cachcani. ");
INSERT INTO qulNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Kancunaka nokawanpuni carkanquichis pruebaycunapi. ");
INSERT INTO qulNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Chayraycu derechota kancunaman koyquichis gobernanayquichispaj, imaynatachus Tatay kowan ajinata. ");
INSERT INTO qulNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Gobernajtiy, kancuna wajaska canquichis, mesaypi miqhunayquichispaj ujyanayquichispajpas. Juezcuna jinataj tiyanquichis, Israelpaj chunca iscayniyoj mirayninta juzganayquichispaj.” ");
INSERT INTO qulNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Señor Jesús nillarkantaj: —Simón, Simón, supay Satanás mañan trigota jina kancunata thalanasunquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nokataj mañapuyqui creeyniyqui ama pisinanpaj. Kantaj nokaman cutimuspa, hermanoyquicunata yanapay firme canancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simontaj nerkan: —Señor, listo cani kanwan carcelman purinaypaj, kanwan wañunaypajpas. ");
INSERT INTO qulNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús contestarkan: —Pedro, niyqui, cunanpacha manaraj gallo wajach'acuchcajtin, quimsa cutita negawanqui mana rejsiwaskayquita nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesús paycunata taporkan: —Cacharkayquichis mana saquillayojta, ni kolkeyojta, nitaj abarcayojta. ¿Imallapas piserkasunquichischu? Paycunataj nerkancu: —Ni imapas pisiwancuchu. ");
INSERT INTO qulNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jesustaj nerkan: —Cunancajka, pipajcha can saquillapas kolkepas, chayta apachun. Mana espadayoj cajka, katananta vendispa uj espadata ranticuchun. ");
INSERT INTO qulNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Niyquichis, Escriturapaj cay niskan nokapi junt'acunan: ‘Mana allin ruwaj runacunawan yupaska canan.’ Tucuy nokamanta escribiskacuna junt'acunanpuni. ");
INSERT INTO qulNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Paycunataj nerkancu: —Señor, cay iscay espadaycu can. Jesús contestarkan: —Chayllaña cachun. ");
INSERT INTO qulNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesús llojsispa costumbrenman jina Olivos niska lomaman purerkan. Discipuloncuna katerkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Chay lugarman chayaspa, nerkan: —Oracionta ruwaychis, ama tentacionman urmanayquichispaj —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Paycunamanta uj rumi chhokayman jina carunchacuspa, konkoriycuspataj, oracionta ruwarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Nerkantaj: “Tatáy, munanqui chayka, cay ñac'arinaymanta jarc'away; chaywanpas ama nokapaj munayniychu cachun, manachayri kanpajta.” ");
INSERT INTO qulNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Uj angeltaj janaj pachamanta riqhurerkan, callpachananpaj. ");
INSERT INTO qulNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Sinchi athun ñac'ariyninpi Jesús astawanraj oracionta ruwarkan, jump'iynintaj athuchaj yawar sut'uy jina pampaman urmakarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Sayarispataj, discipuloncunaman purispa puñurachcajta tariparkan, llaquicuywan atipaska caskancuraycu. ");
INSERT INTO qulNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nerkantaj: —¿Imaraycutaj puñuchcanquichis? Jatariychis, oracionta ruwaychis ama tentacionman urmanayquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús parlachcajtinraj, achqha runa chayamorkancu. Chunca iscayniyoj discipuloncunamanta ujnin, Judas sutiyoj, ñaupakencuta jamuchcarkan. Jesusman chimpaycuspataj much'aycorkan. ");
INSERT INTO qulNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesustaj nerkan: —Judas, ¿ujta much'aycuspachu Tataj Churinta vendiycunqui? —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Paywan cajcunataj chay pasaskanta ricuspa, taporkancu: —Señor, ¿atacaycumanchu espadawan? ");
INSERT INTO qulNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ujnin discípulo curaj sacerdotej uywaskanpaj paña lado ninrinta cuchokarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesustaj nerkan: —Dejaychis, chayllaña cachun —nispa. Ninrita llanqhaycuspataj, Jesús alliyachiporkan. ");
INSERT INTO qulNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Sacerdotecunapaj jefencunata, templopi caj autoridadcunata, llajtapaj jefencunatapas, pay apaj jamojcunatawan nerkan: —¿Imaraycutaj jamunquichis espadacunawan c'aspicunawan nokata jap'ej, uj suwapas cayman jinatari? ");
INSERT INTO qulNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Sapa p'unchay kancunawan templopi cachcajtiy, mana jap'iwarkanquichischu. Chaywanpas cunan horayquichis chayamun, tutayajpi caj mandacojtin. ");
INSERT INTO qulNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jesusta jap'ispa curaj sacerdotepaj wasinman aparkancu. Pedrotaj carullamanta katichcarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Chaypi chaupi patiopi ninata jap'ichispa, muyuntinpi tiyaycorkancu, Pedropas tiyaycullarkantaj paycunawan cusca. ");
INSERT INTO qulNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Chaypitaj uj sipas uywaska Pedrota nina kayllapi tiyachcajta ricuspa, allinta khawarispa nerkan: —Caypas Jesuswan cachcarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pedrotaj negarkan nispa: —Warmi, mana payta rejsinichu. ");
INSERT INTO qulNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Juch'uy ratomanta, wajñataj ricuspa nerkan: —Kanpas paycunamanta canqui. Pedrotaj contestarkan: —Khari, mana nokachu cani. ");
INSERT INTO qulNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Uj hora pasaymanta, wajñataj nillarkantaj: —Ciertopuni cayka Jesuswan cachcarkan. Galileamanta canpas. ");
INSERT INTO qulNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pedrotaj nerkan: —Khari, mana yachanichu imamanta niskayquita. Chhicapacha Pedro parlachcajtillanraj, gallo ujta wajach'acorkan. ");
INSERT INTO qulNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Señorka cutirispa Pedrota khawarerkan. Pedrotaj yuyarerkan Señorpaj niskanmanta: “Cunan, manaraj gallo wajach'acuchcajtin, quimsa cutita negawanqui” nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pedrotaj jawaman llojsipuspa, sonko nanayta wakarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jesusta khawajcunataj asipayaspa burlacuspa, makarkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ñawincunata tapaycuspa, taporkancu: —¿Pitaj makasunqui? ¡Niwaycu! ");
INSERT INTO qulNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Wajcunatawan nispa, insultarkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pakariyachcajtinña, Athun Asambleapi llajtapaj jefencuna, sacerdotecunapaj jefencuna, leymanta yachachejcunapiwan tantacorkancu. Chayman Jesusta aparkancu. Taporkancutaj: ");
INSERT INTO qulNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Niwaycu, ¿kan, Cristochu canqui? Paytaj nerkan: —Arí, niyquichisman chayka, mana creewanquichismanchu. ");
INSERT INTO qulNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Tapuyquichisman chaypas, mana contestawanquichismanchu. ");
INSERT INTO qulNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Cunanmantapacha Tataj Churenka tiyachcanka tucuy atiyniyoj Diospaj paña ladonpi. ");
INSERT INTO qulNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Chhicari tucuynincu taporkancu: —¿Ajinaka kan, Diospaj Churinchu canqui? Jesús contestarkan: —Kancuna quiquiyquichis ninquichis noka caskayta. ");
INSERT INTO qulNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Paycunataj nerkancu: —¿Imapajñataj astawan testigocuna munacuncu? Nokanchis quiquin uyarinchis paypaj siminmanta. ");
INSERT INTO qulNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tucuynincu sayarispa, Jesusta Pilatoman aparkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Pilatopaj ñaupakenpi juchachayta kallarerkancu nispa: —Cay runata taripaycu nacionniycupi runacunata pituchcajta. Manataj munanchu impuestota gobiernoman paganata. Pay quiquintaj ‘Cristo Rey cani’ nin. ");
INSERT INTO qulNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato taporkan: —¿Kanchu judiocunapaj Reynin canqui? Jesustaj nerkan: —Arí, kan ninqui —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilatotaj sacerdotecunapaj jefencunaman runacunamanpiwan nerkan: —Mana ima juchatapas tarinichu cay runapi. ");
INSERT INTO qulNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Paycunataj astawan atipacorkancu nispa: —Yachachiynincunawan tucuy runacunata pituchin, Galileamanta kallarispa tucuy Judeacama. ");
INSERT INTO qulNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Cayta uyarispa, Pilato taporkan Galileamantachus caskanta. ");
INSERT INTO qulNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","“Arí, Galileamanta” nejtincutaj, Herodespajman cacharkan. Chay Galilea gobernaj chay p'unchaycuna Jerusalenpi cachcarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jesusta ricuspa, Herodes cusicorkan. Achqha tiempoña ricuyta munarkan, Jesús milagro ruwaskancunamanta uyariskanraycu. Paypas milagro ruwachcajta ricuyta munarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Tucuy imata tapojtin, Jesús mana imatapas contestarkanchu. ");
INSERT INTO qulNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Chayllapitaj sacerdotecunapaj jefencuna leymanta yachachejcunapiwan cachcarkancu sinchita juchachaspapuni. ");
INSERT INTO qulNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Chhicari Herodes soldadoncunawan millarpayarkancu. Reyta jina allin fino p'achata churaycuspa, burlacorkancu. Chaymantataj Pilatoman cutichiporkan. ");
INSERT INTO qulNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Chay p'unchay Pilato Herodeswan amigo caporkancu. Ñaupajtaj enemigontin carkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato sacerdotecunapaj jefencunata, autoridadcunata, llajtayojcunatawan tantaycorkan. ");
INSERT INTO qulNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Nerkantaj: —Kancuna cay runata apamuwanquichis, ‘Runacunata pituchcan’ nispa. Nokataj kancunapaj ñaupakeyquichispi tapuspa, ni ima juchata tarinichu juchachaskayquichismanta. ");
INSERT INTO qulNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nillataj Herodespas juchata tarinchu; chayraycu cutichimpuwan. Ña ricunquichisña, mana ni imatapas ruwanchu wañuchinapaj jinaka. ");
INSERT INTO qulNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Jasut'isaj, chaymantataj cacharipusaj. ");
INSERT INTO qulNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Sapa Pascuapi Pilato uj presota cacharej, runacunata agradanapaj. ");
INSERT INTO qulNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Chayraycu, tucuynincu wajach'acuyta kallarerkancu: —¡Ama chaytaka cachariychu! ¡Barrabasta cacharipuy! —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabastataj presochaskacu chay llajtapi pitucuskanmanta, uj runata wañuchiskanmantapiwan. ");
INSERT INTO qulNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato Jesusta cacharipuyta munaspapuni, ujtawan runacunaman parlarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Paycunataj astawan wajach'acorkancu nispa: —¡Chacataska cachun, chacataska cachun! ");
INSERT INTO qulNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Quimsa cuticama Pilato paycunata nerkan: —¿Imatapunitaj mana allinta ruwanri? Mana ni imata tarinichu wañuchinapaj jinaka. Jasut'ispa, cacharipusaj. ");
INSERT INTO qulNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Paycunataj wajach'acuchcallarkancupuni chacatachinancupaj. Sinchita wajach'acuskancuwan munaskancuta uyarichicorkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilato mandarkan mañaskancuman jina. ");
INSERT INTO qulNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ajinaka ajllaskancu Barrabasta cachariporkan, Jesustataj entregaporkan chacataska cananpaj. Barrabastaj runacunata pituskanraycu runata wañuchiskanraycu carcelpi cachcarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jesusta chacatanancupaj apachcaspataj, Cirenemanta Simón sutiyoj runata jap'erkancu campomanta jamuchcajtin; paywan cruzta apacherkancu Jesuspaj khepanta. ");
INSERT INTO qulNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Achqha runa achqha warmicunapiwan katerkancu wakaspa, llaquicuymanta kaparispa Jesusmanta. ");
INSERT INTO qulNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesustaj khawarispa, nerkan: —Jerusalén warmicuna, ama nokamanta wakaychischu; manachayri kancuna quiquiyquichismanta wawayquichiscunamantawan wakaychis. ");
INSERT INTO qulNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Jamonka p'unchaycunaka, chaypi nenkacu: ‘Cusicuyniyoj mana wawayoj cay atejcuna, mana onkojyajcuna, mana ñuñuchejcunapas.’ ");
INSERT INTO qulNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Chhica runacunaka orkocunata nenkacu: ‘¡Nokaycu pataman urmaycamuwaycu!’ Lomacunatataj nenkacu: ‘¡Pacaycuwaycu!’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","¡Causachcaj sach'awan cay tucuy imata ruwaspaka, imatarajchá ruwankacu ch'aqui wañuska sach'awanka! ");
INSERT INTO qulNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Apallarkancutaj iscay mana allin ruwajcunata Jesustawan chacatanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Calavera sutiyoj lugarman chayaspa, Jesusta chacatarkancu iscay mana allin ruwajcunatawan, ujta pañannejpi ujtataj llok'ennejpi. ");
INSERT INTO qulNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesús nerkan: —Tatáy, juchancuta perdonapuy; mana yachancuchu imatachus ruwaskancuta. Soldadocunataj paypaj p'achanta partinacunancupaj sorteachcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Runacunataj khawachcarkancu. Autoridadcunantin Jesusmanta burlacuspa, nerkancu: —Wajcunata salvarkan; cunanka pay quiquin salvacuchun, Diospaj ajllaskan Cristo caspaka. ");
INSERT INTO qulNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soldadocunapas burlacorkancu, c'allcu vinota ujyachispa. ");
INSERT INTO qulNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Nerkancutaj: —¡Judiocunapaj Reynin canqui chayka, salvacuy kan quiquiyqui! ");
INSERT INTO qulNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Cruz puntapi uj escribiskata churarkancu. Chaypi nerkan: “Cayka Judiocunapaj Reynin” nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ujnin mana allin ruwaj chacataska insultarkan: —¡Kan Cristo canqui chayka, salvacuy, nokaycutapas salvallawaycutaj! —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ujnintaj payta c'amerkan: —¿Manachu Diosta manchacunqui, kanpas quiquin castigopi cachcaspa? ");
INSERT INTO qulNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nokanchiska tucuy razonwan ñac'arichcanchis; jucha ruwaskanchismanta justo castigota pagachcanchis. Caycajri ni ima juchata ruwarkanchu. ");
INSERT INTO qulNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nillarkantaj: —Jesús, gobernayta kallarispa, yuyaricuway nokamanta. ");
INSERT INTO qulNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesustaj contestarkan: —Segurayqui, cunanpacha nokawan paraisopi canqui. ");
INSERT INTO qulNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Chaupi p'unchaymanta quimsa hora tardecama, tucuy cay pacha Tutayaycorkan. ");
INSERT INTO qulNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Intipas tutayaycorkan. Templopi athun cortina iscayman lliq'icorkan, janajmanta urayman. ");
INSERT INTO qulNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesús alto vozwan wajach'acorkan nispa: —¡Tatáy, kanman espirituyta koyqui! Chayta nispataj, wañuporkan. ");
INSERT INTO qulNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Capitantaj caycunata ricuspa Diosta alabarkan: —Ciertopuni, cay runaka mana juchayoj. ");
INSERT INTO qulNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tucuy chaypi caj runacuna chayta ricuspa, puriporkancu, llaquicuymanta pechoncuta tacacuspa. ");
INSERT INTO qulNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jesuspaj amigoncuna Galileamantapacha purej warmicunapiwan chaypi cachcarkancu, carumanta chay pasaskancunata khawaspa. ");
INSERT INTO qulNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Uj allin justo runa carkan, José sutiyoj, Judeapi caj Arimatea llajtamanta. Judiocunapaj Athun Asambleanmanta ujnin carkan. ");
INSERT INTO qulNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Cay Joseka Diospaj gobiernonta suyachcarkan. Mana payman allinchu yuyacorkan Athun Asambleapaj ruwaskancuna. ");
INSERT INTO qulNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Pilatopajman purispa, Jesuspaj cuerponta mañarkan. ");
INSERT INTO qulNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Cruzmanta apakaspa, fino sabanawan p'istuycuspa, kakapi jutc'uska sepulturaman churaycorkan, manaraj aya churaska sepulturaman. ");
INSERT INTO qulNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Pascua waquichina niska p'unchay carkan, samana p'unchay kallaricuchcarkanña. ");
INSERT INTO qulNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galileamanta Jesuswan purej warmicuna purispa sepulturata ricorkancu, imaynatachus Jesuspaj cuerponta churaskancutawan. ");
INSERT INTO qulNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Wasincuman cutipuspa, sumaj k'apayniyoj perfumecunata jawinacunatawan waquicherkancu. Samana p'unchaypi warmicunaka samararkancu leyman jina. ");
INSERT INTO qulNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Semana kallariy p'unchaypi sinchi tutamanta warmicuna sepulturaman cuterkancu, sumaj k'apayniyoj waquichiskancuta apaspa. ");
INSERT INTO qulNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Chayaspataj, sepultura tapaska rumita waj ladopi tariparkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Yaycuspataj, Jesuspaj cuerponta mana tariparkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Manchariska, ni ima ruwayta aterkancuchu. Ricorkancu iscay kharicunata paycunawan cusca sayachcajta, c'anchachcaj p'achayojta. ");
INSERT INTO qulNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Mancharicuspa pampacama c'uñuycojtincutaj, chay kharicuna nerkancu: —¿Imaraycutaj wañuskacuna uqhupi causachcajta masc'achcanquichis? ");
INSERT INTO qulNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Mana caypichu, causarimpunña. Yuyaricuychis Galileapiraj cachcaspa kancunaman niskanmanta. ");
INSERT INTO qulNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Pay nerkan: ‘Tataj Churenka juchasapacunaman entregaska canka chacatanancupaj, quimsa p'unchaymantataj causarimonka’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Paycuna Jesuspaj niskanmanta yuyaricorkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Sepulturamanta cutipuspataj, willarkancu chunca ujniyoj apostolnincunaman tucuy wajcunamanpas. ");
INSERT INTO qulNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Cay willacoj warmicunataj carkan: María Magdalena, Juana, Santiagopaj maman María, waj warmicunapiwan. ");
INSERT INTO qulNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Paycunapaj niskan sonsera yuyacorkan apostolcunaman, manataj creeyta munarkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Chaywanpas Pedro sepulturaman phawarkan. Khawaycuspa, sabanacunallata ricorkan. Wasiman cutispa, cay pasaskanmanta muspharkan. ");
INSERT INTO qulNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Chay p'unchaypacha iscay apostolcuna Emaús niska llajtaman purerkancu, chunca ujniyoj kilómetro jina carupi Jerusalenmanta. ");
INSERT INTO qulNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Purichcaspataj tucuy ima pasaskanmanta parlachcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Parlachcajtincu, Jesús quiquin paycunaman chimpaycuspa, paycunawan cusca purerkan. ");
INSERT INTO qulNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Jesusta ricuspapas, mana reparacorkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesús taporkan: —¿Imamantataj parlachcanquichis purej jinari? Llaquiska sayaycorkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ujnin, Cleofas sutiyoj, contestarkan: —¿Kan sapallachu canqui, Jerusalenpi cachcaspa mana yachaj cay p'unchaycunapi ima pasaskanta? ");
INSERT INTO qulNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesustaj taporkan: —¿Imataj pasanri? —nispa. Paycunataj nerkancu: —Nazaret llajtayoj Jesuska ruwayninpi parlayninpipas uj atiyniyoj profeta carkan Diospaj ñaupakenpi tucuy runapaj ñaupakenpipas. ");
INSERT INTO qulNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Sacerdotecunapaj jefencuna autoridadniycupiwan payta entregarkancu wañuchinancupaj, chacatanancupajpiwan. ");
INSERT INTO qulNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nokaycu suyarkaycu pay Israel nacionniycuta librananta. Cay tucuy ima pasaskanka quimsa p'unchayña pasapun. ");
INSERT INTO qulNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Chaywanpas nokaycu uqhumanta waquin warmicuna niskancuwan mulljawancu. Pakariyamuchcayta paycuna sepulturaman purerkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Jesuspaj cuerponta mana tarispataj, wasiman cutimuspa willawancu angelcuna paycunaman riqhuriskancuta: ‘Jesús causachcan’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Waquinnin nokaycumanta sepulturaman purispa, taripaskacu imaynatachus warmicuna niskanman jina. Chaywanpas Jesuscajta mana ricuncuchu. ");
INSERT INTO qulNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jesustaj paycunaman nerkan: —¡Ay, llaquina canquichis, mana yuyayniyojcuna, mana creey atejcuna tucuy profetacunapaj niskancuta! ");
INSERT INTO qulNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Manachu Cristori caycunata sufrinan carkan, manaraj glorioso gobiernonman yaycuchcaspa? ");
INSERT INTO qulNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Chaypachataj Escriturapi paymanta niskancunata sut'inchayta kallarerkan, Moisespaj libroncunamanta kallarispa tucuy profetacunapaj libroncunacama. ");
INSERT INTO qulNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Emaús llajtaman chayaspataj, Jesús pasapojman jina tucorkan. ");
INSERT INTO qulNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Paycunataj rogarkancu: —¡Quedacuy nokaycuwan! Ña tardeña, tutayachcanña —nispa. Jesustaj yaycorkan paycunawan quedacoj. ");
INSERT INTO qulNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Mesapiña tiyachcajtincu, Jesús t'antata jap'ispa, Diosman graciasta kospa partispataj, jaywarkan paycunaman. ");
INSERT INTO qulNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Chhicapacha Jesús caskanta reparaspa rejserkorkancu, paytaj chincarkaporkan. ");
INSERT INTO qulNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ninacorkancutaj: —¿Manachu sonkonchis cuyurerkan ñanpi parlapayachcawajtinchis, Escrituracunata sut'inchachcawajtinchispas? ");
INSERT INTO qulNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Chaypacha jatarispa, Jerusalenman cutirerkancu. Chaypitaj chunca ujniyoj apostolcunata paycunawan cajcunatapiwan tantaskata tariparkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Apostolcuna nerkancu: —Ciertotapuni Señor causarimpuska, Simonman riqhurin. ");
INSERT INTO qulNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Paycunataj iscaynincu willarkancu ñanpi ima pasaskanta, imaynatachus Jesús t'antata partejtin rejsiskancutawan. ");
INSERT INTO qulNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Chaycunamanta parlachcajtincuraj, Jesús, chaupincupi sayachcaj, riqhurerkan. Saludaycorkantaj: —Kancunapaj sonko tiyaycuy cachun —nispa. ");
INSERT INTO qulNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Paycuna sinchita mancharicorkancu, almata ricuskancuta yuyaspa. ");
INSERT INTO qulNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jesús paycunaman nerkan: —¿Imaraycutaj mancharicunquichis, sonkoyquichispitaj chay jinata iscayrayachcanquichis? ");
INSERT INTO qulNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Khawariychis maquiycunata chaquiycunatapas; noka quiquiy cani. Llanqhaycuwaychis, ricuwaychis. Almaka mana aychayojchu, ni tulluyojchu. Kancuna ricunquichis, nokapajka can. ");
INSERT INTO qulNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Chayta nispataj, maquincunata chaquincunatawan ricucherkan. ");
INSERT INTO qulNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Paycunataj cusicuymanta musphaymantawan manaraj creerkancuchu. Jesús taporkan: —¿Capusunquichischu imallapas miqhunapaj? ");
INSERT INTO qulNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Jaywarkancu challwa cancaskata abeja misq'itawan. ");
INSERT INTO qulNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jap'ispataj miqhorkan ñaupakencupi. ");
INSERT INTO qulNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nerkantaj: —Kancunawanraj cachcaspa, nerkayquichis Moisespaj, profetacunapaj, salmocunapajpiwan nokamanta escribiskan junt'acunan caskanta. Chayka nokapi junt'acunña. ");
INSERT INTO qulNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Chhicari Escrituracunata sut'incharkan allinta entendinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nerkantaj: —Escribiskaman jina Cristoka wañunan, quimsa p'unchaymantataj causarimunan carkan. ");
INSERT INTO qulNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Cristopaj sutinpi Jerusalenmantapacha kallarispa, tucuy llajtacunaman willarana, Diosman cutiricunancupaj, juchancu perdonaska cananpaj. ");
INSERT INTO qulNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Caycunamanta kancuna testigocuna canquichis. ");
INSERT INTO qulNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Tataypaj prometicuskanta noka kancunaman cachamusaj. Kancunaka cay Jerusalén llajtallapi quedacuychis, janaj pachamanta atiyta jap'ekanayquichiscama. ");
INSERT INTO qulNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jesús discipuloncunata pusarkan llajta jawanejman, Betania llajtacama. Maquincunata okharispataj bendicerkan. ");
INSERT INTO qulNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Bendicichcaspa jina, okharicaporkan, janaj pachaman puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Paycunataj Jesusta adoray pasayta, sinchi cusiska Jerusalenman cutiporkancu. ");
INSERT INTO qulNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Templollapipuni cachcarkancu Diosta alabaspa. Ajina cachun.");
INSERT INTO qulNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kallariypeka Palabra carkanña, Palabrataj Dioswan carkan, chay Palabrataj Dios carkan. ");
INSERT INTO qulNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kallariypeka pay Dioswan cachcarkan. ");
INSERT INTO qulNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Payninta Dios tucuy imacunata ruwarkan. Mana imapas ruwaskachu carkan mana paywanka. ");
INSERT INTO qulNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Causayka paypi cachcarkan. Chay causaytaj c'anchay carkan runacunapaj. ");
INSERT INTO qulNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Chay c'anchay laja tutayajpi c'anchan, laja tutayajtaj mana wañuchiyta atinchu. ");
INSERT INTO qulNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Uj runa carkan Juan sutiyoj, Diospaj cachamuskan, ");
INSERT INTO qulNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","c'anchaymanta willaj, paypaj niskanraycu c'anchaypi tucuy creenancupaj. ");
INSERT INTO qulNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Mana Juanchu c'anchay carkan, manachayri cachamuska carkan c'anchaymanta willananpaj. ");
INSERT INTO qulNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tucuy runata c'anchaycoj, verdad c'anchay cay pachaman jamorkan. ");
INSERT INTO qulNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Chay Palabra cay pachapi cachcarkan. Payninta Dios cay pachata ruwarkan chaywanpas, cay pachapi caj runacuna mana rejserkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Paypaj cajcunaman jamorkan, paypajta cajcunataj mana jap'ekarkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Chaywanpas picunachus Jesusta jap'ekancu paypitaj creencu, chaycunaman Dios derechota kon paypaj wawancuna canancupaj. ");
INSERT INTO qulNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Diospaj wawancuna cancu, mana runamanta naciskallachu, nitaj runacunapaj munayninmantachu, manachayri Diospaj munayninman jina. ");
INSERT INTO qulNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Chay Palabra runaman tucorkan, nokaycu uqhupitaj causachcarkan, munacuywan verdadwan junt'a. Paypi Diospaj glorioso cayninta ricorkaycu. Chay Diospaj cayninta Dios Tatamanta jap'ekarkan ch'ulla Churin caskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan paymanta willarkan: “Caymi jakay pimantachus nerkayquichis: ‘Khepayta jamuchcan nokamanta nejtin astawan importante, imaraycuchus manaraj cachcajtiy, payka carkanñapuni.’ ” ");
INSERT INTO qulNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Paypaj athun khapaj cayninmanta tucuyninchis achqha bendicioncunata jap'ekanchis paypaj favorninman jina. ");
INSERT INTO qulNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisesninta leyka koska carkan; Diospaj munacuynin verdadnintaj Jesucristonta chayamuwanchis. ");
INSERT INTO qulNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mana pipas Diosta jayc'ajpas ricorkancuchu. Diospaj ch'ulla Churin, Dios Tatawan sinchi ujchaska causaj, pay rejsichiwanchis. ");
INSERT INTO qulNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusalenmanta judiocuna sacerdotecunata levitacunatawan cacharkancu Juanta tapunancupaj “¿Pitaj kan canqui?” nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Paytaj sut'inta willarkan: —Mana Cristochu cani —nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tapullarkancutaj: —¿Pitaj canquiri? ¿Profeta Eliaschu? Juantaj nerkan: —Mana Eliaschu cani. Paycuna astawan taporkancu: —Uj profeta jamunan carkan, ¿chaychu canqui? Juantaj contestarkan: —Mana —nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nerkancutaj: —¿Pitaj chhica canquiri? Nokaycuta cachamuwajniycuman willanaycu. ¿Imatataj ninqui kan quiquiyquimanta? ");
INSERT INTO qulNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juantaj contestarkan: —Profeta Isaiaspaj niskanman jina ch'usaj lugarpi wajach'acoj voz cani: ‘Señorpaj sonkoyquichista waquichiychis, recto ñanta jina’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Chay runacunataka fariseocuna cacharkancu Juanwan parlajta. ");
INSERT INTO qulNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Tapullarkancutaj: —Kan mana Cristo, ni Elías, ni jamunan carkan chay profeta caspari, ¿imaraycutaj bautizanqui? ");
INSERT INTO qulNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan contestarkan: —Noka unuwan bautizani. Chaywanpas kancuna uqhupi cachcan uj mana rejsiskayquichis. ");
INSERT INTO qulNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Payka khepayta jamuchcan. Paypaj ñaupakenpeka ni imapaschu cani, abarcanta pascaranallaypajpas. ");
INSERT INTO qulNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Tucuy cay pasarkan Betania lugarpi, Jordán mayu chimpapi, Juanpaj bautizachcaskanpi. ");
INSERT INTO qulNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","K'ayantin Juan Jesusta ricorkan payman chimpaycuchcajta. Nerkantaj: “¡Khawariychis, caymi Diospaj Corderonka, runacunapaj juchanta kechoj! ");
INSERT INTO qulNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Paymanta nerkani: ‘Khepayta jamuchcan, chaywanpas nokamanta nejtin astawan importante, imaraycuchus manaraj cachcajtiy, pay carkanñapuni.’ ");
INSERT INTO qulNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Noka quiquiy mana yacharkanichu pi caskanta. Chaywanpas unuwan bautizachcani Israel runacuna payta rejsinancupaj.” ");
INSERT INTO qulNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Juan willallarkantaj: “Janaj pachamanta Santo Espirituta palomata jina uraycamuchcajta ricorkani. Jesuspaj umanpi tiyaycorkan. ");
INSERT INTO qulNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Noka manaraj yacharkanichu pi caskanta. Unuwan bautizanaypaj cachamuwaj Dios niwarkan: ‘Pipaj patanmanchus Santo Espíritu urakamuspa tiyayconka, chaymi Santo Espirituwan bautizajka.’ ");
INSERT INTO qulNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nokaka ricuniña; testigo cani payka Diospaj Churin caskanmanta.” ");
INSERT INTO qulNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","K'ayantintaj ujtawan Juan chayllapitaj cachcarkan iscay discipuloncunawan. ");
INSERT INTO qulNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jesusta pasajta ricuspa, Juan nerkan: —¡Khawariychis, caymi Diospaj Corderonka! ");
INSERT INTO qulNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Juanpaj iscay discipuloncuna chayta uyarispa, Jesuswan puriporkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesús khepanta khawarispa, paywan purichcaskancuta ricuspa, paycunata taporkan: —¿Imatataj masc'achcanquichis? Paycunataj nerkancu: —Yachachej, ¿maypitaj tiyanqui? ");
INSERT INTO qulNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesustaj contestarkan: —Jamuychis ricoj. Purispa, maypi tiyaskanta ricorkancu. Paywantaj ch'isiyaycorkancu, tawa hora jina tardeña caskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Juanta uyarispa, Jesuswan purejcunamanta ujnin carkan Andrés, Simón Pedropaj wauken. ");
INSERT INTO qulNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Chaypacha Andreska purerkan wauken Simonta masc'aj. Payman nerkan: —Mesiasta tariycu. (Mesías niyta munan: Cristo.) ");
INSERT INTO qulNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Chaypacha Andreska Simonta Jesusman pusarkan. Jesús ricuspa, payta nerkan: —Kan canqui Simón, Juanpaj churin. Cunantaj Cefas sutiyqui canka. (Cefas niyta munan: Pedro.) ");
INSERT INTO qulNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","K'ayantin, Jesús Galileaman puriyta munaspa, Felipewan tuparkan. Paytataj nerkan: —Nokawan puriy. ");
INSERT INTO qulNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Cay Felipeka Betsaida llajtamanta carkan, Andrespas Pedropas chayllamantataj. ");
INSERT INTO qulNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipe purerkan Natanaelta masc'aj. Payta nerkan: —Josepaj churin, Nazaret llajtayoj Jesusta tariycu. Paymanta Moisés escriberkan leypeka, ajinallatataj profetacunapas. ");
INSERT INTO qulNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael nerkan: —¿Nazaret llajtamantari llojsinmanchu ima allinllapas? Felipe payta nerkan: —Jamuy, ricunqui. ");
INSERT INTO qulNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesús Natanaelta payman kayllaycuchcajta ricuspa, nerkan: —Cayka uj verdadero Israel runa jamuchcan. Paypi ni ima engaño canchu. ");
INSERT INTO qulNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael payta taporkan: —¿Imaynatataj rejsiwanquiri? Jesús contestarkan: —Manaraj Felipe kanta wajachcajtin, ricorkayqui higo sach'a urapi cachcajtiyqui. ");
INSERT INTO qulNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael nerkan: —¡Yachachej, kan Diospaj Churin canqui, Israelpaj Reynin! ");
INSERT INTO qulNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús contestarkan: —¿’Higo sach'a urapi cachcajtiyqui ricorkayqui’ niskayraycullachu creewanqui? Astawan athun imaymanacunataraj ricunqui. ");
INSERT INTO qulNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jesús nillarkantaj: —Segurayquichis, kancuna ricunquichis janaj pachata quicharaskata, Tataj Churin pataman Diospaj angelnincunata urakamuchcajta llojsichcajta. ");
INSERT INTO qulNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Quimsa p'unchay pasayta, uj casamiento carkan Galilea provinciapi caj Caná llajtapi. Chaypi Jesuspaj maman cachcarkan. ");
INSERT INTO qulNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesús discipuloncunapiwan purillarkancutaj, casamientoman wajaska. ");
INSERT INTO qulNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Vino tucucojtin, Jesuspaj maman payman nerkan: —Vino manaña capunchu. ");
INSERT INTO qulNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesustaj payta nerkan: —Warmi, ¿imaraycutaj cayta niwanqui? Horay manaraj chayamunchu. ");
INSERT INTO qulNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mamantaj sirvientecunaman nerkan: —Ruwaychis tucuy ima paypaj niskanta. ");
INSERT INTO qulNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Sojta p'uyñucuna, rumimanta ruwaska, chaypi cachcarkan, judío runacunapaj unu churanan limpiochacuna costumbre ruwanancupaj. Sapa p'uyñupi phichka chuncamanta kanchis chunca litrocama unu yaycorkan. ");
INSERT INTO qulNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús sirvientecunaman nerkan: —Unuta junt'achiychis cay p'uyñucunaman. Paycunataj junt'acherkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jesús paycunata nerkan: —Cunanka uj chhicanta orkhoychis. Fiestamanta encargaskaman apaychis. Jinata ruwarkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Encargaskataj unumanta ruwaska vinota mallirerkan, mana yachaspa maymanta llojsimuskanta. Chay sirvientecunalla yacharkancu unumanta orkhoskancuta. Ajinata encargaskaka noviota wajaspa, ");
INSERT INTO qulNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","nerkan: —Tucuy runa sumaj vinotaka ñaupajta sirvincu. Jayc'ajchus wajaskacuna achqhataña ujyancu, chhicaraj ordinario vinotaka sirvincu. Kancajtaj sumaj vinota wakaychanqui cunancama. ");
INSERT INTO qulNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesús cay milagrota ruwarkan Galilea provinciapi caj Caná llajtapi. Ajinamanta Jesús glorioso cayninta ricucherkan, discipuloncunataj paypi creerkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Chay pasaymanta, Jesús Capernaum llajtaman purerkan mamanwan, waukencunawan, discipuloncunapiwan. Chaypi carkancu iscay p'unchayta. ");
INSERT INTO qulNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Judiocunapaj Pascua fiestan kayllachamuchcajtinña, Jesús Jerusalenman purerkan. ");
INSERT INTO qulNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Temploman yaycuspa, tariparkan bueycunata, ovejacunata, palomacunatawan vendejcunata, kolke cambiana puestoncupi tiyachcajcunatapiwan. ");
INSERT INTO qulNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ricuspataj, Jesús lazomanta bajtanata ruwaspa, tucuynincuta templomanta katerkorkan ovejancunawan bueynincunatapiwan cusca. Kolke cambiajcunapaj kolkencutataj pampaman wijch'orkan, mesancutataj tijrararkan. ");
INSERT INTO qulNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Paloma vendejcunata nerkan: —¡Chaycunata caymanta orkhoychis! Tataypaj wasintaka ama negocio wasiman tucuchiychischu. ");
INSERT INTO qulNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Chhicaraj discipuloncunaka yuyarerkancu Escriturapaj niskanta: “Wasiyquimanta phiñacuyniywan wañuniraj.” ");
INSERT INTO qulNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Judiocunataj taporkancu: —¿Ima señaltataj ricuchiwanquichis cayta ruwanapaj autoridadniyoj caskayquita? ");
INSERT INTO qulNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús contestarkan: —Cay templota urmachinquichis chayka, quimsa p'unchaymanta sayarichisaj. ");
INSERT INTO qulNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Judiocunataj nerkancu: —Tawa chunca sojtayoj watapi cay temploka ruwacorkan. ¿Kantajchu quimsa p'unchaypi sayarichiwaj? ");
INSERT INTO qulNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jesús templomanta parlaspaka, quiquin cuerponmanta nerkan. ");
INSERT INTO qulNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jesús wañuskanmanta causarimojtinña, discipuloncuna chay niskanmanta yuyarerkancu. Ajinapi Escriturata Jesuspaj palabrancunatawan creerkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesús Jerusalenpiraj Pascua fiestapi cachcajtin, achqhayoj paypi creerkancu, milagrocuna ruwaskanta ricuspa. ");
INSERT INTO qulNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Chaywanpas Jesús mana paycunapi confiacorkanchu, imaraycuchus tucuynincuta rejserkan. ");
INSERT INTO qulNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Mana necesitarkanchu ni pipas willananta ni imata runacunamanta, imaraycuchus pay quiquin runacunapaj sonkonta yacharkan. ");
INSERT INTO qulNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Uj fariseo, Nicodemo sutiyoj, carkan, judiocuna uqhupi importante. ");
INSERT INTO qulNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Tutapi Jesusman jamuspa, nerkan: —Yachachej, yachaycu Dios cachamuskasunquita yachachinawayquichispaj. Mana pipas chay milagrocunata ruwayta atinmanchu kan jina, Dios paywan mana cajtenka. ");
INSERT INTO qulNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesús payta nerkan: —Segurayqui, pipas mana mosojmanta nacejka Diospaj gobiernonta mana ricunmanchu. ");
INSERT INTO qulNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemo taporkan: —¿Imaynatataj uj runa mosojmanta nacinman machuña caspari? ¿Ujtawan yaycunmanchu mamanpaj wijsanman, mosojmanta nacinanpaj? ");
INSERT INTO qulNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús contestarkan: —Segurayqui, pipas mana unumanta Espiritumantawan nacinchu chayka, mana Diospaj gobiernonman yaycuyta atenkachu. ");
INSERT INTO qulNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Runa tatacunamanta nacejka runa causayniyojlla. Espiritumanta nacejka espíritu causayniyoj. ");
INSERT INTO qulNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ama musphaychu ‘Tucuy ujtawan nacinancu’ niskaymanta. ");
INSERT INTO qulNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Wayraka may munaskanta phucun, uyarinquitaj suenamojta, nitaj yachanquichu maymanta jamuskanta ni may puriskanta. Jinallataj cancu tucuy Espiritumanta nacejcunaka. ");
INSERT INTO qulNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemo ujtawan taporkan: —¿Imaynataj canman chayri? ");
INSERT INTO qulNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús contestarkan: —Kan Israelpaj yachachejnin cachcaspa, ¿manachu cayta yachanqui? ");
INSERT INTO qulNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Segurayqui, yachaskaycuta nokaycoka parlaycu. Ricuskaycumantataj testigo caycu. Kancunataj niskaycuta mana creenquichischu. ");
INSERT INTO qulNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Cay pachapi cajcunamanta willajtiypas mana creewajtiyquichisri, ¿imaynatataj creewanquichisman, janaj pachapi cajcunamanta willayquichisman chayri? ");
INSERT INTO qulNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Mana pipas janaj pachaman purerkanchu, manachayri janaj pachamanta jamojlla, chaytaj Tataj Churin. ");
INSERT INTO qulNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Imaynatachus ch'usaj pampapi Moisés broncemanta pallita ruwaspa warcorkan, ajinallatataj Tataj Churinpas chacataska canka, ");
INSERT INTO qulNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","tucuy paypi creejcuna wiñay causayniyoj canancupaj. ");
INSERT INTO qulNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Dioska tucuy runacunata maytapuni munacun. Chayraycu ch'ulla Churinta cachamorkan, paypi creej mana infiernopi wiñaypaj sufrinanpaj, manachayri wiñaypaj salvaska cananpaj. ");
INSERT INTO qulNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Dioska cay pachaman Churinta cachamorkan, mana runacunata juchachananpajchu, manachayri salvananpaj. ");
INSERT INTO qulNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Diospaj Churinpi creejka mana juchachaskachu, mana creejcunataj juchachaskaña cancu, Diospaj ch'ulla Churinpi mana creeskancuraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Mana creejcunaka juchachaskaña cancu, imaraycuchus c'anchay cay pachaman jamojtin, paycuna c'anchaymanta nejtin tutayajta munarkancu, mana allincunata ruwaskancuraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tucuy mana allin ruwajcunaka c'anchayta chejnincu; mana c'anchayman jamuncuchu, mana allin ruwaskancu mana sut'inchacunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Chaywanpas verdadman jina causajcunacajka c'anchayman jamuncu, Diospaj munaskanman jina tucuy ruwaskancu ricuchiska cananpaj. ");
INSERT INTO qulNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Chay pasaymanta, Jesús discipuloncunawan Judeaman puriporkan. Chaypi uj tiempota cachcajtin, discipuloncuna bautizachcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juanpas bautizachcallarkantaj Enonpi, Salim kayllapi, chaypi achqha unu caskanraycu. Runacunataj purerkancu bautizaska canancupaj. ");
INSERT INTO qulNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Chayka pasarkan, Juanta manaraj carcelman apaycuchcajtincu. ");
INSERT INTO qulNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Waquin Juanpaj discipuloncuna uj judío runawan churanacuyta kallarerkancu limpiochacuna costumbremanta. ");
INSERT INTO qulNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Purerkancu Juanman willaj, nispa: —Yachachej, Jordán mayu chimpapi uj runa kanwan cachcarkan; paymanta willawarkanquichis. Chay cunanka bautizachcan, tucuytaj paywan purichcancu. ");
INSERT INTO qulNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juan paycunaman nerkan: —Mana pipajpas imapas canmanchu, mana Dios konmanchu chayka. ");
INSERT INTO qulNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kancunaka sut'ita uyariwarkanquichis ‘Mana Cristochu cani’ niskayta, manachayri Diospaj cachamuskallan ñaupakenta purinaypaj. ");
INSERT INTO qulNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Noviayojcajka noviomi. Chaypi caj noviopaj amigon noviopaj parlaskanta uyarispa, cusicun. Jinallatataj cunanka cusicuyneyka junt'aska. ");
INSERT INTO qulNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Payka astawan astawan importante canka, nokataj pisi importante. ");
INSERT INTO qulNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Janaj pachamanta jamojka tucuymanta curaj. Cay pachamanta cajka cay pacha runalla, cay pachapi cajcunallamanta parlan. Janaj pachamanta jamojcajtaj tucuymanta curaj. ");
INSERT INTO qulNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ricuskanta uyariskantawan parlan, chaywanpas pipas creenchu paypaj parlaskanta. ");
INSERT INTO qulNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pillapas creejka, willacun Diospaj verdad niskanta. ");
INSERT INTO qulNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Diospaj cachamuskanka Diospaj palabrancunata parlan; imaraycuchus Dios Santo Espiritunta payman kon, mana chhicanta jarc'acuspa. ");
INSERT INTO qulNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Dios Tata Churinta munacun, atiytataj kon tucuy imata paylla mandacunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Diospaj Churinpi creejcunaka wiñaypaj salvaska cankacu; Churipi mana creey munajcunataj mana salvaskachu cankacu, manachayri Dios paycunata sinchita castiganka. ");
INSERT INTO qulNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Fariseocuna yacharkancu Juanmanta nejtin Jesús astawan discipulocunayoj caskanta, astawan bautizachcaskantapas. ");
INSERT INTO qulNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Chaywanpas mana Jesuschu bautizarkan, manachayri discipuloncunalla.) ");
INSERT INTO qulNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jesús fariseocunapaj niskanta yachaspa, Judeamanta llojsispa Galileaman puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Purispa Samarianta pasanan carkan. ");
INSERT INTO qulNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ajinamanta Samariapi uj llajta Sicar niskaman chayarkan, Jacobpaj churin Joseman jallp'a koskan kayllaman. ");
INSERT INTO qulNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Chaypitaj Jacobpaj unu phujyun cachcarkan. Jesús puriskanmanta sayc'uska, chay phujyu patapi tiyaycorkan; chaupi p'unchay kayllaña carkan. ");
INSERT INTO qulNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Chayman Samaria llajtayoj warmi unuta wisej jamorkan. Jesustaj chay warmiman nerkan: —Unuta koriway ujyanaypaj —nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Discipuloncunataj llajtaman puriskacu miqhunata rantej. ");
INSERT INTO qulNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Judiocuna Samaria llajtayojcunawan mana allinpichu carkancu. Chayraycu warmeka Jesusman nerkan: —¿Imaynataj kan judío cachcaspa, noka Samaria llajtayojmanta unuta mañacuwanqui? ");
INSERT INTO qulNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesús payta contestarkan: —Diospaj koskanta rejsiwaj pichus unuta mañasunqui chaytawan chayka, kan paymanta mañacojtiyqui, payka causay unuta kosunquiman. ");
INSERT INTO qulNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Warmitaj nerkan: —Señor, ni imawan unu orkhonayquipas canchu, phujyutaj sinchi uqhu. ¿Maymantataj causay unuta kowanquiman? ");
INSERT INTO qulNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Jacob abueloycu cay phujyuta sakewancu, pay quiquinpaj, wawancunapaj, animalnincunapajpiwan ujyanancupaj. Kanrí, ¿curajchu canqui paymanta? ");
INSERT INTO qulNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús contestarkan: —Tucuy cay unumanta ujyajcunaka wajmanta ch'aquichiconkacu. ");
INSERT INTO qulNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Nokapaj unu koskay ujyajcunaka jayc'ajpas ch'aquichiconkacuñachu. Noka unuta kosaj chayka, paycunapi wiñay causayta phullchenka. ");
INSERT INTO qulNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Warmitaj nerkan: —Señor, chay unuta koway, manaña unumanta ch'aquinawanpaj, nitaj cay phujyumanta orkhoj jamunaypaj. ");
INSERT INTO qulNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús payta nerkan: —Puriy; kosayquita wajamuspa, cutimuy. ");
INSERT INTO qulNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Warmitaj contestarkan: —Mana kosay canchu. Jesustaj nerkan: —Allinta ninqui: ‘Mana kosay canchu’ nispaka, ");
INSERT INTO qulNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","imaraycuchus phichka kosayquicunaka. Cunan cachcan chayka mana kosayquichu. Chayraycu verdadta ninqui. ");
INSERT INTO qulNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Chayta uyarispa, warmeka nerkan: —Señor, reparayqui uj profeta caskayquita. ");
INSERT INTO qulNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nokaycupaj ñaupaj abueloycuna cay lomapi Diosta adorarkancu. Kancuna judiocuna ninquichis Jerusalenllapi adoranata. ");
INSERT INTO qulNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús payta contestarkan: —Warmi, creeway, hora chayamunña, Dios Tatata adoranayquichispaj mana cay lomapichu nitaj Jerusalenpichu. ");
INSERT INTO qulNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kancunaka mana yachanquichischu pita adoraskayquichista. Nokaycoka yachaycu pita adoraskaycuta. Salvacojka judiocunamanta jamun. ");
INSERT INTO qulNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Hora chayamunña, chaytaj cunanpacha, jayc'ajchus Dios Tatata verdadpi adorajcunaka Diospaj Espiritunman jina adoranancu. Chay jina adorajcunata Tataka munacun. ");
INSERT INTO qulNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dioska Espíritu, payta adorajcuna tucuy sonkowan verdadpi adoranancu Diospaj Espiritunman jina. ");
INSERT INTO qulNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Warmeka nerkan: —Noka yachani Mesías jamonka (niyta munan: Cristo); pay jamuspa, tucuy imata sut'inchawasun. ");
INSERT INTO qulNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús nerkan: —Chay cani noka, quiquin kanwan parlachcaj. ");
INSERT INTO qulNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Discipuloncunataj chayaramuspa, musphararkancu Jesús uj warmiwan parlachcaskanmanta. Nitaj maykenpas tapuyta atrevicorkancuchu, ¿imatataj munarkan? chayri ¿imamantataj paywan parlachcarkancu? nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Warmitaj unu p'uyñunta sakerparispa, llajtaman purerkan. Chaypitaj runacunaman willarkan: ");
INSERT INTO qulNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Jamuychis uj runata ricoj. Tucuy ima ruwaskayta sut'inchawan. ¿Manachu payri Cristo canman? ");
INSERT INTO qulNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Chhicari tucuy runacuna llajtamanta llojsimuspa Jesusman purerkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Chhicanacamataj discipuloncuna payta rogachcarkancu: —Yachachej, imallatapas miqhuy —nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Jesustaj paycunaman nerkan: —Nokapaj miqhunay can; kancuna chayta mana rejsinquichischu. ");
INSERT INTO qulNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Discipuloncunaka tapunacorkancu: —¿Icha pichus ima miqhunata apamporkan? ");
INSERT INTO qulNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesustaj paycunata nerkan: —Miqhuyneyka cachamuwajniypaj munayninta ruwanay, llanc'anantapas tucuchanay. ");
INSERT INTO qulNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Kancunaka ninquichis: ‘Ajthapinapaj tawa quillaraj cachcan.’ Nokataj niyquichis: Tarpuskacunata reparaychis, ajthapinapaj pokoskaña cachcan. ");
INSERT INTO qulNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ajthapinapi llanc'ajcunaka pagaska cankacu. Ajthapiskancutaj wiñay causaypaj canka, tarpojpas ajthapejpas junto cusicunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ciertopuni cay niska: ‘Uj tarpun, ujtaj ajthapin.’ ");
INSERT INTO qulNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Noka cachayquichis mana llanc'askayquichista ajthapejta. Wajcuna llanc'amorkancu, kancunataj paycunapaj llanc'askancumanta okharinquichis. ");
INSERT INTO qulNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Achqha Samaria llajtapi tiyajcuna Jesuspi creerkancu warmi willaskanraycu: “Tucuy ima ruwaskayta sut'inchawan” nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ajinapi Samaria llajtayojcunaka chayaspa, Jesusta rogarkancu paycunawan quedacunanpaj. Chaypitaj quedacorkan iscay p'unchayta. ");
INSERT INTO qulNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Pay quiquinpaj niskanta uyarispa, astawan achqhayoj creerkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Warmiman nerkancu: —Cunanka creeycu, mana kan willawaskayquichisraycullachu, manachayri nokaycu quiquin uyarimuycu, yachaycutaj payka runacunapaj Salvadorninpuni caskanta. ");
INSERT INTO qulNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Iscay p'unchay pasayta, Jesús Samariamanta llojsipuspa Galileaman puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesús quiquin nerkan: “Uj profetata mana allinta jap'ekancuchu quiquin llajtanpi caj runacunaka.” ");
INSERT INTO qulNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galileaman chayajtin, allinta jap'ekarkancu, imaraycuchus Jerusalenpi Pascua fiestaman purillaskacutaj, chaypitaj ricuskacu tucuy imata Jesús ruwaskanta. ");
INSERT INTO qulNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesús cutiporkan Galilea provinciapi caj Caná llajtaman, unumanta vinoman tucuchiskanman. Gobernajpaj uj autoridadninpaj churin onkoska carkan Capernaumpi. ");
INSERT INTO qulNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Judeamanta Galileaman Jesuspaj chayaskanta yachaspa, rogaj purerkan, wasinman purispa churinta alliyachinanpaj; churenka wañunayachcarkanña. ");
INSERT INTO qulNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesús contestarkan: —Kancuna mana creenquichischu, milagrocunata mana ricuspaka. ");
INSERT INTO qulNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Autoridadtaj nerkan: —Señor, jamullayña, manaraj churiy wañupuchcajtin. ");
INSERT INTO qulNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Chhicataj Jesús payman nerkan: —Cutipuy wasiyquita. Churiyqueka causanka. Chay runataj creerkan Jesuspaj payman niskanta, puriporkantaj. ");
INSERT INTO qulNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Wasinman cutipuchcajtillanraj, uywaskancuna taripamuspa nerkancu: —¡Churiyqui causapun! ");
INSERT INTO qulNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Autoridadtaj paycunata taporkan ima ratomantachus churin alliyapuskanta. Contestarkancutaj: —Kayna chaupi p'unchay pasayta calenturanka pasaporkan. ");
INSERT INTO qulNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tatantaj yuyarerkan chay quiquin hora Jesús “Churiyqueka causanka” niskanta. Pay tucuy familianpiwan Jesuspi creerkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Chay carkan Jesuspaj iscaycaj milagro ruwaskan Galileapi, Judeamanta cutipojtin. ");
INSERT INTO qulNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Caycuna pasayta judiocuna uj fiestata ruwarkancu. Jesustaj Jerusalenman cutiporkan. ");
INSERT INTO qulNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalenpi, Ovejacunapaj Puncun niska kayllapi, uj unu estanque carkan, hebreo parlaypi Betzata sutiyoj, phichka arco jina athuchaj puncucunayoj. ");
INSERT INTO qulNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Chay puncucunapi carkancu achqha onkoskacuna: ñausacuna, cojocuna, such'ucunapas. Unu cuyurinanta suyaspa, pampapi sirichcarkancu, ");
INSERT INTO qulNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","imaraycuchus uj ángel estanqueman konkaylla urakamuspa, unuta cuyucherkan. Pichus ñaupajta estanqueman yaycojka alliyachiska carkan ima onkoymantapas. ");
INSERT INTO qulNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Onkoskacuna uqhupi uj runa quimsa chunca pusajniyoj wataña onkoska carkan. ");
INSERT INTO qulNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesús chaypi sirichcajta ricuspa, repararkan achqha wataña onkoska caskanta. Taporkantaj: —¿Munanquichu alliyayta? ");
INSERT INTO qulNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Onkoskataj contestarkan: —Señor, estanquepi unu cuyojtin, mana pipas apaycuwaj canchu. Sapa cuti yaycuyta munajtiy, wajllapuni ñaupajta yaycun. ");
INSERT INTO qulNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús payta nerkan: —Sayaricuy, puñunayquita okharispa puripuy. ");
INSERT INTO qulNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Chaypacha runaka alliyaska caporkan. Puñunanta okharispa, puriporkan. Samana p'unchay carkan. ");
INSERT INTO qulNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Chayraycu judiocunaka alliyachiska runata nerkancu: —Cunanka samana p'unchay. Puñunayquita mana apawajchu. ");
INSERT INTO qulNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Paytaj contestarkan: —Alliyachiwajniy niwan: ‘Puñunayquita okharispa puripuy’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Paycunataj taporkancu: —¿Pitaj nisunqui: ‘Puñunayquita okharispa puripuy’ nispari? ");
INSERT INTO qulNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Runataj mana yacharkanchu pi alliyachiskanta, imaraycuchus Jesús achqha runa uqhupi chincapuska. ");
INSERT INTO qulNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Chaymantaña Jesús templopi taripaspa, nerkan: —Khawariy, cunan alliyachiskaña canqui. Amaña juchallicunquichu, astawan mana allin mana pasanasunquipaj. ");
INSERT INTO qulNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Chay runataj puripuspa judiocunaman willamorkan payta alliyachejka Jesús caskanta. ");
INSERT INTO qulNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Chayraycu judiocunaka Jesusta katiycacharkancu, samana p'unchaypi caycunata ruwaskanmanta. ");
INSERT INTO qulNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesustaj paycunaman nerkan: —Tatayka llanc'achcallanpuni, nokapas llanc'achcallanitaj. ");
INSERT INTO qulNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Chaymanta judiocunaka Jesusta wañuchiytaraj munarkancu, samana p'unchay leyta mana casuskanmanta, “Dioska Tatay” nispa Dioswan igualacuskanmantapiwan. ");
INSERT INTO qulNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesús nerkan: “Segurayquichis, Diospaj Churenka mana imatapas payllamantachu ruwan, manachayri Tatanpaj ruwaskanta ruwan. Tatanpaj tucuy ruwaskanta ruwallantaj Churenka. ");
INSERT INTO qulNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tataka Churinta munacun, tucuy ima ruwaskanta ricuchin. Astawan athun ruwaskancunatawanraj ricuchenka, kancunataj muspharanquichis. ");
INSERT INTO qulNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Imaynatachus Dios Tataka wañuskacunata causarichispa causayta kon, ajinallatataj Chureka causayta kon picunamanchus koy munaskanman. ");
INSERT INTO qulNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tataka mana pitapas juzganchu, manachayri Churinman tucuy atiyta kon juzgananpaj, ");
INSERT INTO qulNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","imaynatachus Tatata adorancu, ajinallatataj Churita tucuynincu honrawan adoranancupaj. Churita mana honrawan adorajka, manallataj cachamoj Tatantapas honrawan adoranchu. ");
INSERT INTO qulNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Segurayquichis, pipas niskaycunata allinta uyarispa cachamuwajniypi creejka, wiñay causayniyoj, mana juchachaskachu canka. Wañuymanta causayman pasapunña. ");
INSERT INTO qulNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Segurayquichis, hora chayamunña, cunan chay horaka, jayc'ajchus juchapi wañuska jina runacuna Diospaj Churinpaj vozninta uyarispa casuconkacu chayka, causankacu. ");
INSERT INTO qulNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Imaynatachus Dios Tata pay quiquinpi causayniyoj, ajinallatataj Churipas pay quiquinpi causayniyoj Tatapaj munayninman jina. ");
INSERT INTO qulNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Atiyta kollarkantaj juzgananpaj, Tataj Churin caskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ama muspharaychischu. Hora chayamonka, tucuy wañuskacuna Churipaj vozninta uyarispa, ");
INSERT INTO qulNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","sepulturamanta llojsirankacu. Allin ruwajcunaka causarenkacu wiñay causaypaj; mana allin ruwajcunataj causarenkacu infiernopi juchachaska canancupaj. ");
INSERT INTO qulNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Mana imatapas nokallamanta ruwaymanchu. Tataypaj niskanman jina juzgani, juzgaskaytaj justo. Mana nokapaj munayniytachu ruwani, manachayri cachamuwajniy Tataypaj munayninta. ");
INSERT INTO qulNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Noka quiquiymanta willacuyman chayka, willaskayka mana valorniyojchu canman. ");
INSERT INTO qulNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Manachayri waj can nokamanta willaj, willaskantaj valorniyoj. ");
INSERT INTO qulNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Kancuna Juanman cacharkanquichis nokamanta tapojta. Paytaj verdadta nerkasunquichis. ");
INSERT INTO qulNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Chaywanpas nokaka mana runacunamantachu testigota masc'ani. Caycunataka niyquichis kancuna salvaska canayquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juanka lámpara jina laurarkan, c'ancharkantaj. Kancunataj chay c'anchayninpi pisi tiempollata cusicorkanquichis. ");
INSERT INTO qulNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nokapaj testigoyka Juanpaj willaskanmantapas astawan confiacunapaj cachcan. Noka ruwani Tataypaj mandaskanman jina. Chay ruwaskaycunataj ricuchin Dios Tata cachamuwaskanta. ");
INSERT INTO qulNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tatay cachamuwajniy nokamanta willacun. Kancunataj jayc'ajpas parlaskanta uyarerkanquichischu, nitaj ricorkanquichischu. ");
INSERT INTO qulNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Nitaj Palabranpas kancunaman yaycunchu, imaraycuchus Tatapaj cachamuskanpi mana creenquichischu. ");
INSERT INTO qulNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kancuna Escriturata sinchita estudianquichis, payninta wiñay causayniyoj caskayquichista suyaspa. Chaywanpas Escrituraka nokamanta parlan. ");
INSERT INTO qulNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Kancunataj nokaman jamuyta mana munanquichischu chay wiñay causayniyoj canayquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Nokaka mana runacuna alabanawancutachu masc'ani. ");
INSERT INTO qulNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Astawanpas kancunata rejsiyquichis, yachanitaj Diosta mana munacuskayquichista. ");
INSERT INTO qulNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Noka jamuni Tataypaj sutinpi, kancunataj mana jap'ekawanquichischu. Astawanpas waj quiquin sutinpi jamunman chayka, payta jap'ekawajchis. ");
INSERT INTO qulNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Imaynatataj kancuna creewajchis? Uj ujcunamanta alabanata jap'ekanquichis, manataj ch'ulla Diosmanta jamoj alabanata masc'anquichischu. ");
INSERT INTO qulNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ama creeychischu noka Tataypaj ñaupakenpi kancunata juchachanaytaka. Moisés quiquin juchachasunquichis, paypitaj kancuna confiacuchcanquichis. ");
INSERT INTO qulNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kancuna Moisespaj niskanta creewajchis chayka, nokatapas creellawanquichismantaj, imaraycuchus Moiseska nokamanta escriberkan. ");
INSERT INTO qulNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Paypaj escribiskanta mana creespari, ¿imaynatataj creewajchis noka kancunaman niskayta?” ");
INSERT INTO qulNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Caycuna pasajtin, Jesús puriporkan Galilea kocha chimpaman, Tiberias kocha niskallataj. ");
INSERT INTO qulNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Achqha runa khepanta purerkancu, onkoskacunata alliyachiskanta milagrocunata ruwaskantawan ricuskancuraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesustaj uj lomaman llojsispa, discipuloncunawan tiyaycorkan. ");
INSERT INTO qulNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Judiocunapaj Pascua fiestanman kayllaña carkan. ");
INSERT INTO qulNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesús achqha jamoj runacunata ricuspa, Felipeman nerkan: —¿Maymantataj miqhunata rantisunchis tucuy cay runacunapaj? ");
INSERT INTO qulNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Chayta nerkan imaynatachus Felipe contestanka chayta yachananpaj. Chaywanpas Jesús quiquin yacharkan ima ruwananta. ");
INSERT INTO qulNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipe payman nerkan: —Iscay pachaj kolke valorniyoj miqhunapas nichá aypanmanchu uj chhicallantapas sapa uj miqhunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Discipuloncunamanta ujnin, Andrés sutiyoj, Simón Pedropaj wauken, nerkan: ");
INSERT INTO qulNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Caypi uj juch'uycito cachcan. Paypaj can phichka cebada t'anta, iscay challwitapiwan. Chaywanpas, ¿imataj cay chay tucuy runapajri? ");
INSERT INTO qulNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesustaj nerkan: —Niychis, tucuy tiyarachuncu —nispa. Chay lugarpi achqha pasto carkan; chay patapitaj tiyararkancu. Kharicunalla phichka waranka jina carkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesustaj t'antacunata jap'ispa Diosman graciasta kospa, tiyarachcajcunaman partirarkan. Challwitacunawan caskallantataj ruwarkan. May munaskancucama miqhorkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Sajsarajtincuña, Jesús discipuloncunaman nerkan: —Okhariychis puchojnincunata, mana imapas usunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Paycunataj okharispa, chunca iscayniyoj canastata junt'acherkancu phichka t'antamanta puchojnincunawan. ");
INSERT INTO qulNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Jesuspaj ruwaskan milagrota ricuspa, runacuna nerkancu: —Ciertopuni cayka uj profeta, cay pachaman jamunan carkan chay. ");
INSERT INTO qulNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesustaj gobiernoncupaj churayta munaskancuta reparacuspa, ujtawan lomaman puriporkan, chaypi sapallan cananpaj. ");
INSERT INTO qulNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ch'isiyajtinña, discipuloncuna kochaman purerkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Boteman yaycuspa, Capernaum llajtaman chayanancupaj purerkancu. Sinchi laja tutayajña carkan, Jesustaj mana paycunaman cutimuskarajchu. ");
INSERT INTO qulNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Sinchita wayramojtin, kocha olada okharicamorkan. ");
INSERT INTO qulNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Uj leguata jinaña purichcaspa, Jesusta unu patanta purispa paycunaman chimpaycuchcajta ricorkancu. Mancharicorkancutaj. ");
INSERT INTO qulNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jesús nerkan: —¡Noka cani, ama manchacuychischu! ");
INSERT INTO qulNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Paycunataj cusicuywan botepi jap'ekarkancu. Jesús yaycojtin, chhicapacha chayaporkancu purichcaskancu lugarman. ");
INSERT INTO qulNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","K'ayantintaj uj lado kocha chimpapi quedaj runacuna repararkancu discipulocuna chaypi caj ch'ulla botepi ripuskancuta, Jesustaj mana paycunawan puriskanta. ");
INSERT INTO qulNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Chhicanacamataj maypichus Señor graciasta koy pasayta miqhucherkan, chay kaylla lugarman waj botecuna chayamorkancu Tiberias llajtamanta. ");
INSERT INTO qulNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Jesusta discipuloncunatawan chaypi mana tarispa, runacunaka botecunaman yaycuporkancu, Capernaumpi Jesusta masc'anancupaj. ");
INSERT INTO qulNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Runacuna kocha chimpaman chayaspa, Jesusta tarerkancu. Taporkancutaj: —Yachachej, ¿jayc'ajtaj cayman jamorkanqui? ");
INSERT INTO qulNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesús contestarkan: —Segurayquichis, kancunaka masc'awanquichis sajsanayquichiscama miqhuskayquichisraycu, manataj milagroycunata entendiskayquichisraycuchu. ");
INSERT INTO qulNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ama llanc'aychischu tucucoj miqhunaraycullaka, manachayri wiñay causay koj mana tucucoj miqhunaraycu. Chay miqhunata Tataj Churin kosunquichis, imaraycuchus Dios Tata Churinta churan chay miqhunata konanpaj. ");
INSERT INTO qulNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Jesusta taporkancu: —Diospaj munaskanta ruwanaycupajri, ¿imatataj ruwanaycu? ");
INSERT INTO qulNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús contestarkan: —Dios munan cachamuskanpi creenayquichista. ");
INSERT INTO qulNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Paycunataj taporkancu: —¿Ima milagrotataj ruwanqui, chayta ricuspa kanpi creenaycupaj? ¿Maykencunataj ruwaskayqui? ");
INSERT INTO qulNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Abuelonchiscuna ch'usaj pampapi maná niska t'antata miqhorkancu. Escritura nin: ‘Dios paycunaman korkan janaj pacha t'antata miqhunancupaj.’ ");
INSERT INTO qulNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesustaj contestarkan: —Sequrayquichis, mana Moiseschu korkasunquichis janaj pacha t'antataka, manachayri Tataymi kon janaj pacha verdadero causay t'antataka. ");
INSERT INTO qulNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Dios Tataj koskan t'antaka janaj pachamanta uraycamun, causaytataj runacunaman kon. ");
INSERT INTO qulNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Paycunataj mañarkancu: —Señor, chay t'antata kowaycupuni. ");
INSERT INTO qulNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesús paycunata nerkan: —Noka causay koj t'antaka cani. Nokaman jamojka jayc'ajpas yarekachiconkachu, nokapi creejtaj jayc'ajpas unumanta ch'aquichiconkachu. ");
INSERT INTO qulNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nerkayquichisña jina, ni ricuwaspapas creewanquichischu. ");
INSERT INTO qulNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tucuy Tatapaj kowaskanka nokaman jamun, nokaman jamojcunatataj mana wijch'usajchu jawamanka. ");
INSERT INTO qulNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Mana munayniy ruwajchu janaj pachamanta jamuni, manachayri cachamuwaj Tataypaj munayninta ruwaj. ");
INSERT INTO qulNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Cachamuwajniypaj munaynenka cay: mana ujtapas kowaskancunamanta chincachisajchu, manachayri causarichisaj tucucuy p'unchaypi. ");
INSERT INTO qulNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Tataypaj munaynenka caymi: Diospaj Churinta ricuspa paypi creejcunaka wiñay causayniyoj cancu; nokataj causarichisaj tucucuy p'unchaypi. ");
INSERT INTO qulNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Chayraycu judiocunaka Jesús contra thutuyta kallarerkancu, “Janaj pachamanta uraycamoj t'anta noka cani” niskanmanta. ");
INSERT INTO qulNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Nerkancutaj: —¿Manachu cayri Jesús, Josepaj churin? Nokanchis tatanta mamantapas rejsinchis. Chhicari, ¿imaynapitaj cayri nin: ‘Janaj pachamanta uraycamuni’ nispa? ");
INSERT INTO qulNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesustaj nerkan: —Amaña thutuychischu kancunapura. ");
INSERT INTO qulNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mana pipas nokaman jamunmanchu, cachamuwaj Tatay mana pusamuwanmanchu chayka. Nokataj causarichisaj tucucuy p'unchaypi. ");
INSERT INTO qulNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Profetacunapaj libroncunapi jinata nin: ‘Dios tucuyninman yachachenka’ nispa. Ajinaka Tatata tucuy uyarejcunaka paymanta yachakancu, jamuncutaj nokaman, creewancutaj. ");
INSERT INTO qulNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Mana pipas Tatata ricunchu; Diosmanta jamojlla ricun. ");
INSERT INTO qulNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Segurayquichis, pipas creejka wiñay causayniyojña. ");
INSERT INTO qulNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Noka causay koj t'anta cani. ");
INSERT INTO qulNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Abueloyquichiscuna ch'usaj pampapi maná niska t'antata miqhorkancu chaywanpas, wañurarkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Noka parlachcani janaj pachamanta uraycamoj t'antamanta. Pichus paymanta miqhojka mana wañunchu. ");
INSERT INTO qulNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Noka chay causachcaj t'anta cani, janaj pachamanta uraycamoj. Cay t'antamanta miqhojka wiñaypaj causanka. Chay t'antaka cuerpoymi, cuerpoytataj kosaj runacuna causanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Judiocunataj churanacuspa tapunacorkancu: —¿Imaynatataj cayri kowachuwan cuerponta miqhunanchispaj? ");
INSERT INTO qulNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesustaj nerkan: —Segurayquichis, kancunachus Tataj Churinpaj cuerponta mana miqhunquichischu, ni yawarninta ujyanquichischu chayka, mana causayniyoj canquichis. ");
INSERT INTO qulNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Cuerpoyta miqhoj yawarniytapas ujyajka, wiñay causayniyojña; nokataj causarichisaj tucucuy p'unchaypi. ");
INSERT INTO qulNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Cuerpoyka verdadero miqhuy, yawarniypas verdadero ujyana. ");
INSERT INTO qulNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Cuerpoyta miqhoj yawarniytapas ujyajka, nokawan ujlla causan. Nokataj paywan ujlla causani. ");
INSERT INTO qulNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Cachamuwaj Tatayka causayniyoj, nokataj payraycu causani. Ajinallatataj nokamanta miqhojka nokaraycu causanka. ");
INSERT INTO qulNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Noka parlani janaj pachamanta uraycamoj t'antamanta. Cay t'antaka mana abueloyquichispaj miqhuskancu maná t'anta jinachu. Chayta miqhorkancu chaypas, wañuporkancu. Cay t'antacajmanta miqhojka wiñaypaj causanka. ");
INSERT INTO qulNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesús caycunata yachacherkan Capernaum sinagoga wasipi. ");
INSERT INTO qulNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Chay yachachiskancunata uyarispa, achqhayoj Jesuswan purejcuna nerkancu: —Cay niskanka mana creena jinachu. ¿Pitaj casunmanri? ");
INSERT INTO qulNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesús thutuskancuta reparaspa, paycunata taporkan: —¿Cay niskaychu phiñachisunquichis? ");
INSERT INTO qulNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Chhicari, ¿imataj pasanman, Tataj Churinta ricuwajchis maypichus ñaupaj carkan chayman puripuchcajta chayri? ");
INSERT INTO qulNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Espiritucajmi causayta kojka; cuerpoka mana imapaschu. Nokapaj niskaycunataj Espiritumanta, causaytataj kon. ");
INSERT INTO qulNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kancuna uqhupi canraj mana creejcuna. Jesús yacharkan kallariymantapacha picunachus paypi mana creeskancuta, jinallatataj pichus payta vendiycunanta. ");
INSERT INTO qulNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nillarkantaj: —Chayraycu nerkayquichis, ni pipas nokaman jamunmanchu, Dios Tatay mana pusamojtenka. ");
INSERT INTO qulNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Chhicamantapacha achqha paywan purejcuna sakeporkancu; manaña paywan purerkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jesús chunca iscayniyoj discipuloncunata taporkan: —¿Kancunapas puripuyta munanquichischu? ");
INSERT INTO qulNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simón Pedrotaj contestarkan: —Señor, ¿pimantaj puriycumanri? Kanpaj parlaskayqueka wiñay causayniyoj. ");
INSERT INTO qulNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nokaycu creeycuña, yachaycutaj Diospaj Santo Churin caskayquita. ");
INSERT INTO qulNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesús paycunaman nerkan: —¿Manachu noka chunca iscayniyojta ajllarkayquichis? Chaywanpas ujnin kancunamanta uj supay. ");
INSERT INTO qulNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Chayta nerkan Simonpaj churin Judas Iscariotemanta. Judaska Jesusta vendiycunan carkan, chunca iscayniyoj discipuloncunamanta cachcaspapas. ");
INSERT INTO qulNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Chay pasayta, Jesús Galileanejpi purichcarkan. Judeanejpi manaña cayta munarkanchu, imaraycuchus chaypi judiocuna wañuchinancupaj masc'achcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Judiocunapaj Ramara Ruwana fiestancu kayllachamuchcarkanña. ");
INSERT INTO qulNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jesusmantaj waukencuna nerkancu: —Puripuy caymanta Judeaman, jakaypi cachcaj katejniyquicunapas ruwaskayquita ricunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Pillapas rejsichicuyta munaspaka, mana imatapas pacallapi ruwanchu. Caycunata ruwaspaka, tucuy runapaj ñaupakenpi ruway. ");
INSERT INTO qulNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Chayta nerkancu, imaraycuchus ni waukencunapas paypi creerkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesús nerkan: —Nokapaj rejsichina p'unchayniy manaraj chayamuwanchu. Kancunapajka ima p'unchaypas allillan. ");
INSERT INTO qulNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Cay pachamanta cajcunaka kancunata mana chejnisunquichismanchu; nokacajtaka chejniwancu, mana allin ruwaskancuta sut'inchaskayraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kancuna fiestaman puriychis. Noka manaraj purisajchu, imaraycuchus manaraj p'unchayniy chayamunrajchu. ");
INSERT INTO qulNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Chayta nispa, Galileapi quedacorkan. ");
INSERT INTO qulNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Waukencuna puripojtincu, Jesús fiestaman pacallamanta purillarkantaj, runacunaman mana ricuchicuspa. ");
INSERT INTO qulNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Judiocuna fiestapi Jesusta masc'achcarkancu nispa: —¿Maypitaj chay runa cachcanman? ");
INSERT INTO qulNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Runacuna uqhupi sinchita Jesusmanta parlarkancu. Ujcunaka nerkancu: “Sumaj runa.” Waquincunataj nerkancu: “Mana allinchu, runacunata engañan” nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Manataj ni pipas Jesusmanta sut'ita parlajchu, judiocunapaj jefencunata manchacuskancuraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Chaupi fiestapi Jesús temploman yaycuspa, yachacherkan. ");
INSERT INTO qulNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Judiocuna muspharaspa, nerkancu: —¿Imaynatataj cay runa tucuy imata yachan, mana estudiaspari? ");
INSERT INTO qulNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús contestarkan: —Yachachiskayka mana nokallamantachu, manachayri jakay cachamuwajniymanta. ");
INSERT INTO qulNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Maykenpas Diospaj munayninta ruwayta munanman chayka, yachachiskayta rejsinman Diosmantachus chayri nokallamantachus chayta. ");
INSERT INTO qulNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Pipas payllamanta parlajka, runa alabananpaj ruwan. Cachamojninta alabajka verdadta nin, paypitaj ni ima llullapas canchu. ");
INSERT INTO qulNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“¿Manachu kancunaman Moisés leyta korkasunquichis? Chaywanpas ni mayken casucunquichischu. ¿Imaraycutaj wañuchiyta munawanquichis?” ");
INSERT INTO qulNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Runacuna contestarkancu: —¡Sajra espirituyoj canqui! ¿Pitaj wañuchiyta munasunquiri? ");
INSERT INTO qulNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús paycunaman nerkan: —Samana p'unchaypi uj milagrota ruwajtiy, tucuyniyquichis muspharanquichis. ");
INSERT INTO qulNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisés leyta korkasunquichis circuncidanapaj. (Mana Moisesllamantachu carkan, manachayri ñaupaj abueloyquichiscunamanta.) Kancuna uj khari wawata circuncidanquichis samana p'unchay cachcajtinpas. ");
INSERT INTO qulNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Niyquichis, Moisespaj leyninta junt'anayquichispaj circuncidanquichis samana p'unchay cachcajtinpas chhicari, ¿imaraycutaj phiñacunquichis samana p'unchaypi uj runapaj cuerponta alliyachiskaymanta? ");
INSERT INTO qulNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ama rijch'acuynillanman jina juzgaychischu, manachayri allin yuyaywan juzgaychis. ");
INSERT INTO qulNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Waquin Jerusalenpi cajcuna nerkancu: —¿Manachu cayri wañuchinancupaj masc'achcarkancu chayri? ");
INSERT INTO qulNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Khawariychis, tucuypaj ricunanta parlachcan, nitaj pipas imatapas ninchu. ¿Autoridadcunachu creepuncuña cay runa Cristo caskanta? ");
INSERT INTO qulNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nokanchis yachanchis maymanta cay jamuskanta. Cristo jamojtenka, ni pipas yachankachu maymanta jamuskanta. ");
INSERT INTO qulNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesús templopi yachachichcaspa chayta uyarerkan. Alto vozwantaj nerkan: —¡Ajinaka nokata kancuna rejsiwanquichis, maymanta jamuskaytapas yachanquichis! Manataj nokallamantachu jamuni, manachayri uj cachamuwan. Payka confiacunapaj, paytataj mana rejsinquichischu. ");
INSERT INTO qulNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nokacajka rejsini, imaraycuchus paymanta jamuni, paytaj cachamuwan. ");
INSERT INTO qulNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Chhicari Jesusta presota jap'iyta munarkancu. Manataj pipas aterkanchu, manaraj payta jap'ina p'unchay chayamuskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Achqhayoj paypi creerkancu, nerkancutaj: —Cristo jamuspari, ¿astawanchu milagrota ruwanman cay runamanta nejtinri? ");
INSERT INTO qulNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariseocuna uyarerkancu runacuna Jesusmanta niskancuta. Paycunataj sacerdotecunapaj jefencunapiwan templo guardiajcunata cacharkancu Jesusta presota jap'inancupaj. ");
INSERT INTO qulNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesustaj nerkan: —Pisi tiempolla kancunawan casaj. Chaymanta cutipusaj cachamuwajniypajman. ");
INSERT INTO qulNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kancuna masc'awanquichis, nitaj tariwanquichischu, imaraycuchus maypichus casaj chayman mana jamuyta atinquichischu. ");
INSERT INTO qulNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Judiocunataj tapunacorkancu: —¿Maymantaj cay runa purenka, nokanchis payta mana tarinanchispajri? ¿Waj llajtacunapi t'acaska tiyaj judiocunamanchu purenka, waj diosniyojcunatachu yachachimonka? ");
INSERT INTO qulNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Ima niytataj munan: ‘Masc'awanquichis, nitaj tariwanquichischu, imaraycuchus maypichus casaj chayman mana jamuyta atinquichischu’ nispa? ");
INSERT INTO qulNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Fiesta tucucuy p'unchaycaj astawan importante carkan. Chay p'unchay Jesús sayaycuspa, alto vozwan nerkan: —Pipas unumanta ch'aquichicojka nokaman jamuchun, ujyachuntaj. ");
INSERT INTO qulNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Escritura nin: Nokapi creejpajka, sonkonmanta causay unu phawanka mayu jina. ");
INSERT INTO qulNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Chaywan Jesuska niyta munarkan paypi creejcunaka Santo Espirituta jap'ekanancuta. Manaraj Santo Espiritoka jamuskachu, Jesús manaraj Tatanpajman puripuskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Chayta uyarispa waquin runacunaka nerkancu: —Seguro cay runaka jamunan carkan chay profeta. ");
INSERT INTO qulNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ujcunataj nerkancu: —Cayka Cristo. Ujcunataj nerkancu: —Mana Cristoka Galileamanta jamunmanchu. ");
INSERT INTO qulNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Escritura nin: Cristoka jamonka gobernaj Davidpaj mirayninmanta, David quiquinpaj Belén llajtanmanta. ");
INSERT INTO qulNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ajinamanta runacunaka iscayman particorkancu Jesuspaj causanraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Waquin munarkancu Jesusta jap'iyta, manataj pipas jap'erkanchu. ");
INSERT INTO qulNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Templo guardiajcuna cutirimorkancu fariseocunaman sacerdotecunapaj jefencunaman. Paycunataj taporkancu: —¿Imaraycutaj mana apamunquichischu? ");
INSERT INTO qulNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Guardiajcunataj nerkancu: —¡Ni jayc'aj pipas parlajchu chay runa jinaka! ");
INSERT INTO qulNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Fariseocunataj nerkancu: —¿Kancunapas engañachicapunquichischu? ");
INSERT INTO qulNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Mayken jefellanchispas fariseocunapas paypi creencuchu? ");
INSERT INTO qulNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","¡Cay runacunaka Moisespaj leyninta mana yachancuchu; maldiciska cancu! ");
INSERT INTO qulNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Fariseocunamanta Jesusman tutapi purej Nicodemo nerkan: ");
INSERT INTO qulNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Leyninchisman jina, mana pillatapas juchachayta atichuwanchu, manaraj parlaskanta uyarispa, ni ruwaskantapas yachaspaka. ");
INSERT INTO qulNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Paycunataj contestarkancu: —¿Kanpas Galileamantachu canqui? Escriturata allinta estudiay. Chaypi allinta yachanqui, Galileamanta ni pi Diospaj profetan jamuskanta. ");
INSERT INTO qulNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Chaymantataj sapa uj wasincuman puriporkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesús Olivos lomaman purerkan. ");
INSERT INTO qulNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","K'ayantintaj, pakariyaytaña, temploman cuterkan. Runacuna chimpaycojtincu, pay tiyaycuspa yachachiyta kallarerkan. ");
INSERT INTO qulNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Leymanta yachachejcuna fariseocunapiwan uj warmita pusamorkancu adulterio jucha ruwachcaskanpi taripaskancuta. Tucuynincupaj chaupinpi suyaycucherkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jesusman nerkancu: —Yachachej, cay warmita taripaycu adulterio jucha ruwachcajta. ");
INSERT INTO qulNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Leyninchispi Moisés mandarkan rumiwan chhokaspa wañuchinata cay jina warmicunataka. ¿Kan, ima ninquitaj? ");
INSERT INTO qulNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Chayta nerkancu pantachiyta munaspa juchachanancupaj. Jesustaj c'uñuycuspa dedonwan escribiyta kallarerkan pampapi. ");
INSERT INTO qulNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Astawan tapojtincu, sayarispa paycunaman nerkan: —Maykenpas kancunamanta mana juchayoj cajka, ñaupajta rumita chhokachun cay warmiman. ");
INSERT INTO qulNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ujtawan c'uñuycuspa, wajmanta pampapi escribichcallarkantaj. ");
INSERT INTO qulNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Chayta uyarispa, ujmanta uj puriporkancu, machucunamanta kallarispa, juchancuta reparacuspa. Chaypi Jesusllaña warmipiwan quedaporkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesús sayarispa taporkan: —Warmi, ¿maytaj kanta juchachajcuna? ¿Manachu maykenpas juchachasunquichis? —nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Warmitaj contestarkan: —Mana maykenpas, Señor. Jesús payman nerkan: —Nokapas mana juchachayquichu. Cunanka puripuy, amataj ujtawan juchallicunquiñachu. ");
INSERT INTO qulNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesús ujtawan runacunaman nerkan: —Noka cani c'anchay runacunapaj. Nokawan purejka causay c'anchayniyoj canka; jayc'ajpas tutayajpi purenkachu. ");
INSERT INTO qulNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Fariseocunataj nerkancu: —Kan quiquiyquimanta willacuchcanqui; chay mana valorniyojchu. ");
INSERT INTO qulNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesús contestarkan: —Willacuskayka valorniyoj, noka quiquiy nejtiypas; imaraycuchus noka yachani maymanta jamuskayta, mayta purinayta. Kancunataj mana yachanquichischu. ");
INSERT INTO qulNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kancuna juchachanquichis runacuna jinalla. Noka pitapas juchachanichu. ");
INSERT INTO qulNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Sichus noka juchachani chayka, verdadman jina juchachani. Imaraycuchus mana sapaychu juchachani, manachayri cachamuwaj Tataypiwan. ");
INSERT INTO qulNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Leyniyquichispi escribiska cachcan: Iscay testigocuna caskantacama nincu chayka, niskancoka valorniyoj. ");
INSERT INTO qulNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Allin ari, noka quiquiymanta testigo cani, uj testigotaj cachamuwaj Tatay. ");
INSERT INTO qulNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Taporkancutaj: —¿Maypitaj Tatayqui cachcan? Jesús contestarkan: —Kancuna mana rejsiwanquichischu, nillataj Tataytapas. Rejsiwanquichisman chayka, Tataytapas rejsillawajchistaj. ");
INSERT INTO qulNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesús caycunata nerkan, templopi yachachichcaspa, ofrenda churana lugar chhicapi. Manataj pipas jap'erkanchu, manaraj payta jap'ina p'unchay caskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesús ujtawan nerkan: —Puripusaj, kancunataj masc'awanquichis. Chaywanpas, juchayquichispi wañunquichis. Maymanchus purisaj, chayman mana jamuyta atinquichischu. ");
INSERT INTO qulNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Judiocunaka nerkancu: —¿Wañuchicuytachu pensachcan? ¿Chayraycuchu nin maymanchus puriskanman mana puriyta atinanchista? ");
INSERT INTO qulNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesús nerkan: —Kancunaka cay uraymanta canquichis, nokataj janaj pachamanta. Kancunaka cay pachallamanta canquichis; nokaka mana cay pachallamantachu. ");
INSERT INTO qulNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Chayraycu nerkayquichis: ‘Juchayquichispi wañunquichis.’ Mana creenquichischu nokapuni caskayta chayka, juchayquichispi wañunquichis. ");
INSERT INTO qulNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Paycunataj taporkancu: —¿Pitaj canqui kanri? Jesús contestarkan: —¿Imapajñataj kancunawan parlachcasaj? ");
INSERT INTO qulNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Kancunamanta achqha parlanay, juchachanaypas. Cachamuwajniytaj verdadta nin; paymanta uyariskayta noka runacunaman nini. ");
INSERT INTO qulNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Paycunataj mana entenderkancuchu Dios Tatamanta parlaskanta. ");
INSERT INTO qulNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Chayraycu Jesús paycunaman nerkan: —Jayc'ajchus kancuna Tataj Churinta altoman okharinquichis, chhica rejsiwanquichis nokapuni Tataj Churin caskayta, manataj nokallamanta imatapas ruwaskayta, manachayri Tataypaj yachachiwaskallanta. ");
INSERT INTO qulNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Cachamuwaj Tatayka nokawan cachcan; mana sapaytachu sakewan. Nokaka ruwani payman agradajtapuni. ");
INSERT INTO qulNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jesús cayta nejtin, achqhayoj paypi creerkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jesús paypi creej judiocunaman nerkan: —Palabrayman jinapuni fielta causanquichis chayka, discipuloycunapuni canquichis. ");
INSERT INTO qulNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Rejsinquichistaj verdadta, verdadtaj librasunquichis. ");
INSERT INTO qulNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Paycunataj nerkancu: —Nokaycoka Abrahammanta caycu. Jayc'ajpas ni pipaj esclavonchu carkaycu. ¿Imaynataj kan ninqui, ‘Librasunquichis’ nispa? ");
INSERT INTO qulNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús contestarkan: —Segurayquichis, tucuy juchallicojcunaka juchapaj esclavon cancu. ");
INSERT INTO qulNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Esclavoka mana patronninpaj wasinpi familia jina wiñaypaj jap'ekaska canmanchu, churicajtaj wiñaypaj familia. ");
INSERT INTO qulNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ajinaka Churi librasunquichisman chayka, ciertopuni libre cawajchis. ");
INSERT INTO qulNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Yachaniña Abrahammanta caskayquichista. Chaywanpas wañuchiyta munawanquichis mana palabrayta jap'ekaskayquichisraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Noka Tataymanta yachaskayta parlani, kancunataj tatayquichispaj niskanta ruwanquichis. ");
INSERT INTO qulNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Paycunataj nerkancu: —¡Tataycoka Abraham! Jesús paycunata nerkan: —Abrahampaj wawancunapuni cawajchis chayka, paypaj ruwaskanta jina ruwawajchis. ");
INSERT INTO qulNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Diosmanta yachaskay verdadta niyquichis, chaywanpas kancuna wañuchiyta munawanquichis. ¡Abrahamka jayc'ajpas chay jinata ruwajchu! ");
INSERT INTO qulNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kancunataj ruwanquichis tatayquichis quiquinpaj ruwaskanta. Paycunataj nerkancu: —¡Mana mana tatayoj wawacunachu caycu! ¡Ujllataj Tataycoka, chaytaj Dios! ");
INSERT INTO qulNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesús nerkan: —Ciertopuni Dios canman Tatayquichis chayka, kancunaka munacuwanquichisman, imaraycuchus Diosmanta jamuni, caypitaj cachcani. Mana nokallamantachu jamuni, manachayri Dios cachamuwan. ");
INSERT INTO qulNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Imaraycutaj willaskayta mana entendinquichischu? Mana palabrayta uyariy munaskayquichisraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kancunapaj tatayquichiska supay. Paymanta caspa, paypaj munaskanta ruwayta munanquichis. Kallariymantapacha supayka runa wañuchej. Jayc'ajpas verdadpi jap'icunchu; jayc'ajpas verdadta ninchu. Llullacunata parlaspaka pay quiquin jina caskanta parlan. Payka llulla, llullacojcunapaj tatan. ");
INSERT INTO qulNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nokatataj, verdadta parlaskayraycu, mana creewanquichischu. ");
INSERT INTO qulNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Maykentaj juchayoj caskayta ricuchiwanquichisman? Verdadta nini chayri, ¿imaraycutaj mana creewanquichischu? ");
INSERT INTO qulNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Diospaj cajcunaka Diospaj palabranta uyarincu. Kancunaka mana Diospajta caspa, mana uyariyta munanquichischu. ");
INSERT INTO qulNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Judiocunataj nerkancu: —Razonta niyquichis: ‘Samaria llajtayoj, sajra espirituyojtaj canqui’ nispaka. ");
INSERT INTO qulNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesús contestarkan: —Ni ima sajra espírituy canchu. Ruwani Tatayta alabanaypaj, kancunataj nokata mana alabawanquichischu. ");
INSERT INTO qulNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mana nokallachu munani alabanawayquichistaka, manachayri Dios Tatay munan alabanawayquichista. Pay juchachasunquichis. ");
INSERT INTO qulNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Segurayquichis, palabrayta casucojka mana wañonkachu. ");
INSERT INTO qulNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Judiocunaka contestarkancu: —Cunanka seguro caycu, sajra espirituyojpuni canqui. Abraham tucuy profetacunapas wañurapuncu. Kantaj ninqui: ‘Palabray casucojka mana wañonkachu’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Tataycu Abrahammanta astawan curajchu canquiri? Payka wañuporkan, profetacunapas wañurapullarkancutaj. ¿Pi caskayquitataj kan creecunqui? ");
INSERT INTO qulNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesustaj contestarkan: —Noka quiquiy alabacuni chayka, alabacuskayka mana imapajpas valinchu. Tataymi nokata alabajka. Pay quiquinta kancuna ninquichis: ‘Diosniycu’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Kancuna Diosta mana rejsinquichischu; nokacajtaj rejsini. ‘Mana rejsinichu’ niyman chayka, kancuna jina llulla cayman. Ciertotapuni rejsini, casunitaj palabranta. ");
INSERT INTO qulNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham, abueloyquichis, cusicorkan nokapaj p'unchayniyta ricunanmanta. Ricuspataj mayta cusicorkan. ");
INSERT INTO qulNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Judiocunataj Jesusman nerkancu: —Manaraj phichka chunca watayojpasrajchu canqui. Kantaj ninqui, ‘Abrahamta ricuni’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesús contestarkan: —Segurayquichis, manaraj Abraham cachcajtin, noka carkaniña. ");
INSERT INTO qulNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Judiocunataj rumicunata okharispa, chhokayta munarkancu. Jesustaj pacaycucuspa, llojsiporkan templomanta. ");
INSERT INTO qulNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesús purichcaspa uj runata ricorkan, naciskanmantapacha ñausata. ");
INSERT INTO qulNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Discipuloncunataj taporkancu: —Yachachej, ¿imaraycutaj cay runa ñausa nacerkan? ¿Tata mamanpaj juchancumantachu, icha pay quiquinpaj juchanmantachu? ");
INSERT INTO qulNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesús contestarkan: —Ni pay quiquinpaj juchanmantachu, ni tata mamanpaj juchanmantachu, astawanpas paypi Diospaj ruwaskanta ricuchinapaj. ");
INSERT INTO qulNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ruwana p'unchaycuna cachcajtin, cachamuwajniypaj ruwananta ruwananchis can; imaraycuchus ruwana p'unchaycuna pasapojtin, pipas llanc'ayta atenkañachu. ");
INSERT INTO qulNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Cay pachapi cachcajteyka, c'anchay cani cay pachapi caj runacunapaj. ");
INSERT INTO qulNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Cayta niy pasayta, Jesús pampapi thokaspa, thokayninwan uj chhican t'uruta ruwarkan. Chaywantaj ñausapaj ñawincunata jawiycorkan. ");
INSERT INTO qulNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Nerkantaj: —Puriy, Siloé niska estanque unupi majchicamuy. (Siloé niyta munan: “Cachaska”.) Ñausataj puripuspa majchicorkan. Cutimorkantaj allin ricucuchcaj. ");
INSERT INTO qulNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Kayllamasincuna, limosna mañacojta ricojcunapiwan tapunacorkancu: —¿Manachu cayri limosnata mañaspa tiyachcarkan chay? ");
INSERT INTO qulNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ujcunataj nerkancu: —Arí, chaypuni. Wajcunataj nerkancu: —Mana, mana paychu, payman rijch'acun chaywanpas. Pay quiquintaj nerkan: —Arí, noka cani —nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Taporkancutaj: —¿Imaynapitaj cunan ricucapunquiri? —nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Paytaj contestarkan: —Chay Jesús sutiyoj runa t'uruta ruwaspa, ñawiycunaman jawiycuwan. Niwantaj: ‘Puriy, Siloé estanque unupi majchicamuy’ nispa. Nokataj purini, majchicuytawan ricucapuni. ");
INSERT INTO qulNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Chhicataj taporkancu: —¿Maypitaj cachcan chay runa? Paytaj paycunaman nerkan: —Mana yachanichu. ");
INSERT INTO qulNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ñausa carkan chay runata fariseocunaman pusarkancu, ");
INSERT INTO qulNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","imaraycuchus samana p'unchaypi Jesús t'uruta ruwaspa ñausata ricuchipuska. ");
INSERT INTO qulNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Chayraycu fariseocuna alliyachiska runata taporkancu imaynata ricucapuskanta. Paytaj contestarkan: —T'uruta ñawiycunaman churawan; majchicuspataj, cunan ricucapuni. ");
INSERT INTO qulNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Waquin fariseocuna nerkancu: —Cayta ruwajka mana Diosmantachu canman, imaraycuchus samana p'unchayta mana respetanchu. Waquincunataj nerkancu: —¿Imaynatataj uj juchasapa chay jina milagrota ruwanmanri? Ajinamanta iscayman particorkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Alliyachiska ñausata tapullarkancutaj: —Ñausamanta khawachisunqui chaymantari, kan, ¿ima ninquitaj? Paytaj contestarkan: —Uj profeta, nini. ");
INSERT INTO qulNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Judiocunataj mana creeyta munarkancuchu ñausapuni caskanta, cunantaj ricucapuskanta, tata mamanta wajachimunancucama. ");
INSERT INTO qulNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Taporkancutaj: —Cayri, ¿churiyquichischu? Niychis, ¿ñausapunichu nacerkan? ¿Cunan imaynamantataj ricunri? ");
INSERT INTO qulNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tata mamantaj contestarkancu: —Arí, churiycupuni, ñausapuni nacerkan. ");
INSERT INTO qulNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Cunanka mana yachaycuchu imaynamanta ricucuskanta, ni pi ñawinta alliyachiskantapas. Tapuychis payta, achqha watayojña. Pay quiquin razonta niyta atin. ");
INSERT INTO qulNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tata mamanka chayta nerkancu, judiocunata manchacuspa; yacharkancu pillapas Jesusta Cristo nejtaka, sinagoga wasimanta wijch'orkonancuta. ");
INSERT INTO qulNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Chayraycu tata mamanka nerkancu: ‘Tapuychis payta, achqha watayojña’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Judiocuna ñausamanta alliyachiskata ujtawan wajaspa, nerkancu: —Diospaj ñaupakenpi verdadta niwaycu. Nokaycu yachaycu chay runaka juchasapa caskanta. ");
INSERT INTO qulNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Paytaj contestarkan: —Mana yachanichu juchasapachus manachus chayta. Ujllata yachani: ñausa carkani, cunantaj ricucuni. ");
INSERT INTO qulNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Tapullarkancutaj: —¿Imanasunquitaj? ¿Imatataj ruwasunqui ricunayquipaj? ");
INSERT INTO qulNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Contestarkan: —Ña niyquichisña. Mana creewajtiyquichisri, ¿imapajtaj ujtawan willanayta munanquichisri? ¿Kancunapas paypaj discípulon caytachu munanquichis? ");
INSERT INTO qulNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Chayta nejtin, insultaspa nerkancu: —Kan chay runapaj discípulon canqui; nokaycoka Moisespaj discípulon caycu. ");
INSERT INTO qulNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nokaycu yachaycu Dios Moisesman parlaskanta. Chay runamantataj ni maymanta llojsimuskallantapas yachaycuchu. ");
INSERT INTO qulNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Runataj contestarkan: —¡Musphana jina! Kancuna mana yachanquichischu maymanta llojsimuskanta, nokatataj ñausamanta khawachiwan. ");
INSERT INTO qulNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Allinta yachanchis Dios mana uyariskanta juchasapacunataka, manachayri payta adorajta munaynin ruwajllata uyarin. ");
INSERT INTO qulNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Jayc'ajpas uyaricojchu ni pimantapas nejtaka: ‘Ñausa nacejta khawachin’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Cay runa mana Diosmanta caspaka, ima ruwaytapas atinmanchu. ");
INSERT INTO qulNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Paycunataj nerkancu: —Kanka jucha atipaska nacerkanqui. ¿Kanchu nokaycuta yachachiwanquichisman? Sinagogamantataj katerkorkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesús yacharkan chay runata katerkoskancuta. Taripaspataj nerkan: —¿Creenquichu Tataj Churinpi? ");
INSERT INTO qulNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Paytaj nerkan: —Señor, niway, ¿pitaj chayri, paypi creenaypaj? ");
INSERT INTO qulNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesús nerkan: —Ña payta ricunquiña; noka cani, kanwan parlachcaj. ");
INSERT INTO qulNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Jesuspaj ñaupakenpi konkoriycuspa, nerkan: —Creeni, Señor. ");
INSERT INTO qulNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesustaj nerkan: —Noka cay pachaman jamuni juicio ruwanaypaj, ñausacuna ricunancupaj, ricojcunataj ñausaman tucunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Waquin fariseocuna paywan cachcaj, chayta uyarispa taporkancu: —¿Nokaycupas ñausachu caycu? ");
INSERT INTO qulNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesús contestarkan: —Ñausa cawajchis chayka, mana juchayojchu cawajchis. ‘Mana ñausachu caycu’ niskayquichisraycutaj, juchayoj canquichis. ");
INSERT INTO qulNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesús nerkan: “Segurayquichis, pipas ovejacunapaj canchanman mana puncunta yaycojka, manachayri wajninta yaycun, chayka suwa. ");
INSERT INTO qulNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Puncunta yaycojka ovejata michej, cuidajtaj. ");
INSERT INTO qulNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Puncu cuidaj quichan, michejtaj ovejancunata sutinmanta wajan, canchamanta llojsichinanpaj. Ovejancunataj wajaskanta rejsincu. ");
INSERT INTO qulNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tucuyña llojsejtincu, ñaupakencuta purin. Ovejacunataj katincu wajaskanta rejsiskancuraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Mana rejsiskataka mana katincuchu, manachayri escaparancu, wajaskan mana rejsiska caskanraycu.” ");
INSERT INTO qulNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús cay ejemplota churarkan; paycunataj mana entenderkancuchu ima niy munaskanta. ");
INSERT INTO qulNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jesús ujtawan nillarkantaj: “Segurayquichis, noka puncu cani, ovejacunapaj yaycunan. ");
INSERT INTO qulNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nokamanta ñaupajta jamojcunaka suwacuna cancu, ovejacunataj mana casuncuchu. ");
INSERT INTO qulNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Noka puncu cani. Nokajnin yaycojlla salvaska canka. Imaynatachus uj ovejaka yaycun, llojsin, pastotataj tarin, chay jina canka. ");
INSERT INTO qulNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Suwaka jamun suwananpaj, wañuchinanpaj, ñut'unanpaj. Nokacajka jamuni causayniyoj canancupaj, astawanraj causayniyoj canancupaj. ");
INSERT INTO qulNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Noka cani sumaj michejka. Sumaj michej caspataj, causayniyta koni ovejaycuna wiñaypaj causanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Kolkellamanta cuidajcajka sajra lobo jamojtin, ovejacunata sakerparispa escapan, mana michej caskanraycu, ovejacuna mana paypajta caskanraycu. Sajra lobotaj ovejacunata jap'in, tucuynejmantaj t'ipirachin. ");
INSERT INTO qulNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Chay cuidajka escapan. Paymanka kolkella importan, manataj ovejacunachu. ");
INSERT INTO qulNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Noka sumaj michej cani. Ovejaycunata rejsini, nokatataj rejsiwancu, ");
INSERT INTO qulNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","imaynatachus Dios Tata rejsiwan, nokapas Tatayta rejsini, ajinata. Noka ovejaycunaraycu causayniyta koni. ");
INSERT INTO qulNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Waj ovejaycuna callantaj, mana cay canchamantachu. Paycunatapas pusamunallaytaj; paycunaka casuwankacu. Uj tropalla canka, uj michejniyojlla. ");
INSERT INTO qulNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Causayniyta koni wajmanta causarimunaypaj, chayraycu Tatay munacuwan. ");
INSERT INTO qulNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mana pipas causayniyta kechuwanchu, manachayri munayniymanta koni. Atiyniyoj cani causayniyta konaypaj, wajmanta causarinaypajpas. Cayta Tatay mandawan.” ");
INSERT INTO qulNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Judiocunataj chayta uyarispa, ujtawan iscayman tucorkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Achqhayoj paycuna uqhumanta nerkancu: —¿Imapajtaj casunquichis? Payka sajra espirituyoj, loco. ");
INSERT INTO qulNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Waquincunataj nerkancu: —Sajra espirituyojka mana chay jinata parlanmanchu. Sajra espirituyojri, ¿ñausata khawatatachinmanchu? ");
INSERT INTO qulNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jerusalenpi templopaj p'unchaynin fiestata ruwachcarkancu; chiri tiempo carkan. ");
INSERT INTO qulNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesús templopi cachcaspa, puriycachachcarkan Salomón niska puncu chhicapi. ");
INSERT INTO qulNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Judiocunataj muyuycuspa taporkancu: —¿Jayc'ajcamataj iscayrayachiwanquichis? Cristo canqui chayka, ujpita willawaycu. ");
INSERT INTO qulNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesús contestarkan: —Willarkayquichisña, manataj creewanquichischu. Tucuy imata ruwani Tataypaj atiyninwan. Chay sut'inta willacun Cristo caskayta. ");
INSERT INTO qulNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kancunataj mana creenquichischu, mana ovejaychu canquichis chayraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ovejaycunaka wajaskayta rejsincu; noka paycunata rejsini. Paycunataj khepayta jamuncu. ");
INSERT INTO qulNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Noka paycunaman wiñay causayta koni. Chayraycu jayc'ajpas infiernopi sufrenkacuchu, ni pipas nokamanta kechuwankacuchu. ");
INSERT INTO qulNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ovejacunata kowaj Tatayka tucuymanta nejtin astawan curaj. Ni pipas paymanta kechuyta atincumanchu. ");
INSERT INTO qulNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nokawan Dios Tataywan ujlla caycu. ");
INSERT INTO qulNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Judiocunaka ujtawan rumita okharispa, Jesusta chhokayta munarkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesustaj paycunata nerkan: —Tataypaj atiyninwan achqha sumaj milagrocunata ruwani ñaupakeyquichispi. ¿Mayken ruwaskaymantataj chhokawanquichis? ");
INSERT INTO qulNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Judiocunataj nerkancu: —Ni mayken allin ruwaskayquimanta chhokaskayquichischu, manachayri Dios contra parlaskayquimanta. Kan runalla cachcaspa, parlachcanqui Dios quiquinpas cawaj jinata. ");
INSERT INTO qulNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesustaj contestarkan: —Leyniyquichispi escribiska cachcan: ‘Noka nini, dioscuna canquichis.’ ");
INSERT INTO qulNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Yachanchis, Escriturapaj niskanta mana negayta atichuwanchu. ‘Dioscuna’ nispaka, Dios willaska palabranta jap'ekaj runacunamanta parlarkan. ");
INSERT INTO qulNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Dios ajllawaspa, cay pachaman cachamuwarkan. ¿Imaynatataj kancuna niwanquichis: ‘Dios contra parlan’ nispa, ‘Diospaj Churin cani’ nejtiy? ");
INSERT INTO qulNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Tataypaj ruwanancunata mana ruwanichu chayka, ama creewaychischu. ");
INSERT INTO qulNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ruwani chhicari, amapas creewaychischu, chaywanpas ruwaskaycunata creeychis, ujpita yachanayquichispaj Tata nokapi caskanta, nokataj Tatapi caskayta. ");
INSERT INTO qulNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ujtawan jap'iyta munajtincutaj, Jesús escaparkan. ");
INSERT INTO qulNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jesús cutiporkan inti llojsimunan Jordán mayu chimpaman, ñaupaj Juan Bautista bautizachcarkan chay lugarman. Quedacorkantaj chaypi. ");
INSERT INTO qulNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Achqha runa ricunancupaj purerkancu, nerkancutaj: —Ciertopuni, Juanka ima milagrotapas ruwarkanchu, chaywanpas cay runamanta niskanka verdad carkan. ");
INSERT INTO qulNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Chay lugarpi achqhayoj Jesuspi creerkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betaniamanta caj uj runa, Lázaro sutiyoj, onkoska carkan, chay llajtallamantataj panancunapas, María Martapiwan. ");
INSERT INTO qulNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Cay Lazaropaj panan María, Señor Jesuspaj chaquincunata sumaj k'apayniyoj perfumewan jawerkan; chujchancunawantaj ch'aquicherkan. ");
INSERT INTO qulNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Iscaynin panancuna Jesusman willachimorkancu: —Señor, amigoyqui onkoska —nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesús chayta uyarispa, nerkan: —Chay onkoyka mana wañunanpajchu, manachayri Dios Tata Churinpas honrawan alabaska cananpaj. ");
INSERT INTO qulNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús Martata, Mariata, Lazarotawan sinchita munacorkan. ");
INSERT INTO qulNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Chaywanpas ‘Lázaro onkoska’ nispa willajtincu, iscay p'unchaytaraj quedacorkan. ");
INSERT INTO qulNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Chhicamantaraj discipuloncunata nerkan: —Ujtawan Judeaman purisunchis. ");
INSERT INTO qulNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Discipuloncunataj nerkancu: —Yachachej, kaninpalla judiocunaka rumiwan chhokaspa wañuchiyta munarkasunquichis. ¿Ujtawanchu jakayman puriyta munachcallanquitaj? ");
INSERT INTO qulNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesús contestarkan: —¿Manachu uj p'unchayri chunca iscay horayoj? P'unchaypi purejka mana mitc'anchu, cay pacha c'anchaypi puriskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Tutapi purejka mitc'an, mana c'anchay caskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nillarkantaj: —Amigonchis Lázaro puñupun. Rijch'achimusaj. ");
INSERT INTO qulNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Discipuloncunataj nerkancu: —Señor, puñupun chayka, alliyachcaskanta ricuchin. ");
INSERT INTO qulNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesuspaj niskantaj niyta munarkan Lázaro wañupuskanta. Discipuloncunataj pensachcarkancu puñuchcaskallanta. ");
INSERT INTO qulNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Chayraycu Jesús sut'incharkan: —Lazaroka wañupun. ");
INSERT INTO qulNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Kancunaraycu cusicuni mana chaypi caskaymanta, astawan creenayquichispaj. Jacu, khawamusunchis. ");
INSERT INTO qulNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Mellizo sutiyoj Tomás discipulocunaman nerkan: —Nokanchispas purisunchis, paywan cusca wañunanchispaj. ");
INSERT INTO qulNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jesús chayamunanpajtaj Lazaroka tawa p'unchay p'ampaskaña caska. ");
INSERT INTO qulNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania llajtaka carkan quimsa kilómetro jinalla Jerusalenmanta. ");
INSERT INTO qulNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Achqhayoj judiocuna Martata Mariatawan watoj puriskacu, turan wañuskanmanta sonkochanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta Jesús chayamuchcaskanta yachaspa, taripaj lloserkan, Mariataj wasipi cachcarkan. ");
INSERT INTO qulNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta Jesusman nerkan: —Señor, caypichus cawaj carkan chayka, turayka mana wañunmanchu carkan. ");
INSERT INTO qulNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Chaywanpas noka yachani imatapas Diosmanta mañacojtiyqueka, pay konasunquita. ");
INSERT INTO qulNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesustaj payman nerkan: —Turayqueka causariponka. ");
INSERT INTO qulNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martataj nerkan: —Arí, yachani wañuskacuna causarina p'unchaypi causarimunancuta. ");
INSERT INTO qulNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesús payman nerkan: —Noka cani causarichicojka, causay kojpas. Nokapi creejka, wañuskapas cachun, causanka. ");
INSERT INTO qulNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Pipas causachcasparaj nokapi creejka, jayc'ajpas wañonkachu. ¿Chayta creenquichu? ");
INSERT INTO qulNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Martataj nerkan: —Arí, Señor, noka creeni: kan Cristo canqui, Diospaj Churin, cay pachaman jamunan carkan chay. ");
INSERT INTO qulNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Chayta nispa, Marta purerkan ñañan Mariata wajaj. Pacallamanta nerkan: —Yachachej caypi cachcan, wajasunqui. ");
INSERT INTO qulNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mariataj uyariytawan sayarispa, Jesusman purerkan. ");
INSERT INTO qulNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús manaraj llajtaman yaycuskachu; Martawan tupaskan lugarpi cachcarkan. ");
INSERT INTO qulNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mariata uskhayta sayarispa llojsiskanta ricuspa, compañaj judiocuna katerkancu, sepulturaman wakaj puriskanta pensaspa. ");
INSERT INTO qulNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","María Jesuspajman chayaspa, ñaupakenpi konkoriycuspa nerkan: —Señor, caypichus cawaj carkan chayka, turayka mana wañunmanchu carkan. ");
INSERT INTO qulNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Mariata paywan cusca chayamoj judiocunatawan wakajta ricuspa, Jesús sinchita llaquicorkan, sonkontaj wawayarkan. ");
INSERT INTO qulNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Paycunata taporkan: —¿Maypitaj p'ampanquichis? Nerkancutaj: —Señor, jamuy ricoj. ");
INSERT INTO qulNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesustaj wakarkan. ");
INSERT INTO qulNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Chhicari judiocuna nerkancu: —¡Khawariychis, sinchita payta munacun! ");
INSERT INTO qulNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Waquincunataj nerkancu: —Cay ñausata khawatatachejri, ¿manachu imatapas ruwayta atinman carkan Lázaro ama wañunanpaj? ");
INSERT INTO qulNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús ujtawan sonko wawayaska, sepulturaman chimparkan. Uj jutc'u carkan, puncun uj rumiwan tapaska. ");
INSERT INTO qulNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesús nerkan: —Cay rumita okhariychis. Wañojpaj panan Martataj nerkan: —Señor, asnachcanñachari. Tawa p'unchayña wañuskanka. ");
INSERT INTO qulNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesús payman contestarkan: —¿Manachu nerkayqui, creespa Diospaj glorioso atiyninta ricunayquita? ");
INSERT INTO qulNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Rumita okharerkancu. Jesustaj janaj pachata khawarispa nerkan: —Dios Tatáy, graciasta koyqui uyariwaskayquimanta. ");
INSERT INTO qulNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yachani kan uyariwaskayquitapuni; ajinata niyqui caypi cachcaj runacunapaj allinninpaj, kan cachamuwaskayquita creenancupaj. ");
INSERT INTO qulNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Chayta niytawantaj, alto vozwan nerkan: —¡Lázaro, chaymanta llojsimuy! ");
INSERT INTO qulNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Wañuska Lazarotaj llojsimorkan, maquincuna chaquincunapas vendawan p'istuska, uyanpas umantin pañowan p'istuycuska. Jesús paycunata nerkan: —Pascaraychis purinanpaj. ");
INSERT INTO qulNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Chayraycu Mariata compañaj achqha judiocuna Jesuspaj ruwaskanta ricuspa, Jesuspi creerkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Waquin judiocunataj fariseocunaman willaj purerkancu Jesuspaj ruwaskanmanta. ");
INSERT INTO qulNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Fariseocuna sacerdotecunapaj jefencunapiwan Athun Asambleapi tantacuspa, nerkancu: —¿Imatataj ruwasunchis? Cay runaka achqha milagrocunata ruwachcan. ");
INSERT INTO qulNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Jina ruwajta sakesun chayka, tucuy paypi creenkacu. Romano autoridadcunataj jamuspa, templonchista nacionninchistawan ñut'onkacu. ");
INSERT INTO qulNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Paycunamanta ujnin Caifás carkan, chay watapi curaj sacerdote. Nerkantaj: —Kancuna mana yachanquichischu ni imatapas; ");
INSERT INTO qulNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ni reparacunquichispaschu allin kancunapaj uj runalla llajtaraycu wañunan caskanta, tucuy nación ñut'uska cananmanta nejtenka. ");
INSERT INTO qulNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Caifastaj mana payllamantachu cayta nerkan, manachayri chay watapi curaj sacerdote caskanraycu Dios parlacherkan Jesús judío nacionpaj wañunanmanta, ");
INSERT INTO qulNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","manataj cay nacionllapajchu, manachayri tucuy t'acaska Diospaj wawancunata tantaycunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Chay p'unchaymantapacha tucuynincu judío autoridadcuna allinta quedarkancu Jesusta wañuchinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Chayraycu Jesuska manaña judiocuna uqhupi sut'inta puriycacharkanchu; manachayri llojsiporkan Judeamanta. Puriporkantaj ch'usaj lugar kayllata, Efraín sutiyoj llajtaman. Chaypi quedacorkan discipuloncunawan. ");
INSERT INTO qulNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Judiocunapaj Pascua fiestancu kayllaña carkan. Achqha runacuna llajtancunamanta Jerusalenman purichcarkancu, Pascua ñaupajta limpiochacuna costumbreta ruwanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jesusta masc'aspa uj ujcuna templopi tapunacorkancu: —¿Imaynataj yuyacusunqui? ¿Fiestaman jamonkachu icha manachu? —nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Fariseocuna sacerdotecunapaj jefencunapiwan mandacuskacu, pipas Jesús maypi caskanta yachaspa, willananta Jesusta jap'inancupaj. ");
INSERT INTO qulNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Sojta p'unchayraj Pascua fiestapaj cachcajtin, Jesús Betaniaman purerkan, causarichiskan Lazaropaj tiyaskanman. ");
INSERT INTO qulNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Chaypitaj Jesusta alabanapaj cenata waquicherkancu. Marta sirvichcarkan, Lazarotaj Jesuswan mesapi miqhuchcarkan. ");
INSERT INTO qulNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","María apamorkan cusca litrota jina mana chhajruska nardomanta sinchi valorniyoj k'apaj perfumeta. Jesuspaj chaquincunata jawispa, chujchancunawan ch'aquicherkan. Perfumepaj k'apaynintaj wasitapacha junt'aycorkan. ");
INSERT INTO qulNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Discipuloncunamanta ujnin, Jesusta vendiycoj Judas Iscariote, nerkan: ");
INSERT INTO qulNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Imaraycutaj cay perfumeta mana vendinchu quimsa pachaj kolkepi, pobrecunata yanapanapaj? ");
INSERT INTO qulNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Chayta nerkan mana pobrecuna payman importaskanraycuchu, manachayri suwa carkan. Kolke wakaychaj caspa, chaymanta suwacoj carkan. ");
INSERT INTO qulNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesús payman nerkan: —Dejallay. P'ampacunay p'unchaypaj waquichichcawan. ");
INSERT INTO qulNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Pobrecunaka kancunawanpuni cankacu. Nokataj manaña kancunawanpunichu casaj. ");
INSERT INTO qulNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Achqha judiocuna Jesús Betania llajtapi cachcaskanta yachaspa, chayman purerkancu, Jesusta paypaj causarichiskan Lazarotawan ricunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Sacerdotecunapaj jefencuna rimanacorkancu Lazarotawan wañuchinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Paypaj causariskanraycu, achqhayoj judiocuna Jesuspi creespa sacerdotecunamanta t'ipekacuchcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Achqha runacuna Jerusalenman puriskacu Pascua fiesta ruwanancupaj. K'ayantintaj yacharkancu Jesús llajtaman chayamunanta. ");
INSERT INTO qulNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Palmeracunata p'ataspa, Jesusta jap'ekaj llojsimorkancu, wajach'acorkancutaj: —¡Gloria! ¡Alabaska, bendiciska cachun Señorpaj sutinpi jamoj, Israelpaj Reynin! ");
INSERT INTO qulNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesús uj malta asnota tarispa, chaypi sillaycorkan Escriturapaj niskanman jina: ");
INSERT INTO qulNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ama manchacuychischu, Sión llajtayojcuna. Khawariychis, Reyniyquichis jamun uj malta asnito sillapi.” ");
INSERT INTO qulNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Discipuloncunaka manaraj caycunata entenderkancuchu. Jesús janaj pachaman purejtinraj, yuyarerkancu tucuy cay pasaskanta paymanta escribiska caskanta. ");
INSERT INTO qulNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lazarota wañuskamanta causarichiskanta ricojcuna willachcarkancu ricuskancuta. ");
INSERT INTO qulNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Chayraycu runacunaka llojsimorkancu Jesusta taripaj, milagro ruwaskanmanta yachaspa. ");
INSERT INTO qulNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Fariseocunaka ninacorkancu: —Jina cajtenka, ni imatapas ruwayta atisunchischu. ¡Khawariychis, tucuy runacuna paywan puripuchcan! ");
INSERT INTO qulNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Jerusalenpi Pascua fiestapi Diosta adorajcuna uqhupi waquin griegocuna cachcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Caycuna chimpaycuspa, Galileapi caj Betsaida llajtayoj Felipeta rogarkancu: —Señor, Jesusta ricuyta munaycu —nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Felipetaj purispa, Andresman willamorkan, iscaynincutaj purispa Jesusman willamorkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesús nerkan: —Tataj Churin wañunan hora chayamunña. ");
INSERT INTO qulNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Segurayquichis, uj trigo muju jallp'api tarpojtin mana wañunchu chayka, sapallan quedan. Wañun chayri, achqha ajthapicun. ");
INSERT INTO qulNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Causaynillanta munacojka chincachenka; cay pachapi causayninta mana casurajka wiñay causaypaj wakaychanka. ");
INSERT INTO qulNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Pipas sirviway munajka nokawan purichun. Maypichus noka casaj, chayllapitaj sirvejneyka canka. Maykenpas sirviwajtaka Tatay honranka. ");
INSERT INTO qulNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“¡Cay rato sinchi llaquiska cani chaywanpas! ¿Imanisajtaj? ¿Nisajchu: ‘Tatáy, cay llaquicuymanta libraway’? ¡Manachu, chaypajpuni jamuni! ");
INSERT INTO qulNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tatáy, sutiyquita honray. Janaj pachamantataj uj voz uyaricamorkan nispa: “Honraniña, ujtawan honrallasajtaj.” ");
INSERT INTO qulNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Chaypi uyarejcunataj nerkancu: —Rayo suenan —nispa. Waquincunataj nerkancu: —Uj ángel parlamun —nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesús nerkan: —Mana nokaraycuchu cay voz uyaricamun, manachayri kancunaraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Cunan rato mana creejcuna juchachaska cankacu; cay pachapi mandacoj supaypas katerkoska canka. ");
INSERT INTO qulNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Tataj Churin chacataska caspa, tucuy runata pay quiquinman apamonka. ");
INSERT INTO qulNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jesús cayta nispa entendicherkan imaynatachus wañunanmanta. ");
INSERT INTO qulNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Runacunataj contestarkancu: —Nokaycu leymanta yachaycu Cristoka wiñaypaj causananta. ¿Imaynatataj kan ninqui, Tataj Churin chacataska cananta? ¿Pitaj chay Tataj Churinri? ");
INSERT INTO qulNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesús nerkan: —Kancuna uqhupiraj c'anchay canka pisi p'unchaycunallataña. Puriychis, ari, c'anchay cachcajtinraj, ama tutayay jap'inasunquichispaj. Tutayajpi purejcunaka mana yachancuchu mayta puriskancuta. ");
INSERT INTO qulNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","C'anchayraj cachcajtenka, c'anchaypi creeychis, c'anchaypi causanayquichispaj. Cayta niytawan, Jesús puripuspa paycunamanta pacaycucorkan. ");
INSERT INTO qulNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesús athun milagrocunata ñaupakencupi ruwaska chaywanpas, judiocunaka mana paypi creerkancuchu, ");
INSERT INTO qulNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","profeta Isaiaspaj escribiskan junt'acunan caskanraycu: “Señor, ¿pitaj willaskaycuta creen? ¿Pimantaj Señorpaj atiynin ricuchiska carkan?” ");
INSERT INTO qulNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ajinaka mana creeyta aterkancuchu, Isaías escribillarkantaj: ");
INSERT INTO qulNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Dios ñawincuta ñausayacherkan, sonkoncutataj rumiyacherkan, mana ricunancupaj, ni entendinancupaj, mana nokaman cutirimunancupaj, nokataj mana alliyachinaypaj.” ");
INSERT INTO qulNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías cayta nerkan Jesuspaj sumaj glorianta ricuskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Chaywanpas, achqha judiocuna Jesuspi creerkancu, astawan curaj cajcunantin. Fariseocunatataj manchacuskancuraycu mana sut'inchacuskacuchu, sinagogacunamanta mana wijch'orkoska canancupaj. ");
INSERT INTO qulNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Runacunallamanta honorta jap'ekayta munarkancu, Diosmanta jap'ekaytapachaka. ");
INSERT INTO qulNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesús alto vozwan nerkan: “Pichus nokapi creejka mana nokallapichu creen, manachayri cachamuwaj Tataypi. ");
INSERT INTO qulNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nokata ricuwajka cachamuwajniyta ricullantaj. ");
INSERT INTO qulNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Noka c'anchay cani. Cay pachaman jamuni, tucuy nokapi creejcuna mana tutayajpi canancupaj. ");
INSERT INTO qulNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Pichus palabrayta uyarispa mana casucojtaka mana nokachu juchachasaj. Mana runacunata juchachajchu jamuni, manachayri salvaj. ");
INSERT INTO qulNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nokata despreciawaspa palabrayta mana casucojpajka, canña pi juchachaj. Tucucuy p'unchaypi nokapaj parlaskaycuna juchachanka. ");
INSERT INTO qulNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mana nokallamantachu parlani; manachayri cachamuwaj Tataypaj mandawaskanta parlani, yachachinitaj. ");
INSERT INTO qulNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Yachani Tataypaj mandawaskanka wiñay causaypaj caskanta. Ajina ari, nokapaj parlaskayka Tatapaj mandawaskanman jina.” ");
INSERT INTO qulNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Uj p'unchayllaña Pascua fiestapaj cachcajtin, Jesús yachacorkanña cay pachamanta Tatanman cutipunan p'unchayña caskanta. Cay pachapi discipuloncunata munacorkanpuni, jinallatataj munacorkan tucucuycama. ");
INSERT INTO qulNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Cenata miqhuchcajtincu, Simonpaj churin Judas Iscariotepaj sonkonpi supay churaycuskaña Jesusta vendiycunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesús yacharkan Dios Tatamanta jamuskanta, ujtawan Dios Tataman cutipuchcaskantapas. Yachallarkantaj Tatan payman tucuy autoridadninta koskanta. ");
INSERT INTO qulNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ajinata, ari, miqhuchcajtincuraj, mesamanta sayarispa, pata p'achanta orkhocorkan, cinturanpi toallata wataycuspa. ");
INSERT INTO qulNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Bañadorpi unuta jich'aspa, discipuloncunapaj chaquincunata mayllayta kallarerkan. Cinturanpi caj toallawantaj ch'aquicherkan. ");
INSERT INTO qulNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Simón Pedropaj chaquincunata mayllananpaj chimpaycojtin, Pedroka nerkan: —Señor, ¿kanchu chaquiycunata mayllawanqui? ");
INSERT INTO qulNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesús contestarkan: —Cunan mana entendinquichu ruwachcaskayta, khepamantaj entendinqui. ");
INSERT INTO qulNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedrotaj nerkan: —¡Jayc'ajpas chaquiycunata mayllachicuskayquichu! Jesustaj nerkan: —Mana mayllaskayquichu chayka, mana nokapajtachu canqui. ");
INSERT INTO qulNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simón Pedrotaj nerkan: —Chhicaka, Señor, ¡ama chaquiycunallataka, manachayri maquiycunata umaytawan mayllaway! ");
INSERT INTO qulNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesustaj nerkan: —Mayllaskaña cajtaka chaquillantaña mayllana, imaraycuchus tucuy limpiochaskaña. Kancunataj limpio canquichis, chaywanpas mana tucuyniyquichischu. ");
INSERT INTO qulNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Nerkan: “Mana tucuyniyquichischu” nispa, pi payta vendiycunanta yachaskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Chaquicuna mayllay pasayta, Jesús pata p'achanta churaycucupuspa, ujtawan mesapi tiyaycuspa, paycunaman nerkan: —¿Entendinquichischu ruwaskayta? ");
INSERT INTO qulNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Kancuna niwanquichis: ‘Yachachej’, ‘Señor’ nispataj. Razonniyquichis can. Chaypuni cani. ");
INSERT INTO qulNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Noka, Yachachej, Señortaj cachcaspa, chaquiyquichiscunata mayllayquichis chayka, kancunapas jinallatataj chaquiyquichiscunata mayllanacuychis. ");
INSERT INTO qulNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Uj ejemplota koyquichis, quiquillantataj kancunapas ruwaskayta jina ruwanayquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Segurayquichis, mayken uywaskapas curajchu patronninmantaka, nitaj cachaskapas curajchu cachajninmantaka. ");
INSERT INTO qulNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Caycunata entendispa ruwachcanquichis chayka, cusicuyniyoj canquichis. ");
INSERT INTO qulNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Mana tucuyniyquichismantachu cayta nini. Noka yachani picunatachus ajllaskayta. Escriturapi niskanka junt'acunan can: ‘Nokawan miqhoj, noka contra tucupun.’ ");
INSERT INTO qulNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Manaraj pasachcajtin cayta niyquichis, pasajtintaj kancuna creewanquichis nokapuni Tataj Churin caskayta. ");
INSERT INTO qulNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Segurayquichis, nokapaj cachaskayta jep'ekajka nokata jap'ekawan. Nokata jap'ekawajri cachamuwajniyta jap'ekan. ");
INSERT INTO qulNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Chayta niytawan, Jesús sinchi llaquiska sonko wawayaska sut'incharkan nispa: —Segurayquichis, kancunamanta ujnin vendiycuwanquichis. ");
INSERT INTO qulNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Discipuloncunataj paycunapura khawanacorkancu, mana yachaspa pimanta parlaskanta. ");
INSERT INTO qulNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ujnin discípulo, Jesuspaj sinchi munaskan, ladonpi cachcarkan miqhuspa. ");
INSERT INTO qulNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Chayman Simón Pedro señaswan nerkan: “Tapuy pimantataj parlan” nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Paytaj Jesusman suchcataycuspa taporkan: —Señor, ¿pitajri? —nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesús contestarkan: —Pimanchus t'antata chapuspa jaywasaj, chay canka. Chaypacha t'antata chapuycuspa, Simonpaj churin Judas Iscarioteman jaywarkan. ");
INSERT INTO qulNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas t'antata jap'ekajtinpacha, supay Satanás sonkonman yaycorkan. Jesustaj payta nerkan: —Ruwanayquita, ruwallayña. ");
INSERT INTO qulNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Mesapi miqhojcunaka mana maykennincupas entenderkancuchu, imaraycuchus Judasman jinata niskanta. ");
INSERT INTO qulNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Waquinnincu pensarkancu, Judas Iscariote kolke wakaychaj caskanraycu, Jesús niy munaskanta, “Fiestapaj necesitaskanchista rantimuy”, chayri “Pobrecunaman komuy” nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judastaj t'antata jap'ekaytawan llojsiporkan; tutañataj carkan. ");
INSERT INTO qulNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas llojsipojtin, Jesús nerkan: —Cunanka Tataj Churinpaj glorioso honran ricuchiska canka; paypitaj Diospaj glorioso honran ricuchiska canka. ");
INSERT INTO qulNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Tataj Churin Dios Tatanpaj glorioso honranta ricuchin chayka, Dioska ricuchillankataj Churipaj glorioso honranta. Chaytataj ña ruwankaña. ");
INSERT INTO qulNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Churicitoycuna, manaña achqha tiempochu kancunawan casaj, masc'awanquichistaj. Imaynatachus judiocunaman nerkani, quiquillantataj kancunamanpas cunanka nillayquichistaj: ‘Maytachus purisaj, chayman mana jamuyta atinquichischu.’ ");
INSERT INTO qulNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Koyquichis cay mosoj mandamientota: Uj ujcuna munanacuychis, noka munacuyquichis ajinata. ");
INSERT INTO qulNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Uj ujcuna jinata munanacunquichis chayka, tucuy runa yachankacu discipuloycuna caskayquichista. ");
INSERT INTO qulNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedro Jesusta taporkan: —Señor, ¿maytataj purichcanqui? Jesús contestarkan: —Maymanchus cunan purichcani, chayman mana puriyta atinquichu. Chay pasaytataj puriyta atinqui. ");
INSERT INTO qulNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedrotaj nerkan: —Señor, ¿imaraycutaj cunan mana kanwan puriyta atiymanchu? Kanraycu wañojpas listo cani. ");
INSERT INTO qulNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesús contestarkan: —¿Ciertochu nokaraycu wañojpas listo cachcanqui? Segurayqui, manaraj gallo wajach'acuchcajtin, quimsa cutita negawanqui. ");
INSERT INTO qulNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Ama llaquicuychischu; Diospi confiacuychis, nokapi confiacullaychistaj. ");
INSERT INTO qulNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Tataypaj wasinpi achqha lugarcuna can, chaypi causanapaj. Mana jina cajtenka, noka mana niyquichismanchu carkan: ‘Purisaj, kancunapaj lugarta waquichimusaj’ nispaka. ");
INSERT INTO qulNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Puripuspa, kancunapaj uj lugarta waquichispa, ujtawan jamusaj kancunata pusacapunaypaj, maypichus cachcani chayllapitaj kancunapas canayquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Yachanquichisña nokaman purej ñanta. ");
INSERT INTO qulNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomás Jesusman nerkan: —Señor, mana yachaycuchu mayta puriskayquita. ¿Imaynatataj yachaycuman ñantari? ");
INSERT INTO qulNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús payta nerkan: —Noka cani ñan, verdad, causaypas. Nokapi creespalla Tataypajman chayankacu. ");
INSERT INTO qulNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nokata rejsiwanquichis chayka, Tataytapas rejsillanquichistaj. Cunanmantapacha Dios Tatata rejsinquichisña, ricunquichisñataj. ");
INSERT INTO qulNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Felipe Jesusman nerkan: —Señor, Dios Tatata ricuchiwaycu. Chaywanka contento casajcu. ");
INSERT INTO qulNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesús contestarkan: —Felipe, achqha tiempo kancunawan cachcani. ¿Manarajchu rejsiwanqui? Nokata ricojka, Dios Tatata ricun. ¿Imaraycutaj ‘Dios Tatata ricuchiwaycu’ niwanqui? ");
INSERT INTO qulNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Manachu creenqui noka Tatapi caskayta, Tatataj nokapi caskanta? Niyquichis, tucuy ima niskaycunaka mana nokallamantachu, nokapi causaj Tata ruwananta ruwachcan. ");
INSERT INTO qulNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Creewaychis noka Tatapi caskayta, Tatataj nokapi caskanta. Niskayta mana creenquichis chaypas, creeychis ruwaskaycunallamantapas. ");
INSERT INTO qulNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Segurayquichis, nokapi creejka ruwaskaycunata ruwallankataj, astawan athun ruwaycunataraj ruwanka, Tatayman puripuskayraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Tucuy imata sutiypi mañacuskayquichista noka ruwasaj, Churi Tatanpaj glorioso honranta ricuchinanpaj. ");
INSERT INTO qulNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Imallatapas sutiypi mañacunquichis chayka, noka ruwasaj. ");
INSERT INTO qulNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Kancuna munacuwanquichis chayka, mandacuskaycunata casucuychis. ");
INSERT INTO qulNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nokataj Dios Tatamanta mañasaj waj Cuidajta cachamunasunquichispaj, kancunawanpuni cananpaj. ");
INSERT INTO qulNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Chay Cuidajka verdad Santo Espíritu. Paytataj mana creejcunaka mana jap'ekayta atincuchu, imaraycuchus mana ricuncuchu, nitaj rejsincuchu. Kancunaka payta rejsinquichisña, kancunawanpuni cachcaskanraycu. Kancunapipuni canka. ");
INSERT INTO qulNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Mana sapayquichista sakerpayaskayquichischu. Cutimusaj kancunawan canaypaj. ");
INSERT INTO qulNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Juch'uytawan Diospi mana creejcuna manaña ricuwankacuchu. Kancunacajka ricuwanquichis, causanquichistaj causaskayraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Jakay p'unchaypi reparacunquichis noka Tatapi caskayta, kancunataj nokapi caskayquichista, nokataj kancunapi caskayta. ");
INSERT INTO qulNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Mandacuskaycunata jap'ekaspa casucojka, ricuchicun verdadta munacuwaskanta. Munacuwajtaka Tatay munacullankataj, nokapas munacullasajtaj. Ricuchicusajtaj payman. ");
INSERT INTO qulNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Waj Judas payta taporkan: —Señor, ¿imaraycutaj nokaycullaman ricuchicunqui, manataj mana creejcunamanri? ");
INSERT INTO qulNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesús contestarkan: —Nokata munacuwajka palabrayta casucun, Tataytaj munaconka. Nokataj Tataypiwan paycunawan causaj jamusajcu. ");
INSERT INTO qulNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mana munacuwajka palabrayta mana casucunchu. Kancuna uyarichcawanquichis; chay niskay palabracunaka mana nokallamantachu, manachayri cachamuwaj Tataymanta. ");
INSERT INTO qulNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Tucuy caycunata nichcayquichis kancunawan cachcasparaj. ");
INSERT INTO qulNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Dios Tatay Cuidaj Santo Espirituta cachamonka sutiypi. Pay tucuy imata yachachisunquichis, tucuy niskaytataj yuyarichisunquichis. ");
INSERT INTO qulNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Puripuspa, sonko tiyaycuyta sakeskayquichis; sonko tiyaycuyniyta koyquichis, mana runacunapaj koskanta jinachu. Ama llaquicuychischu, nitaj manchacuychischu. ");
INSERT INTO qulNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Uyariwarkanquichisña, ‘Puripusaj, chaymanta cutimusaj kancunawan canaypaj’ chay niskayta. Ciertota munacuwanquichisman chayka, cusicuwajchis Dios Tataman puripuchcaskayta yachaspaka, imaraycuchus Tataka nokamanta curaj. ");
INSERT INTO qulNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Chaycunata niyquichis manaraj pasachcajtin, pasajtintaj creenayquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Manaña kancunawan sinchita parlasajchu. Cay pachapi mandacoj supay jamuchcanña. Chaywanpas mana imanaytapas nokata atiwanmanchu. ");
INSERT INTO qulNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ajina canan, Tatata munacuskayta paypaj mandaskantataj ruwaskayta runacuna yachananpaj. “Jataricapuychis. Jacuchis caymanta.” ");
INSERT INTO qulNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesús nillarkantaj: “Noka cani verdadero uva sach'a, Tataytaj llanc'aj. ");
INSERT INTO qulNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ujnin c'allmaychus mana urinmanchu chayka, p'atakaska canka. Urejtintaj, jallch'aska limpiochaskataj canka, astawan urinanpaj. ");
INSERT INTO qulNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kancunaka limpioña canquichis kancunaman niskay palabracunawan. ");
INSERT INTO qulNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nokapipuni cacuychis, imaynatachus nokapas kancunapi cacuni ajinata. Uj c'allmaka sapallan mana uriyta atinmanchu, mana uvapaj sach'anpi caspaka. Jinallatataj kancunapas mana nokapi caspaka, sumaj ruwaycunata uriyta mana atiwajchischu. ");
INSERT INTO qulNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Noka uva sach'a cani, kancunataj c'allmancuna canquichis. Pillapas nokawan ujlla cajka, nokataj paywan, chaylla achqhata urenka. Mana nokawanka mana imatapas ruwayta atiwajchischu. ");
INSERT INTO qulNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mana nokawan ujlla cajka, p'atakaska c'allma jina wijch'uska canka, ch'aquiponkataj. Tantaycuspa, ninaman wijch'uyconkacu ruphananpaj. ");
INSERT INTO qulNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Nokawanchus ujlla canquichis, yachachiskayman jina fiel purinquichispuni chayka, ima munaskayquichista mañacuychis, kosunquichistaj. ");
INSERT INTO qulNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kancuna achqha allincunata urejtiyquichis, Dios Tatay honorta jap'ekan. Jinapitaj canquichis verdadero discipuloycuna. ");
INSERT INTO qulNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Imaynatachus Dios Tata nokata munacuwan, ajinallatataj nokapas kancunata munacuyquichis. Munacuyniypi cacuychis, ari. ");
INSERT INTO qulNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Imaynatachus Tataypaj mandacuskancunata casucuni, munacuyninpitaj cani, ajinallatataj mandacuskaycunata casucunquichis chayka, munacuyniypi canquichis. ");
INSERT INTO qulNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Jinata niyquichis nokawan cusicunayquichispaj, cusicuyniyquichistaj junt'aska cananpaj. ");
INSERT INTO qulNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Caymi mandacuskayka: Kancuna uj ujcuna munanacuychis, imaynatachus noka kancunata munacuyquichis jinata. ");
INSERT INTO qulNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Mana astawan athun munacoyka canchu, amigonraycu wañojmanta nejtenka. ");
INSERT INTO qulNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kancunaka amigoycuna canquichis, mandacuskayta ruwajtiyquichiska. ");
INSERT INTO qulNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Manaña sirviente niskayquichischu, sirvienteka mana yachanchu patronninpaj ruwaskanta. Cunan amigoycuna niskayquichis, imaraycuchus yachachiyquichisña Tataypaj tucuy niwaskanta. ");
INSERT INTO qulNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mana kancunachu nokata ajllawanquichis, manachayri noka kancunata ajllayquichis. Cachayquichis achqha allin ruwaycunata urinayquichispaj, chay uritaj quedacunanpaj. Ajinapi Tataka tucuy imata sutiypi mañacuskayquichista kosunquichis. ");
INSERT INTO qulNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Cayta, ari, mandayquichis: Uj ujcuna munanacuychis. ");
INSERT INTO qulNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Mana creejcuna kancunata chejnisunquichis chayka, yachaychis ñaupajta nokata chejniwaskancuta. ");
INSERT INTO qulNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Mana creyente cawajchis chayka, mana creej runacunaka munacusunquichisman, imaynatachus amigocunata munacuncu jinata. Noka ajllayquichis mana creyente uqhumanta, chayraycu mana creyentecuna chejnisunquichis, creyenteña caskayquichisraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Yuyaricuychis cay niskayta: ‘Mayken sirvientepas patronninmantaka curajchu.’ Nokata ñac'arichiwancu chayka, kancunatapas ñac'arichillasunquichistaj. Sichus mana creejcuna palabrayta casuconkacu chayka, kancunapajtapas casullankacutaj. ");
INSERT INTO qulNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Tucuy cayta ruwasunquichis nokapi creeskayquichisraycu, cachamuwajniyta mana rejsiskancuraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Noka mana parlapayaj jamuyman carkan chayka, paycuna mana juchayojchu cancuman carkan. Cunanka manaña imapas ninancu canchu juchancumantaka. ");
INSERT INTO qulNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nokata chejniwajcunaka Tatayta chejnillancutaj. ");
INSERT INTO qulNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Juchayoj cancu, imaraycuchus paycuna uqhupi ruwani mana pipaj ruwaskanta. Chayta ricuspapas, nokata chejniwancu. Tataytapas chejnillancutaj. ");
INSERT INTO qulNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Cayka pasan, paycunapaj leynincupi escribiska cachcan chay junt'acunanpaj: ‘Chejniwancu kasillanmanta.’ ");
INSERT INTO qulNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Noka Tataymanta Cuidaj verdad Santo Espirituta cachamusaj. Pay jamuspa, willajniy canka. ");
INSERT INTO qulNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kancunapas nokamanta willallanquichistaj. Kallariymantapacha nokawan caskayquichisraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Caycunata niyquichis, nokapi creeyniyquichis mana chincananpaj. ");
INSERT INTO qulNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Sinagogacunamanta katerkosunquichis. Canmanraj pillapas kancunata wañuchispa, Diosta sirviskanta creecoj. ");
INSERT INTO qulNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Chayta ruwancuman, mana Tatata ni nokatapas rejsiskancuraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Caycunata niyquichis, pasajtin noka niskaytaña yuyarinayquichispaj. “Kallariymantapacha caycunata mana nerkayquichischu, kancunawan cachcaskayraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Cunanka purichcani cachamuwajniywan canaypaj. Maykenniyquichispas tapuwanquichischu mayta puriskayta. ");
INSERT INTO qulNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Astawanpas caycuna niskayraycu sinchita llaquicuchcanquichis. ");
INSERT INTO qulNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Verdadta niyquichis, noka puripunayka kancunapajka allin. Mana ripusaj chayka, Cuidaj mana jamonkachu kancunawan cananpaj. Ripuspaka, noka payta cachamusaj. ");
INSERT INTO qulNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Pay jamuspaka, runacunaman sut'inta ricuchenka juchancuta, justo cayta, Diospaj castigontawan. ");
INSERT INTO qulNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Nokapi mana creeskancuraycu juchancuta reparachenka. ");
INSERT INTO qulNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Justo cayta reparachenka Tatayman puripuskayraycu, kancunataj manaña ricuwanquichischu. ");
INSERT INTO qulNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Diospaj castigontataj reparachenka, cay pacha gobernaj supay juchachaskaña caskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Achqharaj kancunaman ninay cachcan. Cay rato sinchi achqha canman kancunapaj. ");
INSERT INTO qulNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Verdadniyoj Espíritu jamuspa, tucuy verdadwan yachachisunquichis. Mana parlankachu payllamantaka, manachayri Tatamanta tucuy uyariskanta yachachenka. Yachachisunquichis imacuna pasanantawan. ");
INSERT INTO qulNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Pay nokata honrawanka; nokamanta jap'ekaskanta kancunaman willasunquichis. ");
INSERT INTO qulNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tucuy ima Tatapaj cajnin nokallapajtaj; chayraycu nini Espíritu nokapaj cajta jap'ekaspa yachachinasunquichista. ");
INSERT INTO qulNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Juch'uytawan manaña ricuwanquichischu, juch'uytawantaj ujtawan ricullawanquichistaj.” ");
INSERT INTO qulNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Waquin discipuloncuna tapunacorkancu: —¿Ima niytataj munan ‘Juch'uytawan manaña ricuwanquichischu, juch'uytawantaj ujtawan ricullawanquichistaj’ nispari? ¿Ima niytataj munan ‘Tatayman purinay’ nispari? ");
INSERT INTO qulNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Ima niytataj munan ‘juch'uytawan’ nispari? Mana entendinchischu imamanta parlaskanta. ");
INSERT INTO qulNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesustaj tapucuyta munaskancuta yachaspa, paycunaman nerkan: —‘Juch'uytawan manaña ricuwanquichischu, juch'uytawantaj ujtawan ricullawanquichistaj’, ¿chay niskayraycuchu tapunacuchcanquichis? ");
INSERT INTO qulNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Segurayquichis, kancunaka wakanquichis. Llaquiska canquichis, mana bcreejcunataj cusiconkacu. Llaquiska cachcanquichis chaywanpas, llaquicuyniyquichis cusicuyman tuconka. ");
INSERT INTO qulNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Uj warmipaj onkocunan p'unchay chayamojtin, llaquicun. Wawa naciskan pasaymantataj, nanayninta konkapun uj wawa cay pachapi naciskanmanta cusicuskanwan. ");
INSERT INTO qulNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ajinallatataj kancunapas cunanka llaquicunquichis. Noka kancunaman cutimojtiy, sonkoyquichis cusicuywan junt'ayconka; chay cusicuyta ni pipas kechuyta atisunquichischu. ");
INSERT INTO qulNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Chay p'unchaypi manaña imatapas tapuwanquichischu. Segurayquichis, Tatay tucuy imata sutiypi mañacuskayquichista kosunquichis. ");
INSERT INTO qulNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Cunancama mana imatapas sutiypi mañacorkanquichischu. Mañacuychis, jap'ekanquichistaj cusicuyniyquichis junt'a cananpaj. ");
INSERT INTO qulNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ejemplocunawan caycunata niyquichis. Tiempo jamonka, manaña ejemplocunawan nisajchu, manachayri Tatamanta sut'inta nisaj. ");
INSERT INTO qulNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Chay tiempopi kancuna sutiypi mañacunquichis. Mana ninichu kancunapaj Tataman roganayta, ");
INSERT INTO qulNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","imaraycuchus Tata quiquin munacusunquichis. Munacusunquichis munacuwaskayquichisraycu, Tatamanta jamuskayta creeskayquichisraycupiwan. ");
INSERT INTO qulNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Dios Tatamanta llojsimuni cay pachaman jamunaypaj; cunantaj cay pachata sakespa, Tataman cutipusaj. ");
INSERT INTO qulNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Discipuloncunataj nerkancu: —Cunanka arí, sut'inta parlachcanqui, manataj ejemplocunawanchu. ");
INSERT INTO qulNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Cunan yachaycu tucuy imata yachaskayquita, manataj pitapas tapunayqui canchu. Chayraycu creeycu Dios Tatamanta jamuskayquita. ");
INSERT INTO qulNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesustaj nerkan: —¿Cunanri creenquichischu? ");
INSERT INTO qulNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Tiempo chayamunña, chaytaj cunitan. Sapa uj ripuranquichis, sapaytataj sakepuwanquichis. Manataj sapaychu cachcani, Tatay nokawan cachcan. ");
INSERT INTO qulNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Caycunata niyquichis, nokawan ujlla cachcaspa sonko tiyaska canayquichispaj. Cay pachapi ñac'arinquichis, chaywanpas animacuychis, noka atipaniña sajracunata. ");
INSERT INTO qulNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesús, caycunata niy pasayta, janaj pachata khawarispa nerkan: “Tatáy, wañuna hora chayamunña. Nokata, Churiyquita, gloriawan honray, kantapas Churiyqui gloriawan honrananpaj. ");
INSERT INTO qulNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Noka Churiyquiman atiyta kowanqui tucuy runata mandanaypaj, tucuy koskayqui creejcunaman wiñay causayta konaypaj. ");
INSERT INTO qulNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kanta, ch'ulla verdadero Diosta, cachamuskayqui Jesucristotawan rejsejcunacajka wiñay causayniyoj cancu. ");
INSERT INTO qulNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Cay pachapi noka gloriawan honrayqui. Ruwana kowaskayquita tucuchaniña. ");
INSERT INTO qulNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Cunan ari, Tatáy, gloriawan honraway ñaupakeyquipi, manaraj cay pacha cachcajtin, glorioso honorniy carkan chay quiquin honorwan. ");
INSERT INTO qulNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Konawayquipaj ajllaskayquicunaman yachachiniña pi caskayquita. Kanpajta carkancu, nokamantaj kowanqui, palabrayquitataj casucuncu. ");
INSERT INTO qulNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Cunan yachancu tucuy ima ruwaskayka niskaypas kanmanta caskanta. ");
INSERT INTO qulNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Palabrayquita willaniña, paycunataj jap'ekancu. Reparacuncu ciertopuni kanmanta jamuskayta, creencutaj kan cachamuwaskayquita. ");
INSERT INTO qulNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Paycunapaj mañacuyqui, mana mana creejcunapajchu, manachayri kowaskayquicunapaj, kanpajta caskancuraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tucuy nokapajta cajka kanpajta, kanpajta cajcunataj nokapajta. Paycunapitaj honrayka ricuchicun. ");
INSERT INTO qulNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Noka mana cay pachapiñachu casaj, paycunataj cay pachapiraj cankacu. Kanwan canaypaj purisaj. Santo Tatáy, sutiyquipaj atiyninwan, kowaskayqui sutiwan nokapi creejcunata cuiday, ujllapuni canancupaj imaynachus kan nokawan ujlla canchis jinata. ");
INSERT INTO qulNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Noka cay pachapi paycunawan cachcaspa cuidarkani, wakaycharkanitaj kowaskayqui sutiyquipaj atiyninwan. Maykennincupas chincanchu, manachayri chincaskaña carkan chaylla, Escriturapaj niskan junt'acunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Cunanka kanman jamusaj. Caypi cachcasparaj caycunata nini, noka quiquiypaj cusicuyniywan junt'aska canancupaj. ");
INSERT INTO qulNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Palabrayquita paycunaman willaniña. Mana creejcuna paycunata chejnincu, mana paycuna jina caskancuraycu. Nokapas mana paycuna jinachu cani. ");
INSERT INTO qulNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nokapi creejcunata mana cay pachamanta orkhonayquipajchu mañayqui, manachayri mana allincunamanta wakaychanayquipaj. ");
INSERT INTO qulNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Imaynatachus noka mana cay pachamantachu cani, paycunapas mana cay pachamantachu cancu. ");
INSERT INTO qulNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Kan quiquillayquipaj ch'uwanchay verdadwan. Palabrayqueka verdad. ");
INSERT INTO qulNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Imaynatachus caypi caj runacunaman cachamuwarkanqui, ajinallatataj paycunata cachani manaraj creej runacunaman. ");
INSERT INTO qulNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Paycunaraycu noka quiquiy churacuni, paycunapas verdadwan kanllapaj causanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Mana paycunallapajchu mañacuyqui, manachayri paycunapaj willaskanta uyarispa nokapi creenkacu chaycunapajpiwan. ");
INSERT INTO qulNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mañacuyqui, tucuynin creejcuna ujllapuni canancupaj, nokanchiswanpas ujlla canancupaj. Oh Tatáy, imaynatachus kan nokapi cachcanqui, nokataj kanpi jinata, ujllapuni cachuncu, runacuna cachamuwaskayquita creenancupaj. ");
INSERT INTO qulNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Quiquin glorioso honor kowaskayquita paycunaman koni, imaynatachus kan nokawan ujlla canchis jinata ujlla canancupaj, ");
INSERT INTO qulNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","noka paycunapi, kantaj nokapi, ajinapi ujllapuni canancupaj, runacunataj cachamuwaskayquita reparacunancupaj, paycunatapas munacuskayquita nokata jina. ");
INSERT INTO qulNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tatáy, paycunata kowanqui. Munani maypichus noka casaj chaypi canancuta, kowaskayqui honorniyta gloriaytawan ricunancupaj. Manaraj cay pacha cachcajtin, munacuwarkanqui. ");
INSERT INTO qulNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Justo Tatáy, mana creejcuna mana rejsisunquichischu; nokaka rejsiyqui, caycunapas cachamuwaskayquita yachancu. ");
INSERT INTO qulNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Caycunaman yachachini pichus caskayquita, yachachichcaniraj munacuwaskayqui paycunapi cananpaj, noka quiquiypas paycunapi canaypaj.” ");
INSERT INTO qulNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Caycunata niytawan, Jesús discipuloncunawan llojsiporkan Cedrón niska wayk'o chimpaman. Chaypi uj huerto carkan. Chayman Jesús discipuloncunawan yaycorkan. ");
INSERT INTO qulNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Vendiycoj Judaspas chay lugarta rejsillarkantaj, chaypi achqha cuti Jesús discipuloncunawan tantacoj caskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ajinapi Judaska chayamorkan soldadocunawan, sacerdotecunapaj jefencunawan, fariseocunapaj cachaskan templo guardiajcunapiwan. Armaska cachcarkancu, c'anchaycunata c'aspipi nina lauray jap'ichiskacunatawan apariska. ");
INSERT INTO qulNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesús yacharkanña tucuy ima pasananta. Paycunata taripamuspa, taporkan: —¿Pitataj masc'anquichis? ");
INSERT INTO qulNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Paycunataj contestarkancu: —Nazaret llajtayoj Jesusta. Jesustaj nerkan: —Noka cani. Vendiycoj Judastaj chaypi paycunawan cachcarkan. ");
INSERT INTO qulNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesús “Noka cani” nejtin, khepaman urmararkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesús ujtawan taporkan: —¿Pitataj masc'anquichis? Paycunataj nillarkancutaj: —Nazaret llajtayoj Jesusta. ");
INSERT INTO qulNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesús ujtawan nillarkantaj: —Niyquichisña ‘Noka cani’ nispa. Nokata masc'awanquichis chayka, caycunata dejaychis puripojta. ");
INSERT INTO qulNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Cayka pasarkan Jesús quiquinpaj niskan junt'acunanpaj: “Tatáy, kowaskayquicunamanta mana maykenpas chincanchu” nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simón Pedro uj espadayoj carkan. Orkhospataj, curaj sacerdotej uywaskanpaj paña lado ninrinta cuchokarkan; sutintaj carkan Malco. ");
INSERT INTO qulNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesús Pedroman nerkan: —Espadata maychus cananman churapuy. Tataypaj ñac'arina kowaskanta, ¿manachu ñac'arinay? ");
INSERT INTO qulNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Soldadocuna, capitannincu, templo guardiaj, judiocunapiwan Jesusta jap'ispa, watarkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ñaupajta Anaspaj wasinman aparkancu, Caifaspaj suegron caskanraycu. Chay watapi Caifás curaj sacerdote cachcarkan. ");
INSERT INTO qulNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Cay Caifás quiquin judiocunaman niska: “Kancunapaj allin canman uj runalla llajtaraycu wañunanka” nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedro waj discipulopiwan Jesuspaj khepanta purerkancu. Chay ujnincajtaj curaj sacerdotepaj rejsiskan carkan. Chayraycu Jesuswan wasinman yaycorkan. ");
INSERT INTO qulNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedrotaj jawapi quedacorkan puncu kayllapi. Chay ujnin discípulo, curaj sacerdotepaj rejsiskan, llojsimuspa, puncu cuidaj warmiman nerkan, Pedrota pusaycunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Chay puncu cuidaj warmitaj Pedrota taporkan: —¿Manachu kanpas chay runapaj ujnin discípulon canqui? Pedrotaj contestarkan: —Mana, mana chaychu cani. ");
INSERT INTO qulNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Chirejtin, uywaskacuna templo guardiajcunapiwan ninata jap'icherkancu, chaypi k'oñicunancupaj. Pedropas paycunawan cachcallarkantaj, nina kayllapi k'oñicuspa. ");
INSERT INTO qulNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Curaj sacerdote Jesusta taporkan discipuloncunamanta, yachachiskanmantawan. ");
INSERT INTO qulNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesús nerkan: —Tucuy runacunapaj ñaupakenpi parlarkani. Sinagogacunapi yachachini, templopipas, maypichus tucuy judiocuna tantacuncu chaypi. Ajinaka ni imata pacapichu nini. ");
INSERT INTO qulNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Imaraycutaj nokata tapuwanqui? Uyariwajcunata tapuy; paycuna nichuncu imata parlaskayta. Paycuna niskayta yachancu. ");
INSERT INTO qulNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesús chayta nejtin, templomanta ujnin guardiaj Jesuspaj uyanpi t'ajllispa, nerkan: —¿Jinatachu curaj sacerdoteta contestanqui? ");
INSERT INTO qulNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesús contestarkan: —Mana allinta nejteyka, niway ari, mayken parlaskaychus mana allin caskanta. Allin cajtintaj, ¿imaraycutaj makawanqui? ");
INSERT INTO qulNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anastaj wataskata Jesusta pusachimorkan curaj sacerdote Caifaspaj wasinman. ");
INSERT INTO qulNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pedro chayllapipuni cachcarkan, nina kayllapi k'oñicuspa. Taporkancutaj: —¿Manachu kanri chay runapaj ujnin discípulon canqui? Pedrotaj negacorkan, nispa: —Mana, mana chaychu cani. ");
INSERT INTO qulNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Pedro ninrinta cuchokaskan Malcopaj parienten, curaj sacerdotepaj sirvienten, tapullarkantaj: —¿Manachu kanta huertopi paytawan ricorkayqui? ");
INSERT INTO qulNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedrotaj ujtawan negarkan; chhicapacha gallo wajach'acorkan. ");
INSERT INTO qulNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Chaymanta Jesusta pusarkancu Caifaspaj wasinmanta Roma gobernaj Pilatopaj palacionman. Sut'iyamuchcaskanraycu judiocuna mana palacioman yaycorkancuchu. Chayman yaycuncuman carkan chayka, limpiochacuna costumbre leyta p'aquincuman carkan, chhicataj Pascua cenata mana miqhuncumanchu carkan. ");
INSERT INTO qulNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Chayraycu Pilato llojsispa paycunata taporkan: —¿Imamantataj cay runata juchachanquichis? ");
INSERT INTO qulNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Paycunataj contestarkancu: —Manachus mana allinta ruwanman chayka, mana kanman pusamuyquichismanchu. ");
INSERT INTO qulNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatotaj paycunata nerkan: —Kancuna pusacapuychis, juchachamuychis leyniyquichisman jina. Judiocunataj contestarkancu: —Mana pitapas wañuchinaycupajka derechoycu canchu. ");
INSERT INTO qulNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ajinata junt'acorkan Jesuspaj niskan imaynata pay wañunanta. ");
INSERT INTO qulNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato palacionman cutiycaporkan. Jesusta wajaspataj, taporkan: —¿Kanchu judiocunapaj Reynin canqui? ");
INSERT INTO qulNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesustaj payman nerkan: —¿Kanllamantachu chayta tapuwanqui, icha ujcunachu nokamanta nisunquichis? ");
INSERT INTO qulNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato contestarkan: —¿Judío runachu cani nokari? Llajtamasiyquicuna sacerdotecunapaj jefencunapiwan nokaman pusamusunquichis. ¿Imatataj ruwarkanqui? ");
INSERT INTO qulNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesús contestarkan: —Gobiernoyka mana cay pachamantachu. Jina canman chayka, sirvejniycunaka makanacuncuman judiocunaman mana entregaska canaypaj. Gobiernoyka mana cay pachamantachu. ");
INSERT INTO qulNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Chhicari Pilato taporkan: —¿Ajinaka kan reychu canqui? Jesús contestarkan: —Kan ninqui noka rey caskayta. Nokaka nacini, jamunitaj cay pachaman, imachus verdad chayta ninaypaj. Tucuy verdadpi cajcunaka parlaskayta uyarincu. ");
INSERT INTO qulNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato tapullarkantaj: —¿Imataj verdadri? —nispa. Tapuy pasayta Pilato ujtawan llojserkan judiocunawan parlaj. Nerkantaj: —Ni ima juchata cay runapi tarinichu. ");
INSERT INTO qulNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kancunapaj costumbreyquichis can Pascua fiesta p'unchaypi uj presota cacharinapaj. ¿Munanquichischu judiocunapaj Reynincuta cacharinayta? ");
INSERT INTO qulNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tucuynincu wajach'acorkancu: —¡Chaycajtaka ama! ¡Barrabascajta cachariy! Barrabastaj millaycuna ruwaj carkan. ");
INSERT INTO qulNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilatotaj mandarkan Jesusta bajtanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Soldadocuna qhichcacunamanta uj coronata ruwaspa, Jesuspaj umanman churaycorkancu. Uj morado katanawantaj churaycorkancu reyta jina. ");
INSERT INTO qulNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Payman chimpaycuspa, nerkancu: —¡Causachun, judiocunapaj Reynin! —nispa. Uyapitaj makarkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato ujtawan llojsispa, paycunaman nerkan: —Khawariychis, jawaman orkhomuni yachanayquichispaj ni ima juchatapas paypi tariskayta. ");
INSERT INTO qulNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jesús llojsimorkan, umanpi qhichca coronayoj, morado katanayojtaj. Pilatotaj nerkan: —¡Cayka chay runaka! ");
INSERT INTO qulNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Sacerdotecunapaj jefencuna templo guardiajcunapiwan Jesusta ricuytawan wajach'acorkancu nispa: —¡Chacataska cachun! ¡Chacataska cachun! Pilatotaj nerkan: —Kancuna apacapuychis, chacatamuychis. Nokaka mana tarinichu ni ima juchata paypi. ");
INSERT INTO qulNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Judiocunataj contestarkancu: —Uj leyniycu can, chay leyman jina wañunan, Diospaj Churinmanta pasacuskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Cayta uyarispa Pilatoka astawan manchacorkan. ");
INSERT INTO qulNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Palacionman cutiycuspa, Jesusta taporkan: —¿Kan maymantataj canqui? Jesús mana contestarkanchu ni imata. ");
INSERT INTO qulNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilato nerkan: —¿Manachu contestawanqui? ¿Manachu yachanqui atiyniyoj caskayta kanta chacatanaypaj, chayri cacharinaypajpas? ");
INSERT INTO qulNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesús contestarkan: —Mana ima atiyniyquipas nokaman canmanchu, Dios mana kosunquimanchu chayka. Chayraycu nokata kanman entregawajcunaka astawan juchayojraj cancu. ");
INSERT INTO qulNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Chhicamantapacha Pilato Jesusta cachariyta munarkan. Judiocunataj wajach'acorkancu: —¡Cacharinqui chayka, curaj gobernajpaj mana amigonchu canqui! ¡Pillapas reyman tucojka curaj gobernajpaj enemigon! ");
INSERT INTO qulNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato chayta uyarispa, Jesusta jawaman orkhocherkan. Chaymanta justicia ruwanan sillapi tiyaycorkan, hebreo idiomapi Gabata niska lugarpi. (Niyta munan: “Rumiwan mast'aska.”) ");
INSERT INTO qulNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pascua fiestapaj uj p'unchayllaña cachcajtin, chaupi p'unchay jina, Pilato judiocunaman nerkan: —¡Cayka reyniyquichis! ");
INSERT INTO qulNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Paycunataj wajach'acorkancu: —¡Wañuchun! ¡Wañuchun! ¡Chacataska cachun! Pilatotaj taporkan: —¿Reyniyquichistachu chacatachisaj? Sacerdotecunapaj jefencuna contestarkancu: —¡Nokaycupajka mana canchu waj rey, Romapi curaj gobernajniycumanta nejtenka! ");
INSERT INTO qulNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Chhicataj Pilato paycunaman Jesusta entregaporkan chacataska cananpaj. Paycunataj apaporkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesús cruzninta khewiricuspa llojsiporkan “Calavera” niska lugarman. (Hebreopitaj “Gólgota” niska carkan.) ");
INSERT INTO qulNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Chaypi chacataycorkancu iscay runacunatawan cusca, ujta pañanpi, ujtataj llok'enpi. ");
INSERT INTO qulNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato Jesuspaj cruznin patapi uj escribiskata churacherkan. Escribiskataj nerkan: “Nazaret llajtayoj Jesús, Judiocunapaj Reynin.” ");
INSERT INTO qulNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Achqha judiocuna chay escribiskata leerkancu, llajta kayllapi Jesusta chacataskancuraycu. Chay escribiskataj carkan quimsa idiomapi: hebreopi, latinpi, griegopi ima. ");
INSERT INTO qulNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Chayraycu sacerdotecunapaj jefencuna Pilatoman nerkancu: —Ama escribiychu ‘Judiocunapaj Reynin’ nispaka, manachayri ‘Pay nerkan: Judiocunapaj Reynin cani’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatotaj contestarkan: —Escribiskayka, escribiska canan. ");
INSERT INTO qulNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Soldadocuna Jesusta chacataycuy pasayta, p'achancunata jap'ispa tawaman parterkancu sapa uj soldadopaj. Túnica niska mana sirayniyoj p'achanta mana lliq'iyta munarkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Chayraycu soldadocuna ninacorkancu: —Ama lliq'isunchu, manachayri suerteta khawasun pimanchá tupanka chayta. Ajinapi Escritura niskanka junt'acorkan: “P'achayta partinacuncu, túnica p'achaypitaj suerteta khawancu.” Chayta soldadocuna ruwarkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesuspaj cruznin kayllapi cachcarkancu maman, mamanpaj ñañan, Cleofaspaj warmin María, María Magdalenapiwan. ");
INSERT INTO qulNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesús mamanta ricuspa, paywan cusca munaska discipulontawan, mamanman nerkan: —Warmi, chayka churiyqueka. ");
INSERT INTO qulNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Discipulontataj nerkan: —Chayka mamayqueka. Chhicamantapacha chay discipuloka wasinman pusaporkan. ");
INSERT INTO qulNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Chay pasayta, Jesús yachaspa tucuy junt'acuskantaña, Escriturapas junt'acunallanpajtaj, nerkan: —Unumanta ch'aquiwan —nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Chaypitaj uj p'uyñu cachcarkan, c'allcu vino junt'a. Uj esponjata c'aspiman wataycuspa vinoman chapuycuspataj, siminman churarkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesustaj c'allcu vinota ch'umuycorkan. Chaymanta nerkan: —Tucuy ima junt'acunña. Chaypacha c'uñuycuspa, wañuporkan. ");
INSERT INTO qulNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","K'ayantin Pascua p'unchayña caskanraycu judiocuna mana munarkancuchu chacataskacuna cruzpi quedanancuta samana p'unchaypi, paycunapaj athun p'unchay caskanraycu. Chayraycu Pilatomanta mañarkancu mandananpaj chacataska runacunapaj chaquincuta p'aquiramunancupaj, wañuskaña capojtincu cruzmanta apakapunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Soldadocuna purispa, ujninpaj chaquincunata p'aquerkancu, ajinallatataj ujnincajtapas, Jesuswan cusca chacataskata. ");
INSERT INTO qulNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jesusman chimpaycuspataj, ricorkancu wañuskaña caskanta. Chayraycu chaquincunata mana p'aquerkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Chaywanpas ujnin soldado lanzawan Jesuspaj wajtanta allaycorkan. Chaypacha yawar unupiwan jich'acamorkan. ");
INSERT INTO qulNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Chayta willajka uj ricoj, willaskantaj verdad; pay yachan verdadta niskanta, kancunapas creenayquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Caycunaka pasarkan Escriturapaj niskan junt'acunanpaj: “Mana p'aquincuchu mayken tulluntapas.” ");
INSERT INTO qulNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Uj chhicapi Escritura nillantaj: “Khawankacu allaycuskancuta” nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Chay pasayta, Arimatea llajtayoj José Pilatomanta mañarkan Jesuspaj cuerponta apacapunanpaj. Josetaj Jesuspi creejcunamanta ujnin carkan, judiocunata manchacuspa pacallapi carkan chaywanpas. Pilatotaj permisota korkan. Josetaj purispa, cuerponta apacaporkan. ");
INSERT INTO qulNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Tutapi Jesuswan parlaj purej Nicodemopas chayamullarkantaj, quimsa chunca kilo mirrawan aloewan chhajruskata, sumaj k'apayniyoj perfumeta, apamuspa. ");
INSERT INTO qulNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ajina ari, José Nicodemopiwan Jesuspaj cuerponta apaspa, perfumepi chapuska vendacunawan p'istuycorkancu, judiocunapaj costumbrenman jina wañuskata p'ampanapaj. ");
INSERT INTO qulNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesusta chacataskancu lugarpi carkan uj huerto. Chay huertopitaj uj mosoj sepultura jutc'uska, manaraj ni pitapas p'ampaskarajchu carkan. ");
INSERT INTO qulNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Chaypi Jesuspaj cuerponta churaycorkancu, imaraycuchus sepultura kayllapi cachcarkan, judiocunapaj samana p'unchayninpas kallaricuchcarkanña. ");
INSERT INTO qulNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Semana kallariy p'unchaypi María Magdalena tutamanta sepulturaman purerkan, tutaraj cachcajtin. Sepultura tapaska rumita tankarpayaskata ricorkan. ");
INSERT INTO qulNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Chhicataj phawarkan Simón Pedroman Jesuspaj munaskan discipulonmanpiwan. Nerkantaj: —¡Señorta sepulturamanta apacapuskacu, manataj yachaycuchu maypi churaskancuta! ");
INSERT INTO qulNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pedro uj discipulopiwan llojsispa, sepulturaman purerkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Iscaynincu phawachcarkancu. Ujcajtaj phawarkan astawan Pedromanta nejtin. Chayraycu sepulturaman ñaupajta chayarkan. ");
INSERT INTO qulNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","C'uñuycuspa khawaycorkan, vendacunatataj ricorkan. Manataj yaycorkanchu. ");
INSERT INTO qulNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Khepanta Pedro chayaspa, sepulturaman yaycorkan. Vendacunata chaypi ricullarkantaj, ");
INSERT INTO qulNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Jesuspaj uman p'istuska pañotawan. Chay pañotaj mana vendacunawan cuscachu cachcarkan, manachayri ch'uwiska waj chhicapi. ");
INSERT INTO qulNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Chhicataj ñaupajta sepulturaman chayaj discípulo yaycullarkantaj; chay jinata ricuspa, creerkan. ");
INSERT INTO qulNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Jesús causarinanmanta Escriturapaj niskanta manaraj entendiskacuchu. ");
INSERT INTO qulNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Chaymanta discipulocuna wasiman cutiporkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","María sepultura kayllapi wakachcarkan. Ajina wakachcaj, c'uñuycuspa sepultura uqhuta khawaycorkan. ");
INSERT INTO qulNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Yuraj p'achayoj iscay angelcunata ricorkan tiyachcajta Jesuspaj cuerpon churaska chhicapi, ujcajta umanejpi, ujcajtataj chaquinejpi. ");
INSERT INTO qulNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Angelcunataj taporkan: —Warmi, ¿imaraycutaj wakachcanqui? María nerkan: —Señorniyta apacapuncu, manataj yachanichu maypi churaskancuta. ");
INSERT INTO qulNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","María chayta niytawan, cutirispa Jesusta ricorkan, manataj yacharkanchu pay caskanta. ");
INSERT INTO qulNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesús payta taporkan: —Warmi, ¿imaraycutaj wakachcanqui? ¿Pitataj masc'anqui? Paytaj huerto cuidaj caskanta pensaspa, nerkan: —Señor, kan apacapunqui chayka, niway maypi churaskayquita, purispa masc'amunaypaj. ");
INSERT INTO qulNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Chhicataj Jesús nerkan: —¡María! Paytaj cutirispa, hebreo idiomapi nerkan: —¡Rabuni! (Niyta munan: “Yachachej.”) ");
INSERT INTO qulNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesustaj payman nerkan: —Cachariway, manaraj Dios Tatayman purinichu. Puriy, waukeycunaman willamuy tantacoj puriskayta Tataywan Tatayquichiswan, Diosniywan Diosniyquichiswan. ");
INSERT INTO qulNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","María Magdalenataj purispa discipuloncunaman willarkan Señorta ricuskanta, payman niskantapiwan. ");
INSERT INTO qulNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Chay quiquin semana kallariy p'unchay tutayajtinña, judiocunamanta manchacuspa discipuloncuna puncu wisk'aska uqhupi tantacorkancu. Jesustaj yaycuspa discipuloncuna chaupinpi sayaycuspa, saludarkan nispa: —¡Sonko tiyaycuy kancunaman! ");
INSERT INTO qulNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Cayta nispa, maquincunata wajtantawan ricuchicorkan. Paycunataj Señorta ricuspa, cusicorkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ujtawan Jesús nillarkantaj: —¡Sonko tiyaycuy kancunaman! Imaynatachus Tatay nokata cachamuwan, jinallatataj noka kancunata cachayquichis. ");
INSERT INTO qulNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Chayta nispa, paycunaman phucuspa nerkan: —Santo Espirituta jap'ekaychis. ");
INSERT INTO qulNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Juchancuta perdonaskayquichiska perdonaska canka, mana perdonaskayquichistaj mana perdonaskachu canka. ");
INSERT INTO qulNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Chunca iscayniyoj discipuloncunamanta ujnin Tomás carkan, Mellizo niska. Jesús riqhurejtin, mana waj discipulocunawanchu cachcarkan. ");
INSERT INTO qulNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Discipulocuna payman nerkancu: —Ricuycu Señorta —nispa. Tomastaj contestarkan: —Manachus maquincunapi clavocunapaj jutc'uskanta ricusaj, nitaj chaycunaman dedoyta churaycusajchu, nillataj wajtan jutc'uskaman maquiyta churaycusajchu chayka, mana creeymanchu. ");
INSERT INTO qulNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Pusaj p'unchay pasaymanta discipulocuna ujtawan wasipi tantacuskacu. Cunancajka Tomaspas chaypi cachcarkan puncu wisk'aska uqhupi. Jesustaj chaupincupi sayaycuspa, saludarkan nispa: —¡Sonko tiyaycuy kancunaman! ");
INSERT INTO qulNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tomastataj nerkan: —Dedoyquita cayman churaycuy. Maquiycunata khawariy. Maquiyquita apamuy, wajtaymantaj churaycuy. ¡Ama mana creej caychu, manachayri creej cay! ");
INSERT INTO qulNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomastaj nerkan: —¡Señorníy, Diosníy! —nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús payman nerkan: —Creenqui ricuwaskayquiraycu. ¡Cusicuyniyojmi cankacu mana ricuwaspa creejcunaka! ");
INSERT INTO qulNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesús achqha waj milagrocunata ruwarkan discipuloncunapaj ñaupakenpi. Mana lliujchu escribiska cay libropi, ");
INSERT INTO qulNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","caycuna escribiska cajcunataj kancuna creenayquichispaj Jesús Cristo caskanta, Diospaj Churin caskantapiwan, paypi creespataj salvación causayniyoj canayquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Chaymanta Tiberias kocha cantopi Jesús discipuloncunaman ujtawan riqhurerkan. Cay jinata pasarkan: ");
INSERT INTO qulNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Junto cachcarkancu Simón Pedro, Mellizo niska Tomás, Galileapi caj Caná llajtamanta Natanael, Zebedeopaj churincuna, Jesuspaj iscay waj discipuloncunapiwan. ");
INSERT INTO qulNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simón Pedro paycunata nerkan: —Challwa jap'ej purisaj. Paycunataj contestarkancu: —Nokaycupas kanwan purisajcu. Purerkancutaj uj botepi. Chay tuta entero mana ni ima challwata jap'erkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Pakariyamuchcaytaña Jesús kocha cantopi riqhurerkan. Discipuloncunataj mana yacharkancuchu pay caskanta. ");
INSERT INTO qulNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesús paycunata taporkan: —Waynacuna, ¿manachu ni ima challwata jap'inquichis? Paycunataj contestarkancu: —Mana —nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesús nillarkantaj: —Llicata botepaj pañannejman wijch'uycuychis, jap'inquichistaj. Ajinata ruwarkancu. Chaymantataj achqha challwayoj caskanraycu llicata mana orkhoyta aterkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Jesuspaj munaskan discípulo Pedroman nerkan: —¡Cayka Señor! —nispa. Simón Pedrotaj Señor caskanta uyariytawan, p'achanta churaycucorkan, imaraycuchus mana p'achayoj cachcarkan. Chaymanta unuman wijch'uycucorkan. ");
INSERT INTO qulNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Waquin discipulocuna playaman boteta orkhorkancu, junt'a challwayoj llicata katatispa. Kocha cantoman pachaj metro jina carkan. ");
INSERT INTO qulNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Botemanta playaman urakaspataj, nina sansa patapi uj challwata t'antatawan tariparkancu. ");
INSERT INTO qulNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesús paycunata nerkan: —Apamuychis waquin jap'iskayquichis challwacunata. ");
INSERT INTO qulNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simón Pedro boteman yaycuspa, llicata jap'ispa, kataterkan playaman. Llicataj junt'a athuchaj challwacunayoj carkan, pachaj phichka chunca quimsayoj challwacuna. Achqha carkan, chaywanpas llicaka mana lliq'icorkanchu. ");
INSERT INTO qulNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesús paycunaman nerkan: —Jamuychis, miqhusunchis. Manataj maykennincupas pi caskanta tapuyta atrevicorkancuchu, imaraycuchus yacharkancu Señor caskanta. ");
INSERT INTO qulNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesustaj paycunaman chimpaycuspa, t'antata jap'ispa korkan, ajinallatataj challwatapas. ");
INSERT INTO qulNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Caywanka quimsa cutiña carkan Jesús causariskan pasayta discipuloncunawan ricuchicuskanka. ");
INSERT INTO qulNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Miqhuy pasayta, Jesús Simón Pedrota taporkan: —Simón, Juanpaj churin, ¿astawanchu munacuwanqui caycunamanta nejtin? Pedro contestarkan: —Arí, Señor, kan yachanqui kanta munacuskayta. Jesustaj nerkan: —Ovejaycunata michipuway. ");
INSERT INTO qulNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesús ujtawan tapullarkantaj: —Simón, Juanpaj churin, ¿munacuwanquichu? Pedrotaj contestarkan: —Arí, Señor, kan yachanqui kanta munacuskayta. Jesús payta nerkan: —Ovejaycunata michipuway. ");
INSERT INTO qulNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Quimsacaj cutipi tapullarkantaj: —Simón, Juanpaj churin, ¿munacuwanquichu? Quimsa cuticama “¿Munacuwanquichu?” nispa tapuskanmanta, Pedro llaquiska contestarkan: —Señor, kan tucuy imata yachanqui, kan yachanqui kanta munacuskayta. Jesús nillarkantaj: —Ovejaycunata michipuway. ");
INSERT INTO qulNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Segurayqui, waynallaraj cachcaspaka, p'achayquita churaycucuspa may munaskayquita purej canqui. Machuña caspataj maquiyquicunata okharinqui. Wajtaj p'achaycusunqui, apasunquitaj mana puriy munaskayquiman. ");
INSERT INTO qulNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Cayta nispataj, Jesús entendicherkan imaynatachus Pedro wañunanta, wañuynintaj Diosta honrananta. Chay pasaymanta nerkan: —¡Nokawan puriy! —nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedro cutirispa ricorkan Jesuspaj sinchi munaskan discípulo khepancuta jamuchcaskanta. Chay quiquin discípulo Pascua cenapi Jesuspaj ladonpi cachcaspa tapuska: “Señor, ¿pitaj vendiycusunqui?”, nispa. ");
INSERT INTO qulNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pedro payta ricuspa, Jesusta taporkan: —Señor, ¿caytari imataj pasanka? ");
INSERT INTO qulNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús contestarkan: —Cutimunaycama causananta munayman chayri, ¿imataj kanman importasunqui? Kanka, nokawan puriy. ");
INSERT INTO qulNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Chay niskanraycu creyentecuna ninacorkancu: “Chay discípulo mana wañonkachu” nispa. Jesuska mana niskachu mana wañunantaka, niskanka cayllami: “Cutimunaycama causananta munayman chayri, ¿imataj kanman importasunqui?” ");
INSERT INTO qulNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Chay quiquin discípulo cay librota escribispa caycunata willacun. Yachanchis verdadta niskanta. ");
INSERT INTO qulNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesús achqha wajcunatawan ruwarkan. Achqha, sichus ujmanta uj escribincuman chayka, pensani tucuy cay pachapipas mana campo cananta chay escribiska librocunata churanapaj. Ajina cachun.");
INSERT INTO qulNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Sinchi respetaska Teófilo, ñaupajcaj libroypi escribimorkayquiña tucuy imata Jesús ruwaskanta yachachiskantawan, naciskanmantapacha ");
INSERT INTO qulNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","janaj pachaman puripunan p'unchaycama. Manaraj puripuchcaspa, Santo Espíritu uqhunta ajllaska apostolnincunaman imata ruwanancuta yachacherkan. ");
INSERT INTO qulNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Wañuskamanta causarimuspataj, Jesús quiquin apostolnincunaman ricuchicorkan ciertota causarimuskanta yachanancupaj. Tawa chunca p'unchaycama jinata paycunaman riqhurerkan, Diospaj gobiernonmanta parlaspa. ");
INSERT INTO qulNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Apostolnincunawan cachcasparaj, Jesús nerkan: —Jerusalenpi suyaychis Tataypaj prometicuskan junt'acunancama. Noka chay promesanmanta parlarkayquichis. ");
INSERT INTO qulNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ciertota unullawan Juan bautizarkan, cay pisi p'unchaycunamantataj kancuna Santo Espirituwan bautizaska canquichis. ");
INSERT INTO qulNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jesuswan tantaska cachcajcuna taporkancu: —Señor, ¿cunitanchu Israel llajtaman cutichipunqui ñaupaj jina gobiernonta? ");
INSERT INTO qulNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesús contestarkan: —Mana kancunaman tupasunquichischu yachanayquichiska ima tiempochus chayri ima p'unchaychus cananta Dios Tatalla atiyniyoj gobernananpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Jayc'ajchus Santo Espíritu kancunaman jamojtin, Diospaj atiyninta jap'ekanquichis. Chaywantaj purispa nokamanta willaramunquichis Jerusalenpi, tucuy Judea llajtacunapi, Samaria llajtacunapi, tucuy cay pachapipas. ");
INSERT INTO qulNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Apostolnincuna khawachcajtincu, Jesús chayta nispa janaj pachaman puriporkan. Uj phuyu tapaycapojtin, manaña ricorkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Imaynata ripuskanta paycuna khawachcajtincuraj, iscay khari yuraj p'achayoj riqhurerkancu, paycunawan sayachcaj. ");
INSERT INTO qulNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Nerkancu: —Galileo kharicuna, ¿imaraycutaj janaj pachata khawachcanquichisri? Cay quiquin Jesús chaupiyquichismanta janaj pachaman puripun. Imaynatachus ricuchcanquichis puripojta, ajinallatataj cay caskanta ujtawan cutimonka. ");
INSERT INTO qulNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Apostolcuna Olivos lomamanta Jerusalenman cutiporkancu. Uj kilómetro puriy jina carkan, samana p'unchaypi leypaj permitiskanman jina. ");
INSERT INTO qulNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Llajtaman chayaspataj, alojacuskancu altosniyoj wasiman sekaporkancu. Carkancutaj: Pedro, Juan, Santiago, Andrés, Felipe, Tomás, Bartolomé, Mateo, Alfeopaj churin Santiago, Simón Celote, Santiagopaj churin Judaspiwan. ");
INSERT INTO qulNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tucuynincu tantacojpuni carkancu oracionta ruwanancupaj Jesuspaj waukencunawan, maman Mariawan, waj warmicunapiwan. ");
INSERT INTO qulNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Chay p'unchaycunapi pachaj iscay chuncayoj creyentecuna tantacorkancu. Pedrotaj sayarispa, nerkan: ");
INSERT INTO qulNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Hermanocuna, Judasmanta Davidpaj escribiskan Escriturapi Santo Espiritupaj niskan junt'acunanpuni carkan. Chay Judaska runacunata pusarkan Jesusta jap'inancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Nokanchiswan cachcaspa, paypas cay ruwananchispi cachcarkan. ");
INSERT INTO qulNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Mana allin ruwaskanmanta pagaska kolkewan uj jallp'ata ranterkancu. Umanejmanta urmakaspa wijsanta phatachicorkan, ch'unchulnincunataj tallicorkan. ");
INSERT INTO qulNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jerusalenpi tiyajcuna yachaspa chay jallp'ata suticharkancu Acéldama nispa. Chay niyta munan: ‘Yawar Jallp'a.’ ");
INSERT INTO qulNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Judasmanta Salmos libropi nin: ‘Wasin wijch'uska cachun, chaypi ama pipas tiyachunchu.’ Nillarkantaj: ‘Ruwanantataj waj jap'ichun.’ ");
INSERT INTO qulNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Caypi nokanchiswan cachcancu Jesucristowan tucuy tiempo purejmasinchis, ");
INSERT INTO qulNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Juanpaj bautizaskanmantapacha janaj pachaman puripunancama. Paycunamanta ujninta ajllananchis, Jesucristopaj causariskanmanta willananpaj nokanchiswan cusca.” ");
INSERT INTO qulNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Chhicataj iscayojta ajllarkancu: Justo niskancu José Barsabasta, Matiastawan. ");
INSERT INTO qulNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Diosmanta mañacorkancu, nispa: “Señor, tucuypaj sonkonta rejsinqui. Ricuchiwaycu ari, maykentachus cay iscay kharimanta ajllaskayquita, ");
INSERT INTO qulNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Judaspaj cuentanmanta apostolniyqui cananpaj. Judaska juchallicuskanraycu castigoman puripun.” ");
INSERT INTO qulNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Sorteajtincu, Matiasman chayarkan. Chhicamantapacha Matiaska apóstol carkan chunca ujniyoj apostolcunawan cusca. ");
INSERT INTO qulNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentecostés niska p'unchay chayamojtin, tucuy creyentecuna uj chhicallapi tantaska cachcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Konkaylla janaj pachamanta athun suenay jamorkan, sinchi wayra jina. Chay wasipi cajcuna tucuynincu chayta uyarerkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Sapa uj paycuna patapi nina lauray jina riqhurerkan. ");
INSERT INTO qulNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Tucuynincutaj Santo Espirituwan junt'a carkancu. Waj idiomacunapitaj parlayta kallarerkancu, Santo Espiritupaj parlachiskanman jina. ");
INSERT INTO qulNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Jerusalén llajtapi tucuynejmanta chayamoj judiocuna cachcarkancu, religión costumbreta junt'anancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Chay jina suenamojta uyarispa, runacuna tantacamorkancu. Sapa uj paycunapaj quiquin idiomanpi apostolcunata parlajta uyarispa, musphararkancu, ni imata pensayta atispa. ");
INSERT INTO qulNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Sinchitapuni muspharaspa, uj ujcuna ninacorkancu: —¿Manachu tucuy cay parlachcajcunari Galilea llajtayojcuna? ");
INSERT INTO qulNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Imaynataj sapa ujpaj idiomanchispi parlajta uyarichcanchisri? ");
INSERT INTO qulNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Caypi cachcancu tucuy nacioncunamanta: Partia, Media, Elam, Mesopotamia, Judea, Capadocia, Ponto, Asia, ");
INSERT INTO qulNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia, Panfilia, Egipto, Cirene kayllapi caj Libia, Romamanta jamojcunapiwan. ");
INSERT INTO qulNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Waquincuna judío familiapi nacejcuna, waquincunataj judío religionman cutejcuna. Ajinallataj Cretamanta Arabiamantawan jamuncu. ¡Quiquin idiomanchispi sapa uj uyarichcanchis Diospaj musphana jina athun ruwaskancunamanta parlajta! ");
INSERT INTO qulNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Tucuynincu musphachcarkancu, ni imata pensayta atispa. Tapucuchcarkancutaj: —¿Ima niytataj munan tucuy cay imari? ");
INSERT INTO qulNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Waquincuna burlacuspa, nerkancu: —¡Machaska cancu! —nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pedro apostolcunawan cusca sayarispa, alto vozwan nerkan: “Judiocuna, tucuy Jerusalenpi tiyajcuna, cayta yachaychis, niskaytataj allinta uyariychis. ");
INSERT INTO qulNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kancuna machaska caskaycuta creenquichis chaywanpas, mana machaskachu caycu; tutamanta iskon horallaraj canpas. ");
INSERT INTO qulNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Astawanka profeta Joelpaj niskan junt'acuchcan. Payka nerkan: ");
INSERT INTO qulNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Dios nin: Khepa p'unchaycunapi tucuy runacunaman Espirituyta chayachisaj. Churiyquichiscuna ususiyquichiscunapas Diosmanta parlankacu. Waynacunataj moskoypi jina riconkacu. Machulacunapas moskoycunata moskoconkacu. ");
INSERT INTO qulNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Chay p'unchaycunapi khariman warmimanpas, tucuy sirviwajcunaman Espirituyta chayachejtiy, nokamanta parlankacu. ");
INSERT INTO qulNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Janaj pachapi musphanacunata ricuchisaj, cay pachapitaj señalcunata: yawarta, nina laurayta, phuyu k'osnitapiwan. ");
INSERT INTO qulNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Inti tutayanka, quillataj yawar jina puca tuconka, manaraj Señorpaj athun glorioso p'unchay chayamuchcajtin. ");
INSERT INTO qulNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Señorta tucuy wajacojcunaka salvaska cankacu.’ ");
INSERT INTO qulNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Israel runacuna, uyariychis ari. Cayta niyquichis: Nazaret llajtayoj Jesús kancuna uqhupi milagrocunata, musphana jina ruwaycunata, señalcunatawan ruwarkan. Ruwaskanpi Dios ricuchisunquichis pay Diosmanta caskanta. Chayta allinta yachanquichis. ");
INSERT INTO qulNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Chaywanpas Diospaj ñaupajmantaña waquichiskanman jina kancunaman pay entregaska cajtin, kancuna presota jap'ichinquichis. Wañuchinquichistaj, mana allin ruwaj runacuna chaupipi chacataspa. ");
INSERT INTO qulNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Diostaj causarichin wañuy nanaycunamanta libraspa, imaraycuchus wañoyka mana atipayta aterkanchu. ");
INSERT INTO qulNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Gobernaj David Jesusmanta nerkan: ‘Nokaka ñaupakeypi Señorta ricullajpuni cani. Paña ladoypi pay cajtin, ni ima urmachiwankachu. ");
INSERT INTO qulNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Chayraycu sonkoyka cusicun, simiytaj taquin cusicuywan junt'a. Diospi confiacuspa, causanka tucuy runa cayneyka. ");
INSERT INTO qulNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Imaraycuchus sepulturapi mana sakerpayawanquichu. Nillataj santo sirvejniyquipaj cuerponta ismuchinquichu. ");
INSERT INTO qulNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Causay ñanta ricuchiwanqui. Kanwan cajtiytaj, cusiywan junt'achiwanqui.’ ");
INSERT INTO qulNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Llajtamasicuna, sut'inta niyta munayquichis ñaupaj tatanchis Davidmanta. Payka wañuporkan, p'ampaska carkan, caypitaj nokanchiswan sepulturan cachcan. ");
INSERT INTO qulNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","David profeta caspa yacharkan Dios juramentowan prometicuskanta ujnin pariententa gobernajta churananpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ajinaka ricuchcanmanñapas jinata, Jesucristo causarinanmanta David parlarkan. Nillarkantaj sepulturapi mana quedananta ni cuerponpas ismunanta. ");
INSERT INTO qulNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Dios cay Jesucristota wañuymanta causarichimorkan. Nokaycutaj tucuy caycunamanta testigo caycu. ");
INSERT INTO qulNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Pay okhariska carkan, Diospaj paña ladonpi tiyaycunanpaj. Dios, prometicuskanman jina, Santo Espirituta payman korkan. Paytaj chay Espirituta nokaycuman cachamorkan, imaynatachus cunan ricuchcanquichis uyarichcanquichistaj ajinata. ");
INSERT INTO qulNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Mana Davidchu janaj pachaman okhariska carkan; chaywanpas payka nerkan: Dios Señorniyta nerkan: ‘Tiyaycuy paña ladoypi, ");
INSERT INTO qulNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","noka enemigoyquicunata atipaspa chaquiyqui uraman churanaycama.’ ");
INSERT INTO qulNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Tucuy Israel runacuna ciertota yachachuncu, Dios cay quiquin kancuna chacataskayquichis Jesusta churan Señor, Cristotaj cananpaj.” ");
INSERT INTO qulNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Chaypi tantaska cajcuna cayta uyarispa, sinchitapuni llaquicorkancu. Taporkancutaj Pedrota waj apostolcunatapas: —Waukecuna, ¿imatataj ruwasajcu? ");
INSERT INTO qulNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedrotaj paycunaman contestarkan: —Sapa ujniyquichis Diosman cutiricuychis, bautizachicuychistaj Jesucristopaj sutinpi, Dios juchayquichista perdonananpaj. Ajinapi Dios Santo Espiritunta kosunquichis. ");
INSERT INTO qulNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Cay promesaka kancunapaj, wawayquichiscunapaj, tucuy carupi cajcunapajpiwan. Niyta munan: picunatachus Señorninchis Dios wajayta munan, chaycunapaj cay promesaka. ");
INSERT INTO qulNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Caycunawan waj palabracunapiwan Pedro nerkan: —¡Salvacuychis, cay sajra runacunawan cusca mana castigaska canayquichispaj! ");
INSERT INTO qulNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ajina Pedropaj willaskanta creejcuna bautizaska carkancu. Chay p'unchay quimsa waranka jina creyentecunaman yapacorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tucuynincu apostolcunapaj yachachiskanpi firme quedacorkancu, tucuy cajnincuta jaywanacuspa, oracionta ruwaspa. Tantaycucuspataj, t'antata partispa junto miqhorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Apostolcuna achqha milagrocunata señalcunatawan ruwajtincu, tucuy musphararkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tucuy creejcunaka ujchaska carkancu, tucuy cajnincuta paycunapura jaywanacuspa. ");
INSERT INTO qulNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Jallp'ancuta ima cajnincunatawan vendispa, kolketa jaywararkancu sapa uj pisichicuskanman jina. ");
INSERT INTO qulNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Sapa p'unchay templopi tucuynincu tantacoj cancu. Wasicunapi t'antata partispa, athun cusicuywan sumaj sonkowan junto miqhorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Diosta alabarkancu, tucuy runacunapas paycunata respetarkancu. Señortaj sapa p'unchay salvaska cajcunata iglesiaman yapachcarkan. ");
INSERT INTO qulNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Uj p'unchay quimsa hora tardeyayta, Pedro Juanpiwan temploman purerkancu, oración ruwana horata. ");
INSERT INTO qulNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Chaypi tucuy p'unchay uj naciskanmantapacha such'u runata churaj cancu Hermosa niska sutiyoj puncupi, tucuy yaycojcunamanta limosnata mañacunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Such'u runataj Pedrota Juantawan temploman yaycuchcajta ricuspa, limosnata mañacorkan. ");
INSERT INTO qulNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Such'uta khawarispa, Pedro nerkan: —Khawariwaycu. ");
INSERT INTO qulNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Such'utaj khawarerkan, imallatapas konancuta yuyaspa. ");
INSERT INTO qulNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pedrotaj nerkan: —Mana kolkepas ni koripas capuwanchu, chaywanpas imachus capuwajllata koskayqui. Nazaret llajtayoj Jesucristopaj sutinpi jatariy, puripuy. ");
INSERT INTO qulNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Chayta nispataj, Pedro paña maquinmanta jap'ispa, sayaricherkan. Chhicapacha chaquincuna mokoncunapas c'uchiyaporkan. ");
INSERT INTO qulNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ujta saltaspa sayarerkan, puriytataj kallarerkan. Paycunawan temploman yaycorkan, saltaspa Diosta alabaspa. ");
INSERT INTO qulNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tucuy runacuna such'uta ricorkancu, Diosta alabaspa purichcajta. ");
INSERT INTO qulNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Rejserkancu imaynatachus cay runa Hermosa sutiyoj puncupi tiyaycuspa limosnata mañacoj caskanta. Purichcajta ricuspa, manchariska musphararkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Such'umanta alliyaska runa Pedrota Juantawan mana cacharerkanchu. Salomón niska patiopi cachcajtincu, chayman tucuy runacuna phawamorkancu, musphararkancutaj. ");
INSERT INTO qulNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pedro chayta ricuspa, nerkan: “Israel runacuna, ¿imaraycutaj muspharachcanquichis? ¿Imaraycutaj khawawanquichis, nokaycupas atiyniycuwan cay runata alliyachiycuman, chayri Diosta yupaychaskaycuwanpas purichiycuman jinata? ");
INSERT INTO qulNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Dios, Abrahampaj, Isaacpaj, Jacobpaj, ñaupaj abuelonchiscunapajpiwan Diosnin, sirvejnin Jesusman astawan athun honorta kon. Cay Jesusta kancuna autoridadcunaman entreganquichis. Payta Pilato cachariyta munajtin, kancuna mana munarkanquichischu. ");
INSERT INTO qulNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jesús justo mana juchayoj cachcajtinpas, paypaj cachariska cananta mañaypachaka runa wañuchej cachariska cananpaj mañarkanquichis. ");
INSERT INTO qulNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ajinata salvación causay kojta wañuchinquichis. Chaywanpas Dios causarichin. Chaymanta nokaycu testigo caycu. ");
INSERT INTO qulNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Cay such'u runaka Jesuspaj sutinpi creeskanwan alliyan. Kancuna payta ricunquichis, rejsinquichistaj. Atiyniyoj Jesuspi creeskanraycu alliyaskata tucuyniyquichis ricuchcanquichis. ");
INSERT INTO qulNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Waukecuna, noka yachaniña, Jesusta mana pi caskanta yachaspa, kancuna jefeyquichiscunapiwan wañucherkanquichis. ");
INSERT INTO qulNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Chay jinamanta Dios junt'arkan tucuy profetancunapaj ñaupajmanta willaskancuta, Cristo wañunan niskanta. ");
INSERT INTO qulNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Chayraycu Diosman cutiriychis, converticuychis, pay juchayquichista perdonananpaj. Chhica Dios sonko tiyaska samaricuyta kosunquichis. ");
INSERT INTO qulNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Kallariymantapacha kancunapaj Cristota ajllaska, cachamunasunquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Cunanka Jesucristo janaj pachapiraj canan, Dios tucuy imata niskanman jina churanancama, ñaupaj tiempopi causaj profetacunapaj niskanman jina. ");
INSERT INTO qulNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moisés ñaupaj abuelonchiscunaman willarkan: ‘Señor Diosniyquichis kancuna uqhumanta uj profetata okharenka nokata jina. Casucuychis paypaj tucuy ima niskanta. ");
INSERT INTO qulNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Tucuy mana casucojcuna Diospaj llajtanmanta wijch'uska cankacu.’ ");
INSERT INTO qulNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Cay p'unchaycunamanta tucuy profetacuna Samuelmantapacha parlarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Profetancuna uqhunta abuelonchiscunaman Diospaj prometicuskancunaka kancunapaj, kancunallapajtaj salvación compromisonpas. Dios Abrahamman nerkan: ‘Tucuy nacioncunapi runacuna bendiciska cankacu mirayniyquicuna uqhunta.’ ");
INSERT INTO qulNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Chayraycu Dioska Churinta causarichimuspa, kancunaman ñaupajta cachamorkan, bendiciska canayquichispaj, sapa uj kancuna mana allin causayniyquichismanta Diosman cutiricunayquichispaj.” ");
INSERT INTO qulNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedro Juanpiwan runacunaman parlachcajtincuraj, chayamorkancu sacerdotecuna, templo guardiajcunapaj jefen, saduceocunapiwan. ");
INSERT INTO qulNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Phiñaska cachcarkancu Pedropaj Juanpajwan cay jinata yachachiskancumanta: “Jesucristo causariskanpi ricuchin tucuy runa wañuskamanta causarinanta” nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Chayraycu tardeña cajtin, Pedrota Juantawan carcelpi wisk'aycorkancu k'ayantincama. ");
INSERT INTO qulNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Chaywanpas Pedropaj willaskanta achqha uyarejcuna creerkancu. Creejcunamanta kharicunalla phichka waranka jina carkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","K'ayantintaj judiocunapaj jefencuna, llajtapaj jefencuna, leymanta yachachejcunapiwan Jerusalenpi tantacorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Chaypitaj cachcallarkancutaj curaj sacerdote Anás, Caifás, Juan, Alejandro, curaj sacerdotecunapaj familiancunapiwan. ");
INSERT INTO qulNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pedrota Juantawan pusachimuspa, ñaupakencupi sayaycuchispa, taporkancu: —¿Ima autorizacionwantaj chayri pipaj sutinpitaj caycunata ruwanquichis? —nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pedrotaj Santo Espirituwan junt'a caspa, nerkan: —Llajtapaj jefencuna, waj jefecuna, ");
INSERT INTO qulNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","kancuna tapuwanquichis uj such'u runata allin ruwaskamanta, yachanayquichispaj imaynamanta alliyachiska caskanta. ");
INSERT INTO qulNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Tucuy Israel runacunapas allinta yachanayquichispaj willaskayquichis: cay ñaupakeyquichispi cachcaj runaka alliyachiska atiyniyoj Jesucristopaj sutinpi. Nazaret llajtayoj cay Jesustaka kancuna cruzpi chacatarkanquichis, Diostaj payta causarichin. ");
INSERT INTO qulNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Cay Jesusmi rumeka. Kancunataj, wasi ruwajcuna, payta millarpayanquichis. Cunan pay wasi esquinapaj astawan importante rumiman tucun. ");
INSERT INTO qulNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Mana wajpi salvación canchu, imaraycuchus Dios Jesusllata cay pachaman cachamun runacunata salvananpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tucuy autoridadcuna Pedrota Juantawan mana manchacuspa parlaskancuta uyarispa, musphararkancu mana estudiaska nitaj educaska caskancuraycu. Repararkancutaj Jesuspaj discipuloncuna caskancuta. ");
INSERT INTO qulNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Chaywanpas such'umanta alliyaska runa chaypi paycunawan cachcaskanraycu, apostolcuna contra mana ni ima niyta aterkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Asambleamanta jawaman llojsichispa, autoridadpura parlanacuspa, nerkancu: ");
INSERT INTO qulNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","—¿Imanasuntaj cay runacunawanri? Jerusalén llajtapi tucuy cajcuna yachancu cay milagro ruwaskancuta, manataj negayta atinchischu. ");
INSERT INTO qulNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Llajtanchispi cay tucuy ima mana yachacunanpaj, paycunata amenazasunchis mancharichinapaj, amaña cunanmanta ni pimanpas Jesuspaj sutinmanta parlanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Wajaycuspataj, mandarkancu chaymanta ama parlanancupaj ni Jesusmanta yachachinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pedrotaj Juanpiwan contestarkancu: —Kancuna quiquiyquichis niwaychis, Diospaj ñaupakenpi imachus justo caskanta, ¿Allinchu canman ñaupajta kancunataraj casunaycu, icha Diostachu casunaycu? ");
INSERT INTO qulNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nokaycu willanaycupuni ricuskaycuta uyariskaycutawan. ");
INSERT INTO qulNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Autoridadcunataj amenazaycuspa cachariporkancu. Milagrota ricuskancumanta tucuy runa Diosta alabachcarkancu. Chayraycu autoridadcuna mana imaynamanta castigayta aterkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Milagrowan alliyachiska runaka tawa chunca curaj watayoj jina carkan. ");
INSERT INTO qulNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pedro Juanpiwan cachariskaña caspa, creyentecunawan tantacoj purerkancu. Willarkancutaj curaj sacerdotecunapaj, llajtaj jefencunapajpiwan tucuy ima niskancuta. ");
INSERT INTO qulNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Chayta uyarispa, tucuynincu uj sonkolla Diosman oracionta ruwarkancu, nispa: “Señor, kan ruwanqui janaj pachata, cay pachata, kochata, tucuy cajcunatapas. ");
INSERT INTO qulNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Señor, Santo Espirituyqui sirvejniyqui Davidta parlacherkan cay jina niskayquita: ‘¿Imaraycutaj runacuna phiñacuywan pitucuncu? ¿Imaraycutaj yankhapaj rimanacuncu? ");
INSERT INTO qulNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Cay pachapi reycuna gobernajcunapiwan junto tantacuspa Señor Dios contra sayarincu, ajllaskan Cristo contrapas.’ ");
INSERT INTO qulNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Cay llajtapi Herodeska Poncio Pilatowan, Israel runacunawan, waj llajtayoj runacunapiwan tantacorkancu ajllaskayqui Cristo, santo sirvejniyqui Jesús, contra. ");
INSERT INTO qulNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Chay jinapi paycuna tucuy kanpaj munayniyquiman jina ruwarkancu, niskayquicuna junt'acunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Cunanka khawariy, Señor Dios, amenazawaskancuta. Sirvejniyquicunata callpachawaycu, mana manchacuspa palabrayquita willanaycupaj, ");
INSERT INTO qulNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","atiyniyquiwan onkoskacunata alliyananpaj, milagrocunata sirvejniyqui santo Jesuspaj sutinpi ruwacunanpaj.” ");
INSERT INTO qulNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tucuchajtincutaj, tantacuskancu lugar qharcaterkan. Tucuynincuman Santo Espíritu junt'aycorkan. Diospaj palabrantataj sut'inta willarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Tucuy creyentecuna uj sonkolla, uj runa jinalla pensarkancu. Ni pipas “nokallapaj” nejka carkanchu, ima cajnincupas tucuynincupajta carkan. ");
INSERT INTO qulNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Apostolcuna atiywan willarkancu Señor Jesucristopaj causarimuskanmanta. Diostaj tucuynincuta sinchita bendicerkan. ");
INSERT INTO qulNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Paycuna uqhupi mana pipas imamantapas pisiska cajchu, imaraycuchus jallp'ayojcuna wasiyojcunapas chay cajnincuta vendispa, ");
INSERT INTO qulNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","kolketa apostolcunaman jaywaj cancu, tucuyman konancupaj pisichicuskancuman jina. ");
INSERT INTO qulNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Chipre llajtamanta uj runa José sutiyoj carkan Levipaj mirayninmanta. Apostolcunataj payta suticharkancu Bernabé nispa. (Chay suti niyta munan: “Sonkochaj runa.”) ");
INSERT INTO qulNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Bernabé jallp'anta vendispa, kolketa apostolcunaman apamorkan. ");
INSERT INTO qulNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Uj runa carkan Ananías sutiyoj. Warmin Safirapiwan jallp'ancuta venderkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Warminwan yachachinacuspa, Ananías waquin kolketa apakaspa, waquillanta apostolcunaman aparkan lliujninta jina. ");
INSERT INTO qulNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pedrotaj payta nerkan: —Ananías, ¿imaraycutaj supay Satanás sonkoyquiman yaycun Santo Espirituta llullachinayquipaj, jallp'ayqui vendiskayquimanta waquin kolketa apakaspa? ");
INSERT INTO qulNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Manachu jallp'aka kanpajta carkan? Vendejtiyquipas ¿manachu kanllapajtaj chay kolke carkan? ¿Imaraycutaj jinata ruwanqui? ¡Diosta llullachinqui, mana runatachu! ");
INSERT INTO qulNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananiastaj chayta uyariytawan, wañuporkan. Tucuy chayta yachajcuna sinchita mancharicorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Waynacunataj jamuspa, ayata p'istuycuspa, wantuporkancu p'ampamunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Quimsa hora pasayta Ananiaspaj warmin jamorkan, cay pasaskanmanta mana imata yachaspa. ");
INSERT INTO qulNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pedrotaj Safirata taporkan: —Niway, ¿chay niskayquichis preciopichu jallp'ayquichista venderkanquichis? Paytaj contestarkan: —Arí, chay preciopi —nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pedrotaj payman nerkan: —¿Imaraycutaj kosayquiwan yachachinacorkanquichis, Señorpaj Espiritunta llullachinayquichispaj? Cunitan kosayquita p'ampamuskancumanta chayamuchcancu, cunan kantapas apallasunquichistaj. ");
INSERT INTO qulNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Chhicapacha Safira wañuporkan Pedropaj ñaupakenpi. Waynacunataj yaycuspa, wañuskata tariparkancu. Apaporkancu kosanpaj ladonpi p'ampamunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tucuy iglesiapi cajcuna tucuy yachajcunapiwan sinchita mancharicorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Apostolcuna achqha milagrocunata señalcunatawan ruwarkancu. Tucuy creejcunataj Salomón niska patiopi tantacorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Waj runacuna creyentecunawan tantacuyta mana munajchu cancu; chaywanpas paycunata respetaj cancu. ");
INSERT INTO qulNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Señorpi creejcuna achqhayoj yapacorkancu kharicuna warmicunapas. ");
INSERT INTO qulNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Onkoskacunata callecunaman orkhorkancu. Puñunapi camillacunapitaj suyachej cancu, Pedro pasajtin llanthullanpas waquinnincuman chayananpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Kayllapi caj juch'uy llajtacunamanta achqhayoj runacuna Jerusalenman jamorkancu, onkoskacunata sajra espiritupaj ñac'arichiskan runacunatawan apamuspa. Tucuytaj alliyaska carkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Curaj sacerdote paywan caj saduceocunapiwan apostolcunamanta sinchita envidiacorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Chayraycu apostolcunata jap'ispa, carcelpi wisk'aycucherkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Chay tuta Señorpaj angelnin cárcel puncuta quichararkan. Paycunata orkhospataj, nerkan: ");
INSERT INTO qulNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Temploman puriychis. Chaypi sayaycuspa, willaychis tucuy cay mosoj causaymanta.” ");
INSERT INTO qulNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","K'ayantintaj sut'iyamuyta temploman yaycuspa, yachachiyta kallarerkancu angelpaj niskanman jina. Chaycamataj curaj sacerdote paywan cajcunapiwan tucuy Israel autoridadcunata wajarkancu, Athun Asambleapi tantacunancupaj. Carcelmantaj cacharkancu apostolcunata aparimunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Soldadocunataj carcelman chayaspa, apostolcunata mana tariparkancuchu. Cutirimuspataj willarkancu: ");
INSERT INTO qulNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—Carcelman chayaspa, puncucunata allin wisk'askata taripaycu, soldadocunatataj puncuta cuidachcajta. Quicharaspataj, chay uqhupi ni pita taripaycuchu. ");
INSERT INTO qulNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Chayta uyarispataj curaj sacerdote, templo cuidajcunapaj jefen, sacerdotecunapaj jefencunapiwan tapucorkancu: —¿Imataj pasanka caycunawan? ");
INSERT INTO qulNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Chay ratopitaj uj runa chayamuspa, paycunaman willarkan: —Carcelpi wisk'achiskayquichis runacunaka templopiña yachachichcancu —nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Cuidajcuna jefencupiwan masc'aj purerkancu. Mana nanachispalla pusamorkancu, imaraycuchus mancharkancu runacuna rumiwan chhokanancuta. ");
INSERT INTO qulNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Chayaspataj, Athun Asambleaman pusarkancu. Curaj sacerdotetaj nerkan: ");
INSERT INTO qulNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Nokaycu sinchita mandarkayquichis chay runamanta mana yachachinayquichispaj. ¿Imatataj kancuna ruwanquichis? Jerusalenpi tucuy runacunata yachachichcanquichis. Nokaycutataj juchachachiwanquichis chay runa wañuskanmanta. ");
INSERT INTO qulNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pedro apostolcunapiwan contestarkancu: —Ñaupajta Diosta casunaycu runacunamanta nejtenka. ");
INSERT INTO qulNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Abuelonchiscunapaj Diosnin cruzpi wañuchiskayquichis Jesusta causarichin. ");
INSERT INTO qulNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Chaywanpas Dios Jesusman honorta kospa paña ladonpi churarkan, runacunata Diosman pusaspa salvananpaj, Israel runacunata Diosman cutirichinanpaj, juchancu perdonaska cananpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nokaycu tucuy caycunamanta testigo caycu. Casucojcunaman Diospaj koskan Santo Espiritupas testigollataj. ");
INSERT INTO qulNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Chayta uyarispataj, sinchita phiñaricuspa, apostolcunata wañuchiyta munarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Chay autoridadcuna uqhupi uj fariseo, Gamaliel sutiyoj, carkan, judiopaj leyninta yachachej, tucuy runataj payta respetaj cancu. Sayarispataj, mandacorkan chaymanta apostolcunata llojsichinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Llojsichejtincutaj, autoridadcunaman nerkan: —Israel runacuna, cuidacuychis cay runacunawan ima ruway munaskayquichista. ");
INSERT INTO qulNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Yuyariychis imaynatachus cay ñaupaj p'unchaycunapi Teudas niska riqhurimuskanta. Payka “Importante cani” nej carkan. Tawa pachaj runa jina payta katerkancu. Payta wañuchipojtincutaj, paypaj katejnincuna t'acaracaporkancu. Ajinapi lliuj tucucorkan. ");
INSERT INTO qulNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Khepamantaj runa yupana p'unchaycunapi Galileamanta Judas sutiyoj runa riqhurimorkan. Paytaka achqha runa katillarkancutaj. Paytaka wañuchipullarkancutaj, katejnincunapas t'acaracapullarkancutaj. ");
INSERT INTO qulNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Chayraycu niyquichis, ama imanaspa cacharipuychis. Amataj paycunawan meticuychischu. Runallamanta caycuna chayka, tucuchacaponka. ");
INSERT INTO qulNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Diosmantachus chayri, mana kancuna atipayta atiwajchischu. Cuidacuychis, Dios contrataj cachcawajchis. Chayta nejtin, paycunaka casucorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Apostolcunata wajachispa bajtarkancu. Mandarkancutaj manaña Jesucristomanta parlanancupaj. Chaymantataj cachariporkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Autoridadcunapaj ñaupakenmanta apostolcunaka sinchi cusiska llojsiporkancu, Diospaj munaskanman jina Jesucristoraycu sufriskancumanta. ");
INSERT INTO qulNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Sapa p'unchay templopi wasicunapipas yachacherkancu, Diospaj ajllaskan Jesucristomanta evangeliota willarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Chay tiempopi creyentecuna astawan yapacorkancu. Griego parlajcuna hebreo parlajcuna contra thutuchcarkancu, griego viudacunaman sapa p'unchay yanapata mana allinta ch'ekechiskancumanta. ");
INSERT INTO qulNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Chunca iscayniyoj apostolcuna tucuynin creyentecunata tantaycuspa, nerkan: —Mana allinchu, yanapata ch'ekechinaraycu Diospaj palabran yachachinata sakepunaycoka. ");
INSERT INTO qulNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Chayraycu, hermanocuna, kancuna uqhumanta ajllaychis allin causayniyoj kanchis kharicunata, yachayniyoj cajcunata, Santo Espirituwan junt'a cajcunata. Cay ruwanata paycunaman kosunchis. ");
INSERT INTO qulNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nokaycutaj oracionta ruwasajcu, Diospaj palabrantataj willasajcu. ");
INSERT INTO qulNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tucuynincuman chay niskancu allin yuyacorkan. Ajllarkancutaj Estebanta, paytaj Diospi sinchi creeyniyoj, Santo Espirituwan junt'a carkan. Ajllallarkancutaj Felipeta, Procorota, Nicanorta, Timonta, Parmenasta, Nicolastawan. Nicolaska Antioquía llajtamanta carkan, mana judío llajtayojchu, chaywanpas judiocunapaj religionninman cuterkan. ");
INSERT INTO qulNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Chay ajllaska kharicunata apostolcunapajman pusamojtincu, apostolcuna maquincuta churaycuspa oracionta ruwarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ajinapi Diospaj palabran astawan astawan caruman willaska carkan. Jerusalenpitaj creyentecuna astawan yapacorkancu. Achqha judío sacerdotecuna creellarkancutaj. ");
INSERT INTO qulNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esteban Diospaj bendiciskan caspa, sinchi atiywan milagrocunata ruwachcarkan. ");
INSERT INTO qulNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Chaywanpas, Libraska Runacuna niska sinagogamanta waquin judiocuna Estebanwan churanacuyta kallarerkancu. Paycunawan carkan waquin Cirenemanta, Alejandriamanta, Ciliciamanta, Asia provinciamantawan. ");
INSERT INTO qulNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Churanacuchcaspa, Estebanta mana atipayta aterkancuchu, Santo Espiritupaj yachayninwan parlaskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Chayraycu chay judiocuna wajcunaman kolketa korkancu llullacunancupaj, “Estebanta uyarerkaycu Moisespaj leynin contra, Dios contra mana allincunata parlajta” nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ajinapi Esteban contra pituchcarkancu Jerusalenpi caj runacunata, llajtapaj jefencunata, leymanta yachachejcunatawan. Estebanta jap'ispa, Athun Asambleaman pusarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Masc'arkancutaj llulla testigocunata. Chaycunataj Esteban contra nerkancu: —Cay runaka mana dejayta millayta parlan santo templo contra, nokaycupaj leyniycu contra. ");
INSERT INTO qulNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Uyarerkaycu nejta Nazaretmanta caj Jesús cay templota urmachinanta, Moisespaj yachachiskan costumbrecunatapas cambiananta. ");
INSERT INTO qulNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Autoridadcuna tucuy chaypi tiyachcajcunapiwan khawachcaspa, Estebanta angelpaj uyanta jina ricorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Curaj sacerdote Estebanta taporkan: —¿Ajinachu caycuna kan contra niskancu? ");
INSERT INTO qulNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Estebantaj contestarkan: “Waukecuna, tatacuna, uyariwaychis. Glorioso atiyniyoj Diosninchis abuelonchis Abrahamman riqhurerkan Mesopotamiapi cachcajtin, manaraj Harán llajtaman puripuchcajtin. ");
INSERT INTO qulNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Dios payta nerkan: ‘Sakepuy cay jallp'ayquita, parienteyquicunatapas. Puripuy noka ricuchiskayqui chay jallp'aman.’ ");
INSERT INTO qulNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Chayraycu Abraham Caldea llajtamanta llojsipuspa, Harán jallp'aman tiyaj puriporkan. Abrahampaj tatan wañupojtin, Dios payta pusamorkan cay jallp'aman, maypichus kancuna cunan cachcanquichis chayman. ");
INSERT INTO qulNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Chaywanpas chay jallp'aman chayajtin, Dios mana Abrahamman ni uj chhican jallp'ata korkanchu. Chaywanpas Dios prometerkan Abraham wañupojtin wawancuna cay jallp'ayoj canancuta. Dios chayta nejtin, Abrahampaj manaraj wawan carkanchu. ");
INSERT INTO qulNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Dios nillarkantaj: ‘Kanpaj mirayniyqui waj nacionpi tiyankacu. Chaypi tawa pachaj watata gobernajpaj mandaskanpi caspa ñac'arenkacu.’ ");
INSERT INTO qulNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Dios nillarkantaj: ‘Nokaka ñac'arichej runacunata castigasaj. Tawa pachaj watamanta kanpaj mirayniyquicuna chay llajtamanta llojsiponkacu, caypitaj nokata sirviwankacu.’ ");
INSERT INTO qulNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Dios Abrahamta mandarkan circuncisión costumbreta ruwananpaj, compromiso jap'ekaskanta ricuchinanpaj. Chayraycu Abraham cay circuncisión costumbreta churin Isaacwan ruwarkan, pusaj p'unchay naciskanmanta. Ajinallatataj Isaac paypaj churin Jacobwan ruwarkan. Ajinallatataj Jacob paypaj churincunawan ruwarkan. Jacobpaj chunca iscayniyoj churincunataj tucuy Israel runacunapaj tatan carkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Chay Jacobpaj churincunaka abuelonchiscuna carkancu. Paycunataj waukencu Joseta envidiacuspa, venderkorkancu. Ranticojcunataj Egipto nacionman pusaporkancu. Chaywanpas Dios Joseta wakaychachcarkan. ");
INSERT INTO qulNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Dios Joseta tucuy ñac'ariyninmanta librarkan. Diospaj bendiciskan cajtin, Egipto gobernaj Faraón niska repararkan José allin yachayniyoj caskanta. Chayraycu Joseta churarkan Egipto nacionpi gobernananpaj, gobierno wasipi mandacunanpajpiwan. ");
INSERT INTO qulNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Chay p'unchaycunapi sinchi yarekay ñac'ariypiwan carkan enteron Egipto nacionpi Canaannintinpi. Abuelonchiscunapajpas mana miqhunancu carkanchu. ");
INSERT INTO qulNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jacobtaj Egiptopi trigo caskanta yachaspa, churincunata cacharkan. Paycunataj abuelonchiscuna carkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Iscay cutitaña purejtincu, José waukencunawan rejsichicaporkan. Ajinapi Faraón Joseta rejserkan ima familia caskanta. ");
INSERT INTO qulNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Josetaj tatan Jacobta wajacherkan tucuy familianwan Egiptoman jampunanpaj. Lliujnincu kanchis chunca phichkayoj carkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ajinapi Jacob Egiptoman tiyaj puriporkan, chaypitaj wañuporkan. Chayllapitaj abuelonchiscuna wañuporkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Khepamantaj Jacob wañuskata aparkancu Siquem llajtaman, Hamorpaj familianmanta Abrahampaj rantiskan jallp'api p'ampamunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Abrahamman Diospaj prometiskan tiempo junt'acuchcarkanña. Chay tiempopi Israel runacuna sinchita miraporkancu Egiptopi. ");
INSERT INTO qulNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ajinallatataj Egipto nacionpi waj gobernayta kallarerkan, mana José rejsej. ");
INSERT INTO qulNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Chay gobernajtaj abuelonchiscunata engañaspa ñac'aricherkan. Mandarkantaj khari wawa nacejtin wijch'unancupaj, jinapi wañunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Chay tiempopi Moisés nacerkan. Diostaj paywan cusiska carkan. Quimsa quillata tata maman wasinpi uywarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Sakepunancu cajtintaj, Faraonpaj ususin tarispa, churinta jina uywacaporkan. ");
INSERT INTO qulNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ajinapi Moisés tucuy Egipto runacunapaj yachayninwan yachachiska carkan. Allin respetaska runa carkan parlayninpi ruwaynincunapipas. ");
INSERT INTO qulNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Moisestaj tawa chunca watayojña cachcaspa, Israel runacunata watumuyta munarkan, paypas israelita caskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Chayaspataj, uj Egipto llajtayoj runata ricorkan Israel runata makachcajta. Israel runata jarc'acuspa, Egipto runata wañucherkan vengacuspa. ");
INSERT INTO qulNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisés yuyarkan Israel llajtamasincuna pay Diospaj ajllaskan caskanta reparanancuta, Egipto runacunamanta paycunata librananpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","K'ayantintaj Moisés ricorkan iscay Israel kharicuna makanacuchcajta. Allinyachiyta munaspataj, paycunata nerkan: ‘Kancunaka llajtamasi canquichis, ¿imaraycutaj kancunapura makanacuchcanquichis?’ ");
INSERT INTO qulNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Makaj runataj Moisesta tankarparispa nerkan: ‘¿Pitaj kanta churasunqui nokaycupaj jefeta, juezta jina? ");
INSERT INTO qulNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Nokatañatajchu wañuchiyta munawanqui imaynatachus kayna Egipto runata wañuchinqui jinata?’ ");
INSERT INTO qulNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Chayta uyarispa, Moisés Egiptomanta Madián jallp'aman escapaporkan. Chaypi waj llajtayoj jina tiyarkan. Chaypitaj paypaj iscay churin nacerkan. ");
INSERT INTO qulNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Tawa chunca wata pasayta, Sinaí loma kaylla ch'usaj lugarpi uj ángel Moisesman riqhurerkan nina laurachcaj ch'umi sach'api. ");
INSERT INTO qulNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Chayta ricuspa, muspharkan. Allinta ricunanpaj chimpaycuspataj, Señor Diospaj vozninta uyarerkan: ");
INSERT INTO qulNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Noka cani abueloyquicunapaj Diosnin. Noka cani Abrahampaj, Isaacpaj, Jacobpaj Diosnin’ nispa. Moisestaj manchacuymanta qharcatiyta kallarerkan. Manaña khawayta atrevicorkanchu. ");
INSERT INTO qulNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Señor Diostaj payta nerkan: ‘Abarcayquita thatacuy; imaraycuchus cachcaskayqui lugarka santo Diospaj cachcaskan. ");
INSERT INTO qulNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Allinta ricuni Egipto llajtapi nokapaj ajllaskay runacuna ñac'ariskanta. Uyarinitaj aycojta. Chayraycu urakamuni paycunata salvanaypaj. Jamuy, Egiptoman cachaskayqui.’ ");
INSERT INTO qulNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ñaupaj, Israel runacuna Moisesta mana munarkancuchu, ‘¿Pitaj kanta churasunqui jefeta, juezta jina?’ nispa. Diostaj ch'umi sach'api angelta riqhuricherkan. Ajinapi Dios Moisesta cacharkan paycunapaj autoridadnin cananpaj, paycunata librananpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moisestaj abuelonchiscunata pusamorkan Egiptomanta. Tawa chunca watapacha milagrocunata ruwachcarkan Egiptopi, Puca Kochapi, ch'usaj pampapipas. ");
INSERT INTO qulNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Chay quiquin Moisés Israel runacunata nerkan: ‘Kancunapaj mirayniyquichis quiquinmanta Dios uj profetata churanka nokata jina.’ ");
INSERT INTO qulNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moisestaj abuelonchiscunawan tantacorkan ch'usaj pampapi. Sinaí lomapi uj angelwan parlaspa, Diospaj causay palabranta jap'ekarkan. Chay palabrantataj willawarkanchis. ");
INSERT INTO qulNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Abuelonchiscunataj mana Moisesta casuyta munarkancuchu. Chayraycu Egiptoman cutipuyta munachcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Israel runacunataj Aaronta nerkancu: ‘Nokanchispaj Dioscunata ruway, pusanawanchispaj. Egiptomanta pusamuwajninchis Moisés imanacapunchari, mana yachaycuchu ima pasaskanta’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Paycunataj uña wacaman rijch'acoj idolota ruwarkancu. Maquincuwan ruwaskancu idolota adoranancupaj wacacunata ovejacunatawan wañucherkancu, fiestata ruwarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Chayraycutaj Dios paycunamanta carunchacapuspa, sakerkan koyllurcunata adoranancupaj. Profetacunapaj libroncupi cay jina escribiska carkan: ‘Israel runacuna, tawa chunca wata ch'usaj pampapi cachcaspa, ¿nokapajchu wacacunata wañucherkanquichis? ");
INSERT INTO qulNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Manami nokapajchu, kancunapaj ruwaskayquichis idolocunapaj. Moloc diospaj toldonta apaspa, chaypi Moloc idolocunata adorachcarkanquichis, Refán diospaj koyllurnincunatapas. Chayraycu waj nacioncunaman wijch'uskayquichis, Babilonia llajtamanta astawan carumanraj.’ ");
INSERT INTO qulNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Abuelonchiscuna ch'usaj pampapi cachcajtincu, Diosta adoranancupaj compromiso toldo niska carkan templo jina, Diospaj yachachiskanman jina ruwaska. Dios Moisesman ricucherkan imaynata chay toldota ruwananpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Diospaj chay toldonta tatacuna churincunaman koporkancu herenciata jina. Abuelonchiscunataj chay toldota apaspa, cay jallp'acama chayamorkancu. Caypi tiyaj runacunata atiparkancu, imaraycuchus Dios chay runacunata cay jallp'amanta wijch'orkorkan abuelonchiscunaman kopunanpaj. Chay toldopi Diosta adorachcarkancu Davidpaj tiemponcama. ");
INSERT INTO qulNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Diostaj Davidwan cusiska carkan. Davidtaj Diosmanta permisota mañacorkan adorana wasita ruwananpaj, Davidpaj abuelon Jacobpaj Diosnin chaypi tiyananpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Dios Davidman mana permisota korkanchu, manachayri churin Salomón ruwarkan Dios adorana wasita. ");
INSERT INTO qulNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Chaywanpas janaj pachapi caj Dioska mana runapaj ruwaskan templocunapichu tiyan. Uj profeta nerkan: ");
INSERT INTO qulNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Señor Dios nin: Janaj pacha nokapaj tiyacunay. Cay pachataj chaquiycuna churanay. ¿Imayna wasitataj ruwapuwanquichis? ¿Maykentaj canman samaricunaypaj, ");
INSERT INTO qulNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","noka quiquiy cay tucuy imata ruwajtiyri?’ ” ");
INSERT INTO qulNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Esteban nillarkantaj: “Kancunaka rumi sonko canquichis. Diospaj palabranta mana uyariyta munanquichischu, Diosmanta mana yachajcuna jina. Santo Espíritu contra cachcanquichis, ñaupaj abueloyquichiscuna jina. ");
INSERT INTO qulNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Mayken profetacunatataj abueloyquichiscuna mana ñac'aricherkancuchuri? Justo caj jamunanmanta willaj profetacunata wañucherkancu. Cunanka chay justo caj jamunña, kancunataj vendiycuspa wañucherkanquichis. ");
INSERT INTO qulNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Angelcuna uqhunta Diospaj leyninta jap'ekarkanquichis, kancunataj mana casucunquichischu.” ");
INSERT INTO qulNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Chayta uyarispa, Esteban contra quiruncuta c'uturacuspa sinchita phiñaricuskancuta ricucherkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Paytaj Santo Espirituwan junt'a caspa, janaj pachata khawarispa Diospaj glorioso c'anchayninta ricorkan, Jesustataj Diospaj pañan ladopi sayachcajta. ");
INSERT INTO qulNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Nerkantaj: —¡Khawariychis, janaj pachata quicharaskata ricuni, Diospaj Churintataj pañan ladopi sayachcajta! ");
INSERT INTO qulNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Paycunataj ninrincuta tapaycucuspa sinchita wajach'acuspataj, Estebanman phawararkancu jap'inancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Llajtamanta wijch'orkospa rumicunawan chhokarkancu. Juchachajcunataj p'achancuta churarkancu Saulo sutiyoj wayna wakaychananpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Rumiwan chhokachcanancucama, Esteban oracionta ruwarkan: “Señor Jesús, espirituyta jap'ekay” nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Konkoriycuspataj alto vozwan nerkan: “¡Señor, ama paycunata juchachaychu cay ruwaskancumanta!” Chayta nispataj, wañuporkan. ");
INSERT INTO qulNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo chaypi cachcarkan. Estebanta wañuchiskancoka Sauloman allin yuyacorkan. Chay quiquin p'unchay Jerusalenpi creyentecunata sinchita ñac'arichiyta kallarerkancu. Chayraycu tucuy creyentecuna escaparkancu Judeaman Samariaman ima. Apostolcunalla Jerusalenpi quedacorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Waquin allin creyentecuna sinchita wakaspa Estebanta p'ampamorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulotaj creyentecunata masc'achcarkan ñac'arichinanpaj. Wasimanta wasi yaycuspataj, creyentecunata jawaman katatispa orkhomorkan, carcelman wisk'achinanpaj kharicunata warmicunatapas. ");
INSERT INTO qulNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jerusalenmanta escapacoj creyentecuna tucuynejman purispa, salvación evangeliota willararkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ujnin, Felipe sutiyoj, Samariapaj curaj llajtanman purispa, Jesucristomanta willayta kallarerkan. ");
INSERT INTO qulNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Runacuna tantacamuspa, Felipepaj niskanta allinta uyarerkancu, ricorkancutaj pay atiywan milagrocunata ruwaskanta. ");
INSERT INTO qulNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Achqha sajra espirituyoj runacunata alliyacherkan. Sajra espiritucunataj wajach'acuspa, runacunamanta llojsirarkancu. Ajinallatataj achqha such'u, cojo runacunatapas alliyacherkan. ");
INSERT INTO qulNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Chayraycu chay llajtapi runacunaka sinchita cusicorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Chaypitaj uj runa Simón sutiyoj carkan, ñaupajka laykacuskancunawan runacunata engañarkan. Paytaj athun atiyniyojmanta rejsichicuyta munarkan. ");
INSERT INTO qulNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Tucuy runacuna, juch'uymanta athuncama, Simonta allinta uyarerkancu, nerkancutaj: “Caymi chay ‘Diospaj athun atiynin.’ ” ");
INSERT INTO qulNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Unayña runacunata laykacuskancunawan engañarkan, chayraycu payta casorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Cunanka Felipe Diospaj gobiernonmanta Jesucristomantawan evangeliota willajtin, achqha kharicuna warmicunapiwan creespa bautizachicorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Chay quiquin Simón creespa bautizachicorkan. Chaymantataj Felipewan purichcarkan; Felipepaj ruwaskan milagrocunata ricuspa muspharkan. ");
INSERT INTO qulNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Apostolcunataj Jerusalenpi cachcaspa uyarerkancu Samariapi caj runacuna Diospaj palabranta creeskancuta. Chayta yachaspataj Pedrota Juantawan Samariaman cacharkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Chayaspataj, creyentecunapaj oracionta ruwarkancu, Santo Espirituta jap'ekanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Imaraycuchus Señor Jesucristopaj sutinpi paycuna bautizaska cachcaspa, Santo Espirituta manaraj maykennincupas jap'ekaskacuchu. ");
INSERT INTO qulNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Chayraycu Pedro Juanpiwan creyentecuna pataman maquincuta churarkancu. Ajinapitaj Santo Espirituta jap'ekarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simontaj Santo Espirituta jap'ekaskancuta ricuspa, apostolcunaman kolketa koyta munarkan. ");
INSERT INTO qulNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Nerkantaj: —Nokamanpas chay atiyta kowaychis. Ajinata pimanpas maquiyta churajtiy, paycuna Santo Espirituta jap'ekanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pedrotaj payta nerkan: —¡Kolkeyqueka kanwan cusca juchachaska cachun, Diospaj regalonta kolkewan rantiyta munaskayquiraycu! ");
INSERT INTO qulNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Cay atiytaka mana jap'ekayta atiwajchu, imaraycuchus kanpaj sonkoyqui mana justochu Diospaj ñaupakenpi. ");
INSERT INTO qulNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Juchayquita sakespa, Diosmanta mañacuy, ichapas mana allin pensaskayquita perdonasunquiman. ");
INSERT INTO qulNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Noka ricuni kan envidiawan junt'a caskayquita, mana allin ruwaskayquicunawan wataska jina caskayquita. ");
INSERT INTO qulNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simontaj contestarkan: —Nokapaj Diosmanta mañaripuwaychis, cay niskayquichiscunamanta mana imapas pasanawanpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Apostolcuna Jesucristomanta willaraspa, Diospaj palabranta yachacherkancu. Samaria provinciapi purichcaspa, achqha llajtacunapi evangeliota willarkancu. Chaymanta Jerusalenman cutiporkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Chay pasayta, Señorpaj angelnin Felipeta nerkan: “Jatariy, puriy urayman, Jerusalenmanta Gazaman purej ñanman.” Chay ñanka ch'usaj pampanta pasan. ");
INSERT INTO qulNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Felipe jatarispa puriporkan. Chay ñanpi uj athun autoridadwan tuparkan; Etiopiapi gobernaj warmipaj kolke wakaychajnin carkan. Payka Jerusalenman Diosta adoraj puriskanmanta cutipuchcarkan. ");
INSERT INTO qulNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Carronpi tiyaspa profeta Isaiaspaj libronta leechcarkan. ");
INSERT INTO qulNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Santo Espiritutaj Felipeta nerkan: “Puriy, chay carroman chimpaycuy” nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Felipetaj chimpaycuspa, uyarerkan Etiopía runa Isaiaspaj escribiskan librota leechcajta. Taporkan: —¿Leeskayquita entendinquichu? ");
INSERT INTO qulNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Etiopía runataj contestarkan: —¿Imaynatataj entendisaj, mana pipas yachachiwajtinri? Felipeta wajajtin, carroman sekarkan, paywan cuscataj tiyaycorkan. ");
INSERT INTO qulNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Leeskan Escritura cay jinata nerkan: “Payka apaska carkan oveja jina wañuchiska cananpaj. Imayna ovejata millmanta rutojtincu jup'alla, ajinallatataj paypas jup'alla callarkantaj. ");
INSERT INTO qulNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Humillaska cajtin, paypaj justicia mana carkanchu. ¿Pitaj parlayta atinman mirayninmantari? Cay pachapi paypaj causaynenka kora jina t'iraska carkan.” ");
INSERT INTO qulNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Etiopía autoridadka Felipeta taporkan: —Willariway, ¿pimantataj profeta cayta nin? ¿Pay quiquinmantachu, icha wajmantachu? ");
INSERT INTO qulNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Felipetaj leeskan Escrituramantapacha kallarispa, Jesucristomanta evangeliota willarkan. ");
INSERT INTO qulNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ñanta purichcaspataj, unuyojman chayarkancu. Autoridadtaj nerkan: —Khawariy, caypi unu can. ¿Manachu bautizaska cayta atiyman? ");
INSERT INTO qulNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Felipetaj nerkan: —Tucuy sonkoyquiwan creenqui chayka, aticun bautizaska canayquipaj. Etiopía runataj contestarkan: —Arí, creeni Jesucristoka Diospaj Churin caskanta. ");
INSERT INTO qulNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Paytaj carrota sayacherkan. Iscaynincutaj urakaspa, unuman yaycorkancu. Felipetaj payta bautizarkan. ");
INSERT INTO qulNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Unumanta llojsimpojtincu, Diospaj Espíritun Felipeta pusaporkan. Etiopía runataj Felipeta mana astawan ricorkanñachu. Ñantataj may cusiska puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipetaj Azoto llajtapi riqhurerkan. Llajtamanta llajta purispa, Jesucristomanta evangeliota willachcarkan Cesarea llajtaman chayanancama. ");
INSERT INTO qulNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulo Señor Jesucristopi creejcunata amenazachcarkan wañuchinanpaj. Curaj sacerdotewan parlaj purerkan. ");
INSERT INTO qulNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Paymantataj autorizacionta mañarkan, Damasco llajtaman purispa sinagogacunapi ricuchimunanpaj, Señorpaj Ñanninpi purejcunata, kharicunata warmicunatapas, taripaspa, tucuynincuta presota jap'ispa Jerusalenman apananpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Damasco llajta kayllapiña cachcajtin, janaj pachamanta uj c'anchay Sauloman konkaylla c'anchaycamorkan. ");
INSERT INTO qulNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Paytaj pampaman chhokacuspa uj vozta uyarerkan nejta: “Saulo, Saulo, ¿imaraycutaj ñac'arichinawayquipaj katiycachawanqui?” ");
INSERT INTO qulNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saulo taporkan: “¿Pitaj canqui, Señor?” nispa. Voztaj janaj pachamanta contestarkan: “Noka cani Nazaret llajtayoj Jesús. Noka quiquiytataj katiycachachcawanqui ñac'arichinawayquipaj. Manami allinchu kanpaj qhichca punta jayt'anayqueka; kancamalla nanachicuchcanqui.” ");
INSERT INTO qulNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Saulo mancharicuymanta qharcatispa taporkan: “¿Imatataj ruwanayta munanqui, Señor?” Señor Jesustaj nerkan: “Jatarispa Damasco llajtaman yaycuy, chaypitaj ima ruwanayquita willasunquichis.” ");
INSERT INTO qulNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Saulowan purejcunataj sinchita mancharicorkancu. Voz parlamojta uyarerkancu, manataj pitapas ricorkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulo sayarispa ñawincunata quicharejtin, ni imatapas ricuyta aterkanchu. Maquinmanta aysaspa Damasco llajtaman pusaporkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Quimsa p'unchayta chaypi carkan mana ricucuspa, mana miqhuspa, ni unutapas ujyaspa. ");
INSERT INTO qulNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damascopi uj creyente carkan Ananías sutiyoj. Señor Jesustaj payman riqhurerkan moskoypi jina, nerkantaj: “¡Ananías!” Paytaj contestarkan: “Caypi cani, Señor.” ");
INSERT INTO qulNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Señor Jesustaj nerkan: “Jatariy, Derecha niska calleman puriy. Judaspaj wasinpi Tarso llajtayoj Saulomanta tapucuy. Payka oracionta ruwachcan. ");
INSERT INTO qulNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Moskoypi jina ricusunqui, chayaspa payman maquiyquita churajtiyqui, wajmanta khawacuyta atinanpaj.” ");
INSERT INTO qulNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Chayta uyarispa, Ananías nerkan: “Señor, chay runamanta achqhayoj willawarkancu, Jerusalenpi kanpi creejcunata sinchita ñac'arichiskanta. ");
INSERT INTO qulNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Cunanpas curaj sacerdotepaj autorizaskanwan cay llajtamanpas jamun, tucuy kanpi creejcunata presota jap'inanpaj.” ");
INSERT INTO qulNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Señortaj nerkan: “Payman puriy. Noka chay runata ajllani waj nacioncunapi caj runacunaman, gobernajcunaman, Israel runacunamanpas nokamanta willamunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Noka payman ricuchisaj jayc'atachus nokaraycu ñac'arinanta.” ");
INSERT INTO qulNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananiastaj Saulopaj cachcaskan wasiman purerkan. Yaycuspataj, Sauloman maquinta churaycuspa, nerkan: —Hermano Saulo, ñanpi jamuchcajtiyqui, Señor Jesús riqhuriskasunqui. Chay quiquin Jesús cachamuwan kan ricucapunayquipaj, Santo Espirituwan junt'a canayquipaj. ");
INSERT INTO qulNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Chhicapacha Saulopaj ñawinmanta concha jina urmakararkan, paytaj wajmanta ricucaporkan. Jatarispataj bautizachicorkan. ");
INSERT INTO qulNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Chaymanta miqhuspa callpachacorkan. Uj iscay p'unchayta Damascopi tiyaj creyentecunawan cachcarkan. ");
INSERT INTO qulNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Damascopi sinagoga wasicunapi Saulo willayta kallarerkan Jesús Diospaj Churin caskanta. ");
INSERT INTO qulNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Saulopaj niskanta uyarispa, tucuy uyarejcuna muspharaspa, ninacuchcarkancu: —¿Manachu cayri Jerusalenpi katiycachaspa Jesuspi creejcunata ñac'arichej? ¿Manachu pay quiquin caymanpas jamun, creyentecunata presota jap'ispa sacerdotecunapaj jefencunaman apananpaj? ");
INSERT INTO qulNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saulotaj astawan astawan callpachacuspa sut'inta willararkan Jesuska Cristopuni caskanta. Damascopi tiyaj Israel runacunataj mana ima niytapas aterkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Achqha p'unchay pasayta, judiocuna tantacuspa yachachinacorkancu Saulota wañuchinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Saulotaj chayta yachacorkan; tuta p'unchay llajta puncucunapi payta suyachcarkancu wañuchinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Creyentecunataj athun canastapi Saulota tutapi apakarkancu llajtapaj wisk'aska perka patanta. Ajinata escapacorkan. ");
INSERT INTO qulNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulo Jerusalenman chayaspa, creyentecunawan tantacuyta munarkan. Chaywanpas tucuynincu payta manchacorkancu. Mana creerkancuchu Saulo creyenteña capuskanta. ");
INSERT INTO qulNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Chaywanpas uj creyente, Bernabé sutiyoj, Saulota apostolcunaman pusarkan rejsichinanpaj. Willarkan imaynata ñanpi Saulo Jesucristota ricuskanta, imaynata Jesús payta parlapayaskanta, imaynata Damasco llajtapi mana manchacuspa Jesusmanta willaskantawan. ");
INSERT INTO qulNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ajinapi Saulo Jerusalenpi quedacorkan, creyentecunawantaj puriycacharkan. ");
INSERT INTO qulNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Mana manchacuspa Señor Jesusmanta parlarkan griego idioma parlaj judiocunawan. Paycunataj Saulota wañuchiyta munarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Chayta yachaspataj, creyentecuna Saulota Cesarea llajtaman pusarkancu. Chaymantataj Tarso llajtanman cachaporkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tucuy Judea, Galilea, Samaria provinciacunapi caj creyentecuna sonko tiyaycuska carkancu. Espiritupi wiñaspa, Señorta respetaspa, Santo Espiritupaj yanapayninwan causachcarkancu, achqhayachcarkancutaj. ");
INSERT INTO qulNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pedro tucuynejta purej carkan creyentecunata watuspa. Ajinapi Lida llajtaman chayarkan. ");
INSERT INTO qulNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Chaypitaj Eneas sutiyoj runata tariparkan, pusaj wataña such'u caskanraycu puñunanmanta mana sayariskachu. ");
INSERT INTO qulNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pedrotaj payta nerkan: —Eneas, Jesucristo alliyachisunqui. Jatariy, puñunayquita okhariy. Chhicapacha Eneas jatarerkan. ");
INSERT INTO qulNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Lida, Sarón llajtacunapi tucuy tiyajcuna Eneasta alliyaskata ricuspa, Señor Jesucristoman cutiricorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Chay tiempopi, Jope llajtapi uj creyente carkan Tabita sutiyoj. Griego idiomapi niyta munan “Dorcas”. Payka achqha allincunata ruwaj carkan, pobrecunatapas yanapaj. ");
INSERT INTO qulNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Onkoycuspataj wañuporkan. Ayata bañaspataj wasipaj altosninpi churarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jope llajtaka mana carupichu carkan Lida llajtamanta. Lidapi Pedro caskanta yachaspataj, creyentecuna iscay kharicunata cacharkancu Pedrota wajamunancupaj: “Jopeman jamuchun cunanpacha” nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pedrotaj paycunawan purerkan. Jopeman chayajtincutaj, Pedrota pusaycorkancu wañuskapaj cachcaskan wasi uqhuman. Viudacuna wakaspa Pedrota muyuycorkancu, Dorcaspaj ruwaskan p'achacunata ricuchinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pedrotaj tucuynincuta jawaman llojsicherkan. Konkoriycuspataj Diosmanta mañacorkan. Wañuskata khawarispataj, nerkan: —¡Tabita, jatariy! —nispa. Payka ñawincunata quicharispa, Pedrota ricorkan, tiyarerkantaj. ");
INSERT INTO qulNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedro maquinmanta aysarispa, sayaricherkan. Creyentecunata viudacunatawan wajaspa, Dorcasta causariskataña ricucherkan. ");
INSERT INTO qulNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Tucuynej Jope llajtapi chay causariskanta yachaspa, achqhayoj Señor Jesucristopi creerkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Achqha p'unchayta Pedro cachcarkan chay llajtapi, suela ruwaj Simonpaj wasinpi. ");
INSERT INTO qulNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Cesarea llajtapi uj runa carkan Cornelio sutiyoj, Italiano niska batallonpaj capitannin. ");
INSERT INTO qulNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Payka Diosta sirvej, tucuy familiantin Diosta adoraj. Achqha kolketa koj pobre judiocunata yanapanapaj, Diosman oracionta ruwacullajpuni. ");
INSERT INTO qulNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Uj p'unchay chaupi tarde chhicata, moskoypi jina sut'ita ricorkan Diospaj angelnin paypaj cachcaskan wasi uqhuman yaycuskanta. Nerkantaj: “¡Cornelio!” ");
INSERT INTO qulNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Corneliotaj angelta khawarispa, manchariska nerkan: “¿Imatataj niyta munawanqui, Señor?” Angeltaj contestarkan: “Oracionniyquicunata Dios uyarin, pobrecunata yanapaskayquipas Diosman agradan. ");
INSERT INTO qulNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Jope llajtaman cachay, Pedro niska Simonta wajamunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Kocha kayllapi suela ruwaj Simonpaj wasinpi cachcan.” ");
INSERT INTO qulNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Chay ángel puripojtin, Cornelio iscay allin sirvejnincunata wajarkan Diosta sirvej ujnin soldadotawan. ");
INSERT INTO qulNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Paycunaman tucuy pasaskanta willaspa, Jope llajtaman cacharkan. ");
INSERT INTO qulNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","K'ayantin purichcaspa Jopeman kayllachcajtincuña, Pedro chaupi p'unchayta wasi pataman llojserkan oracionta ruwananpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Yarekachicuspataj miqhuyta munarkan. Miqhunata waquichipunancucama moskoypi jina ricorkan janaj pachata quicharaskata. ");
INSERT INTO qulNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Cay pachaman uj athun sabanata jina uraycamuchcajta ricorkan, tawantin puntamanta wataskata. ");
INSERT INTO qulNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Sabanapitaj imaymana animalcuna carkan: tawa chaquiyoj animalcuna, pallicuna, pisketocunapas. ");
INSERT INTO qulNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Uj voztaj nimorkan: “Pedro, sayariy; wañuchispa miqhuy” nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pedrotaj contestarkan: “Señor, manapuni; jayc'ajpas miqhojchu cani cay jina khelli animalcunataka.” ");
INSERT INTO qulNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ujtawan voz nimorkan: “Diospaj limpiochaskantaka ama niychu ‘khelli’ nispaka.” ");
INSERT INTO qulNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Caytaj carkan quimsa cuticama. Chaymanta chay sábana janaj pachaman cutiporkan. ");
INSERT INTO qulNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pedrotaj chay ricuskanmanta, “¿Ima niytataj munan cayri?” nispa pensachcajtinraj, Corneliopaj cachaskan runacuna wasi puncuman chayarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Alto vozwan wajaspa, taporkancu: “¿Caypichu Pedro niska Simón cachcan?” nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pedrotaj ricuskanmanta pensachcajtinraj, Santo Espíritu payta nerkan: “Khawariy, quimsa runacuna masc'achcasunquichis. ");
INSERT INTO qulNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Sayarispa urakay, ama iscayrayaspataj paycunawan puriy. Noka paycunata cachamuni.” ");
INSERT INTO qulNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pedrotaj urakaspa, paycunata nerkan: —Noka cani kancunapaj masc'askayquichiska. ¿Imapajtaj jamunquichis? ");
INSERT INTO qulNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Paycuna contestarkancu: —Capitán Cornelio cachamuwancu. Payka justo runa, Diosta adoraj. Tucuy judiocuna payta respetancu, munacuncutaj. Diospaj angelnin payman nerkan, kanta wasinman wajachinasunquipaj niskayquita uyarinanpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pedrotaj wasiman pusaycuspa, paycunata korpacharkan. K'ayantin paycunawan purerkan, waquin Jopepi tiyaj creyentecunapiwan. ");
INSERT INTO qulNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Khepantin p'unchayta Cesarea llajtaman chayarkancu. Corneliotaj parientencunawan allincaj amigoncunapiwan suyachcarkan. ");
INSERT INTO qulNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pedro chayajtin, Cornelio wasinmanta llojserkan jap'ekananpaj. Pedropaj ñaupakenpitaj konkoriycorkan payta adorananpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pedrotaj Corneliota aysarispa, nerkan: —Sayariy, nokapas kan jina runallataj cani. ");
INSERT INTO qulNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pedro Corneliowan parlaspa wasinman yaycorkan. Chaypitaj achqha runa tantaskata tariparkan. ");
INSERT INTO qulNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pedrotaj paycunata nerkan: —Kancuna yachanquichis jina, judiocunaka wajcunawan mana tantacuycumanchu, nitaj wasincumanpas yaycuycumanchu, leyniycu prohibiwaskancuraycu. Chaywanpas Dios yachachiwan manaña pitapas ‘khelli’ ninaypaj. ");
INSERT INTO qulNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Chayraycu wajachimuwajtiyqui, mana iscayrayaspa jamuni. Cunantaj yachayta munani imapaj wajachiwaskayquita. ");
INSERT INTO qulNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Corneliotaj nerkan: —Tawa p'unchayña cachcan, cay horata jina wasiypi ayunachcarkani, oraciontataj ruwachcarkani. Oracionta ruwachcajtiy, uj khari riqhuriwan lliphipichcaj p'achayoj. ");
INSERT INTO qulNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Nokata niwarkan: ‘Cornelio, Dios oracionniyquita uyarin, pobrecuna yanapaskayquita yuyaricun. ");
INSERT INTO qulNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Jope llajtaman cachay, Pedro niska Simonta wajamunancupaj. Suela ruwaj Simonpaj wasinpi cachcan, kocha kayllapi. ");
INSERT INTO qulNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ajinapi chhicapacha kanman wajajta cachamorkani. Allin jamunqui. Cunanka tucuyniycu Diospaj ñaupakenpi tantaycuskaña caycu. Uyariyta munaycu Señor Diospaj tucuy mandacuskanta nokaycuman willanawayquichista. ");
INSERT INTO qulNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pedro willayta kallarerkan: —Cunanka ciertota yachani may nacionmanta caj runapas quiquillanpuni Diospajka caskanta. ");
INSERT INTO qulNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Dioska tucuy nacioncunamanta payta respetaj allin ruwaj runacunata jap'ekan. ");
INSERT INTO qulNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Dios Israel runacunaman sonko tiyaycuy evangeliota willacherkan, Jesucristopi creespa Dioswan allinyacapunancupaj. Jesucristoka tucuypaj Señornin. ");
INSERT INTO qulNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Kancuna allinta yachanquichisña tucuy ima pasaskanta Galilea provinciapi judiocunapaj tucuy nacionninpipas, bautizacunancupaj Juan willaskanmantapacha. ");
INSERT INTO qulNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Yachallanquichistaj Dios Nazaret llajtayoj Jesusta Santo Espirituwan atiyninpiwan junt'achiskanmanta. Jesustaj allincunata ruwaspa, supaypaj ñac'arichiskan runacunata alliyachispa tucuynejta purichcarkan. Tucuy chaycunata ruwayta atej, Dios paywan caskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Nokaycutaj Jesucristopaj tucuy ruwaskancunata ricorkaycu Judea provinciapi Jerusalén llajtapipas. Paycunataj Jesusta cruzpi chacataspa wañucherkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Diostaj quimsa p'unchaymanta Jesusta causaricherkan, nokaycumantaj riqhurichiwarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Mana tucuy runamanchu riqhurerkan, manachayri nokallaycuman riqhuriwarkancu, ñaupajmantapacha Diospaj ajllaskan caskaycuraycu, ricuskaycuta willanaycupaj. Causarimojtintaj, nokaycu Jesuswan cusca miqhorkaycu, ujyarkaycutaj. ");
INSERT INTO qulNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Paytaj nokaycuta cachawancu tucuy runacunaman paymanta willaramunaycupaj. Dios cay quiquin Jesusta Juezta jina churan wañuskacunata causajcunatapas juzgananpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Tucuy profetacuna Jesusmanta willarkancu, paypi creejtincu juchancuta Dios perdonananpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pedro parlachcajtillanraj, Santo Espíritu tucuy uyarejcunaman jamorkan. ");
INSERT INTO qulNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Pedrowan jamoj judío creyentecuna musphararkancu Dios Santo Espirituta koskanmanta mana judío cajcunaman. ");
INSERT INTO qulNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Uyarerkancutaj mana yachaskancu idiomacunapi parlajta Diosta alabajtapas. ");
INSERT INTO qulNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Pedrotaj nerkan: —Paycunapas nokanchis jina Santo Espirituwan junt'a cancu. ¿Pipas jarc'ayta atinmanchu mana bautizachicunancupaj? ");
INSERT INTO qulNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ajinata Pedro mandarkan Jesucristopaj sutinpi bautizacunancuta. Chaypi caj creyentecuna Pedrota rogarkancu pisi p'unchaycunallatapas paycunawan quedacunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Judeapi caj apostolcuna creyentecunapiwan uyarerkancu mana judío caj runacunapas Diospaj palabranta jap'ekaskancumanta. ");
INSERT INTO qulNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pedro Jerusalenman cutimojtin, judío religionmanta creyentecuna pay contra thutorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Payta taporkancu: —¿Imaraycutaj mana judío cajcunata watumunqui? ¿Imaraycutaj paycunawan miqhumunqui? —nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pedrotaj paycunaman willarkan kallariymantapacha Jopepi tucuy ima pasaskanta: ");
INSERT INTO qulNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Jope llajtapi cachcaspa oracionta ruwachcajtiy, moskoypi jina ricorkani uj athun sabanata jina janaj pachamanta uraycamuchcajta, tawantin puntamanta wataskata. ");
INSERT INTO qulNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Allinta khawarispataj, chay uqhupi ricorkani tawa chaquiyoj animalcunata, sajra animalcunata, pallicunata piskocunatawan. ");
INSERT INTO qulNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Uj vozta uyarini, niwantaj: ‘Pedro, sayariy; wañuchispa miqhuy.’ ");
INSERT INTO qulNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nokataj nini: ‘Señor, manapuni; jayc'ajpas miqhojchu cani cay jina khelli animalcunataka’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ujtawan chay voz janaj pachamanta nimuwan: ‘Diospaj limpiochaskanta ama niychu “khelli” nispaka.’ ");
INSERT INTO qulNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Caytataj niwarkan quimsa cuticama. Sabanataj janaj pachaman cutiporkan. ");
INSERT INTO qulNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Chhicapacha quimsa kharicuna chayamorkancu nokapaj cachcaskay chay wasiman. Paycunataj Cesarea llajtamanta cachaska carkancu wajanawancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Santo Espiritutaj mandawarkan, mana iscayrayaspa paycunawan purinaypaj. Cay sojta hermanocunapas nokawan purillarkancutaj. Nokaycutaj Corneliopaj wasinman yaycorkaycu. ");
INSERT INTO qulNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Paytaj willawarkancu uj angelta sayachcajta ricuskanta. Angeltaj payta niska: ‘Jope llajtaman cachay, Pedro niska Simonta wajamunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Pedrotaj kanman willasunqui imaynata kan tucuy familiayquiwan salvaska canayquichispaj.’ ");
INSERT INTO qulNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Noka paycunaman parlayta kallarejtiy, Santo Espíritu paycunaman uraycamorkan, ñaupaj nokanchisman uraycamorkan ajinallatataj. ");
INSERT INTO qulNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Chaypachataj Señorpaj niskanta yuyaricorkani: ‘Ciertota Juan unuwan bautizan. Chaywanpas kancuna Santo Espirituwan bautizaska canquichis.’ ");
INSERT INTO qulNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Señor Jesucristopi creejtinchis, Dios Santo Espirituta nokanchisman cachamorkan. Ajinallatataj paycunamanpas Santo Espirituta cachamojtinri, ¿noka pitaj carkani Dios contra canaypajri? ");
INSERT INTO qulNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Jerusalenpi caj creyentecuna chayta uyarispa, manaña Pedro contra parlarkancuchu. Manachayri Diosta alabaspa, nerkancu: —¡Chhicari mana judío cajcuna Diosman cutirejtincu, Dios wiñay causay salvacionta kollantaj! ");
INSERT INTO qulNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Estebanta wañuchiskancu pasayta, waj creyentecunata ñac'arichiyta kallarerkancu. Chayraycu creyentecuna escapararkancu Fenicia, Chipre, Antioquía llajtacunaman. Chaycunapitaj judiocunallaman evangeliota willarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Chipremanta Cirenemantawan waquin creyentecuna Antioquiaman chayaspataj, Señor Jesucristomanta evangeliota willarkancu mana judío cajcunaman. ");
INSERT INTO qulNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Diostaj atiyninwan paycunata yanaparkan. Chayraycu achqha runa ñaupaj costumbrencuta sakespa, Señor Jesucristopi creerkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Chayta uyarispa, Jerusalén iglesiapi caj creyentecuna Bernabeta Antioquiaman cacharkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Chayaspataj, Bernabé ricorkan chaypi Dios allinta bendiciskanta. Paytaj sinchita cusicorkan. Tucuy creyentecunatataj cunarkan: “Señor Jesucristowan tucuy sonkowan allin fielta causaychis” nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bernabeka sumaj creyente carkan, Santo Espirituwan creeywan junt'a. Ajinata achqhayoj Señor Jesucristopi creerkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Chay pasayta Bernabé Tarso llajtaman purerkan Saulota masc'aj. ");
INSERT INTO qulNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Payta taripaspataj, Antioquiaman pusamorkan. Chaypi uj wata entero yachachispa cachcarkancu. Antioquiapi creyentecunata ‘cristianos’ nispa sutichayta kallarerkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Chay tiempopi waquin profetacuna Jerusalenmanta Antioquiaman purerkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ujnintaj Agabo sutiyoj sayarispa, Santo Espirituwan junt'a willarkan: “Tucuy cay nacionpi athun yarekay canka” nispa. Chay niskantaj jinatapuni junt'acorkan Claudio sutiyoj gobierno cachcajtin. ");
INSERT INTO qulNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Antioquiapi caj creyentecuna “allin” nerkancu sapa uj capuyninman jina yanapayta kallarinancupaj, Judeapi caj creyentecunaman kolketa apachinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ajinata ruwaspa, Bernabewan Saulowanpiwan chay kolketa apacherkancu Judea iglesiapi caj encargadocunaman. ");
INSERT INTO qulNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Chay tiempopi Herodes gobernachcaspa, waquin creyentecunata ñac'arichiyta kallarerkan. ");
INSERT INTO qulNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Juanpaj wauken Santiagota espadawan wañuchicherkan. ");
INSERT INTO qulNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Chaymanta mana creej judío runacuna cusiska caskancuta ricuspa, Herodes Pedrota jap'icherkan. Chayka pasarkan mana levadurayoj t'anta miqhuna fiesta p'unchaycunapi. ");
INSERT INTO qulNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pedrota jap'ichispa, carcelman wisk'acherkan. Chaypitaj tawa grupo soldadocuna Pedrota cuidachcarkancu. Sapa grupopitaj tawa soldado carkan. Herodes pensarkan Pascua pasayta runacunapaj ñaupakenpi Pedrota juzgayta. ");
INSERT INTO qulNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ajinapi Pedroka carcelpi cachcarkan, allin cuidaska. Creyentecunataj tucuy sonkowan paypaj Diosmanta mañachcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herodes Pedrota juchachachinanpaj uj p'unchayllaña cachcajtin, chay tuta Pedro iscay soldadocunapaj chaupinpi puñuchcarkan, iscay cadenawan wataska. Waj soldadocunataj cárcel puncuta cuidachcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Señorpaj angelnin konkay riqhurerkan, carcelman sinchita c'anchaycorkan. Angeltaj Pedrota wajtanmanta llanqhaycuspa rijch'acherkan, nerkantaj: “¡Uskhayta jatariy!” nispa. Chhicapacha cadenacuna maquincunamanta pascaracorkan. ");
INSERT INTO qulNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Angel nillarkantaj: “P'achayquita abarcayquitawan churacuy” nispa. Pedrotaj niskanman jina ruwarkan. Angel nillarkantaj: “Ponchoyquita churacuy; khepayta jamuy” nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Angelpaj khepanta carcelmanta llojsispa, Pedro mana yacharkanchu angelpaj ruwaskan sut'ipichu moskoypichu caskanta. Payka yuyarkan moskoypi jina ricuskanta. ");
INSERT INTO qulNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ajinapi pasarkancu ñaupajcaj guardiajcunata, ajinallatataj iscaycaj guardiajcunatapas, fierro puncuman chayanancucama. Chay calleman llojsej puncutaj payllamanta quicharacorkan. Llojsispataj, uj calleta purichcaspa konkaylla ángel Pedrota sapallanta sakerparerkan. ");
INSERT INTO qulNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Pedrotaj yuyayninman cutirispa, nerkan: “Ciertota yachani Señor angelninta cachamuskanta, Herodesmanta libranawanpaj judiocuna tucuy ima ruway munawaskancumantawan.” ");
INSERT INTO qulNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Chayta reparacuytawan, Marcos niska Juanpaj maman Mariapaj wasinman purerkan. Chaypitaj achqha creyentecuna tantaska, Diosmanta mañacuchcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pedro calle puncuta tacajtin, uj sipas Rode sutiyoj llojserkan pichus caskanta yachaj. ");
INSERT INTO qulNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Rodetaj Pedropaj vozninta rejserkospa, cusiska phawaycorkan ujcunaman willaraj Pedro puncupi sayachcaskanta, puncutapas mana quicharaspa cusicuymanta. ");
INSERT INTO qulNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Paycunataj nerkancu: —¡Mana yuyayniyquipichu canqui! Paytaj: —Ciertopuni —nerkan. Paycunataj nerkancu: —Mana Pedrochu, angelninchari —nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Chhicacamataj Pedro puncuta tacachcarkan quicharanancupaj. Quicharaspataj, ricorkancu; mancharicorkancutaj. ");
INSERT INTO qulNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pedrotaj maquinwan señascharkan jup'allanancupaj. Willarkantaj imaynata Señor carcelmanta orkhomuskanta. Nillarkantaj: —Willaychis Santiagoman hermanocunamanpas. Llojsipuspataj, waj lugarman puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Pakariyajtintaj, soldadocuna sinchi llaquiska manchariska parlarachcarkancu, Pedrowan ima pasaskanta mana yachaspa. ");
INSERT INTO qulNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodes mandacorkan Pedrota masc'anancupaj. Nitaj tariyta aterkancuchu. Guardiacunata juchachaspa, paycunata wañuchicherkan. Chay pasaymanta Herodes Judeamanta llojsispa, Cesareaman tiyaj puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodes phiñaska cachcarkan Tiropi Sidonpi tiyaj runacunapaj. Chayraycu paycunaka uj yuyaylla tantaycucuspa, Herodeswan parlaj purerkancu. Gobierno palacio wasi cuidaj Blasto sutiyojwan allinpi yaycorkancu, paywan Herodesmanta mañarkancu allinpi capunancupaj; imaraycuchus Herodespaj llajtanmanta tucuy imata apaj cancu causanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herodes uj p'unchayta ajllarkan paycunawan parlananpaj. Chay p'unchaypitaj autoridad p'achawan p'achalliska gobernana wasipi tiyaycuspa parlarkan. ");
INSERT INTO qulNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Runacunataj uyarispa, wajach'acuyta kallarerkancu, “¡Cay parlajka mana runachu, manachayri dios!” nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Chhicapacha Señorpaj angelnin Herodesta onkoycuchiporkan Diosman mana honorta koskanmanta, paylla Dios jina adorachicuskanmanta. Curucunapaj miqhuskan wañuporkan. ");
INSERT INTO qulNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ajinapitaj Señorpaj palabran tucuynejpi astawan willaska carkan, creyentecunataj astawan yapacuchcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bernabé Saulowan ruwanancuta tucuchaspa, Jerusalenmanta Antioquiaman cutiporkancu, Marcos niska Juantawan pusaspa. ");
INSERT INTO qulNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioquía iglesiapi profetacuna yachachejcunapiwan cachcarkancu. Paycunataj carkancu: Bernabé, Yana niska Simón, Cirenemanta Lucio, Galileapi gobernaj Herodeswan cusca uywaska Manaén, Saulopiwan. ");
INSERT INTO qulNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Uj p'unchay ayunaspa Señorpaj cultota ruwachcajtincu, Santo Espíritu paycunata nerkan: “Bernabeta Saulotawan ajllapuwaychis, mandaskayman jina ruwamunancupaj.” ");
INSERT INTO qulNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Paycunataj ayunaspa, oración ruway pasayta, Bernabeman Saulomanpiwan maquincuta churaycuspa cachaporkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Santo Espiritupaj cachaskan, Bernabé Saulopiwan Seleuciaman purerkancu. Chaypitaj botepi puriporkancu unu muyuycuska Chipre niska isla nacionman. ");
INSERT INTO qulNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Salamina llajtaman chayaspataj, Diospaj palabranta willayta kallarerkancu judiocunapaj sinagoga wasincunapi. Juan Marcostaj paycunawan purerkan yanapananpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Enteron chay unu muyuycuska nacionta puriyta tucuchaspataj, Pafos llajtaman chayarkancu. Chaypitaj tariparkancu laykacoj judío runata Barjesús sutiyojta. Paytaj llulla runa carkan, “Diosmanta willaj cani” nej. ");
INSERT INTO qulNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Chay laykataj allin yachayniyoj gobernaj Sergio Paulowan cachcarkan. Gobernajka Diospaj palabranta uyariyta munaspa, Bernabeta Saulotawan wajacherkan. ");
INSERT INTO qulNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Chay layka, griego idiomapi Elimas niska, apostolcuna contra cachcaspa, gobernaj Sergio creenanta jarc'acorkan. ");
INSERT INTO qulNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Chayraycu Saulo, Pablo sutiyojña caspa, laykata khawarispa, Santo Espirituwan junt'a nerkan: ");
INSERT INTO qulNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","—¡Llullacunawan millaycunawan junt'a, supaypaj churin, tucuy allin cajcuna contra! ¿Jayc'ajcamataj Señorpaj justo ñanninta k'ewichinquiri? ");
INSERT INTO qulNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Cunan Señorka castigasunqui: Ñausayanqui, uj tiempotataj intipaj c'anchayninta mana ricunquichu. Chhicapacha Elimas ñausayaporkan; laja tutayajpi jina ricucorkan. Masc'arkantaj pillapas maquinmanta payta aysananpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Chayta ricuspa, gobernaj Sergio creerkan; muspharkantaj Señorpaj yachachiyninmanta. ");
INSERT INTO qulNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pablo paywan cajcunawan Pafosmanta botepi purerkan Panfilia provinciapi caj Pergaman. Juan Marcostaj paycunata sakerparispa, Jerusalenman cutiporkan. ");
INSERT INTO qulNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pablo Bernabepiwan Pergamanta purerkancu Pisidia provinciapi caj Antioquiaman. Samana p'unchaypitaj sinagoga wasiman yaycuspa, tiyaycorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Sinagogapi caj jefencuna Diospaj leyninmanta profetacunapaj escribiskancumantawan leeskancu pasayta, apostolcunata nerkancu: —Waukecuna, imallapas parlanayquichis canchu, willawaychis, runacunata animanayquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pablotaj sayarispa, maquinwan señascharkan jup'allanancupaj. Nerkantaj: —Uyariwaychis, Israel runacuna, Diosta respetaj waj llajtayoj runacunapas. ");
INSERT INTO qulNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel runacunapaj Diosnin abuelonchiscunata ajllarkan. Egiptopi waj llajtayoj jina tiyachcajtincupas, Dios paycunata miracherkan. Chaymanta Dios atiyninwan Egiptomanta orkhomorkan. ");
INSERT INTO qulNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Tawa chunca watata jina ch'usaj pampapi purichcaspa mana casucuchcajtincupas, Dios may pacienciawan pusarkan. ");
INSERT INTO qulNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Canaanpi kanchis nacioncunata ñut'orkan chay jallp'ata abuelonchiscunaman konanpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Tucuy chaycuna pasarkan tawa pachaj phichka chuncayoj watata jina. “Chay khepamantaj, Samuel tiempocama Dios juezcunata churarkan gobernanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Israel runacuna uj reyta gobernananpaj mañajtincu, Dios Benjaminpaj mirayninmanta Cispaj churin Saulta churarkan. Paytaj tawa chunca watata gobernarkan. ");
INSERT INTO qulNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Diostaj Saulta orkhospa, Davidta churarkan gobernananpaj. Dios Davidmanta nerkan: ‘Isaipaj churin Davidwan cusiska cani; payka ruwan tucuy imata nokapaj munaskayman jina.’ ");
INSERT INTO qulNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Cay quiquin Davidpaj mirayninmanta Jesús nacerkan. Dios payta cachamorkan Israel runacunata salvananpaj prometicuskanman jina. ");
INSERT INTO qulNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Manaraj Jesús yachachiyta kallarejtin, Juan Bautista Israel runacunaman willarkan, ‘Diosman cutiriychis bautizaska canayquichispaj’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Wañunan kaylla Juan nerkan: ‘Mana nokaka kancunapaj pensaskayquichis jinachu cani. Manachayri nokapaj khepayta waj jamuchcan. Paypaj ñaupakenpi ni imapaschu cani.’ ");
INSERT INTO qulNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Abrahampaj miraynin waukecuna, Diosta respetaj waj llajtayoj runacunapas, kancunapaj cay salvacionka willaska. ");
INSERT INTO qulNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalenpi tiyajcuna jefencunapiwan mana yacharkancuchu pi Jesús caskanta, ni profetacunapaj escribiskancunatapas entenderkancuchu, sapa samana p'unchaypi leechcaspapas. Ajinapi Jesusta juchachaspa, profetacunapaj niskancuta junt'arkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Mana juchayoj cajtinpas, Pilatomanta mañarkancu Jesusta wañuchichinanpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Escriturapi Jesusmanta tucuy niskanman jina junt'acojtin, cruzmanta apakaspa Jesusta p'ampaporkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Diostaj Jesusta causaricherkan. ");
INSERT INTO qulNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Achqha p'unchay Jesús Galileamanta Jerusalenman purejcunaman riqhurerkan. Paycuna cunan Jesusmanta willachcancu. ");
INSERT INTO qulNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Nokaycupas cay evangeliota kancunaman willayquichis, abuelonchiscunaman Diospaj prometicuskanta. ");
INSERT INTO qulNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Nokanchis Israelpaj mirayninmanta caskanchisraycu, Dios quiquin prometicuskanta nokanchispaj junt'arkan, Jesusta causarichispa. Iscaycaj Salmopi escribiska cachcan: ‘Kan Churiy canqui; noka Tatayqui cani.’ ");
INSERT INTO qulNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Dios willaskaña Jesús causarinanta, cuerponpas mana ismunanta. Escriturapi Dios nerkan: ‘Davidman santo verdadero prometicuskaycunata junt'asaj.’ ");
INSERT INTO qulNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Chayraycu uj Salmopi ujtawan nillantaj: ‘Kanka mana sakenquichu ajllaska santo sirvejniyqui ismunanta.’ ");
INSERT INTO qulNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Davidka causachcaspa Diospaj munaskanman jina runacunaj allinninpaj gobernarkan. Wañupuspa abueloncunaman chayapojtin, cuerpon ismorkan. ");
INSERT INTO qulNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Chaywanpas Diospaj causarichiskan Jesuspaj cuerpon mana ismorkanchu. ");
INSERT INTO qulNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Waukecuna, yachanayquichis Jesucristopi creejtillayquichis Dios juchayquichista perdonananta. ");
INSERT INTO qulNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ni pipas Moisespaj tucuy leyninta junt'ayta atinchu, Diospaj ñaupakenpi justo mana juchayoj cananpaj. Chaywanpas Jesucristopi creejcunaka Diospaj ñaupakenpi justo mana juchayoj cancu. ");
INSERT INTO qulNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Cuidacuychis, profetacunapaj niskan mana kancunawan pasananpaj. Profetacuna nerkancu: ");
INSERT INTO qulNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Uyariychis, Diospaj niskanta mana casucojcuna. Musphaychis, chincaraychis. Causachcajtiyquichisraj, noka imatacha ruwasaj. Chay ruwaskayta pipas willasunquichisman chayka, kancunaka mana creewajchischu.’ ” ");
INSERT INTO qulNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pablo paywan cajcunapiwan sinagogamanta llojsimojtincu, mana judío llajtayoj runacuna rogarkancu jamoj samana p'unchaytawan cay quiquinmanta yachachinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Sinagogapi tantacuynincuta tucuchajtincu, achqha judío runacuna judío religión katejcunapiwan Pablota Bernabetawan katerkancu. Apostolcunataj paycunata yuyaycharkancu, mana iscayrayaspa Dioswan firme canancupaj, Diospaj munacuyninraycu salvacionta jap'ekaskancupi. ");
INSERT INTO qulNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Jamoj semana, samana p'unchaypi, chay llajtamanta yaka lliuj runa tantacorkancu Diospaj palabranta uyarinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Judiocunataj achqha runacunata ricuspa, envidiacorkancu. Pablopaj yachachiskan contra rimarkancu, insultarkancutaj. ");
INSERT INTO qulNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pablotaj Bernabepiwan mana manchacuspa, judiocunaman nerkancu: —Ñaupajtaka Diospaj palabranta kancunaman willanaycu carkan. Kancunataj mana jap'ekayta, nitaj wiñay causayniyoj caytapas munarkanquichischu. Chayraycu cunan puripusajcu waj runacunaman willaj. ");
INSERT INTO qulNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Cay jinata nispa Señor cachamuwancu: ‘Churayquichis nacioncunapaj c'anchayta jina, salvacionniyta apanayquichispaj tucuy cay pachapi.’ ");
INSERT INTO qulNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Chayta uyarispa, mana judío cajcuna cusicorkancu; Señorpaj palabran sinchi allin caskanmanta parlayta kallarerkancu. Señorpaj ajllaskan tucuy cajcunataj creerkancu, wiñaypaj salvaska canancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ajinapi tucuy chay lugarcunapeka Señorpaj palabranta willarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Waquin judiocunataj Dios respetaj rejsiska warmicunawan importante runacunapiwan parlarkancu apostolcuna contra. Ajinamanta Pablota Bernabetawan ñac'arichiyta kallarerkancu, jallp'ancumanta katerkonancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Apostolcunataj paycuna contra chaquincupi polvo cajta thalaraspa, Iconio llajtaman puriporkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Creyentecunataj Santo Espirituwan junt'a, sinchi cusiska carkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Iconio llajtapi Pablo Bernabepiwan sinagoga wasiman yaycuspa, parlarkancu. Parlaskancumanta achqhayoj creerkancu judío cajcuna, mana judío cajcunapas. ");
INSERT INTO qulNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Mana creej judiocunataj waj runacunawan parlarkancu, creyentecuna contra phiñarichinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Chayraycu chay llajtapi apostolcuna unay tiempota quedacorkancu. Mana manchacuspa, Señorpi allinta jap'icuspa parlarkancu Diospaj munacuyninmanta. Señortaj paycunawan caskanta ricucherkan, atiyninta kospa milagrocunata señalcunatapas ruwanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Llajtapi caj runacunataj iscayman particorkancu, waquincuna judiocuna parte, waquincunataj apostolcuna parte. ");
INSERT INTO qulNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ajinapitaj apostolcuna contra chejnicoj judiocuna mana judío cajcunapiwan autoridadcunawan rimanacorkancu, rumicunawan chhokaspa ñac'arichinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pablotaj Bernabepiwan chayta yachaspa, escaparkancu Listra, Derbe llajtacunaman. Licaonia provinciapi caj llajtacuna tucuy llajta cantocunantinta purichcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Tucuy chaycunapitaj sumaj evangeliota willachcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra llajtapi uj such'u runa carkan, naciskanmantapacha ni jayc'aj puriycachaskachu. Cay runataj tiyachcaspa, ");
INSERT INTO qulNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Pablopaj niskanta uyarerkan. Pablotaj repararkan chay such'u creeyniyoj caskanta alliyananpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Chayraycu alto vozwan nerkan: —¡Sayariy! —nispa. Such'utaj saltaspa sayarerkan, puriytataj kallarerkan. ");
INSERT INTO qulNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pablopaj ruwaskanta ricuspa, runacuna Licaonia idiomapi wajach'acuyta kallarerkancu: —¡Dioscuna, runa rijch'acuyniyoj, uraycamun nokanchisman! —nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Paycunataj Bernabeta Zeus nispa curaj diosta suticharkancu, Pablotataj Hermes nispa diosta, parlaj caskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Zeuspaj templon llajtaman yaycunapi cachcarkan. Chayraycu Zeuspaj sacerdoten torocunata t'ica coronacunatawan apamorkan apostolcunata adoranancupaj diosnincuta jina. ");
INSERT INTO qulNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Bernabé Pablopiwan chayta reparaspa, p'achancuta lliq'erkancu llaquiska caskancuta ricuchinancupaj. Runacunapaj chaupinman yaycuspataj, wajach'acorkancu: ");
INSERT INTO qulNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—Señorcuna, ¿imaraycutaj caycunata ruwachcanquichis? Nokaycoka runacunalla caycu, kancuna jina. Kancunaman jamuycu, cierto causachcaj Diosmanta willaj, cay yankha ruwachcaskayquichiscunamanta Diosman cutiricunayquichispaj. Chay Dioska janaj pachata, cay pachata, kochata, tucuy ima cajcunatapas ruwarkan. ");
INSERT INTO qulNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ñaupajtaka Dios tucuy runacunata khawallarkan munaskancupi puriskancuta. ");
INSERT INTO qulNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Chaywanpas Dios allincunata ruwaspa, ricuchicun pi pay caskanta. Payka parachin, chajrayquichiscunata allinta urichin achqha miqhuna cananpaj, chaywan cusiska causanayquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Chayta nispataj, apostolcuna ñac'ayta jarc'arkancu, runacuna mana torocunata wañuchispa paycunata dioscunata jina adoranancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Waquin judiocuna Antioquiamanta Iconiomantawan chayamorkancu. Paycunataj apostolcuna contra yachacherkancu. Chayraycu chay llajta runacuna apostolcuna contra cutirispa, Pablota rumiwan chhokarkancu. Wañuskaña caskanta creespa, llajta jawaman kataterkorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Pabloka, creyentecuna paypi muyuycojtincu, jatarispa llajtaman ujtawan yaycorkan. K'ayantintaj Bernabewan Derbe llajtaman puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Chaypitaj evangeliota willajtincu, achqhayoj creerkancu. Chaymantataj cuterkancu Listra, Iconio, Antioquía llajtacunaman. ");
INSERT INTO qulNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Chay llajtacunapitaj creyentecunata animarkancu, mana iscayrayaspa creeynincupi firme causanancupaj. Nerkancutaj: “Diospaj gobiernonman yaycunapaj tucuy imata ñac'arinanchis cachcan.” ");
INSERT INTO qulNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Sapa iglesiapitaj encargadocunata churarkancu. Ayunaspa oracionta ruwaspa, Señor Jesucristoman entregarkancu pimanchus creeskancuman. ");
INSERT INTO qulNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pisidia provinciata pasaspa, chayarkancu Panfilia provinciacama. ");
INSERT INTO qulNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Chaypitaj Perga llajtapi evangeliota willaspa, Atalia llajtaman puriporkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Chaymanta botepi Antioquiaman cutiporkancu. Chay llajtapi caj creyentecuna paycunata evangelio willajta cachaskacu, “Dios munacuyninwan kancunata cuidasunquichis” nispa. Chay ruwanata junt'arkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Antioquiaman chayaspataj creyentecunawan tantaycucorkancu, paycunaman Diospaj tucuy ruwaskancunata willanancupaj, imaynatachus Dios sut'ita ricuchiskanta mana judío caj runacunapas creyente cayta atinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Antioquiapi Pablo Bernabepiwan unayta quedacorkancu creyentecunawan. ");
INSERT INTO qulNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Chay tiempopi Judeamanta jamojcuna Antioquiapi caj creyentecunaman yachachiyta kallarerkancu. Nerkancutaj: “Pipas Moisespaj leyninman jina circuncisión costumbreta mana ruwanchu chayka, mana salvaska cayta atinchu.” ");
INSERT INTO qulNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Chayraycu Pablo Bernabepiwan chay yachachejcunawan sinchita discuterkancu. Chay discutiskancumanta Pablo, Bernabe, wajcunapiwan cachaska carkancu Jerusalenman purinancupaj, apostolcunawan Jerusalenpi caj iglesiapaj encargadoncunawan allinta parlamunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Antioquía iglesiamanta cachaska caspa, Fenicia, Samaria provinciacunata pasachcaspa, tucuynejpi willarkancu mana judío caj runacuna ñaupaj costumbrecunata sakespa Diosman cutiripuskancuta. Chay noticiata uyarispa, tucuy creyentecuna sinchita cusicorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Jerusalenman chayajtincutaj, apostolcuna iglesiapi caj encargadocunapiwan Pablota Bernabetawan sumajta jap'ekarkancu. Jap'ekajtincutaj willarkancu tucuy imata Dios paycunawan ruwaskanta. ");
INSERT INTO qulNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Waquin creej fariseocunataj sayarispa, nerkancu: —Mana judío caj creyentecunaka Moisespaj leyninman jina circuncisión costumbreta ruwanancu. Mandaychis Moisespaj leyninta junt'anancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Chayraycu apostolcuna iglesiapi caj encargadocunapiwan tantacorkancu, chaymanta parlanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Sinchita discutiskancu pasayta, Pedro sayarispa nerkan: —Waukecuna, kancuna yachanquichis, kancunamanta Dios nokata ajllawarkan Jesucristomanta salvación evangeliota mana judío caj runacunaman willamunaypaj, paycunapas creenancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Runacunapaj sonkoncuta rejsej Dios paycunaman Santo Espiritunta korkan nokanchisman jina. Ajinapi Dios sut'ita ricucherkan paycunatapas jap'ekaskanta. ");
INSERT INTO qulNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Dioska mana waj wajtachu khawawanchis, judiocunata mana judiocunatapas. Jesucristopi creeskancuraycu Dios sonkoncuta limpiochan. ");
INSERT INTO qulNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Cunanri, ¿imaraycutaj Diosta phiñachichcanquichis, cay creyentecunata Moisespaj tucuy leyninta casuchiyta munaspa? Mana nokanchis ni abuelonchiscunapas Moisespaj leyninta allinta junt'ayta atichcanchischu. ");
INSERT INTO qulNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Manachaytaj yachanchis Señor Jesuspaj qhuyapayacuyninraycu nokanchis salvaska caskanchista, paycuna jinallataj. ");
INSERT INTO qulNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Tucuynincu jup'alla cajtincu, Bernabé Pablopiwan willarkancu Diospaj tucuy milagrocunata ruwaskanta mana judiocuna uqhupi. ");
INSERT INTO qulNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Willayta tucuchajtincu, Santiago nerkan: —Waukecuna, uyariwaychis. ");
INSERT INTO qulNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón Pedro willawanchis imaynata Dios mana judiocunata qhuyapayacuskanta. Paycuna uqhumanta Dios runacunata ajllarkan paypaj quiquin familian canancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Profetacunapaj escribiskanpi jinallatataj nin: ");
INSERT INTO qulNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Noka cutimuspa, Davidpaj mirayninta ujtawan sayarichisaj, wasi urmaska perkata jina ujtawan jatarichisaj, ");
INSERT INTO qulNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","waj runacunapas noka Señor Diosta masc'anawancupaj. Tucuy nacioncunamanta runacunata wajarkani nokallapaj familiay canancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ajinata nin Señor Dioska, ñaupajmantapacha chayta willacherkan.’ ");
INSERT INTO qulNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Santiago nillarkantaj: —Chayraycu niyquichis, waj runacunata mana mandanayquichischu leyninchista junt'anancupaj; ñaupaj religión costumbrencuta sakespa Diosman cutirejtincoka mana jarc'ananchischu. ");
INSERT INTO qulNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Manachayri paycunaman escribisunchis cayta: ‘Amaña miqhunquichischu falso dioscunaman koska aychata. Amaña adulterio juchata ruwanquichischu. Amaña sipiska animalpaj aychanta miqhunquichischu, ni yawartapas.’ ");
INSERT INTO qulNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ñaupajmantapacha sapa llajtapi Moisespaj leyninta willaj cancu. Sapa samana p'unchaytataj sinagogacunapi chaytaka leencu. ");
INSERT INTO qulNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Apostolcuna, iglesiapi caj encargadocuna, tucuy creyentecunapiwan Jerusalén iglesiapi caj waquin kharicunata ajllarkancu, Pablo Bernabewan cusca Antioquiaman purinancupaj. Ajllarkancutaj Barsabás niska Judasta Silastawan. Iscaynincu sinchi respetaska carkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Paycunawan cay cartata apacherkancu: “Nokaycu hermanoyquichiscuna, apostolcuna, iglesiapi caj encargadocunapiwan saludota apachimuyquichis mana judiocunaman, Antioquía, Siria, Ciliciapi tiyaj hermanonchiscunaman. ");
INSERT INTO qulNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Yachaycu waquin caymanta mana autorizacionniycuwan kancunaman puriskancuta. Paycunataj mana allin yachachiynincuwan kancunata iscayrayachispa pantachisunquichis, ‘Circuncisión costumbreta ruwanayquichis, Moisespaj leyninta casucunayquichis’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Chayraycu tucuyniycu tantacuspa, uj yuyaylla hermanocunata ajllaycu, munaskanchis Bernabé Pablowan cusca kancunaman purinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Paycunaka wañuytapas mana manchacuspa, Señorninchis Jesucristota sirvincu. ");
INSERT INTO qulNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ajinamanta Judasta Silastawan cachamuchcaycu. Paycunaña cay escribiskaycumanta allinta willasunquichis. ");
INSERT INTO qulNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Santo Espiritupaj nokaycupajpas allin, kancunaman waj ruwanacunata mana churanaycoka, astawanka caycunallata: ");
INSERT INTO qulNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Amaña miqhunquichischu falso dioscunaman koska aychata. Amaña yawarta miqhunquichischu, nitaj sipiska animalpaj aychantapas. Amaña ni adulterio juchatapas ruwanquichischu. Caycunata casucojtiyquichiska may allin. ¡Allillan cacuychis!” ");
INSERT INTO qulNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Chay cachaskacuna despidicuspa, Antioquiaman purerkancu. Chaypi tucuy creyentecunata tantaspa, cartata korkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Creyentecunataj cartata leespa, sinchita cusicorkancu chay cusichej cartamanta. ");
INSERT INTO qulNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas Silaspiwan profetacuna caspa, creyentecunata allin yachachiynincuwan cusicherkancu, animarkancutaj. ");
INSERT INTO qulNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Waquin tiempo pasajtin, creyentecuna sonko tiyaycuy saludocunawan bendicispa, Judasta Silastawan cacharpayaporkancu, Jerusalenman cutipunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Silascajtaj Antioquiapi quedaporkan. ");
INSERT INTO qulNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pablo Bernabepiwan quedacullarkancutaj, achqha wajcunawan cusca Diospaj palabranta yachacherkancu, Jesucristomanta evangeliota willaspa. ");
INSERT INTO qulNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Waquin p'unchaycuna pasayta, Pablo Bernabeman nerkan: —Jacuchis, evangelio willamuskanchis llajtacunapi caj hermanonchiscunata ujtawan waturimusunchis, imayna cachcaskancuta ricunanchispaj. ");
INSERT INTO qulNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabetaj Marcos niska Juanta pusayta munarkan. ");
INSERT INTO qulNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pablotaj mana munarkanchu, ñaupaj puriskancupi Panfiliapi Marcos paycunata sakerpariskanmanta, paycunawan Señorpaj obranpi puriyta dejapuskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Sinchita discutispa t'ipinacaporkancu. Ajinapi Bernabé Marcoswan botepi unu muyuycuska Chipre llajtaman purerkan. ");
INSERT INTO qulNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pablotaj Silasta ajllacorkan paywan purinanpaj. Creyentecunataj “Señor munacuyninwan kancunata cuidasunquichis” nispa cacharpayarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Siriata Ciliciatawan purichcarkancu, creyentecunata animaspa. ");
INSERT INTO qulNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pablo, Derbe Listra llajtacunaman chayaspa, uj creyente Timoteo sutiyojwan tuparkan. Maman judía creyente carkan, tatantaj griego. ");
INSERT INTO qulNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Listra, Iconio llajtapi caj creyentecuna Timoteomanta allinta parlarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pablotaj pusayta munaspa Timoteota circuncidarkan, chay lugarpi judiocunata mana phiñachiyta munaspa. Tucuy judiocuna yacharkancu Timoteopaj tatan griego caskanta. ");
INSERT INTO qulNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Llajtamanta llajta purispa, willarkancu apostolcunapaj Jerusalén iglesiapi caj encargadocunapajpiwan escribiskanta. ");
INSERT INTO qulNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ajinapi creyentecuna creeynincupi astawan firme carkancu. Sapa p'unchaytaj astawan achqhayarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Santo Espíritu paycunata jarc'arkan, Asiapi mana evangeliota willanancupaj. Chayraycu Frigia Galacia provinciacunaman pasaporkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Misia cantoman chayaspataj, Bitinia provinciaman yaycuyta pensarkancu. Jesuspaj Espirituntaj jarc'arkan mana purinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Misiata pasaspataj, Troasman chayarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Chaypitaj Pablo tutapi moskoypi jina ricorkan Macedoniamanta uj runata. Sayaspa, mañarkan, “Macedoniaman jamuy, yanapariwaycu” nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pablo chayta ricuskanraycu, Macedoniaman purinaycupaj waquichicorkaycu. Imaraycuchus yacharkaycu Dios wajawaskancuta, chay runacunaman evangeliota willanaycupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Troasmanta botepi Samotraciaman rectota purerkaycu. K'ayantintaj Neapolisman chayarkaycu. ");
INSERT INTO qulNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Chaymantataj Filipos llajtaman purerkaycu, Macedoniapi astawan importante llajta caskanraycu. Chaypi achqha Roma llajtayojcuna tiyarkancu. Chaypitaj pisi p'unchaycunata quedacorkaycu. ");
INSERT INTO qulNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Samana p'unchaypi llajtamanta llojsispa mayu cantoman purerkaycu, judiocunapaj oración ruwanancu lugar caskanta pensaspa. Tiyaycuspataj, chaypi tantaska warmicunaman evangeliota willarkaycu. ");
INSERT INTO qulNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ujnin uyarej warmi Lidia sutiyoj carkan, Tiatira llajtamanta. Payka fino morado telata vendej, Diosta adoraj. Señor payta allinta uyaricherkan Pablopaj niskanta. ");
INSERT INTO qulNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Creeskanraycu Lidiaka tucuy familianwan cusca bautizaska carkan. Chay pasaytataj rogawarkan: —Sichus kancuna pensanquichis Señorpi ciertota creeskayta chayka, jamuychis wasiypi alojacoj. Sinchita rogajtin, wasinpi quedacorkaycu. ");
INSERT INTO qulNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Uj p'unchaytaj oración ruwana lugarman purichcaspa, adivinaj sajra espirituyoj sipasta tariparkaycu. Payka patronninpaj mandaskan carkan. Chay adivinaskanwan patronnin achqha kolketa ganaj. ");
INSERT INTO qulNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Chay sipas Pablota nokaycutawan katispa, wajach'acorkan: —¡Chay runacuna janaj pachapi caj Diosta sirvincu; willasunquichis imaynata salvacunayquichismanta! ");
INSERT INTO qulNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ajinata achqha p'unchayta wajach'acorkan. Pablotaj chaymanta phiñacuspa, cutirispa, sipaspi cachcaj sajra espirituta nerkan: —Jesucristopaj sutinpi mandayqui paymanta llojsinayquita. Chhicapacha sajra espíritu llojserkan. ");
INSERT INTO qulNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Sipaspaj patronnincunataj manaña kolketa ganananta yachaspa, Pablota Silastawan jap'erkancu plazaman pusanancupaj autoridadpaj ñaupakenman. ");
INSERT INTO qulNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Juezcunaman entregaycuspa, nerkancu: —Cay judiocuna llajtanchista pituchcancu. ");
INSERT INTO qulNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Waj costumbrecunata yachachincu. Nokanchis Roma llajtayoj canchis. Chay costumbrecunata mana jap'ekayta atichuwanchu, nitaj ruwaytapas. ");
INSERT INTO qulNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Chay runacunataj apostolcuna contra jatarerkancu. Chayraycu juezcuna mandarkancu, p'achancuta thataspa paycunata c'aspiwan c'upanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Sinchita bajtaspa, carcelman wisk'acherkancu. Mandarkancutaj carcelero allinta cuidananpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Carcelerotaj chayta casucuspa, Pablota Silastawan astawan uqhunejman wisk'aycorkan, chaquincutataj cepo niskaman mat'iycorkan. ");
INSERT INTO qulNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Chaupi tutata jina Pablo Silaswan oracionta ruwachcarkancu, Diosmantaj taquichcarkancu. Waj presocunataj uyarichcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Konkaylla jallp'a sinchita qharcatiyta kallarerkan, carcelpaj perka cimientoncunataj cuyurerkan. Chay ratopacha puncucunapas quicharacorkan, tucuy presocunamanta cadenacunapas pascaracorkan. ");
INSERT INTO qulNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Carcelerotaj rijch'arispa carcelpaj puncuncunata quichaskata ricorkan. Presocuna escapaskancuta yuyaspa, espadanta orkhorkan wañuchicunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pablotaj alto vozwan nerkan: —¡Ama imanacuychu, tucuyniycu caypi cacuchcaycu! ");
INSERT INTO qulNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Chayraycutaj carcelero c'anchayta mañaspa, manchacuywan qharcatispataj, Pablopaj Silaspaj ñaupakenpi konkoriycucorkan. ");
INSERT INTO qulNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Jawaman orkhomuspataj, paycunata taporkan: —Señorcuna, ¿imatataj ruwanay salvaska canaypaj? ");
INSERT INTO qulNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Paycunataj contestarkancu: —Señor Jesucristopi creey. Kantaj salvaska canqui, ajinallataj wasiyquipi cajcunapas. ");
INSERT INTO qulNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Paycunataj Señorpaj palabranta willarkancu payman tucuy wasinpi cajcunamanpiwan. ");
INSERT INTO qulNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Chay tutapacha carcelero paycunapaj nanaskanta mayllarkan. Chhicapacha pay familianpiwan bautizachicorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Pablota Silastawan wasinman pusaspa miqhunata korkan. Paytaj familianwan sinchi cusiska carkancu, Diospi creeskancuraycu. ");
INSERT INTO qulNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","K'ayantin juezcuna waquin soldadocunata carceleroman cacharkancu, Pablota Silastawan cacharipunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Carcelero Pabloman willarkan: —Juezcuna ordenta kowancu kancunata cacharipunaypaj. Ajinaka llojsimuychis; puripuychis sonko tiyaska. ");
INSERT INTO qulNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pablotaj soldadocunata nerkan: —Nokaycu Roma llajtayoj caycu. Chaywanpas manaraj juchachaska cachcajtiycu, tucuynincupaj ñaupakenpi c'upawarkancu, carcelmanpas wisk'achiwarkancu. Cunantaj ¿pacallamantachu cachariwankacu? ¡Mana llojsiycumanchu! Paycuna quiquin jamuchuncu orkhonawancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Soldadocunataj chay niskancuta juezcunaman willamorkancu. Paycunataj Pablo Silaspiwan Roma llajtayojcuna caskancuta yachaspa, mancharicorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Juezcuna carcelman uskhayta purispa, Pablomanta Silasmantawan perdonta mañacorkancu. Carcelmanta orkhospataj, rogarkancu chay llajtamanta llojsipunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Carcelmanta llojsispataj, Pablo Silaspiwan Lidiapaj wasinman purerkancu. Creyentecunawan tantacuspa animarkancu. Chaymantataj puriporkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Chaymanta Pablo Silaspiwan Anfípolis, Apolonia llajtacunata pasaspa, Tesalónica llajtaman chayarkancu. Chaypitaj judiocunapaj sinagogan carkan. ");
INSERT INTO qulNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pablo costumbrenman jina sinagogaman yaycorkan. Chaypitaj quimsa samana p'unchaypi Diospaj palabranta yachacherkan. ");
INSERT INTO qulNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Escrituramanta sut'ita ricucherkan Cristo wañunanta causarinantapas. Paycunamantaj nerkan: —Kancunaman willaskay cay quiquin Jesuska Cristopuni —nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Waquin judiocuna creespa, Pablowan Silaswan tantacorkancu. Ajinallatataj Diosta adoraj achqha griegocuna creerkancu, achqha respetaska warmicunapiwan. ");
INSERT INTO qulNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Chayraycu mana creej judiocuna envidiacuspa, mana allin puriycachaj millay runacunata tantamorkancu. Chaycuna judiocunapiwan enteron llajtata pitorkancu. Jasonpaj wasinman mana munachcajtin, yaycorkancu Pablota Silastawan masc'aspa, orkhomuyta munaspa runacunaman entreganancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Paycunata mana tarispataj, Jasonta waquin creyentecunatawan katatispa, autoridadcunapaj ñaupakenman aparkancu. Wajach'acorkancutaj: —¡Caycunaka tucuynejpi runacunata pituchincu! ¡Cunanka caymanñataj jamuncu! ");
INSERT INTO qulNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","¡Cay Jasonka wasinpi paycunata jap'ekan! ¡Mana casucuncuchu Roma gobernajpaj leynincunata! Nincu: ‘Waj gobernaj can Jesús sutiyoj’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Chayta uyarispataj, runacuna autoridadcunapiwan astawanraj pituricorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Jasón paywan cajcunapiwan garantiapaj kolketa kojtincu, cachariporkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Tutapiña creyentecuna Pablota Silastawan Berea llajtaman cachaporkancu. Chayaspataj, sinagogaman purerkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Chaypi caj judiocuna astawan allin sonkoyojcuna carkancu Tesalonicapi tiyaj judiocunamanta nejtin. Tucuy sonkowan Diospaj palabranta jap'ekarkancu. Sapa p'unchaytaj Escriturata estudiachcarkancu, “¿Ciertochu cay runacunapaj yachachiskanka?” nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ajinapi achqha judiocuna creerkancu, achqha respetaska griego warmicuna kharicunapas. ");
INSERT INTO qulNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Chaymanta Tesalónica llajtayoj judiocuna yacharkancu Pablo Bereapi Diospaj palabranta willachcaskanta. Chayraycu Bereaman purispa, runacunata Pablo contra pitullarkancutaj. ");
INSERT INTO qulNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Creyentecunataj Pablota uskhayta cacharkancu kocha cantoman puripunanpaj. Silas Timoteopiwan Bereapi quedacorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pablowan purejcunataj payta pusarkancu Atenascama. Chaymanta Bereaman cutiriporkancu, Pablopaj niskanta Silasman Timoteomanpiwan apaspa, “Uskhayta jamuchuncu” nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Atenaspi Silasta Timoteotawan suyachcaspa, Pablo sonkonpi sinchita llaquicorkan, chay llajtapi achqha idolocunata ricuskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Chayraycu sinagogapi caj judiocunawan waquin Dios adorajcunawanpas discuterkan. Plazapi tantacojcunawanpas sapa p'unchay discutillarkantaj. ");
INSERT INTO qulNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ajinallatataj waquin epicúreo yachachejcuna estoico yachachejcunapiwan Pablowan discuterkancu. Ujcuna nerkancu: —¿Imamantataj parlachcan cay sinchita parlajri? Wajcunataj nerkancu: —Waj dioscunamanta parlajman rijch'acun. Chayta nerkancu, Pablo Jesuspaj evangelionmanta causarimuskanmantawan willaskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Paycuna Pablota pusamorkancu Areópago niska parlanapaj tantacuna lugarman. Nerkancutaj: —¿Yachaycumanchu cay mosoj yachachiskayquicunata? ");
INSERT INTO qulNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kanka niwanquichis mana jayc'aj uyariskaycuta. Yachayta munaycu caycuna ima niy munaskanta. ");
INSERT INTO qulNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Atenas llajtayojcuna, waj llajtayoj chaypi tiyajcunapiwan mosoj niskacunallamanta parlayta uyariytapas munaj cancu. ");
INSERT INTO qulNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pablotaj Areópago niska lugarpi paycunapaj chaupinpi sayarispa, nerkan: “Atenas llajtayoj runacuna, tucuy imata ricuskayman jina reparani kancuna sinchi religioso caskayquichista. ");
INSERT INTO qulNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Culto ruwanayquichis lugarcunata khawaspa, uj altarta ricorkani, cay jina escribiskayojta: ‘Mana rejsiska diosman.’ Chay mana rejsiska Diosta adoraskayquichismanta noka niyquichis. ");
INSERT INTO qulNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Chay Dioska cay pachata tucuy imacunatawan ruwarkan. Paymi janaj pachapaj cay pachapajpas Señornenka. Payka mana runapaj ruwaskan templopichu tiyan, ");
INSERT INTO qulNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","nitaj runamantaka imatapas necesitanchu. Manachayri pay tucuyman causayta kowanchis, samayta, tucuy imacunatapas. ");
INSERT INTO qulNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","“Uj runallamanta tucuy runacunata ruwan, enteron cay pachapi tiyanancupaj. Payka tiempota lugartapas kon causanancupaj, ");
INSERT INTO qulNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","verdadero Diosta masc'anancupaj, icha imaynamantapas payta taripanancupaj. Chaywanpas mana nokanchismanta carupichu cachcan. ");
INSERT INTO qulNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Diosmanta causanchis, purinchis, cachcanchispas. Waquin escribejniyquichiscuna nerkancu cay jinata: ‘Nokanchispas Diospaj familianmanta canchis’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Diospaj familian cachcaspa, mana pensananchischu Dioska runapaj ruwaskan caskantaka. Runacunaka pensaskancuman jinalla idolocunata ruwancu korimanta, kolkemanta, rumimantapas. ");
INSERT INTO qulNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ñaupaj tiempo Dios runacunata pacienciarkan, mana yachaspa jinata causaskancuraycu. Cunanka Dios tucuynejpi tucuy runata mandan juchancumanta payman cutirinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Diostaj uj p'unchayta churanña, uj runatataj ajllanña. Chay p'unchaypi chay ajllaska runa cay pachapi tiyajcunata justiciawan juzganka. Wañuskamanta causarichispa, tucuynincuman ricucherkan chay runa pi caskanta.” ");
INSERT INTO qulNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Wañuskamanta causarinata uyarispataj, waquin Pablota asipayarkancu; waquintaj nerkancu: —Waj cutillaña ujtawan uyariskayquichis. ");
INSERT INTO qulNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Chaymantataj Pablo paycunapaj chaupincumanta llojsiporkan. ");
INSERT INTO qulNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Waquincunataj Pablowan purerkancu, creerkancutaj. Ujnin Dionisio sutiyoj carkan, Areópago partidomanta. Uj warmi Dámaris niska creellarkantaj, wajcunapiwan. ");
INSERT INTO qulNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pablo Atenasmanta llojsispa Corinto llajtaman purerkan. ");
INSERT INTO qulNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Chaypi Aquila sutiyoj judío runata tariparkan. Payka Ponto provinciamanta carkan. Mana unayrajchu Italiamanta jamorkancu warmin Priscilapiwan. Italiapi gobernaj Claudio mandacorkan tucuy judiocuna Roma llajtamanta llojsinancupaj. Pablo paycunata watumorkan. ");
INSERT INTO qulNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Pablopas Aquila jina toldocuna ruwaj callarkantaj. Chayraycu paycunawan quedacorkan cusca llanc'anancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Sapa samana p'unchaytaj Pablo sinagogaman purispa, judiocunata griegocunatapas yachachej, creenancuta munaspa. ");
INSERT INTO qulNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silas Timoteopiwan Macedoniamanta chayamojtincu, Pablo toldo ruwananta sakespa, mana sayc'uspa Diospaj palabranta willaj. Judiocunamantaj yachachej, Jesús suyaskancu Cristopuni caskanta. ");
INSERT INTO qulNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Chay judiocunataj Pablo contra parlayta kallarerkancu, insultarkancutaj. Chayraycu Pablo paycuna contra señalta jina p'achanta thalaracuspa, nerkan: —Infiernopi ñac'arinayquichispajka, kancuna quiquiyquichis juchayoj canquichis. Mana nokachu juchayoj casaj. Cunanmanta jakaynejman evangeliota willasaj mana judío caj runacunaman. ");
INSERT INTO qulNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Sinagogamanta llojsispataj, Ticio Justo sutiyoj runapaj wasinman purerkan. Payka Diosta adoraj, sinagogapaj ladonpitaj tiyaj. ");
INSERT INTO qulNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Sinagogapaj uj jefen, Crispo sutiyoj, Señorpi creerkan tucuy familianpiwan. Pablopaj niskanta uyarispa, achqhayoj Corintopi tiyaj runacuna creerkancu, bautizaskataj carkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Uj tuta Señor moskoypi jina Pabloman nerkan: “Ama manchachicuychu. Astawan evangeliota willay, ama ch'inyaychu. ");
INSERT INTO qulNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Noka kanwan cachcani, manataj pipas imanasunquichu. Cay llajtapeka achqhayoj cancu nokapi creejcuna.” ");
INSERT INTO qulNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ajinapi wata sojta quillayojta Pablo Corinto llajtapi quedacorkan, Diospaj palabranta yachachinanpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Acayapi prefecto Galión gobernachcajtin, judiocuna uj yuyaylla Pablo contra sayarerkancu, juzgadomantaj pusaycorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Chaypitaj nerkancu: —Cay runaka purichcaspa, runacunaman mana allinta yachachin leyninchis contra Diosta adoranancuta. ");
INSERT INTO qulNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pablo parlananpajña cachcajtin, Galión judiocunaman nerkan: —Judiocuna, sichus cay runa ima mana allinta ruwanman carkan, ima athun juchatapas chayka, noka mana phiñacuspa uyariyquichisman carkan. ");
INSERT INTO qulNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Kancunataj niskayquichiscunamanta, suticunamanta, leyniyquichiscunamantawan quejacuchcanquichis. Chaytaka imaynatapas kancuna arreglaychis. Chaycunamanka mana meticuyta munanichu. ");
INSERT INTO qulNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Chayta nispataj, juzgadomanta katerkorkan. ");
INSERT INTO qulNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Chhicataj tucuynincu sinagogapaj uj jefen Sostenesta jap'ispa, juzgadopipacha makarkancu. Gobernaj Galionmantaj mana imapas importarkanchu. ");
INSERT INTO qulNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Achqha p'unchaycunataraj Pablo Corintopi cachcarkan. Creyentecunamanta despidicuspa, Pablo, Priscila, Aquilapiwan Cencrea llajtaman puriporkancu. Cencreapi manaraj boteman yaycuspa, Siriaman puripunanpaj Pablo chujchanta rutuchicorkan, Diosman promesa ruwaskanta junt'ananpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Efeso llajtaman chayaspataj, Pablo Priscilata Aquilatawan sakerkan. Sinagogaman purispa, chaypi tantacoj judiocunawan parlarkan. ");
INSERT INTO qulNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Paycunataj Pablota rogarkancu, chaypi quedacunantaraj. Pablotaj mana munarkanchu. ");
INSERT INTO qulNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Paycunamanta despidicuspa, nerkan: “Dios munajtenka, ujtawan cutimusaj kancunata watoj.” Chayta nispataj, Efesomanta botepi puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Cesareaman chayaspataj, Jerusalenman purerkan creyentecunata saludaj. Chaymantataj Antioquiaman puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Uj tiempota quedacuspa, ujtawan Galacia Frigia provinciapi caj llajtacunaman puriporkan, tucuy creyentecunata watuspa animananpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Chay p'unchaycunapi Alejandriamanta uj judío runa, Apolos sutiyoj, Efeso llajtaman chayarkan. Paytaj Escrituramanta allinta yachaj, sumajta parlaj. ");
INSERT INTO qulNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Señormanta allin yachachiska caspa, tucuy sonkowan Jesusmanta sut'ita yachachichcarkan. Chaywanpas payka Juanpaj bautismollanta rejserkan. ");
INSERT INTO qulNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Mana manchacuspa, Apoloska sinagogapi willayta kallarerkan. Payta uyarispataj, Priscila Aquilapiwan wajnejman pusarkancu, Diospaj ñanninta astawan allintaraj sut'inchanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolos Acayaman puriyta munachcajtintaj, chaypi caj creyentecuna payta animaspa Acayapi caj creyentecunaman cartata escriberkancu, payta allinta jap'ekanancupaj. Acayaman chayaspataj, creyentecunata sinchita yanaparkan, picunachus Diospaj favorninraycu creejcunata. ");
INSERT INTO qulNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Tucuypaj ñaupakenpi mana negay atina razoncunawan parlaspa, judiocunata atiparkan, Escrituramanta ricuchispa Jesuska Cristopuni caskanta. ");
INSERT INTO qulNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolos Corinto llajtapi cachcanancamataj, Pablo lomacunanta pasaspa, Efeso llajtaman chayarkan. Chaypi waquin creyentecunata tariparkan. ");
INSERT INTO qulNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Paycunata taporkan: —¿Creespari Santo Espirituta jap'ekanquichischu? Paycunataj contestarkancu: —Ni uyarillaycupaschu Santo Espiritumanta parlayta. ");
INSERT INTO qulNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pablo tapullarkantaj: —¿Ima bautismowantaj bautizaska carkanquichis? Paycunataj contestarkancu: —Juanpaj bautismonwan —nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pablotaj nerkan: —Juanka Diosman cutirej runacunata bautizarkan. Yachacherkantaj paypaj khepanta jamojpi creenancupaj. Juanpaj khepanta jamojtaj carkan Jesús. ");
INSERT INTO qulNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Chayta uyarispataj, Señor Jesuspaj sutinpi bautizachicorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pablo maquinta paycunaman churaycojtin, Santo Espíritu paycunaman jamorkan. Waj idiomacunapi parlaspataj, Diospaj paycunaman niskanta willayta kallarerkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Tucuynincutaj chunca iscayniyoj kharicuna carkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pablotaj quimsa quillata sinagogaman purispa, mana manchacuspa evangeliota willachcarkan. Runacuna creenancuta munaspa, Diospaj gobiernonmanta yachachichcarkan. ");
INSERT INTO qulNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Waquincunataj mana creeyta munaspa, sonkoncuta khoruyacherkancu. Ajinapi Cristopaj Mosoj Ñannin contra parlachcarkancu tucuypaj ñaupakenpi. Chayraycu Pablo chay judiocunata sakespa, Tirano niskapaj escuelanman creyentecunata pusarkan. Chaypi sapa p'unchay yachacherkan. ");
INSERT INTO qulNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Iscay watata Pablo chaypi yachachichcarkan. Ajinata Asiapi tucuy tiyajcuna Señor Jesucristomanta uyarerkancu, judiocunapas mana judío cajcunapas. ");
INSERT INTO qulNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Pablotaj Diospaj atiyninwan athun milagrocunata ruwarkan. ");
INSERT INTO qulNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","P'achallata chayri pañuelotapas Pablopaj cuerponman tupachispa, onkoskacunaman aparkancu. Churamojtincutaj, alliyaporkancu. Ujcunamantataj sajra espiritucuna llojsiporkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Waquin judiocunaka callecunata purispa, sajra espirituta runacunamanta katerkoyta munarkancu, Señor Jesuspaj sutinpi parlaspa. Sajra espiritucunatataj nerkancu: “¡Pablopaj willaskan Jesuspaj sutinpi mandayquichis, cay runamanta llojsipuy!” ");
INSERT INTO qulNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Chayta ruwachcarkancu sacerdotecunapaj jefen Esceva sutiyojpaj kanchis churincuna. ");
INSERT INTO qulNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Uj cutitaj sajra espíritu paycunata nerkan: “Jesusta rejsini, Pablotapas. Kancunarí ¿picunataj canquichis?” ");
INSERT INTO qulNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Chhicapacha sajra espirituyoj runa paycunaman phaucatarkan. Paycunatataj jap'ispa, tucuynincuta athun atiywan atiparkan. Sinchita makajtin, paycuna wasimanta escapaporkancu mana p'achayoj nanaskataj. ");
INSERT INTO qulNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Efesopi tucuy tiyaj judiocuna mana judío cajcunapas chayta yachaspa, mancharicorkancu. Ajinamanta tucuy uyarerkancu Señor Jesuspaj sutin atiyniyoj caskanta. ");
INSERT INTO qulNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Achqha creyentecunapas tantacuspa, sut'inta willacorkancu ñaupaj mana allin ruwaskancumanta. ");
INSERT INTO qulNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Achqha creyentecunataj laykacuna libroncuta apamuspa, tucuypaj ñaupakenpi ruphacherkancu. Chay ruphachiskancu librocunataj phichka chunca waranka kolkeman jina ajustacorkan. ");
INSERT INTO qulNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ajinapi atiywan Señorpaj evangelion tucuynejman chayachcarkan. Tucuynejpi astawan astawan runacuna Señorpaj evangelionta uyarerkancu, creerkancutaj. ");
INSERT INTO qulNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Chaymanta Pablo Macedoniapi Acayapi caj creyentecunata watumuyta munarkan, chaymanta Jerusalencama puripunanpaj. Nerkantaj: “Jerusalenman purispaka, Roma llajtaman chayanallaytaj.” ");
INSERT INTO qulNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ñaupajta Macedoniaman cacharkan iscay yanapajnincunata, Timoteota Erastotawan. Chhicanacama Pablo Asia provinciapi uj tiempo quedacorkan. ");
INSERT INTO qulNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Chay p'unchaycunapi Efeso llajtapi runacuna sinchita pitucorkancu Jesucristopaj Mosoj Ñannin contra. ");
INSERT INTO qulNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Demetrio sutiyoj runa cay athun pitucuyta okharicherkan. Payka kolkemanta falso diosa Artemisapaj juch'uy templitoncunata ruwaj, chay diosata adorajcunaman vendinanpaj. Ajinapi Demetrio paywan ruwajcunapiwan achqha kolketa ganachcarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetrio ruwajmasincunata tucuy chay ruwanayoj runacunatawan tantachimuspa, nerkan: “Señorcuna, kancuna allinta yachanquichis, cay ruwaskanchiswan achqha kolketa gananchis. ");
INSERT INTO qulNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Kancuna ricuchcanquichis, uyarichcanquichistaj, imaynata Pablo tucuynincuman yachachiskanta, ‘Mana verdadero Dioschu chay runapaj ruwaskan dioscunaka’ nispa. Ajinata yachachispa, achqha runacunata pantachin, mana cay Efeso llajtallapichu, astawanpas tucuy Asia provinciantinpi. ");
INSERT INTO qulNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Chayka mana allinchu nokanchispaj. Kolke jap'inanchis tucucapunman, negocionchista perdichuwan. Sinchi rejsiska diosa Artemisapaj templonpas despreciaska canman. Paypaj sinchi athun cayninpas chincapunman. Tucuy runacuna cay diosataka adorancu Asia provinciapi tucuy cay pachapipas.” ");
INSERT INTO qulNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Chayta uyariytawan, sinchita phiñaricuspa wajach'acorkancu: “¡Efesio runacunapaj Artemisanka causachun!” nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Paycunataj tucuy Efesio runacunata pitorkancu. Macedonia llajtayoj Gayota Aristarcotawan jap'ispa, teatro canchaman aparkancu. Imaraycuchus chay iscay kharicuna Pablopaj purejmasincuna carkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pablo runacunawan parlananpaj teatro canchaman yaycuyta munajtin, creyentecuna jarc'arkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Waquin Asia autoridadcunataj Pablopaj amigoncuna cachcaspa, payman runacunata cacharkancu, “Ama chaypi meticuchunchu” nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Tucuy tantacojcuna wajach'acorkancu waj wajta. Sinchita pitucuspa curaj parte ni yachallarkancupaschu ni imapaj tantacuskancuta. ");
INSERT INTO qulNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Judiocunañataj runacunapaj chaupinmanta ñaupajman Alejandrota tankarkorkancu. Waquincuna cay asuntomanta payman sut'incharkancu. Alejandrotaj maquinwan jup'allachispa, Efeso llajtayoj runacunapaj ñaupakenpi judiocuna favor parlayta munarkan. ");
INSERT INTO qulNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Runacunataj Alejandrota judío caskanta rejsispa, iscay horata jina tucuynincu wajach'acorkancu, “¡Efesio runacunapaj Artemisanka causachun!” nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Llajtapaj secretarion runacunata jup'allachispa nerkan: “Efeso llajtayoj runacuna, cay pachapi tucuy yachancu nokanchis athun diosa Artemisapaj templonta cuidaj caskanchista, janaj pachamanta uraycamoj imagenninta cuidaj caskanchistapas. ");
INSERT INTO qulNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Mana pipas caycunata negayta atinmanchu. Chayraycu tucuyniyquichis pacienciacuychis. Ama imatapas ruwaychischu manaraj allinta pensaspaka. ");
INSERT INTO qulNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Yankha cay kharicunata pusamunquichis. Mana paycunaka templomanta suwancuchu, nitaj diosanchis Artemisa contra parlancuchu. ");
INSERT INTO qulNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Sichus Demetrio paywan llanc'ajcunapiwan pitapas quejayta munancu chayka, juezcuna juzgadopi cachcancu chaypajka. Chaypi quejacuchuncu, sapa ujnincu uyarichicunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Chayri imamantapas quejacuyta munajtincu, leyman jina tantacuypi allin uyariska canan. ");
INSERT INTO qulNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Cunan pasaskanmanta autoridadninchiscuna juchachawachuwan runacuna pituskanchismanta. Cay pituskanchismanta tapucojtincu, mana ima niytapas atichuwanchu.” ");
INSERT INTO qulNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Chayta nispa runacunata cacharpayaporkan. ");
INSERT INTO qulNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Pitucuy ch'inyapojtin, Pablo creyentecunata wajarkan animananpaj. Paycunamanta despidicuspataj, Macedoniaman puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Llajtamanta llajta purispa creyentecunata watorkan, niskancunawan paycunata allinta animaspa. Chaymanta Greciaman chayarkan. ");
INSERT INTO qulNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Chaypi quimsa quillata quedacorkan. Siriaman botepi purinanpaj waquichicuchcaspataj, yacharkorkan judiocuna payta jap'iyta munachcaskancuta. Chayraycu chaquillapi puriporkan wajmanta Macedonianta pasaspa. ");
INSERT INTO qulNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Pablowan cuscataj purerkancu Bereamanta Pirropaj churin Sópater, Tesalonicamanta Aristarco Segundopiwan, Derbemanta Gayo, Asiamanta Tíquico, Trófimo, Timoteopiwan. ");
INSERT INTO qulNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Paycunataj ñauparispa Troas llajtapi suyawarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Mana levadurayoj t'anta miqhuna fiesta pasayta, Filiposmanta nokaycu botepi puriporkaycu. Phichka p'unchay pasayta, Troaspi paycunawan tuparkaycu. Chaypitaj kanchis p'unchayta quedacorkaycu. ");
INSERT INTO qulNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Semanapaj kallariynin domingo p'unchaypi creyentecunawan tantacorkaycu Santa Cenata ruwanaycupaj. Pablotaj chaypi yachachichcarkan. K'ayantin puripunan caskanraycu, paycunaman parlarkan chaupi tutacama. ");
INSERT INTO qulNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Altospi tantaska cachcarkaycu; achqha mecherocuna jap'ichiska carkan. ");
INSERT INTO qulNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Eutico sutiyoj waynataj ventanapi tiyachcarkan. Pablo unayta parlajtintaj, Eutico puñuywan sinchita aysachicuspa, chay quimsa altos patamanta pampaman urmakarkan. Wañuskata okharerkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pablotaj uraycuspa, waynapaj patanman siriycorkan. Waynatataj mark'aycuspa hermanocunaman nerkan: —Ama mancharicuychischu; causachcan. ");
INSERT INTO qulNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ujtawan altosman sekaspa, Pablo creyentecunaman Santa Cenata korkan, miqhorkantaj. Pakariyanancama yachacherkan. Chaymanta puriporkan. ");
INSERT INTO qulNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Waynatataj causachcajta pusaycaporkancu. Chaywantaj sinchita animacorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Nokaycu botepi ñauparerkaycu Aso llajtaman, chaymanta Pablota botepi okharinaycupaj. Paytaj munaskanman jina chaquipi purerkan. ");
INSERT INTO qulNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Nokaycuta taripaspataj, Pablo nokaycuwan boteman yaycorkan. Cuscataj purerkaycu Mitilene llajtaman. ");
INSERT INTO qulNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Chaymanta botepi llojsispa, k'ayantin Quío llajta chimpanta pasarkaycu. Khepan p'unchaypitaj Samospaj puertonman chayarkaycu. K'ayantin Mileto llajtaman chayarkaycu. ");
INSERT INTO qulNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Chayta ruwarkaycu Pablo Efesoman mana puriyta munajtin, Asia provinciapi mana tardanaycupaj. Pablo Jerusalén llajtaman uskhayta chayayta munarkan, Pentecostés p'unchaypi chaypi cananpaj, aticojtin. ");
INSERT INTO qulNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Mileto llajtapi cachcajtiycu, Pablo Efeso iglesiapi caj encargadoncunata wajacherkan. ");
INSERT INTO qulNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Chayamojtincutaj, paycunaman nerkan: “Kancuna allinta yachanquichis, cay Asia provinciaman jamuskay p'unchaymantapacha imaynata kancunawan causaskayta. ");
INSERT INTO qulNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Tucuy tiempo kancunawan cachcaspa, Señorniyta sirvini humilde caskaywan, wakayniypiwan; judiocunataj sinchita ñac'arichiwarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Chaywanpas kancunaj allinniyquichispaj Diospaj palabranta willayta mana dejanichu. Wasimanta wasi purichcaspataj, tucuypaj ricunanta yachacherkayquichis. ");
INSERT INTO qulNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Judiocunaman mana judío cajcunamanpas sut'ita willarkani Diosman cutirinancupaj, Señorninchis Jesucristopi creenancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Cunantaj Santo Espirituta casuspa, Jerusalenman purichcani, mana yachaspa jakaypi ima nokata suyachcawaskanta. ");
INSERT INTO qulNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Cayllata yachani, sapa llajtapi Santo Espíritu willawan carcelman yaycunayta ñac'arinaytawan. ");
INSERT INTO qulNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Chaywanpas chaycunata mana manchacunichu, nitaj wañuytapas. Manachayri cusicuywan causayniyta tucuchayta munani Señor Jesucristopaj mandawaskanta junt'aspa, willaspataj Diospaj munacuyninmanta evangeliota. ");
INSERT INTO qulNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Kancuna uqhupi Diospaj gobiernonta willarkayquichis. Cunanmanta mana maykenniyquichispas ricuwanquichisñachu. Chaymanta seguro cani. ");
INSERT INTO qulNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Chayraycu cunan p'unchay niyta munayquichis, manaña nokaka juchayojchu cani ni mayken runa castigaska cananmanta. ");
INSERT INTO qulNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Imaraycuchus mana imata pacaspa willayquichis Diospaj tucuy munayninta. ");
INSERT INTO qulNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Kancuna quiquiyquichis cuidacuychis. Santo Espíritu kancunata oveja michejta jina churarkasunquichis, Diospaj iglesianta allinta cuidanayquichispaj. Iglesiataj Jesucristopaj yawarninwan rantiska. ");
INSERT INTO qulNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Yachanitaj, puripojtiy waquin yachachejcuna kancunaman jamunancuta. Millay animalcuna jina paycunaka iglesiayquichista tucuchayta munankacu. ");
INSERT INTO qulNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Kancuna uqhullamantataj waquin pantaskata yachachispa llojsenkacu, creyentecuna paycunata katinanta munaspa. ");
INSERT INTO qulNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Cuidacuychis; yuyariychistaj quimsa watata tuta p'unchay mana dejacuspa sapa ujniyquichista wakayniywan yachachiskayta. ");
INSERT INTO qulNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Cunantaj, hermanocuna, Diospaj maquinman entregayquichis kancunata cuidanasunquichispaj. Munacoj Diosninchispaj palabranta ama konkaychischu. Dioska atiyniyoj, creyente causaypi wiñachinasunquichispaj, paypi creejcunaman prometicuskan bendicionta konasunquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Mana pipaj kolkenta, korinta, nitaj p'achantapas munapayarkanichu. ");
INSERT INTO qulNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Astawanka allinta yachanquichis maquiywan llanc'aspa imatapas ranticuskayta nokapaj nokawan cajcunapajpas. ");
INSERT INTO qulNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ajinapi kancunatapas yachacherkayquichis, noka jina llanc'aspa mana imayojcunata yanapanayquichispaj. Señor Jesuspaj niskanta yuyariychis: ‘Astawan cusicuyniyojmi konaka jap'ekanamanta nejtenka.’ ” ");
INSERT INTO qulNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Chay parlay pasayta, Pablo konkoriycuspa tucuynincuwan oracionta ruwarkan. ");
INSERT INTO qulNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Tucuynincu wakaspa, Pablota much'aspa mark'aycorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Paycunataj sinchi llaquiska carkancu manaña jayc'ajpas Pablota ricunancumanta. Botecamataj paywan purerkancu cacharpayamunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Creyentecunata sakespa, botepi rectota puriporkaycu Cos llajtaman, k'ayantintaj Rodas llajtaman, chaymantataj Pátara llajtaman. ");
INSERT INTO qulNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Patarapi Feniciaman purej boteta tariparkaycu. Chayman yaycuspataj, puriporkaycu. ");
INSERT INTO qulNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Purichcaspataj, unu muyuycuska Chipreta ricorkaycu. Llok'e ladoman pasaspa Siriacama purerkaycu. Tiro llajtaman chayaspataj, botemanta llojserkaycu, Tiro puertopi cargata orkhospa sakenancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Creyentecunata taripaspa, kanchis p'unchayta paycunawan quedacorkaycu. Paycunaman Santo Espíritu willaskanraycu, Pablota nerkancu manaña Jerusalenman purinanta. ");
INSERT INTO qulNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Kanchis p'unchay pasajtintaj, puriporkaycu. Tucuy creyentecuna, warmicuna wawacunapiwan, llajta jawanejcama nokaycuwan purerkancu. Kocha cantopi konkoriycuspa, oracionta ruwarkaycu. ");
INSERT INTO qulNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Paycunamantataj despidicuspa, boteman yaycorkaycu. Paycunataj wasincuman cutiporkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tiromanta llojsispa Tolemaida llajtaman chayarkaycu. Ajinapi botepi puriyta tucucharkaycu. Creyentecunata watuspa, uj p'unchayta paycunawan quedacorkaycu. ");
INSERT INTO qulNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","K'ayantin llojsispataj, Cesarea llajtaman chayarkaycu. Evangelio willaj Felipepaj wasinman purispa, paypajpi korpachacorkaycu. Payka iglesiapi caj kanchis diaconocunamanta ujnin carkan, apostolcunapaj ñaupaj ajllaskan. ");
INSERT INTO qulNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Paytaj tawa mana khari rejsej sipas ususicunayoj carkan. Tawantintaj Diospaj niskan willaj profetacuna carkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Waquin p'unchaycuna pasajtin, Judeamanta Agabo sutiyoj profeta chayamorkan. ");
INSERT INTO qulNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Nokaycuman chayaspataj, Pablopaj cinturonninta okharispa chaquinta maquintawan wataycuspa nerkan: —Santo Espíritu cay jinata nin: ‘Ajinata Jerusalenpi judiocuna cay cinturonpaj dueñonta watankacu, waj runacunaman entreganancupaj.’ ");
INSERT INTO qulNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Chayta uyarispataj, nokaycu Cesareapi cajcunapiwan Pablota rogarkaycu mana Jerusalenman purinanpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Pablotaj nerkan: —¿Imaraycutaj wakaspa llaquichiwanquichis? Nokaka listo cani, Jerusalenpi Señor Jesusraycu watanawancupaj, wañunaypajpas. ");
INSERT INTO qulNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Manaña imaynata jarc'ayta atispa, dejaporkaycu: —Señorpaj munaynin ruwaska cachun —nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Chaymanta waquichicuspa, Jerusalenman purerkaycu. ");
INSERT INTO qulNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Cesareamanta waquin creyentecuna nokaycuwan purerkancu. Paycunataj Chipre llajtayoj Mnasonpaj wasinman pusawarkancu, korpachanawancupaj. Payka unayña creyente carkan. ");
INSERT INTO qulNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Jerusalenman chayajtiycu, creyentecuna cusicuywan nokaycuta jap'ekawarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","K'ayantin Pablo nokaycuwan purerkan Santiagota watoj. Chaypitaj iglesiapi caj tucuy encargadoncunawan tantacorkaycu. ");
INSERT INTO qulNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pablotaj saludaspa, paycunaman ujmanta uj willarkan paypaj puriyninpi Diospaj tucuy ima ruwaskanta mana judiocunawan. ");
INSERT INTO qulNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Chayta uyarispataj Diosta alabarkancu. Pablotataj nerkancu: —Allin, hermano. Kan quiquiyqui yachanqui achqha waranka judiocuna creeskancuta. Tucuynincutaj nerkancu creyentecunaka Moisespaj leyninman jina causanata. ");
INSERT INTO qulNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Kanmantataj uyaricun waj nacioncunapi tiyacoj judiocunata yachachiskayquimanta Moisespaj leyninta mana casucunancuta, churincuta mana circuncisión costumbreta ruwanancuta, judiocunapaj waj costumbrencunatapas mana ruwanancutapas. ");
INSERT INTO qulNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","¿Imaynataj chayri? Paycunaka cayman chayamuskayquita yachankacu. ");
INSERT INTO qulNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Chayraycu cay niskaycuta ruway. Nokaycu uqhupi tawa kharicuna cachcancu, Diosman prometicuskancuta junt'anancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Paycunawan cusca temploman yaycuspa, costumbrenchisman jina limpiochacuy. Paycunapaj gastoncutapas pagay, chujchancuta rutuchicunancupaj. Ajinapi tucuy yachankacu mana cierto caskanta tucuy ima kanmanta uyariskancoka. Astawanpas riconkacu kanpas Moisespaj leyninta junt'askayquita. ");
INSERT INTO qulNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Mana judío creyentecunamanpas ña cartata escribiycuña, cay jinata nispa: Amaña miqhunquichischu falso dioscunaman koska aychata, ni yawarta, nitaj sipiska animalpaj aychantapas. Amañataj adulterio juchata ruwanquichischu. ");
INSERT INTO qulNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Pablo chay tawa kharita pusarkan. K'ayantin paycunawan cusca limpiochacorkan judiocunapaj costumbrenman jina. Chaymanta temploman yaycorkancu, ima p'unchaychus chay promesa tucucunanta willanancupaj, chay p'unchaypi sapa ujnincu ofrendata konancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Kanchis p'unchay tucucuchcajtinña, Asiamanta judiocuna Pablota templopi ricorkancu. Pitumorkancutaj tucuy runacunata Pablo contra. ");
INSERT INTO qulNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Pablota jap'ispataj, wajach'acorkancu: “¡Israel runacuna, yanapawaychis! Cay runa tucuynejpi yachachin nokanchispaj llajtanchis contra, Moisespaj leynin contra, cay templo contrapas. Astawanraj templonchisman griego cajcunata yaycuchin khellichachinanpaj.” ");
INSERT INTO qulNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Chayta nerkancu Pablota Efeso llajtayoj Trofimowan purichcajta ricuskancumanta. Yuyarkancu Pablo chay mana judío caj runata temploman pusaycuskanta. ");
INSERT INTO qulNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Chayta uyarispa llajtayoj tucuy runacuna pitucuspa, chaynejman phawararkancu. Pablota jap'ispataj, templomanta jawaman kataterkorkancu. Chhicapacha templopaj puncunta wisk'aycorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Pablota wañuchiyta munachcajtincu, Roma soldadocunapaj comandantenman willamorkancu tucuy Jerusalén pitucuskanmanta. ");
INSERT INTO qulNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Comandantetaj soldadocunata tenientecunatawan wajaspa, runacunapaj cachcaskanman phawarkan. Runacunataj soldadocunata comandantetawan ricuspa, manaña Pablota makarkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Comandantetaj chimpaycuspa Pablota jap'icherkan. Mandarkantaj iscay cadenawan watanancupaj. Taporkan pi pay caskanta, imata ruwaskantapas. ");
INSERT INTO qulNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Runacunataj waj wajta wajach'acorkancu. Chay achqha wajach'acuskancuraycu, comandante ni imata sut'inchayta aterkanchu. Chayraycu mandarkan Pablota cuartelman pusanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Patillacama chayaspataj, soldadocuna Pablota okharispa aparkancu. Wañuchinancupaj jina runacuna khepancuta katichcarkancu, ");
INSERT INTO qulNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","wajach'acuspa: “¡Wañuchun!” nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Cuartelman pusaycuchcajtincu, Pablo comandanteman griego idiomapi nerkan: —¿Parlariymanchu kanwan uj rato? Comandantetaj nerkan: —¿Kan griego parlayta yachanquichu? ");
INSERT INTO qulNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Chhica ¿manachu kanri Egipto llajtayoj canqui? Chay runa cay runacunata pituchispa, ch'usaj pampaman tawa waranka wañuchejcunawan llojserkan. ");
INSERT INTO qulNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pablotaj nerkan: —Noka judío cani, Tarso llajtayoj, Cilicia provinciamanta. Tarsoka importante llajta. Permisota koway runacunaman parlanaypaj. ");
INSERT INTO qulNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Comandante permisota kojtintaj, Pablo patillapi sayaycuspa, maquinwan runacunata ch'inyacherkan. Hebreo idiomapi parlaspa nerkan: ");
INSERT INTO qulNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Waukecuna, tatacuna, uyariwaychis cay niskayta.” ");
INSERT INTO qulNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Hebreo idiomapi parlajta uyarispa, astawan jup'alla carkancu. Pablotaj nerkan: ");
INSERT INTO qulNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Noka judío cani. Cilicia provinciapi caj Tarso llajtapi nacini. Cay Jerusalenpi wiñarkani, yachachejniytaj Gamaliel carkan. Payka ñaupaj abuelonchiscunapaj leynincuta allinta yachachiwarkan. Tucuy kancuna jina Diosninchista tucuy sonkoywan sirviyta munarkani. ");
INSERT INTO qulNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ñaupajka Mosoj Ñanpi cajcunata ñac'aricherkani wañunancucama. Paycunata jap'ispataj, carcelman wisk'aracherkani, kharicunata warmicunatapas. ");
INSERT INTO qulNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Sacerdotecunapaj jefen tucuy judiocunapaj jefencunapiwan chay tucuy imata allinta yachancu. Paycunataj autorizacionta nokaman kowarkancu, Damascopi caj waukenchiscunaman entreganaypaj. Chayman creyentecunata jap'ej purerkani, cay Jerusalenman presota apamuspa castigachinaypaj. ");
INSERT INTO qulNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Chaupi p'unchayta Damasco kayllapiña purichcajtiy, janaj pachamanta uj athun c'anchay konkay c'anchaycamuwarkan. ");
INSERT INTO qulNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Pampaman chhokacuspa, uyarerkani niwajta: ‘Saulo, Saulo, ¿imaraycutaj katiycachachcawanqui ñac'arichinawayquipaj?’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Taporkani: ‘¿Pitaj canqui kan, Señor?’ nispa. Voztaj contestawarkan: ‘Noka cani Nazaret llajtayoj Jesús. Noka quiquiyta katiycachachcawanqui ñac'arichinawayquipaj.’ ");
INSERT INTO qulNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Nokawan purichcajcunataj c'anchayta ricuspa, mancharicorkancu. Chaywanpas mana parlamojta uyarerkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Nokataj taporkani: ‘¿Imatataj ruwasaj?’ Señortaj niwarkan: ‘Jatarispa Damasco llajtaman yaycuy. Chaypitaj ima ruwanayquita yachanqui’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","C'anchaytaj ñausayachiwarkan. Chayraycu nokawan cajcuna maquiymanta aysaspa Damascoman pusapuwarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Damascopi uj runa carkan Ananías sutiyoj, Diosta sinchita respetaj, Moisespaj tucuy leyninta casucoj. Damascopi caj judiocuna tucuynincu paymanta ‘allin runa’ nispa parlarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ananiastaj watuwaj jamorkan. Chayamuspataj niwarkan: ‘Wauke Saulo, ujtawan ricucapuy.’ Chhicapacha wajmanta ricucuyta aterkani, paytapas ricullarkanitaj. ");
INSERT INTO qulNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ananías nillawarkantaj: ‘Abuelonchiscunapaj Diosnin kanta ajllasunqui, paypaj munayninta yachanayquipaj, justo cajta ricuspa quiquin vozninta uyarinayquipaj. ");
INSERT INTO qulNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kan tucuy runacunaman ricuskayquita uyariskayquitawan willajniy canqui. ");
INSERT INTO qulNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Cunanka ama astawan suyaychu. Jatarispa, Señorpaj sutinpi bautizachicuy, juchayquicunamanta limpiochacunayquipaj.’ ");
INSERT INTO qulNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Jerusalenman cutimuspa, templopi oracionta ruwaj purerkani. Chaypitaj moskoypi jina ricorkani. ");
INSERT INTO qulNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Señorta ricojtiy, niwarkan: ‘Cunanpacha uskhayta Jerusalenmanta llojsipuy. Caypi nokamanta willaskayquita mana uyarenkacuchu’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nokataj contestarkani: ‘Señor, tucuynincu yachancu imaynata tucuynejman purispa, sinagogacunapi kanpi creejcunata jap'ichispa, carcelman wisk'achiskayta, makachiskaytapas. ");
INSERT INTO qulNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Señor, kanmanta willaj sirvejniyqui Estebanta wañuchichcajtincupas, noka chaypi paycunawan cusca cachcarkani wañuchinancu allin nispa. Noka wañuchejcunapaj p'achancunatapas khawarkani.’ ");
INSERT INTO qulNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Chaywanpas Señor niwarkan: ‘Puripuy, cachaskayqui caru nacioncunapi cajcunaman’ nispa.” ");
INSERT INTO qulNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Chaycama Pablopaj parlaskanta uyarerkancu. Chaymanta wajach'ayta kallarerkancu: “¡Wañuchun cay runaka! ¡Amaña causachunchu!” nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Wajach'aspa, p'achancuta thalararkancu; jallp'atataj altoman chhokarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Chayta ruwaskancuraycu comandante mandarkan Pablota cuartelman pusaycunancupaj. Mandallarkantaj sok'anancuta parlachinancupaj, imaraycutaj tucuynincu pay contra wajach'acorkancu, chayta. ");
INSERT INTO qulNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Sok'anapaj wataskaña cachcajtin, kayllanpi sayachcaj capitanta Pablo taporkan: —¿Kancuna autoridadniyojchu canquichis romano runata sok'anayquichispaj, manaraj juchachaspa? ");
INSERT INTO qulNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Capitantaj chayta uyarispa, comandanteman willamorkan: —¿Imatataj ruwanqui? Cay runaka romano —nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Comandantetaj Pabloman chimpaycuspa taporkan: —Niway, ¿ciertochu romano canqui? Pablotaj nerkan: —Arí. ");
INSERT INTO qulNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Comandantetaj nerkan: —Nokaka romano canaypaj achqha kolketa pagarkani. Pablotaj nerkan: —Nokaka, naciskaymantapacha romano cani. ");
INSERT INTO qulNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Chayta uyarispa, Pablota sok'ay munajcuna ithiricaporkancu. Quiquin comandante Pablo romano caskanta yachaspa, mancharicorkan cadenawan wataycuchiskanmanta. ");
INSERT INTO qulNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","K'ayantin comandante ciertotapuni yachayta munarkan imamanta judiocuna Pablota juchachaskancuta. Pablomanta cadenata pascararkan. Chaymanta mandarkan sacerdotecunapaj tucuy jefencuna Athun Asambleaman tantacamunancupaj. Pablota carcelmanta orkhomuspataj, paycunapaj ñaupakenman pusaycorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pablotaj Athun Asambleapi cajcunata khawarispa, nerkan: —Waukecuna, cunancama noka Diospaj ñaupakenpi limpio sonkowan causacuni. ");
INSERT INTO qulNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ananías sutiyoj curaj sacerdote Pablopaj kayllanpi cajcunata mandarkan Pablopaj siminpi t'ajllinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pablotaj Ananiasta nerkan: —¡Dios kantapas t'ajllillasunquitaj, iscay uya! Leyman jina juzganawayquipaj chaypi tiyachcanqui. ¿Imaraycutaj ley contra mandanqui t'ajllinawancupaj? ");
INSERT INTO qulNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Chaypi cajcunataj Pablota nerkancu: —¿Ajinatachu insultanqui Diospaj curaj sacerdotenta? ");
INSERT INTO qulNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pablotaj nerkan: —Waukecuna, nokaka mana yacharkanichu pay curaj sacerdote caskanta. Escribiska cachcan: ‘¡Ama mana allinta ninquichu llajtayquipaj autoridadnintaka!’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Chaypi tantaska jefecuna waquin saduceo partidomanta carkancu, waquintaj fariseo partidomanta. Chayta reparaspa, Pablo alto vozwan nerkan: —Waukecuna, noka fariseo cani, fariseopaj familianmanta. Nokata juchachachcawanquichis wañuymanta causarinapi creeskayraycu. ");
INSERT INTO qulNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Chayta nejtin, fariseocuna saduceocunawan paycunapura discutiyta kallarerkancu. Chay tantacuytaj iscayman particorkan. ");
INSERT INTO qulNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Imaraycuchus Saduceocuna nincu wañuymanta causarina mana caskanta, ni angelcuna, ni espiritucunapas caskanta. Fariseocunacajtaj tucuy caycunapi creencu. ");
INSERT INTO qulNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Tucuynincu wajach'acuchcarkancu. Waquin fariseo leymanta yachachejcuna sayarispa nerkancu: —Cay runaka mana ruwanchu ni ima mana allintaka. Ichapas uj espirituchus chayri uj angelchus payman parlarkan. ");
INSERT INTO qulNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Astawanraj pitucuspa, wajach'acorkancu. Chayraycu comandante mancharicorkan, Pablota wañuchinancuta yuyaspa. Soldadocunata mandarkan, Pablota chaymanta orkhospa cuartelman apanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","K'ayantin tutataj Señor Pabloman riqhurispa, nerkan: “Animacuy, Pablo, imaynata cay Jerusalenpi nokamanta willarkanqui, ajinallatataj Roma llajtapipas willanqui.” ");
INSERT INTO qulNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","K'ayantin waquin judiocuna juramentowan yachachinacorkancu mana imata miqhunancupaj, nitaj ujyanancupajpas Pablota wañuchinancucama. ");
INSERT INTO qulNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Chay juramento ruwajcuna tawa chunca curaj kharicuna carkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Paycunataj sacerdotecunapaj jefencunaman waj jefecunamanpiwan purispa, nerkancu: —Nokaycu juramentota ruwaycu mana imatapas miqhunaycupaj Pablota wañuchinaycucama. ");
INSERT INTO qulNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Cunanka kancuna Athun Asambleapi cajcunapiwan comandantemanta mañaychis, k'ayantin Pablota kancunapaj ñaupakeyquichisman apachimunanpaj, astawan yachayta munaj jinalla. Nokaycutaj listo suyasajcu, manaraj chayamuchcajtin wañuchinaycupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Pabloj pananpaj churin niskancuta uyarispa, cuartelman purerkan Pabloman willaj. ");
INSERT INTO qulNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pablotaj ujnin capitanta wajaspa, nerkan: —Cay waynata comandanteman pusaycuripuway, ima yachaskanta willananpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Capitantaj pusaycuspa, comandanteman nerkan: —Preso jap'iska Pablo wajawaspa, mañawan cay waynata kanman pusamunaypaj. Pay ima yachaskanta willayta munasunqui. ");
INSERT INTO qulNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Comandantetaj waynata wajnejman maquinmanta pusaspa, taporkan: —¿Imatataj willayta munawanqui? —nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Waynataj payta nerkan: —Judiocuna yachachinacuncu kanmanta mañanancupaj, pakarin Pablota Athun Asambleaman pusaycunayquita, paymanta astawan yachayta munaj jinalla. ");
INSERT INTO qulNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Kanka ama paycunata creenquichu. Tawa chunca curaj kharicuna ñanpi pacaycucuspa Pablota suyankacu. Paycunataj juramentota ruwancu mana miqhunancupaj nitaj ujyanancupaj Pablota wañuchinancucama. Cunantaj listo cachcancu, kanpaj ninallayquitaña suyaspa. ");
INSERT INTO qulNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Comandantetaj waynata nerkan: —Ama pimanpas ni imata ninquichu cay willawaskayquimanta —nispataj cachaporkan. ");
INSERT INTO qulNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Comandante iscay capitanninta wajachispa, mandarkan: —Chaquipi purej iscay pachaj soldadocunata, caballopi purej kanchis chunca soldadocunata, iscay pachaj lanzayoj soldadocunatawan waquichiychis, iskon hora tutata Cesarea llajtaman purinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Mandallarkantaj: —Caballota alistaychis Pablo sillapi purinanpaj, prefecto Felixman allin c'uchita chayachinayquichispaj —nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Paycunallawantaj Felixman cartata apacherkan, cay jinata nispa: ");
INSERT INTO qulNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Noka, Claudio Lisias, saludamuyqui, sinchi respetaska prefecto Félix. ");
INSERT INTO qulNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Judiocuna cay runata jap'ispa wañuchinancu cachcajtin, noka romano caskanta yachaspa, soldadoycunawan purerkani salvanaypaj. ");
INSERT INTO qulNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Imamanta juchachaskancuta yachayta munaspa, Athun Asambleapaj ñaupakenman pusarkani. ");
INSERT INTO qulNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Chaypitaj yachani leynincu contra ruwaskanmanta juchachaskancuta. Mana juchan canchu wañunanpaj jina, nitaj carcelman wisk'achinapaj jinapas. ");
INSERT INTO qulNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Judiocuna cay runata wañuchinancupaj yachachinacuskancuta yachaspa, kanman pusachimuyqui. Payta juchachaj judiocunatapas nillanitaj, kanpaj ñaupakeyquipi pay contra imatapas willanasunquichispaj.” ");
INSERT INTO qulNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Comandantepaj mandaskanman jina chay tuta soldadocuna Pablota pusarkancu Antípatris llajtacama. ");
INSERT INTO qulNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","K'ayantin chaquipi purej soldadocuna cuartelman cutiporkancu, caballoyoj soldadocunallaña Pablowan purerkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Cesarea llajtaman chayaspataj, cartata prefectoman kospa, Pablota entregarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Cartata leespa, prefecto Pablota taporkan may llajtayoj caskanta. ");
INSERT INTO qulNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Cilicia llajtayoj caskanta yachaspa, nerkan: —Kanta juchachajcuna chayamojtincu, uyariskayqui. Chaymanta soldadocunata mandarkan Herodespaj palacio wasinpi Pablota cuidanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Phichka p'unchay pasayta, curaj sacerdote Ananías Cesareaman purerkan waquin jefecunawan Tértulo sutiyoj abogadopiwan. Prefecto Felixpajman yaycuspa, Pablo contra willarkan juchachananpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Pablota pusaycamojtincu, abogado Tértulo juchachayta kallarerkan, prefecto Felixman nispa: —Gracias kanman, señor prefecto, kanpaj gobernaskayquiraycu allinta causachcaycu sonko tiyaska. Kan yuyayniyoj caskayquiraycu, nacionniycupi tucuy astawan allin cachcan. ");
INSERT INTO qulNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Sinchi respetaska señor prefecto, llajtaycupi tucuynejpipas tucuy allin ruwaskayquicunamanta sinchicajta agradeciyquichis. ");
INSERT INTO qulNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Mana astawan sayc'uchiyta munayquichischu. Chaywanpas cunan allin sonkoyquiman jina mañacuycu cay uj chhicanta uyaririnawayquichista. ");
INSERT INTO qulNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Nokaycu yachaycu cay Pablo peste onkoy jina caskanta. Llajtamanta llajta purispa, judiocunata iscay partidoman tucuchin. Nazareno niska partidopaj jefen caskantapas yachaycu. ");
INSERT INTO qulNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Temploycupi leyniycu contra ruwarkan. Chayraycu payta jap'ispa, leyniycuman jina juchachayta munarkaycu. ");
INSERT INTO qulNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Chhicataj comandante Lisias metiycucuspa, sinchi atiywan Pablota kechuwarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Chay comandantetaj nerkan juchachajcuna kanpaj ñaupakeyquiman jamunancuta, pay contra willanasunquichispaj. Kan quiquiyqui tapunqui chayka, paypaj niskanmanta yachanqui tucuy ima juchachaskaycu ciertopuni caskanta. ");
INSERT INTO qulNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Chaypi caj judiocunapas nillarkancutaj jinapuni caskanta. ");
INSERT INTO qulNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Prefecto Félix maquinwan Pablota señascharkan parlananpaj. Pablotaj nerkan: —Cusicuywan kanpaj ñaupakeyquipi sayani razonniyta parlanaypaj. Yachani achqha wataña cay nacionpi kan juez caskayquita. ");
INSERT INTO qulNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Chunca iscayniyoj p'unchayllaraj, Jerusalenman chayarkani Diosta adoranaypaj. Yachayta munaspaka, kan quiquiyqui tapunqui imayna caskanta. ");
INSERT INTO qulNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Cay juchachawajcunataj mana taripawarkancuchu ni piwan churanacuchcajta, ni templopi runacunata pituchcajta, ni sinagogapi, ni llajta uqhupipas. ");
INSERT INTO qulNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Cay juchachawajcuna noka contra ni imatapas ricuchiyta atincumanchu. ");
INSERT INTO qulNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ujllata mana negacunichu, caytataj sut'ita willaskayqui: Abueloycunapaj Diosninta adorani Mosoj Ñanman jina. Cay Ñantataj paycuna nincu secta caskanta. Nokapas creeni Moisespaj profetacunapajpas tucuy escribiskancuta. ");
INSERT INTO qulNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nokapas paycuna jina Diospi suyacuni jamoj p'unchaypi allin runacunata mana allin runacunatapas Dios causarichinanta. ");
INSERT INTO qulNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Chayraycu munanipuni Diospaj runacunapajpiwan ñaupakenpipas limpio sonkoyoj cayta. ");
INSERT INTO qulNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Cunanka achqha watamantaña tucuynejpi puriycachaspa Jerusalenman cutimuni, pobrecunaman limosnacunata Diosmanpas ofrendacunata konaypaj. ");
INSERT INTO qulNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Templopi limpiochaj costumbreta ruwachcajtiytaj, Asiamanta caj judiocuna taripawarkancu. Chaypitaj mana achqhayojchu carkancu, nitaj ni ima pitucuypas carkanchu. ");
INSERT INTO qulNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Chay judiocunapas ñaupakeyquiman jamunancu noka contra parlanancupaj, juchayoj cajteyka. ");
INSERT INTO qulNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Mana chayka, caypi cajcuna nichuncu, judiocunaj Athun Asembleanpaj ñaupakenpi imatapas mana allinta ruwajteyka. ");
INSERT INTO qulNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Cayta paycunapaj ñaupakencupi cachcaspa, alto vozwan nerkani: ‘Cunanka nokata juchachachcawanquichis wañuymanta causarinapi creeskayraycu’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Prefecto Felixtaj Jesucristopaj Mosoj Ñanninmanta allinta yacharkan. Pablopaj niskanta uyarispa, nerkan: —Comandante Lisias jamojtin, cay tucuy imamanta astawan allinta yachasaj. ");
INSERT INTO qulNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ajinata nispataj, prefecto Félix capitanta mandarkan Pablo jap'iskalla cananpaj, watucojcuna jamojtincutaj mana jarc'anancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Uj p'unchaycunamanta Félix ujtawan jamorkan judía Drusila sutiyoj esposanwan. Felixtaj Pablota wajacherkan, Jesucristopi creeskanmanta uyariyta munaspa. ");
INSERT INTO qulNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Pablo justo mana juchayoj causanamanta, tentación atipanamanta, khepaman juicio jamunanmantawan parlajtin, Félix mancharicorkan, nerkantaj: —Puripullay, waj p'unchaypi wajachiskayqui, tiempo cajtin. ");
INSERT INTO qulNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Felixtaj munarkan Pablo payman kolketa konanta cacharipunanpaj. Chayraycu achqha cuti wajacherkan paywan parlananpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ajinata iscay wata pasayta prefecto Félix cambiacaporkan Porcio Festowan. Felixtaj judiocunawan allinpi cayta munaspa, Pablota presota sakerkan. ");
INSERT INTO qulNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festo prefecto capuspa, quimsa p'unchay pasayta Cesareamanta Jerusalenman purerkan. ");
INSERT INTO qulNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Chayman sacerdotecunapaj jefencuna astawan importante judiocunapiwan jamorkancu Pablo contra quejacoj. ");
INSERT INTO qulNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Prefectomanta favorta jina mañarkancu, Pablota Jerusalenman apachinanpaj. Ñanpi wañuchinancupaj yachachiska carkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Prefectotaj contestarkan Cesareapi Pablo preso caskanta. Pay quiquintaj Cesareaman puriyta pensaspa, ");
INSERT INTO qulNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","nerkan: —Jefeyquichiscuna nokawan Cesareaman purichuncu. Chay runa juchayoj cajtenka, jakaypi juchachachuncu. ");
INSERT INTO qulNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Prefecto Festotaj Jerusalenpi cachcarkan pusajta chayri chunca p'unchaytawanchus. Chaymanta Cesareaman cutiporkan. K'ayantintaj juzgadonpi tiyachcaspa, mandarkan Pablota apamunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pablo yaycojtin, Jerusalenmanta chayamoj judiocuna chimpaycorkancu; tucuy imamanta sinchita juchacharkancu. Manataj ni mayken juchata sut'inchayta aterkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pablotaj razonninta nerkan: —Mana ni ima juchata ruwanichu ni judiocunapaj leynin contra, ni templo contra, ni Roma gobernaj contrapas. ");
INSERT INTO qulNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Prefecto Festotaj judiocunawan allinpi cayta munaspa, Pablota taporkan: —¿Jerusalenman puriyta munanquichu, chaypi noka juzganaypaj? —nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pablotaj nerkan: —Roma gobernajpaj juzgadonpi cachcani. Caypi juzgaska canay. Kan allinta yachanqui judiocuna contra ni ima mana allin ruwaskayta. ");
INSERT INTO qulNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Sichus wañunaypaj jina ima mana allintapas ruwani chayka, wañuchiwaychis. Juchachawaskancu mana cierto cajtenka, ni pipas derechoyojchu paycunaman entreganawancupaj. Mañani, Romapi quiquin athun gobierno juzgawachun. ");
INSERT INTO qulNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Prefecto Festotaj yuyaychajnincunawan parlaspa, Pabloman nerkan: —Romapi athun gobierno juzganasunquipaj mañanquiña, payman cachaskayqui. ");
INSERT INTO qulNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Chay p'unchaycunapi gobernaj Agripa warmin Berenicepiwan Cesareaman purerkancu prefecto Festo watoj. ");
INSERT INTO qulNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Chaypi achqha p'unchaycunata quedacojtincu, prefecto Festo Pablomanta gobernaj Agripaman willarkan: —Caypi can uj runa, Felixpaj preso sakeskan. ");
INSERT INTO qulNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Jerusalenpi cachcajtiy, judío sacerdotecunapaj jefencuna, judiocunapaj waj jefencunapiwan pay contra quejacorkancu. Mañawarkancutaj wañuchinaypaj. ");
INSERT INTO qulNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Nokataj paycunaman nerkani: ‘Roma gobiernopaj autoridadnenka mana pitapas wañunanpaj juchachallanchu manaraj uyanchaspa, nitaj razonninta manaraj uyarispaka.’ ");
INSERT INTO qulNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Cayman jamojtincutaj, k'ayantinpacha juzgadopi tiyaycuspa, Pablota apachimorkani. ");
INSERT INTO qulNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Payta juchachajcuna ñaupakeypi mana ima juchatapas uyanchancuchu noka yuyaskayman jinaka. ");
INSERT INTO qulNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Nillarkancu Pablo religionnincu contra caskanta, uj Jesús wañuskanmanta causarin niskanmantapiwan. ");
INSERT INTO qulNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Cay asuntopi imayna ruwayta mana yachaspa, Pablota taporkani: ‘¿Munanquichu Jerusalenman puriyta, chaypi juzgaska canayquipaj?’ nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Paytaj mañarkan Romapi athun gobierno juzgananpaj. Chayraycu presolla cachcananta mandarkani, Romaman cachamunaycama. ");
INSERT INTO qulNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Chhicataj Agripa Festoman nerkan: —Nokapas chay runata uyariyta munayman. Festotaj nerkan: —Pakarinpacha uyarinqui. ");
INSERT INTO qulNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","K'ayantin gobernaj Agripa warmin Berenicepiwan chayaspa, manchay importante jina juzgadoman yaycorkancu, soldadocunapaj jefencunawan, llajtapi respetaska runacunapiwan. Prefecto Festotaj Pablota apachimorkan. ");
INSERT INTO qulNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Prefectotaj nerkan: —Gobernaj rey Agripa, caypi nokaycuwan tantaska señorcuna, caymi chay runaka. Jakay Jerusalenpi cay Cesareapipas tucuy judiocuna ñaupakeypi payta juchachaspa, mañawarkancupuni wañunanpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Noka yuyaskayman jina mana ni ima juchata ruwanchu wañunanpaj jinaka. Chaywanpas pay quiquin mañaskanraycu, cachamusaj Romapi athun gobierno juzgananpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Manataj ima niyta atiskayraycu, señorniy gobernajniyman escribispa, ñaupakeyquichisman wajachini, kan, rey Agripa, rejsinayquipaj. Ichapas payta tapojtiyqui, yachayman imatachus cartaypi escribinayta. ");
INSERT INTO qulNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Nokapaj mana allinchu canman presota cachanayka, mana allinta willaspa imamantachus juchachaska caskanta. ");
INSERT INTO qulNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Gobernaj Agripa Pablota nerkan: —Razonniyquita niy. Pablotaj maquinta okharispa, cay jinata nerkan: ");
INSERT INTO qulNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Rey Agripa, sinchi respetaska gobernaj, cusiska cani ñaupakeyquipi razonniyta parlanaypaj judiocuna juchachawaskancumanta. ");
INSERT INTO qulNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Astawan cusiskaraj canipas judiocunapaj tucuy costumbrencuta imamantachus parlaskaycutawan yachaskayquimanta. Chayraycu mañayqui, pacienciawan uyariway. ");
INSERT INTO qulNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Tucuy judiocuna yachancu imaynatachus wayna caskaymantapacha causaskayta paycuna uqhupi, llajtaypi Jerusalenpipas. ");
INSERT INTO qulNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Yachallancutaj fariseopuni caskayta. Munaspaka, paycuna chaymanta niyta atincu. Uj judiocunamanta nejtenka religionniycuta junt'ajpuni caycu. ");
INSERT INTO qulNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Dios abuelonchiscunaman prometicuskanpi suyaskaymanta cunan juchachaska cani. ");
INSERT INTO qulNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Israelpaj chunca iscayniyoj miraynincuna suyacuncu cay quiquin prometicuskan junt'acunanta. Chayraycu Diosta adorancu, tuta p'unchay sirvispa. Rey Agripa, cay quiquin promesata suyaskayraycu judiocuna juchachawancu. ");
INSERT INTO qulNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","¿Imaraycutaj kancuna mana creenquichischu Dios wañuskata causarichinanta? ");
INSERT INTO qulNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Ñaupajtaka noka quiquiy pensarkani Nazaret llajtayoj Jesús contra imaymanata ruwayta. ");
INSERT INTO qulNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ajinata ruwarkani Jerusalenpi. Sacerdotecunapaj jefencupaj autorizacionninwan achqha creyentecunata carcelman wisk'acherkani. Wañuchejtincupas, cusicorkani. ");
INSERT INTO qulNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Achqha cuti castigarkani manaña creenancupaj obligaspa. Tucuy sinagogacunapi chayta ruwarkani. Paycuna contra manchay phiñaska cachcaspa, waj llajtacunantinpi ñac'aricherkani. ");
INSERT INTO qulNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Creyentecunata ñac'arichinaypaj Damasco llajtaman purichcarkani, sacerdotecunapaj jefenmanta autorizacionta apaspa. ");
INSERT INTO qulNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Rey Agripa, chaupi p'unchay ñanpi purichcajtiy, janaj pachamanta ricorkani uj c'anchayta, intimantapas astawan sinchi c'anchaytaraj. Nokata, nokawan cajcunatapas c'anchaycuwarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Tucuyniycu pampaman chhokacorkaycu. Hebreo idiomapi uj vozta uyarerkani, ‘Saulo, Saulo, ¿imaraycutaj katiycachachcawanqui ñac'arichinawayquipaj? Mana allinchu kanpaj qhichca punta jayt'anayqueka, kancamalla nanachicuchcanqui’ nejta. ");
INSERT INTO qulNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Nokataj nerkani: ‘¿Pitaj canqui kan, Señor?’ Señortaj niwarkan: ‘Noka cani Jesús, noka quiquiyta ñac'arichinawayquipaj katiycachachcawanqui. ");
INSERT INTO qulNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Sayariy, kanman riqhuriyqui sirvinawayquipaj, cunan ricuskayquimanta ricunquiraj chaycunamantawan nokamanta willanayquipaj. ");
INSERT INTO qulNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Nokataj judiocunamanta mana judiocunamantawan wakaychaskayqui. Cunan willajta cachaskayqui mana judiocunaman. ");
INSERT INTO qulNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Paycunaman cachaskayqui ñawincuta quicharej jina yachachimunayquipaj, manaña tutayajpi jina causanancupaj, manachayri c'anchaypi canancupaj, supay Satanaspaj atiyninmanta escapaspa Diosta sirvinancupaj, nokapi creespa perdonaska canancupaj, Diospaj santo familianwan cusca uj herenciata jap'ekanancupajpas.’ Ajinata Señor niwarkan. ");
INSERT INTO qulNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Rey Agripa, janaj pachamanta ricuskayta casucuni. ");
INSERT INTO qulNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ñaupajtaka evangeliota willarkani Damascopi, chaymanta Jerusalenpi, tucuy Judea provinciapi, waj nacioncunapipas. Paycunata wajarkani juchancumanta Diosman cutirinancupaj, allin ruwaskancuwan converticuskancuta ricuchicunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Chaymanta judiocunaka templopi jap'iwaspa, wañuchiyta munawarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Diospaj yanapayninwan cunancama cachcani, tucuynejpi Diosmanta parlaspa tucuy runacunaman, juch'uycunaman athuncunamanpas. Profetacunapas Moisespas imaynatachus pasananmanta nerkancu, chay quiquinta nini: ");
INSERT INTO qulNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","‘Cristo wañunan carkan, chaymantataj ñaupajta pay causarinan, chay jinamantataj salvación c'anchay jina willaska cananpaj llajtanchisman waj llajtacunamanpas.’ ” ");
INSERT INTO qulNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Ajinata Pablo razonninta nejtin, prefecto Festo alto vozwan nerkan: —¡Loco canqui, Pablo! Sinchita estudiaskayqui locoman tucuchisunqui. ");
INSERT INTO qulNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pablotaj nerkan: —Mana locochu cani, sinchi respetaska prefecto. Manachayri razonniywan verdadta nini. ");
INSERT INTO qulNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Caypi cachcan rey Agripa. Payka allinta yachan. Chayraycu ñaupakenpi mana manchacuspa, sut'inta parlani. Segurani, paypas tucuy caycunata yachan, mana pacapi caycuna pasaskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Sinchi respetaska rey Agripa, ¿profetacunapaj niskancuta creenquichu? Yachani creeskayquita. ");
INSERT INTO qulNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Rey Agripataj nerkan: —Juch'uyllamanta yakapuni cristianoman tucuchiwanqui. ");
INSERT INTO qulNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pablotaj nerkan: —Juch'uymantapas achqhamantapas, Dios munachun mana kanllachu, manachayri tucuy cunan uyarichcawajcunapas noka jina creyente canayquichispaj, mana cay cadenacunawanpas. ");
INSERT INTO qulNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Pablo chayta nejtin, sayarerkancu rey Agripa, prefecto Festo, Berenice, tucuy chaypi tiyachcajcunapiwan. ");
INSERT INTO qulNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Waj chhicaman parlaj purerkancu. Paycunapura nerkancu: —Cay runaka ni imata ruwanchu wañuchinapaj jinaka, ni carcelpipas cananchu. ");
INSERT INTO qulNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Rey Agripa prefectoman nerkan: —Cay runata cacharipuchuwan carkan, manachus pay quiquin mañanman carkan, Romapi caj athun gobierno juzgananpaj chayka. ");
INSERT INTO qulNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Italiaman cachanawancu cajtin, Pablota waj presocunatawan entregarkancu Julio sutiyoj capitanman, Emperador niska batallonpaj jefenman. ");
INSERT INTO qulNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Adramitiomanta chayamoj bote Asia puertocunaman llojsichcarkanña. Chayman yaycorkaycu. Nokaycuwan cachcallarkantaj Aristarco sutiyoj runa Macedonia provinciapi caj Tesalónica llajtamanta. ");
INSERT INTO qulNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","K'ayantin Sidón llajtaman chayarkaycu. Capitán Juliotaj Pabloman favorta ruwaspa permisota korkan amigoncunata watunanpaj, paycuna Pablota atendinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Sidonmanta llojsispa, unu muyuycuska Chipre jallp'anejman purerkaycu, wayramanta cuidacuspa, nokaycu contra caskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Cilicia, Panfilia provinciacunapaj kayllanta pasarkaycu. Chayarkaycutaj Licia provinciapi caj Mira llajtaman. ");
INSERT INTO qulNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Chaypi soldadocunapaj capitannin uj boteta jap'erkan, Alejandriamanta Italiaman purichcajta. Chay botepi apapuwarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Achqha p'unchaycuna allillanmanta purerkaycu. Gnido chimpaman ñac'ayta chayarkaycu. Wayra nokaycu contraraj caskanraycu, Salmón chimpaman pasarkaycu, unu muyuycuska Cretata muyuspa. ");
INSERT INTO qulNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Jallp'a kayllanta purispa, ñac'ayta chayarkaycu Buenos Puertos niskaman, Lasea llajta kayllaman. ");
INSERT INTO qulNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Chayman chayanapaj unayta tardaporkaycu, manaña kochanta purina jinachu carkan, chiri tiempo kayllachamuchcaskanraycu. Chayraycu Pablo paycunata yuyaycharkan, nispa: ");
INSERT INTO qulNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","—Señorcuna, seguro cani cay viaje mana allinchu canka. Boteta cargacunatapas chincachisunchis, wañusunrajchus canpas. ");
INSERT INTO qulNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Soldadocunapaj capitannintaj Pablopaj niskanta mana casorkanchu, manachayri botepaj dueñonta bote apajtawan casorkan. ");
INSERT INTO qulNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Chay puertotaj mana allinchu carkan kasay tiempo pasanapaj. Tucuytaj pensarkancu allin cananta chaymanta llojsispa Feniceman chayanancuta, chaypi kasay tiempo pasanancupaj. Fenicetaj Creta nacionpi carkan, inti yaycuy khawariska. ");
INSERT INTO qulNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Uraynejmanta uj chhicanta wayramuskanraycu, pensarkancu puriy atinancuta. Llojsispataj purerkancu unu muyuycuska Cretapaj jallp'a kayllanta. ");
INSERT INTO qulNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Manaraj caruta purichcajtiycutaj, sinchi athun wayra botenejman jatarerkan. ");
INSERT INTO qulNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Boteta apayta kallarerkan. Wayranejman boteta mana cutichiyta atispa, jinallaña apachicaporkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Cauda niska juch'uy unu muyuycuska jallp'a wasanta pasarkaycu. Chaynejpi pisita wayrachcarkan. Juch'uy boteta boteman ñac'ayta aysarkorkaycu. ");
INSERT INTO qulNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Juch'uy boteta aysarkospa, athun botetañataj wataycorkaycu sogacunawan callpachananpaj. Sirte niska akopi boteta sat'iycucunanta manchacuspa, botepaj vela niska tolderanta juch'uyyacherkancu. Ajinamanta wayrallawanña apachicorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","K'ayantintaj wayra manapuni thanejtin, unuman cargacunata wijch'uycuyta kallarerkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Minchhantintaj botepaj cajnincunata unuman wijch'uycapullarkancutaj. ");
INSERT INTO qulNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Achqha p'unchayta mana intita ni koyllurcunatapas ricorkaycuchu. Sinchi athun wayrawan manaña salvacunaycuta yuyarkaycuchu. ");
INSERT INTO qulNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Achqha p'unchayña mana miqhuska caskaycuraycu, Pablo tucuyniycupaj chaupiycupi sayaycuspa, nerkan: —Señorcuna, allin canman carkan casunawayquichiska, Cretamanta mana llojsinata. Ajinapi mana cay jinata chincachicuchuwanchu carkan, unuman cargacunata wijch'uycuspaka. ");
INSERT INTO qulNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Cunanka chaywanpas ama desanimacuychischu. Mana maykenpas wañunquichischu, bote chincapojtinpas. ");
INSERT INTO qulNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Kayna tutapi uj ángel riqhuriwarkan, sirviskay Diosniypaj cachamuskan. ");
INSERT INTO qulNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Niwarkantaj: ‘Ama manchacuychu, Pablo, Romapi caj athun gobiernowan tupamunayqui. Kanraycu Dios wañuymanta libranka kanwan botepi tucuy cajcunata.’ ");
INSERT INTO qulNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Chayraycu, señorcuna, animacuychis. Noka Diospi confiacuni angelpaj niskanman jina cananta. ");
INSERT INTO qulNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Chaypajtaj uj unu muyuycuska jallp'aman wijch'orkoska cananchis. ");
INSERT INTO qulNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Adriático niska kochapi iscay semanaña purichcajtiycu, wayra tucuynejman apaycachachcawarkancu. Uj tuta, cusca tuta kaylla, bote apajcuna repararkancu jallp'aman chayachcaskaycuta. ");
INSERT INTO qulNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Uqhu cayninta unuta miderkancu, quimsa chunca sojtayoj metro carkan. Astawan jakaynejpiña ujtawan midillarkancutaj, iscay chunca kanchisniyoj metro carkan. ");
INSERT INTO qulNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Kakaman wajracuyta manchacuspa, rauc'anayoj tawa fierrocunata khepanejman cachaycorkancu. Diosmanta mañacuchcarkancu pakariyanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Bote apajcunataj botemanta escapayta pensarkancu. Chaypajtaj juch'uy boteta apakachcarkancu, fierrocunata cachaycoj jinalla. ");
INSERT INTO qulNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Pablotaj capitanninman soldadocunamanpiwan willarkan: —Caycuna botepi mana quedacojtincoka, mana salvacuyta atinquichischu —nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Chayraycu soldadocuna sogacunata cuchurparispa, unuman juch'uy boteta cachaycorkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Pakariyayta Pablo tucuynincuta imallatapas miqhunancupaj nerkan: —Ima pasananta suyaspa, iscay semanaña mana miqhuska canquichis. ");
INSERT INTO qulNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Rogayquichis, imallatapas miqhuychis causayta munaspaka. Mana uj chujchallayquichispas chincankachu. ");
INSERT INTO qulNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Chayta nispa Pablo uj t'antata jap'ispataj, Diosman graciasta korkan tucuynincupaj ñaupakenpi. Partispataj Pabloka miqhuyta kallarerkan. ");
INSERT INTO qulNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Tucuynincu animacuspa, miqhullarkancutaj. ");
INSERT INTO qulNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Iscay pachaj kanchis chunca sojtayoj carkaycu botepi. ");
INSERT INTO qulNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Sajsanancucama miqhuspataj, trigota unuman jich'aycorkancu, bote sujayananpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Bote apajcuna chay jallp'ata mana rejserkancuchu. Pakariyajtin, ako playa pampata ricorkancu. Chayman boteta chayachiyta munarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Fierro wataska sogacunata cuchurparispa, kochapi sakeporkancu. Bote pusaj remocunata wayayacherkancu. Ñaupaj lado vela niska tolderata okharerkancu. Botetaj playaman kayllachayta kallarerkan. ");
INSERT INTO qulNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Botetaj kocha uqhupi akoman sat'iycucorkan, mana cuyurej. Khepanejmantataj callpawan olada wijch'umuspa, ñut'uycapuchcarkan. ");
INSERT INTO qulNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Soldadocunataj presocunata wañuchiyta munarkancu, mana wayt'aspa escapanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Capitannincutaj Pablota salvayta munaspa, paycunata jarc'arkan. Astawanpas mandarkan wayt'ay yachajcuna ñaupajta wayt'aspa jallp'aman chayanancupaj, ");
INSERT INTO qulNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","mana wayt'ay yachajcunataj tablacunapi jap'icuspa khepanta purinancupaj. Ajinapi tucuyniycu jallp'aman chayarkaycu. ");
INSERT INTO qulNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Tucuyniycu salvaskaña caspa, yacharkaycu Malta islapi caskaycuta. ");
INSERT INTO qulNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Chaypi tiyajcuna tucuyniycuta sumajta ricuwarkancu. Parachcarkan, chirichcarkantaj. Chayraycu paycuna ninata jap'icherkancu, “K'oñicuychis” nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pablo llant'ata okharispa, ninaman churaycuchcarkan. Uj palli ninamanta escapachcaspa, Pablopaj maquinpi c'utuycuspa warcuycucorkan. ");
INSERT INTO qulNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Chaypi tiyajcunataj Pablopaj maquinpi pallita warcurayachcajta ricuspa, paycunapura ninacorkancu: “Cay runaka runa wañuchej. Kochamanta salvacun chaywanpas, Diospaj justo caynin mana causajta dejanchu” nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Pablotaj pallita ninaman thalaycorkan. Pablotataj mana imanarkanpaschu. ");
INSERT INTO qulNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Paycunataj suyachcarkancu punquiycunanta, chayri wañunanta. Unaytaña suyaspa, mana imanajtin, nerkancuñataj: “Cay runaka uj diospuni” nispa. ");
INSERT INTO qulNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Cachcarkaycu uj importante runa Publio sutiyoj niskapaj chajrancuna kayllapi. Pay sumajta ricuwarkancu quimsa p'unchaycama. ");
INSERT INTO qulNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Publiopaj tatantaj calenturawan disenteriawan onkoska cachcarkan puñunapi. Pablo khawarej yaycorkan. Diosmanta mañaspa maquinta pay pataman churaspa, alliyacherkan. ");
INSERT INTO qulNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Chayta uyarispa, chay jallp'api caj waj onkoskacunapas jamorkancu, alliyachiskallataj carkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Astawan sinchi sumajta ricuwarkancu. Botepi puripuchcajtiycu, tucuy imata churapuwarkancu apacunaycupaj. ");
INSERT INTO qulNT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Quimsa quillata chay jallp'api kasay tiempota pasarkaycu. Chaymanta botepi puriporkaycu. Chay botetaj Alejandriamanta carkan, botepaj ñaupakenpi iscay diosnincupaj estatuan carkan, Cástor Pólux sutiyoj. ");
INSERT INTO qulNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Siracusa llajtaman chayaspa, quimsa p'unchayta quedacorkaycu. ");
INSERT INTO qulNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Chaymanta puriporkaycu jallp'a kayllanta Regio llajtacama. K'ayantintaj uraynejmanta wayramojtin, minchhantinraj Puteoli llajtaman chayarkaycu. ");
INSERT INTO qulNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Chaypi creyentecunata tariparkaycu, paycunataj niwarkancu uj semanata quedacunaycupaj. Ajinapi khepantin Roma llajtaman chayarkaycu. ");
INSERT INTO qulNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Romapi caj creyentecuna yachaskacuña nokaycu chayanaycumanta; taripaj jamuwarkancu Apio sutiyoj plazacama, waquintaj Tres Tabernas niskacama. Creyentecunata ricuspa, Pablo Diosman graciasta korkan, animacorkantaj. ");
INSERT INTO qulNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Romaman chayajtiycu, capitán presocunata jefenman entregarkan. Pablotataj sakerkancu waj wasipi tiyananpaj, uj soldadotawan payta cuidananpaj. ");
INSERT INTO qulNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Quimsa p'unchay pasaymanta Pablo importante caj judiocunata wajachimorkan. Tantaskaña cajtincutaj, nerkan: —Waukecuna, noka mana ima juchatapas ruwanichu judiocuna contra, ni abuelonchiscunapaj costumbren contrapas. Chaywanpas Jerusalenpi jap'ispa, Roma soldadocunaman entregawarkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Paycunataj tapuway pasayta, cachariyta munawarkancu. Mana ni ima razonta tarerkancuchu wañuchinawancupaj jina. ");
INSERT INTO qulNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Judiocunataj mana cacharinawancuta munarkancuchu. Chayraycu mañarkani Romapi athun gobierno juzganawanpaj. Chaywanpas judiocunata mana juchachanichu. ");
INSERT INTO qulNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Chayraycu wajachiyquichis kancunata parlapayanaypaj. Nokanchis Israel llajtayojcuna suyaskanchisraycu, cay cadenacunawan wataska cachcani. ");
INSERT INTO qulNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Paycunataj nerkancu: —Judeamanta ni ima cartata kanmanta willaspa apachimuwancuchu. Nitaj mayken judío waukecunapas chaymanta jamuspa, kan contra willawancuchu. ");
INSERT INTO qulNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Chaywanpas kanpaj niskayquita uyariyta munaycu, imatachus pensaskayquita. Yachaycu tucuynejpi cay mosoj secta contra parlaskancuta. ");
INSERT INTO qulNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Uj ajllaska p'unchaypi achqha judiocuna Pablopaj cachcaskan wasiman jamorkancu. Tutamantapacha tardecama Pablo Diospaj gobiernonmanta parlarkan, Moisespaj leyninwan profetacunapaj ecribiskanwan ima Jesusmanta entendichiyta munaspa. ");
INSERT INTO qulNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Waquin Pablopaj niskanta creerkancu, waquintaj mana creerkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Paycuna mana uj yuyayllaman chayayta atispa puripuchcajtincu, Pablo nerkan: —Allintapuni Santo Espíritu profeta Isaiaspaj niskanwan abuelonchiscunaman nerkan: ");
INSERT INTO qulNT_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Puriy, cay llajtayojcunaman willay. Uyaricuchcachuncupas, mana entendenkacuchu. Khawacuchcachuncupas, mana riconkacuchu. ");
INSERT INTO qulNT_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Cay llajtayojcunapaj yuyaynincoka mana allin razonniyojchu. Lluphaska jina ninriyoj cachcancu mana uyarinancupaj, wisk'aska jina ñawiyoj mana ricunancupaj, ni entendinancupajpas, mana nokaman cutirimunancupaj, nokataj mana salvanaypaj.’ ");
INSERT INTO qulNT_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Yachaychis, cunanmanta jakaynejman cay Diospaj salvacionnenka willaska canka mana judiocunaman. Paycunataj uyarispa, creenkacu. ");
INSERT INTO qulNT_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Chayta Pablo nejtin, judiocunaka paycunapura discutispa puriporkancu. ");
INSERT INTO qulNT_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pablotaj arrendaska wasipi iscay wata junt'ata cachcarkan. Chaypi pay tucuy watoj jamojcunata jap'ekarkan. ");
INSERT INTO qulNT_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Tucuy libertadwan Diospaj gobiernonmanta willarkan, yachacherkantaj Señor Jesucristomanta, mana pipaj jarc'askan. Ajina cachun.");
INSERT INTO qulNT_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Noka, Pablo, Jesucristopaj sirvejnin, cay cartata escribini. Dios wajawaspa ajllawarkan apostolnin canaypaj, salvación evangeliota willanaypaj. ");
INSERT INTO qulNT_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Profetancunapaj escribiskan uqhunta santa Escriturapi Dios ñaupajmantaña cay evangeliota willarkan. ");
INSERT INTO qulNT_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Cay evangelioka parlan Diospaj Churin Señorninchis Jesucristomanta. Runa cayninman jina gobernaj rey Davidpaj mirayninmanta nacerkan. ");
INSERT INTO qulNT_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Espiritunpi santo Dios cachcaspa, causariskanwan sut'ita ricuchicun Diospaj tucuy atiyniyoj Churin caskanta. ");
INSERT INTO qulNT_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Jesucristoraycu Dios favorninpi ajllawarkan apóstol canaypaj, sutinpi evangeliota willanaypaj, tucuy nacioncunapi runacuna Jesucristopi creenancupaj, payta casunancupaj. ");
INSERT INTO qulNT_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Kancunatapas, Romapi cajcunata, Dios wajasunquichis Jesucristopi cajcunawan canayquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Dios munacusunquichis, wajasunquichistaj Jesucristopajta canayquichispaj, Diospaj wawancuna canayquichispaj. Dios Tatanchis Señor Jesucristopiwan favorninwan sonko tiyaycuyninwan kancunata bendicichun. ");
INSERT INTO qulNT_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Ñaupajta, Jesucristo uqhunta Diosniyman graciasta koni tucuyniyquichismanta, imaraycuchus creeskayquichismanta willararkancu tucuy nacioncunapi. ");
INSERT INTO qulNT_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Tucuy sonkoywan Diosta sirvini, Churinmanta evangeliota willaspa. Diostaj yachan, mana konkaspa kancunapaj oracionta ruwachcanipuni. ");
INSERT INTO qulNT_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Diosmanta mañanipuni kancunata watumunaypaj, Dios munajtenka. ");
INSERT INTO qulNT_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Ricuyta munayquichis yanaparinaypaj, Dioswan causayniyquichispi astawan firme canayquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Niyta munani, cay creeyninchispi uj ujcuna animanacusunchis. ");
INSERT INTO qulNT_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Hermanocuna, yachanayquichista munani achqha cuti kancunaman jamuy munaskayta, cunancama mana atimunichu. Kancuna uqhupi Diospaj obranta athunyachiyta munani imaynatachus waj nacioncunapipas ruwarkani jinata. ");
INSERT INTO qulNT_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Noka manu jina cani evangeliota willanaypaj tucuy runacunaman: educaskacunaman mana educaskacunamanpas, yachayniyojcunaman mana yachayniyojcunamanpas. ");
INSERT INTO qulNT_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Chayraycu sinchita animaska cachcani kancunamanpas, Romapi tiyajcunaman, evangeliota willamunaypaj. ");
INSERT INTO qulNT_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Evangeliomanta mana p'enkacunichu, imaraycuchus evangelioka Diospaj atiynin tucuy creejcunata salvananpaj, ñaupajta judiocunata, mana judiocunatapas. ");
INSERT INTO qulNT_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Cay evangelio uqhunta Dios ricuchiwanchis imaynata runacuna justo mana juchayoj jina jap'ekaska canata, chaytaj creeskaraycu, creeskallawan. Escrituraka ajinata nin: “Diospaj justo niskan runaka creeskanwan causanka.” ");
INSERT INTO qulNT_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Janaj pachamanta Diospaj athun castigon jamun tucuy sajracunaman, mana allin runacunaman. Paycunaka juchasapa caynincuwan verdad rejsinata jarc'ancu. ");
INSERT INTO qulNT_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Paycuna Diosmanta yachanataka allinta yachancu, Dios quiquin ricuchiskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Diospaj ruwaskancunamanta allinta yuyancuman chayka, cay pacha ruwaskanpi sut'ita ricuncuman Dios caskanta, wiñaypaj atiynintapas. Chayraycu mana pipas ninmanchu, “Diosmanta mana imatapas yachanichu” nispaka. ");
INSERT INTO qulNT_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Diosta rejsincu; chaywanpas mana honrancuchu, ni graciasta koncuchu; astawanpas manachanin pensaskancuwan mana yuyayniyoj caynincuwan tutayajpi jina quedacuncu. ");
INSERT INTO qulNT_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","“Yachayniyoj cani” nincu, chaywanpas sonso cancu. ");
INSERT INTO qulNT_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Mana jayc'aj wañoj, glorioso honrayoj Diosta adoraypachaka runapaj ruwaskan dioscunata adorancu: wañoj runacunapaj, pisketocunapaj, tawa chaquiyoj animalcunapaj, pallicunapaj ruwaska imagennincunata adorancu. ");
INSERT INTO qulNT_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Chayraycu Dios sakerpayarkan, paycunapaj khelli munaynincupi causanancupaj. Paycunapura p'enkaycunata ruwancu uj ujcunawan. Animal jina cuerponcuta khellichanacuncu, manapas runachu cancuman jinata. ");
INSERT INTO qulNT_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Diospaj verdad niskanmanta carunchacuspa, llullacunata creencu. Diospaj ruwaskancunallata alabancu, adorancutaj, manataj tucuy ruwaj Dios quiquintachu. Diosllatami wiñaypaj alabanaka. Ajina cachun. ");
INSERT INTO qulNT_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Chayraycu Dioska sakerpayarkan p'enkay khelli munaynincuta ruwanancupaj. Warmicunapas kharincuwan canancuta sakespa, warmipura waj jina canata masc'ancu. ");
INSERT INTO qulNT_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Ajinallatataj kharicunapas warmincuwan canancuta sakespa, kharipura waj jina canata sinchita masc'ancu. Kharipura p'enkay juchata ruwancu. Chayraycu cuerponcu quiquinpi castigota sufrincu. ");
INSERT INTO qulNT_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Diosta negaskancuraycu, Dios sakerpayarkan sajra yuyaynincuman, mana ruwanata ruwanancupaj. ");
INSERT INTO qulNT_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Tucuy ima mana allincunawan junt'a cancu: tucuy imapi mana justo caywan, khelli caywan, kolke sonkocunawan, millay sajra caycunawanpas. Callancutaj: envidiacojcuna, wañuchejcuna, ch'ajwajcuna, engañacojcuna, khelli ruwajcuna, simi apajcuna, ");
INSERT INTO qulNT_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","wajcunamanta mana allinta parlajcuna, Diosta chejnejcuna, insultacojcuna, pay pay tucuspa despreciacojcuna, orgullosocuna, sajra cay waquichejcuna, tata mamancu mana casojcuna, ");
INSERT INTO qulNT_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","mana entendiy munajcuna, parlaskancu mana junt'ajcuna, mana munacuyniyojcuna, mana perdonajcuna, mana qhuyapayacojcuna. ");
INSERT INTO qulNT_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Allinta yachancu Dios chay jina runacunata castigananta, chaywanpas ruwachcallancu, cusicuncutaj paycuna jina jucha ruwajcunawan. ");
INSERT INTO qulNT_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Pipas cay, wajcunata juchachaspaka, kan quiquiyqui juchachacunqui, imaraycuchus ujcunapaj millay ruwaskanta ruwachcallanquitaj. Chayraycu manaña imapas ninayqui canchu. Kanta Dios castigasunqui. ");
INSERT INTO qulNT_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Yachanchis, Dioska verdadman jina juchachan juchallicojcunataka. ");
INSERT INTO qulNT_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Kantaj wajcunata juchachaspa, paycuna jina ruwachcallanquitaj. Ama creeychu Diospaj castigonmanta escapanayquita. ");
INSERT INTO qulNT_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Diospaj mana tucucoj allin cayninta, aguantayninta, pacienciantawan kan desprecianqui; manataj reparacunquichu Diospaj chay allin caynin pusaskasunquita, payman cutirinayquipaj. ");
INSERT INTO qulNT_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Kan khoru sonkoyoj caspa, mana Diosman cutiriyta munanquichu. Kan quiquiyquipaj castigota taukachcanqui, juicio p'unchaypi Dios justo cayninman jina sinchita castiganasunquipaj. ");
INSERT INTO qulNT_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Sapa ujta ruwaskancuman jina juchachaska canka. ");
INSERT INTO qulNT_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Picunachus allinta ruwachcallanpuni, chaycuna masc'ancu Diosmanta gloriata, honorta, wiñay causaytawan, chaycunaman Dios wiñay causay salvacionta konka. ");
INSERT INTO qulNT_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Sajra mana casucoj runacunatataj phiñacuywan castiganka, verdad contra cajcunata, mana allin ruwaycunata “allin” nejcunata. ");
INSERT INTO qulNT_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Ñac'ariycuna sinchi llaquicuycunapiwan canka tucuy mana allin ruwajcunapaj, ñaupajta judiocunapaj, mana judiocunapajpas. ");
INSERT INTO qulNT_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Allin ruwajcunamantaj Dios gloriata, honorta, sonko tiyaycuytawan konka, ñaupajta judiocunaman, mana judiocunamanpas. ");
INSERT INTO qulNT_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Dioska uj ujcunata mana waj wajtachu khawan. ");
INSERT INTO qulNT_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Tucuy mana Moisespaj leyninwan juchallicojcunaka castigaska cankacu mana chay leywanpas. Moisespaj leyninwan juchallicojcunataj chay quiquin leyman jina castigaska cankacu. ");
INSERT INTO qulNT_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Leyta uyarispallaka juchamanta mana librechu cancu, manachayri casucojcunalla salvaska cancu. ");
INSERT INTO qulNT_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Mana judiocuna mana Moisespaj leyninwan cachcaspa, Moisespaj leyninman jina allinta ruwancu chayka, ricuchincu paycuna quiquincupi ley caskanta. ");
INSERT INTO qulNT_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Allinta ruwaspa, ricuchincu sonkoncupi ley escribiska caskanta. Juicio p'unchaypi quiquin concienciancu pensaskancupas willaconka allinta chayri mana allinta ruwaskancuta. ");
INSERT INTO qulNT_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Chay juicio p'unchaypi Jesucristo uqhunta Dios tucuy pacaska juchacunata juchachanka, salvación evangeliota willaskayman jina. ");
INSERT INTO qulNT_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Kan ninqui, “Judío cani” nispa. Moisespaj leyninpi jap'icunqui; Diosniyquimanta orgulloso cachcanqui. ");
INSERT INTO qulNT_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Diospaj munayninta yachanqui; leynenka yachachisunqui allincaj ajllayta. ");
INSERT INTO qulNT_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Seguro cachcanqui, juchapi ñausa jina cajcunata verdadman pusayta atinayquita. Tutayajpi jina cajcunaman verdadta yachachispa c'anchaycunayquita creecunqui. ");
INSERT INTO qulNT_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Mana yachajcunata humilde cajcunatapas yachachiy atinayquita creecunqui, Diospaj leyninpi verdad yachaycuna kanwan caskanraycu. ");
INSERT INTO qulNT_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Allin ari, wajcunata yachachispari, ¿imaraycutaj kancama mana yachachicunquichu? Willanqui mana suwacunata chayri, ¿imaraycutaj suwacunqui? ");
INSERT INTO qulNT_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Adulterio juchata mana ruwanata ninqui chayri, ¿imaraycutaj adulteriota ruwanqui? Ruwaska dioscunata chejninqui chayri, ¿imaraycutaj chay dioscunapaj templonpi cajcunata suwanqui? ");
INSERT INTO qulNT_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Leymanta alabacunqui chaywanpas, Diosta mana honranquichu leyta mana casucuskayquiwan. ");
INSERT INTO qulNT_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Escrituraka razonta nin: “Juchayquichisraycu waj diosniyojcuna verdadero Dios contra parlancu.” ");
INSERT INTO qulNT_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Moisespaj leyninta casucojtiyqui, circuncisión costumbreka yanapa jina sirvisunqui. Mana leyta casucojtiyqueka, mana circuncidaska jina canqui. ");
INSERT INTO qulNT_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Mana circuncidaska cajcunari leypaj mandaskanman jina purincu chayka, circuncidaska jinaña cancu, mana circuncidaskapas. ");
INSERT INTO qulNT_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Cuerponpi mana circuncidaska cajcunaka leyta casucuskancuraycu juchachankacu mana casucojcunataka, circuncidaskatapas leyniyojtapas. ");
INSERT INTO qulNT_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Judío cayka, circuncidaska caypas, mana cuerpo patallapichu canan, ni costumbrecunallapichu. ");
INSERT INTO qulNT_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Verdadero judío cayka sonko uqhunmanta circuncidaska caymi, mana escribiska costumbrecunamantachu, manachayri Santo Espiritumanta. Ajina cajka mana runacunapaj “allin” niskallanchu, manachayri Diospaj “allin” niskan. ");
INSERT INTO qulNT_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","¿Imapajtaj valin judío cana, circuncidaska canapas? ");
INSERT INTO qulNT_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Achqhapaj valin, achqha razoncuna can. Ñaupajta, Dios palabranta judiocunaman korkan. ");
INSERT INTO qulNT_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Waquin judiocuna mana fiel capojtincu, ¿imataj pasanman? ¿Chayraycuchu Dios mana fiel canman? ");
INSERT INTO qulNT_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","¡Chayka mana jinachu! Astawanpas Dioska verdadman jina tucuy imata ruwan, tucuy runa llulla cajtincupas. Escrituraka nin: “Niskayquicunapi justopaj jap'iska canqui, juchachajtincupas atipanqui.” ");
INSERT INTO qulNT_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Sajra cayninchis Diospaj justo cayninta ricuchejtinri, ¿imatataj nisunman: Dios nokanchista castigaspa, manachu justo? (Caytaka parlachcani juchasapa runacuna jinalla.) ");
INSERT INTO qulNT_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","¡Mana ari! Dios mana justo caspari, ¿imaynatataj runacunata juchachanman? ");
INSERT INTO qulNT_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Waquincuna nincu: “Llullacuyniywan Diospaj verdadnin sut'inchacun chayka, ¿imaraycutaj Dios juchachawan juchasapata jina?” ");
INSERT INTO qulNT_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Nillancutaj: “Mana allincunata ruwasun, allincuna astawanraj sut'inta riqhurinanpaj.” Waquincuna jinata yachachiskayta nichcancu, “Mana allinchu yachachiskan” ninawancupaj. Chaycunaka ruwaskancuman jina castigaska canancu. ");
INSERT INTO qulNT_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","¿Imataj, nokanchis judiocuna waj runacunamanta nejtin astawan allinchu canchisri? ¡Chayka mana jinachu! Ricuchiycunña judiocuna mana judío cajcunapas juchapi caskancuta. ");
INSERT INTO qulNT_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Escrituraka nin: “¡Mana ujpas canchu allin ruwajka! ¡Mana canchu ni ujllapas! ");
INSERT INTO qulNT_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","¡Mana ujpas canchu yuyayniyojka! ¡Mana canchu Diosta masc'ajka! ");
INSERT INTO qulNT_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Tucuynincu mana allinman puripuncu; tucuynincu millay ruwajcama cancu. ¡Mana ujpas canchu allin ruwajka! ¡Mana canchu ni ujllapas! ");
INSERT INTO qulNT_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Parlaskancoka sepultura quicharaska jina. Kalluncuwan parlaskancupas llullacuna. Simincu uqhupi palli veneno pacaska jina. ");
INSERT INTO qulNT_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Simincoka sajra parlaycunawan phiñacuywan junt'a cachcan. ");
INSERT INTO qulNT_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Chaquincupas phawan runacunata wañuchinancupaj. ");
INSERT INTO qulNT_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Causaynincoka ñut'uska nanaywan, ñac'ariycunawan. ");
INSERT INTO qulNT_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Sonko tiyaycuy causayta mana rejsincuchu. ");
INSERT INTO qulNT_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Jayc'ajpas Diosta manchacuncuchu.” ");
INSERT INTO qulNT_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Yachanchis leypaj tucuy niskanka leypi cajcunapaj churaska caskanta, tucuy runa ni ima niytapas atinancupaj, juchancuta rejsinancupaj, tucuy runacuna Diospaj ñaupakenpi juchachaska canancupaj. ");
INSERT INTO qulNT_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Manami Moisespaj leyninta junt'askancuraycuchu Dioska pitapas salvan; leyka rejsichiwanchis juchasapa caskallanchista. ");
INSERT INTO qulNT_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Cunanka mana leyllawan Dios yachachiwanchis imaynamanta salvaska cananchista. Chaymantaka leenchis Moisespaj leyninpi profetacunapaj libronpipas: ");
INSERT INTO qulNT_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Dioska salvawanchis Jesucristopi creeskanchisraycu. Dios tucuy creejcunata salvan. ");
INSERT INTO qulNT_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Tucuy juchallicuncu, salvacoj Diosmantataj carunchacapuncu. ");
INSERT INTO qulNT_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Diostaj sumaj favorninpi juchamanta kasilla salvan Jesucristo uqhunta libraspa. ");
INSERT INTO qulNT_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Dios Jesucristota churarkan, juchamanta wañunanpaj, jich'aska yawarninwan perdonananpaj. Chaywanpas creejcunallata perdonan. Ajinapi Dioska ricuchicun justo caskanta. Manaraj Jesucristo wañojtenka, Dios pacienciacuspa juchasapacunata mana castigarkanchu. ");
INSERT INTO qulNT_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Chaywanpas cunanka Jesucristopaj wañuskanwan Dios ricuchicun justo caskanta. Justopuni cachcan, Dios nin: “Jesuspi creejcunaka juchancumanta salvaska cancu.” ");
INSERT INTO qulNT_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Diospaj ñaupakenpi, ¿maytaj runapaj alabacuskanri? ¡Mana canchu! ¿Imaraycutaj? Imaraycuchus mana leyta junt'askanraycuchu salvaconka, manachayri creeskancurayculla. ");
INSERT INTO qulNT_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Ajinapi yachanchis, Dios sut'inchan creejcuna salvaska caskancuta, leypaj mandaskancunata junt'ananta mana obligaspa. ");
INSERT INTO qulNT_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","¿Judiocunallapajchu Diosri? ¿Manachu tucuy nacioncunapi caj runacunapajpiwan? Arí, tucuy runacunapajpiwan. ");
INSERT INTO qulNT_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Uj Dioslla can, creejcunata salvaj Dios; mana importanchu circuncidaska, mana circuncidaska canancoka. ");
INSERT INTO qulNT_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Chhicari, ¿creeywanchu ley mana valipun? ¡Chayka mana jinachu! Astawanpas leyka valinpuni. ");
INSERT INTO qulNT_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Abuelonchis Abraham, ¿imatataj jap'ekarkan? ");
INSERT INTO qulNT_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Abrahamchus ruwaskancunaraycu justo canman carkan chayka, alabacunman, manataj Diospaj ñaupakenpeka. ");
INSERT INTO qulNT_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Escrituraka nin: “Abraham Diospi creerkan, chayraycu Dioska justo mana juchayojta jina jap'ekarkan.” ");
INSERT INTO qulNT_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Mayken ruwajmanpas pagota koncu chayka, mana uj regalochu, manachayri llanc'askanmanta. ");
INSERT INTO qulNT_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Pipas juchamanta libraj Diospi creen chayka, Dios jap'ekan justo mana juchayojta jina creeskanraycu, mana ima allintapas ruwanchu salvanapaj jina chaywanpas. ");
INSERT INTO qulNT_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","David quiquin parlarkan pitachus Dios jap'ekan justo mana juchayojta jina, mana ruwaskancunaraycuchu. ");
INSERT INTO qulNT_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","David nerkan: “¡Cusicuyniyoj cancu picunatachus Dios perdonan millay ruwaskancu juchacunamanta! ");
INSERT INTO qulNT_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","¡Runaka cusicuyniyojmi, chay runapaj juchanta Señor mana yuyajtin!” ");
INSERT INTO qulNT_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","¿Cay niskataj circuncidaskacunallapajchu, icha mana circuncidaska cajcunapajpiwanchu? Ninchisña, Abrahampaj creeskanraycu Dios justo mana juchayojta jina jap'ekarkan. ");
INSERT INTO qulNT_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","¿Jayc'ajtaj jap'ekarkanri? ¿Abraham circuncidaskaña cajtinchu, icha ñaupajtachu? Ñaupajtaña, manaraj circuncidaska cachcajtin. ");
INSERT INTO qulNT_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Chhicamantaraj Abrahamka circuncidaska carkan señal jina, creeskanraycu justo mana juchayojta jina ña Diospaj jap'ekaskantaña ricuchinanpaj. Cay jinamanta Abrahamka tucuy creyentecunapaj tatancu jina carkan, mana circuncidaska cachcajtincupas. Dios jinatacama tucuy creyenteta jap'ekan justota jina. ");
INSERT INTO qulNT_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Abrahamka tata, circuncidaska creyentecunapajpas, Abraham jina Diospi creeskancuraycu. Payka creerkanña manaraj circuncidaska cachcaspa. ");
INSERT INTO qulNT_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Dios Abrahamman miraynincunamanpas prometicorkan, cay pachata jap'ekanancupaj herenciata jina. Mana leyta casucunan caskanwanchu, manachayri Diospi creeskanraycu chay promesata jap'ekarkan. Diostaj payta jap'ekarkan justo mana juchayojta jina. ");
INSERT INTO qulNT_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Leyta casucojcunacaj herenciata jap'ekancuman chayka, Diospi creenaka yankhallapaj canman, Diospaj promesantaj mana valorniyoj canman. ");
INSERT INTO qulNT_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Leyka castigota apamun. Mana ley cajtinri, mana jucha canchu ley contraka. ");
INSERT INTO qulNT_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Abrahamman tucuy miraynincunamanpas Diospaj prometicuskan seguro cananpaj, creeskancuwan chay promesata jap'ekanancu carkan. Chay promesaka mana leyta casucojcunallapajchu, manachayri Abraham jina tucuy creejcunapaj. Chay jinamanta Abrahamka tucuyninchispaj tatanchis jina. ");
INSERT INTO qulNT_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Escriturapi Dios nin: “Achqha nacioncunapi caj runacunapaj tatanta ruwayqui.” Abrahampaj creeskan Dios cayta nerkan, wañuskacunata causachej Dios, manaraj cajcunatapas ruwaj Dios. ");
INSERT INTO qulNT_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Abraham creerkan, manaña suyana jina cajtinpas. Ajinapi achqha nacioncunapi caj runacunapaj tatan carkan Diospaj niskanman jina: “Ajina mirayniyqueka achqha canka” nispa. ");
INSERT INTO qulNT_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Abraham yaka pachaj watayoj jinaña caspa, warmin Sarapas mana wawayoj wañuska jinaña. Iscaynincu machu payaña carkancu, chaywanpas creeynin mana pisiyarkanchu. ");
INSERT INTO qulNT_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Mana iscayrayarkanchu, nitaj Diospaj prometiskanta desconfiarkanchu, manachayri astawan confiaspa creerkan, alabarkantaj Diosta. ");
INSERT INTO qulNT_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Creerkanpuni Dios prometicuskanta junt'ananpaj atiyniyoj caskanta. ");
INSERT INTO qulNT_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Chayraycu Dios jap'ekarkan justota jina. ");
INSERT INTO qulNT_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Creeskanraycu justota jina Dios jap'ekaskanka, mana Abrahamllamantachu escribicun. ");
INSERT INTO qulNT_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Nokanchismantawan escribicullarkantaj. Creeskanchisraycu Dioska nokanchistapas justocunata jina jap'ekawanchis, Señorninchis Jesucristo causarichejpi creejcunata. ");
INSERT INTO qulNT_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Chay Jesucristo juchanchisraycu wañunanpaj entregaska carkan, causarimorkantaj salvaska cananchispaj. ");
INSERT INTO qulNT_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Ajinaka creeyninchiswan salvaska caspa, Dioswan allinpi canchis Señorninchis Jesucristoraycu. ");
INSERT INTO qulNT_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Jesucristopi creeyninchiswantaj Diospaj favorninta jap'ekanchis. Chaypi firme canchis. Suyacuywan cusicunchis Diospaj glorioso causayninwan cananchismanta. ");
INSERT INTO qulNT_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Mana chayllachu, cusicullanchistaj ñac'ariycunapipas. Yachanchis ñac'ariycunaka pacienciata apamuwaskanchista aguantananchispaj. ");
INSERT INTO qulNT_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Pacienciacojtinchistaj, Dios “allin” niwanchis. “Allin” niwaskanchistaj suyacuywan junt'achiwanchis. ");
INSERT INTO qulNT_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Chay suyacoyka seguro, imaraycuchus Dioska munacuyninwan sonkonchista junt'achiwanchis Santo Espirituta kowaskanchisraycu. ");
INSERT INTO qulNT_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Mana salvacuyta atichcajtinchis, Diospaj ajllaskan tiempopi Cristo juchasapacunaraycu wañorkan. ");
INSERT INTO qulNT_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Mana facilchu waj runaraycu wañuchiska canaka, ni justo runa cajtinpas. Ichapas waquin wañuncuman uj sinchi sumaj runaraycu. ");
INSERT INTO qulNT_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Diostaj munacuyninta ricuchiwanchis, imaraycuchus juchapiraj cachcajtinchis, Cristo nokanchisraycu wañorkan. ");
INSERT INTO qulNT_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Cunanka Jesucristopaj wañuskanwan juchamanta salvaskaña canchis. Astawan seguro, Jesucristo uqhunta athun castigo juiciomanta salvaska casunchis. ");
INSERT INTO qulNT_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Dios contraraj cachcajtinchis, Dios pay quiquinwan allinyachiwanchis paypaj Churin Jesucristopaj wañuskanwan. Paypaj causariska causayninwantaj astawan seguro salvaska canchis, cunan Dioswan allinpiña caskanchista yachaspa. ");
INSERT INTO qulNT_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Mana cayllachu, manachayri Señorninchis Jesucristoraycu Diospi cusicullanchistaj, imaraycuchus Cristoraycu Dioswan allinpi canchis. ");
INSERT INTO qulNT_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Ajina ari, uj ch'ulla runa uqhunta juchaka cay pachaman yaycun, juchataj wañuyta apamun. Wañuytaj tucuynincuman pasan, imaraycuchus tucuynincu juchallicuncu. ");
INSERT INTO qulNT_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Manaraj Moisespaj leynin cachcajtin, cay pachapi jucha carkanña. Mana ley cajtenka, leyman jina mana juchachaska carkancuchu. ");
INSERT INTO qulNT_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Chaywanpas Adanmanta Moisescama tucuynincu juchancumanta wañorkancu, mana Adán jina quiquinta juchallicuspapas. Chay Adanka jamojpaj rijch'acuynin carkan. ");
INSERT INTO qulNT_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Adanpaj juchanka mana rijch'acunmanchu Diospaj regalonwanka. Uj ch'ulla runapaj juchanraycu achqha wañurarkancu. Diostaj salvacionta kasilla kowanchis uj ch'ulla runaraycu. Chaytaj Jesucristo, sinchi athun, achqhayojpaj allinninpaj. ");
INSERT INTO qulNT_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Ch'ulla runapaj juchanka mana rijch'acunmanchu Diospaj regalonwan. Uj ch'ulla jucharaycu castigo jamun; Diospaj regalonraycu runacunaka achqha juchancumanta salvaska cancu. ");
INSERT INTO qulNT_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Ch'ulla runapaj juchanraycu tucuy runacuna wañuncu. Picunatachus Dios athun qhuyapayacuyninpi kasilla salvan, chaycuna astawan seguro cancu. Mosoj causaypi wiñaypaj causankacu uj ch'ulla runaraycu, chaytaj Jesucristo. ");
INSERT INTO qulNT_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Adanpaj juchanka castigota apamun tucuy runacunaman. Ajinallatataj Jesucristopaj justo ruwaskan apamun tucuy runacunapaj salvaska causanata, castigomanta libre cananpaj. ");
INSERT INTO qulNT_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Niyta munan, uj runa mana casucuskanraycu, tucuynincu juchayoj cancu. Ajinallatataj uj ch'ulla runa casucuskanraycu, achqhayoj salvaska cancu juchancumanta. ");
INSERT INTO qulNT_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Dioska leyta korkan juchanchista astawan reparacunanchispaj. Juchanchis sinchi athun cajtinpas, Dioska astawanraj ricuchiwanchis athun qhuyapayacuyninta. ");
INSERT INTO qulNT_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Imaynatachus juchaka atiyniyoj carkan wañuyta apamunanpaj, ajinallatataj Diospaj qhuyapayacuynenka atiyniyoj juchamanta salvanawanchispaj, wiñay causayta konawanchispaj Señorninchis Jesucristoraycu. ");
INSERT INTO qulNT_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","¿Ima nisuntaj? Dios qhuyapayacuyninta astawan ricuchinanpaj, ¿juchallatapunichu ruwasunchis? ");
INSERT INTO qulNT_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Chayka mana jinachu. Nokanchiska wañuska jinaña canchis juchapajka. ¿Imaynatataj juchallapipuni causachuwan? ");
INSERT INTO qulNT_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","¿Manachu yachanquichis, bautismonchispi Cristo Jesuswan ujlla caspa Cristo jina wañuskanchista? ");
INSERT INTO qulNT_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Bautismonchisraycu Cristowan p'ampaska jina carkanchis. Paywan wañorkanchis causariska cananchispaj, mosoj causaypi causananchispaj, imaynatachus Cristo Dios Tatapaj sumaj glorioso atiyninwan causarerkan jinata. ");
INSERT INTO qulNT_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Sichus Cristowan cusca wañuyninpi canchis chayka, ajinallatataj causarimuyninpipas paywan cusca causasunchis. ");
INSERT INTO qulNT_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Yachanchis ñaupaj causayninchis Cristowan cusca chacataska caskanta, jucha causayninchis chincachiska cananpaj, amaña juchata casucunanchispaj patronta jina. ");
INSERT INTO qulNT_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Cristowan wañojka juchamanta cachariska. ");
INSERT INTO qulNT_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Cristowan wañunchis chayka, seguro paywan causasunchis. ");
INSERT INTO qulNT_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Yachanchis Cristo causarispa manaña ujtawan wañunanta. Wañoyka manaña Cristota wañuchiyta atinchu. ");
INSERT INTO qulNT_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Cristoka jucharaycu uj cutilla wañorkan; causarimuspataj, Diospaj causan. ");
INSERT INTO qulNT_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Ajinallatataj kancunapas juchapajka wañuska jina caychis, Diospajtaj causachcaj caychis Cristo Jesuswan cusca. ");
INSERT INTO qulNT_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Chayraycu ama dejaychischu wañoj cuerpoyquichista jucha mandananta, nitaj obligananta cuerpoyquichispaj mana allin munaskancunata casunanta. ");
INSERT INTO qulNT_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Amallataj cuerpoyquichista juchaman koychischu, mana allincunata ruwananpaj; manachayri wañuskamanta causariskata jina Diosman cuerpoyquichista koychis, allin cajcunata ruwananpaj. ");
INSERT INTO qulNT_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Ajinapi juchaka manaña atiyniyojchu kancunata mandananpaj, imaraycuchus manaña leypaj mandaskanpichu canquichis, manachayri Diospaj qhuyapayacuyninpi canquichis. ");
INSERT INTO qulNT_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Manaña leypaj mandaskanpichu canquichis, manachayri Diospaj qhuyapayacuyninpiña canquichis chayka, ¿juchallicusunchu? ¡Mana jinachu! ");
INSERT INTO qulNT_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Allinta yachanquichis, uj patronman casunapaj entregacojtiyquichiska, chay patronpaj mandaskanpi canquichis casunayquichispaj. Chayraycu juchata casojtiyquichiska, wañuyman apasunquichis; Diosta casojtiyquichistaj, justo causaypi causanquichis. ");
INSERT INTO qulNT_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Gracias Diosman, ñaupajka juchapaj mandaskanpi carkanquichis; cunanka verdad yachachiskata jap'ekaspa, tucuy sonkoyquichiswan casucunquichisña. ");
INSERT INTO qulNT_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Juchapaj mandaskanmanta cachariskaña caspa, justo causanapaj canquichis. ");
INSERT INTO qulNT_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","(Runa jina parlani, imaraycuchus runa cayniyquichiswan cay yachachiycunata mana allintachu entendiyta atinquichis.) Imaynatachus ñaupajka cuerpoyquichis entregaska carkan millay khellita mana allincunatawan ruwanayquichispaj, ajinallatataj cunanka cuerpoyquichista Diosman entregaychis justo causaypi purinayquichispaj, ciertotapuni Diosllapaj causanayquichispaj. ");
INSERT INTO qulNT_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Juchapaj mandaskanpiraj cachcaspaka, mana justo causaypichu carkanquichis. ");
INSERT INTO qulNT_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Chay wañuyman apaj juchamanta cunanka p'enkacunquichis. ¿Ima allintataj chay juchamanta orkhorkanquichis? Ni imatapas. ");
INSERT INTO qulNT_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Cunanka juchapaj mandaskanmanta cachariskaña caspa, Diospaj sirvejnin canquichis. Caycajka allin kancunapaj. Apasunquichis Diosllapaj causanayquichispaj, chaymantataj wiñay causayman apasunquichis. ");
INSERT INTO qulNT_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Juchamanta pagoka infiernomi; salvaska wiñay causaytaj Diospaj regalon, Señorninchis Jesucristowan ujlla cajtinchis. ");
INSERT INTO qulNT_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Hermanoycuna, kancuna leyta rejsinquichis. Yachanquichistaj causachcajcunalla leyta casunancutaka. ");
INSERT INTO qulNT_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Uj casaraska warmipas, kosan causachcajtillan, leyman jina casaraskaka. Kosan wañupojtenka, chay casaraskan leymanta warmeka cachariska capun. ");
INSERT INTO qulNT_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Chayraycu kosan causachcajtin waj khariwan meticun chayka, adulterio juchata ruwan. Kosan wañupojtintaj, pay cachariska capun chay casaraskan leymanta. Wajwan casaracuspataj, mana adulterio juchata ruwanchu. ");
INSERT INTO qulNT_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Ajinallatataj, hermanoycuna, kancunapas Cristopaj wañuskanraycu paywan cusca leymanta cachariska canquichis, waj kosayoj jina canayquichispaj. Cunanka causariska Cristopaj canquichis. Cay jinamanta causayninchiska Diospaj sirvin. ");
INSERT INTO qulNT_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Juchasapa jinaraj causachcaspa, leyta yachaspapas, cuerponchispaj mana allin munaskancunaraycu leyta mana casorkanchischu. Chaytaj wañuyman apachcawarkanchis. ");
INSERT INTO qulNT_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Cunanka leypaj atiyninmanta cachariska canchis Diosta sirvinapaj Santo Espiritupaj kowaskanchis mosoj causaywan, manataj escribiska mauc'a leywanchu. ");
INSERT INTO qulNT_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","¿Chayraycuchu nisunchis: “Leyka jucha” nispa? ¡Mana jinachu! Manachayri mana leywanka mana juchata yachaymanchu carkan. Ley, “Ama munapayanquichu” mana nejtenka, jayc'ajpas yachaymanchu carkan imachus munapayayka. ");
INSERT INTO qulNT_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Chay mandamientopi jap'icuspa, juchaka tucuy imayna mana allin munaycunata ruwachin. Manaraj ley cajtenka, juchaka wañuska jina. ");
INSERT INTO qulNT_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Uj tiempopi causarkani mana leywan. Ley jamojtintaj, juchaka causariska jina caporkan. ");
INSERT INTO qulNT_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Nokataj wañorkani. Chay leyka causayta kowaypachaka wañuyman apachcawarkan. ");
INSERT INTO qulNT_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Chay leypi jap'icuspa juchaka engañawarkan, wañuchiwanmanpas jinata. ");
INSERT INTO qulNT_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Tucuchaypeka, ley quiquenka santo, mandamientopas santo, justo, allin. ");
INSERT INTO qulNT_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","¿Ley allin caspari, apawankachu wañuyman? ¡Mana jinachu! Juchapuni caskanta ricuchicunanpaj, juchaka allin cajpi jap'icuspa wañuchiwan. Ajinaka leypaj mandacuskanwan juchaka ricuchicun sinchi sajra caskanta. ");
INSERT INTO qulNT_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Yachanchis leyka Diosmanta caskanta, nokataj juchayoj runa cayniypi esclavo jina juchaman vendiska cani. ");
INSERT INTO qulNT_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Mana entendinichu ima pasawaskanta. Munaskayta mana ruwanichu, manachayri chejniskayta ruwani. ");
INSERT INTO qulNT_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Mana munaskayta ruwani chayka, reparacuni leyka allin caskanta. ");
INSERT INTO qulNT_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Ajinaka manaña nokachu ruwani, manachayri nokapi caj jucha ruwan. ");
INSERT INTO qulNT_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Yachani ari, juchayoj runa cayniypi ni ima allin cawaskanta. Allinta ruwayta munani chaypas, mana ruwayta atinichu. ");
INSERT INTO qulNT_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Mana ruwanichu allin ruway munaskayta, manachayri mana allinta ruwani, mana ruway munaskayta. ");
INSERT INTO qulNT_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Cunan ari, sichus mana ruway munaskayta ruwani chayka, mana nokachu ruwani, manachayri nokapi caj jucha ruwan. ");
INSERT INTO qulNT_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Reparacuni, allinta ruwayta munani chaypas, mana allin ruwanallata ruwani. ");
INSERT INTO qulNT_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Uqhuypeka Diospaj leynin gustawan. ");
INSERT INTO qulNT_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Reparacuni, nokapi imacha razonniy contra apawan. Chayka jucha, nokapi cachcan, presochawantaj. ");
INSERT INTO qulNT_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","¡Ay, noka pobre ñac'arej! ¿Pitaj cay cuerpoypi caj wañuypaj atiyninmanta cacharichiwanka? ");
INSERT INTO qulNT_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Dioslla cacharichiwan. Payman graciasta koni Señorninchis Jesucristo uqhunta. Ajinamanta yachani Diospaj leyninta casunaytapuni, chaywanpas runa caspa juchata sirvini. ");
INSERT INTO qulNT_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Cunanka mana ima castigopas canchu Cristo Jesuspi cajcunapajka, mana juchaman jina astawanpas Espirituman jina causajcunapaj. ");
INSERT INTO qulNT_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Santo Espíritu Diospaj causayninta kon Cristo Jesuspi creejcunaman. Cacharichiwanchistaj juchamanta wañuymantawan. ");
INSERT INTO qulNT_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Moisespaj leynin mana ruway atiskanta Dios ruwan. Chay ley mana salvayta atiwarkanchischu juchayoj runa caskanchisraycu. Dios quiquin Churinta cuerpoyojta cachamun juchayoj runata jina, jucharaycu wañunanpaj, chay jinamanta runa cuerponpi juchapaj atiyninta atipananpaj. ");
INSERT INTO qulNT_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Chayta ruwan, leypaj mandaskanta Cristopi junt'ananchispaj. Manaña juchayoj runa cayman jinachu causanchis, manachayri Espirituman jina. ");
INSERT INTO qulNT_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Juchayoj runa cayman jina causajcunaka runapaj munaskancunallapi afanacuncu. Santo Espirituman jina causajcunataj Espiritupaj munaskancunapi afanacuncu. ");
INSERT INTO qulNT_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Runapaj munaskancunallapi afanacoyka wañuyman apan. Espiritupaj munaskancunapi afanacuytaj wiñay causayman sonko tiyaycuymanpiwan apan. ");
INSERT INTO qulNT_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Runapaj cayninman afanacojcunaka Dios contra cancu. Mana Diospaj leyninta munancuchu, ni casuyta atincuchu. ");
INSERT INTO qulNT_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Chayraycu juchayoj runapaj munaskancunaman jina causajcunaka mana Diosman agradayta atincumanchu. ");
INSERT INTO qulNT_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Kancunaka manaña juchayoj runapaj munaskanman jinachu causanquichis, manachayri Santo Espirituman jinaña, sichus Diospaj Espíritun kancunapi causan chayka. Pipajchus mana Cristopaj Espíritun canchu chayka, mana Cristopajtachu. ");
INSERT INTO qulNT_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Kancunapi Cristo causan chayka, espirituyquichis causan, imaraycuchus Dios juchamanta salvasunquichis, jucharaycu cuerpoyquichis wañunan cachcan chaywanpas. ");
INSERT INTO qulNT_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Jesusta causarichej Dios