﻿USE sofia;
DROP TABLE IF EXISTS sofia.quhNT_vpl;
CREATE TABLE quhNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES quhNT_vpl WRITE;
INSERT INTO quhNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Cay kelkaskaka Jesucristoj ñaupaj tatasninmantamin. Jesuska Abrahammanta jamun Davidmantawan. ");
INSERT INTO quhNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahamka Isaacpa tatan carka. Isaactaj Jacobpa tatan carka. Jacobtaj Judajpata waukesninpatawan tatancu carka. ");
INSERT INTO quhNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judataj Farespa tatan carka, Zarajtawan. Paycunaj mamancuri Tamar carka. Farestaj Esrompa tatan carka. Esromtaj Arampa tatan carka. ");
INSERT INTO quhNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramtaj Aminadabpa tatan carka. Aminadabtaj Naasonpa tatan carka. Naasontaj Salmonpa tatan carka. ");
INSERT INTO quhNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmontaj Boozpa tatan carka. Boozpa mamanri Rahab carka. Booztaj Rutwan Obedpa tatasnin carkancu. Obedtaj Isaipa tatan carka. ");
INSERT INTO quhNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaitaj camachej Davidpa tatan carka. Davidtaj Salomonpa tatan carka. Salomonpa maman ñaupajta Uriaspa warmin carka. ");
INSERT INTO quhNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomontaj Roboampa tatan carka. Roboamtaj Abiaspa tatan carka. Abiastaj Asaj tatan carka. ");
INSERT INTO quhNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asataj Josafatpa tatan carka. Josafattaj Jorampa tatan carka. Joramtaj Uziaspa tatan carka. ");
INSERT INTO quhNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziastaj Jotampa tatan carka. Jotamtaj Acazpa tatan carka. Acaztaj Ezequiaspa tatan carka. ");
INSERT INTO quhNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequiastaj Manasespa tatan carka. Manasestaj Amonpa tatan carka. Amontaj Josiaspa tatan carka. ");
INSERT INTO quhNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiastaj Jeconiaspata waukesninpatawan tatancu carka. Chaypacha Diospa unay runasnin Babiloniaman apaskas carkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babiloniaman apaskas carkancu chay khepatataj Jeconiaska Salatielpa tatan carka. Salatieltaj Zorobabelpa tatan carka. ");
INSERT INTO quhNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabeltaj Abiudpa tatan carka. Abiudtaj Eliaquimpa tatan carka. Eliaquimtaj Azorpa tatan carka. ");
INSERT INTO quhNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azortaj Sadocpa tatan carka. Sadoctaj Aquimpa tatan carka. Aquimtaj Eliudpa tatan carka. ");
INSERT INTO quhNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudtaj Eleazarpa tatan carka. Eleazartaj Matanpa tatan carka. Matantaj Jacobpa tatan carka. ");
INSERT INTO quhNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobtaj, Maríaj kosanpa Joséj tatan carka. Chay Mariamanta Jesuska nacecorka. Payka Diospa ajllaskan Cristo sutichaska carka. ");
INSERT INTO quhNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ajinapi tucuy miraycunaka Abrahammanta Davidcama chunca tawayoj yupacuncu. Davidmanta Babiloniaman Diospa runasnin apachiskas carkancu chaypachacamataj chunca tawayoj miraycuna carkancu. Babiloniaman apaskas carkancu chaymantapacha Cristoj nacecuynincamataj chunca tawayoj miraycuna carkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Cayjinapimin Jesucristoka nacecorka. María, Jesuspa mamanka, mañaskaña carka Josewan casaracunanpaj. Manaraj tanta cashajtincutaj Mariaka wijsalliska riqhurerka Santo Espiritunejta. ");
INSERT INTO quhNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Parlaskan Josetaj chekanta ruwaj runa carka. Mana munaspa Mariata p'enkayman riqhurichiyta yuyarka pacayllamanta sakepuyta. ");
INSERT INTO quhNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Chay imasmanta mayta yuyashajtintaj, khaway, Señor Dios uj angelta cachamorka. Moskoyninpi Joseman riqhurispa nerka: —José, camachej Davidpa ayllunmanta canqui. Amaña manchachicuychu parlapayaskayqui Mariata jap'icapuyta. Cay wijsallicuskanka Santo Espiritumantamin cashan. ");
INSERT INTO quhNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mariaka uj khari wawata onkoconka. Paytajmin wiñaspa paypa cajcunanta juchamanta cacharichenka. Chayraycu Jesusta sutichanqui. ");
INSERT INTO quhNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tucuy cayka ruwacorka Señor Diospa niskan junt'acunanpaj. Chaytaka unay willajninnejta nerka: ");
INSERT INTO quhNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","¡Khaway! Uj sipas, mana khari rejsej, wijsalliconka. Uj khari wawata onkoconka. Payka Emanuel sutichaska canka. Emanuel niyta munan: Dios nokanchejwan cashan yanapanawanchejpaj. ");
INSERT INTO quhNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Joseka puñuskanmanta rijch'arispa, Señor Diosmanta cachamuska, chay angelpa camachiskanmanjina ruwarka. Ajinapi payka Mariata wasinman pusacaporka runas yachanancupaj warmin caskanta. ");
INSERT INTO quhNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Joserí payta mana llanqharkachu curaj wawanta onkocunancama. Wawa nacecojtintaj Jesusta suticharka. ");
INSERT INTO quhNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesuska Judea jallp'a Belén llajtapi nacecorka, Herodes camachishajtin, chay p'unchaycunapi. Chaypacha yachaysapacuna inti llojsimuy caru llajtamanta jamuspa Jerusalén llajtaman chayamorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Tapucorkancutaj: —¿Maypitaj cashan israel runasta camachinanpaj nacecoj Wawarí? Ch'ascanta inti llojsimuy ladopi ricuycu. Chayta khatispataj payta yupaychanaycupaj jamuycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Chayta uyariytawantaj camachej Herodeska mancharicorka. Jerusalén llajtapi caj tucuy runaspis paywan mancharicullarkancutaj. ");
INSERT INTO quhNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Chaymantataj Herodes tantachimorka yupaychana-wasimanta curajcunata, israel yachachejcunatawan. Paycunata taporka: —¿Maypitaj Diospa ajllaskan Cristo nacecunan tiyan? ");
INSERT INTO quhNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Paycunataj cuticherkancu: —Judea jallp'a Belén llajtapi naceconka. Ajinata Dios unay willajninta kelkacherka: ");
INSERT INTO quhNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Kancuna, Judá jallp'a Belén llajtapi tiyacojcunata niyquichej: Judá jallp'api caj curajcunamanta aswan jatunpaj khawaskas canquichej. Kancunamanta uj curaj camachej naceconka. Paytaj, ajllaska israelcunayta michenka. ");
INSERT INTO quhNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Chanta Herodes pacayllamanta yachaysapacunata wajyacherka. Ajinallatataj taporka yachananpaj mayc'ajchus chay ch'asca riqhurimuskanta. ");
INSERT INTO quhNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Paycunatataj Belén llajtaman cacharka nispa: —Riychej. Allintataj yachamuychej chay wawitamanta. Payta tarispataj willawaj cutimuychej. Nokapis rispa payta yupaychamusaj, —nispa. Chaytari mana cheka sonkowanchu nisharka. ");
INSERT INTO quhNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Yachaysapacunaka camachejpa niskanmanjina riporkancu. Inti llojsimuy, chay ladopi ricuskancu ch'ascaka ñaupakencuta risharka. Jesús casharka, chaycama pusamuspa patannejpi sayacorka. ");
INSERT INTO quhNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Yachaysapacunataj chay ch'ascata ricuspa maytapuni cusicorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Paycuna wasiman yaycuspataj Wawitata ricorkancu maman Mariatawan. Konkoricuspataj Jesusta yupaycharkancu. Apaskancuta quicharispa khapaj capuynincuta payman korkancu. Korita, inciensota, k'apayniyoj mirra jampitawan payta yupaychaspa jaywarkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Chaymantataj moskoynincupi Dios paycunata willarka Herodespaman ama cutinancuta. Chayraycu paycunaka jallp'ancuman waj ñanta cutiporkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Yachaysapa runas ripuskancuwantaj Dios uj willaj angelta cachamorka. Joseman moskoyninpi riqhurimuspataj nerka: —Jataricuy. Wawitata, Wawaj mamantawan pusaricuspa Egipto jallp'aman aykecuy. Jakaypi tiyacamuy noka willasunaycama. Herodeska masc'aj rishan Wawitata wañuchinanpaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Chay quiquinpachataj José tutapi rijch'arispa jatarerka. Wawitata mamantawan pusariycucuspa Egipto jallp'aman riporka. ");
INSERT INTO quhNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Jakaypitaj Herodes wañunancama tiyacamorkancu. Tucuy cayka ruwacorka Diospa niskan junt'acunanpaj. Chaytaka unay willajninnejta nerka: “Egiptomanta llojsimpunanta Wawayta wajyarkani”. ");
INSERT INTO quhNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herodeska chay yachaysapacuna anchata asipayaycuskancuta reparaspa mayta phiñacorka. Runasnintataj camacherka tucuy khari wawasta iscay watayojcama wañuchimunancuta. Paycunataj wawacunata wañucherkancu Belén llajtapi tucuy chaynejpipis. Jesuspa ch'ascan riqhurimuskan p'unchaycunata yachaysapacunamanta yachaspa chayta ruwarka. ");
INSERT INTO quhNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ajinapi Diospa niskan junt'aska carka. Pay unay willajnin Jeremiasnejta nerka: ");
INSERT INTO quhNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Phutiy wakay uyaricun Ramá llajtapi. Raquel wawasninmanta khaparispa wakashan jatun llaquiywan “ay, ay” nispa. Manaña sonkochacunmanñachu wawasnin wañuskas caskancuraycu. ");
INSERT INTO quhNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodes wañupojtinrí Dios uj willaj angelta cachamorka. Joseman moskoyninpi riqhurispa Egipto jallp'api ");
INSERT INTO quhNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","nerkataj: —Jataricuy. Wawitata mamantawan pusaricuspa ripuy Israel jallp'aman. Wawitata wañuchiyta munajcunaka ñapis wañupuncuña, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Chay quiquinpacha José jataricuspa Wawitata mamantawan pusaricorka Israel jallp'aman. ");
INSERT INTO quhNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Arquelao tatan Herodespa cuentanpi Judea jallp'ata camachisharka. Chayta uyarispa Joseka manchachicorka chayman tiyacoj riyta. Moskoyninpi Dios payman willaskanraycutaj Galilea jallp'aman riporka. ");
INSERT INTO quhNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nazaret llajtaman chayaspa chaypi tiyacorka. Ajina ruwacorka Diospa niskan junt'acunanpaj. Unay willajcunanejta nerka Jesús Nazaret llajtayoj sutichaska cananta. ");
INSERT INTO quhNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Chaypacha bautizaj Juanka riqhurerka willaraspa Judea jallp'a ch'innejpi. ");
INSERT INTO quhNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Nerkataj: —Diospa ajllaskan camachinanpaj chayamunña. Chayraycu juchasniyquichejta sakespa payman cutiriychej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Cay Juanmanta Diospa unay willajnin Isaías parlarka: Ch'innejpi uj runa khaparishan: “Runas uj jatun camachej jamunanpaj ñanta waquichipunancu tiyan. Ajinallatataj sonkosniyquichejta waquichiychej tucuy atiyniyoj Señor jamunanpaj”. ");
INSERT INTO quhNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Willaraj Juanka llamajina camello millmamanta p'achawan p'achallicorka. Kara chumpiwantaj chumpiska carka. Langostastataj miqhoj lachiwana misq'itawan. ");
INSERT INTO quhNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ashqha runas payta uyarej llojsimoj cancu. Jerusalén llajtamantapis tucuy Judea jallp'amantawan Jordán mayu tucuy chaynejmantawan jamoj cancu. ");
INSERT INTO quhNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Paycuna juchasnincuta willashajtincu Juan Jordán mayupi paycunata bautizasharka. Ajinapi runas ricucherkancu Diosman cutiriskancuta. ");
INSERT INTO quhNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Juanka ashqha fariseo partecunata saduceo partecunatawan bautizacoj jamushaskancuta ricorka. Paycunatataj nerka: —Kancuna runa wañuchi catarisjina canquichej. Diospa c'ajaj phiñacuyninmanta aykecunayquichejpaj ¿pitaj willasorkachejrí? —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Diospa phiñacuyninmanta aykecuyta munanquichej chayka, juchasniyquichejta sakeychej. Chaywanpis c'acha ruwaskasniyquichejwan Diosman cutiriskayquichejta ricuchiychej. ");
INSERT INTO quhNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kancunaka Abraham unay tatanchej caskanta nishanquichej. Diospa cheka wawasnin caskayquichejta yuyaspa pantanquichej. Amaña sonkoyquichejpi ajinata jatunchacuychejchu. Imaraycuchus niyquichej Dioska atiyniyojmin cay rumismantapis Abrahampaj cheka wawasninta ruwananpaj. ");
INSERT INTO quhNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Hachaka waquichiskaña cashan sach'a saphinmanta c'utunanpaj. Sapa sach'a mana allin pokojtaka runas c'utuspa ninaman wijch'uncu. ");
INSERT INTO quhNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Chekatapuni noka yacupi bautizayquichej Diosman cutiriskayquichejta ricuchinapaj. Khepaytarí Diospa ajllaskan Cristo jamonka. Payka aswan curaj atiyniyoj nokamanta niskaka. Mana paypajka camachinpajjinallapischu cani runalla caskayraycu. Paymin kancunata bautizaspa Santo Espirituta sonkoyquichejman cachamusonkachej Diosllapaj causanayquichejpaj. Ninawantaj bautizasonkachej. ");
INSERT INTO quhNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Trigo erata wayrachejka jorc'ata maquinpiña jap'ishan. Erata sumajta pichanka trigota ch'uyachananpaj. Trigota pirwanman jallch'anka. Pajatarí ni jayc'aj wañoj ninaman ruphachenka, —nispa willararka Juan. ");
INSERT INTO quhNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Chanta Jesuska Galilea jallp'amanta Jordán mayuman jamorka. Chaypitaj Juanwan bautizachicuyta munarka. ");
INSERT INTO quhNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Juanrí mana munarkachu bautizayta. Jesusmantaj nerka: —Nokata astawanpis kanka bautizanawayqui tiyan. Chanta ¿imaraycutaj nokaman jamuwanqui? —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesusrí payman cuticherka: —Cunan bautizanawayqueka allillan. Yachanchej Diospa tucuy munayninta ruwananchejpuni caskanta, —nispa. Chanta Juanka Jesuspa mañaskanta ruwarka. ");
INSERT INTO quhNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesuska bautizachicuytawan yacumanta llojsiporka. Janaj pachari paypaj quichariska carka. Ricorkataj Diosmanta cachamuska Santo Espirituta palomatajina uraycamojta payman tiyaycucojtapis. ");
INSERT INTO quhNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ajinapitaj Dios janaj pachamanta nimorka: —Paymin c'ata munaska Wawayka. Paypi mayta cusicuni, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Chanta Santo Espiritoka ch'in lomaman Jesusta pusarka. Chaypitaj supay Satanás imaymanamanta juchallichiyta munarka. ");
INSERT INTO quhNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jesuska tawa chunca p'unchayta tawa chunca tutatawan mana miqhorkachu Diosta yupaychananpaj. Chaymantataj payka yarkhachicorka. ");
INSERT INTO quhNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Chay pantachej supayri Jesusman kayllaycuspa nerka: —Sichus Diospa cheka Wawan canqui chayka, niy cay rumista t'antaman cutinancuta. ");
INSERT INTO quhNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesusrí cutichispa nerka: —Palabranpi Dios nin: “Mana miqhunallawanchu runaka causan. Manachayrí Diospa tucuy niskanta casuspa causan”, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Chanta supayka Diospa ajllaska llajtan Jerusalenman Jesusta pusarka. Chaypitaj yupaychana-wasi patapi sayaricherka. ");
INSERT INTO quhNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Jesusmantaj nerka: —Diospa Wawan canqui chayka, cay patamanta pampaman phinquiycuy. Imaraycuchus Diospa palabranpi nin: Angelesninta camachenka kanta wakaychasunancupaj. Maquisnincuwantaj kanta jap'isonkancu ama rumisman urmanayquipaj. ");
INSERT INTO quhNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesusrí payta c'amerka: —Dios palabranpi nillantaj: “Ama Señor Diosniyquej atiyninta mana cajpaj mañacuychu”. ");
INSERT INTO quhNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Uj cutitawan supayka Jesusta pusallarkataj. Cunanpeka may jatun orko patamanña chayacherka. Jesusmantaj tucuy cay pachapi caj camachiska jallp'asta, khapaj capuynincutawan ricucherka. ");
INSERT INTO quhNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Chaymantataj supayka nerka: —Tucuy cayta kopuskayqui sichus kan konkoricuspa yupaychawanquiman chayka. ");
INSERT INTO quhNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Chanta Jesuska payman cuticherka. —Ripuy nokamanta, supay Satanás. Imaraycuchus Dios palabranpi nin: “Señor Diosnillayquita yupaychay. Pay sapallamantaj konkoricuspa casuy”, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Chaymanta supayka Jesusta sakeporka. Yanapaj angelestaj jamuspa Jesusman pisichicuskanta jaywarkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jesustaj Juan wisk'aska caskanta uyarispa Galilea jallp'aman rerka. ");
INSERT INTO quhNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nazaret llajtamanta llojsispa payka Capernaum llajtaman tiyacoj rerka. Chay llajtaka Galilea kocha cantopi carka. Zabulonwan Neftaliwan jallp'as chaynejpi carkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Chaypi Jesús tiyacorka Diospa unay willajnin Isaías niskanmanjina: ");
INSERT INTO quhNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zabulón jallp'api Neftalí jallp'apiwan tiyacojcuna, kancuna tiyacunquichej kochaman rina ñan Jordán mayu chimpapi. Galilea jallp'api tiyacuncu Diosmanta mana yachajcuna. ");
INSERT INTO quhNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Dioska willarajninta cachamorka wiñay causaymanta mana yachajcunapaj. Chay runaska wiñay wañuyman risharkancu. Paycunataj juchancumanta cachariskas canancupaj sumaj willanasta uyarerkancu. Chaytaj uj c'anchayjina carka tucuypaj. ");
INSERT INTO quhNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Chaymantapachataj Jesús kallarerka willarayta: —Diospa ajllaskan p'unchayka cunan chayamushanña. Cunan payka munacoj Camachejniyquichej canka. Chayraycu juchasniyquichejta sakespa payman cutiricuychej sumaj willanasnintataj jap'icuychej. ");
INSERT INTO quhNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesuska Galilea kocha cantonejta purishaspa ricorka iscay waukesta. Ujnin Simón, Pedro sutiyoj carka, ujnintaj Andrés. Paycuna challwiris caspa jatun ch'ipata kochaman chokaycusharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Paycunaman Jesús nerkataj: —Jamuychej nokawan yachacojcunay canayquichejpaj. Kancuna challwiris canquichej. Cunanmantapachataj Diospi jap'icunancupaj runasta nokaman pusamuwanquichej. ");
INSERT INTO quhNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Chay quiquinpacha ch'ipasnincuta sakerpayarkancu. Jesuswan rerkancutaj yachacojcunan canancupaj. ");
INSERT INTO quhNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Uj chhicatawan rispataj Jesuska waj iscay waukestawan ricullarkataj. Paycuna Jacobo Juanwan carkancu. Cusca tatancu Zebedeowan barcopi ch'ipasnincuta t'irisharkancu. Jesús chay waukesta wajyarka yachacojcunan canancupaj. ");
INSERT INTO quhNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Chay quiquinpachataj barcota tatancutawan sakerpayaspa kallarerkancu Jesuswan puriyta yachacojcunan canancupaj. ");
INSERT INTO quhNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús tucuy Galilea jallp'ata purispa tantacuna-wasisnincupi yachachisharka. Sumaj willanastataj willarasharka Diospa ajllaskan chaypiña caskanta camachinanpaj. Astawanpis runas uqhupi tucuy laya onkoycunata thañichisharka. ");
INSERT INTO quhNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tucuy caru Siria jallp'apipis Jesús atiyniyoj caskanta uyarerkancu. Jesusman apamorkancutaj tucuy laya onkoyniyojcunata: nanayniyojcunata, ñac'arejcunata, supayniyojcunata, t'ucu onkoyniyojcunata, suchustawan. Jesusri tucuynincuta thañicherka. ");
INSERT INTO quhNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","May ashqha runastaj Jesusta khaticorkancu. Galilea jallp'amanta, Decápolis jallp'amanta, Jerusalén llajtamanta, Judea jallp'amanta, Jordán mayu chimpamantawan paycuna jamorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesustaj may ashqha runasta ricuspa orkoman wicharerka. Chaypi tiyaycucojtintaj yachacojcunan payman kayllaycorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Paycunatataj jatuchej yachachinasta yachachisharka: ");
INSERT INTO quhNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—May cusiskas cancu sonkoncupi Diosmanta pisiskas caskancuta khawacojcunaka. Imaraycuchus Dios paycunataka munacuywan camachin. ");
INSERT INTO quhNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","‘May cusiskas cancu jucharaycu llaquicojcunaka. Diosmin paycunataka sonkoncupi callpachaspa yanapanka. ");
INSERT INTO quhNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","‘May cusiskas cancu llamp'u sonkowan Diosta casojcuna. Paycunaka cay pachapi Diospa niskanmanjina jap'enkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","‘May cusiskas cancu Diospaj cheka causayta munajcunaka. Imaynatachus yarkhachicojcuna miqhunata munancu chayrí ch'aquichicojcuna yacuta munancu ajinata. Munaskancumanjina paycuna sajsaskas cancu. ");
INSERT INTO quhNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","‘May cusiskas cancu Diosmanjina c'acha sonkowan qhuyacojcunaka. Paycunata Dioska qhuyallankataj. ");
INSERT INTO quhNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","‘May cusiskas cancu llimphu sonkowan Diosllapaj causajcunaka. Paycunalla Dioswan cusca wiñaypaj causaconkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","‘May cusiskas cancu runasta allinyachejcunaka. Paycunalla Diospa cheka wawasnin cankancu, paypa niskanmanjina. ");
INSERT INTO quhNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","‘May cusiskas cancu Diospa ñaupakenpi chekanta causaskancuraycu muchojcunaka. Dios camachishajtin, paywan cusca cankancu. ");
INSERT INTO quhNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","‘May cusiskas canquichej runas llullacuspa sajrata rimasojtiyquichej, muchuchisojtiyquichej khasimanta c'amisojtiyquichejpis, nokata casuwaskayquichejraycu. ");
INSERT INTO quhNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Cusicuychej may jatun cusiywan. Imaraycuchus muchuskayquichejmanta Dios janaj pachapi khapajyachisonkachej sonkoyquichejpi. Ajinallatataj Diospa unay willajcunatapis runas mayta muchucherkancu manaraj kancuna cashajtiyquichej. ");
INSERT INTO quhNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","‘Runas aycha ama ismuycunanpaj cachita churancu. Ajinallatataj kancunatapis Dios churasorkachej runas sajra causayman ama tucuchiskas canancupaj. Chay cachi lak'ayapunman chayka ¿imaynatataj sumaj cachiman cutirinman? Manaña servinchu, astawanpis wijch'unallapajña purejcuna sarunancupajpis cashan. ");
INSERT INTO quhNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","‘Kancunamin Diosta mana rejsejcunapaj c'anchayjina canquichej. Orko patapi uj llajtaka manapuni pacaskachu. ");
INSERT INTO quhNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nillataj runas c'anchayta jap'ichispa wich'i uraman churancuchu. Manachayrí pataman churancu wasipi tucuy tiyacojcunata c'anchamunanpaj. ");
INSERT INTO quhNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kancunapis ajinallataj c'anchayjina canquichej cay pacha runaspaj. Ñaupakencupi c'acha cajta ruwaspa causacuychej. Ajina cachun paycunaka janaj pachapi tiyacoj Tatayquichej Diosta jatunchanancupaj. ");
INSERT INTO quhNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","‘Ama yuyaychejchu Moisespa camachiskasninta chayrí Diospa unay willajcunanpa yachachiskasnincuta chincachinayta. Mana chaycunata chincachinaypajchu jamuni manachayrí tucuyta chaymanjina junt'anaypaj. ");
INSERT INTO quhNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Niyquichej chekatapuni Diospa camachiskasninmantaka ni uj juch'uy niskallanpis chincananta. Atiyniyojllapuni cashan tucuy caj junt'acunancama. Chaymantaraj janaj pacha cay pachapis atinman chincapuyta. ");
INSERT INTO quhNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Pichari Diospa camachiskasninmanta ujnillantapis mana casunmanchu chayrí mana casuyta yachachinman chayka, aswan pisipaj khawaska canka, Dios camachin, chaypi. Pichari Diospa camachiskasninta casunman, casuyta yachachinmantaj chayka, Dios camachin, chaypi jatunpaj khawaska canka. ");
INSERT INTO quhNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Niyquichej chekatapuni fariseo partemantawan israel yachachejcunamantawan yachachiskas caskancumanjina ruwaspa chekan cayta munaskancuta. Dios camachin, chaymanka mana yaycuyta atenkancuchu. Nitaj kancunapis paycunajina caspa yaycuyta atinquichejchu. Manachayrí Diosta casuspa chekan causayniyoj caspalla Dios camachin, chaymanka yaycunquichej. ");
INSERT INTO quhNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","‘Uyarinquichej Moisés unay tatasninchejta camachiskanta: “Runata ama wañuchinquichu. Wañuchejka wañuchiskanmanta wañuchiskallataj canan tiyan”, nispa. Chayta yachanquichej. ");
INSERT INTO quhNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nokarí niyquichej sapa uj runa-masinpaj phiñaska cajta curajcuna ñac'arichinancuta. Sapa uj runa phiñacuspa runa-masinta “wampu” nejtapis aswan curajcuna juchachankancu. Phiñacuspa runa-masinta “supay apachun” nejpis, uqhu pachaman rinanpajjina cashan. ");
INSERT INTO quhNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","‘Chayraycu Diosta yupaychaj konata jaywaspaka sumajta yuyaricuy. Runa-masiyqui kanpaj phiñaska cashaskanta yuyanqui chayka, ");
INSERT INTO quhNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","chaypi konayquita sakey. Riytaj ñaupajta runa-masiyquiwan allinyacamoj. Chaymanta cutimuspa konayquita Diosman jayway. ");
INSERT INTO quhNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","‘Contrallisojniyqui juchachaj curajman pusashasojtenka ñanllataraj rishaspa uskhayta paywan allinyacuy. Allinyacuy amaña curajman jaywasunanpaj nitaj soldadoman jaywaspa carcelman wisk'achisunanpaj. ");
INSERT INTO quhNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Niyqui chekamanta mana allinyacuwaj chayka, carcelmanta manapuni llojsimunquichu tucuy phatasta cutichipunayquicama. ");
INSERT INTO quhNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","‘Uyarinquichej Moisés unay tatasninchejta camachiskanta: “Ama khenchachacuychu”. ");
INSERT INTO quhNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nokarí niyquichej warmita munapayaspa khawaj, chay runaka ñapis sonkonpi paywan khenchachacuskantaña. ");
INSERT INTO quhNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Chayraycu paña ñawiyqui ricuspa juchaman urmachisunquiman chayka, chayta orkhospa wijch'upuy. Aswan allin canman uj ñawillayqui chincaripunan amataj uqhu pacha ñac'ariyman wijch'uska canayqueka. ");
INSERT INTO quhNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Paña maquiyqui juchaman urmachisunquiman chayka, chaytapis qhuchurpacuspa wijch'upuy. Aswan allin canman maquillayqui chincapunan amataj uqhu pacha ñac'ariyman wijch'uska canayqueka. ");
INSERT INTO quhNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","‘Nillajtaj cancu: “Warmiman uj divorcio papel jaywaspa t'akanacuyka aticullan”. ");
INSERT INTO quhNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nokarí niyquichej pichari warminmanta takanacun mana waj khariwan purejtenka, warminta khenchachachiskanta. Chayjina t'akanaska warmiwan casarajpis khenchachacullantaj. ");
INSERT INTO quhNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","‘Uyarinquichej Moisés unay tatasninchejta camachiskantapis: “Ama juraychu llullacuspaka. Manachayrí Diospa ñaupakenpi niskayquimanjina ruway”. ");
INSERT INTO quhNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","35","Nokarí niyquichej: Ama ni imaraycu ni maypi Diospa sutinta okharispa juraychejchu. Imaraycuchus Dioska janaj pachapi cay pachapipis cashan. Nillataj Jerusalén llajtaj sutinta okharispa juraychejchu. Imaraycuchus paypa ajllaska llajtanmin cashan. ");
INSERT INTO quhNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Amataj ni ima sutita okharispa juraychejchu. Causayniyquichejka Diospatamin. Imaraycuchus ni uj chujchatapis umayquipi atinquichu yanayachiyta nitaj yurajyachiytaka. ");
INSERT INTO quhNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Niskayquichejka junt'anayquichejpaj cachun. Chayman waj palabraswan yapawajchej chayka, supay Satanasmantamin. ");
INSERT INTO quhNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","‘Chaywanpis uyarinquichej Moisés unay tatasninchejta camachiskanta: “Ñawiyquita orkhosojmantaka ñawinta orkhollaytaj. Quiruyquita orkhosojmanka quirunta orkhollaytaj”. ");
INSERT INTO quhNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nokarí niyquichej: Ama cutichicuychejchu sajrata ruwasojniyquichejmanka. Pillapis paña lado uyayquipi sajmasunquiman chayka, sakellay llok'e lado uyayquipiwan sajmasunanta. ");
INSERT INTO quhNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Pillapis camisayquita khechusunanpaj curajman pusasunquiman chayka, ponchoyquitawan payman kopuy. ");
INSERT INTO quhNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Pillapis k'epinta cuscan leguatajina apanayquipaj camachisunquiman chayka, uj leguatajina apapuy. ");
INSERT INTO quhNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Pillapis mañacusunquiman chayka, koriy payman. Manucusuyta munajmanpis manurillay. ");
INSERT INTO quhNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","‘Chaywanpis unayka nillajtaj cancu: “Runa-masiyquita munacuy. Chejnisoj runatataj chejniy”. ");
INSERT INTO quhNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nokarí niyquichej munacunayquichej chejnisoj runasta. Sajrata kancunapaj parlajcunaman misq'i palabraswan parlapayariychej. Chejnisojcunaman allin cajta ruwapuychej. Misq'i parlaycunawan parlaychej sajra simiwan kancunapaj parlasojcunaman. Khasillamanta kancunata ñac'arichisojcunapaj sajrata ruwasojcunapajpis Diosmanta mañapuychej. ");
INSERT INTO quhNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Chayjinata ruwanayquichej janaj pacha Dios Tatayquichejjina canayquichejpaj. Payka intita c'anchachimun c'acha runaspaj sajra runaspajpis. Parachimuntaj chekan ruwajpaj sajrata ruwajpajpis. ");
INSERT INTO quhNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Sichus munacusoj runasllata munacuwajchej chayka, Dios mana nisonkachejchu “walejta ruwanquichej”. Juchasapaspis ruwashallancu ajinataka. ");
INSERT INTO quhNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Israel llajta-masisnillayquichejta napaycuwajchej chayka, wajcunamanta niskaka ¿ima astawan allintataj ruwashanquichejrí? ¿manachu quiquillantataj ruwancu Diosta mana rejsejcunapis? ");
INSERT INTO quhNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Imaynatachus janaj pacha Dios Tatayquichej munacuywan runaspa allinnincupaj ruwan, kancunapis ajinallatataj ruwaychej, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","‘Khawaricuychej c'acha cajta ruwaskayquichejka ama runas jatunchasunallancupajka cachunchu. Manachayka janaj pacha Dios Tatayquichej uj sumaj konata mana kosonkachejchu. ");
INSERT INTO quhNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Chayraycu pisichicojcunaman imallatapis kospaka ama runasman willaspalla koychej. Puraj uya runaspis ajinata ruwancu tantacuna-wasispi plazaspipis runas paycunata jatunchanancupaj. Niyquichej chekatapuni paycunaka ruwaskancumanta tucuyta jap'iskancutaña. ");
INSERT INTO quhNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kanrí pisichicojman kospaka ama pipis koskayquitaka yachachunchu. ");
INSERT INTO quhNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ajinapi ruwaskayqui pacaska canka. Pacaypi ricoj Dios Tatayquitaj kanman ruwaskayquimanjina kosonka. ");
INSERT INTO quhNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","‘Diosmanta mañacuspa ama puraj uyajina caychejchu. Paycunaka tantacuna-wasispi jatun plazaspiwan sayaricuspa Diosmanta mañacuyta munancu runas ricunallancupaj. Niyquichej chekatapuni paycunaka ruwaskancumanta tucuyta jap'iskancutaña. ");
INSERT INTO quhNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kanrí wasiyquiman yaycuspa sapallayqui Diosmanta mañacuy. Puncuyquita wisk'aspataj pacaypi caj Dios Tatayquimanta mañacuy. Pacaypi ricoj Tatayquitaj ruwaskayquimanjina kosonka. ");
INSERT INTO quhNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","‘Diosta mana rejsejcunaka ashqha cutista khasi palabrasllawan Diosmanta mañacuncu. Kancunarí ama paycunajina mañacuychejchu. Paycuna ashqha parlaskancuwan uyariskas cayta yuyancu. ");
INSERT INTO quhNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Chayraycu ama paycunajinaka caychejchu. Dios Tatayquichejka pisichicuskayquichejta yachanña manaraj paymanta mañacushajtiyquichej. ");
INSERT INTO quhNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Chayraycu kancunaka cayjinallata mañacunayquichej tiyan: Janaj pachapi caj Tataycu, Tucuy runas sutiyquita yupaychachuncu cheka Dios caskayquiraycu. ");
INSERT INTO quhNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mayta munaycu tucuyta camachinayquita. Janaj pachapi munayniyqui ruwacushan, ajinallataj cay pachapipis ruwacuchun. ");
INSERT INTO quhNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Causanaycupaj miqhunaycuta kowaycu cunan p'unchay. ");
INSERT INTO quhNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Juchasniycuta khechuspa perdonawaycu. Nokaycumanpis juchata ruwajcunata perdonaycu, ajinallatataj. ");
INSERT INTO quhNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Callpachawaycu jatun llaquiycunapi ama juchallicunaycupaj. Astawanpis wakaychawaycu juchallichiyta munajpa atiyninmanta. Kanka wiñaypaj camachinqui. Tucuy atiyniyoj, may curajpaj, jatunchaskapis canqui. Ajina cachun. ");
INSERT INTO quhNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","‘Kancunaman juchata ruwasojcunata perdonaspa konkapuwajchej chayka, janaj pacha Dios Tatayquichejpis juchasniyquichejta perdonaspa khechusonkachej. ");
INSERT INTO quhNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kancunaman juchata ruwasuskancuta mana konkapuwajchejchu chayrí, Dios Tatayquichejpis nillataj juchasniyquichejta perdonaspa khechupusonkachejchu. ");
INSERT INTO quhNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","‘Diosta yupaychanapaj mana miqhunqui chayka, ama puraj uyasjina phutiskaska churacuychejchu. Puraj uyaska uyasnincuta ujjinayachincu runas yachanancupaj mana miqhuskancuta. Noka niyquichej chekatapuni paycunaka jap'inancu carka, chayta jap'iskancutaña. ");
INSERT INTO quhNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kanrí mana miqhuspa Diosta yupaychanayquipaj umayquita ñajch'aycuy, uyayquita mayllacuy, cusiskataj cay. ");
INSERT INTO quhNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ajinapi runas mana miqhuskayquita mana reparankancuchu. Pacaypi caj Dios Tatayquirí yachan. Paytaj pacaypi ricuspa ruwaskayquimanjina kosonka. ");
INSERT INTO quhNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","‘Cay pachapi khapaj capuycunata amaña chhicata kancunallapaj jallch'acuychejchu. Caypi chaytaka thutas thutancu, carcomi tucuchin, suwaspis yaycuspa suwancu. ");
INSERT INTO quhNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Manachayrí tucuyta ruwaychej Diosllata cusichinayquichejpaj. Ajinapi janaj pachapi wiñay khapaj cajta jallch'acunquichej. Jakaypi thutas mana thutancuchu, nitaj carcomi tucuchinchu. Nillataj suwas yaycuspa suwancuchu. ");
INSERT INTO quhNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Imaraycuchus maypichá munaska khapajniyquichej cashan chaypipuni yuyayniyquichejpis cashan. ");
INSERT INTO quhNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","‘Ñawiyqui c'anchayllawan ricun cuerpopaj. Ajinallatataj sonkoyquipis Diospa c'anchayninwan reparan. Sichus llimphu sonkoyoj canqui chayka, tucuy causayniyqui c'anchayniyojmin. ");
INSERT INTO quhNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Sajra sonkoyoj canqui, chayrí tucuy causayniyqui lakhapachamin. Chayjina lakhamanta astawanka mana canchu. ");
INSERT INTO quhNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","‘Ni pi iscay camachejcunata casuyta atinchu. Imaraycuchus ujllata munaconka wajtataj chejniconka. Ujman c'ascaconka wajtataj khesachanka. Cheka Diostawan khapaj capuytawan manapuni casuyta atinquichu. ");
INSERT INTO quhNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","‘Chayraycu niyquichej amaña anchata llaquicuychejchu miqhunamanta nitaj ujyanamanta causanayquichejpajka. Nitaj llaquicuychejchu cuerpoyquichejmanta imawanchus p'achallicunayquichejtaka. Causayniyquichejka ¿manachu miqhunamantapis astawan sumajmin? Chayrí cuerponchejpis ¿manachu p'achamantapis astawan sumajmin? ");
INSERT INTO quhNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Sumajta reparaychej phawaj p'iskosmanta. Paycunaka mana tarpuncuchu nitaj ruthuncuchu. Nitaj pirwasniyojchu cancu miqhunancuta tantanancupaj. Janaj pacha Dios Tatayquichejmin paycunata miqhuchin. Kancunaka p'iskosmanta niskaka ¿manachu Diospajka astawan sumaj canquichej? ");
INSERT INTO quhNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Astawan causayta munaspa, llaquicuspapis ¿uj chhicatawan causayta atiwajchejchu? ");
INSERT INTO quhNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","‘¿Imaraycutaj p'achamantapis phuticunquichejrí? Sumajta reparaychej q'ita t'icasmanta, imaynatachus wiñancu. T'icaska mana llanc'ancuchu nitaj phushcancupischu. ");
INSERT INTO quhNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nokarí niyquichej Salomonka may khapaj camachej caskanta. Chaywanpis payka ni cay chhica c'achitu t'icasjinallapis p'achallicorkachu. ");
INSERT INTO quhNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Cunan p'unchay koraka pampapi khallallashan. K'ayataj runas hornopi ruphachenkancu. Chaywanpis Dios churan chay korata. Payka kancunamanta may astawanraj yuyan. Chayraycu ¿manachu pay kosonkachej causanayquichejpaj? ¡Paypi jap'icuskayquichejka ancha pisi! ");
INSERT INTO quhNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Chayraycu llaquicuspa ama niychejchu: “¿Imatataj miqhusun? ¿Imatataj ujyasun? ¿Imawantaj p'achallicusun?” ");
INSERT INTO quhNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tucuy chaycunallata Diosta mana rejsejcunaka mayta munashancu. Janaj pacha Dios Tatayquichej yachanña tucuy cay imasmanta causanayquichejpaj pisichicuskayquichejtaka. ");
INSERT INTO quhNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kancunarí tucuy atiskayquichejwan llanc'aychej ñaupajta Dios tucuyta camachinanpaj. Ajinallataj Diospa munayninmanjina chekanta causaychej. Chanta payka cay pachapi causanayquichejpaj tucuy imata yapasonkachej. ");
INSERT INTO quhNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Chayraycu k'ayamanta yuyaspa ama llaquicuychejchu. K'aya phuticuycunaka k'ayallapaj cachun. ");
INSERT INTO quhNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","‘Ama waj runata juchachaychejchu mana allinta yachaspaka. Ajinapi kancuna manallataj juchachaskaschu canquichej manacajmantaka. ");
INSERT INTO quhNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","‘Imaynatachus runa-masisniyquichejta khawanquichej chayjinallatataj Dios kancunata khawasonkachej. Ima chhicantachus wajcunaman konquichej chay chhicamanjinallataj Dios kancunaman kosonkachej. ");
INSERT INTO quhNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","‘Uj jatun curcujina kanpa jatun pantaskayquita mana reparacuspaka ¿imaynatataj uj ichhu k'opajina hermanoyquej juch'uy pantaskanta khawaranquirí? ");
INSERT INTO quhNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Quiquin ñawiyquipitaj jatun curcu cashajtin ¿imaynatataj hermanoyquita atinqui niytarí: “Hermanóy, sakellaway ichhu k'opata ñawiyquimanta orkhosunayta?” nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Puraj uya, chay curcutaraj ñawiyquimanta orkhonqui. Chanta aswan sut'ita ricunqui juch'uy k'opata hermanoyquejpa ñawinmanta orkhonayquipajka. ");
INSERT INTO quhNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","‘Dios kosuskayquichejtaka ama koychejchu phiña sajra alkosjina runasmanka, janch'ojtincu kancunata ama qhanispa tucuchisunancupaj. Nitaj millay qhuchijina causaj runasmanka Dios kosuskayquichejtapis wijch'uychejchu ama saruycunancupaj mana cajtajina. ");
INSERT INTO quhNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","‘Diosmanta mañacullaychejpuni, payka kosonkachejtaj. Masc'aychejpuni, Dioska tarichisonkachejtaj. Wajyallaychejpuni Diostaj puncuta kancunaman quicharisonkachej. ");
INSERT INTO quhNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Chekamanta mana sakespa mañacojka jap'enkapuni masc'ajtaj tarenkapuni. Mana sakespa wajyajmanpis puncoka quichariconkapuni. ");
INSERT INTO quhNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","‘Astawanpis, wawan t'antata mañacojtin ¿pitaj, kancuna tatasmanta, uj rumita jaywanman? ");
INSERT INTO quhNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Chayrí wawan challwata mañacojtin ¿uj cataritachu jaywanman? ");
INSERT INTO quhNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kancuna juchasapa runaslla cashaspapis wawasniyquichejmanka allin imastapuni koyta yachanquichej. May astawanraj janaj pacha Dios Tatayquichejka sumaj imasta konka paymanta mañacojmanka. ");
INSERT INTO quhNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","‘Chayraycu imaynatachá munanquichej runas kancunaman ruwanancuta ajinallatataj kancunapis paycunaman ruwaychej. Palabranpi Dioska chayta ruwananchejta camachin. ");
INSERT INTO quhNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","‘Wiñay causayman chayrí wiñay wañuyman kancuna yaycuyta ajllanayquichej tiyan. Imaraycuchus wiñay wañuyman puncoka jatunmin, chayman chayaj ñanpis. Ashqhastaj chaynejta yaycuncu. Wiñay causayman yaycuchej puncurí c'ullcumin, chayman chayanapaj ñanpis c'ullcullataj. Pisistaj Diospa munayninta ruwaspa wiñay causayman yaycuncu. Chayraycu c'ullcu puncunejta yaycuychej. ");
INSERT INTO quhNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","‘Khawacuychej llulla yachachejcunamanta. Chaycunaka pantachisunayquichejpaj jamuncu. Paycunaka ovejaman rijch'acojjinalla cancu, sonkosnincupirí yarkhaska atojcunajina cancu. ");
INSERT INTO quhNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Sach'astaka pokoynincumanta rejsinquichej. Ajinallatataj paycunataka ruwaskancumanta atinquichej rejsiyta. Ni jayc'aj uvaska qhishcarara sach'itamanta pallacunchu. Nitaj higoska pallacunchu qhishca sach'asmantapis. ");
INSERT INTO quhNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ajinata tucuy allin sach'aka sumaj pokoyta pokon. Uj mana allin sach'arí mana sumaj pokoyniyojllataj. ");
INSERT INTO quhNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Allin sach'aka mana jayataka pokonchu. Nitaj mana allin sach'apis allin misq'itaka pokonchu. ");
INSERT INTO quhNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tucuy mana allinta pokoj sach'ataka runas c'utuncu ninamantaj wijch'uncu. ");
INSERT INTO quhNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Chayraycu kancunapis runastaka ruwaskasnincumanta rejsinquichej. ");
INSERT INTO quhNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","‘Simillancuwan “Ay, Señorníy, Tatáy”, nejcuna Dios camachin, chayman mana yayconkancuchu. Manachayka janaj pachapi tiyacoj Dios Tataypa munayninta ruwajcunalla paypaman yayconkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Cutimojtiy, chay p'unchay ashqhas niwankancu: “Ay, Señorníy, Tatáy ¿manachu willanasniyquita willararkaycu? ¿Manachu atiyniyquiwan runasmanta supaycunata kharkorkaycu? ¿Manachu ashqha t'ucuna ruwanastapis atiyniyquiwan ruwarkaycu?” nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Chantarí nokataj tucuypa ñaupakencupi paycunaman sut'inchasaj: “Kancunataka ni jayc'aj rejserkayquichejchu. Mana nokajpatachu canquichej. Kancuna, sajrata ruwajcuna ripuychej nokamanta”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","‘Chayraycu cay niskasniyta uyarispa sumajta casojlla, nokapajka sumaj yuyayniyoj runajina cashan. Payka sinch'i rumi patapi wasichaj runajina cashan. ");
INSERT INTO quhNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Paraka sinch'ita jich'acamorka. Mayustaj ashqha yacuwan chayamorkancu. Wayrapis jatun callpawan wayraspa chay wasiman komorka. Wasiri mana urmarkachu sinch'i rumipi wasichaska caskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Cay niskasniyta uyarispa tucuy mana casojrí nokapajka mana yuyayniyoj runajina cashan. T'iyupi wasinta wasichaj runajina cashan. ");
INSERT INTO quhNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Sinch'ita paraka jich'acamorka. Mayustaj ashqha yacuwan chayamorkancu. Wayrapis may callpawan chay wasiman komorka. Wasitaj manchayta urmarka. ");
INSERT INTO quhNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesús cay imasmanta parlayta tucorka. Ashqha runastaj paypa yachachiskanmanta mayta t'ucorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Imaraycuchus pay Diospa atiyninwan yachachisharka, manataj paycunaj yachachejnincujinallachu. ");
INSERT INTO quhNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesús orkomanta uraycamushajtin ashqha runas paypa khepanta jamusharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ajinapitaj uj manchay chimpa chimpa lepra onkoyniyoj runa Jesusman kayllaycorka. Konkoricuspataj payta yupaychananpaj, mañacorka: —Tucuy atiyniyoj canqui, Señor. Munanqui chayka, llimphuchawaspa atinqui thañichiwayta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesustaj maquinwan payta llanqhaycuspa nerka: —Munani. Thañiskaña canqui, —nispa. Chay quiquinpachataj thañiska carka lepra onkoyninmanta. ");
INSERT INTO quhNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesustaj payta camacherka: —Uyariway. Ama pimanpis cay imasmanta willanquichu. Manachayrí chekanta riy khawachicamuytaj yupaychana-wasipi ruwanayojwan. Moisespa camachiskanmanjina konatataj jaywamuy. Chay jaywaskayquiwan runas yachankancu thañiska caskayquita. ");
INSERT INTO quhNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesús Capernaum llajtaman yaycushajtin uj camachej payman jamorka. Payka pachaj romano soldadosta camacherka. Chay camachej Jesusmanta tucuy sonkowan mañacuspa ");
INSERT INTO quhNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","nerkataj: —Señor, uywaskay wasiypi suchu onkoywan siriska cashan. Mayta ñac'arishan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesustaj payman nerka: —Wasiyquiman noka jampej jamusaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Cutichispa chay camachej nerka: —Señor, arí, noka mana wasiyman yaycunayquipajjinachu cani. Astawanka cayllamanta niy, uywaskaytaj thañicaponka. ");
INSERT INTO quhNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nokajtapis cancu curaj camachiwajcuna. Chaywanpis nokajta callancutaj soldadosniy. Paycuna casuwancutaj camachiskayta. Ujta nini: “Riy”. Rintaj. Wajta nini: “Jamuy”. Jamuntaj. Uywaskayta nini: “Cayta ruway”. Ruwallantaj. ");
INSERT INTO quhNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesuska ajinata nejta uyarispa t'ucorka. Payta khatejcunata nerkataj: —Chekatapuni Diospa runasnin uqhupipis nipuni chayjina niskasniyta jap'icoj runataka tarerkanichu. ");
INSERT INTO quhNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Astawanpis niyquichej ashqha runas tucuy cay pachamanta jamunancuta. Paycunaka Dios camachin, chaypi cusiywan miqhonkancu cusca jatun tatasninchej —Abrahamwan, Isaacwan Jacobwanpis. ");
INSERT INTO quhNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Waquincunarí pantaspa yuyancu Dios camachin, chayman yaycuyta. Paycunaka chaymanta jawapi lakhaman wijch'uskas cankancu. Jakaypitaj khaparispa phutiywan wakankancu. Nanaywan quirusnincuta c'aruconkancu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Chanta Jesús camachejman nerka: —Ripullay wasiyquiman. Diospi jap'icuskayquimanjina ruwaska cachun. Camachejpa runaj uywaskantaj chay niskantawanpacha thañicaporka. ");
INSERT INTO quhNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Khepanta Jesús Pedroj wasinman rispa Pedroj warminpa mamanta ricorka. Pay sinch'i k'oñi onkoywan camapi siricusharka. ");
INSERT INTO quhNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesustaj onkoskaj maquinta llanqharispa k'oñi onkoyninmanta thañicherka. Thañiska warmitaj jataricuspa miqhunata payman jaywarka. ");
INSERT INTO quhNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ch'isiyaycuytari ashqha supayniyojcunata Jesusman runas pusamorkancu. Paytaj ujta parlaskallanwan chay supaycunata kharkorka. Tucuy onkoskastataj thañicherka. ");
INSERT INTO quhNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ajinapi junt'acorka Diospa willajnin Isaiaspa niskan Jesusmanta: “Payka khechupuwarkanchej onkoyninchejcunata nanayninchejcunatapis”. ");
INSERT INTO quhNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesustaj ashqha runasta muyuyninpi ricorka. Chayraycu camacherka yachacojcunanta kocha chimpaman rinancuta. ");
INSERT INTO quhNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Israel yachachejcunamantataj uj yachaysapa Jesusman kayllaycuspa nerka: —Yachachiwajníy, kanwan cusca risaj maymanchá rinqui, chayman. ");
INSERT INTO quhNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesusri payman cuticherka: —Atojcuna jusc'usniyoj cancu. Phawashaj p'iskospis thapasniyoj cancu. Noka, Diospa cachamuska Runanpajrí mana canchu umayta samarichinallaypajpis, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yachachiskasninmanta ujnin caj nillarkataj: —Señorníy, sakellawayraj tatayta p'ampamunayta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesusrí cuticherka: —Kanka nokallawanpuni puriy yachacojniy canayquipaj. Wañuskacuna wañuskasnincutaka p'ampamuchuncu. ");
INSERT INTO quhNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Chaymanta Jesuska barcoman yaycorka, kocha chimpaman rinancupaj. Yachacojcunan paywan risharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ujllata jatun kochapi manchay sinch'i wayrawan yacoka mayta okharicorka. Yacoka callpawan khallacamuspa barcota chincaycuchinayasharkaña. Jesusrí puñucushallarkapuni. ");
INSERT INTO quhNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Yachacojcunantaj payman kayllaycamuspa rijch'aricherkancu. Mancharicuspataj, nerkancu: —¡Señorníy, yanapawaycu! ¡Chincaycunayashanchejña! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesustaj paycunaman c'amerka: —¿Imaraycutaj manchariskas chujchushanquichejrí? ¡Ancha pisita Diospi jap'icunquichej! —nispa. Chanta payka jataricuspa wayrata kochatawan c'amerka. Chay quiquinpacha wayrapis yacupis payta casuspa c'achata thañicaporkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Paywan rejcunataj maytapuni t'ucuspa ninacusharkancu: —¿Ima runataj payrí? ¡Wayrapis kochapis payta casuncu! ");
INSERT INTO quhNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesuska rispataj kocha chimpaman chayarka. Chayri Gadarenospa jallp'ancu carka. Ajinapitaj iscay supayniyoj runas aya p'ampanasmanta llojsimorkancu. Jesustataj taripaycorkancu. Paycunaka manchay phiñas caskancuraycu ni pipis chay ñannejta purejchu. ");
INSERT INTO quhNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Chay supayniyoj runastaj khaparispa nerkancu: —¡C'ata Diospa Wawan, Jesús, imaman chapucuwanqui! ¿Manaraj ñac'arinaycu cashajtinñachu ñac'arichej jamuwaycu? ");
INSERT INTO quhNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Paycunamanta carunejpitaj ashqha qhuchis miqhusharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Supaycunataj Jesusta mayta niricusharkancu: —Cay runasmanta kharkowasajcu chayka, jakay qhuchisman cachawaycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesustaj paycunata nerka: —Riychej. Chanta supaycunaka chay iscay runasmanta llojsispa qhuchisman yaycorkancu. Ajinamanta qhuchis tucuynincu kakamanta kochaman ch'ulticuspa yacupi wañorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Qhuchi michejcunari aykecorkancu manchariskas. Llajtaman chayaspataj tucuy imata chay supayniyoj runasmantapis willamorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Llajtantinmantataj runas Jesuswan tincoj llojsimorkancu. Payta ricuspataj mayta mañacorkancu jallp'ancumanta ripunanta. ");
INSERT INTO quhNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesuska barcoman yaycuspa ujnin kocha chimpaman rerka. Chaymantataj llajtanman chayarka. ");
INSERT INTO quhNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ajinallaman uj mana cuyurej suchu runata siriskata callapunpi payman wantumusharkancu. Jesustaj reparaspa Diospi chekata jap'icuskancuta chay runata nerka: —Wawáy, ama manchachicuychu. Juchasniyqui khechuskasña cancu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Waquin yachaysapacuna sonkoncupi nisharkancu: “Cay runaka Dios caskanmanjina parlaspa payta phiñachishan”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesustaj yuyaskancuta yachaspa nerka: —¿Imaraycutaj chayjina sajrata sonkoyquichejpi yuyashanquichejrí? ");
INSERT INTO quhNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Cay runaman nejtiy “juchasniyqui khechuskaña” nispaka, mana ricunquichejchu chekachus manachus caskantaka. Astawanrí cay mana cuyurej runata jatarichiyman chayka, ricuwajchej. ");
INSERT INTO quhNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Noka, Diospa cachaska Runan caspa, cay pachapi atiyniyoj cani juchasta khechunaypaj. Chayta yachanayquichejpaj cay mana cuyurej runata nini: Jataricuy. Callapuyquita okharicapuspa ripuy wasiyquiman. ");
INSERT INTO quhNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Runataj jataricuspa wasinman riporka. ");
INSERT INTO quhNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ashqha runasri chayta ricuspa manchachicorkancu. Diosta yupaycharkancutaj chayjina atiyta runasman koskanmanta. ");
INSERT INTO quhNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesuska chaymanta ripuspa Mateo sutiyoj runata ricorka. Mateori vendejcunamanta cobrana wasipi tiyacusharka. Jesustaj payta nerka: —Yachacojníy cay, —nispa. Jatarispataj Jesusta khaticorka. ");
INSERT INTO quhNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ajinaka Jesús yachacojcunanwan Mateoj wasinpi miqhusharka. Chay wasimantaj ashqha impuesto jap'ejcuna, juchasapaspaj khawaska runaswan jamorkancu paycunawan miqhoj. ");
INSERT INTO quhNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Chayta ricuspataj fariseo partemanta runas Jesuspa yachacojcunanta taporkancu: —¿Imaraycutaj yachachisojniyquichejka impuesto jap'ejcunawan juchasapaswan cusca miqhunrí? ");
INSERT INTO quhNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesusrí chayta uyarispa nerka: —Onkoska runaslla medicotaka munancu manataj sano runaska. ");
INSERT INTO quhNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kancunari sumajta yachamuychej Dios cayta niskanta: “Runas qhuyanacunancoka astawan cusichiwan uywa wañuska jaywanasmanta niskaka”. Juchasapasta wajyaj jamorkani paycuna sajra ruwaskasnincuta sakespa Diosman cutirinancupaj. Manataj jamorkanichu chekan cajcunata wajyaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Chanta Juanpa yachacojcunan Jesusman chimpaycorkancu. Taporkancutaj: —Nokaycu, fariseocunawan ayunaycu ajllaska p'unchaycunapi yachacuskaycumanjina. Kanpa yachacojcunayquirí ¿imaraycutaj mana ayunancuchu paycunajinata? ");
INSERT INTO quhNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesusrí paycunaman cuticherka: —¿Casamientoman wajyaskacunaka phutiska uyasllachu cancuman casaracoj runa paycunawan cashajtin? Waj p'unchaycuna jamojtincurí paycunamanta casaracoj runa khechuska canka. Chaypacha yachacojcunay phutiywan mana miqhonkancuchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Cay quiquinchanawan mosoj yachachiyninmanta parlarka: —Ni pipis uj mosoj remiendota uj mauc'a p'achaman siraycunmanchu. Chayta ruwanman chayka, mosoj p'achamanta remiendoka k'entispa aswan jatunta lliq'irparinman mauc'a p'achataka. ");
INSERT INTO quhNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Manallataj pipis mosoj pokoshaj vinota mauc'a karasman churanchu. Chayta ruwanman chayka, pokoshaj vinoka phatarparichinman mauc'a karastaka. Ajinapitaj karas lliq'iycucunman vinotaj jich'acuspa chincapunman. Chayraycu mosoj vinotaka mosoj karasman churana tiyan. Ajinamanta iscaynincu allin wakaychaskas cancu, —nispa yachacherka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesús cay imasmanta parlashajtillanraj uj curaj runa payman kayllaycorka. Jesusta yupaychaspataj nerka: —Tatáy, warmi waway cunallan wañupun. Astawanpis payman maquiyquita churanayquipaj jamuy. Wawayka chaywan causarenka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ajinataj Jesuska rerka curaj runawan cusca. Yachacojcunanpis Jesuswan rerkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Rishajtincutaj uj warmi Jesusman kayllaycorka. Payka chunca iscayniyoj watastaña yawar apay onkoywan carka. Khepanmanta jamuspataj Jesuspa ponchonpa t'icasninta jap'irerka. ");
INSERT INTO quhNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ajinata ruwarka sonkonpi niskanraycu: “P'achallantapis llanqharisaj chayka, thañicapusaj”. ");
INSERT INTO quhNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesusrí cutiricuspa warmita khawarerka. Nerkataj: —Cusicuy, mamáy. Diospi jap'icuskayquiraycu thañiska canqui. Warmeka chaypachita sumajta thañicaporka. ");
INSERT INTO quhNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jesustaj curaj runaj wasinman chayamuspa p'ampanapaj tocajcunata ricorka. Ashqha ch'ajwashaj runastapis ricuspataj ");
INSERT INTO quhNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","nerka: —Ithiricuychej. Imillitaka mana wañuporkachu. Manachayrí puñushallan, —nispa. Runastaj Jesusta asipayarkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jesuska paycunata jawaman llojsichispa wasiman yaycorka. Imillitatataj maquinmanta jap'ispa causaricherka. ");
INSERT INTO quhNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Chay ruwaskanmantari tucuynejpi runas yacharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesús chaymanta ripushajtintaj iscay ciego runas paypa khepanta khaterkancu. Khaparispa nerkancu: —Diospa ajllaskan Cristo, qhuyacuwaycu. ");
INSERT INTO quhNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesuska wasiman yaycorka. Chaymantataj ciego runaska payman kayllaycorkancu. Jesusri paycunata tapurerka: —¿Tucuy sonkowanchu creenquichej kancunata thañichiyta atinayta? Paycunataj cuticherkancu: —Arí, tucuy atiyniyoj Señor, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Chanta Jesuska ñawisnincuta llanqhaycuspa nerka: —Diospi jap'icuskayquichejmanjina ricuychej. ");
INSERT INTO quhNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ciegostaj ricorkancu. Chaymanta Jesús sinch'ita paycunata nerka: —Ama ni pimanpis willaychejchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Paycunarí Jesuspa niskanta mana casorkancuchu. Astawanpis tucuy chay jallp'anejpi Jesusmanta willarkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Paycuna llojsishajtincutaj runas Jesusman supayniyoj uj upa runata pusamorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesusri supayta kharkorka. Chay quiquinpachataj upaka parlarerka. Chaypi caj ashqha runastaj t'ucusharkancu: —¡Ni jayc'ajpis cayjina imaska Israel jallp'api ricucorkachu! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","T'akacoj fariseocunarí nerkancu: —Chay runaka supaycunaj curajnincoj atiyninwan supaycunata kharkon, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesuska tucuy llajtasta ranchostawan purerka. Tantacuna-wasisnincupitaj yachachisharka. Willarasharka sumaj willanastapis Diospa ajllaskan cay pachapi caskanta camachinanpaj. Tucuy laya onkoyniyojcunatapis nanayniyojcunatapis thañicherka. ");
INSERT INTO quhNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Chanta ashqha runasta ricuspa paycunata may munacuywan qhuyacorka. Jesuspa sonkon nanarka paycunata llaquiywan sayc'uskasta llauchhuyaskastataj ricuspa. Imaraycuchus paycunaka mana michejniyoj ovejasjina carkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Chantataj yachacojcunanman nerka: —Cheka Diosmanta chincapushaj runaska uj jatun trigo chajrajina cancu. Ashqha trigo cashan ruthunapajjina pokoskaña. Ruthojcunarí pisislla cancu. ");
INSERT INTO quhNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Chayraycu tucuy atiyniyoj Diosmanta mañacuychej llanc'ajcunata uskhayta chajranman cachamunanta. Caytaka paymin camachin. ");
INSERT INTO quhNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesustaj chunca iscayniyoj yachacojcunanta payman wajyarka. Chantataj paycunaman atiyta korka. Paycunaka chay atiywan supaycunata kharkonancu carka. Tucuy laya onkoyniyojcunatataj tucuy mana allin caytawanpis thañichinancu carka. ");
INSERT INTO quhNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jesuspa chunca iscayniyoj cachasnincoj sutisnincoka caycuna cancu: Ñaupaj cajka Simonmin, paytari Pedrota Jesús suticharka, wauken Andreswan, Jacobowan wauken Juanwan. Paycuna iscaynin Zebedeoj wawasnin cancu. ");
INSERT INTO quhNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomewan; Tomás, impuesto jap'ej Mateowan; Jacobo, Alfeoj wawan Tadeowan. Payka Lebeo niskapis. ");
INSERT INTO quhNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón cananista partemanta, Judás Iscariotewan. Payka khepata Jesusta churanacojcunanman jaywaycorka. ");
INSERT INTO quhNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Chay chunca iscayniyoj ajllaskasninta Jesús cacharka, cayjinata camachispa: —Ama Samaria llajtasman yaycuychejchu nitaj waj runasmanpis riychejchu. ");
INSERT INTO quhNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Manachayrí llajta-masisninchejllaman riychej. Paycunaka Diospa ajllaskan israelcuna ayllumanta chincaska ovejasjina cancu. ");
INSERT INTO quhNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Rispataj willaraychej: Cunanka Dios caypiña cashan camachinanpaj. ");
INSERT INTO quhNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Onkoskasta thañichiychej. Manchay lepra onkoyniyojcunata llimphuchaspa thañichimuychej. Wañuskacunata causarichimuychej. Runasmanta supaycunata kharkoychej. Tucuy chayta ruwanayquichejpaj atiyta khasillamanta korkayquichej. Chayraycu kancunapis runaspaj chay atiywan khasillamanta ruwamuychej. ");
INSERT INTO quhNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","‘Ñanniyquichejpaj kolketa ama waquichicuychejchu. ");
INSERT INTO quhNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Puriyniyquichejpaj ama k'epichacuychejchu imatapis. Nitaj iscay camisasta nitaj ojot'asta nillataj c'aspita purinayquichejpaj apaychejchu. Imaraycuchus llanc'ajcunaman causanancupajka konancupuni tiyan. ");
INSERT INTO quhNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","‘Mayken llajtaman ranchomanpis yaycuspaka tapucuychej maykenchus chaypi c'acha runa caskanta. Ajinapi yachanquichej piwanchus samarinayquichejta. Paypa wasinpitaj caricuychej waj llajtaman rinayquichejcama. ");
INSERT INTO quhNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Wasinman yaycuspataj chaypi tiyacojcunata napaycuychej: “Dioswan allinyaska cacuychej”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Chaypi tiyacojcuna napaycuskayquichejta jap'icuncuman chayka, Dioswan allinyaskas cankancu. Mana jap'icuncumanchu chayrí, kancunaman cutimpusonkachej. ");
INSERT INTO quhNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","‘Pillapis mana wajyarisunquichejmanchu nitaj niskasniyquichejta uyarinmanchu chayka, paycunata sakerparipuychej. Chaymanta llojsipuspa chaquisniyquichejmanta jallp'ancutapis thalarpariychej. Chaywan runas yachankancu Diosmanta willanasta khesachaskancuta. ");
INSERT INTO quhNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Chekata niyquichej: Chay llajtapi tiyacojcunata Dioska astawan ñac'arichenka c'ajaj phiñacuyninwan. Sodoma llajtayojcuna Gomorra llajtayojcunatawanka pisitaraj ñac'arichenka paycunamanta niskaka. ");
INSERT INTO quhNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","‘Reparaychej noka cachashayquichej mana michejniyoj ovejastajina sajra atojcunaj chaupincuman. Chayraycu kancunaka sumaj yuyayniyoj llamp'u sonkoyojtaj canayquichej tiyan. ");
INSERT INTO quhNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Khawacuychejpuni sajra runasmanta. Imaraycuchus curajcunaman jaywaycusonkachej. Tantacuna-wasisnincupitaj c'aspiswan wajtasonkachej. ");
INSERT INTO quhNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Yachacojcunay caskayquichejraycu curajcunaman jatun camachejcunamanpis pusasonkachej. Ajinapi israelcunaman Diosta mana rejsejcunamanpis nokamanta willaranquichej. ");
INSERT INTO quhNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Curajcunaman jaywasojtiyquichejka imatachus chayrí imaynatachus ninayquichejmanta yuyaspa ama manchachicuychejchu. Dios chay quiquinpacha sonkoyquichejman churanka imatachus ninayquichejta. ");
INSERT INTO quhNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Imaraycuchus mana sapallayquichejchu parlanquichej. Manachayrí Santo Espíritu Tatayquichejmanta kancunanejta parlanka. ");
INSERT INTO quhNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","‘Uj waukeka waukenta jaywayconka wañuchiska cananpaj. Uj tatapis wawanta wañuchiska cananpaj jaywayconka. Wawaspis tatasnincoj contrancupi jataricullankancutaj wañuchichinancupaj. ");
INSERT INTO quhNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nokamanta willaraskayquichejraycu tucuy runas kancunata chejnicusonkachejpuni. Tucucunancama nokapi confiaspallapuni muchojrí wiñay causayniyoj canka. ");
INSERT INTO quhNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Uj llajtapi nac'arichisojtiyquichejka waj llajtaman aykecuychej. Noka, Diospa cachaska Runan, niyquichej chekatapuni manaraj tucuy Israel llajtasta rishajtiyquichej cutimunayta. ");
INSERT INTO quhNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","‘Yachacojka mana curajchu yachachejninmantaka. Camachipis mana curajchu camachejmantaka. ");
INSERT INTO quhNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Yachacojka yachachejninjinallataj caytawan cusicunanka allinmin. Camachipis camachejninjinallataj cananka allinmin. Noka wasiyojta sutichawarkancu “curaj supay”, nispa chayka, kancuna wasiypi tiyacojcunallataka aswan sinch'itaraj ñac'arichisonkachej. ");
INSERT INTO quhNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","‘Runataka ama manchachicuychejchu. Arí, tucuy sumaj khataska cajpis k'ala khataraska canka. Tucuy pacaska cajpis sut'inchaska callankataj. ");
INSERT INTO quhNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Lakhapi parlasuskayquichejtaka sut'ita tucuypa ñaupakenpi willaychej. Ningrillayquichejpi willasuskayquichejtapis ashqha runasman khaparispa willaraychej. ");
INSERT INTO quhNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Cuerpollata wañuchejcunataka ama manchachicuychejchu. Paycunaka wiñay causayta khechusuyta mana atincuchu. Astawanrí Diosta manchachicuychej. Paylla causayta khechuspa uqhu pacha ninaman wijch'uycuchiyta atin. ");
INSERT INTO quhNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","‘¿Manachu runas iscay phichitanca p'isketosta miqhunancupaj vendencu uj phatallapi? Chaywanpis ni ujllapis wañunchu Dios Tatayquichej mana munajtenka. ");
INSERT INTO quhNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Umayquichejpi chujchaspis ujmanta uj yupaskas cancu. ");
INSERT INTO quhNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Dios Tatayquichej khawashasuskayquichejraycu ama manchachicuychejchu. Kancuna ashqha phichitancasmanta niskapis astawan yuyanarajmin canquichej Diospajka. ");
INSERT INTO quhNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","‘Pichari runaspa ñaupakencupi sut'ita willan noka paypa camachejnin caskayta chayka, nokapis janaj pacha Dios Tatayman willallasajtaj payka nokaj camachiymin caskanta. ");
INSERT INTO quhNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pichari runasman nokamanta willanman mana camachejninchu caskayta chayka, paymanta nokapis janaj pacha Dios Tatayman willallasajtaj mana camachiychu caskanta. ");
INSERT INTO quhNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","‘Ama yuyaychejchu runas juchallapipuni allillanta causacunancupaj jamuskaytaka. Manachayrí juchaj contranpi jamuskayraycu runaska paycunapura sinch'ita t'akanaconkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nokata casuwaskancuraycu khari wawaka tatanwan t'akanacun. Warmi wawa mamanpa contranpi, khachunapis suegranwan t'akanacun. ");
INSERT INTO quhNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Wasinpi tiyacojcunallataj paytaka nokaraycu sinch'ita chejniconkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","‘Pillapis tatanta chayrí mamanta nokamanta astawan munacojka mana yachacojniy cananpajjinachu cashan. Runa nokata astawan munacunawan tiyan warmi wawanmanta chayrí khari wawanmanta niskaka. Manachayka mana yachacojniy cananpajjinachu cashan. ");
INSERT INTO quhNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Runaka munayninta sakespa nokata casunawanpuni tiyan nokaraycu wañunancamapis. Mana casuwanpuni chayrí mana yachacojniy cananpajjinachu cashan. ");
INSERT INTO quhNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Causayninta payllapaj wakaychacuyta munajka mana wiñay causayniyojchu canka. Nokata casuwaskanraycu causayninta chincananta sakejka wiñay causayniyoj canka. ");
INSERT INTO quhNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","‘Pillapis kancunata wajyacun yachacojcunay caskayquichejraycu, nokatapis wajyacuwan. Pillapis nokata wajyacuwan, camachiwajniy Dios Tataytapis wajyacullantaj. ");
INSERT INTO quhNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Diospa willajninta c'achata wajyarejka willaj caskanraycu, willajpa jap'inantajinallataj Diosmanta jap'enka. Chekan ruwaj runata wajyarejka, chekan ruwaj caskanraycu chay ruwajpa jap'inantajinallataj Diosmanta jap'enka. ");
INSERT INTO quhNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Yachacojcunay pisipaj khawaskaspuni cashancu. Pichari paycunamanta ujninman uj chhica yacullatapis jaywarinman yachacojniy caskanraycu, chekatapuni payka uj sumaj konata jap'enka Diosmanta, —nispa yachacherka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesuska chunca iscayniyoj yachacojcunanta ruwanancuta yachacherka. Chayta tucuytawantaj llojserka chay kayllapi llajtasman yachachej willarajtaj. ");
INSERT INTO quhNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juanrí wisk'aska cashaspa uyarerka Cristoj ruwaskasninmanta. Chayraycu yachacojcunanta Jesusman tapunancupaj cacharka. Ajinapi Jesusta taporkancu: ");
INSERT INTO quhNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","—¿Kanchu Diospa niskanmanjina jamoj, Cristoka canqui? chayrí ¿wajtachu suyallasajcupuni? ");
INSERT INTO quhNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesusri paycunaman cutichispa nerka: —Cay uyarishaskayquichejta ricushaskayquichejtawan cutispa Juanman willamuychej. ");
INSERT INTO quhNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ciegos ricushancuña. Suchuspis purishancuña. Lepra onkoyniyoj runaspis thañiskasña cashancu. Lojt'uspis uyarishancuña, wañuska runastaj causarichiskasña cashancu. Sumaj willanasta wajcha runaspis uyarishallancu. ");
INSERT INTO quhNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","¡May cusiska mana p'enkacuspa nokapi jap'icojka! ");
INSERT INTO quhNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Juanpa cachamuska yachacojcunan ripushajtincu Jesuska ashqha runasman paymanta parlarka: —Juan ch'innejpi willarashajtin ¿imatataj khawaj rerkanquichejrí? Ichhu wayrawan c'umuycachachiska ¿chayjinata iscayrayaj runatachu khawamorkanquichej? ");
INSERT INTO quhNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mana ajina cajtinri ¿imata khawajtaj rerkanquichejrí? ¿Uj sumaj c'achitu p'achalliska runata khawajchu rerkanquichej? Reparaychej, ajinata p'achallicojcunaka jatun camachejcunaj wasisnillancupi tiyacuncu. ");
INSERT INTO quhNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Chantarí ¿imata khawajpunitaj rerkanquichej? ¿Diosmanta uj willajtachu? Arí, niyquichej payka Diospa unay willajcunanmanta aswan curajmin caskanta. ");
INSERT INTO quhNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Dios palabranpi Juanmanta kelkacherka: Willajniyta naupakeyquita cachamushani. Payka runaspa sonkoncuta waquichipusonka paycunaman rinayquipaj. ");
INSERT INTO quhNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nokataj chekatapuni niyquichej: Tucuynin runas uqhupi ni uj runa canchu aswan curaj bautizaj Juanmanta niskaka. Dios camachin, chaypirí aswan pisipaj khawaska cajka aswan curajpunimin Juanmanta niskaka. ");
INSERT INTO quhNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","‘Bautizaj Juan willaraskan p'unchaymantapacha cunancama juchasapa runas Diospa camachisnin cayta mayta callpacushancu. Astawanrí Diospa churanacojninta atiywan atipaspalla paypa camachisnin cayta atincu. ");
INSERT INTO quhNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Diospa tucuy unay willajcunanwan Moiseswanka sut'incharkancu Juan jamunancama. Paycunaka Dios tucuyta wiñaypaj camachinanmanta parlarkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nerkancutaj Juanka willaj Eliasjina jamoj caskanta. Chay sut'inchaskancuta jap'iyta munanquichej chayka, atinquichej. ");
INSERT INTO quhNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ningriyoj cajka, sumajta uyarichun. ");
INSERT INTO quhNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","‘¿Picunamantaj rijch'acuncu cunan p'unchay runas? Plazaspi tiyaska pujllacoj wawasman rijch'acuncu. Uj tantaska wawas waj tantaska wawasta khaparincu: ");
INSERT INTO quhNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Kenata tocaporkaycu tusunayquichejpaj. Kancunarí mana tusorkanquichejchu. Wakanapajjina taquiporkaycu kancunarí mana wakarkanquichejchu”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ajinata Juanpis riqhurimuspa sumaj miqhunasta mana miqhojchu nitaj vinota ujyajchu chaywan Diosta casunanpaj. Runastaj nerkancu: “Supayniyoj chay runaka”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Chanta noka, Diospa cachaska Runan, jamorkani, runaswantaj miqhuni. Nokamantataj nincu: “¡Khawaychej! Cay runaka miqhuysapa ujyaysapataj. Juchasapaswan impuesto jap'ejcunawan rejsinaycucun”, nispa. Chaywanpis tucuy cheka yachayniyojka rejsin Diospa yachaynin cheka caskanta. Ruwaskasninwantaj cheka caskanta ricuchin. ");
INSERT INTO quhNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Waquin llajtaspi Jesuska astawan ashqha t'ucuna imasta atiyninwan ruwarka. Chaywanpis chaypi tiyacoj runaska juchasnincuta mana sakerkancuchu. Nitaj Diosman cutirerkancuchu. Chayraycu Jesuska chay llajtaspi tiyacojcunata c'amerka: ");
INSERT INTO quhNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Ay, phutiy, ari, kancuna Corazín llajtapi tiyacojcunapajka! ¡Ay, phutiy, ari, kancuna Betsaida llajtapi tiyacojcunapajka! Dios atiyninwan jatun t'ucunasta kancuna uqhupi ruwarka. Tiro llajtayojcuna Sidón llajtayojcunapis ancha sajras carkancu. Chaywanpis paycuna uqhupi chay jatun t'ucunasta Dios ruwanman carka chayka, paycunaka payman unayña cutiricapuncuman carka. Ajinaka llamp'u sonkowan juchallicuskancumanta mayta llaquicuspa sajra ruwaskasnincuta sakepuncuman carka. Chayta ricuchinancupaj luto p'achasnincuta usphatawan umasnincuman jich'acuncuman carka. ");
INSERT INTO quhNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Chaywanpis niyquichej: Diospa c'ajaj phiñacuynin p'unchaypiri kancunata astawan ñac'arichisonkachej Tiropi Sidonpi tiyacojcunamanta niskaka. ");
INSERT INTO quhNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Capernaum llajtapi tiyacojcuna, kancuna mayta munasharkanquichej janaj pachaman okhariskas jatunpaj khawaskas canayquichejta. Astawanpis kancunaka uqhu pachapi tucuchiskas canquichej manacajpaj khawaskas canayquichejcama. Kancuna uqhupi ruwacuskan ajina ricuchinasllatajchus Sodoma llajtapi ruwacunman carka chayka, cunan p'unchaycama cacushanman carka. ");
INSERT INTO quhNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Chaywanpis niyquichej: Dios c'ajaj phiñacuy p'unchaypi kancunata astawan ñac'arichisonkachej Sodoma llajtamanta niskaka, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Chaypacha Jesuska Diosman nerka: —Yupaychayqui Tatáy, kanka janaj pachata cay pachata camachej canqui. Imaraycuchus cay imasta yachaysapasmanta yuyaysapasmanta pacaycorkanqui. Wawajina llamp'u sonkoyojcunamantaj cay imasta sut'incharkanqui. ");
INSERT INTO quhNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Arí, Tatáy, ajina ruwaskayquimanta cusicunqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Runasman nillarkataj: —Dios Tatay tucuy yachayta kowarka. Payllamin noka Wawataka rejsiwan. Noka Wawallanmin Dios Tataytaka rejsini. Pimanchus noka, Wawan, rejsichiyta munani chay runallataj Dios Tataytaka rejsin. ");
INSERT INTO quhNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Juchawan tucuy sayc'uchiska cajcuna tucuy llaquiska cajcunapis nokaman jampuwaychej. Nokataj samarichiskayquichej. ");
INSERT INTO quhNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Wacas yugota apancu ajinata yachachinasniyta casuychej. Nokamantataj yachacuychej. Llamp'u sonkoyojmin caspa mana jatunchacunichu. Kancunataj nokaman jamuspa sonkoyquichejpi cheka samacuyta tarinquichej. ");
INSERT INTO quhNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Imaraycuchus nokata casuyka cusicuymin. Nokapaj llanc'aytaj mana llasachu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Chay cuti Jesuska trigo chajra chaupinta risharka. Chayri samacuna p'unchay carka. Yachacojcunantaj yarkhachicuspa trigo umasta muruspa pallasharkancu miqhuyta kallarerkancutaj. ");
INSERT INTO quhNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Fariseo partemanta runasri chayta ricuspa Jesusman nerkancu: —Khawaymá, yachacojcunayqui samacuna p'unchaypi cayjinata llanc'ancu camachiwaskanchejta mana casuspa, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesusri paycunaman cuticherka: —¿Manachu leerkanquichej unay camachej Davidpa ruwaskanta? Paywan runasninpiwan yarkhachicorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Paytaj yupaychana-wasiman yaycorka. Diosman t'akaska t'antasta miqhorka. Camachiwaskanchejmanjinarí chay t'antataka yupaychana-wasipi ruwanayojcunalla miqhunancu carka. Ni pay nitaj runasninpis miqhunancuchu carka. ");
INSERT INTO quhNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kancuna Moisespa camachiskasninta leerkanquichejcharí. Chaypi Moisés camacherka samacuna p'unchaypi runas mana llanc'anancuta. Yupaychana-wasipi ruwanayojcunarí ruwanallancupuni. Samacuna p'unchaypi ruwaskancumantataj mana juchallicorkancuchu Diosta yupaychanapaj ruwaskancuraycu. ");
INSERT INTO quhNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nokarí niyquichej caypi cashajka yupaychana-wasipi ruwanasmanta niskaka aswan curajmin caskanta. ");
INSERT INTO quhNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Dios nin: “Runas qhuyanacunancoka astawan nokata cusichiwan uywa wañuchiska jaywanasmanta niskaka”. Chaytachus reparawajchej chayka, mana juchachawajchejchu allin ruwajcunataka. ");
INSERT INTO quhNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Noka, Diospa cachaska Runan, atiyniyoj cani camachinaypaj imatachus ruwanata samacuna p'unchaypipis. ");
INSERT INTO quhNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Chaymanta ripuspataj Jesuska tantacunawasincuman yaycorka. ");
INSERT INTO quhNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Chaypi carka uj wañuska maquiyoj runa. Runaska imaynallamantapis Jesusta juchachayta munasharkancu. Chayraycu taporkancu: —Niwaycu, camachiwaskanchejmanjina ¿aticunchu runata thañichiy samacuna p'unchaypi? ");
INSERT INTO quhNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesusrí paycunaman cuticherka: —Samacuna p'unchaypi uj ovejayquichej jatun t'okoman urmaycunman chayka ¿orkhocapuwajchejcharí? ");
INSERT INTO quhNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Diospa ñaupakenpi runaka aswan yuyanamin ovejamanta niskaka. Chayraycu samacuna p'unchaypeka allin cajtapuni ruwana, —nispa nerka. ");
INSERT INTO quhNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Chanta wañuskajina maquiyoj runaman nerka: —Aysariy maquiyquita. Runataj maquinta aysarerka. Chay maquinri ujnin maquinjina thañiska carka. ");
INSERT INTO quhNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Fariseo partecunarí llojsiytawan tantacamorkancu. Jesuspa contranpi parlanacorkancutaj imaynamantapis payta tucuchinancupaj. ");
INSERT INTO quhNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesusrí chay imasta yachaspa chaymanta llojsiporka. Ashqha runas paywan risharkancu. Tucuy paycunatataj thañichisharka. ");
INSERT INTO quhNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Paycunataka allinta camacherka: —Pitaj noka caskaytaka ama pimanpis willanquichejchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ajinapi junt'acorka Diospa unay willajnin Isaiaspa niskan Jesuscristomanta. Ajinaka Dios nin: ");
INSERT INTO quhNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Paymin ajllacuska camachiy, sonkoyta cusichin. Paytamin munacuni. Santo Espirituta cachasaj paypa sonkonpi tiyacunanpaj. Paytaj tucuy runasman cheka munayniyta willaranka. ");
INSERT INTO quhNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Llamp'u sonkowan parlanka. Manataj runaswan khawachicunanpajjinachu willaranka. ");
INSERT INTO quhNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Mana p'aquenkachu saruska sokosojina runatapis. Nitaj ñac'ayta k'oshñej c'anchanajina runatapis wañuchenkachu. Cheka munayninta junt'anancama chaytaka pay ruwanka. ");
INSERT INTO quhNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Tucuy runaska juchancumanta cachariskas canancupaj paypi suyankancu. ");
INSERT INTO quhNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Chaymantataj Jesusman uj ciegota pusamorkancu. Chay runari supayniyoj upataj carka. Jesustaj payta thañicherka. Ajinapi upa cajka parlaporka, ricorkataj. ");
INSERT INTO quhNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tucuy chay ashqha runastaj t'ucuspa Jesusmanta nerkancu: —¿Cay Diospa ajllaskan Cristochu canman? ");
INSERT INTO quhNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Fariseo partecunarí cayta uyarispa nerkancu: —Cay runaka curaj supaycunaj curajnincu, Beelzebú atiynillanwan supaycunata kharkon, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesusrí yuyashaskancuta yachaspa paycunaman nerka: —Jatun llajtapi tiyacojcuna paycunapura makanaycucojtincoka tucuchiska canka chay llajtaka. Sapa llajta chayrí wasipis paycunapurallataj makanacojtenka chincaponka. ");
INSERT INTO quhNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Curaj supay Satanás supaycunallatataj kharkon chayka, payllataj t'akanacushan. Camachisnillantaj paywan makanacojtincoka tucuconkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Supay Beelzebój atiyninwan supaycunata kharkoskayta ninquichej. Kancunamanta cajcunarí ¿pejpa atiyninwantaj supaycunata kharkoncurí? Chayraycu paycuna pantaskaspuni caskayquichejta ricuchisonkachej. ");
INSERT INTO quhNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nokarí Santo Espíritoj atiyninwan supaycunata kharkoskayka niyta munan Dios kancuna uqhupiña caskanta camachinanpaj. ");
INSERT INTO quhNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","‘Suwayta munajka callpasapaj wasinman yaycunanpajka ñaupajta atipaspa watananraj tiyan. Chanta wasinman yaycuyta atin capuyninta apacapunanpaj. Nokapis ajinallatataj curaj supayta atipaspa millay supaycunata kharkoni. ");
INSERT INTO quhNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","‘Ajinata mana nokawan cusca Diosman sayacojka contraypi churanacun. Mana nokata yanapawajka ruwanasniyta jarc'awan. ");
INSERT INTO quhNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","‘Chayraycu niyquichej Dios khechuyta atiskanta runaspa tucuy juchancuta payta phiñachiskancutapis. Santo Espíritoj contranpi sajrata parlajtarí Dios mana perdonankachu. ");
INSERT INTO quhNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Noka, Diospa cachaska Runanpa contranpi sajrata parlan chayka, parlaskanmanta perdonaskaraj canka. Santo Espíritoj contranta sajrata parlajrí ni jayc'aj perdonaskachu canka, ni cunanpis nitaj khepatapis. ");
INSERT INTO quhNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","‘Yachanchej sach'a sumaj chayka, pokoyninpis sumajllataj. Sach'a mana allinchu chayrí pokoyninpis manallataj allinchu. Arí, sach'ataka pokoyninmantamin rejsinchej. Nokatapis ajinallatataj ruwaskasniymanta atinquichej rejsiwayta. ");
INSERT INTO quhNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Kancuna runa wañuchi catarisjina canquichej! Sajra caspa ¿imaynatataj allin cajta parlayta atiwajchejrí? Runaka sonkonpi junt'a cajmanta parlan. ");
INSERT INTO quhNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","C'acha runaka c'acha imasta parlan sonkonpi c'acha cajta jallch'askanmanta. Sajra runarí sajra cajta parlan sonkonpi sajrata jallch'askanmanta. ");
INSERT INTO quhNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nokarí niyquichej runaska tucuy manacaj niskanmantapis Diosman willacunan tiyan. Chaypi Dios nenka juchayojchus manachus caskancuta. ");
INSERT INTO quhNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Niskasniyquimanjina Dios chekan ruwaj runapaj khawasonka. Chayrí sajra niskasniyquimanjina pay juchachasonka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Chanta waquin yachachejcuna fariseo partecunawan nerkancu: —Yachachej, Diosmanta cachamuska caskayquita yachanaycupaj uj jatun t'ucunata ruwaspa kanmanta ricuchiwaycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesusrí cutichispa paycunaman nerka: —Sajra ruwajcunawan Diosta wasanchajcunawan uj t'ucunapaj ricuchinata mañashancu. Chayka mana ruwaskachu canka. Manachayrí Diospa unay willajnin Jonás ricucherka, chayllataj reparanancupaj cashan. ");
INSERT INTO quhNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonaska quinsa p'unchay tutatawan jatun challwaj wijsan uqhupi carka. Ajinallataj noka, Diospa cachaska Runanpis, jallp'a uqhupi p'ampaska casaj quinsa p'unchayta quinsa tutatawan. ");
INSERT INTO quhNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Diospa c'ajaj phiñacuynin p'unchaypi Nínive llajtapi tiyacojcuna cunan p'unchaycunaj contrancupi willankancu. Paycunatataj juchachankancu. Imaraycuchus Jonaspa willaraskantawan paycunaka juchasnincuta sakespa Diosman cutiricaporkancu. Reparaychejtaj cunan Jonasmanta aswan curaj caj caypi caskanta. ");
INSERT INTO quhNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Chay p'unchaypitaj Sabá runasta camachej warmipis cunan p'unchay runaspa contrancupi willaspa paycunata juchachanka. Imaraycuchus payka may caru jallp'manta jamorka Salomonpa yachayninta uyarej. Reparaychejtaj cunanka Salomonmanta aswan curaj caj caypi caskanta. ");
INSERT INTO quhNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","‘Uj millay supay runamanta llojsispaka ch'aqui pampapi khasilla purin. Samaricuyta masc'aspataj mana tarinchu. ");
INSERT INTO quhNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Chanta yuyaspa nin: “Pimantachus llojsimorkani chay runallamantaj cutipusaj”, nispa. Cutimuspa supayka chay runata taripan pichaskata sumaj c'uchunchaskatataj ch'usaj wasitajina. ");
INSERT INTO quhNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Chaymantaj supayka rispa paymanta aswan millay kanchis supaycunata pusamun. Chay runaman yaycuspataj paypi tiyacuncu. Ajinapitaj chay runaj khepa caynin aswan sajraman tucun ñaupaj caskanmantaka. Cay p'unchay sajra runaswanpis ajinallataj canka. ");
INSERT INTO quhNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús chay ashqha runasman parlashajtinraj, khaway, maman waukesninwan chayamorkancu. Cay jawapi casharkancu paywan parlayta munaspa. ");
INSERT INTO quhNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ajinallapi uj runaka Jesusman willarka: —Khaway, mamayqui waukesniyquiwan jawapi cashancu. Munashasuncutaj kanwan parlanacuyta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesustaj cutichispa willajman nerka: —¿Picunataj mamay waukesniy cancumanrí? —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Yachacojcunanta maquinwan ricuchispataj nerka: —Paycuna mamay waukesniypis cancu. ");
INSERT INTO quhNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Janaj pacha Dios Tataypa munayninta ruwajmin waukey, panay, mamaypis, —nispa nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Chay p'unchay Jesuska wasimanta llojsispa kocha cantoman rerka. Chaypitaj yachachinanpaj tiyaycucorka. ");
INSERT INTO quhNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","May ashqha runastaj tantaycacamorkancu. Chayraycu payka barcoman yaycuspa chaypi tiyaycucorka. Tucuy chay ashqha runastaj kocha cantopi sayaycucorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jesusri quiquinchanaswan ashqha imasmanta paycunaman willarka. Nerkataj: —Uyariwaychej, uj runa mujuta t'acaj llojserka. ");
INSERT INTO quhNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","T'acashajtinri waquin mujoska ñan pataman urmarkancu. P'iskostaj jamuytawan pallacaporkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Waquin mujusri pisi jallp'ayoj rumi pataman urmarkancu. Chay mujoska uskhayta p'uturamorkancu pisi jallp'a caskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Mana sumaj saphiyoj caskanraycutaj inti ruphamojtin ch'aquiporkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Waquin mujustaj qhishca chaupiman urmarkancu. Qhishcawan cusca wiñaycuytawantaj trigota sip'icaporkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Waquin mujusrí sumaj jallp'aman urmarkancu. Chaypi waquenka uj mujullamanta pachajta pokorka. Waquintaj sojta chuncata, waquintaj quinsa chuncata pokorka. ");
INSERT INTO quhNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ningrisniyoj cajka sumajta uyarichun, —nispa nerka Jesuska. ");
INSERT INTO quhNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yachacojcunaka Jesusman kayllaycuspa tapurerkancu: —¿Imaraycutaj runasman quiquinchanaspa parlanquirí? ");
INSERT INTO quhNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Paytaj paycunaman cutichispa nerka: —Dios runasninta camachin, chaymanta yachachinaska wajcunapaj pacaska cancu. Cunanrí kancunallaman sut'i ricuchiskas cancu entiendenayquichejpaj. ");
INSERT INTO quhNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Niskanta jap'icojmanka Dios astawanraj entiendeyta yanapanka. Ajinapi jap'icojka astawan astawanraj jap'iconka. Mana jap'icojmantarí pisi jap'iska yuyaskanpis khechuska canka. ");
INSERT INTO quhNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Chayraycu paycunaman quiquinchanaswan parlani ricushaspapis mana entiendenancupaj uyarishaspapis mana chekata reparanancupajchu. ");
INSERT INTO quhNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ajinapi Isaiaspa sut'inchaskan paycunamanta junt'acun. Dios palabranpi nin: Uyarishaspa chay uyariskayquichejtaka mana entiendenquichejchu. Khawashaspa chay khawashaskayquichejtapis mana reparanquichejchu. ");
INSERT INTO quhNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Sonkoncu rumiyaycapuskanraycu chay runas palabrayta mana entiendencuchu. Ningrisnincoka manaña allintachu uyarin. Ñawisnincutapis ch'illmiycapuncu ama ricunancupaj. Ningrisnincuwanpis mana uyarincuchu mana munaspa entiendewayta. Chaywanpis sonkoncupi mana reparayta munancuchu. Chayraycu nokaman mana cutiricamuncuchu juchasnincuta khechuspa paycunata thanichinaypaj. ");
INSERT INTO quhNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","‘Kancunarí may cusiskas canquichej ñawisniyquichejwan chaycunata ricuskayquichejraycu ningrisniyquichejwantaj uyariskayquichejraycupis. ");
INSERT INTO quhNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Niyquichej chekatapuni kancuna ricushanquichej chayta ashqha unay willajcunawan cheka ruwajcunawan ricuyta mayta munaskancuta. Manataj ricorkancuchu. Uyarishaskayquichejtapis uyariyta mayta munarkancu manataj aterkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","‘Tarpojwan quiquinchaskayta entiendenayquichejpaj uyariwaychej. ");
INSERT INTO quhNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","‘Waquin runas Dios camachin, chaymanta willanasta uyarincu, manataj casuncuchu. Chaycunaka ñan purinaman urmaj mujusjinamin cancu. Supay Satanás jamuspa Diospa niskanta sonkoncumantaka siq'irpayan mana juchamanta cachariska canancupaj. Chay runaska ñanpi t'acaska mujujinamin. ");
INSERT INTO quhNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Waquin runaska pisi jallp'ayoj rumi pataman urmaj mujusjina cancu. Diospa niskanta uyarispa cusiywan jap'icuncu. ");
INSERT INTO quhNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Chay runaska pisi saphiyoj mujusjinamin. Chayraycu pisi ratullapaj jap'incu. Paycunata llaquiycuna khatirishajtin chayrí Diospa niskanraycu muchojtincu paycunaka chaypacha urmacapuncu. ");
INSERT INTO quhNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Waquin runas Diospa niskanta uyarispa cay pacha imasmanta anchata yuyancu. Chayjina runaka munashan ancha khapaj caytaraj. Tucuy chay imastaj payta pantachispa Diospa niskanta sonkonpi mana sakenchu wiñajta. Ajinapi mana pokoyniyoj caspa payka Diosta mana cusichinchu. Chayraycu qhishca chaupiman urmaj mujujina cashan. ");
INSERT INTO quhNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Waquin runas Diospa niskanta tucuy sonkowan uyarispa casuncu. Chay runaka sumaj jallp'aman urmaj mujujina cashan. Diosta casuskancuraycutaj payta cusichincu. Ajinapi waquin runas ancha sumajta ruwaspa pachajman pokoj mujujina cancu. Waquinri sumajllata ruwaspa sojta chuncaman pokoj mujujina cancu. Waquintaj quinsa chuncaman pokoj mujujina callancutaj. ");
INSERT INTO quhNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Waj quiquinchanatawan Jesuska yachachisharka. Nerka: —Dios camachishajtenka sumaj mujuta chajranpi tarpoj runaman rijch'acun. ");
INSERT INTO quhNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tutapi tucuy runas puñushajtintaj uj chejnicojnin jamorka. Millay kora cizaña mujuta trigo tarpuskanman t'acaycarparerka. Chaymantataj riporka. ");
INSERT INTO quhNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Trigotaj wiñaspa sunqhachacorka. Chaypacha millay cizaña trigopis riqhurillarkataj. ");
INSERT INTO quhNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tarpojpa camachisninri payman jamuspa nerkancu: “Tatay, “¿manachu sumaj mujullata t'acarkanqui chajrayquipi? ¿Imaynamantataj riqhurin chay millay khorarí?” ");
INSERT INTO quhNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Paytaj paycunaman nerka: “Chayka uj chejnicojpa ruwaskan”, nispa. Chanta camachisnin payman nerkancu: “¿Munanquichu khorata siq'iramoj rinaycuta?” ");
INSERT INTO quhNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Payri cuticherka: “Amaraj, trigotapis koratawan cusca siq'irashawajchejchá. ");
INSERT INTO quhNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Sakellaychej iscaynincuta wiñajta ruthunacama. Ruthushajtincu trigo ruthojcunaman nisaj: Ñaupajta cizañata t'akarkoychej. K'apiy k'apiyllata churarparispa wataychej ruphachinayquichejpaj. Trigotarí pirwayman wakaychaychej”, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Waj quiquinchanatawan Jesús paycunaman yachacherka: —Imaynatachus chajrapi tarpuska juch'uy muju wiñan, ajinallataj cashan Dios runasta camachishajtenka. ");
INSERT INTO quhNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Chekatapuni chay mujoka tucuy juch'uy mujusmanta aswan juch'uysitumin. Wiñasparí tucuy koramanta aswan jatunta wiñan sach'itajinaman tucunancama. P'iskospis mallquisninpi thapachacuncu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Waj quiquinchanatawan paycunaman yachachispa nerka: —Dios camachishajtenka, t'anta pokochina levadurajina wiñan. Uj warmi chay pokochinata iscay arrobajina trigo jac'uman churaycorka. Chanta tucuynin masa pokospa okharicamorka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Tucuy chay imasta Jesuska chay ashqha runasman quiquinchanasllawanpuni parlaj. Mana chaywanka mana yachachejchu. ");
INSERT INTO quhNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ajinapi Diospa willajninpa niskan junt'acorka. Dios palabranpi nin: Quiquinchaspa paycunaman parlasaj. Cay pacha ruwacuskanmantapacha mana yachaska imasta paycunaman willasaj. ");
INSERT INTO quhNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Chanta Jesuska runasta cacharpayaspa wasiman jamporka. Yachacojcunantaj payman kayllaycuspa nerkancu: —Chay chajrapi cizaña khorawan quiquinchanamanta sut'inchawaycu, ");
INSERT INTO quhNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Payri cuticherka: —Noka, Diospa cachaska Runan, sumaj mujuta tarpoj cani. ");
INSERT INTO quhNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Chajrataj tucuy runas cancu. Sumaj mujutaj Diospa cheka wawasnin cancu. Cizañataj Diosta mana casoj supay Satanaspa wawasnin cancu. ");
INSERT INTO quhNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Cizañata t'acaycojtaj chejnicoj supaymin. Cosechari nokaj cutimunay p'unchaymin. Ruthojcunataj Diosmanta cachaska angeles cancu. ");
INSERT INTO quhNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Chayraycu imaynatachus cizañata runas tantaycuspa ninaman ruphachincu. Ajinallataj canka cay pacha tucucojtenka. ");
INSERT INTO quhNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Noka, Diospa cachaska Runan, angelesniyta cachamusaj. Maypicha camachini, chaymanta orkhonkancu tucuy pantachej, sajrata ruwaj runasta, Diosta mana casojcunatapis. ");
INSERT INTO quhNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Paycunata laurashaj uqhu pachaman wijch'uyconkancu. Chaypitaj chay runaska jatun nanaywan manchayta wakankancu, phutiywan quirusnincutapis c'aruconkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Chanta chekanta ruwajcunaka cusiywan riconkancu Diosta janaj pachapi. Chaypitaj Dios Tata atiyninwan tucuyta camachenka. Ningrisniyoj cajka sumajta uyarichuncu. ");
INSERT INTO quhNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","‘Dios runasta camachishajtin uj chajrapi khapaj capuy p'ampaskaman rijch'acun. Chayta taricoj runaka pacaycun. Cusiywan rispataj tucuy capuyninta vendemun chay jallp'atataj ranticapun. ");
INSERT INTO quhNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","‘Dios runasta camachishajtin uj rantej runamanpis rijch'acullantaj. Payka may sumaj perlasta masc'an rantinanpaj. ");
INSERT INTO quhNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Aswan sumaj caj perlayojwan tincucuspa: “Cayta ranticuskayqui”, nerka. Chaymanta rerka tucuy capuyninta vendemoj sumaj perlata ranticapunanpaj. ");
INSERT INTO quhNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","‘Ajinallataj Dios runasta camachishajtin challwa jap'ina jatun ch'ipaman rijch'acun. Runas chay ch'ipata kochaman churancu. Chay ch'ipawan imaymana challwasta jap'incu. ");
INSERT INTO quhNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ch'ipa junt'aycojtintaj kocha cantoman aysancu. Chaypi tiyaycucuspa challwasta ajllancu. Sumajcunata canastasman tantancu. Mana allin cajcunatataj wijch'upuncu. ");
INSERT INTO quhNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ajina canka cutimunay p'unchaycunapeka. Janaj pachamanta angeles jamonkancu t'akanancupaj sajra runasta chekan ruwaj runasmanta. ");
INSERT INTO quhNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Chay sajra ruwaj runasta laurashaj uqhu pachaman wijch'uyconkancu. Jakaypiri manchayta wakankancu, phutiywantaj quirusnincuta c'aruconkancu, —nispa nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesús yachacojcunata taporka: —¿Tucuy chayta entienderkanquichejchu? Paycunataj cuticherkancu: —Arí, yachachiwajníy, entiendeycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jesusri paycunaman nerka: —Chayraycu Dios camachin, chaymanta sumaj yachachiska runa uj khapaj wasiyojman rijch'acun. Payka jallch'aska khapaj khoyasninmanta orkhomun mosoj khoyasta unay khoyastapis, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Chay quiquinchanaswan parlayta tucuytawan Jesuska chaynejmanta llajtanman riporka. ");
INSERT INTO quhNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Chayaspa runasta tantacuna-wasincupi yachachisharka. Mayta t'ucuspa runas ninacorkancu: —Cay runari ¿maypitaj cayjina yachayniyoj tucumorkarí? ¿Imaynapitaj cayjina t'ucuna ruwanasta ruwashanrí? ");
INSERT INTO quhNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Manachu cayka carpintero runaj wawan? ¿Manachu mamanpa sutinpis María? ¿Manachu waukesninpis Jacobo, José, Simón, Judaswan cancu? ");
INSERT INTO quhNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Panasninpis ¿manachu kayllanchejpi tiyacuncu? Chanta ¿imaynapitaj tucuy cay imasta yachamorkarí? ");
INSERT INTO quhNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Paycunataj phiñacuspa Jesusta mana jap'icorkancuchu. Jesusrí paycunaman nerka: —Diosmanta uj willajka sumajpaj khawaskapuni cashan waj llajtaspeka. Llajtanpi, wasinpiwan cajcunalla paytaka manamin sumajpajchu khawancu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Chaypitaj Jesuska pisi t'ucuna ruwanasllata ruwarka paypi mana jap'icuskancuraycu. ");
INSERT INTO quhNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Galilea jallp'api camachej Herodeska chay p'unchaycunapi Jesuspa ruwaskasninmanta uyarerka. ");
INSERT INTO quhNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Camachisninmanta curajcunamantaj nerka: —Cay runaka bautizaj Juan wañuyninmanta causarimpuskamin. Chayraycu Diospa atiyninwan t'ucuna ruwanasta ruwashan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Ñaupajpi Herodeska jap'iycucherka Juanta. Wataycuchiytawantaj carcelman wisk'aycucherka, wauken Felipej warminraycu. Ñaupajpi Juanka payta c'amejpuni carka: —Juchamin waukeyquej warmin Herodiasta warmillicunayqueka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Chayraycu Herodiaska Juanta wañuchiyta munarka. May ashqha runasmantataj manchachicorka. Paycunaka Diospa willajninpaj Juanta rejserkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Astawanrí Herodespa diachacun chayamorka. Chaypitaj Herodiaspa ususenka wajyaskacunapaj tusorka. Herodesri chaywan mayta cusicorka. ");
INSERT INTO quhNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Chayraycu Herodeska Diospa sutinta okharispa nerka warminpa ususinman: —Imatachá mañacuwaskayquita koskayqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Chay sipastaj maman yachaycuchiskanraycu nerka: —Cunitanpacha chuwapi bautizaj Juanpa umanta koway, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Camachej Herodeska phuticorka. Diospa sutinta okhariskanraycurí paywan cusca tiyacojcunaraycutaj camacherka Juanpa umanta sipasman konancuta. ");
INSERT INTO quhNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Chanta soldadosta carcelman cacharka Juanpa umanta khorumunancuta. ");
INSERT INTO quhNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Chaymantataj Juanpa umanta uj chuwapi apamorkancu. Sipasmantaj jaywarkancu. Paytaj mamanman aparka. ");
INSERT INTO quhNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Chayta yachaspa Juanpa yachacojcunan jamorkancu. Ayantataj apacaporkancu p'ampamunancupaj. Chay imasmantataj Jesusman willamoj rerkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesuska chayta uyariytawan yachacocunanwan barcopi riporka ch'innejman sapallancu canancupaj. Riskanta yachaspataj may ashqha runas llajtasmanta chaquillapi khepanta khaterkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Barcomanta llojsispataj Jesuska may ashqha runasta ricorka. Paycunamantari sonkon nanarka. Qhuyacuspataj onkoskasta thañiracherka. ");
INSERT INTO quhNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ch'isiyaycushajtinña yachacojcunanka Jesusman chimpaycorkancu. Nerkancutaj: —Inti yaycushanña. Ch'in pacha caynejka. Chayraycu cay ashqha runasta cachapullayña. Ajinapi ranchosman rispa miqhunata ranticamonkancu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Astawanri Jesuska paycunaman cuticherka: —Mana paycunaka ripunancuchu tiyan. Kancuna paycunaman miqhunata koychej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Paycunarí nerkancu: —Caypeka phishka t'antaswan iscay challwitasllawan tiyapuwaycu. Chaylla, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesustaj nerka: —Chay capususkayquichejta cayman apamuwaychej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Chay ashqha runastataj camacherka pastopi tiyaricunancuta. Chanta chay phishka t'antasta iscay challwitastawan maquisninpi jap'erka. Janaj pachaman khawarispataj qraciasta korka Diosman. T'antasta challwitastawan partispataj yachacojcunaman jaywarka. Paycunataj chay ashqha runasman jaywaramorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tucuynincu miqhorkancu sajsacunancucama. Chay partiskasmanta puchojtaj chunca iscayniyoj canastas junt'araj carka. ");
INSERT INTO quhNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Chay miqhojcunaka phishka warankajina kharis carkancu. Warmis wawitaswanpis miqhullarkancutaj. ");
INSERT INTO quhNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Chayta ruwaskantawancama Jesuska yachacojcunanta camacherka: —Barcoman yaycuychej kocha chimpaman ñaupajta rishanayquichejpaj. Nokataj chaycama runasta cacharparipusaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Runasta cacharpariytawan Jesuska sapallan orkoman riporka Dios Tatanwan parlaj. Inti yaycuytañari sapallan payka orkopi cacusharka. ");
INSERT INTO quhNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Chaycamataj barcoka jallp'amanta carupi uqhu kochapiña carka. Yacutaj kholchokeyaspa barcotaka mayta apaycachasharka sinch'i wayra contrancupi wayramushaskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Jesusrí sut'iyamuytaña yacu patata purispa paycunaman kayllaycusharka. ");
INSERT INTO quhNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Yachacojcunanka yacu patanta purishajta ricuspa mayta mancharicorkancu “¡Alma!” nispa. Manchaymantataj khaparerkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Khapariskancutawantaj Jesuska paycunaman nerka: —¡Callpachacuychej! ¡Noka cani! Amaña manchachicuychejchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pedrotaj cutichispa nerka: —Señorníy, kanchus canqui chayka, niway cay yacu patata kanman jamunayta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesustaj nerka: —Jamuy, —nispa. Pedrori barcomanta uraycorka. Yacu patanta purispataj Jesusman risharka. ");
INSERT INTO quhNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Wayra sinch'i caskanta ricuspa mancharicorka. Yacuman chincaycushaskanpitaj khaparicorka: —Señorníy, jap'iriway, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jesustaj maquinwan payta jap'icorka. Nerkataj: —¡Ancha pisita nokapi jap'icunqui! ¿Imaraycutaj iscayrayarkanquirí? ");
INSERT INTO quhNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Paycuna barcoman yaycojtincutaj manaña wayrarkachu. ");
INSERT INTO quhNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Barcopi cajcunarí Jesusman kayllacuspa yupaycharkancu. Nerkancutaj: —¡Chekamanta kanka Diospa c'ata Wawan canqui! ");
INSERT INTO quhNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kochata chimpaytawanka Genesaretman chayamorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Chaypi tiyacoj runas Jesusta rejsiycorkancu. Chaymantataj runas paymanta willamorkancu. Tucuy onkoskacunatataj payman apamorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Paycunataj Jesusmanta mañacorkancu p'achanpa t'icasnillantapis llanqharinancuta. P'achanta tucuy llanqharejcunataj thañiskas carkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Chaymantaka waquin fariseo partecuna yachachejcunawan Jerusalén llajtamanta jamorkancu. Jesustataj taporkancu: ");
INSERT INTO quhNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Imaraycutaj yachacojcunayqui unay curajninchejpa yachachiska ruwanasnincuta p'aquincu? Yachacuskanchejmanjina yachacojcunayqueka maquisnincuta mana mayllacuncuchu miqhunancupajka. ¿Imaraycutaj ajinata ruwancurí? ");
INSERT INTO quhNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesustaj cutichispa nerka: —Unay runasmanta yachacuskallayquichejta casushanquichej. Chanta ¿imaraycutaj kancunapis mana casunquichejchu Diospa camachiskanta? ");
INSERT INTO quhNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Imaraycuchus Dioska nerka: “Tatayquita mamayquita jatunpaj khaway. Tatanpaj chayrí mamanpaj sajrata parlajka wañuchiska canan tiyan”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kancunarí yachachinquichej uj runa atillan niyta tataman chayrí mamaman: “Mana atinichu yanapasuyta. Kosunay carka chaytaka Diosmanña korkani”. Chay “korkani” nejka manaña jatunpaj tatanta mamantapis khawanchu. ");
INSERT INTO quhNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Chaywanri Diospa camachiskanta p'aquinquichej yachacuskasniyquichejta ruwanayquichejpaj. ");
INSERT INTO quhNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Puraj uya runas! Allinta Diospa unay willajnin, Isaiaska, kancunamanta sut'incharka. Kelkaskanpi Dios nin: ");
INSERT INTO quhNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Cay runacunaka simisnillancuwan yupaychawancu. Sonkoncurí nokamanta carupi cashan. ");
INSERT INTO quhNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Paycunaka runaj yachachinasnillancuta yachachincu nokamantapis canmanjinata. Ajinapeka yankhalla yupaychawancu. ");
INSERT INTO quhNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Chanta chay ashqha runasta paynejman wajyaspa nerka: —Sumajta uyariwaychej niskasniyta entiendenayquichejpaj. ");
INSERT INTO quhNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Siminnejta yaycoj miqhunaka runaj yuyayninman juchawan mana ch'ichichanchu. Manachayrí runaj sonkonpi sajra yuyaskan siminnejta llojsimun. Chay parlaskanmin runataka ch'ichichaspa juchallichin, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Chanta Jesuspa yachacojcunanka payman kayllaycuspa nerkancu: —¿Yachanquichu chay fariseo runas niskayquita uyarispa phiñacuywan khesachasuskancuta? ");
INSERT INTO quhNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Payri cuticherka: —Tucuy yachachinas mana janaj pachapi tiyacoj Dios Tataymanta cajka k'ala tucuchiskas cankancu. ");
INSERT INTO quhNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Sakeychej chaycunata munaynincumanjina ruwanancuta. Paycuna ciegosjina cancu Diospa yachachinasninmantaka. Chaywanpis waj ciegosta pusajcunajinataj cancu. Sichus uj ciego ciegollatataj pusanman chayka, iscaynincu cusca t'okoman urmayconkancu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pedrori Jesusta nerka: —Ch'ichichanamanta niskayquita sut'inchawaycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Paytaj cuticherka: —Kancunapis ¿manallatajchus yuyayniyoj canquichej? ");
INSERT INTO quhNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Manachu entiendenquichej? runaj miqhuskanka wijsanman yaycuskanta chaymantataj jawaman llojsipun. ");
INSERT INTO quhNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Astawanpis runaj sonkon sajrata yuyaskanmanta llojsimoj parlaskanmin runataka juchallichin. ");
INSERT INTO quhNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Imaraycuchus runaj sonkonmanta sajra yuyaycuna llojsimun. Chaymanta runata wañuchin, khenchachacun, sajra puriypi causan, suwacun, llullacuytawan willan runa-masinmanta, Diospaj sajrata parlan. ");
INSERT INTO quhNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Chaycunamin Diospa ñaupakenpeka jucha cancu. Runaj sonkontataj ch'ichichan. Maquista mana mayllacuspa miqhuyrí manapuni runaj sonkontaka ch'ichichanchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesuska chaymanta llojsipuspa Tiro llajta Sidón llajta chaynejman riporka. ");
INSERT INTO quhNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Chaypitaj tiyacoj Canamanta uj warmi. Paytaj Jesusman jamorka. Khaparispataj paymanta mayta mañacorka: —Tucuy atiyniyoj Señor, Diospa ajllaskan Cristo canqui. ¡Qhuyacuway nokamanta! Ususiyta supay mayta ñac'arichishan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesusrí warmiman ni uj palabratapis cuticherkachu. Chayraycu yachacojcunanka Jesusman kayllaycuspa mayta mañarkancu: —Cachapuy chay warmita. Payka khepanchejta khaparispa jamushan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesusri cuticherka: —Dios Tatayka israel aylluymanta chincaska cajcunallaman cachamuwan. Paycunaka ovejasjina Diospa chekan ñanninmanta pantaporkancu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Chaywanpis chay warmeka kayllaycuspa Jesusman c'umuycorka yupaychananpaj. Nerkataj: —¡Señor, yanapariway ari! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesusrí cuticherka: —Wawaspa t'antancuta okharispa alketusman karaycoyka mana allinchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Warmiri nillarkataj: —Arí, Señor, chaywanpis alketuspis miqhuncupuni dueñosnincoj miqhuy t'unasnin mesamanta t'acacojtenka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Chanta Jesuska payman cutichispa nerka: —Doña, may sumajta nokapi jap'icunqui. Munaskayquimanjina ruwaska cachun, —nispa. Chay quiquinpacha ususenka thañicaporka. ");
INSERT INTO quhNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesuska jakaymanta llojsispa Galilea kocha cantonejman rerka. Orkoman rispataj chaypi tiyaycucorka. ");
INSERT INTO quhNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","May ashqha runas payman kayllaycorkancu. Paycunataj apamorkancu wist'usta, ciegosta, mana rimarejcunata, ñuc'usta, ashqha waj onkoyniyojcunatawan. Jesuspa ñaupakenman chay onkoskasta churaycorkancu. Payri paycunata thañicherka. ");
INSERT INTO quhNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ajinaka chay ashqha runas mayta t'ucorkancu. Uyarerkancu mana rimarejcuna parlashajta. Ricorkancu ñuc'us thañicojta, suchus purishajta, ciegos ricushajta. Israel runaspa Diosnincutataj jatunchaspa yupaycharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesuska yachacojcunanta payman wajyaspa nerka: —Sonkoy nanawan cay ashqha runasmanta. Quinsa p'unchaytaña nokawan cusca cashancu. Miqhunancupaj manaña ni imapis canchu. Mana miqhuskata cachapuytari mana munanichu, ñanta rishaspapis yarkhaywan llauchhuyapuncuman, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Chanta yachacojcunan nerkancu: —Cay ch'innejpi cashanchej ¿imaynapitaj ashqha miqhunata tarisunman cay chhica runasta miqhuchinanchejpajrí? ");
INSERT INTO quhNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesusri taporka: —¿Mashqha t'antastaj capusunquichej? Paycunataj cuticherkancu: —Kanchis t'antaslla pisi challwitaspiwan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Chanta Jesuska runasta camacherka pampaman tiyaycucunancuta. ");
INSERT INTO quhNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Chay kanchis t'antasta maquisninpi jap'erka challwitastawan. Chaycunamantataj Diosman graciasta korka. Ajinaspa chay t'antasta challwitastawan partispa yachacojcunanman jaywallarkapuni. Paycunataj chay ashqha runasman jaywararkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tucuynincutaj miqhorkancu sajsacunancucama. Chaywanpis t'unasmanta puchuska kanchis jatun canastas junt'araj carka. ");
INSERT INTO quhNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Miqhojcunaka tawa warankajina kharis carkancu. Warmispis wawaspis miqhullarkancutaj. ");
INSERT INTO quhNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ajinata Jesús miqhuchiytawan runasta cacharpayarka. Chaymantataj barcoman yaycuspa Magdala jallp'aman riporka. ");
INSERT INTO quhNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Chanta fariseo partemanta saduceo partemantawan cajcuna Jesusman kayllaycamorkancu. Paycunaka imaynallamantapis Jesusta pantachiyta munasharkancu. Chayraycu paymanta mañarkancu uj jatun ruwanata Dios cachamuskanta yachanancupaj. ");
INSERT INTO quhNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesús cuticherka: —Kancunaka inti yaycupushajtin ninquichej: “K'ayaka sumaj p'unchay canka, phuyu puca pucata antawaramuskanraycu”. ");
INSERT INTO quhNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Tutamantataj ninquichej: “Cunan p'unchayka parankachá yanata phuyumushan”, nispa. Kancunaka phuyusta khawarispa yachanquichej imayna p'unchaychus cananta. Diospa ajllaska Runanmanta ricuchinastarí mana yachanquichejchu reparayta. ");
INSERT INTO quhNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Cay sajra ruwajcunawan Diosta wasanchajcunawanka t'ucunapaj uj ricuchinata mañashancu. Diospa willajnin Jonaspa ricuchinalla paycunapaj cashan manataj wajka, —nispa. Paycunata sakespataj riporka. ");
INSERT INTO quhNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yachacojcunanka barcopi kochaj ujnin chimpaman chayarkancu. Chaypiña paycunaka t'antata mana apacuskancuta yuyaricorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesusri paycunaman nerka: —Reparacuychej, sumajtataj khawacuychej fariseocunaj saduceocunaj t'anta pokochinancumanta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Yachacojcunataj paycuna uqhullapi tapunacusharkancu mana t'antata apacamuskancuraycu chayta parlaskanta. ");
INSERT INTO quhNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesusri yuyashaskancuta reparaspa paycunaman nerka: —¿Imaraycutaj kancuna uqhullayquichejpi tapunacushanquichej t'antata mana apacamuskayquichejmanta? ¡Kancunaka ancha pisita Diospi jap'icunquichej! ¿Manarajchu reparanquichej? ");
INSERT INTO quhNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Nitajchu yuyarinquichej miqhuchiskayta phishka t'antasllamanta phishka waranka runasman? ¿Konkapunquichejchu mashqha canastasta chay puchojta junt'achiskayquichejta? ");
INSERT INTO quhNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Nitajchu yuyarinquichej kanchis t'antasmanta tawa waranka runasman miqhuchiskaymanta? ¿Mayc'a jatuchej canastasta junt'ataj puchorkarí? ");
INSERT INTO quhNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Wakaychacuychej saduceowan fariseowan partecunaj t'anta pok'ochinancumanta nisuskayquichejta ¿imaraycutaj mana entienderkanquichejchu? Mana t'antamantachu parlarkayquichej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Chantaraj yachacojcunanka entienderkancu Jesuska mana t'anta pokochina levaduramantachu parlaskanta. Manachayrí fariesocunaj saduceocunaj llulla yachachinasnincuwan ama pantachiskas canancuta paycunaman parlaskanta entienderkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesuska Filipo jallp'api Cesarea llajta chaynejman chayarka. Chaymantataj yachacojcunanta taporka: —Noka, Diospa cachaska Runanmanta parlaspa, runaska ¿pi caskaytataj nincurí? ");
INSERT INTO quhNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Paycunataj cuticherkancu: —Waquin nincu bautizaj Juan causarimpuskanta. Waquintaj nincu Diospa unay willajnin Elías cutimuskanta. Waquinrí nincu Diospa unay willajnin Jeremías chayrí Diospa unay willajcunanmanta uj caskayquita, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Paycunamantaj nerka: —Kancunari ¿pi caskaytataj ninquichej? —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simón Pedrotaj nerka: —Kanka wiñay causaj Diospa ajllaska Wawan, Cristo canqui. ");
INSERT INTO quhNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesustaj payman cuticherka: —Kan, Jonaspa wawan Simón, may cusiska canqui. Chekatapuni niskayquitaka mana runallachu sut'inchasorka. Manachayrí janaj pacha Dios Tatay caytaka sut'inchasorka. ");
INSERT INTO quhNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Noka nillayquitaj kanka Pedro caskayquita. Chaytaj niyta munan rumi. Ujchaska ajllacuskasniytaj sinch'i rumi patapi wasichaskajina cancu. Uqhu pacha supay Satanás chayta manapuni atipankachu. ");
INSERT INTO quhNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Llavesta koskayqui Dios camachin, chayman runas yaycunancupaj. Cay pachapi imatapis runas ruwanancuta ninqui chayka, janaj pachapipis niskallataj canka. Cay pachapi imatapis runas ama ruwanancuta ninqui chayka, janaj pachapipis ajina niskallataj canka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Chanta Jesuska yachacojcunanman camacherka amaraj pimanpis willanancuta pay Diospa ajllaskan Cristo caskantaka. ");
INSERT INTO quhNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Chaypachamantapacha Jesuska yachacojcunanman sut'ita willayta kallarerka: —Jerusalén llajtaman rinaypuni tiyan. Chaypitaj israel curajcuna, yupaychana-wasimanta curajcunawan israel yachachejcunapiwan anchata ñac'arichiwankancu. Paycunaka wañuchiwankancupis. Quinsa p'unchaymantataj causarimpunay tiyan. ");
INSERT INTO quhNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pedrotaj Jesusta wajnejman pusaspa payta c'amerka: —Señorníy, amapuni ajina cananpaj, Dios kanta qhuyasuchun. ");
INSERT INTO quhNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesusrí Pedroman cutiricuspa nerka: —Anchuriy nokamanta. ¿Supay Satanásjina juchaman urmachiwaytachu munanqui? Kanka mana Diospa yuyaskanmanjinachu yuyashanqui manachayrí runaj yuyayninmanjinalla, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Chanta Jesuska yachacojcunanman nerka: —Pichari yachacojniy cayta munajka paypa tucuy munayninta sakepunan tiyan. Chaywanpis nokaraycu pay quiquin muchunan tiyan wañunancama. Nokatataj casunawanpuni tiyan. ");
INSERT INTO quhNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Chekatapuni pichari causayninta payllapaj wakaychacuyta munajka mana wiñay causayniyojchu canka. Picharí causayninta cay pachapi chincananta sakejka nokata casuskanraycu chayka, chekatapuni wiñay causayniyoj canka. ");
INSERT INTO quhNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Reparaychej: Sichus uj runa tucuy cay pacha capuytapis jap'inman, wiñaypajtaj chincapunman chayka ¿ima allintaj paypaj canmanrí? Yachanchejjina runaka causayninta ranticuyta mana atinchu tucuy cay pacha capuywanpis astawan valorniyoj caskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Imaraycuchus noka, Diospa cachaska Runan, cutimusaj Dios Tataypa atiyninwan cachamuska angelesninwan cusca. Chaypachataj sapa ujman ruwaskanmanjina kopusaj. ");
INSERT INTO quhNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Niyquichej chekamanta noka camachinaypaj jamusaj. Waquin caypi cashajcunamantari mana wañuspa nokata jamushajta ricuwankancu, —nispa nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Sojta p'unchaymantataj Jesuska uj jatun orkoman llojserka. Chaymantaj payka pusaricorka Pedrota, Jacobota, wauken Juantawan paycunallata. ");
INSERT INTO quhNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Jesuska paycuna ñaupakencupi wajjina rijch'acuyniyojman cutirparerka. Uyanka paycunaman intijina c'ancharerka. P'achanpis c'anchayjina yuraj yurajman cutirparerka. ");
INSERT INTO quhNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ujllata Moiseswan Eliaswan Jesusta parlanacushaj paycunaman riqhurimorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ajinapi Pedro Jesusman nerka: —Señorníy, caypi cacunanchejka sumajmin. Munawaj chayka, caypi quinsa ch'ujllasta ruwasajcu. Ujta kanpaj, ujta Moisespaj, ujtataj Eliaspaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro parlashajtillanraj mana yuyaskamanta uj lliphipej phuyu paycunaman uraycamorka. Chay phuyumantataj Dios Tata parlamushajta uyarerkancu: —Caymin c'ata munaska Wawayka. Paymanta mayta cusicuni. Payta uyariychej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Yachacojcunanri chayta uyarispa pampacama c'umuycorkancu Jesusta yupaychanancupaj. Maytataj manchachicorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Chanta Jesús paycunaman kayllaycuspa allinnincupaj llanqharerka. Nerkataj: —Sayaricuychej. Amaña manchachicuychejchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Paycunataj pataman khawarispa Jesusta sapallantaña ricorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Orkomanta uraycamushajtincu Jesuska paycunata camacherka: —Cay ricuskayquichejtaka ama willanquichejchu, noka, Diospa cachaska Runan, wañuymanta causarimunaycama. ");
INSERT INTO quhNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Chanta yachacojcunan payta watorkancu: —Yachachejcunanchej nincu manaraj Cristo jamushajtin willaj Eliasraj ñaupajta jamunanta. ¿Imaraycutaj ajinata yachachincurí? ");
INSERT INTO quhNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Paycunaman cutichispa Jesuska nerka: —Chekata yachachincu Elías ñaupajta jamunanta tucuy imata allinyachinanpaj. ");
INSERT INTO quhNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nokarí niyquichej Eliaska jamuskantaña. Runasri jamuskanta mana repararkancuchu. Astawanpis payta munaynincumanjina ñac'aricherkancu. Ajinallataj paycunaka noka, Diospa cachaska Runanta, munaynincumanjina ñac'arichiwankancu. ");
INSERT INTO quhNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Chaymanta yachacojcunaka entienderkancu bautizaj Juanmanta chayta parlaskanta. ");
INSERT INTO quhNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Khepanta ashqha runaswan tincorkancu. Uj runataj Jesusman chimpaycuspa konkoricorka. ");
INSERT INTO quhNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Nerkataj: —Señor, wawayta qhuyaripuway ari. Payka t'ucuwan onkoska, anchatataj ñac'arishan. Ashqha cutista ninamanpis yacumanpis urmaycun. ");
INSERT INTO quhNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Yachacojcunayquiman payta pusamorkani. Paycunarí mana thañichiyta aterkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesús cuticherka: —¡Ay, Diospi mana jap'icoj, nitaj payta casucoj runas! ¡Mayc'ajcamataj kancunawan casaj! ¡Mayc'ajcamataj kancunata muchuskayquichej! Wawata nokaman pusamuwaychej. ");
INSERT INTO quhNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesustaj chay uj supayta c'amispa wawamanta kharkorka. Wawataj chaymantapacha thañicaporka. ");
INSERT INTO quhNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Yachacojcunaka Jesús sapallan cashajtin payman kayllaycorkancu. Taporkancutaj: —¿Imaraycutaj chay supayta mana kharkoyta aterkaycuchurí? ");
INSERT INTO quhNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesustaj paycunaman cuticherka: —Kancunaka Diospi ancha pisillata jap'icuskayquichejraycu kharkoyta mana aterkanquichejchu. Chekamanta niyquichej. Uj mostaza mujitujina pisillatapis Diospi jap'icuwajchej chayka, atiwajchej camachiyta cay orkota wajnejman okharicunanta. Orkotaj okhariconka. Diospi chekata jap'icojtiyquichejka tucuy aticonka kancunapaj. ");
INSERT INTO quhNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Mana miqhuspa Diosmanta tucuy sonko mañacuyllawan chayjina supayka kharkocun. ");
INSERT INTO quhNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yachacojcunan cusca Galilea jallp'api cashajtincu Jesús paycunaman nerka: —Noka, Diospa cachaska Runan, paypa munayninmanjina chejnicoj runasman jaywaycuska casaj. ");
INSERT INTO quhNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Paycunari wañuchiwankancu. Quinsa caj p'unchaypitaj causarimusaj, —nispa. Chayta uyarispa yachacojcunan mayta phuticorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesús yachacojcunanwan Capernaum llajtaman chayarkancu. Yupaychana-wasipaj kolke jap'ejcuna kayllaycamorkancu Pedrota tapoj: —¿Yachachisojniyquichejka yupaychana-wasipaj kolke konata koncharí? ");
INSERT INTO quhNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Cuticherkataj: —Arí, kon, —nispa. Chanta Pedro wasiman yaycushajtin Jesuska ñaupajta nerka: —Simón, ¿imaynataj rijch'acusunqui? ¿Picunataj tasa kolketa chayrí impuestota cay pachapi camachejcunaman konancu canman? ¿Llajtancumanta cajcunachu? chayrí ¿waj llajtayojcunachu? ");
INSERT INTO quhNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedrori cuticherka: —Waj llajtayojcuna, —nispa. Jesustaj payman nerka: —Ajinaka llajtayojcunaka mana konancuchu tiyan. ");
INSERT INTO quhNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Astawanpis kolke jap'ejcunata ama phiñachinanchejpaj kolketa kosunchej. Kochaman challwata jap'ej riy. Anzuelota yacuman chokaycuy. Ñaupaj caj challwata jap'ispataj yacumanta orkhoy. Chay challwaj siminta quicharispa kolketa tarinqui. Chay kolketa apaspa nokamantawan kanmantawan kolke jap'ejcunaman komuy, —nispa nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ajinata parlashajtillancu yachacojcunaka Jesusman kayllaycuspa taporkancu: —¿Pitaj aswan curajpaj khawaska cashan Dios tucuyta camachin, chaypi? ");
INSERT INTO quhNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesuska uj wawata wajyaspa chaupincupi sayaycucherka. ");
INSERT INTO quhNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Nerkataj: —Chekatapuni niyquichej. Diosman cutirinayquichej tiyan cay wawajinaman tucuspa. Manachayrí Dios camachin, chayman manapuni yaycuyta atinquichejchu. ");
INSERT INTO quhNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Chayraycu runaka cay wawajina llamp'u sonkoyojman tucunan tiyan. Ajina llamp'u sonkoyoj cajllata Dios astawan curajpaj khawan pay camachin, chaypi. ");
INSERT INTO quhNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nokapi jap'icuskanraycu cay wawajina llamp'u sonkoyojta “walejta jamunqui”, nejka nokatapis niwan. ");
INSERT INTO quhNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","‘Pichari nokapi jap'icojcunamanta pisipaj khawaska cajcunata juchaman urmachinman chayka ¡ay phutiy, ari, chay runapajka! Paypajka aswan allin canman wañupunan uj jatun molino rumiwan cuncanpi warqhuycuska. Chaymantataj runas jatun kochapi may uqhuman chincaycuchiska canan. ");
INSERT INTO quhNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Ay, phutiy ari, cay pacha runaspajka juchaman urmachej imas caskanraycu! Chayjina urmachej imaska cananpuni tiyan. Astawanpis ¡ay, jatun phutiy ari, juchaman urmachej runapajka! ");
INSERT INTO quhNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","‘Maquiyquichus chayrí chaquiyquichus juchaman urmachisunquiman chayka, qhuchurpacuspa wijch'uy. Ñuc'upis chayrí ch'ulla chaquiyojpis wiñay causayniyoj canayqueka aswan allinpuni iscaynin maquisniyoj chayrí iscaynin chaquisniyoj uqhu pacha ninaman wiñaypaj wijch'uska canayquimantaka. ");
INSERT INTO quhNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ñawiyquitajchus juchaman urmachisunquiman chayka, orkhorpacuspa kanmanta wijch'uy. Ch'ulla ñawiyojpis wiñay causayniyoj canayqueka aswan allinpuni iscaynin ñawisniyoj uqhu pacha ninaman wijch'uska canayquimantaka. ");
INSERT INTO quhNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","‘Khawacushaychejpuni wawajina llamp'u sonkoyoj Diospi jap'icojcunata ama pisipaj khawanayquichejta. Chekamanta janaj pachapi Dios Tatayka tucuy paycunata wakaychashanpuni. ");
INSERT INTO quhNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Noka, Diospa cachaska Runanka, jamorkani Diosmanta chincaska runasta masc'aj juchasnincumanta cacharichinaypajtaj. ");
INSERT INTO quhNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","‘¿Imaynataj rijch'asunquichej? Uj runa pachaj ovejasniyoj carka. Ujnin ovejantataj chincachicunman chayka, ¿manachu isk'on chunca isk'onniyojta waj runawan orkopi miqhushajta sakerparinman? Chanta chay chincaska ovejanta masc'amoj rinman. ");
INSERT INTO quhNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Chincaska ovejanta taricaponka chayka, chekatapuni niyquichej mayta cusicunanta. Chay uj taricapuskanwan may astawanraj cusiconka chay isk'on chunca isk'onniyoj mana chincaska ovejasninmantaka. ");
INSERT INTO quhNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ajinallataj janaj pacha Dios Tatayquichej pisipaj khawaskacunamanta mana munanchu ni ujllapis wiñaypaj chincapunanta. ");
INSERT INTO quhNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","‘Cristopi hermanoyqui juchallicuspa sonkoyquita nanachinman chayka, riy sapallanpi juchanmanta reparachimuy. Casusunquiman chayka, payta yanapanqui amaña Diosmanta chincapunanpaj. ");
INSERT INTO quhNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mana casucojtinrí riyraj ujta chayri iscaytapis pusaricuspa. Ajinapi iscay chayrí quinsa willajtincu tucuy chay imaska sut'ita yachaconka. ");
INSERT INTO quhNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Chay runastapis nillataj casojtinrí Cristopi tantacojcunaman willay. Paycunatapis nillataj casunman chayka, kan payta khaway Diosta mana rejsej uj juchasapapaj. ");
INSERT INTO quhNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","‘Chekamanta imatachá cay pachapi khawaskayquichejmanjina yuyawajchej juchachanapajjina caskanta chayka, janaj pachapipis juchachaskallataj canka. Imatachá cay pachapi khawaskayquichejmanjina yuyawajchej mana juchachanapajjina caskanta chayka, janaj pachapipis manallataj juchachaskachu canka. ");
INSERT INTO quhNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","‘Chekamanta niyquichej cay pachapi iscay kancunamanta ima jawallapis uj sonkolla yuyawajchej chayka, ruwaska cananta. Chay yuyaskayquichejtataj Diosmanta mañacuwajchej chayka, janaj pacha Dios Tatayka ruwapusonkachej. ");
INSERT INTO quhNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Imaraycuchus maypichá iscay chayrí quinsa sutiypi tantacuncu chayka, noka paycunawan cusca cashani, —nispa nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Chanta Pedroka Jesusman kayllaycuspa nerka: —Señorníy, hermanoy contraypi juchallejtenka ¿mayc'a cutitataj perdonasaj? ¿Kanchis cutitacamachu perdonasaj? ");
INSERT INTO quhNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesustaj cuticherka: —Niyqui mana kanchis cuticamallachu perdonanayquita. Manachayrí ashqha cutista juchanta konkapuspa perdonanayquipuni tiyan. ");
INSERT INTO quhNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","‘Dios camachejtin, uj jatun camachejman rijch'acun. Chay camachejka camachisninman manuskan kolketa jap'icapuyta munarka. ");
INSERT INTO quhNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ajinata payka jap'icapuyta kallarisharka. Waranka warankas kolketa manu runatataj paypa ñaupakenman pusamorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Chay camachirí mana capuskanraycu mana aterkachu kolkenta cutichipuyta. Chayraycu chay jatun camachej camacherka: “Chay manu runa vendeska canan tiyan warminwan wawasninpiwan tucuy capuskanwanpis. Chaywan manunmanta uj pisillatapis jap'isaj”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Chanta chay manu camacheka jatun camachejman konkoricorka. Maytataj mañacorka: “Qhuyarillaway. Tucuy manuytaka cutichipullaskayqui”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Jatun camachejka manu camachinta mayta qhuyaspa cacharpariporka. Manuntapis perdonaporka. ");
INSERT INTO quhNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Llojsiytawancamarí chay camacheka uj camachi-masinwan tincorka. Chay camachi-masenka pisisitulla payman manu carka. Paytataj cuncanmanta sinch'ita jap'ispa k'allpirpanayasharka: “Uskhayta cutichipuway manususkayta”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Chanta chay camachi-masenka mayta c'umuycucorka. Nicorkataj: “Qhuyarillaway. Tucuy manuytaka cutichipullaskayqui”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Payrí manapuni munarkachu qhuyayta. Manachayrí manunta pusaspa carcelman wisk'aycucherka kopunancama. ");
INSERT INTO quhNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ajinata ruwaskanta ricuspataj camachi-masisninpa sonkon mayta nanarka. Paycunataj tucuy chay ruwaskanta jatun camachejnincuman willamorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Chanta jatun camachejka wajyachimuspa nerka: “¡Kanka sajra camachi canqui! Mayta nicuwajtiyqui tucuy jakay konawayquita perdonarkayqui qhuyasuspa. ");
INSERT INTO quhNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kanrí camachi-masiyquita ¿manachu qhuyanayqui carka noka kanta qhuyarkayqui ajinata?” nispa nerka. ");
INSERT INTO quhNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Jatun camachejka phiñacuspa chay sajra camachinta muchuchejcunaman jaywaycorka. ");
INSERT INTO quhNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","‘Sapa ujniyquichej tucuy sonkowan hermanoyquichejpa juchanta konkapuspa perdonanayquichej tiyan. Manachayrí janaj pacha Dios Tatayka chay sajra camachiwan imaynatachus camachejnin ruwarka ajinallatatajmin kancunawan ruwanka, —nispa nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Chay imasta parlayta tucuspa Jesús Galilea jallp'amanta riporka. Chaymantataj Judea jallp'aman jamorka Jordán mayu chimpan inti llojsimuynejman. ");
INSERT INTO quhNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Paytari may ashqha runas khatimorkancu. Chaypitaj paycunata onkoynincumanta thañicherka. ");
INSERT INTO quhNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Chaypi cashajtin waquin fariseo partecuna Jesusman kayllaycorkancu pantachinancupaj. Nerkancutaj: —Camachiwaskanchejmanjina ¿uj runa warminta uj imaraycullapis wijch'upuyta atillanchu? ");
INSERT INTO quhNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesustaj paycunaman cutichispa nerka: —Dioska cay pachata ruwaskanmantapacha kharita warmitawan ruwarka. Chayta Diospa palabranpi ¿manachu leerkanquichej? ");
INSERT INTO quhNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Nerka: “Chayraycu khareka tatanta mamanta sakenan tiyan warminwan ujchaska cananpaj. Iscaynincutaj ujlla cancu”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ajinaka manaña iscaychu cancu manachayrí ujllamanña tucupuncu. Chayraycu Diospa ujchaskantaka runa ama t'akachunchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Fariseo partecunaka payta nincu: —Moiseska camacherka pillapis warminwan t'akanacojka t'akanacuskancumanta uj divorcio papelta warminman konanta. ¿Imaraycutaj Moisés ajinata camacherkarí? ");
INSERT INTO quhNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesustaj paycunaman cutichin: —Moiseska warmiyquichejmanta t'akacunayquichejta sakellarka mana casuyta munajcuna caskayquichejraycu. Astawanpis Dios runata ruwaskanmantapachaka mana ajinachu carka. ");
INSERT INTO quhNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nokarí niyquichej pillapis warmin mana khenchachacojtin waj warmiwan casaracunman chayka, khenchachacuskanta. T'akaska warmiwan casaracojpis khenchachacullantaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yachacojcunantaj payman nincu: —Khariwan warminwan ajinata causanan cajtenka mana casaracuylla allenka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesusri nin: —Mana tucuychu cay niskayta entiendeyta atincu. Manachayrí pichari Dios yanapan, paylla entiendeyta atin. ");
INSERT INTO quhNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Waquin khareska nacecuncu mana wawayoj canancupaj. Waquintaj runas mana wawayoj canancupaj ajinaman tucuchincu. Waquinrí mana casaraska causayta ajllancu tucuy atiynincuwan Diosllapaj ruwanancuraycu. Ajinapi causaynincuta churancu Dios tucuyta camachinanpaj. Cay niskayta entiendeyta atejka chaymanjina causachun, —nispa nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Chanta waquin runas wawitasta Jesusman pusamorkancu. Munarkancu pay maquisninta paycunaman churaspa Diosmanta mañaripunanta. Yachacojcunantaj pusamojcunata c'amerkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesusrí nerka: —Sakeychej wawitasta nokaman jamunancuta. Amañataj paycunata jarc'aychejchu. Imaraycuchus Dios wawitajina cajcunata munacuywan camachin. ");
INSERT INTO quhNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Maquisninta wawitasman churaspataj Diosmanta mañaporka. Chanta chaymanta riporka. ");
INSERT INTO quhNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ajinamanta uj runa Jesusman kayllaycuspa tapurerka: —C'acha Yachachiwajníy ¿ima allin cajtataj ruwanay tiyan wiñay causayniyoj canaypaj? ");
INSERT INTO quhNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesustaj payman cuticherka: —¿Imaraycutaj allin cajmanta tapuwanquirí? Dios sapallan c'acha cajka. Wiñay causayniyoj cayta munanqui chayka, Diospa camachiskasninta casuy, —nispa nerka. ");
INSERT INTO quhNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Runataj tapun: —¿Maykencunatajrí? Jesusri cutichin: —Runata ama wañuchiychu. Ama khenchachacuychu. Ama suwacuychu. Runamanta ama willaychu llullacuspa. ");
INSERT INTO quhNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Mamayquita tatayquita casuy, jatunpaj khaway. Runa-masiyquitapis munacuy kan quiquiyquitajina, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Chay runaka payman cutichin: —Tucuy chaycunataka junt'ani. ¿Imatawanrajtaj ruwanay tiyanrí? ");
INSERT INTO quhNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesustaj payman nin: —Wiñay causayniyoj canapajjina cayta munanqui chayka, rispa tucuy capuyniyquita vendemuy. Chaymantataj chay kolketa wajcha runasman jaywaramuy. Chaymanta khepata janaj pachapi khapaj capuyniyoj canqui. Chantaka nokawan jamuspa yachacojniy cay, —nispa nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Chay runarí chay niskanta uyariytawan may phutiska riporka may khapaj caskanraycu iscayrayaspa. ");
INSERT INTO quhNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jesusri yachacojcunanman nin: —Chekamanta uj khapaj runaka ñac'aytapuni janaj pachaman yaycuyta atin. ");
INSERT INTO quhNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Chaywanpis niyquichej jatun camello uywaraj astawan atiskanta yaycuyta agujaj ningrinmanka khapaj runa janaj pachaman yaycunanmantaka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yachacojcunantaj chayta uyariytawan t'ucuspa ninacuncu: —Chanta ¿pitaj wiñay causayniyoj cayta atinmanrí? ");
INSERT INTO quhNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesustaj paycunata khawaycuspa nin: —Runacunapaj cayka mana aticojchu. Diospajrí tucuy aticun. ");
INSERT INTO quhNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Chaymanta Pedroka Jesusman cutichispa nin: —¡Khaway! Nokaycoka tucuy imata sakespa kanta khatiycu yachacojcunayqui canaycupaj. Chayraycu ¿imatataj jap'isajcurí? ");
INSERT INTO quhNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús paycunaman nin: —Noka, Diospa cachaska Runan, chekatapuni parlashayquichej. Tucuy imata mosojyachisaj. Chay p'unchaycunapitaj tiyaycucusaj camachinaypaj tucuy atiyniywan. Sapa ujniyquichejtaj uj camachina tiyanapi tiyacunquichej chunca israel ayllusta camachinapaj. ");
INSERT INTO quhNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Pichari nokapi jap'icuskanraycu sakejka wasisninta, chayrí hermanosninta, chayrí hermanasninta, chayrí tatanta, chayrí mamanta, chayrí wawasninta, chayrí chajrasninta chayka, wiñay causayniyoj canka. Chaywanpis payka pachaj cutistawan nokaraycu sakeskanmanta jap'icaponka. ");
INSERT INTO quhNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Astawanrí may ashqhas cunan jatunpaj khawaskas cajcuna khepata pisipaj khawaskas cankancu. Cunan pisipaj khawaskas cajcunataj khepata jatunpaj khawaskas cankancu. ");
INSERT INTO quhNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","‘Dios tucuyta camachejtenka uj sumaj patronjinamin canka. Chay patronka tutamanta llojserka llanc'ajcunata minc'acamoj. Chaymantataj uvas huertanpi llanc'anancupaj camacherka. ");
INSERT INTO quhNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Llanc'ajcunawantaj sumajta parlarka uj p'unchay llanc'askancumanta kopunanta. Chaymantataj paycunata huertanpi llanc'ajta cacharka. ");
INSERT INTO quhNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Chaupi pakarinjina llojsispa waj llanc'ajcunatawan ricorka. Chay llanc'ajcunaka llanc'ayta masc'ajcunaj tantacunancu chaypi sayacusharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Patronka paycunata nerkataj: “Kancunapis huertaypi llanc'aychej. Nokataj cajmanjina jornalta pagaskayquichej”, nispa. Llanc'ajcunari rerkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Watejmanta patronka llojsillarkataj chaupi p'unchaytajina. Quiquillantataj llanc'ajcunata pusamorka. Chaymantataj jatun tardetajina ajinata ruwarka. ");
INSERT INTO quhNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ujtawanpis masc'aj llojsillarkataj ch'isiyaytaña. Llanc'ayta masc'ajcunaj tantacunancu, chaypi wajcunatawan tarillarkataj. Paycunatapis nillarkataj: “¿Imaraycutaj tucuy cay p'unchayninta mana llanc'aspa sayacushanquichejrí?” ");
INSERT INTO quhNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Paymantaj nerkancu: “Mana pipis minc'awaycuchu llanc'apunaycupaj”, nispa. Payri paycunaman nerka: “Kancunapis huertaypi llanc'aychej”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Inti yaycuytataj patronka khawapoj runanman nerka: “Llanc'ajcunata wajyay kolketa paycunaman pagapunayquipaj. Khepa jamojcunaman ñaupajta koy. Chaymantataj ñaupaj jamojcunaman”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ch'isiyayllataña llanc'ajcuna tucuynin p'unchay llanc'askamantajina jap'erkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tucuy chay p'unchay llanc'ajcunarí yuyarkancu aswan ashqhata jap'inancuta. Astawanpis paycunaka ujcunajinallatataj jap'erkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Chanta chay tucuy p'unchaynintinta llanc'ajcunaka patronpa contranpi thutorkancu ");
INSERT INTO quhNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","nispa: “Chay ch'isiyayllata jamojcunaka uj horallata llanc'arkancu. Nokaycumanrí paycunamanjinalla pagapuwarkaycoka. Tucuynin p'unchayta manchay ruphaypi muchuspa llanc'arkaycoka”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Patrontaj ujnincuman cutichispa nerka: “Causaj-masíy, mana ch'auquiyashayquichu. ¿Manachu parlaskanchejmanjina pagapuyqui? ");
INSERT INTO quhNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Pagota jap'iskayquiwan kanka ripuy. Noka munani cay khepa jamojcunaman kancunamanjinallataj koyta. ");
INSERT INTO quhNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Manachu atiyman capuyniywan munaskaymanjina ruwaytarí? Chayrí ¿c'acha runa caskaymantachu phiñaska khawashawanqui?” ");
INSERT INTO quhNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ajinatamin khepa cajcunaka ñaupaj cajpi cankancu. Ñaupajpi cajcunataj khepapi cajcuna cankancu. Chekamanta Dioska ashqhasta wajyan. Ajllaska cajcunarí pisislla cancu. ");
INSERT INTO quhNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesuska Jerusalén llajtaman llojsisharka yachacojcunawan. Chay chunca iscayniyojllata ñanmanta wajnejman pusaspa nerka: ");
INSERT INTO quhNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Allinta reparaychej Jerusalén llajtaman rishaskanchejta. Chaypitaj noka, Diospa cachaska Runan, yupaychana-wasimanta curajcunaman yachachejcunamanwan jaywaycuska casaj. Paycunataj wañunaypaj juchachawankancu. ");
INSERT INTO quhNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Waj llajtayoj runasman jaywaycullawankancutaj. Chanta chay runaska asipayawankancu jasut'iwankancu, chacataycuwankancupis. Nokataj quinsa caj p'unchaypi causarimpusaj. ");
INSERT INTO quhNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Chanta Zebedeoj warmin wawasninwan Jesusman kayllaycorka. Konkoricuspataj nerka: —Uj imata niricuskayqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Paytaj nerka: —¿Imatataj munanquiri? Paytaj cuticherka: —Atiyniyquiwan camachinayquipaj tiyaycuspa churapuway cay iscay wawasniyta, ujnin pañayquipi ujnintaj llok'eyquipi sumajpaj khawaskas canancupaj. ");
INSERT INTO quhNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesusrí cuticherka: —Kancunaka mana yachanquichejchu imatachus mañaskayquichejta. Manchayta ñac'anay tiyan. Chayka uj jayawan junt'aska copajina. ¿Ñac'ariy wañunaycama nokajina muchuyta atiwajchejchu? Paycunataj nerkancu: —Arí, atiycu. ");
INSERT INTO quhNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesustaj paycunaman nerka: —Arí junt'a copata ujyanquichej nokajina. Wañuycama ñac'ariymantaj yaycunquichej nokajina. Nokawan cusca tiyaycucuspa camachinayquichejpajka ujta pañayman ujtataj llok'eyman churayka mana nokamantachu. Manachayrí picunapajchá waquicherka chaycunallata Dios tiyaycuchenka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tucuy chayta uyariytawan chunca yachacojcunaka phiñacorkancu chay iscay waukecunapaj. ");
INSERT INTO quhNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesusrí paycunata wajyaspa nerka: —Yachanquichejjina llajtasta camachejcunaka chaypi tiyacojcunata llaquichispa camachiskancuta. Llajtapi callpayojcunapis atiynincumanjina tucuy imapi casuchicuncu. ");
INSERT INTO quhNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kancunarí amapuni ajinaka caychejchu. Manachayrí kancuna uqhumanta atiyniyoj cayta munajka tucuy sonkowan yanapasojniyquichej canan tiyan. ");
INSERT INTO quhNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kancuna ughupi curajpaj khawaska cayta munajka casojniyquichej canan tiyan. ");
INSERT INTO quhNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Noka, Diospa ajllaskanka, mana runas yanapanawancupajchu jamorkani. Manachayrí noka runasta yanapanaypaj jamorkani. Astawanpis paycunaj wañunancumanta noka wañusaj juchancumanta cacharichinaypaj. Ajinallataj kancunapis canayquichej tiyan. ");
INSERT INTO quhNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesús yachacojcunanwan Jericó llajtamanta llojsishajtin ashqha runas payta khatisharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ñannejpi iscay ciego runas tiyacusharkancu. Jesús chaynejta puriskanta uyarispataj khaparerkancu: —¡Diospa ajllaskan, nokaycuta qhuyacuwaycu! ");
INSERT INTO quhNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Chay ashqha runastaj c'amerkancu: —Ch'in caychej, —nispa. Paycunarí aswan sinch'iwan khaparispa nerkancu: —¡Diospa ajllaskan, nokaycuta qhuyacuwaycu! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesús sayaricuspa paycunata wajyarka. Nerkataj: —¿Imatataj kancunapaj ruwapunayta munashanquichej? ");
INSERT INTO quhNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Paycuna cuticherkancu: —Señor, ricuyta munaycu. ");
INSERT INTO quhNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesusri qhuyacuywan ñawisnincuta llanqharerka. Chay quiquinpacha ricorkancu Jesusta khaterkancutaj. ");
INSERT INTO quhNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jesús yachacojcunanwan Jerusalén llajtaman kayllaspa Betfagé ranchoman chayarkancu. Betfageka Olivos niska orko kayllapi carka. Chanta Jesuska iscay yachacojcunata cachaspa, ");
INSERT INTO quhNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","nerka: —Riychej chimpa ranchoman. Chaypitaj uj china burrota malton burrowan wataskata tarinquichej. Phascaraspataj cayman khatimuychej. ");
INSERT INTO quhNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mayken tapusunquichejman chayka, niychej: “Señorninchej cay burrosta munan”, nispa. Cunitan cutichisonka. ");
INSERT INTO quhNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Chayka ruwacorka Diospa niskan junt'acunanpaj. Paypa unay willajnin palabranpi nerka: ");
INSERT INTO quhNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Cay pachapi Diospa llajtan Sionpi tiyacojcunata niychej: “Khawaychej, Camachisojniyquichej jamushan. Payka llamp'u sonkoyoj, malton burropi llok'aska. Chay malton burroka chajnana uywaj uñan”. ");
INSERT INTO quhNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Yachacojcunari rispa Jesuspa niskanmanjina ruwamorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","China burrota malton burrotawan Jesusman khatimorkancu. Ponchosta caronaycorkancu. Jesustaj chay malton burroman llok'arka. ");
INSERT INTO quhNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","May ashqha runastaj paycunallamanta ponchosta Jesuspa ñanninpi mast'arkancu. Waquinri sach'a ramasta c'utumuspa ñanninpi mast'arkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Chay ashqha runas waquenka Jesuspa ñaupakenta risharkancu, waquintaj khepanta. Khaparisharkancutaj: —¡Jatunchaska cachun Diospa ajllaskan! ¡Yupaychaska cachun Diospa cachamuska Runanka! ¡May jatunchaska cachun janaj pachapi caj Dioska! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesús Jerusalén llajtaman yaycojtin tucuy chay llajtapi tiyacoj runas mayta jataririspa mayta t'ucorkancu. Tapunacusharkancutaj: —Cay runa ¿pitaj canman? ");
INSERT INTO quhNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Chay ashqha runasri cutichinacusharkancu: —Diospa willajnin Jesusmin. Payka Galilea jallp'amanta Nazaret llajtayoj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Chanta Jesuska yupaychana-wasinpa pationman yaycorka. Chaypi tucuy vendejcunata rantejcunatawan jawaman kharkorka. Kolke trocajcunaj mesasnincuta tejrararka. Jaywana paloma ");
INSERT INTO quhNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","vendejcunaj tiyanancutapis tejrarallarkataj. Paycunamantaj nerka: —Dios palabranpi nin: “Yupaychana-waseyka nokamanta mañacuna wasimin canan tiyan”. Kancunarí pacaymanta suwanayquichejpaj ruwaycacapunquichej, —nispa, Jesús nerka. ");
INSERT INTO quhNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yupaychana-wasipitaj ciegos, wist'us Jesusman kayllaycorkancu. Jesustaj paycunata thañicherka. ");
INSERT INTO quhNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Jesuska chay onkoskasta thañichispaka uj t'ucuna imata ruwarka. Yupaychana-wasipipis wawaska mayta khaparisharkancu: “¡Diospa ajllaskan jatunchaska cachun!” nispa. Chay imasta uyarispa yupaychana-wasimanta curajcunawan yachachejcunawanka mayta phiñacorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jesusmantaj nerkancu: —¿Uyarinquichu cay wawacunaj nishaskancuta? Paytaj nerka: —Arí, kancunari ¿manachu jayc'ajpis Diospa palabranpi cayta leerkanquichej? Nin: Juch'uy wawitasta ñuñoj wawitastawan sumajta yupaychanancuta yuyaycharkanqui. ");
INSERT INTO quhNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Chanta Jesús runasta sakepuspa llajta jawa Betaniaman riporka. Betaniaka Jerusalén kayllapimin. Chaypitaj chay tuta khepacorka. ");
INSERT INTO quhNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tutamanta llajtaman cutimushaspa Jesuska yarkhachicorka. ");
INSERT INTO quhNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ñan kayllapi uj higo sach'ata ricuspataj chimpaycorka. Manataj tarerkachu higostaka, manachayrí laphisllata. Paytaj nerka: —Ni jayc'ajpis pokoyniyqui cachunchu. Chaymanta higo sach'aka ch'aquerpariporka. ");
INSERT INTO quhNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Yachacojcunanka chayta ricuspa t'ucorkancu. Tapucorkancutaj: —¿Imaynapitaj chaypachita cay higo sach'aka ch'aquirpariporka? ");
INSERT INTO quhNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesuska cutichispa nerka: —Noka niyquichej chekatapuni mana iscayrayaspa Diospi jap'icuwajchej chayka, higo sach'awan ruwarkani ajinata ruwaytapis atinayquichejta, chaymanta astawanpis. Sichus cay orkota niwajchej: “Caymanta okhariska cay, jatun kochamantaj wijch'uycuska cay” chayka, wijch'uycuska canka. ");
INSERT INTO quhNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Imallatapis tucuy sonkowan Diospi jap'icuspapuni mañacuwajchej chayka, chayta pay kosonkachej. ");
INSERT INTO quhNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yupaychana-wasi patioman yaycuspa Jesús yachachisharka. Ajinapitaj yupaychana-wasimanta curajcunawan israel curajcunapiwan Jesusman kayllaycorkancu. Taporkancutaj: —¿Pejpa atiyninwantaj cay imasta ruwanqui? ¿Pitaj cay imasta ruwanayquipaj atiyta kosorka? ");
INSERT INTO quhNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesustaj paycunaman cuticherka: —Kancuna uj tapuriynillayman cutichiwaychej. Chanta nokapis cutichiskayquichej ima atiywanchus chay imasta ruwashaskayta. ");
INSERT INTO quhNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Pitaj Juanta cachamorka runasta bautizananpaj? ¿Dioschu chayrí runaschu? Paycunapura unanchaspa ninacusharkancu: —Dios payta cachamuskanta nisunchej chayka, payka tapuwasunchej: “¿Imaraycutaj payta mana creerkanquichejchu?” ");
INSERT INTO quhNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Runaspa atiynincuwan niytarí, manchachicunchej llajtantin phiñacunanta. Imaraycuchus tucuy paycunaka Juanta sumajpaj khawaspa Diospa willajninpaj jap'icuncu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Chaymantataj Jesusman cutichispa nerkancu: —Mana yachaycuchu, —nispa. Paytaj nerka: —Ni nokapis willaskayquichejchu ima atiywanchus tucuy chayta ruwaskayta. ");
INSERT INTO quhNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús paycunaman parlashaspa nerka: —¿Imaynataj rich'asunquichej? Uj runa iscay wawasniyoj carka. Curaj cajman kayllaycuspataj nerka: “Wawáy, cunan p'unchay uva huertaypi llanc'amuy”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Chay wawanrí cuticherka: “Mana munanichu”, nispa. Khepamanta “mana” niskanmanta phuticorka. Chaymanta llanc'aj rerka. ");
INSERT INTO quhNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Uj caj wawawanman tatan kayllaycuytawan quiquillantataj nerka. Chay wawantaj cuticherka: “Ya, tatáy, llanc'amusaj”, nispa. Payrí mana llanc'aj rerkachu. ");
INSERT INTO quhNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Chay iscay wawasmanta ¿maykennincutaj tatancoj munayninta ruwarka? —taporka Jesús. Paycunari cuticherkancu: —Curaj caj wawan, —nispa. Jesustaj paycunaman nerka: —Chekamanta niyquichej manacajpaj khawaska impuesto jap'ejcunaraj khencha warmiswan Diospi jap'icuypi atipasuskayquichejta, pay camachin, chayman yaycunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Imaraycuchus bautizaj Juanka willasorkachej chekanta ruwaspa causanayquichejta. Kancunataj payta mana casorkanquichejchu. Impuesto jap'ejcunawan khencha warmiswanrí payta casorkancu. Astawanpis kancunaka Diosman cutiriskancuta ricuspapis Juanta mana uyarerkanquichejchu casunayquichejpaj. ");
INSERT INTO quhNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","‘Cay waj quiquinchanayta uyariychej. Carka uj patron. Paytaj uvasta jallp'anpi plantarka. Chaycunatataj perkawan muyucherka. Chaypi uj uva sarunata ch'irwanata ruwacherka uj alto wasitawan khawanapaj. ‘Chaymantataj chay jallp'anta pokoshajta jap'inancupaj llanc'ajcunaman sakeycorka. Payri caruman riporka. ");
INSERT INTO quhNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Uva pallana tiempo kayllamushajtintaj camachisninta llanc'ajcunaman cacharka uvasta jap'inancupaj. ");
INSERT INTO quhNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Llanc'ajcunarí camachista jap'iycorkancu. Ajinapi ujninta sinch'ita makaycorkancu. Ujninta wañucherkancu. Ujnintataj rumiswan ch'ankaycorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Patronka ujtawan waj camachisninta cachallarkataj. Chay ñaupaj cachaskanmanta astawan ashqha camachista cacharkapis. Llanc'ajcunari quiquillantataj paycunata ruwaycorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","‘Patronka sonkonpi nerka: “Wawaytaka jatunpaj khawankancupuni”, nispa. Chayraycu tucuy chay khepantaka wawanta llanc'ajcunaman cacharka. ");
INSERT INTO quhNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Llanc'ajcunari wawanta ricuytawan paycuna uqhu ninacorkancu: “Cay wawan jallp'ataka tatanmanta jap'enka. Chayraycu chay jap'inan jallp'ata jap'irparisun nokanchejpata cananpaj. Jamuychej payta wañuchinachej”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Chaymantataj paycunaka wawanta jap'ispa jallp'a jawaman wijch'orkancu wañucherkancutaj. ");
INSERT INTO quhNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ajinata niytawan Jesuska paycunata tapurerka: —Uva jallp'ayoj Señor cutimuspa ¿imanankataj chay llanc'ajcunatarí? ");
INSERT INTO quhNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Paycunataj cuticherkancu: —Chay sajra runastaka mana qhuyaspa wañurachenka. Jallp'antataj waj llanc'ajcunaman koponka. Uva pokojtincama jap'inanta tiemponpi llanc'ajcunaman chay jallp'anta konka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesusri paycunaman nerka: —¿Manachu jayc'ajpis Diospa palabranta leerkanquichej? Nin: “Wasichajcuna uj rumita khawaspa wijch'orkancu. Wasita sinch'ita sayachinanpaj chay wijch'uska rumeka aswan sumaj cashan tucuy waj rumismanta niskaka. Chaytaka Señor Dios ruwan, nokanchejpajtaj uj t'ucuna”. ");
INSERT INTO quhNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","‘Chayraycu niyquichej Dios camachin, chayman kancuna Israel llajtayojcuna, mana yaycuyta atinayquichejta. Dios camachin, chayman paypa munayninta ruwajcunalla yayconkancu. Ajinapi waj llajta canka pay camachinanpaj. ");
INSERT INTO quhNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Noka, Diospa cachaska Runan, wasi kallarina rumijinamin, cani. Ajinataj chay rumiman urmacoj runaka t'unaska canka. Pimanchari chay rumi urmanka payka ñut'uska canka. ");
INSERT INTO quhNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Yupaychana-wasimanta curajcunawan fariseo partecunawan chay quiquinchanata uyarerkancu. Repararkancutaj paycunawan Jesús chay imasta rijch'anachiskanta. ");
INSERT INTO quhNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Chayraycu imaynapipis payta jap'iycuchinancupaj mayta churacorkancu. Ashqha runastarí manchachicorkancu Jesusta Diospa willajninpaj khawaskancuraycu. ");
INSERT INTO quhNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesuska watejmanta quiquinchanaswan paycunaman parlarka. Nerka: ");
INSERT INTO quhNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Dios runasta munacuywan camachin, chayka uj jatun camachejman rijch'acun. Chay camachejka wawanpa casamientonta waquicherka. ");
INSERT INTO quhNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Chay casamiento fiestaman wajyaskacunata pusarimoj cachasninta cacharka. Chay wajyaskasrí mana jamuyta munarkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ujtawanpis camachejka waj camachisninta cachallarkataj. Paycunata nerka: “Wajyaskacunaman nimuychej jamullachuncuña casamientoman. Wirayaska bueyesniy uywasniypis ñac'askasña cancu. Miqhuna waquichiskaña cashan. Tucuy ima casamientopaj waquichiskaña”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Wajyaskacunarí payta khawarkancu manacajpaj. Waquenka chajrapi llanc'aj riporkancu. Waquinri rantej vendej riporkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ujcunataj camachisninta jap'ispa sinch'ita ñac'aricherkancu wañucherkancutaj. ");
INSERT INTO quhNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Chayta uyariytawan jatun camachejka phiñacorka. Soldadosnintataj cacharka chay runasta wañurachimunancupaj llajtancutapis ninawan ruphaycuchinancupaj. ");
INSERT INTO quhNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Chanta jatun camachejka cachasninman nerka: “Casamiento fiestaka waquichiska cashan. Wajyaskacunarí mana jamunancupajjinachu carkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Chayraycu riychej llajta calles, ñancunamanpis. Tucuy tariskayquichej runasta casamientoman wajyamuychej”. ");
INSERT INTO quhNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ajinataj ñancunaman rispa tucuy tariskancuta tantamorkancu allin runasta mana allin runastawan. Casamiento wasiri wajyaskacunawan junt'a carka. ");
INSERT INTO quhNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","‘Camachejtaj wajyaskacunanman sumaj p'achasta korka. Chanta wajyaskacunata khawarimunanpaj casamiento wasiman yaycorka. Chaypitaj mana casamiento p'achayojta uj runata ricorka. ");
INSERT INTO quhNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Chay runatataj nerka: “Amigo ¿imaynapitaj cayman mana casamiento p'achawan p'achalliska yaycumorkanquirí?” nispa. Chay runari ni imatapis cutichiyta aterkachu. ");
INSERT INTO quhNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Chanta camachejka casamientopi yanapajcunata nerka: “Chay runata chaquisninta maquisninta wataycuspa uqhu pacha lakhaman wijch'uychej. Chaypi phutiywan wakay, quiru c'arcucuypis muchunan canka”. ");
INSERT INTO quhNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Imaraycuchus ashqhas wajyaskas cancu. Ajllaska cajcunarí pisis cancu, —nispa nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Chaymanta fariseo partecunaka ripuskancutawan tantacamorkancu. Tantacuynincupitaj yuyarerkancu Jesusta parlaskanpi imaynapipis pantachiyta juchachanancupaj. ");
INSERT INTO quhNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ajinataj fariseoska yachacojcunancutawan Herodesmanta cajcunatawan Jesusman cacharkancu. Cachaskastaj Jesusta nerkancu: —Yachachej, yachaycu kanka cheka parlaj runa caskayquita. Yachaycutaj yachachiskayquita cheka cajta, Dios munan runas ruwanancutapis. Runata mana rijch'acuynillanmantachu khawanqui manachayrí caskancumanjina. Chayraycu paycunata mana manchachicunquichu. ");
INSERT INTO quhNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Cunanri niwaycu: ¿Imaynataj rijch'acusunqui? Nokanchej israelcuna ¿Romano gobiernoman impuesto kolketa konachu manachu? ");
INSERT INTO quhNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesusri sajra yuyaynincuta reparaspa paycunaman nerka: —Kancunaka ancha puraj uyas canquichej. ¿Imaraycutaj nokata pantachiwayta munanquichejrí? ");
INSERT INTO quhNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ricuchiwaychej impuesto kolketa, —nispa. Paycunataj kolketa jaywarkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesustaj paycunata tapurerka: —Cay kolkepi ¿pejpa uyan pejpa sutintaj cashanrí? ");
INSERT INTO quhNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Paycunataj cuticherkancu: —Romano curaj camachej Cesarpata, —nispa. Chaymanta Jesús paycunaman nerka: —Chayraycu Cesarpata cajtaka payman koychej. Diospata cajtataj Diosman koychej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Chay tapojcunaka chayta uyarispa mayta t'ucorkancu. Jesusta sakepuspataj riporkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Chay p'unchaypi saduceocuna Jesusman kayllaycorkancu. Paycunaka nej cancu wañuskacuna mana causarimunancuta. Jesustataj tapuycunancupaj nerkancu: ");
INSERT INTO quhNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Yachachej, Moiseska nerka uj casaraska runa warminwan mana wawayoj wañupunman chayka, chay wañuskaj waukenka viudawan casaranan tiyan wañuskaj sutinpi khari wawa cananpaj. ");
INSERT INTO quhNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Cay llajtaycupi kanchis waukes carkancu. Curaj caj waukeri casaraycucorka. Chaymantataj mana wawayoj wañuporka. Ajinapi viudaka wañojpa waukenwan casaracaporka. ");
INSERT INTO quhNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Chay iscay caj waukeka wañupullarkataj. Quinsa caj waukewanpis ajinallataj carka. Kanchisnintin waukes casaracuspa wañuporkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Khepanta chay viudapis wañupullarkataj. ");
INSERT INTO quhNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Chanta wañuskacuna causarimojtincu chay kanchismanta ¿maykennincoj warmintaj cankarí? Tucuynin waukes chay warmiwanka casararkancu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesusri paycunaman cuticherka: —Kancunaka mana entiendenquichejchu Diospa palabranta nitaj rejsinquichejchu atiynintapis. Chayraycu ancha pantaskas canquichej. ");
INSERT INTO quhNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Imaraycuchus causarimuskancu p'unchaypeka ni kharis nitaj warmis casaraconkancuchu. Manachayrí janaj pachapi angelesjina cancu. ");
INSERT INTO quhNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Wañuskacuna causarimunancumantari ¿manachu Diospa niskanta leerkanquichej? Dioska kancunaman nerka: ");
INSERT INTO quhNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Noka cani Abrahampa Diosnin, wawan Isaacpa Diosnin, allchhin Jacobpatapis Diosnintaj”, nispa. Chay runas unay wañupuskancu khepataña Dios chayta nerka. Chayraycu Dioska mana wañuskacunaj Diosnincuchu. Manachayrí causashajcunaj Diosnincu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ashqha runaska Jesuspa yachachiskanta uyarispa mayta t'ucorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Fariseo partecunaka yachaspa saduceo partecuna Jesusman manaña cutichiyta atiskancuta, tantacorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Chanta paycunamanta uj yachachejtaj Jesusta parlaskanwan pantachinanpaj tapurerka: ");
INSERT INTO quhNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Yachachej, Diospa camachiskasninmanta ¿maykentaj aswan curajrí? ");
INSERT INTO quhNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesusri cuticherka: —Señor Diosniyquita munacunayqui tiyan tucuy sonkowan tucuy causayniyquiwan tucuy yuyayniyquiwanpis. ");
INSERT INTO quhNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Chaymin Diospa camachiskasninmanta aswan curajtaj ñaupajtajka. ");
INSERT INTO quhNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Iscay caj camachiskanpis chay ñaupaj caj quiquillantaj: Runa-masiyquita munacuy kan quiquiyquitajina. ");
INSERT INTO quhNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Chay iscaynin camachiskasta chekanta casuspaka Moisespa camachiskantapis unay willajcunaj kelkaskancutapis casunchej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseo partecuna tantaska cashajtincuraj Jesucristo paycunata ");
INSERT INTO quhNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","tapurerka: —Kancuna ¿ima ninquichejtaj noka, Diospa ajllaskanmanta? Unay jatun tatay ¿pi caskantataj ninquichejrí? Paycunataj cuticherkancu: Camachej Davidmin unay jatun tatayqueka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Chanta Jesús paycunaman nerka: —Camachej Davidka Santo Espirituwan sut'inchaspa ¿imaynapitaj payta Señor Diosníy nerkarí? Ajinata nerka: ");
INSERT INTO quhNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Señorninchej Dios nerka Señorníy Cristoman: “Nokawan cusca tiyaycucuy camachinanchejpaj churanacojcunayquita k'alata atipanaycama”. ");
INSERT INTO quhNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","‘Davidka Cristota Señorninta sutichan. Chayraycu ¿imaynatataj Cristoka Davidpa wawallan canmanrí? ");
INSERT INTO quhNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ni pi ni uj simita cutichiyta aterkachu. Chay p'unchaymantapacha tucuy runas Jesusta uj imata tapuriyta manchachicorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Chanta Jesuska ashqha runasman yachacojcunanmanwan nerka: ");
INSERT INTO quhNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Israel yachachejcunawan fariseo partecunawanka Moisespa camachiskasninmanjina yachachishaskancuta yuyancu. ");
INSERT INTO quhNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Chayraycu Moisespa camachiskasninmanta tucuy nisuskayquichejta casuspa ruwaychej. Paycunaka simillancuwan camachiskasninmanjina ruwasunchej nincu causaynincupitaj wajjinata ruwancu. Kancunarí ama paycunajinaka caychejchu. ");
INSERT INTO quhNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Paycunaka yachachinasnincuta llasa k'epistajina waj runaspaj waquichincu. Chaytataj camachincu runasta ruwanancuta k'epistajina k'epirichispa. Paycunarí chay camachiskasnincuta ni casojllapis churacuncuchu. Nitaj runaspa k'episnincuta uj dedowanjinallapis yanapaj churacuncuchu. ");
INSERT INTO quhNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Paycuna tucuy imata ruwancu runasman ricuchinallancupaj. Diosta yupaychashaskancuta yuyaspa kelkaska churanasta apaycachacoj cancu. Chaycunatapis jatunyachincu. P'achasnincoj t'icasnintapis jatunyachincu. ");
INSERT INTO quhNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Jatun miqhunaspi munancu aswan sumajpaj khawaskacunaj tiyanasnincupi tiyacuyta. Tantacuna-wasispipis curajcunaj tiyanasnincupi tiyacuyta mayta munancu. ");
INSERT INTO quhNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Plazaspipis mayta munancu runaswan napaycuchicuyta. Runaswan jatunpaj khawaskas “yachachiwajníy”, nichicuytapis mayta munancu. ");
INSERT INTO quhNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","‘Kancunarí ama jatunpaj khawaska “yachachiwajníy”, nichicuychejchu. Imaraycuchus nokalla, Diospa ajllaskan, Yachachejniyquichejka cani. Tucuy kancunataj Diospajka uj rejlla canquichej. ");
INSERT INTO quhNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Cay pachapi ni maykenmanpis niychejchu “Tatáy” payta yupaychanayquichejpajka. Imaraycuchus ujllamin kancunaj Tatayquichejka. Payri janaj pachapi tiyacoj Diosmin. ");
INSERT INTO quhNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Runaswan amataj “Camachiwajníy” nichicuychejchu. Imaraycuchus nokallamin, Diospa ajllaskan, Camachejniyquichej cani. ");
INSERT INTO quhNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kancuna uqhupi curaj cajka yanapajniyquichej canan tiyan. ");
INSERT INTO quhNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Payllamanta jatunchacojka juch'uyyachiska canka. Llamp'u sonkoyoj cajrí jatunchaska canka. ");
INSERT INTO quhNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","‘¡Uj phutiy, ari, kancuna yachachejcunamanta fariseo partecunamantawan! Puraj uyas canquichej. Kancunaka yachachiskasniyquichejwan jarc'ashanquichej runasta ama casunancupaj Diosta camachejnincujina. Imaraycuchus kancuna Diosta mana casunquichejchu. Nitaj casuyta munajcunata sakenquichejchu casunancuta munacoj camachejnincujinaka. ");
INSERT INTO quhNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","‘¡Uj phutiy kancuna yachachejcunamanta fariseo partecunamantawan! Puraj uyas canquichej. Imaraycuchus kancunaka viuda warmicunamanta pisi capuynincuta suwaspajina khechushanquichej. Chayta pacanayquichejpaj Diosmanta anchata mañacunquichej. Chayraycu Dios kancunata astawan sinch'iwan juchachasonkachej. ");
INSERT INTO quhNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","‘¡Uj phutiy kancuna yachachejcunamanta fariseo partecunamantawan! Kancunaka kochanejta jallp'anejtapis muyumushanquichej. Ajinapi uj runallatapis kancunajman tijrayta munanquichej. Tijraskayquichejwan chay runaka iscay cuti astawan juchachaskaraj canka kancunamanta niskaka. Chayraycu uqhu pachaman rinanpajjina chay runaka cashan. ");
INSERT INTO quhNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","‘¡Uj phutiy kancunamanta! Kancunaka ciegos caspapis ujcunata pusaycachayta munanquichej. Diospa niskasninta mana reparaspa yachachishanquichej. Kancunaka ninquichej: “Pillapis yupaychana-wasej sutinta okharicuspa jurajka, niskanta mana junt'an, chaypis allillan. Yupaychana-wasipi korej sutinta okharicuspa jurajrí, niskanta junt'anan tiyan”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Kancuna mana yuyayniyojcuna ciegosjina canquichej! ¿Yupaychana-wasi cajtinchu koreka Diosman t'akaska? Chayrí ¿kori cajtinchu yupaychana-waseka Diosman t'akaska? ¿Maykentaj astawan cajrí? ");
INSERT INTO quhNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kancunaka nillanquichejtaj: “Jaywanata churanaj sutinta okharicuspa jurajka, niskanta mana junt'an, chaypis allillan. Chay jaywanaj sutinta okharicuspa jurajrí niskanta junt'ananpuni tiyan”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Kancuna mana yuyayniyoj ciegosjina canquichej! ¿Jaywanata churana cajka jaywana cajtinchu Diosman t'akaska? Chayrí ¿jaywanaka jaywanata churana cajtinchu Diosman t'akaska? ¿Maykentaj astawan cajrí? ");
INSERT INTO quhNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Reparaychej. Jaywanata churanaj sutinta okharicuspa jurajka tucuy chaypi cajcunaj sutinpiwan juran. Manataj jaywanata churanaj sutillanpichu juran. ");
INSERT INTO quhNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Reparaychej yupaychana-wasej sutinta okharicuspa jurajka chaypi tiyacoj Diospa sutinpi juraskanta. Manataj yupaychana-wasej sutillanpichu juran. ");
INSERT INTO quhNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Chaywanpis janaj pachaj sutinta okharicuspa jurajka Diospa tiyacunanpa sutinpi juran. Mana chay tiyanaj sutillanpichu juran. Manachayrí Diospa sutinpi juran chaypi tiyacuskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","‘¡Uj phutiy, arí, kancuna yachachejcunapajka fariseo partecunapajwan! Puraj uyas canquichej. Kancunaka yerba buenamanta, anismanta, cominomantapis ujta sapa chuncamanta Diosman koshanquichej. Diospa curaj caj camachiskasnintataj sakeporkanquichej. Chay curaj caj camachiskaska chekan ruway, qhuyacuy, Diospi jap'icuywan cancu. Caycunatamin ruwanayquichej tiyan ama chay ujcunata sakespa. ");
INSERT INTO quhNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Kancunaka ciegos caspa ujcunata pusaycachayta munanquichej! Ch'uspita orkhoshanquichej jatun uywa camellotataj okoycunquichej, yachachinasniyquichejta Diospa camachiskasninmanta aswan curajpaj khawaspa. ");
INSERT INTO quhNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","‘¡Uj phutiy, ari, kancuna yachachejcunamanta fariseo partecunamantawan! ¡Puraj uyas canquichej! Kancunaka vasota chuwatapis jawallanta mayllanquichej. Uqhuntarí sakenquichej mana llimphuchaspa. Ajinallataj chaycunaman rijch'acojlla canquichej. Sonkoyquichej suwaskayquichejwan khapaj cayta munapayaywan junt'a cashan. ");
INSERT INTO quhNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Ciegojina fariseo runa! Mana reparanquichu sonkoyqueka millay junt'a cashaskanta. Naupajta sonkoyquita llimphuchacuy. Ajinapi chekan ruwaj canqui. ");
INSERT INTO quhNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","‘¡Uj phutiy, ari, kancuna yachachejcunamanta fariseo partecunamantawan! Puraj uyas canquichej. Aya p'ampanasta runas yurajyachincu ama pipis mana yuyayllamanta chimpananpaj. Chay c'achitu yurajyachiska p'ampanasman rijch'acunquichej. Imayna aya p'ampanas uqhuntaj wañuska runaspa tullusninwan junt'a cancu ajinalla sonkoyquichejka tucuy laya millay cajwan junt'a cancu. ");
INSERT INTO quhNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kancuna runaspa ñaupakellancupi chekan ruwaj runasman tucushanquichej. Kancuna quiquiyquichejrí puraj uyas Diospa niskanta mana casojtaj cashanquichej. ");
INSERT INTO quhNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","‘¡Uj phutiy, ari, kancuna yachachejcunamanta fariseo partecunamantawan! Puraj uyas canquichej. Kancunaka unay wañuska willajcunata yuyarinapaj sepulturasta sayachishanquichej. Unay wañuska chekan ruwajcunapajpis sepulturasnincuta c'achachashanquichej. ");
INSERT INTO quhNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Kancunaka nishanquichej ñaupaj tatasninchej willajcunata wañuchiskancuta. Jakay p'unchaycunapi causasunman carka chayka, nokanchej mana tatasninchejjinachu ruwasunman carka. ");
INSERT INTO quhNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Chaywanka kancuna quiquiyquichej contrayquichejpi willacushanquichej willajcunata wañuchejcunaj wawasnin caskayquichejta. ");
INSERT INTO quhNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Tatasniyquichej ruwarka chaymanjina kancunapis tucunayquichejcama ruwanquichej! ");
INSERT INTO quhNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","‘¡Kancunaka runa wañuchi catarisjina canquichej! ¡Ancha pantachej, catarisjina sajras canquichej! ¡Uqhu pacha lauraypipuni ñac'arinayquichej tiyan! ");
INSERT INTO quhNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Chayraycu nokamanta willajcunayta Diosmanta yachayniyojcunatawan yachachejcunatawan cachamuskayquichej. Kancunarí cachamususkayquichejmanta waquinta wañurachinquichej chacatanquichejtaj. Wajcunatataj tantacuna-wasisniyquichejpi sek'onquichej. Chaywanpis paycunata ñac'arichinayquichejpaj llajtamanta llajta khatiycachanquichej. ");
INSERT INTO quhNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ajinapi juchachaskas canquichej tucuy mana juchancumanta wañuchiskas cajcunamanta Abelmanta Berequiaspa wawan Zacariascama. Payta kancunaj tatasniyquichej wañucherkancu yupaychana-wasipi jaywana churana kayllapi. ");
INSERT INTO quhNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Niyquichej chekamanta tucuy chay wañuchiskacunamanta cunan p'unchay runas juchachaskas canancuta. ");
INSERT INTO quhNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","‘¡Mayta phuticuni kancuna Jerusalénpi tiyacojcunamanta! Unaymantapacha Diospa willajcunanta wañuchejcuna canquichej, cachasninta ch'ankajcunapis. Imaynatachus wallpaka chillwisninta phurusnin uraman tantan, ajinallatataj nokapis ashqha cutista kancunata nokaman tantamuyta munarkayquichej. Kancunarí mana munarkanquichejchu. ");
INSERT INTO quhNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Chekatapuni Dios kancunaj yupaychana-wasiyquichejta sakerparipun. ");
INSERT INTO quhNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Chayraycu niyquichej cunanmantapacha manaña nokata ujtawan ricunayquichejta “Diosmanta cachaska jamojka jatunchaska cachun”, ninayquichejcama, —nispa nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesuska yupaychana-wasimanta llojsiytawan ripusharka. Yachacojcunari payman kayllaycorkancu yupaychana-wasita ricuchispa. ");
INSERT INTO quhNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Paytaj paycunaman cutichispa nerka: —¿Tucuy cay sumachej rumismanta wasista ricushanquichejchu? Chekamanta caycunaka k'alata urmachiskas cankancu. Nitaj uj rumillapis waj rumiwan sayashaj sakeskachu canka. ");
INSERT INTO quhNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Chanta Jesús Olivos orko patapi tiyaricuskantawan yachacojcunaka sapallancu payman kayllaycorkancu. Taporkancutaj: —Niwaycu ¿mayc'ajtaj tucuy chayka ruwaconkarí? ¿Ima ricuchinastaj canka cutimunayquimanta cay pachaj tucucunanmantawan? ");
INSERT INTO quhNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesustaj paycunaman cuticherka: —Sumajta khawacuychej ama pantachiskas canayquichejpaj. ");
INSERT INTO quhNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Arí, ashqhas llullacuspa sutiypi jamonkancu. Nenkancutaj: “Noka Diospa ajllaskan cani”, nispa. Ashqhasta pantarachenkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Reparaychej: Guerrasmanta waj guerra canayashallaskanmantataj uyarinquichej. Guerrasmanta parlajta uyarispapis ama manchachicuychejchu. Chay imaska canancupuni tiyan. Astawanpis manaraj tucucuyrajchu canka. ");
INSERT INTO quhNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Imaraycuchus uj ayllu waj aylloj contranpi okhariconka. Uj llajtayoj runas waj llajtayoj runaspa contranpi makanacunapaj okhariconkancu. Yarkhaycuna onkoycunapis canka. Jallp'apis caynejpi jakaynejpi qharcatitenka. ");
INSERT INTO quhNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tucuy chay imasri onkocoj warmej nanaynin kallarinajina sinch'i canka. Ajinata runas mayta ñac'arenkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","‘Chaypachamin sinch'i llaquichiskas canayquichejpaj jaywaycusonkachej wañuchisonkachejtaj. Chaywanpis tucuy runas yachacojcunay caskayquichejraycu chejnicusonkachej. ");
INSERT INTO quhNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ajina cajtinmin ashqhas Diospa cheka ñanninmanta urmaponkancu. Waquenka paycunapura ch'atanaconkancu. Waquintaj paycunapura chejninaconkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ashqha llulla willajcuna riqhurimonkancu. Ashqhastataj pantachenkancu paycunapi creenancupaj. ");
INSERT INTO quhNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Sajra causay junt'aycuskanraycutaj runas mana tucuy sonkowan munanaconkancuñachu. ");
INSERT INTO quhNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tucuy chay tucucunancama nokapi sinch'ita jap'icojrí juchamanta cachariska canka. ");
INSERT INTO quhNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Dios caypi cashan camachinanpaj, cay sumaj willanasnenka tucuy cay pachapi willaraska canka tucuy runas yachanancupaj. Chanta tucucuyka jamonka. ");
INSERT INTO quhNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","‘Diospa unay willajnin Danielka nerka Dios millachicun, chay thuñispa tucuchej cananta. Chayta leerkanquichej chayka, sumajta reparaychej. Imaraycuchus chay tucuchejta Diosman t'akaska cajpi cashajta ricunquichej. ");
INSERT INTO quhNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Chaypacha Judea jallp'api cashajcuna orkosman aykecuychej. ");
INSERT INTO quhNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Wasi jawapi cashajpis ama imata orkhoricojllapis wasinman yaycuchunchu. ");
INSERT INTO quhNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Chajrapi runaka wasiman p'achanta okharicoj ama cutichunchu. ");
INSERT INTO quhNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Phutiy ari, chay p'unchaycunapi wijsalliska warmispaj, ñuñushaj wawayojcunapajpis! ");
INSERT INTO quhNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kancunari Diosmanta mañacuychej ama para tiempopi aykecunayquichej cananpaj nitaj samacuna p'unchaypi. ");
INSERT INTO quhNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Imaraycuchus chay p'unchaycunapi manchay ñac'ariy canka. Cay pachaj kallaricuyninmanta cunancama mana carkachu chayjina ñac'ariyka nitaj jayc'ajpis cankachu. ");
INSERT INTO quhNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Chay ñac'ariy tiempota Dios mana pisiyachinman chayka, ni pi causanmanrajchu. Ajllaskasninraycurí Dioska chay ñac'ariy tiempota aswan pisiman pisiyachenka. ");
INSERT INTO quhNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","‘Sitajchus nisunquichejman: ¡Khawaychej caypi Diospa ajllaskan Cristo cashan! chayrí ¡Khawaychej, jakaypi cashan! Chayta ama creeychejchu. ");
INSERT INTO quhNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Imaraycuchus mana cheka caj cristo caspalla Cristojina riqhurimonkancu. Llulla willajcunapis riqhurimonkancu. Paycunaka sumachej ricuchinastawan sumachej t'ucunastawan ruwankancu. Aticunman chayka, chaywan Diospa quiquin ajllacuskasnintapis cheka cajmanta pantachinancupaj ruwankancu. ");
INSERT INTO quhNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Manaraj chayta ruwacushajtin ñaupajtaña nerkayquichej. ");
INSERT INTO quhNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Chayraycu nisunquichejman: “Khawaychej, jakay ch'innejpi Diospa ajllaskan cashan”, nispa chayka, ama chayman riychejchu. Chayrí nisunquichejman: “Diospa ajllaskan cay uqhupi pacaska cashan”, nispa chayka, chaytapis ama creeychejchu. ");
INSERT INTO quhNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Allinta yachaychej: Lliujlliojka inti llojsimuynejmanta inti yaycuynejcama c'ancharejtin tucuy runas ricuncu. Ajinallatataj cutimojtiy tucuy runas ricuwankancu. ");
INSERT INTO quhNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Maypichá aya cashan, chaymanmin alkamariska tantacuncu. ");
INSERT INTO quhNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","‘Chay ñac'ariskanmanta khepanta inteka lakhayaycaponka. Quillapis manaña c'anchamonkachu. Koyllurcunataj janaj pachamanta urmaramonkancu. Cielopi cajcunata Dios cuyuchenka: purichej callpapis pisiyaycaponka. ");
INSERT INTO quhNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Chanta noka, Diospa cachaska Runan, jatun ricuchinayta janaj pachapi ricuchisaj. Chaypachatajmin cay pacha tucuy ayllusmanta runaska pechoncuta tacacuspa wakankancu. Ñokataj atiywan may lliphipej c'anchaywantaj jamusaj. Runastaj ajinata janaj pachamanta phuyu patapi cutimushajta ricuwankancu. ");
INSERT INTO quhNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nokataj may sinch'i wakaj pututusniyoj angelesniyta cachamusaj. Paycunataj ajllacuskasniyta tucuy cay pacha kayllamanta carumantapis tantayconkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Cay higo sach'awan quiquinchanamanta yachacuychej. Higo sach'aj ramanka wawaramuspa laphisnin p'uturamun. Ajina cajtintaj yachanquichej k'oñi tiempoka chayamushaskantaña. ");
INSERT INTO quhNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ajinallataj kancunapis tucuy chay willarasuskayquichejta junt'askata ricuspaka yachaychej ñapis noka cutimushaskaytaña. ");
INSERT INTO quhNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Niyquichej chekamanta tucuy chayka ruwacunanta manaraj cay p'unchay runas wañurapushajtincu. ");
INSERT INTO quhNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Cielopis jallp'apis tucucaponkancu. Cay niskasniyrí mana tucucaponkachu. ");
INSERT INTO quhNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","‘Ima p'unchaychus ima horachus cutimunayta, ni pi yachanchu. Manamin janaj pachamanta cachamuska angelespis yachancuchu nitaj noka, Diospa Wawanpis yachanichu. Dios Tatalla yachan. ");
INSERT INTO quhNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Astawanrí imaynachus carka unay runa Noé causashajtin, ajinallataj canka noka, Diospa cachaska Runan, ujtawan riqhurimojtiy. ");
INSERT INTO quhNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Unay sinch'i para p'unchaycuna manaraj chayamushajtincu runaska miqhunasta miqhusharkancu. Machasharkancu casaracusharkancutaj. Ajinata causasharkancu Noé jatun barcoman yaycunan p'unchaycama. ");
INSERT INTO quhNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Chay runasrí mana reparacorkancuchu sinch'i para tucuy paycunata apacapunancama. Ajinallataj canka noka, Diospa cachaska Runan, cutimunaycama. ");
INSERT INTO quhNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Chaypachaka iscay runas chajrapi cankancu. Ujnin caj nokaman pusaska canka ujninri sakeska canka. ");
INSERT INTO quhNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Iscay warmis cusca maranpi cutashankancu. Ujnin nokaman pusaska canka. Ujninri sakeska canka. ");
INSERT INTO quhNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","‘Kancunaka manamin yachanquichejchu ima p'unchaychus noka Señorniyquichej cutimunaytaka. Chayraycu waquichiskas caychej. ");
INSERT INTO quhNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Sumajta reparaychej. Uj wasiyoj runa ima horatachus wasiman suwa jamunanta yachanman chayka, waquichicunman. Manataj sakenmanchu jusc'uspa wasiman yaycunantaka. ");
INSERT INTO quhNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ajinaka kancunapis waquichiskas caychej. Imaraycuchus ima horatachus mana suyanquichej cutimunayta, chay horata noka, Diospa cachaska Runan, cutimusaj. ");
INSERT INTO quhNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","‘Parlani uj chekanta junt'aj sumaj yuyayniyoj camachimanta. Patronnenka payta churarka wasinpi camachisninman horasninpi miqhuchinanpaj. ");
INSERT INTO quhNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","May cusiska chay khawapojka patronnin cutimojtin payta taripan ruwananta ruwashajta. ");
INSERT INTO quhNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Chekamanta patronnenka tucuy capuyninta khawapunanpaj chay camachita churanka. ");
INSERT INTO quhNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Sajra camachirí sonkonpi ninman: “Patronniyka khepaconkaraj”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Kallarintaj camachi-masisninta makaspa apaycachayta. Machajcunawantaj miqhoj ujyaj churacun. ");
INSERT INTO quhNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Mana suyaskan p'unchayta, mana yuyaskan horata patronnenka cutimonka. ");
INSERT INTO quhNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Camachintataj puraj uyacunawan cuscata sinch'ita nac'arichenka. Chaypitaj quiru c'arucuyta wakanka, —nispa nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","‘Ajinaka Dios wiñaypaj camachin, chaypi llanc'ajcunaka rijch'acuncu chunca sipascunaman. Paycunaka c'anchanasnincuta apaspa casaracoj runata suyaj rerkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Phishka sipascunari yuyayniyoj caspa waquichicorkancu. Phishka sipascunataj mana yuyayniyoj carkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Chay mana yuyayniyoj sipascunari c'anchasnincuta aparkancu, manataj kerosenta yapanancupaj aparkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Yuyayniyoj sipascunarí c'anchasnincuta aparkancu. Kerosentataj uj churanapi aparkancu yapanancupaj. ");
INSERT INTO quhNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Casaracoj runa runasninwan unayta khepacojtin puñuywan tucuynincu c'aywisharkancu puñurparerkancutaj. ");
INSERT INTO quhNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Chaupi tutaña cashajtintaj uj sinch'i khapariy uyaricorka: “¡Casaracoj runa jamushanña! ¡Taripamuychej payta!” ");
INSERT INTO quhNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Chanta tucuynin chay sipascuna rijch'arispa jataricorkancu. Chaymantataj c'anchanasnincuta waquicherkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Mana yuyayniyojcunarí nerkancu yuyayniyoj sipascunata: “Kerosenniyquichejmanta koriwaycu. C'anchanasniycu wañupushancuña”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Yuyayniyoj sipascunataj cuticherkancu: “Mana. Kosuyquichejman chayka, kancunapajpis nokaycupajpis pisinman. Astawanpis riychej vendejcunajman rantinayquichejpaj”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Paycuna rantej rinancucamataj casaracojka runasninwan jamorka. Waquichiska cajcunataj casaracoj runawan runasninwan ima casamiento wasiman yaycorkancu. Chaymantataj puncu wisk'acaporka. ");
INSERT INTO quhNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Khepamanta chay waj sipascuna chayamorkancu. Nerkancutaj: “¡Señorníy, Tatáy, puncuta qhicharimuwaycu!” nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Casaracoj runataj cuticherka: “Niyquichej chekamanta mana rejsiyquichejchu”. ");
INSERT INTO quhNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jesuska runasman nerka: —Chayraycu kancunapis rijch'ariskas suyaychej. Imaraycuchus mana yachanquichejchu noka, Diospa cachaska Runan, mayc'ajchus cutimunayta. Ima p'unchaychus ima horachus cutimunayta mana yachanquichejchu. ");
INSERT INTO quhNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","‘Chaywanpis nokaj camachinaypaj cutimunayka rijch'acun uj caruman rej patronman. Chay patronka ripushaspa camachisninta wajyarka. Chaymantataj capuyninta paycunaman jaywaycorka. ");
INSERT INTO quhNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Uj camachinman korka phishka warankajina kolketa. Ujmantaj korka iscay warankajina kolketa. Uj cajmantaj korka uj warankajina kolketa. Sapa ujman korka ruwayta atiskancumanjina. Chaymantataj caruman rerka. ");
INSERT INTO quhNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Chanta chay phishka warankajina kolketa jap'ejka rerka. Ajinaspataj chay kolketa sumajta purichimorka. Uj phishkatawantaj mirachimorka. ");
INSERT INTO quhNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ajinallataj chay iscay warankatajina kolketa jap'ejpis uj iscaytawan mirachimorka. ");
INSERT INTO quhNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Uj warankatajina kolketa jap'ejrí rerka. Ajinaspataj patronninpa kolkenta jallp'aman p'ampaskata pacaycamorka. ");
INSERT INTO quhNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","‘Chay camachicunaj patronnincoka ashqha watasmanta cutimorka. Chaymantataj patronka kolkemanta yachananpaj paycunawan parlarka. ");
INSERT INTO quhNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Payman chay phishka warankajina kolketa jap'ejka jamorka. Payri uj phishka waranka kolketawan apamorka. Patronninmantaj nerka: “Señor, phishka warankajina kolketa kowarkanqui. Khawaymá, uj phishkatawan mirachimuni”. ");
INSERT INTO quhNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Patronnintaj payta nerka: “Walejpacha, c'acha, junt'aj camachíy. Chay pisi kolkepi sumajta junt'arkanqui. Cunantaj ashqhamanwanraj ruwapunawayquipaj churaskayqui. Chaywanpis nokawan cusca cusicunayquipaj jampuway”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Chanta chay iscay warankajina kolketa jap'ejpis kayllaycamuspa nillarkataj: “Señor, iscay warankajina kolketa kowarkanqui. Khawaymá, uj iscay warankatawan mirachimorkani”. ");
INSERT INTO quhNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Patronnintaj nerka: “Walejta ruwarkanqui, c'acha, junt'aj camachíy. Chay pisi kolkepi sumajta junt'arkanqui. Cunantaj ashqhamanwanraj ruwapunawayquipaj churaskayqui. Chaywanpis nokawan cusca cusicunayquipaj jampuway”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Uj warankajina kolketa jap'ejpis kayllaycamuspa nerka: “Patronníy, rejsiyqui kanka ancha rumi sonko runa caskayquita. Mana tarpuskayquimanta cosechanquipis. Mana kanpata cajtapis jap'inqui. ");
INSERT INTO quhNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Chayraycu manchachicorkani. Kolkeyquitataj riytawan sumajta jallp'aman p'ampaskata wakaycharkani. Cayka kolkeyqueka. Jap'icapuy”. ");
INSERT INTO quhNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Patronnintaj payman cuticherka: “Khella, sajra camachi. Yacharkanqui mana tarpuskaymanta cosechaj caskayta, mana nokajta cajtapis jap'ej caskayta. ");
INSERT INTO quhNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Yachashaspa ¿imaraycutaj kolkeyta mirachejcunaman mana korkanquichu? Cutimuspa miraynintawan kolkeyta jap'icapuyman carka”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Chayraycu chaypi cajcunaman nerka: “Cay runamanta kolketa khechuychej. Chay chunca warankajina kolkeyojman kopuychej”, nerka patron. ");
INSERT INTO quhNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Imaraycuchus Diospa niskanta jap'icojmanka astawan koska canka. Manataj pisenkachu jayc'ajpis. Mana jap'icojmantarí pisi jap'icuskanpis khechuska canka. ");
INSERT INTO quhNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Cay manacaj camachitari jawa lakhaman wijch'umuychej. Chaypi wakaytawan quiru c'arucuytawan ñac'arenka, —nispa nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Nillarkataj: —Noka, Diospa cachaska Runanka, atiyniywan cutimusaj tucuy angelesta pusaspa. Chaypacha tiyaycusaj camachinaypaj tucuy atiyniywan. ");
INSERT INTO quhNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tucuy llajtasmanta runastaj ñaupakeypi tantaskas cankancu. Uj michejka ovejasta cabrasmanta t'akan. Ajinallatataj nokapis chekanta ruwaj runasta sajrata ruwaj runasmanta t'akasaj. ");
INSERT INTO quhNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Chekanta ruwajcunata pañayman churasaj. Sajrata ruwajcunata llok'eyman churasaj. ");
INSERT INTO quhNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Chanta noka, Camachej, pañaypi cajcunata nisaj: “Jampuwaychej, Dios Tataypa sumajpaj khawaskasnin. Cay pacha ruwacuymantapacha nokawan cusca kancuna camachinayquichejpaj waquichiska carka. Chayraycu cunan nokawan cusca camachiychej. ");
INSERT INTO quhNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Imaraycuchus yarkhachicojtiy miqhuchiwarkanquichej. Ch'aquichicushajtiy ujyanata kowarkanquichej. Forastero purishajtiypis wajyariwarkanquichej. ");
INSERT INTO quhNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","P'achamanta pisichicojtiy p'achata kowarkanquichej. Onkoska cashajtiy watucuwarkanquichej. Carcelpi wisk'aska cashajtiy watucoj jamuwarkanquichej”. ");
INSERT INTO quhNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Chanta chekata ruwaj runaska cutichiwankancu: “Camachiwajníy, ¿mayc'ajtaj yarkhachicojta ricususpa miqhucherkaycurí? Chayrí ch'aquichicushajtiyqui ¿mayc'ajtaj ujyacherkaycurí? ");
INSERT INTO quhNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Forastero purishajta ricususpa ¿mayc'ajtaj wajyarerkaycurí? Chayrí p'achamanta pisichicojta ricususpa ¿mayc'ajtaj p'achallicherkaycurí? ");
INSERT INTO quhNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Onkoskata ricucuspa chayrí carcelpi wisk'aska cashajtiyquipis ¿mayc'ajtaj watucoj jamorkaycurí?” nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Noka, Camachejnincutaj, paycunaman cutichisaj: “Chekamanta cay uj pisipaj khawaska hermanoypaj imallatapis ruwaporkanquichej chayka, nokapaj ruwapuwarkanquichej”. ");
INSERT INTO quhNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","‘Noka, Camachejnincoka, chanta nillasajtaj llok'eypi cajcunata: “Kancuna juchachaska cajcuna riychej caymanta. Supay Satanaspaj cachasninpajwan uqhu pachapi wiñaypaj lauraj nina waquichiska cashan. Chayman kancunaka riychej. ");
INSERT INTO quhNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Imaraycuchus yarkhachicojtiy miqhunata mana kowarkanquichejchu. Ch'aquiska cashajtiy yacuta mana jaywariwarkanquichejchu. ");
INSERT INTO quhNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Forasterojina purishajtiy mana wajyariwarkanquichejchu. P'achamanta pisichicojta ricuwaspa mana p'achallichiwarkanquichejchu. Onkoska cashajtiy, carcelpi wisk'aska cashajtiypis mana watucuwarkanquichejchu”. ");
INSERT INTO quhNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Chanta paycunaka cuticherkancu: “Camachiwajníy, ¿mayc'ajtaj yarkhachicojta ricususpa chayrí ch'aquiskata chayrí forastero purishajta, chayrí p'achamanta pisichicojta chayrí onkoskata chayrí carcelpi wisk'askata ricususpapis mana yanaparerkaycuchu?” ");
INSERT INTO quhNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Chanta noka, Camachejnincoka, paycunaman cutichisaj: “Pisipaj khawaska cajpaj imallatapis mana ruwaporkanquichejchu chayka, chekamanta nokapajpis mana ruwapuwarkanquichejchu”. ");
INSERT INTO quhNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Chayraycu kancunaka wiñay ñac'ariyman riychej. Chekanta ruwaj runasrí wiñay causayniyoj nokawan cankancu. ");
INSERT INTO quhNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesuska tucuy chay parlayta tucuytawan yachacojcunanman nerka: ");
INSERT INTO quhNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Yachanquichejjina iscay p'unchaycunamantawanka pascua p'unchaycuna canka. Noka, Diospa cachaska Runantaj, chay p'unchaycunata chacataska canaypaj jaywaycuska casaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Chaymantapachataj israel curajcuna tantacorkancu Caifás sutiyoj curaj camachejpa pationpi. ");
INSERT INTO quhNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Paycunataj yuyaychacorkancu llullacuspa Jesusta jap'iycuchiyta, chanta payta wañuchichiyta. ");
INSERT INTO quhNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Paycunarí ninacusharkancu: —Ama jatun p'unchaycunapeka, runas ama ch'ajwanancupaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesuska lepra onkoyniyoj niska Simonpa wasinpi casharka. Chay wasiri Betania llajtapi carka. ");
INSERT INTO quhNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Uj warmitaj Jesusman kayllaycorka. Payka nardomanta may c'achitu k'apayniyoj aceitejinata uj c'achitu rumi yuritupi junt'ata apamorka. Chay k'apajri ashqha kolkewan rantiska carka. Jesús mesapi tiyacushajtintaj chay warmeka chay c'achitu k'apajta umanman jich'aycuspa jawiycorka. ");
INSERT INTO quhNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yachacojcunaka chayta ricuytawan mayta phiñacorkancu. Taporkancutaj: —¿Imapajtaj cayjina usuchiska cashanrí? ");
INSERT INTO quhNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Cay c'achitu k'apajka ashqha kolkepaj vendecunman carka. Chay kolketaj wajcha runasman koska canman carka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesuska sumajta reparaspa niskancumanta paycunata nerka: —¿Imaraycutaj cay warmita llaquichishanquichej? Chayta ruwaspaka sumaj cajta nokapaj ruwapuwarka. ");
INSERT INTO quhNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Arí, wajcha runaska yanapanayquichejpaj cancupuni. Nokarí mana unaytañachu kancunawan casaj. ");
INSERT INTO quhNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Cay warmiri chay c'achitu k'apajwan cuerpoyman jich'aycuwaspaka khepata p'ampacuyniypaj ruwarka. ");
INSERT INTO quhNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Niyquichej chekamanta cay sumaj willanaska nokamanta tucuynej cay pachantinpi willarananta. Chay tucuynejpi cay warmej ruwaskanka willaska canka paymanta yuyaricunapaj, —nispa nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Chanta chunca iscayniyoj yachacojcunamanta ujnin caj rerka yupaychana-wasipi curajcunaman. Payri Judas Iscariote niska carka. ");
INSERT INTO quhNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Paycunaman nerkataj: —Noka Jesusta jaywaycuyquichejman chayka, ¿mashqha kolketataj kowanquichejman? Paycuna nerkancu: —Quinsa chunca kolkesta kosajcu, —nispa. Chaytataj payman korkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Judaska chaypacha mantapacha masc'asharka imaynapichus aswan allin canman Jesusta jaywaycunanta. ");
INSERT INTO quhNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Israel runaska jatun p'unchaycunancupi t'antata mana pokochinayojta miqhoj cancu. Ajinata yuyarej cancu imaynata Dios paycunata enemigosnincumanta cacharichiskanta. Ñaupaj caj p'unchaypitaj yachacojcunanka Jesusman kayllaycorkancu. Taporkancutaj: —¿Maypitaj waquichipusajcu yuyarina miqhunata miqhunayquipaj? ");
INSERT INTO quhNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesustaj nerka: —Llajtaman riychej. Chaypitaj uj runaman niychej: “Yachachiwajninchej nisunqui: Wañunay p'unchay kayllamushanña. Wasiyquipi yuyarina miqhunata yachacojcunaywan miqhuyta munani”. ");
INSERT INTO quhNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Yachacojcunantaj Jesuspa niskanmanjina ruwarkancu. Ajinataj yuyarina miqhunata miqhunancupaj waquicherkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Jesuska ch'isiyaycojtinña chunca iscayniyojcunanwan miqhunancupaj tiyaycucorka. ");
INSERT INTO quhNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Miqhushaspataj yachacojcunanta nerka: —Niyquichej chekamanta ujniyquichej kancunamanta nokata chejniwaj runasman jaywaycuwananta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Yachacojcunantaj ancha llaquiskas ujmanta uj payta taporkancu: —Señorníy ¿nokachu cayman? ");
INSERT INTO quhNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Paytaj cutichispa nerka: —Nokawan cusca t'antata chuwaman chhapun, chaymin nokata chejnicojcunaman jaywaycuwanka. ");
INSERT INTO quhNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Noka, Diospa cachaska Runanka wañoj rishani paypa palabranpi nokamanta niskanmanjina. ¡May phutiy, ari, nokata jaywaycojpajka! Aswan allin canman carka chay runapajka mana nacecunan. ");
INSERT INTO quhNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jaywaycoj risharka chay Judaska cuticherka: —Yachachiwajníy, ¿nokachu cayman? Jesustaj nerka: —Arí, kan ninqui, ajinapuni, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Miqhushajtincu Jesuska t'antata maquisninwan jap'erka. Chaymantataj Diosman graciasta korka. T'antata partispataj yachacojcunaman jaywarka. Nerkataj: —Cayta jap'iychej miqhuychejtaj. Cayka cuerpoy ninacun, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Chanta copata jap'ispa Diosman graciasta korka. Ajinaspataj yachacojcunaman jaywaspa nerka: —Tucuyniyquichej cay copamanta ujyaychej. ");
INSERT INTO quhNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Cay ujyanaka yawarniy ninacun. Jich'aska canka Diospa mosoj traton atiyniyoj cananpaj. Chayraycu causayniyta churani ashqha runaspa juchasnincuta wiñaypaj khechunaypaj. ");
INSERT INTO quhNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Chekamanta cay uvasmanta ruwaskata manaña ujyasajñachu kancunawan uj p'unchaycama. Chaypacha ujtawan mosojta ujyasaj kancunawan cusca Dios Tatay camachin, chayllapiña, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Diosta yupaychanapaj taquiytawantaj Olivos orkoman riporkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Chanta Jesuska yachacojcunanta nerka: —Cunan tuta tucuyniyquichej nokata sakerpayawanquichej. Imaraycuchus Diospa palabranpi nin: “Michejta wañuchisaj. Ovejastaj tropamanta ch'erkeraskas cankancu”. ");
INSERT INTO quhNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Wañuymanta causarimusparí Galileaman ñaupakeyquichejta risaj. ");
INSERT INTO quhNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedrotaj Jesusman cuticherka: —Tucuynincu kanta sakerpayancuman chayka, nokaka manapuni jayc'ajpis sakerpayaskayquichu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesuska payman nerka: —Niyqui chekamanta cunan tutapacha manaraj gallo wakashajtin nokata mana rejsiwaskayquita quinsa cutita ninqui. ");
INSERT INTO quhNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedrotaj nerka: —Kanwan cusca wañunay cajtinpis manapuni nisajchu kanta mana rejsisuskaytaka, —nispa. Tucuynin yachacojcunapis quiquinta nerkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Chaymanta Jesuska paycunawan Getsemaní huertaman chayamorka. Yachacojcunamantaj nerka: —Caypi tiyaricuychej noka jakaynejman rispa Diosmanta mañacamunaycama, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Chaymanta Pedrotawan Jacobotawan Juantawanpis pusaricuspataj sinch'ita llaquicaporka maytataj phuticuyta kallarerka. ");
INSERT INTO quhNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Chanta paycunaman nerka: —Manchay llaquiska cani, llaquiywantaj wañunayashaniña. Caypi suyaychej. Nokawan cusca rijch'ariskastaj wakaychacuychej. ");
INSERT INTO quhNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Uj tumpatawan ñaupaspa uyan pampacama c'umuycorka. Diosmanta mañacuspataj nerka: —Munaska Tatáy, cay ñac'ariypi wañunayka sichus aticun chayka, ama cachunchu. Astawanpis cayka mana nokaj munayniychu cachun. Manachayrí kanpa munayniyqui ruwaska cachun, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Quinsa yachacojcunan casharkancu, chayman cutimuspataj Jesuska paycunata puñushajta tariparka. Chaymanta Pedrota nerka: —Ajinaka ¿manachu uj ratullatapis nokawan cusca rijch'ariska wakaychacuyta atinquichej? ");
INSERT INTO quhNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Sumaj rijch'ariskas wakaychacuychej Diosmanta mañacuychejpuni ama juchaman urmachiskas canayquichejpaj. Chekamanta kancunaka allin cajta ruwayta munanquichej. Caypajrí mana callpayojchu canquichej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ujtawan rerka Diosmanta mañacuspataj nerka: —Munaska Tatáy, cay sinch'i ñac'ariypi wañunaypuni cashan chayka, kanpa munayniyqui ruwaska cachun, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ujtawan cutimuspa paycunata puñushajllatataj tariparka puñuywan atipaskas caskancuraycu. ");
INSERT INTO quhNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Paycunata sakespa quinsa cutitaña watejmanta Diosmanta mañaricoj rerka. Chaypipis quiquin palabrasllawantaj ujtawan mañacorka. ");
INSERT INTO quhNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Chantaña yachacojcunanman cutimuspa paycunata nerka: —¿Puñushallanquichejpunichu? Puñucullaychej. Uyariwaychej, horaka chayamunña. Noka, Diospa cachaska Runan, juchasapaspa maquisnincuman jaywaskaña cashani. ");
INSERT INTO quhNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Jataricuychej. Jacu ripuna. Khawaychej jaywaycuwajniyka kayllamushanña, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","48","Jesús parlashajtillanraj Judaska may ashqha runaswan kayllaycamorka. Payka chay chunca iscayniyoj Jesuspa yachacojcunanmanta carka. Chay ashqha runastaj jatuchej t'ujsina cuchilloswan, makana c'aspiswantaj jamorkancu cachamuska israel curajcunamanta yupaychana-wasimanta curajcunamantawan. Jaywaycojtaj chay ashqha runasta yachaycucherka: —Pitachá noka napaycuspa much'aycusaj, chay runata jap'iycuychej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judaska Jesusman kayllaytawan payta nerka: —Allin ch'isi cachun, Yachachiwajníy. Chaymantataj Jesusta may munacuywanjina much'aycorka. ");
INSERT INTO quhNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesustaj nerka: —Amigo, ¿imapajtaj jamunquirí? Chanta Jesusman kayllaycamuspa payta jap'iycorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ajinapi Jesuswan cajcunamanta ujnin caj jatun cuchillonta siq'iycorka. Yupaychana-wasimanta curajpa camachinta wajtaspa ningrinta c'uturparerka. ");
INSERT INTO quhNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Chanta Jesuska chay wajtajta nerka: —Cuchilloyquita wakaychananman churay. Yachanchej cuchillowan makanacojcunaka cuchillollawantaj wañuchiskas caskancuta. ");
INSERT INTO quhNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Noka atiyman Dios Tataymanta mañacuyta. Paytaj chay ratu janaj pachamanta chunca iscayniyoj waranka warankas angelesta churapuwanman. ¿Cayta manachu reparanqui? ");
INSERT INTO quhNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Diospa palabran nin ajina junt'acunan tiyan. Manachayka ¿imaynataj junt'acunan? ");
INSERT INTO quhNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Chaypacha Jesuska ashqha runasman nerka: —¿Uj runa wañuchi suwatajinachu nokata jap'ej jamuwanquichej? ¿Chayraycuchu jatun cuchilloswan makana c'aspiswan jamunquichej? Nokaka sapa p'unchay yupaychana-wasi patiopi yachacherkani. Kancunarí mana jap'iycuwarkanquichejchu. ");
INSERT INTO quhNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tucuy cay ruwacushan Diospa palabranpi unay willajcunan niskancuta junt'acunanpaj, —nispa nerka Jesús. Chanta tucuynin yachacojcunan payta sakerpayaspa aykecaporkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jesusta jap'iycojcunataj Caifaspaman pusariycorkancu. Chay Caifás yupaychana-wasimanta curaj runa carka. Paypa wasinpi tantaskas casharkancu israel yachachejcunawan curajcunawanka. ");
INSERT INTO quhNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedrorí carullamanta Jesusta khatisharka curajpa pationcama. Chay patiopitaj yanapajcunawan cusca tiyaricorka imaynapichus tucucunanta ricuyta munaspa. ");
INSERT INTO quhNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Tucuy jatun tantacuycunataj Jesusta wañuchiyta munasharkancu. Chayraycu Jesuspa contranpi llulla willajcunata masc'asharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ashqha runas jamorkancu llullacuspa willanancupaj. Willaskancurí manataj quiquinpunichu carka. Khepallantaña iscay willajcuna jamorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Nerkancutaj: —Cay runa nerka: “Atiyniyoj cani yupaychana-wasita urmachinaypaj, quinsa p'unchaypitaj watejmanta wasichanaypaj”, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Yupaychana-wasimanta curaj runataj sayarimuspa Jesusta nerka: —Cay runas nisuskancumanta ¿manachu cutichicunqui? ");
INSERT INTO quhNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesusri ch'inlla cacorka. Curajtaj payta nerka: —Causaj Diospa sutinpi camachiyqui: “Sichus kanka Diospa ajllaska Wawan, Cristo, canqui chayka, willawaycu, ari, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesustaj payta nerka: —Arí, niskayquimanjina, Diospa cachaska Runan cani. Cunanmantapachataj curaj atiyniyoj Dioswan cusca camachishajta ricuwanquichej, phuyus chaupipi atiyniywan janaj pachamanta jamushajtapis. ");
INSERT INTO quhNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Chanta curajka may phiñacuskanta ricuchinanpaj p'achasninta lliq'icorka. Nerkataj: —Cay runaka Diosta cayjinata phiñachiskanta uyarerkanquichejña. Manaña waj willajcuna paymanta willanancuta munanchejchu. ");
INSERT INTO quhNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Curajcunatataj tapurerka: —Kancunaman ¿imaynataj rijch'asunquichej? Paycunataj cutichispa nerkancu: —Cay runaka wañuchiska cananpajjina cashan. ");
INSERT INTO quhNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Chanta Jesusta uyanpi thokaycorkancu. Tacaspataj payta apaycachasharkancu. Waquinrí uyanpi sajmasharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Nisharkancutaj: —Diospa ajllaskan Cristo canqui chayka, sut'inchaspa willawaycu ¿pitaj sajmasorka? ");
INSERT INTO quhNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedrori chaycamaka jawa patiopi tiyacusharka. Ajinapitaj uj wasi camachi imilla payman kayllaycuspa nerka: —Kanpis chay Galilea llajtayoj Jesuspa masin canqui. ");
INSERT INTO quhNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedrorí tucuy chay runaspa ñaupakencupi mananchacuspa nerka: —Mana yachanichu imatachus parlashanqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pedro puncunejman rishajtin waj camachi imilla payta ricorka. Chaymantataj chaypi caj runasman nerka: —Cay runaka chay Nazaret llajtayoj Jesuswan purejmin, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pedrori watejmanta mananchacorka. Diospa sutinta okharicuspataj: —Mana rejsinichu chay runataka, —nerka. ");
INSERT INTO quhNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Uj chhicamantawan chaypi cajcuna Pedroman kayllaycorkancu. Nerkancutaj: —Chekamanta kanka Jesuswan purejcunamanta canqui. Parlaynillayquipi sut'i cashanqui. ");
INSERT INTO quhNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Chanta Pedroka kallarerka niyta: —¡Mana chekata parlani chayka, Dios wañuchiwachun! Chay runataka manapuni rejsinichu. Chay quiquinpachataj gallo wakarka. ");
INSERT INTO quhNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Chaymanta payka Jesuspa niskanta yuyaricorka: “Manaraj gallo wakashajtin quinsa cutita khesachawanqui nokata mana rejsiwaskayquita”. Ajinataj jawaman llojsispa sonko nanajta wakaycorka. ");
INSERT INTO quhNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","P'unchayarpamojtinña yupaychana-wasimanta tucuy curajcunawan israel curajcunawan tantacorkancu. Chay tantacuyka uj yuyayllata Jesuspa contranpi ninacorkancu payta wañuchichinancuta. ");
INSERT INTO quhNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jesustataj wataskata pusaspa camachej Pilatoman jaywaycorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jaywaycoj Judaska Jesusta juchachaska caskanta ricorka. Chayraycu payka sonkonpi mayta phuticorka. Chaymantataj chay jatun tantacuyman rispa quinsa chunca kolkesta cutiycuchiporka. ");
INSERT INTO quhNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Payri nerka: —Mana juchayoj runata wañunanpaj jaywaycuspa juchallicuni, —nispa. Paycunataj nerkancu: —¿Nokaycu ima ruwanaycu tiyanrí? Kanmantachá chayka. ");
INSERT INTO quhNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judastaj yupaychana-wasiman kolketa wijch'uycaporka. Chaymantataj rispa sipirpayacamorka. ");
INSERT INTO quhNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Yupaychana-wasimanta curajcuna chay kolketa okharispa nerkancu: —Camachiskanchejmanjina chay kolketa yupaychana-wasipaj mana churayta atinchejchu. Imaraycuchus uj runa wañunanpaj kolke carka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Chanta parlanacuspa chay kolkewan yuyarkancu c'analleroj jallp'anta rantiyta. Chay jallp'a forasterocuna p'ampacunancupaj canan carka. ");
INSERT INTO quhNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Chayraycu chay jallp'aka uj runaj wañuyninwan rantiska sutichaska carka. Cunan p'unchaycama ajina sutichaska cashan. ");
INSERT INTO quhNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ajinapi unay willaj Jeremiaspa niskanka junt'acorka. Payri Diospa palabranpi nerka: “Israelcuna quinsa chunca kolkesta jap'erkancu. Chay kolketa israelcuna uj yuyayman churacuspa korkancu Jesús jaywaska cananpaj. ");
INSERT INTO quhNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Chay kolkewantaj uj c'analleroj jallp'anta ranterkancu. Chayka Diospa camachiwaskanmanjinamin”. ");
INSERT INTO quhNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesustari camachej Pilatoj ñaupakenman aparkancu. Paytaj Jesusta taporka: —¿Kanchu israelcunaj camachejnincu canqui? Jesusri nerka: —Kan ninqui, ajinamin, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Jatun tantacuy runas mayta Jesuspa contranpi willasharkancu. Payri ni imata cutichicorkachu. ");
INSERT INTO quhNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Chayraycu Pilatoka nerka: —¿Imaymanata kanpa contrayquipi willacushancu? ¿Manachu uyarinqui? ");
INSERT INTO quhNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesusri ni uj simitapis payman cuticherkachu. Chayraycu Pilatoka mayta t'ucorka. ");
INSERT INTO quhNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Sapa wata camachejka chay jatun p'unchaycunapi uj wisk'aska runata cacharejpuni caj. Chaymanjinataj mañaskancuta uj wisk'aska runata paycunapaj cacharipunan caj. ");
INSERT INTO quhNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Chaypachataj uj mana allinpaj rejsiska runa wisk'aska casharka. Barrabás sutiyoj. ");
INSERT INTO quhNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ashqha runas tantaska cashajtincu Pilatoka nerka: —¿Maykentataj cacharipuskayquichej? ¿Barrabastachu chayrí Cristo niska Jesustachu? ");
INSERT INTO quhNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Imaraycuchus yacharka israelcuna envidiamanta Jesusta payman jaywaycuskancuta. ");
INSERT INTO quhNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Jesusmanta yuyashajtintaj Pilatoj warmin uj runata cachamorka ninanpaj: “Ama juchachaychu chay chekan runata. Khaway, cunan ch'isi moskoyniypi paynejta sinch'ita muchorkani”. ");
INSERT INTO quhNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tantacuypi tucuy curajcuna chay runasta yachaycucherkancu. Nerkancutaj: “Barrabasta cacharipunanta mañaychej. Jesustataj wañuchiska cananta niychej”. ");
INSERT INTO quhNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilatotaj paycunata taporka: —Cay iscay runasmanta ¿maykentataj cacharipuskayquichej? Paycunataj cuticherkancu: —Barrabasta cacharipuwaycu. ");
INSERT INTO quhNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatori paycunaman nerka: —Cristo niska, chay Jesusta ¿imanasajtajrí? Tucuynincu cuticherkancu: —¡Chacataska cachun payka! ");
INSERT INTO quhNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatotaj nerka: —¿Imaraycutaj? ¿Ima mana allintataj ruwarkarí? Paycunataj astawan sinch'iwan khaparerkancu: —¡Chacataycuy paytaka! ");
INSERT INTO quhNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatoka repararka chay runasta mana ch'in yachiyta atinanta. Astawan astawan ch'ajwa canayashaskanraycutaj yacuta apachimorka. Chaymantataj runaspa ñaupakencupi maquisninta mayllacorka. Nerkataj: —Cay runaj wañuyninmanta mana juchayojchu cani. Kancuna imanamuychejpis. ");
INSERT INTO quhNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tucuynincu chay runaska cuticherkancu: —¡Chay runaj wañuyninmanta nokaycu wawasniy cuwanpacha juchayoj casajcu! ");
INSERT INTO quhNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Chanta Pilatoka Barrabasta cachariporka paycunapaj. Jesustataj jasut'ichispa chay runasman jaywaycorka chacataska cananpaj. ");
INSERT INTO quhNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Chanta camachejpa soldadosnenka Jesusta apaycorkancu camachejpa tiyacuna-wasinman. Chaymantataj paycunaj masisnincu tantaycucorkancu Jesusta muyuycuspa. ");
INSERT INTO quhNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ajinaspataj Jesuspa p'achasninta lluch'orkancu. Chanta camachejtajina puca p'achawan p'achalliycucherkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Pilluta qhishcamanta simp'aspataj Jesuspa umanman churaycorkancu. Asicunancupajtaj paña maquinman camachejmanjina uj sokosta churarkancu. Paypa ñaupakenman konkoricuspa nerkancu: —¡Viva israelcunaj camachejnincu! ");
INSERT INTO quhNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Payta thokaycorkancu. Paymanta sokosta jap'ispataj umanpi wajtasharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Payta asipayaytawanka chay puca p'achata lluch'orkancu. Chaymantataj p'achasninta p'achalliycuchipuspa pusarkancu paytaka chacatanapaj. ");
INSERT INTO quhNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Soldados llajtamanta llojsishaspaka uj Cirene llajtayoj runawan tincorkancu. Paypa sutinri Simón carka. Paytataj camacherkancu Jesuspa cruzninta k'epinanta. ");
INSERT INTO quhNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ajinaspa t'ojlu caskan, chay Gólgota lugarman chayarkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Chaypitaj vinota jayak'ewan chajruycuspa payta korkancu ujyananpaj. Jesusri mallirispa mana ujyarkachu. ");
INSERT INTO quhNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Soldadostaj Jesusta chacatarkancu. Chanta suerteta chokarkancu yachanancupaj pipajchus Jesuspa p'achasnin cananta. Ajinapi unay willajpa niskanka Jesusmanta junt'acorka: “Suertesta chokaspa p'achasniyta partinacorkancu”. ");
INSERT INTO quhNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Chaypi soldadoska tiyaycucuspa sumajta khawasharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jesuspa umanpa patannejpitaj uj kelkaskata churarkancu imamantachus chacataska caskanta willanancupaj. Chaytaj nin: “Caymin Jesuska, israelcunaj camachejnin”. ");
INSERT INTO quhNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Chaypitaj Jesuswan iscay runa wañuchi suwas chacataskas casharkancu. Uj suwaka paypa pañannejpi, uj caj suwataj llok'ennejpi casharka. ");
INSERT INTO quhNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Chayninta purejcunataj millayta c'amisharkancu payta. Umancuta qhiwirispa asipayanancupaj ");
INSERT INTO quhNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","nisharkancu: —¡Kanka, yupaychana-wasita urmachej, chaymanta quinsa p'unchaypitaj watejmanta sayarkochej, quiquiyquita cacharichicuy! Diospa Wawan canqui chayka, chay cruzmanta uraycamuy, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ajinallataj yupaychana-wasimanta curajcunawan, israel yachachejcunawan, waj curajcunawan asipayasharkancu Jesusta. Ninacusharkancutaj: ");
INSERT INTO quhNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Cay runaka wajcunata cacharicherka. Pay quiquinrí nitaj atinchu cacharichicuyta. Israelcunaj camachejnincu canman chayka, cruzmanta uraycamuchun cunitan. Chayta ricuspataj nokaycupis creesajcu pay Camachej caskanta. ");
INSERT INTO quhNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Diospi payka atinicorka, “Diospa Wawan cani”, nispa. Chayraycu cunitan payta cruzmanta cacharichichun, sichus chekamanta Dios payta munacun chayka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Paywan cusca chacataska suwaspis quiquillantataj payta c'amisharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Chaupi p'unchaymanta chaupi tardecama tucuy jallp'a lakhayaycorka. ");
INSERT INTO quhNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Chaupi tardetajinataj Jesuska sinch'ita khaparicorka: —¿Elí, Elí lama sabactani? Khapariskan niyta munan: Diosníy, Diosníy, ¿imaraycutaj sakerpariwanquirí? ");
INSERT INTO quhNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Waquin chaypi cajcunamanta chayta uyarispa nerkancu: —Cayka unay willaj Eliasta wajyacushan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Chay quiquinpacha ujnincu paycunamanta uskhayta rispa uj esponjata jap'erka. Chayta c'allcu ujyanaman chhaporka. Chaytataj uj sokosman churaspa Jesusman jaywarka ch'onkananpaj. ");
INSERT INTO quhNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Waquinrí nisharkancu: —Suyay. A ver, ricusunchej, Elías jamonkachus payta cruzmanta cacharichej. ");
INSERT INTO quhNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesús watejmanta sinch'ita khaparicorka. Causayninta tatanpa maquisninman jaywaycuspataj tucucaporka. ");
INSERT INTO quhNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Yupaychana-wasipi warqhuska caj khatanaka patamanta uracama iscayman lliq'icorka. Jallp'ataj qharcatiterka. Rumispis quichacorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","P'ampanas quicharicorkancu. Diospi jap'icuspa wañuska cajcunajta ashqhaspata ayasnincu causarichiskas carkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Paycunaka p'ampanasmanta llojsiporkancu. Jesús causarimuskanmantataj Jerusalén llajtaman jamorkancu. Chaypitaj ashqha runasman riqhurerkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Romano camachej, soldadosninwan, Jesusta wakaychasharkancu. Paycunataj jallp'a qharcatitishajta chay waj imas ruwacushajtawan ricorkancu. Chayraycu mayta manchachicuspa nisharkancu: —Chekamanta cay runaka Diospa Wawan carka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Chaypi casharkancu ashqha warmis caritullamanta khawacamusharkancu. Paycunari Jesusta Galilea jallp'amanta khatimoj carkancu payta yanapanancupaj. ");
INSERT INTO quhNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Paycuna uqhu carkancu Magdala llajtayoj María, Jacobojta Josejtawan mamancu, waj Mariapiwan. Chaywanpis Zebedeoj wawasninpa mamancupis paycuna uqhupi carka. ");
INSERT INTO quhNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ch'isiyaycojtinña uj khapaj runa, José sutiyoj, jamorka Arimatea ranchonmanta. Paypis Jesusta khaticojcunamanta carka. ");
INSERT INTO quhNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Payka Jesuspa cuerponta mañaj Pilatoman rerka. Chanta Pilatoka camacherka soldadosta Joseman jaywanancuta. ");
INSERT INTO quhNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josetaj cuerponta apacapuspa okharerka. Linomanta uj llimphu awaskawan mayt'orka. ");
INSERT INTO quhNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Paypata carka uj mosoj aya p'ampana. Chaytaka pay uj jatun kakapi unayña ruwachicorka. Chayman Jesuspa cuerponta churaycorka. Chaymantataj chay puncuman uj jatun p'alta rumita muyuchispa wisk'aycorka. Ajinaspataj riporka. ");
INSERT INTO quhNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Chaypitaj casharkancu María Magdalenawan chay uj caj Mariapiwan. Paycunaka chay p'ampanaj chimpannejpi tiyaycusharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Israelcunaj samacuna p'unchaynincupaj waquichicunancu caj. Samacuna p'unchaypitaj yupaychana-wasimanta curajcunawan fariseo partepiwan tantaycucorkancu. Chaymantataj Pilatojman rispa ");
INSERT INTO quhNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","nerkancu: —Señor, chay pantachej runaka causashaspallaraj, “Wañuskaymanta quinsa p'unchaymanta causarimpusaj”, niskanta yuyaricuycu. ");
INSERT INTO quhNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Chayraycu camachiy p'ampananta sumajta wakaychanancuta quinsa p'unchaycamallapis. Yachacojcunanpis cuerponta suwaj jamushancumanchá. Paycunaka suwaytawan runasman nincuman: “Wañuskacunamanta causarimporka”, nispa. Cay pantachiyka chay ñaupaj pantachiymanta aswan mana allinchu canman. ");
INSERT INTO quhNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatoka paycunata nerka: —Cay soldadosta pusacuychej. Riychej. Atiskayquichejta p'ampananta sumajta wakaychamuychej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ajina paycunaka rerkancu. P'ampana rumita sumajta wisk'arkancu ama ni pi t'ojpinanpaj. Soldadostataj wakaychanancupaj churarkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Samacuna p'unchay k'ayantin Domingo p'unchay sut'iyamusharka. Ajinata Magdala llajtayoj Mariawan chay uj caj Mariapiwan sepulturaman khawaj jamorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Jallp'ataj mayta qharcatiterka. Chayka carka Señor Diosmanta cachamuska uj angel janaj pachamanta uraycamuskanraycu. P'ampanaman kayllaycuspa chay jatun rumita wajnejman muyurparicherka. Chay rumi patapitaj tiyaycucorka. ");
INSERT INTO quhNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Rijch'acuynenka lliuj-lliujjina c'ancharisharka. P'achasnintaj rit'ijina yuraj carka. ");
INSERT INTO quhNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","P'ampanata wakaychajcunataj manchaymanta qharcatitisharkancu wañuskajinataj tucorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Diosmanta angeltaj chay warmista nerka: —Amaña manchachicuychejchu. Yachani kancunaka chacataska carka, chay Jesusta masc'ashaskayquichejta. ");
INSERT INTO quhNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Payka manaña caypichu imaraycuchus niskanmanjina causarimporka. Jamuychej Jesuspa wañuska cuerpon churaska carka, chayta khawanayquichejpaj. ");
INSERT INTO quhNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Yachacojcunanman uskhayta riychej. Willamuychej Jesuska wañuskanmanta causarimpuskantaña. Cunantaj kancunaj ñaupakeyquichejta Galilea jallp'aman rishanña. Jakaypitaj payta ricunquichej. Chayta kancunaman nerkayquichej nimunayquichejpaj, —angel nerka. ");
INSERT INTO quhNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Warmistaj p'ampanamanta uskhay uskhayllata riporkancu. Paycunataj manchay manchaylla jatun cusiywantaj riporkancu. Correrkancutaj yachacojcunanman willaj. ");
INSERT INTO quhNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ajinallapi Jesuska paycunaman riqhurerka. Napaycorkataj: —Buenos días, mamacuna, —nispa. Paycunataj Jesusman kayllaycuspa chaquisninta mayta jap'iycorkancu. Ajinaspataj payta yupaycharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Chanta Jesuska paycunata nerka: —Amaña manchachicuychejchu. Riychej hermanosniyman willampuwaychej Galileaman rinancuta. Jakaypi tincuwankancu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Chay warmis rishajtincutaj waquin wakaychajcunaka llajtaman jamorkancu. Jamuspataj paycunaka tucuy ima ruwacuskanta yupaychana-wasimanta curajcunaman willarkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Chaycunallataj curajcunapiwan tantaycucuspa wakaychajcunaman kolketa konancupaj yuyaychanacorkancu. Ajinataj ashqha kolketa orkhocuspa wakaychajcunaman lluq'iycorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Nerkancutaj: —Niychej curajcunaman: Nokaycu puñuskas cashaskaycuycamaka Jesuspa yachacojcunan tuta jamuskancu. Cuerpontataj suwacapuskancu. ");
INSERT INTO quhNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Jatun camachej cayta yachanman chayka, nokaycu paywan parlasajcu kancunapaj allin cananpaj. Kancunaka mana llaquicunayquichejchu canka, —nispa curajcuna nerkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ajinataj wakaychajcuna kolketa jap'icorkancu. Yachaycuchiskancumanjinataj nerkancu. Chay parlayta israelcunaka cunancama parlancu. ");
INSERT INTO quhNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Chunca ujniyoj yachacojcunanka Galilea jallp'aman rerkancu. Jesús rinancuta camacherka, chay orkoman rerkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jesusta ricuytawan yupaycharkancu. Waquinrí iscayrayasharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesustaj paycunaman kayllaycuspa nerka: —Janaj pachapipis cay pachapipis camachinaypaj Dios Tatay tucuy atiyta kowan. ");
INSERT INTO quhNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Chayraycu kancunaka riychej tucuy runasman. Paycunata yachachimuychej yachacojcunay canancupaj. Diospata caskancuta ricuchispa bautizaychej Dios Tataj sutinpi, nokaj, Dios Wawaj sutiypi, Santo Espíritoj sutinpiwan. ");
INSERT INTO quhNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Jap'icojcunatataj sumajta yachachimuychej tucuy camachiskayta ruwanancuta. Reparaychej nokaka sapa p'unchay kancunawanpuni casaj cay pacha tucucuycama. Ajina cachun.");
INSERT INTO quhNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Diospa Wawan Jesucristomanta sumaj willanaska cayjinata kallaricun. ");
INSERT INTO quhNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Dios unay willajnin Isaiaspa kelkaskanpi willarka Wawan Cristota cachamunanta. Wawan jamunanpajtaj willajninta cachamunanta nerka, runaspa sonkoncuta waquichinanpaj. Willajnintaj ñaupajta jamunan carka. ");
INSERT INTO quhNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Paymantataj nin: Ch'in pampapi uj runa khaparishan: “Uj jatun camachej jamojtin runas ñanninta waquichincu, purinasnintapis chekanta ruwancu. Ajinallatataj sonkoyquichejta Diospa Wawan jamunanpaj waquichicuychej”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ajinataj bautizaj Juanka ch'in pampapi riqhurimorka. Runasmantaj willaspa nerka: —Juchasniyquichejta k'alata sakespa bautizacuychej. Chaywan ricuchinquichej Diosman cutiricuskayquichejta juchasniyquichejta pay khechunanpaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ashqha runas tucuy Judea jallp'amanta Jerusalén llajtamantapis payta uyarinancupaj chayamoj cancu. Juchasnincuta willacojtincutaj Jordán mayoj yacusninpi Juanka paycunata bautizaj. ");
INSERT INTO quhNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juantaj camello millmamanta p'achawan p'achallicoj. Kara chumpiwantaj chumpicoj. Langostasta monte misq'itawan miqhoj. ");
INSERT INTO quhNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Payka willaraj: —Khepayta nokamanta uj aswan atiyniyoj jamushan. Nokaka mana paypa camachinpajjinallapischu cani, runalla caskayraycu. ");
INSERT INTO quhNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nokaka yacullawan bautizashayquichej. Payrí kancunata bautizaspa Santo Espirituta cachamusonkachej Diosllapaj causanayquichejpaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Chay p'unchaycunapi Jesuska Nazaret llajtamanta jamorka. Nazaretka Galilea jallp'api carka. Juantaj Jordán mayupi payta bautizarka. ");
INSERT INTO quhNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yacumanta llojsimushaspataj Jesuska ricorka janaj pachata quicharicushajta. Santo Espiritutapis paloma rijch'aypi payman uraycamushajta ricorka. ");
INSERT INTO quhNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Janaj pachamanta Diostaj nimorka: —Kanmin munaska Wawayka canqui. Kanwanmin may cusiska cani, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Khepanpachataj Santo Espíritu sumaj callpanwan Jesusta ch'in pampaman pusarka. ");
INSERT INTO quhNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tawa chunca p'unchaycunata cacorka, q'ita animalespis cancu, chaypi. Supay Satanasri tucuy imata ruwasharka Jesusta juchallichinanpaj. Manataj payta juchallichiyta aterkachu. Diospa angelesnintaj jamuspa Jesuspa pisichicuskanta jaywarkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Bautizaj Juanta jap'iycuspa wisk'achiskancumantaña Jesuska Galilea jallp'aman rerka. Chaypi Diospa sumaj willanasninta willararka. ");
INSERT INTO quhNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Nerkataj: —Diospa ajllaskan p'unchayka cunan chayamushanña. Cunan payka munacoj Camachejniyquichej canka. Chayraycu juchasniyquichejta sakespa payman cutiricuychej sumaj willanasnintataj jap'icuychej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesuska Galilea kocha cantonnejta purishaspa ricorka Simonta wauken Andrestawan. Paycunaka challwasta jap'inancupaj ch'ipasta kochaman churasharkancu, challwiris caskancuraycu. ");
INSERT INTO quhNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesusri paycunata nerka: —Nokawan jamuychej. Kancuna challwa jap'ejcuna cashanquichej. Cunanmantapachataj Diosman runasta pusamojcuna cayta yachachiskayquichej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Chay quiquinpachataj ch'ipasnincuta sakerpayaspa Jesusta khaticorkancu yachacojcunan canancupaj. ");
INSERT INTO quhNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Tumpatawan riskanpitaj Jesús ricorka Zebedeoj wawasninta. Paycunaka Jacobo wauken Juanwan carkancu. Ch'ipasta t'irispataj barconcupi casharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesusri paycunatapis wajyarka yachacojcunan canancupaj. Ajinapi paycunaka Jesusta khaticorkancu tatancu Zebedeota sakespa. Llanc'ajcunapis Zebedeowan barcopi carkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesús yachacojcunanwan Capernaum llajtaman chayarkancu. Samacuna p'unchay cajtintaj Jesuska tantacuna-wasiman yaycuspa runasta yachachiyta kallarerka. ");
INSERT INTO quhNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Paycunataj yachachiskanmanta t'ucorkancu niskasnin atiywan caskanraycu. Manataj israel yachachejcunajinallachu yachacherka. ");
INSERT INTO quhNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Jesús yachachishajtintaj uj millay supayniyoj runa riqhurimuspa tantacuna-wasincupi khaparerka: ");
INSERT INTO quhNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Jesús Nazaret llajtayoj ¿imamantaj chapucuwaycu? ¿Tucuchinawaycupajchu jamunqui? Sumajta yachani pichus caskayquita. Kan Diospa santo Cajninmin canqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesusrí sinch'iwan camacherka supayta: —¡Ch'in cay! Llojsiy paymanta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Chay millay supayri runata t'ucuta jap'icherka. Sinch'ita khaparichispataj supayka paymanta llojserka. ");
INSERT INTO quhNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tucuy chaypi cajcunari mayta t'ucorkancu tapunacusharkancutaj: —¿Imataj cayrí? ¡Cayka waj mosoj yachachiymin atiyniyojtaj! Chaywanpis supaycunatapis camachin, paytataj casuncu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Jesusmantataj tucuynejpi runas uskhayta uyarerkancu, tucuy Galilea jallp'a muyuynintinpi. ");
INSERT INTO quhNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Chaymanta tantacuna-wasimanta Jesús llojserka Jacobowan Juanwan. Yaycorkancutaj Simonpa Andrespawan wasincuman. ");
INSERT INTO quhNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simonpa suegranka sinch'i k'oñi onkoywan siricusharka. Jesús yaycuskantawantaj chaypi cajcuna payman onkoskamanta willarkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesustaj payman kayllariytawan maquinmanta jap'ispa jataricherka. Chay quiquinpachataj k'oñi onkoymanta thañichiska carka. Miqhunatataj paycunaman jaywarka. ");
INSERT INTO quhNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ch'isiyaycuyta inti yaycuskanmantaña runaska tucuy onkoyniyojcunatawan supayniyojcunatawan Jesusman pusamorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Chay llajta runastaj tucuynincu wasi puncuman tantacamorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ashqha onkoska runasta tucuy laya ñac'arichiskasta Jesuska thañicherka. Ashqha runasmantataj supaycunata kharkorka. Supaycunari payta rejserkancu. Chayraycu Jesuska mana parlarejta sakerkachu. ");
INSERT INTO quhNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tutallataraj manaraj sut'iyamuyta Jesús jatarispa llojserka. Ch'innejman rispataj jakaypi Dios Tatanwan parlasharka mañacuypi. ");
INSERT INTO quhNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simonri chay waj yachacojcunawan Jesusta masc'amoj llojserkancu taripanancucama. ");
INSERT INTO quhNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Payta tarispataj nerkancu: —Yachachejníy, tucuy masc'ashasuncu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Payri nerka: —Jacu rina kayllapi caj llajtasman chaypi willaranaypaj. Chaypajmin cay pachaman jamorkani, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ajinamanta tucuy Galilea llajtasman rispa tantacuna-wasisnincupi Jesús willaraj. Runasmanta supaycunatapis kharkoj. ");
INSERT INTO quhNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Uj cuti Jesusman jamorka uj manchay lepra onkoyniyoj runa. Konkoricuspa mayta mañacorka: —Sichus munanqui chayka, thañichiway. Yachani atiyniyoj caskayquita, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesustaj may qhuyacuywan payta jap'irerka. Nerkataj: —Munani. Thañiskaña canqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Onkoyniyoj runataj chay quiquinpacha thañiska carka. ");
INSERT INTO quhNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Sinch'ita camachispa Jesús payta cachaporka. Nerkataj: ");
INSERT INTO quhNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—¡Uyariway! Ama ni pimanpis thañichisuskaymanta willaychu. Astawanrí chekanta riy Jerusalenman yupaychana-wasipi ruwanayojman. Kan quiquiyqui sumajta khawachicamuy paywan. Chaymanta Moisespa camachiskanmanjina jaywanata komuy. Ajinapi thañicuskayquita yachaconka, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Payrí llojsipuspaka Jesusmanta anchata willarayta kallarerka. Thañicuskanmantapis tucuynejpi parlasharka. Chayraycu Jesuska pacayllamantaña llajtasman yaycoj. Llajta jawa ch'innejcunapitaj cacoj. Chaywanpis tucuynejmanta runas payman jamullarkancupuni. ");
INSERT INTO quhNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Khepata ujtawan Capernaum llajtaman Jesús cutiporka. Runastaj uyarerkancu wasipi cashaskanta. ");
INSERT INTO quhNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Chayraycu ashqha runas payman tantaycacamorkancu. Ajinapitaj campoka manaña carkachu puncu jawapipis. Jesustaj paycunaman Diospa niskanta willasharka. ");
INSERT INTO quhNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Chaypachitataj tawa runas riqhurimorkancu uj mana cuyurej runata Jesusman wantumuspa. ");
INSERT INTO quhNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Chay ashqha runas chaypi cashaskancuraycutaj Jesusman chimpaycuchiyta mana aterkancuchu. Chayraycu tejasta orkhorkancu wasi patapi uj jusc'uta ruwanancupaj Jesús casharka chay chekanpi. Chay jusc'unejtataj mana cuyurej runata callapunpi wantuspa Jesuspa ñaupakenman uraycucherkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesuska cayta ricuspa repararka paycuna tucuy sonkowan creeskancuta onkoskata pay thañichinanta. Chayraycu runaman nerka: —Wawáy, juchasniyqui kanmanta khechuskaña, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Waquin israel yachachejcunamanta chaypi tiyashajcuna sonkoncupi tanteyacusharkancu: ");
INSERT INTO quhNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—¿Imaraycutaj cay runaka ajinata parlashanrí? ¡Diosta phiñachishan! Dioslla juchasta khechuytaka atin, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesuska sonkonpi paycunaj tanteyacuskancuta yachaspa nerka: —Amaña sonkoyquichejpi ajinata tanteyacuychejchu. ");
INSERT INTO quhNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Cay runaman nejtiy “juchayqui khechuskaña” nispaka, mana ricunquichejchu chekachus manachus caskantaka. Astawanrí cay mana cuyurej runata jatarichiyman chayka, ricuwajchej. ");
INSERT INTO quhNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Noka, Diospa cachaska Runan caspa, cay pachapi atiyniyoj cani juchasta khechunaypaj. Chayta yachanayquichejpaj, cay mana cuyurej runata nini: ");
INSERT INTO quhNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Kanta niyqui: Jataricuy, callapuyquita okharispa ripuy wasiyquiman, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Chay quiquinpachataj tucuypa ñaupakencupi mana cuyurejka jatarerka. Callapunta okharispataj llojsiporka. Ajinamanta tucuy runas mayta t'ucorkancu. Diosta yupaychaspataj nisharkancu: —¡Manapuni ni jayc'ajpis cayjinataka ricorkanchejchu! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ujtawan Galilea kocha cantoman Jesús llojserka. Tucuy chay may ashqha runastaj payman jamorkancu, paycunatataj yachachisharka. ");
INSERT INTO quhNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Chaymanta Jesús purishaspa Alfeoj wawan Levita ricorka impuesto jap'inanpi tiyashajta. Payta nerkataj: —Yachacojniy cay, —nispa. Levitaj jatarispa Jesusta khaticorka. ");
INSERT INTO quhNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Wasinpitaj miqhunapaj Jesús tiyacusharka yachacojcunanwan. Paycunawan ashqha impuesto jap'ejcunapis juchasapaspaj khawaska runaspiwan tiyacusharkancu, ashqhas paycunamanta Jesusta khaticuskancuraycu. ");
INSERT INTO quhNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Juchasapaswan, impuesto jap'ejcunawan miqhushajta ricuspataj, waquin israel yachachejcuna fariseo partemanta yachacojcunanta taporkancu: —Yachachejniyquichej impuesto jap'ejcunawan, juchasapaswan cusca miqhun. ¿Imaynataj cayrí? ");
INSERT INTO quhNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Chayta uyarispa Jesús paycunaman nerka: —Onkoska runaslla medicotaka munancu, manataj sano runaska. Mana jamorkanichu chekan cajcunata wajyaj. Manachayrí juchasapasta wajyaj jamorkani, paycuna sajra ruwaskasnincuta sakespa Diosman cutiricunancupaj, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Bautizaj Juanpa yachacojcunan fariseocunawan ñaupa yachachinamanjina ayunaj cancu. Runastaj Jesusman jamuspa payta taporkancu: —Juanpa yachacojcunan fariseocunaj khatejcunancupis ajllaska p'unchaycunapi ayunancu. ¿Imaraycutaj kanpata mana ayunancuchu paycunajina? ");
INSERT INTO quhNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesustaj paycunaman cuticherka: —Casamientoman wajyaskacunaka casaracoj khari paycunawan cashanancama cusiywan miqhuncupuni. ");
INSERT INTO quhNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Khepan p'unchaycunapi casaracoj khareka paycunamanta khechuska canka. Chaypacha yachacojcunayka phutiywan mana miqhonkancuchu. —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Jesustaj nerka: —Sichus pipis uj mauc'a p'achaman uj manaraj k'entiska remiendota siranman chayka, mosoj remiendo mauc'a p'achata aysaspa astawan lliq'inman. ");
INSERT INTO quhNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Sitajchus pipis mosoj pokoshaj vinota mauc'a vino churana karasman churanman chayka, pokoshaj vinoka phatarparichinman mauc'a karastaka. Ajinamanta vinoka usunman vino churana karaspis usullanmantaj. Astawanpis mosoj vinotaka mosoj karasman churana tiyan. Ajinallataj mosoj yachachiypipis mosoj ruwanas canan tiyan —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Uj samacuna p'unchaypi Jesús trigo chajra chaupinta risharka. Purin purintaj yachacojcunan trigo umasta muruyta kallarerkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Fariseosrí Jesusta taporkancu: —¡Uyariy! ¿Imaraycutaj yachacojcunayqui samacuna p'unchaypi chay mana ruwana cajta ruwashancurí? ");
INSERT INTO quhNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesusri cuticherka: —¿Manachu leerkanquichej unay tatayquichej Davidpa ruwaskanmanta? Chay p'unchaycunapeka yupaychana-wasimanta Abiatar curajka casharka. Davidka runasninwan ima pisichicuspa yarkhachicorka. ");
INSERT INTO quhNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Chayraycutaj yupaychana-wasiman yaycorka. Abiatarka Diosman t'akaska t'antata Davidman korka. Camachiskapeka nin, chay t'antataka yupaychana-wasipi ruwanayojcunalla miqhunancuta. Davidrí chay t'antata miqhuycorka runasninmanpis kollarkataj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Fariseosmanri Jesuska nerka: —Runaj allinninpajmin Dioska samacuna p'unchayta churarka. Manataj samacuna p'unchayta jatunchanallanpajchu runataka ruwarka. ");
INSERT INTO quhNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nokari, Diospa cachaska Runan, atiyniyoj cani camachinaypaj imatachus ruwanata samacuna p'unchaypipis, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesuska ujtawan tantacuna-wasiman yaycorka. Chaypitaj uj maquin wañuska runa carka. ");
INSERT INTO quhNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Chaypi cajcunamanta waquinri Jesusta sinch'ita khawasharkancu. Samacuna p'unchaypi runata thañichinmanchus manachus, chayta munasharkancu yachayta. Chayraycutaj watekasharkancu imallapipis payta juchachanancupaj. ");
INSERT INTO quhNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesusri maquin wañuska runata nerka: —Sayaricuy runaspa ñaupakencupi, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Watekaj runasman nerkataj: —Ujta tapuriyquichej. ¿Samacuna p'unchaypi imatataj runa ruwanan tiyan? ¿Allin cajtachu chayrí sajra cajtachu? ¿Runasta yanapanatachu chayrí paycunata wañuchinatachu? Paycunataj ch'inlla carkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesuska phiñacuywan ujta ujta khawarka rumi sonkoyoj caskancuraycutaj llaquicorka. Maquin wañuska runatataj nerka: —Maquiyquita aysariy, —nispa. Maquinta aysariskantawantaj thañicaporka. ");
INSERT INTO quhNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tantacuna-wasimanta fariseoska llojsiytawancamataj Herodesta khatejcunawan tantacorkancu. Paycunaka Jesuspa contranpi parlanacorkancu imaynamantapis payta tucuchinancuta. ");
INSERT INTO quhNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ajinamanta Jesús yachacojcunanwan riporka Galilea kocha kayllanejman. May ashqha runastaj Galilea jallp'amanta payta khaterkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jamorkancutaj Judea jallp'amanta, Jerusalén llajtamanta, Idumea jallp'amantawan. Aswan carumantapis jamullarkancutaj, Jordán mayu chimpamanta, chaywanpis Tiro, Sidon llajtaspa muyuynincumantawan. Chay may ashqha runas jamorkancu Jesusman ruwaskasninmanta uyariskancuraycu. ");
INSERT INTO quhNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Runas q'isquicamojtincutaj Jesús yachacojcunanman nerka: —Barco waquichiska cashachun runas ama ñit'imunawancupaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jesuska ashqhasta thañicherka. Chayraycu tucuy onkoywan ñac'arichiskaska q'isquinacamorkancu payta llanqharinancupaj. ");
INSERT INTO quhNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Millay supaycunataj Jesusta ricuytawan chaquisninman konkoricorkancu khaparerkancutaj: —Kan Diospa Wawan canqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesusri chay millay supaycunata sinch'ita camacherka pichus pay caskanta ama sut'inchanancuta. ");
INSERT INTO quhNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesuska orkoman wicharerka, chaymantaj khatejcunanmanta munayninmanjina ajllaskacunata wajyarka. Paycunataj payman kayllarkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Chunca iscayniyojtataj churarka cachasnin canancupaj. Paycunata munarka paywan cusca cacunancupaj. Yuyaskanmanjina sumaj willanasta willaraj cachananpaj ima munarka. ");
INSERT INTO quhNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Atiyninwanpis millay supaycunata kharkonancupaj paycunata wajyarka. ");
INSERT INTO quhNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Cay chunca iscayniyojta cachasnin canancupaj churarka: Simonta, paytari Pedrota, Jesús suticharka; ");
INSERT INTO quhNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedeoj wawasnin, Jacobota wauken Juantawan, paycunatari “Boanergesta”, Jesús suticharka, truenojina caskancuraycu; ");
INSERT INTO quhNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andresta, Felipeta, Bartolometa, Mateota, Tomasta; Alfeoj wawan Jacobota, Tadeota; zelote partemanta Simonta; ");
INSERT INTO quhNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariotetawan. Payka khepata Jesusta jaywaycorka. Jesús wasiman riporka. ");
INSERT INTO quhNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ujtawantaj ashqha runas tantaycacamorkancu. May ashqhapuni caskancuraycuri Jesuswan yachacojcunanwanka ni miqhuytapis aterkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ayllusnintaj chayta yachaspa jamorkancu Jesusta jap'inancupaj, locoyapuska, niskancuraycu. ");
INSERT INTO quhNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Chaywanpis israel yachachejcuna Jerusalenmanta chayamuspa Jesusmanta nisharkancu: —Paypeka cashan supaycunaj curajnincu, Beelzebú sutiyoj. Paypa atiyninwan Jesuska supaycunata kharkoshan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesusri paycunata wajyaspa quiquinchanaswan entiendechinanpaj nerka: —¿Imaynatataj supay Satanás payllatataj kharkocunmanrí? ");
INSERT INTO quhNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Uj llajtapi tiyacojcuna paycunapura makanacojtincoka llajtancu tucuconka. ");
INSERT INTO quhNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ajinallataj uj wasipi tiyacojcuna paycunapura makanacojtincoka wasincu tucuconka. ");
INSERT INTO quhNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Satanaswanpis quiquillantaj cashan. Camachisninwan makanacojtenka Satanaska manaña cankachu. Manachayrí tucuconka. ");
INSERT INTO quhNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","‘Chaywanpis callpasapa runata mana wataycunmanchu chayka, ni pi wasinman capuyninta suwaj yaycuyta atinchu. Callpasapa wataycuska cajtillan suwajka yaycuyta atin. Nokapis ajinallatataj Satanasta atipaspa millay supaycunata kharkoshani. ");
INSERT INTO quhNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Chekata niyquichej: Dios khechonka runaspa tucuy juchasnincuta sajra parlaskancumantapis. ");
INSERT INTO quhNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Astawanrí Santo Espíritoj contranpi sajrata parlaskanmantaka ni jayc'aj juchanta khechonkachu. Chay juchamantaka wiñaypaj juchachaska canka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Chayta Jesús nerka millay supayniyoj caskanta niskancuraycu. ");
INSERT INTO quhNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesuspa maman waukesninwan chayamorkancu. Jawallapi khepacuspa payta wajyacherkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Chay ashqha runas paypa muyuyninpi cajcuna chayta yachaspa payman nerkancu: —Yachachejníy, mamayqui waukesniyquiwan jawamanta kanta wajyamushasuncu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesusri cuticherka: —¿Pitaj mamaypis waukesniypis cancumanrí? ");
INSERT INTO quhNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Muyuyninpi tiyacushajcunata khawaspataj nerka: —Caypi cajcuna mamayka, waukesniypis cancu. ");
INSERT INTO quhNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Diospa munayninta ruwajmin waukey, panay, mamaypis, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Watejmanta Jesús Galilea kocha cantopi yachachiyta kallarerka. Chayman may ashqha runas tantacorkancu payta uyarinancupaj. Chayraycu Jesuska yacupi cashaj barcoman yaycuspa tiyaycucorka. Tucuy runastaj kocha canto jallp'api casharkancu uyarinancupaj. ");
INSERT INTO quhNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ashqha quiquinchanaswan paycunata yachachisharka. Nerkataj: ");
INSERT INTO quhNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—¡Uyariychej! Uj runa mujuta t'acaj llojserka. ");
INSERT INTO quhNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","T'acashajtinri waquin mujoka ñan pataman urmarka. P'iskostaj jamuspa pallacaporkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Waquin mujutaj pisi jallp'ayoj rumi pataman urmarka. Chay mujoka uskhayta p'uturamorka pisi jallp'a caskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Mana sumaj saphiyoj caskanraycutaj inti ruphamojtin ch'aquiporka. ");
INSERT INTO quhNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Waquin mujutaj qhishcas chaupiman urmarka. Cusca wiñaycuytawantaj qhishcas trigota sipiycaporka. Chay mujoka manataj pokorkachu. ");
INSERT INTO quhNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Waquin mujurí sumaj jallp'aman urmarka. Chay mujoka wiñaspa pokorka. Pokoynintaj sumaj carka. Waquin muju quinsa chuncata pokorka. Waquin sojta chuncata, waquintaj pachajta pokorka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Chaywanpis Jesús nillarkataj: —¡Ningriyoj cajka sumajta uyarichun! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Chay ashqha runas ripojtincu Jesuspa waquin khatejcunan chay chunca iscayniyoj cachasninwan payta taporkancu quiquinchanasmanta. ");
INSERT INTO quhNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesustaj paycunaman sut'incharka: —Imaynatachus Dios runasta camachin, chay yachachinaska pacaska carka. Cunanrí kancunallaman Dios chay imasta sut'inchashasunquichej. Waj runasmantaj cay imaska quiquinchanasnejta yachachiska cashan. ");
INSERT INTO quhNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Chayraycu ricuncu manataj ricuskancuta entiendencuchu. Uyarincu manataj uyariskancuta reparancuchu. Ajinapi Diosman mana cutiriconkancuchu juchasnincupis khechuska cananpaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesús paycunata nerka: —Sichus cay quiquinchanata mana entiendenquichejchu chayka ¿imaynatataj reparanquichej tucuy chay waj quiquinchanasnejta yachachiskastarí? ");
INSERT INTO quhNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Chay quiquinchanaka caymin cashan: Mujuta tarpojka Diospa niskanta willarajmin. ");
INSERT INTO quhNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Waquin muju ñan pataman urmarka. Ajinallatataj runas Diospa niskanta uyarincu. Chay quiquinpachataj supay Satanás jamuspa Diospa niskanta sonkoncumanta orkhocapun. ");
INSERT INTO quhNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Waquin mujutaj pisi jallp'ayoj rumi pataman urmarka. Ajinallatataj waquinpis Diospa niskanta uyarispa cusiywan jap'icuncu. ");
INSERT INTO quhNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Sonkoncumanrí mana sumajta yaycunchu. Mana sumaj saphiyoj mujujina cancu. Chayraycu pisi ratullapaj Diospa niskanta creencu. Astawanrí llaquiycuna khatirishajtin chayrí Diospa niskanraycu muchojtincu, chincacapuncu. ");
INSERT INTO quhNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Waquin mujutaj qhishca chaupiman urmarka. Ajinallatataj waquinpis Diospa niskanta uyarincu. ");
INSERT INTO quhNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Chay uyarejcunataj anchataraj yuyashancu cay pacha imasmanta. Munashancu ancha khapaj capuyta pantachej cusiytawan. Cay pacha imasta munashancupuni. Tucuy chay imas sonkoncupi Diospa niskanta sipiycapun. Ajinamanta mana pokoyniyoj caspa causaynincupi Diosta mana cusichincuchu. ");
INSERT INTO quhNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Waquin mujurí allin jallp'aman urmarka. Ajinallatataj waquin runaspis c'acha sonkowan sumajta Diospa niskanta uyarispa casuncu. Causaynincupitaj Diosta cusichincu. Paycunaka quinsa chuncata pokoj, sojta chuncata pokoj, pachajta pokoj mujusjina cancu, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Chaywanpis Jesuska nerka: —Runas uj c'anchata jap'ichispaka mana wich'i uraman churancuchu nitaj tiyana uramanpis. Astawanpis patanejman churancu. ");
INSERT INTO quhNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ajinallataj Diospa niskanwanpis cashan. Waquin runaspajka pacaska cashan. Nokarí reparanancupaj yachachispa Diospa niskanta sut'inchashani. ");
INSERT INTO quhNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","¡Ningriyoj cajka sumajta uyarichun! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Nerkataj: —Sumajta khawacuychej imaynata uyariskayquichejta. Imaynatachus Diospa niskanta uyarispa casunquichej chaymanjinallataj niskanta kosonkachej. Astawanraj kosonkachejpis. ");
INSERT INTO quhNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Diospa niskanta jap'icojmanka astawan koska canka. Mana jap'icojmantarí pisi jap'icuskanpis khechuska canka, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Nerkataj: —Dios runaspa sonkoncupi camachejtin cayjinaman rijch'acun: Uj runa trigo mujuta jallp'aman t'acan. ");
INSERT INTO quhNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Runari tuta puñun, p'unchaytaj jataricun. Manataj yachanchu imaynatachus mujoka llojsimuskanta wiñaskantapis. ");
INSERT INTO quhNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Jallp'ari payllamanta ñaupajta yurata riqhurichin. Chaymanta llullumun; khepantataj pokoyta tucuchan. ");
INSERT INTO quhNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Trigo sumaj pokoskaña cajtintaj runaka ruthun, cosecha chayamuskanraycu, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Nillarkataj: —Dios runaspa sonkoncupi camachejtin ¿imamantaj rijch'acunman? ¿Imawantaj sut'inchasunman? ");
INSERT INTO quhNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Muju tarpuskawan quiquinchasun. Cay jallp'api caj aswan juch'uy mujitu ");
INSERT INTO quhNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","tarpucojtenka tucuy waj korasmanta aswan jatunta wiñan. Sumaj yurachacun. P'iskospis llanthunpi thapacharicuncu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ashqha cayjina quiquinchanaswan Diospa niskanta runasman Jesús parlasharka uyariyta atiskancumanjina. ");
INSERT INTO quhNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Paycunamanka parlaj quiquinchanaswanpuni. Yachacojcunanmanrí paywan sapallancu cashajtincutaj tucuy imata sut'ita reparacherka. ");
INSERT INTO quhNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Chay p'unchay ch'isiyaycojtinñataj yachacojcunanman Jesús nerka: —Jacu rinachej cay kocha chimpaman, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Chanta paycuna chay ashqha runasta cacharpayaspa Jesusta pusarkancu, casharka chay barcollapipuni. Wajcunapis barcosnincupi paycunawan cusca rillarkancutaj. ");
INSERT INTO quhNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Rishaskancupi sinch'i wayra jatarerka kochapi. Wayraskanpitaj yacuta callpawan khallachimuspa barcoman junt'achisharkaña. ");
INSERT INTO quhNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesusri puñucusharka barcoj khepannejpi saunanapi samaricuspa. Payta rijch'achispa nerkancu: —¡Yachachejníy! ¡Chincaycushanchejña! ¡Manachu imapis kocusunqui chincaycunanchejmanta! ");
INSERT INTO quhNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Paytaj rijch'arispa wayrata c'amerka kochatapis nerka: —¡Ch'in cay! ¡Jarc'aska cay! —nispa. Manañataj wayrarkachu. Kochapis ch'inyacaporka. ");
INSERT INTO quhNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nerkataj yachacojcunaman: —¿Imaraycutaj mancharicunquichejrí? ¿Manarajchu Diospi jap'icunquichej? ");
INSERT INTO quhNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Paycunarí mayta manchachicuspa t'ucorkancu. Ninacusharkancutaj: —¿Ima runataj payrí? Wayrapis kochapis payta casuncu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kocha ujnin chimpaman rerkancu Gadara runaspa jallp'ancuman. ");
INSERT INTO quhNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesús barcomanta jallp'aman llojsiskantawancamataj uj millay supayniyoj runa paywan tincorka. Chay runaka panteonmanta llojsimorka, ");
INSERT INTO quhNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","chaypi tiyacuskanraycu. Manaña ni pi payta watayta aterkachu cadenaswanpis. ");
INSERT INTO quhNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ashqha cutitaña payta watarkancu fierro watanaswan fierro cadenaswanpis. Cadenastarí p'itiraj, watanastataj t'unaj. Ajinaka ni pi callpayojchu carka payta mansuyachinanpaj. ");
INSERT INTO quhNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tuta p'unchay panteonpi orkospipis khaparispa purej, rumiswan qhuchucuspa. ");
INSERT INTO quhNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Carumanta Jesusta ricuspa supayniyoj runaka uskhayta jamorka, Jesuspa ñaupakenpitaj konkoricorka. ");
INSERT INTO quhNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Jatunmanta khaparerka khaykeyaspa: —¡C'ata Diospa Wawan Jesús, imaman chapucuwanqui! Diospa ñaupakenpi sumajta mañacuyqui ama ñac'arichinawayquita, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ajinata chay runa nerka Jesús camachishaskanraycu: —¡Millay supay, llojsiy cay runamanta! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesustaj payta taporka: —¿Imataj sutiyqui? Cuticherkataj: —Sutiyka Legión, sojta waranka, ashqhas caskaycuraycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Chay supaycunaka Jesusta mayta mañacusharkancu: —Ama kharkowaycuchu cay jallp'amanta jawamanka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Lomas kayllapiri ashqha qhuchis korata miqhusharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Millay supaycunataj Jesusta mañacorkancu: —Qhuchisman cachawaycu chaycunaman yaycunaycupaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesús paycunata sakellarka. Runamanta llojsispataj millay supaycunaka qhuchisman yaycorkancu. Chanta chaypi caj iscay warankajina qhuchistaj, tucuynincu, lomamanta callpawan wijch'uycucuspa kakanejta kochaman ch'ulticorkancu. Jek'ekaspataj wañurarkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Chayta ricuspa qhuchi michejcunaka aykecorkancu. Paycuna llajta runasman ranchospi tiyacojcunamanpis chay imasmanta willamorkancu. Ajinamanta runas llojserkancu imachus carka, chayta ricunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesusman chimpaspa chay ashqha supayniyoj carka, chay runata ricorkancu. Payka p'achalliska yuyayninpi tiyacusharka. Chayta ricuspa runaska mayta manchachicorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Chay ruwaskasta ricojcunarí willasharkancu imaynatachus chay runata supaycunamanta cacharichiskanta, imayna qhuchiswan caskantapis. ");
INSERT INTO quhNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ajinaka chayta uyarispa jamojcunaka mayta nisharkancu Jesusta jallp'ancumanta ripunanta, anchata manchachicuskancuraycu. ");
INSERT INTO quhNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mañaskancumanjina Jesús ripunanpaj barcoman yaycushajtin, supaycunamanta cacharichiska runaka mayta nicusharka: —Yachachejníy, sakellaway kanwan rinayta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesusrí payta mana sakerkachu paywan rinanta. Astawanpis nerka: —Wasiyquiman cutipuy ayllusniyquejman. Paycunaman willamuypuni Dios ruwapususkanmanta pay qhuyasuskanmantawan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ajinamanta payka Decápolis jallp'api Jesuspa ruwaskanmanta willarayta kallarerka. Tucuytaj t'ucorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ujtawan Jesús barcopi kochata chimparka. Kocha cantopi cashajtintaj payman ashqha runas tantacamorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Chanta uj runa riqhurimorka, Jairo sutiyoj. Payka tantacuna-wasipi curajcunamanta carka. Jesusta ricuspa paypa ñaupakenpi konkoricorka, ");
INSERT INTO quhNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","maytataj niricorka: —Warmi wawitay wañupunayashan. Jamuspa maquisniyquita payman churaycuripuway thañicapunanpaj causananpajtaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesustaj paywan rerka. Rishajtintaj chay may ashqha runas khatisharkancu. Chaycunataj payman ñit'icamusharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Uj warmi carka chunca iscayniyoj watata yawar apaywan onkoska. ");
INSERT INTO quhNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ashqha medicoswan jampichicuspa anchata ñac'ariska, tucuy capuynintapis tucuchiska. Chaywanpis mana allinyacorkachu. Manachayrí aswan onkoskallapuni casharka. ");
INSERT INTO quhNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Chay warmeka Jesusmanta uyarispa chay ashqha runas chaupita jamorka. Jesuspa khepanman kayllacamuspataj p'achasninta jap'iricorka. ");
INSERT INTO quhNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Chayta ruwarka ajinata sonkonpi yuyaskanraycu: “Sichus p'achallantapis llanqharisaj chayka, thañiska casaj”. ");
INSERT INTO quhNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Chay quiquinpacha yawar apaymanta thañicaporka. Payri onkoyninmanta thañichiskaña caskanta reparacorka. ");
INSERT INTO quhNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesuska sonkonpi chay quiquinpacha repararka atiyninwan uj runata thañichiskanta. Chayraycu cutiricuspa chay ashqha runas chaupipi taporka: —¿Pitaj p'achasniyta jap'iricorka? ");
INSERT INTO quhNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Yachacojcunanri payta nerkancu: —Ricunqui cay q'isqui runas kanta ñit'imushasuskancuta. ¿Tapushanquitaj pi jap'irisuskanta? ");
INSERT INTO quhNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesustaj muyuyninta khawarerka payta jap'irejta ricunanpaj. ");
INSERT INTO quhNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Warmirí imaynapichus thañiska caskanta yachaspa, manchachicuywan qharcatitiywantaj paypa ñaupakenpi konkoricorka. Jesusmantaj tucuy imata chekata willarka. ");
INSERT INTO quhNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Chanta Jesús warmita nerka: —Diospi jap'icuskayquiraycu thañiskaña canqui. Onkoyniyquimanta thañiska caspa cusiywan ripuy, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesús parlashajtillanraj chay curaj runa Jairoj wasinmanta willaj jamorkancu: —Ususiyqueka wañupunña. Amaña yachachejta molestaychu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesusri chay niskancuta uyarispa Jairoman nerka: —Amaña manchachicuychu. Jap'icushallaypuni Diospi, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jesuska ni pita sakerkachu paywan rejta manachayka Pedrota, Jacobota, chay Jacoboj wauken Juantawan. ");
INSERT INTO quhNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Curajpa wasinman chayamuspari ashqha wakashajcunata ricorka phutiywan khaparejcunata ima. ");
INSERT INTO quhNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yaycuspataj paycunaman nerka: —¿Imaraycutaj cay ch'ajwarí? Amaña wakaychejchu. Imillitaka mana wañuporkachu. Manachayrí puñushan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Paycunataj Jesusta asipayarkancu. Payrí tucuyta jawaman kharkorka. Imillitaj tatanta mamanta quinsa yachacojcunantawan pusaricorka. Imillita casharka, chaymantaj yaycorka. ");
INSERT INTO quhNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Chanta imillitata maquinmanta jap'ispa nerka parlaynincupi: —Talita, cumi, —nispa. Cayka niyta munan: Imillita, kanta niyqui, jatarimuy. ");
INSERT INTO quhNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Chay quiquinpacha imillitaka jataricorka purerkataj. Chunca iscayniyoj watasniyojjina carka. Chaypi cajcunari manchayta t'ucorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesustaj paycunata sinch'ita camacherka, ama ni pi chay imasmanta yachananta. Nerkataj, imillitaman miqhunata konancuta. ");
INSERT INTO quhNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesustaj chaymanta llojsispa Nazaret llajtanman rerka. Yachacojcunanpis paywan rerkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Samacuna p'unchay chayamojtintaj tantacuna-wasipi yachachiyta kallarerka. Ashqha runas chaypi cajcuna payta uyarispa mayta t'ucorkancu. Nisharkancutaj: —Cay runaka ¿imaynapitaj cayjina yuyaywan yachachishanrí? ¿Maypitaj cayjina yuyayta jap'erkarí? ¿Imaynatataj cayjina atiyniyoj t'ucuna ruwanasta ruwashanrí? ");
INSERT INTO quhNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Manachu payka Maríaj wawan chay carpintero? Waukesnin Jacobo, José, Judas, Simonwan cancu. Panasninpis caypi tiyacuncu, —nispa. Phiñacuspataj payta mana jap'icorkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesusrí paycunaman nisharka: —Diosmanta willajka tucuynejpi sumajpaj khawaskapuni. Astawanrí quiquin llajtallanpi, ayllusnin uqhupi, wasinpiwanka manamin, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ajinapi Nazaretpeka ni ima t'ucuna ruwanatapis ruwayta aterkachu. Manachayka pisi runasllata onkoynincumanta thañicherka maquisninta churaspa. ");
INSERT INTO quhNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesuska t'ucorka Diospi mana jap'icuskancumanta. Chay muyuynin llajtastataj yachachispa purerka. ");
INSERT INTO quhNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesuska chay chunca iscayniyoj cachasninta wajyaspa iscay iscaymanta cachayta kallarerka. Millay supaycunata kharkonancupajtaj paycunaman atiyta korka. ");
INSERT INTO quhNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Paycunatataj camacherka: —Ñanniyquichejpaj ni imata apaychejchu manachayrí uj c'aspillata purinayquichejpaj. Ama apaychejchu kokawita ni wayakata nitaj kolketa cinturayquichejpi. ");
INSERT INTO quhNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ojot'asniyquichejta churacuychej, amataj iscay camisasta apaychejchu p'achallicunayquichejpaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Astawanpis paycunaman nerka: —Mayken wasillamanpis wajyaricusunquichejman chayka, chayllapi cacuychej chay llajtamanta llojsipunayquichejcama. ");
INSERT INTO quhNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Maypichá runas mana wajyasunquichejmanchu nitaj sumaj willanastapis uyarincumanchu chayka, llajtancumanta llojsipuychej. Chaquisniyquichejmantataj jallp'anta thalaycarpaychej chay runaspa contrancupi. Chaywan runas yachankancu Diospa willananta khesachaskancuta. Chekata niyquichej: Juicio p'unchaypeka chay llajtapi tiyacojcuna astawan ñac'arichiskas cankancu Sodoma, Gomorra llajtayojcunamanta niskaka, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ajinamanta cachasnenka llojsispa runasman willaramorkancu: —Juchasniyquichejta sakespa Diosman cutiricuychej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ashqha supaycunata kharkorkancu. Chaywanpis aceitewan jawispa Jesuspa atiyninwan ashqha onkoska runasta thañicherkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jesuspa sutin may allin rejsiska carka. Chayraycu camachej Herodeska paypa ruwaskasninmanta uyarerka. Runas nisharkancu: —Chay Jesuska bautizaj Juanmin, wañuymanta causarimpun. Chayraycu chay t'ucuna ruwanaswan Diospa atiyninta ricuchishan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Waquenka nisharkancu: —Diospa unay willajnin Eliaschá, —nispa. Waquintaj nisharkancu: —Diospa unay willajcunanjina, uj willajchá, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodesrí paymanta uyarispa nerka: —¡Khorucherkani, chay Juanmin cayka! Wañuymanta causarimun, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ajinaka ñaupajpi quiquin Herodes Juanta jap'iycuchispa carcelman wataskata churacherka Herodiasraycu. Chay Herodiaska Herodespa wauken Felipej warmin carka. Waukenpa warmin cashajtinpis Herodeska paywan casaracorka. ");
INSERT INTO quhNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Juanka Herodesman nej: —Waukeyquej warminwan tiyacunayqueka juchamin, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Chayraycu Herodiaska mayta chejnispa Juanta wañuchiyta munasharka, manataj aterkachu Herodes jarc'acuskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodesri yacharka Juanka uj chekan ruwaj runa Diosman t'akaska caskanta. Chayraycu payta manchachicuywan wakaycharka. Juanta uyariytataj munajpuni. Astawanrí uyarishaspapis iscayrayajpuni. Juchanta sakeytataj mana munajchu nitaj Diosman cutiricuytapis. ");
INSERT INTO quhNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodeska diachacunpaj uj jatun miqhunata waquicherka. Chaypacha Herodiaspaj suyaskan horaka chayamorka. Herodeska paywan miqhunancupaj wajyarka camachejcunanta, capitancunata, Galilea jallp'amanta curaj cajcunatawan. ");
INSERT INTO quhNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodiaspa ususintaj chay fiestaman yaycuspa paycunapaj tusorka. Tususkantaj mayta cusicherka Herodesta paywan cashajcunatapis. Chayraycu camachej Herodes sipasman nerka: —Imatachá munanqui, chay mañacuwaskayquita koskayqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Cayta nerka juraspa: —Jurani gobiernoy capuwaskanmanta cuscanta mañacuwanquiman chaypis, chayta koskayqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Sipastaj llojsispa mamanta tapumorka: —¿Imatataj mañacuyman? Mamanri nerka: —Bautizaj Juanpa umanta mañacuy, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Chaymantataj sipaska uskhayta cutirispa, Herodesmanta mañacorka: —Munani cunanpacha bautizaj Juanpa umanta uj chuwapi konawayquita, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Camachej Herodestaj mayta phuticorka. Wajyaskan runaspa ñaupakencupi juraskanraycurí sipaspa mañacuskanta mana munarkachu “mana”, niyta. ");
INSERT INTO quhNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Chayraycu quiquinpacha uj soldadota cacharka carcelman Juanpa umanta apamunanpaj. ");
INSERT INTO quhNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Soldadotaj rispa Juanta khorumorka. Umanta chuwapi apamuspataj sipasman korka. Sipastaj Juanpa umanta mamanman komorka. ");
INSERT INTO quhNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Chayta uyarispa Juanpa yachacojcunan jamorkancu ayata apaspataj p'ampamorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesuspa cachasnintaj payman cutimuspa willarkancu tucuy ruwamuskancuta yachachimuskancutapis. ");
INSERT INTO quhNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Paycunaman Jesús nerka: —Jacu rina sapallanchej ch'innejman tumpata samaricunayquichejpaj, —nispa. Chayta nerka ashqha runasraycu. Chay ashqha runaska payman mana tucucuyta jamusharkancutaj ripusharkancutaj. Chayraycu Jesuspis yachacojcunanpis ni miqhunallancupajpis tiempoyojchu carkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ajinapi paycunalla ch'innejman barcopi kochanejta riporkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ashqha runasrí ripuskancuta ricuspa repararkancu maymanchus rishaskancuta. Chayraycu tucuy llajtasmanta runas chaquipi chayman uskhayta rerkancu payta ñaupanancupaj. ");
INSERT INTO quhNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesuska barcomanta llojsispa may ashqha runasta ricorka. Mana michejniyoj ovejasjina caskancuraycutaj paycunamanta sonkon nanarka. Ashqha imastataj yachachiyta kallarerka. ");
INSERT INTO quhNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ch'isiyaynejtataj yachacojcunanka Jesusman kayllaycuspa nerkancu: —Caypeka ch'innejpi cashanchej ch'isiyashanñataj. ");
INSERT INTO quhNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Runasta cachapullayña muyuyninchejpi chajra wasisman ranchosmanpis miqhunata ranticamunancupaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesusrí cuticherka: —Kancuna paycunata miqhuchiychej, —nispa. Paytataj nerkancu: —Yachachejníy ¿imaynata? Iscay pachaj p'unchay llanc'aymantajina kolkewan t'antata rantimuycuman chaypis, cay chhica runaman konapajka pisinmanraj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesustaj taporka: —¿Mashqha t'antataj capusunquichej? Khawarimuychejmá, —nispa. Yachamuspataj willarkancu: —Phishka t'antas iscay challwitaswan tiyan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Chanta Jesús tucuy runata tiyaycucherka t'aka t'akallata k'omer pasto patapi. ");
INSERT INTO quhNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ajinamanta tiyaycorkancu, waquin t'akaspi pachajjina, waquin t'akaspitaj phishka chuncajina. ");
INSERT INTO quhNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesustaj chay phishka t'antasta chay iscay challwitastawan maquisninpi jap'ispa, janaj pachaman khawarispataj chaycunamanta Diosman graciasta korka. T'antata partispa yachacojcunaman jaywasharka paycuna runasman konancupaj. Ajinallatataj challwitastapis partispa tucuynincupaj jaywachimorka. ");
INSERT INTO quhNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tucuynincu miqhorkancu sajsacorkancutaj. ");
INSERT INTO quhNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Chay partiska t'antasmanta challwitasmantapis puchojtataj chunca iscayniyoj canastas junt'ata okharerkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Miqhojcunaka kharislla yupaskas, carkancu phishka warankajina. ");
INSERT INTO quhNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Chay quiquinpachataj Jesuska yachacojcunanta camacherka barcoman yaycunancuta Betsaida llajtaman rinancupaj. Kocha chimpaman paymanta ñaupajta rinancuta munarka, chay ashqha runasta cacharpayashanancama. ");
INSERT INTO quhNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Runasta cacharpayaspataj Jesuska orkoman riporka Dioswan parlaj. ");
INSERT INTO quhNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tutayaycojtintaj yachacojcunanka barcopi chaupi kochapiña casharkancu, paytaj sapallan jallp'api casharka. ");
INSERT INTO quhNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ricorkataj paycunata tucuy callpancuwanpis ñac'ayta barcota suchuchishajta. Ñaupakencumanta sinch'i wayra wayramuskanraycu sayc'usharkancu. Ajinamanta Jesuska manaraj sut'iyayta yacu patata purispa paycunaman jamorka. Paycunamanta ñauparejjina churacorka. ");
INSERT INTO quhNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Payta yacu patata purishajta ricuspari alma caskanta yuyaspa khaparicorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tucuynincu payta ricorkancu mayta mancharicorkancutaj. Jesusrí paycunata parlapayaspa nerka: —¡Sonkochacuychej! Noka cani, amaña manchachicuychejchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Barcoman yaycorka paycunawan, wayrataj manaña wayrarkachu. Paycunataj mayta t'ucorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Chay ashqha runasta miqhuchiskanta ricorkancu. Ni chaywanpis repararkancuchu Jesús Diospa atiyniyoj Wawan caskanta, rumiyaska sonkoyoj caskancuraycu. ");
INSERT INTO quhNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kochata chimpamuspaña Jesuska yachacojcunanwan Genesaret jallp'aman chayamorkancu. Kocha cantopitaj barcota watarkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Jallp'aman llojsiskancutawantaj runaska Jesusta rejsiycorkancupacha. ");
INSERT INTO quhNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Chayraycu uskhayllata tucuynejta rerkancu onkoska runasta payman pusanancupaj. Maypichus pay cashaskanta uyarerkancu, chayman onkoska runasta puñunasnincupi apamorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Mayllamanpis pay chayajtin, ranchosman chayrí llajtasman chayrí camposmanpis, onkoskasta apamuspa callesman churaj cancu. Jesusmantataj mañacoj cancu p'achanpa t'icasnillantapis llanqharinancuta. P'achanta tucuy llanqharejcunataj onkoynincumanta thañichiskas carkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Fariseocunaka tucuy israelcunapis chay unay curajcunaj yachachiynincumanjina ruwaj cancu. Chayraycu chaymanjina maquisnincu mana mayllacuspaka mana miqhojchu cancu. Recobamanta wasiman cutimuspa manaraj miqhushaspa llimphuchacojpuni cancu costumbrencumanjina. Waj ashqha imaymana ruwanastawan wakaychanancu caj. Cayjina carka: Vasos mayllana, yuru mayllana, cobre manca mayllana, puñuna mayllanapis. Uj cutitaj waquin fariseocuna israel yachachejcunawan Jerusalenmanta jamuspa tantacamorkancu. Paycunaka ricorkancu Jesuspa waquin yachacojcunanta miqhojta maquisnincuta mana costumbrencumanjina mayllacuspa. ");
INSERT INTO quhNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Chayraycu Jerusalenmanta chay jamojcunaka Jesusta nerkancu: —Yachacojcunayqui unay curajcunaj yachachiynincuta mana casuspa maquisnincuta mana llimphuchacuncuchu miqhunancupaj. ¿Imaraycutaj ajinata ruwancurí? ");
INSERT INTO quhNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesusrí paycunata nerka: —Allinta kancuna puraj uyacunamanta Isaiaska sut'incharka. Kelkaskanpi Dios nin: Cay runacunaka simillancuwan yupaychawancu. Sonkoncupirí nokamanta carupi cashancu. ");
INSERT INTO quhNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Paycunaka yachachincu runacunaj yachachinasnillancuta nokamantapis canmanjinata. Ajinapeka yankhalla yupaychawancu. ");
INSERT INTO quhNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Nillarkapuni: —Kancunaka runaspa yachachiynincuta wakaychanayquichejpaj Diospa camachiskanta mana casunquichejchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Paycunaman nillarkataj: —Diospa camachiskanta khesachanquichej curajcunaj yachachiynincuta sumajta wakaychanayquichejpaj. Chaywanka mana allintachu ruwashanquichej. ");
INSERT INTO quhNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moiseska caytamin nerka: “Jatunpaj khawaspa casuy tatayquita mamayquita”, nispa. Nillarkataj: “Tatanta chayrí mamanta sajrata parlaj wañuchiska cachun”. ");
INSERT INTO quhNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kancunarí ninquichej, uj runa khesachayta atiskanta tatanta chayrí mamanta “Corbán”, nispa. Corbán niyta munan, Diospaj t'akaska. Chayta nispa chay runaka tatanta chayrí mamanta pisichicojtincu nin: “Kanta yanapasunaypaj tucuy capuyniyka Diospaj t'akaskaña”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kancunaka chay niskayquichejwan yanapananta jarc'anquichej. Ajinapi runaka ni atinchu capuyninwan tatanta mamantapis yanapayta. ");
INSERT INTO quhNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ajinapitaj kancunaka yachachiyniyquichejnejta Diospa niskanta manacajman tucuchishanquichej. Chayjina ashqha waj imastapis ruwashanquichej. Kancunaka unay curajcunaj yachachiynillancutapuni yachachishanquichej wawasniyquichejman cunan p'unchaycama, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ujtawan chay ashqha runasta payman wajyaspa Jesuska nerka: —Tucuy kancuna uyariwaychej entiendewaychejtaj. ");
INSERT INTO quhNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ni ima miqhuskanpis payman yaycuspa runataka ch'ichichanchu. Manachayrí runataka ch'ichichan paypa sonkonmanta llojsiskan. ");
INSERT INTO quhNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","¡Ningriyoj cajka sumajta uyarichun! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesús chay ashqha runasta sakespa wasiman yaycorka. Chaymantataj yachacojcunanka payta chay quiquinchanamanta taporkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Paycunaman nerkataj: —¿Kancunapis mana yuyayniyojllatajchu canquichej? ¿Manachu cayta entiendenquichej? Ima miqhuskanpis runaman yaycuspaka mana payta ch'ichichanchu. ");
INSERT INTO quhNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Miqhuskanka mana sonkonmanchu yaycun. Manachayrí wijsanman yaycun, chaymantataj jawaman llojsipun, —nispa. Chay niskanwan Jesús ricucherka tucuy laya miqhuna Diospa kowaskanchejka allin caskanta. ");
INSERT INTO quhNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nerkataj: —Astawanrí runaj sonkonmanta llojsimojmin runataka ch'ichichan. ");
INSERT INTO quhNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Runacunaj sonkoncumantaka sajra yuyaynincumanta caycunamin llojsimun: Khenchachacuycunawan, suwaycunawan, runata wañuchiycunawan, ");
INSERT INTO quhNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","sajra puriypi causaycunawan, munapayaycunawan, sajrata ruwaycunawan, pantachiywan, mana Diosmanjina causaywan, envidiacuywan, sajra parlaywan, jatunchacuywan, mana yuyayniyoj caywan. ");
INSERT INTO quhNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tucuy chay sajra imastaj runaj sonkonmanta llojsimun. Paytataj ch'ichichan, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Chaymanta llojsispa Jesús rerka Tiro llajta Sidón llajtapis carkancu, chay ladoman. Chaypi uj wasipi caricusharka manataj munarkachu ni pi yachananta chaypi cashaskanta. Astawanrí paymantaka yachacorkapuni. ");
INSERT INTO quhNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Chaynejpitaj carka uj warmi, Sirofeniciapi naceska. Waj llajtayoj caspa payka mana Jesuspa llajtamasinchu carka. Paypa imillitan millay supayniyoj carka. Chay warmeka Jesusmanta uyarispa payman jamorka. Ñaupakenpi konkoricuspataj mayta nicusharka, wawanmanta supayta kharkonanta. ");
INSERT INTO quhNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesusrí payman nerka: —Ñaupajtaka quiquin llajta-masisniyta yanapanay tiyan. Imaynatachá uj familiapeka miqhuchincu wawitasta, manataj paycunaj miqhunancutaka alketuspaj wijch'uncuchu, ajinata, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Warmitaj cuticherka: —Ajinapuni, Señor. Chaywanpis mesa uraman wawitas t'unitasta urmachejtincu alketuska miqhuncupuni, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesustaj nerka: —Cayjina sumaj yuyaywan cutichiwaskayquiraycu ripullay. Wawayquimanta chay millay supayka llojsinña, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Paytaj wasinman cutipuspa wawanta tariparka camapi siriskata. Jesuspa niskanmanjinataj supayka wawamanta llojsipuskaña. ");
INSERT INTO quhNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tiro jallp'amanta cutispa Jesuska Sidón llajtaninta rerka Galilea kochanejman. Chaymanka Decápolis jallp'anintataj rerka. ");
INSERT INTO quhNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ajinapi uj jok'ara qhacu runata payman pusamorkancu. Maytataj nicusharkancu Jesús maquisninta chay runaman churaspa payta thañichinanta. ");
INSERT INTO quhNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ajinapi Jesuska chaypi caj ashqha runasmanta wajnejman chay runata sapallanta pusarka. Chaypitaj Jesuska maqui dedosninta jok'araj ningrisninman sat'iycurerka. Runaj kallunmanpis Jesuska thokayninta churarka. ");
INSERT INTO quhNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Payka janaj pachaman khawarispa Dios Tatanta yupaycharka. Runaman nerkataj: —¡Efata! —nispa. Cayka niyta munan: ¡Ningrisniyqui quichacuchun! ");
INSERT INTO quhNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Chay quiquinpacha runaka uyarerka. Kalluntaj phascacorka. Sut'ita parlaytataj kallarerka. ");
INSERT INTO quhNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesustaj ricojcunata camacherka chayta ama ni piman willanancuta. Pay ajinata astawan camachishajtinpis runaska astawanraj willarasharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Paycunari manchayta t'ucuspa nisharkancu: —Jesuska tucuy imata may sumajta ruwan. Jok'arasta uyarichin, upastapis parlarichin, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Chay p'unchaycunapi watejmanta ashqha runa Jesús casharka, chaypi tantacullarkataj. Paycuna mana miqhunayoj cajtincutaj Jesús yachacojcunanta wajyaspa nerka: ");
INSERT INTO quhNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Sonkoy nanawan cay ashqha runasmanta. Quinsa p'unchayña nokawan cusca cashancu. Miqhunancupaj manaña ni imapis canchu. ");
INSERT INTO quhNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Sichus mana miqhuskata wasisnincuman cachapuyman chayka, ñanpi llauchhuyapuncuman. Chaywanpis waquenka carusmanta jamorkancu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yachacojcunantaj Jesusta taporkancu: —¿Imaynatataj pipis cay chhicaman miqhuchinman cay ch'innejpirí? ");
INSERT INTO quhNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesustaj paycunata taporka: —¿Mashqha t'antastaj capushasunquichejrí? Paycunataj cuticherkancu: —Kanchis t'antas capuwaycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesusri camacherka chay ashqha runasta pampapi tiyacunancuta. Chay kanchis t'antasta maquisninpi jap'ispataj Diosman graciasta korka. Chay t'antasta partispataj yachacojcunanman kosharka chay ashqha runasman jaywaramunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Paycunajta capullarkataj pisi challwitaspiwan. Ajinallatataj graciasta kospa challwitastapis jaywarachimorka. ");
INSERT INTO quhNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Miqhorkancu sajsacorkancutaj. Chay partiska miqhunasmanta puchoj t'unastaj kanchis canasta junt'a carka. ");
INSERT INTO quhNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Miqhojcunataj kharislla yupaska, carkancu tawa warankajina. Jesustaj paycunata cacharpayaporka. ");
INSERT INTO quhNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Chay quiquinpachataj yachacojcunanwan barcoman yaycuspa rerkancu kochanejta Dalmanuta jallp'aman. ");
INSERT INTO quhNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Chaypi Jesús cashajtintaj fariseoska jamorkancu churanacuyta munaspa. Paymanta mañasharkancu janaj pachamanta uj jatun ricuchinata ruwananta Dios payta cachamuskanta ricuchinanpaj. Paycunaka yuyasharkancu Jesús mana atiyniyoj caskanta chay mañaskancuta ruwananpaj. Mana mañaskancuta ruwaspataj runaspa ñaupakencupi urmachiska canman. Ajinapi chay runas manaña paypi jap'icuncumanchu. ");
INSERT INTO quhNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesusrí sonkonpi phuticuspa jatunta samarimorka nerkataj: —¡Ay, cayjina canancoka! ¿Imaraycutaj cay p'unchay runacunaka uj ricuchinata mañancurí? Chekata niyquichej: Cay runacunapajka ni ima ricuchina ruwaskachu canka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Paycunata sakerpayaspataj ujtawan barcoman yaycuspa yachacojcunawan kocha chimpaman riporka. ");
INSERT INTO quhNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yachacojcunaka t'antata apayta konkapuskancu. Barcopiri uj t'antallancu caporka. ");
INSERT INTO quhNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Chanta Jesús paycunata camacherka: —Allinta khawacuychej fariseocunaj t'anta pokochina levadurancumanta Herodespa levaduranmantawan wakaychacunayquichejpaj, —nispa. Chayta nispaka fariseospawan, Herodespawan puraj uya caynincumanta parlasharka. ");
INSERT INTO quhNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Yachacojcunarí yuyasharkancu t'antancu mana caskanraycu chayta niskanta. Chayraycu paycunapura tapunacusharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesustaj yuyaskancuta reparaspa paycunaman nerka: —¿Imaraycutaj tapunacushanquichej t'antayquichej mana caskanmantarí? ¿Manarajchu cay imasmanta yuyanquichej? ¿Manachu reparanquichejpis? ¿Sonkoyquichejka rumiyaskajinachu cashan? ");
INSERT INTO quhNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Ñawisniyoj cashaspapis manachu ricunquichej? ¿Ningrisniyoj cashaspapis manachu uyarinquichej? ");
INSERT INTO quhNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Manachu yuyaricunquichej imaynatachus miqhucherkani chay phishka waranka runasman phishka t'antasmanta partispa? Chaymanta puchojta ¿mashqha canasta junt'atataj okharerkanquichej? Paycunataj cuticherkancu: —Chunca iscayniyoj canastasta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Nillarkataj: —Chay kanchis t'antamanta tawa warankaman miqhuchishajtiyri chay puchojta ¿mashqha canasta junt'atataj okharerkanquichejrí? Cuticherkancutaj: —Kanchis canastasta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jesuska paycunata taporkataj: —¿Chay ricuskayquichejwanpis manarajchu reparanquichej? —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jesuska yachacojcunanwan Betsaida llajtaman chayarkancu. Chaypitaj uj ciego runa carka. Paytari Jesusman pusamorkancu maytataj nicusharkancu payta llanqharispa thañichinanta. ");
INSERT INTO quhNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesuska maquinmanta jap'ispa chay ciego runata llajta jawaman pusarka. Chay runaj ñawisninman thokaycuspataj Jesuska maquisninta churarka. Taporkataj: —¿Imallatapis ricunquichu? ");
INSERT INTO quhNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Runari ricuyta kallarispa nerka: —Runasta ricuni sach'asman rijch'acojta. Astawanpis purishajta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Chanta ujtawan Jesús maquisninta churarka ciegoj ñawisninman. Cay cutipitaj ciegoka sut'ita ricorka. Thañiskaña caspari carumantapacha tucuy imata ricorka. ");
INSERT INTO quhNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Chaywanpis Jesús payta wasinman cachaporka nerkataj: —Llajtamanka ama yaycullaypischu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesús yachacojcunawan Betsaidamanta llojsispa Cesarea Filipo llajtanejpi ranchosman rerkancu. Ñanta rishaspataj Jesuska yachacojcunanta taporka: —Runas nokamanta parlaspa, noka ¿pi caskaytataj nincu? ");
INSERT INTO quhNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Payman cuticherkancu: —Waquin nincu, bautizaj Juan. Waquin nincu, Diospa willajnin Elías. Waquinri Diospa unay willajcunanmanta ujninchá, nisuncu. ");
INSERT INTO quhNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jesús paycunata taporkataj: —Kancunarí noka ¿pi caskaytataj ninquichej? Pedrotaj cuticherka: —Diospa ajllaskan Cristomin kan canqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesustaj paycunata camacherka, ama ni piman chayta paymanta willanancuta. ");
INSERT INTO quhNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesuska yachacojcunanman yachachiyta kallarerka ñac'ariyninmanta. Nerkataj: —Noka, Diospa cachaska Runan, anchata ñac'arinay tiyan Diospa munayninmanjina. Israel curajcuna, yupaychana-wasimanta curajcuna, israel yachachejcunapiwan, tucuynincu nokata khesachawaspa wañuchiwankancu. Quinsa p'unchaymantataj causarimpunay tiyan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Chay niskantaka sut'ita paycunaman willasharka. Pedrorí wajnejman pusaspa Jesusta c'amiyta kallarerka: —Amaña ajinataka parlaychu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesusrí cutiricamuspa yachacojcunanta khawaspataj Pedrota nerka: —¡Anchhuriy nokamanta! Satanasjina parlashanqui. Manataj Diospa yuyaskanmanjinachu yuyashanqui. Manachayrí runacunaj yuyaynincumanjinalla yuyanqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Chanta chay ashqha runastawan yachacojcunantawan wajyaspa nerka: —Pichus munashan yachacojniy cayta nokawan riytapis chayka, sakenan tiyan quiquin munayninta. Chaywanpis nokaraycu pay quiquinpi muchunan tiyan wañunancama. Nokatataj casunawanpuni tiyan. ");
INSERT INTO quhNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Chekatapuni pillapis causayninta payllapaj wakaychacuyta munajka mana wiñay causayniyojchu canka. Pillapis nokata casuwaskanraycu sumaj willanasraycupis causayninta cay pachapi chincananta sakejka wiñay causayniyoj canka. ");
INSERT INTO quhNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Reparaychej: Sichus uj runa cay pachantintapis jap'inman pay quiquinri wiñaypaj chincapunmantaj chayka ¿ima allin paypajrí? ");
INSERT INTO quhNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Yachanchejjina, runaka manamin atinchu causayninta rantiyta tucuy cay pacha capuywanpis aswan valorniyojmin caskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Cay p'unchaycunapi caj khenchachacoj juchallicoj runacunaj ñaupakencupi ama nokamanta niskasniymantapis p'enkacuychejchu. Nokapis cutimuspa kancunamantaka mana p'enkacuskayquichejchu. Noka, Diospa cachaska Runan, Tataypa atiyninpi santo angelesninwantaj cutimusaj, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Nillarkataj: —Chekata niyquichej: Waquin cunan caypi cajcunamanta mana wañonkancuchu Dios atiyninwan camachinanpaj jamuskanta ricunancucama, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Sojta p'unchaymantataj Jesuska Pedrota, Jacobota, Juantawan sapallancuta pusarka uj alto orkoman. Paycunaj ñaupakencupitaj Jesuspa rijch'acuynenka wajjinaman tucorka. ");
INSERT INTO quhNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","P'achasninpis sumaj yuraj lliphipej rit'ijinaman tucorkancu. Chayjinata yurajyachiytaka cay pachapi ni pi t'ajsajpis atinmanchu. ");
INSERT INTO quhNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Eliaswan Moiseswan riqhurimuspataj Jesuswan parlanacusharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pedrotaj payta nerka: —Yachachejníy, sumajta caypi cashanchej. Ruwaycuman quinsa ch'ujllasta, ujta kanpaj, ujta Moisespaj, ujtataj Eliaspaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pedroka chayta nerka mana yachaspa imatachus parlananta. Chay yachacojcunanka maytamin manchachicusharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Chanta uj phuyu riqhurimuspa paycunaman uraycamorka. Phuyumantataj parlamushajta uyarerkancu: —Caymin c'ata munaska Wawayka. Payta uyariychej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Chay quiquinpacha muyuynincuta khawarispa manaña ni pita ricorkancuchu. Manachayrí Jesús sapallanña paycunawan casharka. ");
INSERT INTO quhNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Orkomanta uraycamushaskancupitaj Jesús yachacojcunanta camacherka: —Chay ricuskayquichejta ama ni piman willaychejchu noka, Diospa cachaska Runan, wañuymanta causarimpunaycama, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ajinaka ni piman chay imasmanta willarkancuchu. Paycunapurarí tapunacusharkancu: —“Wañuymanta causarimpunay” ¿imatataj niyta munan cay niskanwanrí? ");
INSERT INTO quhNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Jesusta Eliasmanta tapuspa nerkancu: —Yachachejcunanchejka nincu, Cristomanta ñaupajta Elías jamunanta. ¿Imaynataj chayrí? ");
INSERT INTO quhNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Jesusri nerka: —Chaytaka allinta nincu Diospa palabranmanjina. Chekata Eliaska jamun tucuy imata allinyachinanpaj. Astawanrí niyquichej: Eliaska jamorkaña. Bautizaj Juan Eliasjina jamorka ñaupakeyta. Runastaj payman sajrata ruwarkancu imatachus munaskancuta. Chaywanpis Diospa palabranpi ajinallatataj nin, Diospa cachaska Runanka ashqha imasta ñac'arinanta, manacajpaj khawaska canantawan, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jesuska paywan cajcunawan cutimuspa yachacojcunanta israel yachachejcunatawan tariparka. Paycunatataj ashqha runa chaupipi churanacushajta ricorka. ");
INSERT INTO quhNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Chay ashqha runasri mana yuyaymanta Jesusta ricorkancu. Correspa payta napaycorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesustaj israel yachachejcunata taporka: —¿Imamantataj churanacusharkanquichej paycunawanrí? ");
INSERT INTO quhNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Chay ashqha runasmantari uj runa payman cuticherka: —Yachachejníy, wawayta pusamorkayqui upayachej supayniyoj caskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Maypichá payta jap'in chayka pampaman wijch'un. Phosokotajina llausata suruchin siminmanta, quirusninta c'aruchispa wañuskatajina ruwan. Ñapis yachacojcunayquita nicorkaniña wawaymanta supayta kharkonancuta, manataj aterkancuchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesustaj nerka: —¡Ay, Diospi mana jap'icoj runas! ¡Mayc'ajcamataj kancunawan casaj! ¡Mayc'ajcamataj kancunata muchuskayquichej! Cayman waynata pusamuwaychej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Waynata payman pusamorkancutaj. Chay supayka Jesusta ricuspa waynata t'ucuwan jap'iycucherka. Waynataj pampaman urmarka. Chokaycachacuspataj siminmanta phosokota ajtorka. ");
INSERT INTO quhNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesús waynaj tatanta taporka: —¿Mayc'ajmantañataj cayjina cashanrí? Tatantaj cuticherka: —Wawitamantapacha. ");
INSERT INTO quhNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ashqha cutis payta ninaman yacumanpis chokaycun wañuchinanpaj. Kanrí, Señorníy, sichus imata atinqui chayka, qhuyacuspa yanapariwaycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesusrí payta nerka: —Kan ninqui: “Sichus atinqui”, nispa. Noka niyqui, Diospi jap'icojpajka tucuy ima aticun, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Niskantawancamataj waynaj tatanka khaparispa nerka: —¡Diospi jap'icuni! ¡Yanapaway astawan jap'icunaypaj! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Astawan ashqha runa tantacamojta ricuspa Jesuska chay quiquinpacha millay supayta camacherka: —Noka camachiyqui, upa jok'ara supay: ¡Llojsiy paymanta, amataj ni jayc'aj ujtawan payman yaycuychu! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Supayri waynata khaparichispa sinch'ita t'ucuchispataj paymanta llojserka. Waynataj wañuskajina carka. Chayraycu ashqhas nisharkancu, wañupuskanta. ");
INSERT INTO quhNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesusrí maquinmanta jap'ispa jataricherka. Waynataj sayaricorka. ");
INSERT INTO quhNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jesús wasiman yaycojtin yachacojcunan sapallancupi taporkancu: —¿Imaraycutaj nokaycu mana aterkaycuchu chay millay supayta kharkoytarí? ");
INSERT INTO quhNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Paycunaman cuticherkataj: —Cay layata kharkoyka mana aticunchu manachayrí tucuy sonkowan Diosmanta mañacuyllawan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Chaynejmanta llojsispataj Galilea jallp'anejta rerkancu. Jesuska yachacojcunanta yachachishaskanraycu, riskanmanta ni pi yachananta munarkachu. ");
INSERT INTO quhNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Paycunata nisharkataj: —Noka, Diospa cachaska Runan, sajra runaspa maquisnincuman jaywaska casaj, wañuchiwankancutaj. Quinsa p'unchaymantari causarimpusaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yachacojcunari mana yacharkancuchu Jesuspa niskanka imatachus niyta munaskanta. Chaywanpis manchachicorkancu niskanmanta payta tapuyta. ");
INSERT INTO quhNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Capernaum llajtaman chayarkancu. Wasipi cashaspataj Jesuska yachacojcunanta taporka: —¿Imamantataj tapunacusharkanquichej ñanta jamushasparí? ");
INSERT INTO quhNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ch'inllataj carkancu. Ñanta jamushaspa paycunaka churanacorkancu maykennincuchus aswan curaj caskanmanta. Chayraycu tapojtenka ni imata nerkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Chanta tiyaycuspa chay chunca iscayniyojta wajyaytawan paycunaman nerka: —Pillapis curajpaj khawaska cayta munajka, tucuy runasmanta pisipaj churacunan tiyan. Tucuypa yanapajnincutaj canan tiyan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ajinapi uj wawata chaupincupi sayacherka. Mark'aricuspataj yachacojcunanta nerka: ");
INSERT INTO quhNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Nokapi jap'icojka cayjina wawata, “Walejta jamunqui”, niyta atinman. Chaywanka noka quiquiyta nishawan. Sichus nokata, “Walejta jamunqui”, niwan chayka, mana nokallatachu nishawan. Manachayrí cachamuwajniytapis nishallantaj, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Chanta Juan Jesusta nerka: —Yachachejníy, uj runata ricorkaycu atiyniyoj sutiyquiwan supaycunata kharkoshajta. Mana kanta nokaycujina khatej caskanraycu payta jarc'ayta kallarerkaycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesús nerka: —Ama payta jarc'aychejchu. Sutiypi uj jatun t'ucuna ruwanata ruwajka, manamin chay khepanpachallataj nokamanta sajrata parlanmanchu. ");
INSERT INTO quhNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mana contranchejpi cajka nokanchejpa allinninchejpaj cashan. ");
INSERT INTO quhNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Chekata niyquichej: Pillapis ujyanapaj yacuta kosunquichejman Cristoj yachacojcunan caskayquichejraycu chayka, payman Dios cutichiponka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Nillarkataj: —Cay juch'uycitus nokapi jap'icojcunamanta ujninta, pillapis juchaman urmachinman chayka ¡ay phutiy, ari, chay runapajka! Paypajka aswan allin canman wañupunan. Allin canman paypaj jatun molino rumita cuncanman warqhuycuspa, runas jatun kochaman payta wijch'uycunancu. ");
INSERT INTO quhNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Sichus maquiyqui juchaman urmachisunquiman chayka, qhuchurpacuy. Ch'ulla maquiyojpis wiñay causayman yaycuyta atinqui. Chayka aswan allinpuni cashan iscaynin maquisniyoj uqhu pacha ninaman wijch'uycuska canayquimantaka. Chay ninaka ni jayc'aj wañunchu. ");
INSERT INTO quhNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Chaypitaj wiñay wañuypi ñac'arenkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Sichus chaquiyqui juchaman urmachisunquiman chayka, qhuchurpacuy. Ch'ulla chaquiyojpis wiñay causayman yaycuyta atinqui. Chayka aswan allinpuni cashan iscaynin chaquisniyoj uqhu pacha ninaman wijch'uycuska canayquimantaka. ");
INSERT INTO quhNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Chaypitaj wiñay wañuypi ñac'arenkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Sitajchus ñawiyqui juchaman urmachisunquiman chayka, siq'irpacuy. Ch'ulla ñawiyojpis janaj pachaman yaycuyta atinqui. Chayka aswan allinpuni cashan iscaynin ñawisniyoj uqhu pacha ninaman wijch'uycuska canayquimantaka. ");
INSERT INTO quhNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Chaypitaj wiñay wañuypi nac'arenkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","‘Chayraycu sajra munayniyquichejta atipaychej. Llaquiycunata muchuspa chay munayniyquichejta atipanquichej. Llaquiyka ninajinamin. Niskasniyta casuytaj cachijinamin. ");
INSERT INTO quhNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ajinata niskasniyta casuspa llaquiycunata muchuwajchej chayka, wiñay cusiskas canquichej. Mana urmachiskas canayquichejpaj niskasniyta casuychejpuni. Kancunapurapis allillanpi causacuychej, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Galileamanta llojsispataj Jesús rerka Judea jallp'aman Jordán mayu chimpanej jallp'asmanpis. Jakaypi purishajtintaj watejmanta may ashqha runa payman tantacamoj. Watejmanta paycunata yachachisharka costumbrenmanjina. ");
INSERT INTO quhNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Chanta fariseos Jesusman kayllamorkancu. Parlaskanpi pantachiyta munaspataj taporkancu: —¿Camachiwaskanchejmanjina uj khari warminta wijch'upuyta atillanchu? ");
INSERT INTO quhNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Payrí paycunaman nerka: —¿Imatataj Moisés camachisorkachej? ");
INSERT INTO quhNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Cuticherkancutaj: —Moiseska kharita sakellarka warminta wijch'upuyta divorcio papelta jaywaspa, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesusrí paycunaman nerka: —Moisés chayta camacherka kancuna Diospa quiquin camachiskanta mana casuyta munaskayquichejraycu, rumi sonkoyoj runas caspa. ");
INSERT INTO quhNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kallariypi Dios tucuy imata ruwarka. Chaymantapacha kharita warmitapis churarka. ");
INSERT INTO quhNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Chayraycu khareka sakenan tiyan tatanta mamantapis warminwan ujchaska cananpaj. ");
INSERT INTO quhNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Iscaynincutaj ujchaska cankancu. Ajinaka manaña iscaychu cancu, manachayrí ujllaña. ");
INSERT INTO quhNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Chayraycu Diospa ujchaskanta runaka ama t'akachunchu, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Wasipiña cashaspa yachacojcunan ujtawan chay jawa Jesusta taporkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Paycunaman nerkataj: —Pillapis warminmanta t'akanacuspa waj warmiwantaj casaracun chayka, warminpa contranpi khenchachacun. ");
INSERT INTO quhNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Sitajchus warmi kosanmanta t'akanacuspa waj khariwantaj casaracun chayka, khenchachacun, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Uj cuti wawitasnincuta Jesusman pusamusharkancu maquisninta churaspa paycunapaj Diosmanta mañaripunanpaj. Yachacojcunataj pusamojcunata c'amerkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Chayta ricuspa Jesús phiñacorka, yachacojcunanta nerkataj: —Sakeychej wawitasta nokaman jamunancuta. Amañataj paycunata jarc'aychejchu. Dios paycunajinata munacuyninwan camachenka. ");
INSERT INTO quhNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Chekata niyquichej: Waquin runas wawitajina Diosta jap'incu Camachejnincupaj. Pillapis wawitajina mana jap'ejrí janaj pachaman yaycuyta manapuni atinchu, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Paytaj wawitasta mark'aricuspa sapa ujman munacuywan maquisninta churarka, paycunapaj Diosmanta mañaripuspa. ");
INSERT INTO quhNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesús wasimanta llojsispa ñanpi cashajtinña uj runa correspa paypa ñaupakenpi konkoricorka. Taporkataj: —C'acha. Yachachejníy ¿imatataj ruwanay tiyan wiñay causay chayaketa jap'inaypaj? ");
INSERT INTO quhNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesustaj payman nerka: —Dioslla c'achaka. Chanta kanka ¿imaynapitaj noka c'acha caskayta niwanquirí? ");
INSERT INTO quhNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Yachanqui Diospa camachiskasninta: Ama khenchachacuychu; ama runata wañuchiychu; ama suwaychu; ama llullacuspa runamanta willaychu; ama pacaymanta runamanta imantapis khechuychu; tatayquita mamayquitapis casuy, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Runarí nerka: —Yachachejníy, tucuy cay Diospa camachiskasninta wawamantapacha casorkani, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesustaj payta khawaycuspa munacorka. Paytataj nerka: —Uj imallaña jarc'asunqui. Ripuy, tucuy capuyniyquita vendemuy, kolketataj wajcha runasman jaywaramuy. Ajinapi khapaj capuyniyqui janaj pachapi canka. Chanta nokawan jamuspa yachacojniy cay, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Chay niskanmantari runaj uyanka ujjinayarka. Mayta phuticuspataj riporka, may khapaj caskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Muyuyninta khawaspa Jesuska yachacojcunanman nerka: —¡Khapaj runaska janaj pachaman wiñay causayniyoj canancupajka ñac'ayta yaycuyta atenkancu! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Yachacojcunaka chay niskanmanta t'ucorkancu. Jesusrí ujtawan paycunata nerka: —Wawasníy, khapaj capuynincupi sonkoncuta churajcunaka ñac'ayta janaj pachaman yayconkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Jatun camello uywaraj astawan atinman yaycuyta agujaj ningrinman, khapaj runa janaj pachaman yaycunanmantaka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Mayta t'ucuspa yachacojcunapura tapunacusharkancu: —Ajina cajtenka ¿pitaj janaj pachaman yaycuyta atinmanrí? ");
INSERT INTO quhNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesusri paycunata allinta khawaycuspa nerka: —Cayka runacunapaj mana aticunchu. Diospajrí aticun, Dioska tucuy atiyniyoj caskanraycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Chaymanta Pedro nerka: —Khaway, nokaycu ari, tucuy imaycuta sakespa kanta khatishaycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesustaj cuticherka: —Chekata niyquichej: Uj runa atinman sakeyta wasinta chayrí waukesninta chayrí panasninta chayrí mamanta chayrí tatanta chayrí wawasninta chayrí chajrasninta. Sichus cayta saken nokaraycu sumaj willanasraycupis chayka, ");
INSERT INTO quhNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","cay p'unchaycunapi sakeskanmanta, pachaj cutis astawan cutichiska payman canka. Ajinaka wasisniyoj, waukesniyoj, panasniyoj, mamasniyoj, wawasniyoj, chajrasniyoj canka. Payri muchuchiskapis canka nokaraycu. Jakay jamoj p'unchaycunapirí wiñay causayniyojmin canka. ");
INSERT INTO quhNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ashqha runas cay pacha imasraycu sumajpaj khawaska cajcunaka jakay p'unchaypi pisipaj khawaskas cankancu. Ashqha runas cunan p'unchaycunapi pisipaj khawaska cajcunarí, jatunpaj khawaskas cankancu, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ashqha runas Jesuspis Jerusalenman ñanta risharkancu. Jesús ñaupajta rishajtin yachacojcunanka khepanta t'ucushaj khatisharkancu, ni imata paymanta yuyayta atispa. Wajcuna khaticushallarkancutaj, paycunapis manchachicuspa risharkancu. Ujtawantaj Jesús chunca iscayniyoj yachacojcunanta wajnejman pusarka. Chay jamoj p'unchaycunapi imachus paywan ruwacoj risharka, chayta paycunaman willarka: ");
INSERT INTO quhNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Khawaychej, Jerusalenman rishanchej. Chaypimin noka, Diospa cachaska Runan, yupaychana-wasimanta curajcunaman israel yachachejcunamanpis jaywaska canay tiyan. Nokata wañunaypaj juchachawankancu, waj llajtayoj runasmantaj jaywaycuwankancu. ");
INSERT INTO quhNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Paycunaka nokata asipayawankancu. Nokaman thokaycuwankancu, jasut'iwankancu, wañuchiwankancutaj. Quinsa p'unchayninmantataj causarimpusaj, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Chanta Zebedeoj wawasnin Jacobowan Juanwan Jesusman kayllaycorkancu. Nerkancutaj: —Yachachejníy, munaycu ruwapunawaycuta imatachus mañacuskaycuta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesustaj nerka: —¿Imata ruwapusunayquichejtataj munanquichejrí? ");
INSERT INTO quhNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Paycunaka cuticherkancu: —Atiyniyquiwan camachinayquipaj tiyaycuspa, kanwan cusca tiyaycuchiwaycu, ujniycuta paña ladoyquiman ujniycutataj llok'e ladoyquiman, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesusrí cuticherka: —Kancunaka mana yachanquichejchu imatachus mañacushaskayquichejta. Manchayta ñac'arinay tiyan. Chayka uj copapijina junt'aña. ¿Chayta ujyayta atiwajchejchu nokajina? ¿Atiwajchejchu ñac'ariyman yaycuyta wañuycama nokajina? ");
INSERT INTO quhNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Paycunaka nerkancu: —Arí, atiycu, —nispa. Jesustaj paycunata nerka: —Junt'a copata ujyanquichej nokajina. Wañuycama ñac'ariymantaj yaycunquichej nokajina. ");
INSERT INTO quhNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Astawanrí camachinaypaj tiyaycuspa, paña ladoyman chayrí llok'e ladoyman tiyaycuchinayka, mana nokamantachu. Manachayrí picunapajchá waquicherka, chaycunataka Dioslla tiyaycuchenka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Chayta uyarispa chay waj chunca yachacojcunanka Jacobopaj Juanpajwan phiñacorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesusri paycunata wajyaspa nerka: —Yachanquichejjina llajtasta camachejcunaka runasta llaquichispa camachiskancuta. Callpayojcunapis atiynincumanjina tucuy imapi runaswan casuchicuncu. ");
INSERT INTO quhNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kancuna uqhupeka mana ajinachu canka. Astawanrí kancunamanta pillapis atiyniyoj cayta munajka tucuy sonkowan yanapasojniyquichej canan tiyan. ");
INSERT INTO quhNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kancunamanta pillapis curajpaj khawaska cayta munajka tucuyta casoj canan tiyan. ");
INSERT INTO quhNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ajinallatataj noka, Diospa cachaska Runanpis, mana runas yanapanawancupajchu jamorkani. Manachayrí noka runasta yanapanaypaj jamorkani. Astawanpis paycuna wañunancumanta noka wañusaj juchancumanta cacharichinaypaj, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesús yachacojcunanwan Jericó llajtaman chayarkancu. Chaymanta ashqha runaswan llojsishajtincutaj, Timeoj wawan Bartimeo chay ñannejpi tiyacusharka. Payka ciego caskanraycu runasmanta mañacoj. ");
INSERT INTO quhNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nazaret llajtayoj Jesús chaynejta rishaskanta uyarispataj khapariyta kallarerka: —¡Jesús, Davidpa miraynin, qhuyacuway nokata! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Chay ashqha runastaj payta c'amisharkancu: —¡Ch'in cay! —nispa. Payri aswan sinch'ita khaparerka: —¡Davidpa miraynin, qhuyacuway! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesusri chayta uyarispa sayarka, nerkataj: —Payta wajyaychej, —nispa. Chanta ciego runata wajyaspa nerkancu: —¡Sonkochacuy, jataricuy! Kanta wajyashasunqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Payri ponchonta wijch'uricorka aswan uskhayta rinanpaj. Phinquirispataj Jesusman chimparka. ");
INSERT INTO quhNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesustaj payta taporka: —¿Imatataj ruwasunayta munashanqui? Ciegotaj cuticherka: —¡Señorníy, ricuyta munani! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesusri payta nerka: —Ripullayña. Diospi jap'icuskayquiraycu thañiskaña canqui, —nispa. Chay quiquinpacha ciegoka ricuyta aterka. Ñantataj Jesusta khaticorka. ");
INSERT INTO quhNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jerusalenman kayllasharkancu. Betfagé, Betania ranchos chekanpi Olivos niska orkonejpi cashajtincuña Jesuska iscay yachacojcunanta cachaspa nerka: ");
INSERT INTO quhNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Riychej chimpa ranchoman. Chayman yaycuspataj manaraj chajnana malton burrota wataskata tarinquichej. Chay burrota phascaraspataj cayman khatimuychej. ");
INSERT INTO quhNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Sichus mayken tapusonkachej: “¿Imaraycutaj burrota phascarashanquichej?” chayka, payta niychej: “Señorninchej cayta munan. Chaywanpis cunanpacha cutichimpusonka”, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Chay iscay yachacojcunataj rispa burrota tariparkancu puncu jawapi ñan kayllapi wataskata. Paycuna burrota phascarasharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Chaypi cajcunamanta waquintaj taporkancu: —¿Imatataj ruwashanquichej? ¿Imapajtaj burrota phascarashanquichej? ");
INSERT INTO quhNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Paycunari cuticherkancu Jesuspa quiquin niskanwan. Chaypi cajcunataj sakellarkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Burrotataj khaterkancu Jesusman. Ponchosnincuta burroman caronaycorkancu. Jesustaj burroman llok'arka. ");
INSERT INTO quhNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Pay rishajtintaj ashqha runas ponchosnincuta ñanninman mast'arkancu chay patata rinanpaj. Waquinpis camposmanta sach'a k'omercunata c'utumuspa mast'ashallarkancutaj. ");
INSERT INTO quhNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ñaupajta rejcunapis khepanta rejcunapis khaparisharkancu: —¡Dios yupaychaska cachun! ¡May jatunchaska Israelman Diospa cachamuskanka! ");
INSERT INTO quhNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Unay tatanchej Davidpa jamoj llajtanka jatunchaska cachun! ¡Camachejninchej cunan jamushan! ¡Janaj pachapi Dioska may yupaychaska cachun —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jerusalenman chayaspa yupaychana-wasiman Jesús yaycorka. Chaypitaj tucuy imata sumajta khawarka. Chanta ch'isiyaycuyña caskanraycutaj chunca iscayniyoj yachacojcunanwan Betaniaman rerka. ");
INSERT INTO quhNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","K'ayantintaj Betaniamanta llojsispa Jesús yarkhachicorka. ");
INSERT INTO quhNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Carumanta uj higo sach'ata laphisniyojta ricuspa chimpaycorka higos canmanchus manachus chayta masc'ananpaj. Chimpasparí ni imata tarerkachu, manachayka laphisllata. Manaraj higospa tiemponchu carka. ");
INSERT INTO quhNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yachachinanpajtaj sach'ata nerka: —¡Amaña ni jayc'aj wiñaypaj ni pi pokoyniyquita miqhuchunchu! —nispa. Yachacojcunantaj chay niskanta uyarerkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jesús yachacojcunanwan Jerusalenman chayaspa yapaychana-wasiman yaycorka. Chanta payka yupaychana-wasej pationpi vendejcunata rantejcunatawan kharkoyta kallarerka. Kolke cambiajcunaj mesasnincuta, jaywana paloma vendejcunaj tiyacunasnincutawan tijrararka. ");
INSERT INTO quhNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Manataj ni pitapis sakerkachu ni imata chayninta apananta. ");
INSERT INTO quhNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Chaymantataj yachachisharka: —Chekata Dios palabranpi nin: “Yupaychana-wasiyka nokamanta mañacuna wasimin canan tiyan tucuy llajtasmanta runacunapaj”. Kancunarí pacaymanta suwanayquichejpaj ruwaycacapunquichej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Yupaychana-wasimanta curajcuna israel yachachejcunapiwan chayta uyarispa imaynapi Jesusta wañuchiyta masc'asharkancu. Paytarí manchachicorkancu tucuy chay ashqha runas paypa yachachiskanta sumajpaj khawaskancuraycu. ");
INSERT INTO quhNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ch'isiyaytataj Jesús yachacojcunanwan llajtamanta llojsiporkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","K'ayantin tutamanta llajtaman cutishaspa chay higo sach'ata ricorkancu saphinmantapacha ch'aquiskata. ");
INSERT INTO quhNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Chanta Pedroka Jesuspa niskanmanta yuyaricuspa payta nerka: —¡Yachachejníy, khaway! ¡Contranpi c'amerkanqui, chay higo sach'aka ch'aquipuska! ¿Imaynataj cayrí? ");
INSERT INTO quhNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesustaj cuticherka: —Diospi jap'icuychej. ");
INSERT INTO quhNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Chekata niyquichej: Pillapis cay orkota ninman: “Caymanta okhariska cay, jatun kochamantaj wijch'uycuska cay”, nispa chayka, paypaj ruwaconka. Astawanrí payka Dios chayta ruwananta tucuy sonkowan creeshananpuni tiyan mana iscayrayaspa. ");
INSERT INTO quhNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Chayraycu niyquichej: Imatachus Diosmanta mañacunquichej, paypi jap'icuspapuni tucuy sonkowan creeychej mañacuskayquichejta kosuskayquichejtaña, capusonkachejtaj. ");
INSERT INTO quhNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Chaywanpis Diosmanta mañacushaspa runasta perdonaychej. Imamantapis pipaj phiñaska cawajchej, chayta konkapuychej. Ajinata runasta perdonaychej janaj pachapi caj Dios Tatayquichejpis pantaskasniyquichejmanta perdonasunayquichejpaj. ");
INSERT INTO quhNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Sitajchus mana perdonanquichejchu chayka, janaj pachapi caj Dios Tatayquichej manallataj kancunatapis perdonasonkachejchu, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jesús yachacojcunanwan ujtawan Jerusalenman chayarkancu. Yupaychana-wasi patiopi pay purishajtintaj israel curajcuna payman chimpamorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Nerkancutaj: —Niwaycu ¿ima atiywantaj cay imasta ruwashanqui? Chayrí ¿pitaj cay atiyta kosorka cay imasta ruwanayquipaj? ");
INSERT INTO quhNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesusrí cuticherka: —Nokapis ujta tapuskayquichej, kancunapis cutichiwaychej. Chanta willaskayquichej ima atiywanchus cay imasta ruwaskayta. ");
INSERT INTO quhNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Niwaychej ¿pitaj cachamorka Juanta runasta bautizananpaj? ¿Dioschu chayrí runaschu? Cutichiwaychej, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Paycuna uqhutaj tanteyacuspa ninacusharkancu: —Sichus nisunman: “Dios payta cachamorka”, nispa chayka, Jesús tapuwasun: “¿Imaraycutaj payta mana creerkanquichejchu?” ");
INSERT INTO quhNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Nitaj atinchejchu niyta runas payta cachamuskancuta, —nispa. Runaska tucuy sonkowan creerkancu Juan Diospa willajnin caskanta. Chayraycu paycunata manchachicuspa chay churanacojcunanka. ");
INSERT INTO quhNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Jesusman cuticherkancu: —Mana yachaycuchu, —nispa. Jesustaj paycunaman nerka: —Ni nokapis willaskayquichejchu ima atiywanchus cay imasta ruwaskayta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesuska quiquinchanaswan paycunaman parlayta kallarerka. Nerkataj: —Uj runa jallp'anpi ashqha uva sach'itasta yuracharka, perkawan muyuycucherka. T'okota allaspataj uva sarunata ch'irwanapaj, alto wasitataj khawanapaj ruwarka. ‘Llanc'ajcunamantaj jallp'anta arrendaycorka. Chanta jallp'ayoj runaka caru llajtaman riporka. ");
INSERT INTO quhNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Uva pallana tiempopitaj camachinta llanc'ajcunaman cacharka pokoyninmanta payman konancupaj. ");
INSERT INTO quhNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Llanc'ajcunarí payta jap'ispa sinch'ita makarkancu mana imayojllatataj cachaporkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ujtawan jallp'ayoj runaka waj camachinta cacharka. Paytari umanpi sinch'ita tacarkancu chaywanpis p'enkayta ruwarkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ujtawan cacharka wajta. Paytari wañucherkancu. Ashqha wajcunata cachallarkataj. Llanc'aj runasrí chay cachasmanta waquinta sek'orkancu, waquintataj wañucherkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","‘Jallp'ayoj runajtaka caporkaraj ujwan. Cayrí carka may munaska wawan. Chay khepapitaj cay wawanta cacharka. Nisharkataj: “Wawaytaka jatunpaj khawankancupuni”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Chay llanc'aj runasrí ninacusharkancu: “Cay wawanka cay jallp'ata tatanmanta jap'enka. Jacu payta wañuchisun jallp'an nokanchejpata cananpaj”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Payta jap'ispa wañucherkancu, jallp'amantataj wijch'orkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","¿Imanankataj uva jallp'ayoj señorka chay llanc'aj runastarí? Cayta ruwanka: Jamuspa chay llanc'aj runasta wañurachenka. Waj llanc'ajcunamantaj jallp'anta arrendanka. ");
INSERT INTO quhNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","‘Cayta Diospa palabranpi ¿manachu leerkanquichej? “Wasichajcuna rumita khawaspa khesacharkancu. Wasita sinch'ita sayachinanpajrí chay khesachaska rumeka aswan sumaj carka”. ");
INSERT INTO quhNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Chaytaka Señor Dios ruwan. Nokanchejpajtaj uj t'ucuna cashan, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tucuy chay israel curajcunaka reparacorkancu Jesús chay quiquinchanawan paycunamanta parlaskanta. Chayraycu payta jap'iycuchiyta churacorkancu. Astawanrí chay ashqha runasta manchachicorkancu. Payta sakespataj riporkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Churanacojcunanka Jesusman waquincunata cacharkancu. Chay cachaskasri carkancu fariseocunamantawan Herodesta khatejcunamantawan. Paycunaka Jesusta parlaskanpi pantachispa jap'iycuyta munasharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Jamuspataj nerkancu: —Yachachej, yachaycu parlaskayqueka cheka caskanta. Runastapis mana rijch'acuynillanmantachu khawanqui, manachayrí caskancumanta. Chaywanpis cheka cajta yachachishanqui imatachus Dios munan runas ruwanancuta. Cunan kan niwaycu: ¿Nokanchej, israelcuna, Romano gobiernoman impuestota konachu? ¿Konanchejchu chayrí manachu konanchej? —nerkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesús allinta yacharka puraj uyawan tapuskancuta. Chayraycu paycunata nerka: —¿Imaraycutaj pantachiwayta munanquichejrí? Uj kolketa apamuwaychej khawanaypaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Paymantaj apamorkancu. Chanta Jesús taporka: —¿Pejpa uyantaj pejpa sutintaj cay kolkepi cashanrí? Cuticherkancu: —Romano curaj camachej Cesarpata, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Chayraycu Jesús paycunata nerka: —Cesarpata cajtaka Cesarman koychej; Diospata cajtataj Diosman koychej, —nispa. Paymanta t'ucorkancu chay cutichiskanmanta. ");
INSERT INTO quhNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Saduceos nej cancu wañuska runaska mana causarimunancuta. Paycunamanta waquin Jesusman jamuspa nerkancu: ");
INSERT INTO quhNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Yachachej, Moisés nokanchejpaj kelkarka: “Sichus uj casaraska runa mana wawayoj wañupunman chayka, paypa wauken casarachun wañojpa viudanwan. Chayta ruwachun wawa cananpaj curaj waukenpa sutin ama chincapunanpaj”. ");
INSERT INTO quhNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Cunanri, carkancu kanchis waukes. Curaj cajka casaracorka mana wawayojtaj wañuporka. ");
INSERT INTO quhNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Chanta iscay caj khareka wañoj waukenpa viudanwan casaracorka. Paypis wañuporka mana ni uj wawata rejsispa. Quinsa cajwanpis quiquillantaj carka. ");
INSERT INTO quhNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ajinataj carka kanchis waukesnintinwanpis. Sapa uj curaj waukenpa viudanwan casaracorka. Sapa ujtaj mana ni uj wawata rejsispa wañuporka. Khepata chay warmipis wañupullarkataj. ");
INSERT INTO quhNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Cunanka, wañuska runas causarimojtincu chay warmi kanchis runaswan casaracuskanmanta ¿maykennincoj warmintaj cankarí? —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesustaj paycunaman cuticherka: —Diospa palabranta mana entiendenquichejchu nitaj atiynintapis rejsinquichejchu. Chayraycu cay imaspi pantaskas canquichej. ");
INSERT INTO quhNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Imaynachus Diospa angelesnenka mana casaracuncuchu, ajinallataj causarimuskancumanta runas mana casaraconkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Chaywanpis wañuska causarimpunancumantari: Moisespa libronpi kelkaskataka ¿manachu leerkanquichej? Dios nina lauraj sach'itamanta nimorka: “Noka cani Abrahampa Diosnin, wawan Isaacpata Diosnin, allchhin Jacobpatapis Diosnintaj”, nispa. Chayta nerka chay runas unay wañupuskancu khepataña. ");
INSERT INTO quhNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Diospajka wañuskaspis causashancu. Chayraycu pay mana wañuskacunaj Diosnincuchu, manachayrí causashajcunaj Diosnincumin. Kancunaka ancha pantaskas canquichej, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Israel yachachejcunamanta ujri tapunacuskancuta uyarerka. Jesús sumajta cutichiskantapis ricorka. Chayraycu payman kayllamuspa taporka: —Yachachejníy, tucuy camachiskacunamanta ¿maykentaj aswan jatun caj camachiskarí? ");
INSERT INTO quhNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesustaj cuticherka: —Aswan jatun caj camachiskaka caymin: “¡Israel runacuna uyariychej! Señor Diosninchejka sapan c'ata Señormin. ");
INSERT INTO quhNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Munacuy Señor Diosniyquita tucuy sonkoyquiwan, tucuy causayniyquiwan, tucuy yuyayniyquiwan, tucuy callpayquiwanpis”. ");
INSERT INTO quhNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Iscay cajtaj cay: “Runa-masiyquita munacuy kan quiquiyquitajina”. Caycunamanta aswan jatun camachiskaka mana canchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Chanta chay yachachejka Jesusta nerka: —Arí, Yachachejníy, sumajta ninqui. Dioska sapan c'ata caskanta, paymanta wajka mana caskantapis. ");
INSERT INTO quhNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Sichus uj runa Señor Diosninta munacun tucuy sonkonwan, tucuy yuyayninwan, tucuy causayninwan, tucuy callpanwanpis chayka, Diosta cusichin. Runa-masintapis munacunan tiyan pay quiquintajina. Ajinata Diosta cusichiyka aswan curaj cashan tucuy jaywanasmanta niskaka. Cachun uywa ruphachiska jaywana chayrí waj jaywanapis, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Sumaj yuyaywan cutichiskanta ricuspataj Jesuska nerka: —Kanka, Diospa camachiskanta casunayquipajjina cashanqui, —nispa. Manaña ni pipis astawan Jesusta tapoj churacorkachu. ");
INSERT INTO quhNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yupaychana-wasi patiopi yachachishaspataj Jesús nerka: —Israel yachachejcunaka nincu, Cristoka Davidpa miraynin caskanta. ¿Imaynapitaj ajinata nincurí? ");
INSERT INTO quhNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Quiquin David Santo Espiritunejta sut'inchaska caspa cayta nerka: Señorninchej Dios nerka Señorniy Cristoman: “Tiyaycuy nokawan cusca camachinanchejpaj churanacojcunayquita k'alata atipanaycama”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ajinata David quiquinpis Cristota, “Señorniy”, nispa, suticharka. Chanta ¿imaynatataj Cristoka Davidpa miraynillan canman? —nerka Jesús. Chay ashqha runastaj cusiywan payta uyarej cancu. ");
INSERT INTO quhNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yachachispataj Jesuska nisharka: —Sumajta khawacuychej waquin israel yachachejcunamanta. Paycuna puriyta munancu sumaj p'achalliskas. Munancutaj plazaspi paycunata sumajta napaycunata. ");
INSERT INTO quhNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Tantacuna-wasipitaj curajcunaj tiyanasnincupi tiyacuyta munancu. Jatun miqhunaspipis sumaj khawaskacunaj tiyanasnincupi tiyacuyta munancu. ");
INSERT INTO quhNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Chaywanpis viudaspa pisi capuynincuta suwaspajina khechuncu. Diosmanta anchata mañacushaskancuwan sajra munaynincuta pacayta munancu. Cay runasta Dioska aswan sinch'iwan juchachanka, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yupaychana-wasipitaj kolke churana kayllanejpi Jesuska tiyacusharka. Ajinapi ricorka imaynata chay ashqha runas Diosman konancupaj kolke churanaman kolketa churashaskancuta. Ashqha khapajcunaka ashqhata churasharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Uj wajcha viudapis jamuspa iscay kolkesitusninta churarka. ");
INSERT INTO quhNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesustaj yachacojcunanta wajyaspa paycunata nerka: —Chekata niyquichej: Kolke churanaman cay ancha wajcha viudaj churaskanta khawaychej. Tucuy waj runaspa churaskancumantaka aswan ashqha carka Diospa yuyayninpeka. ");
INSERT INTO quhNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tucuy chay waj runaska ashqha capuynincoj puchuskanmanta Diosman korkancu. Payrí wajcha cayninmanta tucuy kolkenta korka. Chayka causananpaj casharkapis, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yupaychana-wasimanta Jesús llojsishajtin, yachacojcunamanta ujnin caj yupaychana-wasita sumajta khawaspa nerka: —¡Yachachejníy, khaway, cay wasichaycunata! ¡May jatuchej rumis wasispis cancu! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesustaj payman nerka: —Tucuy cay jatun rumi wasista ricushanquichej, chaycunaka urmachiskas cankancu. Ni uj rumillapis sayashaj sakeskachu canka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Chanta yupaychana-wasej chimpan Olivos orkoman chayaspa Jesús tiyaycucorka. Chaypi sapallan tiyacushajtintaj Pedro, Jacobo, Juan, Andreswan payman jamuspa taporkancu: ");
INSERT INTO quhNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Willawaycu ¿mayc'ajtaj ajina canka? ¿Imastaj ricuchiwasajcu tucuy cay imas tucucunayashaskantarí? —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús paycunaman parlayta kallarerka: —Sumajta khawacuychej ama pantachiskas canayquichejpaj. ");
INSERT INTO quhNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Sutiypi ashqha runas llullacuspa jamonkancu. Nenkancutaj: “Nokamin Cristoka cani”, nispa. Ashqhastataj pantarachenkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","‘Chaywanpis guerrasmanta uyarispa guerrasmanta parlajta uyarispapis ama manchachicuychejchu. Cay imaska cananpuni tiyan. Astawanrí manaraj tucucuyrajchu canka. ");
INSERT INTO quhNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Uj ayllu waj aylloj contranpi okhariconka. Uj llajtayoj runas waj llajtayoj runaspa contranpi okhariconkancu. May sinch'ita jallp'apis qharcatitenka caynejpi jakaynejpitaj. Manchay yarkhaycuna canka. Chay imasrí onkocoj warmej nanayninpa kallariyninjina cashan. ");
INSERT INTO quhNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","‘Astawanka kancuna quiquiyquichejta khawacuychej. Israel curajcunaj ñaupakencuman jaywaycusonkachej. Tantacuna-wasispitaj sek'osonkachej. Camachejcunaj ñaupakencuman curaj camachejcunaj ñaupakencumanpis pusasonkachej yachacojcunay caskayquichejraycu. Ajinapi kancuna paycunaman willaranquichej. ");
INSERT INTO quhNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Manaraj tucucuytari sumaj willanaska willaraskaraj canan tiyan tucuy runasman. ");
INSERT INTO quhNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Curajcunaman jaywaycoj pusasojtiyquichejka, ama ñaupajta sonkoyquichejpi manchachicuspa yuyaychejchu imatachus ninayquichejta. Astawanpis Santo Espíritoj chay ratupi sonkoyquichejman churaskanta, chayta niychej. Manamin kancunallachu parlajcunaka canquichej, manachayrí Santo Espíritu. ");
INSERT INTO quhNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Uj waukeka waukenta jaywayconka wañuchiska cananpaj. Uj tatapis wawanta jaywayconka. Wawaspis tatasnincoj contrancupi okharicullankancutaj wañuchichinancupaj. ");
INSERT INTO quhNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kancunatapis tucuy runas chejnisonkachej yachacojcunay caskayquichejraycu. Tucucuycama Diospi confiacuspa muchojrí wiñay causayniyoj canka. ");
INSERT INTO quhNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","‘Leejka cayta sumajta reparachun: Dios millachicun, chay thuñispa tucuchejta, maypi mana cananchu ricunquichej. Chayta ricuspaka Judea jallp'api cashaj runas orkosman aykecuchuncu. ");
INSERT INTO quhNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Pillapis wasimanta jawapi cashajka ama yaycuchunchu capuyninta okharicojka. ");
INSERT INTO quhNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Pillapis chajrapi cashajka amallataj cutiycuchunchu ponchonta okharejka. ");
INSERT INTO quhNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Ay phutiy, ari, chay p'unchaycunapi wijsayoj warmispaj ñuñushaj wawitasniyojcunapajpis! ");
INSERT INTO quhNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Diosmanta mañacushaychej ama para tiempopi aykecunayquichej cananpaj. ");
INSERT INTO quhNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Chay p'unchaycunapeka ñac'ariy canka. Chayjina ñac'ariyka mana carkachu cay pacha kallariypi Dios tucuy imata ruwaskanmantapacha cunancama. Nitaj jayc'ajpis ajinaka cankachu. ");
INSERT INTO quhNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Sitajchus Señor Dios chay ñac'ariy tiempota mana pisiyachinmanchu chayka, ni pi causanmanrajchu. Astawanrí paypa ajllacuskasninraycu chay tiempota pisiyachenka yuyaskanmanjina. ");
INSERT INTO quhNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","‘Chay p'unchaycunapi sitajchus pipis nisunquichejman: “¡Khaway, caypi Cristo cashan!” chayrí “¡Jakaypi cashan!” chayka, ama payta creeychejchu. ");
INSERT INTO quhNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Llulla cristocuna llulla willajcunapis riqhurimonkancu. Chaywanpis ricuchinasta t'ucuna ruwanastawan ruwankancu Diospa ajllacuskasnintapis pantachinancupaj, sichus aticunman chayka. ");
INSERT INTO quhNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kancunaka allinta khawacuychej. Tucuy imata manaraj ruwacushajtin ñaupajtaña nerkayquichej. ");
INSERT INTO quhNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","‘Astawanrí chay p'unchaycunapi runas ñac'ariskancumanta khepanta inti lakhayaycaponka quillapis manaña c'anchamonkachu. ");
INSERT INTO quhNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Patamanta koyllurcuna urmarankancu. Cielopi cajcunata Dios cuyuchenka. ");
INSERT INTO quhNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Chaymantamin runas ricuwankancu jamushajta phuyus chaupita. Noka, Diospa cachaska Runanka, jatun atiyniywan lliphipej c'anchaywanpis jamusaj. ");
INSERT INTO quhNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Chaypacha Dioska angelesninta cachaspa ajllacuskasninta tucuy cay pachamanta tantachimonka. ");
INSERT INTO quhNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","‘Cay quiquinchanata higo sach'amanta yachacuychej: Maypachachus ramasnin k'omeryamun laphisnin p'uturamushajtinñataj kancuna yachanquichej k'oni tiempo chayamushaskantaña. ");
INSERT INTO quhNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ajinallatataj chay manchay imasta ricuspaka yachanquichej cutimunay p'unchayka kayllallapiña caskanta. ");
INSERT INTO quhNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Chekata niyquichej: Tucuy cay imaska canka manaraj cay p'unchay runas wañurapushajtincu. ");
INSERT INTO quhNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Cielospis jallp'apis tucucaponkancu; nokaj niskasniyrí wiñaypaj mana tucucaponkachu. ");
INSERT INTO quhNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Chay p'unchaytarí ni pi yachanchu ima ratuchus cananta, Tatay Dioslla yachan. Ni janaj pachapi angeles nitaj noka, paypa Wawanpis, yachanichu. ");
INSERT INTO quhNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","‘Rijch'ariskas sumajta khawacushaychej, Diosmanta mañacuspapuni. Manamin yachanquichejchu ima ratutachus cutimunayta. ");
INSERT INTO quhNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Uj wasiyoj runaka caruman rinanpaj, wasinmanta manaraj llojsishaspa camachisninman atiyta kon ruwananmanjina sapa uj ruwashananpaj. Puncu khawajtapis camachin, pay cutimunanpaj rijch'ariska wakaychananta. ");
INSERT INTO quhNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ajinata kancunapis rijch'ariskas allinta wakaychacushaychej. Manamin yachanquichejchu ima ratutachus noka, Señorniyquichej, jamunayta, ch'isiyaycuytachus, chaupi tutatachus, gallo wakaytachus, chayrí sut'iyamuytachus. ");
INSERT INTO quhNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Pajtataj, ujllata mana yuyaskayquichejta Señorniyquichej cutimunman puñushajtataj taripasunquichejman. ");
INSERT INTO quhNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kancunaman niskaytaka tucuyman nishani: ¡Rijch'ariskas allinta wakaychacushaychej! —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Iscay p'unchayllaña casharka israelcunaj pascuancuman, Dios unay tatasnincuta cacharichiskanta yuyarichinapaj. Chay p'unchaycunapi mana pokochinayoj t'antata miqhunancu caj. Chay p'unchaycunapitaj yupaychana-wasimanta curajcunawan israel yachachejcunapiwan Jesusta wañuchinancupaj, pacayllamanta jap'iycuchiyta masc'asharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ninacusharkancutaj: —Ama jatun p'unchaycunapeka jap'iycuchisunchu, ama manchay ch'ajwata runas okharinancupaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Betania llajtapi Jesús casharka, lepra onkoyniyoj niska Simonpa wasinpi. Chaypi miqhushajtintaj uj warmi yaycumorka, c'achitu rumi yuritupis okhariska. Yuritoka nardo purumanta sumaj k'apayniyoj aceitejinawan junt'a carka. Chaytaj ashqha kolkewan rantiska carka. Warmitaj yurituta p'aquerkospa chay k'apayniyoj aceitejinata Jesuspa umanman jich'aycuspa jawiycorka. ");
INSERT INTO quhNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Chaypi cajcunamantataj waquin phiñacuspa paycunapura ninacusharkancu: —¿Imaraycutaj cay sumaj k'apayniyoj aceitejinata usuchishanrí? ");
INSERT INTO quhNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Uj wata pagopajjina vendecunman carka. Chay kolketaj wajcha runasman koska canman carka, —nispa. Mayta phiñacuspa warmitaka sinch'ita c'amerkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesusrí nerka: —Sakeychej. ¿Imaraycutaj payta llaquichishanquichejrí? Chaywanka may sumaj cajta ruwapuwarka nokapaj. ");
INSERT INTO quhNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Wajcha runaska kancunawanpuni cashancu. Mayc'ajpis paycunata yanapayta munanquichej chayka, atillanquichej. Nokarí mana unaytañachu kancunawan casaj. ");
INSERT INTO quhNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Payka atiskanta ruwarka. Jawiwaspa p'ampacuyniypaj waquichiwarka ñaupajtaña manaraj wañushajtiy. ");
INSERT INTO quhNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Chekata niyquichej: Tucuy cay pachapi sumaj willanasta mayllapipis willaraspaka, chaypi cay warmej ruwaskanmantapis parlankancu paymanta yuyaricuspa, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Iscariote niska Judaska Jesuspa chunca iscayniyoj cachasninmanta ujnin carka. Payka yupaychana-wasimanta curajcunaman Jesusta jaywaycunanpaj rerka. Nerkataj: —Noka Jesusta jaywaycuskayquichej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Chayta uyarispa paycunaka mayta cusicorkancu. Judastataj nerkancu: —Payta jaywaycuwaskaycumanta kanman kolketa kosajcu, —nispa. Ajinamanta Judaska unanchacuspa masc'aj churacorka mayc'ajchus aswan allin canman Jesusta jaywaycunanpaj. ");
INSERT INTO quhNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mana pokochinayoj t'anta miqhuna p'unchaycuna chayamorka. Ñaupaj caj p'unchaypeka wañuchinancu carka pascua corderota. Chay p'unchaypi yachacojcunan Jesusta nerkancu: —Pascua miqhunata miqhunayquipaj ¿maypitaj munanqui waquichimunaycuta? ");
INSERT INTO quhNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ajinapi yachacojcunanmanta iscayta cacharka. Paycunatataj nerka: —Riychej llajtaman. Chaypitaj uj yacu p'uñuta apaj runawan tincunquichej. Payta khatiychej. ");
INSERT INTO quhNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Yaycuskan wasipitaj wasiyoj runata niychej: “Yachachejninchej nisunqui: ‘Nokapaj sala ¿maypitaj cashan yachacojcunaywan pascua miqhunata miqhunaypaj?’ nispa”. ");
INSERT INTO quhNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Paytaj uj jatun salata altos wasipi ricuchisonkachej. Chay salataj allinchaska tucuy imayojña cashan. Chaypi waquichimuychej nokanchejpaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Chaymanta llajtaman rispa chay iscay yachacojcunaka tarerkancu tucuy imasta Jesuspa niskanmanjina. Chanta pascua miqhunata waquicherkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ch'isiyaytataj Jesús chay chunca iscayniyojwan chayman chayarka. ");
INSERT INTO quhNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Tiyacuspa miqhushajtincutaj Jesús nerka: —Chekata niyquichej: Kancunamanta ujniyquichej nokawan miqhojmin jaywaycuwanka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Paycunari llaquicuyta kallarerkancu, ujmanta ujtaj Jesusta nerkancu: —¡Mana nokaka caymanchu! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesusri paycunata nerka: —Kancuna chunca iscayniyoj yachacojcunaymanta uj cashan. Payka nokawan cusca t'antata chuwapi chhapushan. ");
INSERT INTO quhNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Noka, Diospa cachaska Runanka, rishani, Diospa palabranpi nokamanta niskanmanjina. Astawanrí ¡ay phutiy, ari, noka jaywaycojpajka! Allin canman carka chay runapajka mana nacecunan, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Miqhushajtincutaj Jesús t'antata maquisninwan jap'ispa Diosman graciasta korka. Chanta t'antata partispa sapa ujman jaywaspataj nerka: —Cayta miqhuychej. Cayka cuerpoy ninacun, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Copatapis jap'ispa Diosman graciasta kospa paycunaman jaywarka. Tucuynincutaj ujyarkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Paycunaman Jesús nerkataj: —Cay yawarniyka Diospa mosoj traton atiyniyoj cananpaj jich'askamin. Yawarniyka ashqha runacunapaj jich'aska canka paycuna ama wiñaypaj wañunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Chekata niyquichej: Manaña ujyasajchu cay uvasmanta ruwaskata chay p'unchaycama. Chanta mosojta ujyasaj Tataywan kancunapiwan, —nerka Jesus. ");
INSERT INTO quhNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Chanta Diosta yupaychanancupaj taquiytawan chay salamanta llojsispa Olivos orkoman rerkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yachacojcunamantaj Jesús nerka: —Cunan tuta tucuyniyquichej nokata sakerpayawanquichej. Cayka canka Diospa palabranpi niskanmanjina: “Michejta wañuchisaj, ovejastaj ch'ekeraskas cankancu”. ");
INSERT INTO quhNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Astawanrí wañuymanta causarimuspa Galileaman ñaupaskayquichej, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedrotaj Jesusman nerka: —Tucuynincu sakerpayasuncuman chaypis, nokaka manapuni, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesustaj Pedrota nerka: —Chekata niyqui: Cunan tutapacha, manaraj gallo iscay cutita wakashajtin, kanka quinsa cutitaña ninqui, nokata mana rejsiwaskayquita, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pedroka atipacuspa sinch'iwan nerka: —Sichus kanwan cusca wañunay canman chaypis, ni jayc'aj nisajchu, kanta mana rejsisuskaytaka, —nispa. Ajinallatataj tucuynincu nerkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jesuska Getsemaní niska huertaman chayaspa yachacojcunanman nerka: —Caypi tiyaricushaychej noka Diosmanta mañacamunaycama, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Jesusri pusacorka Pedrota, Jacobota, Juantawan. Sonkonpitaj kallarerka may llaquiywan t'ucurayayta jatun phutiyninpi. ");
INSERT INTO quhNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Paycunatataj nerka: —Manchay llaquiska cani, llaquiywantaj wañunayashaniña. Caypi suyaychej, wakaychacuychejtaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ajinapi Jesuska tumpatawan ñauparispa uyan pampacama c'umuycorka. Diosmantataj mañacorka, sichus aticunman chayka, chay manchay ñac'ariynenka khechuska cananta. ");
INSERT INTO quhNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Mañacuspataj nerka: —Munaska Tatáy, kanpajka tucuy ima aticun. Cay ñac'ariypi wañunayta nokamanta khechupuway. Astawanrí ama nokaj munayniyka ruwacuchunchu, manachayka kanpa munayniyqui ruwacuchun, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Chanta cutimuspa chay quinsantinta puñushajta taripaspa, Pedrota nerka: —Simón ¿puñushanquichu? ¿Manachu uj ratullatapis rijch'ariska cayta aterkanqui? ");
INSERT INTO quhNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Rijch'ariskas wakaychacuychej Diosmanta mañacuychejtaj juchaman ama urmachiskas canayquichejpaj. Allin cajta ruwayta munashanquichej, chaypajrí kancunaka mana callpayojchu canquichej, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Chanta ujtawan rispa chay quiquillantataj Diosmanta mañacusharka. ");
INSERT INTO quhNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ujtawan cutimuspapis paycunata puñushajllatataj tariparka, puñuywan atipaskas cashaskancuraycu. Chaymantataj ni imata aterkancuchu cutichiyta. ");
INSERT INTO quhNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Quinsa caj cutipi cutimuspataj paycunata nerka: —¿Puñushanquichejpunichu? ¡Puñucullaychej! ¡Chayllataña! Chay hora chayamunña. Uyariychej: Noka, Diospa cachaska Runanka, juchasapaspa maquisnincuman jaywaycuskaña cashani. ");
INSERT INTO quhNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Jataricuychej, jacu ripuna! ¡Khaway, jaywaycuwajniyka kayllamushanña! —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús parlashajtillanraj Judaska riqhurimorka. Payka Jesuspa chunca iscayniyoj cachasninmanta ujnin carka. Paywan cuscataj ashqha runas jamorkancu t'ujsina espadaswan makana c'aspiswan. Paycunaka israel curajcunaj cachamuskasnincu carkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jaywaycoj Judaska pusamuskacunanman ñaupajtaña yachaycuchiska: —Pitachari noka napaycuspa much'aycusaj, chaymin canka. Payta jap'ycuychej. Pusanquichej sumaj wakaychaskata, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ajinaka chayamuytawancama, Jesusman kayllaycuspa, “¡Yachachejníy!” nispa, may munacuywanjina much'aycorka. ");
INSERT INTO quhNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Chay runastaj Jesusta jap'iycorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Chaypi cajcunamanta ujnintaj espadanta siq'icuspa uj runata, wajtaspataj, ningrinta c'uturparerka. Chay c'uturpariska runari yupaychana-wasimanta curajpa camachin carka. ");
INSERT INTO quhNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Churanacojcunanman Jesuska nerka: —¿Runa wañuchi suwata jap'ejjinachu nokata jap'ej jamunquichej espadaswan c'aspiswan? ");
INSERT INTO quhNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Sapa p'unchay yupaychana-wasi patiopi yachachispa nokaka kancunawan carkani, manataj jap'iycuwarkanquichejchu. Astawanrí ajina canan tiyan Diospa palabran junt'acunanpaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Chaymantataj Jesusta sakerpayaspa, tucuynin yachacojcunan aykecorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Uj waynari jatun llijllanawan khataycucuska Jesusta khatispa risharka. Paytataj jap'iycunayasharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Payrí llijllananta sakerpayaspa k'alalla aykecorka. ");
INSERT INTO quhNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ajinamanta yupaychana-wasimanta curajpa ñaupakenman Jesusta pusarkancu. Chaypitaj chay israel curajcuna tucuynincu tantacorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedrotaj Jesusta carullamanta khaticuspa yaycorka curajpa wasi pationcama. Payka chaypi caj yanapajcunawan cusca nina kayllapi k'oñicuspa tiyaricusharka. ");
INSERT INTO quhNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Jesus chay tantacuypi cashajtin curajcunaka contranpi willajcunata masc'asharkancu payta wañuchinancupaj. Chaypaj iscay quiquin willaskasta mana tarerkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ashqha llulla willajcuna Jesuspa contranpi willasharkancu. Willaskasnincuri mana quiquinchu carka. ");
INSERT INTO quhNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Waquin llulla willajcunaka curajcunaj ñaupakencupi nisharkancu: ");
INSERT INTO quhNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Nokaycu Jesusta uyarerkaycu nishajta: “Noka cay maquiwan ruwaska yupaychana-wasita urmachisaj. Chanta quinsa p'unchaypi wajta wasichasaj mana maquiwan ruwaskata”, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Chaywanpis chay willaskasnincoka mana quiquinchu carka. ");
INSERT INTO quhNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Chanta yupaychana-wasimanta curajka paycunaj ñaupakencupi sayarispa Jesusta taporka: —¿Manachu cutichicunqui? ¿Imatataj chay runas contrayquipi willashancurí? ");
INSERT INTO quhNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesusrí ch'inlla carka nitaj ni imata cuticherkachu. Watejmanta curajka Jesusta tapullarkataj: —¿Kanchu Cristo, yupaychaska Diospa Wawan canqui? ");
INSERT INTO quhNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús cuticherka: —Noka cani. Noka, Diospa cachaska Runanta, ricuwanquichejtaj curaj atiyniyoj Dioswan cusca camachishajta. Chaywanpis phuyus chaupita atiyniywan janaj pachamanta jamushajta ricuwanquichej, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Chay niskanta uyarispataj curajka p'achasninta lliq'icorka may phiñacuskanta ricuchinanpaj. Nerkataj: —Manaña astawan willajcunata munanchejchu. ");
INSERT INTO quhNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kancuna uyarinquichejña cayjinata Diosta phiñachiskanta. ¿Kancunaman, imaynataj rijch'asunquichejtaj? —nispa. Tucuynincutaj Jesusta wañunanpaj juchacharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Paycunamanta waquintaj kallarerkancu Jesusman thokaycuyta. Uyanta khataycuspataj sajmashaspa nerkancu: —Sut'inchay ¿pitaj sajmasunqui? Yanapajcuna Jesusta pusashaspa sinch'ita makarkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro chay wasi patiopi cashajtintaj chayman jamorka curajpa wasi camachisninmanta uj imilla. ");
INSERT INTO quhNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Payka Pedrota nina kayllapi k'oñicushajta ricorka. Payta khawaycuspataj nerka: —Kanpis Nazaretmanta Jesuswanmin casharkanqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedrotaj mananchacuspa nerka: —Imatachus nishanqui mana yachanichu nitaj entiendenichu, —nispa. Chayta nispa puncunejman rerka. Gallotaj wakarka. ");
INSERT INTO quhNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Imillaka watejmanta Pedrota ricuytawan chaypi cajcunaman nerka: —Cay runaka Jesuswan purejcunamantamin, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedrori ujtawan mananchacorka. Uj chhicamantataj chaypi cajcunaka Pedrota nisharkancu: —Kanka paycunamantapuni canqui, Galileamanta caskayquiraycu. Parlaskallayquipi sut'i cashanqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Chaymantataj Pedroka niyta kallarerka: —¡Mana chekata parlani chayka, Dios wañuchiwachun! ¡Pimantachus parlashanquichej, chay runataka mana rejsinichu! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Chay quiquinpachataj iscay caj cutita galloka wakarka. Pedrotaj chayta uyarispa Jesuspa cay niskanta yuyaricorka: “Manaraj gallo iscay cutita wakashajtin, kanka quinsa cutitaña ninqui, nokata mana rejsiwaskayquita”, nispa. Uyariskantawantaj sinch'ita wakarka. ");
INSERT INTO quhNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Sut'iyamuskantawancama israel curajcunaka, tucuynincu, uj yuyayllata Jesusmanta nerkancu. Yuyaskancumanjinataj Jesustaka wataskata apaspa camachej Pilatoman jaywaycamorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatori Jesusta taporka: —¿Kanchu israelcunaj camachejnin canqui? Jesustaj payman cuticherka: —Kan ninqui, ajinamin, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Yupaychana-wasimanta curajcunataj ashqna imasta Jesuspa contranpi willasharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatoka ujtawan tapullarkataj: —¿Manachu imatapis cutichicunqui? ¡Uyariy, mashqha imastataj contrayquipi willashancu! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesusrí manaña ni imata cuticherkachu. Chayraycutaj Pilatoka mayta t'ucorka. ");
INSERT INTO quhNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Cunanka sapa pascuapi Pilatoka costumbremanjina cacharipunan caj wisk'achiska runasmanta maykentachus mañaskancuta. ");
INSERT INTO quhNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Chaypachataj uj runa, Barrabás sutiyoj, carcelpi wisk'achiska casharka. Payka ch'ajwachej-masisninwan wisk'achiska casharka runata wañuchiskancuraycu. ");
INSERT INTO quhNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ashqha runas tantacamuspataj Pilatomanta mañayta kallarerkancu, wisk'achiskacunamanta ujta cacharichipunanta costumbremanjina. ");
INSERT INTO quhNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatotaj paycunata taporka: —¿Israelcunaj camachejninta cacharimunayta munanquichejchu? ");
INSERT INTO quhNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilatoka yacharka israel curajcuna Jesusta envidiamanta payman jaywaycuskancuta. Chayraycu ajinata taporka. ");
INSERT INTO quhNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Yupaychana-wasimanta curajcunarí runasman mayta yachaycuchisharkancu Pilatomanta astawanpis mañanancupaj Barrabasta cacharimunanta. ");
INSERT INTO quhNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatotaj ujtawan chay tantaska runasta taporka: —¿Imanasajtaj chanta, israelcunaj camachejnin niskatarí? ");
INSERT INTO quhNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Runacunataj khaparispa cuticherkancu: —¡Chacataska cachun! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatorí tapullarkataj: —¿Ima mana allintataj pay ruwarkarí? Paycunataj aswan sinch'ita khaparerkancu: —¡Chacataska cachun! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatotaj chay khaparejcunata cusichiyta munaspa, Barrabasta cachariporka. Jesustarí jasut'iskanmantaña chacataska cananpaj soldadosman jaywaycorka. ");
INSERT INTO quhNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Soldadosri gobierno wasi patioman Jesusta pusaycorkancu. Chaypitaj tucuy soldadomasisnincuta wajyarkancu tantacunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Jesusta asipayanancupajtaj camachejtajina p'achallicherkancu culli-puca p'achawan. Qhishcamanta uj pilluta simp'aspataj umanman churarkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Payta napaycuyta kallarerkancu: —¡Viva, israelcunaj camachejnin! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Sokoswantaj umanpi wajtasharkancu, thokaycusharkancu, yupaychanancupajjinataj ñaupakenpi konkoriycusharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Jesusta asipayayta tucuskancumanta khepatataj chay culli-puca p'achata orkhospa payta p'achasninwan p'achallichiporkancu. Chanta payta jawaman pusarkancu chacatanancupaj. ");
INSERT INTO quhNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jesusta ñanta pusashaspa soldadoska llajtaman uj yaycumushaj runata tariparkancu. Payka Cirene llajtayoj Simón carka, Alejandrojta Rufojtawan tatancu. Soldadostaj Simonta jap'ispa camacherkancu Jesuspa llasa chacatana cruzninta apananta. ");
INSERT INTO quhNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Llajta jawaman Jesusta pusarkancu Gólgota sutiyoj lugarman. Cay niyta munan T'ojlu Lugar. ");
INSERT INTO quhNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Jesusmantaj mirra jampiwan chajruska vinota ujyachiyta munarkancu. Payrí chayta mana ujyarkachu. ");
INSERT INTO quhNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Jesusta chacatarkancu. Soldadosri paypa p'achasninta partinacunancupaj sorteyanacorkancu pipajchus sapa p'acha canman, chayta yachanancupaj. ");
INSERT INTO quhNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Chacataskancu horaka chaupi pakarinña carka. ");
INSERT INTO quhNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Chacataska caskanmanta tucuy runas yachanancupaj kelkaska carka: “Israelcunaj camachejnin”. ");
INSERT INTO quhNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Chaypitaj Jesuswan iscay runa wañuchi suwastawan chacatarkancu, ujninta pañanman ujnintataj llok'enman. ");
INSERT INTO quhNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ajinapi junt'acorka cay kelkaskaka: “Payka juchasapaswan yupaska carka”. ");
INSERT INTO quhNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Chaynejta purejcunapis umancuta qhiwirispa Jesuspa contranpi sajrata parlasharkancu: —¡Kan yupaychana-wasita urmachej quinsa p'unchaypitaj watejmanta wasichajka! ");
INSERT INTO quhNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Chacatanamanta uraycamuskayquiwan cacharichicuy, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Quiquillantataj yupaychana-wasimanta curajcunawan israel yachachejcunawan Jesusta asipayaspa ninacusharkancu: —Wajcunata cacharicherka, pay quiquinrí mana cacharichicuyta atinchu. ");
INSERT INTO quhNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Cristo israelcunaj camachejnin sutichacun. Cunanpacha chacatanamanta uraycamuchun, nokaycu chayta ricuspa creenaycupaj, —nispa. Paywan chacataska cajcunapis sajrata parlaspa c'amisharkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Chaupi p'unchayña cashajtintaj tucuy jallp'api lakhayaycorka chaupi tardecama. ");
INSERT INTO quhNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Chaupi tardetataj Jesuska sinch'ita khaparerka: —Eloi, Eloi ¿lama sabactani? Cay niyta munan: Diosníy, Diosníy, ¿imaraycutaj sakerpariwanquirí? ");
INSERT INTO quhNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Waquin chaypi cajcunamanta payta uyarispa nerkancu: —¡Uyariychej, Eliasta wajyashan! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ujnin runataj uskhayta rispa esponjata c'allcu ujyanaman chhaporka. Chay esponjata sokospi okharispataj Jesuspa siminman churarka ch'onkananpaj. Chayta ruwajri nerka: —¡A ver Elías jamonkachus chacatanamanta uraycuchej! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesustaj jatunmanta khaparispa tucucaporka. ");
INSERT INTO quhNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Yupaychana-wasipi warqhuska caj khatanataj iscayman lliq'icorka, patamanta uracama. ");
INSERT INTO quhNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jesuspa ñaupakenpi sayashaj romano capitanri Jesús imaynata wañupuskanta ricuspa, nerka: —Chekapuni cay runaka Diospa Wawan carka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Waquin warmistaj caritullamanta khawamusharkancu. Paycuna uqhupi casharkancu Magdala llajtayoj Mariawan Salomewan waj Mariapiwan. Chay waj Mariaka sullc'a caj Jacoboj Josejtawan mamancu carka. ");
INSERT INTO quhNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Chay warmiska Jesús Galileallapiraj cashajtin khatejcunan yanapajcunanpis carkancu. Waj ashqha warmispis cashallarkancutaj Jesuswan cusca Jerusalenman jamojcuna. ");
INSERT INTO quhNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Chay p'unchayka waquichicuna p'unchay carka k'ayantin samacuna p'unchay caskanraycu. Ch'isiyaycojtinña ");
INSERT INTO quhNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Arimatea llajtayoj José mana manchachicuspa camachej Pilatojman rerka. Chay Joseka curajcunaj tantacuynincumanta carka, c'achapaj khawaskataj. Paypis Dios tucuy runasta camachinanta mayta munaj. Payka camachej Pilatoj ñaupakenman Jesuspa cuerponta apacampunanpaj mañaj yaycorka. ");
INSERT INTO quhNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatoka Jesús wañuskaña caskanmanta t'ucorka. Chayraycu capitanta wajyaspa taporka chekachus wañuskaña caskanta. ");
INSERT INTO quhNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Wañuskaña caskanta yachaspataj Joseman nerka: —Atinqui apacapuyta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josetaj linomanta awaskata rantimorka. Jesusta chacatanamanta uraycuchispataj chay awaskawan mayt'uycorka. Chanta orkopi uj rumi jusc'uman p'amparka. Chay p'ampanaka kakapi jusc'uska jatun carka. Jatun muyu p'alta rumitataj p'ampana jusc'u puncuman muyuchispa churarka. ");
INSERT INTO quhNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Magdala llajtayoj Mariataj Joséj maman Mariapiwan ricorkancu maypichus Jesús churaska caskanta. ");
INSERT INTO quhNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Samacuna p'unchay tucucojtincama Magdala llajtayoj Mariawan Salomewan Jacoboj maman Mariapiwan sumaj k'apayniyoj jampita ranterkancu Jesusta jawimunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Domingo p'unchaytaj allin tutamanta chay warmiska rerkancu Jesús p'ampaska carka, chayman. Chayanancupaj inteka llojsimorkaña. ");
INSERT INTO quhNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Paycunataj tapunacusharkancu: —¿Pitaj p'ampana puncumanta chay rumita muyurparichipuwasunrí? ");
INSERT INTO quhNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Khawarispataj chay rumita muyurparichiskataña ricorkancu. Chay rumeka may jatun carka. ");
INSERT INTO quhNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","P'ampanaman yaycuspataj uj wayna runata pañanejpi tiyacushajta ricorkancu. Chay runaka yuraj lliphipej khoysu p'achawan p'achalliska carka. Warmistaj chayta ricuspa mayta mancharicorkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Payrí paycunaman nerka: —Amaña manchachicuychejchu. Nazaret llajtayoj Jesusta masc'ashanquichej, chacataska carka, chayta. Payka causarimpunña, manañataj caypichu. ¡Khawaychej! Caypi payta churarkancu. ");
INSERT INTO quhNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Astawanrí riychej Pedroman chay waj yachacojcunanmanwan willamuychej: Jesús kancunamanta Galileaman ñaupashanña. Chaypitaj payta ricunquichej, pay nisuskayquichejmanjina, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Warmisri p'ampanamanta llojsispa aykecorkancu. Manchachicuywan qharcatitisharkancu. Ni piman ni imata nerkancuchu manchachicuskancuraycu. ");
INSERT INTO quhNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Domingo p'unchayta causarimuspa tutamanta Jesuska ñaupajta Magdala llajtayoj Mariaman riqhurerka. Unayña Galileallapiraj cashaspa Jesuska paymanta kanchis supaycunata kharkorka. Chay carka, chay Mariaka. ");
INSERT INTO quhNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Payka Jesuspa yachacojcunanman willamoj rispa paycunata llaquiskas wakashajta tariparka. ");
INSERT INTO quhNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Jesusta causashajta ricuskanta willarka. Paycunarí causashaskanta uyarishaspapis manapuni creerkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Khepatataj paycunamanta iscayman Jesús riqhurerka wajjinamanta ñanta campoman rishajtincu. ");
INSERT INTO quhNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Chanta paycunaka Jerusalenman cutimuspa chay waj yachacojcunaman ricuskancuta willarkancu. Chay uyarejcunarí nillataj creerkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Aswan khepatataj miqhunancupaj tiyacushajtincu quiquin chunca ujniyojnintinman Jesús riqhurerka. Paycunatari mana creeskancumanta rumi sonko caskancumantawan c'amerka, payta causarimuskata ricojcunata mana creeskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jesuska paycunaman nerka: —Tucuy cay pachantinman riychej. Sumaj willanasta tucuy runasman willaramuychej. ");
INSERT INTO quhNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nokapi jap'icuspa bautizacojtaka Dios wiñaypaj cacharichenka. Nokapi mana jap'icojtarí wiñaypaj juchachanka. ");
INSERT INTO quhNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nokapi jap'icojcunaka cay ricuchinasta ruwankancu: Atiyniywan supaycunata kharkonkancu; waj runacunaj parlaynincuta mana yachaspapis parlankancu; ");
INSERT INTO quhNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","maquisnincuwan venenoyoj catarista okharenkancu; sichus wañuna jampita ujyancuman chaypis, paycunata mana imanankachu; onkoska runastapis maquisnincuta churaspa thañichenkancu, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ajinaka Señorninchej Jesús yachacojcunanman chay imasta nerka. Chaymantataj janaj pachaman okhariska carka Dioswan cusca camachinanpaj. ");
INSERT INTO quhNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Yachacojcunanri Jerusalenmanta llojsispa tucuynejpi runasman willaramorkancu. Señorninchejtaj paycunata yanapasharka. Payka chay ricuchinasta ruwaspa paycunanejta ricuchisharka niskan atiyniyoj caskanta. Ajina cachun.");
INSERT INTO quhNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","May c'acha Teofilóy: Cay sumaj willanaska nokanchej uqhupi Dios ruwaskanmantamin. Chay quiquin sumaj willanasta kallariymantapacha ricojcuna yachachejcunapiwan willawarkanchej. Chaymanjina ashqhasña kelkarkancu. Nokapis anchata munasharkani yachayta imaynachus tucuy cay caskantaka. Ajinapi sumajta masc'arkani kallariymantapacha yachanaypaj. Chayraycu ñaupajmanta cunancama ruwacuskasmanjina kelkarisuyta yuyarkani. ");
INSERT INTO quhNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Munashani tucuy cay imasmanta allinta yachanayquita yachacuskasniyquipis chekapuni caskanta. Chayraycu cay sumaj willanasta kelkamushayqui. ");
INSERT INTO quhNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Judea jallp'ata Herodes camachishajtin carka yupaychana-wasipi uj ruwanayoj, Zacarías sutiyoj. Paypa llanc'ana tropan Abíaspa carka. Warmin Elisabetpis Aaronpa ayllunmanta carka. ");
INSERT INTO quhNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Paycuna khari warmi Diosta cusichejpuni cancu. Diospa tucuy camachiskasninta sumajta casoj cancu mana faltaspa. ");
INSERT INTO quhNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elisabet mana wijsallicuyta atiskanraycu, mana wawayoj carkancu. Chaypachataj iscaynincu ashqha watasniyojña carkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Zacariaspa tropan yupaychachinan p'unchaycuna chayamojtin pay llanc'asharka yupaychana-wasipi Diospa ñaupakenpi. ");
INSERT INTO quhNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ruwanayojcuna yachacuskancumanjina ruwarkancu sorteopi ujta ajllaspa inciensota k'oshñichinanpaj. Chaypaj Zacaríasta ajllajtincoka yupaychana-wasi uqhuman yaycorka. ");
INSERT INTO quhNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Inciensota k'oshñichishajtin tucuy tantaska runas yupaychana-wasi jawapi Diosmanta mañacusharkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Chay quiquinpacha Diosmanta uj willaj angel Zacariasman riqhurerka. Sayarkataj maypichus inciensota k'oshñichincu chay altarpa pañannejpi. ");
INSERT INTO quhNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacarías angelta ricuspa mancharicuywan qharcatiterka. ");
INSERT INTO quhNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Angeltaj payta nerka: —Zacarías, amaña manchachicuychu, Dioska kanpa mañacuskayquita uyarinña. Elisabet, warmiyquitaj, uj khari wawata onkoconka. Paytaka Juanta sutichanqui. ");
INSERT INTO quhNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nacecuskanka anchata cusichisonka. Ashqha runaspis paypa nacecuskanmanta cusiconkancu, ");
INSERT INTO quhNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","payta Dios sumajpaj khawaskanraycu. Mana ni jayc'aj ni vinota ni ima machanatapis ujyankachu. Nacecuskanmantapacha Santo Espirituwan junt'a canka. ");
INSERT INTO quhNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Dios paywan cusca caskanraycu ashqha israel runasta Señor Diosnincuman cutirichenka. ");
INSERT INTO quhNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Unay tiempopipis Diospa willajnin, Elías sutiyoj, atiywan Diospaj llanc'arka. Ajinallatataj cay wawaka runayaspa Diospaj llanc'anka. Tatasta wawasnincuwan allinyachenka. Payka Diosta mana casoj runasta chekanta yuyanancuta yachachenka casucoj wawasjina causanancupaj. Chayta ruwaspa Diospa runasninpa sonkosnincuta waquichenka pay jamunanpaj, —nerka angelka. ");
INSERT INTO quhNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacarías angelta nerka: —¿Imaynapitaj caytaka yachasajrí? Nokaka machuña cani, warmiypis ashqha watasniyojña, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Angeltaj payman cuticherka: —Noka angel Gabriel cani, Diospa ñaupakenpi sayaj. Paymin parlasojta cachamuwarka cay sumaj willanasta willasunaypaj. ");
INSERT INTO quhNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kanrí willasuskayta mana jap'icuskayquiraycu upayanqui. Kan manaña atinquichu parlariyta willasuskay junt'acunancama. Willasuskayka junt'acunan p'unchaypi junt'aconka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Zacarías yupaychana-wasi uqhupi cashanancama runas jawapi payta suyasharkancu. T'ucusharkancutaj uqhupi unayta khepacuskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Llojsispari paycunaman parlayta mana aterkachu. Chaymanta runas yacharkancu yupaychana-wasipi payman moskoypijina Diosmanta uj ima riqhuriskanta. Payrí upapacha maquisnillanwan paycunaman parlasharka. ");
INSERT INTO quhNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Yupaychana-wasipi ruwanasninta tucuspa wasinman cutiporka. ");
INSERT INTO quhNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Chaymantapacha warmin Elisabet wijsallicorka. Phishka quillastataj payka pacacuspa wasillanpi cacorka. Nisharkataj: ");
INSERT INTO quhNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ajinamanta Señor Diosniy qhuyawaspa khechupuwarka p'enkayniyta mana wawa wijsallicuyta atiskaymanta. Cunanka manaña runas khesachawankancuchu”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Zacariasman riqhuriskanmanta sojta quillanman Dioska angel Gabrielta Galilea caj Nazaret llajtaman cachamullarkataj. ");
INSERT INTO quhNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Chay angelta cachamorka María sutiyoj sipasman. Pay parlapayaskaña carka Josewan casaracunanpaj. Josetaj camachej Davidpa ayllunmanta carka. ");
INSERT INTO quhNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","María casharka, chayman jamuspa angelka payta napaycorka: —¡Dios allin p'unchayta kosunqui! Payka kanwan cashan. Kanmantapis mayta cusicun, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mariaka cayta uyarispa manchariywan uqhunpi “¡ras!” nichicorka. Mayta t'ucuspataj yuyasharka sonkonpi: “Cayjina napaycuwaskanka ¿imatataj niyta munanrí?” ");
INSERT INTO quhNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Angel payta nerka: —Amaña manchachicuychu, Dios kanta munacuywan ajllacususkanraycu. ");
INSERT INTO quhNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","¡Khaway! Wijsallicuspa uj khari Wawata onkocunqui. Paytataj Jesusta sutichanqui. ");
INSERT INTO quhNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Payka sumaj c'acha, curaj runataj canka, c'ata Diospa Wawan caskanraycu. Tucuy atiyniyoj Dioska payta unay tatan Davidtajina camachinanpaj churanka. ");
INSERT INTO quhNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Wiñaypajtaj Israel llajtata camachenka. Camachiynintaj ni jayc'ajpis tucuconkachu, —nerka angel. ");
INSERT INTO quhNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariataj angelta nerka: —Mana kharitaka rejsinichu. Chayraycu ¿imaynataj cayka cankarí? ");
INSERT INTO quhNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Angeltaj payman cuticherka: —Santo Espíritu kanman uraycamusonka. C'ata Diospa atiynintaj kanta c'anchaycamusonka. Chayraycu wawayqueka mana juchayoj, c'acha rejsiska canka, Diospa cheka Wawan. ");
INSERT INTO quhNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","¡Khaway! Aylluyqui Elisabetpis uj khari wawata wijsallicorkaña ashqha watasniyojña cashaspapis. Cunantaj sojta quillaña wijsallicuskan cashan chay mana wawa rejsej niska warmeka. ");
INSERT INTO quhNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Chekatapuni Diospa tucuy niskasnenka junt'aconka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Chanta María nerka: —Diospa camachin cani. Nokaman niwaskayquimanjina ruwaska cachun, —nispa. Angeltaj paymanta riporka. ");
INSERT INTO quhNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ajinata María uskhayta waquichicuspa chekanta riporka orko orko Judea jallp'api uj llajtaman. ");
INSERT INTO quhNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Chay llajtaman chayaspataj Zacariaspa wasinman yaycorka. Elisabettataj napaycorka. ");
INSERT INTO quhNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Maríaj napaycuskanta Elisabet uyarejtin wijsanpi wawanka phinquirerka. Elisabetri Santo Espirituwan junt'aska carka. ");
INSERT INTO quhNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Cusiywan khaparispataj Mariata nerka: —Tucuy warmismanta kan astawan curajpaj khawaska canqui Dios kanta ajllacususkanraycu. Wawayquipis may curajpaj khawaska canka. ");
INSERT INTO quhNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Maytapuni cusicuni Señorniypa maman watucuwaskanmanta. Nokaka ni watucunawanpajjinapischu cani. ");
INSERT INTO quhNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","¡Khaway! Napaycuwaskayquita uyarisojtiy wijsaypi wawa cusiymanta phinquirerka. ");
INSERT INTO quhNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","May cusiska kanka Señor Dios willasuskanta jap'icuskayquiraycu. Chekamanta nisuskanka junt'aconka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mariataj nerka: —Mayta jatunchani Diosta tucuy sonkoywan. ");
INSERT INTO quhNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Mayta cusicushani juchamanta Cacharichiwajniy Diospi. ");
INSERT INTO quhNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Payka camachillan cashajtiypis wajcha caskayta qhuyacuyninwan khawawaspa, nokata ajllacuwarka. Chekamanta cunanmantapacha tucuy runas may cusiska caskayta niwankancu. ");
INSERT INTO quhNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tucuy atiyniyoj cheka Diosmin may jatun imasta nokapaj ruwarka. Payka may c'acha, manapuni juchayojmin. ");
INSERT INTO quhNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Unay tatasninchejmantapacha cunancama, Dioska wiñaypaj qhuyacunpuni payta yupaychajcunataka. ");
INSERT INTO quhNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Dios atiyninwan jatuchej ruwanasta ruwarka. Payka tucuy jatunchacojcunata atipaspa aykeracherka. ");
INSERT INTO quhNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Sajra camachejcunata sumaj tiyanasnincumanta uraycucherka, pisipaj khawaskacunatataj okharerka. ");
INSERT INTO quhNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Yarkhaska runasta allin imaswan sajsacherka. Khapaj runastarí mana imayojta ch'usajllata cachaporka. ");
INSERT INTO quhNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Dios ñaupa tatasninchejman niskasninta junt'aspa camachin Israelta yanapaj jamunña. Ajinamanta yuyaricorka qhuyacuyta Abrahamman tucuy paypa mirayninmanpis wiñaypaj, —nerka María. ");
INSERT INTO quhNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Payka quinsa quillata Elisabetwan cacuspa wasinman cutiporka. ");
INSERT INTO quhNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabetpa onkocunan quilla junt'acorka. Khari wawatataj onkocorka. ");
INSERT INTO quhNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Llajta-masisnin ayllusninpiwan uyarerkancu Dios payta cayjinata sumajta qhuyaskanta. Chayraycu paywan cusicorkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Wawaj nacecuskanmanta pusaj p'unchayninpi chay runas payta circuncidaj jamorkancu. Chay señalta cuerponpi churarkancu runas yachanancupaj israelcuna Diospa runasnin caskancuta. Tatan Zacariaspa sutinwantaj sutichayta munasharkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mamanrí nerka: —Ama. Juanmin sutenka canan tiyan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Paycunataj payman cuticherkancu: —Ni pipis chay sutiyojka aylluyquipeka canchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Maquisnincuwantaj tatanta tapurerkancu: “¿Ima sutiwantaj sutichayta munanqui?” ");
INSERT INTO quhNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Kelkanata mañacuspa Zacarías kelkarka: “Juanmin sutenka”. Tucuy paycunataj t'ucorkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Chay quiquinpachataj Zacarías ujtawan parlarispa Diosta yupaycharka. ");
INSERT INTO quhNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tucuy llajta-masisnincutaj t'ucorkancu. Judea orkosnintinpi chay ruwacuskanmanta tucuy runas parlanacusharkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Sonkoncupi yuyaspataj uyariskancumanta ninacusharkancu: —Cay wawaka ¿imayna runapunitaj wiñaspa cankarí? —nispa. Imaraycuchus repararkancu Dios paywan cashaskanta yanapananpaj. ");
INSERT INTO quhNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tatan Zacarías Santo Espirituwan junt'a carka. Sut'incharkataj Diospa munayninmanta ruwaskasninmantapis cayjinata: ");
INSERT INTO quhNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Yupaychaska cachun Israelpa Señor Diosnin. Imaraycuchus runasninta qhuyacuspa jamun juchasnincumanta cacharichinanpaj. ");
INSERT INTO quhNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Atiyniyoj Cacharichiwajninchejta kowarkanchej camachin Davidpa ayllunmanta. ");
INSERT INTO quhNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Caytaka ajinatapuni Dios unayña payman t'akaska willajcunanejta nerka: ");
INSERT INTO quhNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","“Enemigosniyquichejmanta cacharichiskayquichej tucuy chejnisojcunayquichejpa atiynincumanta”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ajinapi Dios unay tatasninchejta qhuyarka, paypa sumaj tratonta paycunaman junt'arkataj. ");
INSERT INTO quhNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Dios unay tatanchej Abrahamman juraspa chekatapuni nerka: ");
INSERT INTO quhNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","“Enemigosniyquichejmanta cacharichiskayquichej paycunata mana manchachicuspa nokata yupaychanawayquichejpaj. ");
INSERT INTO quhNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ajinata cusichiwaspa chekanta ruwanquichej ñaupakeypi tucuy causayniyquichejpi”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Kanrí, wawáy, c'ata Diospa willajnin niska canqui. Diospa ajllaskan jamunanpaj ñaupakenta rinqui runaspa sonkosnincuta waquichipuspa. ");
INSERT INTO quhNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Diospa runasninta yachachinqui juchasnincuta khechuspa Dios paycunata cacharichinanta. ");
INSERT INTO quhNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Diosninchej munacuyniyoj qhuyacuyniyojtaj. Pay jamonka yanapanawanchejpaj. Imaynata inti pakarimun, ajinallatataj Cacharichiwajninchejka janaj pachamanta jamonka juchamanta cacharichinawanchejpaj. ");
INSERT INTO quhNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Janaj pachamanta lliphipimonka lakhapi tiyacojcunaman wañunayashajcunamanpis. Nokanchejta Diosman allinyachispa pusawasunchej allinta causacunanchejpaj, —nerka Zacarías. ");
INSERT INTO quhNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Wawa Juantaj wiñasharka. Sumaj yuyaywantaj Diosta casunanpaj callpachacusharka. Payka ch'in lomaspi tiyacorkataj Dios israel runasman willaramojta cachanancama. ");
INSERT INTO quhNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Jakay p'unchaycunapi uj curaj camachej Romano jallp'api carka, Augusto sutiyoj. Pay camacherka tucuy runas yupaska canancuta. ");
INSERT INTO quhNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Cay ñaupaj yupayka carka camachej Cirenio Siria jallp'ata camachishajtin. ");
INSERT INTO quhNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Tucuy runas sapa uj nacecuskan llajtaman yupachicoj rinancu carka. ");
INSERT INTO quhNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Chayraycu Joseka Galilea jallp'a Nazaret llajtamanta llojserka. Judea jallp'a Belén llajtaman rerka Davidpa ayllunmanta caskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yupachicamunancupaj Mariata pusarka. Payka Josej warmin cananpaj mañaskaña carka. Manaraj cusca tiyacushajtincutaj wijsayojña casharka. ");
INSERT INTO quhNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Belenpi cashajtincu Maríaj onkocunan quilla junt'acorka. ");
INSERT INTO quhNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Chaypitaj curaj khari wawanta onkocorka. Wawanta janantaswan mayt'orka. Uywa karanapi payta siriycucherka paycunapaj puñuna wasipi campo mana caskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Chaypachallataj michejcuna Belén kaylla lomaspi casharkancu. Tutapi paycuna ovejasnincuta khawasharkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mana yuyaskamantataj Diosmanta uj angel paycunaman riqhurerka. Diosmanta c'anchaytaj michejcunaj muyuynintinpi lliphiperka. Michejcunataj mayta mancharicorkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Angelrí michejcunaman nerka: —Amaña manchachicuychejchu. ¡Khawaychej! Sumaj willanasta willayquichej tucuy runas cusicunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Cunan Davidpa llajtan Belenpi juchamanta Cacharichej nacepusunquichej. Payka Diospa tucuy atiyniyoj ajllaskan Cristomin. ");
INSERT INTO quhNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Wawata janantaswan mayt'uskata tarinquichej, uywa karanapi siriskata. Ajinamanta yachanquichej niskay cheka caskanta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ujllata chay angelwan ashqha angeles janaj pachamanta chay ujninwan riqhurimorkancu. Diostataj yupaycharkancu: ");
INSERT INTO quhNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—¡Janaj pachapi Dios yupaychaska cachun! Cay pachapitaj Dios runasta payman allinyachicun. Paycunamanta pay cusicun, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Angeles janaj pachaman cutirejtincutaj michejcuna ninacorkancu: —Jacu ari, Belencama ricoj yachamojtaj Dios sut'inchawaskanchejta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Uskhayllata rispataj Mariata Josetawan khari Wawatawan uywa karanapi siriskata tarerkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Michejcuna chayta ricuspa tatanman mamanmanpis willarkancu angel cay Wawamanta niskanta. ");
INSERT INTO quhNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Tucuy uyarejcunataj michejcuna willaskancumanta t'ucorkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mariarí tucuy chay uj sumaj cajtajina sonkonpi wakaychacorka sumajtataj unanchacorka. ");
INSERT INTO quhNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Michejcuna Diosta yupaychaspa jatunchaspataj lomasman cutiporkancu. Uyariskancumanta ricuskancumantapis Diosta jatuncharkancu. Tucuytaj carka angelpa willaskanmanjina. ");
INSERT INTO quhNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Dios israelcunata camacherka khari wawata nacecuskanmanta pusaj p'unchayninpi circuncidanancuta señalta cuerponpi churaspa. Chay p'unchaypitaj Wawata suticharkancu Jesusta. Angel chay sutita willarkaña manaraj María wijsayoj cashajtin. ");
INSERT INTO quhNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moisespa camachiskanmanjina llimphuchacuna p'unchay junt'acorka. Chay p'unchay José Mariawan Wawata Jerusalén llajtaman aparkancu, Diosman jaywanancupaj. ");
INSERT INTO quhNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ajinata payta aparkancu Diospa camachiskasninpi kelkaskamanjina: “Tucuy curaj khari wawata Diosman t'akaychej”. ");
INSERT INTO quhNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Dios camachiskanmanjina warmi llimphuchacunanpaj jaywajtaj rerkancu. Iscay jurc'utas chayrí iscay paloma irpas jaywana caj. ");
INSERT INTO quhNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Chaypacha Jerusalenpi uj khari carka, Simeón sutiyoj. Pay chekan sonkoyoj runa carka Diosta yupaychajtaj. Cacharichej Cristota israel runasman jamunanta suyasharka. Santo Espíritu Simeonpa sonkonpi casharka. ");
INSERT INTO quhNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Chay Santo Espíritu payman sut'incharkaña: “Señor Diospa ajllaskan Cristota ricunqui manaraj wañushaspa”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ajinamanta Santo Espíritu payta pusamorka yupaychana-wasiman. Quiquinpachataj Jesuspa tatasnin chayman Wawata apamullarkancutaj Moisespa camachiskanmanjina ruwanancupaj. ");
INSERT INTO quhNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeontaj Wawata mark'aricorka Diostataj yupaycharka: ");
INSERT INTO quhNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","—Señor Diosníy, cunanka camachiyquita pusacapuway niskayquimanjina. Tucuy sonko cusiska wañupusaj. ");
INSERT INTO quhNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kanpa ajllaskanta ricuniña. ");
INSERT INTO quhNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Payta waquicherkanqui tucuy runas ricunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Payta cachamorkanqui tucuy waj llajtayojcunaman munayniyquita ricuchinanpaj. Cachamullarkanquitaj payta israel runasniyqui jatunchaska canancupaj kan paycunawan cashaskayquiraycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jesusmanta ajinata niskanraycutaj tatan mamanwan t'ucorkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeontaj Diosmanta mañariporka paycunapaj. Chanta Jesuspa maman Mariaman nerka: —Uyariway, Dios cay Wawata churarka. Ajinapi israelcunamanta ashqhas Diosmanta caruchaconkancu, ashqhastaj payman kayllayconkancu. Jesús uj ricuchina canka. Ashqha runas cay ricuchinata khesachaspa churanaconkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ajinamanta sut'inchaconka sapa uj runa sonkonpi yuyaskanta. Kantapis, María, phutiy uj filoyoj jatun cuchillojina quiquin sonkoyquita t'ujsenka, —nerka Simeón. ");
INSERT INTO quhNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Chaypi uj warmi Diosmanta willaj cashallarkataj, Ana sutiyoj. Pay Fanuelpa ususin, Aserpa ayllunmanta carka, ashqha watayojña. Sipas cashaspa casaracorka, kosanwantaj kanchis watallata tiyacorka. ");
INSERT INTO quhNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Viudataj carka pusaj chunca tawayoj watataña. Yupaychana-wasita mana sakejchu. Astawanpis tuta p'unchay Diosta yupaychaj mana miqhuspa paymanta mañacoj caj. ");
INSERT INTO quhNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeón parlashajtinraj Ana riqhurimorka. Paypis Diosmantaj graciasta korka. Israelcuna cachariskas canancuta tucuy suyajcunaman Jesusmanta willasharka. ");
INSERT INTO quhNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Jesuspa tatansnin Diospa camachiskasninmanjina ruwanancuta tucuyta ruwarkancu. Galilea jallp'aman Nazaretman cutiporkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Jesuska wiñasharka callpachacusharkataj, Diosmanta yachaywan junt'ataj carka imaraycuchus Dios payta yanapasharkapuni. ");
INSERT INTO quhNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Sapa wata tatasnin rej cancu Jerusalenman pascua p'unchaycunapaj. ");
INSERT INTO quhNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ajinapi Jesús chunca iscayniyoj watayojña cashajtin, tucuynincu pascua p'unchaycunapaj rerkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Chay p'unchaycuna tucucojtintaj, Jesuspa tatasnin cutipusharkancu. Jesusrí Jerusalenpi kheparicaporka. Paycunataj chayta mana yacharkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Astawanpis rejcunawan cashaskanta yuyaspa uj p'unchay puriyta rerkancu. Ajinata ayllusnincu rejsiskasnincu chaupipi payta masc'asharkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mana tarispataj cutirerkancu Jerusalenman payta sinch'ita masc'aspa. ");
INSERT INTO quhNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Quinsa p'unchaymantaraj payta tarerkancu yupaychana-wasipi. Israel yachachejcunaj chaupincupi Jesús tiyacusharka. Jesús paycunata uyarisharka tapurisharkataj. ");
INSERT INTO quhNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Jesusta tucuy uyarejcunari mayta t'ucorkancu yachayninmanta cutichiskasninmantapis. ");
INSERT INTO quhNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tatasnin Jesusta ricuspa mayta t'ucorkancu. Mamantaj Jesusta nerka: —Wawáy ¿imaraycu cayta ruwawaycu? Noka tatayquiwan ancha phutiywan kanta masc'ashaycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesustaj cutichispa nerka: —Mamáy ¿imaraycutaj masc'ashawarkanquichej? Tatay Diospa wasinpeka canay tiyan ¿manachu chayta yachanquichej? ");
INSERT INTO quhNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tatasninrí chay niskanta mana entienderkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Chanta Jesús paycunawan cutiporka Nazaretman paycunatataj casojpuni. Mamantaj cay imasta sonkonpi uj may munaska imatajina wakaychacusharka. ");
INSERT INTO quhNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús wiñashallarkapuni yachayninpis yapacushallarkapuni. Diospis runaspis paymanta cusicusharkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Curaj camachej Tiberio chunca phishkayoj watasña camachiskanmanta Dios churarka Juanta palabranta willarananpaj. Chaypachataj Poncio Pilato camachisharka Judea jallp'api tiyacojcunata. Herodestaj Galilea jallp'api tiyacojcunata camachisharka. Wauken Felipetaj Iturea jallp'api, Traconite jallp'api tiyacojcunatawan camachisharka. Lisanias sutiyoj camachishallarkataj Abilinia jallp'api tiyacojcunata. Chaypacha Anás Caifaspiwan yupaychana-wasimanta curajcuna casharkancu. Chaypachataj Juan, Zacariaspa wawanka, Diospa camachiskanta ch'in lomapi uyarerka. ");
INSERT INTO quhNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ajinamanta payka tucuy Jordán mayu kayllantinman rerka Diosmanta willaraspa. Nisharkataj runasta: —Juchasniyquichejta sakespa Diosman cutiricuychej. Chaywanpis bautizacuychej, causayniyquichejta Diosman jaywaspa. Ajinapi Dios juchasniyquichejta khechupusonkachej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ajinata Diospa willajnin Isaías libronpi kelkarka: Ch'in lomapi uj runa khaparishan: “Uj jatun camachej jamojtin runas ñanninta waquichipuncu. Purinasnintapis chekanta ruwancu. ");
INSERT INTO quhNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tucuy t'okosta junt'achincu. Tucuy orkosta mokostapis pampachancu. Wist'u ñancunata chekanchancu. T'oko puru ñancunatapis cuscachancu. Ajinallatataj sonkoyquichejta waquichicuychej Diospa Wawan jamunanpaj. ");
INSERT INTO quhNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Sapa uj runataj riconka Diospa cachamuskanta runasta juchancumanta cacharinanpaj”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ajinapi Juanka ashqha runas bautizacoj jamojcunaman nej: —¡Kancuna runa wañuchi catarisjina canquichej! ¿Pitaj yuyaychasorkachej Diospa jamoj c'ajaj phiñacuyninmanta aykecunayquichejta? Sichus aykecuyta munanquichej chayka, ");
INSERT INTO quhNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","juchasniyquichejta sakespa, Diosman cutiriskayquichejta allin ruwaskasniyquichejwan ricuchiychej. Amataj kallariychejchu jatunchacuyta sonkosniyquichejpi: “Abrahamka unay tatanchejmin. Chayraycu Dios qhuyashawaycu”, nispa. Dioska atiyniyojmin ruwananpaj cay rumismantapis Abrahampa mirayninta. ");
INSERT INTO quhNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Hachaka waquichiskaña cashan sach'a saphinmanta c'utunanpaj. Sapa sach'a mana allin pokojtaka runas c'utuspa ninaman wijch'uncu, —nerka Juan. ");
INSERT INTO quhNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Runas payta tapusharkancu: —Niwaycu ¿imatataj ruwasajcu? ");
INSERT INTO quhNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juanri paycunaman cutichisharka: —Kancunamanta iscay p'achasniyoj cajka ujninta mana p'achayojman kochun. Ajinallatataj miqhunayoj cajpis mana miqhunayojman kochun, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Waquin impuesto jap'ejcunapis bautizacoj jamorkancu ricuchinancupaj juchasnincuta sakespa Diosman cutiriskancuta. Payta taporkancutaj: —Yachachej ¿imatataj ruwasajcu? ");
INSERT INTO quhNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juan paycunaman cuticherka: —Runasmanta kolketa jap'inayquichej, chayllata jap'iychej amataj astawanka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Soldados tapullarkancutaj: —Nokaycupis ¿imatataj ruwasajcu? Paycunata cuticherkataj: —Ama makaspalla nitaj tumpaspallaka kolketa pimantapis khechuychejchu. Pagollayquichejwan cacuychej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Israel runaska juchamanta Cacharichej Cristo jamunanta suyasharkancupuni. Sonkosnincupitaj Juanmanta tucuy tanteyacusharkancu: “¿Cay runaka Cacharichejchu canman?” ");
INSERT INTO quhNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Juantaj tucuy runasman nerka: —Chekatapuni nokaka yacupi bautizayquichej Diosman cutiriskayquichejta ricuchinapaj. Nokamanta uj aswan atiyniyoj jamushan. Mana camachinpajjinapischu cani runalla caskayraycu. Payka Santo Espirituwan ninawantaj kancunata bautizaspa Espirituta sonkoyquichejman cachamusonkachej. ");
INSERT INTO quhNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Paypa jorc'an maquinpi cashan wayrachinanpaj. Erantataj sumajta pichaspa trigonta pirwanman jallch'anka. Pajatarí ni jayc'aj wañoj ninawan ruphaycuchenka. ");
INSERT INTO quhNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Chay niskaswan ashqha waj niskaspiwan Juan runasman yuyaychaspa willarasharka. ");
INSERT INTO quhNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Chaywanpis Juanka camachej Herodesta waukenpa warmin Herodiaswan tiyacushaskanmanta c'amerka. Tucuy sajra ruwaskasninmantapis ricucherka. ");
INSERT INTO quhNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herodesrí payta mana casorkachu. Astawan sajrataraj ruwarka, Juanta carcelman wisk'aycuchispa. ");
INSERT INTO quhNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Juan tucuy runasta bautizashajtin Jesuspis bautizacorka. Pay Diosmanta mañacushajtin, Dios janaj pachata quicharimorka. ");
INSERT INTO quhNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Santo Espiritutaj paloma rijch'aypi ricucoj Jesusman uraycamorka. Janaj pachamanta Diostaj nimorka: —Kanmin c'ata munaska Wawayka canqui. Kanwan may cusiska cani, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesuska quinsa chunca watasniyojjina cashaspa wasinmanta llojsispa Diosllapaj ruwanasninta kallarerka. Runastaj yuyarkancu pay Joséj wawan caskanta. Josetaj Elíj wawan carka. ");
INSERT INTO quhNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Paytaj Matatpa wawan carka. Paytaj Levíj wawan carka. Paytaj Melquij wawan carka. Paytaj Janaj wawan carka. Paytaj Joséj wawan carka. ");
INSERT INTO quhNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Paytaj Matatiaspa wawan carka. Paytaj Amospa wawan carka. Paytaj Nahumpa wawan carka. Paytaj Eslij wawan carka. Paytaj Nagaipa wawan carka. ");
INSERT INTO quhNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Paytaj Maatpa wawan carka. Paytaj Matatiaspa wawan carka. Paytaj Semeipa wawan carka. Paytaj Joséj wawan carka. Paytaj Judáj wawan carka. ");
INSERT INTO quhNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Paytaj Joanaj wawan carka. Paytaj Resaj wawan carka. Paytaj Zorobabelpa wawan carka. Paytaj Salatielpa wawan carka. Paytaj Nerij wawan carka. ");
INSERT INTO quhNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Paytaj Melquij wawan carka. Paytaj Adij wawan carka. Paytaj Cosampa wawan carka. Paytaj Elmodampa wawan carka. Paytaj Erpa wawan carka. ");
INSERT INTO quhNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Paytaj Josuepa wawan carka. Paytaj Eliezerpa wawan carka. Paytaj Jorimpa wawan carka. Paytaj Matatpa wawan carka. ");
INSERT INTO quhNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Paytaj Levíj wawan carka. Paytaj Simeonpa wawan carka. Paytaj Judáj wawan carka. Paytaj Joséj wawan carka. Paytaj Jonanpa wawan carka. Paytaj Eliaquimpa wawan carka. ");
INSERT INTO quhNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Paytaj Meleaj wawan carka. Paytaj Mainanpa wawan carka. Paytaj Matataj wawan carka. Paytaj Natanpa wawan carka. ");
INSERT INTO quhNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Paytaj Davidpa wawan carka. Paytaj Isaipa wawan carka. Paytaj Obedpa wawan carka. Paytaj Boozpa wawan carka. Paytaj Salmonpa wawan carka. Paytaj Naasonpa wawan carka. ");
INSERT INTO quhNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Paytaj Aminadabpa wawan carka. Paytaj Arampa wawan carka. Paytaj Esrompa wawan carka. Paytaj Farespa wawan carka. Paytaj Judáj wawan carka. ");
INSERT INTO quhNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Paytaj Jacobpa wawan carka. Paytaj Isaacpa wawan carka. Paytaj Abrahampa wawan carka. Paytaj Taréj wawan carka. Paytaj Nacorpa wawan carka. ");
INSERT INTO quhNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Paytaj Serugpa wawan carka. Paytaj Ragaupa wawan carka. Paytaj Pelegpa wawan carka. Paytaj Heberpa wawan carka. Paytaj Salaj wawan carka. ");
INSERT INTO quhNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Paytaj Cainanpa wawan carka. Paytaj Arfaxadpa wawan carka. Paytaj Sempa wawan carka. Paytaj Noéj wawan carka. Paytaj Lamecpa wawan carka. ");
INSERT INTO quhNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Paytaj Matusalenpa wawan carka. Paytaj Enocpa wawan carka. Paytaj Jaredpa wawan carka. Paytaj Mahalaleelpa wawan carka. Paytaj Cainanpa wawan carka. ");
INSERT INTO quhNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Paytaj Enospa wawan carka. Paytaj Setpa wawan carka. Paytaj Adanpa wawan carka. Paytaj Diosmanta carka. ");
INSERT INTO quhNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús Jordán mayumanta ripuspa Santo Espirituwan junt'a carka. Santo Espiritutaj ch'in pampapi pusaycachaspa paywan casharka. ");
INSERT INTO quhNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Chaypachataj tawa chunca p'unchaycunantinpi supay Satanás Jesusta juchallichiyta munasharka. Jesustaj chay p'unchaycunapi mana ni imatapis miqhorkachu. Chay khepata pay yarkhachicorka. ");
INSERT INTO quhNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ajinata supay Satanás Jesusman nerka: —Sichus Diospa Wawan canqui chayka, camachiy cay rumita t'antaman cutinanta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesustaj payman cuticherka: —Diospa palabranpi nin: “Runaka mana miqhunallawanchu causanan. Manachayrí Diospa tucuy palabranwan causanan”, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Chanta supay Satanás Jesusta pusarka orko pataman. Uj ratullapi cay pachapi caj tucuy camachiska llajtastataj payman ricucherka. ");
INSERT INTO quhNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Nerkataj: —Kanman koskayqui atiyta camachinayquipaj tucuy cay llajtasta khapaj capuynincutawan. Nokaman jaywaska carka. Chayraycu jaywani pimanchus munani. ");
INSERT INTO quhNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Sichus kan konkoricuspa yupaychawanquiman chayka, tucuy kanpata canka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesustaj payman cuticherka: —Dios palabranpi nin: “Señor Diosnillayquita yupaychanqui. Pay sapallanman konkoricuspa casunqui”, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Chanta supay Satanás Jesusta Jerusalenman pusarka. Yupaychana-wasej patanpi sayaricherka. Jesusta nerkataj: —Sichus Diospa Wawan canqui chayka, cay patamanta chay uraman phinquiycuy pampaman. ");
INSERT INTO quhNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Diospa palabranpi nin: Dios camachenka angelesninta kanta wakaychasunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Nintaj: Angelesninta camachenka kanta wakaychasunancupaj. Maquisnincuwantaj kanta jap'isonkancu rumisman ama urmanayquipaj. ");
INSERT INTO quhNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús payman cuticherka: —Dioska nin: “Ama Señor Diosniyquej atiyninta manacajpaj mañacuychu”, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Supay Satanás tucuy imaymana pantachinaswan munasharka juchallichiyta Jesusta. Mana atispari payta sakerpaspa chincaporka uj p'unchaycama. ");
INSERT INTO quhNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Chanta Galilea jallp'aman Jesús cutipuspa Santo Espíritoj atiyninwan junt'a carka. Runastaj tucuy chay jallp'anejpi Jesusmanta uyarerkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Tantacuna-wasisnincupi paycunata yachachisharka. Tucuy runastaj payta curajpaj khawarkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Chanta Jesús Nazaret llajtaman rerka. Chaypi uywaska carka. Rejpuni payka, samacuna p'unchay tantacuna-wasiman yaycorka. Runaspa ñaupakencupitaj leenanpaj sayaricorka. ");
INSERT INTO quhNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Diospa unay willajnin Isaiaspa libron Jesusman jaywaska carka. Librota quicharispataj tariparka maypichus kelkaska cashan: ");
INSERT INTO quhNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Santo Espíritu nokawan cashan wajchacunaman sumaj willanasta apamunaypaj Dios ajllacuwaskanraycu. Dios cachamuwarka juchapi wisk'aska runasman cachariskas canancuta willaranaypaj. Cachamuwarkataj cheka cajta mana ricojcunata cheka cajta ricuchinaypaj, phutiywan ñit'iskacunata cacharichinaypajpis. ");
INSERT INTO quhNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Cachamullawarkataj willaranaypaj cunanpacha Dios runasta payman chimpanancupaj wajyaskanta. ");
INSERT INTO quhNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","21","Jesús librota wisk'aspataj libro wakaychajman jaywaporka. Tucuy tantacuna-wasipi cajcuna payta sumajta khawasharkancu. Jesustaj tiyaycucuspa kallarerka yachachiyta. Nerkataj: —Diospa palabranmanta cay leeskayka cunan p'unchay junt'acushan nokata uyariwaskayquichejpi, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","T'ucuspataj tucuy runas nisharkancu: —Chekatapuni paypa yachachiskasnin allin cashan, may c'acha, —nispa. Tapunacusharkancutaj: —¿Manachu pay Joséj wawan? ");
INSERT INTO quhNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesustaj nerka: —Chekatapuni khepapi nokata cay niyta niwanquichej: “Onkoskasta thañichej cashaspaka kan quiquiyquita thañichicuy. Capernaum llajtapi jatun ruwaskasniyquimanta uyarerkaycu. Cunan cay llajtayquipipis quiquinta ruway”, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","‘Nokarí niyquichej chekamanta: Willajnincuta quiquin llajta-masisnin mana nincuchu: “Walejta jamunqui”, nispaka. ");
INSERT INTO quhNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Uyariwaychej: Sumajta yachashanquichej Diosmanta unay willaj Elías causashajtin jatun yarkhay caskanta. Chay yarkhay carka tucuy jallp'aspi, quinsa wata sojta quillayojta mana paraskanraycu. Chaypacha Israel jallp'api ashqha viudas carkancu. Eliasrí ni maykennincumanpis cachaskachu carka. Manachayrí Sidón jallp'a Sarepta llajtayoj uj viudallaman cachaska carka. ");
INSERT INTO quhNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Diosmanta unay willaj Eliseo causashajtinpis ashqha lepra onkoyniyoj runas Israel jallp'api callarkancutaj. Paycunamantarí ni uj thañichiskachu carka. Manachayrí Siria jallp'amanta uj runalla, Naamán sutiyoj, thañichiska carka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Chayta uyarispa tucuy runas tantacuna-wasipi mayta rabiacorkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Jatarispataj llajta jawaman Jesusta kharkorkancu. Payta kharkospa llajta jatarichiskancu, chay orko pataman pusarkancu. Chay kakamanta paytaka chokaycuyta munarkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Payrí chay runaspa chaupincuta purispa riporka. ");
INSERT INTO quhNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Chanta Jesús Galilea jallp'a Capernaum llajtaman uraycorka. Samacuna p'unchaypitaj tantacuna-wasipi runasta yachachisharka. ");
INSERT INTO quhNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Paycunataj t'ucorkancu yachachiskanmanta imaraycuchus Diospa atiyninwan yachacherka. ");
INSERT INTO quhNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Tantacuna-wasipi millay supayniyoj runa carka. Sinch'ita khaparerkataj: ");
INSERT INTO quhNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Nazaret llajtayoj Jesús ¿imaman chapucuwaycu? ¿Tucuchinawaycupajchu jamunqui? Sumajta yachani pichus caskayquita. Kan Diospa ajllaskan canqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesusrí sinch'iwan camacherka supayta: —Ch'in cay. Llojsiy paymanta, —nispa. Runaspa chaupincupitaj supay chay runata pampaman chokaycuspa paymanta llojserka mana ni imanaspalla. ");
INSERT INTO quhNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tucuy runastaj mayta t'ucorkancu ninacusharkancutaj: —¿Imayna yachachiytaj cayrí? Atiywan cay runaka sajra supaycunata camachin, paycunataj llojsillancu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Tucuy chay jallp'a muyuynintinpi tiyacojcunataj Jesusmanta uyarerkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tantacuna-wasimanta Jesús llojsispa Simonpa wasinman yaycorka. Simonpa warminpa maman sinch'i k'oñi onkoywan casharka. Jesustataj mañacorkancu: —Señorníy, yanaparipuwaycu payta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Onkoskaj kayllanpi sayaspataj, Jesús sinch'iwan camachispa k'oñi onkoyninta kharkorka. Onkoskataj thañicaporka. Chay quiquinpacha jatarispa thañiska warmeka miqhunata paycunaman jaywarka. ");
INSERT INTO quhNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Inti chincaycushajtintaj tucuy runas onkoska llajta-masisnincuta Jesusman apamuyta kallarerkancu. Tucuy laya onkoywan onkoska runasta apamushallarkancupuni. Jesustaj sapa ujman maquisninta churaspa paycunata thañicherka. ");
INSERT INTO quhNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Chaywanpis ashqha runasmanta supaycunata kharkorka. Supaycunataj khaparisharkancu: —Kan Diospa Wawan Cristo canqui, —nispa. Jesusrí paycunata sinch'ita c'amispa mana sakerkachu parlanancuta chayta sumajta yachaskancuraycu. ");
INSERT INTO quhNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","K'ayantin pakarin Jesús llajtamanta llojsispa uj ch'innejman riporka. Chay ashqha runasrí payta masc'asharkancu. Jesuswan tincuspataj payta jarc'ayta munasharkancu. Nerkancutaj: —Ama sakerpariwaycuchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Payrí cuticherka: —Waj llajtasmanpis rinay tiyan sumaj willanasta willaranaypaj. Imaraycuchus Dios cachamuwarka willaranaypaj pay caypiña caskanta camachinanpaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Jesustaj israelcunaj tantacuna-wasisnincupi willarashallarkapuni. ");
INSERT INTO quhNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ashqha runastaj Diospa niskasninta munasharkancu uyariyta. Chayraycu chimpaspa Jesusman payta ñit'ejpuni cancu. Ajinata uj p'unchay Jesús Galilea kocha cantopi paycunawan sayarisharka. ");
INSERT INTO quhNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Iscay challwa jap'ina barcostataj cantopi ricorka. Challwiristaj chay barcosmanta ch'ipasnincuta t'ajsaj llojsiskancu. ");
INSERT INTO quhNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ajinata Jesús uj barcoman yaycorka. Chaytaj Simonpata carka. Jesús Simonman nerka: —Suchuycurichiy barcoyquita cantomanta as pisita yacuman, —nispa. Chaymanta barcopi tiyaycucuspa Jesús yachachisharka kocha cantopi chay ashqha cajcunaman. ");
INSERT INTO quhNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Paycunaman parlayta tucuspa Simonta nerka: —Kochaj uqhunnejman barcota apay. Yacumantaj ch'ipasniyquichejta churaycuychej challwasta jap'inayquichejpaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón cuticherka: —Señorníy, tutantinta sinch'ita llanc'arkaycu nitaj uj challwatapis jap'erkaycuchu. Chaywanpis niwaskayquiraycu ch'ipasta yacuman churaycusaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ajinata challwiris ch'ipasta yacuman churaycorkancu. May ashqha challwastataj jap'iskancumanta ch'ipasnincoka lliq'icusharkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Maquisnincuwantaj wajyarkancu challwiri-masisnincuta barconcuwan yanapaj jamunancuta. Jamojtincutaj iscaynin barcosman challwasta junt'acherkancu. Barcostaj chincaycunayasharkancu ancha junt'a caskancuraycu. ");
INSERT INTO quhNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simón Pedrotaj chayta ricuspa Jesuspa ñaupakenpi konkoricuspa nerka: —Señorníy, ripullay nokamanta juchasapa runalla caskayraycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simontaj tucuy paywan cajcunapis mayta t'ucorkancu ashqha challwasta jap'iskancumanta. ");
INSERT INTO quhNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ajinallatataj Zebedeoj wawasnin Jacobowan Juanwan mayta t'ucorkancu. Paycuna Simonpa challwiri-masisnin carkancu. Jesustaj Simonman nerka: —Amaña manchachicuychu. Ñaupajta challwiri carkanqui. Cunanmantapachataj Diospi jap'icunancupaj runasta nokaman pusamuwanqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Barcosnincutataj kocha cantoman aysamorkancu. Chaymantaka tucuy imasta sakerparispataj Jesusman c'ascaporkancu yachacojcunan canancupaj. ");
INSERT INTO quhNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Uj cuti Jesús uj llajtapi cashajtin chaypi uj manchay lepra onkoyniyoj runa carka. Chay runataj Jesusta ricuspa pampacama c'umuycuspa mañacorka: —Señorníy, sichus munanqui chayka, llimphuchawaspa thañichiwayta atinqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesús maquinwan payta llanqharispa nerka: —Munani. Thañiskaña canqui, —nispa. Onkoyniyoj runataj chay quiquinpacha thañiska carka. ");
INSERT INTO quhNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesustaj payta camacherka: —Ama pimanpis cay imasmanta willaychu. Manachayrí chekanta riy Jerusalenman yupaychana-wasipi ruwanayojman. Kan quiquiyqui khawachicamuy paywan. Chanta thañicuskayquimanta Moisespa camachiskanmanjina Diosman jayway. Ajinamanta tucuy yachankancu thañicuskayquita, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Chaywanpis tucuynejpi runas Jesusmanta uyarerkancu. Ashqha runastaj jamusharkancu uyarej, onkoynincumanta thañicojtaj. ");
INSERT INTO quhNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jesusrí sapallan ch'innejcunaman rej Diosmanta mañacunanpaj. ");
INSERT INTO quhNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Uj p'unchay Jesús yachachishajtin ashqha fariseocuna israel yachachejcunapiwan tiyaskas uyarisharkancu. Paycunaka jamorkancu tucuy Galilea llajtasmanta, Judea llajtasmanta, Jerusalén llajtamantapis. Jesustaj onkoska runasta thañichisharka atiyninwan. ");
INSERT INTO quhNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ajinapi runas uj mana cuyurej runata callapunpi wantuspa riqhurimorkancu. Sinch'itataj masc'asharkancu Jesuspa ñaupakenman imaynata wantuycuyta. ");
INSERT INTO quhNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Chay tucuywanpis Jesusman chimpaycuchiyta manapuni aterkancuchu runas chaypi ancha q'isqui caskanraycu. Ajinamanta wasi pataman llojsispa tejasta orkospataj jusc'uta ruwarkancu. Chaynejtataj mana cuyurej runata wantuspa uraycucherkancu Jesuspa ñaupakenman runaspa chaupincupi. ");
INSERT INTO quhNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesustaj paypi jap'icuskancuta repararka. Mana cuyurej runatataj nerka: —Wawáy, juchasniyqui kanmanta khechuskaña cancu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Chaymanta israel yachachejcuna fariseopiwan tanteyacuyta kallarerkancu: “¿Pitaj cay runa ajinata parlaspa Diosta phiñachejrí? Dioslla juchasta khechuytaka atin”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesús sumajta yachaspa yuyashaskancuta paycunaman cuticherka: —Amaña sonkosniyquichejpi ajinata tanteyacuychejchu. ");
INSERT INTO quhNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Cay runaman nejtiy “juchayqui perdonaskaña”, nispaka mana ricunquichejchu chekachus manachus caskanta. Astawanrí cay mana cuyurej runata jatarichiyman chayka, ricuwajchej. ");
INSERT INTO quhNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Noka, Diospa cachaska Runan caspa, cay pachapi atiyniyoj cani juchasta perdonanaypaj. Chay cheka caskanta yachanayquichejpaj, cay mana cuyurej runata nini: Kanta niyqui: Jataricuy, callapuyquita okharicuspa ripuy wasiyquiman, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Chay quiquinpachataj runaspa ñaupakencupi runa jatarerka. Callapunta okharicuspa Diosta yupaychaspataj wasinman riporka. ");
INSERT INTO quhNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tucuy runastaj mayta t'ucorkancu Diostataj yupaycharkancu. Mayta manchachicuspataj nerkancu: —Cunan p'unchay may jatuchej t'ucunasta ricushanchej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Chaycuna khepata Jesús llajtamanta llojserka. Uj impuesto jap'ejta, Leví sutiyojta, ricorka impuesto jap'ina wasipi tiyacushajta. Payta khawarispataj nerka: —Yachacojniy cay, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levika tucuy imata sakerpaytawan jatarispataj Jesusta khaticorka. ");
INSERT INTO quhNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Wasinpi Leví uj jatun miqhunata waquicherka Jesuspaj. Ashqha impuesto jap'ejcunata waj runastawan wajyarka paycunawan miqhunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Fariseos paycunaj yachachejcunancupiwan thutorkancu Jesuspa yachacojcunantataj taporkancu: —¿Imaynatataj impuesto jap'ejcunawan juchasapaspiwan cusca tiyaycucuspa miqhushanquichej? ");
INSERT INTO quhNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús paycunaman cuticherka: —Onkoska runaslla medicotaka munancu, manataj sano runaska. ");
INSERT INTO quhNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Juchasapasta wajyaj jamorkani paycuna sajra ruwaskasnincuta sakespa Diosman cutirinancupaj. Manataj jamorkanichu chekan cajcunata wajyaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Chay runastaj Jesusta nerkancu: —Juanpa yachacojcunan q'isquita ayunancu. Ajllaska horaspipuni Diosmantapis mañacuncu. Ajinallatataj fariseospa yachacojcunancupis ruwancu. ¿Imaraycutaj kanpata miqhushallancu ujyashallancurí? Cayta taporkancu Jesuspa mosoj yachachiyninta mana entiendeskancuraycu. ");
INSERT INTO quhNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesustaj paycunaman cuticherka: —Casamientoman wajyaskacunaka casaracoj khari paycunawan cashanancama cusiywan miqhuncupuni. ");
INSERT INTO quhNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Khepa p'unchaycunapi casaracoj khareka paycunamanta khechuska canka. Chaypacha yachacojcunayka phutiywan mana miqhonkancuchu, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Chaywanpis mosoj yachachiyninmanta Jesús cay quiquinchanawan paycunaman willarka: —Ni pipis uj mosoj p'achamanta uj remiendota orkhonmanchu uj mauc'a p'achaman siraycunanpajka. Sichus chayta ruwanman chayka, chay mosoj p'achaka lliq'erkoska canman. Chaywanpis mauc'a cajka mana quiquinchu canman mosojwanka. ");
INSERT INTO quhNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Uj imatawan niskayquichej: Ni pipis mosoj pokoshaj vinota mauc'a vino churana karasmanka jich'anchu. Sichus chayta ruwanman chayka, mosoj vinoka karasta phatarparichinman. Vinoka jich'acunman, karasri lliq'iycucuncuman. ");
INSERT INTO quhNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mosoj vinotaka mosoj karasman churana tiyan. ");
INSERT INTO quhNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Chaywanpis ni pipis ashqha watasniyoj vinota ujyashaspa mosoj vinota munanchu. Astawanpis nin: “Ashqha watasniyoj vinoka nokapaj cosamin”, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Uj samacuna p'unchay Jesús yachacojcunanwan trigo chajra chaupita risharkancu. Yachacojcunantaj trigo umasta muruspa pallasharkancu. Maquisnincuwan trigota kharkorkancu miqhunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Waquin fariseosrí yachacojcunata taporkancu: —¿Imaraycutaj samacuna p'unchaypi mana ruwana cajta ruwashanquichej? ");
INSERT INTO quhNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesustaj paycunaman cuticherka: —¿Manatajchu leerkanquichej unay tatayquichej Davidpa ruwaskanmanta? Payka runasninpiwan yarkhachicorkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Chayraycu Diospa wasinman yaycorka. Diospaj t'akaska t'antataj payman koska carka. Camachiskanpi nin cay t'antaka Diospa wasinpi llanc'ajcunalla miqhunancupaj caskanta. Davidrí cay t'antata miqhuycorka runasninmanpis kollarkataj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Astawanpis Jesús nerka: —Noka, Diospa cachaska Runan, atiyniyoj cani camachinaypaj imatachus ruwanata samacuna p'unchaypi, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Waj samacuna p'unchaypitaj Jesús rispa tantacuna-wasiman yaycorka. Yachachisharkataj runasta. Chaypi uj runa casharka paña maquin wañuska. ");
INSERT INTO quhNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Israel yachachejcuna fariseospiwan Jesusta sinch'ita khawasharkancu. Samacuna p'unchaypi thañichinmanchus manachus, chayta munasharkancu yachayta. Chayraycu watekasharkancu imallamantapis payta juchachanancupaj. ");
INSERT INTO quhNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesusrí ajinata yuyaskancuta yacharka. Chanta wañuska maquiyoj runata nerka: —Sayaricuy ñaupakeycupi, —nispa. Chay runataj jatarispa sayarerka. ");
INSERT INTO quhNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Chanta Jesús israel yachachejcunaman fariseosmanwan nerka: —Ujta tapuriskayquichej: ¿Samacuna p'unchaypi imatataj runa ruwanan tiyan? ¿Allin cajtachu ruwanata chayrí sajra cajtachu, camachiskaka nin? ¿Runata yanapanatachu chayrí payta wañuchinatachu? ");
INSERT INTO quhNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ujta ujta khawarispataj chay wañuska maquiyoj runata nerka: —Maquiyquita aysariy, —nispa. Maquinta aysarerka. Ujnin maquinjinataj thañicaporka. ");
INSERT INTO quhNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Israel yachachejcunawan fariseoswanrí manchayta phiñacorkancu. Tapunacuytataj kallarerkancu: “¿Imanasunmantaj Jesusta?” ");
INSERT INTO quhNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Chaypacha Jesús orkoman llojserka Dioswan parlaricoj. Chaypitaj tutantinta Dioswan parlaricusharka. ");
INSERT INTO quhNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tutamanta yachacojcunata payman wajyarka. Paycunamanta chunca iscayniyoj runasta ajllarka. Paycunatataj cachasninpaj churarka. ");
INSERT INTO quhNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Sutisnincutaj caycuna cashan: Simón, payta Pedrota Jesús suticharka, Simonpa wauken Andrés, Jacobo, Juan, Felipe, Bartolomé, ");
INSERT INTO quhNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Alfeoj wawan Jacobo, zelote partemanta Simón, ");
INSERT INTO quhNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jacoboj wawan Judas, Judas Iscariotepiwan. Payka khepata Jesusta jaywaycorka. ");
INSERT INTO quhNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Chanta paycunawan Jesús uraycuspa uj pampapi sayaricorka. Chaypi ashqha yachacojcunan ashqha runaspiwan carkancu. Paycuna carkancu tucuy Judea jallp'amanta, Jerusalén llajtamanta, jatun kocha kayllanej Tiro llajtamanta Sidón llajtamantawan. Jesusta uyarej jamorkancu, onkoynincumanta thañichicojpis. ");
INSERT INTO quhNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Supaycunawan muchuchiska runastapis Jesús thañichisharka. ");
INSERT INTO quhNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Tucuy runastaj Jesusta llanqhariyta munasharkancu atiyninwan tucuyta thañichiskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesús yachacojcunanta sumajta khawarispa nerka: —Mayta cusicuychej, kancuna, wajcha runas. Imaraycuchus Dios kancunata munacuywan camachin. ");
INSERT INTO quhNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","‘Cusiskas canquichej, cunan yarkhachicojcuna. Khepata sajsachiskas canquichej. ‘Cusiskas canquichej, cunan phutiywan wakashajcuna. Khepata cusiywan asicunquichej. ");
INSERT INTO quhNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","‘Cusiskas canquichej runas kancunata chejnisojtiyquichej, jawaman kharkosojtiyquichej, llullacuspa sajrata kancunamanta rimasojtiyquichej. Cusiskas canquichej runas kancunata sajra runastajina khesachasojtiyquichej, nokata, Diospa cachaska Runanta, khatiwaskayquichejraycu. ");
INSERT INTO quhNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Chay p'unchaypi cusicuychej. Cusiywantaj phinquiriychej. Janaj pachapimin kancunapaj uj jatun kona tiyan. Unay tatasnincupis chay quiquillantataj Diospa unay willajcunata muchucherkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","‘¡Phutiy, ari, kancuna khapajcunapajka! tucuy munaskayquichejwanña sonkochacuskayquichejraycu. ");
INSERT INTO quhNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","‘¡Phutiy, ari, kancuna ashqha miqhunawan sajsaskasña cajcunapajka! Khepata yarkhasonkachej. ‘¡Phutiy, ari, kancuna cunan asishajcunapajka! Khepata llaquicunquichej wakanquichejtaj. ");
INSERT INTO quhNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","‘¡Phutiy, ari kancunapajka tucuy runas allinta kancunamanta parlajtincu! Ajinallatatajmin llulla willajcunamanta unay tatasnincu parlaj cancu. ");
INSERT INTO quhNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","‘Chay jawapis kancuna nokata uyariwajcunaman cayta sumajta nishayquichej. Munacuychej contrayquichejpi churacojcunata. Allin cajta ruwaychej kancunata chejnisojcunata. ");
INSERT INTO quhNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Misq'i parlaywan cutichiychej sajrata parlasojcunaman. Diosmanta mañapuychej kancunaman tumpasojcunapaj. ");
INSERT INTO quhNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Pillapis paña uyayquipi lak'asojtenka cutirichiy llok'e lado uyayquitawan lak'ananpaj. Pillapis ponchoyquita khechusojtenka sakellay apananta camisayquitawanpis. ");
INSERT INTO quhNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Pillapis kanmanta uj imallatapis mañacusojmanka korillay. Pillapis kanpata cajta khechusojtenka ama mañacapuychu. ");
INSERT INTO quhNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Imaynatachá runacuna kancunaman ruwanancuta munanquichej, ajinallatataj kancunapis paycunaman ruwaychej. ");
INSERT INTO quhNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","‘Sichus kancuna munacushanquichej munacusojcunallata chayka ¿ima sumajtataj ruwashanquichejrí? Juchasapaspis paycunata munacojcunallata munacuncu. ");
INSERT INTO quhNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Sichus kancuna allin cajta ruwanquichej allin cajta ruwasojcunallaman chayka ¿ima sumajtataj ruwashanquichejrí? Juchasapaspis ruwancu chaytaka. ");
INSERT INTO quhNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Sichus kolketapis mirayniyojpaj ayniwajchej chayka ¿ima sumajtaj ruwashanquichejrí? Juchasapaspis juchasapasman mirayniyojpaj aynincu mirayninta jap'icapunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kancunarí enemigosniyquichejta munacuychej, allin cajtapuni ruwaychej. Ayniychejtaj runasman ni imata jap'iyta suyaspa. Cayta ruwajtiyquichej Dios ashqhata kopusonkachej. C'ata Diospa wawasnintaj canquichej. Payka c'acha qhuyacuyniyojmin cashan mana graciasta kojcunamanpis sajra runasmanpis. ");
INSERT INTO quhNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Imaynatachus Dios Tatayquichej tucuy runasta qhuyacushan, ajinallatataj kancunapis qhuyacuychej. ");
INSERT INTO quhNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","‘Ama wajcunata khawaraychejchu. Diostaj mana khawarasonkachejchu. Ama wajcunataka juchachaychejchu. Diostaj mana juchachasonkachejchu. Runaspa juchasnincuta perdonaychej. Diostaj perdonasonkachej. ");
INSERT INTO quhNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Koychejpuni. Diostaj kancunaman kosonkachej. Wayakasniyquichejman Dios winapusonkachej sumaj medidawan tupuskata, ñit'iskata, sumaj wasarishajta. Kancuna ima medidawanchá wajcunaman tupunquichej, chayjinallawantaj Dios kancunaman tupusonkachej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Cay quiquinchanata Jesús parlarka runasman: —Uj ciego ciegollatatajka ni jayc'aj pusayta atinmanchu. Pusanchus chayka, iscaynincu cusca t'okoman urmayconkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Yachacojka mana curajchu yachachejninmantaka. Pay sumaj yachachiska caspaka yachachejninjinapis canka. ");
INSERT INTO quhNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","‘Uj jatun curcujina kanpa jatun pantaskayquita mana reparacuspaka ¿imaynatataj uj ichhu k'opajina hermanoyquej juch'uy pantaskanta khawaranquirí? ");
INSERT INTO quhNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Quiquin ñawiyquipitaj jatun curcuta mana reparacunquichu. Chayraycu hermanoyquita amaña niychu: “Hermanóy, sakellaway ichhu k'opata ñawiyquimanta orkhosunayta”, nispa. Puraj uya, chay curcutaraj ñawiyquimanta orkhonqui. Chanta aswan sut'ita ricunqui juch'uy k'opata hermanoyquejpa ñawinmanta orkhonayquipaj. ");
INSERT INTO quhNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","‘Uj sumaj sach'aka nipuni mana allin pokoytaka pokonchu. Uj mana allin sach'apis nillataj sumaj pokoytaka pokonchu. ");
INSERT INTO quhNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Sapa sach'a quiquin pokoyninmanta rejsicun. Ni pipis pallanchu higosta qhishca sach'amantaka. Nitaj uvasta pallanchu qhishcarara sach'itamantaka. ");
INSERT INTO quhNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ajinallataj uj c'acha runaka c'acha cajta ricuchin sonkonpi c'acha caj jallch'aska capuskanmanta. Uj sajra runaka sajra cajta ricuchin sonkonpi sajra caj jallch'aska caskanmanta. Runaka parlan sonkonpi junt'a caskanmanta. ");
INSERT INTO quhNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","‘¿Imaraycutaj kancuna nokata, “Ay, Tatáy, Señorníy”, nispa nishawanquichejpuni manataj niskaytaka casuwanquichejtajchu? ");
INSERT INTO quhNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nokaman jamuwajka niskasniyta uyarispa casushanpuni, ");
INSERT INTO quhNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","chay runaka uj sumaj wasichaj runaman rijch'acun. Chay wasichajka ñaupajta allin uqhuta allarka. Sinch'i rumi patapitaj wasita sayacherka. Mayuta yacu wasarispa callpawan chay wasiman chayarka. Wasita mana cuyurichiyta aterkachu rumi patapi sumaj sayachiska caskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nokata uyariwajka niskasniyta manataj casorkachu, chay runarí waj wasichaj runamantaj rijch'acun. Payka jallp'a patallapi wasita sayacherka manataj rumipichu. Mayuta yacu wasarispa callpawan chay wasiman chayarka. Chay quiquinpacha wasi tijracuspa manchayta urmarka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Chay yachachinasta runasman parlayta tucuspa Jesús Capernaum llajtaman yaycorka. ");
INSERT INTO quhNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Chaypi carka pachaj romano soldadosta uj camachej. Paypa camachintaj sinch'i onkoywan wañunayasharkaña. Chay camachejka camachinta munacorka. ");
INSERT INTO quhNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Runaspa niskasnincuta Jesusmanta uyarispa israel curajcunata wajyarka nerkataj: —Riychej Jesusman wajyarimpuwaychej: “Jamuriy, camachiyta thañichipuwanqui”, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Israel curajcunataj Jesusman chayaspa mayta niricorkancu: —Cay mañasojpajka ruwapunayqui allinpuni canman c'acha runa caskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Payka israelcunata munacun. Tantacuna-wasinchejtapis paypa kolkenwan ruwarkanchej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Chanta Jesús paycunawan rerka. Wasi kayllaman chayashajtintaj chay camachej amigosninta cachamorka ninancupaj Jesusman: —Señorníy, amaña molestacuychu. Juchasapa caskayraycu mana wasiyman yaycunayquipajjinachu cani. ");
INSERT INTO quhNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Manallataj noka quiquiypis kanman chimpaycusunaypajjinachu cani. Nillay, uywaskayka niskayquiwan thañicaponkataj. ");
INSERT INTO quhNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nokajtapis curaj camachiwajcuna cancu. Soldadosniypis callancutaj camachiskayta casuwancu. Ujta nini: Riy. Rintaj. Wajta nini: Jamuy. Jamuntaj. Camachiytapis nini: Cayta ruway. Chayta ruwallantaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesús chayta camachejmanta uyarispa t'ucorka. Chanta ashqha khatejcunaman cutirispataj nerka: —Niyquichej, Israel llajta-masisniy uqhupipis mana tariskaychu ni ujta cay runajinataka. Payka chekatapuni niskasniyta jap'icun, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Camachejpa cachamuskasnin wasiman cutispa onkoska camachintaka thañiskataña tariparkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Chaymanta Jesús Naín llajtaman risharka. Yachacojcunan ashqha runaspiwan paywan risharkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Jesús llajta puncuman chayamushajtin, runas uj joven ayata llajta jawaman p'ampaj apasharkancu. Payka mamanpa sapan c'ata wawan carka. Mamantaj viuda carka. Ashqha runas viudawan risharkancu llajtamanta. ");
INSERT INTO quhNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Señor payta ricuspa mayta phuticorka paymanta. Payta nerkataj: —Amaña wakaychu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Chimpaycuspa Jesús wantunata llanqharerka. Apaj runastaj sayarkancu. Chanta Jesús nerka: —Joven, kanta niyqui: Jataricuy, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Wañojka tiyaycacamuspa parlayta kallarerka. Jesús waynata causashajta mamaman cutichiporka. ");
INSERT INTO quhNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tucuynin runastaj mayta manchachicuspa Diosta yupaycharkancu. Nisharkancutaj: —Chaupinchejpi cashan Diosmanta uj sumaj willaj. Dios jamuspa runasninta yanapashan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Runas willacusharkancu Jesusmanta tucuy Judea jallp'api tucuy chay muyuynintinpipis. ");
INSERT INTO quhNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juanpa yachacojcunantaj payman tucuy chay imasmanta willarkancu. Juantaj paycunamanta iscayta wajyaspa ");
INSERT INTO quhNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","cacharka Señorman tapunancupaj: “¿Kanchu canqui Diospa niskanmanjina jamunan cajka, chayrí wajtachu suyallasajcupuni?” ");
INSERT INTO quhNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Jesusman chayaspa chay cachaska runas nerkancu: —Bautizaj Juan cachamuwarkaycu tapusunaycupaj: ¿Kanchu canqui Diospa niskanmanjina jamunan cajka, chayrí wajtachu suyallasajcupuni? ");
INSERT INTO quhNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Chay quiquinpachataj Jesús ashqha runasta onkoynincumanta muchuynincumantapis thañicherka. Sajra supaycunatapis ashqha runasmanta kharkorka. Ashqha ciegostapis khawaricherka. ");
INSERT INTO quhNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Juanpa cachaska runasninmantaj Jesús cutichispa nerka: —Riychej, willamuychej Juanman ricuskayquichejta uyariskayquichejtawan. Ciegos ricushancuña, suchuspis purishancuña, lepra onkoyniyoj runaspis thañiskaña cashancu. Lojt'ospis uyarishancuña, wañuska runastaj causarichiskaña cashancu. Sumaj willanaspis wajcha runasman willaraska cashan. ");
INSERT INTO quhNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Cusicuyniyojmin mana p'enkacuspa nokapi jap'icojka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Juanpa cachasnin ripuskancutawan Jesús paymanta parlayta kallarerka runasman: —Juan ch'in pampapi willarashajtin kancuna uyarej llojserkanquichej. ¿Ima laya runata ricuytataj yuyasharkanquichejrí? Mana ichhujina wayrawan c'umuycachaska runatachu tarerkanquichej. ");
INSERT INTO quhNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Manataj sumaj camachejjina p'achaswan p'achalliska runatachu tarerkanquichej. Chayjina p'achalliska cusiywan causaj runaka camachejcunaj wasisnincupi tiyacun. ");
INSERT INTO quhNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kancunaka waj laya runata masc'asharkanquichej. Chayraycu Diosmanta uj willajta uyarej llojserkanquichej. Chekapuni payka Diospa unay willajcunanmanta aswan curajmin. ");
INSERT INTO quhNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Cay willajmanta Dios palabranpi nerka: ¡Khaway! Noka willajniyta kanpa ñaupakeyquita cachashani. Payka runaspa sonkoncuta waquichipusonka paycunaman rinayquipaj. ");
INSERT INTO quhNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nokataj niyquichej tucuynin runas uqhupi ni uj runa caskanta aswan curaj Juanmanta niskaka. Dios camachin, chaypeka aswan pisipaj khawaska cajrí aswan curajpunimin Juanmanta niskaka. ");
INSERT INTO quhNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ashqha uyarej runas impuesto jap'ejcunapiwanpis Juan willarashajta uyarispa, bautizacorkancu. Bautizacuspataj ricucherkancu juchasnincuta sakeskancuta Dios chekan caskantataj. ");
INSERT INTO quhNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Fariseosrí israel yachachejcunapiwan paycunapaj Diospa munayninta khesacharkancu. Mana munarkancuchu Juan paycunata bautizananta, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Nerkataj: —¿Picunamantaj rijch'acuncu cunan p'unchay runas? ");
INSERT INTO quhNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Rijch'acuncu plazapi tiyaska pujllacoj wawasman. Paycunapura khaparinacuncu: “Tusunayquichejpaj kenata tocaporkaycu. Kancunarí mana tusorkanquichejchu. Llaquiy taquinasta taquiporkaycu. Kancunarí mana wakarkanquichejchu”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ajinata bautizaj Juan jamuspa mana sumaj miqhunasta miqhorkachu nitaj vinota ujyarkachu. Paymantataj nerkanquichej: “Supayniyoj”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Chanta noka, Diospa cachaska Runan, miqhuspa ujyaspa jamorkani. Nokamantataj nishanquichej: “¡Khawaychej! Cay runaka miqhuysapa ujyaysapataj. Impuesto jap'ejcunata juchasapasta munacun”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tucuy cheka yachayniyojcunaka rejsincu Diospa yachaynin chekapuni caskanta, —nispa nerka Jesus. ");
INSERT INTO quhNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Fariseo partemanta ujnin Jesusta wajyarka paywan miqhunanpaj. Ajinamanta Jesús paypa wasinman rerka miqhoj. ");
INSERT INTO quhNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Cay llajtapitaj carka uj ancha juchasapapaj rejsiska warmi. Pay uyarerka Jesús fariseoj wasinpi miqhushaskanta. Chanta pay uj sumaj rumi yuritupi c'acha k'apayniyoj aceitejina jawinata apamorka. ");
INSERT INTO quhNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jesús mesapi miqhushajtin chay warmi wakaspa sayarka Jesuspa chaquisnin kayllapi. Chanta pay wakayninwan Jesuspa chaquisninta mayllaspa chujchanwan ch'aquicherka. Chaquisnintataj much'asharka k'apayniyoj jawinata jich'aycuspa. ");
INSERT INTO quhNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Miqhunancupaj Jesusta wajyarka, chay fariseo Simón, tucuy chayta ricorka. Yuyarkataj sonkonpi: “Sichus chekamanta cay runa Diospa willajnin canman chayka, sumajta yachanman pichus llanqhaskanta. Cay warmeka chhica juchasapa caskantapis yachanmanpuni carka”, nispa yuyarka. ");
INSERT INTO quhNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Chanta Jesús payta nerka: —Simón, uj ima cashan nisunaypaj, —nispa. Paytaj cuticherka: —Yachachiwajníy, nillaway, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesustaj nerka: —Uj kolke manoj runa iscay manu runasniyoj carka. Ujnin manu runa kolketa cutichipunan carka phishka chunca p'unchay llanc'askamantajina. Ujnin manu runataj phishka p'unchay llanc'askamantajinalla kolketa cutichipunan carka. ");
INSERT INTO quhNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Iscaynincu ni imayoj caskancuraycu, manoj runaka qhuyaspa mana paycunamanta cutipunancuta mañarkachu. ¿Chay iscay runasmanta maykentaj astawan chay manojta munaconkarí? ");
INSERT INTO quhNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón cuticherka: —Yuyani chay aswan ashqha konan carka, chay runachá, —nispa. Paytataj Jesús nerka: —Arí, chekanta tanteyanqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Chanta warmiman cutirispa Jesús Simonta nerka: —Ricushanqui cay warmita. Noka wajyaska jamorkani wasiyquiman. Manataj chaquisniyta yacuwan mayllawarkanquichu. Cay warmirí wakayninwan chaquisniyta jok'ochaspa mayllawarka chujchanwanpis ch'aquichiwarka. ");
INSERT INTO quhNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kan napaycushawaspa mana much'aycuwarkanquichu. Payrí chaquisniyta much'ayta mana sakerkachu chayamuskaymantapacha. ");
INSERT INTO quhNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kan mana umayta jawiwarkanquichu. Payrí k'apaj jawinata chaquisniyman jich'aycuwarka. ");
INSERT INTO quhNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kanta niyqui: Cay warmej may munacuynenka ricuchin ashqha juchasnin khechuska caskanta. Pichari pisi juchasnillanta khechuska cajka pisita munacun, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Chaymanta warmita nerka: —Juchasniyqueka khechuskaña cancu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Paywan wajyaskacunaka sonkoncupi kallarerkancu tanteyacuyta: —¿Imaynapunitaj cay runarí, pay juchastapis khechunanpaj? ");
INSERT INTO quhNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Warmitarí Jesús nerka: —Diospi jap'icuskayquiraycu juchamanta cachariska canqui. Ripullay, allintataj causacuy, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Chanta Jesuska purej llajtamanta llajta, ranchomanta rancho. Purerka sumaj willanasta willaraspa: “Dios caypiña munacuywan camachinanpaj”, nispa. Chay chunca iscayniyoj cachasnintaj paywan purerkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Waquin warmistaj paycunawan rerkancu yanapanancupaj. Cay warmista onkoynincumanta Jesús unayña thañicherka. Waquinmanta supaycunata kharkorka. Ujpis Magdala llajtayoj María carka. Paymanta Jesús kanchis sajra supaycunata kharkoska. ");
INSERT INTO quhNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ujtaj Juana carka, Chuza sutiyojpa warmin. Chuzaka Herodespa uj khawapojnin carka. Chay warmismanta ujnintaj Susana carka. Waj ashqha warmispiwan Jesusta yachacojcunantawan yanapaspa churaporkancu capuynincumanta. ");
INSERT INTO quhNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Runas ashqha llajtasmanta Jesusman jamorkancu. Ashqha runas tantacojtincutaj Jesús cayjinata quiquincharka: ");
INSERT INTO quhNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Uj runa mujuta t'acaj llojserka. T'acashajtin waquin mujoka ñan pataman urmarka. Chay muju saruska carka. P'iskostaj pallacaporkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Waquin mujutaj pisi jallp'ayoj rumi pataman urmarka. Llojsispataj ch'aquicaporka mana jok'o caskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Waquin mujoka qhishcas chaupiman urmarka. Cusca llojsimuspa qhishcaska trigota sipiycaporka. ");
INSERT INTO quhNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Waquin mujutaj sumaj jallp'aman urmarka. Chay mujuri wachaspa sapa ujmanta pachajman pokorka, —nispa. Chayta niytawan Jesús sinch'ita nerka: —¡Ningriyoj cajka sumajta uyarichun! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jesuspa yachacojcunan payta taporkancu: —¿Ima ninayantaj cay quiquinchanarí? ");
INSERT INTO quhNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesustaj nerka: —Imaynatachus Dios runasta camachin, chay yachachinaska pacaska carka. Cunanrí kancunallaman Dios chay imasta sut'inchashasunquichej. Waj runasmantaj quiquinchanaswan yachachiska cashan. Chayraycu ricuncu manataj ricuskancuta entiendencuchu. Uyarincu manataj uyariskancuta reparancuchu. ");
INSERT INTO quhNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","‘Chay quiquinchana cayta ninayan: Mujoka Diospa niskanmin. ");
INSERT INTO quhNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Waquin mujus ñan kayllaman urmarkancu. Ajinallatataj runas Diospa niskanta uyarincu. Chay quiquinpachataj supay Satanás jamuspa Diospa niskanta sonkoncumanta orkhopun. Manataj sakenchu runas Diospa niskanta jap'icunancuta cachariskas canancupaj. ");
INSERT INTO quhNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Waquin mujustaj pisi jallp'ayoj rumi pataman urmarkancu. Ajinallatataj waquinpis Diospa niskanta uyarispa cusiywan creellancu. Sonkoncumanrí mana sumajta yaycunchu. Pisi saphiyojjina cancu. Chayraycu pisi ratullapaj Diospa niskanta jap'icuncu. Llaquiycuna jamojtinrí chay runas sumaj ñanmanta pantapuncu. ");
INSERT INTO quhNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Waquin mujustaj qhishca chaupiman urmarkancu. Ajinallatataj waquinpis Diospa niskanta uyarincu. Chay runasrí anchataraj yuyashancu cay pacha imasmanta. Munashancu ancha khapaj capuyta causaynincupi yankha cusiytawan. Tucuy cay imas Diospa niskanta sipiycapuspa causaynincupi mana sakencuchu wiñananta. Nitaj pokoynenka canchu. ");
INSERT INTO quhNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Waquin mujustaj allin jallp'aman urmarkancu. Ajinallatataj waquin runaspis c'acha sonkoncuwan Diospa niskanta sumajta casullancupuni. Paycunaka pokoyniyoj cancu Diosta cusichincutaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jesús nerkataj: —Runas uj c'anchata jap'ichispa mana mancawan c'umpuycuncuchu. Nitaj tiyana uramanpis churancuchu. Astawanpis pataman churancu runas yaycuspa c'anchata ricunancupaj. Imaynatachá c'anchaywan lakhapi cajcuna riqhurincu, ajinallataj mana yachaska cajpis uj p'unchay yachaconka. ");
INSERT INTO quhNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ajinallataj Diospa niskanwan cashan. Waquin runaspajka pacaska cashan. Nokarí reparanancupaj yachachispa Diospa niskanta sut'inchashani. ");
INSERT INTO quhNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Chayraycu sumajta khawacunayquichej tiyan imaynata uyarishaskayquichejta. Diospa niskanta jap'icojmanka astawan koska canka. Mana jap'icojmantarí jap'iskanta yuyaskanpis khechuska canka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesuspa maman waukesninpiwan payta watoj jamorkancu. Payman mana chimpayta aterkancuchu q'isqui runas chaypi caskancuraycu. ");
INSERT INTO quhNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Runas Jesusman cayjinata willarkancu: —Mamayqui waukesniyquipiwan jawapi sayashancu tincusuyta munaspa, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesustaj paycunaman nerka: —Diospa niskasninta uyarincu casushancutaj, chaycunamin nokaj mamay waukesniypis cancu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Uj p'unchay Jesús uj barcoman yaycorka yachacojcunanwan. Paycunatataj nerka: —Jacu rina kocha chimpaman, —nispa. Ajinatataj rerkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Rishajtincutaj Jesús puñucaporka. Uj sinch'i wayra lomasmanta uraycamuspa kochaman wayramorka. Ajinamanta barcoman yacu junt'aycuspa chincaycuchinayasharka. ");
INSERT INTO quhNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Yachacojcunantaj Jesusman kayllaycuspa rijch'acherkancu: —¡Yachachiwajníy! ¡Yachachiwajníy! Chincarishanchej, —nispa. Paytaj rijch'arispa sinch'iwan camacherka sinch'i wayrata yacutapis okharicamojtapis. Chanta manaña wayrarkachu. Kochapis ch'inyacaporka. ");
INSERT INTO quhNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jesustaj yachacojcunata nerka: —¿Imaraycutaj Diospi mana jap'icushanquichejchu? Paycunarí mayta manchachicuspataj t'ucorkancu. Ninacusharkancutaj: —¿Imayna runapunitaj payrí? Camachin wayrata yacutapis. Payta casuncutaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Paycunataj rerkancu Gadara jallp'aman. Chay jallp'aka Galilea kochaj chimpanpi cashan. ");
INSERT INTO quhNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesús barcomanta jallp'aman llojsejtin paywan tincorka llajtamanta uj runa. Chay runaka supaycunayoj carka. Unayña payka mana p'achanta churacorkachu. Nitaj wasipipis tiyacojchu, astawanpis panteonpi. ");
INSERT INTO quhNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Chay runataj Jesusta ricuspa khaparicorka. Jesuspa ñaupakenman konkoricuspa sinch'iwan nerka: —Jesús, c'ata Diospa Wawan ¿imaman chapucuwanqui? Sumajta mañacuyqui ama ñac'arichinawayquita, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Chayta nerka Jesús sajra supayta runamanta llojsinanta camachishaskanraycu. Ashqha cutista supayka runata t'ucuta jap'ichej. Runas fierro cadenaswan watanaswanpis payta sumajta wataj cancu. Supayniyoj runarí watanasta p'iterkayaj. Supaytaj payta ch'in lugaresman apaj. ");
INSERT INTO quhNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesustaj payta taporka: —¿Imataj sutiyqui? Cuticherkataj: —Suteyka sojta waranka, Legión, —nispa. Ajina sutichaska carka payman ashqha supaycuna yaycuskancuraycu. ");
INSERT INTO quhNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Chay supaycuna Jesusta mañacusharkancu: —Ama uqhu pachaman rinaycuta camachiwaycuchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Chaynejpi ashqha qhuchis orkopi korata miqhusharkancu. Supaycunaka Jesusta mañacorkancu: —Sakellawaycu chay qhuchisman yaycunaycuta, —nispa. Jesús paycunata sakellarka. ");
INSERT INTO quhNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Runamanta llojsispa supaycuna qhuchisman yaycorkancu. Chanta qhuchiska cachaycucuspa kakamanta kochaman ch'ulticorkancu, jek'ecaspataj wañurarkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Cayta ricuspa qhuchi michejcunaka aykecorkancu. Paycunataj llajtapi ranchospipis chay imasmanta willamorkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Chanta runas chay imasta ricoj llojserkancu Jesusman chimpaspa. Supaycuna llojserka, chay runatapis ricorkancu. Payka p'achalliska yuyayninpi Jesuspa chaquisninpi tiyacusharka. Chayta ricuspa runaska manchachicorkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Chay ruwaskasta ricojcunataj jamojcunaman willasharkancu imaynatachus chay runa supaycunamanta cachariska caskanta. ");
INSERT INTO quhNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tucuy Gadara jallp'amanta runas Jesusta ripunanta mañarkancu anchata manchachicuskancuraycu. Mañaskancumanjinataj Jesús barcoman yaycorka kocha chimpaman cutinanpaj. ");
INSERT INTO quhNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Chay supaycunamanta cachariska runarí Jesusta nicusharka: —Sakellaway kanwan rinayta, —nispa. Jesusrí payta cachaporka: ");
INSERT INTO quhNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Cutiriy tatasniyquiman. Willamuy Dios tucuy sumaj ruwapususkanmanta, —nispa. Ajinamanta payka llajtantinman rispa willarasharka Jesús paypaj ruwapuskanta. ");
INSERT INTO quhNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Kocha chimpapi ashqha runas Jesusta suyasharkancu. Chayraycu chayman cutejtin tucuynincu payta, “Walejta jamunqui”, nerkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Chanta uj runa, Jairo sutiyoj, riqhurimorka. Pay uj curaj runa carka tantacuna-wasimanta. Jesuspa ñaupakenpi konkoricuspa mayta mañacorka Jesús wasinman rinanta, ");
INSERT INTO quhNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ususin wañupunayashaskanraycu. Paypa sapa ususin carka, chunca iscayniyoj watayojjina. Jesustaj paywan rerka. Jesús rishajtin ashqha runas q'isquicamuspa payta ñit'isharkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Paycuna uqhupitaj carka uj onkoska warmi. Payka muchorka chunca iscayniyoj watata yawar apaywan. Tucuy capuynintapis tucuycorka medicoswan jampichicuspa. Nitaj ni mayken medicopis payta thañichiyta aterkachu. ");
INSERT INTO quhNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Chay warmeka Jesuspa khepanman jamuspa ponchon t'icasninta jap'irerka. Chay quiquinpacha yawar apayninmanta thañichiska carka. ");
INSERT INTO quhNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesustaj nerka: —¿Pitaj jap'iricuwarkarí? Tucuy runas nerkancu: —Ni pipis jap'iricusorkachu, —nispa. Chanta Pedro nerka: —Yachachejníy, ashqha runas q'isquicamuspa kanta ñit'ishasuncu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesusrí nerka: —Ujmin jap'iricuwarka. Chekamanta noka reparani atiyniy uj runata thañichiskanta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Chay warmeka ruwaskanmanta yachacuskanta repararka. Chayraycu qharcatitispa Jesusman jamorka, ñaupakenpitaj konkoricorka. Tucuy runaspa ñaupakencupitaj imapajchus Jesusta jap'iricuskanta willacorka. Imaynatachus chay quiquinpacha thañicuskantawan willacorka. ");
INSERT INTO quhNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Chanta Jesús payta nerka: —Mamáy, Diospi jap'icuskayquiraycu thañiska canqui. Allillanta ripuy, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesús parlashajtillanraj curaj runaj wasinmanta uj runa jamorka willaj: —Ususiyqueka wañupunña. Amaña yachachejta molestaychu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesusrí chayta uyarispa Jairota nerka: —Amaña manchachicuychu. Astawanpis Diosllapi jap'icuy. Ususiyqueka thañiska canka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Chayaspa chay curajpa wasinman yaycorka. Sakellarkataj Pedrota, Juanta, Jacobotawan paywan yaycunancuta wawaj tatanta mamantawan ");
INSERT INTO quhNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tucuy runas wawamanta phutiywan manchayta wakasharkancu. Jesusrí nerka: —Amaña wakaychejchu. Cay wawaka mana wañuporkachu. Manachayrí puñushan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Paycunataj wawaka wañuska caskanta yachaspa, Jesusta asipayarkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jesusrí wawata maquinmanta jap'ispa wajyarka: —Imillita, jatarimuy, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Imillitataj wañuymanta causarimporka. Chay quiquinpacha jataricorka. Jesusri camacherka payman miqhunata konancuta. ");
INSERT INTO quhNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tatasnin mayta t'ucorkancu. Jesustaj paycunata camacherka ama ni pimanpis chayta willanancuta. ");
INSERT INTO quhNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús chunca iscayniyoj cachasninta tantaycorka. Paycunamantaj atiyta korka tucuy supaycunata kharkonancupaj tucuy onkoycunatapis thañichinancupaj. ");
INSERT INTO quhNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Paycunata cacharka Dios camachin, chaymanta willaranancupaj, onkoska runasta thañichinancupajtaj. ");
INSERT INTO quhNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jesús paycunata nerka: —Ñanniyquichejpaj ama ni imatapis apacuychejchu. Nitaj c'aspita purinayquichejpaj, nitaj wayakata nitaj t'antata nitaj kolketa nitaj iscay camisastapis apacuychejchu. ");
INSERT INTO quhNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Mayken wasillamanpis wajyaricusonkachej chayka, chaypi cacuychej llajtamanta llojsipunayquichejcama. ");
INSERT INTO quhNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Runas mana wajyasojtiyquichejka chay llajtamanta llojsipuychej. Chaquisniyquichejmantataj jallp'anta thalaycarpaychej chay runaspa contrancupi. Chaywan runas yachankancu Diospa willanasninta khesachaskancuta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Chanta Jesuspa cachasnin llojsispa purerkancu ranchomanta rancho. Tucuynejpi sumaj willanasta willarasharkancu onkoska runastataj thañichisharkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Jesuspa tucuy ruwaskasninmanta uyarispa camachej Herodes ni imata yuyayta atisharkachu. Waquinmin nisharkancu: “Juan causarimpun wañuymanta”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Waquintaj nisharkancu: “Elías ujtawan riqhurimun”, nispa. Ujcuna nishallarkancutaj: “Unay willajcunamanta ujninchá causarimpun”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodesrí nerka: —Noka quiquiy Juanpa umanta khorucherkani. Cunan ¿pitaj cay runa pimanta tucuy cayta uyarishanirí? Herodeska Jesusta ricuyta munasharkapuni. ");
INSERT INTO quhNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jesuspa cachasnin cutimuspa tucuy ruwaskasnincumanta payman willarkancu. Payri paycunata nerka: —Jacu rina nokanchejpuralla wajnejman, —nispa. Betsaida llajtanejman rerkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Chaynejman riskancuta yachaspa, ashqha runas Jesusta khaterkancu. Jesús paycunata ricuspa nerka: —Cusicuni jamuskayquichejmanta, —nispa. Paycunamantaj Dios munacuywan camachin, chaymanta parlasharka. Onkoska runastapis thañichisharka. ");
INSERT INTO quhNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ch'isiyashajtintaj yachacojcunanka kayllaycuspa Jesusta nerkancu: —Cachapullayña cay ashqha runasta. Richuncu kaylla ranchosman wasisman miqhunata puñunata masc'anancupaj ch'in pampapi caskanchejraycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesusrí paycunata nerka: —Kancuna paycunata miqhuchiychej, —nispa. Paycunataj cuticherkancu: —Phishka t'antaswan iscay challwitasllapiwan capuwaycu. Tucuy cay runaspaj miqhunata rantej rinaycutachu yuyawaj, nipunichá, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Chaypimin carkancu phishka warankajina, kharislla yupaska. Jesusrí yachacojcunanman nerka: —Cay runasta tiyaycuchiychej t'aka t'akallata phishka chuncamanta phishka chunca, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ajinata ruwarkancu. Tucuytaj tiyacorkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Chanta Jesuska chay phishka t'antasta iscay challwitastawan maquisninpi jap'erka. Janaj pachata khawarispataj Diosman graciasta korka t'antasmanta challwitasmantawan. Chaycunata partispataj yachacojcunaman jaywasharka paycuna runasman konancupaj. ");
INSERT INTO quhNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tucuy runastaj miqhuspa sajsacorkancu. Yachacojcunataj chay puchoj partiska miqhunasmanta chunca iscayniyoj canastas junt'ata okharerkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Uj cuti Jesús sapallan Dioswan parlacusharka. Kayllanpitaj yachacojcuna casharkancu. Paycunata Jesús taporka: —Ashqha runas nokamanta parlaspa ¿pi caskaytataj nincu? ");
INSERT INTO quhNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Yachacojcunataj payman cuticherkancu: —Waquin nincu, bautizaj Juan. Waquin nincu, Elías. Waquinri, ujnin Diospa unay willajcunanmanta, chaychá causarimpuskan, nisuncu. ");
INSERT INTO quhNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jesús paycunata tapullarkataj: —Kancunarí, ¿pi caskaytataj ninquichej? Pedrotaj cuticherka: —Kan Diospa ajllaskan Cristomin canqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Chanta Jesús paycunata sinch'ita camacherka ama pimanpis chayta willanancuta. ");
INSERT INTO quhNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Paycunaman willarka: —Noka, Diospa cachaska Runan, anchata ñac'arinay tiyan Diospa munayninmanjina. Israel curajcunawan yupaychana-wasipi curajcunawan yachachejcunapiwanpis, tucuy paycuna chekatapuni nokata khesachawankancu wañuchiwankancutaj. Quinsa p'unchaymantari causarimpunay tiyan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Tucuy runasta nisharkataj: —Pichus munan yachacojniy cayta nokawan riytapis chayka, sakenan tiyan quiquin munayninta. Chaywanpis sapa p'unchay nokaraycu pay quiquinpi muchunan tiyan. Nokatataj casunawanpuni tiyan wañunancama. ");
INSERT INTO quhNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Chekatapuni pillapis causayninta payllapaj wakaychacuyta munajka mana wiñay causayniyojchu canka. Pillapis causayninta cay pachapi chincananta sakejka nokata casuwaskanraycu chayka, chekatapuni payka wiñay causayniyoj canka. ");
INSERT INTO quhNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Reparaychej: Sichus uj runa cay pachantintapis jap'inman pay quiquinri wiñaypaj chincapunmantaj chayka ¿ima allin canman paypajrí? ");
INSERT INTO quhNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Pillapis nokamanta niskasniymantapis p'enkacunman chayka, nokapis cutimuspa paymantaka p'enkacullasajtaj. Noka, Diospa cachaska Runanka, cutimusaj jatun atiyniywan, Tatay Diospa atiyninwan, angelesninpa atiynincuwanpis. ");
INSERT INTO quhNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Chekatapuni willashayquichej: Cunan caypi cashajcunamanta waquin mana wañonkancuchu Dios camachinanpaj jamuskanta ricunancucama, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Chayta niskantawan pusaj p'unchaymantajina Jesús orkoman rerka Dioswan parlaj. Pusarkataj Pedrota, Juanta, Jacobotawan. ");
INSERT INTO quhNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jesús Diosmanta mañacushajtin uyanpa rijch'aynin wajjinaman tucorka. P'achasninpis sumaj yuraj lliphipejjinaman tucorkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Khaway, iscay runas, Moisés Eliaspiwan, janaj pachamanta Diospa lliphipishaj atiyninwan riqhurimorkancu. Jesuspa wañuyninmanta parlanacusharkancu, chayta Jerusalenpi junt'anantaña Diospa yuyaskanmanjina. ");
INSERT INTO quhNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedrotawan paywan cajcunatawantaj puñuy atiparka. Puñushaskancumanta rijch'arispataj Jesuspa lliphipej c'anchayninta ricorkancu iscay runastawan paywan sayashajta. ");
INSERT INTO quhNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Chay runas Jesusmanta ripunayashajtincu Pedro Jesusta nerka: —Yachachejníy, sumajta caypi cashanchej. Ruwaycuman quinsa ch'ujllasta, ujta kanpaj, ujta Moisespaj, ujtataj Eliaspaj, —nispa. Pedroka chayta nerka mana yachaspa imatachus parlananta. ");
INSERT INTO quhNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Parlashajtin uj phuyu riqhurimuspa paycunaman uraycamorka. Yachacojcuna phuyupi caspa manchachicorkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Phuyumanta uj parlamushajta uyarerkancu: —Caymin ajllaska Wawayka. Payta uyariychej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Chay parlamojta uyarishaspataj Jesusta sapallanta ricorkancu. Ch'inlla cacorkancu manataj ni piman ricuskancuta willarkancuchu chay p'unchaycunapi. ");
INSERT INTO quhNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","K'ayantin orkomanta uraycamojtincuña ancha ashqha runas Jesuswan tincorkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Chay q'isqui runasmanta ujnin khaparerka: —Yachachejníy, mañacuyqui wawayta thañichinapaj khawaripunawayquita pay sapan waway caskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Supay payta jap'ishanpuni. Ujllata wawata khaykeyachin. Supaytaj payta t'ucuchin. Phosokojina llausa surun siminmanta. Supay payta chokaycachachishanpuni manataj payta munanchu sakeyta. ");
INSERT INTO quhNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ñapis yachacojcunayquita mañarkaniña supayta kharkonancuta. Paycunarí mana aterkancuchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesustaj nerka: —¡Ay, Diospi mana jap'icoj nitaj cheka yuyayniyoj runas! ¡Mayc'ajcamataj kancunawan casaj! ¡Mayc'ajcamataj kancunata muchuskayquichej! Chaymanta jovenpa tatanman cuticherka: —Cayman pusamuway wawayquita, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Joven kayllamojtintaj supay pampaman urmachispa t'ucuwan jap'iycucherka. Jesusri supayta sinch'iwan c'amerka, joventataj thañicherka. Chanta joventa tatanman koporka. ");
INSERT INTO quhNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tucuy runastaj manchaytapuni t'ucusharkancu Diospa may jatun atiyninmanta. Tucuy runas Jesuspa ruwaskasninmanta t'ucushajtincutaj payka yachacojcunanta nerka: ");
INSERT INTO quhNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Cay niskayta yuyayniyquichejpi sumajta jap'icuychej: Noka, Diospa cachaska Runanka, sajra runaspa maquisnincuman jaywaskaña caj rishani, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Yachacojcunari mana yacharkancuchu Jesuspa niskanka imatachus niyta munaskanta. Pacaska carka yuyaynincumanta, chayraycu mana repararkancuchu. Chaywanpis chay niskanmanta payta tapuyta manchachicorkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Chanta yachacojcunaka churanacuyta kallarerkancu maykenchus paycunamanta aswan curaj cananmanta. ");
INSERT INTO quhNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesusrí yacharka sonkosnincupi tanteyaskancuta. Chayraycu uj wawata jap'ispa ladonpi sayacherka. ");
INSERT INTO quhNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Chantaka yachacojcunanman nerka: —Nokapi jap'icojka cayjina wawata, “Walejta jamunwanqui”, nispaka noka quiquiyta nishawan. Nokata, “Walejta jamuwanqui” niwajka, cachamuwajniytapis nishallantaj. Tucuy kancunamanta aswan pisipaj khawacoj cajmin chekamanta curaj cajka cashan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Chanta Juan Jesusta nerka: —Yachachejníy, ricorkaycu uj runata atiyniyoj sutiyquiwan supaycunata kharkoshajta. Mana kanta nokaycujina khatej caskanraycu payta jarc'ayta kallarerkaycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús nerka: —Amaña jarc'aychejchu payta. Mana contrayquichejpi cajka kancunaj allinniyquichejpaj cashan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Dios janaj pachaman Jesusta ujtawan pusanan carka. Chay p'unchaycuna kayllamojtin Jesús ajinata tucuy sonkowan yuyacorka Jerusalenman rinanta. ");
INSERT INTO quhNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Paypa ñaupakentataj willajcunata cacharka. Rispataj yaycorkancu Samariapi ujnin llajtaman Jesuspaj waquichipunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Samaritanocunarí Jesús chaypi khepacunanta mana munarkancuchu Jerusalenman rishaskanta sut'ita reparaskancuraycu. Jerusalenpi tiyacojcunawantaj chejniskas carkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Iscay yachacojcunataj, Juan Jacobopiwan, chayta ricuspa Jesusta nerkancu: —Señorníy ¿munawajchu janaj pachamanta ninata uraycuchimunanchejta cay runasta ruphaycuchinapaj? Elías ruwarka, chayjinata, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Chanta Jesús paycunaman cutirispa c'amerka: —Mana yachanquichejchu sonkoyquichejpi yuyaskayquichejka maymantachus caskanta. ");
INSERT INTO quhNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Noka, Diospa cachaska Runanka, runaspa causaynincuta cacharinaypaj jamorkani manataj paycunata tucuchinaypajchu, —nispa. Chaymanta waj llajtaman riporkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Rishajtincutaj, uj runa Jesusta ñanpi nerka: —Kanwan cusca risaj maymanchá rejtiyquipis, chayman, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesustaj cuticherka: —Atojcuna jusc'usniyoj, phawashaj p'iskospis thapasniyoj cancu. Noka, Diospa cachaska Runanrí, mana wasiyojchu cani, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Waj runata Jesús nerka: —Jamuy, yachacojniy cay, —nispa. Payrí nerka: —Señorníy, ñaupajta sakellawayraj tatayta p'ampamunayta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesustaj cutichispa nerka: —Wañuskacuna wañuskasnincuta p'ampamuchuncu. Kanrí, riy, Dios camachin, chaymanta willarallaypuni, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ujnintaj Jesusta nerka: —Señorníy, khatiskayqui yachacojniyqui canaypaj. Ñaupajtaka sakellaway wasiypi cajcunamantaraj cacharpayacamunayta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesusrí payta nerka: —Waquin runas munashancu llanc'ayta Dios tucuyta camachinanpaj, manataj quiquin munaynincuta sakencuchu. Waj ladoman khawaspa surc'aj runaka mana allintachu surc'an. Ajinallataj quiquin munaynillanta ruwajka mana allinchu llanc'an Dios tucuyta camachinanpaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Chay khepata Señorka uj kanchis chunca runastawan churarka. Paycunatataj ñaupakenta cacharka iscay iscayta sapa llajtaman ranchoman rej risharka, chaycunaman. ");
INSERT INTO quhNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jesuska paycunata nisharka: —Chekapuni runaska uj jatun pokoska trigo chajrajina cancu. Llanc'ajcunarí chayta ruthunancupajka ancha pisis cancu. Chayraycu mañacuychej Diosmanta llanc'ajcunata uskhayta chajranman cachamunanta. Tucuy caytaka paymin camachin. ");
INSERT INTO quhNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Riychej, cayta reparaspa: Noka kancunata cachashayquichej oveja uñastajina atojcuna chaupita. ");
INSERT INTO quhNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Amataj apaychejchu ni kolke churanata, ni wayakata nitaj ojot'asta. Puriyniyquichejpi napaycuspa ama khepacuychejchu. ");
INSERT INTO quhNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Mayken wasillamanpis wajyaskas canquichej chayka, napaycuspa ñaupajtaka niychej: “Cay wasipi tiyacoj runaska Diosman allinyaskas cachuncu”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Sichus chay wasipi tiyacoj runa munan Diosman allinyacuyta chayka, napaycuskayquichejka paywan caconka. Manachayrí napaycuskayquichejka kancunaman cutimpusonkachej. ");
INSERT INTO quhNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Wajyaskas canquichej chay wasillapi cacuychej. Chaypi tiyacoj runaspa capuskanmanta miqhuychej ujyaychejtaj. Llanc'askancumanta llanc'ajcunamanka miqhunancupaj konancupuni tiyan. Uj wasillapi tiyacuychej, amataj wasimanta wasi purishaychejchu. ");
INSERT INTO quhNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Uj llajtaman yaycojtiyquichej runas: “Walejta jamunquichej”, nisojtiyquichejka, chaypi cacullaychej. Miqhuychej jaywasuskayquichejtaka. ");
INSERT INTO quhNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Thañichiychej chaypi onkoska cajcunata. Niychejtaj runasman: “Cunan Dios caypiña cashan camichinanpaj”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","May llajtaman yaycojtiyquichej runas mana: “Walejta jamunquichej”, nisojtiyquichejka, llojsiychej. Jatun ñancunancuman rispa chay runasta nimuychej: ");
INSERT INTO quhNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Llajtayquichejpa jallp'anta chaquisniycumanta contrayquichejpi thalarparishaycu. Cayta ruwaycu reparanayquichejpaj cunan Dios camachinanpaj kayllayquichejpi caskanta khesachaskayquichejtataj”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yachacojcunáy, niyquichej, Diospa c'ajaj phiñacuynin p'unchaypeka astawan ñac'arichinanta chay llajtapi tiyacojcunata Sodoma llajtapi tiyacojcunamanta niskaka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Chaywanpis Jesús nerka: —¡Ay, phutiy, ari, kancuna Corazín llajtapi tiyacojcunapajka! ¡Ay, phutiy, ari, kancuna Betsaida llajtapi tiyacojcunapajpis! Dios jatun ruwanasta llajtasniyquichejpi ruwarka. Sichus Tiro llajtapi Sidón llajtapiwan chay quiquin ruwanasta ruwanman carka chayka, unayña paycunaka sajra ruwanasnincuta sakencuman carka. Yana p'achasnincuta churacuspa ushphata umasnincuman khallaycucuncuman carka. Ajinapi runasman ricuchincuman carka sajra ruwaskasnincumanta mayta phuticuskancuta. ");
INSERT INTO quhNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Diospa c'ajaj phiñacuynin p'unchaypiri kancunata astawan ñac'arichenka Tiro llajta Sidón llajtawan tiyacojcunamanta niskaka. ");
INSERT INTO quhNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","¡Kancunapis Capernaum llajtayojcuna, yuyanquichejchu jakay p'unchaypi janaj pachacama okhariskas curajpaj khawaskas canayquichejta! Astawanka uqhu pachacama uraycuchiskas canquichej. ");
INSERT INTO quhNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Chaywanpis Jesús chay kanchis chunca runasta nerka: —Kancunata uyarejka nokata uyariwan. Kancunata khesachajri nokata khesachawan. Nokata khesachawajrí cachamuwajniyta khesachallantaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Chay kanchis chunca yachacojcunantaj cusiywan Jesusman cutimuspa nerkancu: —Señorníy, supaycunapis casuwarkaycu paycunata sutiyquipi camachejtiycoka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesustaj paycunaman cuticherka: —Arí, khawarkani supay Satanasta janaj pachamanta urmaycamushajta lliuj-lliujtajina. ");
INSERT INTO quhNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Khawaychej supay Satanaspa tucuy atiyninta atipanayquichejpaj atiyta korkayquichej. Catarista chayrí atoj-atojcunatapis saruwajchej, ajinata sajra runasta atiyniywan atipanquichej. Manataj ni imapis imanasonkachejchu. ");
INSERT INTO quhNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Astawanpis ama cusicuychejchu supaycuna kancunata casususkayquichejmantaka. Astawanka cusicuychej sutisniyquichej janaj pachapi kelkaskasña caskanmanta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Chay quiquinpacha Santo Espíritu Jesuspa sonkonman jatun cusiywan junt'acherka. Jesustaj nerka: —Tucuy cay pachata janaj pachatawan Camachej Tatáy, agradececuspa yupaychayqui. Imaraycuchus yuyaskayquita pacarkanqui ancha yachayniyoj runasmanta. Chaytarí wawajina llamp'u sonkoyojcunaman sut'incharkanqui. Arí, Tatáy, ajinata ruwaskayquipi cusicunqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nerkataj: —Tatay Dios nokaman tucuy yachayta kowarka. Paylla noka Wawantaka rejsiwan. Tatayta noka Wawallan rejsini. Pimanchus noka Wawan munani Tatayta rejsichiyta, chay runalla paytaka rejsin, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yachacojcunanman cutirispataj paycunallata nerka: —Ricushaskayquichejta ricuspa may cusiskas canquichej. ");
INSERT INTO quhNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Niyquichej, ashqha unay willajcuna camachejcunapiwan ricushaskayquichejta ricuyta munaskancuta. Manataj ricorkancuchu. Uyarishaskayquichejta uyariyta munarkancu. Manataj uyarerkancuchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Chaypitaj carka uj israel yachachej. Payka yachayta munasharka Jesuspa yachachiskasnin chekachus manachus caskanta. Jesusta taporka: —Yachachej ¿ima allin cajta ruwanay tiyan wiñay causayniyoj canaypaj? ");
INSERT INTO quhNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús cuticherka: —Diospa camachiskasninpi ¿imataj kelkaska cashan? Leejtiyqui ¿ima niytataj munan? ");
INSERT INTO quhNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Chay yachachejtaj cuticherka: —Diospa camachiskasninpi nin: “Señor Diosniyquita munacunayqui tiyan tucuy sonkoyquiwan, tucuy causayniyquiwan, tucuy callpayquiwan, tucuy yuyayniyquiwanpis. Runa-masiyquitapis munacuy kan quiquiyquitajina”, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesustaj payta nerka: —Cutichiwaskayqueka chekamin. Chayta ruwashaypuni, wiñay causayniyojtaj canqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Chay yachachejrí tapuskan chekan caskanta ricuchiyta munarka. Chayraycu Jesusta nerka: —¿Pitaj runa-masiyrí? ");
INSERT INTO quhNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Cutichispataj Jesús nerka: —Uj israel runa Jerusalén llajtamanta Jericó llajtaman uraycusharka. Suwas paytaka muyuycarpaspa jap'iycorkancu. Paycuna p'achasninta lluch'uspataj makaycorkancu. Ripuspataj runataka wañuskatajina sakerkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ajinataj yupaychana-wasipi uj ruwanayoj chay ñanllatataj uraycusharka. Chay wijch'uska runata ricuspa carunejta muyurerka. ");
INSERT INTO quhNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ajinallatataj yupaychana-wasipi uj yanapajpis chayman chayarka. Wijch'uska runata ricuspataj carunejta muyurillarkataj. ");
INSERT INTO quhNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Chanta chejniska samaritanocunamanta uj runarí rispa wijch'uska runa casharka, chayman chayarka. Paytaj ricuspaka mayta qhuyarka. ");
INSERT INTO quhNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Payman kayllaspa jampiwan jampiycuspataj nanaskasninta wataycorka. Quiquin uywanman payta llok'achispa pusarka puñuna wasiman. Chaypi payta sumajta khawarka. ");
INSERT INTO quhNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Chay samaritano k'ayantin llojsipushaspa iscay p'unchay llanc'askanmantajina kolketa wasiyojman korka. Nerkataj: “Sumajta khawaripuway cay runata. Sichus astawan gastanqui chayka, cutimuspa noka kopuskayqui”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Chanta Jesús chay yachachejta taporka: —Chay quinsamanta suwawan jap'ichicojpa runa-masenka ¿maykennincu caskantataj yuyanqui? ");
INSERT INTO quhNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Yachachejtaj cuticherka: —Wijch'uska runata qhuyarka, chay runa, —nispa. Jesustaj payta nerka: —Arí, paypuni carka. Kanpis quiquillantataj qhuyaspa ruwamuy, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús yachacojcunanwan rishaspa uj llajtaman yaycorka. Chaypi uj warmi, Marta sutiyoj, Jesusta wasinman wajyarka. ");
INSERT INTO quhNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Paypa ñañan Mariataj Jesuspa chaquisnin kayllapi tiyacuspa willaskanta uyarisharka. ");
INSERT INTO quhNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martarí miqhunata waquichishaskanwan atipachicusharka. Chanta jamorkospa Jesusta nerka: —Señorníy, reparay ñañay ruwanata sapallayman sakeshawaskanta. Nipuway, ari, ruwananpi yanapanawanta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Señortaj payman cuticherka: —Kan, Marta, ashqha ruwanaswan atipacuspa musphachiskataj tucuchishanqui. ");
INSERT INTO quhNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Uj sapallanmin canan cashan. Mariaka allin cajta ajllarka. Cay ajllaskanka mana paymanta khechuskachu canka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Uj lugarpi Jesús Diosmanta mañacusharka. Tucushajtintaj yachacojcunanmanta ujnin nerka: —Señorníy, Diosmanta mañacuyta yachachiwaycu. Juanpis yachacojcunanta Diosmanta mañacuyta yachacherka, ajinata, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Chayraycu Jesús paycunata nerka: —Diosmanta mañacushaspaka niychej: Janaj pachapi caj Tataycu, tucuy runas sutiyquita yupaychachuncu. Mayta munaycu tucuyta camachinayquita. Janaj pachapi munayniyqui ruwacushan, ajinallataj cay pachapipis ruwacuchun. ");
INSERT INTO quhNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Causanaycupaj miqhunaycuta kowaycupuni sapa p'unchay. ");
INSERT INTO quhNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Juchasniycuta khechuspa perdonawaycu; nokaycupis perdonaycu tucuy juchata nokaycuman ruwajcunata. Llaquiycunapi callpachawaycu ama juchallicunaycupaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Chaywanpis paycunata nerka: —Kancunamanta ujniyquichej chaupi tutata amigonpa wasinman rispa ninman: “Amigóy, quinsa t'antasta ayniriway. ");
INSERT INTO quhNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Uj amigoy ñan puriymanta cunallan chayamun wasiyman. Manataj ni imay canchu payman jaywarinaypaj”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Amigoyquitaj wasi uqhumanta cutichispa nimunman: “Amaña molestawaychu. Puncoka tutapaj sumaj wisk'askaña cashan. Wawasniytaj puñushancu nokawan. Mana atinichu jatarimuyta kosunaypaj”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Chekatapuni chay runa manapis jatarinmanchu t'antata kosunanpaj amigon caskayquiraycu. Mayta mañacuskayquiraycurí jatariconka imatachus mañacuskayquitataj kosonka. ");
INSERT INTO quhNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Astawanpis niyquichej: Mañacullaychejpuni, Diosmin kosonkachej. Masc'allaychejpuni, Diosmin tarichisonkachej. Wajyallaychejpuni, Diostaj puncuta kancunaman quicharisonkachej. ");
INSERT INTO quhNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Sapa uj mana sakespa mañacojka jap'inpuni; mana sakespa masc'ajtaj tarinpuni; mana sakespa wajyajmanpis puncoka quichariconkapuni, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Jesús nillarkataj: —Wawayqui t'antata mañacusojtin ¿payman uj rumita kowajchu? Chayrí, challwata mañacusojtin ¿paymanka uj catarita jaywawajchu? ");
INSERT INTO quhNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Chayrí, runtuta mañacusojtin ¿uj atoj-atojta jaywawajchu? ");
INSERT INTO quhNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nipunichá. Kancuna tatas, pantaj runas cashaspapis, yachanquichej allin cajta koyta wawasniyquichejman. May astawanraj Dios Tatayquichejka janaj pachamanta Santo Espirituta konka paymanta mañacushajcunaman, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesús supayta uj runamanta kharkosharka. Chay runaka supayniyoj caskanraycu upa carka. Paymanta supay llojsejtintaj upaka parlarka. Runastaj parlaskanmanta t'ucorkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Waquincunarí nerkancu: —Jesuska supaycunata kharkoshan curaj caj supay Beelzebúj atiyninwan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Waquintaj mana creeskancuchu Dios payta cachamuskanta. Chayraycu Jesusmanta mañasharkancu chayta ricuchinanta, uj janaj pachamanta t'ucunata ruwaspa. ");
INSERT INTO quhNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesusrí yuyaskasnincuta yachaspa paycunata nerka: —Uj llajtapi tiyacojcuna paycunapura makanacojtincoka llajtancu chincapun; uj familiapis chhokonacuspa tucucun. ");
INSERT INTO quhNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ajinallataj Satanaswan cashan. Camachisnillantaj paywan makanacojtincoka atiynin tucuconka. Cayta niyquichej Beelzebúj atiyninwan supaycunata kharkoskayta niskayquichejraycu. ");
INSERT INTO quhNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ajinapis canman chayka, khatejcunayquichej ¿ima atiywantaj supaycunata kharkoncurí? Paycuna sut'itaka ricuchisonkachej. ");
INSERT INTO quhNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Astawanrí noka Diospa atiyninnejta supaycunata kharkoskayka niyta munan Dios kancuna uqhupiña caskanta camachinanpaj, —nispa. Nerkataj: ");
INSERT INTO quhNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","—Uj callpayoj runa makanaswan sumaj waquichin wasinta. Ajinapi khawajtin capuynenka sumaj wakaychaska cashan. ");
INSERT INTO quhNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Uj astawan callpayoj runachus payman jamuspa atiparpan chayka, atinicuska makanasninta khechun. Capuynintataj chay callpayojka amigosninwan jaywanaycucun. Nokapis ajinallatataj supay Satanasta atipaspa millay supaycunata kharkoshani. ");
INSERT INTO quhNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","‘Mana nokaman sayacojka contraypi churacun. Mana nokata yanapawajtaj jarc'awan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jesús cay quiquinchanawan parlarka: —Runamanta millay supaychus llojsin chayka, ch'aquinejpi khasillata purin samariyta masc'aspa. Mana tarispataj nin: “Llojsimorkani, chay runaman cutiycapusaj”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Supayka cutimuspa chay runata taripan uj pichaska sumaj allinchaska ch'usaj wasitajina. ");
INSERT INTO quhNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Chanta rispa paymanta aswan sajra kanchis supaycunata pusamun. Chaycuna yaycuspa runapi tiyacuncu. Ajinapi chay runaka khepata aswan millayman tucupun ñaupajmanta niskaka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Chay imasta Jesús parlashajtin uj warmi ashqha runaspa chaupincumanta khaparerka: —¡May cusicuyniyojmin onkocusorka ñuñuchisorkataj, chay warmeka! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesusrí nerka: —Cusicuyniyojllataj cancu Diospa niskanta uyarej casojcunaka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ashqha runas payman yapacamushajtincu, Jesús kallarerka parlayta: —Cunan p'unchay runaska sajracuna caspa uj ricuchinata mañashancu creenawancupaj. Diospa unay willajnin Jonaswan ruwacuskanjina chaylla cashan. ");
INSERT INTO quhNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jonaska uj ricuchina carka Nínive llajtapi tiyacoj runaspaj. Ajinallataj noka, Diospa cachaska Runanpis, uj ricuchina casaj cunan p'unchay runaspaj. ");
INSERT INTO quhNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Sabá llajtata camachej warmeka ancha carumanta jamorka Salomonpa yachayninta uyarej. Reparaychej, kancunawan caypi cashani, Salomonmanta aswan curaj. Chayraycu Diospa c'ajaj phiñacuynin p'unchaypi chay camachej warmi cunan p'unchay runasta juchachanka. ");
INSERT INTO quhNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ninivepi tiyacojcuna Jonaspa willaraskanta uyarispa juchasnincuta sakerkancu Diosman cutirinancupaj. Reparaychej, caypi cashani Jonasmanta aswan curaj. Chayraycu Diospa c'ajaj phiñacuynin p'unchaypi Ninivepi tiyacojcuna cunan p'unchay runasta juchachankancu. ");
INSERT INTO quhNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","‘Ni pipis uj c'anchayta jap'ichispa pacaycunchu; nitaj wich'i uraman churanchu. Astawanpis pataman churan yaycojcuna c'anchayta ricunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ñawiyqui c'anchayllawan ricun cuerpopaj. Ajinallataj sonkoyquipis Diospa c'anchayninwan reparan. Sichus llimphu sonkoyoj canqui chayka, tucuy causayniyqui c'anchayniyojmin. Sajra sonkoyoj canquirí tucuy causayniyqui lakhapachamin. ");
INSERT INTO quhNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Pajtataj Diospa cheka c'anchaynin causayniyquipi mana cashanmanchu. ");
INSERT INTO quhNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tucuy causayniyqui chay c'anchaywan junt'a cajtin, mana ni ima sajra yuyay kanpi canchu. Uj lliphipej c'anchaypis c'anchashasunquimanjina, Diospa cheka yachachiynenka c'anchasunqui, —nerka Jesus. ");
INSERT INTO quhNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesús parlashajtin uj fariseo paywan miqhunanpaj wajyarka. Ajinamanta fariseoj wasinman yaycuspa miqhoj tiyaycucorka. ");
INSERT INTO quhNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Israelcunaj mayllacunancu yachacuskancumanjina maquisninta mana mayllacuspa Jesús miqhusharka. Chayta ricuspa fariseoka t'ucorka. ");
INSERT INTO quhNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jesusrí payta nerka: —Kancuna fariseoska vasota chuwata jawallanta mayllanquichej. Sonkoyquichejrí munapayaywan sajra yuyaywan junt'a cashan. ");
INSERT INTO quhNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Mana yuyayniyojcuna! Dios jawanta ruwarka uqhunta payllataj ruwarka. ¿Chayta manachu reparanquichej? ");
INSERT INTO quhNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Wajcha runasman tucuy sonkowan qhuyaspa koychej. Ajinapitaj tucuy ima llimphu cashan kancunapaj. ");
INSERT INTO quhNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","‘¡Phutiy, ari, kancuna fariseospajka! Sapa chuncamanta ujta Diosman koshanquichej. Chayta koshanquichej yerbabuenamanta, rudamanta, chayjina juch'uy imasmantawanpis. Astawanpis runasman chekanta ruwayta Diosta munacuytawan konkapunquichej. Chaycunata ruwanayquichej carka, juch'uy imastapis ama konkaspalla. ");
INSERT INTO quhNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","‘¡Phutiy, ari, kancuna fariseospajka! Tantacuna-wasispi curajcunaj tiyanasnincupi tiyacuyta munanquichej. Plazaspi sumajta napaycuchicuyta munallanquichejtaj. ");
INSERT INTO quhNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","‘¡Phutiy, ari, kancuna fariseospajka! Pacaska aya p'ampanasjina canquichej. Runaska mana yachaspa chay ismuyniyquichej patata purincu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Chaymanta israel yachachejcunamanta uj cutichispa Jesusta nerka: —Yachachej, chayta nispaka nokaycutapis p'enkachillawaycutaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesusrí nerka: —¡Phutiy, ari, kancuna israel yachachejcunapajka! Kancuna yachachinasniyquichej llasa k'epistajina waj runaspaj waquichinquichej. Chaytataj camachinquichej runasta ruwanancuta k'epistajina k'epirichispa. Kancunarí chay camachiskasta ni casojllapis churacunquichejchu. ");
INSERT INTO quhNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","‘¡Phutiy, ari, kancunapajka! Diospa unay willajcunanpa p'ampanasnincuta c'achachashanquichej. Tatasniyquichejtaj chay willajcunata wañucherkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Chay c'achachaskayquichejwanka ricuchishanquichej tatasniyquichejpa ruwaskancuwan ujlla caskayquichejta. Paycunaka Diospa willajcunanta wañucherkancu; kancunataj p'ampanasnincuta c'achachanquichej. ");
INSERT INTO quhNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","‘Chayraycu Dioska yachayninpi nin: “Paycunaman cachasaj willajcunaytawan cachasniytawan. Paycunamanta waquinta wañuchenkancu, waquintataj ñac'arichenkancu”. ");
INSERT INTO quhNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Cay pacha kallaricuymantapacha Diospa unay willajcunanmanta ashqhas wañuchiskas carkancu. Tucuy chay wañuchiskacunamanta cay p'unchay runas juchachaskas cankancu. ");
INSERT INTO quhNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Sumajta reparanayquichejpaj niyquichej: Abel sutiyojmanta Zacariascama cay p'unchay runas Diosman cuentata konancu tiyan. Zacariaska yupaychana-wasej ñaupakenpi wañuchiska carka. ");
INSERT INTO quhNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","‘¡Phutiy, ari, kancuna israel yachachejcunapajka! Diosta rejsinancupaj yachachinasta runasmanta pacarkanquichej. Kancuna quiquiyquichejpis Diosta rejsej mana churacorkanquichejchu. Diosta rejsiyta munajcunatapis jarc'arkanquichej, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesús wasimanta llojsiporka. Israel yachachejcuna fariseospiwanka mayta phiñacorkancu paymanta. Kallarerkancutaj tucuy laya tapunasta tapuyta parlaskanpi pantachinancupaj. ");
INSERT INTO quhNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Cazadorcuna jap'iycunancupaj watekancu, ajinata sumajta uyarisharkancu Jesusta parlaskanpi jap'iycunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Chaycamataj waranka waranka runas Jesusman tantacorkancu sarunacunancucama. Ajinapi Jesuska yachacojcunanman ñaupajta parlayta kallarerka. Nerkataj: —Wakaychacuychej fariseospa puraj uya caynincumanta. Chay puraj uyaka t'anta pokochina levadurajinamin. ");
INSERT INTO quhNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tucuy sumaj khataska cajpis k'ala khataraska canka. Pacaska cajtaj sut'inchaska canka. ");
INSERT INTO quhNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Arí, lakhapi parlaskayquichejka c'anchaypi uyariska canka. Wasi c'uchupi runaj ningrillanman chhichiskayquichejpis ashqha runasman khapariska canka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yachacojcunanta Jesús nerka: —Munacuskasníy, niyquichej ama ni jayc'aj manchachicunayquichejta cuerpollata wañuchejcunataka. Wañuchiskancumanta astawanka mana ni imatapis ruwancuñachu. ");
INSERT INTO quhNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Noka niskayquichej pita manchachicunayquichej caskanta. Diosta manchachicuychej. Payka causayta khechuspa wiñay ninaman wijch'unanpaj atiyniyojmin. Chayraycu niyquichej: Diosta manchachiycuychej. ");
INSERT INTO quhNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","‘Runas phishka phichitanca p'isketusta vendencu iscay phatitaspi. Chaywanpis cay phichitanquitasmanta Dios mana konkapunchu. ");
INSERT INTO quhNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kancunarí ashqha phichitanquitasmantaka may astawan yuyanarajmin canquichej. Umayquichejpi chujchaspis ujmanta uj yupaskas cancu. Amaña manchachicuychejchu. ");
INSERT INTO quhNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","‘Chaywanpis kancunata niyquichej: Pillapis runaspa ñaupakencupi nokaj camachiy caskanta willacun chayka, nokapis paymanta willallasajtaj. Noka, Diospa cachaska Runan, paymanta angelesninpa ñaupakencupi camachiy caskanta willasaj. ");
INSERT INTO quhNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Runaspa ñaupakencupi mana camachiychu caskanta willajtaka nokapis paymanta willallasajtaj mana camachiychu caskanta Diospa angelesninpa ñaupakencupi. ");
INSERT INTO quhNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","‘Pillapis noka, Diospa cachaska Runanpa contranpi sajrata parlan chayka, parlaskanmanta perdonaska canka. Santo Espíritoj contranpi sajrata parlajrí mana perdonaskachu canka. ");
INSERT INTO quhNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","‘Tantacuna-wasiman, camachejcunaman, autoridadcunamanpis apasonkachej. Chaypacha ama chhicata manchachicuspa yuyaychejchu imaynatachus cutichinayquichejmanta chayrí imatachus ninayquichejmanta. ");
INSERT INTO quhNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Santo Espiritumin chay ratupi yachachisonkachej imatachus ninayquichej caskanta, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Chay ashqha runasmanta ujnin Jesusta nerka: —Yachachejníy, nipuway waukeyta chayakeyta t'akapunawanta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesustaj nerka: —Amigo ¿pitaj kancunapaj churawarka capuyniyquichejta t'akajta? ");
INSERT INTO quhNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Chanta nillarkataj: —Sumajta khawacuychej wakaychacuychejtaj tucuy munapayaymanta. Arí, runaka mana astawan causaytaka atinmanchu may chhica capuyniyoj cashaspapis, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Chaymantaka uj quiquinchanawan parlarka. Nerkataj: —Carka uj khapaj runa. Paypa haciendantaj may ashqhata pokorka. ");
INSERT INTO quhNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Chanta kallarerka tanteyacuyta: Mana campoy canchu pokopuwaskanta jallch'anaypaj. ¿Imanasajtajrí? ");
INSERT INTO quhNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Cayta ruwasaj. Pirwasniyta urmachispa aswan jatuchejta sayachisaj. Chaycunapitaj tucuy pokopuwaskanta tucuy capuyniytawan wakaychasaj. ");
INSERT INTO quhNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Sonkoyta nisaj: May chhica capuyniy ashqha watapaj wakaychaska cashan. Cunanka samacapusaj, miqhucusaj, ujyacusaj, cusicusajtaj, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Diosrí payta nerka: “¡Mana yuyayniyoj runa! Cunan ch'isipacha causayniyquita kopunayqui tiyan. Waquichiskasniyquita ¿pitaj jap'enkarí?” ");
INSERT INTO quhNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ajinamin cashan pay quiquinpaj khapaj capuyta tantaj runawanka. Chay runaka Diospa khawayninpi mana imayoj, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Chaywanpis Jesús yachacojcunanman nillarkataj: —Chayraycu niyquichej amaña anchata llaquicuychejchu yuyaspa imatachus causanayquichejpaj miqhunayquichejta. Amañataj anchata yuyaychejchu cuerpoyquichejmanta imawanchus p'achallicunayquichejtaka. ");
INSERT INTO quhNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Causayniyquichejka miqhunamanta astawanrajmin. Cuerpoyquichejpis p'achamanta astawanrajmin. ");
INSERT INTO quhNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Sumajta reparacuychej alkamarismanta. Paycunaka mana tarpuncuchu nitaj ruthuncuchu. Mana canchu jallch'anancu ni pirwancupis. Chaywanpis paycunataka Dios miqhuchin. Kancunarí p'iskosmanta niskaka may astawanraj canquichej Diospajka. ");
INSERT INTO quhNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Kancuna chay imasmanta anchata llaquicushajtiyquichejpis ¿uj chhica p'unchaycunatawan causayta atiwajchejchu? ");
INSERT INTO quhNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ancha pisi cajllatapis mana atispaka ¿imaraycutaj chhicata yuyashanquichej chay waj imasmanta? ");
INSERT INTO quhNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","‘Sumajta reparaychej loma t'icasmanta imaynata wiñancu. T'icaska mana llanc'ancuchu nitaj phushcancuchu. Chaywanpis niyquichej: Cay ujnin t'icajina c'achitutaka ni camachej Salomonpis, tucuy khapaj cayninwan, p'achallicorkachu. ");
INSERT INTO quhNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ajinata Dios p'achallichin khorata. Cunan p'unchay chajrapi cashancu. K'ayataj hornopi ruphachiska cankancu. ¿Manachu Dios astawanraj kancunataka p'achallichisonkachej? ¡May pisita Diospi jap'icunquichej! ");
INSERT INTO quhNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Amataj miqhunayquichejta ujyanayquichejtaka masc'aychejchu llaquicuspa. ");
INSERT INTO quhNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Cay pacha runasmin Diosta mana rejsispa tucuy cay imasta masc'aspa causancu. Dios Tatayquichejka yachanmin cay imaspi pisichicuskayquichejtaka. ");
INSERT INTO quhNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Astawanpis mayta munaychej tucuy imapi Dios Camachejniyquichej cananta. Chaymanta miqhunata p'achata ima yapasonkachej. ");
INSERT INTO quhNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Dios Tatayquichejka yuyaskanmanjina munan Camachejniyquichej cayta. Chayraycu ama manchachicuychejchu, juch'uy tropa ovejasníy. ");
INSERT INTO quhNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Capuyniyquichejta vendeychej. Qhuyacuywantaj wajcha runasman koychej. Cayta ruwaspa janaj pachapi khapaj cajta jallch'acushanquichej, manataj jayc'ajpis cayka tucuconkachu. Jakayman mana yaycuyta atinchu suwa, nitaj thutapis thutaspa tucuchiyta atinchu. ");
INSERT INTO quhNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Maypichá munaska khapayniyquichejpis cashan chaypipuni yuyayniyquichejpis cashan. ");
INSERT INTO quhNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","‘Waquichiskaspuni caychej cutimunay p'unchaypaj. ");
INSERT INTO quhNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Imaynatachus camachis camachejnincuta suyancu, ajinata kancunapis suyawaychej. Chay camachicunaka camachejnincuta casamientomanta cutimunanta suyancu. Ajinapi chayamojtincama puncuta quicharipuncu. ");
INSERT INTO quhNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Camachejka chayamuspa paycunata rijch'ashajta taripan. ¡May cusiskas chay camachicunaka! Chekamanta niyquichej: Pay waquichiconka paycunata tiyaycuchispataj miqhunata jaywanka. ");
INSERT INTO quhNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Chaupi tutatapis chayrí gallo wakaytapis chayamunman. Sichus paycunata waquichiskasta taripan chayka, may cusiskas cancu chay camachicunaka. ");
INSERT INTO quhNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Chay jawapis cayta yachaychej: Sichus uj wasiyoj yachanman ima ratutachus wasinman suwa jamunanta chayka, wakaychanman. Manataj sakenmanchu suwa jusc'uspa wasinman yaycunanta. ");
INSERT INTO quhNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kancunapis waquichiskas cashaychej. Imaraycuchus mana suyanquichej cutimunayta, chay horatamin noka, Diospa cachaska Runan, cutimusaj. ");
INSERT INTO quhNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Chanta Pedro taporka: —Señorníy, ¿cay quiquinchanataka nokallaycupajchu parlashanqui chayrí tucuy runaspajchu? ");
INSERT INTO quhNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Señortaj cuticherka: —Parlashani junt'aj, sumaj yuyayniyoj khawapojmanta. Payjinataj caychej. Patronka payta churan camachisninta camachinanpaj, horasninpi miqhuchinanpajpis. ");
INSERT INTO quhNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","May cusiska chay khawapojka patronnin cutimojtin payta taripan ruwananta ruwashajta. ");
INSERT INTO quhNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Chekamanta patronnenka tucuy capuyninta khawapunanpaj payta churanka. ");
INSERT INTO quhNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Chay camachinrí sonkonpi ninman: “Patronniyka khepaconkaraj”, nispa. Chanta camachi kharista camachi warmistawan makarayta kallarin. Kallarintaj miqhuyllata, ujyayllata machacapuytawan. ");
INSERT INTO quhNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Paypa patronnenka cutimonka mana yuyaskan horata. Chayamuspataj paytaka sinch'ita ñac'arichenka, tucuy mana casojcunawan cuscataj churanka. ");
INSERT INTO quhNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","‘Uj camachirí patronninpa munayninta yachashaspa mana waquichicunmanchu nitaj munaynintapis ruwanmanchu. Chay camacheka sinch'i ñac'arichiska canka. ");
INSERT INTO quhNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Uj camachirí mana yachaspa sajrata ruwanman. Chay camacheka pisi ñac'arichiskalla canka. Uj runa ashqhata jap'ispaka ashqhallatataj cutichipunan tiyan. Uj khawapojpis ashqha ruwanasta jap'ispaka astawan ashqha ruwanasllatataj junt'anan tiyan. ");
INSERT INTO quhNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Astawanpis Jesús nerka: —Cay pachapi ninata jap'ichej jamorkani. Mayta munayman jap'ichiskaña cashananta. ");
INSERT INTO quhNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Astawanrí sinch'i ñac'ariyman yaycunay tiyan. Chaytataj muchunay tiyan junt'anaycama. ");
INSERT INTO quhNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Yuyanquichejchu runas uqhu allillanta causacunancupaj jamuskayta? Niyquichej, mana ajinachu. Astawanrí jamuskaywan runas t'akanaconkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Chekamanta cunanmantapachaka uj wasipi phishka tiyacojcuna t'akanaconkancu. Quinsa iscaypa contranpi churanaconkancu, iscaytaj quinsaj contrancupi. ");
INSERT INTO quhNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tatan khari wawanpa contranpi churaconka, khari wawantaj tatanpa contranpi, maman warmi wawanpa contranpi, warmi wawantaj mamanpa contranpi, suegran khachunanpa contranpi, khachunantaj suegranpa contranpi churaconka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Chaywanpis Jesús ashqha runasman nerka: —Cay Israel jallp'anchejpi, inti yaycuynejmanta phuyu llojsimojta ricuytawancama ninquichej: “Sumajta paramonka”, nispa. Parantaj. ");
INSERT INTO quhNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Uramanta wayramojtintaj ninquichej: “Sinch'i koñi canka”, nispa. Ajinapunitaj tucun. ");
INSERT INTO quhNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Puraj uya runas! Cay pachata janaj pachatawan khawaspa imayna tiempochus cananta yachanquichej. Chanta ¿imaraycutaj mana reparanquichejchu imatachus Dios niyta munan cunan p'unchay ruwaskasniywan? ");
INSERT INTO quhNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Imaraycutaj kancuna quiquiyquichejka mana reparanquichejchu chekan cajmantarí? ");
INSERT INTO quhNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","‘Contrallicusojniyqui curajpaman pusasojtenka, ñanllataraj rishaspa uskhayta paywan allinyacuy. Allinyacuy amaña jatun curajman pusasunanpaj nitaj soldadoman jaywaspa carcelman wisk'achisunanpaj. ");
INSERT INTO quhNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Chekatapuni mana allinyacuwaj chayka, carcelmanta mana llojsimunquichu tucuy phatasta cutichipunayquicama, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Chaypachallataj camachej Pilato Galilea runasta wañuchiskanta ujcuna willaj jamorkancu Jesusman. Chay runaska uywasta wañuchishaskancu Diosman jaywanancupaj yachacuskancumanjina. Pilato paycunata wañuchichejtin runacunaj yawarnincu uywasnincoj yawarninwan chajrucuska. ");
INSERT INTO quhNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Chayta willajtincutaj Jesús nerka: —Ama yuyaychejchu chay runas tucuy Galilea llajta-masisnincumanta aswan juchayoj caskancuraycu ajinata wañuchiskancutaka. ");
INSERT INTO quhNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Chekamanta niyquichej: Sajra ruwaskasniyquichejta sakespa Diosman cutirinayquichej tiyan. Chayta mana ruwawajchej chayka, Dios tucuy kancunatapis tucuchillasonkachejtaj. ");
INSERT INTO quhNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Yachanquichejjina Siloé torre urmaspa chunca pusajniyoj runasta ñit'erka. Ama yuyaychejchu chay runas tucuy Jerusalenpi tiyacojcunamanta aswan juchayoj caskancutaka. ");
INSERT INTO quhNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Chekamanta niyquichej: Juchasniyquichejta sakespa Diosman cutirinayquichej tiyan. Chayta mana ruwawajchej chayka, Dios tucuy kancunatapis tucuchillasonkachejtaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Cay quiquinchanata Jesús nerka: —Uj runa higo sach'ata uva huertanpi plantarka. Chanta khepata higosta masc'aj jamuspa mana tarerkachu. ");
INSERT INTO quhNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Mana tarispataj huerta khawajninta nerka: “Khaway, quinsa watastaña cay sach'aj pokoyninta masc'aj jamuni, manataj tarinichu. Cayta c'utuspa orkhoy, khasi jallp'ata usuchishan”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Huerta khawajrí nerka: “Patronníy, cay watatawan sakellay, allaspa wanuta churanaycama. ");
INSERT INTO quhNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Chanta sichus pokoyninta konka chayka, allin canka. Sichus manapuni pokonkachu chayka, c'utuchipuy”, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Uj samacuna p'unchay tantacuna-wasipi Jesús yachachisharka. ");
INSERT INTO quhNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Yachachishajtin uj onkoska warmi yaycorka. Paytaka supay onkocherka chunca pusajniyoj watasta. Manchay c'umupacha carka manataj chekanyariyta atejchu. ");
INSERT INTO quhNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesús payta ricuspa wajyarka. Nerkataj: —Mamáy, onkoyniyquimanta cachariska canqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jesús maquisninta paypa umanman churarka. Chay quiquinpachataj chekanyaricapuspa chay warmeka Diosta yupaychayta kallarerka. ");
INSERT INTO quhNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Samacuna p'unchaypi onkoska warmita thañichiskanraycu tantacuna-wasipi camachejka phiñacorka Jesuspaj. Chay ashqha runasmantaj nerka: —Semanaka sojta p'unchaycunayojmin. Chay p'unchaycunapi runas llanc'anancu tiyan. Chayraycu chay p'unchaycunallapi jamuychej thañichiskas canayquichejpaj, amataj samacuna p'unchaypeka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Chaymanta Señorka nerka: —¡Puraj uyas! Samacuna p'unchaypi sapa ujniyquichej wacanta chayrí burrontapis cacharispa yacumanka khatinpuni. ");
INSERT INTO quhNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Cay warmeka Abrahampa ayllunmantamin. Paytaka supay Satanás chunca pusajniyoj watasta watarka. ¿Manachu samacuna p'unchaypi onkoyninmanta cachariska canan carka? ");
INSERT INTO quhNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesús cayta nejtintaj tucuy p'enkacusharkancu. Tucuy chay ashqha runastaj cusicusharkancu Jesús tucuy may sumaj imasta ruwashaskanmanta. ");
INSERT INTO quhNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Chaymanta Jesús nerka: —Willaskayquichej imaynatachus Dios camachin, chayta. ");
INSERT INTO quhNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Uj juch'uy mujuman rijch'acun. Cayta uj runa tarporka huertanpi. Mujoka llojsispa uj sach'itajina wiñarka. P'iskostaj chay sach'aj mallq'isninpi thapacharicorkancu. Ajinallataj Dios runasta camachin chayka, ashqhaman wiñan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ujtawan nillarkataj: —Dios camachishajtenka ¿imamantaj rijch'acunman? ");
INSERT INTO quhNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","T'anta pokochina levaduraman rijch'acun. Uj warmi levadurata iscay arroba trigo jac'uman churaycorka. Ajinapi tucuy masa pokospa okharicamorka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesuska llajtasta ranchosta purispa yachachisharka, Jerusalenman rishaspa. ");
INSERT INTO quhNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Uj runataj payta taporka: —Señorníy ¿pisichu cancu juchamanta cacharichicuspa wiñaypaj causajcunaka? Runasta yachachinanpaj Jesús cuticherka: ");
INSERT INTO quhNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Tucuy atiskayquichejtapuni ruwaychej Dios camachin, chayman yaycunayquichejpajka c'ullcu puncuyoj caskanraycu. Chekamanta niyquichej ashqha runas munaskancuta yaycuyta manataj atinancuta. ");
INSERT INTO quhNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Jakay p'unchay chayamojtin wasiyoj jatarispa puncuta sumajta wisk'aconka. Chaypachataj jawapi sayaspa puncuta tocayta kallarinquichej. Wajyaspataj ninquichej: “Señor, puncuta quichariwaycu”, nispa. Paytaj cutichimusonkachej: “Mana kancunataka rejsiyquichejchu. Nitaj yachanichu maymantachus caskayquichejta”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Chanta kallarinquichej niyta: “Cusca miqhorkanchej. Llajtaycupipis yachachiwarkaycu”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Paytaj nimusonkachej: “Mana yachanichu maymantachus caskayquichejta. Ripuychej nokamanta tucuy kancuna sajra ruwajcunaka”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Jakay p'unchaypi Abrahamta, Isaacta, Jacobta, tucuy unay willajcunatawan Dios camachin, chaypi cashajta ricunquichej. Kancunarí jawaman wijch'uska caspa wakanquichej phutiywan quirusniyquichejtataj c'arucunquichej. ");
INSERT INTO quhNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Inti llojsimuynejmanta, inti yaycuynejmanta, tucuynejmantapis jakaypi cankancu runaska. Dios camachin, chaypi miqhunancupajtaj tiyayconkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","¡Khawaychej! Dios camachin, chay puncu carunejpi cashajcunamanta waquin ñaupajta yayconkancu. Puncu kayllapi cashajcunamanta waquinrí khepapi cankancu, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Chaypacha waquin fariseos kayllamuspa Jesusta nerkancu: —Ripuy caymanta camachej Herodes wañuchisuyta munashaskanraycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesustaj paycunata nerka: —Nimuychej chay atojjina pantachej Herodesta: “¡Khaway! Cunan p'unchay k'ayapiwan supaycunata kharkoshani, onkoska runastataj thañichishani. Minchhataj llanc'anayta tucusaj”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Astawanpis Diospa yuyaskanmanjina uj p'unchaycunatawan purinallaypuni tiyan Jerusalenman chayanaycama. Diospa willajnenka Jerusalenpimin wañuchiska canan tiyan. ");
INSERT INTO quhNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","‘¡Mayta phuticuni kancuna Jerusalenpi tiyacojcunamanta! Unaymantapacha Diospa willajcunanta wañuchejcuna, paypa cachaskasninta ch'ankajcunataj canquichej. May ashqha cutis kancunata nokaman tantamuyta munarkani. Imaynatachus wallpa chillwisninta phurusnin uraman tantan, ajinallatataj may ashqha cutis kancunata tantamuyta munarkayquichej. Kancunarí mana munarkanquichejchu. ");
INSERT INTO quhNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Chekatapuni Dios yupaychana-wasiyquichejta sakerparipun. Niyquichejtaj: Mana ujtawan ricuwanquichejñachu “Jatunchaska cachun Diosmanta cachaska jamojka”, ninayquichejcama, —nispa nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Samacuna p'unchaypi fariseocunamanta uj curaj Jesusta wajyarka paywan miqhunanpaj. Curajpa wasinman Jesús yaycojtin chaypi cajcuna payta watekasharkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Chay quiquinpacha Jesuska ñaupakenpi uj punquilliska onkoska runata ricorka. ");
INSERT INTO quhNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesustaj israel yachachejcunata fariseostapis taporka: —¿Samacuna p'unchaypi runasta thañichinatachu chayrí mana thañichinatachu camachiskaka nin? ");
INSERT INTO quhNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Paycunarí ch'inlla carkancu. Jesustaj qhuyacuywan jap'ispa onkoska runata thañicherka cachaporkataj wasinman ripunanta. ");
INSERT INTO quhNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Israel yachachejcunaman fariseosmanwan nerka: —Kancunamanta ujniyquichejpa burron chayrí bueyninpis jatun yacu t'okoman urmaycunman. ¿Manachu samacuna p'unchaypipis uskhayta orkhonman? ");
INSERT INTO quhNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Chay niskanmantari mana cutichiyta aterkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesustaj khawasharka paywan wajyaskacuna imaynata aswan sumaj caj tiyanasta ajllacushaskancuta. Chayraycu paycunaman uj quiquinchanawan parlarka: ");
INSERT INTO quhNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Casamientoman wajyaska caspaka ama tiyacuychu aswan sumaj caj tiyanapeka. Ichapis kanmanta uj aswan curaj runa wajyaskallataj canman. ");
INSERT INTO quhNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Chanta wajyacusojniyquichejka nisunquiman: “Cay tiyanata cay ujman koy”, nispa. Kanri p'enkacuspa astawan khepa caj tiyanata masc'ayta kallariwaj. ");
INSERT INTO quhNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Astawanpis wajyaska caspaka aswan khepa caj tiyanapi tiyacuy. Chaymanta wajyasojka jamuspa kanta nisonka: “Amigóy, jamullay nokawan, cusca tiyacusun”, nispa. Chanta tucuy kanwan tiyacushajcunaj ñaupakencupi sumajpaj khawaska canqui. ");
INSERT INTO quhNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Chekamanta pillapis pay quiquin jatunchacojka pisipaj khawaska canka. Pisipaj khawacojtaj jatunchaska canka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Chaywanpis Jesús nillarkataj payta wajyajninman: —Jatun miqhunata waquichispaka ama wajyaychu ni amigosniyquita, ni waukesniyquita, ni ayllusniyquita, nitaj khapaj llajta-masisniyquitapis. Chayta ruwajtiyqueka paycunapis wajyallasuncumantaj. Ajinapitaj cutichipusunquiman. ");
INSERT INTO quhNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Astawanpis jatun miqhunata waquichispaka wajyay wajcha runasta, ñuc'usta, suchusta, ciegostapis. ");
INSERT INTO quhNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","May cusiska canqui cayta ruwaspaka paycunajta ni imancu caskanraycu. Manamin cutichisuyta atincuchu. Chekata ruwajcuna causarimunan p'unchaypeka Dios cutichipusonka, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Chayta uyarispa ujnin paywan tiyacushajcunamanta Jesusta nerka: —¡Cusiska canka Dios camachin, chaypi miqhoj runaka! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesusrí payta nerka: —Uj runa jatun miqhunata waquichiyta yuyarka. Waquichispataj ashqha runasta wajyarka. ");
INSERT INTO quhNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Miqhuna horata camachinta cacharka wajyaska runasman willananpaj: “Jamuychej. Tucuy ima waquichiskaña”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Wajyaskacunarí tucuynincu ujlla kallarerkancu, “Mana atinichu. Ujllapiwan cachun”, niyta. Ñaupaj cajka camachita nerka: “Cunallan jallp'ata ranterkani, chayta khawaj rinay tiyan. Amajinachu cachun, ujllapiwan”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ujtaj nerka: “Cunallan phishka yunta bueyesta ranterkani. Cunanka rishani yachaj imaynatachus llanc'ancu, chayta. Amajinachu cachun, qhuyariwachun”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Wajpis nillarkataj: “Cunallan casaracorkani. Chayraycu mana atinichu jamuyta”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Cutimuspataj camacheka señorninman tucuy cay imasta willarka. Chanta chay wasiyojka phiñacuspa camachinta nerka: “Uskhayta riy llajta callesman ñancunamanpis. Pusamuytaj wajcha runasta, ñuc'usta, ciegosta, suchustawan”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Paycunata pusamuspaña camacheka willarka: “Señorníy, camachiwaskayquita ruwaniña. Chaywanpis campoka canraj”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Señortaj camachinta nerka: “Riy campoman. Jatun ñancunamanta chaqui ñancunamantapis runasta pusarimuspa yaycuchiy. Wasiy junt'a cananta munani. ");
INSERT INTO quhNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Chayraycu niyquichej: Chay wajyaska runasmanta ni ujpis miqhunaytaka mallenkachu”, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jesús Jerusalenman rishajtin ashqha runas paywan rishallarkancutaj. Cutirimuspa paycunata nerka: ");
INSERT INTO quhNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Yachacojniy cayta munanqui chayka, nokata munacunawayqui tiyan astawan quiquin tatayquimanta, mamayquimanta, warmiyquimanta, wawasniyquimanta, waukesniyquimanta, panasniyquimanta, quiquin causayniyquimantapis. Manachayka mana atinquichu yachacojniy cayta. ");
INSERT INTO quhNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kan quiquiyquipi muchunayqui tiyan nokaraycu, casunawayquipunitaj tiyan wañunayquicama. Mana chayta ruwaspaka mana yachacojniy cayta atinquichu. ");
INSERT INTO quhNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Kancunamanta ujniyquichej torreta ruwayta munaspaka ñaupajta tiyaricuspa sumajta tanteyaricun. Yachanan tiyan tucunanpaj kolken caskanta. ");
INSERT INTO quhNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Cimientota churaspa sichus torreta mana tucuchayta atinmanchu chayka, tucuy ricojcuna paymanta asicuyta kallarenkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Nenkancutaj: “Caymin chay runaka cashan, wasichayta kallarerka manataj tucuchayta aterkachu”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Chayrí uj llajtata camachej waj llajtata camachejwan makanacunan cajtenka, ñaupajta tiyaricuspa sumajta tanteyaricunan. Tapuricunantaj: “Noka chunca waranka soldadosniyoj cani. ¿Caycunawan atipayta atisajchu iscay chunca waranka soldadoswan makanacuwaj jamoj camachejta?” ");
INSERT INTO quhNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mana atejjina cajtinrí enemigo carullapiraj cashajtin cachaconka allinyacuymanta parlaj. ");
INSERT INTO quhNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ajinallataj kancunawanpis cashan. Pillapis tucuy capuyninta mana sakejka manapuni atinchu yachacojniy cayta. ");
INSERT INTO quhNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","‘Cacheka sumajpuni. Sichus cachi lak'ayapunman chayka ¿imaynatataj sumaj cachiman cutirillanmantajrí? ");
INSERT INTO quhNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Cay lak'ayapuska cacheka mana allinchu ni jallp'apaj nitaj wanuwan chajrucunapajpis. Astawanpis runas jawallaman wijch'upuncu. Ajinallataj cashan mana cheka yachacojwanpis. ¡Ningriyoj cajka sumajta uyarichun! —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tucuy impuesto jap'ejcuna juchasapaspiwan chimpaycoj cancu Jesusman uyarinancupaj. ");
INSERT INTO quhNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Chayraycu fariseos israel yachachejcunapiwan Jesuspaj thutoj cancu. Nerkancutaj: —Cay runaka juchasapasta wajyacun paycunawantaj miqhun, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Chanta Jesús fariseosman yachachejcunamanpis cay quiquinchanawan parlarka. Nerkataj: ");
INSERT INTO quhNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Kancunamanta pachaj ovejasniyoj runa ujnin ovejanta chincachicuspa ¿imatataj ruwanman? Isk'on chunca isk'onniyoj ovejasninta ch'innej canchapi saken. Masc'aj rintaj chincaska ovejanta taricampunancama. ");
INSERT INTO quhNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ovejanta tarispa may cusiska lijraricampun. ");
INSERT INTO quhNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Wasinman chayamuspataj amigosninta llajta-masisnintawan wajyan tantacamunancupaj. Paycunata nintaj: “Cusicuychej nokawan. Ovejay chincaska carka, chayta taricampuni”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Niyquichej: Ajinallatataj cay pachapi uj juchasapa runa juchasninta sakespa Diosman cutirejtin, Dios anchata cusicun. Astawan cusicun paymantaka chay isk'on chunca isk'onniyoj chekan ruwajcunamanta niskaka. Paycuna ruwanasnincuta mana sakenancuchu tiyan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jesús nillarkataj: —Chunca dracma kolkesniyoj warmipis ujnin kolkenta chincachispa ¿imatataj ruwan? C'anchayta jap'ichin. Wasin uqhuta pichan. Sumajta khawaspa masc'an chincaska kolkenta taricapunancama. ");
INSERT INTO quhNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tarispataj amigasninta llajta-masisnintawan wajyan tantacamunancupaj. Paycunata nin: “Cusicuychej nokawan. Kolkeyta chincacherkani, chayta taricampuni”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Chekatapuni niyquichej. Ajinallatataj Diospa angelesnin mayta cusiconkancu uj juchasapa juchasninta sakespa Diosman cutiriskanraycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesús nillarkataj: —Uj runa iscay khari wawasniyoj carka. ");
INSERT INTO quhNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Sullc'a cajka tatanta nerka: “Tatáy, sakenawaycumanta chayakeyta, cunan koripuway”, nispa. Chaymanta tatancu iscayninman chayakencuta koporka. ");
INSERT INTO quhNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Pisi p'unchaycunamantari sullc'a wawanka tucuy chayakenta venderka. Kolkewantaj wasinmanta riporka caru llajtaman. Jakaypi kolkenta wayrachimorka munayninmanjina causaspa. ");
INSERT INTO quhNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Tucuynin kolkenta usuchejtinña manchay yarkhay tucuy jakay jallp'api carka. Paytaj yarkhayninwan ñac'ariyta kallarerka. ");
INSERT INTO quhNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Chanta jakaypi uj llajtayojman mañaricorka: “Llanc'arichillaway”, nispataj c'ascacorka. Llajtayojri jallp'anman qhuchisninta michimunanpaj payta cacharka. ");
INSERT INTO quhNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Thakoj pokoyninta qhuchis miqhoj cancu. Chay pokoywantaj sullc'aka yarkhaymanta sajsacuyta munasharka. Ni pipis ni ima miqhuyta payman korejchu. ");
INSERT INTO quhNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Chaymantarí chekan yuyayninman cutirispa sonkonpi nerka: “Tataypa wasinpi ashqha llanc'ajcuna cashancu. Tucuynincoj miqhunancu puchunpuni. Nokarí caypi yarkhaymanta wañunayashaniña. ");
INSERT INTO quhNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Jataricuspa tatayman cutipusaj. Nisajtaj: ‘Tatáy, juchallicuni Diospa contranta kanpa contrayquitapis. ");
INSERT INTO quhNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Chayraycu manaña wawayqui ninapajjinañachu cani. Ujnin llanc'aj runayquitajinallapis jap'icuway’ ”, nispa tanteyacorka. ");
INSERT INTO quhNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Chanta jatarispa quiquin tatanman cutiporka. ‘Carullapiraj cashajtin, tatan paytaka ricorkaña. Ricuspataj tucuy sonkonwan qhuyarka. Uskhayta kayllaycuspa wawantaka abrazaycuspa may munacuywan much'aycorka. ");
INSERT INTO quhNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Wawanri nerka: “Tatáy, juchallicuni Diospa contranta kanpa contrayquitapis. Chayraycu manaña wawayqui ninapajjinañachu cani”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Tatanrí camachisninta nerka: “Aswan sumaj p'achata uskhayta orkhomuspa payta p'achallichiychej. Sortejata maquinman churaychej. Chaquisninmantaj zapatosta churaychej. ");
INSERT INTO quhNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Wira caj waca uñata apamuspa ñac'aychej. Miqhuspataj mayta cusiracusunchej. ");
INSERT INTO quhNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Cay wawayka wañuskajina carka cunantaj causarimpunña. Chincaska carka taricapuniñataj”, nerka tatan. Chaymanta kallarerkancu cusiracuyta. ");
INSERT INTO quhNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","‘Chaycamarí curaj caj wawanka chajrapi casharka. Cutimuspa chayamorka wasin kayllaman. Uyarerka sicurista tusojtawan. ");
INSERT INTO quhNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Chanta ujnin camachita wajyaspa taporka: “¿Imaraycu tucuy cay ch'ajwarí?” ");
INSERT INTO quhNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Cuticherka: “Waukeyqui cutimpun. Tatayquitaj wira caj waca uñata ñac'achin waukeyqui allillanta payman cutimpuskanraycu”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Curajrí phiñacuspa mana munarkachu wasiman yaycuyta. Chaymanta tatan wajyamoj llojsimuspa payta nerka: “Wawáy, yaycumullay”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Payrí tatanman cuticherka: “Khaway, cay chhica watastaña llanc'ashani camachiyquijina. Camachiwaskayquitapis ni jayc'aj sakespa ruwashanipuni. Kanrí ni jayc'aj uj cabritollatapis kowanquichu amigosniywan cusicunaypaj. ");
INSERT INTO quhNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Cunan cay wawayqueka capuyniyquita sajra warmiswan k'alata tucuycuspaña jamun. Jamojtintaj cay wawayquipajka wira caj waca uñata ñac'achinqui”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tatantaj munacuywan nerka: “Wawáy, kan nokawan cuscapuni cashanqui. Tucuy nokajta cajka kanpatapuni. ");
INSERT INTO quhNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Cunanrí cusiracunanchej tiyan. Cay waukeyqueka wañuskajinamin carka, causarimpunña. Payka chincaska carka taricapuniñataj”, nispa nerka tatan. ");
INSERT INTO quhNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús yachacojcunaman nillarkataj: —Carka uj khapaj runa. Paypata carka uj khawapojnin. Ujcuna chay khapaj runaman willaycorkancu: “Khawapusojniyqueka capuyniyquita usuchishan”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Chanta khapaj runaka khawapojninta wajyaspa nerka: “¿Imatataj cayta kanmanta uyarishani? Cunanka capuyniywan ruwaskayquimanta willaway. Cunanmantapachaka manaña capuyniyta khawapuwanquichu”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Khawapojka paypi tanteyacuspa nerka: “Camachejniy khawapoj caskaymanta wijch'upuwan. ¿Imanasajtaj? Mana callpay canchu jallp'ata allanaypaj. Runasmanta mañacuspa puriyta p'enkacuni. ");
INSERT INTO quhNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","¡Aja, cayta ruwasaj! Camachejniy llanc'anaymanta wijch'uwajtin runas wasisnincuman wajyanawancupaj yachani imatachus ruwanayta”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Camachejninman manu runastataj ujmanta uj wajyarka. Ñaupaj cajta taporka: “¿Mayc'ataj camachejniyman konayquirí?” ");
INSERT INTO quhNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Runaka cuticherka: “Waranka p'uñus aceite konay tiyan”, nispa. Chanta khawapojka manu runata nerka: “Cayka konayquimanta papel. Tiyaycucuspa uskhayllata phishka pachaj p'uñusllataña churacuy”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Wajtapis taporka: “¿Mayc'ataj konayquirí?” Runaka cuticherka: “Waranka arrobas trigo konay tiyan”, nispa. Khawapojtaj payta nerka: “Cayka konayquimanta papel. Pusaj pachaj arrobasllataña kelkaycuy”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Camachejnintaj mana chekan ruwaj khawapojta mentarka, yuyaywan paypaj waquichicuskanmanta. Niyquichej: Cay pacha imaspi yuyaspa causajcuna paycunapura ruwanasnincupi yachaysapas cancu. Aswan yuyaywan ruwancu cheka caj c'anchaypi purej runasmanta niskaka. ");
INSERT INTO quhNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","‘Nokataj niyquichej: Kolkeyquichejka cay sajra pachamanta cashan, tucucojlla. Chaywanpis qhuyacuywan kolkeyquichejmanta koychej wajcha runasman. Ajinapi wañojtiyquichej kolkeyquichej tucucojtintaj Dios wiñaypaj wasinpi wajyasonkachej. ");
INSERT INTO quhNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","‘Pichari pisi kolkellawan chekanta ruwajka ashqha kolkewanpis chekanta ruwan. Pisi kolkellawan mana chekantachu ruwajrí, ashqha kolkewanpis manallataj chekanta ruwanchu. ");
INSERT INTO quhNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Cay pachapi kolkewan mana chekanta ruwajtaka ¿pitaj churanka wiñay capuyta khawananpaj? ");
INSERT INTO quhNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Dios kancunaman cay pachapi kolketa kosorkachej allin cajta ruwapunayquichejpaj. Sichus chaywan mana chekantachu ruwarkanquichej chayka ¿imaynatataj chayakeyquichejtaka Dios kosonkachej? ");
INSERT INTO quhNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","‘Ni pi iscay camachejcunata casuyta atinchu. Imayraycuchus ujta chejnenka wajtari munaconka. Ujman c'ascaconka wajtari khesachanka. Cheka Diostawan khapaj capuytawan manapuni casuyta atinquichu, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fariseos tucuy cay imasta Jesús parlaskanta uyarerkancu. Paycunaka kolke munacojcuna caspa millayta asipayaycorkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Paycunata Jesús nerka: —Kancuna chekancunapaj runaswan khawachicuyta munanquichej. Diosrí sonkoyquichejta yachan. Runaspaj sumaj khawaska cajtaka Dioska millachicunmin. ");
INSERT INTO quhNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Moisespa camachiskasnin Diospa unay willajcunanpa kelkaskancupiwanka Juan willararka, chaycama carkancu. Khepataka Dios camachin, chaymanta sumaj willanasta willarashaycu. Tucuy runastaj callpacushancu Dios camachin, chayman yaycunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Janaj pacha cay pachapis uskhaytaraj chincanman Diospa camachiskasninmanta niskaka. Cay camachiskasmanta ni jayc'aj uj juch'uy niskallanpis atiyninta chincachenkachu. ");
INSERT INTO quhNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Sapa khari warminmanta t'akanacuspa waj warmiwantaj casaracun chayka, khenchachacun. Chay t'akaska warmiwan casaracoj kharipis khenchachacullantaj, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Nillarkataj: —Carka uj khapaj runa. C'achitu sumaj p'achaswan p'achallicoj. Sapa p'unchaytaj may sumaj imasta miqhoj, jatun p'unchaypijina tucuy cusiywan. ");
INSERT INTO quhNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Callarkataj uj wajcha runa, Lázaro sutiyoj. Payka wijch'uska caj khapaj runaj wasin puncupi. Chay wajcha runari ch'upu onkoywan junt'a casharka. ");
INSERT INTO quhNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Maytataj munasharka korinancuta khapajpa miqhunanmanta t'acacoj t'unasta. Alkospis jamuspa ch'upusninta llajwaj cancu. ");
INSERT INTO quhNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Chaymanta wajcha runaka wañuporka. Angelestaj, payta pusarkancu Abraham cashan, chayman samacunanpaj. Khapaj runapis wañupullarkataj. Paytaka p'amparkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Laurashaj uqhu pachapitaj khapajka manchayta ñac'arisharka. Khawarispataj carupi Abrahamta ricorka, Lazarotapis paywan cuscata ricullarkataj. ");
INSERT INTO quhNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Chanta wajyacorka: “Abraham, tatáy, nokata qhuyariway. Lazarota cachamuway. Niy payta dedo puntallantapis yacuman chhapuspa apamunawanta kalluyta thasnunanpaj. Cay nina lauraypi mayta ñac'arishani”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abrahamka cuticherka: “Wawáy, yuyaricuy causashaspaka tucuy sumaj imas kanpaj carka. Lazaropajtaj mana allinpuni carka. Cunanrí payka caypi sonkochaska cashan. Kantaj ñac'arishanqui. ");
INSERT INTO quhNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Chaywanpis nokaycuwan kancunawan chaupinchejpeka Dios uj manchay wayk'ota churarka. Chayraycu caymanta kancunaman riyta munajcunaka, manapuni atincuchu. Kancuna cashanquichej chaymanta cayman jamuyta munajcunapis, manallataj atincuchu”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Khapajrí nerka: “Mañacuyqui, ari, tatáy, Lazarota cachanayquita tataypa wasinman. ");
INSERT INTO quhNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Jakaypeka phishka waukesniyoj cani. Cachapullaway Lazarota paycunaman sumajta willananpaj, ama chayamunancupaj cay ñac'ariy pachaman”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abrahamtajrí cuticherka: “Waukesniyquejta tiyan Moisespata Diospa unay willajcunanpa kelkaskasnincu. Chayta uyarichuncu”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Khapajka cuticherkaraj: Abraham, tatáy, mana chaycunata uyarenkancuchu. Astawanrí wañuskacunamanta pillapis paycunaman rinman chayka, juchasnincuta sakespa Diosman cutiriconkancu”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abrahamri cutichillarkataj: “Sichus Moisespa kelkaskanta willajcunaj kelkaskasnincuta mana uyarincuchu chayka, nillataj creenkancuchu wañuskacunamanta uj causarejtaka”, nispa. Chayta nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús yachacojcunanta nerka: —Juchaman urmachejka canpunimin. ¡Phutiy, ari, juchaman urmachej runapajka! ");
INSERT INTO quhNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Cay juch'uycitus nokapi jap'icojcunamanta ujninta juchaman urmachejpajka phutiy, ari. Aswan allin canman paypaj wañupunan. Allin canman runas jatun kochaman payta wijch'uycunancu jatun molino rumita cuncanman warqhuycuspa. ");
INSERT INTO quhNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Sumajta khawacuychej kancuna quiquiyquichejta. Sichus hermanoyqui juchallicunman chayka, munacuywan c'amiy. Sitajchus juchanta saken chayka, juchanta konkapuy. ");
INSERT INTO quhNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Uj p'unchaypi kanchis cutitapis contrayquipi juchallicunman. Kanchis cutitataj phuticuspa cutimusunquiman. Nisunquimantaj: “Mana ujtawan ajinata ruwasajchu”, nispa chayka, juchanta k'alata konkapuy. ");
INSERT INTO quhNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Cachasnintaj Señorta nerkancu: —Yanapawaycu Diospi astawan jap'icunaycupaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Señortaj cuticherka: —Uj mostaza mujitujina pisillatapis Diospi jap'icuwajchej chayka, uj jatun sach'ata niyta atiwajchej: “Saphintin t'iracuspa jatun kochaman saphichaycucuy”, nispa. Chekamanta casusunquichejmantaj. ");
INSERT INTO quhNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","‘Kancunamanta ujniyquichej uj camachiyoj caspa, cayta ruwan. P'unchaynintin camachin paypaj llanc'apun chayrí uywata michipun. Patronka camachinta llanc'askanmanta cutimojtin mana ninchu: “Uskhayta tiyaricuspa miqhuy”, nispaka. ");
INSERT INTO quhNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Manachayka nin: “Waquichiy miqhunayta. Miqhunayta ujyanaytawan jaywallawaypuni sajsanaycama. Chaymanta khepata kan miqhullanqui”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nitaj camachinta, “Agradeceyqui”, ninchu patronnenka camachiskanta ruwajtinpis. Chay imastaka camacheka ruwananpuni carka. ");
INSERT INTO quhNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ajinallataj kancunapis Diospa tucuy camachiskasninta ruwaspa niychej: “Mana allin camachislla caycu. Ruwanaycu carka, chayllata ruwarkaycu”, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesuska Jerusalenman rishaspa Samaria jallp'awan Galilea jallp'awan tincuynejta purerka. ");
INSERT INTO quhNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Uj ranchoman kayllashajtintaj chunca lepra onkoyniyoj runas paynejman jamorkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Carullapitaj sayarkancu. Khaparimorkancu: —¡Yachachej Jesús, qhuyawaycu! ¡Thañichiwaycu! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesustaj paycunata ricuspa nerka: —Riychej Jerusalenman. Yupaychana-wasipi ruwanayojcunawan khawachicamuychej, —nispa. Yupaychana-wasiman ñanta rishajtincu onkoynincumanta thañiskasña carkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Paycunamanta ujnincurí thañiskaña caskanta ricucuspa cutirimorka Jesusman. Khaparispataj Diosta yupaycharka. ");
INSERT INTO quhNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesuspa ñaupakenpi konkoricuspataj mayta agradececorka. Payka samaritano carka. ");
INSERT INTO quhNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesusrí nerka: —Chuncantincu thañichiskaska carkancu. Chanta ¿maypitaj chay isk'onrí? ");
INSERT INTO quhNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Imaraycutaj Diosta yupaychaj mana cutirimorkancuchu? Cay sapan waj llajtayoj runalla cutirimun, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Runatari nerka: —Jataricuy, ripuy. Diospi jap'icuskayquiraycu thañiska canqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Waquin fariseos Jesusta taporkancu: —¿Mayc'ajtaj camachenka Dios? Jesustaj paycunaman cuticherka: —Dios camachin, chayka mana ricunapajjinachu. ");
INSERT INTO quhNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Manallataj runas nenkancuchu: “Caypi cashan”, chayrí, “Jakaypi cashan”, nispa. Imaraycuchus, Dios chaupiyquichejpiña cashan camachinanpaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yachacojcunanmanri nerka: —Jamoj p'unchaycunapi noka, Diospa cachaska Runan, cutimuspa kancunawan canayta mayta munanquichej. Uj p'unchayllatapis ricuwayta munanquichej. Manaraj munaskayquichejka cankachu. ");
INSERT INTO quhNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nisonkachejtaj: “¡Khaway! Jesús jakaypi cashan”, chayrí, “Caypi cashan”, nispa. Ama ruwanasniyquichejta sakeychejchu. Amataj paycunata khatiychejchu. ");
INSERT INTO quhNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Lliuj-lliojka c'ancharichin cieloj uj ladonmanta ujnin ladoncama. Ajinallatataj noka, Diospa cachaska Runanka, lliuj-lliujjinamin cutimusaj. ");
INSERT INTO quhNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Astawanpis ñaupajtaka anchataraj ñac'arinay tiyan. Cay p'unchay runaspaj khesachaskancupis canay tiyan. ");
INSERT INTO quhNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","‘Noka, Diospa cachaska Runan, cutimojtiyka Noepa tiemponpijinamin canka. ");
INSERT INTO quhNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Chay p'unchaypi runaska miqhusharkancu, ujyasharkancu casaracusharkancutaj. Ajinata causasharkancu Noé barcojina arcaman yaycupunancama. Uj jatun para jamorka. Yacutaj tucuy chay runasta k'alata tucucherka. ");
INSERT INTO quhNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","‘Quiquillantaj carka Lot causashajtinpis. Miqhusharkancu, ujyasharkancu, rantisharkancu, vendesharkancu, tarpusharkancu, wasichasharkancutaj. ");
INSERT INTO quhNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lot Sodoma llajtamanta llojsiporka. Chay p'unchaypitaj Dioska ninata azufretawan parachimorka janaj pachamanta. Tucuy chaypi cajcunata k'alata tucucherka. ");
INSERT INTO quhNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Quiquillantajmin canka noka, Diospa cachaska Runan, ricuchiska canay, chay p'unchaypeka. ");
INSERT INTO quhNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","‘Chay p'unchaypi pillapis wasimanta jawapi cashanman capuynintaj uqhupi, chay capuyninta okharicoj ama yaycuchunchu. Chajrapi cajpis amallataj cutirichunchu. ");
INSERT INTO quhNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lotpa warminwan imayna caskanmanta yuyaricuychej. ");
INSERT INTO quhNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Causayninta payllapaj wakaychacuyta munajka mana wiñay causayniyojchu canka. Cay pachapi causayninta mana wakaychacojrí wiñay causaypaj wakaychaconka. ");
INSERT INTO quhNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","‘Niyquichejtaj: Noka cutimusaj, chay tutapi iscay runas uj puñunapi cashankancu. Paycunamanta ujnin nokawan cusca pusaska canka. Ujninrí sakeska canka. ");
INSERT INTO quhNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Iscay warmis cusca maranllapi cutashankancu. Paycunamanta ujnin nokawan cusca pusaska canka. Ujninrí sakeska canka. ");
INSERT INTO quhNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Iscay runas chajrapi cashankancu. Paycunamanta ujnin nokawan cusca pusaska canka. Ujninrí sakeska canka, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Cayta uyarispataj Jesusta taporkancu: —Señor ¿maypitaj ajina cankarí? Paytaj paycunaman cuticherka: —Maypicha aya cashan chayman alkamaris tantaconkancu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús uj quiquinchanawan paycunaman parlarka Diosmanta mañacunapuni caskanta, sonkopi mana llauchhuyaspa. ");
INSERT INTO quhNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nerkataj: —Uj llajtapi carka uj juez. Payka Diosta mana casojchu nitaj manchachicojchu. Runastapis manacajpaj khawaj. ");
INSERT INTO quhNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Chay quiquin llajtallapitaj carka uj viuda. Pay jamojpuni juezmanta mañaspa: “Chekan cajta ruwapuway contrallicuwajmanta wakaychaspa”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Juezka uj tiempota mana uyariyta munarkachu. Khepatarí pay quiquinpi nerka: “Diosta mana casunichu nitaj manchachicunichu. Runastataj manacajpaj khawani. ");
INSERT INTO quhNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Astawanrí cay warmeka mana samarejta sakewanchu. Chayraycu paypaj chekan cajta ruwapusaj. Cayta ruwasaj pay jamuwaspallapuni ama umayta nanachinawanpaj”, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Señortaj nerka: —Uyariychej chay mana chekan juez niskanta. ");
INSERT INTO quhNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Cunanrí Diosmanta yuyaychej. ¿Manachu Dioska chekan cajta ruwanka paypa ajllaska runasninpaj? Paycuna tuta p'unchay paymanta mañacushancu. ¿Dioska paycunata yanapananpaj khepaconkachu? ");
INSERT INTO quhNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Niyquichej: Dioska chekan cajta paycunapaj uskhayta ruwanka. Astawanpis noka, Diospa cachaska Runan, cutimuspa ¿nokapi jap'icuwajcunata cay pachapi tarisajrajchu? ");
INSERT INTO quhNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesús waquin runasman parlarka uj quiquinchanawan. Chay runaska yuyasharkancu chekan ruwajcuna caskancuta. Tucuy waj runastataj manacajpaj khawaj cancu. Chayraycu ajinata nerka: ");
INSERT INTO quhNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Iscay runas yupaychana-wasiman Diosmanta mañacoj rerkancu. Uj carka fariseo; wajtaj carka impuesto jap'ej runa. ");
INSERT INTO quhNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Chay fariseoka sumajta sayarispa payllapaj mañacusharka: “Diosníy, agradeceyqui mana waquin runasjinachu caskaymanta. Paycuna kolke orkhojcuna, mana chekan ruwajcuna, khenchacunapis cancu. Nitaj cay impuesto jap'ej runajinapischu cani. ");
INSERT INTO quhNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nokaka iscay cutita semanapi ayunanipis. Tucuy jap'iskaymantataj sapa chuncamanta ujta koyqui”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Cay impuesto jap'ej runarí carullapi sayaricorka. Manchachicuskanraycu janaj pachata mana khawarillarkapischu. Astawanpis phutiywan pechonta tacacushaspa nerka: “Diosníy, qhuyacuwaspa juchasniyta khechupuway. Tucuy runas yachancu juchayoj caskayta”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Niyquichej, chay impuesto jap'ej juchamanta llimphuchaska wasinman cutipuskanta. Chay waj runarí mana llimphuchaskachu carka. Chekamanta pillapis pay quiquin jatunchacojka, pisipaj khawaska canka. Pisipaj khawacojtaj jatunchaska canka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Uj cuti wawitasnincuta Jesusman pusamusharkancu maquisninta churaspa paycunapaj Diosmanta mañapunanpaj. Yachacojcunarí ricuspa pusamojcunata c'amerkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesusrí wawitasta wajyaspa nerka: —Sakeychej wawitasta nokaman jamunancuta. Amañataj paycunata jarc'aychejchu. Paycunajina cajcunata Dios munacuywan camachenka. ");
INSERT INTO quhNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Chekata niyquichej. Waquin runas wawitajina jap'incu Diosta Camachejnincupaj. Pillapis wawitajina mana jap'ejrí janaj pachaman yaycuyta mana atinchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Uj camachej Jesusta taporka: —C'acha Yachachejníy ¿imatataj ruwanay tiyan wiñay causay chayaketa jap'inaypaj? ");
INSERT INTO quhNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesustaj payman nerka: —Dioslla c'achaka. Chanta kanka ¿imaynapitaj noka c'acha caskayta niwanquirí? ");
INSERT INTO quhNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Yachanqui Diospa camachiskasninta: Ama khenchachacuychu; ama runata wañuchiychu; ama suwaychu; ama llullacuspa runamanta willaychu; tatayquita mamayquitapis casuy, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Chay camachejrí nerka: —Tucuy cay Diospa camachiskasninta wawamantapacha casuniña, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Cayta uyarispa Jesuska nerka: —Uj imallaña jarc'asunqui. Rispa tucuy capuyniyquita vendemuy, kolketa wajcha runasman jaywaramuy. Ajinapi khapaj capuyniyqui janaj pachapi canka. Chantaka jamuspa yachacojniy cay, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Camachejrí uyarispaka mayta phuticorka may khapaj caskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Phuticuskanta ricuspa, Jesús nerka: —¡Khapaj capuyniyojcunaka janaj pachaman ñac'ayta yaycuyta atenkancu! ");
INSERT INTO quhNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Jatun camello uywaraj astawan atinman yaycuyta agujaj ningrinmanka khapaj runa janaj pachaman yaycunanmantaka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Uyarejcunaka taporkancu: —Ajina cajtin ¿pitaj janaj pachaman yaycuyta atinmanrí? ");
INSERT INTO quhNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús nerka: —Runaspaj mana aticojka Diospajka aticun, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedrorí nerka: —Khaway, nokaycoka tucuy imaycuta sakespa kanta khatishaycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesustaj cuticherka: —Chekatapuni niyquichej. Uj runa atinman sakeyta wasinta, chayrí warminta, chayrí waukesninta, chayrí ayllunta chayrí wawasninta. Sichus cayta saken Dios runasta camachinanpaj chayka, payman cutichiska canka. ");
INSERT INTO quhNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Cay pachapi sakeskanmantaka ashqha cutis astawan payman cutichiska canka. Janaj pachapipis wiñay causayniyoj canka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Wajnejman chay chunca iscayniyoj cachasninta pusaspa, Jesús paycunata nerka: —Reparaychej, cunan Jerusalenman rishanchej. Noka, Diospa cachaska Runanmanta unay willajcuna kelkarkancu Diospa palabranpi. Tucuy chay kelkaskancutaj junt'aconkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Waj llajtayojcunaman jaywaska casaj. Paycunataj asipayawankancu, ñac'arichiwankancu, thokaycuwankancu. ");
INSERT INTO quhNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Jasut'iwaspataj wañuchiwankancu. Quinsa caj p'unchaymantataj causarimpusaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Cachasnenka willaskasninmanta ni ujta entienderkancuchu. Paycunapaj chay niskaska mana sut'ichu carka. Nitaj repararkancuchu ima niytachus munaskanta. ");
INSERT INTO quhNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesús Jericó llajtaman kayllamusharka. Ñannejpitaj uj ciego tiyacusharka mañacuspa. ");
INSERT INTO quhNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ashqha runas chaynejta purishajta uyarispa taporka: —¿Imataj chayrí? ");
INSERT INTO quhNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Runastaj payman willarkancu, Nazaret llajtayoj Jesús chaynejta rishaskanta. ");
INSERT INTO quhNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ciegotaj khaparerka: —¡Jesús, Diospa ajllaskan, nokata qhuyacuway! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ñaupajta rejcuna payta c'amerkancu: “Ch'in cay”, nispa. Payrí aswan sinch'ita khaparerka: —¡Diospa ajllaskan, nokata qhuyacuway! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Chanta Jesús sayaspa camacherka: —Payta pusamuwaychej, —nispa. Ciego kayllamojtin, Jesús taporka: ");
INSERT INTO quhNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Imatataj ruwapusunayta munashanqui? Ciegotaj cuticherka: —Señorníy, ujtawan ricuyta munani, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús payta nerka: —Ricuy. Diospi jap'icuskayquiraycu thañiska canqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Chay quiquinpacha ciegoka ricuporka. Diosta yupaychaspataj Jesusta khaterka. Chayta tucuy ricojcunapis Diosta yupaychasharkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesús Jericoman yaycuspa llajta chaupinta risharka. ");
INSERT INTO quhNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Chaypi carka uj runa, Zaqueo sutiyoj. Payka impuesto jap'ejcunaj curajnincu carka khapajtaj. ");
INSERT INTO quhNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Munasharka ricuyta imayna runachus Jesús caskanta. Juch'uy runalla caspataj mana ricuyta aterkachu runas ancha q'isqui caskancuraycu. ");
INSERT INTO quhNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ajinapi payka ñaupajman correrka. Jesús rinan casharka, chaynejpi uj jatun sach'a carka. Chay sach'amantaj wasarerka ricunanpaj. ");
INSERT INTO quhNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesusri chayman chayaytawan patanejman khawarispa Zaqueota nerka: —Zaqueo, uskhayta uraycamuy. Cunan p'unchay wasiyquipi khepacunay tiyan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zaqueo uskhayta uraycamuspa cusiywan Jesusta nerka: —Walejta jamunqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Cayta ricuytawan Jesuspaj tucuy rimaspa thutusharkancu: —Uj rejsiska juchasapa runaj wasinman Jesús samaricoj yaycun, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zaqueorí sayaricuspa Señorta nerka: —¡Señorníy, uyariway! Capuyniymanta wajcha runasman cuscanta cunan kosaj. Sichus pimantapis llullacuspa kolkenta orkhorkani chayka, tawa cutista cutichipusaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Zaqueoj niskanmanta Jesuska nerka: —Cunan p'unchay cay runata paywan tiyacojcunatawan Dios juchamanta cacharichin. Paypis Abrahampa ayllunmantañamin cashan. ");
INSERT INTO quhNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Noka, Diospa cachaska Runan, jamorkani Diosmanta chincaska runasta masc'aj juchasnincumanta cacharichejtaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Runas cayta uyarishajtincu Jesús uj quiquinchanawan parlarka. Jerusalén llajta kayllapi casharka. Paycunataj yuyasharkancu cay pachapi chay quiquinpacha Dios runasta camachinanta. ");
INSERT INTO quhNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Chayraycu nerka: —Carka uj wirakochi. Caru llajtaman rerka camachej churaska cananpaj. Chaymantataj cutimunan carka camachinanpaj. ");
INSERT INTO quhNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ajinapi manaraj rishaspa, chunca camachisninta wajyaspa kolketa sapa ujman jaywarka. Cay kolkeka quilla llanc'anapajjina carka. Nerkataj paycunaman: “Kolkeyta llanc'achiychej cutimunaycama”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Cay llajtapi tiyacojcunarí cay wirakochita chejnerkancu. Chayraycu khepanta cachacorkancu ninancupaj: “Mana munaycuchu chay runa camachinawaycuta”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Wirakocheka camachinanpaj churaska carka. Carumanta cutimuspataj nerka: “Kolkeyta jaywarkani, chay chunca camachisniyta wajyamuychej. Yachayta munani kolkeywan imaynata llanc'achiskancuta”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ñaupaj caj camachin payman jamuspa nerka: “Señorníy, kolkeyqui uj chunca kolketawan mirarka”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Camachej payta nerka: “Walej, c'acha camachíy. Chunca llajtasta camachinayquipaj atiyta koskayqui juch'uy imasllapi sumajta ruwaskayquiraycu”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Iscay caj camachin jamuspataj payta nerka: “Señorníy, kolkeyqui uj phishka kolkestawan mirarka”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Camachejtaj payta nerka: “Phishka llajtasta camachinayquipaj atiyta koskayqui”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Chaymanta waj camachin jamuspa nillarkataj: “Señorníy, caypi kolkeyqui cashan. Cayta sumajta wataycuspa jallch'arkani ");
INSERT INTO quhNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","manchachicususkayraycu. Kan rumi sonko canqui. Mana kanpata cajta jap'inqui mana tarpuskayquitapis cosechanqui”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Camachejka payta nerka: “Sajra camachíy, niskasnillayquiwantaj juchachayqui. Yachanqui noka rumi sonko caskayta, mana nokaj cajta jap'iskayta, mana tarpuskayta cosechaskaytapis. ");
INSERT INTO quhNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Chanta ¿imaraycutaj kolkeyta mana llanc'acherkanquichu? Nokataj cutimuspa miraynintawan kolkeyta jap'icapuyman carka”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Chaypi sayashaj yanapajcunata nerka: “Kolkeyta paymanta khechuychej. Koychejtaj chunca kolkesniyoj runaman”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Paycunataj payta nerkancu: “Señor, chunca kolkesta jap'ishanña”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Chay camachejka nerka: “Chekatapuni jap'ejmanka astawan koska canka. Mana jap'ejmantarí pisi capuskanpis khechuska canka. ");
INSERT INTO quhNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Astawanpis camachinayta mana munaj enemigosniyta cayman pusamuwaychej. Ñaupakeypi paycunata wañurachiychej”, nispa nerka. ");
INSERT INTO quhNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Chayta niytawan purispallapuni Jerusalén llajtaman risharka. ");
INSERT INTO quhNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Betfagé, Betania ranchoswan Olivos niska orkonejpiña cashaskancupi Jesuska iscay yachacojcunanta cacharka. Nerkataj: ");
INSERT INTO quhNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Riychej chimpa ranchoman. Chayman yaycuspataj manaraj chajnana malton burrota wataskata tarinquichej. Chay burrota phascaraspataj cayman khatimuychej. ");
INSERT INTO quhNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Sichus pipis tapusunquichejman: “¿Imaraycutaj burrota phascarashanquichej?” nispa chayka, payta niychej: “Señorninchej cayta munan”, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Cachaskastaj rispa Jesús niskanmanjinata tarerkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Burrota phascarashajtincutaj burroyojcuna paycunata taporkancu: —¿Imaraycutaj burroycuta phascarashanquichej? ");
INSERT INTO quhNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Cuticherkancu: —Señorninchej cayta munan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Burrotataj khaterkancu Jesusman. Ponchosnincuta burroman caronaycuspataj wasanman Jesusta llok'acherkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesús rishajtintaj runaska ponchosnincuta ñanninman mast'arkancu Jesús chay patata rinanpaj. ");
INSERT INTO quhNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Olivos orkomanta Jerusalenman uraycuna kayllapiña casharka. Tucuy cay ashqha khatejcunataj may cusiywan Diosta yupaycharkancu. Jesuspa tucuy jatun ruwaskasninta ricuskancumanta khaparispa Diosta yupaychasharkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Nerkancu: —¡Yupaychaska cachun Diospa sutinpi jamoj camachejka! ¡Dios runasta payman allinyachicun! ¡Tucuy atiyniyoj Dioska yupaychaska cachun! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Chay ashqha runasmanta waquin fariseostaj Jesusta nerkancu: —Yachachej, khatejcunayquita c'amiy ch'inyanancuta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesustaj cuticherka: —Chekatapuni cay runas yupaychanancu tiyan. Manachayka cay quiquin rumispis khaparincuman Diosta yupaychaspa, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jesuska Jerusalenman kayllaycamuspa tucuy llajtataña ricorka. Paytaj chay llajtamanta llaquicuspa wakarka. ");
INSERT INTO quhNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Nerkataj: —¡Jerusalenpi tiyacojcuna! Dios payman allinyachicuyta munarka. Kancunataj chayta mana reparaspa payta khesacharkanquichej. Cunanrí manaña chayta reparayta atinquichejchu. ");
INSERT INTO quhNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Chayraycu mana allin p'unchaycuna kancunapaj canka. Enemigosniyquichej llajtayquichejpa jawanta jatun perkata ruwankancu contrayquichejpi makanancupaj. Tucuy muyuyniyquichejpi tiyaycuconkancu, tucuynejmanta wisk'asonkachej. ");
INSERT INTO quhNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Tucuy wasisniyquichejta jallp'aman urmachenkancu. Kancunatataj wañurachisonkachej. Llajtayquichejpi ni uj rumillatapis sayashajta sakenkancuchu. Ajina canka Dios qhuyacuyninpi jamuspa yanapasuyta munaskanta mana reparaskayquichejraycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesús yupaychana-wasi patioman yaycuspataj vendejcunata rantejcunatawan kharkoyta kallarerka. ");
INSERT INTO quhNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Paycunatataj nisharka: —Dioska palabranpi nin: “Yupaychana-wasiyka nokamanta mañacuna wasi canan tiyan”. Kancunarí pacaymanta suwanayquichejpaj ruwaycacapunquichej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jesús yupaychana-wasej pationpi sapa p'unchay runasta yachachisharka. Chay wasimanta curajcunarí israel yachachejcunawan curajcunapiwan imaynallapipis Jesusta wañuchiyta munarkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Astawanrí runas Jesuspa parlaskanta sonko junt'askata uyarisharkancu. Chayraycu chay curajcunaka imaynapichus Jesusta tucuchiyta mana yacharkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Chay p'unchaycunamanta uj cajpi yupaychana-wasi patiopi Jesús runasman sumaj willanasmanta yachachisharka. Chaypacha israel curajcuna churanacoj Jesusman chimpaycorkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Taporkancutaj: —Niwaycu: ¿Ima atiywantaj cay imasta ruwashanqui? Chayrí ¿pitaj cay atiyta kosorka? ");
INSERT INTO quhNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesusrí paycunaman cuticherka: —Nokapis uj tapunata tapuskayquichej, kancunapis cutichiwaychej. ");
INSERT INTO quhNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Pitaj cachamorka Juanta runasta bautizananpaj? ¿Dioschu chayrí runaschu? ");
INSERT INTO quhNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Paycunapura tanteyacuspa ninacusharkancu: —Sichus nisunman Dios payta cachamuskanta chayka, Jesús tapuwasun: “¿Imaraycutaj paypa niskanta mana creerkanquichejchu?” ");
INSERT INTO quhNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Sitajchus nisunman runas payta cachamuskancuta chayka, tucuy runas rumiwan ch'ankawasunchej. Imaraycuchus runaska tucuy sonkowanmin creencu Juan Diospa willajnin caskanta, —nispa tanteyacorkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Chayraycu Jesusman cuticherkancu: —Pichus payta cachamuskanta mana yachaycuchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesustaj paycunata nerka: —Ni nokapis willaskayquichejchu ima atiywanchus cay imasta ruwashaskayta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jesús runasman cay quiquinchanawan parlayta kallarerka: —Uj runa jallp'anpi ashqha uva sach'itasta yuracharka. Llanc'aj runasman jallp'anta arrendarka pokoyninmanta konancupaj. Chanta jallp'ayoj runaka unaypaj caru llajtaman riporka. ");
INSERT INTO quhNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Uva pallana tiempotataj uj camachinta cacharka llanc'ajcunaman, uvasta payman konancupaj. Llanc'ajcunarí payta sek'ospataj mana imayojllata cutichiporkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Jallp'ayojtaj ujnin camachinta cachallarkataj. Chay ujnintapis llanc'aj runas sek'orkancu p'enkaytataj paywan ruwarkancu. Mana imayojllatataj cutichiporkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Jallp'ayoj runaka quinsa caj camachinta cachallarkataj. Llanc'aj runasrí payta sinch'ita makaycuspa jallp'amanta kharkorkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","‘Chayraycu jallp'ayoj señorka nerka: “¿Imanasajtaj? Munaska wawayta cachasaj. Camachisniyta khesacharkancu. Ichapis paytaka jatunpaj khawankancu”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Llanc'aj runasrí camachejpa wawanta ricuspa paycunapura tanteyanacusharkancu: “Cay wawanman cay jallp'a koska canka. Wañuchinachej chayaken nokanchejpata cananpaj”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Jallp'amanta kharkospataj payta wañucherkancu. ‘Chanta ¿imanankataj uva jallp'ayoj señorka chay llanc'aj runastarí? ");
INSERT INTO quhNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Cayta ruwanka: Jamuspa chay llanc'aj runasta wañurachenka jallp'antataj wajcunaman arrendayconka, —nispa. Chayta uyarejcunataj nerkancu: —¡Ni jayc'aj ajinaka cachunchu! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesusrí paycunata sinch'ita khawaspa nerka: —Cay kelkaskata ¿imaynatataj entiendenquichejrí? Nin: Wasichajcuna rumita khawaspa khesacharkancu. Wasita sinch'ita sayachinanpajrí chay khesachaska rumeka aswan sumaj cashan tucuy waj rumismanta niskaka. ");
INSERT INTO quhNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Chay rumiman urmacoj runaka t'unaska canka. Pimanchus chay rumi urmaycunman chayka, payta ñut'urparenka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Israel yachachejcunawan yupaychana-wasimanta curajcunawanka repararkancu Jesús chay quiquinchanata paycunamanta parlaskanta. Chayraycu payta jap'iycuchiyta churacorkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Curajcunarí Jesusta jap'iycuyta munaspa sinch'ita khawasharkancu. Chayraycu watekajcunaman kolketa kospa cacharkancu Jesusta parlaskanpi jap'erkonancupaj. Chaywan curaj camachejpa atiyninman jaywaycuyta munarkancu. Watekajcunaka c'acha runasjinalla tucorkancu puraj uyas cashaspapis. ");
INSERT INTO quhNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Paycunataj Jesusta nerkancu: —Yachachej, yachaycu chekanta parlaskayquita yachachiskayquitapis. Runastapis mana rijch'acuynillanmantachu khawanqui, manachayrí caskancumanta. Astawanpis cheka cajta yachachishanqui imatachus Dios munan runas ruwanancuta chayta. ");
INSERT INTO quhNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Cunan kan niwaycu: Nokanchej, israelcuna ¿romano gobiernoman impuestota konachus manachus? ");
INSERT INTO quhNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesuska puraj uyawan watekaskancuta sumajta reparaspa nerka: ");
INSERT INTO quhNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Uj kolketa ricuchiwaychej, —nispa. Payman ricuchejtincutaj Jesús taporka: —¿Pejpa uyantaj pejpa sutintaj cay kolkepi cashanrí? Cuticherkancu: —Romano curaj camachej Cesarpata, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesustaj paycunata nerka: —Cesarpata cajtaka Cesarman koychej; Diospata cajtataj Diosman koychej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Mana aterkancuchu Jesusta parlaskanpi jap'erkoyta runaspa ñaupakencupi. Cutichiskanmanta t'ucuspataj ch'inyacorkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Saduceos nej cancu wañuska runaska mana ujtawan causarimunancuta. Paycunamanta waquin Jesusman jamuspa nerkancu: ");
INSERT INTO quhNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Yachachej, Moisés nokanchejpaj kelkarka: “Sichus uj casaraska runa mana wawayoj wañupuman chayka, paypa wauken casarachun wañojpa viudanwan. Chayta ruwachun wawa cananpaj curaj waukenpa sutin ama chincapunanpaj”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Cunanri, carkancu kanchis waukes. Curaj cajka casaracorka mana wawayojtaj wañuporka. ");
INSERT INTO quhNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Chanta iscay caj khareka wañoj waukenpa viudanwan casaracorka. Paypis wañuporka mana ni uj wawata rejsispa. ");
INSERT INTO quhNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Quinsa cajwanpis quiquillantaj carka. Ajinataj carka kanchis waukesnintinwanpis. Sapa uj curaj waukenpa viudanwan casaracorkancu. Sapa ujtaj mana ni uj wawata rejsispa wañuporka. ");
INSERT INTO quhNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Khepata chay warmipis wañupullarkataj. ");
INSERT INTO quhNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Cunanka wañuska runas causarimojtincu chay warmi kanchis runaswan casaracuskanmanta ¿maykennincoj warmintaj cankarí? ");
INSERT INTO quhNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesús paycunata cuticherka: —Cay pachapi kharis warmispis casaracuncu. ");
INSERT INTO quhNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Wañuymanta causarimpojcunarí janaj pachaman yaycunancupajjina khawaskasmin cancu. Paycunaka causarimuspa mana casaraconkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Imaynachus angeles mana wañupuncuchu, ajinallataj causarimoj runaspis mana ujtawan wañonkancuchu. Paycunaka janaj pachaman yaycoj Diospa wawasnin cancu. ");
INSERT INTO quhNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Chaywanpis Moisés ricucherka wañuska runas chekatapuni causarimunancuta. Kelkarka, Dios nina lauraj sach'itamanta nimuskanta: “Noka cani Abrahampa Diosnin, wawan Isaacpa Diosnin, allchhin Jacobpatapis Diosnintaj”. Abraham Isaacwan Jacobwanpis may unay wanupuskancumantaña, chayta nerka Dios. ");
INSERT INTO quhNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Diospajka wañuskaspis causashancu. Chayraycu pay mana wañuskacunaj Diosnincuchu, manachayrí causashaj runaspa Diosnincumin, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Waquin israel yachachejcunataj nerkancu: —Yachachej, sumajta cuticherkanqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ajinapi manaña astawan imatapis Jesusta tapoj churacorkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesusrí paycunata taporka: —Cristoka Davidpa wawan caskanta ¿imaynapitaj nincurí? ");
INSERT INTO quhNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Quiquin Davidka taquina libropi kelkarka: Señor Diosninchej nerka Señorniy Cristoman: “Nokawan cusca tiyaycucuy camachinanchejpaj ");
INSERT INTO quhNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","churanacojcunayquita k'alata atipanaycama”. ");
INSERT INTO quhNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ajinata Davidpis Cristota, Señorñiy, nerka. Chanta ¿imaynatataj Cristoka Davidpa wawallan canman? —taporka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tucuy runas uyarishajtincu, Jesuska yachacojcunanta nerka: ");
INSERT INTO quhNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Sumajta khawacuychej israel yachachejcunamanta. Paycuna sumaj p'achalliskas puriyta munancu. Munancutaj plazaspi sumajta napaycuchicuyta. Tantacuna-wasipitaj curajcunaj tiyanasnincupi tiyacuyta munancu. Jatun miqhunaspipis sumaj khawaskacunaj tiyanasnincupi tiyacuyta munancu. ");
INSERT INTO quhNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Chaywanpis viudaspa pisi capuynincuta suwaspajina khechuncu. Diosmanta anchata mañacushaskancuwan sajra munaynincuta pacayta munancu. Cay runastaka Dios aswan sinch'iwan juchachanka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yupaychana-wasipi cashaspa Jesús ricorka khapaj runas Diosman konasta kolke churanasman churashajta. ");
INSERT INTO quhNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ricullarkataj uj wajcha viudata iscay kolkesitusninta churashajta. ");
INSERT INTO quhNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Chanta nerka: —Chekatapuni niyquichej. Diospajka cay wajcha viudaj churaskan astawan carka tucuy ujcunajmanta niskaka. ");
INSERT INTO quhNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tucuy chay waj runas ashqha capuynincoj puchuskanmanta Diosman korkancu. Payrí wajcha cayninmanta tucuy kolkenta korka. Chayka causananpaj casharkapis, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Waquin ninacusharkancu yupaychana-wasi may c'achitu caskanta. Imaraycuchus sumaj rumiswan, Diosman khapaj koskaswan ima, c'achachaska carka. Jesusrí nerka: ");
INSERT INTO quhNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Tucuy cay c'achitu rumi wasista ricushanquichej, chaycunaka urmachiskas cankancu. Jamoj p'unchaycunapi cay yupaychana-wasejta ni uj rumillapis sayashaj sakeskachu canka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Paycunataj Jesusta taporkancu: —Yachachiwajníy, ¿mayc'ajtaj ajina cankarí? ¿Imastaj ricuchiwasajcu, chay imas canayashaskantarí? ");
INSERT INTO quhNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús cutichispa nerka: —Sumajta khawacuychej ama pantachiskas canayquichejpaj. Ashqhas llullacuspa jamonkancu sutiypi. Nenkancu: “Nokamin Diospa ajllaskan Cristoka cani”; “Cunan chay p'unchay chayamunña”, nispa. Ama paycunaj khatejnincoka caychejchu. ");
INSERT INTO quhNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Chaywanpis guerrasmanta uyarispa guerrasmanta parlajta uyarispapis ama manchachicuychejchu. Cay imaska ñaupajta cananpuni. Astawanrí manaraj tucucuyrajchu canka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Chanta nillarkataj: —Uj ayllu waj aylloj contranpi okhariconka. Uj llajtayoj runas waj llajtayoj runaspa contranpi okhariconka. ");
INSERT INTO quhNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Jallp'apis may sinch'ita qharcatitenka. Caynejpi jakaynejpi yarkhaycuna, onkoycuna canka. Mancharinasta janaj pachamanta jatun ricuchinastawan runas riconkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","‘Manaraj tucuy cay pasashajtintaj, runaska kancunata jap'iycuspa ñac'arichisonkachej. Jaywaycusonkachej tantacuna-wasipi curaj runasman juchachaskas wisk'aycuskaspis canayquichejpaj. Camachejcunaman pusasonkachej sutiyraycu, nokaj yachacojcunay caskayquichejraycu. ");
INSERT INTO quhNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ajinapi kancunaka paycunaman nokamanta willarayta atinquichej. ");
INSERT INTO quhNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Imatachus cutichinayquichejtarí ama ñaupajta yuyaychejchu. ");
INSERT INTO quhNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Imaraycuchus noka quiquiymin yachayniyoj parlaycunata parlachiskayquichej. Chay niskasniyquichejta juchachasojcuna mana atipayta nitaj cutichiytapis atenkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Tatasniyquichej, waukesniyquichej, ayllusniyquichej, amigosniyquichejpis enemigosniyquichejman jaywasonkachej. Kancunamanta waquinta wañurachisonkachej. ");
INSERT INTO quhNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tucuy runas chejnisonkachej, nokaj yachacojcunay caskayquichejraycu. ");
INSERT INTO quhNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Chaywanpis ni uj chujchapis umayquichejmanta chincaponkachu. ");
INSERT INTO quhNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Diospi jap'icuspapuni allinta sayaskayquichejwan wiñay causayta jap'inquichej. ");
INSERT INTO quhNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","‘Soldados Jerusalenta muyuycamojta ricuspa yachanquichej cay llajtaka tucuchiskaña cananta. ");
INSERT INTO quhNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Chaypacha Judea jallp'api cashajcuna orkosman aykecuchuncu. Jerusalenpi cashajcuna llojsichuncu. Llajta jawapi cashajcunapis ama chayman yaycuchuncuchu. ");
INSERT INTO quhNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Jakay p'unchaycunaka chaypi tiyacojcunaj juchancuraycu Dios sinch'ita phiñaconka. Ajinapi Diospa tucuy kelkaskan paycunamanta junt'aconka. ");
INSERT INTO quhNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Phutiy, ari, jakay p'unchaycunapi wijsayoj warmispaj ñuñoj wawitasniyoj warmispajpis! Manchay ñac'ariymin cay pachapi canka. Cay runaspaj Dios c'ajajta phiñaconka. ");
INSERT INTO quhNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ashqhas jatun cuchilloswan wañurachiskas cankancu. Ashqhastaj waj llajtasman jap'iycuska apaskas cankancu. Waj llajtayojcunaka Jerusalenta saronkancu chay niska p'unchaycuna tucucunancama. ");
INSERT INTO quhNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","‘Cutimuyniypaj ricuchinas canka intipi, quillapi, ch'askaspiwan. Cay pachapi runaska mayta llaquiconkancu jatun kochaj ch'ajwaskanmanta khallacuskanmantawan. Manchachicuymantataj musphankancu. ");
INSERT INTO quhNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Runaska cay pachawan imachus cananta manchachicuywan suyaspa wañunayashankancu. Cielopi cajcunata Dios cuyuchenka. ");
INSERT INTO quhNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Chaymantamin runas ricuwankancu. Noka, Diospa cachaska Runanta, uj phuyupi jamushajta atiyniywan lliphipej c'anchaywanpis ricuwankancu. ");
INSERT INTO quhNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kancunarí chay imas kallaricojtin sumajta Diospi jap'icuychej, nokata suyawaspa. Cachariska canayquichej p'unchayka kayllamushanña, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Quiquinchaspataj nerka: —Reparaychej higo sach'ata tucuy sach'astapis. ");
INSERT INTO quhNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Laphisnincu ch'illchimojtinña yachanquichej k'oñi tiempo chayamushaskantaña. ");
INSERT INTO quhNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ajinallatataj kancunapis chay imasta ricuspa yachanquichej Dios tucuyta camachinanpaj chayamushaskanta. ");
INSERT INTO quhNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Chekamanta niyquichej cunan p'unchay runas cashajtincuraj tucuy cayka ruwacunanta. ");
INSERT INTO quhNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Janaj pacha cay pachapis chincaponkancu; niskasniyrí junt'aconkancupuni. ");
INSERT INTO quhNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","‘Kancuna quiquiyquichejta sumajta khawacuychej. Pajtataj sonkoyquichej rumiyapunman. Pajtataj millay causaywan, machaywan, cay pacha causay imasmanta llaquicuywanpis atipachicuwajchej. Pajtataj ajinapi chay p'unchay mana yuyayllata kancunaman chayamusunquichejman. ");
INSERT INTO quhNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Trampaka ujllata animalta jap'iycun. Ajinallatataj jakay p'unchaypis tucuy cay pachapi tiyacoj runasman jap'irparenka. ");
INSERT INTO quhNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kancunarí tuta p'unchay Diosmanta mañacuspa rijch'ariskas caychej. Chaywan sonkoyquichejpi sumaj callpachaskas canquichej tucuy chay canayashajcunata muchunayquichejpaj. Ajinapi noka, Diospa cachaska Runanman jakay p'unchaypi chimpacuwanquichej, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","P'unchaycunaka payka yupaychana-wasi patiopi yachachej. Tutastaj Olivos orkoman samacoj rej. ");
INSERT INTO quhNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tucuy runastaj tutamanta payta uyarej yupaychana-wasiman rej cancu. ");
INSERT INTO quhNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Israelcunaj pascuancu kayllamusharkaña, mana pokochinayoj t'antata miqhuna p'unchaycuna. Yuyarichinapaj carka Dios unay tatasnincuta cacharichiskanmanta. ");
INSERT INTO quhNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Chay p'unchaycunapi yupaychana-wasimanta curajcuna israel yachachejcunapiwan Jesusta wañuchiyta mayta munasharkancu. Runasta manchachicuskancuraycutaj imaynapichus wañuchiyta mana yacharkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Jesuspa chunca iscayniyoj cachasninmanta Iscariote niska Judaska ujnin caj carka. Supay Satanasrí sonkonman yaycorka. ");
INSERT INTO quhNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ajinapi payka yupaychana-wasimanta curajcunawan, guardia camachejcunawan parlamorka Jesusta jaywaycunanpaj. ");
INSERT INTO quhNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Paycunataj mayta cusicuspa Judasta nerkancu: —Jaywawaskaycumanta kanman kolketa kosajcu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judastaj nerka: —Allin canka, —nispa. Chanta masc'asharka imaynapichus pacayllamanta Jesusta jaywaycuyta chay ashqha runas mana yachashajtillancu. ");
INSERT INTO quhNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Mana pokochinayoj t'anta p'unchay chayamorka. Chay p'unchaypeka pascua corderota wañuchinancu caj. ");
INSERT INTO quhNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesuska Pedrota Juantawan nerka: —Rispa, pascua miqhunata miqhunanchejpaj waquichimuychej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Paycunataj payta taporkancu: —¿Maypitaj munashanqui chay miqhunata waquichinaycuta? ");
INSERT INTO quhNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Paytaj paycunata nerka: —Uyariwaychej: Llajtaman yaycuspa uj yacu p'uñuta apaj runawan tincunquichej. Payta khatiychej maymanchus yayconka, chay wasiman. ");
INSERT INTO quhNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Chay wasiyojtataj niychej: “Yachachejninchej nisunqui: ‘¿Maypitaj cashan chay sala yachacojcunaywan pascua miqhunata miqhunaypaj?’ ” ");
INSERT INTO quhNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Paytaj uj allinchaska jatun salata alto pisopi ricuchisonkachej. Chaypi waquichimuychej nokanchejpaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Yachacojcunataj llajtaman rispa tucuy imata Jesuspa niskanmanjinata tarerkancu. Pascua miqhunatataj waquichimorkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Miqhunancupaj hora chayamojtin, Jesús tiyaycucorka cachasninwan. ");
INSERT INTO quhNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Paycunata nerka: —Maytapuni munarkani kancunawan cay pascua miqhunata miqhuyta manaraj noka ñac'arishaspa. ");
INSERT INTO quhNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Chekatapuni manaña ujtawan cay pascua miqhunata miqhusajchu Dios tucuyta camachin, chaypi miqhunaycama. Chay p'unchaypi Diospa mosoj traton runasninpaj junt'aconka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Chanta Jesuska copata jap'ispa Diosman graciasta kospataj nerka: —Cay ujyanata jap'iychej ujyacuychejtaj. ");
INSERT INTO quhNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Niyquichej: Cunanmantapachaka cay uvasmanta ruwaskata manaña ujyasajchu Dios tucuyta camachejtin, chay p'unchaycama, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","T'antata maquisninwan jap'ispataj Diosman graciasta kospa t'antata parterka. Cachasninman jaywaspataj nerka: —Cayka cuerpoy ninacun. Kancunaraycu koska cashan. Cayta ruwaychej miqhuspa nokamanta yuyaricunawayquichejpaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Miqhuskancumanta Jesús quiquillantataj copawan ruwaspa nerka: —Cay copaka Diospa mosoj tratonmin. Yawarniyka traton atiyniyoj cananpaj jich'askamin cashan ama wiñaypaj wañunayquichejpaj. ");
INSERT INTO quhNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","‘Chaywanpis cunanka jaywaycojniypa maquin maquiywan cusca mesapi cashan. ");
INSERT INTO quhNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Noka, Diospa cachaska Runanka, paypa yuyaskanmanjina wañunay tiyan. Astawanpis ¡phutiy, ari, chay jaywaycojpajka! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Cachasnintaj tapunacuyta kallarerkancu maykennincuchus chayjina sajrata ruwaj rishaskanmanta. ");
INSERT INTO quhNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Chanta cachasnin churanacusharkancu pichus paycuna uqhupi aswan curajpaj khawaska cananmanta. ");
INSERT INTO quhNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesusrí paycunata nerka: —Llajtasta camachejcuna runasta llaquichispa camachincu. Chaywanpis allin imasta ruwaj, nichicuytaraj munancu. ");
INSERT INTO quhNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kancuna uqhupirí mana ajinachu canka. Astawanpis kancuna uqhupi curaj cajka sullc'ajina cachun. Camachejtaj yanapajjina cachun. ");
INSERT INTO quhNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Miqhunapaj tiyacojchu chayrí miqhunata jaywajchu astawan curajpaj khawaska? Miqhunapaj tiyacojmin astawan curajpaj khawaska cashan. Nokarí yanapajniyquichejjina kancuna uqhupi cashani. ");
INSERT INTO quhNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","‘Nokawan cuscapuni cacorkanquichej ñac'arishajtiy. ");
INSERT INTO quhNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ñac'ariskaymanta Tatay Dios camachinaypaj churawanka. Quiquillantataj nokapis camachinayquichejpaj churaskayquichej. ");
INSERT INTO quhNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ajinapi camachishajtiy nokawan cusca miqhunquichej ujyanquichej. Churaskayquichejtaj chunca iscayniyoj Israel ayllusta camachinayquichejpaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesús nerka: —Simonníy, uyariway. Supay Satanás kancunata sinch'i llaquiycunawan juchaman urmachisunanpaj mañarka. ");
INSERT INTO quhNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nokari kanpaj Diosmanta mañaporkayqui, Diospi jap'icuyniyqui ama chincapunanpaj. Nokaman cutiricamuskayquimanta cay hermanosniyquita sonkoncupi callpachanqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simonrí payta nerka: —Señorníy, kanwan cusca rinaypaj carcelmanpis wañuymanpis waquichiska cani, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesusrí payta nerka: —Kanta niyqui, Pedro, cunan tutapacha manaraj gallo wakashajtin quinsa cutita ninqui nokata mana rejsiwaskayquita, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesús cachasninta nerka: —Ñaupajpi willarajta cacharkayquichej mana kolke churanayojta ni wayakayojta ni ojot'asniyojta. Chaypacha ¿imapis pisisorkachejchu? Cuticherkancutaj: —Ni imapis pisiwarkaycuchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Chanta paycunata nerka: —Cunanrí kolke churanayoj caj chayrí wayakayoj apacuchun. Mana jatun cuchilloyoj cajtaj p'achanta vendechun ujta rantinanpaj. ");
INSERT INTO quhNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Imaraycuchus cay kelkaskaka nokapi junt'acunan tiyan: “Payka yupaska carka juchasapaswan cusca”. Cay pachapi ruwanasniy tucucapun, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Paycunarí nerkancu: —Señorníy, khaway, caypi iscay jatun cuchillos tiyan, —nispa. Jesustaj paycunata nerka: —Chayllaña cachun, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesús wasimanta llojsispa Olivos orkoman rerka, rej caskanmanjina. Yachacojcunapis khatillarkancutaj. ");
INSERT INTO quhNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Chayman chayaspataj paycunata nerka: —Diosmanta mañacushaychej ama juchaman urmanayquichejpaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Paycunamanta caruncharicuspa uj rumi chokaymanjina Jesús konkoricorka. Diosmantataj mañacusharka: ");
INSERT INTO quhNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Tatáy, munanqui chayka, cay ñac'ariypi wañunayta nokamanta khechupuway. Astawanpis ama munayniyka ruwacuchunchu. Manachayrí munayniyqui ruwacuchun, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Janaj pachamanta uj angel riqhurispa payta callpacharka. ");
INSERT INTO quhNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesús sonkonpi mayta ñac'arispa aswan sinch'ita mañacusharka. Jump'intaj sut'uspi yawarjina pampaman urmarka. ");
INSERT INTO quhNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Jesús Diosmanta mañacuskanmanta jatarispa yachacojcunanman cuterka. Paycunata phutiywan puñuskasta tariparka. ");
INSERT INTO quhNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Chanta nerka: —¿Imaraycutaj puñushanquichej? Jatarispa Diosmanta mañacuychej ama juchaman urmanayquichejpaj. ");
INSERT INTO quhNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús parlashajtillanraj, ujllata ashqha runas riqhurimorkancu. Judas paycunata pusamusharka. Payka chunca iscayniyoj yachacojcunamanta ujnin carka. Jesusman kayllamuspataj much'aycorka. ");
INSERT INTO quhNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesusrí payta nerka: —¿Judas, uj much'awanchu jaywaycunqui Diospa cachaska Runanta? ");
INSERT INTO quhNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jesuswan cashajcunaka repararkancu imatachus chay runas ruwanayashaskancuta. Chayraycu nerkancu: —Señorníy, ¿cuchillosniycuwan wajtasajcuchu? ");
INSERT INTO quhNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Paycunamanta ujnintaj cuchillonwan wajtaspa uj runaj paña ningrinta kholurparerka. Chay runari yupaychana-wasipi camachejpa camachin carka. ");
INSERT INTO quhNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesusrí yachacojcunanta nerka: —Chayllata. Sakellaychej paycunata. Cayta nispataj chay camachej kholuska ningrinta llanqharispa thañicherka. ");
INSERT INTO quhNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yupaychana-wasimanta curajcuna, yanapajcunancuwan israel curajcunapiwanpis jap'iycoj jamuspa chaypi casharkancu. Jesustaj paycunata nerka: —¿Jatun cuchilloswan makana c'aspiswan uj runa wañuchi suwamanjinachu jamuwanquichej? ");
INSERT INTO quhNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Sapa p'unchay kancunawan casharkani yupaychana-wasi patiopi manataj jap'iycuwarkanquichejchu. Cunanrí atillanquichej, supay lakhaj atiyninwan camachishajtin, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jesusta jap'ispataj yupaychana-wasipi camachejpa wasinman apaycorkancu. Pedrorí chayman caru khepallanta khaticusharka. ");
INSERT INTO quhNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Runastaj uj sumaj ninata jap'icherkancu patio chaupipi. Paycuna chaupincupitaj Pedro tiyacusharka k'oñicuspa. ");
INSERT INTO quhNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Chaypitaj uj camachi warmi Pedrota nina c'anchaypi tiyacushajta ricorka. Allinta Pedrota khawaspataj nerka: —Cay runapis Jesuswan casharka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pedrorí mananchacorka: —Mana rejsinichu paytaka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Unitaymantawan uj runapis Pedrota ricuspa nerka: —Kanpis Jesuspa yachacojcunanmanta ujnin canqui, —nispa. Pedrorí cuticherka: —Manapuni, tatáy, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Uj horamantajinataj waj runa aswan sinch'ita nerka: —Chekatapuni yachani cay runaka Jesuswan cashaskanta paypis Galileamanta caskanraycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pedroka nerka: —Tatáy, mana yachanichu imatachus nishanqui, —nispa. Chay quiquinpachataj Pedro parlashajtillanraj galloka wakarka. ");
INSERT INTO quhNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Señortaj cutiricamuspa Pedrota khawarimorka. Chaytaj yuyaricherka Pedrota Señorpa niskanta: “Cunan tutapacha manaraj gallo wakashajtin kanka quinsa cutita ninqui nokata mana rejsiwaskayquita”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pedrotaj llojsispa sonko nanajta wakarka. ");
INSERT INTO quhNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Wakaychaj camachis Jesusta sek'ospa asipayarkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ñawisninta wataspataj tapusharkancu: —Sut'inchaspa willawaycu pitaj makasorka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","May ashqha waj sajra imastawan payta nisharkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tutamanta tucuy israel curajcuna tantacorkancu. Chay jatun tantacuyman Jesusta pusachimorkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Nerkancutaj: —Willawaycu ¿Diospa ajllaskan Cristochu canqui? Payrí nerka: —Sichus willayquichejman chaypis, mana creewanquichejmanchu. ");
INSERT INTO quhNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Imata tapuyquichejman chaypis, manapuni cutichiwajchejchu nitaj cachariwanquichejmanchu. ");
INSERT INTO quhNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Cunanmantapacharí noka, Diospa cachaska Runanka, curaj atiyniyoj Dioswan cusca camachisaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tucuy paycunataj taporkancu: —Chanta ¿kanka Diospa Wawanchu canqui? Paytaj nerka: —Nishanquichejjina, noka Diospa Wawan cani, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Chayraycu nerkancu: —Manaña astawan willajcunata munanchejchu, caytaka quiquin siminmanta uyariskanchejraycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Chay israel curajcuna, tucuynincu, camachej Pilatoman Jesusta pusarkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Paypa ñaupakenpitaj tumpayta kallarerkancu. Nerkancutaj: —Cay runapi tarerkaycu llajtaycuta romano camachejpa contranpi ch'ajwachej caskanta. Camachejman impuestota konaycuta jarc'an. Nicunpis pay camachej Cristo caskanta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatori Jesusta taporka: —¿Kanchu israelcunaj camachejnin canqui? Jesustaj payman cuticherka: —Kan ninqui, ajinamin, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilatotaj yupaychana-wasimanta curajcunaman chaypi caj ashqha runasmanwan nerka: —Cay runapeka mana ni ima juchatapis tarinichu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Paycunarí sinch'ita nisharkancu: —Tucuy Israel jallp'api Galilea jallp'amanta kallarispa caycamapis yachachispa ch'ajwachishallanpuni, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Cayta uyarispa Pilatoka taporka: —¿Cay runa Galileamantachu? ");
INSERT INTO quhNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Galileamanta nejtincutaj, Pilatoka Jesusta cacharka camachej Herodesman. Herodeska Galilea runaspa camachejnincu carka. Payka chay p'unchaycunapi Jerusalenpi casharka. ");
INSERT INTO quhNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jesusta ricuspataj mayta cusicorka. Unayña Jesusmanta runas parlaskancuta uyariskanraycu ricuyta munajpuni. Cunanka ñaupakenpi Jesuspa ruwaskan ima ricuchinallatapis ricuyta munasharka. ");
INSERT INTO quhNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ashqha tapunastapis Jesusta tapusharka. Jesusrí Herodesmanka ni imata cuticherkachu. ");
INSERT INTO quhNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Chaypi casharkancu yupaychana-wasimanta curajcuna israel yachachejcunapiwan. Paycunaka sinch'iwan tumpasharkancu Jesusta. ");
INSERT INTO quhNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodestaj soldadosninpiwan Jesusta manacajpaj khawarkancu. Asipayanancupajtaj camachejpa p'achanwanjina p'achalliycucherkancu. Ajinatataj watejmanta Pilatoman cacharka. ");
INSERT INTO quhNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Chay p'unchaypi Herodeswan Pilatowanka allinyanacaporkancu; ñaupajpeka phiñanaska carkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatoka chay curajcunata, runastawan tantachimuspa ");
INSERT INTO quhNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","nerka: —Cay runata pusamuwarkanquichej “runasta ch'ajwachej” nispa. Nokarí ñaupakeyquichejpi ch'ataskayquichejmanta khawaspa, cay runapeka ni ima juchatapis tarerkanichu. ");
INSERT INTO quhNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nillataj Herodespis juchayoj caskanta tarerkachu. Chayraycu cutichimorka. Uyariychej, ni imatapis wañunanpajjinaka ruwarkachu. ");
INSERT INTO quhNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Chayraycu sek'ochispa cacharipusaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pascua p'unchaycunapi Pilatoka costumbrencumanjina cacharinan caj wisk'aska runasmanta ujta. ");
INSERT INTO quhNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Tucuy chay runastaj cusca sinch'itapuni khaparerkancu: —¡Wañuchiy chay runataka! Barrabastataj cacharipuwaycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Chay Barrabaska runasta llajtapi ch'ajwachiskanmanta runa wañuchiskanmantawan wisk'aska carka. ");
INSERT INTO quhNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatoka Jesusta cacharichiyta munaspa ujtawan ch'ajwaj runasman khaparerka. ");
INSERT INTO quhNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Paycunarí aswan sinch'ita khaparerkancu: —¡Payta chacataycuy, payta chacataycuy! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Quinsa caj cutita Pilato paycunaman nerka: —¿Ima mana allintataj ruwarkarí? Ni imatapis wañunanpajjina paypi tarerkanichu. Chayraycu sek'ochispa cacharipusaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Paycunarí Jesús chacataska cananta sinch'ita khaparishallarkancupuni. Paycunataj khapariskancuwan Pilatota atirparkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ajinata Pilatoka camacherka mañaskancumanjina ruwaska cananta. ");
INSERT INTO quhNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Paycunaj mañaskancu Barrabasta cacharerka. Payka runasta ch'ajwachiskanmanta runa wañuchiskanmantawan carcelpi wisk'aska caj, chay runa carka. Jesustarí jaywaycorka khaparejcunaj munaynincumanjina wañuchiska cananta. ");
INSERT INTO quhNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jesusta pusashajtincu Cirene llajtayoj Simonpis Jerusalenman yaycumushallarkataj. Soldadosri payta camacherkancu chacatanata lijraycucuspa Jesuspa khepanta apananta. ");
INSERT INTO quhNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ashqha runas khatisharkancu. Warmispis may phutiywan Jesusmanta wakaspa risharkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesusrí paycunaman cutirispa nerka: —Jerusalén llajtayoj warmis, ama nokamantaka wakaychejchu. Astawanka wakaychej kancuna quiquiyquichejmanta wawasniyquichejmantawan. ");
INSERT INTO quhNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Uyariwaychej: Jamoj p'unchaycunapitaj runaska nenkancu: “Cusiskas cancu mana wawa rejsejcunaka, mana ñuñuchejcunapis”. ");
INSERT INTO quhNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Chanta runas niyta kallarenkancu orkosta: “¡P'ampaycuwaycu!” Lomastataj: “¡Pacaycuwaycu!” nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Mana juchayoj runa k'omer sach'atapis cayjinata cunan ruwashancu. Khepatarí ¿imaynapunichus ch'aqui sach'api ruwaconka? ");
INSERT INTO quhNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Jesusta iscay sajrata ruwajcunatawan pusarkancu wañuchiskas canancupaj. ");
INSERT INTO quhNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Llajta jawa T'ojlu niska lugarman chayaspa soldados chacatarkancu Jesusta chay iscay runa wañuchi suwastawan. Chacatarkancu ujninta Jesuspa pañannejpi ujnintataj llok'ennejpi, sapa ujta waj chacatanapi. ");
INSERT INTO quhNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesustaj payta chacatashajtincu nisharka: —Tatáy, paycunata perdonay ruwashaskancuta mana yachaskancuraycu, —nispa. Soldadostaj paycunapura suerteta chokarkancu yachanancupaj pipajchus Jesuspa p'achasnin cananta. ");
INSERT INTO quhNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Runastaj sayaskas khawasharkancu. Curajcunari Jesusta manacajpaj khawaspa asipayarkancu. Nisharkancutaj: —Wajcunata cacharicherka. Sichus chay runa Cristo, Diospa ajllaskan chayka, pay quiquinta cacharichicuchun, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soldadospis Jesusta asipayashallarkancutaj, akhancuta ujyachinancupaj kayllaspa. ");
INSERT INTO quhNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Paycuna nisharkancu: —Sichus kan israelcunaj camachejnin canqui chayka, kan quiquiyquita cacharichicuy, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Tucuy runas yachanancupaj imaraycuchus Jesús chacataska caskanta uman patanejpi kelkaska carka: Cay runaka israelcunaj camachejninmin. ");
INSERT INTO quhNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Runa wañuchi suwas warqhuska casharkancu, paycunamanta ujnintaj Jesusta millayta c'amisharka: —¿Manachu kanka Diospa ajllaskan Cristo canquirí? Cacharichicuy, nokaycutapis cacharichiwaycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","41","Ujninrí payta rimaspa nerka: —¿Manachu kan Diosta manchachicunqui? Nokanchej juchanchejmanjina juchachaskas canchej ñac'arinapajjina ruwaskanchejraycu. Cay runarí ni ima mana allintapis ruwarkachu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Jesustataj nerka: —Jesusníy, camachinqui, chaypacha yuyaricuway, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesustaj payman cuticherka: —Chekatapuni niyqui cunan p'unchaymin janaj pachapi nokawan cusca canayquita, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Chaupi p'unchayjinaña cashajtin tucuy jallp'api lakhayaycorka chaupi tardecama. ");
INSERT INTO quhNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Intipis mana c'ancharkañachu. Yupaychana-wasipi warqhuska caj khatanaka cuscanninmanta iscayman lliq'icorka. ");
INSERT INTO quhNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesustaj sinch'ita khaparerka: —Tatáy, maquisniyquiman causayniyta jaywacuyqui, —nispa. Chayta nispataj tucucaporka. ");
INSERT INTO quhNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Romano capitán chayta ricuspa Diosta yupaycharka. Nerkataj: —Chekamanta payka chekan runa carka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tucuy chay ashqha khawaj jamojcuna ruwaskancuta ricuspa llajtaman cutipusharkancu. Phuticuskancuta ricuchinancupaj pechoncuta tacacuspa risharkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jesuspa tucuy allin rejsiskasnin carunejpi sayacusharkancu ruwacuskanta ricunancupaj. Galileamanta Jesusta khatimoj warmispis chaypi casharkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Carka uj runa israel curajcunaj tantacuyninmanta, José sutiyoj. C'acha runa chekanta ruwaj carka. ");
INSERT INTO quhNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Payka curajcunaj yuyaskancuwan ruwaskancuwanpis mana ujllachu carka. Israel llajta Arimateamanta carka. Dios tucuy runasta camachinanta mayta munaj. ");
INSERT INTO quhNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Payka camachej Pilatoman rispa Jesuspa cuerponta mañarka apacapunanpaj. ");
INSERT INTO quhNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Chacatanamanta uraycuchispataj linomanta awaskawan mayt'uycorka. Chanta uj orko rumipi jusc'uska p'ampanaman Jesusta p'ampaycorka. Jatun muyu p'alta rumitataj p'ampana puncuman churarka. Chay p'ampanapeka ni uj ayapis churaskarajchu carka. ");
INSERT INTO quhNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Samacuna p'unchaypis kallaricusharkaña. Waquichicuna p'unchay carka. ");
INSERT INTO quhNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galileamanta Jesuswan jamoj warmispis Joséj khepanta khaticorkancu. Ricorkancutaj p'ampana jusc'uta, imaynatachus Jesús p'ampaska caskantapis. ");
INSERT INTO quhNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Llajtaman cutimuspataj k'apajcunata jawinatawan waquicherkancu. Samacuna p'unchaypiri Diospa camachiskanmanjina samacorkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Semana kallariy Domingo p'unchayta allin tutamanta cay warmiska p'ampanaman cuterkancu. Chay waquichiskancu k'apayniyoj jampista aparkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Warmiska chay jatun rumita p'ampanamanta wajnejman muyurparichiskata tarerkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Yaycusparí Señor Jesuspa wañuska cuerponta mana tariparkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Chay imasmanta ni imata ruwayta yacharkancuchu. Ajinallapi iscay kharis lliphipej p'achasniyoj sayashaj paycunaman riqhurerkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Warmiska manchachicuywan mana khawariyta munarkancuchu. Kharistaj paycunata nerkancu: —¿Imaraycutaj causashajta wañuskas chaupipi masc'ashanquichej? ");
INSERT INTO quhNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Jesuska mana caypichu, causarimpunña. Yuyaricuychej Galilea jallp'apiraj cashaspa nisuskayquichejmanta. ");
INSERT INTO quhNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Payka nerka: “Noka, Diospa cachaska Runan, juchasapa runaspa atiynincuman jaywaska chacataskataj canay tiyan. Quinsa caj p'unchaypitaj causarimpunay tiyan”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Warmistaj Jesuspa niskasninta yuyaricorkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","P'ampanamanta cutimuspataj tucuy chay imasta chunca ujniyoj Jesuspa cachasninman willarkancu, tucuy paycunawan cajcunamanpis. ");
INSERT INTO quhNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Chayta willajcuna carkancu Magdala llajtayoj María, Juana, Jacoboj maman Mariawan. Paycunawan waj warmispis chay imasta cachasninman willashallarkancutaj. ");
INSERT INTO quhNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Cachasmanrí chay niskancoka mana yuyayniyojmanjina rijch'acorka, manataj creerkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pedrorí jataricuspa p'ampanaman correrka. C'umuycuspataj Jesuspa mayt'unasninta ch'usajllata ricorka. Payri chay ruwacuskanmanta t'ucuspa wasinman riporka. ");
INSERT INTO quhNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Chay p'unchayllapitaj iscay yachacojcuna risharkancu Emaús niska ranchoman. Jerusalenmanta iscay leguasjina carka. ");
INSERT INTO quhNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Chay p'unchaycunapi tucuy ruwacuskanmanta, rishaspa parlanacusharkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Chay ruwacuskanta parlanacushajtincu mayta yuyashajtincu ima, quiquin Jesús taripaycorka. Paycunawan risharka. ");
INSERT INTO quhNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ricushaspapis mana Jesusta rejsiyta aterkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesustaj paycunata taporka: —Ñanta purispa ¿imamantataj sinch'ita parlanacushanquichej? Paycunari sayarkancu ancha llaquiska uyaslla. ");
INSERT INTO quhNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ujnin paycunamanta, Cleofas sutiyoj, cuticherka: —Kanka purej runallachá cawaj, cay p'unchaycuna Jerusalenpi ruwacuskanta mana yachaspaka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Chanta Jesús paycunata taporka: —¿Imataj ruwacorkarí? Paycunataj cuticherkancu: —Nazaret llajtayoj Jesusta ruwaskancuta. Payka Diospa willajnin caskanta ricucherka jatunta ruwaskanwan yachachiskanwan. Atiyniyoj carka Diospa khawayninpi runaspa ñaupakencupipis. ");
INSERT INTO quhNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Cayjina carka: Yupaychana-wasimanta curajcunanchej camachejcunanchejpiwan Jesusta jaywaycorkancu wañuyman juchachaska cananpaj. Chacatacherkancutaj. ");
INSERT INTO quhNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nokaycurí yuyasharkaycu pay israel runasta cacharinanta. Chaywanpis cunanwan Jesusta chacatachiskancoka quinsa p'unchayña cashan. ");
INSERT INTO quhNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Cunanrí cay tiyan: Nokaycumanta waquin warmis tutamanta p'ampanaman rispa t'ucuchiwarkaycu. ");
INSERT INTO quhNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Jesuspa cuerponta mana taripaskancuchu. Cutimuspataj nishawarkaycu moskoypijina angelesta ricuskancuta niskancutataj Jesús causashaskanta. ");
INSERT INTO quhNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Chaywanpis nokaycumanta waquin runas p'ampanaman rerkancu. Warmis niskancumanjinataj taripaskancu. Jesustari mana ricuskancuchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jesustaj paycunata nerka: —¡Ancha pisi yuyayniyoj canquichej! ¡Diospa unay willajcunanpa tucuy willaskancutapis ñac'aypi creej sonko canquichej! ");
INSERT INTO quhNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Diospa ajllaskan Cristoka chekamanta ñac'arinan carka. Chaymantataj Tatan Dioswan wiñaypaj jatunchaska canan carka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Chaymanta paycunaman Jesús sut'incharka Diospa tucuy palabranpi paymanta cajta. Moisespa kelkaskasninmanta kallarispa Diospa tucuy unay willajcunanpa kelkaskasnintawan sut'incharka. ");
INSERT INTO quhNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Yachacojcuna risharkancu, chay Emausman kayllamorkancu. Jesustaj rejjinallapuni churacorka. ");
INSERT INTO quhNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Paycunataj jarc'arkancu: —Nokaycuwan khepacuy ch'isiyaycushaskanraycu, —nispa. Jesustaj wasiman yaycorka paycunawan khepacoj. ");
INSERT INTO quhNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Payka paycunawan miqhunanpaj tiyaycucuytawan t'antata jap'ispa Diosman graciasta korka. T'antata partispataj paycunaman jaywarka. ");
INSERT INTO quhNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ajinallapi Jesús caskanta reparaspa rejsirparekancu. Paytaj paycunamanta chincariporka. ");
INSERT INTO quhNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Paycunari ninacorkancu: —Ñanpi parlawashajtinchej Diospa palabranta sut'inchawajtinchejpis ¡mayta sonkosninchejka cusiywan t'ucusharkancu! ");
INSERT INTO quhNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Chay ratutaj chay iscayka jataricuspa Jerusalenman cutiporkancu. Jakaypi tariparkancu tantaskastaña chay chunca ujniyoj Jesuspa cachasninta paycunawan cajcunatawan. ");
INSERT INTO quhNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Tantaskacunataj nisharkancu: —Chekamanta yachanchej Señorka causarimpuskanta. Simonpis payta ricuska, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Chanta chay iscay paycunaman willasharkancu ñanpi paycunawan caskanmanta. Imaynatachus t'antata partishajtin Jesusta rejsiskancuta willasharkancutaj. ");
INSERT INTO quhNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Chay imasmanta parlashajtillancuraj Jesuska chaupincupi sayashaj riqhurerka. Napaycorkataj: —Kancunapaj c'acha causay cachun, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Paycunataj mayta mancharicorkancu almata ricuskancuta yuyaspa. ");
INSERT INTO quhNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jesusri paycunata nerka: —¿Imaraycutaj manchariskas cashanquichej? ¿Imaraycutaj sonkoyquichejpi iscayrayashanquichej? ");
INSERT INTO quhNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Khawaychej maquisniyta chaquisniytawan. Nokaka quiquiymin cani. Llanqhariwaychej reparanawayquichejpaj. Almaka mana aychayojchu nitaj tulluyojchu. Ricushawanquichejjina, noka aychayoj tulluyoj cani, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Cayta nispataj Jesuska maquisninta chaquisnintawan paycunaman ricucherka. ");
INSERT INTO quhNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Cusiymanta t'ucuymantawan manaraj creerkancuchu Jesús caskanta. Iscayrayashajtincutaj Jesús taporka: —¿Caypi canchu imallapis muqhunapaj? ");
INSERT INTO quhNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Paycunataj uj chhican challwa cancata lachiwana misq'itawan payman jaywarkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Paytaj chayta jap'ispa ñaupakencupi miqhorka. ");
INSERT INTO quhNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Paycunatataj nerka: —Kancunawanraj cashaspa caycunata nerkayquichej: Tucuy nokamanta kelkaska junt'acunan tiyan, Moisespa kelkaskan, unay willajcunaj kelkaskancu, taquina libropipis, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Chanta tucuy chay imasta paycunaman sut'incharka yuyaynincuwan Diospa palabranta entiendenancupaj. ");
INSERT INTO quhNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nillarkataj: —Dios palabranpi nin paypa ajllaskan Cristo wañunanta, quinsa p'unchaypitaj causarimpunanta. ");
INSERT INTO quhNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Sutinpitaj willaracunan tiyan runas Diosman cutiricunancuta juchasnincu khechuska canancupaj. Tucuy jallp'api tiyacojcunaman willaraska canan tiyan kallarispa Jerusalenpi. ");
INSERT INTO quhNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kancuna cay imasta ricuskayquichejraycu willajcuna canquichej. ");
INSERT INTO quhNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Sumajta uyariwaychej. Tatay cachamuskayquichej sumajta nerka, paytaka noka quiquiy cachamuskayquichej. Kancunarí Jerusalenpi suyashaychej Diospa atiyninwan junt'aska canayquichejcama, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Chaymanta Jesuska Betania ranchonejman yachacojcunanta pusarkorka. Maquisninta patancunejman aysarispataj nerka: —¡Dios kancunawanpuni cachun! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Chayta niytawantaj Jesuska paycunamanta riporka. Janaj pachaman okhariska carka. ");
INSERT INTO quhNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Yachacojcunaka Jesusta yupaycharkancu. Jatun cusiywantaj Jerusalenman cutimporkancu. ");
INSERT INTO quhNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Diosta jatunchaspa yupaychana-wasipipuni carkancu. Ajina cachun.");
INSERT INTO quhNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kallaricuypi carkapuniña causayniyoj Niskaka. Chay Niskataj Dioswan cusca carka Diospuni caspa. Paymin Jesucristoka. ");
INSERT INTO quhNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Paytaj carka Dioswan cusca kallariypi. ");
INSERT INTO quhNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Diostaj tucuy cajta ruwarka paynejta. Ruwaska cajmanta ni imapis canchu mana paynejta ruwaskaka. ");
INSERT INTO quhNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Payllataj tucuy causashajman causayta kon. Causayninnejta runasman yuyayta kon Diosta rejsinancupaj. Chay paymanta yuyayka sonkoncupi c'anchayjinamin. ");
INSERT INTO quhNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Cristoka c'anchaymin, jucharí lakhayaymin. Imaynatachus c'anchayka lakhayayta atipan, ajinallatataj Cristoka juchata atipan. ");
INSERT INTO quhNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Diospa cachamuskan runa riqhurimorka. Paypa sutintaj Juan. ");
INSERT INTO quhNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Payri cheka cajta willananpaj jamorka. Willarkataj cheka c'anchay Jesucristomanta, paynejta tucuy runas Diospi jap'icunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juanka mana chay cheka c'anchaychu carka. Manachayrí chay c'anchaymanta runasman willanallanpaj carka. ");
INSERT INTO quhNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Chay cheka c'anchayrí causayniyoj Niskamin. Tucuy runaj yuyayninman c'anchamoj c'anchayka Diosmanta cay pachaman yaycumusharkaña. Yaycumusharka juchata atipaj. ");
INSERT INTO quhNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Payka cay pachapi casharka runas chaupipi. Cay pachataj paynejta ruwaska carka. Cay pacha runastaj mana payta rejserkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Paypata cajman jamorka. Paypata caj runasninrí mana payta jap'iyta munarkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Astawanpis tucuy paypi jap'icojcunamanrí atiyta korka Diospa wawasnin canancupaj. Paycunaka Diospa Wawan Cristopi jap'icojcuna cancu. ");
INSERT INTO quhNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Chaywanpis Diosnejta nacecuspa wawasnin cancu paypi jap'icuskancuraycu. Manataj cay pacha runaj nacecuyninmanjinachu, ni cay pacha runaj munayninnejtachu, nitaj kharej yuyayninnejtachu Diospa wawasnin cancu. ");
INSERT INTO quhNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Chay Niska, Cristoka, runaman tucuspa nacecorka. Payri nokaycuwan tiyacorka. Paypi Diospa cayninta ricorkaycu. Dios Tataj c'ata Wawan caskanraycutaj paypeka Diospa cayninta ricorkaycu. Cristoka c'acha cayninwan cheka cajwanpis junt'amin. ");
INSERT INTO quhNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Paymantataj Juan tucuyman sut'ita willaraj. Nejtaj: —Cay runamantamin nerkayquichej, khepayta jamojka nokamanta may curajpaj churaska caskanta. Payka manaraj nacecushajtiy carkapuniña, chayraycumin nokamantaka curaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Cristoka tucuy c'acha cayninwan tucuy nokanchejta yanapawarkanchej. Chay c'acha yanapayninmanta astawan astawanraj jap'ishanchej. ");
INSERT INTO quhNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Unayñamin Dios camachiskasninta Moisesnejta israelcunaman korka. Astawanpis cunanka c'acha yanapayninta cheka cajtapis Jesucristonejta kowanchej. ");
INSERT INTO quhNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ni pi ni jayc'ajpis Dios Tatata ricorkachu. C'ata Wawan, Dios caspa, munacuypi yuyaypipis Tatanwan ujllamin. Chayraycu paylla Dios Tatanta sut'inchawarkanchej. ");
INSERT INTO quhNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusalén llajtamanta israel curajcuna cacharkancu yupaychana-wasipi ruwanayojcunata yanapajcunatawan Juanta tapunancupaj: —¿Kan, pitaj canquirí? ");
INSERT INTO quhNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Juantaj cutichispa sut'ita willarka: —Mana nokaka Diospa ajllaskan Cristochu cani, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tapullarkancutaj: —Chanta ¿kan unay willaj Eliaschu canqui? Payri cuticherka: —Mana Eliaschu cani, —nispa. Ujtawan tapullarkancutaj: —¿Diospa willajnin jamunan cashan, chaychu canqui? Paytaj cuticherka: —Mana paychu cani, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Chayraycu payta nerkancu: —Willawaycu pichus caskayquita cachamuwarkaycu, chaycunaman willanaycupaj. Kan quiquiyquimanta ¿imatataj ninquirí? ");
INSERT INTO quhNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juantaj nerka: —Nokaka ch'in pampapi khaparej runa cani. Diospa unay willajnin Isaiaspa niskanmanjina niyquichej: “Señorninchej jamunanpaj sonkoyquichejta waquichicuychej”, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Chay tapojcunaka fariseospa cachamuskasnincu carkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Taporkancutaj: —Mana Cristo caspa nitaj Elías nillataj chay jamoj willajpis caspa ¿imaraycutaj bautizashanquirí? ");
INSERT INTO quhNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juantaj paycunaman cuticherka: —Juchancumanta Diosman cutirejcunata noka yacunejta bautizashani. Astawanpis chaupiyquichejpiña cashan uj runa. Paytari mana rejsinquichejchu. ");
INSERT INTO quhNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Khepaytaña jamushan. Nokarí mana paypa camachinpajjinallapischu cani, runalla caskayraycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ajina carka Betábara, Jordán mayoj chimpanpi, Juan bautizasharka chaypi. ");
INSERT INTO quhNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Khepan p'unchaytaj payman jamushajta Jesusta ricuspa Juan nerka: —¡Caymin Diospa Corderonka! Dios payta jaywanka cay pacha runaspa juchancuta khechunanpaj. ");
INSERT INTO quhNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Paymantamin nerkayquichej, khepayta jamoj khareka nokamanta may curajpaj churaska caskanta. Payka manaraj nacecushajtiy carkapuniña. ");
INSERT INTO quhNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ni nokapis Diosmanta caskanta yacharkanichu. Astawanpis Dios cachamuwarka yacupi bautizaspa israelcunaman Cristota rejsichinaypaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Juanka caytapis willarka: —Ricorkani Santo Espirituta palomatajina janaj pachamanta uraycamushajta, Jesuspitaj tiyaycushajta. ");
INSERT INTO quhNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ni nokapis pi caskanta rejserkanichu. Astawanrí yacupi bautizanaypaj cachamuwaj Dios niwarka: “Santo Espirituta ricunqui uraycamushajta uj runapi tiyaycushajtataj. Cayta ricuspamin yachanqui chay runaka Santo Espiritupi bautizaj caskanta”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nokaka ricorkaniña willaniñataj pay Diospa Wawan caskanta, —nerka Juan. ");
INSERT INTO quhNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Khepan caj p'unchaypi watejmanta Juan iscay yachacojcunanwan sayaricorka. ");
INSERT INTO quhNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Chaynejpi Jesusta purishajta khawaspataj nerka: —¡Caymin Diospa Corderonka! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Chay iscay yachacojcunataj Juanpa niskanta uyarispa Jesusta khaterkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesusri khatejcunaman cutiricamuspa paycunata khawarerka. Nerkataj: —¿Imatataj munanquichejrí? Paycunataj nerkancu: —Yachachejníy ¿maypi tiyaricushanqui? ");
INSERT INTO quhNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesuska paycunaman nerka: —Jamuychej, ricuchiskayquichej, —nispa. Paywantaj rerkancu maypichus tiyaricusharka, chayman. Chaupi p'unchay pasaskaña. Chay p'unchaypitaj Jesuswan khepacorkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Juanta uyarispa Jesusta iscay khatejcunamanta ujnenka Andrés sutiyoj carka. Payka Simón Pedroj wauken carka. ");
INSERT INTO quhNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Payri ñaupajta wauken Simonta tarerka. Nerkataj: —Chay Mesiasta tariycu, —nispa. Mesías niyta munan Diospa ajllaskan Cristo. ");
INSERT INTO quhNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nispataj Jesusman pusarka. Jesustaj allinta payta khawarisparí nerka: —Kan canqui Simón, Jonaspa wawan. Sutiyqui canka Pedro, —nispa. Pedro niyta munan jatun rumi. ");
INSERT INTO quhNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Khepan p'unchayta Jesús Galilea jallp'aman rinanpaj llojsisharka. Felipewan tincuspataj nin: —Jamuy, yachacojniy cay, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Feliperi Betsaida llajtamanta carka. Chayllamantataj Andreswan Pedrowanpis carkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipe Natanaelta tarispa nin: —Yachanqui camachiskaspi Moisés uj runamanta kelkaskanta. Paymanta Diospa unay willajcunanpis kelkarkancu. Paytamin tariycu, Joséj wawan Nazaret llajtayoj Jesusta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaeltaj payta tapun: —¿Ima allintaj Nazaretmanta jamunman? Feliperi cutichin: —Jamuy ricunayquipaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesús Natanaelta jamushajta ricuspa nin: —¡Caymin cheka israel runaka, tucuy sonkowan Diosta yupaychaj! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaelri payta tapun: —¿Imaynapitaj rejsiwanquirí? Jesustaj cutichin: —Manaraj Felipe wajyashasojtin higo sach'a urapi cashajtiyqui ricorkayquiña, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael payman nin: —¡Yachachejníy, kanmin Diospa Wawan canqui, israelcunaj Camachejnin! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesustaj payman cutichispa nin: —Higo sach'a urapi ricorkayqui, nisuskayraycu nokapi jap'icushanqui. Astawan jatun imastaraj ricunqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nillantaj: —Chekatapuni niyquichej: Janaj pachata quichariskata ricunquichej, Diospa angelesnintapis chayman rishajta uraycamushajtataj noka, Diospa cachaska Runanman, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Quinsa caj p'unchaypi Galilea jallp'a Canapi uj casamiento carka. Chaypitaj Jesuspa maman casharka. ");
INSERT INTO quhNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesuspis yachacojcunanwan chay casamientoman wajyariskas carkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Vino tucucapojtintaj maman Jesusta nin: —Manaña vinoncu canñachu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesustaj nin: —Mamáy, chayka nokallamanta. Horayka manaraj chayamunchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mamanri yanapajcunaman nin: —Imatachus nisonkachej chayta ruwaychej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Chaypitaj carka rumimanta sojta yacu p'uñus israelcuna llimphuchacunancupaj churaska. Chay p'uñusmanka sapa ujman pachaj botellajina yaycoj. ");
INSERT INTO quhNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesustaj paycunata nin: —Chay p'uñusman yacuta junt'achiychej, —nispa. Wasarishajta junt'acherkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jesustaj paycunata nin: —Cunan wiserkospa apaychej dispenseroman, —nispa. Paycunataj aparkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Dispenseroka yacumanta ruwaska vinota mallerka. Payri mana yacharkachu maymantachus caskanta. Yacu wisej yanapajcunalla yacharkancu. Chaymanta dispenseroka casaracojta wajyaspa nin: ");
INSERT INTO quhNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","—Tucuy runamin ñaupajta sumaj caj vinota runasman jaywan. Runas sajsajtincutaj khepata lak'allataña jaywan. Kanrí cay sumaj vinota cunancama wakaychaskanqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Cay ricuchinaspa kallariyninta Jesús ruwarka Galileapi caj Caná llajtapi. Chayta ruwaspa atiyninta runasman ricucherka. Yachacojcunantaj paypi jap'icorkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Chaymanta Jesús Capernaum llajtaman riporka. Pay, maman, waukesnin, yachacojcunan rerkancu. Chaypi pisi p'unchaycunallatawanña cacorkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Israelcunaj pascua p'unchaycunancu kayllamusharkaña. Jesustaj Jerusalén llajtaman rerka. ");
INSERT INTO quhNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Chayaspataj yupaychana-wasej pationpi tariparka chay vendej runasta. Paycuna vendej cancu Diosman jaywanaspaj bueycunata, ovejacunata, palomacunata. Taripallarkataj kolke cambiajcunata tiyaskasta. ");
INSERT INTO quhNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Chaypi caj phalasmanta sek'onata ruwaspa Jesús yupaychana-wasimanta tucuy paycunata kharkomorka ovejasnincutawan bueyesnincutawanpis. Cambiajcunaj kolkesnincuta jich'arka mesasnincutapis tijrarka. ");
INSERT INTO quhNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Palomata vendejcunaman nerkataj: —Caycunata jawaman apaychej. Amañataj Tataypa wasinta khatu wasiman tucuchiychejchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Yachacojcunanri Diospa palabranpi cay niskanta yuyaricorkancu: “Yupaychana-wasiyquita tucuy sonkoywan munacuskayraycu wakaychanaypaj causayniyta kosaj”. ");
INSERT INTO quhNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Israel curajcuna chay ruwaskanmanta Jesusta nerkancu: —Nokaycuman ricuchiwaycu ima atiywanchus chayta ruwaskayquita, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesustaj paycunaman cuticherka: —Ruwaskayquichejwan tucuchillaychej cay yupaychana-wasita. Nokataj quinsa p'unchaypi cayta jatarichisaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Chay curajcunataj nerkancu: —Tawa chunca sojtayoj wataspi wasichacushan cay yupaychana-waseka. Kanrí ¿quinsa p'unchaypichu cay yupaychana-wasita jatarichiwaj? —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Caytarí mana chay yupaychana-wasimantachu Jesús nerka. Manachayrí quiquin cuerponmanta parlasharka. ");
INSERT INTO quhNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jesús wañuymanta causarimojtin yachacojcunan yuyaricorkancu chayta niskanta. Diospa palabrantataj creerkancu, Jesuspa niskantapis. ");
INSERT INTO quhNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pascua p'unchaycunapi Jerusalenpi Jesús cashajtin ashqhas paypi jap'icorkancu ricuchinasta ruwaskanta khawaspa. ");
INSERT INTO quhNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jesusrí tucuy runaj yuyayninta yachaskanraycu paycunaman mana confiacorkachu. ");
INSERT INTO quhNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Runaj sonkonta pay quiquin rejsiskanraycutaj runamantaka mana willanatachu suyanan caj. ");
INSERT INTO quhNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Fariseocunamanta uj runa carka Nicodemo sutiyoj. Payka israel curajcunamanta carka. ");
INSERT INTO quhNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Cay runaka tuta Jesusman jamuspa payta nerka: —Yachachejníy, yachaycu Diosmanta cachamuska yachachej caskayquita. Mana Dios paywan cajtenka ni pipis ruwayta atinmanchu kanpa ruwaskayquijina ricuchinastaka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesusri payman nerka: —Chekatapuni niyqui: Diosta Camachejninpaj rejsinanpaj uj runa watejmanta naceska canan tiyan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemo payta nerka: —¿Imaynatataj uj runa machuña caspa watejmanta nacecuyta atinman? ¿Imaynataj chayrí? Ni jayc'aj atinmanchu uj runa mamanpa wijsanman ujtawan yaycuyta nacecuytatajka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesusri cuticherka: —Chekatapuni niyqui: Diosta Camachejninpaj rejsinancupaj uj runaka yacunejta Santo Espiritunejtapis nacecunan tiyan. Ajinapi juchamanta llimphuchaska cajtin, Santo Espíritu mosoj causayta kon. ");
INSERT INTO quhNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Runamanta nacecojka runalla. Santo Espiritumanta nacecojrí Diospa wawanmin. ");
INSERT INTO quhNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ama t'ucuychu, “Watejmanta nacecunayquichej tiyan”, nisuskaymanta. ");
INSERT INTO quhNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Wayraka maymanchá munan chayman wayrallan. Wayraskanta uyarispataj wayra caskanta reparanqui. Maymanta jamuskanta mayman riskantataj mana yachanquichu. Ajinamin Santo Espiritumanta nacecojka, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemotaj payta taporka: —¿Imaynataj cayka canmanrí? ");
INSERT INTO quhNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesustaj payman cuticherka: —Chay israelcunaj yachachejnin canqueka. ¿Manachu yachanqui cay imasmanta? ");
INSERT INTO quhNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Chekatapuni niyqui: Yachaskaycu chayta parlaycu, ricuskaycu chaytataj willaycu. Willaskaycutari mana jap'inquichejchu. ");
INSERT INTO quhNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Cay pacha imasmanta nerkayquichej manataj creerkanquichejchu. Chanta ¿imaynatataj creewajchej janaj pacha imasmanta willayquichejman chayka? ");
INSERT INTO quhNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","‘Ni pipis janaj pachaman wicharerkachu, manachayrí janaj pachamanta uraycamojlla, Diospa cachaska Runallan. Payka Dioswanpuni tiyacun. ");
INSERT INTO quhNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moisespis unayña ch'in pampapi uj catarita c'aspipi warqhuspa okharerka onkoska runas khawanancupaj. Diospi jap'icuspa, chay catarita khawaskancuraycu, Dios paycunata thañicherka. Ajinallataj Diospa cachaska Runan okhariska canan tiyan ");
INSERT INTO quhNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","tucuy runa paypi jap'icojka wiñay causayniyoj cananpaj. ");
INSERT INTO quhNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Dioska tucuy runasta maytapuni munacorka. Chayraycumin c'ata Wawanta korka. Cay pachaman payta cachamorka paypi tucuy jap'icojka ama wiñaypaj wañupunanpaj astawanrí wiñay causayniyoj cananpaj. ");
INSERT INTO quhNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Diosrí mana cay pacha runasta juchachananpajchu Wawanta cachamorka, manachayrí cay pacha runas paynejta juchamanta cachariskas canancupaj. ");
INSERT INTO quhNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Paypi jap'icojka mana juchachaskachu. Paypi mana jap'icojrí juchachaskañamin, Diospa c'ata Wawanpi mana jap'icuskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Cheka c'anchay Cristoka tucuy runasman jamorka. Runastaj sajra lakhayayta astawan munacorkancu paymanta niskaka, ruwaskasnincu sajra caskanraycu. Chayraycu Dioska paycunata juchachan. ");
INSERT INTO quhNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Sapa uj manacajta ruwajka cheka c'anchayta chejnin. Manataj Cristoman jamunchu ruwaskasnin sajra caskan mana ricuchiska cananpaj. ");
INSERT INTO quhNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Cheka cajta ruwajrí Cristoman jamun sumaj ruwaskasnin sut'i ricuchiska cananpaj, Diospa atiyninnejta ruwaska caskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Chay khepata Jesús yachacojcunanwan llojserka Judea jallp'aman. Chaypitaj caricorka paycunawan runasta bautizaspa. ");
INSERT INTO quhNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juanpis bautizashallarkataj Enonpi Salim kayllapi, chaypi ashqha yacu caskanraycu. Runastaj jamullaj cancu bautizacoj. ");
INSERT INTO quhNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Juanri manaraj carcelpi wisk'askarajchu carka. ");
INSERT INTO quhNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ajinapi chay bautismo jawa uj jap'inacuy kallaricorka Juanpa yachacojcunanwan uj israel runawan. ");
INSERT INTO quhNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Yachacojcunantaj Juanman jamuspa nerkancu: —Yachachejníy, Jordán mayu chimpapi kanwan carka chay runa, paymanta willarkanquipis. Chay runaka cunan bautizashan tucuytaj payman rishancu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juantaj cuticherka: —Dios kojtillan runaka imatapis jap'iyta atin. ");
INSERT INTO quhNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kancuna quiquiyquichej yachanquichej cay niskayta: Noka mana chay Cristochu cani. Manachayka paypa ñaupakenta Diospa cachamuskallan cani, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nerkataj: —Casamientopijina casaracoj kharimin curajpaj khawaskaka casaracushaskanraycu. Amigonrí paywan cashaspa payta uyarispataj anchata cusicun. Ajinallataj nokapis may cusiska cani Jesús jatunchaska caskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Payka astawan astawanraj curajpaj khawaska canan tiyan. Nokataj astawan pisillapajña khawaska canay tiyan. ");
INSERT INTO quhNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","‘Diosmanta jamojka tucuy runasmanta aswan atiyniyojmin, payka aswan curaj caskanraycu. Cay pachamanta runaka cay pacha imasllamanta parlan cay pachallamanta caskanraycu. Diosmanta jamojrí tucuy runasmanta aswan curajmin. ");
INSERT INTO quhNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Diosmanta ricuskanta uyariskantataj willan. Runasrí willaskasninta mana jap'incuchu. ");
INSERT INTO quhNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Willaskanta jap'icoj runarí ricuchin Dios wiñaypaj cheka caskanta. ");
INSERT INTO quhNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Diospa cachamuska Wawanka Diospa niskasninta parlan. Diostaj Espiritunta mana mich'acuspa payman kon. ");
INSERT INTO quhNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Dios Tataka Wawanta munacun, tucuy imatataj churarkaña paypa atiyninpi cananpaj. ");
INSERT INTO quhNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Wawanpi jap'icojka wiñay causayniyojmin. Wawanpi jap'icuyta mana munajrí wiñay causayman mana yayconkachu. Astawanpis Diospa c'ajaj phiñacuynin chay runapaj wiñaypaj cashan, —nerka Juan. ");
INSERT INTO quhNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Fariseos uyarerkancu astawan ashqha runas Jesusta khatishaskancuta Juanmanta niskaka. Payka astawan ashqha runasta bautizashanpis, niskata. ");
INSERT INTO quhNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Manapis quiquin Jesús bautizarkachu, manachayrí yachacojcunan. ");
INSERT INTO quhNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jesús yacharka fariseos chayta uyariskancuta. Chayraycu Judeamanta llojsispa ujtawan Galileaman cutimorka. ");
INSERT INTO quhNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Samaria jallp'anejta rinan carka. ");
INSERT INTO quhNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ajinapi Samaria jallp'api uj llajtaman chayamorka, Sicar sutiyojman. Chay llajtari Joséj jallp'an kayllapi carka. Tatan Jacobka unayña chay jallp'ata Joseman koska. ");
INSERT INTO quhNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Chaypitaj Jacobpa yacu pujyun carka. Puriskanmanta ancha sayc'uska caspa Jesuska pujyu canto perkapi tiyaricorka samaricunanpaj. Chaupi p'unchayjinaña carka. ");
INSERT INTO quhNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Jesusta sapallanta sakespa yachacojcunan llajtaman miqhunata rantej rerkancu. Chaycamataj uj samaria warmi Sicarmanta yacuta orkhoj jamorka. Jesustaj payta nin: —Yacuta koriway, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Chay warmitaj Jesusman nin: —Israel runa caspa ¿imaynatataj noka samaria warmimanta yacuta mañacuwanquirí? Israelcuna samariacunawan mana parlajchu cancu. Chayraycu warmeka ajinata taporka. ");
INSERT INTO quhNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesusri payman cutichin: —Dios mana mich'acuspa runasman koskanta, ichapis mana yachanquichu. “Yacuta koriway”, nisojtapis ichapis mana rejsinquichu. Yachawajchus chayka, kan nokamanta mañacuwanquiman carka. Nokataj causachej yacuta koyquiman carka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Warmi payman nin: —Señor, aysanayqui mana capusunquichu, pujyupis ancha uqhurajtaj cashan. ¿Maymantataj chay causachej yacu capusunquimanrí? ");
INSERT INTO quhNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ñaupa tatanchej Jacob cay pujyuta kowarkanchej. Cay pujyumanta pay, wawasnin, uywasnincupis ujyarkancu. Cunan ¿kan aswan curajchu paymanta cawaj? ");
INSERT INTO quhNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesusri payman cutichin: —Cay yacumanta ujyajka watejmanta ch'aquichicun. ");
INSERT INTO quhNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Nokaj koskay yacuta ujyajrí wiñaypaj ni jayc'ajpis ch'aquichiconkachu. Astawanpis koskay yacoka paypi yacu pujyujina canka. Wiñay causaypaj phullchimonka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Warmeka payman nin: —Señor, chay yacuta koriway ama ch'aquichicunaypaj nitaj cayman yacuman jamunaypajpis, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesustaj payta nin: —Riy, kosayquita wajyamuy. Chanta cutimuy, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Warmeka cutichin: —Mana kosayojchu cani, —nispa. Jesusri payman nin: —Chekata ninqui, mana kosayoj caskayquitaka. ");
INSERT INTO quhNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Phishka cuti kharilliskaña canqui. Cunan causashanqui, chaytaj mana kosayquichu. Caytaka chekata ninqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Warmi payman nin: —Señor, Diospa willajnin caskayquita reparani. ");
INSERT INTO quhNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Chayraycu caymanta yachayta munani: Tatasniycu nincu, cay orkopi yupaychanata. Kancuna israelcunataj ninquichej, Jerusalenllapi yupaychana caskanta. ¿Kanrí, ima ninquitaj? ");
INSERT INTO quhNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesustaj payman nin: —Doña, cay nisuskayta creey: Uj sumaj p'unchay chayamunña. Chay p'unchaypi Dios Tatata yupaychanquichej ni cay orkopichu nitaj Jerusalenpipischu. ");
INSERT INTO quhNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mana entiendeskayquichejta kancunaka yupaychanquichej. Nokaycutaj rejsiskaycuta yupaychaycu. Runasta juchamanta Cacharichejka israelcunamantamin jamun. ");
INSERT INTO quhNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Arí, p'unchaycuna jamushan, cunantaj chay p'unchaycunaka. Cunantajmin cheka yupaychajcuna Dios Tatata tucuy sonkowan cheka yuyaywantaj payta yupaychanancu. Chayjina yupaychajcunata Dios Tataka munan. ");
INSERT INTO quhNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Diospa caynenka Espiritumin manataj ricucunchu. Payta yupaychajcunataj tucuy sonkowan cheka yuyaywantaj yupaychanancu tiyan, —nin Jesús. ");
INSERT INTO quhNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Warmeka payman nin: —Arí, yachani Diospa ajllaskan Cristo jamunanta. Pay chayamuspa tucuy imasta sut'inchawasajcu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesusri payman nin: —Noka Cristo cani, kanwan parlaspa, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ajinata parlashajtincutaj yachacojcunanka cutimorkancu. T'ucorkancutaj Jesús uj warmiwan parlashaskanmanta. Chay jawarí mana payta nerkancuchu: “¿Imatataj munanqui?” chayrí “¿Imatataj paywan parlashanqui?” nispapis. ");
INSERT INTO quhNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Warmirí p'uñunta sakespa llajtaman rerka. Chaypitaj runasta nerka: ");
INSERT INTO quhNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Jamuychej uj runata ricoj. Payka tucuy ruwaskayta niwan. ¿Manachu cayka Cristo canman? ¿Imaynataj canmanrí? ");
INSERT INTO quhNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Chanta llajtamanta llojsimorkancu Jesús casharka, chayman jamunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Chaycamataj yachacojcunanka Jesusta nisharkancu: —Yachachejníy, miqhullayña, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Payrí paycunaman nerka: —Nokajta sumaj miqhunay capuwan. Kancunari chaymanta mana yachanquichejchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Chayraycu yachacojcunanka paycunapura ninacusharkancu: —Manachá pipis miqhunanpaj apamunmanchu carka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesustaj paycunaman nin: —Nokajtaka wajjina miqhunamin. Cachamuwajniypa munayninta ruwanay, paypa ruwayninta tucunaypis miqhunajina nokapajka. ");
INSERT INTO quhNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Caypi caj chajrasta ricuspa nishanquichej, tawa quillaraj cashan cosecha okharinapajka. Nokataj niyquichej: Allinta khawariychej ricunayquichejpaj cay waj laya chajrasta. Runaska pokoska chajrajinañamin. Wiñay causayman pusananchejtaj cosecha okhariyjina. ");
INSERT INTO quhNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Okharejka cusiywan chay wiñay causaypaj pokoyta okharishanña. Ajinapi tarpojka okharejwan cusca cusicuncu. ");
INSERT INTO quhNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Cayka Diospa cosechanmanta nincujina: “Ujmin tarpojka wajtaj okharejka”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Diospa cosechanpeka noka kancunata cacharkayquichej mana llanc'askallayquichejmanta okharimunayquichejpaj. Wajcuna llanc'arkancu okharinayquichejpaj. ");
INSERT INTO quhNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Chay samaria llajtamanta cajcuna ashqhas Jesuspi jap'icorkancu warmej willaskanraycu: “Jesús tucuy ruwaskayta niwan”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Chay samaria runastaj payman chayamuspa nisharkancu: —Nokaycuwan kheparicuy, —nispa. Ajinamanta chaypi iscay p'unchaycunata khepacorka. ");
INSERT INTO quhNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Aswan ashqhastaj Jesuspi jap'icorkancu paypa niskanta uyarispa. ");
INSERT INTO quhNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Warmita nisharkancutaj: —Mana kanpa niskallayquimantachu paypi jap'icuycu, manachayrí pay quiquinta uyariskaycuraycu. Yachaycutaj cay runaka chekapuni cay pacha runasta juchamanta Cacharichej caskanta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Iscay p'unchayta chaypi caskanmanta Jesuska llojserka Galileaman rinanpaj. ");
INSERT INTO quhNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Quiquin Jesusri cayta nerka: “Uj willajka pisipaj khawaskamin paypa quiquin llajtanpeka”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Chayraycu Galileaman rerka. Chaymanjinataj Jerusalenpi jatun p'unchaycunapi tucuy ruwaskanta ricuskancuraycu Galilea runaska Jesusta cusiywan jap'erkancu. Paycunapis jatun p'unchaypaj Jerusalenpi caskancu. ");
INSERT INTO quhNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ajinapi Jesús Galilea jallp'a Caná llajtapi yacuta vinoman tucucherka, chay llajtaman ujtawan chayamorka. Chaypachataj Capernaum llajtapi uj camachej runa carka. Paypa wawantaj onkoska casharka. ");
INSERT INTO quhNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Cay runa uyarerka Jesús Judeamanta Galileaman jamushaskanta. Chayraycu pay jamorka Jesusman, niricusharkataj: —Señorníy, waway wañojña rishan. Jamuy Capernaumman payta thañichipunawayquipaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ajinapi Jesús payman nerka: —Sichus ricuchinasta mana ricuwajchej chayka, ni jayc'aj nokapi jap'icuwanquichejmanchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Camachejka payman nerka: —Señorníy, jamullayña manaraj wawitay wañupushajtin, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesús payta nerka: —Rillayña, wawayqueka causashan, —nispa. Jesuspa niskanta creespa chay runaka riporka. ");
INSERT INTO quhNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ripushaspataj camachisninwan ñanpi tincorka. Chay camachisnenka Capernaummanta payman willaj jamusharkancu. Willarkancutaj: —Wawayqui causashan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Camachejka paycunata taporka: —¿Ima horasmantañataj allinyacun? Paymantaj nerkancu: —Kayna chaupi p'unchaytajina sinch'i k'oñi onkoynin chincaporka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tatantaj repararka chay horapi Jesús payman, “Wawayqui causashan”, niskanta. Paytaj Jesuspi jap'icorka tucuy wasinpi cajcunapis. ");
INSERT INTO quhNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Chay jatun ruwaskanwan Jesuska iscay caj cutitaña Galileapi atiyninta ricucherka. Cayri carka Judeamanta cutimuspa. ");
INSERT INTO quhNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Chay khepata israelcunaj Diosta yupaychana p'unchaycunancu carka. Chaypajtaj Jesús Jerusalenman rerka. ");
INSERT INTO quhNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalenpi oveja khatiycuna puncu kayllapi Betesda sutiyoj yacu estanque wasi tiyan. Chayka phishka jatuchej arcosniyoj. Unaycunamanta chay estanque yacoka mana yuyaymanta jatunta phullchimoj. ");
INSERT INTO quhNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Chay arcospitaj ashqha onkoska runas siricusharkancu. Paycunataj thañicunancuta suyasharkancu. Carkancu ciegos, cojos, imaymana onkoskas. ");
INSERT INTO quhNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Paycuna yuyarkancu sapa cuti yacu phullchimojtin onkoskacunamanta ñaupajta yacuman yaycojka thañiska cananta. ");
INSERT INTO quhNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Chaypitaj uj runa casharka quinsa chunca pusajniyoj wata onkoska. ");
INSERT INTO quhNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesusri payta siricushajta ricorka. Ashqha watasña onkoska caskanta yachaspa payman nin: —¿Thañicuyta munanquichu? ");
INSERT INTO quhNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Onkoska runari payman cutichin: —Señorníy, mana canchu yanapawajniy yacu phullchimojtincama churanawanpaj. Noka jamushajtiy wajña ñaupajniyta yaycun, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesutaj payman nin: —Jataricuy, callapuyquita okhariy, puriy, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Runaka chay quiquinpachita thañiska carka. Callapunta okharerka purisharkataj. Chay p'unchayrí samacuna p'unchay carka. ");
INSERT INTO quhNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Chayraycu israel curajcuna nisharkancu thañichiska runaman: —Ama callapuyquita apaychu. Samacuna p'unchay caskanraycu mana aticunchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Paycunaman cuticherka: —Thañichiwarka, chay runa niwarka: “Callapuyquita okhariy, puriy”, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Payta taporkancu: —¿Pitaj okhariy, puriy, nisorkarí? ");
INSERT INTO quhNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Thañiska runaka mana yacharkachu pichus thañichiskanta, Jesús ashqha runas chaupipi chincaripuskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Chaymanta khepata Jesús yupaychana-wasi patiopi payta tariparka. Nerkataj: —¡Khaway! Thañiska canqui, amañataj juchallicuychu, caymanta astawan ima sajrapis manaña jap'isunanpaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Thañiska runaka rispa israel curajcunaman willarka, Jesús sutiyoj payta thañichiskanta. ");
INSERT INTO quhNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Chayraycu israel curajcuna Jesusta muchuchiyta munasharkancu samacuna p'unchaypi chayjinata ruwaj caskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesusri paycunata nerka: —Tatayka sumaj cajta ruwashallanpuni. Chayraycu nokapis chaymanjinallataj ruwashani, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jesús samacuna p'unchaypi mana paycunajinachu ruwarka. Ajinamanta yuyarkancu samacuna p'unchayta chincachiyta munaskanta. Chaywanpis, “Dioska Tataymin” niskanwan Dioswan quiquinchacusharka. Chayraycu chay israel curajcuna payta wañuchiyta munarkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ajinata yuyaskancuraycutaj paycunaman Jesús cuticherka: —Chekatapuni niyquichej: Noka, Diospa Wawanri, munaynillaymanta ni imata ruwayta atinichu. Astawanka Tataypa ruwaskanta ricuspa chayllatataj ruwani. Tatay ruwashan, chayta nokapis quiquillantataj paypa atiyninwan ruwashani. ");
INSERT INTO quhNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tatay noka Wawanta munacuwan. Chayraycu tucuy ruwashaskanta ricuchiwan. Chay runata thañichiskaymanta astawan jatun ruwanastaraj ricuchiwanka kancuna t'ucunayquichejpajjina. ");
INSERT INTO quhNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Imaynatachus Dios Tata wañuskacunata causarichimun causaytataj kon, ajinallatataj noka, Wawanpis, pimanchá munani chayman causayta koni. ");
INSERT INTO quhNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Dios Tataka mana pitapis juchayojchus manachus caskanta ninchu. Manachayrí noka, Wawanman, runasta juchayojchus manachus caskancuta ninaypaj atiyta kowarka. ");
INSERT INTO quhNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Chayta ruwarka noka, Wawanta, tucuy runas jatunchanawancupaj. Dios Tatata jatunchancu quiquillantataj noka, Wawantapis, jatunchanawancu. Mana jatunchawajri nillataj jatunchanchu cachamuwajniy Dios Tatataka. ");
INSERT INTO quhNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","‘Chekatapuni niyquichej: Niskayta tucuy sonkowan uyarejka cachamuwajniypipis jap'icojka wiñay causayniyojmin. Manañataj juchanmanta juchachaskachu canka. Manachayrí wiñay wañuymanta wiñay causaymanña yaycun. ");
INSERT INTO quhNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Chekatapuni niyquichej: Cunanka sumaj p'unchay chayamunña. Cunanmin noka, Diospa Wawan, chay juchapi wañuskacunata wajyashani. Paycunataj uyariwankancu. Chay uyariwajcunataj wiñay causayniyoj cankancu. ");
INSERT INTO quhNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Imaynatachus Dios Tatalla causayta kon, ajinallatataj noka, Wawanman, atiyninta kowarka causayta konaypaj. ");
INSERT INTO quhNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Runasta juchayojchus manachus ninaypaj atiytapis kowarka cachaska Runan caskayraycu. ");
INSERT INTO quhNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Cay niskasmanta amaña t'ucuychejchu. Cunan chay p'unchay chayamunña. Tucuy p'ampaskacunaka wajyaskayta uyarispa llojsimonkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Sumaj cajta ruwajcunaka wiñay causayman yaycunancupaj jatarenkancu. Manacajta ruwajcunataj juchachaskas canancupaj jatarenkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Noka munaynillaymanta ni imata ruwayta atinichu. Astawanpis Tataymanta uyariskaymanjina runasta khawani, juchayojchus manachus niskayka chekanmin cachamuwajniypa munaynillanta ajllaskayraycu. Manataj nokaj munayniytachu ajllani. ");
INSERT INTO quhNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","‘Noka quiquiymanta willacuyman chayka, mana chekapaj khawaskachu willaskay canman. ");
INSERT INTO quhNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nokamanta willajka ujmin. Payka Dios Tata, yachanitaj nokamanta willaskanka cheka caskanta. ");
INSERT INTO quhNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Chaywanpis kancuna runasta cacharkanquichej bautizaj Juanta tapunancupaj. Paytaj nokamanta cheka cajta willasorkachej. ");
INSERT INTO quhNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nokarí cheka caskayta ricuchinaypajka mana runasllamanta willaskatachu munani. Astawanpis juchamanta cachariskas canayquichejpaj paymanta kancunaman parlashayquichej. ");
INSERT INTO quhNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juanka uj c'anchayjina carka sut'ita nokamanta willananpaj. Kancunataj pisi ratullapaj cusiywan payta uyarerkanquichej. ");
INSERT INTO quhNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Willajniyrí Juanmanta aswan curajmin. Chay ruwaskasniymin willajniyka. Chay ruwanasniyta Tatay kowarka tucunaypaj. Chaymanjina ruwashaskay, Dios Tata cachamuwaskanmanta willashan. ");
INSERT INTO quhNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Chaywanpis cachamuwajniy Tatayka nokamanta willarka. Kancunari paypa wajyaskanta ni jayc'aj sonkoyquichejwan uyarerkanquichejchu nitaj paymantapis repararkanquichejchu. ");
INSERT INTO quhNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Mana Tataypa niskanka sonkoyquichejpi canchu paypa cachamuskan caskayta mana creeskayquichejraycu. ");
INSERT INTO quhNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Entiendenayquichejpaj sumajta leeychej Diospa palabranta. Kancuna palabranpi wiñay causayniyoj caskayquichejta yuyanquichej. Astawanpis nokapimin wiñay causayka cashan. Chay palabrantaj nokamanta willan. ");
INSERT INTO quhNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Kancunarí mana nokaman jamuyta munanquichejchu wiñay causayniyoj canayquichejpaj. ");
INSERT INTO quhNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","‘Mana runaj mentacuyninta munanichu. ");
INSERT INTO quhNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Astawanpis kancunata rejsiyquichej. Yachanitaj Diospa munacuynin sonkoyquichejpi mana caskanta. ");
INSERT INTO quhNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Noka Tataypa munayninmanjina jamorkani pay imaynachus caskanta ricuchinaypaj. Kancunataj khesachawanquichej. Wajchus paypa munayninmanjinalla jamunman chayka, paytaka cusiywan jap'iwajchej. ");
INSERT INTO quhNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kancuna purajmanta mentacuyta munajcuna canquichej. Mana masc'anquichejpischu c'ata Diosmanta mentayninta. Ajina cajtenka ¿imaynatataj Diospi jap'icuyta atiwajchej? ");
INSERT INTO quhNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ama yuyaychejchu noka Dios Tataj ñaupakenpi kancunamanta willaycuspa ch'atanaytaka. Ch'atasojniyquichejka Moisesmin. Paypimin kancuna confiacunquichej. ");
INSERT INTO quhNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Sichus Moisespa niskanta creenquichej chayka, nokaj niskaytapis creewajchej carka. Moiseska nokamantamin kelkarka. ");
INSERT INTO quhNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Paypa kelkaskasnintapis mana creenquichejchu chayka ¿imaynatataj niskasniyta creewajchej? —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","2","Chay khepata Jesús Galilea jallp'aman riporka. Chaypitaj ashqha runas khatisharkancu. Paycunaka Jesús onkoska runasta thañichishajta cusiywan khawarkancu. Chayraycu payta khatisharkancu. Chay ashqha runasta sakespa Jesús Tiberias niska, Galilea kocha chimpaman rerka. ");
INSERT INTO quhNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Orkoman rerka chaypitaj yachacojcunanwan tiyaricorka samaricunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Israelcunaj pascua p'unchaynincu kayllaña carka. ");
INSERT INTO quhNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Chay tiyacushaskanmanta Jesuska ashqha runa payman jamushaskanta ricorka. Felipemantaj nerka: —¿Imaynatataj t'antata rantisunman paycuna miqhunancupaj? ");
INSERT INTO quhNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Felipej yuyaskanta yachanallanpaj chayta nerka. Payka yacharka runasman t'antata konanta. ");
INSERT INTO quhNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Feliperi cuticherka: —Uj wata llanc'aska kolkewan t'antata rantisunman chaypis, niraj sapa uj pisillatapis jap'incumanchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Yachacojninmanta Simón Pedroj wauken, Andrés, Jesusman nerka: ");
INSERT INTO quhNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Uj wawa caypi cashan. Paypata capushan phishka cebada t'antas iscay challwitaswan. Cayllaka ni imapischu chay ashqha runaspajka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesusri yachacojcunaman nerka: —Chay ashqha runasta tiyaycuchiychej, —nispa. Chaynejpi ashqha pasto carka. Runastaj tiyaycorkancu. Kharislla yupaska carkancu phishka warankajina. ");
INSERT INTO quhNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesustaj t'antasta okharispa Diosman graciasta korka. Chay tiyacushaj runasmantaj jaywaramorka. Ajinallatataj challwitaswanpis ruwarka tucuy munaskancuta kospa. ");
INSERT INTO quhNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Runas sajsacojtincutaj yachacojcunanman Jesús nerka: —Tucuy puchojta okhariychej ama usuchiska cananpaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ajinatataj miqhuskancumanta puchojta okharerkancu chunca iscayniyoj canasta junt'ata. Chayka puchorka chay phishka cebada t'antasmanta. ");
INSERT INTO quhNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Chay jatun ricuchinata ricuskancumantataj runas nisharkancu: —Ciertopuni cay runaka cay pachaman Diosmanta jamunan carka chay willajmin, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Chay runas camachejnincupaj payta jap'iyta munarkancu. Chayraycu Jesuska paycunaj yuyaskancuta allinta yachaspa chay ashqha runata cacharpayaporka. Chaymanta payka sapallan orkoman riporka. ");
INSERT INTO quhNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ch'isiyajtinña yachacojcunan kochaman uraycamorkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Barcoman yaycuspataj kochanejta Capernaum llajtaman riyta kallarerkancu. Tutayaskaña carka Jesustaj manaraj paycunaman cutimorkachu. ");
INSERT INTO quhNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Yacutaj sinch'i wayramanta mayta okharicusharka. ");
INSERT INTO quhNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Uj leguatajinaña barcowan riskancupi Jesusta ricorkancu yacu patata purishajta. Pay barcoman kayllaycamushajtintaj mancharicorkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Payrí paycunaman nerka: —Noka cani. Amaña manchachicuychejchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Chayraycu paycuna mayta munarkancu Jesús barcoman yaycunanta. Barcotaj ujllata Capernaumman chayarka. ");
INSERT INTO quhNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Astawanrí chay ch'in pampapi waquenka chay ashqha runasmanta khepacorkancu. Ch'isiyayta uj barcolla chaypi caskanta ricorkancu. Ricorkancutaj Jesusta barcoman mana yaycuskantapis, yachacojcunallan ripuskancutapis. Runaska tutapi khepacuspa, khepan p'unchay tutamanta quiquin lugarpi Jesusta masc'asharkancuraj. ");
INSERT INTO quhNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Paycunaka Jesús runasman miqhuchiska, Diosman graciasta kospa, chaypi masc'asharkancu. Chaycamari Tiberias llajtamanta waj juch'uy barcos jamorkancu chaynejman. ");
INSERT INTO quhNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ajinallatataj Jesús manaña chaypichu caskanta ricuspa nitaj yachacojcunanpis, runaska chay juch'uy barcosman yaycorkancu. Capernaummantaj rerkancu Jesusta masc'aspa. ");
INSERT INTO quhNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Taripaspataj payta nerkancu: —Yachachejníy ¿mayc'ajtaj chayamorkanqui? ");
INSERT INTO quhNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesustaj paycunaman nerka: —Chekatapuni niyquichej: Mana chay Diospa atiyninmanta ricuchinasta khawaskayquichejraycuchu masc'ashawanquichej. Manachayrí chay t'antata miqhuspa sajsacuskayquichejrayculla masc'ashawanquichej. ");
INSERT INTO quhNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ama tucucoj miqhunallapajka llanc'aychejchu. Astawanrí wiñay causayta koj miqhunata masc'aychej. Chay miqhunata noka, Diospa cachaska Runan, koskayquichej. Noka Dios Tataypa ajllaskan caskayta chekata pay ricucherka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Chaymanta payta nerkancu: —¿Imatataj ruwanaycu tiyan Diospa munayninmanjina ruwanaycupajrí? ");
INSERT INTO quhNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús paycunaman cuticherka: —Diospa munayninta ruwanayquichejpajka paypa cachamuskanpi jap'icunayquichej tiyan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Paytataj nerkancu: —Astawan jatun ricuchinata ruwanayqui tiyan, chayta ricuspa kanpi jap'icunaycupaj. Atiyniyquita ricuchinawaycupaj ¿imatataj ruwashanquirí? ");
INSERT INTO quhNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ñaupa tatasninchej ch'in pampapi t'antatajina, maná sutiyojta, miqhorkancu. Ajinatataj Diospa palabranpipis nin: Payka janaj pachamanta t'antata paycunaman korka”, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Chay niskancumanta Jesuska nerka: —Chekatapuni niyquichej: Mana Moiseschu kancunaman chay janaj pachamanta t'antata kosorkachej, manachayrí Tatay. Cunantaj payka kosunquichej chekata uraycamojta, janaj pacha miqhunata. ");
INSERT INTO quhNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Chay miqhunaka janaj pachamanta uraycamojmin runasmantaj causayta kon, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Chayraycu paycuna nerkancu: —Señorníy, chay miqhunata kollawaycupuni, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesusrí paycunaman nerka: —Noka cani chay causayta koj miqhunaka. Nokaman jamojka ni jayc'aj yarkhachiconkachu. Nokapi jap'icojka nitaj jayc'ajpis ch'aquichiconkachu. ");
INSERT INTO quhNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nerkayquichejña: “Ricushawaspa kancunarí mana nokapi jap'icuwanquichejchu.” ");
INSERT INTO quhNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tataypa tucuy kowaskan runaka nokaman jamun. Nokaman jamojtarí ni jayc'aj khesachanichu. ");
INSERT INTO quhNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Janaj pachamantataj uraycamorkani mana munayniyta ruwanaypajchu, manachayrí cachamuwajniypa munayninta ruwanaypaj. ");
INSERT INTO quhNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Cachamuwajniypa munaynenka, tucuy kowaskan runasmanta ni uj chincapunan; manachayrí khepa p'unchaypi paycunata causarichimunay. ");
INSERT INTO quhNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Tatay munan tucuy runa Wawan caskayta reparaspa nokapi jap'icunanta. Nokapi jap'icunanta munan wiñay causayniyoj cananpaj. Chaywanpis munan nokapi jap'icojta khepa p'unchaypi causarichimunayta, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Israel runas Jesusmanta thutusharkancu, “Noka Diosmanta uraycamoj miqhuna cani” niskanmanta. ");
INSERT INTO quhNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Nisharkancutaj: —¿Cayka manachu Joséj wawan Jesús? Nokanchej rejsinchej tatanta mamantapis. ¿Imaynatataj cunan nin, Diosmanta uraycamuskanta? ");
INSERT INTO quhNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesustaj paycunaman nerka: —Amaña kancunapura thutuychejchu. ");
INSERT INTO quhNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ni pi nokaman jamuyta atinchu sichus cachamuwajniy Tatay payta mana pusamunchu chayka. Nokaman jamojtari khepa p'unchaypi causarichimusaj. ");
INSERT INTO quhNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Diospa unay willajcunanpa kelkaskasnincupipis nin: “Tucuy runasninta Dios yachachenka”. Chayraycu tucuy runa Dios Tatata sonkonwan uyarispa yachachiska caspataj nokaman jamun. ");
INSERT INTO quhNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mana ninichu, runa Dios Tatata ricuskantaka. Noka paymanta jamojlla Tataytaka ricorkani. ");
INSERT INTO quhNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","‘Chekatapuni niyquichej: Nokapi jap'icojka wiñay causayniyojmin. ");
INSERT INTO quhNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Noka cani chay causayta koj miqhuna. ");
INSERT INTO quhNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Unay tatasniyquichej chay maná t'antata ch'in pampapi miqhorkancu. Chaywanpis wañuporkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nokarí Diosmanta uraycamoj miqhuna cani. Manamin maná t'antajinachu cani. Astawanpis nokamanta miqhojka mana wañuponkachu. ");
INSERT INTO quhNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Noka cani chay wiñay causaj miqhuna Diosmanta jamoj. Ajinallataj wiñay causayniyoj canayquichejpaj nokamanta miqhunayquichej tiyan. Cay pacha runas wiñay causayniyoj canancupaj cuerpoyta koni, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Israel curajcuna paycunapura phiñacuywan churanacusharkancu: —¿Imaynatataj cay runaka cuerponta koyta atinman miqhunanchejpajrí? ");
INSERT INTO quhNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesustaj paycunaman nerka: —Chekatapuni niyquichej: Sichus nokamanta mana miqhunquichejchu nitaj yawarniymanta ujyanquichejchu chayka, mana wiñay causayniyojchu canquichej. ");
INSERT INTO quhNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nokamanta miqhojka yawarniymantapis ujyajka wiñay causayniyojmin. Nokataj payta khepa p'unchaypi causarichimusaj. ");
INSERT INTO quhNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nokamanta miqhojka yawarniymanta ujyajpis cheka miqhunayoj cheka ujyanayojtaj canka. ");
INSERT INTO quhNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Chay cheka miqhunayoj ujyanayoj runaka nokawan ujchaskamin. Causaynintaj nokamanta jamun sonkonpi tiyacuskayraycu. ");
INSERT INTO quhNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Causayniyoj Dios Tata cachamuwarka nokataj paynejta causani. Ajinallatataj nokamanta miqhojka nokaraycu causan. ");
INSERT INTO quhNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Noka cani chay Diosmanta jamoj miqhuna. Ñaupa tatasniyquichej manáta miqhuspapis wañuporkancu. Mana chayjina miqhunachu cani. Astawanpis nokamanta miqhojka wiñaypaj causanka, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Capernaumpi tantacuna-wasipi yachachishaspa chayta nerka. ");
INSERT INTO quhNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ashqhas khaticojcunanmanta Jesuspa niskanta uyarispa nerkancu: —Chay niskanka manchay sinch'i jap'inapajka. ¿Pitaj chayta khatiyta atinman? ");
INSERT INTO quhNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Khaticojcunaj thutuskancuta Jesús sonkonpi reparaspa paycunaman nerka: —¿Cay niskaychu kancunata sinch'ita urmachisunquichej? ");
INSERT INTO quhNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Noka, Diospa cachaska Runanta, ujtawan janaj pachaman wicharishajta ricuspa ¿imatataj yuyawajchej? ");
INSERT INTO quhNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Diospa Espiritullan causayta kon, manamin runaka atiyniyojchu chayta ruwananpajka. Cay palabras noka kancunaman niskayrí Santo Espiritumantamin. Chayraycu niskasniy causayta kon. ");
INSERT INTO quhNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Astawanrí waquin kancunamanta nokapi mana jap'icunquichejchu, —nispa. Paypi mana jap'icojcunamanta payta jaywaycojmantapis Jesuska yacharkapuni. Chayraycu chayta nerka. ");
INSERT INTO quhNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Chaywanpis nillarkataj: —Chayraycu nerkayquichej, ni pi nokaman jamuwayta atinchu sichus Dios Tata atiyta mana konchu chayka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ajinaka chay khatejcunamanta ashqhas khepaman cutiporkancu manañataj paywan purerkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jesustaj chay chunca iscayniyoj yachacojcunanman nerka: —¿Kancunapis ripullaytatajchu munanquichej? ");
INSERT INTO quhNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simón Pedrori payman cuticherka: —Señorníy ¿pimantaj riycuman? Kanpa niskayquimin wiñay causayta kojka. ");
INSERT INTO quhNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nokaycupis kanpi jap'icuycuña sumajtataj yachaycu kanka Diospa cheka cachamuskan caskayquita, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesús payman nerka: —Noka kancunata, chunca iscayniyojta ajllacorkayquichej. Kancunamantari ujka supay Satanaspa casojninmin, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Judas Iscariote Simonpa wawanmanta chayta nerka. Payka Jesusta jaywaycoj risharka. Judasri chunca iscayniyoj yachacojcunanmanta ujnin carka. ");
INSERT INTO quhNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Chay khepatataj Jesús Galilea jallp'anejllapi purisharka yachachispa. Israel curajcuna payta wañuchinancupaj masc'asharkancu. Chayraycu Judea jallp'apeka puriyta mana munarkachu. ");
INSERT INTO quhNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Astawanpis Jerusalenpi israelcunapaj jatun yuyaricuna p'unchaycuna kayllamusharka. Unay ch'in pampapi ch'ujllaspi tiyacoj cancu. Chayta yuyaricunancupaj Jerusalenman rej cancu Diosta yupaychaj. ");
INSERT INTO quhNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Chayraycu Galileapi Jesuspa waukesninpis payman nerkancu: —Yachachiskasniyquipis ruwaskayquita khawanancupaj rillayña caymanta Judea jallp'aman. ");
INSERT INTO quhNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ni pipis pacayllata ruwanchu ricuchicuyta munaspaka. Chayraycu caycunata ruwashaspaka tucuy runasman ricuchicuy, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Waukesninpis pay Diospa cachamuskan caskanta mana creerkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesustaj paycunaman nerka: —Rinay p'unchayka manaraj chayamushanchu. Kancunapajrí p'unchayka waquichiskallapuni cashan. ");
INSERT INTO quhNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Cay pacha runaska mana kancunata chejnisunquichejmanchu. Nokatarí chejniwancu ruwaskasnincu mana allin caskanta reparachiskayraycu. ");
INSERT INTO quhNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kancunalla riychej cay jatun p'unchaycunapajka. Nokaj ricuchicunay p'unchayka manaraj chayamushanchu. Chayraycu mana risajchu cay jatun p'unchaypi ricuchicojka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Chayta niytawan payka Galilea jallp'allapi cacorka. ");
INSERT INTO quhNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Waukesnin Jerusalenman jatun p'unchaypaj riskancutawancama chaymanta paypis rillarkataj. Mana ricuchicuspa pacayllata rerka. ");
INSERT INTO quhNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Israel curajcunataj chay jatun p'unchaypi payta masc'asharkancu. Nisharkancutaj: —¿Maypitaj chay runarí? —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Jatun p'unchaypaj chay ashqha jamojcunataj Jesusmanta mayta chhichinacusharkancu. Ujcuna nisharkancu: “Payka c'acha runa”, nispa. Waquinrí nisharkancu: “Mana c'achachu. Runasta pantachejmin payka”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Israel curajcunata manchachicuskancuraycu ni pi Jesusmanta sut'ita parlajchu runaspa ñaupakencupeka. ");
INSERT INTO quhNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Chay jatun p'unchaycunamanta tawa p'unchayña carka. Jesuska yupaychana-wasiman rerka chaypitaj yachachiyta kallarerka. ");
INSERT INTO quhNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Israel curajcunataj payta uyarispa t'ucorkancu nerkancutaj: —Cay runaka Diospa palabranmanta ni jayc'aj nokaycuwan yachachiskachu carka. ¿Imaynapitaj cayjinata yachanrí? ");
INSERT INTO quhNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Chayraycu Jesuska chay ashqha runaspa ñaupakencupi nerka: —Cay yachachinayka mana nokajtachu, manachayka cachamuwajniypatamin. ");
INSERT INTO quhNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Pillapis Diospa munayninta ruwayta ajllajka cay yachachinamanta yachanka parlaskayka Diosmantachus chayrí nokallamantachus caskanta. ");
INSERT INTO quhNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Payllamanta parlajka payllata jatunchacuyta munan. Cachamojninpa jatunchayninta munajrí cheka yachachejmin. Nitaj paypi pantayka canchu. ");
INSERT INTO quhNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","‘Camachiskasta Moisés kosuskayquichejta yachanquichej. Astawanpis kancunamanta ni pi chay camachiskasta casunchu. Nokatapis wañuchiwaytaraj munashanquichej, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Chay ashqha runas jatun p'unchaypaj jamojcuna nerkancu: —¡Locochu cawaj! ¿Pitaj wañuchisuyta munanrí? ");
INSERT INTO quhNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesusri paycunaman nerka: —Samacuna p'unchaypi uj runallata thañicherkani. Chaymanta tucuy manchariskas cashanquichej. ");
INSERT INTO quhNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Diosman t'akaska caskanta ricuchinapaj khari wawata cuerponpi señalta ruwanayquichejta Moisés camachisorkachej. Chay circuncidayka mana Moisesllamantachu. Manachayka ñaupa tatasniyquichejmantapacha cashan. Samacuna p'unchay cashajtinpis pusaj p'unchayniyoj wawapaj chay juch'uy ruwayta ruwanquichejpuni. ");
INSERT INTO quhNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Chayta ruwanquichej Moisespa camachiskasninta casunayquichejpaj. Chanta ¿imaraycutaj nokapaj phiñacunquichej samacuna p'unchaypi uj runata tucuy cuerponta onkoyninmanta thañichiskayraycu? ");
INSERT INTO quhNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Amaña jawa imallataka khawaychejchu. Manachayrí cheka yuyaywan sumajta reparaychej, —nerka Jesús israel curajcunaman. ");
INSERT INTO quhNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalén llajtayojcunamanta waquinrí nisharkancu: —¿Manachu wañuchinancupaj masc'asharkancu chay runa, cayka? ");
INSERT INTO quhNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","¡Khaway, mana manchachicuspa tucuypa ñaupakencupi parlacushan! Nitaj payta imanancuchu. ¿Cunanri curaj camachejcunapis chekachá jamoj ajllaska Cristo caskanta rejsincuman? ");
INSERT INTO quhNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nokanchejpis yachanchej cay runaka maymantachus caskanta. Cristo jamojtenka ni pi yachankachu maymanta caskantapis, —nisharkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yupaychana-wasi patiopi yachachispa tucuy uyarinancupajjina Jesús cayta nerka: —¡Arí! Kancuna nokata rejsiwaspa maymantachus jamuskaytapis yachaskayquichejta yuyanquichej. Astawanrí mana nokallamantachu jamuni, manachayka cachamuwajniy Diosmanta. Payka chekamin. Kancunarí mana payta rejsinquichejchu. ");
INSERT INTO quhNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nokarí payta rejsini paywan cusca caskayraycu. Paytaj nokata cachamuwarka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Chayraycu payta jap'iycuyta munasharkancu. Nitaj pipis payta imanarkachu manaraj wañunan horachu caskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Jatun p'unchaypaj jamojcunamantataj ashqhas Jesuspi jap'icorkancu. Nisharkancutaj: —¿Jamoj Cristoka cay runamanta aswan jatuchej ricuchinastachu ruwanman? ");
INSERT INTO quhNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ashqha runas Jesusmanta chhichiskancuta fariseos uyarerkancu. Chayraycu yupaychana-wasimanta curajcuna fariseospiwan yanapajnincuta cachamorkancu payta jap'iycunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Chayraycu Jesús paycunaman nerka: —Pisi p'unchaycunatawanraj casaj kancunawan. Chaymanta ujtawan ripusaj cachamuwajniypaman. ");
INSERT INTO quhNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Jamoj p'unchaycunapi masc'awanquichej manataj tariwanquichejchu. Noka cashani, chaymantaj kancuna mana atinquichejchu jamuyta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Israel curajcunataj paycunapura asicuspa ninacusharkancu: —Cay runaka ¿maymantaj ripunman mana payta tarinanchejpaj? ¿Waj llajtayojcuna chaupipi tiyacoj israelcunamanchu rinman? Chayrí ¿chay waj llajtayojcunatachu yachachimunman? ");
INSERT INTO quhNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Imaynataj cay niskanrí? “Jamoj p'unchaycunapi masc'awanquichej manataj tariwanquichejchu”. ¿Chaywanpis? “Noka cashani, chaymantaj kancuna mana atinquichejchu jamuyta”. —nerkancu israel curajcuna. ");
INSERT INTO quhNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Tucuy chay jatun p'unchaycunamanta khepa caj p'unchayka aswan sumaj carka. Chay p'unchaypitaj Jesuska tucuypa ñaupakencupi sayaricuspa nerka: —Ch'aquichicoj runajina wiñay causayta munajka nokaman jamuchun wiñay causayta jap'inanpaj. ");
INSERT INTO quhNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Dios palabranpipis nin: “Nokapi jap'icojka c'acha yanapayniywan sajsaskamin. Paymantaka chay c'acha yanapaynintaj jatun mayusjina llojsenka paynejta waj runasmanpis wiñay causayta jap'inancupaj”, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Chaytarí nerka Santo Espiritumanta. Dios paypi jap'icojcunaman Espirituta cachamunan carka. Yachacojcunaman Santo Espíritoj jatun atiynenka manaraj koskachu carka, Jesús atiyninwan manaraj jatunchaska caskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ashqha runas Jesuspa niskanta uyarejcunamanta waquin nisharkancu: —Chekatapuni cayka Diosmanta jamoj willaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Waquintaj nisharkancu: —Diospa ajllaskan Cristo payka, —nispa. Ujcunarí nisharkancu: —Cristoka mana Galileamantaka jamunmanchu. Chayraycu mana Cristochu payka. ");
INSERT INTO quhNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Dios palabranpipis cayta nin: “Davidpa mirayninmanta jamunan tiyan”. Davidpa llajtan Belenpitaj nacecunan tiyan Cristoka, —nisharkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Chay jawataj churanacuy jatarerka Jesusmanta chay ashqha runas chaupipi. ");
INSERT INTO quhNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Waquin paycunamanta Jesusta jap'iycuyta munasharkancu. Astawanpis ni pi payta imanarkachu. ");
INSERT INTO quhNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Chay cachaska yanapajcunari yupaychana-wasimanta curajcunaman fariseocunamanpis cutimuspa mana Jesusta pusamuspalla cutimorkancu. Chayraycu chay curajcuna paycunaman nerkancu: —¿Imaraycutaj payta mana pusamunquichejchu? ");
INSERT INTO quhNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Yanapajcunataj paycunaman cuticherkancu: —Ni pipis ni jayc'ajpis parlarkachu chay runajinaka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Fariseocunataj phiñacuywan paycunaman nerkancu: —¿Kancunapis paywan engañachicunquichejchu? ");
INSERT INTO quhNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ni pi curajcunamanta nitaj fariseocunamantapis paypi jap'icunchu. ");
INSERT INTO quhNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","¡Chay ashqha campo runasrí camachiskasta mana yachaspa Diosmanta juchachaskas cachuncu! —nerkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemopis paycunamanta carka. Payka ñaupajpi Jesusman jamoj carka. Payri paycunata reparachinanpaj nerka: ");
INSERT INTO quhNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—¿Camachiskasninchejmanjina uj runata juchachayta aticunmanchu manaraj payta uyarishaspa nitaj ruwaskanta sumajta yachashaspapis? ");
INSERT INTO quhNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Paycunataj phiñacuywan cuticherkancu: —¿Kanka Galilea jallp'amantachu canquirí? Riy, sumajta librospi masc'amuy. Galileamanta Diosmanta willajnin mana canchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Sapa ujtaj wasinman riporka. ");
INSERT INTO quhNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesusrí Olivos niska orkoman riporka. ");
INSERT INTO quhNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ujtawan tutamanta yupaychana-wasi patioman yaycorka. Tucuy runastaj payman jamorkancu. Paytaj tiyaycuspa paycunata yachachisharka. ");
INSERT INTO quhNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Chaymanta israel yachachejcuna fariseocunawan Jesusman pusamorkancu juchapi jap'iska uj khencha warmita. Chay warmita tucuypa ñaupakencupi sayaycuchispataj ");
INSERT INTO quhNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jesusman nerkancu: —Yachachej ¡khaway! Cay warmeka quiquin khenchachacuypi jap'iska carka. ");
INSERT INTO quhNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ajinata ruwajcunaka rumiwan ch'ankaskas wañunancuta, Moiseska camachiwarkanchej. Kanrí ¿imatataj ninqui? ");
INSERT INTO quhNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Chayta taporkancu Jesusta pantachiyta munaspa payta juchachanancupaj. Jesusrí pampaman c'umuycuspa maquinwan jallp'api kelkayta kallarerka. ");
INSERT INTO quhNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Paycuna tapojtillancupunirí Jesuska chekanyaricuspa nerka: —Kancunamanta mana juchayoj caj payta ch'ankayta kallarichun, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ujtawan pampaman c'umuycuspa kelkallarkataj. ");
INSERT INTO quhNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pusamojcunataj chay niskanta uyarispa ujmanta ujmanta llojsiraporkancu curaj cajcunamanta kallarispa. Jesusta sapallanta sakerkancu, warmitaj runaspa ñaupakencupi sayashallarkaraj. ");
INSERT INTO quhNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesusri chekanyaricuspa warmita nerka: —¿Maytaj chay runasrí? ¿Manachu ni pipis juchachasunqui? ");
INSERT INTO quhNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Paytaj nerka: —Señorníy, ni pipis, —nispa. Jesusri payta nerka: —Ni nokapis kanta juchachaskayquichu. Ripuy, amañataj cunanmanta juchallicuychu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesús ujtawan ashqha runasta yachachisharka. Nerkataj: —Noka cani cay pacha runaspa c'anchaynincu. Nokapi jap'icojka manaña jucha lakhapi purenkachu. Manachayrí wiñay causayta koj c'anchay sonkonpi tiyaconka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Fariseosri payta nerkancu: —Kanka, kan quiquiyquimanta willacushanqui. Chayraycu willacuskayqueka mana jap'inapajjinachu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesustaj paycunaman cuticherka: —Arí, noka quiquiymanta willani. Cay willaskayrí chekamin cashan maymantachus jamuskayta maymanchus ripushaskaytapis yachaskayraycu. Kancunarí mana yachanquichejchu maymantachus jamuskayta maymanchus ripushaskaytapis. ");
INSERT INTO quhNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kancunaka cay pacha yuyaymanjinalla chay willaskay chekachus manachus caskanta ninquichej. Nokarí ni pita juchachashanichu. ");
INSERT INTO quhNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Sitajchus noka juchachani chayka, juchamanta niskayka chekamin. Cachamuwajniy Tatay nokawan cusca, manataj sapallaychu. Chayraycu willaskayka chekamin. ");
INSERT INTO quhNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Chaywanpis Moisespa camachiskasninpi kancunapaj kelkaska cashan: “Iscay runas quiquinta willajtillancu chay willaskaka cheka”. ");
INSERT INTO quhNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Noka cani nokamanta willaj, cachamuwajniy Tataypis nokamanta willan, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Chayraycu taporkancu asicunancupaj: —¿Maypitaj tatayquirí? Jesusri cuticherka: —Mana nokata rejsiwanquichejchu nitaj Tataytapis. Sichus nokata rejsiwanquichejman chayka, Tataytapis rejsiwajchej carka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Tucuypa ñaupakencupi Jesús chay imasta parlasharka kolke churana chaypi, yupaychana-wasi patiopi yachachishaspa. Nitaj pipis payta jap'iycorkachu wañunan hora manaraj chayamuskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ujtawan paycunaman nillarkataj: —Noka ripusaj. Chaymantataj kancunaka masc'awanquichej. Juchayquichejpitaj wañunquichej. Noka ripushani, chaymantaj kancuna mana jamuyta atinquichejchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Israel curajcunari asicunancupaj nerkancu: —¿Cunan pay quiquinchu wañuchiconka, “Noka ripushani, chaymantaj kancuna mana jamuyta atinquichejchu”, ninanpaj? ");
INSERT INTO quhNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Paycunamantaj nerka: —Kancuna cay pachamanta canquichej. Nokataj janaj pachamanta cani. Kancuna cay pacha runaslla canquichej. Nokari sapallay mana cay pachamantachu cani. ");
INSERT INTO quhNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nerkayquichej, juchasniyquichejpi wañunayquichejta. Noka Diosmanta jamuni runasta juchamanta cacharichinaypaj. Chayraycu manachus nokapi jap'icuwanquichej chayka, juchasniyquichejpi wañunquichej, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Israel curajcunataj taporkancu: —¿Kan pitaj canquirí? Jesusri paycunaman cuticherka: —Nishayquichej, ajinamin noka cani. ");
INSERT INTO quhNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Kancunamanta ashqhatarajmin parlanay tiyan, juchamanta reparachinaypis tiyan. Astawanpis cachamuwajniyka chekapunimin. Nokataj paymanta uyariskallayta cay pacha runasman willashani, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Paycunaka mana entienderkancuchu Dios Tatamanta parlaskanta. ");
INSERT INTO quhNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Chayraycu Jesús paycunaman nerka: —Noka, Diospa cachaska Runanta, wañuypaj okharinquichej. Chaypacha nokamanta yachanquichej. “Nishayquichej, ajinamin noka cani”, nisuskayta yachanquichej. Ni imatapis nokallamanta ruwanichu. Astawanrí Tatay yachachiwaskanmanjina chay imasllata parlani. ");
INSERT INTO quhNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Cachamuwajniypa munaynintapuni ruwani. Chayraycu payka nokawan cuscapunimin. Manataj sapallaytachu sakewan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Chay imasta parlaskanmanta ashqha paypi jap'icorkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Paypi jap'icoj israelcunaman Jesús nerka: —Nokaj niskayta casuspalla kancunaka cheka yachacojcunay canquichej. ");
INSERT INTO quhNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Cheka cajta yachanquichejtaj chay cheka cajri cacharichisonkachej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Mana creejcunarí cuticherkancu: —Nokaycoka Abrahampa miraynin caycu. Nitaj jayc'ajpis pejpa camachinpischu carkaycu. Chanta kan ¿imaynatataj nishanqui: “Cachariskas canquichej”, nisparí? ");
INSERT INTO quhNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesusri paycunaman cuticherka: —Chekatapuni niyquichej: Juchata ruwajka juchaj camachin cashan. ");
INSERT INTO quhNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Camacheka mana wiñaypajchu camachejninpa wasinpeka khepacun. Manachayrí wawallan wiñaypajka tiyacun. ");
INSERT INTO quhNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Chayraycu sichus Diospa Wawan juchamanta cacharichisunquichejman chayka, wiñaypaj cachariskas canquichej. ");
INSERT INTO quhNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Arí, yachani Abrahampa miraynin caskayquichejta. Niskaytarí sonkoyquichejpi mana jap'inquichejchu. Chayraycu wañuchinawayquichejpaj masc'ashanquichej. ");
INSERT INTO quhNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nokaka Tataywan cusca caspa, ricuskayta parlashani. Kancunarí tatayquichejmanta uyariskallayquichejta ruwashanquichej, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Paycunataj cuticherkancu: —Abrahammin tataycoka, —nispa. Jesustaj paycunaman nerka: —Sichus Abrahampa wawasnin cawajchej chayka, Abrahamjina ruwawajchej. ");
INSERT INTO quhNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Astawanpis cunanka wañuchiwayta munanquichej kancunaman cheka cajta parlajtiy. Abrahamka mana chayta ruwarkachu. Nokarí Dios Tataymanta chay cheka cajta uyarispa cheka cajta parlani. ");
INSERT INTO quhNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kancunaka tatayquichejpa ruwanasninta ruwanquichej, —nerka Jesús. Paycunataj mayta cuticherkancu: —Ujlla tataycoka, paytaj Dios. Nokaycoka mana khenchachacuymantachu nacerkaycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesustaj paycunaman nerka: —Dioschus tatayquichej canman chayka, munacuwanquichejman carka, noka Diosmanta llojsimuspa caypi cashaskayraycu. Nokaka mana munayniymanjinachu jamorkani. Manachayrí pay cachamuwarka. ");
INSERT INTO quhNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kancuna niskanta mana jap'inquichejchu simi parlaskayta mana rejsiskayquichejraycu. Chayraycu niskayta uyariyta mana atinquichejchu. ");
INSERT INTO quhNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kancunaka tatayquichej supay Satanasmanta canquichej. Tatayquichejpa munayninta ruwaytataj ajllanquichej. Payka kallariymantapacha runa wañuchi carka. Cheka cajtapis ni jayc'aj munarkachu. Manachayrí paypeka llullacuyllamin. Tucuy llulla cayka paymanta jamun. Chayraycutaj llullata parlaspaka payllamanta parlan. ");
INSERT INTO quhNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Noka kancunaman cheka cajta nejtiyrí mana creewanquichejchu. ");
INSERT INTO quhNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Kancunamanta ¿pitaj juchayoj caskayta ricuchiyta atinman? Cheka cajta niyquichej chayka ¿imaraycutaj mana creewanquichejchurí? ");
INSERT INTO quhNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Diosmanta cajka paypa niskanta uyarin. Kancunarí mana Diosmantachu canquichej. Chayraycu niskanta mana uyarinquichejchu, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Israel curajcuna payman cuticherkancu: —Nokaycu chekata niycu, kanka chejniska samaritano supayniyojtaj caskayquita, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesustaj nerka: —Nokaka mana supayniyojchu cani. Manachayrí Tatayta jatunchani. Kancunarí mana jatunchawanquichejchu. ");
INSERT INTO quhNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nokaka mana jatunchacuyniyllatachu munani. Tataymin jatunchawaytaka munan. Paypa nokamanta parlaskantaj chekamin. ");
INSERT INTO quhNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Chekatapuni niyquichej: Niskayta casojka ni jayc'aj wiñaypaj wañonkachu, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Israel curajcunarí nerkancu: —Cunan yachaycu supayniyoj caskayquita. Abraham wañuporka, Diospa unay willajcunanpis. Kanri ninqui: “Niskayta casojka ni jayc'aj wiñaypaj wañonkachu”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Unay tatanchej Abrahammanta kanka aswan curajchu canqui? Payka unayña wañuporka. Unay willajcunapis wañuporkancu. Kanrí ¿pi caskayquitataj yuyanquirí? ");
INSERT INTO quhNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesustaj cuticherka: —Nokalla jatunchacuyman chayka, jatunchacuskayka mana imachu canman. Jatunchawajniyka Tataymin. Kancunataj paymanta ninquichej, “Payka Diosninchej”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Astawanpis payta mana rejsinquichejchu. Nokarí payta rejsini. Sichus niyman payta mana rejsiskayta chayka, kancunajina llulla cayman. Nokarí paywan cusca caspa rejsini niskantapis casunipunitaj. ");
INSERT INTO quhNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tatayquichej Abrahamka Diospa sumaj niskanmanta cusicorka. Niskanta junt'askantapis ricorka. Chaywanpis jamushaskayta ricuspa cusicorka, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Chayraycu israel curajcuna payman nerkancu: —Kanka ni phishka chunca watayojpis canquirajchu. ¿Imaynatataj Abrahamta ricorkanquirí? ");
INSERT INTO quhNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesusri paycunaman nerka: —Chekatapuni niyquichej: Manaraj Abraham nacecushajtin nokaka carkanipuniña, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Chayraycu israel curajcuna rumista okharicorkancu payta ch'ankaycunancupaj. Jesusri pacaycucorka yupaychana-wasimantataj llojsiporka. ");
INSERT INTO quhNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jerusalenpi purishaspa Jesús uj ciego runata ricorka. Chay runaka nacecuyninmantapacha ciego carka. ");
INSERT INTO quhNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Yachacojcunantaj Jesusta taporkancu: —Yachachejníy ¿pitaj juchallicorka ajina ciego nacecunanpajrí? ¿Paychu chayrí tatasninchu? ");
INSERT INTO quhNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesustaj nerka: —Cayka mana juchanraycuchu nitaj tatasninpa juchanraycupischu. Manachayrí paypi Diospa ruwaskasnin ricuchiska cananpaj ciego nacecorka. ");
INSERT INTO quhNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Cachamuwajniypa ruwanasninta ruwananchej tiyan p'unchay cashajtin. Tutaña cajtenka ni pi llanc'ayta atinchu. ");
INSERT INTO quhNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Caypi cashanaycamaka cay pacha runaspa c'anchaynincu cani, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Chayta nispataj pampaman thokarka. Thokayninwantaj t'uruta ruwaspa chaywan ciegoj ñawisninta jawiycorka. ");
INSERT INTO quhNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Paytataj nerka: —Riy, Siloé estanquepi mayllacamuy, —nispa. Cay estanquej sutin, Siloé, niyta munan, cachamuska. Chay ciegotaj rispa mayllacamorka. Chaymantataj ricorka. ");
INSERT INTO quhNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Chayraycutaj llajta-masisnin, ñaupajta mañacojpaj rejsejcunapis nisharkancu: —Cay runaka mañacunanpaj tiyacushaj. ¿Paychu cay canman? ");
INSERT INTO quhNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ujcunarí nisharkancu: —Arí, paypuni, —nispa. Waquintaj nisharkancu: —Mana paychu. Payman rijch'acun, —nispa. Thañiskarí nisharka: —Noka cani, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Chayraycu payta taporkancu: —¿Imaynapitaj ñawisniyqui quicharicorkarí? ");
INSERT INTO quhNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Paytaj cuticherka: —Chay Jesús sutiyoj runa t'uruta ruwaspa ñawisniyman jawiycuwaspataj niwarka: “Riy, Siloé estanquepi mayllacamuy”, nispa. Nokari rerkani mayllacamoj. Chaymantataj ricuni, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Paytataj taporkancu: —¿Maypitaj chay runa? Payri nerka: —Mana yachanichu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ñaupajpi ciego carka, chay runata fariseospa ñaupakencuman pusarkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jesús t'uruta ruwaspa ñawisninta jawiycuskan quichariskanpis, samacuna p'unchaypi carka. ");
INSERT INTO quhNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Cunanri chay fariseos ujtawan chay runata taporkancu: —¿Imaynatataj ricorkanqui? Paycunamantaj nerka: —T'uruwan ñawisniyta jawiycuwarka. Nokari mayllacorkani ricunitaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Chayraycu fariseos Jesusmanta nisharkancu: —Chay runaka samacuna p'unchayta mana wakaychanchu. Chayraycu mana Diosmantachu, —nispa. Ujcunataj nisharkancu: —Uj juchasapa runaka mana ruwayta atinmanchu chayjina jatun ricuchinataka, —nispa. Paycuna uqhupi churanacuy carka chay jawa. ");
INSERT INTO quhNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ciego carka, chay runatataj ujtawan taporkancu: —Kanri, ñawisniyquita quicharejmanta ¿imata ninquitaj? Payri nerka: —Diosmanta willajninmin, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Israel curajcunari chay runamanta mana creeyta munarkancuchu pay ñaupajta ciego caskanta cunan ricuskantapis. Chayraycu tatanta mamantawan wajyamorkancu tapunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Paycunatataj taporkancu. —¿Payka wawayquichejchu? ¿Ciegochu nacecorka? Cunanri ¿imaynapitaj ricun? ");
INSERT INTO quhNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tatan mamanri cuticherkancu: —Arí, payka wawaycu ciego nacecuskantapis yachaycu. ");
INSERT INTO quhNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Cunanrí imaynapichus ñawisnin quicharicuskanta chayrí pichus ñawisninta thañichiskantapis, mana yachaycuchu. Payta tapuychej. Payka runaña. Atin paymanta parlayta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tatan maman chayta nerkancu israel curajcunata manchachicuskancuraycu. Chay curajcuna tantacuynincupi cayta yuyaychacuskancu: “Pillapis Jesuska Diospa cachamuskan Cristo caskanta willacojka tantacuna-wasimanta wijch'uska canka”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Chayraycu tatan maman nerkancu: “Payta tapuychej. Runaña payka”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ciego carka chay runata watejmanta wajyaspa payta nerkancu: —Diosta jatunchanayquipajjina chekata parlay. Nokaycoka chekata yachaycu chay runaka juchasapa caskanta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Payri cuticherka: —Juchasapachus manachus juchasapa, mana yachanichu. Ciego carkani, cunantaj ricushani. Chayllata yachani, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Paycunataj taporkancu: —¿Imatataj ruwasorka? ¿Imaynatataj ñawisniyquita thañichisorka? ");
INSERT INTO quhNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Paytaj cuticherka: —Nerkayquichejñaka ¿manachu uyariwarkanquichej? ¿Imapaj ujtawan uyariyta munanquichejrí? ¿Kancunapis yachacojcunanchu cayta munanquichej? ");
INSERT INTO quhNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Mayta phiñacuspataj payta c'amiycorkancu: —¡Kanchá chay runaj yachacojnin cawaj! ¡Nokaycoka Moisespa yachacojcunan caycu! ");
INSERT INTO quhNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","¡Nokaycoka yachaycu Dios Moisesman parlaskanta! ¡Chay runarí maymantachus mana yachaycuchu! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Paytaj cuticherka: —¡Cayka uj t'ucunapaj, maymanta caskanta mana yachaskayquichej ñawisniyta quichariwaskantapis! ");
INSERT INTO quhNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Yachanchej Dioska mana uyariskanta juchasapastaka. Manachayrí payta yupaychajta munayninta ruwajtataj Dioska uyarin. ");
INSERT INTO quhNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ni jayc'aj uyaricorkachu nacecuyninmantapacha ciegoj ñawisninta pipis quichariskanka. ");
INSERT INTO quhNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Manachus cay runa Diosmanta jamunman chayka, ni imata ruwayta atinmanchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Paycunataj cuticherkancu: —Chekapuni kanka juchapi naceska runa canqui. ¿Chaychu cunanka nokaycuta yachachiwaycuman? Chaymantataj payta wijch'orkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesusri uyarerka payta wijch'uskancuta. Payta taripaspataj nerka: —Kan ¿Diospa Wawanpi jap'icunquichu? ");
INSERT INTO quhNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Thañiska runataj nerka: —Señorníy, willaway pichus caskanta paypi jap'icunaypaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesusri payman nerka: —Payta ricorkanquiña. Kanman parlashayqui, chay noka cani, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Runari nerka: —Señorníy, kanpi jap'icuni, —nispa. Konkoricuspataj Jesusta yupaycharka. ");
INSERT INTO quhNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesusri nerka: —Cay pachaman jamorkani runaspa yuyaynincuta reparachinaypaj. Ajinapi mana ricojcuna riconkancu. Ricojcuna caskancuta yuyajcunarí ciegos caskancuta ricuchisaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Paywan caspa waquin fariseosmanta uyarejcuna chay jawa nerkancu: —Cunan ¿nokaycupis ciegos caskaycutachu yuyanqui? ");
INSERT INTO quhNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesustaj nerka: —Juchamantachus ciego cawajchej chayka, mana juchayojchu cawajchej. Cunanrí juchamanta yachaskayquichejta, ninquichej. Chayraycu nokapi jap'icuyta mana munanquichejchu wiñay causayta ricunayquichejpaj. Cunanpis juchallapipuni cacushanquichej ciegojina, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesús nillarkataj: —Chekatapuni niyquichej: Oveja canchaman mana puncunejta yaycojka, astawanpis pacacuspa wajnejta yaycun chayka suwamin wañuchejtaj. ");
INSERT INTO quhNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Puncunejta yaycojrí ovejaspa michejninmin. ");
INSERT INTO quhNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Canchata khawajka michejpaj puncuta quicharipun. Ovejasnintaj payta uyarincu. Paypa ovejasnintataj sutincumanta wajyaspa canchamanta pusan. ");
INSERT INTO quhNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ovejasninta canchamanta pusaspataj ñaupakencuta rin. Ovejasnintaj payta khatincu wajyaskanta rejsiskancuraycu. ");
INSERT INTO quhNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Waj runa mana michejnincuchus jamunman chayka, paytaka mana khatincuchu. Astawanpis paymanta aykecuncu wajcunaj wajyaskancuta mana rejsiskancuraycu, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Chay quiquinchanata Jesús runasman nisharka. Paycunarí mana entienderkancuchu paypa parlaskanta. ");
INSERT INTO quhNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Quiquinchanata sut'inchananpaj Jesús nerka: —Chekatapuni niyquichej: Noka cani ovejaspa puncuncu. ");
INSERT INTO quhNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tucuy nokamanta ñaupajta jamojcunaka suwas cancu wañuchejcunataj. Ovejasniyrí paycunata mana uyarerkancuchu khatinancupaj. ");
INSERT INTO quhNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Noka cani cheka puncoka. Diosta rejsinanpaj nokanejta yaycojka allinpi purenka. Yaycuspa llojsispa wiñay causayta koj miqhunatataj tarenka. ");
INSERT INTO quhNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","‘Suwaka runata pantachinallanpaj Diosmanta t'akananpaj, tucuchinanpajtaj jamun. Nokaka jamorkani wiñay causayta ovejasniyman konaypaj. Mana mich'acuspataj causayta kosaj. ");
INSERT INTO quhNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Noka cani chay c'acha michejka. C'acha michej caspataj causayniyta churani ovejasniy wiñay causayniyoj canancupaj. ");
INSERT INTO quhNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Minc'askalla michejka mana paypatachu ovejaska, atojta jamushajta ricuspa ovejasta sakerpan aykecuntaj. Atojtaj ovejasta jap'iran t'akarachintaj. ");
INSERT INTO quhNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Chay runaka kolkeraycu minc'askalla, mana ovejasta munacuskanraycutaj aykecun. ");
INSERT INTO quhNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","‘Noka cani chay c'acha michejka. Sumajta rejsini ovejasniyta. Paycunataj nokata sumajta rejsiwancu. ");
INSERT INTO quhNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Imaynatachus nokata Tatay rejsiwan nokapis Tatayta rejsini, ajinallatataj ovejasniyta rejsini. Causayniytataj koni ovejasniy wiñay causayniyoj canancupaj. ");
INSERT INTO quhNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Waj ovejasniypis capuwan mana cay tropamantachu. Paycunata pusamunay tiyan. Paycunapis wajyaskayta uyarenkancu jamunancupaj. Ajinapi uj tropalla uj michejllataj canka. ");
INSERT INTO quhNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","‘Nokaka causayniyta wañunaypaj churani. Ujtawantaj causarimusaj ovejasniyta michinaypaj. Chayraycu Tatayka munacuwan. ");
INSERT INTO quhNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Causayniytari ni pi khechuwanchu. Manachayrí munaynillaymanta causayniyta churacuni. Atiyniyojtaj cani causayniyta churanaypaj ujtawan jap'icapunaypajpis, Tataypa niskanmanjinamin, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Chayta parlaskanmantataj israel curajcuna uqhupi ujtawan churanacuy jatarerka. ");
INSERT INTO quhNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ashqhas paycunamanta nisharkancu: —¡Supayniyoj payka manataj yuyayninpichu! ¿Imapaj uyarinquichej? ");
INSERT INTO quhNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Waquintaj nisharkancu: —Cayjina parlaycunaka mana supayniyoj runajtachu. Nitaj supayniyojka ciegospa ñawisninta thañichiyta atinmanchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jerusalenpi jatun p'unchaycuna carka yupaychana-wasita ruwaskancumanta yuyaricunancupaj. Para tiempotaj carka. ");
INSERT INTO quhNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ajinapi Jesús purisharka chay yupaychana-wasimanta Salomón sutiyoj corredorpi. ");
INSERT INTO quhNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Israel curajcuna payta muyuycuspa nerkancu: —¿Jayc'ajcamataj suyanaycu tiyan kanmanta yachanaycupaj? Diospa ajllaskan Cristo canqui chayka, sut'ita willawaycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesustaj cuticherka: —Willarkayquichejña manataj creenquichejchu. Nokaka Tataypa sutinpi sumaj ruwanasta ruwashani. Chay ruwanas sut'ita willashancu nokamanta. ");
INSERT INTO quhNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Astawanpis kancunaka mana creenquichejchu mana ovejasniymanta caskayquichejraycu. ");
INSERT INTO quhNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ovejasniyka wajyaskayta uyarincu. Nokataj paycunata sumajta rejsini. Paycunapis nokata casuspa khatiwancu. ");
INSERT INTO quhNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Wiñay causayta paycunaman koni. Nitaj jayc'ajpis wiñaypaj chincaponkancuchu. Maquiymantapis ni pi ovejasniyta khechuwankachu. ");
INSERT INTO quhNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tatay ovejasniyta kowajka tucuymanta aswan atiyniyojmin. Chayraycu Tataypa maquinmanta ni pi paycunata khechuyta atinchu. ");
INSERT INTO quhNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nokawan Tataywanka ujlla caycu, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Israel curajcunaka ujtawan rumista okharicullarkancutaj Jesusta ch'ankaycunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Chayraycu Jesús paycunata nerka: —Tataymanta caj ashqha c'acha ruwaskasta ricucherkayquichej. ¿Chaycunamanta maykenraycutaj ch'ankaycuwayta munashanquichejrí? ");
INSERT INTO quhNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Chay israel curajcunataj payman cuticherkancu: —Mana ni mayken c'acha ruwaskayquimantachu kanta ch'ankaycu, manachayrí Diosta phiñachiskayquimanta. Kan, runalla Diosman ruwacapuspa Diosta phiñachinqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesustaj paycunaman nerka: —Kancuna yachanquichej, Dios kosorkachej, chay camachiskaspeka caymin kelkaska cashan: “Dios nerka, dioscuna caskayquichejta”. ");
INSERT INTO quhNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Diospa palabranta ni pi ni jayc'aj tucuchiyta atinchu. Yachanquichejtaj Dios ajllaska runasman niskanta apachimuspa paycunata dioscunata sutichaskanta. ");
INSERT INTO quhNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Nokatarí Dios Tata ajllawarka cachamuwarkataj cay pacha runasta juchancumanta cacharichinaypaj. Cunanri ¿atiwajchejchu “Diosta phiñachinqui”, niwayta? ");
INSERT INTO quhNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Sichus mana Tataypa ruwanasnintachu ruwani chayka, ama creewaychejchu, ari. ");
INSERT INTO quhNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Tataypa ruwanasninta ruwani chayka, ruwanasniyta creeychej, amapis nokata creewaychejchu. Chaywan yachanquichej reparanayquichejpaj noka Tataywan ujlla caskayta, Tataytaj nokawan ujlla caskanta cayniycupi, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Chayraycutaj ujtawan payta jap'iycuyta munasharkancu. Payrí maquisnincumanta aykecaporka. ");
INSERT INTO quhNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jesusri ujtawan Jordán mayu chimpaman riporka. Juan ñaupajpi bautizasharka chaypitaj tiyacamorka. ");
INSERT INTO quhNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ashqha runastaj payman jamorkancu. Ninacusharkancutaj: —Juanka ni uj ricuchinata ruwarkachu. Cay runamantarí Juanpa tucuy ima niskanka chekamin, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Chaypi Jesús cashajtintaj ashqha runas paypi jap'icorkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Chaymantaka Lázaro sutiyoj onkoska casharka Betania llajtapi. Chay llajtaka Maríaj llajtan carka ñañan Martajtawanpis. ");
INSERT INTO quhNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Chay Mariaka k'apaj aceitejinawan Señorninchejpa chaquisninta jawiska chujchasninwantaj pichaska. Chay onkoska Lazaroka paypa hermanon carka. ");
INSERT INTO quhNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Chayraycu hermanasnin Señor Jesusman willajta cacharkancu: —¡Khaway, munacuskayqueka onkoska cashan! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesusri chayta uyarispa nerka: —Cay onkoyka mana wañuypajchu. Manachayrí Dios jatun atiyninta ricuchinallanpajmin. Cay onkoynejtataj noka, Diospa Wawan, jatunchaska casaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesusri munacorka Martata, ñañan Mariata, Lazarotawan. ");
INSERT INTO quhNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Onkoska caskanta uyarispapis chaypi iscay p'unchaycunatawan kheparicorka. ");
INSERT INTO quhNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Chaymantataj yachacojcunanman nerka: —Jacu ripunachej ujtawan Judea jallp'aman, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Yachacojcunantaj payman nerkancu: —Yachachejníy, cunallan curajcunaka ch'ankaycusuyta munasharkancoka. ¿Ujtawanchu chayman rinquirí? ");
INSERT INTO quhNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesustaj paycunaman cuticherka: —Uj p'unchayka chunca iscayniyoj horasniyoj. P'unchaypi purejri mana urmanchu c'anchay caskanraycu. Quiquillantataj Diospa munayninta junt'anaycama mana urmasajchu. ");
INSERT INTO quhNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Astawanpis mana Diosmanjina causayman chayka, urmayman, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Chayta niytawan paycunaman nerka: —Munaska Lazaronchej puñushan. Nokarí payta rijch'arichimoj risaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Yachacojcunantaj payman nerkancu: —Señorníy, puñuspachá thañiconka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesusrí wañuyninmanta parlarka. Paycunataj yuyarkancu puñuspa samaricuymanta parlashaskanta. ");
INSERT INTO quhNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Chayraycu Jesuska sut'ita paycunaman nerka: —Lazaroka wañupun. ");
INSERT INTO quhNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Mana jakaypi caskaymantataj cusiska cani kancunaraycu astawan nokapi jap'icunawayquichejpaj. Cunanka jacu rinachej paypaman, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Mellizo niska Tomastaj yachacoj-masisninman nerka. —Jacu nokanchejpis paywan cusca wañumunanchejpaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jesustaj Betaniaman chayamuspa tawa p'unchay p'ampaskataña Lazarota tariparka. ");
INSERT INTO quhNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania llajtari Jerusalenmanta cuscan leguapijina carka. ");
INSERT INTO quhNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Chayraycu ashqhas israelcunamanta jamorkancu Martata Mariatapis hermanoncumanta sonkochaj. ");
INSERT INTO quhNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ajinapitaj Martaka Jesús chayamushaskanta uyarispa paywan tincoj llojserka. Mariataj wasillapi tiyaricusharka. ");
INSERT INTO quhNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Jesuswan tincuspataj Martaka nerka: —Señorníy, caypichus cawaj carka chayka, hermanoyka mana wañupunmanchu carka. ");
INSERT INTO quhNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Chaywanpis yachani imatapis mañacuskayquita Dios kosunanta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesustaj payman nerka: —Hermanoyqui causarimonka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martari payman nerka: —Arí, yachani causarimunanta chay khepa p'unchaypi runas causarimonkancu, chaypeka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesustaj payman nerka: —Noka cani causarichej. Nokataj cani causayta koj. Nokapi jap'icojka wañunman chaypis causarimonka. ");
INSERT INTO quhNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Tucuy nokapi jap'icuspa causajcunataj ni jayc'aj wiñaypaj wañonkancuchu. ¿Chayta creenquichu? —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Martataj nerka: —Arí, Señorníy, tucuy sonkoywan creeni cay pachaman jamoj Diospa Wawan Cristo caskayquita, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Chayta niytawan ñañan Mariata wajyaj rerka. Pacayllamantataj payman nerka: —Yachachejninchej caypi cashan wajyarisunqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Uyariytawancamataj Mariaka uskhay uskhayllata jataricorka payman rinanpaj. ");
INSERT INTO quhNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesusri manaraj ranchoman yaycorkarajchu. Aswanka Marta paywan tincorka chayllapiraj casharka. ");
INSERT INTO quhNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mariata sonkochanancupaj wasipi cashaj israelcunataj ricorkancu payta uskhayllata llojsiskanta. Paycunataj yuyarkancu p'ampaskaman wakaj rishaskanta. Chayraycu payta khaterkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mariataj Jesús casharka, chayman chayarka. Jesusta ricuytawantaj chaquisninman wijch'uycucuspa nerka: —Señorníy, caypichus cawaj carka chayka, hermanoyka mana wañupuwanmanchu carka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesusrí pay wakaskanta paywan cusca jamoj israelcuna wakaskancutapis ricorka. Chayraycu sonkonpi sinch'ita llaquicorka paytaj qharcatiterka. ");
INSERT INTO quhNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Nerkataj: —¿Maypitaj payta p'amparkanquichejrí? Paycunataj nerkancu: —Señorníy, jamuy ricunqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesustaj wakarka. ");
INSERT INTO quhNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Chayta ricuspa israelcuna nerkancu: —¡Khaway, may chhicatachus payta munacorka! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Paycunamanta waquintaj nerkancu: —Cay runaka ciegoj ñawisnintapis quicharerka. Chanta ¿manachu Lazarota wañuymanta jarc'anman carka? ");
INSERT INTO quhNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","P'ampana jusc'uman chayamuspa Jesús ujtawan sonkonpi sinch'ita llaquicorka. Chay p'ampanari orko c'uchupi ruwaska carka. Jatun p'alta rumiwantaj wisk'aska carka. ");
INSERT INTO quhNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesusri nerka: —Rumita okhariychej, —nispa. Wañojpa hermanan Martataj nerka: —Señorníy, asnashanña; tawa p'unchay p'ampaskaña, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesustaj payman nerka: —¿Manachu nerkayqui, nokapi jap'icuwanqui chayka, Diospa jatun atiyninta ricunqui? ");
INSERT INTO quhNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Runastaj rumita okharerkancu. Jesusri patata khawarispa nerka: —Tatáy, graciasta koyqui kanman uyariwaskayquimanta. ");
INSERT INTO quhNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yachanitaj uyariwaskayquitapuni. Cay ashqha runasraycutaj chayta nerkani paycuna creenancupaj kan cachamuwaskayquita, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Chayta niytawantaj jatunta khaparerka: —Lázaro, llojsimuy, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Wañuska runataj llojsimorka, chaquisnin maquisnin mayt'uska, uyanpis maychus p'ampanapaj khataska. Jesustaj paycunaman nerka: —Phascaraychej, sakeychej rejta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ashqhas israelcunamanta Jesuspi jap'icorkancu chay ruwaskanta ricuspa. Chay jap'icojcunaka Mariata sonkochaj jamojcunamanta carkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Waquin chay jamojcunamantari Jesuspa ruwaskanta fariseosman willaj rerkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Chayraycu yupaychana-wasimanta curajcuna fariseocunapiwan jatun tantacuyta wajyacorkancu. Nisharkancutaj: —Chay runaka ashqha ricuchinasta ruwashan. ¿Nokanchejri imatataj ruwashanchejrí? ");
INSERT INTO quhNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Sichus payta sakellasunchej chayka, tucuy paypi jap'iconkancu. Roma runastaj jamuspa atiyninchejta khechuwasun. Yupaychana-wasita llajtanchejtapis paycunallaña camachenkancu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Yupaychana-wasimanta curajka chay wata casharka Caifás sutiyoj. Payri tantacojcunamanta carka. Nerkataj: —¡Kancunaka ni imata yachanquichejchu! ");
INSERT INTO quhNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Cayta mana reparanquichejchu: Kancunapajka aswan allin cashan uj runa wañunan tucuy Diospa ajllaska runasninpaj, manataj tucuynincuchu wañunanka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Chaytaka mana payllamantachu nerka. Astawanpis yupaychana-wasimanta curaj chay wata caskanraycu sut'incharka Jesús wañunanta Diospa ajllaska israelcunanpaj. ");
INSERT INTO quhNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Manataj israelcunallapajchu wañunan carka, manachayrí tucuy cay pachapi caj ajllacuskasninpaj. Wañunan carka tucuy Diospa wawasnin tucuynejmanta ujchaska canancupaj. ");
INSERT INTO quhNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Chay p'unchaymantapacha chay camachejcunaka Jesusta wañuchinancupaj unancharkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Chayraycu Jesuska manaña israelcunaj ñaupakencupi purerkañachu. Astawanrí Efraín llajtaman riporka. Chay llajtari ch'in pampa kayllapi carka. Chaypitaj yachacojcunanwan caricorka. ");
INSERT INTO quhNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Israelcunaj pascuancu p'unchaycuna kayllaña casharka. Ashqha runastaj tucuy camposmanta Jerusalenman rerkancu. Paycuna pascua ñaupajta sonkoncuta llimphuchaj cancu Diosta yupaychanancupaj. ");
INSERT INTO quhNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Chay runastaj Jerusalenpi Jesusta masc'asharkancu. Yupaychana-wasipi sayashaskancupitaj paycunapura tapunacusharkancu: —¿Imatataj yuyanquichej? ¿Jesuska manachu cay jatun p'unchaycunapaj jamonka? ");
INSERT INTO quhNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Yupaychana-wasimanta curajcuna fariseoswan cayta camachiskancu: “Jesús maypichá cashaskanta yachajka willawaycu payta jap'inaycupaj”, nispa. Chayraycu chay runaska ajinata parlasharkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pascuaman sojta p'unchay cashajtin Jesús Betaniaman chayamorka. Chaypitaj Lázaro tiyacorka. Jesús wañuskamanta causaricherka, chaymin cay Lázaro carka. ");
INSERT INTO quhNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Chay Betania llajtayoj runastaj jatun miqhunata Jesuspaj waquichiporkancu. Martapis yanapacusharka. Lazarori Jesuswan tiyacushajcunamanta ujnin carka. ");
INSERT INTO quhNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mariataj apamorka uj libra c'achitu k'apayniyoj aceitetajina. Chaytaj nardo purumanta ashqha valorniyoj carka. Chaywantaj Jesuspa chaquisninta jawiycorka. Chujchanwantaj chaquisninta pichaycorka. Wasitaj chay c'achitu k'apaywan junt'a carka. ");
INSERT INTO quhNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Iscariote caj Judas yachacojcunanmanta ujnin carka. Pay Jesusta jaywanayasharkaña. Nerkataj: ");
INSERT INTO quhNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Cay k'apaj aceitejinaka ¿imaraycutaj mana vendecorkachurí? Uj wata pagopajjina carka. Chayka wajcha runasman koska canman carka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Chaytaka nerka mana wajcha runasta qhuyaskanraycuchu, manachayrí suwa caskanraycu. Payka paycuna uqhupi kolketa jallch'aj runa carka. Chay jallch'askancumantataj suwacoj. ");
INSERT INTO quhNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Judas niskanraycutaj Jesús nerka: —Sakellay. Ama jarc'aychu Mariata. Chayta jallch'arka p'ampacunay p'unchaypaj. ");
INSERT INTO quhNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Wajcha runaska kancunawanpuni cashancu. Nokarí mana unaytañachu kancunawan casaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Chay may ashqha Jerusalenman chayamojcuna yacharkancu Jesús Betaniapi cashaskanta. Paycunataj chayman jamorkancu mana Jesusta ricuyta munaspallachu astawanka Lazarota ricuyta munaspa. Payta ricuyta munarkancu wañuskamanta Jesús causarichiskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Ashqhas israelcunamanta curajcunancuta sakerpaspa Jesuspi jap'icusharkancu. Chayraycu yupaychana-wasimanta curajcuna Lazarota wañuchiyta yuyarkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","May ashqha runas Jerusalenman rerkancu chay jatun p'unchaycunapi Diosta yupaychaj. Jesusri Betaniamanta Jerusalenman risharka. Chay ashqha runastaj Jesús jamushaskanta uyarerkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Chayraycu palmasta okharicuspa llajtamanta payta taripaj llojserkancu. Khaparisharkancutaj: —¡Dios yupaychaska cachun! ¡May jatunchaska Israelman Diospa cachamuskanka! ¡Payka Camachejninchej! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesusri uj malton burrota tariytawan llok'aycuspa tiyaycucorka. Chaytaj Diospa palabranmanjina carka. Nin: ");
INSERT INTO quhNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Israelcuna ama manchachicuychejchu. Khawaychej, Camachejniyquichej jamushanña uña burro patapi tiyaska, nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Chaypachapi yachacojcunanka mana entienderkancuchu runas ruwaskancuta. Jesús jatunchaska cajtinrí paycuna yuyaricorkancu paymanta kelkaska caskanta, runas junt'askancupis. ");
INSERT INTO quhNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jesuswan Betaniamanta ashqha runas jamusharkancu. Chay ashqha runasmanta waquinri Jesús Lazarota causarichimojta ricojcuna carkancu. Paycunaka tucuyman willasharkancu imaynatachus Lazarota p'ampana jusc'umanta wajyaspa payta wañuskamanta causarichimuskanta. ");
INSERT INTO quhNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Jerusalenmantapis ashqha runas Jesús chay may jatun ricuchinata ruwaskanta uyarerkancu. Chayraycumin paycunaka Jesusta taripaj Jerusalenmanta llojserkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Fariseosrí chay imasta ricuspa paycunapura ninacorkancu: —¡Ni imapajpis ruwaskayquichejka! ¡Khaway, tucuy runas payta khatej ripushancu! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Waquin griego runas jatun p'unchaycunapaj jamoj cancu Diosta yupaychaj. ");
INSERT INTO quhNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Paycunamanta waquin kayllaycorkancu Felipeman, paypis Betsaida llajtayoj Galileamanta caskanraycu. Nerkancutaj: —Señor, Jesuswan tincuyta munaycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Felipetaj Andresman chayta nerka Andreswan Felipewantaj rispa Jesusman chayta willamorkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesustaj nerka: —Diospa cachaska Runan jatunchaska cananpaj p'unchay chayamunña. ");
INSERT INTO quhNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Chekatapuni niyquichej: Uj trigo muju jallp'aman urmaspa mana wañunchu chayka, sapallan cacun. Wañun chayrí ashqhatataj pokon. ");
INSERT INTO quhNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ajinallatataj cay pacha causayninta munacojka causaynintaka wiñaypaj chincachin. Cay pacha causayninta mana munacojrí wiñay causaypaj wakaychan. ");
INSERT INTO quhNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ruwanasniypi llanc'ananpaj causayninta kojka khatiwachun. Chanta maypichá noka cashani chaypi paypis wiñaypaj nokawan cusca canka. Nokapaj ruwajtarí Tatay sumajpaj khawanka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Chaywanpis nerka: —¡Cunanka may sinch'i llaquiska sonkoyka! ¿Imatataj niyta atini? “Tatáy, cay ñac'ariymanta cacharichiway” ¿nisajchu? Manachayka, cay ñac'ariyta muchunaypajmin jamorkani. ");
INSERT INTO quhNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Chayraycu: Tatáy, jatun atiyniyquita ricuchiy runas kanta jatunchasunancupaj, —nispa. Ajinapitaj Dios janaj pachamanta nimorka: —Jatun atiyniyta ricucherkani kannejta, watejmantapis ricuchillasajtaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Chaypi caj ashqha runastaj chayta uyarispa nisharkancu, para tronaskanta. Waquintaj nisharkancu, uj angel payman parlaskanta. ");
INSERT INTO quhNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesustaj nerka: —Mana nokapajchu Dioska parlamuwarka, manachayrí kancunaj allinniyquichejpaj. ");
INSERT INTO quhNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Cunanri Dios juchachashan cay pacha runasta juchancuraycu. Cunantaj cay pachata sajra camachej supay Satanasta Dios kharkonka. ");
INSERT INTO quhNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nokari jallp'amanta okhariska caytawan tucuyta nokaman c'ascachimusaj nokapi jap'icunancupaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Chayta nerka imaynapichus wañunanta willananpaj. ");
INSERT INTO quhNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Chayraycu chay ashqha runas payta nerkancu: —Nokaycoka cayta yacharkaycu camachiskasmanta, Cristoka wiñaypaj caypi tiyacunanta. Kanri ¿imaynataj nishanqui, “Diospa cachaska Runanka okhariska canan tiyan”, nisparí? ¿Imayna runataj chay Diospa cachaska Runanrí? ");
INSERT INTO quhNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesusri paycunaman nerka: —Noka cani cheka c'anchayka. Pisi p'unchaycunallatawanña kancunawan casaj. Chayraycu noka caypi cashajtiy c'anchaypi puriychej lakha juchawan ama atipaskas canayquichejpaj. Lakhapi purejka mana yachanchu maymanchus rishaskantapis. ");
INSERT INTO quhNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Noka kancunawan cashajtiy cheka c'anchaypi jap'icuwaychej nokajina canayquichejpaj, —nispa. Jesuska chay imasta parlaytawan ripuspa paycunamanta pacacorka. ");
INSERT INTO quhNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesús chay ashqha ricuchinasta runaspa ñaupakencupi ruwashajtinpis paycuna manapuni paypi jap'icorkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ajinapi junt'acusharka Diospa unay willajnin Isaiaspa kelkaskan. Nin: Señorníy, pisislla willanaskaycuta jap'icorkancuchu. Atiyniyquita ricuchejtiyquipis ni pi repararkachu, nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Ujtawanpis Isaias kelkaskanpi nillantaj: Dioska ñawisnincuta ciegoyacherka ama ricunancupaj. Sonkosnincutapis rumiyacherka ama entiendenancupaj. Ajinapi Diosman mana cutirincuchu nitaj juchancuta pay khechunchu, nispa. Chayraycu mana paypi jap'icuyta aterkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Chayta nerka Isaiaska jamoj Cristoj atiyninta ricuskanraycu paymantataj kelkarkapis. ");
INSERT INTO quhNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Chaywanpis curajcunamanta ashqhas Jesuska Cristo caskanta creerkancu. Fariseocunaraycutaj chayta mana willacorkancuchu tantacuna-wasimanta ama kharkoskas canancupaj. ");
INSERT INTO quhNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Paycunaka astawan munarkancu runas paycunata sumajpaj khawanancuta Diosmanta niskaka. ");
INSERT INTO quhNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesustaj runaspa ñaupakencupi nerka cayta: Nokapi jap'icojka mana nokallapichu jap'icushan. Manachayrí cachamuwajniypipis jap'icushan. ");
INSERT INTO quhNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nokata rejsiwajka cachamuwajniytapis rejsillantaj. ");
INSERT INTO quhNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Noka wiñay causayta koj c'anchay caspa cay pacha runasman jamorkani tucuy nokapi jap'icojka amaña juchapi causananpaj. ");
INSERT INTO quhNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Pillapis niskasniyta uyarin manataj casunchu chayka, paytaka mana nokachu juchachani. Nokaka mana cay pacha runasta juchachanaypajchu jamorkani. Manachayrí cay pacha runasta juchamanta cacharichinaypaj jamorkani. ");
INSERT INTO quhNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Pillapis nokata khesachawaspa niskasniyta mana jap'ejka juchachaska canka. Chay niskay payta khepa p'unchaypi juchachanka. ");
INSERT INTO quhNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nokari mana nokallamantachu parlarkani. Manachayrí cachamuwajniy Tatay niwarka imatachus ninayta parlanaytapis. ");
INSERT INTO quhNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Yachanitaj chay niwaskanka wiñay causayta koj caskanta. Chayraycu Tatay niwarka chayta quiquillantataj nokapis parlani. Chay imasta nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pascua ñaupajta Jesuska yachaskaña cay pachamanta ujtawan Tatanman cutipunan hora chayamushaskanta. Payka cay pachapi caj ajllaska runasninta munacorkapuni. Cunantaj chay munacuyninta may jatun caskanta, tucuyta paycunaman ricucherka. ");
INSERT INTO quhNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Pascua miqhuypi casharkancu. Supay Satanastaj Judasta sonkonpi yuyaychaskaña Jesusta jaywaycunanpaj. Judaska Simonpa wawan, Iscariote niska carka. ");
INSERT INTO quhNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesusri yachaskaña tucuy imata atiyninman Tatan jaywaskanta. Yachaskañataj Diosmanta jamuskanta Diosman cutipushaskantapis. ");
INSERT INTO quhNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Chay tucuyta yachaspataj Jesuska miqhuymanta jatarispa ponchonta lluch'ucun, camachijinataj p'achallicun. ");
INSERT INTO quhNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Mayllacunaman yacuta jich'aycuspa yachacojcunanpa chaquisninta mayllayta kallarin, chanta toallawan ch'aquichin. ");
INSERT INTO quhNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Chaquisnincuta mayllaspa Simón Pedroman chayan. Payri Jesusman nin: —Señorníy ¿maytataj chaquisniyta mayllawanquirí? ");
INSERT INTO quhNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesustaj payman cutichin: —Kan mana yachanquichu cunan noka ruwashani, chayta. Khepatarí yachanqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedroka nin: —¡Ni jayc'aj chaquisniytaka mayllawanquimanchu! —nispa. Jesustaj cutichin: —Mana mayllayquimanchu chayka, mana nokawan ujchaskachu canqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simón Pedrotaj nin: —Señorníy, ama chaquisnillaytaka, manachayrí maquisniyta umaytawan mayllaway, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesustaj payman nin: —Llimphuchaskaña cajka manaña mayllanachu. Manachayka chaquisnillanta mayllana tiyan juchamanta llimphuchaska caskanraycu. Kancunaka llimphuchaskasña canquichej, astawanrí mana tucuyniyquichejchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesuska yacharka pichus payta jaywaycunanta. Chayraycu nerka: “Mana tucuyniyquichejchu juchamanta llimphuchaskas canquichej”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Chaquisnincuta mayllaytawan p'achanta churacorka. Ujtawan tiyaycuspataj paycunaman nerka: —¿Entiendenquichejchu cayta kancunawan ruwaskayta? ");
INSERT INTO quhNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Kancuna sutichawanquichej, “Yachachejníy, Señorníy”, nispa. Chaypuni caskayraycu chekata niwanquichej. ");
INSERT INTO quhNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Imaynatachus noka, Señorniyquichej mayllayquichej, ajinallatataj kancunapis chaquisniyquichejta mayllanacuychej. ");
INSERT INTO quhNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ricuchiyquichejña kancunapura quiquillantataj ruwanayquichejpaj. ");
INSERT INTO quhNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Chekatapuni niyquichej, camacheka mana aswan curajpaj khawaskachu camachejninmantaka. Nitaj cachaskapis aswan curajpaj khawaskachu cachamojninmanta niskaka. ");
INSERT INTO quhNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Sichus cayta yachanquichej chayka, cusiska canquichej cayta ruwaspa. ");
INSERT INTO quhNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","‘Maykencunachus ajllacuskasniy cancu paycunata noka rejsini. Chayraycu mana tucuy kancunamantachu parlashani. Nokamanta Diospa palabranpi cay kelkaska junt'acunan tiyan. Nin: “T'antayta miqhojka contraypi sayaycuspa chaquinta okharin”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Manaraj cayjina cashajtin willayquichej ruwacojtinña yachanayquichejpaj. Nokaka niskaymanjina caskaytataj creenquichej. ");
INSERT INTO quhNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Chekatapuni niyquichej: Cachamuwajniyta jap'ejka nokata cusiywan jap'iwan. Nokata jap'ejka cachamuwajniyta cusiywan jap'in, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Chay imasta nispataj Jesuska sonkonpi mayta llaquicorka nerkataj: —Chekatapuni niyquichej: Kancunamanta ujniyquichej jaywaycuwaj rishan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Yachacojcunantaj t'ucuspa paycunapura khawanacorkancu. Ni imata yachaspataj pimantachus parlaskanta yachayta munasharkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yachacojcunanmanta ujnin, Jesús munacorka chay, paywan cusca tiyaska casharka. ");
INSERT INTO quhNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ajinapi Simón Pedroka chay yachacojman ch'illmipayarka pimantachus Jesús parlashaskanta tapunanpaj. ");
INSERT INTO quhNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Chay yachacojka Jesusman astawan kayllaycurispa taporka: —Señorníy ¿pitaj chayrí? —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesustaj cuticherka: —Noka t'antata jok'ochaspa payman kosaj. Chaymin payka, —nispa. Ajinaka t'antata jok'ochaspa Simonpa wawan Judas Iscarioteman korka. ");
INSERT INTO quhNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Chay t'antata jap'ejtincama supay Satanás Judasman yaycorka. Jesusri Judasta nerka: —Imatachus ruwashanqui chayta ruwallayña uskhayta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Chaypi tiyaska cashajcunamantarí imapajchus parlaskanta ni mayken repararkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judaska kolke jallch'ajnincu carka. Chayraycu waquin yuyarkancu Jesús payman cayta niskanta jatun p'unchaycunapaj rantinanpaj, chayrí, wajchasman konanpaj. ");
INSERT INTO quhNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ajinata t'antata jap'iytawancama Judaska llojserka. Tutataj carka. ");
INSERT INTO quhNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas llojsejtincamataj Jesuska nerka: —Cunanka noka, Diospa cachaska Runan, jatunchaskaña cashani, Diospis nokawan jatunchaska cashan. ");
INSERT INTO quhNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Chayraycu ajinallatataj paywan Dios jatunchawanka. Cunanpachataj jatunchawanka. ");
INSERT INTO quhNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Munaska wawasníy, manaña unaytañachu kancunawan casaj. Masc'awanquichejtaj. Israel curajcunaman nerkani, ajinallatataj cunan kancunamanpis niyquichej: Noka ripushani, chayman kancuna mana atinquichejchu chayamuyta. ");
INSERT INTO quhNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Uj mosoj camachiskata koyquichej: Kancunapura munanacuychej. Imaynatachus nokapis munacorkayquichej quiquinta kancunapis munanacuychej. ");
INSERT INTO quhNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ajinata purajmanta munanacuspa causajtiyquichej tucuy runas yachankancu yachacojcunay caskayquichejta, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedrori payta nerka: —Señorníy ¿maymantaj rishanqui? Jesustaj cuticherka: —Noka rishani, chaymanka cunan mana khatiwayta atiwajchu. Khepatarí khatiwanqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedroka payta nerka: —Señorníy ¿imaraycutaj cunan khatisuyta mana atiymanchu? Kanraycu causayniyta konaypajpis waquichiska cani, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","—¿Causayniyquita nokaraycu kowajchu? Chekatapuni niyqui: Manaraj gallo wakashajtin quinsa cutita ninqui, nokata mana rejsiwaskayquita, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","‘Ripushaskaymantaka ama sonko nanayta llaquicuychejchu. Diospi jap'icuychejpuni, nokapipis jap'icullawaychejtaj. ");
INSERT INTO quhNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Tataypa wasinpeka ashqha tiyacunas tiyan chaypi ashqha runas paywan cusca wiñaypaj causanancupaj. Chayraycu chekata willayquichej. Cunanri rishani kancuna chaypi tiyacunayquichejpaj waquichej. ");
INSERT INTO quhNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Kancunapaj waquichej rispa ujtawan cutimusaj kancunata pusacapunaypaj. Ajinaka noka cashani, chaypi kancunapis canquichej. ");
INSERT INTO quhNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Noka rishani, chaymanka ñanta rejsinquichejña, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomasri payta nerka: —Señorníy, mana yachaycuchu maymanchus rishanqui. ¿Imaynatataj chay ñanta rejsiycumanrí? —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesustaj nerka: —Noka cani chay ñanka, chay cheka caj, chay wiñay causayta kojpis. Runaka nokanejllatataj Dios Tataman jamun. ");
INSERT INTO quhNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Sichus nokata rejsiwarkanquichej chayka, Tataytapis rejsiwajchej carka. Cunanmantapachataj payta rejsinquichej ricorkanquichejtaj —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Feliperi payta nerka: —Señorníy, ricuchiwaycu Dios Tatata. Chayllata munaycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesustaj nerka: —Chhica unayña kancunawan cani, Felipe ¿manachu rejsiwanqui? Nokata ricuwajka Dios Tatata ricun. ¿Imaynatataj nishawanqui: “Dios Tatata ricuchiwaycu”, nisparí? ");
INSERT INTO quhNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Noka Tataywan ujlla cani, Tataytaj nokawan ujllamin. ¿Chay niskayta manachu creenquichej? Kancunaman niskaytaka mana nokallamantachu niyquichej. Astawanpis nokapi tiyacoj Tatay ruwanasninta ruwan. ");
INSERT INTO quhNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nokaka Tataywan ujlla cani, Tataytaj nokawan ujllamin. Chayta creeychej noka niskayraycu. Manachayrí ruwaskasniyraycu creeychej. ");
INSERT INTO quhNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Chekatapuni niyquichej: Nokapi jap'icojka chay ruwaskasniy quiquillantataj ruwanka. Nokaka Tatayman ripushani. Chayraycu nokapi jap'icojka ruwaskasniymantapis aswan jatuchejtaraj ruwanka. ");
INSERT INTO quhNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nokawan ujchacuspa imatapis Diosmanta mañacunquichej chayta noka ruwasaj. Ajinapi Dios Tatay, noka Wawannejta jatunchaska canka. ");
INSERT INTO quhNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nokawan ujchacuspa sutiypi imatapis mañacuwaskayquichejta noka ruwasaj. ");
INSERT INTO quhNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","‘Nokata munacuwanquichej chayka, niskasniyta casunquichej. ");
INSERT INTO quhNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nokari Tatayman nisaj kancunaman ujta cachamunanta yanapasunayquichejpaj. Chay Yanapajka kancunawan tiyaconka wiñaypaj. ");
INSERT INTO quhNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Payka Santo Espiritumin. Paytataj cay pacha runas mana atincuchu ricuyta nitaj rejsiytapis. Chayraycu payta mana jap'iyta atincuchu. Kancunarí payta chekata rejsinquichej kancunawan tiyacushaskanraycu. Paywan ujchaskataj canquichej. ");
INSERT INTO quhNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Cay pachapi manamin wajchatajinachu sapasllata sakeskayquichej. Manachayrí kancunaman cutimusaj. ");
INSERT INTO quhNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Uj chhicamantawan cay pacha runas manaña ricuwankancuchu. Kancunarí ricuwanquichejraj. Nokaka wiñay causayniyoj cani. Chayraycu kancunapis wiñay causayniyoj canquichej. ");
INSERT INTO quhNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Sumaj p'unchay jamushan. Chay p'unchaypi yachanquichej nokaka Tataywan ujchaska caskayta. Chaypacha kancunapis nokawan ujchaska canquichej, nokataj kancunawan. ");
INSERT INTO quhNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Niskasniyta jap'ispa casojka, chay runalla munacuwan. Chay munacuwajtataj Tatay munaconka. Nokapis chay runataka munacusaj, sonkonpitaj sut'ita rejsichicusaj, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas, mana Iscariote cajchu, payta taporka: —Señorníy ¿imaynataj cunan nokallaycuman sut'ita rejsichicuwasajcu, manataj cay pacha runasmanka? ");
INSERT INTO quhNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesustaj cuticherka: —Nokata munacuwajka niskayta casonka, Tataytaj payta munaconka. Paymantaj jamusajcu sonkonpi tiyacunaycupaj. ");
INSERT INTO quhNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nokata mana munacuwajka niskayta mana casunchu. Niskayta uyariskayquichejka mana nokajtachu, manachayrí cachamuwajniy Tataypatamin. ");
INSERT INTO quhNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","‘Chay imastari nerkayquichej kancunawan cashasparaj. ");
INSERT INTO quhNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Chay Yanapaj Santo Espiritutarí Tatay sutiypi cachamonka. Paymin mosoj causayniyquichejpi tucuy imata yachachisonkachej. Noka nerkayquichej, tucuy chay niskasniyta yuyarichisonkachejtaj. ");
INSERT INTO quhNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","‘C'acha causaypi canayquichejpaj Diosman allinyacherkayquichej. Nokanejllata c'acha causayka tiyan. Nokalla c'achata causachiyquichej. Cay pacha runaska chayta mana atincuchu. Ama sonko nanayta llaquicuychejchu nitaj manchachicuychejchu. ");
INSERT INTO quhNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Noka kancunaman niskayta uyarerkanquichejña. Nerkani: Ripushani, ujtawan kancunaman cutimusajtaj, nispa. Munacuwaspaka cusicuwajchej carka Tatayman ripushaskayraycu. Tatayka aswanmin cashan nokamanta niskaka. Chayraycu kancunapaj cusiy canka. ");
INSERT INTO quhNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Cunanri chayta nerkayquichej manaraj rishaspa khepata nokapi jap'icunayquichejpaj. ");
INSERT INTO quhNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","‘Manaña ashqhatañachu kancunawan parlasaj. Cay pachata camachej supay Satanás jamushanña. Nokatarí mana camachiwayta atinchu. ");
INSERT INTO quhNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Astawanrí Tataypa yuyaskanmanjina tucuy ima ruwaska canka. Chaynejtataj tucuy runas yachankancu Tatayta munacuskayta Tataypa niskanmanjina tucuy imata ruwaskaytapis. Jataricuychej, jacu llojsipuna. ");
INSERT INTO quhNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","‘Noka cani cheka uva sach'a, Tataytaj chayta llanc'ajka. ");
INSERT INTO quhNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Uvawan llanc'ajka tucuy mana pokoj ramata c'utun. Tucuy pokoj ramatarí c'utun astawan pokonanpaj. Ajinallatataj nokawan ujchaska runasniywan Tatayka ruwan. ");
INSERT INTO quhNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nisuskayquichejnejta juchamanta llimphuchaskasña canquichej. ");
INSERT INTO quhNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nokapi jap'icuwaspa cacuychej, nokataj kancunawanpuni cacusaj. Ajinapi ujchaska canchej. Uj rama mana sach'api cacuspaka mana pokoyta atinchu. Quiquillantataj sichus nokapi jap'icuspa mana cacuwajchejchu chayka, kancunapis mana c'acha runas cayta atinquichejchu. ");
INSERT INTO quhNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","‘Noka cani uva sach'ajina kancunataj ramasniyjina. Nokawan ujchaska cajlla c'acha causayniyoj cashanquichej ashqha pokoyniyoj ramajina. Mana nokawan ujchaska caspaka ni imata ruwayta atinquichejchu. ");
INSERT INTO quhNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nokawan mana ujchaska cacoj runaka c'utuska ramajinamin. C'utuska ramaska wijch'ucun ch'aquinanpaj. Chaymantataj tantacun ninaman ruphachiska cananpaj. ");
INSERT INTO quhNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","‘Nokawan ujchaskachus cacunquichej niskasniypis sonkoyquichejpi chayka, imatachus munaskayquichejta Diosmanta mañacuychej. Kancunamantaj kosonka. ");
INSERT INTO quhNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","C'acha causayniyoj caskayquichejka ashqha pokoyjinamin. Chaywan Tatayta jatunchanquichej, yachacojcunay caskayquichejtataj ricuchinquichej. ");
INSERT INTO quhNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Imaynatachus Tatay munacuwan, ajinallatataj nokapis munacuyquichej. Ajinata munacuyniypi causacuychej. ");
INSERT INTO quhNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Niskasniyta casuspalla munacuyniypi causacunquichej. Imaynatachus noka Tataypa niskasninta casuni, paytaj munacushallawanpuni, ajinallatataj niskasniyta casuwajchej chayka, nokapis munacuyquichej. ");
INSERT INTO quhNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","‘Chay imasta nerkayquichej nokajina cusiskas canayquichejpaj quiquin cusiywan junt'a canayquichejpajtaj. ");
INSERT INTO quhNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","‘Caymin niskayka: Imaynatachus noka munacorkayquichej quiquillantataj kancunapura munanacuychej. ");
INSERT INTO quhNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Uj runa amigosninraycu wañuycama churacojtenka chekatapunimin munacun. Chayjina munacuymanta astawanka mana canchu. ");
INSERT INTO quhNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Niskasniymanjinachus ruwanquichej chayka, amigosniy canquichej. ");
INSERT INTO quhNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Manaña camachitachu sutichayquichej. Uj camacheka camachejnin imatachus ruwashaskanta mana yachanchu. Tataymanta tucuy uyariskayta willarkayquichej. Chayraycu amigosniyta sutichayquichej. ");
INSERT INTO quhNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mana kancunachu nokata ajllacuwarkanquichej. Manachayrí noka kancunata ajllacorkayquichej runasman willajtataj cacharkayquichej. Willaskayquichejwan runas nokapi jap'icojtincu cusiskas canquichej. Cusiyniyquichejtaj wiñaypaj canka. Ajinapitaj nokawan ujchaska caspa imatachus Dios Tatamanta mañacunquichej, chayta kosonkachej. ");
INSERT INTO quhNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Cayta niyquichej: Kancunapura munanacuychej, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Nerkataj: —Cay pacha runas kancunata chejnisojtiyquichejka reparaychej nokata ñaupajta chejniwaskancuta. ");
INSERT INTO quhNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Cay pacha runaswan causaynincupi ujlla cawajchej chayka, cay pacha runaska munacusunquichejman carka. Astawanrí cay pacha runaswan causaynincupi mana ujllachu canquichej. Manachayrí noka cay pacha runasmanta ajllacorkayquichej nokapi jap'icunayquichejpaj. Chayraycu cay pacha runas chejnicusunquichej. ");
INSERT INTO quhNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Yuyaricuychej kancunaman cayta nisuskayta: Camacheka mana aswan curajpaj khawaskachu camachejninmantaka. Sichus nokata ñac'arichiwarkancu chayka, kancunatapis ñac'arichillasonkachejtaj. Sichus niskayta casorkancu chayka, kancunajtapis casullankancutaj. ");
INSERT INTO quhNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Astawanrí tucuy mana allin cajta ruwasonkachej nokaj yachacojcunay caskayquichejraycu. Paycunaka cachamuwajniyta mana rejsincuchu. ");
INSERT INTO quhNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","‘Sichus paycunaman mana jamuymanchu nitaj parlaymanchu carka chayka, mana juchachaskachu cancuman carka. Cunanrí ni imata atincuchu juchancuraycu cutichiyta. ");
INSERT INTO quhNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nokata chejniwajka Tataytapis chejnicullantaj. ");
INSERT INTO quhNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Tucuy runamanta aswan jatuchej ruwanasta paycunaj ñaupakencupi ruwarkani. Chay jatuchej ruwaskasniytachus mana ricuncumanchu carka chayka, mana juchachaskaschu cancuman carka. Cunanrí ricuncuña chejniwaycutaj nokata Tataytapis. ");
INSERT INTO quhNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ajinaka Diospa palabranpi paycunamanta kelkaska junt'acun: “Khasimanta chejnicuwarkancu”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","‘Tataymanta Yanapajta kancunaman noka cachamusaj. Payka cheka Espíritu Tataymanta cajmin. Mayc'ajchus jamonka chaypacha sut'ita nokamanta pay willanka. ");
INSERT INTO quhNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kancunapis nokamanta willanquichej wajyacususkaymantapacha nokawan caskayquichejraycu. ");
INSERT INTO quhNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","‘Cay imasta nerkayquichej Diospi jap'icuskayquichejmanta ama urmanayquichejpaj. ");
INSERT INTO quhNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ñac'ariy p'unchaycuna jamushan. Chay p'unchaycunapeka tantacuna-wasisnincumanta kharkosonkachej. Astawanpis wañuchisojka yuyanka chaywan Diosta yupaychashaskanta. ");
INSERT INTO quhNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Paycunaka Dios Tatata mana rejsincuchu ni nokatapis rejsiwancuchu. Chayraycu ajinata ruwankancu. ");
INSERT INTO quhNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","‘Cay imastarí nerkayquichej chay p'unchaycuna chayamojtin cay niskayta yuyaricunayquichejpaj. Ñaupajpiri muchunayquichejmantaka mana willarkayquichejchu kancunawanraj cashaskayraycu. ");
INSERT INTO quhNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Cunanka ripushaniña cachamuwajniypaman. Kancunamantarí ni pi tapuwanchu: “¿Maymantaj rishanqui?” nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Astawanpis chay imasta nisuskayquichejmanta maytaraj phuticushanquichej. ");
INSERT INTO quhNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","‘Nokaka chekata niyquichej, kancunaj allinniyquichejpaj ripunayta. Mana ripuyman chayka, chay Yanapajka mana jamunmanchu. Ripusaj chayrí kancunaman payta cachamuskayquichej. ");
INSERT INTO quhNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Jamuspataj payka cay pacha runasta juchamanta, chekan caymanta, juiciomantawan reparachenka. ");
INSERT INTO quhNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Juchamanta reparachenka nokapi mana jap'icuskancuraycu. ");
INSERT INTO quhNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Chekan caymanta reparachenka Tatayman ripushaskayraycu manañataj ricuwanquichejchu. Ruwanasniyta tucuspaña Tatayman ripushani. Chay ruwanasniynejllata Tatayka runata chekanpaj khawan. ");
INSERT INTO quhNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Juiciomantataj reparachenka sajra camachejnincu supay Satanás juchachaskaña caskanraycu. Chay quinsa imasmanta Santo Espíritu cay pacha runasta reparachenka. ");
INSERT INTO quhNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","‘Cay niskasniymanta ashqhataraj parlanay tiyan. Cunanrí mana chayta entiendeyta atinquichejchu. ");
INSERT INTO quhNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Santo Espiriturí jamuspa kancunata pusasonkachej tucuy cheka cajta yachanayquichejpaj. Payka mana pay quiquinmantachu parlanka. Manachayrí imatachus uyariskanta parlanka. Paytaj jamoj imasmantapis sut'inchasonkachej. ");
INSERT INTO quhNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Niskayta jap'ispa kancunaman sut'inchasonkachej. Ajinapi nokata jatunchawanka. ");
INSERT INTO quhNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Dios Tatajta tucuy niskanka nokajtapis. Chayraycu nerkayquichej: Nokaj niskayta jap'ispa Santo Espíritu sut'inchasonkachej. ");
INSERT INTO quhNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","‘Uj chhicamantawan manaña ricuwanquichejchu. Uj chhicamantawantaj ujtawan ricuwanquichej, —nerka Jesus. ");
INSERT INTO quhNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Chay niskanmanta waquin yachacojcunan paycunapura ninacusharkancu: —¿Imataj chay niwaskanchejrí? Nin: “Uj chhicamantawan manaña ricuwanquichejchu. Uj chhicamantawantaj ujtawan ricuwanquichej”, nispa. ¿Imataj chay: “Tatayman ripushani”, niwaskanchejrí? ");
INSERT INTO quhNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ninacusharkancutaj: —¿Imaynataj cay “chhicamantawan?” Mana yachanchejchu imamantachus parlaskanta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Chay niskanmanta tapuyta munashaskancuta Jesús yacharka. Chayraycu paycunata nerka: —Nerkayquichej: Uj chhicamantawan manaña ricuwanquichejchu. Uj chhicamantawantaj ujtawan ricuwanquichej. ¿Chay niskaymantachu tapunacushanquichej? ");
INSERT INTO quhNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Chekatapuni niyquichej: Kancunaka phutiywan wakanquichej. Cay pacha runasrí cusiconkancu. Astawanpis kancunapajka chay phutiyniyquichej cusiyman tuconka. ");
INSERT INTO quhNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Yachanquichej onkocoj warmeka onkocunan hora chayamojtin llaquicun. Wawan nacecojtinñarí llaquiyninta manaña yuyaricunchu. Astawanrí cay pachapi uj wawa nacecuskanraycu cusicun warmeka. ");
INSERT INTO quhNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ajinallataj kancunapis cunan llaquiskas cashanquichej. Nokarí ujtawan ricuskayquichej. Sonkoyquichejtaj cusiska canka. Chay cusiytari kancunamanta ni pi khechusonkachejchu. ");
INSERT INTO quhNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","‘Chay p'unchaypitaj nokamanta ni imata tapuwanquichejchu. Chekatapuni niyquichej: Imatachus Dios Tatamanta mañacuwajchej sutiypi chayta kosonkachej. ");
INSERT INTO quhNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Manaraj cunancama ni imata sutiypi Diosmanta mañacorkanquichejchu. Nokawan ujchaska caskayquichejraycurí sutiypi Tataymanta mañacuychej jap'inquichejtaj cusiywan junt'a canayquichejpaj. ");
INSERT INTO quhNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","‘Chay niskasniyka manaraj sut'ichu, rijch'acuycunallarajmin. Chay jamoj p'unchaypirí manaña ajinawanchu parlaskayquichej. Manachayrí sut'ita Tataymanta parlaskayquichej. ");
INSERT INTO quhNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Chay p'unchaypi nokata sonkoyquichejwan rejsiwaspa sutiypi Diosmanta mañacunquichej. Mana niyquichejchu Tatayta kancunapaj nipusunaytaka, ");
INSERT INTO quhNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","pay quiquin kancunata munacususkayquichejraycu. Nokata kancuna munacuwanquichej, Diosmanta cachamuska Wawan caskaytataj creenquichej. Chayraycu Tatay munacusunquichej. ");
INSERT INTO quhNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Tataymanta llojsimorkani cay pachamantaj jamorkani. Cunantaj cay pachamanta llojsipushani, Tataymantaj ripushani, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Yachacojcunanka payta nerkancu: —Cunanka sut'ita parlanqui manataj rijch'acuywanchu ninqui. ");
INSERT INTO quhNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Cunanmin yachaycu tucuy imata yachaskayquita manataj runa tapusunanta suyanayquichu tiyan. Chayraycu Diosmanta cachamuska Wawan caskayquita jap'icuycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús paycunaman nerka: —Cunanka nokapi jap'icushanquichej. ");
INSERT INTO quhNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","¡Khaway! Chay hora jamunña chayamunñataj. Kancunari ch'ekeraskas canquichej sapa ujtaj quiquin wasinman aykecunquichej. Nokatataj sapallayta sakerpawanquichej. Nokarí manataj sapallaychu cani. Tatay nokawanpuni cashan. ");
INSERT INTO quhNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Chay imasta nerkayquichej nokanejta Diosman allinyachiskas caspa allillanta causanayquichejpaj. Cay pachapi llaquichiskas canquichej. Nokarí cay pachata atiparkaniña. Chayraycu sonkoyquichejpi callpachacuychej, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Chay imasta nispaka Jesús janaj pachaman khawarerka nerkataj: —Tatáy, chay hora chayamunña. Noka Wawayquita jatunchaway noka Wawayquitaj kanta jatunchasunaypaj. ");
INSERT INTO quhNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Imaraycuchus nokaman atiyta kowarkanqui tucuy runas atiyniypi canancupaj. Ajinapi tucuy nokapi jap'icojcunaman wiñay causayta kosaj. ");
INSERT INTO quhNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kan c'ata cheka Dios canqui nokatataj cachamuwarkanqui. Kanta nokatapis rejsispalla nokanchejwan ujchacuspataj runaka cheka causayman yaycun. Ajina ujchaska caymin wiñay causayka. ");
INSERT INTO quhNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Noka cay pachapi kanta jatuncharkayqui, kowaskayqui ruwanata tucuspa. ");
INSERT INTO quhNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tatáy, manaraj cay pacha ruwaska cashajtin, kanwan cuscapuni carkani. Kanpa cheka cayniyquiwantaj jatunchaska carkani. Cunanka jatunchaway chay quiquin atiyniyoj cayniyquimanjina. ");
INSERT INTO quhNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","‘Cay pacha runasmanta ajllaskacunata kowarkanqui nokajta canancupaj. Kanpata carkancu nokamantaj kopuwarkanqui. Chay ajllaskacunamantaj cheka cayniyquita sut'ita ricucherkani niskayquitataj casorkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","8","Cay runasniyman willanayta niwarkanqui, chay niskayquita paycunaman willarkani. Paycunataj niskayquita jap'icorkancu, kanmanta caskanta chekata yachaspa. Yachancuñataj noka kanmanta jamuskayta. Kan cachamuwaskayquitapis creerkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","‘Paycunapaj noka nicushayqui, manataj cay pacha runaspajchu. Manachayrí kowaskayqui runasniypaj nicushayqui kanpata caskancuraycu. ");
INSERT INTO quhNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tucuy nokajta cajka kanpata cashan. Tucuy kanpata cajpis nokajtamin. Cay runasninchejnejtataj jatunchaska cani. ");
INSERT INTO quhNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","‘Manaña cay pachapichu caj rishani. Paycunarí cay pachapi cancu. Nokataj kanman jamushani. Santo Tatáy, kowaskayquicunata atiyniyquiwan wakaychay, nokanchejjina ujlla canancupaj. ");
INSERT INTO quhNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Paycunawan cashaspaka kowaskayquicunata atiyniyquiwan wakaycharkani. Chayraycu ni uj paycunamanta chincapunchu. Astawanrí chincapunan carka, chaylla chincapun palabrayquimanjina. ");
INSERT INTO quhNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","‘Cunanrí kanman jampushaniña. Cay pachapi cashaspataj cay imasta parlani kowaskayquicuna mayta cusicunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Niskayquita paycunaman willarkaniña, cay pacha runastaj paycunata chejnerkancu. Imaynachus noka mana cay pachamantachu cani, quiquillantaj paycunapis mana cay pacha runaswan causaynincupi ujllachu cancu. Chayraycu cay pacha runas paycunata chejnincu. ");
INSERT INTO quhNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mana nishayquichu cay pachamanta paycunata orkhopunayquita. Manachayrí sajra cajmanta wakaychanayquita nicuyqui. ");
INSERT INTO quhNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Imaynachus noka mana cay sajra pachamantachu cani quiquillantaj paycunapis mana cay sajra pachamantachu cancu. ");
INSERT INTO quhNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Cheka cajmanjina paycunata kanman t'akay llimphu sonkoyoj canancupaj. Niskayqueka cheka cajmin. ");
INSERT INTO quhNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Imaynatachus nokata cachamuwarkanqui cay pachaman, ajinallatataj nokapis paycunata cacharkani cay pacha runasman willaramunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Noka kanman t'akacuni munayniyquipi paycunata wakaychanaypaj. Ajinapi paycunapis cheka niskayquinejta kanman t'akaskas cankancu. ");
INSERT INTO quhNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","‘Mana paycunallapajchu nicuyqui. Manachayrí willaskancunejta nokapi jap'icojcunapajpis nicuyqui ");
INSERT INTO quhNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ujlla canancupaj. Kan, Tatáy, nokapi cashanqui nokapis kanpi cani. Ajinapi nokanchejpis tucuy paycunawan ujlla casunchej. Ajinapitaj cay pacha runas kan cachamuwaskayquita creenkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Kanwan ujlla caskaypi jatunchawarkanqui. Nokapis paycunawan ujchacuspa paycunata jatuncharkani nokanchejjina ujlla canancupaj. ");
INSERT INTO quhNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Noka paycunapi tiyacuni, kantaj nokapi tiyacunqui, paycunapis ujlla canancupaj. Causaynincupi ruwashani nokaman rijch'acoj ujlla canancucama. Munacuyninchejpi ujlla cajtincutaj cay pacha runas cachamuwaskayquita yachankancu. Yachankancutaj imaynatachus nokata munacuwaskayquita, paycunatapis munacuskayquita. ");
INSERT INTO quhNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","‘Tatáy, munani kowaskayqui runasniy nokawan cusca canancuta. Ajinapi paycunaka wiñaypaj jatunchawaskayquita khawaspa cusiconkancu. Manaraj cay pachata ruwashaspa munacuwaskayquiraycu jatunchawanqui. ");
INSERT INTO quhNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Chekan Tatáy, cay pacha runaska mana munarkancuchu rejsisuyta. Nokarí kanta rejsiyquipuni. Kowaskayqui runasniypis cachamuwaskayquita yachancu. ");
INSERT INTO quhNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Imaynachus caskayquita paycunaman sut'incharkani, sut'inchasajpunitaj c'acha munacuyniyquita rejsinancupaj. C'acha munacuyniyquiwan munacuwarkanqui. Cay munacuywantaj nokapis paycunapi tiyacusaj, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Chay imasta niskanmanta Jesús yachacojcunanwan llajta jawaman llojserka. Cedrón niska ch'aqui mayu chimpaman uj huertaman rerkancu. Chay huertamantaj yachacojcunanwan yaycorka. ");
INSERT INTO quhNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jesuska yachacojcunanwan ashqha cutita chayman rejpuni. Chayraycu payta jaywaycusharka, chay Judaska chay huertata rejserka. ");
INSERT INTO quhNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ajinamanta Judaska uj jatun tropa soldadosta pusariycucuspa chayman jamorka. Pusamuskasnin uqhupi carkancu israel curajcunaj yanapajcunancu. Jamorkancu, jatun c'anchanaswan ima, makanaswanpis. ");
INSERT INTO quhNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesuska tucuy imata paywan ruwanancuta yachaspa llojserka nerkataj: —¿Pitataj masc'anquichej? ");
INSERT INTO quhNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Paycunataj cuticherkancu: —Nazaret llajtayoj Jesusta, —nispa. Jesusri nerka: —Noka cani, —nispa. Jaywaycushaj Judasri jap'iycojcunawan sayasharka. ");
INSERT INTO quhNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesús paycunaman: “Noka cani” nejtintaj paycunaka khepaman ithirispa pampaman urmarkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesuska chayraycu ujtawan taporka: —¿Pitataj masc'anquichej? Nerkancutaj: —Nazaret llajtayoj Jesusta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesusrí cuticherka: —Noka cani, nerkayquichejñaka. Sichus nokata masc'awanquichej chayka, sakeychej cay runas ripunancuta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ajinapi junt'acorka Jesuspa niskan: “Kowaskayquicunamanta ni uj chincapunchu”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simón Pedrotaj espadayoj carka. Chayta orkhospa uj runaj paña ningrinpi wajtaspataj c'uturparerka. Chay runari yupaychana-wasipi camachejpa camachin carka, Malco sutiyoj. ");
INSERT INTO quhNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesusrí Pedroman nerka: —Espadayquita churay wakaychanaman. Tatay cay ñac'arinaypaj churawarka ¿chayta manachu junt'asaj? ");
INSERT INTO quhNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ajinapi chay tropa soldados camachejnincuwan curajcunaj yanapajcunancupiwan Jesusta jap'iycuspa wataycorkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ñaupajtari pusarkancu Anaspa ñaupakenman. Payka yupaychana-wasimanta curaj Caifaspa suegron carka. Cay watapaj Caifaska curaj cananpaj churaska carka. ");
INSERT INTO quhNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Payka israel curajcunata caywan yuyaycharka: “Aswan allin cashan uj runa wañunan tucuy Diospa ajllaska runasninpaj”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Caifaspa wasinman Jesusta khatisharkancu Simón Pedrowan waj yachacojpiwan. Cay waj yachacojka curajpa rejsiskan caspa patioman Jesuswan yaycorka. ");
INSERT INTO quhNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedrorí puncu jawapi sayacusharka. Chayraycu curajpa rejsiskan yachacojka llojsispa puncu khawaj warmiman nerka Pedro yaycumunanta. ");
INSERT INTO quhNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ajinapi chay puncu khawaj warmeka Pedroman nerka: —¿Manachu kanpis chay runaj yachacojcunanmanta canqui? Pedrori nerka: —Mana, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Chiri caskanraycu wasi camachis chay yanapajcunapiwan patiopi ninata jap'icherkancu k'oñicunancupaj. Pedropis paycunawan casharka chaypi k'oñicuspa. ");
INSERT INTO quhNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Yupaychana-wasimanta curajka Jesusta taporka yachacojcunanmanta yachachiyninmantapis. ");
INSERT INTO quhNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesusri cuticherka: —Nokaka tucuy runaspa ñaupakencupipuni sut'ita parlarkani. Tantacuna-wasispipuni yupaychana-wasi patiopipis yachacherkani. Chaypeka tucuy israelcuna tantacuncu. Nitaj imatapis pacaypeka parlarkanichu. ");
INSERT INTO quhNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Imaraycutaj tapuwanqui? Tapuy uyariwajcunata. Paycuna yachancu imatachus niskayta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Chayta niskantawantaj chaypi sayashaj yanapajcunamanta ujka Jesusta lak'arka nerkataj: —¿Ajinatachu curajninchejman cutichinqui? ");
INSERT INTO quhNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesusri cuticherka: —Sichus mana allinta parlarkani chayka, chay parlaskaymanta sut'ita willay. Allintachus parlarkani chayka ¿imaraycutaj lak'awarkanquirí? ");
INSERT INTO quhNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anastaj Jesusta ajina wataskata cacharka curaj Caifaspaman. ");
INSERT INTO quhNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simón Pedrotaj nina kayllapi sayacusharka k'oñicuspa. Ajinapi chaypi cajcunaka payta nerkancu: —¿Manachu kanpis yachacojcunanmanta canqui? Paytaj sinch'ita nerka: —Manapuni, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Curajpa uj camachenka nillarkataj: —¿Manachu kanta huertapi paywan ricorkayqui? Huertapi Pedro ningrinta c'utorka chay runaj ayllun carka chayta nejka. ");
INSERT INTO quhNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ujtawan Pedroka mananchacorka. Chay quiquinpachataj galloka wakarka. ");
INSERT INTO quhNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ajinapi Caifaspa ñaupakenmanta Pilato tiyacoj sumaj wasiman Jesusta pusarkancu. Tutamantataj carka. Israel curajcunaka llimphu canancu caj costumbrencumanjina pascua miqhunata miqhunancupaj. Chayraycu chay sumaj wasiman yaycuyta mana munarkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ajinamanta Pilatoka llojsimorka paycuna casharkancu, chayman, nerkataj: —¿Imata juchachaspataj cay runata apamunquichej? ");
INSERT INTO quhNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Paymantaj cuticherkancu: —Mana sajrata ruwaj cajtenka mana kanman jaywaycumanchu carka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatotaj paycunaman nerka: —Kancuna payta apaychej. Leyniyquichejmanjina juchanta khawaychej, —nispa. Israel curajcunataj payman nerkancu: —Romano leymanjina mana atiycuchu runata wañunanpaj juchachaytaka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jesús ñaupajta sut'incharkaña imaynata wañunanta. Ajinapi chay niskancunejta Jesuspa niskan junt'acorka. ");
INSERT INTO quhNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatoka wasiman ujtawan cutiycorka. Jesusta ñaupakenman pusachimuspataj taporka: —¿Kanchu canqui israelcunaj camachejnin? ");
INSERT INTO quhNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesusri nerka: —¿Yuyayniyquimantachu chayrí nokamanta willaskancuraycullachu chayta tapuwanqui? ");
INSERT INTO quhNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatotaj cuticherka: —¡Nokaka mana paycunajina israel runachu cani! Llajta-masisniyqui yupaychana-wasimanta curajcunapiwan nokaman kanta jaywaycuwarkancu. ¿Ima mana allintataj ruwarkanquirí? ");
INSERT INTO quhNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesusri cuticherka: —Mana cay pachamanta camachejchu cani. Sichus cay pachamanta camachej cayman chayka, yanapajcunay cancuman carka. Paycunataj makanacuncuman carka israel curajcunaman mana jaywaycuska canaypaj. Cunanka camachinaypaj atiyniyka mana cay pachamantachu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Chayraycu Pilatoka nerka: —Ajinaka ¿camachejchu kanka canqui? Jesusri cuticherka: —Kan ninqui ajinamin, camachej cani. Chaypaj nacecorkani. Camachej caspataj cheka cajta willanaypaj cay pachaman jamorkani. Cheka cajta munacojcunaka niskayta uyarispa casuncu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatotaj payman nerka: —¿Imataj cheka cajrí? Pilatoka chayta niskanmanta ujtawan llojsimorka israel curajcunaman nerkataj Jesusmanta: —Nokaka paypi ni imata tarinichu juchachanapajjinaka. ");
INSERT INTO quhNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Cunanri costumbremanjinaka pascua p'unchaypi uj wisk'aska runata cacharinay tiyan kancunapaj. Chayraycu ¿munanquichejchu israelcunaj camachejninta cacharinayta kancunapaj? ");
INSERT INTO quhNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Chaymantataj ujtawan sinch'ita khaparerkancu: —¡Ama chay runataka, manachayrí Barrabasta cacharipuwaycu! —nispa. Barrabasri runa wañuchi suwa carka. ");
INSERT INTO quhNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Chayraycu Pilatoka Jesusta pusaycuchispa jasut'icherka. ");
INSERT INTO quhNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Asipayanancupajtaj qhishcamanta uj pilluta soldados simp'arkancu. Chaytataj umanman churarkancu. Camachejtajinataj p'achallerkancu culli-puca p'achawan. ");
INSERT INTO quhNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Payman kayllamusharkancu nisharkancutaj: —¡Viva, israelcunaj camachejnin! —nispa. Payta lak'asharkancutaj. ");
INSERT INTO quhNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Watejmanta Pilatoka jawaman llojsimorka paycunamantaj nerka: —¡Khawaychej, jawaman payta pusamuyquichej ni ima juchata paypi tariskayta yachanayquichejpaj! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jesusri llojsimorka umanpi qhishca pilluwan churaska chay culli-puca p'achawan p'achalliskataj. Pilatoka paycunaman nerka: —¡Cay chay runaka! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Yupaychana-wasimanta curajcunarí yanapajcunapiwan Jesusta ricuspa mayta khaparerkancu: —¡Chacataycuy, chacataycuy! —nispa. Pilatori nerka: —Kancuna jap'iychejpis, chacataychejpis, imanaychejpis. Nokaka mana paypi juchata tarinichu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Israel curajcunaka cuticherkancu: —Nokaycojta leyniycu capuwaycu. Chaymanjinataj chay runaka wañunan tiyan Diospa Wawan ruwacapuskanraycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Chay niskancuta uyariskanmanta Pilatoka astawan manchachicaporka. ");
INSERT INTO quhNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ujtawan wasiman yaycuspataj Jesusta taporka: —¿Maymantataj canquirí? Jesusrí ni imata cuticherkachu. ");
INSERT INTO quhNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Chayraycu Pilatoka taporka: —¿Manachu nokaman parlawanqui? ¿Manachu yachanqui atiyniyoj caskayta cacharisunaypaj chayrí chacatasunaypajpis? ");
INSERT INTO quhNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesustaj cuticherka: —Manachus Dios atiyta kosunquiman chayka, ni imata atiwajchu nokawan ruwayta. Chayraycu nokata kanman jaywawajka aswan juchayoj cashan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Chayta niskanraycutaj Pilatoka masc'asharka imaynapipis payta cacharipuyta. Israel curajcunarí khaparishallarkancupuni: —Sichus cay runata cacharipunqui chayka, mana Roma camachej Cesarpa amigonchu canqui. Pillapis pay quiquin camachejpaj ruwacojka Cesarpa contranpi churacun, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Chayta uyarispa Pilatoka jawaman pusacherka Jesusta. Chaypiri autoridad tiyaycunanpaj uj jatun tiyana churaska carka. Chay lugartaj, Gabata sutiyoj, rumiwan c'achitu ruwaska plazajina carka. Pilatotaj chay tiyanapi tiyaycucorka. ");
INSERT INTO quhNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Chay p'unchaytaj carka pascua waquichicuna, pakarin. Pilatori israel curajcunaman nerka: —¡Cayka camachejniyquichejka! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Chayraycu paycunaka khaparerkancu: —¡Wijch'uy, wijch'uy! ¡Chacataska cachun! —nispa. Pilatotaj paycunaman nerka: —¿Imayna? ¿Camachejniyquichejtachu chacatasaj? Yupaychana-wasimanta curajcunataj cuticherkancu: —¡Cesarlla camachejniycoka! ¡Mana wajka canchu! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Chayraycu Pilatoka paycunaman Jesusta jaywarka chacataska cananpaj. Paycunataj Jesuswan munaynincumanjina ruwarkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesusri cruzninta apaspa llojserka T'ojlu sutichaska lugarman. Hebreo parlaypi nej cancu, Gólgota. ");
INSERT INTO quhNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Chaypitaj payta chacatarkancu waj iscay runastawan ladosninpi. Jesustaj chaupi caj cruzpi carka. ");
INSERT INTO quhNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatoka uj kelkaskata ruwachispa cruznin patapi churacherka. Kelkaskaka nerka: “Cayka Nazaret llajtayoj Jesús, israelcunaj camachejnin”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jesús chacataska chay lugarka llajta kayllapi carka. Ajinapi israelcunamanta ashqhas chay kelkaskata leerkancu. Chaytaj hebreo, latín, griego parlaycunapi kelkaska carka. ");
INSERT INTO quhNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Chayraycu yupaychana-wasimanta curajcunaka Pilatoman nerkancu: —Ama kelkaychu, “Israelcunaj camachejnintaka”. Manachayrí, “Chay runa nerka, ‘Noka cani israelcunaj camachejnin’ ”. Ajinata kelkaycuy, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatotaj cuticherka: —Kelkaskayka, kelkaskaña, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Soldadoska Jesusta chacataskancumanta khepata p'achasninta jap'ispa tawaman parterkancu sapa ujnincupaj. Ujnin p'achantaj patamantapacha uj awaskalla carka, mana sirayniyoj. ");
INSERT INTO quhNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Chayraycu soldadoska ninacusharkancu: —Ama lliq'inachu caytaka, manachayka suertepi yachacuchun pipajchus cananta, —nispa. Chay ruwaskancuwan Diospa palabranpi cay kelkaska junt'acorka: “Suertesta chokaspa p'achasniyta partinacorkancu”. Ajinatataj chay soldadoska ruwarkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesuspa cruzninnejpi sayasharkancu maman, Cleofaspa warmin María (payka mamanpa hermanan), Magdala llajtayoj Mariapiwan. ");
INSERT INTO quhNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesuska mamanta munaska yachacojnintawan cusca sayashajta ricuspa, mamanman nerka: —Mamáy, caymin wawayqueka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Chay yachacojninmantaj nerka: —Caymin mamayqueka, —nispa. Chaymantapachataj chay yachacojka Jesuspa mamanta wasinman wajyacaporka. ");
INSERT INTO quhNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Chaymantataj Jesús tucuy imas paymanta tucuskaña caskanta yachaspa Diospa palabranmanjina nerka: —Ch'aquiwan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Uj yuru junt'a c'arcu ujyana chaypi carka. Uj esponjata chay ujyanaman chhapuspa hisopo c'aspiman churarkancu. Chaywantaj Jesuspa simincama taripacherkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Chay ujyanata ch'onkaricorka. Chaymantataj nerka: —Ruwanayta tucuniña, —nispa. Umanta c'umuycuspataj causayninta Diosman jaywacorka. ");
INSERT INTO quhNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Chayka samacuna p'unchaypaj waquichicunapi carka. Israel curajcunaka munarkancu ayas chacatanasmanta uraycuchiskas canancuta manaraj samacuna p'unchayta. Chay samacuna p'unchay may jatun caskanraycu ajinata munarkancu. Ajinapi Pilatoman nerkancu, cruzpi cajcunaj chaquisnincuta soldados p'aquiranancuta aswan uskhayta wañunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Chayraycu soldados Jesuswan chacataska cajcunamanta ujman chimpaspa chaquisninta p'aquerkancu. Ujnintapis quiquillantataj ruwarkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jesusman chimpamusparí paytaka wañuskataña tariparkancu. Chayraycu paypa chaquisnintaka mana p'aquerkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Astawanrí chay soldadosmanta ujnenka espadanwan Jesuspa wajtanta t'ujsiycorka. Chay quiquinpacha yawarwan yacuwan uqhunmanta llojsimorka. ");
INSERT INTO quhNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Noka chayta ricuspa willarkayquichejña. Willaskaytaj chekamin. Niskay cheka caskantataj Dios yachan. Chaytataj willarkayquichej Jesuspipuni jap'icunayquichejpaj. ");
INSERT INTO quhNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Chay imasnejtamin Diospa palabran junt'acorka: “Ni uj tullunpis p'aquiskachu canka”. ");
INSERT INTO quhNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Wajnejpitaj palabranka cayta nin: “T'ujsiskancu runata paycuna khawankancu”. ");
INSERT INTO quhNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Chay imasmanta khepata Arimatea llajtayoj José Pilatoman rerka ayata mañaj. Chay Joseka Jesuspa khaticojnin carka. Payka pacayllamanta khaticorka israel curajcunata manchachicuskanraycu. Pilatomanta mañajtintaj Pilatoka, “Apacapullay”, nerka. Chayraycu payka jamuspa Jesusta apacaporka. ");
INSERT INTO quhNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemopis jamullarkataj. Ñaupajpi Jesusman tuta jamoj runa, payka. Apamorka sumaj k'apayniyoj jampita mirrawan aloeswan chajruskata. Chay apamuskanka quintaljina carka. ");
INSERT INTO quhNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Paycunaka Jesusta okharispataj mayt'unaswan chay sumaj k'apayniyoj jampitawanpis churaycuspa mayt'uycorkancu. Chayta ruwarkancu israelcunaj p'ampana costumbrencumanjina. ");
INSERT INTO quhNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Chacataska carka chaynejpi uj huerta carka. Chay huertapitaj uj mosoj p'ampana ruwaska carka. Chay p'ampanapi ni uj ayapis churaskarajchu carka. ");
INSERT INTO quhNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Israelcunaj waquichicuna p'unchaynincu caskanraycu, kayllitapi chay p'ampana caskanraycupis, Jesusta chayman churarkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Domingo p'unchaypi Magdala llajtayoj María tutamanta lakhallataraj p'ampanaman jamorka. P'ampanapi churaska p'alta rumitataj wajnejman cuyuriskata ricorka. ");
INSERT INTO quhNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Chayraycu Simón Pedroman Jesuspa munaska yachacojninmanpis willaj uskhayta rerka. Nerkataj: —¡Señorninchejta p'ampanamanta apacapuskancu! Manataj yachaycuchu maymanchus payta churamuskancuta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Chayraycu Pedroka chay waj yachacojwan p'ampanaman rinancupaj llojserkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Chanta correspa iscaynincu rerkancu. Chay waj yachacojri aswan uskhayta rispa Pedrota atiparka. Ñaupajta p'ampanaman chayaspa ");
INSERT INTO quhNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","khawaycurispataj chaypi caj mayt'unasta ricorka, manataj yaycorkachu. ");
INSERT INTO quhNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Chaymanta Simón Pedroka paypa khepanta chayamorka. P'ampanamantaj yaycorka. Mayt'unastari sakeskata ricorka. ");
INSERT INTO quhNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Umanpi churaska mayt'unatataj manaña cay waj mayt'unaswan cuscatachu ricorka. Manachayka wajnejpi ricorka, imayna mayt'uskachus carka ajinata. ");
INSERT INTO quhNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Chanta ñaupaj jamoj yachacojpis p'ampanaman yaycuspa ricullarkataj, creeytataj kallarerka. ");
INSERT INTO quhNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Paycunaka manaraj entienderkancuchu Jesusmanta cayjina kelkaska caskanta, pay wañuymanta causarimunan tiyan. ");
INSERT INTO quhNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Chayraycu yachacojcunataj wasincuman cutiporkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mariaka p'ampana jusc'u jawapi wakaspa sayacusharka. Wakashaspataj p'ampana uqhuta khawaycorka. ");
INSERT INTO quhNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Chaypitaj iscay angelesta yuraj lliphipej p'achasniyojta tiyashajta ricorka. Jesús churaska carka, chaypi paycunata tiyashajta ricorka. Ujninta cabeceranpi, ujnintataj jayt'ananpi ricorka. ");
INSERT INTO quhNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Angelestaj nerkancu: —Doña ¿imaraycutaj wakashanquirí? Mariataj nerka: —Señorniyta apacapuskancu. Manataj yachanichu maymanchus payta churamuskancuta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Chayta niytawan khepaman cutiricuspa, Jesusta sayashajta ricorka manataj yacharkachu Jesús caskanta. ");
INSERT INTO quhNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesusri payta nerka: —Doña ¿imaraycutaj wakashanquirí? ¿Pitataj masc'ashanquirí? Mariaka hortelano caskanta yuyaspa payman nerka: —Señor, kan payta apacaporkanqui chayka, willaway maymanchus churamuskayquita, nokataj apacapusaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesusri payta nerka: —¡María! —nispa. Paytaj cutirimuspa kayllaycorka nerkataj: —¡Yachachejníy! ");
INSERT INTO quhNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesustaj nerka: —Amaña jap'iwaychu. Pisillataña kancunawan casaj, manaraj Tatayman wicharishaskayraycu. Kanrí riy hermanosniyman nimuy paycunaman: Wicharipushani Tataypaman, Tatayquichejpaman; Diosniyman, Diosniyquichejman, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Magdala llajtayoj Mariataj rerka yachacojcunaman willamoj: —¡Señorninchejta ricuni! —nispa. Willallarkataj imatachus payman niskantapis. ");
INSERT INTO quhNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Quiquin Domingo p'unchaypi ch'isiyayta yachacojcunanka tantacorkancu. Israel curajcunata manchachicuskancuraycu sumajta puncusta wisk'aycucorkancu. Jesusri yaycumorka paycunaj chaupincupitaj sayaycorka. Napaycorkataj: —Kancunapaj c'acha causay cachun, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Chayta niskanmanta maquisninta wajtantawan paycunaman ricuchicorka. Chayraycu yachacojcunan Señornincuta ricuspa mayta cusicorkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ujtawantaj paycunaman nerka: —Kancunapaj c'acha causay cachun. Dios Tatay nokata cachamuwarka, ajinallatataj nokapis kancunata cachayquichej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Chayta niytawan paycunaman phucuycorka nerkataj: —Santo Espirituta koshayquichej, jap'icuychej. ");
INSERT INTO quhNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ajinaka pimantapis juchasninta khechunquichej chayka, juchasnenka khechuskaña. Pitapis juchasninpi sakenquichej chayka, juchasnenka wiñaypaj apan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Mellizo niska Tomasrí chunca iscayniyoj yachacojcunanmanta uj carka. Payka Jesús jamorka, chay ch'isi mana chaypichu carka paycunawan. ");
INSERT INTO quhNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Chayraycu chay waj yachacojcunaka payman nisharkancu: —Señorninchejta ricorkaycu, —nispa. Payrí nerka: —Sichus maquisninpi clavo jusc'usta mana ricuymanchu, nitaj dedoyta chay clavo jusc'usman churaycuymanchu, maquiytapis mana wajtanman churaycuymanchu chayka, ni jayc'aj creesajchu pay causashaskantaka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Khepan Domingo ujtawan yachacojcuna chayllapitaj tantacorkancu. Tomaspis paycunawan casharka. Puncustaj sumaj wisk'askas carkancu. Jesusri yaycumorka, paycunaj chaupincupitaj sayaycorka. Napaycorkataj: —Kancunapaj c'acha causay cachun, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tomastataj nerka: —Dedoyquita apamuy khawaytaj maquisniyta. Maquiyquita apamuy wajtayman churaycuy. Amañataj mana jap'icojka caychu. Manachayrí nokapi jap'icuy, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomastaj cutichispa nerka: —¡Señorníy, Diosníy! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesustaj payman nerka: —Ricuskayquiraycu nokapi jap'icunqui. Waquinrí mana cayjinata riconkancuchu chaywanpis nokapi jap'icuwankancu. Paycunaka may cusiskas cankancu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesuska yachacojcunanpa ñaupakencupi ashqha waj ricuchinastaraj ruwarka. Chaycunaka mana cay libropi kelkaskachu cancu. ");
INSERT INTO quhNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Manachayrí cay waquin ricuchinaslla cay libropi kelkaskas cancu. Ajinapi chayta leespa yachanquichej Jesuska jamunan carka chay Cristo, Diospa Wawan, caskanta. Chayta creespa paypi jap'icuspataj wiñay causayniyoj canayquichejpaj cay libroka kelkaska carka. ");
INSERT INTO quhNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Chaymanta khepata ujtawan Jesuska yachacojcunanman pay quiquin ricuchicorka. Chayka carka Galilea kocha cantopi. Cayjinata riqhurerka. ");
INSERT INTO quhNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Chaypi kanchis yachacojcuna cusca casharkancu. Simón Pedro, mellizo Tomás, Caná llajtayoj Natanael, Zebedeoj wawasnin, iscay waj yachacojcunapiwan carkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simón Pedrori paycunaman nerka: —Challwa jap'ej rishani, —nispa. Ujcunataj nerkancu: —Jacu nokaycuwanpis, —nispa. Rispataj barcoman yaycorkancu. Chay tutapirí nitaj uj challwatapis jap'erkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Sut'iyamuytataj Jesuska kocha cantopi sayashaj riqhurerka. Yachacojcunari mana yacharkancuchu Jesús caskanta. ");
INSERT INTO quhNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesustaj paycunaman nerka: —Amigos ¿manachu challwa capusunquichej? Paycunataj cuticherkancu: —Manamin, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesustaj paycunaman nerka: —Barcoj pañannejman ch'ipayquichejta chokaycuychej jap'inquichejtaj, —nispa. Ajinataj paycunaka ch'ipancuta chokaycorkancu. Orkhoytataj manaña aterkancuchu challwa junt'a caskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Chayraycu Jesuspa munacuskan yachacojka Pedroman nerka: —Señorninchej, payka, —nispa. “Señorninchej, payka”, nejta uyarispataj Simón Pedroka jawa p'achanta chumpiycucorka, chay p'achaka llanc'ashaskanraycu orkhoska carka. Chayta ruwaspataj kochaman phinquiycorka. ");
INSERT INTO quhNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Barcoka mana carupichu carka cantomanta, pachaj metropijinalla. Chayraycu chay waj yachacojcunaka cantoman barcota apamorkancu challwatataj ch'ipa junt'ata aysamusharkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Jallp'aman llojsispataj nina brasa patapi challwatawan t'antatawan churaskata ricorkancu. ");
INSERT INTO quhNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesusri paycunaman nerka: —Jap'iskayquichejmanta challwasta apamuychej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ajinapi Simón Pedroka ch'ipata challwa junt'askata jallp'aman aysamorka. Pachaj phishka chunca quinsayoj jatuchej challwastaj carka. Chaywanpis ch'ipancoka mana lliq'icorkachu. ");
INSERT INTO quhNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesustaj paycunaman nerka: —Jamuychej, miqhucuychej, —nispa. Yachacojcunanmantataj ni mayken tapoj churacorkancuchu: “¿Pitaj canqui?” nispa, Señornincu caskanta yachaspa. ");
INSERT INTO quhNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesustaj nina brasaman chimpaspa t'antata okharispa paycunaman jaywarka, challwatapis quiquillantataj. ");
INSERT INTO quhNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Wañuymanta causarimuskanmanta Jesús yachacojcunanman riqhuriskanka quinsa caj cuti carka. ");
INSERT INTO quhNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Miqhuskancutawan Simón Pedrota Jesuska taporka: —Jonaspa wawan Simonníy ¿paycunamanta astawanchu munacuwanqui? Pedrotaj nerka: —Arí, Señorníy, kan yachanqui munacususkayta, —nispa. Jesusri nerka: —Yachachiy mosoj nokapi jap'icuwajcunayta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Iscay caj cutita payman taporka: —Jonaspa wawan Simonníy ¿munacuwanquichu? Paytaj nerka: —Arí, Señorníy, kan yachanqui munacususkayta, —nispa. Jesustaj nerka: —Runasniyta khawapuway, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Quinsa caj cutita taporka: —Jonaspa wawan Simonníy ¿munacuwanquichu? Pedrori quinsa cutita, “¿Munacuwanquichu?” tapuskanraycu phuticorka. Nerkataj: —Señorníy, tucuy imata yachanqui. Kan yachanquiña munacususkayta, —nispa. Jesustaj nerka: —Munaska runasniyta yachachiy. ");
INSERT INTO quhNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Chekatapuni niyqui: Joven cashaspaka chumpiycucoj canqui maymanchus munaskayquimantaj rej canqui. Viejoña casparí maquisniyquita okharinqui wajñataj chumpichisonka mana munaskayquimantaj pusasonka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Chaytataj nerka sut'inchananpaj Pedroka imayna wañuywanchus Diosta jatunchananta. Chayta niytawantaj Jesuska nerka: —Khaticuway, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedrotaj cutiricamuspa uj yachacojta khepanta rishajta ricorka. Chay yachacojka Jesuspa munaskan carka. Payka carka pascua miqhunata miqhunanpaj Jesuswan cusca tiyaycoj tapojtaj: “Señorníy ¿pitaj jaywaycusonkarí?” Chay yachacojta Pedroka ricorka. ");
INSERT INTO quhNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ricuspataj Pedroka Jesusta taporka: —Señorníy ¿imaynataj paywan canka? ");
INSERT INTO quhNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesustaj nerka: —Sichus munayman cutimunaycama pay causananta ¿imatá ruwanayqui tiyan? Khaticuway, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Chay niskanta uyariskancutawan yachacojpura parlaskancu carka, chay yachacoj mana wañunanmanta. Jesusrí mana nerkachu pay mana wañunantaka, manachayrí: “Sichus munayman cutimunaycama pay causananta ¿imatá ruwanayqui tiyan?” ");
INSERT INTO quhNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Chay imasmanta willaj cay librotapis kelkaj yachacojka chaymin. Yachaycutaj willaskasnin cheka caskanta. ");
INSERT INTO quhNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesuska may ashqha ruwaskasta ruwarka. Sichus chaycuna, ujmanta uj, librospi kelkacunman carka chayka, chay librosta churanapajka mana, sina, cay pachantinpipis campo canmanchu. Ajina cachun.");
INSERT INTO quhNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","3","Munaska Teófilo, ñaupajpi kelkamorkani Jesuspa tucuy ruwaskasninta yachachiskantawan Dios payta pusacapuskancama. Jesús cachasninta ajllacuspa Santo Espíritoj atiyninnejta yachacherka. Wañuskanmanta khepatataj pay quiquin causashaj cachasninman ashqha cutista riqhurerka. Tawa chunca p'unchaycunata paycunawan caspa ashqha jatuchej ricuchinasta ruwarka. Arí, pay munarka paycuna sumajta yachanancuta wañuskanmanta causarimpuskanta. Chay p'unchaycunapi paycunaman parlarka Dios camachin, chaymanta. Chanta khepatataj Dioska Jesusta okharispa janaj pachaman pusacaporka. ");
INSERT INTO quhNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Jesuska cay pachallapiraj cashaspa cachasninwan tantacorka. Camacherkataj paycunata: —Jerusalén llajtapi suyaychej Santo Espíritu kancunaman cachamuska canancama. Paytamin Tatay Dioska cachamunantapuni sumajta nerka. Chaytataj noka willarkayquichejña. ");
INSERT INTO quhNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Juanka runasta yacupi bautizarka, juchasnincuta sakejtincu. Pisi p'unchaycunamantarí Dios kancunata bautizaspa Santo Espirituta sonkoyquichejman cachamusonkachej payllapaj causanayquichejpaj, —nerka Jesús. ");
INSERT INTO quhNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jesuspa cachasnenka paywan tantaska cashaspa taporkancu: —Tucuy atiyniyoj Señor ¿cunanchu Israel llajta-masisninchejta cacharichispa sayachinqui camachinancupaj? ");
INSERT INTO quhNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesustaj paycunaman nerka: —Dios Tatallay chay imastaka munayninmanjina atiyninwantaj ruwanka. Mana munanchu yachanayquichejta jayc'ajchus nitaj imaynatachus chayta ruwanantaka. ");
INSERT INTO quhNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kancunapi Santo Espíritu tiyacojtinrí atiyninta jap'inquichej nokamanta willajcuna canayquichejpaj. Ajinapi willanayquichej tiyan Jerusalén llajtapi, tucuy Judea jallp'api, Samaria jallp'api, cay jallp'aj tucucuynincamapis. ");
INSERT INTO quhNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Chayta niskantawan cachasnin khawashajtincu Dios Tataka pusacaporka Jesusta janaj pachaman. Uj phuyutaj Jesusta pacaycorka. Chayraycu payta manaña ricorkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Jesús ripushajtintaj paycunaka janaj pachata khawasharkancu t'ucurispa. Ajinamanta iscay kharis yuraj p'achasniyoj paycunaman riqhurimuspa ");
INSERT INTO quhNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","nerkancu: —Galilea runacuna ¿imaraycutaj janaj pachata khawashanquichej? Jesuska janaj pachaman okhariskaña, pay quiquin ujtawan cutimonka. Janaj pachaman rishajta ricorkanquichej ajinallatataj cutimonka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Chanta Jesuspa cachasnenka Olivos niska orkomanta Jerusalén llajtaman cutimporkancu. Chay orkoka Jerusalén kayllalla cashan. Diospa unay runasnenka samacuna p'unchaypi ajinallata purinancu caj. ");
INSERT INTO quhNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jesuspa cachasnenka Jerusalenman yaycuspa wasej pata caj pisonman rerkancu. Chaypi pisi p'unchaycunapaj tiyacoj: Pedro, Jacobo, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Alfeoj wawan Jacobo, zelote partemanta Simonwan, Jacoboj wauken Judaspiwan. ");
INSERT INTO quhNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tucuy paycuna tantacojpuni cancu uj yuyaylla Diosmanta mañacunancupaj. Warmispis paycunawan casharkancu, Jesuspa maman María, Jesuspa waukesninwan. ");
INSERT INTO quhNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Pedroka chay p'unchaycunapi Jesuspa yachacojcunanpa chaupincupi sayaycucorka. Cristopi chay hermanoska carkancu pachaj iscay chuncayojjina. Pedrotaj nerka: ");
INSERT INTO quhNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Hermanosníy, Santo Espiritoka Diospa palabranpi unay tatanchej Davidnejta Judasmanta sut'incharka. Chay sut'inchaskaka junt'acunanpuni carka. Chay Judasmin runasta pusarka Jesusta jap'iycunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Chay runaka nokanchejwan cusca ruwananpaj churaska carka. Ajinapi nokanchejmanta ujnin carka. ");
INSERT INTO quhNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Payri sajra ruwaskanmanta kolketa jap'erka. Chay kolkewantaj uj jallp'a rantiska carka. Chanta uray umayojmanta urmaspa ch'akecorka. Ajinaspataj tucuy wijsan t'ojyarka. ");
INSERT INTO quhNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jerusalenpi tucuy tiyacojcuna ajinamanta wañuskanta yacharkancu. Chayraycu chay jallp'ataka Yawar Jallp'ata suticharkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ajinatataj camachej Davidpis paymanta uj taquinapi kelkarka: Wasenka sakeska cachun. Amataj pipis chaypi tiyacuchunchu. Nillantaj: Diospaj ruwanan carka, chay ruwanapaj waj runa churaska cachun. ");
INSERT INTO quhNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","‘Ajinata Judas wañuporka. Chayraycu waj runa churaska canan tiyan. Caypi cashancu nokanchejwan purej hermanos Señor Jesús cay pachallapiraj caskanmantapacha. Paycuna nokanchejwan carkancu Jesús Juanwan bautizacuskanmantapacha Dios payta janaj pachaman okhariskancama. Chaywanpis paycunaka Jesús causarimpuskanta ricorkancu. Chayraycu paycunamanta uj churaska canan tiyan nokanchejwan causarimuyninmanta willaj cananpaj, —nerka Pedroka. ");
INSERT INTO quhNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Chaypi tantacojcunataj iscay sutista okharerkancu: Chekan runa Jose Barsabás sutiyojta, Matiastawan. ");
INSERT INTO quhNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Chanta paycunaka Diosmanta mañacuspa nerkancu: —Señorniycu Jesús, kan yachanqui sonkonpi runaj yuyaskanta. Chayraycu sut'ita ricuchiwaycu cay iscay runasmanta maykenta ajllacuskayquita. ");
INSERT INTO quhNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Ajinapi churaska canka cachayqui cananpaj. Chay ruwanata Judaska juchallicuspa sakeporka. Wañorkataj juchanmanjina wiñaypaj ñac'arinanpaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ajinaspataj suertesta chokarkancu. Suertetaj Matiasman chayarka. Chaymanta payka chunca ujniyoj cachaswan cusca Jesuspa cachanpaj khawaska carka. ");
INSERT INTO quhNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Jesucristopi jap'icojcuna Jerusalenpi uj wasillapi tucuy tantaskas casharkancu. Phishka chunca p'unchayña carka Jesús causarimpuskanmanta. ");
INSERT INTO quhNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ajinapi ujllata sinch'i wayraj sonayninjina janaj pachamanta sonamorka. Tiyacushaskancu, chay wasipi tucuynincu sonajta uyarerkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Paycunataj ricorkancu ashqha laurashaj kallustajina sapa ujnincuman raq'iycucojta. ");
INSERT INTO quhNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Tucuy paycunaman Santo Espíritu yaycuspa sumajta callpacharka yuyaynincupi. Chaymantataj Santo Espíritu parlachiskanmanjina waj ashqha parlaycunata parlayta kallarerkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Chay p'unchaycunapi Jerusalenpi tiyacorkancu Diospa ajllaska runasnin, israelcuna. Paycunaka yachacuskancumanjina Diosta sumajpajpuni khawaj cancu cay pachapi tucuy llajtasmanta jamuspa. ");
INSERT INTO quhNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Chay sonayta uyariytawanka ashqha runas tantacorkancu. Paycunaka sapa ujnincoj quiquin parlaynincupi uyarerkancu Jesuspi jap'icojcunaj parlaskancuta. Uyariskancumanta ");
INSERT INTO quhNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","mayta t'ucuspataj ninacusharkancu: —Tucuy cay parlajcunaka ¿manachu Galilea jallp'amanta cancu? ");
INSERT INTO quhNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Imaynapitaj paycunata uyarishanchej sapa ujninchejpa parlayninchejpi parlajtarí? ");
INSERT INTO quhNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","10","Nokanchej tucuynejmanta canchej: Partiamanta, Mediamanta, Elammanta, Mesopotamiamanta, Judeamanta, Capadociamanta, Pontomanta, Asiamanta, Frigiamanta, Panfiliamanta, Egipto jallp'amanta, Africa jallp'anejmanta, Cirene llajtaj aswan carunmantataj. Chaywanpis Roma llajtamanta caypi tiyacojcuna ima cashancu. Paycunamanta waquenka nacecuynincumantapacha Diospa unay runasnin cancu. Waquintaj jatunmantaña Diospa ajllaska runasnin israelcuna canancupaj tijracaporkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Caypi cashanchej Creta jallp'amanta Arabia jallp'amantawan. Ajinata parlayninchejpi uyarishanchej Jesuspi jap'icojcunaj parlaskancuta: “¡May jatuchej t'ucunasta Dios ruwan!” —nispa ninacusharkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Tucuy chay runastaj mayta t'ucusharkancu. Manaña ni imata niyta atispataj paycunapura tapunacusharkancu: —¿Ima niytataj munan tucuy cay imasrí? ");
INSERT INTO quhNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Waquinrí Jesuspi jap'icojcunata p'enkaypi riqhurichinancupaj asipayasharkancu: —Machaskas cashancu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pedroka chay chunca ujniyoj cachaswan runaspa ñaupakencupi sayaricorka. Jatunmanta parlaspataj runasta nerka: —Israel llajta-masis, Jerusalenpi tucuy tiyacojcunapis uyariwaychej. Cayta yachanayquichejta munani. ");
INSERT INTO quhNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Cay runas mana machaskaschu cashancu yuyaskayquichejmanjinaka. Reparaychej allinta, cay jallp'anchejpi runaska mana machaycuncuchu manaraj pakarin miqhuna horastaka. ");
INSERT INTO quhNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Manachayrí cayka Diospa unay willajnin Joelpa niskanmanjinamin. Payka nerka: ");
INSERT INTO quhNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Wiñaypaj Camachej Dioska nin khepa p'unchaycunapi cayjina cananta: Tucuy jallp'amanta runasman Santo Espirituta cachamusaj. Khari wawasniyquichej ususisniyquichejpis atiyniywan sut'inchankancu. Jovenesniyquichejtapis yuyaychasojcunayquichejtapis cheka cajniymanta ricuchisaj. ");
INSERT INTO quhNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Noka Espirituta cachamusaj chay p'unchaycunapi tucuy casuwajcunaman, kharismanpis warmismanpis. Paycunataj atiyniywan willankancu. ");
INSERT INTO quhNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Janaj pachapi jatuchej t'ucunasta ruwasaj. Cay pachapitaj ricuchinasta ruwasaj tucuy runas juchancuraycu phiñacuskayta reparanancupaj. Chay ricuchinas ninawan, yawarwan, k'osñiwanpis cankancu. ");
INSERT INTO quhNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Inteka lakhayaponka. Quillapis yawarjina pucaman tucuponka. May sinch'i mancharina canka manaraj Señor cutimushajtin. ");
INSERT INTO quhNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Noka, tucuy atiyniyoj Diosmanta tucuy mañacojcunata juchasnincumanta cacharisaj wiñay causayniyoj canancupaj, —nerka Dios. ");
INSERT INTO quhNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","‘Llajta-masisníy, uyariwaychej. Dioska ricuchisorkachej Nazaret llajtayoj Jesusta sumajpaj khawaskanta. Chaywanpis t'ucunastawan jatun ricuchinastawan chaupiyquichejpi Jesusnejta atiyninwan ruwarka. Ajinapi kancunaman rejsichisorkachejña Jesuska paypa ajllaskan caskanta. Chaytataj kancunaka sumajta yachanquichej. ");
INSERT INTO quhNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Dioska munayninmanjina yachayninmanjinataj unaymantaña yuyarka Jesús wañunanta juchasninchejraycu. Ajinapimin kancuna payta jap'iycorkanquichej Diospa camachiskasninta mana casuspa. Sajra runasman jaywaspataj payta wañuchicherkanquichej chacatanapi. ");
INSERT INTO quhNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Payta Dioska wañuskanmantaña causarichimorka. Ajinapi payta sinch'i llaquichej wañuymanta cacharichiporka. Chekatapuni chay wañuyka mana aterkachu payta atipayta. ");
INSERT INTO quhNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Unay camachej Davidpis Jesucristoj causarimuyninmanta nerka: Señor Diosniypi tucuy sonkoywan jap'icorkani. Pay nokawanpuni cashan yanapawaspa. Sayacuwaskanraycutaj paypi jap'icuskayta manapuni sakesajchu. ");
INSERT INTO quhNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Chayraycu may cusiska cani. Simiywanpis cusiyta taquini. Runas caspapis causasaj sumaj niwaskayquipi jap'icuspa. ");
INSERT INTO quhNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Noka kanllata casoj camachiyquimin cani. Manapuni sakewanquichu wañuska runas cancu, chaypi. Nitaj cuerpoyta ismunanta sakenquichu. ");
INSERT INTO quhNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Wiñay causaymanta yachachiwaspapuni pusawarkanqui. Kan nokawanpuni caspa mayta cusichiwanqui. ");
INSERT INTO quhNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","‘Llajta-masis, unay tatanchej Davidmanta sut'ita parlariskayquichej. Payka wañupuspa p'ampaska carka. P'ampananri caypi cunancama cashan. ");
INSERT INTO quhNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Davidka Diospa willajnin carka. Dioska palabranwan unay payman nerka: “Kanpa khepa alchhisniyquimanta kanjina camachinanpaj ajllaskay Cristota churasaj”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Chayta unayña yachaspa Davidka Jesucristoj causarimuyninmanta kelkarka. Nerka mana sakeskachu cananta wañuska runas cancu, chaypeka, nitaj cuerponpis ismunanta. ");
INSERT INTO quhNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Dios chay Jesucristota wañuymanta causarichimorka. Tucuy nokaycutaj chayta ricuskaycuraycu Jesucristomanta willajcunan caycu. ");
INSERT INTO quhNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ajinaka Dios atiyta kospa payta jatunpaj khawarka tucuyta camachinanpaj. Dios Tatanpa sumaj palabranmanjina Jesuspa sonkonman Santo Espirituta cachamorka, tucuy nokaycumanpis. Chayraycu ricuskayquichejka uyariskayquichejpis chay Espíritoj ruwaskanmin. ");
INSERT INTO quhNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Camachej Davidka mana cuerponpichu janaj pachaman wicharerka Jesusjina. Payrí Jesucristomanta kelkarka: Señorninchej Dios nerka Señorniy Cristoman: “Nokawan cusca tiyaycucuy camachinanchejpaj churanacojcunayquita k'alata atipanaycama”. ");
INSERT INTO quhNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","‘Chayraycu tucuy kancuna, Diospa ajllaskan israelcuna sumajta yachanayquichej tiyan: Dioska chay Jesustamin ajllacuspa churarka tucuyta atiywan camachinanpaj. Paytamin kancunaka chacataspa wañuchicherkanquichej. ");
INSERT INTO quhNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pedrota uyariytawan paycunaka sonko nanayta llaquicorkancu. Chayraycu paytawan chay waj cachastawan tapurerkancu: —Llajta-masis ¿imatataj nokaycu ruwanaycu tiyanrí? ");
INSERT INTO quhNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedrotaj paycunaman cuticherka: —Sapa ujniyquichej juchasniyquichejta sakespa Diosman cutiricuychej. Bautizacuychejtaj Señor Jesucristopi jap'icuskayquichejta ricuchinayquichejpaj. Ajinapi Dioska juchasniyquichejta khechusonkachej. Kancunamantaj Dios c'acha caskanraycu cachamusonkachej Santo Espirituta sonkoyquichejpi tiyacunanpaj. ");
INSERT INTO quhNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Dioska palabranwan nerka: “Payta kancunaman cachamusaj”, nispa. Kancunapaj chay sumaj niskanka cashan, khepan allchhisniyquichejpajpis, carupi tiyacoj tucuy runaspajpis. Señor Diosninchej picunatachá munan wajyacuyta paypi jap'icunancupaj, tucuy chaycunapajpis sumaj niskan cashan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ajinata Pedroka ashqhataraj parlaspa Jesusmanta paycunaman willarka. Mayta reparacherkataj: —Jesusta wañuchejcuna wiñaypaj sinch'i ñac'arichiskas cankancu. Kancunarí ama payta khesachaychejchu paycunajinaka. Ajinapi mana ñac'arichiskaschu canquichej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ajinataj uyarejcunamanta waquenka Pedroj niskanta casorkancu. Chaymantataj paycunaka Jesucristopi jap'icuskancuta ricucherkancu bautizacuspa. Chay p'unchaypitaj yapacorkancu quinsa warankajina Jesuspi jap'icojcuna. ");
INSERT INTO quhNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Chay jap'icojcunaka Jesuspa cachasninpa yachachiskancuta sumajta casusharkancu. Paycunapurapis cuscachacuypi allinta causacoj cancu. Ajinallatataj miqhuytawan Jesuspa wañuskanta yuyaricoj cancu t'antata partispa. Diosmantapis cusca mañacoj cancu. ");
INSERT INTO quhNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Jesuspa cachasninta Dioska ashqha t'ucunasta jatun ricuchinastawan ruwacherka. Chayraycu tucuy runas mayta manchachicorkancu, Diosta jatunpaj khawaspa. ");
INSERT INTO quhNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jesucristopi jap'icojcuna tucuynincu uj yuyaylla carkancu. Capuynincumantapis pisichicuskancumanjina yanapanacoj cancu. ");
INSERT INTO quhNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Jallp'asnincutapis capuynincutapis venderaspa tucuy hermanosman pisichicuskancumanjina t'akaspa koj cancu. ");
INSERT INTO quhNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Yupaychana-wasimanpis sapa p'unchay uj yuyaylla rej cancu. Sapa ujnincoj wasincupi miqhoj cancu t'antata partispa Jesuspa wañuskanta yuyaricunancupaj. Miqhunancutapis may cusiywan llamp'u sonkowan cusca miqhucoj cancu. ");
INSERT INTO quhNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Paycunaka Diosta yupaychaspa causacorkancu. Tucuy runastaj paycunata sumajpaj khawarkancu. Señor Jesuska atiyninwan sapa p'unchay yapamoj paypi jap'icuspa tantacojcunaman. Chay yapacamojcunataj carkancu juchamanta cachariskas cajcuna. ");
INSERT INTO quhNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Uj p'unchay Pedrowan Juanwan yupaychana-wasiman risharkancu chaupi tardeta. Chaytaj Diosmanta mañacuna hora carka. ");
INSERT INTO quhNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Yupaychana-wasej C'achitu puncunman uj suchuta sapa p'unchay runas apaj cancu. Chay runari nacecuskanmantapacha ajina suchu carka. Chayman yaycojcunamanta limosnasta pay mañacoj. ");
INSERT INTO quhNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Chay suchu runataj ricorka Pedrota Juantawan yupaychana-wasiman yaycushajta. Paycunamantataj pisichicuskanpi mañacorka. ");
INSERT INTO quhNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pedrowan Juanwanka payta allinta khawaycorkancu. Pedrotaj nerka: —Khawariwaycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Suchu runataj sumajta khawasharka paycunamanta imallatapis jap'iyta suyaspa. ");
INSERT INTO quhNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pedro nerkataj: —Mana phatayoj cani. Capuwaskantarí koskayqui. Nazaret llajtayoj Jesucristoj atiyninwan camachiyqui: Jatarispa puriy. ");
INSERT INTO quhNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Chayta nispataj Pedroka suchuta paña maquinmanta aysarispa sayaycucherka. Chaypachataj suchoj chaqui mokosnin callpachaskas caspa thañicaporkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Chanta suchu carka, chay runaka phinquirispa sayarerka. Puriyta kallarispataj paycunawan cusca yupaychana-wasiman yaycorka. Paytaj phinquirispa sumajta purispataj Diosta mayta jatuncharka. ");
INSERT INTO quhNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tucuytaj ricorkancu purishajta Diosta yupaychashajtawan. ");
INSERT INTO quhNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Runastaj reparaspa chay runaka unay suchu caskanta rejserkancu. Yacharkancutaj pay yupaychana-wasi C'achitu puncupi tiyaska mañacoj caskantapis. Mayta mancharicuspataj t'ucorkancu chay suchu runa thañicuskanmanta. ");
INSERT INTO quhNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Suchu carka, chay runataj Pedromanta Juanmantawan mana cacharicojchu. Tucuy runastaj t'ucuspa uskhayta paycunata khaterkancu chay Salomón niska yupaychana-wasi yaycunaman. ");
INSERT INTO quhNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pedrorí ashqha runasta ricuspa paycunaman parlarka: —Israel llajta-masis ¿imaraycutaj runa thañicuskanmanta t'ucushanquichejrí? Ama nokaycuta t'ucuspa khawawaycuchu. Mana nokaycoj atiyniycuwanchu cay runaka thañicorka. Nitaj chekan runas caskaycuraycuchu cayka ruwacun. ");
INSERT INTO quhNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Manachayrí Dios ruwarka. Payllata unay tatasninchej Abraham, Isaac, Jacobpis casuspa yupaycharkancu. Dios churarka ajllaska camachin Jesusta may jatunpaj khawaska cananpaj. Paytataj kancuna cay pacha curajcunawan jap'iycucherkanquichej Pilatoman jaywanancupaj. Chaywanpis paypa ñaupakenpi Jesusta wijch'uycorkanquichej. Pilatoka sumajta khawaspa cacharipuyta munashajtinpis kancunaka chacatanantapuni mañarkanquichej. ");
INSERT INTO quhNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ajinapi khesacharkanquichej Jesusta. Payka Diosllata casoj, chekan ruwajmin. Astawanpis mañarkanquichej runa wañuchi cachariska cananta. ");
INSERT INTO quhNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ajinamanta wañuchicherkanquichej wiñay causayta koj Jesusta. Payta Dios causarichimorka wañuymanta. Nokaycutaj Jesusta causarimuskanmanta khepata ricuspa willaycu payka chekata causarimuskanta. ");
INSERT INTO quhNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jesús tucuy atiyniyoj caskanta jap'icuspa cay runa thañicorka. Payta rejsinquichej ricunquichejtaj. Jesuspi jap'icuspa cay runa sumajta thañicorka tucuyniyquichej ricushajtiyquichej. ");
INSERT INTO quhNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","‘Cunanka llajta-masis, yachani kancuna mana reparaspa Jesús Diospa ajllaskan caskanta payta ñac'arichiskayquichejta. Curajcunayquichejpis mana repararkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Astawanrí Dioska ajinapi junt'arka unay willajcunannejta niskanta. Chay willajcuna unaymantapacha sut'incharkancu Diospa ajllaskan Cristoka ñac'arinanta. ");
INSERT INTO quhNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Chayraycu juchasniyquichejta sakespa Diosman cutiricapuychej juchasniyquichejmanta llimphuchaskas canayquichejpaj. Chanta Señor Dios sonkosniyquichejta callpachasonkachej cusiskas causanayquichejpaj. ");
INSERT INTO quhNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Chaypaj Dios unay ajllaskan Jesusta cachamusonkachej camachinanpaj. Payka Cristomin. ");
INSERT INTO quhNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","4.27 Janaj pachapeka cacunan tiyan Dios tucuy imata allinyachinan, chay p'unchaycama. Tucuy chayta Dios nerka payman t'akaska unay willajcunannejta. ");
INSERT INTO quhNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Chekatapuni Moisés unay tatasninchejman nerka: “Señor Dios cay pachaman cachamusonkachej nokatajina uj willajta. Aylluyquichejmanta canka. Payta nokamanta tucuy nisuskayquichejta casunquichej. ");
INSERT INTO quhNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Chay willajta mana casoj runarí Diospa cheka runasninmanta wijch'uska canka. Wiñaypajtaj wañonka”, nispa nerka Moisés. ");
INSERT INTO quhNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","‘Ajinata, ari, Diospa unay willajnin Samuelmanta khepaman tucuy willajcuna unayña willarkancu cunan p'unchaycunapi ruwacunanmanta. ");
INSERT INTO quhNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Chay unay sut'inchaskancoka kancunapaj carka. Kancunaj allinniyquichejpaj Dioska uj tratota ruwarka tatasninchejwan. Parlaspa Abrahamman nerka: “Khepa caj alchhisniyquinejta cay pacha runas jap'enkancu sumaj cajta wiñay allinnincupaj”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Dios ñaupajta kancunaman cachamusorkachej ajllaska Camachin Jesucristota wañuskamanta causarichimuspa. Cachamorka kancunata yanapayta munaspa sajra causayniyquichejmanta payman cutirinayquichejpaj, —nerka Pedro. ");
INSERT INTO quhNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ajinata Pedro, Juanwan runasta nisharkancu. Chayllaman yupaychana-wasipi ruwanayojcunawan uj camachejnincuwan saduceo partecunawan paycunaman kayllaycamorkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pedropaj Juanpajwan phiñaskas casharkancu Jesucristoj causarimuskanta yachachiskancuraycu. Tucuy runaspis paynejta wañuskancumanta causarimunallantataj willaskancumanta phiñacorkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Chanta chay curajcunaka jap'iycorkancu Pedrota Juantawan. Ch'isiña caskanraycutaj k'ayantincama wisk'aycucherkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Willaskancuta uyaricojcunamantarí ashqhas jap'icorkancu Jesucristopi. Kharisllata yupaspa phishka warankajina jap'icorkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","K'ayantintaj Jerusalén llajtapi curajcuna tantacorkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Chay jatun tantacuypi casharkataj yupaychana-wasimanta curaj runa Anaspis, ayllunmanta tucuy cajcunantin, Caifaswan, Juanwan, Alejandrowan. ");
INSERT INTO quhNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Juanta Pedrotawan chaupincuman pusaycuchispataj taporkancu: —¿Imaynatataj thañicherkanquichej cay runata? ¿Pejpa atiyninwantaj ruwarkanquichej caytarí? ");
INSERT INTO quhNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Chanta Santo Espirituwan junt'a caspa Pedro sumaj yuyayninwan cuticherka: —Israel llajtapi camachejcuna, curajcunawan, uyariwaychej. ");
INSERT INTO quhNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Cunan tapuwaycu cay suchu runata allinta ruwaspa thañichiskaycumanta. ");
INSERT INTO quhNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Chayraycu willaskayquichej tucuy kancunaman tucuy llajta-masisninchejmanpis yachanayquichejpaj pejpa atiyninwanchus ruwaskaycuta. Jesucristopi jap'icuspa paypa atiyninwantaj cay runata thañichiycu. Jesuska Nazaret llajtapi wiñacorka. Kancunataj payta chacataspa wañuchicherkanquichej. Paytataj Dioska causarichimorka wañuskamanta. Paypa atiyninwanmin cay runaka ñaupakeyquichejpi thañiska cashan. ");
INSERT INTO quhNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Dioska wiñaypaj churarka Jesucristota sumaj esquina rumitajina runas wiñay causayniyoj canancupaj. Kancuna wasichajcunarí cay rumita khawaspa wijch'uporkanquichej. Wasita sayachinanpajri chay wijch'uska rumeka aswan sumaj carka tucuy waj rumismanta niskaka. ");
INSERT INTO quhNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Chekamanta Jesusllata Dios churarka juchamanta c'ata Cacharichiwajninchej cananpaj. Paynejllata runas wiñay causayniyoj cayta atincu, paypi jap'icuspa. Manamin wajnejtachu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Chay curajcuna repararkancu Pedrowan Juanwan mana manchachicuspa parlaskancuta. Mana escuelapi estudiamoj, khasi runasjinalla caspapis sumajta parlaskancumanta mayta t'ucorkancu. Rejserkancutaj Jesuswanpuni purejcuna caskancuta. ");
INSERT INTO quhNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Thañiska runata Pedrowan Juanwan cusca sayashajta ricorkancu. Chayraycu ni imatapis cutichiyta aterkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Chanta chay curajcunaka paycunata tantacuynincumanta llojsinancuta camacherkancu. Munarkancu yachachinacuyta sapallancupi. ");
INSERT INTO quhNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Paycunapurataj ninacorkancu: —¿Imatataj ruwasun cay runaswanrí? Tucuy Jerusalén llajtapi tiyacojcuna yachancuña imaynatachus uj t'ucunapaj ricuchinawan thañichiskancuta. Nokanchejtaj mana atinchejchu niyta mana ruwaskancutaka. ");
INSERT INTO quhNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Amaña ni jayc'aj pimanpis Jesusmanta willanancupaj ninachej: “Willanquichej chayka, ñac'arichisajcu”. Chaywanka manaña runapura willanaconkancuchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Chanta chay quinsa runasta wajyaspa sinch'ita c'amerkancu: —Jesusmantaka ni imaynamantapis willaranquichejchu. Nitaj paymanta pimanpis yachachinquichejchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pedrowan Juanwanrí cuticherkancu: —Tanteyacuychej kancunallapis. Diospa ñaupakenpi ¿kancunatachu astawan casunaycu tiyan? chayrí ¿Diostachu? ");
INSERT INTO quhNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nokaycoka manamin ch'in cacuyta atiycuchu. Manachayrí willanaycu tiyan ricuskaycuta uyariskaycutaka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Tantaska curajcunaka ñac'arichinancupajjina imaynamantapis paycunata juchachayta mana aterkancuchu. Chayraycu phiñaskas sinch'ita c'amispa cachariporkancu. Imaraycuchus tucuy runasmin Diosta yupaycharkancu Jesuspa cachasninpa ruwaskancumanta. ");
INSERT INTO quhNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Chay thañicoj runaka tawa chunca curaj watayoj carka. Chayraycu chaymin may t'ucunapajka. ");
INSERT INTO quhNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Cachariskas caytawantaj Pedro Juanwan rerkancu Cristopi jap'icoj hermanospaman. Paycunamantaj willarkancu chay curajcunaj tucuy niskancuta. ");
INSERT INTO quhNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Chayta uyarispataj tucuynincu cusca uj sonkolla Diosmanta wajyacorkancu: —Diosniycu, jatun Camachiwajniycu canqui. Cay pachata, janaj pachata, jatun kochasta, chaypi tucuy cajcunatapis ruwarkanqui. ");
INSERT INTO quhNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Kan parlarkanqui camachiyqui Davidnejta. Pay Santo Espíritoj atiyninwan kanmanta taporkaña: ¿Imaraycutaj waj llajtayojcuna may phiñacuywan contrayquipi ch'ajwashancurí? Diospa ajllaskan israelcuna jatunchacuspa contrayquipi ruwayta yankhalla yuyashancu. ");
INSERT INTO quhNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Llajtasta camachejcuna jatarimuncu Señor Diospa contranpi. Ajinallataj curajcunapis tantaycucuspa Diospa contranpi churacuncu. Paypa ajllaskan camachinanpaj contranpipis jataricuncu. Ajinata ruwaytarí ni jayc'aj atenkancuchu. Mañacuspallapuni nerkancu: ");
INSERT INTO quhNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","—Chekatapuni cay llajtapi ashqha runas tantaycucorkancu ajllaska Camachiyqui Jesuspa contranpi. Payka kanllaman t'akaskamin tucuyta camachinanpaj. Chekatapuni cay llajtapi Herodeswan Poncio Pilatowan tantaycucorkancu. Llajta-masisniycuwan waj llajtayojcunapiwan cusca Jesuspa contranpi churacorkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Kan, atiyniyoj caspataj tucuy chay ruwanancutaka yacharkanquiña. Paycunaj ruwaskancutaj kanpa yuyaskayquimanjina munayniyquimanjina carka. ");
INSERT INTO quhNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Cunanka tucuy atiyniyoj Señor Diosniycu, “ñac'arichiskayquichej” niskancuta khaway, ari. Nokaycu camachisniyqui caycu. Yanapawaycu niskasniyquita tucuy sonkowan willaranaycupaj mana manchachicuspa. ");
INSERT INTO quhNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","5.24 Chaypaj atiyniyquita ricuchiy onkoskasta thañichispa. Chaywan kanman t'akaska Camachiyqui Jesús willaraypi yanapawasajcu. May t'ucunapaj ricuchinas jatun ruwanaswan paypa atiyninwan ruwaska cachun, —nispa mañacorkancu Diosmanta. ");
INSERT INTO quhNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ajinata Diosmanta wajyacuytawan tantacorkancu, chay waseka qharcatiterka Santo Espíritu chaypi caskanraycu. Tucuy chaypi cajcunataj Espirituwan junt'a carkancu. Chanta Jesuspa cachasnenka Diospa niskanta tucuy sonkowan willarkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jesucristopi chay ashqha jap'icojcunaka uj sonkolla uj yuyaylla tucuy imapi causacorkancu. Paycunamantataj ni uj runapis capuyninta “nokajllata” nejchu. Manachayrí tucuynincu hermanospura capuynincumantapis pisichicuskancumanjina yanapanacoj cancu. ");
INSERT INTO quhNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Señor Jesuspa cachasnenka paypa causarimpuyninmanta jatun atiyninwan willashallarkancupuni. Diostaj tucuy paycunata munacuywan khawaspa yanaparka. ");
INSERT INTO quhNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Paycuna uqhupi ni ujpis pisichicojka cajchu. Wasiyojcunapis jallp'ayojcunapis capuynincuta vendej cancu. Vendeskancu kolketataj apamoj cancu Cristopi hermanospa tantacuynincuman. ");
INSERT INTO quhNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Jesuspa cachasninman jaywaj cancu. Paycunataj sapa ujman pisichicuskancumanjina kolketa raq'icoj cancu. ");
INSERT INTO quhNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Carkataj Cristopi uj hermano, José sutiyoj. Cachaspis payta Bernabeta suticharkancu. Bernabé niyta munan yuyaychaj runa. Pay Chipre jallp'amanta carka, Levij ayllunmantapis. ");
INSERT INTO quhNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Payka uj jallp'anta vendespa kolketa apamorka. Jesuspa cachasninmantaj jaywarka. ");
INSERT INTO quhNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Waj hermanorí Ananías, warmin Safirawan jallp'ancuta vendellarkancutaj. ");
INSERT INTO quhNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ananiastaj vendeskancumanta waquin kolketa paycunapaj pacarka. Chaytaka warmin sumajta yacharka. Chanta Jesuspa cachasninman waquin kolkellata apaspa tucuynin caskantajina jaywarka. ");
INSERT INTO quhNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pedrori nerka: —Ananías, kanka vendeskayquimanta waquin kolketa orkhospa kanpaj pacarkanqui. ¿Imaraycutaj supay Satanaswan atipachicunqui sonkoyquipi Santo Espirituman llullacunayquipaj? ");
INSERT INTO quhNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kanpatapuni jallp'a carka. Vendespaka atillarkanqui chay kolkewan ruwayta munayniyquimanjina. Chanta ¿imaraycutaj cayta ruwayta yuyarkanquirí? Mana runallamanchu llullacunqui manachayrí Diosman, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Cayta uyarispataj Ananiaska wañuska pampaman urmarka. Chayta tucuy uyarejcunataj Diosta mayta manchachicorkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Chanta waynas jamuspa wañuskata mayt'uycuytawan p'ampaj aparkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Quinsa horas pasaymantajinataj Ananiaspa warmenka Jesuspa cachasninpaman yaycorka. Manaraj yacharkachu kosan wañupuskantaka. ");
INSERT INTO quhNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pedrori taporka: —Niway, ¿chay chhicapichu jallp'ayquichejta venderkanquichej? Safira cuticherka: —Arí, chay chhicapi, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Chanta Pedro payta nerka: —Iscayniyquichej tucuy atiyniyoj Señor cachamuska, chay Espirituman llullacuspa unanchacorkanquichej yachanayquichejpaj yachanmanchus manachus, chayta. ¿Imaraycutataj ajinata ruwarkanquichejrí? Khaway, cutimushancuña kosayquita p'ampamojcunaka. Cunan kantapis p'ampaj apallasonkancutaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Chaypachallataj Safirapis wañuska urmarka Pedroj ñaupakenman. Chay waynas yaycojtincutaj Safira wañuskaña carka. Payta apaspataj kosanpa ladonpi p'ampamorkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Mayta mancharicorkancu Jesucristopi jap'icoj tucuy tantacojcuna, chay wañuskancumanta tucuy uyarejcunapis. ");
INSERT INTO quhNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Runas uqhupitaj Jesuspa cachasnin ashqha jatuchej ricuchinasta t'ucunastawan atiyninwan ruwarkancu. Cristopi tucuy jap'icoj hermanoska uj sonkolla tantacoj cancu yupaychana-wasiman Salomón niska jatun yaycunapi. ");
INSERT INTO quhNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Tucuy wajcunarí chay hermanoswan tantacuyta manchachicoj cancu. Chaywanpis paycunata sumajpaj khawaj cancu. ");
INSERT INTO quhNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ashqha runasraj Señor Jesuspi jap'icorkancu kharismanta warmismantapis. ");
INSERT INTO quhNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ajinamanta runas onkoskasta ñancunaman apamoj cancu phullusnincupi puñunasnincupipis churaspa. Pedro chaynejpi purejtin llanthullanpis waquinman chayananpaj apamoj cancu. ");
INSERT INTO quhNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Mana Jerusalén llajtallamantachu jamoj cancu. Manachayrí kaylla llajtasmantapis ashqhas jamoj cancu onkoskasnincuta apamuspa. Supaycunaj ñac'arichiskasnintapis apamoj cancu. Tucuynincutaj thañichiskas carkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Yupaychana-wasimanta curajka, saduceo partemanta, tucuy yanapajcunawan mayta phiñacorkancu Jesuspa cachasninpaj. ");
INSERT INTO quhNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Paycunatataj jap'ichispa runaspa ñaupakenpi carcelman wisk'acherkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Tucuy atiyniyoj Señormanta uj cachamuska angelrí tutapi carcel puncuta quicharka. Jesuspa cachasninta carcelmanta pusarkospataj nerka: ");
INSERT INTO quhNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Riychej yupaychana-wasiman. Yaycuspataj runasman willamuychej Jesucristopi jap'icuspa tucuy cay mosoj causaymanta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Jesuspa cachasninri uyariskancuta casorkancu. Yupaychana-wasiman tutamanta rispa chaypi yachachiyta kallarerkancu. Chaycamataj yupaychana-wasimanta curaj, paywan cajcunawan jamuspa israel llajta curajcunata tantachimorkancu. Chay tantacuyka jatun tantacuy niska carka. Cacharkancutaj yanapajcunancuta Jesuspa cachasninta carcelmanta pusamunancupaj chay tantacuyman. ");
INSERT INTO quhNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Yanapajcuna carcelman chayaspa Jesuspa cachasninta mana tarerkancuchu. Curajcunaman cutispataj ");
INSERT INTO quhNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","willarkancu: —Carcelman chayaspa puncusta sumaj wisk'askasta tariparkaycu, wakaychajcunatapis puncuspi sayashajta. Puncuta quicharisparí ni pita uqhupi tariparkaycuchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Chay curajcuna ajina ruwacuskanmanta uyarerkancu. Iscayra tapunacusharkancu imapitaj cay t'ucunas tucunanta. ");
INSERT INTO quhNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Chanta chayllaman uj runa chayamorka nispa: —Kancuna carcelman wisk'acherkanquichej, chay khariska yupaychana-wasipi runasta yachachishancu, —nerka. ");
INSERT INTO quhNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Chaymanta camachejka yanapajcunapiwan ujtawan yupaychana-wasiman rerkancu. Manchachicorkancu runas rumiswan paycunata ch'ankaycunancuta. Chayraycu Jesuspa cachasninta mana imanaspalla pusamorkancu jatun tantacuyman. ");
INSERT INTO quhNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Pusajtincutaj yupaychana-wasimanta curajka ");
INSERT INTO quhNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","paycunata taporka: —¿Manachu sinch'ita camacherkaycu kancunata amapuniña yachachinayquichejta chay Jesusmanta? ¡Khawaychej! Jerusalén llajtapi tucuy tiyacojcuna yachachiskayquichejta yachancu. Chay Jesús wañuskanmantapis nokaycuta juchachayta munashanquichej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pedro chay waquin cachaswan cutichispa nerkancu: —Diosta astawan casunaycu tiyan runasmanta niskaka. ");
INSERT INTO quhNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Kancuna Jesucristota chacataspa wañuchicherkanquichej. Tatasninchej Diosta yupaycharkancu. Chay Diosninchejtaj Jesusta wañuskamanta causarichimorka. ");
INSERT INTO quhNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Payta jatunchaspataj sumaj atiyniyoj Camachej cananpaj churarka, juchamanta Cacharichejpis cananpaj. Chayta Dios ruwarka Israel llajta-masisninchej juchancuta sakespa payman cutimunancupaj. Ajinapi juchasnincumanta llimphuchaskas cayta atincu. ");
INSERT INTO quhNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tucuy chaymanta willanaycupaj nokaycu cachaskas caycu. Santo Espiritupis chay imasmanta runasta reparachispa willan. Dios Tatataj casojcunanpa sonkoncuman chay Espirituta cachamorka chaypi tiyacunanpaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Runas tucuy chay jatun tantacuypi cay imasta uyarispa manchaytapuni phiñacorkancu. Ajinapi uj yuyayman churacorkancu imaynamanta cachasta wañuchinancupaj. ");
INSERT INTO quhNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Carka chay jatun tantacuymanta uj runa fariseo partemanta, Gamaliel sutiyoj. Pay uj yachachejpis carka. Tucuy runas payta sumajpaj khawaj cancu. Parlananpaj sayaycuspataj pay camacherka Jesuspa cachasninta ascamallapaj tantacuymanta jawaman llojsichinancuta. ");
INSERT INTO quhNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Chanta curajcunaman nerka: —Israel llajta-masis, cay runaswan ruwanayashaskayquichejta sumajta reparacuychej. ");
INSERT INTO quhNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Yuyaricuychej manaraj unaychu uj runapis Teudas sutiyoj riqhurimuskanta. Payka nerka jatun runa caskanta. Tawa pachajjina runas payta khaterkancu. Payta runas wañuchejtincutaj tucuy khatejcunanpis chincapullarkancutaj. Ajinata tucucorka. ");
INSERT INTO quhNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Chay runaj khepanta runa yupachicuy p'unchaycunapi Judas sutiyoj riqhurimullarkataj. Pay Galilea jallp'amanta carka. Ashqhastataj okharerka payta khatinancupaj. Payta wañuchejtincu khatejcunapis tucuynin ch'ekerapullarkancutaj. ");
INSERT INTO quhNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Chayraycu cunan yuyaychayquichej sakenallayquichejta chay runasta. Amataj contrancupi churacuychejchu. Sichus chay yuyaskancu chayrí ruwaskancu runaj atiynillanwan chayka, tucucaponka. ");
INSERT INTO quhNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Diospa atiyninwanchus ruwashancu chayrí kancuna manapuni atipayta atinquichejchu. ¡Pajtataj Diospa contranpi churacushawajchej! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Chaymanta chay curajcunaka Gamalielpa niskanta casorkancu. Jesuspa cachasninta wajyaspataj jasut'icherkancu. Amaña pimanpis parlanancuta camachiytawan cachariporkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ajinamanta chay cachacunaka jatun tantacuymanta llojsiporkancu. Cusiskastaj riporkancu Jesuspa munayninta ruwaskancupi muchuyta atiskancuraycu. ");
INSERT INTO quhNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Sapa p'unchaytaj yachachillarkancupuni. Jesucristo Diospa ajllaskan caskanta willarkancu yupaychana-wasipi, runaspa wasisnincupipis. ");
INSERT INTO quhNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Chay p'unchaycunapitaj Jesuspi jap'icojcuna ashqhamanña wiñasharkancu. Griego parlajcuna rimasharkancu hebreo parlajcunaj contranta. Nerkancu: —Viudasniycuman chay hebreo parlajcuna sapa p'unchay jaywaranapi mana allintachu jaywarancu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Chanta chunca iscayniyoj cachas Jesuspi tucuy jap'icojcunata wajyarkancu tantacunancupaj. Nerkancutaj: —Nokaycoka Diospa niskanta willaranaycu tiyan. Mana allinchu pisichicojcunaman jaywaspa Diospa niskanta willarayta sakepunaycoka. ");
INSERT INTO quhNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Hermanosníy, chayraycu kancunamanta ajllaychej kanchis runasta cay ruwanapi yanapanancupaj. Cachuncu sumajpaj khawaskas, Dios Espirituwan junt'a, sumaj yuyayniyoj runas. Paycunata churasunchej cay ruwaypi khawanancupaj. ");
INSERT INTO quhNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nokaycutaj tucuy sonkowan Diosmanta mañacuspapuni casajcu. Camachiskas caskaycumanjina Diospa niskantapis yachachillasajcupunitaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Chay niskancoka tucuynincupaj allin carka. Ajllarkancutaj Estebanta. Payka Jesuscristopi chekamanta jap'icoj runa carka, Santo Espirituwan junt'a. Ajllallarkancutaj Felipeta, Procorota, Nicanorta, Timonta, Parmenasta, Nicolastawan. Cay Nicolaska Antioquía llajtamanta carka. Ñaupajpi payka Diosta casoj runaman tijracaporka. ");
INSERT INTO quhNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Chanta tantacojcunaka chay kanchis ajllaskancuta pusarkancu Jesuspa cachasninpa ñaupakencuman. Cachastaj Diosmanta mañapuspa maquisnincuta umancuman churarkancu Dios sumajta callpachananpaj ruwaynincupi. ");
INSERT INTO quhNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ajinamanta astawan astawanraj runas Diospa palabranta uyarerkancu Jerusalén llajtapi. Jesucristopi jap'icojcunataj mayta yapacamoj cancu. Paycunataj Diosta casusharkancu. Yupaychana-wasipi ruwanayoj runaspis ashqhas, Jesuspi jap'icuspa palabranta casorkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Santo Espíritu Estebanman atiyta kospa sumajta yanaparka. Jesuspi jap'icuspataj may jatuchej t'ucunasta ricuchinastawan ruwaj runas chaupipi. ");
INSERT INTO quhNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Chanta tantacuna-wasimanta waquin cachariska camachis niskacuna jatarerkancu. Chaycunawan Cirene llajtamanta carkancu Alejandría llajtamanta, Cilicia jallp'amanta, Asia jallp'amantapis. Chay runasmanta waquincuna Estebanwan churanacuyta kallarerkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Espiritunnejta Dios sumaj yachayta Estebanman korka parlananpaj. Chayraycu payta mana aterkancuchu atipayta parlaskasnincuwan. ");
INSERT INTO quhNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Chanta paycuna waquin runasman lluq'iycorkancu llullacunancupaj: —Cay Esteban Moisespa camachiskasninmanta sajrata parlajta uyariycu, Diospa contranpipis, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ajinamanta runasta, curajcunata, yachachejcunatawan okharicherkancu ch'ajwanancupaj. Ujllata phawaycuspataj Estebanta jap'iycorkancu. Phiñaskas pusarkancutaj jatun tantacuyman. ");
INSERT INTO quhNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Llulla parlajcunatataj churarkancu. Llullacojcunataj paypa contranpi churaycucuspa nerkancu: —Cay runa Diosta yupaychana-wasipaj sajrata rimashallanpuni, Moisespa camachiskasninmantapis. ");
INSERT INTO quhNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Cay runamanta uyarillaycutaj Nazaret llajtayoj Jesús chay yupaychana-wasita urmachinanta. Moisés yachachiwaskanchejtapis wijch'uspa waj yachachinaswan Jesús tijrayta munaskanta, nerka cay runaka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","7.8 Chaymanta curaj tantacuypi cajcuna tucuynincu allinta khawarkancu Estebanta. Uyantataj lliphipishajta ricorkancu janaj pachamanta uj willajpa uyantajina. ");
INSERT INTO quhNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Chanta yupaychana-wasimanta curaj taporka Estebanta: —Cay runas contrayquipi niskancoka ¿chekachu? ");
INSERT INTO quhNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Paytaj cuticherka: —Sumajpaj khawaska tatacuna, llajta-masispis uyariwaychej. Tucuy atiyniyoj Dios riqhurerka unay tatanchej Abrahamman jakay Mesopotamia jallp'api cashajtin. Abraham manaraj Harán llajtaman tiyacoj rishajtin, ");
INSERT INTO quhNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Dios nerka: “Jallp'ayquimanta ripuy, tatasniyquita sakepuspa waj jallp'ata ricuchiskayqui, chayman”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Chanta Abraham Caldea jallp'api wasinmanta llojserka. Riporkataj Harán llajtaman tiyacoj. Tatan wañupuskanmanta khepantataj Dios cay tiyacushaskanchej jallp'aman Abrahamta tiyacunanpaj pusamorka. ");
INSERT INTO quhNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Cay jallp'ata payman wawasninmanpis konanta Dioska sumaj niskanwan nerka. Jallp'atarí manaraj ni ujnin chaquinta saruycurinallapajpis korkachu. Abrahamka mana jallp'ayoj wañuporka. Diosrí sumaj niskanwan nerka chay jallp'ata konanta, Abrahamman wawasninmanwan pay manaraj wawayoj cashajtin. ");
INSERT INTO quhNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Dios willallarkataj Abrahamman khepa alchhisninmanta: “Forasterosjina causankancu waj caru jallp'api. Chaypitaj runas paycunata camachisnincupaj jap'enkancu mayta ñac'arichenkancutaj. Ajinallataj paycuna khepa alchhisnincupis cankancu tawa pachaj watasta. ");
INSERT INTO quhNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Chay llajtata noka juchachasaj wawasniyquita ñac'arichiskanmanta. Chanta jakaymanta khepa alchhisniyqui llojsimuspa cay jallp'apeka munayniyta ruwaspa yupaychawankancu”, nispa nerka Dios. ");
INSERT INTO quhNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Paytaj Abrahampaj uj tratota churarka: “Uj señalta churacuy cuerpoyquipi khari wawasniyquipipis”, nispa. Abrahamtaj chay señalta churacuspa Dioswan uj yuyayman yaycorka. Ajinapi ricucherka Diospa ajllaskan caskanta. Chayraycu wawan Isaac nacecojtin pusaj p'unchaypi Abraham paypi chay señalta churarka. Isaacpis ajinallatataj wawan Jacobpi chay señalta churarka. Chaymanta Jacob ajinallatataj churarka chunca iscayniyoj wawasninpipis. Paycuna unay tatasninchej carkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","‘Chay unay tatasninchejka envidiacorkancu sullc'ancu Josewan. Chayraycu payta venderkancu Egipto jallp'api camachi cananpaj. Diosrí paywan casharka yanapaspa. ");
INSERT INTO quhNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Tucuy llaquiyninpi wakaychasharka atipanancama. José chayamojtin camachej Faraonpa ñaupakenman Dios payta c'achapaj khawacherka. Josetataj sumaj yachayniyojta ruwarka. Ajinapi Faraón payta churarka camachinanpaj Egiptopi tiyacojcunata, wasinpi tucuy cajcunatawan. ");
INSERT INTO quhNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","‘Chaypacha jatun yarkhay carka tucuy Egipto jallp'api tucuy Canaán jallp'apipis. Jakay jallp'aspi tiyacojcuna jatun llaquiyta ñac'arerkancu. Unay tatasninchejpis miqhunata mana tariyta aterkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Unay tatanchej Jacobrí uyarispa yacharka jakay Egiptopi miqhuna caskanta. Chayraycu chayman wawasninta ñaupaj cutita rantej cacharka. ");
INSERT INTO quhNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Khepan cuti riskancupi José rejsichicorka waukesninwan. Chanta Egiptoj camachejnin yacharka José Diospa unay runasnin israelcunamanta caskanta. ");
INSERT INTO quhNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Chaymanta José wajyachicaporka tatan Jacobta tucuy ayllunpi cajcunatawan. Chaypachataj tucuynincu yupacorka kanchis chunca phishkayoj runas. ");
INSERT INTO quhNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ajinamanta Jacob uraycamorka Egipto jallp'aman tiyacoj. Chaypi tiyacushaspataj pay wañuporka, unay tatasninchejpis. ");
INSERT INTO quhNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Khepataña ayasnincu apaskas carkancu caru Siquem llajtaman p'ampanapaj. Jakaypi kolkewan unayña Abraham uj p'ampanata ranticorka, Hamorpa wawasninmanta. Chay p'ampanapitaj Abrahampa wawasnin payta p'ampacaporkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","‘Unayka Dios sumaj niskanwan parlarka Abrahamman. Nerka paypa khepa alchhisninta uj sumaj jallp'aman pusacapunanta. Chay niskan junt'acunan p'unchay cashajtintaj Diospa runasnin, unay tatasninchej, ashqhayarkancu Egipto jallp'api. ");
INSERT INTO quhNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ashqhayallarkancupuni waj camachej Egiptota camachinancama. Paytaj Joseta mana rejserkachu unayña wañupuskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Chay camachejtaj ayllusninchejta pantachinaswan atiparka. Ajinapi ñac'aricherka tatasta juch'uy wawitasnincutapis wijch'ucherka manaña causanancupaj. ");
INSERT INTO quhNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Chay p'unchaycunapi Moisés nacecorka. Dios paymanta mayta cusicorka. Tatan mamanri quinsa quillata payta pacaspa wasincupi uywarkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Chanta mayupi pacaska cashajtin camachejpa ususin Moisesta orkhorka. Quiquin wawantajinataj uywarka. ");
INSERT INTO quhNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ajinamanta Moisés sumaj yachachiska carka Egipto runas yacharkancu, tucuy chaycunata. Sumaj yuyayniyoj parlayniyojtaj carka, ruwanapajpis callpayoj. ");
INSERT INTO quhNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","‘Tawa chunca watayoj cashaspataj Moisés yuyarka watucuyta israel ayllusninta yachananpaj imaynachus cashaskancuta. ");
INSERT INTO quhNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Chaypitaj tariparka uj Egipto runa muchuchishajta paypa ayllu-masinta. Ayllu-masinman sayacuspataj chay muchushajta jarc'acorka. Ajinapitaj chay Egipto runata wañucherka ayllu-masinta makaycuskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisés yuyarka ayllu-masisnin entiendenancuta paynejta Dios paycunata cacharinanta chay ñac'arichej runasmanta. Paycunarí mana repararkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","K'ayantintaj Moisés tariparka iscay ayllu-masisninta paycunapura makanacushajta. Allinyanachiyta munaspa chimpaycorka. Nerkataj: “Kancunaka aylluntin canquichej. Amaña makanacuychejchu”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ñac'arichej cajrí Moisesta tankarparispa nerka: “¿Pitaj kanta curaj camachejniycu canayquipaj churasorkarí? ¿Pitaj kanta nokaycuta chekanchanawaycupaj churasorkarí? ");
INSERT INTO quhNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Kayna chay Egipto runata wañucherkanqui ¿ajinallatatajchu wañuchiwayta munashanqui?” ");
INSERT INTO quhNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Chayta uyarispataj Moiseska aykecorka Madián jallp'aman. Chaypiri forasterojina tiyacorka. Casaracuspataj chaypi iscay wawasniyoj carka. ");
INSERT INTO quhNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","‘Tawa chunca watastaña tiyacushajtin chay Madián jallp'api Dioska Moisesman riqhurerka. Sinaí orko kayllapi ch'in lugarpi cachamuska angelninnejta riqhurerka laurashaj qhishcarara sach'api. ");
INSERT INTO quhNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moiseska t'ucorka riqhuriskanmanta. Kayllaycorkataj astawan allinta yachananpaj. Ajinallaman Dios parlapayarka: ");
INSERT INTO quhNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Noka sapallay Dioska cani. Unay tatasniyqui Abrahampis Isaacpis Jacobpis yupaychaspa casuwarkancu”, nispa. Moisestaj manchachicuspa qharcatiterka. Chayraycu chay laurashajta mana khawarinayarkachu. ");
INSERT INTO quhNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Señor Dios nillarkataj: “Ojot'asniyquita lluch'ucuy noka, tucuy atiyniyoj Dios, caypi cashaskayraycu. ");
INSERT INTO quhNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Chekamanta noka ricuni ajllaskacunayta Egipto jallp'api ñac'arichiskas caskancuta. Uyarinitaj paycunaj wakaskancuta. Cayman uraycamushani tucuy chay jatun ñac'ariymanta paycunata orkhomunaypaj. Chayraycu cunan nokaman kayllamuway. Cachaskayquitaj Egipto jallp'aman”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","‘Diospa runasnin israelcunarí Moisesta khesacharkancu. Taporkancutaj: “¿Pitaj camachejniycupaj churasorka chekanchawajniycupajpis?” nispa. Chaywanpis Dios payta churarka camachinanpaj, runasninta ñac'arishaskancumanta cacharichinanpajpis. Ajinata Dioska Moisesta churarka angelninnejta riqhurispa laurashaj qhishcarara sach'api. ");
INSERT INTO quhNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ajinamanta Moisés unay tatasninchejta Egiptomanta llojsichispa tawa chunca watata pusaycacharka. Chaypitaj t'ucunasta may jatun ricuchinastawan ruwarka jatun Puca Kochapipis jakay ch'in jallp'apipis. ");
INSERT INTO quhNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moiseska nerka Diospa runasninman: “Diosniyquichejka uj willajta cachamusonkachej. Kancunaj aylluyquichejmantataj canka. Nokata Dios cachamuwarka, ajinallatataj ujta cachamusonkachej. Paytari casunquichej nokamanta tucuy niskanta”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moisesllataj ch'in pampapi Diospa tantaska runasninwan carka tatasninchejwantaj. Sinaí orkopipis Dios janaj pachamanta payman parlarka. Paytaj Diospa wiñaypaj atiyniyoj palabranta jap'erka khepata nokanchejman konawanchejpaj. ");
INSERT INTO quhNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","‘Chaywanpis unay tatasninchejka Moisesta mana casuyta munarkancuchu. Manachayrí payta khesacharkancu. Sonkosnincupitaj yuyasharkancu Egipto jallp'aman cutiripuyta. ");
INSERT INTO quhNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Chayraycutaj Moisespa wauken Aaronta nerkancu: “Ruwapuwaycu dioscunata ñaupakeycuta apanaycupaj. Egiptomanta pusamuwajniycu, chay Moisesmantarí cunan mana yachaycuchu imachus caskanta”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ajinamanta uj uña wacata korimanta ruwacorkancu. Uywacunata wañuchispari ruphacherkancu chay wacata yupaychanancupaj. Chayjinamanta cusicorkancu maquisnincuwan ruwaska khasi diosmanta. ");
INSERT INTO quhNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Chanta Dios paycunamanta carunchacapuspa sakerparerka patapi caj ch'ascasta yupaychanancupaj. Ajinallatataj Diospa willajnin Joelnejta paycunamanta nerka: Ajllaska israelcuna, ch'innejpi tawa chunca watata uywasta wañucherkanquichej jaywanapaj. Chaywan mana nokatachu yupaychawarkanquichej. ");
INSERT INTO quhNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Manachayrí Molocpa yupaychana-toldonta apaycachacorkanquichej, Renfán niska ch'ascantawan. Paypa rijch'ayninta kancunalla ruwacorkanquichej yupaychanayquichejpaj. Chayraycu llajtayquichejmanta apachiskayquichej jakay Babilonia jallp'aman. ");
INSERT INTO quhNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","‘Ch'in jallp'api unay tatasninchej apaycacharkancu Diosta uj yupaychana-toldota. Chaypi jallch'aska carka Moisespa chunca camachiskasnin iscay kelkaska rumispi. Dios Moisesman ricucherka imaynatachus chay yupaychana-toldota ruwananta. “Ricucherkayqui, chay quiquinta ruway”, nispa camacherka. ");
INSERT INTO quhNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Chanta chay toldota unay tatasninchej wawasnincoj wawasnincama sakerkancu. Aparkancutaj Josuewan rishaspa jakay ashqha jallp'asman. Chaypi tiyacojcunata Dios kharkorka jallp'ancu ajllaska tatasninchejpata cananpaj. Ajina chay yupaychana-toldo caypi carka David causarka chaypachacama. ");
INSERT INTO quhNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Camachej David cusicherka Diosta. Munarkataj Diospaj uj yupaychana-wasita ruwachiyta. Unay tatanchej Jacobpis Diosta yupaycharka. ");
INSERT INTO quhNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Khepantarí Salomón yupaychana-wasita Diospaj ruwacherka. ");
INSERT INTO quhNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Tucuy atiyniyoj Diosrí mana tiyacunchu runaspa ruwaskan wasillapeka. Ajinata paypa unay willajninpis nerka: Señor Dios nin: ");
INSERT INTO quhNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Janaj pachamanta tucuy imata camachini. Cay pachapitaj casuchicuni. Chanta ¿imayna wasitataj ruwapuwanquichejrí? ¿Maytaj samacunaypajjinarí? ");
INSERT INTO quhNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Manachu nokallataj maquisniywan ruwarkani tucuy cayta? ");
INSERT INTO quhNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Esteban nillarkapuni: —Kancunaka c'ullu runas, rumi sonkos canquichej. Diosta mana uyarinquichejchu nitaj Santo Espiritutapis casunquichejchu. Unay tatasniyquichejjinapuni kancunapis canquichej. ");
INSERT INTO quhNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Diospa tucuy willajcunanta chejnispa unay tatasniyquichejka ñac'aricherkancu. Chay willajcuna unayta willarkancu Diospa ajllaska camachin Jesús jamunanta. Chay willajcunatapis wañucherkancu. Cunantaj pay jamojtin chejnicojcunaman jaywaycorkanquichej wañuchicherkanquichejtaj. ");
INSERT INTO quhNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kancunaka Diospa camachiskasninta janaj pachamanta cachamuska angelesnejta jap'erkanquichej. Ni chaywanpis casorkanquichejpunichu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Chayta uyarispa tucuynincu maytapuni phiñacorkancu Estebanpaj, uyasnincu pucayanancama. ");
INSERT INTO quhNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Estebanrí sonkonpi Santo Espirituwan junt'a carka. Janaj pachaman allinta khawaspataj tucuy atiyniyoj Diosta ricorka. Jesustataj paywan cusca sayashajta ricorka jatun atiyninwan camachinanpaj. ");
INSERT INTO quhNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Chaymanta nerkataj: —¡Uyariwaychej! Janaj pachapi ricushani Diospa cachaska Runan Jesusta atiyninpi Dioswan cusca sayashajta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Paycunataj sinch'ita khaparerkancu. Ningrisnincutataj tapaycucorkancu chay palabrasnejta sonkoncupi mana ch'ichichaskas canancupaj. Uj yuyaylla Estebanman sinch'ita correycorkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Payta llajta jawaman wijch'uspataj chaypi ch'ankaspa wañucherkancu. Ch'ankajcunataj ponchosnincuta uj jovenman sakecorkancu. Chay jovenka Saulo sutiyoj carka. ");
INSERT INTO quhNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Rumiwan ch'ankashajtincutaj Estebanka Diosmanta mañacusharka: —Señor Jesusníy, nokamanta causayniyta apacapuy, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Chanta konkoricuspa Estebanka sinch'i khapariywan mañacorka: —Señorníy, ama juchachaychu paycunata cay juchancumantaka. Cayta niytawantaj Estebanka tucucaporka. ");
INSERT INTO quhNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Estebanta wañuchiskancoka Saulopaj allin carka. Jerusalén llajtapitaj chay p'unchaypi kallarerkancu sinch'ita ñac'arichiyta Jesucristopi jap'icuspa tantacojcunata. Jesuspa cachasnillan chayllapipuni casharkancu. Chay ujcunarí tucuynincu ch'ekerachiskas carkancu Judea jallp'aman Samaria jallp'amanpis. ");
INSERT INTO quhNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Waquin cheka sonkoyoj runastaj Estebanta p'amparkancu may phutiywan wakaspa. ");
INSERT INTO quhNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulorí tucuy atiskanwan tucuchiyta munarka Jesuspi jap'icuspa tantacojcunata. Sapa wasimanta wasi yaycuspa kharista warmistapis orkhomoj carcelman wisk'achinanpaj. ");
INSERT INTO quhNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Chay ch'ekerachiskas cajcunataj sumaj willanasta willarasharkancu tucuy riskancupi. ");
INSERT INTO quhNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Paycunamanta uj curaj yanapaj runa, Felipe sutiyoj, Samaria jallp'aman rerka. Chaypi aswan jatun caj llajtapi Jesucristomanta willararka. ");
INSERT INTO quhNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ashqha runastaj uj yuyaylla sumajta jap'ej cancu Felipej willaraskanta. Ajinallataj jatun ricuchinasta ruwaskantapis sumajta khawarkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Felipetaj Diospa atiyninwan ashqha runasmanta supaycunata kharkorka. Chay supaycunataj sinch'ita khaparispa llojserkancu. Ashqha suchu runasta wist'usta thañicherka Felipeka. ");
INSERT INTO quhNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ajinapi chay llajtapi tiyacojcuna mayta cusicorkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Chay llajtapi uj runa carka, Simón sutiyoj. Felipe manaraj jamushajtintaj payka layka ruwaskasninwan Samaria runasta pantachej. Pay quiquintapis atiyniyoj caskanta khawacorka. ");
INSERT INTO quhNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Tucuytaj Simonta sumajta uyarej cancu wawacunapis curaj runaspis. —Cay runapimin jatun atiyniyoj dioska riqhurimun, —nispa nej cancu. ");
INSERT INTO quhNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Chayraycu runaska Simonpa niskanta jap'icoj cancu. Unaymantaña layka ruwaskasninwan pantachiskas carkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Astawanpis Felipe willararka sumaj willanasta Dios runasta munacuywan camachiskanta. Jesucristo Diospa ajllaskan camachinanpaj caskantawan Felipe willararka. Warmispis kharispis chay willaraskanta creespataj bautizacorkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simón, quiquinpis creerka. Bautizacuspataj Felipewan cusca purej. Payka mayta t'ucoj Felipe Diospa atiyninwan jatun ricuchinasta t'ucunastawan ruwaskanmanta. ");
INSERT INTO quhNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ajinata Samaria jallp'api tiyacojcuna sumaj willanasta Jesucristomanta uyarispa jap'icorkancu. Jesuspa cachasnin Jerusalenpi chayta uyarispa Pedrota Juantawan paycunaman cachamorkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Paycunataj chayman chayaspa Diosmanta mañaporkancu Jesucristopi hermanospaj. Mañaporkancu paycuna Santo Espirituta jap'inancuta. ");
INSERT INTO quhNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Imaraycuchus payka manarajmin sonkosnincuman atiyninwan uraycamorkachu. Jesús tucuy atiyniyoj Señor caskanta jap'icuspallaraj bautizaskas carkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Chanta Pedrowan Juanwan maquisnincuta Jesuspi jap'icojcunaman churarkancu. Ajinamanta paycuna Santo Espirituta atiyninwan jap'erkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simonka ricorka Jesuspa cachasnin maquisnincuta churajtincu chay hermanosman Santo Espíritu yaycuskanta. Chayraycu cachasman kolketa koyta munaspa ");
INSERT INTO quhNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","nerka paycunata: —Nokamanpis chay atiyta kowaychej noka maquisniyta pimanpis churajtiy paycuna Santo Espirituta jap'inancupaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pedrori payman cuticherka: —Kolkeyqueka kanwan cusca tucucuchun Diospa atiyninta kolkewan ranticuyta yuyaskayquiraycu. ");
INSERT INTO quhNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Sonkoyquipi Diosman mana allinyaskachu canqui. Chayraycu cay imaspi nokaycuwan mana cusca cawajchu. ");
INSERT INTO quhNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Sajra yuyayniyquita sakespa Diosman cutiricuy. Paymanta mañacojtiyqui ichapis qhuyacususpa sonkoyquita juchamanta llimphuchasunquiman. ");
INSERT INTO quhNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Reparani sonkoyqui ancha sajrawan junt'a caskanta juchawan apaycachaska ima caskayquita, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Chaymantataj Simón cuticherka: —Amajinachu caychej. Señor Diosmanta mañapuwaychej nokapaj chay niwaskayquichej mana ruwacunanpaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Chanta Señor Jesuspa cachasnenka runasman paymanta sumajta willarkancu. Niskantapis willararkancu. Chaywanpis Jerusalén llajtaman cutishaspa rejjina ashqha ranchospi Samaria jallp'api sumaj willanasta willararkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Diosmanta cachamuska uj willaj angeltaj Felipeta parlapayarka: —Waquichicuspa riy uraman ch'innej ñanninta. Chay ñan Jerusalenmanta Gaza llajtaman rishan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Felipetaj chaypachita casuspa rerka. Rishaspataj ñanpi uj curaj runawan tincorka. Payka camachejpa kolkenta jap'ej runa carka Etiopía jallp'amanta. Chaypitaj Candace warmi camacherka. Chay curaj yanapajka Diosta yupaychaj Jerusalenman riskanmanta cutimpusharka. Sumaj c'achitu carretonpi tiyaska leesharka Diosmanta unay willaj Isaiaspa kelkaskanta. ");
INSERT INTO quhNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Chanta Santo Espiritoka Felipeta nerka: —Kayllaycuspa chay carretonta taripay, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Felipe kayllaycuspataj uyarerka chay curaj runa leeshaskanta unay willaj Isaiaspa kelkaskanmanta. Tapurerkataj: —Wirakochi ¿entiendenquichu imatachus ninayan chayta? ");
INSERT INTO quhNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Chay curaj runataj cuticherka: —Mana pi sut'inchawajtin ¿imaynatataj sapallay atiyman entiendeyta? Felipetataj carretonman wajyaycuspa kayllanpi tiyaycucherka. ");
INSERT INTO quhNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Diospa palabranta leeshaskanka cayjina carka: Payka uj ovejajina ch'inllamanta apachicorka wañuchinancupaj. Ruthojcuna ruthushajtincu corderojina ch'inlla cacorka. Ajinapi ni imata parlarerkachu. ");
INSERT INTO quhNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Mana juchayoj cashaspapis payka llamp'uchacorka. Mana qhuyaspa khasillamanta wañucherkancu. Nitaj pipis payman sayacorkachu. Khatejcunantarí ¿pitaj yupayta atinman? ");
INSERT INTO quhNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Curajtaj Felipeta taporka: —Niway, Diospa unay willajnin ¿pimantataj chayta parlashan? ¿Pay quiquinmantachu? chayrí ¿wajmantachu? ");
INSERT INTO quhNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Felipetaj Etiopía curajpa leeskan, chaymanta kallarispa willararka. Sut'ita nerka Jesús wañuskanta tucuyman wiñay causayta konanpaj. ");
INSERT INTO quhNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Rishaspataj yacuman chayarkancu. Chay curaj runataj nerka: —¡Khawariy, caypi yacu tiyan! ¿Imajtintaj mana bautizawanquichu juchasniymanta Diosman cutiriskayta ricuchinaypaj? ");
INSERT INTO quhNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Felipetaj cuticherka: —Kan tucuy sonkoyquiwan Jesuspi jap'icunqui chayka, aticun, —nispa. Chay curaj runa nillarkataj: —Noka sumajta jap'icuni Jesucristo Diospa c'ata Wawan caskanta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Curajka carretonninta sayachinanta camacherka. Felipewan curajwanka yacuman uraycorkancu. Chaypiri Felipe payta bautizarka. ");
INSERT INTO quhNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Yacumanta llojsimojtincuri Señor Diosmanta cachamuska Espiritoka Felipeta ujllata pusacaporka. Chay curajtaj manaña Felipeta astawan ricorkachu. May cusiskataj ripullarkapuni ñanninta. ");
INSERT INTO quhNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipetaj Azoto llajtapi riqhurerka. Riskanpitaj Jesusmanta willararka tucuy llajtaspi Cesarea llajtaman chayanancama. ");
INSERT INTO quhNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Chaycamataj Sauloka mayta chejnispa nishallarkapuni: “Wañuchisaj Jesucristota casojcunata”, nispa. Chayraycu yupaychanawasimanta curajman kayllaycuspa paymanta uj kelkaskata mañarka. Munarka atiyta Damasco llajtapi tantacuna-wasispi Diospa ñanninpi purejcunata masc'amunanpaj. Paycunata tarispataj jap'iycuchiyta munarka Jerusalenman wataskata apachinanpaj, kharistapis warmistapis. ");
INSERT INTO quhNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Rispataj, Saulo Damasco llajtaman kayllaycusharka. Mana yuyashajtillan janaj pachamanta uj sinch'i c'anchay paypa muyuyninpi c'ancharerka. ");
INSERT INTO quhNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Paytaj pampaman chokacamorka. Payta parlapayajtataj uyarerka: —Saulo, Saulo ¿imaraycutaj nokata ñac'arichinawayquipaj khatiycachawanquirí? ");
INSERT INTO quhNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Chanta Saulo taporka: —¿Kanchu cawaj, Señor Dios? Chay parlajtaj cuticherka: —Noka Jesús cani. Nokata khatiycachashawanqui. Kan quiquillayquitataj ñac'arichicushanqui. Uj animal t'ojsinaman jayt'aspa nanachicun ajinata nanachicushanqui, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Saulotaj manchachicuywan qharcatitispa taporka: —¿Imatataj munashanqui ruwanayta, Señor? Jesustaj nerka: —Jataricuspa cunanpacha llajtaman yaycuy. Chaypi uj runa willasonka imatachus ruwanayquitapis, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Saulowan rejcunataj manchaymanta t'ucushaj sayasharkancu. Uyarerkancu parlapayajta nitaj pitapis ricorkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Chanta Sauloka chokacuskanmanta jataricorka. Ñawisninta quicharispataj mana ni imatapis ricorkachu ñawisnin tutayapuskanraycu. Chayraycu maquinmanta aysaspa pusarkancu Damascocama. ");
INSERT INTO quhNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Chaypitaj quinsa p'unchayta mana imata ricuyta aterkachu. Manataj miqhorkachu nitaj ujyarkachu. ");
INSERT INTO quhNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damascopi tiyacorka Jesuspi uj jap'icoj runa, Ananías sutiyoj. Señor payman riqhurerka uj moskhoypijina. Nerkataj payta: —¡Ananías! —nispa. Paytaj cuticherka: —Caypi cashani, Señorníy, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Chanta Señor Jesús payta nerka: —Rillayña chay Chekan sutiyoj ñanman. Chaypi Judaspa wasinpitaj tapucunqui Saulo sutiyojmanta. Payka Tarso llajtamantamin. Cunitanpis Diosmanta mañacushan. ");
INSERT INTO quhNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Uj moskhoypijina ricusorka yaycushaskayquita maquiyquita payman churashajta ima. Chay ruwaskayquiwan watejmanta ricunanpaj moskhoypi ricusorka. ");
INSERT INTO quhNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Chayta uyarispaka Ananías cuticherka: —Señorníy, ashqha runas willawancu chay Saulomanta. Kanpi jap'icoj t'akaska wawasniyquita Jerusalenpi mayta ñac'arichiskanmantapis uyarini. ");
INSERT INTO quhNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Cunanpis yupaychana-wasimanta curajcunaj atiynincuwan caypi cashan jap'irachinanpaj kanmanta tucuy wajyacojcunata, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Señor Jesusrí nerka: —Kanka rillay payman. Paytaka ajllarkani nokamanta willaramunanpaj. Diosmanta manaraj yachajcunaman, curaj camachejcunaman, israel runasniymanpis willaramunan tiyan. ");
INSERT INTO quhNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Noka quiquiy ricuchisaj payman may chhicata nokaraycu ñac'arinanta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ajinapi Ananías rispa maypichá Saulo casharka, chay wasiman yaycorka. Napaycuytawan maquisninta Pabloj umanman churaspataj nerka: —Hermano Saulo, ñanpi jamushajtiyqui riqhurisoj, chay tucuy atiyniyoj Señor Jesús cachamuwan. Chayraycu jamuni ujtawan ricunayquipaj Santo Espirituwan junt'a sonkoyquipi canayquipajtaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Chay quiquinpachataj Sauloj ñawisninmanta wisk'ajcuna t'akacorkancu. Ricorkataj. Jatariytawantaj bautizacorka, ricuchinanpaj Jesucristopi jap'icuskanta. ");
INSERT INTO quhNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Chanta miqhuytawan callpachacorka. Damascopitaj Jesuspi jap'icojcunawan uj p'unchaycunata carka. ");
INSERT INTO quhNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Chay quiquinpachataj tantacuna-wasispi willarasharka Jesuska Diospa c'ata Wawan caskanta. ");
INSERT INTO quhNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Tucuy uyarejcunataj t'ucuspa tapunacusharkancu: —¿Manachu cay runallataj Jerusalenpi khatiycachasharka Jesuspi jap'icojcunata ñac'arichinanpaj? ¿Manachu payka cayman jamorka paycunata wataskata yupaychana-wasipi curajcunaman apananpaj? ");
INSERT INTO quhNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saulorí astawan callpachacuspa Dios Espirituwan willaraj Jesuska Diospa ajllaskan caskanta camachinanpaj. Chayraycu Damascopi tiyacoj israelcunaka niña ni imatapis cutichiyta atejchu cancu sut'ita willaraskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Unay p'unchaycunamantaña israelcuna parlanacorkancu imaynamantapis Saulota wañuchinancupaj. ");
INSERT INTO quhNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Saulorí yachacorka wañuchinayashaskancuta. Israelcunataj llajta llojsinaspi tuta p'unchay sumajta khawasharkancu payta wañuchinancupaj. ");
INSERT INTO quhNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Sauloj yachacojcunanrí payta uj jatun canastapi tutallan orkhorkancu. Llajta alto perkanejtataj uraycucherkancu Saulo aykecunanpaj. ");
INSERT INTO quhNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ajinamanta Saulo chayarka Jerusalenman. Jesuspi jap'icojcunawantaj chaypi ujchacuyta munarka. Paycunataj manchachicorkancu creespa pay mana chekamantachu Jesuspi jap'icuskanta. ");
INSERT INTO quhNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Bernaberí pusarka Saulota Señor Jesuspa cachasninman rejsichinanpaj. Sut'ita willarkataj imaynatachus Saulo ñanpi Jesusta ricuskanta Jesustaj paywan parlaskantapis. Willallarkataj imaynatachus Damascopipis mana manchachicuspa Jesuspa atiyninwan willaraskanta. ");
INSERT INTO quhNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Cristopi cheka hermano caskanta yachaytawan munarkancu paycunawan tantacunanta Jerusalenpi. Hermanoswan cusca purispataj ");
INSERT INTO quhNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Señor Jesuspa atiyninwan willararka mana manchachicuspa. Pay griego parlajcunamanpis tapuynincuman cutichej allinta yachachejpis. Paycunarí Saulota wañuchej churacorkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Chayta yachaspa Cristopi hermanos pusarkancu Saulota Cesarea llajtaman. Chaymantataj Tarso llajtaman payta cachaporkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ajinamanta Jesuspi jap'icuspa tantacojcuna allillanta tiyacorkancu tucuynejpi —Judeapi, Galileapi, Samaria jallp'aspipis. Diosta casuspa causacorkancu. Santo Espíritu paycunata callpacharka sonkosnincupi. Astawan ashqhastaj Jesucristopi jap'icorkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pedro tucuynejta purisharka Jesuspi jap'icojcunata watucuspa. Ajinapi chayarka Lida llajtaman hermanosta watucoj. ");
INSERT INTO quhNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Chaypitaj tariparka uj runata, Eneas sutiyojta. Payka mana cuyurej carka, puñunapi siriska pusaj watataña. ");
INSERT INTO quhNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pedrotaj nerka: —Eneas, Jesucristo cunanpacha thañichisunqui. Jatarispa phullusniyquita c'uchuchay, —nispa. Chay quiquinpachataj Eneaska thañiska jataricorka. ");
INSERT INTO quhNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Lida llajtapi Sarón jallp'apiwan tucuy tiyacojcuna Eneasta purishajta ricorkancu. Ajinamanta paycuna juchasnincuta sakespa Señor Jesuspi jap'icuspataj payta casorkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jope llajtapi carka Cristopi uj jap'icoj warmi, Tabita sutiyoj. Griego parlaypitaj sutin Dorcas taruca ninayan. Payka allin cajtapuni ruwaj pisichicojcunatapis yanapajpuni. ");
INSERT INTO quhNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Chay p'unchaycunapi Tabitaka onkoycuspa wañuporka. Chaypi caj runastaj ayata mayllarpaytawan wasi pata pisoman churarparkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jope llajtamanta Lidamanka mana caruchu carka. Yachaspa Pedro chaypi caskanta Jesuspi jap'icojcuna iscay runasta payman cachamorkancu willanancupaj: —Jamuriwaycu nokaycuman ushkhayllata. ");
INSERT INTO quhNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Chanta Pedroka waquichicuspa rerka chay iscay runaswan. Chayajtintaj pusarkancu maypichus aya casharka chay wasej pata caj pisonman. Chaypi manaña kosayoj tucuy viudas wakaspa Tabitamanta willarkancu Pedroman. Ricucherkancutaj causashaspallaraj p'achasta sirasharka, chaycunata. ");
INSERT INTO quhNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pedrotaj nerka tucuy llojsinancuta. Paytaj konkoricuspa Diosmanta mañacorka. Ayaman cutirispataj nerka: —Tabita, jataricuy, —nispa. Paytaj ñawisninta quicharispa Pedrota khawarispataj tiyaycucorka. ");
INSERT INTO quhNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedrotaj payta maquinwan aysarerka sayaricunanpaj. Diosman t'akaska hermanosta viudastawan wajyaspataj Tabitata causashajta paycunaman ricucherka. ");
INSERT INTO quhNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Chayta yacharkancu tucuy runas Jope llajtapi. Ashqha runastaj Señor Jesucristopi jap'icorkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Chanta Pedroka ashqha p'unchaycunata Jopepi kheparicorka. Uj suela ruwaj Simonpa wasinpitaj tiyacorka. ");
INSERT INTO quhNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Cesarea llajtapi tiyacoj uj runa, Cornelio sutiyoj. Camacherka pachaj soldadosta Italiano niska tropata. ");
INSERT INTO quhNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Payka tucuy wasinpi tiyacojcunawan Diosta jatunchajpuni casojpunitaj carka. Diospa unay runasnin israelcunatapis capuyninwan yanapaspa causacoj. Diosmantapis mañacuspapuni caj. ");
INSERT INTO quhNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Uj p'unchay chaupi tardeta moskoypijina Diosmanta cachamuska uj willaj angelta sut'ita ricorka. Payman chimpaycuspataj chay angel nerka: —¡Cornelio! ");
INSERT INTO quhNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Corneliotaj payta allinta khawarerka. Manchachicuspa taporkataj: —Señor ¿imataj cayrí? —nispa. Chay angeltaj cuticherka: —Diosmanta mañacuskayquipis pisichicojcunata qhuyaskayquipis Diosta cusichin. Paytaj uyarishasunqui. ");
INSERT INTO quhNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Cunanka runasta Jope llajtaman cachaspa Simón Pedro sutiyojta wajyachimuy. ");
INSERT INTO quhNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Payka suela ruwaj Simonpa wasinpi caricushan. Chay Simonpa wasenka jatun kocha kayllapimin. Simón Pedromin nisonka imatachus ruwanayquita, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Angel paymanta ripojtin Cornelioka wajyarka iscay camachisninta, uj soldadontawan. Chay soldadoka Corneliojina Diosta casojllataj carka yanapajcunanmanta paypa atinicuskantaj. ");
INSERT INTO quhNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Chay quinsa runasninman moskoypi ricuskanta tucuyta willarka. Chanta paycunata cacharka Jopeman. ");
INSERT INTO quhNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","K'ayantintaj paycunaka kayllasharkancuña Jope llajtaman. Pedrotaj chaypi wasej patanman rerka Diosmanta mañacunanpaj. Chay wasi pataka pampalla carka. Ñapis chaupi p'unchayña carka. ");
INSERT INTO quhNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","11","Yarkhachicuspataj miqhuyta munarka. Waquichipunancucamataj Pedro moskoypijina ricorka janaj pachata quichacushajta. Chaymanta uj jatun phullujina, tawantin puntasninmanta warqhuska cay pachaman uraycamushajta ricorka. ");
INSERT INTO quhNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Chaypi carkancu tucuy imaymana tawa chaquiyoj q'ita animalcuna suchoj animalcuna, q'ita p'iskocunapis. ");
INSERT INTO quhNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Diostaj Pedrota parlapayarka: —Pedro, jataricuy. Chaycunata wañuchispa miqhuy. ");
INSERT INTO quhNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pedrorí cuticherka: —Ni jayc'aj chayta miqhuymanchu, Señor Diosníy. Imaraycuchus kan unayña camachiwaskaycumanjinaka manapuni miqhorkanichu cay mana miqhuna animalestaka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Dios nerka ujtawan: —Miqhuna llimphuchaskaña niskayka allillanña miqhunapaj. Chaytaka amaña manacajpaj khawaychu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ajinata ruwacorka quinsa cutita. Chanta chay phullujinaka janaj pachaman okharicaporka. ");
INSERT INTO quhNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Simón Pedrotaj yachayta munasharka imatachus Dios payman ninayarka moskhoypi chay ricuchiskanwan. Ajinallapi Cornelioj cachamuskasnin Simón casharka, chay wasita masc'aspa chayamorkancu. Puncupi sayaycuspataj ");
INSERT INTO quhNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","khaparispa taporkancu: —Simón sutichaska Pedro ¿caypichu caricushan? ");
INSERT INTO quhNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pedrorí chayllapiraj cashaspa chay ricuskanta entiendeyta munashajtin Santo Espíritu payta nimorka: —Khaway, quinsa runas masc'ashasuncu. ");
INSERT INTO quhNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Waquichicuspa riy paycunawan ama iscayrayaspa noka paycunata cachamuskayraycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Uraycuspataj Pedroka cachamuska runasman nerka: —Pitachus masc'ashanquichej, noka chay cani. ¿Imamantaj jamorkanquichej? ");
INSERT INTO quhNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Paycunataj cuticherkancu: —Soldadosta camachej Cornelio cachamuwaycu. Payka chekan runamin Diostapis casunpuni. Tucuy Israel llajta-masisniyqui payta c'acha runapaj khawancu. Diosmanta cachamuska uj angel payman sut'inchaspa nerka wasinman wajyasunanta. Pay tucuy ninayquita uyarisuyta munan, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pedroka paycunata wasinman pusaycuytawan tutata chaypi puñucorkancu. K'ayantintaj rerka paycunawan Cornelioj wasinman. Jope llajtamanta waquin hermanospis paywan rillarkancutaj. ");
INSERT INTO quhNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Khepan p'unchaytaj Cesarea llajtaman chayarkancu. Corneliotaj chaypi paycunata suyasharka ayllusninta allin rejsiskasnintawan tantaspa. ");
INSERT INTO quhNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pedro wasinman yaycushajtinña Cornelioka llojserka payta napaycoj. Konkoricuspataj Pedrota yupaycharka. ");
INSERT INTO quhNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pedrorí payta jatarichispa nerka: —Sayaricullay. Nokapis kanjina runallataj cani, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ajina parlaspa yaycorkancu wasinman. Pedrotaj ashqha runasta tantaskata ricorka. ");
INSERT INTO quhNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Nerkataj: —Kancuna yachanquichejjina israel runaspa unay yachachiskas caycu waj llajtayoj runaj wasinmanka ama chayanaycuta, nitaj paycunaman kayllanaycuta. Cunanrí Dios ñapis reparachiwanña waj llajtayoj runasta sumajpaj khawanayta. ");
INSERT INTO quhNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Chayraycu jamuni mana iscayrayaspa wajyachimuwaskayquichejtawan. Munani willarinawayquichejta imapajtaj wajyachiwarkanquichejrí, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Corneliotaj cuticherka: —Ñapis tawa p'unchayña pasan, cunan chaupi tardetajina wasiypi Diosmanta mañacusharkani. Ajinallaman ricorkani moskoypijina uj runata c'anchashaj p'achayojta. ");
INSERT INTO quhNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Payri niwarka: “Cornelio, Dios mañacuskayquita uyarishasunqui. Mana konkapunchu pisichicojcunaman tucuy qhuyaskayquita. ");
INSERT INTO quhNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Cunan cachay runasta Jope llajtaman wajyachimuytaj Simón sutichaska Pedrota. Uj suela ruwaj Simonpapi wajyariska cashan. Chay Simonpa wasenka kocha kayllapimin. Pedrotaj kanman parlasonka”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Uyariytawancamataj wajyachimorkayqui. Walejtapuni jamunqui. Chayraycu cunan tucuyniycu Diospa ñaupakenpi cashaycu uyarinaycupaj tucuy atiyniyoj Señor tucuy camachisuskanta ninawaycupaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Chanta Pedroka paycunaman parlaspa nerka: —Cunan chekamanta yachani may llajtayoj runaspis Diospajka quiquillanpuni caskancuta. ");
INSERT INTO quhNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Diosrí munan tucuy runas paypi jap'icuspa chekan cajta ruwanancuta may llajtamantapis cachuncu. Ajinapi paycunata jap'in. ");
INSERT INTO quhNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Dios willarka israel runasninman paywan allinyacuyta atinancuta Jesucristopi jap'icuspa. Payka atiyniyoj Señormin, tucuy runastataj camachin. ");
INSERT INTO quhNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Kancuna yachanquichej Juan willaskanta. Nerka runas juchasnincuta sakespa yacupi bautizacuspa Diosman cutiricunancuta. Jesús chay khepatataj Galilea jallp'amanta kallarispa tucuy Judea jallp'apipis ruwaskanta yachanquichejña. ");
INSERT INTO quhNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Dioska Nazaret llajtayoj Jesucristota ajllacuspa Santo Espirituta sonkonman churaskantapis yachanquichejñataj. Ajinapi Jesuska atiyniyoj caspa runasta sumajta yanaparka. Supay Satanaspa tucuy llaquichiskancunata thañicherka. Dios paywan caskanraycu tucuy chayta ruwarka. ");
INSERT INTO quhNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Nokaycu ricorkaycu Jesuspa tucuy ruwaskanta Judea jallp'api Jerusalén llajtapipis. Israelcunataj payta cruzpi chacatachispa wañucherkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Quinsa p'unchayninman Dios paytaka causarichimorka. Nokaycu willajcunallaman riqhurichiwarkaycu ");
INSERT INTO quhNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","manataj tucuy runasmanchu. Causarimuskanmanta willanaycupaj Dios unayña ajllacuwarkaycu. Jesús wañuymanta causarimuskanmanta paywan cusca miqhorkaycu. ");
INSERT INTO quhNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Camachiwarkaycutaj tucuy runasman sut'ita willaranaycuta paymanta sumajta parlanaycutapis. Willanaycu tiyan Dios churaskanta Jesusta tucuy runasta khawaspa ninanpaj ruwaskancu allinchus manachus caskanta. Cachun causashajcunapis wañuskacunapis. ");
INSERT INTO quhNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Diospa tucuy unay willajcunanpis Jesusmanta sut'ita willarkancu. Nerkancutaj Jesuspi tucuy jap'icojcuna atiyninraycu juchasnincumanta llimphuchaskas canancuta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pedro chay imasta parlashajtillanraj Santo Espíritu uraycamorka willaskanta tucuy uyarejcunaj sonkoncuman. ");
INSERT INTO quhNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Pedrowan jamoj israel-masisnin Jesucristopi jap'icojcuna carkancu. Paycunaka t'ucorkancu waj llajtayojcunamanpis Diospa qhuyacuyninraycu Espirituta cachamuskanmanta. ");
INSERT INTO quhNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Imaraycuchus waj parlaycunata parlashajta Diosta jatunchashajtataj uyarerkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Chanta Pedro nerka: —Paycunapis nokanchejjinallataj Santo Espirituta sonkoncupi tiyacunanpaj jap'erkancu. Chayraycu ni pi jarc'anmanchu paycuna yacupi bautizacunancuta Diosman cutiriskancuta ricuchinancupaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Camacherkataj chaypi cajcunata bautizacunancuta Jesucristo tucuy atiyniyoj caskanta sut'ita willaspa. Chanta mayta nerkancu Pedrota uj pisi p'unchaycunata paycunawan kheparicunanta. ");
INSERT INTO quhNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Jesuspa cachasnin Judea jallp'api caj hermanospis chayta uyarerkancu. Ajinapi yacharkancu waj llajtayoj runaspis Diospa palabranta jap'iskancuta. ");
INSERT INTO quhNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","3","Chanta Pedro Jerusalén llajtaman cutejtin israel-masisninmanta Cristopi hermanos paywan churanacorkancu: —¿Imaraycutaj chayacorkanqui waj llajtayojcunajmanrí? ¿Imaraycutaj paycunawan miqhorkanquirí? ");
INSERT INTO quhNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pedrotaj paycunaman tucuyninta ujmanta uj willayta kallarerka: ");
INSERT INTO quhNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Jope llajtapi casharkani Diosmanta mañacuspa. Uj moskoypijinataj Dios ricuchiwarka uj jatun phullujina janaj pachamanta uraycamojta. Tawantin puntasninmanta warqhuskataj nokaman chayamuwarka. ");
INSERT INTO quhNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Khawaycuspataj sut'ita ricorkani tucuy imaymana tawa chaquiyoj animalcunata, q'ita animalesta, suchoj animalcunata p'iskocunatapis. ");
INSERT INTO quhNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Diostaj niwarka: “Pedro, jataricuy. Chaycunata wañuchispa miqhuy”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nokarí nerkani: “Ni jayc'aj, Señor Diosníy. Imaraycuchus kan unay camachiwaskaycumanjinaka cay mana miqhuna animalesta mana miqhorkanichu”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Chaymanta pay nillawarkataj: “Miqhuna llimphuchaskaña niskayka allillanña miqhunapaj. Chaytaka amaña manacajpaj khawaychu”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ajina ruwacorka quinsa cutita. Chanta phullujinaka janaj pachaman okharicaporka. ");
INSERT INTO quhNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Chayllaman chayamorkancu, noka casharkani chay wasi puncuman, quinsa runas cachamuskas Cesarea llajtamanta. Jamuskancu nokata masc'aj. ");
INSERT INTO quhNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Santo Espiritutaj cachawarka paycunawan rinaypaj mana iscayrayaspa waj llajtayojcuna caskancumanta. Nokawan rillarkancutaj Cristopi cay sojta hermanospis. Tucuy nokaycutaj chayaspa yaycorkaycu Cornelioj wasinman. ");
INSERT INTO quhNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Corneliori willawarkaycu Diosmanta cachamuska uj willaj angelta ricuskanta wasinpi sayashajta. Willaspataj niska: “Cachay runasta Jope llajtaman wajyachimuytaj Pedro sutichaska Simonta. ");
INSERT INTO quhNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Pay nisonka kanta wasiyquipi cajcunatawan imaynata wiñay causayniyoj canayquichejta”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Parlayta kallarishajtiytaj, chaypacha Santo Espíritu uraycamorka sonkoncuman. Imaynatachus ñaupajpi nokanchejman uraycamorka ajinallatataj. ");
INSERT INTO quhNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Chanta yuyaricorkani Señor Jesuspa uj cuti niskanta: “Chekamanta Juanka runasta yacupi bautizarka juchasnincuta sakejtincu Diosman cutiriskancuta ricuchinancupaj. Pisi p'unchaycunamantarí kancunata bautizaspa cachamusonkachej Santo Espirituta sonkoyquichejman payllapaj causanayquichejpaj”. Ajina niskanta yuyaricorkani. ");
INSERT INTO quhNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Señor Jesucristopi jap'icojtinchejmin Dioska cachamorka Santo Espirituta sonkonchejman. Chay quiquin Espiritutataj cachamorka. Chayraycu ¿pitaj carkani noka, Dios munayninta ruwananta jarc'anaypajrí? ");
INSERT INTO quhNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Chayta uyarispataj Cristopi hermanos manaña Pedrowan churanacorkancuchu. Manachayrí Diosta jatuncharkancu: —¡Chayka niyta munan Dioska munaskanta waj llajtayoj runaspis payman cutiricunancuta wiñay causayniyoj canancupaj! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","12.2 Runas Estebanta wañucherkancu Jesusmanta willaraskanraycu. Chaypachataj runas sinch'ita hermanosta ñac'aricherkancu. Ajinapi waquin hermanos ch'ekerachiskas caspa rerkancu jakay Fenicia jallp'acama. Waquenka Chipre jallp'acama waquintaj Antioquía llajtacama rerkancu. Chay caru jallp'aspi willarkancu Jesusmanta israel llajta-masisnillancuman. Manataj waj llajtayoj runasmanka willarkancuchu. ");
INSERT INTO quhNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Chaywanpis Cristopi waquin hermanos Chipremanta Cirenemantawan rerkancu Antioquía llajtaman. Rispa jakay waj llajtayoj runasmanpis sumaj willanasta willararkancu. Nerkancutaj Jesús tucuy atiyniyoj Señor caskanta. ");
INSERT INTO quhNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Dios paycunta sumajta yanapasharka. Ashqhas millay causaynincuta sakespataj Jesuspi jap'icorkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jerusalén llajtapi tantacoj hermanos chayta uyarerkancu. Chayraycu cacharkancu Bernabeta Antioquía llajtacama. ");
INSERT INTO quhNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Paytaj chayaytawan khawarka imaynatachus Dios atiyninwan paycunata yanapaskanta. Ricuskanmanta mayta cusicuspataj yuyaycharka tucuy paycunata Jesuspi jap'icuspa tucuy sonkowanpuni payta casunancuta. ");
INSERT INTO quhNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Cay Bernabeka c'acha runa carka sonkonpi Santo Espirituwan junt'a. Jesuspi sumajta jap'icojtaj carka. Ajinapi astawan ashqha runas Jesuspi jap'icorkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Chanta Bernabé rerka Tarso llajtaman Saulota masc'aspa. Payta tarispataj pusarka Antioquiaman. ");
INSERT INTO quhNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Chaypi Cristopi tantacojcunawantaj uj wata junt'ata tantacorkancu. Yachacherkancutaj ashqha runasta Jesusmanta. Caypi ñaupajta suticharkancu Cristopi jap'icojcunata “Jesucristojpata cajcuna”, Cristianos nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Chay p'unchaycunapi Diospa willanasninta willarajcuna Jerusalenmanta rerkancu Antioquía llajtaman. ");
INSERT INTO quhNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Paycunamantataj uj hermano Cristopi, Agabo sutiyoj, tantacojcunaj chaupincupi sut'incharka. Santo Espíritoj atiyninwan willarka uj jatun yarkhay jamunanta tucuy jallp'asman. Chay yarkhaytaj carka camachej Claudio camachishajtin. ");
INSERT INTO quhNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ajinamanta Antioquiapi tantacoj hermanos Judea jallp'api tantacojcunaman yanapayta yuyarkancu. Tucuynincu unanchacuspa atiskancumanjina tantarkancu kolketa apachinancupaj. ");
INSERT INTO quhNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ajinataj paycunaka apacherkancu Judea jallp'api tantacojcunaj curajnincuman. Chay apachicuta Bernabewan Saulopiwan aparkancu jaywanancupaj. ");
INSERT INTO quhNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Chay p'unchaycunapi camachej Herodes ñac'arichiyta kallarerka Cristopi tantacojcunamanta waquin hermanosta. ");
INSERT INTO quhNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Juanpa wauken Jacobotapis uj jatun makana cuchillowan wañuchicherka. ");
INSERT INTO quhNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Herodesrí repararka israelcunata chay ruwaskanwan cusichiskanta. Chayraycu Pedrotapis jap'iycucherka israelcunaj jatun p'unchaycunancupi. Chay p'unchaycunapi paycunaka mana pokochinayoj t'antata miqhoj cancu. ");
INSERT INTO quhNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Chanta Herodes wisk'acherka Pedrota carcelman. Chaypi chunca sojtayoj soldadosman jaywarka tawamanta tawa tuta p'unchay sumajta khawanancupaj. Yuyasharka Pedrota orkhomuyta israelcunaj ñaupakencupi juchachaska cananpaj pascua jatun p'unchaycuna pasaytawan. ");
INSERT INTO quhNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ajinapi Pedroka carcelpi wisk'aska casharka sumaj khawaska. Cristopi jap'icuspa tantacoj hermanostaj tucuy sonkowan Pedropaj Diosmanta mañapushallarkancupuni. ");
INSERT INTO quhNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herodestaj k'ayantin Pedrota runaspa ñaupakencuman orkhonan casharka. Chay tutataj Pedroka puñusharka iscay soldados chaupipi. Paycunaman wataska casharka iscay cadenaswan. Soldadostaj carcel puncupi sayasharkancu wakaychanancupaj. ");
INSERT INTO quhNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ajinallaman Dios cachamorka uj willaj angelta. Sumaj c'anchaytaj riqhurerka carcelpi. Chay angeltaj Pedrota maquinwan thalaspa rijch'aricherka. Nerkataj: —¡Jataricuy uskhayta! —nispa. Chayllaman cadenasnin phascaracaporkancu Pedroj maquisninmanta. ");
INSERT INTO quhNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Angelri nerka: —¡Chumpiycucuy! ¡Abarcasniyquita churacuy! Pedrotaj casorka. Chanta angel nillarkataj: —Ponchoyquita churaycucuy. Khatiwaytaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ajinamanta Pedro llojsispa risharka angelpa khepanta. Mana yacharkachu ruwacuskan chekachus manachus caskanta. Manachayrí yuyarka musphashaskanta chay angelwan. ");
INSERT INTO quhNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ajinapi angelwan llojserka ñaupaj caj wakaychaj soldados chayninta khepan cajtapis. Llajtaman llojsinapaj fierro puncuman chayamojtintaj chay puncoka payllamanta quicharicaporka paycunapaj. Llojsispataj ñanta purerkancu uj chhicanta. Chanta angel Pedrota ujllata sakerpayaporka. ");
INSERT INTO quhNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Pedrotaj yuyayninman churacuspa nerka: —Cunan chekamanta yachani Señor Dios angelta cachamuskanta Herodespa maquinmanta khechunawanpaj. Israelcuna ñac'arichiwayta tucuy munaskancumantapis jarc'awarka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Chay ruwacuskanta reparaspa Maríaj wasinman rerka. Cay Mariaka Juan Marcospa maman carka. Chaypitaj ashqha tantaska hermanos Diosmanta mañapusharkancu Pedropaj. ");
INSERT INTO quhNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Calle puncuta tocajtintaj uj camachi warmi, Rode sutiyoj, llojserka uyarej. ");
INSERT INTO quhNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Payri Pedrota parlaskanmanta rejsirpaspa cusiymanta puncuta mana quicharkarajchu. Manachayrí uqhuman correycuspa paycunaman willamorka Pedro puncupi cashaskanta. ");
INSERT INTO quhNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Wasipi cajcunataj nerkancu: —¡Manachá yuyayniyquipichu cashanqui! Paypuni caskanta nisharka. Hermanosrí ninacorkancu: —Ni paychu canman. Paypa wakaychaj angelninchá, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Chaycamataj Pedroka puncuta tocamushallarkapuni. Paycuna puncuta quichaspa Pedrota ricuspataj t'ucorkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Payrí maquinwan ch'inyanancuta nerka. Paycunaman willarkataj imaynata tucuy atiyniyoj Señor payta carcelmanta orkhomuskanta. Nerkataj: —Caycunata Jacoboman willamuychej chay waquin hermanosmanpis, —nispa. Llojsispataj Pedro wajnejman riporka. ");
INSERT INTO quhNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Sut'iyajtincamataj carcel soldados uqhu sinch'ita ch'ajwarkancu Pedromanta yachayta munaspa. ");
INSERT INTO quhNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodeska Pedrota masc'acherka. Soldadosninrí payta mana tariyta aterkancuchu. Khawaj soldadosta sumajta tapuspataj camacherka paycuna wañuchiskas canancuta. Chay pasayta riporka Judea jallp'amanta Cesarea llajtaman tiyacoj. ");
INSERT INTO quhNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Camachej Herodestaj ancha phiñaska carka chay Tirowan, Sidón jallp'apiwan tiyacojcunapaj. Paycunaj curajcunancuri uj yuyaylla churacorkancu Herodespaman rinancupaj. Herodeswan allinyacuynincupi yanapananpajtaj Blastowan munachicorkancu. Chay Blastoka Herodespa wasinpi jatun camachi carka. Herodespa jallp'asninmanta jamoj miqhunawan causaskancuraycu allinyacuyta munarkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herodeska paycunawan parlananpaj uj p'unchayta ajllarka. Chay p'unchaypitaj camachinan p'achasta churaycucorka. Camachina tiyananpi tiyaycuspataj parlamorka. ");
INSERT INTO quhNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Runastaj khaparerkancu: —Parlamushan, payka uj diosjinamin, manataj runajinallachu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Chaypachitataj Señor Diosmanta uj cachamuska angel onkoycucherka Herodesta. Diosta mana jatunchaskanraycu qhuruycuskataj wañorka. ");
INSERT INTO quhNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Diospa sumaj willanasnintarí astawan ashqhas uyarerkancu jap'icorkancutaj. ");
INSERT INTO quhNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bernabewan Saulowan ruwanancuta junt'arkancu. Chanta Juan Marcostawan pusaspa Jerusalén llajtamanta cuterkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioquiapi tantaska hermanosmanta carkancu Diospa niskanta willajcuna, yachachejcuna ima. Carkancu Bernabé, yana runa niska Simón, Cirenemanta Lucio, camachej Herodeswan cusca uywaska caj Manaén, Saulopiwan. ");
INSERT INTO quhNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Uj p'unchaypi paycuna mana imata miqhuspa tantaskas Diosta yupaychasharkancu mañacusharkancutaj. Ajinapitaj Santo Espíritu paycunata parlapayarka: —Nokapaj ruwanancupaj t'akapuwaychej Bernabeta Saulotawan. Paycunatamin chaypaj wajyarkani, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Chanta Diosta yupaychanapaj mana miqhuspa paymanta mañacorkancu. Ajinapi maquisnincuta chay ajllaska runaspa umasnincuman churarkancu ricuchispa Diospaj ruwanancupaj churaskas caskancuta. Chaymanta paycunata cacharparerkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Khepanta Santo Espíritu rinancuta niskanraycu Bernabé Saulowan Seleucia llajtaman uraycamorkancu. Chaymanta yacunta barcopi rerkancu Chipre jallp'aman. ");
INSERT INTO quhNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Chayman chayaspataj kocha canto Salaminapi willarayta kallarerkancu. Chaypi Diospa sumaj willanasninta israelcunaj tantacuna-wasisnincupi willararkancu. Juan Marcospis paycunawan rispa yanapasharka. ");
INSERT INTO quhNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Yacuwan muyuska, tucuy chay jallp'ata purerkancu willaraspa. Pafos llajtaman chayarkancu. Chaypi tariparkancu uj israel runata. Payka Barjesús sutiyoj uj layka carka. Llullacuspa “Diospa willajnin cani”, nej. ");
INSERT INTO quhNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Chay jallp'api Sergio Paulo camacherka, sumaj yuyayniyoj runataj carka. Chay layka paywan caj. Camachej Sergiotaj munarka yachayta Diospa sumaj willanasninta. Chayraycu wajyacherka Bernabeta Saulotawan. ");
INSERT INTO quhNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Chay laykarí paycunata anchata jarc'arka. Griego parlaypi sutenka, Elimas, layka niyta munan. Camachejtataj Jesuspi ama jap'icunanpajpis atiskanta yuyaychasharka. ");
INSERT INTO quhNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Saulorí, ujnin sutinpis Pablo, Santo Espirituwan junt'a yuyayninpi callpachaska carka. Ajinataj laykata allinta khawaycuspa ");
INSERT INTO quhNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","nerka: —¡Tucuyta pantachej llulla runa! ¡Sajrataj canqui! ¡Supay Satanaspa apaycachaskan! ¡Tucuy chekan cajta chejnicojpuni! ¿Runas Jesucristoj cheka munayninta casunancuta jarc'allanquipunichu? ");
INSERT INTO quhNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Chay ruwaskayquimanta cunan tucuy atiyniyoj Señor Dios ñac'arichisonka. Ciegoman tucunqui. Intej c'anchayninta mana ricunquichu uj p'unchaycunapaj, —nispa. Chaypachitantaj laykaka ñawisnin tutayaycojtin lakhapi ricucorka. Thamaycachaspataj uj pusaycachajta masc'acorka. ");
INSERT INTO quhNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Chayta ricuspa Sergio Paulo Jesuspi jap'icorka. Maytataj t'ucorka Señor Jesuspa yachachinasninta uyarispa. ");
INSERT INTO quhNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pabloka llanc'aj-masisninwan yacunta rerkancu Pafos llajtamanta Perge llajtacama. Chay llajta Panfilia jallp'api carka. Juan Marcosrí paycunata sakerparipuspa Jerusalén llajtaman cutiriporka. ");
INSERT INTO quhNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Paycunataj rillarkancupuni Perge llajtamanta Pisidia jallp'api Antioquía llajtacama. Chaypi caspataj samacuna p'unchaypi yaycorkancu tantacuna-wasiman. Tiyaycucorkancutaj. ");
INSERT INTO quhNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Moisespa camachiskasninmanta unay willajcunaj kelkaskasnincumantawan leejta uyarerkancu. Khepanta tantacuypa curajcunan Pablota Bernabetawan nichimorkancu: —Llajta-masis, ima yuyaychanapis tiyan nokaycupaj chayka, cunan niwaycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pablotaj sayaycucuspa maquinwan ch'inyacunancuta mañaspa nerka: —Israel llajta-masis, waj llajtasmanta Diosta tucuy casojcunawan, uyariwaychej. ");
INSERT INTO quhNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel llajta yupaychan, chay Dioska unay tatasninchejta ajllacorka. Jatun llajtamantaj ashqhayacherka Egipto jallp'allapiraj forasteros cashajtincupis. Dios chaymanta jatun atiyninwan paycunata Egipto jallp'amanta orkhomorka. ");
INSERT INTO quhNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Tawa chunca watatajina mana runa tiyacuna jallp'aspi paycunata pusaycacharka. May munacuywantaj pantaskasnincuta qhuyaspa muchorka. ");
INSERT INTO quhNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Payka kanchis ayllucunata Canaán jallp'api atipaspa tucucherka. Chay jallp'ancutataj unay tatasninchejman koporka jap'inancupaj. ");
INSERT INTO quhNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Chaymanta churarka yuyaysapa chekanchajcunata camachinacupaj. Ajinata Dios unay tatasniycuta camachicherka tawa pachaj phishka chuncayoj watatajina unay willajnin Samuelcama. ");
INSERT INTO quhNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Chanta unay israel tatas uj jatun camachejta mañacorkancu. Diostaj churarka Saulta tawa chunca watata camachinanpaj. Pay carka Benjamín ayllumanta Cispa wawan. ");
INSERT INTO quhNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Diosrí Saulta wijch'uspa Davidta churarka camachinanpaj. Paymantataj allinta parlaspa nerka: “Cay David Isaipa wawanka sonkoymanjinamin. Pay tucuy munayniymanjina ruwanka”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Chay Davidpa khepa alchhisninmanta Jesús carka. Paytataj Dios churarka israel llajtanta juchamanta cacharichinanpaj sumaj niskanmanjina. ");
INSERT INTO quhNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Juan jamorka Jesuspa ñaupakenta. Pay willararka tucuy israel runasman millay causaynincumanta Diosman cutiricunancuta. Cutiriskancuta ricuchinancupajtaj yacupi bautizacunancuta willararka. ");
INSERT INTO quhNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Payllataj willayninta tucuchashaspa nerka: “Diospa ajllaskanta suyashaskayquichejka mana nokachu cani. Manachayrí khepayta jamojmin. Diospa c'ata Wawan caskanraycu mana paypajka camachinpajjinallapischu cani”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","‘Llajta-masis, Abrahammanta jatun tatanchej cajcuna, Diosta tucuy casojcunawan: Cay sumaj willanaska nokanchejman apachimuskamin wiñay causayniyoj cananchejpaj. ");
INSERT INTO quhNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Chay Jerusalén llajtapi tiyacojcuna curajcunancuwan mana yacharkancuchu Jesús juchamanta Cacharichej caskanta. Nitaj entienderkancuchu unay willajcunaj kelkaskasnincuta sapa samacuna p'unchay leespapis. Ajinapi chay sut'inchaskas junt'acorkancu Jesusta wañunanpaj juchachaskancuwan. ");
INSERT INTO quhNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Camachejcuna Jesuspi wañunanpajjina juchata mana tarerkancuchu. Chaywanpis Jerusalencuna curajcunancuwanka mañarkancu Pilato payta wañuchinantapuni. ");
INSERT INTO quhNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ajinapi chay ruwaskancuwan junt'acorka Jesusmanta tucuy unay kelkaskas. Chanta Jesuspa yachacojcunan payta chacatanamanta uraycuchispa p'ampaycorkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Diosrí wañuymanta causarichimorka. ");
INSERT INTO quhNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Galilea jallp'amanta Jerusalén llajtaman Jesuswan cusca rejcunaka causarimpuskanmanta ashqha p'unchaycunata payta ricorkancu. Cunantaj israel runasman paymanta willajcuna cancu. ");
INSERT INTO quhNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","‘Nokaycupis sumaj willanasta kancunaman willashaycu unay israel tatasninchejman Diospa sumaj niskanta. ");
INSERT INTO quhNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Nokanchej, paycunaj khepa alchhisninmantaj Dios sumaj niskanta junt'arka Jesusta causarichimuspa. Iscay caj taquinapi Jesusmanta Dios nin: Waway canqui. Cunan p'unchay noka kanta jatunchayqui. ");
INSERT INTO quhNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ajinata Dios nerka Jesusta causarichimunanta, cuerpon ni jayc'aj ismunanpaj. Chayraycu nillarka: “Kancunata yanapaskayquichej Davidman sumaj niskaymanjina”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Chayraycu ujnin caj taquinapi nillantaj: “Ajllaska runayquej cuerpontaka mana ismunanta sakenquichu”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ciertopuni Davidka causaj-masisninta sumajta yanaparka Diospa munayninmanjina. Chanta wañupuspa tatasninwan cusca p'ampacorka. Paypa cuerpontaj ismuporka. ");
INSERT INTO quhNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Diospa causarichimuskan, Jesuspa cuerponrí mana ismorkachu. ");
INSERT INTO quhNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Llajta-masis, chayraycu yachanayquichej tiyan willaraskayka Jesusnejta runas juchasnincumanta llimphuchaskas canancuta. ");
INSERT INTO quhNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Moisespa camachiskasninta casuspallaka runa mana atinchu juchasninmanta llimphuchaska cayta. Jesuspi tucuy jap'icojllata, juchasninmanta llimphuchaska caskanraycu chekan runapaj Dioska khawan. ");
INSERT INTO quhNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Khawacuychej allinta. ¡Pajtataj unay willajcunaj niskasnincu kancunamantapis canman! Dios paycunata kelkacherka: ");
INSERT INTO quhNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","¡Allinta khawacuychej nokamanta asicojcuna! Noka Dios cani. May jatun t'ucunata ruwashani ñaupakeyquichejpi. Ujcuna willasunquichejman chaypis, manapuni creenquichejchu. Chayraycu ¡ruwaskasniymanta t'ucushaspapis wiñaypaj chincapunquichej! ");
INSERT INTO quhNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pablo Bernabewan chay willanasta tucuchaspa llojsipusharkancu tantacuna-wasimanta. Runastaj paycunata mayta mañacorkancu cutimunancuta khepan samacuna p'unchayta paycunaman astawanraj willanancupaj. ");
INSERT INTO quhNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Tantacuy tucucojtintaj ashqha israel runas paycunata khaterkancu, israelpa Diosninta yupaychajcunaman tucojcunapis. Pablo Bernabewantaj tucuy paycunata yuyaycharkancu c'acha Diospa yanapaynillanwanpuni causacunancuta. ");
INSERT INTO quhNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Khepan samacuna p'unchaytataj tantacorkancu yakhalla tucuy llajtantin. Paycuna munarkancu uyariyta Diospa palabranta. ");
INSERT INTO quhNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Israelcunaka sinch'ita phiñacorkancu chhica runa Pablota uyarej riskanmanta. Chayraycu churanacorkancu Pabloj niskasninpa contranpi sajrata parlaspa. ");
INSERT INTO quhNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Callpachacuspa Pablowan Bernabewantaj nerkancu: —Kancuna israelcunaman ñaupajta willanaycu carka Diospa palabranta. Kancunarí payta mana jap'icorkanquichejchu. Mana wiñay causayniyojpajjinapischu khawacunquichej. Chayraycu waj runasman ripusajcu. ");
INSERT INTO quhNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Cayjinatamin Señor Dios camachiwarkaycu: Uj c'anchaytajina churayqui tucuy runas yachanancupaj juchancumanta cacharichiyta munaskayta. Tucuy cay pachapi runasman wiñay causaymanta willanayquipaj cacharkayqui. Ajinata Pablo Bernabewan parlarkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Chayta uyarispataj mana israelcuna cusicorkancu: —Señor Diospa niskanka may sumajmin, —nispa. Wiñay causaypaj tucuy ajllaskaña cajcunataj Jesuspi jap'icorkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Señorpa palabranka tucuy chay jallp'api tiyacojcunaman willaraska carka. ");
INSERT INTO quhNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Chay israelcunarí masc'asharkancu imaynatachus ñac'arichiyta Pablota Bernabetawan. Diosta masc'aj, khapaj warmisman, llajtapi khapaj runasmanwan yuyayta korkancu Jesuspa cachasninta ñac'arichinancupaj. Ajinapi llajtancumanta wijch'orkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Chanta Pablo Bernabewan ojot'asnincuta thalaycorkancu ricuchinancupaj chay runas juchawan juchachaskas caskancuta. Iconio llajtamantaj riporkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Jesuspi jap'icojcunaka Antioquiapi may cusiskas carkancu Dios Espirituwan junt'ataj. ");
INSERT INTO quhNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pablo Bernabewan Iconio llajtaman chayaspataj israelcunaj tantacuna-wasincuman rerkancu. Chaypitaj sumajtapuni willararkancu. Ajinapi ashqhas, israel runaspis, waj runaspis Jesuspi jap'icorkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Jesucristopi manapuni creej israelcunarí waj runasta yachaycucherkancu. Okharicherkancutaj hermanospa contranta phiñacunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Chayraycu Pablo Bernabewan chaypi unayta khepacorkancu. Callpachacuspataj sumajta willararkancu Dios runasta maytapuni yanapayta munashaskanta. Dios ricuchinasta t'ucunastawan ruwarka paycunanejta, runas yachanancupaj chay willanas cheka caskanta. ");
INSERT INTO quhNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Chay llajtayojcuna ashqhasrí iscayman t'akacorkancu. Ujcuna israelcunaman sayaskas carkancu ujcunataj Jesuspa cachasninman. ");
INSERT INTO quhNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ajinaka israelcunawan waj runaswan curajcunancuwan uj yuyayllaman tucuspa yachachinacorkancu. Ninacorkancu: —Chay cachasta ñac'arinachej, rumiswan ch'ankaspa wañuchinachej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pablowan Bernabewanrí chay unanchacuskancuta reparaspa chaymanta aykecorkancu. Licaonia jallp'api Listra llajtaman riporkancu, chanta Derbe llajtaman, chay jallp'aj kayllasninmanwan. ");
INSERT INTO quhNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Chaycunapipis Jesusmanta willararkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra llajtapi carka uj runa, chaquinmanta mana puriy atej. Payka ajina suchupuni nacecorka. Tiyaskalla cacoj ni jayc'aj purerkachu. ");
INSERT INTO quhNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Pablo willashajta uyarisharkataj. Pablori payta sumajta khawaycorka. Repararkataj thañicunanpaj chay runa Diospi jap'icuskanta. ");
INSERT INTO quhNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Chanta jatunmanta nerka: —Sayaycuy chekanta, —nispa. Chay suchu runataj ujllata phinquirispa sayaycucorka. Puriytataj kallarerka. ");
INSERT INTO quhNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Runastaj chayta ricuspa Licaonia parlaynincupi khaparerkancu: —¡Dioscuna runaman tucuspa uraycamuwanchej! —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bernabeta suticharkancu Júpiter dios. Pablotataj suticharkancu Mercurio dios pay curaj parlaj caskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Jupiterta yupaychana-waseka llajtaman yaycunapi carka. Jupiterta yupaychachej runataj chayman apamorka wacasta t'ica pillustawan. Paywan ashqha runaswan munarkancu apamuskasnincuta jaywaspa yupaychayta Bernabeta Pablotawan. ");
INSERT INTO quhNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Jesuspa cachasninrí chayta uyarispa p'achasnincuta lliq'icorkancu mana munaspa runas paycunata yupaychanancuta. Chay ashqha runas chaupiman correycuspataj khaparerkancu: ");
INSERT INTO quhNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—Tatacuna, ¿imaraycutaj cayta ruwashanquichejrí? Nokaycupis kancunajina runaslla caycu. Sumaj willanastataj willaraj jamuycu. Chay ruwaska dioscunaman yankha yupaychayta sakespa causaj Diosman cutiricunayquichejta, niycu. Pay ruwarka janaj pachata, cay pachata, jatun kochasta, tucuy chay ruwaskasninpi cajcunatawan. ");
INSERT INTO quhNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Unay p'unchaycunapi tucuy runacuna munaynincumanjina causanancuta Dios sakellarka. ");
INSERT INTO quhNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Astawanpis payka runaswan sut'ita rejsichicorka c'acha Dios caskanta. Pay apachimuwanchej parata. Payllataj miqhunatapis pokochipuwanchej. Pay sajsachiwanchej miqhunawan. Sonkonchejpitaj mayta cusichiwanchej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Tucuy cay imasta nishajtincupis runaska manapuni munarkancuchu casuyta. Ñac'ayta Pablo Bernabewan chay ashqha runasta jarc'arkancu ama paycunaman uywasta jaywaspa yupaychanancuta. ");
INSERT INTO quhNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Chanta waquin israelcuna chayamorkancu Antioquía llajtamanta Iconio llajtamantawan. Paycuna runasta yuyaychaspa Pabloj contranpi okharicherkancu. Ajinamanta runas payta rumiswan ch'ankarkancu. Wañuchiskancuta yuyaspataj llajta jawaman khataterkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Jesuspi jap'icojcunarí Pabloman muyuchaycucorkancu. Paycuna manaña jatarinanta yuyashajtincutaj Pabloka jatarerka. K'ayantintaj Pabloka Bernabewan Derbe llajtaman riporkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Chay llajtapi tiyacojcunaman Jesusmanta sumaj willanasta willararkancu. Ashqha runastaj Jesuspi jap'icuspa payta casorkancu. Chaymanta Pablo Bernabewan cutimorkancu Listra, Iconio, Antioquía, chay quinsa llajtasman. ");
INSERT INTO quhNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Chay llajtaspi Jesuspi jap'icojcunata sonkoncupi callpacharkancu. Yuyaycharkancutaj paycunaka Cristota casuspapuni causanancuta. Chantapis nerkancu: “Dios camachin, chaymanka sinch'ita muchuspa yaycunanchej tiyan”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Cristopi hermanos tantacoj cancu, chaypi Pablo Bernabewan curajcunata churarkancu sapa uj tantacuypaj. Mana imata miqhuspa Diosmanta mañaporkancu. Señor Jesucristopi ñapis jap'icuskancu tucuy paycunata wakaychananpajtaj paymanta mañaporkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Chanta Pisidia jallp'anejta pasaspa Panfilia jallp'aman chayarkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Perge llajtapi Jesusmanta willaraspataj Atalia llajtaman uraycamorkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Chanta barcopi yacusnejta rerkancu Siria jallp'api caj Antioquiaman. Chaypi hermanos ñaupajpi mañapuskancu ruwaynincupi Dios paycunata yanapananpaj. Cunantaj ruwanancuta tucuspaña chay llajtaman cutimporkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Pablo Bernabewan Antioquía llajtaman chayampuspataj Cristopi tucuy hermanosta tantacherkancu. Chaycunamantaj willarkancu Dios paycunawan tucuy ruwaskanta. Willarkancutaj imaynata Dioska willaraskancunejta ricuchiskanta waj llajtayojcunatapis Jesuspi jap'icuyta atiskancuta. ");
INSERT INTO quhNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Chaypitaj paycuna Cristota casojcunawan unayta khepacorkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Chay p'unchaycunapi waquin runas uraycamorkancu Judea jallp'amanta chay Siriapi caj Antioquiaman. Chaypi paycuna yachachisharkancu Cristopi hermanosta. Nerkancutaj: —Moisespa camachiskanmanjina kharej cuerponpi uj señalta churanayquichej tiyan. Mana churawajchej chayka, mana wiñay causayniyoj cayta atinquichejchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Chayraycu Pablopis Bernabepis paycunawan churanacuspa sinch'ita parlarkancu. Chantaña tantacoj hermanos ajllarkancu Pablota Bernabeta ujcunatawan rinancupaj Jerusalén llajtaman. Chaypitaj parlanancu carka Jesuspa cachasninwan, Cristopi hermanosmanta curajcunawan cay imasmanta sut'ita yachamunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Antioquiapi tantaska hermanos paycunata cacharkancu. Chanta cachaskacunaka pasarkancu Fenicia jallp'anejta Samaria jallp'anejta ima. Chaycunapi willararkancu imaynatachus mana israel cajcuna juchancuta sakespa Jesuspi jap'icuskancuta. Cristopi tucuy hermanostaj chayta uyarispa mayta cusicorkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Chanta chay cachaskacunaka Jerusalenman chayarkancu. Chaypi tantaska hermanoswan, Jesuspa cachasninwan, curajcunawanpis paycunata cusiywan tariparkancu. Cachaskacunataj willarkancu Dios paycunawan sumajta ruwaskanta tucuy chay imasta. ");
INSERT INTO quhNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Waquin fariseo parte caj hermanosrí sayarispa nerkancu: —Mana israelmanta hermanoska kharej cuerponpi uj señalta churanancu tiyan wiñay causayniyoj canancupaj. Chaywanpis paycunaman willananchej tiyan Moisespa camachiskasninta casunancuta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ajinapi tantacorkancu Jesuspa cachasninwan hermanosmanta curajcunawan chay jawa sumajta khawanancupaj. ");
INSERT INTO quhNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ashqhataña parlaycuskancumantataj Pedroka sayarispa nerka: —Hermanosníy, yachanquichej Dioska ñaupajpi cachacunamanta ajllawaskanta waj llajtayojcunata willaramunaypaj. Ajinapi sumaj willanasta willarajta cachawarka paycuna uyarispa paypi jap'icunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Runaj sonkonpi tucuy yuyaskanta sut'ita yachan Dios. Chay waj llajtayojcunatapis wawasninpaj jap'iskanta sut'ita ricucherka. Dioska cachamuspa Santo Espirituta sonkoncuman tiyacunanpaj chayta sut'incharka. Paycunaj sonkoncumanpis chay Espirituta cachallarkataj nokanchejpamanjina. ");
INSERT INTO quhNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Paypajka uj rejlla canchej waj llajtayojcunapis, nokanchej israelcunapis. Sonkoncutataj juchamanta llimpucharka Jesuspi jap'icuskancuraycu. ");
INSERT INTO quhNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","11","Dios munayninta ricucherkaña Moisespa camachiskasninnejta. Ni unay tatasninchejpis nitaj nokanchejpis chayta junt'ayta aterkanchejchu. Astawanpis c'acha Señor Jesucristopi jap'icuspa qhuyacuyninraycu nokanchejpis wiñay causayniyoj canchej. Ajinallatataj waj llajtayojcunapis wiñay causayta jap'incu. Chanta ¿imaraycutaj Jesusta casojcunaman waj ruwanasta k'epichinquichejrí? ");
INSERT INTO quhNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Chayta uyarispa tucuy chay ashqha hermanos ch'inyacorkancu. Uyarerkancutaj Pablota Bernabetawan Dios paycunanejta waj llajtayojcuna uqhupi ruwaskanta. Imaynatachus Dios atiyninwan c'acha jatuchej t'ucunastawan ricuchinasta ruwaskanta uyarillarkancutaj. ");
INSERT INTO quhNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Parlayta tucojtincutaj Jacobo nerka: —Hermanosníy, uyariwaychej. ");
INSERT INTO quhNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón Pedro willawarkanchejña ñaupajpis Dios qhuyacuskanta waj llaytayoj runastapis. Paycunamanta runasta ajllarka cheka wawasnin canancupaj. ");
INSERT INTO quhNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Unay willajcunaj kelkaskancupipis Dioska ajinatapuni nin: ");
INSERT INTO quhNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Uj runa urmaska wasita ujtawan wasichan, ajinallataj noka camachej Davidpa khepa alchhisninmanta uj runata churasaj ujtawan camachinanpaj. ");
INSERT INTO quhNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Waj llajtasmanta tucuy chay runaspis rejsiwayta munanancupaj chayta ruwasaj. Paycunata wajyarkani nokajpata canancupaj. ");
INSERT INTO quhNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ajinata nin tucuyta ruwaj Dios. Payka cayta unaymantapacha runasta uyaricherka. Jacoboka nillarkapuni: ");
INSERT INTO quhNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","—Chayraycu noka yuyani waj llajtayojcunata amaña llaquichinanchejta waj ruwanaswan. Paycuna sajra ruwaskasnincuta sakespa Diosman cutirerkancuña. ");
INSERT INTO quhNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Astawanpis paycunaman kelkasunman: “Amaña ruwaska dioscunapaj jaywanasta miqhunancuta, ni khenchachacunancuta, nitaj sipiska uywaj aychanta miqhunancuta yawarnintin caskanraycu, nillataj ima yawarta miqhunancuta”. ");
INSERT INTO quhNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Imaraycuchus Moisespa camachiskasnintaka runas unaymantapacha sapa llajtapi yachachincupuni. Sapa samacuna p'unchaypitaj runas chayta leencu tantacuna-wasispi, —nispa nerka Jacobo. ");
INSERT INTO quhNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Chanta Jesuspa cachasninwan, tucuy tantacoj hermanoswan, curajcunawan unanchanacorkancu. Tantacuynincumantataj ajllarkancu runasta cachanancupaj Antioquía llajtapi caj hermanosman. Pablowan Bernabewan rinancupaj ajllarkancu Judasta Silastawan. Paycunaka sumajpaj khawaska hermanos carkancu. Cay Judasta Barsabás nispa sutichallajtaj cancu. ");
INSERT INTO quhNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Paycunawan apacherkancu uj cartata nispa: “Nokaycu Jesuspa cachasnin, curajcunawan, Cristopi hermanospiwan napaycamuycu tucuy kancuna waj llajtayoj hermanosman. Kancuna Antioquiapi, Siria, Cilicia jallp'aspi tiyacojcunamanwan napaycamuycu. ");
INSERT INTO quhNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Uyarispa yachaycu waquin hermanos mana nokaycumanta cachaskalla jamuskancuta. Paycuna llaquichispa pantachisunayquichejpaj nerkancu: Moisespa camachiskasninta casunayquichej, kharej cuerponpi uj señalta ruwanayquichejpis tiyan wiñay causayta jap'inapaj, nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Chayraycu yuyaycu ajllaska hermanosta cachamunaycoka allin caskanta sumaj sut'i cananpaj. Tucuyniycu uj yuyayman chayaspa paycunata cachamuycu. Paycuna jamushancu munaska hermanosninchej Pablowan Bernabewan. ");
INSERT INTO quhNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Pablo Bernabewan yakha wañorkancu Señorninchej Jesuscristomanta willaskancuraycu. ");
INSERT INTO quhNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ajinaka cachamushaycu Judasta Silastawan. Paycunamin chay kelkaskaycujinatapuni willasonkachej. ");
INSERT INTO quhNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Santo Espiritupis nokaycupis yuyaycu allin caskanta cay yuyaychaskasllata casunayquichejta: ");
INSERT INTO quhNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Amaña ruwaska dioscunaman jaywaska aychata miqhuychejchu. Nitaj yawarta miqhuychejchu. Nitaj sipiska uywaj aychanta miqhuychejchu yawarnintin caskanraycu. Nitaj khenchachacuychejchu. Chaywanka allillan canka. Allillanta causacuychej”, nispa kelkarkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ajinataj cachaskacunaka rerkancu Antioquía llajtaman. Chaypi Cristopi tucuy hermanosta tantaspa cartata jaywarkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Hermanoska chay yuyaychaj cartata uyarispataj mayta cusicorkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas Silaspiwan Diospa willajcunan carkancu. Ashqhata willaraspa hermanosta yuyaycharkancu. Sonkoncupitaj callpacharkancu Jesucristopi astawan jap'icunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Uj p'unchaycunata caricuspa paycunapis cachamojnincuman riporkancu Jerusalén llajtaman. Tucuy hermanostaj paycunata cachaporkancu: ");
INSERT INTO quhNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Silasrí kheparicuyta yuyarka. ");
INSERT INTO quhNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pablo Bernabewanri Antioquía llajtapi kheparicuspa yachachillarkancupuni. Ashqha waj hermanospiwan willararkancu Señor Jesucristomanta sumaj willanasta. ");
INSERT INTO quhNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Khepan p'unchaycunamanta Pablo Bernabeman nerka: —Jacu ujtawan watucamuna hermanosta ñaupajpi willararkanchej Señor Jesucristoj niskanmanta, tucuy chay llajtasman. Watumunataj imaynachus Cristopi cashancu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabeka paycunawan pusayta munarka Juan Marcosta. ");
INSERT INTO quhNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pablorí mana munarkachu. Nerka mana allinchu caskanta riskancupi Panfiliamanta cutiripuskanraycu ruwananta mana tucuchaysispa. ");
INSERT INTO quhNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Chay jawa mayta rimanacorkancu t'akanacunancucama. Ajinamanta Bernabé pusarka Marcosta. Chipre jallp'amantaj yacunta rerka. ");
INSERT INTO quhNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pablotaj Silasta ajllarka. Hermanostaj Diosmanta mañaporkancu Señor paycunata yanapaspapuni wakaychananpaj. Chanta Pablo llojserka. ");
INSERT INTO quhNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Rerkataj Siria jallp'anejta Cilicia jallp'anejtawan. Chay jallp'aspi Cristopi jap'icuspa tantacojcunata sonkoncupi sumajta callpacharka astawan paypi jap'icunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pablo Silaswan chayarkancu Derbe llajtaman. Chaymantataj Listra llajtaman rerkancu. Chaypitaj tarerkancu Jesuspi uj jap'icoj runata Timoteo sutiyojta. Mamanpis Jesuspi jap'icoj carka, Diospa unay ajllaskan israelcunamanta. Tatanrí griego llajtayoj runa carka. ");
INSERT INTO quhNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Hermanos Listrapi Iconiopipis Timoteota sumaj hermanopaj khawarkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pablori munarka Timoteo paywan purinanta. Chaycunanejpi tiyacoj israel runasraycutaj Pablo Timoteoj cuerponpi uj señalta churacherka. Chaytataj israelcuna ruwaj cancu sapa uj kharita Diospa unay ajllaskasnin caskancuta ricuchinancupaj. Tucuy chaycuna yacharkancu Timoteoj tatan griego runa caskanta. Chayraycu Pablo yuyarka chay señalta churanan caskanta. ");
INSERT INTO quhNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Tucuy llajtasman chayaspataj Pablowan llanc'aj-masisninwan hermanosta yachachisharkancu. Jesuspa cachasninwan Jerusalenpi curaj hermanoswan niskancu ruwanancuta chayta casunancuta munacuywan camacherkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Tucuynejpi Jesuspa cachasnenka tantaska hermanosta astawan callpacharkancu Jesuspi jap'icunancupaj. Sapa p'unchaytaj astawan runas Jesuspi jap'icorkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Santo Espíritu jarc'arka Pablota chay llanc'aj-masisnintawan Asia jallp'api sumaj willanasta Jesusmanta willaramunancuta. Chayraycu Frigia jallp'anejta Galacia jallp'anejtawan rerkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ajinapitaj Misia jallp'a kayllaman chayamorkancu. Paycunataj Bitinia jallp'aman riyta yuyarkancu. Jesuspa cachamuskan, chay Espiriturí, rinancuta jarc'allarkataj. ");
INSERT INTO quhNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Chayraycu Misia jallp'a ladollanta pasaspa Troas llajtaman chayarkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Chaypitaj Pabloka tutapi moskoypijina Macedonia jallp'amanta uj runata ricorka sayashajta. Chay runari Pablota mayta niricorka: “Macedonia jallp'aman jamuspa yanapariwaycu”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ajinata Pablo ricuskantawancama Macedonia jallp'aman rinaycupaj churacorkaycu. Nokaycuri chekamanta yacharkaycu Dios camachiwaskaycuta paycunaman sumaj willanasta willaranaycupaj. ");
INSERT INTO quhNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Troas llajtamanta yacunta barcopi puririmuspa chekanta Samotracia jallp'aman chayarkaycu. K'ayantintaj Neápolis llajtaman chayarkaycu. ");
INSERT INTO quhNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Rispa chaymanta Filipos llajtaman chayarkaycu. Filiposka Macedonia jallp'api jatun llajta carka. Chaypitaj Roma llajtamanta runaspis tiyacuncu. Chaypi nokaycu pisi p'unchaycunata khepacorkaycu. ");
INSERT INTO quhNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Samacuna p'unchaypitaj llajtamanta mayu cantoman llojserkaycu. Chaypi yuyarkaycu tincuyta Diosmanta mañacoj rejcunawan. Ajinapi tantacoj warmiswan parlaspataj Jesusmanta yachacherkaycu. ");
INSERT INTO quhNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Carka paycunamanta uj uyarej warmi, Lidia sutiyoj. Payka Tiatira llajtamanta carka, Diostapis munacoj. Culli-puca, sumaj p'achata vendejpis carka. Señor Jesucristo payman sumaj yuyayta korka Pabloj parlaskanta casunanpaj. ");
INSERT INTO quhNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ajinapi payka wasinpi tiyacojcunawan bautizacorkancu Jesuspi jap'icuskancuta ricuchinancupaj. Chaymantataj payka mayta niwasharkaycu: —Señor Jesuspi chekamanta jap'icojpaj khawawanquichej chayka, wasiyman jamuychej caricunayquichejpaj, —nispa. Ajinata wasinman pusawarkaycu. ");
INSERT INTO quhNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Diosmanta mañacoj rincupuni, uj cuti chayman risharkaycu. Ajinallapi uj camachi sipaswan mana yuyaymanta tincucorkaycu. Chay sipaska supaywan apaycachaska carka. Chayraycu runasman mana yachaska imasta willaj. Ajinaspataj patronninpaj ashqha kolketa ganaj carka. ");
INSERT INTO quhNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Chay sipaska Pablotawan nokaycutawan khatiyta kallariwarkaycu. Khaparispataj nisharka: —Cay runaska tucuy atiyniyoj Diospa camachisnin cancu. Paycuna willasonkachej imaynata juchamanta cachariskas canayquichejta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ashqha p'unchaycunata ajinata khaparillajpuni. Pablorí chayta muchuyta manaña aterkachu. Chayraycu cutiricamuspa sajra supayta nerka: —Jesucristoj atiyninwan camachiyqui: Llojsiy paymanta, —nispa. Chay quiquinpachataj supayka sipasmanta llojsiporka. ");
INSERT INTO quhNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Chay sipaspa patronesnin ricorkancu manaña paywan kolketa ganayta atinancuta. Chayraycu Pablotawan Silastawan jap'icherkancu. Ajinaspataj plazapi llajta camachejcunaman khatatarkancu juchachanancupaj. ");
INSERT INTO quhNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Camachejcunaman chimpaycuchispataj nerkancu: —Cay runaska israelcunamanta caspa llajtanchejta okharishancu ch'ajwachinancupaj. ");
INSERT INTO quhNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Wajjina ruwanasta manchayta willashancu. Nokanchejri romanos caskanchejraycu manapuni chaycunata cheka ruwanaspaj jap'iyta atinchejchu, nitaj ruwaytapis, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ashqha runaspis Pabloj contranpi Silaspawan contranpi okharicorkancu. Camachejcunataj iscaynincoj p'achasnincuta lluch'urparicherkancu. Camacherkancutaj c'aspiwan wajtaskas canancuta. ");
INSERT INTO quhNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ashqhata wajtachispataj carcelman churaycorkancu. Carcelta khawajtataj camacherkancu paycunata sumajta khawananta ama aykecunancupaj. ");
INSERT INTO quhNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Khawajri camachiskancuta casuspa uqhu caj carcel wasiman paycunata churaycorka. Chaquisnincutataj raqhu c'aspi jusc'usman churaraspa jap'iracherka. ");
INSERT INTO quhNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Chaupi tutatajina Pablowan Silaswanka Diosmanta mañacuspa payta yupaychaspataj taquisharkancu. Chaypi wisk'aska runaspis uyarisharkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ajinapi ujllata jallp'aka mayta qharcatiterka. Carcelpa cimientosninpis cuyurerkancu. Chay quiquinpacha carcelpa tucuy puncusninpis quicharicaporkancu. Wisk'aska runaspata tucuy cadena watanasnincupis phascaracaporkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Carcelta khawaj runari puñuymanta rijch'arispa carcel puncusta quichariskata ricorka. Payka wisk'aska runas aykecapuskancuta yuyarka. Chayraycu jatun cuchillonta siq'ispa wañuchicunayasharkaña. ");
INSERT INTO quhNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pablorí sinch'ita khaparispa nerka: —Ama imanacuychu. Tucuyniycu caypi cashaycu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Carcelta khawaj runataj c'anchata mañacuspa carcel wasiman uskhayta yaycorka. Qharcatitispataj Pabloman Silasmanwan konkoricorka. ");
INSERT INTO quhNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Paycunata jawaman pusarkamuspataj nerka: —Wirakochis, juchamanta cachariska canaypaj ¿imatataj ruwanay tiyanrí? ");
INSERT INTO quhNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Paycunataj cuticherkancu: —Señor Jesucristopi jap'icuy. Chaywanka kanpis wasiyquipi tiyacojcunapis ajinata jap'icuspa juchamanta cachariskas canquichej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ajinatataj paycunaka sumaj willanasta Jesusmanta willararkancu payman tucuy wasinpi tiyacojcunamanpis. ");
INSERT INTO quhNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Carcelta khawaj runaka Pablotawan Silastawan chay chaupi tutapacha jamperka nanachicuskasnincuta. Chay quiquinpachataj payka tucuy wasinpi tiyacojcunawan bautizacorkancu Jesuspi jap'icuspa. ");
INSERT INTO quhNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Chaymantataj Pablota Silastawan wasinman pusaspa miqhunata jaywarka. Payka may cusiska casharka tucuy wasinpi tiyacojcunapis Diospi jap'icuskancuraycu. ");
INSERT INTO quhNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","P'unchayamojtinña llajta camachej curajcunaka yanapajcunancuta khawajcunaman cachamorkancu. Nichimorkancutaj: “Chay runasta cacharipuychej”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ajinataj carcelta khawaj runaka chay niskancuta Pabloman willarka: —Camachejcuna camachimuncu cachariska canayquichejta. Chayraycu cunanka allillanta ripuychej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pablorí paycunata nerka: —Roma llajtayoj runas cashajtiycu tucuy runas ricushajtincu jasut'ichiwarkaycu. Chaywanpis ajinata ruwawarkaycu mana juchachaskasllata. Ajinaspataj carcelman wijch'uycuwarkaycu. Cunanrí ¿pacayllamantachu cacharipuyta munawaskaycu? Mana ajinachu canka. Manachayrí paycuna quiquincu jamuspa runaspa ñaupakencupi orkhowachuycu carcelmanta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Yanapajcunaka chayta willarkancu camachejcunaman. Camachejcunari Roma llajtayoj runas caskancuta yachaspa mayta manchachicorkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Paycunari carcelman jamuspa Pabloman Silasmanwan niricusharkancu: —Pantarkaycu, perdonariwaycu, —nispa. Paycunata cacharipuspataj nerkancu: —Cay llajtamanta ripullaychej, ari, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Carcelmanta llojsispataj Lidiaj wasinman yaycorkancu. Chaypiri Cristopi hermanosta tantaskata ricorkancu. Chayraycu Cristopi sumajta jap'icunancupaj hermanosta callpacharkancu. Ajinaspataj riporkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pablowan Silaswanka Anfípolis llajtanejta Apolonia llajtanejtawan rispa Tesalónica llajtaman chayarkancu. Chaypi Diospa ajllaskan israelcunaj tantacuna-wasincu carka. ");
INSERT INTO quhNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pablori tantacuna-wasiman yaycullajpuni, ajinata chaypipis yaycorka. Chanta payka quinsa samacuna p'unchaycunata Diospa palabranmanta yachacherka sumajta parlanacuspa. ");
INSERT INTO quhNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Payka sut'ita willararka. Ricucherkataj Diospa ajllaskan muchunanpuni caskanta, wañuymantapis causarimunanpunitaj caskanta. Nerka: —Chay Jesuska Diospa ajllaskan Cristo caskanta kancunaman willashayquichej, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Israelmanta cajcuna Jesucristopi waquin jap'icorkancu. Ajinapi Pabloman Silasman c'ascacorkancu. May ashqhas, Diosta yupaychaj griego runaspis sumajpaj khawaska warmispis paycunaman c'ascacorkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Jesucristopi mana jap'icoj israelcunarí paycunawan phiñacuspa chhokanacorkancu. Chayraycu runa tantacunasmanta sajra runasta tantaycorkancu. Chay ashqha runaswantaj llajtata ch'ajwacherkancu. Pablotawan Silastawan masc'aspa Jasonpa wasinman callpawan yaycuycorkancu. Ajinaspa llajtapi runaspa tantacuynincuman pusayta munarkancu juchachanancupaj. ");
INSERT INTO quhNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Chay runasri paycunata mana chay wasipi tarerkancuchu. Chayraycu Jasontawan waquin hermanostawan llajta camachejcunaman khataterkancu. Sinch'ita khaparispataj nerkancu: —Cay runasmin tucuynejpi ch'ajwachincu, caymanpis chayaramullancutaj. ");
INSERT INTO quhNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Paycunata Jasonka wajyacorka. Tucuy paycunajtaka waj camachejnincu tiyan Jesús sutiyoj, nincu. Chaywanka romano camachiwajninchejpa camachiskasninta mana casuncuchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Chay imasta uyarejcunatawan llajta camachejcunatawan sinch'ita ch'ajwacherkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Jasonmanta Cristopi jap'icojcunamantawan kolketa orkhorkancu cacharipunancupaj. Kojtincutaj paycunata cachariporkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Hermanosrí chay tutapacha Pablotawan Silastawanka Berea llajtaman cachaporkancu. Ajinataj Pablowan Silaswanka Bereaman chayaytawancama Diospa ajllaskan israelcunaj tantacuna-wasincuman rerkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Tesalónica llajtapi tiyacojcunamantaka Bereapi tiyacojcuna astawan c'acha runas carkancu. Paycunaka tucuy sonkowan Diospa palabranta jap'icorkancu. Sapa p'unchaytaj Diospa palabranta sumajta khawasharkancu yachanancupaj Pabloj parlaskan Diospa niskanmanjinachus caskanta. ");
INSERT INTO quhNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Chayraycu paycunamanta ashqhas Diospi jap'icorkancu, griego parlaj rejsiska warmis, ashqha griego kharispis. ");
INSERT INTO quhNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Tesalonicamanta israelcunarí yacharkancu Pablo Berea llajtapipis Diospa niskanta willashaskanta. Chayraycu Berea llajtaman runasta ch'ajwachinancupaj okharej jamullarkancutaj. ");
INSERT INTO quhNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Hermanos chay quiquinpacha Pablota waquin hermanostawan jatun kocha cantoman cacharkancu. Chay Berea llajtapiri Silaswan Timoteowan khepacorkancuraj. ");
INSERT INTO quhNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pablota pusajcunaka Atenas llajtacama payta pusarkancu. Pablotaj pusajcunaman nerka: —Niychej, Silasman Timoteoman uskhayllata jamunawancuta, —nispa. Chanta Berea llajtaman cuterkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pabloka Atenas llajtapi Silastawan Timoteotawan suyasharka. Suyashaspataj Pablo sonkonpi mayta phuticorka chay llajta runas ruwaska dioscunata yupaychayman koska caskancuraycu. ");
INSERT INTO quhNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ajinapi payka tantacuna-wasipi israel-masisninpiwan Diosta casoj waj runaspiwan parlanacuspa yuyaycharasharka. Khatupipis sapa p'unchay parlasharka runasta taripaskanmanjina. ");
INSERT INTO quhNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Chaypi carkancu waquin yachayniyoj epicureocunamanta estoicocunamantawan. Paycuna Pablowan tapunaycucorkancu. Waquintaj nisharkancu: —Cay thautej runari ¿imatataj niyta munanrí? Ujcunataj nisharkancu: —Waj dioscunamanta willarajman rijch'acun. Chayta nerkancu Jesusmanta causarimuyninmantawan willaraskanraycu. ");
INSERT INTO quhNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ajinataj Pablotaka wajyaspa Marte niska loma pataman pusarkancu. Chaypi yachayniyoj runacuna yachachej cancu. Pablotataj nerkancu: —Cay mosoj yachachinasta parlaskayquimanta yachayta munaycu. ");
INSERT INTO quhNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Mana uyariskaycu parlaycunata kanmanta uyarishaycu. Chayraycu yachayta munaycu ima ninayanchus chay parlaskayqueka, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ajinataj tucuy Atenas llajtayojcuna caru llajtasmanta chaypi tiyacojcunapis mosoj cajllaman churacoj cancu. Tuta p'unchay churacoj cancu mosoj cajta uyariyman chayrí willaymanpis. ");
INSERT INTO quhNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Chanta Pabloka Marte niska lomapi runas tantacuynincoj chaupinpi sayaricorka. Nerkataj: —Atenas llajtayoj runas, reparani kancunaka ashqha dioscunata may yupaychajcuna caskayquichejta. ");
INSERT INTO quhNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Imaraycuchus llajtayquichejpi purishaspa yupaychanasniyquichejta khawarerkani. Ricullarkanitaj uj yupaychana lugartapis. Chay patapiri kolkaska carka: “Mana rejsiska Diosta yupaychanapaj”. Chay kelkachiskayquichejraycu cheka Diosmanta nokaka willashayquichej. ");
INSERT INTO quhNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","‘Willashayquichej chay tucuy atiyniyoj Señor Diosmin ruwarka cay pachata, cay pachapi caj imastapis. Payka janaj pachapipis cay jallp'apipis Camachej Diosmin. Chayraycu mana runaj ruwaskan yupaychana-wasillapichu tiyacun. ");
INSERT INTO quhNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Nitaj runa yanaparinanta pay necesitanchu uj imatapis pisichicushanmanjinaka. Imaraycuchus paymin tucuyman causayta samaytawan kon, tucuy imatapis. ");
INSERT INTO quhNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","‘Dioska uj runata ruwarka. Chay runallamantataj tucuy ayllus riqhurimorkancu. Chaymantataj tucuy cay pachapi tiyacunancupaj churarka. Manaraj paycunata ruwashaspataj yuyaskanmanjina ima p'unchaycunatachus, maypichus tiyacunancutapis camacherka. ");
INSERT INTO quhNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Chayta Dios churarka runas payta masc'anancupaj. Chayta ruwarka ichá imaynallamantapis reparaspa payta tarinancupaj. Payrí sapa ujninchejpa kayllanchejpipis cashanpuni. ");
INSERT INTO quhNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Payraycumin causashanchej, purishanchej, runaspis canchej. Waquin wayñuta ruwajcunayquichej chayjinata nerkancu: “Nokanchejpis Diospa wawasnin canchej pay ruwawaskanchejraycu”, nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Paypa ruwaskasnin caspaka mana yuyananchejchu Dios korijinaman kolkejinaman rumijinaman rijch'acuskantaka. Nitaj runaj yuyayninmanjina uj c'achitu ruwaskalla caskantapis. ");
INSERT INTO quhNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Unay runas Diosmanta mana yachashajtincupis pay yuyarka mana jasut'inanta ruwaskancumanjinaka. Cunanrí tucuy runasta tucuynejpi camachin juchancuta sakespa payman cutiricapunancuta. ");
INSERT INTO quhNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Imaraycuchus Dioska uj p'unchaytamin churan. Chay p'unchaypi tucuy runasta khawanka ruwaskancuta ninanpaj juchayojchus manachus caskancuta. Chayta chekanta ruwanka paypa ajllaskan Jesucristonejta. Dios tucuyman sut'ita ricucherka Jesús ajllaskan caskanta payta causarichimuspa, —nispa nerka Pablo. ");
INSERT INTO quhNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Wañuskacuna causarimuskancuta uyariytawan waquenka asicorkancu. Waquintaj nerkancu: —Chay causarimuymantaka ujllapiwanña uyarisajcu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Chayraycu Pabloka chaupincumanta llojsiporka. ");
INSERT INTO quhNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Waquinrí payman ujchacapuspa Jesucristopi jap'icorkancu. Chay jap'icojcunamanta carkancu chay llajtapi uj curaj runa Dionisio, Dámaris sutiyoj warmipis, waj runaspiwan. ");
INSERT INTO quhNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Chaymanta Pablo Atenas llajtamanta llojsispa Corinto llajtaman rerka. ");
INSERT INTO quhNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Chaypitaj payka uj israel runa Aquilawan tincorka. Aquilaka Ponto llajtapi naceska carka. Warmin Priscilawan chay p'unchaycunallapi Italiamanta chayamorkancu. Imaraycuchus llajtancumanta camachej Claudio tucuy israelcuna ripunancuta camacherka. Pablotaj paycunata watoj rerka. ");
INSERT INTO quhNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Paycunawan tiyacorka toldos ruwaj-masincu caskanraycu. Paycunaka cusca llanc'arkancu toldosta ruwaspa chaywan causanancupaj. ");
INSERT INTO quhNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Pablotaj tantacuna-wasipi sapa samacuna p'unchaypi allinta yuyaycharka. Ajinapitaj niskasnin cheka caskanta reparacherka israelcunaman wajcunamanpis. ");
INSERT INTO quhNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silaswan Timoteowan Macedoniamanta Corinto llajtaman jamorkancu. Chayaytawan Pabloka tucuy sonkowan israelcunaman willarka tuta p'unchay. Jesuska Diospa ajllaskan Cristo caskanta sut'ita willararka. ");
INSERT INTO quhNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Chay israelcunarí Pabloj contranpi jatarerkancu sajrata rimaspa. Chayraycu Pabloka p'achasninta thalacorka paycunata sakerparinanta ricuchinanpaj. Nerkataj: —Kancuna wiñay wañuyman wijch'uycuchicunquichej chayka, kancunallataj juchayoj canquichej. Kancunamanta mana juchayojchu casaj. Cunanmantapachataj risaj waj runasman willaranaypaj, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Chay tantacuna-wasimanta llojsispa Justo sutiyoj runaj wasinman riporka. Chay runaka Diosta casucoj carka. Paypa wasintaj tantacuna-wasej ladonpi carka. ");
INSERT INTO quhNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Tantacuna-wasimanta curaj runa Crispopis Señor Jesuspi jap'icorka, tucuy wasinpi tiyacojcunapis. Corinto llajtayoj runaspis sumaj willanasta uyarispa ashqhas Jesucristopi jap'icorkancu. Jesucristojllata caskancuta ricuchinancupajtaj bautizacorkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Chaymantataj uj tuta moskoypijina Señor Jesús Pabloman nerka: —Ama manchachicuychu. Manachayrí ama ch'inyacuspa sumaj willanasta willarallaypuni. ");
INSERT INTO quhNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Chekatapuni noka kanwan cashani. Chayraycu ni pipis imanasonkachu. Astawanpis nokapi jap'icojcuna ashqhas cay llajtapi cankancu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ajinataj Pabloka chaypi uj wata cuscanniyojta tiyarka. Chaypi tiyacojcunamantaj Diospa palabranta yachachisharka. ");
INSERT INTO quhNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Galión Acaya jallp'ata camachishajtin israelcuna uj yuyaylla Pabloj contranpi jatarerkancu. Chaymantataj llajta camachejman pusarkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Israelcunataj Pablota ch'atarkancu: —Cay runaka Diosta yupaychachinayashan manataj Moisés camachiwaskaycumanjinachu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pablo parlarinan cashajtintaj Galionka israelcunaman nerka: —Tatacuna, uyariwaychej. Runas ima mana allinta ruwasojtiyquichej chayrí jatun juchachaycuy cajtinpis sumajta kancunata uyariyquichejman. ");
INSERT INTO quhNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Cay rimanacuyka jawa niskasllamanta camachiskasniyquichejmantawan cancu. Chayraycu kancunalla caytaka khawamuychej. Nokaka caycunamanta ni imata nisajchu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Chanta ñaupakenmanta Pablota paywan cajcunatawan kharkochimorka. ");
INSERT INTO quhNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Tucuy runastaj tantacuna-wasimanta curaj runa Sostenesta jap'iycorkancu. Ajinaspataj camachej Galionpa ñaupakenpi makaycorkancu. Paymanrí ni imapis kocorkachu. ");
INSERT INTO quhNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pabloka ashqha p'unchaycunatawanraj Corinto llajtapi khepacorka. Chanta hermanosmanta cacharpayacuspataj Siria jallp'aman jatun barcopi rerka. Paywan cusca rerkancu Aquila Priscilapiwan, khari warmi. Cencrea llajtapi cashasparí Pabloka chujchanta k'alata c'utuchicorka Diosman palabranwan niskanta junt'ananpaj. ");
INSERT INTO quhNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Efeso llajtaman chayaspa Pabloka Priscilata Aquilatawan chaypi sakerka. Payrí tantacuna-wasiman rispa israelcunawan parlanacuspa sut'ita yuyaycharka. ");
INSERT INTO quhNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Paycunamanta waquintaj mayta mañarkancu astawanraj khepacunanta. Payri: “Mana khepacuymanpunichu”, nerka. ");
INSERT INTO quhNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Paycunawan cacharpayanacushaspa nerka: —Dios munajtenka kancunaman cutimuskayquichej, —nispa. Chaymantataj Pabloka barcopi Efeso llajtamanta riporka, ");
INSERT INTO quhNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Cesarea llajtamantaj chayarka. Chaymanta Jerusalenman rispataj chaypi Cristopi jap'icuspa tantacojcunata napaycamorka. Ajinaspataj Antioquiaman jamporka. ");
INSERT INTO quhNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Chaypi uj p'unchaycunata tiyacorka. Chaymantataj Galacia jallp'anejta Frigianejtawan purerka. Puriskanpitaj Jesuscristopi tucuy jap'icojcunata yachachispa sonkoncupi callpacharka. ");
INSERT INTO quhNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Chay p'unchaycunapitaj uj israel runa, Apolos sutiyoj, Efeso llajtaman chayamorka. Payka Alejandría llajtapi naceska carka. Diospa unay palabranmantataj paypa ñanninpi purinanpaj sumaj yachachiska carka, cosata parlajtaj. ");
INSERT INTO quhNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Jesusmantataj tucuy sonkowan parlaspa sut'ita yachachej carka. Payrí runas juchasnincuta sakeskancuta ricuchinancupaj, chay Juanpa yacupi bautizacuynillanmanta yacharka. ");
INSERT INTO quhNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apoloska tantacuna-wasipi mana manchachicuspa kallarerka Jesusmanta parlayta. Priscila Aquilawantaj chayta uyarerkancu. Chayraycu payta wasincuman pusaspa paywan sumajta parlarkancu. Aswan sut'ita yachacherkancu imaynata runa causanan Diospa ñanninpi purinanpaj. ");
INSERT INTO quhNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Acaya jallp'aman Apolos riyta munashaskanpitaj hermanos payta Cristopi callpacharkancu. Paycunataj uj cartata kelkarkancu Acaya hermanosman Apolosta sumaj sonkowan wajyanancupaj. Ajinataj payka chayman chayarka. Chaypipis runas Jesuspi jap'icorkancu Dios paycunata qhuyaskanraycu. Chay jap'icojcunata Apoloska sumajta yanaparka. ");
INSERT INTO quhNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Chekatapuni tucuypa ñaupakenpi Diospa ajllaskan israelcuna pantaska caskancuta sumaj yuyaywan ricucherka. Kelkaskasmanta paycunata sumajta yuyaricherka Dios ajllaskanta Jesusta camachinanpaj. ");
INSERT INTO quhNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apoloska Corinto llajtapi casharka. Chaycamataj Pabloka chay pata caj jallp'asninta purimuspaña Efeso llajtaman chayamorka. Chaypitaj payka Jesuspi waquin jap'icojcunawan tincorka. ");
INSERT INTO quhNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ajinaspataj payka paycunata tapurerka: —Jesucristopi jap'icushaspa ¿Santo Espirituta jap'icorkanquichejchu? Paycunataj cuticherkancu: —Santo Espíritu caskanta ni uyarillarkaycupischu, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Paytaj tapurerka: —¿Imatataj yachachisorkachej Diosman t'akacuspa bautizacushajtiyquichejrí? Paycunataj cuticherkancu: —Bautizacunaycupajka Juan yachacherka, ajinallatataj yachacorkaycu juchasniycuta sakenaycuta, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pablotaj nerka: —Juanka runasta bautizarka yacupi ricuchinanpaj paycuna juchasnincuta sakespa Diosman cutiricuskancuta. Juantaj runasta unaytaña nerka: “Khepayta uj runa jamushan, paypi jap'icunayquichej tiyan. Payka Diospa ajllaskan Jesucristomin”, —nispa. ");
INSERT INTO quhNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Chay jap'icojcunaka uyariytawan bautizacorkancu Señor Jesús tucuy atiyniyoj caskanta jap'icuspa. ");
INSERT INTO quhNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pablo maquisninta paycunaman churajtintaj Santo Espiritoka sonkoncuman uraycamorka. Paycunataj waj parlaycunata parlarkancu. Diosmanta willanastapis willararkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Paycunari tucuynincu chunca iscayniyojjina kharis carkancu. ");
INSERT INTO quhNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pabloka tantacuna-wasiman rispa mana manchachicuspa sut'ita parlarka entiendenancucama. Dios camachinantaka chekapuni caskanta yachacherka quinsa quilla junt'ata. ");
INSERT INTO quhNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Waquin runasrí rumi sonkos ruwacaporkancu. Ajinapitaj Diospi mana jap'icorkancuchu. Astawanpis tucuypa ñaupakencupi sajrata parlarkancu Diospa cheka ñanninpi purinanpaj, chay yachachinasmanta. Chayraycu Pabloka paycunamanta t'akacaporka. Cristopi jap'icojcunatapis wajnejman pusarka tantacunancupaj. Chaypitaj sut'ita yachacherka sapa p'unchay Tiranno sutiyojpa yachachina wasinpi. ");
INSERT INTO quhNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ajinata Asia jallp'api Pablo yachacherka iscay wata junt'ata. Chaypi tucuy tiyacojcunataj Señor Jesuspa niskanmanta uyarerkancu israelcunapis waj llajtayojcunapis. ");
INSERT INTO quhNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Diostaj Pabloman atiyta korka jatuchej t'ucunasta ruwananpaj. ");
INSERT INTO quhNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ajinapi Pabloj cuerponmanta pañuelosta chayrí uj juch'uy p'achallatapis apaj cancu onkoskasman churanancupaj. Diospa atiyninwanka chay onkoyniyojcuna thañicapoj, supaycunapis runasmanta llojsillajtaj cancu. ");
INSERT INTO quhNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Waquin purisquiri israelcunarí supaycunata kharkollajtaj cancu. Ajinapi Jesuspa sutinta okharispa yuyaskancumanjina supaycunata nerkancu: —Pablo willarashan, chay Jesuspa sutinpi, noka cam