﻿USE sofia;
DROP TABLE IF EXISTS sofia.qufNT_vpl;
CREATE TABLE qufNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES qufNT_vpl WRITE;
INSERT INTO qufNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Abrahampa, Davidpa ayllunmantami Dyuspa Akrashan Cristun Jesusqa karan. Chaymi kaypi rikachimanchik tukuynin unay rukunkunapaq, mayqankunami karan nirmapis. Kaynumi kaq: ");
INSERT INTO qufNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahammi Isaacpa taytan karan. Isaac-shuypaqa Jacobupa taytan karan. Nataq Jacobuqa Judapa, chaynulla ukninkunapa taytan karan. ");
INSERT INTO qufNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judaqa, Farespa chaynulla Zarapa taytan karan. Nataq maman-shuypaqami Tamar karan. Faresqa Esrompa taytan karan. Esrom-shuypaqa Arampa taytan karan. ");
INSERT INTO qufNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramqa Aminadabpa taytan karan. Aminadabqa Naasonpa taytan karan. Naasón-shuypaqa Salmonpa taytan karan. ");
INSERT INTO qufNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmonqa Boozpa taytan karan. Boozpa maman-shuypaqa Rahab karan. Boozqa Obedpa taytan karan. Nataq Obedpa mamanqa karan Rut. Obedqa Isaipa taytan karan. ");
INSERT INTO qufNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí-shuypaqa mantakuq Davidpa taytan karan. Davidqa Salomonpa taytan karan. Salomonpa mamanqami wanuq Uriaspa warmin kasha karanpis. ");
INSERT INTO qufNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomonqa Roboampa taytan karan. Roboamqa Abiaspa taytan karan. Nataq Abiasqa Asapa taytan karan. ");
INSERT INTO qufNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaqa Josafatpa taytan karan. Josafatqa Jorampa taytan karan. Joramqa Uziaspa taytan karan. ");
INSERT INTO qufNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziasqa Jotampa taytan karan. Jotamqa Acazpa taytan karan. Acazqa Ezequiaspa taytan karan. ");
INSERT INTO qufNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequiasqa Manasespa taytan karan. Manasesqa Amonpa taytan karan. Amonqa Josiaspa taytan karan. ");
INSERT INTO qufNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Nataq Israelmanta kaqkunata Babiloniamanta runakuna prisur apayan chay tyimpuqa Josiasqa Jeconiaspa, chaynulla ukninkunapa taytan karan. ");
INSERT INTO qufNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Chaymanta chaynu chay Babiloniaman prisur apayan chay tyimpu pasatinnaqa, Jeconias Salatielpa taytan karan. Salatielqa Zorobabelpa taytan karan. ");
INSERT INTO qufNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabelqa Abiudpa taytan karan. Abiudqa Eliaquimpa taytan karan. Eliaquimqa Azorpa taytan karan. ");
INSERT INTO qufNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azorqa Sadocpa taytan karan. Sadocqa Aquimpa taytan karan. Aquimqa Eliudpa taytan karan. ");
INSERT INTO qufNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudqa Eleazarpa taytan karan. Eleazarqa Matanpa taytan karan. Matanqa Jacobupa taytan karan. ");
INSERT INTO qufNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobuqa Josipa taytan karan. Josiqami Mariapa runan karan. Kay Mariamantami Jesusqa nasiran. Jesustaqa, kanan nuqanchikkunaqa riqsinchikllapa Dyuspa Akrashan Cristun nir. ");
INSERT INTO qufNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abrahammanta-pachami paynin paynin kriyakaranllapa taytanmanta uk wamran, qashan chay wamranmanta uk wamran ima. Chaynumi katursi rukunllapakuna karan Davidkamanqa. Davidmanta-pacha chay Israelmanta kaqkunata Babiloniamanta runakuna prisu apashankaman, qashan karan uk katursi. Chaymanta-pachami qashan karan uk katursi Dyuspa Akrashan Cristun nasishankamanqa. ");
INSERT INTO qufNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kaynumi Dyuspa Akrashan Cristun Jesusqa nasiran. Maman Mariaqami Josiwan parlashana karan kasarananllapapaq. Piru manaraq pulla punusha ima katinmi, Mariaqa ruriyjun rikariran Santu Ispiritupa pudirninrayku. ");
INSERT INTO qufNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Chay runan Josiqami kusa allinla kar, Mariata ima pasashanpaq mana mayqanpis yaĉhananllapataqa munaranchu. Chaymi ashwan uyarala Mariamantaqa chiqanchakayta yarpuran. ");
INSERT INTO qufNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Chaynu chiqanchakananpaq yarpusha katinmi, Dyuspa uk angelnin musquyninpi rikarir niran: “Davidpa ayllun José, ama manchakurchu Mariawanqa kasaray. Chaqa payqami Santu Ispiritupa pudirninrayku wamrakustuyanmapis. ");
INSERT INTO qufNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Piru chay wamritu nasikutinqami shutichinki Jesús. Chaqa payqami chaynuqa shutiyan Dyuspa kaqninkunata uchanmanta washananpaq kashanrayku”. ");
INSERT INTO qufNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Piru tukuy kaykunaqami pasaran Dyusninchik paypa rimaqninkunata intrachitin nishankuna kumplikananpaq. Chaqa kaynumi nisha kayaq: ");
INSERT INTO qufNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Manaraq runawan punusha uk warmisitami ruriyjun rikarinqa. Chaymanta wamrakurqami wamrituntaqa shutichinqa Emanuel”. Emanuel nirqami intrachimayanchik: “Dyusninchikmi nuqanchikkunawan” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Chaymanta José punuyashanmanta rikĉhakurqa, Dyusninchikpa angelnin willashanta ruraran. Chaymi ashwan Mariawanqa kasararanna. ");
INSERT INTO qufNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Piru chaynu kasarashana karmapismi Josiqa Mariawan mana pullaqa punuranchu chay punta wamritunllapa nasinankaman. Chaymantami Mariaqa wamrakusturanna. Chaymi Josiqa wamritutaqa shutichiran Jesús. ");
INSERT INTO qufNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesucristuqami Judea lugarpi uk pwiblitu Belén shutiqpi nasiran. Chay tyimpupiqami Herodes gubyirnuqa karan Israel pwiblukunapiqa. Chaymantami kusala yaĉhaq runakuna ĉharanllapa Jerusalenmanqa rupay iqamunanlawmanta. Paykunami qullarkunata rikar riqsiq runakuna kaqllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Chaymi kaynu nir tapukuranllapa: “¿Maypitaq chay Israel runakunapa gubyirnun nasisha chayqa? Chaqa chay rupay iqamunanlawpimi rikasha kanillapa uk qullar paypaq intrachimaqllapata. Chaymi shamusha kanillapa payta aduraq”. ");
INSERT INTO qufNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Chaynu nitinllapa uyaparmi chay gubyirnu Herodes chaynulla tukuyla Jerusalén pwiblupi taqkunapis kusalata manchakur yarpupakuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Chaymi chay gubyirnuqa niran tantakamunanllapapaq tukuy chay kurakunapa mantakuqninkuna, Moisés mantakushanta yaĉhar yaĉhachikuqkuna ima. Chaymantaqa tapuran: —¿May lugarpitaq Dyuspa Akrashan Cristunqa nasiyanqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Chaymi paykunaqa niranllapa: —Judea lugarpa pwiblun Belenpi. Chaqa Dyuspa rimaqninmi kaynu niq Belén pwiblupaqqa: ");
INSERT INTO qufNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Belén pwiblu, qammi chay Judea lugarpiqa, takshala pwiblitu kasha karmapis, kananqa kusala mas riqsikashana kanki chay Judea lugarpi wakin pwiblukunamantaqa. Chaqa qammantami uk mantakuq rikarinqa. Chaymi payna kusala shumaqta kuytanqa chay Israel pwibluytaqa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Chaynu nitinllapaqa, Herodesqa mana mayqanpis yaĉhatinchu, qayamuran chay uklawmanta kusa yaĉhaq runakunata. Chaymi paykunarayku yaĉharanna ima tyimpupimi chay qullar rikariran nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Chaymantami chay runakunataqa kaĉharan Belén pwibluman kaynu nir: —Wakman rir puytishaykillapata tapukuyllapa chay wamritupaqqa. Chaymanta tarir-shuypaqa willamankillapa, nuqapis rir aduranaypaq nir. ");
INSERT INTO qufNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Chaynu gubyirnu willatinllapami, chay kusa yaĉhaq runakunaqa riranllapa. Piru chay qullar rupay iqamunanlawpi rikashanllapaqa, naypanllapata riq ĉhurakaran. Chaynu rirmi chay maypiĉhi wamritu karan chaylapi qasillaran. ");
INSERT INTO qufNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Chaynu qullar qasillaqta rikarmi, kusalata aligriyaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Chaymantami chay wasiman yaykur, rikaranllapa chay wamrituta chaynulla maman Mariata ima. Chaynami paykunaqa qunqurikur aduraranllapa. Chaynulla talqitanllapata kiĉhar, uruta, insinsyuta, mutkiypaqla mirrata ima quranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Chaymanta punutinllapami Dyusqa musquyninllapapi willaran Herodes kayashanman ama tikrakananllapapaqchu nir. Chaymi paykunaqa Dyus nishanta kasur pwiblunllapamanqa riran uklaw nantana. ");
INSERT INTO qufNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Chaynu chay kusa yaĉhaq runakuna rishana katinqa, Josipa musquyninpi Dyuspa uk angelnin rikarir kaynu niran: “Sharir, wamrituta mamantinta apar utqar riy Egipto pwibluman. Chaypi kidankillapa nuqa willashunayllapakaman. Chaqa Herodesmi wamrata maskanqa wanuchinanpaq” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Chaymi chaynu nitinqa Josiqa sharir, wamrituta mamantinta apar, chay tutalla riq ĉhurakaranllapa Egiptuman nan riqta. ");
INSERT INTO qufNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Chaymi chaypiqa taranllapa Herodes wanunankaman. Chaynuqami pasaran Dyuspa rimaqnin unay nishan kumplikananpaq. Chaqa nishami kayaq: “Egipto pwiblumantami qayamuray wamrayta” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Chaymantami Herodesqa chay kusa yaĉhaq runakunaqa ingañamasha nir kwintata qukarqa, kusalata piñakuran. Chaymi mantakuran tukuyla ullqu wamritukuna ishkay añuyjun, chaynulla manaraq ishkay añuyjun kaqkunata ima wanuchinanllapapaq tukuyla Belén pwiblumanta kaqkunataqa. Chaynuqami kaĉhakuran chay kusa yaĉhaq runakuna ima tyimpupimi Dyuspa qullarnin rikarisha karan nir willashanmanta yaĉhar. ");
INSERT INTO qufNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Chaynuqami pasaran Dyuspa rimaqnin Jeremías iskribishannu kumplikananpaq. Chaqa niqmi: ");
INSERT INTO qufNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramá pwiblumantami kusala llakiyta, kusala waqayta ima uyapakaran. Chaynuqami waqayaran Raquel, wamrankunapaq. Chaymi mana kunsulakaymatapis munaranchu, tukuynin wanushana kashanrayku” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Piru Herodesqami wanuranna. Chaymi ashwan Dyuspa uk angelnin, José Egiptullapi katin, musquyninpi payman rikarir kaynu niran: ");
INSERT INTO qufNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Sharir, wamrituta mamantinta apar, qashan riyllapa Israel pwibluman. Chaqa chay wamrituta wanuchinaqkunaqami wanushallapana” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Chaymi Josiqa sharir wamrata mamantinta apar riran Israel pwibluman. ");
INSERT INTO qufNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Piru Josiqami yaĉharan chay Judea lugarpiqa Herodespa lugarninqa wamran Arquelao mantakuyan nir. Chaymi kusalata manchakuran chay Judea lugarllaman tikrakaytaqa. Piru Tayta Dyusmi musquyninpi Jositaqa intrachiran Judea lugarman ama rirchu, ashwan Galilea lugarmanna rinanpaq nir. ");
INSERT INTO qufNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Chaymi chayman rir ĉharqa, riran taq Nazaret pwiblumanna. Tukuy kayqami pasaran Dyuspa unay rimaqninkuna kaynu nishan kumplikananpaq. Chaqa Jesuspaqmi nisha kayaq: “Payqami nazareno shutinqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Chaymanta uk tyimpu pasatinmi Shutichikuq Juan rikariran chay Judea lugarpa chunllaqlla lugarninkunapi. ");
INSERT INTO qufNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Paymi yaĉhachikuq qallariran kaynu nir: “Uchaykillapata dijar Dyusmanna tikrakayllapa. Chaqa syilumanta kaq mantakuq qallarinanpaqqami shipchamunna” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Kay Juanpaqmi Dyuspa unay rimaqnin Isaías iskribisha kayaq kaynu nirqa: “Uk runami kusa jwirtita rimar chunllaqpi nin: ‘Amitunchikpa nanninta kamakachiyllapa uchaykillapata dijar, Dyusta kasurllapana. Chaynuqami kusa dirichula nanta kiĉhaq yupayna kankillapa kanqa’ nir”. ");
INSERT INTO qufNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Kay Juanpa raĉhpanqami rurakasha karan kamillupa millwanmanta. Nataq sinchun-shuypaqami qaramanta karan. Payqami mikuq atun shurkukunata, chumpakapa mishkinta ima. ");
INSERT INTO qufNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Piru pay yaĉhachikutin uyakuqqa achka runakuna riqllapa Jerusalén pwiblumanta, Judea lugarmanta, chaynulla chay riyu Jordanpa shipchankunamanta ima. ");
INSERT INTO qufNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Chaymi Juan yaĉhachikutin uyakurqa uchanllapapaq kwintata qukar, Tayta Dyus llakipamayllapa nitin, Shutichikuq Juanqa chay riyu Jordanpi shutichiran. ");
INSERT INTO qufNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Chaymantami Juanqa, achka fariseo, saduceo runakuna, pay shutichinanpaq ĉhaqta rikarqa niran: “¡Largu kurukunapa ayllunkuna! ¿Pitaq qamkunata nishushallapa: ‘Shutikurla chay kusala saqra manchaypaq kastigu Dyusmanta shipchamuyanna chaymanta washakayankillapa kanqa’ nirqa? ");
INSERT INTO qufNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Chaymi ashwan kriyishaykillaparayku kusala shumaqta kawsar Dyuspi kriyinkillapa nir uk qiru puquq yupay intrachikuyllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Imanupiqakish yarpuyatkillapa, Abrahampa ayllun kar washakayanchikllapa nir. ¡Manami chaynuchu! Chaqa allita nishaykillapa: Dyus munarqami, tukuy kay rumikunamatapis Abrahampa ayllunpaq tikranarqa tikranman. ");
INSERT INTO qufNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Achapismi listuna qirukunata ĉhupanmanta kuchunanpaqqa. Chaqa tukuy qiru mana allita puquqtaqa kuchur itanqa ninaman. ");
INSERT INTO qufNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Chiqaptami nishaykillapa: Dyuspi kriyir uchaykillapata dijashaykillaparaykuqa yakulawan nuqaqa shutichishunillapa. Piru nuqamanta kusala mas pudirniyjun shamuq chay-shuypaqami shutichishunqallapa Dyuspa Santu Ispiritunwan, ninawan ima. Chaymi nuqaqa paypaqqa mana sirbinichu llanqinta urqur apanaylapaqmapis. ");
INSERT INTO qufNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Chaqa payqami palanta charikusha shamuyan. Chaymi trigunta limpu shumaqchar ĉhurakunanpi ĉhurakunqa. Nataq pajanta-shuypaqami mana maydiyapis wanuq ninawan limpu rupachinqa”. ");
INSERT INTO qufNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Chaymantaqa Jesuspis Galileamanta riran riyu Jordanpi Juan shutichikuyashanman paytapis shutichinanpaq. ");
INSERT INTO qufNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Piru puntataqami Juanqa mana shutichinarchu kaynu niran: —Qammi shutichimanaykipaq kusala allinqa. ¿Ashwanchu nuqa shutichishunaypaq shamunki? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Chaynu nitinmapis Jesusqa niran: —Amami mana nirchu kananlla shutichimay. Chaqa chaynuqami Dyus tukuy munashanlata ruranapaq nimashanchiktaqa kumpliyashun nir. Chaynu nir, Juanta allinta yarpuchitinmi, ");
INSERT INTO qufNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","shutichiran Jesustaqa. Chaynu shutikur yakumanta yarqamuyatinlami syilu kiĉhakaran. Chaymi Jesusqa rikaran Dyuspa Santu Ispiritun payman uk palumitanu ishkimuqta. ");
INSERT INTO qufNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Chaymantami syilumanta-pacha, Dyus kaynu niqta uyaparan. ");
INSERT INTO qufNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Chaymantaqami Dyuspa Santu Ispiritunqa Jesusta aparan chunllaq lugarkunaman dyablu uchakuchiyta kamananpaq. ");
INSERT INTO qufNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jesusqami kwarinta unaq, kwarinta tutata ayunaran. Chaymantami mallaqnaran. ");
INSERT INTO qufNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Chaymi dyabluqa uchakuchiyta yarpur, Jesusman qimikar niran: —Chiqapta Dyuspa Wamran karqa, kay rumikunata willay tantakunapaq tikrakananpaq nir. ");
INSERT INTO qufNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Piru Jesusqa niran: —Dyus nitin iskribikashakunapimi nin: ‘Manami tantalamantachu runaqa kawsayta puytin. Ashwanmi Dyuspa shiminmanta tukuy rimaynin lluqshiqta kasur kawsanqa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Chaymantami dyabluqa Jesustaqa aparan Dyus akrashan pwiblu Jerusalenman. Chaypiqami Dyusta adurananllapa wasipa kusa unaqninman iqachir, ");
INSERT INTO qufNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","niran: —Chiqapta Dyuspa Wamran karqa, kaymanta uraman kaĉhakay. Chaqa Dyus nitin iskribikashakunapimi, nin: ‘Dyusshi, angelninkunata kaĉhamunqa kuytashunanpaq. Chaynulla aypashuyanqashi ĉhakikimapis ama ĉhachikananpaq ima rumikunalawanmapis’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Chaynu nitinmi, Jesusqa niran: —Dyus nitin iskribikashakunapimi ninpis: ‘Amami Amituyki Dyus nishanllata rurachir pukllaychu’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Chaymanta-shuypaqami dyabluqa aparan uk kusala unaq may atun sirkaman. Chaymantami kay pachapa tukuy pwiblunkunata iman kaqnintinta rikachir, ");
INSERT INTO qufNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","niran: —Qam qunqurir aduramatkiqami tukuy kay rikashaykikunata qushayki nir. ");
INSERT INTO qufNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesusqa niran: —¡Ashuy, dyablu! Chaqa Dyus nitin iskribikashakunapimi ninpis: ‘Adurar sirbiy Amituyki Dyuslata’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Chaynu nitinmi dyabluqa Jesusmantaqa ashuranna. Chayna chay kutilla, Dyuspa angelninkunana shamur ministishanpi yanaparan. ");
INSERT INTO qufNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Chaymanta Jesusqa yaĉharan Juanta karsilman itashallapa nir. Chaymi riran Galilea lugarlawman. ");
INSERT INTO qufNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Chaypimi Nazaret pwiblupi kayarqa, ashwan riran Capernaúm pwiblumanna taq. Chayqami karan chay quĉha qichqankuna Zabulonpa, chaynulla Neftalipa unay ayllunkunapa pachankuna kaq chay lugarkunapi. ");
INSERT INTO qufNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tukuy kaykunaqami pasaran Dyuspa rimaqnin Isaías iskribishan kumplikananpaq. Chaqa niqmi: ");
INSERT INTO qufNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zabulonpa, Neftalipa lugarninkunapi taqkuna, chaynulla mar yaku manyanpi, chay riyu Jordanpa qichqanpi taqkuna, ");
INSERT INTO qufNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","chay Galilea lugarpi mana kriyishanrayku tutaparaqpi yupay taqkuna rikaranllapa imanutaq rupaymaqa kusalata llipyaran chaynuta. Paykunaqami tutaparaqllapi kar wanunanpaqna katinmapis, imanumi Tayta Dyusqa paykunatapis washayta munan nir rikachiran”. ");
INSERT INTO qufNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Chaymi Capernaúm pwiblupi taq qallarishanmanta-pacha Jesusqa yaĉhachikuq qallariran kaynu nir: “Uchaykillapata dijar Dyusmanna tikrakayllapa. Chaqa syilumanta kaq mantakuq qallarinanpaqqami shipchamunna” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesusqami Galilea atun quĉhapa manyanta riyarqa, rikaran ishkay piskadukuq runakuna atun shikranllapata yakuman itaqta. Paykunaqami karan, Simón uknin Andreswan. Kay Simonmi Pedro shutiqpis. ");
INSERT INTO qufNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Chaymi Jesusqa niran: —Shamuyllapa nuqawanna rinallapapaq. Chaqa nuqaqami yaĉhachishaykillapa piskaduta aypaq yupayna runakunata nuqapaq yaĉhachir tantanaykillapapaq nir. ");
INSERT INTO qufNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Chaynu nitinqami, chay runakunaqa chay kutilla atun shikrankunata dijar, paywanna riranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Piru mas naypaqman riyarqami Jesusqa qashan rikaran ishkay runakunata. Paykunaqami Zebedeupa wamrankuna, Santiago, Juan ima karan. Chaymi paykunaqa taytanwan uk yaku karrunpi atun shikrankunata kamkachiyaranllapa. Chayna Jesusqa qayamuran paykunatapis. ");
INSERT INTO qufNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Chaymi, chay kutilla paykunapis yaku karrunta, taytanta ima chaypi dijar, Jesuswanna riranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Chaynumi Jesusqa Galileapa tukuy lugarninkunapi Israel runakuna tantakananllapa wasikunaman yaykur Dyuspa shumaq rimayninta yaĉhachikur puriran, washakarna paypa mantakuyninpi kawsananllapapaq. Chaynullami runakunata allicharan tukuy qishayninmanta, nanayninkunamanta ima. ");
INSERT INTO qufNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Chaymi Jesuspaqqa chay Siriapa tukuyla lugarninkunapi yaĉharanllapana. Chaynu yaĉharllapami, kusa riqchaq nanaywan, qishayninllapawan qischakaqkunata apamuranllapa. Chaynullami apamuranllapapis dyablupa yarpuyninwan kar qischakaqkunata, atakiwan kaqkunata, chaynulla chay mana kuyuyta puytiq kwirpuyjun kaqkunata ima. Piru Jesusqami tukuylata allicharan. ");
INSERT INTO qufNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Chaymi kusa achka runakuna Galileamanta, Decapolispa pwiblunkunamanta, Jerusalenmanta, Judeamanta, Jordanpa rupay iqamunanlaw lugarmanta ima, Jesusta kusata uyakuyta munar ikinpi puriqllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Chaynu achka runakunata rikarmi, Jesusqa sirkaman iqar taran. Chaymi chay yaĉhakuqninkunapis payman qimikatin, ");
INSERT INTO qufNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","kaynu nir yaĉhachikuq qallariran: ");
INSERT INTO qufNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Kusa shumaqmi kanqa, mayqanpis uchakushami kani nir masta Dyusninchikta maskaqkunaqa. Chaqa syilumanta kaq mantakuqwannami kanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kusa shumaqmi kanqa, waqaqkunaqa. Chaqa Dyusmi kunsulanqa llakishanmantaqa. ");
INSERT INTO qufNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kusa shumaqmi kanqa, chay mana kusa kani nir yarpuqkunaqa. Chaqa paykunami Dyus arnishan pachamatapis aypanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kusa shumaqmi kanqa, imuraspis Dyus munashanlata mallaqnaq, yakunaq yupay chiqap allinlata ruranaqkunaqa. Chaqa Dyusmi yanapanqa rurananpaq yarpuyashanllapataqa. ");
INSERT INTO qufNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kusa shumaqmi kanqa, chay mayqanpis ima katinpis llakipakuqqa. Chaqa Dyusmi paytapis llakipanqa. ");
INSERT INTO qufNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kusa shumaqmi kanqa, chay mayqanpis kusa allinla yarpuyniyjun kaqkunaqa. Chaqa paykunami Dyusta rikanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kusa shumaqmi kanqa, chay mayqanpis amana ĉhiqninakur kawsananllapapaq intrachikuqqa. Chaqa Dyusmi paykunatapis chiqap wamranpaqna riqsinqa. ");
INSERT INTO qufNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Kusa shumaqmi kanqa, chay mayqanpis Dyus munashannulla allinlata rurashanrayku qischakaqkunaqa. Chaqa syilumanta kaq mantakuqwannami kanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Kusa shumaqmi kankillapa nuqapi kriyishaykillaparayku runakuna qaryapar, riqchaq llullakunata willar ima qischashutinllapaqa. ");
INSERT INTO qufNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Chayraykumi ima katinpis kusalata aligriyar ima kuntintu kayllapa, unaq syilupi kusala shumaq imata aypanaykillapapaq nir yaĉhar. Chaqa imanutaq kanan qamkunapa ikikillapapi purir qischashuyanllapa, chaynumi Dyuspa unay rimaqninkunatapis ruraranllapa”. ");
INSERT INTO qufNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jesusqami niran: “Imanutaq kaĉhimaqa kusalata sirbin chaynu qamkunapis kankillapa kay pachapiqa. Piru imanupi kaĉhi lampaqyarqa mananami qashan shumaqchakayta puytinnachu. Chaynu mana sirbitinnaqami ashwan waqtaman itakushana puriqkuna saruĉhanllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Chaynullami imanutaq bilamaqa achkirachikun chaynu qamkunapis kankillapa kay pachapiqa. Chaqa uk pwiblu unaq sirkapi katinmaqa tukuylari rikanllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Chaynulla uk bilata kachkarqa manami kajunpa rurinmanchu ĉhuranchik achkirachikunanpaqqa. Ashwanmi ĉhuranchik unaqlapi, tukuy chay wasipi kaqkunata achkirachinanpaq. ");
INSERT INTO qufNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Chayraykumi qamkunapis imanutaq uk bilamaqa achkirachikun chaynu tukuylawan kusa allinla ima kayllapa. Chaynu allinlata rurar kawsatkillapaqami, tukuy rikashuqkuna imanumi kawsanllapa nir kwintata qukar, unaq syilupi Taytaykillapa Dyustana alabanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Amami qamkunaqa nuqapaq yarpunkillapachu, Moisés mantakushankunata, Dyuspa rimaqninkuna nishanta chinqachinanpaq shamusha kanqa nirqa. Chaqa manami chaykunata chinqachinaypaqchu shamusha kani. Ashwanmi tukuy chaykunataqa chiqapta kumplinaypaqna shamusha kani. ");
INSERT INTO qufNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nishaykillapa: Syiluwan pacha kayatinllaqami, Dyus mantakushanmantaqa manami uk puntituta, uk litralamatapis kitanqallapachu chay tukuy nishankuna kumplikanankaman. ");
INSERT INTO qufNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Chayraykumi, Dyus mantakushanta mayqanpis mana kasur ashwan ukkunatapis ama kasunanpaq nir yaĉhachiqkunaqami syilumanta kaq mushuqmanta mantakutinqa, mana kwintachakashanachu kanqa. Nataq chay mayqanpis Dyus mantakushanta allita kasur, wakinkunapis kasunanpaq yaĉhachiqkuna-shuypaqami syilumanta kaq mantakutinqa kusala shumaqta riqsikashana kanqa. ");
INSERT INTO qufNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Chaymi nishaykillapa: Moisés mantakushanta yaĉhar yaĉhachikuqkuna, chaynulla fariseo runakunaqami Dyuspaq intrakarmapis mana tukuy shunqunwan kasunllapachu. Piru kuytawkish qamkunapis paykuna yupayma tukuyatkillapa. Ashwanmi syilumanta kaq mantakuyashanman yaykunaykillapapaqqa tukuy shunquykillapawan Dyus munashanlata rurayta ministinkillapa”. ");
INSERT INTO qufNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Chaynullami niranpis: “Qamkunaqami uyapashaykillapa rukuykillapakunata Moisés unaylla kaynu nishanta: ‘Amami wanuchikunkillapachu. Chaqa mayqanpis wanuchikuqqami, kusala manchaypaqta kastigakashana kanqa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Piru ashwan nuqa-shuypaqa nishaykillapa: Mayqanpis ukninkunawan piñakuqqami kastigakashana kanqa. Chaynulla mayqanpis ukninta ima nir jurapaqta-shuypaqami kusa mas karguyjun kaqkuna rikar yaĉhar kastiganqa. Nataq chay ukninta mana allinpaq riqsir qaryapaqta-shuypaqami Tayta Dyusna rikar infyirnupi tukuy tyimpupaqna kastiganqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Piru imanupi ufrindaykita altarman apar ĉhurayar, yarpunkiman mayqan ukniki qamwan piñakusha nir. ");
INSERT INTO qufNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Chaynu katinqami chay ufrindaykita chay altarpa naypanlapi dijar, rinkiraq chay uknikiwan, shumaqchanakuq. Chaymanta chaynu uknikiwan shumaqchanakusha kar-shuypaqa rinki chay altarman ufrindaykita Dyusninchikpaq ĉhuraqqa. ");
INSERT INTO qufNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Chaynulla imanupi mayqan ima mana allinta rurashayki nir uchachashuyatinqa, manaraq jwiskunaman qayachishuyatin parlar shumaqchanakuyllapa. Chaqa mana chaynu ruratki jwisman qayachishutinqami, chay jwisqa gwardyakunaman qukushutin karsilmanna apashunmanllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Chaqa chiqaptami nishayki: Chay karsilpina karqami mana dasqa lluqshimunkichu, tukuy imata rurashaykipaq limpu pagrakunaykikaman nir”. ");
INSERT INTO qufNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jesusqami niranpis: “Qamkunaqami allita uyapashaykillapa Moisés unay kaynu nishantaqa: ‘Runa kar, manaqa warmi karmapis masayjunna karqa, amami ukwan ukwan pununkillapachu’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Piru nuqa-shuypaqami nishaykillapa: Mayqanpis uk warmita rikar paywan kayta munarqami yarpuyninpiqa uchakushana nir. ");
INSERT INTO qufNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Chayraykumi, allilaw nawiki imata rikachir uchakuchishutinqa urqur itakuy karukaq qammantaqa. Chaqa allinmi kanqa kwirpuykipa uk partin kaqta itakunaykipaq tukuyla kwirpuyki tukuy tyimpupaq infyirnupi qischakananmantaqa. ");
INSERT INTO qufNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Chaynulla allilaw makiki uchakuchishutinpis, pitir itakuy karukaq qammantaqa. Chaqa allinmi kanqa kwirpuykipa uk partin kaqta itakunaykipaq tukuyla kwirpuyki tukuy tyimpupaq infyirnupi qischakananmantaqa. ");
INSERT INTO qufNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Chaynullami Moisesqa niqpis: ‘Mayqan warmiyjun kayar, manana warminwan kanarqa karguyjunkunapi uk kartata rurar warminta qurqashi dijayta puytin’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Piru kananqami nishaykillapa: Uk runa, warmin mana mayqanwan punusha ima katin yanqallamanta dijarqami, uchakunanta munaq yupayna dijayan. Chaynulla mayqanpis chay yanqallamanta itakukasha warmiwan kasaraqpismi kusala saqrata uchakuyan”. ");
INSERT INTO qufNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Chaynullami Jesusqa niranpis: “Qamkunaqami uyapashaykillapa Moisés unay rukuykillapakunata kaynu nishanta: ‘Imata ruranaykipaq Dyusninchikpa shutinpi jurarqa kumpliyllapa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Piru kananqami nishaykillapa: Amami imalapaqpis jurankillapachu nir. Chaynulla amami syilupaq rimar imaqa jurayllapachu. Chaqa syiluqami Dyusninchik tar mantakunan. ");
INSERT INTO qufNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Chaynulla amami pachapaq rimarmapis jurayllapachu. Chaqa pachaqami Dyusninchikpa ĉhakin shanan. Amami Jerusalén pwiblupaq rimarmapis jurayllapachu. Chaqa Jerusalén pwibluqami mantamaqninchik Dyuspa pwiblun-ari. ");
INSERT INTO qufNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Amami jurayllapapischu umaykillapapaq rimarpis. Chaqa manami puytinkichu uk aqchaykillapalamatapis yuraqpaq, manaqa yanapaq tikraytaqa. ");
INSERT INTO qufNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ashwanmi juranaykillapamantaqa imapaqpis ‘Chiqap’ nitkillapaqa, chiqap kanqa. ‘Mana’ nitkillapapis, mana kanqa. Chaqa mayqanpis jurar imata arnikuqqami dyablu munashannuna rimar arnikuyan. ");
INSERT INTO qufNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Qamkunaqami uyapashaykillapapis Moisés unay kaynu nishantaqa: ‘Nawipaqqa kanqa uk nawi. Kirupaqpis uk kiru’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Piru nuqaqami nishaykillapa: Mayqan ima mana allinta rurashutinqa, amami qampis ima mana allintaqa rurankichu. Ashwanmi mayqan allilaw qaqllaykipi takashutinqa uklawtapis rikachiy nir. ");
INSERT INTO qufNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Chaynulla mayqan qayachishur kamsaykita kitashunatinqa, dijay punchuykitapis apanqa. ");
INSERT INTO qufNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Chaynulla mayqan ‘Apay kargayta kaymanta wakkaman’ nir, amalas apachishunatinqa, ashwan chay nishushanmantaqa mas larguta apay. ");
INSERT INTO qufNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Chaymi mayqanpis imalata mañashutinqa, quy. Chaynullami mayqan imalata pristanaykipaq mañashutinpis amami das tikrakar rinkichu. ");
INSERT INTO qufNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Chaynullami uyapashaykillapapis Moisés unay kaynu nishantaqa: ‘Qamkunawan shumaq kaqkunata llakipar, ĉhiqnishuqkunata-shuypaqa ĉhiqniy’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Piru nuqaqa nishaykillapa: Ĉhiqnishuqkunataqa llakipar shumaqta rikayllapa. Chaynulla Tayta Dyusman mañakuyllapa mana allinta rurashunanllapapaq ikikillapapi puriqkunapaq ima nir. ");
INSERT INTO qufNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Chaynu rurarqami qamkunaqa unaq syilumanta Taytaykillapa Dyuspa chiqap wamrankunana kankillapa. Chaqa pay nitinmi rupaymapis achkirachikamun allin kaqkunapaq, chaynulla mana allin kaqkunapaqmapis. Chaynulla pay nitinmi tamyamapis ishkimun allinta ruraqkunapaq, mana allinta ruraqkunapaqmapis. ");
INSERT INTO qufNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Chaqa qamkunata llakipashuqkunalata llakiparqa ¿imatanari Dyusmantaqa aypankillapa? Chaqa Dyusta mana kasuq, Roma pwiblupaq impwistuta kubrakuqkunapismi mayqan paykunata llakipaqtaqa llakipanllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Chaynulla chay mayqanpis qamwan allin kaqlata saludarpis ¿imatataq shumaqtaqa rurayankillapa? Chaqa Dyusta mana kasuq runakunapismi chaynu ruranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ashwanmi qamkunaqa imapipis allinla kayllapa imanuĉhi unaq syilupi Taytaykillapa Dyus kusa allinla chaynu”. ");
INSERT INTO qufNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jesusqami niranpis: “Tukuy ima allin kaqtaqami imuraspis rurayllapa. Amami runakuna rikamananpaq nir paykunapa naypanlapichu rurankillapa. Chaynu runakunala alabashunanllapapaq rurayatkillapaqa imanunari unaq syilumanta Taytaykillapamaqa chay shumaq imata qushunanllapapaq karan chaytaqa qushunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Chayraykumi mayqan ministiqkunata yanaparpis amami imanutaq Dyusta yanqa kasuq tukuqkuna kusalata alabakar parlakunllapa chaynuqa puriyllapachu. Chaqa paykunaqami chay Israel runakuna tantakananllapa wasikunapi, waqtakunapi ima parlakur purinllapa, runakuna paykunapaq shumaqta rimananllapalapaq. Chaymi nishunillapa: Paykunaqami chay runa masinkuna alabashanlawanna kidanqallapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Chayraykumi qamkuna mayqanta ima ministishanpi yanaparqa amami chay kusala riqsinaykimatapis parlankichu. ");
INSERT INTO qufNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Chaynu imata yanapakur mana imatapis rimatkiqami, Taytayki Dyus rikashurqa kusala shumaq imatana qur yanapashunqa. ");
INSERT INTO qufNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Qamkuna Dyusman mañakurqa, amami Dyusta yanqa kasuq tukuq runakuna yupayqa kayllapachu. Chaqa, paykunaqami chay tantakananllapa wasikunapi, chay may iskinakunapi ima sharla Dyusman mañakuyta kusalata munanllapa. Chaynuqami paykunaqa ruranllapa runakuna rikar alabananllapalapaq. Chaymi nishunillapa: Paykunaqami chay runa masinkuna alabashanlawanna kidanqallapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Piru qam mañakurqami wasikiman yaykur, punkuykita kirpakur Taytayki Dyus chaypi qamlawan kaqman mañakunki. Chaynu ruratki chay qamlawan kaq Dyusniki rikashurqami kusala shumaq imata qur yanapashunqa. ");
INSERT INTO qufNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Chaynulla qamkuna Dyusninchikman mañakurqa amami kutir kutir chayllata rimarqa mañakuyllapachu, imanutaq Dyusninchikta mana riqsiq runakunamaqa tukun chaynuqa. Chaqa paykunaqami yarpunllapa chaynu kusalata rimapakutinqashi Dyusqa mas uyapayanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Chaymi qamkunaqa ama chay runakuna yupayqa kayllapachu. Chaqa Taytaykillapa Dyusqami ima ministiyashaykillapatapis yaĉhayanllana manapis mañakuyatkillapa. ");
INSERT INTO qufNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Chaymi ashwan qamkunaqa kaynu mañakunkimanllapa: Unaq syilupi Taytayllapa, qammi kusa allinpaq riqsikanki. ");
INSERT INTO qufNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Shamuy-ari qamla kay pachapiqa mantamanaykillapapaq. Qam munashaykinullami kay pachapi rurakanqa imanuĉhi unaq syilupi ruranki chaynulla. ");
INSERT INTO qufNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kananllami chay ministiyashayllapa mikuytaqa qumayllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Mana allinta rurashayllapamantapis pirdunamayllapa, imanuĉhi nuqakunapis mana allinta ruramatinllapapis pirdunanillapa chaynulla. ");
INSERT INTO qufNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Amami uchakunayllapapaqqa dijamankillapachu. Ashwanmi chay riqchaq mana allinkunamantaqa washamayllapa. Chaqa qammi tukuy imata puytinki; kusala shumaqpaq riqsikanki; chaynulla tukuy tyimpupaq mantakunki ima nir. ");
INSERT INTO qufNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Chaqa qamkunata ukkuna ima mana allinta rurashutinllapa pirdunatkillapaqami, unaq syilupi Taytaykillapa Dyuspis pirdunashunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Piru qamkuna mana ukkunata pirdunatkillapaqa manami Taytaykillapa Dyuspis uchakushaykillapamantaqa pirdunashunqallapachu. ");
INSERT INTO qufNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Chaynulla qamkuna ayunarqa, amami kusa kwashalla tikrakarchu purinkillapa imanutaq Dyusta yanqa kasuq tukuq runakuna, tukunllapa chaynuqa. Chaqa paykunami chaynu kwashalla tukunllapa runakuna rikar, ayunayan ninanllapalapaq. Chaymi nishunillapa: Paykunaqami chay runa masinkuna alabashanlawanna kidanqallapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Chaymi ashwan ayunarqa, alli qaqllitaykillapata paqakur, shumaq ñaqsakur kamakayllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Chaynu ruratkillapaqami mana mayqanpis kwintata qukanqallapachu ayunayankillapa nirqa. Nataq Taytaykillapa Dyus qamkunalawan chaypi kaqmi, yaĉhayanqa chay ayunayashaykillapapaqqa. Chaynami ashwan kusala shumaq imata qur yanapashunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Amami kay pachapi kaq imaykillapataqa tantakunkillapachu. Chaqa kay pachapi kaq imaykillapaqami pumpir, muqusyar ima, limpu tukukan. Chaynulla suwakuqkunamapis wasikunaman yaykur suwakunllapa ima. ");
INSERT INTO qufNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ashwanmi kay pachapi kaq imaykillapapaq yarpunaykillapamantaqa unaq syilumanta kaq imaykillapapaq yarpur Dyus munashanlatana rurar kawsayllapa. Chaqa syilumanta kaq imaykillapaqa manami pumpir, muqusyar ima tukukanlamapischu. Chaynulla manami chaymanqa suwakuqkunalamapis yaykunchu. ");
INSERT INTO qufNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Chaymi nishaykillapa: Qamkuna kay pachamanta kaq imaykikunalata chapar yarpuyatkillapaqa kay pachamanta kaq imakunalapi kanqa yarpuynikillapaqa. Nataq unaq syilumanta mana tukukaq imaykillapapaq chapakur yarpuyatkillapa-shuypaqa syilumanta kaq imaykillapalapi kanqa yarpuynikillapaqa. ");
INSERT INTO qufNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Allita yarpuyllapa: Nawikillapa imanutaq bilamaqa kusala shumaq allinta achkirachikun chaynu kwirpuykillapapi katinqa, tukuyla kwirpuykillapaqa kusala shumaqta achkirachikuq yupaylana kanqa. ");
INSERT INTO qufNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Piru nawikillapa kusala mana allin kashanrayku kay pachamanta kaq imakunalapaq yarpuchishutin-shuypaqami kwirpuykillapapis tutaparaq intirupina kayanqa. Chaynuqami achkirachikunaykillapamantaqa ashwan tutaparachikuyankillapana kanqa. Chaymi ashwan chaynu karqa mana imalatapis Dyusninchikpaqmaqa intrakayankillapachu kanqa. ");
INSERT INTO qufNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Nishaykillapapis: Manami mayqan sirbikuqpis ishkay runata chay kutilla sirbiytaqa puytinchu. Chaqa uknintami munayanqa, nataq ukninta-shuypaqa ĉhiqniyanqa. Manaqa uknintaqa allinta rikayanqa, nataq ukninta-shuypaqa musyayanqa. Chaynulla manami allinchu Dyusninchikta sirbiyar chay kutilla qillayninchiklapaq chaynulla wakin imanchikkunalapaq yarpur kawsanapaqqa. ");
INSERT INTO qufNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Chayraykumi nishunillapa: Amami qamkunaqa yarpupakunkillapachu, imataraq mikur, upyar kawsashaq nirqa. Chaynulla amami yarpupakunkillapapischu imataraq mudakushaq nirmapis. ¿Chaqa manachu yaĉhankillapa chay kawsanaykillapa, chaynulla kwirpuykillapaqa masta sirbin mikuymanta, raĉhpamantaqa nir? ");
INSERT INTO qufNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Rikayllapa pariq kuritukunata. Paykunaqa manami tarpukur urqukunllapalamapischu. Chaynulla manami mikunanllapata ĉhurakunllapalamapischu. Piru, imanutaq ashwan unaq syilupi Taytaykillapa Dyusqa paykunataqa qaran ima. ¡Allita yarpuyllapa, qamkunaqami chay kurukunamanta ashwan kusa masta sirbinkillapa! ");
INSERT INTO qufNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Chayraykumi tapushaykillapa: ¿Chaynu kusalata yarpupakurqachu, imanu kashaykillapamantaqa midyu mitrullataqa winayta puytinkimanllapa? ¡Manami! ");
INSERT INTO qufNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Chaynu katinqa, ¿imapaqtaq qamkunaqa kusalata yarpupakunkillapa mudanaykillapapaq imaqa? Allita kwintata qukayllapa, imanutaq liryukunamaqa muntipi winar, mana trabajanchu chaynulla mana puchkakunlamapischu. ");
INSERT INTO qufNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","“Piru paykunaqami kusala shumaqta tuktukustunmapis. Chaymi nishaykillapa: Mantakuq Salomonmapis kusala ĉhaniyjun raĉhpanwan mudakurmapis manami chay tuktitukuna yupayqa lusiranchu. ");
INSERT INTO qufNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Chaqa Dyus kanankuna chay tuktitukunata winachir kusa shumaqta lusichitinmapis, allaqkunaqa rupar imana tukukanqallapa. Chaynu karmi qamkunataqa ashwan kusala mas shumaqta ima mudachishuyanqallapa. Piru chaynu yaĉharqa, ¿imapaqtaq Dyusninchikpi manaraq allita kriyinkillapa? ");
INSERT INTO qufNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Chayrayku ama llakiyllapachu ‘¿Imatana mikushun? ¿Imatana upyashun? ¿Imanuna mudakushun?’ nir imaqa. ");
INSERT INTO qufNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Chaqa tukuy chaykunapaqqami Dyuspi mana kriyiqkuna chaynuqa yarpupakur kawsanllapa. Piru qamkunapaqqami unaq syilupi Taytaykillapa yaĉhayanna, imatami ministinkillapa nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Chayraykumi, tukuy imakunapaq yarpur llakinaykillapamantaqa, ashwan Taytanchikllapa Dyus tukuyta mantakushanrayku, paylata maskar munashannula allinta rurar kawsayllapa. Chaynu kawsatkillapaqami Taytaykillapa Dyusqa tukuy ministishaykillapapi yanapashunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nishaykillapapis: Amami allaqmantaqa imaraq pasamanqa nirqa yarpupakunkillapachu. Chaqa chay allaqmanta diyapismi ĉhamunqana chay diyallapi ima kaqpaq yarpunaykillapapaqqa. Allita yaĉhashanchikllapanu, diyakunami shamun imanuraq kashaq nir chay diyallapi yarpunapaq. ");
INSERT INTO qufNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Amami uknikikunata rikar yaĉhankillapachu, Dyus qamkunatapis ama rikar yaĉhashunanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Chaqa ukkunata rikar yaĉhatkillapaqa, chaynullami qamkunatapis Dyusqa rikar yaĉhashunqallapa. Chaynulla imanu ukkunata rikatkipis, chay rikashaykinullami Dyusqa qamkunatapis rikar yaĉhashunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Chaqa imapaqtaq uknikipa nawinpi usulsitu tayan chayta rikaq ĉhurakanki, qampa nawikipi atun qiru tayan chayta naypaqta mana lluqshichirqa? ");
INSERT INTO qufNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Chaymi qampa nawikipi uk atun qiru tayatinqa, ¿imanutaq uknikita ninkiman: ‘Nawikipi usulsitu tayan chayta lluqshichishaq’ nirqa? ");
INSERT INTO qufNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Kusa allin tukuq runa! Puntataqa chay nawikipi atun qiru tayan chaytaraq lluqshichiy. Chaymantaraqmi chay uknikipa nawinpi tayan chay usulsitutaqa allita rikar lluqshichimuyta puytinki. ");
INSERT INTO qufNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Chaynulla nishunillapapis: Amami Dyusninchikpa shumaq rimayninta willankillapachu chay kusala marraju allqu yupay runakunataqa. Chaqa imanupiqakish piñakurmana llakiypaqta qischashunmanllapa. Chaynulla chay kuchi yupay runakunataqa amami willankillapapischu. Chaqa paykunaqami mana kwintachar limpu saruĉharmana dijanman. ");
INSERT INTO qufNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Dyusman mana shaykuq mañakuyllapa; paymi qushunqallapa. Tukuy ministishaykillapata maskayllapa; Dyusmi tarichishunqallapa. Chaynulla punkumanta mana shaykuq qayakuyllapa. Chaymi payqa punkunta kiĉhar yanapashunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Chaqa mayqan mañakuqpismi tarikun mañakuyashantaqa. Chaynulla mayqan maskakuqpismi, tarin maskayashantaqa. Punkupi mayqan kusalata shachinakur qayakutinpismi, punkunta kiĉhar yanapanllapa ima. ");
INSERT INTO qufNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“¡Ma nimayllapa! ¿Wamrayki tantata mañashutinllapaqachu rumita qunkimanllapa? ");
INSERT INTO qufNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Manaqa wamrayki piskaduta mañashutinllapaqa, largu kurutachu qunkimanllapa? ¡Manami! ");
INSERT INTO qufNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Chaqa qamkuna kusala malu runakuna karmapismi, wamraykillapataqa allin imakunata qunkillapa. Chaymi ashwan ¡unaq syilupi Taytaykillapamaqa kusala shumaq imakunata qushunqallapa payman mañakutkillapaqa! ");
INSERT INTO qufNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Chaynullami nishaykillapapis: Wakinkuna qamkunawan shumaq kananta munarqa, qamkunapis shumaqta rurayllapa paykunawanqa. Chaynu rurarqami kusala allintana rurayanki, Moisés mantakushannulla, chaynulla Dyuspa unay rimaqninkuna iskribishannulla ima. ");
INSERT INTO qufNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Allita yarpurmi, chay kiĉhkila kaq punkituta pasar rinkillapa Dyusninchikman rinarqa. Chaqa chay tukuy tyimpupaqna rir qischakanapaq kaq punkuqami kusala atun chaynulla chay nanpismi, kusala anchu ima. Chaynu katinmi kusala achka rinqallapa chaylawtaqa. ");
INSERT INTO qufNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Piru Dyusninchikwanna rir tukuy tyimpupaq kawsanapaqqami kusa kiĉhkila punkitu, chaynulla kiĉhkila nansitu ima. Chaynu katinmi aykala chaylawtaqa yaykur rinllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Allitami kuytakankillapa chay llullakur Dyusninchikpaq parlakuq tukuq runakunamantaqa. Chaqa paykunaqami qamkunamanqa shamunqa imanutaq uyshitakunamaqa kusala mansitu chaynu. Piru alli yaĉhaymantaqami kusala manchaypaq atun surrukuna kanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Chaymi qamkunaqa tukuy imata rurayashanlamanta das riqsiyta puytinkillapa imanu nirmapis. Chaqa ubapa puquynintaqa manami kashakunamantachu pallanchik. Chaynulla Iguspa puquynintapis manami shankakunamantachu pallanchik. ");
INSERT INTO qufNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Piru tukuy allin qirukunaqami shumaqta puqun. Nataq chay mana allin qirukuna-shuypaqami mana allintachu puqun. ");
INSERT INTO qufNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Chaqa allin qiruqami mana puytinchu mana allinta puquytaqa. Chaynulla mana allin qirupis manami shumaqtaqa puquyta puytinchu. ");
INSERT INTO qufNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Chaymi, tukuy qirukuna mana allinta puquqtaqa kuchur ninaman itar rupachinchik. ");
INSERT INTO qufNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Chayraykumi qashan nishaykillapa: Tukuytami ima rurashankunalamanta allita rikar riqsinkillapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Manami tukuyla ‘Amituy, Amituy’ nimaqkunaqa, Dyus unaq syilupi mantakuyashanmanqa yaykunqachu. Ashwanmi, unaq syilupi Taytay munashanlata ruraqkuna yaykunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Chaqa chay diyapiqami nimayanqallapa: ‘Amituy, Amituy, nuqakunami qamlapaq kusata parlakurayllapa. Chaynulla qampa shutikiwanmi runakunamanta dyablupa yarpuyninta itakurayllapa. Shutikiwanmi achka milagrukunata rurarayllapa’ nir ima. ");
INSERT INTO qufNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Piru nuqaqami paykunataqa nishaq: ‘Manami maydiyapis riqsishushachu kani. ¡Ashuyllapa nuqamanta, mana allinta ruraqkuna!’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Chayraykumi, chay mayqanpis nuqa nishayta uyakur kasuqtaqa kumparashaq uk runa kusa allinlata yarpuqmaqa wasinta shachinanpaqqa allita yarpur, rumipa ananmanta shachiran chaywan. ");
INSERT INTO qufNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Chaymi tamya shamutin, riyukuna achkayar, wayramapis wakmanta, kaymanta wasilaman pukakamurmapis mana ratachiranchu. Chaqa alliri shachisha karan rumipa ananmanta. ");
INSERT INTO qufNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Piru nuqa nishayta uyakur mana kasuqta-shuypaqami kumparashaq imanutaq uk yaru runamaqa mana allita yarpur wasinta shachiran ushya aqupa ananlamanta chaywan. ");
INSERT INTO qufNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Chaymi tamya shamutin, riyukuna achkayamuran. Chaynulla wayra wakmanta kaymanta chay wasiman pukakamutinmi chay wasiqa limpu limpu pampalla rataran”. ");
INSERT INTO qufNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Chaymi chaynu Jesús rimar tukchitinnaqa, tukuyla chaypi kaqkunaqa dispantakaranllapa chay imanu yaĉhachikushanrayku. ");
INSERT INTO qufNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Chaqa Jesusqami paylla kusata mantakur ima yaĉhachikuran, manami Moisés mantakushanta yaĉhar yaĉhachikuqkuna yupaychu. ");
INSERT INTO qufNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesús chay sirkamanta ishkimutinqami, kusala achka runakuna ikinta riranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Chaymantaqami uk runa ismuyaq kwirpuyjun payman qimikar naypanpi qunqurikur niran: —Taytituy, llakipamayarqa allichamay-ari kay qishayniymantaqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Chaynu nitinqa, Jesusqa makinwan kamar niran: —Munanimi alliyanaykita. Kananlla alliyay nir. Chaymi chay kutilla chay ismuyaq kwirpuyjun runaqa, alliyaran qishayninmantaqa. ");
INSERT INTO qufNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesusqami niranpis: —Amami mayqantapis willankichu. Ashwanmi rir qimikay kuraman. Chaymi apanki ufrinditaykita Moisés mantakushannulla. Chayna tukuy yaĉhananllapapaq qishaynikimantaqa alliyashaykina nir. ");
INSERT INTO qufNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Chaymanta Capernaúm pwibluman Jesús yaykutin, Romamanta suldadukunapa uk mantaqnin, qimikaran payta rugaq. ");
INSERT INTO qufNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Chaymi niran: —Taytituy, sirbikuqniymi wasiypi qishaq. Manami kwirpunqa kuyuylamatapis puytiyanchu. Ashwanmi kusala saqra nanaywan qischakayan nir. ");
INSERT INTO qufNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesusqa niran: —Rishaqmi allichaq nir. ");
INSERT INTO qufNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Chaynu nitin, chay suldadukunapa mantaqninqa niran: —Taytituy, nuqa mana kwintachaypaqla kashayraykumi mana allinchu wasiymanraq rir yaykunaykipaqqa. Ashwanmi kayllamanta ‘Alliyanqa’ niy, chay sirbikuqniyqa alliyananpaq. ");
INSERT INTO qufNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Chaqa nuqallatami mantamaqniykuna mantaman. Chaynulla nuqapis wakin suldadukunata mantani. Chaymi mayqannintapis ‘Riy’ nitiyqa, rin. Ukta ‘Shamuy’ nitiypis, shamun. Chaynulla sirbiqniytapis imata rurananpaq kaĉhatiypis ruran. ");
INSERT INTO qufNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Chaynu nitin uyaparmi Jesusqa kusa dispantakashalla aligriyaran. Chaymi chay wakin ikinta riqkunataqa niran: —Chiqaptami nishaykillapa: Tukuyla Israel pwiblupiqa manami mayqantapis kay runa yupay allita kriyiqtaqa tarishachu kani. ");
INSERT INTO qufNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Chaymi nishaykillapapis: Achka jwira runakunami shamunqallapa rupay iqamunanlawmanta, rupay iqananlawmanta ima. Chaymi paykunana tayanqa pulla mikuq Abrahamwan, Isaacwan, Jacobuwan syilumanta kaq mantakuyashanpiqa. ");
INSERT INTO qufNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Piru Dyus mantakuyashan luryanpi kananpaq karan chaykunaqami, itakukayanqa waqta tutaparaqlla infyirnumanna. Chaymi chaypina kusala mana agwantaypaqta qischakar qayĉhakushanrayku kirunmatapis richyachinqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Chaymantami Jesusqa chay suldadukunapa mantaqnintaqa niran: —Riyna wasikiman. Qam kriyishaykinullami wasikipiqa rurakanqa nir. Chaynu Jesús nitinlami, chay kutilla sirbikuqninqa alliyaranna. ");
INSERT INTO qufNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesusqami riran Pedrupa wasinman. Chaypimi Pedrupa swigranta tariran, mantanpi qishaq usuraqta. Kusala rupawanmi karan. ");
INSERT INTO qufNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Chaymi Jesusqa, chay warmisitataqa makinmanta kamaran. Chayna chay rupaqa dijaranna. Chaymantami ashwan chay warmisitaqa sharikur paykunata qaraqna qallariran. ");
INSERT INTO qufNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tutapatinnaqa Jesusman achka runakuna dyablupa yarpuyninwan kaqkunata apamuranllapa. Piru Jesusqami rimarla chay dyablupa yarpuynin runakunapi kaqtaqa itakuran. Chaynullami allicharanpis tukuyla qishaq kaqkunataqa. ");
INSERT INTO qufNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tukuy kaykunaqami chaynuqa pasaran Dyuspa rimaqnin Isaías kaynu nishan kumplikananpaq. Chaqa kaynumi nisha kayaq: “Paylla nanayninchikkunata urquran. Chaynulla paymi qishayninchikkunatapis aparan” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Uk diyapimi Jesusqa achka runakunapa rurinpi rikariran. Chaymi yaĉhakuqninkunataqa kaynu niran: Pasashunllapa chay quĉhapa chimpanman nir. ");
INSERT INTO qufNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Chaymantaqa Moisés mantakushankunata yaĉhar yaĉhachikuq runami Jesusman qimikar niran: —Yaĉhachikuq Taytituy, mayta ritkipismi pullayki rinayani nir. ");
INSERT INTO qufNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Chaynu nitinmi Jesusqa niran: —Surrukunami maĉhayniyjun pununanpaqqa. Chaynulla pariq kurukunapis qushayjun ima. Piru Dyusmanta Shamuq Runapaq-shuypaqami mana kanchu maylapipis umanta sintikuchinanlapaqmapis nir. ");
INSERT INTO qufNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Chaynu nitinmi yaĉhakuqninkunamanta ukqa kaynu niran: —Taytituy, dijamay rishaq taytay wanutin pampaqraq. Chaymantanami rishun nir. ");
INSERT INTO qufNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Chaynu nitinmi Jesusqa niran: —Kusa allinmi kananlla nuqawan rinaykipaq. Chaqa nuqapi mana kriyiqkunaqami imanutaq wanushakunamaqa chaynu. Chaymi dijay wanushakunaqa paykunapurana pampanakunqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Chaymantami Jesusqa yaĉhakuqninkunawan yaku karruman iqar riranllapana. ");
INSERT INTO qufNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Chaynu riyatinllapami chay quĉha yakuqa kusata wakman kayman maqchikaq qallariran. Chaymi chay yaku karrutaqa pampanayaranna. Piru chaykamanqami Jesusqa punuyaran. ");
INSERT INTO qufNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Chaymi yaĉhakuqninkunaqa rikĉhachiq rir niranllapa: —¡Taytituy, washamayllapari! ¡Yaku rurimanmi chinqayanchikllapana! nir. ");
INSERT INTO qufNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Chaynu rikĉhachitinllapami Jesusqa niran: —¿Imapaqtaq kusalata manchakunkillapa? ¡Qamkunaqami manaraq allitaqa kriyimankillaparaqchu! nir. Chaynu nirnaqami, sharir wayrawan yakutaqa willatinla limpu limpu qasillaran. ");
INSERT INTO qufNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Chaynu rurashanraykumi kusa dispantakashalla paykunapura tapunakuyaqllapa: —¿Kayqa, imanu runa katintaq wayrawan yakumapis kasunqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Chaymanta Jesusqa chay quĉhapa uklaw manyan Gadara shutiq lugarman ĉharan. Chaymi chay lugarmantaqa dyablupa yarpuyninwan kaq ishkay runakuna, pantyunmanta lluqshir, payman qimikaran. Chay runakunaqami kusala saqra manchaypaqta tukuqllapa. Chaymi chay lugartaqa mana mayqanpis pasayta puytiqllapachu. ");
INSERT INTO qufNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Piru Jesusta rikarqami, kaynu nir qayĉhakuq ĉhurakaranllapa: —¡Dyuspa Wamran Jesús, amami nuqakunamanqa yakapakamuychu! ¿Chaqa qamqachu manapis jwisyu diya ĉhamuyatinraq kananlla shamushayki qischamaqllapa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Piru chay kayashanllapamanta largukaqpimi achka kuchikuna shitqakuyaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Chaymi chay dyablupa yarpuyninqa, Jesustaqa kaynu nir rugaranllapa: —Kay runakunamanta lluqshichir itakumarllapaqa, dijamayllapa chay achka kuchikuna kan chayman yaykunayllapapaq nir. ");
INSERT INTO qufNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Chaynu nitinmi Jesusqa niran: —Riyllapa nir. Chaynami chay dyablupa yarpuyninqa runakunamanta lluqshir kuchikunamanna yaykuran. Chaymi kuchikunaqa chay kutilla kusalata kallpar, qaqata rishannu quĉhaman ratar ĉhuqar wanuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nataq chay kuchikunata michiqkunaqami alsakar riranllapa. Chaymi pwibluman ĉharqa imanu chay dyablupa yarpuyninwan kaq runakuna pasashantaqa tukuyta parlaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Chaymi chay kutilla pwiblumanta kaq runakunaqa lluqshir riranllapa Jesús kayashanmanqa. Chaynu Jesusta chaypi rikarllapami kusalata rugaranllapa kay lugarniyllapamantaqa wakaq tukuy nir. ");
INSERT INTO qufNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Chaymantaqami Jesusqa uk yaku karruman iqar, quĉhapa uklaw chimpanman pasar pwiblunllaman ĉharan. ");
INSERT INTO qufNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Chaypina katinqami uk mana kuyuyta puytiq kwirpuyjun runata, uk parapi usurachir wintusha payman ĉhachiranllapa. Chaymi Jesusqa paypi kusalata kriyiqllapata rikar, chay qishaqtaqa niran: —Shachinakuy wamrituy. Chaqa tukuy uchakushaykikunamantami pirdunashushana kani nir. ");
INSERT INTO qufNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Chaymi Moisés mantakushankunata yaĉhar yaĉhachikuq runakunaqa kaynu nir yarpuranllapa: ¿Wakqachu Dyusninchiknulla tukunayan? Manami allinchu chaynuqa. Chaqa Dyuslami uchakunamanta pirdunakuytaqa puytin nir. ");
INSERT INTO qufNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Piru Jesusqami kwintata qukaran imatami yarpuyanllapa nirmapis. Chaymi paykunataqa kaynu nir tapuran: —¿Imapaqtaq qamkunaqa kusala mana allin yarpuyniyjunqa kankillapa? ");
INSERT INTO qufNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Imataq mas trabajusu ninaypaq, ‘Uchaykikunamantami pirdunashuni’ ninaypaq, manaqachu ‘Sharir puriy’ ninaypaq? ‘Uchaykikunamanta pirdunashuni’ nitiyqa qamkunaqa mana kriyinkillapachu. ");
INSERT INTO qufNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Piru kananllami intrachishaykillapa Dyusmanta Shamuq Runaqami kay pachapiqa paylla puytin uchanllapakunamanta pirdunakuytaqa nir. Chaynu nirnaqami chay mana kuyuyta puytiq kwirpuyjun runataqa niran: —Sharir paraykita apar, riy wasikiman nir. ");
INSERT INTO qufNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Chaymi chaynu nitinqa, chay mana kuyuyta puytiq kwirpuyjun kayaq runaqa sharir, riranna wasinman. ");
INSERT INTO qufNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tukuy chaykunata rikarmi chaypi kaq runakunaqa kusalata dispantakaranllapa. Chaymi ashwan Dyusta alabaq ĉhurakaranllapa imanumi payqa uk runata pudirninta qusha nir. ");
INSERT INTO qufNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Chaymantami Jesusqa chay kayashanmantaqa riranna. Chaynu riyarmi rikaran uk runa Mateo shutiqta. Payqami chay Roma pwiblupaq impwistuta kubrakunanpi tayaran. Chaymi Jesusqa niran: —Shamuy nuqawan rishun nir. Chaynu nitinqa Mateuqa sharir paywanna riran. ");
INSERT INTO qufNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Chaymantami Jesusqa Mateupa wasinpi mikuyaranna. Chaymi chay kutilla Romapaq impwistuta kubrakuqkuna, kusa uchayjun runakuna ima ĉharanllapa. Chaynami ashwan paykunapis Jesuswan, yaĉhakuqninkunawan ima pulla mikuq ĉhurakaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Chayta rikarmi chay fariseo runakunaqa Jesuspa yaĉhakuqninkunataqa kaynu nir tapuran: —¿Imapaqtaq yaĉhachikuqnikillapaqa chay impwistuta kubrakuqkunawan chaynulla uchasapakunawan pullaqa mikun? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Chaynu nitinllapa uyaparmi, Jesusqa niran: —Allilan kar mana qishaq kaqkunaqami mana ministinchu rimidyakuqtaqa. Chaymi ashwan chay qishaq kaqkunala ministin rimidyakuqtaqa. ");
INSERT INTO qufNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Rir allita intrakayllapa Dyus nitin unaylla iskribishanllapata. Chaqa ninmi: ‘Nuqaqa manami munanichu animalkunata wanuchir ufrindita nir nuqaman apamunanllapataqa. Ashwanmi munani wakinkunata llakipar ima ministishanpipis yanapananllapapaq’ nir. Chaynulla nuqaqa manami chay kusa allinla kani niqkunata willaqchu shamusha kani. Ashwanmi shamusha kani, chay uchayjunkunata willatiy kriyir washakananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Chaymantaqami Shutichikuq Juanpa yaĉhakuqninkuna, Jesusman qimikar kaynu nir tapuranllapa: —Nuqakuna, chaynulla chay fariseo runakunapismi kusalata ayunanillapa. Piru qampa yaĉhakuqnikikunaqa ¿imapaqtaq mana ayunanllapa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesusqa niran: —¿Uk runa kasaraq, chayllapiraq katinqachu, wakinkunaqa llakishala kanmanllapa? ¡Manami! Chaymi chay kasarasha chaykuna rinanpaq ura ĉhamutin, ritinllapanami ayunanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Nishaykillapapis: Manami mayqanpis uk makwa raĉhpataqa mushuq raĉhpawanqa rimindanchu. Chaqa chay mushuq raĉhpami paqakarqa chapukayanqa. Chaynu chapukarmi, makwa raĉhpataqa llikinman. Chaynuqami ashwan masna llikikayanqa. ");
INSERT INTO qufNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Chaynulla, chay ubapa yakun binutaqa manami itanchikchu makwa qara kapachumanqa. Chaqa chay ubapa yakun binumi byijuyar makwa qarataqa llikinman. Chaymi ashwan ubapa yakun binu chaynulla chay qara kapachupis yanqallana tukukanman. Chayraykumi, ubapa mushuq yakun binutaqa mushuq qara kapachuman itaypaq amana mayqanninpis imanananpaqqa”. ");
INSERT INTO qufNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Chaynu Jesús rimayatinllami, Israel runakunapa uk mantaqnin ĉhamur Jesuspa naypanlapi qunqurikur kaynu niran: —Chayraqmi warmi wamray wanusha. Piru qam rir makisituykita ananpi ĉhuratkiqa, payqa qashan kawsamuyanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Chaynu nitinmi Jesusqa sharir, yaĉhakuqninkunawan ima riranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Piru chaynu riyatinmi chay lugarlawpi karan uk qishaq warmi. Chay warmipa yawarninmi dusi añupaqna kusalata shamuq. Chaymi Jesuspa ikinlawta qimikar raĉhpanpa manyanta kamaran. ");
INSERT INTO qufNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Chaqa chay warmiqami yarpuq, raĉhpanta kamarlami alliyashaq nir. ");
INSERT INTO qufNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Piru chaynu ruratin Jesusqa ikiman chapakur warmita rikarqa niran: —Shachinakunkimi mamitay. Chaqa kriyishaykiraykumi alliyashaykina. Chaymi ashwan chaymanta-pacha allinna kidaran chay warmisitaqa. ");
INSERT INTO qufNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Chaymanta Jesusqa chay Israel runakunapa mantaqninpa wasinman ĉharqa, rikaran dulsaynata waqachiq runakunata. Chaynullami rikaranpis chaypi kaqkuna kusalata waqar laqyaqllapata ima. ");
INSERT INTO qufNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Chaymi Jesusqa niran: —Lluqshiyllapa kaymanta. Chay warmi wamraqami mana wanushachu. Punuyanlami nir. Chaynu nitin, chaypi kaqkunaqa kusalata asiparanllapa Jesustaqa. ");
INSERT INTO qufNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Piru payqami ruripi kaqkunata limpu lluqshichimuran. Chaymantami chay wasiman yaykur, chay warmi wamrataqa makinmanta aypatin, sharimuran. ");
INSERT INTO qufNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Chaymi tukuy chay lugarkunapiqa yaĉharanllapana imanu warmi wamraqa kawsamusha nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Chaymanta lluqshir ritinnaqami Jesuspa ikintaqa ishkay syigu runakuna riran kaynu nir qayakur: —¡Davidpa ayllun llakipamastuyllapari! nir. ");
INSERT INTO qufNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Chaymanta Jesús wasi ruriman yaykutinqa, chay syigu runakunaqa qimikatin, Jesusqa kaynu nir tapuran: —¿Qamkunaqachu kriyinkillapa alliyachishuyashaqllapa nirqa? Chaynu nitin, paykunaqa niranllapa: —Arí taytituy nir. ");
INSERT INTO qufNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Chaymantami Jesusqa, nawinkunata kamar niran: —Qamkuna imanutaq kriyishaykillapanullami rurakanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Chaymi chay kutilla rikakuranllapana. Piru Jesusqami kaynu nir kusalata willaran: —Amami mayqanpis yaĉhanqachu kaytaqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Piru ashwan chay runakunaqa wasimanta lluqshishanmanta-pacha imanu Jesús paykunata alliyachishanpaq ima tukuylata parlaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Chaymanta chay syigukuna alliyashana lluqshimuyatinqa, wakin runakunapis Jesusman aparanllapa uk mudu dyablupa yarpuyninwan qishaq runata. ");
INSERT INTO qufNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Chaymi Jesús chay dyablupa yarpuyninta chay mudu runamanta itakutinqa, rimaqna qallariran chay runaqa. Chaymi chaypi kaqkunaqa kusa dispantakashalla niyaqllapa: “¡Kay Israel pwiblupiqami maydiyapis mana rikashanchikchu waknu mayqanpis allichakuqtaqa!” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Piru chaypi kaq chay fariseo runakuna-shuypaqami niyaranllapa: “Waktaqami dyablukunapa mantaqnin pudirninta qusha, chaynu dyablupa yarpuyninta itakunanpaqqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Piru Jesusqami tukuy pwiblukunapi, taksha pwiblitukunapi ima yaĉhachikur puriyaran. Tukuy tantakananllapa wasikunapimi Dyuspa shumaq rimayninta yaĉhachikur puriran, washakarna paypa mantakuyninpi kawsananllapapaq. Chaynullami allichakuqpis tukuy qishaykunamanta, nanaykunamanta ima. ");
INSERT INTO qufNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Chaymi runakunata rikar, kusalata llakiran paykunapaq. Chaqa chay runakunaqami kusata shaykur kwashayasha, chinqasha mana washakananpaq yupayna karanllapa, imanutaq uyshakuna mana michikuqniyjunmaqa chaynu. ");
INSERT INTO qufNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Chaymi Jesusqa yaĉhakuqninkunataqa niran: “Chiqaptami kusichaqa kusala achka. Piru aykalami trabajaqkunaqa. ");
INSERT INTO qufNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Chayraykumi chay kusichapa amunta mañayllapa, pay kaĉhananpaq trabajaqkunata, paykunana tantananllapapaq” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesusqami chay dusi yaĉhakuqninkunata qayamur, pudirninta quran, dyablupa yarpuyninkunata runakunamanta itakunanllapapaq. Chaynulla tukuy qishaykunamanta, nanayninllapakunamanta imamapis allichakunanllapapaq ima. ");
INSERT INTO qufNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Kaykunami chay dusi yaĉhakuqninkunaqa karan: Puntataqa, Simón (kay Simonmi shutiqpis Pedro), Simonpa uknin Andrés; Zebedeupa ishkay wamrankuna, Santiago, Juan ima. ");
INSERT INTO qufNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Chaynulla Felipe, Bartolomé, Tomás, Mateo. Kay Mateumi Roma pwiblupaq impwistuta kubrakuq karan. Chaynullami karanpis Alfeupa wamran Santiago, Tadeo ima. ");
INSERT INTO qufNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ukqami karan Simón. Payqami Cananeo partidumanta karan. Uk-shuypaqa karan Judas Iscariote. Kaymi Jesustaqa kuntrankunaman qukuran wanuchinanllapapaqqa. ");
INSERT INTO qufNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesusqami chay dusi yaĉhakuqninkunataqa kaynu nir kaĉharan: “Amami rinkillapachu chay mana Israel runakunamanqa. Chaynulla amami yaykunkillapapischu chay Samaria pwiblumanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ashwanmi chay Israel pwiblumanta kaq runakuna imanutaq uysha chinqasha purin chaynu puriqkunaman riyllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Chaynami paykunata willayllapa, syilumanta kaq mantakuq shamunanpaqqami shipchana nir. ");
INSERT INTO qufNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Chaynullami tukuy qishaqkunata allichankillapa, wanushakunata kawsachimunkillapa, ismuyaq kwirpuyjun kaqkunata allichankillapa, itakunkillapapismi dyablupa yarpuyninta runakunamanta ima. Chaqa tukuy chaykunata ruranaykillapapaqqami mana imawan pagrakur imachu dibaldila chay pudirtaqa ayparaykillapa. Chaymi imata rurar yanapakurpis ama kubrakunkillapachu. ");
INSERT INTO qufNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Piru amami apankillapachu urumanta, platamanta, kubrimanta kaq qillay imamatapis. ");
INSERT INTO qufNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Chaynulla amami apankillapachu alburjata, mudakunaykipaq raĉhpaykillapata, llanqita, bastunta imamapis. Chaqa uk trabajaqtaqami trabajashanrayku qarayta puytinllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Chaymi qamkuna uk pwibluman manaqa uk taksha pwiblituman ĉharqa, uk kusa allin runata maskar, chaypa wasinpi kidankillapa chay ima diyaĉhi rinaykillapakaman. ");
INSERT INTO qufNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Piru chay wasiman yaykurqa chaypi kaqkunata kusa shumaqta saludankillapa. ");
INSERT INTO qufNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Chaymi chay wasipi kaqkuna shumaqta samachishutinllapaqa Dyusmi shumaqta yanapanqa paykunataqa. Piru mana chaynu samachishutinllapa-shuypaqa manami imapis kanqachu. ");
INSERT INTO qufNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Chaymi uk wasipi manaqa uk pwiblupi yaĉhachikutkillapa mana uyakunar mana munashutinllapaqa, chaymantaqa ĉhakikillapapi kaq pulbumatapis ĉhaspir rinkillapa. ");
INSERT INTO qufNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Chiqaptami nishaykillapa: Chaynami maydiya jwisyu diya ĉhamutinqa, chay pwibluqa kusala mas manchaypaqta kastigakasha kanqa chay pwiblu Sodomawan Gomorra kastigakashanmanmatapis nir”. ");
INSERT INTO qufNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jesusqami yaĉhakuqninkunataqa niranpis: “¡Kwintata qukayllapa! Nuqami qamkunata kaĉhashurllapaqa uyshakunata surrukunapa rurinta kaĉhaq yupay kaĉhashuyanillapa. Chaymi qamkunaqa ima katinpis imanutaq largu kurumaqa dasla tantyan chaynu kankillapa. Piru chaynu tantyarmapismi imanutaq uk palumitamaqa mana ima mana allintapis ruranchu chaynu kankillapa. ");
INSERT INTO qufNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Allita kuytakankillapa. Chaqa qamkunataqami karguyjunkunaman qukushunqallapa. Chaynulla chay tantakananllapa wasikunapimi wipyashunqallapa ima. ");
INSERT INTO qufNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Chaynulla nuqaraykuqami chay karguyjunkunaman, gubyirnukunaman ima apashunqallapa. Piru qamkunaqa paykunapa naypanpi chaynulla chay mana Israel runakunapa naypanpimapis nuqallapaq rimankillapa. ");
INSERT INTO qufNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Chaynu paykunapa naypanpi karnaqa, amami yarpupakunkillapachu, imatami rimashaq, manaqa imanumi rimashaq nirmapis. Chaqa rimanaykillapapaqna katkillapaqami Dyus yanapashunqallapa imata ninaykillapapaqmapis. ");
INSERT INTO qufNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Chaynuqami mana qamkunallachu rimayankillapa kanqa. Ashwanmi Taytaykillapa Dyuspa Ispiritunmi rimachishunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Chaymi nishaykillapapis: Mayqanpismi ukninta qukuyanqa wanuchinanllapapaq. Nataq taytanllapa-shuypaqa wamrankunata qukuyanqa wanuchinanllapapaq. Chaynulla wamrakuna-shuypaqa taytanpa kuntran tikrakar wanuchinqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Chaymi tukuyla kay pachapiqa nuqapi kriyishaykillaparayku ĉhiqnishunqallapa. Piru chaynu qischakar imamapis maydiya shamunaykaman shachinakuq kaqkunalami washakanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Chayraykumi uk pwiblupi katkillapa mana allinta rurashunanllapapaq ikikillapapi puritinqa, uklaw pwiblukunaman alsakayllapa. Chaqa chiqaptami nishaykillapa: Manaraq chay Israel pwiblukunapi yaĉhachikur tukchiyatkillapami Dyusmanta Shamuq Runaqa shamunqana nir. ");
INSERT INTO qufNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Manami mayqan yaĉhakuqpis maschu chay yaĉhachiqninmantaqa. Chaynulla mayqan sirbikuqpis manami maschu patrunninmantaqa. ");
INSERT INTO qufNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Chaymi chay mayqan yaĉhakuqpis chay yaĉhachiqninnula kayta puytin mana maschu. Chaynulla chay sirbikuqpis imanutaq patrunninmaqa chaynula kayta puytin. Chaqa nuqatami nimanllapa dyablupa mantaqnin Beelzebú nir. Chaymi qamkuna nuqapa yaĉhakuqniy kashaykillaparaykumaqa ashwan ima nishuyanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Piru chaynu katinmapis amami chay runakunataqa manchankillapachu. Chaqa tukuy imapis pakaplla kaqkunaqa manami pakapllaqa kidayta puytinchu. Chaymi tukuy pakaplla kaqtaqa allita yaĉhakanqa. ");
INSERT INTO qufNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Chayraykumi nuqa qamkunata uyarala willashushayllapataqa, tukuylata parlayllapa. Chaynulla chay pakaqnula willashushayllapatapis intrachikunkillapa, tukuypa naypanpi. ");
INSERT INTO qufNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Chaymi chay mayqan wanuchishunatinllapapis ama manchankillapachu. Chaqa wanuchishurllapamapismi kwirpuykillapalata wanuchinqallapa. Ashwanmi manchankillapa chay kwirpuykillapawan almaykillapata tukuy tyimpupaq ninapi qischakananpaq kaĉhaq chayta. ");
INSERT INTO qufNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Piru qamkunataqami Taytanchik Dyusqa kusalata munar kuytashunllapa. Ma willamayllapa: ¿Manachu ishkay pariq kuritukunata uk qillaysitulapaqmapis rantikunllapa? Chaynu paykuna yanqa mana sirbiq katinmapismi, Taytaykillapa Dyus pachaman ratar wanunqa nitin, ratar wanuymatapis puytin, manaqa mana. ");
INSERT INTO qufNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Chaynu kuritukuna yanqa mana sirbiq katinmapis kusa allita kuytarqa, qamkuna chay kuritukunamanta mas sirbiq kashaykillaparaykuqa ¿imanunari mana kuytashunqallapa? Chaqa payqami aqchaykillapamatapis uklapi uklapi allita yupasha purichiyan. Chaynu katinmi ama imalapaqpis manchakunkillapachu. ");
INSERT INTO qufNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Chayraykumi mayqanpis tukuypa naypanpi, nuqapaq mana pinqakur faburniy rimatinqa, nuqapis paykunapaqqa allinta rimashaq, unaq syilupi Taytaypa naypanpiqa. ");
INSERT INTO qufNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Piru mayqanpis tukuypa naypanpi, nuqata mana kwintachamatin-shuypaqa, nuqapis paykunataqa mana kwintachashaqchu unaq syilupi Taytaypa naypanpiqa. ");
INSERT INTO qufNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Amami yarpunkillapachu: Jesucristo shamushanraykumi mana qischakashunllapanachu nirqa. Chaqa nuqa shamushayraykumi mana shumaqnachu kawsankillapa. Ashwanmi nuqarayku kusala ĉhiqninakuy, maqanakuy imana kanqa. ");
INSERT INTO qufNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Chaymi uk ullqu wamramaqa taytanpa kuntran tikrakanqa. Chaynulla uk warmi wamrapis mamanpa kuntranna tikrakanqa. Nataq uk llunchu-shuypaqa swigranpa kuntranna tikrakanqa. ");
INSERT INTO qufNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Chaynumi nuqaraykuqa mayqanpapis ayllunkunalla kuntranqa tikrakanqa. ");
INSERT INTO qufNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Piru mayqanpis nuqamanta masta taytanta, manaqa mamanta munaqqa, manami nuqapa kananpaqqa allinchu. Chaynulla mayqanpis uk ullqu wamranta, manaqa uk warmi wamranta masta nuqamanta munaqqa, manami nuqapa kananpaqqa allinchu. ");
INSERT INTO qufNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Chayraykumi mayqantapis nuqapi kriyishanrayku kruspi wanuchinar qischatinllapa manchakur mana nuqallawan purinaqkunaqami manana nuqapa kananpaqqa allinchu. ");
INSERT INTO qufNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Chaymi mayqanpis bidanpaq llakir washayta kamaqkunaqa limpu chinqanqallapa. Piru chay mayqanpis nuqapi kriyishanrayku wanuq chayqami washakashana rikarinqa. ");
INSERT INTO qufNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Chayraykumi mayqanpis qamkunata shumaqta samachishurllapaqa, nuqata samachimayan. Nataq mayqanpis nuqata samachimaq-shuypaqa, chay mayqanĉhi kaĉhamasha chayta samachiyan. ");
INSERT INTO qufNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Chaymi mayqanpis ukta Dyuspa rimaqnin kashanrayku samachiqqa, Dyus paypa rimaqninta imataĉhi quyanqa chayllatami aypanqa. Chaynulla uk allin runata allin kashanrayku samachiq-shuypaqa, chay allin runata imakunata Tayta Dyus quyan allin kashanrayku, chayllatami aypanqa paypis. ");
INSERT INTO qufNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Chaymi mayqanpis chay sirbimaqniy kashanrayku mana kwintachaypaqla kaqkunata uk jarru qasaq yakituta upyachiq chayqami, kusa shumaq allin imakunata aypanqa Dyusmantaqa”. ");
INSERT INTO qufNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesús chaynu dusi yaĉhakuqninkunata yaĉhachir tukchirnaqa, chay kayashanmanta lluqshir riran, chay pwiblupa uklaw lugarninkunaman Dyus nishankunata parlakur yaĉhachikuq. ");
INSERT INTO qufNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Piru Shutichikuq Juan, karsilpi karqami, yaĉharan imatami Cristo rurar puriyan nir. Chaymi chaynu yaĉharqa, wakin yaĉhakuqninkunata kaĉharan ");
INSERT INTO qufNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Jesusta tapunanpaq: —¿Qamchu Dyusmanta shamunanpaq karan chay kanki, manaqachu uktaraq yarayashaqllapa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Chaymi Jesusqa niran: —Rir Juantaqa willayllapa, kay rikayashaykillapata, uyapayashaykillapata ima. ");
INSERT INTO qufNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Willankillapapismi: ‘Syigukunatapis rikakuchin, kujukunatapis alliyachitin purinllapa, ismuyaq aychayjunkunatapis alliyachin nir. Chaynulla upakunatapis uyakuchin, wanushakunatapis kawsachimun, chay mana imayjun kaqkunatapis willan imanu washakananllapapaq’ nir ima. ");
INSERT INTO qufNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Chaynulla willankillapapis: ‘¡Kusa shumaqmi kanqallapa nuqapi kriyishanrayku imakuna rikarir trumpisachinatin mana maydiyapis qunqamaqkunaqa nin!’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Chaymanta Juanpa yaĉhakuqninkuna ritinnaqa, Jesusqa chaypi kaq runakunata qallariran Shutichikuq Juanpaq parlaq, kaynu nir: “¿Imata rikakuqtaq qamkunaqa riraykillapa chay chunllaq lugarmanqa? Imanutaq uk runa mana uklapi yarpuqmaqa uk yura shukchata wayra wakman kayman kuyuchiq yupay ¿chayta rikakuqchu riraykillapa? ");
INSERT INTO qufNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Manaqachu, uk runa kusala ĉhaniyjun mudanata, mudakushata rikakuq riraykillapa? Qamkunaqami yaĉhankillapa chaynu mudakuqkunaqami, chay gubyirnupa wasinkunalapi tanllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Chaqa, ¿imata rikakuqtaq riraykillapa? ¿Dyuspa rimaq runata rikaq? Chiqaptami qamkunaqa Dyuspa rimaqninkunamantaqa nuqapaq kusa mas intrachikuqta rikaq riraykillapa. ");
INSERT INTO qufNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Chaqa Shutichikuq Juanpaqmi, Dyus nitin iskribikashakunapiqa kaynu niq: ‘Nuqami qampa naypaykita ukta kaĉhashaq, imanutaq nanta kiĉhar kamkachinllapa chaynu qampaq yaĉhachikunanpaq’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Chiqaptami nishaykillapapis: Kay pachapi runakunaqami Shutichikuq Juanmanta masqa mana kashachu uklamapis. Piru chaynu katinmapis syilumanta kaq mantakuqpi kriyiqkunaqa mana kwintachaypaqla karmapis Juanmantaqa kusala masna kanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Chaynumi Shutichikuq Juan yaĉhachikuq qallarishanmanta kanankamanmi syilumanta kaq mantakuqpi kriyiqkunapa ikinpi kusala achka marraju runakuna purinllapa limpu imanachiyta yarpur. ");
INSERT INTO qufNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Chaynullami nishaykillapapis: Dyusninchikpa rimaqninkuna chaynulla Dyus nitin Moisés mantakushankuna imaqami syilumanta kaq shamur mantakunanpaqqa Shutichikuq Juan shamunankalaman intrachimaranchikllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Chaymi qamkuna Shutichikuq Juanpaq, Dyuspa rimaqnin Elías shamunanpaq karan nir kriyinarqa kriyiyllapari. ");
INSERT INTO qufNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Chayraykumi tukuy rinriyjun kaqkuna, allita intrakanarqa uyakur intrakayllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“¿Imawantaq kumparayman kay tyimpupi kaq runakunataqa? Kay runakunaqami, wamritukuna plasapi tar kaynu qayapanakunllapa chay yupay: ");
INSERT INTO qufNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Kinakunatami waqachirayllapa. Piru qamkunaqami mana bayliraykillapachu. Chaynulla llakiypaq takikunata takitiyllapapis, mana waqaraykillapachu’ ninakun chaykuna yupay. ");
INSERT INTO qufNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Chaymi qamkunapis wamritukuna yupay, Shutichikuq Juan shamur kusata ayunatin, chaynulla mana binuta upyatinqa niraykillapa: ‘Juanqami dyablupa yarpuyninwan’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Chaymanta nuqa Dyusmanta Shamuq Runa kar, mikutiy upyatiy-shuypaqa qamkunaqa ninkillapa: ‘Kusala amryintu, upyalun’ ima nir. Chaynulla ninkillapapis: ‘Payqa chay Romapaq impwistuta kubrakuqkunapa amigun chaynulla uchasapa runakunapa amigun’ nir ima. Piru nuqapi kriyishanllaparayku Dyus munashanta rurar kawsaqkunami intrachikunllapa nuqaqami chiqapta Dyusmanta shamusha kani nirqa”. ");
INSERT INTO qufNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jesús chay pwiblukunapi achka milagruta rurasha katinmapis manami kriyinaranllapachu. Chaymi chay runakunataqa anyaqnulla kaynu nir willayaq: ");
INSERT INTO qufNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“¡Ay Corazín pwiblu! ¡Ay Betsaida pwiblu! Kay milagrukunata qamkuna rikanaykillapapaq rurasha kani, chay milagrukunata Tiro shutiq pwiblupi, Sidón pwiblupi rurasha katiymaqa, paykunaqa aykapina uchankunata dijar, saqalla raĉhpanllapata yakakur, uĉhpata umanllapaman itar ima kriyishana kanmanllapa Dyuspiqa. ");
INSERT INTO qufNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","“Piru chay jwisyu diya ĉhamutinqa, chay Tiro pwiblumanta, chaynulla chay Sidón pwiblumantaqa kusala mas manchaypaq kastigu kanqa qamkunapaqqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Qamkuna Capernaúm pwiblupi taqkuna, ¿yarpunkillapachu washakar syiluman riyankillapa kanqa nir? Ashwanmi qamkunaqa chay tukuy tyimpupaq kastigakanaykillapapaqna itakukankillapa. Chaqa chay Sodoma pwiblupi imanutaq kay Capernaúm pwiblupi yupay rurar rikachisha katiyqami, chay pwibluqa kanankaman kayanmanraq. ");
INSERT INTO qufNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Piru nishaykillapa: Chay jwisyu diya ĉhamutinqa, qamkunapaqqa kusala mas manchaypaq kastigu kanqa chay Sodoma pwiblupi kayaq chaymantaqa nir”. ");
INSERT INTO qufNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Chaymanta Jesusqa niran: “¡Taytay! Qammi kay pachapa, unaq syilupa amun kanki. Chayraykumi alabashuni. Chaqa qamqami kananqa chay mana kwintachaypaqla kaq runakunata intrachishayki unay chay kusa yaĉhaq, kusa intrakaq runakunata pakar mana intrachishaykitaqa. ");
INSERT INTO qufNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Chaynumiri Taytituy. Chaqa qam munashaykinumi kananpaq kasha”. ");
INSERT INTO qufNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Chaynullami wakinninkunatapis niran: “Taytaymi tukuy imata qumasha rikanaypaq. Chaqa manami mayqanpis allita nuqataqa riqsimanchu. Ashwan Taytaylami riqsiman. Chaynulla, manami mayqanpis allitaqa Taytaytapis riqsinllapachu. Nataq nuqa Wamranlami riqsini. Chaynu Wamran kashayraykumi mayqantapis riqsichinashaytaqa riqsichiyta puytini. ");
INSERT INTO qufNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Piru tukuy qamkuna uchaykillaparaykuqa imanutaq trabajarmaqa shaykunkillapa, chaynulla imanutaq shipuykillapata aprikurmaqa shaykunkillapa chaynu kaqkuna, shamuyllapa nuqaman. Nuqami samachishaykillapa. ");
INSERT INTO qufNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Chaqa nuqamanta yaĉhakuqkunaqami nuqawan yuntakasha yupayna. Chaymi nuqa yupaylla kayta yaĉhakuyllapa. Chaqa nuqaqami ima katinpis mana das piñakur imachu, ashwan kusa shumaqlata ima intrachikuni. Chaynu nuqawan karqami kusala shumaqta tukuy tyimpupaq almaykillapapi samankillapa. ");
INSERT INTO qufNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Piru chay tukuy imata ruranaykillapapaq nishuyanillapa chayqa manami kusala llashaq imachu. Ashwanmi imanutaq uk yugumaqa kusa ankishla chaynu”. ");
INSERT INTO qufNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Chaymi chay tyimpukunapiqa, uk samana diyapi Jesusqa trigu tarpukashapa rurinta riyaran yaĉhakuqninkunawan. Chaymantami chay, yaĉhakuqninkunaqa mallaqnar, trigupa ispiganta pitir murinta mikuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Chaynu mikuyatinllapa chay fariseo runakuna rikarqa, Jesusta niranllapa: —Rikay, yaĉhakuqnikikunaqami chay samana diyapi mana ruraypaq kaqkunata rurayanllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Chaynu nitinllapaqa, Jesusqa niran: —¿Manachu qamkunaqa liyishaykillapa, uk kuti gubyirnu David wakinninkunawan mallaqnar imanu tukuran nir iskribikashantaqa? ");
INSERT INTO qufNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Chaqa Dyusta adurananllapa tuldu wasiman yaykurmi Dyuspa kaq turtillankunata mikuranllapa. Allita yaĉhashanchikllapanu, chay turtillakunaqami, mana allinchu karan pay David chaynulla wakinninkunamapis mikunanpaqqa. Chaqa chay turtillakunataqami chay kurakunala mikunanllapapaq kaq. ");
INSERT INTO qufNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Chaynulla, ¿manachu Moisés mantakushanta liyirqa intrakashaykillapa, Dyusta adurananllapa wasipi kurakuna samana diyapi, mana samarmapis mana uchakuranllapachu nirqa? ");
INSERT INTO qufNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Piru nuqaqami Dyusta adurananllapa wasimantaqa kusala mas allin kani. ");
INSERT INTO qufNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Chaynuqami qamkunaqa Dyus nitin iskribikashankunataqa mana intrakashaykillapachu. Chaqa ninmi: ‘Nuqaqa manami munanichu animalkunata wanuchir ufrindita nir nuqaman apamunanllapataqa. Ashwanmi munani wakinkunata llakipar ima ministishanpipis yanapananllapapaq’ nir. Chaqa chayta allita intrakasha karllapaqa manami yanqallaqa chay wakin runakunataqa uchachanaykillapatanachu. ");
INSERT INTO qufNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Chaqa Dyusmanta Shamuq Runami chay samana diyapiqa imata ruraypaq chaynulla mana ruraypaqchu niytaqa puytin. ");
INSERT INTO qufNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesusqami chaymanta rirqa, chay tantakananllapa wasiman yaykuran. ");
INSERT INTO qufNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Chaypimi uk runa wiqru makiyjun karan. Chaymi chay fariseo runakunaqa imanullapis uchachayta yarpur kaynu nir Jesustaqa tapuranllapa: —¿Allinchu kanqa uk qishaqta samana diyapi allichanapaqqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Chaynu taputinllapami Jesusqa niran: —Qamkunamanta uknikillapapa kanman uk uysha. Chaymanta chay uyshaqa samana diyapi uk uĉhku ruriman ratanman. ¿Samana diya kashanraykuchu mana rinman lluqshichimuqqa? ");
INSERT INTO qufNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Chaqa, ¡uyshamantaqami uk runaqa kusala masta sirbin! Chayraykumi samana diyapimapis shumaq kaqta rurananpaq kusala allin. ");
INSERT INTO qufNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Chaynu nirnaqami, chay wiqru makiyjun runataqa Jesusqa niran: —Chutarachiy makikita nir. Chaynu nitin, chutarachitinqa makinqa uklaw makin yupay kusa allilanna kidaran. ");
INSERT INTO qufNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Piru, chaynu ruratinmapis, chay fariseo runakunaqa waqtaman lluqshimurqa parlaranllapa Jesustaqa imanullapis wanuchinanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Chaynu wanuchinayanllapa nir yaĉharmi Jesusqa chay kayashanmantaqa riranna. Chaynu ritinmi kusala achka runakuna ikinta riranllapa. Chaqa Jesusqami paykunapa tukuy qishaqninllapata allichaq. ");
INSERT INTO qufNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Chaynu allicharqami, chay runakunataqa willaran, ama mayqantapis parlananllapapaq mayqanmi allichamasha nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tukuy kaykunaqami chaynuqa pasaran Dyuspa rimaqnin Isaías kaynu nishan kumplikananpaq. Chaqa niqmi: ");
INSERT INTO qufNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Kaypimi sirbimaqniyqa. Paytami kusata munar akrasha kani. Paywanmi kusata aligriyani. Chaymi paytaqa Ispirituyta qushaq, tukuy pwiblukunapi intrachikunanpaq nuqa munashaykunata rurar kawsananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Chaqa manami imapaq mayqanwanpis willanakunqachu. Chaynulla manami rimapakunqapischu nublirukuna yupayqa. Manami mayqanpis uyapanqachu waqtakunapi alabakaqtaqa. ");
INSERT INTO qufNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Chaynulla kaña qiwikasha yupay kaq runakunataqami shumaqlata kuytanqa. Chaynulla chay wanuqnula lamparita ratakuq yupay runakunatapis shumaqlata kuytanqa, Dyus tukuy munashankuna kumplikanankaman. ");
INSERT INTO qufNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Chaymi tukuyla pwiblukuna, paylapi kusata kunfyakar yarakunqallapa”. ");
INSERT INTO qufNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Chaymantaqami ukkunapis Jesusman aparanllapa uk syigu mudu runata. Chaqa chay runaqami dyablupa yarpuyninwan karan. Piru Jesusqami chay runataqa rikakuchiran, chaynulla rimachiran ima. ");
INSERT INTO qufNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Chaymi chay rurashanta rikarllapaqa tukuy chaypi kaqkunaqa dispantakashalla kaynu nir tapunakuyaqllapa: “¿Kaychu unay gubyirnu Davidpa ayllunmanta shamur washamanallapapaq karan chay kanqa?” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Chaynu niqta uyaparllapami chay fariseo runakunaqa niranllapa: “Chay dyablupa mantaqnin Beelzebú shutiqmi, wak runataqa pudirninta qusha runakunamanta dyablupa yarpuyninkunata itakunanpaqqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Piru Jesusqami, paykuna imatami yarpuyan nir yaĉhashanrayku kaynu niran: “Mayqan pwiblupis paykunapura ĉhiqninakurqa wakman kayman limpu chiqanchakar tukukanllapa. Chaynulla uk taksha pwiblitu, manaqa uk ayllupis paykunapura ĉhiqninakurqa mana shumaqta kawsaytaqa puytinllapachu. ");
INSERT INTO qufNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Chaynullami dyablupis, uk dyablu masinta itakurqa, ukninta itakushanrayku manami allinchu. Chaynu rurarqa, ¿imanuna kusata mantakuytaqa puytinmanllapa? ");
INSERT INTO qufNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Qamkunaqami ninkillapa nuqapaq, ‘Beelzebú pudirninta qusha katin dyablupa yarpuyninta runakunamanta itakun’ nir. Chaynu katinqa, ¿qamkunamanta wakinnikillapaqa mayqanpa pudirninwantaq dyablupa yarpuynintaqa itakun? Chaqa paykunallami intrachimanchik qamkunaqashi limpu pantasha puriyankillapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","“Allita kwintata qukayllapa: Nuqaqami dyablupa yarpuynintaqa runakunamanta itakuni Dyuspa Ispiritunpa pudirninwan. Chaynuqami intrachimanchik, Dyuspa mantakuyninqami qamkunamanqa ĉhamushana nir. ");
INSERT INTO qufNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Chaqa allita yarpuyllapa: Uk kusala pulsuyjun runapa wasinman mayqanpis suwakuq yaykunarqami, chay wasipa amunta puntataqa wataytaraq ministiyan. Chaynu wataraqmi suwaytaqa puytiyan, manaqa mana. ");
INSERT INTO qufNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Chaymi nishaykillapa: Nuqapaq mana allinta rimaqqami nuqapaqa kuntray. Chaynulla nuqawan mana tantakuqpismi ashwan shikwakun. ");
INSERT INTO qufNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Chayraykumi nishaykillapa: Tukuy runa uchakushanta chaynulla Dyuspaq mana allinta rimashantaqa Dyusmi pirdunanqa. Piru Santu Ispiritupaq mana allinta rimashanllapata-shuypaqami mana pirdunanqachu. ");
INSERT INTO qufNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Chaynullami Dyusqa pirdunanqa paymanta Shamuq Runapaq mana allinta rimatinllapamapis. Piru Santu Ispiritupaq mana allinta rimaqta-shuypaqami mana pirdunanqachu kanan tyimpukuna chaynulla maydiyapis. ");
INSERT INTO qufNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Chaqa uk qiru allin kaqqami shumaqta puqun. Nataq chay mana allin qiru kaq-shuypaqami mana allintachu puqun. Chaynumi mayqan qirutapis puquyninmanta riqsinchik allin qiru, manaqa mana allin qiruchu nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Largu kurukunapa ayllun! ¿Imanunari allin kaqtaqa rimayta puytinkillapa? Chaqa qamkunallami kusala mana allin runakuna kankillapa. Chaymi ashwan shunquykillapapi kusala mana allin kaqllata shimikillapapis riman. ");
INSERT INTO qufNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","“Chayraykumi uk allin runaqa allinlata riman, allin kaqkunala shunqunpi kashanrayku. Piru chay mana allin runaqami mana allin kaqkunalata riman, tukuy mana allinkunala shunqunpi kashanrayku. ");
INSERT INTO qufNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Chaqa nuqaqami nishaykillapa: Chay jwisyu diya ĉhamutinqami tukuy mana allinta rimashaykillapanulla allita rikar yaĉhakashana kankillapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Chaymi chay diyaqa, allinta rimashaykiraykuqa allinpaqna riqsikanki. Nataq mana allinta rimashaykirayku-shuypaqa kastigakaqna rinkillapa”. ");
INSERT INTO qufNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Chaynu nitin wakin fariseo runakuna, chaynulla Moisés mantakushankunapaq yaĉhar yaĉhachikuqkunaqa, Jesusta niranllapa: —Yaĉhachikuq Tayta, Dyusmanta shamushayki nir allita yaĉhanayllapapaqqa ima milagrullatapis rurar rikachimanaykillapata munanillapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Chaynu nitinllapami, Jesusqa niran: “Kay kusala mana allin yarpuyniyjun kaq, chaynulla mana allita kriyimaq runakunaqami uk milagruta ruranaypaq mañamanllapa. Piru Dyus, unay rimaqnin Jonaswan milagruta rurashannu nuqawan ruratinmi, munarqa intrakanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Chaqa Jonasmaqami kimsa unaqta, kimsa tutata kusala atun piskadupa rurinpi katin, Dyusqa milagruta rurar lluqshichimuran, chaynullami Dyusmanta Shamuq Runapis kimsa unaqta, kimsa tutata kay pachapa rurinpi kanqa. Chaymantami Dyusqa milagruta rurar lluqshichimunqa. ");
INSERT INTO qufNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Piru maydiya chay jwisyu diya ĉhamutinqami chay Nínive pwiblumanta kaqkunaqa sharimunqallapa. Chaymi ashwan qamkuna Dyuspi mana kriyishaykillaparayku rimanqa kastigakanaykillapapaq. Chaqa chay Nínive pwiblumanta runakunaqami, Jonás Dyuspaq parlakutinqa, uchanllapata dijar kriyiranllapana. Piru kanan kay naypaykillapapi kaqqami Jonasmantaqa mas ima kar, qamkunata willashutinllapapis mana kriyinkillapachu. ");
INSERT INTO qufNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Chaynulla chay surlawmanta gubyirnapis chay jwisyu diyapiqa sharimur, qamkuna kanan tyimpupi mana kriyinaqkunapaqpis rimanqa, kastigakashana kayankillapa kanqa nir. Chaqa chay gubyirnaqami largu maymanta shamuran, Salomón kusala yaĉhayninwan yaĉhachikuqta uyakuq. Piru kay naypaykillapapi kaqqami kusa mas Salomonmanta kar yaĉhachishutinllapamapis, mana kasunkillapachu. ");
INSERT INTO qufNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Chaynullami nishaykillapapis: Uk runamanta dyablupa yarpuynin lluqshirqami, chunllaq chaki pachakunapi purin, maylapipis samananpaq maskakur. Piru mana maypipis samananpaq tarirqami, kaynuta yarpun: ");
INSERT INTO qufNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Tikrakashaq chay maymantaĉhi lluqshimushay wasiyman nir. Chaynu tikrakamurqami, chay runataqa uk shinalla wasi kusalata pichakar kamakashata yupay tarin. ");
INSERT INTO qufNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Chaynu tarirqami tikrakar rin tarimuq syiti paymanta kusala mana allin ispiritu masinkunata. Chaymantami tukuynin pulla chay runapa kwirpunmanqa yaykunllapa taq. Chaynu katinmi chay runaqa kusala llallinna tikran, punta kashanmantaqa. Chaynullami kanan, kusala mana allin yarpuyniyjun runakunatapis pasanqa”. ");
INSERT INTO qufNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Chaynu nir ima Jesús runakunata willayatinraqmi, paypa mamanwan, ukninkuna ĉharan paywan parlanar. Piru waqtalapimi kidaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Chaymi mayqanĉhi Jesusta willaran, kaynu nir: —Mamaykiwan, uknikikunami chay waqtapi. Qamwanmi parlanayanllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Piru Jesusqami chay willaq chaytaqa niran: —¿Mayqantaq mamayqa? ¿Mayqankunataq ukniykunaqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Chaymantami chay yaĉhakuqninkunaman rikachikur kaynu niran: —Kaykunami mamaywan, ukniykunaqa. ");
INSERT INTO qufNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Chaqa mayqanpis unaq syilupi Taytay Dyus munashanlata ruraq kaqkunami, ullqu kaq, warmi kaq ukniykunaqa, chaynulla mamaymapis nir. ");
INSERT INTO qufNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Chaymantami chay diyaqa Jesusqa chay wasimanta lluqshir rir kusala atun quĉhapa manyanpi taran. ");
INSERT INTO qufNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Chaynu kusa achka runakuna tantakayatinmi, Jesusqa uk yaku karruman iqar taran. Nataq runakunaqami chay quĉhapa manyanlapi kidaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Chaymantami Jesusqa kusa achka imakunata kumparasyunkunawan yaĉhachikuq qallarir, kaynu niran paykunataqa: “Uk runami tarpukuq riran ĉhakranman. ");
INSERT INTO qufNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Chaymantami shikwakutinqa wakin simillaqa nanman rataran. Chaymi pariq kurukuna shamur mikuran chay simillataqa. ");
INSERT INTO qufNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","“Nataq wakin similla-shuypaqa rumipa ananpi yaqqa mana allpa kaqman rataran. Piru chay simillaqami daskaqla winaq qallariran, mana ruri maypi pampakashanrayku. ");
INSERT INTO qufNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Chaymantami rupay iqamutinqa mana allita ĉhupakushanrayku, daskaqla ñutukur chakiran. ");
INSERT INTO qufNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","“Nataq wakin simillakunaqami kasha rurikunaman rataran. Chaymantami kashakuna winar ĉhamitachiran. ");
INSERT INTO qufNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","“Piru wakin similla-shuypaqami rataran kusa shumaq pachaman. Chaymi kusa shumaqta winatin, kusala shumaqta kusichakuranllapa. Chaqa, wakin ispigaqami syin murisituyjun karan. Nataq wakin ispigaqa sisinta murisituyjun. Wakin-shuypaqa, trinta murisituyjun ima karan. ");
INSERT INTO qufNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Chaymi nishaykillapa: Rinriyjun kaqkunaqa uyakur intrakayllapa nir”. ");
INSERT INTO qufNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Chaymantami Jesuspa yaĉhakuqninkunaqa qimikar tapuran: —¿Imapaqtaq kumparasyunkunalawan runakunataqa yaĉhachinki? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Chaymi Jesusqa niran: “Qamkunatami Dyusqa imanumi mantakun nirqa paylla intrachishuyanllapa, michka unay mana intrakasha katinllapamapis. Piru wakin runakunata-shuypaqa mana. ");
INSERT INTO qufNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Chayraykumi nini: Dyuspi intrakaqkunataqa masta intrachinqa, kusa intrakaq kananllapapaq. Piru mana intrakanaqkunata-shuypaqa, chay ashlilata intrakashanmatapis tantar qunqachinqa. ");
INSERT INTO qufNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Chayraykumi kay kumparasyunkunalawan yaĉhachikuni. Chaqa, paykunaqami chapakurpis mana rikakunchu. Chaynulla uyakurpis mana intrakanllapachu. ");
INSERT INTO qufNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Chaymi paykuna chaynu katin ima, Dyuspa rimaqnin Isaías nishanqa kumplikan. Chaqa niqmi: ‘Michka kusata uyakurmapis, mana intrakanqallapachu. Chaynulla michka chapakurmapis, mana rikakunqallapachu nir. ");
INSERT INTO qufNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Chaqa kay pwiblumanta runakunapa yarpuyninqami mana intrakaqpaq tikrakasha. Chaymi rinrinllapamapis limpu kirpakasha amana uyakunanllapapaq. Chaynulla nawinllapamapis limpu kirpakasha amana rikakunanllapapaqnachu. Chaynuqami tukushallapa ama nuqapi kriyinanllapapaq. Mana nuqapaq intrakar kriyitinllapaqami, mana allichashaqmapischu’. ");
INSERT INTO qufNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Nataq qamkuna-shuypaqa kusala shumaqmi kankillapa. Chaqa nawikillapamapis allita rikakun. Chaynulla rinrikillapamapis allita uyakun ima. ");
INSERT INTO qufNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nishaykillapapismi: Chiqaptami Dyuspa rimaqninkuna, wakin kusa allin runakunapis, kanan rikayankillapa chayta, chaynulla uyapayankillapa ima chaytaqa, rikayta uyapayta ima munaqllapa. Piru paykunaqami michka chaynu munarmapis mana rikaran chaynulla uyaparanllapalamapischu. ");
INSERT INTO qufNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Allita intrakayllapa, chay kumparasyun tarpukuqpaq rimarqa imatami intrachimanchikllapa nir: ");
INSERT INTO qufNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Chaymi Dyusmanta shamur mantakuqpaq uyapar mana intrakaqqa, chay similla nanman ishkiran chay yupay. Chaymantami dyablu shamurqa, chay uyakur shunqunpi tarpusha yupay purichiyashantaqa ashuchin. ");
INSERT INTO qufNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","“Nataq chay similla rumikunapa ananman rataran chaykunaqami, intrachimanchik runakuna Dyus rimashanta kusa aligrila uyakuqpaq. ");
INSERT INTO qufNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Piru mana allita ĉhupakusha karmi, mana shachinakuytaqa puytinchu. Chayraykumi Dyuspi kriyishanrayku imallapiqa qischakar, manaqa imanachinanllapapaq ikinllapapi puritinqa chay uyakushanta dijarna qunqanllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“Nataq chay simillakuna kashapa rurinman ishkishakuna-shuypaqa, intrachimanchik Dyuspa rimayninta uyapaqkunapaq. Piru kay pachapi imanupis kusa imayjun kanar, imakunapi yarpupakur imaqa, Dyusmanta ashunllapa. Chayraykumi, chay munashankuna, yarpupakushankuna ima, paykunata ĉhamitachiq yupay qunqachin Dyuspa rimaynintaqa. Mana dijanchu puquq yupay kusa allin kananpaqqa. ");
INSERT INTO qufNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Piru chay similla kusa shumaq pachaman ishkisha-shuypaqa intrachimanchik, Dyuspa rimayninta intrakar kasuqkunapaq. Chaykunaqami, kusa achkata puqur kusichakaq yupay ima shumaqta kawsanllapa. Imanutaq wakin ispigakunamaqa, syin murisituyjun karan, wakin-shuypaqa sisinta murisituyjun, wakinqami trinta murisituyjun karan kada ispigitaqa”. ");
INSERT INTO qufNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesusqami kaynu nir kay kumparasyunta parlakuranpis: “Syilumanta kaqpa mantakuyninqami, uk tarpukuq runa shumaq simillanta tarpuran chay yupay. ");
INSERT INTO qufNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Piru tukuy punuyatinllapa, payta ĉhiqniq runa shamur shikwakuran balliku simillata chay trigupa rurinpiqa. Chaynu shikwakurqami upallala riranna. ");
INSERT INTO qufNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","“Chaymanta trigu winar ispigakutin imanaqa, chay ballikukunapis rikariranna. ");
INSERT INTO qufNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Chaymi chay trabajaqkunaqa riran amunta willaq, kaynu nir: ‘Taytituy, qam tarpushayki simillaqami kusa allin karan. ¿Maymantataq chay ballikuqa winamushaqa?’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Chay ĉhakrapa amunqa niran: ‘Mayqan ĉhiqnimaqmi chaytaqa rurasha kanqa’ nir. Chaynu nitinqa chay trabajaqkunaqa kaynu nir tapuranllapa. ‘¿Allinchu kanqa rir chay ballikuta pilar itakunayllapapaqqa?’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Piru chay amunqa niran: ‘Ama chaytaqa rurayllapachu. Chaqa chay ballikukunata pilashaq nirqami, chay trigukunatapis pilayankillapa kanqa. ");
INSERT INTO qufNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ashwanmi dijayllapa pulla winanqa chay kusichakuna tyimpu ĉhamunankaman. Chaymi chay diyaqa kaĉhakushaq chay ballikukunataqa akrananllapapaq. Chaynu akrarqami manuju manujula watar dijanqallapa rupachikananpaq. Nataq chay trigu kaqta-shuypaqami ĉhuranqallapa chay ĉhurakunaypina’ ”. ");
INSERT INTO qufNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesusqami kay kumparasyuntapis parlakuran: “Syilumanta kaqpa mantakuyninqami uk mustasa qirupa simillanta, runakuna tarpun chaynu. ");
INSERT INTO qufNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Chaqa, mustasa qirupa simillanqami kusala llampitu tukuy qirupa simillanmantaqa. Piru winarqami, kusala atunpaqna tikrakan, wakin mallkikuna ĉhakrapi kaqkunamantaqa. Chaymi ashwan pariq kuritukunamapis, chaymanna rir qushakun”. ");
INSERT INTO qufNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Chaynullami kay kumparasyuntapis parlakuran, kaynu nir: “Syilumanta kaqpa mantakuyninqami imanutaq uk warmi tantata ruraqmaqa, achkalla arinaman pitila libadurata itar dijatin saksachin chaynu”. ");
INSERT INTO qufNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Tukuy kaykunatami, Jesusqa runakunataqa willaran kumparasyunkunalawan. Manami imatapis mana kumparasyunkunawanqa willaranchu. ");
INSERT INTO qufNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Piru tukuy kaykunaqami chaynuqa pasaran Dyuspa rimaqnin unaylla nishankuna kumplikananpaq. Chaqa kaynumi nisha kayaq: “Tukuytami kumparasyunkunawan willashaq. Chaynullami willashaqpis kumparasyunwan, Dyus kay pachata rurashanmanta-pacha imakuna pakaplla katin mana intrakayashanllapapaq ima”. ");
INSERT INTO qufNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Chaymantaqami Jesusqa chay runakunata chaypi dijar rir yaykuran uk wasiman. Chaypimi yaĉhakuqninkunaqa qimikar mañaranllapa intrachinanpaq chay balliku ĉhakrapi winasha kayaq chaypaq. ");
INSERT INTO qufNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Chaymi Jesusqa niran paykunataqa: “Chay kusala shumaq simillata tarpukuq chayqami Dyusmanta Shamuq Runa. ");
INSERT INTO qufNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nataq ĉhakra tarpukasha chay-shuypaqami kay pacha. Chaymi chay shumaq simillaqa intrachimanchik Dyus munashanta rurar mantakuyninpi kaq chaykunapaq. Nataq balliku-shuypaqami intrachimanchik dyablu munashanlata ruraqkunapaq. ");
INSERT INTO qufNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Piru chay ĉhiqnikuq kar, ballikuta tarpusha chay-shuypaqami dyablullapaq intrachimanchik. Nataq chay kusicha tyimpu-shuypaqa intrachimanchik chay jwisyu diyapaq. Chay kusichakuqkuna nir-shuypaqami intrachimanchik Dyuspa angelninkunapaq. ");
INSERT INTO qufNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Chaymi nishaykillapa: Imanutaq chay ballikukunata chiqanchanchik rupachinapaq, chaynumi chay jwisyu diyapipis wakinqa chiqanchakanqa. ");
INSERT INTO qufNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Chayraykumi Dyusmanta Shamuq Runaqa kaĉhamunqa angelninkunata, chay mantakuyashanmanta chay ukkunata uchakuchiqkunata, chaynulla chay mana allinta ruraqkunata chiqanchananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Chaynu chiqancharmi apar kusala miraq ninaman itakunqallapa. Chaymi chaypiraq kusala mana agwantaypaqta qischakar qayĉhakushanrayku kirunmatapis richyachinqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Piru mayqanpis Dyus munashannu ruraqkuna-shuypaqa, rupay yupay kusa shumaqta llipyaranqallapa Taytanllapa mantakuyashanpina. Chaymi nishaykillapa: Rinriyjun kaqkunaqami, uyakur intrakayllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Syilumanta kaqpa mantakuyninqami imanutaq uk lugarpi kusala ĉhaniyjun ima pakaplla katin mana rikanchikchu chaynu. Chaqa nishaykillapa: Mayqan runapis uk pachapi kusala ĉhaniyjun imata tarirqa mana dijayta munanchu. Ashwanmi chayllapi pampar dijar kusala aligrilla rin tukuy iman kaqkunata rantikur tikrakamur, chay pacha kusa imayjun kaqta rantin chaynu. ");
INSERT INTO qufNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Chaynulla syilumanta kaqpa mantakuyninqami, imanutaq uk nigusyantimaqa kusa ĉhaniyjun pirla shutiq rumisituta maskar purin rantinanpaq, chay yupay. ");
INSERT INTO qufNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Chaynu maskar puriyar uk kusa ĉhaniyjunta tarirqami, rir iman kaqkunatapis limpu rantikur, imanupis chay pirla shutiq rumisitutaqa rantin-ari. ");
INSERT INTO qufNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Syilumanta kaqpa mantakuyninqami imanutaq piskadukuqkunamaqa chay shikranta mar yakuman itakurqa kusala achka ukman ukman piskadukunata aypamun chay yupay. ");
INSERT INTO qufNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Chayna chay piskadukuna shikranpi untatinqa chay piskadukuqkunaqa waqtaman urqumunllapa. Chaymantaqa tar akraq qallarinllapa. Chaynami chay kusala shumaq chaykunataqa kanastanman ĉhuranllapa. Nataq chay mana shumaq kaqta-shuypaqami itakunllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Chaynullami pasanqapis chay jwisyu diya ĉhamutinqa. Chaymi chay angelkunaqa rir chay mana allin kaqkunataqa chiqanchanqa allin kaqkunamantaqa. ");
INSERT INTO qufNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Chaynu chiqancharmi chay mana allin kaqkunataqa kusalata nina ratakuqmanna itakunqa. Chaymi chaypiraq kusala mana agwantaypaqta qischakar qayĉhakushanrayku kirunmatapis richyachinqallapa”. ");
INSERT INTO qufNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Chaynu nirqa, Jesusqa tapukuran: —¿Qamkunaqachu intrakankillapa, tukuy kay nishushayllapataqa? —Intrakanillapami Taytituy— niran paykunaqa. ");
INSERT INTO qufNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Chaymantaqami Jesusqa niran: —Moisés mantakushanta uk yaĉhar yaĉhachikuqqami syilumanta kaqpa mantakuyninmanta yaĉhakurqa, uk wasipa amun yupay tukun. Chaymi chay kusa ĉhaniyjun ĉhurakushantaqa urqumun mushuq kaqkunata, unay kaqkunata ima. ");
INSERT INTO qufNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Chaynu nir ima kay kumparasyunkunata parlakurnaqami riranna chay kayashanmantaqa. ");
INSERT INTO qufNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Chaynu rirmi chay pwiblunllaman ĉharan. Chaymi chay tantakananllapa wasipi yaĉhachikuq qallariran. Chaynu yaĉhachikutinmi runakunaqa limpu dispantakasha kaynu ninakuqllapa: “¿Kayqa maypitaq yaĉhakuranqa kay kusa yaĉhayashantaqa? ¿Imanutaq chay milagrukunata rurayta puytin? ");
INSERT INTO qufNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Manachu kayqa, chay iĉhkakuqpa wamran? ¿Chaynulla manachu wakpa mamanqa María? ¿Manachu Santiagupa, Josipa, Simonpa, Judaspa uknin ima? ");
INSERT INTO qufNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Manachu paypa warmi ukninkunamapis kaypi nuqanchikkunawan tanllapa? ¿Piru chaynu katinqa, imanu kartaq tukuy wakkunata rurayta puytinqa?” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Chaynu nir ima piñakur mana kasunatinllapami, Jesusqa paykunataqa niran: “Tukuy uklaw pachapimi kusa shumaqta rikanllapa uk runa Dyuspaq rimaqtaqa. Piru chay pwiblunllapi chaynulla wasinllapi imaqami mana kasunllapachu” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Piru chay pwiblunllapiqami Jesusqa mana achka milagrukunataqa ruraranchu. Chaqa chaymanta kaq runakunaqami mana paypiqa kriyiqllapachu. ");
INSERT INTO qufNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Chaymantaqami chay tyimpukunapiqa Galilea pwiblupa mantaqnin, Herodesqa uyaparan Jesuspaq kusata rimaqllapata. ");
INSERT INTO qufNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Chaymi chay sirbiqninkunataqa niran: “Chay Jesusqami, Shutichikuq Juanlla kanqa. Chaqa wanushanmanta kawsamushanraykumi milagrukunamatapis rurayta puytiyanqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Chaqa Shutichikuq Juanmi naypaqllata Herodestaqa kaynu nisha kayaq: “Chay ukniki Felipipa warmin Herodiasta warmikita yupay purichiyashaykiqami mana allinchu”. Chaynu nishanraykushi Herodesqa kusalata piñakur kaĉhakuran aypar kadinakunawan watar karsilman itananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodesqashi, Shutichikuq Juantaqa kusalata wanuchiyta munaq. Piru runakunata mancharshi mana wanuchiytaqa puytiqchu. Chaqa tukuylashi kriyiqllapa Juanqa Dyuspa rimaqnin nir. ");
INSERT INTO qufNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Piru uk diyapishi Herodespa kumpliyañun karan. Chayshi fyistata ruratinllapa, chay Herodiaspa warmi wamranqa tukuyla chaypi kaqkunapa naypanpi lluqshir bayliran. Chaynu baylishanshi Herodestaqa kusalata gustaran. ");
INSERT INTO qufNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Chayshi ashwan Herodesqa chay intinadantaqa jurar arniran imata mañamatkipis qushayki nir. ");
INSERT INTO qufNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Chaymantaqashi maman chay warmi wamranta animachitin Herodestaqa kaynu niran: “Shutichikuq Juanpa umanta uk platupi qumay” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Chaynu nirqashi gubyirnu Herodestaqa kusalata llakichiran. Piru chaynu llakiyarmapisshi, chaypi kaqkunapa naypanpi jurar arnishanrayku kaĉhakuran chaynu rurananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Chayshi kaĉhakuran Shutichikuq Juanpa umanta chay karsilpi pitinanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Chaymantaqashi uk platupi apar, chay warmi wamrataqa quranllapana. Nataq chay wamraqashi mamantana ashwan quran. ");
INSERT INTO qufNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Chaymantanashi, Shutichikuq Juanpa yaĉhakuqninkunaqa ĉhar, Juanpa kwirpunlatana aparanllapa pampaq. Chaymanta-shuypaqa riranllapa Jesusta willaq chay pasashanpaqqa. ");
INSERT INTO qufNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Chayta yaĉharmi Jesusqa uk yaku karruman iqar uk chunllaq lugarman riran. Piru achka runakunami yaĉharanllapa Jesusqa risha nir. Chaymi chay pwiblukunamanta lluqshir ĉhakpala riranllapa Jesuspa ikintaqa. ");
INSERT INTO qufNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Chaymanta Jesusqa chaynu riyar yaku manyanman ĉharqa, yaku karrumanta ishkiran. Chaynu ishkirmi kusala achka runakunata rikaran. Chaymi paykunata llakipar tukuy qishaqninkunata apashanllapataqa limpu allicharan. ");
INSERT INTO qufNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Piru limpu tardiyayatinnaqami chay yaĉhakuqninkunaqa qimikar kaynu niranllapa: —Kay lugarpiqami mana imapis kanchu. Chaynulla kusa tardinami. Chayraykumi runakunataqa willay chay pwiblukunaman rir mikunanllapata rantinanllapapaq nir. ");
INSERT INTO qufNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Chaynu nitinllapami Jesusqa niran: —Manami allinchu rinanllapapaqqa. Ashwan qamkuna paykunataqa qarayllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Chaynu nitinqa, paykunaqa niranllapa: —Kaypiqami kay sinku tantitawan, ishkay piskaditumantaqa mana masqa imapis kanchu, nir. ");
INSERT INTO qufNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesusqa niran: —Apamuyllapa kayman. ");
INSERT INTO qufNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Chaymantami chay achka runakunataqa chay qiwakunalapi tananllapapaq niran. Chaynu nisha karnaqami, chay sinku tantitawan, ishkay piskadituta aypar unaq syiluman chapakur payji nir, Taytan Dyusman mañakuran. Chaymantami chay tantakunata pidasu pidasu pakir yaĉhakuqninkunata quran tukuyla chaypi kaqkunata aypachinanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Chaynumi tukuyla mikuranllapa tiqllananllapakaman. Chaymantami yaĉhakuqninkunaqa chay mikuypa subrankunataqa ashwan dusi kanasta untata tantaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Piru chay mikusha chaykunata yupatinllapaqami ullqukunala sinku mil (5,000) karanllapa. Nataq warmikunawan wamrakunataqami mana yuparanllapanachu. ");
INSERT INTO qufNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Chaymanta, Jesusqa yaĉhakuqninkunata yaku karruman iqachiran rir ĉhaskinanllapapaq quĉhapa uklaw manyanman paymantaqa naypaqta. Nataq payqa chaylapi kidaran tukuyla dispidikur rinanllapakaman. ");
INSERT INTO qufNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Chaynu dispidikur ritinllapanaqa, Jesusqa uk sirkaman payla iqaran, Taytanman mañakuq. Chaymi limpu amsayatinnamapis payla chaypiqa karan. ");
INSERT INTO qufNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Nataq chay yaku karru-shuypaqa kusa largutana risha karan yaku anantaqa. Piru naypanllapalawmanta kusala jwirti wayra shamuyashanraykumi yaku karrutaqa, yaku kusalata maqchiyaran. ");
INSERT INTO qufNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Limpu achkiyaqpinaqa, Jesusqa yaku ananllata riran yaĉhakuqninkunalawman. ");
INSERT INTO qufNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Chaynu yakupa ananta riqta rikarmi yaĉhakuqninkunaqa kusalata manchakur “¡Wakqami aya!” nir kusata qayĉhakuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Piru Jesusqami paykunataqa kaynu niran: —¡Shachinakur ama manchakuyllapachu! ¡Nuqami kani! nir. ");
INSERT INTO qufNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Chaymantami, Pedruqa kaynu niran: —Taytituy, qam karqa mantakuy nuqa yakupa ananllata qamman shamunaypaq nir. ");
INSERT INTO qufNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Chaymi Jesusqa niran: —Shamuy-ari nir. Chaynu nitinmi Pedruqa yaku karrumanta ishkir yakupa ananllata riq ĉhurakaran Jesús kayashanlawman. ");
INSERT INTO qufNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Piru kusala jwirti wayra shamur yakuta maqchiyashanraykumi kusalata manchakuran. Chaymi ashwan chay kutilla limpu chinqaq qallarir, kaynu nir qayĉhakuran: —¡Yanapamay Taytituy! nir. ");
INSERT INTO qufNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Chaymi chay kutilla Jesusqa makinmanta aypamur niran: —¡Manami qamqa allitaqa kriyinkiraqchu! ¿Imapaqtaq mana allita kriyirayki? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Chaynu nir chay yaku karruman ishkantin iqatinllapaqa, wayraqa qasillaranna. ");
INSERT INTO qufNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Chaymi, chay yaku karrupi kaqkunaqa, Jesuspa naypalanpi qunqurikur kaynu niranllapa: —¡Chiqaptami qamqa Dyuspa Wamran kanki! nir. ");
INSERT INTO qufNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Chaymantami Jesusqa yaĉhakuqninkunawan pulla chay quĉhallata rir pasar, ĉharanllapa Genesaret lugarmanna. ");
INSERT INTO qufNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Chaynu ĉhatinllapami chay lugarmanta kaqkunaqa tukuyla Jesustaqa riqsiranllapa. Chaymi, tukuy chay lugarpi parlakutinllapa, yaĉharanllapana Jesuspaqqa. Chaynu yaĉharllapami tukuy qishaqninllapata aparanllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Chaymi kusalata Jesustaqa rugaranllapa raĉhpanpa manyanlamatapis kamananllapapaq. Chaynumi chay raĉhpanpa manyanta tukuy kamaqkunaqa allinna kidaqllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Chaymantami Jesusman qimikaranllapa Moisés mantakushanta yaĉhar yaĉhachikuqkuna, fariseo runakuna ima. Paykunaqami Jerusalenmanta ĉhamusha karanllapa. Chaymi kaynu nir tapuranllapa: ");
INSERT INTO qufNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Imapaqtaq yaĉhakuqnikikunaqa unay rukunchikkunapa kustumrinta mana kasunllapa? ¿Imapaqtaq mikunanllapapaq karqa, naypaqtaqa mana makinllapataqa paqan? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesuspismi tapuran: —¿Imapaqtaq qamkunapis chay kustumrikillapalata rurar Dyus munashantaqa mana rurankillapa? ");
INSERT INTO qufNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Chaqa Dyusqami niran: ‘Taytaykita mamaykita kusa rispituwan kasuyllapa. Chay mayqanpis taytanta mamanta ĉhiqniqkunaqami wanuchikasha kanqallapa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Piru qamkunaqami ninkillapa, uk runaqa niyta puytin taytanta mamanta: ‘Manami yanapashuyta puytinichu. Chaqa tukuy imay kaqkunatami arnisha kani Dyusta’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Mayqanpis chaynu niqqa, manami taytanta mamantaqa rispitayanllapanachu. Chaymi nishaykillapa: Qamkunaqami Dyus nishanta mana kasunkillapanachu, qamkunapa kustumrikillapalata rurar kawsanaykillapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Dyusta yanqa kasuq tukuq kuchi runakuna! Waknupaqĉhi Dyuspa unay rimaqnin Isaiasqa, qamkunapaq rimaran. Chaqa niqmi: ");
INSERT INTO qufNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Kay pwiblumanta runakunaqami shiminllapalawan kasumanllapa. Piru yarpuyninllapapiqami mana chiqaptaqa kasumanllapachu. ");
INSERT INTO qufNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Chayraykumi yanqalla aduramaqllapa yupay tukunllapamapis. Chaqa chay yaĉhachikuyashan chaykunapis yanqa runakunapa yaĉhachikuyninla imami’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Chaymantami Jesusqa runakunata qayamur kaynu niran: —Allita uyakur intrakayllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Chaqa nishaykillapa: Mayqanpis ima mikuyta mikushanraykuqa manami uchayjun kaytaqa puytinchu. Ashwanmi mayqanpis yarpuyninllapapi mana allinta yarpur rimar uchakuytaqa puytin. ");
INSERT INTO qufNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Chaymantami Jesuspa yaĉhakuqninkunaqa qimikar kaynu nir willaranllapa: —¡Taytituy! Chay fariseo runakunaqami qam chaynu nitki uyaparqa kusata piñakuranllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Piru Jesusqami paykunataqa niran: —Ima qirutapis, syilumanta Taytay, mana tarpusha katinqami, ĉhupanmanta pilar itakukanqa. ");
INSERT INTO qufNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Chaynu piñakutinllapamapis ama kwintachayllapachu. Chaqa paykunaqami imanutaq uk syigumaqa, mana rikakuq masinta kaylata kaylata rishun nin mana rikakurmapis, chaynu paykunapis. Allita yaĉhashanchikllapanu, uk syigu mana rikakuq masinta kaylawta ima rishun niyarmapis, ashwan ishkantinllapa uk uĉhkumanna ratanllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Chaynu nitinmi, Pedruqa Jesusta niran: —Intrachimayllapari chay mayqanpis mikushanraykuqa mana uchakuyta puytinchu nishaykitaqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Chaymi Jesusqa niran: —¿Qamkunamapischu manaraq intrakankillapa? ");
INSERT INTO qufNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Allita kwintata qukayllapa. Tukuy imata mikushallapaqami tukuyla rin paĉhanchikman. Chaymantami qashan kwirpunchikqa itakamun. ");
INSERT INTO qufNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Piru chay kusala mana allin rimaykunata rimanllapa chay-shuypaqami yarpuyninllapamanta lluqshimun. Chaynu karmi mana allinkunata rimar ima uchakushana rikarinllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Chaqa, uk runapa yarpuyninmantaqami mana allin yarpuykuna lluqshimun. Chaymi wanuchikuyta yarpun. Ukwan ukwan kayta yarpun. Musu kar, manaqa shipash karpis pakaplla tayta yarpun. Chaynulla suwakunanpaq, llullakunanpaq, musyakunanpaq ima yarpunllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tukuy chaykunata yarpur rurarmi uchakunllapa. Piru mayqanpis chay maki paqana kustumrita mana rurar mikurqa ¿imanunari uchakunqallapa? ");
INSERT INTO qufNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Chaymantami Jesusqa riran chay Tiro chaynulla Sidón pwiblupa lugarninkunaman. ");
INSERT INTO qufNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Chay lugarkunapimi uk cananea warmisita taq. Paymi Jesusman kaynu nir kusalata qayĉhakur qimikaran: —¡Taytituy, Davidpa ayllun, llakipamastuy-ari! ¡Chaqa warmi wamraymi dyablupa yarpuyninwan kar kusalata qischakayan! nir. ");
INSERT INTO qufNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Chaynu nitinmi, Jesusqa mana imatapis niranchu. Ashwanmi yaĉhakuqninkuna payman qimikar kaynu nir rugaranllapa: —Willay wak warmitaqa rinanpaq. Chaqa nuqanchikkunapa ikinchiktami qayĉhakur shamuyan nir. ");
INSERT INTO qufNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Chaynu nitinllapami, Jesusqa kaynu niran: —Taytay Dyusqami kaĉhamasha Israel pwiblumanta kaqkuna uysha chinqasha yupay runakunalaman. ");
INSERT INTO qufNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Chaynu nitinmapismi chay warmisitaqa rir Jesuspa naypanpi qunqurikur kaynu niran: —¡Taytituy, ama chaynu nirchu yanapamay-ari! nir. ");
INSERT INTO qufNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesusqa niran: —Manami allinchu wamranchikpa mikunanta kitar allqitukunata qaranapaqqa. ");
INSERT INTO qufNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Chaymi chay warmisitaqa niran: —Chiqaptami chaynu Taytituy. Piru allqitukunamapismi, amun misapi mikuyatin, chay mikuysitu ishkishanlamatapis mikun nir. ");
INSERT INTO qufNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Chaynu nitinmi Jesusqa niran: —¡Mamitay, kusalatari qamqa nuqapi kriyinki! Chaymi imanutaq kriyishaykinulla wamraykipiqa rurakanqa nir. Chaynu nitinmi chay kutilla, chay warmipa warmi wamranqa alliyaranna. ");
INSERT INTO qufNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesusqami chay kayashanmanta lluqshir rirqa, ĉharan Galilea shutiq quĉhapa manyanman. Chaymantami unaq sirkaman iqar taran. ");
INSERT INTO qufNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Chaykamanqami kusa achka runakuna tantakaranllapa pay kayashanmanqa. Kujukunata, syigukunata, mana allin rikrayjunkunata, mudukunata chaynulla ukman qishaywan kaqkunata imami apar Jesuspa ĉhakinlapi ĉhuraranllapa. Piru Jesusqami tukuyninta allicharan. ");
INSERT INTO qufNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Chaynu chay mudukuna rimatin, mana allin rikrayjunkuna alliyatin, kujukuna puritin, syigukuna chapakur rikakutin ima rikarmi chay runakunaqa limpu dispantakasha kidaranllapa. Chaymi ashwan Israel runakunapa Dyusnintana tukuyla alabaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Chaymantami, Jesusqa yaĉhakuqninkunata qayamur kaynu niran: —Kusatami llakini kay runakunapaqqa. Chaqa kimsa diyanari nuqawan kaypi. Mananami imata mikunanllapapaqpis kannachu. Chaymi mana qarasha karqa, mana kaĉhanayanichu wasinllapamanqa. Chaqa imanupiqami mallaqpaq riyar nanpi imananmanllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Chaymi, yaĉhakuqninkunaqa niranllapa: —Piru, ¿imanunari waknu kusala achka runakunapaqqa kay chunllaq mana mayqanpis tayashanllapa lugarpiqa mikuytaqa tarishunllapa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Chaymi Jesusqa tapuran paykunataqa: —¿Aykataq kan tantitaykillapaqa? nir. Paykunaqa niranllapa: —Syiti tantitawan aykala piskadukunalami kan nir. ");
INSERT INTO qufNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Chaymantami payqa willaran runakunata, pachalapimapis tananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Chaymi, chay syiti tantitawan, chay piskadutaqa, aypar payji nir ima Taytan Dyusman mañakuran. Chaymantami, tantakunata pakir quran chay yaĉhakuqninkunata. Chaymi paykunana runakunataqa aypachiran. ");
INSERT INTO qufNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Chaynumi tukuynin tiqllanankaman mikuranllapa. Ashwanmi subrankunata tantarqa, syiti kanastatana untachiranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Piru chay mikusha chaykunaqami kwatru milqa (4,000) ullqukunala karanllapa. Nataq warmikunawan wamrakunataqami mana yuparanllapanachu. ");
INSERT INTO qufNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Chaymantaqami Jesusqa runakunataqa, “Rishaqna” nir, yaku karruman iqar riran uk lugar Magdala shutiqmanna. ");
INSERT INTO qufNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Chaymantaqami wakin fariseukuna, chaynulla saduceo runakuna riranllapa Jesusta rikaq. Chaymi paykunaqa mabir ima ninqashi nir, kaynu niranllapa: —Chiqapta syilumanta shamushayki nir yaĉhanayllapapaqqa uk milagruta ruray nir. ");
INSERT INTO qufNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Piru Jesusqami niran: —Qamkunaqami tardikuna unaq syiluman chapakur, syiluta chupikallata rikarqa ninkillapa: ‘Kusa shumaq tyimpumi kanqa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Piru allaqmantakuna unaq syiluman chapakur syiluta chupikalla tultyawta rikarqa ninkillapa: ‘Kananqami mana allin tyimpuchu kanqa’ nir. Chaynu qamkuna syiluta chapar ima tyimpukunapaq yaĉharqa, ¿imapaqtaq mana intrakankillapa nuqa Dyusmanta shamusha kar yaĉhachishutiyqa? ");
INSERT INTO qufNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kay kusala mana allin yarpuyniyjun kaq, chaynulla mana allita kriyimaq runakunaqami uk milagruta ruranaypaq mañamanllapa. Piru kay mana kriyimaq runakunaqami Taytay Dyus imanutaq Jonaswan ruraran chaynulla nuqawan ruratinla, munarqa intrakanqallapa. Chaynu nirqa chay kutilla, riranna chay runakunamantaqa. ");
INSERT INTO qufNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jesuspa yaĉhakuqninkuna quĉhapa uklaw manyanman pasasha karqa yarpuranllapa, tantakunata qunqar rishallapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Chaymantami Jesusqa niran: —Allita kwintata qukar, kuytakankillapa chay fariseo, chaynulla saduceo runakunapa libaduranllapamanta nir. ");
INSERT INTO qufNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Chaymi chay yaĉhakuqninkunaqa paykunapura ninakuranllapa: “¡Mana tantata apamusha kashallapami, chaynu nimashanchikllapa kanqa!” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Chaynu yarpuyanllapa nir yaĉhayashanraykumi, Jesusqa kaynu niran: —¿Imapaqtaq ninkillapa, tanta mana kanchu nirqa? ¡Ima manaraqchu allita nuqapi kriyinkillapa! ");
INSERT INTO qufNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Manaraqchu intrakankillapa, chaynulla mananachu yarpunkillapapis, chay sinku tantitamanta sinku mil runakunata qarashaytaqa? Chaqa achka kanastataraqmi subratinpis tantaraykillapa. ");
INSERT INTO qufNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Chaynulla manachu yarpunkillapa chay syiti tantitamanta kwatru mil runakunata qaratiypis, achka kanastata subranta tantashaykillapataqa. ");
INSERT INTO qufNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Ima manachu kwintata qukaraykillapa, nuqaqa manami tantapaqchu rimayaray nirqa? Ashwanmi nishuyarayllapa kuytakanaykillapapaq chay fariseo, chaynulla chay saduceo runakunapa libaduranmanta. ");
INSERT INTO qufNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Chaymantami paykunaqa intrakaranllapana mana tantapa libaduranpaqchu willamayashanchikllapa nir. Ashwanmi intrakaranllapa chay fariseo, chaynulla saduceo runakuna yaĉhachikuyashanmanta kuytakananllapapaq nir. ");
INSERT INTO qufNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesusqa uk lugar Cesarea Filipuman ĉharqa, tapuran chay yaĉhakuqninkunataqa: —Nuqa Dyusmanta Shamuq Runapaqqa ¿mayqanshi kani ninllapataq runakunaqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Chaynu nitinqa paykunaqa niranllapa: —Wakinqami ninllapa, Shutichikuq Juan nir. Nataq wakin-shuypaqa ninllapa Elías nir. Chaynulla wakinkunaqa ninllapa Jeremías, manaqapis Dyuspa uk rimaqnin kanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","—Qamkunapaq-shuypaqa ¿mayqantaq kani? —nir tapuran chay yaĉhakuqninkunataqa. ");
INSERT INTO qufNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Chaymi Simón Pedruqa niran: —Qamqami Dyuspa Akrashan Cristun, tukuy tyimpupaq kawsaq Dyuspa Wamran kanki, nir. ");
INSERT INTO qufNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Chaymi Jesusqa niran: —Kusa shumaqmi kanki Jonaspa wamran Simón. Chaqa nuqapaq yaĉhanaykipaqqa unaq syilumanta Taytaymi intrachishusha, manami mayqan runa imachu. ");
INSERT INTO qufNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Chaymi kananqa kusalata kriyir, jwirti rumi yupay kashaykirayku Pedro shutichishayki. Chaynuqami wakin kriyiqkunapaqqa atun rumi yupayna kayanqa kriyishaykiqa. Chaymi chay rumipa ananman ĉhurar llutakur uk wasita shachiq yupayna kashaq chay wakin nuqapi kriyiqkunawanqa. Chaynuqami chay mana allinta rurachikuq dyabluqa mana binsiyta puytinqanachu. ");
INSERT INTO qufNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Piru kananqami Pedro, Taytay Dyus syilupi mantakuyashanman yaykuqkunata rikanaykipaqna numrashayki. Chaymi kay pachapi mayqanpis mana kriyishanrayku, Dyus mantakuyashanman mana yaykunqachu nitkiqa, unaq syilupi Taytaypis mana yaykuchinqachu. Chaynulla kay pachapi mayqanpis kriyishanrayku Taytay Dyus mantakuyashanman yaykunqa nitki-shuypaqa, Taytaypis yaykuchinqa mantakuyashanmanqa. ");
INSERT INTO qufNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Chaynu Pedruta nishana karqami Jesusqa yaĉhakuqninkunataqa willaran, ama mayqantapis willananllapapaqchu, payqa Dyuspa Akrashan Cristun nirqa. ");
INSERT INTO qufNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Chaymanta-pachami Jesusqa yaĉhakuqninkunata kaynu nir intrachiq qallariran: “Nuqaqami Jerusalén pwiblumanna riyashaq. Chaymi chay pwibluman ĉhatiyqa, chaypi ruku kaq mantakuqkuna, kurakunapa mantaqninkuna, Moisés mantakushanta yaĉhar yaĉhachikuqkuna ima aypar kusalata qischamanqallapa. Chaynu qischamarmi wanuchimanqallapa. Piru chaynu wanuchimatinllapamapismi kimsa diyamantaqa kawsamushaq” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Chaynu nitinmi, Pedruqa uklawman Jesusta paylata apar anyaqnulla kaynu nir willaran: —¡Dyusqami mana munanqachu chaynu qischakanaykipaqqa Taytituy! ¡Chaqa manami allinchu chaynu pasashunanpaqqa! nir. ");
INSERT INTO qufNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Chaynu nitinmi Jesusqa Pedrulawman tikrakamur niran: —¡Ashuy naypaymantaqa dyablu! Chaqa qamqami Dyus munashanta mana intrakar, yanqa runakuna yarpushannula yarpur, Dyus munashanta mana ruranayta munar disanimachimayanki nir. ");
INSERT INTO qufNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Chaymanta-shuypaqami Jesusqa yaĉhakuqninkunata kaynu niran: “Mayqanpis nuqapa yaĉhakuqniy kanarqami amana bidanllapapaqqa llakinqallapanachu. Ashwanmi kruspi wanuchinatinllapamapis ama manchakurchu nuqalapi yarpur shachinakunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Chaqa mayqanpis paykuna munashannulla bidanta washayta kamaqkunaqami tukuy tyimpupaqna qischakanqallapa. Piru mayqanpis nuqapi kriyishanrayku qischakar wanuqkunaqami tukuy tyimpupaqna kawsanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Chaqa nishaykillapa: Mayqanpis kay pachapi kaq ima munashanta tantakur mana washakatinqa, ¿imapaqtaq sirbiyan chay tantakushanqa? ¿Manaqa uk runachu achka imata pagrakur washakayta puytinman? ¡Manami! ");
INSERT INTO qufNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Chaqa nuqa Dyusmanta Shamuq Runaqami shamushaq Taytay Dyuspa llipyalla pudirninwan, angelniykunawan ima. Chaynu shamurmi tukuyta allita rikar yaĉhar imanu rurashanllapanulla imanu kananpaqmapis nishaq. ");
INSERT INTO qufNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Chiqaptami nishaykillapapis: Kaypi kaqmanta wakinllaqami mana wanunkillaparaqchu Dyusmanta Shamuq Runata mantakuqta rikanaykillapakaman nir”. ");
INSERT INTO qufNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Chaymanta saysi diya pasatinnaqami Jesusqa, Pedruta Santiaguta apar riran. Chaynullami aparanpis Santiagupa uknin Juanta ima. Chaynumi paykunala rir iqaranllapa kusa unaq sirkaman. ");
INSERT INTO qufNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Chaypi katinllapanami, Jesusqa yaĉhakuqninkunapa naypanpi kusala ukman shumaqpaq tikrakaran. Chaqa qaqllanqami rupay yupay kusata llipyarayaran. Nataq raĉhpan-shuypaqami kusa yuraq intiruta achkirayaran. ");
INSERT INTO qufNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Chaynu Jesusta rikakuyarllapami, chay kutilla rikaranllapapis Dyuspa unay rimaqninkuna Moiseswan, Elías ima Jesuswan parlaqta. ");
INSERT INTO qufNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Chaymi Pedruqa Jesusta niran: —Taytituy ¡kaypiqami kusala allin kanchikllapa! Qam munatkiqa, rurashaq kimsa chukllitakunata, ukta qampaq, ukta Moisespaq, ukta-shuypaqa Eliaspaq nir. ");
INSERT INTO qufNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Chaynu Pedro niyatinqami, kusa llipya intiru puktay limpu paykunata pampar pasayaran. Piru chay puktay rurimantami Dyus kaynu niyaran: ");
INSERT INTO qufNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Chaynu niqta uyaparmi chay kimsa yaĉhakuqninkunaqa kusalata manchakur piratap rataran pachaman. ");
INSERT INTO qufNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Chaymantami Jesusqa paykunaman qimikar, kamar kaynu niran: —Ama manchakurchu shariyllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Chaymi sharir chapakurqa mana mayqantapis rikaranllapanachu. Ashwanmi Jesusqa paylana kasha karan. ");
INSERT INTO qufNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Chaymanta chay unaq sirkamanta ishkimuyatinllapanaqa Jesusqa yaĉhakuqninkunata kaynu niran: —Amami mayqantapis parlankillapachu chay rikashaykillapataqa, Dyusmanta Shamuq Runa wanur kawsamunankaman nir. ");
INSERT INTO qufNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Chaymi yaĉhakuqninkunaqa Jesusta kaynu nir tapuranllapa: —Chaynu katinqa, ¿imapaqtaq Moisés mantakushanta yaĉhar yaĉhachikuqkunaqa, Eliasraqshi Dyuspa Akrashan Cristunmanta naypaqta shamuyanqa ninllapa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesusqa paykunata niran: —Chiqaptami Elías naypaqtaqa shamuyanqa. Chaynu shamurmi tukuy imata Dyus munashanulla shumaqchayanqa. ");
INSERT INTO qufNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Piru nuqaqa nishaykillapa: Eliasqami nuqamanta naypaqta shamushana karan. Chaynu shamutinmapismi, Dyuspa rimaqninpaq mana kwintacharchu paykuna munashanta ruraranllapa. Chaynullami kananpis Dyusmanta Shamuq Runatapis qischanqallapa paykunaqa. ");
INSERT INTO qufNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Chaymi chay yaĉhakuqninkunaqa kwintata qukaranllapa, Jesusqami Shutichikuq Juanpaq rimayan nir. ");
INSERT INTO qufNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Chaymanta, unaq sirkamanta tikrakamurqa achka runakuna kayashanman ĉhamuranllapa. Chaymi chay kutilla, Jesusman uk runa qimikar naypalanpi qunqurikur, kaynu niran: ");
INSERT INTO qufNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Wamraymi atakiwan kusalata qischakan. Chaynu atakiwan qischakarmi kusalata ninakunaman, yakukunaman ima ratan. ¡Imaraq Taytituy, wamrayta llakipar alliyachiy-ari! ");
INSERT INTO qufNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Chaqa nuqaqami kay yaĉhakuqnikikunamanmapis apamuray allichananpaq. Piru paykunaqami mana puytishallapachu nir. ");
INSERT INTO qufNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Chaynu nitinmi, Jesusqa niran: —¡Ay qamkuna Dyuspi mana allita kriyiqkuna, chaynulla mana allinta ruraqkuna! ¿Maydiyakamantaq allita intrachishunayllapapaq qamkunawan kashaq? ¿Ima maydiyakamantaq qamkunawan shachinakushaq? Ma, kayman apamuyllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Chaynu chay wamrata apamutinllapami Jesusqa chay dyablupa yarpuyninta chay wamramantaqa anyar itakuranna. Chaymi wamraqa chay kutilla, allinna kidaran. ");
INSERT INTO qufNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Chaynu chay wamra alliyatinnaqa, yaĉhakuqninkunaqa wakaqlaman rir Jesuswan parlar, kaynu nir tapuranllapa: —¿Imaraykutaq chay dyablupa yarpuynintaqa mana itakuyta puytisha kashaqllapaqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesusqami niran paykunataqa: —Qamkunaqa manami allita Dyuspiqa kriyinkillapachu. Chaqa chiqaptami nishaykillapa: Imanutaq chay mustasa qirupa simillitanmaqa kusa llampitu chaynu pitilamatapis allita Dyuspi kriyir, kay qaqata ‘Ashur kaymanta, riy uklawman’ nitkillapaqa, chay qaqaqa ashunman. Chaqa allita Dyuspi kriyirllapaqami tukuy imatapis rurayta puytiyankillapana kanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Waknu riqchaq dyablupa yarpuyninqa mana chaynulaqa runamantaqa lluqshinchu. Ashwan chaynu dyablupa yarpuyninta itakunarqa ayunar kusalata Dyusman mañakurla itakuyta puytinchik. ");
INSERT INTO qufNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Chaymanta chay Galilea lugarpi yaĉhakuqninkunawan pulla puriyarmi, Jesusqa kaynu niran: “Dyusmanta Shamuq Runatami kuntrankunaman qukuyanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Chaynu qukutinllapami wanuchinqallapa. Piru kimsa diyamantaqami, qashan kawsamunqa”. Chaynu nir willatinmi, yaĉhakuqninkunaqa kusalata llakiranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Chaymantami Jesusqa yaĉhakuqninkunawan rir ĉharan Capernaúm pwibluman. Chaynu ĉhatinllapami, Dyusta adurananllapa wasipaq impwistuta kubrakuqkuna Pedruman qimikar, kaynu nir tapuran: —¿Yaĉhachikuqnikiqachu impwistutaqa pagrakun Dyusta adurananllapa wasipaqqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedruqa niran: —Pagrakunmi taytituy. Chaymanta Pedro wasiman yaykur mana imatapis niyatinraqmi, Jesusqa kaynu niran Pedrutaqa: —Ima ninkitaq Simón Pedro, ¿mayqankunatataq kubranllapa impwistutaqa kay pachapi mantakuqkunaqa? ¿Chay pwiblunllapamanta kaqkunata, manaqachu jwira kaq runakunata? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedruqami niran: —Jwiramanta kaq runakunalatami kubranllapa nir. Chaymantami Jesusqa niran: —Chiqaptami, chay mantakuqkunaqa pwiblunllamanta kaqkunataqa mana impwistutaqa kubranllapachu. ");
INSERT INTO qufNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Piru chay impwistuta kubrakuq kaqkunata mana pagrar ama piñachinallapapaqqa, rir chay atun quĉhaman answiluykita itakuy. Chaymanta chay punta kaq piskaduta aypamurqa, aqrunta kiĉhar uk qillayta tarinki chaypiqa. Chaymi chay qillayqa aypanqa, rir nuqapaq kaq impwistuyta chaynulla qampa kaqta pagrakutkimapis nir. ");
INSERT INTO qufNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Chaymanta chay kutilla Jesuspa yaĉhakuqninkunaqa payman qimikar kaynu nir tapuranllapa: —Syilumanta kaq mantakuyashanpiqa ¿mayqanniyllapatataq Dyusqa kusa mas allinpaq rikamayanqallapaqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Chaynu nitinllapami Jesusqa uk wamrituta qayamur paykunapa ĉhaypinpi shachir, ");
INSERT INTO qufNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","kaynu niran: —Chiqaptami nishaykillapa: Imanutaq kanan kawsayankillapa, chaynulla kawsar mana kay wamritu mana kwintachaypaqla chay yupay kawsarqami, syilumanta kaq mantakuyashanmanqa mana yaykunkillapachu. ");
INSERT INTO qufNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Chaqa kay wamritu yupay mana kusa kani nirchu ashwan mana kwintachaypaqla kaqkunalami, syilumanta kaq mantakuyashanpiqa kusa mas allinpaqqa riqsikasha kanqa. ");
INSERT INTO qufNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Chaymi mayqanpis nuqapi kriyishanrayku kay wamritu yupay kaqta, shumaqta samachiqqami, ashwan nuqallatana samachimayan nir. ");
INSERT INTO qufNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Piru nuqapi kriyishanrayku mana kwintachaypaqla kay taksha wamritukuna yupay kaqkunata uchakuchiqkunataqami, kusala allin kanman kunkanpi uk marayta watar, mar yakupa mas ruri kaqninman itakunanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Piru kay pachapiqami kusala saqra mana allinkunala untarayan. Chaymi mana imanupis shumaqta kawsayllapataqa puytinllapachu. Piru, chay mayqanpis uknin mana allinta rurar uchakunanpaq animachiq-shuypaqa imananqaraq. ");
INSERT INTO qufNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Chayraykumi uk makikillapa manaqa uk ĉhakikillapa mana allinta rurar uchakushana rikarichishutinqa, pitir itakuy wakaq qammantaqa. Chaqa mas allinmi kanqa chulla makila, manaqa chulla ĉhakila tukuy tyimpupaqna kawsanaykipaq. Manami allinchu kanqa chay makiki, chaynulla ĉhakiki uchakuchishushanrayku tukuy tyimpupaqna mana wanuq ninapi qischakanaykipaqqa. ");
INSERT INTO qufNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Chaynulla nawiki ima mana allinta rikachir uchakuchishutinqa, urqur itakuy karu mayman qammantaqa. Chaqa kusa allinmi kanqa uk nawiyjunla tukuy tyimpupaq kawsanaykipaqqa. Manami allinchu kanqa nawiki uchakuchishushanrayku, tukuy tyimpupaqna infyirnupi kastigakasha kanaykipaqqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Chaymi nishaykillapa: Amami nuqapi kriyiqkuna yanqa taksha wamritukuna yupay kaqkunataqa ukmanta rikankillapachu. Chaqa paykunata kuytaq angelmaqami waran waran maydiyapis Tayta Dyuspa naypalanpi kayan. ");
INSERT INTO qufNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Chaqa Dyusmanta Shamuq Runaqami shamusha tukuy chay chinqasha kaqkunata washananlapaq. ");
INSERT INTO qufNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“¡Ma nimayllapa! Uk runa syin uyshayjun kanman. Chaymanta chay syin uyshankunamantaqa uksitu chinqanman. Chaynu chay uksitu chinqashanraykuchu ¿chay wakin nubintay-nwibita (99) chaylapi dijar, mana rinman chay chinqasha chayta maskaq? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Chaynu rir maskakur, tarirqami chay nubintay-nwibi kaqkunamantaqa masta aligriyanqa chay chinqasha chayta tarishanraykuqa. ");
INSERT INTO qufNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Chaynullami unaq syilupi Taytaykillapapis mana munanchu uklamapis paypi kriyishanrayku mana kwintachaypaqla wamritu yupay kaqkunapis chinqanantaqa. ");
INSERT INTO qufNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Imanupi uknikillapa ima mana allinta rurashutinllapaqa, rir, ‘Kaynumi mana allinta ruramashayki’ nir shumaqla paylawan parlayllapa. Chaynu paylawan parlar shumaqchanakurqami, kusa shumaqtana kawsankillapa. ");
INSERT INTO qufNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Piru imanupi mana kasushutin-shuypaqa, qayamuy ukta manaqa ishkay kriyiqkunata. Chayna chay paykunapis rikananpaq ima mana allinta rurashantaqa, imanutaq Dyus nitin unay iskribishankunapimaqa, ima katinpis ishkay manaqa kimsa tistigukuna rikar yaĉhanqa niq chaynulla. ");
INSERT INTO qufNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Chaynu ruratkillapa paykunatapis mana kasutinqa, wakin kriyiqkunatapis willayllapa. Piru chay wakin kriyiqkunata mana kasutinllapa-shuypaqa, uk mana kriyiqta, manaqa Roma pwiblupaq impwistuta kubrakuq runata yupayna riqsinkillapa. ");
INSERT INTO qufNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Chaymi nishaykillapapis: Kay pachapi kaqkunata mana allinta tukushanrayku chiqanchatkillapaqa, ¿imanunari syilupi Taytay kayashanmanmaqa yaykunqallapa? Nataq mayqanpis kriyishanrayku kusala allinpaq ima riqsitkillapaqami, ashwan syilupi Taytay kayashanmanpis yaykunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Chaynullami nishaykillapapis: Kay pachapi qamkunamanta ishkay runa chayllata yarpur imata mañakutkillapaqami, unaq syilupi Taytayqa qushuyanqallapa chay mañakushaykillapataqa. ");
INSERT INTO qufNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Chaqa ishkayla, manaqa kimsalamapis nuqapi kriyishanrayku tantakatinllapaqami, nuqaqa pullanllapa kashaq”. ");
INSERT INTO qufNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Chaynu nitinmi Pedruqa riran Jesusta kaynu nir tapuq: —Taytituy ¿ukniykuna ima mana allinta ruramatinqa ayka kutitaq pirdunayta puytiyashaq? ¿Syiti kutichu pirdunanaypaq allin kanqa? ");
INSERT INTO qufNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Chaymi Jesusqa niran: —Nuqaqa manami syiti kutila pirdunanki nishaykichu. Ashwanmi sitinta kuti syiti katinmapis michkatapis pirdunanki nir. ");
INSERT INTO qufNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Chayraykumi syilumanta kaqpa mantakuyninqa, imanutaq uk mantakuqmaqa trabajaqninkunata iman kaqkunatapis rikananpaq dijasha karan chay yupay. ");
INSERT INTO qufNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Chaymanta imankunata rikaq qallaritinllapanaqa payman ĉhachiran uktaqa dyis mil talintu qillayta dibikuqta. ");
INSERT INTO qufNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Chaymi chay trabajaqqa chay dibikuyashanpaq mana imanupis pagrakuyta puytiranchu. Chaynami chay mantakuqqa kaĉhakuran rantikunanllapapaq uk sirbikuqta yupay uklawman. Piru rantikunanpaqmi niran warmintinta, wamrantinta, chaynulla tukuy iman kaqnintinta ima chay dibikuyashanta pagrakunanpaqqa. ");
INSERT INTO qufNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Chaynu chay mantakuq niyatinmapismi, chay trabajaqqa paypa naypalanpi qunqurikur rugaran kaynu nir: ‘Taytituy llakipar yaramaskiy-ari. Nuqaqami imanupis chay dibishuyashaytaqa tukuyninta pagrashayki’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Chaymi chay mantakuqqa chaynu rugatinqa llakiparan paytaqa. Chaynulla ashwan chay dibiyashanmatapis manana kubrananpaqnachu niran. Chaymi ashwan dijatinna riran. ");
INSERT INTO qufNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Piru chay mantakuq chaynu llakipatin rirqami, chay trabajaqqa tariran uk trabajaq masin pitilata dibiyaq chayta. Chaymi ashwan mana llakiparchu kunkanmanta aypar urkaq qallarir, kaynu niran: ‘¡Pagramay chay dibimayashaykita!’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Chaymi chay trabajaq masinqa naypanpi qunqurikur rugaran kaynu nir: ‘Llakipar yaramaskiy-ari taytituy. Chaymantami tukuyninta pagrashayki’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Piru chay ukninqami, mana llakipar yaraytaqa munaranchu. Chaymi ashwan karsilachikuran tukuy dibiyashanta limpu pagranankaman. ");
INSERT INTO qufNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Chaynu rurashanraykumi chay wakin trabajaq masinkunaqa kusalata llakiran. Chaymi rir chay mantakuqtaqa tukuy ima pasashantaqa parlaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Chayta chay mantakuq yaĉharmi, kaĉhakuran qayamunanllapapaq. Chaymi ĉhamutinqa niran: ‘¡Kusala mana allin yarpuyniyjun runa!, nuqamaqami rugamashaykirayku chay tukuy dibimayashaykitaqa llakipashuray. ");
INSERT INTO qufNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Chaymi imanutaq nuqa qamta llakipashuray chaynullami qampis chay uknikitaqa llakipanaykita’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Chaymi chay mantakuqqa kusalata piñakur kaĉhakuran karsilman itar qischananllapapaq, tukuy dibiyashanta limpu pagranankaman”. ");
INSERT INTO qufNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Chaynu nirnaqami, Jesusqa niranpis: “Qamkuna uknikillapata mana tukuy shunquykillapawan pirdunatkillapaqami, syilumanta Taytaypis chaynulla qamkunawanpis ruranqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesusqa yaĉhachikur tukchirnaqa riranna Galilea pwiblumantaqa. Chaynu rirmi riyu Jordanpa chimpan Judea lugarman ĉharan. ");
INSERT INTO qufNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Piru paypa ikintaqa kusala achka runakuna riranllapa. Chaymi ashwan tukuyla qishaq kaqkunataqa allicharan. ");
INSERT INTO qufNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Chaymantaqami wakin fariseo runakuna Jesusman qimikaranllapa. Chaymi mabir imanimashunllapashi nir, kaynu tapuranllapa: —¿Allinchu kanqa uk runa kasarashan warminta imallapaqqa dijananpaq? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Chaymi Jesusqa niran: —¿Manachu qamkunaqa liyishaykillapa Dyus nitin iskribikashakunataqa? Chaqa chaypiqami nin: ‘Dyusqashi puntamanta-pacha runata, warmita ruraran’. ");
INSERT INTO qufNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Chaqa chaypaqmi Dyusqa niqpis: ‘Uk runaqami warminwan kasararqa, taytanta mamanta dijanqa. Chaymi ashwan warminwanqa uk kwirpu yupaylana kawsanqallapa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Chaynu katinmi runaqa warminwanqa manana ishkaynachu. Ashwanmi uk kwirpulana kayanqallapa. Chaymi nishaykillapa: Uk runa warminwan uk kwirpulana kananpaq Dyus nishanraykumi mana mayqanpis, paykunaqa dijanakunqa niyta puytinchu nir. ");
INSERT INTO qufNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Chaymanta chay fariseo runakunaqa qashan kaynu niranllapa: —Chaynu katinqa, ¿imapaqta Moisés mantakushanpiqa kaynu nin? Uk runa warminta dijanarqashi, karguyjunkunapi kartata rurar warminta qurqashi chiqanchakayta puytin nir. ");
INSERT INTO qufNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Chaynu nitinmi Jesusqa niran: —Qamkuna kusala kuchi mana intrakaq kashaykillaparaykumi Moisesqa chaynu dijanakunqa nirmapis mantakuran. Piru Tayta Dyusqami unaymanta-pacha runata warminwan pullacharqa mana imalapaqpis dijanakunanpaqqa munaranchu. ");
INSERT INTO qufNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Piru nuqaqami nishaykillapa: Uk runa, warmin mana mayqanwan punusha ima katin yanqallamanta dijar, ukwan kasararqami kusala saqrata uchakuyan nir. ");
INSERT INTO qufNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Chaynu nitinmi, chay yaĉhakuqninkunaqa kaynu niran: —Chaynu katinqa, manami allinchu mayqanpis warmiyjun kanapaqqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesusqa paykunata niran: —Tukuylaqa manami mana warmiyjun kaytaqa puytinllapachu. Ashwanmi chay mayqantaĉhi Tayta Dyus mana warmiyjun kananpaq nisha, chaykunalami chaynu kaytaqa puytinllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Chaqa chiqaptami wakin runakunaqa mana warmiyjunchu maydiyapis kananpaq nasinllapa. Nataq wakin runakunataqami ama warmikunanpaq runa masinkuna kaparanllapa. Nataq wakinkuna-shuypaqa mana warmikunllapachu kusala mas shumaqta Tayta Dyusta sirbiyta munar ima. Chaymi kay nishayta mayqannikillapapis intrakanarqa imanupis intrakayllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Chaymantami Jesusmanqa wamrakunata apamuranllapa, pay makinta ananman ĉhurar bindisinanpaq. Piru yaĉhakuqninkunaqami chay wamrakunata apamuqkunataqa anyaran. ");
INSERT INTO qufNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Chaymi Jesusqa kaynu niran paykunataqa: “¡Ama arkarchu, dijay nuqaman shamunqa wamritukunaqa! Chaqa syilumanta kaq mantakuyashanqami kay wamritukuna yupay kaqkunalapaq”. ");
INSERT INTO qufNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Chaynu nir, makinkunata chay wamrakunapa ananman ĉhurar bindisirmi, chay lugarmantaqa riranna. ");
INSERT INTO qufNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Chaymantami uk musulla runa shamur Jesusta kaynu nir tapuran: —Kusa allinla yaĉhachikuq Taytituy, ¿ima allin kaqlatataq rurayman, tukuy tyimpupaqna kawsanaypaqqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Chaynu nitinmi Jesusqa niran: —¿Imapaqtaq tapumanki allin kaqpaqqa? Allinla kaqqami kan ukla. Payqami Taytay Dyus. Piru tukuy tyimpupaqna kawsayta munarqami, Dyus mantakushankunata kasur kawsay nir. ");
INSERT INTO qufNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Chaynu Jesús nitinmi, chay musuqa qashan tapuran: —¿Mayqan mantakuykunatana? nir. Chaymi Jesusqa kaynu niran: —Ama wanuchikuychu; ama uk uk warmiwan kaychu; ama suwakuychu; ama uknikipaq llullakur rimaychu; ");
INSERT INTO qufNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","taytaykita, mamaykita kasuy. Chaynulla ukkunata llakipay, imanutaq qampa kwirpuykillapaq llakinki chaynulla, nir. ");
INSERT INTO qufNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Chaynu nitinmi, chay musuqa niran: —Tukuy chaykunataqami takshaymanta-pacha rurashana kani. ¿Imataq mas kanqa ruranaypaqqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesusqa niran: —Kusa mas allin kayta munarqa, rir tukuy imayki kaqta rantikur, qillaynikitaqa mana imayjun kaqkunata quy. Chaynuqami unaq syilupiqa mana tukukaq imaykitana tarikunki. Piru chay nishushayta rurarnaqami, shamutki nuqawanna rishun nir. ");
INSERT INTO qufNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Chayta uyarmi, chay musuqa kusalata llakir riran. Chaqa kusala imayjun-ari karan. ");
INSERT INTO qufNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Chaymi Jesusqa yaĉhakuqninkunata kaynu niran: —Allipla trabajusuraq kanqa chay kusala imayjun kaqkuna, syilumanta kaq mantakuyashanman yaykunanpaqqa. ");
INSERT INTO qufNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Chaymi qashan nishaykillapa: Mayqanpis kusala imayjunkuna, Dyus mantakuyashanman dasla yaykunanmantaqami, ashwan uk kamillu dasla pasayta puytinman uk awjapa uĉhkitunta, nir. ");
INSERT INTO qufNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Chaynu nitin uyaparmi yaĉhakuqninkunaqa kusata yarpupakur kaynu niranllapa: —Chaynu katinqa ¿pitaq washakayta puytiyanqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Chaynu nitinmi Jesusqa paykunata chapar kaynu niran: —Runakunapaqqami kayqa mana ruraypaqchu. Piru Dyuspaq-shuypaqami tukuy imapis ruraypaq nir. ");
INSERT INTO qufNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Chaynu nitinqa, Pedruqa niran: —Nuqakunamaqami tukuy imayllapakunata dijashana, qamwanna purinillapa. Chaynu kashayllaparaykuqa, ¿imatataq aypayashaqllapaqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesusqa niran paykunataqa: —Chiqaptami nishaykillapa: Maydiya nuqa, Dyusmanta Shamuq Runa kusala shumaq mantakuyniypi mantakuq qallaritiyqami, qamkunapis dusikillapa mantakunaykillapapi tar pullay mantakunkillapa. Chaynami qamkunana Israelpa chay dusi kaq ayllunkunamatapis allinta mana allinta rurasha katinmapis allita rikar yaĉhankillapa. ");
INSERT INTO qufNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Chayraykumi chay tyimpuqa nuqarayku wasinta, ullqu ukninkunata, warmi ukninkunata, taytanta, mamanta, manaqa warminta, wamrankunata, ĉhakrankunata dijar nuqa munashayta ruraqkunaqa, chay dijashanmantaqa syin kuti mas imanllapakunata aypanqallapa. Chaynulla tukuy tyimpupaqnami kawsanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Piru kanan tyimpukunapi achka runakuna kusana kaqkunaqami, chay tyimpuqa mana imapaqpis sirbinqachu. Chaynulla kanan tyimpukuna achka mana kwintachaypaq kaqkunaqami, ashwan chay tyimpuqa kusa nishapaqna riqsikanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesusqami niranpis: “Syilumanta kaqpa mantakuyninqami imanutaq uk ĉhakrapa amunmaqa timpranula lluqshiran rikaq trabajadurkunata, ĉhakranman rir trabajananpaq chay yupay. ");
INSERT INTO qufNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Chaymi, chay ĉhakrapa amunqa trabajaqkunawan uk tratuta rurar kaĉharan ĉhakranpi trabajatinllapa uk diya intirupaq pagrananpaq. ");
INSERT INTO qufNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Chaymanta qashan unakaqna lluqshirqa rikaran plasapi ayka mana imatapis rurar taqkunata. ");
INSERT INTO qufNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Chaynu rikarmi paykunataqa niran: ‘Riyllapa qamkunapis ĉhakrayman trabajaq. Nuqami imanu trabajashaykillapanulla pagrashaykillapa’ nir. Chaymi paykunapis riranllapana. ");
INSERT INTO qufNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Chaymanta qashalan chay ĉhakrapa amunqa lluqshiran a las dusi yupay, chaynulla tardikaqpis. Chaymi wakin runakunata tarirpis chaynullata niran paykunatapis. ");
INSERT INTO qufNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Qashan tardikaqna chay plasallaman lluqshirqa, qashan runakunata tariran. Chaymi chay tarishankunatapis niran: ‘¿Imapaqtaq qamkunaqa kaypiqa tukuy unaq mana trabajarqa tashaykillapa?’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Paykunaqa niranllapa: ‘Manamiri mayqanpis rugamashallapachu trabajanayllapapaqqa’ nir. Chaymi chay ĉhakrapa amunqa paykunatapis niran: ‘Riyllapa qamkunapis ĉhakrayman trabajaq. Nuqami imanu trabajashaykillapanulla pagrashaykillapa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Chaymanta amsatinna-shuypaqa, ĉhakrapa amunqa kaynu niran chay trabajachikuqnintaqa: ‘Qayamur trabajaqninchikkunataqa pagrayna. Piru chay ikita trabajaq qallarishakunata pagraq qallarir, tukchinki chay naypaqta trabajaq qallarishakunawan’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Chaymi, chay tardilana trabajaq qallarishakunaqa ĉharanllapa naypaqta pagrakaqqa. Piru tukuy unaq trabajasha yupaymi pagrakaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Chaymantami chay naypaqta trabajaq qallarisha chaykunata pagrananpaq qayatinqa, paykunaqa yarpuranllapa: Nuqanchikkunataqami masta pagramayashunllapa nir. Piru paykunatapismi chay uk diyata trabajashannulla pagraranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Chaynu pagrakashana karqami kusalata piñakur, chay ĉhakrapa amuntaqa juraparanllapa, ");
INSERT INTO qufNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","kaynu nir: ‘Kay ikita ĉhamuqkunaqami uk ratulatana trabajashallapa. Nataq nuqakunamaqami tukuy unaq kusala rupaypi ima shachinakur trabajasha kanillapa. Piru qamqami nuqakunawanqa chayllata pagrashayki. Chaynuqami mana allinchu’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Chaynu nitinllapaqa, ashwan chay ĉhakrapa amunqa kaynu niran chay rimapakuqkunapa uknintaqa: ‘¿Amiguy, ima mana allintataq qamwanqa rurasha kani? ¿Manachu tukuy unaq trabajatkillapa chaynuta pagrashunayllapapaq parlaranchikllapa? ");
INSERT INTO qufNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kaypimi trabajashaykipaq qillaynikiqa. Ashwanmi rikuyna. Ma willamay, ¿ima mana allintataq rurashusha kani, chay ikita trabajaq ĉhamushakunata qamwan chayllata pagrarqa? ");
INSERT INTO qufNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Chaqa nuqapa qillayniywanqami munashayta rurayta puytini. ¿Manaqachu kusala bwinu kashayrayku, chay wakinkunata qamwan chayllata pagrashayrayku inbidyakayanki?’ nir”. ");
INSERT INTO qufNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jesusqami kaynu niranpis: “Kanan ikilapi kaqkunaqami naypaqpina kanqallapa. Nataq chay kanan naypaqllapi kaqkuna-shuypaqa maydiyaqa ikipina rikarinqallapa. Chaynulla kusala achkami qayakasha kanqallapa. Piru aykalami akrakasha kanqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesusqami Jerusalén pwibluman riyarqa yaĉhakuqninkunata, uklawman qayar kaynu niran paykunataqa: ");
INSERT INTO qufNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Qamkuna rikayashaykillapanumi kananqa riyanchikllapana Jerusalén pwiblumanqa. Chaypimi Dyusmanta Shamuq Runataqa qukunqallapa, kurakunapa mantakuqninkunaman, Moisés mantakushanta yaĉhar yaĉhachikuqkunaman ima. Chaymi ashwan paykunaqa wanuchinanllapapaq nir mantakunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Chaynullami mana Israel runakunaman qukunqallapa. Chaymi paykunaqa kusalata burlakar wipyar ima kruspi klabar wanuchinqallapa. Piru kimsa diyamantaqami qashan kawsamunqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Chaymantaqami Zebedeupa warmin, wamran Santiaguwan chaynulla Juanwan rir, Jesusman qimikar naypalanpi qunqurikur, wamranta llakipananpaq mañakuran. ");
INSERT INTO qufNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Chaymi Jesusqa kaynu nir tapuran chay warmitaqa: —¿Imatataq munayanki? nir. Payqami niran: —Chay kusala shumaq mantakuynikipi mantakurqami, qam nitki, uk wamrayqa allilaw qichqaykipi tanqa. Nataq uknin-shuypaqa ichuqlaw qichqaykipi tanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Chaynu nitinmi, Jesusqa kaynu niran: —Manami qamkunaqa imata mañakuyankillapa nirmapis yaĉhankillapachu. Tapushaykillapa: ¿Kusala saqra ayaq yakuta upyaq yupaymi qischakar wanuyashaq, chaynu qischakaytachu puytiyankillapa kanqa? nir. Chaymi paykunaqa niran: —Arí Taytituy nir. ");
INSERT INTO qufNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Chaymi Jesusqa qashan niran: —Chiqaptami qamkunapis kusalata qischakankillapa, nuqa qischakashaynulla. Piru mantakunaypi tar allilawpi manaqa chay ichuqlaw qichqaypi tachishunayllapapaqqami, mana nuqaqa yaĉhanichu. Ashwanmi Taytay Dyus mayqantapis pay munashannulla tachinarqa tachiyanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Piru chay wakin dyis kaq yaĉhakuqninkunaqami chaynu nir mañakuqta uyaparqa, chay ishkaykunawanqa piñakuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Chaymi Jesusqa paykunata qayamur niran: “Qamkuna yaĉhashaykillapanu, kay pachapi mantakuqkunaqami, chay pwiblumanta kaq runakunataqa paykuna munashanlata rurachin. Chaynu katinmi ashwan chay pwiblupi kusa runa nisha kaqmaqa, wakinkunata mantarla ima kawsanllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Piru qamkunapiqami ama chaynuqa pasanmanchu. Ashwanmi chay qamkunamanta mayqannikillapa kusa runa nisha kaqqa, uk sirbikuq yupay kar wakinnikillapata yanapankimanllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Chaynulla qamkunamanta uknikillapa kusa mas kayta munarqa, ukkunapa sirbiqninna kayllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Imanuĉhi Dyusmanta Shamuq Runamaqami mana payta sirbinanllapapaqchu shamusha. Ashwanmi pay sirbikuq shamushamapis. Chaynami ashwan payqa kusala achka runakuna tukuy tyimpupaqna wanunanllapapaqna kaqkunata washar tukuy tyimpupaq kawsachinanpaq shamusha”. ");
INSERT INTO qufNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Chaymantami Jesús, Jericó pwiblumanta yaĉhakuqninkunawan lluqshir ritinmi, kusala achka runakuna ikinta riranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Chaynu riyatinllapami nan qichqalanpi ishkay syigu runakuna tayasha karan. Chaymi Jesús pasaqta uyaparqa, kaynu nir qayĉhakuranllapa: —¡Taytituy, Davidpa ayllun, llakipamastuyllapari! nir. ");
INSERT INTO qufNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Chaynu nitinllapami, runakunaqa anyaranllapa upallananllapapaq. Piru paykunaqami llallin kaynu nir qayĉhakuranllapa: —¡Taytituy, Davidpa ayllun, llakipamastuyllapari! nir. ");
INSERT INTO qufNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Chaymi Jesusqa chaypi yarar, chay syigukunataqa qayar, kaynu nir tapuran: —¿Imatataq qamkunapaq ruranayta munayankillapa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Paykunaqami niranllapa: —Taytituy, nawiyllapa rikakunantami munanillapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Chaymi Jesusqa paykunapaq kusalata llakir, nawinllapataqa kamar chay kutilla allicharan. Chaymi ashwan chay runakunaqa allinna, Jesuspa pullan riranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jesusqami yaĉhakuqninkunawan Jerusalén pwibluman riyar, yaqqa ĉhayarnaqa, Betfagé pwibluman ĉharanllapa. Kay Betfagé pwibluqami chay Olivos sirkapaqa shipchanlapi karan. Chaymi chaypi karnaqa Jesusqa ishkay yaĉhakuqninkunata qayar, ");
INSERT INTO qufNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","kaynu nir kaĉharan: “Riyllapa wak naypanchikpi pwiblitu chayman. Chayman ĉharqami uk burra wawayjun wataraqta tarinkillapa. Chaymi kaĉhar apamunkillapa ishkantinta. ");
INSERT INTO qufNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Piru mayqan imallata willashutinllapaqa ninkillapa: ‘Taytitunchikmi ministiyan, daskaqlami kaĉhamunqa’ nir”. ");
INSERT INTO qufNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Chaynuqami Dyuspa unay rimaqnin nisha kayaq chaynulla kumplikanqa. Chaqa kaynumi nisha kayaq: ");
INSERT INTO qufNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Jerusalén pwiblumanta runakunata niyllapa: ‘Chapayllapa, chaytami shamuyan mantakuqnikillapa. Payqami shamuyan mana kwintachaypaqla yupay, uk burrupa wawitunpa anan tasha’ nir”. ");
INSERT INTO qufNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Chaynu nitinqami, chay ishkay yaĉhakuqninkunaqa rir Jesús nishannulla ruraranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Chaymi burrataqa wawantinta aparanllapa. Chaymi raĉhpakunata ananman ĉhuratinllapa Jesusqa taranna. ");
INSERT INTO qufNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Piru chaypiqami karan kusala achka runakuna. Chaymi Jesús riyashanlawmanqa wakinqa raĉhpanllapata ĉhukiranllapa. Nataq wakin-shuypaqami qirupa raprankunata kuchumur ĉhukiranllapa, chaypa ananlata Jesusqa pasananpaq. ");
INSERT INTO qufNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Chaymi ashwan naypaqta ikita riqkunamapis kusa aligrila kaynu nir laqyayaqllapa: “¡Biba biba! ¡Kusa alabakashami kanqa Davidpa ayllunmanta gubyirnunchik, Taytanchik Dyuspa shutinpi shamuqqa! Chaymi ashwan unaq syilupipis kusa alabakashana kanqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Chaymanta Jesús, Jerusalén pwibluman yaykutinqa, tukuyla chay pwiblumanta kaq runakuna kusalata laqyaranllapa. Chaymi achka runakuna kaynu nir tapunakuyaqllapa: —¿Mayqantaq kayqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Wakinkunaqami niyaqllapa: —Nazaret pwiblu Galileapa lugarninmanta Dyuspaq rimaqnin Jesusmi nir. ");
INSERT INTO qufNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Chaymantami Jesusqa, Dyusta adurananllapa wasiman yaykur tariran rantikuqkunata, rantiqkunata ima. Chaymi limpu waqtaman itakuran. Chaynumi chay uklawmanta kaq qillayta kambyaqkunapa misanta, chaynulla palumata rantikuqkunapa misanmatapis limpu tikrar itakuran. ");
INSERT INTO qufNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Chaymi chay runakunataqa kaynu niran: “Dyus nitin iskribikashakunapiqami nin: ‘Wasiyqami nuqaman mañakunanllapalapaq wasi shutinqa’ nir. Piru qamkunaqami suwakuqkunapa maĉhayninpaqna tikrashaykillapa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Chaymantami Dyusta adurananllapa wasillapi Jesusmanqa qimikaranllapa syigukuna, kujukuna ima. Piru Jesusqami paykunataqa allicharan. ");
INSERT INTO qufNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Piru kurapa mantakuqninkuna, Moisés mantakushanta yaĉhar yaĉhachikuqkuna ima Jesús rurashanta rikaranllapa. Chaynullami uyaparanllapapis wamritukuna Dyusta adurananllapa wasipi kaynu nir laqyaqllapata “¡Biba biba Davidpa ayllun!” niqta. Chaymi kusalata piñakur, ");
INSERT INTO qufNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jesustaqa kaynu niranllapa: —¿Uyapankichu chay wamrakuna rimayashantaqa? nir. Jesusqami niran: —Arí, uyapayanimi. Piru ¿manachu liyishaykillapa qamkunaqa Dyus nitin iskribikashakunapi kaykunapaq nishantaqa? Chaqa kaynumi nin: ‘Taksha wamritukuna, chaynulla ñuñuq wamritukunamapis kusa shumaqta alabamayanqallapa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Chaynu nirnaqami paykunata chaypi dijar, Jesusqa riranna Betania pwibluman. Chaymi chay tutaqa chaypi yurqaran. ");
INSERT INTO qufNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Allaqmanta allaq allaqla Jerusalén pwibluman qashan riyarmi Jesusqa mallaqnaran. ");
INSERT INTO qufNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Piru chay nan qichqalanpimi rikaran uk igus qiruta. Chaymi puquyninta maskaq rirqa yuranlata tariran. Chayraykumi, chay igus qirutaqa kaynu niran: “¡Mananami kaymantaqa puqunkinachu!” nir. Chaynu nitinmi chay kutilla, igus qiruqa chakiranna. ");
INSERT INTO qufNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Chaynu chay igus qiru chakishata rikarmi, Jesuspa yaĉhakuqninkunaqa kusa dispantakashalla kaynu nir tapuranllapa: —¿Ima nitkitaq chay igus qiruqa das chay kutillaqa chakiran? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","22","Jesusqami kaynu niran paykunataqa: —Chiqaptami nishaykillapa: Qamkuna imata ruranaykillapapaq kar Tayta Dyuspi kusalata kunfyakar ama ukmanta yarpurchu mañakutkillapaqami, tukuy imapis rurakanqa. Chaymi ashwan chay igus qiruta imanu rurashaymanmatapis masta rurayta puytinkillapa. Chaynulla ashwan Tayta Dyuspi kusalata kunfyakar, kay qaqata ‘Ashur, rir mar yakuman yaykuy’ nitkillapapis kasushunmanllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Chaymantami Jesusqa Dyusta adurananllapa wasiman yaykur yaĉhachikuq qallariran. Chaynu yaĉhachikuyatinmi, kurakunapa mantaqninkuna, Israel pwiblupa ruku mantakuqninkuna ima qimikar, Jesustaqa kaynu nir tapuranllapa: —¿Mayqan mantashutintaq tukuy chaykunata rurankiqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Chaymi, Jesusqa paykunata niran: —Nuqapis tapushaykillapa: ¿Mayqantaq Shutichikuq Juantaqa kaĉhamuran shutichikunanpaqqa? ¿Dyuschu kaĉhamuran manaqachu runakunala? Qamkuna chay tapushushayta willamatkillapami, nuqapis willashaykillapa mayqan mantamatinmi kayta rurani nirmapis. Chaynu nitinmi, paynin paynin willanakur kaynu ninakuyaqllapa: “ ‘Dyusmi kaĉhamuran’ niytaqa manami puytinchikllapachu. Chaqa, chaynu nishallapaqa ‘¿Imapaqtaq mana kriyiraykillapa?’ nimashunllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Chaynulla, manami puytinchikllapachu ‘Runakunalami kaĉhamuran’ niytapis, runakunata manchashanchikllaparayku. Chaqa tukuylami kriyinllapa ‘Juanqashi Dyuspa rimaqnin karan’ nir”. ");
INSERT INTO qufNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Chaynu ninakuyarmi, Jesustaqa niranllapa: —Manami yaĉhanillapachu nir. Chaymi, Jesuspis paykunataqa niran: —Chayqa nuqapis manami willashaykillapachu, mayqan mantamatinmi tukuy kaykunata rurani nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Chaynullami Jesusqa chay mantakuq runakunataqa tapuranpis: —¿Imatataq yarpunkillapa qamkunaqa kaypaqqa? Karanmi uk runa ishkay wamrayjun. Chaymi uk wamrantaqa niran: ‘Wamray, riy kananqa ubata tarpushanchik ĉhakranchikman trabajaq’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Piru wamranqami kaynu niran: ‘¡Manami kananqa trabajanayanichu!’ nir. Chaymanta, chay wamraqa manami allintachu tukuyani taytayta mana kasurqa nir kwintata qukar, ashwan riran trabajaqqa. ");
INSERT INTO qufNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Chaymanta qashan taytanqa riran uknin wamranta willaq rinanpaq trabajaq. Chay wamraqami niran: ‘Arí, taytituy rishaq’ nir. Piru chaynu nirmapismi mana riranchu. ");
INSERT INTO qufNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Mabir willamayllapa: ¿Kay ishkantinmantaqa mayqannintaq taytan munayashantaqa rurasha kanqa? Paykunaqa niranllapa: —Punta chaymi nir. Chaymi Jesusqa niran paykunataqa: —Chiqaptami nishaykillapa: Chay Roma pwiblupaq impwistuta kubrakuqkuna, chay warmikuna uk uk runawan tasha kaqkunaqami, syilumanta kaq mantakuyashanmanqa qamkunamantaqa naypaqta yaykunqallapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Chaqa Shutichikuq Juan shamur allin kaqlata rurar kawsananllapapaq yaĉhachikutinqami, qamkunaqa mana kasuraykillapachu. Piru chay Roma pwiblupaq impwistuta kubrakuqkuna, chaynulla chay warmikuna uk uk runawan tasha kaqkunaqami, intrakar kriyiranllapa. Nataq qamkuna-shuypaqami tukuy chayta rikarmapis karanlla kar, mana imanupis kriyiraykillapachu. ");
INSERT INTO qufNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“¡Allita uyakuyllapa! Kay kumparasyuntapis parlashaykillapa: Uk runami ĉhakranpi ubata tarpur, ridurninta limpu patyuta ruraran. Chaynullami ruraranpis uk quĉhata chaypi binuta lluqshichinanpaq. Chaynulla uk shuytulla kusala atun wasita yupay ruraran, chaypa ananman iqar chay ĉhakranta chapananpaq. Chaymantaqa ayka runakunata chay ĉhakranta arrintar riran largu mayta. ");
INSERT INTO qufNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Chaymanta kusicha tyimpu ĉhamutinqa, chay ĉhakrapa amunqa kaĉhamuran sirbikuqninkunata, chay kusichakushanmanta paypaq kaq partintaqa qunanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Piru ashwan chay ĉhakrapi kaqkunaqami, chay sirbikuqninkunataqa aypar wakinkunataqa maqaranllapa. Nataq uktaqa wanuchiranllapa. Chaynulla uktaqa rumillawan sitaranllapa ima. ");
INSERT INTO qufNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Chaymantami chay ĉhakrapa amunqa chay punta kaĉhashanmantaqa mastana sirbikuqninkunataqa kaĉhamuran. Piru chay ĉhakrapi kaqkunaqami imanutaq chay punta kaqkunata ruraran chaynulla ruraran. ");
INSERT INTO qufNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Chaymanta tukukananta-shuypaqami wamrantana kaĉhamuran, kaynuta yarpur: ‘Wamrayta-shuypaqami kusalata rispitar kasunqallapa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Chayna wamranta kaĉhatin, chay ĉhakrapi kaqkuna rikarqa, ninakuranllapa: ‘Wakmi kay pachataqa irinsyanpaq aypayanqa. ¡Ashwan wanuchishunllapa nuqanchikkunana kay pachanwanqa kidanallapapaq!’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Chaynu nirmi aypar chay ĉhakramanta urqumur wanuchiranllapa”. ");
INSERT INTO qufNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Chaynu nirqa kaynu tapuran paykunataqa: —¿Chay ĉhakrapa amun shamurqa, chay ĉhakrapi kaqkunawanqa imatataq rurayanqa nir yarpunkillapa qamkunaqa? ");
INSERT INTO qufNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Paykunaqa niranllapa: —Chay kusala mana allin runakunataqami mana llakiparchu limpu wanuchir tukchiyanqa. Chaynami ashwan ukkunatana arrintar dijayanqa, chay paykunaqa kusicha tyimpu ĉhamutinqa amunpaq kaqtaqa karantana qunanllapapaq nir. ");
INSERT INTO qufNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Chaymantami Jesusqa niran paykunataqa: —¿Manachu qamkunaqa liyishaykillapa, Dyus nitin iskribikashakunataqa? Chaqa chaypiqa kaynu nin: ‘Chay llutakuqkuna kay rumiqa mana sirbinchu nir itakushanllapami, ashwan kusala shumaq rumipaq tikrakasha. Piru tukuy chaynu kananpaqqa Dyusmi chaynuqa ruraran. Chaymi ashwan paylata alabashunllapa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Chayraykumi nishaykillapa: Qamkunaqami chay rumi mana sirbiqta yupay nuqata disprisyamashaykillaparayku Dyus mantakuyashanmanqa mana yaykunkillapachu. Ashwanmi chay mayqanĉhi Dyus munashannulla uk puquq yupay rurayan chaykunami tukuy tyimpupaq kawsaqqa rinqallapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Chaymi nini, chay rumipa ananman mayqanpis rataqqa, limpu limpu llampunqa. Nataq, runapa ananman rumi ratar-shuypaqa, limpu limpu pulbupaq tikranqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Chaynu nir Jesús kumparasyunta parlakutin, chay kurakunapa mantakuqninkuna, fariseo runakuna ima uyaparqa, kwintata qukaranllapa paykunapaq rimayan nir. ");
INSERT INTO qufNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Chaymi Jesusta aypar wanuchiyta yarpurllapamapis, manchakuranllapa. Chaqa tukuy runakunami kriyiranllapa Jesusqa, Dyuspa uk rimaqnin nir. ");
INSERT INTO qufNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesusqami qashan kumparasyunkunawan willaq qallariran. Chaymi kaynu niran: ");
INSERT INTO qufNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Syilumanta kaqpa mantakuyninqami, imanutaq uk mantakuqmaqa fyistata ruraran wamranta kidachinanpaq chaynu. ");
INSERT INTO qufNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Chaymi chay fyistaman shamunanllapapaq sirbikuqninkunata kaĉhakuran qayamunanllapapaq chay kunachikasha kaqkunataqa. Piru chay kunachikasha kaqkunaqami mana rinaranllapachu. ");
INSERT INTO qufNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Chaymanta qashan kaĉharan uk sirbikuqninkunatana chay kunachikashakunataqa kaynu ninanllapapaq: ‘Mikuykunatami kamakachishana kani. Kaĉhakutiymi kusala gurdulla animalkunata wanuchir kusala shumaqta kamkachishallapana. Chaynumi tukuy listuna kidamyintuman shamunaykillapapaqqa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Piru chaynu nitinllapamapismi chay kunachikasha kaqkunaqa mana shamunaranllapachu. Chaymi ashwan paykunamanta ukninqa ĉhakrankunata rikaq riranllapa. Nataq ukkuna-shuypaqa riran nigusyunkunaman. ");
INSERT INTO qufNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Piru ukkuna-shuypaqami chay mantakuqpa sirbikuqninkunata aypar qischaranllapa wanuchinanllapakaman. ");
INSERT INTO qufNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Chaymi chay mantakuqqa kusalata piñakur suldadunkunata kaĉhatin wanuchiranllapa chay kunachikasha kaq wanuchikushakunataqa. Chaynulla pwiblunllapata rupachinanpaq ima kaĉhakuran chay mantakuqqa. ");
INSERT INTO qufNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Chaymantami chay mantakuqqa sirbikuqninkunata kaynu niran: ‘Tukuymi listuna kidamyintupaqqa. Piru chay kunachisha karay chaykunaqami manana allinnachu shamunanpaqqa. ");
INSERT INTO qufNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Chaymi kananlla qamkunaqa riyllapa chay waqta kallikunaman. Chaynami chaypi tukuy tarishaykillapata kunachiyllapa shamunanllapapaq kay kidamyintumanqa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","“Chaymi chay sirbiqninkunaqa lluqshiranllapa kallikunaman. Chaypimi tukuy allin, mana allin yarpuyniyjun kaqkunata tarishantaqa kunachiran. Chaynumi chay mantakuqpa wasinmanqa kusala achka runakunata untachiranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Chaymanta chay mantakuqqa kunachishankunata rikaq wasinman yaykurqa, uk runata rikaran chay fyistapaq mana shumaq mudakur kamakashatachu. ");
INSERT INTO qufNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Chaymi kaynu niran: ‘Taytituy, waknu mana shumaq kamakasha karqa ¿imanutaq yaykamushayki kay fyistapi kanaykipaqqa?’ nir. “Piru chaynu nitinmapismi chay runaqa mana imatapis niranchu. ");
INSERT INTO qufNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Chaymantami mantakuqqa chay misapi sirbikuqkunataqa kaynu niran: ‘Wak runataqa makinta, ĉhakinta watar, waqta tutaparaqllamanna itakuyllapa. Chaymi chaypina kusala mana agwantaypaqta qischakar qayĉhakushanrayku kirunmatapis richyachinqa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Chaynu nirqami intrachimanchikllapa, Tayta Dyusqami kusala achkata qayamun. Piru payqami aykalata akran nir”. ");
INSERT INTO qufNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Chaymantami, chay fariseo runakunaqa rir paykunapura kusalata parlaranllapa, rir Jesusta tapur mana allinta rimachir chaylapaqna uchachananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Chaymi chay fariseo runakunaqa wakinninta, chaynulla chay gubyirnu Herodespa wakinninwan pullata kaĉharanllapa Jesusta kaynu ninanllapapaq: —Yaĉhachikuq Taytituy, yaĉhanillapami qamqa Dyus munashannulla chiqapta rimar yaĉhachikunkimapis. Chaynullami runakuna ima nitinpis qamqa mana kwintacharchu yaĉhachikunki. Chaqa qamqami mana runakunawan allinpi kanaykipaqchu yaĉhachikunkimapis. ");
INSERT INTO qufNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Chaymi qam yarpushaykinulla willamayllapa: ¿Allinchu kanqa impwistuta chay Roma pwiblupi mantakuq Cesarta, pagranayllapapaq, manaqachu mana? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Chaynu nitinllapami Jesusqa kwintata qukaran, mana allinta paypaq yarpurllapami chaynuqa tapuyanllapa nir. Chaymi kaynu niran paykunataqa: —Dyusta yanqa kasuq tukuq, kuchi runakuna ¿imapaqtaq mana allinta rimachir uchachamanayankillapa? ");
INSERT INTO qufNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Rikachimayllapa chay impwistuta pagrakunaykillapa qillayta nir. Chaynu nitinmi apamuranllapa uk qillay dinaryu shutiqta. ");
INSERT INTO qufNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Chayna Jesusqa paykunata tapuran: —¿Mayqanpa ritratuntaq kay qillaypiqa? ¿Mayqanpa shutintaq kay qillaypiqa iskribikasha? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Paykunaqa niranllapa: —Mantakuq Cesarpa nir. Chaymi Jesusqa niran: —Chaynu katinqa, gubyirnu Cesarpa kaqnintaqa payta quyllapa. Nataq Dyuspa kaqninta-shuypaqa Dyusta quyllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Chaynu nitin, uyaparllapami kusa dispantakashalla kidaranllapa. Chaymi ashwan Jesusta chaypi dijar riranllapana. ");
INSERT INTO qufNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Chay diyallami, wakin saduceo runakuna riranllapa Jesusta rikaq. Chaqa chay saduceo runakunaqami niqllapa: “Manashi wanuqkunaqa qashanqa kawsamunllapachu” nir. Chayraykumi Jesustaqa, mabir ima ninqashi nir kaynu tapuranllapa: ");
INSERT INTO qufNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Yaĉhachikuq Taytituy, Moisesmi kaynu nir mantakuran: ‘Mayqan warmiyjun kayar, manaraq wamrayjun kar wanutinqa, chay wanushapa ukninnashi kasarayanqa chay byuda warmiwanqa. Chayna chay wanusha ukninpaqqa wamrayjun kananpaq’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","“Chaynu katinmi tapushaykillapa: Uk kutimi syiti irmanukuna karanllapa. Kulakanllapami, warmikur manaraq wamrayjun kayar wanuran. Chaynu mana wamrayjun kashanraykumi chay ishkay kaq ukninna kasararan. ");
INSERT INTO qufNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Chaynullami chay ishkay kaqta, kimsa kaqta pasaran, chay syiti kaq ukninllapa kasarar wanunankaman. ");
INSERT INTO qufNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Chaymantami chay warmipis wanuranna. ");
INSERT INTO qufNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","“Chayna chiqapta wanushakuna kawsamuyatinqa, ¿mayqanninpa warmintaq kanqa chay warmiqa? Chaqa tukuynin-ari kasarasha karan chay warmillawan”. ");
INSERT INTO qufNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Chaynu nitinllapami, Jesusqa niran: —Qamkunaqami limpu pantasha puriyankillapa, Dyus nitin iskribikashanpaq, chaynulla paypa pudirninpaq mana intrakashaykillaparayku. ");
INSERT INTO qufNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Chaqa maydiya chay wanushakuna kawsamurqami, manana kasaranqallapanachu, chaynulla manana kasarachikunqallapalamapischu. Chaymi ashwan imanutaq Dyuspa angelninkunamaqa mana kasaranllapachu chaynuna kawsanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nataq chay wanushakuna kawsamuqpaq-shuypaqa, ¿manachu qamkunaqa liyishaykillapa Dyus paylla kaynu nitin iskribikashantaqa? Chaqa kaynumi niq: ");
INSERT INTO qufNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nuqaqami Abrahampa, Isaacpa, Jacobupa Dyusnin kani’ nir. Chayraykumi Tayta Dyusqa mana wanushakunapa Dyusninchu, ashwanmi tukuy kawsaqkunapa Dyusninla. Chaynu nirqami intrachimanchik, paypaqqami tukuy wanusha kaqkunamapis kawsayanllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Chaynu nir Jesús yaĉhachitinmi, chay runakuna uyakurqa kusa dispantakashalla kidaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Chaymantami chay fariseo runakunaqa, Jesusqashi chay saduceo runakunata willar uyarachisha nir yaĉharmi, tantakaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Piru paykunamanta ukqami Moisés mantakushanta kusata yaĉhar yaĉhachikuq karan. Chaymi Jesusqa ima ninqashi nir, kaynu tapuran: ");
INSERT INTO qufNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Yaĉhachikuq Taytituy, ¿Dyus nitin Moisés mantakushanmantaqa mayqannintaq kusa mas allinqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesusqa niran: —‘Taytayki Dyusta munay tukuy shunquykiwan, bidaykiwan, yarpuynikiwan’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kaymi chay puntapi kaq kusa mas allin mantakuyqa. ");
INSERT INTO qufNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Piru kanmi ukpis chay punta chay yupay kusala mas allin mantakuyqa. Chayqami kaynu nin: ‘Llakiy runa masikikunapaq, imanutaq qampa kwirpuykillapaq llakinki chaynulla’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Chaymi nishaykipis: Kay ishkay mantakuykunata karanta rurarqami, Dyus tukuy mantakushantaqa kumpliyanchikna nir. ");
INSERT INTO qufNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Piru chay fariseo runakuna chaypi tantakasha katinllaparaqmi, ");
INSERT INTO qufNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesusqa kaynu tapuran: —¿Imatataq yarpunkillapa Dyuspa Akrashan Cristunpaqqa? ¿Mayqanpa ayllunmantataq kanqa? nir. Chaymi niranllapa: —Davidpa ayllunmantami nir. ");
INSERT INTO qufNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Chaymantami Jesusqa niran: —Chaynu katinqa, ¿imapaqtaq Davidqa, ‘Amituy’ niran Cristupaqqa, Dyuspa Ispiritun yanapatinqa? Chaqa Davidqari kaynu niran: ");
INSERT INTO qufNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Tayta Dyusmi, Amituytaqa kaynu niran: Tay allilaw qichqaypi, maydiya chay ĉhiqnishuqkunata ĉhakikipa ĉhakinman ĉhuranaykaman nir’. ");
INSERT INTO qufNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Mabir willamayllapa: Davidpa ayllunmanta Dyuspa Akrashan Cristun katinqa, ¿imapaqtaq Davidqa ‘Amituy’ niran? ");
INSERT INTO qufNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Chaynu nitinmi mana mayqanninpis imata willaytapis puytiranllapachu. Chaymi chaymanta-pachaqa, manana imata tapunanllapapaqpis yarpuranllapanachu. ");
INSERT INTO qufNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Chaymanta Jesusqa chaypi kaq runakunata, yaĉhakuqninkunata ima kaynu niran: ");
INSERT INTO qufNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Moisés mantakushanta yaĉhar yaĉhachikuqkuna, chaynulla fariseo runakunaqami kaynu yarpunllapa: ‘Nuqanchikkunaqami Moisés mantakushanta kusa allita intrakashanchikllaparayku, yaĉhachikur mantakunchikllapa kumplinanllapapaq’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Chayraykumi, paykuna imata nitinpis kasur rurayllapa. Piru amami chay paykuna rurayashantaqa rurankillapachu. Chaqa paykunaqami chaynu yaĉhachikuyarmapis, ashwan uktana rurasha rikarinllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Chaynumiri ashwan paykunaqa uk kusala llashaq kargata aprichiq yupay runa masinkunata imata rurananpaq nir mantanllapa. Piru chay niyashanllapataqa mana pitilamatapis kumplinanpaqqa yarpunllapalamapischu. ");
INSERT INTO qufNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Chaymi paykunaqa imata rurarllapapis runakuna rikananllapalapaq ruranllapa. Chaynullami allita Dyuspi kriyin ninanllapapaqpis Dyus nishankunata taksha papilsitukunapi iskribir urkunkunapi, rikrankunapi ima ĉhurar purinllapa. Chaynullami Dyus mantakushankunapi kusata yarpur kawsanllapa ninanllapapaqpismi mudananllapa manyanpipis kusala atun shulyakunata ĉhurakunllapapis. ");
INSERT INTO qufNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Chaymi, chay tantakananllapa wasikunapi, manaqa mikunanpaq apatinllapamapis, kusa runapaq riqsir chay kusala shumaq samanakunapi samachinanllapata munanllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Chaynullami plasakunapimapis kusala shumaqta saludar, ‘Yaĉhaq yaĉhachikuq’ ninanllapata munanllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Piru qamkuna-shuypaqa manami wakinkuna ‘Yaĉhaq yaĉhachikuq’ nishunanllapataraqqa ministinkillapachu. Chaqa qamkunaqami uk ayllulamanta kaq yupay tukuynikillapa chaylla kankillapa. Nataq uklami kan yaĉhaq yaĉhachishuqnikillapaqa. ");
INSERT INTO qufNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Chaynullami kay pachapiqa ama mayqantapis, ‘Taytay’ ninkillapachu. Chaqa unaq syilumanta kaq uklami Taytaykillapaqa. ");
INSERT INTO qufNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Amami ‘Kusa intrachikuq tayta’ nishunanllapataqa munankillapachu. Chaqa uklami kan intrachishuqnikillapaqa. Payqami Dyuspa Akrashan Cristun. ");
INSERT INTO qufNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Chayraykumi qamkunamanta wakinkuna kusa masta yaĉhaq kaqqa, ashwan wakinkunatana sirbinqa. ");
INSERT INTO qufNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Chaqa mayqanpis pay yarpuyninllamanta ‘Kusana kani’ niqkunataqami Tayta Dyusqa mana kwintachanqachu. Nataq mayqanpis kusa karmapis mana kwintachaypaqla tikrakaqtaqami kusa nishapaqna Dyusqa riqsinqa”. ");
INSERT INTO qufNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Jesusqami kaynu niranpis: “¡Akaw Moisés mantakushanta yaĉhar yaĉhachikuqkuna, chaynulla fariseo runakuna, qamkunaqami Dyusta yanqa kasuq tukuq kuchi runakunala kankillapa! Chaynu karmi wakinkuna syilumanta kaqpaq allita intrakar washakananllapataqa mana munankillapachu. Chaynulla qamkunapismi mana munashaykillaparayku mana washakankillapachu. Chaymi ashwan wakinkuna intrakar ima washakananllapapaqmapis mana dijankillapachu.  ");
INSERT INTO qufNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“¡Akaw Moisés mantakushanta yaĉhar yaĉhachikuqkuna, chaynulla fariseo runakuna, qamkunaqami Dyusta yanqa kasuq tukuq kuchi runakunala kankillapa! Chaymi chay wakcha warmikunata kitankillapa wasinkunata ima. Piru allin runa nishunanllapapaqqami kusala unayta Dyusman mañakuq yupay tukunkillapa. Chayraykumi kusala manchaypaqtana kastigakankillapa. ");
INSERT INTO qufNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“¡Akaw Moisés mantakushanta yaĉhar yaĉhachikuqkuna, chaynulla fariseo runakuna, qamkunaqami Dyusta yanqa kasuq tukuq kuchi runakunala kankillapa! Chaynu karmi qamkunaqa tukuy pachata ima rinkillapa uk runallataqa qamkuna yupay kananllapapaq yaĉhachinaykillapapaq. Piru mayqan runatapis qamkuna yupay kananpaq kriyichirqami, qamkunamanta ishkay kuti mas uchayjunpaqna tikrayankillapa. Chaymi ashwan kusala manchaypaqta tukuy tyimpupaq kastigakashana kanqa. ");
INSERT INTO qufNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“¡Akaw imanankillaparaq qamkuna syigu mana allita intrakaq karmapis intrachikuyta munaqkunaqa! Chaqa qamkunaqami, kaynu nir yaĉhachikunkillapa: ‘Mayqan imata rurananpaq nir Dyusta adurananllapa wasipaq rimar jurar, mana rurarmapisshi mana uchayjunchu kanqa. Nataq Dyusta adurananllapa wasipi uru kaqpaq rimar imata rurananpaq jurar mana rurar-shuypaqashi uchakuyan’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Akaw yaru syigukuna! Tapushaykillapa: ¿Mayqannintaq mas allinqa, Dyusta adurananllapa wasi, manaqachu chaypi kaq uru? Chaqa chay uruqami Dyusta adurananllapa wasipi kashanrayku Dyuspaqqa kusala allin. ");
INSERT INTO qufNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Qamkunaqami ninkillapapis: ‘Mayqanpis imata rurananpaq altarpaq rimar jurarpisshi mana chiqapta arnikuq yupaychu. Nataq chay ufrindita altarpi tayan chaypaq rimar jurarshi, chiqapta imata rurananpaqpis arnikuyan’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Akaw syigu kaqkuna! ¿Imataq mas allinqa: Chay altarpi ufrindita, manaqachu altar? ¿Manachu chay ufrinditaqa ashwan altarpi kashanrayku kusala mas allinpaq tikrakan? ");
INSERT INTO qufNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Chaymi nishaykillapa: Mayqanpis, altarpaq jurarqa, manami altarlapaqchu jurayan. Ashwanmi tukuy imankuna chaypi kaqkunapaq ima jurayan. ");
INSERT INTO qufNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Chaynulla mayqanpis Dyusta adurananllapa wasipaq rimar jurarqa, manami chay wasilapaqchu jurayan. Ashwanmi Dyusllapaq rimar jurayan. Chaqa payqami chaypi kawsan-ari. ");
INSERT INTO qufNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Chaymi syilupaq rimar juraq-shuypaqa, Dyus tar mantakuyashanpaq jurayan. Chaynullami jurayanpis Dyusllapaq rimar. Chaqa payqa chaypiri tan. ");
INSERT INTO qufNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“¡Akaw Moisés mantakushanta yaĉhar yaĉhachikuqkuna, chaynulla fariseo runakuna, qamkunaqami Dyusta yanqa kasuq tukuq kuchi runakunala kankillapa! Chaynu karmi qamkunaqa mintamanta, anismanta, kuminumanta ima dyis parti kaqmanta uksituta qunkillapa Dyuspaq nir. Piru Dyus mantakushanpi nin: Ukninchikkunawan imatapis karanta ruranapaq, llakipakunapaq, paylapi kriyinapaq niyan chaytaqami mana rurankillapachu. Ashwanmi kay yarpuchishushayllapata rurankimanllapa naypaqtaqa, chay rurayashaykillapatapis ama dijarchu. ");
INSERT INTO qufNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","“¡Akaw imanankillaparaq qamkuna syigu kusala mana allinta yaĉhachikuqkunaqa! Chaqa qamkunaqami Moisés mantakushanta allita kasur yaĉhachikushaq nirqa, imanutaq yakuta mayqanpis upyananpaq katin, chay yakupi uk chuspisitu katinmaqa shuyshur upyan, chaynu yupay tukunkillapa. Piru manami kwintata qukankillapachu, chaynu tukurqami ashwan uk kamilluta iqachiq yupayna kusala mana allita tukuyankillapa. ");
INSERT INTO qufNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","26","“¡Akaw Moisés mantakushanta yaĉhar yaĉhachikuqkuna, chaynulla fariseo runakuna, qamkunaqami Dyusta yanqa kasuq tukuq kuchi runakunala kankillapa! Chaynu karmi qamkunaqa kusala bwinu yupay tukunkillapa. Piru ukkunata yanapanaykillapamantaqa ashwan kusalata munapakur suwankillapa. ¡Ima kabal yaruĉhiri kankillapa! Chiqaptari wakinkunawan bwinu kankimanllapa. Chaqa mana chaynu karqami, imanutaq uk kupa, manaqa uk platumataqa waqtanlawlata pichashaqa, rurinqa tiqtilla kidan, chaynu kankillapa qamkunapis. Piru uk kupata manaqa uk platuta rurintinta pichashaqami, intirulana kusa chiqap shumaq kidan. ");
INSERT INTO qufNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","28","“¡Akaw Moisés mantakushanta yaĉhar yaĉhachikuqkuna, chaynulla fariseo runakuna, qamkunaqami Dyusta yanqa kasuq tukuq kuchi runakunala kankillapa! Chaqa chaynu karmi qamkunaqa kusala bwinu, karanlata imatapis ruraq yupay tukunkillapa. Piru chiqaptaqami mana chaynuchu kankillapa. Ashwanmi yanqa illaqta chaynu tukuqkuna, kusala mana allinkuna ima kankillapa. Chayraykumi qamkunaqa imanutaq uk bubidamataqa waqtanlawta yuraqta pintatinllapamaqa kusala shumaq. Piru rurinpiqami tullukuna, kusala saqra asyaq ima kan, chay yupaymi qamkunapis kankillapa. ");
INSERT INTO qufNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“¡Akaw Moisés mantakushanta yaĉhar yaĉhachikuqkuna, chaynulla fariseo runakuna, qamkunaqami Dyusta yanqa kasuq tukuq kuchi runakunala kankillapa! Chaqa chaynu karmi qamkunaqa Dyuspa unay rimaqninkuna pampakashankunata kusa shumaq wasikunata yupay kamakachinkillapa, kusala allin kashanrayku. ");
INSERT INTO qufNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Chaynullami ninkillapapis: ‘Nuqanchikkuna unay rukunchikkunapa pullan kawsasha karqa, Dyuspa rimaqninkunata wanuchinanllapapaqqa manami dijanallapatachu’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Piru chaynu unay rukunchikkuna nirqami, qamkunalla niyankillapa: ‘Dyuspa unay rimaqninkunata wanuchiqkunapa ayllun kanchikllapa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Chaynu karqa, unay rukuykillapakuna imata ruraq qallarishanllapataqa rurar tukchiyllapari! ");
INSERT INTO qufNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","34","“Chay rukuykikuna qallarishanta rurar tukchinaykillapapaqqami nuqaqa kaĉhamushaq Dyuspa rimaqninkunata, kusa yaĉhaq intrakaqkunata, yaĉhachikuqkunata ima. Chaymi qamkunaqa wakintaqa wanuchinkillapa, kruspi klabankillapa ima. Nataq wakinkunata-shuypaqa wipyankillapa ima tantakananllapa wasikunapi. Wakinta-shuypaqa pwiblun pwiblun ikinpi purinkillapa qischanaykillaparayku. Chaynu karmi ¡largu kurukuna, largu kurupa ayllunkuna kankillapa! ¿Imanuna washakankillapa chay tukuy tyimpu kastigakanaykillapamantaqa? ");
INSERT INTO qufNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Chayraykumi qamkunapaqqa tukuyla mana allinkunata rurashaykillaparaykuqa kusala manchaypaq kastigu shamunqa. Chay kusa allin runa Abel shutiqta wanuchishaykillapamanta-pacha Berequiaspa wamran Zacariaskaman. Chaqa pay Zacariastaqami qamkunapa rukuykillapakuna wanuchiran Dyusta adurananllapa wasipa, altarninpa naypanpi. ");
INSERT INTO qufNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Chaymi nishaykillapa: Chaynu chay kusala allin runakuna wanushanraykuqami, kanan tyimpu kawsaq runakunapaqna kastiguqa kanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“¡Akaw Jerusalén, Jerusalenmanta runakuna! Dyuspa rimaqninkunatami wanuchinkillapa. Chaynulla Dyus kaĉhamushan yaĉhachishuqkunatapis rumillawan sitar wanuchinkillapa. Kwichkaraq tantashuyllapata munaray, imanutaq uk pishqumaqa wawitunta tantala uqllakun chaynu. Piru manami munashaykillapachu. ");
INSERT INTO qufNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Chaqa rikayllapari, qamkunalanami kidankillapa. ");
INSERT INTO qufNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Chaymi nishaykillapa: Mananami rikamankillapanachu qamkuna kaynu nimanaykillapa tyimpu ĉhamunankaman: ‘¡Alabashunllapa Taytanchik Dyuspa shutinpi shamuqtaqa!’ nir”. ");
INSERT INTO qufNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Chaynu rimar tukchirna, Jesusqa Dyusta adurananllapa wasimanta lluqshir riranna. Chaynu riyatinmi, yaĉhakuqninkuna payman qimikar, Dyusta adurananllapa wasita kusala shumaqta ima rurashanllapapaq parlayaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Piru Jesusqami niran: “Kanan kayta rikayankillapa chaytaqami, limpu ratachinqallapa. Chiqaptami nishaykillapa: Mananami uk rumilamapis anapura llutakashaqa kidanqanachu nir”. ");
INSERT INTO qufNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Chaymantami Jesusqa yaĉhakuqninkunawan Olivos sirkaman riranllapa. Chaymi chaypi Jesús tatin, chay yaĉhakuqninkunaqa kaynu nir paylata tapuranllapa: —Willamayllapa: ¿Maydiyataq chaynuqa pasayanqa? Chaynulla ¿ima siñalta rikartaq yaĉhayashaqllapa qam tikrakamuyankina nir, chaynulla kay pacha tukukanan tyimpu ĉhamunqa nirqa? ");
INSERT INTO qufNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Chaymi, Jesusqa niran: —Allitami kuytakankillapa, ama mayqanpis ingañar pantachishunanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Chaqa kusala achkami nuqa yupay tukur shamunqallapa. Chaymi, ‘Dyuspa Akrashan Cristunmi kani’ nir, kusa achka runakunata ingañanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Qamkunaqami chay tyimpukunaqa uyapankillapa wakpi kaypi guerrata rurayanllapa nir. Piru chaynu katinmapis amami manchakunkillapachu. Chaqa chaynumiri pasanqa. Piru chaynu pasatinmapis manaraqmi pacha tukukanan tyimpuraqchu kanqa. ");
INSERT INTO qufNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Chaqa uk nasyunmanta kaqkunami maqanakunqallapa uklaw nasyunmanta kaqkunawan. Chaynulla uk gubyirnupa kaqninkunapis maqanakunqallapa uklaw gubyirnupa kaqninkunawan. Kusala qishay, mallaq tyimpu ima kanqa. Chaynulla pachamapis kusalata kuyunqa achka lugarkunapi. ");
INSERT INTO qufNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Piru chaynu pasatinqami yarpunkillapa, chayraqmi qischakay tyimpuqa qallariyan nir. ");
INSERT INTO qufNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Chaymi ashwan chay tyimpuqa qamkunataqa qukushuyanqallapa kusalata qischar ima wanuchishunanllapapaq. Chaynumi tukuyla kay pachapi ĉhiqnishunqallapa nuqapi kriyishaykillaparayku. ");
INSERT INTO qufNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nataq kusala achka wakinnikikunaqami chay tyimpukunapiqa manana kriyinanqallapanachu. Chaymi ashwan ĉhiqninakur ima paykunapura ukninpaqmapis mana allinta rimapanakunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Chaynulla Dyuspaq kusala achka rimaq tukuqkuna rikarimunqallapa. Chaynumi ashwan kusala achka runakunata ingañanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Chaymi chay tyimpukunaqa kusala mana allin ruraykunalana kanqa. Chaynu katinmi, tukuyla mayqanpis manana ukninkunapaqqa llakinqallapa imanachu. ");
INSERT INTO qufNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Piru chaynu qischakar imamapis maydiya shamunaykaman kriyishannulla shachinakuqkunalami washakanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Nataq tukuy intirupi Dyuspa shumaq rimayninta washakananllapapaq yaĉhachikur tukchishana katinllapami, kay pacha tukukananpaq tyimpuqa ĉhamunqa. ");
INSERT INTO qufNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Chayraykumi Dyuspa rimaqnin Danielmaqa kaynu nir iskribiran: ‘Uk kusala mana allinta rurachikuqmi rir yaykunqa, Dyusta adurananllapa wasipa Kusala Santu Lugarman’ nir. Chaymi qamkuna chaynu pasaqta rikarqa, Daniel iskribishanmi kumplikayan nir yarpunkillapa. ");
INSERT INTO qufNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Chaymi chay Judea lugarpi kaqkunaqa sirkakunaman alsakanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nataq mayqanpis wasinpa ananpi karpis, amami ishkimunqachu, imanta lluqshichinanpaq nirqa. ");
INSERT INTO qufNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Chaynulla, mayqan ĉhakranpi karqa amami wasinman rinqachu raĉhpanta apananpaq nirqa. ");
INSERT INTO qufNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Akakaw chay diyakunapi warmikuna ruriyjun, manaqa ñuñuq wamrayjun kaqkunaqa imananqallaparaq! ");
INSERT INTO qufNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Chaymi ashwan qamkunaqa Taytay Dyusman alliplata mañakuyllapa, chay alsakanaykipaq tyimpuqa ama qasay tyimpu, manaqa samana diyapichu kananpaq nir. ");
INSERT INTO qufNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Chaqa, chay diyaqami kusala saqra manchaypaq qischakay kanqa. Chaynu qischakayqami pacha rurakashanmanta-pacha mana kashachu. Chaynulla mananami kanqanapischu chaynu qischakayqa maydiyapis. ");
INSERT INTO qufNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Piru Taytay Dyus chay qischakaykuna achka tyimputa kanqa nitinqami, mana mayqanlapis washakanmanchu. Ashwanmi Taytay Dyusqa chay akrashan kaq wamrankunapaq llakir washananrayku, mana kusala achka tyimputachu kanqa niyanqa. ");
INSERT INTO qufNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Piru imanupi mayqan kaynu nishunmanllapa: ‘Rikayllapa kaypimi Dyuspa Akrashan Cristunqa’, manaqa ‘Rikayllapa chaypi’ nishutinllapaqa, amami kriyinkillapachu. ");
INSERT INTO qufNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Chaqa Dyuspa Akrashan Cristun yupay tukuqkuna, chaynulla Dyuspa unay rimaqninkuna yupay tukuqkunami rikarimunqallapa. Chaymi paykunaqa mana ruraypaq imakunata, milagrukunata ima kusalata ruranqallapa. Chaynumi ashwan kusala achka runakunata ingañanqallapa. Chaynullami chay kriyiqkunamatapis imanullapis ingañayta kamanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Piru qamkuna ama ingañakanaykillapapaqqami willashunillapana. ");
INSERT INTO qufNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Chayraykumi mayqan ‘Rikayllapa wak chunllaq lugarpi washakuqqa’ nishutinllapaqa, ama rinkillapachu rikaqqa. Manaqa ‘Rikayllapa kaypimi pakakusha washakuqqa’ nishutinllapapis, amami pitilamatapis kriyinkillapachu. ");
INSERT INTO qufNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Chaqa Dyusmanta Shamuq Runa tikrakamurqami, kusa shutilla shamunqa, imanuĉhi rilampamaqa uklawmanta uklawkaman intirula llipyalla achkirachikun chaynu. ");
INSERT INTO qufNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Allitami nishaykillapa: Maypiĉhi kusala achka shinkukuna tantakaqta rikarqami ninkillapa, ima wanusha kanqa nir tukuyla yaĉhankillapa. Chaynumi nuqa Dyusmanta Shamuq Runa shamutiypis tukuyla yaĉhankillapana. ");
INSERT INTO qufNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Chaynu limpu qischakay tyimpukuna pasatinnaqami, rupayqa limpu tutaparaq intiru kidanqa. Killapismi mana achkirachikunqanachu. Chaynulla qullarkunapismi limpu syilumantaqa ratamutin ima tukuy syilupi kaqkunamapis kusalata kuyunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Chaymantami unaq syilupiqa rikankillapa Dyusmanta Shamuq Runapaq uk siñalta. Chayta rikarmi tukuyla pachapi kaqkunaqa kusala ukmanta manchakur waqanqallapa. Chaqa chayllapimi Dyusmanta Shamuq Runataqa rikanqallapa, puktay rurita kusa pudirninwan, llipya intiru syilumanta shamuqtana. ");
INSERT INTO qufNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Chaynu shamurmi payqa angelninkunata kaĉhanqa trumpitanta kusala jwirtita waqachir tukuyla pachata rir, paypa akrashan kaqkunata tantamunanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Allita uyakur intrakayllapa kay igus qirupaq willar intrachishutiyllapa. Chaqa qamkunaqa igus qiru mushuqmanta qawamuqta rikarqa kwintata qukankillapa, tamya tyimpuqa shipchana nir. ");
INSERT INTO qufNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Chaynullami chay nishushayllapanulla pasaqta rikarqa yarpunkillapana Dyusmanta Shamuq Runaqami shamunanlapina nir. ");
INSERT INTO qufNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Chaymi chiqapta nishaykillapa: Chay tyimpupi kaq runakunaqa manaraq wanuyatinraqmi tukuyla kay nishushayllapaqa pasanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Chaqa syilu chaynulla kay pachamapismi tukukanqa. Piru nuqa nishaykuna-shuypaqami mana maydiyalapis tukukanqachu. ");
INSERT INTO qufNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Piru Dyusmanta Shamuq Runa shamunanpaq diyapaq, urapaq-shuypaqami, mana mayqanlapis yaĉhanchu. Chaynulla syilumanta angelkuna, Dyusmanta Shamuq Runamapis manami yaĉhanchu. Nataq Taytaylami yaĉhan. ");
INSERT INTO qufNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Nishaykillapapis: Imanuĉhi Noepa tyimpunpi pasaran chaynullami pasanqa Dyusmanta Shamuq Runa tikrakamutinpis. ");
INSERT INTO qufNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Chaqa chay kusala manchaypaq tamya manaraq ishkiyatin, chaynulla Noé wampuq wasiman yaykunankamanmi, runakunaqa kusalata mikuqllapa, upyaqllapa, kidachinakuqllapa ima. ");
INSERT INTO qufNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Piru manapis yarpuyatinllapa alliplata tamya ishkitinmi limpu tukukaranllapa. Chaynumi Dyusmanta Shamuq Runa tikrakamutinpis pasanqa. ");
INSERT INTO qufNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Chaymi chay urasqa ishkay runakuna ĉhakranpi katinpis, ukninta apar, ukninta-shuypaqa dijanqa. ");
INSERT INTO qufNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Chaynullami ishkay warmikuna kutakuyatinpis, ukninta apar, nataq ukninta-shuypaqa dijanqa. ");
INSERT INTO qufNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Chayraykumi qamkunaqa imuraspis rikĉhakur allita kamakashalana kankillapa. Chaqa manamiri yaĉhankillapachu ima diyami Amituykillapa shamuyanqa nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Chaqa allita yarpuyllapa: Uk wasipa amun imurasmi uk suwakuq ĉhamuyan suwamaq nir yaĉharqa, imuraspis rikĉhakushala kar, mana dijanmanchu mayqanpis wasinman yaykur suwananllapataqa. ");
INSERT INTO qufNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Chaynullami qamkunapis, imuraspis alamirala kayllapa. Chaqa Dyusmanta Shamuq Runaqami, manapis yarpuyatkillapa shamunqa. ");
INSERT INTO qufNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Nishaykillapapis: Uk runami sirbikuqninta wasinpi kaq wakin sirbikuqninkunata imuraslapi qarananpaq nir inkarganman. Chaymi chay sirbikuqqa chay patrunnin nishannula rurar, kusa alamirala kaqta tarinman. ");
INSERT INTO qufNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Chaynuta chay sirbikuqta patrunnin taritinqami, kusala allin sirbikuqpaqna riqsikasha kanqa. ");
INSERT INTO qufNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Chiqaptami nishaykillapa: Chay patrun chay sirbikuqta pay nishanlata ruraqta tarirqami, ashwan tukuy iman kaqtapis pay rikananpaqna quyanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Piru imanupi chay sirbikuq mana allin yarpuyniyjun kar, chay patrunnin mana das ĉhamuyanqachu nir yarpur, ");
INSERT INTO qufNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","chay sirbikuq masinkunata qischar, payqa chay maĉhaqkunawan tantanakur upyar mikur ima tar, ");
INSERT INTO qufNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","mana imuras ima diya ĉhamuyanqa nir yaĉhayatinchu, patrunnin ĉhamur chaynu ruraqta tarirqami, ");
INSERT INTO qufNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","kusala saqra manchakuypaqta kastigayanqa Dyusta yanqa kasuq tukuq kuchi runakunata yupaylla. Chaynami payqa kusala mana agwantaypaqta qischakar qayĉhakushanrayku kirunmatapis richyachinqa”. ");
INSERT INTO qufNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Chaynullami Jesusqa niranpis: “Syilumanta mantakuq shamunanpaqqami imanutaq uk kuti dyis shipashkuna kidamyintuman riran chay yupay kanqa. Piru chay dyis shipashkunaqa lamparanllapata asaytiyjunta charikur riranllapa chay kidaq runata tariq. ");
INSERT INTO qufNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Piru chay dyis shipashkunamantami sinkuqa askwintalla puriqllapa. Nataq sinku kaqkuna-shuypaqa allita kamakashala puriqllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Chaymi chay askwintalla puriqkunaqa lamparanta aparanllapa asaytiyjunta. Piru manami mas asaytitaqa aparanllapachu tukukatin untachinanllapapaqqa. ");
INSERT INTO qufNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nataq chay kusa kamakashalla puriqkunami asaytita chaynulla lamparanllapatapis aparanllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Piru chay kidananpaq kaq runa mana das ĉhamutinmi, kusalata pununar tukuynin punuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Chaymantami ĉhaypi tuta yupaynaqa kaynu nir qayakuqta uyaparanllapa: ‘¡Kidaq runaqami shamuyanna! ¡Lluqshimuyllapa samachinaykillapapaq!’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Chaynu niqta uyaparmi, chay shipashkunaqa tukuynin sharir lamparanllapata kamakachiq ĉhurakaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Chaymantaqa chay sinku shipashkuna askwintalla puriqkunaqa chay sinku shipashkuna kusa kamakashala puriqkunataqa kaynu niranllapa: ‘Imaraq pitilamatapis asaytisituykillapata apamushaykillapamanta qumastuyllapa. Chaqa lamparayllapami wanuyanna asaytin tukukayashanrayku’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Piru chay kamakashala puriq shipashkunaqa kaynu niranllapa: ‘¡Mana puytinillapachu! Chaqa chaynu qushutiyllapaqami, mana aypanqachu nuqakunapaq chaynulla qamkunapaqmapis. Ashwanmi mas allin kanqa qamkunalla rir chay maypiĉhi rantikun chayllamanta qamkunapaqqa rantinaykillapapaq’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Chaynu nitinllapami chay askwintalla puriq shipashkunaqa riranllapa rantiq asaytitaqa. Piru chaykamanqami chay kidaq runa ĉhamutinqa, chay sinku kusa kamakashala puriq shipashkunaqa chay kidaqwan pulla ruriman yaykur kirpakamuranllapana. ");
INSERT INTO qufNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Chaymanta chay sinku shipashkuna ĉhamurqa kaynu nir qayakuranllapa: ‘¡Taytituy, Taytituy, punkuykita kiĉhay!’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Piru chay kidaq runaqami rurimanta kaynu niran: ‘Chiqaptami nishaykillapa: Manami riqsishunillapachu’ nir”. ");
INSERT INTO qufNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Chaynu nir tukchirmi, Jesusqa paykunataqa kaynu niran: “Qamkunaqami rikĉhakur alli kamakashalana kayllapa. Chaqa manami yaĉhayankillapachu ima diya, ima urami shamuyanqa Dyusmanta Shamuq Runaqa nir”. ");
INSERT INTO qufNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Syilumanta kaqpa mantakuyninqami, imanutaq uk runamaqa uklaw pwibluman rinanpaqna karqa, sirbiqninkunata qayamur uk tratuta rurar qillayninta quran trabajachinanpaq, chay yupay. ");
INSERT INTO qufNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Piru chay sirbiqninkunataqami quran paykuna imanu trabajayta puytishannulla. Chaymi chay punta chaytaqa sinku talintu qillayta quran. Ukninta-shuypaqa ishkay talintu qillayta quran. Nataq ukta-shuypaqa uk talintu qillayta quran. Chaynu qillayninta trabajachinanpaq qurqami riranna chay runaqa. ");
INSERT INTO qufNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Chaymantami, chay uk sirbikuq sinku talintu qillayta ayparan chayqami, kusalata nigusyuta rurar trabajachir qillaytaqa ganachiran uk sinku talintu masta. ");
INSERT INTO qufNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Chaynullami, chay ishkay talintuta aypaqpis trabajarqa ganachiran ishkay talintu masta. ");
INSERT INTO qufNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nataq, chay uk talintu qillayta aypaq-shuypaqa mantaqninpa qillaynintaqa apar pachapi uĉhkukur pamparan. ");
INSERT INTO qufNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Chaymanta kusa unay tyimpumantami chay mantaqninllapaqa tikrakamuranna. Chaynu ĉhamurmi, mabir michkatashi ganachisha kanqallapa qillayniytaqa nir yaĉhanaranna. ");
INSERT INTO qufNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Chaymi puntataqa riran chay sinku talintu qillayta aypasha karan chay. Chaymi kaynu niran: ‘Taytituy qamqami sinku talintuta qumarayki. Kaypimi qillaynikiqa. Uk sinku talintu mastami ganachisha kani’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Chaynu nitinmi, mantaqninqa kaynu niran: ‘Allinpi. Qamqami kusa allin, imatapis karanta ruraq sirbikuq kanki. Chaynu chay pitila kaqpi kusa allin karanta rurashaykiraykumi kusa achka imaykunata rikanaykipaqna qushayki. Chaymi ashwan yaykamur nuqawan pulla aligriyay’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Chaymantami ĉhamuran chay ishkay talintuta aypasha karan chayna. Chaymi paypis kaynu niran: ‘Taytituy qamqami qumarayki ishkay talintu qillaynikitaqa. Kaypimi ishkay talintu masta ganachisha kani’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Mantaqninqami kaynu niran: ‘Allinpi. Qamqami kusa allin, imatapis karanta ruraq sirbikuq kanki. Chaynu chay pitila kaqpi kusa allin karanta rurashaykiraykumi kusa achka imaykunata rikanaykipaqna qushayki. Chaymi ashwan yaykamur nuqawan pulla aligriyay’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Piru chay uk talintuta aypasha karan chay ĉhamur-shuypaqami, mantaqnintaqa kaynu niran: ‘Taytituy, nuqami yaĉharay qamqa kusala miĉha kashaykirayku, mana tarpukushaykikunamanta kusichakunki, mana shikwakushaykikunamanta tantakunki nir. ");
INSERT INTO qufNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Chayraykumi, ashwan kusalata manchakur qillaynikitaqa pachapi uĉhkukur pamparay. Piru kaypimi qampa kaq qillaynikiqa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Mantaqninqami kaynu niran: ‘Qamqami kusala mana allin qilla sirbikuq kanki. Chaqa nuqa mana tarpukushaymanta kusichakuni, chaynulla mana shikwakushaymanta tantakuni nir yaĉharqa, ");
INSERT INTO qufNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","qillayniytaqa apar bankukunaman ĉhuratki ganaskinanta. Chayna tikrakamurqa qillayniytaqa ganashanwanna aypanaypaq’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Chaymi chaypi kaq runakunataqa, kaynu niran: ‘Chay uk talintu qillayniyta purichiqtaqa kitar, chay dyis talintu qillayniyjun kaqta quyllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Chaqa chay mayqanĉhi allinta rurashanrayku, imayjun kaqtaqami masta qushaq. Chaymi manana imanpis faltanqanachu. Piru chay mana allinta rurashanrayku mana imayjun kaqtaqami, pitila kaqninmatapis limpula kitashaq. ");
INSERT INTO qufNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Piru kay mana yarpuyta yaĉhaq, mana allin sirbikuqta-shuypaqami, aypar chay tutaparaqlla waqtaman itakuyllapa. Chaypinami payqa kusala mana agwantaypaqta qischakar qayĉhakushanrayku kirunmatapis richyachinqa’ nir”. ");
INSERT INTO qufNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jesusqami niranpis: “Dyusmanta Shamuq Runa angelninkunawan, kusa llipya intiru shamurmi, chay llipyalla mantakunanpina tanqa. ");
INSERT INTO qufNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Chaymi tukuyla nasyunmanta kaqkuna, paypa naypanman qimikatinna, payqa wakman kayman chiqanchanqa, imanutaq uk michikuqmaqa uyshankunata kabrakunamanta rakichin chaynu. ");
INSERT INTO qufNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Chaynu chiqancharmi chay uyshitakuna yupay kusa allinla kaqkunataqa allilaw qichqanman ĉhuranqa. Nataq chay kabrakuna yupay mana allin kaqkunata-shuypaqa ichuqlaw qichqanmanna ĉhuranqa. ");
INSERT INTO qufNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Chaymi mantakuqqa chay allilaw qichqanpi kaqkunataqa kaynu ninqa: ‘Qamkunatami Taytayqa akrar shumaqchashushallapana. Chaymi kayman shamuyllapa. Kananqami aypayllapana Taytay kay pachata rurashanmanta-pacha qamkunapaq kusa shumaq mantakuyta kamkachishanta. ");
INSERT INTO qufNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Chaqa mallaqnatiypismi qamkunaqa qaramaraykillapa. Yakunatiypis upyachimaraykillapa. Uk furastiru yupay puritiypis samachimaraykillapa. ");
INSERT INTO qufNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Raĉhpay faltamatinpis qamkunami qumaraykillapa. Qishaq katiypis watukumaraykillapa. Chaynulla karsilpi katiypismi watukumaraykillapa’. ");
INSERT INTO qufNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Piru chaynu nitiyqami chay kusa allinla kaqkunaqa kaynu nir tapumayanqallapa: ‘Taytituy ¿maydiyataq mallaqnatki qarashurayllapa? ¿Maydiyataq yakunatki, yakuta upyachishurayllapa? ");
INSERT INTO qufNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Maydiyataq furastiru yupay puritki samachishurayllapa? ¿Chaynulla maydiyataq raĉhpayki faltatin qushurayllapa? ");
INSERT INTO qufNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Maydiyataq qishaq katki manaqapis karsilpi katkiqa rir watukushurayllapa?’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Piru chay mantakuqqami kaynu ninqa: ‘Chiqaptami nishaykillapa: Qamkunaqami chay ukniykuna mana kwintachaypaqla kaqkunata ima ministishanpipis yanaparqami, nuqallapaq rurashaykillapa yupayna kanqa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Chaymantami mantakuqqa chay ichuqlaw qichqanpi kaqkunata-shuypaqa kaynu ninqa: ‘Mana allinta ruraqkuna, wakaq tukur riyllapa chay tukuy tyimpupaqna kastigakanaykillapapaq kasha kaqkunaqa. Chaynami ashwan riyllapa chay tukuy tyimpu ratakur mana wanuq nina kamakasha chay dyablu, chaynulla angelninkuna chaypi kananpaq chaymanna nir. ");
INSERT INTO qufNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Chaqa nuqa mallaqnatiypis, qamkunaqa mana qaramaraykillapachu. Yakunatiypis mana upyachimaraykillapachu. ");
INSERT INTO qufNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Furastiru yupay puritiypis mana samachimaraykillapachu. Raĉhpay faltamatinpis mana qumaraykillapachu. Qishaq katiy, karsilpi ima katiypis mana watukumaraykillapachu’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Piru chaynu nitiyqami paykunaqa kaynu nir tapumayanqallapa: ‘Taytituy, ¿maydiyataq mallaqnaqta, yakunaqta, furastiru yupay puriqta rikashur, raĉhpayki faltaqta, qishaq katki, karsilpi katki ima rikashur, mana yanapashurayllapa?’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Chaynu nitinllapami mantakuqqa kaynu ninqa: ‘Chiqaptami nishaykillapa: Kay mana kwintachaypaqla kaq runakunata mana ima ministishanpi yanaparqami, nuqallata mana yanapamashaykillapachu’ ”. ");
INSERT INTO qufNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Chaymi Jesusqa niranpis: “Paykunaqami tukuy tyimpupaq kastigakaqna rinqallapa. Nataq chay kusa allinlata rurasha chaykuna-shuypaqami tukuy tyimpupaq kawsaqna rinqallapa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesusqa limpu yaĉhachikur tukchirnaqa, kaynu niran yaĉhakuqninkunataqa: ");
INSERT INTO qufNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Qamkunami allita yaĉhankillapa, kaymanta ishkay diyamanta Pascua fyistata ruranllapa nir. Chay fyistallapimi Dyusmanta Shamuq Runataqa kuntrankunaman qukukayanqallapa kruspi klabar wanuchinanllapapaq”. ");
INSERT INTO qufNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Chaymi ashwan chay diyakunapiqa, kurakunapa mantaqninkuna, chay Israel runakunapa ruku mantakuqninkuna ima, chay kurakunapa mantaqnin Caifás shutiq runapa mantakunan wasinman tantakaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Chaynu tantakarllapami yarpuranllapa, imanullapis llullakuypi ima Jesustaqa aypar wanuchinanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Piru wakinkunaqa kaynu niranllapa: “Amami chay fyista diyakunapiqa chaynu rurashunllapachu. Chaqa runakunami piñakur kuntranchikllapa alsakamunmanllapa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesusqami Betania pwiblupi yaĉhakuqninkunawan karqa, uk runa Simón shutiqpa wasinman riranllapa. Kay Simonmi unayqa chay ismuyaq qishaywan karan. ");
INSERT INTO qufNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Piru Jesús chay Simonpa wasinpi kayatinmi, uk warmi payman qimikaran uk alabastru butillitapi kusa ĉhaniyjun mishkila mutkiypaq yakituta charikur. Chaymi ashwan Jesús misapi kanankamanqa, chay warmiqa Jesuspa umanman chay mishki yakitutaqa iĉharan. ");
INSERT INTO qufNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Chayta rikarmi Jesuspa yaĉhakuqninkunaqa piñakur kaynu niq ĉhurakaranllapa: —¿Imapaqtaq wak kusa ĉhaniyjunta yanqallaqa iĉhan? ");
INSERT INTO qufNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ashwanmi waknu yanqalla iĉhananmantaqa qumashallapa kusa karu rantikur, chay mana imayjun kaqkunata yanapanallapata nir. ");
INSERT INTO qufNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Chaynu nitinllapa uyaparmi Jesusqa kaynu niran: —¿Imapaqtaq qillakachinkillapa kay warmisitataqa? Payqami kusala allinta rurasha nuqawanqa. ");
INSERT INTO qufNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Chaqa chay mana imayjun kaqkunawanqami maydiyapis pulla kankillapa. Piru nuqa-shuypaqami manana pullaykillapanachu kashaq. ");
INSERT INTO qufNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kay warmisita nuqapa anayman mishki mutkiypaqla yakituta iĉharqami, kamakachimashana, kusa shumaqta pampakanaypaq. ");
INSERT INTO qufNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Chiqaptami nishaykillapa: Tukuy maylawpipis imanu kriyir washakananllapapaq nir yaĉhachikurqami, kay warmisita rurashantaqa yarpur rimanqallapa. Chaymi mana qunqanqallapachu. ");
INSERT INTO qufNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jesuspa dusi yaĉhakuqninkunamanta ukqa shutiq, Judas Iscariote. Chay paymi, kurakunapa mantaqninkunamanna rir, ");
INSERT INTO qufNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","kaynu niran: —¿Michkatataq pagramayankillapa kanqa nuqa, Jesusta qushutiyllapaqa? nir. Paykunaqami trinta suqu qillayta arniran pagrananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Chaymi chaymanta-pacha, Judasqa yarpuran maylapina, imurasna Jesustaqa qukushaq nir. ");
INSERT INTO qufNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Chay Pascua fyistapa punta diyanpi, tantata mana libadurayjuntachu mikuqllapa chay diyami Jesuspa yaĉhakuqninkunaqa payman qimikar kaynu nir tapuranllapa: —Pascua mikunataqa, ¿maypitaq kamakachinayllapata munayanki? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Payqa niran: —Pwibluman rir uk runapa wasinman ĉhankillapa. Chaymi chay wasipa amuntaqa kaynu ninkillapa: ‘Yaĉhachimaqniyllapami nin: Wanunaypaq uraqami shipchana. Chaymi kananqa wasikiman shamuyani yaĉhakuqniykunawan chay Pascua fyistata chaypi pasaq niyan nir’. ");
INSERT INTO qufNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Chaynu nitinmi yaĉhakuqninkunaqa Jesús nishannulla rir ruraranllapa. Chaynami kamakachiranllapa Pascua mikunataqa. ");
INSERT INTO qufNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Chaymanta tutapatinnaqa, Jesusqa dusi yaĉhakuqninkunawan misapi taranllapana. ");
INSERT INTO qufNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Chaynu tar mikuqnumi Jesusqa niran paykunataqa: —Chiqaptami nishaykillapa: Qamkunamanta uknikillapami kuntraykunaman qukumayanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Chaynu nitinmi, yaĉhakuqninkunaqa kusalata llakiranllapa. Chaymi uknin uknin kaynu nir Jesusta tapuq ĉhurakaranllapa: —Taytituy ¿nuqachu kashaq? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesusqa niran: —Qamkunamanta uknikillapa nuqawan chay platullapi tantata nuyuchir mikuqmi, kuntraykunamanqa qukumayan. ");
INSERT INTO qufNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Chaynuqami Dyus nitin iskribikashannulla, Dyusmanta Shamuq Runawanqa pasanqa. ¡Piru imananqaraq, chay kuntraykunaman qukumaqqa! Kusala allinĉhi kananta chay runaqa ama nasinanpaqchu. ");
INSERT INTO qufNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Chaymantami Judas, chay kuntrankunaman qukuq chayqa, kaynu nir tapuran: —Yaĉhachimaqniy ¿nuqachu kashaq? nir. Jesusqa niran: —Qamllami ninki. ");
INSERT INTO qufNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mikuyatinllapanaqa, Jesusqa uk tantata aypar Taytanta payji nir, pakir quran yaĉhakuqninkunata kaynu nir: “Kaypi mikuyllapa. Kayqami nuqapa kwirpuy” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Chaymanta uk kupata aypar Taytanta payji nir ima, quran chay yaĉhakuqninkunataqa kaynu nir: “Kaypi upyayllapa tukuy qamkuna kay kupamanta. ");
INSERT INTO qufNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Chaqa, kayqami yawarniy. Kay yawarniyta iĉhashaywanmi Taytay Dyuswan uk tratuta rurani, kusa achka runakunata uchankunamanta washanaypaq. ");
INSERT INTO qufNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Piru nishaykillapa: Mananami qashanqa upyashaqnachu kay ubapa yakuntaqa qamkunawanqa, maydiya Taytay mantakuyashanpi pulla mushuq ubapa yakunta pulla upyanallapakaman” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Chaymantami salmukunata takir Dyusta alabarnaqa, riranllapana Olivos sirkaman. ");
INSERT INTO qufNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Chaypina karqami Jesusqa niran: —Tukuy qamkunami, kanan tutalla manchakushaykillaparayku nuqalatana dijamankillapa. Chaqa Dyus nitin iskribikashakunapimi nin: ‘Chay michikuqta wanuchitiymi, tantala kashanmanta uyshakunaqa wakta kayta limpu shikwakanqallapa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Piru nuqa kawsamurqami, qamkunamantaqa naypaqta rishaq Galilea pwiblumanqa. ");
INSERT INTO qufNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Chaynu nitinmi, Pedruqa niran: —Tukuy wakinkuna manchakur dijashutinllapapis, nuqaqa manami dijashaykichu nir. ");
INSERT INTO qufNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Chaymi Jesusqa niran: —Chiqaptami nishayki: Kanan tutallami manaraq gallu kantayatin qamqa kimsa kuti ninki: ‘Manami paytaqa riqsinichu’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piru Pedruqa niran: —Qamwan pullata wanuchimanallapapaq katinmapismi, pullayki shachinakushaq nir. Chaynullatami wakin yaĉhakuqninkunapis niranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Chaymantami Jesusqa yaĉhakuqninkunawan riranllapa uk lugar Getsemaní shutiqman. Chaypimi yaĉhakuqninkunata kaynu niran: “Wakmanmi riyani Taytayman mañakuq. Qamkunaqami kaylapi taskinkillapa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Chaynu nirmi Pedruta, Zebedeupa ishkay wamrankunata ima apar riran pullanqa. Chaymantami alliplata llakir kwashala tikrakaran Jesusqa. ");
INSERT INTO qufNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Chaynu kayarmi kaynu niran paykunataqa: “Kusalataraq llakir wanuq yupayna yarpuni. Qamkunaqa kaylapi kidar rikĉhakushala kayllapa nuqawan” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Chaynu nirqa, chay kayashanmanta ashlila wakaq riran. Chaypimi qunqurikur pachakaman pukĉhirar kaynu nir Taytantaqa mañakuran: “Taytay, puytiypaq katinqa yanapamay-ari kay kusa ayaq yaku yupay qischakaymantaqa. Piru manami nuqa munashaynuchu kanqa. Ashwanmi qam munashayki rurakanqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Chaymantami chay kimsa yaĉhakuqninkuna kayashanman tikrakamurqa, paykunataqa punuqta tariran. Chaymi Pedrutaqa niran: “¿Manachu puytishaykillapa uk uralamatapis rikĉhakur nuqawan kaytaqa? ");
INSERT INTO qufNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Rikĉhakur mañakuyllapa, ama uchapi ratanaykillapapaq. Qamkunaqami allinkunalata rurayta yarpunkillapa. Piru kwirpuykillapa litala kashanraykumi mana shachinakuyta puytinkillapachu”. ");
INSERT INTO qufNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Chaynu nir qashan ishkay kutipaqna rir, Taytantaqa kaynu nir mañakuran: “Taytay, chaynu qischakanaypaq dijamasha karqa, qam munashaykinumi ruray” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Chaymanta tikrakamurqa, qashalan chay yaĉhakuqninkunataqa punuqta tariran. Chaqa nawinllapamapis kusalata qipchirayaran punuypaq. ");
INSERT INTO qufNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Chaymi chaypi dijar qashan kimsa kutipaqna riran mañakuq Taytantaqa, ima nirtaq mañakusha karan chaynulla. ");
INSERT INTO qufNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Chaymanta qashan chay yaĉhakuqninkunaman tikrakamurqa niran: “¿Qamkunaqachu punur samayankillaparaq? Dyusmanta Shamuq Runata uchakuqkunaman qukunanllapapaq uraqami ĉhamushana. ");
INSERT INTO qufNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Shariyllapa, rishunllapana, shipchamunnami nuqata qukumaqqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Chaynu nir Jesús rimayatinllami, chay dusi yaĉhakuqninkunamanta uknin Judasqa, achka runakunawan ĉharanllapa ispadakunawan, qirukunawan ima. Paykunaqami riranllapa kurakunapa mantaqninkuna, Israel runakunapa ruku mantakuqninkuna kaĉhasha katin. ");
INSERT INTO qufNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judasqami, Jesuspa kuntraqninkunataqa, kaynu nisha karan: “Nuqa saludar muchayani chaytami aypar prisunkillapa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Chaymi Jesusman qimikarqa Judasqa, —¡Chaynupalachu, Taytituy!— nir mucharan. ");
INSERT INTO qufNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesusqami niran: —Amiguy, imata ruraqĉhi shamushayki chaytaqami kananlla rurayna nir. Chaymi chay wakinkunaqa Jesusman qimikar aypar prisuranllapana. ");
INSERT INTO qufNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Piru Jesuspa uk yaĉhakuqninmi ispadanta lluqshichimur kurakunapa mantaqninta sirbiq runapa rinrinta ¡saq! pitiran. ");
INSERT INTO qufNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Chaymi Jesusqa niran: —Ispadaykitaqa ĉhuray ĉhurakananpi. Chaqa ispadawan tukuy maqanakuqqami, ispadallawan wanunqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Manachu yaĉhanki nuqa Taytayman mañakutiyqa, kananlla kaĉhamunman kusa manchaypaq achka angelninkunata washamananpaq nirqa? ");
INSERT INTO qufNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Piru chaynu pasananpaq mañatiyqami, Dyus nitin iskribikashankunapi, nuqa qischakar wanunaypaq niyashanqa mana kumplikayanmannachu. ");
INSERT INTO qufNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Chaymantami Jesusqa chay runakunataqa kaynu nir tapuran: —¿Imapaqtaq qamkunaqa shamushaykillapa qirukunawan ispadakunawan imaqa, uk suwakuqta yupay aypar apamaqllapaqa? Nuqaqami imuraspis Dyusta adurananllapa wasipi yaĉhachikuray. Piru manamiri chaypiqa aypar apamaraykillapa imachu. ");
INSERT INTO qufNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kayqami chaynuqa pasayan Dyuspa unay rimaqninkuna iskribishannulla kumplikananpaq. Chaynu Jesús nitinqami, tukuy yaĉhakuqninkunaqa paylata dijar alsakaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Chaymantami Jesusta aypasha karan chaykunaqa, chay kurakunapa mantaqnin Caifaspa wasinman aparanllapa. Chaypimi tantakasha karanllapa Moisés mantakushanta yaĉhar yaĉhachikuqkuna, ruku mantakuqkuna ima. ");
INSERT INTO qufNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piru Pedruqami largukaqllamanta chapar ikinllapata riyaran, chay kurakunapa mantaqninpa wasinpa pampankaman. Chaymantami ruriman yaykurqa, chay yaykushanlapi kidaran Dyusta adurananllapa wasita kuytaqkunawan, rikakunanpaq imanushi Jesustaqa ruranqallapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Chay kurakunapa mantaqninkuna, tukuy chay kusa mas karguyjunkunaqami Jesuspaqqa kusalata yaĉhayta munaranllapa imalata mana allinta rurasha katinqa, chayraykulana wanuchinanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Piru chaynumapis manami tariranllapachu mana allinta rurashantaqa. Kusala achka runakunami, mana kashanmanta uchachananpaq qimikarmapis mana puytiranllapachu. Chaymantami ishkay runakuna qimikar, ");
INSERT INTO qufNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","tukuy chaypi kaqkunapa naypanpi kaynu niran: “Kay runaqami kaynu niran: ‘Nuqaqami Dyusta adurananllapa wasita ratachir, qashan kimsa diyalapaq shachiyta puytini niran’ nir”. ");
INSERT INTO qufNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Chaynu nitinllapami chay kurakunapa mantaqninqa sharir Jesustaqa kaynu nir tapuran: —¿Qam-shuypaqachu mana imatapis ninki? ¿Ima nishaq nirtaq waknu qampaqqa rimayanllapaqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Chaynu nitinmapismi Jesusqa mana imatapis niranchu. Chaymi chay kurakunapa mantaqninqa qashan niran: —Kawsaq Dyuspa shutinpi, nishayki chiqapta rimanaykipaq. Willamayllapa: ¿Chiqaptachu qamqa Dyuspa Akrashan Cristun, Dyuspa Wamran kanki? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesusqa niran: —Qamllami chaynu ninki. Piru, nuqapis nishaykillapa: Kananmanta-pachami rikankillapa Dyusmanta Shamuq Runataqa kusala puytiq Dyuspa allilaw qichqanpi taqta, chaymanta puktaypa rurinta syilumanta shamuqta ima nir. ");
INSERT INTO qufNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Chaynu Jesús nitinmi, chay kurakunapa mantaqninqa kusata piñakur raĉhpanmatapis llikiran, Jesusqa mana allintachu tukuyan nir. Chaymi niran: —¡Kay runa rimashanqami mana allinchu Dyuspaqqa! ¿Ima mas tistigutataq ministinchikllapa? Paypa shiminllami riman qamkuna uyapashaykillapanu. ");
INSERT INTO qufNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Imatataq yarpunkillapa? Chaymi, chaypi kaq runakunaqa niranllapa: —Kusala uchayjunmi wakqa; wanunanpaqmi allin nir. ");
INSERT INTO qufNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Chaymi ashwan qaqllitanpi tuqapar, maqaranllapa. Chaynullami wakinkunapis qaqllanllapi maqar, ");
INSERT INTO qufNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","kaynu niyaqllapa: —¡Qam chiqapta Dyuspa Akrashan Cristun karqa, tantyay pitaq maqashuran! nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Chaykamanqa Pedruqa tayaran waqta punkulapi. Chaypi kanankamanmi uk sirbikuq warmi qimikar niran: —Qampismi Galileamanta Jesuswan puriq kanki nir. ");
INSERT INTO qufNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Piru Pedruqami tukuypa naypanpi kaynu niran: —Manami yaĉhanichu imapaqmi rimayanki nirmapis nir. ");
INSERT INTO qufNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Chaynu nirqa, riranna punkuman. Chaymi, qashan uk sirbikuq warmisita rikar, kaynu nir wakinkunataqa willaran: —Wakqami pulla puriq chay Nazaretmanta Jesuswan nir. ");
INSERT INTO qufNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Qashanmi Pedruqa jurar kaynu niran: —¡Manami riqsinichu wak runataqa! nir. ");
INSERT INTO qufNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Chaymantami uk ratulamantaqa chaypi kaqkunapis Pedruman qimikar kaynu niranllapa: —Chiqaptami qampis paykunamanta kanki. Chaqa, rimanaykimapis paykunapa yupayllari nir. ");
INSERT INTO qufNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Chaymantami Pedruqa kutir kutir jurar niran: —¡Mana riqsinichu wak runataqa nishuyanillapa wakmaqa! ¡Mana chiqapta rimayatiyqami Dyus kastigamanqa! nir. Chaynu niyatinlami galluqa kantaran. ");
INSERT INTO qufNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Chaymantami Pedruqa yarpuran Jesús kaynu nishanta: “Manaraq gallu kantayatinmi kimsa kuti nuqapaqqa ninki, manami riqsinichu nir”. Chaymi Pedruqa, chaymanta lluqshirqa kusalata llakir, piñakur ima waqaran. ");
INSERT INTO qufNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Chaymanta achkiyatinnaqa, chay kurakunapa tukuy mantaqninkuna, chay Israel runakunapa ruku mantaqninkuna imaqa parlaranllapa Jesustaqa wanuchinanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Chaymi alli watar apar quranllapa Roma pwiblumanta numrakasha gubyirnu Pilatuta. ");
INSERT INTO qufNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Chay Judas, Jesusta kuntrankunaman qukusha karan chayqa, Jesusta wanuchinanllapapaq nisha nir yaĉharqa kusalata llakiran. Chaqa manari allintachu tukusha karan. Chaymi chay mana allinta tukushanpaq kwintata qukarqa, chay kurakunapa mantaqninta, Israel runakunapa ruku mantaqninta imaqa qillayninta rir tikrar kaynu niran: ");
INSERT INTO qufNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","—Uchakushami kani uk allin mana uchayjun runata qukushayrayku nir. Piru chay runakunaqa niranllapa: —¿Nuqakunapaqqa ima kwintayllapataq? ¡Chayqami qampa kwintaykina! nir. ");
INSERT INTO qufNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Chaymi Judasqa chay qillaytaqa Dyusta adurananllapa wasipi itakur riran. Chaynu rirmi mana allinta tukushanpaq paylla urkakar wanuran. ");
INSERT INTO qufNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Chaymanta chay kurakunapa mantaqninkunaqa chay qillayta aypar kaynu niranllapa: “Kay qillayraykumi uk runata qukuran wanuchinanllapapaq. Chayraykumi mana allinchu Dyuspaq ufrindita nir ĉhuranallapapaqqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Chaymi paykunaqa yarpuranllapa, chay qillaywanqa uk manka ruraqpa pachanta rantinanllapapaq. Chayna chaypi tukuy uklawmanta runakuna wanutinqa pampananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Chayraykumi chay pachaqa kanankaman shutin “Yawar Pacha”. ");
INSERT INTO qufNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Chaynumi kumplikaran Dyuspa unay rimaqnin Jeremías nishanqa. Chaqa kaynumi nisha kayaq: “Ayparanllapa trinta suqu qillaysituta, chay Israel pwiblumanta runakuna uk paykunapa masinpa ĉhaninpaq nisha karan chaykunata. ");
INSERT INTO qufNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Chaywanmi rantiranllapa manka ruraqpa pachanta, imanuĉhi Tayta Dyus nimashannulla” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Chaymantami Jesustaqa gubyirnu Pilatupa naypanman apatinllapa, kaynu nir tapuran: —¿Qamchu Israel runakunapa mantaqnin kanki? nir. Jesusqa niran: —Qamllami ninki. ");
INSERT INTO qufNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Chaykamanmi chay kurakunapa mantaqninkuna, Israel runakunapa ruku mantaqninkuna imaqa, kusalata uchachayaranllapa. Piru Jesusqami mana imatapis rimaranchu. ");
INSERT INTO qufNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Chayraykumi Pilatuqa qashan kaynu nir tapuran: —¿Manachu uyapanki tukuy imakunata qampaq rimatinllapaqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Piru Jesusqami mana imalatapis rimaranchu. Chaymi chay gubyirnuqa kusalata yarpupakuyar kidaran. ");
INSERT INTO qufNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kada fyistapimi chay gubyirnu Pilatuqa uk runata lluqshichiq chay prisu kashanmanta, runakuna mayqantaĉhi lluqshichiy nishannulla. ");
INSERT INTO qufNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Chay tyimpupimi karan uk runa mana allinta rurashanrayku kusala riqsikasha Barrabás shutiq, prisuqa. ");
INSERT INTO qufNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Chaymi tukuy runakuna tantakasha katinllapa, Pilatuqa tapuran kaynu nir: “¿Mayqantataq munankillapa lluqshichinapaq, Barrabasta, manaqachu Jesusta, Dyus Akrashan Cristun ninllapa chayta?” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Chaqa Pilatuqa kwintata qukasha karan, ĉhiqnirlami Jesustaqa yanqallamanta payman apashallapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nataq Pilatuqami mantakunanpi tayatin warminqa kaĉhakuran kunachinanllapapaq kaynu nir: “Amami chay kusa allinla runawanqa willanakunkichu. Chaqa naqa tutami kusala manchaypaq llakiypaqta musqupakusha kani payta aypashaykillaparaykuqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Piru chay kurakunapa mantaqninkuna, chay Israel runakunapa ruku mantaqninkuna imaqa, tukuy runakunata animachiran Barrabasta kaĉhar, Jesusta wanuchiy nir mañakunanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Chaymi chay gubyirnuqa qashan kaynu nir tapuran paykunataqa: —¿Mayqannintataq kay ishkaymantaqa dijatiy rinanta munankillapa qamkunaqa? nir. Paykunaqa niranllapa: —¡Barrabasta! nir. ");
INSERT INTO qufNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatuqa qashallan paykunataqa tapuran: —¿Imatataq rurayashaq kay Jesusta, Dyuspa Akrashan Cristun ninllapa chaywan-shuypaqa? nir. Ashwanmi tukuyla kaynu niranllapa: —¡Kruspi klabay! nir. ");
INSERT INTO qufNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Qashanmi Pilatuqa niran: —Chaqa, ¿ima mana allintataq rurasha? Piru chay runakunaqami qashan kusala jwirtita kaynu nir lanyaranllapa: —¡Kruspi klabay! nir. ");
INSERT INTO qufNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Piru Pilato imata nitinpis chay runakunaqa mana kasuranllapanachu. Chaymi ashwan Pilatuqa yarpuran mana kasutiyqami piñakur nuqapa kuntray shamur imanachimanman nir. Chaynu nirmi kaĉhakutin yakuta apamutinllapa, tukuypa naypanpi makinta paqakuqnu kaynu niran: —Kay runata wanuchirllapaqa amami nuqataqa uchachamankillapachu. Qamkunapa kwintaykillapanami kanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Chaymi ashwan tukuyla chaypi kaqkunaqa kaynu niranllapa: —¡Nuqakuna, tukuy wamrayllapakunawan imami mana allinta rurayarqa, kay runapaqqa imanashaqllapapis! nir. ");
INSERT INTO qufNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Chaymi Pilatuqa Barrabasta prisu kashanmanta lluqshichir, suldadunkunata kaĉharan Jesusta llibachir, chaymanta-shuypaqa kruspi klabananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Chaymantami chay gubyirnupa suldadunkunaqa manaraq krusman klabaq apayarqa, chay gubyirnupa dispachunman aparanllapa Jesustaqa. Chaypimi tukuy suldadu masinkunata tantaranllapa Jesuspa naypanmanqa. ");
INSERT INTO qufNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Chaypimi ashwan raĉhpanta lluqshichir uk chupika raĉhpatana yakachiranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Chaynullami umachiranllapapis uk kuruna kashamanta rurakashata. Nataq allilaw makinpi-shuypaqa uk barata charichiranllapa. Chaymantami kushipananrayku Jesuspa naypanpi qunqurir, kaynu niqllapa: “¡Biba Israel pwiblupa gubyirnun!” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Chaynullami tuqaparllapa chay barallawan umitanpi kusalata maqaranllapa ima. ");
INSERT INTO qufNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Chaymanta chaynu paymanta kusata burlakarllapa imanaqa, chay chupika raĉhpata yakachishanllapataqa lluqshichir paypa raĉhpanllata yakachiranllapa. Chaynu munashanllapata rurarnaqami aparanllapa kruspi klabananllapapaqna. ");
INSERT INTO qufNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Chaymanta lluqshirllapaqa, uk runa Simón shutiqta tariranllapa. Payqami Cirene pwiblumanta karan. Chaymi ashwan paytaqa Jesuspa krusninta amalas rikrachir aparanllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Chaynu rirmi uk lugar Gólgota shutiqman ĉharanllapa. Kay lugartami ninllapapis Calavera nir. ");
INSERT INTO qufNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Chaypiqami upyachiyta kamaranllapa binuwan, uk rimidyu kusala ayaqta, ama nanachikunanpaq nir. Piru Jesusqa pitilata kamarqa mana munaranchu upyaytaqa. ");
INSERT INTO qufNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Chaymantami Jesustaqa kruspi klabaranllapana. Chaymi chay suldadukunaqa Jesuspa raĉhpankunataqa surtyakur ayparanllapa. Chaynuqami ruraranllapa Dyus nitin iskribikashannulla kumplikananpaq. Chaqa niqmi: Raĉhpaykunatami surtyakur ayparanllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Chaynu surtyakur imanaqami, chaylapi tayar kidaranllapa Jesusta chapananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nataq umanpa ananpiqami, uk litriruta ĉhuraranllapa imaraykushi wanuchishallapa nir. Chaqa kaynumi niyaq: “KAY JESUSMI ISRAEL RUNAKUNAPA MANTAQNIN” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Chaynullami paypa pullanqa ishkay suwakuqkunata krusllapi klabaranllapa, ukninta Jesuspa ichuqlaw qichqanpi, ukninta-shuypaqa allilaw qichqanpi. ");
INSERT INTO qufNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Piru tukuy chayta pasaqkunaqami, umanllapata kuyuchiqnulla kusalata musyar kaynu niyaqllapa: ");
INSERT INTO qufNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“¡Qammi, Dyusta adurananllapa wasita ratachir qashan kimsa diyalapaq shachishaq nirayki! ¡Chaqa chiqapta Dyuspa Wamran karqa, qamlla washakar krusmanta ishkimuy!” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Chaynu nirllami kusalata burlakaranllapa tukuy chay kurakunapa mantaqninkuna, Moisés mantakushanta yaĉhar yaĉhachikuqkuna ima, Israel runakunapa ruku mantaqninkunawan pulla. Chaymi kaynu niyaqllapa: ");
INSERT INTO qufNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ukkunatami washaran. Piru payllaqami mana washakayta puytinchu. Wakqashi Israel runakunapa mantaqnin-ari. ¡Chaynu karqa chay krusmanta ishkimunqari! ¡Chaynami chaypiraq paypi kriyishunllapa! ");
INSERT INTO qufNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Chaqa payqashi Dyuspi kusalata kunfyakan. Chaynu katinqa Dyus kananlla washanqari. ¡Chiqapta Dyus payta munayarqa! ¿Manachu nimaranchikllapa payqa: ‘Dyuspa Wamran kani’ nir?” ");
INSERT INTO qufNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Chaynullami chay suwakuq runakuna paywan pulla kruspi kaqkunamapis ashwan kusalata musyaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Chaymantami a las dusimanta-pacha tardi a las triskaman tukuy pacha tutaparaq intiru kidaran. ");
INSERT INTO qufNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Piru yaqqa a las trispaqna katinqami Jesusqa kusa jwirtita kaynu nir qayĉhakuran: “Elí, Elí, ¿lama sabactani?” nir. (Chaynu nirqami intrachimanchik: “Dyusniy, Dyusniy ¿imapaqtaq nuqalata dijamashayki?” nir.) ");
INSERT INTO qufNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Chaymi wakin chaypi kaqkunaqa chaynu nitin uyaparqa kaynu niranllapa: “Wakqami qayayan Dyuspa unay rimaqnin Eliasta” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Chaymi chay kutilla chaypi kaqkunamanta ukninqa kallpar rir uk puqyala raĉhpata qirupi watar, puchqu binupi nuyuchir Jesuspa shiminman ĉhuraran upyananpaq. ");
INSERT INTO qufNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Piru chay wakinkunaqami niranllapa: “Dijay, mabir Eliaschu shamur washanqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Chaymantami Jesusqa qashan kusala jwirtita qayĉhakurqa wanuranna. ");
INSERT INTO qufNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Piru chay kutillami Dyusta adurananllapa wasi ruripi uk atun rakta raĉhpa warkuraqpis llikikaran ĉhaypin unaqmanta urakaman. Chaynullami pachamapis kusalata kuyutin atun rumikunamapis limpu rajakaran. ");
INSERT INTO qufNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Chaynullami wanushakuna pampakashankunamapis kiĉhakaran. Chaymi Dyuspi kriyisha kaqkuna wanushakunamapis kawsamuranllapana. ");
INSERT INTO qufNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Chaynu wanushanmanta kawsamurqa chay pampakashanmanta lluqshimuranllapana. Chaymi Jesús wanushanmanta kawsamutinqa, yaykuranllapana Dyus akrashan pwiblu Jerusalenmanna. Chaypimi kusala achka runakuna rikaranllapa paykunataqa. ");
INSERT INTO qufNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Chaymanta chay Romamanta suldadukunapa mantaqnin chaypi wakinkunawan kar rikakuranllapa pacha kuyutin, tukuy ima pasaqtapis. Chaymi kusalata manchakur kaynu niyaranllapa: “¡Chiqaptami kay runaqa Dyuspa Wamran kasha!” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Piru chaypiqami achka warmisitakuna Galilea pwiblumanta Jesuswan pulla risha kaqkuna karukaqlamanta rikakuyaranllapa. Chaqa chay warmisitakunami Jesustaqa yanapasha karan imata rurashanpipis. ");
INSERT INTO qufNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Chay warmikunaqami kaykuna karanllapa: María Magdalena, Santiaguwan Josipa maman María, Zebedeupa warmin ima. ");
INSERT INTO qufNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Chaymanta limpu tardiyayatinnaqami Arimatea lugarmanta uk kusa imayjun runa José shutiq Pilatuman ĉharan. Paypismi Jesuspa yaĉhakuqnin karan. ");
INSERT INTO qufNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Chaymi payqa Pilatuman ĉharqa, Jesuspa kwirpunta mañaran. Chaynu mañakutinmi Pilatuqa kaĉhakuran qunanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josiqami Jesuspa kwirpuntaqa aypar pilluran kusa shumaq yuraq raĉhpawan. ");
INSERT INTO qufNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Chaymantaqami uk mushuq uĉhkuta qaqapi pay pampakananpaq rurachikusha karan, chaypi pamparan Jesustaqa. Chaymi ashwan chay uĉhkutaqa uk kusa atun rumiwan kirpar riranna. ");
INSERT INTO qufNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Piru María Magdalenawan, chay uk Mariaqami Jesús pampakashan naypanlapi tar kidaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Samana diyapa quyapachan pasatinqa, kurakunapa mantaqninkuna, fariseo runakuna ima, riranllapa Pilatuta rikaq. ");
INSERT INTO qufNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Chaymi kaynu niranllapa: —Tayta gubyirnu, yarpunillapami chay llullakuqqa kawsayarllaqa niranpis, ‘Wanurqashi kimsa diyamantaqa qashan kawsamuyanqa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Chayrayku suldadukunata kaĉhay chay pampakashanman, kimsa diya pasanankaman chaypi kuytakunanllapapaq. Imanupiqakish chay yaĉhakuqninkuna tuta shamur kwirpunta apar, tukuyla runakunata ‘Kawsamushana’ nir, kriyichitinllapa. Chaynu katinqa qashan chaynu llullakutinqa llallin mana allinchu kanman naypaq llullakushanmantaqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Chaymi Pilatuqa kaynu niran paykunataqa: —Chaypimi kan suldadukuna kuytakunanpaqqa. Paykunawan rir-ari chay pampakashantaqa puytishaykillapakaman alli kirpayllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Chaymi rir alli kirpar, chay atun rumipa ananpi uk siñata ĉhuraranllapa. Piru chaynu kirparmapismi suldadukuna chaypi kuytakunanpaq dijaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Samana diya pasatin, simanapa punta diyan achkiyatinnaqa María Magdalenaqa, chay uk Mariawan riranllapa Jesús pampakashanman chapakuq. ");
INSERT INTO qufNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Piru chay urasllami kusata pacha kuyuran. Chaqa unaq syilumantami Dyuspa angelnin ishkimuran. Chaymantami Jesús pampakashan uĉhkumanta rumita ashuchir chaypa anan taran. ");
INSERT INTO qufNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Chay angelqami uk rilampa yupay kusata llipyarayaran. Nataq raĉhpan-shuypaqa puktay yupay kusa yuraq intiru karan. ");
INSERT INTO qufNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Chaynuta rikarmi chay suldadu kuytakuqkunaqa kusalata manchakur, wanusha yupay kidaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Chaymantami angelqa chay warmikunataqa kaynu niran: “Amami manchakuyllapachu. Nuqami yaĉhayani qamkunaqa Jesusta kruspi klabaranllapa chaytami maskayankillapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Piru payqami manana kaypinachu. Ashwanmi imanutaq pay nisha kayaq, chaynullami kawsamushana. Maski shamur rikayllapa maypi ĉhurashaykillapamatapis. ");
INSERT INTO qufNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Chaymi kananlla rir chay yaĉhakuqninkunata willayllapa kaynu nir: ‘Kawsamushanami, riyan ashwan Galilea pwibluman, qamkunamantaqa naypaqta. Chaypimi rikankillapa’ nir. Kaylatami nuqaqa willashunayllapapaq karan”. ");
INSERT INTO qufNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Chaynu nitinqa chay warmikunaqa kallpaylla riranllapa Jesús pampakashanmantaqa, kusalata manchakur, aligriyar, ima chay yaĉhakuqninkunataqa willaq. ");
INSERT INTO qufNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Piru chaynu riyatinllapaqami Jesusqa paykunaman rikarir, saludaran. Chaymi chay warmikunaqa Jesusman qimikar aduraranllapa, ĉhakinkunata abrasar ima. ");
INSERT INTO qufNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Chaymi Jesusqa paykunataqa kaynu niran: “Amami manchakuyllapachu. Ashwanmi rir ukniykunata willayllapa Galilea pwibluman rinanllapapaq. Chaymi ashwan wakpina rikamanqallapa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Warmikuna rinankamanqa, wakin suldadu kuytakuqkunaqa pwibluman ĉhar chay kurakunapa mantaqninkunata parlaranllapa tukuy ima pasashantaqa. ");
INSERT INTO qufNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Chaymi chay kurakunapa mantaqninkunaqa riranllapa parlaq chay Israel runakunapa ruku mantaqninkunata. Chay suldadu willaqkunataqami kusa achka qillayta quranllapa chay kurakunapa mantakuqninkunaqa kaynu nir: ");
INSERT INTO qufNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Qamkunaqa kaynu ninkillapa: ‘Tuta punuyatiyllapa, yaĉhakuqninkuna shamur suwakur aparanllapa Jesuspa kwirpuntaqa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Piru imanupi chay mantakuq yaĉhaq yupay katinqa nuqakuna imanupis parlashaqllapa. Qamkunapaq ama ukmanta yarpunanllapapaqqa”. ");
INSERT INTO qufNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Chaymi chay suldadukunaqa qillayta ayparqa imanuĉhi chay kurakunapa mantaqninkuna willashanllapanulla rimaranllapa. Piru chay suldadukuna chaynu rimar llullakushanmanta-pachami, kanankaman chay tukuyla Israel runakunaqa chiqapta chaynu kasha kanqa nir parlanllapa. ");
INSERT INTO qufNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Chaymiri Jesuspa unsi yaĉhakuqninkunaqa pay willashannulla riranllapa Galilea pwiblupi atun sirka kaq chayman. ");
INSERT INTO qufNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Chaymi chaypi Jesusta rikarqa, kusata aduraranllapa, michka wakinkuna mana allita kriyitinllapamapis. ");
INSERT INTO qufNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesusqami paykunaman qimikar kaynu niran: “Dyusmi tukuyta mantanaypaq nisha, unaq syilupi chaynulla kay pachapi ima. ");
INSERT INTO qufNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Chaymi qamkunapis tukuy pachata rir yaĉhachikuyllapa. Paykunapis yaĉhakuqniykunana kananllapapaq. Piru paykunataqami shutichinki Taytaypa, Wamranpa, chaynulla Santu Ispiritupa shutinpina. ");
INSERT INTO qufNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Yaĉhachiyllapapismi intrakar kasunanllapapaq, tukuy qamkunata nishushayllapataqa. Chaqa nuqaqami, qamkunapaqa pullaykillapa kashaq maydiyapis, kay pacha tukukanan tyimpu ĉhamunankaman” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kaynumi qallarin Dyuspa Wamran Jesucristupaq shumaq rimashanqa. ");
INSERT INTO qufNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Manaraq Jesucristo nasiyatinmi karanna Dyusninchikpa rimaqnin Isaiasqa. Paymi Dyus nitin kaynu nir iskribiran chay washakuqpaqqa: “Naypaykita kaĉhashaq uk runata qampaq rimananpaq. Chaymi rinqa tukuyta willaq shunqunllapapi shumaqta yarpunanllapapaq. Chaynuqami qam ritkiqa shumaqtana risibishunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Chay runami kusa jwirtita rimar chunllaqpi nin: ‘Amitunchikpa nanninta kamakachiyllapa, uchaykillapata dijar Dyusta kasurllapana. Chaynuqami kusa dirichula nanta kiĉhaq yupayna kankillapa kanqa’ nir”. ");
INSERT INTO qufNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Chaynumi Isaías iskribishannu Shutichikuq Juanqa, chunllaqkunapi runakunata niran: “Uchaykillapata dijar Dyusmanna tikrakayllapa pirdunashunanllapapaq. Chaymantami shutichishaykillapa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Chaymi tukuy Judea pwiblukunamanta, Jerusalenmanta ima, kusa achka runakuna riqllapa Juan kayashanman payta uyakuqqa. Chaynu uyakurmi uchanllapapaq kwintata qukar Tayta Dyus llakipamay nitinllapa, Juanqa riyu Jordanpi tukuyta shutichiran. ");
INSERT INTO qufNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Kay Juanpa raĉhpanqami rurakasha karan kamillupa millwanmanta. Nataq sinchun-shuypaqami qaramanta karan. Payqami mikuq atun shurkukunata, chumpakapa mishkinkunata ima. ");
INSERT INTO qufNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yaĉhachikuqnuqami runakunataqa kaynu niyaqpis: “Nuqamantaqami uk kusala mas pudirniyjun shamuyan. Paypaqqami nuqaqa mana sirbinichu llanqinpa watunta kaĉhanaylapaqmapis. ");
INSERT INTO qufNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Chaqa nuqaqami qamkunataqa yakulawan shutichishushallapa kani. Piru nuqamanta chay uk shamuq-shuypaqami Dyuspa Santu Ispiritunwanna shutichishunqallapa”. ");
INSERT INTO qufNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Chay tyimpukunapimi prubinsya Galileapa uk pwiblun Nazaretmanta Jesusqa lluqshir rir, riyu Jordanman ĉhatin Juanqa chaypi shutichiran. ");
INSERT INTO qufNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Chaynu shutikur yakumanta lluqshimuyarmi rikaran syilu kiĉhakaqta. Chaynullami rikaranpis Dyuspa Santu Ispiritun payman uk palumitanu ishkimuqta. ");
INSERT INTO qufNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Chaymantami syilumanta-pacha Dyus kaynu niqta uyaparan: ");
INSERT INTO qufNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Chaymantaqami Dyuspa Santu Ispiritunqa Jesusta aparan chunllaq lugarman. ");
INSERT INTO qufNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Chaypimi Jesusqa kwarinta diyata, kusala saqra animalkunapa rurinpi karan. Chaynu Jesús payla chaypi katinmi dyabluqa uchakuchiyta kamaran. Piru Dyuspa angelninkunami paytaqa tukuy ministishanpipis yanaparan. ");
INSERT INTO qufNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Chaymanta Shutichikuq Juanta, gubyirnu Herodes karsilashana katinqa, Jesusqa riran Galilea pwiblukunaman Dyuspa shumaq rimayninta yaĉhachikutin, washakarna Dyuspa mantakuyninpi kawsananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Chaynullami niyaqpis: “Kananqami Tayta Dyuspa tyimpunqa kumplikashana. Chaymi Dyusmanta shamuq mantakuq qallarinanpaqqa shipchamushana. Chayraykumi uchaykillapata dijar Tayta Dyusmanna tikrakayllapa. Chaynulla chay kusala shumaqta willashushayllapapi kriyirna kawsayllapa”. ");
INSERT INTO qufNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesusqami Galilea atun quĉhapa manyanta riyarqa, rikaran Simonta uknin Andreswan chaypi kaqta. Paykunaqami piskadukuq kashanrayku atun shikranllapata yakuman itayaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Chaymi Jesusqa paykunataqa kaynu niran: —Shamuyllapa nuqawanna rinallapapaq. Chaqa nuqaqami yaĉhachishaykillapa piskaduta aypaq yupayna runakunata nuqapaq yaĉhachir tantanaykillapapaq nir. ");
INSERT INTO qufNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Chaynu nitinqami, chay runakunaqa chay kutilla atun shikrankunata dijar, paywanna riranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Piru mas naypaqman riyarqa, Jesusqa qashan rikaran Santiaguta uknin Juanwan chaypi kaqta. Paykunaqami Zebedeupa wamrankuna karanllapa. Chaymi paykunaqa uk yaku karrupi atun shikrankunata kamakachiyaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Chayna Jesusqa qayamuran paykunatapis. Chaymi chay kutilla, Juanqa Santiaguwan ishkantin Jesuswanna riranllapa, chay yaku karrullapi taytanta trabajaqninkunawan dijarna. ");
INSERT INTO qufNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Chaynu rirqami Capernaúm pwiblumanna ĉharanllapa. Chaymantami samana diya katin Jesusqa chay Israel runakunapa tantakananllapa wasiman yaykur yaĉhachikuq qallariran. ");
INSERT INTO qufNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Piru yaĉhachikutinqami tukuyla chaypi kaqkunaqa kusalata dispantakaranllapa. Chaqa Jesusqami yaĉhachikuran paypa yaĉhayninllawan, manami Moisés mantakushanta yaĉhar yaĉhachikuqkuna yupaychu. ");
INSERT INTO qufNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Chay tantakananllapa wasi ruripiqami kayaq uk runa dyablupa yarpuyninwan. Chayqami kusala jwirtita kaynu nir qayĉhakuran: ");
INSERT INTO qufNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¡Ay! Nazaretmanta Jesús, ¿imapaqtaq nuqakunaman yakapakanki? ¿Ima, chinqachimaqllapachu shamushayki? ¡Nuqami riqsishuni! ¡Qamqami Dyuspa Santu Wamran kanki! nir. ");
INSERT INTO qufNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Chaynu nitinmi, Jesusqa anyaran dyablupa yarpuynintaqa kaynu nir: —¡Upallalla yarquy kay runamantaqa! nir. ");
INSERT INTO qufNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Chaynu nitinqami, chay dyablupa yarpuyninqa chay runataqa atakita qur, kusala jwirtita qayĉhachirna yarquran. ");
INSERT INTO qufNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Chayta rikarmi, tukuyla runakuna kusalata manchakuranllapa. Chaymi ukninllapa ukninllapa kaynu ninakuyaqllapa: “¿Imataq kayqa kanqa? ¡Kusata paylla mantakur imami ukman mushuq imakunata yaĉhachikun! ¡Chaynulla dyablupa yarpuyninmapis imata nitinpis kasun!” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Chaymanta-pachami tukuyla Galilea lugarkunapi Jesuspaqqa kusalata yaĉharanllapa imanumi payqa imatapis rurayta puytin nir. ");
INSERT INTO qufNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Chaymanta chay Israel runakunapa tantakananllapa wasimanta lluqshirqa, Jesusqa Santiaguwan, Juanta apar riran Simonpa, Andrespa wasinman. ");
INSERT INTO qufNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Chaypimi Simonpa swigranqa kusala rupawan qishaq mantanpi usurayaran. Chaynu chaypi qishaq nir Jesusta willatinllapami, ");
INSERT INTO qufNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesusqa rir qimikar, chay warmisitataqa makinmanta chutar sharichimuran mantanmantaqa. Chaymi chay kutilla chay rupaqa dijaranna. Chaymantami ashwan chay warmisitaqa sharikur paykunata qaraqna qallariran. ");
INSERT INTO qufNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Rupay chinqatin limpu tutapashana katinqa, Jesusmanqa tukuy qishaqkunata, dyablupa yarpuyninwan kaqkunata ima apamuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Piru chay wasipa punkunmanqami chay pwiblumanta tukuyla runakuna limpu untaranllapa Jesusta rikakunanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesusqami tukuy qishayninllapakunamanta kusala achka runakunata allichar, dyablupa yarpuyninkunamatapis achkata itakuran. Chaynu itakutinmi dyablupa yarpuyninkunaqa, yaĉharanllapa “Jesusqami Dyuspa Wamran” nir. Piru Jesusqami mana dijaranchu paypaq rimananllapapaqqa. ");
INSERT INTO qufNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Chaymanta allaqnin achkiyayatinnaqa amsaqla Jesusqa sharir, chay pwiblumanta lluqshir riran chunllaq lugarkunaman Taytanman mañakuq. ");
INSERT INTO qufNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Chaymantaqami, Simonqa wakinninkunawan Jesusta maskaq rir, ");
INSERT INTO qufNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","tarirqa niranllapa: —Tukuymi maskashuyanllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesusqa niran: —Ashwan rishunllapa uklaw shipchakaq pwiblukunaman, chaypipis Dyuspa shumaq rimayninta yaĉhachikunaypaq. Chaqa chaypaqmi shamusha kani. ");
INSERT INTO qufNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Chaynumi Jesusqa Galilea pwiblupa tukuy lugarninkunapi, Israel runakuna tantakananllapa wasikunapiqa Dyuspa shumaq rimayninta yaĉhachikur chaynullami dyablupa yarpuyninkunata itakur ima puriran. ");
INSERT INTO qufNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Chaymantaqami uk runa ismuyaq kwirpuyjun Jesusman qimikar, naypanpi qunqurikur kaynu niran: —¡Taytituy! llakipamayarqa allichamay-ari kay qishayniymantaqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesusqami llakipar makinwan kamar niran: —Munanimi alliyanaykita. Kananlla alliyay, nir. ");
INSERT INTO qufNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Chaynu nitinlami, chay ismuyaq kwirpuyjun runaqa, alliyaranna qishayninmantaqa. ");
INSERT INTO qufNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Chaymantami Jesusqa chay runataqa kaynu niran: —¡Allita uyamay! Amami mayqantapis willankichu. Ashwanmi rir qimikay kuraman. Chaymi apanki ufrinditaykita Moisés mantakushannulla. Chayna tukuy yaĉhananllapapaq qishaynikimantaqa alliyashaykina nir. ");
INSERT INTO qufNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Piru chay runaqami chaymanta lluqshirqa tukuylata parlaran Jesús, paypaq rurashantaqa. Chaymanta-pachami Jesusqa manana pwiblukunamanqa yaqqa yaykuqnachu. Ashwanmi chay maypiĉhi yaqqa mana runakuna kaq chaylapina kidaq. Piru chaynumapis tukuy lugarmantami runakunaqa riqllapa payta rikaqqa. ");
INSERT INTO qufNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Chaymanta, ayka diyamantami Jesusqa Capernaúm pwibluman tikrakar riran. Chaymantami yaĉharanllapa chay wasiman, ĉhamushana nir. ");
INSERT INTO qufNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Chaynu yaĉharllapami Jesús kayashanman chaynulla waqta punkumanmapis kusalata untaranllapa. Chaymi manana maylawta yaykunapaqmapis karannachu. Chaynumapis Jesusqa Dyuspa shumaq rimananta yaĉhachikuyaran. ");
INSERT INTO qufNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Chaykamanmi kwatru runakuna, mana kuyuyta puytiq kwirpuyjun uk runata ĉhachiranllapa chaymanqa. ");
INSERT INTO qufNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Piru Jesús kayashanmanqa mana imanupis ĉhachiyta puytiranllapachu kusala achka runakuna kashanrayku. Chaymi iqaranllapa wasipa ananman. Chaymantaqa chay wasipa qatananta uĉhkukur, chaylata chay qishaqtaqa uk paritapi Jesuspa naypanmanqa ishkichiranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Chaymanta Jesusqa nuqapi kusata kriyinllapa nir yaĉharqa, chay qishaqtaqa kaynu niran: —Wamrituy, tukuy uchakushaykikunamantami pirdunashushana kani nir. ");
INSERT INTO qufNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Chaypimi, Moisés mantakushankunata yaĉhar yaĉhachikuq wakin runakuna tayaranllapa. Chaymi kaynu nir yarpuranllapa: ");
INSERT INTO qufNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Kayqami yanqa runala. ¿Imaraykutaq waknuqa ninqa? Wakqachu Dyusninchiknulla tukunayan. Manami allinchu chaynuqa. Chaqa Dyuslari uchakunamanta pirdunakuytaqa puytin nir. ");
INSERT INTO qufNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Piru Jesusqami kwintata qukaran imatami yarpuyanllapa nirmapis. Chaymi paykunataqa kaynu nir tapuran: —¿Imapaqtaq qamkunaqa chaynuta yarpunkillapa? ");
INSERT INTO qufNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Qamkunapa yarpuynikillapamantaqa ima ninaypaqtaq mas trabajusu kanqa kay runataqa ‘Uchaykikunamantami pirdunashuni’ ninaypaq, manaqachu ‘Sharir paraykita apar riy’ ninaypaq? ");
INSERT INTO qufNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Piru kananllami intrachishaykillapa Dyusmanta Shamuq Runaqami kay pachapiqa paylla puytin uchanllapakunamanta pirdunakuytaqa nir. Chaynu nirnaqami chay mana kuyuyta puytiq kwirpuyjun runataqa niran: ");
INSERT INTO qufNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Qamtami nishuni: Sharir paraykita apar, riy wasikiman nir. ");
INSERT INTO qufNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Chaynu nitinqami, chay qishaq karan chay runaqa das sharir, paranta charikur lluqshimuran tukuyla rikayatin. Chayta rikarmi tukuy chaypi kaqkunaqa kusalata dispantakaranllapa. Chaymi ashwan Dyusta alabaq ĉhurakaranllapa kaynu nir: “¡Manami kaypiqa uk kutilamapis waknutaqa rikashanchikllapachu!” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Chaymantami Jesusqa qashan riran atun quĉhapa manyanman. Piru chaymanpismi kusa achka runakuna tantakatin payqa yaĉhachiyaran. ");
INSERT INTO qufNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Chaymanta riyarqami Alfeupa wamran Levita rikaran. Payqami chay Roma pwiblupaq impwistuta kubrakunanpi tayaran. Chaymi Jesusqa niran: —Shamuy nuqawan rishun nir. Chaynu nitinqami Leviqa sharir paywanna riran. ");
INSERT INTO qufNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Chaymantami Jesusqa Levipa wasinpi mikuyaranna. Chaymi chay kutilla Romapaq impwistuta kubrakuqkuna, kusa uchayjun runakuna Jesuswan chaynulla yaĉhakuqninkunawan ima misapina tayaranllapa. Chaqa kusalatari Jesuswan pulla puriyta munaqllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Chaynu Jesús tukuywan mikuqta rikarmi chay fariseo runakuna chaynulla Moisés mantakushanta yaĉhar yaĉhachikuqkuna, Jesuspa yaĉhakuqninkunataqa kaynu nir tapuran: —¿Imapaqtaq yaĉhachikuqnikillapaqa chay impwistuta kubrakuqkunawan chaynulla uchasapakunawan pullaqa mikun? nir. ");
INSERT INTO qufNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Chaynu nitinllapa uyaparmi Jesusqa niran: —Allilan kar mana qishaq kaqkunaqami mana ministinchu rimidyakuqtaqa. Chaymi ashwan chay qishaq kaqkunala ministin rimidyakuqtaqa. Chaqa nuqaqami mana, chay allinla kani niqkunapaqchu shamusha kani. Ashwanmi shamusha kani chay uchayjunkunata willatiy kriyir washakananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Uk diyapimi Shutichikuq Juanpa yaĉhakuqninkuna, chaynulla wakin fariseukunaqa ayunayaranllapa. Chaymantami wakin runakuna rir, Jesustaqa kaynu nir tapuranllapa: —Shutichikuq Juanpa yaĉhakuqninkuna, chaynulla fariseukunapa yaĉhakuqninkunapismi ayunanllapa. Qampa yaĉhakuqnikikuna-shuypaqa, ¿imapaqtaq mana ayunanllapaqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesusqa paykunataqa niran: —Uk runa kasaraq, chayllapiraq katinqachu chay pullan kaqkunaqa ¿ayunayta puytinman? Manami ayunaytaqa puytinmanchu. ");
INSERT INTO qufNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Piru chay kasarasha rinanpaq urami ĉhamunqana. Chaynu ritinna-shuypaqa ayunanqallapana. ");
INSERT INTO qufNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Nishaykillapapis: Manami mayqanpis uk makwa raĉhpataqa mushuq raĉhpawanqa rimindanchu. Chaqa chay mushuq raĉhpami paqakarqa chapukayanqa. Chaynu chapukarmi, makwa raĉhpataqa llikinman. Chaynuqami ashwan masna llikikayanqa. ");
INSERT INTO qufNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Chaynulla, chay ubapa yakun mushuq binutaqa manami itanchikchu makwa qara kapachumanqa. Chaqa chay ubapa yakun binuqami byijuyar makwa qarataqa llikinman. Chaynuqami ashwan ubapa yakun binu chaynulla chay qara kapachupis yanqallana tukukanman. Chayraykumi, ubapa mushuq yakun binutaqa mushuq qara kapachumanna itaypaq”. ");
INSERT INTO qufNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Uk samana diyapi Jesusqa trigu tarpukashapa rurinta riyaran yaĉhakuqninkunawan. Piru yaĉhakuqninkunaqami trigupa ispiganta pitikuqnu riyaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Chayta rikarmi fariseukunaqa Jesusta kaynu niran: —¡Ay! ¿Imapaqtaq yaĉhakuqnikikunaqa kanan samana diyapi mana ruraypaq kaqtaqa rurayan? nir. ");
INSERT INTO qufNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Chaynu nitinllapami Jesusqa niran: —¿Manachu qamkunaqa liyishaykillapa, gubyirnu David uk kuti wakinninkunawan mallaqnar imanu tukuran nir iskribikashantaqa? ");
INSERT INTO qufNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Chaqa chay tyimpukunapimi kurakunapa mantaqninqa Abiatar karan. Piru Davidmi wakinninkunawan Dyusta adurananllapa tuldu wasiman yaykur, Dyuspa kaq turtillakunata mikuranllapa. Allita yaĉhashanchikllapanu, chay turtillakunataqami, kurakunala mikunanllapapaqqa kaq. ");
INSERT INTO qufNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesusqami niranpis: —Dyusqami samana diyataqa ruraran runakuna mana qischakananpaqchu. Ashwanmi ruraran chay diyapimapis aligriyananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Chaymi Dyusmanta Shamuq Runa kar, chay samana diyapiqa imata ruraypaq chaynulla mana ruraypaqchu niyta puytini. ");
INSERT INTO qufNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Chaymantami uk samana diyapi Jesusqa chay Israel runakuna tantakananllapa wasiman qashan yaykuran. Chaypimi uk runa wiqru makiyjun karan. ");
INSERT INTO qufNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Piru chaypiqami riparakuqkuna, mana shaykuq kusalata Jesustaqa chapar, ninakuyaranllapa: “¿Ima kay samana diyapichu alliyachiyanqa wak runataqa? Chayta ruratinqami, chaylapaqna uchachashunllapa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Piru Jesusqami chay wiqru makiyjun runataqa niran: —Sharir, ĉhaypinllapapi shay. ");
INSERT INTO qufNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Chaymantami chay runakunataqa kaynu nir tapuran: —Samana diyapiqa, ¿allin kaqtachu ruranchik manaqachu mana allin kaqta? Chaynulla ¿allinchu kanqa allichar washakunapaq manaqachu dijasha wanunanpaq? Chaynu nir tapukutinmi, chay runakunaqa mana imatapis rimarchu uyaralla kidaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Piru Jesusqami chay runakuna pay nishanta mana intrakanayashanllaparayku kusata piñakur, llakir ima chay qishaq runataqa kaynu niran: —Chutarachiy makikita nir. Chaynu nitin, chutarachitinqami makinqa allinna kidaran. ");
INSERT INTO qufNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Piru chaynu ruratinmapis, chay fariseo runakunaqa waqtaman lluqshimurqa, Herodespa wakinninkunawan parlaranllapa Jesustaqa wanuchinanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesús yaĉhakuqninkunawan chay atun quĉhapa manyanman ritinmi chay Galileapa pwiblunkunamanta kusala achka runakuna ikinta riranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Piru chaypi Jesús kusa shumaq mana ruraypaq imakunata rurayan nir yaĉharllapami Judea pwiblukunamanta, Jerusalenmanta, Idumeamanta, Tirumanta, Sidón pwiblukunamanta ima kusala achka runakuna Jesús kayashanman shamuranllapa. Chaynullami Jordán riyupa uklaw chimpanmanta ima shamuranllapa Jesusta rikayta munar, chay atun quĉhamanqa. ");
INSERT INTO qufNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Chaynumiri kusata untamuranllapa. Chaypimi Jesusqa achka qishaqkunata allicharan. Chaymi tukuy chay qishaqkuna alliyananllaparaykuqa kumsanakuypa, saruĉhanakuypa wakmanta kaymanta untaranllapa Jesusta kamarla alliyananllapapaq. Chayraykumi Jesusqa yaĉhakuqninkunata kaĉharan uk yaku karruta listatinllapa, chaymanna iqatin amana mas kiĉhkichinanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Chaynullami chay dyablupa yarpuyninwan kaq runakunapis Jesusta rikarqa, paypa naypanpi qunqurir, qayĉhakuranllapa: “¡Qamqami Dyuspa Wamran kanki!” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Piru Jesusqami anyaran chay dyablupa yarpuyninkunataqa, amana chaynu paypaq rimananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Chaymantami Jesusqa uk sirkaman iqar, kusa allinta yarpuchishan runakunata qayaran. Chaynu qayatin tantakatinllapanaqa, ");
INSERT INTO qufNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","paykunamanta dusi runakunata akraran paywanna purinanllapapaq. Chaynulla rir yaĉhachikunanllapapaq imami karan. ");
INSERT INTO qufNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Chaynullami paykunataqa Jesusqa pudirninta quran qishaqkunata allichananpaq, dyablupa yarpuyninkunata runakunamanta itakunanllapapaq ima. ");
INSERT INTO qufNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Kaykunami chay dusi akrashankunaqa karan: Ukqami Simón karan. Payllatami shutichiranpis Pedro nir. ");
INSERT INTO qufNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Chaymantaqami karan Zebedeupa ishkay wamrankuna Santiago, Juan ima. Kay paykunatami shutichiran “Boanerges”. Rimayninchikpiqa “Kunyapa Wamrankuna” nir intrachimanchik. ");
INSERT INTO qufNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Wakinkunaqami karan: Andrés, Felipe, Bartolomé, Mateo, Tomás. Chaynullami karanpis Alfeupa wamran Santiago, Tadeo ima. Ukqami karan Simón. Payqami Cananeo partidumanta karan. ");
INSERT INTO qufNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Uk-shuypaqa karan Judas Iscariote. Kaymi Jesustaqa kuntrankunaman qukuran wanuchinanllapapaqqa. ");
INSERT INTO qufNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Chaymantaqami Jesusqa yaĉhakuqninkunawan yaykuran uk wasiman. Piru chaymanpismi kusa achka runakuna untaranllapa. Chaymi Jesús, chaynulla yaĉhakuqninkunamapis mana mikuylamatapis puytiqllapachu. ");
INSERT INTO qufNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Chaynu yaĉhachikur mana mikutin imami, Jesuspa ayllunkunaqa riranllapa wasinman apananllapapaq. Chaqa wakinkunaqami “Jesusqa yaruyasha” niyaqllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Chaynulla Moisés mantakushanta yaĉhar yaĉhachikuqkuna Jerusalenmanta ĉhasha kaqkunapis kaynu niyaqllapa: “Chay dyablupa mantaqnin Beelzebú shutiqmi, wak runataqa pudirninta qusha runakunamanta dyablupa yarpuyninkunata itakunanpaqqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Chaynu niqta uyaparmi Jesusqa paykunata qayamuran. Chaymantami uk kumparasyunta rurar kaynu niran: “¿Imanuna dyabluqa uk dyablu masinta itakuyta puytinqa? ");
INSERT INTO qufNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Chaynullami mayqan pwiblupis paykunapura ĉhiqninakurqa mana maydiyapis pulla kaytaqa puytinchu. ");
INSERT INTO qufNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Chaynulla uk ayllupis paykunapura ĉhiqninakurqa, mana shumaqta kawsaytaqa puytinllapachu. ");
INSERT INTO qufNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Chaynullami dyablupis, uk dyablu masinta itakurqa ukninta itakushanrayku manami allinchu. Chaymi manana pulla kaytaqa puytiyanqanachu. Ashwanmi chaynu ruranakurqa limpu tukukayanqallapana. ");
INSERT INTO qufNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Chaqa allita yarpuyllapa: Uk kusala pulsuyjun runapa wasinman mayqanpis suwakuq yaykunarqami, chay wasipa amunta puntataqa wataytaraq ministiyan. Chaynu wataraqmi suwaytaqa puytiyan, manaqa mana”. ");
INSERT INTO qufNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","30","Chaymantami Jesusqa chay runakuna wakqami dyablupa pudirninwan nishanllaparayku, kaynu niran: “Chiqaptami nishaykillapa: Runa tukuy uchakushanta chaynulla mana allinta rimashantami Dyusqa pirdunanqa. Piru Santu Ispiritupaq mana allinta rimashanllapata-shuypaqa mana maydiyapis pirdunanqachu”. ");
INSERT INTO qufNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Chaymantaqami Jesuspa mamanwan, ukninkuna ĉharanllapa. Piru waqtalapi kidarmi kaĉhakuranllapa Jesusta qayamunanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Chaymi Jesuspa ridurninpi taqkunaqa kaynu niranllapa: —Mamaykiwan, uknikikunami chay waqtapi. Qamtami maskashuyanllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesusqa niran: —¿Mayqantaq mamayqa? ¿Mayqantaq ukniykunaqa? ");
INSERT INTO qufNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Chaymi chay ridurninpi taqkunata chapar niranpis: —Kaykunami mamaywan, ukniykunaqa. ");
INSERT INTO qufNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Chaqa mayqanpis Dyus munashanta ruraqkunalami ullqu kaq, warmi kaq ukniykunaqa, chaynulla mamaymapis nir. ");
INSERT INTO qufNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Chaymantami Jesusqa chay kusala atun quĉhapa manyanpi qashan yaĉhachikuq qallariran. Piru kusa achka runakuna tantakayatinmi, Jesusqa chay quĉhapi yaku karru karan chayman iqar taran. Nataq runakunaqami chay quĉhapa manyanlapi kidaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Chaymi kumparasyunkunawan kusa achka imakunata yaĉhachikuran. Chaymi kaynu niyaran paykunataqa: ");
INSERT INTO qufNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Allita uyakuyllapa. Uk runami tarpukuq riran ĉhakranman. ");
INSERT INTO qufNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Chaymanta shikwakutinqa wakin simillaqa nanman rataran. Chaymi pariq kurukuna shamur mikuran chay simillataqa. ");
INSERT INTO qufNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","“Nataq wakin similla-shuypaqa rumipa ananpi yaqqa mana allpa kaqman rataran. Piru chay simillaqami daskaqla winaq qallariran, mana ruri maypi pampakashanrayku. ");
INSERT INTO qufNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Chaymantami, rupay iqamutinqa mana allita ĉhupakushanrayku, daskaqla ñutukur chakiran. ");
INSERT INTO qufNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","“Nataq wakin simillakunaqami kasha rurikunaman rataran. Chaymantami kashakuna winar ĉhamitachitin, mana puqurannachu. ");
INSERT INTO qufNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","“Piru wakin similla-shuypaqami rataran kusa shumaq pachaman. Chaymi kusa shumaqta winatin, kusala shumaqta kusichakuranllapa. Chaqa, wakin ispigaqami trinta murisituyjun karan. Nataq wakin ispigaqa sisinta murisituyjun. Wakin-shuypaqa, syin murisituyjun ima karan”. ");
INSERT INTO qufNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Chaynu nishana karmi Jesusqa niranpis: “Rinriyjun kaqkunaqa uyakur intrakayllapa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Chaymanta achka runakuna ritinnaqa Jesusqa paylana kidaran. Piru chaypiqami karanraq Jesuspa pullan puriqkuna chaynulla chay dusi yaĉhakuqninkuna ima. Chaymi paykunaqa kaynu nir Jesustaqa tapuranllapa: —Chay kumparasyunqa, ¿imatataq intrachimanchikqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesusqa niran: “Qamkunatami Dyusqa imanumi mantakun nirqa paylla intrachishuyanllapa, unay michka mana intrakasha katinllapamapis. Piru tukuy mana kriyishanrayku waqtapi yupay kaqkunata-shuypaqami kumparasyunkunalawan willan, ");
INSERT INTO qufNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","michka chapakurmapis mana rikananllapapaqchu. Chaynulla michka uyakurmapis mana intrakananllapapaqchu. Chaynu tukur Dyuspi mana qashan kriyirqami, uchanllapamantaqa manana pirdunakanqallapanachu”. ");
INSERT INTO qufNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesusqami chay tapuqkunataqa niran: “¿Ima qamkunapischu mana intrakashaykillapa chay kumparasyuntaqa? Chaynu kay kumparasyunta mana intrakarqa, ¿imanuna wakin kumparasyunkunata ruratiymaqa intrakankillapa? ");
INSERT INTO qufNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","“Allita uyakuyllapa: Uk tarpukuq nirqami intrachimanchik Dyuspa rimayninta parlakuqpaq. ");
INSERT INTO qufNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Wakin simillakuna nanman ratasha nirqami intrachimanchik Dyus nishanta uyapar mana intrakaqpaq. Chaymi dyablu shamurqa, chay yarpuyninpi purichiyashantaqa limpu qunqachin. ");
INSERT INTO qufNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","“Nataq chay similla rumikunapa rurinman ishkiran chaykunaqami, intrachimanchik chay runakuna Dyus rimashanta kusa aligrila uyakuqpaq. ");
INSERT INTO qufNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Piru mana allita ĉhupakusha karmi, mana shachinakuytaqa puytinchu. Chayraykumi Dyuspi kriyishanrayku imallapiqa qischakar, manaqa imanachinanllapapaq ikinllapapi puritinqa chay uyakushanta dijarna qunqanllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","“Nataq chay simillakuna kashapa rurinman ratashakunaqa, intrachimanchik Dyus nishanta uyapaqkunapaq. Piru kay pachapi imanupis kusa imayjun kanar tukuy imata munar, imakunapi yarpupakur imaqa, Dyusmanta ashunllapa. Chayraykumi, chay munashankuna, yarpupakushankuna ima, paykunata ĉhamitachiq yupay Dyuspa rimaynintaqa qunqachir, manana dijanchu puqunanpaqqa. ");
INSERT INTO qufNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Piru wakinkunaqami Dyus nishanta allita uyakur kasur kusa shumaqtana kawsanllapa. Chaymi paykunaqa imanutaq simillamaqa kusa shumaq pachapi tarpukar kusala achkata puqun chay yupay. Chaymi paykunamanta wakinqa imanutaq uk ispigamaqa trinta murisituyjun karan, wakin-shuypaqa sisinta murisituyjun, wakinqami syin murisituyjun karan kada ispiga chay yupay”. ");
INSERT INTO qufNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Chaynullami Jesusqa paykunataqa niran: “Uk lamparata achkirachikunanpaq apamurqachu ¿kajunpa rurinman manaqa uk parapa ĉhakinpi ĉhuranchik? ¡Manami! Ashwanmi unaqlapi ĉhuranchik achkirachikunanpaqqa. ");
INSERT INTO qufNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Chaynullami kanan qamkunata willashutiyllapa wakinkunapaq pakaplla yupay kaqkunaqa, maydiyaqa uk lampara achkirachikuq yupay shutillamanna rikaritin allita intrakanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","“Chayraykumi, rinriyjun kaqkuna uyakur intrakayllapa”. ");
INSERT INTO qufNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jesusqami niranpis: “Allita uyakur kasumayllapa. Chaqa kanan imanu ukkunata yanapatkillapaqami, chay yanapashaykinullana Dyusqa qamkunatapis mastana yanapashunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Chaqa mayqanpis intrakar kasukuqtaqami masta qushaq. Piru chay mayqanpis mana intrakanaqta-shuypaqami pitilata intrakashanmatapis limpula qunqachishaq” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesusqami niranpis: “Dyuspa mantakuyninqami imanutaq uk runamaqa ĉhakranpi simillata tarpur dijan chay yupay. ");
INSERT INTO qufNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Chaqa chay tarpukuqqami rirqa punun, rikĉhakun ima. Piru payqami mana kwintata qukatinchu nasimur winan chay simillaqa unaq katin, tuta katinmapis. ");
INSERT INTO qufNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Chaqa pachaqami paylla winachitin, puntataqa yurakunraq. Chaymantami ispigakur puqurna untachikun. ");
INSERT INTO qufNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Chaynu puqur qarwatinmi, amunqa kusichakun. Chaynu yupaymi Dyuspa mantakuyninqa”. ");
INSERT INTO qufNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesusqami niranpis: “¿Imanu yupaytaq Dyuspa mantakuyninqa manaqa imawantaq kumparayman Dyuspa mantakuynintaqa? ");
INSERT INTO qufNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Dyuspa mantakuyninqami uk mustasa qirupa simillanta pachapi tarpunllapa chay yupay. Chay simillaqami kusala llampitu tukuy qirupa simillanmantaqa. ");
INSERT INTO qufNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Piru tarputinllapa atunta winarmi, kusala achka rikrayjunpaqna tikrakan, wakin mallkikuna ĉhakrapi kaqkunamantaqa. Chaymi ashwan pariq kuritukunamapis chay rikrankunapina llantukur tanllapa ima”. ");
INSERT INTO qufNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesusqami runakunataqa kusala achka kumparasyunkunawan yaĉhachiran imanu intrakananllapapaq nir. ");
INSERT INTO qufNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Chaqa manami imatapis mana kumparasyunkunawanqa yaĉhachiranchu. Nataq yaĉhakuqninkunata-shuypaqa chaymantana paykunalata intrachiq ima niyanmi chay kumparasyunqa nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Chay diyallapi limpu amsayatinnaqa Jesusqa yaĉhakuqninkunata niran: “Rishunllapa kay quĉhapa waklaw manyanman” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Chaymi paykunaqa, runakunata dijar, chay yaku karrullapi Jesusta apar riranllapa. Wakin yaku karrukunapis pullan riranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Chaynu riyatinllapami kusala jwirti wayra shamushanrayku yakuqa kusata wakman kayman maqchikaq qallariran. Chaymi chay yaku karrutaqa pampanayaranna. ");
INSERT INTO qufNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Piru chaykamanqami Jesusqa ikikaqlawpi uk almadapi umanta sintikuchisha punuyaran. Chaymi chay yaĉhakuqninkunaqa rikĉhachir kaynu niran: —¡Taytituy! ¿Manachu kwintata qukanki yakumanmi chinqayanchikllapana nirqa? ");
INSERT INTO qufNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Chaymantami Jesusqa sharir, wayrawan yakutaqa kaynu niran: —¡Uyarar, qasillay! nir. Chaynu nitinqami wayrawan yakuqa limpu limpu qasillaran. ");
INSERT INTO qufNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Chaymantaqami Jesusqa yaĉhakuqninkunataqa niran: —¿Imapaqtaq kusalata manchakunkillapa? ¿Qamkunaqachu manaraq allitaqa kriyimankillapa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Piru paykunaqami kusalata manchakushanllaparayku dispantakashalla kaynu nir tapunakuyaqllapa: “¿Kayqa, imanu runa katintaq wayrawan yakumapis kasunqa?” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Chaynu rirmi chay quĉhapa uklaw manyan Gadara shutiq lugarman ĉharanllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Chaymanta Jesús yaku karrumanta ishkitinqa, dyablupa yarpuyninwan kaq uk runa qimikaran. ");
INSERT INTO qufNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Chay runaqami pantyunkunapi taq. Chaynulla kusala jwirsayjun ima kaq. Chaymi michka kadinakunawan watarmapis mana qasillachiytaqa puytiqllapachu. ");
INSERT INTO qufNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Chaqa qasillachinanllapapaq nirmi kutir kutir makinkunata, ĉhakinkunata ima kadinakunawan wataqllapa. Piru chaynu kadinakunawan watatinllapamapis manami sirbichiqchu. Ashwanmi imanupis pidasu pidasu pitiq. Chaymi mayqanpis mana imanupis binsiyta puytiqllapachu. ");
INSERT INTO qufNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Chay runaqami unaqpis, tutapis, sirkakunapi, pantyunkunapi kusalata qayĉhakur, rumikunawan paylla takakar ima puriq. ");
INSERT INTO qufNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Piru Jesusta rikar-shuypaqami kusalata kallpar rir naypalanpi qunquriran. ");
INSERT INTO qufNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Chaymi Jesusqa chapar niran: —Qam, dyablu mana sirbiq, lluqshiy kay runamanta nir. Chaynu niyatinmi dyabluqa qayĉhakur kaynu niran: —¡Unaq syilumanta Dyuspa Wamran Jesús, ama nuqamanqa yakapakamuychu! ¡Tayta Dyuspa shutinpimi rugashayki ama qischamanaykipaqchu! nir. ");
INSERT INTO qufNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Chaynu qayĉhakuyatinmi Jesusqa tapuran: —¿Imataq shutinki? nir. Chay runaqa niran: —Nuqaqami shutini ‘Legión’. Chaqa kusa achkami kanillapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Chaymantami chay dyablupa yarpuyninqa Jesustaqa kusalata rugaran ama chay lugarmantaqa itakunanpaqchu. ");
INSERT INTO qufNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Piru chay kayashanllapamanta yatanllapa sirkakunapimi kusa achka kuchikuna shitqakuyaran. ");
INSERT INTO qufNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Chaymi chay dyablupa yarpuyninkunaqa, Jesustaqa kaynu nir rugaranllapa: —Dijamayllapa chay achka kuchikuna kan chayman yaykunayllapapaq nir. ");
INSERT INTO qufNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Chaynu nitinmi Jesusqa niran: —Riyllapa nir. Chaynami chay dyablupa yarpuyninkunaqa runamanta lluqshir kuchikunamanna yaykuranllapa. Chaymi kuchikunaqa chay kutilla kusalata kallpar, qaqata rishannu quĉhaman ratar ĉhuqar wanuran. Chay kuchikunaqami dus mil (2,000) yupay karan. ");
INSERT INTO qufNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nataq chay kuchikunata michiqkunaqami alsakar riranllapa. Chaynu rirmi tukuyla ĉhakranpi kaqkunata chaynulla pwiblupi kaqkunata ima willaranllapa. Chaymi tukuyla runakuna lluqshir riranllapa rikaq. ");
INSERT INTO qufNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Chaymanta Jesús kayashanman ĉharnaqa, chay kusala achka dyablupa yarpuyninwan kasha runataqa, rikaranllapa yarpuyninpina mudakusha taqta ima. Chaqa dyablupa yarpuyninqa lluqshishana karan paymantaqa. Chaymi runakunaqa kusalata manchakuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nataq chay runakuna imanu chay dyablupa yarpuyninwan kaq runa alliyashanta, chaynulla imanu chay kuchikunawan pasashanta ima wakinkunata parlaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Chaymantami tukuyla runakuna kusalata Jesustaqa rugaranllapa, chay lugarninllapamantaqa rinanpaqna. ");
INSERT INTO qufNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Chaymi Jesús yaku karrupi rinanpaqna katinqa chay dyablupa yarpuyninmanta alliyasha runaqa Jesustaqa rugayaran paywan rinanpaq nir. ");
INSERT INTO qufNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Piru Jesusqami mana munarchu niran: —Ashwanmi riyna wasikiman. Chaymi aylluykikunata ima parlanki imanumi Dyusqa kusalata llakipashur allichashusha nir. ");
INSERT INTO qufNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Chaymi chay runaqa rir tukuyla chay Decapolispa pwiblunkunaman parlakuran, imatami Jesusqa paywan rurasha nir. Chayta uyaparqa tukuyla kusata dispantakaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Chaymantami Jesusqa chay quĉhapa uklawninmanta yaku karrupi qashan tikrakamuranna. Piru chaymanpismi kusala achka runakuna tantakaranllapa. Chaymi Jesusqa paykunawan chay atun quĉhapa manyanpina kidaran. ");
INSERT INTO qufNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Chaykamanqami Israel runakunapa tantakananllapa wasipi uk mantakuqnin Jairo shutiq ĉhamuran. Payqami Jesusta rikarqa, rir naypanpi qunqurikur kaynu nir kusalata rugaran: ");
INSERT INTO qufNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","—Taytituy, wamraymi wanuyanna. Imaraq rir makisituykikunata ananman ĉhurankiman, alliyarna kawsananpaq nir. ");
INSERT INTO qufNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Chaymi Jesusqa riran paywan. Piru kusala achka runakunami pullanqa riran. Chaymi kusala kiĉhkipi riyaran payqa. ");
INSERT INTO qufNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Piru chay runakunapa rurintami riyaran uk warmisita. Chay warmimi dusi añupaqna yawarnin shamutin qishaq karan. ");
INSERT INTO qufNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Chaymi rimidyakuqkunapi, kusalata gastaran iman kaqninkunalamatapis. Piru manami mayqanpis allicharanchu. Ashwanmi masna binsikayaran. ");
INSERT INTO qufNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Chaymanta Jesuspaq rimaqta uyaparqa yarpuran: “Jesuspa raĉhpanta kamarlami alliyashaq” nir. Chaymi payqa runakunapa rurinlata rir, ikinmanta Jesuspa raĉhpanta kamaran. ");
INSERT INTO qufNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Chaynu kamatinlami, chay kutilla yawarnin shamuqqa qasillaranna. Chayna kwirpuntaqa alliyaqtana syintiran. ");
INSERT INTO qufNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Piru Jesusqami kwintata qukaran pudirnin yarqusha nir. Chaymi ikiman tikrakar runakunata kaynu nir tapuran: —¿Pitaq raĉhpayta kamasha? nir. ");
INSERT INTO qufNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Yaĉhakuqninkunaqa niran: —¿Manachu rikanki kusala achka runakuna wakmaqa kiĉhkichishuyan? Piru chaynumapis tapukuyanki: ‘¿Pitaq kamamasha?’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Piru Jesusqami kusalata chapayaran tukuy ridurninpi kaqkunata, mayqantaq raĉhpayta kamasha kanqa nir yaĉhananpaq. ");
INSERT INTO qufNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Chaymantami chay warmiqa yaĉharanna nuqapaqmi chapakuyan nir. Chaymi kusalata manchakur chukchukyaqnulla rir Jesuspa naypalanpi qunqurikur, imanu kashantapis karanlata willaran. ");
INSERT INTO qufNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesusqa niran: —Mamitay, kriyishaykiraykumi alliyashaykina. Chayraykumi aligrilana rikuy. Chaqa tukuy qishaynikimantami alliyashaykina. ");
INSERT INTO qufNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Chaynu nir Jesús rimayatinllami, chay tantakananllapa wasipi mantakuq Jairupa wasinmanta ukkuna ĉhamur kaynu niranllapa: —Wamraykiqami wanushana. Amana masqa qillakachiynachu chay yaĉhachikuqtaqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Piru Jesusqami chay nishanllapata mana kasurchu, Jairutaqa niran: —Ama manchakuychu. Nuqalapi kriyiy nir. ");
INSERT INTO qufNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Chaynu nirqa, chay ikinta riqkunataqa Jesusqa manana munaranchu pullan rinantaqa. Chaymi Jairuta, Pedruta, Santiaguta uknin Juanlawan ima aparan. ");
INSERT INTO qufNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jairupa wasinman ĉharqami, uyaparan kusata llakir waqaqllapata ima. ");
INSERT INTO qufNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Chaymi Jesusqa wasi ruriman yaykurqa niran: —¿Imapaqtaq kusata waqar imaqa laqyayankillapa? Wamraqami mana wanushachu. Punuyanlami nir. ");
INSERT INTO qufNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Chaynu nitinmi kusalata asiparanllapa. Piru payqa tukuy ruripi kaqkunata waqtaman urquran. Chayna wamrapa taytanta, mamanta apar, chay kimsa pullan riqkunalawan yaykuran ruriman, chay wamra usurayashanmanqa. ");
INSERT INTO qufNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Chaymanta makinmanta aypar wamrataqa niran: —Talita cumi. (Rimayninchikpiqa munan niyta: “Mamitay, qamtami nishuni: ¡Sharimuy!” nir). ");
INSERT INTO qufNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Chaynu nitinlami, chay dusi añuyjun wamraqa sharir puriq qallariran. Chayta rikarmi tukuy runakuna kusalata dispantakaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Piru Jesusqami paykunataqa niran: —Amami mayqantapis tukuy kaykunapaqqa parlankillapachu nir. Chaymantami kaĉhakuran wamrataqa qarananllapapaqna. ");
INSERT INTO qufNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Chaymantaqa chay Jairupa pwiblunmanta lluqshir Jesusqa yaĉhakuqninkunawan qashan tikrakaran Nazaret pwiblullamanna. ");
INSERT INTO qufNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Chaymi uk samana diyapi Jesusqa chay tantakananllapa wasipi yaĉhachikuq qallariran. Chaynu yaĉhachikutin kusala achka runakuna uyapar kusa dispantakashalla kaynu nir tapunakuyaqllapa: “¿Kayqa maypitaq yaĉhakuranqa kay kusa yaĉhayashantaqa? ¿Wak yaĉhayninqa maymantataq kanqaqa? Chaynulla ¿imanutaq milagrukunata kusalata ruranqa? ");
INSERT INTO qufNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Manachu kayqa Mariapa, iĉhkakuq wamran? Chaynulla ¿manachu Santiagupa, Josipa, Judaspa, Simonpa uknin kay runaqa? ¿Manachu paypa warmi ukninkunamapis kaypi nuqanchikkunawan tanllapa?” Chaynu nir imami, mana kasunaranllapachu. ");
INSERT INTO qufNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Chaymi Jesusqa niran: —Tukuy uklaw pachapimi kusa shumaqta rikanllapa uk runa Dyuspaq rimaqtaqa. Piru chay pwiblunllamanta kaqkuna, ayllunkuna chaynulla wasinllapi imaqami mana kasunllapachu nir. ");
INSERT INTO qufNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Chaymi payqa chay Nazaret pwiblunllapiqa mana ima milagrutapis ruraranchu. Ashwanmi wakin qishaqkunapa ananman makinkunata ĉhurar allicharanla. ");
INSERT INTO qufNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Piru Jesusqami kusalata yarpupakuran, chay runakuna paypi mana kriyinashanrayku. Jesusqami tukuy shipchakaq pwiblukunapi yaĉhachikur puriran. ");
INSERT INTO qufNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Chaymantami dusi yaĉhakuqninkunataqa qayamur pudirninta quran, dyablupa yarpuyninta ima itakunanllapapaq. Chaynami ishkay ishkay kaĉharan rir yaĉhachikunanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Kaynu nirmi kaĉharan paykunataqa: “Nanpaqqami ama imatapis aparchu, bastunnikillapata charikurla rinkillapa. Chaynulla amami alburjata, jyamrita, qillayta imamapis apankillapachu. ");
INSERT INTO qufNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Chaynullami llanqikillapata llanqikur, raĉhpaykillapata yakakur ama mudanantinqa aparchu rinkillapa. ");
INSERT INTO qufNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Chaynullami, uk kusa allin runapa wasinman ĉhar samarqa, chay wasilapina kidankillapa chay ima diyaĉhi rinaykillapakaman. ");
INSERT INTO qufNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Piru may lugarlawpi mana samachishurllapa chaynulla yaĉhachikutkillapa mana uyakushunatinllapaqa, chaymantaqa ĉhakikillapapi kaq pulbumatapis ĉhaspir rinkillapa. Chaynu rurarqami intrachinkillapa: ‘Manami nuqakunapa kwintayllapanachu. Ashwanmi qamkunapina kanqa’ nir. Chiqaptami nishaykillapa: Jwisyu diya ĉhamutinqami chay pwibluqa kusala manchaypaqtana kastigakasha kanqa chay Sodomawan, Gomorra pwiblu kastigakashanmantaqa nir.” ");
INSERT INTO qufNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Chaymi Jesuspa yaĉhakuqninkunaqa rir yaĉhachikuranllapa: Uchaykillapata dijarna Dyusman tikrakayllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Chaynulla dyablupa yarpuyninmatapis kusala achkata itakuranllapa. Qishaqkunatapismi allicharanllapa asaytiwan salar ima. ");
INSERT INTO qufNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Gubyirnu Herodesmi Jesuspaq kusalata rimaqllapata uyaparan. Chaqa chaynu rimatinllapami tukuy intirupi yaĉharanllapana. Chaymi Herodesqa kaynu niran: “Chay Jesusqami, Shutichikuq Juanlla kanqa. Chaqa wanushanmanta kawsamushanraykumi milagrukunamatapis rurayta puytiyanqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Nataq ukkunaqa Jesuspaqqa niqllapa: “Dyuspa rimaqnin Eliasmi” nir. Wakinkuna-shuypaqa niqllapa: “Dyuspa uk rimaqninmi kanqa, imanutaq unay rimaqkuna kaq chaynulla” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Chaynu nitinllapa uyaparmi Herodesqa, kaynu niran: “Chayqami Shutichikuq Juan. Nuqami umanta pitichikutiy wanuran. Piru kananqami kawsamusha” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Chaqa Shutichikuq Juan kawsayatinmi, Herodesqa uknin Felipipa warmin Herodias shutiqta warmikur mana allintachu tukusha karan. Chaypaqmi Shutichikuq Juanqa Herodestaqa kaynu nisha kayaq: “Chay ukniki Felipipa warmin Herodiasta warmikita yupay purichiyashaykiqami mana allinchu” nir. Chayta nishanraykushi, Herodesqa kaĉhakuran Juantaqa aypar kadinakunawan watar karsilananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Chaynullashi chay Herodias warmipis Shutichikuq Juan, runanta chaynu willashanrayku ĉhiqnir, kusalata wanuchiyta munarmapis mana puytiranchu. Chaqa Herodesqashi warmintaqa mana dijaranchu chayta rurananpaqqa. Chaqa payqashi yaĉhaq Juanqami imatapis karanlata ruran chaynulla mana uchayjunlamapischu nir. Chayshi kusalata manchakuran. Chayraykushi Juan imata nitinpis Herodesqa kusa aligrila uyakur, mana imata nishaq nirpis yaĉhaqchu. ");
INSERT INTO qufNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Piru uk diyapishi chay Herodiasqa imanullapis Shutichikuq Juantaqa wanuchichiran. Chay diyapishi Herodespa kumpliyañun karan. Chayshi paypa mantaqninkunawan, suldadukunapa mantaqninkunawan, chaynulla chay Galileamanta kusa runa nishakunawan ima fyistata ruraranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Chaypi katinllapashi Herodiaspa warmi wamranqa tukuyla chaypi kaqkunapa naypanpi lluqshir bayliran. Chayshi chay baylishanqa tukuy chaypi kaqkunata chaynulla Herodestapis kusalata gustaran. Chayshi Herodesqa intinadanta niran: —Mamitay, ima munashaykitapis mañamay, nuqami qushayki nir. ");
INSERT INTO qufNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Chaymi qashan qashan jurar kaynu niran: —Ima munashaykitapis mañamay, nuqami qushayki, michka tukuy nuqa mantakushaymanta lamtar partin kaqmanmatapis nir. ");
INSERT INTO qufNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Chaynu nitinshi, chay wamraqa lluqshir rir, maman Herodiasta tapuran: —¿Imatataq mañayman? nir. Mamanqa niran: —Shutichikuq Juanpa umanta mañay nir. ");
INSERT INTO qufNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Chayshi wamraqa kallpaylla ruriman yaykur, Herodestaqa kaynu niran: —Kananllami Shutichikuq Juanpa umanta uk platupi qumanaykita munani nir. ");
INSERT INTO qufNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Chaynu nirqashi mantakuq Herodestaqa kusalata llakichiran. Piru chaynu llakiyarmapisshi, chaypi kaqkunapa naypanpi jurar arnishanrayku kaĉhakuran chaynu rurananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Chayshi uk suldadunta kaĉharan karsilman rir Juanpa umanta apamunanpaq. ");
INSERT INTO qufNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Chayshi chay suldaduqa karsilman rir, Juanpa umanta pitir uk platupi apamur, chay warmi wamratana quran. Nataq chay wamraqashi mamantana ashwan quran. ");
INSERT INTO qufNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Chaymantashi Juanpa yaĉhakuqninkunaqa chayta yaĉharqa rir, karsilmantaqa kwirpunlatana apar pamparanllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Chaymantaqami Jesuspa dusi yaĉhakuqninkunaqa, tikrakamuranna. Chaynu tikrakamurmi Jesusta parlaranllapa imakunata rurashanllapata, yaĉhachikushanllapata ima. ");
INSERT INTO qufNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Piru chay diyakunapiqami Jesús kayashanmanqa kusala achka runakuna tantakaranllapa. Chaymi chay runakunata yanapar ima Jesusqa yaĉhakuqninkunawan mana puytiqllapachu samar mikuylamatapis. Chaymi Jesusqa chay yaĉhakuqninkunata niran: —Rishunllapa chay chunllaq lugarkunaman, ratulaqa samaq nir. ");
INSERT INTO qufNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Chaymi yaku karrupi paykunalana riranllapa chay chunllaq lugarkunamanna. ");
INSERT INTO qufNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Piru chaynu ritinllapami kusa achka runakuna rikar riqsiranllapa. Chaymi yaĉharanllapa maymanmi riyanllapa nir. Chayraykumi tukuyla pwiblukunamanta runakunaqa kusalata kallpar rir, ashwan paykunamantaqa naypaqta ĉhar yararanllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Chaymanta Jesús yaku karrumanta ishkirqa chay kusa achka runakunata rikar kusalata llakiran. Chaqa paytaqami yarpuchiran, uyshitakuna mana michikuqniyjun kanman yupay. Chaymi payqa kusa achka shumaq imakunata yaĉhachiran. ");
INSERT INTO qufNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Piru limpu tardiyayatinnaqami chay yaĉhakuqninkunaqa qimikar kaynu niranllapa: —Kay lugarpiqami mana imapis kanchu. Chaynulla kusa tardinami. ");
INSERT INTO qufNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Chayraykumi runakunataqa willay chay lugarkunaman, pwiblukunaman rir mikunanllapata rantinanllapapaq nir. ");
INSERT INTO qufNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Piru Jesusqami niran paykunataqa: —Qamkuna qarayllapa nir. Chaynu nitinqa niranllapa: —¿Munayankichu kwichka achka dusyintus dinaryu qillaywan tantata rantir qaranayllapapaq? nir. ");
INSERT INTO qufNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesusqa niran: —¡Rir, rikayllapa! ¿Aykataq tantitaykillapaqa? Chaymanta paykuna rir rikarqa niranllapa: —Sinku tantitawan, ishkay piskaditulami kan nir. ");
INSERT INTO qufNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Chaynami Jesusqa tukuy chay runakunataqa wakpi kaypi muntun muntun tananllapapaq willaran chay qiwakunapina. ");
INSERT INTO qufNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Chaymi paykunaqa kada muntunpi syin, syin; chaynulla sinkwinta, sinkwinta ima taranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Chaynu tashallapana katinqami, Jesusqa chay sinku tantitawan, ishkay piskadituta aypar unaq syiluman chapakur payji nir, Taytan Dyusman mañakuran. Chaymantami chay tantakunata pidasu pidasu pakir yaĉhakuqninkunata quran tukuyla chaypi kaq runakunata aypachinanllapapaq. Chaynumi chay ishkay piskaditutapis tukuylata aypachiranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Chaynumi tukuyla mikuranllapa tiqllananllapakaman. ");
INSERT INTO qufNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Chaymantaqami chay tantapa chaynulla piskadupa subrantaqa dusi kanasta untataraq tantaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Piru chay mikusha chaykunata yupatinllapaqami ullqukunala sinku mil (5,000) karanllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Chaymanta Jesusqa yaĉhakuqninkunata yaku karruman iqachiran, rir ĉhaskinanllapapaq quĉhapa uklawnin Betsaida pwibluman paymantaqa naypaqta. Nataq payqa chaylapi kidaran tukuyla dispidikur rinanllapakaman. ");
INSERT INTO qufNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Chaynu dispidikur ritinllapanaqa, Jesusqa uk sirkaman payla iqaran Taytanman mañakuq. ");
INSERT INTO qufNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Limpu amsayatinnaqa yaku karruqa chay quĉha ĉhaypipina karan. Piru Jesús payla pachapi karmi, ");
INSERT INTO qufNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","rikaran chay yaku karruqa mana yaqqa riyta puytiqtachu. Chaqa naypanllapalawmantami kusala jwirti wayra shamuyaran. Limpu achkiyaqpinaqa, Jesusqa yaku ananllata riran yaĉhakuqninkunalawman. Piru chaynu paykunaman riyarmapis, dirichu pasar rinaq yupay tukuran. ");
INSERT INTO qufNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Chaynu yakupa ananta riqta tukuy yaĉhakuqninkuna rikarmi, kusalata manchakur “¡Wakqami aya!” nir kusata qayĉhakuranllapa. Chaymantami Jesusqa paykunataqa kaynu niran: —¡Shachinakur ama manchakuyllapachu! ¡Nuqami kani! nir. ");
INSERT INTO qufNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Chaynu nirmi, payqa chay yaku karruman iqaran. Chaymi ashwan wayraqa limpu qasillaran. Chayta rikarmi paykunaqa limpu dispantakaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Chaqa manari intrakashallapachu karan Jesús chay tantitakunawan milagruta ruratin rikarmapis, mana allita paypi kriyishanllaparayku. ");
INSERT INTO qufNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Chaymanta chay atun quĉhata pasarqa, Genesaret lugarman ĉharanllapa. Chaymi ashwan chay yaku manyapina yaku karrutaqa watar dijaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Piru chaypi taqkunaqami yaku karrumanta ishkiqlata Jesustaqa riqsiranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Chaymi chay rikaqkunaqa rir tukuyla may lugarkunapi parlakuran Jesuspaqqa. Chayraykumi kusala achka qishaqkunata wintur ima ĉhachimuranllapa Jesusman. ");
INSERT INTO qufNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Chaymi Jesusqa maylawpi nir yaĉharllapaqa, chay may riyashan nankunapi ima qishaqninllapakunataqa apar yarachiqllapa. Michka pwiblukunapi, ĉhakrankunapi, nankunapi ima katinmapis, qishaqninllapataqa yarachiqllapa. Chaymi kusalata Jesustaqa rugaranllapa raĉhpanpa manyanlamatapis kamananllapapaq. Chaynu chay raĉhpanpa manyanta tukuy kamaqkunaqa allinna kidaqllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Chaymantami Jesusman qimikaranllapa fariseo runakuna, Moisés mantakushanta wakin yaĉhar yaĉhachikuqkuna ima. Paykunaqami Jerusalenmanta ĉhamusha karanllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Chaymi paykuna rikayatin, Jesuspa wakin yaĉhakuqninkunaqa mana makinta paqakurchu mikuranllapa. Chaynuqami mana ruraranllapachu chay paqakuna kustumritaqa. Chaymi kusala mana allinta yarpuchiran paykunataqa. ");
INSERT INTO qufNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Chaqa chay fariseukuna, chaynulla tukuy Israelmanta kaqkunaqami unay rukunllapakunapa kustumrinllawan kar, chay paqakuna kustumrita mana rurarqa mana mikuyta puytiqllapachu. ");
INSERT INTO qufNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Chaynulla rantiq rir, tikrakamurmaqa chay paqakuna kustumrita rurar, kusalata paqakur mikuqllapa. Chaynulla chay kustumrinraykuqami kaykunata kusalata paqaqllapa: Basu upyananllapata; jarrankunata, jyirru mankankunata, mantankunata ima. ");
INSERT INTO qufNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Chayraykumi chay fariseo runakuna chaynulla Moisés mantakushanta yaĉhar yaĉhachikuqkunaqa, Jesustaqa kaynu nir tapuranllapa: —¿Imapaqtaq yaĉhakuqnikikunaqa unay rukunchikkunapa kustumrin nishannulla mana rurar, makinllapata mana paqakur mikunllapaqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Chaynu nitinmi Jesusqa paykunataqa niran: —¡Dyusta yanqa kasuq tukuq kuchi runakuna! Waknupaqĉhi Dyuspa unay rimaqnin Isaiasqa, qamkunapaq rimaran. Chaqa niqmi: Kay pwiblumanta runakunaqami shiminllapalawan kasumanllapa. Piru yarpuyninllapapiqami mana chiqaptaqa kasumanllapachu. ");
INSERT INTO qufNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Chayraykumi yanqalla aduramaqllapa yupay tukunllapamapis. Chaqa chay yaĉhachikuyashan chaykunapis yanqa runakunapa yaĉhachikuyninla imami nir. ");
INSERT INTO qufNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Chaqa qamkunaqami Dyus mantakushanta mana kasurchu, runakunapa kustumrinlata rurar kawsankillapa. Chaynulla basu upyanaykillapata, jarraykillapata, uk kusa achka imakunata paqankillapa ima. ");
INSERT INTO qufNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jesusqami niranpis: “Qamkunaqami chay kustumrikillapata ruranaykillaparaykula, Dyus mantakushantaqa mana kasunkillapachu. ");
INSERT INTO qufNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Chaqa Moisesqami Dyus nitin kaynu nir mantakuran: ‘Taytaykita mamaykita kusa rispituwan kasuyllapa. Chay mayqanpis taytanta mamanta ĉhiqniqkunaqami wanuchikasha kanqallapa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Piru qamkunaqami ninkillapa, uk runaqa niyta puytin taytanta mamanta: ‘Manami yanapashuyta puytinichu. Chaqa tukuy imay kaqkunatami arnisha kani Dyusta’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Chaynu nirmi ninkillapa: ‘Mayqanpis chaynu niqqami manana taytanta, mamantaqa yanapayta puytinnachu’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Chaynuqami ninkillapa, Dyus mantakushanta mana kasurnachu, ashwan qamkunapa kusala achka kustumrikillapalatana yaĉhachikur kawsanaykillapapaq”. ");
INSERT INTO qufNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Chaymantami Jesusqa runakunata qayamur kaynu niran: “Allita uyakumarmi, intrakayllapa. Chaqa nishaykillapa: ");
INSERT INTO qufNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Mayqanpis ima mikuyta mikushanraykuqa manami uchakunchu. Ashwanmi mayqantapis yarpuyninllamanta kusala mana allin yarpuynin lluqshimuq uchakuchin.  ");
INSERT INTO qufNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Chaymi nishunillapa: Rinriyjun kaqkunaqa uyakur intrakayllapa nir”. ");
INSERT INTO qufNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Chaymanta Jesusqa chay achka runakunata chaypi dijar rirnaqa, uk wasiman yaykuran. Chaymi chay yaĉhakuqninkunaqa kaynu niranllapa: “Allita intrachimayllapa, chay naqa yaĉhachikushaykitaqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Chaymi paykunataqa niran: “¿Ima qamkunapischu mana intrakankillapa? Chaqa kaynumi niray: Mayqanpis ima mikuyta mikushanraykuqa manami uchakunchu nir. ");
INSERT INTO qufNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Chaqa chay mikuyqa manami yarpuyninmanchu rin mikutinqa. Ashwanmi paĉhanman rin, chaymantana kwirpunqa qashan itakamun”. Chaynu nirqami Jesusqa intrachikuyaran tukuy mikuyqashi allin mikunapaqqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Chaynullami niranpis: “Uk runapa yarpuyninmanta kusala mana allin yarpuynin lluqshimuqmi uchakuchin. ");
INSERT INTO qufNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Chaqa uk runapa yarpuyninmantaqami mana allin yarpuykuna lluqshimun. Chaymi musu kar, manaqa shipash karpis pakaplla kayta yarpun. Chaynulla suwakuyta, wanuchikuyta ima yarpunllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Chaynullami ukwan ukwan kayta, ukpa imankunata munapakuyta, mana allinta rurakuyta, llullachikuyta, yanqalla imantapis tukchiyta, ĉhiqnikuyta, ukpa washanta rimayta, kusa kani niyta ima yarpunllapa. Chaynullami mana yarpuyniyjun yupay purinllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Chaymi tukuy kay riqchaq mana allin yarpuykunaqa runapa yarpuyninllamanta lluqshimun. Chaynu karmi, ashwan runataqa uchakuchin”. ");
INSERT INTO qufNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Chaymantami Jesusqa riran chay Tiro pwibluman chaynulla Sidón pwibluman ima. Chayman ĉharqa, mana mayqanpis yaĉhananpaqchu uk wasiman yaykuran. Piru chaynu mana yaĉhananllapata munatinmapismi ashwan tukuyla yaĉharanllapana. ");
INSERT INTO qufNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Chaymi uk warmisita shamuran payman. Paypa warmi wamranmi dyablupa yarpuyninwan kaq. Chaymi shamur Jesuspa naypanpi qunqurikur, kusalata rugaran wamranmanta chay dyablupa yarpuyninta itakunanpaq. Chay warmisitaqami mana Israelmantachu karan. Ashwanmi Sirofenicia lugarmanta karan. ");
INSERT INTO qufNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Piru Jesusqa niran: —Dijay wamraykunataraq puntataqa qarashaq. Chaqa manami allinchu wamranchikpa mikunanta kitar allqitukunata qaranapaqqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Chaymi chay warmisitaqa niran: —Chiqaptami chaynu Taytituy. Piru allqitukunamapismi, misapa ĉhakinpi karqa chay wamritukuna ishkichishanlamatapis mikun nir. ");
INSERT INTO qufNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Chaynu nitinmi Jesusqa niran: —¡Mamitay, chiqaptami ninki! Rikuynari. Chaqa chay dyablupa yarpuyninqami wamraykimantaqa lluqshishana nir. ");
INSERT INTO qufNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Chaymi warmiqa wasinman rir ĉharqa, wamrantaqa mantanpi usuraqta tariran. Piru chay dyablupa yarpuyninqami lluqshishana karan. ");
INSERT INTO qufNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Chaymantami Jesusqa chay Tiro pwiblumanta lluqshir rir Sidón pwibluta, Decapolispa pwiblitunkunata pasar imana, ĉharan Galilea shutiq quĉhapa manyanman. ");
INSERT INTO qufNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Chayman ĉhatinmi payman apamuranllapa uk upa gagu runata. Chaymi rugaranllapa makinta ananpi ĉhurarla allichananpaq. ");
INSERT INTO qufNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Chaymantami Jesusqa chay runataqa tukuy chaypi kaqkunamantaqa uklawman apar, rinrinkunaman didunta itaran. Chaynulla tuqayninwan didunta nuyuchir chay runapa qallunta nuyuchiran. ");
INSERT INTO qufNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Chaymantami unaq syiluman chapakur, kusala jwirtita amayninta urqur, niran: “¡Efata!” (Rimayninpiqa niyaran: “¡Kiĉhakay!” nir). ");
INSERT INTO qufNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Chaynu nitinlami chay runapa rinrinkunaqa kiĉhakaranna. Qallunpis alliyatin, rimayta puytiranna. ");
INSERT INTO qufNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Chaymantami Jesusqa chaypi kaqkunata willaran ama mayqantapis willananllapapaqchu chayta rurashanpaqqa. Piru chaynu mayqantapis mana willananpaqchu kutir kutir nitinmapis, ashwan kusalata parlakuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Chaymi runakunaqa kusa dispantakashalla niyaqllapa: “Kusa allintami imatapis rurayan. ¡Chaqa upakunatapis uyakuchiyan! Chaynulla mudukunatapis rimachiyan ima” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Chaymantami qashan uk diyapi Jesusman kusa achka runakuna tantakaran. Piru manami imapis mikunanllapapaq karanchu. Chaymi Jesusqa yaĉhakuqninkunata qayamur niran: ");
INSERT INTO qufNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Kusatami llakini kay runakunapaqqa. Chaqa kimsa diyanari nuqawan kaypi. Mananami imata mikunanllapapaqpis kannachu. ");
INSERT INTO qufNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Chaymi mana qarar wasinllapaman kaĉhatiyqa, imanupiqa riyar mallaqpaq imananmanllapa. Chaqa wakinkunaqami kusala largu maymanta shamushallapa. ");
INSERT INTO qufNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Chaynu nitinmi, yaĉhakuqninkunaqa niran: —Piru, ¿imanunari waknu kusala achka runakunapaqqa kay chunllaq mana mayqanpis tayashanllapa lugarpiqa mikuytaqa tarishunllapa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesusqa tapuran paykunataqa: —¿Aykataq kan tantitaykillapaqa? nir. Paykunaqa niranllapa: —Syiti tantitalami kan nir. ");
INSERT INTO qufNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Chaymantami payqa willaran runakunata, pachalapimapis tananllapapaq. Chaymi, chay syiti tantitata aypar payji nir, Taytan Dyusman mañakuran. Chaymantami, tantakunata pakir quran chay yaĉhakuqninkunata. Chaymi paykunana runakunataqa aypachiranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Chaynullami karanpis ayka piskaditukuna. Chaymi aypar Dyusta payji nirqa, yaĉhakuqninkunata quran aypachikunanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Chaynumi tukuynin tiqllanankaman mikuranllapa. Ashwanmi subrankunata tantarqa, syiti kanastatana untachiranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Piru chay mikusha chaykunaqami kwatru mil (4,000) yupay karanllapa. Chaymantami Jesusqa tukuyta dispidirna, ");
INSERT INTO qufNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","yaĉhakuqninkunawan yaku karruman iqar riranllapa uk lugar Dalmanuta shutiqmanna. ");
INSERT INTO qufNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Chaymantami fariseo runakuna ĉhamur Jesuswan willanakuq qallariranllapa. Chaymi mabir ima ninqashi nir, kaynu niranllapa: “Chiqapta Dyusmanta shamushayki nir yaĉhanayllapapaqqa uk milagruta ruray” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Chaymi Jesusqa kusa jwirtita amayninta urqur, niran: “¿Imaraykutaq kay runakunaqa milagrukunataraq ruranaypaq mañamanqa? Chiqaptami nishaykillapa: Manami ima milagrulamatapis qamkunapaqqa rurashaqchu nir”. ");
INSERT INTO qufNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Chaynu nirnaqami, paykunalatana chaypi dijar qashan yaku karruman iqar riranna chay atun quĉhapa uklaw manyanmanna. ");
INSERT INTO qufNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jesuspa yaĉhakuqninkunaqa qunqar mana imalatapis apashallapachu karan mikunanllapapaqqa. Piru yaku karrupina karqa kwintata qukaranllapa, uk tantitalata apayanllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Chaymi Jesusqa niran paykunataqa: —Allita kwintata qukar, kuytakankillapa chay fariseo runakunapa, chaynulla Herodespa libaduranllapamanta nir. ");
INSERT INTO qufNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Chaynu nitinmi, yaĉhakuqninkunaqa, tanta mana kashanraykumi chaynuqa nimayashunllapa ninakuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Chaynu yarpuyanllapa nir yaĉhayashanraykumi, Jesusqa kaynu niran: —¿Imapaqtaq ninkillapa, tanta mana kanchu? nirqa. ¿Ima manaraqchu intrakankillapa? ¿Manaraqchu kwintata qukankillapa? ¿Ima kwichkachu yarpuynikillapaqa mana intrakan? ");
INSERT INTO qufNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Ima nawiyjun karmapischu mana rikashaykillapa rurashayta? ¿Ima rinrikillapa karmapischu mana uyaman? Chaynulla ¿mananachu yarpunkillapa chay, ");
INSERT INTO qufNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","sinku tantitamanta sinku mil runakunata qarashaytaqa? Chaynu qarakutiyqa, mabir ¿ayka kanasta untatataq subrantaqa tantaraykillapa? Paykunaqa niran: —Dusi kanastata nir. ");
INSERT INTO qufNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Ma, chay syiti tantitamanta kwatru mil runakunata qaratiyqa, ¿ayka kanasta untatataq subrantaqa tantaraykillapa? Paykunaqa niran: —Syiti kanastata nir. ");
INSERT INTO qufNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Piru Jesusqa paykunataqa niran: —¿Ima manaraqchu intrakankillapa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Chaynu riyarllapami ĉharanllapa Betsaida pwibluman. Chaypiqami apamuranllapa uk syigu runata Jesusman kamarla allichananpaq. ");
INSERT INTO qufNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Chaymi Jesusqa chay syigutaqa makinmanta aysakur, pwiblumanta waqtalawman aparan. Chaymantami tuqayninwan runapa nawinkunata nuyuchir, makinta ananman ĉhurar, tapuran: —¿Imallataqachu rikayta puytinkina? nir. ");
INSERT INTO qufNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Chaymi chay runaqa chapakuq qallarirna, niran: —Rikaninami runakunataqa qirukunata yupay. Piru puriqtami rikayani nir. ");
INSERT INTO qufNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Chaymi Jesusqa makinwan chay runapa nawinta qashan kamatin, kusalata chapakuyarqa, allinna kidaran. Chaymi tukuy imatapis rikayta puytiranna. ");
INSERT INTO qufNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Chaymantami Jesusqa chay runataqa wasikiman riyna nirqa, kaynu niranpis: —Amami chay pwibluman yaykunkichu. Chaynulla kay rurashaytaqa amami mayqantapis willankichu nir. ");
INSERT INTO qufNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Chaymantami Jesusqa yaĉhakuqninkunawan Cesarea Filipo pwibluman riranllapa. Chaynu riyarmi Jesusqa yaĉhakuqninkunata kaynu nir tapuran: —¿Nuqapaqqa mayqanshi kani ninllapataq runakunaqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Chaynu nitinqa paykunaqa niranllapa: —Wakinqami ninllapa, Shutichikuq Juan nir. Nataq wakin-shuypaqa ninllapa Elías nir. Chaynulla wakinkunaqa ninllapa Dyuspa uk rimaqnin kanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—Qamkunapaq-shuypaqa, ¿mayqantaq kani? —nir tapuran yaĉhakuqninkunataqa. Chaymi Pedruqa niran: —Qamqami Dyuspa Akrashan Cristun kanki nir. ");
INSERT INTO qufNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Chaynu nitinmi, Jesusqa paykunata willaran ama mayqantapis paypaqqa parlananllapapaqchu nir. ");
INSERT INTO qufNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Chaymantami Jesusqa yaĉhakuqninkunata kaynu nir yaĉhachiq qallariran: Dyusmanta Shamuq Runataqami chay ruku kaq mantakuqkuna, kurakunapa mantaqninkuna, chaynulla Moisés mantakushanta yaĉhar yaĉhachikuqkuna ima ĉhiqnir kusalata qischanqallapa. Chaynu qischarmi wanuchinqallapa. Piru kimsa diyamantaqami qashan kawsamunqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Chaynu nirmi, kusalata willar intrachiran paykunataqa. Chaymi, Pedruqa uklawman Jesusta paylata apar, anyaqnulla willaran ama chaynu rimananpaqnachu. ");
INSERT INTO qufNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Piru Jesusqami tikrakar wakin yaĉhakuqninkunata chapar, Pedrutaqa kaynu nir anyaran: —¡Ashuy naypaymantaqa dyablu! Qamqami Dyus munashantaqa mana intrakar, yanqa runakuna yarpushannula rurachimanayanki nir. ");
INSERT INTO qufNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Chaymanta Jesusqa yaĉhakuqninkunata chaynulla chaypi kaqkunata qayamur kaynu niran: “Mayqanpis nuqapa yaĉhakuqniy kanarqami amana bidanllapapaqqa llakinqallapanachu. Ashwanmi kruspi wanuchinatinllapamapis ama manchakurchu nuqalapi yarpur shachinakunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Chaqa mayqanpis paykuna munashannulla bidanta washayta kamaqkunaqami tukuy tyimpupaqna qischakanqallapa. Piru mayqanpis nuqapi kriyishanrayku chaynulla shumaq rimayniyta yaĉhachikushanrayku qischakar wanuqkunaqami tukuy tyimpupaqna kawsanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Chaymi nishaykillapa: Mayqanpis kay pachapi kaq iman munashanta tantakur mana washakatinqa, ¿imapaqtaq sirbiyan chay tantakushanqa? ");
INSERT INTO qufNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Uk runachu achka imata pagrakur washakayta puytinman? ¡Manami! ");
INSERT INTO qufNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Piru mayqanpis nuqamanta chaynulla rimayniymanta ima kay mana kriyishanrayku kusala uchasapa runakunapa naypanpi pinqakutinqami, Dyusmanta Shamuq Runapis Taytanpa kusa llipyalla pudirninwan shamurqa, kusa allinla angelkunapa naypanpimapis pinqakunqa”. ");
INSERT INTO qufNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Chaynullami Jesusqa niranpis: —Chiqaptami nishaykillapa: Kaypi kawsaqkunaqa wakinllaqa Dyus kusa pudirninwan mantakuqtaqa rikanqallapa manaraq wanuyarchu nir. ");
INSERT INTO qufNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Chaymanta saysi diyakuna pasashana katinqa, Jesusqa kusa unaq sirkaman riran, Pedruta, Santiaguta, Juanta ima, paykunalata apar. Chaymi chay kimsa yaĉhakuqninkunapa naypanpi Jesuspa qaqllanqa, kusala ukman shumaqpaq tikrakaran. ");
INSERT INTO qufNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Chaynulla raĉhpanmapis kusala yuraq llipya intirupaq tikrakaran. Chaqa manami mayqanpis raĉhpata kusalata paqarmapis chaynu yuraqchayanqachu. ");
INSERT INTO qufNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Chaymi yaĉhakuqninkunaqa rikaranllapa Jesusta, Eliaswan, Moiseswan ima parlaqta. ");
INSERT INTO qufNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Chaynu rikarqami paykunaqa kusalata manchakuranllapa. Chaymi Pedruqa kusa manchakushalla mana imata nishaq nir yaĉharchu, kaynu niran Jesustaqa: —Yaĉhachikuq Taytituy, ¡kaypiqami kusala allin kanchikllapa! Rurashaqllapa kimsa chukllitakunata, ukta qampaq, ukta Moisespaq, ukta-shuypaqa Eliaspaq nir. ");
INSERT INTO qufNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Chaykamanqami, puktay limpu paykunata pampar pasayaran. Piru chay puktay rurimantami Dyus kaynu niyaran: ");
INSERT INTO qufNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Chaymi chay kutilla tukuy ladunman chapakurqa, manana mayqantapis rikaranllapanachu. Ashwanmi Jesusta paylatana rikaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Chaymanta chay unaq sirkamanta ishkimuyatinllapanaqa Jesusqa yaĉhakuqninkunata kaynu niran: —Amami mayqantapis parlankillapachu chay rikashaykillapataqa, Dyusmanta Shamuq Runa wanur kawsamunankaman nir. ");
INSERT INTO qufNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Chaymi paykunaqa mana mayqantapis parlaranllapachu, michka paykuna chay “Wanur kawsamushaq” nishanpaq mana intrakasha karmapis. Chaynu mana intrakashanllaparaykumi kusalata tapunakuyaqllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Chaymi Jesustaqa kaynu nir tapuranllapa: —Chaynu katinqa, ¿imapaqtaq Moisés mantakushanta yaĉhar yaĉhachikuqkunaqa, Eliasraqshi Dyuspa Akrashan Cristunmanta naypaqtaqa shamuyanqa ninllapa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesusqa paykunataqa niran: —Chiqaptami Elías naypaqtaqa shamuyanqa. Chaynu shamurmi tukuy imata Dyus munashanulla shumaqchayanqa. Chaqa, ¿imapaqtaq Dyus nitin iskribikashakunapiqa nin: ‘Dyusmanta Shamuq Runataqashi ĉhiqnir kusalata qischayanqallapa?’ nirqa. ");
INSERT INTO qufNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Chaymi nishaykillapa: Eliasqami shamushana. Chaynu shamutinmi, Dyus nitin iskribikashannulla mana kwintacharchu paykuna munashannulla ruraranllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Chaymanta Jesusqa chay kimsa yaĉhakuqninwan tikrakamurqa, chay wakin yaĉhakuqninkunataqa kusala achka runakunawan tariran. Chaypiqami karan Moisés mantakushanta wakin yaĉhar yaĉhachikuq runakuna ima. Chaymi paykunaqa Jesuspa yaĉhakuqninkunawan kusalata willanakuyashallapa karan. Chaykamanmi Jesusqa ĉhamuran. ");
INSERT INTO qufNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Chaynu Jesús ĉhamutin rikarmi tukuyla chay runakunaqa kusa dispantakashalla kallparanllapa Jesusta saludaq. ");
INSERT INTO qufNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Chaymi Jesusqa yaĉhakuqninkunata niran: —¿Imapaqtaq paykunawan kusalata willanakuyaraykillapa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Chaypi kaqkunamanta ukqami niran: —Yaĉhachikuq Taytituy, wamraytami apamusha kani qamman. Chaqa dyablupa yarpuyninmi limpu muduchar dijasha. ");
INSERT INTO qufNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Chaymi maypi katinpis dyablupa yarpuyninqa wamraytaqa atakita qur usuraqtana dijan. Chaynulla shiminmanta kusalata pusquta itakuchir, kirunmatapis kusalata richyachir ima wanushata yupayna dijan. Chaymi chay yaĉhakuqnikikunata mañakuray dyablupa yarpuynintaqa itakunanpaq. Piru manami puytishallapachu nir. ");
INSERT INTO qufNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesusqa niran: —¡Ay qamkuna Dyuspi mana allita kriyiqkuna! ¿Maydiyakamantaq allita intrachishunayllapapaq qischakashaq? ¿Ima maydiyakamantaq qamkunawan shachinakushaq? Ma, kayman apamuyllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Chaymi chay wamrataqa Jesusman aparanllapa. Chaynu apatinllapaqa, chay dyablupa yarpuyninqa Jesusta rikarqa, wamrata atakita qur pachaman ratachir ribulkachiran, shiminmanta pusquta itakuchiran ima. ");
INSERT INTO qufNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Chaymi Jesusqa wamrapa taytantaqa kaynu nir tapuran: —¿Ima tyimpumanta-pachataq wamraykiqa waknu qischakan? nir. Taytanqa niran: —Takshitunmanta-pacha. ");
INSERT INTO qufNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Chaymi wak dyablupa yarpuyninqa kutir kutir ninaman, yakuman ima itasha wanuchinanpaq. Chayraykumi puytiq yupay karqa, llakipar yanapamayllapari nir. ");
INSERT INTO qufNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Chaynu nitinmi Jesusqa niran: —¿Imaraykutaq puytiq yupay karqa yanapamayllapari nimanki? Chaqa tukuy kriyiqkunapaqqami imapis ruraypaq nir. ");
INSERT INTO qufNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Chaynu nitinmi chay wamrapa taytanqa kusala jwirtita kaynu nir qayĉhakuran: —Nuqaqami kriyini, Taytituy. Ashwan ¡yanapamay-ari masna kriyinaypaq! nir. ");
INSERT INTO qufNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Chaymantami Jesusqa kusala achka runakuna tantakamuqta rikarqa, chay dyablupa yarpuyninta kaynu nir anyaranna: —Muduchakuq chaynulla upachakuq dyablupa yarpuynin, nuqami mantashuni kay wamramantaqa lluqshir, amana qashanqa yaykunkinachu nir. ");
INSERT INTO qufNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Chaynu nitinmi, chay dyablupa yarpuyninqa wamrataqa qashan atakita qur, pachaman ratachir wanushata yupay dijar lluqshiranna. Chaymi rikaqkunaqa niyaranllapa: “Ashwanmi wamraqa wanunna” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Piru Jesusqami wamrataqa makinmanta chutar sharichimuran. Chaymi ashwan wamraqa sharanna. ");
INSERT INTO qufNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Chaymantami Jesusqa uk wasiman yaykuran. Chaypimi yaĉhakuqninkunaqa paylata kaynu nir tapuranllapa: —¿Imaraykutaq chay dyablupa yarpuynintaqa mana itakuyta puytisha kashaqllapaqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesusqami niran paykunataqa: —Waknu riqchaq dyablupa yarpuynintaqami mana chaynulaqa uk runamantaqa itakunchikchu. Ashwanmi ayunar Dyusman kusalata mañakur ima itakuyta puytinchik nir. ");
INSERT INTO qufNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Chaymanta, Jesusqa yaĉhakuqninkunawan rirqa pasaran Galilea pwiblupa lugarninkunata. Piru payqami mana munaranchu mayqanpis mayta risha nir yaĉhananllapataqa. Chaqa yaĉhakuqninkunatami kaynu nir yaĉhachiyaran: “Dyusmanta Shamuq Runatami kuntrankunaman qukuyanqallapa. Chaynu qukutinllapami wanuchinqallapa. Piru kimsa diyamantaqami qashan kawsamunqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Chaynu nir willatinmi yaĉhakuqninkunaqa mana intrakaranllapachu. Chaynulla tapunanllapapaqmapis kusalatari manchakuyaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Chaymantami Capernaúm pwibluman ĉharnaqa, uk wasiman yaykuranllapa. Chaymi Jesusqa yaĉhakuqninkunata kaynu nir tapuran: —¿Imanirtaq qamkunaqa nanpi willanakuyaraykillapa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Piru paykunaqami pinqakur mana imatapis nirchu uyarala kidaranllapa. Chaqa nanpiqami willanakusha karanllapa, mayqanninllapashi kusa mas allin kanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Chaymantami Jesusqa taran. Chaymi dusi yaĉhakuqninkunata qayar, kaynu niran: —Mayqanpis kusa kayta munaqqami mana kwintachaypaqla tikrakar, uk sirbikuq yupay kar wakinninllapatana yanapanmanllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Chaynu nirmi, uk wamrituta paykunapa ĉhaypinman apar, marqakur kaynu niran: ");
INSERT INTO qufNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Mayqanpis nuqapi kriyishanrayku kay wamritu yupay kaqta, shumaqta samachiqqami, ashwan nuqallatana samachimayan. Piru manami nuqalatachu samachimayan, ashwanmi chay mayqanĉhi kaĉhamasha chaytapis samachiyan nir. ");
INSERT INTO qufNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Chaymantami yaĉhakuqnin Juanqa niran: —Yaĉhachikuq Taytituy rikashami kanillapa uk runata qampa shutikiwan dyablupa yarpuyninkunata runakunamanta itakuqta. Chaymi paytaqa nirayllapa ama chayta ruraychu nir. Chaqa chay runaqa mana nuqanchikkunawanqa purinchu. ");
INSERT INTO qufNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Chaynu nitinmi Jesusqa niran: —Ama ‘Mana’ niyllapachu. Chaqa mayqanpis nuqapa shutiywan milagruta rurayarqa, manami chay kutilla kuntray rimayta puytiyanqachu. ");
INSERT INTO qufNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ashwanmi nuqanchikpa mana kuntranchik karqa, nuqanchikpa faburninchik kanqa. ");
INSERT INTO qufNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Chiqaptami nishaykillapa: Mayqanpis qamkunata nuqapi kriyishaykillaparayku uk jarru yakituta upyachishuqllapaqami, kusa shumaq allin imakunatana aypanqallapa Dyusmantaqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Piru nuqapi kriyishanrayku mana kwintachaypaqla kay taksha wamrituykuna yupay kaqkunata uchakuchiqkunataqami, kusala allin kanman kunkanpi uk marayta watar, mar yakupa mas ruri kaqninman itakunanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Imanupi makiki uchakuchishutinmaqa, pitir itakuy. Chaqa allinmi kanqa kwirpuykipa uk partin kaqta itakunaykipaq tukuyla kwirpuyki tukuy tyimpupaq chay infyirnupi nina maydiyapis mana wanuqpi qischakanaykimantaqa. ");
INSERT INTO qufNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","48","Chaynulla ĉhakiki uchakuchishutinqa, pitir itakuy. Chaqa allinmi kanqa kuju, tukuy tyimpupaqna kawsanaykipaq, ishkantin ĉhakikiwan infyirnumanna itakukanaykimantaqa. Chaynullami nawiki uchakuchishutinpis, urqur itakuy. Chaqa allinmi kanqa uk nawiyjunla, Dyus mantakuyashanman yaykunaykipaq, ishkantin nawikiwan infyirnuman itakukanaykimantaqa. Chaqa chaypiqami ñushi chaynulla ninamapis maydiyapis mana wanunchu. ");
INSERT INTO qufNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Chaymi chaypiqa imanutaq aychamataqa kaĉhiwan salanchik chaynu ninawan kusalata qischakankillapa. ");
INSERT INTO qufNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Chayraykumi qamkunapis kay pachapiqa imanutaq kaĉhimaqa kusalata sirbin chaynu kar uknikillapa uknikillapa kusa shumaqta kawsayllapa. Chaqa uk kaĉhi lampaqyatinqa, ¿imanunari qamkunaqa qashan shumaqchankillapa? ");
INSERT INTO qufNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesusqami chay Capernaúm pwiblumanta lluqshir rir, Judeapa lugarninkunaman ĉharan. Chaymanta rirmi, riyu Jordanpa chimpanmanna ĉharan. Chaymi chaymanpis kusala achka runakuna tantakamutin Jesusqa yaĉhachiran imanutaq yaĉhachikuq chaynulla. ");
INSERT INTO qufNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Chaymantami wakin fariseo runakuna Jesusman qimikaranllapa. Chaymi mabir imanimashunllapashi nir, kaynu tapuranllapa: —¿Allinchu kanqa uk runa warminta dijananpaqqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Chaymi Jesusqa niran: —¿Ima nirtaq Moisesqa mantashuranllapa? ");
INSERT INTO qufNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Paykunaqa niran: —Moisesmi niran, uk runa warminta dijanarqashi karguyjunkunapi kartata rurar warminta qurqashi chiqanchakayta puytin nir. ");
INSERT INTO qufNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Chaynu nitinllapaqa Jesusqa paykunata niran: —Qamkuna kusala kuchi mana intrakaq kashaykillaparaykumi Moisesqa chaynuqa mantakuran. ");
INSERT INTO qufNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Piru Dyusqami puntamanta-pacha runata, warmita ruraran. ");
INSERT INTO qufNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Chayraykumi, ‘Uk runa warminwan kasararqa, taytanta mamanta dijanqa. ");
INSERT INTO qufNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Chaymi ashwan warminwanqa uk kwirpu yupaylana kawsanqallapa’ nir. Chaynuqami mana ishkaynachu, ashwan uklana. ");
INSERT INTO qufNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Chayraykumi uk runa warminwan uk kwirpulana kananpaq Dyus nishanrayku, mana mayqanpis, paykunaqa dijanakunqa niyta puytinchu. ");
INSERT INTO qufNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Chaymanta Jesusqa wasipina katinqa, yaĉhakuqninkunaqa chay yaĉhachikushanpaq tapuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesusqa niran: “Mayqanpis warminta dijar qashan ukwan kasararqami kusala saqratana uchakuyan. ");
INSERT INTO qufNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Chaynulla warmipis runanta dijar, ukwan kasararqa kusala saqratana uchakuyan, punta runanta dijashanrayku” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Chaymantami Jesusmanqa wamrakunata apamuranllapa, bindisinanpaq. Piru yaĉhakuqninkunaqami chay wamrakunata apamuqkunataqa anyaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Chayta rikarmi, Jesusqa piñakur yaĉhakuqninkunataqa niran: “¡Ama arkarchu, dijay nuqaman shamunqa wamritukunaqa! Chaqa Dyus mantakuyashanqami kay wamritukuna yupay kaqkunalapaq. ");
INSERT INTO qufNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Chiqaptami nishaykillapa: Dyus mantakuyashanman yaykunaqkunaqami kay wamritukuna yupay kanqallapa. Chaqa mana chaynu karqami Dyus mantakuyashanmanqa mana yaykunqallapachu”. ");
INSERT INTO qufNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Chaynu nirnaqami wamritukunata, marqakur makinkunata ananman ĉhurar bindisiran. ");
INSERT INTO qufNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Chaymanta Jesús riyatinnaqa uk runa kallpar shamur naypalanpi qunqurikur kaynu nir tapuran: —Kusa allinla yaĉhachikuq taytituy, ¿imatataq rurayman, tukuy tyimpupaqna kawsanaypaqqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Chaymi Jesusqa niran: —¿Imapaqtaq kusa allin nimanki? Allinla kaqqami kan ukla. Payqami Taytay Dyus. ");
INSERT INTO qufNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Chaqa qamqami Dyus mantakushankunataqa yaĉhankina. Chaypiqami nin: ‘Ama uk uk warmiwan kaychu; ama wanuchikuychu; ama suwakuychu; ama uknikipaq llullakur rimaychu; ama uknikita imapipis llullachiychu chaynulla taytaykita, mamaykita kasuy’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Chaynu nitinmi, chay runaqa niran: —Yaĉhachikuq Taytituy, tukuy chaykunataqami takshaymanta-pacha rurashana kani nir. ");
INSERT INTO qufNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Chaymi Jesusqa chapar kusalata llakipar, niran: —Uksitumi faltashuyan ruranaykipaqqa: Rir, tukuy imayki kaqta rantikur qillaynikitaqa mana imayjun kaqkunata quy. Chaynuqami unaq syilupiqa mana tukukaq imaykitana tarikunki. Piru chay nishushayta rurarnaqami, shamutki nuqawanna rishun nir. ");
INSERT INTO qufNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Chaynu Jesús nitinmi, chay runaqa kusalata llakir riran. Chaqa kusala imayjun-ari karan. ");
INSERT INTO qufNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Chaymi Jesusqa, ridurninman chapakur yaĉhakuqninkunataqa kaynu niran: —Kusa trabajusuraq kanqa chay kusala imayjun kaqkuna, Dyus mantakuyashanman yaykunanpaqqa. ");
INSERT INTO qufNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Chaynu nitin uyaparmi, yaĉhakuqninkunaqa kusata yarpupakuranllapa: “¿Imanutaq chaynuqa kanqa?” nir. Chaymi Jesusqa qashan niran: —Wamrituykuna ¡kusala trabajusumi Dyus mantakuyashanman mayqanpis yaykunanpaqqa! ");
INSERT INTO qufNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Chaymi chay kusala imayjunkuna, Dyus mantakuyashanman dasla yaykunanmantaqami, ashwan uk kamillu dasla pasayta puytinman uk awjapa uĉhkitunta nir. ");
INSERT INTO qufNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Chaynu nitin uyaparmi kusala masta yarpupakuranllapa. Chaymi ukninllapa ukninllapa kaynu nir tapunakuyaqllapa: —Chaynu katinqa ¿pitaq washakayta puytiyanqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Chaynu nitinmi Jesusqa paykunata chapar kaynu niran: —Runakunapaqqami kayqa mana ruraypaqchu. Piru Dyuspaq-shuypaqami tukuy imapis ruraypaq nir. ");
INSERT INTO qufNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Chaynu nitinqa, Pedruqa kaynu niq qallariran: —Nuqakunamaqami tukuy imayllapakunata dijashana, qamwanna purinillapa. ");
INSERT INTO qufNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesusqa niran: —Chiqaptami nishaykillapa: Mayqanpis nuqarayku, chaynulla washakananllapapaq yaĉhachikushanrayku wasinta, ullqu ukninkunata, warmi ukninkunata, taytanta, mamanta, warminta, wamrankunata, ĉhakrankunata dijar nuqa munashayta ruraqkunaqami, ");
INSERT INTO qufNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kay pachapiqa syin kuti mas achkatana, wasikunata, ullqu ukninkunata, warmi ukninkunata, taytanta, mamanta, wamrankunata, ĉhakrankunata ima aypanqallapa michka kusalata qischakar imamapis. Nataq maydiya-shuypaqa ashwan tukuy tyimpupaq kawsaytana aypanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Piru kanan tyimpukunapi achka runakuna kusana kaqkunaqami, chay tyimpuqa mana imapaqpis sirbinqachu. Chaynulla achka kanan tyimpukuna mana kwintachaypaq kaqkunami, ashwan chay tyimpuqa kusa nishapaqna riqsikanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Chaymantami Jesusqa yaĉhakuqninkunawan Jerusalenman riq qallaritinllapa, payqa yaĉhakuqninkunapa naypanta riyaran. Piru yaĉhakuqninkunaqami kusa dispantakashalla riyaranllapa. Nataq chay wakinkuna ikita riqkuna-shuypaqa kusalata manchakur ima riyaranllapa. Chaymi Jesusqa dusi yaĉhakuqninkunata qayar uklawman apar, qashan kaynu nir willayaran: ");
INSERT INTO qufNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Qamkuna rikayashaykillapanumi kananqa riyanchikllapana Jerusalenman. Chaypimi Dyusmanta Shamuq Runataqa qukunqallapa, kurakunapa mantakuqninkunaman, Moisés mantakushanta yaĉhar yaĉhachikuqkunaman ima. Chaymi ashwan paykunaqa wanuchinanllapapaq nir mantakur, mana Israelmanta runakunamanna qukunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Chaymi paykunaqa kusalata burlakar, tuqapar, wipyar imanaqa wanuchinqallapa. Piru kimsa diyamantaqami qashan kawsamunqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Chaymantami Zebedeupa wamrankuna Santiaguwan Juanqa, Jesusman qimikar kaynu niranllapa: —Yaĉhachikuq Taytituy, mañashayki uk faburta ruramanaykillapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesusqa niran: —¿Imatataq qamkunapaq ruranayta munayankillapa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Paykunaqa niran: —Imaraq taytituy, qam chay kusala shumaq mantakuynikipi mantakurqami, qam nitki ukniyllapaqa allilaw qichqaykipi tanqa; nataq ukniyllapa-shuypaqa ichuqlaw qichqaykipina nir. ");
INSERT INTO qufNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Chaynu nitinmi Jesusqa paykunataqa niran: —Manami qamkunaqa imata mañakuyankillapa nirmapis yaĉhankillapachu. Tapushaykillapa: ¿Kusala saqra ayaq yakuta upyaq yupay qischakar wanuyashaq, chaynu qischakaytachu puytiyankillapa kanqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Chaymi paykunaqa niran: —Arí Taytituy nir. Chaymi Jesusqa niran: —Chiqaptami qamkunapis kusalata qischakankillapa, nuqa qischakashaynulla. ");
INSERT INTO qufNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Piru chay mantakunaypi tar allilawpi manaqa chay ichuqlaw qichqaypi tachishunayllapapaqqami mana nuqaqa yaĉhanichu. Ashwanmi chay mayqanpaqĉhi chaykunaqa kamakasha chaykunanami chaypiqa tayanqallapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Piru chay wakin dyis kaq yaĉhakuqninkunaqami, chaynu nir mañakuqta uyaparqa piñakuranllapa Santiaguwan Juanwan imaqa. ");
INSERT INTO qufNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Chaymi Jesusqa paykunata qayamur niran: —Qamkuna yaĉhashaykillapanu, chay mana Israel runakunapa mantakuqninkunaqami, chay pwiblunmanta kaq runakunataqa paykuna munashanlata rurachin. Chaynu katinmi ashwan chay pwiblupi kusa runa nisha kaqmaqa, wakinkunata mantarla ima kawsanllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Piru qamkunapiqami ama chaynuqa pasanmanchu. Ashwanmi chay qamkunamanta mayqannikillapa kusa runa nisha kaqqa, uk sirbikuq yupay kar wakinnikillapata yanapankimanllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Chayraykumi qamkunamanta uknikillapa kusa kayta munarqa, tukuypa sirbiqninna kayllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Chaqa Dyusmanta Shamuq Runamaqami sirbikuq shamuran mana payta sirbinanllapapaqchu. Chaymi ashwan kusala achka runakunata uchanmanta washananrayku, wanunqa. ");
INSERT INTO qufNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Chaymantami ĉharanllapa Jericó pwiblumanna. Chaymanta chay pwiblumanta lluqshir yaĉhakuqninkunawan chaynulla kusala achka runakunawan ima riyatinllapami nan qichqalanpi uk syigu runa Bartimeo shutiq tayasha karan, limusnata mañakur. Payqami Timeupa wamran karan. ");
INSERT INTO qufNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Chaymi Nazaretmanta Jesús pasaqta uyaparqa chay syiguqa, kaynu nir qayĉhakuran: —¡Davidpa ayllun Jesús! ¡Llakipamastuy-ari! nir. ");
INSERT INTO qufNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Chaynu nitinmi, runakunaqa anyaranllapa upallananpaq. Piru payqami llallin kaynu nir qayĉhakuran: —¡Davidpa ayllun Jesús! ¡Llakipamastuy-ari! nir. ");
INSERT INTO qufNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Chaymi Jesusqa chaypi shar, kaynu niran: —Qayamuyllapa chay runataqa nir. Chaymi kaynu nir qayamuranllapa: —Aligriyakur, sharir shamuy. Jesusmi qayashuyan nir. ");
INSERT INTO qufNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Chaynu nitinllapami, chay runaqa qatakuna raĉhpanta urqur itakur, piryar rir Jesusman qimikaran. ");
INSERT INTO qufNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Chaymi Jesusqa tapuran: —¿Imatataq qampaq ruranayta munayanki? nir. Payqa niran: —Yaĉhachikuq Taytituy, nawiy rikakunantami munayani nir. ");
INSERT INTO qufNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesusqa niran: —Rikuyna. Chaqa kriyishaykiraykumi alliyashaykina. Chaynu nitinmi chay kutilla rikakuranna. Chaymi ashwan kusalata aligriyar Jesuspa pullanna riran. ");
INSERT INTO qufNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jesusqami yaĉhakuqninkunawan Jerusalenman riyar, yaqqa ĉhayarnaqa, Betfagé chaynulla Betania pwiblupa shipchankaqman ĉharanllapa. Kay pwiblukunaqami chay Olivos sirkapaqa shipchanlapi karan. Chaymi chaypi karnaqa Jesusqa ishkay yaĉhakuqninkunata qayamur, ");
INSERT INTO qufNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","kaynu nir kaĉharan: —Riyllapa wak naypanchikpi pwiblitu chayman. Chayman ĉharqami uk burru wataraqta tarinkillapa. Chay burrupiqami mana mayqanpis tasharaqchu. Chaymi kaĉhar apamunkillapa. ");
INSERT INTO qufNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Piru mayqan imallata willashutinllapaqa ninkillapa: ‘Taytitunchikmi ministiyan, daskaqlami kaĉhamunqa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Chaynu nitin, rirqami kallipi punku yatankaqpi wataraqta burrutaqa tariranllapa. Chaymi kaĉharanllapa apamunanpaq. ");
INSERT INTO qufNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Piru wakin chaypi kaqkunami kaynu nir tapuranllapa: —¿Imapaqtaq burruta kaĉhayankillapa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Chaymi paykunaqa Jesús willashannulla nitinllapa, dijatinna aparanllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Chaymi burrutaqa Jesusman apar raĉhpankunata ananman ĉhuratinllapa Jesusqa anan taranna. ");
INSERT INTO qufNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Piru chaypiqami karan kusala achka runakuna. Chaymi Jesús riyashanlawmanqa wakinqa raĉhpanllapata ĉhukiranllapa. Nataq wakin-shuypaqami qirupa raprankunata kuchumur ĉhukiranllapa, chaypa ananlata Jesusqa pasananpaq. ");
INSERT INTO qufNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Chaymi ashwan naypaqta ikita riqkunamapis kusa aligrila kaynu nir laqyayaqllapa: “¡Biba biba! ¡Kusa alabakashami kanqa Taytanchik Dyuspa shutinpi shamuqqa! ");
INSERT INTO qufNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Chaynulla kusa alabakashami kanqa Davidpa ayllunmanta shamuq gubyirnunchikllapaqa! ¡Payqami unaq syilupipis kusa alabakashana kanqa!” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Chaynu rirmi Jesusqa ĉharan Jerusalenmanqa. Chaymanta rir yaykuran Dyusta adurananllapa wasiman. Chaynu yaykurmi tukuy chay ruripi kaqkunata alli rikaran. Chaymantami yaĉhakuqninkunawan riranna Betania pwibluman. Chaqa kusa tardinari karan. ");
INSERT INTO qufNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Allaqninqami Betania pwiblumanta riyarqa Jesusqa mallaqnaran. ");
INSERT INTO qufNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Piru largukaqpimi rikaran uk igus qiru kusa raprayjunta. Chaymi rir ĉharan, puquyninpismi kanqa nir yarpur. Piru ashwanmi rapranlata tariran, mana puquyniyjuntachu. Chaqa manari puqunan tyimpuraqchu karan. ");
INSERT INTO qufNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Chayraykumi, chay igus qirutaqa kaynu niran: “¡Kaymantaqami manana mayqanpis puquynikitaqa mikunqallapanachu!” nir. Chaynu nitinmi chay yaĉhakuqninkunaqa uyaparanllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Chaymantami Jerusalenman qashan ĉhamur, Jesusqa, Dyusta adurananllapa wasiman yaykur, chaypi rantikuqkunata, rantiqkunata ima limpu waqtaman itakuq ĉhurakaran. Chaynumi chay uklawmanta kaq qillayta kambyaqkunapa misanta, chaynulla palumata rantikuqkunapa misanmatapis limpu tikrar itakuran. ");
INSERT INTO qufNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Chaymi payqa mana munaranchu mayqanpis imankunata charikur ima Dyusta adurananllapa wasiman yaykur pasananllapataqa. ");
INSERT INTO qufNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Chaymi ashwan kaynu nir yaĉhachiq qallariran: “Dyus nitin iskribikashakunapiqami nin: ‘Wasiyqami tukuy nasyunmanta runakuna nuqaman mañakunanllapalapaq wasi shutinqa’ nir. Piru qamkunaqami suwakuqkunapa maĉhayninpaqna tikrashaykillapa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Chaynu nitin uyaparmi chay kurakunapa mantaqninkuna, chaynulla Moisés mantakushanta yaĉhar yaĉhachikuqkuna imaqa, yarpuranllapa imanullapis Jesusta wanuchinanllapapaq. Piru mana puytiranllapachu runakunata manchashanllaparayku. Chaqa tukuyla runakunari yaĉhachikutinqa kusa dispantakashalla uyakuyaqllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Chaymanta tutapayatinnaqami Jesusqa yaĉhakuqninkunawan chay Jerusalenmanta lluqshir riranllapana. ");
INSERT INTO qufNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Allaqmanta qashan riyarmi, chay igus qirupa yatanlata pasayar, rikaranllapa limpu ĉhupanmanta-pacha chakishatana. ");
INSERT INTO qufNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Chaymi Pedruqa, Jesús chay igus qiruta willashanpaq yarpur kaynu niran: —Yaĉhachikuq Taytituy, rikay chay igus qiruta amana maydiyapis puqunanpaq nishaykiqami chakishana nir. ");
INSERT INTO qufNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Chaynu nitinmi Jesusqa paykunata niran: —Allita Dyuspi kriyiyllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Chiqaptami nishaykillapa: Mayqanpis Tayta Dyuspi tukuy shunqunwan kusalata kunfyakar ama ukmanta yarpurchu, kay qaqata ‘Kaymanta ashur rir mar yakuman yaykuy’ nitinllapaqa, chaynu pasayanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Chayraykumi nishaykillapa: Qamkuna Tayta Dyusman mañakurqa kusalata kunfyakar, chay imataĉhi mañakuyashaytaqa qumayanqa nir mañakuyllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Piru Dyusman mañakurqa, pirdunayllapa mana allinkunata rurashuqkunata. Chaynuqami syilumanta Taytaykillapa Dyusqa uchaykillapamantaqa pirdunashunqallapa.  ");
INSERT INTO qufNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Piru qamkuna ukkunata mana pirdunatkillapaqa, syilumanta Taytaykillapa Dyuspis uchakushaykillapamantaqa mana pirdunashunqallapachu. ");
INSERT INTO qufNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Chaymantaqami Jerusalén pwibluman ĉhar, Jesusqa Dyusta adurananllapa wasi ruripi puriyatin, chay kurakunapa mantaqninkuna, Moisés mantakushanta yaĉhar yaĉhachikuqkuna, Israel pwiblupa ruku mantaqninkuna ima payman qimikaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Chaymi kaynu nir tapuranllapa: —¿Mayqan mantashutintaq tukuy chaykunata rurankiqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Chaymi, Jesusqa niran: —¡Ma nuqapis tapushutiyllapa willamayllapa! ¿Mayqantaq Shutichikuq Juantaqa kaĉhamuran shutichikunanpaqqa? ¿Dyus, manaqachu runakunala? Qamkuna chay tapushushayta willamatkillapami, nuqapis willashaykillapa mayqan mantamatinmi kayta rurani nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Chaynu nitinmi, paynin paynin willanakur kaynu ninakuyaqllapa: “ ‘Dyusmi kaĉhamuran’ niytaqa manami puytinchikllapachu. Chaqa, chaynu nishallapaqa ‘¿Imapaqtaq mana kriyiraykillapa?’ nimashunllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Nataq ‘Runakunalami kaĉhamuran’ nishallapaqa, ¿imataq pasanqa?” Piru manami chaynu niytaqa puytiranllapachu, runakunata manchashanllaparayku. Chaqa tukuylari kriyiqllapa Juanqashi Dyuspa chiqap rimaqnin karan nir. ");
INSERT INTO qufNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Chaymi, Jesustaqa niranllapa: —Manami yaĉhanillapachu nir. Jesuspis paykunataqa niran: —Chayqa nuqapis manami willashaykillapachu, mayqan mantamatinmi tukuy kaykunata rurani nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Chaymantami Jesusqa kumparasyunkunawan yaĉhachikuq qallariran, kaynu nir: “Uk runami ĉhakranpi ubata tarpur, ridurninta limpu patyuta ruraran. Chaynullami ruraranpis uk quĉhata chaypi binuta lluqshichinanpaq. Chaynulla uk shuytulla kusala atun wasita yupay ruraran, chaypa ananman iqar chay ĉhakranta chapananpaq. Chaymantaqa ayka runakunata chay ĉhakranta arrintar riran largu mayta. ");
INSERT INTO qufNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Chaymanta kusicha tyimpu ĉhamutinqa, chay ĉhakrapa amunqa kaĉhamuran uk sirbikuqninta, chay kusichakushanmanta paypaq kaq partintaqa qunanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Piru chay ĉhakrapi kaqkunaqami chay sirbikuqtaqa aypar kusalata maqar ima, mana imatapis qurchu qatiĉharanllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Chaymantami chay ĉhakrapa amunqa qashan uk sirbikuqninta kaĉhamuran. Piru chayta-shuypaqami kusalata jurapar, rumillawan sitar umanmatapis lisyaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Chaymantami qashan kaĉhamuran ukta. Nataq chayta-shuypaqami aypar wanuchiranllapa. Chaymantami ukkunata kaĉhatin, wakintaqa kusalata maqar qischaranllapa. Nataq wakinta-shuypaqa wanuchiranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Piru tukukananta-shuypaqami kusala munashan wamrantana kaĉhamuran. Chaqa payqami kaynu yarpuran: ‘Wamrayta-shuypaqami kusalata rispitar kasunqallapa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Chayna wamranta kaĉhatin, chay ĉhakrapi kaqkuna rikarqa, ninakuranllapa: ‘Wakmi kay pachataqa irinsyanpaq aypayanqa. ¡Ashwan wanuchishunllapa nuqanchikkunana kay pachapa amunkunaqa kanallapapaq!’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Chaynu ninakurmi aypar wanuchir, ĉhakramantaqa urqurna itakuranllapa”. ");
INSERT INTO qufNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Chaynu nirqa kaynu nir tapukuran paykunataqa: “¿Chay ĉhakrapa amun shamurqa, chay ĉhakrapi kaqkunawanqa imatataq rurayanqa nir yarpunkillapa qamkunaqa? Chay ĉhakrapi kaqkunataqa rir limpu wanuchir ukkunatana quyanqa chay pachantaqa. ");
INSERT INTO qufNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Manachu qamkunaqa liyishaykillapa, Dyus nitin iskribikashantaqa? Chaqa ninmi: ‘Chay llutakuqkuna kay rumiqa mana sirbinchu nir itakushanllapami, ashwan kusala shumaq rumipaq tikrakasha. ");
INSERT INTO qufNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Piru tukuy chaynu kananpaqqa Dyusmi chaynuqa ruraran. Chaymi ashwan paylata alabashunllapa’ nir”. ");
INSERT INTO qufNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Chaynu nir Jesús kumparasyunta parlakutin chaypi kaq runakuna uyaparqa, kwintata qukaranllapa paykunapaq rimayan nir. Chaymi Jesusta aypar prisunaranllapa. Piru mana puytiranllapachu runakunata manchashanllaparayku. Chaymi ashwan dijatinllapana riran. ");
INSERT INTO qufNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Chaymantami chay fariseo runakunaqa wakinninta chaynulla Herodespa wakinninta ima kaĉharanllapa rir, Jesusta tapur mana allinta rimachir, chaylapaqna uchachananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Chaymi paykunaqa Jesusman rir kaynu nir tapuranllapa: —Yaĉhachikuq Taytituy, yaĉhanillapami qamqa Dyus munashannulla chiqapta rimar yaĉhachikunkimapis. Chaynullami runakuna ima nitinpis qamqa mana kwintacharchu yaĉhachikunki. Chaqa qamqami mana runakunawan allinpi kanaykipaqchu yaĉhachikunkimapis. Piru, ¿allinchu kanqa impwistuta chay Roma pwiblupi mantakuq Cesarta, pagranayllapapaq, manaqachu mana? Ima nimankillapataq, ¿pagrashaqllapachu manaqachu mana? nir. ");
INSERT INTO qufNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Piru Jesusqami kaykunaqa Dyusta yanqa kasuq tukuq, kuchi runakunala nir yaĉhayashanrayku, kaynu niran: —¿Imapaqtaq mana allinta rimachir uchachamanayankillapaqa? Ma, apamuyllapa uk qillayta rikanaypaq nir. ");
INSERT INTO qufNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Chaymi apamuranllapa uk qillayta. Chayna Jesusqa paykunata tapuran: —¿Mayqanpa ritratuntaq kay qillaypiqa? ¿Mayqanpa shutintaq iskribikasha? nir. Paykunaqa niranllapa: —Gubyirnu Cesarpa nir. ");
INSERT INTO qufNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Chaymi Jesusqa niran: —Chaynu katinqa, gubyirnu Cesarpa kaqnintaqa payta quyllapa. Nataq Dyuspa kaqninta-shuypaqa Dyusta quyllapa nir. Chaynu nitinmi kusa dispantakashalla kidaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Chaymantami wakin saduceo runakuna riranllapa Jesusta rikaq. Chaqa chay runakunaqami ninllapa: “Manashi wanuqkunaqa qashanqa kawsamunllapachu” nir. Chayraykumi Jesustaqa kaynu tapuranllapa: ");
INSERT INTO qufNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Yaĉhachikuq Taytituy, Moisesmi kaynu nir iskribiran: ‘Mayqan warmiyjun kayar, manaraq wamrayjun kar wanutinqa, chay wanushapa ukninnashi kasarayanqa chay byuda warmiwanqa. Chayna chay wanusha ukninpaqqa wamrayjun kananpaq’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Chaynu katinmi tapushaykillapa, uk kutimi syiti irmanukuna karanllapa. Kulakanllapami, warmikur manaraq wamrayjunchu kayar wanuran. ");
INSERT INTO qufNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Chaymantami chay ishkay kaq ukninna kasararan byudawanqa. Piru paypismi manaraq wamrayjunchu kayar wanuran. Chaynullami chay ishkay kaqwan, kimsa kaqwan pasaran, ");
INSERT INTO qufNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","chay syiti kaq ukninllapa kasarar wanunankaman. Piru mayqanninllapapis manami wamrayjunchu karan. Chaymantaqami chay warmipis wanuranna. ");
INSERT INTO qufNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Chayna chay wanushakuna maydiya kawsamutinqa, ¿mayqanninpa warmintaq kanqa chay warmiqa? Chaqa tukuynin-ari kasarasha karan chay warmillawan. ");
INSERT INTO qufNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Chaynu nitinllapami, Jesusqa niran: —Qamkunaqami limpu pantasha puriyankillapa, Dyus nitin iskribikashanpaq, chaynulla paypa pudirninpaq mana intrakashaykillaparayku. ");
INSERT INTO qufNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Chaqa maydiya chay wanushakuna kawsamurqami, manana kasaranqallapanachu, chaynulla manana kasarachikunqallapalamapischu. Chaymi ashwan imanutaq Dyuspa angelninkunamaqa mana kasaranllapachu chaynuna kawsanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nataq chay wanushakuna kawsamuqpaq-shuypaqa, ¿manachu qamkunaqa liyishaykillapa Dyus nitin Moisés iskribishantaqa? Chaqa chay sarsapi nina kusalata ratakuq rurimanta Dyusqa kaynu niq: ‘Nuqaqami Abrahampa, Isaacpa, Jacobupa Dyusnin kani’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Chayraykumi Tayta Dyusqa mana wanushakunapa Dyusninchu; ashwanmi tukuy kawsaqkunapa Dyusninla. Chaymi nishaykillapa: Qamkunaqami limpu limpu pantasha puriyankillapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Chaymantami Moisés mantakushanta uk yaĉhar yaĉhachikuq uyaparan Jesús, saduceo runakunata karanta willar uyarachiqta. Chaymi Jesusqa ima ninqashi nir, kaynu tapuran: —Yaĉhachikuq Taytituy, ¿tukuy mantakuykunamantaqa mayqannintaq kusa mas allinqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesusqa niran: —¡UYAKUYLLAPA ISRAEL RUNAKUNA! AMITUNCHIK TAYTA DYUSQAMI, PAYLA DYUSQA. Chaymi chay puntapi kaq kusala mas allin mantakuyqami nin: ");
INSERT INTO qufNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","‘Taytayki Dyusta munay tukuy shunquykiwan, bidaykiwan, yarpuynikiwan, jwirsaykiwan’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nataq chay ishkay kaq mantakuy-shuypaqami nin: ‘Llakiy runa masikikunapaq, imanutaq qampa kwirpuykillapaq llakinki chaynulla’ nir. Chaymi nishaykillapa: Tukuy wakin mantakuykunamantaqami kay ishkaykuna, kusala mas allinqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Chaynu Jesús nitinmi, chay yaĉhar yaĉhachikuq runaqa, niran: —Yaĉhachikuq Taytituy, tukuytami karanta nimashayki. Chaqa Dyusninchikqami payla. Manami uk masqa kanchu paymantaqa. ");
INSERT INTO qufNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Chaymi ashwan Dyusninchikta tukuy shunqunchikwan, yarpuyninchikwan, jwirsanchikwan munar chaynulla runa masinchikkunatapis imanuĉhi nuqanchikpa kwirpunchikta munanchik chaynulla munashanchikmi kusala mas allin, animalkunata chay altarman apar ufrindapaq nir rupachinallapamantaqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Chaynu chay runa kusala allinta rimashanraykumi Jesusqa kaynu niran: —Pitilanami faltashuyan Dyus nishankunata allita intrakar paywanna kawsanaykipaqqa nir. Chaymanta-pachami mana mayqanpis tapunanpaqqa yarpuranlamapischu. ");
INSERT INTO qufNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Chaymantami Jesusqa Dyusta adurananllapa wasipi yaĉhachikuyar kaynu nir tapukuran: “¿Imapaqtaq Moisés mantakushanta yaĉhar yaĉhachikuq runakunaqa ninllapa ‘Dyuspa Akrashan Cristunqami Davidpa ayllunmanta’ nirqa? ");
INSERT INTO qufNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Chaqa, Davidqami paylla Dyuspa Santu Ispiritun yanapatin, kaynu nisha karan: ‘Tayta Dyusmi, Amituytaqa kaynu niran: Tay allilaw qichqaypi, maydiya chay ĉhiqnishuqkunata ĉhakikipa ĉhakinman ĉhuranaykaman’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Piru willamayllapa: Davidpa ayllunmanta Dyuspa Akrashan Cristun katinqa, ¿imapaqtaq Davidqa ‘Amituy’ niran?” Chaynu nir Jesús yaĉhachikutinmi, chay achka runakunaqa kusa aligrila uyakuqllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesusqami yaĉhachikuqnuqa kaynu niran: “Allita kwintata qukarmi, kuytakankillapa Moisés mantakushanta yaĉhar yaĉhachikuqkunamanta. Chaqa paykunaqami munanllapa atun raĉhpanllapata yakakuyta, chaynulla plasakunapimapis kusala shumaqta saludananllapata ima. ");
INSERT INTO qufNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Chaymi chay tantakananllapa wasikunapi manaqa mikunanpaq apatinllapamapis, kusa runapaq riqsir chay kusala shumaq samanakunapi samachinanllapata munan. ");
INSERT INTO qufNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Chaynullami chay wakcha warmikunata kitanllapa wasinkunata ima. Piru allin runa ninanllapapaqqami kusala unayta Dyusman mañakuq yupay tukunllapa. Chaymi kusala manchaypaqtana kastigakanqallapa”. ");
INSERT INTO qufNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Uk diyapimi Jesusqa Dyusta adurananllapa wasipi kar, chay ufrindata tantananllapa kajunkunapa naypanpi taran. Chaymi payqa rikakutin, achka runakuna ufrindankunata itaqllapa chay kajunkunamanqa. Chaynullami achka kusa qillayniyjun runakunapis qillayninllapata itaqllapa chaymanqa. ");
INSERT INTO qufNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Chaymantami uk mana imayjun byuda ĉhamur, mana kusa achka ĉhaniyjun ishkay qillaysituta chay kajunkunamanqa itaran. ");
INSERT INTO qufNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Chaymi Jesusqa yaĉhakuqninkunata qayamur kaynu niran: —Chiqaptami nishaykillapa: Kay mana imayjun byudaqami tukuy runakuna qillayninta ĉhurayashanmantaqa mas achkata itasha kajunkunamanqa. ");
INSERT INTO qufNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Chaqa ukkunaqami qillaynin subrashanlata itanllapa. Piru kay mana imayjun byuda-shuypaqami, chaylawanna kawsananpaq kasha karmapis limpula ĉhurashamapis, nir. ");
INSERT INTO qufNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Chaymanta Dyusta adurananllapa wasimanta lluqshitinllapaqa Jesuspa uk yaĉhakuqninqa kaynu niran: —Yaĉhachikuq Taytituy, rikay Dyusta adurananllapa wasitaqami kusa shumaq rumikunawan ima kusala atunta rurashallapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Chaymi Jesusqa niran: —Kanan kayta rikayankillapa chaytaqami limpu ratachinqallapa. Mananami uk rumilamapis anapura llutakashaqa kidanqanachu nir. ");
INSERT INTO qufNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Chaymantami paykunaqa Olivos sirkaman riranllapa. Chayqami karan Dyusta adurananllapa wasipa naypanlawpi. Chaymi chaypi Jesusqa tatin, Pedro, Santiago, Juan, Andrés imaqa paylata kaynu nir tapuranllapa: ");
INSERT INTO qufNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Willamayllapa: ¿Maydiyataq chaynuqa pasayanqa? Chaynulla ¿ima siñalta rikartaq yaĉhayashaqllapa, tukuy chaykuna pasananpaq diyaqa shipchana? nirqa. ");
INSERT INTO qufNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Chaymi, Jesusqa niran: —Allitami kuytakankillapa, ama mayqanpis ingañar pantachishunanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Chaqa kusala achkami nuqa yupay tukur shamunqallapa. Chaymi, ‘Dyuspa Akrashan Cristunmi kani’ nir, kusala achka runakunata ingañanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Qamkunaqami chay tyimpukunaqa uyapankillapa wakpi kaypi guerrata rurayanllapa nir. Piru chaynu katinmapis amami manchakunkillapachu. Chaqa chaynumiri pasanqa. Piru chaynu pasatinmapis manaraqmi pacha tukukanan tyimpuraqchu kanqa. ");
INSERT INTO qufNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Chaqa uk nasyunmanta kaqkunami maqanakunqallapa uklaw nasyunmanta kaqkunawan. Chaynulla uk gubyirnupa kaqninkunapis maqanakunqallapa uklaw gubyirnupa kaqninkunawan. Kusala achka lugarkunapimi pachamapis kusalata kuyunqa, runakunapis kusala ukmanta tukunqa. Chaynulla kusala mallaq tyimpu, imami kanqa. Piru chaynu pasatinqami yarpunkillapa, chayraqmi qischakay tyimpuqa qallariyan nir. ");
INSERT INTO qufNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Qamkunallami kusalata kuytakankillapa. Chaqa chay tyimpukunapiqami qukushunqallapa karguyjunkunaman. Chaymi kusalata qischashunqallapa chay tantakananllapa wasikunapiqa. Chaynullami apashunqallapapis gubirnadurkunapa, gubyirnukunapa naypanman ima nuqapi kriyishaykillaparayku. Chaymi qamkunaqa paykunapa naypanpimapis nuqallapaq rimankillapa. ");
INSERT INTO qufNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Chaqa tukuy intirupi Dyuspa shumaq rimayninta washakananllapapaq yaĉhachikur tukchishana katinllapami, kay pacha tukukananpaq tyimpuqa ĉhamunqa. ");
INSERT INTO qufNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Piru chaynu karguyjunkunaman apashutinllapaqa, amami yarpupakunkillapachu imatana rimashaq nirqa. Chaymi ashwan Dyus imata rimanaykipaq yanapashushannulla rimankillapa. Chaqa chaypiqami mana qamkunallachu rimayankillapa kanqa. Ashwanmi Dyuspa Santu Ispiritun rimachishunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Chaynullami nishaykillapapis: Mayqanpismi ukninta qukuyanqa wanuchinanllapapaq. Nataq taytanllapa-shuypaqa wamrankunata qukuyanqa wanuchinanllapapaq. Chaynulla wamrakuna-shuypaqa taytanpa kuntran tikrakar wanuchinqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Chaymi tukuyla kay pachapiqa nuqapi kriyishaykillaparayku ĉhiqnishunqallapa. Piru chaynu qischakar imamapis maydiya shamunaykaman shachinakuqkunalami washakanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Chaqa Dyuspa rimaqnin Danielmaqa kaynu nir iskribiran: ‘Uk kusala mana allinta rurachikuqmi rir yaykunqa, Dyusta adurananllapa wasiman’ nir. Chaymi qamkuna chaynu pasaqta rikarqa, Daniel iskribishanmi kumplikayan nir yarpunkillapa. Chayraykumi mayqanpis Judea lugarpi kaqkunaqa sirkakunaman alsakanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nataq mayqanpis uk wasipa ananpi karmapis amami ishkimunqachu, imanta lluqshichinanpaq nirqa. ");
INSERT INTO qufNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Chaynulla, mayqan ĉhakranpi karqa amami wasinman rinqachu raĉhpanta apananpaq nirqa. ");
INSERT INTO qufNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Akaw chay diyakunapi warmikuna ruriyjun, manaqa ñuñuq wamrayjun kaqkunaqa imananqallaparaq! ");
INSERT INTO qufNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Chaymi ashwan qamkunaqa Taytay Dyusman alliplata mañakuyllapa, chay alsakanaykipaq tyimpuqa ama chay qasay tyimpuchu kananpaq nir. ");
INSERT INTO qufNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Chaqa, chay diyaqami kusala saqra manchaypaq qischakay kanqa. Chaynu qischakayqami tukuy ima rurakashanmanta-pacha mana kashachu. Chaynulla mananami kanqanapischu chaynu qischakayqa maydiyapis. ");
INSERT INTO qufNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Piru Taytay Dyus chay qischakaykuna achka tyimputa kanqa nitinqami, mana mayqanlapis washakanmanchu. Ashwanmi Taytay Dyusqa chay akrashan kaq wamrankunapaq llakir washananrayku, mana kusala achka tyimputachu kanqa nisha. ");
INSERT INTO qufNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Piru imanupi mayqan kaynu nishunmanllapa: ‘Rikayllapa kaypimi Dyuspa Akrashan Cristunqa’, manaqa ‘Rikayllapa chaypi’ nishutinllapaqa, amami kriyinkillapachu. ");
INSERT INTO qufNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Chaqa Dyuspa Akrashan Cristun yupay tukuqkuna, chaynulla Dyuspa unay rimaqninkuna yupay tukuqkunami rikarimunqallapa. Chaymi paykunaqa mana ruraypaq imakunata, milagrukunata ima, kusalata ruranqallapa. Chaynumi ashwan kusala achka runakunata ingañanqallapa. Chaynullami chay kriyiqkunamatapis imanullapis ingañayta kamanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","¡Piru qamkunaqami allita kuytakankillapa! Ama ingañakanaykillapapaqqami willashunillapana. ");
INSERT INTO qufNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Piru limpu chay qischakay tyimpukuna pasatinnaqami, rupayqa limpu tutaparaq intiru kidanqa. Killapismi mana achkirachikunqanachu. ");
INSERT INTO qufNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Chaynulla qullarkunapismi limpu syilumantaqa ratamutin ima, tukuy syilupi kaqkunamapis kusalata kuyunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Chaymantami Dyusmanta Shamuq Runataqa rikanqallapa kusa llipyalla pudirninwan puktaypa rurinta shamuqtana. ");
INSERT INTO qufNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Chaynu shamurmi payqa angelninkunata kaĉhanqa tukuyla pachamanta, syilumanta, paypa akrashan kaqkunata tantamunanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Allita uyakur intrakayllapa kay igus qirupaq willar intrachishutiyllapa. Chaqa qamkunaqa igus qiru mushuqmanta qawamuqta rikarqa kwintata qukankillapa, tamya tyimpuqa shipchana nir. ");
INSERT INTO qufNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Chaynullami chay nishushayllapanulla pasaqta rikarqa yarpunkillapana Dyusmanta Shamuq Runaqami shamunanlapina nir. ");
INSERT INTO qufNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Chaymi chiqapta nishaykillapa: Chay tyimpupi kaq runakunaqa manaraq wanuyatinraqmi tukuyla kay nishushayllapaqa pasanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Chaqa syilu chaynulla kay pachamapismi tukukanqa. Piru nuqa nishaykuna-shuypaqami mana maydiyalapis tukukanqachu. ");
INSERT INTO qufNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Piru Dyusmanta Shamuq Runa shamunanpaq diyapaq, uraspaq-shuypaqami, mana mayqanlapis yaĉhanchu. Chaynulla syilumanta angelkuna, Dyusmanta Shamuq Runamapis manami yaĉhanchu. Nataq Taytaylami yaĉhan. ");
INSERT INTO qufNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Chayraykumi qamkunaqa imuraspis rikĉhakur Dyusman mañakur alli kamakashalana kankillapa. Chaqa manamiri yaĉhankillapachu ima diyami shamuyanqa nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Tukuy kayqami imanutaq uk runamaqa largu mayta rinanpaq karqa, sirbiqninkunata wasinta kuytananpaq dijaran chay yupay. Chaymi ukninta ukninta imata rurananpaq nir mantar, uktaqa kaĉharan punkupi kuytakunanpaq ima. ");
INSERT INTO qufNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Chaynumi qamkunapis imuraspis rikĉhakur allita kamakashalana kankillapa. Chaqa chay wasipa amun ima amsaqpi, ĉhaypi tuta, gallu kantaypi manaqa allaqmanta ĉhamuyan nirmapis mana yaĉhayankillapachu. ");
INSERT INTO qufNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kuytawkish, imanupi shamurqa punuqmatana tarishutinllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Tukuy kay nishushayllapallatami wakinkunatapis willani, rikĉhakur kamakashalana kananllapapaq”. ");
INSERT INTO qufNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ishkay diyalanami chay Pascua fyistapi tantata mana libadurawanchu mikuqllapa chayqa faltayaran. Chaymi chay kurakunapa mantaqninkuna, Moisés mantakushanta yaĉhar yaĉhachikuqkuna imaqa yarpuranllapa imanullapis llullakuypi ima Jesustaqa aypar wanuchinanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Piru wakinkunaqami niranllapa: “Amami chay fyista diyakunapiqa chaynu rurashunllapachu. Chaqa runakunami piñakur kuntranchikllapa alsakamunmanllapa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Chaymantami Jesusqa Betania pwibluman ĉharqa, riran Simonpa wasinman. Kay Simonmi unayqa chay ismuyaq qishaywan karan. Piru chaynu misapi tayatinmi uk warmi payman qimikaran uk alabastru butillitapi kusa ĉhaniyjun mishkila mutkiypaq yakituta charikur. Chaymi ashwan chay warmiqa chay butillitata pakir Jesuspa umanman chay mishki yakitutaqa iĉharan. ");
INSERT INTO qufNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Piru chaypi wakin kaqkuna chayta rikarmi piñakur, ukninllapa ukninllapa kaynu ninakuranllapa: “¿Imapaqtaq wak kusa ĉhaniyjunta yanqallaqa iĉhan? ");
INSERT INTO qufNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ashwanmi waknu yanqalla iĉhananmantaqa qumashallapa trisyintus dinaryu qillaymanmatapis mas rantikur, chay mana imayjun kaqkunata yanapanallapata” nir. Chaynu ninakurmi, chay warmitaqa kusalata qillakachiyaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Chaynu nitinllapa uyaparmi Jesusqa kaynu niran: “Ama qillakachirchu dijayllapa. Payqami kusala allinta rurasha nuqawanqa. ");
INSERT INTO qufNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Chaqa chay mana imayjun kaqkunawanqami maydiyapis pulla kankillapa, munashaykillapa ura yanapanaykillapapaqqa. Piru nuqa-shuypaqami manana pullaykillapanachu kashaq. ");
INSERT INTO qufNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kay warmisitaqami puytishanta rurasha nuqapa anayman mishki mutkiypaqla yakituta iĉharqa. Chaymi ashwan kamakachimashana, kusa shumaqta pampakanaypaq. ");
INSERT INTO qufNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Chiqaptami nishaykillapa: Tukuy maylawpipis imanu kriyir washakananllapapaq nir yaĉhachikurqami, kay warmisita rurashantaqa yarpur rimanqallapa. Chaymi mana qunqanqallapachu”. ");
INSERT INTO qufNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jesuspa dusi yaĉhakuqninkunamanta ukqa shutiq, Judas Iscariote. Chay paymi, kurakunapa mantaqninkunaman riran willaq, Jesustaqa qushaykillapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Chaynu nitin uyaparmi chay kurakunapa mantaqninkunaqa kusalata aligriyar, Judasta qillayta qunanpaq arniranllapa. Chaymi Judasqa yarpuran, maylapina, imurasna Jesustaqa qukushaq nir. ");
INSERT INTO qufNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Chay Pascua fyistapa punta diyanpi tantata mana libadurayjuntachu mikuqllapa chaynulla chay uyshitata ufrindapaq nir wanuchiqllapa chay diyami Jesuspa yaĉhakuqninkunaqa payman qimikar kaynu nir tapuranllapa: —Pascua mikunataqa, ¿maypitaq kamakachinayllapata munayanki? nir. ");
INSERT INTO qufNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Chaymi Jesusqa ishkay yaĉhakuqninkunata kaynu nir kaĉharan: —Riyllapa Jerusalén pwibluman. Chaypimi uk runa kantarunpi yakunta apaqta tarinkillapa. Chaymi paypa ikinta rinkillapa. ");
INSERT INTO qufNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Chaynu rir, wasinman yaykutinqa ninkillapa: ‘Yaĉhachimaqniyllapami nin: ¿Maylaw kwartuykipitaq yaĉhakuqniykunawan Pascua mikunata mikushaq? niyan’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Chaynu nitkillapami payqa rikachishunqallapa wasinpa unaqninpi uk atun kwartu kusala kamakashatana. Chaymi chaypi kamkachinkillapa mikunallapapaqqa. ");
INSERT INTO qufNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Chaynu nitinmi yaĉhakuqninkunaqa pwibluman rir Jesús nishannulla tariranllapa. Chaymi chaypina kamakachiranllapa Pascua mikunataqa. ");
INSERT INTO qufNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Chaymanta tutapatinnaqa, Jesusqa chay dusi yaĉhakuqninkunawan ĉharanna chay wasimanqa. ");
INSERT INTO qufNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Chaymanta misapi tasha mikuyarnaqa, Jesusqa niran paykunataqa: —Chiqaptami nishaykillapa: Qamkunamanta uknikillapa pullay mikuqmi kuntraykunaman qukumayanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Chaynu nitinmi, paykunaqa kusalata llakiranllapa. Chaymi uknin uknin kaynu nir tapuq ĉhurakaranllapa: —¿Nuqachu kashaq? nir. ");
INSERT INTO qufNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Chaymi Jesusqa paykunataqa niran: —Qamkunamanta uknikillapa nuqawan chay platullapi tantata nuyuchir mikuqmi, nir. ");
INSERT INTO qufNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Chaynuqami Dyus nitin iskribikashannulla, Dyusmanta Shamuq Runawanqa pasanqa. ¡Piru imananqaraq, chay kuntrankunaman qukuqqa! Kusala allinĉhi kananta chay runaqa ama nasinanpaqchu. ");
INSERT INTO qufNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mikuyatinllapanaqa, Jesusqa tantata aypar Taytanta payji nir, pakir quran yaĉhakuqninkunata kaynu nir: “Kaypi. Kayqami nuqapa kwirpuy” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Chaymanta kupata aypar Taytanta payji nir, yaĉhakuqninkunata qutin, tukuynin upyaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesusqami niran: “Kayqami yawarniy. Kay yawarniyta iĉhashaywanmi Taytay Dyuswan uk tratuta rurani, kusa achka runakunata llakipashayrayku. ");
INSERT INTO qufNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Chiqaptami nishaykillapa: Mananami qashanqa upyashaqnachu kay ubapa yakuntaqa, maydiya Dyus mantakuyashanpi mushuq ubapa yakunta upyanaykaman” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Chaymantami salmukunata takir Dyusta alabarnaqa, riranllapana Olivos sirkaman. ");
INSERT INTO qufNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Chaypimi Jesusqa paykunata niran: —Tukuy qamkunami kanan tutalla manchakushaykillaparayku nuqalatana dijamankillapa. Chaqa, Dyus nitin iskribikashakunapimi nin: ‘Chay michikuqta wanuchitiymi, uyshakunaqa wakta kayta limpu shikwakanqallapa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Piru nuqa kawsamurqami, qamkunamantaqa naypaqta rishaq Galilea pwiblumanqa. ");
INSERT INTO qufNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Chaynu nitinmi, Pedruqa niran: —Tukuy wakinkuna manchakur dijashutinllapapismi, nuqaqa mana dijashaykichu nir. ");
INSERT INTO qufNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Chaymi Jesusqa niran: —Chiqaptami nishayki: Kanan tutallami gallu ishkay kutipaqna kantananpaq katin qamqa kimsa kuti ninki: ‘Manami paytaqa riqsinichu’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Piru Pedruqa qashan niran: —Qamwan pullata wanuchimanallapapaq katinmapismi, pullayki shachinakushaq nir. Chaynullatami wakinkunapis niyaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Chaymantami Jesusqa yaĉhakuqninkunawan riranllapa uk lugar Getsemaní shutiqman. Chaypimi yaĉhakuqninkunata kaynu niran: —Riyanimi Taytayman mañakuq. Qamkunaqami kaylapi taskinkillapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Chaynu nirmi, Pedruta, Santiaguta, Juanta ima apar riran pullanqa. Chaymantami kusata llakir kwashala tikrakaran Jesusqa. ");
INSERT INTO qufNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Chaynu kayarmi kaynu niran paykunataqa: —Kusalataraq llakir wanuq yupayna yarpuni. Qamkunaqa kaylapi kidar rikĉhakushala kayllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Chaynu nirqa, chay kayashanmanta ashlila wakaq riran. Chaypimi qunqurikur pachakaman pukĉhirar Taytanman mañakuran puytiypaq katinmaqa chay kusala saqra qischakayqa mana ĉhamunmanchu nir. ");
INSERT INTO qufNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Chaymi kaynu nir mañakuran: “Abba, Taytay, qampaqqami tukuy imapis ruraypaq. Chaymi puytiypaq katinqa yanapamay-ari kay kusa ayaq yaku yupay qischakaymantaqa. Piru manami nuqa munashaynuchu kanqa. Ashwanmi qam munashayki rurakanqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Chaymanta paykuna kayashanman tikrakamurqa, punuqta tariran. Chaymi Pedrutaqa niran: —Simón, ¿ima punuyankinachu? ¿Manachu puytishayki uk uralamatapis rikĉhakur nuqawan kaytaqa? ");
INSERT INTO qufNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Rikĉhakur mañakuyllapa, ama uchapi ratanaykillapapaq. Qamkunaqami allinkunalata rurayta yarpunkillapa. Piru kwirpuykillapa litala kashanraykumi mana shachinakuyta puytinkillapachu. ");
INSERT INTO qufNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Chaynu nirmi qashan riran mañakuq puntata ima nirtaq mañakusha karan chaynulla. ");
INSERT INTO qufNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Chaymanta tikrakamurqa, qashalan chay yaĉhakuqninkunataqa punuqta tariran. Chaqa nawinllapamapis kusalata qipchirayaran punuypaq. Chaymi paykunaqa mana imata nishaq nirpis yaĉharanllapachu. ");
INSERT INTO qufNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Chaymanta kimsa kutipaqna shamur punuqta tarirqa niran: —¿Qamkunaqachu punur samayankillaparaq? ¡Rikĉhakur shariyllapana! Chaqa Dyusmanta Shamuq Runata uchakuqkunaman qukunanllapapaq uraqami ĉhamushana. ");
INSERT INTO qufNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Shariyllapa, rishunllapana, shipchamunnami nuqata qukumaqqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Chaynu nir Jesús rimayatinllami, chay dusi yaĉhakuqninkunamanta uknin Judasqa, achka runakunawan ĉharanllapa ispadakunawan, qirukunawan ima. Paykunaqami riranllapa kurakunapa mantaqninkuna, Moisés mantakushanta yaĉhar yaĉhachikuqkuna, Israel runakunapa ruku mantakuqninkuna kaĉhasha katin. ");
INSERT INTO qufNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judasqami, Jesuspa kuntraqninkunataqa, kaynu nisha karan: “Nuqa saludar muchayani chaytami aypar alli prisunkillapa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Chaymi Jesusman, Judas qimikarqa, —¡Yaĉhachikuq Taytituy!— nir mucharan. ");
INSERT INTO qufNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Chaymi Jesustaqa aypar prisuranllapana. ");
INSERT INTO qufNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Piru chaypi kaqkunamanta ukmi ispadanta lluqshichimur, kurakunapa mantaqninta sirbiq runapa rinrinta ¡saq! pitiran. ");
INSERT INTO qufNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nataq Jesusqami chay runakunataqa kaynu nir tapuran: —¿Imapaqtaq qamkunaqa shamushaykillapa qirukunawan ispadakunawan ima, uk suwakuqta yupay aypar apamaqllapaqa? ");
INSERT INTO qufNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nuqaqami imuraspis qamkunawan pulla kar Dyusta adurananllapa wasipi yaĉhachikuray. Piru manamiri chaypiqa aypar apamaraykillapa imachu. Kayqami chaynuqa pasayan Dyus nitin iskribikashannulla kumplikananpaq. ");
INSERT INTO qufNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Chaynu Jesús nitinqami, tukuy yaĉhakuqninkunaqa dijarna alsakaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nataq uk musu runami Jesuspa ikintaqa riyaran, uk yuraq raĉhpalawan qatakusha. Chaymi chay runakunaqa ayparan apananpaq. ");
INSERT INTO qufNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Piru payqami chay qatakushan raĉhpanmatapis dijar, lirila alsakar riran. ");
INSERT INTO qufNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Chaymantami Jesustaqa, kurakunapa mantaqninmanna aparanllapa. Chaymanmi tantakaranllapa kurakunapa mantaqninkuna, ruku mantakuqkuna, Moisés mantakushanta yaĉhar yaĉhachikuqkuna, ima. ");
INSERT INTO qufNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Nataq Pedruqami largukaqllamanta chapar ikinllapata riyaran, chay kurakunapa mantaqninpa wasin ruripi pampankaman. Chaymantami chay yaykushanlapi kidaran Dyusta adurananllapa wasita kuytaqkunawan pulla, ninapi quñukuqnu. ");
INSERT INTO qufNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Piru kurakunapa mantaqninkuna, tukuy chay kusa mas karguyjunkunaqami Jesuspaqqa kusalata yaĉhayta munaranllapa imalata mana allinta rurasha katinqa, chayraykulana wanuchinanllapapaq. Piru chaynumapis manami tariranllapachu. ");
INSERT INTO qufNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Chaqa kusala achka runakunami mana kashanmanta uchachananpaq qimikaranllapa. Piru mana puytiranllapachu. Chaqa rimayashanllapaqami mana chayllachu karan. ");
INSERT INTO qufNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Chaynullami wakinkunapis yanqa llullakurla kaynu niranllapa: ");
INSERT INTO qufNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Nuqakunaqami kaynu niqta uyasha kanillapa: ‘Nuqaqami Dyusta adurananllapa wasita runakuna rurashantaqa ratachir, qashan kimsa diyalapaqna shachishaq, mana runakuna rurashannutanachu’ nir. ");
INSERT INTO qufNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Piru chaynu rimarmapismi mana chayllatachu rimayaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Chaynu nitinllapami chay kurakunapa mantaqninqa sharir tukuypa naypanpi Jesustaqa kaynu nir tapuran: —¿Qam-shuypaqachu mana imatapis ninki? ¿Ima nishaq nirtaq waknu qampaqqa rimayanllapaqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Chaynu nitinmapismi Jesusqa mana imatapis niranchu. Chaymi chay kurakunapa mantaqninqa qashan niran: —¿Qamchu Dyuspa Akrashan Cristun, allin Dyuspa Wamran kanki? nir. ");
INSERT INTO qufNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesusqa niran: —Nuqami kani. Chaqa qamkunami rikankillapa Dyusmanta Shamuq Runataqa kusala puytiq Dyuspa allilaw qichqanpi taqta, chaymanta puktaypa rurinta syilumanta shamuqta ima nir. ");
INSERT INTO qufNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Chaynu Jesús nitinmi chay kurakunapa mantaqninqa kusata piñakur raĉhpanmatapis llikiran, Jesusqa mana allintachu tukuyan nir. Chaymi niran: —¿Ima mas tistigutataq ministinchikllapa? ");
INSERT INTO qufNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Qamkuna uyapashaykillapanu, kusala mana allintami Dyuspaq riman. ¿Imatataq yarpunkillapa? Chaymi, chaypi kaq runakunaqa niranllapa: —Kusala uchayjunmi wakqa; wanunanpaqmi allin nir. ");
INSERT INTO qufNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Chaymi ashwan wakinqa tuqapar, nawinta bindar maqar ima kaynu niranllapa: —¡Mabir tantyay!, ¿pitaq maqashuran? nir. Chaynullami Dyusta adurananllapa wasipi kuytakuqkunapis maqaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Chaykamanqami Pedruqa tayaran ruri pampalapi. Chaypi kanankamanmi kurakunapa mantaqninta sirbiq warmi ĉharan. ");
INSERT INTO qufNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Chaymantami Pedruta rikaran ninapa yatalanpi quñukur taqta. Chaymi chay warmiqa kusalata chapar kaynu niran: —Qampismi Nazaretmanta Jesuswan puriq kanki nir. ");
INSERT INTO qufNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Piru Pedruqami kaynu niran: —Manami riqsinichu paytaqa. Chaynulla manami yaĉhanichu imapaq rimayanki nirmapis nir. Chaynu nir, punkulawman risha katinmi kantaranna galluqa. ");
INSERT INTO qufNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Chaymantami chay sirbikuq warmiqa qashan Pedruta rikar, wakinkunata kaynu niran: —Kay runapismi Jesuswan puriq nir. ");
INSERT INTO qufNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Piru payqami qashan niran: —Manami paytaqa riqsinichu nir. Chaymanta uk ratulamantaqa chaypi kaqkunapis Pedruman qimikar kaynu niranllapa: —Chiqaptami paykunapa uknin kanki. Chaqa qampis Galilea pwiblumanta kanki. Rimanaykimapismi paykunanu. ");
INSERT INTO qufNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Chaymantami Pedruqa kutir kutir jurar niran: —¡Mana riqsinichu chay rimayashaykillapa runataqa nishuyanillapa wakmaqa! ¡Mana chiqapta rimayatiyqami Dyus kastigamanqa! nir. ");
INSERT INTO qufNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Chaynu niyatinlami ishkay kutipaqna gallu kantaran. Chaymantami Pedruqa yarpuran Jesús kaynu nishanta: “Manaraq gallu ishkay kutipaqna kantayatinmi kimsa kuti nuqapaqqa ninki: ‘Manami riqsinichu’ nir” nishanta. Chaymi llakir kusalata waqaran. ");
INSERT INTO qufNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Chaymanta achkiyatinnaqa chay kurakunapa mantaqninkuna, ruku mantakuqkuna, Moisés mantakushanta yaĉhar yaĉhachikuqkuna, chaynulla chay wakin kusa mas karguyjunkunawan ima tantanakur parlaranllapa. Chaymi Jesustaqa alli watar apar Pilatutana quranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Chaymi Pilatuqa kaynu nir tapuran: —¿Qamchu Israel runakunapa mantaqnin kanki? nir. Jesusqa niran: —Qamllami ninki. ");
INSERT INTO qufNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Piru chay kurakunapa mantaqninkuna kusalata uchachayashanllaparaykumi, ");
INSERT INTO qufNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatuqa qashan kaynu nir tapuran: —Waknu kusalata uchachashutinllapaqachu, ¿qam-shuypaqa mana imatapis ninki? ");
INSERT INTO qufNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Piru Jesusqami mana rimaranchu. Chaymi Pilatuqa kusalata yarpupakuyar kidaran. ");
INSERT INTO qufNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kada Pascua fyistapimi chay gubyirnu Pilatuqa uk runata lluqshichiq chay prisu kashanmanta, runakuna mayqantaĉhi lluqshichiy nishannulla. ");
INSERT INTO qufNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Chay tyimpupimi uk runa Barrabás shutiq prisu karan wakinninkunawan. Chaqa paykunami gubyirnupa kuntran tikrakar wanuchikusha karanllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Chaymi runakunaqa Pilatuman ĉhar mañakuranllapa, imanutaq kada fyistapi uk prisuta lluqshichiq chaynulla rurananpaq nir. ");
INSERT INTO qufNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Piru Pilatuqa paykunataqa kaynu niran: —¿Qamkunaqachu munayankillapa, Israel runakunapa mantakuqninta dijatiy rinanpaq? nir. ");
INSERT INTO qufNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Chaynuqami Pilatuqa niran, chay kurakunapa mantaqninkunaqa Jesustaqa ĉhiqnirla paymanqa apamusha karan nir kwintata qukashanrayku. ");
INSERT INTO qufNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Piru chay kurakunapa mantaqninkunaqami tukuy runakunata animachiran, Barrabasta kaĉhay nir mañakunanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Chaymi Pilatuqa tapukuran: —Chayqa ¿imatataq ruranayta munayankillapa Israel runakunapa mantakuqnin niyashaykillapawanqa? ");
INSERT INTO qufNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Paykunaqami kusala jwirtita kaynu nir lanyaranllapa: —¡Kruspi klabay! nir. ");
INSERT INTO qufNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Qashanmi Pilatuqa niran: —Chaqa, ¿ima mana allintataq rurasha? Piru chay runakunaqami qashan kusala jwirtita kaynu nir lanyaranllapa: —¡Kruspi klabay! nir. ");
INSERT INTO qufNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Chaymi Pilatuqa tukuy runakunawan allinpi kidanar, Barrabasta prisu kashanmanta lluqshichir, suldadunkunata kaĉharan Jesusta llibachir, chaymanta-shuypaqa kruspi klabananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Chaynami suldadukunaqa Jesusta aparanllapa gubyirnu Pilatupa dispachunpa pampanman. Chaypimi paykunaqa tukuy suldadu masinkunata tantaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Chaymi ashwan uk chupika murada raĉhpata yakachiranllapa. Chaynullami umachiranllapa uk kuruna kashamanta rurakashata. ");
INSERT INTO qufNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Chaymanta-shuypaqa kusalata kushikur kaynu nir qayĉhakuranllapa: —¡Biba Israel pwiblupa gubyirnun! nir. ");
INSERT INTO qufNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Chaynu nirnaqa umitanpi uk barawan maqaranllapa, qaqllitanpi tuqaparanllapa ima. Chaynulla paymanta burlakar naypanpi qunqurir, aduraq yupay tukuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Chaymanta chaynu paymanta kusata burlakarllapa imanaqa, chay chupika murada raĉhpata yakachishanllapataqa lluqshichir paypa raĉhpanllata yakachiranllapa. Chaynu munashanllapata rurarnaqami aparanllapana kruspi klabananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Chaymantami Cirene pwiblumanta uk runa Simón shutiq, ĉhakranmanta shamuqta tariranllapa. Payqami Alejandro chaynulla Rufo shutiq runakunapa taytan karan. Chaynu tarirmi Jesuspa krusninta amalas rikrachir aparanllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Chaynu rirmi uk lugar Gólgota shutiqman ĉharanllapa. Kay lugartami ninllapapis Calavera nir. ");
INSERT INTO qufNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Chaymi chaypiqa binuwan mirrata piĉhur Jesustaqa upyachinaranllapa. Piru payqami mana munaranchu. ");
INSERT INTO qufNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Chaymantami Jesustaqa kruspi klabaranllapana. Chaymi chay suldadukunaqa Jesuspa raĉhpankunata mayqanninllapapaqshi kanqa nir yaĉhananllapapaqqa surtyakur ayparanllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jesustaqami alas nwibi unaqna kruspiqa klabaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Uk litrirutapismi ĉhuraranllapa imaraykushi wanuchishallapa nir. Chaqa kaynumi niyaq: “KAYMI ISRAEL RUNAKUNAPA MANTAQNIN” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Chaynullami paypa pullanqa ishkay suwakuqkunata krusllapi klabaranllapa, ukninta Jesuspa ichuqlaw qichqanpi, ukninta-shuypaqa allilaw qichqanpi.  ");
INSERT INTO qufNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Chaynuqami ruraranllapa Dyus nitin iskribikashannulla kumplikananpaq. Chaqa niqmi: “Uchasapa runakunawan pullatami mana allinpaq riqsishallapa” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Piru tukuy chayta pasaqkunaqami, umanllapata kuyuchiqnulla, kusalata musyar kaynu niyaqllapa: —¡Jajay! ¡Qammi, Dyusta adurananllapa wasita ratachir qashan kimsa diyalapaq shachishaq nirayki! ");
INSERT INTO qufNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡Chaymi ashwan qamlla washakar krusmanta ishkimuy! nir. ");
INSERT INTO qufNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Chaynullami chay kurakunapa mantaqninkuna, Moisés mantakushanta yaĉhar yaĉhachikuqkunapis kusalata kushipar, kaynu ninakuyaqllapa: —Ukkunatami washaran. Piru payllaqami mana washakayta puytinchu. ");
INSERT INTO qufNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Wakqashi Dyuspa Akrashan Cristun, Israel runakunapa mantaqnin-ari. ¡Chaynu karqa chay krusmanta ishkimunqari! ¡Chaynami chaypiraq paypi kriyishunllapa! Chaynullami paywan pulla kruspi kaqkunamapis ashwan kusa mana allinkunata ima willaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Chaymantami a las dusimanta-pacha tardi a las triskaman tukuy pacha tutaparaq intiru kidaran. ");
INSERT INTO qufNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Chay urasllami Jesusqa kusa jwirtita kaynu nir qayĉhakuran: “Eloi, Eloi, ¿lama sabactani?” (Chaynu nirqami intrachimanchik: “Dyusniy, Dyusniy, ¿imapaqtaq nuqalata dijamashayki?” nir). ");
INSERT INTO qufNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Chaymi wakin chaypi kaqkuna chaynu nitin uyaparqa kaynu niranllapa: —¡Uyakuyllapa! Wakqami Dyuspa rimaqnin Eliasta qayayan nir. ");
INSERT INTO qufNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Chaymantami chaypi kaqkunamanta ukninllapa kallpar rir puqyala raĉhpata qirupi watar puchqu binupi nuyuchir Jesuspa shiminman upyananpaq ĉhurar kaynu niran: —Dijayllapa, mabir Eliaschu shamur ishkichimunqa nir. ");
INSERT INTO qufNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Piru Jesusqami kusala jwirtita qayĉhakur wanuranna. ");
INSERT INTO qufNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Chaymi chay kutilla Dyusta adurananllapa wasi ruripi uk atun rakta raĉhpa warkuraqpis llikikaran ĉhaypin unaqmanta urakaman. ");
INSERT INTO qufNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jesuspa naypanpimi Romamanta suldadukunapa mantaqnin karan. Chaymi payqa rikaran imanu Jesús wanutinmapis. Chayraykumi niran: —Chiqaptami kay runaqa Dyuspa Wamran kasha nir. ");
INSERT INTO qufNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Chaypiqami wakin warmisitakuna karukaqlamanta rikakuyaranllapa. Paykunaqami kaykuna karanllapa: María Magdalena, Salomé, chaynulla Josipa, wamrakaq Santiagupa maman María ima. ");
INSERT INTO qufNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Kay warmisitakunami Jesuspaqa pullan purir, yanapasha karan pay Galilea pwiblupi katinqa. Chaynullami chaypiqa wakin warmisitakunapis achka karanllapa. Paykunami Jesuspa pullan risha karanllapa Jerusalén pwiblumanqa. ");
INSERT INTO qufNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Chaymanta chay samana diyapaq kamkachikunanllapa diya limpu tardiyayatinnaqami, ");
INSERT INTO qufNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Arimatea lugarmanta uk kusa imayjun runa José shutiq, riran mana manchakurchu Pilatuta, Jesuspa kwirpunta mañaq. Payqami Dyus maydiyaqa shamur qashan mantakuyanqa nir yarpurla kawsaq. Chaynulla payqami chay Israelmanta kusa mas karguyjunkunapa masin karan. ");
INSERT INTO qufNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Chaynu Jesuspa kwirpunta mañaq ĉhatinmi Pilatuqa kusalata manchakur yarpupakuran. Chaymi suldadukunapa mantaqninta qayachimuran Jesusqachu wanushana nir yaĉhananpaq. ");
INSERT INTO qufNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Chaymi suldadukunapa mantaqninqa rir “Wanushanami” nir willaran. Chaynami Pilatuqa Jesuspa kwirpuntaqa Jositana quran apananpaq. ");
INSERT INTO qufNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Chaymi Josiqa kusa shumaq yuraq raĉhpata rantir, Jesuspa kwirpuntaqa rir krusmanta ishkichimur chay raĉhpawanna pilluran. Chaymantami apar qaqapi uk uĉhku karan, chaylapi ĉhurar, yaykunantaqa kusala atun rumiwanna kirparan. ");
INSERT INTO qufNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Chaynu kirpatinmi, María Magdalenawan, Josipa maman Mariaqa rikakuyaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Chaymanta chay samana diya pasatinnaqa María Magdalena, Salomé chaynulla Santiagupa maman Mariaqa kusala mishki mutkiypaq rimidyukunata rantir aparanllapa, Jesuspa kwirpunta kamkachinanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Chaymi chay simanapa punta diyanpiqa, allaq allaqla chayraq rupay iqamuyatin riranllapa Jesús pampakashanmanqa. ");
INSERT INTO qufNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Kaynu ninakurmi riyaranllapa: “¿Piraq chay uĉhkuta kirpasha kusa atun rumita ashuchiyanqa yaykunallapapaq?” nir. ");
INSERT INTO qufNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Piru ĉharqami, chay kusa atun rumiwan uĉhkuta kirpashanllapaqa uklawpina taqta rikaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Chaymanta paykuna chayman yaykurqa chay uĉhkupa allilaw qichqanpiqa uk musu runa, kusala atun yuraq intiru raĉhpayjunta rikaranllapa. Chaymi chay warmikunaqa kusalata manchakuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Piru chay musu runa rikashanllapaqami kaynu niran: “Ama manchakuyllapachu. Qamkunaqami maskayankillapa Nazaretmanta Jesusta kruspi klabaranllapa chayta. Payqami kawsamur rishana; mananami kaypinachu. Shamur rikayllapa pampashanllapata. ");
INSERT INTO qufNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Chaymi ashwan rir yaĉhakuqninkunata, Pedruta ima willayllapa: Payqashi Galilea pwibluman riyan paykunamanta naypaqta; ashwanshi wakpina rikanqallapa, imanutaq willasha karan chaynulla”. ");
INSERT INTO qufNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Chaynu nitinmi chay warmikunaqa chay uĉhkumantaqa kusalata alsakar lluqshir riranllapa. Chaqa kusalatari manchakur chukchukyayaranllapa. Piru manami mayqantapis willaranllapachu chaynu manchakushanllaparayku. ");
INSERT INTO qufNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesusqami chay simanapa punta diyanpi kawsamurqa, puntataqa rikariran María Magdalenaman. Kay Mariamantami Jesusqa, unaylla syiti dyablupa yarpuyninta itakusha karan. ");
INSERT INTO qufNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Chaymi payqa rir willaran Jesuspi kriyir pullan purisha kaqkunata. Chaqa paykunaqami kusalata llakir waqayaqllapa ima. ");
INSERT INTO qufNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Piru Jesustami kawsamushata nuqa rikasha kani nir willatin uyaparqa, mana kriyiranllapachu. ");
INSERT INTO qufNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Chaymantaqami Jesusqa mana riqsiypaqla tikrakar ishkay yaĉhakuqninkuna chunllaq nanta riyatin rikariran. ");
INSERT INTO qufNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Chaymi riqsirna paykunapis rir wakinninkunata willaranllapa. Piru manami kriyiranllapachu. ");
INSERT INTO qufNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Chaymanta mas tardikaqqami Jesusqa chay unsi yaĉhakuqninkuna misapi tayatinllapa, paykunaman rikariran. Chaymi paykunataqa anyaq anyaq willaran mana allita kriyishanpaq, mana intrakashanllaparayku ima. Chaqa wakinkuna, Jesús kawsamushata rikar, willatinllapami mana kriyishallapachu karan. ");
INSERT INTO qufNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Chaymi paykunataqa niran: “Riyllapa tukuy pachata. Chaynami Dyuspa shumaq rimayninta tukuylata yaĉhachinkillapa. ");
INSERT INTO qufNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Chaymi mayqanpis kriyir shutikurnaqa, washakanqallapa. Nataq chay mana kriyiqkuna-shuypaqami tukuy tyimpupaq kastigakananpaqna kanqa. ");
INSERT INTO qufNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Tukuy kriyiqkunata yanapatiymi kaynu kanqallapa: Nuqapa shutiywanmi dyablupa yarpuyninta runakunamanta itakunqallapa; mushuq rimaykunata rimanqallapa ima. ");
INSERT INTO qufNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Largu kurukunata ayparllapa, manaqa bininuta upyarllapamapis mana imananqallapachu. Chaynulla tukuy qishaqkunapa ananman makinllapata ĉhuratinllapapismi, alliyanqallapa ima”. ");
INSERT INTO qufNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Chaynu nir imanaqami Jesusqa syiluman apakaranna. Chaymantami ashwan Dyuspa allilaw qichqanpina taran. ");
INSERT INTO qufNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nataq yaĉhakuqninkuna-shuypaqa tukuy pachata riranllapa imanu kriyir washakananllapapaq nir yaĉhachikuq. Piru Jesusqami kusalata yanapatin kusa mana ruraypaq milagrukunata ima ruraranllapa. Chaymi tukuy rikaqkuna, uyakuqkunaqa chiqapta chayqa chaynu kanqa niranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Amitunchik Jesucristo tukuy imata rurashantami kusala achka runakuna manyaq iskribiyta kamaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Chaqa paykunaqami imanuĉhi Amitunchik Jesucristuwan puntamanta-pacha pullan kar, tukuy imata rurashankunata rikasha kar willamaranchikllapa chaynulla iskribiranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Chaynullami nuqapis kusala munashay Tayta Teófilo tukuy chaykunapaq manyaq tapukur allita intrakashayrayku manyaq iskribishuyta yarpusha kani. ");
INSERT INTO qufNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Chaynuqami kusala allitana intrakanki chay yaĉhachishutinllapa kriyishaykipaqqa. ");
INSERT INTO qufNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herodes Judea pwiblupi mantakuyashan tyimpupimi, chaypi taran uk kura Zacarías shutiq. Payqami, Abías kurakunapa ayllunmanta karan. Nataq, warmin Elisabet-shuypaqa punta kura Aaronpa ayllunmanta karan. ");
INSERT INTO qufNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Paykunaqami ishkantinllapa kusa allin karanllapa Dyuspaqqa. Chaynu karmi, Dyus nishanta, mantakushanta ima kasushanrayku mana mayqanpis uchachayta puytiqllapachu. ");
INSERT INTO qufNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Piru manami wamrayjun kayta puytiqllapachu, Elisabet mana wamrakuq katin. Chaynulla ishkantin rukullana karanllapapis. ");
INSERT INTO qufNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Uk diyapimi, Zacariasqa wakin kura masinkunawan Dyusta adurananllapa wasipi rurananllapata ruraranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Paykunapa chaynu kustumrin katinmi, Zacariasta akraranllapa Dyusta adurananllapa wasipa Santu Kwartunman yaykur, insinsyuta quntachikunanpaq. ");
INSERT INTO qufNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Chaymi, Santu Kwartupi insinsyuta quntachikunankamanqa, tukuy chay waqtapi kaqkunaqa Dyusman mañakuyaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Chaykamanmi Zacariasmanqa, Tayta Dyuspa uk angelnin rikarir, chay insinsyuta rupachiyashan altarpa allilaw qichqanpi sharan. ");
INSERT INTO qufNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Chayta rikarmi Zacariasqa kusalata dispantakar manchakuran. ");
INSERT INTO qufNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Piru chay angelqa niran: —Zacarías, ama manchakuychu. Chaqa Dyusqami uyapasha mañakutkiqa. Chaymi, warmiki Elisabetqa wamrakustunqa. Chay wamritutaqami shutichinki Juan. ");
INSERT INTO qufNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Qamqami allipta aligriyanki, chay wamrituyki nasitinqa. Chaynulla kusa achka runakunapis aligriyanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Chaqa wamraykiqami, kusa yaĉhaq puytiq kanqa Dyuspaqqa. Manami upyanqachu ubapa yakunta kar, wakin maĉhaypaq ima kaqkunamatapis. Ashwan manaraq nasiyashanmanta-pacha, Dyuspa Santu Ispiritunwanmi kanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Payqami shumaqta yaĉhachikutin, Israelmanta kusa achka runakuna Dyusta kasunqallapa, uchankunata dijar imana. ");
INSERT INTO qufNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Juanqami, Dyuspa rimaqnin Elías yupaylla, kusa shumaq yarpuyniyjun, pudirniyjun ima kanqa. Chaymi, Amitunchikmantaqa naypaqta shamur yaĉhachikunqa, tukuy runakuna wamrankunawan shumaqchakananpaq, chaynulla chay mana intrakanaqkunapis intrakananllapapaq ima. Kaykunatami, tukuy runakunata yaĉhachiyanqa shumaq allinlana kasunanpaq, Amitunchik maydiya shamutinqa. ");
INSERT INTO qufNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Chaymanta Zacariasqa, angeltaqa kaynu nir tapuran: —¿Imanutaq kriyishuyta puytiyman kay nimashaykipaqqa? Chaqa nuqaqami kusa rukunari kani, chaynulla warmiypis nuqa yupay kusa rukuna. ");
INSERT INTO qufNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Chaynu nitinqa, angelqa niran: —Nuqaqami Gabriel kani. Dyuspa naypanpimi kani pay nimashanta ruranaypaq. Paymi nuqata kaĉhamaran qamta parlashunaypaq kay shumaq willashushayta. ");
INSERT INTO qufNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Piru kananqa, nuqa willashutiy mana kriyishaykirayku, mudupaqna tikrakanki. Chaymi manana rimayta puytinkichu, kay tukuy nishushaykunaqa allip chay nishaynulla kanankaman. ");
INSERT INTO qufNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Chaykamanqami, Santu Kwartuman mana yaykusha karan chaykunaqa, yarayaranllapa Zacariastaqa. Chaymi paykunalla tapunakuranllapa: “¿Imakurtaq chay rurimantaqa mana das lluqshimun?” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Chaynu niyatinllapapismi, lluqshimuran. Lluqshimurqa, mana imatapis wakinninkunataqa willayta puytiranchu. Chaymi chay waqtapi kaqkunaqa yarpuranllapa, imata rikapakusha kanqa chay ruripiqa nir. Chaqa makinkunalawan rikachikurla parlakuyaran. Chaymi, chaynuna puriran mana rimakurnachu. ");
INSERT INTO qufNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Chaynumapis, Dyusta adurananllapa wasipi rurananpaq karan chaykunataqa rurar tukchirna, riran wasinmanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Chaymantaqa, warmin Elisabetqa ruriyjun rikariran. Chayraykumi, manana lluqshiranchu wasinmantaqa sinku misista, kaynuta yarpur: ");
INSERT INTO qufNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Amituymi munasha wamrayjun kanaypaq, amana runakunaqa, mana wamrakuq warmichu nir ima pinqamananllapapaqnachu”. ");
INSERT INTO qufNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Saysi misismantaqa, Tayta Dyusqa kaĉharan angelnin Gabrielta, Galileapa uk pwiblun Nazaret shutiqman, ");
INSERT INTO qufNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","rir watukunanpaq, uk warmi María shutiqta. Chay warmisitami manaraq mayqan runawanpis punushachu karan. Piru payqami, parlashana karan kasarananpaq, gubyirnu Davidpa uk ayllun José shutiqwan. ");
INSERT INTO qufNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Chayna, chay angelqa María kayashan wasiman yaykurqa, kaynu niran: —Saludashunimi, Dyuspa munashan warmisita, pay Taytituykiqami pullayki kar kuytashun. ");
INSERT INTO qufNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Chaynu nitinmi, María rikarqa kusata manchakur kaynuta yarpuyaq: ¿Ima nishaq nirtaq waknuqa willamayanqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Chaymanta angelqa niran: —María, ama manchakuychu. Chaqa qamqami Tayta Dyuspaqqa kusa munashan kanki. ");
INSERT INTO qufNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Chaymi, ruriyjun rikarinki. Chayna wamrakusturqa, chay wamritutaqa shutichinki Jesús. ");
INSERT INTO qufNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Payqami kusa runa nisha kanqa. Chaymi runakunamapis Unaqmanta Dyuspa Wamran ninqallapa. Chaqa Dyusqami, paytaqa ruranqa unay rukunllapa gubyirnu David yupaylla kusa mantakuq kananpaq. ");
INSERT INTO qufNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Chayna pay mantakunqa tukuy tyimpupaq Israel shutiq pwiblupiqa. Chaynulla chay mantakunanqa, mana tukukanqachu. ");
INSERT INTO qufNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Chaynu nitinmi, Mariaqa kaynu nir tapuran angeltaqa: —¿Imanutaq kayanqa chay willamashaykiqa? Chaqa, nuqaqa manaraq runayjunlamapischu kani. ");
INSERT INTO qufNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Chaynu nir María taputinmi, angelqa niran: —Dyuspa Santu Ispiritunmi, qamman Dyuspa pudirninwan uk puktaysitu yupayla shamur, rurikipi samanqa. Chayraykumi, chay wamran nasiqqa kusa allinla kar, shutinqa Dyuspa Wamran. ");
INSERT INTO qufNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Chaynulla, chay aylluyki Elisabetpismi, wamrakustunqa rukulana kayarmapis. Paytami manana wamrakunqachu nisha katinllapamapis, payqa saysi misispaqna ruriyjun. ");
INSERT INTO qufNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Dyuspaqqami mana imapis, mana ruraypaqqa kanchu. ");
INSERT INTO qufNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Chaynu nitinmiri, Mariaqa kaynu niran: —Nuqaqari Dyuspa sirbiqnin kani. Chaymi, Tayta Dyusniyqa chay nimashaykinullata ruranqa nuqawanqa. María chaynu nitinqami, angelqa riranna. ");
INSERT INTO qufNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Chay diyakunapimi, Mariaqa utqaylla riran, Judeapa uk pwiblun sirkalla lugarninman, Elisabetta watukuq. ");
INSERT INTO qufNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ĉharqami, Zacariaspa wasinman yaykur Elisabetta saludaran. ");
INSERT INTO qufNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","María saludaqta uyapatinqa, Elisabetpa wamritunqa kuyukuran rurinpiqa. Chaymi, Elisabetqa kusa shumaq Dyuspa Santu Ispiritunwanna kidaran. ");
INSERT INTO qufNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Chayrayku, jwirtita rimar, kaynu niran: —Dyusmi masta shumaqchashusha tukuy warmikunamanta. Chaynulla, wamraykitapis shumaqchasha. ");
INSERT INTO qufNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Pitaq nuqaqa kani, Amituypa maman shamur watukumananpaqqa? ");
INSERT INTO qufNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Chaqa, saludamaqta uyapashutiyla, chay kutilla wamrituyqa aligriyar kuyuran ruriypiqa. ");
INSERT INTO qufNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kusa shumaqnami qamqa kanki, Dyus imatami rurayanqa nir willashutin kriyishaykirayku. ");
INSERT INTO qufNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Chaymi, Mariaqa niran: “Tukuy shunquywanmi alabani kusa puytiq Tayta Dyustaqa. ");
INSERT INTO qufNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Yarpuyniypimapis aligriyani Washamaqniy Dyuspaqqa. ");
INSERT INTO qufNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Llakipaypaqla warmisita katiymapismi, Tayta Dyusqa kusa shumaq allinpaq rikaman. Chaymi, kananmantaqa kusa shumaq warmi nishapaqna riqsimanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Chaqa, kusa puytiq karmi, nuqapiqa chay mana ruraypaqta kusa shumaqta rurasha. Payqa kusala shumaq allinla. ");
INSERT INTO qufNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Dyusqami payta kasuqkunataqa, tukuy tyimpupaq llakipan. ");
INSERT INTO qufNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Dyusmi, tukuy pudirninwan imatapis ruraran. Chaymi kusa kani niqkunapa yarpuyashanllapamatapis limpu chinqachiran. ");
INSERT INTO qufNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ashuchiranpismi kargunkunamanta, chay kusa puytiq karguyjunkunata. Ashwan, chay mana runa nishakunatami, kusa runa nishapaqna tikraran. ");
INSERT INTO qufNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Chay mana imayjun kaqkunatami, tukuy imakunata quran. Nataq chay kusala imayjunkunata-shuypaqa, shinalata kaĉharan. ");
INSERT INTO qufNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Yanaparanmi Israel pwiblunmanta payta sirbiqkunata. Chaymi mana qunqarchu, shumaqta llakipar munaran. ");
INSERT INTO qufNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Chaynu kananpaqmi nisha karan unay rukunchikkunata, Abrahamta tukuy aylluntinta”. ");
INSERT INTO qufNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Tukuy kaykunata nir imami, Mariaqa Elisabetwanqa kimsa misista yupay pulla kidaran. Chaymantanami tikrakaran wasinmanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Chaymanta, Elisabetpa wamrakustunan tyimpu ĉhamutinqa, wamrakusturanna ullqituta. ");
INSERT INTO qufNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Chaymi, chay yatanlapi riqsinan taqkuna, chaynulla wakin ayllunkunapis, riranllapa watukuq, Tayta Dyusqa paywan kusala bwinu kasha nir yaĉharllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Chaymi uchu diyayjunna wamritu katin, chay watukuq risha karan chaykunaqa, aparanllapa siñal kustumrita rurananllapapaq. Chaynu rurarnaqa, wamritutaqa taytanpa shutinllawan Zacarías, shutichinaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Piru mamanqa niran: —¡Mana! Wamrayqami shutinqa Juan. ");
INSERT INTO qufNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Chaymantaqa, chaypi kaqkunaqa niran: —Manami mayqanpis aylluykipiqa, chaynu shutiyjunqa kanchu. ");
INSERT INTO qufNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Chaymantaqa, wamrapa taytanta siñalawan tapuranllapa, imanushi shutichinayan nir. ");
INSERT INTO qufNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Chaymi, taytanqa siñalawan mañaran uk tablitata, chaypi iskribinanpaq wamrapa shutintaqa. Chaymi kaynuta iskribiran: “Shutinqami, Juan” nir. Chayta rikarmi tukuy dispantakar kidaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Chaymantaqami, chay kutilla qashan Zacariasqa rimaq qallarir Dyustaqa kusata alabaran. ");
INSERT INTO qufNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tukuy chay wasin yatanlapi taqkunami, dispantakashalla karanllapa. Chaynulla, Judeapa chay sirkalla lugarninkunamanta runakunapis, parlaqllapa tukuy chay pasashankunapaqqa. ");
INSERT INTO qufNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Chaynulla, tukuy chay uyapaqkunapis paykunalla yarpupakuqllapa: “¿Imanuraq kay wamraqa maydiyaqa kanqa?” nir. Chaqa alliptari Tayta Dyusqa tukuy pudirninwan yanapaq chay wamritutaqa. ");
INSERT INTO qufNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Chay, wamrapa taytan Zacariasqa, Dyuspa kusa shumaq Santu Ispiritunwan kar, Dyuspaq rimarmi kaynu niran: ");
INSERT INTO qufNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Kusa shumaqmi Israelmanta runakunapa Dyusnin, Amitunchikqa. Chaqa, shamushamiri pwiblunta washaq. ");
INSERT INTO qufNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Paymi, sirbikuqnin Davidpa ayllunllamanta, uk kusala puytiq runata nuqanchikkunamanqa kaĉhamusha washamanallapapaq. ");
INSERT INTO qufNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kaypaqmi unaykuna pay nishannullata, chay kusa allin rimaqninkuna kaynu nisha karan: ");
INSERT INTO qufNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Payqashi washamashunllapa, kuntramaqninchikkunamanta, chaynulla tukuy ĉhiqnimaqninchikkunamanmatapis. ");
INSERT INTO qufNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Unay rukunchikkunatapis, llakipayanqa. Chaynulla, manashi qunqayanqachu chay tratuta rurar arnikushanmatapis. ");
INSERT INTO qufNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nataq, kaynumi jurar arnisha karan, agwilunchik Abrahamta-shuypaqa. ");
INSERT INTO qufNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Washamayashunllapashi, chay kuntranchikkunamanta, payta sirbinallapapaq ama imatapis mancharchu. ");
INSERT INTO qufNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Chayna paypa naypanpiqa, pay munashannullata rurarqa, kusala allin runana kanallapapaq, maydiyapis kawsayarllaqa. ");
INSERT INTO qufNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nataq qam-shuypaqa, wamrituy, shutinkimi unaq Dyuspa shumaq rimaqnin. Chaqa, qamqami Amituykimantaqa naypaqta rinki, nanninta kamkachiq yupay pay shamunankaman allita rimar yaĉhachikur ima. ");
INSERT INTO qufNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Yaĉhachinkipismi, paypa pwiblunmanta runakunata Dyusmi uchankunamanta pirdunar washanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Chaqa Taytanchik Dyusqami, llakipamanchik kuytamanchik ima. Chaymi unaq syilumanta-pacha washamaqninchikqa shamunqa, uk achkirachikuq yupay. Paymi nuqanchikkunapaqqa, imanutaq uk mushuq diyamaqa kusa llipyalla, chaynu kanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Chaynu shamurmi, yanapanqa chay achkirachikuyninwanqa tutaparaqpi yupay mana allinta rurar kawsaqkunata, shumaq nanninpi puriq yupay tanallapapaq” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Chay wamrituqamiri winayaq, kusala yarpuyniyjun ima. Chaynulla, Israelmanta runakunata yaĉhachiq qallarinankaman, chunllaq lugarkunapi taran. ");
INSERT INTO qufNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Chay tyimpukunapimi, Romapa punta mantakuqnin Augustuqa, kaĉhakusha karan uk sinsuta rurananllapapaq tukuy pachapi. ");
INSERT INTO qufNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kay sinsuqami rurakaran Cirenio shutiq runa, Siria pwiblupa gubyirnun katin. ");
INSERT INTO qufNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Tukuy runakunami uklaw pwiblukunapi tayarmapis, riqllapa pwiblunllapaman chaypina padrunakananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Chayraykumi, Josiqa chay Galileapa pwiblun Nazaretmanta lluqshir, riran paypa pwiblun Belenman, chay Judea pwiblupa gubyirnu David nasishanman. Chaqa Josiqa, Davidpa ayllunmanta karan. ");
INSERT INTO qufNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Josiqami, Mariawan kasarananpaq kasha kar, rurisituyjun katinmapis, pullana riranllapa wakman padrunakananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Chaymi chay Belenpi kayatinllapaqa, Mariataqa itikustunanpaq nanaynin ayparan. ");
INSERT INTO qufNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Chayna, chaylapi punta wamranqa nasikuran. Nasikutinqami, mantillitakunawan liyar usurachiran, animalkuna mikunanpaq uk batyanula parita kaq chaylapi. Chaqa, manari paykunapaqqa samananllapapaq lugar karanchu, chay samananllapa wasipiqa. ");
INSERT INTO qufNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Belenpa yatanlapimi, karanllapa ayka michikuqkuna. Paykunami chaypiqa tukuy tuta uknin uknin turnanakur uyshankunata kuytar taqllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Chaymi chaypi kananllapakamanqa, illaqmanta Dyuspa uk angelnin paykunaman rikariran. Chaynulla, Dyuspa shumaq llipyayninqa kusata achkirachikamuran paykuna kayashanmanqa. Chaymi paykunaqa kusalata manchakuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Chaynu manchakutinllapamapis, angelqa niran: “Ama manchakuyllapachu. Ashwan kusa shumaqta willashuyanillapa chayta uyarmi aligriyankillapa. Chaynulla tukuymi kusata aligriyanqallapapis. ");
INSERT INTO qufNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kananmi Davidpa pwiblunpi, uk washakuq nasisha. Payqami Dyuspa Akrashan Cristun, Amitunchikllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kay nishuyanillapa chayta chiqapta kriyinaykillapapaqqami, uk wamrituta, animal mikunanpa batyanula paritanlapi mantillitawan liyakasha usuraqta tarinkillapa” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Chaynu parlayatinllaparaqqami, syilumanta achka angelkuna chay uk ángel kayashanman rikaritin, Dyusta alabaranllapa kaynu nir: ");
INSERT INTO qufNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“¡Kusa shumaqmi unaq syilupi Dyusninchikqa! ¡Kay pachapi kaqkunataqa, Tayta Dyusqa tukuyta llakipar yanapanqa! ¡Chayna, paykunaqa shumaq allintana kawsanqallapa!” ");
INSERT INTO qufNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Chaymanta chay angelkuna syiluman tikrakatinnaqa, chay michikuqkunaqa paynin paynin ninakuqllapa: “Rishunllapari Belenman rikaq. Chaqa Dyusninchikmapis angelninkunata kaĉhamutin, willamashanchikllapana chaypi imami pasasha nirmapis”. ");
INSERT INTO qufNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Chaynu ninakur utqaylla rirmi, tariranllapa Mariawan Jositaqa wamritunta batyanula paritapi usurachisha taqllapata. ");
INSERT INTO qufNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Rikarnaqami, kusata parlakuq ĉhurakaranllapa chay ángel wamritupaq willashanllapapaqqa. ");
INSERT INTO qufNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Chaymi chay michikuqkuna parlakutinllapaqa, tukuy uyapaqkunaqa, dispantakashalla kidaqllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Chaynu katinmapis, Mariaqami uyarala uyakuran imanu rimatinllapamapis. Chaymi imata uyapar yaĉharmapis, mana qunqaranchu. ");
INSERT INTO qufNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nataq, chay michikuqkunaqa tikrakaranllapa Dyusninchikta alabaqnu, payji niqnu, tukuy chay rikashanllaparayku, uyapashanllaparayku ima. Chaqa, tukuy chaykunamiri, ángel willashanllapanulla pasasha karan. ");
INSERT INTO qufNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Uchu diyamantami, chay siñal kustumrita rurarnaqa, chay wamritutaqa Jesús shutichiranllapa, imanutaq María manaraq ruriyjun katin, ángel nisha karan chaynulla. ");
INSERT INTO qufNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Chaymanta Moisés mantakushannu María itikushanmanta paqakutinnaqa, chay wamritutaqa aparanllapa Jerusalenman. Chayna Dyusta adurananllapa wasiman apar, kay wamrituyqa Dyuspaqna kanqa ninanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(Chaqa, Dyus nitin iskribikashakunapiqami kaynu niq: “Tukuy kulaka ullqu wamrituqashi Dyuspaqna kanqa” nir). ");
INSERT INTO qufNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Chaymi ufrinditanllapata ĉhurar, Tayta Dyusta payji ninanllapapaqqa, ishkay turtulitakunataĉhi manaqachu palumapa ishkay wawituntaĉhi apar riranllapa, Dyus nishanta kumplinanllapapaqqa. ");
INSERT INTO qufNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Chay tyimpukunapimi, Dyuspa Santu Ispiritunwan kar kusala allin runa, Dyusta aduraq Jerusalenpi taq. Paymi shutiq Simeón. Paymi yarakuyaran Dyuspa Akrashan Cristun shamur Israelmanta runakunata washananpaq. ");
INSERT INTO qufNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Chaqa Santu Ispiritumi paytaqa kaynu nir willasha karan: Manaraq wanuyarchu Dyuspa Akrashan Cristunta rikanki nir. ");
INSERT INTO qufNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Chayna, Santu Ispiritu willatin, Simeonqa riran Dyusta adurananllapa wasiman. Chaynulla chay wamrapa taytankunapis wamritunta aparanllapa Dyus mantakushannulla kumplinanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Chaymi, Simeonqa chay wamritutaqa marqakustur, Tayta Dyusta alabar kaynu niran: ");
INSERT INTO qufNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Tayta Dyusniy, kanan-shuypaqa arnimashaykiqa kumplikashana. Nuqa sirbikuqnikitaqa dijamayna shumaqta wanukunaypaq. ");
INSERT INTO qufNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Chaqa rikashanamiri kani qam kaĉhamushayki kay Washakuqtaqa. ");
INSERT INTO qufNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Qamqami tukuy chaykunataqa ruraq qallarishayki tukuy pwiblukunamanta runakuna rikar yaĉhananpaq qammi Washakuqtaqa kaĉhamushayki nir. ");
INSERT INTO qufNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Paymi imanutaq uk achkirachikuq yanapamanchik, chay yupay tukuy runakunata yanapar qampaq intrachinqa. Chaynami yaĉhar alabanqallapa Israel pwiblumantami shamusha Washakuqqa nir”. ");
INSERT INTO qufNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Chaynu Simeón chay wamritupaq nitin Josiwan, maman María uyaparmi kusalata dispantakar kidaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Chaymantaqami Simeonqa Dyusman mañakuran, paykunata shumaqta rikananpaq. Chaymi Jesuspa maman Mariataqa niran: “Tukuy imata, kay wamritu winar Israel pwiblupi ruratinmi, wakinqa paypi kriyir washakanqa. Nataq wakinkuna-shuypaqa, payta mana kriyishanllaparayku, manana Dyuspaqqa allinnachu kanqallapa. Ashwan chaykunata ruratin imami, kuntranqallapa paytaqa. ");
INSERT INTO qufNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Chaynulla achka runakunapa yarpuyashan, rurayashankunamapis, shutiman rikarinqa. Piru tukuy chaykunapaqmi qamqa kusalata llakinki. Chaqa, tukuy chaykunami qampaqqa, uk kuchillu shunquykillaman yaykuq yupay kanqa”. ");
INSERT INTO qufNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Chaynullami Dyus nishankunata rimaq uk ruku warmi Ana shutiqpismi chaypi karan. Payqami, Aserpa ayllunmanta uk runa Fanuelpa wamran kaq. Chaqa kasarasha kayaq kusa shipashlla kar. Piru runawanqami kawsaran syiti añulata. ");
INSERT INTO qufNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Chaymi chay runanmanta wakchayasha warmisitaqa uchintay kwatru añuyjunna karan. Payqami Dyusta adurananllapa wasimantaqa mana ashurchu Dyusman mañakuq tuta katin, unaq katinmapis. Chaynullami ayunaq ima. ");
INSERT INTO qufNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Chaymi, paypis chay kutilla qimikamur qallariran Dyusta payji niq. Chaynullami, tukuy chaypi Jerusalén washakananta munar yarakuqkunatapis willaran: “Jesusmi chay yarayashanllapa Washakuqqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Chaymanta Tayta Dyus mantakushanta tukuyta rurarllapanaqa, tikrakaranllapana Galileaman, chay paypa pwiblun Nazaretman. ");
INSERT INTO qufNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nataq, chay wamraqami winayaran. Chaymi mas jwirti, mas yaĉhaq ima tikrakayaran. Chaynulla Dyusqa kusa shumaqta yanaparan. ");
INSERT INTO qufNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jesuspa taytankunaqa añu añu Jerusalenman riqllapa Pascua fyistaman. ");
INSERT INTO qufNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Chaymi Jesús dusi añuyjunna katinqa paykunaqa tantakar riranllapa fyistamanqa, chaynu riqllapa kar. ");
INSERT INTO qufNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Chaymanta chay fyista pasashana katin, wasinman tikrar riyatinllapanaqa, wamra Jesusqa kidasha karan Jerusalenllapi, taytankunaqa mana kwintata qukatinchu. ");
INSERT INTO qufNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Chaymi, paykunaqa Jesusqashi runakunapa rurinta riyanqa nir yarpur, riranllapa nantaqa uk diyatana. Chaymanta mana rikaritin, riqsinankunata ayllunkunata tapukur ima, mana yaĉharanllapachu maypi wamranqa kanqa nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Chayna mana tarirmi, tikrakaranllapa qashan Jerusalenman, chaypi maskakunanllapapaq Jesuspaqqa. ");
INSERT INTO qufNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Chaymanta maskakur puriyarllapaqa, kimsa diyamanta tariranllapa Dyusta adurananllapa wasipi taqta. Ashwan chay yaĉhar yaĉhachikuqkunawan pulla tayasha karan. Chay paykunaqa, Jesusta tapur uyakur ima tayasha karanllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Chaymi tukuy uyapaqkunaqa dispantakashalla kidaqllapa, kusata yaĉhayashanpaq, tapushanllapata allita willashanllapapaq ima. ");
INSERT INTO qufNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Chaymanta taytankuna rikarqa, dispantakaranllapa. Chaymi mamanqa niran Jesustaqa: —Wamrituy, ¿imapaqtaq kaytaqa ruramashaykillapa? Kusata llakirmi taytaykiwan nuqaqa purisha kanillapa maskashur. ");
INSERT INTO qufNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Chaymantaqa Jesusqa niran: —¿Imapaqtaq maskamayankillapa? ¿Manachu yaĉhankillapa nuqa Taytaypa wasinpi, pay munashankunata ruranaypaq kani nirqa? ");
INSERT INTO qufNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Piru paykunaqa mana intrakaranllapachu imapaqmi chaynu niyan nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Chaymantami Jesusqa tikrakamuran taytankunawan Nazaret pwibluman. Chaypimi payqa taytankuna imata nitinpis kasur rurar ima kawsaran. Mamanqami tukuy chaykunata yaĉharqa, mana imalatapis qunqaqchu. ");
INSERT INTO qufNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesusqami winayaran. Chaynulla kusa yarpuyniyjun tikrakayaran. Chaymi paytaqa kusa shumaqta rikayaran Dyusqa. Chaynulla wakin runakunamapis, kusa shumaqta rikaqllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Kinsi añupaqna Tiberio César mantakuq katin, Zacariaspa wamran Juanta, Dyusqa uk chunllaq lugarpi parlaran yaĉhachikunanpaq. Chaymi chay tyimpukunallapi Poncio Pilato Judeapa gubyirnun karan. Nataq Herodes-shuypaqa Galileapi mantakuq. Chay uknin Felipiqa mantakuq Iturea pachapi, chaynulla Traconite pachapipis mantakuq paylla. Nataq Lisaniaqa mantakuq Abiliniapi. Anaswan Caifás-shuypaqa kurakunapa mantaqnin karanllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Chay tyimpukunapimi Juanqa tukuy chay riyu Jordanpa lugarninkunapi puriran yaĉhachikur, runakunaqa uchanllapata dijarna, Dyusta kasur shutikunanllapapaq. Chayna, Dyusqa uchanllapakunamanta pirdunar washananpaq. ");
INSERT INTO qufNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Juanqamiri chiqapta chaynu yaĉhachikuran, imanuĉhi Dyuspa rimaqnin Isaías kaynu niran chaynulla: “Uk runami kusa jwirtita rimar chunllaqpi nin: ‘Amitunchik Dyuspa nanninta kamakachiyllapa, uchaykillapata dijar Dyusta kasurllapana. Chaynuqami kusa dirichula nanta kiĉhaq yupayna kankillapa kanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tukuy pukrukuna pampalla kidanqa. Tukuy qaqakuna, sirkakunapis shumaq pampalla kanqa. Qinqulla nankuna kaqkunapis dirichakanqa. Nankuna uĉhku uĉhku kaqkunapis pampalla tikrakanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tukuy pachapi runakunami rikanqallapa Dyus Washakuqninta kaĉhamutinqa’ ”. ");
INSERT INTO qufNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Isaías nishannulla runakuna Juan shutichinanpaq lluqshimutinqa, payqa niyaq: “¡Largu kurukunapa ayllunkuna! ¿Chay manchaypaq kastigumanta washakayashunllapa nirchu yarpuyankillapa? ");
INSERT INTO qufNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Chaynu yarpuyarqa Dyusninchikpinari chiqapta kriyiyllapa, yaĉhananllapapaq chiqapta uchaykillapata dijar, Dyusninchikta kasunkillapana nir. Ama qamkunallaqa alabakayllapachu ‘Abrahampa ayllun kar washakayanchikllapa’ nirqa. Chaqa allita nishaykillapa: Dyus munarqami kay rumikunamatapis, Abrahampa ayllunpaq tikranarqa, tikranman. ");
INSERT INTO qufNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Achapismi listuna qirukunata ĉhupanmanta kuchunanpaqqa. Chaqa tukuy qiru mana allita puquqtaqa, kuchur itakunqa ninaman”. ");
INSERT INTO qufNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Chaynu Juan rimatinqa, chay runakunaqa niranllapa: — Chaqa, ¿imatataq rurashaqllapa ama kastigamananllapapaqqa? ");
INSERT INTO qufNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juanqa paykunata niran: — Mayqannikillapapis ishkay raĉhpayjun kaq, mikunayjun kaqpis, quyllapa uk mana kaqniyjunta. ");
INSERT INTO qufNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Chay Romapaq wakin impwistuta kubrakuqkunapismi qimikaranllapa, shutikunanllapapaqqa. Chaymi Juantaqa kaynu nir tapuranllapa: —Yaĉhachikuq Taytituy, ¿imatataq rurashaq nuqakunaqa? ");
INSERT INTO qufNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Chaymi Juanqa chaykunatapis niran: —Ama kubrakuyllapachu mastaqa, chay kubrakushaykillapamantaqa. ");
INSERT INTO qufNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Chaymantaqa chaynulla wakin suldadukunapis tapuranllapa Juantaqa: —Nuqakuna-shuypaqa, ¿imatataq rurashaqllapa? nir. Chaymi Juanqa paykunataqa niran: —Ama mayqantapis yanqallamanta imanta kitayllapachu. Chaynulla ama yanqallamantaqa uchachayllapachu. Chay michkataĉhi ganankillapa chaywanqa kuntintakayllapana. ");
INSERT INTO qufNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Runakunaqami kusalata rikakuyaranllapa tapunakurllapa, imanupiqa Juan kanman Dyuspa Akrashan Cristunqa nir. ");
INSERT INTO qufNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Piru Juanqa paykunataqa niran: “Chiqaptami nishaykillapa: Nuqaqami shutichikuni yakulawan. Nataq uk shamur-shuypaqami shutichikunqa Santu Ispirituwan, ninawan ima. Payqami kusa mas puytiq nuqamantaqa. Nuqaqa paypa naypanpiqa mana sirbinichu llanqinpa watunta kaĉhanaypaqlamapis. ");
INSERT INTO qufNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Chay payqamiri apamuyan urkitanta makinpi charikur triguta akrananpaq pajanmanta. Chaynu shumaqcharqami chay trigutaqa ĉhuranqa ĉhurakunanpi. Nataq pajanta-shuypaqa rupachinqa. Chay ninaqami ratakurqa mana wanunqachu”. ");
INSERT INTO qufNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Chaynumiri shumaqta willar, Juanqa yaĉhachikuran imanumi Washakuq shamuq chayqa kanqa nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Chaynullami chay gubyirnu Herodesta-shuypaqa anyaran, uknin Felipipa warmin Herodiaswan kayashanrayku, chaynulla tukuy wakin mana allin rurayninkunapaqpis. ");
INSERT INTO qufNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Piru ashwan Herodesqa, chay tukuy mana allinkunata rurashanpaq anyatinqa, ukmanta yarpur Juantaqa karsilachiran. ");
INSERT INTO qufNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Piru manaraq karsilpi kayar Juan kusa achka runakunata shutichiyatinqa, Jesuspis riran shutikuq. Chaynu shutikur Taytanman mañakuyatinqa syiluqa kiĉhakaran. ");
INSERT INTO qufNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Chaymi Dyuspa Santu Ispiritunqa Jesusman ishkimuran kusa rikaypaqla, uk palumitanu. Chaymi syilumanta-pacha Dyus kaynu niqta uyaparan: ");
INSERT INTO qufNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Amitunchik Jesucristo yaĉhachikuq qallarirqami trinta añuyjunmana kasha kanqa. Niqllapa Amitunchik Jesucristuqashi Josipa wamran nir. José-shuypaqa, Elipa wamran nir. ");
INSERT INTO qufNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eliqa, Matatpa wamran. Matatqa, Levipa wamran. Leviqa, Melquipa wamran. Melquí-shuypaqa, Janapa wamran karan. Nataq Janaqa, Josipa wamran. ");
INSERT INTO qufNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josiqa, Matatiaspa wamran. Matatiasqa, Amospa wamran. Amosqa, Nahumpa wamran. Nahumqa, Eslipa wamran. Esliqa, Nagaipa wamran. ");
INSERT INTO qufNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaiqa, Maatpa wamran. Maatqa, Matatiaspa wamran. Matatiasqa, Semeipa wamran. Semeiqa, Josipa wamran. Josiqa, Judapa wamran. ");
INSERT INTO qufNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judaqa, Joanapa wamran. Joanaqa, Resapa wamran. Resaqa, Zorobabelpa wamran. Zorobabelqa, Salatielpa wamran. Salatielqa, Neripa wamran. ");
INSERT INTO qufNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri-shuypaqa, Melquipa wamran karan. Melquiqa, Adipa wamran. Adiqa, Cosampa wamran. Cosamqa, Elmodampa wamran. Elmodamqa, Erpa wamran. ");
INSERT INTO qufNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Erqa, Josuepa wamran. Josueqa, Eliezerpa wamran. Eliezerqa, Jorimpa wamran. Jorimqa, Matatpa wamran. ");
INSERT INTO qufNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matatqa, Levipa wamran. Leviqa, Simeonpa wamran. Simeonqa, Judapa wamran. Judaqa, Josipa wamran. Josiqa, Jonanpa wamran. Jonanqa, Eliaquimpa wamran. ");
INSERT INTO qufNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquimqa, Meleapa wamran. Meleaqa, Mainanpa wamran. Mainanqa, Matatapa wamran. Matataqa, Natanpa wamran. ");
INSERT INTO qufNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán-shuypaqa, Davidpa wamran karan. Davidqa, Isaipa wamran. Isaiqa, Obedpa wamran. Obedqa, Boozpa wamran. Boozqa, Salmonpa wamran. Salmonqa, Naasonpa wamran. ");
INSERT INTO qufNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasonqa, Aminadabpa wamran. Aminadabqa, Adminpa wamran. Adminqa, Arnipa wamran. Arniqa, Esrompa wamran. Esromqa, Farespa wamran. Faresqa, Judapa wamran. ");
INSERT INTO qufNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judaqa, Jacobpa wamran. Jacobqa, Isaacpa wamran. Isaacqa, Abrahampa wamran. Abraham-shuypaqa, Taripa wamran karan. Tariqa, Nacorpa wamran. ");
INSERT INTO qufNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacorqa Serugpa wamran. Serugqa, Ragaupa wamran. Ragauqa, Pelegpa wamran. Pelegqa, Heberpa wamran. Heberqa, Salapa wamran. ");
INSERT INTO qufNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salaqa Cainanpa wamran. Cainanqa, Arfaxadpa wamran. Arfaxadqa, Sempa wamran. Sem-shuypaqa, Noepa wamran karan. Noeqa, Lamecpa wamran. ");
INSERT INTO qufNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamecqa, Matusalenpa wamran. Matusalenqa, Enocpa wamran. Enocqa, Jaredpa wamran. Jaredqa, Mahalaleelpa wamran. Mahalaleelqa, Cainanpa wamran. ");
INSERT INTO qufNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán-shuypaqa, Enospa wamran karan. Enosqa, Setpa wamran. Setqa, Adanpa wamran. Nataq Adanta-shuypaqa Tayta Dyusmi ruraran. ");
INSERT INTO qufNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesusqa Santu Ispirituwan kar tikrakamuran riyu Jordanmantaqa. Chaynu Santu Ispiritu yapatinmi, Jesusqa riran chunllaq lugarman. ");
INSERT INTO qufNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Chaypiqami kwarinta diyata karan. Chaymi chay diyakunaqa ayunar mana imalatapis mikushanrayku kusalata mallaqnaran. Chaynu mallaqnatin, dyabluqa imanullapis Jesustaqa uchakuchinaran. ");
INSERT INTO qufNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Chaymi niran: —Chiqapta Dyuspa Wamran karqa, kay rumita willay tantapaq tikrakananpaq nir. ");
INSERT INTO qufNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Piru Jesusqa niran: —Dyus nitin iskribikashakunapimi nin: ‘Manami tantalamantachu runaqa kawsayta puytin. Ashwanmi Dyuspa tukuy rimayninta kasur kawsanqa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Chaymanta-shuypaqami dyabluqa Jesustaqa aparan kusala unaq sirkaman. Chaymantami dasla kay pachapa tukuy pwiblunkunata rikachir niran: ");
INSERT INTO qufNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","—Nuqaqami qushayki tukuy kay imakuna kay pachapi kaqtaqa, qamna mantakunaykipaq. Chaqa, nuqapami tukuy kaykunaqa. Chay-ari mayqantapis qushaq qunashaytaqa. ");
INSERT INTO qufNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Chayrayku, qunqurir nuqata aduramatkiqami tukuy chay rikayashaykikunaqa qampaq kanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesusqa niran: —¡Ashuy dyablu! Chaqa Dyus nitin iskribikashakunapimi nin: ‘Adurar sirbiy Amituyki Dyuslata’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Chaymantami dyabluqa Jesustaqa aparan Jerusalén pwibluman. Chaypiqami Dyusta adurananllapa wasipa kusa unaqninman iqachir niran: —Chiqapta Dyuspa Wamran karqa, kaymanta uraman kaĉhakay. ");
INSERT INTO qufNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Chaqa Dyus nitin iskribikashakunapimi, nin: ‘Dyusqashi angelninkunata kaĉhamunqa kuytashur washashunanpaq. ");
INSERT INTO qufNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Chaynulla aypashuyanqashi ĉhakikimapis ama ĉhachikananpaq ima rumilawanmapis’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Chaynu nitinmi, Jesusqa niran: —Dyus nitin iskribikashakunapimi ninpis: ‘Amami Amituyki Dyus nishanllata rurachir pukllaychu’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Chaymanta-shuypaqami dyabluqa manana imanupis Jesusta uchakuchiyta puytirnaqa, ashuranna paymantaqa ayka diyallataqa. ");
INSERT INTO qufNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesusqami qashan Galileaman tikrakaran Santu Ispiritupa pudirninwan karna. Chaymi chay lugarkunapa ridurninkunapiqa paypaqqa kusalata yaĉharanllapana. ");
INSERT INTO qufNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Chaqa payqami tukuy chay tantakananllapa wasikunapi yaĉhachikuq. Chaymi tukuyla paytaqa alabaqllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Chaymantami Jesusqa chay maypiĉhi kriyakasha karan, pwiblun Nazaretllaman riran. Chaymi samana diyapiqa chay tantakananllapa wasiman yaykuran paypa kustumrin kashanrayku. Chaymantami shariran Dyus nitin iskribikashakunata liyinanpaq. ");
INSERT INTO qufNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Chaymi Dyuspa rimaqnin Isaías iskribishanta makyatinllapa kiĉharqa, kaynu niqta tarir liyiran: ");
INSERT INTO qufNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Nuqapimiri Dyuspa Ispiritunqa. Chaqa pay akramarmi kaĉhamasha chay mana imayjunkunata Dyuspa shumaq rimayninta yaĉhachinaypaq. Kaĉhamashapismi kwashalla kaqkunata kunsulanaypaq. Chaynullami kaĉhamasha dyablupa makinpi kaqkunata washanaypaq, syigukunata rikakuchinaypaq, qischakaqkunata washanaypaq ima. ");
INSERT INTO qufNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Kaĉhamashapismi Dyusqa tukuylata yanapananpaq tyimpuqa ĉhamushana nir yaĉhachikunaypaq”. ");
INSERT INTO qufNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Chaynu nirnaqa Jesusqa chay iskribikashataqa pillur, chay tantakananllapa wasipi yanapakuqta qur payqa taran. Nataq tukuy chaypi kaqkunaqami kusalata paytaqa chapayaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Chaymi payqa rimaq qallariran kaynu nir: —Dyus nitin iskribikashanta liyishayqami kananlla qamkunapa naypaykillapapi nuqawan kumplikashana. ");
INSERT INTO qufNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Chaynu nir kusa shumaqta rimashanraykumi, chay uyakuqkunaqa dispantakashalla Jesuspaqqa kusa allinta rimayaranllapa. Piru chaynu rimarmapis yaqqa mana kriyinar paykunapura kaynu nir tapunakuyaqllapa: —¿Manachu kayqa Josipa wamran? nir. ");
INSERT INTO qufNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Chaynu yarpuyatinllapamiri, Jesusqa paykunataqa niran: —‘Rimidyakuq tayta, qamraq rimidyakay’ nishanllapanullami nimayankillapa kanqa. Chaynullami nimayankillapapis kanqa: Capernaumpi kwichka achka imakunata rurashayki nir uyapashayllapatami kay pachaykipipis ruray kriyinayllapapaq, nir. ");
INSERT INTO qufNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","“Chiqaptami nishaykillapa: Mayqanpis Dyuspa rimaqnin katinqa, manami pwiblunllapiqa shumaqta rikanllapachu nir. ");
INSERT INTO qufNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Alliptami nishaykillapapis: Dyuspa rimaqnin Eliaspa tyimpunpimi kimsa añu-y-midyuta tamya mana karanchu. Chaymi tukuy Israel pwiblupiqa kusala mallaq tyimpu karan. Chaynullami chaypiqa achka byuda warmikuna karanllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Piru chaynu katinmapis Dyusqa Eliastaqa mana Israelmanta chay byudakunamanchu kaĉharan. Ashwanmi paytaqa kaĉharan Sarepta pwiblumanta uk byuda warmiman. Chayqami Sidón pwiblupa shipchanlapi kaq. ");
INSERT INTO qufNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Chaynullami Israel pwiblukunapipis karan achka qishaq ismuyaq runakuna, Dyuspa rimaqnin Eliseupa tyimpunpiqa. Chaynu katinmapis, mana mayqantapis allicharanchu. Ashwan Siria pwiblumanta Naamán shutiq runalata allicharan” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Chaynu chaykunata uyarllapami, chay tantakananllapa wasipi kaq runakunaqa tukuyla kusata piñakuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Chaymi sharir Jesustaqa chay pwiblumantaqa aparanllapa chay pwiblu rurakashapa qichqalanpi pata karan chayman, chay patamantana itakunanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Piru ashwan Jesusqa chaynu ruranayatinllapamapis ĉhaypinllapata pasar riran. ");
INSERT INTO qufNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesusqami riran Galileapa pwiblun Capernaumman. Chaymi samana diyakunapiqa runakunata yaĉhachiq. ");
INSERT INTO qufNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Chaynu yaĉhachikutinmi kusa dispantakashalla kidaqllapa. Chaqa kusata paylla mantakur imami yaĉhachikuran. ");
INSERT INTO qufNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Chay tantakananllapa wasipiqami, kayaq uk runa dyablupa yarpuyninwan. Chayqami kusa jwirtita kaynu qayĉhakuq: ");
INSERT INTO qufNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Ay! Nazaretmanta Jesús, ¿imapaqtaq nuqakunaman yakapakanki? ¿Ima, chinqachimaqllapachu shamushayki? Nuqaqami riqsishuni. ¡Qamqami Dyuspa Santu Wamran kanki! nir. ");
INSERT INTO qufNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Chaynu nitinmi, Jesusqa anyaran dyablupa yarpuynintaqa kaynu nir: —¡Upallalla yarquy kay runamantaqa! Chaynu Jesús nitinqami, chay dyablupa yarpuyninqa yarquranna runamantaqa. Tukuy runakunapa naypanpimi chay runataqa ratachir mana imanachirlapischu yarquran. ");
INSERT INTO qufNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Chayta rikarmi, tukuyla runakuna kusa dispantakashalla ukninllapa ukninllapa kaynu ninakuyaqllapa: “¿Ima rimaykunataq kaykunaqa? Chaqa pudirninwan kusata paylla mantakur, imami willan dyablu chay runamanta yarqunanpaqqa. ¡Chaynu willatinmi paykunaqa yarqun!” ");
INSERT INTO qufNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Chaynu nir rimatinllapami tukuyla chay lugarpa pwiblitunkunapi Jesuspaqqa kusalata rimaqllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesusqa tantakananllapa wasimanta yarqurqa, rir yaykuran Simonpa wasinman. Chaypimi Simonpa swigran qishaq kusa rupapi karan. Chaymi Jesusta rugaranllapa alliyachinanpaq. ");
INSERT INTO qufNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesusqami payman qimikar chay rupataqa wakaq tukuy niran. Chaynu nitinmi chay rupaqa dijaranna. Chaymantami ashwan chay kutilla, warmisitaqa sharikur paykunata qaraqna qallariran. ");
INSERT INTO qufNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Rupay chinqatinnaqa, tukuy riqchaq qishaywan kaqninkunata Jesusman apamuranllapa. Chaymi makinkunata paykunapa ananman ĉhurarlla allicharan. ");
INSERT INTO qufNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Chaynullami achka runakunamanta dyablupa yarpuyninkunapis yarquran, kaynu qayĉhakur: —¡Qamqami Dyuspa Wamran kanki! nirlla. Chaynu nitinllapami Jesusqa anyar, mana dijaranchu rimananllapapaqqa. Chaqa chay dyablupa yarpuyninkunaqami yaĉhayaranllapa payqa Dyuspa Akrashan Cristun nir. ");
INSERT INTO qufNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Chaymanta allaqnin achkiyayatinnaqa Jesusqa sharir, chay pwiblumanta lluqshir riran chunllaq lugarmanna. Piru runakunami kusalata maskar rir, ĉharanllapa pay kayashanmanqa. Chaymi Jesustaqa chaylapi kidananta munaranllapa, ama rirnachu. ");
INSERT INTO qufNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Chaymi Jesusqa niran: —Ashwanmi Dyusqa imanumi mantakun nir shumaq rimananta uklaw pwiblukunapipis yaĉhachikunaypaq kani. Chaqa chaypaqmi shamusha kani nir. ");
INSERT INTO qufNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Chaynumi Jesusqa chay Israel runakuna tantakananllapa wasikunapi, Galilea lugarkunapi ima Dyuspa shumaq rimanantaqa yaĉhachikur puriyaran. ");
INSERT INTO qufNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Uk diyapimi, Jesusqa Genesaret quĉhapa manyanpi karan. Chaymanmi kusala achka runakuna, Dyus nishanta yaĉhachikutin uyakuyta munashanrayku tantakamur limpu kiĉhkichiranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Chaymantami Jesusqa rikaran ishkay yaku karrukunata quĉhapa rurinpi kaqta. Chay yaku karrukunaqami shinala karan, piskadukuqkuna atun shikranllapata paqaq ishkishanrayku. ");
INSERT INTO qufNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Chaymi Jesusqa iqaran uk yaku karruman. Chayqami Simonpa karan. Chaymi Simontaqa mañaran, yaku karrunta ashlila yakukaq sikpachinanpaq. Chaypinami Jesusqa tar, tukuy chaypi kaqkunataqa yaĉhachiran. ");
INSERT INTO qufNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Chaymanta rimar tukchirnaqa Simonta niran: —Kay yaku karruykitaqa quĉhapa mas ĉhaypinkaqman apar, chaymanta chay atun shikraykillapata itakuyllapa piskaduta aypanaykillapapaqqa, nir. ");
INSERT INTO qufNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simonqa niran: —Yaĉhachikuq Taytituy, tukuy tuta piskadukurmapis, manami uklamatapis aypashachu kanillapa. Piru qam nimashaykinullami atun shikrayllapakunataqa yakuman itashaq. ");
INSERT INTO qufNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Chaynu Jesús nishannulla rurarqami, allipla achkata piskadutaqa ayparanllapa. Chaymi atun shikrankunamapis llikikayaranna. ");
INSERT INTO qufNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Chaymantami chay uk yaku karrupi piskadukuq masinkunata qayaran shamur yanapananllapapaq. Chaymi ishkantin yaku karruman untachitinllapami, ashwan ishkantin yakumanqa chinqayaranllapana kusala achka piskadu kashanrayku. ");
INSERT INTO qufNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Chaynu milagruta rikarqami Simón Pedruqa, Jesuspa naypanlapi qunqurikur, kaynu niran: —Taytituy, ¡nuqami kusala uchasapa kani! ¡Chaymi rugashayki rikunaykipaqna naypaymantaqa! nir. ");
INSERT INTO qufNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Chaynuqami Simonqa niran, wakinninkunawan kusala achka piskaduta aypashanrayku manchakusha kar. ");
INSERT INTO qufNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Chaynullami Zebedeupa wamrankuna Santiaguwan Juanpis kusalata manchakusha karanllapa. Paykunami Simonpa kumpañirun karanllapa. Piru Jesusqa Simontaqa niran: —Ama manchakuychu. Ashwanmi kananmantaqa piskaduta aypaq yupayna runakunata nuqapaq yaĉhachir tantanki nir. ");
INSERT INTO qufNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Chaynu Jesús nitinqami, chay kutilla yaku karrunllapataqa quĉhapa manyanman apar, tukuy imanllapata dijar, utqaylla riranllapa Jesuswanna. ");
INSERT INTO qufNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Uk diyapi Jesús uk pwiblupi katin, ĉharan uk kusa qishaq ismuyaq kwirpuyjun runa. Chaypimi Jesusta rikarqa, pachakaman pukĉhirar kaynu nir rugaran: —¡Taytituy! llakipamayarqa allichamay-ari kay qishayniymantaqa nir. ");
INSERT INTO qufNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Chaymantami Jesusqa makinwan kamar, kaynu niran: —Munayanimi alliyanaykita. ¡Kananlla alliyay! nir. Chaynu nitinlami, chay runaqa alliyaran qishayninmantaqa. ");
INSERT INTO qufNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Chaymi Jesusqa niran: —Amami mayqantapis willankichu. Ashwanmi rir qimikay kurakunaman. Chaymi apanki ufrinditaykita Moisés mantakushannulla. Chayna tukuy yaĉhananllapapaq qishaynikimantaqa alliyashaykina nir. ");
INSERT INTO qufNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Chaynu upallala kananta munatinmapis, Jesuspaqqa kusa achka runakunana yaĉhayaranllapa, payqa imatapis rurayta puytin nir. Chaymi kusa achka runakuna Jesusmanqa tantakaqllapa, qishayninkunamanta alliyananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Piru Jesusqa paykunamanta ashur chunllaq lugarkunaman riq Taytanman mañakuq. ");
INSERT INTO qufNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Uk diyapi Jesús yaĉhachikuyatin, chaykunapiqa tayaranllapa wakin fariseo runakuna, Moisés mantakushanta yaĉhar yaĉhachikuqkuna ima. Paykunaqa shamusha karanllapa, Galileapa, Judeapa, Jerusalenpa tukuy pwiblunkunamanta. Dyuspa pudirnintaqami rikayaranllapa, Jesús qishaqkunata alliyachitin ima. ");
INSERT INTO qufNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Chaymantaqa ĉharanllapa runakuna uk paritapi mana kuyuyta puytiq runata apar. Wasipa rurinman yaykuchirmi, Jesuspa naypanpi usurachinayaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Piru mana maytapis yaykuchiyta puytiqllapachu, kusa unta runakuna katinllapa. Chaymi iqaranllapa wasipa ananman. Chaymantaqa chay wasipa qatananta uĉhkuta rurar, chaylata chay mana kuyuyta puytiq runataqa ishkichiranllapa Jesuspa naypanmanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Chaymantaqa Jesusqa nuqapi kusata kriyinllapa nir yaĉharqa, kaynu niran: —Taytituy, tukuy uchakushaykikunamanta pirdunashushana kani nir. ");
INSERT INTO qufNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Chaynu Jesús nitinqa, Moisés mantakushanta yaĉhar yaĉhachikuqkuna, chaynulla fariseukunaqa yarpupakuq qallariranllapa: ¿Imataq payqa chaynu rimananpaqqa? Wakqachu Dyusninchiknulla tukunayan. Manami allinchu chaynuqa. Chaqa Dyuslari uchakunamanta pirdunakuytaqa puytin nir. ");
INSERT INTO qufNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Piru Jesusqami yaĉhayaran, imatami chay runakunaqa yarpuyan nirmapis. Chaymi kaynu nir tapuran: —¿Imapaqtaq qamkunaqa chaynuta yarpunkillapa? ");
INSERT INTO qufNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Imataq mas trabajusu ruranaypaq, ‘Uchaykikunamantami pirdunashuni’ ninaypaq, manaqachu ‘Sharir puriy’, ninaypaq? ‘Uchaykikunamanta pirdunashuni’ nitiyqa, qamkunaqa mana kriyinkillapachu. ");
INSERT INTO qufNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Piru kananllami intrachishaykillapa Dyusmanta Shamuq Runaqami kay pachapiqa paylla puytin uchanllapakunamanta pirdunakuytaqa nir. Chaynu nirnaqami chay mana kuyuyta puytiq kwirpuyjun runataqa niran: —Qamtami nishuni: Sharir paraykita apar, riy wasikiman nir. ");
INSERT INTO qufNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Chaynu Jesús nitinlami tukuypa naypanpi das sharir, chay usurayashan paritanta apar riran wasinman, Dyusta alabaqnu. ");
INSERT INTO qufNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Chaynu chay milagruta rikarmi chaypi kaqkunaqa kusa dispantakashalla kidar, Dyusninchiktaqa alabaranllapa kaynu nir: “Kananqami kusa ukman shumaqkunata rikashanchikllapa” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Chaymanta Jesusqa waqtaman lluqshirqa, rikaran Romapaq impwistuta kubrakuq runata. Payqami shutiq Leví. Payqami chay impwistuta kubrakunanpi tayaran. Chaymi Jesús rikarqa niran: —Shamuy nuqawan rishun nir. ");
INSERT INTO qufNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Chaynu nitinqa Leviqa sharir, tukuy iman kaqkunata chaypi dijarna, Jesuspa pullan riran. ");
INSERT INTO qufNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Chaymantaqami Leviqa wasinpi ruraran uk fyistata, Jesusrayku. Chaymi achka wakinnin Romapaq impwistuta kubrakuqkunapis wakin runakunawan pulla misapi tayaranllapana. ");
INSERT INTO qufNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Piru chay fariseukuna, chaynulla Moisés mantakushanta yaĉhar yaĉhachikuqkunaqa piñakur, Jesuspa yaĉhakuqninkunataqa anyaqnulla, kaynu niran: —¿Imapaqtaq mikunkillapa, upyankillapa, chay impwistuta kubrakuqkunawan chaynulla uchasapakunawan pullaqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Chaynu nitinllapami, Jesusqa paykunataqa niran: —Allilan kar mana qishaq kaqkunaqami mana ministinchu rimidyakuqtaqa. Chaymi ashwan chay qishaq kaqkunala ministin rimidyakuqtaqa. ");
INSERT INTO qufNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Chaqa nuqaqami mana, chay allinla kani niqkunapaqchu shamusha kani. Ashwanmi shamusha kani, chay uchayjunkunata willatiy kriyir, uchanllapata dijarna washakananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Kaynumi Jesustaqa niranllapa: —Juanpa yaĉhakuqninkuna, fariseukunapa yaĉhakuqninkunapis kusata ayunar, Dyusman mañakunllapa. Piru qampa yaĉhakuqnikikuna-shuypaqa maydiyapis mikunllapa, upyanllapa ima. ");
INSERT INTO qufNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesusqa paykunataqa niran: —Qamkunaqachu uk kasaraq runa chayllapiraq katinqa chay pullan kaqkunata, ¿‘Ayunay’ ninkimanllapa? ");
INSERT INTO qufNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Piru chay kasarasha rinanpaq urami ĉhamunqana. Chaynu ritinna-shuypaqa ayunanqallapana. ");
INSERT INTO qufNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Chaynullami Jesusqa kay kumparasyunkunatapis parlaran: “Manami mayqanpis uk mushuq raĉhpata kuchur, makwa mudananta rimindanchu. Chaqa chaynu rurarqami yanqallana chay mushuq raĉhpataqa dañayan. Chaynullami chay mushuq raĉhpawan, makwa raĉhpata rimindashaqa mana shumaqnachu kidan. ");
INSERT INTO qufNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Chaynulla, chay ubapa yakun mushuq binutaqa manami itanchikchu makwa qara kapachumanqa. Chaqa chay ubapa yakun binuqami byijuyar makwa qara kapachutaqa llikinman. Chaynuqami ashwan ubapa yakun binu chaynulla chay qara kapachupis yanqallana tukukanman. ");
INSERT INTO qufNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Chayraykumi, ubapa yakun mushuq binutaqa mushuq qara kapachumanna itaypaq. ");
INSERT INTO qufNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nishaykillapapis: Mayqan runapis ubapa yakun binu byijuyashata upyayarqa, mananami chay ubapa yakun mushuq binutaqa upyaytaqa munannachu. Chaqa ninmi: Chay byijuyasha chaymi, kusala mishki nir”. ");
INSERT INTO qufNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Uk diyami samana diya katin, Jesusqa riyaran tarpukashakunapa rurinta. Chaymi, yaĉhakuqninkuna riqnuqa trigupa ispigankunata pitir qaqur murintaqa mikuyaqllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Chaymi chaymantaqa, wakin fariseo runakunaqa kaynu nir tapuranllapa: —¿Imapaqtaq chay samana diyapi mana ruraypaqkunataqa, rurankillapa? nir. ");
INSERT INTO qufNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Chaynu nitinllapami, Jesusqa niran: —¿Manachu qamkunaqa liyishaykillapa, uk kuti gubyirnu David wakinninkunawan mallaqnar imanu tukuran nir iskribikashantaqa? ");
INSERT INTO qufNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Chaqa Davidmi wakinninkunawan Dyusta adurananllapa tuldu wasiman yaykur, Dyuspa kaq turtillankunata aypar mikuranllapa. Allita yaĉhashanchikllapanu, chay turtillakunataqami, kurakunala mikunanllapapaqqa kaq. ");
INSERT INTO qufNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jesusqami niranpis: —Dyusmanta Shamuq Runami, chay samana diyapiqa imata ruraypaq chaynulla mana ruraypaqchu niytaqa puytin. ");
INSERT INTO qufNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Qashanmi uk samana diyapi, Jesusqa tantakananllapa wasiman yaykur yaĉhachikuq qallariran. Chaypimi karan uk runa allilaw makin wiqru. ");
INSERT INTO qufNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Piru chaypiqami Moisés mantakushanta yaĉhar yaĉhachikuqkuna, chay fariseo runakunaqa kusalata Jesustaqa chapar ninakuyaranllapa: “¿Ima kay samana diyapichu alliyachiyanqa wak wiqru makiyjun runataqa? Chayta ruratinqami, chaylapaqna uchachashunllapa” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Piru Jesusqa yaĉharan imatami yarpuyanllapa nirmapis. Chaymi, chay wiqru makiyjun runataqa niran: —Sharir, ĉhaypinllapapi shay. Chaynu nitinqa chay runaqa das sharan. ");
INSERT INTO qufNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Chaymi Jesusqa chay runakunataqa niran: —Ma tapushaykillapa, samana diyapiqa, ¿allin kaqtachu ruranchik manaqachu mana allin kaqta? Chaynulla ¿allinchu kanqa allichar washakunapaq manaqachu dijasha wanunanpaq? ");
INSERT INTO qufNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Chaynu nirnaqa, tukuy chay ridurninpi kaqkunata chapar, chay wiqru makiyjun runataqa, niran: —Makikita chutarachiy. Chaynu nitinmi, chay runaqa nishannullata ruraran. Chaymi makinqa allinna kidaran. ");
INSERT INTO qufNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Piru chay runakunaqami ashwan kusalata piñakur ninakuranllapa: “¿Imatataq Jesustaqa rurashunllapa?” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Chay diyakunapimi, Jesusqa riran uk sirkaman mañakuq. Chaymi tukuy tuta Dyusman mañakuyar yurqaran. ");
INSERT INTO qufNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Chaymanta achkiyatinnaqa, tukuy yaĉhakuqninkunata qayamur dusilata akraran. Chaymi paykunataqa niran: “Apustulniykunana kankillapa” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Kaykunami karanllapa: Ukqami Simón karan. Payllatami shutichiranpis Pedro nir. Ukqa karan Simonpa uknin Andrés. Wakinkunaqa karanllapa: Santiago, Juan, Felipe, Bartolomé, ");
INSERT INTO qufNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Alfeupa wamran Santiago, Simón Zelote, ");
INSERT INTO qufNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Santiagupa uknin Judas ima. Uk-shuypaqa karan Judas Iscariote. Kaymi Jesustaqa kuntrankunaman qukuran wanuchinanllapapaqqa. ");
INSERT INTO qufNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Chaymanta Jesusqa chay sirkamanta paykunawan ishkimurqa, uk pampapi kidaranllapa. Chaqa chaypiri tukuy yaĉhakuqninkuna chaynulla kusala achka runakuna karanllapa. Paykunaqami shamusha karanllapa, Judeamanta, Jerusalenmanta, mar manyan Tirumanta, Sidonmanta ima Jesusta uyakuq, chaynulla qishayninllapamanta alliyananllapapaq ima. ");
INSERT INTO qufNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Chaymi chay dyablupa yarpuyninwan kaqkunapis alliyaqllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Chaynumi Jesustaqa tukuyla kamanayaqllapa alliyananllapapaq. Chaqa tukuy payta kamaqkunataqari pudirninwan alliyachiq. ");
INSERT INTO qufNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Chaymantami Jesusqa yaĉhakuqninkunata chapar kaynu niran: “Kusa shumaqmi kankillapa qamkuna mana imayjun kaqkunaqa. Chaqa qamkunapaqnami Dyuspa mantakuyninqa. ");
INSERT INTO qufNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kusa shumaqmi kankillapa qamkuna kanan mallaqnaqkunaqa. Chaqa maydiyaqami untana mikunkillapa. Kusa shumaqmi kankillapa, kanan waqaqkunaqa. Chaqa maydiyaqami aligriyar asikunkillapana. ");
INSERT INTO qufNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kusa shumaqmi kankillapa Dyusmanta Shamuq Runarayku mana allinpaq riqsishutinllapa, ĉhiqnishutinllapa, mana munar mana pullakushutinllapa, musyashutinllapa imaqa. ");
INSERT INTO qufNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Chaynu rurashutinllapamapis, unaq syilupi Tayta Dyuspa pullan kusa shumaqtana kawsashaq nir yaĉhar, kusata aligriyankillapa. Chaqa imanutaq qamkunata qischashunllapa, chaynullami chay runakunapa rukunkunapis Dyuspa unay rimaqninkunatapis qischaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Piru akaw qamkuna kanan kusa imayjun kaqkuna. Chaqa kananllami kusata aligriyashaykillapana. ");
INSERT INTO qufNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Akaw qamkuna kanan kusa unta mikuqkuna. Chaqa maydiyaqami mallaqnankillapa. Akaw qamkuna kanan kusata asikuqkuna. Chaqa maydiyaqami kusalata llakir waqankillapana. ");
INSERT INTO qufNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Akaw qamkuna kanan tukuypaq kusa alabakasha kaqkuna. Chaqa chaynullami unay rukuykillapakunapis, Dyuspa mana chiqap rimaqninkunatachu alabaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Piru qamkuna uyakumaqkunatami nishaykillapa: Ĉhiqnishuqkunatami llakipayllapa. Chaynulla chay qischashuqkunawanpis allinlata rurayllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mayqan qamkunapaq mana allinta rimatinllapapis, shumaqta willayllapa. Chaynulla imapaq uchachar qischashutinllapapis Dyusman mañakuyllapa llakipananpaq. ");
INSERT INTO qufNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mayqan uklaw qaqllaykipi takashutinllapaqa, uklawtapis rikachiyllapa. Mayqan punchuykita kitashutinmapis, dijay kamsaykitapis apanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mayqanpis imalata mañakushutinpis, quy. Chaynulla mayqan imaykita kitashutinpis, amami mañankillapachu tikrashunanllapapaqqa. ");
INSERT INTO qufNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Chaynumiri ukkuna qamkunawan shumaq kananta munarqa, qamkunapis chaynulla paykunawanpis kayllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Chaqa qamkunata llakipashuqkunalata llakiparqa ¿imanuri Dyuspaqqa shumaq kankillapa? Chaqa Dyusta mana kasuqkunapismi, payta llakipaqkunalataqa llakipanllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Chaynulla qamkunata allinta rurashuqkunalawan allinta rurarllapaqa, ¿imanuri Dyuspaqqa shumaq kankillapa? Chaqa Dyusta mana kasuqkunamapis chaynuqa ruranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Qamkuna, mayqanta imalata pristatiyqami kutichimayanqa nir yarpur pristarqa, ¿imanuri Dyuspaqqa shumaq kankillapa? Chaqa Dyusta mana kasuqkunamapismi pristanakunllapa, imalawan kutichinakunanllapapaqqa. ");
INSERT INTO qufNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Chayrayku ashwan chay ĉhiqnishuqkunataqa masta llakipayllapa. Chaynulla allinlata paykunawanqa rurayllapa. Chaymi imata pristarpis, ama yarpunkillapachu: Imalawan kutichimayanqa nirqa. Chaynu rurarllapaqami mana tukukaq imaykillapatana tarikunkillapa. Chaynulla unaqpi kawsaq Dyusninchikpa wamrankunana kankillapa. Chaqa Dyusqami, mana payta yarpuqkunata, chaynulla mana allin kaqkunamatapis kusata llakipan. ");
INSERT INTO qufNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Chaymi qamkunapis llakipakuyllapa, imanutaq Taytanchikllapa Dyuspis kusata llakipakun chaynu. ");
INSERT INTO qufNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Amami ukkunata rikar yaĉhankillapachu, Dyus qamkunatapis ama rikar yaĉhashunanllapapaq. Chaynulla ama ukkunata uchachayllapachu, Dyus qamkunatapis ama uchachashunanllapapaq. Ashwanmi pirdunanakuyllapa, Dyus qamkunatapis pirdunashunanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ukkunatami quyllapa, Dyus qamkunatapis qushunanllapapaq. Payqami kustalnikillapapi qushunqallapa imakunatapis allita midikashatana. Chaymi ĉhaspir ĉhaspir untachimunqa kustalnikillapamanqa. Chaynu qamkuna ukkunata imakunawan yanapashaykillapanullami, Dyusqa qamkunatapis yanapashunqallapa”. ");
INSERT INTO qufNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesusmi kay kumparasyuntapis niran: “¿Puytinmanchu syigu runa, uk syigu masinta kaylata kaylata rishun niyta? ¿Manachu ishkantinllapa ima uĉhkukunaman ratanmanllapa? ");
INSERT INTO qufNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Chaynumiri uk yaĉhakuqpis mana maschu yaĉhachiqninmantaqa. Chaymi maydiya allita yaĉhakurpis, yaĉhachiqnin yupayllana kanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“¿Imapaqtaq uknikipa nawinpi usulsitu tayan chayta rikaq ĉhurakanki, qampa nawikipi atun qiru tayan chayta naypaqta mana lluqshichirqa? ");
INSERT INTO qufNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Qampa nawikipi atun qirupaq mana kwintachakarqa, ¿imapaqtaq uknikita ninki: ‘Ukniy, dijamay nawikipi kaq usulta lluqshichishaq’ nirqa? Kusa allin tukuq runa, qampa nawikipi atun qirutaraq puntataqa lluqshichiy. Chaynuqami allita rikarna, uknikipa nawinpi usul kaqtaqa lluqshichinki. ");
INSERT INTO qufNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Allin qiruqami mana puytinchu mana allinta puquytaqa. Chaynulla mana allin qirupis manami allintaqa puquyta puytinchu. ");
INSERT INTO qufNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Chaymi tukuy qirukunata puquyninmanta riqsinchik. Chaqa iguspa puquynintaqami mana kashakunamantachu pallanchik. Chaynulla ubapa puquynintapis manami sarsakunamantachu pallanchik. ");
INSERT INTO qufNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Chaynumi allin runakunapis allin kaqkunalata riman allinkunala shunqunpi kashanrayku. Piru chay mana allin runaqami mana allin kaqkunalata riman, tukuy mana allinkunala shunqunpi kashanrayku. Chaqa mayqanpis shunqunpi kashanllatami, rimanllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“¿Imapaqtaq qamkunaqa ‘Amituy Amituy’ nimankillapa, nuqa nishaykunata mana kasurqa? ");
INSERT INTO qufNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Chiqaptami nishaykillapa: Mayqanpis uyamar nuqa nishayta kasur ruraqkunaqami kaynu yupay. ");
INSERT INTO qufNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Uk runami wasinta shachinanpaq puntataqa kusa rurita simintuta rajar, rumipa ananmanta shachiran. Chaymanta riyu untamur, chay wasipi wipyakarpis mana kuychiylamatapis puytiranchu. Chaqa kusa alliri shasha karan. ");
INSERT INTO qufNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Piru mayqanpis uyamar chay nishaykunata mana kasuqqami, uk runa mana simintuta rajarchu allpa analanpi wasinta shachiran. Chaymanta riyu untamur chay wasipi wipyakatinqa, chay wasiqa limpu limpu pampalla rataran chay yupay”. ");
INSERT INTO qufNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Chaymanta chay runakunata willar tukchirnaqa, Jesusqa riran Capernaúm pwibluman. ");
INSERT INTO qufNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Chaypimi Romamanta suldadukunapa uk mantaqnin karan. Paypa kusala munashan sirbiqninmi allipla qishaq karan wanuypaqna. ");
INSERT INTO qufNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Chaymi chay runaqa Jesuspaq rimaqllapata uyaparan. Chaymantami, Israel runakunapa ruku mantakuqninkunata rugar kaĉharan, Jesusta rir willatinllapa shamur sirbiqninta allichananpaq. ");
INSERT INTO qufNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Chaymi paykunaqa Jesusman rir qimikarqa, kusalata rugaranllapa kaynu nir: —Taytituy, allinmi kanqa chay suldadukunapa mantaqnintaqa llakipanaykipaq. ");
INSERT INTO qufNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Chaqa payqami nasyunninchikta kusalata munan. Chaynullami chay tantakanayllapa wasimatapis rurachikuran nir. ");
INSERT INTO qufNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Chaynu nitinmi Jesusqa riran paykunawan. Piru wasiman shipchayatinllapanaqa, chay suldadukunapa mantaqninqa amigunkunata kaĉhamuran kaynu nir Jesusta willananllapapaq: “Taytituy, amami piñakunkichu. Chaqa nuqa mana kwintachaypaqla kashayraykumi, mana allinchu rir wasiyman yaykunaykipaqqa. ");
INSERT INTO qufNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Chayraykumi mana nuqallaqa riyta puytiraychu rugashuqqa. Chaymi kaylamanta niy, sirbikuqniyqa alliyananpaq. ");
INSERT INTO qufNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Chaqa nuqallatami mantamaqniykuna mantaman. Chaynulla nuqapis wakin suldadukunata mantani. Chaymi mayqannintapis ‘Riy’ nitiyqa, rin. Ukta ‘Shamuy’ nitiypis, shamun. Chaynulla sirbiqniytapis, imata rurananpaq kaĉhatiypis ruran” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Chaynu nishanta uyaparmi Jesusqa kusa dispantakashalla kidaran. Chaymi chay runakuna ikinta riqkunaman tikrakar, niran: —Nishaykillapa: Tukuyla Israel pwiblupiqa manami mayqantapis kay runa yupay allita kriyiqtaqa tarishachu kani. ");
INSERT INTO qufNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Chaymanta chay mandadu rishakuna wasiman tikrakarqa, chay sirbikuqta allintana tariranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Chaymantaqa Jesusqa riran uk pwiblu Naín shutiqman. Paywanqami achka yaĉhakuqninkuna, chaynulla kusa achka runakuna ima riranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Chaynu rir pwibluman ĉhayarllapanaqa rikaranllapa uk byudapa uklayla wamran wanushata chay pwiblumanta kusala achka runakuna apaqllapata. ");
INSERT INTO qufNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Chayta rikarmi Jesusqa, chay warmisitapaq kusalata llakir kaynu niran: —Ama waqaychu mamitay nir. ");
INSERT INTO qufNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Chaynu nir wanushaman qimikar kamatinmi, chay apaqkunaqa yarachiranllapa. Chaymi Jesusqa chay wanushataqa niran: —Wamra, qamtami nishuni ¡kawsamuy! nir. ");
INSERT INTO qufNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Chaynu nitinqami chay wanushaqa kawsamur tar rimaqna qallariran. Chaymantami Jesusqa chay wamrataqa mamanwanna dijaran. ");
INSERT INTO qufNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Chayta rikarmi, tukuyla chaypi kaqkunaqa alliplata dispantakar Dyusta alabaranllapa, kaynu nir: “Dyusninchikpa kusa shumaq rimaqninmi rikarisha nuqanchikkunaman”. Chaynulla “Dyusninchikmi shamusha pwiblunta yanapaq” nir ima. ");
INSERT INTO qufNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Chaynu Jesús rurashankunataqami, tukuy chay Judeapa lugarninpi yaĉharanllapana. ");
INSERT INTO qufNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juanqami yaĉharan tukuy chay pasashankunata, yaĉhakuqninkuna parlasha katin. Chaymi ishkay yaĉhakuqninkunata qayar, ");
INSERT INTO qufNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","kaĉharan Jesusta tapunanllapapaq: “Qamchu Dyusmanta shamunanpaq karan chay kanki, manaqachu uktaraq yarayashaqllapa” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Chaynu kaĉhatinllapaqa, chay mandadu rishakunaqa Jesusman qimikar tapuranllapa kaynu nir: —Shutichikuq Juanmi kaĉhamashallapa tapushunayllapapaq qamchu kanki Dyusmanta shamunanpaq karan chayqa, manaqachu uktaraq yarayashaqllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Chaynu nitinllapami, Jesusqa chay kutilla achka qishaqkunata allicharan, chaynulla qischakayninkunamantapis. Chaynulla dyablupa yarpuyninwan kaqkunata allicharan, syigukunatapis nawinkunata allichatin rikakuranna. ");
INSERT INTO qufNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Chaynu chaykunata rurarnaqa, Jesusqa niran chay tapuqkunataqa: —Rir Juantaqa willayllapa tukuy rikashaykillapata, uyapashaykillapata ima. Willayllapa: Syigukunatapis rikakuchin, kujukunatapis alliyachitin purinllapa, ismuyaq aychayjunkunatapis allichan nir. Chaynulla upakunatapis uyakuchin, wanushakunatapis kawsachimun, chay mana imayjun kaqkunatapis willan imanu washakananllapapaqpis, nir ima. ");
INSERT INTO qufNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Chaynulla willankillapapis: ¡Kusa shumaqmi kanqallapa nuqapi kriyishanrayku imakuna rikarir trumpisachinatin mana maydiyapis qunqamaqkunaqa nin! nir. ");
INSERT INTO qufNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Chaymanta Juanpa yaĉhakuqninkuna ritinnaqa, Jesusqa chaypi kaq runakunata qallariran Shutichikuq Juanpaq parlaq, kaynu nir: “¿Imata rikakuqtaq qamkunaqa riraykillapa chay chunllaq lugarmanqa? Imanutaq uk runa mana uklapi yarpuqmaqa uk yura shukchata wayra wakman kayman kuyuchiq yupay, ¿chayta rikakuqchu riraykillapa? ");
INSERT INTO qufNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Manaqachu uk runa kusala ĉhaniyjun mudanata, mudakushata rikakuq riraykillapa? Qamkunaqami yaĉhankillapa chaynu mudakur paykuna munashanllapakunalata rurar taqkunaqami, chay gubyirnupa wasinkunalapi tanllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Chaqa, ¿imata rikakuqtaq riraykillapa? ¿Dyuspaq rimaq runata rikaq? Chiqaptami qamkunaqa Dyuspa rimaqninkunamantaqa nuqapaq kusa mas intrachikuqta rikaq riraykillapa. ");
INSERT INTO qufNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Chaqa Shutichikuq Juanpaqmi, Dyus nitin iskribikashakunapiqa kaynu niq: ‘Nuqami qampa naypaykita ukta kaĉhashaq, imanutaq nanta kiĉhar kamkachinllapa chaynu qampaq yaĉhachikunanpaq’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","29","Nishaykillapapis: Tukuy runakunamanta manami Juan yupay kusa allinla runaqa kashachu uklamapis. Chaqa tukuy runakuna, wakin impwistuta kubrakuqkunamapis, Juan rimatin uyakurqa, kwintata qukaranllapa paykunata Dyusqa chiqapta yanapayanqallapa nir. Chaymi paykunaqa Juan shutichikutinqa, kasur shutikuranllapa. Ashwan kananqa Dyusninchikpa mantakuyninpina mana kwintachaypaqla chaykunaqa, mastana intrakanllapa Juanmantaqa. ");
INSERT INTO qufNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Piru chay fariseukuna, chaynulla Moisés mantakushanta yaĉhar yaĉhachikuqkuna-shuypaqa, mana kriyinaranllapachu imanumi Dyus chiqapta yanapayanqa nirmapis. Chaymi paykunaqa Juan shutichikutinpis mana kasur mana shutikuranllapachu”. ");
INSERT INTO qufNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Chaymi Jesusqa niranpis: “¿Imawantaq kumparayman kay tyimpupi runakunataqa? ¿Imakuna yupaytaq paykunaqa? ");
INSERT INTO qufNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kay runakunaqami, wamritukuna plasapi tar kaynu qayapanakunllapa chay yupay: ‘Kinakunatami waqachirayllapa. Piru qamkunaqami mana bayliraykillapachu. Chaynulla llakiypaq takikunata takitiyllapapis, mana waqaraykillapachu’ ninakun chaykuna yupay. ");
INSERT INTO qufNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Chaymi qamkunapis wamritukuna yupay, Shutichikuq Juan shamur kusata ayunatin, chaynulla mana binuta upyatinqa niraykillapa: ‘Juanqami dyablupa yarpuyninwan’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Chaymanta nuqa Dyusmanta Shamuq Runa kar, mikutiy upyatiy-shuypaqa qamkunaqa ninkillapa: ‘Kusala amryintu, upyalun, chaynulla Romapaq impwistuta kubrakuqkunapa, uchasapa runakunapa amigun’ nir ima. ");
INSERT INTO qufNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Piru nuqapi kriyishanllaparayku Dyus munashanta rurar kawsaqkunami intrachikunllapa nuqaqami chiqapta Dyusmanta shamusha kani nirqa”. ");
INSERT INTO qufNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Chaymantaqa uk fariseo runami Jesustaqa kunachiran, wasinman rir mikunanpaq. Chaymi Jesusqa chay fariseupa wasinman yaykur misaman taran. ");
INSERT INTO qufNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nataq chay pwiblullapimi kaq uk kusa uchayjun warmi. Paymi yaĉharan Jesusqashi chay fariseo runapa wasinman mikuq ĉhasha nir. Chaymi alabastru butillitapi kusa mishki mutkiypaqla yakituta charikur ĉharan. ");
INSERT INTO qufNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ĉharqa, kusalata waqar Jesuspa ĉhakinpa yatanlaman tar, chay waqayninwan Jesuspa ĉhakintaqa paqaq qallariran. Chaymantaqa aqchanwan chakichir ĉhakinta muchar salaran chay mishki mutkiypaqla yakituwanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Chaymi chay fariseo, Jesusta qaraq apasha karan chayqa, kaynuta yarpuran: Chiqapta kay runa Dyuspa rimaqnin karqa kwintata qukanman, imanu warmi karmi chaynu rurayan nirmapis. Yaĉhayanmanmi kusa uchayjun warmi nir. ");
INSERT INTO qufNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Chaymi Jesusqa niran: —Simón, kayta willashayki. Chaynu nitinqa, chay fariseuqa niran: —Willamay Yaĉhachikuq Taytituy. ");
INSERT INTO qufNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Chaynu nitinqa, Jesusqa niran: —Ishkay runami dibiyaran uk runa pristasha karan chayta. Ukqa kinyintus dinaryuta dibiyaran. Nataq uknin-shuypaqa sinkwinta dinaryulata dibiyaran. ");
INSERT INTO qufNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Chaymi mana pagrayta puytitinllapaqa, chay pristasha karan chayqa llakipar mana kubrarannachu ishkantinta. Ma willamay Simón: ¿Chay ishkay runakunaqa mayqaynintaq chay qillayta pristasha karan chay runataqa mastaqa munayanqa? ");
INSERT INTO qufNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Chaynu Jesús taputinqa, Simonqa niran: —Nuqataqa yarpuchiman, chay masta dibiyatin llakipar mana kubraranchu chay paymi mastaqa munayanqa nir. Chaynu nitinqa, Jesuspis niran: —Chiqapta ninki. ");
INSERT INTO qufNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Chaynu Simón nitinqa, warmiman Jesusqa tikrakar Simontaqa niran: —¿Rikayankichu kay warmitaqa? Simón, nuqa wasikiman yaykamutiyqa, ĉhakiyta paqakunaypaqqa mana yakuta qumaraykichu. Piru kay warmisita-shuypaqa, ashwan ĉhakiyta waqayninwan paqar aqchanwan chakichishamapis. ");
INSERT INTO qufNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Qamqami mana saludar muchamaraykichu. Piru kay warmisita-shuypaqa, yaykushaymanta-pacha mana shaykuq muchamasha ĉhakiylapi. ");
INSERT INTO qufNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Chaynulla qamqa asaytiwan mana umaylamatapis salashaykichu. Piru kay warmisitaqami, ashwan ĉhakiyta salasha chay mishki mutkiypayla yakituwan. ");
INSERT INTO qufNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Chayrayku nishuni, kay warmisitatami kusa achka uchankunamanmatapis llakipar pirdunani. Chaymi payqa kusata munaman. Piru mayqantapis ashlilata pirdunashaqa, mana yanqa munamanchikchu. ");
INSERT INTO qufNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Chaymantaqa chay warmita niran: —Uchaykikunamantaqami llakipar pirdunashuni nir. ");
INSERT INTO qufNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Chaynu Jesús nitinqa, chay wakin chaypi kaqkunaqa paykunapura tapunakuq qallariranllapa kaynu nir: “¿Imataq kay runaqa uchanllapakunamanmatapis pirdunakunanpaqqa?” ");
INSERT INTO qufNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Chaynu ninakuyatinllapaqa, Jesusqa chay warmisitataqa niran: —Mamitay, chiqapta kriyimashaykiraykumi washakashayki. Qamnami rikunki nir. ");
INSERT INTO qufNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Chaymantami, Jesusqa puriran achka pwiblukunata, chaynulla taksha pwiblitukunata, yaĉhachikuqnu Dyuspa shumaq rimayninta washakarna paypa mantakuyninpi kawsananllapapaq. Pullanqami dusi yaĉhakuqninkuna karan. ");
INSERT INTO qufNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Chaynullami pullanqa karanpis chay warmikuna, dyablupa yarpuyninwan, ukman qishaywan kaqkunata allichashankunapis. Paykunaqami kaykuna karan: María. Paytami María Magdalena niqllapapis, Magdalamanta kashanrayku. Kay Mariamantami, syiti dyablupa yarpuyninkuna lluqshisha karan. ");
INSERT INTO qufNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Chaynullami karanpis Chuza shutiq runapa warmin Juana. Kay Chuzami, Herodespa imankunata rikaq karan. Ukqami karan Susana; chaynullami wakin achka warmikunapis. Paykunami iman kaqlawanmapis yanapaq Jesustaqa. ");
INSERT INTO qufNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tukuy pwiblukunamantami kusala achka runakuna Jesús kayashanman tantakaranllapa. Chaymi Jesusqa kay kumparasyunta paykunataqa parlaran: ");
INSERT INTO qufNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Uk runami tarpukuq riran ĉhakranman. Chaymanta shikwakutinqa wakin simillanqa nanman rataran. Chaymi saruĉharanllapa, chaynulla pariq kurukuna mikuran ima. ");
INSERT INTO qufNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Wakin simillakunaqa rataran rumipa ananman. Chaymanta nasirnaqa, das chakiran yakurayku. ");
INSERT INTO qufNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nataq wakin simillakunaqami kasha rurikunaman rataran. Chaymantami kashakuna pullan winar, limpu ĉhamitachiran. ");
INSERT INTO qufNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Piru wakin simillakunaqami kusala shumaq pachaman ratar, nasimur puquran. Chaymi kada similla syinllata puqutin kusala achkata kusichakuran”. Chaynu nirnaqami, kusa jwirtita kaynu niranpis: “Rinriyjun kaqkunaqa uyakur intrakayllapa” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jesuspa yaĉhakuqninkunami tapuran: —¿Ima nishaq niyantaq kay kumparasyunqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Chaymi Jesusqa niran: —Qamkunatami unay mana intrakaypaq kasha katinmapis, kananqa Dyusqa intrachishuyanllapa imanumi payqa mantakun nirmapis. Piru wakin runakunata-shuypaqami willani kumparasyunkunalawan. Chayna michka chapakurmapis ama rikakunanpaq, chaynulla michka uyakurpis ama intrakananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Kaynutami munan niyta chay kumparasyunqa: Chay simillaqami, Dyuspa rimaynin. ");
INSERT INTO qufNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","“Chay similla nanman ratasha nirqami intrachimanchik, Dyus rimashanta uyakutin chaymanta dyablu shamurqa yarpuyninpi purichiyashanta das qunqachin, amana kriyir washakananllapapaq nir. ");
INSERT INTO qufNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","“Nataq chay similla rumipa ananman rataran chaykunaqami, intrachimanchik chay runakuna Dyus rimashanta kusa aligrila uyakuqpaq. Chaymanta chay simillakuna mana allita ĉhupakusha yupaymi uk tyimpulapaq kriyir qischakarqa das paymanta ashun nir. ");
INSERT INTO qufNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Wakin simillakuna kasha ruriman ratashakunaqa, intrachimanchik Dyus rimashanta uyapaqkunapaq. Piru chay yarpupakushankuna, kusata imakunata munapashankuna, chaynulla munashanta rurashankuna imaqa, allmanta allmantaqa limpu ĉhamitachiq yupay mana dijanchu puqunanpaqqa. ");
INSERT INTO qufNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Piru simillakuna chay kusa shumaq pachaman rataran chaykunaqami intrachimanchik, chay allinla shunquyjun kar Dyus rimashanta uyakur imuraslapis allita kasur, kusalata puquq yupay kawsaqkunapaq nir. ");
INSERT INTO qufNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Manami mayqanpis uk lamparataqa kachkanchu imawan pampananpaq manaqa paranpa ĉhakinman ĉhurananpaqqa. Ashwanmi unaqlapi ĉhuran tukuyla yaykuqkunata achkirachinanpaq. ");
INSERT INTO qufNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Chaynullami kanan qamkunata willashutiyllapa wakinkunapaq pakaplla yupay kaqkunaqami, maydiyaqa uk lampara achkirachikuq yupay shutillamanna rikaritin allita intrakanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Chayraykumi allita uyakuyllapa: Chaqa mayqanpis intrakar kasukuqkunataqami masta intrachishaq. Piru chay mana intrakaqkunata-shuypaqami intrakayanina niyashanmatapis limpula qunqachishaq”. ");
INSERT INTO qufNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Chaymantami Jesuspa mamanwan ukninkunaqa, ĉharanllapa chay maypiĉhi Jesús kayashanlawman. Piru kusala achka runakuna kashanrayku naypanman mana qimikayta puytiranllapachu. ");
INSERT INTO qufNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Chaymi mayqanĉhi Jesustaqa kaynu nir willaran: —Mamaykiwan uknikikunami chay waqtapi ministishuyan nir. ");
INSERT INTO qufNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesusqa niran: —Mayqanpis Dyus rimashankunata uyakur, chay nishannullata ruraqkunami, mamaywan ukniykunaqa nir. ");
INSERT INTO qufNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Uk diyapi, Jesusqa uk yaku karruman yaykuran yaĉhakuqninkunawan. Chaymi paykunata niran: —Rishunllapa quĉhapa uklaw manyanman nir. Chaymi riranllapana. ");
INSERT INTO qufNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Chaymanta quĉhata pasayatinllapaqa, Jesusqa punuran. Chaykamanqami, kusalata wayra rikarimuran. Chaymi chay quĉhamapis wakmanta kaymanta maqchikaq qallariran. Chayna, chay yaku karrumanqa yaku untaq qallaritin, yakuman chinqananlapaqna karanllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Chaynu tukuyatinqa, Jesusta rikĉhachir kaynu niranllapa: —¡Yaĉhachimaqniyllapa! ¡Yaĉhachimaqniyllapa! ¡Yakumanmi chinqayanchikllapana! nir. Chaymi Jesusqa sharir, wayrawan yaku maqchikaqtaqa willatinla, limpu qasillaran. ");
INSERT INTO qufNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Chaymanta yaĉhakuqninkunata niran: —Ima, ¿manaraqchu allita kriyinkillapa? nir. Piru paykunaqami kusata manchakushanrayku dispantakashalla, tapunakuyaqllapa: “¿Imanu runataq kayqa? Chaqa wayrawan yakumatapis willatinla, kasun-ari” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Chay quĉhata riyarqami, ĉharanllapa Galileapa naypanpi Gadara shutiq lugarman. ");
INSERT INTO qufNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Chaymi, Jesús yaku karrumanta ishkitinqa, chay lugarmantaqa dyablupa yarpuyninwan kaq uk runa yarqamur Jesusman qimikaran. Chay runaqami unayna mana raĉhpayjunnachu puriq, chaynulla mana wasipinachu taqpis. Ashwanmi pantyunkunapina taq. ");
INSERT INTO qufNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Chaymanta Jesusta rikarqa, kusala jwirtita qayĉhakur paypa naypanpi qunqurir kaynu niran: —¡Unaq syilumanta Dyuspa Wamran Jesús, ama nuqamanqa yakapakamuychu! ¡Rugashaykimi ama qischamanaykipaq! nir. ");
INSERT INTO qufNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Chaynuqami chay dyablupa yarpuyninqa niran, runamanta lluqshinanpaq Jesús anyashanrayku. Chaqa kutir kutirmi chay dyablupa yarpuyninqa chay runataqa aypaq. Chaymi runakuna michka makinkunata, ĉhakinkunata alli kadinakunawan watatinllapamapis chay runaqa pitiq. Chaynumi ashwan chay dyablupa yarpuyninqa chunllaq lugarkunaman apaq chay runataqa. ");
INSERT INTO qufNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Chaymi Jesusqa chay runataqa kaynu nir tapuran: —¿Imataq shutinki? Chay runaqa niran: —Shutinimi ‘Legión’. Chaynuqami niran, dyablupa yarpuyninkuna paypi kusa achka kashanrayku. ");
INSERT INTO qufNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Chaymi chay dyablukunaqa, Jesusta rugaran ama chay manchaypaq uĉhku ruriman kaĉhananllapapaqchu. ");
INSERT INTO qufNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Chay sirkakunapimi achka kuchikuna shitqakuyatin, chay dyablupa yarpuyninkunaqa Jesusta rugaran, chay kuchikunaman yaykunanllapapaq. Chaymi Jesusqa yaykuyllapa niran. ");
INSERT INTO qufNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Chay dyablupa yarpuyninkuna chay runamanta yarqurqa, chay kuchikunaman yaykuranllapa. Chaymi chay kuchikunaqa kallpaq qallariran qaqata uray. Chaymanta quĉhaman yaykur ĉhuqar wanuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Chaymi chay kuchita michiqkuna, tukuy chay pasashanta rikarqa, kallpar riranllapa chay pwiblupi runakunata, chaynulla ĉhakrapi taqkunatapis parlaq. ");
INSERT INTO qufNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Parlakutinllapaqa runakunaqa lluqshiranllapa rikaq chay pasashankunataqa. Chaymanta Jesús kayashanman ĉharqa, chay runataqa Jesuspa naypanpi yarpuyninpina, mudakusha taqta rikar manchakuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Piru chay tukuy ima pasashakunata rikaqkunaqa, manyaqlla parlakuranllapa imanumi alliyaran chay runaqa nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Chaymi chay Gadara shutiq lugarmantaqa, tukuyla runakunaqa Jesusta rugaranllapa, chaymantaqa rinanpaq uklawta. Chaqa kusatari manchakuyaranllapa. Chaymi Jesusqa yaku karruman yaykur riran. ");
INSERT INTO qufNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Chay dyablupa yarpuyninmanta alliyasha chay runaqa, Jesusta rugayaran paywan rinanpaq. Piru Jesusqami chay runataqa kidananpaq kaynu niran: ");
INSERT INTO qufNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Riy wasikiman. Chayna parlakuy Dyus imanumi llakipar yanapashusha nirmapis. Chaymi chay runaqa rir parlakuran tukuyta chay pwiblupiqa, imatami Jesús paypaq rurasha nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Chaymanta Jesús chay quĉhapa uklawninmanta tikrakar shamutinqa, chaypi kaq runakunaqa kusalata aligriyaranllapa yarayashanllaparayku. ");
INSERT INTO qufNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Chaymi, uk runa Jairo shutiq ĉharan. Chay Jairumi tantakananllapa wasipi uk mantakuq kaq. Paymi Jesuspa naypanpi qunqurikur rugaran wasinman rinanpaq. ");
INSERT INTO qufNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Chaqa wanuypaqna karan chay runapa uklayla warmi wamran kaqqa. Wamranqami dusi añuyjunna kasha kanqa. Piru Jesusqami kusa achka runakunapa rurinta riyashanrayku, kusalata kiĉhkichiyaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Chay runakunapa rurintami riyaran uk warmipis. Chay warmimi dusi añupaqna yawarnin shamutin qishaq karan. Chaymi rimidyakuqkunapi, kusalata gastaran iman kaqninkunalamatapis. Piru manami mayqanpis allicharanchu. ");
INSERT INTO qufNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Kay warmisitami Jesuspa ikinlawta qimikar raĉhpanpa manyanta kamaran. Chaynu kamatinlami, chay kutilla yawarnin shamuqqa qasillaranna. ");
INSERT INTO qufNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Chaymantaqa Jesusqa tapukuran: —¿Pitaq kamamasha? nir. Chaymanta tukuy “Mana mana” niyatinqa, Pedruqa niran: —Yaĉhachikuq Taytituy, kusala achka runakuna kashanraykumi, kiĉhkipi kumsashuyan ima nir. ");
INSERT INTO qufNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Piru Jesusqami niran: —Mayqanĉhi kamamasha. Chaqa nuqami kwintata qukasha kani, pudirniy yarqusha nir. ");
INSERT INTO qufNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Chaymanta chay warmiqa imanupis mana niyta puytirqa, chukchukyaqnulla rir Jesuspa naypanpi qunqurikuran. Chaymi tukuypa naypanpi rimaran imanumi Jesuspa raĉhpanta kamarla alliyaran nir ima. ");
INSERT INTO qufNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Chaymi Jesusqa niran: —Mamitay, kriyishaykiraykumi alliyashaykina. Chayraykumi aligrilana rikuy. ");
INSERT INTO qufNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Chaynu nir Jesús rimayatinllami, chay tantakananllapa wasipi mantakuq Jairupa wasinmanta uk runa ĉhar kaynu niran: —Wamraykiqami wanushana. Amana masqa qillakachiynachu yaĉhachikuqtaqa nir. ");
INSERT INTO qufNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Piru Jesusqa chaynu niqta uyarqa, niran: —Ama manchakurchu, nuqalapi kriyiy. Chaymi wamraykiqa alliyanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Chaymanta Jesús wasiman ĉharnaqa, Pedruta, Santiaguta, Juanta, chay wamrapa taytanta, mamanta imala rurimanqa yaykuchiran. ");
INSERT INTO qufNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tukuymi waqayaranllapa chay wanushapaq llakir. Piru Jesusqa niran: —Ama waqayllapachu. Kay wamraqami mana wanushachu, punuyanlami nir. ");
INSERT INTO qufNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Chaynu nitinmi, tukuyla asiparanllapa paytaqa. Chaqa yaĉhayaranllapari wanusha nir. ");
INSERT INTO qufNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Chaymantami Jesusqa makinmanta aypar kusala jwirtita rimar niran: —¡Mamitay sharimuy! nir. ");
INSERT INTO qufNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Chaynu nitinmi kawsamur, sharimuran. Chaymantami Jesusqa kaĉhakuran qarananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Chaymi taytankunaqa, kusa dispantakashalla kidaranllapa. Piru Jesusqa niran, ama mayqantapis parlananllapapaqchu, chay rurashankunapaqqa nir. ");
INSERT INTO qufNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesusqa tantaran tukuynin dusi yaĉhakuqninkunata. Chaymantami yaĉhayninta, pudirninta ima quran, tukuy dyablupa yarpuyninkunata itakunanllapapaq chaynulla qishaykunamanta allichakunanllapapaq ima. ");
INSERT INTO qufNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Chaynumiri yaĉhakuqninkunataqa kaĉharan Dyuspa mantakuyninpaq yaĉhachikunanllapapaq, qishaqkunata allichananllapapaq ima. ");
INSERT INTO qufNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kaynu nirmi kaĉharan: “Nanpaqqami ama imalatapis aparchu rinkillapa: Bastunta, alburjata, tantata, chaynulla qillayta, mudakunaykipaq raĉhpaykillapa imamatapis. ");
INSERT INTO qufNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Mayqan wasiman ĉharpis, chaymantaqa ama lluqshinkillapachu, chay lugarmanta rinaykillapakaman. ");
INSERT INTO qufNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Imanupi mayqan pwiblupi mana samachishunatinllapaqa, ĉhakikillapapi kaq pulbumatapis ĉhaspir lluqshir rinkillapa. Chaynu rurarqami intrachinkillapa: ‘Manami nuqakunapa kwintaynachu. Ashwanmi qamkunapina kanqa’ nir”. ");
INSERT INTO qufNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Chaynu nitinmi, paykunaqa riranllapana tukuy pwiblitukunata Dyuspa shumaq rimayninta yaĉhachikuqnu chaynulla qishaqkunata allichaqnu ima. ");
INSERT INTO qufNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Chaymantami tukuy chay pasashankunapaq gubyirnu Herodesqa uyaparanna. Piru mana yaĉhayaranchu imanumi kanqa nirmapis. Chaqa Jesuspaqqa ukkunaqa niqllapa: “Juan wanushanmanta kawsamusha” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ukkuna-shuypaqa niqllapa: “Dyuspa rimaqnin Elías shamunanpaq karan, chay shamusha” nir. Chaynulla wakinkunapis niqllapa: “Dyuspa unay uk rimaqninkuna kawsamusha kanqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Chaynu niyatinllapamapis, Herodesqa paylla niran: “Chaqa nuqalla niray, Juanpa umanta pitinanllapapaqqa. Chaynu katinqa ¿mayqantaq kanqaqa chay runapaq kusata rimayanllapa chayqa?” nir. Chaymi chiqapta yaĉhanar Herodesqa kusalata Jesustaqa tariyta yarpuran. ");
INSERT INTO qufNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Chaymanta chay apustulninkuna tikrakamurqa Jesustaqa parlaranllapa tukuy imakunata rurashanllapata. Chaymi Jesusqa paykunalata apar riran Betsaida pwibluman. ");
INSERT INTO qufNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Piru runakunaqa, Jesusqa Betsaidapi nir yaĉharqa riranllapa. Ĉhatinllapaqa Jesusqa samachiran. Samachirqa runakunataqa willaran imanumi Dyus mantakun nir, chaynulla paykunapa naypanpi qishaqkunata allicharan, ima. ");
INSERT INTO qufNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Chaymanta limpu tardiyatinnaqa, Jesuspa dusi yaĉhakuqninkunaqa payman qimikar, kaynu niranllapa: —Taytituy, runakunata willay rir chay shipchakaq pwiblitukunaman, lugarkunaman ima mikunanllapata rantir mikur samananllapapaq. Chaqa kay lugarpiqami mana imapis kanchu nir. ");
INSERT INTO qufNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Chaymi Jesusqa paykunataqa, niran: —Qamkuna qarayllapa, nir. Chaynu Jesús nitinqa paykunaqa niranllapa: —Chaqa sinku tantitawan ishkay piskaditula kan. ¿Maymantashi kay kwichka achka runakunapaqqa mikuymatapis rantishunllapaqa? ");
INSERT INTO qufNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Chaqa tukuyninqa chaypi kaqkunaqa ullqukunala sinku mil (5,000) kasha kanqallapa. Piru Jesusqa yaĉhakuqninkunataqa niran: —Willayllapa chay runakunaqa tanqallapa sinkwinta, sinkwinta nir. ");
INSERT INTO qufNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Chaynu nitinqa, yaĉhakuqninkunaqa tukuy runakunataqa samachiranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Chaymanta Jesusqa chay sinku tantitawan, ishkay piskadituta aypar unaq syiluman chapakur, chaykunapaq payji nir, Taytan Dyusman mañakuran. Chaymantami chaykunataqa pidasu pidasu pakir yaĉhakuqninkunata quran tukuyla chaypi kaqkunata aypachinanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Chaynumi tukuyla mikuranllapa tiqllananllapakaman. Chaymantaqami chay tantapa chaynulla piskadupa subrantaqa dusi kanastata tantaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Uk diyapimi Jesusqa payla Taytanman mañakuyar, yaĉhakuqninkuna pullan katin, paykunataqa tapuran kaynu: —¿Nuqapaqqa mayqanshi kani ninllapataq runakunaqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Chaynu nitinqa paykunaqa niranllapa: —Wakinqami ninllapa, Shutichikuq Juan nir. Nataq wakin-shuypaqa ninllapa Elías nir. Chaynulla wakinkunaqa ninllapa Dyuspa unay rimaqnin kawsamusha kanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","—Qamkunapaq-shuypaqa ¿mayqantaq kani? —nir tapuran yaĉhakuqninkunataqa. Chaymi Pedruqa niran: —Qamqami Dyuspa Akrashan Cristun kanki nir. ");
INSERT INTO qufNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Chaynu nitinllapaqami Jesusqa paykunataqa niran, ama mayqantapis willananllapapaqchu, chay yaĉhayashanllapataqa. Chaymi kaynu niranpis yaĉhakuqninkunataqa: ");
INSERT INTO qufNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","“Dyusmanta Shamuq Runataqami ruku mantakuqkuna, kurakunapa mantaqninkuna, chaynulla Moisés mantakushanta yaĉhar yaĉhachikuqkuna ima ĉhiqnir kusalata qischanqallapa. Chaynu qischarmi wanuchinqallapa. Piru kimsa diyamantaqami qashan kawsamunqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Chaymantaqa tukuyta Jesusqa niran: “Mayqanpis nuqapa yaĉhakuqniy kanarqami amana bidanllapapaqqa llakinqallapanachu. Ashwanmi kruspi wanuchinatinllapamapis ama manchakurchu waran waran nuqalapi yarpur shachinakunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Chaqa mayqanpis paykuna munashannulla bidanta washayta kamaqkunaqami tukuy tyimpupaqna qischakanqallapa. Piru mayqanpis nuqapi kriyishanrayku qischakar wanuqkunaqami tukuy tyimpupaqna kawsanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Piru mayqanpis kay pachapi kaq iman munashanta tantakur mana washakatinqa, ¿imapaqtaq sirbiyan chay tantakushanqa? ");
INSERT INTO qufNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Chaymi nuqaqa nini, nuqamanta pinqakuqkuna, chaynulla chay rimashaykunamanta pinqakuqkunamantaqa, nuqapis llipyalla pudirniywan shamurqa pinqakushaq paykunamantaqa. Chaqa chay diyaqa shamushaq Taytaypa kusala llipyalla pudirninwan, kusa allinla angelkunawan ima. ");
INSERT INTO qufNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Chiqaptami nishaykillapa: Kaypi kawsaqkunaqa wakinllaqa Dyus mantakuqtaqa rikanqallapa manaraq wanuyarchu”. ");
INSERT INTO qufNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Chay parlashanmanta uchu diyamana pasasha katinqa Jesusqa Pedruta, Santiaguta, Juanta ima apar rir iqaran uk sirkaman, chaypi Dyusman mañakunanpaq. ");
INSERT INTO qufNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Chaynu mañakuyatinqami Jesuspa qaqllanqa kusa ukman shumaqpaq tikrakaran. Chaynulla raĉhpanmapis kusala yuraq llipya intirupaq tikrakaran. ");
INSERT INTO qufNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Chaykamanmi ishkay runakuna rikarimusha Jesuswan parlayaran. Chay ishkay runakunaqami Moiseswan Elías karanllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Chay paykunaqami kusa llipyaypa rurinpi shasha parlayaranllapa, imanumi Jesús qischakar Jerusalenpi wanuyanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedruqa wakinninwan allipla punuypaq karmapis, allipta shachinakur Jesuspa chay llipyaynintaqa rikakuranllapa. Chaynulla Jesuswan ishkay runa parlaqtapis rikaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Chaymanta chay ishkay runakuna Jesusmanta ashuyatinnaqa, Pedruqa Jesusman qimikar, kaynu niran: —Yaĉhachikuq Taytituy, ¡kaypiqami kusala allin kanchikllapa! Rurashaqllapa kimsa chukllitakunata, ukta qampaq, ukta Moisespaq, ukta Eliaspaq nir. Piru chaynu nirmapis Pedruqa mana yarpuyninpichu chaynuqa rimayaran. ");
INSERT INTO qufNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Chaynu rimanankamanqa puktay limpu pamparanllapa. Chaynu puktay pampatinllapaqa alliplata manchakuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Chaymantaqa chay puktaypa rurinmantaqa Dyus kaynu niran: ");
INSERT INTO qufNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Chaynu chay rimayta uyapatinllapala Jesusqa payla kasha karan chaypiqa. Piru chaynu katinmapis, chay tyimpuqa, uyasha chaykunaqa mana imalatapis pitapis willaranllapachu, chay rikashanllapataqa. ");
INSERT INTO qufNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Chaymanta allaqnin diya unaq sirkamanta ishkimutinllapaqa, Jesusta tariqqa kusala achka runakuna riranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Chaymi chay kusa achka runakunapa rurinmanta uk runa, kusa jwirtita kaynu niran: —Yaĉhachikuq Taytituy, kusalatami rugashayki rikanaykipaq kay uklayla wamrayta. ");
INSERT INTO qufNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Chaqa paytami dyablupa yarpuynin aypar kusata qayĉhachir atakita qur, shiminmantapis pusquta itakuchin. Chaynulla kusata qischarmi kusa llakiypaqta dijan. ");
INSERT INTO qufNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Chaymi chay yaĉhakuqnikikunata mañakuray dyablupa yarpuynintaqa itakunanpaq. Piru manami puytishallapachu nir. ");
INSERT INTO qufNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Chaynu nitinqa, Jesusqa niran: —¡Ay qamkuna Dyuspi mana allita kriyiqkuna, chaynulla mana allinta ruraqkuna! ¿Maydiyakamantaq allita intrachishunayllapapaq qischakashaq? ¿Ima maydiyakamantaq qamkunawan shachinakushaq? Ma, kayman apamuy wamraykitaqa nir. ");
INSERT INTO qufNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Chaymi chay wamrata Jesusman qimitinnaqa, chay dyablupa yarpuyninqa wamrataqa pachaman ratachir atakita quran. Chaynu ruratinqa Jesusqa, chay dyablupa yarpuynintaqa anyarlla itakur, chay wamrataqa allintana taytanwan dijaran. ");
INSERT INTO qufNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Chayta tukuyla rikaqkunami kusa dispantakashalla kidaranllapa, imanumi Dyusqa rurayta puytin nir. Chaynu Jesús tukuy imata rurashanrayku runakuna kusa dispantakashalla kanankamanmi, payqa yaĉhakuqninkunataqa niran: ");
INSERT INTO qufNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Kay nishuyanillapa chayta allita uyakur ama qunqayllapachu, Dyusmanta Shamuq Runatami kuntrankunaman qukuyanqallapa nir. ");
INSERT INTO qufNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Chaynu nitinmapis, yaĉhakuqninkunaqa mana intrakaranllapachu. Chaqa Dyusmi nisha karan amaraq intrakananllapapaqchu. Chaynullami manchakur Jesustaqa mana tapuranllapachu, imapaqmi chaynu rimasha nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Chaymantami Jesuspa yaĉhakuqninkunaqa paykunapura willanakuq qallariranllapa, mayqanninllapashi kusa mas allin kanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Chaymi Jesusqa imatami yarpuyanllapa nir kwintata qukar, uk wamrituta paypa pullan shachir, ");
INSERT INTO qufNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","yaĉhakuqninkunataqa kaynu niran: “Mayqanpis nuqapa shutiypi kay wamrituta shumaqta samachiqqami, nuqallatana samachimayan. Chaynulla nuqata samachimaq-shuypaqa, mayqanĉhi kaĉhamasha chayta samachiyan. Chaqa tukuy qamkunamanta mana kwintachaypaqla kaqmi, Dyuspaqqa kusa mas allinpaq riqsikasha kanqa”. ");
INSERT INTO qufNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Chaymantaqa yaĉhakuqnin Juanqa niran: —Yaĉhachikuq Taytituy, rikashami kanillapa uk runata qampa shutikiwan dyablupa yarpuyninkunata runakunamanta itakuqta. Chaymi paytaqa nirayllapa ama chayta ruraychu nir. Chaqa chay runaqa mana nuqanchikkunawanchu purin nir. ");
INSERT INTO qufNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Chaynu nitinmi Jesusqa niran: —Ama ‘Mana’ niyllapachu. Chaqa mayqanpis nuqanchikpa mana kuntranchik karqami, faburninchik kanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jesús syiluman rinanpaq tyimpu ĉhamuyatinnaqa, kusata animakur riran Jerusalén pwiblumanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Chaymi wakinta kaĉharan naypaqta rir, Samaria lugarpa uk pwiblitunpi wasita tarir kamakachitinllapa chaylapi samananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Piru chay Samariamanta kaqkunaqa mana samachinaranllapachu, Israelmanta kaqkunawan mana piĉhunakuq kashanrayku. Chaqa paykunaqari yaĉharanllapa Israelmanta kar Jerusalenman riyan nir. ");
INSERT INTO qufNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Chaymi yaĉhakuqninkuna Santiaguwan Juan chayta rikarqa, kaynu niranllapa Jesustaqa: —Taytituy, ¿munayankichu Dyuspa unay rimaqnin Elías rurashannulla nuqakunapis syilumanta nina shamunqa nitiyllapa, shamur paykunata rupachir tukchinanta? ");
INSERT INTO qufNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Chaynu nitinllapami Jesusqa paykunalawman tikrakar anyaran kaynu nir: —Qamkunaqami mana allin yarpuyniyjun kashaykillaparayku mana yaĉhankillapachu imatami rimayankillapa nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Chaqa Dyusmanta Shamuq Runaqami, mana runakunata chinqachinanpaqchu shamusha. Ashwanmi shamusha runakunata washananpaq. Chaymantaqa riranllapa uk pwiblitumanna. ");
INSERT INTO qufNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nanta riyatinllapaqami, uk runa kaynu niran Jesustaqa: —Taytituy, mayta ritkipismi pullayki rinayani nir. ");
INSERT INTO qufNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Chaynu nitinmi Jesusqa niran: —Surrukunami maĉhayniyjun pununanpaqqa. Chaynulla pariq kurukunapis qushayjun ima. Piru Dyusmanta Shamuq Runapaq-shuypaqami mana kanchu maylapipis umanta sintikuchinanlapaqmapis nir. ");
INSERT INTO qufNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Chaymantaqa ukta niran: —Shamuy nuqawan rishun nir. Chaynu nitinmi chay runaqa niran: —Taytituy, dijamay rishaq taytay wanutin pampaqraq. Chaymantanami rishun nir. ");
INSERT INTO qufNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesusqa niran: —Chaqa mana nuqapi kriyiqkunaqami imanutaq wanushakunamaqa chaynu. Chaymi dijay wanushakunaqa paykunapurana pampanakunqa. Ashwan qamqa rir yaĉhachikuy imanumi Dyus mantakun nir ima. ");
INSERT INTO qufNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Qashan ukqa niran: —Taytituy, nuqami pullayki rinayani. Piru puntataqa dijamay rishaq wasiypi kaqkunata ‘Rishaqna’ ninaypaq. ");
INSERT INTO qufNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Chaynu nitinmi Jesusqa niran: —Mayqanpis aradunpi aypakusha yapukuyar, ikiman chapakuqnu riqqami, Dyuspa mantakuyninpaqqa mana sirbinchu nir. ");
INSERT INTO qufNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Chaymantami Amitunchik Jesusqa akraran sitinta runakunata. Chaynu akrarmi, ishkay ishkay kaĉharan paypa naypantaqa, chay tukuy pwiblukunaman, lugarkunaman rinanpaq karan chaykunaman. ");
INSERT INTO qufNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Chaymi Jesusqa yaĉhakuqninkunataqa niran: “Chiqaptami kusichaqa kusala achka. Piru aykalami trabajaqkunaqa. Chayraykumi chay kusichapa amunta mañayllapa, pay kaĉhananpaq trabajaqkunata, paykunana tantananllapapaq nir. ");
INSERT INTO qufNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Riyllapana. Piru allita kwintata qukarmi rinkillapa. Chaqa qamkunata kaĉhashurllapaqa uk uyshitakunata surrukunapa rurinta kaĉhaq yupaymi kaĉhashuyanillapa. ");
INSERT INTO qufNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","“Amami apankillapachu qillayta purichina talqitata, alburjata, chaynulla uk llanqikunamatapis. Chaynulla nankunapi mayqanta saludarqa, amami maykaman parlar shankillapachu. ");
INSERT INTO qufNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Uk wasiman yaykurqa, naypaqtaqa saludakunkillapa kaynu nir: ‘Dyus yanapashutinllapami kusa shumaq kankillapa kay wasipiqa’. ");
INSERT INTO qufNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Chaynu nitkillapa, chaypi kaqkuna kusa shumaqta uyakur intrakatinllapaqa, Taytanchik Dyusmi shumaqta yanapanqa. Piru mana kasushutinllapa-shuypaqami mana imapis kanqachu. ");
INSERT INTO qufNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Chaynu chay wasipi kusa shumaqta uyakur intrakatinllapaqa, chayllapi kidankillapa. Chaymi chaypi mikunkillapa, upyankillapa imalatapis qushutinllapaqa. Chaqa uk trabajaqqami pagrakayta puytin. ");
INSERT INTO qufNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Chaynulla uk pwibluman ĉhatkillapa shumaqta intrakar samachishutinllapaqa, mikuyllapa imalatapis qarashutinllapaqa. ");
INSERT INTO qufNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Chaypi qishaqkuna katinqa, allichar, kaynu ninkillapa: ‘Dyuspa mantakuyninmi, shipchana qamkunapaqqa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Piru uk pwibluman ĉhatkillapa mana kasushutinllapaqa, waqta kallikunaman yarqunkillapa, kaynu nir: ");
INSERT INTO qufNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘¡Kay pwibluykillapapa allpankuna kay ĉhakiyllapapi aypakushanmatapis qamkunapa naypaykillapapi ĉhaspichikushaqllapa mana kasumashaykillaparayku! Piru Dyuspa mantakuyninqami shipchana qamkunapaqqa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nishaykillapa: Chay jwisyu diya ĉhamutinqami chay pwiblupaq kastiguqa kusala mas manchaypaq kanqa, Sodomamanta runakunamanmatapis nir. ");
INSERT INTO qufNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“¡Ay Corazín pwiblu! ¡Ay Betsaida pwiblu! Kay milagrukunata qamkuna rikanaykillapapaq rurasha kani, chay milagrukunata Tiro shutiq pwiblupi, Sidón pwiblupi rurasha katiymaqa, paykunaqa aykapina Dyuspi kriyir uchankunata dijar, saqalla raĉhpankunata yakakur, uĉhpapa anan tasha kanmanllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","“Piru jwisyu diya ĉhamutinqa, qamkunapaq kastiguqa mas kanqa, chay Tiro pwiblumanta, Sidón pwiblumanmatapis. ");
INSERT INTO qufNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Qamkuna Capernaúm pwiblupi taqkuna, ¿yarpunkillapachu washakar syiluman riyankillapa kanqa? nir. Ashwanmi qamkunaqa tukuy tyimpupaq kastigakanaykillapapaqna itakukankillapa. ");
INSERT INTO qufNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Chaqa mayqanpis qamkunata uyakushuqkunaqa, nuqatapis uyakumayan. Chaynulla qamkunata disprisyashurllapaqa, nuqatapis disprisyamayan. Nataq nuqata disprisyamar-shuypaqa chay kaĉhamasha chayta disprisyayanllapa”. ");
INSERT INTO qufNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Chay sitinta runakuna rishakunaqa, tikrakamuranllapa kusa aligrila, kaynu nir: —¡Taytituy, tukuy dyablukunapa yarpuyninkunata qampa shutikipi anyatiyllapaqami kasumanllapa! nir. ");
INSERT INTO qufNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesusqa niran: —Chiqaptami chaynu. Chaqa nuqami rikaray Dyus unaq syilumanta Satanasta itakamutin, uk rilampa yupay ratamuqta. ");
INSERT INTO qufNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Chaynu dyablupa pudirnin kasushunanllapapaqmi pudirta qushurayllapa. Chaymi kulibrakunapa, alakrankunapa rurinpi puritkillapamapis mana imanachishunqallapachu. ");
INSERT INTO qufNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Piru amami chay dyablupa yarpuyninta anyatkillapa kasushushanllaparaykulaqa aligriyayllapachu. Ashwanmi masta aligriyayllapa unaq syilupi shutikillapa iskribikashanrayku. ");
INSERT INTO qufNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Chay kutillami, Jesusqa Santu Ispiriturayku kusalata aligriyar niran: “¡Taytay! Qammi kay pachapa, unaq syilupa amun kanki. Chayraykumi alabashuni. Chaqa qamqami kananqa chay mana kwintachaypaqla kaq runakunata intrachishayki unay chay kusa yaĉhaq, kusa intrakaq runakunata pakar mana intrachishaykitaqa. Chaynumiri Taytituy. Chaqa qammi chaynu kananpaqqa munashayki kasha” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Chaynullami Jesusqa niranpis: “Taytaymi tukuy imata qumasha rikanaypaq. Piru manami mayqanpis riqsimanchu Dyuspa Wamran kani nirqa. Ashwan Taytaylami riqsiman. Chaynulla manami mayqanpis Taytaytaqa riqsinllapachu. Ashwan nuqa Wamranlami riqsini. Chaynu Wamran kashayraykumi mayqantapis riqsichinashaytaqa riqsichiyta puytini”. ");
INSERT INTO qufNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Chaynu nirqa, yaĉhakuqninkunaman tikrakar paykunalata niran: “Kusa shumaqmi kanqallapa, qamkuna kay rikayashaykillapata rikaqkunaqa. ");
INSERT INTO qufNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Chaqa nishaykillapapis: Dyuspa achka rimaqninkuna, mantakuq runakuna ima, kanan rikayankillapa chayta, chaynulla uyapayankillapa ima chaytaqa, rikayta uyapayta ima munaqllapa. Piru paykunaqami michka chaynu munarmapis mana rikaranllapachu chaynulla mana uyaparanllapalamapischu” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Chaymanta Moisés mantakushanta uk kusata yaĉhar yaĉhachikuqmi, ima ninqashi nir, kaynu Jesusta tapuran: —Yaĉhachikuq Taytituy, ¿imatana rurayman tukuy tyimpupaqna kawsanaypaqqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesusqa niran: —¿Imatataq nin Dyus nitin Moisés mantakushanpiqa? ¿Imatataq liyiyanki? ");
INSERT INTO qufNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Chaynu nitinmi chay yaĉhar yaĉhachikuqqa niran: —Taytayki Dyusta munay tukuy shunquykiwan, bidaykiwan, jwirsaykiwan, yarpuynikiwan ima. Chaynulla llakiy runa masikikunapaq, imanutaq qampa kwirpuykillapaq llakinki chaynulla nir. ");
INSERT INTO qufNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Chaynu nitinmi Jesusqa niran: —Allintami nishayki. Chayta rurarqami, tukuy tyimpupaqna kawsanki nir. ");
INSERT INTO qufNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Piru chay yaĉhar yaĉhachikuqqa, chay tapukushanpaq kwintata qukar mana pinqaypi kidanar kaynu niran Jesustaqa: —¿Pitaq runa masiyqa? ");
INSERT INTO qufNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Chaynu taputinmi, Jesusqa Israelmanta uk runata ima pasashanta kaynu nir parlaran: “Israelmanta uk runami nanta riyaran Jerusalenmanta Jericuman. Chaymantami suwakuqkuna rikarimur payta arkar limpu raĉhpanlamatapis kitaranllapa. Chaynu rurarmi kusata qischar, wanushata yupay dijar riranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Piru imanupiĉhi uk kura chay nanta pasayaran. Chayna chay qischakasha runa usuraqta rikarqa, uklawllaman chapakur mana rikaq tukur, pasar riran. ");
INSERT INTO qufNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Chaynullami levipa ayllunmanta Dyusta adurananllapa wasipi sirbikuqpis, chayta pasayaran. Piru paypis chay qischakasha usuraq runata rikarqa, uklawllaman chapakur mana rikaq tukur, pasar riran. ");
INSERT INTO qufNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Piru Israel runakunapaq uk mana kwintachaypaqla Samariamanta runami, chay nanllata pasayarqa chay runa qischakasha usuraqta rikarqa, chay pay-shuypaqa kusata llakiparan. ");
INSERT INTO qufNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Chaymi, chay runaman qimikar, lisyakashankunata rimidyaran asaytiwan, ubapa yakun binuwan ima. Chaymanta raĉhpakunawan wataran. Chaynu rimidyarmi, burritunpa anan tachir samananllapa uk wasiman apar kuytaran. ");
INSERT INTO qufNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","“Chayna allaqninqa, chay Samariamanta runaqa ishkay qillaysituta urqur chay wasipa amunta qur, kaynu niran: ‘Kay runitutami kuytapamay. Imanupi masta gastatkiqa tikrakamur pagrashayki’ nir”. Chaymanta Jesusqa niranpis: ");
INSERT INTO qufNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","—Chaynu kay kimsakuna qischakasha runata rikashanpaq parlashushaymantaqa, ¿mayqannintaq paypa kwirpunllata yupay runa masinta kuytaran? ");
INSERT INTO qufNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Chaynu Jesús nitinmi, chay yaĉhar yaĉhachikuqqa niran: —Chay kusalata llakipar yanaparan chaymi, nir. Jesusqa niran: —Chaynu katinqa qampis rir chayllata ruray nir. ");
INSERT INTO qufNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Chaymantami Jesusqa chay maymanĉhi riyaran chayman riyarqa, ĉharan uk pwiblituman. Chaypimi, uk warmi Marta shutiq, wasinpi samachiran. ");
INSERT INTO qufNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Kay Martami uk irmanayjun kaq. Paymi shutiq María. Chay Mariami Jesuspa ĉhakilanpi taran uyakunanpaq Jesús nishanta. ");
INSERT INTO qufNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Piru Martaqa, imankuna rurananpaq kusa achka katin Jesusman qimikar kaynu niran: —Taytituy, ¿manachu qamqa yarpunki irmanay pullayki katin nuqala imatapis rurani nirqa? Willay yanapamanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Piru Jesusqa, niran: —Marta, Marta, kusatami yarpunki, chaynulla llakinki tukuy imaykikunalapaq. ");
INSERT INTO qufNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Piru uklami allinqa; Mariaqami shumaq kaqninta akrasha paypaqqa. Chaymi mayqanpis akrashan chaytaqa mana kitanqachu nir. ");
INSERT INTO qufNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Uk kutimi, Jesusqa uk lugarpi mañakuyaran. Chaymanta tukchitinnaqa yaĉhakuqninkunamanta ukninqa kaynu niran: —Yaĉhachikuq Taytituy, yaĉhachimayllapa Dyusman mañakuyta, imanutaq Juan yaĉhakuqninkunata yaĉhachiran chaynulla. ");
INSERT INTO qufNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Chaynu nitinmi, Jesusqa niran: —Qamkunaqa kaynu nir mañakuyllapa: ‘Unaq syilupi Taytayllapa, qammi kusa allinpaq riqsikanki. Shamuy-ari qamla kay pachapiqa mantamanaykillapapaq. Qam munashaykinullami kay pachapi rurakanqa imanuĉhi unaq syilupi ruranki chaynulla. ");
INSERT INTO qufNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Kananllami chay ministiyashayllapa mikuyta qumayllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mana allinta rurashayllapamantapis pirdunamayllapa, imanuĉhi nuqakunapis mana allinta ruramatinllapapis pirdunanillapa chaynulla. Amami uchakunayllapapaqqa dijamankillapachu. Ashwanmi chay riqchaq mana allinkunamantaqa washamayllapa’. ");
INSERT INTO qufNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Chaynullami Jesusqa niranpis: “Imanupi amiguykillapapa wasinman ĉhaypi tuta rir, kaynu ninkimanllapa: ‘Amiguy kimsa tantitata pristamay. ");
INSERT INTO qufNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Chaqa uk amiguy chayraqla ĉhamun wasiyman. Chaymi mana imalapis kanchu qaranaypaq’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Chaynu nitkillapaqami, chay ukqa rurimanta nishuyanqallapa: ‘Ama qillakachimaychu, punkuqami kirparayanna. Chaymi nuqa, chaynulla wamraykunapis mantapina kanillapa. Manami sharimuyta puytinichu imata qushunaypaqpis’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Chaymi nishaykillapa: Amiguykillapa kar, mana das sharimur qushurllapamapis, kusata mañayatkillapaqa qushuyanqallapa tukuy ministishaykillapataqa. ");
INSERT INTO qufNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Chaynullami nishaykillapapis: Dyusman mana shaykuq mañakuyllapa; paymi qushunqallapa. Tukuy ministishaykillapata maskayllapa; Dyusmi tarichishunqallapa. Chaynulla punkumanta mana shaykuq qayakuyllapa; chaymi payqa punkunta kiĉhar yanapashunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Chaqa mayqan mañakuqpismi tarikun mañakuyashantaqa. Chaynulla mayqan maskakuqpismi, tarin maskayashantaqa. Punkupi mayqan mana shaykuq qayakutinpismi, punkunta kiĉhar yanapanllapa ima. ");
INSERT INTO qufNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“¿Mayqannikillapataq, wamraykillapa tantata mañashutinllapaqa rumita qunkimanllapa, manaqa piskaduta mañashutinllapaqa, largu kuruta qunkimanllapa? ");
INSERT INTO qufNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Manaqachu runtuta mañashutinllapaqa, alakranta qunkimanllapa? ¡Manami! ");
INSERT INTO qufNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Chaqa qamkuna kusala malu runakuna karmapismi, wamraykillapataqa allin imakunata qunkillapa. Chaymi ashwan ¡unaq syilupi Taytaykillapamaqa, Santu Ispiritunta mañatkillapamapis qushunqallapa!” ");
INSERT INTO qufNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Uk kutimi Jesusqa, uk runata dyablupa yarpuynin mudu dijasha katin, chay runamantaqa itakuyaran. Chaymanta chay dyablupa yarpuynin lluqshitinqa, chay runaqa rimaq qallariranna. Chaymi runakunaqa kusa dispantakasha kidaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Piru wakinkunaqami niranllapa: “Chay dyablupa mantaqnin Beelzebú shutiqmi, wak runataqa pudirninta qusha runakunamanta dyablupa yarpuyninkunata itakunanpaqqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Chaymi ukkunaqa mabir ima ninqashi nir, kaynu niranllapa: “Chiqapta syilumanta shamushayki nir yaĉhanayllapapaqqa uk milagruta ruray” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Piru Jesusqami, paykuna imatami yarpuyan nir yaĉhashanrayku kaynu niran: “Mayqan pwiblupis paykunapura ĉhiqninakurqa wakman kayman limpu chiqanchakar tukukanllapa. Chaynulla uk ayllupis paykunapura ĉhiqninakurqa limpu limpu wakta kayta shikwakanllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Chaynullami, chay dyablukunapis ĉhiqninakurqa ¿imanuna kusata mantakuytaqa puytinmanllapa? Kaytaqami chaynu nishunillapa, qamkuna chay Beelzebú pudirta qumasha katinshi chay dyablupa yarpuyninta itakuyta puytini nimashaykillaparayku. ");
INSERT INTO qufNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Piru qamkunaqami ninkillapa nuqapaq: ‘Beelzebú pudirninta qusha katin dyablupa yarpuyninta runakunamanta itakun’ nir. Chaynu katinqa, ¿qamkunamanta wakinnikillapaqa mayqanpa pudirninwantaq dyablupa yarpuynintaqa itakun? Chaqa paykunallami intrachimanchik qamkunaqashi limpu pantasha puriyankillapa nir. ");
INSERT INTO qufNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Allita kwintata qukayllapa: Nuqaqami dyablupa yarpuynintaqa runakunamanta itakuni Dyuspa pudirninwan. Chaynuqami intrachimanchik, Dyuspa mantakuyninqami qamkunamanqa ĉhamushana nir. ");
INSERT INTO qufNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Chaqa uk runa kusala pulsuyjun alli kamakashala wasinta kuytatinqami, mayqanpis mana iman kaqtapis suwayta puytinllapachu. ");
INSERT INTO qufNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Piru paymanta uk kusa pulsuyjun mas allita kamakasha shamurmi chay runataqa binsiyta puytin. Chaymi chay allita kamakashanpi kunfyakayashanmatapis kitar, chay wasinpi iman kaqkunamatapis limpula tantakun. Chaynuqami ashwan payna tukuy imapa amunqa kidan. ");
INSERT INTO qufNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Chaymi nishaykillapa: Nuqapaq mana allinta rimaqqami nuqapaqa kuntray. Chaynulla nuqawan mana tantakuqpismi ashwan shikwakun nir”. ");
INSERT INTO qufNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jesusqami niranpis: “Uk runamanta dyablupa yarpuynin lluqshirqami, chunllaq chaki pachakunapi purin, maylapipis samananpaq maskakur. Piru maypipis samananpaq mana tarirqami kaynuta yarpun: Tikrakashaq chay maymantaĉhi lluqshimushay wasiyman nir. ");
INSERT INTO qufNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Chaynu tikrakamurqami, chay runataqa uk shinalla wasi kusalata pichakar kamakashata yupay tarin. ");
INSERT INTO qufNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Chaynu tarirqami tikrakar rin tarimuq syiti paymanta kusala mana allin ispiritu masinkunata. Chaymantami tukuynin pulla chay runapa kwirpunmanqa yaykunllapa taq. Chaynu katinmi chay runaqa kusala llallinna tikrakan, punta kashanmantaqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Kaykunata Jesús ninankamanqa, uk warmi chay runakunapa rurinmanta kusa jwirtita niran: —¡Kusa shumaqmi kanqa chay warmi qamta wamrakur winachishusha chayqa! ");
INSERT INTO qufNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Chaynu nitinmi Jesusqa niran: —¡Ashwanmi kusa shumaqqa kanqallapa, Dyus rimashanta uyakur, kasuqkunala! nir. ");
INSERT INTO qufNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Chaykamanmi, kusa achka runakuna tantakayaranllapa Jesuspa ridurninmanqa. Chaymi payqa qallariran rimaq kaynu nir: “Kananmanta runakunaqami kusala mana allin yarpuyniyjun. Chaynu karmi mañamanllapa uk milagruta ruratiy yaĉhananllapapaq chiqaptachu Dyusmanta shamusha kani nir. Piru manami milagrutaqa rurashaqchu. Ashwanmi Dyusmanta shamusha kani nirqa Jonasta yupaylla pasamatinraq munarqa intrakankillapa. ");
INSERT INTO qufNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Chaqa Dyus imanutaq Jonaswan uk milagruta ruratin Ninivimanta runakuna kriyiranllapa, chaynullami Dyusmanta Shamuq Runapis wanur kimsa diyamanta kawsamutinraq kay tyimpupi runakunapis munarqa intrakanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Chaynulla chay surlawmanta gubyirnapis chay jwisyu diyapiqa sharimur, qamkuna kanan tyimpupi mana kriyinaqkunapaqpis rimanqa kastigakashana kayankillapa kanqa nir. Chaqa chay gubyirnaqami largu maymanta shamuran, gubyirnu Salomón kusala yaĉhayninwan yaĉhachikuqta uyakuq. Piru kay naypaykillapapi kaqqami kusa mas gubyirnu Salomonmanta kar yaĉhachikutinmapis mana kasunkillapachu. ");
INSERT INTO qufNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“Piru maydiya jwisyu diya ĉhamutinqami chay Nínive pwiblumanta kaqkunaqa sharimunqallapa. Chaymi ashwan qamkuna Dyuspi mana kriyishaykillaparayku rimanqa kastigakanaykillapapaq. Chaqa Nínive pwiblumanta runakunaqami Jonás, Dyuspaq parlakutinqa uchanllapata dijar kriyiranllapana. Piru kanan kay naypaykillapapi kaqqami Jonasmantaqa mas ima kar, qamkunata willashutinllapapis mana kriyinkillapachu. ");
INSERT INTO qufNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Chaynulla manami mayqanpis uk lamparata kachkarqa pakapaylapi, manaqa kajunpa rurinpichu ĉhuranllapa. Ashwanmi unaqlapi ĉhuranllapa, tukuy chayman yaykuqkuna achkiraqlapi kananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Piru nawikillapakuna imanutaq lamparamaqa kusala shumaq allinta achkirachikun chaynu kwirpuykillapapi katinqa, tukuy kwirpuykillapaqa kusala shumaqta achkirachikuq yupaylana kanqa. Nataq nawikillapakuna kusala mana allin katinqa, kwirpuykillapapis tutaparaqllapi yupay kanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Chayraykumi allita kuytakankillapa. Chaqa chay kwirpuykillapapi achkirachikuqqakish tutaparaqpaqmana tikrakatin. ");
INSERT INTO qufNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Chaqa tukuyla kwirpuykillapa achkila katinqami, manana tutaparaqllapi yupaynachu kankillapa. Chaynuqami uk lampara kusala shumaqta tukuypaq achkirachikuq yupayna kankillapa”. ");
INSERT INTO qufNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Chaymanta Jesús rimar tukchitinnaqa uk fariseo runa, Jesustaqa aparan wasinman mikunanllapapaq. Chaymi Jesusqa chay wasiman yaykur, misaman taranna. ");
INSERT INTO qufNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Piru chay fariseo runaqami kusalata yarpupakuran, Jesús manaraq mikuyar chay paqakuna kustumrita mana rurashanrayku. ");
INSERT INTO qufNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Chaymi Amitunchik Jesusqa niran: —Qamkuna fariseo runakunaqami, imanutaq uk kupata, manaqa platuta waqtanlawlata pichashamaqa rurinqa tiqtilla kidan chaynu, kusala bwinu yupay tukunkillapa. Piru ukkunata yanapanaykillapamantaqa kusalata munapakur, mana allinta rurankillapa. ");
INSERT INTO qufNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Runa yarukuna! ¿Manachu yaĉhankillapa, Tayta Dyusmi waqtalawta, rurilawtapis rurasha nirqa? ");
INSERT INTO qufNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Chayraykumi chay wakchakunapaq tukuyla shunquykillapawan llakir, yanapayllapa. Chaynuqami Dyuspaqqa intirulana kusa allin kankillapa. ");
INSERT INTO qufNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“¡Akaw fariseo runakuna! Qamkunami mintamanta, rudamanta, chaynulla tukuy ima mallkikunamantapis, dyis partin kaqmanta uksituta qunkillapa Dyuspaq nir. Piru Dyus mantakushanpi nin: Ukninchikkunawan imatapis karanta ruranapaq, llakipakunapaq, paylapi kriyinapaq niyan chaytaqami mana rurankillapachu. Ashwanmi kay yarpuchishushayllapata rurankimanllapa naypaqtaqa, chay rurayashaykillapatapis ama dijarchu. ");
INSERT INTO qufNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“¡Akaw qamkuna fariseo runakuna! Qamkunami chay tantakananllapa wasikunapiqa, munankillapa kusa shumaq samanakunapi samachishunanllapata, chaynulla plasakunapimapis kusala shumaqta saludashunanllapata ima. ");
INSERT INTO qufNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“¡Akaw Moisés mantakushanta yaĉhar yaĉhachikuqkuna, chaynulla fariseo runakuna, qamkunaqami Dyusta yanqa kasuq tukuq kuchi runakunala kankillapa! Imanutaq uk pampakashamaqa mana rikaypaqlla katin runakunaqa mana yaĉharchu ananpi sarukur purinllapa, chay yupaymi kankillapa”. ");
INSERT INTO qufNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Chaynu Jesús nitinqa, Moisés mantakushanta yaĉhar yaĉhachikuqkunamanta ukninqa niran: —Yaĉhachikuq Taytituy, chaynu nirqami nuqakunatapis uyachimayankillapa nir. ");
INSERT INTO qufNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Piru Jesusqa niran: —¡Akaw qamkuna Moisés mantakushanta yaĉhar yaĉhachikuqkunapis, imanankillaparaq! Qamkunami kusa llashaq kargata aprichiq yupay runa masikikunata imata rurananpaq nir mantankillapa. Piru chay niyashaykillapataqa mana pitilamatapis kumplinaykillapapaqqa yarpunkillapalamapischu. ");
INSERT INTO qufNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“¡Akaw qamkuna, Dyuspa unay rimaqninkunata wanuchir pampashanllapapa ananpi wasikunata yupay ruraqkuna! Chaqa paykunataqami qamkunapa unay rukuykillapakuna wanuchiranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Chaynuqami intrachimanchikllapa, qamkunapis chay unay rukuykillapakuna rurashannulla rurankillapa nir. Chaqa paykunami Dyuspa unay rimaqninkunata wanuchiranllapa. Chaymi ashwan chay pampakashankunapa ananpi wasikunata yupay rurankillapamapis. ");
INSERT INTO qufNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Chayraykumi Dyusqa kusa yaĉhayninwan kaynu niran: ‘Kaĉhamushaqmi nuqapaq rimaqkunata, apustulkunata ima. Chaymi wakinkunataqa wanuchinqallapa. Nataq ukkunapata-shuypaqa ikinkunapi purinqallapa qischananllapapaq’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Chaymi Tayta Dyus tukuy imata rurashanmanta-pacha paypa rimaqninkunata, ukkuna wanuchisha katinllapamapis, kay tyimpupi runakunatana allita rikar kastiganqa. ");
INSERT INTO qufNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Chaynullami Dyusqa rikar yaĉhanqa Abelta wanuchishanmanta-pacha Zacariaskaman. Chaqa Zacariastami, Dyusta adurananllapa altarpa yatalanpi wanuchiranllapa. Chayraykumi nishunillapa: Dyusqami kastiganqa tukuy chaykunapaqqa, kanan tyimpupi runakunatana nir. ");
INSERT INTO qufNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“¡Akaw, qamkuna Moisés mantakushanta yaĉhar yaĉhachikuqkuna! Qamkunami Tayta Dyuspaq allita intrakar washakananllapataqa mana munankillapachu. Chaynulla qamkunapismi mana munashaykillaparayku mana washakankillapachu. Chaymi ashwan wakinkuna intrakar ima washakananllapapaqmapis mana dijankillapachu”. ");
INSERT INTO qufNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Chaymanta Jesús chaynu nitinqa, Moisés mantakushanta yaĉhar yaĉhachikuqkuna, chay fariseukuna imaqa, kusata piñakuranllapa. Chaymi Jesustaqa ukmanta ukmanta tapur, kusalata qillakachiranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Chaynuqami tapuranllapa imalatapis mana allinta nitinqa, chaylapaq uchachananllapapaq nir yarpur. ");
INSERT INTO qufNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Chaykamanqami, allipla achka runakuna Jesús kashanmanqa, kumsanakuypa, saruĉhanakuypa ima tantakaranllapa. Chaymi, Jesusqa yaĉhakuqninkunalata, kaynu niran: “Kuytakayllapa chay fariseo runakunapa libaduranllapamanta. Chaqa paykunaqami Dyuspaq yanqa illaqta yaĉhachikuq yupay tukunllapala. ");
INSERT INTO qufNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Piru tukuy imapis pakaplla kaqkunaqa manami pakapllaqa kidayta puytinchu. Chaymi tukuy pakaplla kaqtaqa allita yaĉhakanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Chayraykumi tukuy imata qamkuna pakakuqnula rimatkillapamapis, tukuyla uyapanqallapa. Chaynulla punkuykillapata kirpakur upallala rimashaykillapamatapismi, uk wasipa ananman iqar rimasha kankimanllapa yupayna, tukuyla yaĉhanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Amiguykuna nishaykillapapis: Chay mayqan wanuchishunaqkunataqa ama manchankillapachu. Chaqa kwirpuykillapata wanuchirqami manana mas imata rurashuyllapatapis puytinqanachu. ");
INSERT INTO qufNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Chaymi willashaykillapa: Mayqanĉhi wanuchishushallapana karqa, kusala pudirniyjun kashanrayku tukuy tyimpupaq infyirnupi qischakanaykillapapaq itakushuyllapata puytiqta manchayllapa nir. Chay nishushayllapataqa, chiqapta manchayllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Ma willamayllapa: ¿Manachu sinku pariq kuritukunata ishkay qillaysitulapaqmapis rantikunllapa? Chaynu paykuna yanqa mana sirbiq katinmapismi Taytaykillapa Dyusqa kusalata kuytan. ");
INSERT INTO qufNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Piru qamkuna chay achka kuritukunamanta mas sirbiq kashaykillaparaykuqa, ¿imanunari mana kuytashunqallapa? Chaqa payqami aqchaykillapamatapis uklapi uklapi allita yupasha purichiyan. Chaynu katinmi ama imalapaqpis manchakunkillapachu. ");
INSERT INTO qufNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nishaykillapa: Mayqanpis runakunapa naypanpi nuqapaq mana pinqakur faburniy rimatinqa, nuqa Dyusmanta Shamuq Runapis, paykunapaqqa faburnin rimashaq, Dyuspa angelninkunapa naypanpiqa. ");
INSERT INTO qufNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nataq mayqanpis tukuypa naypanpi, nuqata mana kwintachamatinqa, nuqapis paykunataqa mana kwintachashaqchu Dyuspa angelninkunapa naypanpiqa. ");
INSERT INTO qufNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Piru Dyusmanta Shamuq Runapaq tukuy kuntran rimatinllapamapis, Dyusqami pirdunanqa. Piru Dyuspa Santu Ispiritunpaq kuntran rimatinllapa-shuypaqa mana pirdunanqachu. ");
INSERT INTO qufNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Imanupi qamkunata chay tantakananllapa wasikunaman, manaqa jwiskunaman, wakin karguyjunkunaman apashutinllapaqa amami yarpupakunkillapachu, imata nirmi washakashaq, manaqa imatana nishaq nirqa. ");
INSERT INTO qufNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Chaqa tapushutinllapa rimanaykillapapaqqami Dyuspa Santu Ispiritun yaĉhachishunqallapa imata rimanaykillapapaqmapis”. ");
INSERT INTO qufNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Chaymantaqa, chay tantakasha runakunamanta, uk runami Jesustaqa niran: —Yaĉhachikuq Taytituy, ukniyta willapamay qumananpaq nuqapa partiy irinsyayta nir. ");
INSERT INTO qufNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Chaynu nitinqa, Jesusqa niran: —Amiguy, ¿pitaq nuqataqa nimasha qamkunapaq jwisnikillapa kar irinsyaykillapata partishunayllapapaqqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Jesusqa niranpis: —Kuytakar, ama kusa imayjunla kaytaqa munayllapachu. Chaqa manami kusa imayjun karlachu, kawsaytaqa puytinchik. ");
INSERT INTO qufNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Chaynu nirqa, uk kumparasyunta kaynu nir paykunataqa parlaran: “Karanmi uk kusa imayjun runa. Paymi uk kutiqa ĉhakran tarpukashakuna allipta winatin kusalata kusichakuran. ");
INSERT INTO qufNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Chaymantami, chay kusa imayjun runaqa kaynuta yarpuran: ¿Imatana rurashaq? Chaqa manami kanchu maypi mikunayta ĉhurakunaypaqqa. ");
INSERT INTO qufNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Chaynu yarpuyarqa, niran: ‘Yaĉhaninami, ĉhurakunay wasiyta ratachir mushuqmanta qashan kusa atunta shachishaq, chaypina ĉhurakunaypaq kusichakushayta, chaynulla tukuy imaykunata ima’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Chaynu nirnaqa, niranpis: ‘Chaymantaqa nuqalla nikashaq: Taytituy, kusala achka mikunayjun achka añupaq kanki. Samar mikuy, upyay, kusa aligrilla kawsay nir’. Chaynu nir ima, chay runaqa kusata yarpuyaran. ");
INSERT INTO qufNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Piru Dyusqami chay runataqa niran: ‘¡Runa yaru! Kanan tutallami wanunki. Wanutkiqa, ¿pipaqtaq kidanqa chay imaykikunaqa?’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Chaynumi pasanqa chay runakuna kusalata imanllapakunata payllapaq tantakuqkunataqa. Chaqa kaypi kusa imayjun kaqqami, Dyuspaqqa mana imayjunlamapischu kanqa”. ");
INSERT INTO qufNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Chaymantami Jesusqa yaĉhakuqninkunata niran: “Kayta nishaykillapa: Amami imatana mikushaq kawsanaypaq nirqa yarpupakunkillapachu. Chaynulla amami ima raĉhpawanna kwirpuyta mudachishaq nirqa yarpupakunkillapachu. ");
INSERT INTO qufNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Chaqa kawsananchikmi masta sirbin mikuymantaqa. Chaynulla kwirpunchikpis masta sirbin raĉhpamantaqa. ");
INSERT INTO qufNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","“Rikayllapa pariq kurukunata. Paykunaqa manami tarpukur urqukunllapamapischu. Chaynulla manami maypi ĉhurakunanllapalapaqmapis kanchu. Piru, imanutaq ashwan Dyusqa paykunataqa qaran ima. ¡Allita yarpuyllapa, qamkunaqami chay kurukunamantaqa ashwan kusa masta sirbinkillapa! ");
INSERT INTO qufNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","“Chayraykumi tapushaykillapa: ¿Chaynu kusalata yarpupakurqachu, imanu kashaykillapamantaqa midyu mitrullataqa winayta puytinkimanllapa? ¡Manami! ");
INSERT INTO qufNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Chaynu yarpupakur mana mas winayta ima puytirqa, ¿imapaqtaq ‘Imanuraq kawsashaq’ nirqa yarpupakunkillapa? ");
INSERT INTO qufNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Allita kwintata qukayllapa imanutaq liryukunamaqa winar, mana trabajanchu chaynulla mana puchkakunlamapischu. Piru paykunaqami kusala shumaqta tuktukustunmapis. Chaymi nishaykillapa: Gubyirnu Salomonmapis kusala ĉhaniyjun raĉhpanwan mudakurmapis manami chay tuktitukuna yupayqa lusiranchu. ");
INSERT INTO qufNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Chaqa Dyus kanankuna chay tuktitukunata winachir kusa shumaqta lusichitinmapis, allaqkunaqa rupar imana tukukanqallapa. Chaynu karmi qamkunataqa ashwan kusala mas shumaqta ima mudachishunqallapa. Piru chaynu yaĉharqa, ¿imapaqtaq Dyusninchikpi manaraq allita kriyinkillapa? ");
INSERT INTO qufNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Chayraykumi ama llakir yarpupakuyllapachu ¿imatana mikushun? ¿imatana upyashun? nir imaqa. ");
INSERT INTO qufNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Chaqa tukuy chaykunapaqqami Dyuspi mana kriyiqkuna chaynuqa yarpupakur kawsanllapa. Piru qamkunapaqqami Taytaykillapa yaĉhayanna, imatami ministinkillapa nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","“Chaymi qamkunaqa Taytaykillapa Dyus mantakuyashanlapina yarpur kawsayllapa. Chaynuqami payqa ima ministishaykillapapipis yanapashunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Qamkunaqami nuqapa uyshitaykuna kashaykillaparayku ama manchakuyllapachu. Chaqa qamkuna aykala katkillapamapismi Taytaykillapaqa kusalata llakipashurllapa, paypa mantakuyninpina kanaykillapapaq nisha. ");
INSERT INTO qufNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Chaymi nishaykillapa: Tukuy imaykillapakunata rantikur, ministiqkunata yanapayllapa. Chaynu yanapakurqami syilupi mana tukukaq imaykillapatana tantakuyankillapa. Chaqa syilumanqami suwakuqkunaqa mana yaykunchu, chaynulla manami imakunapis pumpinlamapischu. ");
INSERT INTO qufNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Chaymi unaq syilumanta mana tukukaq imaykillapapaq chapakur yarpuyatkillapaqa syilumanta kaq imaykillapalapina kanqa yarpuynikillapaqa. ");
INSERT INTO qufNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Listuna kayllapa alli raĉhpaykillapata yakakusha, lamparitaykillapata kachkar charikusha. ");
INSERT INTO qufNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Listuna kayllapa, imanuĉhi sirbikuqkuna patrunnin kidamyintuman rir, wasinman ĉhamutin punkuta kiĉhananpaq alamirala tanllapa, chaykuna yupay. ");
INSERT INTO qufNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Chaymi chaynu alamirala kaqkunaqa kusa shumaqna kanqallapa. Nishaykillapami: Chaynu sirbikuqkunataqa patrunnin ĉhamurqa, payna ashwan misaman samachir mikuymatapis sirbiyanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Chaynulla kusa shumaqmi kanqallapa, chaynu patrunnin ĉhaypi tuta, manaqa achkiyaypi ĉhatinmapis, rikĉhakur alamirala kaqkunaqa. ");
INSERT INTO qufNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Chaqa allita yarpuyllapa: Uk wasipa amun imurasmi uk suwakuq ĉhamuyan suwamaq nir yaĉharqa, imuraspis rikĉhakushala kar, mana dijanmanchu mayqanpis wasinman yaykur suwananllapataqa. ");
INSERT INTO qufNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Chaynullami qamkunapis, imuraspis alamirala kayllapa. Chaqa manapis yarpuyatkillapami, Dyusmanta Shamuq Runaqa shamunqa”. ");
INSERT INTO qufNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Chaymantami Pedruqa Jesusta tapuran: —Taytituy, ¿kay kumparasyuntaqachu nuqakunalapaq rurashayki, manaqachu tukuypaq? ");
INSERT INTO qufNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Chaymi Jesusqa niran: “Uk runami sirbikuqninta, wasinpi kaq wakin sirbikuqninkunata uranlapi qarananpaq nir inkarganman. Chaymi chay sirbikuqqa patrunnin nishannula rurar, kusa alamirala kaqta tarinman. ");
INSERT INTO qufNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Chaynuta chay sirbikuqta patrunnin taritinqami, chay sirbikuqqa kusala allinpaqna riqsikasha kanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Chiqaptami nishaykillapa: Chay patrun chay sirbikuqta pay nishanlata ruraqta tarirqami, ashwan tukuy iman kaqtapis pay rikananpaqna quyanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Piru imanupi chay sirbikuq mana allin yarpuyniyjun kar, chay patrunnin mana das ĉhamuyanqachu nir yarpur, chay ullqu kaq, warmi sirbikuq masinkunata qischar, mikur upyar maĉhar ima tar, ");
INSERT INTO qufNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","mana imuras ima diya ĉhamuyanqa nir yaĉhayatinchu, patrunnin ĉhamur chaynu ruraqta tarirqami, kusala saqra manchakuypaqta kastigayanqa Dyusta mana kasuq runakunata yupaylla. ");
INSERT INTO qufNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Chayraykumi uk sirbikuq imatami rurananta munayan patrunnin nir yaĉhar, mana listu kashanrayku mana rurarqami kusala llakiypaqtana kastigakanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Piru imanupi, uk sirbikuq mana imatapis yaĉhar mana allinkunata ruraqta-shuypaqa tantyarkaqta kastigakanqa. Chaymi nini chay mayqantaĉhi masta quyanchik chaytaqa, masta mañanchikpis. Chaynulla chay mayqantaĉhi masta kunfyanchik, chaytapis masta rurachishun. ");
INSERT INTO qufNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Nuqaqami kay pachamanqa shamusha kani ninata kachkaq. ¡Chaymi nuqaqa, nina kachkakashana kanman nir yarpuni! ");
INSERT INTO qufNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Piru manaraq kaykuna katinqami, naypaqtaqa allipta qischamanqallapa. ¡Rikamashaykillapanu yarpuyniypimi allipta qischakayani, chay saqra qischakanay diya ĉhamunankaman! ");
INSERT INTO qufNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Amami qamkunaqa yarpunkillapachu: Jesucristo shamushanraykumi manana qischakashunllapanachu nirqa. Chaqa nuqa shamushayraykumi manana pulla ima shumaqnachu kawsankillapa. ");
INSERT INTO qufNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Chaqa kananmantami uk runa sinku aylluyjunmanta nuqarayku limpu chiqanchanakunqallapa. Chaymi chay kimsa kaqkunaqa chay ishkaykuna nuqapi kriyiqkunata kuntrayanqa. Manaqa chay ishkaykuna chay kimsa kaqkuna nuqapi kriyishakunata kuntrayanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Chaynullami nuqapi kriyishanrayku, uk runapis wamranpa kuntran tikrakanqa. Nataq ullqu wamraqa taytanpa kuntran tikrakanqa. Chaynulla uk warmipis warmi wamranpa kuntran tikrakanqa. Nataq warmi wamranpis mamanpa kuntranna tikrakanqa. Chaynulla uk swigrapis llunchuyninpa kuntranna tikrakanqa. Nataq uk llunchu-shuypaqa swigranpa kuntranna tikrakanqa”. ");
INSERT INTO qufNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesusqa niranpis runakunataqa: “Qamkuna rupay chinqananlawmanta puktay shamuqta rikarqa, yaĉhankillapana tamya ishkinqa, nir. Chayqamiri chiqapta chaynu. ");
INSERT INTO qufNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Chaynulla surlawmanta wayra shamutinqa, qamkunaqa yaĉhankillapana kaluryanqa, nir. Chay nishaykillapanumi kaluryan chiqapta. ");
INSERT INTO qufNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Dyusta yanqa kasuq tukuq runakuna! Chaynu syiluta, pachata ima chapar allita yaĉharqa, syilumanta shamuq kay tyimpukunapi imata ruratin rikarmapis, ¿imapaqtaq mana intrakankillapa? ");
INSERT INTO qufNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“¿Imapaqtaq mana yaĉhankillapa, imataq allin imataq mana allin nirqa? Allita rikayllapa chay allinkunata. ");
INSERT INTO qufNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Chayna karguyjunkunaman mayqan qayachishutin rirqa, ashwan chay qayachishusha chay runawanqa shumaq parlayllapa. Chaynu parlatkillapaqami manana karguyjunkunapiqa purichishunqanachu. Chaqa jwisman apashutinqa, jwisqa qukushunqa gwardyakunaman. Chaymi paykunaqa ashwan karsilman itashunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Chaymantaqa tukuy dibikushaykita pagrakur lluqshimunki. Manaqa mana lluqshimunkichu”. ");
INSERT INTO qufNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Chay tyimpukunallapimi, wakinkuna riranllapa Jesusta rikaq. Chaymi parlaranllapa imanumi Pilato mantakutin Galileamanta ayka runakunata wanuchishanpaq. Chaynulla imanumi chay wanushakunapa yawarninta, chay ufrindapaq animalkunata wanuchishanllapakunapa yawarninwan piĉhusha nir ima. ");
INSERT INTO qufNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Chaynu nitinllapami, Jesusqa niran paykunataqa: “¿Qamkunaqachu yarpunkillapa chay wanusha runakunaqa Galileamanta wakin runa masinkunamantaqa mas uchayjun kashanrayku wanusha nir? ");
INSERT INTO qufNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nishaykillapa: Manami chayqa chaynuchu. Qamkunapismi Dyusman mana tikrakarqa, chaynu kastigakar wanunkillapa. ");
INSERT INTO qufNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Manaqachu chay dyisi-uchu runakunata Siloé lugarpi atun turri ratar wanuchiran chaykunapaqpis yarpunkillapa, chay wakin Jerusalenpi taq runakunamantaqa mas uchayjun kar wanusha kanqallapa, nir? ");
INSERT INTO qufNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nishushayllapanu manami chaynuchu. Qamkunapismi Dyusman mana tikrakarqa, chaynu kastigakar wanunkillapa”. ");
INSERT INTO qufNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesusmi kay kumparasyunta parlakuran: “Uk runami, ĉhakranpi igus qirukunata tarpusha karan. Chaymantaqa chay runaqa riran rikaq puquyanqachu nir. Piru manami ima puquyninlamatapis tariranchu. ");
INSERT INTO qufNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Chaymi chay ĉhakrapi kuytakuq runataqa niran: ‘Rikay, kimsa añutanami shamusha kani rikaq puqushana kanqa nir. Piru manami maydiyapis tarishachu kani puquyniyjuntaqa. Chayrayku kuchuy. ¿Chaqa imapaqna yanqallaqa ĉhakrapiqa kanqa?’ ");
INSERT INTO qufNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Chaynu nitinmi, chay ĉhakrapi kuytakuq chayqa niran: ‘Taytituy, dijayraq kay añulaqa. Ĉhupankaqmanta allpata allar ushyachir, wanuta itashaq. ");
INSERT INTO qufNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Chaynuqa imanupiqa puqunman. Piru chaynu ruratiy mana puqutinnaqa, kuchuypaqna’ ”. ");
INSERT INTO qufNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Uk kutimi samana diyapi Jesusqa uk tantakananllapa wasipi qallariran yaĉhachikuq. ");
INSERT INTO qufNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Chaypimi uk warmi karan. Chay warmimi dyisi-uchu (18) añupaqna qishaq karan, dyablupa yarpuynin limpu kurpala dijashanrayku. Chaymi mana imanupis dirichakaylamatapis puytiyaranchu. ");
INSERT INTO qufNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Chaymanta Jesús rikarqa, qayamur niran: —Mamitay, qishaynikimantami alliyashaykina nir. ");
INSERT INTO qufNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Chaynu nirmi, chay warmisitapa ananman makinta ĉhuraran. Chaymi chay kutilla dirichakar, Dyusta alabaq qallariran. ");
INSERT INTO qufNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Piru chay tantakananllapa wasipi kuytakuqkunapa mantaqninqa kusata piñakuran. Chaqa Jesusqa samana diyapi allicharan. Chaymi runakunataqa niran: —Saysi diyami kan trabajanapaq. Chaymi chay diyakunapi shamuyllapa alliyanaykillapapaqqa. Ama samana diyapiqa shamuyllapachu. ");
INSERT INTO qufNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Chaynu nitinmi Amitunchik Jesusqa niran: —Dyusta yanqa kasuq tukuq, kuchi runakuna, ¿manachu mayqannikillapapis turuta manaqa burruta samana diyapimapis, apar yakuta upyachinkillapa? ");
INSERT INTO qufNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kay warmisita Abrahampa ayllunmanta katinmapis, Satanás kay qishaywan watasha yupay qischasha dyisi-uchu añupaqna. Chaynu katin, ¿samana diyachu mana alliyachikunapaq kasha? ");
INSERT INTO qufNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Chaynu Jesús nitinqa, chay ĉhiqniqkunaqa pinqaypi kidaranllapa. Piru wakin runakunami kusata aligriyaranllapa mana rikashanllapakunata Jesús ruratinqa. ");
INSERT INTO qufNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesusqa niranpismi: “¿Ima yupaytaq Dyuspa mantakuyninqa? ¿Imawantaq kumparayman? ");
INSERT INTO qufNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Dyuspa mantakuyninqami, uk qiru mustasa shutiqpa llampula simillitan yupayla. Chay mustasa simillatami uk runa ĉhakranpi tarpun. Chaymantami kusala atunta winan. Chaymi ashwan pariq kurukunamapis rikrankunapina qushakun”. ");
INSERT INTO qufNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesusqa niranpismi: “¿Imawantaq Dyuspa mantakuynintaqa kumparayman? ");
INSERT INTO qufNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Dyuspa mantakuyninqami imanutaq uk warmi tantata ruraqmaqa achkalla arinaman pitila libadurata itar dijatin saksachin chaynu”. ");
INSERT INTO qufNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jerusalenman riqnuqami, Jesusqa yaĉhachikuq pwiblukunapi, chaynulla taksha pwiblitukunapi chaykunata pasaqnuqa. ");
INSERT INTO qufNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Chaymi ukqa tapuran kaynu nir: —Taytituy, ¿aykakaqlachu washakanllapa? nir. Chaynu nitinmi, payqa niran: ");
INSERT INTO qufNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Yaykuyta kamayllapa kiĉhkila punkituta. Chaqa achkami yaykuyta kamanqallapa. Piru chiqaptaqami mana yaykunqallapachu. ");
INSERT INTO qufNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Chaymanta wasipa amun sharimur punkuta kirpatinqa, qamkuna waqtapi kaqkunaqa, qayakur ninkillapa: ‘Taytituy Taytituy punkuykita kiĉhay-ari’ nir. Piru payqami nishunqallapa: ‘Manami yaĉhanichu maymantami qamkunaqa kankillapa nirmapis’. ");
INSERT INTO qufNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Chaymantami qamkunaqa qallarinkillapa rimaq kaynu nir: ‘Qamwanmi mikushanchikllapa, upyashanchikllapa. Chaynulla qammi kalliyllapakunapi yaĉhachikushayki’ nir ima. ");
INSERT INTO qufNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Piru payqami nishunqallapa: ‘Manami yaĉhanichu maymantami kankillapa nirmapis. ¡Wakaq tukuyllapa nuqamantaqa mana allinta ruraqkuna!’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Chaypiraqmi qamkunata waqtaman itakushushanllaparayku kusala mana agwantaypaqta qischakar, qayĉhakur kiruykillapamatapis richyachinkillapa, Abrahamta, Isaacta, Jacobuta chaynulla Dyuspa tukuy rimaqninkunata paypa mantakuyninpi kaqta rikar. ");
INSERT INTO qufNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Chaqa nortilawmanta runakuna shamunqa, chaynulla surlawmanta, rupay iqamunanlawmanta, rupay chinqananlawmanta ima, Dyuspa mantakuyninpi tar mikunanllapapaqqa. ");
INSERT INTO qufNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Piru kanan tyimpukunapi achka runakuna kusana kaqkunaqami, chay tyimpuqa mana imapaqpis sirbinqachu. Chaynulla achka kanan tyimpukuna mana kwintachaypaq kaqkunami, ashwan chay tyimpuqa kusa nishapaqna riqsikanqallapa”. ");
INSERT INTO qufNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Chaymantami wakin fariseukunapis ĉhar Jesustaqa niran: —Kaymanta lluqshir, riy uklawman. Chaqa gubyirnu Herodesmi wanuchishunayan nir. ");
INSERT INTO qufNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Chaynu nitinllapami, payqa niran: —Rir kaynu nir chay surrutaqa willayllapa: ‘Rikay. Kananpis, allaqpis dyablupa yarpuyninkunata runakunamanta itakuyani. Chaynulla qishaqkunata allichashaq chaymanta allaq uk diyaqa chaykunata rurar tukchishaqna’ niyan nir. ");
INSERT INTO qufNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Chaynulla ninkillapapis: ‘Jerusalenman nanta riqnumapis chay rurashaytaqa ruraqnu rishaq kanan, allaq, allaq uk diyakaman. Chaqa manari allinchu Dyuspa uk rimaqninqa Jerusalenmanta uklawpi wanunanpaqqa’ niyan nir. ");
INSERT INTO qufNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“¡Akaw Jerusalén, Jerusalenmanta runakuna! Dyuspa rimaqninkunatami wanuchinkillapa. Chaynulla Dyus kaĉhamushan yaĉhachishuqkunatapis rumillawan sitar wanuchinkillapa. Kwichkaraq tantashuyllapata munaray, imanutaq uk pishqumaqa wawitunta tantala uqllakun chaynu. Piru manami munashaykillapachu. ");
INSERT INTO qufNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Chaqa rikayllapari, qamkunalanami kidankillapa. Chaymi nishaykillapa: Mananami rikamankillapanachu qamkuna kaynu nimanaykillapa tyimpu ĉhamunankaman: ‘¡Alabashunllapa Taytanchik Dyuspa shutinpi shamuqtaqa!’ nir”. ");
INSERT INTO qufNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Uk kutimi samana diyapi Jesusqa riran mikuq, mantakuq fariseupa wasinman. Piru wakin fariseukunaqami mananula riparayaqllapa paytaqa. ");
INSERT INTO qufNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Yapnin ashwan paypa naypanpi uk saksawan qishaq runa karan. ");
INSERT INTO qufNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Chaymi Jesusqa, Moisés mantakushanta yaĉhar yaĉhachikuqkunata, chaynulla fariseukunataqa tapuran kaynu nir: —¿Allinchu kanqa samana diyapi uk qishaqta allichanapaq, manaqachu mana? ");
INSERT INTO qufNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Chaynu nitinmi, paykunaqa uyarala kidaranllapa. Chaymi payqa chay qishaqtaqa das kamarla allichar willaran rinanpaqna. ");
INSERT INTO qufNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Chaymanta fariseukunataqa niran: —¿Mayqannikillapataq burruykillapa kar, manaqa turuykillapa kar uk quĉhaman ratatinqa, samana diya kashanrayku mana das lluqshichinkimanllapa? ");
INSERT INTO qufNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Chaynu taputinllapami mana mayqanninlapis imatapis willaranllapachu. ");
INSERT INTO qufNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Chaymanta chay inbitakashakuna shumaq samanakunata akrar samaqta rikarqa, Jesusqa kaynu nir willaran: ");
INSERT INTO qufNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Mayqan imanupi wasinpi kidamyintu katin, rinaykipaq inbitashutinqa, amami chay kusa shumaq samanakunapiraq samayta yarpuyllapachu. Chaqa imanupiqa qammanta uk mas kusa runa nisha ĉhatinqa, ");
INSERT INTO qufNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","chay inbitashushallapa chayqa shamur nishunman: ‘Qam tayashaykimanta ashuy, kay uk samananpaq’ nir. Chiqapta chaynu rurashutinqa riyanki kanqa pinqaypaqtana chay mana shumaq samanapina samaq. ");
INSERT INTO qufNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Chayrayku ashwan ama chaynuchu kayllapa. Mayqan inbitashutinllapaqa, mana shumaq samanapi samaskiyllapa, chay inbitashusha chay shamurqa nishunanpaq: ‘Amiguy uk mas kusa shumaq samanaman samay’ nir. Chayrayku chay wakinkuna misapi taqkunaqa alabashunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Chaqa mayqanpis pay yarpuyninllamanta ‘Kusana kani’ niqkunataqami Tayta Dyusqa mana kwintachanqachu. Nataq mayqanpis kusa karmapis mana kwintachaypaqla tikrakaqtaqami kusa nishapaqna Dyusqa riqsinqa”. ");
INSERT INTO qufNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Chaynullami niranpis chay inbitasha karan chaytaqa: “Imanupi qarakunaykipaq kar, ama amiguykikunata, uknikikunata, aylluykikunata, kusala imayjun riqsinaykikunalata imaqa, inbitaychu. Chaqa paykunapis-ari qam yupaylla inbitashunqallapa wasinman rinaykipaq. Chaynuqami pagrakasha yupayna kankillapa. ");
INSERT INTO qufNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ashwan, uk fyistata rurarqa, inbitay mana imayjunkunata, mankukunata, kujukunata, syigukunata ima. ");
INSERT INTO qufNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Chaynuqami, kusa aligrina kanki kanqa. Chaqa paykunaqari mana qam yupaylla inbitashuyta puytinqallapachu. Piru qamtaqami Dyus kusa allin runapaqna riqsishunqa, Dyusta kasuqkuna maydiya kawsamutinqa”. ");
INSERT INTO qufNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Chaynu nitinmi, chay misapi samaqkunamanta ukqa kaynu niran Jesustaqa: —¡Kusa shumaqmi kanqa mayqan, Dyuspa mantakuyninpi paywan pulla mikuqqa! nir. ");
INSERT INTO qufNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Chaynu nitinmi, Jesusqa niran: “Uk kutimi uk runa achka runakunata inbitaran mikunanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Chaymi mikunanllapapaq ura ĉhamutinqa, chay inbitakusha chayqa, uk sirbikuqninta kaĉharan chay inbitashankunata kunachinanpaq: ‘Shamuyllapa. Tukuymi listuna’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Piru tukuymi ‘Diskulpamayllapa’ niran. Punta chayqami niran: ‘Chayraqmi uk pachata rantisha kani. Chaymi riyani rikaq. Rugashayki diskulpamay-ari’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Ukqa niran: ‘Sinku yunta turukunatami rantisha kani. Chaymi riyani yuntakur rikaq. Rugashayki diskulpamay-ari’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Ukqa niran: ‘Chayraqmi kasarasha kani. Chaymi mana riyta puytinichu’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Chaynu nitinqa chay sirbikuq tikrakarqa parlaran chay mantaqnintaqa, chay inbitakashakuna nishantaqa. Chaymanta chay mantaqninqa kusalata piñakur niran chay sirbikuqnintaqa: ‘Kananlla waqta kallikunaman, chaynulla chay pwiblupa plasankunaman rir, apamuy kayman mana imayjunkunata, mankukunata, syigukunata, kujukunata ima’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Chaymanta tardikaqnaqa chay sirbikuqqa niran: ‘Taytituy, qam nimashaykinullatami rurashana kani. Piru kanraqmi lugar samananllapapaqqa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Chaynu nitinmi, chay mantaqninqa niran: ‘Riy chay yatanchikllapa nankunaman. Chaymi tukuyta willay shamur yaykamunqallapa wasiy untanankaman. ");
INSERT INTO qufNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Chaqa nishami kani, chay puntata inbitashaykunaqa manana mikunanpaqnachu wasiypiqa’ nir”. ");
INSERT INTO qufNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Chaymantaqa achka runakunami Jesuspa ikinpiqa puriranllapa. Chaymi payqa tikrakar chay runakunataqa niran: ");
INSERT INTO qufNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Mayqan nuqaman shamunar piru ashwan taytantaraq, mamantaraq, warmintaraq, wamrantaraq, uknintaraq, paypa kwirpuntaraq munarqa, mana yaĉhakuqniykuna kaytaqa puytinllapachu. ");
INSERT INTO qufNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Chaynulla mayqantapis nuqapi kriyishanrayku kruspi wanuchinar qischatinllapa manchakur mana nuqallawan purinaqkunaqami, yaĉhakuqniy kaytaqa mana puytinllapachu. ");
INSERT INTO qufNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Nishushayllapanu, mayqannikillapapis uk atun wasita ruranarqa, ¿manachu puntataqa alli tantyankillaparaq michkatami wasipiqa gastashaq nir? ");
INSERT INTO qufNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Chaynu mana tantyar, simintuta rajar chaymanta shachiq qallarir mana tukchitkillapaqa, tukuy asipashunqallapa kushikur. ");
INSERT INTO qufNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Kaynumi niyanqallapa: ‘Kay runami ruraq qallariran, piru manami tukchiyta puytishachu’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Manaqa uk mantakuq, uk mantakuqwan maqanakuq rirqa, ¿manachu naypaqtaqa yarpuyanqa: Dyis mil suldaduykunawanqachu binsiyashaq chay binti mil suldaduyjun chaytaqa, nir? ");
INSERT INTO qufNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mana binsiyta puytiq yupay karqa, chay uk mantakuqqa karullapiraq katin, kaĉhakuyanqa rugakutin shumaqchakananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Chaynullami qamkunamanta mayqannikillapapis naypaqta imaykillapa kaqkunata mana dijarqa, yaĉhakuqniykuna kaytaqa mana puytinkillapachu. ");
INSERT INTO qufNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Kaĉhiqami kusala sirbiq. Piru imanupi lampaqyarqa, ¿imanuna qashanqa sirbinqa? ");
INSERT INTO qufNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Manami allpata shumaqchananpaq, chaynulla wanulapaqmapis sirbinnachu. Ashwanmi chaynu mana sirbitinqa itakunchikna. Chaymi rinriyjun kaqkunaqa uyakur intrakayllapa”. ");
INSERT INTO qufNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Romapaq tukuy impwistuta kubrakuqkuna, uchasapakuna ima qimikaranllapa, Jesusta uyakuq. ");
INSERT INTO qufNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Kay runakunaraykumi fariseukuna, Moisés mantakushanta yaĉhar yaĉhachikuqkunaqa, jurapar kaynu rimaqllapa Jesuspaqqa: “Kayqami tukuy uchayjun runakunawan tantakar pulla mikunllapa” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Chaynu niyatinllapami Jesusqa kay kumparasyunta parlaran chay rimaqkunataqa kaynu nir: ");
INSERT INTO qufNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Qamkunapa mayqannikillapapis kanman syin uyshaykillapa. Chaymanta chay syin uyshaykillapamantaqa uksitu chinqanman. Chaynu chinqatinqa, ¿manachu chay wakinkunataqa chaylapi dijar rinkimanllapa chay chinqasha chaypaq maskakuq tarinaykillapakaman? ");
INSERT INTO qufNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Chaymi nishaykillapa: Ashwan tarirnaqa kusa aligrina riyankillapa kanqa uyshitaykitaqa matanqakurna. ");
INSERT INTO qufNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Wasiman ĉharnaqa tukuy aylluykikunata, amiguykikunata tantar niyankillapa kanqa: ‘Aligriyashunllapa kananqa, chay uyshayta chinqachisha karay, chaytaqa tarishana kani’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","“Chaymi nishaykillapa: Chaynumi unaq syilupi Dyusninchikpis aligriyan, uk runa uchanta dijar payman tikrakatinqa. Chay wakin achka mana uchayjunchu kani niqkunapaqqa mana yaqqa kwintachakanchu. Chaqa paykunaqa ninllapa manari uchayjunnachu kanchikllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Uk warmi dyis qillayniyjun kayar, imanupi ukta chinqachinman. Chaynu chinqachirqa, ¿manachu lamparanta kachkar, wasinta pichar ima manyaqla maskakunman tarinankaman? ");
INSERT INTO qufNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Chaymi chay warmiqa, qillayninta tarirnaqa amigankunata, riqsinankunata tantar ninman: ‘Aligriyashunllapa, tarishanami kani chay qillayniyta chinqachishaytaqa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“Chaymi nishaykillapa: Imanutaq kay warmisita qillayninta tarir aligriyan, chaynumi Dyusninchikpa angelninkunapis kusata aligriyan, uk runa uchanta dijar Dyusmanna tikrakatinqa nir”. ");
INSERT INTO qufNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesusqami kay kumparasyuntapis parlakuran: “Uk runami ishkay wamrayjun karan. ");
INSERT INTO qufNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Chaymi uk kutiqa chay wamrakaq chayqa taytanta niran: ‘Taytay nuqapa partiy kaq irinsyayta qumay’ nir. Chaynu nitinqa taytanqa irinsyantaqa ishkantinta wamrankunataqa quran. ");
INSERT INTO qufNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Chaymanta ayka diyakaqmantaqa chay wamrakaq wamranqa, taytan irinsyanta qushanta limpula rantikur, qillaywan riran uklaw nasyunta. Chaynu rirmi chaypiqa munashannulla tar, riqchaq imakunata rantir ima tukchiran qillaynintaqa. ");
INSERT INTO qufNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","“Chaymanta limpu qillayninta gastar tukchishana katinqa, chay nasyunpiqa allipla mallaq tyimpu karan. Chaymi payqa allipla mallaqpaqna puriran. ");
INSERT INTO qufNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Chaynu mallaqnarmi, chay nasyunllamanta uk runaman qimikaran trabajachinanpaq. Chaymi chay runaqa kaĉharan kuchikunata michinanpaq. ");
INSERT INTO qufNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Piru chay wamraqami kusalata mallaqnashanrayku kuchipa mikunanta mikunatinmapis, mana mayqanpis qararanllapachu imalatapis. ");
INSERT INTO qufNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Chaynu mallaqpaq qischakarmi kaynu nir yarpuran: Taytaypa wasinpimaqami kusa achka sirbikuqkuna unta mikur ima tanllapa. ¡Nataq nuqa-shuypaqa kaypi mallaqpaq wanuyanina! ");
INSERT INTO qufNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Dijur taytaypa wasinman tikrakar, taytaytaqa nishaq: ‘Taytay, uchakushami kani Dyusmanta, qammantapis. ");
INSERT INTO qufNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Chaymi, manana wamraykipaq riqsimanaykipaqqa allinchu kani. Ashwan riqsimay trabajadurnikikunata yupay’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Chaynu nirmi, tikrakaranna taytanmanqa. “Chaymanta wasinman ĉhayatinnaqa, taytanqa largukaqllapi rikar, kusalata llakir kallparan wamrantaqa tariq. Tarirnaqa abrasar muchar saludaran. ");
INSERT INTO qufNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Chaymi wamranqa niran: ‘Taytay, nuqaqami uchakusha kani Dyusmanta, qammantapis. Chaymi manana wamraykipaq riqsimanaykipaqqa allinchu kani’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Chaynu nitinmapis, taytanqa sirbikuqninkunata mantaran kaynu nir: ‘Kananllami shumaq raĉhpata rikar yakachipamayllapa; didunpi surtijata yakachiyllapa, chaynulla llanqichiyllapa ima’ niran. ");
INSERT INTO qufNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Chaynullami chay runaqa sirbikuqninkunataqa niranpis: ‘Kusa mas gurdu animalta apamur wanuchiyllapa, fyistata rurar mikunallapapaq. ");
INSERT INTO qufNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Chaqa kay wamraymi wanusha yupayna karan. Nataq kanan-shuypaqa kawsamusha yupayna. Chinqashami karan, tarishanchikllapana kananqa’. Chaynu nirmi fyistata ruraq qallariranllapana. ");
INSERT INTO qufNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Chaykamanmi, chay byijukaq wamranqa ĉhakranllapiraq karan. Chaymanta wasinman ĉhamuyarnaqa, uyaparan takiqllapata. ");
INSERT INTO qufNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Chaymi chay sirbikuqkunamanta ukta qayamur, imatataq chay wasinpiqa rurayanllapa, nir tapuran. ");
INSERT INTO qufNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Chaynu taputinmi chay sirbikuqqa niran: ‘Wamrakaq ukniki tikrakamur kusa allin ĉhamusha katinmi, taytaykiqa animalta wanuchichimashallapa, fyistata rurananpaq’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Chaynu willatinqami, chay wamraqa alliplata piñakur wasi rurimanqa mana yaykunaranchu. Chaymi taytan lluqshimur rugaran ruriman yaykunanpaq. ");
INSERT INTO qufNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Piru chay wamranqami niran: ‘Taytay, nuqamaqa michka añutataq sirbishusha kani. Piru chaynu sirbishur, qam munashaykilata ruratiymapis manami uk taksha chibulamatapis qumashaykichu, amiguykunawan fyistakunaypaqqa. ");
INSERT INTO qufNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nataq kay wamrayki qillayninmatapis yanqa warmikunawan tar tukchir, ĉhamutin-shuypaqa, ashwan paypaqqa fyistamatapis rurayanki mas gurdulla animalnikita wanuchir ima’. ");
INSERT INTO qufNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Chaynu wamran nitinqa, taytanqa niran: ‘Wamray, chaqa qamqa nuqapaqa maydiyapis pullay kankiri. Chaymi tukuy imay kaqkunaqa qampaqna. ");
INSERT INTO qufNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Piru kay ukniki tikrakamusha chaypaqqami allin fyistata ruranapaq. Chaqa payqa wanusha yupay chinqasha karan. Piru ashwan kananqa allinta tarishanchik. Chayrayku fyistakuyanchik’ nir”. ");
INSERT INTO qufNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesusqami kaytapis parlaran yaĉhakuqninkunataqa: “Karanmi uk kusala imayjun runa. Paypami kayaq uk runa tukuy imankunata rikaq. Chaymi ukkuna riranllapa amunta willaq, chay kuytakuq runaqa, imaykikunata gastayan nir. ");
INSERT INTO qufNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Chaymi chay kusala imayjun runaqa kuytakuqnintaqa qayamur kaynu niran: ‘¿Imanutaq qampaq willamayanllapa chayqa? Willamay, ima imatataq rurashayki. Chaqa mananari imaykunata rikanaykipaqqa allinchu chay willamashanllapanulla chiqapta imaykunata gastakuyatkiqa’. ");
INSERT INTO qufNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Chaynu nitinqa, chay kuytakuqqa yarpuq ĉhurakaran: ¿Imatana kananqa rurashaq mantamaqniy trabajuymanta itakumatinqa? Chaqa manari jwirsaylamapis kanchu ĉhakrakunapi trabajanaypaqqa. Chaynulla kusatami pinqakuni limusnakunata mañakunaypaqpis. ");
INSERT INTO qufNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Chaynu yarpupakuyarmi chaymantaqa niran: ‘Yaĉhaninami imata rurashaq nirmapis, trabajuymanta itakumatin runakuna wasinpi samachimananpaqqa’. ");
INSERT INTO qufNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Chaynu yarpurmi patrunninta wakin dibiq runakunata qayamuran. Chaymantaqa punta ĉhasha chaytaqa niran: ‘¿Michkatataq patrunniytaqa dibiyanki?’. ");
INSERT INTO qufNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Chay runaqa niran: ‘Syin butija asaytitami dibiyani’. Chaynu nitinqa, chay kuytakuqqa niran: ‘Kaypimi risibuyki. Samar sinkwintalapaqna ruray risibuykitaqa’. ");
INSERT INTO qufNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Chaynu nirnaqa chaymanta uktana tapuran kaynu nir: ‘Qamqa, ¿michkatataq dibiyanki?’ Kayqami niran: ‘Syin kustal trigutami dibiyani’ nir. Chaymi chaytapis niran: ‘Kaypi risibuykiqa. Samar ruray uchinta kustalpaqlana risibuykitaqa’. ");
INSERT INTO qufNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Chaynu tukutinmi, chay mantakuqninqa yaĉharan chay imankunata kuytaq runaqashi kusala bibu karan imata rurananpaqpis nir. Chaymi nishaykillapa: Chiqapta Dyuspi mana kriyiqkunaqa, paykunapalla imankunata rurananpaqqa allipta rurayta yaĉhanllapari, Dyuspi kriyiqkuna imankunata rurananllapamantaqa. ");
INSERT INTO qufNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Piru kay pachapi, chay tukukaq qillaynikillapata yanqalla gastanaykillapamantaqa, ashwan ukkunata yanapayllapa, paykunapis amiguykillapana kar Dyusta kasunanllapapaq. Chayna maydiya chay qillaynikillapa tukukatinqa Dyusninchikna pullakushutinllapa pay kayashanpi, tukuy tyimpu kawsanaykillapapaq. ");
INSERT INTO qufNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Chaynulla nishaykillapapis: Mayqanpis mana imanu tukur, tantyarkaqlapi allinta imatapis rikarqa, achka kaqpimapis chaynulla kanqa. Nataq tantyarkaqlapi imanu tukur, imatapis mana allinta rikarqa, achka kaqpipis chaynulla kanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Chayrayku kay pachapi yanqa imankunata mana shumaq allinta rikatkillapaqa, ¿mayqannari kunfyashunqallapa Dyuspa chiqap shumaq imankunapaqmaqa? ");
INSERT INTO qufNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ukkunapata mana allinta imankunatapis rikatkillapaqa, ¿mayqanna kunfyar qushunqallapa qamkunapa imaykikuna kananpaq kaqtaqa? ");
INSERT INTO qufNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Chaymi nini, manami mayqan sirbikuqpis ishkay runata chay kutilla sirbiytaqa puytinchu. Chaqa uknintami munayanqa, nataq ukninta-shuypaqa ĉhiqniyanqa. Manaqa ukninta allinta rikayanqa, nataq ukninta-shuypaqa musyayanqa. Chaynulla manami allinchu Dyusninchikta sirbiyar chay kutilla qillayninchiklapaq chaynulla wakin imanchikkunalapaq yarpur kawsanapaqqa”. ");
INSERT INTO qufNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fariseukunami qillayta kusalata munapakuq karan. Chaymi Jesús chaynu rimatin uyakurllapaqa, burlakar asiparanllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Piru Jesusqami niran: “Qamkunami runakunapa naypanpiqa kusa runa nishunanllapalapaq imatapis rurankillapa. Nataq Dyusqami riqsishunllapa shunquykillapapi imanu kankillapa nirmapis. Chaqa runakuna kusa ima kani nitinllapaqa, Dyusqa mana allinpaqchu riqsin nir. ");
INSERT INTO qufNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Dyusninchikpa rimaqninkuna chaynulla Dyus nitin Moisés mantakushankuna imaqa, Juan shamunankaman Dyuspaqqa intrachikuranllapa. Nataq chaymanta-pachaqa imanumi Dyus mantakuyashanman yaykuyta puytinchik nir yaĉhachikunillapa. Chaymi Dyus mantakuyashanmanqa tukuyla imanullapis yaykuyta kamanllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Piru chaynu nishutiyllapaqa amami yarpunkillapachu, Dyus nitin Moisés mantakushankunaqami manana kumplikayanqanachu nirqa. Ashwanmi syiluwan, pacha tukukatinmapis, Dyus nitin Moisés mantakushanqa tukuyla kumplikanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Chaqa nishaynumiri mayqan runapis warminta dijar ukwan kasararqa, kusala saqratana uchakuyan. Chaynulla mayqanpis chay itakukasha warmiwan kasaraqpis kusala saqratana uchakuyan. ");
INSERT INTO qufNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Karanmi uk runa kusala imayjun. Paymi kusala ĉhaniyjun raĉhpakunata mudakuq, chaynulla waran waran kusala shumaq fyistakunata rurar, kusalata mikuqllapa ima. ");
INSERT INTO qufNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Chaynullami karanpis uk runa mana imayjun Lázaro shutiq. Paypa kwirpunmi qiri intiru karan. Chaymi, chay kusala imayjunpa punkunlapi takuq. ");
INSERT INTO qufNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Kay mana imayjun runitumi, kusalata mallaqnashanrayku, chay kusala imayjunpa mikunan ratashanlawanmapis untachikunayaran. Chaynulla allqukunamapismi chay runapa qirintaqa qimikar llaqwaq. ");
INSERT INTO qufNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Chaymantami chay mana imayjun runituqa wanuranna. Chaymi angelkunaqa aparan Abrahamwan pulla kananpaq Dyuspa luryanpina. Chaynullami chay kusa imayjun kaqpis wanuranna. Chaymanta pamparanllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Chayna chay kusa imayjun runa infyirnupi qischakayarqa, syiluman chapakur, unaq maypi rikaran Abraham Lazaruta qichqakusha taqta. ");
INSERT INTO qufNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Chaymi kaynu nir qayĉhakuran: ‘¡Taytay Abraham, llakipamastuy-ari! Kaĉhamuy Lazaruta didunpa puntitanta yakupi nuyuchir, qalluyta nuyuchinanpaq. Chaqa kay ninapimi kusata qischakayani’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Piru Abrahamqa niran: ‘Wamrituy yarpuy-ari qam kawsayatkillaqa mana imaykipis faltashuranchu. Nataq Lázaro-shuypaqa qischakaq. Kananqami payta kaypi kunsulanllapa. Nataq qamqa qischakayankina. ");
INSERT INTO qufNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Chaynullami nuqanchikkunataqa uk kusala manchaypaq raqra chiqanchamayanchikllapa. Chaynu katinmi kaymanta, qamkuna kayashaykillapaman pasanarmapis mana puytinllapachu. Chaynulla qamkuna kayashaykillapamanta kaymanpis mana pasamuyta puytinllapachu’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Chaymi chay kusa imayjunqa niran: ‘Chaynu katinqa rugashaykiri Taytay Abraham, Lazaruta kaĉhanaykipaq taytaypa wasinman. ");
INSERT INTO qufNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Chaqa chaypimi kan sinku irmanuykuna. Chayna paykunata willatin ama shamunanpaqchu kay lugarman qischakaqqa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Abrahamqa niran: ‘Paykunaqami Moisés iskribishankunata, chaynulla Dyuspa rimaqninkuna iskribishankunata ima liyirna intrakar kasunqallapa’. ");
INSERT INTO qufNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Nataq chay kusa imayjun runaqa niran: ‘Chiqaptami ninki Taytituy Abraham. Piru uk wanusha kawsamur, paykunaman rikaritinqami paykunaqa Dyuspina kriyiyanqallapa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Piru Abrahamqa niran: ‘Moisés iskribishanta, chaynulla Dyuspa rimaqninkuna iskribishanta mana kasurqa, manami kriyinqallapachu michka uk wanusha kawsamur paykunaman rikaritinmapis’ nir”. ");
INSERT INTO qufNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesusqa yaĉhakuqninkunata niran: “Maydiyapismi chay uchakuchikuqqa kayanqalla. Piru ¡imananqaraq, runa masinta uchakuchiqqa! ");
INSERT INTO qufNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Chaynu tukuq runataqami kusala allin kanqa kunkanpi marayta watar mar yakuman itakunanllapapaq, chay nuqapi chayraq kriyiqkunata uchakuchinanmantaqa. ");
INSERT INTO qufNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Chayrayku qamkunamaqa kuytakayllapa. Imanupi ukniki uchakutinqa, anyay. Chaynu willatki, shamur pirdunamay nishutinqa, pirdunay. ");
INSERT INTO qufNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Chaymi ukniki qamta mana allinta rurashur uk diyalapi michka syiti kuti uchakur, chaymanta syiti kuti shamur qammantami uchakusha kani nishutinqa, pirdunay”. ");
INSERT INTO qufNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jesuspa yaĉhakuqninkunaqami, kaynu nir mañakuranllapa: —Taytituy, yanapamayllapa masta qampi kriyinayllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Chaynu nitinllapami, Jesusqa niran paykunataqa: —Imanutaq chay mustasa qirupa simillitanmaqa kusa llampitu, chaynu pitilamatapis allita Dyuspi kriyir, kaypi qiru shayan chayta ‘Rir mar yakupi shay’ nitkillapaqa, rinman. ");
INSERT INTO qufNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Qamkunapa kanman uk sirbikuqnikillapa. Chaymanta chay sirbikuqqa rinman michikuq manaqa yapukuq. Chaymanta ĉhamutinnaqa ¿mayqannikillapataq ninkimanllapa: ‘Yaykamur taytituy mikuy’ nirqa? ");
INSERT INTO qufNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","¡Manami! Ashwan niyankillapa kanqa: ‘Yaykamur mikunayta rurar qaramay, upyachimay nuqataraq. Chaymantana qamqa mikunki upyankimapis’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Chaynu imata ruratinpis, sirbikuqnikillapataqa mana ‘Payji’ niyankillapalamapischu kanqa imapaqpis. ");
INSERT INTO qufNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","“Chaynu chay sirbikuq yupay qamkunapis, Dyus nishushanllapata rurar tukchishana karmapis, ashwan niyllapa Dyustaqa: ‘Nuqakunaqami, mana sirbiq sirbikuqnikichu kanillapa. Chaqa mastaqachu imatapis rurashama katiyllapa, chay ruranayllapapaq karan chaymantaqa’ nir”. ");
INSERT INTO qufNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jerusalenman riqnuqa Jesusqa pasaran Samariapa, Galileapa lugarninkunata. ");
INSERT INTO qufNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Chaynu riyarqa uk pwiblituman ĉharan. Chaypimi, dyis ismuyaq runakuna Jesustaqa tariq shamuranllapa. Piru wakaqllapi kidaranllapa Jesusmantaqa. ");
INSERT INTO qufNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Chaymi kaynu nir qayĉhakuranllapa: —¡Yaĉhachikuq Tayta Jesús, llakipamastuyllapari! nir. ");
INSERT INTO qufNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Chaynu nitinllapa, Jesús paykunata rikarqa, niran: —Rir kurakunaman ĉhayllapa, paykuna yaĉhananpaq alliyashaykillapana nir. Chaynu Jesús nitinqa, nanta riqnula alliyaranllapana. ");
INSERT INTO qufNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Chaynu alliyatinllapanaqa, chay paykunamanta uk runaqa, chay riyashanlamanta ashwan tikrakamuran kusa jwirtita rimar Dyusta alabaqnuna. ");
INSERT INTO qufNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesusman ĉharqa, naypanlapi qunqurikur pachaman pukĉhirar payji niran. Kay runaqami Samariamanta karan. ");
INSERT INTO qufNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Chaymi Jesusqa niran: —¿Manachu chay dyis qishaqkunaqa tukuynikillapa alliyaraykillapa? ¿Chaqa maypitaq chay wakin nwibi runakunaqa? ");
INSERT INTO qufNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Kay furastiru runalachu, Dyusta payji ninanpaqqa, intrakasha? ");
INSERT INTO qufNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Chaynu nirnaqa, chay alliyasha runataqa niran: —Sharir riyna. Kriyishaykiraykumi alliyashaykina, nir. ");
INSERT INTO qufNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Chay fariseo runakunaqami Jesustaqa tapuran, maydiyashi Dyuspa mantakuyninqa ĉhamuyanqa, nir. Chaymi taputinllapaqa, payqa niran: —Dyuspa mantakuyninqami mana kwintata qukayatkillapa ĉhamunqa. ");
INSERT INTO qufNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Chaymi mana mayqanpis ninqachu: ‘Kaypina mantakuqqa’, manaqa ‘Wakpina’ nirqa. Chaqa mana kwintata qukayankillapachu. Ashwanmi, Dyuspa mantakuyninqa qamkunawanna. ");
INSERT INTO qufNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Chaynu nirqa, yaĉhakuqninkunataqa, niran: “Qamkunapaqqami ĉhamunqa uk diya. Chaymi qamkunaqa chay diyakunapiqa Dyusmanta Shamuq Runata alliplata rikanankillapa uk kutilamapis. Piru manami rikankillapachu. ");
INSERT INTO qufNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Chaymi wakin runakunaqa ninqallapa: ‘Kaypimi Dyusmanta Shamuq Runaqa’ nir. Ukkuna-shuypaqa ninqallapa: ‘Wakpimi’ nir. Piru qamkunaqa chaynu nishutinllapamapis, ama kriyinkillapachu. ");
INSERT INTO qufNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Chaqa Dyusmanta Shamuq Runa tikrakamurqami, kusa shutilla rikarimunqa, imanuĉhi rilampamaqa uklawmanta uklawkaman intirula llipyalla achkirachikun, chay yupaymi kanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Piru naypaqtaqami alliplata qischanqallaparaq. Chaynulla kusa ĉhiqnikasha ima kanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Chaynu rurayatinllapamapis chaymantaqa, imanuĉhi Noepa tyimpunpi pasaran, chaynumi pasanqa Dyusmanta Shamuq Runa tikrakamutinqa. ");
INSERT INTO qufNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Chay Noepa tyimpunpiqami runakunaqa mikuqllapa, upyaqllapa, kasaraqllapa chaynulla kasarachikuqllapa ima. Piru chaymanta Noé wampuq wasiman yaykutin, allipla saqra tamya shamur untaran tukuy pachapi. Chaymi yaku untatinqa, tukuyla runakuna wanur tukukaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Chaynulla Lotpa tyimpunpipis pasaran. Runakunaqa mikuqllapa, upyaqllapa, rantiqllapa, rantikuqllapa, tarpukuqllapa, wasikunatapis rurar taqllapa ima. ");
INSERT INTO qufNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Piru chaymanta Lot chay Sodoma pwiblumanta lluqshitinqa, unaq syilumanta ninawan asufri ishkimutin, tukuy wakin runakunaqa wanur tukukaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Chaynumi Dyusmanta Shamuq Runa tikrakamutinpis pasanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Chaymi nishaykillapa: Mayqanpis uk wasipa ananpi karmapis amami ishkimunqachu, imanta lluqshichinanpaq nirqa. Chaynulla, mayqanpis ĉhakranpi karqa amami wasinman rinqachu. ");
INSERT INTO qufNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Chaqa yarpuyllapari, Lotpa warminpaq. ");
INSERT INTO qufNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Chaymi nini, imanupis bidanta washanaqqa, ashwan wanunqa tukuy tyimpupaqna. Nataq kay bidapi Dyusrayku wanuqkuna-shuypaqa, ashwan tukuy tyimpu kawsananpaqna kayanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Nishaykillapapis: Uk tuta ishkay uqllanakusha punuyatinllapamapis, ukninta apar, ukninta-shuypaqa dijanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Chaynullami ishkay warmikuna kutakuyatinpis, ukninta apar, ukninta-shuypaqa dijanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ishkay runakuna ĉhakrapi katinpis, ukta apar, uktaqa dijayanqa”. ");
INSERT INTO qufNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Chaynu nitinqa, paykunaqa tapuranllapa Jesustaqa: —¿Maypitaq Taytituy chaynuqa kanqa? nir. Jesusqa paykunataqa, niran: —Maypiĉhi wanusha katin, chaypimi tantakanqa shinkukuna. Chaymi yaĉhankillapa maypimi chayqa kanqa nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesusmi kay kumparasyuntapis parlar intrachikuran, paykuna maydiyapis ama disanimakurchu Dyusman mañakunanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Niranmi: “Uk pwiblupimi karan uk jwis. Paymi Dyusta mana manchar, runakunamatapis mana rispitaqchu. ");
INSERT INTO qufNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Chaynullami chay pwiblupiqa kaqpis uk byuda warmi. Paymi uk prublimayjun kaq. Chaymi jwisman rir mañakuran, chay kuntraqninwan arriglachinanpaq. ");
INSERT INTO qufNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Piru chay jwisqami waran waran ritinmapis mana kasuqchu chay warmitaqa. Chaymantaqami yarpur niran: Nuqa, Dyusta mana kasunichu. Chaynulla runakunatapis mana rispitanichu. ");
INSERT INTO qufNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Piru chaynu katiymapis kay warmisita qillakachimayan. Chayraykumi paytaqa yanapashaq amana mas shamur qillakachimananpaqnachu nir”. ");
INSERT INTO qufNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Chaynullami Amitunchikqa niranpis: “Mana allin jwis chaynuta ruratinqa, ");
INSERT INTO qufNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ashwan ¿Dyusninchikmaqachu mana kasuyanqa chay paypa kaqninkunata unaqpis, tutapis paypaq llakir mañakutinqa? ¿Yarakuchiyanqaraqchu? ");
INSERT INTO qufNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nishaykillapapis: Manami yarakuchirchu yanapar washayanqa. ¿Piru Dyusmanta Shamuq Runa shamurqachu, mayqanllataqa tariyanqaraq kriyiqta? nir”. ");
INSERT INTO qufNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Chaymantami Jesusqa uk kumparasyunta rurar tukuy chaypi kaqkunataqa intrachiran. Chaqa chaypi kaqkunamanta wakinqami, mana uchayjun yupay tukur ukkunataqa mana kwintachaqchu. ");
INSERT INTO qufNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Chaymi niran: “Ishkay runami riranllapa Dyusta adurananllapa wasiman mañakuq. Ukqami karan fariseo; nataq ukqa Romapaq impwistuta kubrakuq. ");
INSERT INTO qufNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Chay fariseuqami shasha kaynu niyaran paylla alabakar: ‘Tayta Dyus, nuqaqami payji nishuni mana chay wakinkuna yupay kashayrayku. Chaqa wakinkunami suwakuqkuna, malukuna, ukwan ukwan punuqkuna ima. Chaynulla nuqaqa manami kay impwistuta kubrakuq runa yupaychu kanipis. ");
INSERT INTO qufNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nuqami ayunani simanapaq ishkay kuti. Chaynulla dyis parti ganashaymanta ukta qushuni’ nir ima. ");
INSERT INTO qufNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Piru chay impwistuta kubrakuq-shuypaqa karukaqlapi sharan. Chaymi mana syilumanmapis chapakunayaqchu. Ashwanmi malay nir yarpur qasqunta takar niyaran: ‘¡Tayta Dyus llakipamay-ari! ¡Nuqami chiqap uchayjun kani!’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Chaymi nuqaqa nishaykillapa: Kay impwistuta kubrakuqqami, wasinmanqa tikrakaran, Dyus uchankunamanta pirdunar llakipashana katin. Nataq fariseo-shuypaqa mana. Chaqa mayqan kusa kani niqtaqa, mana kusapaqchu Dyusqa riqsin. Ashwan mana kusa kani niqtaqa, maydiyaqa kusa nishapaqna riqsinqa”. ");
INSERT INTO qufNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Chaymantami Jesusmanqa wamritukunata aparanllapa bindisinanpaq. Piru chay yaĉhakuqninkuna chaynu wamritukunata apaqta rikarqa, chay apaqkunataqa anyaq ĉhurakaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Chaymi Jesusqa paykunata qayar, kaynu niran: —¡Ama arkarchu, dijay nuqaman shamunqa wamritukunaqa! Chaqa Dyus mantakuyashanqami kay wamritukuna yupay mana kwintachaypaq kaqkunalapaq. ");
INSERT INTO qufNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Chiqaptami nishaykillapa: Dyus mantakuyashanman yaykunaqkunaqami kay wamritukuna yupay kanqallapa. Chaqa mana chaynu karqami Dyus mantakuyashanmanqa mana yaykunqallapachu nir. ");
INSERT INTO qufNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Uk mantakuqmi Jesusta tapuran kaynu nir: —Kusa allinla Yaĉhachikuq Taytituy, ¿imatataq rurayman, tukuy tyimpupaqna kawsanaypaqqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Chaymi Jesusqa niran: —¿Imapaqtaq kusa allin nimanki? Allinla kaqqami kan ukla. Payqami Taytay Dyus. ");
INSERT INTO qufNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Chaqa qamqami yaĉhankina, Dyus tukuy mantakushankunataqa. Chaypiqami nin: ‘Ama uk uk warmiwan punuychu; ama wanuchikuychu; ama suwakuychu; ama uknikipaq llullakur rimaychu chaynulla taytaykita, mamaykita kasuy’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Chaynu nitinmi, chay runaqa niran: —Tukuy chaykunataqami takshaymanta-pacha rurashana kani nir. ");
INSERT INTO qufNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Chaynu nitin uyarmi, Jesusqa niran: —Uksitumi faltashuyanraq ruranaykipaqqa: Rir, tukuy imayki kaqta rantikur qillaynikitaqa mana imayjun kaqkunata quy. Chaynuqami unaq syilupiqa mana tukukaq imaykitana tarikunki. Piru chay nishushayta rurarnaqami, shamutki nuqawanna rishun nir. ");
INSERT INTO qufNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Piru chaynu Jesús nitin uyaparqami, kusalata llakiran. Chaqa kusala imayjun-ari karan. ");
INSERT INTO qufNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Chaynuta rikarmi, Jesusqa niran: —¡Kusa trabajusuraq kanqa chay kusala imayjun kaqkuna, Dyus mantakuyashanman yaykunanpaqqa! ");
INSERT INTO qufNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ashwanmi chay kusala imayjunkuna, Dyus mantakuyashanman dasla yaykunanmantaqa, uk kamillu dasla pasayta puytinman uk awjapa uĉhkitunta nir. ");
INSERT INTO qufNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Chaymi uyakuqkunaqa, tapuran Jesustaqa: —Chaynu katinqa ¿pitaq washakayta puytiyanqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Chaynu nitinmi Jesusqa niran: —Runakunapaq mana ruraypaq kaqkunamapismi, Dyuspaqqa imapis ruraypaq nir. ");
INSERT INTO qufNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Chaynu nitinmi Pedruqa niran: —Taytituy, nuqakunamaqami tantar imayllapakunata dijashana, qamwanna purinillapa. ");
INSERT INTO qufNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Chaynu nitinmi, payqa niran: —Chiqaptami nishaykillapa: Mayqanpis Dyuspa mantakuyninrayku, wasinta, warminta, ukninkunata, taytankunata, wamrankunata dijaqkunaqami, ");
INSERT INTO qufNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kay pachapiqa kusala achkatana aypanqallapa chay dijashanllapamantaqa. Nataq maydiya-shuypaqa tukuy tyimpupaq kawsaytana aypanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesusqami dusi yaĉhakuqninkunata wakaqlaman qayar kaynu niran: “Kananqami rishunllapana Jerusalenman. Chaynuqami Dyuspa unay rimaqninkuna, Dyusmanta Shamuq Runapaq iskribishanllapakunaqa, kumplikanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Chaqa paytaqami mana Israelmanta runakunamanna qukunqallapa. Chaymi paykunaqa kusalata burlakanqallapa, jurapanqallapa, tuqapanqallapa ima. ");
INSERT INTO qufNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Chaymanta-shuypaqa wipyasha imana karqa wanuchinqallapa. Piru kimsa diyamantaqami qashan kawsamunqa”. ");
INSERT INTO qufNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Chaynu Jesús nitinmapis, yaĉhakuqninkunaqa mana intrakaranllapachu. Chaynulla manami yaĉharanllapapischu imapaqmi willayan nirmapis. Chaqa paykunapaqqami mana intrakaypaqchu karan. ");
INSERT INTO qufNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jericó pwiblupa shipchanpina Jesús katinqa, uk syigu runa limusnata mañakur nanpa yatalanpi tayaran. ");
INSERT INTO qufNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Chaymanta kusa achka runa pasaqta syintirqa, tapukuran imataq pasayan nir. ");
INSERT INTO qufNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Chaymi willaranllapa Nazaretmanta Jesús chayta pasayan nir. ");
INSERT INTO qufNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Chayraykumi chay syigu runaqa jwirtita kaynu niran: —¡Davidpa ayllun Jesús, llakipamastuy-ari! nir. ");
INSERT INTO qufNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Chaynu nitinmi naypaqta riqkunaqa anyaranllapa uyarananpaq. Piru payqami, ashwan mas jwirtita qayĉhakuran kaynu nir: —¡Davidpa ayllun, llakipamastuy-ari! nir. ");
INSERT INTO qufNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Chaymi Jesusqa, das shar kaĉhakuran payman apananllapapaq. Ĉhatinnaqa, Jesusqa tapuran: ");
INSERT INTO qufNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Imatataq qampaq ruranayta munayanki? nir. Chay syigu runaqa niran: —Taytituy, rikakuytami munayani nir. ");
INSERT INTO qufNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesusqa niran: —¡Rikakuynari! Chaqa kriyishaykiraykumi alliyashaykina nir. ");
INSERT INTO qufNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Chaynu nitinmi, chay kutilla rikakuranna. Chaymi Jesuspa pullanna riran Dyusta alabaqnu. Chayta rikarmi Dyustaqa tukuyla alabaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesusqami Jericó pwibluman ĉharqa, ĉhaypinta pasayaranna. ");
INSERT INTO qufNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Chaypiqami taq uk kusala imayjun runa Zaqueo shutiq. Paymi Romapaq impwistuta kubrakuqkunapaqa mantaqnin karan. ");
INSERT INTO qufNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Kay Zaqueuqami kusalata Jesusta riqsiyta munayaran. Piru payqami kusa takshala kar, chaynulla kusala achka runakuna kashanrayku mana rikaytaqa puytiyaranchu. ");
INSERT INTO qufNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Chaymi, rikananpaqqa Jesús riyashanlawman kusata kallpar rir, unaq qiruman iqaran. ");
INSERT INTO qufNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Chaymanta Jesús qirupa ĉhakinta pasayarqa, unaqman chapakur Zaqueuta rikarqa, niran: —Zaqueo, utqar ishkimuy. Chaqa kananmi wasikipi samayani nir. ");
INSERT INTO qufNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Chaynu nitinqa, Zaqueuqa chay kutilla ishkimur, kusa aligrila Jesustaqa wasinman aparan. ");
INSERT INTO qufNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Chayta rikarmi, Jesuspaqqa kusata runakunaqa rimapakuq qallariranllapa: “Uchasapa runapa wasinman risha samaq” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Chaynu niyatinllapaqa, Zaqueuqa sharir Jesustaqa niran: —¡Taytituy!, mana imayjunkunataqa tukuy imay kaqmanta lamtarta qushaq. Chaynulla mayqanta ingañar imanta suwasha karpis, kwatru kuti masta qushaq nir. ");
INSERT INTO qufNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesusqa niran: —Kay runapismi Abrahampa ayllunmanta kashanrayku, kay wasipi kaqkuna washakananpaq uraqa ĉhamushana. ");
INSERT INTO qufNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Chaqa Dyusmanta Shamuq Runaqami shamusha uchanllaparayku chinqasha kaqkunata maskar washananpaqna. ");
INSERT INTO qufNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Chaynu Jesús nitin runakuna uyaparmi yarpuranllapa, Dyus mantakunanpaqqami manana maychu nir. Chaymi Jerusalenman shipchayarnaqa payqa uk kumparasyunta parlaran, ");
INSERT INTO qufNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","kaynu nir: “Uk kusa riqsikasha ayllumantami karan uk runa. Chaymi payqa uk kutiqa kusa karu may nasyunman riran numratinllapa tikrakamurqa pwiblunpina mantakunanpaq. ");
INSERT INTO qufNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Piru manaraq riyarqami, dyis sirbikuqninkunata qayamur, tukuyninta achka qillayta qur, niran: ‘Nuqa tikrakamunaykamanqa kay qillayniykunawanqa nigusyuta ruraskinkillapa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Nataq chay pwiblunmanta runakunaqami paytaqa ĉhiqniqllapa. Chaymi ikintaqa kaĉhakuranllapa ninanllapapaq: ‘Kay runataqa mana munayanillapachu mantaqniyllapa kananpaqqa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Piru chaynu kaĉhakutinllapamapis, paytaqa numraranllapana mantakuq kananpaq. Chaymanta pwibluman tikrakamurnaqa, kaĉhakuran chay sirbikuqninkunata qayamunanllapapaq. Chayna tapunanpaq, chay qillayninta qushushayllapataqa, kada runa michkatataq ganachishaykillapa nir. ");
INSERT INTO qufNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Chayna punta chayta taputinqa, niran: ‘Taytituy, qillaynikiqami dyis kuti masta ganasha’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Chaynu nitinqa, chay mantakuqninqa niran: ‘Allinpi. Qamqami kusa allin sirbikuq kanki. Chaynu chay pitila kaqpi kusa allin karanta rurashaykiraykumi ashwan dyis pwiblukunata mantanaykipaqna numrashayki’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Chaymantaqa uk sirbikuqpis qimikarqa kaynu niran: ‘Taytituy, qillaynikiqami ganasha sinku kuti masta’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Chaymi mantaqninqa paytapis niran: ‘Qamtapis sinku pwiblukunata mantanaykipaqna numrashayki’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Piru uk qimikar-shuypaqa kaynu niran: ‘Taytituy, kaypimi qillaynikiqa. Ĉhuraraymi uk pañulapi watar. ");
INSERT INTO qufNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Chaqa manchakuraymi, kusala marraju kashaykirayku mana tarpukushaykimanta kusichakunki, chaynulla mana shikwakushaykikunamanta tantakunki nir, yaĉhashayrayku’. ");
INSERT INTO qufNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Chaynu nitinqa, mantaqninqa niran: ‘Mana allin sirbikuq, qam rimashaykillawan rikashur yaĉhani, imanumi kanki nirmapis. Chaqa chaynu nuqa marraju kani nir, chaynulla mana tarpukushaymanta kusichakuni, mana shikwakushaymanta tantakuni nir yaĉharqa, ");
INSERT INTO qufNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Imapaqtaq bankuman mana aparayki qillayniyqa ganaskinanpaq? Chaynuqami ashwan tikrakamurqa ganashanwanna aypanayta’. ");
INSERT INTO qufNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Chaynu nirqa, wakin runakuna chaypi kaqkunataqa niran: ‘Chay runataqa qillayniyta kitar quyllapa, chay dyis kuti masta ganachisha chayta’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Chaymi paykunaqa niranllapa: ‘¡Piru Taytituy, payqa dyis kuti mas qillayniyjunna!’ ");
INSERT INTO qufNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Chaynu nitinllapami mantakuqqa niran: ‘Nishaykillapa: Chay mayqanĉhi allinta rurashanrayku, imayjun kaqtaqami masta qushaq. Piru chay mana allinta rurashanrayku mana imayjun kaqtaqami, pitila kaqninmatapis limpula kitashaq. ");
INSERT INTO qufNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Chaynulla mana mantakunayta munar ĉhiqnimaqkunata-shuypaqa, kayman apamur naypaypi wanuchiyllapa’ nir”. ");
INSERT INTO qufNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Kaykunata nirqami, Jesusqa riranna Jerusalenmanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Chaymanta, chay Olivos sirkapa yatan Betfagiman, chaynulla Betania pwibluman yaqqa ĉhashana karqa, kaĉhakuran ishkay yaĉhakuqninkunata, ");
INSERT INTO qufNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","kaynu nir: —Riyllapa, wak naypanchikpi pwiblitu kan chayman. Chayman ĉharqami, tarinkillapa uk burru wataraqta. Chay burrupiqami manaraq mayqanpis tasharaqchu. Chayta kaĉhar apamuyllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nataq, mayqan ‘¿Imapaqtaq burruta kaĉhayankillapa?’ nishutinllapaqa, niyllapa ‘Taytanchikmi ministiyan’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Chaynu nitinqa, yaĉhakuqninkunaqa riranllapa. Chaynu rirllapaqa, imanuĉhi Jesús nisha karan chaynulla burrutaqa wataraqta tariranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Burruta kaĉhayatinllapanaqa amunkunaqa rikarimur kaynu nir tapuranllapa: —¿Imapaqtaq burruta kaĉhayankillapa? nir. ");
INSERT INTO qufNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Chaynu nitinqa paykunaqa niranllapa: —Taytitunchikmi ministiyan nir. ");
INSERT INTO qufNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Chaynu nirnaqami, raĉhpankunata burrupa ananman ĉhurar aparanllapa Jesusman. Ĉhachirnaqa, chay burritupa ananpina tachiranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Chaymi chaynu Jesús burrupa anan ritinqa, runakunaqa naypanta riranllapa raĉhpankunata ĉhukir ima. Chaylatami burruqa riran. ");
INSERT INTO qufNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Chaynu riyar chay Olivos sirkapa urayninman shipchayatinllapanaqa, tukuyla kriyiqkunaqa kusalata aligriyaranllapa. Chaymi kusa jwirtita rimaq qallariranllapa tukuy milagrukunata rurashanpaq yarpur ima. ");
INSERT INTO qufNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Kaynumiri niyaqllapa: “¡Biba biba! ¡Kusa alabakashami kanqa gubyirnunchik, Taytanchik Dyuspa shutinpi shamuqqa! ¡Unaq syilupipis aligriyanqallapa! ¡Kusa shumaqtami alabanqallapa Dyusninchiktaqa!” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Chaymi wakin fariseo runakuna chaypi uyakuqkunaqa, kaynu niranllapa Jesustaqa: —Yaĉhachikuq Taytituy, yaĉhakuqnikikunata anyar uyarachiy nir. ");
INSERT INTO qufNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Chaynu nitinqa, Jesusqa niran: —Qamkunata willashaykillapa, kay runakuna upallatinllapaqami ashwan rumikunamapis qayĉhakunqallapa nir. ");
INSERT INTO qufNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Chaymanta Jerusalén yatanmanna ĉhar chay pwibluta rikarnaqa, Jesusqa chay pwiblurayku waqaq qallariran ");
INSERT INTO qufNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","kaynu nir: “¡Jerusalenmanta runakuna! Kusa allinĉhi kanman qamkuna kay diyapi kwintata qukanaykipaq, nuqami shamusha kani yanapashuq, shumaqta kawsanaykillapapaq nir. Piru chaypaqqami mana kwintata qukankillapachu. ");
INSERT INTO qufNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ay, qamkunapaqqami kanqa allipla saqra diyakuna. Chaymi kuntraykikunaqa shamur, wakmanta kaymanta arkar kurralashurllapa ima, limpu wanuchir tukchishunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Tukuyla Jerusalén pwiblupi kaqkunaqa, tukukanqallapa. Chaypiqami, mana uk rumi, uk rumipa ananlapimapis llutakashaqa kidanqachu. Chaqa qamkunaqa, Dyus washashuqllapa shamutinpis, mana kasushaykillapachu”. ");
INSERT INTO qufNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Chaymanta Jesusqa, Dyusta adurananllapa wasiman yaykur, chay ruripi rantikuqkunata, rantiqkunata itakuq ĉhurakaran, ");
INSERT INTO qufNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","kaynu nir: “Dyus nitin iskribikashakunapiqami nin: ‘Wasiyqami nuqaman mañakunanllapalapaq wasi kanqa’ nir. Piru qamkunaqami suwakuqkunapa maĉhayninpaqna tikrashaykillapa” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jesusqami waran waran, Dyusta adurananllapa wasipi yaĉhachikuq. Piru chay kurakunapa mantaqninkuna, Moisés mantakushanta yaĉhar yaĉhachikuqkuna, chaynulla wakin karguyjun runakunapis, yarpuranllapa imanullapis Jesustaqa wanuchinanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Piru manami imanupis wanuchiyta puytiranllapachu. Chaqa tukuyla runakunami Jesús yaĉhachikutinqa kusa qasillala uyakuyaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Uk diyapimi, Jesusqa Dyusta adurananllapa wasipi Dyuspa shumaq rimayninta imanu washakananllapapaq nir runakunataqa yaĉhachiyaran. Chaymantami, ĉharanllapa kurakunapa mantaqninkuna, Moisés mantakushanta yaĉhar yaĉhachikuqkuna, ruku mantakuqkuna ima. ");
INSERT INTO qufNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Chaymi kaynu nir tapuranllapa: —¡Willamayllapa! ¿Mayqan mantashutintaq tukuy chaykunata rurankiqa? ");
INSERT INTO qufNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Chaymi Jesusqa niran: —¡Ma nuqapis tapushutiyllapa, willamayllapa! ");
INSERT INTO qufNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Mayqantaq Shutichikuq Juantaqa kaĉhamuran shutichikunanpaqqa? ¿Dyus, manaqachu runakunala? ");
INSERT INTO qufNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Chaynu nitinmi, paynin paynin willanakur kaynu ninakuyaqllapa: “ ‘Dyusmi kaĉhamuran’ niytaqa manami puytinchikllapachu. Chaqa, chaynu nishallapaqa ‘¿Imapaqtaq mana kriyiraykillapa?’ nimashunllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Chaynulla manami ‘Runakunala’ niytapis puytinchikllapachu. Chaynu nishallapaqami, runakuna rumillawan sitar wanuchimachuwanllapa. Chaqa chiqaptari yarpunllapa: Juanqa Dyuspa rimaqnin karan nir”. ");
INSERT INTO qufNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Chaymi paykunaqa niranllapa: —Manami yaĉhanillapachu mayqan kaĉhamuran nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesuspis paykunataqa niran: —Chayqa nuqapis manami willashaykillapachu, mayqan mantamatinmi tukuy kaykunata rurani nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Chaymantaqa tukuy runakunata kay kumparasyunta parlaq qallariran: “Uk runami ĉhakranpi ubata tarpuran. Chaymantaqa ayka runakunata trabajananpaq arrintar riran largu mayta, mana das tikrakamuqchu. ");
INSERT INTO qufNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Chaymanta kusicha tyimpu ĉhamutinqa, chay ĉhakrapa amunqa kaĉhamuran uk sirbikuqninta, chay kusichakushanmanta paypaq kaq partinta qunanllapapaq. Piru ashwan chay ĉhakrapi trabajaqkunaqami chay sirbikuqtaqa aypar kusalata maqar ima mana imatapis qurchu qatiĉharanllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","“Chaymantaqa qashan kaĉhamuran uk sirbikuqninta. Piru chaytapis, chay ĉhakrapi trabajaqkunaqa maqar, jurapar ima mana imatapis qurchu qatiĉharanllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Qashan uk sirbikuqninta kaĉhamuran. Piru chaytapis chaynullata rurar lisyar ima ĉhakramantaqa itakuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Chaynu chay sirbikuqninkunata rurar mana kasutinqa, chay ĉhakrapa amunqa niran: ‘¿Imanashaqna kananqa? Kusala munashay wamraytana kaĉhashaq dijur. Ichapis rispitar kasunmanllapa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Chayna wamranta kaĉhatin, chay ĉhakrapi trabajaqkuna rikarqa, ninakuranllapa: ‘Wakmi kay pachataqa irinsyanpaq aypayanqa. ¡Ashwan wanuchishunllapa nuqanchikkunana kay ĉhakrawanqa kidanallapapaq!’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Chaynu nirllapa ĉhakramantaqa urqur, wanuchiranllapa”. Chaynu kumparasyunta rurarqa Jesusqa kaynu niran: —Chay ĉhakrapa amun shamurqa, chay ĉhakrapi kaqkunawanqa, ¿imatataq rurayanqa nir yarpunkillapa qamkunaqa? ");
INSERT INTO qufNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Chaqa chay ĉhakrapi kaqkunataqa rir limpu wanuchir ukkunatana quyanqa chay pachantaqa. Chaynu Jesús nitinmi niranllapa: —¡Manami chaynuqa kanqachu! nir. ");
INSERT INTO qufNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Chaynu nitinllapaqa, kusata paykunataqa chapar Jesusqa niran: —Mana chaynu katinqa, ¿ima nishaq nirtaq, Dyus nitin iskribikashakunapiqa nin?: ‘Chay llutakuqkuna kay rumiqa mana sirbinchu nir itakushanllapami, ashwan kusala shumaq rumipaq tikrakasha’ nirqa. ");
INSERT INTO qufNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Chaymi, chay rumipa ananman mayqanpis rataqqa, limpu limpu llampunqa. Nataq, rumi runapa ananman ratar-shuypaqa, limpu limpu pulbupaq tikranqa nir. ");
INSERT INTO qufNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Chaynu nitinmi, kurapa mantaqninkuna, Moisés mantakushanta yaĉhar yaĉhachikuqkuna uyaparllapaqa, kwintata qukaranllapa paykunapaq rimayan nir. Chaymi chay kutilla, Jesusta aypar prisunaranllapa. Piru mana puytiranllapachu runakunata manchashanllaparayku. ");
INSERT INTO qufNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Chaymantami ashwan, wakin runakunata kaĉharanllapa mananula Dyuspi kriyiq tukur, Jesusta uyakunanllapapaq. Chayna imanullapis mana allinkunata rimachir, chaylapaqna aypar apananllapapaq Romapa gubirnadurninman. ");
INSERT INTO qufNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Chaynuta yarpurllapami, kaynu nir Jesustaqa tapuranllapa: —Yaĉhachikuq Taytituy, yaĉhanillapami qam yaĉhachikuyashayki, rimayashaykiqa chiqap nir. Chaynu karmi, mana runakunata riparayta yarpunkichu imanu katinmapis. Ashwan qamqami yaĉhachikunki Dyus munashannulata. ");
INSERT INTO qufNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Chaymi nishunillapa: ¿Allinchu kanqa Romapa punta gubyirnun Cesarta impwistuta pagranayllapapaqqa? ");
INSERT INTO qufNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesusqa chay mana allinta yarpuyashanllapapaq kwintata qukarmi, niran: —¿Imapaqtaq mana allinta rimachir uchachamanayankillapa? ");
INSERT INTO qufNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Ma, rikachimayllapa uk qillayta. ¿Mayqanpa ritratuntaq kay qillaypiqa? ¿Mayqanpa shutintaq iskribikasha? nir. Chaynu taputinqa, paykunaqa niranllapa: —Gubyirnu Cesarpami nir. ");
INSERT INTO qufNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Chaymantami Jesusqa niran: —Chaynu katinqa, gubyirnu Cesarpa kaqnintaqa payta quyllapa. Nataq Dyuspa kaqnintaqa Dyusta quyllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Chaynu Jesús tukuy runakunapa naypanpi rimatinqami, mana imanupis uchachayta puytiranllapachu. Ashwan dispantakar uyaralana kidaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Chaymantaqa ayka Saduceo runakuna riranllapa Jesustaqa rikaq. Paykunaqami ninllapa: “Wanuqkunaqashi manana kawsamunnachu” nir. Chaymi tapuranllapa Jesustaqa: ");
INSERT INTO qufNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Yaĉhachikuq Taytituy, Moisesmi kaynu nir iskribisha karan: ‘Mayqan warmiyjun kayar, manaraq wamrayjun kar wanutinqa, chay wanushapa ukninnashi kasarayanqa chay byuda warmiwanqa. Chayna chay wanusha ukninpaqqa wamrayjun kananpaq’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Chaqa, uk kutimi syiti irmanukuna karanllapa. Kulakanllapaqa, warmikur manaraq wamrayjunchu kayar wanuran. ");
INSERT INTO qufNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Chaymi chay ishkay kaq uknin, ");
INSERT INTO qufNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","chaynulla kimsa kaq ukninpis chay warmillawan kasararan. Chaynumi syitinllapa chay warmillawan kasarar, manaraq wamrayjun kayar tukuynin wanuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Chaymantami chay warmipis wanuranna. ");
INSERT INTO qufNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nataq chay wanushakuna maydiya kawsamutinqa ¿mayqanninpa warmintaq kanqa chay warmiqa? Chaqa tukuynin-ari kasarasha karan chay warmillawan. ");
INSERT INTO qufNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Chaynu nitinllapami, Jesusqa niran: —Kananmi kay bidapiqa kasaranllapa, chaynulla kasarachikunllapa ima. ");
INSERT INTO qufNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Piru, Dyus munashannullata shumaqta rurar taqkunaqami, wanushanmanta kawsamur uk bidapiqa, manana kasaranqallapanachu. Chaynulla mananami kasarachikunqallapa imamapischu. ");
INSERT INTO qufNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Chaqa paykunaqa manana wanurchu angelkuna yupayna kanqallapa. Chaynulla, wanushanmanta kawsamushanllaparayku, Dyuspa Wamranna kanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Chaynumi, ashwan Dyus nitin Moisés chay sarsa rupayashanpaq iskribishanllapi, intrachimanchik, wanushakunaqashi kawsamuyanqa nir. Chaqa ninmi: Dyusqashi, Abrahampa, Isaacpa, Jacobupa, Dyusnin nir. ");
INSERT INTO qufNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Chaymi, Tayta Dyusqa mana wanushakunapa Dyusninchu, ashwan payqami tukuy kawsaqkunapa Dyusninla. Chaynu katinmi, ¡paypaqqa tukuy mayqanpis kawsayan! nir. ");
INSERT INTO qufNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Chaymantaqa wakin yaĉhar yaĉhachikuqkunaqa niranllapa: —Allintami nishayki Yaĉhachikuq Taytituy. ");
INSERT INTO qufNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Chaymi chaymanta-pacha, manana mayqanninlapis tapuyta yarpuranllapalamanapischu. ");
INSERT INTO qufNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Chaymantami Jesusqa paykunataqa tapuran kaynu nir: —¿Imapaqtaq Dyuspa Akrashan Cristuntaqa Davidpa ayllunmanta ninllapa? ");
INSERT INTO qufNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Chaqa Davidqami paylla Salmos librunpiqa nin: ‘Tayta Dyusmi Amituytaqa kaynu niran: Tay allilaw qichqayman, ");
INSERT INTO qufNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","maydiya chay ĉhiqnishuqkunata ĉhakikipa ĉhakinman ĉhuramunaykaman nir’. ");
INSERT INTO qufNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Chaynu Davidpa ayllunmanta Dyuspa Akrashan Cristun katinqa, ¿imapaqtaq Davidqa ‘Amituy’ niran? ");
INSERT INTO qufNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tukuyla runakuna uyakutinmi yaĉhakuqninkunata Jesusqa kaynu niran: ");
INSERT INTO qufNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Allita kwintata qukarmi, kuytakankillapa Moisés mantakushanta yaĉhar yaĉhachikuqkunamanta. Chaqa paykunaqami munanllapa atun raĉhpanllapata yakakuyta, chaynulla plasakunapimapis kusala shumaqta saludananllapata ima. Chaymi chay tantakananllapa wasikunapi manaqa mikunanpaq apatinllapamapis, kusa runapaq riqsir chay kusala shumaq samanakunapi samachinanllapata munan. ");
INSERT INTO qufNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Chaynullami chay wakcha warmikunata kitanllapa wasinkunata ima. Piru allin runa ninanllapapaqqami kusala unayta Dyusman mañakuq yupay tukunllapa. Chaymi kusala manchaypaqtana kastigakanqallapa” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesusmi, Dyusta adurananllapa wasipi, rikakuyaran kusa imayjun runakuna, ufrindanta kajunkunaman itatinllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Chaynullami rikaranpis uk mana imayjun byuda ishkay qillaysituta kajunkunaman itaqta. ");
INSERT INTO qufNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Chaymi Jesusqa niran: —Chiqaptami nishaykillapa: Kay mana imayjun byudaqami, tukuy runakunamanta masta ĉhurasha ufrindantaqa. ");
INSERT INTO qufNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Chaqa, tukuy wakin runakunaqami qillaynin subraqlata ufrindakunllapa. Nataq chay mana imayjun byuda-shuypaqami, mana mas qillaynin mikunanpaq katinmapis, limpula ufrindakusha nir. ");
INSERT INTO qufNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Chayllapimi, wakinkunaqa kusata parlayaqllapa Dyusta adurananllapa wasipaq, chay kusa shumaq rumikunawan shasha karan chaykunapaq, ufrinditakunata ĉhurashanllapakunapaq ima. Chaymi Jesusqa niran: ");
INSERT INTO qufNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Uk diyami ĉhamunqa. Chaymi chay diyapiqa kanan kay rikayashaykillapataqa limpu ratachitinllapa, manana uk rumilamapis anapura llutakashaqa kidanqanachu” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Chaymantaqa Jesustaqa kaynu nir tapuranllapa: —Yaĉhachikuq Taytituy, ¿maydiyataq chaynuqa pasayanqa? ¿Ima siñalta rikartaq yaĉhayashaqllapa, tukuy chaykuna pasananpaq diyaqa shipchana? nirqa. ");
INSERT INTO qufNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Chaynu nir taputinllapaqa Jesusqa niran: “Allitami kuytakankillapa ama ingañakanaykillapapaq. Chaqa kusala achkami nuqa yupay tukur shamunqallapa. Chaymi ninqallapa: ‘Nuqami kani Dyuspa Akrashan Cristun’. ‘Chay tukukanan tyimpuqami ĉhamunqana’ nir. Chaynu nishutinllapamapis, qamkunaqa ama kriyinkillapachu. ");
INSERT INTO qufNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Chayna, wakpi kaypi guerrata rurayanllapa nir, gubyirnupa kuntran tikrakayanllapa nir ima uyaparmapis, ama manchakunkillapachu. Chaqa chaynumiri pasanqa. Piru chaynu pasatinmapis manaraqmi kay pacha tukukanan tyimpuraqchu kanqa”. ");
INSERT INTO qufNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Niranpismi: “Uk nasyunmanta kaqkunami maqanakunqallapa uklaw nasyunmanta kaqkunawan. Chaynulla uk gubyirnupa kaqninkunapis maqanakunqallapa uklaw gubyirnupa kaqninkunawan. ");
INSERT INTO qufNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kusala achka lugarkunapimi pachamapis kusalata kuyunqa. Chaynulla kusala mallaq tyimpu imami kanqa. Qishaykunamapis kusala saqra mana rikashaykillapakuna kanqa, tukuy pachapi. Syilupipis rikankillapa dispantaypaq allipla mana rikashaykillapakunata ima. ");
INSERT INTO qufNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Piru kaykuna manaraq chaynu kayatinqami, qamkunataqa aypashunqallapa, kusata qischashunqallapa chay tantakananllapa wasikunapi. Apashunqallapapis karsilkunaman itashuqllapa. Chaynulla qukushunqallapa gubirnadurkunapa, gubyirnukunapa naypanman ima nuqapi kriyishaykillaparayku. ");
INSERT INTO qufNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Chaynu apashutinllapamapis ashwan qamkunaqa nuqallapaq rimankillapa. ");
INSERT INTO qufNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Qamkunaqa, amami llakir yarpupakunkillapachu imataraq rimar washakashunllapa nirqa. ");
INSERT INTO qufNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Chaqa, nuqami chay urasqa yanapashaykillapa allipla shumaqta rimanaykillapapaq. Chaymi kuntrashuqkunaqa mana imata nishuyllapatapis puytinqallapachu, allita rimashaykillaparayku. ");
INSERT INTO qufNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Chaynulla nishaykillapapis: Qamkunataqami taytaykillapa, uknikillapakuna, primuykillapa, chaynulla amiguykikunamapis chay ĉhiqnishuqkunaman qukushunqallapa. Nataq wakinnikillapallataqa wanuchishunqallapa ima. ");
INSERT INTO qufNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Chaymi tukuyla kay pachapiqa nuqapi kriyishaykillaparayku ĉhiqnishunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Piru qamkunapaqami, mana umaykillapamanta uk aqchaykillapalamapis chinqanqachu nuqapaqqa. ");
INSERT INTO qufNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Chayraykumi nuqalapi allita kriyir shachinakurqa tukuy tyimpupaqna kawsankillapa. ");
INSERT INTO qufNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Chayna, Jerusalén pwiblupa ridurninman kusa achka suldadukuna ĉhaqta rikarqa, yaĉhankillapana mananami maychu chay pwiblu tukukananpaq kanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Chaymi chay Judea lugarpi kaqkunaqa, sirkakunaman alsakankillapa. Chaynulla, Jerusalenpi kaqkunapis lluqshinkillapa chay pwiblumantaqa. Nataq, chay ĉhakrapi kaqkuna-shuypaqa amallana tikrakankillapachu chay pwiblumanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Chaqa chay diyakunapimi, Dyuspa librun mantakushanpi kastigupaq iskribikashanqa kumplikayan. ");
INSERT INTO qufNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Akakaw chay diyakunapi warmikuna ruriyjun, manaqa ñuñuq wamrayjun kaqkunaqa imananqallaparaq! Chaqa allipla manchakuypaq nanachikuykuna chaynulla kusala saqra manchaypaq kastigumi chay pwiblupiqa kanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Wakinkunaqami wanunqallapa kuchilluwan lisyakar, chaynulla wakinkunataqa aypar prisur purichinqallapa tukuy nasyunkunapi. Nataq, Dyuspi mana kriyiq runakunaqa, Jerusalén pwiblutaqa limpu saruĉhanqallapa, paykunapaq Dyus imanu kananpaq nishan tyimpu kumplikanankaman. ");
INSERT INTO qufNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Chaymi siñalkuna kanqa rupaypi, killapi, qullarkunapi ima. Nataq pachapi-shuypaqa tukuy runakuna dispantakashalla kidanqallapa. Chaynulla alliplata manchakunqallapa, mar yaku kusalata maqchikar waqamutin. ");
INSERT INTO qufNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Runakunami kusata manchakur, imana kay pachapiqa kanan-shuypaqa pasayanqa nir yarpur, limpu dismayanqallapa. Chaqa syilupi tukuy kaqkunamapis kusalata kuyunqa. ");
INSERT INTO qufNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Chaymantami Dyusmanta Shamuq Runataqa rikanqallapa kusa llipyalla pudirninwan puktaypa rurinta shamuqtana. ");
INSERT INTO qufNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Qamkuna nuqapi kriyiqkuna, kaynu tukuq qallaritinqa, animuta aypar umaykillapata unaqman alsar nuqapaq chapakunkillapa. Chaqa mananami maychu kanqa washakanaykillapapaqqa”. ");
INSERT INTO qufNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Chaynupaqmi, kay kumparasyuntapis ruraran: “Allita rikayllapa igus qiruta, manaqa wakin qirukunatapis. ");
INSERT INTO qufNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Chaqa chay qiru mushuqmanta qawamuqta rikarqa, yaĉhankillapana tamya tyimpuqa shipchana nir. ");
INSERT INTO qufNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Chaynulla chay nishushaykunata pasaqta rikarqa, yaĉhankillapana Dyus mushuqmanta mantakunanpaq tyimpuqa shipchana nir. ");
INSERT INTO qufNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Chaymi chiqapta nishaykillapa: Chay tyimpupi kaq runakunaqa manaraq wanuyatinraqmi tukuyla kay nishushayllapaqa pasanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Chaqa syilu chaynulla kay pachamapismi tukukanqa. Piru nuqa nishaykuna-shuypaqami mana maydiyalapis tukukanqachu. ");
INSERT INTO qufNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Kuytakankillapa, amami dijankillapachu yarpuynikillapa chay mana allin ruraykunata rurachishunanllapapaqqa. Chaynulla ama maĉhankillapachu, ama yarpupakankillapapischu kay bidapi kawsayashaykillapapaqqa. Ama chay jwisyu diyapiqa qamkunata, chay mana allin ruraykuna daskaqla ratachishunanllapapaqchu. ");
INSERT INTO qufNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Chaqa chay shamuq diyaqami shamunqa kay pachapi tukuy runakuna kawsaqkunaman. ");
INSERT INTO qufNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Chayrayku, qamkunaqa rikĉhakushala kar tukuy tyimpula Dyuspi yarpur, payman mañakuyllapa chay saqra kastigukunamantaqa washakarna, Dyusmanta Shamuq Runapa naypanman ĉhanaykillapapaq”. ");
INSERT INTO qufNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Chaynumiri Jesusqa, unaqqa yaĉhachikuq Dyusta adurananllapa wasipi. Nataq, tutaman-shuypaqa chay Olivos sirkapi kidaq. ");
INSERT INTO qufNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Chaymi, tukuy runakunaqa allaq allaqla riqllapa Dyusta adurananllapa wasimanqa, Jesusta uyakuq. ");
INSERT INTO qufNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Shipchamuyarannami Pascua fyistapi mana libadurayjun tantata mikuqllapa chay diyaqa. ");
INSERT INTO qufNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Nataq chay kurakunapa mantakuqninkuna, Moisés mantakushanta yaĉhar yaĉhachikuqkunaqa, yarpuranllapa imanullapis Jesustaqa wanuchinanllapapaq. Piru runakunata manchashanllaparaykumi mana aypayta puytiranllapachu. ");
INSERT INTO qufNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Chaynu katinmiri, Jesuspa dusi yaĉhakuqninkunapa uknin Judas Iscariotimanqa Satanás yaykuran. ");
INSERT INTO qufNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Paymi riran kurakunapa mantakuqninkunata, Dyusta adurananllapa wasipi kuytakuqkunapa mantakuqninkunawan parlaq, “Imanumi Jesustaqa qushaykillapa” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Chaynu nitinmi, kusata aligriyar qillayta arniranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Chaymi Judasqa “Arí” nir, imanulapis allita rikar maykaqlapipis runakuna mana yaqqa kaq yupay katin, “Rikachishutiyllapa aypankillapa” niran. ");
INSERT INTO qufNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pascua fyistapi mana libadurayjun tantata mikuqllapa chay diyapinami karanllapa. Chaynulla chay diyapimi uyshitakunata ufrindapaq nir wanuchiqllapapis. ");
INSERT INTO qufNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Chaymi Pedruwan Juantaqa, Jesusqa kaĉharan kaynu nir: —Rir kamakachiyllapa Pascua fyistapi mikunanchikllapata. ");
INSERT INTO qufNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Chaynu nitinqa paykunaqa tapuranllapa: —¿Maypitaq kamakachinayllapata munayanki? nir. ");
INSERT INTO qufNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesusqa niran: —Jerusalén pwibluman ĉharnaqami, uk runa kantarunpi yakuta apaqta tarinkillapa. Chaymi paypa ikinta rinkillapa wasinman yaykunankaman. ");
INSERT INTO qufNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Chaymantami chay wasipa amuntaqa ninkillapa: ‘Yaĉhachimaqniyllapami nin: ¿Maylaw kwartuykipitaq yaĉhakuqniykunawan Pascua mikunata mikushaq? niyan’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Chaynu nitkillapami payqa rikachishunqallapa wasinpa unaqninpi uk atun kwartu kusala kamakashatana. Chaymi chaypi kamkachinkillapa mikunallapapaqqa. ");
INSERT INTO qufNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Chaynu nitinmi paykunaqa rir, Jesús nishannulla tariranllapa. Chaymi chaypina kamakachiranllapa Pascua mikunataqa. ");
INSERT INTO qufNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Chaymanta mikunanllapa uras ĉhamutinqa, Jesusqa apustulninkunawan samaranna misamanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Chaymi Jesusqa paykunataqa niran: “Kanan manaraq qischakar wanuyashayllami, ¡alliplata munasha kani qamkunawan pulla tantanakur mikunallapapaq! ");
INSERT INTO qufNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Chaqa kanan mikushallapaqami manana qashanqa pullaqa mikushunllapanachu, Dyus qashan mushuqmanta mantakutin, chaypi mikunallapakaman”. ");
INSERT INTO qufNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Chaynu nirqa uk kupata aypar, Dyusta payji nishana kar niran: “Kayta aypar, aypachinakur upyayllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Allitami willashaykillapa, mananami qashanqa kay ubapa yakuntaqa upyashaqnachu, Dyus qashan mushuqmanta mantakuq qallarinankaman”. ");
INSERT INTO qufNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Chaynu nirmi, Jesusqa uk tantata aypar Taytanta payji nir, pakir quran yaĉhakuqninkunata kaynu nir: “Kaymi nuqapa kwirpuy. Qamkunata washashunayllapapaq wanuyani chay. Kaytami ama qunqarchu rurankillapa yarpumanaykillapapaq” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Chaynu mikutinllapanaqami, kupata aypar kaynu niran: “Kay yawarniyta iĉhashaywanmi Taytay Dyuswan uk mushuq tratuta rurani, qamkunata kusata llakipashushayllaparayku. ");
INSERT INTO qufNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Piru, mayqanĉhi kanan kuntraykunaman qukumayan chayqa, kay misapi nuqawan pulla. ");
INSERT INTO qufNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Chaymi Dyusmanta Shamuq Runataqa, imanutaq kananpaq karan chaynuta ruranqallapa kuntrankunaqa. ¡Piru imananqaraq, chay kuntrankunaman qukuqqa!” ");
INSERT INTO qufNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Chaynu Jesús nitinmi yaĉhakuqninkunaqa, paynin paynin niqllapa: “¿Mayqanninchikllapataq kuntrankunaman qukuyanchikllapaqa?” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jesuspa yaĉhakuqninkunaqa paykunapura anyanakuranllapa, mabir mayqanninllapashi Dyuspaqqa kusa mas allin nir. ");
INSERT INTO qufNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Chaymanta Jesusqa paykunataqa niran: “Uk nasyunkunata mantaqkunami munashannulata runa masinkunatapis mantakur purichinllapa. Chaynu karmapis, ‘Ukkunatami kusalata yanapanillapa’ nir alabakanllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Piru qamkunaqami ama chaynuchu kankimanllapa. Ashwan mayqannikillapa kusa mas yaĉhaq karqa, mana kwintachaypaqla kayllapa. Chaynulla chay mantakuqpis uk sirbikuq yupay kanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mabir willamayllapa: ¿Mayqantaq kusa mas allinqa? ¿Chay misaman mikuq tan chay runa, manaqachu chay mikuyta aypachikamun chay? Misapi samayan chay runami kusa mas allinqa. Nataq nuqaqa chay sirbikuq yupay kani qamkunapaqqa. ");
INSERT INTO qufNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Chaymi imanu ĉhiqnimaqkuna ruramatinllapamapis, qamkunaqa pullay kashaykillapa. ");
INSERT INTO qufNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Chayraykumi nuqaqa mantakunaykillapapaq nishaykillapa imanuĉhi Taytay Dyus nuqatapis mantakunaypaq nimaran, chaynulla. ");
INSERT INTO qufNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Chaynu karqami, maydiyaqa qamkunaqa mantakunaypiqa mikunkillapa, upyankillapa nuqa tashay misapi pullay. Chaynulla, mantakunaykillapa samanapi tar, Israel pwiblumanta dusi ayllukunata rikar yaĉhankillapa, allin mana allin nirmapis”. ");
INSERT INTO qufNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Chaynullami niranpis Amitunchik Jesusqa: —Simón, Simón, imanutaq wayramaqa triguta ĉhaspir qutun, chay yupaymi Satanás, nuqamanta chiqanchashunayanllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Piru Simón, nuqaqami qampaq mañakusha kani, maydiyapis nuqallapi kriyinaykipaq. Chaymi qashan nuqallawan karqa, yanapay uknikikunata nuqalapi allita kriyinanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Chaynu Jesús nitinqa, Simonqa niran: —Taytituy, nuqaqami karsilman qamwan pulla rinaypaqmapis yarpushana kani. Chaynulla wanutkimapis pullayki wanushaq. ");
INSERT INTO qufNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Piru Jesusqa niran: —Pedro, nishaykimi: Kananllami manaraq gallumapis kantayatinchu, kimsa kuti nuqapaqqa ninki ‘Manami riqsinichu’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Chaynulla Jesusqa tapuranpis yaĉhakuqninkunataqa: —Nuqami mana alfurjayjunta, mana qillayta purichinaykillapapaq talqitayjunta, mas llanqiyjunta imachu kaĉhashurayllapa. Chaynu kaĉhashutiyllapaqa, ¿imaykillapallaqachu faltashuranllapa? Chaynu nitinqa paykunaqa niranllapa: —¡Manami! ");
INSERT INTO qufNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Chaymanta Jesusqa niran: —Kanan-shuypaqa alfurjayjun kaqqa apayllapa. Chaynulla qillayta purichinaykillapa talqitatapis apayllapa. Nataq mayqannikillapa mana ispadayjun karqa, punchuykillapamatapis rantikur rantiyllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Imapaqmi chaynutaqa nishuyanillapa. Chaqa nuqawanmi Dyus nitin iskribikashankunaqa kumplikanqa. Chaqa niqmi: ‘Mana allin runakunawan pullata, mana allinpaq riqsimanqallapa’ nir. Chaynumiri Dyus nitin nuqapaq tukuy iskribikashakunaqa, kumplikayanqa chay nishannulla. ");
INSERT INTO qufNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Chaynu Jesús nitinqa, paykunaqa niranllapa: —Taytituy, kaypimi ishkay ispadakunaqa nir. Chaymi Amitunchik Jesusqa niran: —Chaykaqllana nir. ");
INSERT INTO qufNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Chaymantaqa Jesusqa lluqshir riran Olivos sirkaman, chaynu kustumrin kashanrayku. Chaymi yaĉhakuqninkunapis ikinta riran. ");
INSERT INTO qufNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Chay lugarman ĉharnaqa, yaĉhakuqninkunataqa niran: —Dyusman mañakuyllapa ama uchapi ratanaykillapapaq. ");
INSERT INTO qufNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Chaynu nirqa paykunamantaqa karukaqllaman rir, chaypi qunqurikur Taytanman mañakuran, kaynu nir: ");
INSERT INTO qufNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Taytay, puytiypaq katinqa yanapamay-ari kay kusa ayaq yaku yupay qischakaymantaqa. Piru amami nuqa munashaynuchu rurakanqa. Ashwanmi qam munashayki kanqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Chaynu niyatinqami, unaq syilumanta uk ángel chaypi rikarir yanaparan. ");
INSERT INTO qufNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesusqa chay kusalata qischakananpaq karan, chaypaq yarpur kusalata mañakuyaran Dyusmanqa. Chaynu mañakutinqami, ĉhiĉhapninmapis pachaman shutuyaran yawar yupay. ");
INSERT INTO qufNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Chaynu nir, Dyusman mañakurnaqa sharir riran chay yaĉhakuqninkuna kayashanman. Ĉharnaqa alliplata llakir shaykusha punuqta tariran paykunataqa. ");
INSERT INTO qufNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Chaymi kaynu niran: —¿Imapaqtaq punuyankillapa? Sharir Dyusman mañakuyllapa, ama uchapi ratanaykillapapaq nir. ");
INSERT INTO qufNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Chaynu nir Jesús rimayatinllami, chay dusi yaĉhakuqninkunamanta uknin Judasqa, achka runakunapa naypanta ĉharan. Chaymi qimikaran Jesustaqa muchar saludananpaq. ");
INSERT INTO qufNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Piru Jesusqa niran: —Judas, ¿mucharlachu Dyusmanta Shamuq Runataqa kuntrankunaman qukunki? nir. ");
INSERT INTO qufNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Chaymi chaypi Jesuswan kaqkunaqa, imami pasayan nir kwintata qukar, niranllapa: —Taytituy, ¿ispadakunawanchu washakashunllapa? nir. ");
INSERT INTO qufNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Chaynu nitinqa, chaypi kaqkunamanta ukninqa, kurakunapa mantaqninta sirbiq runapa allilaw rinrinta ¡saq! pitiran. ");
INSERT INTO qufNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesusqa niran: —¡Amana mas imatapis rurayllapachu! nir. Chaynu nirmi chay sirbikuqpa rinrintaqa kamarla, allicharan. ");
INSERT INTO qufNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Chaynu rurarnaqa chay kurakunapa mantakuqninkunata, Dyusta adurananllapa wasipi kuytakuqkunapa mantakuqninkunata, chaynulla tukuy ruku mantakuqkunawan payta apaq shamushakunataqa, niran: —¿Imapaqtaq ispadakunawan, qirukunawan ima, uk suwakuqman yupay shamushaykillapa nuqamanqa? ");
INSERT INTO qufNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nuqaqami imuraspis Dyusta adurananllapa wasipiqa qamkunawan pulla katiyqa, mana imatapis ruramaraykillapachu. Piru qamkuna tutaparaqmanta kar, kanan tutapashana katinqa, imatapis rurayashaq nir yarpunkillapana. Chaqa uraykillapa ĉhamushanari nir. ");
INSERT INTO qufNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Chaymanta Jesustaqa aypar aparanllapana kurakunapa punta mantaqninpa wasinman. Piru Pedruqami largukaqllamanta chapar, ikinllapata riyaran. ");
INSERT INTO qufNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Chaymi chay wasipa pampanpa ĉhaypinpi ninata ratachir chaypa ridurninlapi tukuy taranllapa. Pedrupis chaypi paykunawan pulla tayaran. ");
INSERT INTO qufNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Chaynu tayatinllapaqa, uk sirbikuq warmi Pedrutaqa rikar, kusalata chapayaran. Chaymi kaynu niran: —Kay runapismi paywanqa pulla karan nir. ");
INSERT INTO qufNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Piru Pedruqa niran: —Mamitay, manami riqsinichu chay runataqa nir. ");
INSERT INTO qufNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Chaymanta qashan uk ratukaqlamanta ukpis Pedrutaqa rikar, kaynu niran: —Qampis paypa uknin kanki nir. Pedruqa niran: —¡Manami! Mana nishuyanillapa wakmaqari. ");
INSERT INTO qufNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Chaymanta uk ura pasashana yupay katinqa, qashan ukpis niran: —Alliptamiri kay paypis Jesuswanqa pulla karan. Chaynulla payqa Galileamanta wakmaqari. ");
INSERT INTO qufNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Qashanmi Pedruqa niran: —¡Taytituy, manami yaĉhayanichu mayqanpaqmi rimayanki nirmapis! Chaynu Pedro niyatinlami chay kutilla, gallu kantaran. ");
INSERT INTO qufNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Chaymantaqa Amitunchik Jesusqa das tikrakar Pedruta chaparan. Chaynu chapatinqa, Pedruqa yarpuran, Amitunchik kaynu nishanta: “Kananllami manaraq gallu kantayatin kimsa kuti nuqapaqqa ninki: ‘Manami riqsinichu’ nir” nishanta. ");
INSERT INTO qufNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Chaymi Pedruqa chaymanta lluqshirqa kusalata llakir, piñakur ima waqaran. ");
INSERT INTO qufNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Chay runakuna Jesusta chaypi kuytar shaqkunaqa kusata asipar ima maqaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nawinkunata bindar ima kaynu tapuqllapa: —Mabir tantyay ¿pitaq maqashusha? nir ima. ");
INSERT INTO qufNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Chaynulla, allip ukmankunata tapur allipla saqra pinqaypaqta willaqllapamapis. ");
INSERT INTO qufNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Unaqna katinqa tantakaranllapa, chay Israel runakunapa ruku mantakuqninkuna, kurakunapa mantaqninkuna, chaynulla Moisés mantakushanta yaĉhar yaĉhachikuqkuna ima. Tantakarqa Jesustaqa aparan kusa mas karguyjunkunapa naypanman. Chaypiqami, kaynu nir tapuranllapa: ");
INSERT INTO qufNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Willamayllapa: ¿Qamchu Dyuspa Akrashan Cristun kanki? nir. Chaynu taputinllapaqa, payqa niran: —Nuqa, kananlla ‘Dyuspa Akrashan Cristun kani’ nishutiyllapaqa, mana kriyimankillapachu. ");
INSERT INTO qufNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Chaynulla, nuqa tapushutiyllapapis mana imatapis willamayankillapachu chaynulla mana kaĉhamayankillapalamapischu kanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Piru kananmanta-pachami, Dyusmanta Shamuq Runaqa kusa puytiq Dyuspa allilaw qichqanpi tayanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Chaynu nitinqa tukuy tapuranllapa: —Chaynu katinqa, ¿qamchu Dyuspa Wamran kanki? nir. Jesusqa niran: —Qamkunallami ninkillapa. ");
INSERT INTO qufNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Chaymantaqa paykunaqa niranllapa: —¿Ima tistigutataq masqa munanchikllapa? Chaqa nuqanchikkunalla uyapashanchikllapa paylla rimatin nir. ");
INSERT INTO qufNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tukuy chaypi kaqkunaqa, sharir aparanllapa Jesustaqa gubyirnu Pilatupa naypanman. ");
INSERT INTO qufNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Chay Pilatupa naypanpiqa, yanqa illaqmanta llullakur Jesuspaqqa willakuq qallariranllapa kaynu nir: —Kay runataqami tarisha kanillapa pwibluyllapamanta runakunata kusa ukman saqrakunata yaĉhachiqta. Chaqa, paymi nin manashi impwistuta gubyirnu Cesartaqa pagrashaqllapachu. Chaynulla ninpis payshi Dyuspa Akrashan Cristun tukuyta mantakuqqa nir. ");
INSERT INTO qufNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Chaymi Pilatuqa Jesustaqa kaynu nir tapuran: —¿Qamchu chay Israel runakunapa mantaqnin kanki? nir. Jesusqa niran: —Qamllami ninki. ");
INSERT INTO qufNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Chaynu Jesús nitinqa, Pilatuqa chay kurakunapa mantaqninta, tukuy runakunatapis niran: —Nuqapaqqami kay runaqa mana ima uchayjunchu nir. ");
INSERT INTO qufNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Chaynu nitinqa, chay runakunaqa llallin kusalata lanyar niranllapa: —Chay kusa ukmanta yaĉhachikuyashanwanmi, chay pwibluyllapamanta runakunataqa limpu pantachiyan. Chaynu mana allinta yaĉhachikuqqami qallariran Galileapi. Kanan-shuypaqa kay Judeapina puriyan nir. ");
INSERT INTO qufNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Chaynu nitinllapa uyaparqa, Pilatuqa tapukuran ¿kay runaqachu Galileamanta? nir. ");
INSERT INTO qufNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Chaymanta runakuna, Galileamantami nitinllapaqa, kaĉharan gubyirnu Herodesman. Chaqa, paypis chay diyakunapiqa Jerusalenpi karan. ");
INSERT INTO qufNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jesús chayman ĉhatin, Herodes rikarqa kusala aligrita yarpuran. Chaqa kusa unaynami paypaqqa rimaqllapata uyapasha kar, Herodesqa riqsiyta munaran. Chaynullami milagrukunata ruratin ima rikanaran. ");
INSERT INTO qufNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Chaymi kusata tapuran. Piru, Jesusqa mana imalatapis willaranchu. ");
INSERT INTO qufNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Chaypiqa karanllapapis kurakunapa mantaqninkuna, Moisés mantakushanta yaĉhar yaĉhachikuqkuna ima. Chay paykunaqami chaypiqa alliplata uchachayaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Chayna, Jesús mana imatapis rimatinqa, Herodesqa wakin suldadukunawan kusalata kushiparanllapa. Chaymi Jesusta asipananllaparaykuqa, gubyirnupa kusala ĉhaniyjun raĉhpanta yakachiranllapa. Chaynu rurayar imaqa, Herodespis Jesustaqa qashan kaĉharan Pilatuman. ");
INSERT INTO qufNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Chay diyaqamiri Pilatuwan Herodesqa kusala amiguna tikrakaranllapa, unaykuna kusata ĉhiqninakuq kasha karmapis. ");
INSERT INTO qufNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Chaymantami Pilatuqa kurakunapa mantaqninkunata, wakin karguyjunkunata, chaynulla tukuyla runakunata ima tantamuran. ");
INSERT INTO qufNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Chaymi kaynu niran: —Qamkunaqa kay runata nuqaman apamuraykillapa, ‘Pwibluymanta runakunata limpu pantachiyan’ nir. Nuqami qamkunapa naypaykillapapi tapusha kani. Piru paypa uchantaqami mana tarishachu kani qamkuna niyashaykillapanuqa. ");
INSERT INTO qufNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Chaynulla Herodespis mana paypiqa ima uchatapis tarishachu. Chayraykumi qashan nuqaman kaĉhamusha. Chayrayku yaĉhayankillapana, manami ima mana allintapis kay runaqa rurashachu nir. Chaymi wanuchinapaqqa mana allinchu. ");
INSERT INTO qufNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Chaymiri nuqaqa wipyachikurla kaĉhashaq. ");
INSERT INTO qufNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Chaynuqami Pilatuqa niran, kada Pascua fyistapi uk prisuta lluqshichiq kar. ");
INSERT INTO qufNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Chaynu Pilato nitinqami, allipta chay runakunaqa tukuynin pullalla lanyaranllapa kaynu nir: —¡Wanuchiy chaytaqa! ¡Ashwan Barrabasta karsilmanta lluqshichir kaĉhay! nir. ");
INSERT INTO qufNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Chaqa, kay Barrabastaqami karsilmanqa itasha karanllapa, Romapa gubyirnunpa kuntran kar uk runata wanuchishanpaq. ");
INSERT INTO qufNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Piru Pilatuqa, Jesusta mana wanuchiyta munarqa, qashanpis chayllata chay runakunataqa niran. ");
INSERT INTO qufNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ashwan paykunaqa kusala jwirtita lanyaranllapa kaynu nir: —¡Kruspi klabay! ¡Kruspi klabay! nir. ");
INSERT INTO qufNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Chaynu niyatinllapamapis, qashan kimsa kutipaqna Pilatuqa niran: —Chaqa ¿ima mana allintataq kayqa rurasha? Nuqapaqqami kay runaqa mana ima uchayjunpischu wanuchichikunaypaqqa. Chaymi nuqaqa kastigachikurla kaĉhashaq. ");
INSERT INTO qufNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Piru chay runakunaqami qashan kusala jwirtita kaynu nir lanyaranllapa: —¡Kruspi klabay! nir. Chaynu allipta lanyayatinllapaqami, ");
INSERT INTO qufNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilatuqa, paykuna munashanllapanullata ruraran. ");
INSERT INTO qufNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Chaymi chay Barrabás, Romapa gubyirnunpa kuntran kar uk runata wanuchisha katinmapis, karsilmanta lluqshichir, Jesusta-shuypaqa paykunatana quran. ");
INSERT INTO qufNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jesusta krusman klabaq apayarllapanaqa, Cirenemanta uk runa Simón shutiq, ĉhakranmanta shamuqta tariranllapa. Chaymi Jesuspa krusninta rikrachir, paypa ikinllata aparanllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kusala achka runakunami Jesuspa ikintaqa riranllapa. Chaynullami warmikunapis kusalata llakir, waqar ima riranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Piru Jesusqami paykunata chapar kaynu niran: “Jerusalenmanta warmisitakuna, ama nuqapaqqa waqayllapachu. Ashwan qamkunallapaq, wamraykikunapaq ima waqayllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Chaqa uk kusala qischakay tyimpukunapimi ninqallapa: ‘Allinmi kasha chay warmisitakuna mana wamrakuq chaykunapaq, chay warmi mana ruriyjunchu kaqkunapaq, chaynulla chay warmikuna mana wamran katin mana ñuñuchikuqkunapaqmapis’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Chaymi, chaynu qischakarnaqa runakunaqa qaqakunata ninqallapa: ‘¡Nuqakunapa anayllapaman ratamuyllapa!’ Chaynulla lumakunatapis ninqallapa: ‘Pakakuchimayllapa ima’ nir. ");
INSERT INTO qufNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Chaqa llullu qiruwan tukuy kaykunata rurarqa, ¿imanuna kanqa qiru chakishana katinqa?” ");
INSERT INTO qufNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Chaynullami Jesuswan pullataqa apaqllapapis ishkay wanuchikuq runakunata Jesuswan pullata kruspi klabananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Chaymanta chay uk lugar Calavera shutiqman ĉhachirllapaqa, Jesustaqa klabaranllapana kruspiqa. Chaynulla chay ishkay wanuchikuq runakunatapis kadalaw qichqanpi krusllapi klabaranllapa. Ukninta allilaw qichqanpi, ukninta ichuqlaw qichqanpi. ");
INSERT INTO qufNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Klabatinllapanaqa Jesusqa niran: “Taytay, pirdunay kay runakunataqa. Paykunaqami mana yaĉhanchu imatami rurayanllapa nirmapis”. Chaymantami chay suldadukunaqa Jesuspa raĉhpankunata surtyakur ayparanllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Runakunaqami chaypi rikakuyaranllapa, chay karguyjun runakunamapis alliplata kushikur asiparanllapa kaynu nir: —Ukkunata-shuypaqa washaran. Mabir kananqa paylla washakanqari, chiqapta Dyuspa Akrashan Cristun karqa. ");
INSERT INTO qufNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Chaynulla chay suldadukunapis Jesusmantaqa burlakaqllapa. Chaymi qimikar upyachiqllapa allipla puchqu binuta, kaynu nir: ");
INSERT INTO qufNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","—¡Chiqapta, Israelmanta runakunapa mantaqnin karqa, qamlla washakay-ari! nir. ");
INSERT INTO qufNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Chaynulla, Jesuspa umanpa ananpiqami uk litriruta ĉhuraranllapa griego rimaypi, latinpi, hebreo rimaypi ima Chaqa kaynu niyaq: “KAYMI ISRAEL RUNAKUNAPA MANTAQNIN” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Chay ishkay wanuchikuqkuna Jesuswan pulla kruspi klabaraqkunapa ukninqa, musyar kaynu niyaq: —¡Chiqapta qam Dyuspa Akrashan Cristun karqa, qamlla washakar, nuqakunatapis washamayllapari! nir. ");
INSERT INTO qufNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Chaynu nitinqami, ukninqa kaynu nir anyaran: —¿Manachu qamqa manchanki Taytanchik Dyustaqa, qam wanunaykipaqna qischakayarmapis? ");
INSERT INTO qufNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nuqanchikqa imanu mana allinta rurashanchikraykumi qischakayanchikmapis, pagrakuq yupayna, chay mana allinkunata tukushanchikpaq. Piru kay runa-shuypaqa mana imata uchakusha karmapis, qischakayan. ");
INSERT INTO qufNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Chaymantaqa niranpis chay runaqa: —Tayta Jesús, yarpumankiri qashan mushuqmanta mantakuq qallarirqa. ");
INSERT INTO qufNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Chaynu nitinqa, Jesusqa niran: —Allitami nishayki: Qamqa kananllami nuqawan pulla kanki Taytay Dyuspa luryanpi nir. ");
INSERT INTO qufNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","A las dusimanta-pacha alas tris di la tardikaman tukuy pacha allipla tutaparaq intiru kidaran. ");
INSERT INTO qufNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Rupayqami manana achkirachikamurannachu. Dyusta adurananllapa wasipa ĉhaypinpi atun rakta raĉhpa warkuraqpis ĉhaypimanta wakman kayman limpu llikikaran. ");
INSERT INTO qufNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Chay kutillami, Jesusqa kusala jwirtita qayĉhakuran kaynu nir: “¡Taytay, ispirituytami makikilaman ĉhuramuni! ¡Qamna rikapamanki!” Chaynu nirqa Jesusqa wanukuranna. ");
INSERT INTO qufNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Chaymanta chay romano suldadukunapa kapitannin, tukuy chaykunata rikar uyapar imaqa, Dyusta alabaran, kaynu nir: —Chiqaptami kay runaqa mana ima uchayjunlamapischu kasha nir. ");
INSERT INTO qufNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tukuy chaypi kaqkunaqa, tukuy ima pasashanta rikarqa, kusala mana allitachu yarpur riranllapa, qasqunllapata takaqnu. ");
INSERT INTO qufNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Piru, Jesusta tukuy riqsiqkuna, Galileamanta-pacha pullan warmisitakuna rishakunapis, chayllapiraq kidaranllapa. Chaymi tukuy ima pasaqkunatapis karukaqlapi shasha rikakuyaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Karanmi uk allip allinla runa José shutiq, chay Judea lugarpa pwiblun Arimatea shutiqmanta. Payqami Israelmanta kusa mas karguyjunkunapa masin karan. Piru chay karguyjunkuna yarpushankunawanqa mana chayllatachu yarpuq. Ashwan, Dyus mushuqmanta mantakunanpaq nir yarpur, kawsaq-ari. ");
INSERT INTO qufNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Chaymi payqa Pilatuman ĉhar Jesuspa kwirpunta mañaran. ");
INSERT INTO qufNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Chayna, Pilatuqa apay nitinqa, payqa krusmanta shumaqla ishkichimur, uk yuraq raĉhpawan pillur apar ĉhuraran qaqapa paĉhanlapi uk uĉhku rurakasha karan chayman. Chaypiqami manaraq mayqantapis pampashallapachu karan. ");
INSERT INTO qufNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Chay pampayan diyapiqami, samana diyapaqna kamakachikuyaqllapa, chaqa qallariyaqnari. ");
INSERT INTO qufNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Chay warmikuna Galileamanta-pacha Jesuswan pulla riqkunaqa, riranllapa rikaq chay uĉhkutaqa. Chaymi, chaypi imanu pampatinllapamapis allita rikaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Chaymanta wasinllapaman tikrakamurllapanaqa, kusala mishki mutkiypaq rimidyitukunata kamakachiranllapa, chaykunawan Jesustaqa salar kamakachinanllapapaq. Piru chay samana diyapi-shuypaqa imanutaq kananllapapaq karan, chaynullata kumpliranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Chaymantami simanapa punta diyanpiqa, chay warmisitakunaqa allaq allaqla riranllapa Jesús pampakashanmanqa, chay mishki mutkiypaqla rimidyitukunata kamkachishanllapata apar. Chaynullami wakin warmikunapis paykunawan riranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Chayman ĉhatinllapaqa, chay uĉhkuta kirpasha kusa atun rumiqa manana tayashanpinachu kasha karan. ");
INSERT INTO qufNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Chaymi chayman yaykurqa manana tariranllapanachu Amitunchik Jesuspa kwirpuntaqa. ");
INSERT INTO qufNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Chayna chayta rikarqa, kusalata yarpupakuranllapa. Chaykamanmi ishkay runakuna kusa llipyalla yuraq mudanayjun paykunapa pullan shaqta rikaranllapa. Chaymi alliplata manchakuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Chaynu manchakushanllaparaykumi, tukuynin qunqurikur pachaman pukĉhiraranllapa. Piru chay llipyaraqlla runakunaqa niranllapa paykunataqa: —¿Imapaqtaq kawsaq runapaqqa, maskakunkillapa wanushakunapa pampakashanpiqa? ");
INSERT INTO qufNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Manami kaypinachu. Kawsamushanami. Yarpuyllapa qamkunawan pulla kar Galileapi willashushanllapata. ");
INSERT INTO qufNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","¿Manachu nishuranllapa: Dyusmanta Shamuq Runataqashi uchasapakunapa makinman qukutinllapa wanuchiyanqallapa; chaymanta kimsa diyamantaqa kawsamuyanqa nir? ");
INSERT INTO qufNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Chaymi, chaynu nitinqa, chay warmikunaqa yarpuranllapa Jesús willashanllapata. ");
INSERT INTO qufNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Chaymanta Jesús pampakashanmanta tikrakarllapaqa, unsi apustulninkunata, chaynulla wakinkunatapis willaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Chaynu Jesuspa apustulninkunata willaqkunaqami kaykuna karanllapa: María Magdalena, Juana, Santiagupa maman María, wakin warmikuna ima. ");
INSERT INTO qufNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Piru chay apustulkunata willatinllapaqa, mana kriyiranllapachu. Ashwan wak warmikunaqa yaruyasha kanqa nir yarpuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Chaynu niyatinllapamapis, Pedruqa wasimantaqa lluqshimur riran kallpaylla Jesús pampakashanmanqa. Chayman ĉhar uĉhku ruriman chapakurqa, mana imatapis rikaranchu. Ashwan Jesús pillukashan raĉhpalana chaypiqa usurayasha karan. Chaynuta rikarqami kusa dispantakashalla qashan wasinman tikrakamuran. ");
INSERT INTO qufNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Chay diyallapimi Jesuspa ishkay yaĉhakuqninkuna riranllapa Emaus pwibluman. Chay pwibluqami, Jerusalenmantaqa yaqqa ishkay urasma kasha kanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Chay paykunaqa, tukuy ima pasashanta parlaqnu riyaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Chaynu parlar ima riyatinllapaqa, Jesusqa pay paylla paykunamanqa qimikar pullanllapa riq qallariran. ");
INSERT INTO qufNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Chayna, rikarmapis paykunaqa mana riqsiranllapachu, nawinllapa bindakasha yupay kashanrayku. ");
INSERT INTO qufNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Chaymantaqa Jesusqa paykunataqa tapuran: —¿Imatataq qamkunaqa kusata parlaqnu riyankillapa nantaqa? Chaynu nitinqa, paykunaqa sharanllapa llakishala. ");
INSERT INTO qufNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Chaymantaqa uknin Cleofas shutiqqa niran: —Tukuy runakunami yaĉhanllapa kay diyakuna Jerusalenpi pasashanta. ¿Qamlachu mana yaĉhanki chaykunataqa, furastiru kashaykirayku? ");
INSERT INTO qufNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Chaynu taputinqa, paypis kaynu nir paykunataqa tapuran: —¿Imataq pasasha? Paykunaqa niranllapa: —Nazaretmanta Jesuspaqmi parlayanillapa. Chay runaqami Dyusninchikpaqqa uk puytiq rimaqnin kaq, rimayninpi, ima ruraykunapimapis. Chaynulla tukuy runakunapa naypanpimapis kusa allin kaq. ");
INSERT INTO qufNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Chay paytaqami kurakunapa mantaqninkuna, nuqakunamanta karguyjun runa masiyllapa, paytaqa uchachar qukuran kruspi klabar wanuchinanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nuqakunaqami alliplata paypi yarpur yarakuyarayllapa, pay washayanqa nasyunniyllapata nir. Piru, kimsa diyapaqnamiri payta wanuchishanllapaqa. ");
INSERT INTO qufNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","“Piru wakin warmikuna, nuqakunawan pulla kaqkunaqami manchachimashallapa, paykuna amsaqlla Jesús pampakashanman risha kar. ");
INSERT INTO qufNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Chayshi paykunaqa Jesuspa kwirpunta mana rikarchu tikrakamuranllapa wasinmanqa. Chaymi paykunaqa parlamashallapa, paykunamanqashi angelkuna rikarir, Jesusqashi kawsayan nisha nir. ");
INSERT INTO qufNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Chaynu nimatinllapa, wakin kriyiq masiyllapakunaqa riranllapa Jesús pampakashanmanqa. Chay pampakashanman ĉharqashi chay warmisitakuna nishannulla, Jesustaqa mana rikaranllapachu”. ");
INSERT INTO qufNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Chaynu chay runakuna nitinqa, Jesusqa niran: —¡Qamkunaqa mana das intrakaq runachu kankillapa! Chaynu karmi Dyuspa tukuy rimaqninkuna nishankunataqa, mana dasqa kriyinkillapachu. ");
INSERT INTO qufNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Manachu yaĉhayankillapa, Dyuspa Akrashan Cristunqa manaraq mantakuyarqa, chaynuraqmi qischakananpaq karan nirqa? ");
INSERT INTO qufNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Chaynu nirqa kusa shumaqta intrachiq qallariran chay runakunataqa, Dyus nitin iskribikashakunapi paypaq nishankunata. Chaynumiri Moisés iskribishanmanta qallarir, Dyuspa tukuy rimaqninkuna iskribishankunata willaran paykunataqa. ");
INSERT INTO qufNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Chaynu nirqa chay pwiblu riyashanllapaman ĉharqa, Jesusqa naypaqman riq yupay tukuran. ");
INSERT INTO qufNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Chaynu tukutinmi, paykunaqa Jesustaqa kusata rugaranllapa, kaynu nir ima: —Nuqakunawan kaylapi kiday. Chaqa tardina, tutapayannami. Chaynu niyatinllapaqa, Jesusqa yaykuran ruriman, paykunawanna chaypi kidananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Chaymanta misapina tayatinllapaqa, Jesusqa makinpi tantata aypar Dyusta payji nirqa, ĉhaypinmanta pakir paykunataqa quran. ");
INSERT INTO qufNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Chaynu qutinqa, chay kutilla chay runakuna chiqapta kwintachakarnaqa, Jesusta riqsiranllapa. Piru Jesusta riqsitinllapaqa, payqa das chinqaran. ");
INSERT INTO qufNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Chaymi paykunapura ninakuqllapa: “¿Manachu Dyus nitin iskribikashapi tukuy nishanta intrachimarninchik nanta shamutinqa, shunqunchikpimapis allipla shumaq aligrita yarpuranchik?” ");
INSERT INTO qufNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Chaynu nirllapami, chay kutilla ishkantin sharir tikrakaranllapa Jerusalenman. Ĉharnaqa tariranllapa Jesuspa unsi apustulninkunata, chaynulla wakin kriyiq masinkunatapis. ");
INSERT INTO qufNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Chaypi tantanakusha taqta taritinllapaqa, chay wasipi taqkunaqa niranllapa: —Alliptamiri Amitunchik Jesusqa wanushanmantaqa kawsamusha. Simonmanmi rikarisha payqa nir. ");
INSERT INTO qufNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Chaynu nitinllapami chay ishkaykunapis imanu nanta riyatinllapa pasashanta, chaynulla imanu tantata ĉhaypinmanta pakitin Jesusta riqsishanllapata ima parlaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Paykunaqami chayllapaq alliplata parlayaranllapa. Chaynu parlayatinllapaqa ashwan Jesusqa illaqmanta paykunapa ĉhaypinllapaman shar kaynu nir saludaran: —Kusa shumaqmi kankillapa nir. ");
INSERT INTO qufNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Chaynu nitinqa, paykunaqa alliplata manchakuranllapa, ayata rikayanchikllapa nir yarpur. ");
INSERT INTO qufNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Chaynu yarpuyatinllapamapis Jesusqa niran: —¿Imapaqtaq qamkunaqa manchakushaykillapa? ¿Imapaqtaq manaraq allita nuqapiqa kriyinllapa? ");
INSERT INTO qufNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Rikayllapa makiykunata, ĉhakiykunata. Nuqallami kani. Kanan kamamarllapa yaĉhayllapa: Uk ayaqa mana aychayjunchu, mana tulluyjunchu. Qamkuna rikamashaykillapanumi nuqaqa aychayjun, tulluyjun ima kani. ");
INSERT INTO qufNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Chaynu nirqa chay kutilla, ĉhakinta makintapis rikachiran paykunataqa. ");
INSERT INTO qufNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Piru paykunaqa kusala aligri karmapis mana kriyiranllapachu kusa dispantakashalla kashanllaparayku. Chaymi Jesusqa niran: —¿Mikunaykillapaqachu imalaqa kan kaypiqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Chaynu nitinqa paykunaqa quranllapa piskadu kankakashata, panalwan. ");
INSERT INTO qufNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Qutinllapaqa payqa aypar mikuran, paykunapa naypanpi. ");
INSERT INTO qufNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Chaymantaqa paykunataqa niran: “Nuqataqami kaynu pasamasha, imanutaq qamkunawan kar willashurayllapa chaynullata. Nuqami nishurayllapa, imanumi Moisés iskribishankunapi, Dyuspa rimaqninkuna iskribishankunapi, Salmos librupipis nuqapaq nishankunaqa kumplikayanqa nir. Chaymi chay nishanllapanulla pasamasha”. ");
INSERT INTO qufNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Chaynu nirmi paykunataqa allita intrachiran, chay iskribikashakunapi nishantaqa. ");
INSERT INTO qufNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kaynumi niran: “Iskribikashakunapimi nin: Dyuspa Akrashan Cristunqashi kusata qischakar wanuyanqa. Chaymanta kimsa diyamantaqa kawsamuyanqa nir”. ");
INSERT INTO qufNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Niranpismi: “Jerusalenmanta qallarirshi tukuy pachapi paypa shutinpi yaĉhachikunqallapa. Chaynu yaĉhachikutinllapashi tukuyla kriyir uchanllapakunata dijatin Dyusqa pirdunanqa. ");
INSERT INTO qufNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Qamkunaqami tukuy kaykunapaqqa uk tistigu kankillapa. ");
INSERT INTO qufNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Chaymi nuqaqa qamkunamanqa kaĉhamushaq Taytay Dyus arnishushanllapata. Piru qamkunaqa kay Jerusalén pwiblupi kidaskiyllapa, unaq syilumanta arnishushanllapa pudir qamkunaman shamunankaman” nir. ");
INSERT INTO qufNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Chaynu nir imaqa, Jesusqa chay Jerusalén pwiblumantaqa, paykunata lluqshichir aparan Betania pwiblukaman. Chaypiqami makinta unaqman alsar bindisiran paykunataqa. ");
INSERT INTO qufNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Chaynu bindisiqnumi, paykunamantaqa unaq syiluman apakaranna. ");
INSERT INTO qufNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Chaymantami paykunaqa Jesusta kusata adurar imaqa, tikrakaranllapana Jerusalenman kusa aligrila. ");
INSERT INTO qufNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Chaymiri maydiyapis, Dyusta adurananllapa wasipiqa, Dyusta alabar ima taranllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Manaraq imapis kayatinmi uk RIMAY karanllana. Kay RIMAYQAMI Dyuswan kar, Dyuslla karan. ");
INSERT INTO qufNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Chaynu mana imapis katinraqmi Dyuswan pulla kawsaran. ");
INSERT INTO qufNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tayta Dyus nitinmi, payqa tukuy imata ruraran. Chaqa mana rurasha katinqa, mana imapis kanmanchu. ");
INSERT INTO qufNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Payllami tukuyta kawsachimanchikllapa. Chaynu kawsachikuq karmi, kay pachaman shamuran tukuyta achkirachinanpaq. ");
INSERT INTO qufNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Chaynu achkirachikuq karmi, tutaparaqpi kaqkunataqa Dyuspaq yaĉhachin. Piru chay tutaparaqpi kaqkunaqami mana imanachiytapis puytinchu. ");
INSERT INTO qufNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Tayta Dyusmi, uk runa Juan shutiqta kaĉhamuran chay achkirachikuqpaq yaĉhachikunanpaq. Chaymi yaĉhachikuran chay achkirachikuqlapina kriyinanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Chaqa Juanqami mana chay achkirachikuqchu karan. Paytaqami Tayta Dyus kaĉhamuran yaĉhachikunanpaq pimi chay achkirachikuqqa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Kay chiqap achkirachikuqqami, kay pachaman shamuran achkirachikuq yupayna, Tayta Dyuspaq tukuyta intrachinanpaq. ");
INSERT INTO qufNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tayta Dyus paywan tukuy imata rurasha katinmapis, kay pachaman shamutinqa, runakunaqa mana riqsiranllapachu Dyus nirqa. ");
INSERT INTO qufNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Chaynu tukuyta rurashanraykumi, paypa kaqninkunaman shamuran. Piru chaynu shamutinmapis, wakinqa mana kasuranllapachu. ");
INSERT INTO qufNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nataq tukuy shunqunllapawan kriyir kasuqkunata-shuypaqa, Tayta Dyuspa chiqap wamrankunana kananllapapaq nisha. ");
INSERT INTO qufNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Chaynuqami niran mana taytanmanta, mamanmanta nasir paykuna munashanllaparaykuchu. Ashwanmi Tayta Dyus munar chaynu chiqap wamrankunapaqqa nisha. ");
INSERT INTO qufNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Chay RIMAYQAMI runapaq tikrakar tukuy nuqanchikkunawan kawsaran. Payqami kusalata munamarninchik, chiqap kaqlata rurar ima kawsaran. Nuqakuna rikasha kar, yaĉhanillapa Tayta Dyuspa uklayla Wamranqa Taytan Dyusnu kusa allinla nir. ");
INSERT INTO qufNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Paypaqmi Juanqa achka runakunata willaran kaynu nir: “Kaypaqmi unaylla kaynu nishushallapa karay: ‘Nuqamanta shamuyan chayqami kusala mas puytiq ima. Chaqa payqami manapis kayatiy karanllana’ nir”. ");
INSERT INTO qufNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Chaqa pay kusalata llakipamarninchikllapami kutir kutir yanapamaranchikllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tayta Dyusmi unayqa Moisesta mantakuykunata quran, intrachimanallapapaq. Piru kanan-shuypaqami Jesucristurayku intrachimanchikllapa imanumi munamanchikllapa, chaynulla imatapis karanlata ruran nir. ");
INSERT INTO qufNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tayta Dyustaqami mana mayqanlapis rikashachu. Piru Tayta Dyuspa uklayla Wamran Jesucristo paypa pullan kashanrayku, Dyuslla karmi riqsichimanchikllapa Taytanqa imanu nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Israel pwiblupa mantakuqninkunami, Jerusalenmanta kurakunata chaynulla Levipa ayllumanta runakunata ima, kaĉharanllapa rir Juanta tapunanllapapaq mayqanshi payqa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Chaynu rir taputinllapami payqa karanlata rimar kaynu niran: —Manami Dyuspa Akrashan Cristunchu kani nir. ");
INSERT INTO qufNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Qashanmi tapuranllapa: —Chayqa, ¿mayqantaq kanki? ¿Dyuspa rimaqnin Elías shamunanpaq karan, chaychu kanki? nir. Juanqa niran: —Manami paychu kani. Piru qashan tapuranllapa: —Chayqa, ¿qamchu uk rimaqninta Dyus kaĉhamunanpaq karan chay kanki? nir. Juanqa niran: —Manami nir. ");
INSERT INTO qufNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Chay tapuqkunaqa niran: —Chayqa, ¿mayqantaq kanki? Willamayllapari. Chaqa allita qampaq yaĉhar riyta ministinillapa chay mantamashallapakunata willanayllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juanqa niran: —Nuqaqami chunllaq lugarkunapi kusa jwirtita rimar kaynu niq chay kani: ‘Uk dirichula nanta kiĉhaq yupay bidaykillapata shumaqchar, Taytanchik Dyuslatana yarayllapa’ nir, imanutaq Dyuspa rimaqnin Isaías nisha karan chaynulla. ");
INSERT INTO qufNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Chaynu Juan nitinqami, chay fariseo runakunamanta mandadu risha karan chaykunaqa, ");
INSERT INTO qufNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","kaynu nir tapuranllapa: —Chaqa, Dyuspa mana Akrashan Cristun, mana Elías, chaynulla Dyus uk rimaqninta kaĉhamunanpaq karan chay mana karqa, ¿imapaqtaq runakunata shutichinkiqa? ");
INSERT INTO qufNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juanqa niran: —Nuqaqami yakulawan shutichikuni. Qamkuna tapukuyashaykillapaqami pullaykillapana. Piru manami riqsiyankillapachu. ");
INSERT INTO qufNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Paymi nuqamanta ikitaraq shamuyan. Chaynu ikita shamutinmapismi nuqaqa paypaqqa mana sirbinichu llanqinpa watunta kaĉhanaylapaqmapis. ");
INSERT INTO qufNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Tukuy kaykunaqami riyu Jordanpa chimpan Betania pwiblupi chaynuqa karan, chay maypiĉhi Shutichikuq Juan shutichikuyaran chaypi. ");
INSERT INTO qufNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Allaqnin diyami Shutichikuq Juanqa, Jesús payman qimikaqta rikaran. Chaymi niran: “¡Rikayllapa kaymi Dyusmanta Shamuq chayqa! Paymi uk musu uyshita yupay, tukuy nuqanchikkunarayku wanunanpaq shamusha chayqa. Chaymi payrayku Taytanchik Dyusqa uchanchikkunamanta washamanchikllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Paypaqmi rimaray kaynu nirqa: ‘Nuqamanta uk ikita shamuyan. Chayqami, nuqamantaqa mas yaĉhaq, puytiq ima. Chaqa manapis kayatiy, payqa karanllana’ nir. ");
INSERT INTO qufNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nuqamapis mana yaĉharaychu mayqanmi kanqa nirmapis. Chaynumapis nuqaqa yakuwan shutichikuray, Israelmanta runakuna chiqapta payta riqsinanllapapaq”. ");
INSERT INTO qufNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Juanqa niranpis: “Dyuspa Santu Ispiritunta rikaray, syilumanta uk palumitanu payman ishkimur taqta. ");
INSERT INTO qufNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Piru nuqaqami manaraq yaĉharaychu pimi kanqa payqa nirmapis. Piru Tayta Dyus yakuwan shutichikunaypaq kaĉhamaqmi, nimaran: ‘Chay mayqanpa ananmanĉhi Dyuspa Santu Ispiritun rikayatki ishkimur tayan chay paymi, Santu Ispirituwan shutichikunqa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Dyus nimashannumi, nuqaqa rikashana kani. Chaymi chiqapta nini: Payqa Dyuspa Wamran nir”. ");
INSERT INTO qufNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Chaymanta allaqnin diyapismi, chay kayashanllapallapi Shutichikuq Juanqa ishkay yaĉhakuqninkunawan karan. ");
INSERT INTO qufNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Chaymi Jesusta pasaqta rikarqa, Juanqa niran: —Rikayllapa, wakmi Dyusmanta Shamuqqa. Paymi uk musu uyshita yupay nuqanchikrayku wanunanpaq shamusha chayqa. ");
INSERT INTO qufNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Chaynu nitinqa, Juanpa chay ishkay yaĉhakuqninkunaqa, Jesuspa ikinta chay kutilla riranllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Chaymanta, ikinta riqta rikarqa, Jesusqa tapuran: —¿Imatataq maskayankillapa? Paykunaqa niranllapa: —Yaĉhachikuq Taytituy, ¿maypitaq tanki? ");
INSERT INTO qufNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesusqa niran: —Shamur rikayllapa. Chaymi rir rikaranllapa maypimi tan nirmapis. Chay diyaqami, pullan kidaranllapa, tardi alas kwatru yupayna katin. ");
INSERT INTO qufNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Juan rimaqta uyar Jesuspa ikinta riqkunamanta ukqa, karan Andrés, Simón Pedrupa uknin. ");
INSERT INTO qufNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andresqami Jesusta tarirqa, chay kutilla riran uknin Simonta tarir willaq kaynu nir: —Tarisha kanillapa Mesiasta. (Rimayninchikpiqa munan niyta Dyuspa Akrashan Cristun). ");
INSERT INTO qufNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Chaymanta chaynu nirnaqa, Andresqa aparan Simonta, Jesús kayashanman. Chayna Jesús, Simonta rikarqa niran: —Qamqami Jonaspa wamran Simón kanki. Piru kananmantaqami shutinki Cefas. (Rimayninchikpiqa munan niyta Pedro). ");
INSERT INTO qufNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Qashan allaqninpismi, Jesusqa Galilea lugarman rinanpaq yarpuran. Chaymi, Felipita tarirqa niran: —Shamuy nuqawan rishun nir. ");
INSERT INTO qufNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipiqa Betsaida pwiblumanta kaq, Andrespa, Pedrupa pwiblunllamanta. ");
INSERT INTO qufNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Chaymantami Felipiqa riran Natanaelta tarir, kaynu niq: —Tarishami kanillapa Dyuspa Akrashan Cristunta, chay mayqanpaqĉhi Moisés iskribisha karan chayta. Chaqa paypaqmi Dyuspa wakin rimaqninkunapis iskribisha karan. Payqami Nazaretmanta Josipa Wamran Jesús. ");
INSERT INTO qufNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Chaynu nitinqa, Natanaelqa niran: —¿Nazaretmantachu kusa runa nisha kayta puytin? Felipiqa niran: —Shamur rikay yaĉhanaykipaq. ");
INSERT INTO qufNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Chaymanta Natanael qimikaqta rikarqa, Jesusqa niran: —Kaytami shamun Israelmanta uk chiqap Dyuspi kriyiq runa. Payqami mana llullakuyta yaĉhanchu. ");
INSERT INTO qufNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Chaymanta, Natanaelqa niran: —¿Imanutaq riqsimanki? nir. Jesusqa niran: —Manapis Felipe nuqaman shamunaykipaq willashuyatinmi, riqsishuyarayllana, chay igus qirupa ĉhakinpi katki. ");
INSERT INTO qufNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaelqa niran: —Yaĉhachikuq Taytituy, ¡chiqaptami Dyuspa Wamran kanki! ¡Qammi Israel pwiblupa gubyirnun kanki! nir. ");
INSERT INTO qufNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesusqa niran: —¿Qamqachu kriyimanki igus qirupa ĉhakinpi riqsishuray nishushayraykula? Ashwan kusa mana rikashaykikunataraqmi rikanki. ");
INSERT INTO qufNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Niranpismi: —Chiqaptami nishaykillapa: Qamkunaqami rikankillapa syilu kiĉhakashata. Chaynulla rikankillapapis, Dyusmanta Shamuq Runaman angelninkuna ishkimuqta, iqaqta ima. ");
INSERT INTO qufNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Natanaelwan parlashanmanta allaqnin uk diyaqa, Galilea lugarpa pwiblun Caná shutiqpi, karan uk kidamyintu. Jesuspa mamanpis chay kidamyintupi karan. ");
INSERT INTO qufNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Chaynulla Jesuspis yaĉhakuqninkunawan kunachikasha kar, chaypi karanllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Chay kidamyintupina kayatinllapaqa, ubapa yakun binu tukukaran. Chaymi Jesustaqa, mamanqa niran: —Manana ubapa yakun binu kannachu nir. ");
INSERT INTO qufNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesusqa niran: —Mamitay, ¿imapaqtaq kayta willamanki? ¡Yarayraq! Milagrukunata ruranaypaq uraqami, manaraq ĉhamushachu nir. ");
INSERT INTO qufNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Chaynu Jesús nitinmi, mamanqa chay kidamyintupi ikimanta aypachikuqkunataqa niran: —Tukuy imata pay nishutinllapaqa, rurayllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Chaypiqami karan, rumimanta saysi atunlla butijakuna. Chaykunapimi Israelmanta runakunaqa yakuta ĉhuraqllapa, paqakuna kustumrinta rurananllapapaq. Kada butijakunami kwatru lata yakuta aypaq. ");
INSERT INTO qufNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Chaymanta Jesusqa ikimanta aypachikuq chaykunataqa niran: —Kay atun butijakunaman yakuta untachiyllapa, nir. Chaynu nitinqa, chay ikimanta aypachikuqkunaqa, untachiranllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Chaymantaqa, Jesusqa niran: —Kananqa pitilata ĉhaqar, apar quyllapa chay naypaqpi aypachikuqqa kamananpaq nir. Chaynu nitinqa, chay ikimanta aypachikuqkunaqa, chaynu ruraranllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Chay naypaqpi aypachikuq chayqa yaku, binupaq tikrakashata kamar mana yaĉharanchu maymanta, imanumi chay binuqa rikarisha nirmapis. Nataq, ikimanta aypachikuqkunaqa, yaĉhayaranllapa yakumanta nir. Chaqa paykunallari yakuta ĉhaqar untachisha karanllapa chay butijakunamanqa. ");
INSERT INTO qufNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Chaymantaqa naypaqpi aypachikuq chayqa, chay kidaq runata qayamur, niran: —Tukuy kidaqkunami puntataqa shumaq binutaraq upyachikunllapa. Chaymanta tukuy kusata upyashana katinqa, mana shumaq binutanachu upyachikunllapa. Piru qam-shuypaqa ashwan mas shumaq binutaraq ĉhurashayki kasha upyachikunaykipaqqa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Chayta chay kidamyintupi rurashanmi, Jesuspa punta milagrunqa karan. Chay milagrutaqami ruraran Galileapa pwiblun Caná shutiqpi. Chaywanmi intrachikuran payqa Dyus kar, puytin chaykunata rurayta nir. Chaymi yaĉhakuqninkunaqa paypi kriyiranllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Chaymantaqa riranllapana uran Capernaúm pwibluman mamanwan, ukninkunawan, yaĉhakuqninkunawan ima. Chaypimi ayka diyata karanllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Israel runakunapa Pascua fyistan shipchana katinmi, Jesuspis riran Jerusalenman. ");
INSERT INTO qufNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Jerusalenman ĉharqa, Dyusta adurananllapa wasipiqa, rantikuqkunata tariran. Chaypiqami ufrindapaq nir rantikuyaranllapa turukunata, uyshakunata, palumakunata ima. Chaynulla uklawmanta kaq qillayta kambyaq runakuna ima karanllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Chaykunata tarirmi, Jesusqa waskakunata aypar uk latiguta rurar, tukuy chaypi kaqkunataqa waqtaman itakuran, uyshantinta, turuntinta ima. Nataq chay qillaykunata kambyaqkunapata-shuypaqa, qillayninmatapis pachaman chaqchukuran. Chaynulla misanllapamatapis ratachiran ima. ");
INSERT INTO qufNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Palumakunata rantikuqkunata-shuypaqa niran: —¡Qamkunapis, kaykunataqa urquyllapa! ¡Chaqa Taytay Dyuspa wasinqami mana imakunata rantikunanllapapaqchu! ");
INSERT INTO qufNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Chaynu nitinmi, yaĉhakuqninkunaqa kwintata qukaranllapa uk iskribikashakunapi nishanpaq. Chaqa niqmi: “Wasikipi mana allinkunata ruratinllapami, kusata piñakushaq” nir. ");
INSERT INTO qufNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Chaymantaqa, Israelmanta karguyjunkunaqa, kaynu nir tapuran: —¿Ima milagruwantaq intrachimankillapa, Dyusmanta shamusha kar chayta rurayanki nir, nuqakuna kriyishunayllapapaqqa? ");
INSERT INTO qufNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesusqa niran: —Kay wasita ratachiyllapa. Chaymanta kimsa diyalapaq qashan shachishaq nir. ");
INSERT INTO qufNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Chaynu Jesús nitinmi, chay Israelmanta karguyjunkunaqa niran: —¡Aja jay! ¡Kwarintay-saysi (46) añupaqmi, shachirayllapa Dyusta adurananllapa wasitaqa! ¡Piru qamqa ninki, kimsa diyalapaq shachishaq! nir. ");
INSERT INTO qufNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Piru Jesús “Kay wasita shachishaq” nirqami, kwirpunllapaq niran. ");
INSERT INTO qufNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Chaymi Jesús wanur kawsamutinqa, yaĉhakuqninkunaqa yarpuranllapa, wanur qashan kimsa diyamanta kawsamushaq nishanta. Chaynami kriyiranllapa, iskribikashakuna nishanpi, chaynulla Jesús tukuy nishanpi imamapis. ");
INSERT INTO qufNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesusqa Jerusalenllapi kayar Pascua fyistapiqa achka milagrukunata ruraran. Chaymi kusala achka runakuna kriyiranllapa paypiqa. ");
INSERT INTO qufNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Piru Jesusqa mana paykunapiqa kunfyakaranchu, chaynu kriyitinllapamapis. Chaqa tukuytari riqsiq imanumi nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Chaynu karmi, runa uk runa masinpaq payta willanantaqa mana ministiqchu. Chaqa paylla tukuyta riqsiq, yarpuyninllapapiqa imanumi nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Jerusalenpimi taq uk fariseo runa Nicodemo shutiq. Payqami Israelmanta karguyjun runakunapa masin karan. ");
INSERT INTO qufNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Kay runami uk tuta, Jesusta watukuq rir, kaynu niran: —Yaĉhachikuq Taytituy, yaĉhanillapami Tayta Dyus kaĉhamushusha yaĉhachimanaykillapapaq nir. Chaqa, qamlami chay milagrukunata rurashaykitaqa rurayta puytinki. Dyus mana qamwan katinqa, mana rurayankimanchu chay milagrukunataqa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Chaynu Nicodemo nitinmi, Jesusqa niran: —Piru chiqaptami nishayki: Mayqanpis mana mushuqmanta nasiqqa, Dyus mantakushanpi mana kayta puytinqachu nir. ");
INSERT INTO qufNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Chaynu Jesús nitinmi, Nicodemuqa, kaynu nir tapuran: —Chayqa, ¿imanutaq uk runa rukuna karqa qashan nasiyanqaqa? ¿Ima mamanpa shunqunman yaykurchu, qashan mushuqmanta nasimuyanqa? ");
INSERT INTO qufNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Chaynu taputinmi, Jesusqa niran: —Chiqaptami nishayki: Uk runa yakumanta chaynulla Dyuspa Santu Ispiritunmanta manaraq nasiyarqa, Dyus mantakuyashanmanqa mana yaykuyta puytinqachu nir. ");
INSERT INTO qufNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Chaqa mayqanpis taytanllapakunalamanta nasiqqami paykuna munashanlata rurar kawsanllapa. Nataq Tayta Dyuspa Santu Ispiritunmanta nasiqkuna-shuypaqami Tayta Dyus munashanlata rurar kawsanllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Piru ‘Tukuymi mushuqmantaraq nasiyta ministin’ nishutiyqa, amami kusalata chaypaqqa yarpupakunkichu. ");
INSERT INTO qufNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Chaqa imanutaq wayramaqa pay munashannulla maymantapis shamun. Chaynu shamutin waqaqta uyaparmapis manami yaĉhankichu maymanta shamun chaynulla mayman rin nirmapis. Chaynumi pasan Dyuspa Santu Ispiritunwan yarpuyninpi nasiqkunawanpis. ");
INSERT INTO qufNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Chaynu nitinqa, qashan Nicodemuqa tapuran: —¿Imanutaq kayqa kanqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesusqa niran: —¿Qam Israel runakunapa yaĉhachiqnin karmapis, manachu kaytaqa yaĉhanki? ");
INSERT INTO qufNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Chiqaptami nishayki: Nuqakunaqami allita yaĉhaq kar chaynulla rikashayllapata ima willashunillapa. Piru qamkunaqa mana kriyinkillapachu. ");
INSERT INTO qufNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Chaynu kay pachapi rikaypaqkunapaq willashutiyllapa mana kriyirqa, ¿imanuna kriyinkillapa unaq syilupi mana rikaypaqkunapaq willashutiyllapamaqa? ");
INSERT INTO qufNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Chaqa manami mayqanpis unaq syilumanqa iqashachu. Ashwanmi tukuy chaykunapaqqa yaĉhan Dyusmanta Shamuq Runala. ");
INSERT INTO qufNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Unaymi chunllaq lugarpi runakunata largu kuru kanisha katin, Dyuspa rimaqnin Moisés, jyirrumanta largu kuruta rurar unaqman qirupi alsatin, kanikasha kaqkunaqa rikarla, alliyaranllapa. Chaynullami Dyusmanta Shamuq Runatapis qirupi klabar alsanqallapa unaqman. ");
INSERT INTO qufNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Chaynami tukuyla paypi kriyiqkunaqa washakar tukuy tyimpupaqna kawsanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Tayta Dyusqami tukuy runakunata kusalata munashanrayku uklayla Wamranmatapis kaĉhamuran. Chayna tukuyla paypi kriyiqkunaqa amana wanurchu tukuy tyimpupaqna washakar kawsananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Chaqa Tayta Dyusqa Wamrantaqa manami mayqanta uchachar kastigananpaqchu kaĉhamuran, ashwanmi tukuyta washananpaqna. ");
INSERT INTO qufNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Chaymi mayqanpis, Tayta Dyuspa uklayla Wamranpi kriyiqqa, mana imapaqpis uchachakar kastigakanqanachu. Piru chay mana kriyiq-shuypaqa may tyimpu uchachakashana. Chaymi tukuy tyimpupaqna kastigakanqa. ");
INSERT INTO qufNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Chay mana kriyiqkunaqami uchachakashana. Chaqa mana allinkunata rurar tutaparaqlapi kayta munar, Dyuspa Wamran achkirachikuq shamutinqa, mana yaĉhayta munaranllapachu paywanqa. ");
INSERT INTO qufNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tukuy mana allinta ruraqkunaqa, chay achkirachikuqtaqa ĉhiqnin. Chaymi paypa naypanmanqa mana qimikayta munanllapachu, tukuy saqra rurayninllapakunaqa shutiman mana rikarinanta munar. ");
INSERT INTO qufNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Piru chay allinta ruraqkuna-shuypaqa chay achkirachikuqpa naypanman mas qimikanllapa. Chayna tukuyta intrachinanpaq Tayta Dyus munashannulla rurar kawsanllapa nir”. ");
INSERT INTO qufNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Chaymantami Jesusqa yaĉhakuqninkunawan riran Judea lugarman. Chaypimi paykunawan ayka diyallataqa karanllapa shutichikur ima. ");
INSERT INTO qufNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Chaynullami Juanpis, Salim shutiq pwiblupa shipchanlapi Enón shutiq pwiblu karan, chaypi shutichikuyaran. Chaqa chaypiri achka yaku karan. Chaymi chayman tukuy riqkunaqa shutikuqllapana. ");
INSERT INTO qufNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tukuy kaykunaqami pasaran Shutichikuq Juanta manaraq karsilman itayatinllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Piru, Juanpa wakin yaĉhakuqninkunaqa, Israelmanta uk runawan, chay yakuwan shutikur Dyuswanqa shumaqchakanchik niyashanllapapaq kusalata willanakuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Chaymi Juanpa yaĉhakuqninkunaqa riranllapa payta kaynu nir willaq: —Yaĉhachimaqniyllapa, qammi parlamaraykillapa riyu Jordanpa chimpanpi pullayki karan, chay runapaq. Paymi kananqa shutichikutin, tukuy kriyir paymanna riyanllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Chaynu nitinllapami, Juanqa niran: —Manami mayqanpis pudirniyjunchu kanman, Dyus mana pudirta qutinqa. ");
INSERT INTO qufNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Piru uk kuti qamkunata ‘Manami Dyuspa Akrashan Cristunchu kar, uk paypa naypanta shamuqla kani’ nir willashutiyllapa uyakurmapischu ¿mana intrakaraykillapa? ");
INSERT INTO qufNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Chaqa allita intrakayllapa: Uk kidamyintupimaqami kidaq chay, nubyawan pulla kaytaqa puytin, mana amigunkunachu. Ashwanmi chay kidaqpa amigunkunaqa chaynu kidaqta uyaparqa kusalata aligriyan. Chaynumi nuqapis chay kidaqpa amigun kashayrayku kusalata aligriyani. Chaqa payqami nuqanchikkunaman ĉhamushana. ");
INSERT INTO qufNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Chaymi ashwan paylatana kusata kasur kawsanqallapa. Nataq nuqata-shuypaqa waran waranqa mana kwintachamanqallapanachu. ");
INSERT INTO qufNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Chaqa syilumanta shamuqqami, tukuyla imapaqpis yaĉhan. Nataq kay pachamanta kaq-shuypaqami pachapi kaqkunalapaq yaĉhar riman. Piru unaq syilumanta shamuq-shuypaqami, tukuyta yaĉhaq kashanrayku, ");
INSERT INTO qufNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","tukuy imata rikashanta, uyapashantaqa karanlata riman. Piru chaynu rimatinmapis, manami mayqanpis kriyinllapachu. ");
INSERT INTO qufNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nataq mayqanpis chay nishanta kriyiq-shuypaqami Dyusqa chiqapta riman nir parlakun. ");
INSERT INTO qufNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Chaqa Dyusmanta shamusha chayqami Taytan, Santu Ispiritunta qushanrayku imatapis karanlata riman. ");
INSERT INTO qufNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Taytanmi, Wamranta kusalata munashanrayku pudirta qusha tukuy imatapis payna mantananpaq. ");
INSERT INTO qufNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Chayraykumi mayqanpis chay Wamranpi kriyiqkunaqa, tukuy tyimpupaqna washakar kawsanqallapa. Nataq chay mana kriyinaqkuna-shuypaqami mana washakarnachu, tukuy tyimpupaq kastigutana Dyusmanta aypanqallapa”. ");
INSERT INTO qufNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Wakinkuna rimatinllapami fariseo runakunapis yaĉharanllapa, Jesusqashi Juanmantaqa achka runakunata shutichitin, paywanna riyanllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Piru chiqaptaqami mana Jesuschu shutichikuyaran. Ashwanmi tukuy paypi kriyiqkunataqa yaĉhakuqninkuna shutichiyaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Chaymantami Jesusqa yaĉharan fariseo runakunaqa imatami paypaq yarpuyan nir. Chaymi Jesusqa Judeamanta lluqshir Galileamanna riran. ");
INSERT INTO qufNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Piru Galileaman rinanpaqqami, Samaria lugarllata pasayta ministiran. ");
INSERT INTO qufNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Chaynu riyarqami, Samariapa uk pwiblun Sicar shutiqman ĉharan. Chay pwibluqa Jacobo, wamran Josita irinsyanpaq nir pachata qusha kayaq chaypa yatalanpi karan. ");
INSERT INTO qufNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Chay pachapi Jacobupa yaku upyanan quĉhapis karan. Chay quĉhapa yatanlapimi, Jesusqa kusata shaykushanrayku samaran, alas dusi yupayna. ");
INSERT INTO qufNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Chaykamanqa, yaĉhakuqninkunaqa pwibluman risha karanllapa mikuyta rantimuq. Chaypi Jesús payla katinmi, Samariamanta uk warmi chay quĉhaman ĉharan yakukuq. Chaymi Jesusqa niran: —Mamitay, yakituta upyachimay nir. ");
INSERT INTO qufNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Israelmanta kaqkuna, Samariamanta kaqkunawan mana piĉhunakuq kashanllaparaykumi, warmiqa niran: —¿Imanutaq qam Israelmanta runa karqa, nuqa Samariamanta warmitaqa yakuta mañakumayankiqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesusqa niran: —Qamqa manami yaĉhayankichu imanumi Tayta Dyus yanapakun chaynulla mayqanmi yakuta mañashuyan nirmapis. Chaqa allita yaĉhar yakuta mañamatkimaqa tukuy tyimpu nasimuq yakutana upyachishuyman nir. ");
INSERT INTO qufNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Chaynu Jesús nitinqa, warmiqa niran: —Taytituy, yakuqami kusala ruri maypi. ¿Manami imaykipis kanchu yakuta lluqshichimunaykipaqqa? ¿Maymantana tukuy tyimpu nasimuq yakutaqa upyachimanki? ");
INSERT INTO qufNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Qamqachu rukunchikllapa Jacobumantaqa mas runa nisha kanki? Chaqa kay quĉhataqami unay rukunchikllapa Jacobo qumaranllapa, pay chaynulla wamrankuna, animalninkuna ima upyanan yakuta nir. ");
INSERT INTO qufNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesusqa niran: —Tukuy kay quĉhamanta yakuta upyaqkunaqami, qashan yakunanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Piru nuqa qutiy yakuta upyaqkuna-shuypaqa, mananami maydiyapis yakunanqanachu. Chaqa nuqa mayqantapis yakuta upyachiyani chayqami, yaku nasimuq yupay tukuy tyimpupaqna kawsanqa. ");
INSERT INTO qufNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Warmiqa niran: —Taytituy, chay yakituta upyachimay. Chaynuqa manana qashan yakunar imaqa, kay quĉhaman shamur yakukunaypaqnachu nir. ");
INSERT INTO qufNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Chaymi Jesusqa niran: —Rir, runaykita qayamur, shamuyllapa kayman nir. ");
INSERT INTO qufNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Chaynu nitin, warmiqa niran: —Manami runayjunchu kani nir. Jesusqa niran: —Chiqaptami ninki mana runayjunchu kani nirqa. ");
INSERT INTO qufNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Runaykimi, sinku kaytaqa kasha, piru kanan chay ukwan kanki chaypaqa shipashninla kanki, mana chiqap kasarashan warminchu. Chiqaptami nimashayki nir. ");
INSERT INTO qufNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Chaynu nitinmi, warmiqa niran: —Taytituy, willamatkilami yaĉhanina, qamqa chiqapta Dyuspa uk rimaqnin kanki nir. ");
INSERT INTO qufNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Chaqa Samariamanta unay rukuyllapakunapismi kay sirkapi Dyustaqa aduraqllapa. Piru qamkuna Israelmanta kaqkunaqami ninkillapa: Jerusalenlapimi Dyusta aduranapaqqa allin nir. ");
INSERT INTO qufNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Chaymi Jesuspis niran: —Kriyimay mamitay, ĉhamunqanami tyimpuqa Tayta Dyusta maylapipis aduranaykillapapaqqa. Chaynuqami Tayta Dyusta aduranaykillapapaqqa mana ministinkillapanachu kay sirkaman shamuyta, chaynulla Jerusalenman riymatapis. ");
INSERT INTO qufNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Chaqa qamkunaqami mana yaĉhayankillapachu mayqanta adurayankillapa nirmapis. Piru nuqakuna-shuypaqami allita yaĉhanillapa mayqantami adurayanillapa nirmapis. Chaqa tukuyta Washakuqqami Israel runakunallamanta shamusha. ");
INSERT INTO qufNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Piru uk tyimpu ĉhamunanpaq karan chayqami ĉhamushana. Chaymi kananqa chay chiqapta aduraqkunaqa Tayta Dyuspa Santu Ispiritun munashannullana chiqapta tukuy shunqunllapawan aduranqallapana. Chaqa Tayta Dyusqami chaynu adurananllapata ministin. ");
INSERT INTO qufNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Tayta Dyusqami wayra yupayla. Chaynu karmi payqa Ispiritu. Chayraykumi payta aduraqkunaqa Santu Ispiritu munashannullana tukuy shunqunllapawan chiqapta aduranqallapa. ");
INSERT INTO qufNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Chaynu Jesús nitinmi, chay warmiqa niran: —Nuqaqami chiqapta yaĉhani, Dyus Akrashan Cristo ninllapa chayqa, shamuyan nir. Pay shamurmi, manyaq tukuyta intrachimashunllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Chaynu nitinmi, Jesusqa niran: —Chay mayqanpaqĉhi rimayanki chayqami, nuqa kani. Payllawanmi parlayanki nir. ");
INSERT INTO qufNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Chaynu chaypi warmiwan parlayatinllapami, Jesuspa yaĉhakuqninkunaqa ĉharanllapa. Ĉharqami kusalata dispantakaranllapa Jesús uk warmiwan parlayashanrayku. Piru manami mayqanninlapis tapuyta puytiranchu imatami chay warmiqa ministiyan, imatami parlayanllapa nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Chaymantaqa chay warmiqa kantarunta chaylapi dijar, kallpaylla riran pwibluman tukuy runakunata willaq. Ĉharqa, niran: ");
INSERT INTO qufNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Shamur rikayllapa uk runa tukuy imata nuqa rurashaykunata willamashanta. ¿Manachu payqa Dyuspa Akrashan Cristun kanqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Chaynu nitinmi, tukuy runakuna chay kutilla riranllapa Jesús kayashanmanqa. ");
INSERT INTO qufNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Chaykamanqami, Jesustaqa yaĉhakuqninkunaqa kaynu nir rugayaranllapa: —Yaĉhachikuq Taytituy, imalataqa mikuy nir. ");
INSERT INTO qufNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Piru payqa, niran: —Nuqapa mikunayqami kan. Chaypaqqami mana yaĉhankillapachu nir. ");
INSERT INTO qufNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Chaynu nitinmi yaĉhakuqninkunaqa ukninllapa, ukninllapa kaynu nir tapunakuranllapa: “¿Mayqantaq mikunanta apamusha katin waknuqa nimayanchikllapa?” nir. ");
INSERT INTO qufNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Chaynu nitinllapami, Jesusqa niran: —Taytay Dyus imata ruranaypaqĉhi nimasha chaymi, mikunay yupayqa. Chaymi rurar tukchishaqna nir. ");
INSERT INTO qufNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Tarpukurnaqami qamkunaqa ninkillapa: ‘Kwatru misisraqmi faltan kusichakunapaqqa’ nir. Piru nuqaqami nishaykillapa: Rikayllapa, ĉhakraqami qarwashana sigakur kusichakunaykillapapaqqa. ");
INSERT INTO qufNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Chaqa allita yaĉhashanchikllapanu uk kusichakuqqami partinta aypan. Chaymi mayqanpis uk kusichakuq yupay runakunata willatin kriyirqa tukuy tyimpupaqna kawsanqa. Chaymi chay tarpukuqwan, kusichakuqqa pullana kusalata aligriyanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Chaynuqami unay nishanllapakunaqa chiqap. Chaqa kaynumi niqllapa: ‘Ukmi tarpukun, chaymantami ukna kusichakun’ nir. ");
INSERT INTO qufNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nuqami qamkunataqa kusichaq yupay runakunata willar tantanaykillapalapaqna kaĉhashurayllapa. Chaqa paykunataqami mana qamkunachu puntata Dyuspaq intrachishaykillapa karan. Nataq kanan qamkuna paykunata Dyuspaq masta intrachirqami uk tarpukushanta kusichakuq yupayna kankillapa”. ");
INSERT INTO qufNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","“Tukuy nuqa rurashayta karanta willamasha” nir, chay warmisita tukuyla Samaria pwiblupi parlakushanraykumi kusala achka runakuna kriyiranllapa Jesuspiqa. ");
INSERT INTO qufNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Chaymanta chay Samariamanta runakuna Jesús kayashanman ĉharqa, kusalata rugaran paykunawan kidananpaq. Chaymi Jesusqa, ishkay diyata paykunawanqa kidaran. ");
INSERT INTO qufNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Chaymanta Jesús paylla yaĉhachikutin uyaparqami masna kriyir achkayaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Chaymi chay warmisitataqa niranllapa: —Kanan-shuypaqami mana qam willamashaykillaparaykulanachu kriyinillapa. Ashwanmi nuqakunalla uyapar imana mas kriyinillapa. Chaymi ashwan yaĉhanillapana, payqami tukuypa chiqap Washakuqnin nir. ");
INSERT INTO qufNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Chaymanta, ishkay diya pasashana katinqa, Jesusqa Samariamanta lluqshir riran Galileaman. ");
INSERT INTO qufNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Chaqa payllami kaynu niran: “Dyuspa uk rimaqnintaqami paypa pwiblunllapiqa mana kasunllapachu” nir. ");
INSERT INTO qufNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Chaymanta Galileaman rir ĉhatinnaqa, kusa shumaqta samachiranllapa. Chaqa chay runakunaqami Jerusalén pwiblupi Pascua fyista katin, rir rikasha karanllapa, tukuy imata Jesús ruratinmapis. ");
INSERT INTO qufNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Chaymantami qashan Galilea lugarpa uk pwiblun Caná shutiqpi yakuta binupaq tikrasha karan chayllaman tikrakaran. Chaypimi karan uk mantakuqpa ikillan kaq mantakuq. Chay paypa wamranmi, Capernaumpi qishaq karan. ");
INSERT INTO qufNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Chaymantami chay runaqa, Jesús Judeamanta Galileaman ĉhamusha nir yaĉharqa, riran rikaq. Ĉharnaqa rugaran wasinman rir wamran wanuypaqna karan chayta allichananpaq. ");
INSERT INTO qufNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Chaymi Jesusqa niran: —Qamkunaqami kusa dispantakaypaq milagrukunata mana ruratiyqa mana kriyinkillapachu. ");
INSERT INTO qufNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Chaynu nitinmi, chay mantakuqpa ikillan kaqqa, niran: —Taytituy, utqar ripamashun, wamraykish wanutinmana nir. ");
INSERT INTO qufNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Chaynu nitinmi, Jesusqa niran: —Riyna wasikiman. Wamraykiqami alliyashana nir. Chaynu nitinmi, Jesús nishanpi kriyir chay runaqa riranna wasinman. ");
INSERT INTO qufNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Wasinman ĉhayatinnaqa, sirbikuqninkunaqa nanllapi tarir niranllapa: —¡Wamraykiqami alliyashana! nir. ");
INSERT INTO qufNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Chaynu nitinllapami, payqa tapuran sirbikuqninkunataqa: —¿Ima urastaq wamrayqa kwirpun kaĉhakaqta kamaran? nir. Paykunaqa niranllapa: —Quya, a la una di la tardimi rupamantaqa qasakaran nir. ");
INSERT INTO qufNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Chaymi taytanqa yarpuran, Jesús chay uras “Wamraykiqa alliyashana” nisha karan chayta. Chaymi pay, tukuy ayllunkunamapis kriyiranllapa Jesuspiqa. ");
INSERT INTO qufNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Judeamanta Galileaman tikrakamur chay wamrata allichashanwanqami, Jesusqa ishkay milagrutana ruraran. ");
INSERT INTO qufNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Chaymantaqami Jesusqa qashan riran Jerusalén pwibluman. Chaqa chay diyakunapimi Israelmanta kaq runakunaqa fyistata rurayaranllapa Jerusalenpiqa. ");
INSERT INTO qufNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalenpi, Uyshapa Punkun niqllapa chaypa yatanlapimi kan uk quĉha sinku kurridurniyjun. Hebreo rimaypiqa niqllapa Betesda. ");
INSERT INTO qufNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Chay kurridurpimi, achka qishaqkuna pachalapi usurasha llantukuyaqllapa, kujukuna, syigukuna, mana kuyuyta puytiq kwirpuyjunkuna ima. Paykunaqa yarakuyaranllapa yaku kuyutin, yaykunanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Chaqa mayqanpis mana yaĉhatinmi unaymanta unaymanta, Dyuspa angelnin shamur yakuta kuyuchiq. Chaynu ángel ruratinmi, mayqan qishaqpis naypaqta yaykuqqa alliyaqna, ima qishayninmanmatapis. ");
INSERT INTO qufNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Piru chay qishaqkunapa rurinpimi, karan uk runa trintay-uchu añupaqna qishaq. ");
INSERT INTO qufNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Chaypi chaynu usuraqta rikar, unaymanta-pacha qishaq nir yaĉharmi, Jesusqa tapuran: —¿Alliyakuytachu munayanki? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Chaymi chay qishaqqa niran: —Taytituy, manami mayqanlapis kanchu chay yaku kuyuq qallaritin itamananpaq. Chaqa yaku kuyutin, yaykuyta kamanaykamanmi ashwan ukna das naypaqta yaykun. ");
INSERT INTO qufNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Chaynu nitinmi, Jesusqa niran: —Sharir, paraykita apar riyna nir. ");
INSERT INTO qufNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Chaynu nitinlami, chay runaqa alliyarna das sharir, paranta apar riran. Piru samana diya katinmi, ");
INSERT INTO qufNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Israelmanta karguyjunkunaqa, chay alliyasha runataqa kaynu niranllapa: —Kananqami samana diya. Mantakushanllapanu, manami allinchu paraykita apanaykipaqqa. ");
INSERT INTO qufNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Chaynu nitinllapaqa, chay alliyasha runaqa niran: —Chay allichamasha runami nimaran: ‘Sharir, paraykita apar riyna’ nir. ");
INSERT INTO qufNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Chaynu nitinqa, chay karguyjunkunaqa niranllapa: —¿Mayqantaq chay runa ‘Sharir paraykita apar riyna’ nishuran chayqa? ");
INSERT INTO qufNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Chaynu nitinllapaqa, chay runaqa mana yaĉharanchu, mayqanmi allichasha nirmapis. Chaqa Jesusqami, kusala achka runakunapa rurinta rishana karan. ");
INSERT INTO qufNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Chaymantami Jesusqa chay runataqa, Dyusta adurananllapa wasipi tarir, niran: —Kananqami allinna kanki. Amanami qashanqa uchakunkinachu. Kuytawkish uchakurmana chay qischakayashaykimantaqa tukuy tyimpupaqmana qischakatki nir. ");
INSERT INTO qufNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Piru chay runaqami rir willaran Israelmanta karguyjunkunataqa, “Jesusmi kasha chay allichamaqqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Chaynu nitin yaĉharmi chay Israelmanta karguyjunkunaqa, samana diyapi chaykunata rurarqa mana allintachu tukuyan nir, Jesusta aypananllapapaqna ikinpi puriranllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Chaymi Jesusqa, paykunataqa niran: —Taytaymi chay diyakunapimapis yanapakun. Chaymi nuqapis chayllata rurani. ");
INSERT INTO qufNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Chaynu nitinmi, ashwan llallin tukur Jesustaqa wanuchinayaranllapa Israelmanta karguyjunkunaqa. Chaqa Jesusqa paykunapaqqa samana diyata mana rispitaq yupayshi tukuyaran. Chaynulla Dyus yupayshi tukuyaran, “Dyusqa nuqapa Taytay” nirqa. ");
INSERT INTO qufNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Chaynu karguyjunkuna wanuchinayan nir yaĉharmi, Jesusqa niranpis: “Chiqaptami nishaykillapa: Dyuspa Wamranqami mana pay munashannullatachu ruran. Ashwanmi Taytan imataĉhi rurayashanta rikarqa, chayllata ruran. Chayraykumi Taytan tukuy imata ruratinqa Wamranpis chayllata ruran. ");
INSERT INTO qufNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Chaqa Taytan Wamranta kusata munashanraykumi, tukuy imata rurashantapis rikachin. Chaymi ashwan mas imakunata Wamranwan ruratin rikarmi, qamkunaqa kusalata dispantakankillapa. ");
INSERT INTO qufNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Chaynulla imanuĉhi Taytanqa, wanushakunata kawsachimur bidanta qun, chaynullami Wamranpis wanushakunata kawsachimur bidanta qun mayqantapis munashantaqa. ");
INSERT INTO qufNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Chaqa manami Taytanqa runakunata payllaqa rikar yaĉharqa kastiganchu. Ashwanmi Wamrantana pudirta qusha tukuyta allita rikar yaĉhar kastigananpaqqa. ");
INSERT INTO qufNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Chaynuqami rurasha Taytanta yupayllana Wamrantapis rispitar kasunanllapapaq. Chaqa mayqanpis Dyuspa Wamranta mana kasurqami, Taytan kaĉhamusha chaytapis mana kasuyanllapachu. ");
INSERT INTO qufNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Chiqaptami nishaykillapapis: Mayqanpis nuqa nishayta kasur, chay mayqanĉhi kaĉhamasha chaypi kriyiqqa, tukuy tyimpupaqna kawsanqa. Chaynuqami manana tukuy tyimpupaq kastigakanqanachu. Chaqa tukuy tyimpupaq kastigakar wanunanmantaqami, nuqata kasumashanrayku, tukuy tyimpupaq kawsananpaq nikasha. ");
INSERT INTO qufNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Chiqapta nishaykillapapis: Ĉhamunqanami uk ura, Dyuspa Wamranta tukuyla kasunanllapapaq. Piru chay uraqami ĉhamushana. Chayraykumi mayqanpis kananlla Dyuspa Wamran nishanta uyakur, kriyiqkunaqa wanushanmanta kawsamuq yupayna tukuy tyimpupaq kawsanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Chaqa imanuĉhi Taytanmaqa paylla kawsan chaynullami Wamrantapis nisha paylla kawsananpaq. ");
INSERT INTO qufNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Chaynulla Dyusmanta Shamuq Runa kashanraykumi, paylla nisha tukuy runakunata rikar yaĉhananpaqmapis. ");
INSERT INTO qufNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Piru chaynu nishutiyllapaqa amami kusalata yarpupakunkillapachu. Chaqa chay ura ĉhamutinqami, chiqapta wanushakunapis tukuy nishanta uyapar, ");
INSERT INTO qufNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","pampakashanmanta kawsamunqallapa. Chaymi allinkunalata rurasha karqa, kawsamunqallapa tukuy tyimpupaq kawsananpaqna. Nataq mana allinkunata rurasha kar-shuypaqa tukuy tyimpupaq Dyusmanta kastiguta aypananllapapaqna kawsamunqallapa”. ");
INSERT INTO qufNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jesusqami niranpis: “Nuqa munashayllamantaqami mana imatapis ruranichu. Ashwanmi Taytay Dyus nimasha katin, mayqan imanu katinpis karanlata rikar yaĉhani. Manami munashaynullata ruraytachu munani, ashwanmi Taytay Dyus kaĉhamasha chay pay munashannulata rurani imatapis. ");
INSERT INTO qufNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Chaqa nuqa munashaylamanta imatapis rimatiyqa, rimashayqa mana sirbiyanmanchu. ");
INSERT INTO qufNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Piru kanmi uk, nuqa imanu kani nir chiqapta rimaqqa. Chaymi allita yaĉhani, payqa chiqapta riman nuqapaq, qamkuna allita intrakanaykillapapaq nirqa. ");
INSERT INTO qufNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Qamkunami uk kutiqa kaĉhakuraykillapa Juanta, nuqapaq tapunanllapapaq. Piru Juanta taputinllapa tukuy nishanqami chiqap karan. ");
INSERT INTO qufNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nishaykillapapis: Nuqaqami Dyusmanta kani pay chaynu munasha katin, mana runakuna munashanraykuchu. Piru chaynuqami nishunillapa: Juan rimashankunaqami kriyir washakanaykillapapaq karan nir yaĉhanaykillapapaq. ");
INSERT INTO qufNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Chaqa Juan yaĉhachikushanqami uk lampara ratakuq yupay karan. Chaymi, qamkunaqa chaynu shumaqta yaĉhachikutinqa, uk ratulapaq aligriyar uyakuraykillapa. ");
INSERT INTO qufNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Piru qamkuna chiqapta nuqapaq intrakanaykillapapaqqami, Juan nishanmanmatapis kan uk. Chayqami Taytay imakunataĉhi ruranaypaq nimashankuna. Chaymi ashwan Taytay munashannulla rurashaykuna ima allita intrachikun, nuqaqa chiqapta Dyusmanta shamusha kani nirqa. ");
INSERT INTO qufNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Chaynulla Taytay kaĉhamasha chayqa nuqapaq rimaran ima. Piru qamkunaqami rimatinmapis mana uyapashaykillapa chaynulla nuqa yupayqa mana rikashaykillapalamapischu. ");
INSERT INTO qufNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Chaynulla qamkunaqami Dyus nishankunamatapis mana intrakankillapachu, chay mayqanĉhi kaĉhamusha kaqpa Wamranpi mana kriyishaykillaparayku. ");
INSERT INTO qufNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Qamkunaqami, kutir kutir Tayta Dyus nitin iskribikashankunata liyinkillapa, chaynuqa tukuy tyimpupaqna kawsashaqllapa nir yarpur. Piru chaynu iskribikashakuna nuqapaq rimatin liyirmapis, ");
INSERT INTO qufNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","nuqapiqa mana kriyinayankillapachu, tukuy tyimpuna kawsanaykillapapaqqa. ");
INSERT INTO qufNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Piru, manami runakunaraq nuqata alabamanantachu ministini. ");
INSERT INTO qufNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Chaqa, qamkunapaqqami allita yaĉhani, Dyusta mana munankillapachu nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nuqata Taytay Dyus kaĉhamatin shamutiyqa, mana kasumar mana kriyimanankillapachu. Nataq ashwan uk runa paypa yarpuyninllamanta shamusha katin-shuypaqa alabar kasuyankimanllapana. ");
INSERT INTO qufNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Qamkunaqa, ¿imanunari kriyimankillapa? Chaqa qamkunaqami uknikillapa alabashunanllapalata munankillapa. Chaynu karmi Taytay Dyus qamkunata alabashunanllapataqa mana munankillapachu. ");
INSERT INTO qufNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Qamkunaqa amami yarpunkillapachu Taytaypa naypanpiqa nuqa uchachashuyashaqllapa nirqa. Ashwanmi Moisespi, kusalata kunfyakayankillapa chay paymi uchachashuyanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Piru chiqapta Moisespi kriyirqa, nuqapipis kriyinkimanllapa. Chaqa Moisesqami iskribirqa nuqapaq intrachikuran. ");
INSERT INTO qufNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Chaynu Moisés iskribishankunapi mana kriyirqa, ¿imanunari kriyinkillapa nuqa willashutiyllapamaqa?” nir. ");
INSERT INTO qufNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Chaymantami Jesusqa riran Galilea quĉhapa uklawn manyanman. Chay quĉhallami shutiqpis, Tiberias quĉha. ");
INSERT INTO qufNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Chaynu ritinmi, kusala achka runakuna pullanqa riranllapa. Chaqa paykunaqa rikasha karanllapa, Jesús qishaqkunata allichar ima achka milagrukunata rurashanta. ");
INSERT INTO qufNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Chaymantaqa Jesusqa yaĉhakuqninkunawan uk sirkaman iqar taranllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Piru chay diyamantaqa manami maychu karan Israelmanta runakunapa Pascua fyistanpis. ");
INSERT INTO qufNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Chaymanta Jesusqa sirkapi tayar chapakurqa, kusala achka runakuna paypa ikinta shamushata rikar, yaĉhakuqnin Felipita niran: —¿Maypitaq kay kwichka achka runakunapaqqa, rantiyanchikllapa mikuytaqa? ");
INSERT INTO qufNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Piru chaynuqami Jesusqa Felipitaqa tapuran, mabir imaninqashi nir. Chaqa payqami allita yaĉhayaranna imanu chay runakunata qarananpaq nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Chaynu taputinmi, Felipiqa niran: —Michka dusyintus dinaryu qillaywan tantata rantishamapis, manami piti pitila mikunanllapapaqmapis aypayanqachu nir. ");
INSERT INTO qufNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Chaymantaqa, chay yaĉhakuqnin Simón Pedrupa uknin Andresqa, niran: ");
INSERT INTO qufNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Kaypimi uk wamritu purichiyan sibadamanta sinku tantitawan ishkay piskadituta. Piru chaysituqa, ¿imanunari aypanqa kwichka achka runakunapaqqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Chaynu nitinmi, Jesusqa yaĉhakuqninkunataqa niran: —Willayllapa, tukuyla tanqallapa nir. Chaymi chaypi kusala qiwa katin, tukuyla chaypi samaranllapa. Chaqa chaypi kaqkunaqami, ullqukunala sinku milma (5,000) kasha kanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Chaymanta Jesusqa, chay tantitakunata aypar payji nir, Taytan Dyusman mañakurqa, yaĉhakuqninkunata aypachitin, paykunana tukuyla chaypi taqkunataqa aypachiranllapa. Chaynullami chay piskaditukunatapis aypachikutinllapa munashanllapata mikuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Chaynu mikur tiqllatinllapanaqa, Jesusqa yaĉhakuqninkunata niran: —Mikuy subrashankunataqa tantayllapa ama yanqalla qischakananpaqchu nir. ");
INSERT INTO qufNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Chaymi paykuna tantarqa dusi kanastata untachiranllapa, chay sibadamanta sinku tantita pakikar subrashankunataqa. ");
INSERT INTO qufNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Chaynu Jesús milagruta ruratin rikarmi, runakunaqa niyaranllapa: —Chiqaptami kay runaqa, Dyuspa rimaqnin kay pachaman shamunanpaq karan chay nir. ");
INSERT INTO qufNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Piru Jesusqami kwintata qukaran, chay runakunaqashi amalas apar mantaqninllapapaqna numranayan nir. Chayta yaĉharmi, qashan riran uk kusala atun sirkapa ananman, paylana kananpaq. ");
INSERT INTO qufNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Chaymanta limpu amsayatinnaqa, Jesuspa yaĉhakuqninkunaqa chay unaq sirkamanta ishkimur atun quĉhaman ĉhamuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Chaymi uk yaku karruman iqaranllapa, chay yakullata rir waklaw chimpa Capernaumman ĉhananllapapaq. Piru chay uras limpu limpu tutapashana katinmapis, manaraqmi Jesusqa unaq sirkamantaqa tikrakamushachu karan. ");
INSERT INTO qufNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Chaynu riyatinllapami, chay atun quĉhaqa alliplata wakmanta kaymanta maqchikaq qallariran, kusala jwirti wayra shamushanrayku. ");
INSERT INTO qufNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Chaymanta imanullapis sinkuta, manaqachu saysi kilumitrutana risha karllapaqa, Jesusta rikaranllapa yakupa ananllata rir paykunaman shipchaqtana. Chaymi paykunaqa kusalata manchakuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jesusqami niran: —¡Nuqami kani! ¡Amami manchakuyllapachu! nir. ");
INSERT INTO qufNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Chaynu nitinmi, yaĉhakuqninkunaqa yaku karruman kusa aligrila iqachiranllapa. Chaymi ashwan daslana chay riyashanllapa pachamanqa ĉharanllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Chaymanta allaqninqa, chay atun quĉhapa uklaw manyanpi runakuna kidasha kaqkunaqa kusalata Jesuspaq chapakuranllapa. Chaqa quya-pachami Jesuspa yaĉhakuqninkunataqa rikayatinllapa chay uklayla yaku karru chaypi kaqpi paykunala riranllapa. Chaymi yaĉharanllapa Jesusqa mana yaĉhakuqninkunawanqa rishachu nir. ");
INSERT INTO qufNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Piru chaynu chapakunanllapakamanqami, wakin yaku karrukunapis ĉhamuranllapana chay pwiblu Tiberias shutiqpi, Jesús Taytan Dyusta payji nir, tantitata runakunata qarasha karan, chay lugarpa yatanman. ");
INSERT INTO qufNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Chaymi runakunaqa, Jesusta chaynulla yaĉhakuqninkunata mana chaypi tarirqa, chay yaku karrukunaman iqar riranllapa Capernaumman, Jesusta maskaq. ");
INSERT INTO qufNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Chaynu rir, chay atun quĉhapa uklaw manyanman ĉhar, Jesusta tarirqa tapuranllapa: —Yaĉhachikuq Taytituy, ¿imurastaq kaymanqa ĉhamushayki? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesusqa niran: —Chiqaptami nishaykillapa: Qamkunaqami chay tiqllanaykillapakaman mikushaykillaparaykula maskamayankillapa. Manami chay milagrukunata rurashayta intrakashaykillaparaykuchu maskamayankillapa. ");
INSERT INTO qufNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Amami chay tukukaq mikuylapaq yarpurchu puriyllapa. Ashwanmi chay mikuy mana tukukaq, tukuy tyimpu kawsachikuqlapina yarpuyllapa. Chaymi Dyusmanta Shamuq Runaqa, mana tukukaq mikunaykillapatana qushunqallapa. Chaqa Taytan Dyusmi chaynu kananpaqqa nisha. ");
INSERT INTO qufNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Chaymi, Jesustaqa tapuranllapa: —Chaynu katinqa, ¿imatataq rurayashaqllapa, Dyus munashanta ruranayllapapaqqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesusqa, niran: —Dyusqami munayan chay mayqantaĉhi pay kaĉhamusha chay paylapi kriyinaykillapalata nir. ");
INSERT INTO qufNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Chaynu nitinpis, qashan tapuranllapa: —¿Ima milagruta ruratki rikartaq, kriyishuymanllapa, chiqapta Dyusmanta shamushayki nirqa? ¿Chaqa imakunatataq ruranki? ");
INSERT INTO qufNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Unay rukunchikllapakunamaqami chunllaq lugarpi ‘maná’ shutiq mikuyta mikur kawsaranllapa, imanuĉhi Dyus nitin iskribikashanpi nishannulla. Chaqa niqmi: ‘Paymi unaq syilumanta tantitata quran mikunanllapapaq’ nir. ");
INSERT INTO qufNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Chaynu nitinllapami, Jesusqa niran: —Chiqaptami nishaykillapa: Chay mikuytaqami unaq syilumanta chiqap kawsaq tantitata qarakuq Taytay Dyus qushuranllapa, mana Moiseschu. ");
INSERT INTO qufNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Chaqa Dyus chay tantitata qarakuyashanmi, syilumanta shamushana. Chaymi mayqanpis chay tantitata mikuqqa tukuy tyimpupaqna kawsanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Chaynu Jesús nitinmi, paykunaqa niranllapa: —Taytituy, chay tantitataqa tukuy tyimpu qaramastuyllapari, nir. ");
INSERT INTO qufNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesusqa niran: —Nuqami, kawsachikuq tantitaqa kani. Chaymi mayqanpis nuqapi kriyir nuqalapina kunfyakaqqa, manana mallaqnanqa chaynulla yakunanqalamapischu. ");
INSERT INTO qufNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Piru nishushayllapanullami, qamkunaqa imata ruratiy rikarmapis mana kriyimankillapachu. ");
INSERT INTO qufNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Chaqa Taytay Dyus akrashankunaqami nuqaman shamunllapa. Chaymi mayqanpis nuqaman shamuqtaqa mana itakurchu pullakushaq. ");
INSERT INTO qufNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","“Nuqaqami syilumanta, Taytay Dyus kaĉhamatin shamusha kani, mana munashayllata ruranaypaqchu. Ashwan shamusha kani, Taytay Dyus munashankunalata ruranaypaq. ");
INSERT INTO qufNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Chaqa Taytay Dyus, pay akrar qumashankunataqa mana chinqachinaytachu munan. Chaymi ashwan jwisyu diya ĉhamutinqa, wanushakunamatapis kawsachimushaq tukuy tyimpupaqna kawsananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Chaqa Taytay Dyusqami munan, mayqanpis nuqata rikamar kriyiqkunaqa tukuy tyimpupaqna kawsananllapata. Chaymi tukuy nuqapi kriyir wanutinmapis, maydiya jwisyu diya ĉhamutinqa kawsachimushaq tukuy tyimpupaqna” nir. ");
INSERT INTO qufNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Chaynu Jesús nitinmi, chay Israelmanta karguyjun runakunaqa piñakur rimapakuq qallariranllapa. Chaqa Jesusqa kaynu nisha karan: “Nuqami chay chiqap tantita unaq syilumanta shamusha chayqa” kani nir. ");
INSERT INTO qufNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Chaymi paykunaqa niranllapa: —¿Manachu kay runaqa, Josipa Wamran Jesús? Nuqanchikkunami riqsinchikllapa taytanta mamanmatapis. Piru ¿imapaqtaq, unaq syilumanta shamusha kani, niyan? ");
INSERT INTO qufNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Chaymi Jesusqa paykunataqa, niran: —Amana yanqalla piñakur rimapakuyllapanachu. ");
INSERT INTO qufNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Taytay mana akrashankunaqami, mana nuqamanqa imanupis shamunqallapachu. Mayqanpis nuqapi kriyiqkunataqami jwisyu diyapiqa kawsachishaq tukuy tyimpupaqna. ");
INSERT INTO qufNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Chaqa Dyuspa rimaqninkuna iskribishankunapimi nin: ‘Dyusmi tukuyta allita intrachinqa’ nir. Chayraykumi, Taytay Dyus nishankunata uyakur kasuqkunaqa, nuqamanna shamunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Manami mayqanpis Taytay Dyustaqa rikashachu. Nataq Dyusmanta shamusha chaylami allita riqsin. ");
INSERT INTO qufNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Chiqaptami nishaykillapa: Mayqanpis nuqapi allita kriyiqkunaqami tukuy tyimpupaqna kawsanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Chaqa nuqami kawsachikuq tantitaqa kani. ");
INSERT INTO qufNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Chay unay rukuykillapakuna chunllaq lugarpi ‘maná’ shutiq mikuyta mikurmapis, wanuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Piru nuqaqami willashuyanillapa chay tantita syilumanta shamusha chaypaq. Chaymi mayqanpis chayta mikuqqa manana maydiyapis wanunqanachu. ");
INSERT INTO qufNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nuqami chay kawsaq tantita syilumanta shamusha chayqa kani. Chaymi mayqanpis chay tantitata mikuqqa tukuy tyimpupaqna kawsanqa. Piru chay tantitaqami nuqapa kwirpuylla. Chaymi kwirpuytaqa qukuyani tukuyla runakunata washarna, tukuy tyimpu kawsachinaypaq” nir. ");
INSERT INTO qufNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Chaynu Jesús nitinmi Israelmanta karguyjunkunaqa paykunapura kusata willanakuq qallariranllapa: “¿Imanutaq paypa kwirpunllataqa qaramayashunllapaqa?” nir. ");
INSERT INTO qufNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Chaymi Jesusqa paykunata niran: —Chiqaptami nishaykillapa: Qamkuna, Dyusmanta Shamuq Runapa kwirpunta mana mikur chaynulla yawarninta mana upyarqa, Dyuspaqqa wanusha yupayna kankillapa. ");
INSERT INTO qufNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nataq nuqapi kriyir chay kwirpuyta mikuq, yawarniyta upyaqkuna-shuypaqa tukuy tyimpupaqna kawsanqa. Chaymi jwisyu diyapiqa, kawsachishaq wanusha katinmapis. ");
INSERT INTO qufNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Chaqa kwirpuywan yawarniymi chiqapta kawsachikun. Chayna, manana mallaqnanqallapa, yakunanqallapalamanapischu. ");
INSERT INTO qufNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Chaymi kwirpuyta mikuq, yawarniyta upyaqkunaqa, nuqapa pullay katin, nuqapis pullan kashaq. ");
INSERT INTO qufNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","“Tukuy tyimpupaq kawsaq Taytaymi kaĉhamasha. Chaymi kawsani Taytay munashanta ruranaypaq. Chaynullami mayqanpis mikumaqqa, nuqarayku kawsanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kananmi willashuyanillapa unaq syilumanta shamusha tantitapaq. Chay tantitaqami, mana unay rukuykillapakuna chunllaq lugarpi ‘maná’ shutiq mikuyta mikuranllapa chaynuchu. Chaqa paykunaqa chay ‘maná’ shutiq mikuyta mikurmapis, wanuranllapa. Piru syilumanta chay tantitata mikuqkunaqami tukuy tyimpupaqna kawsanqallapa” nir. ");
INSERT INTO qufNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesusqami tukuy kaykunataqa Capernaumpi tantakananllapa wasipi tantakasha katinllapa yaĉhachikuran. ");
INSERT INTO qufNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jesús chaynu yaĉhachikutin uyaparllapami paypi achka kriyiqkunaqa, kaynu niranllapa: —Kay niyashankunataqa manakish rurayashunllapachuqa. ¿Pitaq chaqa kasuyanqaqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Chaynu yarpupakuyanllapa nir kwintata qukarmi, Jesusqa kaynu nir tapuran: —¿Chay yaĉhachikushaychu, mana allinta yarpuchishuyanllapa? ");
INSERT INTO qufNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Piru Dyusmanta Shamuq Runa rikayatkillapa, unay kashanllaman tikrakatinqa, ¿imaniyankillapataq kanqa? ");
INSERT INTO qufNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Tayta Dyuspa Ispiritunmi tukuy tyimpupaq kawsachikuqqa. Chaqa mayqan runapismi mana chaynu kawsachikuytaqa puytinchu. Chayraykumi nuqa nishushayllapaqa kawsachikuq kar, kriyitkillapaqa tukuy tyimpupaqna kawsachishunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Piru chaynu katinmapis qamkunamanta wakinnikillapaqami mana kriyimanllaparaqchu. Jesusqami chaynuqa niran, chaqa payqami unaymanta-pacha, mayqankunami mana kriyinqallapachu, chaynulla mayqanmi kuntrankunaman qukuyanqa nir yaĉhashanrayku. ");
INSERT INTO qufNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jesusqami niranpis: —Chayraykumi nishurayllapapis: Mayqanta Taytay mana akrasha katinqa, manami nuqapi kriyiytaqa puytinchu nir. ");
INSERT INTO qufNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Chaynu Jesús nitinmi, chaymanta-pacha achka runakuna ashur, manana paywanchu puriranllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Chaymantami, Jesusqa dusi yaĉhakuqninkunataqa tapuran: —¿Qamkunapischu nuqamanta ashur rinayankillapana? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Chaymi Simón Pedruqa niran: —Piru Taytituy, ¿mayqanmannari rishaqllapa? Chaqa qam nishaykikunaqami chiqapta tukuy tyimpupaq kawsachikun. ");
INSERT INTO qufNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nuqakunaqami qampi kriyishana kanillapa. Chaymi yaĉhanillapa, qamqa Dyuspa Akrashan kusala Allin Wamran kanki, nir. ");
INSERT INTO qufNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Chaynu Pedro nitinmi, Jesusqa niran: —¿Manachu qamkunataqa dusikillapata akrashurayllapa? Piru qamkunamanta ukqami, dyablupa yarpuyninwan kashanrayku, dyablu. ");
INSERT INTO qufNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Chaynu nirqami, Jesusqa chay Simón Iscariotipa wamran Judaspaq, niran. Chaqa chay paymi dusi yaĉhakuqninkunamanta karmapis, Jesustaqa kuntrankunaman qukunanpaq karan. ");
INSERT INTO qufNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Chaymantami Jesusqa yaĉhachikur tukuy Galileapa lugarninkunapi puriran. Chaqa, payqami mana Judeapi kaytaqa munaranchu, Israelmanta karguyjunkuna wanuchinanllapapaq maskashanllaparayku. ");
INSERT INTO qufNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Piru chay Israel runakunapa uk fyistan Enramada shutiq chay shipchamuyatinnaqa, ");
INSERT INTO qufNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jesuspa ukninkunaqa kaynu niran: —Ama kaypi kidarchu, riy Judeaman. Wakpi, kriyiqkunapis rikananpaq qam tukuy ima rurashaykikunata. ");
INSERT INTO qufNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Chaqa, mayqanpis riqsikayta munaqqami imatapis mana pakapllaqa ruranchu. Chayraykumi kay rurashaykikunataqa tukuypa naypanpina ruray nir. ");
INSERT INTO qufNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Chaynumi paykunaqa niranllapa, ukninkuna karmapis mana kriyishanllaparayku. ");
INSERT INTO qufNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Chaymi Jesusqa niran: —Manami tukuy imata ruranaypaq uraqa ĉhamusharaqchu. Piru qamkunapaq-shuypaqami, ima uraspis kusala allin. ");
INSERT INTO qufNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kay pachamanta kaqkunaqa, mana ĉhiqnishuyta puytinllapachu qamkunataqa. Piru nuqata-shuypaqa ĉhiqnimanllapa, kusala mana allin rurashanllapakunata willar rikachishayrayku. ");
INSERT INTO qufNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Riyllapa qamkunala fyistamanqa. Nuqa-shuypaqa manaraq rishaqchu. Chaqa manaraqmi tukuy imata ruranaypaq uraqa ĉhamushachu nir. ");
INSERT INTO qufNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Chaynu nirmi, payqa Galileallapi kidaran. ");
INSERT INTO qufNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Chaymanta ukninkuna ritinnaqa, Jesuspis riran fyistamanqa. Piru, manami mayqanpis yaĉhatinchu, uyarala riran. ");
INSERT INTO qufNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nataq chay Israelmanta karguyjunkunaqa, fyistapiqa kusata maskayaranllapa Jesustaqa. Chaymi niyaranllapa: —¿Maypitaq kanqa chay runaqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Chay runakunamanta wakinkunami kusalata rimayaqllapa Jesuspaqqa. Ukkunami niyaqllapa: “Kusa allin runami” nir. Nataq ukkuna-shuypaqa niyaqllapa: “Manami, ashwan runakunata llullachin” nir. ");
INSERT INTO qufNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Piru pakakuqnulami rimaqllapa paypaqqa, Israelmanta karguyjunkunata manchashanllaparayku. ");
INSERT INTO qufNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Fyista qallarishanmanta lamtarpina katinqa, Dyusta adurananllapa wasiman Jesusqa yaykur, qallariran yaĉhachikuq. ");
INSERT INTO qufNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Chaymi, chay Israelmanta karguyjunkunaqa kusa dispantakashalla ninakuyaqllapa: “¿Imanutaq kayqa kusalata yaĉhan mana maydiyapis istudyasha karqa?” nir. ");
INSERT INTO qufNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesusqami paykunataqa niran: —Kay yaĉhayashayqami mana nuqapachu, ashwanmi chay mayqanĉhi kaĉhamasha chaypa. ");
INSERT INTO qufNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Chaymi mayqanpis Dyus munashanta ruranaqqa, yaĉhayta puytinqa kay yaĉhachikuyashayqa, Dyusmanta manaqachu nuqallamanta nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Chaqa mayqanpismi payllamanta rimaqqa, runakuna alabananlapaq rimanllapa. Piru, chay kaĉhamuran chayta alabananllapapaq rimaqqami, karanlata riman. Chaynulla, paypiqa mana ima mana allinkunaqa kanchu. ");
INSERT INTO qufNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“¿Manachu Moisés, Dyus mantakushanta qushuranllapa? Piru manami mayqannikillapalapis kumplinkillapachu. Chayraykumi wanuchimanayankillapa”. ");
INSERT INTO qufNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Piru, runakunaqami niranllapa: —¡Qamqami dyablupa yarpuyninwan kanki! ¿Pitaq wanuchishunayan? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesusqa niran: —Tukuyla qamkunaqami chay samana diyapi uk milagruta rurashaylapaq kusalata yarpupakur dispantakankillapa. ");
INSERT INTO qufNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Piru Moisesmi, qamkunata nishuranllapa chay siñal kustumrita ruraskinaykillapapaq, michka mana paypa mantakuynin katinmapis. Chaqa chay siñal kustumriqami unay rukuykillapakunamanta karan. Chaymi qamkunamaqa michka samana diyapimapis chay kustumritaqa rurankillapa. ");
INSERT INTO qufNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Chaynu qamkuna Moisés mantakushannulla kumplinaykillapapaq nir samana diyapimapis uk ullqu wamrituwan chay siñal kustumrita rurarqa, ¿imapaqtaq nuqa uk runapa tukuy kwirpunta samana diyapi allichashaypaq piñakunkillapa? ");
INSERT INTO qufNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Chayraykumi manaraq allita yaĉharqa ama uktaqa kusalata uchachayllaparaqchu. Ashwanmi allita yaĉhar, ima niytapis puytinkillapa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalén pwiblupi taqkunamanta wakinmi kaynu nir tapukayaqllapa: “¿Manachu kayta maskayanllapa wanuchinanllapapaq? ");
INSERT INTO qufNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Chaypi wakmaqa tukuypa naypanpi rimayan. Piru manami mayqanpis willayanchu. Wak karguyjunkunapisĉhi ¿Dyuspa Akrashan Cristun wak runaqa nir kriyishanllaparayku mana willanllapachu? ");
INSERT INTO qufNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nataq nuqanchikkuna-shuypaqami yaĉhanchikllapa maymantami kay runaqa nirmapis. Chaqa chiqap Dyuspa Akrashan Cristun shamutinqa, mana mayqanpis yaĉhanqachu maymantami shamun nirmapis”. ");
INSERT INTO qufNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Chaynu nitinllapa uyaparmi Jesusqa Dyusta adurananllapa wasipi yaĉhachikuyarqa, kusa jwirtita kaynu niran: “¡Chayqaĉhi qamkunaqa riqsimayankillapaqa maymantami kani nirmapis! Piru manami nuqa munashaynullachu shamusha kani. Ashwanmi uk kaĉhamasha katin shamusha kani. Payqami kusa allinla, chaynulla imatapis karanta ima ruran. Chaynu katinmi qamkunaqa mana riqsinkillapachu. ");
INSERT INTO qufNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nataq nuqa-shuypaqami allita riqsini paymanta shamushayrayku. Chaqa paymi kay pachamanqa kaĉhamasha” nir. ");
INSERT INTO qufNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Chaynu nitinmi, aypar wanuchinaranllapa. Piru manami mayqanlapis puytiranllapachu. Chaqa manaraqmi wanunanpaq urachu karan. ");
INSERT INTO qufNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Nataq kusala achkami wakinkunaqa kriyiranllapa paypiqa. Chaymi kaynu niyaranllapa: —¿Dyuspa Akrashan Cristun shamurqachu, kay runa mana ruraypaq imakunata, milagrukunata rurayashanmantaqa masta rurayanqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariseukunami, wakin runakuna Jesuspaq rimaqta uyaparanllapa. Chaymi, paykunaqa kurakunapa mantaqninkunata, Dyusta adurananllapa wasipi wakin kuytakuqkunata kaĉharanllapa, Jesusta aypananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Piru Jesusqa niran: —Qamkunawanqami mana unaylatanachu kashaq. Chaymi ashwan tikrakashaqna chay mayqanĉhi kaĉhamaran chayman. ");
INSERT INTO qufNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Chaynami qamkunaqa kusalata maskamarpis mana tarimankillapachu. Chaqa manami chay kayashaymanqa riyta puytinkillapachu nir. ");
INSERT INTO qufNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Chaynu nitinmi, Israelmanta karguyjunkunaqa, paynin paynin kaynu ninakuqllapa: “¿Maymantaq kayqa riyanqa, nuqanchikkuna mana tarinapaqqa? ¿Manaqachu riyanqa Israelmanta runakuna uklaw pachakunapi shikwakasha tan chaykunaman, chaypina mana Israelmanta kaqkunata yaĉhachiq? ");
INSERT INTO qufNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Ima nishaq nirtaq niyanqa: ‘Qamkunaqami maskamarpis mana tarimankillapachu’, ‘Chaqa nuqa kayashaymanqa mana puytinkillapachu riyta’ nirqa?” ");
INSERT INTO qufNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Chay fyista tukukanan diyami kusala mas allin karan. Chaymi Jesusqa chay diyapi sharir kusa jwirtita kaynu niran: “Mayqan yakunaqqa, nuqaman shamunqa. Chaymi kriyirqa yakuta upyaq yupayna kanqa, ");
INSERT INTO qufNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Dyus nitin iskribikashanpi nishannulla. Chaqa ninmi: Mayqanpis nuqapi kriyiqpa yarpuyninpiqami riyu yaku riq yupay kanqa nir”. ");
INSERT INTO qufNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Chaynu nirqami Jesusqa yaĉhachikuyaran, paypi kriyiqkunaqashi Dyuspa Santu Ispiritunwanna kanqallapa nir. Piru Jesús manaraq wanur kawsamusha katinmi, Tayta Dyuspa Santu Ispiritunqa manaraq kriyiqkunawanchu karan. ");
INSERT INTO qufNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Chaymantami wakin runakuna Jesús nishanta uyaparqa, kaynu niyaranllapa: —Chiqaptami kay runaqa Dyuspa uk rimaqnin shamunanpaq karan chay, nir. ");
INSERT INTO qufNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ukkunaqa niqllapa: —Kaymi Dyuspa Akrashan Cristun nir. Piru ukkunaqa niqllapa: —¡Manami! Chaqa Dyuspa Akrashan Cristunqami mana Galileamantachu kayta puytin. ");
INSERT INTO qufNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Chaqa Dyus nitin iskribikashakunapimi nin: ‘Dyuspa Akrashan Cristunqashi unay gubyirnu Davidpa ayllunmanta kanqa. Chayshi David yupaylla Belén pwiblumanta kanqa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Chaynu nir Jesuspaq ukmanta ukmanta yarpurmi tukuyla runakuna limpu chiqanchanakuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Chaynullami Dyusta adurananllapa wasipi wakin kuytakuqkunaqa, aypar prisunayaqllapa. Piru manami mayqanpis chaynuqa ruraranllapachu. ");
INSERT INTO qufNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Chaymantami Dyusta adurananllapa wasipi kuytakuqkunaqa, tikrakar riranllapa fariseo runakuna, kurakunapa mantaqninkuna kayashanllapaman. Chaymi tapuranllapa: —¿Imapaqtaq mana apamushaykillapa? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Paykunaqa niranllapa: —Mana mayqanpis chay runa yupay kusa shumaqtaqa rimashachu nir. ");
INSERT INTO qufNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Chaymi, chay fariseo runakunaqa, niranllapa: —¿Qamkunapischu dijakatkillapa llullachishushallapa? ");
INSERT INTO qufNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Manaqachu ¿paypi mayqannin mantaqninchikllapa, manaqa wakin fariseo masinchikkunapis ‘Dyuspa Akrashan Cristun’ nir kriyishallapa? ");
INSERT INTO qufNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Piru, chay runakuna Dyus nitin Moisés mantakushankunata mana intrakarmi, Jesustaqa ‘Dyuspa Akrashan Cristun’ ninllapa. Chayraykumi Dyus paykunataqa kastiganqa. ");
INSERT INTO qufNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Chaymi fariseo runakunamanta Nicodemo, uk tuta Jesusta rikaq risha karan chayqa, niran: ");
INSERT INTO qufNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Nuqanchikkunapaq Dyus unay mantakushanpimi nin: Manashi mayqan runatapis ima niytapis puytinchikchu, puntata paypaq mana imata rurasha nir yaĉhar, uyapasha ima karqa. ");
INSERT INTO qufNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Chaynu nitinmi, wakinkunaqa niranllapa: —¿Qampischu Galileamanta kanki? Dyus nitin iskribikashakunatami allita liyiy. Chaynumi yaĉhanki Galileamantaqa Dyuspa uk rimaqninqa mana kayta puytinchu nir. ");
INSERT INTO qufNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Chaymantami wasinman riranllapana. ");
INSERT INTO qufNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Nataq Jesusqami Olivos sirkaman riran. ");
INSERT INTO qufNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Allaqmanta achkiyatinnaqa qashan riran Dyusta adurananllapa wasiman. Chaypimi runakuna payman qimikatin, chaylapi tar yaĉhachikuq qallariran. ");
INSERT INTO qufNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Chaymi chaymanqa, Moisés mantakushanta yaĉhar yaĉhachikuqkuna, fariseo runakunaqa uk warmi ukwan ukwan punuqta tarishanllapata aparanllapa. Chaymantami chay warmitaqa tukuypa ĉhaypinpi shachir, ");
INSERT INTO qufNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jesustaqa niranllapa: —Yaĉhachikuq Taytituy, kay warmimi runan kaqta ingañar, uk runawan punuqta tarisha kanillapa. ");
INSERT INTO qufNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Chaqa Dyus nitin Moisés iskribishanpimi nin: Waknu tukuq warmitaqashi rumillawan sitar wanuchiypaq. ¿Qam-shuypaqa ima ninkitaq? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Paykunaqami chaynuqa tapuranllapa Jesús ima mana allinta rimatinqa, chaylapaqna uchachananllapapaq. Piru Jesusqa piratar didunwan pachapi iskribiq ĉhurakaran. ");
INSERT INTO qufNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Chaymanta mas tapuyatinllapami, Jesusqa das sharir niran: —Qamkunamanta mayqannikillapa mana uchayjun kaqmi naypaqtaqa sitanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Chaynu nirqami, qashan piratar iskribiq ĉhurakaran pachapiqa. ");
INSERT INTO qufNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Chaynu nitin uyaparmi, kusa uchayjun kashanllaparayku pinqakur ukninpis ukninpis chay runakunaqa riq qallariranllapa. Ashwanmi chay puntata riqkunaqa mas rukukaqkuna karan. Chaynumi tukuyla ritinnaqa chay warmiqa paylana kidasha karan. Chaymi Jesusqa, ");
INSERT INTO qufNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","piratayashanmanta alsakamur tapuran: —Mamitay, ¿maypitaq chay runakuna uchachashuqkunaqa? ¿Manachu mayqanninpis sitashuran? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Warmisitaqa niran: —Manami Taytituy. Chaymi Jesusqa niran: —Nuqapismi mana sitashaykichu. Ashwanmi kananqa rikuyna. Piru amanami uchakunkinachu nir. ");
INSERT INTO qufNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Chaymantami Jesusqa qashanpis runakunata willaq qallariran kaynu nir: —Nuqami tukuypa achkirachikuqnin kani. Chaymi mayqanpis nuqata kasumaqqa, achkiraqlapina kawsanqa. Chaynuqami manana maydiyapis tutaparaqpinachu kawsanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Chaynu Jesús nitinmi, fariseo runakunaqa niran: —Qamqami chaynuqa qamllapaq rimayanki. Chaymi chay rimashaykiqa mana imapaqpis sirbinchu nir. ");
INSERT INTO qufNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Chaynu nitinllapami, Jesusqa niran: —Nuqa rimashayqami chiqap, michka nuqallapaq rimatiymapis. Chaqa, nuqami yaĉhani maymanta shamusha kani, maymanmi riyani nirmapis. Nataq qamkuna-shuypaqa mana yaĉhankillapachu nuqapaqqa, maymantami kani, maymanmi riyani nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Qamkunami runakuna munashannulla rikar uchachamankillapa. Nataq nuqa-shuypaqami mana mayqantapis uchachanichu yanqa illaqmantaqa. ");
INSERT INTO qufNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Piru mayqanta allita rikar yaĉharqami, Dyus munashannulla chiqapta rikar yaĉhashaq. Chaqa manari nuqalachu chaytaqa rurashaq. Ashwanmi Taytay Dyus nuqata kaĉhamaqwan pulla runakunataqa allita rikar yaĉhashaqllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Chaqa Moisés qamkunapaq mantakushanpimi kaynu nin: ‘Imapaqpis ishkay tistigukuna chayllata rimatinshi ima nishanllapapis sirbin’ nir. ");
INSERT INTO qufNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Chaynu katinmi, nuqapis nuqallapaq rimarqa, uk tistigu kani. Chaynulla Taytay kaĉhamasha chay paypis, nuqapaq rimarqa paypis uk tistigu. Chaymi chay rimashaykunapaqqa, ishkay tistigukunana kanillapa Taytaywanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Chaynu nitinmi tapuranllapa: —¿Maypitaq Taytaykiqa? nir. Jesusqa niran: —Qamkunaqami mana riqsimankillapachu. Chaynulla Taytaytapis mana riqsinkillapachu. Chaqa nuqata riqsimayarllapaqa, Taytaytapis riqsiyankimanllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Tukuy kaykunataqami Jesusqa Dyusta adurananllapa wasipi yaĉhachikuran, chay ufrindata ĉhurananllapa kajunkuna tanan kwartupi. Piru, manami mayqanpis paytaqa ayparanllapachu. Chaqa manaraqmi chaynu kananpaq uraqa ĉhamusharaqchu karan. ");
INSERT INTO qufNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Chaymantami Jesusqa qashan paykunataqa niran: —Nuqaqami riyanina. Chaynu ritiymi qamkunaqa maskamankillapa. Piru manami tarimankillapanachu. Chaymi chay uchaykillapallawanna tukuy tyimpupaq wanunkillapa. Chaqa nuqa rishaymanqami qamkunaqa mana riyta puytinkillapachu nir. ");
INSERT INTO qufNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Chaymi Israelmanta karguyjunkunaqa niranllapa: —¿Wakqa paylla wanuyta munarchu imataq nimayanchikllapa pay riyashanmanqa mana riyta puytishunllapachu, nirqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Chaymi Jesusqa niranpis: —Qamkunaqami kaymanta kankillapa. Nataq nuqaqami unaq syilumanta kani. Chaynulla qamkunaqami kay pachapi, Dyusta mana riqsiqkunamanta kankillapa. Nataq nuqaqa mana kay pachamantachu kani. ");
INSERT INTO qufNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Chayraykumi nishurayllapa uchaykillaparayku wanunkillapa nirqa. Chaqa nuqata ‘Pimi kani’ nir, mana kriyimarllapaqa, uchaykillaparayku wanunkillapa tukuy tyimpupaqna nir. ");
INSERT INTO qufNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Chaynu nitinmi, tapuranllapa: —¿Pitaq qamqa kanki? nir. Jesusqa niran: —Nuqaqami puntamanta-pacha willashushallapana kani. ");
INSERT INTO qufNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nuqapami kan achka qamkunapaq rimanaypaq, imanumi kankillapa nir rikar yaĉhashushallapana kar. Nuqa willashushayllapaqami chiqap. Chaqa nuqata kaĉhamasha chayqami, chiqapta riman. Chaymi nuqa willashushayllapaqa, chaylla chay kaĉhamasha nishanwanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Piru paykunaqami, mana intrakaranllapachu Taytan Dyuspaq chaynu parlatinllapamapis. ");
INSERT INTO qufNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Chayraykumi Jesusqa niran: —Qamkunaqa, Dyusmanta Shamuq Runata unaqman alsaraq, riqsinkillapa Dyusmanta shamusha kasha nirqa. Chaynullami yaĉhankillapa manami imatapis nuqallaqa ruranichu nir. Ashwanmi rimani Taytay Dyus yaĉhachimashanlata. ");
INSERT INTO qufNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Chaqa nuqata kaĉhamaq Taytayqami, nuqawan. Chaymi, mana nuqalataqa dijamashachu. Chaqa nuqaqami pay munashannulata rurani nir. ");
INSERT INTO qufNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Chaynu Jesús nitinmi, kusa achka runakuna kriyiranllapa paypiqa. ");
INSERT INTO qufNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jesusmi chay Israelmanta runakuna paypi kriyishakunataqa kaynu niran: —Qamkuna, nuqa nishaykunapi kriyishaykillapanulla kawsarqami, chiqap yaĉhakuqniykunana kankillapa. ");
INSERT INTO qufNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Chaynulla chay chiqap kaqtana riqsinkillapa. Chaymi ashwan chay chiqap kaqqa tukuy imamanta washashunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Chaynu Jesús nitinmi, paykunaqa niranllapa: —Nuqakunaqami unay rukuyllapa Abrahampa ayllunmanta kanillapa. Chaynu karmi mana mayqanpa sirbiqninlamapischu kasha kanillapa. Piru, ¿imapaqtaq qamqa ninki tukuy imamanta washakankillapa nirqa? ");
INSERT INTO qufNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesusqa niran: —Chiqaptami nishaykillapa: Tukuy uchakuqkunaqami chay uchapaqa sirbikuqninna. ");
INSERT INTO qufNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Chaqa uk sirbikuqmaqa uk wasipiqa mana tukuy tyimpupaqqa kidayta puytinchu. Piru chay wasimanta kaqpa wamran-shuypaqami, tukuy tyimpupaqna wasinpiqa kidan. ");
INSERT INTO qufNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Chaynullami Dyuspa Wamran tukuy imamanta washashutinllapaqa, chiqaptana washakasha kankillapa. ");
INSERT INTO qufNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nuqaqami yaĉhani qamkunaqa Abrahampa ayllunmanta kankillapa nirmapis. Piru, qamkunami nuqa nishushayllapata mana kasunashaykillaparayku wanuchimanayankillapa. ");
INSERT INTO qufNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Chaqa nuqami, Taytay willamashanta, rikachimashanta qamkunataqa willashunillapa. Piru qamkuna-shuypaqami chay uk taytaykillapa nishanta uyar, munashanlata rurankillapa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Chaymi, paykunaqa niranllapa: —¡Taytayllapaqami rukuyllapa Abraham karan! Chaynu nitinllapami Jesusqa niran: —Qamkuna chiqapta Abrahampa wamrankuna karqa, pay rurashankunallata rurayankimanllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Piru qamkunaqami manana imanutaq Abraham allinlata ruraq chaynunachu kawsankillapa. Chaymi ashwan nuqa, Dyus willamashanta karanta willashutiyllapamapis qamkunaqa wanuchimanayankillapa. ");
INSERT INTO qufNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Chaynuqami qamkunaqa chay uk taytaykillapa munashannullata rurayankillapa nir. Chaynu Jesús nitinmi, paykunaqa niranllapa: —Manami mayqanpa jwira wamranchu kanillapa. Nuqakunaqami uk Taytayjunla kanillapa. ¡Payqami Taytayllapa Dyus! nir. ");
INSERT INTO qufNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Chaynu nitinllapaqa, Jesusqa niran: —Chiqapta Taytay Dyus, taytaykillapa katinqa, nuqata munamayankimanllapa. Chaqa nuqaqami kaypi kani Dyusmanta shamushayrayku. Manami munashayllamantachu shamusha kani. Ashwanmi Taytay Dyus kaĉhamasha kay pachaman shamunaypaqqa. ");
INSERT INTO qufNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Imapaqtaq qamkunaqa mana intrakayta puytinkillapa nuqa willashutiyllapaqa? Piru qamkunaqami rimashayta mana uyakunashaykillaparayku, mana intrakankillapachu. ");
INSERT INTO qufNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Qamkunapa taytaykillapaqami dyablu. Chaymi, paypa kaqninkuna kar munashanlata rurankillapa. Chaqa dyabluqami qallarishanmanta-pacha wanuchikuq karan. Chaynulla chay chiqap kaqpi kayta mana puytishanrayku, mana imalatapis karantaqa rimanchu. Chaymi imata rimarpis tukuyta llullakurla riman. Chaynu kashanraykumi tukuy llulla rimaqpaqa taytan. ");
INSERT INTO qufNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","“Piru nuqa karanta rimatiymapis, qamkunaqa mana kriyimankillapachu. ");
INSERT INTO qufNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Mabir ¿mayqannikillapataq nuqata qamqa uchayjun kanki nimayta puytinkillapa? Nuqa karanlata rimatiyqa, ¿imapaqtaq mana kriyimankillapa? ");
INSERT INTO qufNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Chaqa Dyusmanta kaqkunaqami, Dyus rimashankunata uyakur kasunllapa. Piru qamkunaqami mana Dyusmanta kashaykillaparayku, mana uyakunankillapalamapischu”. ");
INSERT INTO qufNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Chaymantaqa chay Israelmanta karguyjunkunaqa niranllapa: —Qamqami chay Samariamanta runa, chaynulla dyablupa yarpuyninwan kanki nirqa, manami pantarchu karanta willashuyanillapa. ");
INSERT INTO qufNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesusqa niran: —Manami ima dyablupa yarpuyninwanmapischu kani. Ashwanmi tukuy imatapis rurani Taytayta rispitar kasushayrayku. Nataq qamkuna-shuypaqami mana kasumankillapachu. ");
INSERT INTO qufNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Piru nuqaqa manami alabamanaykillapataqa ministinichu. Ashwan Taytaymi chaynu kanantaqa munan. Chaqa Paymi tukuyta allita rikar yaĉhanqa. ");
INSERT INTO qufNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Chiqaptami nishaykillapa: Mayqanpis nuqa rimashayta chiqapta kasur kawsaqkunaqami mana wanurchu tukuy tyimpupaqna kawsanqallapa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Chaynu nitinmi, Israelmanta karguyjunkunaqa niranllapa: —Kanan-shuypaqami chiqaptana yaĉhanillapa qamqa chiqapta dyablupa yarpuyninwan kanki nirqa. Chaqa Abraham, chaynulla Dyuspa wakin rimaqninkunapismi wanuranllapa. Nataq qam-shuypaqa ninki: ‘Nuqa rimashayta kasuqkunaqami mana wanurchu tukuy tyimpupaqna kawsanqallapa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Manaqachu qamqa taytayllapa Abrahammanta mas kanki? Paymi wanuran. Chaynulla Dyuspa rimaqninkunapismi wanuranllapa. ¿Imanu runa kaytataq qamqa munanki? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesusqa niran: —Nuqalla alabakanaypaq rimayatiyqami, chay rimashayqa mana imapaqpis sirbinmanchu. Nataq chay alabamaq chayqami Taytay, chay mayqantaĉhi qamkuna Dyusniy niyashaykillapalla. ");
INSERT INTO qufNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Piru qamkunaqami mana paytaqa riqsinkillapachu. Nataq nuqa-shuypaqa allita riqsini. Piru imanupi paytaqa mana riqsinichu niyar-shuypaqami, nuqapis kusala llulla kayman qamkuna yupaylla. Chaqa chaynu chiqapta riqsiq karmi, pay rimashankunata intrakar kasur ima kawsani. ");
INSERT INTO qufNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nataq unay rukuykillapa Abrahamqami nuqa imanu shamunaypaq nir rikananpaq kar, rikashanrayku kusalata aligriyaran nir. ");
INSERT INTO qufNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Chaynu nitinmi, Israelmanta karguyjunkunaqa, Jesustaqa kaynu niranllapa: —Manami sinkwinta añuyjunlamapischu kanki. ¿Piru ninki Abrahamta rikasha kani nir? ");
INSERT INTO qufNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Chaynu nitinllapami, Jesusqa niran: —Chiqaptami nishaykillapa: Nuqaqami Abraham manaraq kayatin, karayllana nir. ");
INSERT INTO qufNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Chaynu nitinqa, Israelmanta karguyjunkunaqa rumikunata ayparanllapa Jesusta sitananllapapaq. Piru payqami runakunapa rurinta pakakuqnulla Dyusta adurananllapa wasimantaqa lluqshiran. ");
INSERT INTO qufNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Chaymanta uk lugarta pasayarnaqa, Jesusqa rikaran uk runa nasishanmanta-pacha syigu kaqta. ");
INSERT INTO qufNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Chaymi yaĉhakuqninkunaqa Jesustaqa kaynu nir tapuranllapa: —Yaĉhachikuq Taytituy, ¿imaraykutaq kay runaqa syigu nasisha kasha kanqa, taytankunapa uchanraykuchu, manaqachu paypa uchanrayku? ");
INSERT INTO qufNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Chaynu taputinllapami, Jesusqa niran: —Manami paypa uchanrayku, chaynulla taytankunapa uchanraykuchu chaynuqa nasisha. Ashwanmi chaynuqa nasisha karan pay alliyatin rikar, Tayta Dyuspaq allita yaĉhananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Chayraykumi achkilla katinraq chay kaĉhamasha kaqpa trabajuntaqa rurashunllapa. Chaqa tutapananpaq urami ĉhamunqana. Chaynu tutapatinqami manana mayqanpis trabajanqanachu. ");
INSERT INTO qufNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Chaqa nuqa kay pachapi karllaraqmi, tukuypa achkirachikuqnin kani nir. ");
INSERT INTO qufNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Chaynu nirnaqami Jesusqa pachaman tuqakur, tuqayninwan lluchkitata rurar, chay syigupa nawinta ");
INSERT INTO qufNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","salar kaynu niran: —Rir paqakuy Siloé shutiq quĉhapi. (Siloimi, rimayninchikpiqa munan niyta ‘Kaĉhamusha’ nir). Chaymi chay syiguqa rir paqakurqa, rikakurna tikrakamuran. ");
INSERT INTO qufNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Piru paytaqami chay yatanpi taqkuna, chaynulla wakinkunapis unaylla rikasha karanllapa limusnata mañakur taqta. Chaymi chay runakunaqa kaynu ninakuqllapa: “¿Manachu kay runaqa limusnata mañakur taq chay?” nir. ");
INSERT INTO qufNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ukkunaqa niyaqllapa: “Chiqaptami pay” nir. Ukkuna-shuypaqa niyaqllapa: “Manami paychu. Michka kusa paynu karmapis” nir. Piru chay alliyasha runaqami niyaq: “Arí, nuqami kani” nir. ");
INSERT INTO qufNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Chaymi tapuranllapa: —¿Imanutaq kananqa rikakuyta puytinki? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Chay alliyasha chayqa, niran: —Chay runa Jesús shutiqmi pachalapi tuqayninwan lluchkitata rurar, nawiyta salar nimaran: ‘Rir chay quĉha Siloé shutiqpi paqakuy’ nir. Chaynu nimatin paqakurmi, rikakuyta puytirayna. ");
INSERT INTO qufNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Chaymi qashan tapuranllapa kaynu nir: —¿Maypitaq chay runaqa? Payqami niran: —Manami yaĉhanichu nir. ");
INSERT INTO qufNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Jesusqami samana diyapi lluchkitata rurar, chay syigu runata allichashanqa karan. Chaymi, unay syigu kasha runataqa aparanllapa fariseukunaman. ");
INSERT INTO qufNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Chaymantami, paykunaqa tapuranllapa: —¿Imanutaq kananqa rikakuyta puytinkina? nir. Payqami niran: —Nawiyta lluchkitawan salatin, rir paqakushaymanta-pachami kananqa rikakunina. ");
INSERT INTO qufNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Wakin fariseo runakunaqami niranllapa: —Chayta rurashaqami mana Dyusmanta Shamuq Runachu kanqa. Chaqa manari samana diyamatapis kwintachayanchu nir. Piru ukkunaqami niyaqllapa: —¿Uk runa uchayjunqami chay mana ruraypaq milagrukunataqa mana rurayta puytinmanchu? Chaynu ukmanta ukmanta rimarmi, mana chayllatanachu yarpuyaqllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Chaymi qashan kaynu nir tapuranllapa chay unay syigu karan chay runataqa: —Kanan rikakunaykipaq allichashushanraykuqa, ¿imaninkitaq paypaqqa? Payqa niran: —Nuqami nini, Dyuspa uk rimaqnin kanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Piru Israelmanta karguyjunkunaqami mana kriyinaranllapachu chiqap syigu kasha kanqa nirqa. Chaymi, taytankunata qayachimuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Chaymi kaynu nir tapuranllapa: —¿Kayqachu wamraykillapa? ¿Manachu qamkunaqa niraykillapa syigu nasiran nir? ¿Imanutaq kananqa rikakuyta puytin? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Chaynu taputinllapami, taytankunaqa niranllapa: —Yaĉhanillapami payqa wamrayllapa syigu nasisha karan chay nir. ");
INSERT INTO qufNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Piru manami yaĉhanillapachu imanumi kananqa rikakuyta puytinna, chaynulla mayqanmi allichasha nirmapis. Dijur payta tapuyllapa willashunqallapa. Chaqa paypismi byiju runana nir. ");
INSERT INTO qufNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Chaynuqami taytankunaqa rimaranllapa manchakushanllaparayku. Chaqa Israelmanta karguyjunkunaqami parlasha karanllapa, mayqanpis Jesusta Dyuspa Akrashan Cristun nir kriyiqtaqa chay tantakananllapa wasimanta itakunanllapapaq nir. ");
INSERT INTO qufNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Chayraykumi, taytankunaqa kaynu niranllapa: “Dijur payta tapuyllapa. Chaqa payqami byiju runana” nirqa. ");
INSERT INTO qufNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Chaymantami chay Israelmanta karguyjunkunaqa, qashan chay syigu alliyashataqa, qayamur tapuranllapa: —Chiqapta Dyuspa naypanpi jurar willamayllapa. Chaqa nuqakunaqami yaĉhanillapa chay allichashusha runaqami kusala uchayjun nir. ");
INSERT INTO qufNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Chaynu taputinllapami, payqa niran: —Nuqaqami mana yaĉhanichu uchayjun mana uchayjun nirmapis. Nataq nuqaqami yaĉhani syigu karay, piru kananqami rikakunina nir. ");
INSERT INTO qufNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Chaynu nitinmi, qashan tapuranllapa: —¿Imanutaq rurashuran? ¿Imatataq ruraran rikakunaykipaqqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Payqa niran: —Willashurayllapanami, ¿manachu intrakankillapa? ¿Imapaqtaq qashan willashunayta munankillapa? ¿Manaqachu qamkunapis paypa yaĉhakuqninna kanayankillapa? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Chaynu nitinmi, kusata musyar niranllapa: —Qamqami chay runapa yaĉhakuqninna kanki. Nataq nuqakuna-shuypaqa Moisespa yaĉhakuqnin kanillapa. ");
INSERT INTO qufNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Chaqa allitami yaĉhanillapa, Dyusmi Moisestaqa willaran nir. Piru chay runapaq-shuypaqami mana yaĉhanillapachu maymantami rikarimusha nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Chaynu nitinllapami, chay runaqa niran: —¡Imanutaq kayqa kanqa! Qamkunaqa mana yaĉhankillapachu maymantami chay runaqa nirmapis. Piru nuqata-shuypaqami syigu kashaymanta allichamashana. ");
INSERT INTO qufNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Allita yaĉhashanchikllapanu, uk uchasapataqami Dyusqa michka mañakutinmapis mana uyapanchu. Ashwanmi paylata sirbir, munashanta ruraqkunalatami uyapan. ");
INSERT INTO qufNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Manami maydiyapis uyashanchikllapachu, uk runa nasishanmanta-pacha syigu kaqta uk runa allichasha nirqa. ");
INSERT INTO qufNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Chaqa chay runa, Dyusmanta mana shamusha karqa, manami imatapis rurayta puytiyanmanchu nir. ");
INSERT INTO qufNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Chaynu nitinmi, niranllapa: —Qam kusala uchayjun nasisha karmapischu, ¿nuqakunata yaĉhachimanayankillapa? nir. Chaynu nirmi, chay tantakananllapa wasimantaqa itakuranllapana. ");
INSERT INTO qufNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Chaymantami Jesusqa yaĉharan chay tantakananllapa wasimanta itakushallapa chay syigu kayar alliyasha runataqa nir. Chaymi, payta tarirqa Jesusqa kaynu nir tapuran: —¿Qamqachu kriyinki Dyusmanta Shamuq Runapiqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Chaymi chay runituqa niran: —Taytituy, mayqantaq payqa willamay, nuqa kriyinaypaq nir. ");
INSERT INTO qufNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesusqa niran: —Rikashaykinami. Nuqami kani. Nuqallawanmi parlayanki nir. ");
INSERT INTO qufNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Chaymantami chay runaqa, Jesuspa naypanpi qunqurikur kaynu niran: —Kriyinimi qampi Taytituy nir. ");
INSERT INTO qufNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Chaymantami Jesusqa niran: —Nuqami kay pachaman shamusha kani tukuyta allita rikar yaĉhanaypaq. Chaynulla syigukunaqa rikakunanpaq. Nataq chay rikakuqkuna-shuypaqa amana rikakunanpaqnachu nir. ");
INSERT INTO qufNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Chaynu Jesús nitinmi, wakin fariseo runakuna chaypi kar, uyakuqkunaqa niranllapa: —¿Nuqakunapischu syigukuna kanillapa? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesusqa niran: —Qamkuna syigukuna karllapaqa, manami uchayjunchu kankimanllapa. Piru rikakuni nishaykillaparayku, ashwan uchayjun kankillapa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesusqami niranpis: “Chiqaptami nishaykillapa: Mayqanpis uyshakunapa chikrunman mana punkunta yaykur uklawta yaykuqqami, upallala suwakuqkuna, imanullapis amalas suwakuqkuna ima. ");
INSERT INTO qufNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Piru chikruman chay punkunlata yaykuq-shuypaqami, chay uyshakunapaqa michikuqnin kar kuytan. ");
INSERT INTO qufNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Chaymi, punkupi kuytakuqqa punkuta kiĉhatin, chay michikuqqa uyshankunataqa shutinllapi qayatin, rimayninlamanta riqsin. Chaynumi uyshankunataqa chikrunmanta lluqshichinna. ");
INSERT INTO qufNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Chaymanta tukuynin uyshankuna lluqshitinnaqa, michikuqninqa naypanta rin. Nataq chay uyshankuna-shuypaqa ikinlata rin. Chaqa rimayninlamantari riqsin michikuqnintaqa. ");
INSERT INTO qufNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Piru, mayqan mana riqsishanpa ikintaqami mana rinchu. Ashwanmi paymantaqa alsakan. Chaqa manari riqsinchu rimayninlamatapis”. ");
INSERT INTO qufNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Chaynu nir Jesús kay kumparasyunwan willatinmapismi, chay uyakuqkunaqa mana intrakaranllapachu ima nishaq nirmi chaynu niyan nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Chaymantami Jesusqa qashan kaynu niran: “Chiqaptami nishaykillapa: Nuqami chay uyshakuna chikrunman yaykunan punku kani. ");
INSERT INTO qufNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Piru tukuy nuqamanta naypaqta shamuqkunaqami upallala suwakuqkuna, chaynulla imanullapis amalas suwakuqkuna ima karanllapa. Chaymi, chay uyshitaykunaqa mana kasuranllapachu paykunataqa. ");
INSERT INTO qufNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nishushayllapanu, nuqami chay chikrunpa punkunqa kani. Chaymi mayqanpis nuqapi kriyishanrayku chay punkuta yaykuqqa washakashana kanqa. Chaynuqami, imanutaq uk uyshamaqa chikrunman yaykur, lluqshimur, rir kusala shumaq qiwata tarin, chaynuna kanqa. ");
INSERT INTO qufNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Suwakuqkunaqami shamun suwakuq, wanuchikuq, pantachikuq ima. Piru nuqa-shuypaqami shamusha kani, nuqapi kriyiqkunata bidanta qutiy kusa achkata kusichakuq yupay kusa aligrila tukuy tyimpupaqna kawsananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nuqami uyshakunapa chiqap michiqninqa kani. Chaqa chay chiqap michikuqqami uyshankunata washananrayku wanunmapis. ");
INSERT INTO qufNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Piru wakin michikuqkunaqami qillayta ganananlapaq michikunllapa. Chaynu karmi kusala atun surru shamuqta rikarqa, uyshakunamatapis dijar alsakan mana washarlamapischu. Chaqa chiqaptaqari chay uyshakunapaqa mana chiqap michikuqninchu. Chaynulla chay uyshakunapis mana paypachu. Chaymi chay atun surru, uyshakunata aypaq shamutinqa, uyshakunaqa wakta kayta shikwakar rinllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Chaynumi chay michikuq qillaylapaq yarpur michikuqqa alsakan. Chaqa qillaylapaqri yarpur, uyshakunata-shuypaqa mana kwintachanchu. ");
INSERT INTO qufNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Piru nuqa-shuypaqami uyshakunapa chiqap michikuqnin kani. Chaymi, imanutaq Taytayqa nuqata riqsiman chaynullami nuqapis paytaqa riqsini. Chaynulla uyshaykunatapis riqsitiy, paykunapis riqsimanllapa. Chayraykumi uyshaykunata washanayraykuqa wanushaq ima. ");
INSERT INTO qufNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Uklawpipismi kan uyshaykunaqa. Piru paykunaqami mana chay chikrullamantachu. Chaymi paykunatapis kaymanna apamushaq. Chaynuqami paykunapis nuqatana kasumatinqa tukuyla uk chikrulamanta yupayna kanqallapa. Chaymi ashwan uk michikuqniyjunlana kanqallapa tukuyla. ");
INSERT INTO qufNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Taytaymi nuqataqa kusalata munaman. Chaqa uyshaykunaraykumi wanur, chaymanta kawsamushaq. ");
INSERT INTO qufNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Piru manami mayqan runa wanunaypaq nishanraykuchu wanuyani. Ashwanmi nuqalla chaynu pasananpaqqa yarpusha kani. Chaqa nuqaqami wanur chaymanta qashan kawsamunaypaqna kani. Chaynu ruranaypaqmi Taytayqa nimasha” nir. ");
INSERT INTO qufNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tukuy chaykunata Jesús rimatinmi, chay Israelmanta karguyjunkunaqa, qashan ukmanta ukmanta yarpupakur chiqanchanakuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Piru paykunamanta achkami niyaranllapa: —¿Imapaqta waktaqa kasuyankillapa? Wakqami dyablupa yarpuyninwan kar yaruyasha, nir. ");
INSERT INTO qufNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Nataq ukkunaqa niyaqllapa: —Mayqanpis dyablupa yarpuyninwan karqa, manami waknuqa rimayanmanchu. ¿Manaqachu uk dyablupis allichayta puytinman syigukunata? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jerusalén pwiblupimi unayqa, Israel runakuna Dyusta adurananllapa wasita kamkachir, qasay tyimpupi Dyusman mañakuranllapa paypaqna kananpaq nir. Chaymi chayta yarpur añu añu chay qasay tyimpullapi fyistata ruraqllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Chay diyakunami Jesusqa Dyusta adurananllapa wasipi, Salomonpa kurridurnin niqllapa chaypi puriyatin, ");
INSERT INTO qufNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Israelmanta karguyjunkunaqa paypa ridurninman qimikar kaynu nir tapuranllapa: —¿Maydiyakamantaq willamayankillapaqa mayqanmi kanki nirqa? Chiqapta Dyuspa Akrashan Cristun karqa, kananlla willamayllapana nir. ");
INSERT INTO qufNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesusqa niran: —Willashurayllapami qamkunataqa. Piru manami kriyimaraykillapachu. Chaqa Taytay nimashannulla imatapis rurarqami, allitana intrachishunillapa mayqanmi kani nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Piru qamkunaqami mana kriyinkillapachu, mana uyshaykunapa wakinnin kashaykillaparayku. ");
INSERT INTO qufNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Chaqa uyshaykunaqami rimanaylamanta riqsimar, pullayna rinllapa. Chaynullami nuqapis paykunata riqsini. ");
INSERT INTO qufNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Chaymi paykunataqa mana tukukaq tukuy tyimpu kawsaytana qushaq. Chaynuqami manana mayqanpis kitamanqachu. ");
INSERT INTO qufNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Chaqa Taytay tukuymanta kusalata puytiqmi uyshitaykunataqa qumasha. Chaymi Taytay akrashantaqa mana mayqanpis kitayta puytinqachu. ");
INSERT INTO qufNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Taytaywan nuqaqami, ukla kanillapa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Chaynu Jesús nitinmi, Israelmanta karguyjunkunaqa qashan rumikunata ayparanllapa sitananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Piru Jesusqa niran: —Taytaypa pudirninwanmi kusala achka allin imakunata naypaykillapapi rurasha kani. ¿Chay mayqayninpaqtaq sitamanayankillapa? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Chaynu Jesús nitinmi, Israelmanta karguyjunkunaqa niranllapa: —Manami allinkunata rurashaykipaqchu sitashuyanillapa. Ashwanmi sitashuyanillapa Tayta Dyuspaq kusala mana allinta rimashaykirayku. Chaqa runala karmapismi ‘Nuqaqa Dyuswanqa chaylla kani’ nirqa Dyusnu tukuyanki nir. ");
INSERT INTO qufNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesusqa paykunata niran: —Dyus nitinmi, qamkunapaq kaynu nir iskribiran: ‘Nuqami nini dyuskuna kankillapa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Allita yaĉhashanchikllapanu chay iskribikashakunaqami chiqap. Chaqa Tayta Dyusqami paylla, paypa rimayninta intrakaqkunataqa, ‘dyuskuna kankillapa’ niran. ");
INSERT INTO qufNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Piru nuqamataqami Taytay Dyusqa paylla akrar kay pachaman kaĉhamaran. Chaynu kar nuqaqa Dyuspa Wamran kani nishushayllapapaqqa, ¿imapaqtaq Dyuspaqqa mana allintachu rimanki ninkillapaqa? ");
INSERT INTO qufNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Taytay rurashankunata mana rurayatiyqa, amari kriyimayllapachu. ");
INSERT INTO qufNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Piru Taytaypa ruranankunata ruratiy mana nuqata kriyimarllapamapis, chay rurashaykunalapimapis kriyiyllapa, allita yaĉhanaykillapapaq Taytaywan nuqaqa chaylla kanillapa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Chaynu Jesús nitinmi, qashan paykunaqa aypanaranllapa. Piru Jesusqami alsakar riran. ");
INSERT INTO qufNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Chaymantami Jesús tikrakar rir, riyu Jordanpa chimpanman ĉhar chaypi kidaran, chay maypiĉhi Shutichikuq Juan unay shutichikuq chaypi. ");
INSERT INTO qufNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Piru chaymanpismi, kusa achka runakuna rikaq rirllapa, kaynu niyaqllapa: —Shutichikuq Juan mana milagruta rurar imapis, kay runapaq nishanqami, chiqap kasha nir. ");
INSERT INTO qufNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Chaymi chay lugarkunapiqa, achka kriyiranllapa Jesuspiqa. ");
INSERT INTO qufNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Karanmi uk qishaq runa Lázaro shutiq. Payqami Mariapa, Martapa pwiblun Betaniamanta karan. Piru kay ishkay warmikunaqami Lazarupaqa ukninkuna karan. ");
INSERT INTO qufNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Kay Lazarupa uknin Mariami Jesuspa ĉhakinman mishki mutkiypaqla yakituta iĉhar, aqchanwan chakichisha karan. ");
INSERT INTO qufNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Kay ishkay warmikunami, uknin Lázaro qishaq katin, kaĉhakuranllapa Jesusta kaynu nir willananllapapaq: —Taytituy, kusala munashayki amiguykimi qishaq nir. ");
INSERT INTO qufNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Chaynu nitinllapa uyaparmi, Jesusqa niran: —Manami chay nanaywanqa wanunqachu. Ashwanmi chayqa chaynuqa pasayan imanumi Taytay Dyus, chaynulla Wamranpis kusala pudirniyjun nir yaĉhar alabananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Piru Jesusqa, Martawan Mariata chaynulla Lazaruta michka kusata munaq karmapismi, mana chay diyaqa riranchu. ");
INSERT INTO qufNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Chaymi ashwan Lázaro qishaq nitinllapamapis, ishkay diya mastaraq kidaran chay maypiĉhi karan chay lugarpiqa. ");
INSERT INTO qufNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Chaymantami Jesusqa yaĉhakuqninkunata kaynu niran: —Rishunllapa qashan Judea lugarman nir. ");
INSERT INTO qufNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Chaynu nitinmi, yaĉhakuqninkunaqa niranllapa: —Yaĉhachikuq Taytituy, manami maychu chay Israelmanta karguyjunkuna rumikunawan sitar wanuchishuyta kamashanllapaqa. Chaynumapischu, ¿qashan chay lugarman rinayanki? ");
INSERT INTO qufNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Piru Jesusqa niran: —¿Manachu dusi urayjun uk diyaqa? Chaynu katinqa, mayqanpis unaq purirqa mana trumpisanchu, kay pachapi tukuypa achkirachikuqninchikllapa kashanrayku. ");
INSERT INTO qufNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nataq mayqanpis tuta puriqkunaqa trumpisan, achkirachikuqnin mana kashanrayku. ");
INSERT INTO qufNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Chaynullami niranpis: —Amigunchik Lazarumi punusha. Chaymi rishaq rikĉhachiq nir. ");
INSERT INTO qufNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Chaynu nitinmi, yaĉhakuqninkunaqa niranllapa: —Taytituy, punusha karqami intrachimanchik alliyayanqana nir. ");
INSERT INTO qufNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Piru Jesusqami, Lazaruqa punusha niyaran, wanushanrayku. Nataq yaĉhakuqninkunaqami yarpuranllapa Lázaro punusha katin waknuqa niyan nir. ");
INSERT INTO qufNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Chaynu yarpuyatinllapami, Jesusqa allitana willar niran: —Lazaruqami wanusha. ");
INSERT INTO qufNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Piru nuqa mana chaypi katiy wanushanraykumi kusalata aligriyani. Chaqa chaypiraq imata ruratiypis rikar allitana nuqapi kriyinkillapa. Chaymi ashwan rishunllapa rikaq. ");
INSERT INTO qufNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Chaymantami, Tomasta milli niqllapa chayqa, wakin yaĉhakuq masinkunataqa niran: —Rishunllapa nuqanchikkunapis, paywan pulla wanunallapapaq, nir. ");
INSERT INTO qufNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Chaymanta Jesús ĉharqa yaĉharan Lázaro pampakashanqa kwatru diyana nir. ");
INSERT INTO qufNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania pwibluqami Jerusalenmanta yaqqa kimsa kilumitrupi yupay kashanrayku shipchanlapi karan. ");
INSERT INTO qufNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Chaymi Israelmanta kusa achka runakunaqa risha karanllapa Martawan Mariata, watukur kunsulananllapapaq uknin wanushanrayku. ");
INSERT INTO qufNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Chaymantami Martaqa yaĉharan, Jesús shamuyan nir. Chaymi lluqshir riran tariq. Nataq María-shuypaqa wasinlapi kidaran. ");
INSERT INTO qufNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta, Jesusta tarirnaqa niran: —Taytituy, qam kaypi kasha katkiqa, ukniyqa mana wanunantachu. ");
INSERT INTO qufNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Piru yaĉhayani, kananmapis imata mañakutkiqa Dyusqa yanapashunqa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesusqa niran: —Uknikiqami kawsamunqa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martaqa niran: —Arí, maydiya jwisyu diya ĉhamutinqami, wanushakunawan pulla kawsamuyanqa nir yaĉhayani. ");
INSERT INTO qufNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Chaymi Jesusqa niran: —Nuqami tukuypa kawsachiqnin kani. Chaymi mayqanpis nuqapi kriyiqqa michka wanusha karmapis kawsamunqa. ");
INSERT INTO qufNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nataq mayqanpis kawsayarlla nuqapi kriyiqkuna-shuypaqa, manana tukuy tyimpupaqnaqa wanunqallapanachu. ¿Kriyinkichu chaynu nishutiyqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Martaqa niran: —Arí Taytituy. Nuqaqami kriyini qamqa Dyuspa Akrashan Cristun kanki, Dyuspa Wamran kay pachaman shamunanpaq karan chay, nir. ");
INSERT INTO qufNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Chaynu nirnaqami, Martaqa riran uknin Mariata qayamuq. Chaymi uknintaqa uyarala kaynu nir willaran: —Yaĉhachimaqninchikmi chaypi qayashuyan nir. ");
INSERT INTO qufNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Chaynu nitinmi, Mariaqa chay kutilla sharir riran Jesustaqa rikaq. ");
INSERT INTO qufNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Piru Jesusqami, manaraq chay pwiblumanqa yaykusharaqchu karan. Ashwanmi chay maypiĉhi Martawan tarinakusha karan, chayllapiraq karan. ");
INSERT INTO qufNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Chaynu María sharir utqaylla ritinqa, Israelmanta wakin runakuna kunsulaq ĉhasha karan chaykunaqa ikinta riranllapa uknin pampakashanman riyanqa chaypi waqaq nir yarpur. ");
INSERT INTO qufNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Chaymanta María, Jesús kayashanman ĉharqa, naypanpi qunqurikur kaynu niran: —Taytituy, qam kaypi kasha katkiqa, ukniyqa mana wanunantachu nir. ");
INSERT INTO qufNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Chaymantami Jesusqa Mariata, chaynulla Israelmanta runakuna Mariata kunsulaq rishakunapis waqaqta rikarqa kusala ukmanta llakiran. ");
INSERT INTO qufNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Chaymi kaynu nir tapuran: —¿Maypitaq pamparaykillapa? Paykunaqa, —Shamur rikay Taytituy— nitinllapa, ");
INSERT INTO qufNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesusqa waqaran. ");
INSERT INTO qufNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Chaymi Israelmanta runakunaqa niranllapa: —¡Rikayllapa alliplatari munayasha! ");
INSERT INTO qufNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Piru paykunamanta wakinqa, niyaranllapa: —Kay runa, chay syiguta allichashaqachu ¿mana imallataqa rurayta puytisha kanman, Lázaro ama wanunanpaqqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Chaymantami Jesusqa qashan kusa llakishala, Lázaro pampakashanman qimikaran. Chay Lázaro pampakashanqami uk atun maĉhay karan. Nataq chay yaykuna punkunqami kirparayaran uk paltalla rumiwan. ");
INSERT INTO qufNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Chaymi Jesusqa niran: —Ashuchiyllapa kay rumitaqa, nir. Chaymi wanushapa uknin Martaqa, niran: —Taytituy, kusatanami asyayanqa. Chaqa kwatru diyanari wanushanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Piru Jesusqa niran: —¿Manachu nishuray, nuqapi kriyitkiqami Tayta Dyuspa pudirnin mana ruraypaqkunata ruratin rikanki? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Chaynu nitinmi, rumita ashuchiranllapa. Chaymi Jesusqa unaq syiluman chapakur, kaynu niran: “Taytay, payji nishuni. Chaqa qamqami uyapamashayki. ");
INSERT INTO qufNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Piru nuqaqami allita yaĉhani, qamta mañakushutiyqa imuraspis uyapamanki nir. Chaynuqami nishuni: Kay runakuna uyakuqkunaqa allitana yaĉhananllapapaq, qammi kay pachamanqa kaĉhamashayki nir”. ");
INSERT INTO qufNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Chaynu nirqami, kusala jwirtita qayakuran: —¡Lázaro, lluqshimuy! nir. ");
INSERT INTO qufNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Chaynu nitinmi wanusha karan chayqa lluqshimuran, ĉhakin, makinmapis raĉhpawan watakasha. Chaynulla qaqllanpis raĉhpawan pampakasha ima. Chaymi Jesusqa niran: —Kaĉhar dijayllapa rinqa, nir. ");
INSERT INTO qufNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Tukuy Israelmanta runakuna Mariata yapar rishakuna, Jesús Lazaruta kawsachimutin rikarqa, achka kriyiranllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Piru wakinkuna-shuypaqami riranllapa fariseo runakunata willaq, Jesús tukuy imata rurashantaqa. ");
INSERT INTO qufNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Chaynu willatinllapami chay fariseukuna, kurakunapa mantaqninkunaqa tantakaranllapa chay kusa karguyjunkunaman. Chaymi kaynu niranllapa: —¿Imatataq rurashunllapa? Chay runaqami ashwan mas milagrukunata rurarna puriyan. ");
INSERT INTO qufNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Chaqa dijashallapaqami tukuylana paypi kriyinqallapa. Chaymi ashwan chay Roma pwiblumanta karguyjunkunaqa shamur Dyusta adurananchikllapa wasita, chaynulla tukuyta limpu tukchimachuwanllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Piru paykunamanta uk runa Caifás shutiqmi, chay añukunapiqa kurakunapa punta mantaqnin karan. Chaymi kaynu niran: —Qamkunaqa mana imatapis yaĉhankillapachu. ");
INSERT INTO qufNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Chaynulla manami kwintata qukankillapachu. Chaqa chay pwiblunchikllapa tukukananmanta chaynulla tukuyla runakuna wanunanmantaqami uk runa wanunanpaqqa kusala allin nir. ");
INSERT INTO qufNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Nataq Caifasqami mana pay munashanllamantachu chaynuqa rimaran. Chaqa chay añukunapi kurakunapa mantaqnin katin, Dyus rimachitin, rimaran Jesusqashi wanuyanqa tukuy Israel runakunata washananpaq nir. ");
INSERT INTO qufNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Piru manami Israel runakunalapaqchu wanunanpaq karan. Ashwanmi payqa Dyuspa tukuy wakin wamrankuna kaqkunapaqpis wanunanpaq karan. Chaynuqami maymanta karmapis uklana kananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Chaymi chay diyamanta-pacha, Israelmanta karguyjunkunaqa Jesusta wanuchinanllapapaqna yarpuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Chayraykumi Israelmanta karguyjunkunapa shutinpiqa, Jesusqa manana puriqchu. Chaynami chay Judeapa pwiblunkunamantaqa lluqshir riran uk chunllaq lugarpa shipchanpi uk pwiblu Efraín shutiqmanna. Chaymi chaypina kidaranllapa yaĉhakuqninkunawanqa. ");
INSERT INTO qufNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Manami maychu karan Israelmanta runakunapa Pascua fyistanqa. Chaymi chay diyakunapiqa tukuyla Israel pwiblukunamanta kusala achka runakuna riyaqllapa Jerusalenman chay shumaqchakananllapa kustumrinta ruraqllapa manaraq fyista qallariyatin. ");
INSERT INTO qufNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Chaynu Jerusalenpina karqami, kusalata Jesusta maskayaranllapa. Chaymi Dyusta adurananllapa wasipiqa ukninllapa ukninllapa kaynu nir tapunakuyaqllapa: “¿Imatataq yarpunkillapa? ¿Shamuyanqachu fyistamanqa, manaqachu mana?” nir. ");
INSERT INTO qufNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nataq, chay fariseukuna, kurakunapa mantaqninkuna-shuypaqa mantakusha karanllapa, mayqanpis Jesuspaq maypi nir yaĉharqa, paykunata willatinllapa aypananllapapaq nir. ");
INSERT INTO qufNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Saysi diya, Pascua fyistapaq faltayatinmi, Jesusqa chay kawsachimushan Lázaro tayashan Betaniaman riran. ");
INSERT INTO qufNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Chaypiqami Jesusrayku mikuyta kamkachir, kunachikuranllapa mikunanllapapaq. Chaymi, Martaqa mikuyta misaman aypachikamuyaq. Nataq Lázaro-shuypaqa misapina Jesuswan pulla mikuyaqllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Chaykamanqami, midya butilla kusa karu ĉhaniyjun mishki mutkiypaqla nardo shutiq yakituta, Lazarupa uknin Mariaqa apamuran. Chaymi chaywanna Jesuspa ĉhakinta paqastur, aqchanwan chakichiran. Chaymi, chay wasi kayashanllapamapis kusala shumaq mishkita asyayarna kidaran. ");
INSERT INTO qufNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Chaymantami, yaĉhakuqninkunapa uknin Simonpa wamran Judas Iscariote, Jesusta kuntrankunaman qukunanpaq karan chayqa, kaynu niran: ");
INSERT INTO qufNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Waknu yanqalla iĉhananmantaqa qumashallapa trisyintus dinaryu qillaypaq rantikur, mana imayjun kaqkunata yanapanallapata nir. ");
INSERT INTO qufNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Piru Judasqami chaynuqa niran, mana chiqapta mana imayjunkunapaq llakishanraykuchu. Ashwanmi chaynuqa niran suwakuq kashanrayku. Chaqa pay chay ufrindata tantananllapa talqitata purichiq karmi, ĉhuratinllapaqa munashanta aypakuq. ");
INSERT INTO qufNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Chaymi Jesusqa niran: —Dijay, payqami kusa shumaqtana kwirpuyta kamkachisha wanur pampakanaypaq. ");
INSERT INTO qufNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Chaqa mana imayjun kaqkunawanqami maydiyapis pulla kankillapa, munashaykillapa ura yanapanaykillapapaqqa. Piru nuqa-shuypaqami manana pullaykillapanachu kashaq nir. ");
INSERT INTO qufNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Israelmanta achka runakunami yaĉharanllapa, Jesusqa Betaniapi nir. Chaymi riranllapa wakmanqa, Jesusta chaynulla pay kawsachimushan Lazaruta rikaq ima. ");
INSERT INTO qufNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Chaymantami chay kurakunapa mantaqninkunaqa Lazarutapis wanuchinanpaq yarpuranllapa. Chaqa Lázaro kawsamushanta rikarmi Israelmanta kusala achka runakuna Jesuspina kriyiqllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kusala achka runakunami risha karanllapa Jerusalenman, Pascua fyistapaqqa. Chaymantami allaqnin diyaqa yaĉharanllapa Jesusqami fyistaman ĉhamuyan nir. ");
INSERT INTO qufNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Chaymi paykunaqa palmira qirukunata kuchumur, kusa aligrila kaynu nir laqyar riranllapa Jesustaqa tariq: “¡Biba biba! ¡Kusa alabakashami kanqa Taytanchik Dyuspa shutinpi shamuqqa! Chaynulla ¡kusa alabakashami kanqa Israel pwiblupa gubyirnunqa!” nir. ");
INSERT INTO qufNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Chaymantaqami Jesusqa uk burruta tarir anan taran, imanuĉhi Dyus nitin iskribikashannulla. Chaqa niqmi: ");
INSERT INTO qufNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Amami manchakuychu, Sión pwiblu. Chaqa rikay, mantakuqnikimi shamuyan uk burritupa anan tasha” nir. ");
INSERT INTO qufNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Piru kaykunapaqqa yaĉhakuqninkunaqa mana intrakaranllaparaqchu. Chaymanta Jesús wanur kawsamutinraqmi, yaĉhakuqninkunaqa intrakaranllapa, pay imanu kananpaqqami, unaylla iskribikasha kasha nir. ");
INSERT INTO qufNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Nataq runakuna, Jesús Lazaruta pampakashanmata kawsachimushanta rikashakunaqa, tukuylata parlaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Chayraykumi runakunaqa riranllapa Jesustaqa tariq. Chaqa yaĉharanllapari milagrukunata rurashanpaq. ");
INSERT INTO qufNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Piru chay fariseo runakuna-shuypaqa paykunapura kaynu ninakuyaranllapa: “Rikashaykillapanu kananqami manana imatapis rurayta puytinchikllapanachu. Chaqa tukuymi paylapi kriyirna, rinllapa paywanna” nir. ");
INSERT INTO qufNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Jerusalén fyistaman adurakuq rishakunapa rurinpiqami, Greciamanta runakuna karanllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Chaymi paykunaqa, Galileapa uk pwiblun Betsaida shutiqmanta kaq, Felipiman qimikar kaynu nir rugaranllapa: —Taytituy, Jesustami rikanayanillapa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Chaynu nitinllapami, Felipiqa rir Andresta willar, ishkantinllapa riran Jesusta parlaqqa. ");
INSERT INTO qufNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Chaymi Jesusqa niran: —Ĉhamushanami uraqa, Dyusmanta Shamuq Runa wanutin, Taytay Dyus kawsachimutin, tukuy runakuna rikar yaĉhananllapapaqqa. ");
INSERT INTO qufNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Chiqaptami nishaykillapa: Trigupa uk murisitun pachaman ratar mana pampakarqami mana puqunqachu. Ashwanmi maydiyapis chay uk murisitula kayanqa. Nataq pampakar-shuypaqa, ashwan winar kusala achkatana puquyanqa. ");
INSERT INTO qufNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Chaymi nini, mayqanpis bidanpaq llakir washayta kamaqkunaqa limpu chinqanqallapa. Piru chay mayqanpis kay bidapi nuqapi kriyishanrayku wanuq-shuypaqami, tukuy tyimpupaqna kawsanqa. ");
INSERT INTO qufNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Chayraykumi mayqanpis sirbimanaqqa, maypi katiypis pullay kar sirbimanqa. Chaynu mayqanpis sirbimatinqami, Taytayqa kusa allinpaqna riqsinqa. ");
INSERT INTO qufNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Chaymantaqami Jesusqa niran: “¡Kananllami kusalata llakini! ¿Imatanari nishaq? ¿Taytay kay qischakanay uramanta washamay, nir? ¡Manami! Chaqa chaypaq-ari shamusha kani. ");
INSERT INTO qufNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Taytay, runakunata rikachiy, imatapis rurayta puytinki nir alabashunanllapapaq”. Chaynu Jesús nitinqami, unaq syilumanta uk rimay kaynu niyaran: “Qamwanmi rikachishana kani. Piru qashanmi rikachikushaq, chiqapta imatapis rurayta puytini nir alabamananllapapaq”. ");
INSERT INTO qufNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Chaymi runakuna chaypi uyakuqkunaqa, niyaranllapa: “Kunya karan” nir. Nataq wakin-shuypaqa niyaranllapa: “Uk angelmi payta willasha” nir. ");
INSERT INTO qufNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Chaynu niyatinllapami, Jesusqa niran: —Manami nuqaraykuchu chay rimaytaqa uyapashaykillapa. Ashwanmi chaytaqa uyapashaykillapa qamkuna allita intrakanaykillapapaq, nuqatami Taytayqa willamayaran nir. ");
INSERT INTO qufNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Chaymi kananqa ĉhamushana uraqa, tukuy kay pachapi kaqkunata allita rikar yaĉhanaypaqqa. Chaymantami Taytay Dyusqa, kay pachapi mantakuqtaqa itakunqa amana mantakunanpaqchu. ");
INSERT INTO qufNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Piru, nuqata kruspi unaqman alsamatinllapanaqa, kay pachapi kaqkunaqa nuqapi tukuyla kriyir, tukuy tyimpupaqna kawsanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Chaynu nirqami Jesusqa intrachikuyaran imanumi wanuyanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Chaynu nitinmi, chay runakunaqa niranllapa: —Dyus nitin iskribikashankunata liyirmi yaĉhasha kanillapa, Dyuspa Akrashan Cristunqashi tukuy tyimpupaq kawsayanqa nir. Piru ¿imapaqta ninki, Dyusmanta Shamuq Runataqa kruspi unaqman alsakayanqallapa nirqa? Chaynu katinqa, ¿pitaq Dyusmanta Shamuq Runaqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Chaymi Jesusqa paykunata niran: —Pullaykillaparaqmi kanqa chay achkirachikuqqa. Piru mananami unaytanachu pullaykillapaqa kanqa. Chayraykumi kay achkirachikuq kaypi kayashanlla, ama tutaparaqpiqa puriyllapachu. Chaqa mayqanpis tutaparaqpi puriqqami, mana yaĉhanchu maytami riyan nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Chaymi chay achkirachikuq kaypi kashanlla kriyiyllapa paypi. Chaynuqami qamkunapis chay achkirachikuqpaqna kankillapa. Chaynu nirqami, Jesusqa chay kayashanmantaqa rir pakakuranna paykunamantaqa. ");
INSERT INTO qufNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesús, Israel runakunapa naypanpi michka mana ruraypaq shumaq imakunata, chaynulla milagrukunata rurasha katinmapis, paykunaqa mana kriyiranllapachu. ");
INSERT INTO qufNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Piru chaynuqami pasaran, Dyuspa rimaqnin Isaías iskribishannulla kumplinanpaq. Chaqa kaynu nirmi iskribisha kayaq: “Taytituy, ¿pitaq shumaq rimashanchikpiqa kriyisha? ¿Pitaq intrakasha tukuy imata rurayta puytinki nirqa?” ");
INSERT INTO qufNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Chaynumi, mana imanupis kriyiyta puytiqllapachu. Chaqa Isaiaspismi kaynu nir iskribisha karan: ");
INSERT INTO qufNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Dyusmi kay runakunapa nawintaqa limpu kirpasha. Chaynulla mana intrakaqpaq tikrasha. Chaynuqami rurasha chapakurpis amana rikakunanpaq. Chaynulla manana intrakananllapapaq. Chaynu nuqapaq mana intrakar mana kriyitinllapaqami, nuqapis mana allichashaqchu” nir. ");
INSERT INTO qufNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Chaynu nirqami Isaiasqa iskribiran, Jesucristo imanu kusa pudirninwan mantakuqta rikashanrayku. ");
INSERT INTO qufNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Chaymi Israelmanta kusa achka runakuna, chaynulla wakin karguyjunkunamapis Jesuspiqa kriyiranllapa. Piru chaynu kriyirllapamapis, manami tukuypa naypanpiqa Jesuspaqqa rimaqllapachu, chay fariseo runakunata tantakananllapa wasimanta itakumanmanllapa nir manchakushanllaparayku. ");
INSERT INTO qufNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Chaynuqami paykunaqa tukuyaranllapa runakuna alabananllapalata munar. Nataq Dyus kusa allinpaq riqsinanta-shuypaqami mana yaqqa kwintachaqllapachu. ");
INSERT INTO qufNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Chaymantami Jesusqa kusa jwirtita rimar kaynu niran: “Mayqanpis nuqapi kriyiqqa, manami nuqalapichu kriyiyan. Ashwanmi Taytay kaĉhamasha chay paypipis kriyiyanllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Chaynulla mayqan rikamaqkunapismi, chay kaĉhamasha chaytapis rikanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nuqami achkirachikuq chay kani. Chaymi kay pachamanqa shamusha kani, nuqapi kriyiqkunaqa ama tutaparaqpi kidananllapapaqnachu. ");
INSERT INTO qufNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Piru mayqanpis nuqa rimashayta uyakur, mana kasukuqkunataqa, manami nuqachu kastigashaq. Chaqa manami kay pachamanqa runakunata kastiganaypaqchu shamusha kani. Ashwanmi shamusha kani, tukuyta washanaypaq. ");
INSERT INTO qufNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Chaymi disprisyamar, rimashaykunata mana kasuqkunataqami, jwisyu diya ĉhamutinqa Taytay Dyusqa rimashaykunawan rikar kastiganqa. ");
INSERT INTO qufNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Chaqa manami nuqa munashayllamantachu rimani. Taytaymi kaĉhamasha, imata rimanaypaq, yaĉhachikunaypaq nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Chaymi nuqaqa yaĉhayani, Taytay mantakushankunata kasur imaqa tukuy tyimpupaqna kawsanqallapa nir. Chaynumi nuqaqa, tukuy imata Taytay Dyus nimashanlata rimar yaĉhachikuni”. ");
INSERT INTO qufNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Mananami maychu karan Pascua fyistapaqqa. Jesusqa yaĉhashana karan, wanur kawsamur syiluman rir Taytanwan qashan tarinakunanpaq uraqami ĉhamushana nir. Piru Jesusqami tukuyla paypi kriyiqkunataqa kusalata munaran. Chaymi wanunanpaqna karmapis ashwan masta paykunataqa munaran. ");
INSERT INTO qufNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Chaymanta Pascua mikunata mikunanllapapaqna katinllapaqami, Simonpa wamran Judas Iscariotita dyabluqa yarpuchishana karan, Jesusta kuntrankunaman qukunanpaqqa. ");
INSERT INTO qufNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Piru Jesuspismi yaĉharanllana, Taytan Dyusmanta shamushanrayku qashan payllaman tikrayan nir. Chaynullami yaĉharanpis Taytanqami tukuy imata pay mantananpaqna nisha nir. ");
INSERT INTO qufNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Chaynu mikuyatinllapami das sharir, qatakunan raĉhpanta lluqshichir uk twayata sinturanpi watakuran. ");
INSERT INTO qufNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Chaymantami yakuta batyaman itar, yaĉhakuqninkunapa ĉhakinkunata paqar, chay sinturanpi watakushan twayawan chakichiran. ");
INSERT INTO qufNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nataq Simón Pedrupa ĉhakinta paqananpaqna katinqa, Pedruqa niran: —Taytituy, ¿qamchu nuqapa ĉhakiyta paqanayanki? ");
INSERT INTO qufNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesusqa niran: —Kanan kayta ruratiyqami mana intrakankiraqchu. Piru chaymantaqami intrakankina nir. ");
INSERT INTO qufNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedruqa niran: —¡Taytituy, michkapis manami ĉhakiytaqa paqachishaykichu! nir. Jesusqa niran: —Mana ĉhakikita paqatiyqami, mana nuqapa kaqniychu kayanki kanqa, nir. ");
INSERT INTO qufNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Chaynu nitinmi Simón Pedruqa niran: —¡Chaynu katinqa, Taytituy ama ĉhakiylatachu paqay! ¡Ashwanmi makiywan umaytapis paqapamay! nir. ");
INSERT INTO qufNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Piru Jesusqami niran: —Chayraq intiru kwirpunta paqakushataqami ĉhakinlatana paqanchik. Chaqa kwirpunqami kusala shumaqnari. Chaynumi qamkunapis shumaqna kankillapa. Piru chaynu shumaqqami mana tukuynikillapachu kankillapa. ");
INSERT INTO qufNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Chaynu, “Manami tukuynikillapachu shumaq kankillapa” nirqami niyaran, mayqanmi kuntrankunaman qukuyanqa nir yaĉhashanrayku. ");
INSERT INTO qufNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yaĉhakuqninkunapa ĉhakinkunata paqarnaqa qatakunan raĉhpanta qatakurna qashan misaman tar, kaynu niran: “¿Intrakankillapachu, chaynu ĉhakikillapata paqashaypaqqa? ");
INSERT INTO qufNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Qamkunaqami nimankillapa: Mantamaqniy, Yaĉhachikuq Taytituy nir. Chaynu nirqami chiqapta niyankillapa. Chaqa chaynumiri kani. ");
INSERT INTO qufNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","15","Nuqa mantashuqnikillapa, yaĉhachishuqnikillapa karmapismi ĉhakikillapata paqasha kani. Chaymi, nuqa rurashaynulla, qamkunapis uknikillapa uknikillapa ĉhakikillapata paqar sirbinakunkimanllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","“Chiqaptami nishaykillapa: Uk sirbikuqqami mana maschu patrunninmantaqa. Chaynulla chay kaĉhamutin shamuqpis manami maschu chay kaĉhamuqmantaqa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tukuy kay nishushayllapata intrakasha kar, kasur kawsarllapaqami, kusa shumaqna kayankillapa kanqa. ");
INSERT INTO qufNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Chaynu nirqami, mana tukuynikillapapaqchu rimayani. Chaqa nuqaqami allita yaĉhayani mayqankunalatami akrasha kani nirmapis. Piru Dyus nitin iskribikashanqami kumplikayta ministiyan. Chaqa niqmi: ‘Nuqawan pulla mikuqmi, kuntrayna tikrakasha’ nir. ");
INSERT INTO qufNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Kaytami willashunillapa yaĉhaskinaykillapapaqna, maydiya chaynu pasatinqa, kriyinaykillapapaq mayqanmi nuqaqa kani nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Chiqaptami nishaykillapapis: Nuqa kaĉhashayta shumaqta samachiqqami, nuqata samachimayanqa. Chaynulla, nuqata samachimaq-shuypaqa, chay kaĉhamasha chayta samachiyanqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Chaynu nir tukchirnaqa, Jesusqa kusalata llakir kaynu niran: —Chiqaptami nishaykillapa: Qamkunamanta uknikillapami kuntraykunaman qukumayanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Chaynu nitinmi yaĉhakuqninkunaqa uknin uknin kusalata chapanakuyaranllapa, mayqanpaqmi rimayan nirmapis mana yaĉharchu. ");
INSERT INTO qufNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tukuy yaĉhakuqninkunamantaqami Jesusqa ukta kusalata munaq. Chaymi mikuyatinllapaqa Jesuspa qichqanlapi tayaran. ");
INSERT INTO qufNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Chayraykumi chaytaqa, Simón Pedruqa siñalawan willaran Jesusta tapunanpaq, pipaqshi rimayan nir. ");
INSERT INTO qufNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Chaymi chay yaĉhakuqninqa Jesusman mas qimikar kaynu nir tapuran: —Taytituy, ¿pitaq chayqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesusqa niran: —Mayqantaĉhi, tantata pitir nuyuchir aypachiyani chay paymi nir. Chaynu nirnaqami tantata pitir nuyuchir, Simonpa wamran Judas Iscariotita aypachiran. ");
INSERT INTO qufNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Chaynu tantata Judas aypatinla, yarpuyninman Satanaspa yarpuyninqa yaykuran. Chaymi Jesusqa niran: —Imataĉhi ruranaykipaq yarpushayki chaytaqami, utqar rurayna, nir. ");
INSERT INTO qufNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Piru chaynu Jesús nitinmapismi, chay misapi mikuqkunaqa mana intrakaranllapachu, imapaqmi chaynu nisha nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ashwanmi wakinqa Judas qillayta tantananpaq talqitata purichiq katin kaynuta yarpuranllapa: Pascua fyistapaq imallataqa rantinanpaq, manaqapis mana imayjunkunata imallataqa qunanpaq kanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Chaymanta Judas tantata mikurnaqa, waqtaman lluqshiranna. Chaqa chay urasqami, tutana karan. ");
INSERT INTO qufNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas waqtaman lluqshishana katinqa, Jesusqa niran: —Kananmi ĉhamushana uraqa Dyusmanta Shamuq Runa wanur kawsamutin, tukuyla rikar alabananllapapaq. Chaynu pasatinmi Taytay Dyuspis alliplata riqsikar alabakanqa. ");
INSERT INTO qufNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Chaymi, payrayku Tayta Dyus allipta alabakarqa, dasna paypis riqsichikur alabachinqa, paymanta Shamuq Runaqa chiqap paynu nir. ");
INSERT INTO qufNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Kusala munashay wamrituykuna, pullaykillapaqa mananami unaylatanachu kashaq. Chaymi qamkunaqa maskamankillapa. Piru imanuĉhi Israelmanta karguyjunkunata willaray, chaynulla qamkunatapis kananqa willashaykillapa: Nuqa rishaymanqami manaraq riyta puytinkillapachu. ");
INSERT INTO qufNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Chaymi ashwan kay mushuq mantakuyta willashaykillapa ruranaykillapapaq: Uknikillapa uknikillapami llakipanakunkillapa, imanuĉhi qamkunata llakipashunillapa chaynulla. ");
INSERT INTO qufNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Chaynu uknikillapa uknikillapa llakipanakutkillapaqami, tukuy kwintata qukanqallapa, chiqaptami yaĉhakuqniykuna kankillapa, nir. ");
INSERT INTO qufNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Chaymantami Simón Pedruqa Jesustaqa kaynu nir tapuran: —Taytituy, ¿maymantaq riyanki? Jesusqa niran: —Imanuĉhi nishurayllapa chaynullami kananllaqa manaraq nuqa rishaymanqa riyta puytinkichu. Piru chaymantanami rinki nuqa kayashaymanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Chaymi Pedruqa niran: —Taytituy, ¿imapaqtaq mana kananlla qamwan riyta puytini? ¡Chaqa nuqaqami qamrayku wanuchimanatinllapamapis wanunaypaqqa listuna kani! nir. ");
INSERT INTO qufNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Chaynu Pedro nitinmi, Jesusqa niran: —¿Nuqaraykuchu wanunaykipaqmapis listuna kanki? Piru chiqaptami nishayki: Manaraq gallu kantayatinmi, qamqa kimsa kuti ninki: ‘Manami paytaqa riqsinichu’ nir. ");
INSERT INTO qufNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Chaymantami Jesusqa yaĉhakuqninkunataqa kaynu niran: “Qamkunaqa amami yarpupakuyllapachu. Ashwanmi Dyuspi chaynulla nuqalapi kriyir kawsayllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Chaqa Taytaypa wasinpiqami tanapaqqa kusala achka lugarqa kan. Chaymi nuqaqa willashurayllapa, riyani uk lugarta qamkunapaq kamakachiq nirqa. Manaqa mana imatapis willashunayllapatachu. ");
INSERT INTO qufNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Chaynu rir lugarta kamkachirnaqa, qashan tikrakamushaq Taytaypa wasinmanna apashunayllapapaq. Chaynuqami chay maypiĉhi nuqa kayashaypina qamkunapis kankillapa. ");
INSERT INTO qufNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Chaqa qamkunaqami yaĉhankillapana maymanmi riyani nir chaynulla nantapismi riqsinkillapana”. ");
INSERT INTO qufNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Chaynu Jesús nitinmi, Tomasqa niran: —Taytituy, manami yaĉhayanillapachu, maymanmi riyanki nirqa. ¿Imanunari chay nantaqa riqsishaqllapa? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Chaynu Tomás nitinmi, Jesusqa niran: —Nuqami chay nanqa kani. Chaynullami nuqa chay chiqap kaq, chaynulla kawsachikuqpis kani. Chaymi nuqapi kriyishaykillaparaykula Taytaymanqa ĉhayta puytinkillapa. ");
INSERT INTO qufNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nuqata riqsimarqami, Taytaytapis riqsinkillapa. Piru kananmanta-pachami riqsinkillapana. Chaqa rikashaykillapanari nir. ");
INSERT INTO qufNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Chaynu Jesús nitinmi, Felipipis niran: —Taytituy, rikachimayllapa Taytaykitaqa. Chaqa chaynu rikaylatanami ministiyanillapa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesusqa niran: —Felipe, kwichka achka tyimpunami pullaykillapa kani. Ima, ¿manaraqchu riqsimanki? Chaqa mayqanpis nuqata rikamaqqami Taytaytapis rikayanna. ¿Imapaqtaq mañamanki, ‘Taytaykita rikachimay’ nirqa? ");
INSERT INTO qufNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Manachu kriyinki nuqa Taytaywan chaylla kani, Taytaypis nuqawan chaylla nirqa? Chaymi, tukuy willashushayllapataqa, mana nuqa munashaymantachu willashunillapa. Ashwanmi Taytay nuqawan kar, imatapis pay rurachiman. ");
INSERT INTO qufNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kriyimayllapari Taytaywanqa chaylla kani, chaynulla Taytaypis nuqawan chaylla nir. Chaynu mana kriyinarqa, chay rurashaykunalapimapis kriyiyllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Chiqaptami nishaykillapa: Mayqanpis nuqapi kriyiqqami nuqa rurashaykunamatapis ruranqa. Chaynullami ashwan mas ukman shumaqkunata ruranqallapa. Chaqa nuqaqami riyanina Taytay kayashanman. ");
INSERT INTO qufNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Chaymi tukuy imatapis shutiypi mañakutkillapaqa, rurashaq. Chaynuqami, nuqarayku Taytayqa alabakashana kanqa. ");
INSERT INTO qufNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nishushayllapanumi, shutiypi mañakutkillapaqa imatapis rurashaq nir. ");
INSERT INTO qufNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Chaymi qamkuna munamayarqa, mantakushaykunata intrakar kasunkillapa. ");
INSERT INTO qufNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Chaynami nuqaqa Taytay Dyusta mañashaq uk Yanapashuqllapata kaĉhamunanpaq. Chayqami Chiqap Ispiritu kar, maydiyapis pullaykillapa kananpaq. Piru chaytaqami mana kriyiqkunaqa mana aypayta puytinqallapachu. Chaqa manari rikasha chaynulla riqsinllapalamapischu. Nataq qamkuna-shuypaqami riqsinkillapa, qamkunapa pullaykillapa maydiyapis kashanrayku. Chaymi pullaykillapana kanqa. ");
INSERT INTO qufNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Manami askwintallaqa dijashaykillapachu. Ashwanmi tikrakamushaq qamkunawan pulla kanaypaq. ");
INSERT INTO qufNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mananami maychu, chay mana kriyiqkuna, manana rikamananllapapaqqa. Nataq qamkuna-shuypaqami rikamankillapa. Chaynulla nuqa kawsashayraykumi, qamkunapis kawsankillapa. ");
INSERT INTO qufNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Chaynu Taytayman ritiynaqa, kwintata qukankillapa, Taytaywanna kani nir. Chaynulla qamkuna-shuypaqa nuqawan kankillapa nir, chaynulla nuqapis qamkunawan kani nir ima. ");
INSERT INTO qufNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Chaymi mayqanpis mantakushaykunata intrakar kasuqkunaqa, chiqapta nuqata munaman nir intrachikun. Chaynu nuqata munamaqtaqami Taytaypis munanqa. Chaynulla nuqapis munar chiqapta intrachishaq imanumi kani nirmapis”. ");
INSERT INTO qufNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jesús chaynu nitinqa Judas (mana chay Judas Iscariotichu), tapuran kaynu nir: —Taytituy, ¿imapaqtaq nuqakunalata rikachimarllapa, mana tukuy runakunata rikachinkiqa? ");
INSERT INTO qufNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesusqa niran: —Mayqanpis munamaqqami, rimashaykunata allita intrakar kasun. Chaymi Taytayqa munanqa paytaqa. Chaynu katinmi, ishkantiyllapa shamur pullana kawsashaqllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Piru mayqanpis mana munamaqqami, mana kasunchu rimashaykunataqa. Piru willashuyanillapa chayqami mana nuqamantachu. Ashwanmi Taytay willashunayllapapaq nimashanta willashunillapa. ");
INSERT INTO qufNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Tukuy kaykunatami qamkunawan karllaraq willashunillapa. ");
INSERT INTO qufNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Piru Taytay, Santu Ispirituta nuqapa shutiypi yanapashunanllapapaq kaĉhamutin, payna allita intrachishunqallapa, Taytanchik Dyusta chiqapta riqsinaykillapapaqqa. Chaynullami tukuy willashushayllapatapis yarpuchishunqallapa ima. ");
INSERT INTO qufNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Nuqami kusa shumaq kawsaytana dijashunillapa, shumaqtana kawsanaykillapapaq. Piru manami kay pachapi mana allinta yarpuqkuna shumaqta tanillapa nin, chaynuchu nishunillapa. Chaymi ashwan nuqawan kashaykillaparaykuqa ama yarpupakuyllapa chaynulla manchakuyllapalamapischu. ");
INSERT INTO qufNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Chaqa uyapamashaykillapanami, ‘Riyashaqna, piru qashanmi tikrakamushaq qamkunawan kanaypaq’ nitiyqa. Chayrayku, chiqapta munamayarllapaqa, aligriyashaykillapana kanqa Taytayman riyani nir yaĉharqa. Chaqa nuqamantaqami tukuy imapi payqa mas. ");
INSERT INTO qufNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Tukuy kaytaqami willashunillapa, maydiya nishushayllapanulla ima pasatinqa, kriyinaykillapapaqna. ");
INSERT INTO qufNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Mananami qamkunawanqa unaytanachu parlashaq. Chaqa kay pachapi mantakuq nuqamanta mana mas karmapismi, imakunata ruraq qallariyanna. ");
INSERT INTO qufNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Chaynu pasatinmi, tukuyla runakuna kwintata qukanqallapa Taytayta chiqapta munarmi, pay nimashanta imatapis rurani nirqa. “Shariyllapa. Rishunllapana kaymantaqa”. ");
INSERT INTO qufNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesusqami kaynu niran: “Nuqami chiqap uba tarpukashaqa kani. Nataq Taytaymi kuytaq chayqa. ");
INSERT INTO qufNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Chaynu chiqap uba katiymi tukuy nuqapi kriyiqkunaqa nuqapa rikraykunana. Chaymi chay rikraykuna mana puquqtaqa, Taytayqa kuchur itakunqa. Nataq chay puquqkunata-shuypaqa mana shumaqninkunata kuchupar ima kamkachinqa, mastana puqunanpaq. ");
INSERT INTO qufNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nataq qamkunaqami willashushayllapata kasur kawsashaykillaparayku kusa shumaqna kankillapa Dyuspaqqa. ");
INSERT INTO qufNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Chaynu karmi imanutaq nuqa qamkunamanta mana chiqanchakanichu, chaynulla ama nuqamantapis chiqanchakayllapachu. Chaqa uk ubapa rikrankunamaqa tullunmanta pakikasha karqa, mana puquyta puytinchu. Chaynullami qamkunapis mana nuqallawan karqa, mana puquq yupayna mana shumaqnachu kankillapa Dyuspaqqa. ");
INSERT INTO qufNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Nuqami chay chiqap uba tarpukashaqa kani. Nataq qamkuna-shuypaqami rikraykuna kankillapa. Chaymi mayqanpis nuqamanta mana chiqanchakatinqa, nuqapis paykunamanta mana chiqanchakatiychu puquq yupayna kusa shumaqta kawsanqallapa. Chaqa mana nuqawan kaqkunaqami mana imatapis rurayta puytinqallapachu. ");
INSERT INTO qufNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Chaymi mayqanpis mana nuqallawan kaqtaqa, imanutaq qirupa rikrankunamataqa kuchur itakusha chakitin rupachinchik, chaynu ninamanna itakukanqa. ");
INSERT INTO qufNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Piru qamkuna tukuy rimashaykunata kasur, nuqamanta mana chiqanchakar ima ministishaykillapata mañakutkillapapismi Taytayqa qushunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Chaynulla, chaynu puquq yupay kusa shumaqta kawsatkillapaqami Taytayqa kusa alabakashana kanqa. Chaynuqami nuqapa chiqap yaĉhakuyniypaqna riqsikankillapa. ");
INSERT INTO qufNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Chaqa nuqami qamkunataqa kusata munashunillapa, Taytay imanutaq nuqata munamashannulla. Chayraykumi qamkunapis uknikillapa uknikillapa munanakur kawsayllapa, nuqa munashushayllapanulla. ");
INSERT INTO qufNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Chaymi chiqapta nuqata munamarllapaqa, mantakushaykunata intrakar kasuyllapa. Chaqa imanutaq nuqamaqa Taytayta kusata munashayrayku tukuy mantamashanta kasur kawsani chaynulla. ");
INSERT INTO qufNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Chaynuqami nishunillapa kusa shumaqta yarpurna, nuqawan chiqapta aligriyanaykillapapaq. ");
INSERT INTO qufNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Chaynullami mantashaykillapa: Imanutaq nuqa munashushallapa kani, chaynulla qamkunapis uknikillapa uknikillapa munanakuyllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","“Chayraykumi mayqanpis ukninta munashanrayku amigunta washananraykuqa wanuymatapis puytin. ");
INSERT INTO qufNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Chaymi qamkunapis tukuy mantashushayllapata rurarqa kusa munashay amiguykunana kankillapa. ");
INSERT INTO qufNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Chaynu katkillapami manana kananmantaqa sirbimaqniypaqnachu riqsir, amiguykunapaqna riqsishaykillapa. Chaqa uk sirbikuqqami mana yaĉhanchu imata patrunnin ruran nirmapis. Piru qamkunataqami Taytay tukuy imata willamashantapis tantar willashushallapana kani. ");
INSERT INTO qufNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Chaynulla manami qamkunachu nuqataqa akramashaykillapa. Ashwanmi nuqa qamkunata akrar kaĉhashurayllapa rir kusata puquq yupayna maydiyapis kawsanaykillapapaq. Chaynu kar, tukuy imata ministir shutiypi Taytayta mañatkillapaqa qushunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Chaymi qashan mantashaykillapa: Uknikillapa uknikillapa munanakuyllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Nishaykillapapis: Kay pachapi mayqan ĉhiqnishutinllapaqa yaĉhankillapana nuqatami puntataqa ĉhiqnimayan nir. ");
INSERT INTO qufNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Chaqa qamkuna kay pachamanta kaqkunallawan katkillapaqa, kusalata munashuyanmanllapa, imanutaq paykuna munanakunllapa chaynulla. Piru qamkunata paykunamanta akrashushayllaparaykumi ĉhiqnishunllapa. Chaqa manami paykunapanachu kankillapa. ");
INSERT INTO qufNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Chaymi uk kuti nishushayllapata yarpuyllapa. Chaqa kaynumi nishurayllapa: Uk sirbikuqqami mana maschu patrunninmantaqa nir. Chaymi imanutaq nuqapa ikiypi puriranllapa mana allinta ruramananllapapaq, chaynullami qamkunatapis rurashunqallapa. Chaqa nuqa rimashaykunata kasuyarllapaqa, qamkuna nishaykillapatapis kasunmanllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Chaynumi rurashunqallapa nuqarayku. Chaqa paykunaqami mana riqsinllapachu kaĉhamasha chaytaqa. ");
INSERT INTO qufNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Paykunaqami nuqa mana shamur willasha katiyqa mana uchayjunchu kanmanllapa. Piru shamur willatiy mana kasukushanllaparaykumi kusala uchayjunna. Chaymi manana pirdunakanqalamapischu. ");
INSERT INTO qufNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Chaqa mayqanpis nuqata ĉhiqnimaqqami Taytaytapis ĉhiqniyanllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Chaynulla nuqa paykunapa naypanpi mana mayqanpis rurashanllapata rurasha katiyqami mana ima uchayjunlamapischu kanmanllapa. Piru tukuy imakunata paykunapa naypanpi rurasha katiymapis, ĉhiqnimanllapa, chaynulla Taytaytapis ĉhiqninllapa ima. ");
INSERT INTO qufNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Tukuy kaykunaqami chaynuqa pasayan, Dyus nitin Moisés iskribikashankuna kumplikananpaq. Chaqa niqmi: ‘Yanqa illaqmantami ĉhiqnimanllapa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Piru Taytaymanta Chiqap Ispiritu Yanapakuqta kaĉhamutiymi nuqapaq intrachikunqa uk tistigu yupayna mayqanmi kani nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Chaynullami qamkunapis nuqapaqqa tistiguykuna kankillapa. Chaqa qamkunaqami puntamanta-pacha pullay kashaykillapa. ");
INSERT INTO qufNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Tukuy kaykunatami willashunillapa, nuqapi kriyishaykillapamanta ama chiqanchakanaykillapapaq. ");
INSERT INTO qufNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Chaqa chay tantakananllapa wasikunamantami itakushunqallapa. Chaynullami uk tyimpu ĉhamunqa. Chaymi chay tyimpupiqa wanuchishurllapa, yarpunqallapa Dyuspaqqami kusa allinta rurayanchikllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Chaynuqami tukunqallapa Taytayta chaynulla nuqatapis mana riqsimashanllaparayku. ");
INSERT INTO qufNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Tukuy kaykunataqami chaynuqa nishunillapa, chaynu pasananpaq ura ĉhamutinqa, tukuy chay willashushayllapata yarpunaykillapapaq. “Piru tukuy kaykunataqami qamkunallawan kashayrayku mana naypaqllataqa willashurayllapachu. ");
INSERT INTO qufNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Nataq kananqami riyanina mayqanĉhi kaĉhamasha karan paywan pullana kanaypaq. Piru chaynu nishutiyllapaqa manami mayqannikillapapis tapumankillapachu ¿maymantaq riyanki? nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ashwanmi, chay willashushayllapapaq yarpur, kusa llakishalana tikrakashaykillapa. ");
INSERT INTO qufNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Piru chiqaptami nishaykillapa: Chaynu rinaypaqna katiymapis aligriyayllapa. Chaqa nuqa ritiymi Yanapakuq Ispirituqa shamunqa manaqa mana. Nataq nuqa rirqami kaĉhamushaq. ");
INSERT INTO qufNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Chaynu Yanapakuq Ispiritu shamurmi, tukuy mana kriyiqkunata allita rikachinqa uchayjunmi kankillapa nir. Chaynulla intrachikunqa Dyusqami mana ima uchayjunlamapischu nir. Chaynu karmi tukuyta allita rikar yaĉhashunqallapa nir ima intrachikunqa. ");
INSERT INTO qufNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Chaymi yaĉhankillapa, tukuy nuqapi mana kriyiqkunaqami kusala uchayjun nir. ");
INSERT INTO qufNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Chaynulla yaĉhankillapapis nuqaqami mana ima uchayjunlamapischu kani nir. Chaymi ashwan riyanina Taytayman, chaynulla mananami rikamankillapanachu. ");
INSERT INTO qufNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Chaynullami yaĉhankillapapis, kay pachapi mantakuq dyablutaqa, Tayta Dyus kastigakananpaq nishantaqami, allita rikar yaĉhar tukuy tyimpupaqna kastigayanqa nir ima. ");
INSERT INTO qufNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Chaynu nir ima willashunayllapapaqmi kusa achka kan. Piru kananlla willashutiyllapaqami mana intrakankillapachu. ");
INSERT INTO qufNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Chaymi Chiqapta intrachikuq Ispiritu shamur tukuy imatapis karanlata intrachishunqallapa. Chaqa payqa manami munashanllamantachu willashunqallapa. Ashwanmi tukuy imata Dyusmanta uyapashanta ima willar intrachishunqallapa. Chaynullami willashunqallapapis, imakunami maydiyaqa pasanqa nir ima. ");
INSERT INTO qufNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Payqami nuqamanta uyashantana allita intrachishutinllapa, alabamanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Chaqa Taytay Dyus yaĉhashantami nuqapis yaĉhani. Chayraykumi nishurayllapa: Ispirituqami nuqamanta uyashanta allita qamkunataqa intrachishunqallapa nirqa”. ");
INSERT INTO qufNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jesusqami niranpis: “Mananami maychu manana rikamanaykillapapaqqa. Chaqa Taytaymanmi riyanina. Piru unaykaqmantaqami rikamankillapana” nir. ");
INSERT INTO qufNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Chaynu nitinmi, wakin yaĉhakuqninkunaqa paykunapura kaynu tapunakuqllapa: “¿Ima nishaq nirtaq, chaynuqa nimanchikllapa? Chaqa nimanchikllapami, mananashi maychu Taytanman ritin manana rikanallapapaqqa. Chaymanta unaykaqmantashi rikayashunllapana nir. ");
INSERT INTO qufNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Chaynulla, ¿ima nishaq nirtaq nin, ‘Mananami maychu’ nirqa? Manami intrakanchikllapachu imata rimayan nirmapis”. ");
INSERT INTO qufNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Piru Jesusqami kwintata qukaran, tapunayanllapa nir. Chaymi niran: —Qamkunatami nishaykillapa: Manana maychu qamkuna manana rikamanaykillapapaqqa. Piru unaykaqmantami rikamankillapana nir. ¿Chaynu nishaypaqchu tapunakuyankillapa? ");
INSERT INTO qufNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Piru chiqapta nishaykillapa: Qamkunaqami llakir waqankillapa ima nuqa dijashutiyllapaqa. Nataq nuqapi mana kriyiqkuna-shuypaqami kusalata aligriyanqallapa. Piru qamkuna chaynu llakishaykillapamantaqa ashwan mastana aligriyankillapa. ");
INSERT INTO qufNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Imanutaq uk warmimaqa, kusata nanachikun wamrakustunanpaq nanaynin aypatinqa. Piru wamritun nasikutinnaqami nanachikushanmatapis qunqanna. Chaymi ashwan kusata aligriyan, wamrakushanrayku. ");
INSERT INTO qufNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Chaynumi qamkunapis kananqa kusata llakinkillapa. Piru nuqa tikrakamur rikashutiyllapami, shunquykillapapi kusa shumaqta yarpurna aligriyankillapa. Chaymi chay aligriyashaykillapamantaqa manana mayqanpis llakichishunqallapanachu. ");
INSERT INTO qufNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Chaqa chay diyakunapiqami manana imatapis tapumankillapanachu. Piru chiqaptami nishaykillapa: Ima ministishaykillapatapis shutiypi, Taytayta mañakutkillapa payqa qushunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kanankamanmi manaraq imatapis shutiypiqa Taytaymanqa mañakushaykillapachu. Mañakuyllapa, pay yanapashutinllapa tukuy shunquykillapawan aligriyanaykillapapaq. ");
INSERT INTO qufNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Tukuy kaykunatami, kumparasyunkunawan willashushallapa kani. Piru ĉhamunqanami uraqa manana kumparasyunkunawannachu willashunayllapapaq. Ashwanmi Taytaypaqqa imatapis kusa intrakaypaqtana willashaykillapa. ");
INSERT INTO qufNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Chaymi chay diyapiqa, imakunatapis shutiypina Taytaytaqa mañakunkillapa. Chaypiqami mana nuqanachu qamkunapaqqa Taytaymanqa mañakushaq. ");
INSERT INTO qufNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Chaqa Taytaymi kusalata munashunllapa, qamkuna nuqata munamashaykillaparayku, chaynulla paymanta nuqaqa shamusha kani nir kriyishaykillaparayku ima. ");
INSERT INTO qufNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Taytaypa naypanmantami shamuray kay pachaman. Nataq kanan-shuypaqa kay pachata dijanina, Taytay kayashanman tikrakanaypaq”. ");
INSERT INTO qufNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Chaynu Jesús nitinqa, yaĉhakuqninkunaqa niran: —Kanan-shuypaqami kusa intrakaypaqtana rimayanki, mana kumparasyunkunawannachu. ");
INSERT INTO qufNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Chaymi kananqa yaĉhanillapana tukuy imatapis yaĉhanki nir. Chayraykumi manana tapushunayllapamatapis ministinkinachu. Chaynu katkimi, kriyinillapana chiqaptami Dyusmanta shamushayki nir. ");
INSERT INTO qufNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesusqa niran: —¿Chayqachu kananqa kriyimankillapana? ");
INSERT INTO qufNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Chaqa ura ĉhamunanpaq karan chayqami ĉhamushana. Chaymi qamkunaqa wakta kayta shikwakar rir, nuqalatana dijamankillapa. Piru manami nuqalachu kashaq, Taytay pullay kashanrayku. ");
INSERT INTO qufNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Tukuy kaykunatami willashunillapa, nuqapi maydiyapis kriyirlla kusa shumaqtana kawsanaykillapapaq. Chaqa, kay pachapiqami kusalata qischashunqallapa. Piru kusata animakurmi shachinakunkillapa. Chaqa nuqami tukuy mana allin kaqkunataqa binsishana kani. ");
INSERT INTO qufNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Tukuy kaykunata nirnaqami, Jesusqa syiluman chapakur kaynu nir mañakuran: “Taytay, qischakar wanunaypaq uraqami ĉhamushana. Chaymi, runakunata intrachiy, imaraykumi wanuyani nir intrakar alabamananllapapaq. Chaynuqami ashwan qamtapis alabashunqallapana. ");
INSERT INTO qufNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Chaqa qammi Wamraykitaqa nishayki, tukuylata mantar qampa kaqkunataqa washar, tukuy tyimpupaq kawsachinanpaq. ");
INSERT INTO qufNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Chaymi mayqanpis qamta uklayla chiqap Dyus kanki nir riqsishuqkuna, chaynulla Jesucristuta kaĉhamushaykipi kriyiqkunalami tukuy tyimpupaqqa kawsanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Tukuy imata ruranaypaq nimashaykita kay pachapi rurar tukchishayraykumi, runakuna qamtaqa kusata alabashunllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Chayraykumi Taytituy kanan-shuypaqa kay pachamapis manaraq kayatinchu kusa shumaq pudirninchikwan mantakuqninchik, chaynulla kanaypaqna tikramay. ");
INSERT INTO qufNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Chaqa qampa shutikitami, chay mana kriyiqkunamanta akrar qumashaykikunata riqsichisha kani. Paykunataqami, qampa kashanrayku qumarayki. Chaymi rimanaykita intrachishayrayku kasurna kawsanllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Chaymi kananqa paykunaqa intrakanllapana, tukuy imatapis qamrayku rurani nir. ");
INSERT INTO qufNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Chaqa rimanaykita paykunata yaĉhachinaypaq nimashaykita yaĉhachitiymi, kasushallapa. Chaynullami paykunaqa kriyishallapa, nuqataqa chiqapta qam kaĉhamatki shamusha kani nir ima. ");
INSERT INTO qufNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Chayraykumi tukuy chay qampa kaqkunata qumashaykipaq mañakuni. Chaqa qammi paykunataqa qumarayki. Piru chay mana kriyiq kaqkunapaq-shuypaqa manami mañakunichu. ");
INSERT INTO qufNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tukuy nuqapa kaqkunaqami qampa. Chaynulla tukuy qampa kaqkunapis nuqapa. Chaymi tukuy nuqapa kaqniykunaqa, rikar imanumi kusala pudirniyjun ima kani nir alabamanllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Nuqami kay pachamantaqa, qammanna shamuyani Taytay. Nataq paykunaqami kay pachallapiraq kidanqallapa. Chayraykumi kusa allinla Taytay, shutikipi mañakushayki, allita kuytapamatki amana nuqamanta chiqanchakananllapapaq. Chaynuqami nuqawanqa pullalana kanqallapa, imanutaq qamwan nuqamaqa pullala kanchik chaynu. ");
INSERT INTO qufNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Chaqa nuqa kay pachallapi paykunawan karqami, qam pudirnikita qumashaykiwan kuytaray ima tukuy mana allinkunamanta. Nataq iskribikashannulla kumplikananpaqmi, dyablu munashannu rurar ukla chinqaran. Piru paymantaqami mana masqa chinqashallapanachu. ");
INSERT INTO qufNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Kanan-shuypaqami shamuyanina Taytay chay maypiĉhi kayashaykiman. Piru paykunataqami kay pachapi mana kriyiqkunawan karlla intrachini nuqa aligriyashaynulla kusalata aligriyananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nuqa rimaynikita yaĉhachitiy kasushanllaparaykumi, mana kriyiqkunaqa paykunata ĉhiqninllapa. Chaqa rimaynikita kasuqkunaqami nuqa yupayna, mana chay mana kriyiqkuna yupaynachu. ");
INSERT INTO qufNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Piru chaynu nishurqa, manami mañashuyanichu, kay pachapi mana kriyiqkunamanta chiqanchanaykipaq nirchu. Ashwan mañashuni kuytanaykipaq tukuy mana allin kaqkunamanta. ");
INSERT INTO qufNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Chaqa imanutaq nuqamaqa mana, kay pachapi mana kriyiqkunapa kaqninchu kani, chaynullami paykunapis. ");
INSERT INTO qufNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Chayraykumi paykunataqa chiqap kaqlawan shumaqchay. Chaqa rimaynikiqami kusala chiqap. ");
INSERT INTO qufNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Paykunatami mana kriyiqkunapa rurinta kaĉhayani, imanutaq nuqata qam kaĉhamarayki chaynulla. ");
INSERT INTO qufNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nuqami qam munashaykinulla paykunapaq wanushayrayku kusala shumaqpaqna riqsimanki. Chaynullami paykunapis chiqap rimayniki nishannula rurarna, shumaqchakanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Manami paykunalapaqchu mañashuni. Ashwanmi paykuna yaĉhachikutin kriyiyanqallapa chay paykunapaqpis mañashuni. ");
INSERT INTO qufNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Chaynullami Taytay mañashunipis tukuy nuqapi kriyiqkunaqa uklana kananllapapaq. Chaqa imanutaq qam nuqawanmaqa ukla kanchik chaynu, nuqanchikwan tantalana kananllapapaq. Chaynu katin, mana kriyiqkuna rikarqami allitana kriyinqallapa, qammi nuqata kaĉhamashayki nir. ");
INSERT INTO qufNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Chaqa imanuĉhi kusa pudirniyjun kashayrayku alabamananllapapaq nimarayki, chaynu kananpaqmi paykunatapis nisha kani, uklana kananllapapaq. Imanutaq qamwan, nuqamaqa uklana kanchik chaynulla. ");
INSERT INTO qufNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Chaynu qam nuqawan karmi kusata yanapamanki. Chaynullami nuqapis paykunataqa yanapashaq, ukninllapa ukninllapa yanapanakur, uklana kawsananllapapaq. Chaynu katinllapami chay mana kriyiqkunaqa kwintata qukanqallapa, qammi nuqataqa kaĉhamashayki, chaynulla paykunataqa kusata munanki nuqata yupaylla nir. ");
INSERT INTO qufNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Taytay, qammi qumarayki akrashaykikunataqa. Chaymi munani paykunapis chay maypiĉhi kayashaypiqa pullay kananllapata. Chaynu pullay karmi qamrayku kusa pudirniyjun kani nir yaĉhar alabamanqallapa. Chaqa qammi, pachamapis manaraq kayatinchu munamashaykillana kasha. ");
INSERT INTO qufNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Imatapis karanlata rikaq Taytay, mana kriyiqkunaqami mana riqsishunllapachu. Piru nuqa-shuypaqami riqsishuni. Chaynullami tukuy kriyiqkunapis yaĉhanllapa, qam nuqataqa kaĉhamashayki nir. ");
INSERT INTO qufNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Chaymi paykunataqa riqsichisha kani, imanu kanki nirmapis. Chaynullami masta qampaq intrachishaq munanakur kawsananllapapaq imanuĉhi nuqata munamanki chaynulla. Chaynu katinllapami nuqaqa paykunapina kashaq maydiyapis”. ");
INSERT INTO qufNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Chaymanta chaynu nirnaqa, Jesusqa riran yaĉhakuqninkunawan Cedrón raqrapa chimpanman. Chaypi wirta katinmi, chayman Jesusqa yaykuran yaĉhakuqninkunawanqa. ");
INSERT INTO qufNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Chaynullami chay Judas, Jesusta kuntrankunaman qukunanpaq karan chaypis, riqsiq chay wirtataqa. Chaqa Jesusqami achka kuti chaymanqa yaĉhakuqninkunawan risha kayaq. ");
INSERT INTO qufNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Chaynu chay lugarta riqsiq karmi, Judasqa achka suldadukunawan, Dyusta adurananllapa wasita wakin kuytaqkunawan ima, ĉharanllapa. Paykunataqami kurakunapa mantaqninkuna, fariseukuna ima kaĉhamutin, ĉhamuranllapa lamparakunawan, anturchakunawan, chaynulla ispadakunawan ima alli kamakasha. ");
INSERT INTO qufNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Piru Jesusqami tukuy ima pasayan nir yaĉhashanrayku, lluqshir rir kaynu nir tapuran: —¿Mayqantataq maskayankillapa? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","6","Paykunaqa niran: —Nazaretmanta Jesusta nir. Jesusqa niran: —Nuqami kani. Chaynu Jesús “Nuqami kani” nitinqa, ikiman tukushaq nir tukuynin pachaman rataranllapa. Judaspismi chaypi pullanllapa karan. ");
INSERT INTO qufNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Chaymantaqa qashan Jesusqa tapuran kaynu nir: —¿Mayqantataq maskayankillapa? nir. Paykunaqa qashan niran: —Nazaretmanta Jesusta nir. ");
INSERT INTO qufNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Chaynu nitinllapaqa, qashan Jesusqa niran: —Nuqami kani nir willashushallapana kani. Nuqata maskamayarllapaqa, yaĉhakuqniykunataqa dijayllapa rinqa. ");
INSERT INTO qufNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Chaynuqami Jesusqa niran “Taytay chay qumashaykikunaqami, mana uklamapis nuqamantaqa chiqanchakashachu” nishan kumplikananpaq. ");
INSERT INTO qufNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Chaymantaqa Jesuspa yaĉhakuqnin Simón Pedruqa, uk ispadata lluqshichimur, kurakunapa mantaqninta sirbiq runapa allilaw rinrinta ¡saq! pitiran. Chay sirbikuqqami Malco shutiq. ");
INSERT INTO qufNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Chayta Pedro ruratin rikarmi, Jesusqa niran: —Ispadaykita ĉhuray tananman. Chaqa ¿manachu chay ayaq yaku yupay qischakanaypaq Taytay nishantaqa puytiyashaq rurayta? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Chaymantaqa chay suldadukuna, mantaqninwan, chaynulla Dyusta adurananllapa wasita kuytaqkuna ima Jesustaqa aypar wataranllapana. ");
INSERT INTO qufNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Chaymi puntataqa aparanllapa Caifaspa swigrun Anaspa wasinman. Chay añupiqami Caifasqa kurakunapa punta mantaqnin karan. ");
INSERT INTO qufNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kay Caifasmi Israelmanta runakunataqa kaynu nisha kayaq: “Uk runalami wanunanpaq allin kanqa tukuypaq” nir. ");
INSERT INTO qufNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedrumi, uk yaĉhakuq masinwan Jesuspa ikinta riyaranllapa. Pedrupa yaĉhakuq masinqami, kurakunapa mantakuqninpaqa riqsinan karan. Chaymi Jesuswan pulla yaykuran chay wasipa pampankaman. ");
INSERT INTO qufNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Nataq Pedro-shuypaqa waqta punkulapi kidaran. Chaymi Jesuspa yaĉhakuqnin kurakunapa mantaqninpa riqsinan kaqqa, punkupi warmi kuytakuqtaqa willar Pedrutapis ruriman yaykuchiran. ");
INSERT INTO qufNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Chaymantaqa chay punkupi kuytakuq warmiqa, Pedrutaqa kaynu nir tapuran: —¿Manachu qampis wak runapa uk yaĉhakuqnin kanki? nir. Pedruqa niran: —Manami nir. ");
INSERT INTO qufNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Piru kusata qasayatinmi, chay sirbikuqkuna, Dyusta adurananllapa wasita kuytakuqkunaqa ninata kachkasha quñukur shayaranllapa. Pedrupismi paykunawan pulla chaypi quñukur shayaran. ");
INSERT INTO qufNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kurakunapa mantaqninqa qallariranna Jesusta tapuq yaĉhakuqninkunapaq, imakunata yaĉhachikushanpaq ima. ");
INSERT INTO qufNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Taputinqa, Jesusqa niran: —Nuqaqa tukuypa naypanpi rimasha kani. Maydiyapismi tantakananllapa wasikunapi, chaynulla Dyusta adurananllapa wasipi, chay maypiĉhi Israelmanta tukuy runakuna tantakanllapa chaykunapi yaĉhachikusha kani. Chaynuqami mana imatapis pakapllaqa yaĉhachikushachu kani. ");
INSERT INTO qufNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Chaynu katinqa, ¿imapaqtaq tapumayanki? Tapuy uyakumasha chaykunata. Paykunami yaĉhanllapa nuqa rimashaykunataqa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Chaynu Jesús nitinmi, Dyusta adurananllapa wasita kuytaqkunamanta ukqa qaqllanpi maqaran Jesustaqa, kaynu nir: —¿Kurakunapa mantaqnintachu waknu willanki? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Chaymi Jesusqa niran: —Mana allinta rimasha katiyqa willamay-ari imatami mana allinta rimasha kani nirmapis. Piru allinta rimasha katiyqa ¿imapaqtaq maqamanki? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Chaymantami Anasqa Jesustaqa watakashallata kaĉharan, kurakunapa punta mantaqnin Caifasmanna. ");
INSERT INTO qufNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Chaykamanqa, Pedruqa ninapa yatalanpi shasha quñukuyaran. Chaymi tapuranllapa: —¿Manachu chiqapta wak runapa uk yaĉhakuqnin kanki? nir. Pedruqa niran: —Manami nir. ");
INSERT INTO qufNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Chaypimi karan kurakunapa mantaqninpa uk sirbikuqninpis. Payqami, Pedro uk sirbikuqpa rinrinta pitisha karan chaypaqa ayllun karan. Chaymi paypis tapuran Pedrutaqa kaynu nir: —¿Manachu paywan rikashuray wak wirtapi? ");
INSERT INTO qufNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Chaynu nir taputinmapis, Pedruqa qashan, “Manami riqsinichu” nitinlami galluqa kantaranna. ");
INSERT INTO qufNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Piru limpu achkiyayatinnaqami, Jesustaqa Caifaspa wasinmantaqa, aparanllapa Romamanta mantakuq Pilatupa mantakuna wasinman. Piru Israelmanta karguyjunkunaqa mana yaykuranllapachu chay wasimanqa. Chaqa paykunaqami yarpuqllapa: Chayman yaykurqashi mantakuykuna nishannulla manana Dyuspaqqa shumaqnachu kayanqallapa nir. Chaynulla mananashi Pascua mikunamatapis mikuyta puytiyanqallapanachu nir. ");
INSERT INTO qufNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Chaynu Jesusta ĉhachitinllapanaqa, Pilatuqa waqtaman lluqshimur niran: —¿Imamantataq kay runataqa uchachayankillapa? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Paykunaqa niranllapa: —Kay runa allin katinqa, qammanqa mana apamunayllapatachu nir. ");
INSERT INTO qufNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatuqa niran: —Chaynu katinqa, apar liynikillapa nishannulla kay runataqa rikar yaĉhayllapa nir. Chaynu nitinmi, Israelmanta karguyjunkunaqa niran: —Nuqakunaqami mana dirichuyjunchu kanillapa mayqantapis wanuchinayllapapaqqa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Chaynumiri kumplikaran, Jesús imanumi wanushaq nir payllapaq rimashanqa. ");
INSERT INTO qufNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Chaymantami Pilatuqa qashan mantakunan wasinman yaykur, Jesustaqa qayar kaynu nir tapuran: —¿Qamchu Israel runakunapa mantaqnin kanki? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesusqa niran: —¿Qampa yarpuynikillamantachu tapumanki, manaqachu ukkuna willashusha katin? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Jesús chaynu nitinqa, Pilatuqa niran: —¿Nuqachu Israelmanta runa kani? Chaqa qampa nasyunnikimanta runakuna, chaynulla kurakunapa mantaqninkunami qamtaqa nuqamanqa apamushushallapa. Ma willamay, ¿imatataq rurashayki? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesusqa niran: —Nuqapa mantakunayqami mana kay pachamantachu. Chaqa chaynu katinqami, nuqapa kaqniykuna maqanakunmanllapa ama Israelmanta karguyjunkunaman qukumananllapapaq. Piru mantakuyniyqami mana kaymantachu nir. ");
INSERT INTO qufNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Chaymantaqa Pilatuqa tapuran: —Chaynu karqa, ¿chiqaptachu qamqa uk mantakuq kanki? nir. Jesusqa niran: —Qamllami nimanki, mantakuq kani nirqa. Nuqami kay pachaman shamur nasiray tukuy runakunata willanaypaq chay chiqap kaqpaq. Chaymi chiqap kaqpaq rimatiy intrakaqkunaqa, uyamanllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Chaynu nitinqa, Pilatuqa niran: —¿Imataq chay chiqap kaqqa? nir. Chaynu Jesusta tapurnaqa, Pilatuqa qashan lluqshimuran, chay Israelmanta karguyjunkunata kaynu nir willaq: —Nuqapaqqami kay runaqa mana ima uchayjunlamapischu. ");
INSERT INTO qufNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Piru qamkunapa kustumrikillapami kan, kada Pascua fyistapi qamkuna nishaykillapanulla uk prisuta kaĉhanaypaq. Chaynu katinmi, ¿munankillapachu kay Israel runakunapa mantaqninta kaĉhanaypaq? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Chaynu Pilato nitinqa, tukuyninllapa qashan kaynu niranllapa: —¡Ama chaytaqa kaĉharchu, ashwan Barrabasta kaĉhay! nir. Kay Barrabasqami kusala suwakuq runa karan. ");
INSERT INTO qufNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Chaymantaqami, Pilatuqa kaĉhakuran, Jesusta kusata llibachinanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Chaymi suldadukunaqa kashamanta rurakasha kurunata Jesustaqa umachiranllapa. Chaynulla uk chupika murada raĉhpata yakachiranllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Chaymantami kushipananllaparayku tukuynin qimikar kaynu niranllapa: —¡Biba Israel pwiblupa gubyirnun! nir. Chaynu nir imaqami, qaqllitanpi maqaqllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Chaynami, Pilatuqa qashanpis mantakunanmanta yarqamur niran: —Rikayllapa. Nuqaqami paytaqa yarqachimusha kani rikar kwintata qukanaykillapapaq, nuqapaqqa kay runaqa mana ima uchayjunlamapischu nir. ");
INSERT INTO qufNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Chaymantaqami Jesusqa yarqamuran, kashamanta rurakasha kurunata umakusha, chupika murada raĉhpata yakakusha ima. Chaymi Pilatuqa niran: —¡Kaypimi kay runaqa! nir. ");
INSERT INTO qufNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Chaynu nitinqa, kurakunapa mantaqninkuna, Dyusta adurananllapa wasita kuytaqkunaqa niranllapa: —¡Kruspi klabay! ¡Kruspi klabay! nir. Piru Pilatuqa paykunataqa niran: —Chaqa, qamkuna apar kruspiqa klabayllapamapis. Nuqapaq-shuypaqa, kay runaqa mana ima uchayjunlamapischu nir. ");
INSERT INTO qufNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Chaynu Pilato nitinqa, Israelmanta karguyjunkunaqa niranllapa: —Nuqakunapaqami uk liyniyllapa kan. Chaymi, chay liyniyllapa nishannuqa, kay runaqa allin wanunanpaq. Chaqa payqa ‘Dyuspa Wamran kani’ nisha. ");
INSERT INTO qufNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Chaynu nitinllapaqa llallin Pilatuqa kusata manchakuran. ");
INSERT INTO qufNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Chaymi qashan mantakunanman yaykur, tapuran Jesustaqa kaynu nir: —¿Maymantataq qamqa kanki? nir. Piru Jesusqami, mana imatapis willaranchu. ");
INSERT INTO qufNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Chaymi Pilatuqa qashan niran: —¿Manachu imatapis willamayanki? ¿Manachu yaĉhanki, nuqa washashuyta puytini? nir. Manaqapis ¿mantakutiy kruspi klabashuyta puytinllapa nirqa? ");
INSERT INTO qufNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesusqa niran: —Tayta Dyus, mana munasha katinqa, manami imatapis ruramayta puytinkimanchu. Piru mayqanĉhi nuqata qamman qukumasha chaymi mas uchayjunqa qammantaqa. ");
INSERT INTO qufNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Chaynu Jesús nitinmi, Pilatuqa chay kutilla kaĉhayta yarpuran imanullapis. Piru chay Israelmanta karguyjunkunaqa kusata lanyaranllapa, kaynu nir: —¡Chay runata kaĉharqa, Romapa punta mantaqnin Cesarpaqa mana amigunchu kanki! ¡Mayqanpis mantakuq paylla tikrakarqa, mantakuq Cesarpaqa kuntran! nir. ");
INSERT INTO qufNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Chaynu nitinllapa Pilato uyaparqa, Jesustaqa tukuypa naypanman lluqshichimur, payqa mantakunanpina taran. Chay mantakunan lugarqami shutiq “Rumi Llutakasha Pampa”. Nataq hebreo rimaypi-shuypaqa “Gabata” nir. ");
INSERT INTO qufNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Chaypimi uk diyalana Pascua fyistapaq faltayatin, alas dusi yupayna karan. Chaymi Pilatuqa niran: —¡Kaypimi mantakuqnikillapaqa! nir. ");
INSERT INTO qufNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Piru paykunaqami ashwan kusata laqyaranllapa kaynu nir: —¡Wanunqa! ¡Wanunqa! ¡Kruspi klabay! nir ima. Chaynu nitinllapa, Pilatuqa tapuran paykunataqa kaynu nir: —¿Mantakuqnikillapatachu nuqaqa kruspi klabayashaq? Chaynu nitinqami, chay kurakunapa mantaqninkunaqa niranllapa: —¡Nuqakunapaqa, Cesarla mantakuqniyllapaqa! ¡Manami chiqan mantakuqniyjunchu kanillapa! nir. ");
INSERT INTO qufNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Chaynu nitinllapami, Pilatuqa Jesustaqa paykunatana quran. Chaymi Jesustaqa aparanllapana kruspi klabaq. ");
INSERT INTO qufNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesusqa kayashanmantaqa krusninta rikrakur riran, Calavera shutiq lugarmanqa. (Hebreo rimaypiqa chay lugartaqa ninllapa Gólgota nir.) ");
INSERT INTO qufNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Chay lugarpimi Jesustaqa klabaranllapa ishkay runawan pullata krusllapi, ukninta Jesuspa allilaw qichqanpi, ukninta ichuqlaw qichqanpi. ");
INSERT INTO qufNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Kruspi klabatinllapanaqa Pilatuqa kaĉhakuran, uk litriru kaynu niqta ĉhurananllapapaq: “NAZARETMANTA JESÚS, ISRAEL RUNAKUNAPA MANTAQNIN” nir. ");
INSERT INTO qufNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Chaymi chay litrirutaqa Israelmanta achka runakuna liyiranllapa. Chaqa Jerusalén pwiblupaqa shipchanlapi karan. Chay litriruqami iskribikasha karan hebreo rimaypi, latin rimaypi, griego rimaypi ima. ");
INSERT INTO qufNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Chaymi Israelmanta kurakunapa mantaqninkunaqa niranllapa Pilatutaqa. —Ama iskribiychu ‘Israel runakunapa mantaqnin’ niqtaqa. Ashwan iskribiy kaynuta: ‘Israel runakunapa mantaqnin tukuq’ niqta. ");
INSERT INTO qufNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Piru Pilatuqa niran: —¡Chaynu iskribirqami, iskribishana kani! nir. ");
INSERT INTO qufNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Chaymanta suldadukuna Jesusta kruspi klabarllapanaqa raĉhpantaqa kwatru partipaq pitir, uk parti kada unu aypakuranllapa. Piru chay atun raĉhpa qatakunantaqa mana siranayjun katinmi, mana imanupis partinakuyta puytiranllapachu. Chaqa uk kwirpuyjunlami karan. ");
INSERT INTO qufNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Chaynu katinmi suldadukunaqa, kaynu niranllapa: —Ama llikirchu surtyakushunllapa, mabir mayqanninchikllapashi aypashunllapa nir. Chaynu ruratinllapami Dyus nitin iskribikashanqa kumplikaran. Chaqa niqmi: “Raĉhpaytami paykunalla ayparanllapa. Nataq qatakuna raĉhpayta-shuypaqa surtyakur ayparanllapa” nir. Chaymi chaynulla suldadukunaqa ruraranllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesús klabakashanpa yatanpiqa karanllapa Jesuspa maman María, Jesuspa mamanpa irmanan, Cleofaspa warmin María, chaynulla María Magdalena ima. ");
INSERT INTO qufNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Chaymanta Jesús mamanta rikar, chay kusa munashan yaĉhakuqnin mamanpa pullan shaqta rikarqa, mamantaqa niran: —Mamitay, chaypimi wamraykiqa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Chaynu mamanta nirqa, yaĉhakuqnintapis niran: —Chaypimi mamayki nir. Jesús chaynu nishanmanta-pachami, chay yaĉhakuqninqa Jesuspa mamantaqa payna rikaran, kuytaran imamapis. ");
INSERT INTO qufNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Chaymantami, Jesusqa tukuy imapis kumplikashana nir yaĉhashanrayku kaynu niran: —Yakunayani nir. Chaynuqami niran, Dyus nitin iskribikashapi nishan kumplikananpaq. ");
INSERT INTO qufNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Chaynu nitinmi, puqyala raĉhpitata isupu qirupi watar, puchqu binu uk jarrupi tayatin nuyuchir, Jesuspa shiminmanqa qimiranllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Chaymi Jesusqa puchqu binuta kamarnaqa niran: —Tukuymi kumplikashana nir. Chaynu nirqa, pukĉhirar wanuranna. ");
INSERT INTO qufNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Samana diyapi Pascua fyista qallarinanpaq katinqami, chay Israelmanta karguyjunkunaqa mana munaranllapachu, chay kruspi klabaraqkunapa kwirpun krusllapi kanantaqa. Chaqa Pascua fyistaqami kusala shumaq fyista karan. Chayrayku Pilatuta rugaranllapa kaĉhakutin rir chay kruspi klabaraqkunapa ĉhankanta pakitinllapa dasna wanutin, kwirpunta ashuchinanllapapaq nir. ");
INSERT INTO qufNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Chaymi kaĉhakutinllapa, suldadukunaqa rir, Jesuspa qichqanpi uk klabaraqpa ĉhankantaqa pakiran. Chaynulla chay uk qichqanpi kaqpatapis. ");
INSERT INTO qufNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Piru Jesuspa ĉhankanta pakinanpaq qimikayatinllapa-shuypaqa, wanushana karan. Chaymi ĉhankantaqa manana pakiranllapanachu. ");
INSERT INTO qufNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Piru ashwan chay suldadukunapa ukninqa rir atun puntayjun jyirruwan Jesuspa kustillanta uĉhkuran. Chaymi chay kutilla, yawarwan yaku Jesuspa kwirpunmantaqa yarqamuran. ");
INSERT INTO qufNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Kaytaqami uk rikasha chay parlakun. Chaymi chiqapta riman. Chaynulla yaĉhanpis chiqapta rimayan nir. Chaynu rimatinmi, qamkunapis kriyinaykillapapaq. ");
INSERT INTO qufNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Chaqa tukuy kaykunaqami chaynuqa pasaran Dyus nitin iskribikashankuna kumplikananpaq. Chaqa niqmi: “Manami uk tullunlamatapis pakinqallapachu” nir. ");
INSERT INTO qufNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Chaynullami uk iskribikashakunapipis niq: “Rikakunqallapami uĉhkushanllapamatapis” nir. ");
INSERT INTO qufNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Chaymantaqami Arimateamanta Josiqa, Pilatuta rugaran Jesuspa kwirpunta qutin apar pampananpaq. Josiqami, Jesuspa yaĉhakuqninna karan. Piru chay Israelmanta karguyjunkunata manchashanraykumi, upallala puriq, mana imatapis rimarchu. Chaymi Pilato apar pampay nitinqa, Josiqa rir, Jesuspa kwirpuntaqa aparanna pampaq. ");
INSERT INTO qufNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Chaynullami Nicodemupis ĉhamuran, trinta kiluta yupay kusa mishki mutkiypaqla rimidyitukuna mirrawan, aluwita apar. Paymi unaylla uk tuta risha kayaq Jesuswan parlaq. ");
INSERT INTO qufNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Chaynumi, Josiwan Nicodemuqa Jesuspa kwirpuntaqa aypar, raĉhpitata chay mishki mutkiypaqla rimidyitukunawan alli salar, pilluranllapa. Chaynuqami ruraranllapa, Israelmanta runakunapa chaynu pampakunanllapapaq kustumrin kashanrayku. ");
INSERT INTO qufNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Chay lugar kruspi klabashanllapapiqa kayaq uk wirta. Chaypiqami kayaqna qaqapi uk uĉhku wanuqkuna pampakananpaq. Piru chaypiqami manaraq mayqanpis pampakashachu kayaq. ");
INSERT INTO qufNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Chaymi chaylapi pamparanllapa, chay yatanlapi katin. Chaqa Israelmanta runakunapa samanan diyamapis qallariyarannari. ");
INSERT INTO qufNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Chaymantami simanapa punta diyanpiqa María Magdalenaqa amsaq amsaqla riran Jesús pampakashanmanqa. Chaynu rir ĉharmi, chay uĉhkuta kirpaq atun rumiqa uklawpina kaqta rikaran. ");
INSERT INTO qufNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Chaymi kallpar riran, Simón Pedruta, chaynulla Jesuspa chay kusa munashan yaĉhakuqninta willaq. Ĉharqa, kaynu niran: —¡Amitunchikllapataqa pampakashanmanta urqur apashallapa! ¡Manami yaĉhayanillapachu maymanmi apar ĉhurashallapa nirmapis! ");
INSERT INTO qufNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Chaynu nitinmi, Pedruqa chay uk yaĉhakuq masinwanqa riranllapa Jesús pampakashanmanqa. ");
INSERT INTO qufNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ishkantinmi kusata kallparanllapa. Piru chay uk yaĉhakuqqami kusata kallpar Pedrumantaqa naypaqta ĉharan. ");
INSERT INTO qufNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ĉharqami piratar chapakurqa Jesús pillukashan raĉhpalatana rikaran. Piru manami yaykuranchu rurimanqa. ");
INSERT INTO qufNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Chaymanta Simón Pedro ĉharqa, yaykuran pampakashan uĉhkumanqa. Piru paypis, Jesús pillukashan raĉhpalatana usuraqta rikaran. ");
INSERT INTO qufNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Chaynullami umanta pillushanllapa raĉhpaqa, kwirpunta pillushanllapa raĉhpawanqa mana pullachu karan. Ashwanmi umanta pillushanllapa chay raĉhpaqa, chiqanla pillukasha usurayaran. ");
INSERT INTO qufNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Chaymantaqa, Jesuspa chay uk yaĉhakuqnin naypaqta ĉhasha karan chaypis, yaykuran. Yaykur tukuy chay pasashanta rikarqa, chaypiraq kriyiran Jesús kawsamushana nirqa. ");
INSERT INTO qufNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Chaqa paykunaqa manaraq intrakashachu karanllapa, Dyus nitin iskribikashakunapi Jesusqa wanur kawsamuyanqa nishanpaqqa. ");
INSERT INTO qufNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Chaymantami Jesuspa yaĉhakuqninkunaqa tikrakaranllapa wasinllapaman. ");
INSERT INTO qufNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Nataq María-shuypaqa Jesús pampakashan punkulapi waqar kidaran. Chaynu waqayarqa, piratar chapakuran uĉhku rurimanqa. ");
INSERT INTO qufNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Chaymi ishkay angelkuna kusa yuraq intiru raĉhpayjunta rikaran. Paykunaqami Jesús pampakashanpi, uknin ĉhakinlaw kashanpi, ukninqa uman kashanpi tayaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Chaymantaqa chay angelkunaqa tapuranllapa Mariataqa kaynu nir: —Mamitay, ¿imapaqtaq waqayanki? nir. Chaynu taputinllapaqa, payqa niran: —Amituyta apasha katinllapami waqayani. Manami yaĉhayanichu mayman aparmi ĉhurasha kanqallapa nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Chaynu nir uklawman chapakuq tikrakayarlami, Jesusta naypanpi shaqta rikaran Mariaqa. Piru payqa mana yaĉhayaranchu Jesús kanqa nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Chaymantami Jesusqa payta tapuran kaynu nir: —Mamitay, ¿imapaqtaq waqayanki? ¿Pitataq maskayanki? Chaynu taputinqa, María Magdalenaqa, wirtata kuytaq kanqa nir yarpur, niran: —Taytituy qam apasha karqa willamay, ¿maypitaq ĉhurashayki rir apanaypaq? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Chaynu nitinqa, Jesusqa niran: —¡María! nir Mariaqa tikrakamur niran hebreo rimaypi: —¡Raboni! nir. (Rimananchikpiqa niyan “Yaĉhachikuq Taytituy”). ");
INSERT INTO qufNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Chaynu nitinmi chaymantaqa, Jesusqa niran: —Ama aypamaychu mamitay. Chaqa manaraqmi rishachu kani Taytaywan pulla kanaypaqqa. Piru rir, tukuy ukniykunata willapamay, riyaninami Taytaywan, Taytaykillapawan, Dyusniywan, Dyusnikillapawan tarinakuq nir. ");
INSERT INTO qufNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Chaymi Mariaqa rir, willaran Jesuspa tukuy yaĉhakuqninkunataqa: “Amitunchikllapatami rikasha kani” nir ima. Chaynullami Jesús willashantaqa tukuyta parlakuran manyaqmanta. ");
INSERT INTO qufNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Chay simanapa punta diyanllapi, limpu amsayatinnaqa Jesuspa yaĉhakuqninkunaqa uk wasilapi tantakar alli kirpakusha ima tayaranllapa, Israelmanta karguyjunkunata manchashanllaparayku. Chaynu kayatinllapami, Jesusqa illaqmanta yaykur, paykunapa ĉhaypinllapapi shar, kaynu nir saludaran: —¡Kusa shumaqmi kankillapa! nir. ");
INSERT INTO qufNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Chaynu nirnaqa, Jesusqa yaĉhakuqninkunata rikachiran makinkunata, kustillanta ima. Chaymi paykunaqa Jesusta rikar riqsirqa, allipta aligriyaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Chaymantaqa qashan Jesusqa paykunataqa niran: —¡Kusa shumaqmi kankillapa! Chaqa imanuĉhi Taytay kaĉhamaran chaynullami qamkunatapis kaĉhashunillapa, nuqapaq yaĉhachikutkillapa kriyirna washakananllapapaq nir. ");
INSERT INTO qufNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Chaynu nirqa, Jesusqa paykunaman pukakur, niran: —Santu Ispiritu qamkunawan kanqa. ");
INSERT INTO qufNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Chaymi mayqantapis uchanmanta pirdunatkillapaqa pirdunakashana kanqallapa. Chaynulla mayqantapis uchanmanta mana pirdunatkillapaqa, mana pirdunakanqachu nir. ");
INSERT INTO qufNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jesús kawsamur yaĉhakuqninkunaman rikaritinqa, dusi yaĉhakuqninkunamanta Tomás, chay Milli niqllapa chayqa, mana chaypichu karan. ");
INSERT INTO qufNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Chaymi chaymantaraq Tomastaqa willaranllapa: —Amitunchikllapatami rikasha kanillapa, nir. Piru Tomasqa niran: —Makinkunata klabu chuqrishanta mana rikar, chaynulla chay chuqrikashanman mana diduyta itar, mana makiywan kustillanta kamar imaqa, mana kriyishaqchu nir. ");
INSERT INTO qufNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Chaymanta uchu diya pasatinnaqa, Jesuspa yaĉhakuqninkunaqa qashan tantakaranllapa chay wasillaman. Tomaspismi chaypina karan. Paykunaqami punkuta kirpakusha tayaranllapa. Piru Jesusqami illaqmanta yaykur paykunapa ĉhaypinllapapi shar kaynu nir saludaran: —¡Kusa shumaqmi kankillapa! nir. ");
INSERT INTO qufNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Chaynu nirqa, Tomastaqa niran: —Diduykita kayman itay, makiykunata rikay, makikita apamur kustillayman itay. Ama mana kriyiq runachu kar, ¡kriyiy! nir. ");
INSERT INTO qufNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Chaynu nitinmi, Tomasqa kusata aligriyar kaynu niran: —¡Amituymi kanki; Dyusniymi kanki! nir. ");
INSERT INTO qufNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Chaymi Jesusqa niran: —¿Kanan rikamarqachu kriyimankina? ¡Kusa shumaqmi kanqa manaraq rikamayar, kriyimaqkunaqa! nir. ");
INSERT INTO qufNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesusqami yaĉhakuqninkunapa naypanpiqa mas achka milagrukunata ruraran. Piru wakin milagrukunaqami kay librupiqa mana iskribikashachu. ");
INSERT INTO qufNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nataq chay iskribikashakuna-shuypaqami, Jesusqa Taytanchik Dyuspa Wamran chaynulla Akrashan Cristun nir, qamkuna kriyinaykillapapaq iskribikasha. Chaynu kriyirnaqami tukuy tyimpupaqna kawsankillapa payrayku. ");
INSERT INTO qufNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Chaymantami, Jesusqa qashan rikariran wakin yaĉhakuqninkunaman, Tiberias shutiq quĉhapa manyanpi. Kaykunami karan tarinakutinllapaqa: ");
INSERT INTO qufNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simón Pedruqa chay Milli niqllapa Tomaswan, chay Caná Galilea pwiblumanta kaq Natanaelwan, Zebedeupa ishkay wamrankunawan, chaynulla ishkay mas yaĉhakuq masinkunawan pulla karanllapa. ");
INSERT INTO qufNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Chaypi pulla kayatinllapaqa, Simón Pedruqa niran: —Riyani piskadukuq, nir. Chaymi chay wakinkunapis niranllapa: —Chaynu katinqa nuqakunapis pullayki rishaqllapa nir. Chaynu ninakur chaymantaqa riranllapanari uk yaku karruman iqar. Piru chay tutaqa mana uklamatapis piskadutaqa ayparanllapachu. ");
INSERT INTO qufNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Limpu achkiyayatinnami, Jesusqa chay atun quĉhapa manyanpi rikariran. Piru yaĉhakuqninkunaqa mana yaĉhayaranllapachu, Jesús kanqa nirqa. ");
INSERT INTO qufNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Chaynu yarpupakuyatinllapaqa, ashwan Jesusqa niran paykunataqa: —Wamrituykuna, ¿manachu piskaduta aypashaykillapa mikunallapapaq? nir. Paykunaqa niranllapa: —Manami nir. ");
INSERT INTO qufNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Chaynu nitinllapaqa, Jesusqa qashan niran paykunataqa: —Yaku karruykillapapa allilaw qichqanman atun shikraykillapataqa itakuyllapa. Chaypiqami aypankillapa nir. Chaynu nitinmi, paykunaqa chaynu ruraranllapa. Piru chaymantaqa manana chay atun shikrataqa lluqshichimuyta puytiranllapachu, kusala unta piskadu kashanrayku. ");
INSERT INTO qufNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Chaymantami Jesuspa chay kusa munashan yaĉhakuqninqa, Pedrutaqa niran: —¡Wakqami Amitunchikllapa! nir. Chaynu niqta uyaparlami Simón Pedruqa raĉhpanta yakakuran. Chaqa lirila karan. Raĉhpanta yakakur yakuman yaykuran. ");
INSERT INTO qufNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Nataq chay wakinkuna-shuypaqa, syin mitrulana yupay manyaman ĉhananpaq faltayatin, yaku karrunpiqa ĉharanllapana, atun shikrapi piskaduta untalla aysaĉhakusha. ");
INSERT INTO qufNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Chaymanta ishkir rirqa yaku manyaman ĉharqa nina ratakuqta tariranllapa. Chay nina ratakuqpa ananpiqa piskaduwan, tantita kasha karan. ");
INSERT INTO qufNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Chaymi Jesusqa paykunataqa niran: —Apamuyllapa chayraqla lluqshichimushaykillapa wakin piskadukunata nir. ");
INSERT INTO qufNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Chaynu Jesús nitinqa, Simón Pedruqa iqar chay atun shikrataqa waqta pachakaman chutamuran. 153 piskadu kusa atunlla karan, chay atun shikrapiqa. Piru chaynumapis mana llikikaranchu chay shikraqa. ");
INSERT INTO qufNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Chaymantami Jesusqa, paykunataqa niran: —Shamur mikuyllapa nir. Chaynu nitinqa chay yaĉhakuqninkunaqa ukninlamapis mana tapuyaqllapachu, mayqantaq kanki nirlamapis. Chaqa yaĉhayaranllapanari Amitunchikllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Chaymantami Jesusqa paylla yaĉhakuqninkunaman qimikar tantitakunata, piskadukunata ima aypachiran. ");
INSERT INTO qufNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Chay rikarishanwanqami kawsashanmantaqa Jesusqa kimsa kutipaqna rikarisha karan yaĉhakuqninkunamanqa. ");
INSERT INTO qufNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Mikur tukchitinllapanaqa, Jesusqa niran Simón Pedrutaqa: —Jonaspa wamran Simón. ¿Qamqachu chiqapta kaykunamantaqa masta munamanki? Pedruqa niran: —Arí Taytituy. Qamqami yaĉhayanki nuqaqami munashuni nir. Chaymi Jesusqa niran: —Uyshitaykunatami qaranki nir. ");
INSERT INTO qufNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Chaynu nirqa, qashan tapuran: —Jonaspa wamran Simón, ¿chiqaptachu munamanki? nir. Pedruqa niran: —Arí Taytituy. Qamqami yaĉhayanki nuqaqami munashuni nir. Chaymi qashanpis Jesusqa niran: —Uyshitaykunatami michinki nir. ");
INSERT INTO qufNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Chaynu nirqa qashan kimsa kutipaqna kaynu nir tapuran: —Jonaspa wamran Simón ¿munamankichu? nir. Chaynu Jesús kimsa kuti tapushanrayku, Pedruqa kusa llakishala niran: —Taytituy, qamqami yaĉhayanki tukuyta. Qamqami yaĉhayanki nuqaqa munashuni nir. Jesusqa qashan niran: —Uyshitaykunatami qaranki nir. ");
INSERT INTO qufNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Chiqaptami nishayki: Musu karqami maytapis rinashaykita riq kanki, qamlla mudakur ima. Piru kanan-shuypaqa nishayki: Rukuna katkiqami, ukna mudachishunqa, qamqa rikraykikunata chutarachitki. Chaynu raĉhpaykita yakachishurqa, maytapis apashunqa mana qam rinashaykimanmapis. ");
INSERT INTO qufNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesús chaynu nirqa, Pedrutaqa intrachinayaran imanumi wanuyanqa nir. Chaynulla intrachinayaranpis chay wanushanrayku, runakunaqa Dyuspi mastana kriyir alabanqallapa nir. Chaynu nirnaqa chaymantaqa niran: —¡Shamuy nuqawan rishun! nir. ");
INSERT INTO qufNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Chaynu ninakurqa riranllapana. Riyarllapa Pedruqa das ikinman chapakurqa, rikaran Jesuspa kusa munayashan yaĉhakuqnin ikinllapata riqta. Kay kusa munayashan yaĉhakuqninmi Jesús wanunanpaqna paykunawan mikuyatinqa, tapusha karan “¿Mayqanninllapashi kuntrankunamanqa qukuyanqa?” nir. Paymi ikinllapataqa riyaran. ");
INSERT INTO qufNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ikinllapata riqta rikarqa, Pedruqa Jesustaqa tapuran: —Taytituy, kayta-shuypaqa, ¿imataq pasayanqaqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesusqa Pedrutaqa niran: —Nuqa munar, qashan shamunaykaman kawsachitiymapis, ¿ima kwintaykitaq qampaqqa? Qamqa shamuy nuqawan rishun nir. ");
INSERT INTO qufNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Chaynu Jesús nisha katinmi, tukuy paypi kriyiqkunaqa kusata ninakuqllapa: “Chay kusa munashan yaĉhakuqninqa manana wanuyanqanachu” nir. Piru Jesusqa manami, mana chiqapta wanunanpaqchu niran. Chaqa payqa, niran: “Nuqa munarqa, qashan shamunaykaman kawsachitiymapis, ¿ima kwintaykitaq qampaqa?” nirla. ");
INSERT INTO qufNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Jesusqami nuqapaq rimaran chaynuqa. Chaynu karmi nuqalla rimani tukuy chaykunapaqqa. Chaynullami tukuy kaypi iskribikashakunatapis nuqalla iskribisha kanimapis. Chaymi nishayqa chiqap. ");
INSERT INTO qufNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesusqami achka milagrukunata ruraran. Tukuy chay rurashankunata manyaqmanta iskribishaqami kay pachamapis tukuy librukunataqa mana aypayanmanchu. ");
INSERT INTO qufNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tayta Teófilo, punta iskribishushay libruypimi nishuray Jesús imata rurashanpaq, yaĉhachikushanpaq ima, qallarishan diyamanta-pacha, ");
INSERT INTO qufNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","syiluman rishankaman. Manaraq syiluman riyarqami, Santu Ispiritunlawan yaĉhachiran, tukuy akrashan apustulninkunataqa, imatami ruranqallapa nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Chaymantaqami, wanusha karmapis kawsamurqa rikariran apustulninkunapa naypanman. Chaqa, chaynumi paykunataqa intrachiran “Chiqapta kawsayan” nir. Chaymi, kwarinta diyakunata pullanllapa kar, yaĉhachiyaran Taytanchik Dyuspa mantakuyninpaq. ");
INSERT INTO qufNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Apustulninkunawan pulla karllaraqmi, Jesusqa allita willaran, kaynu nir: —Amaraqmi maytapis rinkillapachu Jerusalén pwiblumantaqa. Ashwan yarayllapa Taytay tukuy chay arnishushanllapata kumplishunanllapakaman. Manachu nishurayllapa Santu Ispiritunwan shutichishuyanqallapa nir. ");
INSERT INTO qufNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Chiqaptamiri Shutichikuq Juanqa yakulawan shutichikuran. Nataq allaqkamanqa Santu Ispirituwanna shutikunkillapa. ");
INSERT INTO qufNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Chaynu nitin Jesuswan pulla kaqkunaqa kaynu nir, tapuranllapa: —Taytituy, ¿qamchu, chay romano runakuna mantamananllapamantaqa washar, kay Israel pwiblumanta kaqkunataqa kananlla mantamanaykillapapaq kanki? nir. ");
INSERT INTO qufNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Chaymi Jesusqa niran: —Manami qamkunaqa yaĉhanaykillapapaq allinchu, maydiyami, ima urasmi Tayta Dyus imata rurayanqa nirmapis. Chaytaqami payla yaĉhan, tukuypa amun kar, maydiyami, ima urasmi imata rurayanqa nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Chaynu katinmapis, Taytanchik Dyuspa Santu Ispiritunmi qamkunaman shamutin, paypa pudirninwanna kankillapa. Chaymantanami rinkillapa nuqapaq yaĉhachikuq kay Jerusalén pwiblupi, tukuy Judeapa pwiblunkunapi, Samariapa pwiblunkunapi, chaynulla tukuy pacha intiruta ima. ");
INSERT INTO qufNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Chaynu nirmi, tukuy chaypi kaqkuna rikayatin, Jesusqa apakaq qallariran syiluman. Chaymantaqa unaqpina katin, puktay rikarimur limpu pampatin, mana rikaranllapanachu. ");
INSERT INTO qufNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Chaymanta chay runakuna, syiluman iqaqta rikakuyatinllapaqa, ishkay runakuna yuraq mudanayjun rikariran paykunamanqa. ");
INSERT INTO qufNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Chaymi niranllapa: —Galilea pwiblumanta runakuna, ¿imapaqtaq qamkunaqa chapakuyankillapa syilumanqa? Jesús, qamkunawan karan chayqami rishana syiluman. Chaymantaqami imanutaq qamkuna rikayatkillapa riran, chaynulla qashan shamunqa maydiyaqa. ");
INSERT INTO qufNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Olivos shutiq sirkamanta-pachami apustulkunaqa tikrakaranllapa Jerusalén pwiblukaman, shipcha kashanrayku. Chaqa samana diyapiqami chaynulata purinanllapapaq karan. ");
INSERT INTO qufNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Chaynu Jerusalenman ĉharllapaqa, chay samashanllapa wasipa mas unaq altuman iqaranllapa. Paykunaqami kaykuna karanllapa: Pedro, Juan, Santiago, Andrés, Felipe, Tomás, Bartolomé, Mateo, Alfeupa wamran Santiago, Simón (paymi Celote shutiranpis), chaynulla Santiagupa uknin Judas ima. ");
INSERT INTO qufNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Paykunaqami tukuyninllapa waran waran Jesuspa ukninkunawan, maman Mariawan, wakin warmikunawan ima tantakaqllapa Dyusman pulla mañakunanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Chay diyakunapimi syintu binti (120) yupay kriyiqkunaqa tantakaranllapa. Chaymi Pedruqa ĉhaypinllapapi shar, kaynu nir rimaq ĉhurakaran: ");
INSERT INTO qufNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","“Ukniykuna, Davidmi Santu Ispiritu yanapatin iskribiran Judaspaq. Chaymi tukuy iskribishanqa kumplikaranna. Chaqa Judasqami nuqanchikkunapa ukninchikllapa kar, imata rurashallapapis ruraq. Piru chaynu karmapis Jesuspa kuntrankunata apatin, ayparanllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Chaynu Jesusta kuntrankunaman qukur mana allinta rurashanpaqqami pagraranllapa. Chaymi chay qillaywanqa rir uk pachata rantiran. Chaymantami umap ratar paĉhyatin, limpu chunchulinmapis qutukamutin wanuran. ");
INSERT INTO qufNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Chayta Jerusalén pwiblupi taqkuna yaĉharmi, chay pachataqa ‘Acéldama’ shutichiranllapa. Rimayninllapapi-shuypaqa munan niyta ‘Yawar Pacha’ nir. ");
INSERT INTO qufNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Chaqa Judaspaq David, Salmos librupi iskribishanqami chiqapta kumplikaran. Chaqa niqmi: ‘Wasinqami chunllaq lugarpaq tikrakanqa. Chaymi manana mayqanpis chaypiqa tanqanachu’ nir. Chaynullami niqpis: ‘Uknami paypa lugarninqa kanqa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Chayraykumi, allin kanqa tukuy kriyiqkunamanta, uk runata akrasha yanapamanallapapaq. Chaqa kay nuqanchikkunapimi kanllapa Amitunchik Jesucristo nuqanchikkunawan katin, maydiyapis pullanchikllapa kasha kaqkunaqa. ");
INSERT INTO qufNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Paykunaqami Shutichikuq Juan, Jesusta shutichishanmanta-pacha, syiluman rinankaman, pullanchikllapa kasha. Chaymi paykunamanta uknin allin kanqa, pullanchikllapana kar intrachikunanpaq, Jesusqami wanushanmantaqa kawsamuran nir ima”. ");
INSERT INTO qufNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Chaynu nirqami ishkay runakunata akraranllapa: Ukninqami shutiq José. Paytami niqllapapis: Barsabás, Justo ima nir. Nataq, uk-shuypaqa Matías karan. ");
INSERT INTO qufNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Chaymantami Dyusman kaynu nir mañakuranllapa: “Taytituy, qammi tukuypa yarpuyninta yaĉhanki. Chaymi rikachimayllapa, kay ishkaykunamantaqa mayqannintataq akrashayki. ");
INSERT INTO qufNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Chaynuqami payna chay Judas uchanrayku chinqaran chaypa lugarninqa apustul kananpaqqa. Chaqa Judasqami rishana maymanĉhi rinanpaq karan chaymanqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Chaynu nir mañakutinllapami swirtikunaqa Matiaspaq ishkiran. Chaymi chaymanta-pachaqa chay unsi apustulkuna, Matiaswan tantakarqa dusina qashan karanllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Chaymanta Pentecostés fyista ĉhamutinqa, Jesucristupi tukuy kriyiqkunaqa uk wasilaman tantakasha karanllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Chaynu chaypi katinllapami, illaqmanta jwirti wayra yupay kusata waqar syilumanta shamur, yaĉhapachiran chay wasi kashanllapamatapis. ");
INSERT INTO qufNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Chaymi, paykunamanqa rikariran ninapa llipyaynin yupay tukuyninpa ananman. ");
INSERT INTO qufNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Chaymantami, tukuy chaypi kaqkunaqa Dyuspa Santu Ispiritunwanna kidaranllapa. Chaymi Santu Ispiritu rimachishannulla uk rimaykunatana rimar parlaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Chay diyakunapimi Jerusalén pwiblumanqa, Dyuspi kusa achka kriyiq Israel runakuna ĉhamusha chaypina tayaranllapa. Paykunaqami tukuy may nasyunkunamanta shamusha karanllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Chaymi, chay wayra yupay waqaqta uyaparllapaqa, tukuy runakuna qimikaranllapa chay wasimanqa. Chaynumi paykunapa rimananllapapi rimaqta uyaparanllapa, chay wasipi tantakashakunataqa. ");
INSERT INTO qufNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Chaymi mana allitachu yarpur, paykunapura kaynu ninakuqllapa: “¿Manachu kay rimaqkunaqa tukuynin, Galilea pwiblulamanta? ");
INSERT INTO qufNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Imanutaq nuqanchikkunapa rimayninchikllapapi rimayanllapaqa? ");
INSERT INTO qufNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kaypiqami kanchikllapa achka nasyunkunamanta: Partia pwiblumanta, Mediamanta, Elammanta, Mesopotamia pwiblumanta ima. Wakinqa Judea pwiblumanta, Capadociamanta, Pontumanta, chaynulla prubinsya Asiamanta ima. ");
INSERT INTO qufNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Kanchikllapapismi Frigia pwiblumanta, Panfiliamanta, Egiptumanta, chay Cirene pwiblupa qichqan Africapa pwiblunkunamanta ima. Chaynulla wakinkuna-shuypaqa shamushanchikllapa Roma pwiblumanta. Ukkunaqa chiqap Israel runakuna kanchikllapa. Nataq wakin-shuypaqa, Israel runakunapa kustumrikunata ruraqkunana kanchikllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Kanchikllapapismi Cretapa pwiblunkunamanta, Arabiamanta ima. Chaynu tukuy riqchaq pwiblukunamanta karmapismi, kusa allita intrakanchikllapa rimayninchikkunapi Dyusninchikpaq, tukuy shumaq rurashanpaq ima yaĉhachimashallapamapis nir”. ");
INSERT INTO qufNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Tukuy paykunami kusata dispantakarllapa, mana allita yarpuranllapachu. Chaymi kaynu ninakuqllapa: “¿Imatataq munan niyta, tukuy kayqa?” nir. ");
INSERT INTO qufNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Nataq wakinkuna-shuypaqami burlakar, niqllapa: “Wak runakunaqami maĉhasha” nir. ");
INSERT INTO qufNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Chaymantami Pedruqa shariran, wakin unsi apustul masinkunawan pulla. Chaymi payqa jwirtita rimaq qallariran, kaynu nir: “Israel runa masiykuna, tukuy kay Jerusalén pwiblupi taqkuna, kayta qamkunaqa uyakuyllapa nuqa willashuyanillapa chayta. ");
INSERT INTO qufNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Qamkunaqa maĉhasha nimankillapa. Manami chay nishaykillapanuchu. Chayraqmi allaqllaraq, imanuna maĉhashaqa kashaqllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ashwan kayqami chaynu pasayan, Dyuspa unay rimaqnin Joel nisha karan chaynulla. Chaqa Joelmi kaynu niran: ");
INSERT INTO qufNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Dyusninchikmi nin: Maydiya pacha tukukananpaq katinnaqami tukuy runakunaman kaĉhashaq Santu Ispirituyta. Chaymi runakunapa wamrankuna, ullqupis, warmipis rimanqallapa nuqa munashayta. Musu wamrakunami riqchaq imakunata rikapakunqallapa. Nataq rukukuna-shuypaqa musqupanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Chaynulla chay diyakunapimi munashay akrashaykunamanpis kaĉhashaq Santu Ispirituytaqa, paykunapis rimananllapapaq nuqa munashayta. ");
INSERT INTO qufNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Unaq syilupimi mana rikashanllapakunata rikachishaq, rikar dispantakananllapapaq. Nataq kay pachapi-shuypaqa yawarta, ninata, quntayta ima rikachishaq, runakuna rikar dispantakananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Chayna, Amitunchik shamunanpaq diya ĉhamuyatinnaqa, rupayqa yanalla tutaparaqpaq tikrakanqa. Nataq killa-shuypaqa yawarpaq yupay tikrakanqa. ");
INSERT INTO qufNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Piru mayqanpis Amitunchikpi kriyir shutinpi mañakuqqami washakanqa’ nir”. ");
INSERT INTO qufNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Chaymi Pedruqa niranpis: “Uyakuyllapa, Israel runakuna, kaynu nishutiyllapa: Nazaretmanta Jesustami, Dyus yanapatin naypaykillapapi mana ruraypaq shumaq imakunata, milagrukunata, kusa dispantakaypaqkunata ima ruraran. Chaynuqami ruraran qamkuna rikar allita yaĉhanaykillapapaq, Jesusqami chiqapta Dyusmanta shamusha karan nir. ");
INSERT INTO qufNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Piru ukkuna qushutinllapami ashwan chay mana allin runakunawan kruspi klabar wanuchiraykillapa, imanutaq Dyus unaylla chaynu kananpaqqa nishallana karan chaynulla. ");
INSERT INTO qufNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Chaynu wanuchitkillapapismi, Tayta Dyusqa wanushanmanta kawsachimuran. Manari dijaranchu ismunanpaqqa. ");
INSERT INTO qufNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Chaqa Davidmi unaylla iskribiran, Jesús kaynu nishanta: ‘Nuqami maydiyapis Dyusniytaqa naypaypi rikani. Chaynu pay allilaw qichqaypi katinqami, mana mayqantapis manchayta puytinichu. ");
INSERT INTO qufNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Chayraykumi tukuy shunquywan kusata aligriyar takini. Chaymi ashwan Dyusniylapi kunfyakarna kawsashaq. ");
INSERT INTO qufNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Chaymi Taytay, wanur pampakatiymapis mana dijankichu almay chaypi kidananpaqqa. Chaynulla kusa munashayki Wamraykipa kwirpun ismunanpaqpis mana dijankichu. ");
INSERT INTO qufNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Chaqa qammi intrachimarayki, munashaykita rurar tukuy tyimpupaqna kawsanaypaq. Chaymi naypaykipiqa, kusata aligriyanimapis’ nir”. ");
INSERT INTO qufNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Chaynu nirnaqami Pedruqa niranpis: “Ukniykuna, chiqaptami nishaykillapa: Unay rukunchikllapa Davidmi wanutin, pamparanllapa. Chaymi chay pampakashantaqa kanankaman rikanchikllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Chaqa Davidmi Dyuspa rimaqnin kashanrayku Dyusqa jurar arnisha katin, yaĉhayaranllana, paypa ayllunmantashi uk mantakuq kayanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Chaynu katinmi Davidqa, Jesús kawsamunanpaq kashanta rikasha yupayna kaynu niran: Dyus Akrashan Cristun wanur pampakatinqashi, almanqa mana chaypiqa kidayanqachu, chaynulla kwirpunmapis manashi ismuyanqachu nir. ");
INSERT INTO qufNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Chaqa chay nishannullami Dyusqa, Jesustaqa kawsachimuran. Chaymi tukuy chaykunapaqqa nuqanchikkuna allita yaĉhanchikllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Chaymantami Dyusqa, Jesucristuta syiluman apar, allilaw qichqanpina tachiran. Chaynullami Taytanqa quran Santu Ispiritunta. Chaymi paypis chay arnimashanchikllapa Santu Ispiritutaqa nuqanchikkunamanpis kaĉhamuran. Tukuy chaytami qamkunaqa rikashaykillapa, uyapashaykillapa ima. ");
INSERT INTO qufNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Mabir, ¿imapaqtaq Davidqa syilumanqa mana riran? Chaqa payllamiri kaynu niran: ‘Tayta Dyusmi, Amituytaqa kaynu niran: Tay allilaw qichqaypi, ");
INSERT INTO qufNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","maydiya chay ĉhiqnishuqkunata ĉhakikipa ĉhakinman ĉhuranaykaman nir’. ");
INSERT INTO qufNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Israel pwiblumanta runakuna allita uyakur intrakayllapa, Jesusta kruspi klabar wanuchishaykillapatami, Dyusqa kananqa nisha, tukuypa Washakuqnin Amitunchikllapana kananpaq” nir. ");
INSERT INTO qufNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Chaynu Pedro nitinmi, chaypi tantakasha kaqkuna uyaparqa, tukuy shunqunwan kusalata llakiranllapa. Chaymi Pedruta, chaynulla wakin apustulkunamatapis kaynu nir tapuranllapa: —¡Ukniykuna! ¿Imatataq rurashaqllapa? nir. ");
INSERT INTO qufNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedruqa niran: —Tukuy mana allinta rurashaykillapata dijar, Dyusman tikrakar, uknikillapa uknikillapa Jesucristupa shutinpina shutikuyllapa. Chaynuqami Dyusqa uchaykillapamanta pirdunar, Santu Ispiritunta qushunqallapa. ");
INSERT INTO qufNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tukuy kay nishushayllapaqami qamkunapaq, wamraykillapapaq, chaynulla tukuy uklawmanta kaqkunata Amitunchik Tayta Dyus akranashankunapaq imami kanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Chaynu nir imami, Pedruqa allita willar, kaynu niranpis: —¡Wakaq tukuyllapa chay mana allin tukuq runakunamanta! nir. ");
INSERT INTO qufNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pedro chaynu nitinmi, intrakar kriyiqkunaqa chay diyalla shutikuranllapa. Chaymi kriyiqkunaqa tris mil (3,000) yupayna karanllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Paykunaqami apustulkuna yaĉhachikutinqa kusa allita kriyishanllaparayku yanapanakur ima kawsaqllapa. Chaynulla Dyusman mañakuqllapa; Santa Mikunata mikuqllapa ima. ");
INSERT INTO qufNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Tukuy kriyiqkunaqami kusalata dispantakaqllapa, Dyus yanapatin apustulkuna achka milagrukunata, mana ruraypaq shumaq imakunata ruratinllapa rikarqa. ");
INSERT INTO qufNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Chaynumi kriyiqkunaqa tantala kusa shumaqta kawsaqllapa, iman kaqkunawan ukninllapa ukninllapa yanapanakur ima. ");
INSERT INTO qufNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Chaymi imanllapata rantikurmapis chay qillaywan imanu paykunamanta ministishanllapanulla yanapanakuqmapis. ");
INSERT INTO qufNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Chaynulla waran waranmi Dyusta adurananllapa wasipi tantakar, Dyusta alabaqllapa. Nataq wasinllapapi-shuypaqa tantakaqllapa Santa Mikunata mikunanllapapaq. Chaynumi tukuy shunqunllapawan kusata aligriyar ima tantala mikuqllapamapis. ");
INSERT INTO qufNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Dyusta tantala alabatinllapa rikarmi, tukuyla kusa shumaqta yarpuqllapa. Chaymi Dyus yanapatin kriyir washakaqkunaqa waran waran masna achkayayaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Uk diyami, alas tris di la tardina, Pedruwan Juanqa Dyusta adurananllapa wasiman riran. Chay urasmi tantakar Dyusman mañakuqllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Piru Dyusta adurananllapa wasipiqami, nasishanmanta-pacha uk kuju runitu karan. Paytami waran waran apar dijaqllapa chay wasipa punkun “Shumaq Punku” shutiqpi. Chayna chay wasiman tukuy yaykuqkunata limusnata mañakunanpaq. ");
INSERT INTO qufNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Chaymanta chay kujuqa, Pedruwan Juanta Dyusta adurananllapa wasiman yaykuqta rikarqa, limusnata mañakuran. ");
INSERT INTO qufNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Chaymi Pedruwan Juanqa kusata chaparan. Chaynu chaparllapami, Pedruqa kaynu niran chay kujitutaqa: —Allita chapamayllapa nir. ");
INSERT INTO qufNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Chaymi chay runituqa kusata chaparan, imalataqa qumayanqallapa nir yarpur. ");
INSERT INTO qufNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ashwanmi, Pedruqa niran: —Manami qillayniyjun, uruyjunpischu kani. Piru kaytami qushuyta puytini, Nazaretmanta Jesucristupa shutinpi nishuni: Sharir puriy nir. ");
INSERT INTO qufNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Chaynu nirqami Pedruqa allilaw makinmanta chutar sharichitin, chay kujupa ĉhakinkuna, muqunkunamapis jwirtina tikrakaran. ");
INSERT INTO qufNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Chaymi, chay kujuqa das piryar sharir puriqna qallariran. Chaymantaqa paykunawan pullana, Dyusta adurananllapa wasiman yaykuran, piryar piryar Dyusta alabaqnuna. ");
INSERT INTO qufNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Chaymi tukuy chaypi kaqkuna, Dyusta alabar puriqta rikarqa, ");
INSERT INTO qufNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","kusalata manchakur dispantakaranllapa. Chaqa payqa mananari kujunachu karan. Chaymi dispantakaranllapa, chay kujitu unaymanta-pacha limusnata, Dyusta adurananllapa wasipa punkun “Shumaq Punku” shutiqpi, mañakur taqta rikashanllaparayku. ");
INSERT INTO qufNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Chay kuju alliyashaqami, Pedruwan Juanmantaqa mana chiqanchakarannachu. Chaymi tukuy runakuna kusata dispantakar kallpar riranllapa, Dyusta adurananllapa wasipi, “Salomonpa Kurridurnin” shutiqpi kayashanllapaman. ");
INSERT INTO qufNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Chaymanta, Pedruqa chayta rikarmi, runakunataqa kaynu niran: “Israel pwiblumanta runakuna, ¿imaraykutaq kusata dispantakar, chapamankillapa? ¿Qamkunachu yarpunkillapa, nuqakunalla pudirniyjun kar, chaynulla kusa allin kashayllaparayku allichatiyllapa purisha chay runaqa? nir. ¡Manami chaynuchu! ");
INSERT INTO qufNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Unay rukunchik Abrahampa, Isaacpa, Jacobupa Dyusninmi, Wamran Jesucristuta, munashankunata qusha. Piru chaynu katinmapis qamkunaqa karguyjunkunaman qukuraykillapa. Chaymanta chay gubyirnu Pilato kaĉhashaq nitinmapis, qamkunaqa mana munaraykillapachu. ");
INSERT INTO qufNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ashwanmi washanaykillapamantaqa, allin mana uchayjun katinmapis, qamkunaqa mañaraykillapa uk wanuchikuq runata kaĉhananpaq, allinla Amitunchikta-shuypaqa mana. ");
INSERT INTO qufNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Chaynumi qamkunaqa wanuchiraykillapa bidanchikta qumanchik chaytaqa. Chaynu katinmapis, Dyusmi kawsachimuran. Chaytaqami nuqakuna rikasha kar, yaĉhanillapa. ");
INSERT INTO qufNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Chaymi, Jesuspa shutinpi allita kriyitiyllapa, Amitunchik allichasha kay runitutaqa. Qamkuna kay runituta riqsinkillapa, paypismi allita Jesuspi kriyir alliyasha. Chaytami tukuy qamkuna rikankillapa. ");
INSERT INTO qufNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Yaĉhaninami ukniykuna, qamkuna mantaqnikikunawan ima Jesusta wanuchiraykillapa mana allita yaĉharchu, imatami rurayanchikllapa kaynu tukurqa nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Chayta ruratkillapaqami kumplikasha Dyus unay nishanqa, imanuĉhi paypa rimaqninkuna nisha kayaq, ‘Paypa Cristunqashi qischakar wanuyanqa’ nir, chaynulla. ");
INSERT INTO qufNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Chayraykumi qamkunaqa uchaykillapata dijar, Dyusman tikrakar pay munashannu kawsayllapa. Chaynuqami payqa, tukuy uchaykillapamanta shumaqchashunqallapana. ");
INSERT INTO qufNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Chaynullami Tayta Dyusqa qashan Jesusta kaĉhamunqa, washamanallapapaq. Imanutaq unaymanta-pacha arnikusha chaynulla. ");
INSERT INTO qufNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Kananllaqami manaraq shamunqachu. Syilullapiraqmi kanqa, kay pachapi shumaqchakunan tyimpu ĉhamunankaman. Chay tyimpu ĉhamutinraqmi, Taytanchik Dyusqa kaĉhamunqa Wamranta kay pachapi tukuy imata shumaqchananpaq, imanuĉhi unay rimaqninkuna nisha karan chaynulla. ");
INSERT INTO qufNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Chaqa rimaqnin Moisesmi niran rukunchikkunata: ‘Dyus Amitunchikmi akranqa qamkunamanta uk rimaqninta nuqa yupaylla kananpaq. Chayrayku tukuy imata pay nishushanllapataqa, kasur rurayllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Chaqa tukuy payta mana kasuqkunataqa, Dyusqa kriyiqninkunamantaqa akrar chinqachinqa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Chaynumi Samuelmanta-pacha, Dyuspa tukuy rimaqninkunaqa, Jesús shamunan tyimpullapaq rimaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Chaymi Dyusninchik rimaqninkunata arnishanqa, qamkunapaqna kasha. Chaynulla, chay tratuta Dyus Amitunchikqa rukunchikkunawan ruraran, chaypis qamkunapaq kasha. Chay tratuta rurarmi Amitunchikqa, Abrahamtaqa niran: ‘Aylluykimanta uk runawanmi tukuy kay pachapi kaqkunata shumaqchashaq’ nir. ");
INSERT INTO qufNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Tayta Dyusmi, Wamran Jesucristuta wanushanmanta kawsachimurqa, naypaqtaqa qamkunamanraq kaĉhamuran bindisishunanllapapaq. Chaynuqa Dyusmanna tikrakanaykillapapaq, tukuy mana allin ruranaykillapataqa dijarna”. ");
INSERT INTO qufNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedruwan Juanqa runakunata yaĉhachiyatinllaraq, kurakuna ĉharan, Dyusta adurananllapa wasipa kuytakuqninkunawan, saduceo runakunawan ima. ");
INSERT INTO qufNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Paykunami piñakusha karanllapa, Pedruwan Juan, kaynu runakunata yaĉhachishanpaq: “Tayta Dyus, Jesusta wanushanmanta kawsachimushanraykumi runakunapis wanurqa qashan kawsamuyanqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Chaypaqmi aypar, apar karsilaranllapa allaqninkaman, chay diyaqa tardina katin. ");
INSERT INTO qufNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Chaynumapis, Pedruwan Juan yaĉhachikushanpiqa achka runakuna uyakurqa kriyishallapana karan. Chaymi chay kriyiqkunaqa ullqukunala yaqqa sinku milna (5,000) kasha kanqa. ");
INSERT INTO qufNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Allaqnin diyaqa Jerusalenpi tantakaranllapa, Israel runakunapa mantaqninkuna, Moisés mantakushanta yaĉhar yaĉhachikuqkuna ima. ");
INSERT INTO qufNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Chaypiqami karanpis, kurakunapa mantaqnin Anas shutiq runa. Chaynulla pullanqa karanpis Caifás, Juan, Alejandro ima. Tukuylla chay kurakunapa ayllun kaqkunapismi, chaypi karanllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Paykunami kaĉhakuranllapa, Pedruwan Juantaqa paykunaman apananllapapaq. Chaymi ĉhaypinllapapi shachir tapuranllapa, kaynu nir: —¿Mayqan mantashutinllapataq, pipa shutinwantaq, kaykunata rurayankillapa qamkunaqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pedruqa Santu Ispirituwan karmi, niran: —Pwiblukunapa rukunkuna, mantaqninkuna ima. ");
INSERT INTO qufNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Qamkuna tapumankillapa uk qishaq runata allichashayllapalapaq, yaĉhanaykillapapaq imanumi rurasha kanillapa, nir. ");
INSERT INTO qufNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Chaynu katinqa, qamkunata willashaykillapa, tukuy Israel pwiblupi yaĉhananllapapaq. Kay runa alliyasha naypaykillapapi shaqqami, alliyasha Nazaretmanta Jesucristupi kriyishanrayku, chay mayqantaĉhi qamkuna kruspi klabaraykillapa, payrayku. Chaynu klabatkillapamapis Dyusmi paytaqa kawsachimuran. ");
INSERT INTO qufNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesucristutami qam llutakuqkuna, kay rumiqami mana sirbinchu nir itakutkillapamapis, ashwan kusa shumaq rumipaqna tikrakasha. ");
INSERT INTO qufNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Manami ukkunapiqa washakayta puytinchikchu. Chaqa Tayta Dyusqa kay pachapi, maypipis mana qumashanchikchu uk runata payrayku washakanallapapaqqa nir. ");
INSERT INTO qufNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Chaynu nir, Pedruwan Juan mana istudyasha karmapis, mana manchakur imachu kusata rimaqta uyaparllapami karguyjunkunaqa kusata dispantakaranllapa. Chaynullami kwintata qukaranllapa, kay runakunaqami Jesuspa yaĉhakuqninkuna kasha nir. ");
INSERT INTO qufNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Chay alliyasha runapis chaypi paykunawan katin, mana mayqanpis imatapis willayta puytiranllapachu. ");
INSERT INTO qufNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Chaymi paykunaqa, Pedruwan Juanta waqtaman lluqshichir, ukninllapa ukninllapa tapunakur parlaqllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Chaymi kaynu ninakuqllapa: “¿Imatataq rurashunllapa kay runakunawanqa? Tukuy kay Jerusalén pwiblupi taqkunami yaĉhayanllapa kay shumaq milagruta rurashanllapapaqqa, manami mana niytaqa puytinchikllapachu. ");
INSERT INTO qufNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Chayraykumi, Jesuspaq rimar yaĉhachikutinllapa kriyir, ama achkayananllapapaqqa, alli abisar kaĉhashunllapa amana mayqantapis Jesuspaqqa parlar purinanllapapaqnachu”. ");
INSERT INTO qufNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Chaymi Pedruwan Juantaqa, qayamur willaranllapa, ama mayqantapis Jesuspa shutinpi rimarqa yaĉhachinanllapapaqnachu. ");
INSERT INTO qufNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Chaynu nitinllapamapis, Pedruwan Juanqa niranllapa: —Qamkunalla yarpuyllapa. ¿Allinchu kanqa Dyusta manana kasur qamkunatana kasushunayllapapaq? ¿Manaqachu Tayta Dyustaraq naypaqtaqa kasunayllapapaq allin kanqa? ");
INSERT INTO qufNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Manami nuqakunaqa uyarayta puytinillapachu rikashayllapamanta, uyapashayllapamantaqa. ");
INSERT INTO qufNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Piru chay karguyjunkunaqami amana chayta rurananllapapaq alli abisar, dijatinllapana riran. Manami imanupis kastigayta puytiranllapachu. Chaqa tukuy runakuna alabaranllapa Dyusta, ");
INSERT INTO qufNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","chay kuju runa kwarinta añuyjun karmapis alliyashanrayku. ");
INSERT INTO qufNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pedruwan Juanqa, prisu kashanmanta lluqshishana karllapaqa, rir tantanakuranllapana tukuy kriyiq masinkunawan. Chaymi chay kurapa mantaqninkuna, tukuy ruku mantakuqkuna, imanu willashanllapatapis, parlaranllapa wakinninkunataqa. ");
INSERT INTO qufNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Chaymanta uyakurllapaqa, tukuyninllapa tantala mañakuranllapa Dyusman, kaynu nir: “Taytayllapa qammi rurarayki syiluta, pachata, mar yakuta, tukuy chaykunapi kaqkunata ima. ");
INSERT INTO qufNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","26","Chaynu karmi Santu Ispirituykiwan rimachirayki unay rimaqniki Davidta, kaynu ninanpaq: ‘¿Imapaqtaq rimapakunllapa pwiblukuna? ¿Imapaqtaq parlanllapa mana imata yaĉhar, mana allin ruraykunapaqqa? Kay pachapiqa mantakuqkuna piñakunllapa, chaymanta-shuypaqa pulla ĉhiqninllapa Tayta Dyusta. Chaynulla Dyus Akrashan Cristuntapis ĉhiqninllapa’. ");
INSERT INTO qufNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Tayta Dyus, chiqaptami David nishannulla kasha. Gubyirnu Herodes, mantakuq Poncio Pilato kay pwiblupi tantakaranllapa, uklawmanta runakunawan, chaynulla kay Israel pwiblumanta runakunawan ima, chay akrashayki kusa allinla Wamrayki Jesusta ĉhiqnir. ");
INSERT INTO qufNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Chaynu katinmi, ruraranllapa qam imanuĉhi yaĉhaynikiwan pasananpaq nisha karayki chaynulla. ");
INSERT INTO qufNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Kananqa Taytituy rikay-ari imanu abisar dijashallapa nirmapis. Chaynu katinmapis kay sirbishuqnikikunata yanapamayllapa shachinakur qampa rimanaykita yaĉhachikunayllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Qampa pudirnikiwan yanapamatkillapa, mana ruraypaqkunata, kusa shumaq milagruta ruranayllapapaq. Chaynulla qishaqkunata allichanayllapapaq ima, kusa allinla Wamrayki Jesuspa shutinwan” nir. ");
INSERT INTO qufNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Chaynu nir mañakur tukchitinllapaqa, chay tantakashanllapa wasiqa kuyuq qallariran. Chaymi chay kutilla, tukuyninta Santu Ispiritu balurta qur yanaparan. Chaymi chaymanta-pacha ashwan mana manchakur imanachu mas animakur ima rimaq qallariranllapa Dyus nishanlatana. ");
INSERT INTO qufNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Tukuy kriyiqkunami achka karllapamapis, chayllata yarpuqllapa. Manami mayqanpis niqchu, chay imankunaqa paylapaqna kanqa nirqa. Tukuyninllapami niq tukuy imanllapaqashi tukuypaq kanqa nir. ");
INSERT INTO qufNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Chaynu katinmapis, Dyus pudirninwan yanapatin apustulkunaqa rimayaranllaparaq, Amitunchik Jesucristo imanumi wanushanmanta kawsamuran nir. Chaymi Tayta Dyusqa tukuyninta yanapatin shumaqta kawsaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Manami paykunamantaqa, mayqanlapis imakunata ministiqkunaqa karanllapachu. Chaqa achka pachayjun, mas wasiyjun ima kaqkunaqa, chay imankunata rantikur, qillayninllapataqa, ");
INSERT INTO qufNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","apustulkunata quqllapa, paykunana ministiqkunataqa qutinllapa ima ministishanllapamatapis rantinanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Karanmi Chipre shutiq pwiblumanta uk Levita, José shutiq runa. Paytami apustulkunaqa niqllapapis Bernabé (rimayninchikpi munan niyta “Kunsulakuq”) nir. ");
INSERT INTO qufNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Paymi pachayjun kar, chay pachanta rantikur apustulkunata quran qillaytaqa. ");
INSERT INTO qufNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Piru karanmi uk runa Ananías shutiq. Paymi warmin Safirawan pulla rantikuranllapa uk pachata. ");
INSERT INTO qufNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Kay runami warminwan pulla parlaran pachanta rantikur wakin qillayta aypar wakinlata apustulkunataqa qur ninanllapapaq: “Kaylami rantikushayllapa qillayqa” nir. Chay parlashanllapanullami ruraranllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Chaynu llullakushanpaqmi Pedruqa niran: —Ananías ¿imapaqtaq Satanaspa yarpuyninta, shunquykipi ratakuchir Santu Ispirituta llullachiyta kamashayki, chay pachapaq pagrashushanmanta wakin qillayta aypar wakinlatana ‘Kaymi tukuynin’ nir qumashaykillapa? ");
INSERT INTO qufNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Chaqa manachu qampa karan chay pachaqa? Chaytaqami rantikushayki. ¿Manachu qampa karan chay qillayqa? ¿Imata yarpurtaq kaytaqa rurashayki? Manami runakunatachu llullachishayki. Dyustami llullachiyta kamashayki nir. ");
INSERT INTO qufNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Chaynu Pedro nitin, uyaparmi Ananiasqa das ratar wanuran. Chaymi tukuy chaypi uyakuqkunaqa kusata manchakuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Chaymantaqa musu runakuna shamur, chay wanushataqa raĉhpawan pillur aparanllapa pampaqqa. ");
INSERT INTO qufNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ananías wanushana katin, kimsa uramanta yupayqa, chay kayashanllapamanqa yaykuran Ananiaspa warmin, mana imata yaĉharlamapischu. ");
INSERT INTO qufNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Chaymi Pedro tapuran kaynu nir: —Nimay ¿chiqaptachu qamkunaqa rantikuraykillapa chay pachataqa, qamkuna niyashaykillapanula? nir. Payqa niran: —Arí, chaynu nishushayllapanumi rantikurayllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Chaynu nitinmi, Pedruqa chay warmita niran: —¿Imapaqtaq qamkunaqa parlashaykillapa chayllata rimar, Amitunchikpa Ispiritunta llullachiyta kamanaykillapapaq? Chaytami runaykita pampaqkunaqa shamuyanllapa. Kananqami qamtana apashunqallapa pampaqqa nir. ");
INSERT INTO qufNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Chaynu Pedro nitinmi Safirapis, Pedrupa ĉhakinman ratar wanuran. Chaymanta chay musu runakuna yaykurqa, wanushatana tarir, aparanllapa runan pampakashanllaman pampaqqa. ");
INSERT INTO qufNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Chaymi Jesucristupi tukuy kriyiqkuna, chaynulla wakin runakunamapis, chayta yaĉharllapaqa kusalata manchakuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Tayta Dyusmi, apustulkunata yanapatin ruraranllapa kusa shumaq mana ruraypaqkunata chaynulla kusa achka milagrukunata runakunapa naypanpiqa. Chaymi tukuy kriyiqkuna tantakaqllapa Salomón rurashan kurridurpi. ");
INSERT INTO qufNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nataq mana kriyiqkunaqami paykunawanqa mana pulla kayta munaqllapachu manchakushanllaparayku. Piru chaynumapis kusalata paykunataqa alabachiqllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Chaymi Amitunchikpi kriyiqkunaqa ullquraq, warmiraq kusalata achkayayaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Chaqa, achka runakuna qishaqninllapakunata wasinmanta urquqllapa kallikunaman pununakunapi, parakunapi ima. Chaynumi Pedro pasatinqa, qishaqkunapa ananta llantunlamapis pasanman nir yarpuqllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Chaymi Jerusalén pwiblupa shipchankunamanmatapis, runakunaqa apamuran qishaqninkunata, tukuy chay dyablupa yarpuyninrayku yaruyashakunamatapis. Chaynumi tukuy shamuqkunaqa alliyaqllapa qishayninllapamantaqa. ");
INSERT INTO qufNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Chaymantami chay kurakunapa mantaqninwan, chay saduceo runakunaqa apustulkuna Jesucristupaq yaĉhachikutin achka runakuna kriyishanllaparayku kusalata ĉhiqniranllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Chaymi paykunataqa aypar, karsilman itaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Piru Amitunchikpa uk angelnin tuta chaypi rikarirmi, karsilpa punkunta kiĉhar lluqshichimuran kaynu nir: ");
INSERT INTO qufNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Riyllapa, Dyusta adurananllapa wasiman. Chaypimi shar yaĉhachikuyllapa tukuyta mushuq bidapaq, imatami ruranqallapa nir”. ");
INSERT INTO qufNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Chaynu ángel nishannullami, allaqmantaqa amsaq amsaqla Dyusta adurananllapa wasiman yaykur, yaĉhachikuq qallariranllapa. Piru chaykamanqami, kurakunapa mantaqninqa, paywan pulla kaqkunawan, qayamuranllapa kusa mas karguyjunkunata, chaynulla Israel runakunapa ruku mantaqninkunata ima, tantakar parlananllapapaq. Chaymi kaĉhakuranllapa apustulkunataqa karsilmanta apamunanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Piru kuytakuqkuna karsilman rirqa, apustulkunataqa mana tariranllapachu. Chaymi tikrakamurqa kaynu niranllapa: ");
INSERT INTO qufNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—Karsilpa punkuntaqami alli kirpakashata tarinillapa. Chaynulla chay kuytakuq suldadukunatapis, karsilpa punkunpi allita chapar kuytakur shaqta tarinillapa. Piru punkuta kiĉharqa, mana mayqantapis tarinillapachu ruripiqa nir. ");
INSERT INTO qufNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Chaynu nitinllapa, chay kurakunapa mantaqnin, Dyusta adurananllapa wasipa kuytakuqninkunapa mantaqnin, chaynulla kurakunapa wakin mantaqninkuna ima uyaparqa, ninakuqllapa: “¿Imanutaq lluqshisha kanqaqa? ¿Kanan-shuypaqa imanuraq tukushunllapa?” nir. ");
INSERT INTO qufNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Chaymi chay kutilla, ukqa ĉhar niran paykunataqa: —Qamkuna runakunata karsilman itaraykillapa, chaykunaqami achka runakunata Dyusta adurananllapa wasipi yaĉhachiyan nir. ");
INSERT INTO qufNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Chaymi chay kuytakuqkunapa mantaqnin wakin kuytakuqkunawan rir maskar tariranllapa. Piru chaynu tarirmapis, manami qischaranllapachu. Chaqa manchakuyaranllapari “Runakuna rumillawan sitamachuwanllapa” nir. ");
INSERT INTO qufNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Chaymantaqa aparanllapa kusa mas karguyjunkuna tantakasha karanllapa chayman. Chaymi chay kurakunapa mantaqninqa kaynu niran: ");
INSERT INTO qufNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Nuqakunaqami allita willashurayllapa, amana Jesuspa shutinta rimarqa yaĉhachikunaykillapapaqnachu. Chaynu katinqa ¿imatataq qamkunaqa rurashaykillapa? Chaqa chaynu yaĉhachikutkillapami, tukuyla Jerusalén pwibluta shikwakasha. Chaynullami anallan uchachamanayankillapa chay runa wanushanpaqmapis nir. ");
INSERT INTO qufNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Chaymi Pedro chay wakin apustulkunawanqa niranllapa: —Nuqakunaqami runakunata naypaqta kasunayllapamantaqa, Dyustaraq kasunillapa. ");
INSERT INTO qufNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Chaqa unay rukunchikkunapa Dyusninmi, Jesusta qamkuna kruspi klabar wanuchitkillapamapis qashan kawsachimuran. ");
INSERT INTO qufNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Chaynu kawsachimurmi syilupiqa allilaw qichqanpi tachisha. Chaymi nisha puytiq Mantakuq, Washakuq ima katin tukuy Israel runakuna Dyusmanna tikrakatin, uchanllapamanta pirdunananpaq. ");
INSERT INTO qufNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Chaymi nuqakuna, chaynulla Santu Ispiritu ima tistigu kanillapa tukuy chaykunapaqqa. Chaqa Dyusmi payta kasuqkunataqa Santu Ispiritunta qusha nir. ");
INSERT INTO qufNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Chaynu apustulkuna niqta uyaparqa, karguyjunkunaqa kusalata piñakur, apustulkunataqa wanuchiyta yarpuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Piru chay kusa mas karguyjunkunamantami kaq uk fariseo runa Gamaliel shutiq. Paymi Moisés mantakushanta kusata yaĉhar yaĉhachikuq katin, kusalata rispitaqllapa wakin runakunaqa. Chaymi sharir, kaĉhakuran apustulkunata uk ratituta waqtaman lluqshichinanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Chaymantami wakin karguyjunkunataqa niran: —Israel runakuna, allita intrakankillapa. Kuytakankillapa chay runakunamantaqa imata ruranayarllapamapis. ");
INSERT INTO qufNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Yarpuyllapa qamkuna. Uk tyimpupi Teudas shutiq runa kusa puytiq kayta munatin, kwatru-syintus runakuna yupay paypi kriyir ikinpi puriranllapa. Piru chaymantaqa chay runata wanuchitinllapaqa chay ikinpi puriqkunaqa wakta kayta shikwakar tukukaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Chaymanta qashan uk tyimpupi, sinsuta ruratinllapaqa, Galileamanta uk runa Judasna rikariran. Chaymi paypi kriyir puriqkunapis karanllapa. Piru chaytapis wanuchiranllapa. Chaynullami, chay ikinpi puriqkunaqa wakta kayta shikwakaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Chayraykumi nishunillapa, chay runakunataqa ama imatapis rurarchu, dijanaykillapapaq. Chaqa chay runakuna yanqa runakunapa rimayninkunalata rimayarqa, chinqanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Nataq Dyuspa rimayninwan katin-shuypaqa manami imanu tukurpis binsiyta puytinkillapachu. ¡Kuytakankillapami! ¡Imanupiqakish Dyuspa kuntranmana, shachinakuq qallaritkillapa!” nir. ");
INSERT INTO qufNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Chaynu Gamaliel nitinmi, chay karguyjunkunaqa “Allinmi chayqa” niranllapa. Chaymantaqa apustulkunata qayamur kusata llibachir ima, willaranllapa, amana Jesuspa shutinpi rimar yaĉhachikur purinanllapapaqnachu. Chaynu allita willar imaqa, kaĉharanllapana. ");
INSERT INTO qufNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Piru chaynu ruratinllapamapis, apustulkunaqa chay karguyjunkunapa naypanmantaqa kusala aligrina lluqshiranllapa. Chaqa Dyusmi paykunataqa akraran Jesucristurayku chaynu qischakananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Chaymi ashwan waran waran Dyusta aduranllapa wasikunapi, tananllapa wasikunapi ima mana manchakurlamapischu Dyuspa shumaq rimayninta yaĉhachikuqllapa, Jesusmi Dyus Akrashan Cristun nir ima. ");
INSERT INTO qufNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Chay tyimpuqa Dyuspi kriyiqkuna mastana achkayaq qallarisha katinllapanaqa, chay griego rimaypi rimaqkunaqa rimapakuqllapa chay hebreo rimaypi rimaqkunapaqqa, kaynu nir: “Chay griego byuda warmikunaqashi, chay hebreo byuda warmikuna yupayqa mana aypaqchu kasha chay ministiyashan qukuyashanllapamantaqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Chaymi chay dusi akrakasha apustulkunaqa, tukuy kriyiqkunata tantar niranllapa: —Manami allinchu nuqakuna Dyuspa rimananta yaĉhachikuyashayllapata dijar, mikuy tantashanchikllapata qukunayllapapaqqa. ");
INSERT INTO qufNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Chayrayku kriyiq masiykuna, qamkunallamanta akrayllapa syiti runakuna, kusa allin yarpuyniyjun, kusa intrakaq, Dyuspa Santu Ispiritunwan kaqkunata ima. Paykunatana willatiyllapa, kay ruraykunataqa rurananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nuqakunaqami Dyusman mañakur ima, paypa rimayninta yaĉhachikushaqllapa maydiyapis nir. ");
INSERT INTO qufNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Chaymi Jesucristupi kriyiqkunaqa tukuynin “Allinmi chay nishaykillapaqa” nir, akraranllapa Estebanta. Paymi Amitunchikpi kusata kriyiq, chaynulla Dyusninchikpa Santu Ispiritunwan karan. Akraranllapapismi: Felipita, Procuruta, Nicanorta, Timonta, Parmenasta, Nicolasta ima. Pay Nicolasmi Antioquía pwiblumanta karan. Piru yaĉhakushami karan Israel runakunapa kustumrinkunata. ");
INSERT INTO qufNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Chaymantaqa aparanllapa paykunataqa chay apustulkunapa naypanman. Ĉhachitinllapaqa apustulkunaqa, chay syiti akrakashan runakunata, allitana Dyusta sirbinanpaq nir, paykunapa ananman makinkunata ĉhurar, Dyusman mañakuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Chaynulla, Dyus rimashantaqami tukuy parlakutinllapa, kriyiqkunamapis achkana karanllapa Jerusalenpiqa. Chaynullami, Jesucristupiqa chay Israelmanta kurakunamapis kusala achkana kriyiranllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Dyus yanapatinmi, Estebanqa ashwan kusala pudirniyjun kar, milagrukunata, mana ruraypaq shumaq imakunata ima ruraran tukuypa naypanpi. ");
INSERT INTO qufNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Chaymantami tantakananllapa wasi Libertos shutiqmanta wakin runakuna, chaynulla Cirene, Alejandría pwiblumanta kaqkuna, chaynulla chay Cilicia, Asia lugarmanta kaqkuna ima tantanakur, Estebanwan willanakuq qallariranllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Piru chay runakunaqa mana upallachiytaqa puytiranllapachu. Chaqa Estebanqa, Dyuspa Santu Ispiritun yanapatin, kusa shumaqta rimayaran. ");
INSERT INTO qufNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Chaymi Estebanta kuntraq runakunaqa mana imanupis binsiyta puytirqa, wakin runakunata pagraran rimananllapapaq Estebanpa kuntran kaynu nir: “Estebantami, Moisespa, chaynulla Dyusninchikpa kuntranta rimaqta uyapasha kanillapa” nir. ");
INSERT INTO qufNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Chaynu llullakutinllapami, runakunaqa kriyir tukuy ruku mantakuqkunawan, Moisés mantakushanta yaĉhar yaĉhachikuqkunawan tantanakur kusata piñakuranllapa. Chaynu piñakurllapami Estebantaqa aypar aparanllapa kusa mas karguyjunkunapa naypanman. ");
INSERT INTO qufNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Chaynulla tistigukunatapis, Estebanpa kuntran rimar llullakunanllapapaq maskaranllapa. Chaymi kaynu niranllapa: —Kay runaqami kusa saqra mana rimaypaqkunata waran riman Dyuspa wasinpaq, chaynulla kusa allin mantakushanpaqmapis. ");
INSERT INTO qufNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Chaynullami uyapasha kanillapapis kaynu niqta: ‘Nazaretmanta Jesusshi, Dyuspa wasinta ratachiyanqa. Chaynullashi Moisés kustumrinta qumashanchikllapatapis ukmanpaqna tikrayanqa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Chaynu nitinllapami, tukuy kusa mas karguyjunkuna, Estebanta chaparqa, rikaranllapa kusa angelnula qaqllitayjunta. ");
INSERT INTO qufNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Chay kurakunapa mantaqninmi Estebantaqa kaynu nir tapuran: —Qampaq chaynu rimayashanllapaqa, ¿chiqapchu, manaqachu mana? nir. ");
INSERT INTO qufNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Chaymi Estebanqa niran: “Ukniykuna, taytituykuna allita uyapamayllapa: Kusa puytiq Taytanchik Dyusmi, unay rukunchik Abraham Mesopotamia pwiblullapi kar, manaraq Harán pwibluman taq riyatin, payman rikariran. ");
INSERT INTO qufNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Abrahamtaqa niran: ‘Pachaykita, aylluykikunata dijar, riy chay pachata nuqa rikachishuyani chayman’ nir. ");
INSERT INTO qufNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Chaynu nitinmi, Abrahamqa chay tayashan Caldea pwiblumantaqa lluqshir rir, Harán pwibluman ĉhar, chaypina taran. Chaymanta taytan wanutinqa, Abrahamtaqa Tayta Dyus apamuran, kay tayashanchikllapa Israel pachamanqa. ");
INSERT INTO qufNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Piru kaypiqami Abrahamtaqa mana irinsyantaqa quranchu, uk ĉhakisitunta sarukuchinanlapaqmapis. Piru mana kaypi qurmapis, arniranmi pay wanutinqa wamrankunana kay pachapiqa tananllapapaq. Chaynumiri arniran manaraq wamranmapis kayatinraqchu. ");
INSERT INTO qufNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","“Chaynullami Dyusqa niranpis: ‘Aylluykikunaqami kay tayashanllapamantaqa lluqshir rir uklaw pachakunapi kwatru-syintus (400) añuta tanqallapa furastirukuna yupay, kusata sirbikur, qischakar ima. ");
INSERT INTO qufNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Piru chay nasyun aylluykikunata sirbikuchir qischaqkunataqami nuqa kastigashaq. Chaymantami paykunaqa lluqshir shamur, kay lugarpina sirbimanqallapa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Chaynu nirmi Dyusqa Abrahamwan uk tratuta ruraran, tukuy Israelmanta kaqkunaqa siñal kustumrita rurananllapapaq nir. Chaymi Abrahamqa wamran Isaac nasishanmanta uchu diyayjunna katinqa siñal kustumrita ruraran. Chaynullami Isaacpis wamran Jacobo nasitinqa ruraran. Chaymi Jacobupis wamrankunawan chay Israel runakunapa dusi pwiblunkunapa rukunkunawanqa ruraran. ");
INSERT INTO qufNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Chay dusi rukunchikllapamantami uknin shutiq José. Paytami ukninkuna ĉhiqnir Egiptuman rantikuran. ");
INSERT INTO qufNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Piru Tayta Dyusmi, Josiwan kar, qischakatinmapis kusata llakipar kusa yaĉhaqpaq imana tikraran Egiptupa mantaqnin Faraonpa naypanpiqa. Chaymi ashwan Faraonqa, Josita numraran pay mantakuna wasinpi, chaynulla chay pwiblupa mantakuqninna kananpaq. ");
INSERT INTO qufNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Piru chaymantami chay Egipto pachapi chaynulla Canaán pachapiqa kusala mallaq tyimpu katin, kusalata qischakaranllapa. Chaqa manari imapis karanchu rukunchikllapakuna mikunanllapapaqqa. ");
INSERT INTO qufNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Chaymantami, Jacobuqa Egiptupishi trigu kan nir yaĉharqa, kaĉharan wamrankunata, chay rukunchikkuna karan chaykunata. Chaymi paykunaqa riranllapa puntataqa. ");
INSERT INTO qufNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Qashan ishkay kutipaqna ritinllapaqa, Josiqa ukninkunata niran, payqashi ukninllapa nir. Chaynu José ukninkunata nitinmi, Faraonqa yaĉharan mayqan ayllumantami Josiqa nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","“Chaymi Josiqa kaĉhakuran taytan Jacobuta, tukuy aylluntinta apananllapapaq. Tukuy ayllunkunaqami sitintay sinku (75) kasha kanqallapa. ");
INSERT INTO qufNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Chaynu rirmi Jacobuqa Egiptupi tayar, chaypina wanuranmapis. Chaynullami unay rukunchikllapakunamapis chaypi wanuran. ");
INSERT INTO qufNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Chaymantaqa Jacobupa kwirpunta aparanllapa Abrahampa unay tashan pwiblu Siquempi pantyunninman pampaq. Chaqa chaytaqami Abraham rantisha karan, uk runa Hamor shutiqpa wamrankunamanta. ");
INSERT INTO qufNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Taytanchik Dyusmi, Abrahamta tukuy ima pasayanqa nir arnishan tyimpu shipchamuyatinnaqa, Israel runakunaqa kusala achkana karan Egiptupiqa. ");
INSERT INTO qufNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Chay tyimpumi Egiptupiqa mantakuran uk gubyirnuna. Payqami Jositaqa mana riqsishachu karan. ");
INSERT INTO qufNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Chaymi chay gubyirnuqa ingañar ima kusalata qischaranllapa unay rukunchikkunataqa. Chaynullami mantakuranpis ullqu wamritukuna chayraq nasitinqa, dijatinllapa wanur amana achkayananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Piru chay tyimpupimi Moisés nasiran. Paymi kusala shumaq wamritu karan Dyuspaqqa. Chaymi Dyus yanapatin taytankunaqa wasinpi pakaqnula kimsa misista purichiranllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Chaymanta wasinpi manana pakayta puytir waqtalapi dijasha katin, Faraonpa warmi wamran tarir apar, kusa shumaqta kriyakuran wamranta yupay. ");
INSERT INTO qufNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Chaynumi Moisesqa winaran Egipto runakunapa yaĉhayninkunata kusata yaĉhakur. Chaymi Moisesqa kusa puytiq karan rimananpaq, chaynulla imata rurananpaqmapis. ");
INSERT INTO qufNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Kwarinta añuyjunna karqa, Moisesqa watukuran Israel masin runakunata, paypa chiqap ayllunkuna katin. ");
INSERT INTO qufNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Chaymi Egiptumanta runa, paypa ayllu masinta maqaqta rikarqa, washananrayku chay Egiptumanta chaytaqa wanuchiran. ");
INSERT INTO qufNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Chaqa payqari yarpuran, Israel aylluykunaĉhi allita kwintata qukar ninqallapa: ‘Dyusmi, Moisesrayku Egipto runakunamanta washamashunllapa’ nir. Piru paykunaqa mana kwintata qukaranllapachu. ");
INSERT INTO qufNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Chaymanta, allaqnin ishkay Israel runakunata maqanakuqta tariran. Chaymi payqa washanachiyta yarpur niran: ‘Qamkunaqami chay ayllulla kankillapa, ¿imapaqtaq uknikillapa uknikillapaqa maqanakur ima qischanakunkillapa?’ nir. ");
INSERT INTO qufNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Piru ukninta masta qischaq chayqa, Moisesta kumsar niran: ‘¿Pitaq qamtaqa uk mantakuq jwista yupayqa ĉhuramushusha nuqakunamanqa? ");
INSERT INTO qufNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Manaqachu qamqa, quya imanuĉhi uk Egiptumanta runata wanuchirayki, chaynulla nuqatapis wanuchimanayanki?’ nir. ");
INSERT INTO qufNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Chaynu nitinmi, Moisesqa alsakar riran Madián shutiq pachaman. Chaypimi furastiru yupay tayatin, ishkay wamrankuna nasiran. ");
INSERT INTO qufNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Kwarinta añuna pasasha katin Moisés chunllaq lugar Sinaí sirkapi kayatinmi, sarsapi nina ratakuq rurimanta uk ángel payman rikariran. ");
INSERT INTO qufNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Chaymi Moisés chayta rikarqa kusalata dispantakaran. Chaymanta mas qimikar rikashaq niyarqa, uyaparan Amitunchik kaynu niqta: ");
INSERT INTO qufNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Nuqami unay rukuykikuna Abrahampa, Isaacpa, Jacobupa Dyusnin kani’ nir. Piru Moisesqa kusalata manchakur chukchukyashanrayku, mana chapanaranlamapischu. ");
INSERT INTO qufNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Chaymi Amitunchikqa kaynu niran: ‘Llanqikita urquy. Chaqa kay lugar kayashaykiqami, kusa santu lugar. ");
INSERT INTO qufNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nuqami allita rikasha kani pwibluymanta runakuna imanu Egiptupi qischakatinmapis. Paykunatami uyapasha kani kusata llakir qayĉhakutinmapis. Chayraykumi ishkimusha kani paykunata washanaypaq. Chaymi shamuyna. Chaqa Egiptumanmi kaĉhashuyani’ nir. ");
INSERT INTO qufNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Unaymi paykuna, Moisesta disprisyar ‘¿Pitaq kaĉhashusha mantakuq jwis yupay kanaykipaq?’ niranllapa. Piru Dyusmi kaĉharan mantakuq kar washakunanpaq, imanutaq angelnin chay sarsa rurinpi rikar intrachishannulla. ");
INSERT INTO qufNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Chaymi Moisesqa, milagrukunata, chaynulla mana ruraypaq shumaq imakunata rurar ima Egiptumantaqa lluqshichir unay rukunchikkunataqa apar pasachiran chay chupika mar yakupa rurinta. Chaynumi milagrukunata rurar ima, chay chunllaq lugarkunapi kwarinta añuta puriran. ");
INSERT INTO qufNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Chaqa Moisesllami Israel runakunatapis niran: ‘Dyus Amitunchikmi qamkunamanta ukta akranqa nuqa yupay rimaqnin kananpaq. Chayna qamkunaqa kasunaykillapapaq’ nir. ");
INSERT INTO qufNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","“Israel runakuna chunllaq lugarpi tantakasha katinmi, Moisesta, angelqa Sinaí sirkapi shumaq imakunata willaran. Payna rukunchikkunata imanu kawsananllapapaq nir intrachitin, nuqanchikkunatapis intrachimashallapa kasurna kawsanallapapaq. ");
INSERT INTO qufNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Piru rukunchikkunaqami mana uyakunar disprisyashanllaparayku ashwan Egiptuman tikrakanaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Chaymi Aaronta niranllapa: ‘Moisés Egiptumanta urqumaranllapa chayqa, mana rikarinnachu. Chayraykumi dyuskunata ruratki, yanapar Egiptuman apamananllapata munanillapa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Chaynu nitinllapami, Aaronqa ruraran uk dyus bisirrunuta. Chaynami animalkunata wanuchir, rupachir imana fyistata rurar aduraranllapa chay paykunalla rurashan dyustaqa. ");
INSERT INTO qufNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Chayraykumi Dyusqa paykunamanta ashur, dijaran syilupi tukuy ima kaqkunata adurananllapapaq. Chaqa chaypaqmi Dyus nitin, rimaqninkunaqa kaynu nir iskribisha kayaq: ‘Israel runakuna, ¿qamkunachu chay kwarinta añukunata chunllaq lugarpi karqa, animalkunata wanuchir, ufrinditata ĉhurar ima aduramaraykillapa? ");
INSERT INTO qufNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ashwanmi qamkunaqa chay yanqa dyus Molocta andasninpi purichiraykillapa. Chaynullami Refán qullarpa ritratunta ima rurar dyus nir aduraraykillapa. Chaykunata adurashaykillaparaykumi, nuqaqa pwibluykimanta urqur, Babilonia pwiblumanmatapis mas wakaqman itakushaykillapa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Unay rukunchikkunami chay chunllaq lugarkunapiqa ruraran Dyusta adurananllapa tuldu wasita, imanutaq Dyus, Moisesta rikachir willaran chaynulla. Chaytaqami purichiqllapapis Dyuswan tratuta rurashanpaq yarpunanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Chay tuldu wasitaqami ayka añukunata purichiyarqa, Josuewan apar rir uk pwiblumanta kaqkunata binsir taran, Tayta Dyus arnishan pachapi. Chay tuldu wasiqami chaypiqa karan Davidpa tyimpunkaman. ");
INSERT INTO qufNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","“Davidtaqami Tayta Dyusqa shumaqta rikar, kusata yanaparan. Chaymi Davidqa mañakuran Dyusta adurananllapa wasita ruratin, chaypina Jacobupa Dyusnin tananpaq. ");
INSERT INTO qufNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Chaynu mañakusha katinmapismi, wamran Salomón ruraran Dyusta adurananllapa wasitaqa. ");
INSERT INTO qufNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Piru allita yaĉhashanchikllapanu syilumanta Taytanchikllapa Dyusqami, mana runakuna rurashan wasikunapichu tan. Chaypaqmi Dyuspa rimaqninqa kaynu nisha kayaq: ");
INSERT INTO qufNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Unaq syilumi, tar mantakunay. Nataq pacha-shuypaqa ĉhakiy shanan. ¿Imanu wasitataq rurayanqallapa nuqapaqqa? ¿Mayqantaq tanay wasiqa kanqaqa? ");
INSERT INTO qufNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Nuqami tukuy imata rurasha kani’ nir”. ");
INSERT INTO qufNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Chaynu Dyuspa rimaqnin nishanta willarmi, Estebanqa niranpis: “Qamkunaqami unaymanta kusala mana intrakaq, anku shunqukuna kankillapa. Chaynullami chay mana kriyiqkuna yupay mana kasukuq, mana shumaqta yarpuqkuna ima kankillapa. Chaynu karmi maydiyapis Dyuspa Santu Ispiritunpa kuntranla kankillapa. Chaynuqami unay rukuykillapa yupaylla kankillapa. ");
INSERT INTO qufNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Chaymi nimayllapa, ¿Dyuspa mayqan rimaqnintataq mana qischaranchu chay unay rukuykillapaqa? Paykunami, wanuchiranllapa Dyuspa Akrashan Cristunmi shamuyanqa nir yaĉhachikuqkunata. Piru chaynumapis Dyuspa Akrashan Cristun shamutinqa, kuntrankunaman qukur ima wanuchiraykillapa. ");
INSERT INTO qufNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Chaynullami Dyus mantakushanta angelkuna, Moisesta willatin, intrachishutinllapapis mana kasukuraykillapachu” nir. ");
INSERT INTO qufNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Chaynu Esteban nitinmi, payta kuntrashanllaparayku chay karguyjunkunaqa kusata piñakur kirunllapamatapis richyachiranllapa ima. ");
INSERT INTO qufNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Piru Estebanqami, Dyuspa Santu Ispiritunwan kar, unaq syiluman chapakur, Dyusninchikta kusa llipyaraqta rikaran. Chaynulla rikaranpis Jesús, Dyuspa allilaw qichqanpi shaqta. ");
INSERT INTO qufNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Chaymi Estebanqa niran: —¡Rikayllapa! ¡Syilutami rikani kiĉhakashata! Rikanipismi Dyusmanta Shamuq Runata paypa allilaw qichqanpi shaqta nir. ");
INSERT INTO qufNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Piru chaynu nitinqa, chay runakunaqa mana uyapanar rinrinllapata kirpar, qayĉhakur ima, tukuynin kallparanllapa Estebantaqa aypaq. ");
INSERT INTO qufNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Chaymanta ayparqa, chay pwiblumanta lluqshichir, rumikunawan sitaranllapa. Chaymi chay llullakuq tistigukunaqa raĉhpanllapata urqur inkargaranllapa uk musu runa Saulo shutiqta. ");
INSERT INTO qufNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Chaynu sitayatinllaparaqmi, Estebanqa mañakuran kaynu nir: “Amituy Jesucristo, ispirituyta rikapamanki”. ");
INSERT INTO qufNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Chaynu nirqa, qunqurikur kusala jwirtita rimar niran: “Taytituy, amami kay uchakushanllapataqa kwintachankichu” nir. Chaynu nirqami, wanuranna. ");
INSERT INTO qufNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Chayta rikarmi, Sauluqa yarpuran: Estebanta wanuchirqami allinta tukuyanllapa nir. Nataq chay kusala allin llakipakuq runakunalami Estebantaqa pamparanllapa kusata paypaq waqar ima. Chaymanta chay diyallami Jerusalenpiqa, Jesucristupi kriyiqkunapa ikinpi puriq qallariranllapa qischananllapapaq. Chaymi tukuy kriyiqkunaqa shikwakar, riranllapa Judeapa, Samariapa pwiblunkunaman. Piru apustulkuna-shuypaqa mana lluqshiranllapachu Jerusalenmantaqa. ");
INSERT INTO qufNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Chaykamanqami Sauluqa kusalata qischaq Jesucristupi kriyiqkunataqa. Chaymi wasin wasin yaykur, ullqutaraq warmitaraq aysaĉhakur lluqshichimuqllapa karsilman apananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Nataq Jerusalenmanta wakta kayta shikwakaqkunaqa, may rishankunapipis Dyuspa shumaq rimayninta yaĉhachikuranllapa kriyirna washakananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Paykunamanta uknin Felipimi, Samaria pwibluman rir ĉharqa, Dyuspa Akrashan Cristunpaq yaĉhachikuq qallariran. ");
INSERT INTO qufNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Chaynu yaĉhachikutinmi tukuyla tantakashakunaqa kusalata uyakuqllapa, Felipe imata nitinpis. Chaynullami rikaqllapapis Felipe, Dyuspa pudirninwan milagrukunata ruratin ima. ");
INSERT INTO qufNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Kusa achka runakuna dyablupa yarpuyninwan kaqkuna alliyaqllapa. Felipita uyar, dyablukunapa yarpuynin runakunata qayĉhachir, lluqshiqllapa. Chaynullami achka mana kuyuyta puytiq kwirpuyjunkuna, chaynulla kujukunamapis alliyaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Chaynu katinmi, chay pwiblupiqa tukuyla kusata aligriyaqllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Piru chaypiqami karan uk runa, Simón shutiq. Paymi unaymanta-pacha Samaria pwiblumanta runakunata wasqakur, kriyichisha karan: Payqashi kusa puytiq runa nir. ");
INSERT INTO qufNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Chaymi tukuy wamrantin, rukuntin paytaqa kusata uyakuqllapa. Paykunami niqllapa: “Kay runa, Dyuspa pudirninwan. Chayrayku tukuy riqchaq milagrukunata rurayta puytin” nir. ");
INSERT INTO qufNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Chaynu nir imami, paytaqa kusata kasuqllapa unaymanta-pacha wasqakur kriyichisha kashanrayku. ");
INSERT INTO qufNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Piru Felipe, Dyuspa shumaq rimayninta Jesucristupa shutinpi kriyirmi, Dyuspa mantakuyninpi kawsananllapapaq nir yaĉhachikutinmi, warmipis ullqupis kriyirna tukuyla shutikuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Chaynulla chay wasqakuq Simonpismi, Felipe nishanta kriyir, shutikuran. Chayna Felipipa pullan puriqna qallariran. Achka milagrukunata Felipe ruratin rikar, Simonqa kusalata dispantakaran. ");
INSERT INTO qufNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Chaymanta Jerusalenpi apustulkunaqa “Samaria pwiblupi runakunaqashi Dyuspa rimayninpi kriyishallapana” nir yaĉharqa, Pedruwan Juanta kaĉharanllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Paykunaqa Samaria pwibluman ĉharqa, Dyusman mañakuranllapa Santu Ispiritunwanna mushuq kriyiqkunaqa kananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Chaqa, manaraqmi kriyiqkunamanqa shamushachu karan, Dyuspa Santu Ispiritunqa. Piru paykunaqami shutikushallapana karan Amitunchik Jesucristupa shutinwanqa. ");
INSERT INTO qufNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Chaymi Pedruwan Juanqa, kriyiqkunapa ananman makinkunata ĉhuratin, Dyuspa Santu Ispiritunwanna paykunaqa kidaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Chaynu apustulkuna kriyiq runakunapa ananman makinkunata ĉhuratinllapa, Dyuspa Ispiritun paykunawan kidatin rikaran, chay Simonqa. Chaymi apustulkunata qillayta arnir, kaynu niran: —Chay pudirta qumayllapa, nuqapis makiykunata mayqanpa ananman ĉhuratiyqa, Dyuspa Santu Ispiritunwanna paykunaqa kananpaq nir. ");
INSERT INTO qufNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Chaynu nitinmi, Pedruqa niran: —Tayta Dyus pudirninta qumanchik chayta rantinashaykirayku, qillaynikiwan pulla chinqankillapa. ");
INSERT INTO qufNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Qamqa mana ima dirichuyjunchu kanki nuqakuna rurashayllapata ruranaykipaqqa. Chaqa qampa shunquykiqami Dyuspaqqa mana allinchu. ");
INSERT INTO qufNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Chaymi ashwan uchaykita dijar, Tayta Dyusman tikrakar mañakuy ichapis pirdunashunman chay mana allinta yarpushaykimantaqa. ");
INSERT INTO qufNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Chaqa yaĉhayanimi shunquykipiqa kusata inbidyakayanki nir. Chaymi uchaykiqa prisu yupayna purichishuyan nir. ");
INSERT INTO qufNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Chaynu Pedro nitinmi, Simonqa niran: —Amitunchikman mañakupamayllapari. Chaqa manami munanichu chay nimashaykillapanulla imapis pasamanantaqa nir. ");
INSERT INTO qufNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Chaymanta Pedruwan Juan, Dyuspa rimayninta yaĉhachikurllapanaqa, tikrakaranllapana Jerusalenman, Samariapa pwiblunkunapipis Dyuspa shumaq rimayninta yaĉhachikuqnu ima. ");
INSERT INTO qufNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Chaymantaqami Dyuspa uk angelnin Felipiman rikarir niran: —Sharir riy surlawman, Jerusalenman nanta rishaykinu Gaza pwiblukaman. Chay nanqami chunllaq lugarta pasan. ");
INSERT INTO qufNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Chaymi Felipiqa sharir, riran. Riyarmi, nanpiqa rikaran Etiopía pwiblumanta uk runata. Payqami uk kusa karguyjun eunuco karan. Chay payllami gubyirna Candace shutiqpa imankunata rikaq. Chay runami risha karan Jerusalenman Tayta Dyusta aduraq. ");
INSERT INTO qufNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Chaymanta qashan pwiblunman tikrakar, uk karritapi tasha riyaran, Dyuspa rimaqnin Isaías iskribishan libruta liyiqnu. ");
INSERT INTO qufNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Chaymi Dyuspa Ispiritun Felipitaqa niran: —Rir qimikay wak karritaman nir. ");
INSERT INTO qufNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Chaymanta Felipe chay karritaman qimikar chay runa, Isaiaspa librunta liyiqta uyaparqa, kaynu nir tapuran: —¿Intrakankichu kay liyiyashaykitaqa? nir. ");
INSERT INTO qufNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Chaynu taputinqa chay runaqa niran: —¿Imanunari intrakashaq, mana mayqanpis intrachimatinqa? nir. Chaymi Felipitaqa rugaran kaynu nir: —Karritayman iqamur qichqaypi tay nir. ");
INSERT INTO qufNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Nataq chay librupi liyiyashanqami kaynu niyaran: “Imanutaq Uyshata wanuchitin, millwanta rututinllapamapis uyarala, chay yupaymi paypis mana imatapis rimaranchu. ");
INSERT INTO qufNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Pinqaypaqta ruraranllapa. Chaynulla mana llakiparchu, allin runa katinmapis uchacharanllapa. Piru mayqanpis mana yarpuranchu ¿imanumi payqa maydiyaqa kanqa? nirqa. Chaqa wanuchirna kay pachamanta ashuchiranllapa” nir. ");
INSERT INTO qufNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Chaymi chay karguyjun runaqa tapuran Felipitaqa kaynu nir: —Willamay-ari, ¿pipaqtaq rimayan kay Dyuspa rimaqninqa? ¿Payllapaqchu, manaqachu ukpaq? ");
INSERT INTO qufNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Chaymanta Felipiqa chay runa liyiyashanpaq willar, intrachiran Jesuspaq: “Imanumi washamanchikllapa” nir. ");
INSERT INTO qufNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Chayna parlar riyarllapaqa, uk lugar yakuyjun kaqta pasayarqa, chay karguyjun runaqa niran: —Kaypi kan yaku. ¿Manachu nuqapis shutikuyman? nir.  ");
INSERT INTO qufNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Felipiqa niran: —Tukuy shunquykiwan kriyitkiqami, puytini shutichishuyta. Chaymi chay runaqa niran: —Kriyinimi, Jesucristuqa Dyuspa Wamran nir. ");
INSERT INTO qufNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Chaymi karritanta yarachir, ishkantin ishkir, yaykuranllapa yakuman. Chaymi chaypina Felipiqa shutichiran eunucutaqa. ");
INSERT INTO qufNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Chaymanta yakumanta lluqshitinllapaqa, Amitunchikpa Ispiritun Felipitaqa illaqmanta apatin, chay runaqa mana rikarannachu. Piru chaynumapis ashwan kusa aligrina riran. ");
INSERT INTO qufNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Nataq Felipiqa Azoto pwiblupi rikariran. Chaymi pwiblun pwiblun riran, Dyuspa shumaq rimayninta yaĉhachikuqnu, Cesarea pwibluman ĉhanankaman. ");
INSERT INTO qufNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Chaykamanqa Saulo-shuypaqa mana shaykuq, rimapakur puriran, Amitunchikpi kriyiqkunata wanuchiyta yarpur. Chaymi kurakunapa mantaqninkunaman rir mañakuran uk urdinta. Chaywanna Damasco pwibluman rir, tantakananllapa wasikunaman yaykur Jesuspi kriyiqkunataqa tarir ullquta, warmita ima prisur Jerusalén pwibluman apamunanpaq. ");
INSERT INTO qufNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","4","Chaymanta, Damasco pwibluman rir ĉhayatinllapanaqa, nanpi illaqmanta kusala llipya intiru, syilumanta achkirachikamuran Saulo kayashanmanqa. Chaynu achkirachikamutinqa, pachaman ratar, uk rimayta uyaparan kaynu niqta: “¡Saulo, Saulo! ¿Imapaqtaq ikiypi puriyanki qischamanaykipaq?” nir. ");
INSERT INTO qufNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Chaymi Sauluqa niran: “¿Mayqantaq kanki, Taytituy?” Chay rimaqqami niran: “Nuqami Jesús kani, mayqanpa ikinpiĉhi qischanaykipaq puriyanki chay. Chaynu purirqami qamlla mana allintachu rurakayanki, imanuĉhi turumaqa yapukuyar, ikiman matqakur, rijapi ĉhachikarqa paylla nanachikun chay yupay”. ");
INSERT INTO qufNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Chaymi Sauluqa manchaysalla chukchukyayar, kaynu nir tapuran: “Taytituy, ¿imatataq ruranaypaq allin kanqa?” nir Amitunchikqa niran: “Sharir, riy Damasco pwibluman. Wakpimi willashunqallapa imatami ruranki nirmapis”. ");
INSERT INTO qufNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Chaynulla Sauluwan riqkunapis uyaparan chay rimaytaqa. Piru manami mayqantapis rikaranllapachu. Chaymi kusalata dispantakaranllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Chaymanta, Sauluqa ratashanmanta sharir, manana rikakuyta puytiranchu. Chaymi pullan kaqkunaqa, makinmanta aysakurna, aparanllapa Damasco pwiblumanqa. ");
INSERT INTO qufNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Chaypiqami kimsa diyatana karan mana chapakur; mana mikur, mana imatapis upyar imalamapischu. ");
INSERT INTO qufNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damasco pwiblupiqami taq Amitunchikpi kriyiq uk runa Ananías. Chaymi Amitunchikqa, rikapakuyninpi payman rikarir, kaynu niran: “¡Ananías!” Payqa niran: “Kaypimi kani, Taytituy” nir. ");
INSERT INTO qufNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Chaymi, Amitunchikqa niran: “Sharir, riy chay kalli Dirichu shutiqman. Chaypimi Judaspa wasinpi tapukuy uk runa Saulo shutiqpaq. Payqami Tarso pwiblumanta. Paymi Dyusman kusata mañakuyan. ");
INSERT INTO qufNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Chaymi, rikapakuyninpi rikashusha wasiman ĉhar yaykur, makikikunata ananpi ĉhuratki qashan rikakuyan” nir. ");
INSERT INTO qufNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Chaynu Amitunchik nitinmi, Ananiasqa niran: “Taytituy, kusa achka runakunami parlamashallapa paypaqqa, tukuy mana allinkunata Jerusalenpi qampi kriyiqkunata rurashanpaq. ");
INSERT INTO qufNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Kananqami chay runaqa kay Damasco pwiblumanna shamusha, kurakunapa mantaqninkuna kaĉhamutin, qampi kriyiqkunata apar prisunanpaq” nir. ");
INSERT INTO qufNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Chaynu nitinmapis, Amitunchikqa kaynu nir kaĉharan: “Riy. Chaqa paytami akrasha kani nuqapaq rimar yaĉhachinanpaq chay Israel runakunata, chaynulla mana Israel runakunata, gubyirnunkunata ima. ");
INSERT INTO qufNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nuqami paytaqa intrachishaq, nuqapaq rimar yaĉhachikurqa kusata qischakayanqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Chaynu Amitunchik nitinqa, Ananiasqa riran, chay maypiĉhi Saulo kayashanman. Chayman ĉharqa, wasiman yaykur Saulupa ananpi makinkunata ĉhurar, niran: —Kriyiq masiy Saulo, nanta shamuyatki Amitunchik Jesús qamman rikariran chay paymi kaĉhamasha nawiki rikakutinna, Santu Ispiritu qamwanna kananpaq nir. ");
INSERT INTO qufNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Chayta nitinmi chay kutilla, Saulupa nawinmantaqa pispa yupaylla wiqtikuna rataran. Chaymi qashan rikakurna sharir shutikuran. ");
INSERT INTO qufNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Chaymantaqa mikur kusa jwirsayjunna tikrakaran. Chayna Jesucristupi kriyiqkunawanqa pullana taran Damasco pwiblupiqa, ayka diyallataqa. ");
INSERT INTO qufNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Chaymantami Sauluqa, Damasco pwiblupiqa Israel runakunapa tantakananllapa wasikunapi yaĉhachikuran, “Jesucristuqa, Tayta Dyuspa Wamranmi” nir. ");
INSERT INTO qufNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Chaynu yaĉhachikutinmi, tukuy chay uyakuqkunaqa dispantakashalla ninakuqllapa: “¿Manachu kay runa Jerusalenpiqa, Jesuspi kriyiqkunapa ikinpi puriq prisur ima qischananpaq? ¿Manachu chaynu kar, kaymanpis shamuran Jesuspi kriyiqkunata prisur, kurakunapa mantaqninman qukunanpaq?” nir. Chaynu nir imami, paykunapura parlaqllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Piru chaynu ninakutinllapamapis, Sauluqa mana mayqantapis mancharchu, kusata animakur yaĉhachikuran: “Jesusmi, Dyus Akrashan Cristun chiqap washamaqninchikllapaqa” nir. Chaynu nir yaĉhachikutinmi, Damasco pwiblupi taq Israel runakunaqa alliplata yarpupakuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Chaymanta, ayka diyakuna pasatinnaqa, chay runakunaqa tantakar parlaranllapa Saulutaqa wanuchinanllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Piru Sauluqami yaĉharan, tukuy unaq, tukuy tutashi chay ĉhiqniqninkunaqa yarakuyan, chay pwiblumanta lluqshina punkupi, pay yarquqta wanuchinanllapapaq nir. ");
INSERT INTO qufNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Chaymi Jesucristupi kriyiqkunaqa Saulutaqa uk kanastaman itar, chay pwiblupa ridurninpi rumiwan llutakasha pata kaq chaypa ananman iqachir, chaylata tuta waqtalawman ishkichiranllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Chaymanta Saulo, Jerusalén pwibluman ĉharqa, Jesucristupi kriyiqkunaman pullachakayta munaran. Piru payta kusata manchashanllaparayku mana kriyiranllapachu, “Jesucristupi kriyiyanqa” nirqa. ");
INSERT INTO qufNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Nataq Bernabimi Saulutaqa aparan apustulkunaman. Chaymi apustulkunataqa parlaran, imanumi Sauluqa nanpi Amitunchikta rikatin, payqa parlaran, chaynulla imanumi yaĉhachikuran Amitunchik Jesuspaq Damasco pwiblupi, mana mayqantapis manchar imachu nir. ");
INSERT INTO qufNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Chaynami Sauluqa Jerusalenpi kidar, paykunawanna puriran. ");
INSERT INTO qufNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Chaynullami mana manchakur imachu Amitunchikpaq yaĉhachikuq, chay griego rimaq Israel runakunawan parlar, willanakur ima. Piru chay runakunaqami Saulutaqa wanuchiyta yarpuranllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Chaymanta kriyiq masinkuna chayta yaĉharmi, Saulutaqa Cesarea pwibluman apar, paypa pwiblun Tarsumanna kaĉharanllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Chaynami Judeapa, Galileapa, Samariapa pwiblunkunapi Jesucristupi kriyiqkunaqa kusa shumaqtana kawsaqllapa, mana qischakarnachu. Chaymi ashwan Amitunchik munashannulana kawsaqllapapis. Chaynulla Dyuspa Santu Ispiritun yanapatinmi, masna achkayaranllapapis. ");
INSERT INTO qufNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Chay tyimpukunapimi Pedruqa, Jesucristupi kriyiqkunata watukur puriq. Chaymi Lida shutiq pwiblupi taqkunatapis riran watukuq. ");
INSERT INTO qufNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Chayman ĉharqami, tarinakuran uk runa Eneas shutiqwan. Paymi mana kuyuyta puytiq kwirpuyjun kar, uchu añupaqna mantanlapi karan. ");
INSERT INTO qufNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Paytami Pedruqa niran: —Eneas, kananqami Jesucristo alliyachishunna. Chaymi sharir, mantaykita tantay nir. Chaynu nitinmi, Eneasqa chay kutilla allinna shariran. ");
INSERT INTO qufNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Chaymi, chay Lida pwiblupi, Sarón pwiblupi taqkunaqa, rikaran imanumi Eneas sharitinmapis. Chayta rikarmi, uchanllapakunata dijar, Jesucristupina kriyiranllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Lida pwiblupa shipchanpimi kaq uk pwiblu Jope shutiq. Chaypimi karan uk warmi, Amitunchikpi kusata kriyiq. Paymi shutiq Tabita. Nataq, griego rimaypi-shuypaqa “Dorcas” nir. Chay warmisitaqami kusa allinkunata rurar, mana imayjunkunata yanapar ima kawsaq. ");
INSERT INTO qufNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Chaymantami chay diyakunapiqa qishar wanuran. Chaymi kwirpuntaqa paqachir ima aparanllapa wasipa altun unakaqnin kwartuman chutarachiq. ");
INSERT INTO qufNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Chaymi chay Lida pwiblupi Pedro katin, Dorcaspa kriyiq masinkunaqa ishkay runata kaĉharanllapa, Pedruta kaynu willananllapapaq: “Dorcas wanusha katin, kananllashi rinki Jopiman, ama tardarchu” nir. ");
INSERT INTO qufNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Chaymi Pedruqa paykunawan riran. Chaymanta ĉhatinqa, aparanllapa Dorcas chutarayashanman. Chaypimi achka byuda warmikuna, Dorcaspa ridurninman tantakasha, kusata waqayaranllapa. Chaynu waqarllapami, Pedrutaqa uknin uknin rikachiranllapa, manaraq wanuyar raĉhpanta rurashankunata ima. ");
INSERT INTO qufNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Chayna Pedruqa, chay ruripi kaqkunataqa tukuyta waqtaman urqur, payqa qunqurikur Dyusman mañakuran. Chaymantaqa chay wanushata chapar, niran: —Tabita, shariy, nir. Chaynu nitinmi, chay warmisitaqa chay kutilla, nawinkunata chapakuchiran. Chayna Pedruta rikarqa, das taran. ");
INSERT INTO qufNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Chaymanta, Pedruqa makinmanta chutar sharichir, kriyiq masinkunata, byuda warmikunata qayar, Dorcastaqa kawsaqtana paykunapa naypanman apamuran. ");
INSERT INTO qufNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Chaymi chayta Jope pwiblupi yaĉharllapaqa, kusala achka kriyiranllapa Amitunchikpiqa. ");
INSERT INTO qufNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pedrupismi, achka diyakunata Jope pwiblupiqa kidaran, uk runa Simón shutiqpa wasinpi. Simonqami qarata blanduchar trabajaq. ");
INSERT INTO qufNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Nataq Cesarea pwiblupimi taq uk runa Cornelio shutiq. Paymi uk kwartil Italiano shutiqmanta suldadukunapa uk mantaqnin karan. ");
INSERT INTO qufNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Payqami mana Israel runa karmapis tukuy chay wasinpi ayllun taqkunawan Dyusta allipta kasur, aduraqllapa. Chaynu karmi, qillaynin kaqkunamatapis, Israel runa ministiqkunata qur yanapaq. Chaynulla waran waran Taytanchik Dyusman mañakuq. ");
INSERT INTO qufNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Chaymi uk diyaqa tardi, alas tris yupayna katin, Corneliuqa rikapakuyninpi Dyuspa angelninta rikaran. Chaymi Dyuspa angelninqa pay kashanman yaykur, kaynu niqta uyaparan: “¡Cornelio!” nir. ");
INSERT INTO qufNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Chaymi, Corneliuqa angelta kusata chapar manchakur, tapuran: “¿Imatataq munanki, Taytituy?” nir. Angelqa niran: “Tayta Dyusmi uyashusha, payman mañakutki. Chaynulla, mana imayjunkunata yanapatkipis, shumaqta rikashusha. ");
INSERT INTO qufNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Kananlla Jope pwibluman kaĉhakuy apamunanllapapaq uk runa Simón shutiqta. Paytami ninllapapis Pedro nir. ");
INSERT INTO qufNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Payqami tukayun Simón, qarata blanduchar trabajan chaypa wasin, mar yakupa manyanlapi, chaypi tayan. Chaymi shamurqa imata ruranaykipaqpis willashunqa”. ");
INSERT INTO qufNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Chaynu ángel parlar ritinnaqa, Corneliuqa uk suldadunta, chaynulla ishkay sirbikuqninta qayamuran. Chay suldadunqami Dyuspi kusata kriyiq. Chaynulla pay Corneliutapis kusata kasuq. Chaynu katinmi Corneliuqa chay suldadunpaq kusata yarpuq. ");
INSERT INTO qufNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Qayamur paykunata chay rikashanta manyaqla parlarqa, kaĉharan Jope pwibluman. ");
INSERT INTO qufNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Allaqninqa yaqqana Jopiman ĉhayatinllapa, alas dusi yupaynaqa Pedruqa iqaran wasipa ananman, Dyusman mañakunanpaq. ");
INSERT INTO qufNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Payqari kusata mallaqnar, mikunayaran. Chaymanta mikunanta kamakachinanllapakamanqa, rikapakuyninpi rikaran syilu kiĉhakaqta. ");
INSERT INTO qufNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Chaynu syilu kiĉhakatinqa unaqmanta ishkimuyaran uk atun pullu kada manyankunamanta watakasha. ");
INSERT INTO qufNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Chay pullu watakashapa rurinpiqa karan tukuy riqchaq mana mikuypaq animalkuna, kwatru ĉhakiyjun animalkuna, largu kurukuna, pariq kurukuna ima. ");
INSERT INTO qufNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Chay rikapakuyninpi uyaparanpis syilumanta kaynu niqta: “Pedro, sharir wanuchir, mikuy” nir. ");
INSERT INTO qufNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Piru Pedruqa niran: “Mana Taytituy. Chaqa chay riqchaq mana mikuypaq animalkunataqa mana mikushachu kani maydiyapis” nir. ");
INSERT INTO qufNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Chaynu nitinqa, qashan chay rimaqqa niran: “Tayta Dyus tukuy imatapis ‘Allin’ nishantaqa, ama ‘Mana allin’ niychu qamqa” nir. ");
INSERT INTO qufNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Chaynullamiri kimsa kuti willaran. Chaymantaqa qashan tikrakaranna syiluman chay pulluqa. ");
INSERT INTO qufNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pedruqa kusata yaĉhayta munaran chay riqchaq rikapakushanpaq, ¿imataq kanqa chayqa? nir. Chaypaq kusata yarpupakunankaman, Cornelio kaĉhashan runakunaqa ĉharanna Simonpa wasinmanqa, Pedrupaq tapukur. ");
INSERT INTO qufNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Chay wasiman ĉharnaqa kusa jwirtita rimar tapukuranllapa: —¿Kaypichu Pedro ninllapa Simón shutiq runa tan? nir. ");
INSERT INTO qufNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pedruqari chay riqchaq rikapakuyninpaq yarpuyatinlla, Dyuspa Santu Ispiritunqa niran: “Chapay. Kimsa runakuna maskashuyan. ");
INSERT INTO qufNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Sharir, ishkir paykunawan riy ama imapaqpis yarpupakurchu. Nuqami chay runakunataqa kaĉhamusha kani qamman shamunanllapapaq” nir. ");
INSERT INTO qufNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Chaymi Pedruqa wasipa ananmanta ishkimur, Cornelio kaĉhashan runakunataqa niran: —Nuqami kani Simón Pedruqa. ¿Imalapaqtaq shamushaykillapa? nir. ");
INSERT INTO qufNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Paykunaqa niranllapa: —Nuqakunami shamunillapa suldadukunapa kapitannin Cornelio kaĉhamatinllapa. Paymi allipta Dyuspi kriyin. Chaymi Israel runakunapis paytaqa kusata rispitanllapa, munanllapa ima. Pay Corneliumi kaĉhamashallapa paypa wasinman rir willatki uyakushunanpaq. Chaqa payqa nimaranllapa Dyuspa angelninshi willasha, qam rir wasinpi willatki uyakushunanpaq nir. ");
INSERT INTO qufNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Chaynu nitinllapaqami, Pedruqa samachiran wasin ruriman. Chaypimi pullana chay tutaqa kidaranllapa. Chaymanta allaqninqa paykunawan pullalla riranllapa. Chaynulla wakin chay Jope pwiblupi, Dyuspi kriyiqkunapis pullan yapar riran Pedrutaqa. ");
INSERT INTO qufNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Jope pwiblumanta lluqshirqa, allaqninraq Cesarea pwiblumanqa ĉharanllapa. Ĉhatinllapaqa, Corneliuqa ayllunkunawan amigunkunawan tantakasha, Pedrutaqa yarayasha karanllapa. ");
INSERT INTO qufNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pedro ĉhatinqa, Corneliuqa lluqshiran tariq, naypanpi qunqurikur adurananpaq. ");
INSERT INTO qufNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Piru mana chayta munarchu kaynu nir sharichiran: —Shariy taytituy. Nuqapismi qam yupay runala kani nir. ");
INSERT INTO qufNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Chaynu paywan parlaqnu riyar wasinman yaykurqa, chay wasi ruripiqa achka runa tantakashata tariran. ");
INSERT INTO qufNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Chaymantami Pedruqa tukuyta chaypi kaqkunataqa niran: —Qamkunaqami yaĉhankillapa nuqakunapa kustumriyllapata. Israel runakuna katiyllapa kustumriyllapaqami intrachimanllapa: Ama uklawmanta runakunawanqa tantakanayllapapaqchu, ama wasinmanmapis yaykunayllapapaq imachu. Piru Tayta Dyusmi yaĉhachimasha amashi pitapis nishaqchu: ‘Mana watukuypaqchu, mana allinchu ima’ nirqa. ");
INSERT INTO qufNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Chayraykumi qayachimatkillapaqa, utqaylla shamusha kani, mana imapaqpis ukmanta yarpur imachu. Chaymi yaĉhayta munanina ¿imalapaqtaq qayachimashaykillapa kanqa? nirmapis. ");
INSERT INTO qufNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Chaymi Corneliuqa niran: —Kananwanqa kwatru diyana, kay uras yupay nuqaqa kay wasiypi ayunar, Dyusman mañakuyaray. Chaykamanmi, naypaypi uk runa allipla yuraq intiru raĉhpayjun rikariran. Chaymi nimaran: ");
INSERT INTO qufNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‘Cornelio, Dyusman mañakutkimi, payqa uyapashusha. Chaynulla, mana imayjunkunata yanapatkipis payqa shumaqta rikashusha. ");
INSERT INTO qufNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Kaĉhay runakunata Jope pwibluman Simonta, Pedro ninllapa chayta apamunanllapapaq. Mar yakupa manyanpimi chay tukayun qarata blanduchar trabajaqpa wasinpi tayan’ nir. ");
INSERT INTO qufNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","“Chaynu nimatinmi, utqaylla kaĉhakuray shamunaykipaq. Qamqami mana ima mana allinkunataqa yarpurchu, ashwan utqaylla shamushayki. Kanan-shuypaqari tukuyla, kaypi kanchikllapa, Dyuspa naypanpi. Chaymi kusata uyakushuyta munanillapa, tukuy imata Amitunchik willashusha nuqakunata willamanaykillapapaq chayta rimatki” nir. ");
INSERT INTO qufNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Chaymantami Pedruqa paykunata niran: —Kananqami allita intrakanina, chiqaptami Dyusqa mana ukmanta ukmantachu rikamanchik maylawmanta kashamapis nir. ");
INSERT INTO qufNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ashwanmi maylaw nasyunmanta, ima ayllumanta karmapis payta kasusha, allinkunata rurashaqa, kusa munashan wamranpaqna riqsimanchik. ");
INSERT INTO qufNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nuqakuna Israel runakunatami willamashallapa, tukuypa Amun Jesusrayku, imanumi Dyuswanqa shumaqta kawsanayllapapaq nir. ");
INSERT INTO qufNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","“Qamkunaqami allita yaĉhankillapa Israel pwiblupi pasashantaqa. Naypaqtaqami Dyusninchikqa akraran Shutichikuq Juanta, Amitunchik Jesuspaq allita yaĉhachikunanpaq. ");
INSERT INTO qufNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Chaynulla yaĉhankillapapis, Taytanchik Dyus Nazaretmanta Jesusta Santu Ispiritunta, pudirninta qushanpaqmapis. Chaynu karmi Jesusqa allinkunalata rurar, runakunata dyablu qischatinmapis washaran, Dyus pullan katin nir imami yaĉhankillapa. ");
INSERT INTO qufNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Chaqa nuqakunami rikasha kanillapa Jesús tukuy imata Jerusalenpi, Judeapa pwiblunkunapi ima rurashanta, chaynulla kruspi klabar wanuchishanllapamatapis. Chaymi nuqakunaqa tukuy chaykunapaqqa tistigu kanillapa. ");
INSERT INTO qufNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Piru Dyus, kimsa diyamanta kawsachimutinmi, nuqakunaman rikariran. ");
INSERT INTO qufNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Manami tukuyla runakunamanchu rikarimuran. Ashwanmi Dyus nuqakunata tistigukuna kanayllapapaq akramashanllapakunalaman rikariran. Chaqa kawsamutinqami, paywan mikurayllapa, upyarayllapa ima. ");
INSERT INTO qufNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","“Chaymantami payqa kaĉhamaranllapa, rir tukuyta intrachinayllapapaq: ‘Dyusmi, Jesustaqa kaĉhamusha wanuqkunata, kawsaqkunata allita rikar yaĉhananpaq’ nir. ");
INSERT INTO qufNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Chaqa Dyuspa tukuy rimaqninkunami Jesuspaq kaynu nisha kayaq: ‘Tukuy paypi kriyitinllapashi tukuy uchankunamanta payqa pirdunayanqa’ nir”. ");
INSERT INTO qufNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pedro chaynu yaĉhachikuyatinmi, tukuy chay uyakuqkunamanqa Dyuspa Santu Ispiritun shamuran. ");
INSERT INTO qufNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Chaymi Santu Ispiritu uyakuqkunaman shamutinqa, Israelmanta kriyiq runakuna Pedruwan ĉhasha karan chaykunaqa, alliplata dispantakaranllapa. Chaqa chay uyakuqkunaqa ukman rimaykunapi Dyusta alabaqta uyaparanllapa. Chaymi yarpuranllapa: ¿Imanutaq Dyusninchikqa mana Israel runakunatapis Santu Ispiritunta qun? nir. ");
INSERT INTO qufNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Chaymi Pedruqa niran: —Nuqanchikkunata yupaylla kay runakunatapis Dyusninchik Santu Ispiritunta qusha katinqa, ¿ama shutikuychu niytachu puytinchik? nir. ");
INSERT INTO qufNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Chaynu nirnaqa kaĉhakuran Amitunchik Jesuspa shutinpina shutikunanllapapaq. Chaymanta shutikurnaqa, Pedruta kusata rugaranllapa ayka diyallataqa paykunawan kidananllapapaq nir. ");
INSERT INTO qufNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Apustulkuna, chaynulla Judea pwiblukunapi Jesuspi kriyiq runakunapis uyaparanllapana, “Chay mana Israel runa kaqkunapis, Dyusninchikpa shumaq rimayninpi kriyishallapana” nir. ");
INSERT INTO qufNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Chaymi Jerusalén pwibluman qashan Pedro ĉhatinnaqa wakin Israelmanta kriyiqkunaqa, paywan willanakuranllapa. Chaqa paykunaqa yarpuqllapa, mayqanpis Jesuspi kriyiq karmapis, paykunapa kustumrintapis rurananllapapaq nir. ");
INSERT INTO qufNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Chaymi Pedrutaqa tapuranllapa kaynu nir: —¿Imapaqtaq rirayki chay kustumrinchikta mana ruranllapachu chaykunapa wasinmanqa? Chaynulla ¿imapaqtaq paykunawan pulla mikushayki ima? nir. ");
INSERT INTO qufNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Chaynu taputinllapami, Pedruqa manyaqmanta parlaran tukuy ima pasashankunata, kaynu nir: ");
INSERT INTO qufNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Nuqaqa Jope pwiblupi karay. Chaypi kar Dyusman mañakuyarmi, rikapakuyniypi rikaray syilumanta uk atun pullu kada manyankunamanta watakasha nuqaman ishkimuqta. ");
INSERT INTO qufNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Chaymi, chaypa rurinman chapakurqa rikaray mana mikuypaq kwatru ĉhakiyjun animalkunata, utiq kurukunata, largu kurukunata, pariq kurukunata ima. ");
INSERT INTO qufNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Chaynullami uyaparaypis syilumanta kaynu nimaqta: ‘Pedro sharir wanuchir mikuy’ nir. ");
INSERT INTO qufNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Chaynu nimatinqa nuqaqa niray: ‘Mana Taytituy. Chaqa chay riqchaq mana mikuypaq animalkunataqa mana mikushachu kani maydiyapis’ nir. ");
INSERT INTO qufNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Chaynu nitiyqa, chay syilumanta willamaqqa qashan nimaran: ‘Tayta Dyus tukuy imatapis “Allin” nishantaqa, ama “Mana allin” niychu qamqa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Chaynullamiri kimsa kuti willamaran. Chaymantaqa chay pulluqa qashan tikrakaranna syiluman. ");
INSERT INTO qufNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Chay kutillami, chay wasi kayashaymanqa ĉharan kimsa mana Israel runakuna. Paykunataqami, Cesarea pwiblumanta kaĉhasha karanllapa nuqata apamananllapapaq. ");
INSERT INTO qufNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Chaymi, Dyusninchikpa Santu Ispiritun nimaran paykunawan rinaypaq, ama ukmanta yarpurlamapischu. Pullaymi riran kay saysi ukninchikkunapis. Tukuy paykunawanmi yaykurayllapa chay runapa wasinmanqa. ");
INSERT INTO qufNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Chaymi chay runaqa parlamaranllapa imanushi uk ángel wasinman yaykur kaynu willaran nir: ‘Jope pwibluman kaĉhakuy apamunanpaq uk runa Simón shutiqta, chay Pedro ninllapa chayta. ");
INSERT INTO qufNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Pay shamurmi willashunqa, imanumi qam, chaynulla tukuy aylluykikunamapis washakankillapa’ nir. ");
INSERT INTO qufNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Chaymi, paykunata yaĉhachiyatiyqa, Dyuspa Santu Ispiritunqa paykunaman shamuran, imanutaq uk kuti shamuran nuqanchikkunaman chaynulla. ");
INSERT INTO qufNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Chaymi chaymantaqa yarpuray Amitunchik nishanta. Chaqa niqmi: ‘Chiqaptami Shutichikuq Juanqa yakulawan shutichikuran. Piru Dyu