﻿USE sofia;
DROP TABLE IF EXISTS sofia.quctt_vpl;
CREATE TABLE quctt_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES quctt_vpl WRITE;
INSERT INTO quctt_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Are waꞌ ri kibꞌiꞌ ri e ratiꞌt umam ri Jesús rijaꞌl ri David, rijaꞌl ri Abraham. ");
INSERT INTO quctt_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ri Abraham are utat ri Isaac, ri Isaac are utat ri Jacob, ri Jacob are utat ri Judá xuqujeꞌ are kitat ri e rachalal. ");
INSERT INTO quctt_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ri Judá are utat ri Fares xuqujeꞌ ri Zera (are kinan ri Tamar), ri Fares are utat ri Ezrón, ri Ezrón are utat ri Ram. ");
INSERT INTO quctt_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ri Ram are utat ri Aminadab, ri Aminadab are utat ri Naasón, ri Naasón are utat ri Salmón. ");
INSERT INTO quctt_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ri Salmón are utat ri Booz (are unan ri Rahab), ri Booz are utat ri Obed (are unan ri Rut), ri Obed are utat ri Isaí. ");
INSERT INTO quctt_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ri Isaí are utat ri taqanel David, ri David are utat ri Salomón (are unan ri Betsabé, rixoqil kan ri Urías). ");
INSERT INTO quctt_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ri Salomón are utat ri Roboám, ri Roboám are utat ri Abdías, ri Abdías are utat ri Asá. ");
INSERT INTO quctt_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ri Asá are utat ri Josafat, ri Josafat are utat ri Jorán, ri Jorán are utat ri Uzías. ");
INSERT INTO quctt_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ri Uzías are utat ri Jotán, ri Jotán are utat ri Acaz, ri Acaz are utat ri Ezequías. ");
INSERT INTO quctt_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ri Ezequías are utat ri Manasés, ri Manasés are utat ri Amón, ri Amón are utat ri Josías. ");
INSERT INTO quctt_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Xuqujeꞌ ri Josías are utat ri Jeconías xuqujeꞌ are kitat ri e rachalal che taq riꞌ are xekꞌam bꞌik ri winaq aꞌj Israel pa ri tinimit Babilonia. ");
INSERT INTO quctt_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Are ikꞌowinaq chi ri qꞌotaj are xetzalij ri winaq aꞌj Israel pa Babilonia, ri Jeconías xutik ri Salatiel, ri Salatiel are utat ri Zorobabel. ");
INSERT INTO quctt_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ri Zorobabel are utat ri Abiud, ri Abiud are utat ri Eliaquín, ri Eliaquín are utat ri Azor. ");
INSERT INTO quctt_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ri Azor are utat ri Sadoc, ri Sadoc are utat ri Aquín, ri Aquín are utat ri Eliud. ");
INSERT INTO quctt_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ri Eliud are utat ri Eleazar, ri Eleazar are utat ri Matán, ri Matán are utat ri Jacob. ");
INSERT INTO quctt_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Xuqujeꞌ ri Jacob are utat ri José, rachajil ri María, ri unan ri Jesús, ri kabꞌix Mesías che. ");
INSERT INTO quctt_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Xaq jeriꞌ e kajlajuj puq winaq atiꞌt mam kitereneꞌlom kibꞌ xchapleꞌtaj loq rukꞌ ri Abraham xultoqꞌol rukꞌ ri David, kꞌa te riꞌ e kajlajuj puq winaq chik atiꞌt mam kitereneꞌlom kibꞌ xchapleꞌtaj loq rukꞌ ri David xopan kꞌa pa ri qꞌij are xekꞌam bꞌik ri winaq aꞌj Israel pa ri tinimit Babilonia, xuqujeꞌ kajlajuj puq winaq atiꞌt mam kitereneꞌloꞌm kibꞌ xchapleꞌtaj loq pa ri qꞌij ri xekꞌam bꞌik pa ri tinimit Babilonia kꞌa pa taq ri qꞌij are xalax ri Cristo. ");
INSERT INTO quctt_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Are waꞌ ri xkꞌulmatajik are xalax ri Jesús, ri Cristo. Ri María unan ri Jesús jubꞌiqꞌ karaj kakꞌuliꞌ rukꞌ ri José, majoꞌq kꞌu kakꞌuliꞌk are xkanaj yawabꞌ winaq rumal ri ukwinem ri Tyoxalaj Uxlabꞌixel. ");
INSERT INTO quctt_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ri José ri rachajil ri María, rumal cher sukꞌ ranimaꞌ, man xraj taj xuya ri rixoqil pa ukꞌixibꞌal, xuchomaj kuqꞌat ribꞌ che ri rixoqil, maj jachin che xutzijoj wi. ");
INSERT INTO quctt_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tajin kꞌu kuchomaj ubꞌanik we riꞌ are xukꞌut ribꞌ jun ángel rech ri Ajawxel choch pa ri uwaram, xubꞌij che: José, rijaꞌl ri David, man kaxiꞌj ta awibꞌ kakꞌam che awixoqil ri María, rumal cher are ri Tyoxalaj Uxlabꞌixel xtikoꞌnij che. ");
INSERT INTO quctt_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kakꞌojiꞌ kꞌu na jun ral ala, kakoj na Jesús che ubꞌiꞌ, rumal cher areꞌ kakolow na ri utinimit che ri kimak. ");
INSERT INTO quctt_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ronojel we jastaq riꞌ xbꞌantajik rech kakꞌulmataj ronojel ri ubꞌim loq ri Ajawxel chuchiꞌ ri qꞌalajisal rech ri utzij, are xubꞌij: ");
INSERT INTO quctt_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ri qꞌapoj ali kux na yawabꞌ winaq. Kakꞌojiꞌ na jun ral ala, ri kabꞌix na Emanuel che, ri kel kubꞌij: Are ri Dios kꞌo qukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Are xkꞌastaj ri José che ri uwaram, xunimaj ri xbꞌix che rumal ri ángel, xukꞌam ri María che rixoqil. ");
INSERT INTO quctt_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Man xqꞌoyiꞌ ta kꞌu na rukꞌ ri María kꞌa xkꞌojiꞌ na ri nabꞌyal ral, Jesús xukoj che ubꞌiꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Alaxinaq chi ri Jesús pa ri tinimit Belén rech Judea, pa taq ri qꞌij are kataqan ri taqanel Herodes. Xoꞌpan pa Jerusalén nikꞌaj achyabꞌ kꞌo ketaꞌmabꞌal, kipetik pa ri relibꞌal qꞌij. ");
INSERT INTO quctt_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Xkitatabꞌelaꞌ xkibꞌij: ¿Jawjeꞌ xalax wi ri kirey ri winaq aꞌj Israel? Xqil ri uchꞌumil rumal riꞌ xujpe chuqꞌijilaꞌxik. ");
INSERT INTO quctt_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ri taqanel Herodes are xutabꞌej rech we riꞌ, xkꞌaxir ranimaꞌ, xkꞌaxir xuqujeꞌ kanimaꞌ ri winaq rech ri tinimit Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Xaq jeriꞌ xtaqan che kisikꞌixik konojel ri e kꞌamal taq bꞌe ke ri chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq, xuqujeꞌ ri aꞌjtijabꞌ rech ri taqanik, xuta chike jas leꞌaj kalax wi ri Cristo. ");
INSERT INTO quctt_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Pa ri tinimit Belén rech Judea, xecha che, rumal cher jeriꞌ utzꞌibꞌam loq ri qꞌalajisal utzij ri Dios: ");
INSERT INTO quctt_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ri at tinimit Belén, ri at kꞌo pa ri rulew ri Judea, Pune nitzꞌ aqꞌij chikiwach ri e nikꞌaj leꞌaj chik rech ri Judea, Chawe kꞌut kakꞌiy wi na loq jun qꞌatal tzij, Ri kuꞌyuqꞌuj na ri nutinimit Israel. ");
INSERT INTO quctt_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kꞌa te riꞌ ri Herodes cheleqꞌal xuꞌsikꞌij ri achyabꞌ ri kꞌo ketaꞌmabꞌal, xuta chike jampaꞌ xukꞌut ribꞌ ri chꞌumil. ");
INSERT INTO quctt_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kꞌa te riꞌ xuꞌtaq bꞌik pa Belén, xubꞌij chike: Jix chitatabꞌelaꞌ jawjeꞌ xalax wi ri akꞌal. Are kiriqo, jilibꞌij chwe jeriꞌ kineꞌ xuqujeꞌ in chuqꞌijilaꞌxik. ");
INSERT INTO quctt_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Are xtataj ri xubꞌij ri taqanel chike, xkitaqej ri kibꞌe, kꞌa te xkilo xnabꞌej ri chꞌumil chkiwach, te xeꞌtakꞌal puꞌwiꞌ ri leꞌaj ri kꞌo wi ri akꞌal. ");
INSERT INTO quctt_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Are xkil ri chꞌumil, sibꞌalaj xekiꞌkotik. ");
INSERT INTO quctt_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Xoꞌk bꞌik pa ri ja, xkil ri akꞌal kꞌo rukꞌ ri unan María, xexukiꞌk xkiqꞌijilaꞌj ri Jesús. Kꞌa te riꞌ xkijaq ri kikꞌolibꞌal, xkisipaj qꞌana pwaq che, uqꞌolal cheꞌ, xuqujeꞌ kꞌokꞌ taq kunabꞌal ubꞌiꞌ mirra. ");
INSERT INTO quctt_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Xechꞌabꞌex kꞌu we achyabꞌ riꞌ pa ri kiwaram xbꞌix chike chi man ketzalij ta chi rukꞌ ri Herodes, rumal riꞌ pa jun bꞌe chik xetzalij wi. ");
INSERT INTO quctt_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","E bꞌenaq chi ri achyabꞌ ri kꞌo ketaꞌmabꞌal, are xaq kꞌa teꞌ xukꞌut ribꞌ jun ángel rech ri Ajawxel pa uwaram ri José, xubꞌij che: Chatwaꞌjiloq, chakꞌama bꞌik ri akꞌal rachiꞌl ri unan, chatanimaj bꞌik. Jat pa Egipto, chatkanaj kan chilaꞌ kꞌa jampaꞌ na kꞌu kinbꞌij chawe, rumal cher ri Herodes kutzukuj na ri akꞌal rech kukamisaj. ");
INSERT INTO quctt_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Xaq jeriꞌ kꞌa chaqꞌabꞌ na are xwaꞌjil bꞌi ri José, xeꞌ pa Egipto, xukꞌam bꞌik ri akꞌal rachiꞌl ri unan ri akꞌal. ");
INSERT INTO quctt_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Chilaꞌ xkꞌojiꞌ wi kꞌa xkam na ri Herodes. Jeriꞌ xkꞌulmataj ri ubꞌim loq ri Ajawxel chuchiꞌ ri qꞌalajisal rech ri utzij, are xubꞌij: Pa Egipto kꞌo wi ri nukꞌojol are xinsikꞌij apanoq. ");
INSERT INTO quctt_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Are xunabꞌej ri Herodes chi man xnimax ta ri utzij kumal ri achyabꞌ ri kꞌo ketaꞌmabꞌal, xchꞌuꞌjar che royawal. Xtaqan chikikamisaxik ri akꞌalabꞌ ri majaꞌ katzꞌaqat kakabꞌ kijunabꞌ ri e kꞌo pa ri tinimit Belén xuqujeꞌ pa nikꞌaj taq leꞌaj chik ri e kꞌo apan chikixukut, are xutereneꞌj ri qꞌotaj ri xbꞌix kan che kumal ri achyabꞌ ri kꞌo ketaꞌmabꞌal. ");
INSERT INTO quctt_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Jeriꞌ xkꞌulmataj ri xubꞌij loq ri qꞌalajisal utzij ri Dios Jeremías are xubꞌij: ");
INSERT INTO quctt_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Xtataj jun raqoj chiꞌ pa ri tinimit Ramá, oqꞌej xuqujeꞌ nimalaj bꞌis. Are Raquel keroqꞌej ri ral. Man karaj ta kꞌut kakubꞌisax ukꞌuꞌx, rumal cher e maj chi ral. ");
INSERT INTO quctt_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Are kaminaq chi ri Herodes, jun ángel rech ri Ajawxel xukꞌut ribꞌ cho ri José pa ri uwaram, are kꞌo na pa Egipto. ");
INSERT INTO quctt_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Xubꞌij che: Chatwaꞌjiloq, chakꞌama bꞌik ri akꞌal rachiꞌl ri unan, chattzalij pa Israel. Xekam riꞌ ri winaq ri kakirayij ukamisaxik ri akꞌal. ");
INSERT INTO quctt_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Xwaꞌjil ri José, xukꞌam bꞌik ri akꞌal rachiꞌl ri rixoqil, xetzalij pa ri tinimit Israel. ");
INSERT INTO quctt_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Are xutabꞌej rech chi ri Arquelao are tajin kataqan pa Judea che ukꞌex wach ri utat Herodes, xuxiꞌj ribꞌ xeꞌ je laꞌ. Xya kꞌu unoꞌj rumal ri Dios pa ri uwaram rumal riꞌ xetzalij pa Galilea. ");
INSERT INTO quctt_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Xkꞌojiꞌ pa jun leꞌaj ubꞌiꞌ Nazaret, jeriꞌ xkꞌulmataj ri xkibꞌij loq ri e qꞌalajisal taq utzij ri Dios are xkibꞌij: Kabꞌix na Jesús aj Nazaret che. ");
INSERT INTO quctt_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Pa taq ri qꞌij riꞌ xopan ri Juan Bꞌanal qasanaꞌ chutzijoxik ri utzij ri Dios pa taq ri katzꞌinow ulew rech ri tinimit Judea. ");
INSERT INTO quctt_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Jewaꞌ xubꞌij: Chikꞌexa ikꞌuꞌx rumal xqet loq ri ajawarem rech ri kaj. ");
INSERT INTO quctt_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ri Juan are waꞌ ri achi ri xtzꞌibꞌax loq rij rumal ri qꞌalajisal rech ri utzij ri Dios Isaías, are xubꞌij: Uchꞌabꞌal jun winaq ri kasikꞌinik pa ri katzꞌinow ulew, kubꞌij: “Chisukꞌumaj ri ubꞌe ri Ajawxel, sukꞌum chibꞌana che ri ubꞌe.” ");
INSERT INTO quctt_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ri ratzꞌyaq ri Juan che rismal kamey bꞌantal wi. Ujatꞌim ri upam rukꞌ jun tzꞌuꞌm jatꞌibꞌal xuqujeꞌ kuꞌtij sakꞌ xuqujeꞌ juyubꞌil kabꞌ che uwa. ");
INSERT INTO quctt_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ri winaq aꞌj Jerusalén, aꞌj Judea, xuqujeꞌ ri keꞌl je laꞌ pa Jordán xoꞌpan rukꞌ ri Juan. ");
INSERT INTO quctt_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Are katzujutaj kibꞌ che ri kimak kabꞌan kan kiqasanaꞌ pa ri nimaꞌ Jordán. ");
INSERT INTO quctt_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Are xril ri Juan chi xoꞌpan sibꞌalaj e kꞌi fariseos xuqujeꞌ e kꞌi saduceos pa ri leꞌaj jawjeꞌ ri tajin kubꞌan wi ri qasanaꞌ, xubꞌij chike: Kijaꞌl taq kumatz, ¿jachin xbꞌin chiꞌwe chi kixkwinik kixanimaj choch ri kꞌaxkꞌolal ri kape na pa iwiꞌ? ");
INSERT INTO quctt_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Qas utz chixnoꞌjinoq rech qas kaqꞌalajinik chi qas xikꞌex ikꞌuꞌx. ");
INSERT INTO quctt_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Man kixkwin ta kꞌut kibꞌij: “Are qatat ri Abraham.” Rumal kinbꞌij chiꞌwe chi ri Dios kakwinik kubꞌano chi kekꞌiy ralkꞌwaꞌl ri Abraham chike we abꞌaj riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ri ikaj xaq yaꞌtal chik rukꞌ ri ukꞌaꞌmalil ri cheꞌ. Ronojel kꞌu cheꞌ ri man kuya ta uwach kaqasax na, xuqujeꞌ kakꞌyaq na bꞌik pa ri qꞌaqꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","In kinbꞌan iqasanaꞌ rukꞌ jaꞌ rech kikꞌex ikꞌuꞌx. Kꞌo kꞌu jun ri kape na, sibꞌalaj kꞌo ukwinem chinuwach in, man taqal ta chwe xa ta ne kinwukꞌaj ri uxajabꞌ. Areꞌ kubꞌan na iqasanaꞌ rukꞌ ri Tyoxalaj Uxlabꞌixel xuqujeꞌ rukꞌ qꞌaqꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kꞌo ri uchaꞌbꞌal puꞌqꞌabꞌ, kuchꞌajchꞌobꞌej na ri rulew. Kuyak na ri tiriko ri kꞌo pa ri ukꞌolibꞌal, are kꞌu ri pajo kuporoj na pa ri qꞌaqꞌ ri maj ukꞌisik. ");
INSERT INTO quctt_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jun qꞌijal ri Jesús xel bꞌik pa Galilea, xeꞌ pa ri nimaꞌ Jordán rech kabꞌan kan uqasanaꞌ rumal ri Juan. ");
INSERT INTO quctt_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ri Juan are xraj xukꞌex ri uchomanik ri Jesús, xubꞌij che: ¿La are kꞌu kaj la in kinbꞌanow ri qasanaꞌ la? In riꞌ ri rajawaxik kabꞌan la nuqasanaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ri Jesús xubꞌij che: Qabꞌana jetaq ri kinbꞌij chawe, rumal kumajo are kaqabꞌan ri karaj ri Dios. Ri Juan xunimaj ri xubꞌij ri Jesús che. ");
INSERT INTO quctt_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Are xbꞌantaj uqasanaꞌ ri Jesús, xel loq pa ri jaꞌ. Pa ri qꞌotaj riꞌ, xjaqajobꞌ ri kaj, kꞌa te riꞌ xril ri Uxlabꞌixel rech ri Dios xqaj loq puꞌwiꞌ jacha jun palomax. ");
INSERT INTO quctt_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Xtataj kꞌu jun chꞌabꞌal rech chilaꞌ chikaj xubꞌij: Are waꞌ ri Loqꞌalaj nuKꞌojol, sibꞌalaj kakiꞌkot wanimaꞌ rumal rech. ");
INSERT INTO quctt_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Te kꞌu riꞌ ri Tyoxalaj Uxlabꞌixel xukꞌam bꞌik ri Jesús pa ri ulew ri katzꞌinowik rech kataqchiꞌxik pa mak rumal ri Itzel. ");
INSERT INTO quctt_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ri Jesús are xtoꞌtaj chubꞌanik kawinaq aqꞌabꞌ xuqujeꞌ kawinaq qꞌij re qꞌipoj waꞌim, xunaꞌ numik. ");
INSERT INTO quctt_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Xpe kꞌu ri Itzel xqet rukꞌ, xubꞌij che: We qas at uKꞌojol ri Dios, chabꞌij chike we abꞌaj riꞌ kuꞌx kaxlan wa. ");
INSERT INTO quctt_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ri Jesús xubꞌij che: Ri tzꞌibꞌatalik kubꞌij: Man xaq xwi ta ri kaxlan wa kakꞌasbꞌan ri achi, xane are ri utzij Dios kayoꞌw kꞌaslemal. ");
INSERT INTO quctt_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kꞌa te riꞌ ri Itzel xukꞌam bꞌik ri Jesús pa ri tinimit Jerusalén, xutakꞌabꞌa kꞌa puꞌwiꞌ ri unimal ri Templo, xubꞌij che: ");
INSERT INTO quctt_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","We qas at uKꞌojol ri Dios, chakꞌyaqa bꞌik awibꞌ ikim. Rumal cher ri tzꞌibꞌatalik kubꞌij: Kuꞌtaq ri rangelibꞌ katkitelej pa kiqꞌabꞌ, rech man katopij ta awaqan rukꞌ abꞌaj. ");
INSERT INTO quctt_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ri Jesús xubꞌij che: Tzꞌibꞌatal xuqujeꞌ: Man kakoj ta kꞌaꞌmabꞌal pa ubꞌe ri awajaw ri aDios. ");
INSERT INTO quctt_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Junmul chik ri Itzel xukꞌam bꞌik ri Jesús puꞌwiꞌ jun nimalaj juyubꞌ, kꞌa te riꞌ xukꞌut choch ronojel ri ajawarem rech ri uwachulew xuqujeꞌ ri ujeꞌlal. ");
INSERT INTO quctt_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kꞌa te riꞌ xubꞌij che: Ronojel we riꞌ kinya chawe we katxukiꞌ chinuwach kinaqꞌijilaꞌj. ");
INSERT INTO quctt_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ri Jesús xubꞌij che: Jat Itzel, ri tzꞌibꞌatalik kubꞌij: Chaqꞌijilaꞌj ri Ajawxel ri aDios, xuqujeꞌ xaq xwi areꞌ chapatanij. ");
INSERT INTO quctt_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Xel kꞌu bꞌik ri Itzel rukꞌ ri Jesús, kꞌa te riꞌ xepe kꞌu jujun angelibꞌ chupatanixik. ");
INSERT INTO quctt_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ri Jesús are xutabꞌej re chi ri Juan xkoj pa cheꞌ, xtzalij pa Galilea. ");
INSERT INTO quctt_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Xel bꞌik pa Nazaret, xeꞌkꞌol pa ri tinimit Capernaúm, ri kꞌo chuxukut ri cho ri kꞌo pa Zabulón xuqujeꞌ Neftalí. ");
INSERT INTO quctt_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Rech kakꞌulmataj ri xubꞌij loq ri qꞌalajisal utzij ri Dios Isaías, are xubꞌij: ");
INSERT INTO quctt_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zabulón, Neftalí, Bꞌe ri keꞌ pa ri cho, ri kꞌo apanoq cho ri Jordán, Galilea kech ri winaq ri man aꞌj Israel taj. ");
INSERT INTO quctt_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ri winaq ri e kꞌo kanoq pa ri qꞌequꞌmal xkil jun nimalaj tunal. Xtunan jun nimalaj tunal pa kiwiꞌ ri winaq ri e kꞌo kanoq pa ri nimalaj qꞌequꞌmal. ");
INSERT INTO quctt_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Che ri qꞌij riꞌ, ri Jesús xuchapleꞌj utzijoxik ri utzij ri Dios, xubꞌij: Chikꞌexa ikꞌuꞌx, rumal xqet loq ri ajawarem rech ri kaj. ");
INSERT INTO quctt_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Are tajin kabꞌin ri Jesús chuxukut ri plo ri kꞌo pa Galilea, xeꞌril kebꞌ alaxik, tajin kakikꞌyaq ri kꞌat pa ri cho, rumal e chapal taq kar, ri jun are Simón ri kabꞌix Pedro che, ri jun chik are Andrés. ");
INSERT INTO quctt_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ri Jesús xubꞌij chike: Chixanloq, chinitereneꞌj. Kinbꞌan na chiꞌwe chi kiꞌkꞌam la achyabꞌ wukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Aninaq xkiya kan ri kikꞌat, xkitereneꞌj ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Are e bꞌininaq chi apanoq jubꞌiqꞌ, xeꞌril chi kebꞌ alaxik. Ri Jacobo rachiꞌl ri Juan e ralkꞌwaꞌl ri Zebedeo e kꞌo pa jun jukubꞌ bꞌinibꞌal puꞌwiꞌ ri jaꞌ, tajin kakitꞌis ri kikꞌat, xuꞌsikꞌij apanoq. ");
INSERT INTO quctt_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Xkiya kꞌu kan ri kijukubꞌ xuqujeꞌ xkiya kan ri kitat, xkitereneꞌj ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ri Jesús xbꞌinilobꞌ pa ronojel Galilea, xuya taq kꞌutuꞌn pa taq ri Sinagoga, xutzijoj ri utz laj tzij rech ri ajawarem, xuqujeꞌ xuꞌkunaj ronojel uwach yabꞌilal xuqujeꞌ kꞌaxal ri kꞌo winaq. ");
INSERT INTO quctt_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Xtukin utzijoxik ri xubꞌano pa ronojel ri tinimit Siria. Ri winaq xeꞌkikꞌam bꞌik rukꞌ, konojel ri yawabꞌibꞌ xuqujeꞌ ri sibꞌalaj kꞌo nimaq taq qꞌoxom chike, ri okinaq itzel taq uxlabꞌal chike, ri kꞌo yabꞌil chike ri kuꞌtontiꞌrisaj, xuqujeꞌ ri kaminaq kityoꞌjal, ri Jesús xuꞌkunaj konojel. ");
INSERT INTO quctt_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Sibꞌalaj kꞌi winaq aꞌj Galilea, aꞌj Decápolis, aꞌj Jerusalén, aꞌj Judea xuqujeꞌ aꞌj pa taq ri tinimit ri kꞌo apanoq cho ri Jordán xkitereneꞌj ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Are xril ri Jesús ri kikꞌiyal ri winaq, xpaqiꞌ cho ri juyubꞌ, kꞌa te riꞌ xtꞌuyiꞌk, xkimulij kꞌu kibꞌ ri utijoxelabꞌ chirij. ");
INSERT INTO quctt_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ri Jesús xuchapleꞌj ubꞌixik we tzij riꞌ: ");
INSERT INTO quctt_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","E tewchiꞌtal ri mebꞌaibꞌ pa kanimaꞌ, rumal cher aꞌreꞌ aꞌjchoqꞌe ri ajawarem rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","E tewchiꞌtal ri koꞌqꞌik rumal cher kakubꞌisax na kikꞌuꞌx. ");
INSERT INTO quctt_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","E tewchiꞌtal ri kakimochꞌ kibꞌ rumal cher kakikꞌamawaꞌj na ri ulew che kechabꞌal. ");
INSERT INTO quctt_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","E tewchiꞌtal ri kenumik, xuqujeꞌ kachaqiꞌj kichiꞌ chubꞌanik ri sukꞌal rumal cher kayaꞌtaj na chike ri urayibꞌal kikꞌuꞌx. ");
INSERT INTO quctt_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","E tewchiꞌtal ri kakitoqꞌobꞌisaj kiwach nikꞌaj winaq chik rumal cher katoqꞌobꞌisax na kiwach aꞌreꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","E tewchiꞌtal ri chꞌajchꞌoj kanimaꞌ rumal cher kakil na uwach ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","E tewchiꞌtal ri kechakunik chuyaꞌik jaꞌmaril rumal cher kabꞌix na ralkꞌwaꞌl ri Dios chike. ");
INSERT INTO quctt_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","E tewchiꞌtal ri kabꞌan kꞌax chike rumal ubꞌanik ri sukꞌal, rumal cher kech na ri ajawarem rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Chixkiꞌkotoq are kabꞌix itzel taq jastaq chiꞌwe, xuqujeꞌ kixtzukuxik rech kabꞌan kꞌax chiꞌwe, xuqujeꞌ kabꞌan ronojel uwach bꞌanoj tzij chiꞌwij xa rumal we in. ");
INSERT INTO quctt_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Chixkiꞌkotoq, xuqujeꞌ noj ri iwanimaꞌ che kiꞌkotemal, rumal cher kayaꞌtaj na jun nimalaj tojbꞌal iwe pa ri kaj. Jeriꞌ xbꞌan chike ri e qꞌalajisal taq tzij rech ri Dios ri xepe kan chiꞌwach ix nabꞌe. ");
INSERT INTO quctt_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ri ix ix atzꞌam rech ri uwachulew. We man katzayin chi ri atzꞌam ¿jas kubꞌan kꞌut rech katzayin chi na? Maj chi kutayij, xane kakꞌyaq bꞌi riꞌ kumal ri winaq, ketzelax uwach xuqujeꞌ katakꞌaleꞌxik. ");
INSERT INTO quctt_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ix kixtunan ri uwachulew. Ri tinimit ri kꞌo puꞌwiꞌ ri juyubꞌ man kakwin taj karawaj ribꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Xuqujeꞌ man katzij ta jun qꞌaqꞌ tunabꞌal kꞌa te riꞌ kachꞌuq rukꞌ jun kaxon. Xane kaya puꞌwiꞌ jun kꞌolibꞌal jastaq rech kuꞌtunaj konojel ri e kꞌo pa ri ja. ");
INSERT INTO quctt_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Xaq jeriꞌ tunan ri itunal chkiwach ri winaq rech kakil ri utz taq chak ri kibꞌano, xuqujeꞌ kakiqꞌijilaꞌj ri Tataxel ri kꞌo pa ri kaj. ");
INSERT INTO quctt_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Michomaj chi xinpe che uchupik ri taqanik xuqujeꞌ ri xkibꞌij ri e qꞌalajisal taq tzij rech ri Dios, man je ta riꞌ, xane in petinaq che unimaxik. ");
INSERT INTO quctt_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Qas tzij kinbꞌij chiꞌwe chi are kꞌa kꞌo na ri kaj rachiꞌl ri uwachulew, maj jun tzꞌibꞌ, maj xa ta ne jun tzꞌut rech ri taqanik kasach uwach, ronojel kakꞌulmataj na. ");
INSERT INTO quctt_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Xapachin ri man kunimaj ta jun chike we taqanik riꞌ, pune are ri sibꞌalaj nitzꞌ chike xuqujeꞌ kuꞌtaqchiꞌj chi nikꞌaj je kakibꞌano, nitzꞌ kabꞌan na chi rilik pa ri ajawarem rech chilaꞌ chikaj. Xapachin kꞌu ri kunimaj xuqujeꞌ kuꞌtaqchiꞌj chi nikꞌaj chunimaxik ri taqanik, nim na kil pa ri ajawarem rech chilaꞌ chikaj. ");
INSERT INTO quctt_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Qas kinbꞌij chiꞌwe chi man kixok taj pa ri ajawarem rech ri kaj we man kikꞌow na ri isukꞌal chikiwach ri e fariseos xuqujeꞌ ri aꞌjtijabꞌ rech ri taqanik. ");
INSERT INTO quctt_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ri ix itom chi xbꞌix chike ri qamam ojer: Matkamisanik, xuqujeꞌ Xapachin ri kakamisanik, kaqꞌat na tzij puꞌwiꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ri in kꞌut kinbꞌij chiꞌwe, xapachin ri kayojtaj rukꞌ ri rachalal, kaqꞌat na tzij puꞌwiꞌ. Xapachin ri kutzukuj chꞌoꞌj rukꞌ ri rachalal kaqꞌat na tzij puꞌwiꞌ cho ri qꞌatbꞌal tzij. Xuqujeꞌ xapachin ri karetzelaj ri rachachal kaqꞌat na tzij puꞌwiꞌ pa ri tyoꞌnel qꞌaqꞌ ri maj ukꞌisik. ");
INSERT INTO quctt_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Xaq jeriꞌ, we tajin kaya ri asipanik cho ri tzujbꞌal sipanik kꞌa te riꞌ kanaꞌtaj chawe chi ri awachalal yojtajinaq awukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Chaya kan ri asipanik cho tzujbꞌal sipanik. Jat nabꞌe rukꞌ ri awachalal, jaꞌta toqꞌobꞌ che, kꞌa te riꞌ chattzalij loq chutzujik ri asipanik. ");
INSERT INTO quctt_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","We kꞌo jun akꞌulel ri raj katuꞌtzujuj cho ri qꞌatbꞌal tzij, chattzijon rukꞌ aninaq are bꞌenaq pa ri bꞌe, rech man katujach ta che ri qꞌatal tzij, rumal we xatujach che ri qꞌatal tzij, ri qꞌatal tzij katujach chi che jun ri katkꞌamow bꞌik pa ri cheꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Qas tzij kinbꞌij chawe chi man katel ta kꞌu loq chilaꞌ we man katoj kan ri kꞌisbꞌal centaw akꞌas. ");
INSERT INTO quctt_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ri ix itom bꞌiꞌtal loq: Mabꞌan mak rukꞌ ri kꞌulanik winaq. ");
INSERT INTO quctt_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kinbꞌij in chiꞌwe xapachin ri kukaꞌyej jun ixoq xuqujeꞌ kurayij kamakun rukꞌ, xmakun riꞌ rukꞌ pa ranimaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Xaq jeriꞌ, we ri abꞌoqꞌoch ri kꞌo pa awiqiqꞌabꞌ katutaqchiꞌj pa mak, chawesaj, chakꞌyaqa bꞌik. Are katanik katzaq jubꞌiqꞌ che ri atyoꞌjal, cho ri ronojel ri atyoꞌjal kakꞌyaq bꞌik pa ri tyoꞌnel qꞌaqꞌ ri maj ukꞌisik. ");
INSERT INTO quctt_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","We ri aqꞌabꞌ ri wiqiqꞌabꞌ katutaqchiꞌj pa mak, chasakꞌij, chakꞌyaqa bꞌik. Are katanik katzaq jubꞌiqꞌ che ri atyoꞌjal cho ri kakꞌyaq bꞌik ronojel pa ri tyoꞌnel qꞌaqꞌ ri maj ukꞌisik. ");
INSERT INTO quctt_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Bꞌiꞌtal loq: Ri karetzelaj uwach ri rixoqil chuya jun uwuj jawjeꞌ kubꞌij wi chi xkijach kibꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ri in kꞌut kinbꞌij chiꞌwe, ri kujach rixoqil man xa ta rumal chi xriqitaj chi rukꞌ jun achi, tajin kutaqchiꞌj ri rixoqil pa mak, je xuqujeꞌ ri winaq ri kakꞌuliꞌ rukꞌ ri jachtalik, kamakun xuqujeꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Xuqujeꞌ itom riꞌ xbꞌix chike ri iwatiꞌt imam ojer: Chabꞌana ri chꞌekom tzij, ri xabꞌij kabꞌano, chabꞌana ri xatzuj ubꞌanik cho ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ri in kꞌut kinbꞌij chiꞌwe, man kibꞌan ta chꞌekoj tzij cho ri kaj, rumal cher are utꞌuyulibꞌal ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Man kibꞌan ta chꞌekoj tzij cho ri uwachulew, rumal cher are utakꞌalibꞌal ri Dios. Man kibꞌan ta chꞌekom tzij cho ri tinimit Jerusalén, rumal cher are utinimit ri nimalaj Taqanel. ");
INSERT INTO quctt_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Xuqujeꞌ man kibꞌan ta chꞌekoj tzij puꞌwiꞌ ri ijolom, rumal cher man kixkwin taj kisaqirisaj o kiqꞌeqꞌarisaj ri iwiꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Are kibꞌij “jeꞌ” o “jeriꞌ”, qas je bꞌa riꞌ chibꞌanaꞌ; xuqujeꞌ are kibꞌij “man je ta riꞌ”, je xuqubꞌa riꞌ chibꞌanaꞌ. Rumal tzi che ri itzel kape wi we xaq bꞌanoj tzij kibꞌano. ");
INSERT INTO quctt_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ri ix itom ri xbꞌixik: We kꞌo jun winaq karesaj jun bꞌoqꞌochaj, kesax xuqujeꞌ na jun ubꞌoqꞌoch ri winaq riꞌ, xuqujeꞌ we kꞌo jun winaq karesaj jun wareaj kesax xuqujeꞌ na jun uware we winaq riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ri in kinbꞌij chiꞌwe: Man kibꞌan ta chꞌoꞌj rukꞌ ri kubꞌan kꞌax chiꞌwe. We kꞌo jun winaq kixuchꞌay che ri ipalaj ri kꞌo pa iwiqiqꞌabꞌ, chiya chi ri jun ipalaj che. ");
INSERT INTO quctt_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","We kꞌo jun kumaj kan ri akamiꞌx, chaya xuqujeꞌ kan ri achakeꞌt che. ");
INSERT INTO quctt_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","We kꞌo jun katutaqchiꞌj che ukꞌamik bꞌik jun eqaꞌn jun kilómetro, chakꞌama bꞌik at kebꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ri winaq ri kuta jastaq chawe, chaya che. Ri kuta uqajanik chawe, man kakꞌekꞌej ta uyaꞌik che. ");
INSERT INTO quctt_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Itom xuqujeꞌ ri bꞌiꞌtal loq: Chaloqꞌaj ri ajil tzꞌaqat xuqujeꞌ chawetzelaj ri akꞌulel. ");
INSERT INTO quctt_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kinbꞌij kꞌu in chiꞌwe: Chiꞌloqꞌaj ri iꞌkꞌulel xuqujeꞌ chibꞌana chꞌawem pa kiwiꞌ ri kixkitzukuj rech kakibꞌan kꞌax chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Rech jeriꞌ qas kixux ralkꞌwaꞌl ri iTat ri kꞌo pa ri kaj. Areꞌ kabꞌanowik chi kel loq le qꞌij pa kiwiꞌ ri itzel taq winaq xuqujeꞌ pa kiwiꞌ ri e utz taq winaq, xuqujeꞌ kubꞌan jabꞌ pa kiwiꞌ ri e sukꞌ taq winaq xuqujeꞌ ri man e sukꞌ taj. ");
INSERT INTO quctt_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","We xaq xwi kiꞌloqꞌaj ri winaq ri kixloqꞌanik, ¿jas ta kꞌu riꞌ ri tojbꞌal iwe kikꞌamawaꞌj? ¿La man kꞌu jewaꞌ kenoꞌjin xuqujeꞌ le toqꞌil taq alkabal? ");
INSERT INTO quctt_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Xuqujeꞌ we xaq xwi kiya rutzil uwach ri iwachalal ¿jas kꞌu riꞌ ri kꞌakꞌ jastaq ri kibꞌano? ¿La man kꞌu jewaꞌ kenoꞌjin ri winaq ri man aꞌj Israel, taj? ");
INSERT INTO quctt_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Xaq jeriꞌ, qas tzꞌaqat chixnoꞌjinoq jetaq ri iTat ri kꞌo chilaꞌ chikaj, tzꞌaqat kanoꞌjinik. ");
INSERT INTO quctt_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Mitzijoj chike nikꞌaj winaq chik are kibꞌan jun utz laj jastaq, rumal cher we kitzijoj, ri iTat ri kꞌo chilaꞌ chikaj man kuya ta tojbꞌal iwe. ");
INSERT INTO quctt_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","We kꞌo jun chiꞌwe kuꞌtoꞌ ri mebꞌaibꞌ, muchapleꞌj utzijoxik pa taq ri Sinagoga xuqujeꞌ mutzijoj chikiwach ri winaq. Ri kawach taq winaq jewaꞌ kenoꞌjinik, rumal cher kakaj keqꞌijilaꞌx kumal ri winaq. Qas tzij kinbꞌij chiꞌwe chi we jeriꞌ kibꞌan ix xkꞌamtaj riꞌ ri tojbꞌal iwe. ");
INSERT INTO quctt_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","We kꞌo jun chiꞌwe kutoꞌ jun mebꞌaꞌ, mutzijoj chike nikꞌaj winaq chik. ");
INSERT INTO quctt_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Xaq jeriꞌ maj jun chike ri winaq ketaꞌman ri tobꞌanik ri xayaꞌo, xwi ri iTat ri kakaꞌy pa ri awal kuya na chiꞌwe ri tojbꞌal rech. ");
INSERT INTO quctt_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Are kibꞌan chꞌawem, man je ta kixnoꞌjinik jetaq ri kawach taq winaq, aꞌreꞌ utz kakinaꞌo kiꞌl kumal ri winaq are kakibꞌan chꞌawem pa taq ri Sinagoga xuqujeꞌ pa taq ri kꞌolibꞌal jawjeꞌ ri kiꞌkꞌow wi e sibꞌalaj kꞌi winaq. Qas tzij kinbꞌij chiꞌwe chi xkꞌamtaj ri tojbꞌal ke. ");
INSERT INTO quctt_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ri at kꞌut are kabꞌan chꞌawem, chabꞌana pa atukel wi, chatzꞌapij awibꞌ pa ri awachoch, chabꞌana chꞌawem pa awal rukꞌ ri aTat. We jewaꞌ kabꞌano, ri Dios kuya na chawe ri kata che pa awal. ");
INSERT INTO quctt_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Are kibꞌan chꞌawem, mibꞌij sibꞌalaj kꞌi tzij, man kiwesaj ta kiwach ri man ketaꞌm ta uwach ri Dios, rumal cher pa kikꞌuꞌx aꞌreꞌ chi xa rumal ri ukꞌiyal ri kitzij ketataj rumal ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Man kiwesaj ta kiwach we winaq riꞌ, rumal cher ri Dios ri qaTat retaꞌm jas ri kajawataj chiꞌwe, pune majaꞌ kita che. ");
INSERT INTO quctt_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ri ix kꞌut are kibꞌan chꞌawem jewaꞌ chibꞌij: Qatat ri lal kꞌo pa ri kaj, tyoxirisatal ri bꞌiꞌ la. ");
INSERT INTO quctt_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Peta ri ajawarem e la, are bꞌanoq ri kaj lal cho ri uwachulew jetaq ri kabꞌan pa ri kaj. ");
INSERT INTO quctt_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ya la ri qawa ri kajawataj kamik. ");
INSERT INTO quctt_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kuyu la ri etzelal ri kaqabꞌano, jacha ri kaqabꞌan uj chikikuyik ri kakibꞌan etzelal chaqe. ");
INSERT INTO quctt_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Man kaya ta la bꞌe kujtzaq pa ri etzelal, man kaya ta la bꞌe kujtzaq pa uqꞌabꞌ ri itzel. ");
INSERT INTO quctt_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","We kikuy ix ri etzelal ri kibꞌanom chi nikꞌaj winaq chiꞌwe, ri iTat ri kꞌo pa ri kaj kixukuy xuqujeꞌ na. ");
INSERT INTO quctt_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Are kꞌu we man kiꞌkuy nikꞌaj winaq chik, ri iTat man kukuy ta xuqujeꞌ ri imak ix. ");
INSERT INTO quctt_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Are kibꞌan qꞌipoj waꞌim makikꞌut ta ri ibꞌis chiꞌpalaj, jacha ri kakibꞌan ri e kawach taq winaq. Ri e winaq riꞌ kakaj keꞌtaꞌmaxik are tajin kakiqꞌip kibꞌ che kiwaꞌim. Qas tzij kinbꞌij chiꞌwe chi xwi riꞌ, tojbꞌal ke kakikꞌamawaꞌj. ");
INSERT INTO quctt_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Are kibꞌan qꞌipoj waꞌim, chixiya ri iwiꞌ, xuqujeꞌ chichꞌaja ri ipalaj, ");
INSERT INTO quctt_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","rech man kakichꞌobꞌ ta ri winaq chi tajin kiqꞌip iwibꞌ che iwaꞌim. Xaq xwi ri Dios ri kakaꞌy pa ri awal areꞌ kayoꞌw na ri tojbꞌal iwe. ");
INSERT INTO quctt_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Man kimulij ta qꞌinomal waral cho ri uwachulew. We jastaq riꞌ xaq ketukinik xuqujeꞌ kiꞌxjutirik. Xuqujeꞌ xaq kelaqꞌax kumal ri eleqꞌomabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Are utz na we kimulij iqꞌinomal pa ri kaj, chilaꞌ man katukin ta wi xuqujeꞌ man kixjutir taj, man koꞌk ta xuqujeꞌ eleqꞌomabꞌ chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Naꞌtaj chiꞌwe chi jawjeꞌ kꞌo wi ri iqꞌinomal, chilaꞌ kakꞌojiꞌ wi na ri iwanimaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","We are kakaꞌyej xuqujeꞌ kachomaj rij utz taq jastaq, ronojel ri atyoꞌjal nojinaq riꞌ che tunal. ");
INSERT INTO quctt_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","We are kakaꞌyej xuqujeꞌ kachomaj rij itzel taq jastaq, ronojel ri atyoꞌjal riꞌ nojinaq che qꞌequꞌmal. We kabꞌij tunal che ri qꞌequꞌmal ri at kꞌo wi, at kꞌo riꞌ pa jun nimalaj qꞌequꞌmal. ");
INSERT INTO quctt_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Maj jun ajchak kakwinik kachakun kukꞌ e kebꞌ patrón, rumal cher kꞌo jun riꞌ kuloqꞌoqꞌej na cho ri jun chik. Man kixkwin taj kipatanij ri Dios xuqujeꞌ ri qꞌinomal pa junamam. ");
INSERT INTO quctt_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Man xaq xwi ta kichomaj rij jawjeꞌ kape wi ri kitijo, jawjeꞌ kape wi ri kiqumuj, o jawjeꞌ kape wi ri kiwatzꞌyaqibꞌej. ¿La man kꞌu are nim ri kꞌaslemal cho ri tijowik rij, xuqujeꞌ cho ri karatzꞌyaqibꞌej jun? ");
INSERT INTO quctt_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Chiꞌwilampe ri e chochiꞌ ri kerapap pa ri kyaqiqꞌ, man keꞌtikoꞌnij taj, xuqujeꞌ man kakiyak ta kitikoꞌn, xuqujeꞌ man kakiyak ta ri ijaꞌ pa ri kikꞌolibꞌal. Ri Dios kꞌut, ri Tataxel ri kꞌo pa ri kaj kuya ronojel ri kajawataj chike. ¿La man kꞌu are nim iqꞌij ix chikiwach le aꞌwaj leꞌ? ");
INSERT INTO quctt_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Teꞌq pa ikꞌuꞌx chi rukꞌ ri kakꞌaxkꞌobꞌ iwanimaꞌ kixkꞌasiꞌ chi na jun qꞌij? ");
INSERT INTO quctt_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Jas che kakꞌaxir ikꞌuꞌx che ri iwatzꞌyaq? Chiwetaꞌmaj iwe kukꞌ ri kotzꞌiꞌj ri e kꞌo cho ri saq. Man areꞌ taj kebꞌanow ri katzꞌyaq. ");
INSERT INTO quctt_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kinbꞌij kꞌu chiꞌwe, chi ri taqanel Salomón pune xkꞌojiꞌ nimalaj uqꞌinomal man xkwin taj wi je xatzꞌyaqinik jetaq ri e kotzꞌiꞌj. ");
INSERT INTO quctt_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","We sibꞌalaj jeꞌl kubꞌan ri Dios chike ri e kotzꞌiꞌj ri man naj ta qꞌotaj kekꞌasiꞌk ¿la man kꞌu kꞌo na ri kubꞌan iwukꞌ ix? Qas tzij kinwilo chi majaꞌ kakubꞌiꞌ ikꞌuꞌx chirij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Man kakꞌaxir ta chi ikꞌuꞌx rumal ri kitijo, xuqujeꞌ rumal ri kiqumuj, xuqujeꞌ rumal ri kiwatzꞌyaqibꞌej. ");
INSERT INTO quctt_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Xaq xwi ri winaq ri man ketaꞌm ta uwach ri Dios kakꞌaxir kanimaꞌ che we jastaq riꞌ. Are iTat ix ri kꞌo pa ri kaj, areꞌ retaꞌm jas kajawataj chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Chitzukuj nabꞌe ri Ajawarem rech ri Dios, xuqujeꞌ ri usukꞌal, ri areꞌ kꞌut kuya na ronojel ri kajawataj chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Xaq jeriꞌ makꞌaxkꞌobꞌ iwanimaꞌ rumal ri kakꞌulmataj chweꞌq. Ka kꞌo na qꞌotaj chuchomaxik jas kibꞌano. Naꞌtaj chiꞌwe chi xaqareꞌ kubꞌan chaqe ri kakꞌulmataj pa jun qꞌij. ");
INSERT INTO quctt_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Miqꞌat tzij pa kiwiꞌ nikꞌaj winaq chik, rech man kuqꞌat ta tzij ri Dios piꞌwiꞌ ix. ");
INSERT INTO quctt_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","We sibꞌalaj kꞌax kibꞌan chuqꞌatik tzij pa kiwiꞌ nikꞌaj winaq chik, kꞌax xuqujeꞌ kubꞌan na ri Dios chuqꞌatik tzij piꞌwiꞌ ix. Ri Dios je kanoꞌjin na iwukꞌ jetaq ri kixnoꞌjin ix kukꞌ nikꞌaj chik. ");
INSERT INTO quctt_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Jas che kabꞌij tzij chike nikꞌaj winaq chik are kakibꞌan etzelal, man kawil ta kꞌu ri itzel taq jastaq ri kabꞌan at? Kakaꞌyej jun laj nitzꞌ mes ri kꞌo puꞌbꞌoqꞌoch ri jun winaq chik, man kawil ta kꞌut chi kꞌo jun uqꞌabꞌ cheꞌ pa ri abꞌoqꞌoch at. ");
INSERT INTO quctt_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Jas che kabꞌij che jun winaq chik: “Chaya bꞌe chwe kinwesaj ri jun laj nitzꞌ mes ri kꞌo paꞌbꞌoqꞌoch,” man kanaꞌ ta kꞌut at chi kꞌo jun uqꞌabꞌ cheꞌ pa ri abꞌoqꞌoch? ");
INSERT INTO quctt_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Kawach! Nabꞌe chawesaj ri uqꞌabꞌ cheꞌ ri kꞌo pa ri abꞌoqꞌoch at rech qas kawilo are kawesaj ri nitzꞌ mes ri kꞌo puꞌbꞌoqꞌoch ri jun winaq chik. ");
INSERT INTO quctt_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Man kiya ta chike ri tzꞌiꞌ ri jastaq rech ri Dios, xuqujeꞌ man kiya ta chike ri aq ri jastaq ri paqal rajil rech man xaq taq kakitakꞌaleꞌla xuqujeꞌ rech man ketzalij ta chiꞌwij chi paꞌqꞌik. ");
INSERT INTO quctt_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Chitaꞌ rech kayaꞌtaj chiꞌwe, chitzukuj rech kiriqo, chixchꞌawoq rech kajaqataj ri uchiꞌ ja chiꞌwach. ");
INSERT INTO quctt_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Rumal cher ri winaq ri kuto, kukꞌamawaꞌj, ri kutzukuj, kuriq na, xuqujeꞌ we kachꞌawik, kajaqataj na choch ri uchiꞌ ja. ");
INSERT INTO quctt_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Maj jun tataxel kuya jun abꞌaj che ri ukꞌojol we kaxlan wa kata che. ");
INSERT INTO quctt_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Xuqujeꞌ we jun kar ri kata che, man jun kumatz ta kuyaꞌo. ");
INSERT INTO quctt_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ri ix pune ix itzel taq winaq iwetaꞌm kiya utz laj taq jastaq chike ri iꞌwalkꞌwaꞌl, are ta kꞌu mat kuya utz laj taq jastaq, ri iTat ri kꞌo pa ri kaj chike ri kakita che. ");
INSERT INTO quctt_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Je chixnoꞌjin kukꞌ ri winaq jetaq ri kiwaj ix kenoꞌjin iwukꞌ. Jeriꞌ kakikꞌut chiqawach ri taqanik xuqujeꞌ ri qꞌalajisal taq utzij ri Dios pa ri Tyoxalaj Wuj. ");
INSERT INTO quctt_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Chixok pa ri nitzꞌ uchiꞌ ja, rumal cher nim ri uchiꞌ ja xuqujeꞌ nim uwach ri bꞌe ri kakꞌamow bꞌik ri winaq pa ri kꞌaxkꞌolal. E kꞌi kꞌut kebꞌe chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Are kꞌax bꞌenam pa ri bꞌe ri kakꞌaman bꞌik pa ri kꞌaslemal, rumal cher kꞌin laj nitzꞌ uwach, xaq aꞌjilatal ri winaq ri koꞌk chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Chichajij iwibꞌ chike ri kakijaluj chi e qꞌalajisal taq utzij ri Dios, rumal cher xaq e bꞌanal taq tzij. Kakibꞌij chi utzij ri Dios kakibꞌij, jer kekaꞌy chij are koꞌpan iwukꞌ, xa kꞌu qas e xibꞌibꞌal wi jetaq ri kayoꞌt, e tijonelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Iwetaꞌm kiwach waꞌ we winaq riꞌ, rumal cher man kekwin ta chubꞌanik jun utza jastaq, xaq jer e kꞌo kꞌix ri kesokonik. ");
INSERT INTO quctt_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kajunumataj rukꞌ ri cheꞌ. Ronojel utz cheꞌ, utz uwach kuyaꞌo, are kꞌu ri itzel cheꞌ, itzel uwach kuyaꞌo. Maj jun utz cheꞌ ri kuya itzel uwach xuqujeꞌ maj jun itzel cheꞌ ri kuya utz uwach. ");
INSERT INTO quctt_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Maj jun utz cheꞌ kuya itzel taq uwach xuqujeꞌ man jun itzel cheꞌ kuya utz taq uwach. ");
INSERT INTO quctt_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ronojel cheꞌ ri man utz ta uwach kuyaꞌo, kaqasaxik xuqujeꞌ kaporoxik. ");
INSERT INTO quctt_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Xaq jeriꞌ kiwetaꞌmaj kiwach ri e bꞌanal taq tzij rumal ri etzelal ri kakibꞌano. ");
INSERT INTO quctt_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Man konojel ta ri kakibꞌij chi in Kajaw xuqujeꞌ in kajchoqꞌe koꞌk pa ri ajawarem rech ri Dios. Xaq xwi koꞌk pa ri ajawarem rech ri Dios ri kakinimaj ri utaqanik ri nuTat ri kꞌo pa ri kaj. ");
INSERT INTO quctt_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Are kopan ri qꞌij ri kuqꞌat tzij ri Dios pa kiwiꞌ kojonel ri winaq rech uwachulew, e kꞌi na kakibꞌij chwe: “Ajawxel xuqujeꞌ qajchoqꞌe, xqatzijoj ri tzij la chike nikꞌaj winaq chik, xuqujeꞌ xqesaj ri itzel taq uxlabꞌal je xuqujeꞌ xqabꞌan mayijabꞌal taq jastaq pa ri bꞌiꞌ la.” ");
INSERT INTO quctt_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kinbꞌij na chike: “Chixel chinuwach, itzel taq winaq. Maj we chiꞌwe.” ");
INSERT INTO quctt_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ri kutatabꞌej xuqujeꞌ kunimaj ri nukꞌutuꞌn, xuqujeꞌ kuchakubꞌej, xaq junam rukꞌ ri achi ri xuyak rachoch puꞌwiꞌ ri abꞌaj. ");
INSERT INTO quctt_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Xqaj ri jabꞌ, xekꞌiy taq ri nimaꞌ, xpe ri kyaqiqꞌ, xupuyij ri ja rukꞌ chuqꞌabꞌ. Man xtzaq ta kꞌu ri ja, rumal kꞌo puꞌwiꞌ ri abꞌaj. ");
INSERT INTO quctt_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Xapachin ri kutatabꞌej ri nukꞌutuꞌn, man kubꞌan ta kꞌu ri kinbꞌij. Je ri kꞌo jun achi ri maj retaꞌmabꞌal ri xuyak rachoch puꞌwiꞌ ri sanyobꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Xqaj ri jabꞌ, xekꞌiy taq ri nimaꞌ, xpe ri kyaqiqꞌ xupuyij ri ja rukꞌ chuqꞌabꞌ. Xtzaq ri ja, xuqujeꞌ xtukin ronojel. ");
INSERT INTO quctt_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Are xtoꞌtaj ri Jesús che tzijonem, konojel ri winaq xemayijanik rumal ri ukꞌutuꞌn. ");
INSERT INTO quctt_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Rumal cher ri Jesús xuya taqanik rukꞌ chuqꞌabꞌ, man je ta kꞌu riꞌ kakibꞌan ri aꞌjtijabꞌ rech ri taqanik. ");
INSERT INTO quctt_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Are xqaj loq ri Jesús puꞌwiꞌ ri juyubꞌ, e kꞌi winaq xeteriꞌ chirij. ");
INSERT INTO quctt_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Xaq kꞌa te xqet jun chꞌaꞌk achi rukꞌ, xukiꞌ choch, xubꞌij che: Ajawxel, wetaꞌm chi kakwin la chinukunaxik, ¿la kaj la kinkunaj la? ");
INSERT INTO quctt_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ri Jesús xuya ri uqꞌabꞌ puꞌwiꞌ ri achi, kꞌa te riꞌ xubꞌij che: Kawaj, chatutziroq. Aninaq xutzir ri achi. ");
INSERT INTO quctt_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kꞌa te riꞌ, ri Jesús xubꞌij che: Qas chatatabꞌej we riꞌ, man katzijoj ta chi che jun winaq chik ri xkꞌulmatajik. Xaq xwi jat jawjeꞌ ri kꞌo wi ri chꞌawenel pa kiwiꞌ ri winaq, chakꞌama bꞌik ri sipanik ri xtaqan ri Moisés chubꞌanik, rech kakil ri e chꞌawenelabꞌ pa kiwiꞌ ri winaq chi xatutzir che ri yabꞌil. ");
INSERT INTO quctt_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Are xok bꞌi ri Jesús pa ri tinimit Capernaúm, jun kinimaꞌqil ri ajchꞌoꞌjabꞌ chajil tinimit aj Roma xqet rukꞌ, xuta tobꞌanik che, ");
INSERT INTO quctt_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","xubꞌij: Ajawxel Jesús, ri patanil we kꞌo cho ja, yawabꞌ, sibꞌalaj kunaꞌ qꞌoxom, man kakwin taj kusalabꞌaj ribꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ri Jesús xubꞌij che: Kineꞌek riꞌ, keꞌnkunaj kanoq. ");
INSERT INTO quctt_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ri kinimaꞌqil ri ajchꞌoꞌjabꞌ chajil tinimit xubꞌij: Ajawxel, man taqal ta chwe kok la pa ri wachoch. Kubꞌano we kabꞌij la jun tzij rech jeriꞌ kakunataj ri patanil we. ");
INSERT INTO quctt_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Wetaꞌm in jas jeꞌ ri yoꞌj taqanik xuqujeꞌ ri nimanik. We kinbꞌij che jun ajchꞌoꞌj, “keꞌ pa jun leꞌaj”, keꞌek. We kinsikꞌij xuqujeꞌ apanoq jun chike kapetik. We kintaq jun patanil we chubꞌanik jun jastaq, kubꞌano. ");
INSERT INTO quctt_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ri Jesús xmayijanik are xuta ri xubꞌij ri kinimaꞌqil ri ajchꞌoꞌjabꞌ chajil tinimit. Rumal riꞌ xubꞌij chike ri winaq ri e teren chirij: Qas tzij kinbꞌij chiꞌwe chi man nuriqom ta jun winaq waral pa ri tinimit Israel ri qas kꞌo ukojobꞌal jetaq we achi riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Qas chitatabꞌej we kinbꞌij riꞌ: Kepe na winaq pa taq jaljoj taq tinimit kewaꞌ na rukꞌ ri Dios pa ri rajawarem, ketꞌuyiꞌ na kukꞌ ri e kimam ri Abraham, ri Isaac xuqujeꞌ ri Jacob. ");
INSERT INTO quctt_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Are kꞌu ri e kꞌo apan nabꞌe pa ri ajawarem rech ri Dios, keꞌsax na bꞌik, kekꞌyaq bꞌik pa ri qꞌequꞌmal. Chilaꞌ koꞌqꞌ wi na rumal ri kꞌax, xuqujeꞌ kakiqutꞌutꞌej wi na ri kiware. ");
INSERT INTO quctt_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kꞌa te riꞌ xubꞌij che ri kinimaꞌqil ri ajchꞌoꞌjabꞌ chajil tinimit: Chattzalij cho awachoch, kꞌulmataj awukꞌ jacha ri xakojo. Qas che ri qꞌotaj riꞌ, xutzir ri patanil rech ri achi. ");
INSERT INTO quctt_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ri Jesús xeꞌ cho rachoch ri Pedro, are xrilo chi ri ujiꞌ ixoq ri Pedro yawabꞌ, uriqom jun nimalaj qꞌaqꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ri Jesús xuchap ri uqꞌabꞌ ri ixoq, aninaq xel bꞌik ri qꞌaqꞌ che. Ri ixoq xwaꞌjilik, xuya uwa ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Are xok aqꞌabꞌ, sibꞌalaj e kꞌi winaq xeꞌkikꞌam bꞌik ri e kꞌo itzel taq uxlabꞌal chike, ri Jesús xeꞌresaj bꞌik ri itzel taq uxlabꞌal xa rukꞌ jun tzij xuqujeꞌ xuꞌkunaj konojel ri e yawabꞌibꞌ ri e kꞌo chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jeriꞌ xkꞌulmataj ri uchiꞌm loq ri Dios, ri utzijom loq pa ri uwuj ri qꞌalajisal utzij Dios Isaías: Areꞌ xkꞌamow bꞌik ri qayabꞌilal, xuqujeꞌ xuqꞌiꞌ ri qakꞌaxal. ");
INSERT INTO quctt_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ri Jesús xrilo chi sibꞌalaj e kꞌi winaq e mulan chirij. Rumal riꞌ, xubꞌij chike ri utijoxelabꞌ chi kebꞌe rukꞌ chꞌaqaꞌp che ri cho ri kꞌo pa Galilea. ");
INSERT INTO quctt_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Are xoꞌpan je laꞌ, jun ajtij rech ri taqanik xqet rukꞌ ri Jesús, xubꞌij che: Ajtij, kineꞌ ukꞌ la japawjeꞌ keꞌ wi la. ");
INSERT INTO quctt_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ri Jesús xubꞌij che: Ri e par kꞌo kijul xuqujeꞌ ri aꞌwaj ri kerapinik kꞌo kisok. In, ri in uKꞌojol ri Achi man kꞌo ta kꞌolibꞌal jawjeꞌ kinuxlan wi. ");
INSERT INTO quctt_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kꞌa te riꞌ jun chike ri utijoxelabꞌ xubꞌij che: Ajawxel, ya la bꞌe chwe nabꞌe kinmuq na kan ri nutat, kꞌa te riꞌ kinteriꞌ chij la. ");
INSERT INTO quctt_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ri Jesús xubꞌij che: Chaya bꞌe chike ri e kaminaqibꞌ keꞌkimuq ri e kachiꞌl kikaminaqibꞌ, are kꞌu ri at, chinatereneꞌj. ");
INSERT INTO quctt_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ri Jesús xaqꞌan bꞌik pa ri jukubꞌ bꞌinibꞌal puꞌwiꞌ ri jaꞌ e rachiꞌl ri utijoxelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Are e bꞌenaq chi puꞌwiꞌ ri jaꞌ, xaq kꞌa teꞌ, xwaꞌjil jun nimalaj kyaqiqꞌ xuchapleꞌj ukojik bꞌik ri jaꞌ pa ri jukubꞌ bꞌinibꞌal. Are kꞌu ri Jesús tajin kawarik. ");
INSERT INTO quctt_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ri utijoxelabꞌ xebꞌe chukꞌasuxik, xkibꞌij che: Ajawxel, tajin kujqaj xeꞌ le jaꞌ, chujtoꞌ la. ");
INSERT INTO quctt_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ri Jesús xubꞌij chike: ¿Jas che sibꞌalaj kixiꞌj iwibꞌ? Ix man kuꞌl ta ikꞌuꞌx chirij ri Dios. Xwaꞌjil ri Jesús, xuyaj ri kyaqiqꞌ xuqujeꞌ ri jaꞌ, ronojel kꞌut xjoriꞌk. ");
INSERT INTO quctt_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ri e tijoxelabꞌ xemayijanik, kakibꞌila chibꞌil taq kibꞌ: ¿Jachin waꞌ we achi riꞌ, ri kyaqiqꞌ xuqujeꞌ ri jaꞌ keniman che? ");
INSERT INTO quctt_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Are xopan ri Jesús pa Gadara, ri kꞌo chuchiꞌ ri plo, xeꞌl loq kebꞌ achyabꞌ chuxoꞌl ri muqbꞌal taq kaminaqibꞌ. Sibꞌalaj e xibꞌibꞌal rumal riꞌ maj jun winaq kakwinik kikꞌow pa ri bꞌe riꞌ. Are xeqet ri kebꞌ achyabꞌ rukꞌ ri Jesús, ");
INSERT INTO quctt_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ri itzel taq uxlabꞌal xkiraq kichiꞌ xkibꞌij: Jesús, Ralkꞌwaꞌl ri Dios, ¿jas kaj la chaqe, la kaqꞌat kꞌu la tzij pa qawiꞌ kꞌa majoꞌq kuꞌriqa ri kꞌisbꞌal qꞌatoj tzij? ");
INSERT INTO quctt_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","E kꞌo kꞌu apanoq sibꞌalaj e kꞌi aq chikinaqaj. ");
INSERT INTO quctt_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ri itzel taq uxlabꞌal xkita toqꞌobꞌ che ri Jesús, xkibꞌij: We kujesaj la bꞌik chike we achyabꞌ riꞌ, ya la bꞌe chaqe kujok chike le aq leꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ri Jesús xubꞌij: Chixok chike. Ri itzel taq uxlabꞌal xeꞌl bꞌik chike ri achyabꞌ, xoꞌk chike ri aq. Ri aq kexikꞌanik xebꞌek, man xetakꞌiꞌ taj, xetzaq bꞌik pa ri plo, chilaꞌ xejiqꞌ wi. ");
INSERT INTO quctt_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ri aꞌjyuqꞌabꞌ ke ri aq xaꞌnimaj bꞌik, xebꞌe pa ri tinimit. Chilaꞌ xkitzijoj wi ronojel ri xkꞌulmataj kukꞌ ri aq xuqujeꞌ kukꞌ ri achyabꞌ ri xeꞌl itzel taq uxlabꞌal chike. ");
INSERT INTO quctt_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Konojel ri winaq xeꞌkila ri Jesús, xkita toqꞌobꞌ che rech kel bꞌik pa ri tinimit. ");
INSERT INTO quctt_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Are xtoꞌtaj ri Jesús chubꞌixik we riꞌ, xaqꞌan pa jun jukubꞌ bꞌinibꞌal puꞌwiꞌ ri jaꞌ, xeꞌ chꞌaqaꞌp che ri kꞌo wi, pa ri tinimit ubꞌiꞌnam Capernaúm, jawjeꞌ ri kel wi. ");
INSERT INTO quctt_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Are kꞌo chilaꞌ e nikꞌaj winaq xkikꞌam bꞌik jun achi ri qꞌoyol pa ri uchꞌat, ri man kakwin taj kusalabꞌaj ribꞌ. Ri Jesús are xril ri kikojobꞌal ri winaq xubꞌij che ri achi: Achi, chabꞌana achuqꞌabꞌ. In katinkuy che ronojel ri amak. ");
INSERT INTO quctt_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","E kꞌo kꞌu jujun aꞌjtijabꞌ rech ri taqanik chilaꞌ, xkichomaj: Jachin jun jeꞌ kunaꞌ we achi riꞌ, we pukꞌuꞌx chi are Dios, awas riꞌ ri kuchomaj. ");
INSERT INTO quctt_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ri Jesús retaꞌm ri tajin kakichomaj, rumal riꞌ xuta chike: ¿Jas che sibꞌalaj itzel kixchoman chwij? ");
INSERT INTO quctt_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Jas ri man kꞌax ta ubꞌixik? ¿Xkuyutaj ri amak, o chatwaꞌjiloq chatbꞌinoq? ");
INSERT INTO quctt_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Rech kꞌu kiwilo chi in in uKꞌojol ri Achi, kꞌo nukwinem chukuyik makaj choch ri uwachulew, xubꞌij ri Jesús che ri achi ri man kakwin taj kabꞌinik: Chatwaꞌjiloq, chakꞌama bꞌik ri achꞌat, jat cho awachoch. ");
INSERT INTO quctt_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Xwaꞌjil kꞌu bꞌik ri achi, xeꞌ cho rachoch. ");
INSERT INTO quctt_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Are xkil ri winaq ri xkꞌulmatajik, xemayijanik, xkiqꞌijilaꞌj ri Dios rumal cher uyaꞌom ri kwinem riꞌ chike ri e winaq. ");
INSERT INTO quctt_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Are xel bꞌik ri Jesús chilaꞌ, xril jun achi ubꞌiꞌ Mateo, tꞌuyulik tajin kutoqꞌij alkabal rech ri nim taqanel pa Roma. Xpe ri Jesús xubꞌij che: Chinatereneꞌj. Ri Mateo xwaꞌjil bꞌik, xutereneꞌj ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Pa ri qꞌij riꞌ, ri Jesús xuqujeꞌ ri utijoxelabꞌ xubꞌeꞌwoq cho rachoch ri Mateo. E kꞌi toqꞌil taq alkabal xuqujeꞌ aꞌjmakibꞌ xubꞌeꞌwoq kukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ri fariseos are xeꞌkil we winaq riꞌ, xkita chike ri utijoxelabꞌ ri Jesús, xkibꞌij: ¿Jas che kawaꞌ le iwajtij kukꞌ toqꞌil taq alkabal xuqujeꞌ kukꞌ aꞌjmakibꞌ? ");
INSERT INTO quctt_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Are xuta ri Jesús ri xkibꞌij ri fariseos xubꞌij chike: Man kajawataj taj ajkun chike ri utz kiwach, xane are kajawataj ajkun chike ri e yawabꞌibꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Are katanik, jix chitatabꞌelaꞌ jas kel ri xubꞌij ri Dios are xubꞌij we tzij riꞌ: Are kawaj in utz kixnoꞌjin kukꞌ ri winaq, man are ta kawaj kikꞌam la ri isipanik chinuwach. Xinpe in chikisikꞌixik ri aꞌjmakibꞌ rech kuꞌx nutijoxelabꞌ, man are ta in petinaq chikisikꞌixik ri sibꞌalaj e utz taq winaq kakinaꞌo. ");
INSERT INTO quctt_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jun qꞌijal, ri utijoxelabꞌ ri Juan xeqet rukꞌ ri Jesús, xkita che: ¿Jas che ri uj xuqujeꞌ le fariseos kaqabꞌan qꞌipoj waꞌim, man je ta kꞌu laꞌ kakibꞌan le atijoxelabꞌ? ");
INSERT INTO quctt_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ri Jesús xubꞌij chike: Ri winaq ri e sikꞌital pa jun kꞌulanem man kebꞌison taj, rumal cher kꞌo ri jiꞌatz kukꞌ. Kuꞌriqa kꞌu na qꞌij are kakꞌam bꞌik ri jiꞌatz chikiwach. Kꞌa te riꞌ riꞌ kakibꞌan qꞌipoj waꞌim. ");
INSERT INTO quctt_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","We xtꞌoqopin jun qꞌeꞌl atzꞌyaq, man kakꞌojox taj rukꞌ jun chꞌaqaꞌp kꞌakꞌ atzꞌyaq. Rumal cher are kachꞌaj ri qꞌeꞌl atzꞌyaq, kujikꞌ ribꞌ ri kꞌakꞌ atzꞌyaq kꞌojobꞌal, xuqujeꞌ kutꞌoqopij ronojel ri qꞌeꞌl atzꞌyaq, jeriꞌ kanimataj ri teqꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Xuqujeꞌ man kaya ta ri kꞌakꞌ vino pa qꞌeꞌl taq kꞌolibꞌal, rumal cher ri kꞌakꞌ vino kutꞌoqopij riꞌ ri qꞌeꞌl taq kꞌolibꞌal, xaq jeriꞌ katix ri kꞌakꞌ vino, xuqujeꞌ katꞌoqopin ri kꞌolibꞌal. Rumal riꞌ are utz na we kaya ri kꞌakꞌ vino pa ri kꞌakꞌ taq kꞌolibꞌal, jeriꞌ man katꞌoqopin ta ri kꞌolibꞌal xuqujeꞌ man katix ta ri vino. ");
INSERT INTO quctt_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Tajin katzijon ri Jesús, are xopan jun kꞌamal kibꞌe ri winaq aꞌj Israel, xukiꞌ choch kꞌa te riꞌ xubꞌij che: Xkam ri numiꞌal, we kꞌu keꞌya ri qꞌabꞌ la puꞌwiꞌ, kakꞌastaj na riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Xwaꞌjil ri Jesús, xeꞌ rukꞌ ri achi, e rachiꞌl ri utijoxelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Are e bꞌenaq pa ri bꞌe, xiꞌkꞌow bꞌik jawjeꞌ ri kꞌo wi jun ixoq yawabꞌ kabꞌlajuj junabꞌ. Ri yabꞌil riꞌ kubꞌano chi ri ixoq kutzaq ri ukikꞌel. Are xril ri ixoq chi tajin kiꞌkꞌow bꞌik ri Jesús, ");
INSERT INTO quctt_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","xuchomaj: we ta kꞌo bꞌanom wiꞌ nuchapom apanoq ri umanta ri Jesús, rukꞌ riꞌ kinutzirik. Xqet kꞌut chirij ri Jesús, xuchap ri umanta. ");
INSERT INTO quctt_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ri Jesús xtzalqꞌomijik xukaꞌyej ri ixoq, xubꞌij che: Man kakꞌaxir ta chi awanimaꞌ, are ri akuꞌlibꞌal kuꞌx chirij ri Dios, xatkunanik. Qas che ri qꞌotaj riꞌ xkunataj ri ixoq. ");
INSERT INTO quctt_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ri Jesús xutaqej ri ubꞌe, xopan cho rachoch ri kꞌamal kibꞌe ri winaq aꞌj Israel. Are xopanik, xeꞌril ri ajqꞌojomabꞌ tajin kakibꞌan ri qꞌojom rech muqbꞌal, xuqujeꞌ sibꞌalaj e kꞌi winaq kakiraqaqej kichiꞌ koꞌqꞌik. ");
INSERT INTO quctt_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ri Jesús xubꞌij chike: Chixel bꞌik waral. Ri ali man kaminaq taj, xaq kawarik. Konojel kꞌu ri winaq ri e kꞌo chilaꞌ xetzeꞌn che ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ri Jesús xeꞌresaj bꞌik ri winaq pa ri ja, te kꞌu riꞌ xok bꞌik. Xuchap ri ali che ri uqꞌabꞌ. Ri ali xwaꞌjilik. ");
INSERT INTO quctt_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Konojel ri winaq ri keꞌl pa ri tinimit xketaꞌmaj ri xkꞌulmatajik. ");
INSERT INTO quctt_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Are xel bꞌik ri Jesús chilaꞌ xepe kebꞌ moyabꞌ. Xkitereneꞌj xkichapleꞌj uraqik kichiꞌ xkibꞌij: ¡Jesús, Ralkꞌwaꞌl ri David, toqꞌobꞌisaj la qawach! ");
INSERT INTO quctt_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ri e moyabꞌ xkitereneꞌj bꞌik ri Jesús xok pa ri ja. Are e kꞌo chi pa ri ja, ri Jesús xuta chike: ¿La kikojo chi kinkwinik kixinkunaj? Ri e moyabꞌ xkibꞌij: Jeꞌ, Ajawxel, kaqakojo. ");
INSERT INTO quctt_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ri Jesús xuchap ri kibꞌoqꞌoch kꞌa te riꞌ xubꞌij: Kꞌulmataj iwukꞌ ri kikojo. ");
INSERT INTO quctt_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Aninaq xekwinik xekaꞌy chi junmul. Ri Jesús xubꞌij chike: Man kitzijoj ta chi chike nikꞌaj ri xkꞌulmatajik. ");
INSERT INTO quctt_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ri achyabꞌ are xeꞌl loq xkitzijoj ri xubꞌan ri Jesús chike konojel ri winaq pa ri tinimit. ");
INSERT INTO quctt_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Are tajin keꞌl bꞌik ri achyabꞌ pa ri ja, e nikꞌaj winaq xkikꞌam loq rukꞌ ri Jesús jun achi ri man kakwin taj kachꞌawik rumal cher kꞌo jun itzel uxlabꞌal che. ");
INSERT INTO quctt_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ri Jesús xresaj bꞌik ri itzel uxlabꞌal ri kꞌo che ri achi, are xesataj bꞌik ri itzel uxlabꞌal che, ri achi xchꞌawik. Ri winaq ri e kꞌo chilaꞌ xemayijanik, xkibꞌij: Man ilom ta wi pa Israel jun kꞌulmatajem jetaq we riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ri fariseos xkibꞌij: We Jesús karesaj itzel taq uxlabꞌal, rumal cher yaꞌtal kwinem che rumal ri kꞌamal kibꞌe ri itzel taq uxlabꞌal. ");
INSERT INTO quctt_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ri Jesús xikꞌow pa taq ri nimaꞌq xuqujeꞌ nitzꞌ taq tinimit. Xuya kꞌutuꞌn pa taq ri Sinagoga, xutzijoj ri utz laj taq tzij rech ri ajawarem rech ri Dios, xuꞌkunaj ri winaq ri kꞌo kꞌaxal xuqujeꞌ yabꞌilal chike. ");
INSERT INTO quctt_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Are xril ri kikꞌyal ri winaq ri e teren chirij, xutoqꞌobꞌisaj kiwach, rumal xrilo chi sibꞌalaj e sachinaq pa ri kichomanik xuqujeꞌ maj jachin ketoꞌwik, jacha ta ne ri chij ri maj kajyuqꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ri Jesús xubꞌij chike ri utijoxelabꞌ: Sibꞌalaj e kꞌi ri kajawataj chike koꞌk pa ri ajawarem rech ri Dios, man e kꞌi ta kꞌut tijoxelabꞌ ketzijon ri utz laj taq tzij chike we winaq riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Rumal riꞌ, chita che ri Dios, ri ajchoqꞌe ri chak chuꞌtaqa loq nikꞌaj ajchakibꞌ chik pa ri uchak. ");
INSERT INTO quctt_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ri Jesús xuꞌmulij ri e kabꞌlajuj utijoxelabꞌ. Xuya kwinem chike chi resaxik itzel taq uxlabꞌal xuqujeꞌ chukunaxik ronojel uwach yabꞌilal. ");
INSERT INTO quctt_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Are waꞌ ri kibꞌiꞌ ri e kabꞌlajuj tijoxelabꞌ, ri xbꞌix taqoꞌn chike rumal ri Jesús: Simón ri xubꞌinaꞌj Pedro, ri rachalal ubꞌiꞌ Andrés; ri Jacobo xuqujeꞌ ri rachalal Juan, e ralkꞌwaꞌl ri Zebedeo; ");
INSERT INTO quctt_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ri Felipe, ri Bartolomé, ri Tomás, ri Mateo ri toqꞌil alkabal, ri Jacobo ukꞌojol ri Alfeo, ri Tadeo, ");
INSERT INTO quctt_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ri Simón ri kachiꞌl ri Cananeos, xuqujeꞌ ri Judas Iscariote ri xkꞌayin ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ri Jesús xuꞌtaq bꞌik ri e kabꞌlajuj utijoxelabꞌ, xubꞌij chike: Man kixeꞌ taj pa ri tinimit jawjeꞌ ri e kꞌo wi ri winaq ri man aꞌj Israel taj. Xuqujeꞌ man kixeꞌ taj pa taq ri tinimit rech Samaria. ");
INSERT INTO quctt_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Xane jix kukꞌ taq ri winaq ri aꞌj Israel rumal jer e kꞌo ri tinimit ri kejunumataj kukꞌ ri chij ri e sachinaq. ");
INSERT INTO quctt_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Are chixeꞌek chitzijoj we tzij riꞌ: Xqebꞌ loq ri ajawarem rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Chiꞌkunaj ri e yawabꞌibꞌ. Chiꞌkꞌastajisaj kaminaqibꞌ. Chiꞌkunaj ri e chꞌaꞌkibꞌ, chiꞌwesaj ri itzel taq uxlabꞌal ri e kꞌo chike ri winaq. Maj pwaq kitoqꞌij rumal ubꞌanik taq we jastaq riꞌ, rumal cher maj pwaq xuta ri Dios are xuya ri ukwinem chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mikꞌam bꞌik qꞌana pwaq xuqujeꞌ saqa pwaq pa ri ximbꞌal ipam. ");
INSERT INTO quctt_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Xuqujeꞌ mikꞌam bꞌik ijastaq rech pa bꞌe, mikꞌam bꞌik ichꞌamiꞌy, mikꞌam bꞌik jukꞌulaj ixajabꞌ chik, xuqujeꞌ mikꞌam bꞌik jun wok iwatzꞌyaq chik. Rumal cher yaꞌtalik katzuq ri ajchak. ");
INSERT INTO quctt_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Are kixopan pa ri tinimit o pa ri leꞌaj, chitzukuj jachinaq ri kuya kuꞌlibꞌal kꞌuꞌx chiꞌwe, chixkꞌol rukꞌ pa ri rachoch, kꞌa kixel na bꞌik pa ri leꞌaj. ");
INSERT INTO quctt_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Are kixok bꞌik pa ri ja, chiya rutzil kiwach ri e kꞌo chilaꞌ, chitzuju jaꞌmaril chike ri e kꞌo pa ri ja kꞌolibꞌal. ");
INSERT INTO quctt_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","We kataqiꞌk kakikꞌamawaꞌj jaꞌmaril ri winaq ri e kꞌo pa ri ja, kayaꞌtaj na riꞌ chike. We kꞌu man kataqiꞌk chike, man kakikꞌamawaꞌj ta riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","We man kixkꞌamawaꞌx pa jun ja o jun tinimit xuqujeꞌ man kakaj ta ri winaq kixkitatabꞌej, chitota kan ri ulew ri kꞌo che ri iwaqan, kꞌutbꞌal rech chi man xixkꞌamawaꞌx taj. Kꞌa te riꞌ chixel bꞌik chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Qas tzij kinbꞌij chiꞌwe chi pa ri qꞌij ri kabꞌan ri kꞌisbꞌal qꞌatoj tzij, kꞌo na ri kꞌax ri kakiriq ri tinimit riꞌ, ri jeriꞌ kenoꞌjinik, choch ri xkiriq ri e tinimit Sodoma xuqujeꞌ ri Gomorra. ");
INSERT INTO quctt_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","¡Qas xibꞌibꞌal wi ubꞌanik ri chak ri kixintaq bꞌik chubꞌanik! Je ta ne ri keꞌntaq bꞌik chij chikixoꞌl ri e kayoꞌt. Rumal riꞌ chikojo ri iwetaꞌmabꞌal, xuqujeꞌ qas chichomaj na rij ri jastaq jeꞌ jas ri kubꞌan ri kumatz, xuqujeꞌ rajawaxik kimochꞌ iwibꞌ jetaq ri kubꞌan ri palomax. ");
INSERT INTO quctt_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Chichajij iwibꞌ rumal cher kixjach na chkiwach ri e qꞌatal taq tzij, xuqujeꞌ kixchꞌay na pa taq ri Sinagoga. ");
INSERT INTO quctt_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Xuqujeꞌ kixkꞌam na bꞌik chikiwach ri e nimaq taq taqanelabꞌ xuqujeꞌ kixchꞌaw na chikiwach ri winaq ri man aꞌj Israel taj, xa rumal cher ix nutijoxelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Are kixjach cho ri qꞌatbꞌal tzij, man kakꞌaxir taj iwanimaꞌ chuchomaxik ri kibꞌij, xuqujeꞌ jas kibꞌan che ubꞌixik, rumal cher are ri Dios kabꞌin na chiꞌwe pa ri qꞌotaj, ri rajawaxik kibꞌij. ");
INSERT INTO quctt_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Man ix taj riꞌ ri kixchꞌawik, are ri Tyoxalaj Uxlabꞌixel kachꞌaw na chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ri aꞌlaxik pa kachoch kakijach taq na kibꞌ pa kamikal. Ri e tat nan keꞌkijach na pa kamikal ri e kalkꞌwaꞌl, xuqujeꞌ ri alkꞌwaꞌlaxelabꞌ keꞌkichꞌey na ri kitat kinan xuqujeꞌ keꞌkikamisaj na. ");
INSERT INTO quctt_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Konojel ri winaq rech uwachulew kixketzelaj na rumal cher ix nutijoxelabꞌ. We kꞌu qas kajeqiꞌ ikꞌuꞌx chwij kꞌa pa ri kꞌisbꞌal rech ri qꞌotaj, kixin kol na. ");
INSERT INTO quctt_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Are kixkoqataj ri winaq rech jun tinimit rech kixkimamisaj, jix chi apanoq pa jun tinimit chik. Qas tzij kinbꞌij chiꞌwe, in, ri in uKꞌojol ri Achi, kintzalij na loq rukꞌ ronojel ri ukwinem ri Dios, are majaꞌ kakꞌis chusolixik ronojel ri tinimit rech Israel iwumal. ");
INSERT INTO quctt_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Man are taj ri tijoxel nim uqꞌij choch ri rajtij, man are taj ri ajchak nim uqꞌij choch ri upatrón. ");
INSERT INTO quctt_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ri tijoxel xaq xwi kakwinik kux junam rukꞌ ri rajtij, xuqujeꞌ ri ajchak kux na junam rukꞌ ri upatrón. We kakibꞌij ri winaq chi in ri in Itzel, ¿jas ta kꞌu mat kabꞌix na chiꞌwe ix? ");
INSERT INTO quctt_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Man kixiꞌj ta iwibꞌ choch jun winaq chik, rumal cher ronojel ri awatalik, kilitaj na uwach, xuqujeꞌ ronojel ri xaq pa awal bꞌiꞌtal wi, ketaꞌmataj na. ");
INSERT INTO quctt_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","We kinbꞌij jun jastaq chiꞌwe pa ri qꞌequꞌm, chibꞌij ix cho ri utunal ri qꞌij, we kinbꞌij jun jastaq chiꞌwe pa awal, chitzijoj ix chike konojel ri winaq rech ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Man kixiꞌj ta iwibꞌ chikiwach ri winaq ri kakikamisaj ri ityoꞌjal, are chixiꞌj iwibꞌ choch ri kꞌo ukwinem chukꞌisik tzij piꞌwiꞌ pa ri tyoꞌnel qꞌaqꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Man sibꞌalaj ta paqal kajil ri e kebꞌ chochiꞌ, maj kꞌu jun kakam chike, we man are ri iTat kayoꞌw bꞌe che. ");
INSERT INTO quctt_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ri Dios retaꞌm janipa iwiꞌ ix kꞌo pa ijolom. ");
INSERT INTO quctt_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Rumal riꞌ man kixiꞌj ta iwibꞌ, rumal cher ix paqal iwajil chikiwach ri e chochiꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","We kibꞌij chike nikꞌaj winaq chik chi ix ix nutijoxelabꞌ, kinbꞌij xuqujeꞌ na in che ri nuTat ri kꞌo pa ri kaj chi qas tzij wi. ");
INSERT INTO quctt_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","We kꞌu kibꞌij chike ri winaq chi man ixtereneꞌl taq we taj, kinbꞌij xuqujeꞌ na in che ri nuTat chi qas man ixtereneꞌl taq we taj. ");
INSERT INTO quctt_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Michomaj chi in petinaq chuyaꞌik jaꞌmaril choch we uwachulew riꞌ. Man jaꞌmaril ta ri nukꞌamom loq xane chꞌoꞌj xuqujeꞌ kꞌaxal. ");
INSERT INTO quctt_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","In petinaq chukojik Chꞌoꞌj chikixoꞌl ri alkꞌwaꞌlaxel xuqujeꞌ ri utat, xuqujeꞌ chꞌoꞌj chikixoꞌl ri ali xuqujeꞌ ri unan, ri alibꞌatz rukꞌ ri ralibꞌ ixoq. ");
INSERT INTO quctt_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ri ikꞌulel pa ri iwachoch na kel wi. ");
INSERT INTO quctt_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ri are nim karil ri utat o ri unan chinuwach in, o are ne nim karil ri ukꞌojol xuqujeꞌ ri umiꞌal chinuwach in, man kataqiꞌ ta ri kixux we in. ");
INSERT INTO quctt_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ri man kareqaj ta ri ucheꞌ ripbꞌal xuqujeꞌ kinutereneꞌj man kataqiꞌ che kux we in. ");
INSERT INTO quctt_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ri xaq xwi kakꞌaxir ranimaꞌ che ri ukꞌaslemal, katzaqmaj na riꞌ. Are kꞌu we kuya ri ukꞌaslemal rumal we in, qas tzij kinbꞌij chiꞌwe, chi kachꞌeken na. ");
INSERT INTO quctt_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ri winaq ri kixukꞌamawaꞌj, kinukꞌamawaꞌj xuqujeꞌ in. Ri winaq ri kinukꞌamawaꞌj in, kukꞌamawaꞌj xuqujeꞌ ri Dios, are xintaqow loq. ");
INSERT INTO quctt_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ri Dios kuya na tojbꞌal chike ri winaq ri kakikꞌamawaꞌj jun qꞌalajisal utzij ri Dios cho ri kachoch, rumal chi ri qꞌalajisal tzij, utzij ri Dios kubꞌij. Ri tojbꞌal junam riꞌ rukꞌ ri kuya ri Dios chike ri e qꞌalajisal taq tzij. ");
INSERT INTO quctt_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Qas tzij kinbꞌij chiꞌwe, man kasachan ta che ri Dios kutoj ukꞌaxel juqubꞌ joron, ri kasipax chike ri e tereneꞌl taq re, pune man nim taj kakaꞌyik. ");
INSERT INTO quctt_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Are xtoꞌtaj ri Jesús chubꞌixik we jastaq riꞌ chike ri kabꞌlajuj utijoxelabꞌ, xeꞌ pa taq nikꞌaj tinimit chik chutzijoxik xuqujeꞌ chukꞌutik ri utz laj tzij. ");
INSERT INTO quctt_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ri Juan Bꞌanal qasanaꞌ, are xutabꞌej ronojel ri tajin kubꞌan ri Jesús, xuꞌtaq bꞌik e jujun utijoxelabꞌ rech keꞌkita che ri Jesús: ");
INSERT INTO quctt_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","¿La lal riꞌ ri Mesías ri xubꞌij kan ri Dios chaqe chi kutaq na loq, o kaqayeꞌj na jun chik? ");
INSERT INTO quctt_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ri Jesús xubꞌij: Chixtzalijoq, chitzijoj che ri Juan ronojel ri tajin kito xuqujeꞌ kiwilo. ");
INSERT INTO quctt_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ri moyabꞌ kekaꞌyik, ri chꞌokeꞌr kebꞌinik, kuꞌtzir ri e chꞌaꞌkibꞌ, xuqujeꞌ ri tꞌoꞌyabꞌ kakita chik, kekꞌastaj ri kaminaqibꞌ xuqujeꞌ katzijox ri utz laj tzij rech kolotajem chike ri e mebꞌaibꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Utz re ri winaq ri man kutopij ta raqan rumal we. ");
INSERT INTO quctt_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Are xebꞌe ri utijoxelabꞌ ri Juan, ri Jesús xuchapleꞌj utzijoxik rij ri Juan chike ri winaq, xubꞌij: ¿Jas uwach achi xiꞌwila, are xixeꞌ pa ri ulew ri katzꞌinowik? ¿La xiꞌwila jun achi ri kumejejej ribꞌ jetaq ri kubꞌan ri patzꞌan ri kamejejex rumal ri kyaqiqꞌ? ");
INSERT INTO quctt_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿La xiꞌwila jun achi ri ukojom atzꞌyaq ri sibꞌalaj paqal rajil? Naꞌtaj chiꞌwe chi ri winaq ri paqal taq kaꞌtzyaqinik, pa taq ri nimaꞌq taq tꞌuyulibꞌal kech ri taqanelabꞌ xuqujeꞌ pa taq ri kitꞌuyulibꞌal ri e taqanelabꞌ e tꞌuyul wi. ");
INSERT INTO quctt_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Jachin kꞌu xiꞌwila? ¿La xiꞌwila jun qꞌalajisal utzij ri Dios? Jeꞌ jeriꞌ, ri Juan sibꞌalaj nim na uqꞌij choch jun qꞌalajisal utzij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Are waꞌ ri taqoꞌn, ri ubꞌim loq ri Dios pa ri utzij, are xubꞌij: Kintaq na bꞌik ri nutaqoꞌn, kanabꞌej chawach, rech kusukꞌumaj apanoq ri abꞌe. ");
INSERT INTO quctt_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Qas tzij kinbꞌij chiꞌwe majaꞌ kalax jun achi ri sibꞌalaj nim na uqꞌij choch ri Juan ri bꞌanal qasanaꞌ. Pa ri rajawarem kꞌu ri Dios, ri winaq ri sibꞌalaj nitzꞌ uqꞌij are nim na uqꞌij cho ri Juan. ");
INSERT INTO quctt_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Pa ri qꞌij ri xuchapleꞌj loq Juan Bꞌanal qasanaꞌ utzijoxik ri utzij ri Dios ri Juan Bꞌanal qasanaꞌ, kꞌa pa taq we qꞌij riꞌ, tajin kanimar ri ajawarem rech ri Dios, pune e kꞌo uꞌkꞌulel. Xaq xwi ri e winaq ri kakibꞌan kichuqꞌabꞌ xuqujeꞌ kuchap kikꞌuꞌx, xaq xwi waꞌ koꞌk pa ri ajawarem rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ri Dios xutzijoj loq pa ri utzij ri kakꞌulmataj na are kape ri Juan Bꞌanal qasanaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","We kikojo o man kikoj taj, ri Dios are xubꞌij chi kutaq loq ri qꞌalajisal utzij ri Dios, Elías, are xutzijoj loq rij ri Juan Bꞌanal qasanaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ri kꞌo uxikin chutatabꞌexik, qas chutatabꞌej. ");
INSERT INTO quctt_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ix winaq ri ix kꞌo kamik, jer ix kꞌo ri akꞌalabꞌ ri kixtꞌuyiꞌ pa taq ri kꞌayibꞌal kixetzꞌanik, xuqujeꞌ kiraq ichiꞌ kibꞌij chike nikꞌaj akꞌalabꞌ chik: ");
INSERT INTO quctt_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Xqoqꞌisaj ri chirimiꞌy rech ri kꞌulanem, man xixxojow taj xuqujeꞌ xqabꞌixoj bꞌisobꞌal taq bꞌix, rech kamikal man xixoqꞌ taj. ");
INSERT INTO quctt_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Rumal riꞌ ri Juan Bꞌanal qasanaꞌ are man xwaꞌ taj, xibꞌij che chi xa kꞌo jun itzel uxlabꞌal che. ");
INSERT INTO quctt_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kꞌa te riꞌ xinpe in, ri in uKꞌojol ri Achi, kinwaꞌik xuqujeꞌ kinqumun iwukꞌ, kibꞌij chi xaq kinpaqꞌ nupam, in jun qꞌabꞌarel, xuqujeꞌ are e wech chꞌabꞌem ri itzel taq winaq ri man keniman taj che ri Dios. Xa kꞌu naꞌtaj chiꞌwe chi ri etaꞌmabꞌal rech ri Dios kilitajik rumal ri kabꞌanik. ");
INSERT INTO quctt_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ri Jesús xyojtaj kukꞌ ri winaq ri keꞌl pa taq ri tinimit ri xubꞌan wi sibꞌalaj kꞌi mayijabꞌal taq jastaq, rumal cher ri winaq man xkikꞌex ta wi ri kinoꞌjibꞌal xuqujeꞌ man kakaj taj kakinimaj ri Dios, rumal ri xubꞌij chike: ");
INSERT INTO quctt_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","¡Winaq rech ri tinimit Corazín, qas kiriq wi na ri kꞌax! ¡Je xuqujeꞌ ix winaq ri kixel pa ri tinimit Betsaida! We ta xbꞌan ri mayijabꞌal taq jastaq ri xbꞌan chiꞌxoꞌl ix je laꞌ pa taq ri tinimit Tiro xuqujeꞌ Sidón, najtir ta riꞌ xkikꞌex kikꞌuꞌx ri e winaq ri keꞌl chilaꞌ. Xkikoj ta koxtar taq katzꞌyaq riꞌ, xuqujeꞌ xkiya ta chaj riꞌ pa taq kijolom chukꞌutik chi kakikꞌex kikꞌuꞌx. ");
INSERT INTO quctt_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Qas tzij kinbꞌij chiꞌwe chi ri kꞌisbꞌal qꞌatoj tzij ri kape na pa iwiꞌ, nim na choch ri kape pa kiwiꞌ we winaq riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ri ix winaq ri kixel pa ri tinimit Capernaúm, ¿teꞌq pa ikꞌuꞌx chi ix kꞌo chik pa ri kaj? Kinbꞌij kꞌu chiꞌwe chi kixkꞌyaq na bꞌik qas pa ri ukꞌuꞌx ri tyoꞌnel qꞌaqꞌ. We ta xbꞌan ri mayijabꞌal taq jastaq ri xbꞌan iwukꞌ ix, kukꞌ ri winaq ri xekꞌojiꞌ pa ri tinimit Sodoma, xkikꞌex ta kibꞌ riꞌ ri winaq riꞌ, xuqujeꞌ kꞌa kꞌo ta na ri tinimit riꞌ kamik. ");
INSERT INTO quctt_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Qas tzij kinbꞌij chiꞌwe chi ri kꞌisbꞌal qꞌatoj tzij ri kape na piꞌwiꞌ, nim na choch ri qꞌatoj tzij ri xpe pa kiwiꞌ aꞌreꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Pa ri qꞌotaj riꞌ, ri Jesús xubꞌij che ri Dios: Tataxel, ri kabꞌan e la puꞌwiꞌ ri kaj xuqujeꞌ puꞌwiꞌ ri uwachulew, tyox che la rumal cher man xkꞌut ta la we jastaq riꞌ chikiwach ri achyabꞌ ri sibꞌalaj kꞌo ketaꞌmabꞌal, xane are xkꞌut la chikiwach ri winaq ri jer e kꞌo akꞌalabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Jeriꞌ xbꞌan la rumal, cher jeriꞌ xqaj choch la. ");
INSERT INTO quctt_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ri Jesús xubꞌij chike ri winaq ri e kꞌo chilaꞌ: Ri nuTat uyaꞌom chwe ronojel ri jastaq rumal cher xaq xwi areꞌ retaꞌm nuwach. Maj chi jun qas etaꞌmaninaq uwach ri nuTat, xaq xwi ri in. Rumal laꞌ kintzijoj ri nuTat chike nikꞌaj winaq chik, rech kaketaꞌmaj uwach. ");
INSERT INTO quctt_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Chixpeta wukꞌ ri ix ri ronojel qꞌij kixbꞌisonik xuqujeꞌ kakꞌaxir iwanimaꞌ rech kinbꞌan chiꞌwe kixuxlanik. ");
INSERT INTO quctt_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Chinimaj ri nutaqanik, xuqujeꞌ chiwetaꞌmaj iwe wukꞌ, rumal cher in kinjororik xuqujeꞌ qas kinmochꞌ wanimaꞌ. Wukꞌ in utz kixuxlanik. ");
INSERT INTO quctt_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Man kꞌax taj ri kintaqan in chubꞌanik, xuqujeꞌ man al taj ri eqaꞌn ri kixintaq bꞌik chukꞌamik. ");
INSERT INTO quctt_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Pa jun qꞌij rech uxlanem, ri Jesús rachiꞌl ri utijoxelabꞌ tajin kebꞌin pa jun ulew jawjeꞌ ri tiktal wi tiriko. Ri tijoxelabꞌ xenumik, rumal riꞌ xkichapleꞌj utzukuxik ri ujolom tiriko xuqujeꞌ xkichapleꞌj utijik. ");
INSERT INTO quctt_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ri fariseos are xkilo chi ri tijoxelabꞌ tajin kakitzukuj ri ujolom ri tiriko, xkibꞌij che ri Jesús: Chawilampe ri tajin kakibꞌan ri atijoxelabꞌ, ri taqanik kubꞌij chi man yaꞌtal taj kabꞌan le jastaq leꞌ pa ri qꞌij rech uxlanem. ");
INSERT INTO quctt_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ri Jesús xubꞌij chike: ¿Man isikꞌim ta kꞌu ri kubꞌij ri utzij ri Dios, jawjeꞌ kubꞌij wi ri xubꞌan ri David xuqujeꞌ ri e rachiꞌl are xenumik? ");
INSERT INTO quctt_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Xoꞌk bꞌik pa ri rachoch ri Dios, xkitij ri kaxlan wa ri tyoxirisatalik. Man yaꞌtal ta che ri David xuqujeꞌ ri e rachiꞌl kakitij we kaxlan wa riꞌ, xane xwi yaꞌtal chike ri e chꞌawenelabꞌ pa kiwiꞌ ri winaq. ");
INSERT INTO quctt_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Man isikꞌim ta kꞌut ri wuj rech taqanik rech ri Moisés, man iwetaꞌm ta kꞌut chi ri e chꞌawenelabꞌ pa kiwiꞌ ri winaq ri kechakun pa ri Templo kekwinik kechakun pa ri qꞌij rech uxlanem, xuqujeꞌ maj jun winaq kakwinik kamolow kimak? ");
INSERT INTO quctt_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Qas tzij kinbꞌij chiꞌwe chi waral kꞌo wi jun ri nim uqꞌij cho ri Templo. ");
INSERT INTO quctt_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Man kichꞌobꞌ ta riꞌ ri xubꞌij ri Dios are xubꞌij: Man kawaj taj kiꞌtzuj aꞌwaj chinuwach, are kawaj kiꞌloqꞌaj ri winaq, xuqujeꞌ kiꞌtoꞌo. ");
INSERT INTO quctt_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Rumal kꞌu cher in ri in uKꞌojol ri Achi, in kabꞌan we puꞌwiꞌ ri qꞌij rech uxlanem, in kinbꞌinik jas ri yaꞌtalik kabꞌanik xuqujeꞌ jas ri man yaꞌtal taj. ");
INSERT INTO quctt_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ri Jesús xok bꞌik pa ri Sinagoga rech ri leꞌaj. ");
INSERT INTO quctt_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Chilaꞌ kꞌo wi jun achi ri man kakwin taj kusalabꞌaj jun uqꞌabꞌ. Ri fariseos rumal cher kakaj kakimol umak ri Jesús xkibꞌij: ¿La kuya bꞌe ri taqanik kakunax jun winaq pa ri qꞌij rech uxlanem? ");
INSERT INTO quctt_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ri Jesús xubꞌij: We kꞌo jun chiꞌwe katzaq bꞌik jun uchij pa jun jul pa jun qꞌij rech uxlanem, ¿la keꞌresaj loq chilaꞌ? Jas mat keꞌresaj wi. ");
INSERT INTO quctt_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Jun winaq kꞌut are nim uqꞌij choch jun chij. Rumal laꞌ yaꞌtalik kabꞌan ri utzilal pa ri qꞌij rech uxlanem. ");
INSERT INTO quctt_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kꞌa te riꞌ, ri Jesús xubꞌij che ri achi ri man kakwin taj kusalabꞌaj ri uqꞌabꞌ: Chayuqu ri aqꞌabꞌ. Ri achi xuyuq ri uqꞌabꞌ, aninaq xutzirik, je xkanajik jetaq ri jun uqꞌabꞌ chik ri utz. ");
INSERT INTO quctt_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ri fariseos xeꞌl bꞌik pa ri Sinagoga, xkichapleꞌj uchomaxik jas kakibꞌan chukamisaxik ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ri Jesús kꞌut retaꞌm ri tajin kakichomaj ri fariseos, rumal riꞌ xeꞌl bꞌik chilaꞌ, e kꞌi winaq xeteriꞌ bꞌik chirij. Ri Jesús xuꞌkunaj konojel ri e yawabꞌibꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Xuchilibꞌej chike ri winaq chi man kakitzijoj taj jachin ri areꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jeriꞌ xkꞌulmatajik ri tzꞌibꞌatal pa ri utzij ri Dios ri xubꞌij loq ri qꞌalajisal tzij rech ri Dios, Isaías, are xubꞌij: ");
INSERT INTO quctt_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Chiwilampeꞌ, ri patanil we ri xinchaꞌo. Sibꞌalaj nuloqꞌ, xuqujeꞌ kunojisaj ri wanimaꞌ che kiꞌkotemal. In kinya na ri uxlabꞌixel we che, Areꞌ katzijon na ri nusukꞌal chikixoꞌl konojel ri winaq pa ronojel tinimit. ");
INSERT INTO quctt_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Man kutij ta chuqꞌabꞌ pa tzij rukꞌ jachinaq, Xuqujeꞌ man kuraq ta uchiꞌ. Maj jun katow ri uchꞌabꞌal pa taq ri bꞌe. ");
INSERT INTO quctt_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Man kubꞌan ta kꞌax chike ri kiriqom kꞌax, Xuqujeꞌ man kuꞌkamisaj ta ri xa jubꞌiqꞌ kakaj kekamik, Xane kuya kichuqꞌabꞌ ri maj kichuqꞌabꞌ, Xuqujeꞌ kubꞌan na chi are kachꞌeken che ri sukꞌal. ");
INSERT INTO quctt_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Konojel ri winaq ri e kꞌo cho ri uwachulew kakubꞌiꞌ na kikꞌuꞌx chirij. ");
INSERT INTO quctt_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","E nikꞌaj winaq xkikꞌam bꞌik jun achi rukꞌ ri Jesús rech kakunax loq. Ri achi moy xuqujeꞌ man kachꞌaw taj rumal cher kꞌo jun itzel uxlabꞌal che. Ri achi xkunax loq rumal ri Jesús, xkwinik xchꞌawik xuqujeꞌ xkaꞌyik. ");
INSERT INTO quctt_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Xemayijan ri winaq rumal ri xubꞌan ri Jesús, xuqujeꞌ kakitatabꞌela chibꞌil taq kibꞌ: ¿La are waꞌ ri Jesús ri Mesías, ri Ralkꞌwaꞌl ri David, ri xutzuj kanoq ri Dios chi kape chqakolik? ");
INSERT INTO quctt_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","E kꞌo jujun chike ri fariseos are xkita ri xkibꞌij ri winaq, xkibꞌij: Ri Jesús keꞌresaj ri itzel taq uxlabꞌal chike ri winaq, rumal cher are ri Beelzebú ri kinimaꞌqil ri itzel taq uxlabꞌal kayoꞌw kwinem che. ");
INSERT INTO quctt_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ri Jesús retaꞌm ri tajin kakibꞌij, rumal riꞌ xubꞌij chike: We kechꞌoꞌjin jun tinimit kukꞌ ri e kiwinaqil, katukin riꞌ ri tinimit. We kechꞌoꞌjin jun laj tinimit kukꞌ ri kiwinaqil, katukin riꞌ ri laj tinimit. We kechꞌoꞌjin jun ja winaq kukꞌ taq ri e kachalal, xaq aꞌreꞌ ri kakitukij kibꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","We kachꞌoꞌjin ri Itzel rukꞌ ri Itzel, xaq rukꞌ areꞌ riꞌ kachꞌoꞌjin wi, katukin kꞌu na riꞌ ri rajawarem. ");
INSERT INTO quctt_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kibꞌij ix chi keꞌnwesaj ri itzel taq uxlabꞌal rumal cher are ri Itzel kayoꞌw ri kwinem chwe. We ta qas tzij riꞌ ¿jachin kayoꞌw ri kwinem chike ri iꞌtijoxelabꞌ ix rech kakesaj ri itzel taq uxlabꞌal? We kibꞌij chwe chi are ri Dios kayoꞌw ri kwinem chike, qas kaqꞌalajin na chi ix, ix sachinaq. ");
INSERT INTO quctt_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","We keꞌnwesaj in ri itzel taq uxlabꞌal rukꞌ ri ukwinem ri Tyoxalaj Uxlabꞌixel, rukꞌ riꞌ kinkꞌutu chi ri ajawarem rech ri Dios kꞌo chi waral. ");
INSERT INTO quctt_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","We kꞌo jun achi karaj kareleqꞌaj ri kꞌo pa rachoch jun achi ri sibꞌalaj kꞌo uchuqꞌabꞌ, nabꞌe riꞌ kujatꞌij na kan ri achi ri kꞌo uchuqꞌabꞌ. Kꞌa te riꞌ kakwin riꞌ kareleqꞌaj bꞌik ronojel ri jastaq. ");
INSERT INTO quctt_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ri man wachiꞌl taj, nukꞌulel riꞌ. Ri man kinutoꞌ taj chi kikꞌamik loq e winaq wukꞌ rech kinkitereneꞌj, xa tajin kuꞌtukij bꞌi riꞌ ri winaq. ");
INSERT INTO quctt_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Rumal laꞌ kinbꞌij chiꞌwe chi kakuyutaj na ronojel uwach makaj, xuqujeꞌ xapakux yoqꞌoj ri kabꞌanik, are kꞌu ri winaq ri kaketzelaj uwach ri Tyoxalaj Uxlabꞌixel man kakuyutaj ta wi. ");
INSERT INTO quctt_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Xapachin ri kubꞌij kꞌax taq tzij chwe in, ri in uKꞌojol ri Achi, kakuyutaj na umak, are kꞌu ri karetzelaj ri Tyoxalaj Uxlabꞌixel, man kakuyutaj ta wi umak choch ri uwachulew, xuqujeꞌ man kakuyutaj taj pa ri kꞌaslemal ri kape na. ");
INSERT INTO quctt_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jun utz cheꞌ utz taq uwach kuyaꞌo. Jun itzel cheꞌ itzel taq uwach kuyaꞌo. We kajawaxik ketaꞌmaxik we utz ri cheꞌ o man utz taj, xaq xwi rajawaxik kil ri uwach. Je xuqujeꞌ kakꞌulmataj kukꞌ ri winaq. We rajawaxik ketaꞌmax kiwach we e utz o man e utz taj, xaq xwi rajawaxik kil ri jastaq ri kakibꞌano. ");
INSERT INTO quctt_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kijaꞌl taq kumatz, ¿jamo riꞌ kibꞌij utz taq jastaq we ix itzel taq winaq? Jun utz winaq, utz taq jastaq riꞌ kubꞌij, jun itzel winaq itzel taq jastaq riꞌ kubꞌij. ");
INSERT INTO quctt_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ri utz laj winaq, are karesaj loq ri utzilal ri uyakom pa ranimaꞌ, are kꞌu ri itzel winaq, are karesaj loq ri etzelal ri kꞌo pa ranimaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Qas kinbꞌij chiꞌwe, pa ri kꞌisbꞌal qꞌatoj tzij ri kabꞌan na, iwonojel kibꞌij na jas rumal xibꞌij kꞌax taq tzij chubꞌanik kꞌax chike nikꞌaj winaq chik. ");
INSERT INTO quctt_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ri Dios kuqꞌat na tzij pa iwiꞌ chi ijujunal rumal ri tzij ri xibꞌij. We xibꞌij utz taq tzij kixkolotaj na, we are xibꞌij itzel taq jastaq, kaqꞌat na tzij pa iwiꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","E kꞌo jujun fariseos xuqujeꞌ aꞌjtijabꞌ rech ri taqanik xkibꞌij che ri Jesús: Ajtij, kaqaj kabꞌan la jun jastaq ri kakꞌutuwik chi are ri Dios taqowinaq la loq. ");
INSERT INTO quctt_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ri Jesús xubꞌij chike: Ix sibꞌalaj ix itzel taq winaq, man kakubꞌiꞌ ta ikꞌuꞌx chirij ri Dios, are kiwaj kinkꞌut jun mayijabꞌal jastaq chiꞌwach. Ri jastaq ri kinkꞌut chiꞌwach are ri xkꞌulmataj rukꞌ ri qꞌalajisal utzij ri Dios Jonás. ");
INSERT INTO quctt_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jacha ri Jonás xkꞌojiꞌ oxibꞌ qꞌij xuqujeꞌ oxibꞌ aqꞌabꞌ chupam ri nimalaj kar, je xuqujeꞌ ri in ri uKꞌojol ri Achi kinkꞌojiꞌ na oxibꞌ qꞌij xuqujeꞌ oxibꞌ aqꞌabꞌ xeꞌ ri ulew. ");
INSERT INTO quctt_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Pa ri kꞌisbꞌal qꞌatoj tzij, ri winaq ri xekꞌojiꞌ pa ri tinimit Nínive kewaꞌjil na, kakibꞌij na tzij chiꞌwe rech kaqꞌat na tzij pa iwiꞌ, rumal ri Dios. Ri winaq riꞌ xkikꞌex ri kikꞌaslemal are xkita ri tzij ri xutzijoj ri Jonás chike. Ri ix kꞌut pune kita ri nutzij, man kikꞌex ta kꞌu iwibꞌ, pune in nim nuqꞌij cho ri Jonás. ");
INSERT INTO quctt_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Xuqujeꞌ ri nimalaj taqanel ixoq ri xkꞌojiꞌ chuxukut ulew kawaꞌjil na pa ri qꞌij rech qꞌatoj tzij, kubꞌij na tzij chiꞌwe. Areꞌ sibꞌalaj naj xpe wi chutatabꞌexik ri etaꞌmabꞌal ri xukꞌut ri Salomón. Ri ix kꞌut man kitatabꞌej ta ri nukꞌutuꞌn pune in nim nuqꞌij cho ri Salomón. ");
INSERT INTO quctt_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Are kel bꞌik jun itzel uxlabꞌal che jun winaq, keꞌ pa taq ri kꞌolibꞌal jawjeꞌ e maj wi ja, kutzukuj jun kꞌolibꞌal jawjeꞌ kuxlan wi. ");
INSERT INTO quctt_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Are man kuriq ta jun kꞌolibꞌal jawjeꞌ kuxlan wi, kubꞌij: Kintzalij na pa ri najtir wachoch, kine kꞌol chi na junmul chilaꞌ. Are kopanik, ri kꞌolibꞌal maj kꞌo chupam, chꞌajchꞌoj xuqujeꞌ sukꞌumatalik. ");
INSERT INTO quctt_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Keꞌ chi junmul kubꞌuꞌtzukuj chi e wuqubꞌ uxlabꞌal chik, konojel ri e wuqubꞌ koꞌk che we winaq riꞌ rumal riꞌ sibꞌalaj nim ri kꞌax kuriq ri winaq riꞌ cho ri xuriq kan nabꞌe are xa jun ri itzel uxlabꞌal kꞌo che. Jeriꞌ kakꞌulmataj na iwukꞌ ix rumal cher sibꞌalaj ix itzel taq winaq. ");
INSERT INTO quctt_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Tajin katzijon na ri Jesús kukꞌ ri winaq, are xopan ri unan xuqujeꞌ ri e rachalal chilaꞌ jawjeꞌ ri kꞌo wiꞌ, are kakaj ketzijon rukꞌ, xkayeꞌj apanoq cho ri ja, ");
INSERT INTO quctt_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","kꞌo kꞌu jun xubꞌij che ri Jesús: Ri anan xuqujeꞌ ri aꞌwachalal e kꞌo cho ja, kakaj ketzijon awukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ri Jesús xuta chike: ¿Jachin riꞌ ri qas nunan xuqujeꞌ ri qas e wachalal? ");
INSERT INTO quctt_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ri Jesús xuꞌkꞌut konojel ri utijoxelabꞌ kꞌa te riꞌ xubꞌij chike: Aꞌreꞌ waꞌ ri e nunan xuqujeꞌ e wachalal. ");
INSERT INTO quctt_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Xapachin ri kunimaj ri utaqanik ri nuTat ri kꞌo pa ri kaj, are riꞌ nunan xuqujeꞌ wanabꞌ xuqujeꞌ wachalal. ");
INSERT INTO quctt_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Che ri qꞌij riꞌ, xel bꞌik ri Jesús pa ri ja ri kꞌo wi, xeꞌ chuchiꞌ ri plo, xtꞌuyiꞌk chilaꞌ chuyaꞌik kꞌutuꞌn. ");
INSERT INTO quctt_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Rumal kꞌu cher sibꞌalaj e kꞌi ri winaq, rumal riꞌ xaqꞌan pa ri jun jukubꞌ bꞌinibꞌal puꞌwiꞌ ri jaꞌ, xtꞌuyiꞌ chilaꞌ chuyaꞌik ri kꞌutuꞌn. Konojel ri winaq xekꞌojiꞌ chuchiꞌ ri jaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ri Jesús xukꞌut sibꞌalaj kꞌi jastaq rukꞌ taq kꞌambꞌejabꞌal noꞌj jetaq we riꞌ: Kꞌo jun ajchak, xeꞌ pa tikoꞌnijik. ");
INSERT INTO quctt_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Are tajin katikoꞌnijik, nikꞌaj ijaꞌ xqaj pa ri bꞌe, xepe nikꞌaj chochiꞌ, xkitij bꞌik. ");
INSERT INTO quctt_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Nikꞌaj ijaꞌ chik xqaj pa jun ulew jawjeꞌ kꞌo wi abꞌaj. Aninaq xkꞌiy loq ri tiriko, rumal cher man nim taj qajinaq ri ulew. ");
INSERT INTO quctt_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ri tikoꞌn naj taj xuqꞌiꞌo rumal cher maj ukꞌaꞌmalil, are xel loq ri qꞌij, xchaqiꞌjarik. ");
INSERT INTO quctt_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ri nikꞌaj taq ijaꞌ chik xqaj chikixoꞌl ri kꞌix. Are xekꞌiy loq ri kꞌix, xkijiqꞌisaj kan ri tikoꞌn man xkiya ta bꞌe che xkꞌiyik. ");
INSERT INTO quctt_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","E kꞌo chi nikꞌaj ijaꞌ ri xeqaj pa ri utz laj ulew, we ijaꞌ riꞌ xewachinik, kꞌo xkiya jun ciento, kꞌo xkiya oxkꞌal, kꞌo xkiya juwinaq lajuj kiwach. ");
INSERT INTO quctt_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","We qas kꞌo ixikin, chitatabꞌej ri kabꞌix chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ri tijoxelabꞌ xeqet rukꞌ ri Jesús, xkita che: ¿Jas che kakoj la kꞌambꞌejabꞌal noꞌj are kaya la kꞌutuꞌn? ");
INSERT INTO quctt_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ri Jesús xubꞌij: Ri ix yaꞌtalik kiwetaꞌmaj ri awatalik pa ri ajawarem rech ri Dios, man je ta kꞌu ri nikꞌaj winaq chik. ");
INSERT INTO quctt_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ri winaq ri ketaꞌm jas ubꞌanik ri jastaq pa ri ajawarem rech ri Dios, yaꞌtal chike kanimar ri ketaꞌmabꞌal. Are kꞌu ri man ketaꞌm taj jas ubꞌanik ri jastaq pa ri ajawarem rech ri Dios, ri Dios kubꞌan na chi kasachan chike ri nitzꞌ jastaq ri ketaꞌm. ");
INSERT INTO quctt_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ri in kinya kꞌutuꞌn chike ri winaq rukꞌ kꞌambꞌejabꞌal noꞌj, rech pune kekaꞌyik, man kakil taj, pune kakito, man kakichꞌobꞌ ta ri kabꞌix chike. ");
INSERT INTO quctt_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Jeriꞌ kakꞌulmataj kukꞌ ri xubꞌij loq ri Dios chuchiꞌ ri qꞌalajisal tzij Isaías: We winaq riꞌ, pune kakito, man kakichꞌobꞌ taj, Pune kekaꞌyik, man kakil ta wi. ");
INSERT INTO quctt_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Rumal cher we tinimit riꞌ xkowir ri kanimaꞌ, xuqujeꞌ man kechoman taj kitzꞌapim ri kibꞌoqꞌoch rech man kakil taj, xuqujeꞌ kitzꞌapim ri kixikin rech man kakita taj, we ta kakikꞌex kikꞌuꞌx kakichꞌobꞌ riꞌ ri nutzij, xuqujeꞌ kakikꞌex riꞌ ri kikꞌaslemal, ri in xuqujeꞌ keꞌnkunaj na. ");
INSERT INTO quctt_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Are kꞌu ri ix, sibꞌalaj utz iwe, rumal cher kiwilo xuqujeꞌ kita ri nutzij. ");
INSERT INTO quctt_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Sibꞌalaj e kꞌi winaq xuqujeꞌ e qꞌalajisal taq utzij ri Dios xkaj xkil ri tajin kiwil ix xuqujeꞌ xkita ri kita ix, man xekwin ta kꞌut. ");
INSERT INTO quctt_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Chanim chitatabꞌej, kinbꞌij chiꞌwe ri kel kubꞌij ri kꞌambꞌejabꞌal noꞌj rech ri ajtikolobꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","E kꞌo jujun winaq ri kakitatabꞌej ri utzij ri Dios, man kakichꞌobꞌ ta kꞌut jas kel kubꞌij, rumal riꞌ kape ri itzel kubꞌano chi kasachan chike. Are waꞌ ri kel kubꞌij ri ijaꞌ ri xtzaq pa ri bꞌe. ");
INSERT INTO quctt_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ri ijaꞌ ri xtzaq chikixoꞌl ri abꞌaj are kel kubꞌij ri kakitatabꞌej ri tzij rech ri ajawarem rech ri Dios, xuqujeꞌ aninaq kakikꞌamawaꞌj rukꞌ kiꞌkotem. ");
INSERT INTO quctt_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Rumal chi maj kikꞌaꞌmal, naj taj kakiqꞌiꞌo. Are kakiriq kꞌax, o kabꞌan ne kꞌax chike rumal keniman che ri Dios, kasachan ri tzij chike. ");
INSERT INTO quctt_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kꞌa te riꞌ e kꞌo ri ijaꞌ ri xetzaq chikixoꞌl ri kꞌix. We ijaꞌ riꞌ kel kubꞌij ri e winaq ri kakitatabꞌej ri tzij, man kakiya ta kꞌu bꞌe kakꞌexkꞌobꞌ ri kikꞌaslemal xaq xwi kakichomaj rij ri kajawataj chike, xuqujeꞌ jas kakibꞌano rech kuꞌx qꞌinomabꞌ, rumal riꞌ man kekwin taj kewachinik. ");
INSERT INTO quctt_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kꞌisbꞌal rech, ri ijaꞌ ri xetzaq pa ri utz ulew, are waꞌ ri winaq ri kakitatabꞌej ri tzij xuqujeꞌ kakichꞌobꞌo. Are waꞌ ri winaq ri kakikꞌex kikꞌaslemal xuqujeꞌ kakibꞌan ri utzilal. Jer e kꞌo ri ijaꞌ ri xewachinik xkiya jun ciento, xkiya oxkꞌal, xuqujeꞌ xkiya juwinaq lajuj ijaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ri Jesús xutzijoj chi we jun kꞌambꞌejabꞌal noꞌj riꞌ: Pa ri ajawarem rech ri Dios je kakꞌulmataj na jetaq ri xkꞌulmataj rukꞌ jun winaq ri xutik jeꞌl laj ijaꞌ rech tiriko pa ri rulew. ");
INSERT INTO quctt_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Che ri chaqꞌabꞌ riꞌ konojel ri winaq tajin kewarik, are xopan ri kꞌulel, xuꞌtikaꞌ kanoq ri jun itzel qꞌayes chuxoꞌl ri tiriko, kꞌa te riꞌ xel bꞌik chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ri tiriko are xkꞌiy loq, xkꞌiy xuqujeꞌ loq ri itzel qꞌayes. ");
INSERT INTO quctt_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ri aꞌjchakibꞌ xebꞌe rukꞌ ri ajchoqꞌe ri ulew, xkibꞌij che: Ajawxel, ¿la man utz taq ijaꞌ rech tiriko xtik lal? ¿Jas kꞌu che xkꞌiy loq itzel qꞌayes chuxoꞌl? ");
INSERT INTO quctt_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ri ajchoqꞌe ri ulew xubꞌij chike: Are waꞌ ri xubꞌan ri kꞌulel. Ri ajchakibꞌ xkibꞌij: ¿La kaj la keꞌqabꞌoqo kanoq ri itzel qꞌayes? ");
INSERT INTO quctt_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ri ajchoqꞌe xubꞌij chike: Man kawaj taj, ri tiriko xuqujeꞌ ri itzel qꞌayes xaq raj junam kekaꞌyik, rukꞌ ta ne jubꞌiqꞌ are kibꞌoq kan ri tiriko. ");
INSERT INTO quctt_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Are katan riꞌ, chiya bꞌe kekꞌiy loq kikobꞌchal. Are kuriq ri qꞌotaj rech yakoj, kꞌa che riꞌ keqilo jachin chike ri itzel qꞌayes xuqujeꞌ jachin chike ri tiriko. Keꞌntaq na bꞌik ajchakibꞌ riꞌ rech nabꞌe kakibꞌoq ri itzel qꞌayes, kakimulij, kꞌa te riꞌ kakiporoj. Xuqujeꞌ kakikꞌam bꞌik ri tiriko, keꞌkiya kanoq pa ri nukꞌolibꞌal. ");
INSERT INTO quctt_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ri Jesús xutzijoj chi jun kꞌambꞌejabꞌal noꞌj, xubꞌij: Ri ajawarem rech ri Dios kajunumataj rukꞌ ri jun achi ri xutik jun ijaꞌ rech moxtansia pa ri rulew. ");
INSERT INTO quctt_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Pune ri ijaꞌ rech moxtansia sibꞌalaj nitzꞌ chikiwach ronojel uwach ijaꞌ, are kakꞌiy loq, sibꞌalaj nim chikiwach konojel ri e qꞌayes ri e tiktalik. Kux na jetaq jun cheꞌ jawjeꞌ kakibꞌan wi ri kisok ri chochiꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ri Jesús xukoj chi jun kꞌambꞌejabꞌal noꞌj, xubꞌij: Ri ajawarem rech ri Dios kajunumataj rukꞌ ri kꞌaj. Ri ixoq are kuya nitzꞌ chꞌam rukꞌ ri kꞌaj, kasipoj ri kꞌaj rumal ri nitzꞌ chꞌam ri kaya rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ri Jesús xuya kꞌutuꞌn chike ri winaq rukꞌ kꞌambꞌejabꞌal taq noꞌj, xuqujeꞌ xujunamaj taq ri jastaq rukꞌ nikꞌaj chik. ");
INSERT INTO quctt_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Jeriꞌ xkꞌulmataj ri xubꞌij loq ri Dios chuchiꞌ ri qꞌalajisal rech ri utzij are xubꞌij: Keꞌnchꞌabꞌej na we winaq riꞌ rukꞌ kꞌambꞌejabꞌal noꞌj, xuqujeꞌ kinbꞌij na jas kel ri jastaq ri xaq xwi ri Dios etaꞌmaninaq are xutik loq ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ri Jesús xtzalij cho ri ja, xuꞌya kan ri winaq chilaꞌ, ri tijoxelabꞌ xeꞌkibꞌij che: Bꞌij la chaqe jas kel kubꞌij ri kꞌambꞌejabꞌal noꞌj chirij ri itzel qꞌayes ri xtik pa ri ulew. ");
INSERT INTO quctt_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ri Jesús xubꞌij: Ri uKꞌojol ri Achi are riꞌ ri katikow ri utz ijaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ri ulew are ri uwachulew, ri utz laj ijaꞌ rech tiriko, aꞌreꞌ ri winaq ri kakinimaj ri taqanik rech ri ajawarem rech ri Dios. Ri ijaꞌ rech ri itzel qꞌayes aꞌreꞌ ri winaq ri kakinimaj ri Itzel. ");
INSERT INTO quctt_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ri Itzel are xtikow loq ri etzelal cho ri uwachulew. Ri qꞌotaj rech yakoj are ri kꞌisbꞌal qꞌatoj tzij, ri ajchakibꞌ ri keyakow ri tikoꞌn aꞌreꞌ ri rangelibꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Are kabꞌoq ri itzel qꞌayes xuqujeꞌ kaporoxik are kel kubꞌij ri qꞌatoj tzij ri kubꞌan na ri Dios pa kiwiꞌ konojel ri winaq. ");
INSERT INTO quctt_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","In ri in uKꞌojol ri Achi, keꞌntaq na bꞌik ri e wangelibꞌ rech keꞌkesaj na bꞌik pa ri ajawarem we konojel ri kakibꞌan etzelal xuqujeꞌ ri keꞌkitaqchiꞌj nikꞌaj winaq chik chubꞌanik mak. ");
INSERT INTO quctt_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","We winaq riꞌ kekꞌyaq na bꞌik kumal ri angelibꞌ pa ri tyoꞌnel qꞌaqꞌ, chilaꞌ kakixiꞌj kꞌu na kibꞌ, koꞌq na, xuqujeꞌ kakiqutꞌutꞌej na kiware. ");
INSERT INTO quctt_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Are kꞌu ri winaq ri keniman che ri Dios, kechuplin na pa ri ajawarem rech ri Tataxel jacha ri kubꞌan ri qꞌij are kachuplinik. We qas kꞌo ixikin chutatabꞌexik, qas chitatabꞌej. ");
INSERT INTO quctt_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ri ajawarem rech ri Dios kajunumataj rukꞌ ri qꞌinomal ri muqtal kan pa jun ulew, are kariqitaj rumal jun winaq, ri winaq karawaj chi kan junmul. Kꞌa te riꞌ kakiꞌkotik keꞌ chukꞌayixik ronojel ri rulew rech kakwinik kuloqꞌ kan ri ulew rech kakanaj kan rukꞌ ri qꞌinomal ri kꞌo pa we ulew riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ri ajawarem rech ri Dios kajunumataj rukꞌ ri jun ajkꞌay ri kuloqꞌ ri abꞌaj ri paqal rajil. ");
INSERT INTO quctt_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Are kuriq jun abꞌaj ri paqal rajil, kukꞌayij kan ronojel ri kꞌo rukꞌ rech kuloqꞌ ri paqal rajil. ");
INSERT INTO quctt_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ri ajawarem rech ri Dios kajunumataj rukꞌ ri jun kꞌat chapbꞌal kar. Ri e chapal taq kar kakikꞌyaq bꞌik ri kꞌat pa ri cho, keꞌkimol ronojel uwach kar. ");
INSERT INTO quctt_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Are kanoj ri kꞌat, kakesaj la chuchiꞌ ri jaꞌ, ketꞌuyiꞌ chuqꞌatik ri utz taq kar xuqujeꞌ ri itzel taq kar. Ri utz taq kar keꞌkiyak pa jun chakach, ri itzel taq kar keꞌkikꞌyaq bꞌik. ");
INSERT INTO quctt_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Jeriꞌ kakꞌulmatajik are kopan ri kꞌisbꞌal qꞌij rech ri uwachulew: Ri angelibꞌ keꞌkiqꞌat na ri utz taq winaq chike ri itzel taq winaq. ");
INSERT INTO quctt_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ri itzel taq winaq kekꞌyaq na bꞌik pa ri tyoꞌnel qꞌaqꞌ, chilaꞌ kakixiꞌj wi na kibꞌ, rumal riꞌ koqꞌ na xuqujeꞌ kakiqutꞌutꞌej na ri kiware. ");
INSERT INTO quctt_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ri Jesús xuta chike ri utijoxelabꞌ: ¿La kichꞌobꞌ ix ronojel we kꞌutuꞌn riꞌ? Ri tijoxelabꞌ xkibꞌij: Jeꞌ, kaqachꞌobꞌo. ");
INSERT INTO quctt_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ri Jesús xubꞌij chike: Ri ajtij rech ri taqanik ri kux utijoxel ri rawajarem ri Dios, je kꞌo ri winaq ajchoqꞌe jun ja ri keꞌ jawjeꞌ ri kuyak wi ri ujastaq, chilaꞌ karesaj wi loq kꞌakꞌ xuqujeꞌ qꞌeꞌl taq jastaq. ");
INSERT INTO quctt_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Are xtoꞌtaj ri Jesús chuyaꞌik ri kꞌutuꞌn rukꞌ ri kꞌambꞌejabꞌal taq noꞌj, xel bꞌik chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Xopan pa ri utinimit, xuchapleꞌj uyaꞌik kꞌutuꞌn pa ri Sinagoga. Ri winaq xemayijanik, e kꞌo kꞌu jujun chike xkibꞌij: ¿Jawjeꞌ xretaꞌmaj wi we achi riꞌ ronojel we jastaq riꞌ? E nikꞌaj winaq chik xkibꞌij: ");
INSERT INTO quctt_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Are waꞌ ri Jesús, ukꞌojol ri José ri qolol cheꞌ, are unan ri María, are e rachalal ri Jacobo, ri José, ri Simón xuqujeꞌ ri Judas. ");
INSERT INTO quctt_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ri e ranabꞌ e kꞌo na waral ¿jas che laꞌ retaꞌm sibꞌalaj kꞌi jastaq, xuqujeꞌ kakwinik kubꞌan mayijabꞌal taq jastaq? ");
INSERT INTO quctt_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Maj kꞌu jun chike ri winaq ri keꞌl chilaꞌ xraj xukꞌamawaꞌj ri ukꞌutuꞌn ri Jesús. Rumal riꞌ, ri Jesús xubꞌij: Jun qꞌalajisal utzij ri Dios kanimax pa ronojel taq ri tinimit, xwi pa ri utinimit xuqujeꞌ pa ri rachoch man kanimax ta wi. ");
INSERT INTO quctt_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","E kꞌi winaq man xekojon ta che, rumal riꞌ man kꞌi taj mayijabꞌal taq jastaq xubꞌan pa ri leꞌaj riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Pa taq ri qꞌij riꞌ, ri Herodes are taqanel pa Galilea. Are xretaꞌmaj ri kakitzijoj ri winaq che ri Jesús ");
INSERT INTO quctt_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","xubꞌij chike ri e patanil rech: Qas tzij kinbꞌij chiꞌwe, ri Jesús are Juan Bꞌanal qasanaꞌ, xa xkꞌastaj loq. Rumal riꞌ kakwinik kubꞌan mayijabꞌal taq jastaq. ");
INSERT INTO quctt_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ri Herodes are xkojow ri Juan pa cheꞌ rumal cher xyojtajik rumal cher xbꞌix che: Man utz taj ri xabꞌano, xaweleqꞌaj ri Herodías rixoqil ri awachalal, Felipe, xatkꞌuliꞌ rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ri Juan kꞌi mul xubꞌij che: Man kuya ta bꞌe ri taqanik chawe kakꞌam ri Herodías che awixoqil. ");
INSERT INTO quctt_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ri Herodes are xraj kukamisaj ri Juan, man xkwin ta kꞌut rumal cher kuxiꞌj ribꞌ chikiwach ri winaq, rumal cher ri winaq ketaꞌm chi ri Juan jun qꞌalajisal utzij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Are xtzaꞌqat chik jun ujunabꞌ ri Herodes, xubꞌan jun nimaqꞌij, ri ral ali ri Herodías xojow chikiwach konojel ri winaq ri e sikꞌitalik. ");
INSERT INTO quctt_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Sibꞌalaj xqaj choch ri Herodes ri xojowem ri xubꞌan ri ali, rumal riꞌ xubꞌij che ri ali chi kuya che xapakux ri karaj. ");
INSERT INTO quctt_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ri Herodías ri unan ri ali are xutabꞌej re we riꞌ, xukoj ukꞌuꞌx ri ral rech kuta che ri Herodes chi kaya loq pa jun palaꞌt ri ujolom ri Juan Bꞌanal qasanaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Sibꞌalaj xbꞌison ri Herodes are xuta ri xbꞌix che, xa kꞌu rumal cher xutzuj che ri ali, xapakux ri kata che. Man xraj ta ukꞌuꞌx mat xtakꞌiꞌ pa ri utzij chikiwach ri e winaq ri e sikꞌital pa ri nimaqꞌij. Xaq jeriꞌ maj chi xkwinik xubꞌano, xuꞌtaq ri e patanil rech chuyaꞌik ri xutoqꞌij ri ali. ");
INSERT INTO quctt_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ri e patanil rech ri Herodes xebꞌe pa ri cheꞌ, xeꞌkikutij loq ri ujolom ri Juan. ");
INSERT INTO quctt_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Xkiya pa jun palaꞌt, xeꞌkiya che ri ali. Ri ali xuꞌya che ri unan. ");
INSERT INTO quctt_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ri utijoxelabꞌ ri Juan xeꞌkikꞌama loq ri utyoꞌjal ri kajtij Juan, xeꞌkimuqu kanoq. Kꞌa te riꞌ, xeꞌkitzijoj che ri Jesús ri xkꞌulmatajik. ");
INSERT INTO quctt_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Are xuta ri Jesús ri xbꞌan che ri Juan Bꞌanal qasanaꞌ, xaqꞌan bꞌik pa jun jukubꞌ bꞌinibꞌal puꞌwiꞌ ri jaꞌ, xeꞌ pa jun kꞌolibꞌal jawjeꞌ ri utz kakꞌojiꞌ wi utukel. Ri winaq ri keꞌl pa taq ri tinimit are xketaꞌmaj jawjeꞌ keꞌ wi ri Jesús, xkitereneꞌj bꞌik chikaqan. ");
INSERT INTO quctt_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Are xqaj ri Jesús pa ri jukubꞌ bꞌinibꞌal, xeꞌril sibꞌalaj e kꞌi winaq. Xel ukꞌuꞌx chike xuꞌkunaj konojel ri e yawabꞌibꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Are xuchapleꞌj uqajem ri qꞌij, ri e tijoxelabꞌ xeqet rukꞌ ri Jesús xkibꞌij che: Waꞌ we kꞌolibꞌal riꞌ naj kꞌo wi che ri tinimit, xuqujeꞌ tajin kaqaj le qꞌij. Bꞌij la chike ri winaq chebꞌoꞌj pa taq ri tinimit, jeꞌkiloqꞌo kiwa. ");
INSERT INTO quctt_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ri Jesús xubꞌij chike: Man rajawaxik ta laꞌ kebꞌek. Chiꞌtzuqu ix. ");
INSERT INTO quctt_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ri tijoxelabꞌ xkibꞌij che: Xaq xwi kꞌo jobꞌ kaxlan wa qukꞌ xuqujeꞌ kebꞌ kar. ");
INSERT INTO quctt_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ri Jesús xubꞌij chike: Chikꞌama loq waral. ");
INSERT INTO quctt_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Are xeꞌtaqtaj ri winaq rech ketꞌuyiꞌ cho ri saq, ri Jesús xukꞌam ri jobꞌ kaxlan wa rachiꞌl ri kebꞌ kar, xkaꞌy chikaj, xtyoxin che ri Dios, kꞌa te riꞌ xupirij ri kaxlan wa xuya chike ri utijoxelabꞌ, rech kakijach chike ri winaq. ");
INSERT INTO quctt_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Konojel ri winaq xewaꞌik, sibꞌalaj xenojik, ri tijoxelabꞌ xkimulij ronojel ri chꞌaqaꞌp ri xkanajik, chi ronojel xkiriq na kabꞌlajuj chakach. ");
INSERT INTO quctt_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Karaj e jobꞌ mil achyabꞌ ri xewaꞌik, man xaꞌjilax ta ri ixoqibꞌ rachiꞌl ri akꞌalabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kꞌa te riꞌ ri Jesús xubꞌij chike ri utijoxelabꞌ: Chixaqꞌan pa le jukubꞌ bꞌinibꞌal puꞌwiꞌ le jaꞌ, jix chꞌaqaꞌp che le cho. In kinkanaj na kanoq waral Keꞌnchꞌabꞌej na kan le winaq, kꞌa te kixeꞌn riqaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Are xebꞌe konojel ri winaq, ri Jesús xpaqiꞌ utukel puꞌwiꞌ jun laj juyubꞌ, xubꞌan chꞌawem. Tajin kubꞌan chꞌawem are xok ri aqꞌabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Are kꞌu ri jukubꞌ bꞌinibꞌal puꞌwiꞌ ri jaꞌ naj chi kꞌo wi apanoq, kapuyiloꞌx rukꞌ chuqꞌabꞌ rumal ri kyaqiqꞌ xuqujeꞌ rumal ri jaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kꞌa chaqꞌabꞌ na are xuchapleꞌj bꞌinem ri Jesús puꞌwiꞌ ri jaꞌ xqebꞌ chuxukut ri jukubꞌ bꞌinibꞌal puꞌwiꞌ ri jaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Are xkil ri tijoxelabꞌ chi tajin kabꞌin puꞌwiꞌ ri jaꞌ, man xkichꞌobꞌ taj chi are Jesús, sibꞌalaj xkixiꞌj kibꞌ, xkiraq kichiꞌ xkibꞌij: ¡Jun subꞌunel! ");
INSERT INTO quctt_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ri Jesús aninaq xubꞌij chike: In waꞌ, kꞌol ichuqꞌabꞌ. Man kixiꞌj ta iwibꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ri Pedro xubꞌij che: Ajawxel, we qas lal, bꞌana la chwe chi kinbꞌin xuqujeꞌ in puꞌwiꞌ le ja, rech kineꞌ apanoq jawjeꞌ le kꞌo wi la. ");
INSERT INTO quctt_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ri Jesús xubꞌij che: Chatan loq. Aninaq xqaj ri Pedro pa ri jukubꞌ bꞌinibꞌal puꞌwiꞌ ri jaꞌ, xbꞌin puꞌwiꞌ ri jaꞌ xeꞌ rukꞌ ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Are xunaꞌ ri uchuqꞌabꞌ ri kyaqiqꞌ, xuxiꞌj ribꞌ. Xuchapleꞌj qajem xeꞌ ri jaꞌ, xubꞌij: ¡Wajaw, chintoꞌ la! ");
INSERT INTO quctt_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ri Jesús xuchap apanoq ri Pedro, xubꞌij che: Pedro man qas ta kuꞌl akꞌuꞌx chwij, ¿jas che xubꞌan kebꞌ akꞌuꞌx? ");
INSERT INTO quctt_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Are xepaqiꞌ kikobꞌchal pa ri jukubꞌ bꞌinibꞌal puꞌwiꞌ ri jaꞌ, xtaniꞌ ri kyaqiqꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Konojel ri e kꞌo pa ri jukubꞌ bꞌinibꞌal, xexukiꞌ choch ri Jesús xkibꞌij che: Qas tzij wi, lal, lal Ralkꞌwaꞌl ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Are xeqꞌax chꞌaqaꞌp che ri cho, xoꞌpan pa ri tinimit Genesaret. ");
INSERT INTO quctt_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ri winaq ri keꞌl pa ri tinimit are xkil uwach ri Jesús, xkitzijoj chike konojel ri winaq. Ri winaq xeꞌkikꞌam bꞌik ri e kiyawabꞌibꞌ jawjeꞌ ri kꞌo wi ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Xkita toqꞌobꞌ che ri Jesús, rech kakichap ri uchiꞌ ri umanta. Ri e yawabꞌibꞌ ri xkichap ri uchiꞌ ri umanta ri Jesús, xuꞌtzirik. ");
INSERT INTO quctt_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","E kꞌo kꞌu jujun chike ri fariseos xuqujeꞌ jujun aꞌjtijabꞌ rech ri Taqanik, ri e petinaq pa Jerusalén, xkita che ri Jesús: ");
INSERT INTO quctt_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","¿Jas che ri atijoxelabꞌ man kakinimaj taj ri naqꞌatajibꞌal ri kibꞌanom kan ri e qamam ojer? ¿Jas che man kakichꞌaj taj ri kiqꞌabꞌ are kewaꞌik? ");
INSERT INTO quctt_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ri Jesús xubꞌij chike: ¿Jas che man kinimaj ta ix ri utaqanik ri Dios rumal unimaxik ri inaqꞌatajibꞌal? ");
INSERT INTO quctt_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ri Dios xubꞌij: Nim chaꞌwila ri atat rachiꞌl ri anan, xuqujeꞌ ri karetzelaj uwach ri utat rachiꞌl ri unan, taqal che kakamisaxik. Ri Dios xuqujeꞌ xubꞌij: xapachin ri man nim ta keril ri utat unan yaꞌtal che kakamisaxik. ");
INSERT INTO quctt_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ri ix kꞌut kibꞌij chi jun alkꞌwaꞌlaxel utz we kubꞌij che ri utat xuqujeꞌ ri unan: Man kinkwin taj kintobꞌan ukꞌ alaq, rumal cher xintzuj uyaꞌik che ri Dios ronojel ri nujastaq rachiꞌl ri nurajil. ");
INSERT INTO quctt_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","We jeriꞌ kubꞌan ri alkꞌwaꞌlaxel, man tajin ta kunimaj riꞌ ri utat. Ri ix man tajin ta kichꞌobꞌ ri utaqanik ri Dios, rumal are tajin kinimaj ri inaqꞌatajibꞌal. ");
INSERT INTO quctt_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kawach taq winaq, kꞌo rumal xutzijoj loq iwij ri Isaías are xubꞌij: ");
INSERT INTO quctt_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","We winaq ri keꞌl pa we tinimit riꞌ, kakibꞌij chi kinkinimaj, qas tzij kꞌut kinbꞌij xa ta ne junmul kakichomaj wij. ");
INSERT INTO quctt_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Maj kutayij kiniqꞌijilaꞌj, rumal cher ri ikꞌutuꞌn xaq ke achyabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ri Jesús xuꞌsikꞌij ri winaq xubꞌij chike: Qas chita na, xuqujeꞌ utz chibꞌana che uchꞌobꞌik ri kinbꞌij chiꞌwe: ");
INSERT INTO quctt_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Man are ta ri rikil ri kitijo kabꞌanow chꞌuluj chiꞌwe cho ri Dios, xane are kabꞌanow chꞌuluj chiꞌwe ri tzukun taq chꞌoꞌj rukꞌ taq tzij, xuqujeꞌ ri itzel taq tzij ri kibꞌij. ");
INSERT INTO quctt_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ri tijoxelabꞌ xeqet rukꞌ ri Jesús, xkibꞌij che: Man utz taj xkita le fariseos ri xbꞌij la. ");
INSERT INTO quctt_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ri Jesús xubꞌij: Ronojel qꞌayes ri man are ta ri nuTat tikowinaq kabꞌoq na bꞌik ri kꞌa te riꞌ kakꞌyaq na bꞌik. ");
INSERT INTO quctt_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Chiꞌya chilaꞌ rumal cher jer e kꞌo ri moy ri kakikꞌam kibꞌe nikꞌaj moyabꞌ chik, we jun moy kukꞌam ubꞌe jun moy chik, kikobꞌchal riꞌ ketzaq bꞌik pa jun jul. ");
INSERT INTO quctt_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ri Pedro xuta che ri Jesús: Bꞌij la chaqe jas ubꞌanik ri kꞌambꞌejabꞌal noꞌj ri xtzijoj la are xbꞌij la ri jastaq ri kubꞌan chꞌuluj chaqe cho ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ri Jesús xubꞌij che: ¿Man kichꞌobꞌ ta xuqujeꞌ ix? ");
INSERT INTO quctt_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ronojel ri kaqatijo xuqujeꞌ ri kaqaqumuj keꞌ chiqapam, kꞌa te riꞌ keꞌqachuluj kanoq. ");
INSERT INTO quctt_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Are kꞌu ri kape pa qanimaꞌ kel loq pa qachiꞌ are riꞌ kuchꞌulujij ri winaq. ");
INSERT INTO quctt_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Pa ri animaꞌaj kape wi ri itzel taq chomanik, ri kamisanik, ri tzukun kakabꞌ ixoqibꞌ, xuqujeꞌ kakabꞌ achyabꞌ, ri mak kukꞌ taq ixoqibꞌ xuqujeꞌ mak kukꞌ taq achyabꞌ, bꞌanoj taq tzij chikij nikꞌaj winaq chik, ri elaqꞌ, ri itzel taq noꞌjibꞌal chikiwach ri winaq. ");
INSERT INTO quctt_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Man are ta kabꞌanow chꞌuluj che jun winaq we man kuchꞌaj uqꞌabꞌ, are kabꞌanow chꞌuluj che ri winaq ri itzel taq jastaq. ");
INSERT INTO quctt_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Are xel bꞌik ri Jesús chilaꞌ, xeꞌ pa ri tinimit Tiro xuqujeꞌ Sidón. ");
INSERT INTO quctt_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kꞌo jun ixoq chilaꞌ kachiꞌl ri kabꞌix kananeos chike kumal ri winaq aꞌj Israel, xuraq uchiꞌ xqebꞌ rukꞌ ri Jesús, xubꞌij che: Ajawxel, lal riꞌ ri Ralkꞌwaꞌl ri David, toqꞌobꞌisaj la nuwach, chintoꞌ la. Kꞌo jun itzel uxlabꞌal che ri wal ali, sibꞌalaj kubꞌan kꞌax che. ");
INSERT INTO quctt_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ri Jesús xa ta ne jun tzij xubꞌij che. Ri e tijoxelabꞌ xeqet rukꞌ ri Jesús xkibꞌij che: Bꞌij la che le ixoq chi man kujutereneꞌj taj xuqujeꞌ chuxlanoq. ");
INSERT INTO quctt_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ri Jesús xubꞌij: Ri Dios xinutaq loq xaq xwi chikitoꞌik ri winaq ri aꞌj Israel, rumal jer e kꞌo chij ri e sachinaq kanoq. ");
INSERT INTO quctt_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ri ixoq xqet rukꞌ ri Jesús, xukiꞌ choch, xubꞌij che: Ajawxel, chintoꞌ la. ");
INSERT INTO quctt_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ri Jesús xubꞌij che: Man utz taj kaqaya ri kiwa ri alkꞌwaꞌlaxelabꞌ chike ri tzꞌiꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ri ixoq xubꞌij che: Qas tzij wi, Ajawxel. Pune jeriꞌ, ri tzꞌiꞌ kakitij ri uxeꞌr taq kiwa ri e kajaw ri katzaq chuxeꞌ ri mexa. ");
INSERT INTO quctt_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ri Jesús xubꞌij che ri ixoq: Ixoq, at qas kuꞌl wi akꞌuꞌx chirij ri Dios. Kabꞌantaj na awukꞌ ri xata chwe. Qas che ri qꞌotaj riꞌ xutzir ri ral ri ixoq. ");
INSERT INTO quctt_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ri Jesús xel bꞌik chilaꞌ, xeꞌ chuchiꞌ ri cho Galilea. Xpaqiꞌ puꞌwiꞌ jun juyubꞌ, kꞌa te riꞌ xtꞌuyiꞌk. ");
INSERT INTO quctt_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Sibꞌalaj e kꞌi winaq xeꞌkikꞌam bꞌik e yawabꞌibꞌ rukꞌ ri Jesús. Chikixoꞌl ri yawabꞌibꞌ e kꞌo chꞌokeꞌr, moyabꞌ, maj kiqꞌabꞌ, e memabꞌ. Ri Jesús xuꞌkunaj konojel. ");
INSERT INTO quctt_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ri winaq sibꞌalaj xemayijanik are xeꞌkil ri yawabꞌibꞌ ri xuꞌtzirik, ri memabꞌ xkichapleꞌj chꞌawem, ri e chꞌokeꞌr xkichapleꞌj bꞌinem, xuqujeꞌ ri e moyabꞌ xkichapleꞌj kaꞌyem. Ri winaq xkichapleꞌj uqꞌijilaꞌxik ri kiDios ri aꞌj Israel. ");
INSERT INTO quctt_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ri Jesús xuꞌsikꞌij ri utijoxelabꞌ, xubꞌij chike: Kintoqꞌobꞌisaj kiwach konojel we winaq riꞌ. Xeꞌ oxibꞌ qꞌij e kꞌo wukꞌ, man kꞌo ta kiwa kitijom. Man kawaj ta kꞌut ketzalij cho kachoch we man kewaꞌ bꞌik, rukꞌ jubꞌiqꞌ kekam che numik pa ri bꞌe. ");
INSERT INTO quctt_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ri tijoxelabꞌ xkibꞌij che: Naj uj kꞌo wi che ri tinimit, ¿jawjeꞌ keꞌ qa man wi loq kiwa konojel we winaq riꞌ? ");
INSERT INTO quctt_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ri Jesús xuta chike: ¿Janipa kaxlan wa kꞌo iwukꞌ? Ri tijoxelabꞌ xkibꞌij: Wuqubꞌ kaxlan wa, rachiꞌl kebꞌ oxibꞌ alaj taq kar. ");
INSERT INTO quctt_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ri Jesús xuꞌtaq ri winaq che tꞌuyulem pa ri ulew. ");
INSERT INTO quctt_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kꞌa te riꞌ xukꞌam ri wuqubꞌ kaxlan wa xuqujeꞌ ri kar, xutyoxij che ri Dios. Kꞌa te riꞌ xupirij ri kaxlan wa xuqujeꞌ ri kar, xuya chike ri utijoxelabꞌ, rech kakijach chike ri winaq. ");
INSERT INTO quctt_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Konojel ri winaq xewaꞌik, xuqujeꞌ xenojik. Are xkimol ri chꞌaqaꞌp ri xkanajik, xkiriq na, wuqubꞌ chakach. ");
INSERT INTO quctt_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","E kajibꞌ mil achyabꞌ ri xewaꞌik, man xaꞌjilax ta ri ixoqibꞌ xuqujeꞌ ri akꞌalabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kꞌa te riꞌ ri Jesús xuꞌchꞌabꞌej kan ri winaq, xpaqiꞌ pa jun jukubꞌ bꞌinibꞌal puꞌwiꞌ ri jaꞌ, xeꞌ pa ri tinimit Magadán. ");
INSERT INTO quctt_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ri fariseos xuqujeꞌ ri saduceos xeqet rukꞌ ri Jesús, are xkaj xubꞌij jun jastaq ri man je ta ubꞌanik, xkita che chi kubꞌan jun kꞌutbꞌal rech chikaj. ");
INSERT INTO quctt_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ri Jesús xubꞌij chike: Are kok aqꞌabꞌ ri ix kibꞌij chi jeꞌl ri qꞌotaj ri kape na, rumal cher kyaqarinaq le kaj. ");
INSERT INTO quctt_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Xuqujeꞌ aqꞌabꞌil are kiwilo chi kyaq xuqujeꞌ qꞌeqmuj le uwach le kaj kibꞌij chi kubꞌan na jabꞌ, rumal cher kaxibꞌin le ubꞌanik le uwo kaj. Ix iwetaꞌm kichꞌobꞌ rij ri kukꞌut ri kaj, man iwetaꞌm ta kꞌut ri kakꞌulmataj pa taq ri qꞌotaj ri kape na. ");
INSERT INTO quctt_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ri itzel xuqujeꞌ kawach taq winaq are kakaj jun mayijabꞌal kꞌutbꞌal, man kayaꞌtaj ta chi kꞌu jun kꞌutbꞌal chike, xaq xwi jun jacha ri rech ri Jonás. Are xbꞌiꞌtaj we tzij riꞌ rumal ri Jesús, xel bꞌik chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Are xebꞌe puꞌwiꞌ ri plo rech keqꞌax chꞌaqaꞌp, man xnaꞌtaj ta bꞌik ukꞌamik ri kaxlan wa chike ri tijoxelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ri Jesús xubꞌij chike: Chichajij iwibꞌ che ri levadura ke ri fariseos xuqujeꞌ ke ri Saduceos. ");
INSERT INTO quctt_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ri tijoxelabꞌ xkibꞌij chibꞌil taq kibꞌ: Jeriꞌ laꞌ kubꞌij le Jesús rumal man xnaꞌtaj ta loq ukꞌamik ri kaxlan wa chaqe. ");
INSERT INTO quctt_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Are xretaꞌmaj ri Jesús ri kakibꞌij, xubꞌij chike: ¿Jas che kibꞌij chi maj kaxlan wa iwukꞌ? ");
INSERT INTO quctt_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Man kichꞌobꞌ ta kꞌut? ¿Man kanaꞌtaj ta kꞌu chiꞌwe ri jobꞌ kaxlan wa ri xqaya chike ri jobꞌ mil winaq, janipa chakach chꞌaqaꞌp ximulij? ");
INSERT INTO quctt_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Xuqujeꞌ ¿la man kanaꞌtaj ri wuqubꞌ kaxlan wa ri xuꞌtzuq kajibꞌ mil winaq, janipa chakach chꞌaqaꞌp ximulij? ");
INSERT INTO quctt_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Jas che man kichꞌobꞌ taj chi man are ta tajin kintzijoj rij ri kaxlan wa, xane are tajin kintzijoj rij ri kilevadura ri fariseos xuqujeꞌ ri saduceos? ");
INSERT INTO quctt_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kꞌa te riꞌ xkichꞌobꞌo chi man are ta tajin kubꞌij chike chi rajawaxik kakichajij kibꞌ che ri levadura ri kꞌo pa ri kaxlan wa, xane are ri kikꞌutuꞌn ri fariseos xuqujeꞌ ri saduceos. ");
INSERT INTO quctt_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Are xopan ri Jesús pa ri tinimit Cesarea rech Filipo, xuta chike ri utijoxelabꞌ: ¿Jachin ri in kakibꞌij ri winaq? Ri tijoxelabꞌ xkibꞌij che: ");
INSERT INTO quctt_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","E jujun kakibꞌij chi lal lal Juan ri bꞌanal qasanaꞌ, e jujun chik kakibꞌij lal lal Elías, e nikꞌaj chik kakibꞌij chi lal lal Jeremías o wine jun chike ri qꞌalajisal taq tzij. ");
INSERT INTO quctt_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ri Jesús xubꞌij: E kꞌu ri ix, ¿in jachin ri in kibꞌij ix? ");
INSERT INTO quctt_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ri Simón xubꞌij: Lal lal Cristo, Ralkꞌwaꞌl ri kꞌaslik Dios. ");
INSERT INTO quctt_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ri Jesús xubꞌij: Utz awe, Simón, ralkꞌwaꞌl ri Jonás, rumal man jun winaq taj xkꞌutuw chawach, xane are ri nuTat ri kꞌo pa ri kaj. ");
INSERT INTO quctt_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ri in kinbꞌij chawe chi ri at, at Pedro. Puꞌwiꞌ kꞌu we nimalaj abꞌaj riꞌ kinyak wi na ri nukomontyox, ri uchiꞌ ja rech ri tyoꞌnel qꞌaqꞌ man kachꞌeken ta che. ");
INSERT INTO quctt_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kinya na chawe ri lawe rech ri ajawarem rech ri kaj. Ronojel ri kajatꞌij choch ri uwachulew, kajatꞌix na pa ri kaj, ronojel ri kakir choch ri uwachulew, kakiritaj na pa ri kaj. ");
INSERT INTO quctt_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kꞌa te riꞌ xubꞌij chike ri utijoxelabꞌ chi man kakibꞌij ta chi che jun winaq chik chi ri Jesús areꞌ Cristo. ");
INSERT INTO quctt_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Che ri qꞌij riꞌ, ri Jesús xuchapleꞌj utzijoxik chike ri utijoxelabꞌ chi keꞌ na pa ri tinimit Jerusalén, xuqujeꞌ kabꞌan na kꞌax che kumal ri kꞌamal taq kibꞌe ri winaq aꞌj Israel, ri kꞌamal taq kibꞌe ri e chꞌawenelabꞌ cho ri Dios xuqujeꞌ ri aꞌjtijabꞌ rech ri taqanik, xuqujeꞌ choqꞌaqꞌ kakamisax na, churox qꞌij kꞌut kakꞌastaj na uwach. ");
INSERT INTO quctt_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ri Pedro xukꞌam bꞌik ri Jesús utukel, xuchapleꞌj uyajik xubꞌij che: ¡Ajawxel, man kuya taj jewaꞌ kakꞌulmatajik! ¡Waꞌ we riꞌ man kakꞌulmataj ta wi! ");
INSERT INTO quctt_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ri Jesús xtzolqꞌomijik, xubꞌij che ri Pedro: ¡Chatel bꞌik wukꞌ Itzel! Xaq at qꞌatel we, man are ta achomanik at ri jastaq rech ri Dios, xane kichomanik achyabꞌ kꞌo awukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kꞌa te riꞌ xubꞌij ri Jesús chike ri utijoxelabꞌ we kꞌo jun karaj kuxik nutijoxel, choqꞌaqꞌ, kukꞌekꞌej ribꞌ chibꞌil ribꞌ, karukꞌaꞌj ri cheꞌ rech ripbꞌal, xuqujeꞌ kateriꞌ chwij. ");
INSERT INTO quctt_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Jeriꞌ, rumal ri winaq ri karaj kukol ri ukꞌaslemal, kutzaq na riꞌ, are kꞌu ri kutzaq ri ukꞌaslemal xa rumal we, kuriq na riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Jas kutayij che jun winaq kuchꞌek ronojel ri uwachulew, we kutzaq ri ukꞌaslemal? O ¿jas kakwin jun winaq kuya che ukꞌaxel ri ukꞌaslemal? ");
INSERT INTO quctt_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","In ri uKꞌojol ri Achi, kinpe na rukꞌ ri nujuluwem xuqujeꞌ ri e wangelibꞌ, kuluya na tojbꞌal ke pa kijujunal, jas na kꞌu ri kataqiꞌ chike. ");
INSERT INTO quctt_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Qas tzij kinbꞌij chiꞌwe, e kꞌo jujun chike ri e kꞌo waral, man kekam ta na, kakil na kopan ri uKꞌojol ri Achi pa ri rajawarem. ");
INSERT INTO quctt_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Are ikꞌowinaq chi waqibꞌ qꞌij, ri Jesús xusikꞌij bꞌik ri Pedro, ri Jacobo, ri Juan, ri rachalal ri Jacobo, xepaqiꞌ bꞌik puꞌwiꞌ ri jun nimalaj juyubꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Chilaꞌ xkꞌexkꞌobꞌ wi ri ukaꞌyebꞌal chikiwach ri utijoxelabꞌ, ri upalaj xrepqꞌunik jacha ri qꞌij, ri ratzꞌyaq xrepqꞌunik jacha ri tunal. ");
INSERT INTO quctt_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kꞌa te riꞌ xkikꞌut kibꞌ ri Moisés rachiꞌl ri Elías, tajin ketzijon rukꞌ ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ri Pedro xubꞌij che ri Jesús: Ajawxel, utz we kujkanaj kanoq waral. We kaj la kinbꞌan oxibꞌ alaj taq ja, jun e la, jun rech le Moisés xuqujeꞌ jun rech le Elías. ");
INSERT INTO quctt_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tajin katzijon na ri Pedro, are xaq kꞌa teꞌ xpe jun nimalaj sutzꞌ xuꞌchꞌuq konojel, kꞌa te riꞌ xpe jun chꞌabꞌal pa ri sutzꞌ kubꞌij: Are waꞌ ri loqꞌalaj nukꞌojol, sibꞌalaj kakiꞌkot wanimaꞌ rumal rech. Chinimaj ri kubꞌij areꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Are xkita ri tijoxelabꞌ ri xbꞌixik, sibꞌalaj xkixiꞌj kibꞌ, xexukiꞌk xkiya ri kipalaj pa ri ulew. ");
INSERT INTO quctt_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ri Jesús xqebꞌ kukꞌ, xuꞌchapo, kꞌa te riꞌ xubꞌij chike: Man kixiꞌj ta iwibꞌ, chixwaꞌjiloq. ");
INSERT INTO quctt_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Are xekaꞌyilobꞌik, maj chi jun xkil uwach, xwi ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tajin keqaj loq puꞌwiꞌ ri juyubꞌ are xubꞌij ri Jesús chike: Man kitzijoj ta chi che jun winaq ri xiwilo, kꞌa chinkꞌastaj na, in ri uKꞌojol ri Achi, kꞌa te riꞌ utz kitzijoj. ");
INSERT INTO quctt_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ri tijoxelabꞌ xkita che ri Jesús: ¿Jas che kakibꞌij ri aꞌjtijabꞌ rech ri taqanik chi nabꞌe na kape na ri Elías? ");
INSERT INTO quctt_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ri Jesús xubꞌij chike: Qas tzij kinbꞌij, ri Elías kape chusukꞌumaxik ronojel ri jastaq. ");
INSERT INTO quctt_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Kinbꞌij kꞌu chiꞌwe chi ri Elías xpe kanoq, man xkichꞌobꞌ ta uwach, xane xkibꞌan che ri xraj kikꞌuꞌx. Je xuqujeꞌ kakibꞌan na chwe in ri in uKꞌojol ri Achi. Kakibꞌan na kꞌax chwe. ");
INSERT INTO quctt_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Kꞌa te riꞌ xkichꞌobꞌ ri tijoxelabꞌ chi are tajin kutzijoj rij ri Juan Bꞌanal qasanaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Are xoꞌpan kukꞌ ri winaq, xqebꞌ jun achi rukꞌ ri Jesús, xukiꞌk choch xubꞌij che: ");
INSERT INTO quctt_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ajawxel, toqꞌobꞌisaj la uwach le nukꞌojol. Kabꞌan kꞌax che, kꞌi mul katzaq pa qꞌaqꞌ xuqujeꞌ pa jaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Xinkꞌam loq chikiwach le tijoxelabꞌ la, man xekwin taj xkikunaj. ");
INSERT INTO quctt_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ri Jesús xubꞌij: ¡Ri ix, ix itzel taq winaq, maj ikojobꞌal! ¿La ronojel mul in kꞌo iwukꞌ qaj iwukꞌ? ¿La ronojel mul kinkochꞌ ri kibꞌano? Kꞌa te riꞌ xubꞌij: Chikꞌama loq ri ala. ");
INSERT INTO quctt_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ri Jesús xresaj bꞌik ri itzel uxlabꞌal ri kꞌo che ri ala, qas che ri qꞌotaj riꞌ ri ala xkunatajik. ");
INSERT INTO quctt_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kꞌa te riꞌ ri tijoxelabꞌ xaq kitukel xeqet rukꞌ ri Jesús, xkita che: ¿Jas che man xujkwin ta uj xqesaj bꞌik ri itzel uxlabꞌal? ");
INSERT INTO quctt_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ri Jesús xubꞌij chike: Rumal cher xa nitzꞌ ri ikojobꞌal. Qas tzij kinbꞌij chiꞌwe, we ta kꞌo ikojobꞌal jetaq ri ijaꞌ rech ri moxtansia, kixkwin riꞌ kibꞌij che we juyubꞌ riꞌ: “¡Chatel bꞌik waral, jat je laꞌ!” Keꞌ riꞌ jawjeꞌ ri kitaq wi bꞌik. Maj jun jastaq riꞌ ri mat kixkwin chubꞌanik. ");
INSERT INTO quctt_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","/We itzel uxlabꞌal riꞌ man kel ta bꞌik we man kibꞌan chꞌawem xuqujeꞌ we man kibꞌan qꞌipoj waꞌim./ ");
INSERT INTO quctt_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Are kimulim kibꞌ pa Galilea, ri Jesús xubꞌij chike: In ri uKꞌojol ri Achi, kinjach na pa kiqꞌabꞌ ri achyabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Kinkamisax na, churox qꞌij kꞌut kinkꞌastajik. Are xkita ri tijoxelabꞌ ri xbꞌix chike, sibꞌalaj xebꞌisonik. ");
INSERT INTO quctt_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Are xopan ri Jesús pa ri tinimit Capernaúm, ri e toqꞌil taq alkabal rech ri Templo xeqet rukꞌ ri Pedro, xkita che: ¿La kutoj kꞌu le iwajtij alkabal rech le Templo? ");
INSERT INTO quctt_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Jeꞌ, kutojo, xubꞌij ri Pedro. Are xok bꞌik ri Pedro pa ri ja, ri Jesús xnabꞌej chutayik che: Simón, ¿jas kabꞌij at? Ri e nimaꞌq taq taqanelabꞌ ¿jachin chike kakitoqꞌij wi ri alkabal, chike ri e kalkꞌwaꞌl o chike konojel ri winaq? ");
INSERT INTO quctt_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Chike konojel ri winaq, xcha ri Pedro. Ri Jesús xubꞌij che: Kawilo ri e kalkꞌwaꞌl man kakitoj taj. ");
INSERT INTO quctt_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Man kawaj ta kꞌut kinkoj chꞌoꞌj chikixoꞌl we winaq riꞌ. Jat pa le plo, chakꞌyaqa ri chapbꞌal kar. Ri nabꞌe kar ri kachapo, kꞌo jun pwaq pa uchiꞌ. Chawesaj ri pwaq, rukꞌ riꞌ chatojo ri alkabal we in xuqujeꞌ awe at. ");
INSERT INTO quctt_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Qas pa ri qꞌotaj riꞌ, ri tijoxelabꞌ xeqet rukꞌ ri Jesús, xkita che: ¿Jachin ri qas sibꞌalaj nim uqꞌij pa ri ajawarem rech ri kaj? ");
INSERT INTO quctt_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ri Jesús xusikꞌij jun akꞌal, xuya chikixoꞌl. ");
INSERT INTO quctt_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Kꞌa te riꞌ xubꞌij: Qas tzij kinbꞌij chiꞌwe, we man kikꞌex iwibꞌ, rech je kixux akꞌalabꞌ, man kixkwin taj kixok pa ri ajawarem rech ri kaj. ");
INSERT INTO quctt_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Jeriꞌ, ri kumochꞌ ribꞌ jacha we kubꞌan we akꞌal riꞌ, sibꞌalaj nim na uqꞌij pa ri ajawarem rech ri kaj. ");
INSERT INTO quctt_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Xuqujeꞌ ri kukꞌamawaꞌj jun akꞌal pa ri nubꞌiꞌ, in riꞌ kinukꞌamawaꞌj. ");
INSERT INTO quctt_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","We kꞌo jun kuꞌtaqchiꞌj pa mak we alaj taq nitzꞌ ri e kojoninaq chwe. Are katan riꞌ we kaxekebꞌax bꞌik jun abꞌaj rech keꞌbꞌal chuqul, kꞌa te riꞌ kakꞌyaq bꞌik kꞌa pa ri ukꞌuꞌx ri cho. ");
INSERT INTO quctt_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Kꞌax ke ri winaq ri keꞌkitaqchiꞌj nikꞌaj winaq chik pa mak! Rajawaxik kꞌu wi chi kakꞌulmataj na we riꞌ, xa kꞌu kꞌax rech ri winaq ri kuꞌtaqchiꞌj chi nikꞌaj pa mak. ");
INSERT INTO quctt_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","We are ri aqꞌabꞌ o ri awaqan kabꞌanow chawe katmakunik, chakutij, kꞌa te riꞌ chakꞌyaqa bꞌik. Are katanik katok pa ri jun alik kꞌaslemal, maj jun aqꞌabꞌ o maj jun awaqan cho ri rukꞌ ukobꞌchal aqꞌabꞌ xuqujeꞌ rukꞌ ukobꞌchal ri awaqan katkꞌyaq bꞌik pa ri qꞌaqꞌ ri maj ukꞌisik. ");
INSERT INTO quctt_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","We are ri abꞌoqꞌoch kabꞌanow chawe katmakunik, chawesaj, chakꞌyaqa bꞌik. Are katanik xa rukꞌ jun abꞌoqꞌoch katok pa ri jun alik kꞌaslemal cho ri rukꞌ ukobꞌchal ri abꞌoqꞌoch katkꞌyaq bꞌik pa ri qꞌaqꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Qas chiwila na, miwetzelaj jun chike we alaj taq e nitzꞌ riꞌ. Rumal qas kinbꞌij chiꞌwe chi ri kiángel, amaqꞌel ketzijon rukꞌ ri nuTat ri kꞌo chilaꞌ chikaj. ");
INSERT INTO quctt_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","/Ri uKꞌojol ri Achi xpetik che kikolik ri e sachinaq kanoq./ ");
INSERT INTO quctt_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Jas kichomaj ix chrij ri achi, ri kasach kan jun chike ri jun ciento uchij? ¿La man kꞌu kuꞌya kan ri junmuchꞌ bꞌelej lajuj pa ri juyubꞌ rech keꞌ chutzukuxik ri uchij ri xsach kanoq? ");
INSERT INTO quctt_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Qas tzij kinbꞌij chiꞌwe, sibꞌalaj kꞌo na ri ukiꞌkotemal ri ajyuqꞌ are kuriq ri jun uchij, cho ri e junmuchꞌ bꞌelej lajuj chij ri man xesach taj. ");
INSERT INTO quctt_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Je xuqujeꞌ ri iTat ri kꞌo pa ri kaj, man karaj taj katzaq jun chike we alaj taq nitzꞌ riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","We kꞌo jun awachalal pa Cristo, kubꞌan jun kꞌax chawe, jat rukꞌ atukel, chabꞌij che ri xubꞌan chawe. We kutatabꞌej ri kabꞌij che xatchꞌeken riꞌ che. ");
INSERT INTO quctt_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","We man kutatabꞌej ri awachalal ri kabꞌij che, jat chi junmul rukꞌ, chaꞌkꞌama bꞌik kebꞌ o oxibꞌ winaq awukꞌ, rech kakilo jas kibꞌan chusukꞌumaxik ri xkꞌulmatajik. ");
INSERT INTO quctt_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","We man kuta wi ri kabꞌix che, chabꞌij chike ri komontyox, we man kuta wi tzij, chabꞌana che chi jer kꞌo jun winaq ri man kojonel taj o jun itzel winaq. ");
INSERT INTO quctt_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Qas tzij kinbꞌij chiꞌwe ronojel ri man kaya ta bꞌe che cho ri uwachulew, man kaya ta bꞌe che chilaꞌ chikaj, xuqujeꞌ ronojel ri kaya bꞌe che cho ri uwachulew, kaya na bꞌe che pa ri kaj. ");
INSERT INTO quctt_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Xuqujeꞌ kinbꞌij chiꞌwe we e kꞌo kebꞌ chiꞌwe kakijunamaj kikꞌuꞌx chutayik jun jastaq, kayaꞌtaj na chike rumal ri nuTat ri kꞌo pa ri kaj. ");
INSERT INTO quctt_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Jeriꞌ rumal cher jawjeꞌ ri kakimulij wi kibꞌ kebꞌ oꞌxibꞌ winaq pa ri nubꞌiꞌ, kinkꞌojiꞌ riꞌ chikixoꞌl. ");
INSERT INTO quctt_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ri Pedro xqebꞌ chuxukut ri Jesús xubꞌij che: ¿Awaj janipa mul rajawaxik kikuy umak ri wachalal ri kubꞌan kꞌax chwe? ¿La xaqareꞌ wuqubꞌ mul? ");
INSERT INTO quctt_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ri Jesús xubꞌij: Man tajin ta kinbꞌij chawe chi xa wuqubꞌ mul xane wuqubꞌ mul oxkꞌal lajuj. ");
INSERT INTO quctt_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Rumal riꞌ, ri ajawarem rech ri kaj kajunumataj rukꞌ ri jun taqanel ri xuta chike ri rajchakibꞌ chi kakijach ri kwenta rech ri pwaq ri kikꞌas rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Are xuchapleꞌj kitoqꞌixik, xopan ri jun rajchak ri ukꞌas lajuj mil qꞌana pwaq rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Maj urajil chutojik ri ukꞌas, rumal riꞌ ri patrón xtaqan chukꞌayixik ri achi, ri rixoqil, xuqujeꞌ ri ralkꞌwaꞌl, xuqujeꞌ ronojel ri ujastaq ri kꞌolik rech katojtaj ri kꞌasaj. ");
INSERT INTO quctt_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ri ajchak xukiꞌk choch ri upatrón xuta toqꞌobꞌ che xubꞌij: Toqꞌobꞌisaj la nuwach, kintoj na che la ronojel ri nukꞌas. ");
INSERT INTO quctt_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ri patrón xutoqꞌobꞌisaj uwach ri rajchak, xubꞌij che chi maj chi ukꞌas, kꞌa te riꞌ xutzoqopij bꞌik. ");
INSERT INTO quctt_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Are xel bꞌik ri ajchak rukꞌ ri patrón, xuriq jun chike ri rachiꞌl ri ukꞌas jun ciento saq pwaq rukꞌ, xuchap che ri uqul are xraj xujitzꞌaj, kꞌa te riꞌ xubꞌij che: Chatojo ri akꞌas wukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ri rech ajchak xukiꞌk choch, xuta toqꞌobꞌ che xubꞌij: Chatoqꞌobꞌisaj nuwach, kintoj na chawe ronojel ri nukꞌas. ");
INSERT INTO quctt_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ri achi man xutoqꞌobꞌisaj ta uwach ri rech ajchak, xyojtajik kꞌa te riꞌ xuꞌkojo kan pa cheꞌ, kꞌa chutojo na ri ukꞌas. ");
INSERT INTO quctt_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Are xkil konojel ri ajchakibꞌ ri xkꞌulmatajik, sibꞌalaj xebꞌisonik, kꞌa te riꞌ xeꞌkitzijoj che ri kipatrón ri xkꞌulmatajik. ");
INSERT INTO quctt_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ri patrón xusikꞌij ri ajchak ri je xubꞌan we riꞌ, xubꞌij che: “¡At Itzel laj ajchak! Xinkuy ri akꞌas, rumal xata toqꞌobꞌ chwe. ");
INSERT INTO quctt_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿La man kꞌu xatoqꞌobꞌisaj uwach ri awachiꞌl jacha ri xinbꞌan in chawe?” ");
INSERT INTO quctt_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ri patrón xyojtajik, kꞌa te riꞌ xujach bꞌik ri achi chike ri ajchakibꞌ pa ri cheꞌ, rech kabꞌan kꞌax che kꞌa chutojo na ronojel ri ukꞌas. ");
INSERT INTO quctt_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ri Jesús xubꞌij: Jeriꞌ kubꞌan na ri nuTat ri kꞌo chilaꞌ chikaj chiꞌwe, we man kiꞌkuy ri iwachalal rukꞌ ronojel ikꞌuꞌx. ");
INSERT INTO quctt_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Are xtoꞌtaj ri Jesús chubꞌixik ronojel we jastaq riꞌ, xel bꞌik pa ri Galilea, xeꞌ pa jun tinimit rech Judea, chꞌaqaꞌp che ri Jordán. ");
INSERT INTO quctt_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Sibꞌalaj e kꞌi winaq xeteriꞌ chirij, xuꞌkunaj konojel ri e yawabꞌibꞌ ri e kꞌo chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","E jujun fariseos xeqet rukꞌ ri Jesús are kakaj kakikoj jun kꞌaꞌmabꞌal che, xkita che: ¿La yaꞌtal che jun achi kujach ri rixoqil rumal xapakux jastaq ri xkꞌulmatajik? ");
INSERT INTO quctt_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ri Jesús xubꞌij: ¿La man isikꞌim ri tzꞌibꞌatalik, pa ri majibꞌal re ronojel, ri Tikol kaj xuqujeꞌ ulew, xutik ri achi xuqujeꞌ ri ixoq? ");
INSERT INTO quctt_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Xuqujeꞌ xubꞌij: Rumal waꞌ ri achi kuꞌtzaq kan ri utat unan, keꞌ rukꞌ ri rixoqil rech kuꞌx xa jun winaq. ");
INSERT INTO quctt_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Xaq jeriꞌ man e kebꞌ ta chik, xane xa e jun chik. Rumal cher ri xunukꞌ ri Dios, man kakwin ta ri achi kuꞌjacho. ");
INSERT INTO quctt_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ri fariseos xkibꞌij che: ¿Jas kꞌu che ri Moisés pa ri taqanik ri xuya kanoq kubꞌij chi ri achi kakwinik kujach ribꞌ che ri rixoqil we kuya ri wuj che jawjeꞌ kubꞌij wi chi kakijach kibꞌ? ");
INSERT INTO quctt_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ri Jesús xubꞌij: Ri Moisés xuya bꞌe chiꞌwe kiꞌjach ri iwixoqilal rumal cher sibꞌalaj abꞌaj ri iwanimaꞌ, man je ta kꞌu riꞌ ubꞌanik pa ri majibꞌal loq rech ronojel. ");
INSERT INTO quctt_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kinbꞌij chiꞌwe, we kꞌo jun kujach ri rixoqil, man xa ta rumal xmakun chik rukꞌ jun achi, kꞌa te riꞌ kakꞌuliꞌ rukꞌ jun ixoq chik, kamakunik, rumal e kebꞌ chi riꞌ ri rixoqil. ");
INSERT INTO quctt_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ri tijoxelabꞌ xkibꞌij: We jeriꞌ kakꞌulmataj chikixoꞌl ri achi rachiꞌl ri rixoqil, are katan riꞌ man kakꞌuliꞌ ta jun. ");
INSERT INTO quctt_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ri Jesús xubꞌij: Man konojel taj kakikꞌamawaꞌj we jastaq riꞌ xane xwi ri winaq ri yaꞌtal chike kakikꞌamawaꞌj. ");
INSERT INTO quctt_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Jeriꞌ rumal cher e kꞌo winaq eunuco, kech wi pa ri kikꞌojiꞌkal, e kꞌo chi nikꞌaj xa xbꞌan eunuco chike kumal ri achyabꞌ, e kꞌo chi nikꞌaj eunuco rumal cher aꞌreꞌ xkichaꞌ ri ajawarem rech chilaꞌ chikaj. Ri karaj kukꞌamawaꞌj we riꞌ chukꞌamawaꞌj. ");
INSERT INTO quctt_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ri winaq xeꞌkikꞌam bꞌik akꞌalabꞌ rukꞌ ri Jesús rech kuya ri uqꞌabꞌ xuqujeꞌ kubꞌan chꞌawem pa kiwiꞌ. Ri tijoxelabꞌ kꞌut xkichapleꞌj kiyajik ri e kꞌamowinaq bꞌik ri akꞌalabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ri Jesús xubꞌij chike: Chiya bꞌe chike ri akꞌalabꞌ kepe wukꞌ, man kiꞌqꞌatej taj, rumal cher ri winaq ri je kenoꞌjin akꞌalabꞌ are ri ajawarem rech ri kaj. ");
INSERT INTO quctt_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Are xtoꞌtaj chuyaꞌik ri uqꞌabꞌ pa kiwiꞌ ri akꞌalabꞌ xel bꞌik chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kꞌa te riꞌ jun achi xqebꞌ rukꞌ ri Jesús xubꞌij che: Ajtij, ¿jas ri utzilal ri rajawaxik kinbꞌano rech kinok pa ri jun alik kꞌaslemal? ");
INSERT INTO quctt_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ri Jesús xubꞌij che: ¿Jas che kata chwe jas riꞌ ri utzilal? Xa jun riꞌ ri utz. Chanimaj ri taqanik, we kawaj katok pa ri jun alik kꞌaslemal. ");
INSERT INTO quctt_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ri achi xuta che ri Jesús: ¿Jachin chike taq riꞌ ri taqanik ri kabꞌij la? Ri Jesús xubꞌij che: Man katkamisan taj, man kekꞌojiꞌ ta kebꞌ awixoqil, man katelaqꞌ taj, man kabꞌan ta bꞌanoj tzij chirij jun winaq chik. ");
INSERT INTO quctt_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Nim chaꞌwila ri atat anan, xuqujeꞌ chaloqꞌaj ri ajil tzꞌaqat jacha ri kabꞌan chuloqꞌaxik awibꞌ at. ");
INSERT INTO quctt_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ri ala xubꞌij: Ronojel waꞌ we riꞌ nubꞌanom. ¿Jas chi jun kajawataj na? ");
INSERT INTO quctt_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ri Jesús xubꞌij che: We kawaj qas at tzꞌaqat, jat jaꞌkꞌayij kanoq ronojel ri kꞌo awukꞌ, kꞌa te riꞌ chaya ri pwaq chike ri e mebꞌaibꞌ, kayaꞌtaj kꞌu na aqꞌinomal pa ri kaj. Kꞌa te riꞌ chatan loq, chinatereneꞌj. ");
INSERT INTO quctt_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Are xuta ri ala ri xbꞌix che, kabꞌisonik xeꞌek, rumal sibꞌalaj nim uqꞌinomal ri kꞌolik. ");
INSERT INTO quctt_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ri Jesús xubꞌij chike ri utijoxelabꞌ, qas tzij kinbꞌij chiꞌwe sibꞌalaj kꞌax rokem jun qꞌinom pa ri ajawarem rech ri kaj. ");
INSERT INTO quctt_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Are man kꞌax taj rokem jun kameypa ri ujolom ri bꞌaq cho ri rokik ri qꞌinom pa ri ajawarem rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ri tijoxelabꞌ xemayijanik are xkita ri xbꞌix chike, xkibꞌij: We jeriꞌ ¿jachin kꞌu riꞌ ri kakwinik kukol ribꞌ? ");
INSERT INTO quctt_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ri Jesús ko xuꞌkaꞌyej kꞌa te riꞌ xubꞌij chike: Ri Dios kakwinik kubꞌano ri man kakwin ta ri achi chubꞌanik. ");
INSERT INTO quctt_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ri Pedro xubꞌij che ri Jesús: Chilampe la, uj qatzaqom kanoq ronojel rumal tereneꞌxik la. ¿Jas kꞌu kaqachꞌek uj rukꞌ we riꞌ? ");
INSERT INTO quctt_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ri Jesús xubꞌij: Qas tzij kinbꞌij chiꞌwech are kabꞌan kꞌakꞌ che ri jastaq, are kintꞌuyiꞌ na In ri in uKꞌojol ri Achi pa ri tꞌuyulibꞌal ri kajuluwik, kixtꞌuyiꞌ xuqujeꞌ na ix pa ri kabꞌlajuj tꞌuyulibꞌal, rech kiqꞌat tzij pa kiwiꞌ ri e kabꞌlajuj wok winaq aꞌj Israel. ");
INSERT INTO quctt_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ri winaq ri xa rumal we, xutzaq kan rachoch, e rachalal, e ranabꞌ, utat unan, e ralkꞌwaꞌl xuqujeꞌ rulew, kukꞌamawaꞌj na ciento mul ukꞌaxelal xuqujeꞌ ri jun alik kꞌaslemal. ");
INSERT INTO quctt_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","E kꞌi chike ri e nabꞌe, kuꞌx na e kꞌisbꞌal, xuqujeꞌ e kꞌi chike ri e kꞌisbꞌal kuꞌx na e nabꞌe. ");
INSERT INTO quctt_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ri ajawarem rech ri Dios kajunumataj xuqujeꞌ rukꞌ ri jun patrón ri sibꞌalaj aqꞌabꞌ xwaꞌjil bꞌik, xeꞌ chikitzukuxik rajchakibꞌ rech keꞌchakun rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Are xuꞌriq jujun ajchakibꞌ, xuꞌtaq bꞌik pa ri uchak, xubꞌij chike chikutoj jun denario ri kiqꞌij. ");
INSERT INTO quctt_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Pa ri bꞌelejebꞌ qꞌotaj rech ri qꞌij ri patrón xeꞌ chi junmul chikitzukuxik ri ajchakibꞌ, are xeꞌril chi nikꞌaj winaq ri maj kakichakuj. ");
INSERT INTO quctt_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Xubꞌij chike: “Jix xuqujeꞌ ix, jix e chakun pa ri wulew. Kintoj na ri qas xaqareꞌ chiꞌwe.” ");
INSERT INTO quctt_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Jaꞌe, xechaꞌ. Xebꞌe pa ri chak. Ri patrón xel bꞌik pa ri nikꞌaj qꞌij, xuqujeꞌ pa ri nikꞌaj bꞌenaq qꞌij, xubꞌutzukuj chi na nikꞌaj ajchakibꞌ, je xubꞌij chike jetaq ri xubꞌij chike ri nikꞌaj winaq, aqꞌabꞌil. ");
INSERT INTO quctt_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Pa ri uroꞌ qꞌotaj rech ri bꞌenaq qꞌij xel chi na bꞌik ri patrón, xuꞌriq chi na nikꞌaj winaq ri maj kichak, xuta chike: “¿Jas che xaq ix kꞌo waral maj kichakuj?” ");
INSERT INTO quctt_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ri winaq xkibꞌij che: “Maj jachin tzujuwinaq qachak.” Ri patrón xubꞌij chike: “Jix xuqujeꞌ ix, jix e chakun pa ri wulew.” ");
INSERT INTO quctt_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Are xqaj ri qꞌij, ri ajchoqꞌe ri ulew xubꞌij che ri yakol urajil: “Chaꞌsikꞌij ri ajchakibꞌ, chatojo bꞌik ri kiqꞌij, are nabꞌe kaꞌtoj ri kꞌisbꞌal xuꞌlik, kꞌa te riꞌ kaꞌtoj ri nabꞌe xuꞌlik.” ");
INSERT INTO quctt_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Xoꞌpan ri ajchakibꞌ ri xeꞌmok pa ri uroꞌ rech ri bꞌenaq qꞌij, xya bꞌik ri kirajil rech ri jun qꞌij kichak. ");
INSERT INTO quctt_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Are xoꞌpan ri winaq ri xemok nabꞌe pa ri chak, pa kikꞌuꞌx chi nim kirajil kaya chikiwach ri nikꞌaj chik. Xaq kꞌu junam ri xya chike, xa rech jun qꞌij chak. ");
INSERT INTO quctt_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Are xkꞌamtaj ri tojbꞌal ke xkichapleꞌj utzijoxik rij ri Patrón. ");
INSERT INTO quctt_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Xkibꞌij: “We ajchakibꞌ ri xetoj la nabꞌe, xa jun hora xechakunik, junam xbꞌan la chikitojik qukꞌ, uj naj xujchakunik xqakochꞌ ri chak xuqujeꞌ ri qꞌij.” ");
INSERT INTO quctt_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ri patrón xubꞌij che jun chike ri ajchakibꞌ: “Ala maj kꞌaxal tajin kinbꞌan chawe ¿Man xakꞌam ta kꞌut uqꞌabꞌ ri tojbꞌal awe xintzuju are xatinmoko? ");
INSERT INTO quctt_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Jat, chakꞌama bꞌik ri tojbꞌal awe, kawaj kintoj chi na ri kꞌisbꞌal ajchak, jetaq ri xinbꞌan che atojik at. ");
INSERT INTO quctt_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Man kꞌu yaꞌtal chwe kinbꞌan rukꞌ ri nurajil jacha ri kawaj in? ¿O xa kꞌax chawe chi sibꞌalaj in utz winaq?” ");
INSERT INTO quctt_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jeriꞌ, ri e nabꞌe kuꞌx na kꞌisbꞌal, xuqujeꞌ ri e kꞌisbꞌal kuꞌx na e nabꞌe. ");
INSERT INTO quctt_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Are xpaqiꞌ ri Jesús pa Jerusalén, xuꞌkaꞌm bꞌik ri e kabꞌlajuj utijoxelabꞌ, xubꞌij chike: ");
INSERT INTO quctt_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Chanim kujeꞌ pa ri tinimit Jerusalén, chilaꞌ ri in ri uKꞌojol ri Achi kinjach na pa kiqꞌabꞌ ri e kꞌamal taq bꞌe kech ri e chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq xuqujeꞌ ri aꞌjtijabꞌ rech ri taqanik. Aꞌreꞌ kakiqꞌat na tzij pa nuwiꞌ xuqujeꞌ kinkikamisaj na. ");
INSERT INTO quctt_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Xuqujeꞌ kinkijach na pa kiqꞌabꞌ ri winaq ri man aꞌj Israel taj rech kakitzꞌeꞌj na nuwach, kinkirapuj na, xuqujeꞌ kinkirip na. Churox qꞌij kꞌut kinkꞌastaj na. ");
INSERT INTO quctt_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ri unan ri Jacobo xuqujeꞌ ri Juan e rachiꞌl ri ral xqebꞌ rukꞌ ri Jesús, xukiꞌ choch, kꞌa te riꞌ xuta jun toqꞌobꞌ che. ");
INSERT INTO quctt_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ri Jesús xuta che: ¿Jas kawaj? Ri chuchuꞌ xubꞌij: Taqan la chi pa ri ajawarem la jun chike we wal riꞌ katꞌuyiꞌ pa ri wiqiqꞌabꞌ la, ri jun chik katꞌuyiꞌ pa ri mox la. ");
INSERT INTO quctt_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ri Jesús xubꞌij che: Man iwetaꞌm ta ri tajin kitoqꞌij. ¿La kixkwin ix kiwikꞌowisaj ri kꞌaxkꞌolal ri kakꞌulmataj na wukꞌ in? Ri tijoxelabꞌ xkibꞌij: Kujkwinik. ");
INSERT INTO quctt_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ri Jesús xubꞌij chike: Qas kixkwin wi riꞌ kiriq ri kꞌax ri kinriq in, man in ta kꞌut kabꞌan we kinya itꞌuyulibꞌal pa ri nuwiqiqꞌabꞌ xuqujeꞌ pa ri numox. Are ri nuTat riꞌ etaꞌmaninaq e jachinaq. ");
INSERT INTO quctt_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Are xkita ri lajuj tijoxelabꞌ ri xkibꞌan ri e kebꞌ kachiꞌl xeyojtaj kukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ri Jesús xuꞌsikꞌij xubꞌij chike: Ix iwetaꞌm ri e qꞌatal taq tzij pa taq ri tinimit kakibꞌan kꞌax chike ri winaq xuqujeꞌ ri e kipatanijelabꞌ, rukꞌ che ri kꞌo kikwinem. ");
INSERT INTO quctt_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Man yaꞌtal ta kꞌut jewaꞌ kakꞌulmataj iwukꞌ ix. Xane ri karaj kux nim uqꞌij chiꞌxoꞌl ix rajawaxik kux patanil iwe. ");
INSERT INTO quctt_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Xuqujeꞌ xapachin ri karaj kux nabꞌe chiꞌwe ix, rajawaxik kux kajchak konojel. ");
INSERT INTO quctt_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Jeꞌ jetaq ri uKꞌojol ri Achi man xpe taj rech kapatanixik, xane xpe chikipatanixik xuqujeꞌ chuyaꞌik ri ukꞌaslemal kumal ke e kꞌi winaq. ");
INSERT INTO quctt_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Are xel bꞌik ri Jesús pa ri tinimit Jericó e rachiꞌl ri utijoxelabꞌ, sibꞌalaj kꞌi winaq e teren bꞌik chirij. ");
INSERT INTO quctt_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","E kꞌo kꞌu kebꞌ achyabꞌ e tꞌuyul chuchiꞌ ri bꞌe, are xkito chi tajin kikꞌow bꞌik ri Jesús chilaꞌ xkiraq kichiꞌ, xkibꞌij: Ajawxel, ralkꞌwaꞌl ri David, toqꞌobꞌisaj la qawach. ");
INSERT INTO quctt_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ri winaq xeꞌkiyajo rech kuꞌxlanik, man xkita ta kꞌut ri xbꞌix chike xane rukꞌ chuqꞌabꞌ xkiraq kichiꞌ xkibꞌij: Ajawxel, Ralkꞌwaꞌl ri David, toqꞌobꞌisaj la qawach. ");
INSERT INTO quctt_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Xtakꞌiꞌ ri Jesús, xuꞌsikꞌij, xuta chike: ¿Jas kiwaj kinbꞌan chiꞌwe? ");
INSERT INTO quctt_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ri moyabꞌ xkibꞌij: Ajawxel, kaqaj kujkaꞌyik. ");
INSERT INTO quctt_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ri Jesús xutoqꞌobꞌisaj kiwach, xuchap ri kibꞌoqꞌoch, aninaq xekwinik xekaꞌyik, kꞌa te riꞌ xkitereneꞌj ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Are xenaqajin che ri tinimit Jerusalén, xoꞌpan pa ri leꞌaj Betfagé puꞌwiꞌ ri juyubꞌ Olivos, ri Jesús xuꞌtaq bꞌik e kebꞌ utijoxelabꞌ, ");
INSERT INTO quctt_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","xubꞌij bꞌik chike: Jix pa ri alaj tinimit ri kꞌo apanoq chiꞌwach, chilaꞌ kiꞌriqa wi jun atiꞌt bꞌur xuqujeꞌ jun laj bꞌur, e jatꞌitalik, chikira loq chiꞌkꞌama loq. ");
INSERT INTO quctt_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","We kꞌo ne jachin kꞌo kubꞌij chiꞌwe, chibꞌij che xa kajawataj che ri Ajawxel, kꞌa te kutzalij chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Jeꞌ riꞌ rech kakꞌulmataj ri xubꞌij loq ri qꞌalajisal utzij Dios are xubꞌij: ");
INSERT INTO quctt_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Chibꞌij chike ri winaq aꞌj Jerusalén: Chiwilampeꞌ, ri ataqanel petinaq, sibꞌalaj utz ranimaꞌ Kejeninaq chirij jun laj bꞌur, ral jun awaj ri kubꞌan eqaꞌn. ");
INSERT INTO quctt_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Xebꞌe ri tijoxelabꞌ je xkibꞌano jetaq ri xubꞌij ri Jesús chike. ");
INSERT INTO quctt_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Xeꞌkikꞌama loq ri atiꞌt bꞌur xuqujeꞌ ri alaj bꞌur, xkilikꞌ ri kimanta chirij, kꞌa te riꞌ xtꞌuyiꞌ ri Jesús chirij. ");
INSERT INTO quctt_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Sibꞌalaj e kꞌi winaq xkilikꞌ ri kimanta pa ri bꞌe, e kꞌo chi nikꞌaj xkitzukuj uqꞌabꞌ taq cheꞌ xkiya pa ri bꞌe. ");
INSERT INTO quctt_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ri winaq ri e nabꞌe cho ri Jesús xuqujeꞌ ri e teren chirij, xkiraq kichiꞌ xkibꞌij: Juluwem che ri Ralkꞌwaꞌl ri David. Tewchiꞌtal ri petinaq pa ri ubꞌiꞌ ri Ajawxel. Bꞌana la toqꞌobꞌ, chujkolo la nimalaj Dios. ");
INSERT INTO quctt_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Are xok bꞌi ri Jesús pa Jerusalén, salabꞌataj ri kanimaꞌ konojel ri winaq, kakitatabꞌela chibꞌil taq kibꞌ ¿jachin waꞌ we achi riꞌ? ");
INSERT INTO quctt_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","E kꞌo winaq xkibꞌij: Are waꞌ ri Jesús, ri qꞌalajisal utzij ri Dios ri kel pa ri tinimit Nazaret rech Galilea. ");
INSERT INTO quctt_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ri Jesús xok bꞌik pa ri Templo, xeꞌresaj loq konojel ri winaq ri tajin kakikꞌayij xuqujeꞌ tajin kakiloqꞌ aꞌwaj rech ri sipanik. Xuwolqotij bꞌik ri kimexa ri kꞌexol taq pwaq, xuqujeꞌ ri tajin keꞌkikꞌayij palomax. ");
INSERT INTO quctt_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kꞌa te riꞌ xubꞌij chike: Tzꞌibꞌatalik chi ri wachoch Ja rech bꞌanbꞌal chꞌawem, ri ix kꞌut tajin kibꞌan kijul eleqꞌomabꞌ che. ");
INSERT INTO quctt_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Xepe kꞌu moyabꞌ xuqujeꞌ chꞌokeꞌr taq winaq, xeqet rukꞌ ri Jesús pa ri Templo, ri Jesús kꞌut xuꞌkunaj. ");
INSERT INTO quctt_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ri e kꞌamal taq bꞌe ke ri chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq xuqujeꞌ ri aꞌjtijabꞌ rech ri taqanik are xkil ri mayijabꞌal taq jastaq ri xubꞌan ri Jesús xuqujeꞌ are xeꞌkita ri akꞌalabꞌ ri e kꞌo pa ri Templo kakiraq kichiꞌ kakibꞌij “juluwem che ri Ralkꞌwaꞌl ri David”, sibꞌalaj xyakataj koyawal. ");
INSERT INTO quctt_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Xkibꞌij che ri Jesús: ¿La kata ri tajin kakibꞌij? Ri Jesús xubꞌij chike: Qas kinta wi, ¿man isikꞌim ta kꞌu ri tzꞌibꞌatalik kibꞌij: Chi kichiꞌ ri alaj taq nitzꞌ taq akꞌalabꞌ xuqujeꞌ ri ketuꞌn na, yaꞌtal wi ri jeꞌl laj bꞌixonem? ");
INSERT INTO quctt_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kꞌa te riꞌ xel bꞌik ri Jesús pa ri tinimit, xeꞌkꞌol kanoq jun aqꞌabꞌ pa ri tinimit Betania. ");
INSERT INTO quctt_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Sibꞌalaj aqꞌabꞌil are tzalijem loq rech ri Jesús pa ri tinimit, xnumik. ");
INSERT INTO quctt_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Are xril jun higuera ri kꞌo chuchiꞌ ri bꞌe, xqebꞌ rukꞌ, xraj xutzukuj jun uwach, xa ta ne kꞌu ne jun xuriqo. Xubꞌij che ri cheꞌ: Xa ta ne junmul chik katwachinik. Tzi che riꞌ ri higuera xchaqiꞌjarik. ");
INSERT INTO quctt_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ri tijoxelabꞌ xemayijanik are xkil ri xkꞌulmatajik. ¿Jas che laꞌ aninaq xchaqiꞌjar ri higuera? xechaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ri Jesús xubꞌij chike: Qas tzij kinbꞌij chiꞌwe, we qas kꞌo ikojobꞌal, man kakabꞌalaj ta ikꞌuꞌx, man xwi ta kixkwinik laꞌ kibꞌano jetaq le xinbꞌan in che le higuera, xane kixkwinik kibꞌij che le juyubꞌ leꞌ, chatel bꞌik chilaꞌ jat pa le cho, jeriꞌ kꞌut kakꞌulmataj na. ");
INSERT INTO quctt_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","We qas kikojonik, kikꞌamawaꞌj na ronojel ri kita pa ri ichꞌawem. ");
INSERT INTO quctt_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ri Jesús xok bꞌik pa ri Templo, are tajin kuya ri kꞌutuꞌn, xeqet rukꞌ ri e kꞌamal taq bꞌe kech ri chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq, e kachiꞌl ri e kꞌamal taq bꞌe rech ri tinimit xkita che: ¿Jas kwinem kakoj chubꞌanik we riꞌ? ¿Jachin xyoꞌw we kwinem riꞌ chawe? ");
INSERT INTO quctt_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ri Jesús xubꞌij chike: Ri in xuqujeꞌ kinta jun kꞌotbꞌal chiꞌ chiꞌwe, we kibꞌij ri kinta chiꞌwe, kinbꞌij chiꞌwe jachin yoꞌwinaq kwinem chwe kinbꞌan we jastaq riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ri kwinem ri xya che ri Juan rech kubꞌan qasanaꞌ ¿jawjeꞌ upetik wi, chikaj o choch ri uwachulew? Ri achyabꞌ xkichapleꞌj utzijoxik rij, xkibꞌij: We kaqabꞌij chi chikaj upetik wi, kubꞌij laꞌ chaqe ¿jas kꞌu che man xikoj taj? ");
INSERT INTO quctt_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","We kaqabꞌij chi choch uwachulew xpe wi, kaqaxiꞌj qibꞌ chikiwach le winaq pa le tinimit, rumal aꞌreꞌ kikojom chi ri Juan are jun qꞌalajisal utzij ri Dios. Jeriꞌ xeꞌkibꞌij che ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Man qetaꞌm taj. Ri Jesús xubꞌij chike: In xuqujeꞌ man kinbꞌij taj chiꞌwe jawjeꞌ kape wi ri kwinem ri kinkoj chubꞌanik we kinbꞌano. ");
INSERT INTO quctt_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ri Jesús xubꞌij: Jas kichꞌobꞌ chirij we ri: Kꞌo jun achi e kꞌo kebꞌ ralkꞌwaꞌl. Xubꞌij che ri nabꞌe: “Nukꞌojol, jateꞌ chakun pa ri wulew kamik.” ");
INSERT INTO quctt_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ri ala xubꞌij: “Man kawaj taj.” Kꞌa te riꞌ xukꞌex ukꞌuꞌx, xeꞌ pa ri chak. ");
INSERT INTO quctt_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kꞌa te riꞌ ri tataxel xubꞌij chik che ri jun ukꞌojol jacha ri xubꞌij che ri jun, ri ala xubꞌij: “Jeꞌ tat, kineꞌek.” Man xeꞌ ta kꞌut. ");
INSERT INTO quctt_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Jachin chike ri kebꞌ alabꞌom xubꞌan ri karaj ri utat kubꞌano? Ri nabꞌe, xecha ri winaq. Ri Jesús xubꞌij: Qas tzij kinbꞌij chiꞌwe ri e toqꞌil taq alkabal xuqujeꞌ ri ixoqibꞌ ri sibꞌalaj e kꞌi kachajil, e nabꞌejinaq chiꞌwach che ri kokem pa ri ajawarem rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jeriꞌ, rumal ri Juan xtaq loq iwukꞌ chukꞌutik ri ubꞌeal ri sukꞌal man xikoj ta kꞌut xuqujeꞌ man xikꞌex ta ikꞌuꞌx. Are kꞌu ri e toqꞌil taq alkabal xuqujeꞌ ri ixoqibꞌ ri sibꞌalaj e kꞌi kachajil xekojon che ri xubꞌij, pune xiwil ix waꞌ we ri, man xikꞌex ta wi ikꞌuꞌx. ");
INSERT INTO quctt_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Chitatabꞌej chi we jun kꞌambꞌejabꞌal noꞌj riꞌ: Kꞌo jun achi, ajchoqꞌe jun ulew, xutik nikꞌaj uvas. Xutzꞌapij, xukꞌot jun nimalaj jul, xuyak jun nimalaj ja jawjeꞌ kekꞌojiꞌ wi chajil taq rech ri tikoꞌn, xuya kanoq pa qajik chike nikꞌaj winaq, kꞌa te riꞌ xeꞌ chubꞌanik jun utaqkil pa jun tinimit chik. ");
INSERT INTO quctt_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Are xopan ri qꞌij rech yakoj, ri ajchoqꞌe ri ulew xuꞌtaq bꞌik ri e rajchakibꞌ chukꞌamik ri uchꞌekoj. ");
INSERT INTO quctt_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ri ajchakibꞌ xeꞌkichap ri e patanijelabꞌ. Xkichꞌay ri jun, xkikamisaj ri jun chik, ri urox xkibꞌan che abꞌaj. ");
INSERT INTO quctt_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kꞌa te riꞌ xuꞌtaq chi bꞌik sibꞌalaj e kꞌi patanijelabꞌ, choch ri xuꞌtaq bꞌik nabꞌe mul. Ri ajchakibꞌ xkibꞌan xuqujeꞌ kꞌax chike. ");
INSERT INTO quctt_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kꞌisbꞌal rech, xutaq bꞌik ri ukꞌojol, xuchomaj: Kakinimaj waꞌ we nukꞌojol xchaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ri ajchakibꞌ are xkil ri alkꞌwaꞌlaxel, xkibꞌij chibꞌil taq kibꞌ: “Are waꞌ ri kechꞌabꞌen kan ri ulew. Qakamisaj rech kaqechabꞌej kan uj ri ulew.” ");
INSERT INTO quctt_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Jeriꞌ xkichapo, xkesaj bꞌik pa ri ulew, kꞌa te riꞌ xkikamisaj. ");
INSERT INTO quctt_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ri Jesús xuta chike ri winaq: ¿Jas kibꞌij ix kubꞌan na chike ri ajchakibꞌ riꞌ? ");
INSERT INTO quctt_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ri winaq xkibꞌij: Kuꞌkamisaj na ri ajchakibꞌ, xuqujeꞌ kuya na kan ri rulew chike nikꞌaj ajchakibꞌ chik rech jeriꞌ kaya rech ri uwach ri ulew are kuriq ri qꞌij rech yakoj. ");
INSERT INTO quctt_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ri Jesús xubꞌij chike: ¿La man isikꞌim ri tzꞌibꞌatalik ri kubꞌij: Ri abꞌaj ri xketzelaj uwach ri ajchakibꞌ xuxik ri abꞌaj ri qas kꞌo kutayij. Waꞌ we riꞌ are uchak ri Ajawxel ri kubꞌan chaqe kujmayijanik? ");
INSERT INTO quctt_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Rumal riꞌ kinbꞌij chiꞌwe chi ri ajawarem kamaj na chiꞌwe, kaya na chike jun tinimit chik ri qas kawachinik. ");
INSERT INTO quctt_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ri katzaq puꞌwiꞌ ri abꞌaj, katukin na, are kꞌu we are ri abꞌaj katzaq puꞌwiꞌ ri winaq kasach na uwach ri winaq. ");
INSERT INTO quctt_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Are xkita ri e kinimaꞌqil ri e chꞌawenelabꞌ cho ri Dios xuqujeꞌ ri fariseos ronojel ri kꞌambꞌejabꞌal noꞌj ri xubꞌij ri Jesús, xkichꞌobꞌo chi aꞌreꞌ kebꞌixik. ");
INSERT INTO quctt_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Xkichapleꞌj kꞌu utzukuxik jas kakibꞌan chubꞌanik kꞌax che ri Jesús, kakixiꞌj kꞌu kibꞌ chikiwach ri e winaq rumal ketaꞌm chi ri Jesús are jun qꞌalajisal utzij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Junmul chik ri Jesús xuchapleꞌj tzijonem kukꞌ ri winaq xukoj kꞌambꞌejabꞌal noꞌj, xubꞌij: ");
INSERT INTO quctt_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Ri ajawarem rech ri kaj kajunumataj rukꞌ ri jun taqanel ri xubꞌan jun nimaqꞌij rumal ri kꞌulanem rech ri ukꞌojol. ");
INSERT INTO quctt_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Xuꞌtaq bꞌik ri e patanil taq rech chikisikꞌixik ri winaq ri e sikꞌital pa ri nimaqꞌij, we winaq riꞌ man xkaj taj xebꞌek pa ri nimaqꞌij. ");
INSERT INTO quctt_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kꞌa te riꞌ xuꞌtaq chi bꞌik nikꞌaj e rajchakibꞌ xubꞌij chike: Chibꞌij chike ri e qasikꞌim chi xutzir le wa. Xinkamisaj ri e nuwakax, ronojel xutzirik. Chixpetoq pa we nimaqꞌij riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ri winaq man xkilij ta ri sikꞌinik ri xya chike xane ri jun xeꞌ pa ri uchak pa ri rulew, ri jun chik xeꞌ pa ri ukꞌay. ");
INSERT INTO quctt_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ri nikꞌaj chik xeꞌkichap ri ajchakibꞌ, xkibꞌan kꞌax chike kꞌa te riꞌ xeꞌkikamisaj. ");
INSERT INTO quctt_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ri taqanel xyakataj royawal. Xuꞌtaq bꞌik ri e rajchꞌoꞌjabꞌ chikikamisaxik ri e kamisanelabꞌ xuqujeꞌ chuporoxik ri kitinimit. ");
INSERT INTO quctt_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kꞌa te riꞌ xubꞌij chike ri e rajchakibꞌ: “Xutzir ri wa rech nimaqꞌij, are kꞌu ri xeꞌnsikꞌij man taqal ta chike xeꞌnsikꞌij. ");
INSERT INTO quctt_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Jix pa taq ri uchꞌuꞌk ri bꞌe, jibꞌisikꞌij loq ri winaq ri kiꞌriqo.” ");
INSERT INTO quctt_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Jeriꞌ xebꞌe ri patanijelabꞌ pa taq ri bꞌe xebꞌe chikimulixik konojel ri winaq ri xeꞌkiriqo, e kꞌo utz taq winaq chike xuqujeꞌ e kꞌo itzel taq winaq, xaq jeriꞌ xnoj ri ja pa ri nimaqꞌij rech kꞌulanem. ");
INSERT INTO quctt_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Are xok bꞌik ri nim taqanel chikilik ri e sikꞌital pa ri nimaqꞌij, xril jun achi ri man ukojom taj ri atzꞌyaq rech nimaqꞌij rech kꞌulanem. ");
INSERT INTO quctt_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Xubꞌij che: “Ala, ¿jas che xatok la at waral man akojom taj awatzꞌyaq rech ri nimaqꞌij rech kꞌulanem?” Ri achi xaq xuta ri xbꞌix che. ");
INSERT INTO quctt_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ri nim taqanel xubꞌij chike ri e patanil re: “Chijatꞌij le uqꞌabꞌ xuqujeꞌ le raqan, chiwesaj bꞌik, chikꞌyaqa bꞌik pa ri qꞌequꞌmal, chilaꞌ kꞌo wi na oqꞌej xuqujeꞌ qutꞌutꞌem ware.” ");
INSERT INTO quctt_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jeriꞌ rumal sibꞌalaj e kꞌi e sikꞌitalik, xa kꞌu xaq e jujun e chaꞌtalik. ");
INSERT INTO quctt_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Xebꞌe kꞌu ri fariseos, xkitzukuj jas kibꞌan che ukojik jun kꞌaꞌmabꞌal che ri Jesús rukꞌ ri kubꞌij chike. ");
INSERT INTO quctt_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Xeꞌkitaq bꞌik e jujun kitijoxelabꞌ e kachiꞌl ri herodianos, xeꞌkibꞌij che ri Jesús: Ajtij, qetaꞌm chi lal jun achi tzꞌaqat, xuqujeꞌ saq kabꞌan la chukꞌutik ri ubꞌe ri Dios man are ta kabꞌan la ri kakibꞌij ri winaq, rumal cher man are ta kil la ri kekaꞌy ri winaq. ");
INSERT INTO quctt_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Bꞌij bꞌa la chaqe: ¿La taqalik kaqatoj ri alkabal che ri César ri taqanel pa Roma o man taqal taj? ");
INSERT INTO quctt_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ri Jesús retaꞌm ri itzel taq kichomanik rumal riꞌ xubꞌij chike: Kawach taq winaq, ¿jas che kiwaj kikoj kꞌaꞌmabꞌal pa ri nubꞌe? ");
INSERT INTO quctt_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Chikꞌutumpe jun pwaq tojbꞌal rech ri alkabal. Ri winaq xkikꞌut jun pwaq choch. ");
INSERT INTO quctt_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ri Jesús xuta chike: ¿Jachin ajchoqꞌe we palajaj xuqujeꞌ we tzꞌibꞌ riꞌ? ");
INSERT INTO quctt_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ri winaq xkibꞌij: Rech ri César. Ri Jesús xubꞌij chike: Chiya che ri César ri rech ri César, xuqujeꞌ chiya che ri Dios ri rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Are xkita ri xbꞌix chike: Sibꞌalaj xemayijanik, xkitzaq kanoq ri Jesús, xebꞌek. ");
INSERT INTO quctt_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Che ri qꞌij riꞌ ri Saduceos, ri kakibꞌij chi maj kꞌastajibꞌal wach, xeqet rukꞌ ri Jesús, xkita jun kꞌotbꞌal chiꞌ che, xkibꞌij: ");
INSERT INTO quctt_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ajtij, ri Moisés xukꞌut kanoq chiqawach, we kꞌo jun achi kakꞌuliꞌk, kꞌa te riꞌ kakamik maj kꞌu kan e ralkꞌwaꞌl rukꞌ ri rixoqil, ri rachalal ri achi ri xkamik kakꞌuliꞌk kan rukꞌ ri rixoqil ri rachalal, rech kekꞌojiꞌ rijaꞌl ri rachalal. ");
INSERT INTO quctt_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Chiqaxoꞌl uj xekꞌojiꞌ e wuqubꞌ alaxik. Ri nabꞌyal xkꞌuliꞌk, kꞌa te riꞌ xkamik, maj e ralkꞌwaꞌl xekanaj kanoq rukꞌ ri rixoqil, rumal riꞌ xkꞌuliꞌ kanoq ri rachalal rukꞌ ri rixoqil. ");
INSERT INTO quctt_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Jeꞌ xkꞌulmataj rukꞌ ri ukabꞌ, ri urox, kꞌa xtoꞌtaj rukꞌ ri wuqubꞌ alaxik. Konojel xekꞌuliꞌ rukꞌ ri ixoq, xekam kꞌu bꞌik maj jun xuya kanoq ralkꞌwaꞌl rukꞌ ri ixoq. ");
INSERT INTO quctt_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kꞌisbꞌal rech xkam bꞌik ri ixoq. ");
INSERT INTO quctt_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Are kuriq ri qꞌij rech kꞌastajibꞌal wach ¿jachin chike we wuqubꞌ achyabꞌ riꞌ rachajil we ixoq, rumal cher konojel xekꞌuliꞌ rukꞌ? ");
INSERT INTO quctt_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ri Jesús xubꞌij chike: Ri ix ix sachinaq rumal man iwetaꞌm taj ri tzꞌibꞌatalik xuqujeꞌ ri ukwinem ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Pa ri kꞌastajibꞌal wach man kekꞌuliꞌ taj chi ri winaq, xuqujeꞌ man keya ta xuqujeꞌ pa kꞌulanem, xane jer kuꞌx angelibꞌ ri e kꞌo pa ri kaj. ");
INSERT INTO quctt_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Are kꞌu ri kꞌastajibꞌal wach ke ri kaminaqibꞌ, ¿la man isikꞌim ri xubꞌij ri Dios chiꞌwe ojer? ");
INSERT INTO quctt_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","In riꞌ, ri in uDios ri Abraham, ri Isaac, xuqujeꞌ ri Jacob. Ri Dios man kiDios taj kaminaqibꞌ xane kiDios e kꞌaslik taq winaq. ");
INSERT INTO quctt_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Are xkita ri winaq ri xubꞌij ri Jesús, xemayijanik che ri ukꞌutuꞌn. ");
INSERT INTO quctt_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ri fariseos are xkita ri xubꞌij ri Jesús chike ri e saduceos, xkimulij kibꞌ rech kakikoj chi jun kꞌaꞌmabꞌal che ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Jun chike ri fariseos ri qas retaꞌm ri taqanik xubꞌan jun kꞌotbꞌal chiꞌ che ri Jesús, rech kukoj jun kꞌaꞌmabꞌal che xubꞌij: ");
INSERT INTO quctt_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ajtij, ¿pa ri utaqanik ri Moisés, jachin chike ri taqanik ri sibꞌalaj nim uqꞌij? ");
INSERT INTO quctt_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ri Jesús xubꞌij che: Chaloqꞌaj ri Ajawxel ri aDios rukꞌ ronojel awanimaꞌ, rukꞌ ronojel akꞌuꞌx, xuqujeꞌ rukꞌ ronojel achomanik. ");
INSERT INTO quctt_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Are waꞌ ri nabꞌe taqanik xuqujeꞌ nim uqꞌij chikiwach ronojel ri nikꞌaj chik. ");
INSERT INTO quctt_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ri ukabꞌ taqanik xaq raj junam rukꞌ we nabꞌe: Chaloqꞌaj ri ajil tzꞌaqat, jacha ri kabꞌan chuloqꞌaxik awibꞌ at. ");
INSERT INTO quctt_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Pa ukobꞌchal we taqanik riꞌ kꞌo wi ronojel ri kubꞌij ri taqanik xuqujeꞌ ronojel ri kitzijom loq ri e qꞌalajisal taq utzij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ri fariseos kimulim kibꞌ are xuta ri Jesús chike: ");
INSERT INTO quctt_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","¿Jas kichomaj ix chirij ri Cristo? ¿Ralkꞌwaꞌl jachinaq? Ri fariseos xkibꞌij che: Ralkꞌwaꞌl ri David. ");
INSERT INTO quctt_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","¿Jas kꞌu che ri David nojinaq che ri Uxlabꞌixel xubꞌij Ajawxel che? Are xubꞌij: ");
INSERT INTO quctt_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Xubꞌij ri Ajawxel che ri wajaw: chattꞌuyul pa ri nuwiqiqꞌabꞌ kꞌa keꞌnya na konojel ri akꞌulel pa awaqan. ");
INSERT INTO quctt_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ri David we kubꞌij “wajaw” che ri Mesías ¿jas ta kꞌu che riꞌ ukꞌojol? ");
INSERT INTO quctt_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Xa ta ne jun xkwinik xutzalij uwach ri xubꞌij ri Jesús, xa ta ne jun tzij xkibꞌij che, tzi che ri qꞌij riꞌ maj chi jun karaj kubꞌan kꞌotbꞌal chiꞌ che ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Are xbꞌantaj we riꞌ, ri Jesús xubꞌij chike ri winaq xuqujeꞌ ri utijoxelabꞌ: ");
INSERT INTO quctt_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Rajawaxik chi ri aꞌjtijabꞌ rech ri taqanik xuqujeꞌ ri fariseos kakiya uchꞌobꞌik chiꞌwe jas kubꞌij ri taqanik rech ri Moisés. ");
INSERT INTO quctt_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Rajawaxik kinimaj xuqujeꞌ kibꞌano ronojel ri kakibꞌij chiꞌwe. Are makibꞌan taj ri kakibꞌan aꞌreꞌ, rumal man kakibꞌan taj ri kakitzijoj. ");
INSERT INTO quctt_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Kakiya nimaꞌq taq eqaꞌn cho kachaq nikꞌaj chik, man kakaj ta kꞌu aꞌreꞌ kakisalabꞌaj rukꞌ jun uwiꞌ kiqꞌabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Are kakaj kekaꞌyex kumal ri winaq, rumal cher kakikoj ri nimaꞌq taq filacterias xuqujeꞌ kakiwiqiqej ri katzꞌyaq. ");
INSERT INTO quctt_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kekam xuqujeꞌ che ri kꞌolibꞌal ri nim uqꞌij xuqujeꞌ ri nabꞌe taq tem pa taq ri Sinagoga. ");
INSERT INTO quctt_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Are kakaj kaya rutzil kiwach pa taq ri kꞌayibꞌal, utz kakito kabꞌix ajtij, chike. ");
INSERT INTO quctt_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Man kiya ta kꞌu bꞌe kabꞌix ajtij chiꞌwe ix, rumal xa jun iwajtij kꞌolik, iwonojel iwachalal iwibꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Xuqujeꞌ mibꞌij itat che jun winaq chik ajuwachulew, rumal xa jun iTat ix kꞌolik, are ri kꞌo pa ri kaj. ");
INSERT INTO quctt_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Miya bꞌe xuqujeꞌ kabꞌix ajtij chiꞌwe, rumal xa jun iwajtij kꞌolik, are ri Cristo. ");
INSERT INTO quctt_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ri sibꞌalaj nim uqꞌij chiꞌxoꞌl ix, kux na patanijel ke nikꞌaj chik. ");
INSERT INTO quctt_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Jeriꞌ rumal cher ri kunimarisaj ribꞌ, kanitzꞌarisax na, are kꞌu ri kunitzꞌarisaj ribꞌ, kanimarisax na uqꞌij. ");
INSERT INTO quctt_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","¡Kꞌax iwe aꞌjtijabꞌ rech ri taqanik xuqujeꞌ fariseos, ix kawach! Kitzꞌapij ri kaj chikiwach nikꞌaj winaq chik, man kixok ta ix, xuqujeꞌ man kiya ta bꞌe chike ri kakaj koꞌkik. ");
INSERT INTO quctt_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","/¡Kꞌax iwe fariseos xuqujeꞌ aꞌjtijabꞌ rech ri taqanik! Kimaj ri kachoch ri malkaꞌnibꞌ, xuqujeꞌ kijaluj chi kibꞌan chꞌawem cho ri Dios, kibꞌan tuqutaq taq ichꞌawem rech kixkil ri winaq. Rumal kꞌu waꞌ kꞌax na kabꞌan chuqꞌatik tzij pa iwiꞌ./ ");
INSERT INTO quctt_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡Kꞌax iwe aꞌjtijabꞌ rech ri taqanik, xuqujeꞌ ri ix fariseos, ix kawach! Kiqꞌaxaj tinimit xuqujeꞌ cho chuchꞌekik jun tereneꞌl iwe, are kixkwin chuchꞌekik ri tereneꞌl iwe riꞌ, tajin kibꞌan che chi kux kebꞌ mul chiꞌwech ix taqal che keꞌ pa ri tyoꞌnel qꞌaqꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡Kꞌax iwe moy taq kꞌamal bꞌe! We kꞌo jun kunaꞌtaj jun jastaq pa ri ubꞌiꞌ ri Templo, maj kel riꞌ che, we kꞌu kunaꞌtaj jun jastaq pa ri ubꞌiꞌ ri qꞌana pwaq ri kꞌo pa ri Templo, kajatꞌitaj kan riꞌ rukꞌ ri utzij. ");
INSERT INTO quctt_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Moy taq winaq, maj iwetaꞌmabꞌal! ¿Jachin nim uqꞌij, la are ri qꞌana pwaq, o are ri Templo ri kutyoxirisaj ri qꞌana pwaq? ");
INSERT INTO quctt_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ix xuqujeꞌ kibꞌij: “We kꞌo jun winaq kubꞌij jun jastaq pa ubꞌiꞌ ri tzujbꞌal sipanik, maj kel riꞌ, we kꞌu kꞌo jun kubꞌij jun jastaq pa ubꞌiꞌ ri sipanik ri kuya choch ri tzujbꞌal sipanik, kajatꞌitaj na riꞌ rukꞌ ri utzij.” ");
INSERT INTO quctt_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Ix moy! ¿Jachin nim uqꞌij, ri sipanik o are ri tzujbꞌal sipanik ri katyoxirisan ri sipanik? ");
INSERT INTO quctt_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Jeriꞌ xapachin ri kubꞌij jun jastaq pa ri ubꞌiꞌ ri tzujbꞌal sipanik, man xaq xwi ta kubꞌij pa ubꞌiꞌ ri tzujbꞌal, xane pa ubꞌiꞌ ronojel ri kꞌo puꞌwiꞌ ri tzujbꞌal sipanik. ");
INSERT INTO quctt_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ri winaq ri kubꞌij jun jastaq pa ri ubꞌiꞌ ri Templo, man xaq xwi ta kubꞌij pa ri ubꞌiꞌ ri Templo, xane tajin kubꞌij pa ubꞌiꞌ ri Dios, rumal cher are ri Dios kꞌo pa ri Templo. ");
INSERT INTO quctt_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ri kubꞌij jun jastaq pa ubꞌiꞌ ri kaj, tajin kubꞌij pa ubꞌiꞌ ri utꞌuyulibꞌal ri Dios, xuqujeꞌ pa ri ubꞌiꞌ ri Dios rumal cher Areꞌ tꞌuyul chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡Kꞌax iwe ix aꞌjtijabꞌ rech ri taqanik xuqujeꞌ fariseos, ix kawach! Kiya ri ulajujil ri menta, ri anis, xuqujeꞌ ri comino. Itzaqom kꞌu kanoq ri taqanik ri nim uqꞌij jetaq ri sukꞌal, ri bꞌanoj toqꞌobꞌ, ri utzilal. Choqꞌaqꞌ wi ubꞌanik waꞌ we nikꞌaj riꞌ jacha we nikꞌaj chik riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Moy taq kꞌamal taq bꞌe. Kichaꞌ na ri nitzꞌ us, kibꞌiqꞌ kꞌu bꞌik ri kamey. ");
INSERT INTO quctt_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Kꞌax iwe ix aꞌjtijabꞌ rech ri taqanik xuqujeꞌ fariseos, ix kawach! Kichꞌajchꞌobꞌej ri rij ri qumubꞌal xuqujeꞌ ri ipalaꞌt, are kꞌu ri upam nojinaq che elaqꞌ xuqujeꞌ etzelal. ");
INSERT INTO quctt_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Moy laj fariseo, nabꞌe chachꞌajchꞌobꞌej ri upam ri aqumubꞌal xuqujeꞌ ri apalaꞌt, jeriꞌ kachꞌajchꞌojir riꞌ ri upam xuqujeꞌ ri rij. ");
INSERT INTO quctt_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡Kꞌax iwe ix aꞌjtijabꞌ rech ri taqanik xuqujeꞌ fariseos, ix kawach! Jer ix kꞌo muqbꞌal taq kaminaqibꞌ, saq iwij. Jeꞌl kakaꞌy ri iwij, ri ipam nojinaq che qꞌayinaq taq kibꞌaqil kaminaqibꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ix sukꞌ kixkaꞌy chiꞌwij, pa iwanimaꞌ ixnojinaq che kawachil xuqujeꞌ etzelal. ");
INSERT INTO quctt_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡Kꞌax iwe ix aꞌjtijabꞌ rech ri taqanik xuqujeꞌ fariseos, ix kawach! Kiyak tzꞌaq naꞌtabꞌal ke ri e qꞌalajisal taq utzij ri Dios, xuqujeꞌ kiwiqiqej ri tzꞌibꞌatal wi ri kibꞌiꞌ ri e sukꞌ taq winaq. ");
INSERT INTO quctt_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Xuqujeꞌ kibꞌij we ta uj kꞌo uj che ri qꞌij ri xekꞌojiꞌ ri e qatat qanan, riꞌ man uj jun ta chikikamisaxik ri e qꞌalajisal taq utzij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ix kachiꞌl kꞌut ri winaq riꞌ rumal kibꞌij chi ix kijaꞌl ri winaq ri xekamisan ri e qꞌalajisal taq utzij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Xa junmul chitzꞌaqatisaj ri xkibꞌan ri itat inan ojer! ");
INSERT INTO quctt_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Ix kumatz, ix kalkꞌwaꞌl taq kumatz! ¿Jachin katoꞌw iwiꞌ rech man kixeꞌ taj pa ri qꞌaqꞌ? ");
INSERT INTO quctt_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Rumal riꞌ keꞌntaq na loq qꞌalajisal taq utzij ri Dios, achyabꞌ ri kꞌo ketaꞌmabꞌal xuqujeꞌ aꞌjtijabꞌ. E kꞌo kiꞌkamisaj na chike e nikꞌaj chik kiꞌrip na, e nikꞌaj chik kerapux na pa taq ri Sinagoga, xuqujeꞌ koꞌqotax na pa taq ri tinimit. ");
INSERT INTO quctt_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Jeriꞌ ix kixux na aꞌjmakibꞌ rumal cher kikamisaxik winaq ri maj kimak, waꞌ xchapleꞌtaj loq rukꞌ ri ukamikal ri Abel, xtoqꞌiꞌ rukꞌ ri ukamikal ri Zacarías ukꞌojol ri Berequías, ri xikamisaj pa ri Templo chuxoꞌl ri Tyoxalaj kꞌolibꞌal xuqujeꞌ ri tzujbꞌal rech ri tzujbꞌal sipanik. ");
INSERT INTO quctt_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Qas tzij kinbꞌij chiꞌwe chi ix kixtojow na ri kꞌaxal ri xkibꞌan kanoq ri itat inan. ");
INSERT INTO quctt_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","¡Winaq aꞌj Jerusalén, winaq aꞌj Jerusalén, ix ri kiꞌkamisaj ri e qꞌalajisal taq utzij ri Dios, xuqujeꞌ kibꞌan che abꞌaj ri winaq ri ketaq loq iwukꞌ! Sibꞌalaj kꞌi mul xwaj xeꞌnmulij riꞌ iwalkꞌwaꞌl jetaq kubꞌan jun atiꞌt akꞌ are kuꞌmulij ri ral pa ri uxikꞌ, man xawaj ta kꞌut. ");
INSERT INTO quctt_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Rumal riꞌ maj jun winaq kakanaj na kanoq pa ri iwachoch. ");
INSERT INTO quctt_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Xuqujeꞌ kinbꞌij chiꞌwe chi man kiwil ta chi na nuwach kꞌa kuriq na ri qꞌij are kibꞌij: Tewchiꞌtal ubꞌiꞌ ri petinaq pa ri ubꞌiꞌ ri Ajawxel. ");
INSERT INTO quctt_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ri Jesús xel loq pa ri Templo, are tajin kabꞌinik, ri utijoxelabꞌ xeqet rukꞌ xkikꞌut choch ronojel ri ja ri wokowinaq ri Templo. ");
INSERT INTO quctt_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ri Jesús xubꞌij chike: ¿La kiwil ronojel we riꞌ? Qas tzij kinbꞌij chiꞌwe, maj jun abꞌaj kakanaj kanoq puꞌwiꞌ jun chik, jeriꞌ rumal cher ronojel katukix na. ");
INSERT INTO quctt_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Are xeꞌ ri qꞌij, ri Jesús xtꞌuyiꞌ puꞌwiꞌ ri juyubꞌ Olivos, ri utijoxelabꞌ xoꞌpan rukꞌ xaq pa utukel xkita che: ¿Jampaꞌ kakꞌulmataj we riꞌ xuqujeꞌ jas retal ri petibꞌal la, xuqujeꞌ jas retal ri kꞌisbꞌal rech ri uwachulew? ");
INSERT INTO quctt_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ri Jesús xubꞌij chike: Chichajij iwibꞌ rech maj jachin kixsubꞌuwik. ");
INSERT INTO quctt_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","E kꞌi kepe na kakikoj ri nubꞌiꞌ kakibꞌij chi aꞌreꞌ e Cristo, sibꞌalaj e kꞌi winaq keꞌkisubꞌ na. ");
INSERT INTO quctt_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ri ix kita na ri chꞌoꞌj ri kabꞌanik xuqujeꞌ ri chꞌoꞌj ri kachomax ubꞌanik, man kixiꞌj ta kꞌu iwibꞌ, rumal cher choqꞌaqꞌ wi chi kakꞌulmataj we riꞌ, xa kꞌu man are ta waꞌ ri kꞌisbꞌal rech ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kachꞌoꞌjin na jun tinimit rukꞌ jun tinimit chik, xuqujeꞌ jun wokaj tinimit rukꞌ jun wokaj tinimit chik. Kape na kabꞌraqan xuqujeꞌ numik pa ronojel ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Are waꞌ ri majibꞌal rech ri qꞌoxom. ");
INSERT INTO quctt_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Kixkijach na rech kabꞌan kꞌax chiꞌwe, xuqujeꞌ rech kixkamisaxik, konojel ri kaketzelaj na iwach ri tinimit, xa rumal we in. ");
INSERT INTO quctt_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Pa taq ri qꞌij riꞌ e kꞌi kakitzaq na kanoq ri kojonik, e kꞌo chi nikꞌaj keꞌkikꞌayij na ri e kachiꞌl, xuqujeꞌ kaketzelaj na kiwach. ");
INSERT INTO quctt_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","E kꞌi kakijaluj na chi e qꞌalajisal taq utzij ri Dios, kekwin kꞌu na keꞌkiqꞌol nikꞌaj winaq chik. ");
INSERT INTO quctt_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Sibꞌalaj nim ri etzelal kabꞌan na rumal riꞌ e kꞌi na man keloqꞌan ta chik. ");
INSERT INTO quctt_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Are kꞌu ri ko kakꞌojiꞌk, kakolotaj na pa ri kꞌisbꞌal qꞌij. ");
INSERT INTO quctt_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Katzijox na we utz laj taq tzij riꞌ pa taq ronojel ri tinimit rech ri uwachulew, kꞌa te riꞌ kape ri kꞌisbꞌal rech ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Xaq jeriꞌ are kiwil ri xaꞌwibꞌal taq jastaq ri kakꞌulmataj pa ri Tyoxalaj kꞌolibꞌal, ri xutzijoj loq ri qꞌalajisal utzij ri Dios, Daniel, are xubꞌij: (Ri kusikꞌij ri uwach ri wuj chuchꞌobꞌo rij we riꞌ). ");
INSERT INTO quctt_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ri winaq ri keꞌl pa ri tinimit Judea chaꞌnimaj bꞌik chebꞌoꞌj pa taq ri juyubꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ri kꞌo pa ri ja ri kꞌo puꞌwiꞌ ri rachoch, maqaj chi na bꞌi chukꞌamik jun jastaq pa ri rachoch. ");
INSERT INTO quctt_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ri tajin kachakun cho ri saq, matzalij chukꞌamik ri ratzꞌyaq. ");
INSERT INTO quctt_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Cher ri qꞌij riꞌ sibꞌalaj kꞌax kakiriq na riꞌ yawabꞌ taq ixoqibꞌ xuqujeꞌ ri keꞌkitubꞌisaj kal. ");
INSERT INTO quctt_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Chibꞌana chꞌawem rech ri iwelik bꞌik waral man kakꞌulmataj taj pa taq ri qꞌalaj, xuqujeꞌ man paqꞌij taj rech uxlanem. ");
INSERT INTO quctt_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Jeriꞌ rumal cher kape na jun nimalaj kꞌaxkꞌolal ri man kꞌulmatajinaq ta wi pa ri uchapleꞌtajibꞌal ri uwachulew, xuqujeꞌ man kꞌulmatajinaq ta wi pa taq we qꞌij kamik, maj chi jun kꞌulmatajik kajunumataj rukꞌ ri kape na. ");
INSERT INTO quctt_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Maj jun winaq riꞌ kakꞌasiꞌk che riꞌ we ta mat kakꞌopix ri qꞌij riꞌ, xa kꞌu kumal ke ri e chaꞌtalik kakꞌopix na. ");
INSERT INTO quctt_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","We kꞌo jun kubꞌij chiꞌwe: “Chiwilampeꞌ, chi riꞌ kꞌo wi ri Cristo,” o “je laꞌ kꞌo wi,” man kikoj taj re. ");
INSERT INTO quctt_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Jeriꞌ rumal kepe na e kꞌi kakijaluj chi aꞌreꞌ e Cristo xuqujeꞌ kakijaluj chi aꞌreꞌ e qꞌalajisal taq utzij ri Dios, kakibꞌan na nimaꞌq taq etal xuqujeꞌ mayijabꞌal taq jastaq rech keꞌkisubꞌ ri winaq pune are ri e chaꞌtalik. ");
INSERT INTO quctt_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Qas chichꞌobꞌoꞌ chi nubꞌim chik we jastaq riꞌ chiꞌwe, pune majaꞌ kakꞌulmatajik. ");
INSERT INTO quctt_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Rumal riꞌ, we kabꞌix chiꞌwe: “Chiwilampeꞌ, kꞌo pa ri leꞌaj jawjeꞌ ri maj wi ja,” o wine kabꞌix chiꞌwe “chiwilampeꞌ, kꞌo pa we jun ja riꞌ.” Man kiꞌwila taj xuqujeꞌ man kikoj taj. ");
INSERT INTO quctt_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Jeriꞌ rumal jetaq ri kubꞌan ri kayapaꞌ ri karepqꞌun chirelibꞌal qꞌij kaqaj pa ri uqajibꞌal qꞌij, jeriꞌ kubꞌan na ri upetibꞌal, ri uKꞌojol ri Achi. ");
INSERT INTO quctt_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Jawjeꞌ kꞌo wi ri kaminaq chilaꞌ kerapap wi na ri kꞌuch, are waꞌ kakꞌutuwik chi are kꞌisbꞌal rech ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Are kikꞌow ri nimalaj kꞌaxkꞌolal, kachup na ri qꞌij, man kakaꞌy ta chi ri ikꞌ, ketzaq na loq ri chꞌumil xuqujeꞌ kachup na ronojel ri kꞌo cho ri kaj. ");
INSERT INTO quctt_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ri retal ri uKꞌojol ri Achi kaqꞌalajin na cho ri kaj, kakꞌaxir kꞌu na kanimaꞌ konojel ri winaq ri e kꞌo cho ri uwachulew. Kakil na ri uKꞌojol ri Achi kape rukꞌ kwinem xuqujeꞌ juluwem pa ri sutzꞌ ri kꞌo cho ri kaj. ");
INSERT INTO quctt_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kuꞌtaq kꞌu na bꞌik ri rangelibꞌ pa ronojel ri uwachulew rech rukꞌ ri roqꞌibꞌal ri suꞌ keꞌkimulij na konojel ri e chaꞌtalik pa ronojel ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Chikꞌama jun inoꞌj chirij ri kubꞌan ri higuera: Are karexar ri uqꞌabꞌ xuqujeꞌ kakꞌiy la ri uxaq, iwetaꞌm chi xqebꞌ loq ri qꞌalaj. ");
INSERT INTO quctt_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Je xuqujeꞌ are kiwil we jastaq riꞌ, chiwetaꞌmaj chi naqajin loq ri upetibꞌal ri ajawarem rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Qas tzij kinbꞌij chiꞌwe chi majaꞌ kixkamik are, kakꞌulmataj ronojel we jastaq riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kasach na uwach ri kaj xuqujeꞌ ri uwachulew, are kꞌu ri nutzij man kasach ta wi uwach. ");
INSERT INTO quctt_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Are kꞌu ri qꞌij xuqujeꞌ ri qꞌotaj, maj jun etaꞌmaninaq man ne ketaꞌm taj ri angelibꞌ xuqujeꞌ ri uKꞌojol ri Achi, xane xwi ri Tataxel etaꞌmaninaq we jastaq riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ri upetibꞌal ri uKꞌojol ri Achi kajunumataj rukꞌ ri xkꞌulmataj rukꞌ ri Noé. ");
INSERT INTO quctt_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Rumal cher are majaꞌ kuriq ri qꞌij rech ri nimalaj jabꞌ ri winaq kewaꞌik, kequmunik, kekꞌuliꞌ xuqujeꞌ kakiya kibꞌ pa taq kꞌulanem kꞌa xopan na ri qꞌij are xok ri pa ri arca. ");
INSERT INTO quctt_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Man xketaꞌmaj ta wi ri kakꞌulmatajik kꞌa xopan na ri qꞌij ri xqaj ri nimalaj jabꞌ xukꞌam bꞌik konojel ri winaq. Jeriꞌ kakꞌulmataj na pa ri upetibꞌal ri uKꞌojol ri Achi. ");
INSERT INTO quctt_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kechakun na kebꞌ achyabꞌ cho ri saq, ri jun kakꞌam na bꞌik, ri jun katzaq na kanoq. ");
INSERT INTO quctt_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","E kebꞌ ixoqibꞌ kekeꞌn na junam, ri jun kakꞌam na bꞌik, ri jun chik katzaq na kanoq. ");
INSERT INTO quctt_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Rumal bꞌa riꞌ, chisukꞌumaj iwibꞌ, rumal man iwetaꞌm taj jampaꞌ ri upetibꞌal ri Ajawxel. ");
INSERT INTO quctt_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Chichomaj we riꞌ: We ri ajchoqꞌe ri ja retaꞌm jas qꞌotaj kok ri elaqꞌom pa ri ja, kakꞌaskꞌat riꞌ rech man kuya ta bꞌe che ri elaqꞌom kok pa ri ja. ");
INSERT INTO quctt_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Rumal riꞌ rajawaxik kikowij, rumal cher ri uKꞌojol ri Achi kapetik are man iwayeꞌm ta apanoq. ");
INSERT INTO quctt_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ri ajchak ri sukꞌ ranimaꞌ, kꞌo retaꞌmabꞌal, are waꞌ ri yaꞌtal kan bꞌe che karil ronojel ri jastaq xuqujeꞌ kuya kiwa ri ajchakibꞌ pa ri qꞌotaj rech waꞌim. ");
INSERT INTO quctt_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Utz rech we kulriqitaj rumal ri rajaw tajin kubꞌan apanoq ri uchak. ");
INSERT INTO quctt_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Qas tzij kinbꞌij chiꞌwe chi ri patrón kukoj na ri patanijel riꞌ che chajil rech ronojel ri ujastaq. ");
INSERT INTO quctt_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Jas kakꞌulmataj riꞌ we ri ajchak kubꞌij pa ranimaꞌ: “Kabꞌeyetaj riꞌ ri wajaw,” ");
INSERT INTO quctt_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","kꞌa te riꞌ kuchapleꞌj kichꞌayik ri e rachiꞌl xuqujeꞌ kuchapleꞌj waꞌim xuqujeꞌ qꞌabꞌarik kukꞌ ri qꞌabꞌarelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Pa ri qꞌij ri man uchomam ta apanoq, pa ri qꞌotaj ri man uchomam ta apanoq, katzalij loq ri rajaw. ");
INSERT INTO quctt_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ri patrón kubꞌan na kꞌax che ri ajchak xuqujeꞌ kuqꞌat na tzij puꞌwiꞌ kukꞌ e kawach taq winaq. Chilaꞌ kꞌo wi na oqꞌej xuqujeꞌ qutꞌutꞌem ware. ");
INSERT INTO quctt_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ri ajawarem rech ri kaj kajunumataj kukꞌ ri e lajuj alitomabꞌ ri man e kꞌulan taj, xkikꞌam bꞌik ri kilampara, xebꞌe chukꞌulaxik ri jiꞌatz. ");
INSERT INTO quctt_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","E jobꞌ chike ri alitomabꞌ maj ketaꞌmabꞌal, ri e jobꞌ chik kꞌo ketaꞌmabꞌal. ");
INSERT INTO quctt_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ri alitomabꞌ ri maj ketaꞌmabꞌal xkikꞌam bꞌik ri kilampara, man nim ta kꞌut ri kaceite xkikꞌam bꞌik. ");
INSERT INTO quctt_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Xuqujeꞌ ri alitomabꞌ ri kꞌo ketaꞌmabꞌal xkikꞌam bꞌik ri kilampara rachiꞌl ri kaceite. ");
INSERT INTO quctt_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ri jiꞌatz xbꞌeyetaj bꞌik rumal riꞌ xewar konojel ri alitomabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nikꞌaj aqꞌabꞌ xtataj jun chꞌabꞌal kubꞌij: “¡Xpe le jiꞌatz, chixel loq chukꞌamawaꞌxik!” ");
INSERT INTO quctt_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Jeriꞌ konojel ri alitomabꞌ xekꞌastajik, xoꞌk chusukꞌumaxik ri kilamparas. ");
INSERT INTO quctt_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ri alitomabꞌ ri maj ketaꞌmabꞌal xkibꞌij chike ri alitomabꞌ ri kꞌo ketaꞌmabꞌal: “Chiya jubꞌiqꞌ qe ri iwaceite rech man kechup ta ri qalámparas.” ");
INSERT INTO quctt_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ri alitomabꞌ ri kꞌo ketaꞌmabꞌal xkibꞌij: “Man kaqaya taj, we kaqaya iwe man kubꞌan ta chilaꞌ chaqe uj, are utz we kiꞌloqꞌo iwe pa ri kꞌayibꞌal aceite.” ");
INSERT INTO quctt_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Are e bꞌenaq chuloqꞌik ri aceite, xopan ri jiꞌatz. Ri alitomabꞌ ri kayeꞌm apanoq xok rukꞌ pa ri nimaqꞌij rech kꞌulanem, kꞌa te riꞌ xtzꞌapiꞌk ri uchiꞌ ja. ");
INSERT INTO quctt_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kꞌa te riꞌ xuqujeꞌ ri nikꞌaj alitomabꞌ chik, xkibꞌij: “¡Ajawxel, Ajawxel, jaqa la ri uchiꞌ ja chiqawach!” ");
INSERT INTO quctt_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ri Ajawxel xubꞌij: “Man kinjaq taj, man wetaꞌm taj iwach.” ");
INSERT INTO quctt_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Rumal riꞌ chixkꞌasloq rumal man iwetaꞌm taj ri qꞌotaj xuqujeꞌ ri qꞌij are jewaꞌ kakꞌulmatajik. ");
INSERT INTO quctt_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ri ajawarem rech ri Dios kajunumataj rukꞌ jun achi, are xeꞌ pa ri utaqkil xuꞌsikꞌij ri e patanil rech xuchilibꞌej kanoq ri urajil chike. ");
INSERT INTO quctt_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Che ri jun xuya jobꞌ mil qꞌana pwaq, che ri jun chik xuya kebꞌ mil, che ri jun chik xuya jun mil, jaljoj xubꞌan chuyaꞌik ri pwaq chike rumal cher are xrilo ri ketaꞌmabꞌal chuchajixik, kꞌa te riꞌ xeꞌ pa ri utaqkil. ");
INSERT INTO quctt_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ri patanijel ri xukꞌamawaꞌj jobꞌ mil xchakun rukꞌ ri pwaq, xuchꞌek chi jun jobꞌ mil chirij. ");
INSERT INTO quctt_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Je xuqujeꞌ ri xukꞌamawaꞌj kebꞌ mil xuchꞌek chik jun kebꞌ mil chik chirij. ");
INSERT INTO quctt_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Are kꞌu ri achi ri xukꞌamawaꞌj jun mil xukꞌot jun jul pa ri ulew, kꞌa te riꞌ xrawaj kanoq ri urajil ri rajaw. ");
INSERT INTO quctt_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Are xikꞌow sibꞌalaj kꞌi qꞌij, ri patrón xtzalij loq, xuta ri kwenta chike ri e patanijel taq rech. ");
INSERT INTO quctt_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ri patanijel ri xukꞌamawaꞌj jobꞌ mil pwaq, xukꞌam chi bꞌik ri jun mil ri xuchꞌeko, xubꞌij che ri patrón, Ajawxel lal xya la kanoq jobꞌ mil pwaq chwe, chilampe la xinchꞌek chi lajuj mil chirij le xya la kanoq chwe. ");
INSERT INTO quctt_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ri upatrón xubꞌij che: Utz ri xabꞌano, utz laj ajchak, sukꞌ ri awanimaꞌ. Utz xabꞌano rukꞌ ri nitzꞌ ri xinya chawe rumal riꞌ kibꞌan chawe chi kachajij na nima taq jastaq. Chatan loq chatkiꞌkotoq rukꞌ ri awajaw. ");
INSERT INTO quctt_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Xopan xuqujeꞌ ri achi ri xukꞌamawaꞌj kebꞌ mil pwaq xubꞌij che ri patrón. Ajawxel lal xya la kanoq kebꞌ mil pwaq chwe, chilampe la xinchꞌek chi kebꞌ mil pwaq chirij le xya la kanoq chwe. ");
INSERT INTO quctt_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ri patrón xubꞌij che: “Utz ri xabꞌano, utz laj ajchak, sukꞌ awanimaꞌ, utz xabꞌano rukꞌ ri nitzꞌ ri xinya chawe, kinbꞌan na chi kabꞌan awe puꞌwiꞌ nim jastaq. Chatan loq, chatkiꞌkot pa ri kiꞌkotemal rech ri awajaw.” ");
INSERT INTO quctt_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Kꞌa te riꞌ xopan ri achi ri xukꞌamawaꞌj mil pwaq. Xubꞌij: “Ajawxel, in wetaꞌm chi sibꞌalaj ko ri animaꞌ la, are kaj la kabꞌan la yakoj cho ri ulew jawjeꞌ ri man xtikoꞌnij ta wi la, xuqujeꞌ are kaj la kakꞌamawaꞌj la uwach ri tikoꞌn jawjeꞌ ri man xtikoꞌnij ta wi la. ");
INSERT INTO quctt_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Rumal riꞌ xinxiꞌj wibꞌ, xinmuq ri rajil la pa ri ulew. Riꞌ xinkꞌam loq, are waꞌ ri rajil la.” ");
INSERT INTO quctt_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ri upatrón xubꞌij che: “At jun itzel ajchak, at saqꞌor. Xaq jeriꞌ awetaꞌm chi kinyakoꞌnijik jawjeꞌ ri man xintikoꞌnij ta wi, xuqujeꞌ kikꞌamawaꞌj we ri uwach ri tikoꞌn jawjeꞌ ri man xintikoꞌnij ta wi. ");
INSERT INTO quctt_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Are utz we ta xaya ri nurajil jawjeꞌ kayak wi ri pwaq rech kuchꞌek ral, rech are xintzalij loq xaya ta apanoq ri chꞌekoj chwe.” ");
INSERT INTO quctt_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ri patrón xubꞌij chike ri nikꞌaj ajchakibꞌ chik: “Chimaja ri jun mil pwaq che, chiya che ri kꞌo lajuj mil rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Jeriꞌ, rumal cher ri nim kꞌo rukꞌ kayaꞌtaj na nim che, rech sibꞌalaj nim kakꞌojiꞌ na rukꞌ. Are kꞌu ri maj kꞌo rukꞌ kamaj na che ri kꞌisbꞌal jastaq ri kꞌo rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","We itzel ajchak riꞌ, chiwesaj bꞌik, chikꞌyaqa bꞌik pa ri qꞌequꞌmal, jawjeꞌ kꞌo wi na oqꞌej xuqujeꞌ qutꞌutꞌem ware.” ");
INSERT INTO quctt_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ri uKꞌojol ri Achi are kape pa ri ujuluwem, rachiꞌl ri angelibꞌ, katꞌuyiꞌ na pa ri utem ri kajuluwik. ");
INSERT INTO quctt_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Konojel ri winaq rech ri uwachulew kakimulij na kibꞌ choch, ri uKꞌojol ri Achi kuꞌqꞌat na nikꞌaj chike ri nikꞌaj chik, jacha ri kubꞌan ri jun ajyuqꞌ kuꞌqꞌat ri chij chike ri e kꞌisikꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Kuꞌya na ri chij pa ri uwiqiqꞌabꞌ xuqujeꞌ ri kꞌisikꞌ pa ri umox. ");
INSERT INTO quctt_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ri Taqanel kubꞌij na chike ri e kꞌo pa ri uwiqiqꞌabꞌ: “Chixpetoq, ri ix ri ixutewechiꞌm ri nuTat, chikꞌamawaꞌj ri iwechabꞌal, are waꞌ ri ajawarem ri chiꞌtal loq chiꞌwe are majaꞌ katiktaj loq ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Jeriꞌ rumal are xinnumik, xiya nuwa, are xchaqiꞌj nuchiꞌ, xiya nujoron, are xinwaꞌkatik xiya kanoq nukꞌolibꞌal jawjeꞌ kinkanaj wi. ");
INSERT INTO quctt_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Are xajawataj watzꞌyaq, xiya watzꞌyaq, are xinyawajik, xinichajij, are xintzꞌapiꞌk pa cheꞌ xinisolij.” ");
INSERT INTO quctt_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ri sukꞌ taq winaq kakibꞌij na: “Ajawxel, ¿jampaꞌ xqaya wa la are xnum la? ¿Jampaꞌ xqaya joron la are xchaqiꞌj chiꞌ la? ");
INSERT INTO quctt_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Jampaꞌ xqaya kꞌolibꞌal la are xwaꞌkat la o jampaꞌ xqaya atzꞌyaq la are xajawataj che la? ");
INSERT INTO quctt_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Jampaꞌ xqasolij la are lal yawabꞌ o are xtzꞌapiꞌk la pa cheꞌ?” ");
INSERT INTO quctt_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ri Taqanel kubꞌij na chike: “Qas tzij kinbꞌij chiꞌwe, ronojel ri xibꞌano chike ri e wachalal pune are ri kꞌin laj nitzꞌ, chwe in xibꞌan wi.” ");
INSERT INTO quctt_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Kꞌa te riꞌ kubꞌij na chike ri e kꞌo pa ri umox: “Chixel wukꞌ itzel taq winaq, jix pa ri tyoꞌnel qꞌaqꞌ ri maj ukꞌisik, are riꞌ ukꞌolibꞌal ri Itzel xuqujeꞌ ri uꞌtaqoꞌn. ");
INSERT INTO quctt_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Jeriꞌ rumal cher man xiya ta nuwa are xinnumik, man xiya ta nujoron are xchaqiꞌj nuchiꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Are xinwaꞌkatik man xiya ta nukꞌolibꞌal jawjeꞌ kinkanaj wi, man xiya ta watzꞌyaq are xajawataj chwe, are xinyawajik xuqujeꞌ xintzꞌapiꞌk pa che man xinisolij taj.” ");
INSERT INTO quctt_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ri winaq riꞌ kakibꞌij na che: “Ajawxel, ¿jampaꞌ man xqatoꞌta la are xnum la, jampaꞌ xchaqiꞌj chiꞌ la, jampaꞌ xwaꞌkat la, jampaꞌ xajawataj atzꞌyaq la, jampaꞌ xyawaj la o xtzꞌapiꞌ la pa cheꞌ?” ");
INSERT INTO quctt_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ri Ajawxel kubꞌij na: “Qas tzij kinbꞌij ronojel ri man xibꞌan taj kukꞌ ri e wachalal pune aꞌreꞌ alaj taq e nitzꞌ, chwe in riꞌ xibꞌan wi. ");
INSERT INTO quctt_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ri itzel taq winaq kebꞌe na pa ri jun alik kꞌaxkꞌolal are kꞌu ri sukꞌ taq winaq kebꞌe na pa ri jun alik kꞌaslemal.” ");
INSERT INTO quctt_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Are xtoꞌtaj ri Jesús chubꞌixik ronojel we jastaq riꞌ, xubꞌij chike ri utijoxelabꞌ: ");
INSERT INTO quctt_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Iwetaꞌm chi xa kebꞌ qꞌij chik karaj kuriq ri nimaqꞌij Pascua, che ri qꞌij riꞌ ri uKꞌojol ri Achi kajach na pa kiqꞌabꞌ ri achyabꞌ rech karipik. ");
INSERT INTO quctt_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Are kꞌu ri e kꞌamal taq bꞌe kech ri chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq, ri aꞌjtijabꞌ rech ri taqanik, xuqujeꞌ ri e kꞌamal taq bꞌe pa ri tinimit xkimulij kibꞌ cho rachoch ri Caifás, kinimaꞌqil ri e chꞌawenelabꞌ cho ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Xkitzukuj jas jeꞌ kakibꞌan chuchapik ri Jesús rech jeriꞌ kakikamisaj. ");
INSERT INTO quctt_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Man kakaj ta kꞌut kakibꞌan ri kꞌax riꞌ pa ri nimaqꞌij rumal cher xkichomaj, xkibꞌij: Kakimulij kibꞌ laꞌ le winaq chaqij. ");
INSERT INTO quctt_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Are kꞌo ri Jesús pa ri tinimit Betania, cho rachoch ri Simón, ri chꞌaꞌk achi. ");
INSERT INTO quctt_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Xqebꞌ jun ixoq rukꞌ rukꞌaꞌm jun kꞌolibꞌal bꞌantal che alabastro nojinaq che kꞌokꞌalaj kunabꞌal paqal rajil. Xutix kꞌu puꞌ jolom ri Jesús are tꞌuyul puꞌwiꞌ ri mexa. ");
INSERT INTO quctt_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Are xkil ri tijoxelabꞌ ri xkꞌulmatajik, xeyojtajik. Xkibꞌij: ¿Jas che xaq xtix we kunabꞌal riꞌ? ");
INSERT INTO quctt_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Jas che man xkꞌayix ta we kunabꞌal riꞌ rech jeriꞌ kachꞌek nimalaj pwaq chirij kaya chike ri e mebꞌaibꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ri Jesús retaꞌm ri xkibꞌij: rumal riꞌ xubꞌij chike: ¿Jas che kibꞌij tzij che we ixoq riꞌ? Jun utz laj chak ri xubꞌan wukꞌ in. ");
INSERT INTO quctt_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ri e mebꞌa e kꞌo wi laꞌ chiꞌxoꞌl, man je ta kꞌu in. ");
INSERT INTO quctt_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","We kunabꞌal riꞌ xutix chwij naꞌtabꞌal rech chi kinmuqiꞌ na. ");
INSERT INTO quctt_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Qas tzij kinbꞌij chiꞌwe chi pa ronojel ri uwachulew jawjeꞌ katzijox wi na ri utz laj taq tzij, katzijox xuqujeꞌ na ri xubꞌan we ixoq riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ri Judas Iscariote, jun chike ri kabꞌlajuj tijoxelabꞌ, xeꞌ kukꞌ ri e kꞌamal taq kibꞌe ri e chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq. ");
INSERT INTO quctt_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ri Judas xubꞌij chike: ¿Janipa kiya chwe, we kinjach ri Jesús chiꞌwe? Ri chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq xkibꞌij che: Kaqaya juwinaq laluj saq pwaq chawe. ");
INSERT INTO quctt_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Che ri qꞌij riꞌ, ri Judas xuchapleꞌj utzukuxik ri qꞌotaj rech kujach ri Jesús chike. ");
INSERT INTO quctt_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pa ri nabꞌe qꞌij rech ri nimaqꞌij are katij ri kaxlan wa ri maj chꞌam rukꞌ ri tijoxelabꞌ xeqet rukꞌ ri Jesús xkibꞌij che: ¿Jawjeꞌ kaj wi la kaqabꞌan wi ri waꞌim rech Pascua? ");
INSERT INTO quctt_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ri Jesús xubꞌij chike: Jix pa ri tinimit cho rachoch ri jun achi chibꞌij che chi ri ajtij kubꞌij: “Naj ta chik in kꞌo waral. Kawaj kꞌut kinwikꞌowisaj ri nimaqꞌij rech pascua waral kukꞌ ri nutijoxelabꞌ.” ");
INSERT INTO quctt_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ri tijoxelabꞌ xkibꞌano jetaq ri xubꞌij ri Jesús chike, xkibꞌan apanoq ri wa rech ri nimaqꞌij Pascua. ");
INSERT INTO quctt_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Are xok aqꞌabꞌ, ri Jesús xtꞌuyiꞌk kukꞌ ri kabꞌlajuj utijoxelabꞌ puꞌwiꞌ ri mexa. ");
INSERT INTO quctt_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Are tajin kewaꞌik xubꞌij chike: Qas tzij kinbꞌij chiꞌwe, jun chiꞌwe kinukꞌayij na. ");
INSERT INTO quctt_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ri tijoxelabꞌ xebꞌisonik are xkita ri xbꞌix chike, xkichapleꞌj utatabꞌeloꞌxik che ri Jesús: ¿Teꞌq in riꞌ Ajawxel? ");
INSERT INTO quctt_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ri Jesús xubꞌij: Are kinkꞌayin na ri winaq ri kukꞌam uwa wukꞌ pa ri palaꞌt. ");
INSERT INTO quctt_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Qas tzij, ri ralkꞌwaꞌl riꞌ achi kakam na jetaq ri tzꞌibꞌatalik, kꞌax kꞌu rech ri winaq ri kakꞌayinik. Are katanik we ta mat xalaxik. ");
INSERT INTO quctt_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ri Judas ri kꞌayinel xubꞌij che ri Jesús: Ajtij, ¿teꞌq in riꞌ? Ri Jesús xubꞌij che: At xatbꞌinik. ");
INSERT INTO quctt_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Are tajin kewaꞌik, ri Jesús xukꞌam ri kaxlan wa, xutewechiꞌj kꞌa te riꞌ xupaꞌij, xuya chike ri utijoxelabꞌ xubꞌij: Chikꞌamawaꞌj, chitijaꞌ, are waꞌ ri nutyoꞌjal. ");
INSERT INTO quctt_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kꞌa te riꞌ xukꞌam ri qumubꞌal, xutyoxij che ri Dios kꞌa te riꞌ xutzuj chike xubꞌij: Chixqumunoq iwonojel. ");
INSERT INTO quctt_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Are waꞌ ri nukikꞌel rech ri kꞌakꞌ chꞌekom tzij, ri katixtobꞌ na che kikuyik kimak sibꞌalaj e kꞌi winaq. ");
INSERT INTO quctt_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Qas tzij kinbꞌij chiꞌwe chi man kinqumuj ta chi na we vino riꞌ kachapleꞌtaj bꞌik kamik kꞌa te kinqumuj chi riꞌ ri kꞌakꞌ vino pa ri ajawarem rech ri nuTat. ");
INSERT INTO quctt_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Are xetoꞌtaj chubꞌixoxik jun Salmo, xebꞌek puꞌwiꞌ ri juyubꞌ Olivos. ");
INSERT INTO quctt_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ri Jesús xubꞌij chike: Iwonojel kinitzaq na kanoq, jeriꞌ rumal tzꞌibꞌatalik: Kinbꞌan na kꞌax che ri ajyuqꞌ, ri chij kaꞌnimaj na bꞌik. ");
INSERT INTO quctt_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Are kinkꞌastajik, kinnabꞌej na chiꞌwech kineꞌ je laꞌ pa Galilea. ");
INSERT INTO quctt_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ri Pedro xubꞌij: Pune konojel kakitzaq la kanoq, in man je ta ri kinbꞌano. ");
INSERT INTO quctt_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ri Jesús xubꞌij che: Qas tzij kinbꞌij chawe, chaqꞌabꞌ kamik oxmul abꞌim chi man awetaꞌm ta nuwach are koqꞌ ri amaꞌ akꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ri Pedro xubꞌij che ri Jesús: Pune choqꞌaqꞌ kinkam ukꞌ la, man kinbꞌij ta kꞌu wi chi mat wetaꞌm wach la. Konojel ri tijoxelabꞌ je xuqujeꞌ xkibꞌij. ");
INSERT INTO quctt_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kꞌa te riꞌ xeꞌ ri Jesús, xukꞌam bꞌik ri utijoxelabꞌ, xeꞌ pa jun leꞌaj ubꞌiꞌnam Getsemaní, xubꞌij chike ri utijoxelabꞌ: Chixtꞌuyul kanoq waral keꞌnbꞌana na chꞌawem je laꞌ apanoq. ");
INSERT INTO quctt_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Xuꞌsikꞌij bꞌik ri Pedro rachiꞌl ri e kebꞌ ukꞌojol ri Zebedeo, kꞌa te riꞌ xuchapleꞌj bꞌisonem xuqujeꞌ xkꞌaxir ranimaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ri Jesús xubꞌij chike: Sibꞌalaj kaqꞌoxow ri wanimaꞌ jer kinnaꞌo chi kinkamik, chixkanaj kanoq waral, chixkꞌasloq wukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Xbꞌin chi na apanoq jubꞌiqꞌ, kꞌa te riꞌ xukiꞌk, xuya ri upalaj pa ri ulew, xubꞌan chꞌawem xubꞌij: Tat, kꞌo ta bꞌa ne wi, mat kinriq we kꞌax riꞌ, man in ta kꞌut kabꞌan we, xane are bꞌanoq ri kaj lal. ");
INSERT INTO quctt_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Are xtzalij loq jawjeꞌ e kꞌo wi kan ri utijoxelabꞌ tajin kewarik are xuluꞌriqaꞌ. Xubꞌij che ri Pedro: ¿Man xixkwin taj xixkꞌasiꞌk jun hora wukꞌ? ");
INSERT INTO quctt_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Chixkꞌasloq rech man kixtaqchiꞌx taj pa mak. Ri uxlabꞌal qas tzij kꞌolik xa kꞌu are ri tyoꞌjal man kꞌo taj uchuqꞌabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ri Jesús xtzalij chik junmul chubꞌanik chꞌawem, xubꞌij: Tat, we rajawaxik wi kinkamik, bꞌanoq ri kaj la. ");
INSERT INTO quctt_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Are xtzalij loq, junmul chik xuluꞌriqa ri utijoxelabꞌ tajin kewarik, rumal cher sibꞌalaj kꞌax kiwaram. ");
INSERT INTO quctt_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Xuꞌya kanoq kitukel, xtzalij chubꞌanik chꞌawem churox mul, pa ri uchꞌawem je xubꞌij jetaq ri xubꞌij nabꞌe. ");
INSERT INTO quctt_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Xtzalij chi loq junmul kukꞌ ri utijoxelabꞌ xubꞌij chike: Kꞌa tajin kixwarik, xuqujeꞌ kixuxlan ix. Chiwilampeꞌ, xopan ri qꞌotaj, ri uKꞌojol ri Achi kajach na pa kiqꞌabꞌ ri aꞌjmakibꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Chixwaꞌjiloq, ¡joꞌ! ¡Xul le kꞌayil we! ");
INSERT INTO quctt_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Tajin katzijon na ri Jesús are xopan ri Judas, jun chike ri e kabꞌlajuj tijoxelabꞌ. E rachiꞌl bꞌik sibꞌalaj e kꞌi winaq, ri e taqtal bꞌik kumal ri e kꞌamal taq kibꞌe ri e chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq, xuqujeꞌ ri e kꞌamal taq bꞌe rech ri tinimit, kukꞌaꞌm taq bꞌik sakꞌibꞌal xuqujeꞌ cheꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ri Judas ubꞌim chike ri winaq: Ri achi ri kintzꞌumaj are riꞌ, chichapa bꞌik. ");
INSERT INTO quctt_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Xqebꞌ kꞌu ri Judas rukꞌ ri Jesús, xuya rutzil uwach, xutzꞌumaj kꞌa te riꞌ xubꞌij: ¡Ajtij! Kꞌa te riꞌ xutzꞌumaj. ");
INSERT INTO quctt_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ri Jesús xubꞌij che: Ala, ¿jas rumal at petinaq? Kꞌa te riꞌ konojel ri winaq xeqet rukꞌ ri Jesús, xkichapo. ");
INSERT INTO quctt_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Are jeriꞌ xkꞌulmatajik, jun chike ri utijoxelabꞌ ri Jesús xukꞌam jun sakꞌibꞌal, xusakꞌij ri uxikin ri jun patanijel rech ri kinimaꞌqil ri chꞌawenelabꞌ cho ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ri Jesús xubꞌij che: Chayaka ri asakꞌibꞌal, rumal cher riꞌ rukꞌ sakꞌibꞌal kakamisanik rukꞌ sakꞌibꞌal kakamisax na. ");
INSERT INTO quctt_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Xa kꞌu pa akꞌuꞌx chi man kinkwin taj kinta tobꞌanik che ri nuTat, aninaq riꞌ kuya e kabꞌlajuj wokaj angelibꞌ chinutoꞌik? ");
INSERT INTO quctt_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","We kꞌu jeriꞌ kibꞌano, man kakꞌulmataj ta riꞌ ri tzꞌibꞌatalik ri kubꞌij chi jeriꞌ kakꞌulmataj na. ");
INSERT INTO quctt_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Kꞌa te riꞌ xubꞌij chike ri winaq: ¿La xa kꞌu in jun elaqꞌom rech rumal riꞌ kixpe chwij rukꞌ taq sakꞌibꞌal xuqujeꞌ cheꞌ? Ronojel qꞌij xintꞌuyiꞌk pa ri Templo xinya kꞌutuꞌn, man xinichap ta kꞌut. ");
INSERT INTO quctt_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Xkꞌulmataj kꞌu ronojel we jastaq riꞌ rech jeriꞌ kakꞌulmataj ronojel ri xkitzꞌibꞌaj loq ri e qꞌalajisal taq utzij ri Dios. Are kꞌu ri tijoxelabꞌ xaꞌnimaj bꞌik konojel, xkitzaq kanoq ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ri winaq xkikꞌam bꞌik ri Jesús choch ri Caifás kꞌamal kibꞌe ri chꞌawenelabꞌ, chilaꞌ kimulim wi kibꞌ konojel ri aꞌjtijabꞌ rech ri taqanik xuqujeꞌ ri e kꞌamal taq bꞌe. ");
INSERT INTO quctt_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Are kꞌu ri Pedro naj kꞌo wi apanoq che ri Jesús utereneꞌm bꞌik, xok bꞌik cho rachoch ri kinimaꞌqil ri chꞌawenelabꞌ cho ri Dios. Are xok bꞌik, xtꞌuyiꞌk kukꞌ ri ajchꞌoꞌjabꞌ chajinelabꞌ rech karilo jas ri kakꞌulmatajik. ");
INSERT INTO quctt_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ri e kinimaꞌqil ri chꞌawenelabꞌ cho ri Dios xuqujeꞌ ri e kꞌamal taq bꞌe rech ri tinimit xkitzukuj jun bꞌanoj tzij ri kuqꞌalajisaj chi ri Jesús ajmak rech jeriꞌ kakikamisaj. ");
INSERT INTO quctt_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Man xkiriq ta kꞌut umak, pune sibꞌalaj e kꞌi winaq xoꞌpanik xkibꞌan ri bꞌanoj tzij chirij. Kꞌisbꞌal rech xoꞌpan e kebꞌ, ");
INSERT INTO quctt_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","we kebꞌ achyabꞌ ri xkibꞌij: We achi riꞌ xubꞌij: “Ri in kinkwinik kintukij ri Templo rech ri Dios, kꞌa te riꞌ pa oxibꞌ qꞌij kinyak ukꞌaxel.” ");
INSERT INTO quctt_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ri kinimaꞌqil ri chꞌawenelabꞌ cho ri Dios, xtakꞌiꞌk xuta che ri Jesús: ¿La maj jas kabꞌij at? ¿Jas kel kubꞌij we jastaq we kakichaꞌ we winaq riꞌ chawe? ");
INSERT INTO quctt_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ri Jesús xa ta ne jun tzij xubꞌij. Ri kinimaꞌqil ri kꞌamal taq bꞌe xubꞌij: Pa ri ubꞌiꞌ ri kꞌaslik Dios kinta chawe: Chabꞌij chaqe we at ri at Cristo, uKꞌojol ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ri Jesús xubꞌij: Are laꞌ le xabꞌij. Chanim kinbꞌij chiꞌwe iwonojel, kachapleꞌtaj bꞌik chanim, kiwil na ri uKꞌojol ri Achi tꞌuyul pa ri uwiqiqꞌabꞌ ri kakwin chubꞌanik ronojel ri jastaq, xuqujeꞌ kape na pa ri sutzꞌ ri kꞌo pa ri kaj. ");
INSERT INTO quctt_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ri kinimaꞌqil ri chꞌawenelabꞌ cho ri Dios xutꞌoqopij ri ratzꞌyaq, xubꞌij: We achi riꞌ xubꞌij ri awas ubꞌixik cho ri Dios, man kaꞌjawataj ta chik e nikꞌaj qꞌalajisanelabꞌ chik. Qas ix xixtow rukꞌ ixikin ri xubꞌij. ");
INSERT INTO quctt_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Jas kichomaj kaqabꞌan che we achi riꞌ? Areꞌ xkibꞌij: Taqal che kakamik. ");
INSERT INTO quctt_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","E kꞌo jujun xkichubꞌaj ri upalaj ri Jesús kꞌa te riꞌ xkichꞌey rukꞌ tꞌoyom qꞌabꞌ. E nikꞌaj chik xkichꞌey chupalaj. ");
INSERT INTO quctt_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Kꞌa te riꞌ xkibꞌij che: Cristo, chariqampeꞌ jachin xatchꞌayowik. ");
INSERT INTO quctt_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Are kꞌu ri Pedro tꞌuyul apanoq cho ri ja. Jun aj ikꞌ xqebꞌ rukꞌ, xubꞌij che: At xuqujeꞌ at rachiꞌl ri Jesús aj Galilea. ");
INSERT INTO quctt_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ri Pedro chikiwach konojel xubꞌij: Man wetaꞌm taj jas ri tajin kabꞌij. ");
INSERT INTO quctt_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kꞌa te riꞌ xeꞌ chuchiꞌ ri uchiꞌ jaꞌ, xqebꞌ chi jun aj ikꞌ rukꞌ xubꞌij chike ri winaq ri e kꞌo chilaꞌ. We achi riꞌ rachiꞌl ri Jesús aj Nazaret. ");
INSERT INTO quctt_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ri Pedro junmul chik xubꞌij: Man wetaꞌm ta wi uwach le achi leꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Man naj taj ikꞌowinaq are xeqet ri winaq ri e kꞌo chilaꞌ rukꞌ ri Pedro, xkibꞌij che: At at kachiꞌl, qꞌalaj le katzijonik. ");
INSERT INTO quctt_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ri Pedro xuchapleꞌj ubꞌixik kꞌaxal chibꞌil ribꞌ xubꞌij: Qas karilomaj ri Dios, man wetaꞌm ta uwach le achi leꞌ. Qas pa ri qꞌotaj riꞌ xoqꞌ ri amaꞌ akꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Xnaꞌtaj kꞌu che ri Pedro ri xubꞌij ri Jesús che: Qas tzij kinbꞌij chawe, chaqꞌabꞌ kamik oxmul abꞌim chi man awetaꞌm ta nuwach are koqꞌ ri amaꞌ akꞌ. Ri Pedro xel bꞌik chilaꞌ xoqꞌik rukꞌ nimalaj bꞌis. ");
INSERT INTO quctt_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ri e kꞌamal taq kibꞌe ri chꞌawenelabꞌ cho ri Dios xuqujeꞌ ri e kꞌamal taq bꞌe rech ri tinimit sibꞌalaj aqꞌabꞌil xkichomaj ukamisaxik ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Xkiyut bꞌik, xkikꞌam bꞌik, xekijacha choch ri Pilato ri taqanel. ");
INSERT INTO quctt_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Are xril ri Judas ri xjachow ri Jesús, chi xqꞌat tzij puꞌwiꞌ ri Jesús rech kakamisaxik, xkꞌaxir ranimaꞌ rumal ri xubꞌano, xeꞌek xuꞌtzalij kanoq ri juwinaq laluj saq pwaq chike ri e kꞌamal taq kibꞌe ri chꞌawenelabꞌ cho ri Dios xuqujeꞌ ri e kꞌamal taq bꞌe rech ri tinimit. ");
INSERT INTO quctt_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ri Judas xubꞌij: Xinmakunik, xinjach ri jun winaq ri maj umak. Ri achyabꞌ xkibꞌij che: Maj qe uj laꞌ che. At laꞌ at etaꞌmaninaq. ");
INSERT INTO quctt_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ri Judas kꞌut xukꞌyaq kanoq ri pwaq pa ri Templo kꞌa te riꞌ xel bꞌik, xuꞌjitzꞌaj ribꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ri e kinimaꞌqil ri chꞌawenelabꞌ xkisikꞌ ri pwaq xkibꞌij: Ri taqanik man kuya ta bꞌe chaqe kaqayak we pwaq riꞌ pa ri kꞌolibꞌal rech pa ri Templo, rumal cher we pwaq riꞌ tojbꞌal rech kikꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Xaq jeriꞌ xkichomaj uloqꞌik jun ulew ubꞌiꞌ ukꞌolibꞌal ri bꞌanal bꞌoꞌj rukꞌ ri pwaq riꞌ, rech keꞌkimuq ri winaq ri man aꞌj pa ri tinimit taj. ");
INSERT INTO quctt_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Rumal riꞌ ri ulew ubꞌiꞌnam kꞌa pa taq ri qꞌij kamik Kikꞌ ulew. ");
INSERT INTO quctt_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Jeriꞌ xkꞌulmajik ri xubꞌij loq ri qꞌalajisal utzij ri Dios, Jeremías: Xkikꞌamawaꞌj ri winaq juwinaq lajuj saq pwaq jetaq ri xkichomaj loq ri winaq aꞌj Israel. ");
INSERT INTO quctt_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Rukꞌ riꞌ xkiloqꞌ ri ulew rech ri bꞌanal bꞌoꞌj, jewaꞌ xubꞌij ri Ajawxel chwe. ");
INSERT INTO quctt_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Are xopan ri Jesús choch ri Pilato, xuta che: ¿La at riꞌ ri at nim taqanel kech ri winaq aꞌj Israel? Ri Jesús xubꞌij che: Are laꞌ le xabꞌij. ");
INSERT INTO quctt_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Xa ta ne jun tzij xubꞌij ri Jesús are xtzujux kumal ri e kꞌamal taq kibꞌe ri e chꞌawenelabꞌ choch ri Dios e kachiꞌl ri e kꞌamal taq bꞌe rech ri tinimit. ");
INSERT INTO quctt_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ri Pilato xubꞌij che: ¿La man kata ri tajin kakibꞌij chawe? ");
INSERT INTO quctt_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ri Jesús xa ta ne jun tzij xubꞌij, xuqujeꞌ man xutzalij ta uwach ri xbꞌix che. Rumal riꞌ sibꞌalaj xmayijanik ri qꞌatal tzij. ");
INSERT INTO quctt_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pa ri nimaqꞌij, naqꞌatal che ri Pilato kutzoqopij jun winaq ri tzꞌapital pa cheꞌ, xapachin ri kakita ri winaq. ");
INSERT INTO quctt_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kꞌo kꞌu jun achi sibꞌalaj etaꞌmatal uwach ubꞌiꞌ Barrabás, tzꞌapital pa che. ");
INSERT INTO quctt_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ri Pilato xuta chike wi winaq: ¿Jachin kiwaj kintzoqopij, la are ri Jesús, ri kabꞌix Cristo che o are ri Barrabás? ");
INSERT INTO quctt_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ri Pilato retaꞌm chi ri e kꞌamal taq bꞌe rumal koyawal xkijach ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Are tꞌuyul ri Pilato pa ri utem rech qꞌatbꞌal tzij, ri rixoqil xutaq ubꞌixik che: Maj jas kabꞌan che ri sukꞌ achi riꞌ, rumal rech xinriq kꞌax pa ri nuwaram. ");
INSERT INTO quctt_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ri kinimaꞌqil ri chꞌawenelabꞌ choch ri Dios pa kiwiꞌ ri winaq e kachiꞌl ri e kꞌamal ta bꞌe kech ri tinimit xeꞌkimenkꞌetij ri winaq rech are kakita katzoqopix ri Barrabás. Are kꞌu ri Jesús kamisaxoq. ");
INSERT INTO quctt_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ri Pilato xuta chike ri winaq: ¿Jachin chike we kebꞌ achyabꞌ riꞌ kiwaj kintzoqopij? Ri winaq xkibꞌij: Are ri Barrabás. ");
INSERT INTO quctt_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ri Pilato xubꞌij: ¿Jas kꞌu kinbꞌan che le Jesús, ri kabꞌix Cristo che? Konojel ri winaq xkibꞌij: ¡Ripoq! ");
INSERT INTO quctt_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ri Pilato xubꞌij: ¿Jas rumal? ¿Jas kꞌax ubꞌanom? Konojel ri winaq rukꞌ chuqꞌabꞌ xkibꞌij: ¡Ripoq! ");
INSERT INTO quctt_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Are xril ri Pilato chi maj kubꞌij kikꞌuꞌx ri winaq chutzoqopixik ri Jesús, xane xa tajin kechꞌuꞌjarik, xtaqanik rech kakꞌam loq ujaꞌ, xuchꞌaj kꞌu uqꞌabꞌ chikiwach konojel ri winaq, kꞌa te riꞌ xubꞌij: Man numak ta in we kakam we achi riꞌ, imak ix laꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ri winaq xkibꞌij: Uj, xuqujeꞌ ri e qijaꞌl uj aꞌjmakibꞌ che ri ukamikal we achi riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ri Pilato xutzoqopij ri Barrabás xuqujeꞌ xtaqan chuchꞌayik ri Jesús, kꞌa te riꞌ xujach bꞌik chike ri winaq rech karipik. ");
INSERT INTO quctt_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ri e rajchꞌoꞌjabꞌ ri Pilato xkikꞌam bꞌik ri Jesús cho ri nimalaj ja qꞌatbꞌal tzij kꞌa te riꞌ xkimulij kibꞌ chirij. ");
INSERT INTO quctt_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Xkesaj ri ratzꞌyaq kꞌa te riꞌ xkikoj jun moraꞌt manta chirij. ");
INSERT INTO quctt_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Xkikem jun kꞌix korona, xkikoj pa ujolom, kꞌa te riꞌ xkiya jun aj pa ri uqꞌabꞌ, xkichapleꞌj uyoqꞌik, xexukiꞌk choch xkibꞌij: Nim aqꞌij taqanel kech ri winaq ri aꞌj Israel. ");
INSERT INTO quctt_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Xkichubꞌaj ri upalaj, kꞌa te riꞌ xkichꞌey pa ujolom rukꞌ ri aj. ");
INSERT INTO quctt_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Are xetoꞌtaj chuyakik kitzeꞌ che ri Jesús, xkesaj ri manta chrij, xkitzalij ri ratzꞌyaq chirij, kꞌa te riꞌ xkikꞌam bꞌik pa ripik. ");
INSERT INTO quctt_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Are e bꞌenaq pa ri bꞌe, xkiriq jun achi ubꞌiꞌ Simón, aj Cirene, xkikoj kichuqꞌabꞌ xkibꞌij che chi kukꞌam bꞌik ri ripbꞌal. ");
INSERT INTO quctt_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kꞌa te riꞌ xoꞌpan pa ri jun leꞌaj ubꞌiꞌ Gólgota (ri kel kubꞌij Kꞌolibꞌal rech ri bꞌaqilaj). ");
INSERT INTO quctt_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Chilaꞌ xkiya wi vino rachiꞌl hiel che ri Jesús. Ri Jesús are xunaꞌ jubꞌiqꞌ, man xraj taj xuqumuj. ");
INSERT INTO quctt_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kꞌa te riꞌ xkiripo xuqujeꞌ xoꞌk pa etzꞌanem rech kakilo jachin kachꞌekow bꞌik ri ratzꞌyaq. ");
INSERT INTO quctt_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Xuqujeꞌ xetꞌuyiꞌk chuchajixik. ");
INSERT INTO quctt_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Pa uwiꞌ ri ujolom ri Jesús xkitzꞌibꞌaj jas ri xumakuj, ri kubꞌij: ARE WAꞌ RI JESÚS, RI NIM TAQANEL PA KIWIꞌ RI WINAQ AꞌJ ISRAEL. ");
INSERT INTO quctt_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Pa uxukut ri Jesús xeꞌkirip xuqujeꞌ e kebꞌ eleqꞌomabꞌ, jun pa ri umox, jun pa ri uwiqiqꞌabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ri winaq ri kiꞌkꞌow bꞌik chilaꞌ, kakisutusa ri kijolom, kakiyoqꞌ kanoq, kakibꞌij: ");
INSERT INTO quctt_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","At, ri katukij ri Templo kꞌa te riꞌ pa oxibꞌ qꞌij kayak ukꞌaxel, chakolo awibꞌ, we qas at ri at uKꞌojol ri Dios, chatqaj loq cho le ripbꞌal. ");
INSERT INTO quctt_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Xkitzeꞌj xuqujeꞌ uwach ri Jesús ri kinimaꞌqil ri e chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq e kachiꞌl ri aꞌjtijabꞌ rech ri taqanik, xuqujeꞌ ri e kꞌamal taq bꞌe ke ri tinimit. ");
INSERT INTO quctt_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Xkibꞌij: Man kakwin taj kukol ribꞌ pune xuꞌkol chi nikꞌaj, kubꞌij kꞌut chi are nimalaj taqanel pa Israel. Qaj loq cho le ripbꞌal rech kujkojon che. ");
INSERT INTO quctt_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","We qas kuꞌl ukꞌuꞌx chirij ri Dios, Toꞌq bꞌa rumal ri Dios, we qas kaloqꞌaxik. ¿La man kꞌu xubꞌij: In in uKꞌojol ri Dios? ");
INSERT INTO quctt_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ri eleqꞌomabꞌ xuqujeꞌ ri xerip chuxukut ri Jesús kakibꞌij apanoq itzel taq tzij che. ");
INSERT INTO quctt_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Pa ri nikꞌaj qꞌij xqꞌequꞌmataj ronojel ri uwachulew kꞌa te xtaniꞌk pa ri urox hora bꞌenaq qꞌij. ");
INSERT INTO quctt_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Teqꞌ qas pa ri urox hora rech bꞌenaq qꞌij, ri Jesús xuraq uchiꞌ rukꞌ chuqꞌabꞌ xubꞌij: Eli, Eli ¿lama sabactani? Ri kel kubꞌij NuDios, nuDios, ¿jas che xintzaq la kanoq nutukel? ");
INSERT INTO quctt_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","E jujun chike ri e kꞌo chilaꞌ xkibꞌij: Xa tajin kusikꞌij apanoq ri Elías. ");
INSERT INTO quctt_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Aninaq jun chike ri winaq xuꞌtzukuj loq jun qꞌux, xumubꞌa pa vinagre kꞌa te riꞌ xuxekebꞌaꞌ che jun aj, xuya apanoq pa uchiꞌ ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","E nikꞌaj chik xkibꞌij: Chiwayeꞌj na, qilampeꞌ we qas kape ri Elías chutoꞌik. ");
INSERT INTO quctt_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Junmul chik ri Jesús xuraq uchiꞌ rukꞌ chuqꞌabꞌ, kꞌa te riꞌ xkamik. ");
INSERT INTO quctt_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Qas pa ri qꞌotaj riꞌ, ri tasbꞌal pa ri Tyoxalaj kꞌolibꞌal ri kꞌo pa ri Templo xraqin pa kebꞌ, xuchapleꞌj loq puꞌwiꞌ xulkꞌis chuxeꞌ. Kꞌa te riꞌ xubꞌan jun nimalaj kabꞌraqan, ri aꞌbꞌaj xepaqꞌinik. ");
INSERT INTO quctt_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Xejaqataj loq ri muqbꞌal taq kaminaqibꞌ, e kꞌi e ralkꞌwaꞌl ri Dios ri e kaminaq, xekꞌastajik. ");
INSERT INTO quctt_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Xeꞌl loq pa taq ri muqbꞌal are kꞌastajinaq chi ri Jesús, xoꞌk bꞌik pa Jerusalén ri utinimit ri Dios, e kꞌi winaq xiꞌlowik. ");
INSERT INTO quctt_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Are xkil ri kinimaꞌqil ri ajchꞌoꞌjabꞌ xuqujeꞌ konojel ri e chajininaq ri Jesús, ri kabꞌraqan xuqujeꞌ ronojel ri xkꞌulmatajik, sibꞌalaj xkixiꞌj kibꞌ, xkibꞌij: Qas tzij wi, we achi riꞌ qas uKꞌojol ri Dios wi. ");
INSERT INTO quctt_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ri ixoqibꞌ ri xkitereneꞌj loq ri Jesús are xel loq pa Galilea, naj e kꞌo wi kekaꞌy apanoq. ");
INSERT INTO quctt_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Chkixoꞌl ri ixoqibꞌ riꞌ e kꞌo ri María Magdalena, ri María ri unan ri Jacobo rachiꞌl ri José, xuqujeꞌ ri kinan ri e ralkꞌwaꞌl ri Zebedeo. ");
INSERT INTO quctt_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Okem kubꞌan ri aqꞌabꞌ, xpe jun qꞌinom achi, ubꞌiꞌ José, kel pa ri tinimit Arimatea, xubꞌan na utijoxel ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Xopan rukꞌ ri Pilato, xuꞌta ri utyoꞌjal ri Jesús, ri Pilato xtaqanik kaya loq che. ");
INSERT INTO quctt_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ri José xubꞌolqꞌotij ri utyoꞌjal ri Jesús pa jun saq atzꞌyaq. ");
INSERT INTO quctt_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Xuya kanoq pa jun kꞌakꞌ muqbꞌal ri kꞌottal pa jun abꞌaj ri kꞌo pa ri rulew. Xuwolqotij jun nimalaj abꞌaj xutzꞌapibꞌej kanoq ri uchiꞌ ri jul. Kꞌa te riꞌ xel bꞌik chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Choch ri muqbꞌal e tꞌuyul apanoq ri María Magdalena xuqujeꞌ ri jun María chik. ");
INSERT INTO quctt_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jun qꞌij ikꞌowinaq ri sukꞌumam qꞌij rech uxlanem, ri e kinimaꞌqil ri e chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq e kachiꞌl ri fariseos, xoꞌpan rukꞌ ri Pilato. ");
INSERT INTO quctt_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Xkibꞌij che: Ajawxel, kanaꞌtaj chaqe are kꞌas na ri jun achi ri bꞌanal tzij xubꞌij: “Kinkꞌastaj na pa oxibꞌ qꞌij.” ");
INSERT INTO quctt_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Rumal ri, taqan la katzꞌapix ri uchiꞌ ri jul, tzꞌaqat na oxibꞌ qꞌij, rech man kepe ta ri utijoxelabꞌ kulkeleqꞌaj ri utyoꞌjal kꞌa te riꞌ kakibꞌij na chike ri winaq chi xa xkꞌastajik. Ri bꞌanoj tzij riꞌ sibꞌalaj nim na cho ri nabꞌe. ");
INSERT INTO quctt_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ri Pilato xubꞌij chike: Chikꞌama bꞌik jun wok ajchꞌoꞌjabꞌ rech kakichajij ri uchiꞌ ri jul. ");
INSERT INTO quctt_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Jeriꞌ xebꞌek, xeꞌkikojo kanoq jun abꞌaj chutzꞌapixik ri jul, xkikoj kanoq retal, xuqujeꞌ xeꞌkiya kanoq ri e chajil taq rech. ");
INSERT INTO quctt_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ikꞌowinaq chi ri qꞌij rech uxlanem, qas pa ri usaqiribꞌal ri nabꞌe qꞌij rech ri wuqubꞌ qꞌij, ri María Magdalena rachiꞌl ri jun María chik xebꞌek chi rilik ri muqbꞌal. ");
INSERT INTO quctt_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Xaq kꞌa teꞌ xubꞌan jun nimalaj kabꞌraqan, jeriꞌ rumal cher jun ángel rech pa ri kaj xqaj loq, xqebꞌ chuxukut ri muqbꞌal, xresaj ri abꞌaj kꞌa te riꞌ xutꞌuyulej. ");
INSERT INTO quctt_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ri ángel sibꞌalaj karepqꞌunik jetaq ri kayapaꞌ, sibꞌalaj saq ri ratzꞌyaq jetaq ri saq tew. ");
INSERT INTO quctt_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ri ajchꞌoꞌjabꞌ chajinelabꞌ sibꞌalaj xkixiꞌj kibꞌ, xkichapleꞌj bꞌiribꞌatem, kekam che ri kixibꞌin ibꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ri ángel xubꞌij chike ri ixoqibꞌ: Man kixiꞌj ta iwibꞌ, wetaꞌm chi are kitzukuj ri Jesús ri xripik. ");
INSERT INTO quctt_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Man kꞌo taj waral, xkꞌastaj uwach, jacha ri xubꞌij chiꞌwe. Chixanloq chiwilaꞌ jawjeꞌ ri xmuqiꞌ wi. ");
INSERT INTO quctt_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kꞌa te riꞌ jix aninaq, jiꞌbꞌij chike ri utijoxelabꞌ: “Xkꞌastaj ri Jesús chikixoꞌl ri kaminaqibꞌ, kanabꞌej na chiꞌwach je laꞌ pa Galilea. Iwetaꞌm chik, je laꞌ kiwil wi na uwach.” ");
INSERT INTO quctt_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ri ixoqibꞌ aninaq xeꞌl bꞌik rukꞌ ri muqbꞌal, kixiꞌm kibꞌ xuqujeꞌ kekiꞌkotik, kexikꞌanik xeꞌkibꞌij chike ri tijoxelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Xaq kꞌa te xkikꞌulaj ri Jesús pa ri bꞌe, xuya rutzil kiwach. Ri ixoqibꞌ xeqet rukꞌ xkimatzej ri raqan xuqujeꞌ xkiqꞌijilaꞌj. ");
INSERT INTO quctt_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ri Jesús xubꞌij chike: Man kixiꞌj ta iwibꞌ, jiꞌbꞌij chike ri e wachalal chebꞌoꞌj je laꞌ pa Galilea, je laꞌ kakil wi na nuwach. ");
INSERT INTO quctt_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","E bꞌenaq ri ixoqibꞌ pa ri bꞌe, are jujun chike ri ajchꞌoꞌjabꞌ chajinelabꞌ xoꞌk bꞌik pa ri tinimit, xeꞌkitzijoj chike ri e kinimaꞌqil ri chꞌawenelabꞌ pa kiwiꞌ ri winaq ronojel ri xkꞌulmatajik. ");
INSERT INTO quctt_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Are xetoꞌtaj che ri kichomanik ri e kꞌamal taq bꞌe rech ri tinimit xuqujeꞌ ri e kinimaꞌqil ri chꞌawenelabꞌ cho ri Dios, xkiya nimalaj pwaq chike ri ajchꞌoꞌjabꞌ chajinelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Kꞌa te riꞌ xkibꞌij chike: Chibꞌij: are ri utijoxelabꞌ ri Jesús xulkeleqꞌaj ri utyoꞌjal ri Jesús are tajin kujwarik. ");
INSERT INTO quctt_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Man kixiꞌj taj iwibꞌ we kuta ri qꞌatal tzij we riꞌ, uj kujchꞌaw piꞌwiꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ri ajchꞌoꞌjabꞌ chajinelabꞌ xkikꞌam ri pwaq xuqujeꞌ je xkibꞌij jetaq ri xbꞌix chike. Are waꞌ ri xaq jeꞌ katzijox chkixoꞌl ri winaq aꞌj Israel pa taq we qꞌij kamik riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ri e julajuj tijoxelabꞌ xebꞌe pa Galilea, puꞌwiꞌ ri juyubꞌ ri xubꞌij ri Jesús chike. ");
INSERT INTO quctt_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Are xkil ri Jesús, xkiqꞌijilaꞌj, e kꞌo kꞌu jujun chike man xkikoj taj chi are Jesús. ");
INSERT INTO quctt_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ri Jesús xqet kukꞌ, xubꞌij: Ronojel chuqꞌabꞌ yaꞌtal chwe pa ri kaj xuqujeꞌ choch ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Rumal riꞌ jix chitzijoj ri utz laj tzij chike konojel ri winaq rech ri uwachulew, chibꞌana kiqasanaꞌ pa ri ubꞌiꞌ ri Tataxel, Kꞌojolaxel xuqujeꞌ ri Tyoxalaj Uxlabꞌixel. ");
INSERT INTO quctt_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Chiꞌtijoj chunimaxik ronojel ri ixnutaqom chubꞌanik, qas tzij kinbꞌij chiꞌwe kinkꞌojiꞌ na iwukꞌ ronojel qꞌij, kꞌa pa ri kꞌisbꞌalil rech ri uwachulew.");
INSERT INTO quctt_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jewaꞌ xkꞌulmatajik are xchapleꞌtaj loq utzijoxik ri utz laj tzij rech ri Jesucristo, ukꞌojol ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Xkꞌulmatajik jetaq ri utzꞌibꞌam loq ri qꞌalajisal rech ri utzij ri Dios Isaías, are xubꞌij: Kintaq na bꞌik ri nutaqoꞌn kanabꞌej na chawach, rech kusukꞌumaj apanoq ri abꞌe, ");
INSERT INTO quctt_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Uchꞌabꞌal jun winaq ri kasikꞌinik pa ri katzꞌinow ulew, kubꞌij: Chisukꞌumaj ri ubꞌe ri Ajawxel, sukꞌum chibꞌana che ri ubꞌe. ");
INSERT INTO quctt_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jeriꞌ xubꞌan ri Juan are xutzijoj ri qasanaꞌ rech kꞌexbꞌal kꞌuꞌx rech kuybꞌal mak pa ri katzꞌinow ulew. ");
INSERT INTO quctt_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Konojel ri winaq aꞌj Judea, aꞌj Jerusalén xoꞌpan rukꞌ. Ri Juan xubꞌan kiqasanaꞌ ri winaq pa ri nimaꞌ Jordán, are xtzujutaj kibꞌ che ri kimak. ");
INSERT INTO quctt_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ri ratzꞌyaq ri Juan che rismal kamey bꞌantal wi, ri jatꞌibꞌal upam jun tzꞌuꞌm, are xutij che uwa ri e sakꞌ rachiꞌl ri juyubꞌil kabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jewaꞌ xubꞌij are xutzijoj ri utzij ri Dios: Kape chi na jun ri sibꞌalaj kꞌo ukwinem chinuwach in, man taqal ta chwe kinkir ri uxajabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","In xinbꞌan iqasanaꞌ rukꞌ jaꞌ, are kꞌu ri kape na kubꞌan na iqasanaꞌ pa ri Tyoxalaj Uxlabꞌixel. ");
INSERT INTO quctt_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Pa taq ri qꞌij riꞌ xopan ri Jesús, upetik pa Nazaret rech Galilea, xbꞌan kan uqasanaꞌ rumal ri Juan pa ri nimaꞌ Jordán. ");
INSERT INTO quctt_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ri Jesús are xel loq pa ri nimaꞌ, xril ri kaj xjaqajobꞌik, xqaj loq ri Tyoxalaj Uxlabꞌixel jer xubꞌan jun palomax. ");
INSERT INTO quctt_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Xtataj xuqujeꞌ jun chꞌabꞌal upetik pa ri kaj xubꞌij: At, at loqꞌalaj nukꞌojol, kakiꞌkot na nukꞌuꞌx awukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kꞌa te riꞌ xkꞌam bꞌik ri Jesús rumal ri Uxlabꞌixel pa ri katzꞌinow ulew. ");
INSERT INTO quctt_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kawinaq qꞌij xkꞌojiꞌk chilaꞌ chikixoꞌl juyubꞌil taq aꞌwaj, xkoj kꞌaꞌmabꞌal pa ri ubꞌe rumal ri Itzel rech kaqaj pa mak. Xepe kꞌu ri angelibꞌ chupatanixik. ");
INSERT INTO quctt_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Are xokisataj ri Juan pa cheꞌ, ri Jesús xeꞌ chutzijoxik ri utz laj utzij ri Dios pa Galilea. ");
INSERT INTO quctt_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Xubꞌij: Xopan ri qꞌij ri utzujum loq ri Dios, xnaqajir loq ri rajawarem, chikꞌexa ikꞌuꞌx, chikojo ri utz laj tzij. ");
INSERT INTO quctt_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Are xikꞌow bꞌik ri Jesús chuchiꞌ ri cho pa Galilea, xeꞌril ri Simón rachiꞌl ri Andrés ri rachalal, tajin kakikꞌyaq ri kikꞌat pa ri cho, rumal cher e chapal taq kar. ");
INSERT INTO quctt_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ri Jesús xubꞌij chike: Chixanloq, chinitereneꞌj, kinbꞌan na chiꞌwe chikikꞌam loq achyabꞌ wukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Aninaq xkitzaq kanoq ri kikꞌat, xeteriꞌ bꞌik chirij ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ri Jesús are bꞌininaq chi apanoq jubꞌiqꞌ xeꞌril ri Jacobo rachiꞌl ri Juan e ralkꞌwaꞌl ri Zebedeo, e kꞌo apanoq pa ri jukubꞌ bꞌinibꞌal puꞌwiꞌ ri jaꞌ, tajin kakisalabꞌaj ri kikꞌat puꞌwiꞌ ri jaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ri Jesús xuꞌsikꞌij apanoq ri achyabꞌ, ri achyabꞌ xkiya kan ri kitat Zebedeo kukꞌ ri e kajchakibꞌ pa ri jukubꞌ bꞌinibꞌal, kꞌa te riꞌ xebꞌe rukꞌ ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Are xoꞌpan pa ri tinimit Capernaúm, pa ri qꞌij rech uxlanem, ri Jesús xok bꞌik pa ri Sinagoga, xuchapleꞌj uyaꞌik kꞌutuꞌn. ");
INSERT INTO quctt_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ri winaq kemayijan che taq ri ukꞌutuꞌn, rumal cher man kuxiꞌj ta ribꞌ chukꞌutik. Man je ta kubꞌano jetaq kakibꞌan ri aꞌjtijabꞌ rech ri taqanik. ");
INSERT INTO quctt_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Xaq kꞌa teꞌ xwaꞌjil jun achi pa ri Sinagoga ri kꞌo jun itzel uxlabꞌal che, xuraq uchiꞌ xubꞌij: ");
INSERT INTO quctt_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Jesús aj Nazaret, ¿jas che kanim awibꞌ chiqaxoꞌl? ¿La xa at petinaq chiqatukixik? In wetaꞌm at jachinaq. At riꞌ ri at chaꞌtal rumal ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ri Jesús xubꞌij che: Chatuxlanoq, chatel bꞌik che we achi riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ri itzel uxlabꞌal xutzaq ri achi pa ri ulew rukꞌ chuqꞌabꞌ, kꞌa te riꞌ xuraqaqej uchiꞌ, xel bꞌik che ri achi. ");
INSERT INTO quctt_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Konojel ri winaq xkixiꞌj kibꞌ, kakitatabꞌela chibꞌil taq kibꞌ: ¿Jas waꞌ we riꞌ? ¡Jun kꞌakꞌ kꞌutuꞌn waꞌ rumal laꞌ qas rukꞌ chuqꞌabꞌ kubꞌano! Pune aꞌre itzel taq uxlabꞌal keniman che. ");
INSERT INTO quctt_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Rumal waꞌ aninaq xel utzijoxik ri Jesús pa ronojel Galilea. ");
INSERT INTO quctt_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ri Jesús are xeꞌl bꞌik pa ri Sinagoga e rachiꞌl ri Jacobo xuqujeꞌ ri Juan xebꞌe cho rachoch ri Simón xuqujeꞌ ri Andrés. ");
INSERT INTO quctt_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Aninaq xkibꞌij che ri Jesús chi ri ujiꞌ ixoq ri Simón yawabꞌ, qꞌoyol pa ri usok, kꞌo qꞌaqꞌ che. ");
INSERT INTO quctt_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ri Jesús xqebꞌ rukꞌ ri ixoq, xuchap che ri uqꞌabꞌ, xutoꞌo xwaꞌjilik. Aninaq kꞌut xel bꞌik ri qꞌaqꞌ che ri ixoq. Aninaq xwaꞌjilik xuchapleꞌj kipatanixik. ");
INSERT INTO quctt_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Are xqaj ri qꞌij, ri winaq xeꞌkikꞌam bꞌik ri e yawabꞌibꞌ xuqujeꞌ ri e kꞌo itzel taq uxlabꞌal chike rukꞌ ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Jeriꞌ konojel ri winaq xkimulij kibꞌ chuchiꞌ ri uchiꞌ ja. ");
INSERT INTO quctt_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ri Jesús xuꞌkunaj e kꞌi yawabꞌibꞌ. Xeꞌresaj xuqujeꞌ itzel taq uxlabꞌal, man xuya ta bꞌe chike ri uxlabꞌal xechꞌawik rumal cher ri itzel taq uxlabꞌal ketaꞌm uwach ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Sibꞌalaj aqꞌabꞌil kꞌa kamuquq na, xwaꞌjil bꞌik ri Jesús xel bꞌi cho ri ja, xeꞌ pa jun leꞌaj utukel, chilaꞌ xuchapleꞌj wi chꞌawem. ");
INSERT INTO quctt_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ri Simón e rachiꞌl jujun tijoxelabꞌ chik xebꞌe chutzukuxik ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Are xkiriqo xkibꞌij che: Konojel ri winaq tajin kakitzukuj la. ");
INSERT INTO quctt_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ri Jesús xubꞌij chike: Chujel bꞌik waral, joꞌ chi pa taq nikꞌaj leꞌaj chik, rech jeriꞌ keꞌntzijoj ri utzij ri Dios, rumal cher are waꞌ nupatan in petinaq. ");
INSERT INTO quctt_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Xaq jeriꞌ, xbꞌinik pa ronojel Galilea, xutzijoj ri utz laj tzij pa ri Sinagoga, xuqujeꞌ xeꞌresaj ri itzel taq uxlabꞌal chike ri winaq. ");
INSERT INTO quctt_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Xopan jun chꞌaꞌk achi rukꞌ ri Jesús, xqebꞌ rukꞌ xukiꞌk choch, kꞌa te riꞌ xuta toqꞌobꞌ che xubꞌij: We kaj la, chinchꞌajchꞌobꞌej la. ");
INSERT INTO quctt_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Salabꞌataj ri ranimaꞌ ri Jesús xuyuq ri uqꞌabꞌ xuchap ri achi, xubꞌij: Jeꞌ kawaj, chatchꞌajchꞌobꞌetajoq. ");
INSERT INTO quctt_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ri achi aninaq xutzirik, xel bꞌik ri chꞌaꞌk che. ");
INSERT INTO quctt_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ri Jesús xutaq bꞌik ri achi, xupixabꞌaj bꞌik, xubꞌij che: ");
INSERT INTO quctt_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Qas chataꞌ, mabꞌij chi che jun winaq ri xkꞌulmataj awukꞌ, xaq xwi jat jakꞌutu awibꞌ choch ri chꞌawenel pa kiwiꞌ ri winaq, chakꞌama bꞌik ri sipanik ri kubꞌij ri utaqanik ri Moisés, rech kakil ri winaq chi xatutzirik. ");
INSERT INTO quctt_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Are xel bꞌik ri achi rukꞌ ri Jesús, xuchapleꞌj utzijoxik chike ri winaq ri xkꞌulmatajik. Rumal riꞌ man xkwin ta chi ri Jesús xok pa taq ri tinimit, pune jeriꞌ e kꞌi winaq aꞌj jaljoj taq tinimit xoꞌpan rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ikꞌowinaq chi jun janipa qꞌij, ri Jesús xok chi bꞌi junmul pa Capernaúm, aninaq xtukin utzijoxik chi xopan ri Jesús pa ri utinimit. ");
INSERT INTO quctt_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ri winaq aninaq xkimulij kibꞌ, xkinojisaj ri ja. Ri Jesús xuchapleꞌj utzijoxik ri utz laj tzij chike. ");
INSERT INTO quctt_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Xoꞌpan xuqujeꞌ e kajibꞌ achyabꞌ kukꞌam bꞌik jun achi cheꞌarinaq ri utyoꞌjal. ");
INSERT INTO quctt_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Man kekwin ta kꞌut keqebꞌ rukꞌ ri Jesús rumal ri kikꞌyal ri winaq, rumal riꞌ xkesaj ri uwiꞌ ri ja jawjeꞌ kꞌo wi ri Jesús, xkiqasaj bꞌik ri achi ri cheꞌarinaq ri ubꞌaqil, qꞌoyol pa ri uchꞌat. ");
INSERT INTO quctt_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Are xril ri Jesús ri kikojobꞌal ri achyabꞌ, xubꞌij che ri achi ri cheꞌarinaq utyoꞌjal: Nukꞌojol, ri amak xekuyutajik. ");
INSERT INTO quctt_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Jujun chike ri aꞌjtijabꞌ rech ri taqanik ri e tꞌuyul chilaꞌ xkichomaj: ");
INSERT INTO quctt_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","¿Jas che jewaꞌ katzijon we achi riꞌ? Awas ri tajin kubꞌij: “¿Jachin riꞌ ri kakwinik kukuy makaj, we man xaq xwi ri Dios?” ");
INSERT INTO quctt_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Qas che riꞌ ri qꞌotaj riꞌ, ri Jesús xretaꞌmaj ri tajin kakichomaj ri aꞌjtijabꞌ rech ri taqanik. Xubꞌij chike: ¿Jas che jeriꞌ kixchomanik? ");
INSERT INTO quctt_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Jas ri man kꞌax ta ubꞌixik che we achi ri cheꞌarinaq utyoꞌjal, “xkuyutaj ri amak” o are “chatwaꞌjiloq, chakꞌama bꞌik ri achꞌat, jat cho awachoch”? ");
INSERT INTO quctt_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Rech kiwilo chi ri uKꞌojol ri Achi kꞌo ukwinem chukuyik makaj cho ri uwachulew. Xuchꞌabꞌej ri achi ri cheꞌarinaq ubꞌaqil xubꞌij che, ");
INSERT INTO quctt_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Kinbꞌij chawe: Chatwaꞌjiloq, chakꞌama bꞌik ri achꞌat, jat cho awachoch. ");
INSERT INTO quctt_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ri achi xwaꞌjilik, chikiwach konojel ri winaq xukꞌam bꞌi ri uchꞌat, kabꞌinik xeꞌek. Konojel ri winaq xkichapleꞌj uqꞌijilaꞌxik ri Dios. Xkibꞌij: Man qilom ta wi jun jastaq jetaq we riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Junmul chik xeꞌ ri Jesús chuchiꞌ ri plo. Xuya kꞌutuꞌn chike konojel ri winaq ri xoꞌpan rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Are xuchapleꞌj bꞌinem chilaꞌ, xril ri Leví ukꞌojol ri Alfeo tajin kutoqꞌij alkabal rech ri tinimit Roma, ri Jesús xubꞌij che: Chinatereneꞌj. Ri Leví xwaꞌjilik, xteriꞌ bꞌik chirij ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ri Jesús xkꞌojiꞌ puꞌwiꞌ ri mexa cho rachoch ri Leví, e kꞌi toqꞌil taq alkabal xuqujeꞌ aꞌjmakibꞌ xetꞌuyiꞌk rukꞌ xuqujeꞌ ri utijoxelabꞌ, sibꞌalaj e kꞌi chik ri e teren chirij ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Are xkil ri e fariseos aꞌjtijabꞌ rech ri taqanik chi ri Jesús tajin kawaꞌ kukꞌ ri winaq riꞌ, xkita chike ri utijoxelabꞌ: ¿La kawaꞌ kꞌu we achi riꞌ kukꞌ ri aꞌjmakibꞌ xuqujeꞌ kukꞌ ri e toqꞌil taq alkabal? ");
INSERT INTO quctt_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Are xuta ri Jesús ri xkibꞌij, xubꞌij: ¿La man are kajawataj ajkun chike ri e yawabꞌibꞌ? In man xinpe taj chikisikꞌixik ri e sukꞌ xane xinpe chikisikꞌixik ri aꞌjmakibꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jun qꞌijal ri winaq xkilo chi ri utijoxelabꞌ ri Juan xuqujeꞌ ri e fariseos man kewaꞌ taj, e jujun xeqet rukꞌ ri Jesús, xkita che: ¿Jas che ri utijoxelabꞌ ri Juan xuqujeꞌ ri kitijoxelabꞌ ri fariseos man kewaꞌ taj, are kꞌu le tijoxelabꞌ la man je taj kakibꞌano? ");
INSERT INTO quctt_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ri Jesús xubꞌij chike: ¿La kuya kꞌu riꞌ man kewaꞌ ta ri e rech chꞌabꞌeꞌn ri jiꞌatz are kꞌo kukꞌ? Man kuya ta riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kuꞌriqa kꞌu na qꞌij are kesax ri jiꞌatz kukꞌ, che ri qꞌij riꞌ qas man kewaꞌ ta wi. ");
INSERT INTO quctt_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Man kꞌo ta jun kukoj jun chꞌaqaꞌp kꞌakꞌ atzꞌyaq chukꞌojoxik jun qꞌeꞌl atzꞌyaq. We jeriꞌ kubꞌano katꞌoqopin la riꞌ ri chꞌaqaꞌp kꞌakꞌ atzꞌyaq ri xukoj chukꞌojoxik ri qꞌeꞌl atzꞌyaq, xuqujeꞌ kanimar na ri teqꞌ che ri kꞌakꞌ atzꞌyaq. ");
INSERT INTO quctt_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Xuqujeꞌ maj jun kuya kꞌakꞌ vino pa ri qꞌeꞌl tzꞌuꞌm kꞌolibꞌal. We jeriꞌ kubꞌano, ri tzꞌuꞌm kꞌolibꞌal katꞌoqopinik, katix na ri vino xuqujeꞌ ketꞌoqopinik ri tzꞌuꞌm. Are utz kaya ri kꞌakꞌ vino pa ri kꞌakꞌ tzꞌuꞌm kꞌolibꞌal. ");
INSERT INTO quctt_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Pa jun qꞌij rech uxlanem xikꞌow bꞌi ri Jesús chuxoꞌl ri tikoꞌn, ri utijoxelabꞌ xkichapleꞌj utzukuxik ri ujolom ri tiriko. ");
INSERT INTO quctt_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ri fariseos xkibꞌij che ri Jesús: Chawilampeꞌ, ¿jas che ri atijoxelabꞌ kakibꞌan ri man yaꞌtal taj kabꞌan pa ri qꞌij rech uxlanem? ");
INSERT INTO quctt_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ri Jesús xubꞌij chike: ¿La man isikꞌim ri xubꞌan junmul ri David, e rachiꞌl ri rajchꞌoꞌjabꞌ are xenumik? ");
INSERT INTO quctt_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Xok bꞌik pa ri Templo, xuꞌtija ri tyoxalaj kaxlan wa ri xaq xwi yaꞌtal chike ri chꞌawenelabꞌ cho ri Dios kakitijo, xuqujeꞌ xuya ke ri rachiꞌl, che riꞌ are ri Abiatar chꞌawenel cho ri Dios pa kiwiꞌ ri winaq. ");
INSERT INTO quctt_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ri qꞌij rech uxlanem xbꞌanik rech kukoj ri achi, man are ta ri qꞌij rech uxlanem kakojow ri achi, ");
INSERT INTO quctt_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","xaq jeriꞌ ri uKꞌojol ri Achi, are kabꞌan rech puꞌwiꞌ ronojel pune are ri qꞌij rech uxlanem. ");
INSERT INTO quctt_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Junmul chik xok bꞌik ri Jesús pa ri Sinagoga, chilaꞌ kꞌo wi jun achi cheꞌarinaq jun uqꞌabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Kꞌo kꞌu jujun winaq kakaj kakimol umak ri Jesús, xaq jeriꞌ xaq kikꞌakꞌaleꞌm we kukunaj kanoq ri achi pa ri qꞌij rech uxlanem. ");
INSERT INTO quctt_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ri Jesús xubꞌij che ri achi, ri cheꞌarinaq uqꞌabꞌ: Chattakꞌal chikiwach konojel. ");
INSERT INTO quctt_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kꞌa te riꞌ xubꞌij chike winaq ri e kꞌakꞌaleꞌninaq: ¿Jas yaꞌtalik kabꞌan pa ri qꞌij rech uxlanem? ¿La yaꞌtalik kabꞌan utzilal o etzelal, la utz kakol jun winaq o are utz kakamisaxik? Maj jun chike ri winaq xchꞌawik. ");
INSERT INTO quctt_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ri Jesús xuꞌkaꞌyej ri winaq, xyojtajik, xuqujeꞌ xbꞌisonik rumal ri ukowil ri kanimaꞌ, kꞌa te riꞌ xubꞌij che ri achi: Chayuqu ri aqꞌabꞌ. Are xuyuq ri uqꞌabꞌ ri achi, xutzirik. ");
INSERT INTO quctt_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Xaq xeꞌl loq ri fariseos pa ri Sinagoga, xkichapleꞌj uchomaxik kukꞌ ri herodianos jas kakibꞌan chukamisaxik ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ri Jesús e rachiꞌl ri utijoxelabꞌ xeꞌ chuchiꞌ ri cho, sibꞌalaj e kꞌi winaq xeteriꞌ bꞌi chirij. ");
INSERT INTO quctt_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Are xetaꞌmataj ri kubꞌan ri Jesús, e kꞌi winaq aꞌj Judea, Jerusalén, Idumea, ri kepe chꞌaqaꞌp che ri Jordán, xuqujeꞌ ri kepe pa ri tinimit Tiro xuqujeꞌ Sidón xoꞌpan rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ri Jesús xubꞌij chike ri utijoxelabꞌ chi kakisukꞌumaj jun jukubꞌ bꞌinibꞌal puꞌwiꞌ ri jaꞌ rech kakꞌojiꞌ ri Jesús chupam jeriꞌ man katakꞌaleꞌx taj kumal ri winaq. ");
INSERT INTO quctt_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jeriꞌ rumal e kꞌi xuꞌkunaj xuqujeꞌ konojel ri e yawabꞌibꞌ kakaj kakichap ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ri itzel taq uxlabꞌal are xkil ri Jesús xexukiꞌk choch, xkibꞌij che: ¡At at uKꞌojol ri Dios! ");
INSERT INTO quctt_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ri Jesús xubꞌij chike ri itzel taq uxlabꞌal chi man kakibꞌij taj jachin ri areꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ri Jesús xpaqiꞌ puꞌwiꞌ jun juyubꞌ, xuꞌsikꞌij bꞌik ri xraj xebꞌe rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Chilaꞌ xuꞌchaꞌ wi ri kabꞌlajuj uꞌtaqoꞌn, rech kuꞌx e rachiꞌl xuqujeꞌ rech kuꞌtaq bꞌik chutzijoxik ri utz laj tzij. ");
INSERT INTO quctt_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Xuqujeꞌ xuya kwinem chike rech keꞌkesaj itzel taq uxlabꞌal. ");
INSERT INTO quctt_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Are waꞌ ri kibꞌiꞌ ri e kabꞌlajuj ri xuꞌchaꞌo: ri Simón ri xubꞌij Pedro che, ");
INSERT INTO quctt_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ri Jacobo rachiꞌl ri rachalal Juan e ralkꞌwaꞌl ri Zebedeo ri xbꞌix Boanerges chike rumal ri Jesús, ");
INSERT INTO quctt_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ri Andrés, ri Felipe, ri Bartolomé, ri Mateo, ri Tomás, ri Jacobo ukꞌojol ri Alfeo, Tadeo, ri Simón ri kabꞌix Zelote, ");
INSERT INTO quctt_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","xuqujeꞌ ri Judas Iscariote, ri xjachow ri Jesús pa kamikal. ");
INSERT INTO quctt_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kꞌa te riꞌ xok bꞌi ri Jesús pa jun ja, ri winaq junmul chik xkimulij kibꞌ rukꞌ, rumal riꞌ ri Jesús xuqujeꞌ ri utijoxelabꞌ man xekwin taj xewaꞌik. ");
INSERT INTO quctt_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Are xkita ri rachalal ri Jesús ri tajin kakꞌulmatajik, xeꞌl bꞌi chi rilik, xkibꞌij: Xkonar le Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ri aꞌjtijabꞌ rech ri taqanik ri xoꞌpan pa Jerusalén xkibꞌij: Kꞌo ri Beelzebú che we achi riꞌ, kakwinik karesaj ri itzel taq uxlabꞌal rumal kꞌo ri kinimal ri itzel rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ri Jesús xuꞌsikꞌij ri winaq, xubꞌij we jun kꞌambꞌejabꞌal noꞌj chike: ¿Jas kubꞌan ri Itzel chi resaxik bꞌik ri itzel? ");
INSERT INTO quctt_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ri winaq pa jun tinimit we xaq chikixoꞌl aꞌreꞌ kechꞌoꞌjin wi, ketukin na riꞌ xuqujeꞌ kasach na kiwach riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","We kꞌo jun ja winaq xaq kechꞌoꞌjin chikixoꞌl aꞌreꞌ, we ja winaq riꞌ kasach na kiwach. ");
INSERT INTO quctt_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Je xuqujeꞌ we kubꞌan chꞌoꞌj ri itzel chibꞌil ribꞌ, man kajeqiꞌ ta riꞌ, xane kasach riꞌ uwach. ");
INSERT INTO quctt_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Qilampeꞌ, maj jun kakwinik kelaqꞌ pa rachoch jun achi ri kꞌo uchuqꞌabꞌ we man nabꞌe kujatꞌij ri achi ajchoqꞌe ri ja. Kꞌa te riꞌ kakwinik kareleqꞌaj bꞌik ri jastaq. ");
INSERT INTO quctt_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Qas tzij kinbꞌij chiꞌwe ronojel ri makaj, xuqujeꞌ ri bꞌim awas taq jastaq kakuyutaj na. ");
INSERT INTO quctt_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Xaq xwi man kakuyutaj taj ri winaq ri kubꞌij awas taq tzij che ri Tyoxalaj Uxlabꞌixel. We winaq riꞌ man kakuyutaj ta wi, ajmak chibꞌe qꞌij saq. ");
INSERT INTO quctt_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ri Jesús xubꞌij we tzij riꞌ rumal cher ri winaq xkibꞌij: Kꞌo jun itzel uxlabꞌal che. ");
INSERT INTO quctt_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kꞌa te riꞌ xoꞌpan ri unan xuqujeꞌ ri e rachalal ri Jesús. Xekanaj kanoq cho ri ja ri kꞌo wi ri Jesús, xkitaq bꞌi jun winaq chusikꞌixik ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jeriꞌ rumal sibꞌalaj e kꞌi winaq e remel chirij, xkibꞌij che: Ri anan rachiꞌl ri aꞌwachalal e kꞌo cho we ja, tajin katkitzukuj. ");
INSERT INTO quctt_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ri Jesús xubꞌij: ¿Jachin riꞌ ri nunan, jachin riꞌ ri e wachalal? ");
INSERT INTO quctt_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Kꞌa te riꞌ xuꞌkaꞌyej konojel ri winaq ri e tꞌuyulik kisutim rij, xubꞌij: Chi riꞌ kꞌo wi ri nunan rachiꞌl ri e wachalal. ");
INSERT INTO quctt_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Are wachalal, are wanabꞌ, are nunan ri winaq ri kubꞌan ri karaj ri nutat. ");
INSERT INTO quctt_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Junmul chik ri Jesús xuchapleꞌj uyaꞌik kꞌutuꞌn chuchiꞌ ri plo. Sibꞌalaj e kꞌi winaq xkimulij kibꞌ chutayik ri kꞌutuꞌn rumal riꞌ xaqꞌan ri Jesús pa jun jukubꞌ bꞌinibꞌal puꞌwiꞌ ri jaꞌ. Konojel ri winaq xekꞌojiꞌ chuchiꞌ ri plo. ");
INSERT INTO quctt_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Xuchapleꞌj ukꞌutik sibꞌalaj kꞌi jastaq rukꞌ kꞌambꞌejabꞌal taq noꞌj jewaꞌ xubꞌij: ");
INSERT INTO quctt_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","¡Chitampeꞌ! Jun ajtikolobꞌ xeꞌ pa tikoꞌnijik. ");
INSERT INTO quctt_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Are xuchikoj ri ijaꞌ, nikꞌaj xqaj chuchiꞌ ri bꞌe, xoꞌpan ri chochiꞌ xkitijo. ");
INSERT INTO quctt_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Nikꞌaj ijaꞌ chik xqaj chuxoꞌl ri abꞌaj, jawjeꞌ man nim taj ulew kꞌolik. Aninaq xkꞌiy loq ri tikoꞌn rumal man naj taj qajinaq ri ulew. ");
INSERT INTO quctt_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Are xel loq ri qꞌij, xechaqiꞌjar ri tikoꞌn rumal man naj taj qajinaq ri ukꞌaꞌmal pa ri ulew. ");
INSERT INTO quctt_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nikꞌaj ijaꞌ chik xqaj chuxoꞌl ri kꞌix, are xekꞌiy loq xejiqꞌ chuxoꞌl ri kꞌix, man xewachin taj. ");
INSERT INTO quctt_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ri nikꞌaj ijaꞌ chik xeqaj pa ri utz ulew. Are xkꞌiy loq, xenimaꞌqirik, xewachinik e jujun xkiya juwinaq lajuj, e nikꞌaj oxkꞌal e nikꞌaj chik jun ciento. ");
INSERT INTO quctt_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kꞌa te riꞌ xubꞌij ri Jesús: Ri kꞌo uxikin chutatabꞌexik, chutatabꞌej. ");
INSERT INTO quctt_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Are xebꞌe konojel ri winaq, xeqet ri kabꞌlajuj utijoxelabꞌ rukꞌ ri Jesús, xkita che jas ubꞌanik ri kꞌambꞌejabꞌal noꞌj. ");
INSERT INTO quctt_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ri Jesús xubꞌij: Yaꞌtal chiꞌwe ix kiwetaꞌmaj ri ajawarem rech ri Dios; are kꞌu ri man e qachiꞌl taj rukꞌ kꞌambꞌejabꞌal noꞌj kinbꞌij chike. ");
INSERT INTO quctt_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Jeriꞌ rumal cher pune kekaꞌyik man kakichꞌobꞌ taj ri kakilo, pune kakito man kakichꞌobꞌ taj ri kakitatabꞌej. Rech man kakikꞌex taj kikꞌuꞌx xuqujeꞌ man kekuyutaj taj. ");
INSERT INTO quctt_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","¿Man kichomaj taj we jun kꞌambꞌejabꞌal noꞌj riꞌ? Man kixkwin ta bꞌa ri kichomaj ronojel ri nikꞌaj chik. ");
INSERT INTO quctt_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ri ajtikolobꞌ kutik ri utzij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","E kꞌo winaq kejunumataj rukꞌ ri ulew ri kꞌo chuchiꞌ ri bꞌe. Are katatabꞌetaj ri tzij kumal kape ri itzel karesaj pa kanimaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","E jujun chik kejunumataj rukꞌ ri abꞌaj ulew. Sibꞌalaj kekiꞌkotik are kakitatabꞌej ri tzij. ");
INSERT INTO quctt_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Man katikiꞌ ta kꞌu ri tzij pa kanimaꞌ, man naj taj kuqꞌiꞌo. Are kape kꞌaxkꞌolal, o kabꞌan kꞌax chike xa rumal ri utz laj tzij, kakijelechꞌuj kanoq kibꞌe. ");
INSERT INTO quctt_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","E nikꞌaj chik kejunumataj rukꞌ ri kꞌix ulew: kakitatabꞌej ri tzij. ");
INSERT INTO quctt_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Are kꞌu ri kirajawaxik rech we kꞌaslemal rech uwachulew, ri subꞌunik, xuqujeꞌ ri qꞌinomal, itzel taq rayinik, kakijiqꞌisaj ri utz laj tzij, man kawachin taj. ");
INSERT INTO quctt_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nikꞌaj chik kejunumataj rukꞌ ri utz ulew. Kakitatabꞌej ri tzij, kakikꞌamawaꞌj pa kanimaꞌ, kewachinik kakiya juwinaq lajuj, kakiya oxkꞌal, kakiya jun ciento kiwach. ");
INSERT INTO quctt_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Xubꞌij xuqujeꞌ ri Jesús chike: ¿La katzij jun lámpara kꞌa te riꞌ kaya chuxeꞌ jun chꞌat o chuxeꞌ jun cajon? ¿La man xa kaya pa jun kꞌolibꞌal chikaj rech katunanik? ");
INSERT INTO quctt_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Maj jun jastaq awatalik ri mat kariqitaj na, xuqujeꞌ maj jun jastaq ri xaq pa awal bꞌiꞌtalik ri mat ketaꞌmataj na. ");
INSERT INTO quctt_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ri kꞌo uxikin chutatabꞌexik, chutatabꞌej. ");
INSERT INTO quctt_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ri Jesús xuqujeꞌ xubꞌij: Chichajij iwibꞌ che ri kito. Rukꞌ ri pajbꞌal ri kixpajanik, rukꞌ riꞌ kapaj na ri jastaq iwe, kayaꞌtaj ne na uwiꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ri kꞌo rukꞌ kayaꞌtaj nim che, are kꞌu ri maj kꞌo rukꞌ kamaj na che ri nitzꞌ ri kꞌo rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ri Jesús xubꞌij: Ri ajawarem rech ri Dios kajunumataj rukꞌ ri ajtikolobꞌ ri kuchikoj ri ijaꞌ pa ri ulew. ");
INSERT INTO quctt_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ri ajtikolobꞌ pune kawarik o man kawar taj, ri ijaꞌ chi paqꞌij chi chaqꞌabꞌ tajin kakꞌiyik. Pune jeriꞌ man retaꞌm ta kꞌut jas kubꞌan ri ijaꞌ che ukꞌiyem. ");
INSERT INTO quctt_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ri ijaꞌ kawachinik pa utukel: nabꞌe katuxar loq, kꞌa te riꞌ kakꞌiy loq ri ujolom, kꞌisbꞌal rech kakꞌiy loq ri uwach. ");
INSERT INTO quctt_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Are kutzir ri tikoꞌn, kaqꞌatik, rumal cher xopan ri qꞌij rech yakoj. ");
INSERT INTO quctt_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Xubꞌij xuqujeꞌ ri Jesús: ¿Jas rukꞌ kaqajunamaj wi ri ajawarem rech ri Dios? ¿Jas kꞌambꞌejabꞌal noꞌj kaqakoj chutzijoxik rij? ");
INSERT INTO quctt_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kajunumataj rukꞌ jun uwach moxtansia. Nitzꞌ chikiwach konojel ri ijaꞌ are katikik. ");
INSERT INTO quctt_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Are kakꞌiy loq sibꞌalaj nim keꞌek, kux jun nimalaj cheꞌ chikiwach ri nikꞌaj e tikoꞌn chik. Nimaꞌq kebꞌe ri uqꞌabꞌ, chilaꞌ kakibꞌan wi kisok ri aꞌwaj ri kerapinik. ");
INSERT INTO quctt_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Rukꞌ jaljoj kꞌambꞌejabꞌal taq noꞌj xuya uchꞌobꞌik ri Jesús ri kꞌutuꞌn chike ri winaq. Jas na kꞌu ri xkwin ri kichomabꞌal chuchꞌobꞌik. ");
INSERT INTO quctt_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Rukꞌ kꞌambꞌejabꞌal taq noꞌj xubꞌij chike ri winaq ronojel ri jastaq. Are xaq xwi ri utijoxelabꞌ e kꞌo rukꞌ, xubꞌij chike jas jeꞌ kel kubꞌij ri kꞌambꞌejabꞌal taq noꞌj. ");
INSERT INTO quctt_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Chaqꞌabꞌ che ri qꞌij riꞌ xubꞌij ri Jesús chike ri utijoxelabꞌ: Chujqꞌax chꞌaqaꞌp. ");
INSERT INTO quctt_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ri tijoxelabꞌ xeꞌl bꞌik kukꞌ ri winaq, xebꞌek rukꞌ ri Jesús pa ri jukubꞌ bꞌinibꞌal puꞌwiꞌ ri jaꞌ, e kꞌo chi nikꞌaj winaq xaqꞌan bꞌik pa nikꞌaj taq jukubꞌ chik, xebꞌe kukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Are e kꞌo chi puꞌwiꞌ ri plo, xwaꞌjil aqꞌanoq jun nimalaj kyaqiqꞌal jabꞌ, ri jaꞌ xuchapleꞌj okem pa ri jukubꞌ bꞌinibꞌal karaj kasach kanoq chuxeꞌ ri plo. ");
INSERT INTO quctt_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ri Jesús tajin kawarik pa ri kꞌisbꞌal tꞌuyulibꞌal ri kꞌo pa ri jukubꞌ bꞌinibꞌal, ri e tijoxelabꞌ aninaq xkikꞌasuj xkibꞌij che: ¡Ajtij! ¿la man kil la chi raj kujkamik? ");
INSERT INTO quctt_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Xwaꞌjilik ri Jesús, xuyaj ri kyaqiqꞌ, kꞌa te riꞌ xubꞌij che ri plo: Chatuxlanoq. Ri plo xjoriꞌk xuta chꞌabꞌexik. ");
INSERT INTO quctt_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ri Jesús xuta chike ri utijoxelabꞌ: ¿Jas che sibꞌalaj kixiꞌj iwibꞌ? ¿Maj ikojobꞌal? ");
INSERT INTO quctt_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ri tijoxelabꞌ sibꞌalaj xkixiꞌj kibꞌ kakibꞌij chibꞌil taq kibꞌ: ¿Jachin we achi riꞌ, ri plo rachiꞌl ri kyaqiqꞌ keniman che? ");
INSERT INTO quctt_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Xoꞌpan chꞌaqaꞌp rech ri cho pa ri kulew ri winaq gerasenos. ");
INSERT INTO quctt_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Are xqaj ri Jesús pa ri jukubꞌ bꞌinibꞌal puꞌwiꞌ ri jaꞌ, xkꞌulax rumal jun achi, kꞌo jun itzel uxlabꞌal che, elem loq rech chuxoꞌl ri e muqbꞌal taq kaminaqibꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ri achi chikixoꞌl taq ri muqbꞌal kaminaqibꞌ kakꞌojiꞌ wi chi paqꞌij chi chaqꞌabꞌ, man kabꞌan ta uyutik rukꞌ chꞌichꞌ jatꞌibꞌal. ");
INSERT INTO quctt_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kutꞌoqopij taq ri chꞌichꞌ jatꞌibꞌal ri kajatꞌibꞌex rech, maj jun kakwin chuchapik. ");
INSERT INTO quctt_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Chi chaqꞌabꞌ chi paqꞌij ri achi kakꞌojiꞌ chikixoꞌl ri muqbꞌal taq kaminaqibꞌ xuqujeꞌ puꞌwiꞌ taq ri juyubꞌ, kuraqaqej uchiꞌ xuqujeꞌ kuchꞌey ribꞌ rukꞌ taq abꞌaj. ");
INSERT INTO quctt_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Naj kꞌo wi ri achi are xril apanoq ri Jesús, kaxikꞌanik xeꞌek xeꞌxukuloq choch. ");
INSERT INTO quctt_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Rukꞌ chuqꞌabꞌ xuraq uchiꞌ, xubꞌij: Jesús ralkꞌwaꞌl ri nimalaj Dios ¿jas che kape la waral? Bꞌana la toqꞌobꞌ man kabꞌan ta la kꞌax chwe. ");
INSERT INTO quctt_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Jewaꞌ xubꞌij ri itzel uxlabꞌal rumal cher ri Jesús xubꞌij che: Chatel bꞌik che we achi riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ri Jesús xuta che: ¿Jas abꞌiꞌ? Ri itzel uxlabꞌal xubꞌij: Legión nubꞌiꞌ, rumal sibꞌalaj uj kꞌi. ");
INSERT INTO quctt_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ri itzel sibꞌalaj xuta toqꞌobꞌ che ri Jesús rech man kesax taj bꞌik pa ri tinimit riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","E kꞌo sibꞌalaj e kꞌi aq tajin keyuqꞌux apanoq puꞌwiꞌ ri juyubꞌ rumal riꞌ, ri itzel taq uxlabꞌal xkibꞌij che ri Jesús: ");
INSERT INTO quctt_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ya la bꞌe chaqe kujok chike le aq leꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ri Jesús xuya bꞌe chike. Ri itzel taq uxlabꞌal xeꞌl bꞌik che ri achi, xoꞌk chike ri kebꞌ mil aq ri tajin keyuqꞌuxik. Ri aq xechꞌuꞌjarik, xetzaq bꞌik pa ri plo, xejiqꞌik. ");
INSERT INTO quctt_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ri e yuqꞌul taq aq xaꞌnimaj bꞌik, xebꞌe pa taq ri leꞌaj chutzijoxik ri xkꞌulmatajik, konojel kꞌu ri winaq xebꞌe chi rilik ri xkꞌulmatajik. ");
INSERT INTO quctt_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Are xoꞌpan ri winaq jawjeꞌ ri kꞌo wi ri Jesús xkixiꞌj kibꞌ rumal xkilo ri achi ri xeꞌl bꞌik itzel uxlabꞌal chike, tꞌuyulik, utz uwach. ");
INSERT INTO quctt_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ri xiꞌlow ri xkꞌulmatajik xkitzijoj chike ri winaq jas xkꞌulmataj rukꞌ ri achi ri xeꞌl bꞌik itzel uxlabꞌal che xuqujeꞌ jas xkꞌulmataj kukꞌ ri itzel taq uxlabꞌal. ");
INSERT INTO quctt_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ri winaq xkita toqꞌobꞌ che ri Jesús chi kel bꞌik pa ri leꞌaj riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Are tajin kaqꞌan ri Jesús pa ri jukubꞌ bꞌinibꞌal are xpe ri achi ri xeꞌsax itzel uxlabꞌal che, xubꞌij che ri Jesús chi karaj kꞌa te riꞌ chirij. ");
INSERT INTO quctt_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ri Jesús man xraj taj, xane xubꞌij che: Jat cho awachoch, jat rukꞌ ri awixoqil xuqujeꞌ kukꞌ ri awalkꞌwaꞌl jaꞌtzijoj chike jas xubꞌan ri Dios awukꞌ, xel ukꞌuꞌx chawe. ");
INSERT INTO quctt_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Jeriꞌ xeꞌ ri achi pa ri tinimit Decápolis chutzijoxik ri xubꞌan ri Jesús rukꞌ. Konojel ri winaq xemayijanik. ");
INSERT INTO quctt_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Sibꞌalaj e kꞌi winaq xoꞌpan rukꞌ ri Jesús are xopan chuchiꞌ ri plo, rumal riꞌ xaq chuchiꞌ ri plo xkanaj wi. ");
INSERT INTO quctt_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Xopan kꞌut jun kꞌamal bꞌe rech ri Sinagoga rukꞌ ri Jesús ubꞌiꞌnam Jairo. Ri Jairo are xrilbꞌej uwach ri Jesús xukiꞌ pa ri ulew. ");
INSERT INTO quctt_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Xuta toqꞌobꞌ che, xubꞌij: Raj kakam ri kꞌin laj numiꞌal, oj la wukꞌ jeꞌ ya ri qꞌabꞌ la puꞌwiꞌ rech kutzirik xuqujeꞌ kakꞌasiꞌk. ");
INSERT INTO quctt_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ri Jesús xeꞌ rukꞌ ri Jairo, sibꞌalaj e kꞌi winaq xeteriꞌ bꞌik chrij, kakipaqchiꞌ la kibꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kꞌo jun ixoq ri xeꞌ kabꞌlajuj junabꞌ xaq katuruw ukikꞌel. ");
INSERT INTO quctt_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Bꞌenaq kukꞌ sibꞌalaj e kꞌi ajkunabꞌ usachom ronojel ri urajil, man kꞌo xutayij ri xubꞌano rumal cher xa xnimataj ri yabꞌil che. ");
INSERT INTO quctt_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Are xuto katzijoxik ri Jesús, xok bꞌik chikixoꞌl ri winaq, xuꞌchapa ri umanta. ");
INSERT INTO quctt_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Jewaꞌ xubꞌano rumal xubꞌij: Kinkunatajik we kinkwinik kinchap ri ratzꞌyaq ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Aninaq xtaniꞌk ri kikꞌ che ri ixoq, kꞌa te xunaꞌo xtaniꞌk ri qꞌoxom che. ");
INSERT INTO quctt_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Qas che riꞌ xunaꞌ xuqujeꞌ ri Jesús chi xel bꞌik chuqꞌabꞌ che, rumal riꞌ xuta chike ri winaq: ¿Jachin xchapow ri watzꞌyaq? ");
INSERT INTO quctt_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ri utijoxelabꞌ xkibꞌij che: Kꞌa kata na la jachin xchapow la ¿la man kil la chi sibꞌalaj e kꞌi winaq kepaqchiꞌn la? ");
INSERT INTO quctt_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ri Jesús xkaꞌyilobꞌik rech karilo jachin ri xchapowik. ");
INSERT INTO quctt_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Are xril ri ixoq chi xretaꞌmaj ri Jesús ri xkꞌulmatajik, aninaq xukiꞌk choch, xubꞌij che jas ubꞌantajik ri jastaq. ");
INSERT INTO quctt_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ri Jesús xubꞌij che: Xatutzirik numiꞌal, jat pa jaꞌmaril, xatutzir che ri qꞌoxom. ");
INSERT INTO quctt_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tajin katzijon ri Jesús are xoꞌpan nikꞌaj achyabꞌ, kipetik cho rachoch ri Jairo, kꞌamal bꞌe pa ri Sinagoga, xkibꞌij che: Xkam ri amiꞌal, man kaya ta chi latzꞌ che le ajtij. ");
INSERT INTO quctt_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ri Jairo man are ta xrilij ri xbꞌix che. Ri Jesús xubꞌij che ri Jairo: Man kaxiꞌj taj awibꞌ, xaq xwi chatkojon chwe. ");
INSERT INTO quctt_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ri Jesús man xraj taj, xebꞌe sibꞌalaj e kꞌi winaq rukꞌ, xaq xwi xuꞌsikꞌij bꞌik ri Pedro, ri Jacobo rachiꞌl ri Juan ri rachalal ri Jacobo. ");
INSERT INTO quctt_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Are xoꞌpan cho rachoch ri kꞌamal bꞌe pa ri Sinagoga, ri Jesús xeꞌril ri winaq tajin kakiraqaqej kichiꞌ koꞌqꞌik. ");
INSERT INTO quctt_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Xok bꞌik pa ri ja, xubꞌij chike: ¿Jas che sibꞌalaj kixel chꞌuꞌj chiroqꞌexik le ali? Le ali man kaminaq taj, xaq kawarik. ");
INSERT INTO quctt_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Konojel ri winaq xkitzeꞌj ri Jesús, ri Jesús xeꞌresaj loq konojel ri winaq ri e kꞌo pa ri ja, xaq xwi xekanaj kanoq ri utat unan ri akꞌal rachiꞌl ri e tijoxelabꞌ, xebꞌe jawjeꞌ ri kꞌo wi ri ali. ");
INSERT INTO quctt_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ri Jesús xuchap ri ali che ri uqꞌabꞌ, xubꞌij che: ¡Talita, kum! ri kel kubꞌij Ali, kinbꞌij chawe: Chatwaꞌjiloq. ");
INSERT INTO quctt_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ri ali ri kabꞌlajuj ujunabꞌ aninaq xwaꞌjilik, xuchapleꞌj bꞌinem. Konojel ri winaq xemayijanik are xkil ri xkꞌulmatajik. ");
INSERT INTO quctt_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ri Jesús xubꞌij chike ri winaq chi man kakitzijoj taj ri xkꞌulmatajik, kꞌa te riꞌ xtaqanik katzuq ri ali. ");
INSERT INTO quctt_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Xel bꞌik ri Jesús chilaꞌ, e rachiꞌl ri utijoxelabꞌ xeꞌ pa ri utinimit ri xkꞌiy wi. ");
INSERT INTO quctt_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Are xuriq ri qꞌij rech uxlanem, xuchapleꞌj uyaꞌik kꞌutuꞌn pa ri Sinagoga, ri winaq ri xetowik xemayijanik, xkibꞌij: ¿Jawjeꞌ xukꞌamawaꞌj wi we kꞌutuꞌn we achi riꞌ? ¿Jachin yoꞌwinaq laꞌ le etaꞌmabꞌal che? ¿Jawjeꞌ kape wi che ri kwinem chubꞌanik ronojel ri mayijabꞌal taq jastaq? ");
INSERT INTO quctt_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿La man are waꞌ ri ajanel, ral ri María, kachalal ri Jacobo, ri José, ri Judas xuqujeꞌ ri Simón? ¿La man are e ranabꞌ ri e kꞌo qukꞌ chanim? Xkitatabꞌelaꞌ kꞌotbꞌal taq chiꞌ rumal rech ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ri Jesús xubꞌij chike: Sibꞌalaj nim kil jun qꞌalajisal utzij ri Dios pa kꞌi tinimit, xaq xwi man nim taj kilik pa ri utinimit, xuqujeꞌ man nim taj kilik kumal ri utat unan xuqujeꞌ ri rachalal. ");
INSERT INTO quctt_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Rumal riꞌ man kꞌi taj mayijabꞌal taq jastaq xubꞌan ri Jesús pa ri utinimit, xwi xekunataj jujun yawabꞌibꞌ are xuya ri uqꞌabꞌ pa kiwiꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Sibꞌalaj xmayijanik rumal chi ri winaq man xekojon taj. Ri Jesús xikꞌow pa ronojel ri tinimit ri e kꞌo naqaj, xuya kꞌutuꞌn. ");
INSERT INTO quctt_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Xuꞌsikꞌij ri e kabꞌlajuj utijoxelabꞌ, pa kakabꞌ xuꞌtaq bꞌik chutzijoxik ri utzij ri Dios. Xuya bꞌik kwinem chike pa kiwiꞌ ronojel itzel uxlabꞌal. ");
INSERT INTO quctt_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Xubꞌij chike chi man kakikꞌam ta bꞌik kiwa, kichim, kirajil pa ri kiximbꞌal kipam, xane xaq xwi ri kichꞌamiꞌy. ");
INSERT INTO quctt_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Xuqujeꞌ xubꞌij chike: Chikꞌama bꞌik ixajabꞌ, man kikꞌam ta bꞌik kebꞌ wok iwatzꞌyaq. ");
INSERT INTO quctt_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kꞌa te riꞌ xubꞌij: Chixkꞌol kanoq pa ri ja ri kixkꞌamawaꞌx wi, kꞌa kixel na bꞌik pa ri tinimit. ");
INSERT INTO quctt_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","We man kixkꞌamawaꞌx pa jun kꞌolibꞌal, o we ne man kakitatabꞌej ri kibꞌij, chitota kanoq ri ulew ri kꞌo che ri iwaqan, rech jeriꞌ kaqꞌalajinik chi man utz taj ri kakibꞌano. ");
INSERT INTO quctt_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ri kabꞌlajuj tijoxelabꞌ xkichapleꞌj utzijoxik chike ri winaq chi rajawaxik kakikꞌex kikꞌuꞌx. ");
INSERT INTO quctt_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Xeꞌkesaj xuqujeꞌ itzel taq uxlabꞌal, xkikoj aceite rech olivo chike ri e yawabꞌibꞌ rech kekunatajik. ");
INSERT INTO quctt_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ri taqanel Herodes xretaꞌmaj ri tajin kubꞌan ri Jesús. E jujun xkibꞌij xkꞌastaj loq ri Juan Bꞌanal qasanaꞌ rumal riꞌ kꞌo ukwinem chubꞌanik mayijabꞌal taq jastaq. ");
INSERT INTO quctt_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","E nikꞌaj winaq chik xkibꞌij: Are Elías. E nikꞌaj chik xkibꞌij: Jun qꞌalajisal utzij ri Dios jetaq ri xekꞌojiꞌ ojer. ");
INSERT INTO quctt_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Are xuta ri Herodes ri kakibꞌij ri winaq, xubꞌij: Xkꞌastaj loq ri Juan ri xintaqan chukutixik ri ujolom. ");
INSERT INTO quctt_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Jeriꞌ xubꞌij rumal are ri Herodes xtaqan chutzꞌapixik ri Juan pa che, rumal ri Herodes xkꞌuliꞌk rukꞌ ri Herodías, rixoqil ri rachalal Felipe. ");
INSERT INTO quctt_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ri Juan xubꞌij che ri Herodes: Ri taqanik kubꞌij chi man yaꞌtal ta chawe katkꞌuliꞌ rukꞌ ri rixoqil ri awachalal. ");
INSERT INTO quctt_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Rumal riꞌ ri Herodías sibꞌalaj royawal che ri Juan, are karaj kukamisaj. Man kwininaq ta kꞌu che. ");
INSERT INTO quctt_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ri Herodes kuxiꞌj ribꞌ cho ri Juan, rumal riꞌ uchajim, retaꞌm chi sukꞌ xuqujeꞌ maj umak. Kutatabꞌej ronojel ri kubꞌij ri Juan pune kakꞌaxir ranimaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Jun qꞌijal, are xutzꞌaqatisaj ujunabꞌ ri Herodes, xubꞌan jun nimalaj nimaqꞌij, xuꞌsikꞌij konojel ri e rajchakibꞌ, e rajchꞌoꞌjabꞌ xuqujeꞌ ri e winaq ri nim kibꞌanik pa Galilea. ");
INSERT INTO quctt_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ri ral ri Herodías xojow pa ri nimaqꞌij, ri Herodes xuqujeꞌ ri e rajchakibꞌ sibꞌalaj jeꞌl xkilo. Ri Herodes xubꞌij che ri ali: Chata chwe ri kawaj, qas kinya wi chawe. ");
INSERT INTO quctt_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ri Herodes xubꞌan jun chꞌekom tzij, xubꞌij che: Xapakux ri kata chwe kinya chawe, pune pa nikꞌaj che ri tinimit. ");
INSERT INTO quctt_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ri ali xuta che ri unan: ¿Jas kinto? Ri Herodías xubꞌij che ri ral: Chata ri ujolom ri Juan Bꞌanal qasanaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Aninaq xeꞌ ri ali, xubꞌij che ri taqanel ri karaj: Chanim kawaj kaya la chwe pa jun palaꞌt ri ujolom ri Juan Bꞌanal qasanaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ri taqanel xkꞌaxir ranimaꞌ, rumal kꞌu ri chꞌekom tzij ri xubꞌano chikiwach ri e rajtobꞌom, man xraj taj xuyak royawal ri ali. ");
INSERT INTO quctt_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Aninaq xuꞌtaq bꞌik jun rajchꞌoꞌj ri kꞌo uchuqꞌabꞌ chukutixik ri ujolom ri Juan. Ri achi xeꞌek, xuꞌkutij loq ri ujolom ri Juan ri kꞌo pa cheꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Are xtzalij loq rukꞌaꞌm loq ri ujolom ri Juan pa jun palaꞌt, xuya che ri ali, ri ali xuꞌjacha che ri unan. ");
INSERT INTO quctt_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ri utijoxelabꞌ ri Juan are xketaꞌmaj ri xkꞌulmatajik, xeꞌkikꞌama loq ri utyoꞌjal ri Juan, xeꞌkimuqu kanoq. ");
INSERT INTO quctt_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ri tijoxelabꞌ xetzalij rukꞌ ri Jesús, xeꞌkitzijoj che ri xkibꞌano xuqujeꞌ ri xkikꞌutu. ");
INSERT INTO quctt_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Man kekwin ta kꞌut kakitij kiwa rumal ri kikꞌiyal ri winaq ri xoꞌpan rukꞌ ri Jesús. Rumal riꞌ ri Jesús xubꞌij chike ri utijoxelabꞌ: Chixanloq, joꞌ pa jun kꞌolibꞌal, xaq uj wi, rech kixuxlan jubꞌiqꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Xebꞌe kꞌut kitukel pa jun jukubꞌ bꞌinibꞌal puꞌwiꞌ ri jaꞌ, pa jun kꞌolibꞌal jawjeꞌ kubꞌe kꞌol wi kitukel. ");
INSERT INTO quctt_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Sibꞌalaj kꞌi winaq xiꞌlowik are xebꞌek rumal riꞌ xeꞌkitereneꞌj bꞌik chkaqan, nabꞌe chik xoꞌpan chikiwach. ");
INSERT INTO quctt_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Are xqaj ri Jesús pa ri jukubꞌ bꞌinibꞌal, xeꞌril sibꞌalaj kꞌi winaq, xeꞌl ukꞌuꞌx chike rumal je ri e kꞌo chij ri maj kajyuqꞌ. Xuchapleꞌj ukꞌutik sibꞌalaj kꞌi jastaq chikiwach. ");
INSERT INTO quctt_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Are xqaj ri qꞌij, xeqet ri tijoxelabꞌ rukꞌ ri Jesús, xkibꞌij che: Xeꞌ le qꞌij, xuqujeꞌ sibꞌalaj naj uj kꞌo wi che ri tinimit. ");
INSERT INTO quctt_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Cheꞌtaqa la bꞌi le winaq kebꞌe pa ri tinimit ri kꞌo chi qanaqaj rech keꞌkiloqꞌo jastaq ketijowik rij. ");
INSERT INTO quctt_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ri Jesús xubꞌij chike: Chiya ix kiwa. Ri tijoxelabꞌ xkibꞌij: Pwaq re jun junabꞌ chak waꞌ kukꞌam bꞌik ¿la kaj kꞌu la kaqasach ronojel ri pwaq riꞌ rech keꞌqatzuq we winaq riꞌ? ");
INSERT INTO quctt_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","¿Janipa kaxlan wa kꞌo iwukꞌ? xcha ri Jesús chike. Ri tijoxelabꞌ xeꞌkila janipa kꞌa te riꞌ xkibꞌij che: Jobꞌ kaxlan wa kꞌo qukꞌ rachiꞌl kebꞌ kar. ");
INSERT INTO quctt_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Xtaqan kꞌu ri Jesús rech ketꞌuyubꞌax ri winaq cho ri saq pa taq wokaj. ");
INSERT INTO quctt_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ri winaq xkimulij kibꞌ pa taq nikꞌaj ciento xuqujeꞌ pa taq jujun ciento. ");
INSERT INTO quctt_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ri Jesús xukꞌam ri jobꞌ kaxlan wa rachiꞌl ri kebꞌ kar, xkaꞌy chikaj, xutewechiꞌj. Kꞌa te riꞌ xupirij ri kaxlan wa, xuya chike ri utijoxelabꞌ rech kakiya chike ri winaq. Xujach xuqujeꞌ ri kar chikiwach konojel. ");
INSERT INTO quctt_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Konojel ri winaq xewaꞌik, sibꞌalaj xenojik. ");
INSERT INTO quctt_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ri tijoxelabꞌ xkisikꞌ ronojel ri chꞌaqaꞌp taq kaxlan wa ri xkanajik rachiꞌl ri kar, xkimulij kꞌu kabꞌlajuj chakach. ");
INSERT INTO quctt_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Jobꞌ mil winaq ri xetzuqik. ");
INSERT INTO quctt_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ri Jesús tajin katzijon na kanoq kukꞌ winaq, xuꞌtaq bꞌik ri utijoxelabꞌ rech kebꞌe pa jun jukubꞌ bꞌinibꞌal puꞌwiꞌ ri jaꞌ, kenabꞌej apanoq kebꞌe Betsaida. ");
INSERT INTO quctt_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Are xechꞌabꞌetaj kanoq ri winaq rumal xeꞌ pa ri juyubꞌ, xubꞌana chꞌawem. ");
INSERT INTO quctt_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Xok chaqꞌabꞌ, ri jukubꞌ bꞌinibꞌal puꞌwiꞌ ri jaꞌ kꞌo pa ri unikꞌajil ri plo. Ri Jesús kꞌo na kanoq utukel chuchiꞌ ri plo. ");
INSERT INTO quctt_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Kꞌa kamuquq na are xeꞌril ri tijoxelabꞌ tajin kakibꞌinisaj ri jukubꞌ bꞌinibꞌal rukꞌ chuqꞌabꞌ rumal ri kyaqiqꞌ tajin kuꞌpuyij, ri Jesús kabꞌinik puꞌwiꞌ ri jaꞌ xqebꞌ kukꞌ raj xikꞌow bꞌik chikiwach. ");
INSERT INTO quctt_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ri tijoxelabꞌ are xkilo chi tajin kabꞌin puꞌwiꞌ ri jaꞌ, xkiraq kichiꞌ, pa kikꞌuꞌx chi jun subꞌunel. ");
INSERT INTO quctt_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Sibꞌalaj xkixiꞌj kibꞌ rumal ri xkilo. Ri Jesús aninaq xuꞌchꞌabꞌej, xubꞌij chike: Chixuxlanoq, In waꞌ. Man kixiꞌj ta iwibꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Xaqꞌan kukꞌ pa ri jukubꞌ bꞌinibꞌal, ri kyaqiqꞌ xtaniꞌk, ri tijoxelabꞌ sibꞌalaj xemayijanik. ");
INSERT INTO quctt_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Rumal sibꞌalaj kꞌaxirinaq kikꞌuꞌx chuchomaxik jas ri xbꞌan chukꞌiyirisaxik ri kaxlan wa. ");
INSERT INTO quctt_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Are xqꞌaxetaj ri jaꞌ kumal, xoꞌpan pa ri tinimit Genesaret, xkiya kanoq ri jukubꞌ bꞌinibꞌal chuchiꞌ ri jaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Xeqaj pa ri jukubꞌ bꞌinibꞌal, ri winaq aninaq xkichꞌobꞌ uwach ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ri winaq xkitereneꞌj ri Jesús pa ronojel ri leꞌaj ri xeꞌ wi. Are xkita konojel ri winaq jawjeꞌ kꞌo wi ri Jesús xeꞌkikꞌam bꞌik ri e yawabꞌibꞌ cho ri kichꞌat rech kuꞌkunaj kanoq. ");
INSERT INTO quctt_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Pa taq ri nimaꞌq taq tinimit, nitzꞌ taq tinimit, leꞌaj ri xikꞌow wi ri Jesús, ri winaq xeꞌkiya ri e yawabꞌibꞌ pa taq ri kꞌayibꞌal. Xkita toqꞌobꞌ che ri Jesús rech kuya bꞌe chike kakichap ri umanta. Konojel ri xkichapo kuꞌtzir kanoq. ");
INSERT INTO quctt_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ri fariseos e kachiꞌl ri aꞌjtijabꞌ rech ri taqanik ri kipetik pa Jerusalén xkimulij kibꞌ chrij ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Xkilo chi ri tijoxelabꞌ man xkichꞌaj taj ri kiqꞌabꞌ jetaq ri kinaqꞌatajibꞌal, are xewaꞌik. ");
INSERT INTO quctt_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Are kꞌu ri fariseos xuqujeꞌ ri winaq aꞌj Israel jeꞌ kakibꞌan chuchꞌajik kiqꞌabꞌ jetaq ri kubꞌij ri naqꞌatajibꞌal kech ri e riꞌjabꞌ taq winaq. ");
INSERT INTO quctt_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Are ketzalij loq pa ri kꞌayibꞌal kakichꞌaj nabꞌe ri kiqꞌabꞌ we kakitij jun jastaq. Xuqujeꞌ kakichꞌaj ri qumubꞌal, ri xaruꞌ xuqujeꞌ ri palaꞌt ri e bꞌantal che chꞌichꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Rumal riꞌ, ri fariseos e kachiꞌl ri aꞌjtijabꞌ rech ri taqanik xkita che ri Jesús: ¿Jas che man kakinimaj ta le atijoxelabꞌ ri kubꞌij ri naqꞌatajibꞌal ke ri nimaꞌq taq winaq, man kakichꞌaj ta le kiqꞌabꞌ are kewaꞌik? ");
INSERT INTO quctt_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ri Jesús xubꞌij chike: Qas tzij ri xubꞌij ri Isaías are xutzꞌibꞌaj: We tinimit riꞌ xaq che uchiꞌ kubꞌij chi kinuqꞌijilaꞌj, ri ranimaꞌ naj kꞌo wi chwe. ");
INSERT INTO quctt_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Maj kutayij kinkiqꞌijilaꞌj, ri kikꞌutuꞌn xaq kech achyabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ri ix iwetzelam ri utaqanik ri Dios, are kꞌu tajin kinimaj ri kitaqanik ri achyabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kꞌa te riꞌ xubꞌij: Jeꞌl kibꞌan chunimaxik ri inaqꞌatajibꞌal, are ijelechꞌum kanoq iwibꞌ chunimaxik ri utaqanik ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Chiwilampeꞌ, ri Moisés xubꞌij: Nim chiꞌwila ri itat inan, ri winaq ri keꞌretzelaj ri utat unan kakamisax na. ");
INSERT INTO quctt_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ri ikꞌutuꞌn ix kubꞌij chi ri alkꞌwaꞌlaxel kuyaꞌo kubꞌij chike ri utat unan: “Ri tobꞌanik ri kawaj xinya che alaq xinya che ri Dios.” ");
INSERT INTO quctt_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","We jeriꞌ kubꞌij ri alkꞌwaꞌlaxel man kakwin ta chi riꞌ kuꞌtoꞌ ri utat unan. ");
INSERT INTO quctt_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Jeriꞌ kakꞌulmataj iwukꞌ ix rumal ri naqꞌatajibꞌal ri kikꞌutu, man kinimaj ta chik ri utzij ri Dios, kꞌi jastaq jetaq we riꞌ kibꞌano. ");
INSERT INTO quctt_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Junmul chik ri Jesús xuꞌsikꞌij ri winaq, xubꞌij chike: Chinitatabꞌej iwonojel xuqujeꞌ chichꞌobꞌo we riꞌ: ");
INSERT INTO quctt_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Man are ta kachꞌulujisan ri winaq ri jastaq ri kutijo xane are kachꞌulujisan ri etzelal ri kel loq pa ranimaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ri Jesús xubꞌij: Qas chichomaj rij we tzij riꞌ we xinbꞌij chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Are xtoꞌtaj chubꞌixik we riꞌ, xel bꞌik kukꞌ ri winaq, xok bꞌik pa ri ja, ri utijoxelabꞌ xkita che jas kel kubꞌij chomanik ri xubꞌij. ");
INSERT INTO quctt_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ri Jesús xubꞌij chike: ¿Man kichomaj ta xuqujeꞌ ne lo ix ri kinbꞌij? ¿La man kichomaj chi maj jun jastaq ri kutij ri winaq kakwin chuchꞌulujisaxik? ");
INSERT INTO quctt_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Rumal cher man pa ri ranimaꞌ taj keꞌ wi ri kutijo xane chupam, kꞌa te riꞌ kuꞌchuluj kanoq. Rukꞌ we riꞌ ri Jesús xubꞌij chi ronojel ri jastaq tijowik rij, chꞌajchꞌoj. ");
INSERT INTO quctt_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Xuqujeꞌ xubꞌij: Are kachꞌulujisan ri kel loq che ri winaq. ");
INSERT INTO quctt_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Pa ri ranimaꞌ ri winaq kape wi ri itzel taq chomanik, qꞌoyolem kukꞌ taq achyabꞌ xuqujeꞌ kukꞌ taq ixoqibꞌ, ri kamisanik, ri utzukuxik e kebꞌ ixoqibꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Ri jiqꞌjatik, ri etzelal, ri subꞌunik, ri ubꞌanik etzelal maj uqꞌatexik, ri kꞌax ri kunaꞌ chi jun chirij jun rech winaq, ri bꞌanoj tzij, ri nimal, xuqujeꞌ are man kuya ta ribꞌ ri winaq pa sukꞌumaxik. ");
INSERT INTO quctt_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ronojel we etzelal riꞌ pa ranimaꞌ ri winaq kape wi, are waꞌ ri kachꞌulujin ri ranimaꞌ ri winaq. ");
INSERT INTO quctt_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Xel bꞌik ri Jesús chilaꞌ, xeꞌ pa jun leꞌaj ri kꞌo pa ri tinimit Tiro rachiꞌl Sidón. Xok bꞌik pa jun ja, are xraj maj jun ketaꞌmanik jawjeꞌ kꞌo wi, man xkwin ta kꞌut rawaj ribꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kꞌo jun ixoq aninaq xretaꞌmaj chi xopan ri Jesús chilaꞌ. Ri ixoq kꞌo jun ral ali, kꞌo jun itzel uxlabꞌal che, xopanik xeꞌxukul cho ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ri ixoq aj Fenicia rech ri tinimit Siria xuta toqꞌobꞌ che ri Jesús rech kakunax ri ral. ");
INSERT INTO quctt_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ri Jesús xubꞌij che: Nabꞌe chaya bꞌe chike ri alkꞌwaꞌlaxelabꞌ kewaꞌik, rumal man kuya taj kamaj ri kiwa ri alkꞌwaꞌlaxelabꞌ kakꞌyaq chkiwach ri tzꞌiꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ri ixoq xubꞌij: Jeꞌ tat, ri tzꞌiꞌ kakitij xuqujeꞌ ri uxeꞌr taq kiwa ri alkꞌwaꞌlaxelabꞌ ri katzaq chuxeꞌ ri mexa. ");
INSERT INTO quctt_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ri Jesús xubꞌij che: Rumal jeriꞌ xabꞌan chutzalixik uwach ri xinbꞌij chawe, ri itzel xel bꞌik che ri awal. Jat pa jororemal. ");
INSERT INTO quctt_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Are xopanik ri ixoq cho rachoch, xuꞌriqa ri akꞌal qꞌoyol pa ri uchꞌat. Elinaq chi bꞌik ri itzel uxlabꞌal che. ");
INSERT INTO quctt_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Xel loq ri Jesús pa ri tinimit Tiro, xeꞌ pa Sidón chuxukut ri plo pa Galilea, xkanaj kanoq pa ri tinimit Decápolis. ");
INSERT INTO quctt_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ri Jesús are kꞌo chilaꞌ, xkikꞌam bꞌik jun achi rukꞌ katakꞌtoꞌman kachꞌawik, xkita toqꞌobꞌ che kuya ri uqꞌabꞌ puꞌwiꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ri Jesús xukꞌam bꞌik ri achi utukel, xujut ri uwiꞌ uqꞌabꞌ pa ri uxikin, kꞌa te riꞌ xukoj uchubꞌ cho ri raqꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kꞌa te riꞌ xkaꞌyik cho ri kaj, xujiqꞌaj nim kyaqiqꞌ, kꞌa te riꞌ xubꞌij che ri achi: ¡Efatá! ri kel kubꞌij ¡Chatjaqatajoq! ");
INSERT INTO quctt_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Rukꞌ we riꞌ xjaqataj ri uxikin ri achi xuqujeꞌ xjaqataj ri uchꞌabꞌal, xuchapleꞌj chꞌawem jetaq kachꞌaw jun utz winaq. ");
INSERT INTO quctt_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ri Jesús xubꞌij chike ri winaq chi man kuya taj kakitzijoj ri xkꞌulmatajik, pune xuꞌpixibꞌaj, ri winaq rukꞌ chuqꞌabꞌ xkitzijoj ri xkꞌulmatajik. ");
INSERT INTO quctt_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ri winaq sibꞌalaj xemayijanik, xkibꞌij: Utz kubꞌan chubꞌanik taq le jastaq, kuꞌkunaj ri e tꞌoꞌyabꞌ xuqujeꞌ kuya kichꞌabꞌal ri e memabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Pa taq ri qꞌij riꞌ, sibꞌalaj e kꞌi winaq xkimulij kibꞌ. Rumal ri maj kakitijo, ri Jesús xuꞌsikꞌij riꞌ utijoxelabꞌ xubꞌij chike: ");
INSERT INTO quctt_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Sibꞌalaj kintoqꞌobꞌisaj kiwach we winaq riꞌ rumal xeꞌ oxibꞌ qꞌij e kꞌo wukꞌ maj kiwa kitijom. ");
INSERT INTO quctt_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","We keꞌntaq bꞌik cho taq kachoch kekam waꞌ che numik pa ri bꞌe, rumal maj kiwa kitijom e kꞌo jujun chike naj kepe wi. ");
INSERT INTO quctt_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ri tijoxelabꞌ, xkibꞌij che: ¿Jawjeꞌ keqakꞌama wi kiwa konojel we winaq riꞌ? Naj uj kꞌo wi che ri tinimit. ");
INSERT INTO quctt_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ri Jesús xuta chike: ¿Janipa kaxlan wa kꞌo iwukꞌ? ");
INSERT INTO quctt_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ri Jesús xubꞌij chike ri winaq chi ketꞌuyiꞌ pa ri ulew. Xukꞌam ri wuqubꞌ kaxlan wa, xutyoxij che ri Dios, kꞌa te riꞌ xuya chike ri utijoxelabꞌ rech kakijach chikiwach ri winaq. Jeriꞌ xkibꞌan ri tijoxelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Xuqujeꞌ kꞌo kebꞌ oxibꞌ alaj taq nitzꞌ kar kukꞌ. Xutyoxij xuqujeꞌ ri Jesús che ri Dios, kꞌa te riꞌ xubꞌij chike ri utijoxelabꞌ chi kakijach chikiwach ri winaq. ");
INSERT INTO quctt_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ri winaq xewaꞌik, sibꞌalaj xenojik. Ri tijoxelabꞌ xkimulij na wuqubꞌ chakach chꞌaqaꞌp kaxlan wa. ");
INSERT INTO quctt_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","E kajibꞌ mil ri winaq ri xewaꞌik. Kꞌa te riꞌ xel bꞌik kukꞌ ri winaq. ");
INSERT INTO quctt_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Xeꞌ kukꞌ ri utijoxelabꞌ pa jun jukubꞌ bꞌinibꞌal, xeꞌbꞌe pa ri tinimit Dalmanuta. ");
INSERT INTO quctt_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ri fariseos xoꞌpanik rukꞌ ri Jesús, xkichapleꞌj ukꞌotik uchiꞌ, xkita che jun kꞌutbꞌal rech chikaj. ");
INSERT INTO quctt_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ri Jesús naj xujiqꞌaj ri kyaqiqꞌ, kꞌa te riꞌ xubꞌij: ¿Jas che we winaq riꞌ kakita jun kꞌutbꞌal rech chikaj? Qas tzij kinbꞌij maj kꞌutbꞌal kayaꞌtaj na chike. ");
INSERT INTO quctt_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kꞌa te riꞌ xel bꞌik kukꞌ, xeꞌ pa jun jukubꞌ bꞌinibꞌal, xeꞌ chꞌaqaꞌp che ri kꞌo wi. ");
INSERT INTO quctt_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Xsachan chike ri tijoxelabꞌ xkikꞌam bꞌik kiwa, xa jun kaxlan wa kꞌo bꞌik pa ri jukubꞌ bꞌinibꞌal puꞌwiꞌ ri jaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ri Jesús xubꞌij chike: Qas chichajij iwibꞌ che ri chꞌam kech ri fariseos xuqujeꞌ ri Herodes. ");
INSERT INTO quctt_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ri tijoxelabꞌ xkibꞌij: Jeriꞌ la kubꞌij rumal maj qawa xqakꞌam loq. ");
INSERT INTO quctt_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ri tijoxelabꞌ man xkichꞌobꞌ taj chi are tajin kabꞌix chike ri kꞌutuꞌn kech ri fariseos. Are xril ri Jesús we riꞌ, xubꞌij chike: ¿Jas che kibꞌij chi maj iwa? ¿La man kixkaꞌyik, man kixchomanik? ¿La xa qꞌeqarinaq ri ichomabꞌal? ");
INSERT INTO quctt_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿La xa maj ibꞌoqꞌoch chi rilik, o xa maj ixikin chutayik? ¿La man kanaꞌtaj chiꞌwe? ");
INSERT INTO quctt_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Are xinjach ri kaxlan wa chikiwach ri jobꞌ mil winaq ¿janipa chakach chꞌaqaꞌp ximulij? Kabꞌlajuj, xecha ri tijoxelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Are xinjach chik ri wuqubꞌ kaxlan wa chike ri kajibꞌ mil winaq ¿Janipa chakach chꞌaqaꞌp ximulij? Wuqubꞌ, xecha ri tijoxelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Kꞌisbꞌal rech xubꞌij: ¿La xaq jeꞌ man kichꞌobꞌ taj jas kel kubꞌij ri chꞌam kech ri fariseos? ");
INSERT INTO quctt_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Are xopan ri Jesús pa ri tinimit Betsaida, nikꞌaj winaq xkikꞌam bꞌik jun moy achi rukꞌ xkita toqꞌobꞌ che kuchap kanoq. ");
INSERT INTO quctt_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ri Jesús xukꞌam bꞌik ri moy achi che ri uqꞌabꞌ xel bꞌik pa ri tinimit. Xuchubꞌaj pa ri ubꞌoqꞌoch, xuya ri uqꞌabꞌ puꞌwiꞌ kꞌa te riꞌ xuta che: ¿La kawil chik? ");
INSERT INTO quctt_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ri achi xuwaꞌjilisaj ri ukaꞌyebꞌal xubꞌij: Jeꞌ, keꞌnwil chi ri winaq jer kebꞌantaj cheꞌ kebꞌinik. ");
INSERT INTO quctt_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ri Jesús xuya chik junmul ri uqꞌabꞌ puꞌwiꞌ ri uꞌbꞌoqꞌoch ri achi, kꞌa te riꞌ xkunatajik. Ri achi xkꞌayik xuchapleꞌj rilik ri jastaq jacha kubꞌan jun utz uwach winaq. ");
INSERT INTO quctt_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ri Jesús xutaq bꞌik ri achi cho rachoch, xubꞌij bꞌik che: Man katok ta chi bꞌik pa le tinimit xuqujeꞌ man katzijoj ta chike ri winaq jas ri xkꞌulmataj awukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ri Jesús e rachiꞌl ri utijoxelabꞌ xebꞌe pa taq ri leꞌaj rech Cesarea rech Filipo. E bꞌenaq pa ri bꞌe are xuta chike: ¿In jachin in kakibꞌij ri winaq? ");
INSERT INTO quctt_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ri tijoxelabꞌ xkibꞌij: E jujun kakibꞌij chi lal Juan Bꞌanal qasanaꞌ, e jujun chik kakibꞌij chi lal lal Elías, e nikꞌaj chik kakibꞌij chi lal la jun chike ri e qꞌalajisal taq utzij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ri Jesús xubꞌij chike: ¿Jas kibꞌij ix? ¿In jachin ri in? Ri Pedro xubꞌij: Lal, lal Mesías. ");
INSERT INTO quctt_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ri Jesús xubꞌij chike chi man kakitzijoj ta chik che jun winaq jachin ri areꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kꞌa te riꞌ xuchapleꞌj uyaꞌik kꞌutuꞌn, xubꞌij: Ri uKꞌojol ri Achi kuriq na kꞌax, ketzelax na uwach kumal ri kꞌamal taq kibꞌe ri winaq, kumal ri kinimaꞌqil ri e chꞌawenelabꞌ cho ri Dios xuqujeꞌ ri aꞌjtijabꞌ rech ri taqanik. Sibꞌalaj choqꞌaqꞌ kꞌu wi kakamisax na, xuqujeꞌ kakꞌastaj na uwach churox qꞌij. ");
INSERT INTO quctt_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ri Jesús qas kꞌyaqal xubꞌan chubꞌixik, rumal riꞌ ri Pedro xusikꞌij bꞌik pa utukel pa jun kꞌolibꞌal xuchapleꞌj uyajik. ");
INSERT INTO quctt_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Xtzalqꞌomij ri Jesús, xuꞌkaꞌyej ri utijoxelabꞌ, kꞌa te riꞌ xuyaj ri Pedro xubꞌij: Itzel, chatel chinuwach. Man are ta kachomaj at ri jastaq rech ri Dios xane are ri kech ri achyabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kꞌa te riꞌ xuꞌsikꞌij ri winaq rachiꞌl ri utijoxelabꞌ xubꞌij chike: We kꞌo ne jun karaj kuxik nutijoxel, chukꞌekꞌej ribꞌ, reqaj ri cheꞌ ripbꞌal xuqujeꞌ chinutereneꞌj. ");
INSERT INTO quctt_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Jeriꞌ rumal ri winaq ri karaj kukol ri ukꞌaslemal, kutzaq na riꞌ, are kꞌu ri kutzaq ri ukꞌaslemal xa rumal we xuqujeꞌ rumal rech ri utz laj tzij, kukol na riꞌ ri ukꞌaslemal. ");
INSERT INTO quctt_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Jas kutayij che ri winaq kuchꞌek ronojel ri qꞌinomal rech uwachulew, we man kakwinik kukol ri ukꞌaslemal? ");
INSERT INTO quctt_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Jas kakwin jun kuya cho ri ukꞌaslemal? ");
INSERT INTO quctt_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","We kꞌo jun kukꞌixibꞌej nuqꞌalajisaxik xuqujeꞌ utzijoxik ri nutzij chike we itzel taq winaq aꞌjmakibꞌ rech we qꞌij kamik. Ri uKꞌojol ri Achi kakꞌix na che we winaq riꞌ are kape pa ri ujuluwem ri utat e rachiꞌl ri tyoxalaj taq rangelibꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Te kꞌu riꞌ xubꞌij: Qas tzij kinbꞌij chiꞌwe, e kꞌo jujun chike ri e kꞌo chanim man kekam ta na we man nabꞌe kakil ri rulik ri ajawarem rech ri Dios ri kape na rukꞌ kwinem. ");
INSERT INTO quctt_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ikꞌowinaq chi waqibꞌ qꞌij che we riꞌ, ri Jesús xusikꞌij bꞌik ri Pedro, ri Jacobo, ri Juan, xebꞌe rukꞌ puꞌwiꞌ jun nimalaj juyubꞌ. Chilaꞌ xkꞌexkꞌobꞌ wi ri ukaꞌyibꞌal ri Jesús chikiwach ri xebꞌe rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ri ratzꞌyaq sibꞌalaj xrepqꞌunik, maj jun winaq choch ri uwachulew ri xkwin ta ne chubꞌanik we riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Xuqujeꞌ xkikꞌut kibꞌ ri Elías rachiꞌl ri Moisés tajin ketzijon rukꞌ ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ri Pedro xubꞌij che ri Jesús: Ajtij, utz uj kꞌo waral, kujkwinik kaqabꞌan oxibꞌ alaj taq ja: jun e la, jun rech le Moisés, xuqujeꞌ jun rech le Elías. ");
INSERT INTO quctt_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Xubꞌij we riꞌ xa rumal xibꞌin ibꞌ, man qas ta xuchomaj ri xubꞌij. ");
INSERT INTO quctt_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kꞌa te riꞌ xpe jun sutzꞌ, xuꞌchꞌuq konojel. Xpe jun chꞌabꞌal chupam, xubꞌij: Are waꞌ ri loqꞌalaj nukꞌojol. Chitatabꞌej. ");
INSERT INTO quctt_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Are xekaꞌylobꞌik, xaq xwi xkil chi uwach ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Are tajin keqaj loq puꞌwiꞌ ri juyubꞌ, ri Jesús xubꞌij chike chi man kakitzijoj ta chi che jun winaq ri xkilo, kꞌa te kuyaꞌo kakitzijoj are kakꞌastaj ri uKꞌojol ri Achi chikixoꞌl ri kaminaqibꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Xkikꞌol pa kanimaꞌ, xa kꞌu kakitatabꞌela la chibꞌil taq kibꞌ jas kel kubꞌij are xubꞌij chi kawaꞌjil chikixoꞌl ri kaminaqibꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ri tijoxelabꞌ xkita che ri Jesús: ¿Jas che ri aꞌjtijabꞌ rech ri taqanik kakibꞌij chi nabꞌe kape na ri Elías? ");
INSERT INTO quctt_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ri Jesús xubꞌij: Qas tzij wi, ri Elías are kape nabꞌe chusukꞌumaxik ronojel ri jastaq. ¿Jas ta kꞌu che tzꞌibꞌatalik chi ri uKꞌojol ri Achi kuriq na kꞌax xuqujeꞌ ketzelax na uwach? ");
INSERT INTO quctt_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kinbꞌij chiꞌwe chi ri Elías xpe kanoq, ri winaq xkibꞌan che ronojel ri xkaj, jetaq ri tzꞌibꞌatalik. ");
INSERT INTO quctt_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Are xoꞌpan kukꞌ ri nikꞌaj tijoxelabꞌ chik, xeꞌkil sibꞌalaj e kꞌi winaq xuqujeꞌ aꞌjtijabꞌ rech ri taqanik tajin kakibꞌan chꞌoꞌj pa tzij kukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ri winaq are xkil ri Jesús kexikꞌanik xebꞌe chuyaꞌik rutzil uwach. ");
INSERT INTO quctt_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ri Jesús xuta chike: ¿Jas tajin kichꞌoꞌjij kukꞌ? ");
INSERT INTO quctt_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Jun achi kꞌo chikixoꞌl ri winaq xubꞌij che ri Jesús: Ajtij, xinkꞌam loq ri nukꞌojol choch la rumal kꞌo jun itzel uxlabꞌal che, man kuya ta bꞌe che kachꞌawik. ");
INSERT INTO quctt_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Are kukoj uchuqꞌabꞌ ri itzel uxlabꞌal che, katzaq pa ri ulew, kawusuw upuꞌchiꞌ, kuqutꞌutꞌej ri uware. Xinbꞌij chike le tijoxelabꞌ la kakesaj bꞌik ri itzel uxlabꞌal che, man xekwin ta che. ");
INSERT INTO quctt_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ri Jesús xubꞌij: ¡kꞌax iwe ix winaq ri maj ikojobꞌal che ri Dios, naj chik in kꞌo iwukꞌ! ¿Jampaꞌ xaq in kꞌo iwukꞌ? ¿La xaq kinkochꞌ in ri kibꞌano? Chikꞌama loq ri ala. ");
INSERT INTO quctt_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Xkikꞌam bꞌik ri ala rukꞌ. Ri itzel uxlabꞌal xutzaq ri ala pa ri ulew, xuchapleꞌj bꞌalkaꞌtik, kawusuw ri upuꞌchiꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ri Jesús xuta che ri utat ri ala: ¿Jampaꞌ xuchapleꞌj we kꞌax riꞌ che we ala? Ri achi xubꞌij: Pa ri ralkꞌaꞌlal. ");
INSERT INTO quctt_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ri itzel uxlabꞌal kꞌi mul raj ukamisam we ala. Utzaqom pa ri qꞌaqꞌ xuqujeꞌ pa ri jaꞌ. We kakwin la, kujtoꞌ la. Cheꞌl kuꞌx la chaqe. ");
INSERT INTO quctt_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ri Jesús xubꞌij: ¿Jamo riꞌ kabꞌij we kakwin laꞌ? Ronojel keꞌ ubꞌanik rukꞌ ri winaq ri kakojon che ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ri utat ri ala aninaq xubꞌij: Kinkojonik che ri Dios, chintoꞌ la rukꞌ ri nukojobꞌal. ");
INSERT INTO quctt_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Are xril ri Jesús chi tajin kakimulij kibꞌ kꞌi winaq, xubꞌij che ri itzel uxlabꞌal: At uxlabꞌal ri kabꞌan tꞌoꞌy, mem che we ala riꞌ, chatel bꞌik, man katok ta chik che. ");
INSERT INTO quctt_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ri uxlabꞌal xuraqaqej uchiꞌ, xubꞌirirej ri ala rukꞌ chuqꞌabꞌ, kꞌa te riꞌ xel bꞌik che. Ri ala raj xkamik cher xbꞌantajik, e kꞌi winaq xkibꞌij: Xkam le ala. ");
INSERT INTO quctt_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ri Jesús kꞌut xuchap ri ala che ri uqꞌabꞌ, xuwaꞌjilisaj. Ri ala xwaꞌjilik, xtakꞌiꞌk. ");
INSERT INTO quctt_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Are xok bꞌik ri Jesús pa ri ja e rachiꞌl ri utijoxelabꞌ, xkita che xaq pa utukel: ¿Jas che man xujkwin taj uj xqesaj bꞌik ri itzel uxlabꞌal? ");
INSERT INTO quctt_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Xubꞌij ri Jesús chike: We itzel uxlabꞌal riꞌ xwi kel bꞌik we kibꞌan chꞌawem. ");
INSERT INTO quctt_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Xel bꞌik pa ri leꞌaj riꞌ, xiꞌkꞌow bꞌik pa Galilea. Are karaj ri Jesús maj jachin ketaꞌmanik jawjeꞌ kꞌo wi. ");
INSERT INTO quctt_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Jeriꞌ rumal tajin kubꞌij chike ri utijoxelabꞌ: Ri uKꞌojol ri Achi kajach na pa kiqꞌabꞌ ri achyabꞌ. Kakamisax na, churox qꞌij kꞌut kakꞌastaj na. ");
INSERT INTO quctt_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ri tijoxelabꞌ man xkichomaj taj jas xraj xubꞌij rukꞌ we riꞌ, xkixiꞌj kibꞌ xkita che jas xraj xubꞌij. ");
INSERT INTO quctt_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Xoꞌpan pa Capernaúm. Are kꞌo chi pa ri ja, xuta ri Jesús chike: ¿Jas ri tajin kitzijoj loq are ix petinaq pa ri bꞌe? ");
INSERT INTO quctt_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ri tijoxelabꞌ man xechꞌaw taj, rumal pa ri bꞌe are xkitzijoj la rij jachin ri nim uqꞌij. Rumal pa kijujunal kakinaꞌo chi e nimaꞌq chikiwach ri e kachiꞌl. ");
INSERT INTO quctt_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ri Jesús xtꞌuyiꞌk, xusikꞌij ri kabꞌlajuj utijoxelabꞌ, xubꞌij chike: We kꞌo jun karaj kok che nabꞌe chike konojel ri winaq, rajawaxik kux na kꞌisbꞌal chike konojel xuqujeꞌ patanil ke konojel. ");
INSERT INTO quctt_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Kꞌa te riꞌ xukꞌam jun akꞌal xuya chikixoꞌl, kꞌa te riꞌ xuqꞌaluj xubꞌij chike: ");
INSERT INTO quctt_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Ri kukꞌamawaꞌj jun chike we akꞌalabꞌ riꞌ pa nubꞌiꞌ, in kinukꞌamawaꞌj, ri kinukꞌamawaꞌj in, man in taj kinukꞌamawaꞌj xane are kukꞌamawaꞌj ri xintaqow loq. ");
INSERT INTO quctt_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ri Juan xubꞌij: Ajtij, xqil jun winaq tajin keꞌresaj itzel taq uxlabꞌal pa ri bꞌiꞌ la, xqaqꞌil kanoq rumal man qachiꞌl taj. ");
INSERT INTO quctt_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ri Jesús xubꞌij: Man kiqꞌil taj, maj jun winaq kubꞌan mayijabꞌal taq jastaq pa ri nubꞌiꞌ, kꞌa te riꞌ itzel katzijon chwe. ");
INSERT INTO quctt_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ri man qakꞌulel taj qachiꞌl riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Qas tzij kinbꞌij chiꞌwe, xapachin ri kusipaj juqubꞌ jaꞌ pa ri nubꞌiꞌ, katoj na ukꞌaxel che. ");
INSERT INTO quctt_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","We kꞌo jun kutaqchiꞌj pa mak jun chike we alaj taq nitzꞌ riꞌ, are katanik kajatꞌix jun abꞌaj kebꞌal chuqul, kakꞌyaq bꞌik kꞌa pa ukꞌuꞌx ri plo. ");
INSERT INTO quctt_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Je xuqujeꞌ we are ri aqꞌabꞌ katutaqchiꞌj pa mak, chasakꞌij. Are katanik katok pa ri jun alik kꞌaslemal, xa jun aqꞌabꞌ cho ri kateꞌ pa ri tyoꞌnel qꞌaqꞌ ri man kachup taj, rukꞌ ukobꞌchal aqꞌabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","/Ri tyoꞌnel qꞌaqꞌ man kachup ta wi xuqujeꞌ ri winaq man kakam taj chupam./ ");
INSERT INTO quctt_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","We are ri awaqan kattaqchiꞌn pa mak, chasakꞌij. Are katanik katok pa ri kaj, maj jun awaqan cho ri kakꞌyaq bꞌik pa ri tyoꞌnel qꞌaqꞌ rukꞌ ukobꞌchal awaqan. ");
INSERT INTO quctt_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","/Chilaꞌ kꞌut man kakam ta wi ri winaq xuqujeꞌ man kachup taj ri qꞌaqꞌ./ ");
INSERT INTO quctt_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","We are ri abꞌoqꞌoch kattaqchiꞌn pa mak, chawesaj. Are katanik katok pa ri ajawarem rech ri Dios xa jun abꞌoqꞌoch cho ri katkꞌyaq bꞌik pa ri tyoꞌnel qꞌaqꞌ rukꞌ ukobꞌchal abꞌoqꞌoch. ");
INSERT INTO quctt_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Chilaꞌ man kakꞌis ta wi ri kꞌaxkꞌolal che ri winaq xane kuriq kꞌax chibꞌe qꞌij saq, rumal man kachup ta wi ri qꞌaqꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ri qꞌaqꞌ are je kel ri atzꞌam ri kayoꞌw utzayil ronojel. ");
INSERT INTO quctt_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Utz ri atzꞌam, are kꞌu we kelik ri utzayil ¿jas kabꞌan riꞌ chutzalixik ri utzayil? Man kakꞌis ta bꞌa ri iwatzꞌamil rech kixkꞌojiꞌk pa jaꞌmaril kukꞌ konojel ri winaq. ");
INSERT INTO quctt_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Xel bꞌik ri Jesús pa ri tinimit ri kꞌo wi, xeꞌ pa ri tinimit ri kꞌo pa Judea chꞌaqaꞌp che ri Jordán. Junmul chik xkimulij kibꞌ winaq, ri Jesús xuchapleꞌj chik uyaꞌik kꞌutuꞌn chikiwach jacha ri naqꞌatal che kubꞌano. ");
INSERT INTO quctt_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Xoꞌpan nikꞌaj fariseos, xeqet rukꞌ ri Jesús chubꞌixik jun kꞌaꞌmabꞌal che, xkibꞌij: ¿La yaꞌtal che jun achi kujach ri rixoqil? ");
INSERT INTO quctt_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ri Jesús xubꞌij chike: ¿Jas kubꞌij ri utaqanik ri Moisés rajawaxik kibꞌano? ");
INSERT INTO quctt_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ri fariseos xkibꞌij: Ri Moisés xuya bꞌe chi utz katzꞌibꞌax jun wuj jawjeꞌ kubꞌij wi chi xjach ri ixoq, kꞌa te riꞌ kesax bꞌik ri ixoq rumal ri achi. ");
INSERT INTO quctt_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ri Jesús xubꞌij: Ri taqanik riꞌ are ri Moisés xtzꞌibꞌanik rumal man kiwaj taj kixnimanik. ");
INSERT INTO quctt_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Man je ta riꞌ ubꞌanik are xtiktaj loq ronojel, ri Dios xutik ri achi xuqujeꞌ ri ixoq. ");
INSERT INTO quctt_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Rumal riꞌ, ri achi kuya kanoq ri utat xuqujeꞌ ri unan keꞌ rukꞌ ri rixoqil, ");
INSERT INTO quctt_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","rech xa jun tyoꞌjal kuꞌxik.” Jeriꞌ man e kebꞌ ta chik xane xa e jun chik. ");
INSERT INTO quctt_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Xaq jeriꞌ ri xunukꞌ ri Dios man kuya taj kujach ri achi. ");
INSERT INTO quctt_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Are xoꞌpan cho ri ja, ri tijoxelabꞌ xkita che ri Jesús jas kel kubꞌij we jastaq riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ri Jesús xubꞌij: Ri kujach rixoqil kꞌa te riꞌ kakꞌuliꞌk chik rukꞌ jun ixoq chik e kebꞌ rixoqil xuqujeꞌ xmakunik rukꞌ ri nabꞌe. ");
INSERT INTO quctt_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","We are ri ixoq kujach rachajil kꞌa te riꞌ kakꞌuliꞌk chik rukꞌ jun achi chik, kamakunik. ");
INSERT INTO quctt_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ri winaq xeꞌkikꞌam bꞌik akꞌalabꞌ rukꞌ ri Jesús rech kuꞌchapo, ri e tijoxelabꞌ kꞌut xeꞌkiyaj ri e kꞌamowinaq bꞌik. ");
INSERT INTO quctt_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Are xril ri Jesús ri xkꞌulmatajik, xyojtajik xubꞌij chike ri utijoxelabꞌ: Man kiꞌqꞌatej ta ri akꞌalabꞌ kepe wukꞌ, chiya bꞌe chike, rumal aꞌreꞌ kechꞌabꞌen na ri ajawarem rech ri Dios ri kakubꞌiꞌ kikꞌuꞌx chirij ri Dios jetaq ri kakibꞌan ri akꞌalabꞌ kakubꞌiꞌ kikꞌuꞌx chirij ri kitat kinan. ");
INSERT INTO quctt_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Qas tzij kinbꞌij chiꞌwe, ri man kukꞌamawaꞌj ta ri ajawarem rech ri Dios jetaq kabꞌan chukꞌamawaꞌxik jun laj nitzꞌ akꞌal man kakwin ta riꞌ kok chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ri Jesús xuqꞌaluj ri akꞌalabꞌ, kꞌa te riꞌ xuya ri uqꞌabꞌ pa kiwiꞌ xuꞌtewechiꞌj. ");
INSERT INTO quctt_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Bꞌenam kubꞌan ri Jesús are kaxikꞌan jun achi xopan rukꞌ, xukiꞌk choch, xubꞌij: Utz laj ajtij, ¿jas rajawaxik kinbꞌano rech kinwechabꞌej ri jun alik kꞌaslemal? ");
INSERT INTO quctt_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ri Jesús xubꞌij che ri ala: ¿Jas che kabꞌij utz chwe? ¡Man kꞌo ta jun qas utz, xane xaq xwi ri Dios! ");
INSERT INTO quctt_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Awetaꞌm chik ri taqanik kubꞌij: Matkamisanik, matzukuj kebꞌ awixoqil, man katelaqꞌ taj, man kabꞌan ta bꞌanoj tzij chirij jun chik, man kabꞌan ta etzelal che jun winaq chik, nim chaꞌwila ri atat anan. ");
INSERT INTO quctt_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Xubꞌij ri achi: Ronojel we riꞌ nuchapleꞌm loq ubꞌanik pa ri walkꞌaꞌlal. ");
INSERT INTO quctt_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ri Jesús ko xukaꞌyej ri achi, kꞌa te riꞌ rukꞌ loqꞌanik xubꞌij che: Xa jun jastaq chik kajawatajik kabꞌano: jaꞌkꞌayij ronojel ri kꞌo awukꞌ, kꞌa te riꞌ chasipaj ri pwaq chike ri e mebꞌaibꞌ rech kayaꞌtaj aqꞌinomal chilaꞌ chikaj, kꞌa te riꞌ chatan loq chinatereneꞌj xuqujeꞌ chawetaꞌmaj awe ri kinbꞌano. ");
INSERT INTO quctt_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ri achi are xuta we riꞌ xkꞌaxkꞌobꞌ ranimaꞌ, kabꞌisonik xeꞌ cho rachoch rumal sibꞌalaj kꞌi uqꞌinomal kꞌolik. ");
INSERT INTO quctt_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Xkaꞌyilobꞌ ri Jesús, kꞌa te riꞌ xubꞌij chike ri utijoxelabꞌ sibꞌalaj kꞌax kakiriq ri qꞌinomabꞌ koꞌk pa ri ajawarem rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ri tijoxelabꞌ xemayijanik che ri xubꞌij ri Jesús. Junmul chik xubꞌij: Walkꞌwaꞌl, sibꞌalaj kꞌax okem pa ri ajawarem rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Are man kꞌax taj kubꞌan jun kamey kok pa ri ujolom ri bꞌaq tꞌisoꞌmabꞌal cho jun qꞌinom kok pa ri ajawarem rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Xnimataj ri kimayijanik ri tijoxelabꞌ rumal riꞌ xkichapleꞌj ubꞌixik chibꞌil taq kibꞌ we jeriꞌ ¿jachin kakwinik kukol ribꞌ? ");
INSERT INTO quctt_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ri Jesús ko xuꞌkaꞌyej xubꞌij chike: Ri Dios kakwinik chubꞌanik ri man kekwin ta ri achyabꞌ che. ");
INSERT INTO quctt_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Xubꞌij ri Pedro che ri Jesús: ¿Jas kakꞌulmataj qukꞌ uj, ri qayaꞌom kanoq ronojel ri qajastaq rumal tereneꞌxik la? ");
INSERT INTO quctt_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ri Jesús xubꞌij: Qas tzij kinbꞌij chiꞌwe: ri utzaqom kanoq rachoch, e rachalal, e ranabꞌ, utat unan, e ralkꞌwaꞌl xuqujeꞌ rulew xa rumal ri utz laj tzij ");
INSERT INTO quctt_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kukꞌamawaꞌj na ciento mul ukꞌaxel pa taq we qꞌij junabꞌ riꞌ rachoch, e rachalal, e ranabꞌ, uꞌnan, uꞌkꞌojol, e rulew pune kuriq kꞌax rukꞌ. Xuqujeꞌ pa ri qꞌotaj ri kape na, kukꞌamawaꞌj ri jun alik kꞌaslemal. ");
INSERT INTO quctt_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","E kꞌi winaq sibꞌalaj nimaꞌq kakinaꞌo choch ri uwachulew xa kꞌu maj kiqꞌij kaya na pa ri ajawarem rech ri Dios xuqujeꞌ e kꞌo man nimaꞌq taj kakinaꞌo are e kꞌo cho ri uwachulew xa kꞌu nimaꞌq na kiꞌlik pa ri ajawarem rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","E bꞌenaq pa ri bꞌe, e paqal pa Jerusalén, ri Jesús xnabꞌej bꞌik chikiwach. Ri e tijoxelabꞌ sibꞌalaj xemayijanik, ri nikꞌaj chik ri e teren loq xkixiꞌj kibꞌ. Ri Jesús xuꞌsikꞌij ri e kabꞌlajuj utijoxelabꞌ xaq kitukel xubꞌij chike ri kakꞌulmatajik, xubꞌij: ");
INSERT INTO quctt_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Chanim kujeꞌ pa Jerusalén, chilaꞌ kajach wi na ri uKꞌojol ri Achi pa kiqꞌabꞌ ri e kꞌamal taq kibꞌe ri e chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq xuqujeꞌ ri aꞌjtijabꞌ rech ri taqanik. Kakiqꞌat na tzij puꞌwiꞌ rech kakamisaxik xuqujeꞌ kajach na pa kiqꞌabꞌ ri winaq ri man aꞌj Israel taj. ");
INSERT INTO quctt_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ketzelax na uwach, kachubꞌax na upalaj, karapux na xuqujeꞌ kakamisax na. Churox qꞌij kꞌut kakꞌastaj na. ");
INSERT INTO quctt_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ri Juan xuqujeꞌ ri Jacobo e ralkꞌwaꞌl ri Zebedeo, xeqet rukꞌ ri Jesús xkibꞌij che: Ajtij, kaqaj chi kaya la chaqe ri kaqata che la. ");
INSERT INTO quctt_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ri Jesús xubꞌij: ¿Jas kiwaj kinbꞌan iwukꞌ? ");
INSERT INTO quctt_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Jun chike xubꞌij: Ya la bꞌe chaqe chi pa ri ajawarem la ri kajuluwik jun chaqe katꞌuyiꞌ na pa ri wiqiqꞌabꞌ la xuqujeꞌ jun pa ri mox la. ");
INSERT INTO quctt_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ri Jesús xubꞌij: Man iwetaꞌm taj ri kitoqꞌij ¿La kiqꞌiꞌ ix ri kꞌax ri kinriq na in? ¿La kiqꞌiꞌ ix ri kamikal ri kinriq na in? ");
INSERT INTO quctt_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ri aꞌreꞌ xkibꞌij: Kujkwinik. Ri Jesús xubꞌij chike: Kixkwin riꞌ kiqꞌiꞌ ri kꞌaxal ri kinriq in xuqujeꞌ ri kamikal ri kinriq na in ");
INSERT INTO quctt_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","are kꞌu ri uyaꞌik chiꞌwe chi kixtꞌuyiꞌk pa ri nuwiqiqꞌabꞌ xuqujeꞌ pa ri numox man in taj kabꞌan we puꞌwiꞌ. Chomatal chi riꞌ nabꞌe kanoq jachin ajchoqꞌe ri kꞌolibꞌal riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Are xkita ri e lajuj ri xkꞌulmatajik xeyojtaj chikij ri Jacobo xuqujeꞌ ri Juan. ");
INSERT INTO quctt_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ri Jesús xuꞌsikꞌij xubꞌij chike: Iwetaꞌm ix, ri winaq ri kakinaꞌo e kꞌamal taq bꞌe kech ri tinimit xuqujeꞌ ri nimaꞌq kibꞌanik pa ri tinimit keꞌkibꞌan kꞌax chike ri e kiwinaq. ");
INSERT INTO quctt_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Man yaꞌtal ta kꞌut jeriꞌ kakꞌulmataj iwukꞌ ix, ri karaj kux nabꞌyal chiꞌxoꞌl are rajawaxik kux patanil iwe. ");
INSERT INTO quctt_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Xuqujeꞌ ri karaj kux nim uqꞌij chike konojel rajawaxik kux kajchak konojel. ");
INSERT INTO quctt_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Jeriꞌ, rumal man ne xpe ta ri uKꞌojol ri Achi rech kapatanixik xane xpetik chuyaꞌik ri ukꞌaslemal che kikolik sibꞌalaj e kꞌi winaq. ");
INSERT INTO quctt_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kꞌa te riꞌ xoꞌpan pa ri tinimit Jericó. Bꞌenam kubꞌan ri qꞌij are xel bꞌik ri Jesús pa Jericó e rachiꞌl ri utijoxelabꞌ xuqujeꞌ sibꞌalaj e kꞌi winaq. Kꞌo jun moy kuta ulimoxna ubꞌiꞌ Bartimeo (ralkꞌwaꞌl ri Timeo) tꞌuyul chuchiꞌ ri bꞌe. ");
INSERT INTO quctt_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Are xuto chi petinaq ri Jesús aj Nazaret, xuchapleꞌj uraqik uchiꞌ xubꞌij: Jesús, Ralkꞌwaꞌl ri David, cheꞌl kuꞌx la chwe. ");
INSERT INTO quctt_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","E kꞌi xkiyajo rech kataniꞌk, man xtaniꞌ ta kꞌut xane ko xuraq uchiꞌ xubꞌij: Ralkꞌwaꞌl ri David, cheꞌl kuꞌx la chwe. ");
INSERT INTO quctt_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Xtakꞌiꞌ ri Jesús, xubꞌij: Chichꞌabꞌej apanoq. Xaq jeriꞌ xkichꞌabꞌej apanoq. Xkibꞌij che: Chatkiꞌkotoq, katusikꞌij le Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ri achi xukꞌyaq kanoq ri uqꞌuꞌ, xchꞌoplajik, xqebꞌ loq rukꞌ ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ri Jesús xuta che: ¿Jas kawaj kinbꞌan awukꞌ? Ri moy achi xubꞌij: Ajtij, kawaj kinkaꞌyik. ");
INSERT INTO quctt_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ri Jesús xubꞌij che: Ri akojobꞌal xatukunaj, utz chik kateꞌek. Aninaq xkaꞌy chi junmul ri achi, xuchapleꞌj utereneꞌxik ri Jesús pa ri bꞌe. ");
INSERT INTO quctt_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Are xoꞌpan pa Betfagé xuqujeꞌ pa Betania, chunaqaj ri tinimit Jerusalén puꞌwiꞌ ri juyubꞌ Olivos, ri Jesús xuꞌtaq bꞌik e kebꞌ chike ri utijoxelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Xubꞌij chike: Jix pa ri leꞌaj ri kꞌo apanoq chiqawach. Chilaꞌ kiꞌriqa wi jun laj nitzꞌ bꞌur, jatꞌital kanoq ri maj jun winaq kejeninaq. Chikiraꞌ, kꞌa te riꞌ chikꞌama loq. ");
INSERT INTO quctt_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","We kꞌo jun katow chiꞌwe: “¿Jas che je laꞌ kibꞌano?” chibꞌij che “Xa kajawataj che ri Ajawxel, kꞌa te kutzalij.” ");
INSERT INTO quctt_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ri tijoxelabꞌ xeꞌkiriqa ri bꞌur jatꞌital kanoq pa ri bꞌe chuchiꞌ jun nim uchiꞌ ja, xkikir loq. ");
INSERT INTO quctt_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Jujun chike ri e kꞌo chilaꞌ xkita chike: ¿Jas che tajin kikir le bꞌur? ");
INSERT INTO quctt_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ri tijoxelabꞌ xkibꞌij chike jas ri ubꞌim bꞌik ri Jesús chike, jeriꞌ xya bꞌe chike kumal ri winaq xkikir loq ri bꞌur. ");
INSERT INTO quctt_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Xkikꞌam bꞌik ri kꞌin laj nitzꞌ bꞌur rukꞌ ri Jesús, xkiya ri e kimanta chrij ri bꞌur, kꞌa te riꞌ xkejen ri Jesús chirij. ");
INSERT INTO quctt_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","E kꞌi xkilikꞌ ri kimanta pa ri bꞌe, e nikꞌaj chik xkiya uqꞌabꞌ taq cheꞌ pa ri bꞌe ri kikꞌamom loq pa taq ri juyubꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ri winaq ri e nabꞌe xuqujeꞌ ri e terenik xkiraq kichiꞌ xkibꞌij: ¡Hosanna! ¡Tewchiꞌtal ubꞌiꞌ ri petinaq pa ri ubꞌiꞌ ri Ajawxel! ");
INSERT INTO quctt_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Tewchiꞌtal ri ajawarem rech ri qatat David ri petinaq pa taq we qꞌij riꞌ! ¡Yoꞌq nimal uqꞌij! ");
INSERT INTO quctt_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Are xok bꞌik ri Jesús pa Jerusalén, xeꞌ pa ri Templo. Are xiltaj kanoq ronojel rumal, bꞌenaq chik ri qꞌij, xeꞌ pa ri tinimit Betania e rachiꞌl ri kabꞌlajuj utijoxelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Chukabꞌ qꞌij, are kelik loq pa Betania, ri Jesús xnumik. ");
INSERT INTO quctt_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Xril apanoq jun ucheꞌal higuera ri kꞌo uxaq, xeꞌrilaꞌ kꞌut we kꞌo uwach. Are xopan rukꞌ ri cheꞌ xaq xwi uxaq xuꞌriqaꞌ, maj uwach rumal majaꞌ kuriq ri qꞌij kawachin ri higos. ");
INSERT INTO quctt_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ri Jesús xubꞌij che ri ucheꞌal higos: Maj chi jun kutzukuj higos chawe, ri tijoxelabꞌ xkita ri xubꞌij ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Are xoꞌpan pa ri tinimit Jerusalén, ri Jesús xok bꞌik pa ri Templo, xuchapleꞌj kesaxik loq ri winaq ri aꞌjkꞌayibꞌ xuqujeꞌ ri tajin keloqꞌoꞌmanik. Xuwolqotij bꞌik ri kimexa ri tajin kakikꞌex pwaq xuqujeꞌ ri kikꞌolibꞌal ri aꞌjkꞌayibꞌ taq palomax. ");
INSERT INTO quctt_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Man xuya ta bꞌe che xa ta ne jun kukoj bꞌik ukꞌay pa ri Templo. ");
INSERT INTO quctt_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Xuqujeꞌ xubꞌij chike we tzij riꞌ: La man iwetaꞌm ri tzꞌibꞌatalik kubꞌij: Ri wachoch bꞌanbꞌal chꞌawem kech konojel ri winaq ri kepe pa ronojel ri uwachulew.Ix kꞌut ibꞌanom kijul eleqꞌomabꞌ che. ");
INSERT INTO quctt_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Are xkita ri e kꞌamal taq kibꞌe ri e chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq xuqujeꞌ ri aꞌjtijabꞌ rech ri taqanik, xkitzukuj jas jeꞌ kakibꞌan chukamisaxik, rumal kakixiꞌj kibꞌ choch jeriꞌ rumal ri winaq kemayijanik che ronojel ri ukꞌutuꞌn. ");
INSERT INTO quctt_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Are xeꞌ ri qꞌij, ri Jesús e rachiꞌl ri utijoxelabꞌ xeꞌl bꞌik pa ri tinimit. ");
INSERT INTO quctt_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Che ri aqꞌabꞌil are xiꞌkꞌow bꞌik chuxukut ri ucheꞌal ri higos, xkilo chi xchaqiꞌjar ri ukꞌaꞌmal ri cheꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Xnaꞌtaj che ri Pedro ri ubꞌim kanoq ri Jesús, xubꞌij che: Ajtij, chilampe la, xchaqiꞌjar le ucheꞌal le higos le xetzelaj la kanoq uwach. ");
INSERT INTO quctt_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ri Jesús xubꞌij chike ri utijoxelabꞌ: ¡Chixkojonoq che ri Dios! ");
INSERT INTO quctt_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Qas tzij kinbꞌij chiꞌwe, we kꞌo jun kubꞌij che we jun juyubꞌ riꞌ: “Chatel bꞌik chilaꞌ, jat pa le plo, qas kukojo ri kubꞌij man kakabꞌalaj ta ukꞌuꞌx che, kakꞌulmataj na ri kubꞌij.” ");
INSERT INTO quctt_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Rumal riꞌ kinbꞌij chiꞌwe are kibꞌan chꞌawem, chikojo chi xikꞌamawaꞌj ri tajin kito rech kayaꞌtaj na chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","We iwoyawal che jun are tajin kibꞌan chꞌawem, chixkuyunoq rech ri iTat ri kꞌo chilaꞌ chikaj kukuy xuqujeꞌ na ri imak ix. ");
INSERT INTO quctt_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","/We kꞌu man kikuy ix kimak nikꞌaj chik, ri iTat ri kꞌo chikaj man kukuy ta ri imak ix./ ");
INSERT INTO quctt_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Junmul chik ri Jesús e rachiꞌl ri utijoxelabꞌ xoꞌpan pa Jerusalén. Are tajin kabꞌin ri Jesús pa ri Templo, xeqet ri e kꞌamal taq kibꞌe ri chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq rukꞌ xuqujeꞌ ri aꞌjtijabꞌ rech ri taqanik e kachiꞌl ri e kꞌamal taq bꞌe kech ri winaq aꞌj Israel. ");
INSERT INTO quctt_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Xkibꞌij che: ¿Jachin xyoꞌw kwinem chawe chubꞌanik we jastaq riꞌ? ¿Jachin yoꞌwinaq kwinem chawe rech jewaꞌ kabꞌano? ");
INSERT INTO quctt_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Xubꞌij ri Jesús chike: In xuqujeꞌ ri kinta jun jastaq chiꞌwe, we kixkwinik kibꞌij chwe, kinbꞌij chiꞌwe jachin yoꞌwinaq kwinem chwe chubꞌanik we jastaq riꞌ: ");
INSERT INTO quctt_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ri qasanaꞌ ri xubꞌan ri Juan, ¿la pa ri kaj upetik wi o rech uwachulew? ");
INSERT INTO quctt_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Xkichapleꞌj utayik chibꞌil kibꞌ, xkibꞌij: We kaqabꞌij chi rech pa ri kaj, ¿jas che man xikoj taj kacha laꞌ chaqe? ");
INSERT INTO quctt_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Man kujkwin ta kꞌut kaqabꞌij chi jun winaq xyoꞌw kwinem che. Jewaꞌ xkibꞌij rumal xkixiꞌj kibꞌ chubꞌixik chi rech uwachulew rumal ketaꞌm ri winaq chi ri Juan jun qꞌalajisal utzij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Xaq jeriꞌ xkibꞌij che ri Jesús: Man qetaꞌm taj. Ri Jesús xubꞌij chike: Man kinbꞌij ta xuqujeꞌ in chiꞌwe jachin yoꞌwinaq kwinem chwe chubꞌanik we jastaq riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ri Jesús xuchapleꞌj tzijonem kukꞌ ri winaq rukꞌ kꞌambꞌejabꞌal taq noꞌj, xubꞌij: Kꞌo jun achi xutik nikꞌaj uvas. Xukoralij rij, xukꞌot jun nimalaj pichꞌbꞌal uvas, kꞌa te riꞌ xuyak jun nimalaj ja jawjeꞌ kakꞌojiꞌ wi ri chajinel. Xuya pa qajik chike e nikꞌaj ajchakibꞌ, kꞌa te riꞌ xeꞌ pa jun utaqkil. ");
INSERT INTO quctt_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Are xopan ri qꞌij rech yakoj, xutaq bꞌik jun rajchak kukꞌ ri ajchakibꞌ chutoqꞌixik nikꞌaj rech ri yakoj. ");
INSERT INTO quctt_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ri ajchakibꞌ xkichap ri taqoꞌn, xkichꞌayo, maj xkiya bꞌik che, xkitaq bꞌik cho ja. ");
INSERT INTO quctt_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ri ajchoqꞌe ri ulew xutaq chi bꞌik jun rajchak. Ri ajchakibꞌ xkibꞌan kꞌax che xkiya pa ukꞌixibꞌal xuqujeꞌ xkiraqij loq ri ujolom. ");
INSERT INTO quctt_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Xutaq chi kꞌu bꞌi jun ajchak, ri ajchakibꞌ kꞌut xkikamisaj loq we ajchak riꞌ. E kꞌi xuꞌtaq chi na bꞌik, e kꞌo xechꞌay loq chike, nikꞌaj chik xekamisax loq. ");
INSERT INTO quctt_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kꞌisbꞌal rech, ri ajchoqꞌe ri ulew xutaq bꞌik ri xa jun ukꞌojol ri sibꞌalaj kuloqꞌaj, xubꞌij: “Kakinimaj waꞌ we nukꞌojol.” ");
INSERT INTO quctt_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ri ajchakibꞌ are xkil ri ukꞌojol ri ajchoqꞌe ri ulew xkibꞌij chibꞌil taq kibꞌ: “Are waꞌ ri kechꞌabꞌen kanoq ri ulew, qakamisaj, rech kaqechabej kanoq ri ulew.” ");
INSERT INTO quctt_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Are xopanik ri kꞌojolaxel, xkichapo, xkikamisaj, xkesaj bꞌik pa ri ulew. ");
INSERT INTO quctt_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","¿Jas kꞌu kubꞌan riꞌ ri ajchoqꞌe ri ulew are katzalij loq? Kuꞌkamisaj na ri ajchakibꞌ xuqujeꞌ kuya na ri ulew tikbꞌal uvas chike nikꞌaj chik. ");
INSERT INTO quctt_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿La man isikꞌim ri tzꞌibꞌatalik ri kubꞌij? Ri abꞌaj ri xketzelaj ri e yakol taq jaꞌ xuxik ri abꞌaj ri qas kꞌo kutayij. ");
INSERT INTO quctt_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Are waꞌ ri uchak ri Ajawxel, ri kuyak qamayijanik. ");
INSERT INTO quctt_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ri kinimaꞌqil ri winaq aꞌj Israel are xkichꞌobꞌo chi are katzijox kij pa ri kꞌambꞌejabꞌal noꞌj, xkaj xkichap ri Jesús. Man xkibꞌan ta kꞌut rumal cher kakixiꞌj kibꞌ chikiwach ri e winaq, jeriꞌ xkitzaq kanoq xebꞌek. ");
INSERT INTO quctt_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kꞌa te riꞌ xeꞌkitaq bꞌik e jujun fariseos e kachiꞌl e jujun herodianos rukꞌ ri Jesús rech kakikoj jun kꞌaꞌmabꞌal che rukꞌ ri tzij ri tajin kubꞌij. ");
INSERT INTO quctt_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Are xoꞌpanik xkibꞌij che: Ajtij, qetaꞌm chi lal jun tzꞌaqat achi. Man kaya ta la bꞌe chi jun winaq chik kabꞌin che la ri rajawaxik kabꞌan la, rumal man are ta kil la ri kekaꞌy ri winaq. Xane qas are kakꞌut la ri utz laj bꞌe ri keꞌ rukꞌ ri Dios, bꞌij la chaqe ¿la yaꞌtalik katoj che ri César ri alkabal o man yaꞌtal taj? ");
INSERT INTO quctt_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","¿La choqꞌaqꞌ kaqatojo o man choqꞌaqꞌ taj? Ri Jesús retaꞌm jas che tajin kakibꞌij che we riꞌ, xubꞌij chike: ¿Jas che kikoj kꞌaꞌmabꞌal pa chwe? Chikꞌama loq jun pwaq rech Roma, rech kaqilo. ");
INSERT INTO quctt_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Xkikꞌam bꞌik ri pwaq choch ri Jesús, xubꞌij chike: ¿Jachin ajchoqꞌe we tzꞌibꞌ riꞌ le kꞌo choch xuqujeꞌ le palajaj? Rech ri César, xecha ri winaq. ");
INSERT INTO quctt_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ri Jesús xubꞌij: Chiya che ri César ri rech ri César, xuqujeꞌ chiya che ri Dios ri rech ri Dios. Konojel ri winaq xemayijanik che ri xubꞌij ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Are kꞌu ri saduceos ri man kakikoj taj chi kꞌo kꞌastajibꞌal wach xoꞌpan rukꞌ ri Jesús, xeꞌkibꞌij che: ");
INSERT INTO quctt_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ajtij, ri Moisés xukꞌut chiqawach pa ri wuj ri xutzꞌibꞌaj chi are kakam jun achi xuqujeꞌ kakanaj kanoq ri rixoqil maj ral. Choqꞌaqꞌ wi ri rachalal ri achi ri xkamik, kakꞌuliꞌk rukꞌ ri ixoq ri xkanaj kanoq rech kekꞌojiꞌk rijaꞌl ri rachalal ri xkamik. ");
INSERT INTO quctt_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","E kꞌo kꞌu wuqubꞌ alaxik. Ri nabꞌe xkꞌuliꞌk, maj e ralkꞌwaꞌl xekanaj kanoq are xkamik. ");
INSERT INTO quctt_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ri ukabꞌ xkꞌuliꞌk rukꞌ ri malkaꞌn ixoq, xkam xuqujeꞌ bꞌik maj e ralkꞌwaꞌl xekanaj kanoq, je xubꞌan xuqujeꞌ ri urox. ");
INSERT INTO quctt_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Je xkꞌulmataj kukꞌ konojel kꞌa xkam na bꞌik ri kꞌisbꞌal chike ri wuqubꞌ, kꞌisbꞌal rech, xkam xuqujeꞌ bꞌik ri ixoq. ");
INSERT INTO quctt_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Pa ri kꞌastajibꞌal wach, ¿jachin chike ri achyabꞌ qas rachajil ri ixoq, rumal konojel xekꞌuliꞌ rukꞌ? ");
INSERT INTO quctt_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ri Jesús xubꞌij chike: Ri ix, ix sachinaq, xa man iwetaꞌm ta riꞌ ri tzꞌibꞌatalik xuqujeꞌ man iwetaꞌm taj ri utzij ri Dios xuqujeꞌ ri ukwinem. ");
INSERT INTO quctt_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Are kekꞌastaj ri kaminaqibꞌ, man kekꞌuliꞌ taj xuqujeꞌ man keya taj pa kꞌulanem, xane je kuꞌx ri angelibꞌ ri e kꞌo pa ri kaj. ");
INSERT INTO quctt_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Are kꞌu ri kꞌastajibꞌal wach kech ri kaminaqibꞌ, ¿la man isikꞌim ri uwuj ri Moisés, jawjeꞌ ri kutzijoj wi rij ri kꞌix, ri Dios xubꞌij che: In in uDios ri Abraham, ri Isaac, xuqujeꞌ ri Jacob? ");
INSERT INTO quctt_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ri Dios man kiDios ta kaminaqibꞌ xane kiDios e kꞌaslik winaq. Ri ix sibꞌalaj ix sachinaq. ");
INSERT INTO quctt_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jun chike ri aꞌjtijabꞌ rech ri taqanik xqebꞌ rukꞌ ri Jesús, are xuto tajin ketzijonik xuqujeꞌ xuta ri xubꞌij ri Jesús, xuta che: ¿Jachin chike ri taqanik ri nim uqꞌij chike konojel? ");
INSERT INTO quctt_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ri Jesús xubꞌij: Ri nim taqanik chike konojel are we jun riꞌ: Winaq aꞌj Israel, chitatabꞌej chi ri Dios are xa jun Ajawxel. ");
INSERT INTO quctt_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Chaloqꞌaj ri awAjaw Dios rukꞌ ronojel awanimaꞌ, rukꞌ ronojel akꞌuꞌx, xuqujeꞌ rukꞌ ronojel achuqꞌabꞌ. Are wa riꞌ taqanik ri sibꞌalaj nim uqꞌij chike konojel. ");
INSERT INTO quctt_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ri ukabꞌ taqanik are we jun riꞌ: Chaloqꞌaj ri ajil tzꞌaqat, jetaq ri kabꞌan chuloqꞌaxik awibꞌ at. ");
INSERT INTO quctt_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Utz ri xbꞌan la chubꞌixik, ri achi xubꞌij: Ajtij, qas tzij ri xbꞌij la, ri Dios xa jun, man kꞌo ta chi jun Dios xaq xwi ri areꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Uloqꞌaxik ri Dios rukꞌ ronojel animaꞌaj, rukꞌ ronojel kuꞌx xuqujeꞌ rukꞌ ronojel chuqꞌabꞌ. Xuqujeꞌ uloqꞌaxik ri kꞌulja jetaq kubꞌan chuloqꞌaxik ribꞌ jun, kꞌo na choch ri utzujik poron sipanik xuqujeꞌ ri utzujik ri kaminaq taq awaj choch ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ri Jesús are xrilo chi ri achi xutzalij uwach ri xubꞌij ri Jesús rukꞌ etaꞌmanik xubꞌij che: Naqaj at kꞌo wi che ri ajawarem rech ri Dios. Kꞌa te riꞌ man kꞌo ta chik jun winaq xubꞌij jun jastaq che ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Are tajin kuya kꞌutuꞌn ri Jesús pa ri Templo, xubꞌij chike ri winaq: ¿Jas che kakibꞌij ri aꞌjtijabꞌ rech ri taqanik chi ri Cristo ukꞌojol ri David? ");
INSERT INTO quctt_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ri David nojinaq che ri Tyoxalaj Uxlabꞌixel che are xubꞌij: Ri Ajawxel xubꞌij che ri wAjaw: Chattꞌuyul pa ri nuwiqiqꞌabꞌ,kꞌa kinya na pa awaqan konojel ri akꞌulel. ");
INSERT INTO quctt_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ri David we kubꞌij Ajawxel che ri Cristo, ¿jas ta kꞌu che riꞌ ukꞌojol? Ri winaq sibꞌalaj utz xkibꞌan chutatabꞌexik ri xubꞌij ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ri Jesús pa ri ukꞌutuꞌn xubꞌij: Chichajij iwibꞌ chike ri aꞌjtijabꞌ rech ri taqanik. Utz kakinaꞌo kewaꞌkat pa taq ri kꞌayibꞌal kikojom ri katzꞌyaq ri karepqꞌunik, xuqujeꞌ utz kakinaꞌo kaya rutzil kiwach. ");
INSERT INTO quctt_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Utz kakinaꞌo ketꞌuyiꞌk pa taq ri nabꞌe taq tꞌuyulibꞌal pa ri Sinagoga, xuqujeꞌ are kakichaꞌ ri tꞌuyulibꞌal ri nim ubꞌantajik pa taq ri nimaqꞌij ri kesikꞌix wi. ");
INSERT INTO quctt_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Kakimaj ri kijastaq ri e malkaꞌnibꞌ taq ixoqibꞌ xuqujeꞌ kakibꞌan chꞌawem rech ketataj kumal nikꞌaj winaq chik. Nimalaj ri kꞌaxkꞌolal ri kape pa kiwiꞌ we achyabꞌ riꞌ kꞌo na chikiwach nikꞌaj chik. ");
INSERT INTO quctt_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ri Jesús xtꞌuyiꞌk chunaqaj ri kꞌolibꞌal rech ri sipanik, xuchapleꞌj kikaꞌyexik ri winaq are kakiya ri kisipanik pa ri kꞌolibꞌal rech, ri kꞌo pa ri Templo. Sibꞌalaj e kꞌi qꞌinomabꞌ xkiya nimaꞌq taq pwaq. ");
INSERT INTO quctt_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Xopan kꞌut jun malkaꞌn ixoq, xuꞌya kanoq kebꞌ qꞌana taq pwaq ri man nim taj kilitajik. ");
INSERT INTO quctt_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ri Jesús xusikꞌij ri utijoxelabꞌ, xubꞌij chike: Qas tzij kinbꞌij chiꞌwe, we malkaꞌn ixoq riꞌ are nim xuya chikiwach konojel. ");
INSERT INTO quctt_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","We nikꞌaj winaq xkiya ri jubꞌiqꞌ che ri nim ri kꞌo kukꞌ, are kꞌu we ixoq riꞌ xuya ronojel ri kꞌo rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Elem loq rech ri Jesús pa ri Templo, jun chike ri utijoxelabꞌ xubꞌij che: Ajtij, chilampe sibꞌalaj jeꞌl kakaꞌy le nimaꞌq taq abꞌaj le kojtal che le Templo. ");
INSERT INTO quctt_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ri Jesús xubꞌij che: ¿La kawil ronojel we nimaq taq ja riꞌ? Man jun abꞌaj kakanaj chi kanoq puꞌwiꞌ jun abꞌaj, ronojel katukix na. ");
INSERT INTO quctt_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Are xeꞌ ri qꞌij, ri Jesús xtꞌuyiꞌk puꞌwiꞌ ri juyubꞌ Olivos, ri kꞌo apanoq choch ri Templo. Ri Pedro, ri Jacobo, ri Juan, xuqujeꞌ ri Andrés xkita che ri Jesús xaq pa utukel, xkibꞌij che: ");
INSERT INTO quctt_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Bꞌij la chaqe ¿jampaꞌ kakꞌulmataj le xbꞌij la? ¿Jas kakꞌutuwik chi xa jubꞌiqꞌ karaj kakꞌulmatajik? ");
INSERT INTO quctt_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ri Jesús xubꞌij chike: Qas chichajij iwibꞌ, kꞌo mixsubꞌuwik. ");
INSERT INTO quctt_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","E kꞌi winaq kepe na pa ri nubꞌiꞌ kakibꞌij: “In riꞌ,” xuqujeꞌ keꞌkisubꞌ na e kꞌi. ");
INSERT INTO quctt_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Are kito chi kꞌo chꞌoꞌj kabꞌanik xuqujeꞌ katzijoxik chi kabꞌan na chꞌoꞌj. Man kixtontiꞌr taj. Choqꞌaqꞌ wi kakꞌulmataj we riꞌ, man are ta na kꞌisbꞌal rech ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kechꞌoꞌjin na jun tinimit rukꞌ jun tinimit chik, xuqujeꞌ kechꞌoꞌjin na jun wok tinimit rukꞌ jun wok chik. Kubꞌan na kabꞌraqan pa ronojel ri uwachulew, kape na numik. Are waꞌ ri majibꞌal rech ri qꞌoxom. ");
INSERT INTO quctt_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","¡Chichajij iwibꞌ! Kixjach na cho ri qꞌatbꞌal taq tzij, chixchꞌay na pa taq ri Sinagoga. Rumal we kixkꞌam na bꞌik chikiwach ri nimaꞌq taq taqanelabꞌ rech kiniqꞌalajisaj chikiwach. ");
INSERT INTO quctt_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nabꞌe na rajawaxik katzijox ri utz laj tzij pa ronojel tinimit. ");
INSERT INTO quctt_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Man kakꞌaxir taj iwanimaꞌ chuchomaxik ri kibꞌij are kixkꞌam bꞌik rech kaqꞌat tzij pa iwiꞌ, xaq xwi chibꞌij ri kabꞌix chiꞌwe kibꞌij pa ri qꞌotaj riꞌ, rumal man ix taj riꞌ kixchꞌawik xane are ri Tyoxalaj Uxlabꞌixel. ");
INSERT INTO quctt_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ri aꞌlaxik xaq aꞌreꞌ kakijach na kibꞌ pa kamikal, ri tataxel kujach na ri ralkꞌwaꞌl pa kamikal. Ri alkꞌwaꞌlaxelabꞌ man keꞌkinimaj ta chi na ri kitat kinan, keꞌkikamisaj na. ");
INSERT INTO quctt_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Konojel ri winaq rech ri uwachulew kaketzelaj na iwach rumal ri nubꞌiꞌ, are kꞌu ri ko kakꞌojiꞌk, kakolotaj na. ");
INSERT INTO quctt_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Are kiwil na ri itzel laj awas kakꞌojiꞌk jawjeꞌ ri man taqal ta wi, /jetaq ri xutzꞌibꞌaj ri qꞌalajisal tzij Daniel/ (ri kusikꞌij uwach ri wuj, chuchꞌobꞌo ri kubꞌij ri kusikꞌij) ri winaq ri e kꞌo pa Judea chaꞌnimaj bꞌik chebꞌoꞌj pa ri juyubꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ri kꞌo pa ri jaꞌ ri kꞌo puꞌwiꞌ ri rachoch, maqaj bꞌik ikim chukꞌamik jun ujastaq. ");
INSERT INTO quctt_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Xuqujeꞌ ri kꞌo cho ri saq, matzalij loq chukꞌamik ri uqꞌuꞌ xane chanimajoq. ");
INSERT INTO quctt_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Che ri qꞌij riꞌ, ¡kꞌax ke ri ixoqibꞌ ri yawabꞌ taq winaq xuqujeꞌ ri keꞌkitubꞌisaj kal! ");
INSERT INTO quctt_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Chibꞌana chꞌawem rech man we riꞌ man kakꞌulmataj taj pa ri qꞌalaj. ");
INSERT INTO quctt_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Rumal ri kꞌax ri kakꞌulmatajik, man kꞌulmatajinaq ta wi loq pa ri majibꞌal rech ri uwachulew xuqujeꞌ man kakꞌulmataj ta chi na. ");
INSERT INTO quctt_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","We ta mat kukoꞌpij ri Dios we qꞌij riꞌ, maj jun riꞌ kakꞌasiꞌ, xa kꞌu kumal ke ri e chaꞌtalik, kakꞌopix na ri qꞌij. ");
INSERT INTO quctt_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","We kꞌo jun kubꞌij chiꞌwe: “¡Chiwilampeꞌ, chi riꞌ kꞌo wi ri Cristo!” o “¡Chiwilampeꞌ, je leꞌ kꞌo wiꞌ!” man kikoj taj. ");
INSERT INTO quctt_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kepe na winaq kakijaluj chi aꞌreꞌ e Cristo, xuqujeꞌ kakijaluj chi e qꞌalajisal taq utzij ri Dios, kakibꞌan na kꞌutbꞌal xuqujeꞌ mayijabꞌal taq jastaq rech keꞌkisubꞌ ri winaq pune are ri e chaꞌtalik. ");
INSERT INTO quctt_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Rumal riꞌ qas kinbꞌij chiꞌwe: “Chichajij iwibꞌ.” ");
INSERT INTO quctt_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Pa taq ri qꞌij riꞌ are kikꞌow ri nimalaj kꞌaxal, kachup na ri qꞌij xuqujeꞌ ri ikꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ketzaq na loq ri chꞌumil ri e kꞌo cho ri kaj xuqujeꞌ kasach na uwach ri kaj. ");
INSERT INTO quctt_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kiwil kꞌu na ri uKꞌojol ri Achi kape pa ri sutzꞌ rukꞌ kwinem xuqujeꞌ juluwem. ");
INSERT INTO quctt_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Kuꞌtaq kꞌu na loq ri rangelibꞌ ri Dios chikimulixik konojel ri e chaꞌtalik pa ronojel ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Chichꞌobꞌo ri kꞌutuꞌn chirij ri ucheꞌal ri higos. Are keraxar ri uqꞌabꞌ, kekꞌiy loq ri uxaq, iwetaꞌm chi xqebꞌ loq ri qꞌalaj. ");
INSERT INTO quctt_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Jeriꞌ xuqujeꞌ are kiwilo kakꞌulmatajik we jastaq riꞌ, chiwetaꞌmaj chi xqebꞌ loq ri nupetibꞌal. ");
INSERT INTO quctt_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Qas tzij kinbꞌij chiꞌwe chi man kekam ta na we winaq riꞌ rech we qꞌij kamik, kꞌa kꞌulmataj na we jastaq riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ri kaj xuqujeꞌ ri uwachulew kasach na, are kꞌu ri nutzij maj usachik. ");
INSERT INTO quctt_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Are kꞌu ri qꞌij xuqujeꞌ ri qꞌotaj, maj jun etaꞌmaninaq, man ne ketaꞌm taj ri angelibꞌ, in xuqujeꞌ man wetaꞌm taj, xane xaq xwi ri Tataxel. ");
INSERT INTO quctt_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Chixkꞌasloq, xuqujeꞌ chibꞌana chꞌawem rumal man iwetaꞌm taj are kopan ri qꞌotaj rech ri nupetibꞌal. ");
INSERT INTO quctt_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kajunumataj rukꞌ jun achi are keꞌ pa jun utaqkil, kuꞌya kanoq ri e rajchakibꞌ kakichajij apanoq ri rachoch, kuya kanoq kitaqkil konojel, xuqujeꞌ kutaq kanoq ri chajil uchiꞌ ja rech man kawar taj. ");
INSERT INTO quctt_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Rumal riꞌ chixkꞌasloq, man iwetaꞌm taj jampaꞌ katzalij loq ri ajchoqꞌe ri ja, wine are kaqaj qꞌij, wine pa nikꞌaj aqꞌabꞌ, o wine are koqꞌ ri amaꞌ akꞌ, o are ne kasaqirik. ");
INSERT INTO quctt_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Rech man kixwar taj are kuꞌriqa ri nupetibꞌal. ");
INSERT INTO quctt_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ri kinbꞌij chiꞌwe ix, kinbꞌij chike konojel: ¡Chixkꞌasloq! ");
INSERT INTO quctt_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Xa kebꞌ qꞌij chik karaj che ri nimaqꞌij Pascua, xuqujeꞌ ri nimaqꞌij are katij ri kaxlan wa ri maj chꞌam rukꞌ. Ri e kꞌamal taq bꞌe kech ri chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq e kachiꞌl ri aꞌjtijabꞌ rech ri taqanik tajin kachichomaj jas kakibꞌan chuchapik ri Jesús, rech kakikamisaj. ");
INSERT INTO quctt_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Xkibꞌij: Man kaqachap taj pa le nimaqꞌij rech man ketukin ta bꞌik le winaq. ");
INSERT INTO quctt_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Are kꞌo ri Jesús pa ri tinimit Betania pa rachoch ri Simón, ri kabꞌix chꞌaꞌk achi che, xopan jun ixoq rukꞌaꞌm bꞌik jun kꞌokꞌ laj kunabꞌal. ri bꞌantal che jun ri qꞌayes ubꞌiꞌ nardo, ri sibꞌalaj paqal rajil. Ri ixoq xupaxij ri kꞌolibꞌal ri kꞌo wi bꞌik ri kunabꞌal, kꞌa te riꞌ xuqꞌij pa ujolom ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","E kꞌo kꞌu jujun chike ri e kꞌo chilaꞌ xkibꞌij: ¿Jas che xaq xtix we kunabꞌal riꞌ? ");
INSERT INTO quctt_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","La man xa xkꞌayix we jastaq riꞌ rech kachꞌek nimalaj pwaq che jeriꞌ kaya chike ri mebꞌaibꞌ. Sibꞌalaj kꞌax kakibꞌan chuyajik ri ixoq. ");
INSERT INTO quctt_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ri Jesús xubꞌij: ¿Jas che kꞌax kixtzijon che we ixoq riꞌ? Man kiyaj taj. Sibꞌalaj utz ri chak ri xubꞌan wukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ronojel qꞌij e kꞌo ri e mebꞌaibꞌ iwukꞌ rech kiꞌtoꞌo, ri in kꞌut man in kꞌo taj ronojel qꞌij iwukꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","We ixoq riꞌ xubꞌano ri xkwin chubꞌanik naꞌtabꞌal rech chi kinmuqiꞌk na. ");
INSERT INTO quctt_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Qas tzij kinbꞌij chiꞌwe pa ronojel ri uwachulew jawjeꞌ ri katzijox wi na ri utz laj tzij, katzijox na we xubꞌano we ixoq riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ri Judas Iscariote, jun chike ri kabꞌlajuj utijoxelabꞌ ri Jesús, xopan chukꞌayixik ri Jesús kukꞌ ri e kꞌamal taq bꞌe kech ri chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq. ");
INSERT INTO quctt_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Sibꞌalaj xekiꞌkotik are xkitabꞌej rech ri xbꞌix chike, xkitzuj pwaq che ri Judas. Jeriꞌ ri Judas xuchapleꞌj utzukuxik jas kubꞌan chujachik ri Jesús pa kiqꞌabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pa ri nabꞌe qꞌij rech ri nimaqꞌij, are katij ri kaxlan wa ri maj chꞌam rukꞌ, xuqujeꞌ are kakamisax ri chij rech ri Pascua, ri tijoxelabꞌ xkita che ri Jesús: ¿Jawjeꞌ kaj wi la kaqabꞌan wi ri waꞌim rech Pascua? ");
INSERT INTO quctt_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ri Jesús xubꞌij chike e kebꞌ chike ri utijoxelabꞌ: Jix pa le tinimit. Chilaꞌ kel wi loq jun achi rukꞌaꞌm jun qꞌebꞌal jaꞌ, chitereneꞌj bꞌik. ");
INSERT INTO quctt_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Jawjeꞌ ri kok wi bꞌik ri achi, chibꞌij che: “Ri ajtij kuto: ¿Jawjeꞌ kꞌo wi ri ja ri kinwikꞌowisaj wi ri nimaqꞌij Pascua, kukꞌ ri nutijoxelabꞌ?” ");
INSERT INTO quctt_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ri achi kukꞌut na chiꞌwach jun nim ja ri kꞌo chikaj, sukꞌumatal chik. Chibꞌana ri qarekeqꞌij chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Xebꞌek ri tijoxelabꞌ, xoꞌk bꞌik pa ri tinimit, xkiriq ri achi jetaq ri xubꞌij bꞌik ri Jesús chike. Jeriꞌ xkibꞌano ri rekeqꞌij rech Pascua. ");
INSERT INTO quctt_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Are xok aqꞌabꞌ, xopan ri Jesús e rachiꞌl ri kabꞌlajuj utijoxelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Are e qꞌaꞌlik tajin kewaꞌ puꞌwiꞌ ri mexa, ri Jesús xubꞌij chike: Qas tzij kinbꞌij chiꞌwe, jun chiꞌwe ri tajin kawaꞌ wukꞌ kinukꞌayij na. ");
INSERT INTO quctt_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ri tijoxelabꞌ sibꞌalaj xebꞌisonik, xkichapleꞌj utatabꞌeloꞌxik chibꞌil kibꞌ: ¿Teꞌq in riꞌ? ");
INSERT INTO quctt_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ri Jesús xubꞌij: Jun chike ri kabꞌlajuj ri kumuꞌ ri ukaxlan wa wukꞌ pa ri palaꞌt. ");
INSERT INTO quctt_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Qas tzij kinbꞌij chiꞌwe, kakꞌulmataj na rukꞌ ri uKꞌojol ri Achi, jetaq ri tzꞌibꞌatal loq, xa kꞌu kꞌax rech ri kꞌayinel, are katanik we ta mat xalaxik. ");
INSERT INTO quctt_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Are tajin kewaꞌik, ri Jesús xukꞌam ri kaxlan wa, xutewechiꞌj. Kꞌa te riꞌ xujach chike ri utijoxelabꞌ, xubꞌij chike: Riꞌ chikꞌamaꞌ, are waꞌ ri nutyoꞌjal. ");
INSERT INTO quctt_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kꞌa te riꞌ xukꞌam jun qumubꞌal, xutyoxij che ri Dios, kꞌa te riꞌ xuya chike ri utijoxelabꞌ, konojel xequmunik. ");
INSERT INTO quctt_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Xubꞌij chike: Are waꞌ ri nukikꞌel rech ri kꞌakꞌ chꞌekom tzij, ri katixtobꞌ kumal ke e kꞌi winaq. ");
INSERT INTO quctt_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Qas tzij kinbꞌij chiꞌwe, man kinqumuj ta chi na we vino xane kꞌa te kinqumuj chik pa ri ajawarem rech ri Dios ri kꞌakꞌ vino. ");
INSERT INTO quctt_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Are xbꞌixotaj ri Salmos kumal, xebꞌe pwiꞌ ri juyubꞌ Olivos. ");
INSERT INTO quctt_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Kꞌa teꞌ ri xubꞌij ri Jesús: Iwonojel kinitzaq na kanoq, jeriꞌ rumal tzꞌibꞌatalik: Kinbꞌan na kꞌax che ri ajyuqꞌ xuqujeꞌ ketukin na bꞌik ri chij. ");
INSERT INTO quctt_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Are kinkꞌastajik, kinnabꞌej na bꞌik chiꞌwach kineꞌ je laꞌ pa Galilea. ");
INSERT INTO quctt_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ri Pedro xubꞌij: In man kantzaq ta la kanoq pune konojel ri nikꞌaj jeriꞌ kakibꞌano. ");
INSERT INTO quctt_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ri Jesús xubꞌij che: Qas tzij kinbꞌij chawe, che we chaqꞌabꞌ kamik oxmul awawam nuwach are koqꞌ ri akꞌ chukamul. ");
INSERT INTO quctt_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ri Pedro ko xubꞌij: Pune rajawaxik kinkam ukꞌ la, man kinwawaj ta wi qꞌalajisaxik la. Konojel ri nikꞌaj tijoxelabꞌ chik je xkibꞌij jacha ri xubꞌij ri Pedro. ");
INSERT INTO quctt_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Xoꞌpan pa jun kꞌolibꞌal ubꞌiꞌ Getsemaní, ri Jesús xubꞌij chike ri utijoxelabꞌ: Chixtꞌuyul kanoq waral, xa keꞌnbꞌana na apanoq chꞌawem. ");
INSERT INTO quctt_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Xuꞌkam bꞌik ri Pedro, ri Jacobo, ri Juan rukꞌ. Xuchapleꞌj bꞌisonem xuqujeꞌ xuxiꞌj ribꞌ ");
INSERT INTO quctt_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Xubꞌij chike ri e kꞌo rukꞌ: Sibꞌalaj kabꞌison ri wanimaꞌ, raj kinkamik kinnaꞌo. Kꞌa te riꞌ xubꞌij chike: Chixkanaj kanoq waral, chixkꞌasloq. ");
INSERT INTO quctt_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Xbꞌin chi na apanoq jubꞌiqꞌ, xukiꞌk pa ri ulew, xuchapleꞌj ubꞌanik chꞌawem are xuto we ta kꞌo bꞌanom wi mat kuriq ri kꞌaxal. ");
INSERT INTO quctt_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Xubꞌij: ¡Tat! lal kakwin la chubꞌanik ronojel. Man kaya ta la bꞌe chwe kinriq we kꞌax riꞌ, man are ta kꞌu kabꞌan we in, xane are bꞌanoq ri kaj lal. ");
INSERT INTO quctt_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kꞌa te riꞌ xtzalij kukꞌ ri utijoxelabꞌ, are xopan kukꞌ tajin kewarik. Xubꞌij: ¡Simón! ¿Tajin ne lo katwarik? ¿Man xatkwin taj xatkꞌasiꞌk xa ta ne jun hora? ");
INSERT INTO quctt_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Chixkꞌasloq, chibꞌana chꞌawem rech man kixqaj taj pa ri mak. Ri uxlabꞌal sibꞌalaj karaj ri chꞌawem are kꞌut ri ityoꞌjal maj uchuqꞌabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Xeꞌ chi junmul ri Jesús, xubꞌana chꞌawem. ");
INSERT INTO quctt_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Are xtzalij loq kukꞌ ri tijoxelabꞌ, junmul chik tajin kewarik, rumal sibꞌalaj kꞌax kiwaram. Man xkiriq taj jas xkibꞌij che ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Churox mul xtzalij loq kukꞌ ri utijoxelabꞌ, xubꞌij chike: Chixwaroq, chixuxlanoq, waral xkꞌis wi. Chiwilampeꞌ, xopan ri qꞌotaj are kajach ri uKꞌojol ri Achi pa kiqꞌabꞌ ri aꞌjmakibꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Chixwaꞌjiloq! ¡Joꞌ! Xul le kinjachowik. ");
INSERT INTO quctt_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Tajin kachꞌaw na ri Jesús are xaq kꞌa te xopan ri Judas, jun chike ri kabꞌlajuj tijoxelabꞌ, e rachiꞌl sibꞌalaj e kꞌi winaq ri e taqtal bꞌik kumal ri e chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq, aꞌjtijabꞌ rech ri taqanik xuqujeꞌ e kꞌamal taq bꞌe kech ri winaq aꞌj Israel, kukꞌam cheꞌ rachiꞌl sakꞌibꞌal. ");
INSERT INTO quctt_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ri Judas ubꞌim chike ri winaq: Ri achi ri kintzꞌumaj are riꞌ, chichapaꞌ, chikꞌama bꞌik rukꞌ chuqꞌabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Are xopanik ri Judas, xqebꞌ rukꞌ ri Jesús, xubꞌij che: Ajtij. Kꞌa te riꞌ xutzꞌumaj. ");
INSERT INTO quctt_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ri achyabꞌ xkichap ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jun chike ri e kꞌo chilaꞌ xresaj jun sakꞌibꞌal, xusakꞌij ri uxikin ri patanil rech ri kꞌamal kibꞌe ri e chꞌawenelabꞌ cho ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ri Jesús xubꞌij chike: ¿La in jun elaqꞌom kꞌut che ri ix petinaq chwij rukꞌ cheꞌ rachiꞌl sakꞌibꞌal? ");
INSERT INTO quctt_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Man xinichap ta kꞌut pa taq ri qꞌij are xinkꞌojiꞌk iwukꞌ pa ri Templo. Xkꞌulmataj kꞌu we riꞌ rumal cher rajawaxik wi kakꞌulmataj na ri tzꞌibꞌatal loq. ");
INSERT INTO quctt_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kojonel ri utijoxelabꞌ xaꞌnimaj bꞌik, xkitzaq kanoq utukel. ");
INSERT INTO quctt_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Xkichap kꞌut jun ala ri utereneꞌm bꞌik ri Jesús, uqꞌuꞌm jun atzꞌyaq. ");
INSERT INTO quctt_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ri ala xutzaq kanoq ri atzꞌyaq, chꞌanalik, xanimaj bꞌik. ");
INSERT INTO quctt_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Xkikꞌam bꞌik ri Jesús choch ri kꞌamal kibꞌe ri chꞌawenelabꞌ cho ri Dios, chilaꞌ xkimulij wi kibꞌ ri e kꞌamal taq bꞌe kech wi e chꞌawenelabꞌ cho ri Dios, ri aꞌjtijabꞌ rech ri taqanik xuqujeꞌ ri e kꞌamal taq kibꞌe ri winaq aꞌj Israel. ");
INSERT INTO quctt_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ri Pedro naj kꞌo wi kanoq utereneꞌm bꞌik ri Jesús, xok bꞌik cho rachoch ri kinimaꞌqil ri chꞌawenelabꞌ cho ri Dios. Xtꞌuyiꞌk kukꞌ ri ajchꞌoꞌjabꞌ chajinelabꞌ kumiqꞌ ribꞌ chuchiꞌ ri qꞌaqꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ri e kꞌamal taq kibꞌe ri chꞌawenelabꞌ cho ri Dios xuqujeꞌ ri e yaꞌl taq noꞌj kakitzukuj jas kakibꞌan chuqꞌalajisaxik chi ri Jesús ajmak, jeriꞌ kekwinik kakikamisaj, maj kꞌu umak xkiriqo. ");
INSERT INTO quctt_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","E kꞌi winaq xkibꞌan bꞌanoj tzij chirij ri Jesús, man saq ta kꞌut ri kakibꞌij. ");
INSERT INTO quctt_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","E kꞌo kꞌu nikꞌaj winaq xkibꞌan we bꞌanoj tzij riꞌ chirij ri Jesús, xkibꞌij: ");
INSERT INTO quctt_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Uj xqato are xubꞌij: Kintukij we Templo ri kiqꞌabꞌ achyabꞌ yakowinaq, kinyak kꞌu na jun man uqꞌabꞌ ta achi kayakowik. ");
INSERT INTO quctt_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Man rukꞌ ta waꞌ xjunamataj uwach ri kakibꞌij. ");
INSERT INTO quctt_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Xwaꞌjil ri kꞌamal bꞌe kech ri chꞌawenelabꞌ cho ri Dios, xubꞌij che ri Jesús: ¿La maj jas kabꞌij che le kakibꞌij chawe? ¿Jas kel kubꞌij waꞌ we mak riꞌ, ri kabꞌixik xabꞌano? ");
INSERT INTO quctt_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ri Jesús maj jas xubꞌij. Ri kꞌamal kibꞌe ri chꞌawenelabꞌ cho ri Dios xuta che: ¿La at, at Cristo, uKꞌojol ri tewchiꞌtal laj Dios? ");
INSERT INTO quctt_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jeꞌ, in riꞌ, xcha ri Jesús. Kiwil na ix ri uKꞌojol ri Achi, katꞌuyiꞌ na pa ri uwiqiqꞌabꞌ ri kwinel laj Dios are kape pa ri sutzꞌ rech chilaꞌ chikaj. ");
INSERT INTO quctt_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ri kꞌamal bꞌe kech ri chꞌawenelabꞌ cho ri Dios xutꞌoqopij ri ratzꞌyaq, xubꞌij: ¿Jas kakitayij chi na chaqe ri e qꞌalajisanelabꞌ? ");
INSERT INTO quctt_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","¡Qas ix xixtow rukꞌ ixikin ri awas ri xubꞌij! ¿Jas kita che? Konojel ri winaq xkibꞌij chi taqal che kakamisaxik. ");
INSERT INTO quctt_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","E kꞌi xkichapleꞌj uchubꞌaxik ri upalaj, xkichꞌuq ri ubꞌoqꞌoch, xkikoj tꞌoyom qꞌabꞌ che, xkibꞌij: ¡Chaqꞌalajisaj ri utzij ri Dios chiqawach! Ri ajchꞌoꞌjabꞌ chajinelabꞌ xkilaqꞌij qꞌabꞌ chupalaj. ");
INSERT INTO quctt_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ri Pedro are kꞌo cho ri ja, xikꞌow bꞌik jun aj ikꞌ rech ri kꞌamal kibꞌe ri chꞌawenelabꞌ cho ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Are xrilo chi ri Pedro tajin kumiqꞌ ribꞌ chuchiꞌ ri qꞌaqꞌ, ko xukaꞌyej, xubꞌij che: Xuqujeꞌ at at kꞌo rukꞌ ri Jesús ri aj Nazaret. ");
INSERT INTO quctt_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ri Pedro xubꞌij: Man wetaꞌm taj uwach, man ne wetaꞌm taj jachin tajin katzijoj rij. Kꞌa te riꞌ xel bꞌik chuchiꞌ ri qꞌaqꞌ, xeꞌ chuchiꞌ ri uchiꞌ ja. ");
INSERT INTO quctt_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ri aj ikꞌ are xril ri Pedro xubꞌij chike ri e kꞌo chilaꞌ: We jun achi riꞌ kachiꞌl we winaq riꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ri Pedro junmul chik xubꞌij chi man retaꞌm taj uwach ri Jesús. Maj naj taj ikꞌowinaq, are nikꞌaj winaq chik xkibꞌij che ri Pedro: Qas tzij wi laꞌ at kachiꞌl rumal at at aj Galilea. ");
INSERT INTO quctt_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ri Pedro xuchapleꞌj ubꞌixik etzelal chibꞌil ribꞌ. Xubꞌij: Qas tzij kinbꞌij chiꞌwe chi man wetaꞌm taj uwach ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Xaq kꞌa teꞌ xoqꞌ jun amaꞌ akꞌ chukamul. Xnaꞌtaj che ri Pedro ri xbꞌix che rumal ri Jesús: Oxmul awawam nuwach are koqꞌ chukamul ri amaꞌ akꞌ. Ri Pedro xuchapleꞌj oqꞌej. ");
INSERT INTO quctt_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Are xsaqirik, ri kinimaꞌqil ri chꞌawenelabꞌ cho ri Dios, ri e kꞌamal taq kibꞌe ri winaq aꞌj Israel xuqujeꞌ ri e yoꞌl taq noꞌj xkichomaj jas kakibꞌano. Xkiyut bꞌik ri Jesús, xkikꞌam bꞌik choch ri Pilato. ");
INSERT INTO quctt_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ri Pilato xuta che ri Jesús: ¿La at ri at kirey ri winaq aꞌj Israel? Ri Jesús xubꞌij che: Lal xbꞌin la in jachinaq. ");
INSERT INTO quctt_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ri e kꞌamal taq kibꞌe ri e chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq xkichapleꞌj utzujuxik ri Jesús che kꞌi jastaq. ");
INSERT INTO quctt_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ri Pilato xubꞌij che ri Jesús: ¿La maj jas kabꞌij che le tajin kakibꞌij chawe? Sibꞌalaj kꞌi ri amakum, jeriꞌ kakibꞌij. ");
INSERT INTO quctt_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pune jeriꞌ xbꞌix che ri Jesús, maj xa ta ne jun tzij xubꞌij, rumal riꞌ ri Pilato sibꞌalaj xmayijanik. ");
INSERT INTO quctt_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pa ri nimaqꞌij, naqꞌatal che ri Pilato kutzoqopij jun itzel winaq ri kꞌo pa che, xapachin na kꞌu ri kakita ri winaq. ");
INSERT INTO quctt_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kꞌo kꞌu jun achi ubꞌiꞌ Barrabás, tzꞌapital pa ri cheꞌ kukꞌ ri itzel taq winaq, rumal ukꞌulel ri nim taqanel pa Roma xuqujeꞌ rumal ri kamisanik ri ubꞌanom. ");
INSERT INTO quctt_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Xkimulij kibꞌ ri winaq choch ri Pilato, xkita che kutzoqopij ri jun itzel winaq jetaq ri naqꞌatalik kubꞌano pa ri nimaqꞌij. ");
INSERT INTO quctt_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ri Pilato xuta chike: ¿La are kiwaj kintzoqopij bꞌik le kirey le winaq aꞌj Israel? ");
INSERT INTO quctt_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Jeriꞌ xubꞌij rumal xuchꞌobꞌo chi ri e kꞌamal taq kibꞌe ri e chꞌawenelabꞌ cho ri Dios xkijach ri Jesús rumal kꞌax kakinaꞌ che. ");
INSERT INTO quctt_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ri e kinimaꞌqil ri e chꞌawenelabꞌ cho ri Dios xeꞌkitaqchiꞌj ri winaq are kakito katzoqopix ri Barrabás. ");
INSERT INTO quctt_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ri Pilato xuta chike: ¿Jas kꞌu kinbꞌan che le achi le kibꞌij ix chi are kirey ri winaq aꞌj Israel? ");
INSERT INTO quctt_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ri winaq ko xkiraq kichiꞌ, xkibꞌij: ¡Ripoq! ");
INSERT INTO quctt_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ri Pilato xuta chike: ¿Jas che? ¿Jas xumakuj we achi riꞌ? Ri winaq ko xkiraq kichiꞌ, xkibꞌij: ¡Ripoq! ");
INSERT INTO quctt_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Xraj kꞌu ri Pilato xuya chike ri winaq ri kakaj xtaqanik katzoqopixik ri Barrabás, xuqujeꞌ xtaqan churapuxik ri Jesús, kꞌa te riꞌ xujach bꞌik chike rech kakiripo. ");
INSERT INTO quctt_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ri ajchꞌoꞌjabꞌ xkikꞌam bꞌik ri Jesús choch ri ja ri kakꞌojiꞌ wi ri nim qꞌatal tzij, xeꞌkimulij konojel ri kachiꞌl. ");
INSERT INTO quctt_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Xkikoj jun kyaq manta chirij ri Jesús, kꞌa te riꞌ xkikem jun kꞌix korona, xkikoj pa ujolom, ");
INSERT INTO quctt_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","xuqujeꞌ xkibꞌij: ¡Nim uqꞌij ri kirey ri winaq aꞌj Israel! ");
INSERT INTO quctt_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Xkichꞌay chujolom rukꞌ jun aj, xkichubꞌaj, xexukiꞌk choch, kakijaluj kakiya uqꞌij. ");
INSERT INTO quctt_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Are xetoꞌtaj chuyakik kitzeꞌ chirij ri Jesús, xkesaj ri manta chrij, xkikoj ri ratzꞌyaq. Kꞌa te riꞌ xkikꞌam bꞌik pa ripik. ");
INSERT INTO quctt_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kꞌo jun achi ubꞌiꞌ Simón aj Cirene, utat ri Alejandro Rufo, tzalijem loq rij pa ri uchak cho ri saq, xkitaq bꞌik chi reqaxik ri ripbꞌal. ");
INSERT INTO quctt_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Xkikꞌam bꞌik ri Jesús pa ri ulew ubꞌiꞌnam Gólgota, ri kel kubꞌij Ubꞌaqilal jolomaj. ");
INSERT INTO quctt_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Xkiyujaꞌj vino rukꞌ mirra, kꞌa te riꞌ xkitzuj che, ri Jesús man xraj taj xutijo. ");
INSERT INTO quctt_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kꞌa te riꞌ xkiripo, ri ajchꞌoꞌjabꞌ xeꞌtzꞌanik rech kakilo jachin kachꞌekow bꞌik ri ratzꞌyaq ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Pa ri bꞌelejebꞌ hora rech ri qꞌij, xkirip ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Xkikoj we tzꞌibꞌatalik riꞌ puꞌwiꞌ ri cheꞌ ripbꞌal: ARE WAꞌ RI KIREY RI WINAQ AꞌJ ISRAEL. ");
INSERT INTO quctt_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Xerip xuqujeꞌ e kebꞌ eleqꞌomabꞌ chuxukut, jun pa umox, jun pa uwiqiqꞌabꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Xkꞌulmataj kꞌut ri tzꞌibꞌatal loq chirij kubꞌij: Xajilax chikixoꞌl ri aꞌjmakibꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Konojel ri kiꞌkꞌow bꞌik kakisutusa kanoq ri kijolom xuqujeꞌ kakibꞌij kanoq che ri Jesús: At ri katukij ri Templo kꞌa te riꞌ pa oxibꞌ qꞌij kayak ukꞌaxel. ");
INSERT INTO quctt_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡Chatqaj loq cho ri ripbꞌal, chakolo awibꞌ! ");
INSERT INTO quctt_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ri e kꞌamal taq bꞌe kech ri chꞌawenelabꞌ cho ri Dios, e kachiꞌl ri aꞌjtijabꞌ rech ri taqanik xkitzeꞌj uwach ri Jesús xkibꞌij che: Xkwinik xuꞌkol nikꞌaj winaq chik, man kakwin ta kꞌut kukol ribꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Chuqasaj loq ribꞌ choch ri ripbꞌal, we are Cristo kirey ri winaq aꞌj Israel rech jeriꞌ kaqilo xuqujeꞌ kujkojon che. Ri achyabꞌ ri xerip rukꞌ kakibꞌij apanoq kꞌax taq tzij che. ");
INSERT INTO quctt_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Pa ri unikꞌajil qꞌij xqꞌequꞌmataj ri uwachulew kꞌa te xtaniꞌ pa ri urox hora rech bꞌenaq qꞌij. ");
INSERT INTO quctt_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ri Jesús xuraq uchiꞌ pa ri urox hora rech bꞌenaq qꞌij, xubꞌij: Eloi, Eloi, ¿lama sabactani? ri kel kubꞌij: NuDios, nuDios ¿jas che xinya la kanoq nutukel? ");
INSERT INTO quctt_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Jujun chike ri e kꞌo chilaꞌ, are xkita ri xubꞌij ri Jesús, xkibꞌij: Chitampeꞌ, tajin kuchꞌabꞌej apanoq ri Elías. ");
INSERT INTO quctt_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kaxikꞌan jun chike ri achyabꞌ xuꞌchꞌaqabꞌa loq jun qꞌux pa vinagre kꞌa te riꞌ xuxekebꞌa bꞌik che jun aj, xutzuj apanoq che ri Jesús, xuqujeꞌ xubꞌij: Qilampeꞌ we qas kape ri Elías chuqasaxik. ");
INSERT INTO quctt_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ri Jesús rukꞌ chuqꞌabꞌ xuraq uchiꞌ, kꞌa te riꞌ xkamik. ");
INSERT INTO quctt_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ri atzꞌyaq tasbꞌal upam ri Tyoxalaj kꞌolibꞌal ri kꞌo pa ri Templo xjisjobꞌ pa kebꞌ upetik chikaj kꞌa pa ri ulew. ");
INSERT INTO quctt_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Are xuta ri kinimal ri ajchꞌoꞌjabꞌ chi xuraq uchiꞌ ri Jesús, xuqujeꞌ xrilo jas xubꞌan ri Jesús xkamik, xubꞌij: Qas tzij wi, we achi riꞌ are Ukꞌojol ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","E kꞌo kꞌu jujun ixoqibꞌ naj e kꞌo wi kekaꞌy apanoq. Chikixoꞌl e kꞌo ri María Magdalena, ri María ri unan ri Jacobo, xuqujeꞌ ri unan ri José, xuqujeꞌ ri Salomé. ");
INSERT INTO quctt_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","We ixoqibꞌ riꞌ xeteriꞌk, xuqujeꞌ xkipatanij ri Jesús are kꞌo pa Galilea. E kꞌo xuqujeꞌ nikꞌaj ixoqibꞌ chik chilaꞌ ri xepaqiꞌ rukꞌ are xeꞌ pa Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Bꞌenaq chi qꞌij, (qꞌij ri kasukꞌumax kanoq ronojel ri katij pa ri qꞌij rech uxlanem) ");
INSERT INTO quctt_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ri José aj Arimatea, jun chike ri e yaꞌl taq noꞌj kech ri winaq aꞌj Israel, jun achi ri rayeꞌm ri ajawarem rech ri Dios, man xuxiꞌj taj ribꞌ, xopan rukꞌ ri Pilato chutayik ri utyoꞌjal ri Jesús rech kumuqu. ");
INSERT INTO quctt_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ri Pilato sibꞌalaj xmayijanik are xuto chi aninaq xkam ri Jesús, xusikꞌij ri kinimal ri ajchꞌoꞌjabꞌ xuta che la naj chik kaminaq ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Are xkibꞌij che chi ri Jesús kaminaq chik, xuya bꞌe che ri José xukꞌam bꞌik. ");
INSERT INTO quctt_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ri José xuqasaj bꞌik ri utyoꞌjal ri Jesús, xubꞌolqꞌotij bꞌik pa jun kꞌakꞌ atzꞌyaq ri xuloqꞌo, xuyaꞌ kanoq pa jun jul ri kꞌottal cho jun abꞌaj, kꞌa te riꞌ xuwolqotij kanoq jun abꞌaj rech kutzꞌapij ri uchiꞌ ri muqbꞌal. ");
INSERT INTO quctt_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ri María Magdalena rachiꞌl ri María unan ri José xkilo jawjeꞌ xmuqiꞌ wi kanoq ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Are xikꞌow ri qꞌij re uxlanem, ri María Magdalena, ri María unan ri Jacobo xuqujeꞌ ri Salomé xkiloqꞌ bꞌi kꞌokꞌ taq kunabꞌal rech keꞌkikojo kan che ri utyoꞌjal ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sibꞌalaj kamuquq na pa ri nabꞌe qꞌij rech ri wuq qꞌij, ri ixoqibꞌ xebꞌe chuchiꞌ ri muqbꞌal. ");
INSERT INTO quctt_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Kakibꞌila chibꞌil taq kibꞌ pa ri bꞌe: ¿Jachin ta kꞌu kabꞌanow toqꞌobꞌ chaqe karesaj ri abꞌaj chuchiꞌ ri muqbꞌal? ");
INSERT INTO quctt_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Jeriꞌ kakibꞌij rumal ri abꞌaj ri kꞌo chuchiꞌ ri muqbꞌal sibꞌalaj nim. Are xoꞌpanik xkilo chi ri abꞌaj esatal chi kanoq chuchiꞌ ri muqbꞌal. ");
INSERT INTO quctt_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Xoꞌk bꞌi pa ri muqbꞌal, kꞌa te xkilo kꞌo jun ala tꞌuyulik pa ri uwiqiqꞌabꞌ rech ri xkꞌojiꞌ wi ri Jesús, sibꞌalaj saq ri ratzꞌyaq. Ri ixoqibꞌ sibꞌalaj xkixiꞌj kibꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ri ángel xubꞌij chike: Man kixiꞌj ta iwibꞌ. Ix tajin kitzukuj ri Jesús ri xripik. Man kꞌo ta chi waral, xane xkꞌastaj uwach. Chixkaꞌyoq jawjeꞌ le xkꞌojiꞌ wi. ");
INSERT INTO quctt_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Jix kꞌut, jiꞌtzijoj chike ri tijoxelabꞌ xuqujeꞌ che ri Pedro: “Ri Jesús xnabꞌej apanoq chiꞌwach xeꞌ je laꞌ pa Galilea, je laꞌ kiwil wi na uwach, jetaq ri ubꞌim chiꞌwe.” ");
INSERT INTO quctt_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ri ixoqibꞌ xebꞌiribꞌobꞌik, xaꞌnimaj bꞌik, xeꞌl bꞌik chuchiꞌ ri muqbꞌal rukꞌ xibꞌin ibꞌ. Maj xkitzijoj wi ri xkilo. ");
INSERT INTO quctt_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","/Are xkꞌastaj ri Jesús pa ri nabꞌe qꞌij rech ri wuq qꞌij, xukꞌut ribꞌ choch ri María Magdalena, ri xesax wuqubꞌ itzel uxlabꞌal che. ");
INSERT INTO quctt_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ri María Magdalena xeꞌ chutzijoxik chike konojel ri xekꞌojiꞌ rukꞌ ri Jesús. Konojel tajin kebꞌisonik xuqujeꞌ koꞌqꞌik. ");
INSERT INTO quctt_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Are xubꞌij chike chi xril uwach ri Jesús kꞌastajinaq chik, man xkikoj taj. ");
INSERT INTO quctt_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ri Jesús xukꞌut xuqujeꞌ ribꞌ chikiwach e kebꞌ chike ri tijoxelabꞌ are e bꞌenaq pa ri kibꞌe cho ri saq. ");
INSERT INTO quctt_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ri e tijoxelabꞌ xeꞌkitzijoj chike ri nikꞌaj tijoxelabꞌ chik chi xkil ri Jesús, man xkikoj ta kꞌu ri xbꞌix chike. ");
INSERT INTO quctt_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kꞌisbꞌal re xukꞌut ribꞌ chikiwach ri e juꞌlajuj utijoxelabꞌ are tajin kewaꞌik, xuꞌyajo rumal cher man xeꞌkikoj ta ri xebꞌin chike chi xkꞌastaj uwach. ");
INSERT INTO quctt_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Xubꞌij chike ri utijoxelabꞌ: Jix pa ronojel ri uwachulew, jiꞌtzijoj ri utz laj taq tzij, chike konojel winaq. ");
INSERT INTO quctt_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ri kakojonik xuqujeꞌ kabꞌan uqasanaꞌ kakolotajik, are kꞌu ri man kakojon taq, kaqꞌat na tzij puꞌwiꞌ. ");
INSERT INTO quctt_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ri kekojon che ri nubꞌiꞌ, kekwin na. Keꞌkesaj itzel taq uxlabꞌal pa ri nubꞌiꞌ, ketzijon chi na pa juleꞌ taq tzijobꞌal. ");
INSERT INTO quctt_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Keꞌkichap na kumatz, xuqujeꞌ we kakiqumuj jaꞌ ri yaꞌtal kamisabꞌal rukꞌ, man kubꞌan ta kꞌax chike. We kakiya ri kiqꞌabꞌ pa kiwiꞌ ri yawabꞌibꞌ, kuꞌtzir na. ");
INSERT INTO quctt_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Are xtoꞌtaj ri Jesús che tzijonem kukꞌ ri tijoxelabꞌ, xkꞌam bꞌik pa ri kaj, xeꞌtꞌuyul pa ri uwiqiqꞌabꞌ ri Dios. ");
INSERT INTO quctt_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ri tijoxelabꞌ xebꞌe chutzijoxik ri ukamikal xuqujeꞌ ri kꞌastajibꞌal uwach ri Jesús pa ronojel ri tinimit. Ri Ajawxel xuꞌtoꞌo chubꞌanik ri utz laj chak, xuqujeꞌ xukꞌutu chi qas kwinel wi ri utzij rumal xuꞌtoꞌo ri tijoxelabꞌ chubꞌanik ri mayijabꞌal taq jastaq./");
INSERT INTO quctt_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Loqꞌalaj Teófilo: E kꞌi ri winaq ri xkaj xkitzꞌibꞌaj pa cholaj ri tzijobꞌelil chrij ri qas xkꞌulmataj waral chiqaxoꞌl. ");
INSERT INTO quctt_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Are waꞌ ri xkikꞌut loq chiqawach ri qas xiꞌlow ronojel ri xkꞌulmatajik pa ri majibꞌal re, ri e tzijol taq re ri utz laj tzij. ");
INSERT INTO quctt_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ri in xuqujeꞌ sibꞌalaj utz rilik xuqujeꞌ usolixik xinbꞌano rech xinwetaꞌmaj ronojel ri ucholajil ri jastaq ri xkꞌulmatajik qas pa ri majibꞌal rech. Rumal waꞌ xinchomaj utzꞌibꞌaxik chawe pa ucholajil, nimalaj Teófilo, ");
INSERT INTO quctt_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","rech kawetaꞌmaj ri qas tzij chrij ri kꞌutuꞌn ri yaꞌom chawe. ");
INSERT INTO quctt_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Pa taq ri qꞌij che riꞌ are taqanel ri Herodes pa ri Judea, kꞌo jun chꞌawenel cho ri Dios ubꞌiꞌ Zacarías jun chike ri wok e rijaꞌl ri Abías, ri rixoqil are ri Elisabet, rijaꞌl ri Aarón. ");
INSERT INTO quctt_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Kikꞌulajal e utz laj taq winaq, sukꞌ kanimaꞌ cho ri Dios. Xeniman che ronojel ri utaqanik ri Dios. Man kꞌo ta etzelal xkibꞌano. ");
INSERT INTO quctt_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Maj kꞌu e kal rumal cher ri Elisabet man kakwin taj kuya ral pa ri uwachulew xuqujeꞌ e nimaq taq winaq chik. ");
INSERT INTO quctt_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Jun qꞌijal ri Zacarías are tajin kapatanij pa ri Templo rech ri Dios rumal cher xuriq ri qꞌij are kapatanik ri uwo kaj. ");
INSERT INTO quctt_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Jacha ri kubꞌij ri naqꞌatajibꞌal kech ri chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq, kakikꞌyaq rij jachin ri chꞌawenel kok bꞌik pa utemplo ri Dios chutzujik ri incienso. ");
INSERT INTO quctt_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Are tajin kaporox ri incienso, ri winaq ri kimulim kibꞌ tajin kakibꞌan apanoq chꞌawem cho ri Templo rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Are tajin kuporoj incienso ri Zacarías xukꞌut ribꞌ jun ángel choch, xtakꞌiꞌ pa ri wiqiqꞌabꞌ rech ri tzujbꞌal sipanik jaw ri kaporox wi ri incienso. ");
INSERT INTO quctt_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Are xril ri Zacarías ri ángel, xkꞌaxir ranimaꞌ, sibꞌalaj xuxiꞌj ribꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ri ángel xubꞌij che: Man kaxiꞌj ta awibꞌ. Ri achꞌawem xtataj rumal ri Dios. Kakꞌojiꞌ na jun akꞌojol rukꞌ ri awixoqil Elisabet, Juan kakoj che ubꞌiꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Sibꞌalaj katkiꞌkot na rumal rech ri akꞌal, xuqujeꞌ e kꞌi winaq kekiꞌkot na we xkil uwach. ");
INSERT INTO quctt_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Jeriꞌ rumal cher nim na uqꞌij cho ri Dios. Man kutij ta wi vino xuqujeꞌ tzam. Kanojisax na che ri Tyoxalaj Uxlabꞌixel are kꞌo chupam ri unan. ");
INSERT INTO quctt_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","E kꞌi winaq aꞌj Israel ketzalij na rukꞌ ri Ajawxel ri kiDios rumal rech areꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kanabꞌej na cho ri Ajawxel rukꞌ chuqꞌabꞌ xuqujeꞌ kwinem jetaq ri xya che ri Elías, kubꞌan na chi kesukꞌiꞌ ri tat nan kukꞌ ri alkꞌwaꞌlaxelabꞌ xuqujeꞌ kubꞌan na chi ri man keniman taj kakikꞌamawaꞌj ketaꞌmabꞌal chike ri sukꞌ taq winaq. Rech jeriꞌ ri winaq kakisukꞌumaj apanoq kibꞌ chirayeꞌxik ri Ajawxel. ");
INSERT INTO quctt_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ri Zacarías xubꞌij che ri ángel: ¿Jas kinbꞌan chi retaꞌmaxik chi qas kakꞌulmataj na we jastaq riꞌ? In in riꞌj achi chik, ri wixoqil xuqujeꞌ bꞌenaq chi ri ujunabꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ri ángel xubꞌij: In in Gabriel, in kꞌo cho ri Dios chanim, areꞌ xintaqow loq chubꞌixik we utz laj taq tzij riꞌ chawe. ");
INSERT INTO quctt_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Rumal kꞌu cher man xakoj ta ri xinbꞌij chawe, katmemar kan chanim, man katkwin taj katchꞌawik, ka chi kꞌol na ri akꞌal kꞌa te riꞌ kajaqataj ri achꞌabꞌal. Kakꞌulmataj na ri nutzij pa ri qꞌotaj ri kajawatajik. ");
INSERT INTO quctt_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ri winaq ri aꞌyeninaq ri Zacarías xemayijanik rumal cher maj ri kel loq. ");
INSERT INTO quctt_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Are xel loq, man kakwin ta chik kachꞌawik. Xaq pa memal tzij chik xtzijon kukꞌ, xkichomaj kꞌut chi xa xril jun kꞌutbꞌal pa ri Tyoxalaj kꞌolibꞌal. ");
INSERT INTO quctt_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Are xtoꞌtaj ri Zacarías che ri patanijik pa ri Templo, xtzalij cho rachoch. ");
INSERT INTO quctt_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ikꞌowinaq chi jun janipa qꞌij, ri Elisabet rixoqil ri Zacarías xkanaj yawabꞌ ixoq. Ri Elisabet jobꞌ ikꞌ xaq cho rachoch xkꞌojiꞌ wi. ");
INSERT INTO quctt_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Sibꞌalaj utz ri wAjaw, xinresaj pa ri nukꞌixibꞌal rech man kinkiyoqꞌ ta chi ri winaq, xcha ri Elisabet. ");
INSERT INTO quctt_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Pa ri uwaq ikꞌ rech ri uyawajik ri Elisabet, xtaq loq ri ángel Gabriel pa Nazaret, jun leꞌaj ri kꞌo pa Galilea. ");
INSERT INTO quctt_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Xopan rukꞌ jun qꞌapoj ali, ubꞌiꞌ María, ri tzꞌonom chik rumal jun achi ubꞌiꞌ José, jun rijaꞌl ri Taqanel David. ");
INSERT INTO quctt_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ri Gabriel xukꞌut ribꞌ choch ri María, xubꞌij che: ¡Rutzil awach, at jun ixoq chaꞌtalik, ri Ajawxel kꞌo awukꞌ! ");
INSERT INTO quctt_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ri María xsach ukꞌuꞌx, xkꞌaxkꞌobꞌ ranimaꞌ, xuchomaj rij ri kubꞌij ri ángel. ");
INSERT INTO quctt_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ri ángel xubꞌij che: ¡Man kaxiꞌj ta awibꞌ María, at chaꞌtal rumal ri Dios! ");
INSERT INTO quctt_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Katiktaj na jun akꞌal chawe, kalax na, kakoj Jesús che ubꞌiꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kanimar na uqꞌij, kabꞌix na ukꞌojol ri Nimalaj Dios che. Ri Ajawxel Dios kukoj na che nim taqanel jetaq ri qamam David. ");
INSERT INTO quctt_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Amaqꞌel kataqan na puꞌwiꞌ ri tinimit Israel, ri utaqanik maj ukꞌisik. ");
INSERT INTO quctt_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ri María xubꞌij: ¿Jamo riꞌ kakꞌulmataj we riꞌ? Man in kꞌolinaq ta in rukꞌ achi. ");
INSERT INTO quctt_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ri ángel xubꞌij che: Ri Tyoxalaj Uxlabꞌixel kaqaj na loq paꞌwiꞌ. Ri ukwinem ri nimalaj Dios katuchꞌuq na. Rumal riꞌ, ri neꞌ riꞌ ri kakꞌojiꞌ na, jun Tyoxalaj akꞌal, xuqujeꞌ kubꞌiꞌnaꞌj na Ralkꞌwaꞌl ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ri Elisabet ri awachalal xkanaj yawabꞌ winaq pa ri uriꞌjobꞌnaqil. Waqibꞌ ikꞌ chik yawabꞌ winaq pune xbꞌix che kumal ri winaq chi man kakwin taj kuꞌya ral pa ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Maj jun jastaq ri mat kakwin ri Dios che ubꞌanik. ");
INSERT INTO quctt_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ri María xubꞌij: In patanil rech ri Ajawxel. Kꞌulmataj wukꞌ ronojel ri xabꞌij. Ri ángel xtzalijik. ");
INSERT INTO quctt_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Kebꞌ oxibꞌ qꞌij chik ikꞌowinaq we kꞌulmatajem riꞌ, ri María xeꞌ pa taq ri juyubꞌ pa ri tinimit rech Judea. ");
INSERT INTO quctt_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Are xopan chilaꞌ, xok bꞌik pa ri rachoch ri Zacarías, xuya rutzil uwach ri Elisabet. ");
INSERT INTO quctt_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Are xuta ri Elisabet ri rutzil wach ri xya rumal ri María, xchꞌoplaj ri ral chupam, xnoj kꞌut che ri Tyoxalaj Uxlabꞌixel. ");
INSERT INTO quctt_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ri Elisabet xuraq uchiꞌ chech kiꞌkotemal, xubꞌij che ri María: Sibꞌalaj at tewchiꞌtalik chikiwach konojel ri ixoqibꞌ. Xuqujeꞌ tewchiꞌtal ri awal. ");
INSERT INTO quctt_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Jas che xya bꞌe chwe, kinulusolij ri unan ri Wajaw? ");
INSERT INTO quctt_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Are xinta ri rutzil nuwach xuyaꞌo, xchꞌoplaj ri nuneꞌ ri kꞌo chinupam xchꞌoplaj che kiꞌkotemal. ");
INSERT INTO quctt_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Sibꞌalaj at tewchiꞌtalik rumal cher xakojo chi ri Ajawxel kubꞌan ri xuchiꞌj chawe. ");
INSERT INTO quctt_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ri María xubꞌij: Ri wanimaꞌ sibꞌalaj kuqꞌijilaꞌj ri Ajawxel. ");
INSERT INTO quctt_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Sibꞌalaj kakiꞌkot ri wanimaꞌ pa ri nuDios, nukolonel. ");
INSERT INTO quctt_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Xel ukꞌuꞌx che we patanijel rech ri man nim ta uqꞌij. Konojel kꞌu ri winaq kakibꞌij na riꞌ chwe chi in tewchiꞌtalik. ");
INSERT INTO quctt_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Jeriꞌ rumal cher ri Tyox xuqujeꞌ kwinel laj Dios xubꞌan nimalaj taq jastaq wukꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kutoqꞌobꞌisaj kiwach konojel ri winaq ri e kꞌolik xuqujeꞌ ri kekꞌojiꞌ na. Ri winaq kakimochꞌ kibꞌ choch. ");
INSERT INTO quctt_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Rukꞌ ri utelebꞌ xubꞌan nimalaj taq jastaq, xusach kiwach ri winaq ri nimal chike xuqujeꞌ ri kakinimarisaj kibꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Xresaj ri taqanik pa kiqꞌabꞌ ri nimaꞌq kibꞌanik, xuya kiqꞌij ri winaq ri nim taj kiqꞌij. ");
INSERT INTO quctt_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Xuya jastaq kech ri kenumik, maj ke ri qꞌinomabꞌ xuyaꞌo. ");
INSERT INTO quctt_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Xutoꞌ ri utinimit Israel, man xsachan ta che ubꞌanik ri utzilal kukꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Jeriꞌ xubꞌano rumal cher xuchiꞌj kan che ri qamam Abraham xuqujeꞌ amaqꞌel chike ri e rijaꞌl chi jewaꞌ kubꞌan na. ");
INSERT INTO quctt_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ri María xkanaj kan oxibꞌ ikꞌ rukꞌ ri Elisabet kꞌa te riꞌ xtzalij cho rachoch. ");
INSERT INTO quctt_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Are xopan ri qꞌij, kakꞌojiꞌ ri ral ri Elisabet, xalax ri ral, ala ri ral. ");
INSERT INTO quctt_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ri ukꞌulja ri Elisabet xuqujeꞌ ri e rachalal xekiꞌkotik are xketaꞌmaj chi ri Dios sibꞌalaj xutoqꞌobꞌisaj uwach ri Elisabet. ");
INSERT INTO quctt_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Are xtzꞌaqat wajxaqibꞌ uqꞌij ri neꞌ, xkimulij kibꞌ rech kakilo kakoj retal, xkaj kꞌut xkikoj Zacarías che ubꞌiꞌ, jetaq ri ubꞌiꞌ ri utat. ");
INSERT INTO quctt_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ri Elisabet kꞌut xubꞌij: ¡Man je ta riꞌ! Juan kubꞌiꞌnaꞌj we akꞌal riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","¿Jas che? xecha ri winaq. Man kꞌo ta jun chike ri awachalal jeriꞌ ubꞌiꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Pa memal tzij kꞌut xkita che ri utat ri akꞌal jas ubꞌiꞌ ri ukꞌojol kukojo. ");
INSERT INTO quctt_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ri Zacarías xuta jun chꞌaqaꞌp tzꞌalam chike rech kutzꞌibꞌaj choch jas ri bꞌiꞌaj. Sibꞌalaj xemayijan kꞌut are xkilo ri xutzꞌibꞌaj “Juan ubꞌiꞌ.” ");
INSERT INTO quctt_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Aninaq xjaqataj ri uchꞌabꞌal ri Zacarías, xuchapleꞌj uqꞌijilaꞌxik ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Xtzijox kꞌu ronojel we kꞌulmatajem riꞌ pa taq ri tinimit ri kꞌo pa taq ri juyubꞌ rech Judea, konojel ri e kuꞌl ja xkixiꞌj kibꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Konojel ri winaq ri xetowik kakitatabꞌela chibꞌil taq kibꞌ: ¿Jas kux we akꞌal ri? Jeꞌ xkibꞌij waꞌ rumal qꞌalaj chi ri Ajawxel Dios kꞌo rukꞌ ri akꞌal. ");
INSERT INTO quctt_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ri Zacarías, ri utat ri akꞌal, xnoj che ri Uxlabꞌixel, xubꞌij: ");
INSERT INTO quctt_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Chiqꞌijilaꞌj ri Ajawxel, ri Dios rech ri tinimit Israel, xusolij ri utinimit, xutoꞌo pa ri qꞌoxom. ");
INSERT INTO quctt_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Xutaq loq jun kwinel laj kolonel rijaꞌl ri patanil rech, David. ");
INSERT INTO quctt_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Are waꞌ ri xuchiꞌj loq ri Dios chi kichiꞌ ri tyoxalaj taq qꞌalajisal taq rech ri utzij, ojer. ");
INSERT INTO quctt_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Kujutoꞌ na pa kiqꞌabꞌ ri e qakꞌulel, xuqujeꞌ pa kiqꞌabꞌ ri kaketzelaj qawach. ");
INSERT INTO quctt_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Rech kutoqꞌobꞌisaj kiwach ri e qamam rumal cher xnaꞌtaj che ri chꞌekom tzij ri xubꞌano. ");
INSERT INTO quctt_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Are waꞌ ri chꞌekom tzij xubꞌan kan rukꞌ ri qamam Abraham. ");
INSERT INTO quctt_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Xujesax na pa kiqꞌabꞌ ri qakꞌulel rech kaqapatanij ri Dios man rukꞌ ta xibꞌin ibꞌ, ");
INSERT INTO quctt_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","rukꞌ jun tyoxalaj kꞌaslemal xuqujeꞌ sukꞌal, pa ronojel qꞌij rech ri qakꞌaslemal. ");
INSERT INTO quctt_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","At, nukꞌojol, kabꞌix na qꞌalajisal rech ri utzij ri nimalaj Dios chawe, kasukꞌumaj na apanoq ri ubꞌe ri Ajawxel. ");
INSERT INTO quctt_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Katzijoj na jas kakibꞌan ri winaq rech kekolotajik xuqujeꞌ kekuyutaj che ri kimak. ");
INSERT INTO quctt_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Tyox che ri utoqꞌobꞌ ri Dios, katunan na ri tunal rech pa ri kaj, chiqaxoꞌl. ");
INSERT INTO quctt_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Kuꞌtunaj na ri e kꞌo pa ri qꞌequꞌmal, pa ri uqꞌequꞌmal ri kamikal, xuqujeꞌ kukꞌam na qabꞌe pa ri ubꞌeal ri jaꞌmaril. ");
INSERT INTO quctt_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Xkꞌiy kꞌu ri Juan, sibꞌalaj xpe uchuqꞌabꞌ pa ri ranimaꞌ. Xkꞌojiꞌ pa ri katzꞌinow ulew kꞌa pa ri qꞌij are xukꞌut ribꞌ chkiwach ri winaq aꞌj Israel. ");
INSERT INTO quctt_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Pa taq ri qꞌij riꞌ, xya jun taqanik rumal ri César Augusto rech konojel ri winaq kakitzꞌibꞌaj kibꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Are waꞌ ri nabꞌe ajilanik ri xbꞌanik che riꞌ are qꞌatal tzij ri Cirenio pa ri tinimit Siria.) ");
INSERT INTO quctt_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Konojel xetzalij pa taq ri kitinimit, rech kakitzꞌibꞌaj kibꞌ pa ri ajilanik. ");
INSERT INTO quctt_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ri José xel bꞌik pa ri leꞌaj Nazaret, xeꞌ pa Galilea pa ri tinimit Belén ri kꞌo pa ri tinimit Judea, najtir ukꞌolibꞌal ri David. ");
INSERT INTO quctt_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Xukꞌam bꞌik ri rixoqil María rech kuꞌtzꞌibꞌaj ribꞌ, yawabꞌ ixoq chik. ");
INSERT INTO quctt_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Are kꞌo pa ri tinimit Belén, xopan ri qꞌij kalax ri neꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Xkꞌojiꞌ kꞌu ri nabꞌe ral ala ri María, xubꞌalqꞌotij kꞌut pa atzꞌyaq, xuqꞌoyobꞌa pa jun rechabꞌal awaj rumal cher man xkiriq ta chi jun kꞌolibꞌal jawjeꞌ kekanaj wi kanoq. ");
INSERT INTO quctt_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","E kꞌo kꞌu aꞌjyuqꞌabꞌ cho taq ri saq che ri chaqꞌabꞌil riꞌ tajin keꞌkichajij ri kichij. ");
INSERT INTO quctt_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Xaq kꞌa teꞌ xukꞌut ribꞌ chikiwach jun ángel taqom loq rumal ri Ajawxel Dios. Ri ujuluwem ri Dios xsutin chikij. Ri aꞌjyuqꞌabꞌ xkixiꞌj kibꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ri ángel xubꞌij chike: Man kixiꞌj ta iwibꞌ, nukꞌamom loq utz laj tzij chiꞌwe, ri kuya na kiꞌkotemal chike konojel ri winaq. ");
INSERT INTO quctt_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kamik xalax pa ri utinimit ri David jun Kolonel, are ri Mesías ri Ajawxel. ");
INSERT INTO quctt_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ri retal chiꞌwe are chi: Kiriq na jun laj akꞌal, bꞌalqꞌotital pa atzꞌyaq, qꞌoyobꞌatal pa jun rechabꞌal awaj. ");
INSERT INTO quctt_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Xaq kꞌa te xepe sibꞌalaj e kꞌi angelibꞌ rukꞌ ri nabꞌe ángel, xkiqꞌijilaꞌj ri Dios, xkibꞌij: ");
INSERT INTO quctt_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Juluwem che ri Dios ri kꞌo pa ri kaj, jaꞌmaril kukꞌ ri winaq ri kuꞌloqꞌaj ri Dios, ri e kꞌo cho ri uwachulew! ");
INSERT INTO quctt_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Are xetzalij ri angelibꞌ pa ri kaj, ri aꞌjyuqꞌabꞌ xkibꞌij chibꞌil taq kibꞌ: Joꞌ pa Belén, jeꞌqila ri xutzijoj ri Ajawxel chaqe. ");
INSERT INTO quctt_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Aninaq xebꞌe pa ri leꞌaj, xeꞌkiriqa ri María, ri José xuqujeꞌ ri kꞌin laj akꞌal qꞌoyol pa ri rechabꞌal awaj. ");
INSERT INTO quctt_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Are xiltaj kumal, ri aꞌjyuqꞌabꞌ xkitzijoj chike konojel ri winaq, ri xkilo xuqujeꞌ ri xubꞌij ri ángel chike. ");
INSERT INTO quctt_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Konojel ri winaq ri xetow ronojel ri xkitzijoj ri aꞌjyuqꞌabꞌ xemayijanik. ");
INSERT INTO quctt_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Are kꞌu ri María xuyak pa ranimaꞌ ronojel we jastaq riꞌ, amaqꞌel xuchomaj rij. ");
INSERT INTO quctt_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ri aꞌjyuqꞌabꞌ xetzalij chuchajixik ri kichij, xkiqꞌijilaꞌj ri Dios rumal ri xkilo xuqujeꞌ xkito. Je xkꞌulmatajik jetaq ri xutzijoj ri ángel chike. ");
INSERT INTO quctt_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Are xikꞌow wajxaqibꞌ qꞌij, xkoj retal ri neꞌ, Jesús xkoj che ubꞌiꞌ. Are waꞌ ri ubꞌiꞌ ri xbꞌix rumal ri ángel are majaꞌ kalaxik. ");
INSERT INTO quctt_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Xopan ri qꞌij ri katzuj ri sipanik rech chꞌajchꞌojil jetaq ri kutoqꞌij ri utaqanik ri Moisés, are kakꞌojiꞌ jun akꞌal, xaq jeriꞌ ri utat unan xkikꞌam bꞌik pa Jerusalén chutzujik cho ri Ajawxel. ");
INSERT INTO quctt_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Kubꞌij ri taqanik: We ala ri nabꞌyal ral ri ixoq, rajawaxik katzuj cho ri Dios e kebꞌ tukmux o jukꞌulaj palomax. ");
INSERT INTO quctt_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Xaq jeriꞌ xkitzuj ri sipanik jetaq ri kubꞌij ri utaqanik ri Ajawxel, kebꞌ tukmux o jukꞌulaj palomax. ");
INSERT INTO quctt_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Pa taq ri qꞌij riꞌ, kꞌo jun achi ubꞌiꞌ Simeón pa ri tinimit Jerusalén, we achi riꞌ sukꞌ xuqujeꞌ utz ranimaꞌ rayeꞌm chi kulkubꞌisax ukꞌuꞌx ri tinimit Israel. ");
INSERT INTO quctt_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Kꞌuttal kꞌu choch chi man kakam taj we man nabꞌe karil kan uwach ri Mesías rech ri Ajawxel. ");
INSERT INTO quctt_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Che ri qꞌij riꞌ, xkꞌam bꞌik rumal ri Tyoxalaj Uxlabꞌixel, xeꞌ pa ri Templo rech ri Dios. Xaq jeriꞌ are xopan ri María rachiꞌl ri José chutzujik ri neꞌ Jesús, jetaq ri kubꞌij ri utaqanik ri Ajawxel. ");
INSERT INTO quctt_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ri Simeón kꞌo chilaꞌ, xuqꞌaluj ri akꞌal, xuqujeꞌ xuqꞌijilaꞌj ri Dios, xubꞌij: ");
INSERT INTO quctt_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ajawxel, chanim ya bꞌa la bꞌe kakam we patanil e la pa jaꞌmaril jetaq ri bꞌim la loq. ");
INSERT INTO quctt_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Xinwil rukꞌ ri nubꞌoqꞌoch ri koltajem la. ");
INSERT INTO quctt_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ri xtaq la loq chike konojel ri winaq. ");
INSERT INTO quctt_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Areꞌ ketunan na ri winaq rech kakil ri Dios, areꞌ ujuluwem ri tinimit Israel. ");
INSERT INTO quctt_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ri utat unan ri Jesús sibꞌalaj xemayijanik che ri kabꞌix che ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ri Simeón xuꞌtewechiꞌj, xubꞌij che ri María, ri unan: E kꞌi winaq aꞌj Israel ketzaq na rumal re we akꞌal riꞌ, xuqujeꞌ kuya na kiꞌkotem chike nikꞌaj chik. Kux xuqujeꞌ na jun etal rech tijoj chuqꞌabꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Rumal rech, kaqꞌalajin na ri chomabꞌal rech ri kanimaꞌ ri winaq, chawe at ri at unan, ronojel we jastaq riꞌ je ri kok na jun chꞌichꞌ che ri awanimaꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kꞌo xuqujeꞌ jun qꞌalajisal utzij ri Dios, jun ixoq ubꞌiꞌ Ana ri kꞌo pa ri Templo rech ri Dios, umiꞌal ri Fanuel, rech ri jupuq winaq Aser. Wuqubꞌ junabꞌ e kꞌulanik xkam ri rachajil. ");
INSERT INTO quctt_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Junmuchꞌ kajibꞌ ujunabꞌ, man kel ta wi pa ri Templo. Chi paqꞌij chi chaqꞌabꞌ kuqꞌijilaꞌj ri Dios, kubꞌan chꞌawem xuqujeꞌ man kawaꞌtaj. ");
INSERT INTO quctt_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ri ixoq xopanik are tajin katzijon ri Simeón rukꞌ ri María rachiꞌl ri José, xuchapleꞌj uqꞌijilaꞌxik ri Dios, xutzijoj rij ri akꞌal chike konojel ri kayeꞌm kakolotaj ri tinimit Jerusalén, rumal ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Are xtzꞌaqat ubꞌanik ronojel ri kutoqꞌij ri utaqanik ri Ajawxel kumal ri utat unan ri Jesús, xetzalij cho kachoch je laꞌ pa Nazaret pa Galilea. ");
INSERT INTO quctt_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Chilaꞌ xkꞌiy wi ri akꞌal, utz uwach xuqujeꞌ xkꞌojiꞌ uchuqꞌabꞌ. Sibꞌalaj xkꞌiy retaꞌmabꞌal, ri utoqꞌobꞌ ri Dios kꞌo rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ronojel junabꞌ ri utat unan ri Jesús xebꞌe pa ri tinimit Jerusalén, pa ri nimaqꞌij Pascua. ");
INSERT INTO quctt_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Are kabꞌlajuj ujunabꞌ ri Jesús, xebꞌe pa Jerusalén jetaq ri naqꞌatal chike. ");
INSERT INTO quctt_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Are xkꞌis ri nimaqꞌij, xkichapleꞌj tzalijem loq pa ri tinimit Nazaret, ri utat unan ri Jesús man xkinabꞌej taj chi xkanaj kan ri Jesús pa Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Pa kikꞌuꞌx chi kꞌo chikixoꞌl ri nikꞌaj winaq chik. Are xuriq chaqꞌabꞌ, xkichapleꞌj utzukuxik chikixoꞌl ri e rech chꞌabꞌeꞌn xuqujeꞌ ri rachalal, man xkiriq ta kꞌut. ");
INSERT INTO quctt_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Are man xkiriq taj, xetzalij pa ri tinimit Jerusalén chutzukuxik. ");
INSERT INTO quctt_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Oxibꞌ qꞌij chik ikꞌowinaq are xeꞌkiriqa ri Jesús kꞌo pa ri Templo, tꞌuyul chkixoꞌl ri aꞌjtijabꞌ rech ri taqanik, tajin kuꞌtatabꞌej xuqujeꞌ tajin kukꞌot kichiꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Konojel ri tajin ketatabꞌenik xemayijan che ri retaꞌmabꞌal xuqujeꞌ ri tzalibꞌal wach ri xuya ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Are xkilo, xemayijanik ri unan xubꞌij che: Ala, ¿jas che je xabꞌan we riꞌ chaqe? In rachiꞌl ri atat tajin katqatzukuj pa ronojel kꞌolibꞌal. ");
INSERT INTO quctt_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ri Jesús xubꞌij chike: ¿Jas che kintzukuj alaq? ¿La man etaꞌm alaq chi pa rachoch ri nuTat rajawaxik kinkꞌojiꞌ wi? ");
INSERT INTO quctt_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Man xkichꞌobꞌ ta kꞌu ri utat unan jas che jewaꞌ xubꞌij. ");
INSERT INTO quctt_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Xtzalij kꞌu kukꞌ ri utat unan pa ri tinimit Nazaret xuqujeꞌ xniman chike. Ri unan xukꞌol pa ranimaꞌ ronojel ri jastaq ri xkꞌulmatajik. ");
INSERT INTO quctt_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Xkꞌiy kꞌu ri Jesús, pa ri utoqꞌobꞌ ri Dios, xkꞌojiꞌ retaꞌmabꞌal, xuqujeꞌ xqaj ri unoꞌjibꞌal chikiwach konojel ri winaq. ");
INSERT INTO quctt_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Pa ri roꞌlajuj junabꞌ rech ri utaqanik ri Tiberio César, che riꞌ are taqanel ri Poncio Pilato pa Judea. Ri Herodes are nim taqanel pa Galilea. Ri Felipe rachalal ri Herodes are qꞌatal tzij pa Iturea xuqujeꞌ pa Traconite. Ri Lisanias are qꞌatal tzij pa ri tinimit Abilinia. ");
INSERT INTO quctt_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ri Anás rachiꞌl ri Caifás are kinimaꞌqil ri chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq aꞌj Israel. Pa taq ri qꞌij riꞌ, ri utzij ri Dios xtaq che ri Juan ri ukꞌojol ri Zacarías, are kꞌo pa ri katzꞌinow ulew. ");
INSERT INTO quctt_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ri Juan xbꞌin chunaqaj ri nimaꞌ Jordán, xutzijoj chike ri winaq chi utz kabꞌan kiqasanaꞌ rech kakiqꞌalajisaj chi xkikꞌex kanimaꞌ xuqujeꞌ ketzalij rukꞌ ri Dios, rech kakuyutaj ri kimak. ");
INSERT INTO quctt_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ri Isaías xutzijoj la rij ri Juan are xubꞌij: Uchꞌabꞌal jun winaq ri kuraq uchiꞌ pa ri katzꞌinow ulew, kubꞌij: Chisukꞌumaj ri ubꞌe ri Ajawxel, chibꞌana sukꞌum che. ");
INSERT INTO quctt_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kenojisax na ri siwan, konojel ri juyubꞌ kuꞌx na leaꞌnik, ri kotokaꞌq taq bꞌe kesukꞌumax na xuqujeꞌ ri abꞌaj taq bꞌe kechꞌajchꞌobꞌex na. ");
INSERT INTO quctt_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Konojel kakil na ri koltajem ri kutaq loq ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Sibꞌalaj kꞌi winaq xoꞌpan rukꞌ ri Juan rech kubꞌan kiqasanaꞌ. Ri Juan xubꞌij chike: Kijaꞌl taq kumatz, ¿jachin xbꞌin chiꞌwe chi kixkwinik kixanimaj choch ri rayowal ri Dios ri kape na? ");
INSERT INTO quctt_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Qas utz chixnoꞌjinoq rech qas kaqꞌalajinik chi qas xikꞌex ikꞌuꞌx. Man kixkwin ta kꞌut kibꞌij: “Are qatat ri Abraham.” Rumal kinbꞌij chiꞌwe chi ri Dios kakwinik kubꞌano chi kekꞌiy ralkꞌwaꞌl ri Abraham chike we abꞌaj riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ri ikaj xaq yaꞌtal chik rukꞌ ri ukꞌaꞌmalil ri cheꞌ. Ronojel kꞌu cheꞌ ri man kuya ta uwach kaqasax na, xuqujeꞌ kakꞌyaq na bꞌik pa ri qꞌaqꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Sibꞌalaj e kꞌi winaq xkibꞌij: ¿Jas rajawaxik kaqabꞌano? ");
INSERT INTO quctt_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ri Juan, xubꞌij chike: We kꞌo kebꞌ akamiꞌx, chaya jun rech ri maj rech. We kꞌo awa, chaya ke ri kanumik. ");
INSERT INTO quctt_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Xuqujeꞌ xoꞌpan ri toqꞌil taq alkabal rech kabꞌan kiqasanaꞌ, xkita che ri Juan: Ajtij, ¿jas rajawaxik kaqabꞌano? ");
INSERT INTO quctt_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ri Juan xubꞌij chike: Man kitoqꞌij ta uwiꞌ ri alkabal ri ix taqom chutoqꞌixik. ");
INSERT INTO quctt_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ri ajchꞌoꞌjabꞌ chajil tinimit xkibꞌij: ¿Jas rajawaxik kaqabꞌan uj? Ri Juan xubꞌij chike: Man kitoqꞌij ta pwaq chike ri winaq, man kibꞌan ta bꞌanoj tzij chikij ri winaq ri maj kimak, kuꞌl ikꞌuꞌx rukꞌ ri tojbꞌal iwe. ");
INSERT INTO quctt_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Rumal kꞌu cher ri winaq kayeꞌm ri upetibꞌal ri Mesías are kakaj kaketaꞌmaj we are Mesías ri Juan. ");
INSERT INTO quctt_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ri Juan xutzalij uwach ri kꞌotbꞌal chiꞌ xubꞌij: In kinbꞌan iqasanaꞌ rukꞌ jaꞌ, kape kꞌu na jun ri nim reqeleꞌn chinuwach in, man taqal ta chwe kinux jun patanijel, xuqujeꞌ man taqal ta chwe kinkir ri jatꞌibꞌal rech ri uxajabꞌ. Areꞌ kubꞌan iqasanaꞌ rukꞌ ri Tyoxalaj Uxlabꞌixel xuqujeꞌ rukꞌ qꞌaqꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Areꞌ xaq rayeꞌm kujosqꞌij ri tiriko, rukꞌ ri uchaꞌbꞌal. Xuqujeꞌ kumulij bꞌik ri utiriko, kuya pa ri utarroz. Kuporoj na ri pajo pa jun qꞌaqꞌ ri maj ukꞌisik. ");
INSERT INTO quctt_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Sibꞌalaj kꞌi ri xubꞌan ri Juan chuqꞌalajisaxik chike ri winaq ri utz laj taq tzij. ");
INSERT INTO quctt_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ri Juan xuqujeꞌ xuyaj ri Herodes Antipas chikiwach konojel ri winaq rumal xkꞌuliꞌk rukꞌ ri Herodías, rixoqil ri rachalal, je xuqujeꞌ rumal kꞌi itzel taq jastaq ri ubꞌanom, ");
INSERT INTO quctt_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","rumal riꞌ ri Herodes xukoj ri Juan pa cheꞌ, xnimar ri umak. ");
INSERT INTO quctt_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jun qꞌijal, ri Juan are tajin kubꞌan kiqasanaꞌ e kꞌi winaq, xubꞌan uqasanaꞌ ri Jesús. Are tajin kubꞌan chꞌawem ri Jesús xjaqataj ri kaj. ");
INSERT INTO quctt_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Xilitaj kꞌut xqaj loq ri Tyoxalaj Uxlabꞌixel puꞌwiꞌ ri Jesús jeꞌ jas jun palomax. Xtataj xuqujeꞌ jun chꞌabꞌal pa ri kaj ri kubꞌij: At at loqꞌalaj nukꞌojol, sibꞌalaj kaya kiꞌkotem chwe. ");
INSERT INTO quctt_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Juwinaq lajuj ujunabꞌ ri Jesús are xuchapleꞌj chakunem kukꞌ ri winaq. Ri Jesús xetaꞌmax uwach chi ralkꞌwaꞌl ri José, ri José ralkꞌwaꞌl ri Elí, ");
INSERT INTO quctt_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ri Elí ralkꞌwaꞌl ri Matat, ri Matat ralkꞌwaꞌl ri Leví, ri Leví ralkꞌwaꞌl ri Melqui, ri Melqui ralkꞌwaꞌl ri Jana, ri Jana ralkꞌwaꞌl ri José, ");
INSERT INTO quctt_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ri José ralkꞌwaꞌl ri Matatías, ri Matatías ralkꞌwaꞌl ri Amós, ri Amós ralkꞌwaꞌl ri Nahúm, ri Nahúm ralkꞌwaꞌl ri Esli, ri Esli ralkꞌwaꞌl ri Nagai, ");
INSERT INTO quctt_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ri Nagai ralkꞌwaꞌl ri Maat, ri Maat ralkꞌwaꞌl ri Matatías, ri Matatías ralkꞌwaꞌl ri Semei, ri Semei ralkꞌwaꞌl ri José, ri José ralkꞌwaꞌl ri Judá, ");
INSERT INTO quctt_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ri Judá ralkꞌwaꞌl ri Joana, ri Joana ralkꞌwaꞌl ri Resa, ri Resa ralkꞌwaꞌl ri Zorobabel, ri Zorobabel ralkꞌwaꞌl ri Salatiel, ri Salatiel ralkꞌwaꞌl ri Neri, ");
INSERT INTO quctt_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ri Neri ralkꞌwaꞌl ri Melqui, ri Melqui ralkꞌwaꞌl ri Adi, ri Adi ralkꞌwaꞌl ri Cosam, ri Cosam ralkꞌwaꞌl ri Elmodam, ri Elmodam ralkꞌwaꞌl ri Er, ");
INSERT INTO quctt_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ri Er ralkꞌwaꞌl ri Josué, ri Josué ralkꞌwaꞌl ri Eliezer, ri Eliezer ralkꞌwaꞌl ri Jorim, ri Jorim ralkꞌwaꞌl ri Matat, ");
INSERT INTO quctt_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ri Matat ralkꞌwaꞌl ri Leví, ri Leví ralkꞌwaꞌl ri Simeón, ri Simeón ralkꞌwaꞌl ri Judá, ri Judá ralkꞌwaꞌl ri José, ri José ralkꞌwaꞌl ri Jonán, ri Jonán ralkꞌwaꞌl ri Eliaquim, ");
INSERT INTO quctt_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ri Eliaquim ralkꞌwaꞌl ri Melea, ri Melea ralkꞌwaꞌl ri Mainán, ri Mainán ralkꞌwaꞌl ri Matata, ri Matata ralkꞌwaꞌl ri Natán, ri Natán ralkꞌwaꞌl ri David, ");
INSERT INTO quctt_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ri David ralkꞌwaꞌl ri Isaí, ri Isaí ralkꞌwaꞌl ri Obed, ri Obed ralkꞌwaꞌl ri Booz, ri Booz ralkꞌwaꞌl ri Salmón, ri Salmón ralkꞌwaꞌl ri Naasón, ");
INSERT INTO quctt_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ri Naasón ralkꞌwaꞌl ri Aminadab, ri Aminadab ralkꞌwaꞌl ri Aram, ri Aram ralkꞌwaꞌl ri Esrom, ri Esrom ralkꞌwaꞌl ri Fares, ri Fares ralkꞌwaꞌl ri Judá, ");
INSERT INTO quctt_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ri Judá ralkꞌwaꞌl ri Jacob, ri Jacob ralkꞌwaꞌl ri Isaac, ri Isaac ralkꞌwaꞌl ri Abraham, ri Abraham ralkꞌwaꞌl ri Taré, ri Taré ralkꞌwaꞌl ri Nacor, ");
INSERT INTO quctt_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ri Nacor ralkꞌwaꞌl ri Serug, ri Serug ralkꞌwaꞌl ri Ragau, ri Ragau ralkꞌwaꞌl ri Peleg, ri Peleg ralkꞌwaꞌl ri Heber, ri Heber ralkꞌwaꞌl ri Sala, ");
INSERT INTO quctt_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ri Sala ralkꞌwaꞌl ri Cainán, ri Cainán ralkꞌwaꞌl ri Arfaxad, ri Arfaxad ralkꞌwaꞌl ri Sem, ri Sem ralkꞌwaꞌl ri Noé, ri Noé ralkꞌwaꞌl ri Lamec, ");
INSERT INTO quctt_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ri Lamec ralkꞌwaꞌl ri Matusalén, ri Matusalén ralkꞌwaꞌl ri Enoc, ri Enoc ralkꞌwaꞌl ri Jared, ri Jared ralkꞌwaꞌl ri Mahalaleel, ri Mahalaleel ralkꞌwaꞌl ri Cainán, ");
INSERT INTO quctt_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ri Cainán ralkꞌwaꞌl ri Enós, ri Enós ralkꞌwaꞌl ri Set, ri Set ralkꞌwaꞌl ri Adán, ri Adán are ralkꞌwaꞌl ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Nojinaq ri Jesús che ri Uxlabꞌixel upetik chuchiꞌ ri nimaꞌ Jordán, xkꞌam bꞌik rumal ri Uxlabꞌixel pa ri katzꞌinow ulew. ");
INSERT INTO quctt_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Xkꞌojiꞌ chilaꞌ kawinaq qꞌij, sibꞌalaj kanumik rumal cher man woꞌqinaq taj, xtaqchiꞌx kꞌu che mak rumal ri Itzel. ");
INSERT INTO quctt_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ri itzel xubꞌij che ri Jesús: We qas at ukꞌojol ri Dios, chabꞌij chi kubꞌan kaxlan wa we jun abꞌaj riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ri Jesús xubꞌij che: Ri tzꞌibꞌatalik kubꞌij: Man xwi ta ri kaxlan wa kakꞌasbꞌan ri winaq. ");
INSERT INTO quctt_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Te kꞌu riꞌ ri Itzel xukꞌam bꞌik ri Jesús kꞌa puꞌwiꞌ jun nimalaj juyubꞌ, aninaq xukꞌut choch ronojel ri tinimit rech ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Xubꞌij che: Kinya ri juluwem xuqujeꞌ ri kwinem pa aqꞌabꞌ pa kiwiꞌ ronojel taq le tinimit leꞌ, rumal cher e we in kinya kꞌu na che ri winaq ri kawaj in kinya wi. ");
INSERT INTO quctt_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ronojel waꞌ kinya chawe, we katxukiꞌk chinuwach kinaqꞌijilaꞌj. ");
INSERT INTO quctt_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ri Jesús xubꞌij che: Kubꞌij ri tzꞌibꞌatalik chaqꞌijilaꞌj ri awajaw ri aDios, xaq xwi areꞌ chapatanij. ");
INSERT INTO quctt_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ri Itzel xukꞌam bꞌik ri Jesús pa ri tinimit Jerusalén, xutakꞌabꞌa puꞌwiꞌ ri Templo, xubꞌij che: We qas at ralkꞌwaꞌl ri Dios, chakꞌyaqa bꞌik awibꞌ pa ri ulew. ");
INSERT INTO quctt_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Rumal chi ri tzꞌibꞌatalik kubꞌij: Areꞌ kuꞌtaq ri angelibꞌ chatoꞌik xuqujeꞌ che achajixik. ");
INSERT INTO quctt_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Xuqujeꞌ katkitelej rukꞌ ri kiqꞌabꞌ rech man katopij ta ri awaqan cho ri abꞌaj. ");
INSERT INTO quctt_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ri Jesús xubꞌij che: Ri tzꞌibꞌatalik kubꞌij: Man kakoj ta kꞌaꞌmabꞌal pa ubꞌe ri awajaw, ri aDios. ");
INSERT INTO quctt_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Are xtoꞌtaj ri Itzel che utaqchiꞌxik ri Jesús che mak, xel bꞌik rukꞌ, kꞌa te katzalij chi loq jun qꞌijal. ");
INSERT INTO quctt_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Xtzalij kꞌu ri Jesús pa Galilea, nojinaq che ri ukwinem ri Uxlabꞌixel. Aninaq xtzijox rij kumal ri winaq aꞌj chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Amaqꞌel xuya kꞌutuꞌn pa jaljoj taq Sinagoga, konojel kꞌu ri winaq xkiya uqꞌij. ");
INSERT INTO quctt_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Are xopan ri Jesús pa ri tinimit Nazaret, pa ri leꞌaj ri xkꞌiy wi, pa ri qꞌij rech uxlanem. Xok bꞌik pa ri Sinagoga, jetaq ri naqꞌatal che, xtakꞌiꞌ kꞌu chusikꞌixik ri wuj. ");
INSERT INTO quctt_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Xkiya kꞌu che ri wuj ri xutzꞌibꞌaj ri qꞌalajisal utzij ri Dios Isaías. Ri Jesús are xusol ri wuj xuriq ri tzꞌibꞌatal wi we tzij riꞌ: ");
INSERT INTO quctt_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ri Loqꞌalaj Uxlabꞌixel rech ri Dios kꞌo pa nuwiꞌ, rumal cher inuchaꞌom chukꞌamik bꞌik utz laj tzij chike ri e mebꞌa, inutaqom loq chuqꞌalajisaxik ri kitzoqopitajik ri e tzꞌapitalik xuqujeꞌ ri e jatꞌitalik ketzoqopitaj na. Xuqujeꞌ chujaqik ri kibꞌoqꞌoch ri e moyabꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Xuqujeꞌ chutzijoxik chi xopan ri qꞌotaj rech ri utoqꞌobꞌ ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Are xtoꞌtaj chusikꞌixik ri wuj, xubꞌot chi kanoq, xutzalij che ri tobꞌanel, kꞌa te riꞌ xtꞌuyiꞌk. Konojel winaq ri e kꞌo pa ri Sinagoga ko xkikaꞌyej. ");
INSERT INTO quctt_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Xuchapleꞌj kꞌu tzijonem ri Jesús kukꞌ, xubꞌij: Kamik xkꞌulmataj we tzꞌibꞌatalik riꞌ chiꞌwach. ");
INSERT INTO quctt_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Konojel ri winaq utz kakibꞌan chutzijoxik ri Jesús, xuqujeꞌ sibꞌalaj kemayijan che ri mayijabꞌal taq tzij ri kubꞌij. Kakitatabꞌela chibꞌil kibꞌ: ¿La man are waꞌ ri ukꞌojol ri José? ");
INSERT INTO quctt_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Xubꞌij kꞌu ri Jesús chike: Kibꞌij wa chwe ri jun kꞌambꞌejabꞌal noꞌj: “Ajkun, chakunaj awibꞌ.” Chabꞌana ri mayijabꞌal taq jastaq waral jacha pa ri xabꞌan pa ri tinimit Capernaúm. ");
INSERT INTO quctt_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Xuqujeꞌ xubꞌij chike: Qas tzij kinbꞌij chiꞌwe chi man nim ta kilik jun qꞌalajisanel pa ri utinimit. ");
INSERT INTO quctt_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kinbꞌij kꞌu chiꞌwe chi e kꞌi malkaꞌnibꞌ riꞌ xekꞌojiꞌ pa ri tinimit Israel pa taq ri uqꞌij ri qꞌalajisal rech ri utzij ri Dios Elías, che riꞌ are man xubꞌan ta jabꞌ. Oxibꞌ junabꞌ rukꞌ nikꞌaj, xkꞌojiꞌ kꞌu nimalaj wiꞌjal pa ronojel ri uwachulew pa taq ri qꞌij riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Man xtaq ta kꞌu bꞌik ri Elías kukꞌ ri malkaꞌnibꞌ ri e kꞌo pa ri tinimit xane rukꞌ ri jun malkaꞌn ri kape pa ri tinimit Sarepta rech Sidón. ");
INSERT INTO quctt_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Pa taq ri uqꞌij ri qꞌalajisal tzij rech ri Dios Eliseo, e kꞌo xuqujeꞌ sibꞌalaj e kꞌi chꞌaꞌkibꞌ pa ri tinimit Israel, xa kꞌu jun xkunatajik xwi ri Naamán, ri kel pa ri tinimit Siria. ");
INSERT INTO quctt_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Are xkita ri winaq ri e kꞌo pa ri Sinagoga ri xubꞌij chike, xechꞌuꞌjarik. ");
INSERT INTO quctt_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Xewaꞌjil chirij, xkikꞌam bꞌik rukꞌ chuqꞌabꞌ chutzaꞌm ri juyubꞌ ri yakom wi ri kitinimit, are xkaj xkikꞌyaq bꞌik pa ri siwan. ");
INSERT INTO quctt_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ri Jesús kꞌut xikꞌow chikixoꞌl ri winaq, xtzalij pa ri bꞌe. ");
INSERT INTO quctt_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Xqaj bꞌik ri Jesús, xeꞌ pa Capernaúm rech Galilea. Xuꞌtijoj ri winaq pa ri Sinagoga, pa ri qꞌij rech uxlanem. ");
INSERT INTO quctt_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Xemayijanik ri winaq rumal ri ukꞌutuꞌn, xuqꞌalajisaj chi yaꞌtal uchuqꞌabꞌ rumal ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ri Jesús are kꞌo pa ri Sinagoga, kꞌo jun achi ri kꞌo jun itzel uxlabꞌal che, xuchapleꞌj uraqik uchiꞌ che ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Xubꞌij: Jesús aj Nazaret, wetaꞌm chi lal, lal Tyoxalaj winaq rech ri Dios. ¿Jas che xpe la che qatukixik? ");
INSERT INTO quctt_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ri Jesús xubꞌij che: Chatuxlanoq, xuqujeꞌ chatel bꞌik che we achi riꞌ. Che ri qꞌotaj riꞌ, ri itzel uxlabꞌal xutzaq ri achi pa ri ulew. Xel kꞌu bꞌik ri itzel uxlabꞌal man xubꞌan ta chi kꞌax che ri achi. ");
INSERT INTO quctt_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Konojel xemayijanik, kakitatabꞌela chibꞌil taq kibꞌ: ¿Jas kwinem kukoj we achi riꞌ cher kakwinik keꞌresaj bꞌik ri itzel taq uxlabꞌal, rukꞌ ri utaqanik kaꞌnimaj bꞌik ri itzel taq uxlabꞌal? ");
INSERT INTO quctt_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Xtzijox kꞌu rij ri Jesús pa ronojel kꞌolibꞌal rech ri tinimit. ");
INSERT INTO quctt_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Xel kꞌu loq ri Jesús pa ri Sinagoga, xeꞌ cho rachoch ri Simón. Chilaꞌ kꞌo wi ri ujiꞌ chuchuꞌ ri Simón kꞌo qꞌaqꞌ che. Xkita kꞌu jun toqꞌobꞌ che ri Jesús rech kukunaj kanoq. ");
INSERT INTO quctt_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ri Jesús xqet chuxukut ri usok ri ujiꞌ ri Pedro, xresaj bꞌik ri yabꞌil che ri ixoq. Ri ixoq aninaq xwaꞌjilik, xuꞌpatanij. ");
INSERT INTO quctt_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Are xsaqirik, ri e winaq rech taq ri leꞌaj xeꞌkikꞌam bꞌik ri e kachalal ri e yawabꞌibꞌ rech kekunax kan rumal ri Jesús. Xapakux kꞌu ne ri yabꞌil ri kꞌo chike, xuꞌtzirik are xechap rumal ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","E kꞌi e kꞌo itzel taq uxlabꞌal chike, kakiraqaqej kichiꞌ, kakibꞌij: “At at ralkꞌwaꞌl ri Dios.” Rumal ketaꞌm chi are Mesías, ri Jesús man xuya ta bꞌe chike xechꞌawik, xeꞌresaj bꞌik konojel. ");
INSERT INTO quctt_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Sibꞌalaj aqꞌabꞌ che ri jun qꞌij chik, ri Jesús xeꞌ pa jun kꞌolibꞌal jawjeꞌ ri e maj wi winaq. E kꞌi winaq kꞌut xkitzukuj, kꞌamaꞌtam xkiriqo, are xkiriqo, xkita toqꞌobꞌ che chi kakanaj kan kukꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ri Jesús xubꞌij chike: Rajawaxik kintzijoj ri utz laj tzij rech ri ajawarem rech ri Dios, pa nikꞌaj taq tinimit chik rumal cher are nupatan waꞌ in petinaq. ");
INSERT INTO quctt_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Xaq jeriꞌ are xrilij utzijoxik ri utz laj tzij pa taq ri Sinagoga ke ri winaq aꞌj Israel. ");
INSERT INTO quctt_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jun qꞌijal ri Jesús tajin kutzijoj ri utzij ri Dios chuchiꞌ ri plo Genesaret, ");
INSERT INTO quctt_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","xeꞌril kꞌu kebꞌ jukubꞌ bꞌinibꞌal puꞌwiꞌ jaꞌ ri e kꞌo chuchiꞌ ri plo. Eꞌlinaq loq ri e chapal taq kar ri e kꞌo chupam tajin kakichꞌaj ri e kikꞌat. ");
INSERT INTO quctt_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ri Jesús xaqꞌan pa ri jukubꞌ bꞌinibꞌal puꞌwiꞌ jaꞌ, xuta toqꞌobꞌ che ri Simón Pedro ajchoqꞌe ri jukubꞌ chi kupaqchiꞌj bꞌik ri jukubꞌ pa ri jaꞌ. Kꞌa te riꞌ xtꞌuyiꞌ pa ri jukubꞌ, xuchapleꞌj uyaꞌik kꞌutuꞌn chike e kꞌi winaq. ");
INSERT INTO quctt_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Are xtoꞌtaj che chꞌawem, xubꞌij che ri Simón: Jat jawjeꞌ nim qajinaq wi le jaꞌ, chakꞌyaqa le akꞌat chilaꞌ rech kaꞌchap ri kar. ");
INSERT INTO quctt_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ri Simón, xubꞌij: Ajtij, ronojel jun aqꞌabꞌ xujchakunik, xa ta ne jun kar xqachapo. We kꞌu jeriꞌ kabꞌij la, kaqakꞌyaq le kꞌat junmul chik. ");
INSERT INTO quctt_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Are jewaꞌ xkibꞌano, xenoj ri kar pa ri kꞌat, ri kꞌat xkichapleꞌj tꞌoqopinik. ");
INSERT INTO quctt_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ri Simón rachiꞌl ri toꞌl taq rech xeꞌkisikꞌij ri kachiꞌl ri e kꞌo pa ri jun jukubꞌ chik, rech ketoꞌ kumal. Xkinojisaj kꞌu kebꞌ jukubꞌ che kar, raj kꞌu keqaj ri jukubꞌ chuxeꞌ ri jaꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Are xril ri Simón Pedro ri xbꞌantajik, xukulik, xqaj cho ri Jesús, xubꞌij che: Ajawxel Jesús, cheꞌl la wukꞌ, man taqal ta chwe kinkꞌojiꞌ ukꞌ la, sibꞌalaj in ajmak. ");
INSERT INTO quctt_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Jewaꞌ xubꞌij rumal sibꞌalaj xmayijanik che ri kikꞌiyal ri kar ri xeꞌkichapo, ri rachiꞌl xuqujeꞌ xemayijan rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ri e rachiꞌl ri Simón, ri Jacobo, ri Juan, uꞌkꞌojol ri Zebedeo, xemayijan xuqujeꞌ. Ri Jesús xubꞌij che ri Simón: Man kaxiꞌj ta awibꞌ jetaq ri xabꞌan chkichapik kar, je kabꞌan na chkikꞌamik la winaq wukꞌ in. ");
INSERT INTO quctt_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Are xetzalij pa ri chaqiꞌj ulew, xkiya kan ronojel ri kijastaq, xkitereneꞌj ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ri Jesús are xopan pa ri jun leꞌaj xuriq jun achi nojinaq che chꞌaꞌk. Ri achi are xrilbꞌej rech ri Jesús, xukiꞌk, xuya ri upalaj pa ri ulew, xuta toqꞌobꞌ che kakunaxik jewaꞌ xubꞌij: Wajaw, we kaj la, chinkunaj la xuqujeꞌ chinchꞌojchꞌobꞌej la. ");
INSERT INTO quctt_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ri Jesús xuyuq ri uqꞌabꞌ, xuchapo, kꞌa te ri xubꞌij che: Kawaj, chatutziroq. Aninaq xsach ri chꞌaꞌk ri kꞌo che ri achi. ");
INSERT INTO quctt_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ri Jesús xubꞌij che chi maj jachin che kutzijoj wi ri xkꞌulmatajik, xubꞌij xuqujeꞌ che: Jat jakꞌutu awibꞌ cho ri chꞌawenel cho ri Dios pa kiwiꞌ ri winaq rech katrilo. Chakꞌama bꞌik ri sipanik ri kakitzuj ri e winaq ri kuꞌtzir che ri chꞌaꞌk, jetaq ri kubꞌij ri utaqanik ri Moisés. Rukꞌ waꞌ kaqꞌalajisaj chi xatchꞌajchꞌobꞌetajik. ");
INSERT INTO quctt_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pune jeriꞌ, aninaq xtukin ubꞌixik ri xkꞌulmatajik, e kꞌi winaq xoꞌpan chutayik ri Jesús, xuqujeꞌ chukꞌamawaꞌxik kunanik. ");
INSERT INTO quctt_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kꞌi mul xel bꞌik ri Jesús pa ri tinimit, xeꞌ chubꞌanik chꞌawem pa ri leꞌaj ri katzꞌinowik. ");
INSERT INTO quctt_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Jun qꞌijal are tajin kuya kꞌutuꞌn ri Jesús, e tꞌuyutꞌuj ri fariseos xuqujeꞌ ri aꞌjtijabꞌ rech ri taqanik chunaqaj ri Jesús. Are waꞌ ri e petinaq pa taq ri leꞌaj rech Galilea, rech Judea, xuqujeꞌ e kꞌo jujun ri kepe pa ri tinimit Jerusalén. Ri ukwinem ri Ajawxel kꞌo rukꞌ ri Jesús chikiꞌkunaxik ri winaq. ");
INSERT INTO quctt_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Xoꞌpan kꞌu nikꞌaj achyabꞌ kukꞌam loq jun achi qꞌoyol cho jun chꞌat, man kakwin taj kusalabꞌaj ribꞌ, xkitzukuj kꞌut jas xkibꞌan che rokisaxik bꞌik cho ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Man kekwin ta kꞌut koꞌk bꞌik pa ri ja rumal cher sibꞌalaj e kꞌi ri winaq, xaq jeriꞌ xkesaj nikꞌaj xot puꞌwiꞌ ri ja, xkiqasaj bꞌik ri achi cho ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Are xril ri Jesús ri kikojobꞌal, xubꞌij che ri achi: Ala, ri amak xekuyutajik. ");
INSERT INTO quctt_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ri fariseos xuqujeꞌ ri aꞌjtijabꞌ rech ri taqanik xkibꞌij: ¿Jachin jun jeꞌ kunaꞌ we achi riꞌ? Xaq kubꞌij awas taq tzij che ri Dios. Xaq xwi ri Dios kakwinik kukuy makaj. ");
INSERT INTO quctt_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ri Jesús xril ri xkichomaj ri achyabꞌ pa kanimaꞌ. Xuta chike: ¿Jas che jewaꞌ kixchoman pa taq iwanimaꞌ? ");
INSERT INTO quctt_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Jachin man kꞌax ta ubꞌixik: “Xkuyutaj ri amak” o “Chatwaꞌjiloq, chatbꞌinoq”? ");
INSERT INTO quctt_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Rech kꞌu kiwilo chi ri uKꞌojol ri Achi kꞌo ukwinem kukuy makaj cho ri uwachulew. Ri Jesús xukaꞌyej ri achi ri man kakwin taj kusalabꞌaj ribꞌ, xubꞌij che: Chatwaꞌjiloq, chakꞌama bꞌik ri achꞌat, jat cho awachoch. ");
INSERT INTO quctt_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ri achi aninaq xwaꞌjilik chikiwach konojel ri winaq, xukꞌam bꞌik ri uchꞌat, xeꞌ cho rachoch kuqꞌijilaꞌj ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Konojel ri winaq sibꞌalaj xemayijanik che ri xkilo, xkiqꞌijilaꞌj ri Dios, xkibꞌij: Mayijabꞌal taq jastaq ri xqil kamik. ");
INSERT INTO quctt_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Are xel bꞌik ri Jesús pa ri tinimit, xril jun toqꞌil alkabal ubꞌiꞌ Leví, tꞌuyul pa ri ja ri katoqꞌix wi alkabal, xubꞌij che: Chinatereneꞌj. ");
INSERT INTO quctt_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Xwaꞌjil kꞌu ri Leví, xuya kan ronojel ri ujastaq, xutereneꞌj ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ri Leví xubꞌan jun nimaqꞌij cho ri rachoch. Xuꞌsikꞌij ri Jesús, e nikꞌaj winaq chik, xuqujeꞌ ri e rachiꞌl toqꞌil taq alkabal. ");
INSERT INTO quctt_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ri aꞌjtijabꞌ rech ri taqanik xuqujeꞌ ri fariseos xkichꞌaꞌ chike ri e tijoxelabꞌ, xkibꞌij: ¿Jas che kixwaꞌ kukꞌ ri aꞌjmakibꞌ xuqujeꞌ ri toqꞌil taq alkabal? ");
INSERT INTO quctt_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ri Jesús xubꞌij chike: Man kajawataj ta ajkun chike ri winaq ri utz kiwach, xane are kajawataj ajkun chike ri e yawabꞌibꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Man in petinaq ta kꞌu che kisikꞌixik ri winaq ri kakinaꞌo chi e sukꞌ xane are keꞌntzukuj ri aꞌjmakibꞌ ri ketaꞌm chi kꞌo kimak. ");
INSERT INTO quctt_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jun qꞌijal nikꞌaj winaq xkibꞌij che ri Jesús: Ri utijoxelabꞌ ri Juan Bꞌanal qasanaꞌ amaqꞌel kakiqꞌip kibꞌ che waꞌim, je xuqujeꞌ ri kitijoxelabꞌ ri fariseos ¿jas kꞌu che amaqꞌel kewaꞌ ri atijoxelabꞌ xuqujeꞌ kequmunik? ");
INSERT INTO quctt_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ri Jesús xutzalij uwach ri kitzij, xubꞌij: ¿La kumaj kꞌut kakiqꞌip kiwaꞌim re rajtobꞌom jun jiꞌatz? Man kumaj taj. ");
INSERT INTO quctt_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kopan kꞌu na jun qꞌij are kesax bꞌik ri jiꞌatz chikixoꞌl, kꞌa te riꞌ riꞌ kakiqꞌip na kiwaꞌim che taq ri qꞌij riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Kꞌa te riꞌ xuya jun kꞌambꞌejabꞌal noꞌj xubꞌij: Man kꞌo ta jun winaq kukꞌojoj jun qꞌeꞌl atzꞌyaq rukꞌ jun chꞌaqaꞌp kꞌakꞌ atzꞌyaq, rumal kateqꞌetobꞌ riꞌ ri kꞌakꞌ atzꞌyaq, xuqujeꞌ ri chꞌaqaꞌp kꞌakꞌ atzꞌyaq man kukꞌulaj ta ribꞌ rukꞌ ri qꞌeꞌl. ");
INSERT INTO quctt_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Man kꞌo ta xuqujeꞌ jun winaq ri kuya kꞌakꞌ vino pa qꞌeꞌl taq tzꞌuꞌm taq qꞌebꞌal, rumal chi ri kꞌakꞌ vino xaq katix bꞌik riꞌ, xuqujeꞌ ri tzꞌuꞌm taq qꞌebꞌal ketꞌoqopin riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ri kꞌakꞌ vino yaꞌtalik kayak pa taq kꞌakꞌ taq tzꞌuꞌm taq qꞌebꞌal. ");
INSERT INTO quctt_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Man kꞌo ta xuqujeꞌ jun winaq karaj kutij rech ri kꞌakꞌ vino, we utijom kan rech ri ojer vino. Jeriꞌ rumal cher ri winaq ri kutij nabꞌe ri kꞌakꞌ vino kꞌa te riꞌ kutij ri ojer vino, kubꞌij na: “Are sibꞌalaj utz ri ojer vino.” ");
INSERT INTO quctt_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Pa jun qꞌij rech Uxlanem are tajin kabꞌin ri Jesús pa nikꞌaj ulew ri tikom, ri utijoxelabꞌ xkichapleꞌj uchꞌupik ri ujolom ri tiriko, xkichꞌolo xuqujeꞌ xkichapleꞌj utijik. ");
INSERT INTO quctt_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","E kꞌo nikꞌaj fariseos xkibꞌij che ri Jesús: ¿Jas che ri atijoxelabꞌ kakibꞌan ri man yaꞌtal ta ubꞌanik pa ri qꞌij rech uxlanem? ");
INSERT INTO quctt_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ri Jesús xutzalij uwach ri kitzij, xubꞌij: ¿La man lo isikꞌim ri tzꞌibꞌatalik, kubꞌij jas xkꞌulmataj rukꞌ ri David xuqujeꞌ ri e rachiꞌl are xenumik? ");
INSERT INTO quctt_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Xok bꞌik pa ri rachoch ri Dios, xuqꞌipij ri taqanik are xutij ri tyoxalaj kaxlan wa xuqujeꞌ xuya ke ri rachiꞌl, we kaxlan wa ri xkitijo xwi taqal chike kakitijo ri e chꞌawenelabꞌ cho ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Xuqujeꞌ xubꞌij ri Jesús: ri uKꞌojol ri Achi are ajchoqꞌe ri qꞌij rech uxlanem. ");
INSERT INTO quctt_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pa jun qꞌij rech uxlanem, are tajin kuya kꞌutuꞌn ri Jesús pa ri Sinagoga, kꞌo kꞌu jun achi, kaminaq ri wiqiqꞌabꞌ uqꞌabꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ri aꞌjtijabꞌ rech ri taqanik xuqujeꞌ ri fariseos xkikꞌakꞌaleꞌj ri Jesús, ri kichomanik are chi we ri Jesús kukunaj ri achi pa ri qꞌij rech uxlanem, kakimol umak rumal cher kachakun pa ri qꞌij rech uxlanem. ");
INSERT INTO quctt_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Retaꞌm kꞌu ri Jesús ri kichomanik, xubꞌij che ri achi: Chatan loq, chattakꞌal chikiwach konojel. Ri achi kꞌut xtakꞌiꞌk chikiwach konojel ri winaq. ");
INSERT INTO quctt_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Xubꞌij ri Jesús chike ri winaq ri kakimol umak: Kꞌo jun kꞌotbꞌal chiꞌ kawaj kinbꞌan chiꞌwe: ¿Jas ri utz kaqabꞌan pa ri qꞌij rech uxlanem, la are utz kabꞌan ri utzilal o are utz kabꞌan ri etzelal? ¿La are utz kakol jun kꞌaslemal o kakꞌis puꞌwiꞌ jun kꞌaslemal? ");
INSERT INTO quctt_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ri Jesús xuꞌkaꞌyej pa kijujunal konojel ri winaq ri e chemel chirij, kꞌa te riꞌ xubꞌij che ri achi: Chayuqu le aqꞌabꞌ. Are xuquq ri uqꞌabꞌ, xutzirik. ");
INSERT INTO quctt_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ri fariseos xuqujeꞌ ri aꞌjtijabꞌ rech ri taqanik sibꞌalaj xejiqꞌ che koyawal are xkil ri xkꞌulmatajik, xkichapleꞌj kꞌu uchomaxik jas kakibꞌan che ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Jubꞌiqꞌ qꞌotaj ikꞌowinaq we jastaq riꞌ, xpaqiꞌ ri Jesús puꞌwiꞌ jun juyubꞌ chubꞌanik chꞌawem. Jun aqꞌabꞌ xubꞌan chꞌawem cho ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Are xsaqirik, xuꞌsikꞌij konojel ri utijoxelabꞌ, xuchaꞌ kabꞌlajuj chike, xuya bꞌe chike kux e tereneꞌl taq re. Are waꞌ ri kibꞌiꞌ: ");
INSERT INTO quctt_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ri Simón ri xubꞌij Pedro che, ri Andrés uchaqꞌ ri Pedro, ri Jacobo, ri Juan, ri Felipe, ri Bartolomé, ");
INSERT INTO quctt_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ri Mateo xuqujeꞌ ri Tomás, ri Jacobo ukꞌojol ri Alfeo, ri Simón ri kabꞌix “Zelote” che, ");
INSERT INTO quctt_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ri Judas ri uchaqꞌ ri Jacobo, xuqujeꞌ ri Judas Iscariote ri xkꞌayin ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Are xeqaj loq kipetik puꞌwiꞌ ri juyubꞌ, xekanaj cho jun nimalaj saq, sibꞌalaj kꞌi winaq e teren chirij ri Jesús, jaljoj taq kepe wi, e kꞌo aꞌj Judea, aꞌj Jerusalén, xuqujeꞌ aꞌj Tiro xuqujeꞌ Sidón. ");
INSERT INTO quctt_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","We winaq riꞌ xoꞌpan chutatabꞌexik ri Jesús rech kekunataj che ri yabꞌilal, xuqujeꞌ rech keꞌl bꞌik ri itzel taq uxlabꞌal ri kꞌo chike, jeriꞌ xekunatajik. ");
INSERT INTO quctt_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Konojel ri winaq kakaj kakichap ri Jesús, rumal cher sibꞌalaj kꞌo ukwinem kakunanik. ");
INSERT INTO quctt_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Xubꞌij ri Jesús chike ri utijoxelabꞌ: Utz iwe ri ix mebꞌa rumal cher iwech ri ajawarem rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Utz iwe ri kixnum kamik rumal cher kayaꞌtaj na iwa rech kakubꞌiꞌ ikꞌuꞌx. Utz iwe ri kixoqꞌ kamik, rumal cher kixtzeꞌtzet na. ");
INSERT INTO quctt_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Utz iwe are kixetzelaxik, are kabꞌan nitzꞌ chiꞌwe, are kabꞌix kꞌax taq tzij chiꞌwe, xuqujeꞌ man kaya ta iqꞌij, xa rumal cher ixkojoninaq che ri uKꞌojol ri Achi. ");
INSERT INTO quctt_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Sibꞌalaj chixkiꞌkotoq are kakꞌulmataj we riꞌ iwukꞌ. Chixchꞌoplajoq rumal cher ixrayeꞌm jun nimalaj tojbꞌal iwe pa ri kaj. Naꞌtaj chiꞌwe chi jeriꞌ xkibꞌan ri kitat kinan we winaq riꞌ chike ri e qꞌalajisal taq utzij ri Dios ojer. ");
INSERT INTO quctt_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Kꞌax iwe ix qꞌinom taq winaq, rumal cher ri ikiꞌkotemal xaq xwi chanim xuqujeꞌ xaq xwi cho ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Nimalaj kꞌaxkꞌolal iwayeꞌm ri kixnoꞌjitajik, xuqujeꞌ ixchomaꞌq. Rumal cher kape na jun nimalaj wiꞌjal pa iwiꞌ. Nimalaj kꞌaxkꞌolal iwayeꞌm ix ri kixtzeꞌn kamik rumal cher ri itzeꞌ kakꞌexetaj na pa oqꞌej xuqujeꞌ pa kꞌax. ");
INSERT INTO quctt_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Nimalaj kꞌax iwayeꞌm ix ri sibꞌalaj nim kixkil ri winaq kamik, jeriꞌ rumal cher jeriꞌ xkibꞌan ri itat inan ojer, nim xeꞌkil ri xkijaluj chi e tzijol taq rech ri utzij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ri ix ri kitatabꞌej we nutzij, kinbꞌij chiꞌwe: Chiꞌloqꞌaj ri iꞌkꞌulel, chibꞌana utzilal chike ri kakibꞌan koyawal chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Chiꞌtewechiꞌj ri kaketzelaj iwach, chibꞌana chꞌawem pa kiwiꞌ ri kakibꞌan kꞌax chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","We kꞌo jun katchꞌayow che ri juperaj apalaj, chaya chi ri juperaj. We kꞌo jun kumaj ri achakeꞌt, chaya xuqujeꞌ kan ri akamiꞌx che. ");
INSERT INTO quctt_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Chaya che ri ajil tzꞌaqat ri jastaq ri kuta chawe. We kumaj jun jastaq awe, man kakoj ta achuqꞌabꞌ che utoqꞌixik che. ");
INSERT INTO quctt_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Je chatnoꞌjin kukꞌ ri winaq jacha ri kawaj at kenoꞌjin awukꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","We xaq xwi kiꞌloqꞌaj ri winaq ri kixloqꞌan ix, ¿jas rumal kinimarisaj iwibꞌ? Ri e winaq aꞌjmakibꞌ xuqujeꞌ keꞌkiloqꞌaj ri e winaq ri keloqꞌan aꞌreꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","We xaq xwi kibꞌan utzil chike ri winaq ri kebꞌanow utzil chiꞌwe, ¿jas rumal kinimarisaj iwibꞌ? Je xuqujeꞌ waꞌ kakibꞌan ri aꞌjmakibꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","We xwi kiya pwaq pa qajik chike ri winaq ri kekwin chutzalixik ukꞌaxel, ¿jas rumal kinimarisaj iwibꞌ? Je xuqujeꞌ waꞌ kakibꞌan ri aꞌjmakibꞌ, kakiya pwaq pa qajik, rumal kakayeꞌj nim tojbꞌal kakichꞌek chirij. ");
INSERT INTO quctt_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Chiꞌloqꞌaj ri iꞌkꞌulel, chibꞌana utzil chike, chiya kiqajanik man kiwayeꞌj ta ukꞌaxelal, we jewaꞌ kibꞌano kikꞌamawaꞌj na nim ukꞌaxelal rech chilaꞌ chikaj, xuqujeꞌ chikꞌutuꞌ chi qas ix ralkꞌwaꞌl ri nimalaj Dios, ri Dios sibꞌalaj utz kukꞌ ri man ketyoxin taj xuqujeꞌ kukꞌ ri itzel taq winaq. ");
INSERT INTO quctt_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Chitoqꞌobꞌisaj kiwach ri winaq jetaq ri iTat chilaꞌ chikaj sibꞌalaj kutoqꞌobꞌisaj kiwach ri winaq. ");
INSERT INTO quctt_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Man kiqꞌat ta tzij pa kiwiꞌ nikꞌaj winaq chik, rech man kaqꞌat ta tzij pa iwiꞌ ix rumal ri Dios. Man kikꞌis ta tzij pa kiwiꞌ ri winaq rech man kakꞌis ta tzij pa iwiꞌ ix rumal ri Dios. Chikuyu kimak nikꞌaj winaq chik, rech kakuyutaj imak ix. ");
INSERT INTO quctt_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Chiyaꞌ rech kayaꞌtaj na chiꞌwe, katzalitaj na ukꞌaxel ri kiyaꞌo nojinaq, mesmetinaq, maj chi kakꞌojiꞌ wi pa ri ikꞌolibꞌal, rumal cher jetaq ri kibꞌan ix chuyaꞌik je kabꞌan na chuyaꞌik chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kꞌa te riꞌ ri Jesús xukoj jun kꞌambꞌejabꞌal noꞌj, xubꞌij: ¿La kakwin jun moy kukꞌam ubꞌe jun moy chik? ¿La man kikobꞌchal ri ketzaq bꞌik pa jun jul? ");
INSERT INTO quctt_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Man are ta nim uqꞌij jun tijoxel cho ri rajtij. We kꞌu karetaꞌmaj ronojel ri jastaq kux na jetaq ri rajtij. ");
INSERT INTO quctt_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Jas kꞌu che kꞌax kanaꞌ che ri awachalal are kꞌo jun nitzꞌ mes pa ubꞌoqꞌoch are kꞌu ri at kꞌo jun kutaꞌm pa ri awe? ");
INSERT INTO quctt_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Jas kꞌu che kabꞌij: “Wachalal, chaya bꞌe chwe kinwesaj ri nitzꞌ mes ri kꞌo pa ri abꞌoqꞌoch”? Katkwin ta kꞌut kawil jun jastaq chik, xwi ya kawil ri kutaꞌm ri kꞌo pa ri abꞌoqꞌoch at. ¡Kawach! Nabꞌe chawesaj ri kutaꞌm ri kꞌo pa ri abꞌoqꞌoch, rech katkwinik kawilo jas kabꞌan chi resaxik ri nitzꞌ mes ri kꞌo pa ubꞌoqꞌoch ri awachalal. ");
INSERT INTO quctt_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Man kꞌo ta jun utza cheꞌ itzel taq uwach kuyaꞌo xuqujeꞌ man kꞌo ta jun itzel cheꞌ utz taq uwach kuyaꞌo. ");
INSERT INTO quctt_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Jun cheꞌ etaꞌmatal uwach rumal ri uwach kuyaꞌo. Ri kꞌix man kuwachij ta higos, xuqujeꞌ ri ucheꞌal ri tukan man kuwachij ta uvas. ");
INSERT INTO quctt_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Jun utz laj winaq are kutzijoj ri utz laj jastaq ri kꞌo pa ranimaꞌ. Jun itzel winaq are kutzijoj ri itzel taq jastaq ri kꞌo pa ranimaꞌ. Ronojel ri kubꞌij jun winaq are riꞌ ri yakal pa ranimaꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Jas che kibꞌij chwe “Ajawxel, Ajawxel”, kꞌa te riꞌ man kinimaj ta ri kinbꞌij? ");
INSERT INTO quctt_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Chanim kinbꞌij chiꞌwe jachin rukꞌ kajunumataj wi ri winaq ri kape wukꞌ, kuta ri nutzij, xuqujeꞌ kuchakubꞌej ri kinbꞌij. ");
INSERT INTO quctt_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","We winaq riꞌ kajunumataj rukꞌ ri achi ri xuyak jun rachoch. Xukꞌot ri ulew, naj xuqasaj kꞌa xuꞌriqa na ri abꞌaj, kꞌa te riꞌ xubꞌan kan ri utakꞌalibꞌal ri ja. Are xpe jun nimalaj nimaꞌ, xuꞌpuyij ribꞌ cho ri ja, xa ta ne nitzꞌ xkwin chusalabꞌaxik rumal cher sibꞌalaj utz xbꞌan che uyakik. ");
INSERT INTO quctt_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ri winaq kꞌut ri kutatabꞌej ri nutzij, kꞌa te riꞌ man kuchakubꞌej taj ri kinbꞌij, kinjunamaj rukꞌ ri achi ri xuyak rachoch pa ri ulew. Maj utakꞌalibꞌal xubꞌano. Are xpe ri nimaꞌ, xupuyij ribꞌ cho ri ja, xtukin ri ja, sibꞌalaj man utz ta ri xkꞌulmatajik. ");
INSERT INTO quctt_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Are xtoꞌtaj ri Jesús che tzijonem kukꞌ ri winaq, xeꞌ pa ri tinimit Capernaúm. ");
INSERT INTO quctt_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Chilaꞌ kel wi jun kinimaꞌqil ri ajchꞌoꞌjabꞌ chajil tinimit rech Roma. Xyawaj kꞌu jun patanil we achi riꞌ ri sibꞌalaj uloqꞌ, jubꞌiqꞌ karaj kakamik. ");
INSERT INTO quctt_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ri kinimaꞌqil ri ajchꞌoꞌjabꞌ chajil tinimit are xuto chi katzijox ri Jesús, xuꞌtaq bꞌik e kꞌamal taq bꞌe ke ri winaq aꞌj Israel rech keꞌkisikꞌij la ri Jesús jeriꞌ kulukunaj kan ri patanil rech. ");
INSERT INTO quctt_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Are xoꞌpan rukꞌ ri Jesús, xkibꞌochiꞌj, xkibꞌij che: We achi riꞌ, taqal che chi kaya la ri kuta che la, ");
INSERT INTO quctt_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","rumal cher xuyak jun qaSinagoga rumal cher kuloqꞌaj ri qatinimit. ");
INSERT INTO quctt_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ri Jesús xeꞌ kukꞌ, are xnaqajin che ri ja ri kꞌo wi ri yawabꞌ, ri kinimaꞌqil ri ajchꞌoꞌjabꞌ chajil tinimit xuꞌtaq bꞌik e rech chꞌabꞌeꞌn, xeꞌkibꞌij che ri Jesús: Ajawxel, xaq maqꞌitajisaj ibꞌ la, man taqal ta chwe kok la pa ri wachoch. ");
INSERT INTO quctt_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Rumal riꞌ man xinkꞌut ta nupalaj choch la, bꞌij jun tzij la rukꞌ riꞌ kakunataj ri patanil we. ");
INSERT INTO quctt_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","In xuqujeꞌ kinnimaj kitzij ri nimaꞌq kiqꞌij chinuwach, xuqujeꞌ kꞌo ajchꞌoꞌjabꞌ chajil tinimit chuxeꞌ raqan nuqꞌabꞌ. We kinbꞌij che jun: “¡Jat!” kincha che, keꞌek. We kinbꞌij xuqujeꞌ che jun chik: “Chatan loq,” kincha che, kapetik. We kinbꞌij che ri patanil we: “¡Chabꞌana we riꞌ!” kincha che, jaꞌe kachaꞌ kubꞌano. ");
INSERT INTO quctt_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Are xuta ri Jesús we riꞌ, sibꞌalaj xmayijanik, xtzalqꞌomijik, xubꞌij chike ri winaq ri e teren chrij: Kinbꞌij chiꞌwe, man nuriqom ta we nimalaj kojobꞌal riꞌ xa ta ne chikixoꞌl ri winaq aꞌj Israel. ");
INSERT INTO quctt_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Are xoꞌpan ri e taqoꞌn cho rachoch ri kinimaꞌqil ri ajchꞌoꞌjabꞌ chajil tinimit, utzirinaq chi ri patanijel. ");
INSERT INTO quctt_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Te kꞌu riꞌ xeꞌ ri Jesús pa ri tinimit Naín e rachiꞌl ri utijoxelabꞌ xuqujeꞌ e teren sibꞌalaj e kꞌi winaq chirij. ");
INSERT INTO quctt_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Are xqeteqobꞌ bꞌik chuchiꞌ ri uchiꞌ ja rech ri tinimit, xrilo chi tajin kesax loq jun kaminaq, ral jun malkaꞌn ixoq ri ixoq, xa jun ral kꞌolik. Sibꞌalaj kꞌi winaq e teren chikij. ");
INSERT INTO quctt_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Are xril ri Jesús chi tajin koqꞌ ri ixoq, xel ukꞌuꞌx che, xubꞌij: Man katoqꞌ taj. ");
INSERT INTO quctt_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Xqebꞌ rukꞌ ri kaxa, xuchapo. Ri ukꞌaꞌl taq re ri kaxa xetakꞌiꞌk, ri Jesús xubꞌij: Ala, kinbꞌij chawe, ¡chatwaꞌjiloq! ");
INSERT INTO quctt_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ri ala ri kaminaq xkꞌastajik, xuchapleꞌj chꞌawem. Ri Jesús xuya kan ri ala che ri unan. ");
INSERT INTO quctt_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Sibꞌalaj xkixiꞌj kibꞌ konojel ri winaq xuqujeꞌ xkiqꞌijilaꞌj ri Dios, xkibꞌij: Ri Dios xpe chutoꞌik ri utinimit, kꞌo jun qꞌalajisal rech ri utzij ri Dios chiqaxoꞌl. ");
INSERT INTO quctt_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Xtukin kꞌu ubꞌixik ri xubꞌan ri Jesús pa ri tinimit Judea xuqujeꞌ pa taq ri tinimit ri kꞌo chikinaqaj. ");
INSERT INTO quctt_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ri utijoxelabꞌ ri Juan xkitzijoj che ri Juan ri xkꞌulmatajik, ri Juan xuꞌsikꞌij kebꞌ chike ri utijoxelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Xuꞌtaq bꞌik rukꞌ ri Jesús rech xeꞌkita che: ¿La lal riꞌ ri kape la o kaqayeꞌj na jun chik? ");
INSERT INTO quctt_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Are xoꞌpan rukꞌ ri Jesús, xkibꞌij: Ri Juan Bꞌanal qasanaꞌ, xujutaq loq chutayik che la: “¿La lal riꞌ ri Cristo ri qayeꞌm, o kaqayeꞌj chi na jun chik?” ");
INSERT INTO quctt_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ri Jesús qas che riꞌ ri qꞌotaj riꞌ, xuꞌkunaj e kꞌi yawabꞌibꞌ, ri kꞌax keriqitajik, xuqujeꞌ ri kꞌo itzel taq uxlabꞌal chike, je xuqujeꞌ e kꞌi moyabꞌ xuya kikaꞌyebꞌal. ");
INSERT INTO quctt_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kꞌa te riꞌ xubꞌij chike ri uꞌtaqoꞌn ri Juan: Jix, jiꞌtzijoj che ri Juan ri iwilom xuqujeꞌ itom: ri e moyabꞌ kekaꞌyik, ri e chꞌokeꞌr kebꞌinik, kuꞌtzir ri e chꞌaꞌkibꞌ, ri e tꞌoꞌy kakito, ri e kaminaqibꞌ kekꞌastajik, xuqujeꞌ katzijox ri utz laj taq tzij chike ri e mebꞌaibꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Utz rech ri winaq ri man kubꞌan ta kebꞌ ukuꞌx rumal we. ");
INSERT INTO quctt_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Are xebꞌe ri uꞌtaqoꞌn ri Juan, ri Jesús xuchapleꞌj utzijoxik ri Juan chike ri winaq, xubꞌij: ¿Jas xiꞌwila are xixeꞌ pa ri ulew ri katzꞌinowik? ¿La xiꞌwila jun patzꞌan ri kasalabꞌax rumal ri kyaqiqꞌ? ");
INSERT INTO quctt_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","We man jeriꞌ ¿jas kꞌu xiꞌwila? ¿La xiꞌwila jun achi ri ukojom atzꞌyaq paqal rajil? Man je ta riꞌ, rumal cher ri e winaq ri kakikoj atzꞌyaq ri paqal taq rajil e kꞌo riꞌ pa taq ri nimaq taq ja kech ri taqanelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","We man are waꞌ xiꞌkaꞌyej ¿jas kꞌu xiꞌkaꞌyej? ¿La xiꞌwila jun tzijol rech ri utzij ri Dios? Jeꞌ, riꞌ areꞌ kꞌo na choch jun qꞌalajisal rech ri utzij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Are waꞌ ri taqoꞌn, ri ubꞌim loq ri Dios pa ri utzij, are xubꞌij: Kintaq na bꞌik ri nutaqoꞌn kanabꞌej chawach, rech kusukꞌumaj apanoq ri abꞌe. ");
INSERT INTO quctt_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kinbꞌij kꞌu chiꞌwe man kꞌo ta jun chikixoꞌl ri winaq ri sibꞌalaj nim uqꞌij cho ri Juan, pune jeriꞌ, ri kꞌin laj nitzꞌ pa ri ajawarem rech ri Dios, are sibꞌalaj nim uqꞌij cho ri Juan. ");
INSERT INTO quctt_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Are xkita ri winaq xuqujeꞌ ri e toqꞌil taq alkabal ri xbꞌixik, xkichomaj chi sibꞌalaj sukꞌ ri ubꞌe ri Dios, xbꞌan kꞌu kiqasanaꞌ rumal ri Juan. ");
INSERT INTO quctt_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ri fariseos kꞌut xuqujeꞌ ri aꞌjtijabꞌ rech ri taqanik man xkaj taj xbꞌan kiqasanaꞌ rumal ri Juan, xaq jeriꞌ xketzelaj ri urayibꞌal ukꞌuꞌx ri Dios chike. ");
INSERT INTO quctt_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ri Jesús xubꞌij: ¿Jachin rukꞌ keꞌnjunamaj wi we winaq rech we qꞌij junabꞌ riꞌ? ¿Jachin rukꞌ kejunumataj wi? ");
INSERT INTO quctt_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Xaq e junam kukꞌ ri akꞌalabꞌ ri e tꞌuyutꞌuj pa ri kꞌayibꞌal kakibꞌij chibꞌil taq kibꞌ: “Xqoqꞌisaj ri suꞌ, man xixxojow taj, xqabꞌixoj bꞌix rech kamikal man xixoqꞌ taj.” ");
INSERT INTO quctt_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jeriꞌ rumal cher ri Juan are xpetik man xwaꞌ taj xuqujeꞌ man xqumun taj, rumal riꞌ xibꞌij chi kꞌo jun itzel uxlabꞌal che. ");
INSERT INTO quctt_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Xpe kꞌu ri uKꞌojol ri Achi, Areꞌ kawaꞌik xuqujeꞌ kaqumunik, ri ix kꞌut kibꞌij che: “Jun jiqꞌalaj achi, jun qꞌabꞌarel, kech chꞌabꞌeꞌn e toqꞌil taq alkabal xuqujeꞌ aꞌjmakibꞌ.” ");
INSERT INTO quctt_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Are kꞌu ri etaꞌmabꞌal ri rech ri Dios, kaqꞌalajin pa taq kikꞌaslemal ri e tereneꞌl taq rech Areꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Jun chike ri fariseos xusikꞌij ri Jesús che waꞌim cho ri rachoch, ri Jesús are xopanik, xtꞌuyiꞌk chwi ri mexa. ");
INSERT INTO quctt_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kꞌo kꞌu jun ajmak ixoq kel pa ri tinimit, are xuto chi ri Jesús tajin kawaꞌ cho rachoch ri fariseo, xukꞌam bꞌik jun laj ulimeꞌt nojinaq che kꞌokꞌalaj kunabꞌal. ");
INSERT INTO quctt_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Xoqꞌik xukiꞌk chunaqaj ri raqan ri Jesús, xratinisaj ri raqan ri Jesús pa ri uwaꞌl uwach, kꞌa te riꞌ xusuꞌ rukꞌ ri uwiꞌ, xutzꞌumaj, xuqujeꞌ xutix ri kunabꞌal chirij. ");
INSERT INTO quctt_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Are xril ri fariseo ri xsikꞌin ri Jesús, xubꞌij: We ta qas jun qꞌalajisal rech ri utzij ri Dios we achi riꞌ, retaꞌm ta uwach waꞌ we ixoq riꞌ ri tajin kachapowik, waꞌ areꞌ jun ajmak ixoq. ");
INSERT INTO quctt_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ri Jesús, xubꞌij che ri fariseo: Simón, kꞌo ri kawaj kinbꞌij chawe. Bꞌij la, ajtij, xcha ri Simón. ");
INSERT INTO quctt_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ri Jesús xubꞌij: E kꞌo kebꞌ achyabꞌ kiqajom pwaq che jun achi ri kuya pwaq pa qajik. Ri jun ukꞌas jobꞌ ciento keteꞌt taq pwaq, ri jun chik ukꞌas nikꞌaj ciento. ");
INSERT INTO quctt_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Maj kꞌu jawjeꞌ keꞌkima wi tojbꞌal rech, rumal riꞌ ri xyoꞌw kiqajanik, xukuy kimak kikobꞌchal. ¿Jachin chike we kebꞌ winaq riꞌ sibꞌalaj kaloqꞌaxik? ");
INSERT INTO quctt_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ri Simón xubꞌij: In kinchomaj chi are sibꞌalaj kaloqꞌax ri sibꞌalaj nim ukꞌas. Ri Jesús xubꞌij che: Qas je laꞌ leꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kꞌa te riꞌ xukaꞌyej ri ixoq, xubꞌij che ri Simón: ¿La kawil we ixoq riꞌ? Ri at man xaya ta nujaꞌ chꞌajbꞌal waqan are xinok la pa ri awachoch. Chawilampeꞌ, we ixoq riꞌ xratinisaj ri waqan rukꞌ ri uwaꞌl uwach xuqujeꞌ xuchaqiꞌjarisaj rukꞌ ri uwiꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Man xinatzꞌumaj taj, we ixoq kꞌut riꞌ are wokibꞌem loq man tanalinaq ta che utzꞌumaxik ri waqan. ");
INSERT INTO quctt_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Man xaqꞌij ta aceite rech olivo pa nujolom are xinok loq, are kꞌu we ixoq riꞌ xuqꞌij kꞌokꞌ laj kunabꞌal chirij ri waqan. ");
INSERT INTO quctt_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Rumal laꞌ kinbꞌij chawe: we ixoq riꞌ sibꞌalaj kꞌi umak xekuyutajik, rumal cher sibꞌalaj kaloqꞌanik. Xapachin ri xa nitzꞌ umak kakuyik, xa nitzꞌ loqꞌabꞌal kuꞌx kaya che. ");
INSERT INTO quctt_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ri Jesús xubꞌij che ri ixoq: Ronojel ri amak xkuyutajik. ");
INSERT INTO quctt_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ri winaq ri e kꞌo pa ri waꞌim xkichapleꞌj utayik chibꞌil taq kibꞌ. ¿Jachin we achi riꞌ cher kakwinik kukuy makaj? ");
INSERT INTO quctt_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ri Jesús xubꞌij che ri ixoq: Ri akojobꞌal xatukolo, jat pa jaꞌmaril. ");
INSERT INTO quctt_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Te kꞌu riꞌ, ri Jesús e rachiꞌl ri e kabꞌlajuj utijoxelabꞌ, xutzijoj ri utz laj taq tzij rech ri ajawarem rech ri Dios, pa taq ri tinimit xuqujeꞌ ri leꞌaj. ");
INSERT INTO quctt_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","E rachiꞌl xuqujeꞌ jujun ixoqibꞌ ri xesax itzel taq uxlabꞌal chike, ri María ri kabꞌix Magdalena che, ri xesax wuqubꞌ itzel taq uxlabꞌal che, ");
INSERT INTO quctt_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ri Juana rixoqil ri Cuza, ri kabꞌan rech puꞌwiꞌ ri ujastaq ri Herodes, ri Susana xuqujeꞌ e kꞌi ixoqibꞌ ri xkiya ri kirajil chutoꞌik ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Jaljoj taq tinimit xepe wi ri winaq xulkila ri Jesús. Are xkimulij kibꞌ kꞌi winaq, ri Jesús xutzijoj we jun kꞌambꞌejabꞌal noꞌj riꞌ chike: ");
INSERT INTO quctt_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Jun ajtikolobꞌ xeꞌ pa tikoꞌnijik. Are xukꞌyaq ri ijaꞌ, kꞌo xqaj chuxukut ri bꞌe, xtakꞌaleꞌxik xuqujeꞌ xkitij ri chochiꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Xqaj kꞌu nikꞌaj puꞌwiꞌ ri abꞌaj, are xkꞌiy loq, ri tikoꞌn xbꞌachꞌuꞌyarik rumal maj rax ulew xuriqo. ");
INSERT INTO quctt_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nikꞌaj chik xqaj chikixoꞌl ri kꞌix, are xkꞌiy loq, xjiqꞌ chuxoꞌl ri kꞌix. ");
INSERT INTO quctt_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Xqaj kꞌu nikꞌaj pa utz laj ulew, xeꞌl kꞌu loq, xekꞌiyik. Xkiya jujun ciento uwach chkijujunal. Are xtoꞌtaj chubꞌixik we jastaq riꞌ, xubꞌij: Ri kꞌo uxikin chutatabꞌexik, chutatabꞌej. ");
INSERT INTO quctt_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ri utijoxelabꞌ xkita che ri Jesús jas kel kubꞌij waꞌ we kꞌambꞌejabꞌal noꞌj riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ri Jesús xubꞌij: Yaꞌtal chiꞌwe ix kiwetaꞌmaj ri awatalik che ri ajawarem rech ri Dios, chike kꞌu nikꞌaj winaq chik, rukꞌ kꞌambꞌejabꞌal noꞌj kechꞌabꞌexik rech: Pune kekaꞌyik man kakil taj, pune kakito man kakichꞌobꞌ taj. ");
INSERT INTO quctt_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Are waꞌ ri kel kubꞌij ri xintzijoj chiꞌwe: Ri ijaꞌ are ri utzij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ri e kꞌo chuxukut ri bꞌe, are ri winaq ri kakitatabꞌej ri utzij ri Dios, ri itzel kꞌut kapetik, karesaj bꞌik ri tzij pa kanimaꞌ rech man kekojon taj xuqujeꞌ man kekolotaj taj. ");
INSERT INTO quctt_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ri e kꞌo puꞌwiꞌ ri abꞌaj are ri winaq ri kakikꞌamawaꞌj ri tzij rukꞌ kiꞌkotemal are kakitatabꞌej, maj kꞌu kikꞌaꞌmalil, jubꞌiqꞌ qꞌotaj kakikoj ri tzij, kꞌa te riꞌ keꞌl kanoq are kopan ri kꞌaxkꞌolal. ");
INSERT INTO quctt_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ri ijaꞌ ri xqaj pa taq ri kꞌix, are ri winaq ri kakito, are kꞌu keꞌ ri junabꞌ kejiqꞌ kan rumal taq ri rajawaxik, ri qꞌinomal, xuqujeꞌ ri jastaq rech ri uwachulew, man kewachin ta kꞌut. ");
INSERT INTO quctt_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Are kꞌu ri ijaꞌ ri xqaj pa utz laj ulew are ri winaq ri kakitatabꞌej ri tzij rukꞌ ronojel kanimaꞌ, kakiyak ri tzij pa kanimaꞌ, amaqꞌel kewachinik rumal cher amaqꞌel kakichakuj ri utzij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Maj jun winaq riꞌ ri kutzij jun qꞌaqꞌ, kꞌa te riꞌ kuchꞌuq rukꞌ jun laq. Xane kutzij jun qꞌaqꞌ rech kuya chikaj rech kꞌo kiqꞌaqꞌ ri kok bꞌik pa ri ja. ");
INSERT INTO quctt_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Maj jun jastaq ri awatalik ri mat kariqitaj na, xuqujeꞌ maj jun ri awatalik ri mat ketaꞌmataj na kumal konojel ri winaq. ");
INSERT INTO quctt_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Xaq jeriꞌ chitatabꞌej we riꞌ, ri kꞌo, kꞌo rukꞌ, kꞌo kayaꞌtaj na che, ri maj kꞌo rukꞌ, pune kubꞌij chi rech jun jastaq, kesataj na che. ");
INSERT INTO quctt_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Xopan kꞌu ri unan ri Jesús xuqujeꞌ ri e rachalal chi rilik. Sibꞌalaj kꞌi winaq kꞌut e kꞌo pa ri ja e sutininaq chirij ri Jesús, man kekwin taj keqet rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Xkibꞌij che ri Jesús: Ri anan xuqujeꞌ ri awachalal kakaj katkilo, e kꞌo cho le ja. ");
INSERT INTO quctt_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ri Jesús xubꞌij chike: Are e nunan xuqujeꞌ e wachalal, ri winaq ri kakitatabꞌej ri utzij ri Dios xuqujeꞌ kakichakubꞌej. ");
INSERT INTO quctt_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Jun qꞌijal xaqꞌan ri Jesús pa jun jukubꞌ bꞌinibꞌal puꞌwiꞌ jaꞌ, xubꞌij chike ri utijoxelabꞌ: Chujqꞌax chꞌaqaꞌp rech le plo. ");
INSERT INTO quctt_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Are e bꞌenaq puꞌwiꞌ ri plo, xwar ri Jesús, xpe kꞌu jun nimalaj kyaqiqꞌ puꞌwiꞌ ri plo, xuchapleꞌj okem ri jaꞌ pa ri jukubꞌ bꞌinibꞌal, xuchapleꞌj qajem chuxeꞌ ri jaꞌ, sibꞌalaj xibꞌibꞌal. ");
INSERT INTO quctt_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ri tijoxelabꞌ xebꞌe chukꞌasuxik, xkiraq kichiꞌ xkibꞌij: Ajtij, ajtij, kujjiqꞌik. Xwaꞌjil ri Jesús, xuyaj ri kyaqiqꞌ xuqujeꞌ ri jaꞌ, ri kyaqiqꞌ xtaniꞌk, ronojel xjoriꞌk. ");
INSERT INTO quctt_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Xubꞌij kꞌu chike ri utijoxelabꞌ: ¿Jawjeꞌ kꞌo wiꞌ ri ikojobꞌal? Ri tijoxelabꞌ xemayijanik xuqujeꞌ xkixiꞌj kibꞌ kakitatabꞌela chibꞌil taq kibꞌ. ¿Jachin waꞌ we achi riꞌ cher kataqan puꞌwiꞌ ri jaꞌ xuqujeꞌ ri kyaqiqꞌ keniman che? ");
INSERT INTO quctt_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Xoꞌpan pa ri tinimit Gadara, ri kꞌo apanoq cho ri Galilea chuchiꞌ ri plo. ");
INSERT INTO quctt_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ri Jesús are xqaj pa ri jukubꞌ bꞌinibꞌal puꞌwiꞌ jaꞌ, xuriq jun achi ri kꞌo jun itzel uxlabꞌal che upetik pa ri tinimit, we achi riꞌ najtir chik man kukoj ta ratzꞌyaq, xuqujeꞌ man kakꞌojiꞌ ta cho rachoch, xane pa taq ri muqbꞌal kaminaq kakꞌojiꞌ wi. ");
INSERT INTO quctt_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","We achi riꞌ are xril ri Jesús, xuraq uchiꞌ, xukulik xqaj choch, rukꞌ chuqꞌabꞌ xubꞌij: ¿Jas kaj la chwe, Jesús ralkꞌwaꞌl ri nimalaj Dios? Kinta toqꞌobꞌ che la man kabꞌan ta la kꞌax chwe. ");
INSERT INTO quctt_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jewaꞌ xubꞌij rumal cher ri Jesús xtaqanik rech ri itzel Uxlabꞌal kel bꞌik che ri achi. Kꞌi chi mul ubꞌanom rech che ri achi, pune kajatꞌix ri raqan rachiꞌl ri uqꞌabꞌ rukꞌ chꞌichꞌ jatꞌibꞌal xuqujeꞌ kachajixik, kutꞌoqopij kan ri chꞌichꞌ jatꞌibꞌal, ri itzel uxlabꞌal kujururej bꞌik pa taq ri kꞌolibꞌal ri katzꞌinowik. ");
INSERT INTO quctt_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ri Jesús xuta che: ¿Jas ri abꞌiꞌ? Legión nubꞌiꞌ, xchaꞌ. Jewaꞌ xubꞌij rumal cher sibꞌalaj e kꞌi ri itzel taq uxlabꞌal oꞌkinaq che. ");
INSERT INTO quctt_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ri itzel taq uxlabꞌal xkibꞌochiꞌj ri Jesús rech ketaq bꞌik pa ri qꞌequꞌmal. ");
INSERT INTO quctt_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Xkita toqꞌobꞌ che ri Jesús rech kuya bꞌe chike kok chike ri nikꞌaj aq ri tajin keyuqꞌux puꞌwiꞌ ri juyubꞌ. Ri Jesús xuya bꞌe chike. ");
INSERT INTO quctt_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Are xel bꞌik ri itzel taq uxlabꞌal che ri achi, xoꞌk chike ri aq, konojel ri aq xebꞌe pa ri plo, xejiqꞌik. ");
INSERT INTO quctt_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Are xkil ri aꞌjyuqꞌabꞌ ri xbꞌantajik, xaꞌnimajik, xkiya utzijoxik ri xkꞌulmatajik chike ri winaq pa ri tinimit, xuqujeꞌ pa taq ri leꞌaj. ");
INSERT INTO quctt_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Xeꞌl kꞌu bꞌik konojel ri winaq chi rilik ri xbꞌantajik, xeꞌkiriqa ri achi ri xel itzel uxlabꞌal che, tꞌuyul rukꞌ ri Jesús, are xkilo chi utz uwach, xuqujeꞌ ukojom chi ratzꞌyaq xkixiꞌj kibꞌ che. ");
INSERT INTO quctt_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Konojel ri winaq ri xkil ri xkꞌulmatajik xkitzijoj chike ri winaq jas jeꞌ xbꞌan chukunaxik ri achi. ");
INSERT INTO quctt_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Xepe kꞌu ri winaq rech ri tinimit Gadara, xkibꞌochiꞌj ri Jesús, rech kel bꞌik pa ri tinimit, rumal cher sibꞌalaj xkixiꞌj kibꞌ. Ri Jesús xaqꞌan bꞌik pa jun jukubꞌ bꞌinibꞌal xel bꞌik pa ri tinimit. ");
INSERT INTO quctt_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ri achi ri xel itzel uxlabꞌal che are xraj xutereneꞌj ri Jesús. Ri Jesús xubꞌij che: ");
INSERT INTO quctt_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Chattzalij cho awachoch, chatzijoj ronojel ri nimaq taq jastaq ri xubꞌan ri Dios awukꞌ. Xtzalij kꞌu ri achi pa ri utinimit, xutzijoj ronojel ri xubꞌan ri Jesús rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Are xtzalij ri Jesús pa Galilea ri winaq ri aꞌyeninaq apanoq xekiꞌkotik are xkil uwach. ");
INSERT INTO quctt_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Xopan kꞌu jun achi rukꞌ ri Jesús, ubꞌiꞌ Jairo, jun kꞌamal bꞌe pa ri Sinagoga, xukulik xqaj cho ri Jesús, xuta toqꞌobꞌ che rech keꞌ rukꞌ cho ri rachoch. ");
INSERT INTO quctt_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Jeriꞌ rumal cher ri Jairo xa jun umiꞌal kꞌolik, kabꞌlajuj ujunabꞌ raj kꞌu kakamik, ri Jesús kꞌut xeꞌ rukꞌ ri Jairo, are kꞌu ri winaq sibꞌalaj e kꞌi, kakipuyila ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kꞌo kꞌu jun ixoq chikixoꞌl ri winaq, kabꞌlajuj junabꞌ xaq katuruw ukikꞌel, maj jun ajkun kwininaq chukunaxik. ");
INSERT INTO quctt_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ri ixoq xqebꞌ chrij ri Jesús, xuchap ri uchiꞌ ri umanta, aninaq xtaniꞌ ri kikꞌ che. ");
INSERT INTO quctt_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ri Jesús xuta chike ri winaq: ¿Jachin xinchapowik? Rumal kꞌu cher kojonel ri winaq xkibꞌij chi man aꞌreꞌ taj xechapow ri Jesús, ri Pedro xubꞌij che: Ajtij e sibꞌalaj kꞌi winaq kakipaqchiꞌj la xuqujeꞌ kakipuyij la. ");
INSERT INTO quctt_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ri Jesús xubꞌij che: Kꞌo jun winaq ri xinchapowik. Xinnaꞌo kꞌo chuqꞌabꞌ xel bꞌik chwe. ");
INSERT INTO quctt_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Are xril ri ixoq chi xnabꞌetaj ri xubꞌano, kabꞌiribꞌatik, xukulik xqaj cho ri Jesús, chkiwach konojel ri winaq xutzijoj jas rumal xuchap ri manta, xuqujeꞌ chi aninaq xutzirik. ");
INSERT INTO quctt_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ri Jesús xubꞌij che: Numiꞌal, ri akojobꞌal xatukunaj, jat pa jaꞌmaril. ");
INSERT INTO quctt_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Tajin katzijon na ri Jesús, are xopan jun uꞌtaqoꞌn ri kꞌamal bꞌe rech ri Sinagoga, xuꞌbꞌij che: Man kaya ta chi latzꞌ che ri ajtij, xkam ri amiꞌal. ");
INSERT INTO quctt_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Are xuta ri Jesús, xubꞌij che ri Jairo: Man kaxiꞌj ta awibꞌ, we kakojo chi kakunataj ri amiꞌal, kakunatajik. ");
INSERT INTO quctt_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Are xopan ri Jesús cho rachoch ri Jairo, man xuya ta bꞌe xok japachinaq rukꞌ, xwi ri Pedro, Juan xuqujeꞌ ri Jacobo, xuqujeꞌ ri utat unan ri ali. ");
INSERT INTO quctt_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ri winaq ri e kꞌo chilaꞌ, kakibꞌisoj xuqujeꞌ kakoqꞌej ri ali. Ri Jesús xubꞌij chike, man kixoqꞌ ta chik, ri ali xaq kawarik, man kaminaq taj. ");
INSERT INTO quctt_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ri winaq are xkita we riꞌ xkichapleꞌj uyoqꞌik ri Jesús rumal cher ketaꞌm chi kaminaq chik ri ali. ");
INSERT INTO quctt_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ri Jesús xuchap ri uqꞌabꞌ ri ali, xubꞌij che: Chatwaꞌjiloq ali. ");
INSERT INTO quctt_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ri ali aninaq xwaꞌjilik, xtzalij loq ri ranimaꞌ. Ri Jesús kꞌut xtaqan chuyaꞌik uwa ri ali. ");
INSERT INTO quctt_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Sibꞌalaj xemayijan ri utat unan ri ali. Ri Jesús xubꞌij chike chi man kakitzijoj ri xkꞌulmatajik che jun chik. ");
INSERT INTO quctt_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ri Jesús xuꞌsikꞌij ri kabꞌlajuj utijoxelabꞌ, xuya kwinem chike chi resaxik ronojel ri itzel taq uxlabꞌal xuqujeꞌ chukunaxik yabꞌilal. ");
INSERT INTO quctt_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Xuꞌtaq bꞌik chutzijoxik ri ajawarem rech ri Dios, xuqujeꞌ chikikunaxik ri yawabꞌibꞌ ");
INSERT INTO quctt_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Xubꞌij ri Jesús chike: Mikꞌam bꞌik jun jastaq ri kajawataj chiꞌwe pa ri bꞌe, mikꞌam bꞌik ichꞌamiꞌy, ichim, ikaxlan wa, irajil, xuqujeꞌ mikꞌam bꞌik kebꞌ wok iwatzꞌyaq. ");
INSERT INTO quctt_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Chixkanaj kanoq pa japachike ja ri kixok wi, chixkꞌol chilaꞌ kꞌa chixel na loq pa ri tinimit. ");
INSERT INTO quctt_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","We man kixkꞌamawaꞌx pa jun tinimit, chitota kan ri ulew che ri iwaqan are kixel la chilaꞌ, jeriꞌ kiqꞌalajisaj chi man xixkꞌamawaꞌx taj. ");
INSERT INTO quctt_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Xebꞌe kꞌut ri tijoxelabꞌ, xkitzijoj ri utz laj tzij pa taq ronojel ri leꞌaj, xuqujeꞌ xeꞌkikunaj ri winaq. ");
INSERT INTO quctt_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ri nim taqanel Herodes Tetrarca xretaꞌmaj ronojel ri tajin kakꞌulmatajik. Xmayijanik rumal cher e kꞌo jujun winaq kakibꞌij chi xkꞌastaj ri Juan Bꞌanal qasanaꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","E kꞌo xuqujeꞌ kebꞌinik are Elías xukꞌut ribꞌ, e jujun xuqujeꞌ kakibꞌij jun laꞌ chike ri najtir taq qꞌalajisal rech ri utzij ri Dios ri xkꞌastaj loq. ");
INSERT INTO quctt_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Xubꞌij ri Herodes: In xintaqan chi resaxik ri ujolom ri Juan. ¿Jachin ta kꞌu waꞌ we achi riꞌ we kabꞌanow taq we jastaq riꞌ? Are kꞌu karaj karil uwach ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Are xetzalij loq ri tijoxelabꞌ, xkitzijoj che ri Jesús ri xkibꞌano. Ri Jesús xuꞌkꞌam bꞌik, xebꞌe kitukel pa ri tinimit Betsaida. ");
INSERT INTO quctt_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ri winaq are xketaꞌmaj jawjeꞌ xeꞌ wi ri Jesús xkitereneꞌj bꞌik. Xuꞌkꞌamawaꞌj kꞌu ri Jesús, xutzijoj ri ajawarem ri Dios chike, xuqujeꞌ xuꞌkunaj ri kajawataj kunanik chike. ");
INSERT INTO quctt_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Are xqaj qꞌij, xeqet ri tijoxelabꞌ rukꞌ, xkibꞌij che: Cheꞌtaqa la bꞌik ri winaq pa taq ri naqaj taq tinimit chutzukuxik kiwa xuqujeꞌ jun kꞌolibꞌal jawjeꞌ kekanaj wi kanoq, maj kariqitaj waral jawjeꞌ ri uj kꞌo wi. ");
INSERT INTO quctt_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ri Jesús xubꞌij chike: Chiꞌtzuqu ix. Ri tijoxelabꞌ xkibꞌij: Xaq xwi jobꞌ kaxlan wa xuqujeꞌ kebꞌ kar kꞌo qukꞌ, o are kaj la keꞌqaloqꞌo la kiwa konojel we winaq ri. ");
INSERT INTO quctt_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Jewaꞌ xkibꞌij rumal cher xkilo chi e jobꞌ mil achyabꞌ e kꞌolik, ri Jesús xubꞌij chike: Chibꞌij chike ketꞌuyiꞌ pa puq rech nikꞌaj ciento. ");
INSERT INTO quctt_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jewaꞌ xkibꞌan ri tijoxelabꞌ xeꞌkitaq konojel ri winaq rech ketꞌuyiꞌk. ");
INSERT INTO quctt_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Xukꞌam ri Jesús ri jobꞌ kaxlan wa xuqujeꞌ ri kebꞌ kar, xkaꞌy chikaj, xutewechiꞌj, xupirij. Kꞌa te riꞌ xuya chike ri utijoxelabꞌ rech kakijach chike ri winaq. ");
INSERT INTO quctt_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Konojel ri winaq xewaꞌik xuqujeꞌ xenojik, are xkimulij ri chꞌaqaꞌp taq kaxlan wa, kabꞌlajuj chakach xmulitajik. ");
INSERT INTO quctt_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Jun qꞌijal are tajin kubꞌan chꞌawem ri Jesús, e rachiꞌl ri utijoxelabꞌ xuta chike: ¿In jachin in kakibꞌij ri winaq? ");
INSERT INTO quctt_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ri utijoxelabꞌ xkibꞌij che: E kꞌo jujun kakibꞌij chi lal lal Juan Bꞌanal qasanaꞌ, e jujun chik kakibꞌij chi lal lal Elías, e jujun chik kakibꞌij chi lal jun chike ri e najtir taq tzijol rech ri utzij ri Dios, ri xkꞌastaj loq. ");
INSERT INTO quctt_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ri Jesús xuta chike: In ¿jachin kꞌu in kibꞌij ix? Lal lal Cristo rech ri Dios, xcha ri Pedro. ");
INSERT INTO quctt_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ri Jesús xuꞌpixibꞌaj ri utijoxelabꞌ rech man kakitzijoj taj we riꞌ che jachinaq. Xubꞌij xuqujeꞌ chike: ");
INSERT INTO quctt_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ri uKꞌojol ri Achi kuriq na kꞌax, ketzelax na uwach kumal ri e kꞌamal taq bꞌe, ri e kinimaꞌqil ri e bꞌanal taq chꞌawem cho ri Dios xuqujeꞌ ri aꞌjtijabꞌ rech ri taqanik. Sibꞌalaj choqꞌaqꞌ wi chi kakamisax na churox qꞌij kꞌut kakꞌastaj uwach. ");
INSERT INTO quctt_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Xubꞌij kꞌu chike konojel: We kꞌo jun karaj kubꞌan nutijoxel, mubꞌan ri urayinik, ronojel qꞌij reqaj ri ucheꞌ ripbꞌal xuqujeꞌ chinutereneꞌj. ");
INSERT INTO quctt_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Xapachin ri karaj kukol ri ukꞌaslemal, kasach na uwach riꞌ. Xapachin kꞌu ri kuya ri ukꞌaslemal wumal we kakolotaj na riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Jas kutayij che ri achi kuchꞌek ronojel ri qꞌinomal rech ri uwachulew kꞌa te riꞌ ke pa jun alik kaxkꞌolal? ");
INSERT INTO quctt_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","We kꞌo jun kakꞌix chwe, xuqujeꞌ kukꞌixibꞌej ri nutzij, kakꞌix xuqujeꞌ na ri uKꞌojol ri Achi che are kape pa ri ujuluwem xuqujeꞌ pa ri ujuluwem ri Tataxel xuqujeꞌ kech ri Tyoxalaj taq angelibꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Kinbꞌij xuqujeꞌ chiꞌwe chi e kꞌo winaq ri e kꞌo waral man kekam ta na, we man nabꞌe kakil ri ajawarem rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Wajxaqibꞌ qꞌij ubꞌim ri Jesús we jastaq riꞌ, xpaqꞌi puꞌwiꞌ jun juyubꞌ chubꞌanik chꞌawem, e rachiꞌl ri Pedro, ri Juan xuqujeꞌ ri Jacobo. ");
INSERT INTO quctt_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tajin kubꞌan chꞌawem are xkꞌexkꞌobꞌ ri upalaj, xsaqir ri ratzꞌyaq xuqujeꞌ xuchapleꞌj chuplinem. ");
INSERT INTO quctt_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Xkikꞌut xuqujeꞌ kibꞌ e kebꞌ achyabꞌ ketzijon rukꞌ ri Jesús, are Moisés rachiꞌl Elías. ");
INSERT INTO quctt_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Sibꞌalaj jeꞌl ri ujuluwem ri kipalaj. Ketzijon rukꞌ ri Jesús, puꞌwiꞌ ri ukamikal ri kakꞌulmataj na pa ri tinimit Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ri Pedro kꞌut xuqujeꞌ ri e rachiꞌl e kaminaq che waram, are xekꞌastaj qꞌanoq, xeꞌkil we kebꞌ winaq riꞌ xuqujeꞌ ri ujuluwem. ");
INSERT INTO quctt_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Are kakibꞌan bꞌenam ri e kebꞌ achyabꞌ, xpe ri Pedro, xuchapleꞌj chꞌawem pune man qas ta kuchomaj jas ri tajin kubꞌij: Ajtij, utz waꞌ kujkanaj waral. Kaqayaq oxibꞌ alaj taq ja, jun ech la, jun rech le Moisés, xuqujeꞌ jun rech le Elías. ");
INSERT INTO quctt_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tajin kachꞌaw na are xaq kꞌa te xpe jun sutzꞌ xechꞌuqutaj chupam, xkixiꞌj kꞌu kibꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Xpe kꞌu jun chꞌabꞌal pa ri sutzꞌ kubꞌij: Are waꞌ ri loqꞌalaj nukꞌojol, chitatabꞌej ri kubꞌij. ");
INSERT INTO quctt_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Are xtaniꞌ ri chꞌabꞌal, xebꞌe ri e rachiꞌl ri Jesús. Maj kꞌu jachin che xkitzijoj wi ri tijoxelabꞌ ri xkilo. ");
INSERT INTO quctt_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Chukabꞌ qꞌij, are xeqaj loq puꞌwiꞌ ri juyubꞌ, e kꞌi winaq xeꞌl bꞌik chi kikꞌulaxik. ");
INSERT INTO quctt_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kꞌo kꞌu jun achi chikixoꞌl ri winaq, ko xchꞌawik, xubꞌij: Ajtij, bꞌana la jun toqꞌobꞌ chwe, toꞌo la le nukꞌojol. ");
INSERT INTO quctt_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kꞌo jun itzel uxlabꞌal che, xaq kꞌa teꞌ kuraqaqej uchiꞌ, katontiꞌrik, kawusuw upuꞌchiꞌ. Tajin kubꞌan kꞌax che. ");
INSERT INTO quctt_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Xeꞌnbꞌochiꞌj ri tijoxelabꞌ la kakesaj bꞌik ri itzel uxlabꞌal, man xekwin ta kꞌut. ");
INSERT INTO quctt_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ri Jesús xubꞌij: Ri ix winaq sibꞌalaj man kixkojon taj, xuqujeꞌ man sukꞌ ta riꞌ bꞌe. ¿Jampaꞌ xaq in kꞌo iwukꞌ che ikochꞌik? Chakꞌama loq ri akꞌojol. ");
INSERT INTO quctt_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ri itzel uxlabꞌal xutzaq ri ala pa ri ulew are tajin kaqebꞌ loq. Ri Jesús kꞌut xresaj bꞌik ri itzel uxlabꞌal, xukunaj ri ala, kꞌa te riꞌ xutzalij bꞌik che ri utat. ");
INSERT INTO quctt_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Konojel ri winaq xkimayijaj ri nimalaj uchuqꞌabꞌ ri Dios. Are tajin kemayijan ri winaq che ri xubꞌan ri Jesús, ri Jesús xubꞌij chike ri utijoxelabꞌ: ");
INSERT INTO quctt_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Qas chikojo retal we kinbꞌij chiꞌwe, ri uKꞌojol ri Achi kajach na pa kiqꞌabꞌ ri achyabꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ri utijoxelabꞌ man xkichomaj taj jas ri xubꞌij chike. Jeriꞌ rumal cher tzꞌapital ri kibꞌoqꞌoch rech man kakichꞌobꞌ taj. Man kꞌo ta kꞌu jun karaj kuta che jas ri karaj kubꞌij. ");
INSERT INTO quctt_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ri tijoxelabꞌ kꞌut xkichapleꞌj utzijoxik rij jachin ri qas nim uqꞌij chike. ");
INSERT INTO quctt_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Retaꞌm ri Jesús ri tajin kakichomaj rumal riꞌ xukꞌam apanoq jun laj nitzꞌ akꞌal, xuya chuxukut. ");
INSERT INTO quctt_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Kꞌa te riꞌ xubꞌij: Ri kukꞌamawaꞌj we akꞌal riꞌ pa ri nubꞌiꞌ, in kinukꞌamawaꞌj, xuqujeꞌ ri kinukꞌamawaꞌj, kukꞌamawaꞌj ri xintaqow loq. Are sibꞌalaj nim uqꞌij ri man nim ta uqꞌij chi ixoꞌl ix. ");
INSERT INTO quctt_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ajtij, xcha ri Juan, xqil jun achi tajin keꞌresaj itzel taq uxlabꞌal pa ri bꞌiꞌ la, ri uj xqaqꞌil kanoq rumal cher man qachiꞌl taj. ");
INSERT INTO quctt_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ri Jesús xubꞌij che: Man kiꞌqꞌil taj. Ri man qakꞌulel taj, qachiꞌl riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Are xqeteqobꞌ loq ri qꞌij are katzalij ri Jesús pa ri kaj, xuchap ukꞌuꞌx keꞌ pa ri tinimit Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Xuꞌtaq bꞌik u taqoꞌn kenabꞌej apanoq keꞌkisukꞌumaj ri kꞌolibꞌal jawjeꞌ kawar wi pa ri tinimit ri kꞌo pa Samaria. ");
INSERT INTO quctt_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ri winaq aꞌj chilaꞌ man xkikꞌulaj ta ri Jesús, rumal cher xkilo chi pa Jerusalén bꞌenam wi rij. ");
INSERT INTO quctt_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Are xkil ri tijoxelabꞌ Jacobo xuqujeꞌ ri Juan ri xkꞌulmatajik, xkita che ri Jesús: Ajawxel, ¿la kaj la kaqata chikajil qꞌaqꞌ pa kiwiꞌ we winaq riꞌ rech kejaꞌrik? ");
INSERT INTO quctt_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Xtzalqꞌomij ri Jesús, xuꞌyajo. ");
INSERT INTO quctt_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kꞌa te riꞌ xkitaqej. Xebꞌe pa jun leꞌaj chik. ");
INSERT INTO quctt_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Are e bꞌenaq pa ri bꞌe, jun achi xubꞌij che ri Jesús: Kinteriꞌ chij la xapawjeꞌ keꞌ wi la. ");
INSERT INTO quctt_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Xubꞌij ri Jesús che: Ri e par e kꞌo kijul, ri aꞌwaj kerapinik kꞌo kisok. Are kꞌu ri uKꞌojol ri Achi maj jawjeꞌ kuqꞌoyobꞌa wi ri ujolom. ");
INSERT INTO quctt_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Xubꞌij ri Jesús che jun chik: Chatteren chwij. Ri achi xubꞌij: Ajawxel, ya la bꞌe chwe kinwil na kanoq kamuq ri nutat. ");
INSERT INTO quctt_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ri Jesús xubꞌij che: Chaya bꞌe chike ri e kaminaqibꞌ keꞌkimuq ri e kech kaminaqibꞌ. Ri at kꞌut chatan loq, chatzijoj ri ajawarem rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Jun achi chik xubꞌij: Ajawxel, kinteriꞌ chij la, xwi ya na la bꞌe chwe kenchꞌabꞌej kan ri e kꞌo pa ri wachoch. ");
INSERT INTO quctt_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ri Jesús xubꞌij che: Man taqal ta che jun winaq kok pa ri ajawarem rech ri Dios we nabꞌe kuya ri uqꞌabꞌ puꞌwiꞌ ri arado kꞌa te riꞌ kakaꞌy kan chirij. ");
INSERT INTO quctt_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Are xbꞌantaj we jastaq riꞌ, ri Jesús xuꞌchaꞌ oxkꞌal lajuj utijoxelabꞌ, xuꞌtaq bꞌik pa e kakabꞌ pa taq ri tinimit ri xraj xebꞌe wi. ");
INSERT INTO quctt_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kꞌa te riꞌ xubꞌij: Man e kꞌo ta kꞌi ajchakibꞌ chuyakik ronojel ri unimal ri xwachinik. Chita kꞌu che ri Ajawxel kuꞌtaq loq ajchakibꞌ pa ri uchak. ");
INSERT INTO quctt_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","¡Jix bꞌaꞌ! Qas chiwila na rumal kixintaq bꞌik jetaq ri chij chikixoꞌl kayoꞌt. ");
INSERT INTO quctt_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mikꞌam bꞌik yakbꞌal irajil, xuqujeꞌ ixajabꞌ, man kixtakꞌiꞌ ta pa ri bꞌe chuyaꞌik rutzil uwach japachinaq. ");
INSERT INTO quctt_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Are kixok pa jun ja, nabꞌe chibꞌij: “Jaꞌmaril pa we ja kꞌolibꞌal ri.” ");
INSERT INTO quctt_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","We kꞌu kꞌo jun winaq taqal ri jaꞌmaril che pa ri ja kꞌolibꞌal, kayaꞌtaj riꞌ ri tewechibꞌal che. We maj, katzalij riꞌ ri tewechibꞌal iwukꞌ ix. ");
INSERT INTO quctt_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Chixkanaj kanoq pa ri ja riꞌ, chitijaꞌ xuqujeꞌ chiqumuj ri kakiya chiꞌwe, rumal cher ri ajchak taqal che chi katojik. Man xaq ta kixikꞌow pa jaljoj taq ja. ");
INSERT INTO quctt_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Are kixok pa jun tinimit, ri kixkꞌamawaꞌx wi, chitijaꞌ ri kakiya chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Chiꞌkunaj ri yawabꞌibꞌ ri e kꞌo chilaꞌ, chibꞌij chike: “Ri ajawarem rech ri Dios xnaqajir loq.” ");
INSERT INTO quctt_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Are kꞌu man kixkꞌamawaꞌx taj pa jun tinimit, jix chibꞌij pa ri kꞌayibꞌal: ");
INSERT INTO quctt_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ri ulew ri xnakꞌiꞌ bꞌik pa qaqan, kaqatota kanoq, kꞌutbꞌal rech chi man xujikꞌamawaꞌj taj, naꞌtaj kꞌu chiꞌwe chi xnaqajir loq ri ajawarem rech ri Dios.” ");
INSERT INTO quctt_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kinbꞌij kꞌu chiꞌwe che ri qꞌij riꞌ, kꞌo na ri kꞌaxkꞌolal ri kape pa kiwiꞌ we tinimit cho ri xpe puꞌwiꞌ ri tinimit Sodoma ojer. ");
INSERT INTO quctt_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","¡Kꞌax iwe winaq ri kixel pa ri tinimit Corazín! ¡Kꞌax iwe winaq ri ix kꞌo pa ri tinimit Betsaida! We ta xbꞌan ri mayijabꞌal taq jastaq ri xbꞌan iwukꞌ pa ri tinimit Tiro xuqujeꞌ Sidón, rukꞌ oqꞌej ta waꞌ xkikꞌex kikꞌuꞌx ri winaq ri keꞌl chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Rumal kꞌu waꞌ, katan wi ri kꞌaxkꞌolal ri kape na pa kiwiꞌ ri tinimit Tiro xuqujeꞌ Sidón cho ri kꞌaxkꞌolal ri kape na pa iwiꞌ ix. ");
INSERT INTO quctt_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Xuqujeꞌ ri ix winaq ri ix kꞌo pa ri tinimit Capernaúm, ¿teꞌq pa ikꞌuꞌx kixpaqabꞌax bꞌik pa ri kaj? Man je ta kꞌu riꞌ, kꞌa pa ri nimalaj jul ri maj ukꞌisik kixkꞌyaq wi bꞌik. ");
INSERT INTO quctt_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Xapachin ri kixutatabꞌej, in riꞌ kinutatabꞌej, xapachin ri kaketzelaj iwach, in kinretzelaj. Xapachin kꞌu ri kinretzelaj in, karetzelaj ri xintaqow loq. ");
INSERT INTO quctt_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Rukꞌ kiꞌkotemal xetzalij loq ri oxkꞌal lajuj tijoxelabꞌ xkibꞌij: Ajawxel, pune are ri itzel taq uxlabꞌal kakimochꞌ kibꞌ pa ri bꞌiꞌ la. ");
INSERT INTO quctt_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ri Jesús xubꞌij: In xinwil ri Itzel, je ri xubꞌan jun kayapaꞌ xtzaq loq cho ri kaj. ");
INSERT INTO quctt_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Jeꞌ, nuyoꞌm kwinem chiꞌwe kiꞌtakꞌaleꞌj kumatz xuqujeꞌ escorpión, xuqujeꞌ kichꞌek ri ukwinem ri kꞌulel, maj kabꞌanow kꞌax chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pune jeriꞌ, man kikiꞌkotebꞌej taj are kakimochꞌ kibꞌ ri itzel taq uxlabꞌal chiꞌwach, xane are chikiꞌkotebꞌej chi tzꞌibꞌatal ri ibꞌiꞌ pa ri kaj. ");
INSERT INTO quctt_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Qas pa ri qꞌotaj riꞌ, ri Jesús xkiꞌkot pa ri Uxlabꞌixel, xubꞌij: Tataxel, ajawxel re ri kaj xuqujeꞌ ri ulew, xawaj la we jastaq riꞌ chikiwach ri achyabꞌ ri kꞌo ketaꞌmabꞌal, ri kꞌo kinoꞌjibꞌal, xkꞌut la chikiwach ri e winaq ri je ri e kꞌo nitzꞌ taq akꞌalabꞌ. Are waꞌ ri xrajawaj kuꞌx la, jeꞌ Tataxel. ");
INSERT INTO quctt_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ri nuTat xujach pa nuqꞌabꞌ ronojel ri jastaq ri kꞌolik. Maj jun etaꞌmaninaq uwach ri alkꞌwaꞌlaxel, xwi ri tataxel. Maj xuqujeꞌ jun retaꞌm uwach ri Tataxel, xaq xwi ri alkꞌwaꞌlaxel, xuqujeꞌ ri winaq ri yaꞌtal bꞌe che rumal ri alkꞌwaꞌlaxel. ");
INSERT INTO quctt_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ri Jesús xtzalqꞌomij kukꞌ ri utijoxelabꞌ, xubꞌij: Utz ke ri winaq ri kakil ri kiwil ix. ");
INSERT INTO quctt_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kinbꞌij chiꞌwe e kꞌo qꞌalajisal taq utzij ri Dios xuqujeꞌ e taqanelabꞌ ojer, xkaj kil ronojel we kiwil ix kamik, man xkil ta kꞌut, xkaj xuqujeꞌ xkita we kita ix kamik, man xekwin ta kꞌu chutatabꞌexik. ");
INSERT INTO quctt_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Xopan kꞌu jun nimalaj etaꞌmanel rech ri taqanik are karaj kukoj jun kꞌaꞌmabꞌal che ri Jesús, xubꞌij che: ¿Ajtij, jas rajawaxik kinbꞌano kinwechabꞌej ri jun alik kꞌaslemal? ");
INSERT INTO quctt_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ri Jesús kꞌut xubꞌij che: ¿Jas kabꞌan chusolik rij ri tzꞌibꞌatal pa ri taqanik? ");
INSERT INTO quctt_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ri achi etaꞌmanel rech ri taqanik xubꞌij: Chaloqꞌaj ri aDios rukꞌ ronojel awanimaꞌ, rukꞌ ronojel achuqꞌabꞌ, rukꞌ ronojel achomanik. Xuqujeꞌ chaloqꞌaj ri ajil tzꞌaqat jetaq ri kabꞌan chuloqꞌaxik awibꞌ at. ");
INSERT INTO quctt_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ri Jesús xubꞌij: Utz xabꞌan che ubꞌixik, we kabꞌan ri xabꞌij, katkꞌasiꞌ na. ");
INSERT INTO quctt_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Are kꞌu karaj ri achi kuqꞌalajisaj ri rutzilal, xuta kꞌu che ri Jesús: ¿Jachin kꞌu riꞌ ri nukꞌul ja? ");
INSERT INTO quctt_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ri Jesús xubꞌij: Upetik jun achi pa Jerusalén, xulanem bꞌik rij pa ri tinimit Jericó. Xqaj kꞌu pa kiqꞌabꞌ eleqꞌomabꞌ, xkesaj kan ri ratzꞌyaq, xkichꞌay kanoq, jubꞌiqꞌ karaj kakamik are xkitzaq kanoq. ");
INSERT INTO quctt_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Bꞌenaq kꞌu pa ri bꞌe riꞌ jun chꞌawenel cho ri Dios pa kiwiꞌ ri winaq. Are xrilo, xujelechꞌuj ubꞌe, kꞌa te riꞌ xusukꞌu, xeꞌek. ");
INSERT INTO quctt_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Xikꞌow xuqujeꞌ jun rijaꞌl ri Leví, are xril we achi, xujelechꞌuj xuqujeꞌ ri ubꞌe, xikꞌow bꞌik. ");
INSERT INTO quctt_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Bꞌenaq kꞌu jun achi aj Samaria pa ri bꞌe riꞌ. Are xril ri achi, xel ukꞌuꞌx che. ");
INSERT INTO quctt_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Xqebꞌ rukꞌ, xukunaj ri sokotajik rukꞌ vino xuqujeꞌ aceite rech olivo, xupiso, kꞌa te riꞌ xuya bꞌik puꞌwiꞌ ri ubꞌur, xukꞌam bꞌik pa jun ja chilaꞌ xuchajij wi. ");
INSERT INTO quctt_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Chukabꞌ qꞌij xuya kan kebꞌ saq taq pwaq che ri ajchoqꞌe ri ja warabꞌal, xubꞌij kan che: “Chajij la we achi riꞌ che la. We kꞌu kꞌo kusach na puꞌwiꞌ le xinya kan che la, kintoj che la are kintzalij loq.” ");
INSERT INTO quctt_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","¿Jachin chike we achyabꞌ riꞌ kabꞌij at chi xukꞌutu chi qas ukꞌulja we achi we xqaj pa kiqꞌabꞌ we eleqꞌomabꞌ? ");
INSERT INTO quctt_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Are ri achi ri xel ukꞌuꞌx che, xcha ri etaꞌmanel rech ri taqanik. Xubꞌij kꞌu ri Jesús che: Jat, jaꞌbꞌana jas ri xubꞌan we achi riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Are bꞌenaq ri Jesús pa ri bꞌe rachiꞌl ri utijoxelabꞌ xiꞌkꞌow bꞌik pa ri jun leꞌaj, kꞌo kꞌu jun ixoq ubꞌiꞌ Marta, xukꞌamawaꞌj ri Jesús cho ri rachoch. ");
INSERT INTO quctt_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Kꞌo kꞌu jun rachalal ubꞌiꞌ María xpetik, xultꞌuyul rukꞌ ri Jesús, xok chutatabꞌej ri tajin kubꞌij ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Are kꞌu ri Marta sibꞌalaj kel chꞌuꞌj rumal ronojel ri tajin kubꞌano. Xqebꞌ kꞌu rukꞌ ri Jesús xubꞌij che: Ajawxel, ¿la man kil la inuyoꞌm kan nutukel le wachalal cho le patanijik? Bꞌij la che kinutoꞌo. ");
INSERT INTO quctt_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ri Jesús kꞌut xubꞌij che: Marta, Marta, sibꞌalaj kꞌaxirinaq awanimaꞌ rumal ri ukꞌiyal ri jastaq tajin kabꞌano. ");
INSERT INTO quctt_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Xa kꞌu jun jastaq ri qas sibꞌalaj rajawaxik ubꞌanik. Are kꞌu waꞌ xuchaꞌ ri María, maj kꞌu jun kesan che. ");
INSERT INTO quctt_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jun qꞌijal ri Jesús tajin kubꞌan chꞌawem pa jun leꞌaj. Are xtoꞌtajik, jun chike ri utijoxelabꞌ xubꞌij che: Ajawxel, kꞌutu la chiqawach jas kaqabꞌan chubꞌanik chꞌawem, jetaq ri xubꞌan ri Juan kukꞌ ri utijoxelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Xubꞌij ri Jesús chike: Are kibꞌan chꞌawem, chibꞌij: Tat, tyoxirisatalik ri bꞌiꞌ la, peta ri ajawarem e la. ");
INSERT INTO quctt_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ya la qawa ronojel qꞌij. ");
INSERT INTO quctt_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kuyu la ri qamak jeꞌ jas ri uj keꞌqakuy ri kakibꞌan kꞌax chaqe, man kujtzaj ta la pa ri mak. ");
INSERT INTO quctt_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Kꞌa te riꞌ xubꞌij ri Jesús chike: Qaꞌnampe che: Jun chiꞌwe kꞌo jun rech chꞌabꞌeꞌn, kopan nikꞌaj aqꞌabꞌ rukꞌ kubꞌij che: “Wech chꞌabꞌeꞌn, kinqaj na oxibꞌ akaxlan wa. ");
INSERT INTO quctt_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Xa xul jun wech chꞌabꞌeꞌn cho ja upetik che jun ubꞌe, maj kꞌu kinya apanoq che.” ");
INSERT INTO quctt_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ri awech chꞌabꞌeꞌn kubꞌij loq chawe: “In xuqujeꞌ ri akꞌalabꞌ uj qꞌoyol chik, man kinkwin ta chik kinwaꞌjil chuyaꞌik we jastaq riꞌ chawe, man kawesaj ta nuwaram.” ");
INSERT INTO quctt_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Kinbꞌij chiꞌwe: Pune ri achi man kawaꞌjil taj rumal at rech chꞌabꞌeꞌn, kawaꞌjil kꞌu bꞌik rumal man katel ta chuchiꞌ ri rachoch, kuya bꞌik ri kajawataj chawe. ");
INSERT INTO quctt_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Rumal riꞌ kinbꞌij chiꞌwe: Chitaꞌ, rech kayaꞌtaj chiꞌwe. Chixtzukunoq rech kiriq ri kitzukuj, chixchꞌawoq rech kajaqataj ri uchiꞌ ja chiꞌwach. ");
INSERT INTO quctt_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Rumal cher ri winaq ri kuto, kayaꞌtaj na che, ri katzukunik kuriq na ri kutzukuj, ri kachꞌawik kajaqataj na ri uchiꞌ ja choch. ");
INSERT INTO quctt_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ix ix tat, ¿la kꞌo jun chiꞌwe are kuta jun ukaxlan wa ri iwalkꞌwaꞌl chiꞌwe la kiya jun abꞌaj che? Xuqujeꞌ are kuta jun kar chiꞌwe ¿la jun kumatz kiya che? ");
INSERT INTO quctt_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O wine kuta jun saqmoꞌl, ¿la escorpión kaya che? ");
INSERT INTO quctt_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","We ri ix, ix itzel taq winaq kiya utz laj taq jastaq chike ri iꞌwalkꞌwaꞌl, kꞌo kꞌu na ri kubꞌan ri tataxel Dios iwukꞌ, kuya na ri Uxlabꞌixel chike ri kakita che. ");
INSERT INTO quctt_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jun qꞌijal chik ri Jesús tajin karesaj jun itzel uxlabꞌal ri umemarisam jun achi. Are xesataj ri itzel uxlabꞌal che ri mem achi, ri achi xchꞌawik. Konojel kꞌu ri winaq xemayijanik. ");
INSERT INTO quctt_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","E kꞌo jujun winaq xkibꞌij: Waꞌ we achi riꞌ keꞌresaj ri itzel taq uxlabꞌal rukꞌ ri ukwinem ri Beelzebú ri kinimaꞌqil ri itzel taq uxlabꞌal. ");
INSERT INTO quctt_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","E kꞌo kꞌu jujun winaq chik xkita etal rech chikajil che ri Jesús xaq rech kakikoj kꞌaꞌmabꞌal pa ri ubꞌe. ");
INSERT INTO quctt_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Retaꞌm kꞌu ri Jesús ri kichomanik xubꞌij chike: Ronojel ajawarem ri ujachom ribꞌ, kasach na uwach, xuqujeꞌ ri e winaq ri keꞌl pa jun ja, we man xaq jun kichomanik, ketukin na riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Xaq jeriꞌ we kꞌo tukin ibꞌ chikixoꞌl ri itzel xuqujeꞌ ri e rachiꞌl, ¿la kakwin kꞌu riꞌ kajeqiꞌ pa ri rajawarem? Ri ix kibꞌij chi keꞌnwesaj ri itzel taq uxlabꞌal rukꞌ ri ukwinem ri Beelzebú. ");
INSERT INTO quctt_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","We keꞌnwesaj in ri itzel taq uxlabꞌal rukꞌ ri ukwinem ri Beelzebú, ¿jachin kꞌu kayoꞌw kwinem chike ri itijoxelabꞌ ix chi resaxik ri itzel taq uꞌxlabꞌal? Rumal riꞌ aꞌreꞌ la keqꞌatow na tzij pa iwiꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","We rukꞌ ri ukwinem ri Dios keꞌnwesaj bꞌik ri itzel taq uxlabꞌal, waꞌ kel kubꞌij chi xul ri ajawarem rech ri Dios iwukꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","We kꞌo jun achi ri sibꞌalaj kꞌo uchuqꞌabꞌ, xuqujeꞌ kꞌo uchꞌeyabꞌal, utz riꞌ kubꞌan chuchajixik ri rachoch xuqujeꞌ ri umebꞌail. ");
INSERT INTO quctt_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","We kꞌu kape jun achi chirij ri sibꞌalaj kꞌo uchuqꞌabꞌ choch, kesax riꞌ ri uchꞌeyabꞌal ri kuꞌl ukꞌuꞌx chirij, xuqujeꞌ kelaqꞌax bꞌik ronojel ri jastaq rech. ");
INSERT INTO quctt_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ri man wachiꞌl taj, nukꞌulel riꞌ. Ri man kinutoꞌ ta chikimulixik ri winaq riꞌ xa kuꞌtukij bꞌik. ");
INSERT INTO quctt_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jun itzel uxlabꞌal are kel bꞌik che jun achi, keꞌ pa taq ri katzꞌinow ulew, kuꞌxlanoq. Are man kuriq ta kꞌu uxlanem, kubꞌij: “Kintzalij cho wachoch jawjeꞌ ri xinel wi loq.” ");
INSERT INTO quctt_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Are kopanik, mestal chi ri ja ri xel wi loq sibꞌalaj sukꞌumatal chik. ");
INSERT INTO quctt_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kel kꞌu bꞌik, kubꞌuꞌ ma loq e wuqubꞌ itzel uxlabꞌal che rachiꞌl, kepe rukꞌ cho ri ja. Xaq jeriꞌ sibꞌalaj kꞌax kakanaj kan ri ukꞌaslemal ri winaq, sibꞌalaj kꞌax na cho ri ubꞌanik kan nabꞌe. ");
INSERT INTO quctt_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Are tajin kubꞌij ri Jesús we jastaq riꞌ, jun ixoq ri kꞌo chikixoꞌl ri winaq xubꞌij che: Sibꞌalaj utz rech ri ixoq ri xatuya pa ri uwachulew, xuqujeꞌ xatutubꞌisaj. ");
INSERT INTO quctt_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ri Jesús xubꞌij: Are utz ke ri winaq ri kakita ri utzij ri Dios, xuqujeꞌ kakinimaj. ");
INSERT INTO quctt_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Are tajin kakimulij kibꞌ ri winaq, ri Jesús xubꞌij chike: Itzel taq winaq ri winaq rech we qꞌij junabꞌ riꞌ, are kakaj kabꞌan jun mayijabꞌal laj kꞌutbꞌal chikiwach, man kayaꞌtaj ta chi kꞌu jun kꞌutbꞌal chike we man are ri kꞌutbꞌal rech ri Jonás. ");
INSERT INTO quctt_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jetaq ri Jonás xux jun kꞌutbꞌal chike ri winaq ri aꞌj tinimit rech Nínive ojer, ri uKꞌojol ri Achi xuqujeꞌ kux na jun kꞌutbꞌal chike ri itzel taq winaq rech we qꞌij junabꞌ riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ri ixoq taqanel rech ri tinimit Saba kawaꞌjil na pa ri kꞌisbꞌal qꞌij, kuqꞌat na tzij pa kiwiꞌ we winaq riꞌ, rumal areꞌ upetik pa ri kꞌisbꞌal taq tinimit xuluta ri retaꞌmabꞌal ri Salomón. Waral kꞌut kꞌo jun achi ri are nim uqꞌij cho ri Salomón. ");
INSERT INTO quctt_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ri winaq aꞌj Nínive rech ojer, kewaꞌjil na pa ri qꞌij rech qꞌatbꞌal tzij, kakiqꞌat na tzij pa kiwiꞌ ri winaq rech we qꞌij junabꞌ riꞌ, rumal aꞌreꞌ xkikꞌex kikꞌuꞌx are xkita ri qꞌalajisanik ri xubꞌan ri Jonás, kamik kꞌut kꞌo jun winaq iwukꞌ ri nim ubꞌanik cho ri Jonás. ");
INSERT INTO quctt_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Man kꞌo ta jun winaq ri kutzij jun tunal, kꞌa te riꞌ karawaj, o kukoj ne jun kajon chuchꞌuqik, xane kuya chikaj rech kꞌo kitunabꞌal ri koꞌk bꞌik pa ri ja. ");
INSERT INTO quctt_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ri abꞌoqꞌoch at are katunan ri atyoꞌjal, we kekaꞌy ri abꞌoqꞌoch, kꞌo utunal riꞌ ri atyoꞌjal, are kꞌu we kꞌo sutzꞌ chupam, ronojel riꞌ ri atyoꞌjal kakꞌojiꞌ pa qꞌequꞌmal. ");
INSERT INTO quctt_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Qas chawila na chi ri tunal ri kabꞌij kꞌo awukꞌ man qꞌequꞌmal taj. ");
INSERT INTO quctt_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Xaq jeriꞌ we ronojel ri atyoꞌjal kꞌo utunal, man kꞌo ta jubꞌiqꞌ qꞌequꞌmal che, katkꞌojiꞌ riꞌ pa ri tunal, jetaq are at tunatal rumal jun nimalaj tunal. ");
INSERT INTO quctt_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Are xtoꞌtaj ri Jesús che tzijonem, xpe jun fariseo xusikꞌij che waꞌim, xaq jeriꞌ xok bꞌik cho rachoch ri fariseo, xtꞌuyiꞌ chu ri mexa. ");
INSERT INTO quctt_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Xmayijan kꞌu ri fariseo are xril ri Jesús man xuchꞌaj ta ribꞌ are majaꞌ kawaꞌik, jetaq ri kubꞌij ri naqꞌatajibꞌal. ");
INSERT INTO quctt_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Xubꞌij ri Jesús: Ri ix, ix fariseos, kichꞌajchꞌobꞌej ri qumubꞌal xuqujeꞌ ri palaꞌt, xa kꞌu ixnojinaq pa iwanimaꞌ che, itzel taq rayinik xuqujeꞌ etzelal. ");
INSERT INTO quctt_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Maj iwetaꞌmabꞌal! ¿La man are winaq ri xbꞌanow ri rij ri jastaq ri xbꞌanow xuqujeꞌ ri upam? ");
INSERT INTO quctt_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","We kibꞌan ri utzilal kukꞌ ri iꞌkꞌulja kachꞌajchꞌojir riꞌ ri iwanimaꞌ che itzel taq chomabꞌal. ");
INSERT INTO quctt_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Kꞌax iwe, fariseos! Ri kiya ri ulajujil rech ri menta, ri rora, xuqujeꞌ ronojel uwach qꞌayes, xa kꞌu man kibꞌan ta ri sukꞌal, xuqujeꞌ man kibꞌan ta ri kubꞌij ri uloqꞌanik ri Dios. Rajawaxik wi kibꞌan waꞌ we riꞌ xuqujeꞌ man kasachan ta chiꞌwe ubꞌanik waꞌ we jun chik riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Kꞌax iwe, fariseos! ix ri kixkam che uriqik ri nabꞌe taq tꞌuyulibꞌal pa ri Sinagoga, xuqujeꞌ kiwayeꞌj ri rutzil iwach kakiya ri winaq pa taq ri kꞌayibꞌal. ");
INSERT INTO quctt_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Kꞌax iwe! je ri ix kꞌo ri muqbꞌal taq kaminaqibꞌ, pune jeꞌl kabꞌantaj ri iwij, xa kꞌu e sibꞌalaj chu ri kaminaqibꞌ ri e kꞌo chiꞌpam. ");
INSERT INTO quctt_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jun chike ri achyabꞌ ri sibꞌalaj retaꞌm ri taqanik, xubꞌij che ri Jesús, ajtij: tajin kujyoqꞌ xuqujeꞌ la uj, are jeriꞌ katzijon la. ");
INSERT INTO quctt_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Xubꞌij ri Jesús chike: Je xuqujeꞌ ix ri sibꞌalaj iwetaꞌm ri taqanik. ¡Kꞌax iwe! ix ri kiya eqaꞌn ri man qꞌiꞌowel taj chikij nikꞌaj winaq chik xa kꞌu man kiwaꞌjilisaj ta apanoq jun uwiꞌ iqꞌabꞌ chikitoꞌik. ");
INSERT INTO quctt_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Kꞌax iwe! ix ri kiyak tzꞌaq naꞌtabꞌal ke ri qꞌalajisal taq rech ri utzij ri Dios ri xekamisax kumal ri itat inan ojer. ");
INSERT INTO quctt_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ri ix tajin kibꞌij chi utz ri xkibꞌan ri itat inan ojer rumal cher aꞌreꞌ xekamisan ri e qꞌalajisal taq utzij ri Dios, ri ix kꞌut are tajin kiyak tzꞌaq naꞌtabꞌal ke. ");
INSERT INTO quctt_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Rumal riꞌ, ri Dios rukꞌ ri retaꞌmabꞌal xubꞌij: Keꞌntaq bꞌik qꞌalajisal taq nutzij xuqujeꞌ e tzijol taq we kukꞌ, kakibꞌan kꞌu na kꞌax chike, xuqujeꞌ keꞌkikamisaj. ");
INSERT INTO quctt_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Rumal waꞌ kata na kwenta chike we winaq rech we qꞌij junabꞌ riꞌ che ri kikikꞌel konojel ri e qꞌalajisal taq rech ri utzij ri Dios ri xkichapleꞌj loq pa ri ujeqetajik ri uwachulew, kꞌa pa taq ri qꞌij rech kamik. ");
INSERT INTO quctt_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kachapleꞌtaj loq rukꞌ ri ukikꞌel ri Abel, kultoqꞌol rukꞌ ri ukikꞌel ri Zacarías ri xkam chuxoꞌl ri tzujbꞌal sipanik xuqujeꞌ ri Tyoxalaj kꞌolibꞌal. Jeꞌ, qas kinkꞌyaqabꞌa kan ubꞌixik, rumal we riꞌ kaqꞌat na tzij pa kiwiꞌ we winaq rech we qꞌij junabꞌ riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Kꞌax iwe ix ri sibꞌalaj iwetaꞌm ri taqanik! rumal ibꞌanom iwe che ri lawe rech ri etaꞌmabꞌal. Ix man ixokinaq taj, xuqujeꞌ iꞌqꞌatem ri rajawam kikꞌuꞌx koꞌkik. ");
INSERT INTO quctt_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Are xel bꞌik ri Jesús chilaꞌ, ri aꞌjtijabꞌ rech ri taqanik sibꞌalaj kꞌax xkinaꞌo rumal ri xubꞌij, rumal riꞌ xkichapleꞌj ukꞌotik uchiꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Are xkaj xkikoj kꞌaꞌmabꞌal pa ri ubꞌe, rech kasach chubꞌixik jun jastaq. ");
INSERT INTO quctt_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Sibꞌalaj e kꞌi winaq kꞌut xkimulij kibꞌ, xaq kakitakꞌaleꞌla chi kibꞌ, xpe kꞌu ri Jesús xuchapleꞌj kichꞌabꞌexik, nabꞌe xubꞌij chike ri utijoxelabꞌ: Chichajij iwibꞌ che ri chꞌam kech ri fariseos, pa nikꞌaj tzij chik, ri kikawachil. ");
INSERT INTO quctt_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Rumal chi maj jun jastaq ri man etaꞌmatal taj ri mat kilitaj na, xuqujeꞌ maj jun jastaq awatalik ri mat ketaꞌmataj na. ");
INSERT INTO quctt_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Rumal riꞌ ronojel ri ibꞌim pa ri qꞌequꞌmal katataj na cho ri utunal ri qꞌij, xuqujeꞌ ri ibꞌim chi awal are itzꞌapim ri uchiꞌ ja, karaqaqex na ubꞌixik puꞌwiꞌ taq ri ja. ");
INSERT INTO quctt_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Chiꞌwe ix wech chꞌabꞌeꞌn kinbꞌij man kixiꞌj ta iwibꞌ chike ri kekamisan ri ityoꞌjal, rumal xwi riꞌ kekwinik kakibꞌano. ");
INSERT INTO quctt_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kinbꞌij chiꞌwe jachin choch rajawaxik kixiꞌj wi iwibꞌ, chixiꞌj iwibꞌ choch ri are kesataj ri kꞌaslemal rumal, kꞌo ukwinem kixutaq bꞌik pa ri tyoꞌnel qꞌaqꞌ, jeꞌ cho areꞌ rajawaxik kixiꞌj wi iwibꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","¿La man kebꞌ saqa pwaq kajil ri jobꞌ chochiꞌ? Pune jeriꞌ man kesachan ta che ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Rumal cher ri Dios rajilam ronojel ri ukꞌiyal ri iwiꞌ ri kꞌo pa ijolom, xaq jeriꞌ man kixiꞌj ta iwibꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Kinbꞌij kꞌu chiꞌwe xapachin ri kinuqꞌalajisaj chikiwach ri winaq, kaqꞌalajisax xuqujeꞌ na uwach chikiwach ri angelibꞌ rech ri Dios rumal ri uKꞌojol ri Achi. ");
INSERT INTO quctt_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Xapachin kꞌu ri karawaj nubꞌixik chkiwach ri winaq man kaqꞌalajisax ta ri ubꞌiꞌ chikiwach ri angelibꞌ rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Xapachin ri kubꞌij jun itzel tzij che ri uKꞌojol ri Achi, kakuyutaj na. Are kꞌu ri winaq ri karetzelaj uwach ri Tyoxalaj Uxlabꞌixel rukꞌ taq tzij, man kakuyutaj taj. ");
INSERT INTO quctt_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Are kixtakꞌatobꞌ pa ri Sinagoga xuqujeꞌ chikiwach ri qꞌatal taq tzij, xuqujeꞌ ri e taqanelabꞌ, man kakꞌaxkꞌobꞌ ta iwanimaꞌ chuchomaxik jas kibꞌan chutoꞌik iwibꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Are ri Tyoxalaj Uxlabꞌixel kakꞌutuw chiꞌwach ri rajawaxik kibꞌij. ");
INSERT INTO quctt_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kꞌo kꞌu jun achi chikixoꞌl ri winaq, xubꞌij che ri Jesús: Ajtij, bꞌij la che ri wachalal chujacha ri echabꞌal chiqawach. ");
INSERT INTO quctt_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ri Jesús kꞌut xubꞌij che: Achi, ¿jachin xbꞌin chawe chi in in qꞌatal tzij pa iwiꞌ? ");
INSERT INTO quctt_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Chichajij iwibꞌ che ri kꞌarkꞌatem rumal cher man are taj ri ukꞌiyal ri uqꞌinomal ri winaq ri kayoꞌw ukꞌaslemal. ");
INSERT INTO quctt_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Xutzijoj kꞌu chike we jun kꞌambꞌejabꞌal noꞌj riꞌ: Kꞌo jun qꞌinom achi, ri sibꞌalaj xwachin ri rulew. ");
INSERT INTO quctt_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Xuchomaj kꞌut: “¿Jas kinbꞌano? ¿Jawjeꞌ kinyak wi ronojel ri nutikoꞌn ri xwachinik?” ");
INSERT INTO quctt_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kꞌisbꞌal rech xubꞌij: “Wetaꞌm jas kinbꞌano, kintukij na ri nukꞌolibꞌal jawjeꞌ ri kinyak wi ri uwach ri nutikoꞌn, kinyak chi na jun sibꞌalaj nim cho ri kꞌo kan nabꞌe, rech utz kinbꞌan chuyakik ronojel ri nutikoꞌn. ");
INSERT INTO quctt_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kinbꞌij kꞌu na, wanimaꞌ sibꞌalaj kꞌi ajastaq rech kꞌi junabꞌ yakalik. Xaq bꞌa chatuxlanoq, chatwoꞌq, chatqumunoq, chakiꞌkotebꞌej ri kꞌaslemal.” ");
INSERT INTO quctt_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Xubꞌij kꞌu ri Dios che: “¡Konalaj achi! Chaqꞌabꞌ kamik katkamik. ¿Jachin kꞌu pa uqꞌabꞌ kakanaj wi kan ri ajastaq ri amulim?” ");
INSERT INTO quctt_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jewaꞌ kakꞌulmataj kukꞌ ri winaq ri kakimulij qꞌinomal xaq ke aꞌreꞌ, man are ta kakitzukuj kuꞌx qꞌinomabꞌ cho ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kꞌa te riꞌ xubꞌij ri Jesús chike ri utijoxelabꞌ: Rumal riꞌ kinbꞌij chiꞌwe we are ri Dios yoꞌwinaq ri ikꞌaslemal, are xuqujeꞌ kayoꞌw na ri iwa, we are ri Dios yoꞌwinaq ri ityoꞌjal are xuqujeꞌ kayoꞌw na ri iwatzꞌyaq. ");
INSERT INTO quctt_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Are nim na rajil ri kꞌaslemal cho ri tijowik rij, je xuqujeꞌ are nim ubꞌanik ri ityoꞌjal cho ri iwatzꞌyaq. ");
INSERT INTO quctt_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","¡Chiꞌwilampe ri joj! Man keꞌtikoꞌnij taj, xuqujeꞌ man kejachꞌan taj, xuqujeꞌ Man kꞌo ta kikaxon chuyakik ri kakijachꞌo. Pune jeriꞌ, ri Dios kuya kiwa. Ix kꞌut ix kꞌo na chikiwach ri aꞌwaj ri kerapinik. ");
INSERT INTO quctt_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Jachin ta kꞌu chiꞌwe rukꞌ ri kakꞌaxkꞌobꞌ ukꞌuꞌx kakwinik kuya jubꞌiqꞌ uwiꞌ ri ukꞌaslemal? ");
INSERT INTO quctt_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","¿Jas che kakꞌaxkꞌobꞌ ikꞌuꞌx chike nikꞌaj winaq chik, la man kinaꞌo chi man kixkwin ta chubꞌanik xa ta ne jun nitzꞌ laj jastaq? ");
INSERT INTO quctt_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Chiwilampeꞌ ri kotzꞌiꞌj, man kechakun taj, man kakisol ta bꞌatzꞌ, pune jeriꞌ, ri Salomón rukꞌ ronojel ri ujuluwem man xkwin taj je xatzꞌyaqinik jetaq ri aꞌreꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","We jeriꞌ kubꞌan ri Dios kukꞌ ri qꞌayes, ri tikil kamik cho ri saq chweꞌq kꞌut kaporoxik, are kꞌu mat kuya iwatzꞌyaq ix, winaq ri xa nitzꞌ ikojobꞌal. ");
INSERT INTO quctt_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Xaq jeriꞌ man kakꞌaxkꞌobꞌ ta ikꞌuꞌx che ri kitijo xuqujeꞌ ri kiqumuj, chixtanal che uchomaxik rij. ");
INSERT INTO quctt_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ri winaq aꞌjuwachulew are kitereneꞌm utzukuxik ronojel waꞌ we jastaq riꞌ, ri iTat kꞌut retaꞌm chi rajawaxik ronojel waꞌ we jastaq riꞌ chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Are chitzukuj ix ri rawajarem ri Dios, xaq kꞌu katerebꞌax na uyaꞌik ronojel waꞌ we jastaq riꞌ chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ri utz laj urayibꞌal ukꞌuꞌx ri Tataxel are chi kuya na ri ajawarem chiꞌwe, man kixiꞌj ta bꞌa iwibꞌ alaj taq nuchij. ");
INSERT INTO quctt_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Chikꞌayij ri ijastaq rech kiya kirajil ri kajawataj chike. Chiloqꞌo yakbꞌal irajil ri man kajar taj, chimulij ri iqꞌinomal chilaꞌ chikaj, jawjeꞌ e maj wi eleqꞌomabꞌ, xuqujeꞌ maj iꞌxjut kok che. ");
INSERT INTO quctt_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Rumal ri iwanimaꞌ kakꞌojiꞌ na jawjeꞌ ri kꞌo wi ri iqꞌinomal. ");
INSERT INTO quctt_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Chitzija bꞌa ri qꞌaqꞌ tunabꞌal, chisukꞌumaj iwibꞌ, chikojo ri iwatzꞌyaq ri jas xaqareꞌ chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Je chixnoꞌjinoq jetaq ri kakibꞌan ri ajchakibꞌ aninaq kakijaq ri uchiꞌ ja cho ri kipatrón ri upetik pa ri nimaqꞌij rech jun kꞌulanem. ");
INSERT INTO quctt_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Utz ke ri patanijelabꞌ ri kuleꞌriqitajoq kayeꞌm apanoq ri kajaw. Qas kinbꞌij chiꞌwe, are kul ri kajaw kukꞌex riꞌ ri ratzꞌyaq, kuꞌtaq pa tꞌuyulem ri e rajchakibꞌ, xuqujeꞌ kok chikipatanixik. ");
INSERT INTO quctt_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Jeꞌ, utz ke ri ajchakibꞌ ri pune nikꞌaj aqꞌabꞌ, o sibꞌalaj aqꞌabꞌ kisukꞌumam apanoq kibꞌ are kuleꞌriqitajoq. ");
INSERT INTO quctt_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Chichꞌobꞌo kꞌu rij we riꞌ, we kꞌo jun ajchoqꞌe jun ja ri retaꞌm jas qꞌotaj kok ri elaqꞌom pa ri rachoch, kakꞌasiꞌ riꞌ chuchajixik rech man kok ta ri elaqꞌom pa ri ja. ");
INSERT INTO quctt_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Rajawaxik je kibꞌan apanoq ix, rumal chi ri uKꞌojol ri Achi kapetik are man ichomanik ta apanoq. ");
INSERT INTO quctt_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Are kꞌu ri Pedro xubꞌij che ri Jesús: Ajawxel ¿la chike konojel le winaq katzijoj wi la we kꞌambꞌejabꞌal noꞌj riꞌ o xaq chaqe uj? ");
INSERT INTO quctt_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Xubꞌij ri Jesús: ¿La kariqitaj jun utz laj patanijel ri kꞌo retaꞌmabꞌal, kachilibꞌex kan che kuya kiwa ri ajchakibꞌ pa ri kꞌyaqalik qꞌotaj? ");
INSERT INTO quctt_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Utz rech ri ajchak ri are katzalij loq ri rajaw tajin kubꞌan apanoq ri upatan. ");
INSERT INTO quctt_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Qas kinbꞌij chiꞌwe, riꞌ ri winaq riꞌ kukoj che chajil rech ronojel ri ujastaq. ");
INSERT INTO quctt_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Jas kꞌu kakꞌulmataj riꞌ we kuchomaj ri ajchak chi kabꞌeyetaj riꞌ ri wajaw, kuchapleꞌj kꞌut kichꞌayik ri ajchakibꞌ achyabꞌ xuqujeꞌ ixoqibꞌ, kuchapleꞌj waꞌim xuqujeꞌ qꞌabꞌarik. ");
INSERT INTO quctt_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Katzalij kꞌu loq ri rajaw we ajchak riꞌ, pa ri qꞌij xuqujeꞌ pa ri qꞌotaj ri man ayeꞌtal ta apanoq rumal ri rajchak, kaqꞌat kꞌu na tzij puꞌwiꞌ jetaq ri kabꞌan chike ri man e kojonelabꞌ taj. ");
INSERT INTO quctt_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Kul chꞌaya kꞌu na ri patanijel ri man ubꞌanom ta apanoq jas ri karaj ri patrón. ");
INSERT INTO quctt_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ri patanijel kꞌut ri man retaꞌm taj jas ri rayibꞌal ukꞌuꞌx ri rajaw, kubꞌan kꞌu apanoq jun jastaq ri man utz taj, kaqꞌat tzij riꞌ puꞌwiꞌ xa kꞌu man sibꞌalaj kꞌax taj kabꞌan che. Ri nim yaꞌtal che, nim na katoqꞌix che, xuqujeꞌ ri nim kuꞌlibꞌal kuꞌx yaꞌtal che, sibꞌalaj nim na kata che. ");
INSERT INTO quctt_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Nukꞌamom la in qꞌaqꞌ cho ri uwachulew, kꞌo ta bꞌa ne wi kajinin chik. ");
INSERT INTO quctt_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Xa kꞌu kinikꞌow na pa ri jun kꞌax laj etabꞌal jetaq ri kabꞌan che ri qasanaꞌ, kꞌaxkꞌobꞌinaq kꞌu ri wanimaꞌ, kꞌa pa ri qꞌij ri kakꞌulmataj na we jastaq riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Teꞌq pa ikꞌuꞌx ix chi jaꞌmaril nukꞌamom la cho ri uwachulew? Man je ta kꞌu riꞌ, tukinem nukꞌamom loq. ");
INSERT INTO quctt_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kamik kꞌut kachapleꞌtaj bꞌik ri paꞌin ibꞌ pa ri ja kꞌolibꞌal, jawjeꞌ ri e kꞌo wi jobꞌ winaq, oꞌxibꞌ kakibꞌan na kikꞌulel chike ri e kebꞌ, xuqujeꞌ ri e kebꞌ winaq kuꞌx na kikꞌulel ri oxibꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Kechꞌoꞌjin na ri tat rukꞌ ri ukꞌojol, ri kꞌojolaxel kachꞌoꞌjin na rukꞌ ri utat, ri nan kachꞌoꞌjin na rukꞌ ri ral ali, xuqujeꞌ ri ali kachꞌoꞌjin na rukꞌ ri unan. Ri alibꞌ chuchuꞌ kachꞌoꞌjin na rukꞌ ri ralibꞌ ali, xuqujeꞌ ri alibꞌatz kachꞌoꞌjin na rukꞌ ri ralibꞌ ixoq. ");
INSERT INTO quctt_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Xuqujeꞌ xubꞌij ri Jesús chike ri sibꞌalaj e kꞌi winaq: Kibꞌij ix chi kubꞌan jabꞌ are xaq kꞌa teꞌ kiwilo kapaqiꞌ la jun sutzꞌ, qas je kꞌu wi riꞌ kakꞌulmatajik. ");
INSERT INTO quctt_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Are kape ri kyaqiqꞌ chuxukut ulew ri kajichꞌichꞌik kubꞌan qꞌaqꞌ waꞌ kixcha ix, qas je kꞌu wi riꞌ kakꞌulmatajik. ");
INSERT INTO quctt_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kawach taq winaq, iwetaꞌm kichꞌobꞌ rij ri kakꞌulmataj cho ri kaj xuqujeꞌ cho ri uwachulew. ¿Jas kꞌu che man kixkwin taj kisol rij ri qꞌotaj ri uj kꞌo wi kamik? ");
INSERT INTO quctt_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Jas che man kichomaj taj ri qas sukꞌ ubꞌanik? ");
INSERT INTO quctt_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","We kꞌo ne jun akꞌulel, ri rumal re kꞌa te cho ri qꞌatbꞌal tzij, chatzukuj jas kabꞌan che utayik toqꞌobꞌ che pa ri bꞌe, rech man katukꞌam ta bꞌik cho ri qꞌatal tzij, riꞌ ri qꞌatal tzij katuya bꞌik puꞌqꞌabꞌ ri katkꞌamow bꞌik pa cheꞌ rech katok kanoq pa cheꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kinbꞌij kꞌu chawe chi we man katoj kan ri kꞌisbꞌal centaw akꞌas, man katel ta la riꞌ chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Xoꞌpan nikꞌaj winaq che ri qꞌij riꞌ, xkitzijoj che ri Jesús chi ri Pilato xuꞌkamisaj nikꞌaj winaq aꞌj Galilea, are tajin kakitzuj ri sipanik pa ri Templo. ");
INSERT INTO quctt_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Xubꞌij kꞌu ri Jesús chike: ¿Teꞌq pa ikꞌuꞌx chi riꞌ ri winaq aꞌj Galilea riꞌ xkiriq kꞌax rumal sibꞌalaj aꞌjmakibꞌ chikiwach konojel ri nikꞌaj winaq chik? ");
INSERT INTO quctt_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Man jeꞌ ta riꞌ, xuqujeꞌ ix kasach na iwach, we man kikꞌex na ikꞌuꞌx. ");
INSERT INTO quctt_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Teꞌq pa ikꞌuꞌx xuqujeꞌ chi ri wajxaq lajuj winaq ri xtzaq loq jun torre chikij pa Siloé xa sibꞌalaj aꞌjmakibꞌ chikiwach ri winaq ri keꞌl pa Jerusalén? ");
INSERT INTO quctt_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Man jeꞌ ta riꞌ. Je xuqujeꞌ kakꞌulmataj iwukꞌ iwonojel we man kikꞌex ikꞌuꞌx. ");
INSERT INTO quctt_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ri Jesús kꞌut xutzijoj chike we jun kꞌambꞌejabꞌal noꞌj: Kꞌo jun achi, ri kꞌo jun ucheꞌal higuera pa ri utikobꞌal. Are kꞌu xraj xuꞌtzukuj uwach ri ucheꞌ, maj xuꞌriqa che. ");
INSERT INTO quctt_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Xubꞌij kꞌu che ri achi ri chajil rech ri utikoꞌn: “Chawilampeꞌ, xeꞌ oxibꞌ junabꞌ maj uwach we higuera kinriqo. Chaqasaj rech man xaq ta kuya latzꞌ pa we ulew.” ");
INSERT INTO quctt_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ri chajil rech ri tikoꞌn xubꞌij: “Ajawxel, ya chi na la kan jun junabꞌ, rech kinkwinik kinbꞌan rij, xuqujeꞌ kinya uqꞌayisal. ");
INSERT INTO quctt_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","We ne kawachin na, we man xwachinik, kꞌa te riꞌ utz kaqasaj la.” ");
INSERT INTO quctt_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Pa jun qꞌij sábado, are tajin kuya kꞌutuꞌn ri Jesús pa Sinagoga, ");
INSERT INTO quctt_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","kꞌo kꞌu jun ixoq chilaꞌ, wajxaq lajuj junabꞌ yawabꞌ, rumal cher jun itzelalaj uxlabꞌal xubꞌan kan bꞌujbꞌik cher ri uwo rachaq, man kakwin ta kꞌut sukꞌum katakꞌiꞌk. ");
INSERT INTO quctt_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Are xilitaj rumal ri Jesús, xusikꞌij xubꞌij che: Ixoq, chatutzir che ri ayabꞌilal. ");
INSERT INTO quctt_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Are xuya ri uqꞌabꞌ ri Jesús puꞌwiꞌ, aninaq sukꞌum xtakꞌiꞌ ri ixoq, xuchapleꞌj uqꞌijilaꞌxik ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ri kinimaꞌqil ri winaq pa ri Sinagoga, xyojtajik are xril ri kunanik xubꞌan ri Jesús pa ri sábado. Xubꞌij chike ri winaq: Kꞌo waqibꞌ qꞌij rech kachakun jun, chixpeta pa riꞌ ri qꞌij riꞌ rech kixkunaxik, man pa ri qꞌij taj rech uxlanem. ");
INSERT INTO quctt_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ri Jesús xubꞌij chike: ¡Kawach taq winaq! ¿la man kitur bꞌik ri iwakax pa ri qꞌij sábado, kiwesaj bꞌik pa ri rachoch rech kuꞌtija loq ujoron? ");
INSERT INTO quctt_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","La man kꞌu yaꞌtalik kesax pa we qꞌij rech uxlanem, ri jatꞌibꞌal ri ukojom ri itzel, wajxaq lajuj junabꞌ che we ixoq riꞌ, rijaꞌl ri Abraham. ");
INSERT INTO quctt_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Xekꞌix ri uꞌkꞌulel ri Jesús are jewaꞌ xubꞌij, e nikꞌaj winaq chi kꞌut xemayijanik are xkil ri mayijabꞌal taq jastaq ri xubꞌano. ");
INSERT INTO quctt_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ri Jesús xubꞌij: ¿Jas rukꞌ kajunumataj wi ri ajawarem rech ri Dios? ¿Jas rukꞌ kinjunamaj wi? ");
INSERT INTO quctt_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Are jeꞌ jas jun ijaꞌ rech moxtansia, ri xutik jun achi pa ri utikobꞌal, xkꞌiy kꞌut, xux jun cheꞌ. Xepe ri aꞌwaj ri kerapinik xkibꞌan kisok pa taq ri uqꞌabꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Xubꞌij chi junmul ri Jesús: ¿Jas rukꞌ kinjunamaj wi ri ajawarem rech ri Dios? ");
INSERT INTO quctt_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Jeꞌ jetaq ri chꞌam ri kaya rukꞌ ri kaxlan wa, ri xuya ri jun ixoq rukꞌ ri kꞌaj, kꞌa xchꞌamir na ronojel. ");
INSERT INTO quctt_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Are xtzalij ri Jesús pa ri tinimit Jerusalén, xuya kan kꞌutuꞌn pa taq ri leꞌaj xuqujeꞌ ri e tinimit ri xikꞌow wi bꞌik. ");
INSERT INTO quctt_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Kꞌo kꞌu jun achi, xuta che: Ajawxel, ¿la xaq e jujun winaq ri kekolotajik? Ri Jesús, xubꞌij che: ");
INSERT INTO quctt_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Chikojo ichuqꞌabꞌ rech kixok pa ri uchiꞌ ja ri nitzꞌ uwach, rumal cher e kꞌi winaq kakaj na koꞌk chilaꞌ man kekwin ta kꞌut. ");
INSERT INTO quctt_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","We kꞌu xtzꞌapitaj ri uchiꞌ ja rumal ri ajchoqꞌe ri ja, kixkanaj na kan chirij ja, kichapleꞌj na kꞌorokꞌatik, kibꞌij na riꞌ: Ajawxel, jaqa la ri uchiꞌ ja chiqawach. Ri ajchoqꞌe kubꞌij na chiꞌwe man wetaꞌm ta iwach. ");
INSERT INTO quctt_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Kibꞌij kꞌu na, “Lal xyoꞌw la kꞌutuꞌn pa taq ri qakꞌayibꞌal, xuqujeꞌ xujwaꞌik xujqumunik ukꞌ la.” ");
INSERT INTO quctt_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kubꞌij kꞌu na chiꞌwe: “Kintzalij ubꞌixik chiꞌwe, man wetaꞌm ta iwach, chixel bꞌik waral bꞌanal taq etzelal.” ");
INSERT INTO quctt_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Kꞌa te riꞌ, kꞌo oqꞌej, xuqujeꞌ qutꞌutꞌem ware, are kiꞌwil ri Abraham, ri Isaac, ri Jacobo xuqujeꞌ konojel ri e qꞌalajisal taq tzij rech ri Dios pa ri ajawarem rech ri Dios, are kꞌu ri ix chixesax bꞌik chirij ja. ");
INSERT INTO quctt_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","E kꞌo kꞌu winaq kepe na pa ri relibꞌal qꞌij, pa ri uqajibꞌal qꞌij, xuqujeꞌ winaq ri keꞌl pa uxukut kaj xuqujeꞌ pa uxukut ulew kuleꞌ tꞌuyul na pa ri nimaqꞌij rech ri ajawarem rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","E kꞌo kꞌu winaq ri e nabꞌe kuꞌx na kꞌisbꞌal xuqujeꞌ e kꞌo xuqujeꞌ na kꞌisbꞌal ri kuꞌx na e nabꞌe. ");
INSERT INTO quctt_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Pa ri qꞌotaj riꞌ xeqet nikꞌaj fariseos rukꞌ ri Jesús, xkibꞌij che: Ri Herodes karaj katukamisaj, chatel bꞌik waral jat chi pa jun kꞌolibꞌal. ");
INSERT INTO quctt_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Xubꞌij kꞌu ri Jesús chike: Jix jiꞌbꞌij apanoq che ri par riꞌ, kamik xuqujeꞌ chweꞌq keꞌnwesaj na itzel taq uxlabꞌal xuqujeꞌ keꞌnkunaj na ri winaq, pa oxibꞌ qꞌij kintoꞌtaj chubꞌanik ri rajawaxik kinbꞌano. ");
INSERT INTO quctt_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Rajawaxik kinbꞌin na kamik, chweꞌq, xuqujeꞌ kabꞌij, rumal man yaꞌtal ta che jun qꞌalajisal utzij ri Dios kakam chi pa jun tinimit chik ri man are ta Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","¡Tinimit Jerusalén! ¡Tinimit Jerusalén! At ri kaꞌkamisaj ri qꞌalajisal taq rech ri utzij ri Dios xuqujeꞌ kabꞌan che abꞌaj ri ketaq loq awukꞌ. ¡Kꞌi mul xwaj xeꞌnmulij ri awalkꞌwaꞌl jetaq ri kubꞌan ri atiꞌt akꞌ kuꞌmulij ri alaj taq e ral chuxeꞌ ri uxikꞌ, man xawaj ta kꞌut! ");
INSERT INTO quctt_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Rumal kꞌu riꞌ, ri iꞌwachoch ketoliꞌ na kanoq, man kiwil ta kꞌu na nuwach kꞌa pa ri qꞌij ri kibꞌij: “Tewchiꞌtal ri ubꞌiꞌ ri petinaq pa ri ubꞌiꞌ ri Ajawxel.” ");
INSERT INTO quctt_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Jun qꞌij rech uxlanem, ri Jesús xeꞌwoꞌk cho rachoch jun kinimaꞌqil ri fariseo, e kꞌo chi kꞌu nikꞌaj fariseos ri tajin kakiwalwechij ri jastaq ri kubꞌan ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Jun achi kꞌut ri kꞌo sipoj che kꞌo chilaꞌ cho ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ri Jesús kꞌut xuta chike ri aꞌjtijabꞌ rech ri taqanik xuqujeꞌ ri fariseos. ¿La yaꞌtalik kabꞌan kunanik pa ri qꞌij rech uxlanem? ");
INSERT INTO quctt_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Maj kꞌu jun xchꞌawik chike ri e kꞌo chilaꞌ. Ri Jesús kꞌut xukꞌam apanoq ri yawabꞌ, xukunaj bꞌik, kꞌa te riꞌ xutaq bꞌik cho rachoch. ");
INSERT INTO quctt_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Xubꞌij xuqujeꞌ: We kꞌo jun chiꞌwe kꞌo jun ukꞌojol o wine kꞌo jun uwakax ri katzaq bꞌik pa jun jul, ¿la man aninaq keꞌresaj loq pune jun qꞌij rech uxlanem? ");
INSERT INTO quctt_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Maj kꞌu jas xekwinik xkibꞌij che. ");
INSERT INTO quctt_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Are xril ri Jesús jas ri kakibꞌan ri winaq ri e sikꞌital pa ri waꞌim chuchaꞌik ri sibꞌalaj utz taq kꞌolibꞌal chwi ri mexa, xutzijoj we jun kꞌambꞌejabꞌal noꞌj. ");
INSERT INTO quctt_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Are katsikꞌix pa jun nimaqꞌij rech kꞌulanem, man kattꞌuyiꞌ taj pa ri sibꞌalaj jeꞌl laj kꞌolibꞌal ri nim ubꞌantajik rumal cher rukꞌ jubꞌiqꞌ kꞌo chi na jun winaq sikꞌitalik ri sibꞌalaj kꞌo na uqꞌij chawach ri sikꞌitalik. ");
INSERT INTO quctt_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","We jeriꞌ, kape riꞌ ri winaq ri xixsikꞌinik kubꞌij na chawe: “Chaya kan le atꞌuyulibꞌal che we achi riꞌ rukꞌ kꞌu kꞌixibꞌal riꞌ kateꞌ tꞌuyul pa ri kꞌisbꞌal tem.” ");
INSERT INTO quctt_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Are katsikꞌixik pa jun nimaqꞌij, are utz we kattꞌuyiꞌ kan pa ri kꞌisbꞌal tem, rech are katril ri winaq ri xatsikꞌinik kubꞌij chawe: “Wech chꞌabꞌeꞌn chatqꞌax choch, kꞌo jun jeꞌl laj atꞌuyulibꞌal xaq awe at.” Xa jeriꞌ kanimarisax na aqꞌij chikiwach konojel ri e sikꞌitalik. ");
INSERT INTO quctt_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Xapachin kꞌu ri kunimarisaj ribꞌ kanitzꞌarisax na uqꞌij, xuqujeꞌ xapachin ri kunitzꞌarisaj na ribꞌ kanimarisax na uqꞌij. ");
INSERT INTO quctt_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kꞌa te riꞌ xubꞌij ri Jesús che ri winaq ri sikꞌininaq: Are kabꞌan jun tzuquꞌnijik o kaya ne jun rekeqꞌij, man are ta kaꞌsikꞌij ri awech chꞌabꞌeꞌn, xuqujeꞌ man are ta kaꞌsikꞌij ri awachalal, man are ta kaꞌsikꞌij ri uqꞌabꞌ taq alaxik awukꞌ, xuqujeꞌ man are ta kaꞌsikꞌij ri e qꞌinom taq aꞌkꞌulja. Rukꞌ jubꞌiqꞌ katsikꞌix chi kumal aꞌreꞌ kakitzalij la ukꞌaxel chawe. ");
INSERT INTO quctt_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Xane are kabꞌan nimaqꞌij, chaꞌsikꞌij ri e mebꞌaibꞌ, ri man e tzꞌaqat winaq taj, ri e chꞌokeꞌr, xuqujeꞌ e moyabꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Utz kꞌu na awe we jeriꞌ kabꞌano, pune man kekwin taj katkitoj we winaq riꞌ chawe, kayaꞌtaj kꞌu na rajilal ukꞌaxelal chawe pa ri kꞌastajibꞌal ke ri e sukꞌ taq winaq. ");
INSERT INTO quctt_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Are xutabꞌej rech ri jun achi ri tꞌuyul puꞌwiꞌ ri mexa, xubꞌij che ri Jesús: Sibꞌalaj utz rech ri kawaꞌ pa ri nimaqꞌij rech ri ajawarem rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ri Jesús xubꞌij: Jun qꞌijal, kꞌo jun achi ri xuꞌsikꞌij sibꞌalaj e kꞌi winaq, xubꞌan kꞌut jun nimalaj nimaqꞌij. ");
INSERT INTO quctt_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Pa ri qꞌotaj rech ri nimaqꞌij, xutaq bꞌik jun chike ri e patanil rech, xeꞌkibꞌij chike ri sikꞌital pa ri nimaqꞌij: “Ronojel xutzirik, chixanloq.” ");
INSERT INTO quctt_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Konojel kꞌut xok chutayik toqꞌobꞌ, ri nabꞌe xubꞌij, chakuyu numak, xa kꞌa te xinloqꞌ jubꞌiqꞌ wulew keꞌnwila kꞌu na, ");
INSERT INTO quctt_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ri jun chik xubꞌij, chakuyu numak xa kꞌa te xinloqꞌ e jobꞌ wok nuwakax rech chak, kubꞌeꞌn wi la na jas kechakunik. ");
INSERT INTO quctt_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ri jun chik xubꞌij: Xa kꞌa te xinkꞌuliꞌk rumal riꞌ man kinkwin taj kineꞌek. ");
INSERT INTO quctt_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Xtzalij kꞌu ri ajchak xuꞌtzaqa utaqkil che ri rajaw. Are xutabꞌej rech ri ajchoqꞌe ri ja xyojtajik, xusikꞌij kꞌu ri patanil rech xubꞌij che: Jat aninaq pa taq ri kꞌayibꞌal xuqujeꞌ xoꞌl taq ri ja, ja bꞌa kꞌamaloq ri e mebꞌaibꞌ xuqujeꞌ ri man e tzꞌaqat taq winaq taj, ri maj kaqꞌan, xuqujeꞌ ri e moy. ");
INSERT INTO quctt_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ri patanijel xubꞌij che ri rajaw: Xbꞌantaj ri xbꞌij la chwe, kꞌa kꞌo kꞌu na kꞌolibꞌal. ");
INSERT INTO quctt_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ri rajaw xubꞌij che: Jat pa ri nima bꞌe xuqujeꞌ pa taq ri solibꞌal taq bꞌe, chakojo achuqꞌabꞌ, chikimulixik loq ri winaq rech kanoj ri wachoch. ");
INSERT INTO quctt_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Qas kinbꞌij na chiꞌwe, maj jun chike riꞌ ri qas xeꞌnsikꞌij kakikiꞌkotebꞌej ri nunimaqꞌij. ");
INSERT INTO quctt_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ri Jesús kꞌut xtzalqꞌomij kukꞌ ri e sibꞌalaj kꞌi winaq ri e teren chirij xubꞌij chike: ");
INSERT INTO quctt_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","We kꞌu kꞌo jun ri karaj kuxik nutijoxel rajawaxik kꞌo na ri kubꞌan chinuloqꞌaxik chikiwach ri unan, rixoqil, e ralkꞌwaꞌl, e rachalal, ranabꞌ, xuqujeꞌ kinuloqꞌaj na in cho areꞌ. We man jewaꞌ kanoꞌjin ri winaq, man kakwin taj kux nutijoxel. ");
INSERT INTO quctt_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ri man kareqaj ta ri ucheꞌ ripbꞌal xuqujeꞌ man kinutereneꞌj taj, man kakwin taj kuxik nutijoxel. ");
INSERT INTO quctt_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Qaꞌnampe che, kꞌo jun achi ri karaj kuyak jun nimalaj torre. ¿La man nabꞌe katꞌuyiꞌk chi rilik janipa kel wi ri kubꞌano, xuqujeꞌ we kꞌo nim urajil chukꞌisik ri chak? ");
INSERT INTO quctt_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Xaq kayoqꞌ riꞌ kumal konojel ri winaq ri kiꞌlowik we xwi kubꞌan ri utakꞌalibꞌal ri ja, man xkwin taj xukꞌiso. ");
INSERT INTO quctt_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Man xkwin ta le kꞌin achi chukꞌisik ri xumajij,” kecha riꞌ ri winaq che. ");
INSERT INTO quctt_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Xuqujeꞌ qaꞌnampe che kꞌo jun taqanel kachꞌoꞌjin rukꞌ jun taqanel chik. ¿La man nabꞌe riꞌ katꞌuyiꞌ chi rilik la rukꞌ lajuj mil achyabꞌ kakwinik kachꞌoꞌjin rukꞌ ri ukꞌamom loq juwinaq mil achyabꞌ? ");
INSERT INTO quctt_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kutaq bꞌik uꞌtaqoꞌn riꞌ rech keꞌkita jaꞌmaril che riꞌ ri taqanel are naj petinaq wi na, we karilo chi man kakwin taj kachꞌoꞌjin rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Je xuqujeꞌ xapachin ri man kuya ta kan ronojel ri uqꞌinomal, man kakwin taj kux nutijoxel. ");
INSERT INTO quctt_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Sibꞌalaj utz ri atzꞌam, we kꞌu kel ri utzayil ri atzꞌam, ¿la xaq jeꞌ kꞌu riꞌ utz na kanoꞌwik? ");
INSERT INTO quctt_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Man kꞌo ta chi ne riꞌ kutayij, xa ta ne che ri ulew, xa ta ne che uqꞌayisal tikoꞌn, kakꞌyaq bꞌik riꞌ pa mes. Chutatabꞌej bꞌa ri kꞌo uxikin chutatabꞌexik. ");
INSERT INTO quctt_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","E kꞌi kꞌu aꞌjmakibꞌ xuqujeꞌ e tal taq alkabal xeqet rukꞌ ri Jesús chutatabꞌexik. ");
INSERT INTO quctt_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Rumal riꞌ ri e fariseos xuqujeꞌ ri aꞌjtijabꞌ rech ri taqanik xkichapleꞌj wixwatem xkibꞌij: Waꞌ we achi riꞌ kuꞌkꞌamawaꞌj xuqujeꞌ kawaꞌ kukꞌ ri aꞌjmakibꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ri Jesús kꞌut xutzijoj we jun kꞌambꞌejabꞌal noꞌj riꞌ chike: ");
INSERT INTO quctt_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Qaꞌnampe che jun chiꞌwe e kꞌo jun ciento uchij, kasach kꞌu kan jun chike. ¿La man kꞌu kuꞌya kan ri junmuchꞌ bꞌelej lajuj cho ri saq, kꞌa te riꞌ katzalij chutzukuxik ri xsach kanoq, kꞌa kuꞌriqa na loq? ");
INSERT INTO quctt_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Are kuriq ri uchij sibꞌalaj kakiꞌkotik, kukꞌyaq loq chwi utelebꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Katzalij loq cho ri rachoch, kuꞌmulij ri e rech taq chꞌabꞌeꞌn xuqujeꞌ ri uꞌkꞌulja ja kubꞌij chike: “Chixkiꞌkot wukꞌ, rumal xinriq ri nuchij ri xsach kanoq.” ");
INSERT INTO quctt_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Je xuqujeꞌ kakꞌulmataj pa ri kaj kabꞌan nimaqꞌij rumal jun ajmak ri kukꞌex ukꞌuꞌx man are ta kabꞌan nimaqꞌij chike ri junmuchꞌ bꞌelej lajuj e sukꞌ taq winaq ri man kajawataj kakikꞌex kikꞌuꞌx. ");
INSERT INTO quctt_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Xuqujeꞌ qaꞌnampe che we kꞌo jun ixoq ri kꞌo lajuj saqa pwaq rukꞌ, kutzaq kꞌu jun chike, ¿la man kꞌu kutzij jun qꞌaqꞌ riꞌ pa ri ja, xuqujeꞌ kumes ri upaja, kuchapleꞌj utzukuxik kꞌa kuriq na? ");
INSERT INTO quctt_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Are kꞌu kuriqo, kuꞌmulij kꞌu ronojel ri e rech taq chꞌabꞌeꞌn xuqujeꞌ ri uꞌkꞌulja are, kubꞌij riꞌ chike: “Chixkiꞌkot wukꞌ xinriq le nurajil le xtzaqik.” ");
INSERT INTO quctt_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ri Dios xuqujeꞌ e rachiꞌl ri angelibꞌ kekiꞌkotik are kukꞌex ukꞌuꞌx ri jun ajmak. ");
INSERT INTO quctt_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ri Jesús xubꞌij: Kꞌo jun achi, ri e kꞌo kebꞌ ralkꞌwaꞌl. ");
INSERT INTO quctt_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ri koꞌl chike xubꞌij che ri utat: “Tat, ya la ri wechabꞌal.” Xaq jeriꞌ ri tat xujach ri umebꞌail chike ri uꞌkꞌojol. ");
INSERT INTO quctt_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Are xikꞌow kebꞌ oxibꞌ qꞌij, ri kꞌojolaxel xumulij ronojel ri kꞌo rukꞌ, xukꞌayij kanoq. Kꞌa te riꞌ xeꞌ pa jun naj alaj tinimit, chilaꞌ xkꞌojiꞌ wi, xusachachej ronojel ri pwaq rajil ri rechabꞌal, maj pa sukꞌ ri xubꞌano. ");
INSERT INTO quctt_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Xa kꞌu are xsachtaj ronojel ri urajil, xpe jun nimalaj wiꞌjal pa ri tinimit riꞌ, xuchapleꞌj kꞌu numik. ");
INSERT INTO quctt_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Xuriq kꞌu jun achi, xuta uchak che. Ri achi xuya uchak ri ala, xutaq bꞌik chikiyuqꞌuxik aq cho jun saq. ");
INSERT INTO quctt_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Sibꞌalaj are kꞌu karaj kutij ri kechaꞌ ri aq, xa kꞌu maj jachin ri kayoꞌw che. ");
INSERT INTO quctt_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kꞌisbꞌal kꞌu rech xuchomaj: “Sibꞌalaj kꞌo kiwa ri rajchak ri nutat, ri in kꞌut tajin kinkam che numik waral. ");
INSERT INTO quctt_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Kintzalij waꞌ cho rachoch ri nutat, kinbꞌij waꞌ che: ‘Xinmakun cho ri Dios xuqujeꞌ cho la nutat. ");
INSERT INTO quctt_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Man taqal ta chi chwe kabꞌij kꞌojol la chwe, bꞌana la chi kinux jun ajchak la.’ ” ");
INSERT INTO quctt_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Xwaꞌjilik, xutaqej ri ubꞌe, xtzalij kꞌu cho rachoch ri utat. Kꞌanaj kꞌu na kꞌo wi loq, xtoqꞌobꞌax uwach are xilitaj apanoq rumal ri utat, kaxikꞌanik xuꞌkꞌulaj apanoq, xumatzej ri ukꞌojol xuqujeꞌ xutzꞌumaj. ");
INSERT INTO quctt_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Tat, ri in xinmakunik cho ri kaj xuqujeꞌ cho la, taqal ta chi chwe kabꞌij kꞌojol la chwe,” xcha ri ala. ");
INSERT INTO quctt_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Are kꞌu ri tataxel aninaq xtaqan chike ri e patanil taq rech, xubꞌij: “Aninaq chikꞌama loq ri jeꞌl laj atzꞌyaq rech kukojo, xuqujeꞌ chikojo jun mulqꞌabꞌ che ri uqꞌabꞌ, xuqujeꞌ chikojo uxajabꞌ che ri raqan. ");
INSERT INTO quctt_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Jiꞌkꞌama loq xuqujeꞌ chikamisaj ri chomalaj wakax rech kaqabꞌan nimaqꞌij. ");
INSERT INTO quctt_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Rumal cher ri nukꞌojol ri xkamik, xkꞌastaj chi kꞌu na loq, waꞌ sachik, xa kꞌu xqariq na.” Xaq jeriꞌ xkichapleꞌj ubꞌanik nimaqꞌij. ");
INSERT INTO quctt_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Are kꞌu ri nabꞌyal kꞌojolaxel bꞌenaq cho ri saq, are kꞌu xtzalij loq xuta ri qꞌojom rech ri xojow. ");
INSERT INTO quctt_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Xusikꞌij kꞌu jun chike ri patanijelabꞌ, xuta che jas tajin kakꞌulmatajik. ");
INSERT INTO quctt_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Xubꞌij kꞌu ri patanijel che: “Xtzalij loq ri achaqꞌ, utz uwach, rumal kꞌu rech xtaqan ri atat chukamisaxik ri chomalaj wakax.” ");
INSERT INTO quctt_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Sibꞌalaj xyakataj kꞌu royawal ri nabꞌyal kꞌojolaxel man xraj ta kꞌut xok bꞌik, xel kꞌu na loq ri tataxel chutayik toqꞌobꞌ che chi kok bꞌik pa ja. ");
INSERT INTO quctt_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ri nabꞌyal kꞌojolaxel xubꞌij che ri utat: “Xwimpe chilaꞌ la sibꞌalaj kꞌi junabꞌ nupatanim la, xa ta ne nitzꞌ inkꞌululaꞌninaq che la, xa ta kꞌu ne jun laj nukꞌisikꞌ yaꞌom la chwe rech kinbꞌan nimaqꞌij kukꞌ ri e wech taq chꞌabꞌeꞌn. ");
INSERT INTO quctt_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Are kꞌu xul we kꞌojol la riꞌ, ri xusach kan ronojel ri qꞌinomal la kukꞌ taq ixoqibꞌ, lal kataqan la che ukamisaxik ri chom laj wakax.” ");
INSERT INTO quctt_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ri tataxel xubꞌij che: “Nukꞌojol, at kꞌolinaq wi at wukꞌ, ronojel ri nujastaq awe at. ");
INSERT INTO quctt_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Xa kꞌu rajawaxik xqabꞌan nimaqꞌij, xuqujeꞌ xujkiꞌkotik rumal cher we awachalal we xkamik, xkꞌastaj loq, pune xsach na, xqariq chi kꞌu na.” ");
INSERT INTO quctt_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ri Jesús xuqujeꞌ xutzijoj jun kꞌambꞌejabꞌal noꞌj chike ri utijoxelabꞌ: Kꞌo jun qꞌinom achi, ri xkꞌojiꞌk jun rajchak chajil re ri uqꞌinomal. Ri qꞌinom achi xretaꞌmaj chi ri rajchak xaq tajin kusach ri urajil pa taq jastaq ri man kꞌo ta kutayij. ");
INSERT INTO quctt_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ri qꞌinom achi xusikꞌij ri rajchak, xubꞌij che: “¿Jas riꞌ ri xinto kabꞌix chawe? Man katkwin ta chik katchakun wukꞌ, chajacha kan ronojel ri akwenta.” ");
INSERT INTO quctt_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ri ajchak xuchomaj, xubꞌij: “¿Jas kinbꞌano? Maj nuchuqꞌabꞌ chukꞌotik jul, xuqujeꞌ kꞌixibꞌal riꞌ we kinta nulimoxna. ");
INSERT INTO quctt_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Wetaꞌm kꞌut jas ri kinbꞌano, rajawaxik keꞌntzukuj winaq ri kinkikꞌamawaꞌj cho taq ri kachoch are kinesax bꞌik pa ri nuchak.” ");
INSERT INTO quctt_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Xuchapleꞌj kꞌu kisikꞌixik pa jujunal konojel ri winaq ri kꞌo kikꞌas. Xuta kꞌu che ri nabꞌe: “¿Janipa akꞌas rukꞌ ri wajaw?” ");
INSERT INTO quctt_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Xubꞌij ri ajkꞌas che: “Jun ciento tonel aceite olivo nukꞌas.” Xubꞌij kꞌu ri kabꞌan rech puꞌwiꞌ ronojel ri jastaq che: “Riꞌ le uwujil ri akꞌas. Chattꞌuyuloq, chatzꞌibꞌaj kanoq chi xa nikꞌaj ciento chik akꞌas.” ");
INSERT INTO quctt_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Xuta chi kꞌu che ri jun e ri at: “¿Janipa akꞌas rukꞌ ri wajaw?” Ri ajkꞌas xubꞌij che: “Jun ciento koxtar tiriko.” Ri kabꞌan rech puꞌwiꞌ ronojel ri jastaq xubꞌij che: “Riꞌ le awuj, chatzꞌibꞌaj kanoq xa chi wajxaqibꞌ koxtar tiriko akꞌas.” ");
INSERT INTO quctt_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Xya kꞌu uqꞌij ri ajchak rumal ri rajaw rumal ri xnoꞌjin kukꞌ ri winaq. Ri e winaq ri aꞌjuwachulew are kꞌo na kinoꞌjibꞌal rumal ri kakibꞌan kukꞌ taq ri e kech winaq, kꞌo na ri kechoman chikiwach ri e winaq ri kikꞌamawaꞌm ri tunal. ");
INSERT INTO quctt_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Rumal laꞌ kinbꞌij in chiꞌwe: Chikojo bꞌa ri iqꞌinomal rech uwachulew chikichꞌekik iwach taq chꞌabꞌeꞌn, rech are kakꞌis waꞌ we qꞌinomal riꞌ, kꞌo kixkꞌamawaꞌn ix pa ri jun alik kꞌaslemal. ");
INSERT INTO quctt_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ri sukꞌ ranimaꞌ rukꞌ ri nitzꞌ jastaq, sukꞌ xuqujeꞌ na riꞌ rukꞌ ri nimaꞌq taj jastaq, xuqujeꞌ ri tzꞌaqat rukꞌ ri nitzꞌ jastaq, tzꞌaqat xuqujeꞌ na riꞌ kanoꞌjin rukꞌ ri nimalaj taq jastaq. ");
INSERT INTO quctt_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Rumal laꞌ kinbꞌij chiꞌwe, we man sukꞌ kixnoꞌjin chukojik ri qꞌinomal rech uwachulew, ¿jachin ta kꞌu riꞌ ri kakubꞌiꞌ ukꞌuꞌx chiꞌwe che uchajixik ri qꞌinomal rech chikajil? ");
INSERT INTO quctt_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Xuqujeꞌ we man sukꞌ ix noꞌjininaq rukꞌ ri man iwech taj ¿jachin ta kꞌu riꞌ ri kayoꞌw iwechabꞌal? ");
INSERT INTO quctt_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Man kꞌo ta jun patanijel kakwinik kuꞌpatanij e kebꞌ upatrón. Karetzelaj uwach ri jun, xuqujeꞌ kuloqꞌaj uwach jun chik, o wine kupatanij riꞌ ri jun xa kꞌu karetzelaj uwach ri jun chik. Man yaꞌtal ta kꞌut kapatanix ri qꞌinomal xuqujeꞌ ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Xkichapleꞌj uyoqꞌik ri Jesús ri fariseos, ri bꞌenaq kikꞌuꞌx rukꞌ ri pwaq are xkitatabꞌej ri xubꞌij. ");
INSERT INTO quctt_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Xubꞌij kꞌu ri Jesús chike: Kijaluj chi ix utz taq winaq, xa kꞌu retaꞌm ri iwanimaꞌ ri Dios. Naꞌtaj chiꞌwe karetzelaj ri Dios ri jastaq sibꞌalaj kakiya uqꞌij ri winaq. ");
INSERT INTO quctt_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ri taqanik xuqujeꞌ ri kiwuj ri qꞌalajisal taq utzij ri Dios xul utzijoxik kꞌa pa taq ri uqꞌij ri Juan. Che riꞌ xchapleꞌtaj loq utzijoxik ri utz laj taq tzij rech ri ajawarem rech ri Dios xuqujeꞌ che ri qꞌij xkichapleꞌj ri winaq ukojik kichuqꞌabꞌ koꞌk chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Are man kꞌax taj usachik uwach ri kaj xuqujeꞌ ri uwachulew cho ri kasach jun juchꞌ rech ri taqanik. ");
INSERT INTO quctt_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Xapachin ri kujach ri rixoqil, kakꞌuliꞌ chi kꞌu rukꞌ jun ixoq chik, kamakunik rumal kekꞌojiꞌ kebꞌ rixoqil. Xuqujeꞌ ri kakꞌuliꞌ rukꞌ ri ixoq ri jachtal kanoq rumal ri rachajil, kamakun xuqujeꞌ rumal kekꞌojiꞌ e kebꞌ rachajil. ");
INSERT INTO quctt_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Kꞌo jun qꞌinomalaj achi, kukoj jeꞌlalaj taq atzꞌyaq xuqujeꞌ ronojel qꞌij kubꞌan nimaqꞌij. ");
INSERT INTO quctt_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Chuchiꞌ kꞌu ri rachoch, katꞌuyiꞌ jun achi ubꞌiꞌ Lázaro, nojinaq ri utyoꞌjal che chꞌaꞌk xuqujeꞌ kuta ulimoxna. ");
INSERT INTO quctt_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ri mebꞌaꞌ kurayij utijik ri uxeꞌr taq jastaq ri katzaq chuxeꞌ ri umexa ri qꞌinom achi, xuqujeꞌ ri tzꞌiꞌ keqebꞌ churiqꞌik ri chꞌaꞌk ri kꞌo che. ");
INSERT INTO quctt_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Jas ta waꞌ, xkꞌam bꞌi ri mebꞌaꞌ achi kumal e angelibꞌ rech keꞌkꞌol chuxukut ri Abraham. Ri qꞌinom achi xkam xuqujeꞌ xeꞌmuq kanoq. ");
INSERT INTO quctt_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Are kꞌo chi ri qꞌinom achi pa ri kikꞌolibꞌal ri kaminaqibꞌ jawjeꞌ ri kꞌo wi nimalaj kꞌaxkꞌolal, are kꞌo pa ri kꞌaxkꞌolal, xkaꞌy chikaj, xeꞌril apanoq ri Abraham rachiꞌl ri Lázaro naj e kꞌo wi apanoq che. ");
INSERT INTO quctt_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Xaq jeriꞌ xuchꞌabꞌej apanoq, xuraq uchiꞌ xubꞌij: “Tataxel Abraham, chel kuꞌx la chwe, taqa la loq ri Lázaro chumuꞌloq ri uwiꞌ uqꞌabꞌ pa joron, rech kuluya puꞌwiꞌ ri waqꞌ rumal cher tajin kinriq kꞌax pa we qꞌaqꞌ riꞌ.” ");
INSERT INTO quctt_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ri Abraham kꞌut xubꞌij che: “Achi, naꞌtaj chawe chi are at kꞌaslik sibꞌalaj jeꞌl xabꞌan chi rikꞌowisaxik ronojel ri akꞌaslemal, are kꞌu we Lázaro sibꞌalaj kꞌax xuriqo. Chanim kꞌut areꞌ kukꞌamawaꞌj na ri kubꞌsabꞌal ukꞌuꞌx areꞌ, are kꞌu ri at chanaꞌ na ri kꞌaxkꞌolal. ");
INSERT INTO quctt_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Xuqujeꞌ jun nimalaj siwan kꞌo chiqaxoꞌl, rumal riꞌ ri kekaj keqꞌax je laꞌ iwukꞌ man kekwin taj, xuqujeꞌ man kekwin taj keqꞌax loq jewaꞌ qukꞌ uj.” ");
INSERT INTO quctt_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ri qꞌinom xutzalij uwach ri xbꞌix che, xubꞌij: Tat, kinbꞌochiꞌj kuꞌx la, taqa la bꞌik ri Lázaro cho rachoch ri nutat, ");
INSERT INTO quctt_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","rech kuꞌbꞌij chike ri e jobꞌ wachalal, rech man kepe ta pa we kꞌaxalaj kꞌolibꞌal riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Xubꞌij kꞌu ri Abraham che: “Kꞌo kukꞌ aꞌreꞌ ri utzꞌibꞌam kan ri Moisés, xuqujeꞌ ri kitzꞌibꞌam kan ri e qꞌalajisal taq rech ri utzij ri Dios, are cheꞌkitatabꞌej ri aꞌreꞌ.” ");
INSERT INTO quctt_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Xubꞌij kꞌu ri qꞌinom: “Tat Abraham, man keꞌkitatabꞌej ta riꞌ, are kakitatabꞌej riꞌ xuqujeꞌ kakikꞌex kanimaꞌ we are kopan jun kaminaq chubꞌixik chike.” ");
INSERT INTO quctt_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Xubꞌij ri Abraham che: “We man kakinimaj ri Moisés, we man keꞌkinimaj ri e qꞌalajisal taq rech ri utzij ri Dios, man kekojon ta wi riꞌ pune jun kaminaq kawaꞌjil bꞌik chubꞌixik chike.” ");
INSERT INTO quctt_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Xubꞌij ri Jesús chike ri utijoxelabꞌ: Xa chi kꞌo wi laꞌ le topibꞌal taq aqanaj, kꞌax kꞌu re ri winaq ri rumal rech katzaq jun chik. ");
INSERT INTO quctt_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Are katanik kajatꞌix bꞌik jun kꞌa chuqul kakꞌyaq bꞌik pa ri plo, cho ri xaq kuꞌtaqchiꞌj ri alaj taq e chꞌutiꞌn chubꞌanik makaj. ");
INSERT INTO quctt_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Xaq jeriꞌ chichajij iwibꞌ, we kamakun ri awachalal, chayaja apanoq xuqujeꞌ chakuyu we kukꞌex ukꞌuꞌx. ");
INSERT INTO quctt_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Pune kasach apanoq awukꞌ wuqubꞌ mul pa jun qꞌij, Chakuyu umak we kopan awukꞌ kubꞌij chawe: Kinkꞌex nukꞌuꞌx chinakuyuꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ri apóstoles kꞌut xkibꞌij che ri Jesús: Tat, nimarisaj la ri qakojobꞌal. ");
INSERT INTO quctt_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ri Jesús kꞌut xubꞌij chike: We ta kꞌo jun ikojobꞌal jetaq ri uwach ri moxtansia, riꞌ kixunimaj jun cheꞌ we kibꞌij che chatbꞌoqobꞌobꞌ bꞌik chatqꞌax pa le plo. ");
INSERT INTO quctt_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Qaꞌnampe che, we jun chiꞌwe kꞌo jun rajchak ri xchakun apanoq cho ri saq, o wine xuꞌchajij ri chij, are kꞌu katzalij cho ri ja la kibꞌij che: “chatan loq chattꞌuyul puꞌwiꞌ le mexa” ¿la kixcha che? ");
INSERT INTO quctt_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","¿La man kꞌu jewaꞌ kibꞌij che: “chakꞌexa ri awatzꞌyaq, chabꞌana nuwa, kꞌa te katwaꞌ kan at are kinwalej in”? ");
INSERT INTO quctt_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿La utz kꞌu riꞌ katyoxix na che ri ajchak xwi rumal xubꞌano ri upatan? ");
INSERT INTO quctt_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ri ix are xbꞌantaj ronojel ri ipatan chibꞌij: “Uj patanijelabꞌ ri maj kaqatayij, xaq xwi xujkwinik xqabꞌan ri qapatan.” ");
INSERT INTO quctt_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jun qꞌijal bꞌenam rij ri Jesús pa ri tinimit Jerusalén, tajin kꞌu kiꞌkow bꞌik pa ri tinimit Samaria xuqujeꞌ pa Galilea. ");
INSERT INTO quctt_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Okem kꞌu bꞌik rij pa ri jun tinimit, xeꞌl loq e lajuj achyabꞌ e chꞌaꞌkibꞌ, rumal kꞌu cher naj e kꞌo wi loq. ");
INSERT INTO quctt_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Xkiraq kichiꞌ xkibꞌij: Ajtij, Jesús, cheꞌl kuꞌx la chaqe. ");
INSERT INTO quctt_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Are xeꞌrilo, xubꞌij chike: Jix, jiꞌkꞌutu iwibꞌ chkiwach ri chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq. E bꞌenaq kꞌu pa ri bꞌe are xechꞌajchꞌobꞌetajik. ");
INSERT INTO quctt_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Are kꞌu xril jun chike ri achyabꞌ chi xutzirik, xtzalijik kuraqaqej uchiꞌ kuqꞌijilaꞌj ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Xukulik xqaj cho ri Jesús, xtyoxin che, pune aj Samaria we achi riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Xubꞌij kꞌu ri Jesús che: ¿La man kꞌu e lajuj achyabꞌ ri xechꞌajchꞌobꞌetajik? ¿Jawjeꞌ kꞌu e kꞌo wi ri e bꞌelejebꞌ chik? ");
INSERT INTO quctt_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿La maj chi jun ri xtzalij loq chuyaꞌik uqꞌij ri Dios, la xaq xwi we achi ri man qawinaqil taj? ");
INSERT INTO quctt_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Xubꞌij kꞌu ri Jesús che ri achi: Chatwaꞌjiloq, jat, xatkunataj rumal ri akojobꞌal. ");
INSERT INTO quctt_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ri e fariseos xkita che ri Jesús chirij ri upetibꞌal ri ajawarem rech ri Dios, xubꞌij kꞌu chike: Maj jun kakwinik qas kuchomaj jas ri qas upetibꞌal ri ajawarem rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Man kibꞌij taj: “Chiwilampeꞌ, chi riꞌ kꞌo wi, chiwilampeꞌ, je laꞌ kꞌo wi”. Chiwilaꞌ chi pa ri iwanimaꞌ kꞌo wi ri ajawarem rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Xubꞌij kꞌu ri Jesús chike ri utijoxelabꞌ: Kopan na ri qꞌij ri sibꞌalaj kirayij kiwil ri uqꞌijal ri uKꞌojol ri Achi, man kiwil ta kꞌut. ");
INSERT INTO quctt_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Man kixeꞌ ta kꞌu kukꞌ xuqujeꞌ man kiꞌtereneꞌj taj ri winaq riꞌ kakibꞌij na chiꞌwe: “Jiꞌwilampeꞌ kꞌo jewaꞌ, chiwilampeꞌ kꞌo chi riꞌ.” ");
INSERT INTO quctt_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Rumal chi ri uqꞌijal ri upetibꞌal ri uKꞌojol ri Achi, jeꞌ jas ri kayapaꞌ ri karepqꞌun chuxukut kaj kaqaj chuxukut ulew. ");
INSERT INTO quctt_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Xa kꞌu nabꞌe na kuriq na kꞌax xuqujeꞌ ketzelax na uwach kumal ri winaq rech we qꞌij junabꞌ riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ri upetibꞌal ri uKꞌojol ri Achi, jeꞌ jas ri xkꞌulmataj pa taq ri uqꞌij ri Noé. ");
INSERT INTO quctt_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ri winaq kewaꞌik, kequmunik, kekꞌuliꞌ taq xuqujeꞌ keya pa taq kꞌulanem, kꞌa xopan na ri qꞌij are xok ri Noé pa ri arca, xpe kꞌu ri qꞌeqal jabꞌ, xuꞌkamisaj kan konojel ri winaq. ");
INSERT INTO quctt_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Je xuqujeꞌ xkꞌulmatajik pa taq ri qꞌij rech riꞌ Lot: ri winaq kewaꞌik, kequmunik, keloqꞌoꞌmanik, xuqujeꞌ kekꞌayinik, ketikoꞌnijik xuqujeꞌ kakiyak taj ja. ");
INSERT INTO quctt_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Xa kꞌu are xuriq ri qꞌij ri xel bꞌik ri Lot pa ri tinimit Sodoma, xtzaq loq qꞌaqꞌ rech chikajil xuqujeꞌ azufre, xukꞌis pa kiwiꞌ konojel ri winaq. ");
INSERT INTO quctt_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Jeriꞌ kakꞌulmataj na are kukꞌut ribꞌ ri uKꞌojol ri Achi. ");
INSERT INTO quctt_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Pa ri qꞌij riꞌ, ri winaq ri kꞌo puꞌwiꞌ ri rachoch, maqaj bꞌik chutzukuxik ri ujastaq ri kꞌo kan pa ri rachoch, je xuqujeꞌ ri tajin kachakun cho ri saq, matzalij chukꞌamik ri man xnaꞌtaj ta bꞌik che. ");
INSERT INTO quctt_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Xwi naꞌtaj chiꞌwe ri xkꞌulmataj rukꞌ ri rixoqil ri Lot. ");
INSERT INTO quctt_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Xapachin kꞌu ri karaj kukol ri ukꞌaslemal, kutzaq na riꞌ, xapachin kꞌu ri kutzaq ri ukꞌaslemal, kukol na riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Qas tzij kinbꞌij chiꞌwe chi che ri aqꞌabꞌ riꞌ, kekꞌojiꞌ na kebꞌ winaq pa jun chꞌat. Jun kakꞌam bꞌik chike, ri jun chik kakanaj kanoq. ");
INSERT INTO quctt_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","E kebꞌ ixoqibꞌ kekeꞌn na junam, jun kꞌut kakꞌam na bꞌik, ri jun chik kakanaj kanoq. ");
INSERT INTO quctt_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","E kebꞌ achyabꞌ kechakun na cho ri saq, jun kakꞌam na bꞌik, ri jun chik kakanaj kanoq. ");
INSERT INTO quctt_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Xkita kꞌu che: Ajawxel ¿Jawjeꞌ kakꞌulmataj wi waꞌ we riꞌ? Ri Jesús xubꞌij chike: Ri e kꞌuch kakimulij kibꞌ riꞌ xapawjeꞌ kꞌo wi jun kaminaq. ");
INSERT INTO quctt_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ri Jesús xutzijoj jun kꞌambꞌejabꞌal noꞌj chike ri utijoxelabꞌ chukꞌutik chi sibꞌalaj choqꞌaqꞌ wi kakibꞌan chꞌawem man kakꞌis taj ta kikꞌuꞌx. ");
INSERT INTO quctt_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Xubꞌij kꞌu chike: Kꞌo jun qꞌatal tzij pa jun tinimit ri man kuxiꞌj ta ribꞌ cho ri Dios, xuqujeꞌ man kuꞌnimaj ta ri winaq. ");
INSERT INTO quctt_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Pa ri tinimit xuqujeꞌ kꞌo jun malkaꞌn ixoq ri kꞌo jun uchꞌoꞌj, xeꞌ kꞌu rukꞌ ri qꞌatal tzij chutayik chi kuqꞌat tzij puꞌwiꞌ ri ukꞌulel. ");
INSERT INTO quctt_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Pune naj qꞌotaj man xraj taj xubꞌan ri qꞌatoj tzij, kꞌisbꞌal kꞌu rech xubꞌij: “Pune man kinxiꞌj ta wibꞌ cho ri Dios, xuqujeꞌ man keꞌ ta nukꞌuꞌx rukꞌ jun chike. ");
INSERT INTO quctt_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Xa kꞌu rumal man kel ta we ixoq riꞌ wukꞌ, kinbꞌan waꞌ ri qꞌatoj tzij, rukꞌ jubꞌiqꞌ kinqꞌiꞌtaj are kape sibꞌalaj kꞌi mul chiwilik.” ");
INSERT INTO quctt_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Xubꞌij kꞌu ri Ajawxel Jesús: Qas kichomaj rij ri xubꞌij ri itzel qꞌatal tzij. ");
INSERT INTO quctt_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿La man kꞌu kuqꞌat tzij ri Dios kukꞌ ri winaq ri uchaꞌom, we chi paqꞌij chi chaqꞌabꞌ kechꞌaw rukꞌ? ¿La kꞌamaꞌtam ta kꞌu riꞌ kutzalij uwach ri kichꞌawem? ");
INSERT INTO quctt_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Qas kubꞌan wi na riꞌ ri qꞌatoj tzij pa kiwiꞌ aninaq, pune jeriꞌ are kape ri Ukꞌojol ri Achi, ¿la kulu winaq ri kuꞌl kikꞌuꞌx che ri Dios? ");
INSERT INTO quctt_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","E kꞌo kꞌu jujun winaq ri kuꞌl kikꞌuꞌx chibꞌil taq kibꞌ, e sukꞌ kakinaꞌo, kaketzelaj kiwach ri e nikꞌaj winaq chik. Rumal riꞌ ri Jesús xutzijoj jun kꞌambꞌejabꞌal noꞌj chike: ");
INSERT INTO quctt_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","E kꞌo kebꞌ achyabꞌ, xebꞌe pa ri Templo chubꞌanik chꞌawem, ri jun fariseo, ri jun chik jun toqꞌil alkabal. ");
INSERT INTO quctt_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Are xubꞌan chꞌawem ri fariseo xubꞌij: “Kintyoxin che la o Dios, rumal man in junam ta kukꞌ ri eleqꞌomabꞌ taq achyabꞌ, e bꞌanal taq kꞌax, e kakabꞌ kixoqil, xuqujeꞌ man in junam ta rukꞌ we achi riꞌ we toqꞌil alkabal. ");
INSERT INTO quctt_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ri in kinqꞌip wibꞌ che nuwaꞌim kebꞌ mul pa wuqubꞌ qꞌij, xuqujeꞌ kinya ri ulajujil rech ronojel ri nuchꞌekoj.” ");
INSERT INTO quctt_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Are kꞌu ri toqꞌil alkabal naj xkanaj wi kanoq, xa ta ne kuwaꞌjilisaj ri uwach cho ri kaj, kutꞌikitaꞌ ri uwach ukꞌuꞌx xubꞌij: “Cheꞌl kꞌuꞌx la chwe o Dios, wetaꞌm chi in ajmak.” ");
INSERT INTO quctt_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Qas tzij kinbꞌij chiꞌwe chi we achi riꞌ, sukꞌ ranimaꞌ xtzalij cho rachoch man je ta kꞌu ri fariseo, rumal iwetaꞌm chi xapachin ri kunimarisaj ribꞌ kanitzꞌarisax na uqꞌij, xapachin xuqujeꞌ ri kumochꞌ ribꞌ kanimarisax na uqꞌij. ");
INSERT INTO quctt_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Xekꞌam kꞌu bꞌik akꞌalabꞌ cho ri Jesús rech kuya ri uqꞌabꞌ pa kiwiꞌ. Are xkil ri tijoxelabꞌ, xeꞌkiyaj ri e kꞌamowinaq bꞌik. ");
INSERT INTO quctt_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ri Jesús kꞌut xuꞌsikꞌij ri akꞌalabꞌ, kꞌa te riꞌ xubꞌij chike ri winaq: Chiya bꞌe chike ri akꞌalabꞌ kepe wukꞌ, man kiꞌqꞌil taj, rumal chi are ajchoqꞌe ri ajawarem rech ri Dios ri winaq ri kakubꞌiꞌ kikꞌuꞌx jetaq ri akꞌalabꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Qas tzij kinbꞌij chiꞌwe, ri man kukꞌamawaꞌj ta ri ajawarem rech ri Dios jetaq ri kubꞌan jun laj akꞌal, man kwinel ta riꞌ kok chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jun chike ri kꞌamal bꞌe xuta che ri Jesús: Utz laj ajtij, ¿jas rajawaxik kinbꞌano chi rechabꞌexik ri jun alik kꞌaslemal? ");
INSERT INTO quctt_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ri Jesús xubꞌij che: ¿Jas che kabꞌij chi in utz? Man kꞌo ta chi jun winaq ri utz, xwi ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Awetaꞌm ri kubꞌij ri taqanik: man katzukuj ta chi jun awixoqil, man kabꞌan ta kamisanik, man katelaqꞌ taj, man kabꞌan ta bꞌanoj tzij chirij jun winaq chik, xuqujeꞌ chaꞌnimaj ri atat anan. ");
INSERT INTO quctt_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ri achi xubꞌij che ri Jesús: Pa ri walkꞌaꞌlal numajim la unimaxik waꞌ we ri, kꞌa xaq jeꞌ ne kinnimaj kamik. ");
INSERT INTO quctt_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Are xuta ri Jesús ri xubꞌij ri achi che, xubꞌij: Xa chi jun jastaq kajawataj chawe, chakꞌayij kan ronojel ri kꞌo awukꞌ. Kꞌa te riꞌ chajacha ri rajil chike ri e mebꞌaibꞌ, kayaꞌtaj kꞌu na aqꞌinomal chilaꞌ chikaj. Kꞌa te riꞌ chatan loq chinatereneꞌj. ");
INSERT INTO quctt_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Are xutabꞌej rech ri achi, xkꞌaxkꞌobꞌ ri ranimaꞌ, rumal sibꞌalaj qꞌinom. ");
INSERT INTO quctt_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Are xril ri Jesús chi xkꞌaxkꞌobꞌ ranimaꞌ xubꞌij: Sibꞌalaj kꞌax okem ke ri qꞌinomabꞌ pa ri ajawarem rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Are man kꞌax taj kubꞌan jun kamey kikꞌow pa ri uteqꞌal ri bꞌaq rech tꞌisoꞌmabꞌal cho ri jun qꞌinom ri karaj kok pa ri ajawarem rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ri winaq ri xetow ri xubꞌij ri Jesús, xkibꞌij: ¿Jachin kꞌu riꞌ kakwin chukolik ribꞌ? ");
INSERT INTO quctt_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ri Jesús xubꞌij chike: Ri Dios kwinel chubꞌanik ri man kakwin ta ri achi che. ");
INSERT INTO quctt_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ri Pedro xubꞌij che: Chilampe la, ri uj xqaya kan ronojel ri qajastaq rumal tereneꞌxik la. ");
INSERT INTO quctt_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ri Jesús xubꞌij: Qas tzij kinbꞌij chiꞌwe chi ri winaq ri xuya kan rachoch, rixoqil, e rachalal, utat unan xuqujeꞌ e ralkꞌwaꞌl ");
INSERT INTO quctt_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kayaꞌtaj na kꞌi ukꞌaxelal che, xuqujeꞌ pa ri qꞌotaj ri petinaq, kayaꞌtaj na che ri jun alik kꞌaslemal. ");
INSERT INTO quctt_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ri Jesús xukꞌam bꞌik ri kabꞌlajuj utijoxelabꞌ xaq kitukel, xubꞌij chike: Chanim kujeꞌ pa Jerusalén, chilaꞌ kakꞌulmataj wi ronojel ri xkitzꞌibꞌaj ri e qꞌalajisal taq tzij rech ri Dios kakꞌulmataj na rukꞌ ri Ukꞌojol ri Achi. ");
INSERT INTO quctt_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kajach na pa kiqꞌabꞌ ri winaq ri man aꞌj Israel taj, kayoqꞌ na, kabꞌix na kꞌax taq tzij che, kachubꞌax na upalaj. ");
INSERT INTO quctt_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Karapux na, xuqujeꞌ kakamisax na, xa kꞌu kakꞌastaj na churox qꞌij. ");
INSERT INTO quctt_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ri tijoxelabꞌ man xkichꞌobꞌ taj ri xbꞌix chike. Rumal cher xawax chikiwach ri kel kubꞌij we jastaq riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Are xopan ri Jesús chuxukut ri tinimit Jericó, kꞌo jun moy tꞌuyul chuchiꞌ ri bꞌe, kuta ulimoxna. ");
INSERT INTO quctt_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Are xuto chi e kꞌi winaq tajin kiꞌkꞌowik, xuta chike ri winaq jas ri tajin kakꞌulmatajik. ");
INSERT INTO quctt_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ri winaq xkibꞌij che: Are ri Jesús aj Nazaret ri tajin kikꞌow waral. ");
INSERT INTO quctt_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ri moy xuraqaqej uchiꞌ, xubꞌij: Jesús, Ralkꞌwaꞌl ri David, cheꞌl kuꞌx la chwe. ");
INSERT INTO quctt_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ri winaq ri e nabꞌe apanoq choch xkibꞌij che chi katanik, xa kꞌu kꞌo na ri xubꞌan churaqik uchiꞌ: Ralkꞌwaꞌl ri David, che la kuꞌx la chwe. ");
INSERT INTO quctt_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Xtakꞌiꞌ kꞌu ri Jesús, xtaqan chukꞌamik apanoq ri achi. Are xqet chuxukut, ri Jesús xuta che: ");
INSERT INTO quctt_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","¿Jas kawaj kinbꞌan chawe? Ri moy xubꞌij: Ajawxel, kawaj kinkaꞌyik. ");
INSERT INTO quctt_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ri Jesús xubꞌij che: Chakꞌamawaꞌj ri akaꞌyebꞌal. Xatutzir rumal ri akojobꞌal. ");
INSERT INTO quctt_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Aninaq xkaꞌyik, xteriꞌ kꞌu chirij ri Jesús, kuqꞌijilaꞌj ri Dios, konojel kꞌu ri winaq ri xkilo xkiqꞌijilaꞌj ri ubꞌiꞌ ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Are xopan ri Jesús pa Jericó, xuchapleꞌj kꞌu bꞌik ikꞌowem pa ri tinimit. ");
INSERT INTO quctt_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Kꞌo kꞌu jun qꞌinom achi ubꞌiꞌ Zaqueo, kꞌamal bꞌe ke ri e toqꞌil taq alkabal. ");
INSERT INTO quctt_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","We achi riꞌ karaj karil ri Jesús, man kakwin ta kꞌut rumal ri kikꞌiyal ri winaq xuqujeꞌ rumal koꞌl raqan. ");
INSERT INTO quctt_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Rumal riꞌ kaxikꞌanik xnabꞌejik, xwacheꞌn che jun cheꞌ rech sicómoro rech karil ri Jesús are kikꞌow bꞌik. ");
INSERT INTO quctt_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Are xopan ri Jesús chilaꞌ, xkaꞌy chikaj, xubꞌij: Zaqueo, chatqaj loq aninaq, kamik kinkanaj kan cho awachoch. ");
INSERT INTO quctt_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Aninaq kꞌut xqaj loq, sibꞌalaj kakiꞌkotik, xukꞌamawaꞌj ri Jesús cho ri rachoch. ");
INSERT INTO quctt_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Are xkil ri winaq we xkꞌulmatajik, xkichapleꞌj ubꞌixik: Le Jesús xkanaj kan cho rachoch jun ajmak. ");
INSERT INTO quctt_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Are kꞌu ri Zaqueo xubꞌij: Ajawxel, chilampe la. Chanim kinya pa nikꞌaj che ri nuqꞌinomal chike ri mebꞌaibꞌ, we kꞌu nubꞌanom kꞌax che jun chik, kinya kajibꞌ mul ukꞌaxelal. ");
INSERT INTO quctt_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ri Jesús xubꞌij che: Kamik xul ri koltajem cho ri ja kꞌolibꞌal riꞌ, rumal we achi riꞌ ralkꞌwaꞌl xuqujeꞌ ri Abraham. ");
INSERT INTO quctt_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Rumal ri uKꞌojol ri Achi xpe chutzukuxik xuqujeꞌ chukolik ri winaq ri sachinaq. ");
INSERT INTO quctt_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Are tajin kakitatabꞌej ri kubꞌij ri Jesús, xutzijoj jun kꞌambꞌejabꞌal noꞌj chike rumal xa jubꞌiqꞌ chik karaj kopan pa ri tinimit Jerusalén, xuqujeꞌ rumal pa kikꞌuꞌx ri winaq chi xaq kꞌa teꞌ kukꞌut ribꞌ ri ajawarem re ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Xaq jeriꞌ xubꞌij ri Jesús chike: Kꞌo jun achi, ralkꞌwaꞌl jun nim taqanel, xeꞌ chi pa jun tinimit rech kabꞌan la taqanel che, kꞌa te riꞌ katzalij loq. ");
INSERT INTO quctt_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Xuꞌsikꞌij kꞌu e lajuj chike ri e rajchakibꞌ, xuya kan nikꞌaj pwaq chike, xuqujeꞌ xubꞌij chike: Chixchakun rukꞌ we pwaq riꞌ, kꞌa te kitzalij chwe are kintzalij loq. ");
INSERT INTO quctt_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Are kꞌu ri winaq rech ri tinimit xeꞌkitaq bꞌik jun wok winaq chubꞌixik: Man keqaj ta we achi riꞌ kataqan pa qawiꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pune jeriꞌ xkibꞌano, ri achi xok wi che taqanel. Are xtzalij loq pa ri utinimit, xuꞌsikꞌij ri e rajchakibꞌ ri xuya kan pwaq chike, rech karetaꞌmaj janipa xkichꞌeko. ");
INSERT INTO quctt_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Xopan kꞌu ri nabꞌe ajchak xubꞌij: Ajawxel, ri rajil la, xuchꞌek chi lajuj mul cho ri xya la kan chwe. ");
INSERT INTO quctt_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ri taqanel xubꞌij che: Sibꞌalaj utz ri xabꞌano, at utz laj ajchak. Rumal kꞌu ri utz xabꞌan chi rilik ri nitzꞌ jastaq, kinya taqanik pa aqꞌabꞌ pa kiwiꞌ lajuj tinimit. ");
INSERT INTO quctt_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Xopan chi ri ukabꞌ ajchak xubꞌij: Ajawxel, ri rajil la xuya jobꞌ mul cho ri xya la kan chwe. ");
INSERT INTO quctt_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ri taqanel xubꞌij che: Chawe at kinya taqanik pa aqꞌabꞌ puꞌwiꞌ jobꞌ tinimit. ");
INSERT INTO quctt_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Xopan chi ri jun ajchak xubꞌij: Ajawxel, riꞌ le rajil la. Xinyako, xinjatꞌij pa jun atzꞌyaq. ");
INSERT INTO quctt_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Xinxiꞌj wibꞌ cho la, rumal cher katoqꞌij la ri man xya ta la, xuqujeꞌ kayak la ri man xtik ta la. ");
INSERT INTO quctt_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ri taqanel xubꞌij che: Itzel laj ajchak, kinqꞌat tzij paꞌwiꞌ rukꞌ ri xabꞌij, ¿xaq jeriꞌ chi awetaꞌm chi sibꞌalaj in kꞌaꞌn, xuqujeꞌ chi kinkꞌam ri jastaq ri man in taj xintikowik? ");
INSERT INTO quctt_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Jas che kꞌut man xaya taj ri nurajil kukꞌ ri winaq ri kakiyak pwaq, rech are kintzalij loq kulintoqꞌij ri ral ri nurajil? ");
INSERT INTO quctt_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Kꞌa te riꞌ xubꞌij chike ri e winaq ri e kꞌo chilaꞌ: Chikꞌama le pwaq che, chiya che ri ajchak ri xtoj lajuj mul che. ");
INSERT INTO quctt_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ri winaq xkibꞌij: Ajawxel, le achi leꞌ kꞌo chi lajuj mul urajil. ");
INSERT INTO quctt_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ri taqanel xubꞌij chike: Qas tzij kinbꞌij chiꞌwe, ri kꞌo, kꞌo rukꞌ, nim kayaꞌtaj na che. Are kꞌu ri maj kꞌo rukꞌ, kamaj na che ri jubꞌiqꞌ ri kꞌo rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Are kꞌu ri winaq ri man kakaj taj kinux taqanel pa kiwiꞌ, chikꞌama loq, xuqujeꞌ chiꞌkamisaj chinuwach. ");
INSERT INTO quctt_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Are xbꞌiꞌtaj we tzij riꞌ rumal ri Jesús, xnabꞌej chikiwach ri utijoxelabꞌ, xpaqiꞌ pa ri tinimit Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Are xqeteqobꞌ chuxukut ri tinimit ubꞌiꞌ Betfagé, xuqujeꞌ chuxukut ri tinimit Betania, ri kꞌo chuxukut ri juyubꞌ ubꞌiꞌ Olivos, xuꞌtaq bꞌik e kebꞌ chike ri utijoxelabꞌ, xubꞌij chike: ");
INSERT INTO quctt_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Jix pa ri leꞌaj ri kꞌo apanoq chiqawach, chilaꞌ kiriq wi jun laj bꞌur jatꞌital kanoq, ri maj jun winaq kejeninaq. Chikira loq xuqujeꞌ chikꞌama loq. ");
INSERT INTO quctt_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","We kꞌo jun katow chiꞌwe: “¿Jas che tajin kikir le bꞌur?” chibꞌij che: “Xa kajawataj che ri Ajawxel.” ");
INSERT INTO quctt_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Xebꞌe kꞌu ri utijoxelabꞌ, qas xeꞌkiriqa wi, jetaq ri xbꞌix chike. ");
INSERT INTO quctt_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ri ajchoqꞌe kꞌut xkita chike: ¿Jas che kikir le kꞌin laj bꞌur? ");
INSERT INTO quctt_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Aꞌreꞌ xkibꞌij: Xa kajawataj che ri Ajawxel. ");
INSERT INTO quctt_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Xkikꞌam kꞌu bꞌik, xeꞌkiya che ri Jesús, xkiya ri katzꞌyaq chirij ri bꞌur, kꞌa te riꞌ xkitoꞌ ri Jesús rech kukejej ri bꞌur. ");
INSERT INTO quctt_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ri winaq xkichapleꞌj ulikꞌik ri kimanta pa taq ri bꞌe, ri bꞌenaq wi ri bꞌur ri ukejem ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Are xqeteqobꞌ bꞌik ri Jesús chuxukut ri xulanik cho ri juyubꞌ Olivos, xkichapleꞌj kiꞌkotem konojel ri tijoxelabꞌ xuqujeꞌ xkichapleꞌj uqꞌijilaꞌxik ri Dios rumal ronojel ri mayijabꞌal taq jastaq ri xkilo xubꞌan ri Jesús. Kakiraqaqej kichiꞌ kakibꞌij: ");
INSERT INTO quctt_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Tewchiꞌtal ri ubꞌiꞌ ri Taqanel ri petinaq pa ri ubꞌiꞌ ri Ajawxel. Jaꞌmaril pa ri kaj xuqujeꞌ juluwem rech chikajil. ");
INSERT INTO quctt_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","E kꞌo kꞌu jujun chike ri fariseos chkixoꞌl ri winaq, xkibꞌij che ri Jesús: Ajtij, chaꞌyaja ri atijoxelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ri Jesús xubꞌij chike: We kuꞌxlan waꞌ aꞌreꞌ, are kakiraq na kichiꞌ ri abꞌaj. ");
INSERT INTO quctt_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Are xenaqajin che ri tinimit Jerusalén, ri Jesús xril ri tinimit, kꞌa te riꞌ xroqꞌej. ");
INSERT INTO quctt_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Kꞌa te riꞌ xubꞌij: We ta kꞌo bꞌanom wi kawetaꞌmaj jachin ri kayoꞌw jaꞌmaril chawe, xa kꞌu awatal chawach. ");
INSERT INTO quctt_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kape kꞌu na qꞌij ri kewaꞌjil na ri akꞌulel chawij, kakimulij na kibꞌ chawij, kakitzꞌapij na ri abꞌe. ");
INSERT INTO quctt_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Kakiwulij na ri tapya ri kꞌo chirij ri atinimit, keꞌkikamisaj na ri awalkꞌwaꞌl. Xa ta ne jun abꞌaj kakanaj chi kan puꞌwiꞌ jun abꞌaj chik, rumal man xachomaj ta ri qꞌotaj ri xpe ri Dios che akolik. ");
INSERT INTO quctt_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kꞌa te riꞌ xok bꞌik pa ri Templo, xeꞌresaj loq konojel ri aꞌjkꞌayibꞌ ri e kꞌo chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Xubꞌij chike ri winaq: Tzꞌibꞌatalik: Ri wachoch rech bꞌanbꞌal chꞌawem, ibꞌanom kꞌu ix kijul eleqꞌomabꞌ che. ");
INSERT INTO quctt_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ronojel kꞌu qꞌij ri Jesús xuya kꞌutuꞌn pa ri Templo, are kꞌu ri kꞌamal bꞌe ke ri chꞌawenelabꞌ cho ri Dios, xuqujeꞌ ri aꞌjtijabꞌ rech ri taqanik are kakaj kakikamisaj. ");
INSERT INTO quctt_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Man kakiriq ta kꞌut jas kakibꞌan chukamisaxik, rumal konojel ri winaq kakitatabꞌej ri ukꞌutuꞌn rukꞌ ronojel kanimaꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Jun qꞌijal are tajin kuya kꞌutuꞌn ri Jesús pa ri Templo chirij ri utz laj taq tzij, xeqet rukꞌ ri kꞌamal taq bꞌe ke ri e chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq, ri aꞌjtijabꞌ xuqujeꞌ ri e kꞌamal taq bꞌe. ");
INSERT INTO quctt_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Xkibꞌij che: ¿Jachin at taqowinaq chubꞌanik waꞌ we riꞌ? ¿Jachin yoꞌwinaq kwinem chawe? ");
INSERT INTO quctt_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ri Jesús xubꞌij chike: Ri in xuqujeꞌ kinbꞌan jun kꞌotbꞌal chiꞌ chiꞌwe, chibꞌij chwe: ");
INSERT INTO quctt_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ri qasanaꞌ ri xubꞌan ri Juan ¿la jun taqanik rech achi o rech ri Dios? ");
INSERT INTO quctt_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Xkitzijobꞌej kꞌu rij, xkibꞌij kꞌut: We kaqabꞌij chi rech ri Dios, ¿jas kꞌu che man xikoj taj, kacha laꞌ chaqe? ");
INSERT INTO quctt_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","We kꞌu kaqabꞌij chi rech achi, kujkibꞌan che abꞌaj laꞌ le winaq, rumal ketaꞌm chi ri Juan are jun qꞌalajisal utzij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Xaq jeriꞌ xeꞌkibꞌij che: Man qetaꞌm taj jawjeꞌ upetik wi. ");
INSERT INTO quctt_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Xubꞌij kꞌu ri Jesús chike: Man kinbꞌij ta xuqujeꞌ in jachin yoꞌwinaq kwinem chwe chubꞌanik wa we jastaq riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ri Jesús xutzijoj we jun kꞌambꞌejabꞌal noꞌj chike ri winaq: Kꞌo jun achi xutik uvas pa jun ulew, xuya kꞌu kan ri ulew pa qajik chike nikꞌaj winaq rumal xeꞌ pa jun naj laj utaqkil. ");
INSERT INTO quctt_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Are kꞌu xuriq ri qꞌotaj rech yakoj, xutaq bꞌik jun rajchak kukꞌ ri ajtikolobꞌ rech kuta rech ri xwachinik. Are kꞌu ri ajtikolobꞌ xkichꞌayo, kꞌa te riꞌ xkitaq bꞌik cho rachoch, maj jas xkiya bꞌik che. ");
INSERT INTO quctt_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ri ajchoqꞌe ri ulew xutaq chi bꞌik jun ajchak kukꞌ xkichꞌey xuqujeꞌ loq, xuqujeꞌ maj xkiya loq che. ");
INSERT INTO quctt_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Xutaq chi kꞌu bꞌik jun urox ajchak kukꞌ, xkesaj kꞌu loq pa ri ulew, xkibꞌan loq kꞌax che. ");
INSERT INTO quctt_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Are kꞌu ri ajchoqꞌe ri ulew xubꞌij: “¿Jas ta kꞌu kinbꞌano? Kintaq na bꞌik ri nukꞌojol, kakinimaj waꞌ areꞌ.” ");
INSERT INTO quctt_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ri ajchakibꞌ are xkilo, xkitzijobꞌej rij, xkibꞌij: “Are waꞌ kechꞌabꞌen kan ri ulew, qakamisaj” xechaꞌ, “rech keqechabꞌej kan le ulew.” ");
INSERT INTO quctt_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Xaq jeriꞌ xkesaj loq pa ri ulew kꞌa te riꞌ xkikamisaj. ¿Jas kubꞌan ri ajchoqꞌe ri ulew chike we ajchakibꞌ riꞌ? ");
INSERT INTO quctt_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Kukꞌis pa kiwiꞌ ri ajchakibꞌ are katzalij loq, kꞌa te riꞌ kuya chi kan ri ulew chike nikꞌaj winaq chik. Are xkita ri winaq xkibꞌij: Kꞌo ta bꞌa ne wi mat karaj ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ri Jesús ko xuꞌkaꞌyej ri winaq, xubꞌij: ¿Jas kꞌu kel waꞌ ri tzꞌibꞌatalik ri kubꞌij: Ri abꞌaj ri xketzelaj uwach ri e yakol taq ja, xux na ri abꞌaj ri qas kꞌo kutayij chikiwach ri nikꞌaj abꞌaj chik? ");
INSERT INTO quctt_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Xapachin ri katzaq puꞌwiꞌ ri abꞌaj riꞌ kamuchuꞌlitajik, xuqujeꞌ kajaqꞌin ri winaq we katzaq we abꞌaj riꞌ chirij. ");
INSERT INTO quctt_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Are xkinabꞌej ri aꞌjtijabꞌ rech ri taqanik xuqujeꞌ ri e kꞌamal taq bꞌe ke ri chꞌawenelabꞌ cho ri Dios chi aꞌreꞌ xtzijox kij pa ri kꞌambꞌejabꞌal noꞌj, xkaj xkiqꞌat tzij puꞌwiꞌ ri Jesús, xkixiꞌj kꞌu kibꞌ chikiwach ri winaq rech ri tinimit. ");
INSERT INTO quctt_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Xaq jeriꞌ xeꞌkitaq bꞌik winaq ri kakijaluj chi nimaꞌq kibꞌanik, rech kakikoj jun kꞌambꞌejabꞌal pa ubꞌe ri Jesús rech rukꞌ riꞌ kekwinik kakikꞌam bꞌik cho ri qꞌatal tzij. ");
INSERT INTO quctt_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ri winaq ri xetaq bꞌik xkibꞌij: Ajtij, qetaꞌm chi sukꞌ ronojel ri kabꞌij la, xuqujeꞌ ri kakꞌut la xuqujeꞌ man kaqꞌat ta la tzij pa kiwiꞌ ri winaq rumal ri kekaꞌyik, xane qas are wi kakꞌut la ri bꞌe rukꞌ ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿La yaꞌtal chaqe kaqatoj alkabal che ri César o man yaꞌtal taj? ");
INSERT INTO quctt_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ri Jesús kꞌut xuchꞌobꞌ ri itzel taq kichomabꞌal, rumal riꞌ xubꞌij chike: ");
INSERT INTO quctt_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Chikꞌutumpe jun pwaq kech ri aꞌj Roma chinuwach. ¿Jachin ajchoqꞌe we palajaj xuqujeꞌ we tzꞌibꞌ we kꞌo choch? Rech ri César, xecha ri winaq. ");
INSERT INTO quctt_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ri Jesús xubꞌij chike: Chiya che ri César ri rech ri César, xuqujeꞌ chiya che ri Dios ri rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Man xekwin ta kꞌut xkikoj kꞌaꞌmabꞌal pa ri ubꞌe, rukꞌ ri kubꞌij chike ri winaq, xemayijanik are xkita ri tzalibꞌal uwach ri xubꞌij chike, xaq jeriꞌ maj chi jas xkibꞌij. ");
INSERT INTO quctt_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Are kꞌu ri e saduceos, ri kakibꞌij chi maj kꞌastajibꞌal wach, xeqet chuxukut ri Jesús, xkibꞌij we kꞌulmatajik che: ");
INSERT INTO quctt_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ajtij, ri Moisés kukꞌut chiqawach pa ri wuj ri xutzꞌibꞌaj chi we kakam jun achi, maj kan ralkꞌwaꞌl rukꞌ ri rixoqil, choqꞌaqꞌ wi chi ri rachalal we achi riꞌ kakꞌuliꞌ rukꞌ ri ixoq ri xya kanoq rech kekꞌojiꞌ rijaꞌl ri rachalal ri xkamik. ");
INSERT INTO quctt_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","E kꞌo kꞌu e wuqubꞌ achyabꞌ alaxik. Ri nabꞌe xkꞌuliꞌk, xa kꞌu e maj ralkꞌwaꞌl xekꞌojiꞌ kan rukꞌ ri rixoqil. ");
INSERT INTO quctt_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ri ukabꞌ xkꞌuliꞌ rukꞌ ri rixoqil ri rachalal, xuqujeꞌ maj e ralkꞌwaꞌl xekꞌojiꞌ kan rukꞌ ri ixoq ");
INSERT INTO quctt_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ri urox achi xuqujeꞌ xkꞌuliꞌ rukꞌ ri malkaꞌn ixoq maj xuqujeꞌ ralkꞌwaꞌl xekꞌojiꞌ rukꞌ, jeriꞌ xkibꞌan ri e wuqubꞌ alaxik. Konojel xekꞌuliꞌ rukꞌ ri ixoq, xa kꞌu maj kalkꞌwaꞌl xekꞌojiꞌ kan rukꞌ ri ixoq. ");
INSERT INTO quctt_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kꞌisbꞌal kꞌu rech, xkam xuqujeꞌ ri ixoq. ");
INSERT INTO quctt_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Are kꞌu kuriq ri qꞌij rech kꞌastajibꞌal ¿jachin chike ri e wuqubꞌ alaxik karachajilaj na ri ixoq, rumal chi konojel ri e wuqubꞌ achyabꞌ xekꞌuliꞌ rukꞌ? ");
INSERT INTO quctt_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ri Jesús xubꞌij chike: Ri winaq rech ri uwachulew kekꞌuliꞌ xuqujeꞌ kakiya kibꞌ pa taq kꞌulanem. ");
INSERT INTO quctt_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Are kꞌu ri yaꞌtal chike kekꞌastaj na rech kekꞌojiꞌ pa ri jun alik kꞌaslemal ri kape na, ri winaq riꞌ man kekꞌuliꞌ taj xuqujeꞌ man keya taj pa kꞌulanem. ");
INSERT INTO quctt_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Man kekam taj xuqujeꞌ je kuꞌx na jetaq ri angelibꞌ, e ralkꞌwaꞌl ri Dios rumal yaꞌtal bꞌe chike kekꞌastaj na, jun qꞌijal. ");
INSERT INTO quctt_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Pa ri uwuj ri Moisés jawjeꞌ ri xkꞌut wi choch ri kꞌix ri kajinow pa qꞌaqꞌ, kuqꞌalajisaj chi ri e kaminaqibꞌ kekꞌastaj na, rumal kubꞌij che ri Ajawxel, chi are kiDios ri Abraham, ri Isaac xuqujeꞌ ri Jacob. ");
INSERT INTO quctt_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ri Dios man kiDios ta kaminaqibꞌ, xane kiDios e kꞌaslik winaq, konojel e kꞌaslik cho areꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","E jujun kꞌut chike ri aꞌjtijabꞌ rech ri taqanik xkibꞌij che ri Jesús: Sibꞌalaj utz ri xbꞌij la ajtij. ");
INSERT INTO quctt_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Maj chi kꞌu jun xkꞌotow uchiꞌ ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ri Jesús kꞌut xukꞌot kichiꞌ ri winaq xubꞌij: ¿Jas che kibꞌij chi ri Cristo Ralkꞌwaꞌl ri David? ");
INSERT INTO quctt_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Are ri David xtzꞌibꞌan pa ri wuj rech Salmos: Ri Dios xubꞌij che ri wAjaw: Chattꞌuyul pa ri nuwiqiqꞌabꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Kꞌa katchꞌeken na chike ri akꞌulel xuqujeꞌ kekꞌojiꞌ na xeꞌ raqan aqꞌabꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","We ri David kubꞌij wAjaw che, ¿jas kꞌu che riꞌ kubꞌij ukꞌojol che? ");
INSERT INTO quctt_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Are tajin katatabꞌex ri Jesús kumal ri winaq, xubꞌij chike ri utijoxelabꞌ: ");
INSERT INTO quctt_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Chichajij iwibꞌ chike ri aꞌjtijabꞌ rech ri taqanik. Ri aꞌre utz kakinaꞌo kewaꞌkat rukꞌ ri katzꞌyaq ri sibꞌalaj kachuplinik, xuqujeꞌ sibꞌalaj jeꞌl chike kaya rutzil kiwach pa taq ri kꞌayibꞌal, xuqujeꞌ kakichaꞌ ri jeꞌl laj taq kꞌolibꞌal pa taq ri Sinagoga, xuqujeꞌ kakichaꞌ ri jeꞌl laj taq kꞌolibꞌal pa taq ri nimaqꞌij. ");
INSERT INTO quctt_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Utz xuqujeꞌ kakinaꞌo kakimaj ri e kachoch xuqujeꞌ ri kimebꞌail ri e malkaꞌnibꞌ, kakibꞌan xuqujeꞌ naj taq chꞌawem rech ketatabꞌex kumal nikꞌaj winaq chik rumal riꞌ nim kꞌax kape na pa kiwiꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ri Jesús xuꞌkaꞌyej ri qꞌinomabꞌ are tajin kakiya ri kisipanik pa taq ri kꞌolibꞌal rech pa ri Templo rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Xril xuqujeꞌ jun mebꞌa malkaꞌn ixoq ri xuya kebꞌ qꞌana pwaq pa ri kꞌolibꞌal rech ri sipanik. ");
INSERT INTO quctt_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Xaq jeriꞌ xubꞌij: Qas tzij kinbꞌij chiꞌwe chi we mebꞌa malkaꞌn ixoq riꞌ, are nim ri usipanik xuya chkiwach konojel ri winaq. ");
INSERT INTO quctt_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Konojel ri winaq xkiya jubꞌiqꞌ che ri kꞌo kukꞌ, are kꞌu we mebꞌaꞌ ixoq riꞌ xuya ronojel ri urajil tzuqbꞌal ribꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","E kꞌo kꞌu jujun chike ri utijoxelabꞌ ri Jesús, tajin kakitzijoj rij ri Templo rech ri Dios, chi sibꞌalaj jeꞌl kakaꞌyik rumal ri jeꞌl taq abꞌaj ri kojtal che, xuqujeꞌ ronojel ri sipanik ri e kꞌo chupam ri e tzujtal che ri Dios, are kꞌu ri Jesús xubꞌij chike: ");
INSERT INTO quctt_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Kuꞌriqa na qꞌij chi ronojel waꞌ we kiwilo riꞌ kewulix na, maj jun abꞌaj kakanaj kan puꞌwiꞌ jun abꞌaj chik. ");
INSERT INTO quctt_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Xkibꞌij kꞌu che: Ajtij, ¿jampaꞌ kꞌu kakꞌulmataj we riꞌ, xuqujeꞌ jas retal chi xa jubꞌiqꞌ chik karaj kakꞌulmatajik? ");
INSERT INTO quctt_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ri Jesús xubꞌij chike: Qas chichajij iwibꞌ, man kiya ta iwibꞌ pa menkꞌetixik, rumal cher e kꞌi winaq kepe na, kakikoj ri nubꞌiꞌ xuqujeꞌ kakibꞌij: In in Mesías, xnaqajir loq ri qꞌotaj. Man kiꞌtereneꞌj ta kꞌu ri winaq riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Man kixiꞌj ta iwibꞌ are kito chi kꞌo chꞌoꞌj kakꞌulmatajik xuqujeꞌ jastaq ri kekꞌexkꞌobꞌik, rumal choqꞌaqꞌ wi chi kape na waꞌ we riꞌ nabꞌe, xa kꞌu man are ta kꞌisbꞌal rech ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kꞌa te riꞌ xubꞌij: Kechꞌoꞌjin na tinimit kukꞌ tinimit xuqujeꞌ e wok tinimit kukꞌ taq e wok taq tinimit. ");
INSERT INTO quctt_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kape na nimalaj taq kabꞌraqan, numik, xuqujeꞌ yabꞌil pa ronojel ri tinimit rech uwachulew, xuqujeꞌ kakꞌulmataj na xibꞌibꞌal taq kꞌutbꞌal cho ri kaj. ");
INSERT INTO quctt_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Xa kꞌu nabꞌe kakibꞌan na kꞌax chiꞌwe, kixkichap na xuqujeꞌ kixkikꞌam na bꞌik pa taq ri Sinagoga xuqujeꞌ kixkikoj na pa cheꞌ rumal rech ri uqꞌalajisaxik ri nubꞌiꞌ, kixkikꞌam na bꞌik chikiwach e taqanel xuqujeꞌ e qꞌatal taq tzij. ");
INSERT INTO quctt_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Xaq jeriꞌ kayaꞌtaj na bꞌe rech kiniqꞌalajisaj chikiwach. ");
INSERT INTO quctt_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Naꞌtaj chiꞌwe chi man rajawaxik taj kichomaj bꞌik rij jas kibꞌan chutoꞌik iwibꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Rumal in kinya iwetaꞌmabꞌal xuqujeꞌ ri tzij ri kitzalibꞌej uwach ri ikꞌulel rech man kakiriq taj jas kakibꞌan chutzalixik uwach ri itzij, xuqujeꞌ man kekwin taj kakikoj kꞌaꞌmabꞌal pa ibꞌe. ");
INSERT INTO quctt_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Kabꞌan na bꞌanoj tzij chiꞌwij kumal ri iꞌtat, iꞌwachalal, xuqujeꞌ ri uqꞌabꞌ taq alaxik iwukꞌ, kekamisax kꞌu na jujun chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Konojel ri winaq cho ri uwachulew kixketzelaj na rumal rech ri nubꞌiꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pune jeriꞌ xa ta ne jun iwiꞌ katzaq na. ");
INSERT INTO quctt_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","We ko kixtakꞌiꞌ pa ri ikojobꞌal, kixkolotaj na. ");
INSERT INTO quctt_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Xa kꞌu chiwetaꞌmaj chi xqeteqobꞌ loq ri kꞌaxkꞌolal are kiwil ri tinimit Jerusalén sutital rij kumal ri ajchꞌoꞌjabꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Che ri qꞌij riꞌ, ri winaq ri e kꞌo pa ri tinimit Judea chaꞌnimaj bꞌik pa taq ri juyubꞌ, xuqujeꞌ ri e kꞌo pa ri tinimit Jerusalén, cheꞌ la bꞌik chilaꞌ, ri e kꞌo xuqujeꞌ cho ri saq, metzalij loq pa ri tinimit. ");
INSERT INTO quctt_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Are waꞌ ri qꞌotaj rech ri qꞌatoj tzij, jawjeꞌ ri kakꞌulmataj wi ronojel ri tzꞌibꞌatalik. ");
INSERT INTO quctt_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Kꞌax rech ri yawabꞌ ixoq, xuqujeꞌ ri tajin kutubꞌisaj ral pa taq ri qꞌij riꞌ! Jeriꞌ rumal nimalaj kꞌaxkꞌolal kape cho ri uwachulew, xuqujeꞌ kꞌaxkꞌolal puꞌwiꞌ we tinimit riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","E kꞌo winaq kekamisax na chi sakꞌibꞌal, xuqujeꞌ e kꞌo kekꞌam na bꞌik, ri winaq ri man aꞌj Israel taj kakibꞌan na kꞌax chike ri winaq aꞌj Jerusalén, kꞌa katzꞌaqat na ri qꞌij ri bꞌiꞌtal loq. ");
INSERT INTO quctt_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Kakꞌexkꞌobꞌ na le qꞌij, le ikꞌ xuqujeꞌ le e chꞌumil. Ri winaq ri keꞌl pa taq ri tinimit kakꞌaxkꞌobꞌ na kanimaꞌ, xuqujeꞌ kemayijan na rumal ri uchꞌuꞌjarem ri plo. ");
INSERT INTO quctt_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Kekam na konojel ri winaq che xibꞌin ibꞌ, rumal cher kabꞌirirex na ronojel le uwach le kaj. ");
INSERT INTO quctt_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kꞌa te riꞌ kakil kꞌu na ri upetibꞌal ri uKꞌojol ri Achi pa jun sutzꞌ, rukꞌ kwinem xuqujeꞌ juluwem. ");
INSERT INTO quctt_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Are kuchapleꞌj kꞌulmatajik waꞌ we jastaq riꞌ, chikꞌamawaꞌj ichuqꞌabꞌ, chiwaꞌjilisaj ri kixkaꞌyik rumal cher ri ikolotajem tajin kanaqajir loq chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ri Jesús xutzijoj chike we jun kꞌambꞌejabꞌal noꞌj riꞌ: Chiwilampeꞌ ri ucheꞌal ri higuera xuqujeꞌ ri nikꞌaj taq cheꞌ chik. ");
INSERT INTO quctt_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Are kakichapleꞌj ukꞌiyik loq ri kixaq, ix iwetaꞌm chi are xqet loq ri qꞌalaj. ");
INSERT INTO quctt_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Je xuqujeꞌ chiwetaꞌmaj chi are kekꞌulmataj we jastaq riꞌ, xqeteqobꞌ la riꞌ ri ajawarem rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Qas tzij kinbꞌij chiꞌwe kikꞌow na ronojel we jastaq riꞌ kꞌa te riꞌ kikꞌow we qꞌij junabꞌ riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ri kaj xuqujeꞌ ri uwachulew kasach na kiwach, are kꞌu ri nutzij man kasach ta uwach. ");
INSERT INTO quctt_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Qas chichajij iwibꞌ, rech man kakowir ta ri iwanimaꞌ rumal ri karkꞌatem, xuqujeꞌ ri qꞌabꞌarik, je xuqujeꞌ rumal kakꞌaxir iwanimaꞌ rumal taq ri jastaq rech uwachulew, rumal ta ne riꞌ maj kinabꞌej are kuriq ri qꞌij riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Rumal ri qꞌij riꞌ, je kꞌo jun kꞌaꞌmabꞌal chike konojel ri winaq rech ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Qas chixkꞌasloq, chibꞌana chꞌawem rech man kiriq ta ri kꞌaxkꞌolal ri xa jubꞌiqꞌ karaj kakꞌulmatajik, rech kixkwinik kiꞌwila uwach ri uKꞌojol ri Achi. ");
INSERT INTO quctt_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ri Jesús chi paqꞌij xuya kꞌutuꞌn pa ri Templo, chaqꞌabꞌ xeꞌ puꞌwiꞌ ri juyubꞌ ubꞌiꞌ Olivos. ");
INSERT INTO quctt_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Konojel ri winaq sibꞌalaj aqꞌabꞌ xkimulij kibꞌ chutatabꞌexik ri utzij pa ri Templo. ");
INSERT INTO quctt_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Are tajin kaqeteqobꞌ loq ri nimaqꞌij rech kaxlan wa ri maj chꞌam rukꞌ, ubꞌiꞌnam Pascua. ");
INSERT INTO quctt_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ri e kꞌamal taq bꞌe ke ri chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq, xuqujeꞌ ri aꞌjtijabꞌ rech ri taqanik, kakaj kakisach uwach ri Jesús, rumal kakixiꞌj kibꞌ chikiwach ri winaq. ");
INSERT INTO quctt_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Are kꞌu ri Itzel xok pa ranimaꞌ ri Judas ubꞌiꞌnam Iscariote, jun chike ri kabꞌlajuj tijoxelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ri Judas xeꞌ kukꞌ ri e kꞌamal taq kibꞌe ri e chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq, xuqujeꞌ ri e kꞌamal taq bꞌe ke ri chajil rech ri Templo, chuchomaxik jas jeꞌ kubꞌan chujachik ri Jesús chike. ");
INSERT INTO quctt_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Xekiꞌkot kꞌut are xkita ri xbꞌix chike, xaq jeriꞌ xkichomaj uyaꞌik pwaq che ri Judas. ");
INSERT INTO quctt_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Areꞌ xukꞌam ri pwaq, xuqujeꞌ xutzukuj jun qꞌotaj jawjeꞌ e maj wi winaq rech kujach ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Are xopan ri nimaqꞌij rech ri kaxlan wa ri maj chꞌam rukꞌ, che riꞌ xuqujeꞌ kakamisax ri chij rech ri Pascua. ");
INSERT INTO quctt_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ri Jesús xuꞌtaq bꞌik ri Pedro xuqujeꞌ ri Juan, xubꞌij chike: Jix jiꞌsukꞌumaj apanoq ri jastaq ri kajawataj chaqe, rech kaqabꞌan ri waꞌim rech Pascua. ");
INSERT INTO quctt_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ri tijoxelabꞌ xkita che: ¿Jawjeꞌ kaj wi la keꞌqabꞌana wi? ");
INSERT INTO quctt_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ri Jesús xubꞌij chike: Are kixok bꞌik pa ri tinimit, kikꞌulaj jun achi, rukꞌaꞌm jun qꞌebꞌal jaꞌ, chitereneꞌj bꞌik, kꞌa pa ri ja ri kopan wi. ");
INSERT INTO quctt_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Kꞌa te riꞌ chita che ri ajchoqꞌe ri ja, kuta ri ajtij: “¿Jawjeꞌ kꞌo wi ri ja ri kinwikꞌowisaj wi ri Pascua kukꞌ ri nutijoxelabꞌ?” ");
INSERT INTO quctt_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kukꞌut riꞌ chiꞌwach jun nima ja ri kꞌo chikaj, sukꞌumatalik, chilaꞌ chibꞌana wi ri rekeqꞌij. ");
INSERT INTO quctt_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ri e tijoxelabꞌ xebꞌe kꞌu pa ri tinimit, xeꞌkiriqa kꞌut ronojel jetaq ri xubꞌij ri Jesús chike. Xkibꞌan kꞌu ri rekeqꞌij rech ri Pascua. ");
INSERT INTO quctt_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Are xopan ri qꞌotaj rech ri waꞌim, ri Jesús xtꞌuyiꞌ kukꞌ ri utijoxelabꞌ chwi ri mexa. ");
INSERT INTO quctt_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kꞌa te riꞌ xubꞌij chike: Sibꞌalaj nurayim loq utijik waꞌ we rekeqꞌij riꞌ iwukꞌ nabꞌe cho ri nukamikal. ");
INSERT INTO quctt_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Rumal kꞌa te kintij chi waꞌ junmul are kopan ri qꞌij rech ri ajawarem rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Xukꞌam kꞌu ri qumubꞌal vino, xutyoxij che ri Dios, kꞌa te riꞌ xubꞌij: Chijacha chiꞌwach, chixqumunoq. ");
INSERT INTO quctt_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Qas tzij kinbꞌij chiꞌwe chi man kinqumuj ta chi na ri uwaꞌl uva, kꞌa pa ri qꞌij ri kape ri ajawarem rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Xuqujeꞌ xukꞌam ri kaxlan wa, are xtyoxitaj rumal che ri Dios xuya chike ri utijoxelabꞌ, xubꞌij: We kaxlan wa riꞌ are retwachil nubꞌaqil ri kajach na rumal iwe, chitijaꞌ che naꞌtabꞌal we. ");
INSERT INTO quctt_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Are xtijtaj ri kirekeqꞌij, xukꞌam ri qumubꞌal xubꞌij: Are waꞌ retwachil ri kꞌakꞌ chomanik ri kabꞌantaj na pa ri nukikꞌel ri katixtobꞌ na rumal iwe. ");
INSERT INTO quctt_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Chiwetaꞌmaj kꞌut chi kꞌo wukꞌ puꞌwiꞌ ri mexa ri uqꞌabꞌ ri kinjachow na. ");
INSERT INTO quctt_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Qas tzij ri Ukꞌojol ri Achi kajach na jetaq ri tzꞌibꞌatal loq, xa kꞌu kꞌax rech ri kajachow na. ");
INSERT INTO quctt_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ri tijoxelabꞌ kꞌut xkichapleꞌj utatabꞌeloꞌxik chibꞌil taq kibꞌ: ¿Jachin kabꞌanow na wa we riꞌ? ");
INSERT INTO quctt_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Xuqujeꞌ kakitatabꞌela chibꞌil taq kibꞌ jachin ri nim ubꞌanik chikixoꞌl. ");
INSERT INTO quctt_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ri Jesús kꞌut xubꞌij chike: Ri e taqanel pa kiwiꞌ ri e tinimit kakibꞌan kꞌax chike ri kiwinaq, xuqujeꞌ are keqꞌinomar pa kiwiꞌ ri winaq, kakibꞌij chi sibꞌalaj e utz, xa kꞌu man je ta riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Man jeꞌ ta kꞌu riꞌ kixnoꞌjin ix, xane ri winaq ri karaj kux nim uqꞌij, rajawaxik kunitzꞌarisaj ribꞌ. Xuqujeꞌ ri karaj kataqanik are chuxoq patanijel. ");
INSERT INTO quctt_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Rumal ¿jachin ta kꞌu riꞌ ri nim uqꞌij? ¿La are ri winaq ri katꞌuyiꞌ chwi ri mexa o are ri kapatanijik? ¿La man kꞌu are nim uqꞌij ri katꞌuyiꞌ puꞌwiꞌ ri mexa? Pune jeriꞌ, in kꞌo in chiꞌxoꞌl che ipatanixik. ");
INSERT INTO quctt_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ix kꞌut, ixkꞌolinaq wukꞌ pa ronojel ri kꞌaxkꞌolal ri wikꞌowisam. ");
INSERT INTO quctt_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Rumal kꞌu riꞌ kinya chiꞌwe ri jun ajawarem, jetaq ri xuya chwe in, ri tataxel. ");
INSERT INTO quctt_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Rech kixtꞌuyiꞌ na wukꞌ pa ri nuajawarem, xuqujeꞌ kixtꞌuyiꞌ pa ri jeꞌlik tem kiqꞌat tzij pa kiwiꞌ ri lajuj wok winaq aꞌj Israel. ");
INSERT INTO quctt_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simón, ri Itzel xatuto rech karetzꞌabꞌej awach, jetaq ri kakꞌulmataj rukꞌ ri tiriko. ");
INSERT INTO quctt_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Xa kꞌu xinbꞌan chꞌawem paꞌwiꞌ rech man kattzaq ta pa ri akojobꞌal, xuqujeꞌ are kattzalij wukꞌ kaya kichuqꞌabꞌ ri awachalal. ");
INSERT INTO quctt_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Xubꞌij ri Simón Pedro che: Rajawam nukꞌuꞌx kineꞌ ukꞌ la, pune keꞌ la pa ri cheꞌ, xuqujeꞌ we kakam la. ");
INSERT INTO quctt_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ri Jesús xubꞌij: Pedro, kamik are majaꞌ katzitziriqiꞌn ri akꞌ, kawawaj na ubꞌixik oxibꞌ mul chi awetaꞌm nuwach. ");
INSERT INTO quctt_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kꞌa te riꞌ xubꞌij ri Jesús chike konojel ri utijoxelabꞌ: Are xixintaq bꞌik, xinbꞌij chiꞌwe chi maj kꞌolibꞌal irajil kikꞌambꞌik, xuqujeꞌ maj ixajabꞌ kikꞌambꞌik, ¿la kꞌo kꞌu xajawataj chiꞌwe? Ri tijoxelabꞌ xkibꞌij: Man kꞌo taj. ");
INSERT INTO quctt_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Chanim kꞌut ri kꞌo yakbꞌal urajil chukꞌama bꞌik, je xuqujeꞌ ri kꞌo uchim, are kꞌu ri maj kꞌo rukꞌ chukꞌayij ri umanta chuloqꞌo jun usakꞌibꞌal. ");
INSERT INTO quctt_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Rumal kinbꞌij chiꞌwe chi kakꞌulmataj na ronojel ri tzꞌibꞌatal loq: Ri areꞌ xajilax chkixoꞌl ri e bꞌanal taq kꞌax. Tajin kꞌu kakꞌulmataj ri tzꞌibꞌatal loq chwij. ");
INSERT INTO quctt_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ri tijoxelabꞌ xkibꞌij: Ajawxel, kꞌo kebꞌ sakꞌibꞌal qukꞌ. Ri Jesús xubꞌij chike: Xaqareꞌ laꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Xel bꞌik ri Jesús pa ri tinimit jetaq ri naqꞌatal che, xeꞌ pa ri juyubꞌ Olivos. Ri utijoxelabꞌ xeteriꞌ bꞌik ri chirij. ");
INSERT INTO quctt_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Are xoꞌpan pa ri juyubꞌ, xubꞌij chike: Chibꞌana chꞌawem rech man kixtzaq ta pa ri mak. ");
INSERT INTO quctt_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ri Jesús kꞌut xutas apanoq ribꞌ chike ri utijoxelabꞌ, kꞌa te riꞌ xukiꞌk xubꞌan chꞌawem. ");
INSERT INTO quctt_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Xubꞌij kꞌut: Tat, kꞌo ta bꞌa ne wi, kaj la man kinriq ta waꞌ we kꞌaxal riꞌ, xa kꞌu man in taj kabꞌan we, xane lal. ");
INSERT INTO quctt_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Xukꞌut kꞌu ribꞌ jun ángel cho chuyaꞌik uchuqꞌabꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Sibꞌalaj kꞌax kꞌu ri ranimaꞌ xubꞌan kꞌu chꞌawem rukꞌ chuqꞌabꞌ, sibꞌalaj xel kꞌu pa jaꞌ, ri jaꞌ ri xel che jer kꞌo ri utzatzal ri kikꞌ xtzꞌutuw pa ri ulew. ");
INSERT INTO quctt_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Are xtoꞌtaj che chꞌawem, xtzalij kukꞌ ri utijoxelabꞌ, tajin kꞌu kewarik xubꞌuꞌriqaꞌ, rumal sibꞌalaj e qꞌiꞌtajinaq rumal ri bꞌis ri kakinaꞌo. ");
INSERT INTO quctt_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Xubꞌij ri Jesús chike: ¿Jas che tajin kixwarik? Chixwaꞌjiloq, chibꞌana chꞌawem rech man kixtzaq ta pa mak. ");
INSERT INTO quctt_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Kꞌa tajin na katzijon ri Jesús are xaq kꞌa teꞌ xoꞌpan sibꞌalaj e kꞌi winaq, nabꞌe bꞌik chikiwach jun chike ri tijoxelabꞌ ubꞌiꞌ Judas. Ri Judas xqet chuxukut ri Jesús, rech xutzꞌumaj. ");
INSERT INTO quctt_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ri Jesús xuta che ri Judas: ¿La rukꞌ jun tzꞌumanik kakꞌayij ri uKꞌojol ri Achi? ");
INSERT INTO quctt_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Are kꞌu ri e tijoxelabꞌ ri kisutim rij ri Jesús, are xkilo ri tajin kakꞌulmatajik xkibꞌij: Ajawxel, ¿la utz kujchꞌoꞌjin rukꞌ sakꞌibꞌal? ");
INSERT INTO quctt_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Jun kꞌut chike ri tijoxelabꞌ xusakꞌij bꞌik ri wiqiqꞌabꞌ uxikin ri patanil re ri kinimal ri chꞌawenel cho ri Dios chikiwach ri winaq. ");
INSERT INTO quctt_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ri Jesús xubꞌij chike: Chiya chilaꞌ. Xuchap kꞌu ri uxikin ri achi, xukunaj. ");
INSERT INTO quctt_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kꞌa te riꞌ xubꞌij chike ri e kꞌamal taq kibꞌe ri e chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq, chike ri e chajil taq ri Templo rech ri Dios, xuqujeꞌ chike ri e kꞌamal taq kibꞌe ri winaq, ri xuꞌlik chuchapik. ¿La in jun elaqꞌom kꞌut che ri kixpe chinuchapik rukꞌ sakꞌibꞌal rachiꞌl cheꞌ? ");
INSERT INTO quctt_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Xinkꞌojiꞌ ya ronojel qꞌij iwukꞌ pa ri Templo, maj ya jun xutzaq uqꞌabꞌ chwij, xa kꞌu xopan ri qꞌotaj are ri qꞌequꞌmal kabꞌan rech. ");
INSERT INTO quctt_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Xkichap kꞌu ri Jesús, xkikꞌam bꞌik cho rachoch ri ki kinimaꞌqil ri chꞌawenel cho ri Dios pa kiwiꞌ ri winaq. Ri Pedro kꞌut utereneꞌm ri Jesús, xa kꞌu naj kꞌo wi kan che. ");
INSERT INTO quctt_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Xkikuch jun qꞌaqꞌ cho ri ja, konojel xkimulij kibꞌ chirij, ri Pedro xtꞌuyiꞌ xuqujeꞌ kukꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Xa kꞌu kꞌo jun aj ikꞌ xrilo chi tꞌuyul qaj ri Pedro kukꞌ, kꞌo xukaꞌyej xubꞌij che: Waꞌ we achi riꞌ rachiꞌl xuqujeꞌ ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ri Pedro kꞌut xrawaj ubꞌixik, xubꞌij: Ixoq, man wetaꞌm ta in uwach ri achi riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Man naj ta qꞌotaj ikꞌowinaq are xpe chi jun achi, xubꞌij che ri Pedro: At xuqujeꞌ at kachiꞌl. Ri Pedro xubꞌij: Achi, man e wachiꞌl ta in. ");
INSERT INTO quctt_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Are xikꞌow jun hora, kꞌo chi jun achi xubꞌij che ri Pedro: Waꞌ we achi riꞌ rachiꞌl ri Jesús, aj Galilea xuqujeꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ri Pedro xubꞌij: Achi man wetaꞌm ta in jas riꞌ tajin katzijoj rij. Qas che ri qꞌotaj ri xutzalij uwach ri tzij, xtzitziriqiꞌn ri amaꞌ akꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Are kꞌu ri Ajawxel xtzalqꞌomijik, xukaꞌyej ri Pedro. Xnaꞌtaj kꞌu che ri Pedro jas ri bꞌiꞌtal che rumal ri Ajawxel: Kꞌamajaꞌ na katzitziriqiꞌn ri akꞌ are kawowaj uqꞌalajisaxik nuwach oxibꞌ mul. ");
INSERT INTO quctt_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Xel kꞌu loq chilaꞌ xutzoqopij jun bꞌisobꞌal laj roqꞌej. ");
INSERT INTO quctt_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ri achyabꞌ kꞌut ri e chajininaq ri Jesús xkichapleꞌj uchꞌayik xuqujeꞌ utzeꞌxik uwach. ");
INSERT INTO quctt_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Xkichꞌuq ri ubꞌoqꞌoch, kꞌa te riꞌ kakita che: Chariqaꞌ jachin xatchꞌayowik. ");
INSERT INTO quctt_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Je xuqujeꞌ sibꞌalaj kꞌi kꞌax taq tzij xkibꞌij che. ");
INSERT INTO quctt_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Are xsaqirik, xkimulij kibꞌ konojel ri e kꞌamal taq bꞌe ke ri tinimit, ri e kꞌamal taq kibꞌe ri e chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq, je xuqujeꞌ ri aꞌjtijabꞌ rech ri taqanik, xkikoj kichuqꞌabꞌ chi keꞌ ri Jesús chkiwach ri e qꞌatal taq tzij. ");
INSERT INTO quctt_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Xkibꞌij kꞌu che: chabꞌij chaqe we at ri, ri at Cristo. Ri Jesús, xubꞌij: Pune kinbꞌij chiꞌwe, riꞌ man kinikoj taj. ");
INSERT INTO quctt_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","We ta kinbꞌan xuqujeꞌ kꞌotbꞌal chiꞌ chiꞌwe, man kitzalij ta riꞌ uwach. ");
INSERT INTO quctt_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Xa kꞌu kamik riꞌ ri uKꞌojol ri Achi katꞌuyiꞌ na pa ri uwiqiqꞌabꞌ ri Dios, ri kwinel che ronojel. ");
INSERT INTO quctt_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Konojel kꞌu ri winaq junam xkibꞌij: ¿La at kꞌut at ukꞌojol ri Dios? Ri Jesús xubꞌij: Ix xixbꞌinik. ");
INSERT INTO quctt_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ri winaq kꞌut xkibꞌij: ¿La kaꞌjawataj kꞌu na winaq rech kakiqꞌalajisaj chaqe ri xubꞌij? Uj xqata rukꞌ ri qaxikin ri xubꞌij rukꞌ ri uchiꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Xewaꞌjil kꞌu konojel ri winaq, kꞌa te riꞌ xkikꞌam bꞌik ri Jesús cho ri Pilato. ");
INSERT INTO quctt_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Xkichapleꞌj kꞌu utzujuxik, jewaꞌ xkibꞌij: Xqariq we achi riꞌ, tajin kuꞌsach ri winaq pa ri qatinimit, man karaj ta xuqujeꞌ kutoj ri alkabal che ri nim qꞌatal tzij pa Roma. Kubꞌij xuqujeꞌ chi are Cristo, jun taqanel. ");
INSERT INTO quctt_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Xaq jeriꞌ ri Pilato xukꞌot uchiꞌ ri Jesús: ¿La at, ri at kitaqanel ri winaq aꞌj Israel? Ri Jesús xubꞌij che: At xatbꞌinik. ");
INSERT INTO quctt_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ri Pilato kꞌut xubꞌij chike ri e kꞌamal taq bꞌe ke ri chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq, xuqujeꞌ chike ri sibꞌalaj e kꞌi winaq: Maj mak kinriq chrij we achi riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ri winaq kꞌut xkibꞌij: We achi riꞌ uchapleꞌm loq pa Galilea xuqujeꞌ pa ronojel Judea, xul kꞌa waral, rukꞌ ri ukꞌutuꞌn, kusach kikꞌuꞌx ri winaq rech ri tinimit. ");
INSERT INTO quctt_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Are xuta ri Pilato ri xbꞌix che, xuta chike ri winaq we aꞌj Galilea ri achi ri. ");
INSERT INTO quctt_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Xutabꞌej kꞌu rech chi ri Jesús kel pa ri tinimit jawjeꞌ ri kaqꞌatow wi tzij ri Herodes, xuꞌtaq bꞌik je laꞌ, rumal che taq ri qꞌij riꞌ, ri Herodes kꞌo pa Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ri Herodes are xril ri Jesús sibꞌalaj xkiꞌkotik, rumal cher rayeꞌm karil jun nimalaj kꞌutbꞌal jetaq ri kubꞌan ri Jesús, xaq utom ri kakitzijoj ri winaq chirij ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Xuta kꞌu sibꞌalaj kꞌi kꞌotbꞌal chi che ri Jesús, xa ta kꞌu ne jun tzij xubꞌij ri Jesús che. ");
INSERT INTO quctt_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kakimol kꞌu koq umak ri e kꞌamal taq kibꞌe ri e chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq, xuqujeꞌ ri aꞌjtijabꞌ rech ri taqanik, kakimol koq umak. ");
INSERT INTO quctt_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ri Herodes kꞌut xuqujeꞌ ri e rajchꞌoꞌjabꞌ chajil tinimit xkichapleꞌj uyoqꞌik ri Jesús xuqujeꞌ kaketzelaj uwach. Xetaqan kꞌu chukojik jun atzꞌyaq ri sibꞌalaj kachuplinik chirij ri Jesús, kꞌa te riꞌ xkitaq chi bꞌik junmul cho ri Pilato. ");
INSERT INTO quctt_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ri Herodes xuqujeꞌ ri Pilato man kechꞌabꞌen ta ibꞌ kanoq, xa kꞌu che ri qꞌij riꞌ xuꞌtzirik. ");
INSERT INTO quctt_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Xuꞌmulij kꞌu ri Pilato ri e kꞌamal taq kibꞌe ri e chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq, xuqujeꞌ ri e qꞌatal taq tzij, je xuqujeꞌ ri winaq. ");
INSERT INTO quctt_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Pilato xubꞌij chike ri winaq: Ix xikꞌam loq we achi riꞌ, kitzujuj chi tajin kuꞌtaqchiꞌj ri winaq che ubꞌanik itzel taq jastaq, are xinkꞌot uchiꞌ, xiwilo chi maj mak xinriq che. ");
INSERT INTO quctt_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Xuqujeꞌ qꞌalaj chi ri Herodes, maj mak xuriq chirij rumal laꞌ xutzalijisaj loq chinuwach, xaq jeriꞌ, chiwilaꞌ chi maj jun makaj xubꞌano ri rumal re yaꞌtalik kakamik. ");
INSERT INTO quctt_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Rumal kꞌu la kintaqan chuchꞌayik, kꞌa te riꞌ kintzoqopij bꞌik. ");
INSERT INTO quctt_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Xa kꞌu naqꞌatal wi che ri Pilato, pa taq ri nimaqꞌij rech Pascua, kutzoqopij jun bꞌanal kꞌax. ");
INSERT INTO quctt_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Are kꞌu ri winaq pa junamam xkibꞌij: Chakamisaj le achi leꞌ, are chatzoqopij ri Barrabás. ");
INSERT INTO quctt_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ri Barrabás kꞌut jun achi, kojtal pa cheꞌ rumal ri kꞌax ubꞌanom pa ri tinimit, xuqujeꞌ rumal kamisanik. ");
INSERT INTO quctt_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ri Pilato rumal are karaj kutzoqopij ri Jesús xuta chi junmul chike ri winaq. ");
INSERT INTO quctt_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ri winaq kꞌut xkiraq kichiꞌ, xkibꞌij: ¡Ripoq! ¡Ripoq! ");
INSERT INTO quctt_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Xchꞌaw chi ri Pilato churox mul, xuta chike ri winaq: ¿Jas kꞌu ri xumakuj we achi ri? Man kꞌo ta makaj ubꞌanom ri rumal ri taqalik kakamik, pune jeriꞌ kintaqan chuchꞌayik, kꞌa te riꞌ kintzoqopij bꞌik. ");
INSERT INTO quctt_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ri winaq kꞌut man xetaniꞌ ta churaqik kichiꞌ, xkita chi kakamisax ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Kꞌisbꞌal rech, ri Pilato xuya bꞌe che ri xkitoqꞌij ri winaq. ");
INSERT INTO quctt_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Xutzoqopij ri achi ri xkitoqꞌij ri winaq, ri kꞌo pa cheꞌ rumal man kaniman taj chike ri qꞌatbꞌal tzij xuqujeꞌ rumal kamisanik ri ubꞌanom, xuqujeꞌ xuya bꞌe chike ri winaq kakibꞌan rukꞌ ri Jesús jas ri karaj kikꞌuꞌx. ");
INSERT INTO quctt_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Are xkikꞌam bꞌik ri Jesús pa ripik, xkibꞌij che ri jun achi ubꞌiꞌ Simón ri kel pa ri tinimit Cirene, utzalijik loq che ri uchak cho ri saq, kareqaj bꞌik ri ripbꞌal, kutereneꞌj ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","E kꞌi winaq ri aꞌj pa ri tinimit xkitereneꞌj ri Jesús, xuqujeꞌ e kiꞌ ixoqibꞌ, ri xkitꞌikitaꞌ uwa kikꞌuꞌx. xkibꞌisoj uwach ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ri Jesús kꞌut xtzalqꞌomijik, xubꞌij chike: Ixoqibꞌ aꞌj Jerusalén, man kiniwoqꞌej taj in, are chiwoqꞌej iwibꞌ ix, xuqujeꞌ chiꞌwoqꞌej ri iꞌwal. ");
INSERT INTO quctt_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Qas tzij kinbꞌij chiꞌwe, kuꞌriqa na qꞌotaj ri kabꞌix na, utz ke ri ixoqibꞌ ri man kekꞌojiꞌ ta kal, xuqujeꞌ ri man xetubꞌisan ta wi. ");
INSERT INTO quctt_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kakibꞌij kꞌu na chike ri juyubꞌ, Chixtzaq loq pa qawiꞌ, xuqujeꞌ kakibꞌij na chike ri juyubꞌ. Chujichꞌuqu kanoq. ");
INSERT INTO quctt_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Rumal we kabꞌan we riꞌ, are rax ri cheꞌ, jas ta kꞌu ri man kakꞌulmataj taj are chaqiꞌj ri cheꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Xuqujeꞌ ri winaq xeꞌkikꞌam bꞌik kebꞌ e bꞌanal taq kꞌax rech kekamisax xuqujeꞌ kanoq. ");
INSERT INTO quctt_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Are xoꞌpan pa ri jun leꞌaj ubꞌiꞌnam Calavera, xkirip ri Jesús xuqujeꞌ ri e kebꞌ e bꞌanal taq kꞌax, jun pa ri uwiqiqꞌabꞌ ri Jesús, jun pa ri umox. ");
INSERT INTO quctt_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Xubꞌij kꞌu ri Jesús: Tataxel, kuyu la kimak, xa man ketaꞌm ta la ri kakibꞌano. Are jewaꞌ tajin kubꞌij, xoꞌk che retzꞌabꞌexik jachin kechꞌabꞌen kan ri ratzꞌyaq ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Are kꞌu ri winaq kakikaꞌyej apanoq ri Jesús, ri e qꞌatal taq tzij kꞌut kakiyoqꞌ apanoq ri Jesús, xkibꞌij: Xuꞌkol ya nikꞌaj winaq chik. We kꞌu qas are Cristo, ri chaꞌtalik, chukolo xuqubꞌa ribꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Xeqet xuqujeꞌ ri ajchꞌoꞌjabꞌ chajil tinimit, xkichapleꞌj uyoqꞌik ri Jesús, xkitzuj kꞌu vinagre che. ");
INSERT INTO quctt_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Xkibꞌij che: Chakolo awibꞌ we at riꞌ ri at kirey ri winaq aꞌj Israel. ");
INSERT INTO quctt_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kojom kꞌu jun tzꞌibꞌatalik puꞌwiꞌ ri Jesús, ri kubꞌij: ARE WAꞌ RI KIREY RI WINAQ AꞌJ ISRAEL. ");
INSERT INTO quctt_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jun chike ri e bꞌanal taq kꞌax, ri riptalik xuchapleꞌj uyoqꞌik ri Jesús, xubꞌij che: ¿La man kꞌu at riꞌ ri at Cristo? Chakolo awibꞌ xuqujeꞌ chujakolo uj. ");
INSERT INTO quctt_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ri jun bꞌanal kꞌax chik xuyaj ri rachiꞌl xubꞌij: ¿Man kaxiꞌj ta ne lo awibꞌ cho ri Dios, pune tajin kaqꞌat tzij paꞌwiꞌ? ");
INSERT INTO quctt_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ri uj qas taqal chaqe we qꞌatoj tzij kabꞌan chaqe, rumal are tajin kaqatoj ri qamak, are kꞌu we achi riꞌ, maj etzelal ubꞌanom. ");
INSERT INTO quctt_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kꞌa te riꞌ xubꞌij che ri Jesús: Chinnaꞌtaj che la are kape la pa ri ajawarem e la. ");
INSERT INTO quctt_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ri Jesús xubꞌij che: Qas tzij kinbꞌij chawe, kamik katkꞌojiꞌ na wukꞌ pa ri jeꞌlalaj kꞌolibꞌal. ");
INSERT INTO quctt_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ri uwachulew kꞌut xmuqiꞌ pa ri qꞌequꞌmal, xchapleꞌtaj pa ri unikꞌaj qꞌij kꞌa pa ri unikꞌaj ri bꞌenaq qꞌij. ");
INSERT INTO quctt_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Xchup ri qꞌij, xuqujeꞌ xjisjobꞌ pa kebꞌ ri tasbꞌal upam ri tyoxalaj kꞌolibꞌal ri kꞌo pa ri Templo re ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Are kꞌu ri Jesús rukꞌ chuqꞌabꞌ xuraq uchiꞌ, xubꞌij: Tat, kinwuqxaꞌnij ri wanimaꞌ pa ri qꞌabꞌ la, kꞌa te riꞌ xkamik. ");
INSERT INTO quctt_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ri kinimaꞌqil ri ajchꞌoꞌjabꞌ chajil tinimit, are xril ri xkꞌulmatajik, xuqꞌijilaꞌj ri Dios, xubꞌij: Qas tzij sibꞌalaj sukꞌ waꞌ we achi riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Konojel kꞌu ri winaq ri xkimulij kibꞌ che rilik ri xkꞌulmatajik, kakitꞌikitaꞌ ri uwo kikꞌuꞌx ");
INSERT INTO quctt_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Are kꞌu ri winaq ri ketaꞌm uwach ri Jesús xuqujeꞌ ri ixoqibꞌ ri xkitereneꞌj loq are xel loq pa Galilea, kakikaꞌyej apanoq, naj e kꞌo wi che. ");
INSERT INTO quctt_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kꞌo kꞌu jun achi, jun utz achi, sukꞌ ranimaꞌ, ubꞌiꞌnam José, kachiꞌl ri e kꞌamal taq bꞌe. ");
INSERT INTO quctt_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Man xukꞌam ta kꞌu uqꞌabꞌ rukꞌ ri kichomanik ri rachiꞌl, xuqujeꞌ rukꞌ ri xenoꞌjinik. Ri achi riꞌ kel pa ri tinimit Arimatea, rayeꞌm ri upetibꞌal ri ajawarem rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","We achi riꞌ xuta ri ubꞌaqil ri Jesús che ri Pilato rech kuꞌmuqu kanoq. ");
INSERT INTO quctt_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Are xqasataj loq rumal, xubꞌolqꞌotij bꞌik pa ri jun atzꞌyaq bꞌantal che lino, xuꞌya kan pa ri muqbꞌal ri kꞌo pa ri jun abꞌaj, jawjeꞌ xa ta ne jun winaq muqtal chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","We qꞌij riꞌ are qꞌij rech bꞌanbꞌal taq jastaq rech ri qꞌij rech uxlanem, ri jubꞌiqꞌ karaj kachapleꞌtajik. ");
INSERT INTO quctt_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ri ixoqibꞌ ri xeteriꞌ loq chirij ri Jesús are xel loq pa Galilea xkitereneꞌj bꞌik ri José, xeꞌkilaꞌ jawjeꞌ kamuqiꞌ wi kan ri Jesús, xuqujeꞌ jas kabꞌan kan che ri ubꞌaqil pa ri jul. ");
INSERT INTO quctt_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kꞌa te riꞌ xetzalij cho kachoch, xkitzukuj ri kꞌokꞌalaj taq kunabꞌal. Kꞌa te riꞌ xuxlanik jetaq ri kubꞌij ri taqanik. ");
INSERT INTO quctt_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sibꞌalaj aqꞌabꞌ xebꞌe ri ixoqibꞌ pa ri nabꞌe qꞌij rech ri wuq qꞌij, xoꞌpan kꞌu chuchiꞌ ri muqbꞌal. Xkikꞌam bꞌik ri kꞌokꞌalaj taq kunabꞌal ri kiyakom kanoq. ");
INSERT INTO quctt_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Kꞌa te xkilo esatal kan ri abꞌaj chuchiꞌ ri muqbꞌal. ");
INSERT INTO quctt_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Are kꞌu xoꞌk bꞌik, man xkiriq ta ri ubꞌaqil ri Ajawxel Jesús. ");
INSERT INTO quctt_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Are kꞌu tajin kakitzijoj rij ri xkꞌulmatajik, xaq kꞌa teꞌ xetakꞌatobꞌ e kebꞌ achyabꞌ kachuplin ri katzꞌyaq. ");
INSERT INTO quctt_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Xkixiꞌj kꞌu kibꞌ ri ixoqibꞌ, xexukiꞌk xkiya ri kipalaj pa ri ulew, ri achyabꞌ kꞌut xkibꞌij chike: ¿Jas che kitzukuj ri Kꞌaslik chikixoꞌl ri kaminaqibꞌ? ");
INSERT INTO quctt_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Man kꞌo ta waral, xkꞌastaj uwach, naꞌtaj chiꞌwe ri xubꞌij chiꞌwe are kꞌo na iwukꞌ je laꞌ pa Galilea: ");
INSERT INTO quctt_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Ri uKꞌojol ri Achi kajach na pa kiqꞌabꞌ ri achyabꞌ aꞌjmakibꞌ, karip xuqujeꞌ na, churox qꞌij kꞌut kakꞌastaj na uwach.” ");
INSERT INTO quctt_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Are jewaꞌ xkito, xnaꞌtaj kꞌu chike ri utzij ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Are xetzalij loq, xiltaj kan ri muqbꞌal kumal, xkitzijoj ronojel ri xkilo, chike ri e lajuj, xuqujeꞌ chike konojel ri e kꞌo chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Are waꞌ ri ixoqibꞌ ri xeꞌkisolij ri muqbꞌal: ri María Magdalena, ri Juana, ri María unan ri Jacobo, xuqujeꞌ nikꞌaj ixoqibꞌ chik. ");
INSERT INTO quctt_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Are kꞌu ri tijoxelabꞌ man xkikoj taj ri xbꞌix chike, pa kikꞌuꞌx chi xaq kikonal ri ixoqibꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ri Pedro kaxikꞌanik, xeꞌek pa ri muqbꞌal, xqet chuxukut. Are xkꞌayik, xwiꞌ kꞌo kan ri atzꞌyaq rech lino, ri xbꞌalqꞌotix wi ri Jesús. Kamayijan kꞌut, xtzalij cho rachoch rumal ri xkꞌulmatajik. ");
INSERT INTO quctt_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Pa we qꞌij riꞌ e bꞌenaq pa ri bꞌe kebꞌ chike ri tijoxelabꞌ. Bꞌenam ke pa jun alaj tinimit ubꞌiꞌ Emaús, julajuj kilómetros uxoꞌl rukꞌ ri tinimit Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Are kakitzijoj rij ri xkꞌulmataj pa ri tinimit Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tajin kꞌu kakitzijoj rij are xqet ri Jesús, xuchapleꞌj bꞌinem kukꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Man xkichꞌobꞌ ta kꞌu uwach rumal cher tzꞌapital ri kibꞌoqꞌoch. ");
INSERT INTO quctt_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Xukꞌot kꞌu kichiꞌ, xubꞌij: ¿Jas ri tajin kitzijoj la rij? Ri e tijoxelabꞌ xetakꞌiꞌ, xkichiqibꞌa ri kipalaj pa ri ulew. ");
INSERT INTO quctt_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jun chike ri tijoxelabꞌ ubꞌiꞌnam Cleofas xubꞌij che: ¿La xaq xwi ri at, ri at solinel pa ri tinimit Jerusalén, ri man xawetaꞌmaj ta ri xkꞌulmatajik? ");
INSERT INTO quctt_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ri Jesús xuta chike: ¿Jas kꞌu riꞌ ri xkꞌulmatajik? Are ri Jesús aj Nazaret, jun qꞌalajisal utzij ri Dios, sibꞌalaj kwinel che nimaq taq chak, xuqujeꞌ sibꞌalaj utz ri katzijon cho ri Dios xuqujeꞌ chkiwach ri winaq. ");
INSERT INTO quctt_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Are kꞌu ri e qꞌatal taq qatzij, xuqujeꞌ ri e kꞌamal taq kibꞌe ri e chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq xkijacho rech kaqꞌat tzij puꞌwiꞌ, rech kakamisaxik xuqujeꞌ rech karipik. ");
INSERT INTO quctt_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Kuꞌl kꞌu qakꞌuꞌx uj chi areꞌ kakolow ri qatinimit Israel, xeꞌ kꞌu oxibꞌ qꞌij ri xbꞌantaj we kꞌulmatajem riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","E kꞌo xuqujeꞌ e nikꞌaj e qachiꞌl ixoqibꞌ ri xebꞌe pa ri muqbꞌal che we aqꞌabꞌil riꞌ, xilkitzijoj kꞌu ri mayijabꞌal jastaq chaqe. ");
INSERT INTO quctt_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Man xkiriq ta ri ubꞌaqil ri Jesús, xaq xwi xkitzijoj chaqe chi xkikꞌut kibꞌ jujun angelibꞌ chkiwach, xkibꞌij chike chi ri Jesús kꞌaslik. ");
INSERT INTO quctt_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","E kꞌo chi kꞌu nikꞌaj e qachiꞌl ri xebꞌe pa ri muqbꞌal, xeꞌkiriqaꞌ jetaq ri xulkibꞌij ri qachiꞌl ixoqibꞌ chaqe, xa kꞌu man xkil ta uwach ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ri Jesús xubꞌij chike: Sibꞌalaj maj iwetaꞌmabꞌal, xuqujeꞌ sibꞌalaj kakabꞌalaj ikꞌuꞌx, chukojik ronojel ri xkibꞌij kan ri e qꞌalajisal taq utzij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿La man kꞌu choqꞌaqꞌ na kuriq taq waꞌ we kꞌax riꞌ, ri Cristo are majaꞌ kok pa ri rajawarem? ");
INSERT INTO quctt_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Xuchapleꞌj kꞌu utzijoxik rij ri bꞌiꞌtal loq chirij kumal ri e qꞌalajisal taq rech ri utzij ri Dios, xuchapleꞌj la rukꞌ ri Moisés xuqujeꞌ konojel ri e qꞌalajisal taq rech ri utzij ri Dios, ri kitzꞌibꞌam loq pa ri uchoch wuj. ");
INSERT INTO quctt_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Are xenaqajin che ri leꞌaj ri kekanaj wi kan ri tijoxelabꞌ, ri Jesús xujaluj chi naj ri keꞌ wi na. ");
INSERT INTO quctt_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ri tijoxelabꞌ kꞌut xkibꞌij che: Xeꞌ le qꞌij, chatkanaj kan qukꞌ, kok aqꞌabꞌ chawe. Xaq jeriꞌ xkanaj kan kukꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Are e kꞌo puꞌwiꞌ ri mexa, xukꞌam ri kaxlan wa, xutewechiꞌj, xupirij, kꞌa te riꞌ xujach chike. ");
INSERT INTO quctt_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Xjaqataj kꞌu ri kibꞌoqꞌoch, xkichomaj kꞌu uwach, xaq kꞌu kꞌa teꞌ xsachik. ");
INSERT INTO quctt_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kakibꞌij kꞌu chibꞌil taq kibꞌ: ¿La chi man kaqꞌaqꞌan ri qanimaꞌ are tajin katzijon la qukꞌ pa ri bꞌe chirij ri uchoch wuj? ");
INSERT INTO quctt_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Aninaq xewaꞌjilik, xetzalij loq pa Jerusalén, chilaꞌ xuleꞌkiriqa wi ri e julajuj tijoxelabꞌ, kimulim kibꞌ, xuqujeꞌ ri e winaq ri e kꞌo kukꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ri e julajuj xkibꞌij che: Qas xkꞌastaj wi ri Ajawxel, xukꞌut ribꞌ cho ri Simón. ");
INSERT INTO quctt_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ri e kebꞌ tijoxelabꞌ kꞌut xkitzijoj jas ri xkꞌulmataj kukꞌ pa ri bꞌe, xuqujeꞌ xkitzijoj chi kꞌa te xkichꞌobꞌ uwach ri Jesús are xujach ri kaxlan wa. ");
INSERT INTO quctt_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kꞌa tajin na kakitzijoj rij ri xkꞌulmatajik, are xtakꞌatobꞌ ri Jesús chikixoꞌl. “Jaꞌmaril chiꞌwe,” xcha chike. ");
INSERT INTO quctt_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Sibꞌalaj xkixiꞌj kibꞌ pa kikꞌuꞌx chi jun subꞌunel xkilo. ");
INSERT INTO quctt_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ri Jesús kꞌut xuta chike: ¿Jas che sibꞌalaj kixiꞌj iwibꞌ? ¿Jas che sibꞌalaj kakabꞌalaj ikꞌuꞌx? ");
INSERT INTO quctt_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Chiwila le waqan xuqujeꞌ le nuqꞌabꞌ. Qas in wi, chinichapaꞌ rech qas kiwilo. Jun uxlabꞌal maj bꞌaq che xuqujeꞌ maj utyoꞌjal, ri in kꞌut utz kinichapo. ");
INSERT INTO quctt_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Are xbꞌiꞌtaj we riꞌ, xukꞌut ri uqꞌabꞌ xuqujeꞌ ri raqan chkiwach. ");
INSERT INTO quctt_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kꞌamajaꞌ kꞌu kakikojo chi qas areꞌ, rumal ri kiꞌkotemal xuqujeꞌ rumal kemayijanik, ri Jesús kꞌut xuta chike: ¿La kꞌo jastaq tijowik rij iwukꞌ? ");
INSERT INTO quctt_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Xkiya kꞌu chꞌaqaꞌp bꞌolom kar che. ");
INSERT INTO quctt_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Xukꞌam kꞌut, kꞌa te riꞌ chkiwach xutijo, kꞌa te riꞌ xubꞌij chike: ");
INSERT INTO quctt_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Are xinkꞌojiꞌ iwukꞌ, xinbꞌij chiꞌwe chi kakꞌulmataj ronojel ri tzꞌibꞌatal loq chwij, pa ri taqanik rech ri Moisés, xuqujeꞌ pa ri kiwuj ri e qꞌalajisal taq rech ri utzij ri Dios, xuqujeꞌ pa ri wuj rech Salmos. ");
INSERT INTO quctt_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Xujaq kꞌu ri kichomabꞌal rech kakichꞌobꞌ ri tzꞌibꞌatal kan pa ri uchoch wuj. ");
INSERT INTO quctt_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Xubꞌij kꞌu chike: Are waꞌ ri tzꞌibꞌatalik: “Ri Cristo kuriq na kꞌax, xuqujeꞌ kakꞌastaj na churox qꞌij. ");
INSERT INTO quctt_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Xuqujeꞌ pa ri ubꞌiꞌ katzijox na ri kꞌexoj kꞌuꞌx xuqujeꞌ ri kuybꞌal mak pa ronojel ri tinimit, kachapleꞌtaj bꞌik pa Jerusalén.” ");
INSERT INTO quctt_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ri ix ix qꞌalajisal taq rech waꞌ we jastaq riꞌ. ");
INSERT INTO quctt_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Kintaq kꞌu na loq, ri utzujum kan ri nuTat chiꞌwe, xaq jeriꞌ chixkanaj na kanoq pa we tinimit riꞌ, kꞌa kayaꞌtaj na ri chuqꞌabꞌ rech chikajil chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Te kꞌu riꞌ xuꞌkꞌam bꞌik ri utijoxelabꞌ, chuxukut ri tinimit Betania, xuyak kꞌu ri uqꞌabꞌ xuꞌtewechiꞌj. ");
INSERT INTO quctt_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Tajin kꞌu kuꞌtewechiꞌj na are xnajtin chike, rumal xkꞌam bꞌik chikaj. ");
INSERT INTO quctt_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ri utijoxelabꞌ kꞌut xkiqꞌijilaꞌj, kꞌa te riꞌ sibꞌalaj xekiꞌkotik xetzalij pa ri tinimit Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Amaqꞌel kꞌut xekꞌojiꞌ pa ri Templo xkiqꞌijilaꞌj ri Dios.");
INSERT INTO quctt_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Pa ri majibꞌal tzi kꞌo chi wi ri Tzij, ri Tzij kꞌo rukꞌ ri Dios, ri Tzij are Dios xuqujeꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ri Tzij kꞌo wi loq rukꞌ ri Dios pa ri majibꞌal rech ronojel. ");
INSERT INTO quctt_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Rumal rech Areꞌ xbꞌan ronojel ri jastaq, we ta mat rumal rech areꞌ mat xbꞌan ronojel ri jastaq ri kꞌolik. ");
INSERT INTO quctt_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Pa Areꞌ kꞌo wi loq ri kꞌaslemal, xuqujeꞌ ri kꞌaslemal are kitunal ri winaq. ");
INSERT INTO quctt_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Are waꞌ ri tunal ri katunan pa ri qꞌequꞌmal, man kwininaq taj ri qꞌequꞌmal chuchupisaxik. ");
INSERT INTO quctt_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Kꞌo jun achi ri xtaq loq rumal ri Dios, ubꞌiꞌnam Juan. ");
INSERT INTO quctt_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Xtaq loq chuqꞌalajisaxik ri tunal, rech rumal re kekojon konojel ri winaq. ");
INSERT INTO quctt_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Man are taj tunal ri Juan, xwi xpe che uqꞌalajisaxik ri Tunal. ");
INSERT INTO quctt_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ri qas tzij tunal, ri kuꞌtunaj konojel winaq, xpe choch ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ri tunal kꞌo chi wi choch ri uwachulew, are xtikow ronojel ri uwachulew, ri winaq kꞌut aꞌjuwachulew man xkichꞌobꞌ taj uwach ri Tzij. ");
INSERT INTO quctt_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Xpe rukꞌ ri e rech, ri e rech man xkikꞌamawaꞌj taj. ");
INSERT INTO quctt_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Are kꞌu ri xkikꞌamawaꞌj ri Tzij, ri xekojon che, xyaꞌtaj chike xuꞌx e ralkꞌwaꞌl ri Dios. ");
INSERT INTO quctt_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","We riꞌ man xkꞌiy ta loq che winaq xuqujeꞌ man xaq ta kꞌa teꞌ xkꞌiy loq, man urayibꞌal achi taj, xane che ri Dios xkꞌiy wi loq. ");
INSERT INTO quctt_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ri Tzij xux winaq, xkꞌojiꞌk chiqaxoꞌl. Xqil ri ujuluwem, are ujuluwem ri xa jun uKꞌojol ri Tataxel Dios, nojinaq che toqꞌobꞌ xuqujeꞌ qas tzij. ");
INSERT INTO quctt_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ri Juan xuqꞌalajisaj rij ri uKꞌojol ri Dios are xubꞌij: Areꞌ wa ri nutzijom loq chiꞌwe, are xinbꞌij: “Ri teren loq chwij, sibꞌalaj nim na chinuwach in, rumal cher kꞌo wi loq nabꞌe chinuwach in.” ");
INSERT INTO quctt_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Che ri uqꞌinomal qonojel uj xqakꞌamawaꞌj toqꞌobꞌ puꞌwiꞌ toqꞌobꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Jeriꞌ rumal cher ri taqanik che ri Moisés xya wi, are kꞌu ri toqꞌobꞌ xuqujeꞌ ri qas tzij are ri Jesucristo xyoꞌw chaqe. ");
INSERT INTO quctt_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Man kꞌo ta wi jun winaq ilowinaq uwach ri Dios. Xwi ri xa jun ukꞌojol ri Dios, ri kꞌo uriqoj ibꞌ rukꞌ ri Tataxel, Areꞌ xkꞌutuw ri Dios chiqawach. ");
INSERT INTO quctt_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Are waꞌ ri xubꞌij ri Juan chike ri e rijaꞌl ri Leví xuqujeꞌ ri e chꞌawenelabꞌ choch ri Dios ri xetaq bꞌik kumal ri winaq chutayik che jachin ri areꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Man xrawaj taj uqꞌalajisaxik, xane xubꞌij: Man in taj in Cristo. ");
INSERT INTO quctt_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ri winaq xkita che: ¿Jachin kꞌu ri at? ¿La at kꞌut at Elías? Man in taj, xchaꞌ. ¿La at kꞌut ri at qꞌalajisal tzij? Man in ta xuqujeꞌ, xchaꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","¿Jachin kꞌu ri at? xecha che. Choqꞌaqꞌ kaqetaꞌmaj rech keꞌqabꞌij chike ri xujtaqow loq. ");
INSERT INTO quctt_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ri Juan xukoj ri utzij ri qꞌalajisal utzij ri Dios Isaías, are xubꞌij: Uchꞌabꞌal jun winaq ri kuraq uchiꞌ pa ri katzꞌinow ulew, kubꞌij: “Chisukꞌumaj ri ubꞌe ri Ajawxel.” ");
INSERT INTO quctt_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","E kꞌo jujun winaq ri xetaq bꞌik kumal ri fariseos. ");
INSERT INTO quctt_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Xkita che: ¿Jas kꞌu che kabꞌan qasanaꞌ we man at at Cristo, man at taj at Elías xuqujeꞌ man at taj ri at Qꞌalajisal utzij ri Dios? ");
INSERT INTO quctt_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ri Juan xubꞌij: Ri in kinbꞌan qasanaꞌ rukꞌ jaꞌ. Kꞌo kꞌu jun ri kꞌo chi ixoꞌl ri man iwetaꞌm taj uwach. ");
INSERT INTO quctt_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Areꞌ teren loq chwij, man taqal taj chwe in kinkir ri jatꞌibꞌal rech ri uxajabꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ronojel we jastaq riꞌ xkꞌulmataj pa ri tinimit Betania, chꞌaqaꞌp che ri nimaꞌ Jordán, jawjeꞌ tajin kubꞌan wi qasanaꞌ ri Juan. ");
INSERT INTO quctt_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Chukabꞌ qꞌij ri Juan xril ri Jesús are tajin kanaqajin loq che, xubꞌij: ¡Chiwilampeꞌ! ¡Are waꞌ ri alaj uchij ri Dios ri karesaj makaj choch ronojel ri uwachulew! ");
INSERT INTO quctt_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Are waꞌ ri xintzijoj are xinbꞌij chiꞌwe: “Teren loq jun achi ri chwij ri nim ubꞌanik chinuwach, jeriꞌ rumal tzi kꞌo wi loq Areꞌ, are kꞌa majaꞌ kinkꞌojiꞌ in.” ");
INSERT INTO quctt_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Man wetaꞌm ta in uwach nabꞌe, xinbꞌan kꞌu kiqasanaꞌ ri winaq pa jaꞌ, rech jeriꞌ kukꞌut ribꞌ chikiwach. ");
INSERT INTO quctt_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ri Juan xubꞌij: Ri in xinwilo ri Uxlabꞌixel jer xubꞌan jun palomax xqaj loq puꞌwiꞌ ri Areꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Man wetaꞌm ta in uwach nabꞌe, are kꞌu ri xintaqow loq chubꞌanik qasanaꞌ pa jaꞌ xubꞌij chwe: “Ri kawilo kaqaj ri Uxlabꞌixel puꞌwiꞌ are riꞌ ri kabꞌanow qasanaꞌ rukꞌ ri Uxlabꞌixel.” ");
INSERT INTO quctt_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ri in wilom we riꞌ rumal riꞌ kinqꞌalajisaj chi areꞌ are uKꞌojol ri Dios. ");
INSERT INTO quctt_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Che ri jun qꞌij chik ri Juan junmul chik kꞌo chilaꞌ, e rachiꞌl kebꞌ chike ri utijoxelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Are xrilo chi tajin kikꞌow bꞌik ri Jesús chilaꞌ, xubꞌij: ¡Chiwilampeꞌ! Chi riꞌ kꞌo wi we alaj uchij ri Dios ri kukuy makaj. ");
INSERT INTO quctt_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Are xkita ri e kebꞌ utijoxelabꞌ ri Juan chi jeriꞌ xubꞌij, xeteriꞌ bꞌik chirij ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Xtzalqꞌomij ri Jesús, kꞌa te xeꞌrilo e teren ri kebꞌ tijoxelabꞌ chirij, xuta chike: ¿Jas kitzukuj? Areꞌ xkibꞌij: Ajtij, ¿jawjeꞌ kꞌo wi ri achoch la? ");
INSERT INTO quctt_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ri Jesús xubꞌij chike: Chixanloq jiliwilaꞌ. Ri tijoxelabꞌ xebꞌek, xeꞌkilaꞌ jawjeꞌ kel wi ri Jesús, kꞌa te riꞌ xekanaj kan jun aqꞌabꞌ chilaꞌ, rumal cher ukaj hora chik rech bꞌenaq qꞌij. ");
INSERT INTO quctt_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ri Andrés rachalal ri Simón Pedro, jun chike ri e kebꞌ tijoxelabꞌ, xuta ri xubꞌij ri Juan, rumal riꞌ xutereneꞌj bꞌik ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ri Andrés are xuriq ri rachalal, Simón xubꞌij che. Xqarik ri Mesías, (ri kel kubꞌij Cristo). ");
INSERT INTO quctt_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ri Andrés xukꞌam bꞌik ri rachalal rukꞌ ri Jesús, ri Jesús ko xukaꞌyej ri Simón, kꞌa te riꞌ xubꞌij che: At Simón, ralkꞌwaꞌl ri Juan, kabꞌinaꞌj na Cefas, (ri kel kubꞌij Pedro). ");
INSERT INTO quctt_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Chukabꞌ qꞌij chik, ri Jesús xuchomaj keꞌ pa Galilea. Xuriq kꞌu ri Felipe, xubꞌij che: Chinatereneꞌj. ");
INSERT INTO quctt_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ri Felipe aj Betsaida, je xuqujeꞌ ri Andrés rachiꞌl ri Pedro. ");
INSERT INTO quctt_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ri Felipe xeꞌ chutzukuxik ri Natanael, are xuriqo xubꞌij che: Xqarik ri Jesús aj Nazaret, ukꞌojol ri José, are waꞌ ri xtzꞌibꞌax loq rij chupam ri wuj rech taqanik rech ri Moisés xuqujeꞌ chupam ri wuj kech ri e qꞌalajisal taq tzij rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ri Natanael xubꞌij: ¿Che aj Nazaret we achi riꞌ? ¿La kꞌo kꞌu jun utza winaq kel chilaꞌ? Ri Felipe xubꞌij che: Chatampe loq, jalawilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ri Jesús are xrilo chi tajin kaqebꞌ loq ri Natanael rukꞌ, xubꞌij: Waral kꞌo wi jun achi qas aj Israel, man kubꞌan taj bꞌanoj tzij. ");
INSERT INTO quctt_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ri Natanael xuta che ri Jesús: ¿Jawjeꞌ ilom wi la nuwach? Ri Jesús xubꞌij che: Xatinwilo are majaꞌ katusikꞌij ri Felipe, at kꞌo chuxeꞌ ri ucheꞌal ri higuera. ");
INSERT INTO quctt_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ri Natanael xubꞌij: Rabí, at at Ukꞌojol ri Dios, at nim taqanel pa ri tinimit Israel. ");
INSERT INTO quctt_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ri Jesús xubꞌij che: ¿La rumal ri xinbꞌij chawe chi xatinwilo are at kꞌo chuxeꞌ ri ucheꞌal ri higuera rumal riꞌ kakojo chi in in Ukꞌojol ri Dios? Kawil na nimaq taq jastaq choch we riꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Qas tzij kinbꞌij chiꞌwe chi kiwil na kajaqataj ri kaj, xuqujeꞌ ri angelibꞌ kepaqiꞌk kexuliꞌk puꞌwiꞌ ri uKꞌojol ri Achi. ");
INSERT INTO quctt_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Churox qꞌij, xbꞌan jun kꞌulanem pa Caná rech Galilea. Ri unan ri Jesús kꞌo pa ri kꞌulanem riꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ri Jesús xuqujeꞌ ri utijoxelabꞌ e sikꞌital pa ri kꞌulanem riꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Are xkꞌis ri vino, ri unan ri Jesús xubꞌij che ri Jesús: Maj chik kivino. ");
INSERT INTO quctt_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ri Jesús xubꞌij che: Ixoq, ¿jaswe in che we jastaq riꞌ majaꞌ kuriq ri nuqꞌotaj? ");
INSERT INTO quctt_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ri unan ri Jesús xubꞌij chike ri e patanijelabꞌ: Chibꞌana ronojel ri kubꞌij chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Kꞌo kꞌu waqibꞌ qꞌebꞌal bꞌantal che abꞌaj, are waꞌ kakikoj ri winaq aꞌj Israel pa ri kinimaqꞌij rech chꞌajchꞌobꞌen ibꞌ. Ri qꞌebꞌal riꞌ kuqꞌiꞌ jun ciento limeꞌt jaꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ri Jesús xubꞌij chike ri e patanijelabꞌ: Chinojisaj le qꞌebꞌal che jaꞌ. Ri patanijelabꞌ xeꞌkinojisaj ri qꞌebꞌal. ");
INSERT INTO quctt_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Kꞌa te riꞌ xubꞌij chike: Chikꞌama bꞌik jubꞌiqꞌ che ri kꞌamal bꞌe rech ri nimaqꞌij. Jeriꞌ xkibꞌano. ");
INSERT INTO quctt_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ri kꞌamal bꞌe are xunaꞌ ri jaꞌ ri bꞌantal chik vino che, pune man retaꞌm jawjeꞌ xkꞌam wi bꞌik, xwi ri patanijelabꞌ etaꞌmaninaq chi are waꞌ ri jaꞌ ri xkipulij bꞌik. Xusikꞌij ri jiꞌatz pa utukel, ");
INSERT INTO quctt_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","xubꞌij che: Konojel ri winaq kakikoj nabꞌe ri utz vino. Are nim chik kitijom ri aꞌjtobꞌom, kꞌa te riꞌ kaya chike ri vino ri man paqal taj rajil. Ri at kꞌut ayakom kan ri utz laj vino kꞌa pa ri kꞌisbꞌal rech ri nimaqꞌij. ");
INSERT INTO quctt_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Are waꞌ ri nabꞌe kꞌutbꞌal ri xubꞌan ri Jesús pa Caná, je laꞌ pa Galilea. Jeriꞌ xubꞌan chukꞌutik ri ujuluwem, xekojon kꞌu ri tijoxelabꞌ che. ");
INSERT INTO quctt_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Are xbꞌantaj we jastaq riꞌ, ri Jesús xtzalij pa ri tinimit Capernaúm, e rachiꞌl ri unan, ri e rachalal, ri utijoxelabꞌ, xekanaj kanoq chilaꞌ kebꞌ oxibꞌ qꞌij. ");
INSERT INTO quctt_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Xa jubꞌiqꞌ karaj kuriq ri Pascua kech ri winaq aꞌj Israel, are xpaqiꞌ ri Jesús pa ri tinimit Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Pa ri Templo xuꞌbꞌuriqa ri winaq ri tajin kakikꞌayij e wakax, e chij, rachiꞌl e palomax, xuqujeꞌ e kꞌo puꞌwiꞌ taq ri kimexa tajin kakikꞌex pwaq. ");
INSERT INTO quctt_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ri Jesús xubꞌan jun uchꞌeyabꞌal rukꞌ kꞌam, kꞌa te riꞌ xeꞌresaj loq konojel ri e kꞌo pa ri Templo xubꞌalkatij bꞌik ri kimexa ri e kꞌexol taq pwaq, xutix bꞌik pa ri ulew ronojel ri kirajil ri winaq ri e kꞌexol taq pwaq. ");
INSERT INTO quctt_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Xubꞌij chike ri ajkꞌay taq palomax: Chiꞌwesaj bꞌik ri aꞌwaj waral. ¿La chi il chiꞌwe kibꞌan qaj ikꞌayibꞌal che ri rachoch ri nuTat? ");
INSERT INTO quctt_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ri utijoxelabꞌ ri Jesús xnaꞌtaj chike ri tzꞌibꞌatalik kubꞌij: Kakꞌaxir ri wanimaꞌ rumal ri jastaq ri kabꞌan pa ri achoch la. ");
INSERT INTO quctt_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Xepe ri winaq e kꞌamal taq kibꞌe ri winaq aꞌj Israel xkita che ri Jesús: ¿Jas etal kaya la chaqe rech kaqetaꞌmaj chi kꞌo kwinem la chubꞌanik we jastaq riꞌ? ");
INSERT INTO quctt_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ri Jesús xubꞌij chike: Chitukij we Templo riꞌ, pa oxibꞌ qꞌij kꞌut kinyak ukꞌaxel. ");
INSERT INTO quctt_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ri winaq xkibꞌij che ri Jesús: ¿Che kayak at pa oxibꞌ qꞌij we Templo riꞌ ri kawinaq waqibꞌ junabꞌ xyakik? ");
INSERT INTO quctt_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ri templo ri xubꞌij ri Jesús are ri utyoꞌjal. Are kꞌu ri winaq pa kikꞌuꞌx chi are xubꞌij ri ja rech ri Templo. ");
INSERT INTO quctt_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jeriꞌ are xwaꞌjil chikixoꞌl ri kaminaqibꞌ, xnaꞌtaj chike ri tijoxelabꞌ ri xubꞌij kanoq, xekojon che ri tzꞌibꞌatalik xuqujeꞌ che ri xubꞌij ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Sibꞌalaj e kꞌi winaq xekojon che ri Jesús are xkil ronojel ri etal xubꞌano pa ri nimaqꞌij Pascua, pa ri tinimit Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ri Jesús kꞌut man xkubꞌiꞌ taj ukuꞌx chikij ri winaq rumal cher retaꞌm ri kꞌo pa ri kanimaꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Man xrayeꞌj ta kꞌut chi jun winaq chik xbꞌin che jas kakichomaj ri winaq, jeriꞌ rumal cher Areꞌ retaꞌm ri kꞌo pa kanimaꞌ konojel ri winaq. ");
INSERT INTO quctt_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kꞌo jun chike ri fariseos ubꞌiꞌ Nicodemo, jun kꞌamal bꞌe kech ri winaq aꞌj Israel. ");
INSERT INTO quctt_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Jun chaqꞌabꞌil ri Nicodemo xuꞌsolij ri Jesús. Xubꞌij che: Ajtij, qetaꞌm chi are ri Dios xtaqow la loq, rumal cher maj chi jun kakwin chubꞌanik ri etal ri kabꞌan la, xaq xwi kakwin ri winaq chubꞌanik we jastaq riꞌ we kꞌo ri ukwinem ri Dios rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ri Jesús xubꞌij che: Qas tzij kinbꞌij chawe chi ri winaq ri man kalax ta chik junmul, man kakwin taj kok pa ri ajawarem rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ri Nicodemo xubꞌij che ri Jesús: ¿Jas kubꞌan jun achi rech kalax chik junmul? ¿La kakwin kꞌut kok chi bꞌik junmul chupam ri unan, kꞌa te riꞌ kalax chik? ");
INSERT INTO quctt_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ri Jesús xubꞌij che: Qas tzij kinbꞌij chawe, ri man kalax taj che jaꞌ xuqujeꞌ che ri Uxlabꞌal man kakwin taj kok pa ri ajawarem rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ri kakꞌiy chike winaq, winaq riꞌ, are kꞌu ri kakꞌiy che ri Uxlabꞌal rech ri Dios, uxlabꞌal riꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mat mayijanik che le xinbꞌij chawe: “Rajawaxik wi kixalax chik junmul.” ");
INSERT INTO quctt_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ri kyaqiqꞌ kajichꞌichꞌ xapawjeꞌ ri karaj wi. Kato kaxururik, man awetaꞌm ta kꞌut jawjeꞌ upetik wi xuqujeꞌ jawjeꞌ keꞌ wi. Je xuqujeꞌ kakꞌulmataj rukꞌ ri winaq ri kalax pa ri Uxlabꞌal. ");
INSERT INTO quctt_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ri Nicodemo xubꞌij che ri Jesús: ¿Jas che jewaꞌ kakꞌulmatajik? ");
INSERT INTO quctt_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ri Jesús xubꞌij che: ¿At ajtij kech ri winaq aꞌj Israel, man kachꞌobꞌ taj we jastaq riꞌ? ");
INSERT INTO quctt_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Qas tzij kinbꞌij chawe, ri uj are kaqabꞌij ri qetaꞌm, xuqujeꞌ kaqaqꞌalajisaj ri qas qilom, ri ix kꞌut man kikoj taj ri kaqaqꞌalajisaj. ");
INSERT INTO quctt_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","We man kikoj ri jastaq rech uwachulew ri nubꞌim chiꞌwe ¿la are ta kꞌu kikoj ri jastaq rech chikaj? ");
INSERT INTO quctt_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Maj jun paqalinaq pa ri kaj, xaq xwi ri in uKꞌojol ri Achi ri xqaj loq choch ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Jetaq ri xubꞌan ri Moisés xuxekebꞌa ri kumatz pa ri katzꞌinow ulew, je xuqujeꞌ kabꞌan na che uxekebꞌaxik ri uKꞌojol ri Achi. ");
INSERT INTO quctt_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Jeriꞌ rech xapachin ri kakojon che kuriq na kꞌaslemal ri maj ukꞌisik. ");
INSERT INTO quctt_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ri Dios sibꞌalaj xuꞌloqꞌaj ri winaq ri e kꞌo choch ri uwachulew, xuya ri xa jun uKꞌojol rech xapachin ri kakojon che man kasach ta uwach xane kꞌo ukꞌaslemal ri maj ukꞌisik. ");
INSERT INTO quctt_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ri Dios man xutaq ta loq ri uKꞌojol chuqꞌatik tzij pa kiwiꞌ ri winaq ri e kꞌo choch ri uwachulew, xane xpetik rech rumal rech kekolotaj ri winaq. ");
INSERT INTO quctt_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ri kakojon che Areꞌ man kaqꞌat taj tzij puꞌwiꞌ, are kꞌu ri man kakojon taj xqꞌat taj tzij riꞌ puꞌwiꞌ, rumal cher man xkojon taj che ri ubꞌiꞌ ri xa jun uKꞌojol ri Dios. ");
INSERT INTO quctt_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kaqꞌat tzij pa kiwiꞌ ri winaq rumal man xekojon taj che ri tunal ri xpe choch ri uwachulew, are utz xkil ri qꞌequꞌmal, jeriꞌ rumal itzel taq chak kakibꞌano. ");
INSERT INTO quctt_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ri winaq ri kubꞌan etzelal, riꞌ karetzelaj ri tunal, man kaqebꞌ taj rukꞌ rumal cher kuxiꞌj ribꞌ chi kaqꞌalajin ri uchak. ");
INSERT INTO quctt_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Are kꞌu ri winaq ri are karilij ubꞌanik ri chak rech ri tunal kaqebꞌ rukꞌ ri tunal rech jeriꞌ kaqꞌalajinik chi are ubꞌanom ri chak ri karaj ri Dios. ");
INSERT INTO quctt_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Are xbꞌiꞌtaj we jastaq riꞌ, ri Jesús xeꞌ pa Judea, e rachiꞌl ri utijoxelabꞌ. Chilaꞌ xkꞌojiꞌ wi kebꞌ oxibꞌ qꞌij xubꞌan kiqasanaꞌ ri winaq. ");
INSERT INTO quctt_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Xuqujeꞌ ri Juan tajin kubꞌan qasanaꞌ pa ri tinimit Enón, ri kꞌo chuxukut ri tinimit Salín, rumal nim ri jaꞌ ri chilaꞌ. Rumal riꞌ xepe ri winaq, xulkiya kibꞌ rech kabꞌan kan kiqasanaꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Xkꞌulmataj we riꞌ are majaꞌ kok ri Juan pa cheꞌ.) ");
INSERT INTO quctt_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kꞌa te riꞌ xchapleꞌtaj jun chꞌoꞌj pa tzij puꞌwiꞌ ri qꞌij rech chꞌajchꞌobꞌen ibꞌ, chikixoꞌl ri utijoxelabꞌ ri Juan rachiꞌl jun achi aj Israel. ");
INSERT INTO quctt_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ri utijoxelabꞌ ri Juan xeꞌkibꞌij che ri Juan: Ajtij, ri achi ri xopan awukꞌ che ri junmul chꞌaqaꞌp che ri Jordán, ri xaqꞌalajisaj chkiwach ri winaq, tajin kubꞌan qasanaꞌ, e kꞌi winaq tajin koꞌpan rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ri Juan xubꞌij chike: Man kꞌo ta jun winaq kakwinik kubꞌan jun jastaq we man are ri Dios kayoꞌw kwinem che chubꞌanik. ");
INSERT INTO quctt_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Xita ri xinbꞌij: “Man in taj in Cristo, xane xaq xwi xintaq loq nabꞌe choch Areꞌ.” ");
INSERT INTO quctt_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ri jiꞌatz are qas kꞌo rukꞌ ri alibꞌatz. Ri rech chꞌabꞌeꞌn ri jiꞌatz ri kꞌo chuxukut kakiꞌkotik are kuta ri uchꞌabꞌal ri jiꞌatz. Are waꞌ ri kiꞌkotemal ri kꞌo pa wanimaꞌ in. ");
INSERT INTO quctt_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Rajawaxik Areꞌ kakꞌiyik, are kꞌu ri in xa kakoꞌpij nukꞌiyem. ");
INSERT INTO quctt_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ri jun ri kape na chilaꞌ chikaj are kꞌo pa kiwiꞌ kojonel, ri winaq ri ajuwachulew, ajuwachulew riꞌ, are karilij utzijoxik riꞌ ri jastaq rech uwachulew. Ri kape na chilaꞌ chikaj are kꞌo pa kiwiꞌ konojel ri winaq. ");
INSERT INTO quctt_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ri kape chilaꞌ chikaj kutzijoj ri rilom xuqujeꞌ utom, man kꞌo ta kꞌu jun katatabꞌen ri kubꞌij. ");
INSERT INTO quctt_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ri winaq ri kutatabꞌej ri kubꞌij Areꞌ, kuqꞌalajisaj chi qas tzij ri kubꞌij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ri utaqoꞌn ri Dios kuqꞌalajisaj ri tzij rech chilaꞌ chikaj rumal cher ri Dios man kuqꞌatej taj uyaꞌik ri Uxlabꞌixel che ri winaq riꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ri Tataxel Dios kuloqꞌaj ri Kꞌojolaxel rumal riꞌ ronojel ri jastaq uyaꞌom pa uqꞌabꞌ Areꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ri winaq ri kakojon che ri Kꞌojolaxel Dios, kꞌo ukꞌaslemal ri maj ukꞌisik, are kꞌu ri winaq ri karetzelaj ri Kꞌojolaxel Dios man kayaꞌtaj taj ukꞌaslemal xane kaqꞌat na tzij puꞌwiꞌ rumal ri Dios. ");
INSERT INTO quctt_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ri Jesús tajin kubꞌan kiqasanaꞌ sibꞌalaj e kꞌi winaq xuqujeꞌ tajin kuꞌx utijoxelabꞌ, sibꞌalaj e kꞌi na choch ri utijoxelabꞌ ri Juan. Xretaꞌmaj kꞌu ri Jesús chi xketaꞌmaj we riꞌ ri fariseos. ");
INSERT INTO quctt_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Man tzij ta kꞌut chi qas are ri Jesús tajin kabꞌanow ri qasanaꞌ xane are ri utijoxelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Are xretaꞌmaj ri Jesús we riꞌ, xel bꞌik pa ri tinimit Judea, xtzalij pa Galilea. ");
INSERT INTO quctt_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Choqꞌaqꞌ kꞌut kiꞌkow bꞌik pa ri tinimit Samaria. ");
INSERT INTO quctt_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Xok kꞌu bꞌik pa Sicar, jun tinimit ri kꞌo pa Samaria, ri kꞌo chuxukut ri ulew ri xuya ri Jacob che ri ukꞌojol José. ");
INSERT INTO quctt_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Chilaꞌ kꞌo wi ri kꞌwaꞌ ri xukꞌot kanoq ri Jacob. Ri Jesús xqꞌiꞌtaj bꞌik che ri bꞌe, xeꞌtꞌuyul chuxukut ri kꞌwaꞌ. Qas pa ri unikꞌaj riꞌ qꞌij. ");
INSERT INTO quctt_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ri utijoxelabꞌ e bꞌenaq kanoq pa ri tinimit chuloqꞌik kiwa. Xopan kꞌut jun ixoq chresaxik ujaꞌ pa ri kꞌwaꞌ. Ri Jesús xubꞌij che: Chaya juqubꞌ nujoron. ");
INSERT INTO quctt_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ri ixoq xubꞌij che: ¿Jas che kata ajaꞌ chwe, at at aj Israel are kꞌu ri in, in aj Samaria? Jeriꞌ xubꞌij che rumal cher ri aꞌj Israel man kakitun taj ukojik jun jastaq kukꞌ ri aꞌj Samaria. ");
INSERT INTO quctt_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ri Jesús xubꞌij che ri ixoq: We ta awetaꞌm ri kakwinik kuya ri Dios xuqujeꞌ ri tajin katow juqubꞌ jaꞌ chawe, at ta riꞌ nabꞌe xata ajaꞌ che, xuqujeꞌ xyaꞌtaj ta ajaꞌ riꞌ rumal, ri kuya kꞌaslemal ri maj ukꞌisik. ");
INSERT INTO quctt_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ri ixoq xubꞌij che ri Jesús: Tat, man keꞌ ta resaxik le jaꞌ, naj qajinaq. ¿Jawjeꞌ kꞌu keꞌsaj wi la loq ri jaꞌ ri kuya kꞌaslemal? ");
INSERT INTO quctt_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿La lal ta kꞌu nim qꞌij la choch ri qamam Jacob, areꞌ xyoꞌw kan we kꞌwaꞌ riꞌ chaqe, chi riꞌ xresaj wi kijoron ri e ralkꞌwaꞌl xuqujeꞌ ri e rawaj? ");
INSERT INTO quctt_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ri Jesús xubꞌij che ri ixoq: Xapachin ri kutij we jaꞌ riꞌ, kachaqiꞌj chi na uchiꞌ junmul chik. ");
INSERT INTO quctt_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Are kꞌu ri kutij rech ri jaꞌ ri kinya in man kachaqiꞌj ta chik uchiꞌ, xane ri jaꞌ ri kutijo kux na jun kꞌiyibꞌal jaꞌ ri kapulinik ri kuya kꞌaslemal ri maj ukꞌisik. ");
INSERT INTO quctt_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ri ixoq xubꞌij che: Tat, ya la we ri joron riꞌ rech man kinpe ta chik waral chi resaxik nujaꞌ xuqujeꞌ rech man kachaqiꞌj ta chik nuchiꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ri Jesús xubꞌij che ri ixoq: Jaꞌsikꞌij bꞌa loq ri awachajil, kꞌa te riꞌ chattzalij loq waral. ");
INSERT INTO quctt_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ri ixoq xubꞌij che ri Jesús: Maj wachajil in. Ri Jesús xubꞌij: Qas tzij laꞌ le xabꞌij chi maj awachajil. ");
INSERT INTO quctt_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Jeriꞌ rumal e kꞌolinaq kanoq e jobꞌ awachajil xuqujeꞌ ri kꞌo awukꞌ kamik man are taj awachajil, qas tzij laꞌ le xabꞌij. ");
INSERT INTO quctt_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ri ixoq xubꞌij: Tat, chanim kinchꞌobꞌo chi lal qꞌalajisal utzij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ri qamam uj ojer xeqꞌijilaꞌn puꞌwiꞌ we juyubꞌ riꞌ, are kꞌu ri ix, ix aj Israel kibꞌij chi pa Jerusalén rajawaxik kixqꞌijilaꞌn wi. ");
INSERT INTO quctt_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ri Jesús xubꞌij: Ixoq, chakojo ri kinbꞌij. Kuꞌriqa na jun qꞌij are man kabꞌan ta chik ri qꞌijilaꞌnem che ri Tataxel Dios, puꞌwiꞌ we juyubꞌ riꞌ, xa ta ne pa Jerusalén kabꞌan wi qꞌijilaꞌnem. ");
INSERT INTO quctt_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ix kiqꞌijilaꞌj ri man iwetaꞌm taj uwach, ri uj kꞌut kaqaqꞌijilaꞌj ri qetaꞌm uwach, jeriꞌ rumal ri kolotajem kukꞌ ri winaq aꞌj Israel petinaq wi. ");
INSERT INTO quctt_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Xqebꞌ kꞌu loq ri qꞌij xuqujeꞌ xopan ri qꞌotaj are taq ri qas e qꞌijilaꞌnelabꞌ kakiya na uqꞌij ri Tataxel Dios pa ri Uxlabꞌixel xuqujeꞌ qas tzij kekꞌojiꞌk, rumal jeriꞌ karaj ri Tataxel kabꞌanik. ");
INSERT INTO quctt_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ri Dios are uxlabꞌal, rajawaxik xuqujeꞌ chi ri e qꞌijilaꞌj taq rech kakiqꞌijilaꞌj pa ri uxlabꞌal xuqujeꞌ qas tzij kekꞌojiꞌk. ");
INSERT INTO quctt_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ri ixoq xubꞌij che: Wetaꞌm chi kape na ri Mesías ri kabꞌix Cristo che. Are kape riꞌ areꞌ, kubꞌij na chaqe jas ubꞌanik we jastaq riꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ri Jesús xubꞌij che: In riꞌ, ri tajin kintzijon awukꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Qas jeꞌ riꞌ tajin kubꞌij are xoꞌpan ri utijoxelabꞌ, xemayijanik rumal tajin katzijon rukꞌ jun ixoq, maj kꞌu jun xtow chike: ¿Jas kaj la che le ixoq? O ¿jas katzijoj la rukꞌ? ");
INSERT INTO quctt_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ri ixoq xuya kanoq ri uqꞌebꞌal, xtzalij pa ri tinimit, xubꞌij chike ri winaq: ");
INSERT INTO quctt_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Chixanloq, jiliwila jun achi ri xubꞌij chwe ronojel ri nubꞌanom. ¿La man are waꞌ ri kabꞌix Cristo che? ");
INSERT INTO quctt_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ri winaq xeꞌl bꞌik pa ri tinimit, xeꞌkila ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Are majaꞌ koꞌpan ri winaq, ri tijoxelabꞌ xkibꞌij che ri Jesús: Ajtij, woꞌq la. ");
INSERT INTO quctt_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ri Jesús xubꞌij chike: Ri in kꞌo jun jaswe tijowik rij ri man iwetaꞌm ta ix uwach. ");
INSERT INTO quctt_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ri tijoxelabꞌ xkichapleꞌj utayik chibꞌil taq kibꞌ: ¿La kꞌo ta kꞌu jun xkꞌamow loq jun jas rech tijowik rij? ");
INSERT INTO quctt_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ri Jesús xubꞌij chike: Are nuwa in ri ubꞌanik ri urayibꞌal ukꞌuꞌx ri xintaqow loq xuqujeꞌ kinkꞌis kanoq ubꞌanik ri uchak. ");
INSERT INTO quctt_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","¿La man kꞌu kibꞌij ix: “Karaj na kajibꞌ ikꞌ che ri yakoj”? Ri in kꞌut kinbꞌij chiꞌwe: ¡Chijaqa ri ibꞌoqꞌoch, chikaꞌyej ronojel ri tikoꞌn! Xutzirik. ");
INSERT INTO quctt_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ri winaq ri kabꞌanow ri yakoj kukꞌamawaꞌj na ri tojbꞌal rech, xuqujeꞌ ri yakoj ri kubꞌano rech jun kꞌaslemal ri maj ukꞌisik. Ri ajtikolobꞌ xuqujeꞌ ri kabꞌanow ri yakoj junam kekiꞌkotik. ");
INSERT INTO quctt_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Jeriꞌ rumal kꞌo jun tzij kubꞌij: “Jun kabꞌanow ri tikoꞌn, jun chi wi ri kabꞌanow ri yakoj.” ");
INSERT INTO quctt_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ri in xixintaq bꞌik chuyakik ri man xiriq taj kꞌax chutikik. E nikꞌaj wi ri xeqꞌiꞌtajik, e nikꞌaj wi ri xechakunik, ri ix kꞌut xaq xwi kiꞌtzukuj loq uwach ri chak ri bꞌantajinaq chi kanoq. ");
INSERT INTO quctt_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","E kꞌi chike ri winaq aꞌj Samaria xekojon che ri Jesús rumal xkita ri xubꞌij ri ixoq: Areꞌ xubꞌij chwe ronojel ri nubꞌanom. ");
INSERT INTO quctt_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Jeriꞌ are xoꞌpan ri aꞌj Samaria rukꞌ ri Jesús xkibꞌij che chi kakanaj kan kukꞌ. Ri Jesús xkanaj kanoq chilaꞌ kebꞌ qꞌij. ");
INSERT INTO quctt_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","E kꞌi winaq xekojon chi na che ri Jesús rumal ri xubꞌij areꞌ chike. ");
INSERT INTO quctt_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Xkibꞌij kꞌu che ri ixoq: Man xwi taj kujkojonik rumal ri xabꞌij chaqe xane rumal ri xqatatabꞌej uj rukꞌ ri qaxikin, xqetaꞌmaj chi are waꞌ ri Kolonel kech konojel ri winaq rech ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Are xikꞌow ri kebꞌ qꞌij, ri Jesús xel bꞌik pa ri tinimit Samaria, xeꞌ pa Galilea. ");
INSERT INTO quctt_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Jeriꞌ, rumal ri Jesús ubꞌim chi xa ta ne jun qꞌalajisal tzij kaya uqꞌij pa ri tinimit ri kel wi.) ");
INSERT INTO quctt_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Are xopan pa Galilea utz xbꞌan chukꞌamawaꞌxik kumal ri winaq aꞌj chilaꞌ, jeriꞌ rumal kilom ronojel ri xubꞌan pa Jerusalén pa ri nimaqꞌij Pascua. ");
INSERT INTO quctt_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kꞌa te riꞌ xtzalij chik ri Jesús pa Caná rech Galilea, chilaꞌ xukꞌex wi ri jaꞌ pa vino. Kꞌo kꞌut jun ukꞌojol ri jun rajchak ri qꞌatal tzij yawabꞌ je laꞌ pa ri tinimit Capernaúm. ");
INSERT INTO quctt_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Are xretaꞌmaj ri achi, utat ri yawabꞌ, chi xopan ri Jesús pa Galilea, upetik pa Judea, xeꞌ chutzukuxik. Are xuriqo, xuta toqꞌobꞌ che rech keꞌ chukunaxik ri ukꞌojol rumal xa jubꞌiqꞌ karaj kakamik. ");
INSERT INTO quctt_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ri Jesús xubꞌij che: Ri ix man kixkojon ta wi la we man kiwil kꞌutbꞌal xuqujeꞌ etal. ");
INSERT INTO quctt_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ri ajchak rech ri qꞌatal tzij xubꞌij che ri Jesús: Wajaw, bꞌana la toqꞌobꞌ, oj la cho ri wachoch rech man kakam taj ri nukꞌojol. ");
INSERT INTO quctt_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ri Jesús xubꞌij che ri achi: Chattzalij cho awachoch, man kakam taj ri akꞌojol. Xukoj ri achi ri xbꞌix che rumal ri Jesús, kꞌa te riꞌ xtzalij cho rachoch. ");
INSERT INTO quctt_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Are bꞌenaq ri achi cho rachoch, xeꞌl loq ri e rajchakibꞌ chukꞌulaxik pa ri bꞌe, xkibꞌij che chi man xkam taj ri ukꞌojol xane xkꞌasiꞌk xuqujeꞌ xutzirik. ");
INSERT INTO quctt_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ri achi xuta chike jas qꞌotaj xutzir ri ukꞌojol. Ri ajchakibꞌ xkibꞌij: Iwir qas jun hora ikꞌowinaq che ri unikꞌajil qꞌij xel bꞌik ri qꞌaqꞌ che. ");
INSERT INTO quctt_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Naꞌtaj kꞌu che ri utat ri akꞌal chi qas che riꞌ ri qꞌotaj riꞌ, xubꞌij ri Jesús che: “Ri akꞌojol kakꞌasiꞌ na.” Jeriꞌ konojel ri e kꞌo rukꞌ ri achi pa ri rachoch xekojon che ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Are waꞌ ri ukabꞌ etal ri xubꞌan ri Jesús are xtzalij loq pa Galilea upetik pa Judea. ");
INSERT INTO quctt_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Are ikꞌowinaq chik jun janipa qꞌij, xpaqiꞌ ri Jesús pa ri nimaqꞌij kech ri winaq aꞌj Israel ri kabꞌan pa Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Chilaꞌ kꞌo jun jaꞌ chuxukut ri kꞌolibꞌal ubꞌiꞌnam Okibꞌal kech ri chij, sutim rij rukꞌ jobꞌ raqan ja, Betzatá ubꞌiꞌ pa arameo. ");
INSERT INTO quctt_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Pa taq ri raqan ja riꞌ e qꞌoyoqꞌoj sibꞌalaj e kꞌi yawabꞌibꞌ, e kꞌo e moyabꞌ, e chꞌokeꞌr, kꞌo man kekwin taj kakisalabꞌaj kibꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Jeriꞌ rumal che taq ri qꞌij riꞌ kꞌo jujun mul jun ángel kaqaj loq chusalabꞌaxik ri jaꞌ, ri winaq ri kaqaj nabꞌe pa ri jaꞌ are kasalabꞌataj kanoq kutzirik. ");
INSERT INTO quctt_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Chilaꞌ xuqujeꞌ kꞌo wi jun achi ri kaminaq ri utyoꞌjal juwinaq lajuj wajxaqibꞌ junabꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ri Jesús are xril ri achi qꞌoyol pa ri ulew, xuchomaj chi kꞌi qꞌij chik kꞌo chilaꞌ, jeriꞌ xuta che: ¿La kawaj katutzirik? ");
INSERT INTO quctt_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ri achi xubꞌij: Wajaw, maj jun kabꞌanow toqꞌobꞌ chwe kinuqasaj pa le jaꞌ, are kasalabꞌataj kanoq raj kinqaj chupam kꞌa te kinwilo jun chik nabꞌe kaqajilobꞌ chupam. ");
INSERT INTO quctt_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ri Jesús xubꞌij che: Chatwaꞌjiloq, jat chakꞌama bꞌik ri achꞌat. ");
INSERT INTO quctt_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ri achi aninaq xutzirik, xukꞌam bꞌik ri uchꞌat, xuchapleꞌj bꞌinem. Ri kꞌulmatajem riꞌ xbꞌantaj pa ri qꞌij rech uxlanem. ");
INSERT INTO quctt_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ri winaq aꞌj Israel xkibꞌij che ri achi ri xkunatajik, man yaꞌtal taj chawe kaweqaj ri achꞌat, are qꞌij rech uxlanem kamik. ");
INSERT INTO quctt_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ri achi xubꞌij chike: Ri xinkunanik xubꞌij chwe: “Jat chakꞌama bꞌik ri achꞌat.” ");
INSERT INTO quctt_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ri winaq xkita che: Jachin xbꞌin chawe: “¿Jat chakꞌama bꞌik ri achꞌat?” ");
INSERT INTO quctt_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Man retaꞌm ta kꞌut ri achi ri xutzirik jachin riꞌ ri xkunanik, jeriꞌ rumal ri Jesús xok bꞌik chikixoꞌl konojel ri winaq ri e kꞌo chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kꞌa te riꞌ ri Jesús xuriq ri achi ri xkunatajik pa ri Templo, xubꞌij che: Chawilampeꞌ, xatkunatajik. Makat makun ta chik rech man kape ta chik jun kꞌax paꞌwiꞌ ri kꞌo na cho we xariqo. ");
INSERT INTO quctt_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ri achi xubꞌij chike ri winaq aꞌj Israel chi are ri Jesús xkunanik. ");
INSERT INTO quctt_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Rumal kꞌu riꞌ, ri winaq aꞌj Israel xkitzukuj jas xkibꞌan che uchapik ri Jesús, jeriꞌ rumal kubꞌan taq we jastaq riꞌ pa ri qꞌij rech uxlanem. ");
INSERT INTO quctt_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ri Jesús xubꞌij chike: Ri nuTat kꞌa kachakun na kamik, rumal riꞌ kinchakun xuqujeꞌ in. ");
INSERT INTO quctt_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ri winaq aꞌj Israel are kakaj kakikamisaj ri Jesús, jeriꞌ rumal man xwi taj man kunimaj taj ri qꞌij rech uxlanem xane kubꞌij xuqujeꞌ chi are utat ri Dios, kujunamaj ribꞌ rukꞌ ri Dios. ");
INSERT INTO quctt_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Rumal riꞌ, ri Jesús xubꞌij: Qas tzij kinbꞌij chiꞌwe: Ri kꞌojolaxel man kakwin taj kubꞌan jun jastaq xaq pa areꞌ wi, xane xaq xwi kakwinik kubꞌan ri karil ri utat kubꞌano, jeriꞌ rumal xapakux jastaq ri kubꞌan ri Tataxel kubꞌan xuqujeꞌ ri Kꞌojolaxel. ");
INSERT INTO quctt_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ri Tataxel sibꞌalaj uloqꞌ ri Kꞌojolaxel rumal riꞌ kukꞌut choch ronojel ri jastaq ri kubꞌano. Kukꞌut kꞌu na nimaq taq jastaq choch ri ukꞌutum choch kamik riꞌ, qas kixmayijan kꞌu na. ");
INSERT INTO quctt_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Jetaq ri kubꞌan ri Tataxel kukꞌastajisaj ri kaminaqibꞌ xuqujeꞌ kuya kikꞌaslemal, je xuqujeꞌ ri Kꞌojolaxel kuya kikꞌaslemal konojel ri keꞌraj. ");
INSERT INTO quctt_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ri Tataxel, xa ta ne jun kuqꞌat tzij puꞌwiꞌ, xane ronojel ri qꞌatoj tzij uyaꞌom pa uqꞌabꞌ ri Kꞌojolaxel. ");
INSERT INTO quctt_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Jeriꞌ rech konojel ri winaq kakiqꞌijilaꞌj ri Kꞌojolaxel, jetaq ri kakibꞌan chuqꞌijilaꞌxik ri Tataxel. Ri man kuqꞌijilaꞌj taj ri Kꞌojolaxel man kuqꞌijilaꞌj ta riꞌ ri Tataxel ri xtaqow loq ri Kꞌojolaxel. ");
INSERT INTO quctt_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Qas tzij kinbꞌij chiꞌwe xapachin ri kuta ri nutzij xuqujeꞌ kakojon che ri xintaqow loq kuriq na kꞌaslemal ri maj ukꞌisik, man kaqꞌat taj tzij puꞌwiꞌ xane xel loq pa ri kamikal xuriq kꞌaslemal. ");
INSERT INTO quctt_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Qas tzij kinbꞌij chiꞌwe xopan ri qꞌij are kakita ri uchꞌabꞌal ri Ukꞌojol ri Dios ri kaminaqibꞌ, ri ketow ri chꞌabꞌal riꞌ kekꞌasiꞌ na. ");
INSERT INTO quctt_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Jetaq ri ubꞌanik ri Tataxel kꞌo ukꞌaslemal xaq pa areꞌ wi, xuya xuqujeꞌ che ri Kꞌojolaxel ukwinem rech kꞌo ukꞌaslemal xaq pa areꞌ wi. ");
INSERT INTO quctt_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Yaꞌtal kwinem che rech kuqꞌat tzij, jeriꞌ rumal are uKꞌojol ri Achi. ");
INSERT INTO quctt_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Man kixmayijan taj rumal kape na ri qꞌij are konojel ri e muqumoj kakita na ri uchꞌabꞌal ri uKꞌojol ri Dios. ");
INSERT INTO quctt_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Keꞌl kꞌu na loq pa ri muqbꞌal. Ri xkibꞌan ri utzilal kekꞌastaj na rech kebꞌe pa ri kꞌaslemal, are kꞌu ri xkilij ubꞌanik ri etzelal kekꞌastaj na rech kaqꞌat tzij pa kiwiꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ri in man kinkwin taj kinbꞌan jun jastaq xaq pa wech wi; xaq xwi kinqꞌat tzij puꞌwiꞌ ri kinto, sukꞌ ri nuqꞌatoj tzij, jeriꞌ rumal man are ta kabꞌan ri kawaj in, xane are kabꞌan rech ri xintaqow loq. ");
INSERT INTO quctt_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","We xaq in kinqꞌalajisaj wibꞌ chibꞌil wibꞌ, maj kupatanij riꞌ ri nuqꞌalajisanik. ");
INSERT INTO quctt_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Kꞌo kꞌu jun ri kubꞌan ri qꞌalajisanik pa nuwiꞌ, wetaꞌm chi ri uqꞌalajisanik ri kubꞌan pa nuwiꞌ qas tzij wi. ");
INSERT INTO quctt_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ri ix xiꞌtaq bꞌik nikꞌaj iwachiꞌl chutayik kꞌotbꞌal chiꞌ che ri Juan, areꞌ xuya loq jun qꞌalajisanik ri qas tzij. ");
INSERT INTO quctt_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Man kinkꞌamawaꞌj ta kꞌu in ri uqꞌalajisanik jun achi; kinqꞌalajisaj kꞌu we riꞌ rech jeriꞌ kixkolotajik. ");
INSERT INTO quctt_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ri Juan kajunumataj rukꞌ ri jun qꞌaqꞌ ri tzijilik, ri ix kꞌut xikiꞌkotebꞌej ri utunal jun janipa qꞌotaj. ");
INSERT INTO quctt_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ri qꞌalajisanik ri bꞌantal chwij in nim na choch ri qꞌalajisanik ri xbꞌan chirij ri Juan. Jeriꞌ rumal ri nuchak ri xuya ri Tataxel are kakꞌutuwik chi ri Tataxel are xbꞌanow ri qꞌalajisanik chwij chi areꞌ xintaqow loq. ");
INSERT INTO quctt_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ri Tataxel ri xintaqow loq are bꞌanowinaq ri qꞌalajisanik chwij. Ix man itom taj ri uchꞌabꞌal ri Tataxel xuqujeꞌ man iwilom taj uwach. ");
INSERT INTO quctt_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Man kꞌo taj ri utzij ri Tataxel pa iwanimaꞌ jeriꞌ rumal man kixkojon taj che ri xutaq loq. ");
INSERT INTO quctt_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ri ix kisolij uwach ri utzij ri Dios rumal cher iwetaꞌm chi chilaꞌ kiriq wi kꞌaslemal ri maj ukꞌisik xuqujeꞌ are waꞌ ri kuya nuqꞌalajisaxik. ");
INSERT INTO quctt_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pune jeriꞌ, ix man kiwaj taj kixpe wukꞌ chukꞌamawaꞌxik we kꞌaslemal riꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Man kinkꞌamawaꞌj taj ri juluwem ri kakiya ri winaq. ");
INSERT INTO quctt_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ix wetaꞌm kꞌut chi man qas ta kiloqꞌaj ri Dios. ");
INSERT INTO quctt_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","In in petinaq pa ri ubꞌiꞌ ri nuTat, ri ix kꞌut man kinikꞌamawaꞌj taj; we ta kꞌu kape chi jun xaq pa rech wi, kꞌa te riꞌ ri kikꞌamawaꞌj. ");
INSERT INTO quctt_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Jas ta kꞌu che kixkojonik we xaq ix kiya iqꞌij chibꞌil taq iwibꞌ, man kitzukuj ta kꞌut ri juluwem ri kape rukꞌ ri xa jun Dios? ");
INSERT INTO quctt_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mibꞌij kꞌut chi in kineꞌmolow imak choch ri Tataxel xane are ri Moisés, ri achi ri jeqel ikꞌuꞌx chirij, are riꞌ kixtzujun na choch ri Dios. ");
INSERT INTO quctt_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","We ta kikoj ri xubꞌij ri Moisés, kixkojon xuqujeꞌ riꞌ chwe in, jeriꞌ rumal ri Moisés xutzꞌibꞌaj loq wij. ");
INSERT INTO quctt_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","We man kikoj ri xutzꞌibꞌaj ri Moisés, ¿la are ta kꞌu kikoj ri nutzij in? ");
INSERT INTO quctt_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Are xikꞌow jun janipa qꞌij, xeꞌ ri Jesús chuchiꞌ ri cho rech Galilea (ubꞌiꞌnam xuqujeꞌ Tiberíades). ");
INSERT INTO quctt_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Sibꞌalaj e kꞌi winaq e teren chirij, jeriꞌ rumal xkilo ronojel ri mayijabꞌal taq jastaq ri ubꞌanom kukꞌ ri e yawabꞌibꞌ ");
INSERT INTO quctt_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ri Jesús xpaqiꞌ kꞌut puꞌwiꞌ jun laj juyubꞌ xtꞌuyiꞌk chilaꞌ e rachiꞌl ri utijoxelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Xa jubꞌiqꞌ karaj kuriq ri nimaqꞌij kech ri winaq aꞌj Israel, ubꞌiꞌnam Pascua. ");
INSERT INTO quctt_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Are xkaꞌy apanoq ri Jesús, xeꞌril sibꞌalaj e kꞌi winaq e bꞌenaq rukꞌ, xubꞌij kꞌut che ri Felipe: ¿Jawjeꞌ keꞌqaloqꞌo wi kiwa konojel we winaq riꞌ? ");
INSERT INTO quctt_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jeriꞌ xubꞌij che ri Felipe rech karilo jas kubꞌij che, ri Jesús kꞌut retaꞌm chik jas kubꞌano. ");
INSERT INTO quctt_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ri Felipe xubꞌij: Man kakwin ta riꞌ kebꞌ ciento denario kuloqꞌ chꞌaqaꞌp taq kikaxlan wa we winaq riꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Jun chik chike ri utijoxelabꞌ ubꞌiꞌnam Andrés, ri rachalal ri Simón Pedro, xubꞌij che: ");
INSERT INTO quctt_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Kꞌo jun ala waral rukꞌaꞌm jobꞌ kaxlan wa bꞌantal che cebada rachiꞌl kebꞌ kar. ¿Jas ta kꞌu waꞌ we ri chike we kikꞌiyal we winaq riꞌ? ");
INSERT INTO quctt_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ri Jesús xtaqanik chikitꞌuyubꞌaxik konojel ri winaq, sibꞌalaj nim qꞌayes kꞌo pa ri leꞌaj riꞌ. Xetꞌuyiꞌk kꞌut konojel, ri kikꞌiyal ri achyabꞌ e kꞌulanik are jobꞌ mil. ");
INSERT INTO quctt_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ri Jesús xukꞌam apanoq ri kaxlan wa, xtyoxin che ri Dios, kꞌa te riꞌ xujach chike ri tꞌuyul chilaꞌ, xajanipa ri xkaj. Je xuqujeꞌ xubꞌan che ri kar. ");
INSERT INTO quctt_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Are xenoj ri winaq, ri Jesús xubꞌij chike ri utijoxelabꞌ: Chisikꞌa le e chꞌaqaꞌp le xekanaj kanoq rech man xaq ta katzaqik. ");
INSERT INTO quctt_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Xkiyak kꞌut ri e chꞌaqaꞌp ri xekanaj kanoq, xkimulij kabꞌlajuj chakach chꞌaqaꞌp kaxlan wa rech cebada. ");
INSERT INTO quctt_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Are xkil ri winaq ri kꞌutbꞌal ri xubꞌan ri Jesús, xkichapleꞌj ubꞌixik: We achi riꞌ qas tzij jun qꞌalajisal utzij ri Dios, are waꞌ ri kape na choch ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ri Jesús are xrilo chi ri winaq are kakaj kakikꞌam bꞌik kukꞌ rech kux Taqanel pa kiwiꞌ, xel bꞌik kukꞌ, xeꞌ pa ri juyubꞌ utukel. ");
INSERT INTO quctt_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Are tajin kok ri aqꞌabꞌ, ri utijoxelabꞌ ri Jesús xeqaj bꞌik pa ri cho. ");
INSERT INTO quctt_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Xaꞌqꞌan bꞌik pa jun jukubꞌ bꞌinibꞌal puꞌwiꞌ ri jaꞌ, xebꞌe chꞌaqaꞌp rech ri cho chusukꞌumal ri tinimit Capernaúm. Majaꞌ kꞌu kopan ri Jesús kukꞌ ri utijoxelabꞌ are xok ri aqꞌabꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Xaq kꞌa te xwaꞌjil aqꞌanoq jun kyaqiqꞌ puꞌwiꞌ ri cho, ri cho sibꞌalaj xchꞌuꞌjarik. ");
INSERT INTO quctt_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ri e tijoxelabꞌ oꞌkinaq chi bꞌik jobꞌ o waqibꞌ kilómetros pa ri jaꞌ are xkil ri Jesús tajin kaqebꞌ rukꞌ ri jukubꞌ, kabꞌin puꞌwiꞌ ri jaꞌ bꞌenaq, xkixiꞌj kibꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ri Jesús xubꞌij chike: In waꞌ, man kixiꞌj ta iwibꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Xaq jeriꞌ xkikꞌamawaꞌj ri Jesús pa ri jukubꞌ. Ri jukubꞌ xopan kꞌut chuchiꞌ ri jaꞌ ri e bꞌenaq wi. ");
INSERT INTO quctt_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Chukabꞌ qꞌij ri winaq ri xekanaj kanoq chꞌaqaꞌp che ri cho jawjeꞌ ri xkojiꞌk wi ri Jesús xkilo chi ri e tijoxelabꞌ xebꞌe chꞌaqaꞌp xaq pa kitukel. Xa jun jukubꞌ bꞌinibꞌal xopan chilaꞌ, ri Jesús man xeꞌ ta kꞌu chupam ri jukubꞌ xane xaq xwi ri utijoxelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Xoꞌpan kꞌut nikꞌaj e jukubꞌ bꞌinibꞌal puꞌwiꞌ ri jaꞌ aꞌj pa Tiberíades, xenaqajin rukꞌ ri leꞌaj jawjeꞌ xkitij wi ri kaxlan wa ri winaq ri xbꞌan chꞌawem puꞌwiꞌ rumal ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Are xkil ri winaq chi ri Jesús xuqujeꞌ ri utijoxelabꞌ man e kꞌo ta chik chilaꞌ, xaꞌqꞌan bꞌik pa ri jukubꞌ bꞌinibꞌal, xebꞌe chutzukuxik ri Jesús pa ri tinimit Capernaúm. ");
INSERT INTO quctt_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ri winaq are xkiriq chi ri Jesús chꞌaqaꞌp che ri cho, xkita che: Ajtij, ¿jampaꞌ xul la waral? ");
INSERT INTO quctt_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ri Jesús xubꞌij chike: Qas tzij kinbꞌij chiꞌwe, ri ix man kinitzukuj taj rumal cher iwilom taq ri kꞌutbꞌal, kinitzukuj rumal cher xixnojik are xitij ri kaxlan wa. ");
INSERT INTO quctt_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Chixchakunoq man rumal taj ri iwa ri xaq kasach uwach xane chixchakunoq rumal ri kꞌaslemal ri maj ukꞌisik, ri kuya na ri uKꞌojol ri Achi chiꞌwech. Are waꞌ ri ukojom retal ri Dios Tataxel ubꞌim chi utz. ");
INSERT INTO quctt_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ri winaq xkita che: ¿Jas rajawaxik kaqabꞌano rech kaqabꞌan ri chak ri karaj ri Dios? ");
INSERT INTO quctt_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ri Jesús xubꞌij: Ri uchak ri Dios are we riꞌ: Chixkojon che ri jun ri xutaq loq. ");
INSERT INTO quctt_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ri winaq xkita che: ¿Jas kꞌutbꞌal kabꞌan la rech kaqilo xuqujeꞌ kujkojon che la? ");
INSERT INTO quctt_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ri qatat qanan xkitij ri maná ri xya chike pa ri ulew ri katzꞌinowik, jetaq ri tzꞌibꞌatalik: Xya kaxlan wa rech chikaj chike. ");
INSERT INTO quctt_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ri Jesús xubꞌij chike: Qas tzij kinbꞌij chiꞌwe: Man are taj ri Moisés xyoꞌw ri kaxlan wa chiꞌwe. Ri kayoꞌw ri kaxlan wa rech chikajil are ri nuTat. ");
INSERT INTO quctt_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ri kaxlan wa rech ri Dios are riꞌ ri kaqaj loq pa ri kaj, ri kuya kikꞌaslemal ri winaq ri e kꞌo choch ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ri winaq xkibꞌij: Ajawxel, ya la qe ri kaxlan wa riꞌ ronojel qꞌij. ");
INSERT INTO quctt_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ri Jesús xubꞌij chike: In riꞌ ri kaxlan wa rech kꞌaslemal. Ri kape wukꞌ man kunaꞌ ta chik wiꞌjal, xuqujeꞌ ri kakojon chwe man kachaqiꞌj ta chi wi uchiꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nubꞌim chik chiꞌwe, pune iniwilom chik, man kixkojon taj chwe. ");
INSERT INTO quctt_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Konojel ri xuꞌya ri nuTat chwe kepe na wukꞌ, ri winaq ri kape wukꞌ man kinwetzelaj taj. ");
INSERT INTO quctt_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Jeriꞌ rumal xinqaj loq pa ri kaj, man chubꞌanik taj ri kawaj in, xane chubꞌanik ri karaj ri xintaqow loq. ");
INSERT INTO quctt_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ri urayibꞌal ukꞌuꞌx ri xintaqow loq are chi man kintzaq ta kan jun chike ri xuꞌya chwe, xane kinkꞌastajisaj na pa ri kꞌisbꞌal qꞌij. ");
INSERT INTO quctt_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ri urayibꞌal ukꞌuꞌx ri nuTat are chi xapachin ri kukꞌamawaꞌj ri uKꞌojol xuqujeꞌ kakojon che, kuriq na jun alik kꞌaslemal, xuqujeꞌ in kinkꞌastajisaj na pa ri kꞌisbꞌal qꞌij. ");
INSERT INTO quctt_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ri winaq aꞌj Israel xkichapleꞌj ubꞌixik taq tzij che, jeriꞌ rumal xubꞌij: In riꞌ ri kaxlan wa ri xqaj loq pa ri kaj. ");
INSERT INTO quctt_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Xuqujeꞌ kakibꞌij chibꞌil taq kibꞌ: ¿La man are waꞌ ri ukꞌojol ri José? ¿La man qetaꞌm uj kiwach ri utat unan? ¿Jas che kꞌut kubꞌij chi xa xqaj loq pa ri kaj? ");
INSERT INTO quctt_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ri Jesús xubꞌij chike: Chixtanal chubꞌixik taq tzij. ");
INSERT INTO quctt_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Maj jun kakwinik kape wukꞌ we man are ri Tataxel kakꞌamow la wukꞌ. Ri in kꞌut kinkꞌastajisaj na uwach ri winaq riꞌ pa ri kꞌisbꞌal qꞌij. ");
INSERT INTO quctt_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Pa ri kiwuj ri e qꞌalajisal taq utzij ri Dios tzꞌibꞌatalik: Kabꞌix na chike konojel ri ucholajil. Qas tzij wi xapachin ri kutatabꞌej ri kubꞌij ri Tataxel xuqujeꞌ karetaꞌmaj ri kubꞌij kape na wukꞌ in. ");
INSERT INTO quctt_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Maj jun ilowinaq ri Tataxel, xaq xwi ri petinaq che ri Dios ilowinaq uwach. ");
INSERT INTO quctt_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Qas tzij kinbꞌij chiꞌwe, ri kakojonik kuriq na kꞌaslemal ri maj ukꞌisik. ");
INSERT INTO quctt_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","In riꞌ ri in kaxlan wa rech kꞌaslemal. ");
INSERT INTO quctt_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ri itat inan ojer xkitij ri maná pa ri leꞌaj jawjeꞌ e maj wi ja, pune jeriꞌ xekam wi. ");
INSERT INTO quctt_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Are kꞌu waꞌ ri kaxlan wa ri xqaj loq pa ri kaj, xapachin ri kutij rech man kakam taj. ");
INSERT INTO quctt_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","In riꞌ ri in kꞌaslik kaxlan wa ri xqaj loq pa ri kaj, ri kutij rech we kaxlan wa riꞌ, kakꞌasiꞌ na chibꞌe qꞌij saq. We kaxlan wa riꞌ are nutyoꞌjal ri kinjach na rech kekꞌasiꞌk ri winaq aꞌjuwachulew. ");
INSERT INTO quctt_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ri winaq aꞌj Israel xeqꞌaqꞌarik xkichapleꞌj utatabꞌeloꞌxik chibꞌil taq kibꞌ: ¿Jas kubꞌan we achi riꞌ chuyaꞌik ri utyoꞌjal chaqe? ");
INSERT INTO quctt_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ri Jesús xubꞌij chike: Qas tzij kinbꞌij chiꞌwe, we man kitij ri utyoꞌjal ri uKꞌojol ri Achi xuqujeꞌ man kiqumuj taj ri ukikꞌel, man kꞌo taj ikꞌaslemal. ");
INSERT INTO quctt_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Jachin ri kutij ri nutyoꞌjal xuqujeꞌ kuqumuj ri nukikꞌel kꞌo ukꞌaslemal ri maj ukꞌisik. Kinkꞌastajisaj kꞌu na pa ri kꞌisbꞌal qꞌij. ");
INSERT INTO quctt_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Jeriꞌ rumal ri nutyoꞌjal qas tijowik wi rij, xuqujeꞌ ri nukikꞌel qas utz wi kaqumuxik. ");
INSERT INTO quctt_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Jachin ri kutij ri nutyoꞌjal xuqujeꞌ kuqumuj ri nukikꞌel kakꞌojiꞌ na pa in xuqujeꞌ in kinkꞌojiꞌ na pa areꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Jetaq ri xubꞌan ri Tataxel ri kꞌaslik, xinutaq loq. In in kꞌaslik rumal Areꞌ, je xuqujeꞌ ri kinutijo, kakꞌasiꞌ xa rumal we in. ");
INSERT INTO quctt_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Are waꞌ ri kaxlan wa ri xqaj loq pa ri kaj. Ri itat inan ojer xkitij ri maná, xekam kꞌut, are kꞌu ri kutij rech we kaxlan wa riꞌ kakꞌasiꞌ ronojel qꞌij. ");
INSERT INTO quctt_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ronojel we jastaq riꞌ xubꞌij ri Jesús are kꞌo pa ri Sinagoga, pa ri tinimit Capernaúm. ");
INSERT INTO quctt_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","E kꞌi chike ri utijoxelabꞌ are xkita ri xubꞌij Jesús xkibꞌij: Sibꞌalaj kꞌax we kꞌutuꞌn riꞌ. ¿La kꞌo ta kꞌu jun riꞌ kakwin chukꞌamawaꞌxik? ");
INSERT INTO quctt_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ri Jesús retaꞌm chi ri utijoxelabꞌ tajin kakitzijoj rij ri xubꞌij chike, rumal riꞌ xubꞌij chik junmul chike: ¿La topibꞌal aqanaj waꞌ we riꞌ chiꞌwe ix? ");
INSERT INTO quctt_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Jas ta kꞌu kibꞌan ri we kiwil ri uKꞌojol ri Achi kapaqiꞌ chik junmul jawjeꞌ ri kꞌo wi nabꞌe? ");
INSERT INTO quctt_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ri Uxlabꞌixel kuya kꞌaslemal, ri tyoꞌjal man kꞌo taj kutayij. Ri tzij ri nubꞌim chiꞌwe are Uxlabꞌal xuqujeꞌ Kꞌaslemal. ");
INSERT INTO quctt_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pune jeriꞌ nubꞌim chiꞌwe, e kꞌi chiꞌwe man kekojon taj. Jeriꞌ xubꞌij ri Jesús rumal e retaꞌm ri winaq ri xekojon che ri xubꞌij xuqujeꞌ ri man xekojon taj xuqujeꞌ retaꞌm uwach ri achi ri kajachow na. Rumal riꞌ xubꞌij: ");
INSERT INTO quctt_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Rumal la xinbꞌij chiꞌwe chi maj jun kakwinik kape wukꞌ, we man are ri Tataxel kayoꞌw bꞌe che. ");
INSERT INTO quctt_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tzi che ri qꞌij riꞌ, e kꞌi chike ri utijoxelabꞌ xkijelechꞌuj kan kibꞌe, man xkaj ta chik xekꞌojiꞌ rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ri Jesús kꞌut xuta chike ri e kabꞌlajuj utijoxelabꞌ: ¿Teꞌq kiwaj xuqujeꞌ ix kixeꞌ kanoq? ");
INSERT INTO quctt_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ri Simón Pedro xubꞌij: Ajawxel, ¿Jachin chi rukꞌ kujeꞌ wi? Xaq xwi ukꞌ la kꞌo wi tzij rech kꞌaslemal ri maj ukꞌisik. ");
INSERT INTO quctt_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ri uj qakojom xuqujeꞌ qetaꞌm chi lal lal ri Tyoxalaj uKꞌojol ri Dios. ");
INSERT INTO quctt_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ri Jesús xubꞌij chike: ¿La man ix kabꞌlajuj xixinchaꞌo? Pune jeriꞌ jun chiꞌwe jun itzel. ");
INSERT INTO quctt_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Are xutzijoj rij ri Judas, ukꞌojol ri Simón Iscariote, are riꞌ kajachow na. ");
INSERT INTO quctt_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Are ikꞌowinaq chik jun janipa qꞌij, ri Jesús kabꞌin pa Galilea. Maj jas kubꞌij ukꞌuꞌx keꞌ pa Judea, jeriꞌ rumal ri kꞌamal taq bꞌe kech ri winaq aꞌj Israel kakaj kakikamisaj. ");
INSERT INTO quctt_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Kꞌa karaj kꞌu na jun janipa qꞌij che ri nimaqꞌij kech ri winaq aꞌj Israel ubꞌiꞌnam Tabernáculos. ");
INSERT INTO quctt_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Xaq jeriꞌ ri e rachalal ri Jesús xkibꞌij che: Rajawaxik laꞌ katel bꞌik waral kateꞌ pa Judea, rech jeriꞌ kakil ri utz taq achak ri atijoxelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Jeriꞌ rumal xapachin karaj kukꞌut ri kubꞌano chikiwach ri winaq man kuya taj kubꞌan ri jastaq xaq pa awal, xane kuya bꞌe chike konojel ri winaq kakil ri kubꞌano. ");
INSERT INTO quctt_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Qas tzij wiꞌ chi xa ta ne ri rachalal ri Jesús kekojon che. ");
INSERT INTO quctt_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Rumal riꞌ ri Jesús xubꞌij chike: Qas tzij wi laꞌ chi ronojel qꞌij utz chiꞌwe ix, ri in kꞌut majaꞌ kuriq nuqꞌijal. ");
INSERT INTO quctt_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ri ix maj rumal kixketzelaj ri winaq, ri in kꞌut kinketzelaj rumal cher kinqꞌalajisaj chi man utz taj ri kakibꞌano. ");
INSERT INTO quctt_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Jix ix pa ri nimaqꞌij, ri in man kineꞌ ta na waꞌ, rumal cher majaꞌ kuriq nuqꞌijal. ");
INSERT INTO quctt_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Are xbꞌiꞌtaj we jastaq riꞌ rumal, xkanaj kanoq pa Galilea. ");
INSERT INTO quctt_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Are e bꞌenaq chi ri rachalal pa ri nimaqꞌij, xeꞌ xuqujeꞌ areꞌ, man xukꞌututej ta kꞌu ribꞌ xane xaq pa awal xeꞌek. ");
INSERT INTO quctt_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ri e kꞌamal taq kibꞌe ri winaq aꞌj Israel xkitzukuj ri Jesús pa ri nimaqꞌij, kakibꞌij chibꞌil taq kibꞌ: ¿Jawjeꞌ kꞌo wi? ");
INSERT INTO quctt_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kꞌi jastaq xkibꞌij ri winaq che. E kꞌi xkibꞌij chi jun utz achi, e kꞌo chi nikꞌaj xkibꞌij chi xaq kuꞌmenkꞌetij ri winaq. ");
INSERT INTO quctt_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Man kꞌo ta kꞌu jun chike ri winaq qas xubꞌij ri kꞌo pa ranimaꞌ, jeriꞌ rumal xkixiꞌj kibꞌ chikiwach ri e kꞌamal taq bꞌe. ");
INSERT INTO quctt_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ri Jesús xrayeꞌj na xnikꞌajar ri nimaqꞌij kꞌa te riꞌ xpaqiꞌ pa ri Templo chuyaꞌik kꞌutuꞌn. ");
INSERT INTO quctt_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ri winaq aꞌj Israel xemayijanik xkibꞌij: We achi ri man xeꞌ taj pa etaꞌmanik, ¿jawjeꞌ kꞌut xukꞌamawaꞌj wi nimalaj etaꞌmabꞌal? ");
INSERT INTO quctt_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ri Jesús xubꞌij chike: Ri nukꞌutuꞌn man wech taj in, xane rech ri xintaqow loq. ");
INSERT INTO quctt_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ri qas karaj kubꞌan ri urayibꞌal ukꞌuꞌx ri nuTat chuchꞌobꞌo we ri nukꞌutuꞌn kape rukꞌ ri Dios o xaq pa we wi kinbꞌij we jastaq riꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ri winaq ri xaq pa rech wi katzijonik, xaq are riꞌ kuya uqꞌij ribꞌ. Are kꞌu ri karaj kuqꞌijilaꞌj ri xtaqow loq, jun winaq sukꞌ ranimaꞌ riꞌ xuqujeꞌ qas tzꞌaqat. ");
INSERT INTO quctt_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿La man kꞌu xuya ri taqanik ri Moisés chiꞌwe ix? Pune jeriꞌ maj jun chiꞌwe kubꞌan ri kubꞌij ri taqanik. ¿Jas kꞌu che kiwaj kinikamisaj? ");
INSERT INTO quctt_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ri winaq xkibꞌij che: ¿Jachin le karaj katkamisanik? Jun itzel riꞌ kꞌo chawe. ");
INSERT INTO quctt_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ri Jesús xubꞌij chike: Xixmayijan ya che ri jun mayijabꞌal jastaq ri xinbꞌano. ");
INSERT INTO quctt_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Rumal riꞌ ri Moisés xixutaq chukojik ri retal ri ojer chꞌekom tzij pa ri ityoꞌjal, qas tzij kinbꞌij chiꞌwe, man are taj ri Moisés xixtaqow che we jastaq riꞌ, xane are ri itat inan ojer, kamik kꞌut xaq jeꞌ kakibꞌan ri winaq pune pa ri qꞌij rech uxlanem kakibꞌano. ");
INSERT INTO quctt_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kamik kꞌut, we kakoj ri etal rech chꞌekom tzij che jun achi pa ri qꞌij rech uxlanem, ¿jas kꞌu che kixyojtaj chwij we kinkunaj in jun winaq pa ri qꞌij rech uxlanem? ");
INSERT INTO quctt_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Man kiqꞌat ta tzij pa kiwiꞌ ri winaq rumal ri kekaꞌyik xane qas chibꞌana ri qꞌatoj tzij rukꞌ sukꞌal. ");
INSERT INTO quctt_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","E kꞌo kꞌu jujun chike ri winaq ri keꞌl pa Jerusalén xkibꞌij: ¿La man kꞌu are waꞌ ri achi ri kakaj kakikamisaj? ");
INSERT INTO quctt_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Leꞌ tajin katzijon chik junmul man kꞌo ta ya jun kabꞌin tzij che. ¿La xa ta kꞌu xkichꞌobꞌ le kꞌamal taq bꞌe chi qas are Cristo? ");
INSERT INTO quctt_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Qetaꞌm uj jawjeꞌ upetik wi we achi riꞌ, we kꞌu xpe ri Cristo maj jun riꞌ ketaꞌmanik jawjeꞌ upetik wi. ");
INSERT INTO quctt_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ri Jesús are kꞌo pa ri Templo, tajin kuya kꞌutuꞌn xubꞌij: Ri ix kibꞌij chi iwetaꞌm nuwach xuqujeꞌ iwetaꞌm jawjeꞌ nupetik wi. Man xinpe taj xaq pa we wi xane kꞌo jun xintaqow loq ri qas kuꞌl na kꞌuꞌx chirij, man iwetaꞌm ta kꞌu uwach ix. ");
INSERT INTO quctt_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ri in kꞌut wetaꞌm uwach rumal in che areꞌ in petinaq wi, xuqujeꞌ Areꞌ xintaqow loq. ");
INSERT INTO quctt_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ri winaq kꞌut xkaj xkichapo, pune jeriꞌ man kꞌo ta jun xchapowik rumal majaꞌ kuriq ri uqꞌijal. ");
INSERT INTO quctt_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pune jeriꞌ xbꞌix che ri Jesús, e kꞌi chike ri winaq ri e kꞌo pa ri Templo xekojon che xuqujeꞌ xkibꞌij: Are kape ri Cristo, ¿la kubꞌan ta kꞌu nimaq taq kꞌutbꞌal cho we kubꞌan we achi riꞌ? ");
INSERT INTO quctt_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Are xkita ri e fariseos xuqujeꞌ ri e kꞌamal taq kibꞌe ri e chꞌawenelabꞌ cho ri Dios ri kakibꞌij ri winaq che ri Jesús, xeꞌkitaq bꞌik nikꞌaj ajchꞌoꞌjabꞌ e chajil taq rech ri Templo rech keꞌkichapa loq. ");
INSERT INTO quctt_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ri Jesús xubꞌij chike ri winaq: Kinkꞌojiꞌ chi na jubꞌiqꞌ iwukꞌ, kꞌa te riꞌ kintzalij rukꞌ ri xintaqow loq. ");
INSERT INTO quctt_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kinitzukuj na, man kiniriq ta kꞌut, jeriꞌ rumal man kixkwin taj kixopanik jawjeꞌ ri kineꞌ wi. ");
INSERT INTO quctt_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ri winaq aꞌj Israel xkitatabꞌelaꞌ chibꞌil taq kibꞌ: ¿Jawjeꞌ ta kꞌu keꞌ wi che ri man keꞌqariqa taj? ¿La xa ta kꞌu keꞌ kukꞌ ri qawinaqil ri e tukininaq bꞌik, rech kuꞌya kꞌutuꞌn kukꞌ ri winaq aꞌj Grecia? ");
INSERT INTO quctt_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Jas ta kꞌu xraj xubꞌij rukꞌ ri utzij: “Kinitzukuj na, man kiniriq ta kꞌut xuqujeꞌ man kixkwin taj kixopanik jawjeꞌ ri kineꞌ wi in”? ");
INSERT INTO quctt_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Pa ri kꞌisbꞌal qꞌij rech ri nimaqꞌij, are waꞌ ri qꞌij ri sibꞌalaj nim ubꞌanik, ri Jesús xtakꞌiꞌ aqꞌanoq chkixoꞌl ri winaq, xubꞌij: We kꞌo jun kachaqiꞌj uchiꞌ, peta wukꞌ, qumunoq. ");
INSERT INTO quctt_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ri kakojon chwe in jetaq ri kubꞌij ri tzꞌibꞌatalik kabꞌin na nimaꞌ rech kꞌaslemal che. ");
INSERT INTO quctt_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Rukꞌ we riꞌ xuya ubꞌixik chi ri kekojon che kakikꞌamawaꞌj na ri Tyoxalaj Uxlabꞌixel. Che ri qꞌij riꞌ majaꞌ kayaꞌtaj ri Uxlabꞌixel chike ri winaq jeriꞌ rumal majaꞌ katzalitaj ri ujuluwem ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Are xkita ri winaq ri xubꞌij, jujun chike xkibꞌij: Qas tzij wi we achi riꞌ are Qꞌalajisal utzij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","E nikꞌaj chik xkibꞌij: “Are waꞌ ri Cristo,” e kꞌo xuqujeꞌ nikꞌaj chik xkibꞌij “¿La pa Galilea kꞌut kape wi ri Cristo? ");
INSERT INTO quctt_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿La man kꞌu kubꞌij ri Tzꞌibꞌatalik chi ri Cristo jun na chike ri Rijaꞌl ri David, xuqujeꞌ je laꞌ kape na pa ri tinimit Belén?” ");
INSERT INTO quctt_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Xkiqꞌat kꞌu kibꞌ ri winaq rumal rech ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","E kꞌo jujun chike ri winaq xkaj xkichapo, pune jeriꞌ man kꞌo ta kꞌu jun xutzaq uqꞌabꞌ chirij ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ri ajchꞌoꞌjabꞌ e chajil taq rech ri Templo are xetzalij kukꞌ ri e kꞌamal taq bꞌe e kachiꞌl ri e chꞌawenelabꞌ cho ri Dios, xta chike: ¿Jas che man xikꞌam ta loq ri Jesús? ");
INSERT INTO quctt_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ri chajinelabꞌ xkibꞌij: ¡Man kꞌo ta jun achi qatom je laꞌ katzijonik! ");
INSERT INTO quctt_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ri fariseos xkibꞌij chike: ¿La xixumenkꞌetij xuqujeꞌ ix? ");
INSERT INTO quctt_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿La kꞌo jun chike ri e qꞌatal taq tzij o jun chike ri fariseos kojoninaq che we achi riꞌ? ");
INSERT INTO quctt_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","¡Man kꞌo taj! Are kꞌu we winaq ri man ketaꞌm taj ri taqanik, e kꞌo riꞌ chuxeꞌ ri etzelal. ");
INSERT INTO quctt_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ri Nicodemo, jun chike ri fariseos, tzijoninaq kan rukꞌ ri Jesús nabꞌe, xubꞌij: ");
INSERT INTO quctt_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","¿La kuqꞌat kꞌu tzij ri qataqanik puꞌwiꞌ jun achi we man nabꞌe kutatabꞌej xuqujeꞌ kusol rij jas ri kubꞌano? ");
INSERT INTO quctt_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ri e rachiꞌl fariseos xkibꞌij che: ¿La man kꞌu at aj Galilea at? Chasolijampe rij rech kawilo chi man kꞌo ta jun qꞌalajisal utzij ri Dios ri kape je laꞌ pa Galilea. ");
INSERT INTO quctt_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Kꞌa te riꞌ xebꞌe kojonel cho kachoch. ");
INSERT INTO quctt_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Xeꞌ kꞌu ri Jesús pa ri juyubꞌ Olivos. ");
INSERT INTO quctt_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Are xsaqir chukabꞌ qꞌij, xopan chi junmul pa ri Templo. Konojel ri winaq xeqet rukꞌ, xtꞌuyiꞌk kꞌut, xuchapleꞌj uyaꞌik kꞌutuꞌn chike. ");
INSERT INTO quctt_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ri aꞌjtijabꞌ rech ri taqanik e kachiꞌl ri fariseos xkikꞌam bꞌik jun ixoq ri xkiriq pa mak kukꞌ achyabꞌ xeꞌkiya chikixoꞌl ri winaq ");
INSERT INTO quctt_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Kꞌa te riꞌ xkibꞌij che ri Jesús: Ajtij, xriqitaj we ixoq riꞌ tajin kamakun kukꞌ achyabꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ri utaqanik ri Moisés kubꞌij chaqe chi keꞌqakamisaj che abꞌaj ri ixoqibꞌ ri jewaꞌ kakibꞌano. ¿Jas kabꞌij lal che? ");
INSERT INTO quctt_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Jewaꞌ xkibꞌij che rech kakikoj jun kꞌaꞌmabꞌal pa ubꞌe rech jeriꞌ kakimol umak. Ri Jesús kꞌut xchiqiꞌk, xuchapleꞌj tzꞌibꞌanem pa ri ulew. ");
INSERT INTO quctt_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ri winaq xkichapleꞌj ubꞌanik kꞌotbꞌal chiꞌ che ri Jesús rumal riꞌ, xtakꞌiꞌk kꞌa te riꞌ xubꞌij chike: Ri maj umak chiꞌwe chukꞌyaqa ri nabꞌe abꞌaj. ");
INSERT INTO quctt_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ri Jesús xchiqiꞌ chi junmul xuchapleꞌj chik tzꞌibꞌanem pa ri ulew. ");
INSERT INTO quctt_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Are xkita ri xbꞌix chike xkichapleꞌj bꞌik elem pa jujunal, nabꞌe xebꞌe ri e riꞌjabꞌ, xaq xwi xekanaj kanoq ri Jesús rachiꞌl ri ixoq. ");
INSERT INTO quctt_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ri Jesús kꞌut xuta che ri ixoq: Ixoq, ¿jawjeꞌ e kꞌo wi ri kakiqꞌat tzij pa awiꞌ? ");
INSERT INTO quctt_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ri ixoq xubꞌij: Ajawxel, man e kꞌo ta chik. Ri Jesús xubꞌij che: Man kinqꞌat ta xuqujeꞌ tzij in pa awiꞌ. Jat, ma katmakun ta chik junmul. ");
INSERT INTO quctt_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ri Jesús junmul chik xubꞌij chike ri winaq: In in tunal ri katunan ri uwachulew. Ri kateriꞌ chwij man kabꞌin taj pa qꞌequꞌmal xane kukꞌamawaꞌj na ri tunal rech kꞌaslemal. ");
INSERT INTO quctt_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ri fariseos xkibꞌij che ri Jesús: Xaq at kaqꞌalajisaj awibꞌ maj kutayij ri qꞌalajisanik ri kabꞌano. ");
INSERT INTO quctt_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ri Jesús xubꞌij: Pune in kinqꞌalajisaj wibꞌ, qas saq ri nuqꞌalajisanik, jeriꞌ rumal wetaꞌm jawjeꞌ nupetik wi xuqujeꞌ jawjeꞌ kineꞌ wi. Ri ix kꞌut man iwetaꞌm taj jawjeꞌ nupetik xuqujeꞌ jawjeꞌ kineꞌ wi. ");
INSERT INTO quctt_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ri ix kiqꞌat tzij rukꞌ ri ichomabꞌal rech uwachulew, ri in man kinqꞌat taj tzij puꞌwiꞌ jun chik. ");
INSERT INTO quctt_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","We kꞌu kinqꞌat tzij, ri nuqꞌatoj tzij qas sukꞌ wi, jeriꞌ rumal man kinbꞌan ta xaq pa we wi, xane wachiꞌl ri Tataxel ri xintaqow loq. ");
INSERT INTO quctt_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Pa ri itaqanik kubꞌij chi we e kebꞌ winaq kebꞌanow ri qꞌalajisanik, qas tzij riꞌ ri kakibꞌij. ");
INSERT INTO quctt_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","In kinqꞌalajisaj wibꞌ xuqujeꞌ ri Tataxel ri xintaqow loq kuya qꞌalajisanik chwij in. ");
INSERT INTO quctt_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ri fariseos xkita che ri Jesús: ¿Jawjeꞌ kꞌo wi ri atat? Ri Jesús xubꞌij chike: We ta iwetaꞌm in jachinaq iwetaꞌm xuqujeꞌ riꞌ jachin ri nuTat. ");
INSERT INTO quctt_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","We jastaq riꞌ xubꞌij ri Jesús are tajin kuya kꞌutuꞌn pa ri kꞌolibꞌal jawjeꞌ kaya wi ri sipanik pa ri Templo. Maj kꞌu jun xchapowik jeriꞌ rumal majaꞌ kuriq ri uqꞌijal. ");
INSERT INTO quctt_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Junmul chik ri Jesús xubꞌij chike: In kineꞌek, ri ix kꞌut kinitzukuj na pune jeriꞌ kixkam kꞌu pa taq ri imak. Man kixkwin taj kixeꞌek jawjeꞌ ri kineꞌ wi in. ");
INSERT INTO quctt_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ri winaq aꞌj Israel xkibꞌij: ¿Teꞌq xa kuchomaj kukamisaj ribꞌ? ¿Wine rumal laꞌ kubꞌij chi: “Man kixkwin taj kixeꞌek jawjeꞌ ri kineꞌ wi”? ");
INSERT INTO quctt_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ri Jesús xubꞌij: Ix ix aj waral choch ri uwachulew, in in rech chikaj. Ix ix ajuwachulew, ri in man in ajuwachulew taj. ");
INSERT INTO quctt_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Rumal riꞌ xinbꞌij chiꞌwe chi kixkam pa taq ri imak, jeriꞌ rumal man kikoj taj chi in ri kinbꞌij chiꞌwe kinuxik, rumal riꞌ kixkam pa ri imak. ");
INSERT INTO quctt_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ri winaq xkita che: ¿At jachin kꞌu ri at? Ri Jesús xubꞌij chike: Pa ri majibꞌal re xinbꞌij chiꞌwe in jachinaq. ");
INSERT INTO quctt_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Sibꞌalaj kꞌi jastaq na kinbꞌij chiꞌwe xuqujeꞌ kinqꞌat na tzij pa iwiꞌ rumal rech kiꞌ jastaq. Are kꞌu ri xintaqow loq qas kꞌo wi, ri ubꞌim chwe are kintzalij ubꞌixik chike ri winaq aꞌjuwachulew. ");
INSERT INTO quctt_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ri winaq kꞌut man xkichomaj taj chi ri Jesús are tajin kutzijoj rij ri uTat. ");
INSERT INTO quctt_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ri Jesús xutzꞌaqatisaj ubꞌixik chike: Are kawaꞌjilisax ri uKꞌojol ri Achi, kiwetaꞌmaj na chi ri in man kinkwin taj kinbꞌan ri jastaq xqa pa we wi, xane are kinbꞌan ri ukꞌutum ri Tataxel chinuwach. ");
INSERT INTO quctt_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Kꞌo wukꞌ ri xintaqow loq, man in uyaꞌom ta kanoq nutukel, jeriꞌ rumal are kinbꞌan ri kaqaj choch. ");
INSERT INTO quctt_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tajin katzijon na ri Jesús are xkichapleꞌj kojonem che e kꞌi winaq. ");
INSERT INTO quctt_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Xubꞌij kꞌu ri Jesús chike ri winaq aꞌj Israel ri xekojon che: We qas kixjeqiꞌk pa ri nukꞌutuꞌn qas kixux riꞌ nutijoxelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kiwetaꞌmaj kꞌu na ri qas tzij, ri qas tzij kꞌut kubꞌan na chiꞌwe chi kixtzoqopitajik. ");
INSERT INTO quctt_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ri winaq aꞌj Israel xkibꞌij: Ri uj rijaꞌl ri Abraham, man ujuxinaq ta wi patanil rech jun chik. ¿Jas kꞌu che kabꞌij at chi kujtzoqopitaj na? ");
INSERT INTO quctt_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ri Jesús xubꞌij: Qas tzij kinbꞌij chiꞌwe xapachin ri kamakunik, riꞌ patanil rech ri mak. ");
INSERT INTO quctt_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Jun patanijel man kakanaj ta kanoq amaqꞌel pa ri ja ri kapatanij wi, are kꞌu ri alkꞌwaꞌlaxel chi aj upaja wi. ");
INSERT INTO quctt_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","We qas are ri Alkꞌwaꞌlaxel kixtzoqopinik, qas kixtzoqopitaj wi na. ");
INSERT INTO quctt_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Wetaꞌm in chi ix rijaꞌl ri Abraham, pune jeriꞌ are kiwaj kinikamisaj rumal cher man kiwaj taj kikꞌamawaꞌj ri nutzij. ");
INSERT INTO quctt_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","In are kintzijoj ri wilom rukꞌ ri nuTat, are kꞌu ri ix are kinbꞌan ri itom che ri itat. ");
INSERT INTO quctt_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ri winaq xkibꞌij: Are qatat uj ri Abraham. Ri Jesús xubꞌij chike: We ta qas ix ralkꞌwaꞌl ri Abraham, kibꞌan riꞌ jetaq ri xubꞌan areꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ix kꞌut are kiwaj kinikamisaj jeriꞌ rumal xintzijoj ri tunal chiꞌwe ri xuya chwe ri Dios. Ri Abraham man kubꞌan ta kꞌu riꞌ ri kichomaj ix ubꞌanik. ");
INSERT INTO quctt_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ri ix are kibꞌan ri uchak ri itat itzel. Ri winaq xkibꞌij: Uj, man uj ralkꞌwaꞌl ta mak. Xa jun qatat kꞌolik, are ri Dios. ");
INSERT INTO quctt_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ri Jesús xubꞌij chike: We ta qas are itat ri Dios, kiniloqꞌaj riꞌ, jeriꞌ rumal in in petinaq che ri Dios xuqujeꞌ in kꞌo waral iwukꞌ. Man in petinaq taj xaq pa we wi, xane Areꞌ xintaqow loq. ");
INSERT INTO quctt_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Jas che man kichomaj taj ri kinbꞌij? Man kichomaj taj rumal man kikꞌamawaꞌj taj ri nutzij. ");
INSERT INTO quctt_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ix ix rech ri itat ri Itzel, are kibꞌan ri urayibꞌal areꞌ. Kamisanel wi riꞌ areꞌ pa ri majibꞌal loq rech ronojel, man kꞌo taj pa ri tunal, jeriꞌ rumal man kꞌo ta tunal pa are. Are kubꞌan bꞌanoj tzij, kukꞌut ribꞌ chi xaq bꞌanal tzij. Ri itzel are utat ri bꞌanoj tzij. ");
INSERT INTO quctt_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Are kꞌu ri in man kinikoj taj pune are kinbꞌij chiꞌwe ri qas tzij. ");
INSERT INTO quctt_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Jachin chiꞌwe kakwin chukꞌutik chi in ajmak? We qas tzij ri kinbꞌij chiꞌwe, ¿jas kꞌu che kiwaj kinikamisaj? ");
INSERT INTO quctt_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ri winaq ri rech ri Dios kutatabꞌej ri kubꞌij ri Dios. Ri ix kꞌut man kitatabꞌej taj rumal man ix rech taj ri Dios. ");
INSERT INTO quctt_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ri winaq aꞌj Israel xkibꞌij che ri Jesús: ¿La man kꞌyaqal ri kaqabꞌij chawe chi at, at jun achi aj Samaria, ri kꞌo jun itzel uxlabꞌal chawe? ");
INSERT INTO quctt_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ri Jesús xubꞌij: Man kꞌo taj jun itzel uxlabꞌal chwe. Xaq xwi kinqꞌijilaꞌj ri nuTat, ri ix kꞌut xaq xwi kiwesaj nukꞌixibꞌal. ");
INSERT INTO quctt_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Man are ta kintzukuj kinya nuqꞌij chibꞌil wibꞌ, xane kꞌo jun ri karaj kaya uqꞌij, are riꞌ ri Qꞌatal tzij. ");
INSERT INTO quctt_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Qas tzij kinbꞌij chiꞌwe, ri kubꞌan ri kubꞌij ri nutzij man kakam taj. ");
INSERT INTO quctt_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ri winaq aꞌj Israel xkibꞌij: Chanim qas kaqakojo chi qas kꞌo jun itzel uxlabꞌal chawe. Xkam ri Abraham, xekam xuqujeꞌ konojel ri e qꞌalajisal taj utzij ri Dios, ri at kꞌut kabꞌij chi we kakojon jun che ri atzij, man kakam taj. ");
INSERT INTO quctt_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿La at ta kꞌut at nabꞌyal cho ri qatat Abraham? Areꞌ xkamik, xekꞌam xuqujeꞌ konojel ri e qꞌalajisal taj utzij ri Dios. ¿Jachin kabꞌij at katuxik? ");
INSERT INTO quctt_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ri Jesús xubꞌij chike: Man kꞌo ta kutayij riꞌ we xaq in kinya nuqꞌij chibꞌil wibꞌ. Ri kayoꞌw nuqꞌij in are ri nuTat ri kibꞌij ix iDios che, ");
INSERT INTO quctt_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","pune man iwetaꞌm uwach. Ri in kꞌut wetaꞌm uwach. We kinbꞌij chiꞌwe chi man wetaꞌm taj uwach, in jun bꞌanal tzij riꞌ jetaq ri ix. Ri in kꞌut wetaꞌm uwach xuqujeꞌ kinbꞌan ri kubꞌij ri utzij. ");
INSERT INTO quctt_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ri itat Abraham sibꞌalaj xkiꞌkotik are xuchomaj chi karil na ri nuqꞌij, are xrilo sibꞌalaj xkiꞌkotik. ");
INSERT INTO quctt_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ri winaq aꞌj Israel xkibꞌij che: Majaꞌ ne katzꞌaqat nikꞌaj ciento ajunabꞌ, ¿are ta kꞌu riꞌ kabꞌij chi xawil uwach ri Abraham? ");
INSERT INTO quctt_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ri Jesús xubꞌij chike: Qas tzij kinbꞌij chiꞌwe: Are taq majaꞌ kakꞌojiꞌ ri Abraham, In Riꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Xepe kꞌu ri winaq aꞌj Israel, xkisikꞌ abꞌaj rech kakikoj che ri Jesús. Ri Jesús kꞌut xrawaj ribꞌ, maj jun xilowik are xel bꞌik pa ri Templo. ");
INSERT INTO quctt_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Tajin kikꞌow bꞌik ri Jesús are xril jun achi moy wi pa ri ukꞌojiꞌkal. ");
INSERT INTO quctt_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ri utijoxelabꞌ xkita che: Jas che wa moy we achi ri pa ri ukꞌojiꞌkal ¿jachin chike waꞌ xmakunik, la areꞌ o aꞌreꞌ ri utat unan? ");
INSERT INTO quctt_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ri Jesús xubꞌij chike: Man areꞌ taj xmakunik, xuqujeꞌ man are ta ri utat unan. Xkꞌulmatajik we riꞌ rech kaqꞌalajin na ri kwinem ri Dios pa ri ukꞌaslemal. ");
INSERT INTO quctt_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Choqꞌaqꞌ kꞌut kinbꞌan ri uchak ri xintaqow loq, utz chi kꞌo na ri qꞌij, jeriꞌ rumal are kape ri aqꞌabꞌ maj jun kakwinik kachakunik. ");
INSERT INTO quctt_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Are in kꞌo in cho ri uwachulew, in riꞌ ri qꞌaqꞌ ri katunanik rech ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Are xbꞌiꞌtaj we tzij riꞌ rumal, xchubꞌan pa ri ulew, kꞌa te riꞌ xubꞌan xaqꞌoꞌl rukꞌ ri uchubꞌ, kꞌa te riꞌ xuqibꞌ che ri ubꞌoqꞌoch ri moy, xubꞌij che: ");
INSERT INTO quctt_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Jat jaꞌchꞌaja awibꞌ pa le jaꞌ chonolik ubꞌiꞌnam Siloé, ri kel kubꞌij Taqoꞌn. Ri moy achi xeꞌek xuꞌchꞌaja ribꞌ, kakaꞌy chik chi kꞌut are xtzalij loq. ");
INSERT INTO quctt_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ri uꞌkꞌulja ja ri achi xuqujeꞌ ri iꞌlowinaq kan nabꞌe chi kubꞌan ulimoxna xkibꞌij: ¿La man kꞌu are waꞌ ri achi ri katꞌuyiꞌk chutayik ulimoxna? ");
INSERT INTO quctt_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Jujun chike xkibꞌij: Jeꞌ areꞌ. Kꞌo chi nikꞌaj xkibꞌij: Man are taj, xa xaq raj junam kekaꞌy rukꞌ. Ri moy kꞌut xubꞌij chike: Jeꞌ, qas in wi. ");
INSERT INTO quctt_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Xkita kꞌu che: ¿Jas che kꞌut katkaꞌy chik? ");
INSERT INTO quctt_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ri achi xubꞌij: Ri achi ubꞌiꞌnam Jesús, xubꞌan jubꞌiqꞌ xaqꞌoꞌl xuqibꞌ che ri nubꞌoqꞌoch kꞌa te riꞌ xubꞌij chwe: “Jat jaꞌchꞌaja awibꞌ pa le jaꞌ chonolik ubꞌiꞌnam Siloé.” Jeriꞌ xineꞌek, xeꞌnchꞌaja wibꞌ kꞌa te riꞌ xinkwinik xinkaꞌyik. ");
INSERT INTO quctt_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ri winaq xkita che ri achi: ¿Jawjeꞌ kꞌo wi ri achi riꞌ? Man wetaꞌm taj, xcha chike. ");
INSERT INTO quctt_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ri winaq xkikꞌam bꞌik ri achi ri xkunatajik chikiwach ri fariseos. ");
INSERT INTO quctt_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ri Jesús xubꞌan ri xaqꞌoꞌl rech xujaq ri ubꞌoqꞌoch ri achi pa jun qꞌij rech uxlanem. ");
INSERT INTO quctt_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Rumal riꞌ ri fariseos xkita che ri achi jas xubꞌano rech xkaꞌy chik junmul. Ri achi xubꞌij: Xuqibꞌ xaqꞌoꞌl che ri nubꞌoqꞌoch, xinchꞌaj wibꞌ, chanim kꞌut kinkaꞌy chik. ");
INSERT INTO quctt_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","E jujun chike ri fariseos xkibꞌij: We achi riꞌ man che ta ri Dios petinaq wi, jeriꞌ rumal man kunimaj taj ri qꞌij rech uxlanem. E nikꞌaj chik xkibꞌij: ¿Jas che waꞌ kakwin jun ajmak chubꞌanik taq we jastaq riꞌ? Jeriꞌ ri winaq man xekwin taj xkijunamaj ri kichomanik. ");
INSERT INTO quctt_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Xkita chi kꞌu junmul che ri moy achi: ¿Jas kꞌu kabꞌij at che we achi ri xjaqow ri abꞌoqꞌoch? Ri achi xubꞌij chike: In kinbꞌij chi we achi riꞌ jun qꞌalajisal utzij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ri winaq aꞌj Israel man kakikoj ta kꞌut chi ri achi moy kan nabꞌe kamik kꞌut kakaꞌy chik, jeriꞌ xeꞌkisikꞌij ri utat unan. ");
INSERT INTO quctt_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Xkita chike: ¿La are waꞌ ri iwal ri kibꞌij chi moy pa ri ukꞌojiꞌkal? ¿Jas kꞌu che kakaꞌy chik kamik? ");
INSERT INTO quctt_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ri utat unan ri achi xkibꞌij: Qetaꞌm chi qal, xuqujeꞌ qetaꞌm chi moy are xkꞌojiꞌk. ");
INSERT INTO quctt_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ri man qetaꞌm taj are jas che kakaꞌy chik kamik. Chita che, riꞌj chik kakwin laꞌ kubꞌij chiꞌwe jas ri kiwaj che. ");
INSERT INTO quctt_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Jewaꞌ xkibꞌij ri utat unan rumal kakixiꞌj kibꞌ chike ri winaq aꞌj Israel, jeriꞌ rumal kichomanik kakesaj bꞌik pa ri Sinagoga ri winaq ri kubꞌij chi ri Jesús are Cristo. ");
INSERT INTO quctt_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Rumal riꞌ xkibꞌij ri utat unan: “Chita che. Riꞌj chik.” ");
INSERT INTO quctt_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Chukabꞌ mul ri e winaq aꞌj Israel xkisikꞌij ri achi ri moy kan nabꞌe xkibꞌij che: Chaya uqꞌij ri Dios. Qetaꞌm uj chi ri achi ri xatkunanik, ajmak. ");
INSERT INTO quctt_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ri achi xubꞌij chike: Man wetaꞌm taj we ajmak. Xaq xwi wetaꞌm chi in moy kan nabꞌe chanim kꞌut kinkaꞌy chik. ");
INSERT INTO quctt_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ri winaq xkita che: ¿Jas kꞌu xubꞌan chawe? ¿Jas xubꞌan chujaqik ri abꞌoqꞌoch? ");
INSERT INTO quctt_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ri achi xubꞌij: Man xita ta kꞌu ri xinbꞌij. ¿Jas che kiwaj kita chi junmul? ¿La xa kꞌu kiwaj kixok che utijoxelabꞌ? ");
INSERT INTO quctt_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ri winaq xkibꞌij che rukꞌ oyawal: At riꞌ at utijoxel, uj uj utijoxelabꞌ ri Moisés. ");
INSERT INTO quctt_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Qetaꞌm uj chi xchꞌabꞌex ri Moisés rumal ri Dios, we achi kꞌut riꞌ man ketaꞌm taj jawjeꞌ upetik wi. Ri uj qetaꞌm chi ri Dios xchꞌaw rukꞌ ri qamam Moisés. ");
INSERT INTO quctt_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ri achi xubꞌij: Jeꞌ, are kꞌu la ri mayijabꞌal chi man iwetaꞌm taj jawjeꞌ upetik wi we achi riꞌ, xujaq kꞌu ri nubꞌoqꞌoch in. ");
INSERT INTO quctt_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Qetaꞌm chi ri Dios man kuꞌta ta ri kichꞌawem ri aꞌjmakibꞌ xaq xwi kuꞌta ri e utz taq winaq xuqujeꞌ ri kakibꞌan ri urayibꞌal ukꞌuꞌx. ");
INSERT INTO quctt_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Man tatal ta wi junmul we kꞌo jun achi ujaqom ubꞌoqꞌoch jun ri moy pa ri ukꞌojiꞌkal. ");
INSERT INTO quctt_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","We ta mat che ri Dios petinaq wi we achi riꞌ, maj kakwin laꞌ kubꞌano. ");
INSERT INTO quctt_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ri winaq xkibꞌij che: At pa makaj xatalax wi, kꞌa te riꞌ kawaj ¿kaya kꞌutuꞌn chaqe? Xaq jeriꞌ xkesaj bꞌik pa ri Sinagoga. ");
INSERT INTO quctt_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ri Jesús xretaꞌmaj chi xesax bꞌik ri achi pa ri Sinagoga, xaq jeriꞌ are xuriqo xuta che: ¿La katkojon che ri uKꞌojol ri Achi? ");
INSERT INTO quctt_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ri achi xubꞌij: Ajawxel, bꞌij la chwe jachin riꞌ, rech kinkojon che. ");
INSERT INTO quctt_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ri Jesús xubꞌij che: Awilom chik uwach, are waꞌ ri tajin katzijon awukꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ri achi xubꞌij: Kinkojo, Wajaw. Xukiꞌ choch ri Jesús, kꞌa te riꞌ xuqꞌijilaꞌj. ");
INSERT INTO quctt_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ri Jesús xubꞌij che: In in petinaq chuqꞌatik tzij puꞌwiꞌ we uwachulew riꞌ, rech jeriꞌ kekaꞌy na ri e moyabꞌ are kꞌu ri kekaꞌyik kemoyir na. ");
INSERT INTO quctt_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jujun fariseos kꞌut are xkita ri xubꞌij, xkita che: ¿La uj moy kꞌu uj? ");
INSERT INTO quctt_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ri Jesús xubꞌij chike: We ta ix moy, man kꞌo ta imak riꞌ, xa kꞌu rumal kibꞌij chi kixkaꞌyik rumal riꞌ kꞌo imak. ");
INSERT INTO quctt_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Qas tzij kinbꞌij chiꞌwe: Ri man kok taj pa ri uchiꞌ ja rech ri korral kech ri chij, xane xa kaqꞌan bꞌik rech kutzukuj rokibꞌal, jun elaqꞌom riꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ri koꞌk bꞌik pa ri uchiꞌ ja are ajyuqꞌ kech ri chij. ");
INSERT INTO quctt_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ri chajil rech ri korral kujaq ri korral, xuqujeꞌ ri chij kakita ri uchꞌabꞌal ri ajyuqꞌ. Chi kijujunal kuꞌsikꞌij che ri kibꞌiꞌ rech jeriꞌ keꞌresaj loq pa ri korral. ");
INSERT INTO quctt_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Are keꞌsataj bꞌik ri e rech, kanabꞌej chikiwach, ri chij kꞌut kakitereneꞌj, rumal cher kakita ri uchꞌabꞌal. ");
INSERT INTO quctt_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Man kakitereneꞌj ta kꞌu jun we man ketaꞌm uwach, xane xa kaꞌnimaj choch, jeriꞌ rumal man kakita taj uchꞌabꞌal jun ri man ketaꞌm taj uwach. ");
INSERT INTO quctt_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ri Jesús xukoj we kꞌambꞌejabꞌal noꞌj riꞌ chikiwach ri winaq, man xkichꞌobꞌ ta kꞌut ri xraj xubꞌij. ");
INSERT INTO quctt_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Rumal riꞌ xutzalij ubꞌixik chike: Qas tzij kinbꞌij chiꞌwe, In in uchiꞌ ja jawjeꞌ koꞌk wi ri chij. ");
INSERT INTO quctt_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Eleqꞌomabꞌ ri xepe kan nabꞌe chinuwach in. Ri chij kꞌut man xkinimaj taj ri xbꞌix chike kumal. ");
INSERT INTO quctt_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","In ri in uchiꞌ ja. Ri kok loq pa we uchiꞌ ja riꞌ, kakolotaj na, kasolotaj na, xuqujeꞌ kuriq na utz laj echaꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ri elaqꞌom petinaq chubꞌanik elaqꞌ, kamisanik xuqujeꞌ tukinik. Ri in kꞌut in petinaq rech kayaꞌtaj na ikꞌaslemal, jun alik kꞌaslemal. ");
INSERT INTO quctt_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","In riꞌ ri sibꞌalaj utz ajyuqꞌ. Ri utz laj ajyuqꞌ kuya ri ukꞌaslemal pa kiwiꞌ ri chij. ");
INSERT INTO quctt_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Man are taj ajyuqꞌ ri xwi rayeꞌm tojbꞌal rech, man are taj ajchoqꞌe ri chij. Jeriꞌ rumal cher ri xwiꞌ rayeꞌm tojbꞌal rech, are karilo chi kaqebꞌ loq ri kayoꞌt, kanimaj bꞌik, kuꞌtzaq kan ri chij. Ri kayoꞌt kꞌut kuchapleꞌj ubꞌanik kꞌax chike ri chij rech ketukin bꞌik. ");
INSERT INTO quctt_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ri achi riꞌ kanimaj bꞌik rumal cher retaꞌm chi xwi rayeꞌm ri tojbꞌal rech, man are ta kꞌax ukꞌuꞌx chike ri chij. ");
INSERT INTO quctt_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","In riꞌ ri in utz laj ajyuqꞌ, wetaꞌm kiwach ri nuchij, aꞌreꞌ xuqujeꞌ ketaꞌm nuwach in. ");
INSERT INTO quctt_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Jacha ri Tataxel retaꞌm nuwach in, in xuqujeꞌ wetaꞌm uwach areꞌ xuqujeꞌ kinya ri nukꞌaslemal pa kiwiꞌ ri chij. ");
INSERT INTO quctt_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","E kꞌo chi na nikꞌaj e nuchij ri man e kꞌo ta pa we korral riꞌ, rajawaxik kꞌut keꞌnkꞌam na loq waral. Rech jeriꞌ kakita ri nuchꞌabꞌal rech xa jun wokaj chij, xuqujeꞌ xa jun ajyuqꞌ chike konojel. ");
INSERT INTO quctt_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Rumal kꞌu riꞌ kinuloqꞌaj ri Tataxel: Jeriꞌ rumal kinjach ri nukꞌaslemal, rech jeriꞌ kinkwinik kinkꞌam chi na junmul. ");
INSERT INTO quctt_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Maj jun kakwinik kesan ri nukꞌaslemal, xane in pa wanimaꞌ kape wi chi kinyaꞌo. Kꞌo nukwinem chujachik ri nukꞌaslemal xuqujeꞌ chukꞌamik chi junmul. Are waꞌ ri taqanik ri xinkꞌamawaꞌj che ri nuTat. ");
INSERT INTO quctt_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Are xkita ri winaq aꞌj Israel we tzij riꞌ, xkichapleꞌj ujachik kibꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","E kꞌi chike ri winaq xkibꞌij: Xa kꞌo jun itzel uxlabꞌal che xuqujeꞌ sibꞌalaj kon. ¿Jas che kitatabꞌej koq? ");
INSERT INTO quctt_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","E kꞌo chi nikꞌaj xkibꞌij: We tzij riꞌ man rech taj jun winaq ri kꞌo itzel uxlabꞌal che. ¿La kꞌo ta kꞌu jun riꞌ ri kꞌo itzel uxlabꞌal che kujaq kibꞌoqꞌoch ri e moyabꞌ? ");
INSERT INTO quctt_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Pa taq ri qꞌij riꞌ tajin kikꞌowisax ri nimaqꞌij rech naꞌtabꞌal rech ri tzujuꞌnijik rech ri templo, pa taq ri qꞌalaj. ");
INSERT INTO quctt_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ri Jesús kawaꞌkat pa ri Templo, chuxukut ri raqan ja rech ri Salomón. ");
INSERT INTO quctt_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Xepe kꞌu ri winaq aꞌj Israel, xkimulij kibꞌ chrij, xkita che: ¿Kꞌa jampaꞌ kattaniꞌk chubꞌanik kꞌax che ri qanimaꞌ? Chabꞌij chaqe wa qas at at Cristo. ");
INSERT INTO quctt_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ri Jesús xubꞌij chike: Nubꞌim chik chiꞌwe, man kikoj ta kꞌut. Are kinqꞌalajisan ri jastaq ri kinbꞌan pa ubꞌiꞌ ri nuTat. ");
INSERT INTO quctt_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ix man kixkojon ta chwe, jeriꞌ rumal man ix kachiꞌl taj ri nuchij. ");
INSERT INTO quctt_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ri e nuchij kakita ri nuchꞌabꞌal. In wetaꞌm kiwach xuqujeꞌ kinkitereneꞌj. ");
INSERT INTO quctt_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","In kinya kikꞌaslemal ri maj ukꞌisik, man kasach ta kꞌu kiwach, xuqujeꞌ maj jun kakwin chkesaxik pa nuqꞌabꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ri nuTat ri yoꞌwinaq chwe, are sibꞌalaj nim chikiwach konojel. Maj kꞌu jun keꞌsan pa ri uqꞌabꞌ ri Tataxel. ");
INSERT INTO quctt_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ri in xuqujeꞌ ri Tataxel xa jun qaꞌnik. ");
INSERT INTO quctt_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Junmul chik xkisikꞌ abꞌaj ri winaq aꞌj Israel rech kakikoj che ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ri Jesús xubꞌij chike: Nubꞌanom sibꞌalaj kꞌi utz taq chak ri petinaq che ri Tataxel. ¿Jachike rumal ri nubꞌanom kiwaj kinibꞌan che abꞌaj? ");
INSERT INTO quctt_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ri winaq aꞌj Israel xkibꞌij che: Man katqabꞌan taj che abꞌaj rumal jun chike ri chak abꞌanom xane rumal ri awas ri kabꞌij. Jeriꞌ rumal at achi uloq kabꞌij chi at Dios. ");
INSERT INTO quctt_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ri Jesús xubꞌij chike: ¿La man kꞌu tzꞌibꞌatal pa ri itaqanik: In nubꞌim chi ix ix dioses? ");
INSERT INTO quctt_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","We are ri Dios xubꞌij “dioses” chike ri winaq ri xya wi ri tzij (man kuya taj kaqꞌipix ri tzꞌibꞌatalik). ");
INSERT INTO quctt_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¿Jas che kibꞌij chi awas ri xubꞌij ri xqꞌat rumal ri Dios, kꞌa te riꞌ xtaq loq choch ri uwachulew? ¿La xa kꞌu rumal xubꞌij: In in Ralkꞌwaꞌl ri Dios? ");
INSERT INTO quctt_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Man kinikoj taj we man kinbꞌan ri uchak ri nuTat. ");
INSERT INTO quctt_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","We kꞌu are tajin kinbꞌan ri karaj ri nuTat, chikojo ri nuchak ri tajin kinbꞌano rech jeriꞌ kichꞌobꞌo chi ri Tataxel kꞌo pa in xuqujeꞌ in in kꞌo pa ri Tataxel. ");
INSERT INTO quctt_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Junmul chik xkaj xkichap bꞌik, ri Jesús kꞌut xresaj bꞌik ribꞌ pa kiqꞌabꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Xtzalij ri Jesús chꞌaqaꞌp che ri Jordán, chilaꞌ jawjeꞌ xubꞌan wi qasanaꞌ ri Juan; xkanaj kꞌu kan chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","E kꞌi winaq xoꞌpan rukꞌ, xkibꞌij che: Pune maj jun kꞌutbꞌal xubꞌan ri Juan, ronojel kꞌu ri xubꞌij chirij we achi riꞌ qas tzij wi. ");
INSERT INTO quctt_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","E kꞌi winaq ri keꞌl chilaꞌ xekojon che ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Kꞌo jun achi yawabꞌ ubꞌiꞌ Lázaro aj pa ri tinimit Betania chilaꞌ jawjeꞌ ri keꞌl wi ri e ranabꞌ María rachiꞌl ri Marta. ");
INSERT INTO quctt_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ri María are waꞌ ri xqꞌijow kꞌokꞌ kunabꞌal chirij ri Ajawxel, xuqujeꞌ xusuꞌ ri raqan rukꞌ ri uwiꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","We kebꞌ alaxik riꞌ xetaqan chubꞌixik che ri Jesús: Ajawxel, ri sibꞌalaj loqꞌ ech chꞌabꞌeꞌn la yawabꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Are xuta ri Jesús we riꞌ, xubꞌij: We yabꞌilal riꞌ man kakꞌis taj pa kamik xane qꞌijilaꞌbꞌal rech ri Dios, rech jeriꞌ kaqꞌijilaꞌtaj na ri Ukꞌojol ri Dios. ");
INSERT INTO quctt_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ri Jesús sibꞌalaj uꞌloqꞌ ri Marta rachiꞌl ri María, xuqujeꞌ ri Lázaro. ");
INSERT INTO quctt_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pune xuto chi yawabꞌ ri Lázaro, xkanaj chi na kan kebꞌ qꞌij jawjeꞌ ri kꞌo wi. ");
INSERT INTO quctt_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Kꞌa te riꞌ xubꞌij chike ri utijoxelabꞌ: Chujtzalij pa Judea. ");
INSERT INTO quctt_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ri tijoxelabꞌ xkibꞌij: Ajtij, chi jun janipa qꞌij kanoq ri winaq aꞌj Israel raj xkibꞌan laꞌ che abꞌaj ¿kaj kꞌu la katzalij chi la je laꞌ? ");
INSERT INTO quctt_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ri Jesús xubꞌij chike: ¿La man kꞌu kabꞌlajuj hora kꞌo pa jun qꞌij? Ri winaq ri kabꞌin paqꞌij man kutopij taj uwiꞌ raqan rumal cher katunax rumal ri qꞌij rech ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ri winaq kꞌut ri chaqꞌabꞌ kabꞌinik kutopij uwiꞌ raqan rumal cher man katunax taj rumal ri tunal ri katunanik. ");
INSERT INTO quctt_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Kꞌa te riꞌ xutzꞌaqatisaj ubꞌixik: Ri qech chꞌabꞌeꞌn Lázaro xa tajin kawarik, kineꞌ chanim chukꞌasuxik. ");
INSERT INTO quctt_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ri tijoxelabꞌ xkibꞌij: Ajawxel, we xaq tajin kawarik, kawaꞌjil na riꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ri Jesús are xutzijoj rij ri ukamikal ri Lázaro, ri tijoxelabꞌ kꞌut pa kikꞌuꞌx chi are xutzijoj rij ri waram. ");
INSERT INTO quctt_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ri Jesús kꞌyaqal xubꞌan chubꞌij chike: Xkam ri Lázaro. ");
INSERT INTO quctt_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Kinkiꞌkotik man in kꞌo ta chilaꞌ rech jeriꞌ kixkojon chwe. Joꞌmpeꞌ, jeꞌ qilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ri Tomás ri kabꞌix Yoꞌx che xubꞌij: Joꞌ, xuqujeꞌ uj rech kujeꞌkam rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Are xopan ri Jesús, xuto chi ri Lázaro kajibꞌ qꞌij chik kꞌo pa ri muqbꞌal. ");
INSERT INTO quctt_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ri tinimit Betania oxibꞌ kilómetro unajal che ri Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","E kꞌi winaq kꞌut oꞌpaninaq chi kichꞌabꞌexik ri Marta rachiꞌl ri María, cho ri kachoch rumal ri ukamikal ri kixibꞌal. ");
INSERT INTO quctt_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Are xretaꞌmaj ri Marta chi opanem tajin kubꞌan ri Jesús, xeꞌ chukꞌulaxik; are kꞌu ri María xkanaj kan cho ri ja. ");
INSERT INTO quctt_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Xubꞌij ri Marta che ri Jesús: We ta kꞌo la waral, ma ta xkam riꞌ ri nuxibꞌal. ");
INSERT INTO quctt_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pune jeriꞌ wetaꞌm in chi ri Dios kuya na xapakux ri kuta jun che. ");
INSERT INTO quctt_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Xubꞌij ri Jesús che: Ri axibꞌal kakꞌastaj na. ");
INSERT INTO quctt_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ri Marta xubꞌij: Jeꞌ wetaꞌm chi kakꞌastaj na pa ri kꞌisbꞌal qꞌij. ");
INSERT INTO quctt_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ri Jesús kꞌut xubꞌij che: In in kꞌastajibꞌal wach xuqujeꞌ in kꞌaslemal. Ri kakojon chwe pune kakamik, kakꞌasiꞌ na. ");
INSERT INTO quctt_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Xuqujeꞌ xapachin ri kꞌaslik xuqujeꞌ kakojon chwe, man kakam ta wi. ¿La kakoj we kinbꞌij chawe? ");
INSERT INTO quctt_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ri Marta xubꞌij: Jeꞌ, Ajawxel, kinkojo chi lal lal Cristo, uKꞌojol ri Dios, ri petinaq choch ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Are xbꞌiꞌtaj we riꞌ rumal ri Marta, xtzalij cho rachoch, xuꞌsikꞌij loq ri rachalal María, xubꞌij che: Xaq pa awal, ri Ajtij kꞌo waral, katusikꞌij. ");
INSERT INTO quctt_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Xuta ri María chi jeriꞌ, xwaꞌjil bꞌik aninaq xeꞌ rukꞌ ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Majaꞌ kok bꞌik ri Jesús pa ri tinimit xane kꞌo na kan pa ri leꞌaj jawjeꞌ xtzijon wi rukꞌ ri Marta. ");
INSERT INTO quctt_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ri winaq aꞌj Israel ri e kꞌo rukꞌ ri María chukubꞌisaxik ukꞌuꞌx, are xkilo chi aninaq xwaꞌjil bꞌik, xkitereneꞌj bꞌik, pa kikꞌuꞌx chi xa keꞌ pa ri muqbꞌal rech koꞌqꞌoq. ");
INSERT INTO quctt_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Are xopan ri María jawjeꞌ ri kꞌo wi ri Jesús, xrilo, kꞌa te riꞌ xukulik xqaj choch xubꞌij che: Wajaw we ta lal kꞌo la waral, ma ta xkam riꞌ ri nuxibꞌal. ");
INSERT INTO quctt_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ri Jesús are xrilo chi xoqꞌ ri María rachiꞌl ri winaq aꞌj Israel ri xebꞌe rukꞌ, sibꞌalaj xkꞌaxir ranimaꞌ ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Xuta chike: ¿Jawjeꞌ ximuq wi? Ri winaq xkibꞌij che: Peta la, jul ila la. ");
INSERT INTO quctt_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Xoqꞌ ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ri winaq aꞌj Israel xkibꞌij: Chiwilampeꞌ, sibꞌalaj uloqꞌ ri Lázaro. ");
INSERT INTO quctt_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","E kꞌo chi jujun xkibꞌij: Are waꞌ we achi riꞌ ri xjaqow ubꞌoqꞌoch ri moy achi, ¿la man kꞌu xkwinik xuqꞌatej ri Lázaro rech man xkam taj? ");
INSERT INTO quctt_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Xkꞌaxir chi junmul ri ranimaꞌ ri Jesús xqebꞌ chuxukut ri muqbꞌal. Ri muqbꞌal jun jul ri tzꞌapital uchiꞌ rukꞌ jun abꞌaj. ");
INSERT INTO quctt_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ri Jesús xubꞌij chike ri winaq: Chiwesaj le abꞌaj. Ri Marta ranabꞌ ri kaminaq xubꞌij: Ajawxel, kꞌo chi ruxlabꞌ laꞌ, rumal cher kajibꞌ qꞌij chik kꞌo chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Xubꞌij ri Jesús che: ¿La man kꞌu xinbꞌij chawe chi we katkojonik kawil na ri ujuluwem ri Dios? ");
INSERT INTO quctt_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Xaq jeriꞌ xkesaj ri abꞌaj. Ri Jesús xuwaꞌjilisaj ri ukaꞌyebꞌal, xubꞌij: Tat, kintyoxin che la rumal cher in tatabꞌem wi la. ");
INSERT INTO quctt_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Wetaꞌm wi chi kintatabꞌej la ronojel mul, xinbꞌij kꞌu we riꞌ kumal ke we winaq ri e kꞌo waral, rech jeriꞌ kakikojo chi lal xintaqow la loq. ");
INSERT INTO quctt_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Are xbꞌiꞌtaj we tzij riꞌ rumal, xuraq uchiꞌ rukꞌ ronojel uchuqꞌabꞌ, xubꞌij: ¡Lázaro chatel loq! ");
INSERT INTO quctt_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ri kaminaq xel loq, bꞌatzꞌtal ri uqꞌabꞌ xuqujeꞌ ri raqan, xwi kaqꞌalajin loq ri upalaj pistal pa jun atzꞌyaq, kꞌa te riꞌ xubꞌij ri Jesús chike: Chikira le atzꞌyaq chirij, chiya bꞌe che keꞌek. ");
INSERT INTO quctt_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","E kꞌi chike ri winaq ri e bꞌenaq chukubꞌisaxik ukꞌuꞌx ri María, xekojon che ri Jesús are xkil ri xubꞌano. ");
INSERT INTO quctt_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","E kꞌo kꞌu jujun chike xeꞌkitzijoj chike ri fariseos ri xubꞌan ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Are kꞌu ri e kꞌamal taq kibꞌe ri e chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq xuqujeꞌ ri fariseos xeꞌkimulij ri e yaꞌl taq noꞌj, xkibꞌij: ¿Jas kaqabꞌano? We achi riꞌ tajin kubꞌan sibꞌalaj kiꞌ mayijabꞌal taq kꞌutbꞌal. ");
INSERT INTO quctt_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","We xaq kaqaya bꞌe che jewaꞌ kubꞌano, konojel laꞌ kekojon che, kepe kꞌu laꞌ le winaq aꞌj Roma kulkikꞌisa puꞌwiꞌ le Templo, xuqujeꞌ puꞌwiꞌ le qatinimit. ");
INSERT INTO quctt_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Jun chike ri e kꞌamal taq bꞌe ubꞌiꞌ Caifás, kinimaꞌqil ri chꞌawenelabꞌ cho ri Dios, che ri junabꞌ riꞌ, xubꞌij chike: Qas maj iwetaꞌmabꞌal ix. ");
INSERT INTO quctt_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","¿La man kꞌu kichomaj chi are katanik we xa jun achi kakam kumal ke we tinimit, cho we kasach uwach ronojel le tinimit? ");
INSERT INTO quctt_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Man xubꞌij ta kꞌu we riꞌ rumal je xraj areꞌ, xane xubꞌij rumal are kinimaꞌqil ri chꞌawenelabꞌ cho ri Dios che ri junabꞌ riꞌ, xuqꞌalajisaj kꞌut chi ri Jesús kakam na pa kiwiꞌ ri winaq aꞌj Israel. ");
INSERT INTO quctt_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Man xwi ta kꞌu rumal rech ri tinimit riꞌ xane kumal ke konojel ri e ralkꞌwaꞌl ri Dios ri e tukininaq bꞌik rech jeriꞌ kakwinik kubꞌan jun chike. ");
INSERT INTO quctt_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Xaq jeriꞌ tzi che ri qꞌij riꞌ xkijunamaj kikꞌuꞌx kakikamisaj ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Rumal riꞌ ri Jesús man kawaꞌkatilobꞌ ta chik chikiwach ri winaq aꞌj Israel. Xane xeꞌ pa jun tinimit naqaj che ri leꞌaj ri e maj wi ja, pa ri tinimit ubꞌiꞌnam Efraín, chilaꞌ xkanaj wi kanoq e rachiꞌl ri utijoxelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Xa jubꞌiqꞌ karaj kuriq ri kinimaqꞌij ri winaq aꞌj Israel ubꞌiꞌnam Pascua, jeriꞌ e kꞌi kelik bꞌik cho taq ri saq, xepaqiꞌ pa Jerusalén chuchꞌajchꞌobꞌexik kibꞌ utz majaꞌ kuriq ri Pascua. ");
INSERT INTO quctt_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tajin kꞌu kakitzukuj ri Jesús, are e kꞌo pa ri Templo, kakibꞌila chibꞌil taq kibꞌ: ¿Jas kibꞌij ix? ¿Teꞌq man kape ta riꞌ pa we nimaqꞌij riꞌ? ");
INSERT INTO quctt_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Are kꞌu ri e kinimaꞌqil ri e chꞌawenelabꞌ cho ri Dios e kachiꞌl ri fariseos xetaqanik rech we kꞌo ketaꞌmanik jawjeꞌ kꞌo wi ri Jesús, kabꞌan tzujunem rech jeriꞌ kachapik. ");
INSERT INTO quctt_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Waqibꞌ qꞌij na karaj ri nimaqꞌij Pascua are xopan ri Jesús pa ri tinimit Betania, jawjeꞌ kel wi ri Lázaro, ri xukꞌastajisaj. ");
INSERT INTO quctt_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Chilaꞌ xbꞌan wi jun waꞌim chuyaꞌik uqꞌij ri Jesús. Ri Marta kapatanijik, are kꞌu ri Lázaro jun chike ri e kꞌo puꞌwiꞌ ri mexa rukꞌ ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Xpe kꞌu ri María, xukꞌam nikꞌaj litro rech jun kꞌokꞌ kunabꞌal sibꞌalaj paqal rajil ubꞌiꞌnam nardo, xutix chirij raqan ri Jesús, kꞌa te riꞌ xusuꞌu rukꞌ ri uwiꞌ. Xnoj kꞌu ri ja che ruxlabꞌ ri kꞌokꞌ kunabꞌal. ");
INSERT INTO quctt_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ri Judas Iscariote jun chike ri utijoxelabꞌ ri Jesús xuqujeꞌ are waꞌ ri kakꞌayin na ri Jesús xubꞌij: ");
INSERT INTO quctt_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","¿Jas che man xkꞌayix ta waꞌ we kunabꞌal riꞌ we sibꞌalaj paqal rajil, jeriꞌ kasipax ri rajil chike ri e mebꞌaibꞌ? ");
INSERT INTO quctt_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Xubꞌij we riꞌ man rumal ta cher qas kutoqꞌobꞌisaj kiwach ri e mebꞌaibꞌ, xane xa rumal cher areꞌ jun elaqꞌom, xuqujeꞌ are kilow ri pwaq, naqꞌatal che kareleqꞌaj kan rech che ri kayak pa ri kꞌolibꞌal. ");
INSERT INTO quctt_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ri Jesús xubꞌij che: Chaya chilaꞌ. We ixoq riꞌ uyakom we kunabꞌal naꞌtabꞌal rech ri qꞌij are kinmuqiꞌ na. ");
INSERT INTO quctt_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","E kꞌo wi laꞌ le mebꞌaibꞌ iwukꞌ, ri in kꞌut man in kꞌo taj ronojel qꞌij iwukꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","E kꞌi kꞌu chike ri winaq aꞌj Israel xkito chi kꞌo ri Jesús chilaꞌ, xebꞌe chi rilik man xwi taj xeꞌkila ri Jesús xane xeꞌkila xuqujeꞌ ri Lázaro, ri xkꞌastajisax rumal ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ri e kinimaꞌqil ri chꞌawenelabꞌ cho ri Dios xkichomaj xuqujeꞌ ukamisaxik ri Lázaro. ");
INSERT INTO quctt_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Jeriꞌ, rumal xa rumal rech areꞌ e kꞌi kakitas kibꞌ chike ri winaq aꞌj Israel rech kekojon che ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Chukabꞌ qꞌij sibꞌalaj e kꞌi winaq ri e bꞌenaq pa ri nimaqꞌij, xketaꞌmaj chi ri Jesús bꞌenaq pa Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Xkitzukuj uqꞌabꞌ taq palmas, xebꞌe chukꞌulaxik, kakiraqaqej kichiꞌ kakibꞌij: Nim uqꞌij ri Dios.Tewchiꞌtal ri petinaq pa ri ubꞌiꞌ ri Ajawxel. Tewchiꞌtal ri ubꞌiꞌ ri nim taqanel rech Israel. ");
INSERT INTO quctt_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Xuriq kꞌu ri Jesús jun laj bꞌur, xkejen bꞌik chirij, jetaq ri kubꞌij ri tzꞌibꞌatalik. ");
INSERT INTO quctt_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Maxiꞌj awibꞌ umiꞌalSión. Chawilampeꞌ, petinaq ri ataqanel, kejeninaq la puꞌwiꞌ jun laj bꞌur. ");
INSERT INTO quctt_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ri tijoxelabꞌ man xkichꞌobꞌ taj ri tajin kakꞌulmatajik. Are xyaꞌtaj uqꞌij ri Jesús xkichꞌobꞌo chi xkꞌulmataj rukꞌ ri tzꞌibꞌatal loqꞌ chirij pa ri taqanik. ");
INSERT INTO quctt_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Are kꞌu ri winaq ri xekꞌojiꞌ rukꞌ ri Jesús are xukꞌastajisaj ri Lázaro pa ri muqbꞌal, man xetaniꞌ taj chutzijoxik ri xkilo. ");
INSERT INTO quctt_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ri winaq ri xkita ri kꞌutbꞌal ri xubꞌan ri Jesús xeꞌl loq chukꞌamawaꞌxik. ");
INSERT INTO quctt_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Rumal riꞌ xkibꞌij ri fariseos chibꞌil taq kibꞌ: Qas kiwilo leꞌ, maj kujkwin chubꞌanik. ¡Chiwilampeꞌ le kakibꞌan konojel le winaq chutereneꞌxik! ");
INSERT INTO quctt_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","E kꞌo kꞌu jujun aꞌj Grecia chikixoꞌl ri e bꞌenaq chuyaꞌik qꞌijilaꞌnem pa ri nimaqꞌij. ");
INSERT INTO quctt_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Xeqet rukꞌ ri Felipe ri kel pa Betsaida pa Galilea, xkibꞌij che: Kaqaj kaqil ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ri Felipe xeꞌ chubꞌixik che ri Andrés, kꞌa te riꞌ kikobꞌchal xebꞌe chubꞌixik che ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ri Jesús xubꞌij chike: Xuriq ri qꞌotaj are kaya uqꞌij ri uKꞌojol ri Achi. ");
INSERT INTO quctt_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Qas tzij kinbꞌij chiꞌwe, we man kaqaj ri uwach ri tiriko pa ri ulew rech kakamik, kakanaj kan riꞌ utukel. Are kꞌu we kakamik, kuya na sibꞌalaj kꞌi uwach. ");
INSERT INTO quctt_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ri kuloqꞌaj ri ukꞌaslemal kutzaq na riꞌ, are kꞌu ri karetzelaj ri ukꞌaslemal rech we uwachulew riꞌ, kuyak na riꞌ rech kuriq jun kꞌaslemal ri maj ukꞌisik. ");
INSERT INTO quctt_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ri karaj kinupatanij rajawaxik kinutereneꞌj xuqujeꞌ jawjeꞌ ri kinkꞌojiꞌ wiꞌ in, chilaꞌ kakꞌojiꞌ xuqujeꞌ wi ri patanil we. Ri kinupatanij, kaya na uqꞌij rumal ri nuTat. ");
INSERT INTO quctt_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Chanim kabꞌison ri wanimaꞌ. ¿La kuya kꞌut kinbꞌij: “Tat chinkolo la cho we kꞌaxa qꞌotaj riꞌ”? Rumal kꞌu ne waꞌ in petinaq. ");
INSERT INTO quctt_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","¡Tat, nimarisaj ri bꞌiꞌ la! Xtataj kꞌut jun chꞌabꞌal pa ri kaj, xubꞌij: Nunimarisam chik, kinnimarisaj chi kꞌu na junmul. ");
INSERT INTO quctt_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Sibꞌalaj kꞌi winaq e kꞌo chilaꞌ, are xkita we chꞌabꞌal riꞌ xkibꞌij chi jun kaqulja ri xkito, e nikꞌaj chik xkibꞌij jun ángel riꞌ ri xchꞌawik. ");
INSERT INTO quctt_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ri Jesús xubꞌij chike: Man rumal ta we in xtataj ri chꞌabꞌal riꞌ, xane rumal iwe ix. ");
INSERT INTO quctt_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Xopan kꞌu ri qꞌij ri kaqꞌat tzij puꞌwiꞌ we uwachulew, xuqujeꞌ kesax bꞌik ri kabꞌan rech puꞌwiꞌ we uwachulew. ");
INSERT INTO quctt_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Are kꞌu kinwaꞌjilisax bꞌik choch we uwachulew, keꞌnkꞌam na konojel ri winaq rech kuꞌx wech. ");
INSERT INTO quctt_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Rukꞌ wa xubꞌij jas jeꞌ ubꞌanik ri kamikal ri kuriqo. ");
INSERT INTO quctt_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ri winaq xkibꞌij: Qetaꞌmam pa ri taqanik kubꞌij chi ri Cristo kakꞌojiꞌ na chibꞌe qꞌij saq. ¿Jas kꞌu che kabꞌij at chi ri uKꞌojol ri Achi kawaꞌjilisax na bꞌik? ¿Jachin kꞌu riꞌ ri? ");
INSERT INTO quctt_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ri Jesús xubꞌij chike: Ri tunal ri katunanik kakꞌojiꞌ chi na jubꞌiqꞌ iwukꞌ. Chixbꞌinoq utz kꞌa kꞌo na ri tunal, utz kꞌamajaꞌ kixuchꞌuq kan ri qꞌequꞌmal. Jeriꞌ rumal cher ri kabꞌin pa qꞌequꞌmal man retaꞌm taj jawjeꞌ keꞌ wi. ");
INSERT INTO quctt_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Chixkojon che ri tunal, utz kꞌa kꞌo na iwukꞌ, rech jeriꞌ kixux ralkꞌwaꞌl ri tunal. Are xbꞌiꞌtaj we jastaq riꞌ rumal ri Jesús, xeꞌek xeꞌrawaj ribꞌ chikiwach ri winaq. ");
INSERT INTO quctt_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ri Jesús, pune xubꞌan ronojel we kꞌutbꞌal riꞌ chikiwach ri winaq, man xekojon ta che. ");
INSERT INTO quctt_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Xaq jeriꞌ xkꞌulmataj ri xubꞌij ri qꞌalajisal utzij Dios Isaías: Ajawxel, ¿jachin xkojon che ri tzij ri xqabꞌij, xuqujeꞌ jachin choch xqꞌalajisax wi ri ukwinem ri Ajawxel? ");
INSERT INTO quctt_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Rumal riꞌ man xekojon taj, ubꞌim xuqujeꞌ loq ri Isaías: ");
INSERT INTO quctt_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Tzꞌapital ri kibꞌoqꞌoch xuqujeꞌ kowirisam ri kanimaꞌ rech man kakil taj rukꞌ ri kibꞌoqꞌoch xuqujeꞌ man kechoman taj rukꞌ ri kanimaꞌ, rech man kekojon taj jeriꞌ man keꞌnkunaj taj. ");
INSERT INTO quctt_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Jeriꞌ xubꞌij ri Isaías, rumal xrilo ri ujuluwem ri Jesús xuqujeꞌ xutzijoj rij. ");
INSERT INTO quctt_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pune jeriꞌ e kꞌi chike ri winaq xekojon che, e kꞌi e kꞌamal taq bꞌe xuqujeꞌ xekojonik, man xkitzijoj ta kꞌut rumal kakixiꞌj kibꞌ keꞌsax bꞌik pa ri Sinagoga kumal ri fariseos. ");
INSERT INTO quctt_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Are xkichaꞌ ri qꞌijilaꞌnem ri xkiya ri achyabꞌ cho ri kiqꞌij ri kuya ri Dios. ");
INSERT INTO quctt_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ri Jesús kꞌo xubꞌij: Ri kakojon chwe man xaq xwi ta chwe in kakojon wi, xane kakojon xuqujeꞌ che ri xintaqow loq. ");
INSERT INTO quctt_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ri kinukaꞌyej in, kukaꞌyej xuqujeꞌ ri xintaqow loq. ");
INSERT INTO quctt_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","In riꞌ ri qꞌaqꞌ ri katunanik in petinaq cho ri uwachulew rech xapachin ri kakojon chwe man kakꞌojiꞌ taj pa ri qꞌequꞌmal. ");
INSERT INTO quctt_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","We kꞌo jun kutatabꞌej ri nutzij kꞌa te riꞌ man kunimaj taj, man in taj kinqꞌatow tzij puꞌwiꞌ, jeriꞌ rumal in man xinpe taj chuqꞌatik tzij puꞌwiꞌ ri uwachulew, xane xinpe chukolik. ");
INSERT INTO quctt_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ri karetzelaj nuwach xuqujeꞌ man kukꞌamawaꞌj taj ri nutzij, kꞌo jun riꞌ kaqꞌatow na tzij puꞌwiꞌ. Ri tzij ri xintzijoj are riꞌ kaqꞌatow na tzij puꞌwiꞌ pa ri kꞌisbꞌal qꞌij. ");
INSERT INTO quctt_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Man xaq ta pa we wi xintzijonik, xane are ri Tataxel ri xintaqow loq. Areꞌ xbꞌin che jas ri kinbꞌij xuqujeꞌ jas kinbꞌan chubꞌixik. ");
INSERT INTO quctt_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Wetaꞌm chi ri utaqanik are kꞌaslemal ri maj ukꞌisik. Xaq jeriꞌ ronojel ri kinbꞌij are riꞌ ri ubꞌim ri Tataxel chwe kinbꞌij. ");
INSERT INTO quctt_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Xnaqajin kꞌu loq ri nimaqꞌij rech Pascua. Retaꞌm ri Jesús chi xuriq ri qꞌij kuya kanoq ri uwachulew rech katzalij rukꞌ ri uTat. Ri Jesús xuꞌloqꞌaj ri e rech ri e kꞌo choch ri uwachulew kꞌa pa ri kꞌisbꞌal qꞌij rech ri ukꞌolem choch ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Are xuriq ri qꞌotaj rech ri rekeqꞌij. Ri Itzel okinaq chik pa ranimaꞌ ri Judas Iscariote, ukꞌojol ri Simón, rech kujach ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Retaꞌm ri Jesús chi ronojel ri jastaq yaꞌtal xeꞌ raqan uqꞌabꞌ xuqujeꞌ retaꞌm chi che ri Dios petinaq wi xuqujeꞌ rukꞌ areꞌ katzalij wi. ");
INSERT INTO quctt_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Jeriꞌ, xwaꞌjil puꞌwiꞌ ri mexa, xresaj ri umanta kꞌa te riꞌ xujatꞌij jun atzꞌyaq suꞌbꞌal, xeꞌ upam. ");
INSERT INTO quctt_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kꞌa te riꞌ xuya jaꞌ pa jun kꞌolibꞌal, xuchapleꞌj uchꞌajik ri kaqan ri utijoxelabꞌ xuqujeꞌ xuchaqiꞌjarisaj rukꞌ ri atzꞌyaq ri xekel bꞌik xeꞌ upam. ");
INSERT INTO quctt_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Are xopan ri Jesús rukꞌ ri Simón Pedro, ri Simón Pedro xubꞌij che ri Jesús: Che ri lal Ajawxel, ¿kachꞌaj la le waqan? ");
INSERT INTO quctt_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ri Jesús xubꞌij che: At man kachꞌobꞌ ta chanim jas ri tajin kinbꞌano, jun qꞌijal kꞌu na kachꞌobꞌo. ");
INSERT INTO quctt_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ri Pedro xubꞌij: Man kachꞌaj ta wi la ri waqan in. Ri Jesús xubꞌij che: Katkwin taj katux wachiꞌl we man kinchꞌaj ri awaqan. ");
INSERT INTO quctt_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ri Pedro xubꞌij che: Ajawxel man xwi ta bꞌa kachꞌaj la ri waqan xane chꞌaja xuqujeꞌ la ri nuqꞌabꞌ rachiꞌl ri nujolom. ");
INSERT INTO quctt_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ri Jesús xubꞌij che: Ri winaq ri atininaq man rajawaxik taj kuchꞌaj ribꞌ xane xwi rajawaxik kuchꞌaj ri raqan. Ixchꞌajchꞌoj chi kꞌu ix, pune man iwonojel. ");
INSERT INTO quctt_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ri Jesús kꞌut retaꞌm jachin ri kakꞌayinik rumal riꞌ xubꞌij chi man konojel taj e chꞌajchꞌoj. ");
INSERT INTO quctt_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Are xtoꞌtaj chuchꞌajik ri kaqan, xukoj chi junmul ri umanta, xtzalij jawjeꞌ ri kꞌo wi. Kꞌa te riꞌ xubꞌij: ¿La kichꞌobꞌo jas che xinbꞌan we riꞌ iwukꞌ? ");
INSERT INTO quctt_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ix kibꞌij chi in iwajtij, xuqujeꞌ in iwajaw, utz riꞌ ri kibꞌij, jeriꞌ rumal qas jeriꞌ wi kinuxik. ");
INSERT INTO quctt_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","We in in iwAjtij, in iwAjaw xinchꞌaj ri iwaqan, ix xuqujeꞌ kuyaꞌo kichꞌaj ri kaqan nikꞌaj chik. ");
INSERT INTO quctt_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Xinkꞌut chiꞌwach rech kibꞌan kukꞌ chi nikꞌaj ri xinbꞌan in iwukꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Qas tzij kinbꞌij chiꞌwe chi man kꞌo ta jun patanijel ri nim ubꞌanik choch ri rajaw, je xuqujeꞌ man kꞌo ta jun qꞌaxel tzij ri nim ubꞌanik cho ri xtaqow bꞌik. ");
INSERT INTO quctt_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Chanim kꞌut chi iwetaꞌm chik we jastaq riꞌ, utz iwe we kichakubꞌej. ");
INSERT INTO quctt_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Man tajin taj kinbꞌij we riꞌ chiꞌwe iwonojel. Wetaꞌm in jachin ri e nuchaꞌom, kinbꞌij we riꞌ chiꞌwe rech kakꞌulmataj ri tzꞌibꞌatalik: Ri kutij rech ri kaxlan wa wukꞌ xuwaꞌjilisaj ri uqꞌabꞌ chwij chubꞌanik kꞌax chwe. ");
INSERT INTO quctt_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Kinbꞌij we riꞌ chiꞌwe, utz majaꞌ kakꞌulmatajik, rech are kakꞌulmatajik kikojo chi In riꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Qas tzij kinbꞌij chiꞌwe, ri kukꞌamawaꞌj ri kintaq bꞌik, in riꞌ kinukꞌamawaꞌj, xuqujeꞌ ri kukꞌamawaꞌj in, kukꞌamawaꞌj xuqujeꞌ ri xintaqow loq. ");
INSERT INTO quctt_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Are xbꞌiꞌtaj we tzij riꞌ rumal ri Jesús, sibꞌalaj xkꞌaxir ri ranimaꞌ, kꞌa te riꞌ xubꞌij: Qas tzij kinbꞌij chiꞌwe jun chiꞌwe kinujach na. ");
INSERT INTO quctt_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ri tijoxelabꞌ xkikaꞌyela la taq kibꞌ jeriꞌ rumal man ketaꞌm taj jachin tajin katzijox rij chike. ");
INSERT INTO quctt_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Kꞌo kꞌu chuxukut ri Jesús jun chike ri tijoxelabꞌ ri sibꞌalaj kuloqꞌaj. ");
INSERT INTO quctt_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ri Simón pa memal tzij xubꞌij che ri tijoxel riꞌ: Chata che le Jesús jachin tajin kutzijoj rij. ");
INSERT INTO quctt_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ri tijoxel xqꞌaꞌiꞌk cho ukꞌuꞌx ri Jesús kꞌa te riꞌ xubꞌij che: Ajawxel, ¿jachin riꞌ ri kabꞌij la? ");
INSERT INTO quctt_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ri Jesús xubꞌij: We winaq riꞌ are ri kinya chꞌaqaꞌp kaxlan wa che ri numuꞌum pa ri palaꞌt. Are xbꞌiꞌtaj we riꞌ rumal, xumuꞌ ri chꞌaqaꞌp kaxlan wa kꞌa te riꞌ xuya che ri Judas Iscariote, ukꞌojol ri Simón. ");
INSERT INTO quctt_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Are xkꞌamtaj ri kaxlan wa rumal ri Judas, xok ri Itzel pa ranimaꞌ. Ri Jesús xubꞌij che: Aninaq chabꞌanaꞌ ri rajawaxik kabꞌano. ");
INSERT INTO quctt_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Man kꞌo ta kꞌu jun chike ri e kꞌo puꞌwiꞌ ri mexa xchꞌobꞌowik jas che jeriꞌ xubꞌij ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Pa kikꞌuꞌx ri tijoxelabꞌ chi xa xbꞌix che ri Judas chi kꞌu loq ri kajawataj chike pa ri nimaqꞌij o kuya pwaq chike ri e mebꞌaibꞌ, jeriꞌ rumal are kayakow ri pwaq. ");
INSERT INTO quctt_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Are xtijtaj bꞌik ri kaxlan wa rumal ri Judas, xel bꞌik chilaꞌ. Chaqꞌabꞌ chi kꞌut. ");
INSERT INTO quctt_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Are xel bꞌik ri Judas, ri Jesús xubꞌij: Chanim xopan ri qꞌotaj are kayaꞌtaj uqꞌij ri uKꞌojol ri Achi, xuqujeꞌ kayaꞌtaj uqꞌij ri Dios pa Areꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Are kayaꞌtaj uqꞌij ri Dios pa Areꞌ, ri Dios xuqujeꞌ kuya na uqꞌij ri Kꞌojolaxel, kakꞌulmataj kꞌu na we jastaq riꞌ che taq we qꞌij riꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Loqꞌalaj taq walkꞌwaꞌl, xa jubꞌiqꞌ chik in kꞌo iwukꞌ. Kinitzukuj kꞌu na, ri xinbꞌij kꞌu chike ri winaq aꞌj Israel, kinbꞌij chiꞌwe ix chanim: Man kixkwin taj kixeꞌ jawjeꞌ ri kineꞌ wi in. ");
INSERT INTO quctt_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","We kꞌakꞌ taqanik we kinya chiꞌwe: Are chiloqꞌaj iwibꞌ chibꞌil taq iwibꞌ. Jetaq ri in ix nuloqꞌam, ri ix xuqujeꞌ rajawaxik kiloqꞌaj iwibꞌ chibꞌil taq iwibꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","We qas kiloqꞌaj iwibꞌ chibꞌil taq iwibꞌ, kiwetaꞌmaj riꞌ chi qas ix nutijoxelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ri Simón Pedro xuta che ri Jesús: ¿Jawjeꞌ kꞌut keꞌ wi la, Ajawxel? Ri Jesús xubꞌij che: Man katkwin taj kinatereneꞌj jawjeꞌ ri kineꞌ wi, kꞌa te kinatereneꞌj are ikꞌowinaq chik jun janipa qꞌotaj. ");
INSERT INTO quctt_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ri Pedro xubꞌij: ¿Jas che kꞌut man kinkwin taj kinteriꞌk chij la chanim? Umal e la kinya ri nukꞌaslemal. ");
INSERT INTO quctt_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ri Jesús xubꞌij che: ¿Che ri at kaya ri akꞌaslemal rumal we? Qas tzij kinbꞌij chawe chi oxibꞌ mul chik awawam nuqꞌalajisaxik are kabꞌixon ri amaꞌ akꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Makꞌaxir iwanimaꞌ, kuꞌl ikꞌuꞌx chirij ri Dios xuqujeꞌ kuꞌl ikꞌuꞌx chwij in. ");
INSERT INTO quctt_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Cho rachoch ri nuTat kꞌo sibꞌalaj kꞌi ja kꞌolibꞌal. We ta mat jeriꞌ, nubꞌim ta riꞌ chiꞌwech. Kineꞌ na chusukꞌumaxik jun ikꞌolibꞌal. ");
INSERT INTO quctt_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Are kineꞌek, keꞌnsukꞌumaj kan ri ikꞌolibꞌal, kꞌa te riꞌ kintzalij loq chiꞌkꞌamik, rech kixeꞌ wukꞌ. Jeriꞌ rech kixkꞌojiꞌ na jawjeꞌ ri in kꞌo wi in. ");
INSERT INTO quctt_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ix iwetaꞌm chik ri bꞌe ri kitaqej rech kixopan jawjeꞌ ri kineꞌ wi. ");
INSERT INTO quctt_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ri Tomás xubꞌij che: Ajawxel, man qetaꞌm taj jawjeꞌ keꞌ wi la. ¿Jas kaqaꞌn riꞌ chi retaꞌmaxik ri bꞌe? ");
INSERT INTO quctt_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ri Jesús xubꞌij che: In ri in bꞌe, ri tunal xuqujeꞌ ri kꞌaslemal. Man kꞌo ta jun kopan rukꞌ ri nuTat we man xa rumal we in. ");
INSERT INTO quctt_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","We ta qas iwetaꞌm nuwach, iwetaꞌm ta xuqubꞌa riꞌ uwach ri nuTat. Chanim kꞌut iwetaꞌm chi uwach xuqujeꞌ iwilom chik uwach. ");
INSERT INTO quctt_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ri Felipe xubꞌij che: Kꞌutu bꞌa la uwach ri Tataxel chiqawach, kubꞌan riꞌ chaqe. ");
INSERT INTO quctt_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ri Jesús xubꞌij che: Felipe, najtir chik in kꞌo iwukꞌ man awetaꞌm ta kꞌu nuwach, xapachin ri rilom nuwach in, rilom xuqujeꞌ uwach ri nuTat. ¿Jas che kabꞌij chwe: “Kꞌutu la chiqawach ri Tataxel, kubꞌan riꞌ chaqe”? ");
INSERT INTO quctt_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿La man kakojo chi in in kꞌo pa ri Tataxel xuqujeꞌ ri Tataxel kꞌo pa in? Ri tzij ri kitzijoj chiꞌwe man xaq ta pa we wi kinbꞌij chiꞌwe, xane utzij ri Tataxel, ri kꞌo chwe in, are riꞌ kabꞌanow ri chak. ");
INSERT INTO quctt_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Chikojoꞌ are kinbꞌij chiꞌwe chi in in kꞌo pa ri Tataxel, xuqujeꞌ ri Tataxel kꞌo chwe in; o pune xaq xwi chinikojoꞌ rumal taq ri chak ri kinbꞌano. ");
INSERT INTO quctt_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Qas tzij kinbꞌij chiꞌwe, ri kakojon chwe in kubꞌan na ri chak ri kinbꞌano, nimaq taq jastaq kubꞌan na jeriꞌ rumal in kintzalij rukꞌ ri Tataxel. ");
INSERT INTO quctt_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Kinbꞌan na xapakux jastaq kita pa ri nubꞌiꞌ, jeriꞌ kaqꞌijilaꞌtaj na ri Tataxel pa ri Kꞌojolaxel. ");
INSERT INTO quctt_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","In kinbꞌan na ri kita pa ri nubꞌiꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","We qas kiniloqꞌaj, kinimaj riꞌ ri nutaqanik. ");
INSERT INTO quctt_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ri in kꞌut kinta na che ri Tataxel kutaq loq jun kuꞌlisabꞌal ikꞌuꞌx rech kakꞌojiꞌ iwukꞌ ronojel qꞌij. ");
INSERT INTO quctt_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ri Uxlabꞌixel rech qas tzij ri man kakikꞌamawaꞌj taj ri winaq aꞌjuwachulew. Jeriꞌ rumal man karil ta uwach xuqujeꞌ man retaꞌm taj uwach. Ri ix kꞌut iwetaꞌm uwach, rumal kꞌo iwukꞌ xuqujeꞌ kakꞌojiꞌ na pa iwanimaꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Man kixinya ta kanoq itukel, kintzalij na loq iwukꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Pa jun janipa qꞌij ri winaq aꞌjuwachulew man karil ta chik nuwach, ri ix kꞌut kiwil na nuwach. Kixkꞌasiꞌ kꞌu na jeriꞌ rumal in in kꞌaslik. ");
INSERT INTO quctt_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Pa ri qꞌij riꞌ kichꞌobꞌ na chi in in kꞌo pa ri Tataxel xuqujeꞌ ri Tataxel kꞌo chwe in, ri in xuqujeꞌ in in kꞌo chiꞌwe ix. ");
INSERT INTO quctt_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","¿Jachin riꞌ ri kinuloqꞌaj? Are kinuloqꞌaj ri winaq ri kubꞌan rech che ri nutaqanik xuqujeꞌ kunimaj. Ri kinuloqꞌaj, kaloqꞌax na rumal ri nuTat xuqujeꞌ kinloqꞌaj na in, kinkꞌut xuqujeꞌ na wibꞌ choch. ");
INSERT INTO quctt_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ri Judas (man are ta ri Judas Iscariote) xubꞌij che: ¿Jas che riꞌ kaj la kakꞌut la ibꞌ la chiqawach, man are ta kakꞌut la ibꞌ la chikiwach ri winaq ajuwachulew? ");
INSERT INTO quctt_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ri Jesús xubꞌij che: Ri kinuloqꞌaj in kunimaj riꞌ ri nutzij. Kaloqꞌax kꞌu na rumal ri nuTat, kaqabꞌan xuqujeꞌ na qachoch pa ranimaꞌ xuqujeꞌ kujulkꞌol na chupam. ");
INSERT INTO quctt_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ri man kinuloqꞌaj taj, man kunimaj ta riꞌ ri nutzij. Ri tzij ri tajin kitatabꞌej man we in taj, xane rech ri Tataxel ri xintaqow loq. ");
INSERT INTO quctt_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Tajin kinbꞌij we jastaq riꞌ chiꞌwe rumal in kꞌo iwukꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Are kꞌu ri Kuꞌlisabꞌal ikꞌuꞌx, ri Tyoxalaj Uxlabꞌixel, ri kutaq na loq ri Tataxel pa ri nubꞌiꞌ, kukꞌut na ronojel ri jastaq chiꞌwach xuqujeꞌ kunaꞌtaj na chiꞌwe ri xinbꞌij chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Kinya kan ri jaꞌmaril chiꞌwe, kinya ri nujaꞌmaril chiꞌwe. Man je ta kinbꞌan in chuyaꞌik jetaq ri kakibꞌan ri winaq ajuwachulew. Man kakꞌaxir taj iwanimaꞌ xuqujeꞌ man kixiꞌj ta iwibꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Itom chik nubꞌim chiꞌwe: “Ri in kineꞌek, kintzalij kꞌu na loq iwukꞌ.” We ta qas kiniloqꞌaj kixkiꞌkot riꞌ rumal kineꞌ rukꞌ ri Tataxel, jeriꞌ rumal ri Tataxel are nim ubꞌanik chinuwach. ");
INSERT INTO quctt_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Xinbꞌij we riꞌ chiꞌwe chanim utz majaꞌ kakꞌulmatajik, rech we xkꞌulmatajik ix kixkojonik. ");
INSERT INTO quctt_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Man kintzijon ta chi na iwukꞌ, jeriꞌ rumal kape ri kabꞌan re puꞌwiꞌ we uwachulew riꞌ. Areꞌ maj ukwinem pa nuwiꞌ in. ");
INSERT INTO quctt_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Rajawaxik kꞌut chi ri winaq ajuwachulew kaketaꞌmaj chi kinloqꞌaj ri Tataxel, xuqujeꞌ je kinbꞌano jetaq ri inutaqom chubꞌanik. Chixwaꞌjiloq, chujel bꞌik waral. ");
INSERT INTO quctt_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","In riꞌ ri qas in ucheꞌal ri uvas, ri nuTat are kachakun ri ulew. ");
INSERT INTO quctt_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ri uqꞌabꞌ ri ucheꞌal ri uvas we man kuya uwach, kasakꞌix bꞌik. Are kꞌu ri uqꞌabꞌ ri cheꞌ ri kuya uwach, kachꞌajchꞌobꞌexik rech kꞌi uwach kuyaꞌo. ");
INSERT INTO quctt_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ri ix ixchꞌajchꞌoj chik rumal ri tzij ri xintzijoj chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Chixkꞌol chwe in, rech in kinkꞌojiꞌ chiꞌwe ix. Jetaq ri uqꞌabꞌ ri cheꞌ man kakwin taj kawachinik xaq pa rech wi, xane rajawaxik kakꞌojiꞌ che ri ucheꞌal ri uvas, je xuqujeꞌ ix man kixkwin taj kixwachinik we man kixkꞌojiꞌ chwe in. ");
INSERT INTO quctt_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","In riꞌ ri in ucheꞌal ri uvas, ix ix uqꞌabꞌ. Ri kakꞌojiꞌ chwe in, xuqujeꞌ in che areꞌ, sibꞌalaj kꞌi na uwach kuyaꞌo. Maj kixkwinik kibꞌano we man kixkꞌojiꞌ chwe. ");
INSERT INTO quctt_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ri man kakꞌojiꞌ ta chwe in ketzelax uwach xuqujeꞌ kachaqiꞌjarik, jetaq ri uqꞌabꞌ taq cheꞌ ri kamulix bꞌik rech keꞌkꞌyaq kan pa ri qꞌaqꞌ kaporoxik. ");
INSERT INTO quctt_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","We kixjeqiꞌ chwe in xuqujeꞌ kajeqiꞌ ri nutzij pa iwanimaꞌ, xapakux ri kito kayaꞌtaj na chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kaqꞌijilaꞌtaj ri ubꞌiꞌ ri nuTat are sibꞌalaj kixwachinik xuqujeꞌ kikꞌutu chi ix nutijoxelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ix nuloqꞌam jetaq ri ubꞌanom ri nuTat chinuloqꞌaxik. Chixjeqel pa ri nuloqꞌanik. ");
INSERT INTO quctt_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","We kinimaj ri nutaqanik, kixkꞌojiꞌ riꞌ pa ri nuloqꞌanik, jetaq ri in nunimam ri uꞌtaqanik ri nuTat xuqujeꞌ in kꞌo pa ri uloqꞌanik. ");
INSERT INTO quctt_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nubꞌim we riꞌ chiꞌwe rech jeriꞌ kikꞌamawaꞌj ri nukiꞌkotemal xuqujeꞌ katzꞌaqat ri ikiꞌkotemal. ");
INSERT INTO quctt_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Are waꞌ ri nutaqanik: Chiloqꞌaj iwibꞌ chibꞌil taq iwibꞌ, jetaq ri nubꞌanom in chiꞌloqꞌaxik. ");
INSERT INTO quctt_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Man kꞌo taj jun nimalaj loqꞌanik choch ri uyaꞌik ukꞌaslemal jun pa kiwiꞌ ri e rech taq chꞌabꞌeꞌn. ");
INSERT INTO quctt_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ix qas ix wech chꞌabꞌeꞌn wi we kinbꞌan ri kixintaq wi. ");
INSERT INTO quctt_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Man kinbꞌij ta chik patanil we chiꞌwe, jeriꞌ rumal ri patanijel man retaꞌm taj jas kubꞌan ri rajaw. Nubꞌim chi ix wech chꞌabꞌeꞌn, jeriꞌ rumal ronojel ri xinto xubꞌij ri nuTat chwe, xinbꞌij chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Man ix taj xinichaꞌo, xane in xixinchaꞌo xuqujeꞌ xinya itaqkil rech kixeꞌek xuqujeꞌ kixwachinik, xuqujeꞌ qas kixjeqiꞌk. Jeriꞌ kuya na ri Tataxel ronojel ri kita che pa ri nubꞌiꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ri nutaqanik are chi kiloqꞌaj iwibꞌ chibꞌil taq iwibꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","We kixketzelaj ri winaq aꞌjuwachulew, naꞌtaj chiꞌwe chi in riꞌ xinketzelaj. ");
INSERT INTO quctt_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","We ta ix aꞌjuwachulew, kixkiloqꞌaj riꞌ ri winaq aꞌjuwachulew jetaq kakibꞌan chuloqꞌaxik ri e kachiꞌl. Man ix ajuwachulew ta kꞌut rumal cher in xixinchaꞌo chikixoꞌl ri winaq ajuwachulew. Rumal riꞌ kaketzelaj iwach. ");
INSERT INTO quctt_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Naꞌtaj chiꞌwe ri xinbꞌij chiꞌwe: Man kꞌo ta jun patanijel nim uqꞌij cho ri rajaw. We bꞌantal kꞌax chwe in, ix xuqujeꞌ kabꞌan na kꞌax chiꞌwe. We inimam ri na kꞌutuꞌn, kanimax xuqujeꞌ na ri ikꞌutuꞌn ix. ");
INSERT INTO quctt_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Kakibꞌan kꞌax ri chiꞌwe rumal rech ri nubꞌiꞌ, jeriꞌ rumal man ketaꞌm taj jachin xintaqow loq. ");
INSERT INTO quctt_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","We ta mat xinpetik xuqujeꞌ mat xinultzijon kukꞌ, man aꞌjmakibꞌ ta riꞌ. Chanim kꞌut man kuya taj kakibꞌij chi maj kimak. ");
INSERT INTO quctt_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Jachin ri karetzelaj nuwach in, karetzelaj xuqujeꞌ uwach ri xintaqow loq. ");
INSERT INTO quctt_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","We ta mat xinbꞌan ri mayijabꞌal taq jastaq ri man kꞌo ta winaq bꞌanowinaq chkixoꞌl, mat kꞌo ki kimak we winaq riꞌ. Chanim kꞌut pune kilom chik we riꞌ, kaketzelaj nuwach xuqujeꞌ kaketzelaj uwach ri nuTat. ");
INSERT INTO quctt_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Xkꞌulmataj kꞌu we jastaq riꞌ rech kakꞌulmataj ri tzꞌibꞌatal pa ri kitaqanik kubꞌij: Pune maj numak, xinketzelaj. ");
INSERT INTO quctt_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Are kape ri Kubꞌisal kꞌuꞌx, ri kintaq na loq, ri kape rukꞌ ri Tataxel, ri Tyoxalaj Uxlabꞌixel rech tunal, ri kape rukꞌ ri Tataxel, areꞌ kuqꞌalajisaj na ri nubꞌiꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ri ix xuqujeꞌ kiqꞌalajisaj na in jachinaq jeriꞌ rumal ixkꞌolinaq wukꞌ are xmajtaj loq ronojel. ");
INSERT INTO quctt_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Xinbꞌij chiꞌwe ronojel we jastaq riꞌ rech man kakabꞌalaj ta ikꞌuꞌx ");
INSERT INTO quctt_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Kixesax na bꞌik pa taq ri Sinagoga, xuqujeꞌ kuriq na qꞌij chi ri winaq ri kixkamisanik kubꞌij chi xa tajin kuqꞌijilaꞌj ri Dios. ");
INSERT INTO quctt_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Jeꞌ waꞌ kenoꞌjin na rumal man ketaꞌmam taj uwach ri Tataxel xuqujeꞌ man ketaꞌm taj nuwach in. ");
INSERT INTO quctt_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Kinbꞌij we jastaq riꞌ chiꞌwe rech are kuriq ri qꞌij kakꞌulmatajik kanaꞌtaj chiꞌwe chi nubꞌim chik chiꞌwe. Man xinbꞌij ta we riꞌ chiꞌwe pa ri majibꞌal rech ronojel jeriꞌ rumal in kꞌo na iwukꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Chanim kintzalij rukꞌ ri xintaqow loq, maj jun chiꞌwe katow chwe ¿jawjeꞌ keꞌ wi la? ");
INSERT INTO quctt_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Xane sibꞌalaj kixbꞌison chik rumal ri xinbꞌij chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Qas tzij kinbꞌij chiꞌwe: Are utz we kineꞌek, jeriꞌ rumal we man kineꞌek man kape ta riꞌ ri kubꞌisal kuꞌx iwukꞌ, are kꞌu we kineꞌek, keꞌntaqa loq rech kape iwukꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Are kape ri kubꞌisal kuꞌx, kubꞌan na chi ri winaq aꞌjuwachulew kakichꞌobꞌ ri kimak, ri sukꞌal, xuqujeꞌ ri qꞌatoj tzij. ");
INSERT INTO quctt_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kaketaꞌmaj chi kꞌo kimak rumal man kekojon ta chwe. ");
INSERT INTO quctt_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Kaketaꞌmaj na ri sukꞌal, jeriꞌ rumal in kineꞌek rukꞌ ri nuTat, xuqujeꞌ man kixkwin ta chik kiwil nuwach. ");
INSERT INTO quctt_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Kaketaꞌmaj na ri qꞌatoj tzij, jeriꞌ rumal ri kabꞌan rech puꞌwiꞌ ri uwachulew xqꞌat taj tzij puꞌwiꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Kꞌi jastaq na kawaj kinbꞌij chiꞌwe, man kiqꞌiꞌ ta kꞌut we kinbꞌij chiꞌwe chanim. ");
INSERT INTO quctt_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Are kape ri Uxlabꞌixel rech tunal, kukꞌam na ibꞌe pa ri tunal, jeriꞌ rumal man xaq ta pa rech wi kachꞌawik, xane are kibꞌij ri kutatabꞌej xuqujeꞌ kutzijoj na ri jastaq ri kape na. ");
INSERT INTO quctt_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Areꞌ kuya na nuqꞌij jeriꞌ rumal kukꞌam na ri wech in rech kukꞌut chiꞌwech ix. ");
INSERT INTO quctt_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ronojel ri kꞌo rukꞌ ri Tataxel, we in. Rumal laꞌ xinbꞌij chi ri Uxlabꞌixel kukꞌam na ri wech in rech kukꞌut chiꞌwach ix. ");
INSERT INTO quctt_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Pa jun janipa qꞌij man kiniwil ta chik, are ikꞌowinaq chi jun janipa qꞌij kiniwil chi na junmul. ");
INSERT INTO quctt_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jujun chike ri utijoxelabꞌ xkibꞌilaꞌ chibꞌil taq kibꞌ: ¿Jas karaj kubꞌij rukꞌ we riꞌ “Pa jun janipa qꞌij man kiniwil ta chik,” kꞌa te riꞌ “Are ikꞌowinaq chi jun janipa qꞌij junmul chik kiniwil na” xuqujeꞌ rukꞌ le “Rumal kineꞌ rukꞌ ri Tataxel”? ");
INSERT INTO quctt_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Kakikoj kichuqꞌabꞌ chi retaꞌmaxik ri xubꞌij, kakibꞌila chibꞌil taq kibꞌ ¿jas karaj kubꞌij rukꞌ ri tzij “xaq pa jun janipa qꞌij chik”? Man qetaꞌm taj jas laꞌ le kubꞌij. ");
INSERT INTO quctt_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ri Jesús xuchꞌobꞌo chi are kakaj kakita we jastaq riꞌ che, rumal riꞌ xubꞌij chike: ¿Tajin kita chibꞌil iwibꞌ jas xwaj xinbꞌij rukꞌ: “Pa jubꞌiqꞌ man kiwil ta chik nuwach, xuqujeꞌ are kikꞌow jun janipa qꞌij kiniwil chi na ri junmul”? ");
INSERT INTO quctt_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Qas tzij kinbꞌij chiꞌwe: Ri ix kixoqꞌ na rumal ri qꞌoxomal, are kꞌu ri winaq ajuwachulew kekiꞌkot na. Ri ix kixbꞌison na, ri ibꞌis kꞌut kakꞌexkꞌobꞌ na pa kiꞌkotemal. ");
INSERT INTO quctt_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ri ixoq kunaꞌ qꞌoxom are jubꞌiqꞌ karaj kakꞌojiꞌ ri ral, are kakꞌojiꞌ ri ral kasachan che ri qꞌoxom kuchapleꞌj kiꞌkotik rumal cher retaꞌm chi xukꞌam loq jun kꞌakꞌ winaq cho ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Je xuqujeꞌ kakꞌulmataj iwukꞌ ix. Kixbꞌison chanim, xa kꞌu kixkiꞌkot na are kixinwil chi na junmul, maj kꞌu jun kesan ri kiꞌkotemal riꞌ chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Che ri qꞌij riꞌ maj jun jastaq chik kita chwe. Jeriꞌ rumal qas tzij kinbꞌij chiꞌwe ri nuTat kuya na chiꞌwe ronojel ri kita pa ri nubꞌiꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kꞌa kamik maj jun jastaq itom pa ri nubꞌiꞌ. Chitaꞌ rech kikꞌamawaꞌj, rech jeriꞌ katzꞌaqat ri ikiꞌkotemal. ");
INSERT INTO quctt_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","We jastaq riꞌ xinbꞌij chiꞌwe rukꞌ kꞌambꞌejabꞌal taq noꞌj. Kape kꞌu na ri qꞌotaj are man je ta chi riꞌ kinbꞌan che ichꞌabꞌexik, xane qas kꞌyaqal na kinbꞌan chutzijoxik ri nuTat chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Che ri qꞌij riꞌ kita na jastaq pa ri nubꞌiꞌ, man kinbꞌochiꞌj ta kꞌu na ri Tataxel rech kixutoꞌo. ");
INSERT INTO quctt_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Jeriꞌ, rumal tzi are ri Tataxel kixloqꞌanik rumal xiniloqꞌaj ix xuqujeꞌ xikojo chi che ri Dios nupetik wi. ");
INSERT INTO quctt_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nupetik che ri Tataxel are xinpe choch ri uwachulew; chanim kinya kanoq ri uwachulew kintzalij rukꞌ ri Tataxel. ");
INSERT INTO quctt_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ri tijoxelabꞌ xkibꞌij che: Chanim man patzkuꞌy taj tajin katzijon la, xane qas kꞌyaqalik. ");
INSERT INTO quctt_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Chanim kaqachꞌobꞌo chi qas etaꞌm la ronojel ri jastaq, xuqujeꞌ man rajawaxik taj kaqata che la jas ubꞌanik. Rumal laꞌ kaqakojo chi che ri Dios petinaq wi la. ");
INSERT INTO quctt_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ri Jesús xubꞌij chike: ¿La kixkojon chwe chanim? ");
INSERT INTO quctt_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Kape na ri qꞌotaj, xuqujeꞌ xul waral, are kixtunkin na bꞌik, pa ijujunal kixeꞌ cho taq iwachoch, kiniya kanoq nutukel. Pune jeriꞌ man nutukel taj in kꞌolik, ri Tataxel kꞌo wukꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Xinbꞌij we jastaq riꞌ chiꞌwe rech kiriq jaꞌmaril rumal we. Kiriq na kꞌax cho ri uwachulew pune jeriꞌ kuꞌl ikꞌuꞌx rumal In xinchꞌeken puꞌwiꞌ ri kwinem rech ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Are xbꞌiꞌtaj we tzij riꞌ rumal ri Jesús, xkaꞌy chikaj, xubꞌan chꞌawem, xubꞌij: Tat, xopan ri qꞌotaj. Nimarisaj ri Kꞌojol la rech ri Kꞌojol la kunimarisaj xuqujeꞌ qꞌij la. ");
INSERT INTO quctt_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Yaꞌom la che ronojel kwinem puꞌwiꞌ konojel ri winaq rech jeriꞌ kuya kikꞌaslemal konojel ri e yoꞌm la che. ");
INSERT INTO quctt_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ri kꞌaslemal ri maj ukꞌisik are chi ketaꞌmax wach la, xa jun Dios, xuqujeꞌ ri Jesucristo ri xtaq la loq. ");
INSERT INTO quctt_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ri in nunimarisam qꞌij la cho ri uwachulew xuqujeꞌ nubꞌanom ri chak ri xbꞌij la chi kinbꞌano. ");
INSERT INTO quctt_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Chanim kꞌut Tat, ya la nuqꞌij jetaq ri yaꞌom la kan chwe are majaꞌ katiktaj loq ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Xinbꞌij chike ri xeya la chwe jachin ri lal. Ech la nabꞌe kanoq, xeꞌya kꞌu la chwe xuqujeꞌ e nimaninaq kꞌut che ri tzij la. ");
INSERT INTO quctt_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Kamik ketaꞌm chik chi ukꞌ la petinaq wi ronojel ri yaꞌom la chwe. ");
INSERT INTO quctt_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Jeriꞌ rumal nubꞌim chike ri tzij ri xya la chwe, xkikꞌamawaꞌj kꞌut, qas tzij ketaꞌm chi che la in petinaq wi, xuqujeꞌ kikojom chi lal xintaqow la loq. ");
INSERT INTO quctt_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Kinta che la pa kiwiꞌ aꞌreꞌ. Man xaq xwi taj kinta che la pa kiwiꞌ ri winaq aꞌjuwachulew, xane kinta xuqujeꞌ pa kiwiꞌ ri xeya la chwe, jeriꞌ rumal aꞌreꞌ ech la. ");
INSERT INTO quctt_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ronojel ri kꞌo wukꞌ in, ech la, xuqujeꞌ ronojel ri kꞌo ukꞌ la we in, xuqujeꞌ rumal ke aꞌreꞌ xyaꞌtaj nuqꞌij in. ");
INSERT INTO quctt_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Man naj ta chik kinkꞌojiꞌ cho ri uwachulew, aꞌreꞌ kꞌut naj e kꞌo na waral, in kintzalij ukꞌ la. Tat, che chajij la pa ri ukwinem ri bꞌiꞌ la ri xya la chwe, rech xa jun kuꞌxik, jetaq ri qaꞌnik uj ukꞌ la. ");
INSERT INTO quctt_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Xeꞌnchajij are xinkꞌojiꞌk kukꞌ xuqujeꞌ xeꞌntoꞌo rukꞌ ri bꞌiꞌaj ri xya la chwe, maj jun chike xtzaqik xwi xtzaq ri tzaqel rij xkꞌojiꞌk, rech jeriꞌ kakꞌulmataj ri tzꞌibꞌatalik. ");
INSERT INTO quctt_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Chanim kintzalij ukꞌ la, kinbꞌij kꞌu we tzij riꞌ, utz in kꞌo na choch ri uwachulew, rech jeriꞌ katzꞌaqat ri nukiꞌkotemal pa kanimaꞌ aꞌreꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Xintzijoj ri tzij la chike, ri winaq ajuwachulew xeꞌketzelaj, jeriꞌ rumal man ajuwachulew taj, xuqujeꞌ in man in ajuwachulew taj. ");
INSERT INTO quctt_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Man are ta kinta che la chi keꞌsaj la cho ri uwachulew, xane kinta che la chi keꞌchajij la che ri Itzel. ");
INSERT INTO quctt_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Aꞌreꞌ man aꞌjuwachulew taj, je xuqujeꞌ in man in ajuwachulew taj. ");
INSERT INTO quctt_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Cheꞌtyoxirisaj la pa ri qas tzij; ri tzij la are qas tzij. ");
INSERT INTO quctt_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Jetaq ri xbꞌan la chinutaqik loq cho ri uwachulew, in xuqujeꞌ keꞌntaq bꞌik kukꞌ ri winaq aꞌjuwachulew. ");
INSERT INTO quctt_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Kumal ke aꞌreꞌ kintyoxirisaj wibꞌ in, rech jeriꞌ ketyoxirisataj xuqujeꞌ na aꞌreꞌ pa ri tunal. ");
INSERT INTO quctt_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Man xwi ta kinta che la pa kiwiꞌ aꞌreꞌ xane kinta xuqujeꞌ pa kiwiꞌ ri kekojon na chwe rumal ri tzij ri kakitzijoj na aꞌreꞌ chike nikꞌaj chik. ");
INSERT INTO quctt_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Rech jeriꞌ xa jun kuꞌxik. Jetaq ri qaꞌnik ukꞌ la, Tat, lal kꞌo la pa wanimaꞌ xuqujeꞌ ri in, in kꞌo pa animaꞌ la. Ya xuqujeꞌ la bꞌe chi aꞌreꞌ kekꞌojiꞌ chaqe uj, rech jeriꞌ kekojon ri winaq aꞌjuwachulew chi lal xintaqow la loq. ");
INSERT INTO quctt_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ri in xinya chike ri juluwem ri xya la chwe, rech jeriꞌ xa jun kuꞌxik, jetaq ri qaꞌnik uj ukꞌ la xa uj jun. ");
INSERT INTO quctt_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ri in in kꞌo pa kanimaꞌ aꞌreꞌ xuqujeꞌ lal kꞌo la pa wanimaꞌ in. Ya la bꞌe chike rech kuꞌx sukꞌ xuqujeꞌ xa jun, jeriꞌ kaketaꞌmaj ri winaq aꞌjuwachulew chi lal xintaqow la loq xuqujeꞌ e loqꞌam la jetaq ri bꞌanom la chinuloqꞌaxik in. ");
INSERT INTO quctt_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tat, kawaj kekꞌojiꞌk wukꞌ ri xeꞌya la chwe jawjeꞌ ri kinkꞌojiꞌ wi. Rech jeriꞌ kakil ri nujuluwem, ri juluwem ri xya la chwe, jeriꞌ rumal xinloqꞌaj la are majaꞌ katiktaj loq ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Sukꞌ laj Tataxel, pune man etaꞌmatal ta wach la kumal ri winaq aꞌjuwachulew, in wetaꞌm wach xuqujeꞌ aꞌreꞌ ketaꞌm chi lal xintaqow la loq. ");
INSERT INTO quctt_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","In nubꞌim chike jachin ri lal, xuqujeꞌ man kintaniꞌ taj chutzijoxik, rech jeriꞌ ri loqꞌanik la ri in loqꞌam la rukꞌ kakꞌojiꞌ na pa kanimaꞌ aꞌreꞌ xuqujeꞌ in kinkꞌojiꞌ na pa kanimaꞌ aꞌreꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Are xbꞌiꞌtaj we jastaq riꞌ rumal ri Jesús, xeꞌ kukꞌ ri utijoxelabꞌ xkiqꞌaxaj ri jaꞌ ri kabꞌinik ri kꞌo pa Cedrón. Chꞌaqaꞌp che ri kabꞌin wi ri jaꞌ, kꞌo jun chꞌaqaꞌp ulew jawjeꞌ tiktal wi cheꞌ, ri Jesús xok bꞌik chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ri Judas ri xkꞌayin ri Jesús retaꞌm xuqujeꞌ jawjeꞌ kꞌo wi kꞌolibꞌal riꞌ, jeriꞌ rumal sibꞌalaj kꞌi mul kꞌolinaq ri Jesús chilaꞌ kukꞌ ri utijoxelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ri kꞌamal taq kibꞌe ri chꞌawenelabꞌ cho ri Dios rachiꞌl ri fariseos xeꞌkiya bꞌik junmulaj ajchꞌoꞌjabꞌ chajil tinimit, xuqujeꞌ e chajinelabꞌ rech ri Templo che ri Judas xoꞌpan kꞌut jawjeꞌ kꞌo wi ri Jesús kukꞌaꞌm taq bꞌik qꞌaqꞌ ri katunanik xuqujeꞌ cheꞌyabꞌal. ");
INSERT INTO quctt_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ri Jesús retaꞌm chik ronojel ri kakꞌulmatajik, xel loq chkikꞌulaxik ri winaq, xuta chike: ¿Jachin kitzukuj? ");
INSERT INTO quctt_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ri winaq xkibꞌij che: Are kaqatzukuj ri Jesús aj Nazaret. Ri Jesús xubꞌij: In Riꞌ. Ri Judas ri xkꞌayin ri Jesús kꞌo xuqujeꞌ kukꞌ ri winaq. ");
INSERT INTO quctt_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ri Jesús are xubꞌij “In Riꞌ”, xetzalij chikij, pakꞌalik xeqajik. ");
INSERT INTO quctt_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Kꞌa te riꞌ xuta chi junmul chike xubꞌij: ¿Jachin kitzukuj? Ri winaq xkitzalij ubꞌixik: Are kaqatzukuj ri Jesús aj Nazaret. ");
INSERT INTO quctt_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ri Jesús xubꞌij chike: Xinbꞌij chiꞌwe chi in Riꞌ, we in kinitzukuj, chiya bꞌe chike we nikꞌaj riꞌ kebꞌek. ");
INSERT INTO quctt_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jewaꞌ xubꞌij rech kakꞌulmataj ri tzꞌibꞌatalik: Xa ta ne jun xtzaq chike ri xeya la chwe. ");
INSERT INTO quctt_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ri Simón Pedro rukꞌaꞌm bꞌik jun sakꞌibꞌal xresaj, kꞌa te riꞌ xusakꞌij ri wiqiqꞌabꞌ uxikin ri patanil rech ri kꞌamal kibꞌe ri chꞌawenel cho ri Dios pa kiwiꞌ ri winaq. (Ri patanijel ubꞌiꞌ Malco.) ");
INSERT INTO quctt_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ri Jesús xubꞌij che ri Pedro: Chatzalij le asakꞌibꞌal pa ri kꞌolibꞌal rech. ¿La man yaꞌtal wi kinqumuj ri kꞌa ri kuya ri nuTat chwe? ");
INSERT INTO quctt_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Are kꞌu ri ajchꞌoꞌjabꞌ chajil tinimit, xuqujeꞌ ri kꞌamal kibꞌe, e kachiꞌl ri e chajil taq re ri Templo xkiyut ri Jesús kꞌa te riꞌ xkikꞌam bꞌik. ");
INSERT INTO quctt_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nabꞌe xkikꞌam bꞌik ri cho ri Anás, ujiꞌ ri Caifás, are kinimaꞌqil ri chꞌawenelabꞌ cho ri Dios, che ri junabꞌ riꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ri Caifás are xbꞌin chike ri winaq aꞌj Israel, are katanik we xa jun achi kakam kumal ke ri winaq cho ri kekam konojel ri tinimit. ");
INSERT INTO quctt_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ri Simón Pedro rachiꞌl jun tijoxel e teren bꞌik chirij ri Jesús. Ri jun tijoxel chik etaꞌmatal uwach rumal ri kꞌamal bꞌe kech ri kinimal ri chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq rumal riꞌ xya bꞌe che xok bꞌik cho rachoch ri kinimaꞌqil ri chꞌawenelabꞌ, rukꞌ ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Are kꞌu ri Pedro xkanaj kanoq chuchiꞌ ri ja. Ri tijoxel ri etaꞌmatal uwach rumal ri kinimaꞌqil ri chꞌawenelabꞌ xel chi loq junmul xultzijon rukꞌ ri jaqal rech ri uchiꞌ ja xuta toqꞌobꞌ che rech koq bꞌik ri Pedro. ");
INSERT INTO quctt_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ri jaqal uchiꞌ ja xubꞌij che ri Pedro: ¿La man at kachiꞌl at ri utijoxelabꞌ we achi riꞌ? Ri Pedro xubꞌij: Man in kachiꞌl taj. ");
INSERT INTO quctt_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Sibꞌalaj kꞌax tew kꞌut rumal riꞌ ri e patanijelabꞌ xuqujeꞌ ri e chajinelabꞌ kimulim kibꞌ chirij jun qꞌaqꞌ tajin kakimiqꞌ kibꞌ. Ri Pedro xuqujeꞌ tajin kumiqꞌ ribꞌ kukꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Are kꞌu ri kinimaꞌqil ri chꞌawenelabꞌ cho ri Dios tajin kuta che ri Jesús jas uwach ri kꞌutuꞌn tajin kuyaꞌo xuqujeꞌ jachin taq ri utijoxelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ri Jesús xubꞌij che: Ri in nuyoꞌm ri nukꞌutuꞌn chikiwach konojel ri winaq pa ri Sinagoga, pa ri Templo xuqujeꞌ jawjeꞌ ri kakimulij wi kibꞌ ri winaq aꞌj Israel. Man kꞌo taj jun jastaq ri xaq cheleqꞌal nubꞌim. ");
INSERT INTO quctt_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Jas che chwe in kata wi? Chata chike ri winaq ri xetow ri nutzij. Aꞌreꞌ riꞌ etaꞌmaninaq ri xintzijoj chike. ");
INSERT INTO quctt_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Are jewaꞌ xubꞌij, jun chike ri chajinelabꞌ rech ri Templo xutzoqopij jun qꞌabꞌ chupalaj, kꞌa te riꞌ xubꞌij che: ¿La jeriꞌ kabꞌan chuchꞌabꞌexik ri kinimaꞌqil ri chꞌawenelabꞌ cho ri Dios? ");
INSERT INTO quctt_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ri Jesús xubꞌij che: We kꞌo itzel jastaq xinbꞌij chabꞌij jawjeꞌ xinsach wi. We utz ri xinbꞌij, ¿jas che kꞌut kinachꞌayo? ");
INSERT INTO quctt_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Jatꞌital ri Jesús xtaq bꞌik rumal ri Anás choch ri Caifás ri kinimaꞌqil ri chꞌawenelabꞌ cho ri Dios. ");
INSERT INTO quctt_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Are kꞌu ri Pedro xaq jeꞌ takꞌal chilaꞌ tajin kumiqꞌ ribꞌ chuchiꞌ ri qꞌaqꞌ. Kꞌo chilaꞌ, are xta che: ¿La man kꞌu at jun at chike ri utijoxelabꞌ we achi riꞌ? Man in kachiꞌl taj, xcha ri Pedro. ");
INSERT INTO quctt_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","¿La man kꞌu xatinwilo are at kꞌo rukꞌ pa ri ulew jawjeꞌ tiktal wi cheꞌ? xcha jun chike ri patanijel rech ri kinimaꞌqil ri chꞌawenelabꞌ cho ri Dios che, uqꞌabꞌ taq alaxik rukꞌ ri achi ri xsakꞌix uxikin rumal ri Pedro. ");
INSERT INTO quctt_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ri Pedro junmul chik xubꞌij chi man retaꞌm taj uwach ri Jesús, qas che ri qꞌotaj riꞌ xtzitziriqiꞌn ri amaꞌ akꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ri e kꞌamal taq bꞌe kech ri winaq aꞌj Israel xkesaj bꞌik ri Jesús cho rachoch ri Caifás, xkikꞌam bꞌik cho ri nim taqanel aj Roma. Rumal kꞌu chi tajin kasaqirik, ri winaq aꞌj Israel man xoꞌk ta bꞌik pa ri nimalaj ja ri kꞌo wi ri Pilato, jeriꞌ rumal we ta xoꞌk bꞌik kakichꞌulujij kibꞌ xuqujeꞌ man kekwin taj kewaꞌ pa ri nimaqꞌij Pascua we jeriꞌ kakibꞌano. ");
INSERT INTO quctt_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Rumal riꞌ xel loq ri Pilato chutayik chike: ¿Jas umak we achi riꞌ, kibꞌij ix? ");
INSERT INTO quctt_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ri winaq xkibꞌij: We ta mat jun achi bꞌanal kꞌax, mat xqakꞌam loq la chawe. ");
INSERT INTO quctt_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ri Pilato xubꞌij chike: Chikꞌama bꞌik ix, chiqꞌata tzij puꞌwiꞌ jetaq ri kubꞌij ri itaqanik. Ri winaq aꞌj Israel xkibꞌij: Man kꞌo ta kwinem pa qaqꞌabꞌ uj chukamisaxik jun winaq. ");
INSERT INTO quctt_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jewaꞌ xbꞌantajik rech kakꞌulmataj ri ubꞌim ri Jesús are xutzijoj rij jas uwach kamikal kuriqo. ");
INSERT INTO quctt_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ri Pilato xok chi bꞌik junmul pa ri nimalaj ja, xusikꞌij ri Jesús, xuta che: ¿La at riꞌ ri at nim taqanel pa kiwiꞌ ri winaq aꞌj Israel? ");
INSERT INTO quctt_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ri Jesús xubꞌij che ri Pilato: ¿Are riꞌ kabꞌij at? O ¿are riꞌ kibꞌim chi nikꞌaj chawe chi kinux in? ");
INSERT INTO quctt_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ri Pilato xubꞌij: ¿La in aj Israel kꞌu in? Are ri awinaq xuqujeꞌ ri e kꞌamal taq kibꞌe ri e chꞌawenelabꞌ cho ri Dios xatkꞌamow loq chinuwach. ¿Jas xamakuj? ");
INSERT INTO quctt_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ri Jesús xubꞌij: Ri ajawarem ri kintaqan wi man rech ta we uwachulew riꞌ. We ta jeriꞌ, kechꞌoꞌjin riꞌ ri e chajil taq rech jeriꞌ man kakiya ta bꞌe kinkichap ri winaq aꞌj Israel. Man rech ta kꞌu uwachulew ri nutaqanik. ");
INSERT INTO quctt_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ri Pilato xubꞌij che: Xaq jeriꞌ at taqanel. Ri Jesús xubꞌij: At xatbꞌinik chi in taqanel, rumal waꞌ xinalaxik xuqujeꞌ rumal waꞌ xinpe choch ri uwachulew, rech jeriꞌ kulinqꞌalajisaj ri tunal. Xapachin ri kuloqꞌaj ri tunal kutatabꞌej riꞌ ri nuchꞌabꞌal. ");
INSERT INTO quctt_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ri Pilato xuta che ri Jesús: ¿Jas kꞌu riꞌ ri tunal? Are xbꞌiꞌtaj we riꞌ rumal, xel bꞌik chikilik ri winaq aꞌj Israel, xubꞌij chike: Man kinriq ta in umak we achi riꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ri ix kꞌut naqꞌatal chiꞌwe chi katzoqopix jun achi ri kꞌo pa cheꞌ pa ri nimaqꞌij rech Pascua. ¿La kiwaj kꞌut kintzoqopij ri nim taqanel ke ri winaq aꞌj Israel? ");
INSERT INTO quctt_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ko xkiraq kichiꞌ ri winaq, xkibꞌij: Chatzoqopij ri Barrabás. Ri Barrabás kꞌut jun elaqꞌom. ");
INSERT INTO quctt_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ri Pilato xuchap ri Jesús, kꞌa te riꞌ xtaqan chuchꞌayik. ");
INSERT INTO quctt_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ri ajchꞌoꞌjabꞌ chajil tinimit xkikem jun kꞌixa korona, kꞌa te riꞌ xkikoj che ri ujolom ri Jesús xuqujeꞌ xkikoj jun moraꞌt atzꞌyaq chirij. ");
INSERT INTO quctt_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Kꞌa te riꞌ xeqet rukꞌ, xkichapleꞌj uraqik kichiꞌ xkibꞌij: ¡Nim uqꞌij ri taqanel kech ri winaq aꞌj Israel! Kꞌa te riꞌ xkichꞌey chupalaj. ");
INSERT INTO quctt_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ri Pilato xel chi loq junmul pa ri nimalaj ja ri kataqan wi, kꞌa te riꞌ xubꞌij chike ri winaq aꞌj Israel: Riꞌ xinwesaj loq we Jesús rech kiwetaꞌmaj chi man kꞌo ta mak kinriq che. ");
INSERT INTO quctt_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Are xel loq ri Jesús, kojtal loq jun kꞌix korona che ri ujolom xuqujeꞌ kꞌyaqtal jun moraꞌt atzꞌyaq chirij. Ri Pilato xubꞌij chike: Riꞌ we achi. ");
INSERT INTO quctt_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Are xkil ri kꞌamal kibꞌe ri e chꞌawenelabꞌ cho ri Dios xuqujeꞌ ri e chajinelabꞌ rech ri Templo, xkiraq kichiꞌ xkibꞌij: ¡Ripoq! ¡Ripoq! Ri Pilato xubꞌij chike: Chikꞌama bꞌik ix chiripaꞌ. Ri in man kꞌo ta umak xinriqo. ");
INSERT INTO quctt_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ri winaq aꞌj Israel xkibꞌij: Uj kꞌo jun qataqanik, ri qataqanik kubꞌij chi yaꞌtal che kakamik, jeriꞌ rumal kubꞌij chibꞌil ribꞌ chi are ukꞌojol ri Dios. ");
INSERT INTO quctt_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ri Pilato are xuta we tzij riꞌ xnimar ri uxibꞌin ibꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Jeriꞌ xok chi bꞌik junmul pa ri nimalaj ja, kꞌa te riꞌ xuta che ri Jesús: ¿Jawjeꞌ katel wi? Ri Jesús man xchꞌaw taj. ");
INSERT INTO quctt_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ri Pilato xubꞌij che ri Jesús: ¿Man kinachꞌabꞌej ta ne lo? ¿La man kawilo chi kinkwinik katintzoqopij bꞌik xuqujeꞌ kinkwinik kintaqan charipik? ");
INSERT INTO quctt_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ri Jesús xubꞌij che: Man katkwin ta chubꞌanik ri jastaq riꞌ we ta mat chikaj petinaq wi ri kwinem ri yaꞌtal chawe, xaq jeriꞌ ri sibꞌalaj nim umak ri xinjachow pa aqꞌabꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Are xuta ri Pilato ri xbꞌix che, are xraj xutzoqopij bꞌik ri Jesús, ri winaq kꞌut xkiraqaqej kichiꞌ xkibꞌij: We katzoqopij bꞌik we achi riꞌ man at rech chꞌabꞌeꞌn taj ri nim qꞌatal tzij. Xapachin ri karaj kubꞌan taqanel wi xaq pa utukel kubꞌan ukꞌulel che ri nim taqanel. ");
INSERT INTO quctt_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Are xuta ri xkibꞌij ri winaq, xresaj loq ri Jesús kꞌa te riꞌ xtꞌuyiꞌk pa ri utem rech qꞌatoj tzij, ri kꞌolibꞌal ubꞌiꞌnam Bꞌantal che abꞌaj, Gabatá ubꞌiꞌ pa arameo. ");
INSERT INTO quctt_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Are qꞌij rech patanijem rech ri nimaqꞌij Pascua, qas pa nikꞌaj qꞌij, ri Pilato xubꞌij chike ri winaq: Riꞌ le itaqanel. ");
INSERT INTO quctt_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ri winaq xkibꞌij: Cheꞌl bꞌik, cheꞌl bꞌik, ripoq, ripoq. Ri Pilato xuta chike: ¿La kinrip kꞌu in ri itaqanel? Ri e kꞌamal taq kibꞌe ri e chꞌawenelabꞌ cho ri Dios xkibꞌij: Xaq xwi nim qataqanel uj ri kel je laꞌ pa Roma. ");
INSERT INTO quctt_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ri Pilato xujach bꞌik ri Jesús pa kiqꞌabꞌ rech jeriꞌ kakiripo. Ri ajchꞌoꞌjabꞌ chajil tinimit xkikꞌam bꞌik ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Xel kꞌu bꞌik ri Jesús, reqam bꞌik ri cheꞌ ripbꞌal xeꞌ je laꞌ pa ri leꞌaj ubꞌiꞌnam Ubꞌaqil jolomaj, pa arameo ubꞌiꞌnam Gólgota. ");
INSERT INTO quctt_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Chilaꞌ xkirip wi, xuqujeꞌ xeꞌkirip chi kebꞌ winaq rukꞌ, jun pa ri umox, jun chik pa ri uwiqiqꞌabꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ri Pilato xtaqan chukojik jun tzꞌibꞌatalik puꞌwiꞌ ri cheꞌ ripbꞌal ri kubꞌij: ARE WAꞌ RI JESÚS AJ NAZARET, RI NIM TAQANEL KECH RI WINAQ AꞌJ ISRAEL. ");
INSERT INTO quctt_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","E kꞌi chike ri winaq aꞌj Israel xkisikꞌij uwach ri tzꞌibꞌatalik jeriꞌ rumal ri leꞌaj ri xrip wi ri Jesús chuxukut ri nima tinimit kꞌo wi. Ri tzꞌibꞌatalik xtzꞌibꞌax pa ri tzijobꞌal arameo, latin xuqujeꞌ pa ri tzijobꞌal kech ri aꞌj Grecia ");
INSERT INTO quctt_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ri kꞌamal taq kibꞌe ri e chꞌawenelabꞌ cho ri Dios xeꞌkibꞌij che ri Pilato: Man katzꞌibꞌaj ta la “Nim Taqanel kech ri winaq aꞌj Israel.” We achi riꞌ xubꞌij chibꞌil ribꞌ chi are nim kitaqanel ri winaq aꞌj Israel. ");
INSERT INTO quctt_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ri Pilato xubꞌij chike: Ri xintzꞌibꞌaj, xintzꞌibꞌaj. ");
INSERT INTO quctt_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ri ajchꞌoꞌjabꞌ chajil tinimit are xkirip ri Jesús, xkikꞌam ri ratzꞌyaq xkirichꞌij pa kajibꞌ, xkikꞌam kanoq jun taq chꞌaqaꞌp ke. Xkikꞌam xuqujeꞌ ri ukaton xa ta ne jun tꞌisel kꞌo che, xane xa kemtalik. ");
INSERT INTO quctt_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ri ajchꞌoꞌjabꞌ xkibꞌij: Man kaqarichꞌij ta waꞌ we riꞌ. Chujetzꞌanoq rech kaqilo jachin kachꞌeken che. Jeriꞌ xkibꞌano. Jewaꞌ xkibꞌano rech kakꞌulmataj ri tzꞌibꞌatalik, ri kubꞌij: Xkijach ri watzꞌyaq chikiwach, xuqujeꞌ xeꞌtzꞌanik chuchꞌekik ri watzꞌyaq. ");
INSERT INTO quctt_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Chunaqaj ri cheꞌ ri xrip wi ri Jesús kꞌo apanoq ri unan ri Jesús xuqujeꞌ ri rachalal ri unan, kꞌo xuqujeꞌ ri María ri rixoqil ri Cleofas, rachiꞌl ri María Magdalena. ");
INSERT INTO quctt_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ri Jesús are xril ri unan xuqujeꞌ ri utijoxel ri sibꞌalaj uloq, xubꞌij che ri unan: Ixoq, leꞌ kꞌo le awal chi leꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kꞌa te riꞌ xubꞌij che ri utijoxel: Leꞌ chi leꞌ kꞌo wi le anan. Tzi che ri qꞌij riꞌ ri tijoxel xukꞌamawaꞌj ri ixoq cho ri rachoch. ");
INSERT INTO quctt_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Are xbꞌantaj ronojel we jastaq riꞌ, retaꞌm ri Jesús chi xbꞌantaj ronojel, rech kꞌu kakꞌulmataj ri tzꞌibꞌatalik xubꞌij: Kachaqiꞌj nuchiꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Kꞌo kꞌu apanoq jun kꞌolibꞌal ri kꞌo vinagre chupam. Xkimuꞌ kꞌu bꞌik jun qꞌux chupam, kꞌa te riꞌ xkixekebꞌa che jun aj, xkiya qꞌanoq pa uchiꞌ ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Are xunaꞌ ri Jesús ri vinagre, xubꞌij: Ronojel xbꞌantajik. Kꞌa te riꞌ xutzalabꞌa ri ujolom, xel ranimaꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Are qꞌij kabꞌan patanijik rech ri nimaqꞌij Pascua. Ri winaq aꞌj Israel man kakaj taj kekanaj kan ri kaminaqibꞌ choch ri cheꞌ ripbꞌal, jeriꞌ rumal are qꞌij rech uxlanem. Xaq jeriꞌ xkita che ri Pilato chi kataqan chuqꞌipixik ri bꞌaq che taq ri kaqan ri e xekel cho ri cheꞌ ripbꞌal rech keꞌqasax loq xuqujeꞌ keꞌsax bꞌik chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ri ajchꞌoꞌjabꞌ chajil tinimit xebꞌe chutatzꞌixik ri bꞌaq rech ri kaqan ri e xekebꞌatal cho ri che ripbꞌal. Nabꞌe xeꞌkitatzꞌij ri bꞌaq che ri kaqan ri e kebꞌ achyabꞌ ri e xekebꞌatal chuxukut ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Are xeqet rukꞌ ri Jesús, xkilo chi kaminaq chik, xaq jeriꞌ man xkitatzꞌij ta chi ri bꞌaq che ri raqan. ");
INSERT INTO quctt_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pune jeriꞌ jun chike ri ajchꞌoꞌjabꞌ chajil tinimit xujut bꞌik ri cheꞌ chꞌeyabꞌal che ri ukꞌalkꞌaꞌx ri Jesús, jeriꞌ xel loq kikꞌ xuqujeꞌ ja che. ");
INSERT INTO quctt_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ri xilowik kuqꞌalajisaj we jastaq riꞌ, xuqujeꞌ qas tzij ri kubꞌij. Areꞌ retaꞌm chi qas tzij ri kubꞌij, rech jeriꞌ kixkojon xuqujeꞌ ix. ");
INSERT INTO quctt_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Xkꞌulmataj we jastaq riꞌ rech jeriꞌ kakꞌulmataj ri tzꞌibꞌatalik: Man katatzꞌix ta jun chike ri ubꞌaqil ");
INSERT INTO quctt_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Kubꞌij xuqujeꞌ pa ri tzꞌibꞌatalik: Kakikaꞌyej na ri xkisoko. ");
INSERT INTO quctt_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Are xbꞌantaj ronojel we jastaq riꞌ, ri José ri kel pa Arimatea xeꞌ rukꞌ ri Pilato, xuꞌta che ri utyoꞌjal ri Jesús rech kumuqu. Ri José jun chike ri utijoxelabꞌ ri Jesús pune xaq pa awal, jeriꞌ rumal kuxiꞌj ribꞌ chike ri winaq aꞌj Israel. Ri Pilato xuya bꞌe che ri José xukꞌam bꞌik ri utyoꞌjal ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Xopan xuqujeꞌ ri Nicodemo, are waꞌ ri achi ri xeꞌsolin ri Jesús che ri jun chaqꞌabꞌil, rukꞌaꞌm bꞌik jun ciento libra kunabꞌal mirra xuqujeꞌ áloe. ");
INSERT INTO quctt_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ri José rachiꞌl ri Nicodemo xkikꞌam bꞌik ri utyoꞌjal ri Jesús, xkipis bꞌik jetaq ri kubꞌij ri kinaqꞌatajibꞌal, xkikoj bꞌik kꞌokꞌ taq kunabꞌal chirij. ");
INSERT INTO quctt_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Pa ri leꞌaj ri xrip wi ri Jesús kꞌo jun kꞌolibꞌal jawjeꞌ tiktal wi cheꞌ xuqujeꞌ kꞌo jun kꞌakꞌ muqbꞌal, xa ta ne jun muqtal chupam. ");
INSERT INTO quctt_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Xkimuq kꞌu kan ri Jesús chilaꞌ, jeriꞌ rumal are qꞌij bꞌanbꞌal patanijik rech ri nimaqꞌij Pascua, xuqujeꞌ naqaj kꞌo wi ri muqbꞌal chike. ");
INSERT INTO quctt_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Pa ri nabꞌe qꞌij rech wuq qꞌij, sibꞌalaj aqꞌabꞌ kꞌa kamuquq na, ri María Magdalena xeꞌ chuchiꞌ ri muqbꞌal, kꞌa te xrilo esatal chi ri abꞌaj ri kojtal kan chutzꞌapixik ri okibꞌal. ");
INSERT INTO quctt_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Jeriꞌ kaxikꞌanik xeꞌ jawjeꞌ e kꞌo wi ri Simón Pedro xuqujeꞌ ri jun tijoxel chik ri sibꞌalaj loqꞌ rumal ri Jesús, xuꞌbꞌij chike: Xkꞌamtaj bꞌik ri Ajawxel, man ketaꞌm taj jawjeꞌ xeꞌyoꞌq wi kanoq. ");
INSERT INTO quctt_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ri Pedro rachiꞌl ri jun tijoxel chik xebꞌe chuchiꞌ ri muqbꞌal. ");
INSERT INTO quctt_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Kikobꞌchal kexikꞌanik xebꞌek, are kꞌu ri jun tijoxel rumal ri sibꞌalaj kaxikꞌanik, nabꞌe xopan cho ri Pedro chuchiꞌ ri muqbꞌal. ");
INSERT INTO quctt_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Xpachi bꞌik pa ri muqbꞌal kꞌa te xrilo kꞌo ri atzꞌyaq chilaꞌ ri xpisiꞌ wi ri Jesús, man xok ta kꞌu bꞌik. ");
INSERT INTO quctt_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Kꞌa te riꞌ xopan ri Simón Pedro, xok bꞌik pa ri muqbꞌal. Xril ri atzꞌyaq ri xpisiꞌ wi ri Jesús, ");
INSERT INTO quctt_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","xuqujeꞌ ri atzꞌyaq ri xpisiꞌ wi ri ujolom ri Jesús, are kꞌu ri atzꞌyaq ri xpisiꞌ wi ri utyoꞌjal ri Jesús man kꞌo ta chi rukꞌ ri rachiꞌl taq atzꞌyaq xane bꞌustal chi kanoq yaꞌtal kan chuxukut. ");
INSERT INTO quctt_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Qas che ri qꞌotaj riꞌ xok chi bꞌik ri jun tijoxel ri xopan nabꞌe chuchiꞌ ri muqbꞌal. Are xril ri atzꞌyaq, xkojonik. ");
INSERT INTO quctt_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Che riꞌ majaꞌ kakichꞌobꞌ ri kubꞌij ri tzꞌibꞌatalik chi ri Jesús kakꞌastaj na uwach. ");
INSERT INTO quctt_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Kꞌa te riꞌ ri e tijoxelabꞌ xetzalij cho ri kachoch. ");
INSERT INTO quctt_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Are kꞌu ri María koqꞌik xkanaj kan chuchiꞌ ri muqbꞌal. Tajin koqꞌik are xpachi bꞌik, xkaꞌy pa ri muqbꞌal. ");
INSERT INTO quctt_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Kꞌa te xrilo e kebꞌ angelibꞌ aꞌj saq taq atzꞌyaq, e tꞌuyutꞌuj jawjeꞌ ri xkanaj wi ri utyoꞌjal ri Jesús, jun ángel tꞌuyul jawjeꞌ xkanaj wi ri raqan ri Jesús, ri jun chik tꞌuyul jawjeꞌ ri xkanaj wi ri ujolom. ");
INSERT INTO quctt_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ri angelibꞌ xkita che ri María: ¿Ixoq jas che katoqꞌik? Ri María xubꞌij: Kinoqꞌik rumal cher xkikꞌam bꞌik ri Wajaw, man wetaꞌm taj jawjeꞌ xeꞌkiya wi kanoq. ");
INSERT INTO quctt_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Are xbꞌiꞌtaj we riꞌ rumal xtzalqꞌomij chirij, kꞌa te xrilo takꞌal ri Jesús chilaꞌ, pune xril uwach man retaꞌm ta kꞌut chi are Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ri Jesús xuta che: Ixoq, ¿jas che katoqꞌik? ¿Jachin tajin katzukuj? Ri María pa ukꞌuꞌx chi ri Jesús are achi chajil rech ri leꞌaj jawjeꞌ kꞌo wi ri muqbꞌal, xubꞌij che: Tat, we lal xkꞌamow la bꞌik, bꞌij la chwe jawjeꞌ xeꞌya wi la rech keꞌn wi laꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ri Jesús xubꞌij che: ¡María! Ri María xtzalqꞌomij chirij, xubꞌij: ¡Raboni! (pa arameo kel kubꞌij Ajtij) ");
INSERT INTO quctt_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ri Jesús xubꞌij che: Minachapo rumal majaꞌ kintzalij rukꞌ ri nuTat. Are jaꞌbꞌij chike ri e wachalal chi kintzalij rukꞌ ri nuTat, are xuqujeꞌ iTat ix. Kintzalij rukꞌ ri nuDios xuqujeꞌ are iDios ix. ");
INSERT INTO quctt_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ri María Magdalena xeꞌ chubꞌixik chike ri tijoxelabꞌ ri xkꞌulmatajik, xubꞌij: Xinwil ri Ajawxel. Kꞌa te riꞌ xutzijoj chike ronojel ri xbꞌix che rumal ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Che ri bꞌenaq qꞌij rech ri nabꞌe qꞌij rech ri wuq qꞌij, ri tijoxelabꞌ kimulim kibꞌ kitzꞌapim ri uchiꞌ ja, jeriꞌ rumal kakixiꞌj kibꞌ chikiwach ri e kꞌamal taq bꞌe kech ri winaq aꞌj Israel, xaq kꞌa te xok bꞌik ri Jesús xeꞌkꞌol chikixoꞌl, xuya rutzil kiwach, xubꞌij: Ri jaꞌmaril kꞌo iwukꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Are xbꞌiꞌtaj we riꞌ rumal, xukꞌut ri uqꞌabꞌ xuqujeꞌ ri ukꞌalkꞌaꞌx chkiwach. Ri tijoxelabꞌ are xkil uwach ri Ajawxel, xekiꞌkotik. ");
INSERT INTO quctt_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Xutzalij ubꞌixik chike: Ri jaꞌmaril kꞌo iwukꞌ. Jetaq ri xubꞌan ri Tataxel, chinutaqik loq in, jeriꞌ xuqujeꞌ kinbꞌan in chiꞌtaqik bꞌik. ");
INSERT INTO quctt_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kꞌa te riꞌ xuꞌwupuj xuqujeꞌ xubꞌij chike: Chikꞌamawaꞌj ri Tyoxalaj Uxlabꞌixel. ");
INSERT INTO quctt_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ri winaq ri kikuy ix umak, kakuyutaj na; are kꞌu ri man kikuy taj, man kakuyutaj ta umak. ");
INSERT INTO quctt_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ri Tomás, jun chike ri kabꞌlajuj tijoxelabꞌ, man kꞌo ta kukꞌ ri tijoxelabꞌ are xukꞌut ribꞌ ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Jeriꞌ ri nikꞌaj tijoxelabꞌ xkibꞌij che: Xqil uwach ri Ajawxel. Ri Tomás xubꞌij: We man kinwil ri ujulal ri kalawix pa uqꞌabꞌ xuqujeꞌ kinjut bꞌik ri nuqꞌabꞌ pa ri ukꞌalkꞌaꞌx, man kinkoj ta wi. ");
INSERT INTO quctt_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Are iꞌkꞌowinaq chi wuqubꞌ qꞌij, ri tijoxelabꞌ junmul chik kimulim kibꞌ pa ri ja, kachiꞌl ri Tomás. Pune e tzꞌapatzꞌoj ri uchiꞌ ja ri Jesús xok bꞌik, xtakꞌiꞌk pa kinikꞌaj, xuya rutzil kiwach xubꞌij: Ri jaꞌmaril kꞌo iwukꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Kꞌa te riꞌ xubꞌij che ri Tomás: Chaya ri aqꞌabꞌ waral xuqujeꞌ chawila le nuqꞌabꞌ. Chaqebꞌsaj loq ri aqꞌabꞌ xuqujeꞌ chajutu bꞌik ri uwiꞌ aqꞌabꞌ pa ri nukꞌalkꞌaꞌx. Man kakabꞌalaj ta akꞌuꞌx xane chatkojonoq. ");
INSERT INTO quctt_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ri Tomás xubꞌij: ¡Wajaw, nuDios! ");
INSERT INTO quctt_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ri Jesús xubꞌij che: Katkojonik jeriꞌ rumal xawil na nabꞌe. Utz ke ri pune man xkil taj nabꞌe xekojon kꞌut. ");
INSERT INTO quctt_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ri Jesús xubꞌan chi na nikꞌaj mayijabꞌal taq kꞌutbꞌal chikiwach ri utijoxelabꞌ, ri man xetzꞌibꞌax taj pa we wuj riꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Are kꞌu we xtzꞌibꞌax pa we wuj riꞌ, xtzꞌibꞌaxik rech jeriꞌ kikojo chi ri Jesús are Cristo, ralkꞌwaꞌl ri Dios, rech are kixkojon che ri ubꞌiꞌ kayaꞌtaj na ikꞌaslemal. ");
INSERT INTO quctt_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Junmul chik ri Jesús xukꞌut ribꞌ chkiwach ri utijoxelabꞌ, chuchiꞌ ri cho Tiberias. Jewaꞌ xubꞌan chukꞌutik ribꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ri Simón Pedro xaq jun e kꞌo wi rukꞌ ri Tomás (ri kabꞌix yoꞌx che), ri Natanael ri kel pa Caná pa Galilea, ri e ralkꞌwaꞌl ri Zebedeo, xuqujeꞌ e kebꞌ tijoxelabꞌ chik. ");
INSERT INTO quctt_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ri Simón Pedro xubꞌij: Kineꞌ na pa chapoj kar. Ri e tijoxelabꞌ xkibꞌij che: Kujeꞌ awukꞌ. Xaq jeriꞌ xeꞌl bꞌik xaqꞌan pa ri jukubꞌ bꞌinibꞌal puꞌwiꞌ ri jaꞌ, xa ta kꞌu ne jun kar xkiriq che ri chaqꞌabꞌil riꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Are xsaqirik, ri Jesús xopan chuchiꞌ ri cho. Ri tijoxelabꞌ man xkichꞌobꞌ taj chi areꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Xaq kꞌa teꞌ ri Jesús xuta chike: Alabꞌom, ¿la maj jun jas iwe tijowik rij iwukꞌ? Maj, xecha ri tijoxelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ri Jesús xubꞌij chike: Chikꞌyaqa ri kꞌat pa iwiqiqꞌabꞌ rech kiꞌchap ri kar. Je kꞌu ri xkibꞌano, sibꞌalaj e kꞌi kar xeꞌkichapo, man kekwin ta chi kꞌut kakesaj loq ri kꞌat pa ri jaꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ri tijoxel ri sibꞌalaj kaloqꞌax rumal ri Jesús xubꞌij che ri Pedro: Are Ajawxel. Are xuta ri Pedro xbꞌix che “Are Ajawxel” aninaq xukoj bꞌik ri ratzꞌyaq jeriꞌ rumal xaq kꞌyaqal ratzꞌyaq ukojom, kꞌa te riꞌ xukꞌyaq bꞌik ribꞌ pa ri jaꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ri nikꞌaj tijoxelabꞌ chik xekanaj kanoq pa ri jukubꞌ bꞌinibꞌal puꞌwiꞌ ri jaꞌ, tajin kakijuruj kan ri kꞌat nojinaq che kar, jeriꞌ rumal chi ciento metros e kꞌo wi che ri uchiꞌ ri jaꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Are xeqaj pa ri jukubꞌ bꞌinibꞌal, xkil jun kar rachiꞌl jun kaxlan wa kꞌo cho jun rachaq qꞌaqꞌ. ");
INSERT INTO quctt_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ri Jesús xubꞌij chike: Chikꞌama loq kebꞌ oxibꞌ kar che ri xiꞌchap loq. ");
INSERT INTO quctt_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ri Simón Pedro xpaqiꞌ pa ri jukubꞌ bꞌinibꞌal, xuꞌjuruj bꞌik ri kꞌat sibꞌalaj nojinaq che nimaq taq kar, kꞌa chuchiꞌ ri jaꞌ. Xeꞌkichap jun ciento rukꞌ nikꞌaj rachiꞌl oxibꞌ kar. Pune sibꞌalaj e kꞌi kar e kꞌo bꞌik pa ri kꞌat, man xtꞌoqopin ta kꞌu ri kꞌat. ");
INSERT INTO quctt_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ri Jesús xubꞌij chike: Chixanloq, chixulwoꞌq. Man kꞌo ta kꞌu jun chike ri tijoxelabꞌ xuta che ri Jesús: ¿Jachin ri lal? Jeriꞌ rumal ketaꞌm chi are Jesús. ");
INSERT INTO quctt_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ri Jesús xukꞌam ri kaxlan wa, kꞌa te riꞌ xuya chike, je xuqujeꞌ xubꞌan che ri kar. ");
INSERT INTO quctt_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Are waꞌ urox mul ri xukꞌut ribꞌ ri Jesús chikiwach ri utijoxelabꞌ are kꞌastajinaq chi uwach. ");
INSERT INTO quctt_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Are xtijtaj ri kiwa rech aqꞌabꞌil, ri Jesús xuta che ri Simón Pedro: Simón ukꞌojol ri Juan, ¿la kꞌo na ri aloqꞌanik chwe cho ri aloqꞌanik chike we nikꞌaj riꞌ? Ri Pedro xubꞌij: Jeꞌ Tat, etaꞌm la chi kanloqꞌaj la. Ri Jesús xubꞌij che: Chaꞌchajij bꞌa ri alaj taq nuchij. ");
INSERT INTO quctt_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ri Jesús xuta chi junmul che ri Pedro: Simón ukꞌojol ri Juan, ¿la kinaloqꞌaj? Ri Pedro xubꞌij: Jeꞌ Tat, etaꞌm la chi kanloqꞌaj la. Ri Jesús xubꞌij che: Chaꞌchajij ri nuchij. ");
INSERT INTO quctt_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Churox mul xuta ri Jesús che ri Simón: Simón, ukꞌojol ri Juan ¿la kinaloqꞌaj? Ri Pedro xkꞌaxir ranimaꞌ jeriꞌ rumal xta che oxibꞌ mul ri kꞌotbꞌal chiꞌ “¿La kinaloqꞌaj?” Xubꞌij che ri Jesús: Wajaw, lal etaꞌm la ronojel, etaꞌm la chi kanloqꞌaj la. Ri Jesús xubꞌij che: Chaꞌchajij ri nuchij. ");
INSERT INTO quctt_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Qas tzij kinbꞌij chawe chi are at akꞌal ala, kakoj bꞌik ri awatzꞌyaq kateꞌ jawjeꞌ ri kawaj wi. Are kꞌu we xatriꞌjobꞌik, kayuq na ri ukobꞌchal ri aqꞌabꞌ, jun chi kꞌu wi na kakojow bꞌik ri awatzꞌyaq chawij kꞌa te riꞌ katukꞌam bꞌik jawjeꞌ ri man kawaj taj kateꞌ wi. ");
INSERT INTO quctt_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Xubꞌij ri Jesús we riꞌ rech kuya uchꞌobꞌik che ri Pedro ri kamikal ri kuriq na, rech jeriꞌ kuya uqꞌij ri Dios. Kꞌa te riꞌ xubꞌij ri Jesús che: Chinatereneꞌj. ");
INSERT INTO quctt_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Are xtzalqꞌomij ri Pedro chirij, xrilo chi teren bꞌik ri tijoxel ri sibꞌalaj kaloqꞌax rumal ri Jesús, are waꞌ ri tijoxel ri pa ri jun rekeqꞌij xqꞌoyiꞌ cho ukꞌuꞌx ri Jesús xuta che: Ajawxel, ¿jachin riꞌ ri kakꞌayin la? ");
INSERT INTO quctt_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Are xril ri Pedro we tijoxel riꞌ, xuta che ri Ajawxel: Ajawxel, ¿jas kakꞌulmataj rukꞌ areꞌ? ");
INSERT INTO quctt_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ri Jesús xubꞌij che: We kawaj in chi kakꞌasiꞌ na kꞌa kintzalij na loq, ¿jas awe at che? At xwi chinatereneꞌj. ");
INSERT INTO quctt_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Rumal riꞌ xtukin bꞌik ubꞌixik chikixoꞌl ri alaxik chi we tijoxel riꞌ man kakam taj. Ri Jesús man xubꞌij taj chi mat kakamik, xane xwi xubꞌij: We kawaj in chi kakꞌasiꞌ kꞌa kintzalij na loq, ¿jas awe at che? ");
INSERT INTO quctt_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Are waꞌ ri tijoxel ri kaqꞌalajisan we jastaq riꞌ xuqujeꞌ areꞌ xtzꞌibꞌan we jastaq riꞌ. Uchapom xuqujeꞌ qakꞌuꞌx chi ri uqꞌalajisanik qas tzij wi. ");
INSERT INTO quctt_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ri Jesús xubꞌan xuqujeꞌ nikꞌaj taq jastaq chik, we ta kꞌu katzꞌibꞌax pa jujunal ronojel ri xubꞌano, kinchomaj in chi maj kakꞌojiꞌ wi ronojel ri wuj riꞌ cho ri uwachulew.");
INSERT INTO quctt_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Loqꞌalaj wach chꞌabꞌeꞌn Teófilo: Pa ri nabꞌe nuwuj ri xintzꞌibꞌaj chawe, xintzijon chirij ronojel ri xubꞌan ri Jesús xuqujeꞌ ri xukꞌutu. ");
INSERT INTO quctt_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Kꞌa pa ri qꞌij are xkꞌam bꞌik chikaj are xyaꞌtaj kan ri utaqanik chike ri utijoxelabꞌ rukꞌ ri utobꞌanik ri Tyoxalaj Uxlabꞌixel. ");
INSERT INTO quctt_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Are xkꞌastaj uwach, xukꞌut ribꞌ chikiwach ri uꞌtaqoꞌn, xubꞌan mayijabꞌal taq jastaq rech xukꞌut chikiwach chi qas xkꞌastaj uwach. Kawinaq qꞌij xukꞌut ribꞌ chkiwach xutzijoj ri rajawarem ri Dios chike. ");
INSERT INTO quctt_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Are kꞌo kukꞌ xubꞌij chike: Man kixel ta na bꞌik pa Jerusalén, xane chiwayeꞌj na ri ubꞌim loq kan ri nuTat, ri nutzijom chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Rumal cher ri Juan xubꞌan qasanaꞌ rukꞌ jaꞌ, are kꞌu ri ix man kanajtin ta na kabꞌan iqasanaꞌ rukꞌ ri Tyoxalaj Uxlabꞌixel. ");
INSERT INTO quctt_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Are kimulim kibꞌ ri e taqoꞌn, xkita che ri Jesús: Ajawxel, ¿la che kꞌu we qꞌotaj riꞌ kakoj la ri taqanel pa ri tinimit Israel? ");
INSERT INTO quctt_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Xubꞌij ri Jesús chike: Man yaꞌtal ta chiꞌwe ix kiwetaꞌmaj ri qꞌotaj xuqujeꞌ ri qꞌij are kubꞌan na ri karaj ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Are kape ri Tyoxalaj Uxlabꞌixel piꞌwiꞌ, kikꞌamawaꞌj na kwinem xuqujeꞌ kixux na qꞌalajisal taq we pa Jerusalén, pa ronojel ri tinimit Judea, pa ri tinimit Samaria xuqujeꞌ pa ri naj taq tinimit rech ronojel ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Are xbꞌiꞌtaj we jastaq riꞌ rumal ri Jesús, ko xkaꞌyex kumal ri tijoxelabꞌ, kꞌa te riꞌ qas chikiwach xwaꞌjilisax bꞌik, xkꞌam bꞌik chikaj, xchꞌuq bꞌik pa jun sutzꞌ, man xekwin ta chik xkil uwach. ");
INSERT INTO quctt_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ri tijoxelabꞌ tajin kekaꞌy apanoq cho ri kaj are paqal ri Jesús, xaq kꞌa teꞌ xeqet kebꞌ achyabꞌ kukꞌ, kikojom saq taq katzꞌyaq, xkibꞌij chike: ");
INSERT INTO quctt_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Achyabꞌ aꞌj Galilea, ¿jas che tajin kixkaꞌy chikaj? Ri Jesús ri xkꞌam bꞌik chiꞌwach pa ri kaj, kape chi na junmul jetaq ri xubꞌano are xeꞌek. ");
INSERT INTO quctt_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Are xeqaj loq ri e taqoꞌn cho ri juyubꞌ ri kabꞌix Olivos che ri kꞌo apanoq chi jun kilómetro che ri tinimit Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Xoꞌpan kꞌu pa ri tinimit, xepaqiꞌ pa ri ja ri e kꞌo wi. Are waꞌ ri kibꞌiꞌ ri achyabꞌ ri e kꞌo chilaꞌ: ri Pedro, ri Jacobo, ri Juan, ri Andrés, ri Felipe, ri Tomás, ri Bartolomé, ri Mateo, ri Jacobo ukꞌojol ri Alfeo, ri Simón ri kachiꞌl ri Zelotes rachiꞌl ri Judas rachalal ri Jacobo. ");
INSERT INTO quctt_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Konojel ri e taqoꞌn xkimulij kibꞌ, kachiꞌl ri María ri unan ri Jesús, ri e rachalal xuqujeꞌ nikꞌaj ixoqibꞌ chik, junam amaqꞌel xkibꞌan chꞌawem cho ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Pa taq ri qꞌij riꞌ are kimulim kibꞌ ri kojonelabꞌ karaj e jun ciento rukꞌ juwinaq kikꞌyal. Ri Pedro xtakꞌiꞌ chikixoꞌl xubꞌij chike: ");
INSERT INTO quctt_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Qachalal, rajawaxik kakꞌulmataj ri kubꞌij ri Tzꞌibꞌatalik are waꞌ ri xubꞌij loq ri Tyoxalaj Uxlabꞌixel chuchiꞌ ri qamam David ojer chi kakꞌulmataj na rukꞌ ri Judas. ");
INSERT INTO quctt_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ri Judas qachiꞌl kan nabꞌe xuqujeꞌ xchakun qukꞌ pa ri qawokaj. ");
INSERT INTO quctt_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Xuloqꞌ kꞌu jun ulew chech ri pwaq ri tojbꞌal rech ri etzelal ri xubꞌano, chilaꞌ xtzaq wi xuliꞌ uwiꞌ, xraqin ri upam, xel loq ronojel ri rixkoꞌl. ");
INSERT INTO quctt_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Xel kꞌu loq utzijoxik ri xkꞌulmatajik konojel ri winaq pa ri tinimit Jerusalén xketaꞌmaj we jastaq riꞌ. Rumal riꞌ ri ulew ri xkam wi ri Judas xubꞌinaꞌj Acéldama, ri kel kubꞌij Kikꞌ ulew pa ri tzijobꞌal arameo. ");
INSERT INTO quctt_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Jeriꞌ rumal cher pa ri wuj rech Salmos tzꞌibꞌatal wi loq: Tolon kan upam ri rachoch, mat ko chi jun kakꞌojiꞌ chupam. Xuqujeꞌ kubꞌij: Yoꞌq ri reqeleꞌn che jun winaq chik. ");
INSERT INTO quctt_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Rumal kꞌu ri rajawaxik kaqachaꞌ jun chikixoꞌl ri xekꞌojiꞌ qukꞌ are xkꞌojiꞌ ri Ajawxel Jesús qukꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Rajawaxik chi we winaq riꞌ kꞌolinaq loq qukꞌ are xqachapleꞌj loq, che taq ri qꞌij are xubꞌan qasanaꞌ ri Juan kꞌa pa ri qꞌij are xkꞌam bꞌik ri Jesús pa ri kaj, xuqujeꞌ rajawaxik chi xril qukꞌ junam ri ukꞌastajibꞌal ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Xeꞌkichaꞌ kꞌu e kebꞌ achyabꞌ: Ri José ri kabꞌix Barsabás che, xuqujeꞌ Justo rachiꞌl ri Matías. ");
INSERT INTO quctt_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Kꞌa te riꞌ xkibꞌan chꞌawem xkibꞌij: Ajawxel, etaꞌm la ri kanimaꞌ konojel ri winaq, kꞌutu bꞌa la chiqawach jachin chike we kebꞌ achyabꞌ riꞌ chaꞌom la, ");
INSERT INTO quctt_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","rech kok che taqoꞌn ech la, kukꞌam ri eqeleꞌn ri xuya kan ri Judas rumal cher xqaj pa mak, xeꞌ kꞌu chilaꞌ jawjeꞌ ri taqal wi che. ");
INSERT INTO quctt_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Xkikꞌyaq kꞌu kij chi rilik jachin chirij kaqaj wi. Xqaj kꞌu chirij ri Matías. Ri Matías xok kukꞌ ri julajuj taqoꞌn. ");
INSERT INTO quctt_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Are xopan ri nimaqꞌij rech Pentecostés, konojel ri kojonelabꞌ kimulim kibꞌ xa pa jun kꞌolibꞌal. ");
INSERT INTO quctt_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Xaq kꞌa teꞌ xkita jun nimalaj jumumem jetaq jun nimalaj kyaqiqꞌ ri xpe chikaj, xjinin pa ronojel ri ja jawjeꞌ ri e tꞌuyul wi. ");
INSERT INTO quctt_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Xaq kꞌa te xkil raqꞌ qꞌaqꞌ ri kajinin pa kiwiꞌ chi kijujunal. ");
INSERT INTO quctt_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Konojel ri e kꞌo pa ri ja xenoj che ri Tyoxalaj Uxlabꞌixel, xkichapleꞌj chꞌawem pa juleꞌ taq chꞌabꞌal chik ri xuya ri Tyoxalaj Uxlabꞌixel chike. ");
INSERT INTO quctt_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Pa taq ri qꞌij riꞌ e kꞌo pa Jerusalén achyabꞌ aꞌj Israel ri keniman che ri Dios, ri kepe pa juleꞌ taq tinimit chik. ");
INSERT INTO quctt_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Are xkita ri xkꞌulmatajik, aninaq xeꞌkilaꞌ, xemayijanik rumal chi ri kitzijobꞌal katzijobꞌex chi kumal ri kojonelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Xkimay ri xkꞌulmatajik, rumal riꞌ xkibꞌij: Konojel we winaq riꞌ aꞌj Galilea ¿jas che jewaꞌ xkꞌulmatajik? ");
INSERT INTO quctt_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Jas che waꞌ keꞌqato chi kechꞌaw pa ri qatzijobꞌal? ");
INSERT INTO quctt_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ri uj, jaljoj taq tinimit uj petinaq wi, e kꞌo aꞌj Media, aꞌj Elam, aꞌj Mesopotamia, aꞌj Judea, aꞌj Capadocia, aꞌj Ponto, aꞌj Asia. ");
INSERT INTO quctt_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Xuqujeꞌ e kꞌo qukꞌ ri aꞌj Frigia, aꞌj Panfilia, aꞌj Egipto xuqujeꞌ e solinelabꞌ ri kepe Roma. ");
INSERT INTO quctt_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Xuqujeꞌ e kꞌo winaq aꞌj Creta, xuqujeꞌ aꞌj Arabia, qonojel xqato chi we winaq riꞌ kakitzijoj pa ri qatzijobꞌal ri mayijabꞌal taq jastaq ri ubꞌanom ri Dios kukꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Xemayijan ri winaq, man kakiriq taj jas kakibꞌano, xkita chibꞌil taq kibꞌ jas jeꞌ keꞌloq ri xkilo. ");
INSERT INTO quctt_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","E kꞌo kꞌu jujun xkibꞌij chike: ¡We achyabꞌ riꞌ xa e qꞌabꞌarelabꞌ! ");
INSERT INTO quctt_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ri Pedro e rachiꞌl ri julajuj taqoꞌn xetakꞌiꞌ chikiwach ri winaq, ri Pedro xubꞌij: Qatat qanan aꞌj Jerusalén, xuqujeꞌ ri kixpe pa nikꞌaj taq tinimit chik mixsachik, ");
INSERT INTO quctt_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","we winaq riꞌ man e qꞌabꞌarelabꞌ taj jetaq ri kibꞌij ix, la man kiwilo sibꞌalaj aqꞌabꞌil na. ");
INSERT INTO quctt_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","We tajin kiwilo are waꞌ ri xuqꞌalajisaj loq ri qꞌalajisal tzij Joel ojer. ");
INSERT INTO quctt_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ri Dios kubꞌij: Pa ri kꞌisbꞌal taq qꞌij kintaq loq ri Tyoxalaj Uxlabꞌixel pa kiwiꞌ konojel winaq. Ri iꞌkꞌojol xuqujeꞌ ri iꞌmiꞌal kakiqꞌalajisaj na ri tzij ri kinya chike. Ri akꞌal taq alabꞌom kakil na ri kakꞌut chkiwach, Ri achyabꞌ kaꞌchikꞌ na. ");
INSERT INTO quctt_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Xuqujeꞌ pa taq ri qꞌij riꞌ kintaq na bꞌik ri Tyoxalaj Uxlabꞌixel pa kiwiꞌ ri e patanil we, achyabꞌ xuqujeꞌ ixoqibꞌ kakiqꞌalajisaj kꞌu na ri tzij ri kinya chike. ");
INSERT INTO quctt_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Kinbꞌan na kꞌutbꞌal cho ri kaj xuqujeꞌ cho ri uwachulew. Kilitaj na kikꞌ, xuqujeꞌ qꞌaqꞌ, xuqujeꞌ nimaꞌq taq sibꞌ jeꞌ jas ri sutzꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ri qꞌij kaqꞌequꞌmataj na, Ri ikꞌ kakyaqar na jeꞌ jas ri kikꞌ. We riꞌ kakꞌulmatajik are majaꞌ kuriq ri nimalaj uqꞌij ri Ajawxel Dios. ");
INSERT INTO quctt_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Are kꞌu ri kunaꞌtaj ri ubꞌiꞌ ri Ajawxel Dios, kakolotaj na. ");
INSERT INTO quctt_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Achyabꞌ aꞌj Israel, chitatabꞌej ri kinbꞌij. Iwetaꞌm ix chi ri Jesús aj Nazaret are waꞌ ri achi ri xya uqꞌij rumal ri Dios rumal xubꞌan ri mayijabꞌal taq jastaq, ri nimaq taq kꞌutbꞌal, xuqujeꞌ ri etal ri xubꞌan ri Dios iwukꞌ rumal Areꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ri Dios retaꞌm chi loq ri kakꞌulmatajik, je kꞌu xelik are xjach ri Jesús pa kamikal kumal ri itzel taq winaq, xiripo xuqujeꞌ xikamisaj bꞌik. ");
INSERT INTO quctt_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ri Dios kꞌut xukꞌastajisaj ri Jesús, man xkwin ta ri kamikal xchꞌeken che. ");
INSERT INTO quctt_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Jewaꞌ ubꞌim loq ri nim taqanel David chirij ri Jesús: Ri Ajawxel kꞌo wukꞌ, man kasach ta nuwach. ");
INSERT INTO quctt_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Rumal riꞌ sibꞌalaj kakiꞌkot ri wanimaꞌ, amaqꞌel kinraq nuchiꞌ che qꞌijilaꞌnem, kuꞌl na kꞌuꞌx chi man kꞌo ta kꞌax kinriqo. ");
INSERT INTO quctt_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Wetaꞌm chi man kinya ta la kan chkixoꞌl ri kaminaqibꞌ, man kaj ta la chi kaqꞌay ri Tyoxalaj patanil e la pa ri jul. ");
INSERT INTO quctt_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kꞌutum la ri bꞌe rech kꞌaslemal chinuwach. Kanojisaj kꞌu na la ri wanimaꞌ rukꞌ kiꞌkotemal rumal cher kakꞌojiꞌ na la wukꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Loqꞌalaj taq qachalal, chichomajmpeꞌ. Ri qamam David man tajin ta kubꞌij we jastaq riꞌ chibꞌil ribꞌ areꞌ, rumal cher areꞌ kaminaq chik, xmuqik, xuqujeꞌ ri jul ri xmuq wi kꞌa kaqil na uwach kamik. ");
INSERT INTO quctt_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ri David rumal cher jun qꞌalajisal utzij ri Dios, retaꞌm chi ri Dios uchiꞌm loq chi jun chike ri e ralkꞌwaꞌl kataqan na pa kiwiꞌ ri tinimit. ");
INSERT INTO quctt_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ri David ojer xril loq ri kakꞌulmataj na, xuqꞌalajisaj kꞌu ri ukꞌastajibꞌal ri Cristo, xubꞌij chi Man kakanaj ta kan chkixoꞌl ri kaminaqibꞌ, man kaqꞌay ta ri utyoꞌjal. ");
INSERT INTO quctt_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ri Dios kꞌut xukꞌastajisaj ri Jesús chkixoꞌl ri kaminaqibꞌ, qonojel uj xqil ri xkꞌulmatajik. ");
INSERT INTO quctt_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Xnimarisax kꞌu uqꞌij, xtꞌuyubꞌax pa ri uwiqiqꞌabꞌ ri Dios jetaq ri chiꞌtal loq che, xuqujeꞌ xyaꞌtaj ri Tyoxalaj Uxlabꞌixel che, rech che taq we qꞌij riꞌ kuya loq pa qawiꞌ jetaq ri tajin kiwilo. ");
INSERT INTO quctt_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ri David man xpaqiꞌ taj pa ri kaj pune xubꞌij: Ri Ajawxel xubꞌij che ri wAjaw: Chattꞌuyul pa ri nuwiqiqꞌabꞌ, ");
INSERT INTO quctt_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Kinya na chawe chi katchꞌeken, pa kiwiꞌ konojel ri akꞌulel. ");
INSERT INTO quctt_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Rumal kꞌu waꞌ chetaꞌmaxoq chi waꞌ we Jesús riꞌ ri xiripo, ri Dios xubꞌan Cristo che xuqujeꞌ rajaw ronojel ri kꞌolik. ");
INSERT INTO quctt_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ri tzij ri xuqꞌalajisaj ri Pedro xukꞌaxirisaj kanimaꞌ ri winaq, rumal riꞌ xkibꞌij che ri Pedro xuqujeꞌ chike ri nikꞌaj taqoꞌn chik: Qachalal, ¿jas kꞌu rajawaxik kaqabꞌano? ");
INSERT INTO quctt_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ri Pedro xubꞌij chike: Chikꞌexa ikꞌuꞌx, xuqujeꞌ ri ichomanik chixtzalij rukꞌ ri Dios. Rajawaxik kabꞌan iqasanaꞌ pa jujunal pa ri ubꞌiꞌ ri Jesucristo, xa jeriꞌ kakuyutaj ri imak, xuqujeꞌ kikꞌamawaꞌj ri usipanik ri Tyoxalaj Uxlabꞌixel. ");
INSERT INTO quctt_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Waꞌ we chiꞌtal loq, iwech kech ri iwalkꞌwaꞌl, kech konojel ri winaq ri e kꞌo cho ri uwachulew, kech konojel ri e sikꞌital rumal ri Ajawxel. ");
INSERT INTO quctt_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ri Pedro man xqꞌiꞌtaj ta che ubꞌixik chike ri kojonelabꞌ: Chikolo iwibꞌ chike ri itzel taq winaq ri e kꞌo pa taq we qꞌij junabꞌ riꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ri xkikoj ri xubꞌij ri Pedro, xbꞌan kiqasanaꞌ karaj oxibꞌ mil riꞌ ri xeqꞌax kukꞌ ri kojonelabꞌ che riꞌ qꞌij riꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Konojel ri xekojonik xkibꞌan ri xkikꞌut ri e taqoꞌn re ri Jesús, xkimulij kibꞌ rukꞌ kiꞌkotemal, junam xkibꞌan chꞌawem, junam xkitij kiwa. ");
INSERT INTO quctt_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Sibꞌalaj xkimochꞌ kibꞌ konojel ri winaq xuqujeꞌ xemayijanik, rumal ri jastaq xuqujeꞌ kꞌutbꞌal ri xkibꞌan ri uꞌtaqoꞌn ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Konojel ri kojonelabꞌ xkimulij kibꞌ xa pa jun kꞌolibꞌal xuqujeꞌ xkijach ronojel ri kijastaq chibꞌil taq kibꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","E kꞌi chike xkikꞌayij ri kulew xuqujeꞌ ri jastaq ke. Ri rajil ri xkiriqo xkiya chike ri kꞌo kirajawaxik. ");
INSERT INTO quctt_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ronojel qꞌij xkimulij kibꞌ pa ri Templo, xuqujeꞌ cho taq kachoch, xkijach kiwa chibꞌil taq kibꞌ man xkikꞌekꞌej taj uyaꞌik. Junam xewaꞌik rukꞌ kiꞌkotemal. ");
INSERT INTO quctt_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Amaqꞌel xkiya uqꞌij ri Dios, sibꞌalaj nim xiꞌlik kumal konojel ri winaq. Ri Dios kꞌut xuꞌkꞌam loq qꞌij chi qꞌij ri winaq ri kekolotajik rech kekꞌojiꞌ kukꞌ ri kojonelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ri Pedro rachiꞌl ri Juan xebꞌe pa chꞌawem pa ri Templo pa ri uroꞌ qꞌotaj rech bꞌenaq qꞌij. ");
INSERT INTO quctt_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Are xoꞌpan rukꞌ ri Ja Templo Dios, xkil jun achi tꞌuyul chuchiꞌ ri uchiꞌ ja ri ubꞌiꞌnam Jeꞌlik uchiꞌ ja, we achi riꞌ kuta ulimoxna chike ri winaq ri kopan chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ri achi, are xrilo chi ri Juan rachiꞌl ri Pedro koꞌk bꞌik pa ri Templo, xuta ulimoxna chike. ");
INSERT INTO quctt_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ri Juan xuqujeꞌ ri Pedro ko xkikaꞌyej ri achi, ri Pedro xubꞌij che: Ko chujakaꞌyej. ");
INSERT INTO quctt_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ri achi xuꞌkaꞌyej, rayeꞌm kaya kan jun ulimoxna. ");
INSERT INTO quctt_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ri Pedro xubꞌij che: Man kꞌo ta saqa pwaq, man kꞌo ta qꞌana pwaq wukꞌ. Are kꞌu ri kꞌo wukꞌ kinya chawe. Pa ri ubꞌiꞌ ri Cristo Jesús rech Nazaret, chatwaꞌjiloq, chatbꞌinoq. ");
INSERT INTO quctt_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ri Pedro xuchap ri uwiqiqꞌabꞌ ri achi, xuwaꞌjilisaj, aninaq kꞌut xeyaꞌtaj uchuqꞌabꞌ ri raqan xekunatajik. ");
INSERT INTO quctt_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Xtakꞌiꞌ ri achi, xbꞌinik, xuqujeꞌ xuchapleꞌj chꞌoplajem. Kꞌa te riꞌ xok bꞌik kukꞌ ri Juan rachiꞌl ri Pedro pa ri Templo, kachꞌoplajik kuqꞌijilaꞌj ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Konojel ri winaq ri xkilo chi xbꞌinik xuqujeꞌ xuqꞌijilaꞌj ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Xemayijanik are xkilo chi are waꞌ ri chꞌokeꞌr ri kuta kan limoxna nabꞌe chuchiꞌ ri jeꞌl uchiꞌ ja. ");
INSERT INTO quctt_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Xemayijanik ri winaq, aninaq xeꞌl loq pa ri raqan ja rech Salomón xepe jawjeꞌ kꞌo wi ri achi ri xutzirik, kꞌa te xkilo ri achi xekel chike ri Pedro rachiꞌl ri Juan. ");
INSERT INTO quctt_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ri Pedro are xrilo chi xkimulij kibꞌ ri winaq, xubꞌij chike: Winaq aꞌj Israel, ¿jas che kixmayijan che we xkꞌulmatajik? ¿Jas che ko kujikaꞌyej teꞌq piꞌkꞌuꞌx chi uj xujkunan we achi riꞌ rukꞌ qachuqꞌabꞌ o rukꞌ ri qutzilal? ");
INSERT INTO quctt_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Are ri uDios ri Abraham, ri uDios ri Isaac, ri uDios ri Jacob, ri kiDios ri qatat qanan, are waꞌ xyoꞌw kwinem che ri Jesús rech xubꞌan we kꞌutbꞌal riꞌ. Are waꞌ ri Jesús ri xiwetzelaj uwach xuqujeꞌ xijach cho ri Pilato, pune ri Pilato xraj xutzoqopij. ");
INSERT INTO quctt_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Xiwetzelaj ri sukꞌ xuqujeꞌ Tyoxalaj winaq are xitoqꞌij xtzoqopix ri jun kamisanel. ");
INSERT INTO quctt_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Xikamisaj bꞌik ri yaꞌl kꞌaslemal, ri Dios kꞌut xukꞌastajisaj uwach chikixoꞌl ri kaminaqibꞌ. Ri uj xqil we kꞌulmatajem riꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","We achi riꞌ xkunatajik rumal ri kojonik che ri Jesús, iwetaꞌm chi nabꞌe kanoq chꞌokeꞌr. Are kꞌu ri kojonem che ri ubꞌiꞌ ri Jesús xkunanik. ");
INSERT INTO quctt_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Wachalal, wetaꞌm in chi ri ix xuqujeꞌ ri kꞌamal taq ibꞌe, xibꞌan kꞌax che ri Jesús rumal cher man iwetaꞌm taj uwach. ");
INSERT INTO quctt_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ri Dios kꞌut xraj chi jewaꞌ xkꞌulmatajik. Ri e qꞌalajisal taq tzij kitzijom loq chi ri Jesús kuriq na ri kꞌax. ");
INSERT INTO quctt_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kamik kꞌut chikꞌexa ikꞌuꞌx xuqujeꞌ chixtzalij rukꞌ ri Dios rech kachuptaj ri imak. ");
INSERT INTO quctt_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Kutaq kꞌu na loq ri Jesús, ri iMesías. Are waꞌ ri utzijom loq rij ojer. ");
INSERT INTO quctt_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Choqꞌaqꞌ wi chi kakꞌojiꞌ na ri Jesús pa ri kaj, kꞌa kabꞌan na kꞌakꞌ che ronojel ri jastaq jeꞌ jas ri ubꞌim loq ri Dios chi kichiꞌ ri loqꞌalaj taq achyabꞌ qꞌalajisal taq rech ri utzij. ");
INSERT INTO quctt_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ri Moisés xubꞌij: Ri Ajawxel ri iDios kuwaꞌjilisaj na jun qꞌalajisal rech ri utzij chikixoꞌl ri uwinaq jetaq ri in. Chitatabꞌej jas jeꞌ ri kubꞌij na chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Xapachin kꞌu riꞌ ri man kuta ta ri qꞌalajisal utzij ri Dios, kesax na bꞌik chikixoꞌl ri utinimit ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Konojel ri achyabꞌ ri xkiqꞌalajisaj loq ri utzij ri Dios xchapleꞌtaj loq rukꞌ ri Samuel xkitzijoj la rij waꞌ we tajin kakꞌulmataj kamik. ");
INSERT INTO quctt_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ronojel ri xutzuj loq ri Dios kumal ri qꞌalajisal taq rech ri utzij, iwech ix rumal chi ix kalkꞌwaꞌl taq ri achyabꞌ riꞌ. Ri Dios xubꞌij che ri Abraham: Ketewchiꞌtaj na konojel ri winaq rech ri uwachulew rumal re ri awijaꞌl. ");
INSERT INTO quctt_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ri Dios are xukꞌastajisaj ri ukꞌojol chkixoꞌl ri kaminaqibꞌ, xutaq bꞌik nabꞌe iwukꞌ, winaq aꞌj Israel, rech kixutewechiꞌj, xuqujeꞌ kitas iwibꞌ che ri itzel taq ibꞌe. ");
INSERT INTO quctt_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Tajin ketzijon na ri Pedro rachiꞌl ri Juan kukꞌ ri winaq are xoꞌpan ri chꞌawenelabꞌ cho ri Dios, xuqujeꞌ ri kꞌamal bꞌe kech ri chajil rech ri Templo je xuqujeꞌ jujun chike ri saduceos. ");
INSERT INTO quctt_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Sibꞌalaj e yojtajinaq we kꞌamal taq bꞌe riꞌ, rumal chi ri Pedro, rachiꞌl ri Juan tajin kakikꞌut chikiwach ri winaq chi kꞌo kꞌastajibꞌal ke kaminaqibꞌ pa ri ubꞌiꞌ ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Rumal kꞌu che ri xok ri aqꞌabꞌ xeꞌkichapo, xeꞌkikoj kan jun aqꞌabꞌ pa cheꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Sibꞌalaj e kꞌi kꞌu chike ri xkita ri utzij ri Dios xekojonik, xwi ri achyabꞌ kaꞌjilabꞌ jobꞌ mil, man xaꞌjilabꞌ taj ri akꞌalabꞌ xuqujeꞌ ri ixoqibꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Chukabꞌ qꞌij xkimulij kibꞌ pa Jerusalén ri kꞌamal taq bꞌe ri e taqanelabꞌ xuqujeꞌ ri ajtzꞌibꞌabꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Xkꞌojiꞌ xuqujeꞌ kukꞌ ri Anás, ri qas kinimaꞌqil ri chꞌawenelabꞌ cho ri Dios, rachiꞌl ri Caifás, ri Juan, ri Alejandro, xuqujeꞌ e nikꞌaj rachalal ri kinimaꞌqil ri e chꞌawenelabꞌ cho ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Xubꞌeꞌ kima loq ri kebꞌ tijoxelabꞌ ri e tzꞌapal pa ri cheꞌ, kꞌa te riꞌ xkita chike: ¿Jas chuqꞌabꞌ o jas bꞌiꞌaj xikoj chubꞌanik we jastaq riꞌ? ");
INSERT INTO quctt_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ri Pedro nojinaq che ri Tyoxalaj Uxlabꞌixel xubꞌij chike: Qꞌatal taq tzij xuqujeꞌ kꞌamal taq bꞌe rech ri qatinimit, ");
INSERT INTO quctt_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","tajin kikꞌot qachiꞌ rumal cher xqabꞌan jun utza chak rukꞌ jun chꞌokeꞌr xuqujeꞌ tajin kita chaqe jas rumal xkunatajik. ");
INSERT INTO quctt_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Kawaj kinbꞌij chiꞌwe xuqujeꞌ chike konojel ri winaq aꞌj Israel, chi we achi riꞌ xkunatajik pa ri ubꞌiꞌ ri kwinel laj Jesucristo aj Nazaret, ri xiripo, ri Dios kꞌut xuwaꞌjilisaj chikixoꞌl ri kaminaqibꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Are waꞌ ri kubꞌij ri Tyoxalaj wuj: Yakal taq ja, ri abꞌaj ri xiwetzelaj, xuxik ri abꞌaj ri qas kꞌo kutayij. ");
INSERT INTO quctt_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Maj chi jun bꞌiꞌaj ri kꞌo xeꞌ ri kaj yaꞌtal chike ri winaq kakwinik kuya koltajem. ");
INSERT INTO quctt_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ri qꞌatal taq tzij xemayijanik are xkilo chi ri Pedro rachiꞌl ri Juan man xkixiꞌj ta kibꞌ chikiwach ri winaq pune etaꞌmatalik chi man kꞌo ta ketaꞌmabꞌal, xkichꞌobꞌ ri winaq chi we achyabꞌ riꞌ e xekꞌojiꞌk rukꞌ ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Man xekwin ta kꞌu ri winaq xkibꞌij jun jastaq rumal cher ri achi ri xutzirik takꞌal koq kukꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Xeꞌkesaj kꞌu loq ri Juan xuqujeꞌ ri Pedro chikixoꞌl, kꞌa te riꞌ xkita chibꞌil taq kibꞌ: ");
INSERT INTO quctt_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","¿Jas kaqabꞌan chike we achyabꞌ riꞌ? Man kuya taj kaqabꞌij chi man aꞌreꞌ taj xebꞌanow we jun kunanik riꞌ rumal cher konojel ri winaq pa Jerusalén xketaꞌmaj ri xkꞌulmatajik. ");
INSERT INTO quctt_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Rech kꞌu man kachikon ta ubꞌixik we riꞌ pa we tinimit, qabꞌij bꞌik chike chi man kakitzijoj ta chi ri ubꞌiꞌ ri Jesús che jun winaq chik. ");
INSERT INTO quctt_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Xeꞌkisikꞌij ri Pedro rachiꞌl ri Juan xkibꞌij bꞌik chike chi man kakiya ta chi kꞌutuꞌn xuqujeꞌ man kakitzijoj ta chi ri ubꞌiꞌ ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ri Pedro xuqujeꞌ ri Juan xkibꞌij: Chibꞌijmpe chaqe ¿la are kꞌu taqalik kixqanimaj ix nabꞌe cho ri Dios? ");
INSERT INTO quctt_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Man kuya taj kujtaniꞌ uj chutzijoxik ri qilom xuqujeꞌ ri qatom. ");
INSERT INTO quctt_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ri qꞌatal taq tzij xeꞌkixibꞌij bꞌik ri e taqoꞌn, kꞌa te riꞌ xeꞌkitzoqopij bꞌik rumal cher man xkiriq mak chike xuqujeꞌ rumal cher xkixiꞌj kibꞌ chikiwach ri tinimit rumal cher konojel xkiqꞌijilaꞌj ri Dios rumal ri xkꞌulmatajik. ");
INSERT INTO quctt_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","rumal cher ri achi ri chꞌokeꞌr ri xkunatajik, ikꞌowinaq chi che ri kawinaq junabꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Are xetzoqopitaj bꞌik ri Pedro rachiꞌl ri Juan, xebꞌe kukꞌ ri nikꞌaj kojonelabꞌ chik, xkitzijoj ronojel ri xbꞌix bꞌik chike kumal ri kinimaꞌqil ri chꞌawenelabꞌ cho ri Dios xuqujeꞌ konojel ri nimaq taq kꞌamal bꞌe. ");
INSERT INTO quctt_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Are xtzijotaj ronojel ri xkꞌulmatajik, xkibꞌan chꞌawem junam cho ri Dios, xkibꞌij: Nimalaj Ajawxel, lal riꞌ qas lal Dios ri xbꞌanow la ri kaj, ri ulew, ri plo xuqujeꞌ ronojel ri kꞌo cho ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ojer bꞌim la loq rumal ri Tyoxalaj Uxlabꞌixel chuchiꞌ ri qamam David ri patanil e la: ¿Jas che sibꞌalaj koyawal ri e tinimit, jas rumal kakichomaj ubꞌanik jastaq ri maj xutayij? ");
INSERT INTO quctt_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ri nimaq taq taqanelabꞌ rech ri uwachulew xkimulij kibꞌ che ubꞌanik ri chꞌoꞌj, xewaꞌjil chirij ri Ajawxel, xuqujeꞌ xewaꞌjil chirij ri Cristo. ");
INSERT INTO quctt_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","We chꞌoꞌj riꞌ xkꞌulmataj pa we tinimit rumal chi ri Herodes Antipas, ri nim qꞌatal tzij Poncio Pilato, ri winaq man utinimit ta ri Dios, xuqujeꞌ ri winaq rech Israel xewaꞌjil chirij ri Jesús, ri Cristo. ");
INSERT INTO quctt_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Etaꞌm chi kꞌu la loq ri kakꞌulmataj na. Je kꞌu riꞌ xkꞌulmatajik rumal cher jeriꞌ xaj la. ");
INSERT INTO quctt_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ajawxel, chilaꞌ la ri kakibꞌan chaqe xuqujeꞌ ya la qachuqꞌabꞌ che utzijoxik ri tzij la. ");
INSERT INTO quctt_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Xuqujeꞌ bꞌana la chi kabꞌantaj mayijabꞌal taq jastaq pa ri Tyoxalaj ubꞌiꞌ ri kꞌojol la Jesús. ");
INSERT INTO quctt_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Are xetoꞌtaj chubꞌanik ri chꞌawem, ri ja ri e kꞌo wi xbꞌiririk, xqaj kꞌu loq ri Tyoxalaj Uxlabꞌixel pa kiwiꞌ konojel ri e kꞌo chilaꞌ, man xkixiꞌj ta kꞌu kibꞌ xkitzijoj ri utzij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ri kojonelabꞌ xa jun ri kichomanik, ketaꞌm chi man xaq ta aꞌreꞌ ajchoqꞌe ri kijastaq xane kech pa junamal. ");
INSERT INTO quctt_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ri e taqoꞌn xkiqꞌalajisaj ri ukꞌastajibꞌal ri Jesús rukꞌ chuqꞌabꞌ, ri utewechiꞌbꞌal ri Dios kꞌo pa kiwiꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ri kꞌo kachoch chike xuqujeꞌ ri kꞌo kulew xkikꞌayij, man kꞌo ta kꞌu jun xajawataj jun jastaq che. ");
INSERT INTO quctt_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Xkijach ri kirajil chike ri e taqoꞌn rech aꞌreꞌ kiꞌlowik jachin ri rajawaxik tobꞌanik che. ");
INSERT INTO quctt_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Jetaq ta ne ri José ri xbꞌix Bernabé che, ri kel kubꞌij Alkꞌwaꞌlaxel taqchiꞌnel bꞌanal utzilal che kumal ri taqoꞌn waꞌ areꞌ rijaꞌl ri Leví, kel pa ri leꞌaj ri sutital rumal jaꞌ pa Chipre. ");
INSERT INTO quctt_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Xukꞌayij ri rulew kꞌa te riꞌ xuya ri pwaq chike ri e taqoꞌn. ");
INSERT INTO quctt_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Kꞌo kꞌu jun achi ubꞌiꞌ Ananías, ri rixoqil ubꞌiꞌ Safira, xkikꞌayij jun ulew. ");
INSERT INTO quctt_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Xkikꞌam bꞌik ri pwaq, xeꞌkiya chike ri e taqoꞌn, xkibꞌij chike chi are riꞌ ronojel ri pwaq ri xtoj chike. Man tzij ta kꞌut rumal cher ri Ananías rachiꞌl ri Safira xkichomaj chi kakesaj kan nikꞌaj che ri pwaq. ");
INSERT INTO quctt_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ri Pedro kꞌut xubꞌij che ri Ananías: ¿Jas che xaya bꞌe che ri Itzel kok pa ri awanimaꞌ? Xabꞌan bꞌanoj tzij che ri Tyoxalaj Uxlabꞌixel rumal xakꞌam kan nikꞌaj che ri pwaq ri xtojbꞌex rech ri ulew. ");
INSERT INTO quctt_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿La man at xbꞌan awe chukꞌayixik ri awulew? At xuqujeꞌ xbꞌan awe puꞌwiꞌ ri pwaq we kasipaj o man kasipaj taj. ¿Jas kꞌu che jewaꞌ xabꞌano? Man chaqe ta uj xabꞌan wi bꞌanoj tzij xane che ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ri Ananías are xuta we tzij riꞌ, xtzaq pa ri ulew, xkamik. Konojel ri xiꞌlowik xetowik we xkꞌulmatajik riꞌ sibꞌalaj xkixiꞌj kibꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Xepe kꞌu nikꞌaj alabꞌom, xkiwaꞌjilisaj bꞌik, xkipis bꞌik kꞌa te riꞌ xeꞌkimuqu kanoq. ");
INSERT INTO quctt_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Karaj ikꞌowinaq chi oxibꞌ hora xopan ri rixoqil, man retaꞌm ta kꞌut jas ri xkꞌulmatajik. ");
INSERT INTO quctt_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ri Pedro xuta che: ¿La are waꞌ ri pwaq ri xya chiꞌwe cho ri ulew ri xikꞌayij? Ri ixoq xubꞌij: Jeꞌ, areꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ri Pedro xubꞌij che ri ixoq: ¿Jas che xijunamaj ikꞌuꞌx chubꞌanik bꞌanoj tzij, teꞌq piꞌkꞌuꞌx chi kixkwinik kiqꞌol ri Tyoxalaj Uxlabꞌixel rech ri Ajawxel? Ri alabꞌom ri xubꞌeꞌmuquw ri awachajil e petinaq jubꞌiqꞌ kakaj koꞌk loq chiꞌ le ja, katkikꞌam xuqujeꞌ bꞌi at. ");
INSERT INTO quctt_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Aninaq xtzaq ri Safira pa ri ulew. Ri alabꞌom are xok bꞌik xkilo chi kaminaq chik, xkesaj bꞌik xeꞌkimuqu kanoq chuxukut ri xkimuq wi ri rachajil. ");
INSERT INTO quctt_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Konojel ri kojonelabꞌ xuqujeꞌ konojel ri xkita we xkꞌulmatajik riꞌ sibꞌalaj xkixiꞌj kibꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Sibꞌalaj kꞌi mayijabꞌal taq jastaq xkibꞌan ri e taqoꞌn kukꞌ ri winaq. Konojel ri kojonelabꞌ amaqꞌel xkimulij kibꞌ pa ri raqan ja rech Salomón pa ri Templo. ");
INSERT INTO quctt_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Maj chi kꞌu jun chike ri winaq karaj kok kukꞌ pune sibꞌalaj nim kiꞌlik. ");
INSERT INTO quctt_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Amaqꞌel e kꞌi achyabꞌ xuqujeꞌ ixoqibꞌ xekojonik che ri Ajawxel Jesús. ");
INSERT INTO quctt_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ri winaq are xkil ri kichak ri e taqoꞌn xeꞌkikꞌam loq ri e yawabꞌibꞌ pa taq ri kichꞌat xeꞌkiya pa ri bꞌe rech kakiriq kan ri umuꞌjal ri Pedro. ");
INSERT INTO quctt_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","E kꞌi winaq keꞌl pa taq ri komon ri e kꞌo chuxukut ri tinimit Jerusalén xeꞌkikꞌam bꞌik ri e yawabꞌibꞌ, xuqujeꞌ ri kꞌo itzel taq uxlabꞌal chike konojel kꞌut xutzir kanoq. ");
INSERT INTO quctt_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Are kꞌu ri kinimaꞌqil ri chꞌawenelabꞌ cho ri Dios, xuqujeꞌ konojel ri e rachiꞌl, ri saduceos, sibꞌalaj kꞌax xkinaꞌo. ");
INSERT INTO quctt_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Xeꞌkichap ri e taqoꞌn, xeꞌkikoj pa che. ");
INSERT INTO quctt_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Xpe kꞌu jun ángel rech ri Ajawxel chaqꞌabꞌ xujaq bꞌik ri uchiꞌ ri cheꞌ, kꞌa te riꞌ xeꞌresaj loq, xubꞌij chike: ");
INSERT INTO quctt_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Jix pa ri Templo, chitzijoj ri tzij rech kꞌaslemal chike ri winaq. ");
INSERT INTO quctt_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Are xsaqirik, ri taqoꞌn xkichapleꞌj chi ukꞌutik ri utz laj tzij jetaq ri xbꞌix chike. Are kꞌu ri kinimaꞌqil ri chꞌawenelabꞌ cho ri Dios rachiꞌl ri e rajchakibꞌ xeꞌkimulij konojel ri nimaq taq kꞌamal bꞌe rech Israel kꞌa te riꞌ xetaqan che kikꞌamik ri e taqoꞌn rech kaqꞌat tzij pa kiwiꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Are xoꞌpan ri e chajil taq rech ri Templo pa ri cheꞌ, ri achyabꞌ man e kꞌo ta chi chilaꞌ xetzalij kꞌu loq, xulkibꞌij chike ri e qꞌatal taq tzij: ");
INSERT INTO quctt_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Tzꞌapil ri uchiꞌ ri cheꞌ, ri e chajil taq rech e takꞌatoj pa taq ri kikꞌolibꞌal are xqajaq bꞌik ri uchiꞌ, man kꞌo ta chi jun kꞌo chupam. ");
INSERT INTO quctt_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ri kꞌamal bꞌe kech ri e chajil re ri Templo xuqujeꞌ ri e kinimaꞌqil taq ri e chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq xemayijanik are xkita ri xkꞌulmatajik xkita chibꞌil taq kibꞌ jas kel kubꞌij we jastaq riꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Xopan kꞌu jun winaq xuꞌbꞌij chike: Ri achyabꞌ ri xiꞌkoj pa che tajin kakiya kꞌutuꞌn chike ri winaq pa ri Templo. ");
INSERT INTO quctt_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ri kꞌamal kibꞌe ri e chajil taq rech ri Templo xuqujeꞌ ri e rachiꞌl xubꞌe kikꞌama loq ri e taqoꞌn man rukꞌ ta chꞌuꞌjal, rumal chi xkixiꞌj kibꞌ kebꞌan che abꞌaj kumal ri winaq. ");
INSERT INTO quctt_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Xeꞌkikꞌam kꞌu bꞌik chikiwach ri nimaq taq qꞌatal tzij, ri kinimaꞌqil ri chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq xubꞌij chike: ");
INSERT INTO quctt_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","¿La man xqabꞌij chiꞌwe chi man kibꞌan ta chi ri kꞌutuꞌn pa ri ubꞌiꞌ ri achi riꞌ? Xiꞌnojisaj kꞌu ri kanimaꞌ ri winaq aꞌj Jerusalén rukꞌ ri ukꞌutuꞌn xuqujeꞌ kiqꞌabꞌaj chi uj xuj kamisan ri achi riꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ri Pedro xuqujeꞌ ri e rach taq taqoꞌn xkibꞌij: Uj kaqanimaj ri Dios nabꞌe na choch xapachin qꞌatal tzij. ");
INSERT INTO quctt_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ri kiDios ri qamam xukꞌastajisaj ri Jesús, ri xirip cho ri ripbꞌal, ri xikamisaj. ");
INSERT INTO quctt_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ri Dios kꞌut xuya pa ri uwiqiqꞌabꞌ pa jun jeꞌlalaj kꞌolibꞌal xuqujeꞌ xubꞌan che nim qꞌatal tzij kolonel, je xubꞌan waꞌ rech ri winaq aꞌj Israel kakikꞌex kikꞌuꞌx. kakitas kibꞌ che ri kimak xuqujeꞌ kekuyutajik. ");
INSERT INTO quctt_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Xqil uj we jastaq riꞌ, xuqujeꞌ ri Tyoxalaj Uxlabꞌixel ri xyaꞌtaj chike konojel ri keniman che ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Are xkita ri nimaq taq qꞌatal taq tzij xeyojtajik are xkaj xeꞌkikamisaj. ");
INSERT INTO quctt_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kꞌo kꞌu jun fariseo chkixoꞌl ri e kꞌamal taq bꞌe, Gamaliel ubꞌiꞌ, retaꞌm ri pixabꞌ, nim kilik kumal ri winaq. Xtakꞌiꞌk xtaqanik kesax loq ri e taqoꞌn. ");
INSERT INTO quctt_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Kꞌa te riꞌ xubꞌij chike ri e rachiꞌl: Achyabꞌ aꞌj Israel, qas chichomaj na jas kibꞌan chike we achyabꞌ riꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Xkꞌojiꞌ jun achi ojer ubꞌiꞌ Teudas, xujaluj nim ubꞌanik, kajibꞌ ciento winaq xeteriꞌ chirij are kꞌu xkamisaxik, ri e tereneꞌl taq rech xkibꞌan jaljoj taq jastaq, maj xeꞌl wi ri kimulim ibꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Are xbꞌan ri ajilan winaq xwaꞌjil jun achi ubꞌiꞌ Judas aj Galilea, xkwinik xuꞌmenkꞌetij ri winaq rech keteriꞌ chirij are kꞌu xkamisaxik, konojel ri e tereneꞌl taq rech xsach kiwach. ");
INSERT INTO quctt_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Rumal riꞌ kinbꞌij in, chiꞌtzoqopij bꞌik ri achyabꞌ, we xaq pa ke wiꞌ kakibꞌan taq waꞌ we jastaq riꞌ, kasach kiwach laꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","We kꞌu ne rech ri Dios ri kakibꞌano, man kixkwin ta laꞌ kiꞌqꞌatej, rukꞌ ta ne jubꞌiqꞌ rukꞌ ri Dios tajin kixchꞌoꞌjin wi. ");
INSERT INTO quctt_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Konojel ri e kꞌamal taq bꞌe xkikꞌam uqꞌabꞌ ri xubꞌij ri Gamaliel. Xeꞌkisikꞌij kꞌu ri e taqoꞌn, xeꞌkirapuj. Kꞌa te riꞌ xkibꞌij bꞌik chike chi man kakitzijobꞌej ta chi ri jastaq pa ri ubꞌiꞌ ri Jesús, kꞌa te riꞌ, xeꞌkitzoqopij bꞌik. ");
INSERT INTO quctt_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Xeꞌl bꞌik ri e taqoꞌn rukꞌ kiꞌkotemal rumal cher ri Dios xuya bꞌe chike kakiriq jun kꞌixibꞌalalaj kꞌaxkꞌolal rumal ri ubꞌiꞌ ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ronojel qꞌij xkiya kꞌutuꞌn pa ri Templo xuqujeꞌ cho taq ri ja, xkitzijoj chi ri Jesús are Mesías. ");
INSERT INTO quctt_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Are xekꞌiyar ri kojonelabꞌ, ri winaq ri ketzijon pa griego kibꞌ xkibꞌij chi ri e kꞌi malkaꞌnibꞌ man junam ta tajin kabꞌan chike kukꞌ ri malkaꞌnibꞌ ri kechꞌaw pa hebreo man katzꞌaqat ta ri kiwa. ");
INSERT INTO quctt_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Rumal kꞌu riꞌ ri e kabꞌlajuj tijoxelabꞌ xeꞌkimulij konojel ri kojonelabꞌ, xkibꞌij chike: Uj, uj taqoꞌn rech ri Dios, ri qachak are utzijoxik xuqujeꞌ ukꞌutik ri utzij ri Dios, man are ta ri ujachik ri wa. ");
INSERT INTO quctt_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Qachalal, chitzukuj wuqubꞌ achyabꞌ chiꞌxoꞌl. Ri kenimax kumal ri winaq, ri kꞌo ri Uxlabꞌixel pa kanimaꞌ xuqujeꞌ kꞌo ketaꞌmabꞌal, are waꞌ kekanajik chubꞌanik we patanijik riꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Rajawaxik chi ri uj, ri uj taqoꞌn are kaqilij ubꞌanik ri chꞌawem xuqujeꞌ kaqaya ri kꞌutuꞌn rech ri utzij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Utz xkita konojel ri xbꞌix chike xeꞌkichaꞌ kꞌu ri Esteban (jun achi ri kꞌo nimalaj ukojobꞌal xuqujeꞌ nojinaq che ri Uxlabꞌixel) xuqujeꞌ ri Felipe, ri Prócoro, ri Nicanor, ri Timón, ri Parmenas xuqujeꞌ ri Nicolás aj Antioquía, (are waꞌ ri xkojonik che ri kꞌutuꞌn ke ri winaq aꞌj Israel). ");
INSERT INTO quctt_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Aꞌre waꞌ ri wuqubꞌ achyabꞌ ri xekꞌam loq chikiwach ri uꞌtaqoꞌn ri Jesús, ri taqoꞌn xkiya kiqꞌabꞌ pa kiwiꞌ ri xeꞌkichaꞌo xuqujeꞌ xkibꞌan chꞌawem. ");
INSERT INTO quctt_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Xjabꞌun kꞌu ubꞌixik ri utzij ri Dios rumal riꞌ xekꞌiyar ri e kojonelabꞌ pa Jerusalén, xuqujeꞌ xekojon e kꞌi pareyibꞌ xuqujeꞌ winaq aꞌj Israel. ");
INSERT INTO quctt_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ri Esteban nojinaq che tewechibꞌal xuqujeꞌ ukwinem ri Dios xubꞌan mayijabꞌal taq jastaq kukꞌ ri winaq. ");
INSERT INTO quctt_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Jun qꞌijal kꞌut jujun achyabꞌ aꞌj Israel ri kepe pa ri tinimit Cirene, pa Alejandría, xuqujeꞌ pa Cilicia rech Asia ri kebꞌe pa ri Sinagoga ubꞌiꞌnam patanijelabꞌ ri e tzoqopitalik. Xkichapleꞌj ukꞌululaꞌxik uwach ri utzij ri Esteban. ");
INSERT INTO quctt_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Man kꞌo ta kꞌu jun chike xuchꞌek ri etaꞌmabꞌal xuqujeꞌ ri kwinem ri kꞌo rukꞌ ri Esteban are kachꞌawik. ");
INSERT INTO quctt_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Xaq jeriꞌ xkikoj kikꞌuꞌx jujun achyabꞌ rech kakibꞌij chi xkita ri Esteban chi xubꞌij awas taq tzij che ri Moisés xuqujeꞌ che ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ri winaq are xkita we tzij riꞌ xyakataj koyawal, ri e kꞌamal taq bꞌe, xuqujeꞌ ri aꞌjtijabꞌ rech ri taqanik xkichap ri Esteban xkikꞌam bꞌik chikiwach ri qꞌatal taq tzij. ");
INSERT INTO quctt_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Xeꞌkimok winaq rech kakibꞌan bꞌanoj tzij kakibꞌij: We achi riꞌ kubꞌij awas taq tzij che ri Templo xuqujeꞌ che ri taqanik rech ri Moisés. ");
INSERT INTO quctt_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Qatom kubꞌij chi ri Jesús aj Nazaret kutukij na ri Templo xuqujeꞌ kukꞌex na ronojel ri ukꞌutum kan ri Moisés chiqawach. ");
INSERT INTO quctt_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ri qꞌatal taq tzij ko xkikaꞌyej ri Esteban rumal chi ri upalaj xuchapleꞌj chuplinem jetaq kubꞌan ri upalaj jun ángel. ");
INSERT INTO quctt_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ri kinimal ri chꞌawenelabꞌ cho ri Dios xuta che ri Esteban: ¿La qas tzij we kabꞌix chawe? ");
INSERT INTO quctt_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ri Esteban xubꞌij: Kꞌamal taq bꞌe xuqujeꞌ wachalal, chinitampeꞌ. Ri loqꞌalaj qaDios xukꞌut ribꞌ choch ri qamam Abraham pa ri tinimit Mesopotamia are majaꞌ keꞌ pa tinimit Harán. ");
INSERT INTO quctt_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ri Dios xubꞌij che: “Chaya kan ri kitinimit ri aꞌmam, xuqujeꞌ ri atat anan, jat pa ri ulew ri kinkꞌut chawach.” ");
INSERT INTO quctt_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Xel kꞌu bꞌik ri Abraham pa ri kitinimit ri Caldeos, xkꞌojiꞌ na pa tinimit Harán, xkam na kanoq ri utat kꞌa te riꞌ xkꞌam loq rumal ri Dios waral pa we tinimit ri ix kꞌo wi chanim. ");
INSERT INTO quctt_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Man xya ta kꞌu chꞌaqaꞌp rulew che rechabꞌal waral, xa ta ne nitzꞌ xa kꞌu xbꞌix che chi jun qꞌijal na ronojel we ulew riꞌ kayaꞌtaj na che ri Abraham xuqujeꞌ chike ri e rijaꞌl. ");
INSERT INTO quctt_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Xuqujeꞌ xubꞌij ri Dios che chi ri e rijaꞌl kekꞌojiꞌ na pa jun tinimit chik ri man kitinimit taj, kabꞌan na kꞌax chike, kajibꞌ ciento junabꞌ kuꞌx na e patanijelabꞌ ke nikꞌaj winaq chik, ");
INSERT INTO quctt_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","kinqꞌat kꞌu na tzij pa kiwiꞌ ri tinimit ri kabꞌanow kꞌax chike ri nutinimit, keꞌl kꞌu na loq pa ri tinimit riꞌ rech kinulkiqꞌijilaꞌj pa we kꞌolibꞌal riꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Xuqujeꞌ che ri qꞌij riꞌ ri Dios xubꞌan jun chꞌekom tzij rukꞌ ri Abraham chi rajawaxik kokisax ketal konojel ri achyabꞌ aꞌj Israel. Rumal riꞌ are xkꞌojiꞌ ri ukꞌojol ri Abraham, ri Isaac, wajxaqibꞌ qꞌij chik alaxinaq, are xokisax retal, je xuqujeꞌ xubꞌan ri Isaac che ri ukꞌojol Jacob, xuqujeꞌ je xubꞌan ri Jacob chike konojel ri e ralkꞌwaꞌl aꞌre waꞌ ri e kitat ri e kabꞌlajuj wok winaq rech ri tinimit Israel. ");
INSERT INTO quctt_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ri kabꞌlajuj wok winaq rech Israel rumal ri koyawal xkikꞌayij bꞌik jun chike ri qamam ubꞌiꞌnam José, jun chike ri wok winaq, kꞌax xkinaꞌ che ri kachalal rumal riꞌ xkikꞌayij bꞌik rech kux jun taqoꞌn pa Egipto, pune jeriꞌ ri Dios xkꞌojiꞌ rukꞌ ri José. ");
INSERT INTO quctt_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Xutoꞌ pa ronojel ri kꞌaxkꞌolal ri xuriqo. Xuya unoꞌj, xuya nimalaj retaꞌmabꞌal rumal riꞌ, ri Faraón nim taqanel pa Egipto xukoj ri José che qꞌatal tzij puꞌwiꞌ ronojel Egipto, xuqujeꞌ xukoj che taqanel pa ri rachoch. ");
INSERT INTO quctt_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Xpe kꞌu wiꞌjal pa Egipto xuqujeꞌ pa Canaán, ri xukꞌam loq nimalaj kꞌax, xkinaꞌ kꞌu numik ri e qamam. ");
INSERT INTO quctt_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ri Jacob are xuto chi kꞌa kꞌo tiriko pa Egipto xuꞌtaq bꞌik ri uꞌkꞌojol je laꞌ (ri e qamam) rech xeꞌkiloqꞌo loq jubꞌiqꞌ ke. ");
INSERT INTO quctt_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Are xebꞌe chukamul, ri José xuqꞌalajisaj ribꞌ chikiwach ri e rachalal, xuqujeꞌ xuꞌkꞌut cho ri Faraón. ");
INSERT INTO quctt_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Xtaqan kꞌu ri José chukꞌamik ri utat Jacob, xuqujeꞌ konojel ri e rachalal. E oxkꞌal olajuj winaq chkonojel. ");
INSERT INTO quctt_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Xaq jeriꞌ xeꞌ ri Jacob pa Egipto. Chilaꞌ xkam wi, chilaꞌ xuqujeꞌ xekam wi konojel ri e qamam. ");
INSERT INTO quctt_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ri kibꞌaqil xmuq kan pa Siquem, pa ri ulew ri uloqꞌom kan ri Abraham chike ri e ralkꞌwaꞌl ri Hamor. ");
INSERT INTO quctt_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Are jubꞌiqꞌ karaj kuriq ri qꞌotaj rech kakꞌulmataj ri uchiꞌm loq ri Dios rukꞌ ri Abraham, xekꞌiyar ri qawinaq je laꞌ pa Egipto. ");
INSERT INTO quctt_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Xok kꞌu jun kꞌakꞌ taqanel pa Egipto ri man xretaꞌmaj ta uwach ri José. ");
INSERT INTO quctt_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","We taqanel riꞌ xubꞌan kꞌax chike ri qawinaq, xuꞌtaqchiꞌj chikitzaqik kan ri nitzꞌ taq kalkꞌwaꞌl rech kekamik. ");
INSERT INTO quctt_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Che taq ri qꞌij riꞌ xalax jun akꞌal ubꞌiꞌ Moisés, jun jeꞌlalaj akꞌal cho ri Dios. Oxibꞌ ikꞌ xkichajij ri utat unan cho ri kachoch. ");
INSERT INTO quctt_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Are xkiya bꞌi we akꞌal riꞌ pa kamikal, ri umiꞌal ri Faraón xuriq ri akꞌal xukꞌiyisaj, xrilo, jer xubꞌan ral che. ");
INSERT INTO quctt_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Xtijox kꞌu ri Moisés rech karetaꞌmaj ronojel ri etaꞌmabꞌal kech ri aꞌj Egipto, xuxik jun kwinel laj achi pa ri uchꞌawem xuqujeꞌ pa ronojel ri xubꞌano. ");
INSERT INTO quctt_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Kawinaq ujunabꞌ ri Moisés are xpe pa ranimaꞌ, xubꞌuꞌsolij ri e rachalal ri tinimit Israel. ");
INSERT INTO quctt_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Are xril ri jun aj Egipto chi tajin kubꞌan kꞌax che jun aj Israel xutoꞌo, xukamisaj ri aj Egipto rumal ri kꞌax ri xubꞌan che ri aj Israel. ");
INSERT INTO quctt_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Puꞌkꞌuꞌx ri Moisés chi ri e rach taq aꞌj Israel kakichomaj chi are ri Dios taqowinaq bꞌik che kikolik. Man xkichomaj ta kꞌut. ");
INSERT INTO quctt_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Chukabꞌ qꞌij xeꞌril ri Moisés kebꞌ aꞌj Israel tajin kechꞌoꞌjinik, are xraj xuꞌjacho, xubꞌij chike: “¿Jas che kixchꞌoꞌjinik iwachalal iwibꞌ?” ");
INSERT INTO quctt_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Are kꞌu ri tajin kubꞌan kꞌax che ri rachiꞌl, xupaqchiꞌj bꞌik ri Moisés je laꞌ, xubꞌij che: “¿Jas awe che? ¿Jachin xat kojow che taqanel o che qꞌatal tzij pa qawiꞌ? ");
INSERT INTO quctt_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Teꞌq are kawaj kinakamisaj jetaq ri xabꞌan che ri jun aj Egipto?” ");
INSERT INTO quctt_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Are xuta ri Moisés we riꞌ xanimaj bꞌik, xeꞌ pa ri tinimit Madián. Xkꞌojiꞌ chkixoꞌl ri winaq ri man uꞌwinaqil taj. Chilaꞌ xaꞌlax wi e kebꞌ chike ri ukꞌojol. ");
INSERT INTO quctt_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Are ikꞌowinaq chi kawinaq junabꞌ, jun ángel xukꞌut ribꞌ cho ri Moisés pa nikꞌaj kꞌix kajinow pa qꞌaqꞌ pa ri katzꞌinow ulew chuxukut ri juyubꞌ Sinaí. ");
INSERT INTO quctt_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ri Moisés sibꞌalaj xuxiꞌj ribꞌ are xril we jastaq riꞌ, xqet rukꞌ rech qas karil ri tajin kakꞌulmatajik. Xpe kꞌu ri uchꞌabꞌal ri Dios, xubꞌij che: ");
INSERT INTO quctt_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“In riꞌ ri in kiDios ri amam ojer, ri uDios ri Abraham, ri Isaac, xuqujeꞌ ri Jacob”. Ri Moisés are xuta we riꞌ, xuchapleꞌj bꞌiribꞌatem man xukochꞌ ta chik xkaꞌyik. ");
INSERT INTO quctt_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ri Dios kꞌut xubꞌij che: Chawesaj ri axajabꞌ, rumal chi at kꞌo chinuwach. ");
INSERT INTO quctt_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Qas tzij wilom chi ri nutinimit Israel kuriq kꞌax rumal chi ri aꞌj Egipto e kibꞌanom kajchakibꞌ chike xuqujeꞌ nutom ri kichꞌawem kakita tobꞌanik chwe. Rumal waꞌ in petinaq che kitzoqopixik. Xaq jeriꞌ katintaq bꞌik pa ri tinimit Egipto. ");
INSERT INTO quctt_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Xaq jeriꞌ ri Dios xutaq bꞌik ri achi ri xketzelaj uwach nabꞌe mul, are xkibꞌij che: ¿Jachin xat kojow che taqanel o che qꞌatal tzij pa qawiꞌ? Xa kꞌu are ri Dios xubꞌan taqanel xuqujeꞌ kꞌamal bꞌe che ri Moisés, rech ri utinimit Israel. Are waꞌ ri xubꞌij ri ángel che, are xukꞌut ribꞌ choch pa ri kꞌix. ");
INSERT INTO quctt_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ri Moisés xresaj loq ri tinimit Israel pa Egipto rukꞌ kꞌutbꞌal xuqujeꞌ mayijabꞌal taq jastaq. Xukꞌam kibꞌe pa ri plo xuqujeꞌ xukꞌam kibꞌe kawinaq junabꞌ pa ri katzꞌinow ulew. ");
INSERT INTO quctt_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ri Moisés xubꞌij chike ri winaq aꞌj Israel: Ri Dios kuchaꞌ na jun chike ri qawinaq, rech kuqꞌalajisaj ri utzij ri Dios jetaq ri kinbꞌan in. ");
INSERT INTO quctt_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Xuqujeꞌ xkꞌojiꞌ kukꞌ ri qamam pa ri katzꞌinow ulew xubꞌij chike ronojel ri tzij rech kꞌaslemal ri xubꞌij ri ángel che pa ri juyubꞌ Sinaí. ");
INSERT INTO quctt_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Are kꞌu ri aꞌj Israel man xeniman taj. Man xkaj taj xkinimaj ri Moisés, are xkaj ketzalij kan pa Egipto. ");
INSERT INTO quctt_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Jun qꞌijal kꞌut xkibꞌij ri aꞌj Israel che ri Aarón, rachalal ri Moisés: Ri Moisés xujresaj loq pa ri tinimit Egipto, man qetaꞌm ta kꞌut jas xkꞌulmataj rukꞌ, are katanik chabꞌana jun qadios rech kukꞌam qabꞌe xuqujeꞌ kujuchajij. ");
INSERT INTO quctt_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Xkibꞌan kꞌu jun wakax che kidios, kꞌa te riꞌ xkiqꞌijilaꞌj xuqujeꞌ xkiporoj jastaq choch xuqujeꞌ xeꞌkiꞌkot che ri xkibꞌano. ");
INSERT INTO quctt_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Rumal riꞌ, ri Dios xutas ribꞌ chike, rumal cher xkichapleꞌj uqꞌijilaꞌxik ri chꞌumil ri e kꞌo cho ri kaj. Ri Dios xubꞌij pa ri kiwuj ri e qꞌalajisal taq utzij ri Dios. Tinimit rech Israel ¿la chwe in xiya wi sipanik xuqujeꞌ la xitzuj aꞌwaj chinuwach ronojel ri kawinaq junabꞌ ri xixkꞌojiꞌ pa ri katzꞌinow ulew? ");
INSERT INTO quctt_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Xa kꞌu xitelelaꞌ ri rachoch ri idios Moloc, xuqujeꞌ ri idios Refán ix xixbꞌanow ri tzꞌaq kꞌa te riꞌ xiꞌqꞌijilaꞌj. Rumal riꞌ kinbꞌan chiꞌwe chi kixkꞌam na bꞌik naj che ri kꞌo wi ri tinimit Babilonia. ");
INSERT INTO quctt_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ri qamam ojer xkukꞌaꞌj ri Tabernáculo rech ri chꞌekom tzij pa taq ri ulew ri katzꞌinowik. Je xbꞌan chuyakik jetaq ri xbꞌix che ri Moisés rumal ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ri Tabernáculo xkikꞌamawaꞌj ri qatat qanan xkikoj rukꞌ ri Josué are xkechabꞌej ri nikꞌaj tinimit chik ri xjach chike rumal ri Dios kꞌa pa taq ri qꞌij rech ri David. ");
INSERT INTO quctt_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ri David sibꞌalaj xqaj cho ri Dios, rumal riꞌ xubꞌij che ri Dios chi karaj kuyak jun Templo rech ri uDios ri Jacob. ");
INSERT INTO quctt_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Are ri Salomón ri ukꞌojol xyakow we ja riꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ri kwinelalaj Dios kꞌut man kakꞌojiꞌ ta kꞌu pa taq ri ja bꞌanom kumal achyabꞌ, are waꞌ ri xubꞌij chuchiꞌ jun qꞌalajisal utzij: ");
INSERT INTO quctt_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ri kaj are nutꞌuyulibꞌal, ri ulew are nutakꞌalibꞌal. Maj jun kakwinik kuyak jun Templo jawjeꞌ kinuxlan wi. ");
INSERT INTO quctt_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","In xintikow ri kaj ulew. ");
INSERT INTO quctt_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ri Esteban are jubꞌiqꞌ karaj katoꞌtaj che tzijonem xubꞌij chike ri qꞌatal taq tzij: Ix sibꞌalaj ix kon, man kichꞌobꞌ taj ri utzij ri Dios, xaq ix junam kukꞌ ri imam, amaqꞌel man inimam taj ri Uxlabꞌixel. ");
INSERT INTO quctt_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Aꞌreꞌ xkibꞌan kꞌax chike ri e qꞌalajisal taq utzij ri Dios, xuqujeꞌ ri ix xiꞌkamisaj ri xkitzijoj ri upetibꞌal ri sukꞌ achi, ri Mesías, ri xikꞌayij xuqujeꞌ xikamisaj. ");
INSERT INTO quctt_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Man xinimaj ta ri utaqanik ri Dios ri xikꞌamawaꞌj chike ri angelibꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Are xkita ri qꞌatal taq tzij ri xubꞌij ri Esteban, xeyojtajik xuqujeꞌ xkiqutꞌutꞌej ri kiware. ");
INSERT INTO quctt_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ri Esteban nojinaq rukꞌ ri ukwinem ri Uxlabꞌixel xkaꞌy chikaj, xril ri Dios rukꞌ ronojel ri ujuluwem xuqujeꞌ ri Jesús takꞌal pa ri uwiqiqꞌabꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Xubꞌij: Kinwil le kaj jaqalik, kinwil xuqujeꞌ le Jesús, uKꞌojol ri Achi, takꞌal pa ri jun jeꞌl laj kꞌolibꞌal pa ri uwiqiqꞌabꞌ ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ri e qꞌatal taq tzij xkitzꞌapij ri kixikin, ko xkiraqaqej kichiꞌ, kꞌa te riꞌ konojel xebꞌe chirij ri Esteban. ");
INSERT INTO quctt_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Xkesaj bꞌik pa ri tinimit, xkibꞌan che abꞌaj. Ri achyabꞌ ri xkibꞌan tzij chirij ri Esteban xkiya kan ri katzꞌyaq rech kachajix rumal jun ala ubꞌiꞌ Saulo. ");
INSERT INTO quctt_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Are tajin kakꞌyaq che abꞌaj ri Esteban, xubꞌan chꞌawem, xubꞌij: Ajawxel Jesús, kꞌama la ri wanimaꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kꞌa te riꞌ xukulik xtzaqik ko xuraq uchiꞌ xubꞌij: Ajawxel, man kaqꞌat ta la tzij pa kiwiꞌ we winaq riꞌ rumal we mak tajin kakibꞌano. Are tajin kubꞌij we tzij riꞌ, xkamik. ");
INSERT INTO quctt_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ri Saulo utz xrilo chi xkamisax ri Esteban, xqaj choch ri xbꞌanik. Che ri qꞌij riꞌ xchapleꞌtaj ubꞌanik kꞌax chike ri kojonelabꞌ pa ri tinimit Jerusalén. Konojel ri kojonelabꞌ xejabꞌun bꞌik pa ri tinimit Judea xuqujeꞌ pa Samaria. Xwi ri uꞌtijoxelabꞌ ri Jesús xekanaj kanoq pa Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","(E kꞌo kꞌu jujun utz laj taq winaq xkoqꞌej ri Esteban, kꞌa te riꞌ xeꞌkimuqu kanoq). ");
INSERT INTO quctt_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Are kꞌu ri Saulo xuchapleꞌj ubꞌanik kꞌax chike ri e kojonelabꞌ. Xok cho taq ri ja, xuꞌkꞌam bꞌik achyabꞌ, ixoqibꞌ, xuꞌkoj pa cheꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Are kꞌu ri kojonelabꞌ ri xejabꞌun bꞌik pa taq ri tinimit, xkitzijoj ri utz laj tzij rech ri Jesús xapawjeꞌ ri xebꞌe wi. ");
INSERT INTO quctt_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ri Felipe xeꞌ pa ri tinimit Samaria, chilaꞌ xutzijoj wi ri Mesías chike ri winaq. ");
INSERT INTO quctt_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ri winaq xkimulij kibꞌ, xkitatabꞌej ri tzij ri xubꞌij ri Felipe rumal cher kekꞌarkꞌat che utayik ri utz laj tzij xuqujeꞌ kakil ri mayijabꞌal taq jastaq ri kubꞌano. ");
INSERT INTO quctt_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Xeꞌsax e kꞌi itzel taq uxlabꞌal chike ri winaq, e kꞌi chꞌokeꞌr xuqujeꞌ ri kaminaq kibꞌaqil, xuꞌtzirik. ");
INSERT INTO quctt_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Sibꞌalaj xekiꞌkot ri winaq ri keꞌl pa ri tinimit. ");
INSERT INTO quctt_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kꞌo kꞌu jun achi ubꞌiꞌ Simón, jun najtir aj itz kubꞌan mayijabꞌal taq jastaq chikiwach ri winaq rech Samaria, kubꞌij chi sibꞌalaj nim reqeleꞌn. ");
INSERT INTO quctt_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Konojel ri winaq ta kꞌu akꞌalabꞌ ta kꞌu riꞌjabꞌ kakibꞌij chi we achi riꞌ: Nim uqꞌij xuqujeꞌ kꞌo ukwinem ri Dios rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ojer chik katatabꞌex kumal ri winaq rumal che ri ubꞌanom mayijabꞌal taq jastaq rukꞌ ri itzinik. ");
INSERT INTO quctt_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ri winaq xekojon che ri utz laj tzij rech ri Dios xuqujeꞌ ri ubꞌiꞌ ri Jesucristo e kꞌi achyabꞌ xuqujeꞌ ixoqibꞌ xbꞌan kiqasanaꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Xkojon xuqujeꞌ ri Simón, xbꞌan uqasanaꞌ, kꞌa te riꞌ xteriꞌ chirij ri Felipe xapawjeꞌ ri xeꞌ wi, kamayijan che taq ri kꞌutbꞌal xuqujeꞌ che ri mayijabꞌal taq jastaq ri xubꞌan ri Felipe. ");
INSERT INTO quctt_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ri utijoxelabꞌ ri Jesús ri e kꞌo pa tinimit Jerusalén are xkito chi ri winaq ri e kꞌo pa ri tinimit Samaria xekojon che ri utzij ri Dios, xeꞌkitaq bꞌik ri Pedro rachiꞌl ri Juan je laꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Are xoꞌpan ri Juan rachiꞌl ri Pedro, xkibaꞌn chꞌawem pa kiwiꞌ ri kꞌakꞌ taq kojonelabꞌ rech kakikꞌamawaꞌj ri Uxlabꞌixel. ");
INSERT INTO quctt_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Rumal cher majaꞌ kakikꞌamawaꞌj ri Uxlabꞌixel xwi bꞌantal kiqasanaꞌ pa ri ubꞌiꞌ ri Ajawxel Jesús. ");
INSERT INTO quctt_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ri Pedro kꞌut xuqujeꞌ ri Juan xkiya ri kiqꞌabꞌ pa kiwiꞌ ri kojonelabꞌ, rech xa jeriꞌ xkikꞌamawaꞌj ri Tyoxalaj Uxlabꞌixel. ");
INSERT INTO quctt_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ri Simón are xrilo chi rukꞌ ri kakiya ri kiqꞌabꞌ ri taqoꞌn pa kiwiꞌ ri kojonelabꞌ kakikꞌamawaꞌj ri Tyoxalaj Uxlabꞌixel xutzuj pwaq chike ri tijoxelabꞌ rech kuloqꞌ rech we kwinem riꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Jewaꞌ xubꞌij: Chiya we ri chuqꞌabꞌ ri kꞌo iwukꞌ, rech are kinya xuqujeꞌ nuqꞌabꞌ in pa kiwiꞌ ri winaq kakikꞌamawaꞌj ri Tyoxalaj Uxlabꞌixel. ");
INSERT INTO quctt_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ri Pedro xubꞌij che: Sach uwach ri arajil xuqujeꞌ sach awach at, rumal cher xachomaj chi ri usipanik ri Dios rukꞌ pwaq kaloqꞌik. ");
INSERT INTO quctt_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Man kꞌo ta awe che we sipanik riꞌ, rumal chi ri awanimaꞌ man sukꞌ ta cho ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Chakꞌexa akꞌuꞌx che ri awetzelal, chabꞌana chꞌawem cho ri Ajawxel, wine kukuy ri itzel taq achomanik. ");
INSERT INTO quctt_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kinwilo chi kꞌo jun nimalaj etzelal pa ri awanimaꞌ xuqujeꞌ ri mak at ujatꞌim. ");
INSERT INTO quctt_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ri Simón xubꞌij: Chibꞌana bꞌa chꞌawem pa nuwiꞌ rech man kakꞌulmataj ta wukꞌ we kꞌax taq jastaq ri xibꞌij. ");
INSERT INTO quctt_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Are xetoꞌtaj ri Juan rachiꞌl ri Pedro che utzijoxik ri utzij ri Dios pa Samaria, xetzalij pa Jerusalén. Xikꞌow bꞌik pa ri leꞌaj rech Samaria, xkitzijoj kan ri utz laj tzij. ");
INSERT INTO quctt_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Jun ángel xuchꞌabꞌej ri Felipe, xubꞌij che: Jat pa ri relibꞌal qꞌij pa ri bꞌe ri keꞌ pa ri katzꞌinow ulew rech Jerusalén ri keꞌ pa Gaza. ");
INSERT INTO quctt_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Xunimaj kꞌu ri Felipe ri xbꞌix che, xeꞌ je laꞌ. Pa ri bꞌe xuriq ri yakal pwaq rech Etiopía, upetik pa qꞌijilaꞌnem pa ri tinimit Jerusalén jun achi eunuco ri sibꞌalaj nim ubꞌanik, chajil rech ronojel ri ujastaq ri Chuchuꞌ Candace nim taqanel pa Etiopía. ");
INSERT INTO quctt_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Tzalijem loq rech tꞌuyul pa ri eqomal, tajin kusikꞌij ri wuj rech ri qꞌalajisal utzij ri Dios Isaías. ");
INSERT INTO quctt_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ri Uxlabꞌixel xubꞌij che ri Felipe: Chatqebꞌ rukꞌ we jun eqomal riꞌ, chatbꞌin chuxukut. ");
INSERT INTO quctt_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Kaxikꞌan ri Felipe, xqet chuxukut ri eqomal, xuto chi ri achi ri kꞌo chupam tajin kusikꞌij ri wuj rech Isaías, xuta che: ¿La kachꞌobꞌ ri tajin kasikꞌij? ");
INSERT INTO quctt_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ri eunuco xubꞌij che: ¿Jas che kinchꞌobꞌo? Man kꞌo ta jun kintoꞌw chuchꞌobꞌik. Are xbꞌiꞌtaj we riꞌ rumal ri achi ri man kakꞌuliꞌ taj, xubꞌij che ri Felipe chi katꞌuyiꞌ bꞌik rukꞌ pa ri eqomal. ");
INSERT INTO quctt_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Jewaꞌ kubꞌij ri tajin kusikꞌij ri achi: Xkꞌam bꞌik pa kamisaxik jetaq kabꞌan che jun laj chij. Xa ta ne jun tzij xubꞌij, je xubꞌano jacha kubꞌan ri alaj chij are kakꞌam bꞌik pa pilik. ");
INSERT INTO quctt_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Man xya ta uqꞌij, man xbꞌan ta ri qas usukꞌ che. Maj xa ta ne jun rijaꞌl xkꞌojiꞌk jeriꞌ rumal cher xesax ri ukꞌaslemal cho ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Kꞌa te riꞌ, ri eunuco xuta che ri Felipe: “Chabꞌij chwe ¿jachin tajin kutzijoj rij chi riꞌ la are ri qꞌalajisal tzij o jun winaq chik?” ");
INSERT INTO quctt_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ri Felipe xuchapleꞌj utzijoxik che ri achi ri utz laj tzij rech ri Jesús, xuchapleꞌj rukꞌ ri tajin kusikꞌij. ");
INSERT INTO quctt_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Junam e bꞌenaq are xoꞌpan pa jun kꞌolibꞌal jawjeꞌ kꞌo wi jaꞌ, ri achi xubꞌij che ri Felipe: Chawilampeꞌ, kꞌo jaꞌ chi riꞌ. ¿La utz kabꞌan nuqasanaꞌ? ");
INSERT INTO quctt_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ri Felipe xubꞌij: We qas tzij katkojon che ri Jesús, utz kabꞌan aqasanaꞌ. Ri eunuco xubꞌij: Kinkojo rukꞌ ronojel wanimaꞌ chi ri Jesús are ukꞌojol ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ri achi xtaqan chutakꞌabꞌaxik ri eqomal, xeqaj pa ri jaꞌ, xbꞌan uqasanaꞌ rumal ri Felipe. ");
INSERT INTO quctt_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Are xeꞌl loq pa ri jaꞌ, ri Uxlabꞌixel rech ri Dios xukꞌam bꞌik ri Felipe. Man xil ta chi uwach rumal ri achi. Ri achi ri man kakꞌuliꞌ taj xutaqej ri ubꞌe rukꞌ nimalaj kiꞌkotemal. ");
INSERT INTO quctt_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Xaq kꞌa teꞌ ri Felipe xopan pa ri tinimit Azoto jawjeꞌ xutzijoj wi ri utzij ri Dios, xutzijoj xuqujeꞌ ri utz laj tzij pa taq ri tinimit ri xikꞌow wi bꞌik xopan pa ri tinimit Cesarea. ");
INSERT INTO quctt_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ri Saulo sibꞌalaj kꞌaꞌnarinaq kurayij kikamisaxik ri e tereneꞌl taq rech ri Ajawxel, rumal riꞌ xeꞌ rukꞌ ri kinimaꞌqil ri chꞌawenelabꞌ cho ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Xutoqꞌij chi kataq bꞌik wuj pa ri Sinagoga ri kꞌo pa ri tinimit Damasco, rech ketaqan che kichapik ri kojonelabꞌ che ri Jesús. Xuqujeꞌ rech we kuꞌriq achyabꞌ xuqujeꞌ ixoqibꞌ ri e kojonelabꞌ kuꞌkꞌam bꞌik pa cheꞌ je laꞌ pa Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ri Saulo are xopan chunaqaj ri tinimit Damasco rech kubꞌana ri rajawam ukꞌuꞌx xaq kꞌa teꞌ xril jun nimalaj tunal ri xpe cho ri kaj, xusutij rij. ");
INSERT INTO quctt_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ri Saulo xtzaq pa ri ulew, xuta jun chꞌabꞌal, xubꞌij che: Saulo, Saulo, ¿jas che tajin kabꞌan kꞌax chwe? ");
INSERT INTO quctt_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ri Saulo xubꞌij: ¿Jachin ri lal, Tat? Ri Jesús xubꞌij: In, in Jesús ri tajin kabꞌan kꞌax chwe. ");
INSERT INTO quctt_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Chatwaꞌjiloq, jat pa ri tinimit. Chilaꞌ kabꞌix wi chawe jas rajawaxik kabꞌano, xuchixik. ");
INSERT INTO quctt_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ri achyabꞌ ri e bꞌenaq rukꞌ ri Saulo man kakiriq ta chik jas kakibꞌij rumal chi man kakil ta uwach ri tajin kachꞌawik xaq xwi kakita ri chꞌabꞌal. ");
INSERT INTO quctt_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Are xwaꞌjil ri Saulo, xraj xkaꞌyik man xkwin ta chi kꞌut, rumal cher xmoyirik. Xaq xtzuyex chi bꞌik che ri uqꞌabꞌ kumal ri rachiꞌl xebꞌe pa ri tinimit Damasco. ");
INSERT INTO quctt_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Oxibꞌ qꞌij xkanaj chilaꞌ, moy. Maj wa maj jaꞌ xutijo. ");
INSERT INTO quctt_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Kꞌo kꞌu jun kojonel pa ri tinimit Damasco ubꞌiꞌ Ananías. Xchꞌabꞌex rumal ri Dios: ¡Ananías! xuchixik. Ri Ananías xubꞌij: In kꞌolik riꞌ Ajawxel. ");
INSERT INTO quctt_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ri Ajawxel xubꞌij che: Jat pa ri bꞌe ri kabꞌix wiqiqꞌabꞌ che, pa ri rachoch ri Judas, are katopanik chataꞌ jawjeꞌ kꞌo wi ri jun achi ri kape pa ri tinimit Tarso, ubꞌiꞌnam Saulo, chanim tajin kubꞌan chꞌawem. ");
INSERT INTO quctt_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Xinkꞌut choch chi kꞌo jun achi ubꞌiꞌ Ananías, kopan jawjeꞌ ri kꞌo wi, kuya uqꞌabꞌ puꞌwiꞌ rech katzalitaj ri ukaꞌyibꞌal. ");
INSERT INTO quctt_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ri Ananías xubꞌij: Ajawxel, e nutom sibꞌalaj kꞌi winaq kakitzijoj ri itzel taq jastaq ri ubꞌanom ri achi riꞌ chike ri kojonelabꞌ ri e kꞌo pa ri tinimit Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Xuqujeꞌ yaꞌtal bꞌe che kumal ri kinimaꞌqil ri e chꞌawenelabꞌ cho ri Dios rech kuꞌchap konojel ri kakinaꞌtaj ri bꞌiꞌ la. ");
INSERT INTO quctt_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ri Ajawxel xubꞌij che ri Ananías: ¡Jat! waꞌ we achi riꞌ kinkoj na chutzijoxik ri nutzij chike ri winaq ri man aꞌj Israel taj, xuqujeꞌ kutzijoj na ri nutzij chike ri taqanelabꞌ xuqujeꞌ chike ri tinimit Israel. ");
INSERT INTO quctt_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Kinkꞌut na choch jas jeꞌ uriqik kꞌax rumal ri nubꞌiꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Xeꞌ kꞌu ri Ananías jawjeꞌ kꞌo wi ri Saulo, xuya ri uqꞌabꞌ puꞌwiꞌ xubꞌij che: Wachalal Saulo, ri Ajawxel Jesús ri xukꞌut ribꞌ chawach pa ri bꞌe xinutaq loq rech katkwinik katkaꞌyik, xuqujeꞌ rech katnoj che ri Tyoxalaj Uxlabꞌixel. ");
INSERT INTO quctt_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Aninaq xel nikꞌaj slot che ri ubꞌoqꞌoch ri Saulo, xkaꞌyik xuqujeꞌ xwaꞌjilik kꞌa te riꞌ xbꞌan uqasanaꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kꞌa te riꞌ xwaꞌik jeriꞌ xtzalij ri uchuqꞌabꞌ. Xkanaj kꞌu kan kebꞌ oxibꞌ qꞌij pa ri tinimit Damasco. ");
INSERT INTO quctt_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ri Saulo xuchapleꞌj utzijoxik ri Jesús pa taq ri Sinagoga, xubꞌij: Qas tzij ri Jesús, are ukꞌojol ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Konojel ri xkita ri tzij sibꞌalaj xemayijanik xkibꞌij: ¿La man kꞌu are waꞌ ri achi ri xukoj chꞌoꞌj chikixoꞌl ri kojonelabꞌ pa ri tinimit Jerusalén? ¿La man kꞌu are waꞌ ri kuꞌyut bꞌik ri kojonelabꞌ kuꞌkꞌam bꞌik chikiwach ri kinimaꞌqil ri chꞌawenelabꞌ? ");
INSERT INTO quctt_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Qꞌij chi qꞌij ri Saulo xkꞌiy uchuqꞌabꞌ chutzijoxik ri utz laj tzij chike ri aꞌj Israel ri e kꞌo pa Damasco, xa jeriꞌ xkiqꞌalajisaj chi ri Jesús are Mesías. ");
INSERT INTO quctt_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ikꞌowinaq chi sibꞌalaj kꞌi qꞌij ri winaq aꞌj Israel xkichomaj ukamisaxik ri Saulo. ");
INSERT INTO quctt_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Chi chaqꞌabꞌ chi paqꞌij xkichajij ri uchiꞌ ja rech ri tinimit rech jeriꞌ kakikamisaj, xbꞌix kꞌu che ri Saulo ri kichomanik ri winaq. ");
INSERT INTO quctt_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Jun chaqꞌabꞌ kꞌut nikꞌaj kojonelabꞌ xkiqasaj bꞌi ri Saulo pa jun chakach pa jun teqꞌ rech ri tapya rech ri tinimit. ");
INSERT INTO quctt_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Are xopan ri Saulo pa ri tinimit Jerusalén, xraj xkꞌojiꞌ kukꞌ ri kojonelabꞌ. Ri kojonelabꞌ xkixiꞌj kibꞌ che, man xkikoj taj chi qas kojonel chik. ");
INSERT INTO quctt_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Xpe kꞌu ri Bernabé, xukꞌam bꞌik ri Saulo chkiwach ri e taqoꞌn xutzijoj chike chi ri Saulo xril ri Jesús pa ri bꞌe ri keꞌ pa ri tinimit Damasco xuqujeꞌ xchꞌabꞌex rumal. Xubꞌij xuqujeꞌ chike chi ri Saulo rukꞌ chuqꞌabꞌ xutzijoj ri ubꞌiꞌ ri Jesús je laꞌ pa ri tinimit Damasco. ");
INSERT INTO quctt_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Xaq jeriꞌ xkanaj kan ri Saulo kukꞌ ri e taqoꞌn rukꞌ chuqꞌabꞌ xkitzijoj ri utzij ri Ajawxel pa ri tinimit Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ri Saulo xtzijon kukꞌ nikꞌaj winaq aꞌj Israel, we winaq ri ketzijon pa ri tzijobꞌal griego, are xkita ri xubꞌij chike xkaj xkikamisaj. ");
INSERT INTO quctt_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Are xkita ri kojonelabꞌ ri xkꞌulmatajik, xkikꞌam bꞌik ri Saulo pa tinimit Cesarea, kꞌa te riꞌ xkitaq bꞌik pa ri utinimit je laꞌ Tarso. ");
INSERT INTO quctt_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ri komontyox xkꞌiyik xuqujeꞌ xuriq jaꞌmaril pa ronojel Judea, pa Galilea xuqujeꞌ pa Samaria. Ri kojonelabꞌ xkimochꞌ kibꞌ xeꞌ raqan uqꞌabꞌ ri Ajawxel xyaꞌtaj kichuqꞌabꞌ pa ri kikojobꞌal rukꞌ ri utobꞌanik ri Tyoxalaj Uxlabꞌixel. ");
INSERT INTO quctt_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Are kꞌu ri Pedro are tajin kuꞌsolij sibꞌalaj kꞌi leꞌaj xeꞌ chikisolixik ri e kojonelabꞌ ri e kꞌo pa ri tinimit Lida. ");
INSERT INTO quctt_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Chilaꞌ xuriq wi jun achi ubꞌiꞌ Eneas, we achi riꞌ wajxaqibꞌ junabꞌ chik qꞌoyol pa ri uchꞌat, kaminaq ri ubꞌaqil. ");
INSERT INTO quctt_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ri Pedro xubꞌij che: Eneas, chatwaꞌjiloq. Ri Jesucristo katukunaj, chayaka bꞌik ri achꞌat. Are xbꞌiꞌtaj we riꞌ che, aninaq xutzirik. ");
INSERT INTO quctt_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ri winaq ri e kꞌo pa ri tinimit Lida, xuqujeꞌ ri e kꞌo pa ri tinimit Sarón, are xkilo chi ri Eneas xbꞌinik xekojon che ri Ajawxel. ");
INSERT INTO quctt_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Kꞌo kꞌu jun ixoq kojonel pa ri tinimit Jope ubꞌiꞌ Tabita, (pa ri chꞌabꞌal griego kel kubꞌij Dorcas). We chuchuꞌ riꞌ amaqꞌel kubꞌan utz laj taq jastaq xuqujeꞌ kuꞌtoꞌ ri e mebꞌaibꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Xyawaj kꞌu che taq ri qꞌij riꞌ kꞌa te riꞌ xkamik. Xchꞌaj kꞌu ri utyoꞌjal xya pa uwiq jun ja. ");
INSERT INTO quctt_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ri kojonelabꞌ are xkito chi ri Pedro naqaj kꞌo wi chike xeꞌkitaq bꞌik kebꞌ achyabꞌ rukꞌ xeꞌkibꞌij che: Chabꞌana jun toqꞌobꞌ, jat qukꞌ aninaq. ");
INSERT INTO quctt_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ri Pedro xeꞌ kukꞌ. Are xoꞌpanik xkikꞌam bꞌik pa ri ja ri kꞌo chikaj. Pa ri ja e nojinaq malkaꞌnibꞌ koꞌqꞌik kakikꞌut cho ri Pedro ri katzꞌyaq ri ubꞌanom ri Dorcas are xkꞌojiꞌ kukꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ri Pedro xeꞌresaj loq konojel ri e kꞌo pa ri ja kꞌa te riꞌ xukiꞌk xubꞌan chꞌawem. Xukaꞌyej ri kaminaq, xubꞌij che: Tabita, chatwaꞌjiloq. Ri Tabita xujaq ri ubꞌoqꞌoch, are xril ri Pedro, xwaꞌjilik, xtꞌuyiꞌk. ");
INSERT INTO quctt_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ri Pedro xuchap che ri uqꞌabꞌ, xutoꞌo xwaꞌjilik. Kꞌa te riꞌ xuꞌsikꞌij ri e malkaꞌnibꞌ xuqujeꞌ konojel ri kojonelabꞌ xukꞌut chikiwach chi ri Tabita kꞌaslik. ");
INSERT INTO quctt_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Xtzijox kꞌu ri kꞌulmatajem pa ronojel ri tinimit, e kꞌi xekojon che ri Ajawxel. ");
INSERT INTO quctt_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Naj kꞌut xkꞌojiꞌ na kan ri Pedro pa ri tinimit Jope cho rachoch ri Simón ri kachakun che taq tzꞌuꞌm. ");
INSERT INTO quctt_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kꞌo jun achi ubꞌiꞌnam Cornelio je laꞌ pa ri tinimit Cesarea, jun kinimaꞌqil ri ajchꞌoꞌjabꞌ chajil tinimit pa ri tinimit Roma rech ri wokaj ubꞌiꞌnam Italiano. ");
INSERT INTO quctt_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ri Cornelio sibꞌalaj kubꞌan toqꞌobꞌ chike ri winaq. Ri Cornelio xuqujeꞌ ri e kꞌo rukꞌ pa rachoch kakimochꞌ kibꞌ cho ri Dios kasipan chike ri e mebꞌaibꞌ xuqujeꞌ kubꞌan chꞌawem amaqꞌel cho ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Jun qꞌijal pa ri oxibꞌ hora rech bꞌenaq qꞌij, ri Cornelio xril jun ángel rech ri Dios xqet rukꞌ. ¡Cornelio! xuchixik. ");
INSERT INTO quctt_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ko xkaꞌyik xuxiꞌj ribꞌ, xubꞌij che: ¿Jas kaj la, tat? Ri ángel xubꞌij che: Ri Dios xuta ri achꞌawem xuqujeꞌ xqaj choch ri asipanik ri xaya chike ri mebꞌaibꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Chanim kꞌut chaꞌtaqa bꞌik nikꞌaj achyabꞌ rech kebꞌe pa ri tinimit Jope rech keꞌkisikꞌij loq jun achi ubꞌiꞌ Simón Pedro. ");
INSERT INTO quctt_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","We achi riꞌ kꞌo cho rachoch ri Simón ri kachakun che taq tzꞌuꞌm, ri kel chuchiꞌ ri plo. ");
INSERT INTO quctt_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Are xeꞌ ri ángel, ri Cornelio xusikꞌij kebꞌ rajchakibꞌ rachiꞌl jun ajchꞌoꞌj ri sibꞌalaj kuꞌl ukꞌuꞌx chikij. ");
INSERT INTO quctt_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Xutzijoj chike ronojel ri xkꞌulmatajik kꞌa te riꞌ xuꞌtaq bꞌik pa ri tinimit Jope. ");
INSERT INTO quctt_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Chukabꞌ qꞌij, are xeqeteqobꞌ ri e taqoꞌn pa ri tinimit. Ri Pedro xpaqiꞌ pa ri uwiq ri ja ri kꞌo chikaj chubꞌanik chꞌawem qas pa ri unikꞌajil qꞌij. ");
INSERT INTO quctt_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Xaq kꞌa teꞌ sibꞌalaj xnumik, are kꞌu tajin kabꞌan ri uwa xaq kꞌa teꞌ xsachiꞌk, xkꞌut kꞌu jun mayijabꞌalalaj jastaq choch. ");
INSERT INTO quctt_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Xril ri kaj jaqalik xuqujeꞌ jun likꞌilik atzꞌyaq ximtal che ri kajibꞌ utzaꞌm tajin kaqaj loq cho ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","E kꞌo ronojel uwach aꞌwaj pa ri manta, aꞌwaj kajkaj kaqan, aꞌwaj ri kakijururej kibꞌ cho ri ulew, xuqujeꞌ aꞌwaj ri kerapinik. ");
INSERT INTO quctt_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Kꞌa te riꞌ xuta jun chꞌabꞌal xubꞌij che: Pedro chatwaꞌjiloq, chaꞌkamisaj, kꞌa te riꞌ chaꞌtijaꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ri Pedro xubꞌij: Tat, ri taqanik kubꞌij chi man yaꞌtal tal ketij we aꞌwaj riꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ri chꞌabꞌal xtataj chi junmul, xubꞌij: Man kabꞌij taj chi man yaꞌtal taj katij ri uchꞌajchꞌobꞌem chi ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Oxmul xril ri Pedro we kꞌulmatajem riꞌ, kꞌa te riꞌ xpaqabꞌax ri manta pa ri kaj. ");
INSERT INTO quctt_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ri Pedro xmayijanik che ri xkꞌut choch, xuchomaj rij jas kel kubꞌij ri xrilo. Qas che ri qꞌotaj riꞌ, ri achyabꞌ ri xetaq bꞌik rumal ri Cornelio xkiriq ri rachoch ri Simón e takꞌatoj chik chuchiꞌ ri uchiꞌ ja. ");
INSERT INTO quctt_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Xekꞌorokꞌatik, xkito la chilaꞌ kꞌo wi ri jun achi ubꞌiꞌnam Simón. ");
INSERT INTO quctt_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ri Pedro kꞌut tajin kuchomaj na jas kel kubꞌij ri xrilo are xpe ri uchꞌabꞌal ri Tyoxalaj Uxlabꞌixel xubꞌij che: Oxibꞌ achyabꞌ tajin katkitzukuj. ");
INSERT INTO quctt_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Chatwaꞌjiloq, chatqaj bꞌik, jat kukꞌ man kubꞌan ta kebꞌ akꞌuꞌx xa e nutaqom loq chasikꞌixik. ");
INSERT INTO quctt_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Xqaj kꞌu loq ri Pedro, xubꞌij chike ri winaq ri tajin kakitzukuj: In riꞌ ri achi ri tajin kitzukuj. ¿Jas kiwaj? ");
INSERT INTO quctt_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ri winaq xkibꞌij: Xa xujutaq loq ri Cornelio, jun kinimaꞌqil ri ajchꞌoꞌjabꞌ pa ri tinimit Roma, jun achi ri sibꞌalaj kuꞌtoꞌ ri winaq, xuqujeꞌ kumochꞌ ribꞌ cho ri Dios, kanimax kumal konojel ri winaq aꞌj Israel. Jun tyoxalaj ángel xbꞌin che chi rajawaxik kateꞌ at cho rachoch rech kutatabꞌej ri katzijoj che. ");
INSERT INTO quctt_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ri Pedro xuꞌkoj bꞌik pa ri ja xubꞌij chike chi kekanaj kan che ri chaqꞌabꞌ riꞌ pa ri ja ri kꞌo wi, chukabꞌ qꞌij xeꞌ kukꞌ xerachiꞌlaj bꞌik nikꞌaj alaxik ri keꞌl pa ri tinimit Jope. ");
INSERT INTO quctt_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Chukabꞌ qꞌij xoꞌpan pa ri tinimit Cesarea. Ri Cornelio e rayeꞌm apanoq uꞌmulim ri rachalal xuqujeꞌ e rech taq chꞌabꞌeꞌn. ");
INSERT INTO quctt_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ri Pedro are xok bꞌik pa ri ja, xukiꞌ ri Cornelio choch, xuqꞌijilaꞌj. ");
INSERT INTO quctt_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ri Pedro xubꞌij che: Chatwaꞌjiloq, ri in, in jun achi jetaq ri at. ");
INSERT INTO quctt_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Xkichapleꞌj kꞌu tzij, kꞌa te riꞌ xoꞌk bꞌik jawjeꞌ ri kimulim wi kibꞌ ri nikꞌaj winaq chik. ");
INSERT INTO quctt_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ri Pedro xubꞌij: Ix iwetaꞌm chi ri qataqanik kubꞌij chi man kuya taj chi jun winaq aj Israel katzijon rukꞌ jun winaq ri man aj Israel taj, pune jeriꞌ ri Dios xukꞌut chinuwach chi man kuya taj kinbꞌij chꞌuluj che ri uchꞌajchꞌobꞌem chi Areꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Rumal riꞌ man xinkꞌopij ta wibꞌ xinpe waral are xiniꞌsikꞌij loq. Chibꞌij bꞌa chwe jas rumal xiniꞌkꞌama loq. ");
INSERT INTO quctt_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ri Cornelio xutzijoj we riꞌ: Chi kajibꞌ qꞌij kanoq tajin kinbꞌan chꞌawem pa ri wachoch pa ri urox hora rech bꞌenaq qꞌij. Xaq kꞌa teꞌ jun achi karepqꞌun ri ratzꞌyaq xtakꞌatobꞌ chinuwach. ");
INSERT INTO quctt_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Xubꞌij chwe: Cornelio, ri achꞌawem xtataj rumal ri Dios xuqujeꞌ xril ri asipanik ri kaya chike ri mebꞌaibꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Chanim kꞌut chattaqan chukꞌamik ri jun achi ubꞌiꞌ Simón Pedro, kꞌo pa ri rachoch ri Simón ri kachakun che taq tzꞌuꞌm, ri kel chuchiꞌ ri plo, pa ri tinimit Jope. ");
INSERT INTO quctt_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Rumal riꞌ aninaq xintaqan che asikꞌixik, tyox chawe xatpetik. Che we chanim qonojel qamulim qibꞌ choch ri Dios, qayeꞌm kaqata ri utzij ri uyoꞌm chawe. ");
INSERT INTO quctt_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ri Pedro xubꞌij: Chanim kinwilo chi ri Dios man xaq ta kuꞌchaꞌ ri winaq ri keꞌraj. ");
INSERT INTO quctt_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Xane kuꞌkꞌamawaꞌj konojel ri kakimochꞌ kibꞌ choch xuqujeꞌ kakibꞌan ri utzilal. ");
INSERT INTO quctt_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ri utz laj tzij ri yaꞌtal che ri tinimit Israel are chi kꞌo jaꞌmaril rukꞌ ri Dios, rumal ri Jesucristo, ri Ajawxel rech ronojel ri kꞌolik. ");
INSERT INTO quctt_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Iwetaꞌm ri xkꞌulmatajik, ri xchapleꞌtaj loq pa ronojel ri tinimit Judea, pa Galilea are xbꞌantaj ri uqasanaꞌ ri Jesús rumal ri Juan ");
INSERT INTO quctt_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Iwetaꞌm xuqujeꞌ chi ri Dios xuya ri kwinem rech ri Uxlabꞌixel che ri Jesús aj Nazaret. Rumal kꞌu wa ri Jesús xubꞌan ri utzilal, xuꞌkunaj ri e yawabꞌibꞌ xuqujeꞌ ri e jatꞌital rumal ri itzel, rumal kꞌo ri Dios rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ri uj, uj taqoꞌn xqilo ronojel ri xubꞌano pa ronojel Judea xuqujeꞌ pa Jerusalén, xqilo are xkamisaxik xuqujeꞌ xekebꞌax cho ri jun cheꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ri Dios kꞌut xukꞌastajisaj ri Jesús churox qꞌij. Ri Dios xuqujeꞌ xuya bꞌe che chi kukꞌut chi na ribꞌ junmul. ");
INSERT INTO quctt_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Man chikiwach ta konojel ri winaq xane xaq chikiwach ri xuchaꞌo rech jeriꞌ kaqaqꞌalajisaj ri xkꞌulmatajik. Uj riꞌ, ri xujwaꞌ rukꞌ, xujqumun rukꞌ are xkꞌastaj uwach chikixoꞌl ri kaminaqibꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ri Dios xuchaꞌ ri Jesús, rech kux qꞌatal tzij pa kiwiꞌ konojel ri winaq ri e kꞌaslik xuqujeꞌ ri e kaminaq, xujutaq kꞌu chutzijoxik xuqujeꞌ chuqꞌalajisaxik chike konojel ri winaq pa ronojel ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Are waꞌ ri xkitzijoj loq ri e qꞌalajisal taq tzij chirij ri Jesús, are xkibꞌij: jachin kakojon che Areꞌ kakuyutaj ri umak pa ri ubꞌiꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Tajin katzijon na ri Pedro are xqaj ri Uxlabꞌixel pa kiwiꞌ ri tajin kakitatabꞌej ri utz laj tzij. ");
INSERT INTO quctt_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ri e kojonelabꞌ aꞌj Israel ri e rachiꞌl bꞌi ri Pedro, xemayijanik are xkil ri usipanik ri Uxlabꞌixel xqaj pa kiwiꞌ ri winaq ri man aꞌj Israel taj. ");
INSERT INTO quctt_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Xkito are kechꞌaw pa juleꞌ taq chꞌabꞌal chik, xuqujeꞌ kakiqꞌijilaꞌj ri Dios. Ri Pedro xuta chike: ");
INSERT INTO quctt_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","¿La kꞌo jun man karaj taj kaqabꞌan kiqasanaꞌ we winaq riꞌ? Aꞌreꞌ xkikꞌamawaꞌj ri Uxlabꞌixel jetaq ri uj. ");
INSERT INTO quctt_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Xtaqan kꞌu ri Pedro kabꞌan kiqasanaꞌ pa ri ubꞌiꞌ ri Jesucristo. Kꞌa te riꞌ ri Cornelio xubꞌochiꞌj chi kakanaj kan ri Pedro jun janipa qꞌij rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ri e taqoꞌn xuqujeꞌ ri kojonelabꞌ ri e kꞌo pa Judea are xkito chi ri winaq ri man aꞌj Israel taj xekojon che ri utzij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Xkibꞌij che ri Pedro are xtzalij pa ri tinimit Jerusalén chi man utz taj ri xubꞌano. ");
INSERT INTO quctt_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Xatok pa kachoch ri man aꞌj Israel taj xuqujeꞌ xatwaꞌ kukꞌ, xecha che. ");
INSERT INTO quctt_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ri Pedro kꞌut xutzijoj chike jas ri xkꞌulmatajik. ");
INSERT INTO quctt_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Jewaꞌ xubꞌij: In kꞌo pa ri tinimit Jope, tajin kinbꞌan chꞌawem. Xaq kꞌa teꞌ xinsachiꞌk, xkꞌut kꞌu chinuwach jun atzꞌyaq ri tajin kaqaj loq cho ri kaj chaptal ri kajibꞌ utzaꞌm xqaj loq jawjeꞌ ri in kꞌo wi. ");
INSERT INTO quctt_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Are xinkaꞌyej jas kꞌo chupam, xinwil ronojel kiwach aꞌwaj, aꞌwaj kakijururej kibꞌ cho ri uwachulew, awaj kajibꞌ kichakalibꞌal xuqujeꞌ aꞌwaj ri kerapin cho ri kaj. ");
INSERT INTO quctt_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Xinta kꞌu jun chꞌabꞌal kubꞌij: “Pedro chatwaꞌjiloq chaꞌtijaꞌ.” ");
INSERT INTO quctt_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","In xinbꞌij: “Tat, man nutijom ta wi jun chꞌulujalaj jastaq rumal cher ri qataqanik man kuya ta bꞌe chaqe.” ");
INSERT INTO quctt_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Xchꞌaw chi junmul ri chꞌabꞌal ri xpe chikaj, xubꞌij: “Man kabꞌij taj chi man yaꞌtal taj katij ri uchꞌajchꞌobꞌem chi ri Dios.” ");
INSERT INTO quctt_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Oxmul xkꞌulmataj we kꞌutbꞌal riꞌ, kꞌa te riꞌ xpaqabꞌax chi ri manta pa ri kaj. ");
INSERT INTO quctt_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Qas che ri qꞌotaj riꞌ, oꞌxibꞌ achyabꞌ ri kipetik pa ri tinimit Cesarea xoꞌpan jawjeꞌ ri in kꞌo wi. ");
INSERT INTO quctt_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ri Tyoxalaj Uxlabꞌixel xubꞌij chwe chi kineꞌ kukꞌ xuqujeꞌ chi man kakꞌaxir ta wanimaꞌ kineꞌ kukꞌ ri winaq ri man aꞌj Israel taj. We waqibꞌ alaxik ri e kꞌo chanim xebꞌe wukꞌ are xujopan cho rachoch ri achi ri xtaqan che qasikꞌixik. ");
INSERT INTO quctt_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ri achi xuchapleꞌj utzijoxik chaqe chi jun ángel xukꞌut ribꞌ choch pa ri rachoch xubꞌij che: “Chaꞌtaqa bꞌik e taqoꞌn pa ri tinimit Jope rech keꞌkisikꞌij loq jun achi ubꞌiꞌ Simón Pedro.” ");
INSERT INTO quctt_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ri achi riꞌ are kabꞌin chawe jas kabꞌano rech katkolotajik xuqujeꞌ kekolotaj ri winaq ri e kꞌo pa ri awachoch. ");
INSERT INTO quctt_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Are xinchapleꞌj tzijonem kukꞌ, ri Tyoxalaj Uxlabꞌixel xqaj pa kiwiꞌ jetaq ri xubꞌan qukꞌ uj nabꞌe. ");
INSERT INTO quctt_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Xnaꞌtaj kꞌu chwe are xubꞌij ri Ajawxel Jesús: “Ri Juan xubꞌan qasanaꞌ rukꞌ jaꞌ, ri ix kꞌut kabꞌan na iqasanaꞌ rukꞌ ri Tyoxalaj Uxlabꞌixel.” ");
INSERT INTO quctt_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","We xuya ri Dios ri sipanik riꞌ chike ri winaq ri man aꞌj Israel taj jetaq ri xuya chaqe uj, ¿in jachin in chuqꞌatexik ri Dios? ");
INSERT INTO quctt_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Are xkita we tzij riꞌ, konojel xkiqꞌil kibꞌ che ubꞌixik tzij che ri Pedro, xkichapleꞌj uqꞌijilaꞌxik ri Dios. Xkibꞌij: Kaqilo chi ri Dios are xraj chi ri winaq ri man aꞌj Israel taj kakikꞌex kikꞌuꞌx rech kakikꞌamawaꞌj jun alik kꞌaslemal. ");
INSERT INTO quctt_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Jujun chike ri kojonelabꞌ ri xaꞌnimaj bꞌik are xchapleꞌtaj kitzukuxik che riꞌ are xkamisax ri Esteban, xebꞌe pa taq ri tinimit rech Fenicia, kꞌo xebꞌe Chipre, kꞌo xebꞌe Antioquía rech Siria. Xkitzijoj ri utzij ri Dios xwi chike ri winaq aꞌj Israel. ");
INSERT INTO quctt_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Kꞌo kꞌu jujun kojonelabꞌ ri aꞌj Chipre xuqujeꞌ aꞌj Cirene are xoꞌpan pa Antioquía xkichapleꞌj utzijoxik ri Ajawxel Jesús chike ri man aꞌj Israel taj. ");
INSERT INTO quctt_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ri ukwinem ri Ajawxel kꞌo kukꞌ, e kꞌi kꞌu winaq ri man aꞌj Israel taj xekojon che ri Ajawxel. ");
INSERT INTO quctt_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Are xketaꞌmaj ri komontyox ri kꞌo pa ri tinimit Jerusalén, ri xkꞌulmatajik xkitaq bꞌik ri Bernabé pa ri tinimit Antioquía. ");
INSERT INTO quctt_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ri Bernabé are xopanik, xnoj ri ranimaꞌ che kiꞌkotemal rumal cher xril ri utewechiꞌbꞌal ri Dios, xuꞌtaqchiꞌj ri kojonelabꞌ rech kajeqiꞌ kanimaꞌ chirij ri Ajawxel. ");
INSERT INTO quctt_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ri Bernabé jun utz laj achi, nojinaq che ri Uxlabꞌixel, qas ko kꞌo pa ri ukojobꞌal. Sibꞌalaj e kꞌi winaq kꞌut xekojon che ri Ajawxel. ");
INSERT INTO quctt_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Are kꞌu ri Bernabé xeꞌ pa ri tinimit Tarso, xuꞌtzukuj ri Saulo. ");
INSERT INTO quctt_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Are xuriqo, xukꞌam bꞌik pa ri tinimit Antioquía. Jun junabꞌ xekanaj kan kikobꞌchal pa jun komontyox xkiya kꞌutuꞌn chike e kꞌi winaq. (Pa ri tinimit Antioquía xbꞌix wi nabꞌe mul Cristianos chike ri kojonelabꞌ). ");
INSERT INTO quctt_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Pa taq ri qꞌij riꞌ e kꞌo jujun qꞌalajisal taq rech ri utzij ri Dios xeꞌl bꞌik pa ri tinimit Jerusalén, xebꞌe pa ri tinimit Antioquía. ");
INSERT INTO quctt_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Jun chike ubꞌiꞌ Agabo, pa jun chike ri kimulin ibꞌ xtakꞌiꞌk xubꞌij chi kape na jun nimalaj numik pa ronojel ri tinimit Roma. Xkꞌulmataj kꞌu we riꞌ are kꞌo ri Claudio che qꞌatal tzij. ");
INSERT INTO quctt_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Rumal riꞌ, ri kojonelabꞌ aꞌj Antioquía xkitaq kꞌu bꞌik jun tobꞌanik chike ri alaxik aꞌj Judea, chi kijujunal xkiya ri xekwin chuyaꞌik. ");
INSERT INTO quctt_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Xkiterebꞌa kꞌu bꞌik ri kisipanik kukꞌ ri Bernabé rachiꞌl ri Saulo, rech kakiya apanoq chike ri kꞌamal taq bꞌe rech ri komontyox ri kꞌo pa ri tinimit Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Pa taq ri qꞌij riꞌ, ri taqanel Herodes Agripa xuchapleꞌj ubꞌanik kꞌax chike jujun kojonelabꞌ rech ri komontyox. ");
INSERT INTO quctt_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Xtaqan chukamisaxik ri Jacobo (rachalal ri Juan) chi sakꞌibꞌal. ");
INSERT INTO quctt_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Are xril ri Herodes chi xqaj chkiwach ri winaq aꞌj Israel ri xubꞌano, xtaqan chuchapik ri Pedro. (Wa we riꞌ xkꞌulmataj pa ri nimaqꞌij rech Pascua). ");
INSERT INTO quctt_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Xukoj pa cheꞌ xuꞌtaq e kajibꞌ wok aꞌj ajchꞌoꞌjabꞌ chajil tinimit chuchajixik, kajibꞌ achyabꞌ pa jujun wok. Ri uchomanik are chi we xikꞌow ri nimaqꞌij Pascua kuqꞌat tzij puꞌwiꞌ, chikiwach konojel ri winaq. ");
INSERT INTO quctt_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ri komontyox xkibꞌan chꞌawem rukꞌ chuqꞌabꞌ puꞌwiꞌ ri Pedro are kꞌo pa cheꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Jun aqꞌabꞌ karaj kuriq ri qꞌij kaqꞌat tzij puꞌwiꞌ ri Pedro, ri Pedro tajin kawar chikixoꞌl kebꞌ aꞌj ajchꞌoꞌjabꞌ chajil tinimit, ri nikꞌaj aꞌj ajchꞌoꞌjabꞌ chajil tinimit chik kichajim ri uchiꞌ ja rech ri cheꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Xaq kꞌa teꞌ xtunan jun qꞌaqꞌ pa ri cheꞌ, jun ángel rech ri Ajawxel xtakꞌiꞌ choch ri Pedro, ko xuchap pa ri ukꞌalkꞌaꞌx rech kakꞌastajik, kꞌa te riꞌ xbꞌix che: Chakowij chatwaꞌjiloq. Ri chꞌichꞌ ri kojtal chujatꞌixik xtzaq pa ri ulew. ");
INSERT INTO quctt_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ri ángel xubꞌij che: Chakojo ri awatzꞌyaq xuqujeꞌ ri axajabꞌ. Ri Pedro xunimaj ri xbꞌix che, kꞌa te riꞌ ri ángel xubꞌij che: Chakojo ri aqꞌuꞌ, chinatereneꞌj. ");
INSERT INTO quctt_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ri Pedro xel loq pa ri kꞌolibꞌal ri kꞌo wi, xutereneꞌj ri ángel, puꞌkꞌuꞌx chi xaq tajin kachikꞌik, man xuchꞌobꞌ taj chi qas tzij ri tajin kakꞌulmatajik. ");
INSERT INTO quctt_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Xikꞌow loq chkiwach ri nabꞌe taq chajinelabꞌ, kꞌa te riꞌ chkiwach ri ukabꞌ. Xoꞌpan chuchiꞌ ri chꞌichꞌ uchiꞌ ja ri kel bꞌik pa ri tinimit, are xoꞌpan chilaꞌ, ri uchiꞌ ja xjaqajobꞌ utukel chikiwach. Xeꞌl bꞌik, xkichapleꞌj bꞌinem pa ri bꞌe, xaq kꞌa teꞌ xya kan utukel ri Pedro rumal ri ángel. ");
INSERT INTO quctt_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Are xtzaratzobꞌ ri Pedro, xubꞌij: Qas tzij bꞌa ri Ajawxel xutaq loq ri ángel chinukolik cho ri Herodes xuqujeꞌ che ri kꞌax ri kichomam ri winaq aꞌj Israel kakibꞌan chwe. ");
INSERT INTO quctt_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Kꞌa te riꞌ xeꞌ cho rachoch ri María, ri unan ri Juan Marcos, chilaꞌ kimulim wi kibꞌ e kꞌi kojonelabꞌ chubꞌanik chꞌawem. ");
INSERT INTO quctt_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Xukꞌorokꞌa ri uchiꞌ ja, xel kꞌu loq jun ali patanijel ubꞌiꞌ Rode. ");
INSERT INTO quctt_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Are xuta ri uchꞌabꞌal ri Pedro, sibꞌalaj xkiꞌkotik, man xujaq ta kꞌu ri uchiꞌ ja xane nabꞌe xuꞌbꞌij chike konojel ri e kꞌo pa ri ja: Kꞌo ri Pedro chuchiꞌ le ja. ");
INSERT INTO quctt_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Xaq at kon riꞌ, wine are uángel, xecha che. Ri ali kꞌut xubꞌij chi qas are wi Pedro. ");
INSERT INTO quctt_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ri Pedro kꞌut xaq je xukꞌorokꞌa ri uchiꞌ ja. Kꞌamaꞌtam xkijaqo, are xkilo xemayijanik. ");
INSERT INTO quctt_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pa memal tzij xubꞌij chike chi man kechꞌaw ta na, xutzijoj chike jas xubꞌan ri Ajawxel chi resaxik loq pa ri cheꞌ. Chitzijoj che ri Jacobo xuqujeꞌ chike konojel ri alaxik ri xkꞌulmatajik, xcha chike. Kꞌa te riꞌ xeꞌ chi pa jun kꞌolibꞌal chik. ");
INSERT INTO quctt_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Are xsaqirik, ri aꞌj ajchꞌoꞌjabꞌ chajil taq tinimit xetontiꞌrik rumal ri xkꞌulmataj rukꞌ ri Pedro. ");
INSERT INTO quctt_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ri Herodes Agripa xukꞌot kichiꞌ ri e chajinelabꞌ, kꞌa te riꞌ xtaqan che kikamisaxik. Ri Herodes are xbꞌantaj we riꞌ rumal xeꞌkꞌol pa Cesarea jun janipa qꞌij. ");
INSERT INTO quctt_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Sibꞌalaj xyojtaj ri Herodes kukꞌ ri winaq rech ri tinimit Tiro xuqujeꞌ Sidón. Ri winaq aꞌj chilaꞌ xeꞌkitaq bꞌik taqoꞌn xeꞌkibꞌij che ri Herodes chi maj chꞌoꞌj kakaj kakibꞌan rukꞌ rumal cher ketaꞌm chi chilaꞌ kape wi ri kakitijo. Xraj kꞌu ri Blasto ri rajchak ri Herodes xchꞌaw pa kiwiꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Jun qꞌijal kꞌut ri Herodes xuchaꞌ jun qꞌij katzijon kukꞌ. Are xuriq ri qꞌij ri Herodes, xukoj ri ratzꞌyaq rech nim taqanel, xtꞌuyiꞌ pa ri utem xtzijon kukꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ri winaq xkipaqꞌapa ri kiqꞌabꞌ, xkiraq kichiꞌ xkibꞌij: ¡Man uchꞌabꞌal ta achi, ri tajin kaqatoꞌ uchꞌabꞌal jun dios! ");
INSERT INTO quctt_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Aninaq xpe jun ángel rech ri Dios, xukoj jun yabꞌil che, rumal cher xukꞌamawaꞌj ri qꞌijilaꞌnik ri xkiya ri winaq che, man xuya ta che ri Dios. Xaq jeriꞌ xkamik, iꞌxjut xetijowik. ");
INSERT INTO quctt_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Are kꞌu ri utzij ri Dios xjabꞌun pa ronojel tinimit, sibꞌalaj e kꞌi xekojonik. ");
INSERT INTO quctt_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ri Bernabé rachiꞌl ri Saulo are xetoꞌtaj che ri kitaqkil pa ri tinimit Jerusalén, xetzalij pa ri tinimit Antioquía, xkikꞌam bꞌik ri Juan Marcos. ");
INSERT INTO quctt_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","E kꞌo kꞌu qꞌalajisal taq rech ri utzij ri Dios xuqujeꞌ aꞌjtijabꞌ pa ri komontyox rech ri tinimit Antioquía pa Siria, ri Bernabé, ri Simón (ri kabꞌix Qꞌeq che), ri Lucio (aj Cirene), ri Manaén ri junam xekꞌiy rukꞌ ri Herodes Antipas, xuqujeꞌ ri Saulo. ");
INSERT INTO quctt_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Jun qꞌijal are tajin kakibꞌan chꞌawem xuqujeꞌ tajin kakiqꞌip kiwaꞌim, ri Uxlabꞌixel xubꞌij chike: Chiꞌqꞌata ri Bernabé rachiꞌl ri Saulo rech kebꞌe che ri chak ri e nusikꞌim wi. ");
INSERT INTO quctt_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Xkibꞌan kꞌu qꞌipoj waꞌim xuqujeꞌ xkibꞌan chꞌawem pa kiwiꞌ ri Saulo rachiꞌl ri Bernabé xkiya kiqꞌabꞌ pa kiwiꞌ, kꞌa te riꞌ xeꞌkitaq bꞌik. ");
INSERT INTO quctt_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ri Uxlabꞌixel xutaq bꞌik ri Bernabé rachiꞌl ri Saulo xebꞌe chuchiꞌ ri jaꞌ rech Seleucia kelik bꞌi chilaꞌ xebꞌe puꞌwiꞌ ri jaꞌ xoꞌpan pa jun leꞌaj sutital che jaꞌ pa ri tinimit Chipre. ");
INSERT INTO quctt_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Are xoꞌpan pa ri tinimit Salamina, xoꞌk pa ri Sinagoga kech ri winaq aꞌj Israel chilaꞌ xkitzijoj wi ri utzij ri Dios. Ri Juan Marcos xeꞌ kukꞌ chikitoꞌik. ");
INSERT INTO quctt_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Xebꞌe pa jaljoj taq tinimit kꞌa te riꞌ xoꞌpan pa ri tinimit Pafos. Chilaꞌ xketaꞌmaj wi uwach jun ajqꞌij, jun menkꞌetinel aꞌj Israel ubꞌiꞌ Barjesús. ");
INSERT INTO quctt_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ri achi riꞌ kachakun rukꞌ ri qꞌatal tzij, Sergio Paulo, jun qꞌatal tzij ri sibꞌalaj kꞌo retaꞌmabꞌal. Xtaqan kꞌu chikisikꞌixik ri Bernabé rachiꞌl ri Saulo, rumal cher karaj kuta ri utzij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Are kꞌu ri Elimas ri ajqꞌij (are waꞌ ri ubꞌiꞌ pa tzijobꞌal griego) xukoj ukꞌuꞌx ri nim qꞌatal tzij rech man kutatabꞌej ta ri kakitzijoj ri Bernabé rachiꞌl ri Saulo rech jeriꞌ man kakojon taj. ");
INSERT INTO quctt_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ri Saulo ubꞌiꞌ Pablo xnoj che ri Uxlabꞌixel ko xukaꞌyej ri achi. ");
INSERT INTO quctt_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Kꞌa te riꞌ xubꞌij che: ¡Ralkꞌwaꞌl itzel, at ukꞌulel ri sukꞌal, at nojinaq che menkꞌetinik, xuqujeꞌ bꞌanoj tzij. At ukꞌulel ronojel utzilal! ¿Jampaꞌ kattaniꞌk chukotik ri utz laj ubꞌe ri Ajawxel? ");
INSERT INTO quctt_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ri Ajawxel kꞌut kuqꞌat tzij paꞌwiꞌ rumal riꞌ katmoyar chanim. Man kawil ta chi ri utunal ri qꞌij jun janipa qꞌij. Jeriꞌ aninaq xok sutzꞌ xuqujeꞌ qꞌequꞌmal pa ri ubꞌoqꞌoch ri achi, xuchapleꞌj bꞌinem, man karil ta chi ri ubꞌe, xa xuta chi toqꞌobꞌ xtzuyexik kakꞌut ri ubꞌe. ");
INSERT INTO quctt_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ri qꞌatal tzij are xril ri xkꞌulmatajik, xkojonik rumal xmayijanik che ri kꞌutuꞌn rech ri Ajawxel Jesús. ");
INSERT INTO quctt_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ri Pablo xuqujeꞌ ri e rachiꞌl xeꞌl bꞌik pa ri tinimit Pafos, xebꞌe pa jun jukubꞌ bꞌinibꞌal puꞌwiꞌ ri jaꞌ, xebꞌe pa ri tinimit Panfilia. Xoꞌpan chuchiꞌ ri jaꞌ pa ri tinimit Perge. Chilaꞌ xtzalij wi kanoq ri Juan Marcos xeꞌ kanoq pa Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ri Pablo kꞌut rachiꞌl ri Bernabé xkisukꞌu xoꞌpan pa ri tinimit Antioquía pa Pisidia. Pa ri qꞌij rech uxlanem xebꞌe pa ri mulim ibꞌ pa ri Sinagoga. ");
INSERT INTO quctt_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Are xsikꞌitaj ri wuj rech ri Moisés, ri naqꞌatalik kakisikꞌij xuqujeꞌ ri kiwuj ri e qꞌalajisal taq rech ri utzij ri Dios, ri e kꞌamal taq bꞌe kech ri winaq ri kimulin kibꞌ xkitaq ubꞌixik chike: Alaxik, we kꞌo tzij iwukꞌ ri kuya jororemal xuqujeꞌ kuꞌtaqchiꞌj ri alaxik kebꞌe chikiwach, chixqꞌaxoq jiꞌbꞌij. ");
INSERT INTO quctt_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Xwaꞌjil kꞌu ri Pablo, pa memal tzij xubꞌij chike chi man kechꞌaw ta na kꞌa te riꞌ xuchapleꞌj chꞌawem xubꞌij: Chitampeꞌ, achyabꞌ aꞌj Israel xuqujeꞌ ri ix man ix aꞌj Israel taj, ri kixiꞌj iwibꞌ cho ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ri Dios rech we tinimit Israel xuꞌchaꞌ ri qamam ojer, xuꞌkꞌiyarisaj, xuya kichuqꞌabꞌ are xekꞌojiꞌ pa ri tinimit Egipto, kꞌa te riꞌ rukꞌ ri kwinel laj uqꞌabꞌ xeꞌresaj loq pa ri patanijik. ");
INSERT INTO quctt_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Xukochꞌ uwach chike kawinaq junabꞌ are xebꞌin pa ri katzꞌinow ulew. ");
INSERT INTO quctt_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Xusach kiwach wuqubꞌ tinimit ri e kꞌo pa Canaán rech jeriꞌ xuya ri ulew chike ri winaq aꞌj Israel. ");
INSERT INTO quctt_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","We jastaq riꞌ xkꞌulmatajik kajibꞌ ciento rukꞌ kawinaq lajuj junabꞌ. Kꞌa te riꞌ ri Dios xuꞌkoj qꞌatal taq tzij kꞌamal taq kibꞌe ri tinimit Israel, ri kꞌisbꞌal qꞌatal tzij are ri Samuel. ");
INSERT INTO quctt_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ri winaq xkita kꞌu jun kitaqanel, ri Dios xuya chike ri Saúl ukꞌojol ri Cis, rech ri jupuq winaq rech Benjamín are waꞌ xtaqan pa Israel kawinaq junabꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ri Dios are xresaj ri Saúl che taqanel, xukoj ri David che ukꞌaxel, are waꞌ ri xbꞌix che rumal ri Dios: Ri David ukꞌojol ri Isaí are qas kaqaj chinuwach, rumal cher kubꞌan na ronojel ri kinbꞌij che kubꞌano. ");
INSERT INTO quctt_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ri Jesús kꞌut are jun chike ri e rijaꞌl ri David are waꞌ ri kolonel uchiꞌm loq ri Dios chike ri utinimit Israel. ");
INSERT INTO quctt_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Majoꞌq kape ri Jesús, are xpe ri Juan Bꞌanal qasanaꞌ, xubꞌij chike ri winaq aꞌj Israel chi rajawaxik kakikꞌex kikꞌuꞌx che ri kimak, ketzalij rukꞌ ri Dios, xuqujeꞌ kabꞌan kiqasanaꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Are xuriq ri kꞌisbꞌal qꞌij rech ukꞌaslemal ri Juan, xubꞌij: “¿Teꞌq piꞌkꞌuꞌx chi in in Mesías? Man in taj. Kape kꞌu na Areꞌ, man taqal ta kꞌu chwe in kinoq che patanil re, man ne taqal ta chwe kinkir ri ximbꞌal uxajabꞌ.” ");
INSERT INTO quctt_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Qachalal ralkꞌwaꞌl ri Abraham xuqujeꞌ winaq ri man ix aꞌj Israel taj ix ri kixiꞌj iwibꞌ cho ri Dios, we tzij rech kolotajem chaqe uj xyaꞌtaj wi. ");
INSERT INTO quctt_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ri winaq aꞌj Jerusalén, xuqujeꞌ ri kꞌamal taq kibꞌe man xkichꞌobꞌ taj chi ri Jesús xtzijox loq kumal ri qꞌalajisal taq rech ri utzij ri Dios. Rumal riꞌ xkiqꞌat tzij puꞌwiꞌ je xkibꞌano jetaq ri kitzijom loq ri qꞌalajisal taq rech ri utzij ri Dios, ri kasikꞌix pa ronojel taq qꞌij rech uxlanem. ");
INSERT INTO quctt_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Man kꞌo ta kꞌu rumal kakamisaxik, pune jeriꞌ xkita wi che ri Pilato chi kakamisaxik. ");
INSERT INTO quctt_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Are xbꞌantaj kumal ronojel ri tzꞌibꞌatal chrij ri Jesús, xkiqasaj cho ri cheꞌ kꞌa te riꞌ xeꞌkimuqu kanoq. ");
INSERT INTO quctt_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ri Dios kꞌut xukꞌastajisaj uwach chkixoꞌl ri kaminaqibꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ri Jesús xukꞌut ribꞌ sibꞌalaj kꞌi mul chikiwach ri winaq ri xebꞌin rukꞌ kelik loq pa Galilea xebꞌe pa ri tinimit Jerusalén. Kamik riꞌ, are waꞌ we winaq riꞌ ketzijon ri ukamikal xuqujeꞌ ri kꞌastajibꞌal uwach ri Jesús chike ri tinimit Israel. ");
INSERT INTO quctt_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Kamik riꞌ, uj kꞌo waral chutzijoxik ri utz laj tzij ri bꞌiꞌtal loq chike ri e qamam ojer. ");
INSERT INTO quctt_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ri Dios xubꞌano ri ubꞌim loq chaqe are xukꞌastajisaj uwach ri Jesús. Are waꞌ ri kubꞌij ri ukabꞌ Salmo che ri Jesús. At at nukꞌojol, kamik riꞌ xinux aTat. ");
INSERT INTO quctt_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ri Dios xubꞌij loq chi kuwaꞌjilisaj na ri Jesús chikixoꞌl ri kaminaqibꞌ, man xuya ta kanoq pa ri jul rech kaqꞌayik, xubꞌij xuqujeꞌ: Kinya na ri Tyoxalaj tewechibꞌal ri nuchiꞌm loq che ri David. ");
INSERT INTO quctt_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Kꞌo chi jun Salmo ri kꞌyaqal kubꞌan chubꞌixik: Man kaya ta la bꞌe chi ri Tyox patanil e la kaqꞌay pa ri jul. ");
INSERT INTO quctt_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","We Salmo riꞌ man are ta kutzijoj rij ri David. Ri David are xepatanitaj ri e rach kꞌiyik, xkam bꞌik, xmuq kukꞌ ri ratiꞌt umam, xqꞌay ri areꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Man are ta kutzijoj rij ri David xane jun winaq chik ri xkꞌastajisax rumal ri Dios ri man xqꞌay ta ri ubꞌaqil. ");
INSERT INTO quctt_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Qachalal, chitampeꞌ, uj kꞌo waral che uqꞌalajisaxik chi kꞌo kuybꞌal imak rumal ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Xapachin ri kakojon che ri Jesús kabꞌantaj sukꞌ che cho ri Dios, are waꞌ ri man xkwin ta ri utaqanik ri Moisés xubꞌano. ");
INSERT INTO quctt_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Qas chixchomanoq rech man kakꞌulmataj ta iwukꞌ ri xkibꞌij loq ri e qꞌalajisal taq rech ri utzij ri Dios, are xkibꞌij: ");
INSERT INTO quctt_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Chiwilampeꞌ ix ri ix ajyoqꞌolobꞌ, chixmayijanoq xuqujeꞌ sach iwach, rumal cher tajin kinbꞌan jun jastaq ri pune kꞌo katzijon chiꞌwe man kikoj ta wi riꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ri Pablo rachiꞌl ri Bernabé are xeꞌl loq pa ri Sinagoga xebꞌochiꞌx kumal ri winaq rech kakitzalij utzijoxik ri jastaq pa jun qꞌij chik rech uxlanem. ");
INSERT INTO quctt_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","E kꞌi winaq aꞌj Israel xuqujeꞌ winaq ri xkibꞌan aꞌj Israel chibꞌil kibꞌ xeꞌkitereneꞌj ri Pablo rachiꞌl ri Bernabé. Konojel we winaq riꞌ xeꞌkitaqchiꞌj ri Pablo rachiꞌl ri Bernabé rech kajeqiꞌ kikꞌuꞌx pa ri utoqꞌobꞌ ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Che ri jun qꞌij chik rech uxlanem, konojel ri winaq rech ri tinimit xkimulij kibꞌ chutayik ri utzij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ri winaq aꞌj Israel are xkil ri kikꞌyal ri winaq, itzel xkinaꞌo xkichapleꞌj ubꞌixik bꞌanoj taq tzij chirij ri Pablo, xkichapleꞌj ukꞌululaꞌxik ronojel ri kubꞌij. ");
INSERT INTO quctt_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ri Pablo xuqujeꞌ ri Bernabé xkibꞌij rukꞌ chuqꞌabꞌ: Sibꞌalaj rajawaxik nabꞌe kaqatzijoj ri utzij ri Dios chiꞌwe ix, ri ix aj Israel, rumal kꞌu cher xiwetzelaj uwach kinaꞌo chi man kataqiꞌ ta chiꞌwe ri jun alik kꞌaslemal, rumal riꞌ kaqatzijoj chi we tzij riꞌ chike ri winaq ri man aꞌj Israel taj. ");
INSERT INTO quctt_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ri Ajawxel xuya we taqanik riꞌ chaqe are xubꞌij: At nuyaꞌom chikitunaxik ri winaq ri man aꞌj Israel taj, rech katzijoj ri koltajem pa taq ri naja taq tinimit rech ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ri winaq ri man aꞌj Israel taj are xkita ri xbꞌixik, xetyoxin che ri Ajawxel rumal ri utzij, konojel ri e chaꞌtal chukꞌamawaꞌxik ri jun alik kꞌaslemal, xekojonik. ");
INSERT INTO quctt_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ri utzij ri Dios xjabꞌun pa ri tinimit riꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Are kꞌu ri kꞌamal taq kibꞌe ri winaq aꞌj Israel xeꞌkitaqchiꞌj ixoqibꞌ ri muꞌl kikꞌuꞌx pa ri kinaqꞌatajibꞌal xuqujeꞌ e kꞌamal taq bꞌe rech ri tinimit rech xkimulij kibꞌ chikij ri Pablo rachiꞌl ri Bernabé rech jeriꞌ xeꞌkesaj bꞌik pa ri tinimit. ");
INSERT INTO quctt_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ri Pablo rachiꞌl ri Bernabé xeꞌl loq pa ri tinimit, xkitota kan ri ulew che ri kaqan kꞌutbꞌal rech chi maj kimak chike ri winaq we kape kꞌaxkꞌolal pa kiwiꞌ. Kꞌa te riꞌ xebꞌe pa ri tinimit Iconio. ");
INSERT INTO quctt_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ri tijoxelabꞌ xenoj che kiꞌkotemal xuqujeꞌ che ri Uxlabꞌixel. ");
INSERT INTO quctt_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ri Pablo rachiꞌl ri Bernabé are xoꞌpan pa ri tinimit Iconio xoꞌk bꞌik pa ri Sinagoga, xkitzijoj rukꞌ chuqꞌabꞌ ri utz laj tzij, e kꞌi kꞌu winaq aꞌj Israel xuqujeꞌ winaq ri man aꞌj Israel taj xekojonik. ");
INSERT INTO quctt_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","E kꞌo kꞌu jujun chike ri aꞌj Israel xketzelaj ri utzij ri Dios, xkimenkꞌetij ri kichomabꞌal ri man aꞌj Israel taj rech jeriꞌ man kakitatabꞌej ta ri kakitzijoj ri Bernabé rachiꞌl ri Pablo. ");
INSERT INTO quctt_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Rumal riꞌ naj qꞌotaj xekanaj kanoq ri taqoꞌn pa ri tinimit xkitzijoj ri utoqꞌobꞌ ri Ajawxel rukꞌ chuqꞌabꞌ. Ri Ajawxel xuya kwinem chike rech kakibꞌan mayijabꞌal taq jastaq rech jeriꞌ kaqꞌalajinik chi qas tzij ri kakitzijoj. ");
INSERT INTO quctt_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Kꞌo kꞌu xkikoj kibꞌ kukꞌ ri e taqoꞌn kꞌo xuqujeꞌ are xkikoj ri kakibꞌij ri e kꞌamal taq kibꞌe ri aꞌj Israel. ");
INSERT INTO quctt_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Rumal riꞌ xkimulij kibꞌ nikꞌaj aꞌj Israel xuqujeꞌ nikꞌaj man aꞌj Israel taj e kachiꞌl ri e kꞌamal taq kibꞌe xkichomaj keꞌkibꞌan ri taqoꞌn che abꞌaj. ");
INSERT INTO quctt_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ri taqoꞌn are xkita ri xchomax chikij xaꞌnimaj bꞌik xebꞌe pa ri tinimit Licaonia, pa ri tinimit rech Listra xuqujeꞌ Derbe kꞌa te riꞌ pa taq ri tinimit ri e kꞌo pa taq kixukut. ");
INSERT INTO quctt_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Chilaꞌ xkitzijoj wi ri utz laj tzij. ");
INSERT INTO quctt_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ri e taqoꞌn are xoꞌpan pa ri tinimit Listra xkiriq jun achi ri uriqom kꞌax ri raqan. Chꞌokeꞌr wi pa ri ukꞌiyik, man bꞌininaq ta wi. We achi riꞌ tꞌuyul apanoq, ");
INSERT INTO quctt_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","tajin kutatabꞌej ri Pablo. Ri Pablo are xrilo chi ri achi kꞌo ukojobꞌal rech kutzirik. ");
INSERT INTO quctt_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ko xuchꞌabꞌej, xubꞌij che: ¡Chatwaꞌjiloq! Ri achi xtakꞌiꞌk, xchꞌoplajik kꞌa te riꞌ xuchapleꞌj bꞌinem. ");
INSERT INTO quctt_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ri winaq are xkil ri xubꞌan ri Pablo, xkiraq kichiꞌ, xkibꞌij pa ri kitzijobꞌal: ¡We achyabꞌ riꞌ e dios, e petinaq chi qasolixik pa winaqil! ");
INSERT INTO quctt_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Xkibꞌij kꞌu dios Zeus che ri Bernabé, xkibꞌij dios Hermes che ri Pablo, rumal cher are qas ukꞌaꞌninaq bꞌik ri tzij. ");
INSERT INTO quctt_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ri templo re ri dios Zeus man pa ri tinimit taj kꞌo wi. Ri pare ri kachakun chilaꞌ e rachiꞌl ri winaq xkikꞌam bꞌik wakax, kotzꞌiꞌj taq korona chuchiꞌ ri okibꞌal pa ri tinimit, rech kakitzuj chikiwach ri e taqoꞌn. ");
INSERT INTO quctt_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ri Bernabé rachiꞌl ri Saulo are xkita ri tajin kakꞌulmatajik, xemayijanik. Xkitꞌoqopij ri katzꞌyaq xuqujeꞌ xkiraq kichiꞌ, xkibꞌij chike ri winaq: ");
INSERT INTO quctt_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","¡Achyabꞌ! ¿Jas che jewaꞌ kibꞌano? Ri uj xaq uj winaq jetaq ri ix uj petinaq che utzijoxik ri utz laj tzij chiꞌwe, rajawaxik kitas iwibꞌ che ri itzel taq jastaq xuqujeꞌ chixkojon che ri kꞌaslik Dios ri xbꞌanow ri kaj ulew, ri cho, xuqujeꞌ ronojel ri kꞌo chupam. ");
INSERT INTO quctt_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ri Dios najtir xuya bꞌe chike konojel ri tinimit kakitaqej ri bꞌe ri kakaj. ");
INSERT INTO quctt_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Xa kꞌu xukꞌut chkiwach chi Areꞌ jun kꞌaslik Dios xuqujeꞌ sibꞌalaj utz kukꞌ konojel ri winaq. Kutaq la jabꞌ pa kiwiꞌ konojel ri winaq xuqujeꞌ kubꞌano chi kawachin ri kitikoꞌn, kuya kiwa xuqujeꞌ kiꞌkotemal pa kanimaꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ri Pablo rachiꞌl ri Bernabé xekwinik xeꞌkiqꞌatej ri winaq xaq jeriꞌ man xtzuj ta kaminaq aꞌwaj chikiwach, pune kꞌax xkibꞌan chi kiqꞌatexik. ");
INSERT INTO quctt_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Xoꞌpan kꞌu nikꞌaj winaq, kipetik pa ri tinimit Antioquía xuqujeꞌ pa ri tinimit Iconio, xkikoj kikꞌuꞌx ri winaq xkibꞌan che abꞌaj ri Pablo kꞌa te ri xkichararej bꞌik xkesaj bꞌik pa ri tinimit, pa kikꞌuꞌx chi xkamik. ");
INSERT INTO quctt_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Xkimulij kꞌu kibꞌ ri kojonelabꞌ chirij, chikiwach kꞌu konojel xwaꞌjil bꞌik xtzalij pa ri tinimit. Chukabꞌ qꞌij xeꞌ pa ri tinimit Derbe rachiꞌl ri Bernabé. ");
INSERT INTO quctt_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Xkitzijoj ri utz laj tzij pa ri tinimit Derbe e kꞌi kꞌu winaq xekojon che ri Jesús. Kꞌa te riꞌ xetzalij pa ri tinimit Listra, pa ri tinimit Iconio xuqujeꞌ pa ri tinimit Antioquía rech Pisidia. ");
INSERT INTO quctt_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Are xoꞌpan chilaꞌ, xeꞌkitaqchiꞌj ri kojonelabꞌ kejeqiꞌk pa ri kikojobꞌal xuqujeꞌ xkinaꞌtaj kan chike chi rajawaxik kakitas kibꞌ che kꞌi taq jastaq rech koꞌk pa ri ajawarem rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ri Pablo rachiꞌl ri Bernabé xeꞌkikoj kꞌamal taq kibꞌe ri kojonelabꞌ pa ronojel ri komontyox. Xkibꞌan chꞌawem xuqujeꞌ xkiqꞌip kibꞌ che waꞌim, xeꞌkijach ri kꞌamal taq bꞌe pa uqꞌabꞌ ri Dios, rumal cher chirij Areꞌ kuꞌl wi kikꞌuꞌx. ");
INSERT INTO quctt_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ri Pablo rachiꞌl ri Bernabé xiꞌkꞌow chi bꞌik pa ri tinimit Pisidia xoꞌpan pa ri tinimit Panfilia. ");
INSERT INTO quctt_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Chilaꞌ xkitzijoj wi ri utzij ri Dios pa ri tinimit Perge kꞌa te riꞌ xeqaj bꞌik je laꞌ pa ri tinimit Atalia. ");
INSERT INTO quctt_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Kꞌisbꞌal rech xetzalij pa jun jukubꞌ bꞌinibꞌal puꞌwiꞌ jaꞌ xebꞌe pa ri tinimit Antioquía rech Siria, chilaꞌ xkimajij wi loq ri kibꞌinem. Chilaꞌ bꞌantal wi bꞌik chꞌawem pa kiwiꞌ kumal ri kojonelabꞌ are majaꞌ kebꞌe chutzijoxik ri utzij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Are xoꞌpan pa ri tinimit Antioquía, xeꞌkimulij konojel ri e kojonelabꞌ rech ri komontyox, xkitzijoj chike ri nimaq taq kꞌulmatajem ri xubꞌan ri Dios kukꞌ, xkitzijoj xuqujeꞌ chike jas xubꞌan ri Dios chuyaꞌik bꞌe chike ri winaq ri man aꞌj Israel taj rech kekojonik. ");
INSERT INTO quctt_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Naj kꞌut xekꞌojiꞌ kan ri Pablo rachiꞌl ri Bernabé kukꞌ ri kojonelabꞌ pa Antioquía. ");
INSERT INTO quctt_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ri Pablo rachiꞌl ri Bernabé tajin kakiya kꞌutuꞌn pa ri tinimit Antioquía rech Siria are xoꞌpan nikꞌaj achyabꞌ aꞌj pa ri tinimit Judea, xkichapleꞌj ukꞌutik chikiwach ri kojonelabꞌ chi man kekolotaj taj we man kokisax ri ketal kibꞌ jetaq ri kubꞌij ri utaqanik ri Moisés. ");
INSERT INTO quctt_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ri Pablo rachiꞌl ri Bernabé man utz taj xkita we riꞌ rumal riꞌ xkibꞌan tijoj chuqꞌabꞌ pa tzij kukꞌ ri winaq. Kꞌisbꞌal rech ri alaxik rech ri komontyox xuqujeꞌ ri kojonelabꞌ, xkichomaj xeꞌkitaq bꞌik ri Pablo rachiꞌl ri Bernabé xuqujeꞌ e nikꞌaj kojonelabꞌ chik xebꞌe chutzijoxik rij we jastaq riꞌ kukꞌ ri e taqoꞌn xuqujeꞌ kukꞌ ri kꞌamal taq bꞌe. ");
INSERT INTO quctt_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ri kojonelabꞌ rech ri komontyox xeꞌkitaq bꞌik ri taqoꞌn pa Jerusalén, pa ri kikꞌowik xeꞌkisolij kanoq ri kojonelabꞌ ri e kꞌo pa ri tinimit Fenicia, xuqujeꞌ pa ri tinimit Samaria, xkitzijoj chike chi tajin kekojon ri winaq ri man aꞌj Israel taj, ri kojonelabꞌ chilaꞌ sibꞌalaj xekiꞌkotik are xkita we riꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Are xoꞌpan ri Pablo rachiꞌl ri Bernabé pa ri tinimit Jerusalén, utz kikꞌulaxik xbꞌanik kumal ri kojonelabꞌ, ri taqoꞌn xuqujeꞌ ri kꞌamal taq bꞌe. Xkitzijoj kꞌu chike ronojel ri ubꞌanom ri Dios kukꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","E kꞌo kꞌu nikꞌaj achyabꞌ fariseos ri e kojoninaq chik che ri Cristo, xetakꞌiꞌ aqꞌanoq, xkibꞌij: Ri achyabꞌ ri man aꞌj Israel taj tzi rajawaxik wi kokisax ketal are kekojonik, xuqujeꞌ kakinimaj ri taqanik rech ri Moisés. ");
INSERT INTO quctt_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Xkimulij kꞌu kibꞌ ri taqoꞌn xuqujeꞌ ri kꞌamal taq bꞌe chuchomaxik rij we jastaq riꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Are xtzijotaj rukꞌ chuqꞌabꞌ we jastaq riꞌ, ri Pedro xtakꞌiꞌk, xubꞌij: Alaxik, iwetaꞌm chi ri Dios najtir uloq xinuchaꞌ chiꞌxoꞌl chutzijoxik ri utz laj tzij chike ri winaq ri man aꞌj Israel taj rech jeriꞌ kakitatabꞌej xuqujeꞌ kekojon che we tzij riꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ri Dios ri retaꞌm ri animaꞌaj xukꞌutu chi xuꞌkꞌamawaꞌj ri winaq ri man aꞌj Israel taj, are xuya ri Uxlabꞌixel chike jetaq ri xubꞌan chuyaꞌik chaqe uj. ");
INSERT INTO quctt_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ri Dios xuchꞌajchꞌobꞌej ri kanimaꞌ rumal ri kikojobꞌal, ri Dios man xaq xwi ta xujuchaꞌ uj xane xuchaꞌ xuqujeꞌ areꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","¿Jas kꞌu che kijunamaj iwibꞌ rukꞌ ri Dios, kiya eqaꞌn chikij nikꞌaj chik ri man xekwin ta ri qatat qanan, xuqujeꞌ man xujkwin ta uj che rukꞌaꞌxik? ");
INSERT INTO quctt_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ri uj qonojel kaqakojo chi kujkoltajik xa rumal riꞌ toqꞌobꞌ ri man taqal ta chaqe are waꞌ ri xuya chaqe ri Ajawxel Jesús. ");
INSERT INTO quctt_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Qonojel kꞌu ri winaq man xechꞌaw ta chik are xkitatabꞌej ri Pablo rachiꞌl ri Bernabé xkitzijoj ri mayijabꞌal taq kꞌulmatajik ri xubꞌan ri Dios kukꞌ are xoꞌpan kukꞌ ri winaq ri man aꞌj Israel taj. ");
INSERT INTO quctt_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Are xetoꞌtaj chutzijoxik ri xkꞌulmatajik, xtakꞌiꞌ ri Jacobo kꞌa te riꞌ xubꞌij: Chitampe na, qachalal. ");
INSERT INTO quctt_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ri Pedro xutzijoj chiꞌwe ri xubꞌan ri Dios are xuꞌsolij nabꞌe mul ri winaq ri man aꞌj Israel taj rech jeriꞌ xukꞌamawaꞌj che uꞌwinaq. ");
INSERT INTO quctt_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Are waꞌ ri tzijotal loq kumal ri e qꞌalajisal taq tzij rech ri Dios ojer ri tzꞌibꞌatalik, ri kubꞌij: ");
INSERT INTO quctt_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Are kikꞌow we jastaq riꞌ kintzalij kꞌu na loq, kinyak na ri rachoch ri David ri xtukinik, kinsukꞌumaj na ri tukininaq, kinbꞌan na kꞌakꞌ ");
INSERT INTO quctt_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","rech konojel ri achyabꞌ rech ronojel ri uwachulew xuqujeꞌ ri winaq ri man aꞌj Israel taj kaketaꞌmaj na nuwach xuqujeꞌ kuꞌx na e wech. ");
INSERT INTO quctt_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Jewaꞌ xubꞌij ri Ajawxel, Areꞌ xbꞌanowik chi xetaꞌmax loq we kꞌulmatajem riꞌ ojer. ");
INSERT INTO quctt_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Rumal laꞌ kinbꞌij in chi man kuya taj keꞌqaqꞌatej ri winaq ri man aꞌj Israel kekojon che ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Xwi qatzꞌibꞌaj chike chi man kakitij ta jastaq ri e tzujtal chikiwach ri e bꞌanom taq dios, kiqꞌila kibꞌ che mak kukꞌ taq ixoqibꞌ xuqujeꞌ achyabꞌ xuqujeꞌ man kuya taj kakitij aꞌwaj e jitzꞌam rachiꞌl kikꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Are kꞌu ri utaqanik ri Moisés tzijotal wi loq najtir pa ronojel qꞌij rech uxlanem pa ri Sinagoga kech ri aꞌj Israel. ");
INSERT INTO quctt_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ri e taqoꞌn xuqujeꞌ ri kꞌamal taq bꞌe rech ri komontyox xeꞌkichaꞌ taqoꞌn, kꞌa te riꞌ xeꞌkitaq bꞌik kukꞌ ri Pablo xuqujeꞌ ri Bernabé pa ri tinimit Antioquía rech Siria, chubꞌixik chike ri kojonelabꞌ jas jeꞌ ri xkichomaj. Ri e taqoꞌn are ri Judas (ri kabꞌix Barsabás che) rachiꞌl ri Silas, e kebꞌ kꞌamal taq bꞌe rech ri komontyox. ");
INSERT INTO quctt_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ri wuj ri xkikꞌam bꞌik kubꞌij: Uj, ri uj taqoꞌn xuqujeꞌ ri uj kꞌamal taq bꞌe rech ri komontyox, uj iwachalal uj kꞌo pa ri tinimit Jerusalén. Uj kujtzꞌibꞌan we wuj riꞌ chike ri e kojonelabꞌ ri e kꞌo pa ri tinimit Antioquía, Siria, xuqujeꞌ Cilicia. Jun rutzil iwach. ");
INSERT INTO quctt_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Xqato chi e kꞌo nikꞌaj achyabꞌ keꞌl waral are kakaj kixkisubꞌu rukꞌ taq ri kikꞌutuꞌn, man xa ta kꞌu e qataqom bꞌik. ");
INSERT INTO quctt_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Rumal riꞌ pa junamam xqachomaj keꞌqataq bꞌik e kꞌamal taq bꞌe kukꞌ ri e loqꞌalaj taq qachalal Bernabé rachiꞌl ri Pablo. ");
INSERT INTO quctt_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ri e qachalal riꞌ kiyoꞌm ri kikꞌaslemal chupatanixik ri Ajawxel Jesucristo. ");
INSERT INTO quctt_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Xeꞌqataq bꞌik ri Judas xuqujeꞌ ri Silas chuqꞌalajisaxik ri xqachomaj, rumal rech ri kꞌotbꞌal chiꞌ xibꞌan loq. ");
INSERT INTO quctt_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ri Tyoxalaj Uxlabꞌixel xuqujeꞌ ri uj man kaqaj taj kaqaya eqaꞌn chiꞌwij xaq xwi kaqaj kibꞌan we xqatzꞌibꞌaj bꞌik chiꞌwe: ");
INSERT INTO quctt_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Man kitij ta jastaq ri e tzujtal chikiwach ri e bꞌanom taq dios, man kuya taj kitij aꞌwaj e jitzꞌatalik, man kuya taj kitij kikꞌ xuqujeꞌ chiqꞌila iwibꞌ che mak kukꞌ taq ixoqibꞌ xuqujeꞌ achyabꞌ. Tajin kibꞌan ri utzilal, we kibꞌan we xqatzꞌibꞌaj chiꞌwe riꞌ. Kiwil iwibꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Aninaq xebꞌe ri taqoꞌn pa ri tinimit Antioquía, chilaꞌ xeꞌkimulij wi ri kojonelabꞌ, xkijach chike ri wuj ri xya bꞌik chike. ");
INSERT INTO quctt_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Xekiꞌkot ri e kojonelabꞌ are xsikꞌix ri wuj ri xtaq bꞌik chike. ");
INSERT INTO quctt_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Ri Judas xuqujeꞌ ri Silas e qꞌalajisal taq rech ri utzij ri Dios, naj xetzijon kukꞌ ri kojonelabꞌ xeꞌkitaqchiꞌj kejeqiꞌk pa ri kikojobꞌal. ");
INSERT INTO quctt_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Xekꞌojiꞌ kꞌu na jun janipa qꞌij chilaꞌ, kꞌa te riꞌ xetaq bꞌik kumal ri kojonelabꞌ rukꞌ tewechibꞌal xuqujeꞌ jaꞌmaril pa ri komontyox ri kꞌo pa ri tinimit Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","/Ri Silas kꞌut xraj xkanaj kan chilaꞌ./ ");
INSERT INTO quctt_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ri Pablo rachiꞌl ri Bernabé xekanaj kan pa ri tinimit Antioquía. Xkitzijoj xuqujeꞌ xkikꞌut ri utzij ri Dios. E kꞌi winaq xuqujeꞌ je xkibꞌano. ");
INSERT INTO quctt_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Are xikꞌow jun janipa qꞌij, ri Pablo xubꞌij che ri Bernabé: Jeꞌqasolij ri e tinimit ri xqatzijoj wi ri utzij ri Ajawxel, rech kaqilo jas kibꞌanik ri e kꞌakꞌ taq kojonelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Are kꞌu ri Bernabé xraj xukꞌam bꞌik ri Juan Marcos kukꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ri Pablo man xraj ta wi, rumal chi ri Juan Marcos xutas kan ribꞌ chike pa ri tinimit Panfilia, man xchakun ta chi kukꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Man xukꞌulaj ta kꞌu ribꞌ ri kichomanik rumal riꞌ xkijach kibꞌ. Ri Bernabé xukꞌam bꞌik ri Juan Marcos, xeꞌ pa Chipre. ");
INSERT INTO quctt_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ri Pablo kꞌut, are xuchaꞌ bꞌik ri Silas che rachiꞌl. Ri e kojonelabꞌ aꞌj chilaꞌ xeꞌkijach bꞌik pa uqꞌabꞌ ri Ajawxel rech kel ukꞌuꞌx chike. ");
INSERT INTO quctt_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Xikꞌow pa ronojel Siria xuqujeꞌ Cilicia, xuꞌtaqchiꞌj kan konojel ri kojonelabꞌ rech kejeqiꞌk pa ri kikojobꞌal. ");
INSERT INTO quctt_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ri Pablo xeꞌ pa ri tinimit Derbe, kꞌa te riꞌ xeꞌ pa ri tinimit Listra, chilaꞌ kꞌo wi jun ala tijoxel ubꞌiꞌnam Timoteo. Ri unan ri Timoteo jun ixoq kojonel aj Israel, ri utat aj Grecia. ");
INSERT INTO quctt_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ri e kojonelabꞌ ri keꞌl pa ri tinimit Listra xuqujeꞌ Iconio ketaꞌm chi utz ri kanoꞌjin ri Timoteo. ");
INSERT INTO quctt_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Ri Pablo xusikꞌij bꞌik ri Timoteo rech keꞌ rukꞌ, xa kꞌu nabꞌe xutaqchiꞌj rech kok bꞌi etal che rumal cher kuꞌnimaj ri winaq aꞌj Israel ri e kꞌo pa ri tinimit riꞌ xuqujeꞌ ri winaq ketaꞌm chi ri utat aj Grecia. ");
INSERT INTO quctt_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Xebꞌe kꞌu pa ronojel ri tinimit xkiya kꞌutuꞌn chike ri e kojonelabꞌ ri xkinimaj ri kꞌutuꞌn ri xya chike kumal ri uꞌtaqoꞌn ri Ajawxel xuqujeꞌ kumal ri e kꞌamal taq bꞌe rech ri komontyox ri e kꞌo pa Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Xaq jeriꞌ xejeqiꞌ pa ri kikojobꞌal, xuqujeꞌ xekꞌiyar ri kojonelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pa taq ri qꞌij riꞌ ri Dios xubꞌij chike ri Pablo rachiꞌl ri Silas chi man kakitzijoj ta ri utzij ri Dios pa taq ri leꞌaj rech Asia. Jeriꞌ xebꞌe pa Frigia xuqujeꞌ pa Galacia. ");
INSERT INTO quctt_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Are xoꞌpan pa ri kꞌulbꞌat rech Misia, xkaj xebꞌe pa Bitinia. Ri Uxlabꞌixel rech ri Jesús junmul chik man xuya ta bꞌe chike xebꞌe chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Xiꞌkꞌow kꞌu bꞌik pa ri Misia xeqaj bꞌik pa ri tinimit Troas ri kꞌo chiꞌ ri Plo. ");
INSERT INTO quctt_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Che ri chaqꞌabꞌ riꞌ, ri Dios xukꞌut cho ri Pablo chi kꞌo jun achi aj Macedonia ri kꞌo pa Grecia, tajin kusikꞌij loq ri Pablo, kubꞌij: Chatan loq jewaꞌ pa Macedonia, chujulatoꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Xaq jeriꞌ aninaq xqachomaj xujeꞌ pa ri Macedonia, xqachꞌobꞌo chi ri Dios are karaj kaqatzijoj ri utz laj tzij pa ri tinimit riꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Xujaqꞌan kꞌu bꞌik pa jun jukubꞌ bꞌinibꞌal puꞌwiꞌ jaꞌ ri kꞌo pa ri tinimit Troas, xujeꞌ pa ri chꞌaqaꞌp ulew ri sutital rumal jaꞌ ubꞌiꞌnam Samotracia, chukabꞌ qꞌij xujqꞌax pa ri tinimit Neápolis. ");
INSERT INTO quctt_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Are xujopan pa ri tinimit Filipos, jun tinimit ri kꞌo pa Macedonia, kitinimit ri aꞌj Roma, xujkanaj kan chilaꞌ jun janipa qꞌij. ");
INSERT INTO quctt_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Pa ri qꞌij rech uxlanem xujel bꞌik pa ri tinimit, xujeꞌ chuchiꞌ ri nimaꞌ chilaꞌ kakimulij wi kibꞌ nikꞌaj winaq chubꞌanik chꞌawem. Xujtꞌuyiꞌk, xujtzijon kukꞌ nikꞌaj ixoqibꞌ ri kimulim kibꞌ chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Kꞌo kꞌu jun ixoq chikixoꞌl ri winaq ubꞌiꞌ Lidia, aj pa ri tinimit Tiatira. We ixoq riꞌ kꞌayil manta ri paqal taq rajil. Ri Lidia jun qꞌijilaꞌl Dios, are tajin kutatabꞌej ri tzij ri kaqatzijoj, ri Ajawxel xujaq ri ranimaꞌ rech xukꞌamawaꞌj ri tajin kubꞌij ri Pablo. ");
INSERT INTO quctt_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Xbꞌan kꞌu uqasanaꞌ xuqujeꞌ xbꞌan kiqasanaꞌ ri e kꞌo rukꞌ pa ri rachoch. Kꞌa te kꞌu riꞌ xubꞌij chaqe: We kikojo chi qas in kojonel chik che ri Ajawxel, chixanloq wukꞌ pa ri wachoch, xujubꞌochiꞌj rech xujkanaj kan rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Jun qꞌijal kꞌut uj bꞌenaq chubꞌanik chꞌawem, xqarik jun ali aj ikꞌ kꞌo jun itzel uxlabꞌal che. Kubꞌij jas keriqitaj ri winaq, kuchꞌek nimalaj pwaq rukꞌ ri kubꞌano kꞌa te riꞌ kuya chike ri rajaw. ");
INSERT INTO quctt_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","We ali riꞌ xutereneꞌj bꞌik ri Pablo xuqujeꞌ uj, xuraq uchiꞌ xubꞌij: We achyabꞌ ri e patanil taq rech ri nimalaj Dios e petinaq waral chutzijoxik chiꞌwe jas rajawaxik kibꞌano rech kixkolotajik. ");
INSERT INTO quctt_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Kꞌi qꞌij jewaꞌ xubꞌan ri ali, xkꞌistaj kꞌu ukꞌuꞌx ri Pablo xubꞌij che ri itzel uxlabꞌal ri kꞌo che ri ali: Pa ri ubꞌiꞌ ri Jesucristo, chatel bꞌik che we ali riꞌ. Aninaqil xel bꞌik ri itzel uxlabꞌal ri kꞌo che ri ali. ");
INSERT INTO quctt_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ri e rajaw ri ali are xkilo chi ri ali makuchꞌek ta chi pwaq, xeꞌkichap ri Pablo rachiꞌl ri Silas, xeꞌkijururej, xeꞌkikꞌam bꞌik chikiwach ri e qꞌatal taq tzij ri e kꞌo pa ri kꞌayibꞌal. ");
INSERT INTO quctt_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Xubꞌe kitzujuj, jewaꞌ xkibꞌij: Konojel ri winaq ri e kꞌo pa ri tinimit yakatajinaq koyawal kumal ke we achyabꞌ aꞌj Israel. ");
INSERT INTO quctt_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Kakikꞌut naqꞌatajibꞌal ri man kuya taj kaqabꞌan uj ri uj romanos, man tzij taj ri kakibꞌij. ");
INSERT INTO quctt_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Xkimulij kꞌu kibꞌ ri winaq chikij ri Pablo rachiꞌl ri Silas, ri e qꞌatal tzij xetaqan chi resaxik ri katzꞌyaq rech kechꞌayik. ");
INSERT INTO quctt_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Sibꞌalaj kꞌi mul xechꞌayik, kꞌa te riꞌ xeꞌkikoj pa cheꞌ. Xkibꞌij che ri chajinel chi utz kubꞌan chikichajixik rech man kaꞌnimaj ta bꞌik. ");
INSERT INTO quctt_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ri chajinel, xuꞌkoj bꞌik pa ri kꞌolibꞌal jawjeꞌ qas kakiriq wi kꞌax xujatꞌij kan ri kaqan rech man kekwin taj kesalabꞌik. ");
INSERT INTO quctt_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Pa ri nikꞌaj aqꞌabꞌ ri Pablo, rachiꞌl ri Silas tajin kakibꞌan chꞌawem xuqujeꞌ kebꞌixon che ri Dios, ri winaq ri e kachiꞌl e kꞌo pa che tajin keꞌkitatabꞌej apanoq. ");
INSERT INTO quctt_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Xaq kꞌa teꞌ xubꞌan jun nimalaj kabꞌraqan ri xusalabꞌaj ri raqan ja rech ri cheꞌ, aninaq xejaqataj ri uchiꞌ. Xtꞌoqopin xuqujeꞌ ri chꞌichꞌ jatꞌibꞌal ke konojel ri winaq ri e kꞌo pa ri cheꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Are xkꞌastaj ri chajinel rech ri cheꞌ e jaqajoj ronojel ri uchiꞌ ja, xresaj kꞌu ri usakꞌibꞌal are xraj xukamisaj ribꞌ, puꞌkꞌuꞌx chi xaꞌnimaj bꞌik konojel ri e kꞌo pa ri cheꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ri Pablo kꞌut ko xuraq uchiꞌ, xubꞌij che: Man kakamisaj ta awibꞌ, qonojel uj uj kꞌo waral. ");
INSERT INTO quctt_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ri chajinel rech ri cheꞌ xtaqan chutzijik ri qꞌaqꞌ, aninaq xok bꞌik pa ri cheꞌ kabꞌiribꞌatik xukiꞌ chikiwach ri Pablo rachiꞌl ri Silas. ");
INSERT INTO quctt_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Kꞌa te riꞌ xeꞌresaj loq pa ri cheꞌ xuta chike: Achyabꞌ, ¿jas rajawaxik kinbꞌano rech kinkolotajik? ");
INSERT INTO quctt_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ri Pablo rachiꞌl ri Silas xkibꞌij che: Chatkojon che ri Ajawxel Jesucristo, rech katkolotajik xuqujeꞌ kekolotaj ri e kꞌo awukꞌ pa ri awachoch. ");
INSERT INTO quctt_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ri Pablo rachiꞌl ri Silas xkitzijoj ri utzij ri Dios che ri achi, xuqujeꞌ chike konojel ri e kꞌo pa rachoch. ");
INSERT INTO quctt_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Che ri aqꞌabꞌ riꞌ ri chajinel rech ri cheꞌ xuchꞌaj ri sokotajik chike ri Pablo rachiꞌl ri Silas. Xbꞌan kꞌu uqasanaꞌ ri achi xuqujeꞌ konojel ri e kꞌo pa rachoch. ");
INSERT INTO quctt_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Te kꞌu riꞌ xuꞌkꞌam bꞌik ri Pablo rachiꞌl ri Silas cho rachoch, xuꞌtzuqu. Konojel kꞌut xekiꞌkotik rumal xekojon che ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Are xsaqirik, ri e qꞌatal tzij xeꞌkitaq bꞌik jujun e taqoꞌn chubꞌixik che ri chajinel rech ri cheꞌ chi kutzoqopij bꞌik ri Pablo rachiꞌl ri Silas. ");
INSERT INTO quctt_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ri chajinel rech ri cheꞌ xubꞌij che ri Pablo: Ri qꞌatal taq tzij xkitaq loq ubꞌixik chwe chi kixintzoqopij bꞌik. Jix pa jaꞌmaril. ");
INSERT INTO quctt_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ri Pablo xubꞌij: Uj uj aj Roma, xujkirapuj chikiwach konojel ri winaq, man nabꞌe ta na xkiqꞌat tzij pa qawiꞌ. Chanim kꞌut are kakaj kujel bꞌik chaꞌwal, man kuya ta ri. Chepet na aꞌreꞌ, jujul kitzoqopij kan rukꞌ kiqꞌabꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Are xkita ri e qꞌatal tzij ri xbꞌix chike kumal ri e taqoꞌn, xkixiꞌj kibꞌ rumal cher xkito chi ri Pablo rachiꞌl ri Silas aꞌj Roma. ");
INSERT INTO quctt_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Xepe kꞌu ri qꞌatal taq tzij, xeꞌkita toqꞌobꞌ chike, kꞌa te riꞌ xeꞌkibꞌochiꞌj rech keꞌl bꞌik pa ri tinimit. ");
INSERT INTO quctt_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Xel kꞌu bꞌik pa ri cheꞌ, xetzalij cho rachoch ri Lidia. Xeꞌkitaqchiꞌj ri kojonelabꞌ, kejeqiꞌk pa ri kikojobꞌal, kꞌa te riꞌ xeꞌl bꞌik pa ri tinimit. ");
INSERT INTO quctt_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ri Pablo rachiꞌl ri Silas xiꞌkꞌow pa taq ri tinimit Anfípolis xuqujeꞌ pa ri tinimit Apolonia, xoꞌpan kꞌa pa ri tinimit Tesalónica, chilaꞌ kꞌo wi jun Sinagoga ke ri winaq aꞌj Israel. ");
INSERT INTO quctt_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ri Pablo naqꞌatal che, xeꞌ pa ri mulim ibꞌ pa ri Sinagoga, chilaꞌ xkꞌojiꞌ wi oxibꞌ qꞌij rech uxlanem, xutzijoj ri utzij ri Dios ri tzꞌibꞌatalik xuqujeꞌ xuꞌtaqchiꞌj ri winaq chuchꞌobꞌik rij ri tzꞌibꞌatal pa ri tyoxalaj wuj. ");
INSERT INTO quctt_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Xuqꞌalajisaj ri tzijotal loq chirij ri Mesías, chi kuriq na kꞌax xuqujeꞌ kakꞌastaj na chikixoꞌl ri kaminaqibꞌ. Xubꞌij chike: Ri Jesús ri kintzijoj chiꞌwe are Mesías. ");
INSERT INTO quctt_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","E kꞌo kꞌu jujun chike ri winaq aꞌj Israel are xkita ri xbꞌix chike, xekojonik, xoꞌk che kachiꞌl ri Pablo rachiꞌl ri Silas, xoꞌk xuqujeꞌ kukꞌ e kꞌi achyabꞌ ri man aꞌj Israel taj xuqujeꞌ ixoqibꞌ ri nim keqeleꞌn. ");
INSERT INTO quctt_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","E kꞌo kꞌu jujun chike ri winaq aꞌj Israel xpe etzelal pa kanimaꞌ rumal ri xkꞌulmatajik, xeꞌkimulij ri winaq chubꞌanik etzelal. Xoꞌk pa rachoch ri Jasón xkitzukuj ri Pablo rachiꞌl ri Silas rech keꞌkichararej loq keꞌkikꞌam la chikiwach ri winaq. ");
INSERT INTO quctt_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Man xeꞌkiriq ta kꞌut chilaꞌ. Rumal riꞌ are xkijururej bꞌik ri Jasón xuqujeꞌ nikꞌaj kojonelabꞌ chik che kikꞌexwach xeꞌkikꞌam bꞌik chikiwach ri qꞌatal tzij rech ri tinimit. Xkiraq kichiꞌ xkibꞌij: Ri Pablo rachiꞌl ri Silas tajin kakikoj kꞌaxkꞌolal chikixoꞌl ri winaq pa ronojel ri uwachulew e kꞌo kꞌu waral chanim tajin kakisach ri kichomabꞌal ri qawinaq. ");
INSERT INTO quctt_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ri Jasón xuꞌkꞌamawaꞌj we winaq ri pa ri rachoch, we winaq riꞌ uꞌkꞌulel ri César rumal cher kakinaꞌtaj jun taqanel chik ubꞌiꞌ Jesús. ");
INSERT INTO quctt_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ri winaq xuqujeꞌ ri e qꞌatal taq tzij are xkita we jastaq riꞌ man xkiriq taj jas xkibꞌano. ");
INSERT INTO quctt_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ri e qꞌatal taq tzij xkibꞌij che ri Jasón xuqujeꞌ chike ri nikꞌaj kojonelabꞌ chi rajawaxik kakitoj jun pwaq rumal ri xkibꞌano, xkitoj kꞌut, kꞌa te riꞌ xetzoqopix bꞌik. ");
INSERT INTO quctt_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Che ri chaqꞌabꞌ riꞌ, ri kojonelabꞌ xeꞌkitaq bꞌik ri Pablo rachiꞌl ri Silas pa ri tinimit Berea, are xoꞌpan chilaꞌ xeꞌbꞌe pa ri Sinagoga. ");
INSERT INTO quctt_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ri winaq ri keꞌl pa ri tinimit Berea kꞌo na xetow tzij chikiwach ri winaq ri keꞌl pa ri tinimit Tesalónica, xkita ri utz laj tzij rukꞌ kiꞌkotemal, xuqujeꞌ qꞌij chi qꞌij xkisolij ri utzij ri Dios ri tzꞌibꞌatalik rech jeriꞌ xkilo we qas tzij ri kakitzijoj ri Pablo rachiꞌl ri Silas o man tzij taj. ");
INSERT INTO quctt_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","E kꞌi kꞌu winaq aꞌj Israel xekojonik, xekojon xuqujeꞌ achyabꞌ, ixoqibꞌ, nimaꞌq keqeleꞌn ri man aꞌj Israel taj. ");
INSERT INTO quctt_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","E kꞌo kꞌu jujun winaq aꞌj Israel ri keꞌl pa ri tinimit Tesalónica, are xkito chi ri Pablo tajin kutzijoj ri utzij ri Dios pa ri tinimit Berea, xebꞌe je laꞌ xeꞌkimulij winaq rech kakibꞌan kꞌax che ri Pablo. ");
INSERT INTO quctt_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Are xkita ri kojonelabꞌ aninaq xkitaq bꞌik ri Pablo pa ri tinimit ri kꞌo chuchiꞌ ri Plo. Ri Silas kꞌut rachiꞌl ri Timoteo xekanaj kan pa ri tinimit. ");
INSERT INTO quctt_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ri Pablo xkꞌam bꞌik xeꞌyoꞌq kan pa ri tinimit Atenas kumal nikꞌaj achyabꞌ kꞌa te riꞌ xetzalij loq we achyabꞌ riꞌ chikikowixik ri Silas rachiꞌl ri Timoteo rech keꞌbꞌe rukꞌ ri Pablo chubꞌanik ri kipatan. Ri Pablo kꞌo pa ri tinimit Atenas ");
INSERT INTO quctt_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ri Pablo are e rayeꞌm apanoq ri Silas rachiꞌl ri Timoteo koꞌpanik, xbꞌisonik are xril ri kikꞌiyal ri e bꞌanom taq dios ri e kꞌo pa ri tinimit. ");
INSERT INTO quctt_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Xaq jeriꞌ xeꞌ pa ri Sinagoga xutij chuqꞌabꞌ pa tzij kukꞌ ri winaq aꞌj Israel xuqujeꞌ ri man aꞌj Israel taj ri kakixiꞌj kibꞌ cho ri Dios, xuqujeꞌ kukꞌ ri winaq ri kakimulij kibꞌ pa ri kꞌayibꞌal. ");
INSERT INTO quctt_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Xuchꞌoꞌqꞌ uwach ri kichomanik ri achyabꞌ epicúreo xuqujeꞌ estoico. ri sibꞌalaj kꞌo ketaꞌmabꞌal. Xutzijoj ri Jesús xuqujeꞌ ri ukꞌastajibꞌal wach chike, ri winaq are xkita ri xubꞌij, ri Pablo xkibꞌij: ¿Jas karaj kubꞌij we tzijonel laj achi rukꞌ ri jaljoj taq uchomanik? Nikꞌaj winaq xkibꞌij: Are kutzijoj kibꞌiꞌ e dios rech juleꞌ taq tinimit chik. ");
INSERT INTO quctt_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Xkikꞌam kꞌu bꞌik ri Pablo pa ri areópago chikiwach ri nimaq taq kꞌamal bꞌe pa ri tinimit, xkibꞌij che chatzijoj chaqe we kꞌakꞌ kꞌutuꞌn ri awukꞌaꞌm loq. ");
INSERT INTO quctt_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Jaljoj ri jastaq ri katzijoj, kaqaj kꞌut kaqato jas kel kubꞌij ri kabꞌij. ");
INSERT INTO quctt_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Ri winaq ri keꞌl pa ri tinimit Atenas, xuqujeꞌ ri kubꞌe solin pa ri tinimit riꞌ, kikꞌatik kakitzijoj rij kꞌakꞌ taq chomanik). ");
INSERT INTO quctt_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Xtakꞌiꞌ kꞌu ri Pablo chikiwach ri kꞌamal taq kibꞌe ri winaq xubꞌij: Achyabꞌ aꞌj Atenas, kinwilo chi sibꞌalaj jeqel ikꞌuꞌx chupam ri kibꞌano. ");
INSERT INTO quctt_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Are tajin kinbꞌin pa ri tinimit, xinwil ri ukꞌiyal ri kꞌolibꞌal ri kixqꞌijilaꞌn wi, cho kꞌu ri jun tzujbꞌal sipanik tzꞌibꞌatal we tzij riꞌ: “Che ri Dios ri man etaꞌmatal ta uwach.” We Dios riꞌ, ri kiqijilaꞌj ri man iwetaꞌm ta uwach, areꞌ waꞌ ri kintzijoj. ");
INSERT INTO quctt_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Are Dios ri xbꞌanow ri uwachulew, xuqujeꞌ ronojel ri kꞌo choch, are Rajaw ri kaj ulew. Areꞌ man kakꞌojiꞌ ta pa taq ri ja qꞌijilaꞌbꞌal yaktal kumal ri winaq. ");
INSERT INTO quctt_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Man kiqꞌabꞌ ta winaq kapataninik, maj urajawaxik. Rumal cher areꞌ yoꞌwinaq kikꞌaslemal xuqujeꞌ ruxlabꞌal ronojel ri kꞌolik, xuqujeꞌ uyoꞌm ri kajawataj chike. ");
INSERT INTO quctt_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Xa jun achi xukoj che kikꞌiyarisaxik ri winaq cho ri uwachulew. Kꞌamajaꞌ kutik ri achi are xuchomaj jas jeꞌ kubꞌan na jas jeꞌ kanoꞌjin na, xuqujeꞌ ri kꞌolibꞌal ri kakꞌojiꞌ wi na. ");
INSERT INTO quctt_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ri urayibꞌal ukꞌuꞌx ri Dios chike ri winaq pa ronojel tinimit are chi kakitereneꞌj ri ubꞌe ri Dios, kakitzukuj ri Dios, pune man naj taj kꞌo wi ri Dios, chaqe. ");
INSERT INTO quctt_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","“Rumal re ri Dios uj kꞌaslik, uj kꞌolik, kujsalabꞌik.” Jetaq ta ne ri xkibꞌij ri xetzꞌibꞌan ri qꞌajajem tzij iwukꞌ: “Uj uj rijaꞌl ri Dios.” ");
INSERT INTO quctt_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Saq ri xkibꞌij, rumal laꞌ man kuya taj kaqachomaj chi ri Dios, xa jun tzꞌaq ri bꞌanom kumal che qꞌana o saq pwaq kumal ri ajchakibꞌ, man che ta abꞌaj bꞌantal wi. ");
INSERT INTO quctt_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ojer kanoq ri Dios xuꞌkuy ri winaq are xkibaꞌn we jastaq riꞌ, rumal cher man kꞌo ta ketaꞌmabꞌal, kamik kꞌut kataqanik chi konojel ri winaq rech ri uwachulew, kakikꞌex kikꞌuꞌx, kakiqꞌil kibꞌ che ri kimak rech ketzalij rukꞌ Areꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Rumal chi ri Dios uchaꞌom jun achi ri jun qꞌijal kuqꞌat na tzij pa kiwiꞌ konojel ri winaq cho ri uwachulew, ri achi riꞌ xukꞌut chikiwach konojel ri winaq are xukꞌastajisaj chikixoꞌl ri kaminaqibꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","E kꞌo jujun winaq xetzeꞌnik are xkito chi ri Pablo kutzijoj chi kekꞌastaj ri kaminaqibꞌ, e kꞌo xuqujeꞌ nikꞌaj xkibꞌij: Jun qꞌijal chik katzijoj chaqe we ri. ");
INSERT INTO quctt_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Xtaniꞌ kꞌu ri Pablo che tzijonem kukꞌ ri winaq. ");
INSERT INTO quctt_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","E kꞌo kꞌu jujun winaq xoꞌk che rachiꞌl, xekojonik, xkojon xuqujeꞌ jun achi ubꞌiꞌ Dionisio, jun kꞌamal bꞌe ke ri winaq, jun ixoq ubꞌiꞌ Damaris, xuqujeꞌ nikꞌaj winaq chik. ");
INSERT INTO quctt_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Xel bꞌik ri Pablo pa ri tinimit Atenas, xeꞌ pa ri tinimit Corinto. ");
INSERT INTO quctt_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Chilaꞌ xuriq wi jun achi aj Israel ubꞌiꞌ Aquila, we achi riꞌ xalax pa ri tinimit Ponto, rachiꞌl ri rixoqil ubꞌiꞌ Priscila, we jukꞌulaj winaq riꞌ xuꞌl pa ri tinimit Corinto kipetik pa Italia rumal pa taq ri qꞌij riꞌ, ri taqanel Claudio César xtaqan chikesaxik loq konojel ri winaq aꞌj Israel ri e kꞌo pa Roma. ");
INSERT INTO quctt_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ri Pablo xkanaj kan kukꞌ ri Aquila xuqujeꞌ ri Priscila jeriꞌ rumal junam uwach ri kichak, e bꞌanal taq carpas. ");
INSERT INTO quctt_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ronojel qꞌij rech uxlanem ri Pablo xeꞌ pa ri Sinagoga chutzijoxik ri utzij ri Dios chike ri winaq aꞌj Israel xuqujeꞌ chike ri griegos. ");
INSERT INTO quctt_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Are xoꞌpan ri Silas rachiꞌl ri Timoteo pa ri tinimit Corinto kipetik pa ri tinimit Macedonia, ri Pablo are tajin karilij utzijoxik ri utzij ri Dios chike ri winaq, xuqꞌalajisaj chike chi ri Jesús are Mesías. ");
INSERT INTO quctt_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Are kꞌu ri winaq aꞌj Israel man utz taj xkito, xkikꞌululaꞌj. Ri Pablo kꞌut xutota ri ulew ri kꞌo che ri ratzꞌyaq xubꞌij: Man numak ta chi in chiꞌwe we man kixkojonik, keꞌntzijoj chi na kꞌu waꞌ ri utzij ri Dios chike ri winaq ri man aꞌj Israel taj. ");
INSERT INTO quctt_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Are xel bꞌik chilaꞌ xeꞌ cho rachoch jun achi ubꞌiꞌ Ticio Justo, kel chuxukut ri Sinagoga, ri Ticio jun achi man aj Israel taj ri kuqꞌijilaꞌj ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ri Crispo, kꞌamal bꞌe pa ri Sinagoga xuqujeꞌ ri e kꞌo rukꞌ pa rachoch, xekojon che ri Ajawxel. E kꞌi xuqujeꞌ winaq aꞌj Corinto xekojonik are xkita ri utzij ri Dios, xuqujeꞌ xbꞌan kiqasanaꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Jun chaqꞌabꞌil ri Dios xuchꞌabꞌej ri Pablo pa ri uwaram xubꞌij che: Makaxiꞌj ta awibꞌ chutzijoxik ri utzij ri Ajawxel jetaq ri abꞌanom loq. ");
INSERT INTO quctt_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Maj jachin kabꞌanow kꞌax chawe rumal in kꞌo awukꞌ, e kꞌi winaq ri e kꞌo waral kekojon na chwe. ");
INSERT INTO quctt_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ri Pablo xkanaj kan jun junabꞌ rukꞌ nikꞌaj pa ri tinimit riꞌ xukꞌut ri utzij ri Dios chikiwach ri winaq. ");
INSERT INTO quctt_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","E kꞌo kꞌu nikꞌaj winaq aꞌj Israel xewaꞌjil chrij ri Pablo xkikꞌam bꞌik cho ri qꞌatal tzij Galión, taqanel pa Acaya che taq ri qꞌij riꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Xkitzujuj ri Pablo chi tajin kuꞌtaqchiꞌj ri winaq chuqꞌijilaꞌxik ri Dios pa jun bꞌeal ri man kubꞌij ta ri taqanik. ");
INSERT INTO quctt_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ri Pablo kꞌut xuchapleꞌj utoꞌik ribꞌ, ri Galión xubꞌij chike ri winaq tzujunelabꞌ: Chitampe na achyabꞌ winaq aꞌj Israel, we ta qas nimaꞌt ri kubꞌan we achi riꞌ, kumajo kinqꞌat tzij puꞌwiꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Xa kꞌu we xaq tzij, bꞌiꞌaj, rech ri itaqanik ix winaq aꞌj Israel, ri kutzijoj, chiwila ix jas kibꞌan che. Man kawaj ta in kinqꞌat tzij puꞌwiꞌ we jastaq riꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Xeꞌresaj kꞌu loq pa ri qꞌatbꞌal tzij. ");
INSERT INTO quctt_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ri winaq kꞌut xkichap ri Sóstenes, kꞌamal bꞌe pa ri Sinagoga, xkichꞌey chilaꞌ pa ri qꞌatbꞌal tzij, ri Galión maj jas xubꞌij chike. ");
INSERT INTO quctt_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Ri Pablo kꞌut xkanaj kan kꞌi qꞌij pa ri tinimit Corinto, kꞌa te riꞌ xuꞌya kan ri kojonelabꞌ ri e kꞌo chilaꞌ, xeꞌ pa ri tinimit Cencrea, man naj ta kꞌo wi che ri tinimit Corinto. Chilaꞌ xusakꞌij wi ronojel ri uwiꞌ jetaq ri naqꞌatajibꞌal ke ri winaq aꞌj Israel retal chi kubꞌan na jun jastaq ri utzujum ubꞌanik, kꞌa te riꞌ xuꞌkam bꞌik ri Priscila rachiꞌl ri Aquila xebꞌe pa ri tinimit Siria. ");
INSERT INTO quctt_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Xiꞌkꞌow kꞌu na bꞌik chuchiꞌ ri jaꞌ pa ri tinimit Éfeso, xuꞌya kan nikꞌaj winaq chilaꞌ, xuqujeꞌ xeꞌ na pa ri Sinagoga xtzijon kukꞌ ri winaq aꞌj Israel. ");
INSERT INTO quctt_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ri winaq aꞌj Israel xkibꞌochiꞌj ri Pablo kakanaj kan kukꞌ kebꞌ oxibꞌ qꞌij chi na. Man xraj ta kꞌut. ");
INSERT INTO quctt_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Are kꞌu jubꞌiqꞌ karaj keꞌek, xubꞌij kan chike: We karaj ri Dios, kintzalij la waꞌ. Xel kꞌu bꞌik pa ri tinimit Éfeso. ");
INSERT INTO quctt_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Xikꞌow xuqujeꞌ bꞌik chuchiꞌ ri jaꞌ rech ri tinimit Cesarea, kꞌa te riꞌ xpaqiꞌk xuꞌsolij kan ri komontyox ri kꞌo pa ri tinimit Jerusalén. Kꞌa te riꞌ xtzalij pa ri tinimit Antioquía. ");
INSERT INTO quctt_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Are xtoꞌtaj bꞌik pa ri Antioquía, xikꞌow bꞌik pa Galacia, xuqujeꞌ pa Frigia, xuꞌsolij xuqujeꞌ xuꞌtaqchiꞌj kan ri kojonelabꞌ rech kejeqiꞌk pa ri kikojobꞌal. Ri Apolos kutzijoj ri utzij ri Dios pa Éfeso ");
INSERT INTO quctt_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Pa taq ri qꞌij riꞌ xopan jun achi aj Israel pa ri tinimit Éfeso ubꞌiꞌ Apolos, we achi riꞌ upetik pa ri tinimit Alejandría rech Egipto. Sibꞌalaj kanaꞌwik kachꞌawik, xuqujeꞌ retaꞌm ri utzij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Kꞌuttal choch ri kꞌutuꞌn rech ri Ajawxel. Xuya mayijabꞌal kꞌutuꞌn rech ri Jesús chike ri winaq, xaq xwi kꞌu retaꞌm ri qasanaꞌ ri xubꞌan ri Juan. ");
INSERT INTO quctt_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ri Priscila rachiꞌl ri Aquila are xkito tajin kutzijoj ri utzij ri Dios pa ri Sinagoga rukꞌ chuqꞌabꞌ, xkisikꞌij utukel xkibꞌij che ri ubꞌel usukꞌ ri utzij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Kꞌa te riꞌ ri Apolos xuchomaj keꞌ pa Acaya, ri alaxik kojonelabꞌ xkitaqchiꞌj rech keꞌek. Xkitaq bꞌik jun wuj chike ri kojonelabꞌ ri keꞌl pa Acaya, xkitzꞌibꞌaj chike chi we xopan ri Apolos utz kibꞌana chukꞌamawaꞌxik. Ri Apolos are xopanik, sibꞌalaj kꞌo xutayij chike ri kojonelabꞌ ri e kojoninaq rumal ri utoqꞌobꞌ ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Xretzelaj uwach ri kichomabꞌal ri winaq aꞌj Israel, chikiwach konojel ri winaq. Xukoj ri wuj tzꞌibꞌatalik chuqꞌalajisaxik chikiwach chi ri Jesús are Mesías. ");
INSERT INTO quctt_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ri Apolos kꞌo pa ri tinimit Corinto, are kꞌu ri Pablo xikꞌow pa taq tinimit ri naqaj e kꞌo wi, kꞌa te riꞌ xopan pa ri tinimit Éfeso, chilaꞌ xuꞌriq wi e kꞌi kojonelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Xuta chike: ¿La xikꞌamawaꞌj ri Tyoxalaj Uxlabꞌixel are xixkojonik? Man xqakꞌamawaꞌj taj, xechaꞌ. Man e qetaꞌm taj we kꞌo Tyoxalaj Uxlabꞌixel. ");
INSERT INTO quctt_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","¿Jachin chike qasanaꞌ xikꞌamawaꞌj ix? Are ri qasanaꞌ rech ri Juan, xecha che. ");
INSERT INTO quctt_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ri Pablo xubꞌij chike: Ri qasanaꞌ ri xubꞌan ri Juan, xubꞌano rech kakikꞌex kikꞌuꞌx ri winaq che kimak xubꞌij kꞌu chike ri winaq chi rajawaxik kekojon che ri kape na, ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Are xetoꞌtaj chutatabꞌexik ri xbꞌix chike, xbꞌan kiqasanaꞌ pa ri ubꞌiꞌ ri Ajawxel Jesús. ");
INSERT INTO quctt_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Are xuya ri uqꞌabꞌ ri Pablo pa kiwiꞌ, xqaj ri Tyoxalaj Uxlabꞌixel pa kiwiꞌ, xechꞌaw pa juleꞌ taq chꞌabꞌal chik, xuqujeꞌ xkiqꞌalajisaj ri utzij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","E kabꞌlajuj achyabꞌ chkonojel. ");
INSERT INTO quctt_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Ri Pablo oxibꞌ ikꞌ xtzijonik xuqujeꞌ xmenkꞌetinik chirij ri ajawarem rech ri Dios pa ri Sinagoga. ");
INSERT INTO quctt_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","E kꞌo jujun man xkaj taj xekojon che ri utzij ri Jesús, xkichapleꞌj ubꞌixik itzel taq jastaq chike ri kojonelabꞌ chikiwach konojel ri winaq. Rumal riꞌ, ri Pablo xel bꞌik pa ri Sinagoga, xuꞌkꞌam bꞌik ri kojonelabꞌ, amaqꞌel, xtzijon kukꞌ pa ri ja tijobꞌal re ri achi ubꞌiꞌnam Tirano. Xuchoqꞌ uwach ri xbꞌix che. ");
INSERT INTO quctt_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Kebꞌ junabꞌ jewaꞌ xkꞌulmatajik xaq jeriꞌ ri winaq aꞌj Israel xuqujeꞌ ri winaq ri man aꞌj Israel taj ri e kꞌo pa taq ri tinimit rech Asia, xkitatabꞌej ri utzij ri Ajawxel. ");
INSERT INTO quctt_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ri Dios kꞌut xuya kwinem che ri Pablo kubꞌan nimaq taq kꞌutbꞌal xuqujeꞌ kunanik. ");
INSERT INTO quctt_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ri yawabꞌibꞌ kekunatajik are kaya ri kisuꞌt xuqujeꞌ chꞌuqbꞌal taq kichꞌek chirij ri Pablo xuqujeꞌ ri itzel taq uxlabꞌal keꞌl bꞌik chike. ");
INSERT INTO quctt_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Kꞌo kꞌu jun wok winaq aꞌj Israel ri kewaꞌkat pa taq kiꞌ tinimit, keꞌkesaj itzel taq uxlabꞌal, kakikoj ri ubꞌiꞌ ri Ajawxel Jesús, kakibꞌij: Pa ri ubꞌiꞌ ri Jesús ri kutzijoj ri Pablo, katqesaj bꞌik itzel uxlabꞌal. ");
INSERT INTO quctt_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ri kebꞌanow we riꞌ are ri e wuqubꞌ ralkꞌwaꞌl ri Esceva, jun pare kꞌamal bꞌe. ");
INSERT INTO quctt_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Junmul kꞌut are xkaj jewaꞌ xkibꞌano, ri itzel uxlabꞌal xubꞌij chike: Wetaꞌm uwach ri Jesús, xuqujeꞌ wetaꞌm jachin riꞌ ri Pablo, ¿ix jachin kꞌu ri ix? ");
INSERT INTO quctt_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ri achi kꞌut ri kꞌo itzel uxlabꞌal che, xukꞌyaq ribꞌ chikij rukꞌ chꞌuꞌjilal, xkixiꞌxitej kꞌu kibꞌ, xkiriq kꞌax xuqujeꞌ kechꞌanchꞌatik xebꞌe cho kachoch. ");
INSERT INTO quctt_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","We kꞌulmatajik riꞌ xetaꞌmataj kumal konojel ri winaq ri e kꞌo pa ri tinimit Éfeso, winaq aꞌj Israel, xuqujeꞌ winaq ri man aꞌj Israel taj, konojel xkixiꞌj kibꞌ, rumal riꞌ xkinimarisaj uqꞌij ri Ajawxel Jesús. ");
INSERT INTO quctt_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","E kꞌi chike ri winaq ri xekojonik, xkitzujuj kibꞌ che ri man utz taj ri kibꞌanom kan nabꞌe. ");
INSERT INTO quctt_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","E kꞌi xuqujeꞌ chike ri kakibꞌan kan itzinik nabꞌe xkikꞌam loq ri kiwuj ri rech itzibꞌal, xkiporoj chkiwach konojel ri winaq. Ri rajil ri wuj ri xkiporoj, are kawinaq lajuj mil qꞌana pwaq. ");
INSERT INTO quctt_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","E kꞌi winaq xekojonik rumal ronojel ri xkꞌulmatajik. ");
INSERT INTO quctt_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ri Pablo xuchomaj kisolixik ri tinimit rech Macedonia, rech Acaya, are majaꞌ keꞌ pa ri tinimit Jerusalén. Xuchomaj chi we xtoꞌtaj pa Jerusalén, rajawaxik keꞌ pa ri tinimit Roma. ");
INSERT INTO quctt_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Xuꞌtaq kꞌu bꞌik ri Timoteo rachiꞌl ri Erasto, kebꞌ chike ri ketobꞌan rukꞌ, xebꞌe pa Macedonia. Are kꞌu ri areꞌ xkanaj kan jun janipa qꞌij pa Asia. ");
INSERT INTO quctt_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Pa taq ri qꞌij riꞌ xchapleꞌtaj jun chꞌoꞌj chkixoꞌl ri winaq pa ri tinimit Éfeso rumal ri utz laj tzij rech ri kꞌakꞌ taq tzij. ");
INSERT INTO quctt_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Kꞌo kꞌu jun achi ubꞌiꞌ Demetrio. Jun chꞌayal chꞌichꞌ ri kubꞌan alaj taq ja che saq pwaq karesaj uwach ri rachoch ri Diana ri kidios ri winaq aꞌj Éfeso, nima pwaq kakichꞌek ri achyabꞌ ri kechakun rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ri Demetrio xuꞌmulij ajchakibꞌ, xuqujeꞌ nikꞌaj achyabꞌ ri junam kichak rukꞌ, xubꞌij chike: Iwetaꞌm chi nim tajin kiqachꞌek chrij we chak riꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Kiwil bꞌa ri achi Pablo, kubꞌij chi we tzꞌaq riꞌ e winaq e bꞌanowinaq man e dios taj. Man xwi ta kꞌu ukojom kikꞌuꞌx ri winaq pa Éfeso, xane ukojom kikꞌuꞌx konojel ri winaq ri e kꞌo pa ri tinimit Asia. ");
INSERT INTO quctt_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","We man nim chik kilik ri templo rech ri Diana, kasach uwach waꞌ we qakꞌay, sibꞌalaj kꞌax riꞌ. Man kaya ta chi kꞌu uqꞌij we nimalaj dios ri kaqꞌijilax kumal konojel ri winaq aꞌj Asia, xuqujeꞌ kumal konojel ri winaq ri e kꞌo cho ri uwachulew. ");
INSERT INTO quctt_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ri winaq are xkita ri xbꞌix chike, sibꞌalaj xpe koyawal, xkiraq kichiꞌ, xkibꞌij: ¡Nim uqꞌij ri Diana ri kidios ri aꞌj Éfeso! ");
INSERT INTO quctt_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Konojel ri winaq ri e kꞌo pa ri tinimit xkikꞌyaq kibꞌ chikij ri Gayo, xuqujeꞌ ri Aristarco are waꞌ ri achyabꞌ aꞌj Macedonia e rachiꞌl ri Pablo. Ri winaq xeꞌkicharchatej bꞌik xeꞌkikꞌam bꞌik pa ri kꞌolibꞌal ri kakimulij wi kibꞌ ri winaq. ");
INSERT INTO quctt_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Ri Pablo are xraj xok bꞌik chikixoꞌl ri winaq, ri kojonelabꞌ man xkiya ta bꞌe che. ");
INSERT INTO quctt_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","E kꞌo xuqujeꞌ jujun qꞌatal tzij rech ri tinimit Asia, kech chꞌabꞌeꞌn ri Pablo, xkitaq ubꞌixik che chi man kok ta chkixoꞌl ri winaq. ");
INSERT INTO quctt_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ri winaq ri kimulim kibꞌ xkiraq kichiꞌ, xkibꞌij jaljoj taq jastaq. E kꞌi chike man ketaꞌm taj jas che kimulim kibꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Kꞌo kꞌu jun achi aj Israel chilaꞌ ubꞌiꞌ Alejandro, xkichꞌikmayij bꞌik rech kubꞌij jas tajin kakꞌulmatajik. Ri Alejandro xuyak ri uqꞌabꞌ rech man kechꞌaw ta na ri winaq. ");
INSERT INTO quctt_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ri winaq are xkichꞌobꞌo chi ri Alejandro aj Israel, konojel xkiraq kichiꞌ, xkibꞌij: ¡Nim uqꞌij ri Diana, ri kidios ri aꞌj Éfeso! ");
INSERT INTO quctt_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Xpe kꞌu jun qꞌatal tzij rech ri tinimit xkwinik xuꞌtanabꞌa ri winaq, xubꞌij chike: Achyabꞌ aꞌj Éfeso, konojel ri winaq ketaꞌm chi we tinimit Éfeso are e chajil re ri utemplo ri qadios Diana, ri utzꞌaqil xa xqaj loq chikaj. ");
INSERT INTO quctt_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Qetaꞌm kꞌut chi man kꞌo ta jun ri mat retaꞌm. Xaq jeriꞌ makiyak ta chꞌoꞌj, qas chichomaj na ri kibꞌano. ");
INSERT INTO quctt_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","We achyabꞌ we iꞌkꞌamom loq man kꞌo ta jun awas kibꞌanom, maj jastaq keleqꞌam pa ri templo, man e yoqꞌoꞌwinaq ta che ri qaDiana, ri qadios. ");
INSERT INTO quctt_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ri Demetrio xuqujeꞌ ri rajchakibꞌ we kꞌo kichꞌoꞌj rukꞌ jachinaq, are kipatan ri qꞌatal taq tzij xuqujeꞌ ri qꞌatbꞌal taq tzij ri e kꞌolik. Chilaꞌ jeꞌkibꞌij wi jachike ri kꞌo pa kanimaꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","We kꞌo chi ne jun jastaq ri kiwaj, kuyaꞌo kibꞌij chaqe rech kaqamulij qibꞌ chuchomaxik. ");
INSERT INTO quctt_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Xibꞌibꞌal riꞌ we kabꞌix chaqe chi xa man kujniman ta chike ri ketaqan pa qawiꞌ, xa rumal ri xbꞌantaj waral kamik. Jas kꞌu kaqabꞌij riꞌ we xta chaqe ri xkꞌulmataj kamik qetaꞌm uj chi man kꞌo ta rumal. ");
INSERT INTO quctt_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Are xtoꞌtaj ri qꞌatal tzij chubꞌixik we tzij riꞌ xuꞌtaq bꞌik ri winaq cho taq kachoch. ");
INSERT INTO quctt_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Are xtaniꞌ ri tzukun chꞌoꞌj, ri Pablo xuꞌsikꞌij ri kojonelabꞌ rech jeriꞌ kuꞌpixibꞌaj, xuqujeꞌ kukubꞌisaj kikꞌuꞌx. Kꞌa te riꞌ xuꞌchꞌabꞌej kanoq, xeꞌ pa Macedonia. ");
INSERT INTO quctt_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Xuꞌpixabꞌaj kꞌu ri aꞌlaxik ri e kꞌo pa taq ri tinimit ri xikꞌow wi. Xuꞌtaqchiꞌj ri kojonelabꞌ kejeqiꞌk pa ri kikojobꞌal. Kꞌisbꞌal re xopan pa ri tinimit Grecia. ");
INSERT INTO quctt_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Oxibꞌ ikꞌ xkꞌojiꞌ chilaꞌ. Are jubꞌiqꞌ karaj keꞌ pa jun jukubꞌ bꞌinibꞌal puꞌwiꞌ jaꞌ rech keꞌ pa ri tinimit Siria, xuto chi ri winaq aꞌj Israel tajin kakichomaj ubꞌanik kꞌax che, rumal riꞌ xtzalij kan pa ri tinimit Macedonia. ");
INSERT INTO quctt_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Xachiꞌlax kꞌu bꞌik kumal ri Sópater aj Berea, ri Aristarco, ri Segundo aj Tesalónica, ri Gayo aj Derbe, ri Timoteo, xuqujeꞌ ri Tíquico, xuqujeꞌ ri Trófimo e kojonelabꞌ aꞌj Asia. ");
INSERT INTO quctt_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","We achyabꞌ riꞌ xenabꞌej bꞌik, xujkayeꞌj apanoq pa ri tinimit Troas. ");
INSERT INTO quctt_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Are xikꞌow ri nimaqꞌij Pascua xujel bꞌik pa ri tinimit Filipos xujeꞌ pa jun jukubꞌ bꞌinibꞌal puꞌwiꞌ jaꞌ, are ikꞌowinaq chi jobꞌ qꞌij, xubꞌeꞌqariqaꞌ pa ri tinimit Troas. Wuqubꞌ qꞌij kꞌut xujkanaj kan chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Pa ri nabꞌe qꞌij rech ri wuqubꞌ qꞌij xqamulij qibꞌ rech junam kujwaꞌik, naꞌtabꞌal rech ri ukamikal ri Ajawxel Jesús. Ri Pablo kꞌut xutzijoj ri utzij ri Dios chike ri kojonelabꞌ, naj xtzijonik kꞌa xuꞌriqa na ri nikꞌaj aqꞌabꞌ rumal cher chukabꞌ qꞌij kel bꞌik chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Chilaꞌ uj kꞌo wi pa ri ja ri kꞌo chi kawiq. Kꞌi qꞌaqꞌ tunal e tzijitzoj. ");
INSERT INTO quctt_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Kꞌo kꞌu jun ala ubꞌiꞌ Eutico, tꞌuyul pa ri wentaꞌn pa ri urox wiq ja. Ri ala sibꞌalaj kꞌax uwaram, rumal riꞌ xtzaq loq pa ri ulew, xkamik. ");
INSERT INTO quctt_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Xqaj kꞌu loq ri Pablo, xumatzej ri ala, xuchꞌelej, kꞌa te riꞌ xubꞌij chike ri winaq: Mixiꞌj iwibꞌ, we ala riꞌ kꞌaslik. ");
INSERT INTO quctt_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ri Pablo xpaqiꞌ chi junmul pa ri ja, xwaꞌ kukꞌ ri kojonelabꞌ, kꞌa te riꞌ xtzijon chi na kukꞌ junmul kꞌa xsaqir na, kꞌa te riꞌ xeꞌek. ");
INSERT INTO quctt_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Xkikꞌam kꞌu bꞌi ri ala cho rachoch kꞌaslik. Konojel kꞌut sibꞌalaj xekiꞌkotik. ");
INSERT INTO quctt_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ri Pablo cho ulew xeꞌ pa ri tinimit Asón, uj xujeꞌ pa jun jukubꞌ bꞌinibꞌal puꞌwiꞌ ri jaꞌ, xqachomaj chi kaqakꞌam bꞌi ri Pablo pa riꞌ ri tinimit riꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Are xqariq ri Pablo, xok bꞌik qukꞌ pa ri jukubꞌ bꞌinibꞌal puꞌwiꞌ jaꞌ. Junam xujeꞌ pa ri tinimit Mitilene. ");
INSERT INTO quctt_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Chukabꞌ qꞌij qelik bꞌik chilaꞌ xujeꞌ je laꞌ pa Quío. Che ri jun qꞌij chik xujeꞌ chuchiꞌ ri jaꞌ ubꞌiꞌ Samos; xujikꞌow bꞌi pa Trogilio, kꞌa te riꞌ chukabꞌ qꞌij xujopan pa Mileto. ");
INSERT INTO quctt_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Ri Pablo kꞌut xuchomaj chi man kikꞌow ta bꞌik pa ri tinimit Éfeso rech man kabꞌeyetaj taj pa Asia. Jeriꞌ rumal cher karaj karikꞌowisaj ri Pentecostés pa ri tinimit Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Are uj kꞌo chi pa ri tinimit Mileto, ri Pablo xtaqan che kisikꞌixik ri kꞌamal taq bꞌe rech ri komontyox ri kꞌo pa ri tinimit Éfeso rech katzijon kukꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Are xoꞌpan ri kꞌamal taq bꞌe xubꞌij chike: Iwetaꞌm jas jeꞌ in noꞌjininaq che ri qꞌij are xinul waral pa Asia kꞌa kamik. ");
INSERT INTO quctt_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ronojel qꞌij are xinkꞌojiꞌ iwukꞌ xinpatanij ri Ajawxel Jesús, man xinnimarisaj ta wibꞌ. Rukꞌ oqꞌej xinbꞌan ri nuchak iwukꞌ, xuqujeꞌ xinriq kꞌi uwach kꞌaxkꞌolal rumal ronojel ri xkibꞌan ri winaq aꞌj Israel chwe. ");
INSERT INTO quctt_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Pune jeriꞌ, xintzijoj ri utzij ri Dios chiꞌwe pa taq iwachoch xuqujeꞌ pa taq ri nimaq taq kꞌolibꞌal xinya ronojel uwach kꞌutuꞌn ri kajawataj chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Xinbꞌij chike konojel ri winaq aꞌj Israel xuqujeꞌ ri man aꞌj Israel taj rajawaxik chi rajawaxik kakikꞌex kikꞌuꞌx, kakikꞌex kichomanik cho ri Dios, xuqujeꞌ kakiya kan ri kimak, rech kekojon che ri Ajawxel Jesucristo. ");
INSERT INTO quctt_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Kamik kꞌut kineꞌ pa ri tinimit Jerusalén. Rajawaxik kinniman che ri Tyoxalaj Uxlabꞌixel ri in taqowinaq loq. Man wetaꞌm ta kꞌut jas ri kabꞌan na chwe chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Xwi wetaꞌm ri ubꞌim ri Uxlabꞌixel chwe pa ronojel ri tinimit chi kinokisax na pa cheꞌ xuqujeꞌ kinriq na kꞌax are kintzalij pa Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Man kinok ta kꞌu il cho we kꞌaxkꞌolal riꞌ, xuqujeꞌ man are ta qas nim kinwil wi. Are kawaj kinkꞌis ri nuchak ri nutaqem rech kinopan pa ri kꞌisbꞌal rech ri nukꞌaslemal rukꞌ kiꞌkotem xuqujeꞌ kintoꞌtaj chutzijoxik ri utzij ri Dios, chike ri winaq, are waꞌ chilibꞌetal chwe rumal ri Ajawxel Jesús. Kinbꞌij chike ri winaq chi ri Dios sibꞌalaj kutoqꞌobꞌisaj kiwach konojel. ");
INSERT INTO quctt_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Kamik kꞌut qas wetaꞌm chi man kꞌo ta jun chiꞌwech, ri nutzijom ri utzij ri Dios che ri karil chi na nuwach junmul chik. ");
INSERT INTO quctt_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Rumal riꞌ kamik kinbꞌij chiꞌwe chi man kꞌo ta numak chiꞌwe we kiriq jun alik kamikal. ");
INSERT INTO quctt_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Rumal cher xinya ubꞌixik chiꞌwe ronojel ri uchomam ri Dios pa qawiꞌ. Man kꞌo ta jun kꞌutuꞌn ri mat xinya chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Chichajij bꞌa iwibꞌ, xuqujeꞌ chiꞌchajij ri qachalal kojonelabꞌ. Rumal chi ri Uxlabꞌixel xubꞌan kꞌamal taq bꞌe chiꞌwe chiꞌchajij bꞌa konojel ri qachalal ri e kojoninaq che ri Ajawxel Jesús, ri xkam cho ri ripbꞌal, xuya ri ukikꞌel rech jeriꞌ ri winaq kakiriq ri utobꞌanik ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Wetaꞌm chi we xinel bꞌik iwukꞌ, kepe na achyabꞌ ri kakibꞌan na kꞌax chike ri kojonelabꞌ, je kakibꞌan na itzel taq kayoꞌt ri keꞌkitij chij. ");
INSERT INTO quctt_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Kekꞌojiꞌ kꞌu na jujun achyabꞌ e bꞌanal taq tzij chiꞌxoꞌl, keꞌkitijoj na ri winaq che bꞌanoj tzij, keꞌkimenkꞌetij kꞌu na e kꞌi kojonelabꞌ kukꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Rumal bꞌa riꞌ, chixkꞌasloq, naꞌtaj chiꞌwe chi oxibꞌ junabꞌ, chi paqꞌij chi chaqꞌabꞌ, man xintaniꞌ ta che ipixabꞌaxik rukꞌ oqꞌej. ");
INSERT INTO quctt_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Kamik kꞌut, qachalal, kixinjach kan puꞌqꞌabꞌ ri Dios rech man kasachan ta ri utzij ri Dios ri kukꞌut chiqawach chi sibꞌalaj nim ri utoqꞌobꞌ pa qawiꞌ. We tzij riꞌ kakwinik kuya ichuqꞌabꞌ, xuqujeꞌ kuya ri iwechabꞌal junam kukꞌ konojel ri e rech ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Man are ta ri irajil man are ta riꞌ iwatzꞌyaq xinrayij. ");
INSERT INTO quctt_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Qas iwetaꞌm chi xinchakun chuchꞌekik ronojel ri xajawataj chwe, xuqujeꞌ ri xajawataj chike ri e kꞌo wukꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Nukꞌutum chiꞌwach chi rajawaxik kujchakunik chuchꞌekik ri kajawataj chaqe, rech jeriꞌ kujkwinik keꞌqatoꞌ ri kꞌo kirajawaxik. Xinnaꞌtaj chiꞌwe chi ri utzij ri Ajawxel Jesús ri kubꞌij: “Are utz re ri winaq ri kasipanik cho ri winaq ri kakꞌamawaꞌnik.” ");
INSERT INTO quctt_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Are xbꞌiꞌtaj we tzij riꞌ rumal ri Pablo, xukiꞌk, xubꞌan chꞌawem kukꞌ konojel ri kojonelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Kꞌa te riꞌ sibꞌalaj xoꞌqꞌik. Ri aꞌlaxik xkimatzej ri Pablo xuqujeꞌ xkitzꞌumaj. ");
INSERT INTO quctt_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ri aꞌlaxik xkachiꞌlaj bꞌik ri Pablo rukꞌ loqꞌanik xekijacha kanoq pa jun jukubꞌ bꞌinibꞌal. Are xoꞌpan chuchiꞌ ri jaꞌ xoꞌqꞌik, xkimatzej ri Pablo. Sibꞌalaj xebꞌisonik rumal xubꞌij chike chi man kakil ta chi wi uwach junmul chik. ");
INSERT INTO quctt_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Are xqajach qibꞌ kukꞌ ri alaxik, xujok pa ri jukubꞌ bꞌinibꞌal puꞌwiꞌ jaꞌ, sukꞌum xujeꞌ pa leꞌaj sutital che jaꞌ ubꞌiꞌnam Cos. Chukabꞌ qꞌij xujqꞌax chik pa ri tinimit Rodas, kꞌa te riꞌ xujeꞌ pa ri tinimit Pátara. ");
INSERT INTO quctt_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Xqariq kꞌu jun jukubꞌ bꞌinibꞌal ri kꞌo pa Pátara ri keꞌ pa Fenicia, xujeꞌ chupam. ");
INSERT INTO quctt_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Are xujqꞌax pa ri plo, xqil apanoq pa ri qamox ri chꞌaqaꞌp ulew sutital che jaꞌ ubꞌiꞌ Chipre, xqataqej ri qabꞌe, xujopan je laꞌ pa Tiro ri kꞌo pa Siria xujikꞌow na chilaꞌ rumal chi ri jukubꞌ bꞌinibꞌal xuya na nikꞌaj jastaq chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Xeꞌqariq kꞌu jujun kojonelabꞌ chilaꞌ, xujkanaj kan wuqubꞌ qꞌij kukꞌ. E kꞌo kꞌu e kojonelabꞌ ri xkiqꞌalajisaj jastaq ri xubꞌij ri Uxlabꞌixel chike, rumal riꞌ xkibꞌij che ri Pablo chi man keꞌ ta pa ri tinimit Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Are xtzꞌaqat wuqubꞌ qꞌij uj kꞌo kukꞌ ri kojonelabꞌ, xujel bꞌik pa ri tinimit Tiro. Konojel ri kojonelabꞌ, ri achyabꞌ, ri e kixoqil, xuqujeꞌ ri e kalkꞌwaꞌl xujeꞌkijacha kanoq. Are xujopan chuchiꞌ ri plo xujxukiꞌk, xqbꞌan chꞌawem cho ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Kꞌa te riꞌ xeꞌqamatzej kanoq kꞌa te riꞌ xujtzalij pa ri jukubꞌ bꞌinibꞌal, ri aꞌlaxik kꞌut xetzalij kan cho kachoch. ");
INSERT INTO quctt_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Ri uj xqataqej ri qabꞌe pa ri plo, qelik loq pa ri tinimit Tiro xujopan pa ri tinimit Tolemaida. Xqaya rutzil kiwach ri qachalal ri e kꞌo chilaꞌ xuqujeꞌ xujkanaj kan jun qꞌij kukꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Chukabꞌ qꞌij ri Pablo xuqujeꞌ ri uj xujel bꞌik pa Tolemaida, xujeꞌ pa ri tinimit Cesarea, are uj kꞌo chi chilaꞌ xujeꞌ cho rachoch ri Felipe, tzijol rech ri Utz laj uTzij ri Dios, jun chike ri wuqubꞌ patanijelabꞌ ri xechaꞌ pa Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ri Felipe e kꞌo kajibꞌ umiꞌal ri man e kꞌulan taj. We alitomabꞌ riꞌ e qꞌalajisal taq rech ri utzij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Kebꞌ oxibꞌ qꞌij chik uj kꞌo chilaꞌ, are xopan jun qꞌalajisal rech ri utzij ri Dios, ubꞌiꞌ Agabo upetik pa ri tinimit Judea. ");
INSERT INTO quctt_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Xujuchꞌabꞌej, kꞌa te riꞌ xukꞌam ri ximbꞌal upam ri Pablo, xuxim ri raqan xuqujeꞌ ri uqꞌabꞌ rukꞌ, xubꞌij: Ri Tyoxalaj Uxlabꞌixel kubꞌij are kopan ri ajchoqꞌe we pas riꞌ pa ri tinimit Jerusalén, jewaꞌ kakibꞌan na ri winaq aꞌj Israel chuyutik. Kakijach na pa kiqꞌabꞌ ri winaq ri man aꞌj Israel taj. ");
INSERT INTO quctt_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Are xqata we tzij riꞌ, uj e qachiꞌl ri winaq aꞌj Cesarea xqabꞌochiꞌj ri Pablo rech man keꞌ ta pa Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ri Pablo kꞌut xubꞌij: ¿Jas che kixoqꞌik, xaq kiyak nubꞌis? Ri in nujachom wibꞌ, man xwi taj pa yutik, xane nujachom wibꞌ pa kamikal rumal rech ri ubꞌiꞌ ri Ajawxel je laꞌ pa ri tinimit Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Man xujkwin ta kꞌut xqaqꞌatej, xaq xqaya chi jeriꞌ, Xwi xqabꞌij che: ¡Chubꞌana ri urayibꞌal ukꞌuꞌx ri Ajawxel awukꞌ! ");
INSERT INTO quctt_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Are ikꞌowinaq chi kebꞌ oxibꞌ qꞌij, xqasukꞌumaj ri qajastaq xujeꞌ pa ri tinimit Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Xujkachiꞌlaj bꞌik jujun kojonelabꞌ aꞌj Cesarea. Jun chike ubꞌiꞌ Mnasón kel pa Chipre. Ojer laj kojonel, qachomam kꞌut chi kujkanaj kan rukꞌ cho ri rachoch. ");
INSERT INTO quctt_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Are xujopan pa ri tinimit Jerusalén, xujkikꞌulaj ri qachalal, sibꞌalaj xekiꞌkot qukꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Chukabꞌ qꞌij xeꞌ ri Pablo qukꞌ, xujeꞌ kꞌu chuchꞌabꞌexik ri Jacobo. Kimulim kꞌu kibꞌ konojel ri kꞌamal taq kibꞌe ri kojonelabꞌ rech Jerusalén chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ri Pablo xuya rutzil kiwach konojel, kꞌa te riꞌ xutzijoj ronojel ri ubꞌanom ri Dios chkixoꞌl ri winaq ri man aꞌj Israel taj. ");
INSERT INTO quctt_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Are xkita ri xubꞌij, xkiya uqꞌij ri Dios. Xkibꞌij che ri Pablo: Jeꞌ, qachalal. Pune ta ne jeriꞌ, e kꞌi mil winaq aꞌj Israel e kojoninaq. Kakibꞌij chi rajawaxik wi kaqataqej u ubꞌanik ri kubꞌij ri utaqanik ri Moisés. ");
INSERT INTO quctt_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Bꞌiꞌtal kꞌu chike we winaq riꞌ chi ri at tajin kaꞌtijoj konojel ri winaq aꞌj Israel chi man rajawaxik ta chik keꞌniman che ri xtaqan wi ri qamam Moisés. Xuqujeꞌ kakibꞌij chi kabꞌij chi man rajawaxik taj kokisax ketal xuqujeꞌ man rajawaxik taj kakaꞌn ri naqꞌatajibꞌal ke ri winaq aꞌj Israel. ");
INSERT INTO quctt_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","¿Jas kꞌu kaqabꞌano? Kakimulij na kibꞌ riꞌ ri winaq are kakito chi at ulinaq waral. ");
INSERT INTO quctt_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Are utz na we kabꞌan ri kaqabꞌij: e kꞌo kajibꞌ achyabꞌ qukꞌ ri kakaꞌn na jas ri xkitzuj u ubꞌanik cho ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Chaꞌkꞌama bꞌik we achyabꞌ riꞌ awukꞌ pa ri Templo, are kakesaj ri awas chikij, chabꞌana awe kukꞌ. Chaya ri pwaq ri rajawaxik chike rech kekwinik kakisokaj ri kiwiꞌ rech konojel kakilo chi man qas tzij ta riꞌ ri kabꞌix chawe, xane at kanimaj ri kubꞌij ri utaqanik ri Moisés. ");
INSERT INTO quctt_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Are kꞌu ri winaq ri e kojoninaq ri man aꞌj Israel taj, qatzꞌibꞌam bꞌik wuj chike, qabꞌim chike chi rajawaxik man kakitij ta ri tiꞌj ri yoꞌm chkiwach taq tyox ri xa e bꞌanom kumal winaq, man kakitij ta kikꞌ, man kakitij ta ki tiꞌjol awaj e jitzꞌatalik, xuqujeꞌ man kakaꞌn ta mak kukꞌ taq achyabꞌ xuqujeꞌ ixoqibꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Xpe kꞌu ri Pablo, xuꞌkꞌam bꞌik kajibꞌ achyabꞌ rukꞌ. Chukabꞌ qꞌij xresaj ri awas chirij junam kukꞌ, kꞌa te riꞌ xok pa ri Templo chubꞌixik chike janipa qꞌij karaj na chi resaxik ri awas chikij, are kakitzuj aꞌwaj chi kijujunal cho ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Jubꞌiqꞌ kꞌu karaj katzꞌaqat ri wuqubꞌ qꞌij, e kꞌo jujun winaq aꞌj Israel e petinaq pa ri tinimit Asia ri xkil ri Pablo kꞌo pa ri Templo. Xeꞌkimulij ri winaq, xkikoj kikꞌuꞌx, ");
INSERT INTO quctt_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","xkiraq kichiꞌ, xkibꞌij: ¡Achyabꞌ aꞌj Israel! ¡Chujitoꞌ! We achi riꞌ kawaꞌkat pa ronojel taq ri tinimit. Kuya kꞌutuꞌn chike ri winaq puꞌwi ri man utz taj kakibꞌan ri qawinaqil, chrij ri utaqanik ri Moisés, xuqujeꞌ chrij we loqꞌalaj ja riꞌ. Uꞌkꞌamom kꞌu bꞌik jujun winaq aꞌj Grecia ri man e qawinaqil taj pa ri Templo, ubꞌanom ri awas ubꞌanik pa we loqꞌalaj kꞌolibꞌal riꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Je xkibꞌij waꞌ rumal cher kilom chi ri Pablo kꞌo pa ri tinimit Jerusalén, rachiꞌl ri Trófimo aj Éfeso, man aj Israel taj. Pa kikꞌuꞌx kꞌut chi xukꞌam bꞌik pa ri Templo. ");
INSERT INTO quctt_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Konojel ri winaq pa ri tinimit Jerusalén xeꞌl chꞌuꞌj. Aninaq xkimulij kibꞌ, xkichap ri Pablo, xkichararej loq chupam ri Templo, xkitzꞌapij kꞌu kan ri uchiꞌ ri tinimit. ");
INSERT INTO quctt_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Tajin kakitzukuj jas kakibꞌan chukamisaxik are xuta ri achi, ri kinimal ri ajchꞌoꞌjabꞌ chajil tinimit aꞌj Roma, chi konojel ri winaq pa ri tinimit Jerusalén e chꞌuꞌjarinaq. ");
INSERT INTO quctt_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ri nim taqanel riꞌ xuꞌmulij jujun aꞌj chꞌoꞌjabꞌ chajil tinimit, xuqujeꞌ jujun chike ri kinimal taq ri aꞌj chꞌoꞌjabꞌ chajil tinimit, aninaq xebꞌe jawjeꞌ e kꞌo wi ri winaq. Are xkil ri winaq ri nim taqanel e rachiꞌl ri ajchꞌoꞌjabꞌ chajil tinimit, xkitanabꞌaꞌ uchꞌayik ri Pablo. ");
INSERT INTO quctt_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Xpe kꞌu ri achi riꞌ ri kataqan pa kiwiꞌ ri aꞌj ajchꞌoꞌjabꞌ chajil tinimit, xuꞌchapa ri Pablo. Kꞌa te riꞌ xtaqan chuyutik rukꞌ kebꞌ chꞌichꞌ ximbꞌal. Xuta kꞌu chike ri winaq jachin riꞌ ri Pablo, xuqujeꞌ jas ri umak. ");
INSERT INTO quctt_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Are kꞌu ri winaq xkiraq kichiꞌ, jaljoj ri kakibꞌij. Ri achi man xkwin ta chuchꞌobꞌik jas ri xkꞌulmatajik rumal cher man kꞌyaqal ta ri kakibꞌij. Xtaqan kꞌu bꞌik chukꞌamik ri Pablo pa ri ja ri e kꞌo wi ri aꞌj ajchꞌoꞌjabꞌ chajil tinimit. ");
INSERT INTO quctt_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Are xoꞌpan cho taq ri wiq rech ri ja, ri aꞌj ajchꞌoꞌjabꞌ chajil tinimit ri e kꞌamowinaq bꞌik ri Pablo xkitelej, xkipaqabꞌaꞌ, rumal cher konojel ri winaq kakaj kakesaj kan ri Pablo rech kakichꞌayo. ");
INSERT INTO quctt_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Konojel kꞌu ri winaq ri e teren chikij kakiraq kichiꞌ, kakibꞌij: ¡Kamisaxoq! ");
INSERT INTO quctt_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Are xkꞌam bꞌik ri Pablo pa ri ja ri e kꞌo wi ri aꞌj ajchꞌoꞌjabꞌ chajil tinimit, xuta che ri achi ri kataqan pa kiwiꞌ, xubꞌij: ¿La utz kintzijon jubꞌiqꞌ ukꞌ la? Ri achi xuta che, xubꞌij: ¿La awetaꞌm katchꞌaw pa chꞌabꞌal griego? ");
INSERT INTO quctt_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","¿La man at riꞌ ri achi, ri at aj Egipto, ri chi kebꞌ oxibꞌ qꞌij xwaꞌjil chirij ri qꞌatbꞌal tzij, kꞌa te riꞌ xuꞌmulij kajibꞌ mil achyabꞌ kamisanelabꞌ, xukꞌam bꞌik pa ri juyubꞌ ri katzꞌinowik? ");
INSERT INTO quctt_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Xubꞌij kꞌu ri Pablo che: In in jun chike ri winaq aꞌj Israel, xinalax pa ri tinimit Tarso, jun tinimit rech Cilicia ri nim u ubꞌanik. Bꞌana la jun toqꞌobꞌ chwe, ya la bꞌe chwe kenchꞌabꞌej ri winaq. ");
INSERT INTO quctt_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ri achi xuya bꞌe che ri Pablo, ri Pablo kꞌut xtakꞌiꞌ puꞌwiꞌ taq ri wiq, xuyak ri uqꞌabꞌ chkiwach ri winaq rech man kechꞌaw taj. Are xetaniꞌ ri winaq, ri Pablo xuchꞌabꞌej pa ri tzijobꞌal hebreo, xubꞌij: ");
INSERT INTO quctt_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Loqꞌalaj taq qachalal, ix ix kꞌamal taq qabꞌe, chitampe ri kinbꞌij chiꞌwe. ");
INSERT INTO quctt_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Are xkita ri winaq chi ri Pablo xuꞌchꞌabꞌej pa ri tzijobꞌal hebreo, xaq jun xekꞌojiꞌ wi, xkitatabꞌej ri kubꞌij: ");
INSERT INTO quctt_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Ri in in iwinaqil, in aj Israel. Xinalax pa ri tinimit Tarso, tinimit rech Cilicia. Waral kꞌut pa Jerusalén xinkꞌiy wi. Qas utz nutijoxik xbꞌanik puꞌwiꞌ ri taqanik ke ri qamam ojer rumal ri nim achi Gamaliel amaqꞌel xintij nuchuqꞌabꞌ chupatanixik ri Dios, jetaq ri kibꞌan ix iwonojel kamik. ");
INSERT INTO quctt_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nabꞌe kanoq in xinbꞌan kꞌax chike konojel ri e kojoninaq che ri Jesús, xwaj xeꞌnkamisaj. Xeꞌnchap bꞌik achyabꞌ, ixoqibꞌ, xeꞌnkoj pa cheꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ri kinimal chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq xuqujeꞌ konojel ri kinimaꞌqil ri winaq kekwinik kakiqꞌalajisaj chi qas tzij ri kinbꞌij. Rumal cher aꞌreꞌ xkiya bꞌik jujun wuj chwe. Xaq jeriꞌ xineꞌ pa ri tinimit Damasco xubꞌentzukuj ri kojonelabꞌ rech keꞌnchapo, keꞌnkꞌam loq waral pa Jerusalén, chukꞌajisaxik kiwach. ");
INSERT INTO quctt_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Bꞌenam kꞌu we pa ri bꞌe, opanem kinbꞌan pa ri tinimit Damasco, qas pa ri nikꞌaj qꞌij, xaq kꞌa teꞌ xtunan jun nimalaj tunal chwij ri xpe chikaj. ");
INSERT INTO quctt_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Xintzaq puꞌlew, kꞌa te riꞌ xinta jun chꞌabꞌal xpe chikaj xubꞌij chwe: Saulo, Saulo, ¿jas che kabꞌan we nimalaj kꞌax riꞌ chwe? ");
INSERT INTO quctt_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“¿Jachin ri lal, Tat?” xincha che. Xubꞌij chwe: In riꞌ ri Jesús aj Nazaret. Ri tajin kabꞌan kꞌax chwe. ");
INSERT INTO quctt_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ri e kꞌo wukꞌ xkil ri tunal, sibꞌalaj kꞌu xkixiꞌj kibꞌ. Man xkita ta kꞌu ri uchꞌabꞌal ri tajin kachꞌaw wukꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ri in kꞌut xinbꞌij: Tat, ¿jas kaj la kinbꞌano? Xubꞌij kꞌu ri Ajawxel Jesús chwe: Chatwaꞌjiloq, chataqej ri abꞌe ri ke pa ri tinimit Damasco. Chilaꞌ kꞌut kabꞌix wi na chawe jas ri rajawaxik kabꞌano. ");
INSERT INTO quctt_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Man xinkwin ta chi kꞌut xinkaꞌyik rumal ri tunal, ri sibꞌalaj kajuluwik. Rumal riꞌ xa xintzuyex bꞌik che ri nuqꞌabꞌ kumal ri wachiꞌl, xinkikꞌam bꞌik pa ri tinimit Damasco. ");
INSERT INTO quctt_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Kꞌo kꞌu jun achi chilaꞌ, ubꞌiꞌ Ananías. Kojoninaq che ri Dios, kunimaj ri utaqanik ri Moisés. Konojel ri winaq aꞌj Israel ri e kꞌo chilaꞌ pa Damasco kakibꞌij chi sibꞌalaj utz we achi riꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","We achi riꞌ xopan che nuchꞌabꞌexik, xubꞌij kꞌu chwe: “Wachalal Saulo, chatkaꞌy chi junmul.” Aninaq kꞌut xutzir ri nubꞌoqꞌoch, xinkwinik xinkaꞌyik, xinwil ri achi. ");
INSERT INTO quctt_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Xubꞌij kꞌu chwe: “At chaꞌtal rumal ri qaDios, ri kiDios ri qamam, rech kawetaꞌmaj jas ri urayinik, xuqujeꞌ rech katuxik patanil rech ri Dios, xuqujeꞌ rech kata ri chꞌabꞌal. ");
INSERT INTO quctt_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Katok kꞌu na che qꞌalajisal rech ri Dios chkiwach ri winaq, katzijoj na ronojel ri atom xuqujeꞌ awilom. ");
INSERT INTO quctt_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Jas kꞌu awayeꞌm, chatwaꞌjiloq, chabꞌana aqasanaꞌ jeqel akꞌuꞌx chrij ri Ajawxel Jesús, chata toqꞌobꞌ che rech kasach taj ri amak, kachꞌajchꞌojir kꞌu ri awanimaꞌ.” ");
INSERT INTO quctt_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Ri Pablo xubꞌij: Are xintzalij loq pa we tinimit Jerusalén, xineꞌ kꞌu pa ri Templo. Tajin kinbꞌan chꞌawem chilaꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Pa jun kꞌutbꞌal kꞌut xinwil ri Ajawxel Jesús, xubꞌij chwe: “Chakowij, chatel bꞌik chanim waral pa Jerusalén, rumal chi ri winaq ri e kꞌo waral man kakikoj ta ri nutzij ri kabꞌij chike.” ");
INSERT INTO quctt_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ri in kꞌut xinbꞌij che: “Ajawxel, aꞌreꞌ ketaꞌm chi nabꞌe kanoq xineꞌ pa taq ri Sinagoga. Xeꞌnchap konojel ri kekojon che la, xeꞌnkoj pa cheꞌ, xuqujeꞌ xeꞌnchꞌayo. ");
INSERT INTO quctt_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Are tajin kakikamisaj ri Esteban ri patanil e la, ri kaqꞌalajisan tzij la, ri in in kꞌo kukꞌ. Sibꞌalaj utz kꞌut xinwilo xkamisaxik, in xinchajin ri katzꞌyaq ri tajin kekamisanik.” ");
INSERT INTO quctt_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ri Ajawxel Jesús xubꞌij chwe: “Jat, rumal cher rajawaxik katintaq bꞌik naj kukꞌ ri nikꞌaj winaq chik ri man aꞌj Israel taj.” ");
INSERT INTO quctt_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Are xubꞌij ri Pablo chike ri winaq aꞌj Israel, chi keꞌ kukꞌ ri winaq ri man aꞌj Israel taj, xkichap uraqik kichiꞌ, xkibꞌij: ¡Kamisax we achi riꞌ! ¡Man yaꞌtal ta che kakꞌasiꞌk! ");
INSERT INTO quctt_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Xkichapleꞌj uraqik kichiꞌ, xkiroqij ri katzꞌyaq pa ri ulew, xkijopij ulew chikaj. ");
INSERT INTO quctt_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Ri achi ri kataqan pa kiwiꞌ ri ajchꞌoꞌjabꞌ chajil tinimit xuya taqanik rech kokisax ri Pablo pa ri ja ri e kꞌo wi ri ajchꞌoꞌjabꞌ chajil tinimit, xuqujeꞌ xuya taqanik rech karapuxik, kꞌa te riꞌ kakꞌot uchiꞌ rech kubꞌij jas rumal ri winaq kakiraq kichiꞌ chrij. ");
INSERT INTO quctt_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Are kꞌu yuttal chik rech kakichꞌayo, ri Pablo xubꞌij che ri kinimal ri ajchꞌoꞌjabꞌ chajil tinimit ri takꞌal chilaꞌ chuchajixik: ¿La yaꞌtal chiꞌwe kichꞌay jun winaq rech ri tinimit Roma, la man nabꞌe kaqꞌat tzij puꞌwiꞌ? ");
INSERT INTO quctt_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Are xuta ri ajchꞌoꞌj chajil tinimit ri xubꞌij ri Pablo, xuꞌbꞌij che ri achi ri kataqan pa kiwiꞌ ri ajchꞌoꞌjabꞌ chajil tinimit: ¿Jas ri tajin kabꞌan che we achi riꞌ? Areꞌ jun winaq rech ri tinimit Roma. ");
INSERT INTO quctt_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ri achi ri kataqan pa kiwiꞌ ri ajchꞌoꞌjabꞌ chajil tinimit xeꞌ rukꞌ ri Pablo, xuta che: ¿La qas tzij chi at aj Roma? Ri Pablo xubꞌij: Jeꞌ, qas tzij. ");
INSERT INTO quctt_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ri ajchꞌoꞌj chajil tinimit xubꞌij che ri Pablo: Ri in xintoj nimalaj pwaq rech xya nuwuj rumal ri tinimit Roma. Ri Pablo xubꞌij: Ri in, in aj Roma pa nukꞌojiꞌkal. ");
INSERT INTO quctt_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ri ajchꞌoꞌjabꞌ chajil tinimit man xkichꞌay ta chi ri Pablo. Are kꞌu ri achi ri kataqan pa kiwiꞌ ri ajchꞌoꞌjabꞌ chajil tinimit, are xretaꞌmaj chi ri Pablo aj Roma, sibꞌalaj xuxiꞌj ribꞌ rumal cher xujatꞌij rukꞌ chꞌichꞌ jatꞌibꞌal. ");
INSERT INTO quctt_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ri achi ri kataqan pa kiwiꞌ ri ajchꞌoꞌjabꞌ chajil tinimit xraj xretaꞌmaj jas ri qas umak ri Pablo, ri tajin kakibꞌij ri winaq aꞌj Israel che. Xaq jeriꞌ chukabꞌ qꞌij xresaj ri chꞌichꞌ ximbꞌal che ri Pablo, kꞌa te riꞌ xtaqan che ki mulixik ri kinimaꞌqil ri chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq aꞌj Israel xuqujeꞌ konojel ri kinimaꞌqil ri winaq. Xresaj kꞌu loq ri Pablo, xutakꞌabꞌa chkiwach. ");
INSERT INTO quctt_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Xuꞌkaꞌyej ri Pablo ri kinimaꞌqil ri qꞌatal taq tzij, xuchapleꞌj ubꞌixik: Alaxik, amaqꞌel nukꞌaslebꞌem chꞌojchꞌojlaj chomabꞌal cho ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Aninaq, ri Ananías, kinimaꞌqil ri chꞌawenelabꞌ cho ri Dios, xuꞌtaq ri e kꞌo chunaqaj ri Pablo kakichꞌay puꞌchiꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Xubꞌij kꞌu ri Pablo che: Chatuchꞌaya at ri Dios, kawach, ¿jas uwach qꞌatal tzij katuxik we at kaqꞌipij ri taqanik kattaqan che nuchꞌayik? ");
INSERT INTO quctt_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Xkibꞌij ri e kꞌo chunaqaj ri Pablo: ¿Jeriꞌ kabꞌan chukꞌululaꞌxik ri kinimaꞌqil ri chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq? ");
INSERT INTO quctt_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Chikuyuꞌ, alaxik. Man wetaꞌm taj chi are kinimaꞌqil chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq. Kubꞌij ri tzꞌibꞌatalik, maj jun kawetzelaj chike ri kꞌamal taq bꞌe rech ri atinimit. ");
INSERT INTO quctt_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Xril ri Pablo chi ri e kꞌamal taq bꞌe rech ri Tinimit e kꞌo saduceos xuqujeꞌ fariseos chike. Xuraq uchiꞌ, xubꞌij: Alaxik, in xuqujeꞌ in Fariseo, jacha ri watiꞌt numam. In kꞌo pa ri uqꞌabꞌ ri qꞌatbꞌal tzij rumal chi kuꞌl na kꞌuꞌx che ri kꞌastajibꞌal kiwach ri kaminaqibꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Are jewaꞌ xubꞌij. Ri achyabꞌ fariseos xuqujeꞌ ri e saduceos xoꞌk pa chꞌoꞌj. ");
INSERT INTO quctt_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Rumal chi ri achyabꞌ saduceos man kakikoj taj chi kꞌo kꞌastajibꞌal wach, man kakikoj taj chi e kꞌo angelibꞌ, man kakikoj taj chi e kꞌo taq uxlabꞌal. Are kꞌu ri achyabꞌ fariseos kakikojo chi e kꞌo taq waꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Xaq jeriꞌ xkꞌulmataj chꞌoꞌj chikixoꞌl, xewaꞌjil kꞌu jujun chike ri aꞌjtijabꞌ rech ri taqanik, ri e fariseos, xkichapleꞌj uyajik kibꞌ, ko xkichꞌabꞌej kibꞌ, xkibꞌij: Maj etzelal kaqarik uj che we achi riꞌ wine jun uxlabꞌal o jun ángel chꞌabꞌeninaq man kaqakꞌopij ta qibꞌ cho ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Xril ri qꞌatal tzij chi xnimataj ri chꞌoꞌj chikixoꞌl, pukꞌuꞌx chi kakipil ri Pablo. Xuꞌsikꞌij ri ajchꞌoꞌjabꞌ chajil taq rech ri tinimit, xtaqanik chi kakesaj bꞌik chikixoꞌl, kakitzalij pa ri ja rech qꞌatbꞌal tzij. ");
INSERT INTO quctt_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Che ri chaqꞌabꞌil riꞌ, xukꞌut ribꞌ ri Ajawxel cho ri Pablo, xubꞌij che: Chabꞌana achuqꞌabꞌ Pablo, jacha ri xabꞌan chi nuqꞌalajisaxik pa Jerusalén je kabꞌan na che nuqꞌalajisaxik je laꞌ pa ri tinimit Roma. ");
INSERT INTO quctt_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Saqir chukabꞌ qꞌij, xkimulij kibꞌ jupuq achyabꞌ aꞌj Israel, xkijunamaj kitzij, qas tzij xekꞌojiꞌk xkibꞌij chi man kewaꞌ ta na xuqujeꞌ man ke qumun ta na kꞌa kakamisataj na ri Pablo kumal. ");
INSERT INTO quctt_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Kikꞌow na cho kawinaq ri kikꞌiyal ri kamisanelabꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Xeꞌkikꞌutu kibꞌ chikiwach ri e kꞌamal taq bꞌe kech ri chꞌawenelabꞌ cho ri Dios xuqujeꞌ ri e kꞌamal taq bꞌe xkibꞌij che: Ri uj qabꞌim chi qaj etzelal pa qawiꞌ xuqujeꞌ man kaqatij ta qawa we man nabꞌe kaqakamisaj ri Pablo. ");
INSERT INTO quctt_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Xaq jeriꞌ ri ix xuqujeꞌ ri ix unimaꞌqil qꞌatal tzij rajawaxik kibꞌij che ri qas kabꞌan rech chi kakꞌam chi bꞌik junmul ri Pablo chikiwach ri qꞌatal taq tzij, chijaluj chi xa kiwaj kiwilo jas qas ubꞌanik ri umak, kꞌa majoꞌq kꞌu kopan cho ri qꞌatbꞌal tzij, are keqakamisaj. ");
INSERT INTO quctt_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Xretaꞌmaj kꞌu ri chꞌut ukꞌojol ri Pablo, ral ri ranabꞌ, ri kichomanik, xeꞌ pa ri ja rech qꞌatbꞌal tzij xuꞌtzijoj che ri Pablo. ");
INSERT INTO quctt_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Xtaqan ri Pablo che usikꞌixik jun chike ri ajchakibꞌ rech ri qꞌatbꞌal tzij rech ri tinimit Roma, xubꞌij che chakꞌama bꞌik we ala riꞌ rukꞌ ri unimal ri qꞌatal tzij. Kubꞌij jun utaqkil che: Choqꞌaqꞌ rij. ");
INSERT INTO quctt_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Jaꞌe, xchaꞌ. Ri ajchak rech ri qꞌatbꞌal tzij xuꞌya ubꞌixik. “Xinusikꞌij ri Pablo ri kꞌo pa cheꞌ, xubꞌij chwe chi kinkꞌam loq ukꞌ la we ala riꞌ, kulubꞌij jun utaqkil che la.” ");
INSERT INTO quctt_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ri qas kabꞌan rech pa kiwiꞌ ri ajchakibꞌ rech ri qꞌatbꞌal tzij xutzuyej bꞌik ri ala che ri uqꞌabꞌ, xkiqꞌat bꞌi kibꞌ xaq aꞌreꞌ, xuta che: ¿Jas ri kawaj kabꞌij chwe? ");
INSERT INTO quctt_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ri ala xubꞌij: Nikꞌaj achyabꞌ aꞌj Israel kakaj kakibꞌij che la chi kakꞌam la bꞌik ri Pablo chikiwach ri uꞌnimaꞌqil qꞌatal taq tzij, kakijaluj chi xa kakikꞌot uchiꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ma kimenkꞌetij la, rumal chi kawinaq ri kaꞌjilabꞌ ri achyabꞌ ri kawom kibꞌ pa taq ri bꞌe, xaq kayeꞌm uqꞌatexik ri Pablo, rech kakikamisaj. Xwi kayeꞌm jas ri kabꞌij la. ");
INSERT INTO quctt_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Maj bꞌa jun ketaꞌman ri xabꞌij chwe, xcha ri qꞌatal tzij che ri ala. ");
INSERT INTO quctt_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Ri nim qꞌatal tzij xuꞌsikꞌij kebꞌ uꞌtaqoꞌn ri kabꞌan ke pa kiwiꞌ ri ajchꞌoꞌjabꞌ chajil taq tinimit. Xubꞌij chike chi kewok lajujkꞌal 200 ajchꞌoꞌjabꞌ chajil taq tinimit rech kebꞌe je laꞌ pa ri tinimit Cesarea, bꞌelej qꞌotaj okinaq ri aqꞌabꞌ rech kamik, che kikꞌamaꞌ bꞌik lajujkꞌal 200 aꞌjtzꞌijtzꞌaq taq chꞌichꞌ chꞌoꞌjibꞌal, xuqujeꞌ oxkꞌal lajuj ajkejabꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Cheyoꞌq bꞌik kikej ri kekꞌamow bꞌik ri Pablo rech jeriꞌ utz uwach kopan rukꞌ ri qꞌatal tzij Félix. ");
INSERT INTO quctt_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Kꞌa te riꞌ xutzꞌibꞌaj bꞌik we wuj riꞌ che ri qꞌatal tzij. ");
INSERT INTO quctt_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Ri Claudio Lisias: Kutaq rutzil wach la nimalaj reqeleꞌn qꞌatal tzij, Félix. ");
INSERT INTO quctt_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Achyabꞌ e winaq aꞌj Israel xkichap we achi riꞌ, raj xkikamisaj are xinopanik e wachiꞌl ri ajchꞌoꞌjabꞌ chajil taq tinimit, xinwetaꞌmaj kꞌut chi we achi riꞌ aj Roma, xintoꞌo xinqꞌaxaj pa jun kꞌolibꞌal ri maj keqelenik. ");
INSERT INTO quctt_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Kꞌa te riꞌ xinkꞌam bꞌik chikiwach ri uꞌnimaꞌqil qꞌatal taq tzij kech ri winaq aꞌj Israel, chi rilik jas rumal kakitzujuj. ");
INSERT INTO quctt_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Xinwetaꞌmaj chi ri umak xaq rumal taq taqanik rech ri kinaqꞌatajibꞌal aꞌreꞌ aꞌj Israel. Man taqal ta kꞌut kok pa cheꞌ xuqujeꞌ maj kamikal chirij. ");
INSERT INTO quctt_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Are xbꞌix chwe chi xkimulij kibꞌ chukamisaxik, aninaq xintaq bꞌik che la. Xinbꞌij chike ri xetzujun chwe, chi jeꞌ kiya ubꞌixik ri umak che la. ");
INSERT INTO quctt_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Xaq jeriꞌ che we chaqꞌabꞌil riꞌ, jacha we xintaqan wi, ri ajchꞌoꞌjabꞌ chajil taq tinimit xkikꞌam bꞌik ri Pablo kꞌa pa ri tinimit Antípatris. ");
INSERT INTO quctt_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Saqir chukabꞌ qꞌij xetzalij ri ajchꞌoꞌjabꞌ chajil tinimit pa ri ja ri e kꞌo wi xwi xeꞌkiya kan ri xebꞌe chirij kej rech xebꞌe rukꞌ ri Pablo. ");
INSERT INTO quctt_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Xoꞌpan kꞌu pa ri tinimit Cesarea, xkijach ri Pablo cho ri qꞌatal tzij Félix xuqujeꞌ xkijach ri wuj. ");
INSERT INTO quctt_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Xusikꞌij kꞌu uwach ri wuj ri qꞌatal tzij kꞌa te riꞌ xuta che ri Pablo: ¿Jas tinimit kape wi? Pa ri Cilicia kinpe wi, xcha ri Pablo. ");
INSERT INTO quctt_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Kinta riꞌ jas ri amak we xuꞌlik ri winaq ri e tzujul taq awe, xcha ri qꞌatal tzij che. Kꞌa te riꞌ xtaqan ri qꞌatal tzij chi kayak ri Pablo pa ri cheꞌ rech ri ja kꞌolibꞌal kech ri ajchꞌoꞌjabꞌ chajil taq tinimit rech ri nim taqanel Herodes. ");
INSERT INTO quctt_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Jobꞌ qꞌij chik ikꞌowinaq are xqaj bꞌik ri Ananías kinimaꞌqil ri chꞌawenelabꞌ cho ri Dios, e rachiꞌl jujun taq kinimaꞌqil ri tinimit, xuqujeꞌ ri Tértulo, jun qꞌaxal tzij cho ri qꞌatal tzij, xebꞌe pa ri tinimit Cesarea, chuqꞌalajisaxik ri umak ri Pablo cho ri qꞌatal tzij. ");
INSERT INTO quctt_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Xokisataj bꞌik ri Pablo cho ri qꞌatal tzij, xpe ri Tértulo xuchapleꞌj utzujuxik, xubꞌij: Tyox che la nimalaj qꞌatal tzij, kariqom jaꞌmaril, jororemal, rukꞌ ri etaꞌmabꞌal la, sibꞌalaj utz rilik utayik ri tinimit bꞌanom la xuqujeꞌ kꞌi sukꞌumam la che ri taqanik. ");
INSERT INTO quctt_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Rumal cher ronojel ri bꞌanom la, kujtyoxin che la nimalaj qꞌatal tzij Félix. ");
INSERT INTO quctt_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Chintatabꞌextaj la man naj taj kintzijon ukꞌ la, rech man kaqꞌitajta la. ");
INSERT INTO quctt_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Xqariqo chi we achi riꞌ jun bꞌanal kꞌax, kojol chꞌoꞌj chikixoꞌl ri winaq aꞌj Israel, cho ronojel ri uwachulew ri e kꞌo wi winaq, kꞌamal bꞌe rech ri kꞌutuꞌn rech ri jun achi aj Nazaret. ");
INSERT INTO quctt_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Qas kok chubꞌanik etzelal pa ri Templo are xqachapo, xqaj kꞌut xqaqꞌat tzij puꞌwiꞌ jetaq ri kubꞌij ri qataqanik. ");
INSERT INTO quctt_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Xopan kꞌu ri Lisias, ri kinimaꞌqil ri ajchꞌoꞌjabꞌ chajil tinimit, rukꞌ chuqꞌabꞌ xumaj loq pa qaqꞌabꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Xqabꞌij kꞌu chike ri e tzujul taq rech chi kepe choch la, kꞌotompe la uchiꞌ rech qas ketaꞌmaj la jastaq ri umak ri kaqatzujuj wi che la. ");
INSERT INTO quctt_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Xkimulij kibꞌ konojel ri winaq aꞌj Israel ri e kꞌo chilaꞌ, xkibꞌij: Qas je wi riꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Xuya kꞌu bꞌe ri qꞌatal tzij che ri Pablo rech kachꞌawik. Xubꞌij kꞌu ri Pablo: Wetaꞌm chi sibꞌalaj kꞌi chi junabꞌ lal okinaq che qꞌatal tzij rech we tinimit riꞌ, rukꞌ ronojel nukꞌux kintoꞌ wibꞌ choch la. ");
INSERT INTO quctt_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Qas kuyaꞌo ketaꞌmaj la chi jewaꞌ chi kabꞌlajuj qꞌij xinpaqiꞌ je laꞌ pa Jerusalén chuqꞌijilaꞌxik ri Dios pa ri Templo. ");
INSERT INTO quctt_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Man xinriqitaj taj chi in yakal chꞌoꞌj kukꞌ taq ri winaq, pa ri Templo, pa ri Sinagoga, xa ta ne pa ri tinimit. ");
INSERT INTO quctt_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Maj jutzꞌit laj kꞌutbꞌal rech ri numak kakibꞌan choch la. ");
INSERT INTO quctt_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Kinqꞌalajisaj cho la, chi ri in in kojoninaq che waꞌ we Bꞌe we kakibꞌij aꞌreꞌ che chi xaq jun naqꞌatajibꞌal, kinpatanij ri Dios kech ri watiꞌt numam. Nukojom ronojel ri jastaq ri kubꞌij ri taqanik, xuqujeꞌ ronojel ri jastaq ri kitzꞌibꞌam loq ri e qꞌaxal taq utzij ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Wayeꞌm che ri Dios rukꞌ ukuꞌlibꞌal kꞌuꞌx jacha ri kayeꞌm aꞌreꞌ, chi kꞌo kꞌastajibꞌal wach chike konojel ri winaq chi sukꞌ chi man sukꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Rumal waꞌ amaqꞌel nuchajim wibꞌ rukꞌ jun chꞌojchꞌojlaj chomabꞌal je choch ri Dios xuqujeꞌ chikiwach ri winaq. ");
INSERT INTO quctt_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Kꞌi chi kꞌu junabꞌ ikꞌowinaq xintzalij pa ri nutinimit chuyaꞌik tobꞌanik chikitoꞌik ri nuwinaq xuqujeꞌ chutzujik sipanik cho ri Dios. ");
INSERT INTO quctt_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Xineꞌkiriqa kꞌu pa ri Templo tajin kinchꞌojchꞌobej wibꞌ. Man kukꞌ ta e kꞌi winaq xuqujeꞌ man pa chꞌoꞌj taj. ");
INSERT INTO quctt_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ri winaq aꞌj Israel rech ri tinimit Asia, ri xinilowik, rajawaxik kuletzujun che la we kꞌo ri numak xkilo. ");
INSERT INTO quctt_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Kibꞌij xuqujeꞌ bꞌaꞌ ri e kꞌo waral we kꞌo etzelal xinbꞌan chikiwach ri kinimaꞌqil ri qꞌatal taq tzij aꞌj Israel. ");
INSERT INTO quctt_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Wine rumal ri ko xinchꞌaw chkixoꞌl xinbꞌij: “Kinkojo chi kakꞌastaj kiwach ri kaminaqibꞌ, kiqꞌat tzij pa nuwiꞌ kamik.” ");
INSERT INTO quctt_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Ri qꞌatal tzij Félix sibꞌalaj retaꞌm ri kikꞌutuꞌn ri kojonelabꞌ, are xuta we xubꞌij ri Pablo, xubꞌij: Chiwayeꞌj na, we chi pe ri qꞌatal tzij chajinel Lisias, kꞌa te riꞌ kinwilo jas qas kinbꞌan che ri kixriqitajik. ");
INSERT INTO quctt_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Xtaqan ri nima qꞌatal tzij che jun kinimaꞌqil ri ajchꞌoꞌjabꞌ chajil tinimit chi kuchajij ri Pablo xuqujeꞌ kuya bꞌe chike ri e rachiꞌl ri Pablo kakipatanij. ");
INSERT INTO quctt_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Xikꞌow kebꞌ oxibꞌ qꞌij xopan ri Félix rachiꞌl ri rixoqil Drusila aj Judea, xtaqan chusikꞌixik ri Pablo xuqujeꞌ xutatabꞌej ri qꞌalajisanik ri kojobꞌal chirij ri Jesús. ");
INSERT INTO quctt_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Are xok ri Pablo chutzijoxik ri bꞌanoj sukꞌalaj qꞌatoj tzij xuqujeꞌ ri qꞌaten ibꞌ chubꞌanik etzelal, ri kꞌaxkꞌolal ri kape na, xuxiꞌj ribꞌ ri Félix, xubꞌij: Jat jampaꞌ chik kinwinik katintatabꞌej katinsikꞌij. ");
INSERT INTO quctt_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Puꞌkꞌuꞌx chi kaya pwaq che rumal ri Pablo, rumal riꞌ katajinik kusikꞌij katzijon rukꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Kebꞌ junabꞌ jeriꞌ xubꞌano, xuꞌriqaꞌ xkꞌextaj ri qꞌatal tzij Félix, are xok ri achi Porcio Festo che ukꞌaxel, are kꞌu karaj ri Félix nim kil kumal ri winaq aꞌj Israel xukoj kan ri Pablo pa cheꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Ikꞌowinaq chi oxibꞌ qij are xopan ri achi Festo chukꞌamik ri reqeleꞌn relik bꞌik pa ri tinimit Cesarea xopan pa ri tinimit Jerusalén. ");
INSERT INTO quctt_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ri kinimaꞌqil taq ri chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri tinimit xuqujeꞌ ri achyabꞌ ri qas kabꞌan ke pa kiwiꞌ taq ri winaq aꞌj Israel xoꞌpan rukꞌ ri qꞌatal tzij chutzujuxik ri Pablo. ");
INSERT INTO quctt_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Xkita jun toqꞌobꞌ che ri Festo kutaq bꞌik ri Pablo je laꞌ pa ri tinimit Jerusalén, (kichomam kakiqꞌatej pa ri bꞌe kakikamisaj). ");
INSERT INTO quctt_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ri Festo kꞌut xubꞌij chi ri Pablo kꞌo pa ri tinimit Cesarea xuqujeꞌ chi katzalij areꞌ je laꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Xubꞌij kꞌu chike: Ri kꞌo keqeleꞌn chiꞌwe utz kixeꞌ wukꞌ. We kꞌo itzel jastaq ubꞌanom ri Pablo utz kꞌut kitzujuj. ");
INSERT INTO quctt_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Wine wajxaqibꞌ o lajuj qꞌij ikꞌowinaq are xtzalij ri Festo pa Cesarea, chukabꞌ qꞌij xtzalij pa ri ja qꞌatbꞌal tzij xuqujeꞌ xtaqan chukꞌamik ri Pablo. ");
INSERT INTO quctt_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Are xopan ri Pablo, ri e kꞌamal taq kibꞌe ri winaq aꞌj Jerusalén, xkimulij kibꞌ chrij, xkitzujuj che taq mak ri man tzij taj. ");
INSERT INTO quctt_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Ri Pablo xubꞌij: Man inmakuninaq taj choch ri taqanik kech ri winaq aꞌj Israel, man inmakuninaq ta choch ri Templo, man inmakuninaq ta choch ri César. ");
INSERT INTO quctt_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Are kꞌu ri achi Festo xraj kaqaj chikiwach ri winaq aꞌj Israel, xuta che: ¿La kuchap akꞌuꞌx kateꞌ je laꞌ pa Jerusalén, rech je laꞌ kinqꞌat wi tzij paꞌwiꞌ? ");
INSERT INTO quctt_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Ri Pablo xubꞌij: Man kawaj taj. We ja riꞌ qas are qꞌatbꞌal tzij rech ri tinimit Roma, waral qas yaꞌtal wi kaqꞌat tzij pa nuwiꞌ. Etaꞌm la chi man in ajmak taj, maj kꞌax nubꞌanom chike ri winaq aꞌj Israel. ");
INSERT INTO quctt_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","We kꞌu ne nubꞌanom mak ri taqalik kinkamisax rumal, man kinkꞌopij ta wibꞌ we kinkamik. We kꞌu ne maj numak, maj jachin yaꞌtal bꞌe che kinujach pa kiqꞌabꞌ we achyabꞌ riꞌ rech kinkikamisaj. Chuqꞌata tzij pa nuwiꞌ ri César. ");
INSERT INTO quctt_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Ri Festo xtzijon kukꞌ ri yaꞌl taq unoꞌj kꞌa te riꞌ xubꞌij: Utz bꞌa riꞌ, cho ri César kateꞌ wi rumal cher xatoqꞌij are ri César kaqꞌatow tzij paꞌwiꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Are ikꞌowinaq chi kebꞌ oxibꞌ qꞌij, ri taqanel Agripa rachiꞌl ri ranabꞌ ubꞌiꞌ Berenice, xoꞌpan chuyaꞌik rutzil uwach ri Festo. ");
INSERT INTO quctt_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Are tajin kasolix ri Festo rumal ri taqanel, ri Festo xutzijoj che ri taqanel ri kariqitaj ri Pablo, xubꞌij che: Waral kꞌo jun achi kojtal kan pa cheꞌ rumal ri Félix. ");
INSERT INTO quctt_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Are xinkꞌojiꞌ pa ri tinimit Jerusalén, ri kinimaꞌqil chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq xuqujeꞌ ri e kꞌamal taq kibꞌe ri winaq aꞌj Israel xkitzujuj chwe xuqujeꞌ xkitoqꞌij kinqꞌat tzij puꞌwiꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Xinbꞌij kꞌu chike chi ri taqanik rech Roma, man kuqꞌalajisaj taj ajmak jun winaq we majaꞌ kata ri utzij pa ri qꞌatbꞌal tzij. Ri winaq ri katzujuxik yaꞌtal che kutoꞌ ribꞌ chikiwach ri ketzujunik. ");
INSERT INTO quctt_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Are xuꞌl ri e tzujunelabꞌ rech ri Pablo, man xinbꞌey ta wibꞌ, chukabꞌ qꞌij xeꞌnsikꞌij ri kabꞌan ke pa ri qꞌatbꞌal tzij kꞌa te riꞌ xintaqan chukꞌamik ri Pablo. ");
INSERT INTO quctt_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ri umak kꞌut ri xkibꞌij man are ta riꞌ ri etzelal ri wayeꞌm in. ");
INSERT INTO quctt_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Kakitzujuj rumal ri kikojonik, xuqujeꞌ rumal jun achi ubꞌiꞌ Jesús ri xkamik, xa kꞌu kubꞌij ri Pablo chi kꞌaslik. ");
INSERT INTO quctt_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Man wetaꞌm taj jas kinbꞌan chi retaꞌmaxik we jastaq riꞌ. Xinta kꞌu che we kuchap ukꞌuꞌx kaqꞌat tzij puꞌwiꞌ pa ri tinimit Jerusalén rumal taq we jastaq riꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ri Pablo kꞌut xutoqꞌij chi are ri César kaqꞌatow tzij puꞌwiꞌ. Xaq jeriꞌ xintaqan che uchajixik kꞌa kintoꞌtaj na chusukꞌumaxik ri rajawaxik che rech keꞌ cho ri César. ");
INSERT INTO quctt_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Ri Agripa xubꞌij: Kawaj kinta in riꞌ ri achi riꞌ. Ri Festo xubꞌij: Chweꞌq kata la. ");
INSERT INTO quctt_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Chukabꞌ qꞌij, ri Agripa xopan pa ri nimalaj ja ri kakimulij wi kibꞌ ri winaq, rachiꞌl ri Berenice xuqujeꞌ sibꞌalaj e kꞌi winaq, ri nimaq taq taqanelabꞌ pa kiwiꞌ ri ajchꞌoꞌjabꞌ xuqujeꞌ achyabꞌ ri nimaꞌq keqeleꞌn pa ri tinimit. Ri Festo kꞌut xtaqan chukꞌamik ri Pablo. ");
INSERT INTO quctt_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ri Festo xubꞌij: Taqanel Agripa, xuqujeꞌ winaq ri ix kꞌo kamik, are waꞌ ri achi ri sibꞌalaj kakaj ri winaq aꞌj Israel ri e kꞌo waral xuqujeꞌ ri e kꞌo pa Jerusalén kakil uwach kaminaq. ");
INSERT INTO quctt_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ri in kꞌut kinchomaj maj jun jastaq ubꞌanom ri yaꞌtalik kakam rumal. Xutoqꞌij kꞌut keꞌ cho ri kinimaꞌqil ri nimaq taq qꞌatal tzij ri kꞌo pa ri tinimit Roma, rumal riꞌ kintaq bꞌik. ");
INSERT INTO quctt_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","¿Jas kꞌu ri kintzꞌibꞌaj bꞌik che ri qꞌatal tzij? Man kꞌyaqal ta ri umak ri kabꞌixik, rumal laꞌ xinkꞌam loq chiꞌwach iwonojel, je xuqujeꞌ choch la Taqanel Agripa, rech are kakꞌot taj uchiꞌ kꞌo kaqatzꞌibꞌaj bꞌik. ");
INSERT INTO quctt_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Rumal cher man kuya taj kaqataq bꞌik jun winaq ri kꞌo pa cheꞌ cho ri kinimaꞌqil ri nimaq taq qꞌatal tzij, we man kꞌyaqal ri umak, ri katzujux wi. ");
INSERT INTO quctt_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Ri Agripa xubꞌij che ri Pablo: Kuyaꞌo katchꞌawik, katoꞌ awibꞌ. Ri Pablo kꞌut xumajij chꞌawem, xubꞌan jun kꞌutbꞌal rukꞌ ri uqꞌabꞌ rech man kechꞌaw ta na ri winaq, xubꞌij: ");
INSERT INTO quctt_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","Nim taqanel Agripa, sibꞌalaj kakiꞌkot wanimaꞌ lal katow la ri nutzij tobꞌal wibꞌ che ri jastaq ri kinkitzujuj wi ri kꞌamal taq kibꞌe ri winaq aꞌj Israel. ");
INSERT INTO quctt_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Wetaꞌm chi lal qas etaꞌm la ri naqꞌatajibꞌal xuqujeꞌ ri qas ubꞌanik ri jastaq ri kakichꞌoꞌjij rij ri winaq aꞌj Israel. Kamik kꞌut kinta jun toqꞌobꞌ kintatabꞌej la. Ri ukꞌaslemal kan ri Pablo nabꞌe. ");
INSERT INTO quctt_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Are in nitzꞌ akꞌal, xya kꞌutuꞌn chwe chkixoꞌl ri nuwinaq, xuqujeꞌ pa ri tinimit Jerusalén, ketaꞌm ri e kꞌamal taq bꞌe ke ri winaq aꞌj Israel. ");
INSERT INTO quctt_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Aꞌreꞌ ketaꞌm we kakaj kakibꞌij, nabꞌe in kachiꞌl kan ri fariseos, ri wokaj ri sibꞌalaj tzꞌaqat kakibꞌan che ri jastaq pa ri naqꞌatajibꞌal rech kan nabꞌe. ");
INSERT INTO quctt_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Kamik kꞌut kaqꞌat tzij pa nuwiꞌ rumal chi kuꞌl na kꞌuꞌx che ri uchiꞌm loq ri Dios chike ri qamam ojer. ");
INSERT INTO quctt_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Are waꞌ rumal keqꞌijilaꞌn che ri Dios chi paqꞌij chi chaqꞌabꞌ ri kabꞌlajuj puq winaq rech Israel, kuꞌl kikꞌuꞌx che ri kuꞌl wi na kꞌuꞌx in. Pune jeriꞌ, Nimalaj Taqanel, aꞌreꞌ kinkitzujuj rumal waꞌ we kꞌulibꞌal na kꞌuꞌx. ");
INSERT INTO quctt_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","¿Jas che man kikoj taj chi ri Dios kuꞌkꞌastajisaj ri kaminaqibꞌ? ");
INSERT INTO quctt_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Pa nukꞌuꞌx in nabꞌe, chi are in taqchiꞌtal chuqꞌatexik ri ubꞌiꞌ ri Jesús aj Nazaret. ");
INSERT INTO quctt_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Qas tzij kinbꞌij, qas kꞌyaqal riꞌ ri xinbꞌan pa Jerusalén. Ri e kinimaꞌqil ri e chꞌawenelabꞌ cho ri Dios xkiya bꞌe chwe xeꞌntaq bꞌik e kꞌi kojonelabꞌ pa cheꞌ. Are tajin kekamisaxik in xinbꞌij chi taqalik kekamik. ");
INSERT INTO quctt_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Kꞌi mul xinbꞌano chi kaqꞌat tzij pa kiwiꞌ pa ri Sinagoga rech kaketzelaj uwach ri Jesús. Sibꞌalaj woyawal chike rumal riꞌ xeꞌntereneꞌj pa taq juleꞌ taq tinimit chik. ");
INSERT INTO quctt_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Jun qꞌijal inbꞌenaq pa ri tinimit Damasco, keꞌnbꞌana ri jun chak, xkibꞌij bꞌik chwe ri qꞌatal tzij xuqujeꞌ ri kinimaꞌqil ri e chꞌawenelabꞌ cho ri Dios pa kiwiꞌ ri winaq. ");
INSERT INTO quctt_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Nim Taqanel, qas pa ri unikꞌajil qꞌij, xpe jun tunanik pa ri kꞌaj, are kꞌo na cho ri utunal ri qꞌij, xinutunaj in xuqujeꞌ ri e wachiꞌl. ");
INSERT INTO quctt_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Qonojel xujtzaq pa ri ulew, kꞌa te riꞌ xinta jun chꞌabꞌal pa ri tzijobꞌal hebreo, xubꞌij: “Saulo, Saulo ¿jas che kabꞌan kꞌax chwe? Xaq at kabꞌan kꞌax chibꞌil awibꞌ.” ");
INSERT INTO quctt_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Ri in xinbꞌij: “¿Jachin ri lal, Tat?” Ri Ajawxel xubꞌij: “In riꞌ ri Jesús ri tajin kabꞌan kꞌax chwe.” ");
INSERT INTO quctt_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Chanim chatwaꞌjiloq, xinkꞌut wibꞌ chawach rech katuxik wajchak xuqujeꞌ qꞌalajisal rech ri awilom xuqujeꞌ ri kinkꞌut na chawach. ");
INSERT INTO quctt_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Katintoꞌ na pa kiqꞌabꞌ ri awinaqil, xuqujeꞌ pa kiqꞌabꞌ ri man aꞌj Israel taj. Qas tzij, katintaq na bꞌik kukꞌ ri winaq ri man aꞌj Israel taj, ");
INSERT INTO quctt_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","rech kajaqataj ri kibꞌoqꞌoch, rech keꞌl la pa ri qꞌequꞌmal keqꞌax pa ri tunal, xuqujeꞌ keꞌl loq xeꞌ raqan uqꞌabꞌ ri itzel keqꞌax puꞌqꞌabꞌ ri Dios. Kakikꞌamawaꞌj kꞌu na ri kuybꞌal kimak xuqujeꞌ kayaꞌtaj na kꞌokꞌibꞌal chikixoꞌl ri utinimit ri Dios, rumal ri kikojobꞌal chwe. ");
INSERT INTO quctt_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Rumal waꞌ Nim taqanel Agripa, xinnimaj ri kꞌutuꞌn rech chikajil. ");
INSERT INTO quctt_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Nabꞌe xintzijoj chike ri winaq aꞌj Damasco, kꞌa te riꞌ pa Jerusalén, pa Judea xuqujeꞌ chike konojel ri winaq ri man aꞌj Israel taj, kakikꞌex kikꞌuꞌx che ri kimak, ketzalij rukꞌ ri Dios, xuqujeꞌ kakibꞌan ri utz laj taq jastaq rech kakikꞌutu chi xekꞌextajik. ");
INSERT INTO quctt_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Rumal waꞌ nikꞌaj winaq aꞌj Israel xinkichap pa ri Templo, are xkaj xinkikamisaj. ");
INSERT INTO quctt_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ri Dios kꞌut inuchajim kꞌa kamik rech kinqꞌalajisaj chike konojel ri winaq kachapleꞌtaj kukꞌ ri nitzꞌ keqeleꞌn kopan kukꞌ ri nimaꞌq keqeleꞌn. Man kꞌo ta jun jastaq kinkꞌutu ri mat xkitzijoj loq ri e qꞌalajisal taq rech ri utzij ri Dios xuqujeꞌ ri Moisés. ");
INSERT INTO quctt_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Aꞌreꞌ xkitzijoj loq chi ri Mesías kuriq na kꞌax, xuqujeꞌ areꞌ nabꞌe kakꞌastaj na chikiwach konojel ri kaminaqibꞌ xaq jeriꞌ kutzijoj na ri utunal ri Dios junam chike ri winaq aꞌj Israel xuqujeꞌ ri winaq ri man aꞌj Israel taj. ");
INSERT INTO quctt_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Xaq kꞌa te ri Festo xuraq uchiꞌ xubꞌij: ¡Xa at kon Pablo, ri nimalaj etaꞌmanik at ukonarisam! ");
INSERT INTO quctt_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ri Pablo xutzalij uwach, xubꞌij: Man xa taj in kon, nimalaj reqeleꞌn Festo. Are tajin kinbꞌij ri tunal ri sibꞌalaj kꞌo kutayij. ");
INSERT INTO quctt_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Ri Nim taqanel Agripa retaꞌm waꞌ we jastaq riꞌ, rumal laꞌ man kinxiꞌj ta wibꞌ che ri kinbꞌij, man xkꞌulmataj ta we jastaq riꞌ chaꞌwal. ");
INSERT INTO quctt_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Taqanel Agripa ¿la kakoj lal ri xkibꞌij ri e qꞌalajisal taq utzij ri Dios? Wetaꞌm in chi kekoj la. ");
INSERT INTO quctt_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Ri Agripa xuqꞌatej ri utzij ri Pablo, xubꞌij: ¿Teꞌq pa akꞌuꞌx aninaq kinamenkꞌetij rech kinkojonik? ");
INSERT INTO quctt_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Ri Pablo xubꞌij: We kꞌu aninaq o kꞌamaꞌtam, kinta che ri Dios pa ri nuchꞌawem chi ri lal xuqujeꞌ konojel ri e kꞌo pa we kꞌolibꞌal riꞌ kuꞌx na jetaq ri in, xwi chi man e yuttal taj. ");
INSERT INTO quctt_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Xewaꞌjil kꞌu ri taqanel, ri qꞌatal tzij, ri Berenice xuqujeꞌ konojel ri winaq xel loq. ");
INSERT INTO quctt_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Are tajin keꞌl loq xkichomaj: Waꞌ we achi riꞌ maj mak ubꞌanom ri taqal che kakamik o keꞌ pa cheꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Ri Agripa xubꞌij che ri Festo: Wine utz katzoqopixik wet mat xutoqꞌij kaqꞌat tzij puꞌwiꞌ rumal ri César. ");
INSERT INTO quctt_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Are xopan ri qꞌotaj, xujeꞌ pa ri tinimit Italia. Ri Pablo xuqujeꞌ e nikꞌaj winaq chik ri e kꞌo pa cheꞌ xechajix bꞌik rumal jun chike ri kinimaꞌqil ri ajchꞌoꞌjabꞌ chajil tinimit ubꞌiꞌ Julio jun kinimaꞌqil ri ajchꞌoꞌjabꞌ rech ri nim Tinimit. ");
INSERT INTO quctt_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Xeꞌ xuqujeꞌ ri Aristarco qukꞌ, jun achi aj Macedonia ri kꞌo pa ri tinimit Tesalónica. Xujeꞌ kꞌu pa ri jukubꞌ ri yaꞌtal bꞌe che pa ri tinimit Adramitio ri kꞌo pa Asia. Ri jukubꞌ kikꞌow bꞌik pa jaljoj taq kꞌolibꞌal chuchiꞌ ulew rech Asia. ");
INSERT INTO quctt_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Are xujopan pa ri tinimit Sidón, ri Julio sibꞌalaj utz xnoꞌjin rukꞌ ri Pablo, xuya bꞌe che xqaj pa ri jukubꞌ xuꞌsolij kan ri e rech taq chꞌabꞌeꞌn rech chilaꞌ, rech kaya bꞌik ujastaq ri kajawataj che. ");
INSERT INTO quctt_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Kꞌa te riꞌ xujeꞌ chik pa ri plo, xqarik bꞌik nimaq taq kyaqiqꞌ ri man kuya ta bꞌe che ri jukubꞌ jaꞌ kabꞌinik. Xaq jeriꞌ xujikꞌow bꞌik chuxukut Chipre, chuxoꞌl ri chꞌaqaꞌp ulew xuqujeꞌ ri nima tinimit. ");
INSERT INTO quctt_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Are uj bꞌenaq pa ri cho xujikꞌow bꞌik chuchiꞌ ri jaꞌ rech ri tinimit Cilicia xuqujeꞌ ri tinimit Panfilia, kꞌa te riꞌ xujtakꞌiꞌ na pa ri tinimit Mira ri kꞌo pa ri tinimit Licia. ");
INSERT INTO quctt_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Chilaꞌ ri kinimaꞌqil ri ajchꞌoꞌjabꞌ chajil tinimit xuriq bꞌik jun jukubꞌ ri kape pa ri tinimit Egipto, rech ri leꞌaj Alejandría bꞌenam rij pa ri tinimit Italia, xujuya bꞌik chupam. ");
INSERT INTO quctt_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Kꞌi qꞌij noꞌjim xujeꞌek, are xikꞌow taq kan ri kꞌax xujopan chuchiꞌ ri tinimit Gnido. Ri kyaqiqꞌ man kuya ta bꞌe chaqe kujbꞌinik rumal riꞌ xujikꞌow bꞌik pa ri chꞌaqaꞌp ulew rech Creta, xaq koꞌl ri kyaqiqꞌ kubꞌan chuchiꞌ ri retal ri Salmón. ");
INSERT INTO quctt_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Rukꞌ kꞌax xaq chuchiꞌ ri jaꞌ xujeꞌ wi, kꞌisbꞌal rech xujopan chuchiꞌ ri ja ubꞌiꞌ “Utz uchiꞌ jaꞌ” jawjeꞌ utz ketakꞌiꞌ wiꞌ ri jukubꞌ bꞌinibꞌal chuxukut ri tinimit Lasea. ");
INSERT INTO quctt_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Naj qꞌotaj xukꞌam bꞌik ri qabꞌinem. Xibꞌibꞌal ri bꞌinem pa ri plo rumal taq ri kyaqiqꞌ jabꞌ ri kakꞌulmatajik, ri qꞌotaj rech jabꞌ xuchapleꞌj, ri Pablo kꞌut xutzijoj rij ri tajin kakꞌulmatajik kukꞌ ri winaq ri e kꞌo pa ri jukubꞌ bꞌinibꞌal. ");
INSERT INTO quctt_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","Xubꞌij chike: Achyabꞌ, kꞌo kꞌax waꞌ kaqariqo we xaq jeꞌ kujbꞌinik, ronojel le jastaq le kꞌo pa le jukubꞌ qatzaqa kanoq, katukin waꞌ we jukubꞌ bꞌinibꞌal chi qa xeꞌ, xuqujeꞌ kaqarik waꞌ uj kꞌax. ");
INSERT INTO quctt_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Are kꞌu ri taqanel pa kiwiꞌ ri ajchꞌoꞌjabꞌ chajil tinimit man xuta ta ri xubꞌij ri Pablo che, are xuta ri xbꞌix che rumal ri ajchoqꞌe xuqujeꞌ ri kabꞌan rech puꞌwiꞌ ri jukubꞌ bꞌinibꞌal. ");
INSERT INTO quctt_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Are kꞌu ri tinimit ubꞌiꞌnam utz taq uchiꞌ jaꞌ man chajital taj, rumal riꞌ xibꞌibꞌal ikꞌowem chilaꞌ. E kꞌi chike ri kebꞌin pa ri plo are jeꞌl chike kiꞌkꞌow pa ri tinimit Fenice, ri kꞌo apanoq choch ri uchiꞌ jaꞌ pa ri tinimit Creta, ri Fenice sibꞌalaj jun utz laj uchiꞌ jaꞌ jawjeꞌ kikꞌowisax wi ri qꞌotaj rech jabꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Xwaꞌjil kꞌu jun kyaqiqꞌ ri xaq kajororik pa ri uxukut ulew, pa kikꞌuꞌx ri kabꞌan ke puꞌwiꞌ ri jukubꞌ chi maj kꞌax kakiriqo, xkiwaꞌjilisaj ri chꞌichꞌ ri kꞌo che ri jukubꞌ bꞌinibꞌal ri qajinaq pa ri jaꞌ, jeriꞌ xiꞌkꞌow bꞌik chuchiꞌ ri jaꞌ rech ri tinimit Creta. ");
INSERT INTO quctt_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Xaq kꞌa te xkꞌexen ri qꞌotaj, jun nimalaj kyaqiqꞌ jabꞌ ubꞌiꞌ ri kape chuxukut kaj, xpe puꞌwiꞌ ri chꞌaqaꞌp ulew, xujupaqchiꞌj bꞌik pa ri plo. ");
INSERT INTO quctt_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ri kabꞌan ke puꞌwiꞌ ri jukubꞌ bꞌinibꞌal man xekwin taj xkisutij ri jukubꞌ bꞌinibꞌal xechꞌeketajik xekꞌam bꞌik rumal ri kyaqiqꞌ jabꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Xujikꞌow chrij jun laj chꞌaqaꞌp ulew ri kꞌo pa ri plo, ubꞌiꞌ Clauda, ri man kꞌo ta wi nim kyaqiqꞌ. Rukꞌ taq kꞌax xujkwin chuyakik ri alaj taq jukubꞌ bꞌinibꞌal ri chararem bꞌik che toꞌbꞌal qibꞌ. ");
INSERT INTO quctt_vpl VALUES ("AC27_17",