﻿USE sofia;
DROP TABLE IF EXISTS sofia.qucTNT_vpl;
CREATE TABLE qucTNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES qucTNT_vpl WRITE;
INSERT INTO qucTNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Are wa' ri qui bi' ri u mam ri Jesús ojer. Ri Jesús Are rachalaxic ri ka mam David xukuje' ri ka mam Abraham ojer. ");
INSERT INTO qucTNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ri ka mam Abraham are u tat ri ka mam Isaac. Ri ka mam Isaac are u tat ri ka mam Jacob. Ri ka mam Jacob are u tat ri ka mam Judá xukuje' tak ri e rachalal ri are'. ");
INSERT INTO qucTNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ri ka mam Judá are u tat ri ka mam Fares xukuje' ri ka mam Zara. Ri qui nan c'ut are ri nan Tamar. Ri ka mam Fares are u tat ri ka mam Esrom. Ri ka mam Esrom are u tat ri ka mam Aram. ");
INSERT INTO qucTNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ri ka mam Aram are u tat ri ka mam Aminadab. Ri ka mam Aminadab are u tat ri ka mam Naasón. Ri ka mam Naasón are u tat ri ka mam Salmón. ");
INSERT INTO qucTNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ri ka mam Salmón are u tat ri ka mam Booz. Ru nan ri ka mam Booz are ri nan Rahab. Ri ka mam Booz are u tat ri ka mam Obed. Ru nan ri ka mam Obed are ri nan Rut. Ri ka mam Obed are u tat ri ka mam Isaí. ");
INSERT INTO qucTNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ri ka mam Isaí are u tat ri ka mam David ri nim takanel. Ri ka mam David ri nim takanel ruc' ri chichu' ri xrixokilaj na ri tat Urías, e are' u nan u tat ri ka mam Salomón. ");
INSERT INTO qucTNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ri ka mam Salomón are u tat ri ka mam Roboam. Ri ka mam Roboam are u tat ri ka mam Abías. Ri ka mam Abías are u tat ri ka mam Asa. ");
INSERT INTO qucTNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ri ka mam Asa are u tat ri ka mam Josafat. Ri ka mam Josafat are u tat ri ka mam Joram. Ri ka mam Joram are u tat ri ka mam Uzías. ");
INSERT INTO qucTNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ri ka mam Uzías are u tat ri ka mam Jotam. Ri ka mam Jotam are u tat ri ka mam Acaz. Ri ka mam Acaz are u tat ri ka mam Ezequías. ");
INSERT INTO qucTNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ri ka mam Ezequías are u tat ri ka mam Manasés. Ri ka mam Manasés are u tat ri ka mam Amón. Ri ka mam Amón are u tat ri ka mam Josías. ");
INSERT INTO qucTNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ri ka mam Josías are u tat ri ka mam Jeconías, xukuje' ri e rachalal. Pa tak ri k'ij ri' xec'am bi ri winak aj Israel, xeopan c'u pa ri tinimit Babilonia. ");
INSERT INTO qucTNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Aretak ri winak aj Israel e c'o chic pa ri tinimit Babilonia, ri ka mam Jeconías xc'oji jun u c'ojol, Salatiel u bi'. Ri ka mam Salatiel are u tat ri ka mam Zorobabel. ");
INSERT INTO qucTNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ri ka mam Zorobabel are u tat ri ka mam Abiud. Ri ka mam Abiud are u tat ri ka mam Eliaquim. Ri ka mam Eliaquim are u tat ri ka mam Azor. ");
INSERT INTO qucTNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ri ka mam Azor are u tat ri ka mam Sadoc. Ri ka mam Sadoc are u tat ri ka mam Aquim. Ri ka mam Aquim are u tat ri ka mam Eliud. ");
INSERT INTO qucTNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ri ka mam Eliud are u tat ri ka mam Eleazar. Ri ka mam Eleazar are u tat ri ka mam Matán. Ri ka mam Matán are u tat ri ka mam Jacob. ");
INSERT INTO qucTNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ri ka mam Jacob are ru tat ri a José ri rachajil ri María. We María ri' are c'u wa' ru nan ri Jesús ri cäbix Cristo che. ");
INSERT INTO qucTNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Je ri' chi cajlajuj juch'ob tataxelab cachi'l ri qui c'ojol e oc'owinak xchaptaj lok ruc' ri ka mam Abraham c'ä ruc' ri ka mam David. Cajlajuj chic xchaptaj lok ruc' ri ka mam David c'ä aretak xec'am bi ri winak aj Israel, xeopan pa ri tinimit Babilonia. Te c'u ri' e c'o chi cajlajuj chic c'ä xil na u wäch ri Cristo. ");
INSERT INTO qucTNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Are je wa' xbantajic aretak xil u wäch ri alaj a Jesús: Ri k'apoj al María ru nan u yo'm chi u tzij che c'ulanem ruc' ri a José. Mäja' c'u quec'uli'c aretak ri al María xcanaj yawab winak rumal ru chuk'ab ri Lok'alaj Espíritu. ");
INSERT INTO qucTNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ri a José c'ut ri rachajil are jun achi ri jicom ranima' cho ri Dios, man craj tä c'ut cäresaj u q'uixbal ri al María chquiwäch ri winak. Rumal ri' xuchomaj u ya'ic canok xak chi c'uyal. ");
INSERT INTO qucTNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Aretak je' tajin cuchomaj wa', xpe jun ángel ri takom lok rumal ri Dios ri xuc'ut rib chuwäch ri a José pa ri u waram, xubij che: A José, at ba' at rachalaxic ri tat David. Maxej awib chuc'amic ri al María che awixokil, rumal chi ri ral ri quil na u wäch, are rech ri Lok'alaj Espíritu wa'. ");
INSERT INTO qucTNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ri are' cäc'oji na jun ral ala, cacoj c'u na JESÚS che u bi'. (Ri “Jesús” quel cubij “To'l Ke”.) Je' u bi' wa' rumal chi queuto' na ru winakil, queresaj na pa ri qui mac, —xcha ri ángel. ");
INSERT INTO qucTNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ronojel wa' xbantajic rech kas je' quel wi jas ru bim ri Kajaw Dios rumal ri k'alajisal re ru Lok' Pixab ri cubij: ");
INSERT INTO qucTNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ri k'apoj ali cäcanaj na can yawab winak, cäril c'u na u wäch jun ral ala ri cäbix na Emanuel che, —cächa'. Quel cubij wa': Ri Dios c'o kuc', —cächa ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Aretak xc'astaj ri a José che ru waram, xunimaj ri xbix che rumal ri ángel ri takom lok rumal ri Dios. Xuc'am ri al María che rixokil. ");
INSERT INTO qucTNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Man xquirik tä c'u na quib, xane c'ä te' aretak xil na u wäch ri ral ri al María. Ri a José xucoj c'u JESÚS che u bi'. ");
INSERT INTO qucTNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ri alaj a Jesús xil u wäch pa ri tinimit Belén, ri c'o pa Judea. Are chi' c'o ri tat Herodes che nim takanel puwi' ronojel ri Judea. Xeopan c'u jujun achijab ajno'jab pa ri tinimit Jerusalén, jela' c'u quepe pa relbal k'ij. ");
INSERT INTO qucTNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Xquita' c'u u tzijol chila', xquibij: ¿Jawije' cäriktaj wi ri nim takanel ri cätakan na pa qui wi' ri winak aj Israel ri c'ä te' xil u wäch? Xa xkil ru ch'imil pa relbal k'ij, rumal ri' xujpe chuk'ijilaxic, —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Aretak ri tat Herodes ri nim takanel xuta wa', sibalaj xsach u c'ux, je' xukuje' conojel ri niq'uiaj winak aj Jerusalén. ");
INSERT INTO qucTNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Xtakan c'u ri nim takanel che qui siq'uixic ri qui nimakil sacerdotes, xukuje' ri tijonelab re ri Pixab, xuta' c'u chque jawije' quil wi na u wäch ri Cristo. ");
INSERT INTO qucTNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ri e are' xquibij che: Pa ri tinimit Belén ri c'o pa Judea, rumal chi ri k'alajisal re ru Lok' Pixab ri Dios je wa' xutz'ibaj: ");
INSERT INTO qucTNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ri at tinimit Belén, at ri' ri rech ri rulew ri Judá, machomaj chi ri at man nim tä a k'ij at chquiwäch ri k'atal tak tzij ri e c'o chila', rumal chi awuc' at quel wi na jun nim c'amal be, ri cuc'am na qui be ri nu winak aj Israel, —cächa', —xecha ri tijonelab re ri Pixab. ");
INSERT INTO qucTNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Are c'u ri tat Herodes chelak'al xeusiq'uij ri ajno'jab, xuta' c'u chque jampa' kas xc'utun ri ch'imil. ");
INSERT INTO qucTNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Te ri' xeutak bi pa Belén, xubij bi chque: Jix ba' jela', chitatabela' jawije' c'o wi ri ac'al. Aretak quiriko, chixpe chubixic chwe, rech ri in xukuje' quine' na chuk'ijilaxic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ri ajno'jab xuwi xquito ri xbix chque rumal ri nim takanel, xebe'c. Are c'u ri ch'imil ri xquil pa relbal k'ij xnabej chquiwäch, c'ä xopan na puwi' ri c'o wi ri ac'al, xtaq'ui c'u chila'. ");
INSERT INTO qucTNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ri ajno'jab, aretak xquil ri ch'imil, sibalaj xequicotic. ");
INSERT INTO qucTNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Xeboc c'u bi pa ri ja, xquil c'u ri ac'al c'o ruc' ri al María ru nan. Xexuqui'c, xquik'ijilaj ri ac'al. Te c'u ri' xquijak u wi' ri qui c'olibal, xquisipaj k'än puak, incienso, xukuje' mirra che ri Are'. ");
INSERT INTO qucTNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Te c'u ri' xbix chque pa achic' chi meoc'ow chi jela' jawije' c'o wi ri tat Herodes. Xetzelej c'u bi pa ri qui tinimit, xquic'am bi jun be chic. ");
INSERT INTO qucTNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Aretak e benak chi ri ajno'jab, xpe jun ángel ri takom lok rumal ri Dios, xuc'ut rib chuwäch ri a José pa achic', xubij che: Chatwalijok, chac'ama bi ri ac'al, rachi'l ru nan, chixanimaj bic. Jix pa Egipto, chixcanaj c'u na can chila' c'ä quinbij na chiwe jampa' quixpetic. Je ri' chibana rumal chi ri tat Herodes cutzucuj na u cämisaxic ri ac'al, —xcha ri ángel che. ");
INSERT INTO qucTNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Xwalij c'u ri a José, xuc'am ri ac'al, rachi'l ru nan, chak'ab c'ut xebel bic, xebe' pa Egipto. ");
INSERT INTO qucTNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Chila' xec'oji wi na c'ä xcäm na ri tat Herodes. Je' xbantaj wa' rech kas je' quel wi jas ri xubij ri Dios rumal ri k'alajisal re ru Lok' Pixab ri cubij: “Pa Egipto xinsiq'uij wi lok ri nu C'ojol,” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Aretak ri tat Herodes xretamaj chi man are tä kas tzij ri xbix can che cumal ri ajno'jab, sibalaj xpe royowal. Xutak c'u qui cämisaxic conojel ri ac'alab alabom ri tz'akat chi quieb qui junab xukuje' ri mäja' cätz'akat quieb qui junab ri e c'o pa ri tinimit Belén xukuje' ri e c'o pa tak ri tinimit chunakaj ri Belén, je' jas ri k'ij ri xquibij can ri ajno'jab. ");
INSERT INTO qucTNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Xa je ri' kas je' xel wi jas ri xutz'ibaj can ri ka mam Jeremías ri k'alajisal re ru Lok' Pixab ri Dios ri cubij: ");
INSERT INTO qucTNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Xtataj c'ut chi c'o jun ri curak u chi' pa ri tinimit Ramá, nimalaj ok'ej wa', nimalaj bis cäbanic. Are ri nan Raquel ri cubisoj qui wäch ri ral, ri man cuya' taj cäcu'bisax u c'ux rumal chi ya e cäminak chic ri ral, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Aretak c'ut cäminak chic ri tat Herodes, jun ángel ri takom lok rumal ri Dios xuc'ut rib chuwäch ri a José pa achic' jela' pa Egipto, xubij che: ");
INSERT INTO qucTNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Chatwalijok, chac'ama bi ri ac'al awuc', xukuje' ru nan, chixtzelej chi na jumul pa Israel. Xecäm c'u conojel ri cäcaj cäquicämisaj ri ac'al, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Xwalij c'u ri a José, xuc'am bi ri ac'al rachi'l ru nan, xtzelej chi na jumul pa Israel. ");
INSERT INTO qucTNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Aretak c'ut ri a José xuto chi are ri tat Arquelao chic c'o che nim takanel pa Judea chuq'uexel ri Herodes ru tat, xuxej rib xe' jela'. Xch'abex c'u rumal ri Dios pa achic', rumal ri' jela' xe' wi pa Galilea. ");
INSERT INTO qucTNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Aretak xopan chila', jela' xec'ol wi pa ri tinimit Nazaret. Je' xbantaj wa' rech kas je' quel wi ri xquibij can ri k'alajisal tak re ru Lok' Pixab ri Dios, chi ri Jesús cäbix na aj Nazaret che. ");
INSERT INTO qucTNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Pa tak ri k'ij ri' ri tat Juan Kasal Ja' xopan pa Judea, pa tak ri juyub ri cätz'inowic. Tajin cutzijoj ru Lok' Pixab ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Cubij c'u chque ri winak: Chiq'uexa ri iwanima', chiq'uexa ri i chomanic, rumal chi xa jubik' chic man cuchaplej ru takanic ri Dios, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","We tat Juan ri' are wa' ri xtz'ibax can chrij ojer rumal ri ka mam Isaías, ri k'alajisal re ru Lok' Pixab ri Dios ri cubij: C'o jun ri co cäch'aw pa tak ri juyub ri quetz'inowic, cubij: “Chibana u banic ri nim be ri cäbin wi ri Kajaw. Chisuc'umaj, chibana sibalaj jicom che,” —xcha ri ka mam Isaías. ");
INSERT INTO qucTNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Are c'u ri tat Juan xucoj atz'iak ri banom ruc' ri rismal jun awaj, camello u bi', tz'um c'u ru pas. Xa sac' xukuje' uwal che' xutijo. ");
INSERT INTO qucTNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Xepe c'u ri winak aj Jerusalén, xukuje' ri e c'o pa tak niq'uiaj tak tinimit chic re Judea xukuje' ri e c'o chunakaj ri nima' Jordán, xeopan c'u ruc' ri tat Juan chutatabexic ri cubij. ");
INSERT INTO qucTNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Aretak xquik'alajisaj ri qui mac, xban c'u qui kasna' rumal ri tat Juan pa ri nima' Jordán. ");
INSERT INTO qucTNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Aretak c'ut xril ri tat Juan chi e q'uia chque ri tata'ib fariseos xukuje' ri tata'ib saduceos xepetic rech cäban qui kasna', xubij chque: ¡Ri alak subanelab tak winak! ¿Jachin c'u ri xbin chech alak chi rajwaxic canimaj alak chuwäch ri nimalaj royowal ri Dios ri cäpetic? ");
INSERT INTO qucTNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Bana ba' alak ri takal u banic, ri cuk'alajisaj chi kas tzij xq'uextaj ri anima' alak, ri chomanic alak. ");
INSERT INTO qucTNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mächaplej c'u alak u bixic pa anima' alak: “Ri uj, uj rachalaxic can ri ka mam Abraham.” Quinbij c'u chech alak chi ri Dios cäcowinic cuban chque tak we abaj ri' chi e rachalaxic can ri ka mam Abraham. ");
INSERT INTO qucTNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Cämic ri' tajin cäcoj ri iquiäj che tak ri qui xera' ri che' rech quet'oyic. Ronojel che' ri man cuya tä utzalaj u wäch, cät'oy c'u na wa', cäporox na pa ri k'ak'. ");
INSERT INTO qucTNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ri in kas tzij quinban kasna' alak ruc' joron, c'utbal wa' chi q'uexom chi anima' alak, q'uexom chi ri chomanic alak. Cäpe chi c'u na jun chic ri cuban na kasna' alak ruc' ri Lok'alaj Espíritu xukuje' ruc' k'ak'. Ri Are' nim na u k'ij chnuwäch in, nim c'u na u banic. Man takal tä chwe in chi quinquir ru c'amal u xajäb. ");
INSERT INTO qucTNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ri Are' are jas jun achi ri cujosk'ij ru trico. Ruc'am chi ru pala, cujopij c'u na ri trico, cutas che ri pajo. Cuc'ol na ri trico pa ri c'uja. Are c'u ri pajo cuporoj na pa jun k'ak' ri man cächup tä chic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Xel c'u lok ri Jesús pa Galilea, xopan chuchi' ri nima' Jordán ri c'o wi ri tat Juan rech cäban u kasna' rumal. ");
INSERT INTO qucTNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Man xraj tä c'u ri tat Juan, xane xubij che ri Jesús: Ri in man takal tä chwe chi quinban kasna' la. Rajwaxic ne chi ri lal cäban la nu kasna' in, —cächa'. ¿Jas che xpe la wuc' in? —xcha che ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Xubij c'u ri Jesús che: Che we chanim ri', chaya chwe chi je' quinban wa'. Are c'u wa' takalic rech cäka'no jachique ri cätakan wi ri Dios, —xcha che. Ri tat Juan c'ut xunimaj ri xubij. ");
INSERT INTO qucTNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Aretak c'ut xbantaj u kasna' ri Jesús, xel lok ri Are' pa ri ja'. ¡Chanim xjakjob ri caj! Ri Jesús c'ut xril ri Lok'alaj Espíritu xkaj lok puwi' ri Are', je' u banic jun palomäx. ");
INSERT INTO qucTNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Te ri' xtataj c'ut chi cäch'aw lok jun chicaj ri xubij: Are ri Lok'alaj nu C'ojol wa'. Cäquicot ri wanima' rumal, —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Te c'u ri' ri Lok'alaj Espíritu xuc'am bi ri Jesús pa tak juyub ri quetz'inowic, rech cätakchi'x che mac chila' rumal ri Itzel. ");
INSERT INTO qucTNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Cawinak k'ij, cawinak ak'ab xc'oji chila', man c'o tä c'u jas ri xutijo. Te c'u ri' sibalaj xnumic. ");
INSERT INTO qucTNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Xpe c'u ri Itzel, xopan ruc' ri Jesús rech cutakchi'j ri Are' che mac, xubij che: We kas tzij chi lal u C'ojol ri Dios, takan la chque tak we abaj ri' chi cäca'n na wa, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Xch'aw ri Jesús, xubij che: Ru Lok' Pixab ri Dios ri Tz'ibtalic cubij: “Man xak tä xuwi rumal ri wa quec'asi na ri winak, xane xukuje' rumal ronojel ru Tzij ri Dios,” —cächa', —xcha ri Jesús che. ");
INSERT INTO qucTNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ri Itzel xuc'am bi ri Jesús pa ri lok'alaj tinimit Jerusalén, xupakba c'u puwi' ri nimalaj rachoch Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Te ri' xubij che: We kas tzij chi lal u C'ojol ri Dios, q'uiäka bi ib la iquim, rumal chi ru Lok' Pixab ri Dios ri Tz'ibtalic cubij: Ri Dios queutak na lok ri ángeles awuc' che a chajixic. Catquichap na che ra k'ab che a to'ic rech man cachak'ij tä rawakan cho abaj, —cächa', —xcha ri Itzel che. ");
INSERT INTO qucTNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ri Jesús xch'awic, xubij che: Xukuje' cubij ru Lok' Pixab ri Dios ri Tz'ibtalic: “Mayac royowal ri Awajaw, ri a Dios,” —cächa', —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Te c'u ri' ri Itzel xuc'am bi ri Jesús puwi' jun nimalaj juyub. Xeuc'ut c'u conojel tak ri tinimit ajuwächulew chuwäch ri Are', xukuje' ri qui k'inomal. ");
INSERT INTO qucTNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Xubij c'u che ri Jesús: Ronojel wa' quinya che la, we cäxuqui la, quink'ijilaj la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Xch'aw ri Jesús, xubij che: Jat, Satanás, chatel chnuwäch rumal chi ru Lok' Pixab ri Dios ri Tz'ibtalic cubij: “Chak'ijilaj ri Awajaw ri a Dios, xuwi c'u ri Are' chapatänij,” —cächa', —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Xel c'u bi ri Itzel ruc' ri Jesús. Xepe c'u jujun ángeles rech quepatänin che ri Are'. ");
INSERT INTO qucTNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ri Jesús, aretak xuto chi c'o ri tat Juan pa che', xe' pa Galilea. ");
INSERT INTO qucTNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Man xcanaj tä c'u can pa ri tinimit Nazaret, xane xa xc'oji pa Capernaum, jun tinimit Romano wa' ri c'o chi' ri mar chquinakaj ri ojer tak tinimit Zabulón ruc' Neftalí. ");
INSERT INTO qucTNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Je' xbantaj wa' rech kas je' quel wi jas ri xutz'ibaj can ri ka mam Isaías ri k'alajisal re ru Lok' Pixab ri Dios ri cubij: ");
INSERT INTO qucTNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Winak aj Zabulón, winak aj Neftalí, ix ri' ri nakaj ix c'o wi che ri mar, ch'äkäp che ri nima' Jordán, chila' pa Galilea jawije' e c'o wi winak ri man aj Israel taj. ");
INSERT INTO qucTNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ri winak ri je' ta ne e c'o pa k'ekum xquil jun nimalaj sakil. E are' winak wa' ri e c'o pa ri qui mac, ri e c'o cho ri cämical, xpe jun nimalaj sakil pa qui wi', —xcha ri ka mam Isaías. ");
INSERT INTO qucTNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","C'ä te ri' c'ut ri Jesús xuchaplej u tzijoxic ru Lok' Pixab ri Dios, xubij c'u chque ri winak: Chiq'uexa ri iwanima', chiq'uexa ri i chomanic, rumal chi xa jubik' chic man cuchaplej ru takanic ri Dios, —xcha chque ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Oc'owem cuban ri Jesús chuchi' ri mar re Galilea, xeril c'u quieb achijab cachalal quib. Ri jun are ri tat Simón ri xukuje' cäbix Pedro che, ri jun chic are ri tat Andrés. Tajin cäquiq'uiäk bi jun c'at chapäbal cär pa ri cho rumal chi e chapal tak cär ri e are'. ");
INSERT INTO qucTNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ri Jesús xubij chque: Chixsa'j wuc'. Quinban c'u na chiwe chi quixoc che qui mulixic winak che qui q'uexwäch ri cär, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Chanim xquiya can ri qui c'at, xebe' ruc' ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Oc'owinak chi apan jubik' ri Jesús, xeril chi c'u quieb achijab chic cachalal quib. E are' ri tat Jacobo rachi'l ri tat Juan. E u c'ojol ri tat Zebedeo wa'. E c'o pa jun barco cachi'l ri qui tat, tajin cäquic'ojoj c'u ri qui c'at. Xesiq'uix c'u rumal ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ri e are' c'ut chanim xquiya can ri barco ruc' ri Zebedeo ri qui tat, xebe' ruc' ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ri Jesús xbin pa conojel tak ri tinimit re Galilea, xuya tijonic chque ri winak pa tak ri rachoch Dios. Xutzijoj ri Utzalaj Tzij re ri Evangelio chrij ru takanic ri Dios pa qui wi' ri winak. Xukuje' xucunaj ronojel u wäch yabil ri c'o chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Xtataj c'u u tzijol ri Jesús cumal ri winak pa conojel tak ri tinimit re Siria. Ri winak c'ut xequic'am lok conojel ri qui rikom c'äx rumal q'uia u wäch c'äxc'ol, yabil, k'oxom. Xequic'am lok ri e c'o itzel tak espíritus chque, xukuje' ri winak ri man utz tä chi qui jolom rumal chi e elinak ch'uj, xequic'am c'u lok ri cäminak qui cuerpo. Ri Jesús c'ut xeucunaj conojel. ");
INSERT INTO qucTNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","E q'uia winak c'ut aj Galilea xebe' ruc' ri Jesús. Xukuje' e c'o winak aj Decápolis, aj Jerusalén, aj Judea, e c'o c'u ri xepe ch'äkäp che ri nima' Jordán. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Aretak ri Jesús xeril ri q'uialaj winak, xpaki puwi' ri juyub, xt'uyi chila'. Xquimulij c'u quib ru tijoxelab ruc'. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ri Jesús xuchaplej qui tijoxic, je wa' xubij chque: ");
INSERT INTO qucTNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Utz que ri cäquina' pa canima' chi c'o ri rajwaxic chque ri cäpe chila' chicaj. Ri Dios c'ut cätakan na pa qui wi'. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Utz que ri quebisonic rumal chi ri Dios cäcu'bisan na qui c'ux. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Utz que ri man cäca'n tä nimal. Ri e are' c'ut cäquechbej na ri ulew ri u bim ri Dios chi cuya chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Utz que ri quenumic, ri cächaki'j qui chi' che jun c'aslemal jicom. Are c'u ri Dios cäyo'w na wa' chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Utz que ri quel qui c'ux chque niq'uiaj winak chic. Ri Dios c'ut cutok'obisaj na qui wäch ri e are'. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Utz que ri sak canima'. Ri e are' c'ut cäquil na u wäch ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Utz que ri cäquitzucuj u ya'ic utzil chquixol ri winak. Ri Dios cubij na chi e are' ralc'ual ri Are'. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Utz que ri quetzelax qui wäch rumal ru banic ri jicomal cho ri Dios. Ri Dios c'ut cätakan na pa qui wi'. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Utz iwe ix aretak cäban c'äx chiwe cumal ri winak, quixyok' cumal, cäquibij ronojel u wäch ri man kas tzij taj chiwij, xa rumal chi quixcojon chwe in. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Chixquicot ba', chixtze'nok rumal chi quic'am na jun nimalaj tojbal iwe chila' chicaj. Je c'u c'äx wa' xban chque ri k'alajisal tak re ru Lok' Pixab ri Dios ri xec'oji can ojer, —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ri ix, je' ta ne ix atz'am chque ri winak cho ruwächulew. We c'u man c'o chic u tzayil ri atz'am, ¿jas ta c'u lo cäban che rech c'o chi cupatänij? Man c'o tä chi u patän ri', xane xa cäq'uiäk na apanok, cätac'alex c'u na cumal ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ri ix, je' ta ne ix sakil chque ri winak cho ruwächulew je' jas jun tinimit ri c'o puwi' jun juyub, ri amak'el cäk'alajinic. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Man cätzij tä jun chäj, te c'u ri' cäyi' chuxe' jun coxon, xane xa cäyi' ri' pa jun c'olibal chicaj rech cätunun pa qui wi' conojel ri e c'o pa ri ja. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Je wa' chibana ix xukuje', chibana' chi ri sakil ri c'o iwuc' cätunun chquiwäch ri winak. Je ri' rech aretak cäquil ri utzil ri quibano, cäquiya u k'ij ri i Tat ri c'o chila' chicaj. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Michomaj ix chi in petinak che resaxic ri Pixab ri xutz'ibaj can ri ka mam Moisés, o ri qui tijonic ri k'alajisal tak re ru Lok' Pixab ri Dios. Man in petinak tä che resaxic, xane in petinak chubixic ri kas u banic ri Pixab xukuje' ri qui tijonic ri k'alajisal tak re ru Lok' Pixab ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kas tzij quinbij chiwe, man c'o tä quesax na che ri Pixab, xane xa ronojel cäbantaj na. C'ä mäjok cäsach u wäch ri caj ulew, man c'o tä jun punto, man c'o tä jun alaj tz'ib ri quesax na che ri Pixab. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Rumal ri' jachin ri man cunimaj tä jun chque ri takanic re ri Pixab, pune are ri man nim tä u banic, xukuje' cuc'ut chquiwäch niq'uiaj winak chic chi man kas rajwaxic taj cänimax wa', ri are' man nim taj quil wi na chquixol ri winak ri cätakan na ri Dios pa qui wi'. Are c'u ri winak ri cunimaj ri Pixab, xukuje' cuc'ut chquiwäch niq'uiaj winak chic chi cäquinimaj wa', kas nim na u banic wa' chquixol ri winak ri cätakan na ri Dios pa qui wi'. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Quinbij c'u chiwe, chi we man jicom na ri i c'aslemal ix chuwäch ri qui c'aslemal ri tata'ib fariseos xukuje' ri tijonelab re ri Pixab, man quixoc tä ri' chquixol ri winak ri cätakan na ri Dios pa qui wi'. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ri ix i tom chi xbix chque ri ka mam ojer: “Mixcämisanic, apachin c'u ri cäcämisanic cäk'at na tzij puwi',” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Are c'u ri in quinbij chiwe chi jachin ri cuyac royowal chrij ri rachalal cäk'at na tzij puwi'. Jachin ri c'äx cäch'aw che ri rachalal cäk'at na tzij puwi' cumal ri k'atal tak tzij. Xukuje' jachin ri cubij che ri rachalal chi xa are jun con, chi man c'o tä chi u patän, que' na ri' pa ri k'ak'. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Rumal c'u ri', we cac'am bi ri a sipanic cho ri ta'bal tok'ob, chila' c'ut cäna'taj chawe chi c'o jun c'äx ri cuna' ri awachalal chawij, chaya can ri a sipanic cho ri ta'bal tok'ob. Jat na ruc' ri awachalal rech catutzir ruc' nabe, te c'u ri' cuya' cattzelej cho ri ta'bal tok'ob chuya'ic ra sipanic cho ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","We c'o jun winak cuban u c'ulel chawe, catuc'am c'u bi pa ri k'atbal tzij, chatutzir na ruc' pa ri be rech man catujach tä pu k'ab ri k'atal tzij. We ta mat je ri', ri k'atal tzij catujach na pa qui k'ab ri mayor, ri mayor c'ut catquicoj na pa che'. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kas tzij ba' ri quinbij chawe chi man c'o tä awelic lok chila' c'ä catoj na ronojel ri a multa, —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ri ix i tom chi xbix can nabe: “Maban ri nimalaj mac ri äwas u banic chrij ra c'ulaj,” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Are c'u ri in quinbij chiwe, chi jachin ri cuca'yej jun ixok, xak xuwi ruc' ru rayixic u wäch xmacun ri' ruc' pa ranima', —cächa ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","We ri awak'äch re ri awiquiäk'ab cubano chi catzak pa mac, chawesaj, chaq'uiäka apanok. Are utz na chawe we quel jun ch'äkap che ra cuerpo, chuwäch wa' chi ronojel ra cuerpo cäq'uiäk bi pa ri k'ak'. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","We c'u are ri a k'ab re ri awiquiäk'ab cubano chi catzak pa mac, chak'ata', chaq'uiäka apanok. Are c'u utz na chawe we quel jun ch'äkap che ra cuerpo, chuwäch wa' chi ronojel ra cuerpo cäq'uiäk bi pa ri k'ak', —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","(Cäch'aw chi ri Jesús, cubij:) Xukuje' xbix can nabe: “Apachin ri cujach bi ri rixokil, rajwaxic cuya bi jun wuj che ri cubij wi chi jachom canok,” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ri in c'ut quinbij chiwe, chi we jun achi cujach bi ri rixokil man rumal tä u ch'abexic jun achi chic, cuban ri' chi ri rixokil cuban ri nimalaj mac ri äwas u banic. Jachin c'u ri cäc'uli ruc' jun ixok ri jachom bic, cuban ri' ri nimalaj mac ri äwas u banic, —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Xukuje' i tom ri' ri xbix chque ri ka mam ojer: “Kas chabana' jas ri xachi'j u banic ruc' juramento cho ri Kajaw Dios,” —xeuchixic. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ri in c'ut quinbij chiwe, chi miban juramento aretak c'o ri quichi'j che jun winak chic. Miban juramento ruc' ri caj rumal chi chila' c'o wi ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Miban juramento ruc' ruwächulew rumal chi are je' ta ne u tac'alibal ri rakan ri Dios. Miban juramento ruc' ri tinimit Jerusalén rumal chi are u tinimit ri Dios ri Nimalaj Takanel. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Xukuje' miban juramento ruc' ri i jolom, rumal chi man quixcowin taj quiban sak o k'ek che xa jun i wi'. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Xane xak xuwi chibij “je', je ri'” o “man je' taj”, —quixcha'. Are c'u ri tzij ri xak u wi' tzij chic, rech ri Itzel ri', —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ri ix i tom chi xbix can nabe: “We jun cäresaj u wak'äch jun winak chic, quesax na ru wak'äch ri are'. We jun cäresaj u ware jun winak chic, quesax na ru ware ri are',” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Are c'u ri in quinbij chiwe: Chixel chuwäch ri itzel achi ri craj cäch'ojin iwuc'. Xane we c'o jun catch'ayow che ri juperaj a palaj, chaya ri juperaj a palaj chic chuwäch. Mitzelej u q'uexel ri c'äx ri cäban chiwe. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","We c'o jun craj catusiq'uij pa k'atbal tzij, craj c'ut cumaj ri a camixa', chaya bi ra chaquet che xukuje'. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","We c'o jun cucoj u chuk'ab chawe chi cac'am bi jun eka'n ri cäbinibej jun legua, chac'ama bi quieb legua ruc'. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Apachin ri c'o jas cuta' chawe, chaya che. Macowirisaj ri awanima' chuwäch ri winak ri craj cäkajan awuc'. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Xukuje' i tom ri' ri xbix can nabe: “Lok' chawila wi ri awachi'l, chawetzelaj c'u u wäch ri a c'ulel,” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Are c'u ri in quinbij chiwe: Lok' chiwila wi ri i c'ulel. Chibij: Ri Dios c'o pi wi', —quixcha chque ri winak ri queyok'on chiwe. Chibana utzil chque ri cäquetzelaj i wäch, chibana ba' orar pa qui wi' ri xak cäca'n c'äx chiwe. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","We je' quiban wa' k'alaj ri' chi kas ix ralc'ual ri ka Tat ri c'o chila' chicaj. Are c'u ri ka Tat quesan lok ri k'ij pa qui wi' ri utzalaj tak winak, xukuje' pa qui wi' ri itzel tak winak. Cutak c'u lok ri jäb pa qui wi' ri cäca'n ri jicomal, xukuje' pa qui wi' ri man cäca'n tä ri jicomal. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Are c'u we xak xuwi queiwaj ri quixcaj ix, ¿jas ta c'u che cäyi' na tojbal re wa' chiwe rumal ri Dios? Xukuje' ne ri tok'il tak alcabal cäcaj quib ri e are'. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","We xak xuwi quiya rutzil qui wäch ri iwachalal, ¿a quichomaj lo ri' chi i banom jun nimalaj utzil? Je c'u ne wa' xukuje' cäca'n ri man kas quetam tä u wäch ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Je ba' chibana ix jas ri ka Tat ri c'o chila' chicaj. Ri Are' tz'akat pa ru chomabal. Ri ix xukuje' chibana tz'akat pa ri i chomabal, —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ru patänixic ri Dios ri quibano, miban wa' chquiwäch ri winak xak rech cäquilo, cäquiya c'u i k'ij. We je' quiban wa', ri ka Tat ri c'o chila' chicaj man c'o tä tojbal iwe cuya na. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Rumal ri' aretak queito' ri c'o qui rajwaxic, mitzijoj chque conojel ri winak, je' jas ri cäca'n ri winak ri xak quieb qui wäch cäquitzijoj chque conojel ri winak pa tak ri rachoch Dios, pa tak ri be. Je' cäca'n wa' xak xuwi rech utz quech'aw ri winak chquij. Kas tzij c'ut quinbij chiwe chi ri cäbix chquij xuwi wa' ri tojbal que cäquirik na. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Xane ri ix aretak c'o jas u wäch jun tobanic ri quiya chque ri c'o qui rajwaxic, c'o jun metamanic. Mitzijoj ne wa' che ri utzalaj iwachi'l. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Chibana ba' ri utzil xak chelak'al. Ri ka Tat c'ut ri quilow ronojel ri quiban chelak'al, are cäyo'w na ri tojbal iwe, —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ri ix aretak quiban orar miban iwe jas ri cäca'n ri winak ri xak quieb qui wäch, ri cäkaj chquiwäch xak e tac'atoj cäca'n orar pa tak ri rachoch Dios, pa tak ri u cruz tak be. Xak are cäcaj chi que'ilitaj cumal ri winak. Kas tzij quinbij chiwe chi xuwi wa' ri tojbal que cäquirik na. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Xane ri ix aretak quiban orar, chixoc pa ja, chitz'apij ri uchija. Chibana orar chuwäch ri ka Tat ri c'o iwuc' pa i tuquiel wi. Ri ka Tat c'ut ri quilowic chi tajin quiban orar chelak'al, are cäyo'w na ri tojbal iwe. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Aretak quiban orar, mibij q'uia tzij ri man c'o tä qui patän, jas ri cäca'n ri winak ri man kas quetam tä u wäch ri Dios. Ri e are' cäquichomaj chi ri Dios queutatabej xa rumal chi q'uia ri cäquibij pa tak ri oración ri cäca'no. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Miban ba' iwe jas ri cäca'n ri e are'. Rumal chi ri ka Tat retam chic jas ri rajwaxic chiwe c'ä mäja' quita' wa' che. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Rumal ri' aretak quiban orar, je wa' chibij: Ka Tat ri c'o la pa ri caj, chnimarisax ta na u k'ij ri bi' la. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Takan na la pa qui wi' conojel winak. Bana ba' na la ri rayibal la cho ruwächulew, jas ri cäban chila' chicaj. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ya la chkawäch ri cäkatijo, jas ri rajwaxic chke cämic. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Sacha la ri ka mac ri ka'nom je' jas ri uj cäkasach ri qui mac ri cäca'n c'äx chke. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mäya la chke chi cujtakchi'x che mac, xane chujto' la cho ri Itzel. Ronojel wa' cäkata' che la rumal chi ri lal cätakan la puwi' ronojel. C'o nimalaj chuk'ab uc' la puwi' ronojel, chnimarisax ta ba' k'ij la amak'el pa tak ri k'ij ri junab ri quepetic. Amén. (Je wa' quibij aretak quiban orar, —xcha ri Jesús chque.) ");
INSERT INTO qucTNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","We ri ix quisach qui mac niq'uiaj winak chic ri ca'nom c'äx chiwe, ri ka Tat ri c'o chila' chicaj xukuje' cusach na ri i mac ix. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Are c'u we man quisach qui mac niq'uiaj winak chic, ri ka Tat man cusach tä na ri i mac ix, —xcha ri Jesús chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Aretak ri ix quiban ayuno miban iwe jas ri cäca'n ri achijab ri xak quieb qui wäch. Ri e are' cäca'n che quib chi quebisonic. Je' cäca'n wa' xak rech cäquil ri winak chi tajin cäca'n ayuno. Kas tzij quinbij chiwe chi xuwi wa' ri tojbal que cäquirik na. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ri ix c'ut aretak quiban ayuno, chich'aja ri i palaj, utz quiban chuxayic ri i wi'. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Je wa' quibano rech ri winak man cäquich'ob taj chi tajin quiban ayuno, xane xak xuwi ri ka Tat ri c'o iwuc' pa i tuquiel wi quilowic. Are c'ut cäyo'w na ri tojbal iwe. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Mimulij i k'inomal waral cho ruwächulew, rumal chi waral xa quechicopir ri jastak, xa quek'elobic, xa quelak'axic. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Xane are chimulij i k'inomal chila' chicaj, jawije' ri man quechicopir tä wi, man quek'elob taj, man quelak'ax tä c'ut. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ri c'o wi ri i k'inomal, chila' ri' benak wi ri iwanima', —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ri a wak'äch are je' jas jun candela ri cuya sakil chawe. We utz ri a wak'äch, k'alaj ri' ri a be chawäch. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","We c'u man utz ra wak'äch, man k'alaj tä ri' ra be, at c'o ri' pa k'ekum. We ri sakil ri c'o pa ri awanima' cuban k'ekum, ¡sibalaj nim na ri k'ekum ri'! —xcha ri Jesús chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Man c'o tä jun winak cäcowinic queupatänij quieb patrón. Cäretzelaj c'u na u wäch ri jun, lok' cäril na ri jun chic. Cuban ri jicomal ruc' ri jun, man nim tä c'u cäril wi ri jun chic. Jun winak man cuya' taj cupatänij ri Dios we benak u c'ux ruc' ri k'inomal, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Rumal ri' quinbij chiwe: Mixoc il che jas ri quiban chuch'aquic ri i wa o ri quitijo. Mixoc il che ri iwatz'iak ri quicojo. Are c'u nim na u banic ri c'aslemal chuwäch ri quitijo, are c'u nim na u banic ri i cuerpo chuwäch ri atz'iak ri quicojo. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Chiwilampe ri chicop ri querapap chicaj. Man cäca'n tä tico'n, man cäquiyac tä c'u u wäch ri tico'n chuc'olic wa' pa tak c'uja. Pune je ri', ri ka Tat ri c'o chila' chicaj quetzukuwic. Nim c'u na i k'ij ix chquiwäch ri chicop ajuwocaj. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿A c'o lo jun chiwe ri cäcowinic cäc'asi chi na quieb oxib junab xa rumal chi sibalaj coc il che? ¡Man c'o taj! —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Jas c'u che sibalaj quixoc il che ri iwatz'iak? Chiwilampe ri cotz'ij pa tak ri juyub jas cäca'no queq'uiyic. Man quebatz'in taj, xukuje' man quequiemen taj. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Quinbij c'u chiwe chi pune ta ne je ri', ri nim takanel Salomón, ruc' ronojel ru k'inomal, man xcowin tä xucoj jun ratz'iak je' jas jun chque we cotz'ij ri', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","We ri Dios je wa' u banom che ri catz'iak ri k'ayes ri e c'o cämic pa juyub, chuwek c'ut xa queyi' na pa ri k'ak', ¡e ta c'u lo ri ix! ¿A mat quixrilij na ri Dios che ri iwatz'iak? Ri ix xa jubik' quixcojonic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Rumal ri', mixoc ba' il, mibij: “¿Jawije' cäpe wi ri ka wa? o ¿jawije' cäpe wi ri cäkatijo? o ¿jawije' cäpe wi ri katz'iak?” —mixcha', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Conojel c'u we jastak ri' are ri cäquitzucuj ri winak. Are c'u ri ix c'o ri i Tat chila' chicaj ri retam chi queajwataj wa' chiwe. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Rumal ri' are nabe chitzucuj chi ri Dios cätakan pa ri i c'aslemal, xukuje' chibana ri jicomal chuwäch ri Are', cäya'taj c'u na ronojel ri cajwataj chiwe. ");
INSERT INTO qucTNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mixoc ba' il che ri chuwek. Ri chuwek c'o na ri c'äx cäriktajic jas ri cämic. Ruc' wa' ri i cosic re ri k'ij cämic, —xcha ri Jesús chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Mik'at tzij pa qui wi' niq'uiaj winak chic, rech ri Dios man cuk'at tä tzij pi wi' ix. ");
INSERT INTO qucTNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ri Dios je' u k'atic tzij cuban na pi wi' ix jas ru k'atic tzij quiban ix pa qui wi' niq'uiaj winak chic. Jas ri pajbal ri quicoj ix chque niq'uiaj winak chic, je' cäcoj na chiwe ix. ");
INSERT INTO qucTNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Jas che cabij tzij chquij niq'uiaj winak chic? ¡Je' ta ne chi cawil ri in nitz' mes ri c'o pa ru wak'äch ri awachalal, man cawil tä c'u ri a mac at ri je' jas jun cuta'm ri c'o pa ra wak'äch! ");
INSERT INTO qucTNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","We ri at c'o jun cuta'm pa ra wak'äch, ¿a cuya' lo ri' cabij che ri awachalal: “Chaya chwe chi quinwesaj cok ri in nitz' mes ri c'o pa ra wak'äch”? ");
INSERT INTO qucTNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Ri at xak quieb a wäch! Chawila' nabe jas u banic ra c'aslemal at, je' ta ne chi cawesaj jun cuta'm ri c'o pa ra wak'äch. Je ri' kas catca'y na che resaxic cok ri in nitz' mes ri c'o pa ru wak'äch ri awachalal. ");
INSERT INTO qucTNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Meiya ri lok'alaj tak jastak ri rech ri Dios chque tak ri tz'i', mepe c'u ne chiwij, cäca'n c'u ch'akatak chiwe. Meiya ri je'lalaj tak abaj perlas chquiwäch tak ri ak, xak c'u ne mäquitac'alej. ");
INSERT INTO qucTNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Chita' ri quiwaj, cäya'taj c'u na wa' chiwe rumal ri Dios. Chitzucuj ruc' ri Dios, quirik c'u na. Chic'oroc'a ri uchija, cäjaktaj c'u na wa' chiwäch. ");
INSERT INTO qucTNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Je ri', rumal chi jachin ri c'o jas cuta', cäya'taj na che. Jachin ri c'o cutzucuj, c'o curiko, jachin c'u ri cuc'oroc'a ri uchija, cäjaktaj na wa' chuwäch. ");
INSERT INTO qucTNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿A c'o lo jun chiwe ri cuya jun abaj che ri u c'ojol aretak cuta' u wa? ");
INSERT INTO qucTNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿A cuya ne lo jun cumätz che aretak cuta' jun cär? ");
INSERT INTO qucTNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","We ri ix, ix ajmaquib, quixcowin chuya'ic utzalaj tak jastak chque ri iwalc'ual, ¿a mat ri i Tat ri c'o chila' chicaj queuya na utzalaj tak jastak chque ri cäquita' che? ");
INSERT INTO qucTNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Je c'u ri', jas ri quiwaj ix chi cäca'n ri winak chiwe, je' chibana ix chque ri e are' xukuje'. Are c'u je wa' ri cubij ri Pixab ri xutz'ibaj ri ka mam Moisés, xukuje' je wa' cubij tak ri wuj ri xquitz'ibaj can ri k'alajisal tak re ru Lok' Pixab ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Chixoc bi pa ri uchibe ri latz' u wäch. Ri uchibe xukuje' ri be ri que' pa ri c'äx jawije' cäsach wi qui wäch ri winak, nim qui wäch. E q'uia c'ut ri queboc pa ri uchibe ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Are c'u ri uchibe xukuje' ri be ri que' pa ri c'aslemal ruc' ri Dios, nu'ch qui wäch xukuje' sibalaj c'äx. Man e q'uia tä c'ut ri querikowic. ");
INSERT INTO qucTNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Chichajij iwib chquiwäch ri achijab ri xak e banal tak tzij, ri cäca'n che quib chi e k'alajisal tak re ru Lok' Pixab ri Dios. E are c'u wa' quepe iwuc', sibalaj utz quepetic je' ta ne chij ri quij, are c'u chquipam e jik'ab tak utiw. ");
INSERT INTO qucTNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ri ix quich'ob na jachin tak wa' rumal ri cäca'no. Je' jas jun che' cäch'obtaj u wäch rumal ru wächinic. ¿A c'o lo jumul ri quetam uvas chrij ri q'uix? ¿A quetam lo higos chrij ri tzäcäm? ¡Man je' taj! ");
INSERT INTO qucTNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Je c'u ri' ronojel utzalaj che' utz ri u wäch ri cuya'. Are c'u ri che' ri man utz taj, man utz tä ru wäch ri cuya'. ");
INSERT INTO qucTNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ri utzalaj che' man cäcowin taj cuya ru wäch ri man utz taj. Ri che' ri man utz taj man cäcowin taj cuya utzalaj u wäch ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ronojel che' ri man cuya tä utzalaj u wäch, cät'akix na, cäq'uiäk na ri' pa ri k'ak'. ");
INSERT INTO qucTNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Je wa ri' ri ix kas quich'ob na jas qui banic ri winak rumal ri cäca'no, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Man conojel tä winak queboc chila' jawije' ri cätakan wi ri Dios, pune cäquibij chwe: “Kajaw, Kajaw,” —quecha ri', xane xak xuwi ri quebanow ru rayibal ri nu Tat ri c'o chila' chicaj. ");
INSERT INTO qucTNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","E q'uia ri cäquibij na chwe pa ri k'ij ri': “Kajaw, Kajaw, ri uj ka yo'm tzijonem pa ri bi' la. Pa ri bi' la xekesaj bi itzel tak espíritus chque ri winak, xukuje' are pa ri bi' la ri xka'n q'uia u wäch cajmabal,” —quecha na. ");
INSERT INTO qucTNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ri in c'ut quinbij na chque: “Man wetam tä i wäch. Chixel bi chnuwäch, ri ix xak ix banal tak etzelal,” —quincha na chque, —xcha ri Jesús chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Je c'u ri' jachin ri cutatabej ri nu tzij, cuban c'ut jas ri quinbij, are je ri' jas jun achi ri c'o u no'j, ri xuyac ri rachoch pa abaj. ");
INSERT INTO qucTNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Xkaj c'u ri jäb, xeq'uiy tak ri ja', xpe jun nimalaj quiäkik' chrij ri ja, man xtzak tä c'ut rumal chi ru tac'alibal are abaj. ");
INSERT INTO qucTNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Jachin c'u ri cutatabej ri nu tzij, man cuban tä c'ut jas ri quinbij, junam ri' ruc' jun achi ri man cuch'ob taj jas ri cubano, ri xuyac ri rachoch puwi' ri senyäb. ");
INSERT INTO qucTNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Xkaj ri jäb, xeq'uiy tak ri ja', xpe jun nimalaj quiäkik' chrij ri ja, xtzak c'u ri ja. ¡Ronojel xa xwulijic! —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Aretak ri Jesús xto'taj che tzijonem, ri winak sibalaj xquicajmaj ru tijonic. ");
INSERT INTO qucTNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Je ri', rumal chi ri u tijonic cuc'utu chi are je' jas jun ri c'o u takanic pa qui wi', man je' taj jas ri xca'n ri tijonelab re ri Pixab. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Aretak ri Jesús xkaj lok cho ri juyub, e q'uia winak xeteri lok chrij. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Xopan c'u ruc' ri Jesús jun achi ri c'o itzel ch'a'c che. Xxuqui chuwäch ri Jesús, xubij che: Tat, ri in wetam chi cäcowin la che nu cunaxic we caj la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Xuyuk c'u ru k'ab ri Jesús, xuchap cok ri achi, xubij che: ¡Cwaj! Chutzir ba' la, —xcha che. Xuwi wa' xubij ri Jesús. Xutzir c'u ri achi ri c'o ri itzel ch'a'c che. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Xubij c'u ri Jesús che: ¡Tampe la! C'o jas mäbij la che jachin jun. Oj la, jec'utu ib la cho ri sacerdote. Ya la ri sipanic ri takom can rumal ri ka mam Moisés chi cäyi'c aretak cäcunataj jun ri c'o itzel ch'a'c che. Are c'u k'alajisabal wa' chquiwäch ri winak chi utzirinak chi la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Aretak xopan ri Jesús pa ri tinimit Capernaum, xpe jun achi ruc'. Are jun chque ri qui nimal soldados aj Roma. Xuta' c'u jun tok'ob che ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Je wa' xubij: Tat, ri ala ri patänil we kajinak pa ch'at cho ja, cäminak u cuerpo. Sibalaj c'äx u rikom rumal ri yabil, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ri Jesús xubij che: Quine' na chucunaxic, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ri qui nimal soldados xch'awic, xubij che ri Jesús: Tat, man takal tä chwe chi coc la pa ri wachoch. Xak xuwi takan la chi quel ri yabil che ri patänil we, ruc' c'u wa' cutzir na, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ri in xukuje' c'o jun ri cätakan pa nu wi' ri nim u banic. Xukuje' ri in e c'o nu soldados ri quintakan pa qui wi'. Aretak quinbij che jun chque ri nu soldados chi que'c, que' c'ut. Aretak quinbij che jun chic chi cäpetic, cäpe c'u ri are'. Aretak quintak ri patänil we chubanic jun chac, ri are' cuban ri quinbij, —xcha ri qui nimal soldados che ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Aretak ri Jesús xuta wa', sibalaj xucajmaj, xubij c'u chque ri winak ri e teren chrij: Kas tzij quinbij chiwe, chi man c'o tä jumul ri nu rikom chquixol ri winak aj Israel jun achi jas we achi ri' ri sibalaj cäcojon chwe, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Quinbij c'u chiwe chi e q'uia ri quepe na chrelbal k'ij, xukuje' chukajbal k'ij, ri quet'uyi na junam ruc' ri ka mam Abraham, ri ka mam Isaac, ri ka mam Jacob chuchi' ri mesa chila' jawije' ri cätakan wi ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Are c'u ri xa xquichomaj queboc chila' jawije' ri cätakan wi ri Dios, man queboc taj rumal chi man xecojon taj. Xane xa queq'uiäk na bi pa ri k'ekum. Chila' c'ut quebok' wi na, chila' cäquikuch'uch'ej wi na ri qui ware, —xcha ri Jesús chque ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Te ri' xubij ri Jesús che ri qui nimal soldados: Oj la cho ja. Rumal chi xcoj la chi cäcunataj ri ala, je c'u cäbantaj na, —xcha che. Tzare chi' c'ut xutzir ri ala aretak xubij ri Jesús wa' we tzij ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ri Jesús xe' cho rachoch ri tat Pedro, xril c'u ru ji' chichu' ri tat Pedro kajinak pa ch'at rumal jun nimalaj k'ak'. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ri Jesús xuchap ri chichu' che ru k'ab, xel c'u ri k'ak' chrij. Chanim c'ut xwalijic, xuchap qui patänixic. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Aretak xk'ekal chic, e q'uia winak ri c'o itzelalaj tak espíritus chque xec'am bi cho ri Jesús. Xa c'u ruc' jun tzij ri xubij ri Jesús xebel bi ri itzelalaj tak espíritus, xukuje' xeucunaj conojel tak ri yawabib. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Je' xbantaj wa' rech je' quelic jas ri xubij ri ka mam Isaías ri k'alajisal re ru Lok' Pixab ri Dios: “Ri Are' xurik c'äx rumal kech, xuya ka chuk'ab, xujucunaj che ri ka yabilal,” —xcha ri ka mam Isaías. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ri Jesús xrilo chi e q'uia winak qui mulim quib ruc', xubij chque ru tijoxelab: Chujk'ax ch'äkäp che ri mar, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Xpe c'u jun tijonel re ri Pixab, xkeb c'u ruc' ri Jesús, xubij che: Ajtij, cwaj quine' uc' la apawije' ta ne ri que' wi la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Xch'aw c'u ri Jesús, xubij che: Ri yac c'o qui jul, xukuje' ri chicop ri querapap cho ri caj c'o qui soc. Are c'u ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak, man c'o tä jawije' ri quinwar wi, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Jun achi chic, jun chque ru tijoxelab, xubij che ri Jesús: Tat, ya la chwe chi nabe quine'c, quinmuk can ri nu tat aretak cäcämic, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Xch'aw c'u ri Jesús, xubij che: Tasa'j at wuc', chaya chque ri cäminakib chi chquimuku ri qui cäminak, —xcha ri Jesús che. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Te ri' xoc ri Jesús pa ri barco, ru tijoxelab c'ut xebe' ruc'. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Xpe c'u jun nimalaj quiäkik' ri sibalaj c'äx puwi' ri ja', je ri' chi ri nimak tak uwoja' tajin queboc pa ri barco. Are c'u ri Jesús tajin cäwaric. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Xebe' c'u ru tijoxelab, xequic'asuj, xquibij che: ¡Kajaw Jesús, chujto' la! ¡Tajin cujcämic! —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Xch'aw c'u ri Jesús, xubij chque: ¿Jas che sibalaj quixej iwib? ¡Ri ix kas tzij man nim tä más ri i cojonic! —xcha chque. Xwalij c'u ri Jesús, xuyaj ri quiäkik' xukuje' ri mar. Xtäni c'u ri quiäkik', xlilob ronojel ru wi' ri mar. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ri achijab sibalaj xquicajmaj, xquibij c'ut: ¿Jachin lo ri' we achi ri', chi ri quiäkik' xukuje' ri ja' re ri mar queniman che? —xecha ri achijab. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Aretak xeopan ch'äkäp che ri mar, pa ri qui tinimit ri winak aj Gadara, xebel lok quieb achijab pa ri campo santo chquixol tak ri mukubal, xeopan c'u ruc' ri Jesús. E c'o itzel tak espíritus chque we achijab ri'. Sibalaj xibibal quepetic, je ri' chi man c'o tä chi jun cäcowinic coc'ow pa ri be ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Xquichap c'u u rakic qui chi', co xech'awic, xquibij che ri Jesús: ¿Jas caj la chke uj, Jesús, lal ri' ri u C'ojol ri Dios? ¿A petinak la waral chubanic c'äx chke pune mäja' curik ri k'ij? —xecha che ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","E q'uia c'u ri ak tajin queyuk'ux apan chila' pa ri juyub ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ri itzel tak espíritus xebochi'n che ri Jesús, xquibij che: We cujesaj bi la, ya la chke chi cujoc chque ri ak, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Xubij c'u ri Jesús chque: Jix ba', chixoc chque ri ak, —xcha chque. Xebel c'u bi ri itzel tak espíritus chque ri achijab, xeboc bi chque ri ak. Conojel c'u ri ak xquiq'uiäk bi quib chutza'm ri juyub, xekaj c'u pa ri mar, xejik'ic. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Are c'u ri ajyuk'ab tak ak sibalaj xquixej quib, xeanimaj bic, xebe'c. Aretak xeopan pa ri tinimit xquesaj u tzijol wa' ri xquilo, xukuje' ri xbantaj cuc' ri achijab ri xec'oji ri itzel tak espíritus chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Conojel c'u ri winak ri e c'o pa ri tinimit xebe' jela' jawije' c'o wi ri Jesús. Aretak xquil ri Jesús, xquibochi'j, xquibij che chi chel bi pa ri qui tinimit. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Te c'u ri' xoc ri Jesús pa jun barco, xk'ax ch'äkäp che ri cho, xopan c'u pa ru tinimit ri Are'. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Xc'am c'u bi jun achi cho ri Jesús ri cäminak u cuerpo, k'oyol c'u ri' cho jun alaj ch'at. Aretak ri Jesús xrilo chi ri achijab ri e teleninak lok sibalaj quecojon che, xubij che ri yawab: Mäbison chi la, tat, ri mac la xesachtajic, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jujun c'u chque ri tijonelab re ri Pixab tajin quechomanic, xquibij pa canima': “We achi ri' cubij ri äwas u bixic chrij ri Dios,” —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ri Jesús retam chic jas ri tajin cäquichomaj, xubij c'u chque: ¿Jas che c'o we itzel tak chomanic ri' pa anima' alak? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Jachique ri man c'äx tä u bixic: “Ri mac la xesachtajic”, o ru bixic: “Walij la, oj la cho ja”? —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Rech ba' quetamaj alak chi ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak, c'o c'u nu takanic pa qui wi' ri winak cho ruwächulew chusachic ri qui mac, ¡tampe alak ri quinbij! —xcha chque. Xubij c'u ri Jesús che ri achi ri cäminak u cuerpo: Walij la, oj la cho ja, c'ama bi la ri soc la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Xwalij c'u bi ri achi ri cäminak u cuerpo, xe' cho rachoch. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Aretak xquil ri winak wa', xquixej quib. Xquinimarisaj c'u u k'ij ri Dios, rumal chi u yo'm pa qui k'ab winak chi takal u banic we cajmabal ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Xel bi ri Jesús chila'. Oc'owem cuban ri Are' jawije' ri cätoj wi ri alcabal, xril c'u u wäch jun achi, Mateo u bi', t'uyul chila'. Xubij c'u che: Tasa'j wuc', —xcha che. Xwalij c'u ri tat Mateo, xe' ruc' ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Pa jun k'ij c'ut t'uyul ri Jesús chi' ri mesa cho rachoch ri tat Mateo. E q'uia c'u ri tok'il tak alcabal, xukuje' niq'uiaj ajmaquib chic e t'uyul ruc' ri Jesús chi' ri mesa junam cuc' ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Xepe c'u ri tata'ib fariseos, xquil ronojel wa'. Xquita' c'u chque ru tijoxelab, xquibij: ¿Jas che cäwi' ri Jesús ri iwajtij cuc' ri tok'il tak alcabal xukuje' cuc' ri ajmaquib? —xecha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Aretak xuta ri Jesús wa', xubij chque: Ri winak ri utz qui wäch, ri c'o qui chuk'ab, man rajwaxic tä cunal que, xane are rajwaxic wa' chque ri yawabib, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Oj alak, jetamaj alak jas quel cubij wa' we tzij ri' ri tz'ibtal can pa ru Lok' Pixab ri Dios ri cubij: “Ri in are cwaj chi ri ix quitok'obisaj qui wäch ri winak. Man are tä cwaj chi queicämisaj tak awaj che qui sipaxic chnuwäch,” —cächa ri Dios, —xcha chque. Ri in, man in petinak tä che qui siq'uixic winak ri jicom canima' cho ri Dios, xane in petinak che qui siq'uixic ri ajmaquib rech cäquiq'uex canima', cäquiq'uex c'u qui chomanic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ru tijoxelab ri tat Juan Kasal Ja' xeopan ruc' ri Jesús, xquibij che: ¿Jas che ri uj xukuje' ri tata'ib fariseos amak'el cäka'n ri ayuno, are c'u ri tijoxelab la man cäca'n tä ri ayuno? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ri Jesús xch'awic, xubij chque: ¿A quebison lo ri winak ri e c'o pa jun c'ulanem aretak ri achi ri te' xc'uli'c c'o cuc'? Copan c'u na ri k'ij aretak quesax bi we achi ri' chquixol. Te c'u ri' cäca'n na ri ayuno pa ri k'ij ri', —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Xukuje' xubij ri Jesús chque: Man c'o tä jun winak ri cut'is jun c'ac' c'ojobal chrij jun k'el atz'iak. We ta je ri' ri c'ac' c'ojobal cuc'ol rib, cäresaj c'u bi jubik' che ri k'el atz'iak, cänimar c'u ru tek'tobic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Man c'o tä jun ri cuya c'ac' vino pa k'el tak k'ebal re tz'um. We ta je ri', ri vino cut'ubij na ri tz'um, quetzeletaj c'u na ri vino xukuje' tak ri tz'um. Rajwaxic c'ut chi ri c'ac' vino cäyi' pa tak c'ac' tak k'ebal re tz'um, rech ri vino xukuje' tak ri tz'um man quetzeletaj taj, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Je wa' tajin cubij ri Jesús chque ri winak aretak xopan jun tata' qui nimal ri winak aj Israel. Xxuqui chuwäch ri Jesús, xubij che: Ri alaj nu mia'l c'ä te' xcäm canok. We c'u ri lal que' la wuc', cäya la ri k'ab la puwi', cäc'asi na, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Xe' c'u ri Jesús ruc' ri tata', e rachi'l ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","C'o c'u jun ixok yawab, ri xque' cablajuj junab xak quel u quiq'uel. Xkeb c'u chrij ri Jesús, xuchap cok ru chi' ru k'u'. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Xubij c'u pa ranima': “Xuwi ta ne we quinchap cok ru k'u', quinutzir na,” —xcha ri ixok. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ri Jesús c'ut xutzolk'omij rib, xril ri ixok, xubij che: Mäbison chi la, nan, xcunataj c'u la, rumal chi xcojon la chwe, —xcha che. Tzare chi' c'ut xutzir ri ixok. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Aretak ri Jesús xopan cho rachoch ri tata' ri qui nimal ri winak aj Israel, xrilo chi e c'o chi ri ajk'ojomab ri quebe' che ri muknajic, xukuje' xeril ri winak chi sibalaj cäquiq'uis quib che ok'ej, sibalaj cäquirak qui chi'. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Xubij c'u chque: ¡Chel na apan alak cho ja! Man cäminak tä ri ali, xane xa cäwaric, —xcha chque. Are c'u ri winak xa xquitze'j u wäch ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ri Jesús c'ut xeresaj bi ri winak cho ja, te c'u ri' xoc bic. Xuchap ri ali che ru k'ab. Ri ali c'ut xwalijic. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Xel c'u u tzijol wa' ri xbantajic pa tak conojel ri tinimit chila'. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Aretak xel bi ri Jesús chila', quieb moyab xeteri bi chrij, xquirak qui chi', xquibij: ¡Tat, lal ri' ri Ralc'ual can ri ka mam David, tok'obisaj la ka wäch! —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Aretak ri Jesús xoc bi pa ri ja, ri quieb moyab xekeb ruc'. Ri Jesús xuta' chque: ¿A cäcoj alak chi quincowin chubanic wa'? —xcha chque. Cäkacojo, Tat, —xecha ri e are'. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ri Jesús xuchap cok ri qui wak'äch, xubij chque: Je' ta ba' chbantajic jas ri xcoj alak chi quincowin chubanic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Xutzir c'u ri qui wak'äch. Ri Jesús sibalaj xeupixbaj, xubij chque: Mätzijoj alak wa' che jachin jun, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Te c'u ri', aretak xebel bic, xquichap u tzijoxic wa' jas ri xuban ri Jesús cuc' pa conojel tak ri tinimit ri c'o jela'. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Tajin quebel bi ri quieb moyab ri xecunaxic, aretak xc'am lok chuwäch ri Jesús jun achi mem ri c'o jun itzel espíritu che. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Aretak xesax bi ri itzel espíritu rumal ri Jesús, ri achi ri mem xuchaplej tzijonem. Ri winak sibalaj xquicajmaj wa', xquibij: Man c'o tä jumul ri je' kilom wa' waral pa Israel, —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Are c'u ri tata'ib fariseos xquibij: We achi ri' queresaj bi ri itzel tak espíritus chque ri winak ruc' ru chuk'ab ri qui nimal ri itzel tak espíritus, —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ri Jesús xeusolij ri nimak tak tinimit xukuje' ri alaj tak tinimit. Pa tak ri rachoch Dios ri cäquimulij wi quib ri winak xuya tijonic, xutzijoj ri Utzalaj Tzij re ri Evangelio chrij ru takanic ri Dios pa qui wi' ri winak. Xucunaj ronojel u wäch yabil, xukuje' xresaj ronojel u wäch c'äx chque ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Aretak xeril ri q'uialaj winak, xel u c'ux chque rumal chi quebisonic, man c'o tä cäcu'bisan qui c'ux. E je' ta ne chij ri man c'o tä cajyuk'. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Xubij c'u chque ru tijoxelab: Kas tzij sibalaj nim ri k'atoj, xa c'u e quieb oxib ri ajchaquib. ");
INSERT INTO qucTNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Chibochi'j ba' ri Ajchak'el ri k'atoj chi queutak bi niq'uiaj ajchaquib chic pa ru chac, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ri Jesús xeusiq'uij ri cablajuj u tijoxelab. Xuya chque chi cäc'oji takanic pa qui k'ab che quesaxic bi ri itzel tak espíritus, xukuje' che qui cunaxic ri winak che ronojel u wäch yabil o ronojel u wäch c'äx ri c'o chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Are wa' ri qui bi' ri cablajuj apóstoles: nabe ri tat Simón ri xukuje' cäbix Pedro che, ruc' ri tat Andrés ri rachalal. Ri tat Jacobo ruc' ri tat Juan ri rachalal ri e u c'ojol ri tat Zebedeo. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ri tat Felipe, ri tat Bartolomé, ri tat Tomás, xukuje' ri tat Mateo ri tok'il alcabal. Ri tat Jacobo ru c'ojol ri tat Alfeo. Ri tat Lebeo ri xukuje' cäbix Tadeo che. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ri tat Simón ri cäbix u nimal tinimit che, xukuje' ri tat Judas Iscariote ri xjachow ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ri Jesús xeutak bi we achijab ri', xeupixbaj bic, xubij chque: Mixe' pa tak ri qui tinimit ri winak ri man aj Israel taj. Man quixoc tä c'ut pa tak ri qui tinimit ri winak aj Samaria. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Xane are quixe' cuc' ri winak aj Israel, ri e je' ta ne chij e sachinak can pa tak juyub. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Jix, jibij chque chi xa jubik' man cuchaplej ru takanic ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Cheicunaj ri yawabib, cheic'astajisaj ri cäminakib, cheicunaj ri c'o itzel tak ch'a'c chquij, cheiwesaj c'u bi ri itzel tak espíritus chque ri winak. Ri ix xak sipam wa' we cuinem ri' chiwe, c'o c'u ba' mita' che ri qui to'ic ri winak, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mic'am bi i rajil. Ri k'än puak, ri sak puak, ri quiäk puak mic'am c'u bic. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mic'am bi ri i chim che ri be. Xa jun i camixa' quic'am bic. Mic'am bi i xajäb. Mic'am bi i ch'imiy. Je ri', rumal chi takal che ri ajchac chi cäyi' ri cajwataj che. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Apachique tinimit ri quixopan wi, we nim, we ch'utin, chitzucuj jun winak chila' ri kas quixc'ulaj. Chixcanaj can chila' c'ä quichap na bi jumul chic ri i be. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Aretak quixoc pa jun ja, chiya rutzil qui wäch ri e c'o pa ri ja. Quibij chque chi are utzil quiwaj chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","We takal chque ri winak ri e c'o pa ri ja chi quiya can rutzil qui wäch ruc' utzil, chiya canok. We c'u man takal chque, miya can rutzil qui wäch. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Are c'u we man quixc'ulax cumal, we man cäcaj taj cäquitatabej ri i tzij, chixel bi cho ri ja ri' o pa ri tinimit ri'. Chitota' can ri ulew ri c'o che tak ri iwakan. (Chibana wa' chuk'alajisaxic chquij ri winak re ri tinimit ri' chi man utz tä ri cäca'no, c'o qui mac.) ");
INSERT INTO qucTNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kas tzij quinbij chiwe chi pa ri k'ij ri cäk'at na tzij pa qui wi' ri winak ri' rumal ri Dios, nim na ri c'äjisabal qui wäch ri winak re ri tinimit ri' chuwäch ri c'äjisabal qui wäch ri winak aj Sodoma xukuje' ri winak aj Gomorra, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","¡Chiwilampe'! Ri in quixintak bic je' ta ne chi ix chij chquixol ri utiw. Chixsac'laj ba' je' jas ri cumätz, chibana c'ut je' jas ri cuban ri palomäx ri man cuban tä c'äx. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Chiwila ba' iwib, rumal chi ri winak quixquijach na pa qui k'ab ri qui nimakil ri winak, quixquich'ay na pa tak ri rachoch Dios ri cäquimulij wi quib ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Quixquic'am na bi chquiwäch k'atal tak tzij, xukuje' chquiwäch nimak tak takanelab rumal wech in, rech quik'alajisaj ri Utzalaj Tzij re ri Evangelio chquiwäch ri e are' xukuje' chquiwäch ri winak ri man aj Israel taj. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Aretak c'ut quixc'am bic rech quixjach chquiwäch ri k'atal tak tzij, mixej iwib. Michomaj bic jas ri quibij, o jas ri quiban chubixic wa'. C'ol ba' pa i jolom chi aretak rajwaxic quixch'awic, ri Dios cäyo'w na chiwe ri tzij ri quibij. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Man ix tä c'u ri' ri quixtzijon na, xane are ri Lok'alaj Espíritu rech ri ka Tat cäyo'w na ri tzij pa ri iwanima', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ri winak quequijach na ri cachalal pa cämisaxic. Ri nan tat quequijach na ri calc'ual pa cämisaxic. Ri alc'ualaxelab cäquiyac na quib chquij ri qui nan qui tat, quequijach na pa cämisaxic. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Quetzelax na i wäch cumal conojel ri winak xa rumal wech in. Apachin c'u ri cuch'ij ri c'äx c'ä cäq'uis na ronojel curik na ru tobanic ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Aretak cäban c'äx chiwe pa jun tinimit, chixanimaj bi pa jun tinimit chic. Kas tzij quinbij chiwe chi mäja' quixcowin chusolixic tak conojel ri tinimit ri e c'o wi ri winak aj Israel aretak quinpe in, in ri' ri Ralc'ual ri Dios ri Kas Winak, —xcha chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ri tijoxel man are tä nim na u banic chuwäch ru tijonel. Ri ajchac c'ut man are tä nim na u banic chuwäch ri u patrón. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ri tijoxel rajwaxic cäcu'bi u c'ux chi cäjunamataj na ruc' ru tijonel. Ri ajchac c'ut rajwaxic cäcu'bi u c'ux chi cäjunamataj na ruc' ru patrón. We ri ajchak'el ja cäbix Beelzebú che xa che yok'bal re, ¿jas ta c'u lo cäbix chque ri rachalaxic ri are'? ");
INSERT INTO qucTNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Rumal ri' mixej iwib chquiwäch ri winak. Man c'o tä ri ch'uktalic ri mat quel na chi sak. Man c'o tä c'u ri c'u'talic ri mat quetamax na. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ri quinbij chiwe ix pa ri k'ekum, chiya u bixic pa sakil. Ri quinbij chiwe chic'uyal, chiraka i chi' chubixic wa' pa tak ri be. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mixej iwib chquiwäch ri winak ri quecowinic cäquicämisaj ri cuerpo, man quecowin tä c'u chucämisaxic ri ranima' jun. Xane are chixej iwib chuwäch ri Jun ri cäcowinic cusach u wäch ru cuerpo jun winak xukuje' ri ranima' ri are' pa ri k'ak'. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","¿A mat xa jun centavo queq'uiyix wi quieb alaj tak chicop ajuwocaj? Man c'o tä c'u jun chque we alaj tak chicop ri' ri cäcämic we ta mat craj ri i Tat. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Xukuje' ne ri rismal i wi', conojel wa' e ajilatal rumal ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Mixej ba' iwib, ri ix sibalaj ix lok' na chquiwäch q'uia alaj tak chicop ajuwocaj, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Conojel ri cäquik'alajisaj quib chquiwäch ri winak chi e cojoninak chwe, ri in xukuje' quink'alajisaj na chuwäch ri nu Tat ri c'o chila' chicaj chi e wachi'l in. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Apachin c'u ri cubij chquiwäch ri winak chi man retam tä nu wäch, ri in xukuje' quinbij chuwäch ri nu Tat ri c'o chila' chicaj chi man wetam tä u wäch ri are', —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Michomaj chi ri in petinak chuya'ic utzil chquixol ri winak cho ruwächulew, xane rumal wech in cäc'oji na ch'oj chquixol ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Cäbantaj na ch'oj rumal wech, jun tata' chrij ri u c'ojol, ru c'ojol c'ut chrij ru tat, jun chichu' chrij ri ral ali, ri ali c'ut chrij ru nan, xukuje' ne ri jun ali chic chrij ru nan ralib, ru nan ralib c'ut chrij ri are'. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Je ri' chi ri qui c'ulel ri winak chquijujunal, e are' ri cachalaxic ri e are', —cächa ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Apachin ri lok' na cäril ru nan u tat chnuwäch in, man takal tä ri' chi coc che nu tijoxel. Apachin ri lok' na cäril ru c'ojol o ru mia'l chnuwäch in, man takal tä ri' chi coc che nu tijoxel. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Apachin ri man cäpe tä wuc' in rumal chi man craj taj curik ri cämical jas ri quinrik in, man takal tä ri' chi coc che nu tijoxel. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Jachin ri craj cuto' u wi' ru c'aslemal waral cho ruwächulew, cäcäm na ri'. Jachin c'u ri cuya ru c'aslemal rumal wech in, cuto' na u wi' ri' ru c'aslemal. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ri winak ri utz i c'ulaxic cubano, in ri' quinuc'ulaj. Jachin ri quinuc'ulaj in, are cuc'ulaj ri' ri Jun ri xintakow lok. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Jachin ri cuc'ulaj jun k'alajisal re ru Lok' Pixab ri Dios ri takom lok rumal ri Dios, cuc'am na ri tojbal re jas ri cäyi' che jun k'alajisal re ru Lok' Pixab ri Dios. Jachin ri cuc'ulaj jun utzalaj achi, cuc'am na ri tojbal re jas ri cäyi' che jun utzalaj achi rumal ri utzil ri cubano. ");
INSERT INTO qucTNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Apachin ri cuya jun vaso joron che jun chque we winak ri' ri man nim tä qui banic xa rumal chi are nu tijoxel wa', kas curik na ri tojbal re, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Aretak ri Jesús xto'taj che qui pixbexic ri cablajuj u tijoxelab, xel bi chila' rech cuya tijonic chque niq'uiaj winak pa tak ri tinimit jela', xukuje' rech cutzijoj ri Utzalaj Tzij re ri Evangelio chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Are c'u ri tat Juan Kasal Ja' c'o pa che'. Xretamaj c'ut jas ri tajin cuban ri Cristo. Ri are' xeutak bi quieb chque ru tijoxelab ruc' ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Je' xubano rech cäquita' che: ¿A lal ri' ri Cristo ri cäpe na? o ¿A rajwaxic ne cäkeyej chi na jun chic? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Xch'aw c'u ri Jesús, xubij chque: Oj alak, bij alak che ri tat Juan jas ri tajin quil alak, xukuje' ri tajin cäta alak. ");
INSERT INTO qucTNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Bij alak che chi ri moyab queca'y chic, ri ch'ocojib quebin chic, ri c'o itzel ch'a'c chquij tajin queutzir che ri qui yab. Bij alak che chi ri so'rab cäquita chic, ri cäminakib tajin quec'astajic, xukuje' chi ri meba'ib tajin cätzijox ri Utzalaj Tzij re ri Evangelio chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Utz re ri winak ri man cuban tä quieb u c'ux chwij, —xcha chque ru tijoxelab ri tat Juan. ");
INSERT INTO qucTNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Aretak xebe' ru tijoxelab ri tat Juan, ri Jesús xuchaplej u tzijoxic ri tat Juan chque ri winak, xubij chque: ¿Jas xe' alak che rilic pa ri juyub ri cätz'inowic? ¿A xe' alak che rilic jun aj ri tajin cäslabisax rumal ri quiäkik'? ");
INSERT INTO qucTNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","We man are tä ri', ¿jas ri xil alak? ¿A xil alak jun achi ri je'l ri ratz'iak u cojom? Etam alak chi ri c'o je'lalaj tak catz'iak, e c'o ri e are' pa tak cachoch ri nimak tak takanelab. ");
INSERT INTO qucTNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Jas c'u ri xe' alak che rilic? ¿A xil alak jun k'alajisal re ru Lok' Pixab ri Dios? Je', je ri', —xcha'. Tzare c'u ri tat Juan nim na u banic chuwäch apachique k'alajisal re ru Lok' Pixab ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ri tat Juan are wa' ri tz'ibam can chrij pa ru Lok' Pixab ri Dios ri Tz'ibtalic ri cubij: Quintak na bi ri nu tako'n, cänabej c'u na chawäch ri cuban na u banic ra be, —cächa ri', —xcha ri Jesús chque ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Kas tzij ri quinbij chiwe chi chquixol conojel ri winak ri e c'olinak c'ä we cämic ri', man c'o tä jun ri nim na u k'ij chuwäch ri tat Juan Kasal Ja'. Pune je ri', ri jun ri man kas nim tä u banic ri cätakan ri Dios pa ranima', are nim na u k'ij wa' chuwäch ri tat Juan Kasal Ja', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tzpa tak ri k'ij ri xpe ri tat Juan Kasal Ja' c'ä cämic, ri winak xquichaplej lok u tijic qui chuk'ab rech queboc pa ru takanic ri Dios. Ri cäquicoj qui chuk'ab cäquichomaj chi e are' quech'acan na. ");
INSERT INTO qucTNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ri Pixab ri xutz'ibaj ri ka mam Moisés cubij chi cäpe na ri Dios rech cätakan pa qui wi' ri winak, xukuje' je' xquibij conojel ri k'alajisal tak re ru Lok' Pixab ri Dios c'ä xpe na ri tat Juan. ");
INSERT INTO qucTNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","We c'u ri ix kas quiwaj quicoj wa', ri tat Juan are ri k'alajisal re ru Lok' Pixab ri Dios ri cäpe na jas ri xpe ri ka mam Elías ojer. ");
INSERT INTO qucTNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Jachin tak ri cäquijiquiba canima' chutatabexic ri nu tzij, chquitatabej ba', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Jas ruc' queinjunamaj wi ri winak re we k'ij junab ri'? Ri winak cämic quejunamataj cuc' ri ac'alab ri queetz'en pa tak ri c'ayibal, cäquirak qui chi' che qui ch'abexic ri cachi'l, cäquibij: ");
INSERT INTO qucTNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Xkok'esaj ri su' chiwe, man xixxojow tä c'ut. Xka'n u k'ojom cäminak, man xixok' tä c'ut,” —quecha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Xpe c'u ri tat Juan ri man wi'j taj, ri man cutij tä vino. Ri winak c'ut cäquibij chi xa c'o jun itzel espíritu che. ");
INSERT INTO qucTNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Aretak c'ut xinpe in, in ri' ri Ralc'ual ri Dios ri Kas Winak, ri quinwi'c, ri quintij vino, conojel c'ut cäquibij chi xa in jik'alaj achi, in k'abarel, in cachi'l ajmaquib xukuje' tok'il tak alcabal. Ri winak ri utz ru chac k'alaj wa' chi c'o ri u no'j ri Dios ruc', —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ri Jesús c'ut xuchap qui yajic ri winak pa tak ri tinimit jawije' u banom wi q'uia tak cajmabal. Je ri', rumal chi ri winak ri e c'o chila' man qui q'uexom tä canima', man qui q'uexom tä c'u ri qui chomanic. Xubij c'u chque: ");
INSERT INTO qucTNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","¡C'äx iwe, winak re ri tinimit Corazín! ¡C'äx iwe, winak re ri tinimit Betsaida! We ta xeban wa' we cajmabal ri' pa tak ri tinimit Tiro, ri tinimit Sidón jas ri xebantaj iwuc' ix, q'uextajinak ta chi ri' ri canima', ri qui chomanic ri winak jela'. Xquicoj ta catz'iak ri' ri cuk'alajisaj chi quebisonic. Xukuje' c'o ta banom wi chi cuk'alajisaj chi are rumal ri qui mac chi quebisonic, —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Quinbij c'u chiwe ix chi pa ri k'ij ri cuk'at na tzij ri Dios, nim na ri c'äjisabal i wäch quirik na chuwäch ri c'äjisabal qui wäch ri cäquirik na ri winak aj Tiro, aj Sidón. ");
INSERT INTO qucTNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Are c'u ri ix winak aj Capernaum, ri sibalaj quinimarisaj iwib, c'ä pa ri k'ak' c'ut quixkasax wi na. We ta cuc' ri winak aj Sodoma xeban wi tak ri cajmabal ri xebantaj iwuc' ix, c'o ta na ri' ri qui tinimit cämic. ");
INSERT INTO qucTNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Quinbij c'u chiwe chi pa ri k'ij aretak cuk'at na tzij ri Dios, nim na ri c'äjisabal i wäch ix quirik na chuwäch ri cäquirik ri winak aj Sodoma, —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Pa ri k'ij ri' xubij ri Jesús: Quinnimarisaj k'ij la, Tat, Rajaw ri cajulew. Je ri', rumal chi xc'u' la ri etambal la chquiwäch ri winak ri c'o qui no'j, ri c'o quetambal, are c'utum c'u la wa' chquiwäch ri man c'o tä quetambal, ri je' ta ne chi e ac'alab. ");
INSERT INTO qucTNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Je', Tat, rumal chi je ri' ri utzalaj rayibal la chque ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ri nu Tat u jachom pa nu k'ab ronojel ri c'olic. Man c'o tä jun ri kas retam u wäch ru C'ojol ri Dios, xane xak xuwi ri ka Tat. Xukuje' man c'o tä jun ri kas retam u wäch ri ka Tat, xane xak xuwi ri in, in ri' ri u C'ojol, xukuje' jachin c'u tak chque ri cwaj quinbij wi jas ru banic ri ka Tat Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Chixsa'j wuc' in, iwonojel ri ix cosinak, iwonojel ri c'o iweka'n, quinya c'u uxlanem chiwe. ");
INSERT INTO qucTNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Chic'ama ri ekbal yunt ri quinya chiwij. Chiwetamaj iwe wuc' in rumal chi ri in c'o nu paciencia, man quinnimarisaj tä wib. Cuxlan c'u na ri iwanima'. ");
INSERT INTO qucTNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ri ekbal yunt ri quinya chiwij man c'äx tä ruc'axic. Ri eka'n c'ut ri quinya chiwij, man al tä ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Pa jun k'ij re uxlanem ri Jesús tajin coc'ow xol tak ri trico. Are c'u ru tijoxelab xpe qui numic, xquichap c'u u ch'upic ru jolom tak ri trico. Xquibak pa qui k'ab, te c'u ri' xquitijo. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Aretak ri tata'ib fariseos xquilo, xquibij che ri Jesús: Chilampe la, ri tijoxelab la tajin cäca'n chac ri äwas u banic pa tak ri k'ij re uxlanem. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ri Jesús xubij chque: ¿A mat c'o jumul ri siq'uim alak jas ri xuban ri ka mam David ojer aretak ri are' xuna' numic, xukuje' jas ri xca'n ri e c'o ruc'? ");
INSERT INTO qucTNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Xoc c'u bi ri ka mam David pa ri nimalaj rachoch Dios, xutij c'u re ri wa ri yo'm cho ri Dios, xuya c'u que ri e c'o ruc' xukuje'. Äwas c'u u tijic wa' cumal xak jachinok, xane xak xuwi chque ri sacerdotes ya'tal wi wa', —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Xukuje' xubij: ¿A mat c'o jumul ri siq'uim alak pa ri Pixab ri xutz'ibaj ri ka mam Moisés, chi ri sacerdotes ri quepatänin pa ri rachoch Dios man queuxlan tä pa ri k'ij re uxlanem? Pune ta ne je ri' man mac tä c'u ri' chi je' cäca'n wa'. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Quinbij c'u chech alak, chi waral c'o Jun ri nim na u banic chuwäch ri nimalaj rachoch Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ri alak xa man cäch'ob tä alak jas quel cubij wa' we tzij ri' ri tz'ibtal can pa ru Lok' Pixab ri Dios ri cubij: “Ri in cwaj chi ri ix quiban tok'ob chque ri winak, man are tä cwaj chi queicämisaj awaj che qui sipaxic chnuwäch,” —cächa ri'. We ta kas cäch'ob alak wa', mat cäk'at alak tzij chi cäc'äjisax qui wäch ri winak ri man c'o tä qui mac. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Are c'u ri' ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak, c'o nu takanic puwi' ri k'ij re uxlanem xukuje', —xcha ri Jesús chque ri tata'ib fariseos. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Xel c'u bi ri Jesús chila', xoc bi pa jun chque ri rachoch Dios ri cäquimulij wi quib ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","C'o c'u jun achi chila' ri cäminak jun u k'ab. Are c'u ri tata'ib fariseos cäcaj cäquitzucuj u mac ri Jesús, rumal ri' xquita' che: ¿A ya'talic cäcunax jun yawab pa ri k'ij re uxlanem? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Xch'aw ri Jesús, xubij chque: We jun chiwe c'o jun u chij, cätzak c'u bi pa jun c'ua' pa jun k'ij re uxlanem, ¿a mat que' ri' che resaxic? ");
INSERT INTO qucTNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","E ta c'u lo jun winak, are ri Dios nim na u banic cäril wi wa' chuwäch jun chij. Rumal ri' ya'tal u banic tok'ob pa tak ri k'ij re uxlanem, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Xubij c'u ri Jesús che ri achi: Yuku ri k'ab la, —xcha che. Xuyuk ru k'ab, xutzir c'ut. Je' chic ri u k'ab ri' jas ri jun chic. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Xebel c'u bi ri tata'ib fariseos, xquitala qui no'j chbil tak quib jas ri cäca'n chucämisaxic ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Aretak ri Jesús xuch'ob ri qui chomanic ri tata'ib fariseos, xel bi chila'. E q'uia c'u ri winak xeteri bi chrij. Ri Jesús c'ut xeucunaj conojel tak ri yawabib. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Xeutak c'u ri winak, xubij chque chi c'o jachin che mäquibij wi jachin ri Are'. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Xubij ri Jesús wa' rech je' quel wi jas ri xubij lok ri ka mam Isaías ri k'alajisal re ru Lok' Pixab ri Dios ri xubij: ");
INSERT INTO qucTNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Are wa' ri patänil we ri cha'tal wumal, ri sibalaj lok' chnuwäch, ri cäquicot ri wanima' rumal. Quinya na ri Lok'alaj nu Espíritu pa ranima' ri Are'. Cubij c'u na chque conojel qui wäch winak chi ri in quink'at na tzij pa qui wi'. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Man cäch'ojin taj, man curak tä u chi', man c'o ta jun cäto'w ri Are' co cäch'aw pa tak ri be. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","We c'o jun winak ri je' jas jun aj ri cotaquic, man cuk'up taj. We ne c'o jun winak ri junam jas jun candela ri man nim tä ru k'ak'al, man cuchup tä ri'. Xane cächacun na che rilic chi copan na ri k'ij aretak kas cäk'at na tzij ruc' jicomal. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Conojel c'u qui wäch winak cho ruwächulew, cäcu'bi na qui c'ux chrij ri Are', —xcha ri Dios chuchi' ri k'alajisal re ru Lok' Pixab. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Xc'am c'u bi jun achi ruc' ri Jesús. Ri achi mem xukuje' moy, c'o c'u jun itzel espíritu ruc'. Xcunax c'u rumal ri Jesús, je ri' chi ri achi xcowinic xca'yic xukuje' xch'awic. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Conojel ri winak xquicajmaj wa', xquibij: ¿A mat are wa' ri Ralc'ual can ri ka mam David ri cäbixic chi cäpe na? —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Aretak c'ut xquita ri tata'ib fariseos ri cäquibij ri winak, ri e are' xquibij: We achi ri' cäcowinic queresaj bi ri itzel tak espíritus chque ri winak xa rumal ru chuk'ab ri Beelzebú ri qui nimal ri itzel tak espíritus ri c'o ruc', —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ri Jesús xuch'obo jas ri tajin cäquichomaj, xubij c'u chque: Apachique k'atbal tzij ri u banom quieb, ri juch'ob k'atal tak tzij cäquiyac quib chquij ri juch'ob chic, ri k'atbal tzij ri' cäq'uis na u wäch. We jun tinimit o jun ja winak u banom quieb rumal chi c'o ch'oj chquixol, man naj tä ri' cuch'ijo. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Je ri' xukuje', we ta ri Satanás cäresaj bi ri Satanás, u banom quieb ri'. We ta je ri', ¿a naj ta c'u ri' cuch'ij ru takanic? ¡Man je' taj! ");
INSERT INTO qucTNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ri alak cäbij alak chi ri in quinwesaj bi ri itzel tak espíritus ruc' ru chuk'ab ri Beelzebú. We ta je ri', ¿jachin cäyo'w qui chuk'ab ri tijoxelab alak che quesaxic bi ri itzel tak espíritus? Kas are ri e are' cäquik'alajisaj chi xa sachinak alak. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ri in c'ut quinwesaj bi ri itzel tak espíritus ruc' ru chuk'ab ri Espíritu rech ri Dios ri c'o wuc'. Quel cubij wa' chi ri Dios c'o chi uc' alak rech cätakan puwi' alak, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Man c'o tä jun cäcowinic coc pa rachoch jun achi ri sibalaj c'o u chuk'ab, cärelak'aj c'u bi ri jastak re, we ta mat nabe cuyut na ri achi ri c'o u chuk'ab. Te c'u ri' cäcowinic cärelak'aj bi ri jastak re. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ri jun ri man junam tä u chomanic wuc', quinuc'ulelaj ri'. Ri jun ri man cächacun tä wuc', xak cutur ri' ri nu chac, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Rumal ri' quinbij chech alak: Ronojel mac ri cäca'n ri winak cuya' cäsachtaj na qui mac ri' rumal ri Dios, xukuje' ronojel ri äwas u bixic chrij ri Dios ri cäquibij ri winak cuya' cäsachtaj na qui mac ri'. Are c'u we cäquibij ri äwas u bixic chrij ri Lok'alaj Espíritu man cuya' taj cäsachtaj ri qui mac ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Apachin ri cubij tzij ri äwas u bixic chwij in, in ri' ri Ralc'ual ri Dios ri Kas Winak, cäsachtaj na u mac ri' che. Apachin c'u ri cubij ri äwas u bixic chrij ri Lok'alaj Espíritu, man cäsachtaj tä na u mac ri' che waral cho we uwächulew. Man cäsach tä c'u u mac ri' pa ri jun c'aslemal chic ri cäpe na, —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","We utz ri che', utz ru wäch ri cuya. We man utz tä ri che', man utz tä ru wäch ri' ri cuya. Ri jun che' rumal ru wäch cäch'obtajic jas u banic. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Ri alak, alak subanelab tak winak! ¿A cäcowin lo alak ri' chubixic utzalaj tak tzij, alak itzel tak winak c'ut? Ri quel lok pu chi' ri winak, are wa' ri kas c'o pa ranima'. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ri utzalaj winak, utz ri' ri cubij rumal rech ri utzil ri c'o pa ranima'. Ri itzel winak, man utz tä ri' ri cubij rumal chi etzelal wa' ri c'o pa ranima'. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Quinbij c'u chech alak, chi pa ri k'ij aretak cuk'at na tzij ri Dios, conojel ri winak cäquijach na cuenta rumal ronojel tzij ri qui bim ri man c'o tä u patän. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Jas c'u je' ri cätzijon ri winak, are je ri' ri k'atow tzij ri cäban na puwi'. Cäk'alajisax c'u na we c'o u mac o man c'o taj. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Jujun tata'ib fariseos cachi'l jujun tijonelab re ri Pixab, xquibij che ri Jesús: Ajtij, cäkaj chi cäban la jun cajmabal etal chkawäch rech cäkilo, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ri Jesús xch'awic, xubij chque: Ri lawalo tak winak, ri man jicom tä canima', cäcaj chi quinban jun cajmabal etal chquiwäch. Man cäyi' tä c'u wa' chque, xane xak xuwi ri etal chrij ri Jonás ri k'alajisal re ru Lok' Pixab ri Dios ojer. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Je' jas ri Jonás xc'oji chupam ri jun nimalaj cär oxib k'ij, oxib ak'ab, are c'u je' quinban na in, in ri' ri Ralc'ual ri Dios ri Kas Winak, quinc'oji c'u na xe' ri ulew oxib k'ij, oxib ak'ab. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ri winak aj Nínive, pa ri k'ij re ri k'atow tzij aretak cäk'at tzij pa qui wi' ri winak ri e c'o cämic, cäquik'at na tzij pa qui wi' chi cäc'äjisax qui wäch. Je ri', rumal chi ri winak aj Nínive, xquiq'uex ri canima', xquiq'uex c'u ri qui chomanic aretak ri Jonás xutzijoj ru Lok' Pixab ri Dios chque. Waral c'ut c'o Jun ri nim na u banic chuwäch ri Jonás. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Xukuje' ri nimalaj takanel ixok ri xc'oji chumox ri relbal k'ij, cäc'oji na pa ri k'ij re ri k'atow tzij. Aretak cäk'at tzij pa qui wi' ri winak ri e c'o cämic, ri are' cuk'at na tzij pa qui wi' chi cäc'äjisax qui wäch. Je ri', rumal chi ri ixok ri' naj xel wi lok, xpe c'u chutatabexic ri nimalaj retambal ri Salomón. Waral c'ut c'o wi Jun ri nim na u banic chuwäch ri Salomón. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Aretak jun itzelalaj espíritu quel bi che jun winak, xak cäwacatalob chic pa tak juyub ri cätz'inowic, cutzucuj jawije' cuxlan wi. Aretak man curik taj jawije' cuxlan wi, cubij: ");
INSERT INTO qucTNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Quintzelej na bi cho ri wachoch jawije' ri xinel wi lok,” —cächa'. Aretak copanic, curika ri ranima' ri winak je' u banic jun ja tolonic, mesom chi u pam, utz c'u banom che. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Que' c'ut, queuc'ama chi na wukub itzelalaj tak espíritus ri sibalaj e lawalo na chuwäch ri are'. Conojel wa' queboc pa ranima' ri winak. Ri winak ri' nim na ri c'äx curik na chuwäch ri c'äx ri xurik nabe. Je c'u wa' ri cäquic'ulmaj na ri lawalo tak winak cämic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ri Jesús tajin cätzijon na cuc' ri winak aretak xopan ru nan, e rachi'l ri rachalal. Xak c'u chrij ri ja e tac'atoj wi, cäcaj c'ut quetzijon ruc' ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","C'o c'u jun ri xubij che ri Jesús: Ri nan la, xukuje' ri chak' la e c'o chrij ri ja, cäch'abex la cumal, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Xubij c'u ri Jesús che ri xbin che: ¿Jachin ri' ri nu nan, xukuje' jachin tak ri kas e wachalal? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Xeuc'ut ru tijoxelab chquiwäch ri winak, te c'u ri' xubij: E are wa' je' ta ne ri nu nan, xukuje' ri nu chak', —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Je ri', rumal chi apachin ta ne ri cäbanow ru rayibal ri nu Tat ri c'o chila' chicaj, are wa' ri kas wachalal, ri nu chak', ri wanab, ri nu nan, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Pa ri k'ij ri' ri Jesús xel lok cho ja, xe' c'u chuchi' ri mar, xt'uyi c'u chila'. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Xquimulij c'u quib q'uia winak ruc', je ri' chi xoc bi ri Are' pa jun barco, xt'uyi c'u chupam. Conojel ri winak xecanaj can cho ri ulew chuchi' ri mar. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Xeucoj c'u tak c'utbal che qui tijoxic ri winak chquij q'uia u wäch tak no'j, xubij chque: Xel bi jun ticol ija' cho rachoch, xe' chubanic u tico'n, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Aretak tajin cujopij ri ija', xkaj jubik' ri ija' pa ri be. Xeopan c'u ri chicop ajuwocaj. Querapapic xekajic, xa xquitij bi ri ija'. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Xkaj chi jubik' xol tak ri abaj, ri man c'o tä wi q'uia ulew. Chanim c'ut xq'uiy ri jubik' ija' ri' rumal chi man pim tä ri ulew. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Aretak c'ut xel lok ri k'ij, xec'at ri alaj tak tico'n rumal, xechaki'jic rumal chi man kas tä c'u c'o qui xera'. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Xkaj chi c'u jubik' ri ija' pa tak ri k'ayes ri c'o qui q'uixol. Xeq'uiy c'u ri k'ayes, xequijik'isaj ri tico'n. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Are c'u ri niq'uiaj ija' chic xekaj pa utzalaj ulew. Sibalaj xewächinic. E c'o jujun tico'n xquiya jujun ciento qui wäch pa tak ri qui jolom ri trico chquijujunal, e c'o c'u jule' chic xquiya oxc'al qui wäch pa tak ri jujun qui jolom. Ri niq'uiaj tico'n chic xquiya juwinak lajuj qui wäch chquijujunal, —xcha ri Jesús chque ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","We ri ix quijiquiba ri iwanima' chutatabexic ri nu tzij, ¡chitatabej ba'! —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ru tijoxelab ri Jesús xekeb ruc', xquita' che: ¿Jas che cuc' tak c'utbal quetzijobej la ri winak? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ri Jesús xch'awic, xubij chque: Ri ix yo'm chiwe rumal ri Dios ri retamaxic ri man quetam tä ri niq'uiaj winak chic chrij ru takanic ri Dios pa qui wi' ri winak. Man ya'tal tä c'u chque ri e are' chi cäquich'ob wa'. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ri winak ri c'o c'o ruc', cäyi' chi na niq'uiaj che rech cänimar ri c'o ruc'. Are c'u ri winak ri man c'o tä c'o ruc', ri jubik' ri c'o ruc' quesax na che. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Rumal ri' queintzijobej ri winak cuc' tak c'utbal, rumal chi pune jakal ri qui wak'äch, man quecowin tä chuch'obic ri cäquilo, je' ta ne chi man queca'y taj. Pune cäquitatabej ri kas tzij, man cäquich'ob tä ri' ri qui tatabem. Je' ta ne chi man cäquita tä ri quinbij. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Are c'u je' cäbantaj na wa' cuc' ri e are' jas ri xubij ri ka mam Isaías ri k'alajisal re ru Lok' Pixab ri Dios: Ri ix, pune quitatabej ri kas tzij, man quich'ob taj. Pune quixca'yic, man quich'ob tä ri quiwilo. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Je ri', rumal chi abajarinak ri canima' we winak ri'. Man utz tä quetow tzij. Qui tz'apim c'u ri qui wak'äch rech man queca'y taj. Je' u banom ri canima' rech man cäquita taj, rech man cäkaj tä ri nu tzij pa canima', rech man quinquitzucuj taj rech queincunaj, —xcha ri Dios chuchi' ri k'alajisal re ru Lok' Pixab. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Are c'u ri iwe ix, sibalaj utz iwe, rumal chi tajin quiwil ri tajin quinbano, tajin quita ri tajin quinbij. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kas tzij quinbij chiwe chi e q'uia k'alajisal tak re ru Lok' Pixab ri Dios, xukuje' e q'uia utzalaj tak winak xcaj xquilo jas ri tajin quiwil ix cämic, man xquil tä c'ut. Xcaj xquita jas ri tajin quita ix cämic, man xquita tä c'ut, —xcha ri Jesús chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Chitatabej ba' jas quel cubij ri c'utbal chrij ri ticol ija', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ri ija' ri xekaj pa ri be, e are wa' jas ri winak ri cäquitatabej ru Lok' Pixab ri Dios chrij ru takanic ri Dios pa qui wi' ri winak, man cäquich'ob tä c'ut. Chanim cäpe ri Itzel, cäresaj c'u bi ri tzij ri xkaj pa canima'. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ri ija' ri xekaj xol tak ri abaj, e are wa' jas ri winak ri cäquita ru Tzij ri Dios ruc' quicotemal, je'l cäquito. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Rumal c'ut chi man kas tä c'o ri qui xera', xa quieb oxib k'ij cäquich'ijo. Aretak c'ut cäquichaplej u rikic c'äx, craj queyok'ic rumal rech ru Tzij ri Dios, chanim quetzak canok. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ri ija' ri xekaj pa tak ri k'ayes ri c'o qui q'uixol, e are wa' jas ri winak ri cäquita ru Tzij ri Dios, are c'u cäquilij na ri jastak rech we uwächulew ri', quesubtaj rumal ri k'inomal. Are c'u wa' cäjik'isan ru Tzij ri Dios, man cäwächin tä c'u ri' pa ri canima'. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Are c'u ri ija' ri xekaj pa utzalaj ulew, e are wa' jas ri winak ri cäquita ru Tzij ri Dios, cäquich'obo. Cäquiya c'u q'uia qui wäch. E je' jas ri ija' ri xquiya jujun ciento qui wäch chquijujunal, niq'uiaj chic e je' jas ri ija' ri xquiya oxc'al qui wäch chquijujunal, jujun chic e je' jas ri ija' ri xquiya juwinak lajuj qui wäch chquijujunal, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ri Jesús xucoj jun c'utbal chic chquiwäch: Ru takanic ri Dios pa qui wi' ri winak, are junam ruc' jun achi ri xutic utzalaj ija' pa ri rulew. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Xpe c'u jun u c'ulel ri ajchak'el ri tico'n. Aretak conojel tajin quewaric, xoc bi pa ri ulew, xutica c'u can itzel tak k'ayes xol tak ri trico. Te c'u ri' xe'c. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Aretak xq'uiy ri trico, xechomakir ru jolom, xukuje' xeq'uiy ri itzel tak k'ayes. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Xebe' c'u ri ajchaquib, xequibij che ri qui patrón: “Tat, we kas utz ri ija' ri xtic la, ¿jawije' c'ut xpe wi wa' we itzel k'ayes ri'?” —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Xubij c'u ri patrón chque: “Xa c'o jun nu c'ulel xbanow wa',” —xcha chque. Ri ajchaquib xquibij che ri qui patrón: “¿A caj la chi quekabok ri itzel tak k'ayes?” —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ri patrón xubij chque: “Man utz tä ri' we je' quibano, rumal chi we ne quibok bi ri trico junam ruc' ri itzel k'ayes. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Cheq'uiy na ri itzel tak k'ayes junam ruc' ri trico, chiweyej na c'ä curik ri k'atoj. Queintak c'u na bi ri ajchaquib rech nabe cäquimol ri itzel tak k'ayes, cäquixim pa tak yataj, te c'u ri' cäquiporoj. Are c'u ri trico cäquic'ol na pa ri nu c'uja,” —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ri Jesús xucoj chi jun c'utbal chquiwäch, xubij: Ru takanic ri Dios pa qui wi' ri winak, junam wa' ruc' ri ija' re ri tico'n ri cäbix “mostaza” che, ri cutic jun achi pa ri rulew. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kas tzij ri ija' ri' are ri sibalaj nitz' na chquiwäch conojel tak u wäch ija'. Aretak c'ut cäq'uiyic, are nim na que' chquiwäch conojel tak ri tico'n. Cuban jun nimalaj che', je ri' chi ri chicop ajuwocaj cäca'n ri qui soc xol tak ru k'ab, quemu'jan chupam, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ri Jesús xucoj chi jun c'utbal chquiwäch, xubij: Ru takanic ri Dios pa qui wi' ri winak, are je' jas ri ch'äm ri cuya jun ixok ruc' oxib pajbal c'äj, rech cuq'uiyisaj ronojel ri k'or re caxlan wa, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ronojel wa' we tzij ri' xubij ri Jesús chque ri winak cuc' tak c'utbal. Xak xuwi cuc' tak c'utbal xeutzijobej ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Je' xbantaj wa' rech kas je' quel wi jas ri xubij ri k'alajisal re ru Lok' Pixab ri Dios ri Tz'ibtal canok: Quintzijon na cuc' tak c'utbal, quinbij na ri man etamtal taj tzaretak ri Dios xuban ri cajulew, —xcha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Xtäni c'u ri Jesús che ru tzij, xeutak bi ri winak cho tak ri cachoch, ri Are' c'ut xoc pa ja. Are c'u ri tijoxelab xquirik quib ruc', xquibij che: Bij la chke jas quel cubij ri c'utbal chrij ri itzel k'ayes ri xtic can pa ri ulew, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ri Jesús xubij chque: Ri cäticow ri utzalaj ija', in ri' ri Ralc'ual ri Dios ri Kas Winak. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ri ulew are ronojel ruwächulew. Ri utzalaj ija' e are wa' ri winak ri cätakan ri Dios pa qui wi'. Ri itzel k'ayes e are wa' ri winak ri e rech ri itzel. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ri c'ulel ri xticow ri itzel k'ayes, are ri Itzel wa'. Ri k'atoj quel cubij ri q'uisbal re ruwächulew aretak cäq'uis ronojel. Ri quebanow ri k'atoj e are' ri ángeles. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Je' jas ri cäban che ri itzel k'ayes, cämolic, cäq'uiäk pa ri k'ak', are c'u je' cäban na pa ri q'uisbal re ruwächulew. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak, queintak na lok ri nu ángeles che qui molic conojel ri winak ri quequitakchi'j niq'uiaj winak chic che mac, xukuje' ri banal tak etzelal. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Quequiq'uiäk c'u na bi pa ri nimalaj k'ak', jawije' quebok' wi na, cäquikuch'uch'ej na ri qui ware. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Are c'u ri cäca'n ri craj ri Dios, queopan na jawije' ri cätakan wi ri ka Tat chila' chicaj. Quejuluw na je' jas ri k'ij. We quijiquiba ri iwanima' chutatabexic ri quinbij, ¡chitatabej ba'! —xcha ri Jesús chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ru takanic ri Dios pa qui wi' ri winak, quinjunamaj ruc' jun coxon puak ri muktalic. Cäriktaj c'u ri puak rumal jun achi. Ri are' cumuk chi c'u can jumul chic chila'. Rumal ru quicotemal que'c, cuq'uiyij ronojel ri jastak re, culok' ri ulew, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Xukuje' quinjunamaj ru takanic ri Dios ruc' jun ajc'ay ri cutzucuj je'lalaj tak abaj ri quejuluwic. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Aretak curik jun ri sibalaj pakal rajil, que'c, cuq'uiyij ronojel ri jastak re, culok' ri perla ri xuriko, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Xukuje' quinjunamaj ru takanic ri Dios pa qui wi' ri winak ruc' jun c'at chapäbal cär ri cäq'uiäk bi pa ri ja', queboc c'u ronojel qui wäch cär chupam. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Aretak nojinak chi ri c'at, quesax lok cumal ri chapal tak cär, cäquiya chuchi' ri ja', te c'u ri' quet'uyi che qui cha'ic ri cär. Ri utzalaj tak cär quequiya pa tak chicäch, are c'u ri man e utz taj, quequiq'uiäk can pa ri ja', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Are je wa' cäbantaj na aretak cäq'uis ruwächulew. Quepe ri ángeles che qui cha'ic ri utzalaj tak winak chquixol ri man e utz taj. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ri man e utz taj quequiq'uiäk na pa ri nimalaj k'ak'. Chila' quebok' wi na, cäquikuch'uch'ej na ri qui ware, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ri Jesús xuta' chque ri winak, xubij: ¿A quich'ob ronojel ri xinbij? —xcha chque. Cäkach'obo, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Xubij c'u ri Jesús chque: Aretak jun tijonel re ri Pixab craj cäretamaj ronojel chrij ru takanic ri Dios pa qui wi' ri winak, je' u banic ri' jas jun ajchak'el ja ri c'o q'uia jastak re. Aretak rajwaxic ri k'el che, cäresaj lok, cucojo. Aretak rajwaxic ri c'ac' che, cäresaj lok, cucojo, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Aretak xto'taj ri Jesús che qui tijoxic ri winak cuc' tak we c'utbal ri', xel bi chila'. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Xopan c'u pa ri u tinimit ri Are'. Xuchaplej qui tijoxic ri winak pa ri rachoch Dios ri c'o chila'. Are c'u ri winak sibalaj xquicajmaj wa', xquibij: ¿Jawije' xretamaj wi we achi ri' we no'j ri'? ¿Jas lo cubano che qui banic ri nimak tak cajmabal ri tajin quebantaj rumal? —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Are wa' ru c'ojol ri tata' ri kolol che', ru nan c'ut are ri nan María. Catz ri a Jacobo, ri a José, ri a Simón, xukuje' ri a Judas. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","E c'o c'u ri ranab kuc' waral xukuje'. ¿Jawije' c'ut xretamaj wi wa' ronojel ri tajin cubano? —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Rumal ri' ri winak xa tzel xquita ru tzij. Xubij c'u ri Jesús chque: Pa niq'uiaj tinimit chic, nim quil wi ronojel k'alajisal re ru Lok' Pixab ri Dios. Xak xuwi pa ru tinimit ri are', xukuje' chquixol ri rachalal, xukuje' cho rachoch man nim tä quil wi, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Man xcowin tä c'u ri Jesús chubanic q'uia tak cajmabal chila' rumal chi ri winak man xecojon tä che ri Are'. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Pa tak ri k'ij ri' ri tat Herodes, ri nim takanel pa Galilea, xretamaj ri tajin cuban ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Xubij c'u chque ri winak ri e c'o ruc': Are ri Juan Kasal Ja' ri' ri xc'astaj lok chquixol ri cäminakib, rumal ri' cäcowin ri are' chubanic q'uia u wäch cajmabal, —xcha ri tat Herodes chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tzare c'u ri tat Herodes xtakan chuchapic ri tat Juan rech cäyutic, cäyi' pa che', xa rumal rech ri nan Herodías ri xc'uli ruc' are' pune are rixokil ri Felipe ru chak'. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Xubij c'u ri tat Juan che ri tat Herodes: Man takal tä che la chi cäban ixokil la che ri rixokil ri chak' la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ri tat Herodes sibalaj craj cucämisaj ri tat Juan, cuxej c'u rib chquiwäch ri winak. Je ri', rumal chi conojel quetam chi ri Juan Kasal Ja', are jun k'alajisal re ru Lok' Pixab ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Xurik c'u ri nimak'ij re ri roc'owisaxic u junab ri tat Herodes. Are c'u ri ali ri ral ri nan Herodías xoc bi cuc', xuchap xojowem chquiwäch ri ula' ri e c'olic. Xkaj c'u ri ali chuwäch ri tat Herodes. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Sibalaj xkaj chuwäch, xuban c'u juramento chi cuya che ri ali apachique ta ne ri craj ri are'. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ri ali c'ut cojom chi lok u c'ux rumal ru nan, xubij che ri tat Herodes: Cwaj chi cäya la chwe ru jolom ri Juan Kasal Ja' pa jun plato, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Sibalaj c'u xbison ri tat Herodes. Rumal c'u rech chi xubij wa' ruc' juramento chquiwäch conojel ri rula' chi cuya che ri ali apachique ri cuta' che, xtakan c'u chuya'ic wa' che. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Xtakan che resaxic ru jolom ri Juan Kasal Ja' ri c'o pa che'. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Xc'am lok pa jun plato, xyi' c'u che ri ali. Ri ali c'ut xuya che ru nan. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Xeopan c'u ru tijoxelab ri tat Juan, xquic'am bi ru cuerpo, xequiya can pa jun mukubal. Xebe' c'ut, xequibij che ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ri Jesús, aretak xuto jas ri xbantaj che ri tat Juan, xel bi chila' u tuquiel, xoc pa jun barco, xe' c'u jela' jawije' ri man c'o tä wi winak. Xquetamaj c'u ri winak chi ri Jesús benak jela'. Xebel lok pa tak ri qui tinimit, xebe' c'u chi cakan churikic ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Aretak xel lok ri Jesús pa ri barco, xeril ri q'uialaj winak, xel c'u u c'ux chque. Xeucunaj ri yawabib ri xquic'am bi jela' cuc'. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kajem c'u cuban ri k'ij, ru tijoxelab ri Jesús xekeb ruc', xquibij che: We juyub ri' ri uj c'o wi sibalaj cätz'inowic, benak chi c'u ri k'ij. Chetaka la bi ri winak rech quebe' pa ri alaj tak tinimit ri nakaj e c'o wi, rech cäquilok' c'u na ri qui wa, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ri Jesús xubij chque: Man rajwaxic taj quebe'c, xane xa chiya ix ri cäquitijo, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Xquibij c'u ru tijoxelab che: Xa job caxlan wa rachi'l quieb cär c'o kuc', —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ri Jesús xubij chque: Chic'ama lok chwe waral, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Xtakan c'u ri Jesús chi quet'uyi ri winak cho ri räxalaj uwosak. Ri Jesús xeuc'am c'u ri job caxlan wa xukuje' ri quieb cär, xca'y chicaj, xeutewchij. Te c'u ri' xeupir ri caxlan wa, xeuya chque ri tijoxelab rech quequijach wa' chquiwäch ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Xewi' c'u conojel, xenoj c'ut. Te c'u ri' xequic'ol ri ch'akatak ri xecanaj canok. Xuban cablajuj chicäch wa' chi ronojel. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Craj are job mil achijab ri xewi'c. Man xeajilax tä c'u ri ixokib xukuje' ri ac'alab (ri xukuje' xewi'c). ");
INSERT INTO qucTNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Te c'u ri' ri Jesús xubij chque ru tijoxelab chi utz we queboc pa ri barco rech quebe'c, quenabej apan chuwäch ri Are' rech queopan ch'äkäp che ri mar. Are c'u ri Are' xcanaj na can cuc' ri q'uialaj winak che qui jachic bic. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Aretak e jachtajinak chi bi ri winak rumal ri Jesús, xe' ri Are' puwi' ri juyub u tuquiel chubanic orar. Aretak xoc ri ak'ab, ri Jesús u tuquiel c'o chila'. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Are c'u ri tijoxelab e c'o chi pa ri barco puwi' ri ja' pu niq'uiajal ri mar. Ri nimak tak uwoja' xupuq'uij rib chrij ri barco, rumal chi xa chquiwäch petinak wi ri quiäkik'. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Xa c'u jubik' man cäsakiric aretak xopan ri Jesús cuc', tajin cäbin puwi' ri ja'. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Aretak ri tijoxelab xquilo chi cäbin ri Jesús puwi' ri ja', xquixej quib. Rumal rech chi xquixej quib xquirak qui chi', xquibij: ¡Are jun xibinel wa'! —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Chanim ri Jesús xeuch'abej, xubij chque: ¡In wa', mixej iwib, chichajij anima'! —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Xch'aw c'u ri tat Pedro, xubij che: We lal ri', Tat, takan la chi quinbin puwi' ri ja', rech quinopan uc' la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ri Jesús xubij che: Tasa'j ba', —xcha ri Jesús che. Ri tat Pedro xel bi pa ri barco, xuchaplej binem puwi' ri ja' rech curika ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Aretak c'ut xrilo chi sibalaj c'o u chuk'ab ri quiäkik', xuxej rib. Xe' ri rakan pa ri ja', xurak u chi', xubij che ri Jesús: ¡Wajaw, chinto' la! —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ri Jesús chanim xuchap che ru k'ab, xubij che: ¡Tzij ri' chi man kas tä catcojonic! ¿Jas che xuban quieb a c'ux? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Aretak c'ut xpaki ri Jesús pa ri barco, xtäni ri quiäkik'. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ri e c'o pa ri barco xexuqui chuwäch ri Jesús, xquibij che: Kas tzij, lal ri' ri u C'ojol ri Dios, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Xek'ax pa ri mar, xeopan c'u chuchi' ri ulew pa Genesaret. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Aretak ri winak ajchila' xquich'ob u wäch ri Jesús, xquesaj u tzijol wa' pa tak ri tinimit. Xequic'am c'u lok conojel ri yawabib jawije' chi' c'o wi ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Xquibochi'j ri Jesús chi xuwi ta ne cuya chque chi cäquichap cok ru chi' ru k'u'. Conojel c'u ri xechapowic, xeutziric. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Te ri' jujun tata'ib fariseos xukuje' jujun chque ri tata'ib tijonelab re ri Pixab ri e petinak pa ri tinimit Jerusalén, xquimulij quib chrij ri Jesús, xquita' che: ");
INSERT INTO qucTNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","¿Jas che ri tijoxelab la man cäca'n taj jas ri e nak'atal wi ri ka nan ka tat ojer? Man cäca'n taj jas ri nak'atal u banic. Are wa' ru ch'ajic ri rij ri qui k'ab aretak mäja' quewi'c, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Xuta' c'u ri Jesús chque: E ri alak, ¿jas che yo'm can alak ru Lok' Pixab ri Dios? Chuq'uexwäch wa' are jiquibam anima' alak chrij ri nak'atal wi alak. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Cubij c'u ri Dios pa ri Lok' Pixab ri Tz'ibtalic: “Nim cheawila wi ra nan a tat,” —cächa'. Xukuje' cubij: “Jachin ri cuyok' ru nan u tat, tzrajwaxic wi ri' cäcämisaxic,” —cächa', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ri alak c'ut cäbij alak chi xak xuwi rajwaxic cubij jun achi chque ru nan u tat: “Ronojel ri quincowinic quincoj che to'ic alak, nu yo'm cho ri Dios,” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","We ri achi je' cubij wa', man cäya tä alak che chi c'o jas cuban che qui to'ic ru nan u tat. Je ri' man nim tä chic quil wi alak ru Tzij ri Dios, man c'o tä c'u u patän ru Lok' Pixab ri Dios chuwäch alak rumal ru banic ri nak'atal wi alak. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Xak quieb wäch alak! Kas tzij ri xubij ri ka mam Isaías ri k'alajisal re ru Lok' Pixab ri Dios chij alak aretak xutz'ibaj can we tzij ri' ri cubij: ");
INSERT INTO qucTNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","We winak ri' xak chi qui chi' cäquinimarisaj nu k'ij, Man kas tä cäquijiquiba ri canima' chwij, —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Xak lok' quek'ijilan chwe, xak c'u qui takanic winak cäquiya che tijonic, —xcha ri Dios chuchi' ri ka mam Isaías. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ri Jesús xeusiq'uij ri winak ruc', xubij chque: Alak, onojel alak, tatabej alak ri nu tzij, ch'obo alak ri quinbij. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ri cutij ri winak, man are tä ri' ri quetzelan u wäch ru c'aslemal, xane xa are ri quel lok pu chi' ri winak are wa' ri quetzelan u wäch ru c'aslemal, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Xekeb c'u ri tijoxelab ruc' ri Jesús, xquibij che: ¿A etam la chi ri tata'ib fariseos c'äx xquina' ri xbij la? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ri Jesús xch'awic, xubij chque: Apachique u wäch tico'n ri man xtic tä rumal ri nu Tat ajchicaj, cäbok na apanok. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Xak je' tak que la' ri fariseos. Ri e are' e je' jas moyab ri cäquic'am qui be niq'uiaj moyab chic. We jun moy cuc'am u be jun moy chic, ri quieb ri' quetzak na pa jun jul. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Xubij c'u ri tat Pedro che ri Jesús: Bij la chke jas quel cubij ri c'utbal ri xcoj la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ri Jesús xubij che: ¿A mat lo quich'ob wa' ri ix? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿A mat iwetam chi ronojel ri cutij ri winak pa ri rixco'l que' wi, quel c'u canok aretak cubana ru chul? —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Are c'u ri quel lok pu chi' ri winak, pa ranima' ri' quel wi lok. Are c'u wa' ri quetzelan u wäch ru c'aslemal. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Je ri', rumal chi pa ranima' ri winak quel wi lok ri itzel tak chomanic, ru banic cämisanic, ru banic ri nimalaj mac ruc' ri rixokil jun winak chic, ru banic jas ri cäca'n ri tz'i' ri xak cäquirik quib, man c'o tä qui pixab, ru banic elak', ru banic ri banow tzij, xukuje' ru yaquic tzij chrij jun winak chic. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","E are wa' we etzelal ri' ri quetzelan u wäch ru c'aslemal ri winak cho ri Dios. Are c'u we jun winak man cuban tä ri nak'atal u banic, man cuch'aj tä ri rij ru k'ab aretak mäja' cäwi'c, man cäretzelaj tä ru c'aslemal ri' cho ri Dios, —xcha ri Jesús chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Xel bi ri Jesús chila', xe'c, xopan pa Fenicia chunakaj ri tinimit Tiro, xukuje' ri tinimit Sidón. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Xpe c'u jun ixok aj Cananea ri c'o chila', xopan ruc' ri Jesús, xurak c'u u chi', xubij: ¡Tat, lal ri' ri rachalaxic can ri David, chel c'ux la chwe! Ri wal ali c'o jun itzel espíritu che, sibalaj curik c'äx rumal, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ri Jesús c'ut man c'o tä jun tzij xubij che. Xepe c'u ru tijoxelab ri Jesús, xquita' tok'ob che, xquibij: Taka la bi ri chichu' rumal chi xak curak u chi' teren chkij, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Xubij c'u ri Jesús chque: Ri Dios in u takom lok xak xuwi cuc' ri winak aj Israel, rumal chi ri e are' e je' ta ne chij ri e sachinak, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Xpe c'u ri ixok, xkeb ruc' ri Jesús, xxuqui chuwäch, xubij che: ¡Tat, chinto' la! —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ri Jesús xubij che: Man utz tä ru chapic ri qui wa ri kas ralc'ual jun, cäq'uiäk ta c'u chquiwäch ri alaj tak tz'i', —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Xubij c'u ri ixok che: Je', Tat. Xukuje' ne ri alaj tak tz'i' ri queboc pa ja, cäquitij ru xe'r tak qui wa ri cajaw ri quetzak pulew, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ri Jesús xubij che ri ixok: ¡Kas tzij ba' chi nim ri cojonic la, nan! Chbantaj ta ba' jas ri caj la, —xcha che. Tzare chi' c'ut xutzir ri ral ali. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Xel bi ri Jesús chila', xoc'ow chuchi' ri mar re Galilea. Te c'u ri' xpaki puwi' jun juyub, xt'uyi c'u chila'. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Xeopan c'u q'uia winak ruc' cuc'am bi ch'ocojib, moyab, memab, winak ri c'äx u banom ri qui k'ab, xukuje' e q'uia ri c'o niq'uiaj yabil chic chque. Xequiya chuwäch ri Jesús, ri Are' c'ut xeucunaj. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ri winak sibalaj xquicajmaj aretak xquilo chi ri memab xech'aw chic, ri c'äx u banom qui k'ab xeutziric, ri ch'ocojib xebin chic, ri moyab xeca'y chic. Xquichap c'u u nimarisaxic u k'ij ri Dios aj Israel. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ri Jesús xeusiq'uij ru tijoxelab, xubij chque: Quel nu c'ux chque ri winak rumal chi oxib k'ij chi wa' e c'o wuc', man c'o tä c'u jas cäquitijo. Man cwaj taj queintak bi cho tak cachoch mäja' c'u quewi'c, quetzak ta c'u ne pa tak ri be, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ru tijoxelab xech'awic, xquibij che: ¿Jawije' ta c'u lo cäkarik wi ri wa ri cäkaya chque we q'uialaj winak ri' waral pa we juyub ri' ri cätz'inowic? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Xuta' c'u ri Jesús chque: ¿Janipa' caxlan wa c'o iwuc'? —xcha chque. Ri e are' xquibij: Wukub caxlan wa, rachi'l quieb oxib alaj tak cär, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Xtakan c'u ri Jesús chque ri q'uialaj winak chi quecu'bi pulew. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Te c'u ri' xeuc'am ri wukub caxlan wa, xukuje' ri alaj tak cär, xmaltioxinic. Xeupiro, xeuya chque ru tijoxelab rech cäquijach wa' chquiwäch ri winak. Je c'u ri' xca'no. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Xewi' c'u conojel ri winak, xenojic. Xequimulij c'u ri ch'akatak tak wa ri xecanaj canok. Ronojel wa' xuban wukub chicäch wa. ");
INSERT INTO qucTNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","E quiejeb mil achijab c'ut ri xewi'c. Man xecajilaj tä c'u ri ixokib xukuje' ri ac'alab (ri xukuje' xewi'c). ");
INSERT INTO qucTNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Te c'u ri' ri Jesús xeujach bi ri winak rech quebe' cho tak cachoch. Ri Are' xoc bi pa ri barco, xe' pa ri tinimit Magdala. ");
INSERT INTO qucTNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ri tata'ib fariseos xukuje' ri tata'ib saduceos xeopan ruc' ri Jesús. Te c'u ri' xquita' che chi cuc'ut chquiwäch jun cajmabal etal ri cäpe chicaj. Xquibij wa' che xak rech cäkaj ri Jesús pa qui k'ab. ");
INSERT INTO qucTNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Xch'aw c'u ri Jesús, xubij chque: Pa benak tak k'ij cäbij alak: “Sak'ij wa' cubano rumal chi quiäk ri uwocaj,” —cächa alak. ");
INSERT INTO qucTNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Are c'u ri ak'abil cäbij alak: “Cämic cäpe jäb rumal chi quiäk ri uwocaj, xukuje' k'ekmuj,” —cächa alak. ¡Ri alak xak quieb wäch alak! Cäcowin alak chuch'obic ri u wäch ri caj, man cäch'ob tä c'u alak jas ri tajin cuc'ut ri Dios chuwäch alak pa tak we k'ij junab ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","We winak ri' ri e lawalo, ri man jicom tä canima', cäcaj chi quinban jun cajmabal etal chquiwäch. Man cäyi' tä chi c'u na jun etal chque, xane are quinna'taj chque ri etal rech ri Jonás, —xcha chque. Ri Jesús xeuya can wa' we achijab ri', xe'c. ");
INSERT INTO qucTNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Aretak xek'ax ru tijoxelab ri Jesús ch'äkäp che ri mar, xsach pa qui jolom ru c'amic bi qui wa. ");
INSERT INTO qucTNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Xubij c'u ri Jesús chque: ¡Chitampe'! Chichajij iwib chuwäch ri qui ch'amil ri tata'ib fariseos xukuje' chuwäch ri qui ch'amil ri tata'ib saduceos, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Xquitzijobela c'u quib ri tijoxelab, xquibij: Ri Are' cubij wa' chke rumal chi man c'o tä ka wa ka c'amom lok, —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Aretak ri Jesús xretamaj jas ri tajin cäquibij, xubij chque: ¿Jas che tajin quibij chi man c'o tä i wa? ¡Tzij ri' chi xa man kas tä quixcojonic! —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿A xak are mäja' quich'obo, man cäna'taj tä chiwe chi xinpir ri job caxlan wa, xinjach c'u wa' chquiwäch ri job mil winak? ¿A mat cäna'taj chiwe janipa' chicäch ch'akatak tak caxlan wa ri man xeq'uis taj ri xeic'olo? ");
INSERT INTO qucTNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿A mat c'u cäna'taj chiwe xukuje' chi xinpir ri wukub caxlan wa, xinjach c'u wa' chquiwäch quiejeb mil winak, janipa' chicäch ch'akatak tak caxlan wa ri man xeq'uis taj ri xeic'olo? ");
INSERT INTO qucTNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Jas che man quich'ob taj chi ri in man are tä tajin quinbij ri caxlan wa aretak xinbij chi quichajij iwib chuwäch ri qui ch'amil ri tata'ib fariseos xukuje' ri tata'ib saduceos? —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Te c'u ri' ri tijoxelab xquich'obo chi ri Jesús man are tä xubij chque chi cäquichajij quib chuwäch ri ch'äm re caxlan wa, xane chuwäch ri qui tijonic ri tata'ib fariseos xukuje' ri tata'ib saduceos. ");
INSERT INTO qucTNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Aretak ri Jesús tajin cänakajin che ri tinimit Cesarea Filipo, xuta' chque ru tijoxelab, xubij chque: ¿Jas cäquibij ri winak chwij chi jachin ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Xquibij c'u che: E c'o jujun winak cäquibij chi lal ri' ri Juan Kasal Ja', xukuje' cäquibij jule' chic chi lal ri' ri ka mam Elías. E c'o chi niq'uiaj cäquibij chi lal ri' ri ka mam Jeremías o jun chic chque ri ojer k'alajisal tak re ru Lok' Pixab ri Dios, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Xuta' c'u ri Jesús chque: E c'u ri ix, ¿jachin ri in ri quibij ix? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Xch'aw ri tat Pedro, xubij che: Lal ri' ri Cristo, ru C'ojol ri c'aslic Dios, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ri Jesús xch'awic, xubij che: Utz awe, Simón, u c'ojol ri tat Jonás, rumal chi man are tä jun winak ri xbin wa' chawe, xane are ri nu Tat ri c'o chila' chicaj. ");
INSERT INTO qucTNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ri in quinbij chawe chi ri at, at Pedro. Puwi' c'u we nimalaj abaj ri' queinjekba wi na ri winak ri quecojon chwe. Man cäcowin tä c'u na ri cämical chusachic qui wäch, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Queinya chawe ri lawe re ri c'olibal ri takan wi ri Dios. Jachique ri cak'alajisaj chi man utz tä u banic cho ruwächulew, man utz tä u banic ri' chila' chicaj. Jachique ri cak'alajisaj chi utz u banic cho ruwächulew, utz u banic ri' chila' chicaj. ");
INSERT INTO qucTNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ri Jesús c'ut xeupixbaj ru tijoxelab, xubij chque chi mäquitzijoj wa' che jachin jun chi ri Are' are ri Cristo. ");
INSERT INTO qucTNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tzare chi' c'ut ri Jesús xuchaplej u k'alajisaxic chquiwäch ru tijoxelab chi ri Are' rajwaxic que' na pa ri tinimit Jerusalén. Xubij chi cäban na sibalaj c'äx che cumal ri qui nimakil ri winak, cumal ri qui nimakil ri sacerdotes, xukuje' cumal ri tijonelab re ri Pixab. Xukuje' rajwaxic chi cäcämisax na, te ri' cäc'astaj chi c'u na churox k'ij chquixol ri cäminakib. ");
INSERT INTO qucTNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Are c'u ri tat Pedro xuc'am bi ri Jesús u tuquiel wi. Xuchaplej u yajic, xubij che: ¡Mat craj ri Dios wa', Wajaw! ¡Mat je' cäc'ulmaj la wa'! —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Xutzolk'omij c'u rib ri Jesús, xubij che ri tat Pedro: ¡Chatel chnuwäch, Satanás, xak at ya'l latz' chwe! Man cach'ob tä c'u ru chomanic ri Dios, xane xak xuwi cach'ob ri qui chomanic winak, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ri Jesús c'ut xubij chque ru tijoxelab: We c'o jun craj cäpe wuc' in, rajwaxic chi muban chic xak jas ri craj ri are'. Rajwaxic cutelej lok ru cruz, cäpe wuc' in, —xcha chque. (Quel cubij wa' chi ri winak ri' man nim tä chic cäril ru c'aslemal, xane cuya u tzij pune ta ne curik ri cämical rumal rech ri Jesús.) ");
INSERT INTO qucTNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Je ri', rumal chi apachin ta ne ri craj cuto' u wi' ru c'aslemal cho ruwächulew, cäcäm na ri winak ri', cutzak na ronojel. Apachin c'u ri cuya ru c'aslemal pa ri c'äx rumal wech in, cuto' na u wi' ri' ri kas u c'aslemal wa'. ");
INSERT INTO qucTNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Jas ta c'u lo ri cuch'ac jun winak we cärechbej ronojel ruwächulew, cutzak c'u na ri ranima'? ¿Jas ta c'u lo ri cäcowin ri winak chuya'ic chuq'uexwäch ri ranima'? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Quinpe c'u na in, in ri' ri Ralc'ual ri Dios ri Kas Winak, e wachi'l ri lok'alaj tak ángeles. Cänimarisax na nu k'ij jas ru nimarisaxic u k'ij ri nu Tat. Quinya c'u na ri tojbal que ri winak chquijujunal jas ri xca'n ri e are' pa ri qui c'aslemal. ");
INSERT INTO qucTNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Kas tzij quinbij chiwe chi e c'o jujun chque ri e c'o waral ri man quecäm tä na c'ä quinquil na in, in ri' ri Ralc'ual ri Dios ri Kas Winak, in petinak rech quintakan pa qui wi' ri winak, —xcha ri Jesús chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Xque' wakib k'ij u bim can ri Jesús wa', aretak xeuc'am bi ri tat Pedro, ri tat Jacobo, xukuje' ri tat Juan ru chak' ri tat Jacobo. Qui tuquiel wi xepaki puwi' jun nimalaj juyub. ");
INSERT INTO qucTNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Xq'uextaj c'u ru cayebal ri Jesús chquiwäch. Ru palaj ri Jesús xjuluwic je' jas ri k'ij. Ri ratz'iak xuban sibalaj sakloloj je' jas ri sakil. ");
INSERT INTO qucTNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Xak c'u te'talic xquic'ut quib quieb achijab ri tajin quetzijon ruc' ri Jesús. E are' ri ka mam Moisés rachi'l ri ka mam Elías. ");
INSERT INTO qucTNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Xch'aw c'u ri tat Pedro, xubij che ri Jesús: Kajaw, ¡sibalaj utz chi uj c'o waral! We caj la, cäka'n na oxib mo', jun che la, jun che ri ka mam Moisés, jun chic che ri ka mam Elías, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Aretak tajin cätzijon ri tat Pedro, xkaj lok jun sakloloj sutz' chquij, xech'uktaj c'u rumal. Te c'u ri' xch'aw lok Jun chupam ri sutz', xubij: Are ri lok'alaj nu C'ojol wa', sibalaj cäquicot ri wanima' rumal. Chitatabej ba' ri cubij, —xcha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ri tijoxelab, aretak xquita wa', sibalaj xquixej quib. Xexuqui'c xquikasaj ri qui palaj cho ri ulew. ");
INSERT INTO qucTNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Are c'u ri Jesús xkeb cuc', xeuchap c'u kajok, xubij chque: Mixej ba' iwib. Chixwalijok, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ri e are' chanim xeca'ylobic. Man c'o tä chi c'u jachin xquilo, xane xak xuwi ri Jesús c'o cuc'. ");
INSERT INTO qucTNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kajem que lok cho ri juyub, ri Jesús xeupixbaj, xubij chque: C'o jachin mitzijoj wi ri iwilom c'ä quinc'astaj na chquixol ri cäminakib, in ri' ri Ralc'ual ri Dios ri Kas Winak, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ri tijoxelab xquita' che ri Jesús, xquibij che: ¿Jas che cäquibij ri tijonelab re ri Pixab chi rajwaxic cäpe na ri ka mam Elías nabe? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Xch'aw c'u ri Jesús, xubij chque: Tzij ri' chi cäpe ri ka mam Elías nabe, rech cuban na u banic ronojel. ");
INSERT INTO qucTNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ri in c'ut quinbij chiwe chi ya ulinak chic ri ka mam Elías. Ri winak c'ut man xquich'ob tä u wäch, xane xa xca'n che ri are' jas ri xcaj xca'no. Je c'u ri' xukuje' ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak, quinrik na c'äx pa qui k'ab, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Xquich'ob c'u ri tijoxelab chi ri tajin cubij ri Jesús chque, are ri Juan Kasal Ja'. ");
INSERT INTO qucTNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Aretak c'ut xeopan chila' jawije' e c'o wi ri q'uialaj winak, xpe jun achi, xopan ruc' ri Jesús, xxuqui c'u chuwäch, xubij che: ");
INSERT INTO qucTNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Tat, chel c'ux la che ri nu c'ojol, xa c'o jun itzel espíritu che, sibalaj c'u curik c'äx rumal. Q'uia mul cätzak pa ri k'ak', pa ri ja'. ");
INSERT INTO qucTNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Xinc'am lok, xinya chquiwäch ri tijoxelab la, ri e are' c'ut man xecowin tä chucunaxic, —xcha che ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ri Jesús xch'awic, xubij: ¡Ay, ri alak winak ri man cäcojon tä alak che ri Dios! ¡Xak xuwi cäban alak jas ri caj alak! ¿A are lo caj alak chi xak tajin wi quinc'oji uc' alak ronojel k'ij? ¿A are lo caj alak chi xak quincuy alak? C'ama ba' alak lok ri ala chnuwäch, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ri Jesús c'ut xuyaj ri itzel espíritu ri c'o che ri ala, xresaj bic. Tzare chi' xutzir ri ala, utz chi c'u canok. ");
INSERT INTO qucTNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ru tijoxelab ri Jesús xquita' che pa u tuquiel wi: ¿Jas che ri uj man xujcowin tä che resaxic bi ri itzel espíritu ri'? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Xubij ri Jesús chque: Are wa' rumal chi man kas tä c'o ri i cojonic, —xcha chque. Kas tzij quinbij chiwe chi we ta ri i cojonic je' jas ri in nitz' ija' re mostaza, quixcowin ri' quibij che we juyub ri': “¡Chatel bi chi', jat jela'!” —quixcha che. Ri juyub quel na bic. Man c'o tä ri mat quixcowin chubanic we ta kas tzij quixcojonic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Xak xuwi ruc' ru banic orar, xukuje' ruc' ru banic ayuno quel bi jun itzel espíritu ri je' u banic wa', —xcha ri Jesús chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Aretak xetzelej bi cuc' ri q'uialaj winak, ri Jesús xubij chque ru tijoxelab: Ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak, quinjach na pa qui k'ab ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Quincämisax na, churox k'ij c'ut quinc'astaj na chquixol ri cäminakib, —xcha chque. Aretak xquita wa' ri tijoxelab, sibalaj xebisonic. ");
INSERT INTO qucTNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Aretak ri Jesús cuc' ru tijoxelab xeopan pa ri tinimit Capernaum, ri tok'il tak alcabal re ri nimalaj rachoch Dios xeopan ruc' ri tat Pedro, xquibij che: ¿A mat cutoj re ri ajtij alak ri alcabal re ri nimalaj rachoch Dios? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Je', je ri', —xcha ri tat Pedro chque. Aretak c'ut xoc bi ri tat Pedro pa ri ja, nabe xch'aw ri Jesús, xubij che: Simón, ¿jas cachomaj? ¿Jachin tak chque cäquita' wi ri alcabal o ri cuchuj ri nimak tak takanelab rech ruwächulew? ¿A cäquita' wa' chque ri qui winakil o chque ri man qui winakil taj? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ri tat Pedro xch'awic, xubij che: Chque ri man qui winakil taj cäquita' wi wa', —xcha che. Ri Jesús xubij che: We je ri', ri winak ri quebel pa ri qui tinimit ri nimak tak takanelab man c'o tä alcabal ri' cäquitojo, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Man cwaj tä c'ut chi quinyac royowal jachin jun winak. Rumal ri' jat chuchi' ri mar, chaq'uiäka bi ri anzuelo pa ri ja'. Chawesaj lok ri nabe cär ri cachapo, pu chi' c'ut cawesaj wi jun puak. Ruc' ri puak ri' catoj ri alcabal re ri nimalaj rachoch Dios, ri wech in xukuje' ri awech at. Chac'ama c'u wa', cate' c'ut, catojo canok, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Pa ri k'ij ri' ri tijoxelab xquimulij quib ruc' ri Jesús, xquita' che: ¿Jachin ri nim na u banic chila' jawije' ri cätakan wi ri Dios? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ri Jesús xusiq'uij apan jun alaj ac'al, xuc'amo, xutac'aba chquiwäch ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Xubij c'u chque: Kas tzij quinbij chiwe. We ri ix man quiq'uex tä ri iwanima', ri i chomanic, we man quiban iwe jas ri cäca'n ri ac'alab man cäca'n tä nimal, man quixopan tä ri' chila' jawije' ri cätakan wi ri Dios, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Je c'u ri' quinbij chiwe chi ri nim na u banic chila' jawije' ri cätakan wi ri Dios, are ri man nim tä cuban che rib, cuban c'ut jas we ac'al ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Apachin ri cuc'ulaj jun ac'al jas we ac'al ri' rumal wech in, in ri' quinuc'ulaj, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Apachin c'u ri cubano chi jun chque we ch'utik ri' ri quecojon chwe curik ri be ri man utz taj, are utz ri' we ta cäxim jun ca' re molino chukul ri winak ri', cäq'uiäk ta c'u bi pa ri mar. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Sibalaj c'äx chque ri winak cho ruwächulew chi c'o jas ri cubano chi ri winak cäquirik ri be ri man utz taj! Amak'el c'ut cäquic'ulmaj wa'. Sibalaj c'äx c'u re ri winak ri cubano chi jun winak chic curik ri be ri man utz taj. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Rumal ri', we ri a k'ab o ri awakan cubano chi ri at carik ri be ri man utz taj, chak'ata', chaq'uiäka apanok. Are utz na chawe we carik na ri kas c'aslemal pune at cut o at ch'oco', chuwäch ri c'o quieb a k'ab o quieb awakan cate' pa ri c'atic jawije' c'o wi ri k'ak' ri man cächuptaj taj. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","We are ri a wak'äch cubano chi carik ri be ri man utz taj, chawesaj, chaq'uiäka apanok. Are utz na chawe we carik na ri kas c'aslemal pune xa jun ra wak'äch c'olic, chuwäch ri c'o quieb a wak'äch, catq'uiäk bi pa ri nimalaj k'ak', —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Miwetzelaj ba' qui wäch jun chque we ch'utik ri' ri quecojon chwe. Quinbij c'u chiwe chi ri e are' amak'el ronojel k'ij c'o ri qui ángeles chuwäch ri nu Tat chila' chicaj. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Je ri', rumal chi ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak, xinpe che qui to'ic ri winak ri e sachinak. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Jas quichomaj chrij ri quinbij na? We c'o jun achi ri c'o jun ciento u chij, cätzak c'u can jun chque, ¿a mat queuya na can ri' ri jumuch' belejlajuj pa ri juyub, que' c'u chutzucuxic ri jun ri xtzak canok? Je', je ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","We curiko, sibalaj cäquicot na ruc'. Nim na ru quicotemal ruc' wa' chuwäch ru quicotemal cuc' ri jumuch' belejlajuj ri man xetzak taj. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Je c'u ri' ri i Tat ri c'o chila' chicaj man craj taj chi cätzak jun chque we ch'utik ri' ri quecojon chwe. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","We ri awachalal cuban jun c'äx chawe, chattzijon ruc' pa u tuquiel wi, chabij che jas ru mac. We cucoj rib chupam, xatcowin ri' chuch'aquic ra wachalal. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","We c'u ri awachalal man cucoj tä rib pa ru mac aretak cattzijon ruc', chasiq'uij jun o quieb winak chic, rech ronojel ri quibij quetamax wa' cumal quieb u oxib tal tak tzij. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","We c'u man coc ri tzij pu jolom ri cäbix che cumal ri niq'uiaj chic, cheasiq'uij conojel ri niq'uiaj kachalal. We c'u man cuto jas ri cäquibij conojel ri kachalal, chabana che chi je' jas jun winak ri man cäcojon tä che ri Dios o jun tok'il alcabal. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Kas tzij quinbij chiwe chi jachique ri quik'alajisaj chi man utz tä u banic cumal ri winak cho ruwächulew, man utz tä u banic ri' chila' chicaj. Jachique c'u ri quik'alajisaj chi utz u banic cumal ri winak waral cho ruwächulew, utz u banic ri' chila' chicaj. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Xukuje' quinbij chiwe chi we c'o quieb chixol waral cho we uwächulew ri curik rib qui chomanic puwi' jun rajwaxic, cäca'n c'u orar chuta'ic wa', ri ka Tat ri c'o chila' chicaj cuya na wa' chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Je ri', rumal chi jawije' ri qui mulim wi quib quieb oxib winak rumal chi quecojon chwe, cuc' ri' in c'o wi, —xcha ri Jesús chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Xpe ri tat Pedro, xuta' c'u che ri Jesús: Kajaw, we ri wachalal q'uia mul cuban c'äx chwe, ¿janipa' mul rajwaxic quinsach u mac? ¿A craj ne wukub mul ri'? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Xch'aw c'u ri Jesús, xubij che: Man quinbij tä chawe chi xa wukub mul casach u mac, xane rajwaxic casach u mac wukub mul chic, wukub mul chic, c'ä copan na pa job ciento, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Je ri', rumal chi ru takanic ri Dios pa qui wi' ri winak, are je' jas jun k'inom achi ri xeumulij ri rajchaquib, xuchap c'u u ta'ic we c'o ri qui c'as, o we ne c'o u c'as ri are' cuc'. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Aretak tajin cuchaplej rajilaxic ri qui cuenta chquijujunal, xc'am lok jun ajchac ri u c'as q'uia mil quetzales. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Are c'u ri jun ajchac ri' man c'o tä cutojbej re ru c'as. Ri patrón xtakanic chi cäq'uiyix ri ajchac ri' pu k'ab jun winak chic rech cäpatänin che, rachi'l ri rixokil, ri ralc'ual, xukuje' conojel ri jastak re, rech cätojtaj ru c'as. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Are c'u ri ajchac xxuqui chuwäch ru patrón, xbochi'nic, xuta' tok'ob, xubij che: “Tat, chajij la paciencia wuc', quintoj na ronojel ri nu c'as,” —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ri patrón xutok'obisaj u wäch ri rajchac, xusach u mac, xubij che chi man cutoj tä chi ru c'as, xutzokopij c'u bic. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Te ri' ri ajchac ri xtzokopitaj bic, xurik jun rach ajchac ri u c'as quieb oxib quetzal ruc'. Xuchap ri rach ajchac chukul, xuchap u jitz'axic, xubij che: “¡Chatojo ra c'as wuc'!” —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ri rach ajchac xxuqui chuwäch, xbochi'nic, xuta' tok'ob che, xubij: “Chachajij paciencia wuc', quintoj na ronojel ri nu c'as,” —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ri are' c'ut man xusach tä u mac ri rach ajchac, xane xucoj pa che', xubij che chi rajwaxic cutoj na ru c'as. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Aretak xquil wa' ri niq'uiaj ajchaquib chic, sibalaj xebisonic. Xebe' c'ut, xequibij che ri qui patrón ronojel ri xbantajic. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Xpe c'u ri qui patrón, xtakan chusiq'uixic ri ajchac ri', xubij che: “¡Itzel ajchac! Ri in xincuy ra c'as rumal chi xata' tok'ob chwe. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ri at xukuje' rajwaxic xatok'obisaj ta u wäch ri awach ajchac, jas ri xinban in chawe xintok'obisaj a wäch,” —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","¡Ru patrón c'ut, sibalaj xpe royowal! Xtakanic chi cäc'äjisax u wäch ri rajchac c'ä cutoj na ru c'as. ");
INSERT INTO qucTNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ri Jesús xuq'uisbej re ru tzij, xubij: Jas ri xuban ri patrón che ri rajchac, are je' cuban na ri nu Tat ri c'o chila' chicaj chiwe, we man kas quisach qui mac ri iwachalal, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Aretak xto'taj ri Jesús chubixic ronojel wa' we tzij ri', xel bi pa Galilea, xe' pa tak ri tinimit re Judea, ch'äkäp che ri nima' Jordán. ");
INSERT INTO qucTNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","E q'uia winak xeteri bi chrij, xeucunaj c'u tak ri yawabib chila'. ");
INSERT INTO qucTNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Xeopan c'u jujun tata'ib fariseos ruc' ri Jesús, xquita' che: ¿A takal che jun achi cujach bi ri rixokil pune man kas c'o u mac? —xecha che. Xquibij wa' che xak rech cäkaj ri Jesús pa qui k'ab. ");
INSERT INTO qucTNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Xch'aw c'u ri Jesús, xubij chque: ¿A mat siq'uim alak pa ru Lok' Pixab ri Dios ri Tz'ibtalic jas ri xuban ri Dios pa ru chaplexic lok ronojel, “chi achi chi ixok xeubano”? —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Xukuje' cubij: “Rumal wa' jun achi cuya na can ru nan u tat, cätuni c'u na ruc' ri rixokil. Xa e jun chic ri quieb winak ri',” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Je c'u ri' man e quieb tä chic, xane xa e jun chic. Rumal c'u ri', jas ri xeutunuba ri Dios, mäjach qui wäch wa' cumal ri winak, —xcha ri Jesús chque ri tata'ib fariseos. ");
INSERT INTO qucTNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Xquibij c'u ri tata'ib fariseos: ¿Jas che ri ka mam Moisés xtakanic chi jun achi cuya' cutz'ibaj jun wuj ri cubij wi chi cujach bi ri rixokil? Je c'u ri' cuya' cujach bi ri rixokil, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ri Jesús xubij chque: Xa rumal chi sibalaj abajarinak ri anima' alak, are rumal ri' xuya chech alak chi cuya' cäjach bi alak ri ixokil alak. Man je' tä c'u wa' aretak xchapletaj lok ronojel. ");
INSERT INTO qucTNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ri in c'ut quinbij chech alak chi apachin ri cujach bi ri rixokil, we man rumal ru ch'abexic jun achi chic, cäc'uli chi c'u na ruc' jun ixok chic, ri achi ri' cuban ri nimalaj mac ri äwas u banic chrij ri nabe rixokil. Ri achi c'ut ri cäc'uli ruc' jun ixok ri jachom canok cuban ri nimalaj mac ri', —xcha ri Jesús chque ri tata'ib fariseos. ");
INSERT INTO qucTNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Xquibij c'u ru tijoxelab ri Jesús che ri Are': We jun achi man cuya' taj cujach bi ri rixokil, are utz na ri' chi man cäc'uli taj, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ri Jesús xubij chque: Man conojel tä winak cäquich'ij wa' chi man quec'uli taj, xane xak xuwi ri yo'm chque rumal ri Dios chi cäquich'ijo. ");
INSERT INTO qucTNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","C'o c'u jas che jujun achijab man quec'uli taj. E c'o jujun xa tzquech wi man quec'uli taj, e c'o niq'uiaj chic ri xa banom chque cumal ri achijab chi man quec'uli taj, e c'o c'u niq'uiaj chic cäquich'ijo man quec'uli taj xa rumal chi cäcaj cäquipatänij ri Dios. Jachin ri cäcowinic je' cuban wa', chubana', —xcha ri Jesús chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ri winak xequic'am lok ri ac'alab cho ri Jesús rech cuya ru k'ab pa qui wi', rech xukuje' cuban orar pa qui wi'. Ri winak ri xequic'am lok ri ac'alab xeyaj cumal ri tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ri Jesús c'ut xubij chque: Chiya chque ri ac'alab chi quepe wuc', meik'atej rumal chi ri winak ri cätakan ri Dios pa qui wi' e are' winak ri e je' jas we ac'alab ri', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Xuya c'u ru k'ab pa qui wi' ri ac'alab, te c'u ri' xel bi chila'. ");
INSERT INTO qucTNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Jun ac'al achi xopan ruc' ri Jesús, xuta' che: Utzalaj Ajtij, ¿jas u wäch utzil rajwaxic quinbano rech quinrik ri c'aslemal ri man c'o tä u q'uisic? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ri Jesús xubij che: ¿Jas che cabij chwe chi utz ri in? Man c'o tä jun kas utz, xane xak xuwi ri Dios, —xcha che. We c'u cawaj carik ri c'aslemal ri man c'o tä u q'uisic, chanimaj ru takanic ri Dios, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ri achi xubij che: ¿Jachique tak ri' ru takanic ri Dios ri rajwaxic quinniman chque? —xcha che. Ri Jesús xubij che: Matcämisanic, maban ri nimalaj mac ri äwas u banic ruc' ri rixokil jun winak chic, maban ri elak', maban tzij chrij jun winak chic. ");
INSERT INTO qucTNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Nim cheawila wi ra nan a tat. Lok' cheawila wi ri awach winak jas ri at lok' cawil awib, —xcha ri Jesús che ri achi. ");
INSERT INTO qucTNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ri achi xubij che ri Jesús: Ronojel wa' nu takem u banic tzaretak in ac'al na. ¿Jas ta chi c'u ri rajwaxic quinbano? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ri Jesús xubij che: We cawaj cäjicomataj ra c'aslemal cho ri Dios, jat, cheaq'uiyij conojel ri jastak awe, chaya ri rajil chque ri meba'ib. Cäc'oji c'u na ra k'inomal chila' chicaj. Te ri' tasa'j wuc', —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Aretak ri achi xuta ri xubij ri Jesús, xq'uextaj ru wäch, xbisonic, xe'c rumal chi q'uia ru k'inomal c'olic. ");
INSERT INTO qucTNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Xubij c'u ri Jesús chque ru tijoxelab: Kas tzij quinbij chiwe, chi sibalaj c'äx cutij jun k'inom coc chquixol ri winak ri cätakan ri Dios pa qui wi'. ");
INSERT INTO qucTNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Are man c'äx tä ri roc'owisaxic jun awaj camello pa ru julil jun t'isombal bak, chuwäch ri roquic jun k'inom chquixol ri winak ri cätakan ri Dios pa qui wi', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ri tijoxelab aretak xquita wa', sibalaj xquicajmaj, xquibij c'u chbil tak quib: ¿Jachin ta c'u lo ri cäcowinic curik ru tobanic ri Dios? —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ri Jesús co xca'y chque, te ri' xubij: Man quecowin tä ri winak chubanic wa', cäcowin c'u na ri Dios che ronojel, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ri tat Pedro xubij che ri Jesús: Kajaw, chilampe la chi ri uj ka yo'm can conojel ri jastak ke, uj c'o uc' la. ¿Jas c'u ri cäyi' na chke? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Xch'aw c'u ri Jesús, xubij chque: Kas tzij quinbij chiwe, copan na jun k'ij aretak cäban c'ac' che ronojel. Aretak ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak, quincu'bi na pa ri je'lalaj nu t'uyulibal, cänimarisax nu k'ij, are chi' c'ut chi ri ix, ri ix ri c'o wuc' quixcu'bi na xukuje' pa cablajuj je'lalaj tak t'uyulibal. Quik'at c'u na tzij pa qui wi' ri cablajuj tinimit re Israel. ");
INSERT INTO qucTNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Conojel ri qui yo'm can cachoch, cachalal, qui nan qui tat, quixokil, calc'ual, culew rumal wech in, cäquirik na jun ciento mul ri tojbal que, xukuje' cäquirik na ri c'aslemal ri man c'o ta u q'uisic pa tak ri k'ij ri junab ri quepe na, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","E q'uia c'u ri winak ri nim que'il wi cämic ri man nim tä chi na que'il wi pa tak ri k'ij ri'. Xukuje' e q'uia ri man nim tä que'il wi cämic ri nim que'il wi na pa ri k'ij ri', —xcha chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ru takanic ri Dios pa qui wi' ri winak, are je' jas jun achi ajchak'el jun nimalaj ulew. Xel bi sibalaj ak'ab che qui tzucuxic ajchaquib che qui mulixic ru wäch tak uvas. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Xeurik c'u jujun achijab, xuchomaj c'u cuc' chi cäquich'ac cacab quetzal che ri jun k'ij, xeutak c'u bi pa ri rulew che ri chac. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Xel chi c'u bi jumul pa ri u belej hora re ri ak'abil. Xeril niq'uiaj achijab chic ri xak tajin quekasan k'ij pa ri c'ayibal. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Xubij c'u chque: “Jix pa ri nu chac, quinya c'u na ri tojbal iwe ri takal chiwe,” —xcha chque. Ri e are' c'ut xebe' pa ri chac. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ri patrón xel chi bi jumul pa ri niq'uiaj k'ij che qui tzucuxic ajchaquib, xukuje' pa ri urox hora re ri benak k'ij, junam xuban cuc' niq'uiaj ajchaquib chic. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Pa ri uro' hora chic re ri benak k'ij, xel chi bi jumul pa ri c'ayibal. Xeurika chi niq'uiaj achijab ri xak tajin quekasan k'ij, xubij c'u chque: “¿Jas che xak ix c'o waral juntir ri jun k'ij man c'o tä c'u chac quibano?” —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ri e are' xquibij: “Xa man c'o tä jun ri cäbin chac chke,” —xecha che. Xubij c'u chque: “Jix pa chac wuc' in pa ri wulew, quinya c'u na ri tojbal iwe ri takal chiwe,” —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Aretak c'ut xoc ri ak'ab, ri patrón xubij che ri chajil que ri ajchaquib: “Cheasiq'uij ri ajchaquib, chaya bi ri tojbal que. Are cachap qui tojic nabe ri xeboc q'uisbal. Are c'u ri xeboc nabe queatoj wa' q'uisbal,” —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Xepe c'u ri ajchaquib ri te' xeboc pa chac pa ri uro' hora re ri benak k'ij. Chquijujunal tz'akat cacab quetzal xyi' chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Te c'u ri', aretak hora chic chi quetoj ri oquinak nabe pa ri chac, ri e are' xquichomaj chi más na ri tojbal que cäyi' chquiwäch ri c'ä te' xeboc pa ri chac. Xukuje' c'u ri e are' xyi' cacab quetzal chque chquijujunal. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Aretak xquic'amo xquichap u yajic ri qui patrón. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Xquibij: “We ajchaquib ri' ri te' xebul q'uisbal, xa jun hora xechacunic. Xak junam c'u qui tojic xban la jas ri uj. Ri uj c'ut xkach'ij ronojel ri jun k'ij chac, xujchacun chuwäch ru chuk'ab ri k'ij,” —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ri patrón xubij che jun chque ri ajchaquib: “E ri at, man c'o tä jas ri tajin quinban chawe ri mat jicom. ¿A mat junam xkachomaj chi xak quieb quetzal ri tojbal awe? ");
INSERT INTO qucTNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","C'ama bi ri tojbal awe, jat. Ri in cwaj quinya ri tojbal que we niq'uiaj ri' ri te' xeboc q'uisbal junam jas ri xinya chawe at. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿A mat pa nu k'ab c'o wi jachique ri cwaj quinban ruc' ri nu rajil? ¿A xa c'äx ne cana' chi in utz cuc' conojel?” —xcha ri patrón che ri ajchac. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Je c'u ri' ri winak ri man nim tä que'il wi cämic nim que'il wi na. Are c'u ri winak ri nim que'il wi cämic, man nim tä chi que'il wi na. E q'uia ri e siq'uim. Man e q'uia tä c'ut ri e cha'talic, —xcha chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Pakalem re ri Jesús pa Jerusalén, xeusiq'uij c'u ri cablajuj u tijoxelab pa qui tuquiel wi, xubij chque: ");
INSERT INTO qucTNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","¡Chiwilampe'! Benam ke, tajin cujpaki pa ri tinimit Jerusalén. Quinjach c'u na in, in ri' ri Ralc'ual ri Dios ri Kas Winak, pa qui k'ab ri qui nimakil ri sacerdotes, xukuje' pa qui k'ab ri tijonelab re ri Pixab. Cäquik'at c'u na tzij pa nu wi' chi quincämisax na. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Quinquijach c'u na pa qui k'ab ri niq'uiaj winak chic, cäquetz'bej na nu wäch, quinquich'ay na, quinquirip c'u na cho ri cruz. Quinc'astaj c'u na chquixol ri cäminakib churox k'ij, —xcha ri Jesús chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Te c'u ri' xekeb ru c'ojol ri tat Zebedeo ruc' ri Jesús. E are' ri tat Jacobo, ri tat Juan, cachi'l ri qui nan. Ri qui nan xxuqui chuwäch ri Jesús chuta'ic jun tok'ob che. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ri Jesús xuta' che: ¿Jas caj la, nan? —xcha che. Ri chichu' xubij: Aretak cächaplej takanic la pa qui wi' ri winak, cwaj chi cäya la chque ri quieb wal chi quecu'bi uc' la, ri jun pa wiquiäk'ab la, ri jun chic pa ri moxk'ab la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Xubij c'u ri Jesús chque: Ri ix man quich'ob taj jas u wäch tok'ob ri tajin quita' chwe. ¿A quixcowinic quich'ij ri c'äx ri quinrik na in, quitij iwe ri c'o pa ri vaso ri quintij wi na we? ¿A quixcowinic cäban na i kasna' ix jas ri kasna' ri cäban na chwe in? —xcha chque. Xquibij c'u che: Cujcowinic, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Xubij ri Jesús chque: Kas tzij quirik na c'äx, quitij c'u na iwe ri c'o pa ri vaso ri quintij na we in, xukuje' cäban na i kasna' jas ri cäban na chwe in. Are c'u ri t'uyulem pa ri nu wiquiäk'ab o pa ri nu moxk'ab, man cuya' taj quinya in chiwe, xane are wa' quech ri e cha'tal rumal ri nu Tat chi quet'uyi pa tak ri t'uyulibal ri', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Aretak ri lajuj tijoxelab chic xquita u bixic ronojel wa', xpe coyowal ri e are' chrij ri tat Jacobo, ri tat Juan. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Xeusiq'uij c'u ri Jesús, xubij chque: Ri ix iwetam chi ri winak ri yo'm chque chi quetakan pa qui wi' ri niq'uiaj winak chic, cäquina' chi kas c'o qui chuk'ab pa qui wi'. Ri qui nimakil ri winak c'ut quetakan pa qui wi', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Man je' tä c'u wa' ri ix. Xane apachin chiwe ri craj chi nim quil wi, rajwaxic chi coc na che patänil que conojel. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Apachin chiwe ri craj coc che i nimal, rajwaxic chi coc na che patänil que ri niq'uiaj chic. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Are je ri', rumal chi ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak, man in petinak taj rech quinpatänixic, xane rech quinpatänin chque niq'uiaj chic, xukuje' rech quinya ri nu c'aslemal che tojbal re ri qui toric q'uia winak, —xcha ri Jesús chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Aretak ri Jesús tajin quel bi pa ri tinimit Jericó e rachi'l ru tijoxelab, e q'uia winak xeteri bi chrij. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","E c'o c'u quieb achijab moyab t'uyul chi' ri be. Xquito chi ri Jesús tajin coc'ow chila', xquirak qui chi', xquibij che ri Jesús: ¡Tat, lal ri' ralc'ual can ri ka mam David, tok'obisaj la ka wäch! —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ri winak xa xequiyajo, xquibij chque chi chquitz'apij u pa qui chi'. Are c'u ri e are' man xquita taj, xane sibalaj co chi na xquirak qui chi', xquibij: ¡Tat, lal ri' ralc'ual can ri ka mam David, tok'obisaj la ka wäch! —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Xtaq'ui c'u ri Jesús. Xeusiq'uij ri quieb moyab, xuta' chque: ¿Jas caj alak chi quinban chech alak? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ri moyab xquibij: Tat, cäkaj cujca'yic, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Te ri' ri Jesús xutok'obisaj qui wäch, xuchap c'u cok ri qui wak'äch. Chanim c'ut xecowinic xeca'yic, xebe' c'u ruc' ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Aretak nakaj chic e c'o wi che ri tinimit Jerusalén, xeopan pa ri alaj tinimit Betfagé. Tajin queoc'ow chuwäch ri Ujuyubal Olivos. Ri Jesús xeutak bi quieb chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Xubij bi chque: Jix pa ri alaj tinimit ri c'o apan chkawäch. Chila' quirik wi na jun ati't burro yukulic, rachi'l jun alaj burro. Chiquira', cheic'ama c'u lok chwe, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","We c'o jachin jun c'o jas cubij chiwe, chibij che chi xa cajwataj che ri Kajaw Jesús, chanim c'ut cutzelej chi na lok, —quixcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Je' xbantaj wa' rech kas je' quelic jas ri xutz'ibaj can ri k'alajisal re ru Lok' Pixab ri Dios ri cubij: ");
INSERT INTO qucTNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Chibij chque ri winak re ri tinimit Jerusalén ri c'o puwi' ri juyub Sión: “¡Chiwilampe'! Ri Nimalaj i Takanel petem re iwuc'. Man nim tä u banic u banom che rib, xane quiejeninak chrij jun burro. Chrij ri alaj ral jun burro quiejeninak wi,” —cächa ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Xebe' c'u ri quieb tijoxelab, je' xca'no jas ri xetak wi bi rumal ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Xquic'am lok ri ati't burro rachi'l ri ral. Xquiya c'u ri qui k'u' chrij, xquiejen c'u ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","E q'uia c'u ri winak xquilic' ri qui k'u' pa ri be, xukuje' e c'o niq'uiaj chic ri xequiya u xak tak che' pa ri be ri xequich'upala pa tak ri juyub. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ri winak ri e nabejinak chuwäch ri Jesús, xukuje' ri e teretoj chrij, co xech'awic, xquibij: ¡Chnimarisax u k'ij ri ralc'ualaxic ri ka mam David ri nim takanel! ¡Utz re ri petinak pa ru bi' ri Kajaw Dios! ¡Chnimarisax u k'ij ri Dios! —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Aretak xoc ri Jesús pa ri tinimit Jerusalén, conojel ri winak xquituquij quib, xquitatabala chbil tak quib, xquibij: ¿Jachin wa' we achi ri'? —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ri winak xquibij: Are wa' ri Jesús, ri k'alajisal re ru Lok' Pixab ri Dios, ri aj Nazaret re Galilea, —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Te c'u ri' xoc bi ri Jesús pa ri nimalaj rachoch Dios, xeresax bi ri ajc'ayib xukuje' ri quequilok' tak jastak pa ri nimalaj rachoch Dios. Xeutzak ri qui mesa ri q'uexal tak puak xukuje' xeutzak ri qui tem ri ajc'ay tak palomäx. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Xubij chque ri winak: Tz'ibtal pa ru Lok' Pixab ri Dios, cubij: “Ri wachoch in are jun ja ri cäban wi orar,” —cächa'. Ri alak c'ut jun cachoch elak'omab banom alak che, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Chila' pa ri nimalaj rachoch Dios, xeopan jujun achijab moyab ruc' ri Jesús, xukuje' jujun ch'ocojib. Xecunax c'u rumal ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Aretak c'ut ri qui nimakil ri sacerdotes xukuje' ri tijonelab re ri Pixab, xquil tak ri cajmabal ri xuban ri Jesús, xukuje' xquito chi ri ac'alab cäquirak qui chi' pa ri nimalaj rachoch Dios, cäquibij: “¡Nim u k'ij ri ralc'ual can ri nim takanel David ojer!” —quecha'. Ri e are' xpe coyowal. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Xquibij c'u che ri Jesús: ¿A cäta la jas ri tajin cäquibij ri ac'alab? —xecha che. Ri Jesús xch'awic, xubij chque: Je', quinto, —xcha chque. ¿A mat siq'uim pu alak ri tz'ibtal pa ru Lok' Pixab ri Dios? Je wa' cubij: Xya la chque ri ac'alab, chque ri alaj tak ac'alab ri quetu'nic chi kas tzij cäquibixoj bix ri cuya u k'ij ri Dios, —cächa', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Xe' c'u ri Jesús, xeuya can ri qui nimakil sacerdotes xukuje' ri tijonelab re ri Pixab. Xel bi pa ri tinimit Jerusalén, xe' pa ri tinimit Betania. Chila' c'ut xcanaj can che ri chak'ab. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ak'abil aretak tajin quetzelej bi pa Jerusalén, e petinak pa ri tinimit Betania, xnum c'u ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Xril apan jun u che'al higos ri c'o chuchi' ri be. Xerila', man c'o tä c'u u wäch xuriko, xane xak xuwi u xak. Xubij c'u ri Jesús che ri che': ¡Man c'o tä chi jumul chic cäc'oji a wäch! —xcha che. Chanim c'ut xchaki'jar ru che'al higos. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ru tijoxelab ri Jesús aretak xquil wa' sibalaj xquicajmaj. Xquita' c'u che ri Jesús: ¿Jas che chanim xchaki'jar ru che'al higos? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ri Jesús xch'awic, xubij chque: Kas tzij quinbij chiwe, we kas quixcojonic, man cuban tä c'u quieb i c'ux, man xuwi tä wa' quixcowin chubanic jas ri xinban in che ru che'al higos. Xane cuya' quibij che we juyub ri': “Chatel bi waral, chaq'uiäka bi awib pa ri mar,” —quixcha che. Cäbantaj c'u na wa', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ronojel c'u ri quita' che ri Dios cäya'taj na chiwe we kas quixcojonic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ri Jesús xoc pa ri nimalaj rachoch Dios. Aretak tajin queutijoj ri winak chila', ri qui nimakil sacerdotes, xukuje' ri qui nimakil ri winak aj Israel xeopan ruc', xquita' che: ¿Jachin xtakow la chi cäban la ronojel wa' we ri'? ¿Jachin lo ri yo'winak che la chi je' cäban la wa'? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ri Jesús xch'awic, xubij chque: Ri in xukuje' c'o ri quinta' chech alak. We cäcowin alak chubixic chwe jas ri quinta', quinbij na chech alak jachin ri yo'winak chwe chi c'o nu takanic rech je' quinban wa', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Bij alak chwe: ¿Jachin xtakow ri tat Juan chubanic ri kasna'? ¿A are ri Dios o e are ri winak? —xcha chque. Xquichaplej c'u u tzijobexic quib, xquibij: We cäkabij chi are ri Dios xtakowic, cubij na chke: “¿Jas c'u che man xcojon tä alak che?” —cächa na. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","We cäkabij chi e are ri winak xtakowic, cäkaxej kib chquiwäch ri winak. Conojel c'u ri winak cäquicojo chi ri tat Juan are jun k'alajisal re ru Lok' Pixab ri Dios, —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Rumal wa' xquibij che ri Jesús: Man ketam taj, —xecha che. Ri Jesús xch'awic, xubij chque: Man quinbij tä c'u in chiwe jachin yo'winak chwe chi quinban wa' we ri', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ri Jesús xubij chque ri tata'ib fariseos: ¿Jas cächomaj alak che wa' ri quinbij chech alak ri'? C'o jun achi ri e c'o quieb u c'ojol. Xubij c'u che jun chque ru c'ojol: “Nu c'ojol, jat cämic pa ri nu chac che qui mulixic ru wäch tak ri uvas,” —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ri ala xubij che ru tat: “¡Man c'o tä quine' wi in!” —xcha che. Te c'u ri' xuq'uex ru chomanic, xe' na che ri chac. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ri tata' xe' chi ruc' ri jun u c'ojol chic, xubij che: “Jat cämic pa ri nu chac che qui mulixic ru wäch tak ri uvas,” —xcha che. Ru c'ojol xubij che: “Je', tat, utz ri' quine'c,” —xcha che. Man xe' tä c'ut. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Jachin c'u chque we quieb ri' xubano jas ri xraj ru tat chi cäbanic? —xcha ri Jesús chque ri tata'ib fariseos. Ri e are' xquibij: Are ri xtak nabe, —xecha che ri Jesús. Xubij ri Jesús chque: Kas tzij ri quinbij chech alak chi ri tok'il tak alcabal, xukuje' ri itzel tak ixokib nabe queboc na chuwäch alak chquixol ri winak ri cätakan ri Dios pa qui wi', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Je ri', rumal chi ri Juan Kasal Ja' xpetic, xuc'ut chuwäch alak jas cäban alak rech jicom ri c'aslemal alak cho ri Dios, man xcoj tä c'u alak ru tzij. Are c'u ri tok'il tak alcabal, xukuje' ri itzel tak ixokib xquicojo. Are c'u ri alak, pune xil alak wa' ri xca'n ri e are', man xq'uex tä ri anima' alak, man xq'uex tä c'u ri chomanic alak. Man xcoj tä alak ri xubij ri tat Juan Kasal Ja' chech alak, —xcha ri Jesús chque ri tata'ib fariseos. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Tatabej ba' alak we jun c'utbal chic ri', —xcha chque. C'o jun achi ri xuban jun ticbal uvas, xucoralij rij, te c'u ri' xuc'ot jun jul ri cäpitz' wi ri uvas, xuban xukuje' jun tac'aticalaj ja ri cäcoj che chajibal re ronojel. Xuya c'u can pa kajomal chque jujun achijab, te ri' xe' ri are' naj pa jun tinimit chic. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Xopan c'u ri k'ij ri xechäk'aj ri qui wäch ri uvas, ri ajchak'el xeutak bi jujun patänil tak re cuc' ri ajchaquib chuc'amic re ri qui wäch ri uvas. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Are c'u ri ajchaquib xequichap ri patäninelab, jun xquich'ayo, jun xquicämisaj, jun chic c'ut xca'n chabaj. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ri ajchak'el ri ulew xeutak chi bi niq'uiaj tako'n chic. E q'uia chi na ri xeutak bic chuwäch ri nabe. Ri ajchaquib c'ut je' xca'n chque jas ri xca'n chque ri nabe tak tako'n. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Chuq'uisbal ronojel xutak bi ri u c'ojol, xuchomaj c'ut: “Kas nim cäquil wi na ri nu c'ojol,” —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Aretak c'ut ri ajchaquib xquil ru c'ojol ri tata', xquitzijobela quib, xquibij: “Are wa' ri quechben na ronojel. Jo', kacämisaj rech cäk'ax can ronojel ri ulew pa ka k'ab uj,” —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Xquichapo, xquesaj bi pa ri ticbal uvas, xquicämisaj. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Te c'u ri' ri Jesús xuta' chque, xubij: Aretak cäpe ri ajchak'el ri ulew ticbal uvas, ¿jas cuban na chque ri ajchaquib? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ri e are' xquibij che ri Jesús: Man cutok'obisaj tä na qui wäch, queucämisaj na ri itzel tak ajchaquib ri', cuya c'u na ri ticbal uvas chque niq'uiaj chic, ri cäquijach ru wäch ri tico'n aretak curik ri k'ij, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Xubij c'u ri Jesús chque: ¿A mat siq'uim alak wa' we tzij ri' pa ru Lok' Pixab ri Dios? Je wa' cubij: Ri abaj ri man xcaj tä ri yacal tak ja, are abaj wa' xcoj che tok'ebal re ri ja. Je' banom wa' rumal ri Kajaw Dios. Kas cajmabal c'u wa' chkawäch, —cächa', —xcha ri Jesús chque ri tata'ib fariseos. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Rumal ri' quinbij chech alak chi ri Dios man cätakan tä chi na puwi' alak, xane ri Dios are cätakan na pa qui wi' ri winak ri utz cäca'n che ri qui chac, ri cäquijach cuenta cho ri Dios aretak curik ri k'ij. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Are c'u we c'o jun cätzak puwi' ri abaj, cäk'aj na. We c'u ne are ri abaj cätzak puwi' jun winak, cäc'äjisax na rumal ri abaj, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Aretak ri qui nimakil ri sacerdotes xukuje' ri tata'ib fariseos xquita wa', xquich'obo chi chquij ri e are' xutzijoj wi wa' we c'utbal ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Xcaj xquichap ri Jesús. Xquixej c'u quib chquiwäch ri winak, rumal chi ri winak xquicojo chi ri Jesús are jun k'alajisal re ru Lok' Pixab ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jumul chic ri Jesús xuchaplej qui tzijobexic ri winak cuc' tak c'utbal, xubij chque: ");
INSERT INTO qucTNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Ru takanic ri Dios pa qui wi' ri winak, junam ruc' jun nim takanel ri xuban jun nimak'ij che ru c'ulanem ru c'ojol. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Xeutak bi ri patänil tak re che qui siq'uixic lok ri winak ri e siq'uim pa ri c'ulanem, man xcaj tä c'u ri winak xepetic. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ri tata' xeutak chi bi niq'uiaj chic patänil tak re, xubij bi chque: “Chibij chque ri winak ri e siq'uim chi xutzir ri wa. Xintakan che qui cämisaxic ri nu wacäx, ri awaj ri e nu k'obsam xepilitajic. Ronojel ri ulabal c'o chic, sa'j alak pa ri c'ulanem,” —quixcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Are c'u ri winak ri xesiq'uix che ri c'ulanem man xeboc tä il che ri xubij ri nim takanel. Xak xquitzucuj jas xca'no. Jun xe' chusolixic ri rulew, jun chic xe' che c'ayinic. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ri niq'uiaj chic xequichap ri u tako'n ri nim takanel, xca'n c'äx chque, xequicämisaj. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ri nim takanel sibalaj xpe royowal, xeutak c'u bi ru soldados che qui cämisaxic ri winak ri xecämisan ru tako'n. Xtakan che ru poroxic ri qui tinimit. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Xubij c'u chque ri patänil tak re: “Ronojel ri cajwataj che ri c'ulanem c'o chic, are c'u ri winak ri xekasiq'uij che ri c'ulanem man takal tä chque chi quepetic. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Rumal ri' jix pa tak ri nim be, cheisiq'uij lok conojel ri winak ri queiriko rech quepe pa ri c'ulanem,” —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ru tako'n xebel bi che qui tzucuxic ri winak pa tak ri be. Xequimulij c'u lok conojel ri xequiriko, ri e utz xukuje' ri man e utz taj. Xnoj c'u ri ja cumal ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Xoc bi ri tata' che quilic conojel ri xesiq'uix pa ri c'ulanem. Xril c'u jun achi chquixol ri winak ri man u cojom tä atz'iak re c'ulanem. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Xubij che: E c'u ri at, “¿Jas che xatoc lok waral we man c'o tä awatz'iak re c'ulanem?” —xcha che. Ri achi man c'o tä jas xubij. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ri nim takanel xubij chque ri que'ilow ri mesa: “Chiyutu ri rakan u k'ab. Jiq'uiäka can chrij ja pa ri k'ekum. Chila' c'ut cok' wi na, cukuch'uch'ej na ru ware,” —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","E q'uia c'u ri e siq'uim, xak c'u e quieb oxib ri e cha'talic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Xebe' c'u ri tata'ib fariseos, xquitala qui no'j, xjunamataj c'u qui chomanic rech cäquic'ot u chi' ri Jesús xak rech cuya' cäquibij chi c'o u mac. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Rumal ri' xequitak bi jujun chque ri cachi'l junam cuc' niq'uiaj chic ri e rachi'l ri tat Herodes chubixic che ri Jesús: Ajtij, ketam chi jicom ri anima' la, xukuje' chi cäc'ut la ru beyal ru rayibal ri Dios chquiwäch conojel ri winak. Man cäxej tä ib la chquiwäch ri winak, pune c'o jas cäquichomaj chij la, rumal chi man nim tä quil la jun winak chuwäch ri jun chic. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Bij ba' la chke jas ri cächomaj la: ¿A takal chke cäkatoj alcabal che ri César o man takal taj? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ri Jesús xretamaj c'ut ri itzel tak qui chomanic, xubij chque: Xak quieb wäch alak, ¿jas che cäta' alak wa' chwe? ¿A mat xa caj alak chi quinkaj pa k'ab alak? ");
INSERT INTO qucTNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","C'amampe alak lok jun puak chnuwäch ri cätojbex re ri alcabal, —xcha chque. Xquic'am c'u lok ri jun puak. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Aretak ri Jesús xrilo, xubij chque: ¿Jachin ajchak'el we cayebal ri', xukuje' we bi'aj ri' ri tz'ibtal chuwäch? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ri e are' xech'awic, xquibij: Are rech ri César, —xecha che. Xubij c'u ri Jesús chque: Ya ba' alak che ri César ri rech ri César. Ya c'u alak che ri Dios ri rech ri Dios, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Aretak ri tata'ib fariseos xquita ri xubij ri Jesús chque, sibalaj xquicajmaj u wäch. Xquiya c'u canok, xebe'c. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Pa ri k'ij ri' xeopan jujun tata'ib saduceos ruc' ri Jesús. Ri tata'ib ri' cäquibij chi man quec'astaj tä chi na ri cäminakib. Xquita' c'u che ri Jesús, xquibij: ");
INSERT INTO qucTNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ajtij, bim can chke rumal ri ka mam Moisés chi we cäcäm jun achi, cäcanaj can ri rixokil pa malca'nil, man c'o tä c'u can ralc'ual ruc', rajwaxic chi ri rachalal chak'axel ri c'o canok cäc'uli ruc' ri ixok ri malca'n rech quec'oji ralc'ual ruc'. Ri ac'alab ri' e je' ta ne rech ri cäminak. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Chkaxol uj je' xc'ulmataj wa': Xec'oji wukub achijab cachalal quib. Ri nabeal xc'uli'c, xcäm c'ut. Man c'o tä ralc'ual xc'oji can ruc' ri rixokil, xa je ri' xcanaj can ri malca'n ixok che rixokil ri chak'axel rachalal. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Je' xc'ulmataj xukuje' ruc' ri ucab, ri urox rachalal, c'ä xeq'uis na ri wukub achalaxic. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","E cäminak chic conojel, xcäm c'u bi ri ixok. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Aretak c'ut quec'astaj na ri cäminakib, ¿jachin chque wa' we wukub achijab ri' cäc'amow ri ixok che rixokil? Xc'oji c'u che quixokil ri wukub, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ri Jesús xch'awic, xubij chque: Ri alak xa sachinak alak rumal chi man etam tä alak ru Lok' Pixab ri Dios ri Tz'ibtalic, man etam tä c'u alak ru chuk'ab ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Aretak ri cäminakib quec'astajic, man quec'uli tä chic, man cäquiya tä c'u ri calc'ual che c'ulanem, xane xak e junam chic cuc' ri ángeles rech ri Dios ri e c'o chila' chicaj, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Chrij c'u wa' chi quec'astaj na ri cäminakib, c'o na ri cwaj quinbij chech alak: ¿A mat siq'uim alak ri cubij wi ri Dios? Je wa' cubij: ");
INSERT INTO qucTNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“In ri', in ru Dios ri Abraham, ru Dios ri Isaac, ru Dios ri Jacob,” —cächa'. Ri ka Dios man are tä Dios quech ri cäminakib, xane quech ri e c'asc'oj, —xcha ri Jesús chque ri tata'ib saduceos. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Aretak xquita ri winak wa' ri xubij ri Jesús, conojel sibalaj xquicajmaj ru tijonic. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Aretak ri tata'ib fariseos xquito chi ri saduceos xtz'apix u pa qui chi' rumal ri Jesús, ri e are' xquimulij quib. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Jun c'u chque ri fariseos are tijonel re ri Pixab. Xopan c'u ruc' ri Jesús rech cuc'am u pu chi', xubij che: ");
INSERT INTO qucTNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ajtij, ¿jachique ri takanic ri nim na u banic ri c'o pa ri Pixab? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ri Jesús xubij che: “Sibalaj chiwaj ri i Dios, ri Iwajaw, chijiquiba ri i c'ux, chijiquiba ri iwanima' chrij, chicojo ri i chomanic chubanic wa',” —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Are wa' ri takanic ri nim na u banic, ri nabe chquiwäch conojel. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ri ucab takanic ri nim na u banic ri junam ruc' ri nabe are wa': “Cheiwaj ri i wach winak, jas ri ix quiwaj iwib,” —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","We quieb takanic ri' e are wa' ri kas u c'ux ronojel ri Pixab ri xutz'ibaj ri ka mam Moisés, xukuje' e are wa' u c'ux ri qui tijonic ri k'alajisal tak re ru Lok' Pixab ri Dios, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","C'ä qui mulim quib ri tata'ib fariseos. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Ri Jesús xuta' chque: ¿Jas cächomaj alak chrij ri Cristo? ¿Ralc'ual jachinok? —xcha chque. Ri e are' xquibij: Ri Cristo are ralc'ual can ri ka mam David ojer, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ri Jesús xubij chque: ¿Jas c'u che ri ka mam David ojer rumal ri Lok'alaj Espíritu xubij Kajaw che ri Cristo? Xubij c'ut: ");
INSERT INTO qucTNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Xubij ri Kajaw ri ka Dios che ri Wajaw: “Chatt'uyul pa ri nu wiquiäk'ab, c'ä quinya na chawe chi catch'acanic, cattakan c'u pa qui wi' conojel ri cäca'n qui c'ulel chawe,” —xcha ri ka mam David. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Jas ta ne che ri Cristo are ralc'ual can ri David we ri ka mam David xubij Kajaw che ri Cristo? —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Man c'o tä chi c'u jachin jun xcowinic xch'awic, xubij ta chi jun tzij che ri Jesús. Pa tak c'u ri k'ij ri' xetani'c, man c'o tä chi jachin jun c'o jas xuta' che ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ri Jesús xubij chque ri winak xukuje' chque ru tijoxelab: ");
INSERT INTO qucTNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ri tijonelab re ri Pixab, xukuje' ri tata'ib fariseos c'o takanic pa qui k'ab chuk'alajisaxic ri Pixab ri xutz'ibaj ri ka mam Moisés. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Cheinimaj ba', chibana c'u ronojel ri cäquibij chiwe. Xuwi c'u miban iwe jas ri cäca'n ri e are', rumal chi jun wi ri cäquibij, jun chi c'u wi ri cäca'no. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ri takanic ri cäquiya are je' jas jun eka'n ri sibalaj al, ri man c'o tä jun cuch'ij ri ra'lal. Cäcaj c'ut chi cäquinimaj ri winak. Ri e are' c'ut man c'o tä jubik' cäca'n che qui to'ic. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ronojel ri cäca'no xak rech quilitaj cumal ri winak. Cäkaj chquiwäch cäquinac' paj tak tzij re ru Lok' Pixab ri Dios cho ru crucil ri qui palaj xukuje' che ri qui k'ab ri tz'ibtal cho rabara'k tak wuj. Xukuje' cäkaj chquiwäch cäquicoj charcha'k tak atz'iak ri c'o retz'balil nimak na chuwäch ri que ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Are cäquitzucuj ri t'uyulibal ri nim que'il wi na pa tak ri ula'nem, xukuje' ri t'uyulibal ri nimak qui banic pa tak ri rachoch Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Cäcaj chi sibalaj utz qui ch'abexic cäban cumal ri winak pa tak ri be, xukuje' chi cäbix ajtij chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Are c'u ri ix mibano chi ri winak cäquibij ajtij chiwe. Iwonojel ri ix, iwachalal iwib, xa c'u jun ri Iwajtij c'olic, are ri Cristo. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Miban i tat che jun winak cho ruwächulew, xa c'u jun ri i Tat, are ri c'o chila' chicaj. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Miban che iwib chquiwäch ri winak chi ix c'amal tak qui be, xuwi c'u ri Cristo are C'amal i Be. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Jachin ri queupatänij conojel, are wa' ri nim na u banic chixol. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Jachin ri nim cuban che rib man nim tä quil wi na. Jachin c'u ri man nim tä cuban che rib are ri' nim quil wi na. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","¡C'äx ech alak, tijonelab re ri Pixab xukuje' ri alak tata'ib fariseos! ¡Xak quieb wäch alak! Quek'atej alak ri winak rech man queboc tä chquixol ri winak ri cätakan ri Dios pa qui wi'. Xak quek'atej alak ri cäcaj queboquic, man coc tä c'u alak xukuje'. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡C'äx ech alak, tijonelab re ri Pixab xukuje' ri alak tata'ib fariseos! ¡Xak quieb wäch alak! Cätokij alak ri cachoch ri malca'nib tak ixokib, te ri' cäyuk alak u tza'm ri tzij alak aretak cäban alak orar, rech man k'alaj tä ri etzelal ri cäban alak. Rumal ri' nim na ri c'äjisabal wäch alak aretak cäk'at na tzij pa qui wi' ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡C'äx ech alak, tijonelab re ri Pixab xukuje' ri alak tata'ib fariseos! ¡Xak quieb wäch alak! Ri alak cäwacat alak cho ronojel ruwächulew, cäk'ax alak ch'äkäp che tak ri mar chuch'aquic jun winak ruc' ri tijonic alak. Aretak c'ut cäcowin alak chuch'aquic, cäban alak che chi takalic que' pa ri k'ak' nabe chuwäch alak. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡C'äx ech alak, ri alak moyab c'amal tak be! Ri alak cäbij alak: “We jun winak cucoj ru bi' ri nimalaj rachoch Dios pa ru tzij aretak cuban juramento, man kas rajwaxic tä ri' cubano jas ri xuchi'j u banic. Are c'u we cucoj pa ru tzij ri k'än puak ri cojom che ri nimalaj rachoch Dios, rajwaxic wi ri' cubano jas ri xuchi'j,” —cächa alak. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Xak alak con, xak alak moyab! ¿Jachique nim na u banic: ri k'än puak o ri nimalaj rachoch Dios ri cuban nim u banic che ri k'än puak? ");
INSERT INTO qucTNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Xukuje' cäbij alak: “We jun winak cucoj ri ta'bal tok'ob pa ru tzij aretak cuban juramento, man kas rajwaxic tä ri' cubano jas ri xuchi'j u banic. We c'u are cucoj ri sipanic ri c'o puwi' ri ta'bal tok'ob pa ru tzij, rajwaxic ri' cubano jas ri xuchi'j,” —cächa alak. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Xak alak con, xak alak moyab! ¿Jachique ri nim na u banic: ri sipanic o ri ta'bal tok'ob ri cuban sibalaj lok' che ri sipanic? ");
INSERT INTO qucTNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Jachin ri cucoj ri ta'bal tok'ob pa ru tzij, man xuwi tä ri ta'bal tok'ob ri' cucoj pa ru tzij, xane ronojel ri c'o puwi' ri ta'bal tok'ob. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Jachin ri cucoj ri nimalaj rachoch Dios pa ru tzij man xuwi tä ri nimalaj rachoch Dios ri' cucoj pa ru tzij, xane xukuje' ri Dios ri c'o chila'. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Xukuje' jachin ri cucoj ri caj pa ri u tzij aretak cuban juramento, man xuwi tä cucoj ri je'lalaj u t'uyulibal ri Dios pa ru tzij, xane xukuje' ri Dios ri t'uyul puwi'. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡C'äx ech alak, tijonelab re ri Pixab xukuje' ri alak tata'ib fariseos! ¡Xak quieb wäch alak! Ri alak cäya alak che ri Dios ru lajujil ri k'ebun, ri anís, ri comino, yo'm c'u can alak u banic ri tijonic ri nim u banic ri c'o pa ri Pixab. Man cäban tä alak ri jicomal, man cätok'obisaj tä alak qui wäch niq'uiaj winak chic, man kas tä cäcojon alak che ri Dios. Are wa' ri rajwaxic cäban alak, man cäya tä c'u can alak u banic ri niq'uiaj chic. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Ri alak, xak alak moyab c'amal tak be! Cäban ech alak jas cuban jun achi, man craj taj cubik' bi jun amalo. Je' ta ne chi cäbik' bi alak jun awaj camello. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡C'äx ech alak, tijonelab re ri Pixab xukuje' ri alak tata'ib fariseos! ¡Xak quieb wäch alak! Utz cäban alak chquiwäch ri winak xak rech utz quil wi alak cumal. Kas tzij c'ut quelak'an alak, cärayij alak ri quech niq'uiaj winak chic. Je' ri banic alak jas ri lak ri xuwi ch'ajtal ri rij, are c'u ru pam tz'il na. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Alak moyab tak fariseos. Are rajwaxic nabe cäch'aj ru pam ri vaso xukuje' ri plato, te c'u ri' cäch'aj ri rij. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡C'äx ech alak, tijonelab re ri Pixab xukuje' ri alak tata'ib fariseos! ¡Xak quieb wäch alak! Junam alak cuc' ri mukubal que tak ri cäminakib ri tz'ajom ri rij che chun. Rumal ri' sibalaj je'l quelic. Are c'u ru pam nojinak che qui bakil tak cäminakib, xukuje' nojinak che ronojel chulaj tz'ilol. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Je ri' ri alak. Utz quel alak chquiwäch ri winak. Are c'u ri anima' alak sibalaj man utz taj, xak c'u quieb u wäch ri cäban alak. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡C'äx ech alak, tijonelab re ri Pixab xukuje' ri alak tata'ib fariseos! ¡Xak quieb wäch alak! Ri alak cäban alak qui banic ri mukubal quech ri k'alajisal tak re ru Lok' Pixab ri Dios ojer. Cäwik alak ri mukubal quech ri winak ri utz xca'no. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Cäbij c'u alak: “We ta xujc'oji can pa ri qui k'ijol ri ka nan ka tat ojer, mat xujtob ri' che qui cämisaxic ri k'alajisal tak re ru Lok' Pixab ri Dios ojer,” —cächa alak. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ruc' wa' we cäbij alak ri', cäk'alajisaj ib alak chi alak cachalaxic can ri winak ri xecämisan ri k'alajisal tak re ru Lok' Pixab ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Xak tajin cäq'uis alak u banic ri xquichaplej can u banic ri nan tat alak ojer! ");
INSERT INTO qucTNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Alak cumätz! ¡Itzel tak winak! ¡Alak cal tak cumätz! ¿Jachin ta lo ri cäto'w alak chuwäch ri c'äjisabal wächaj re ri k'ak'? ");
INSERT INTO qucTNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Rumal ri' queintak na lok k'alajisal tak re ru Lok' Pixab ri Dios uc' alak, queintak na lok achijab ri c'o qui no'j xukuje' tijonelab. Are c'u ri alak quecämisaj na alak, querip na alak jujun chque cho ri cruz. Jujun chic quech'ay na alak pa tak ri rachoch Dios. Jujun chic cäban alak c'äx chque je ri' chi rajwaxic queanimaj na bi pa tak ri tinimit. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Rumal ri' alak ajchak' mac che ri qui cämical conojel ri utzalaj tak winak ri e cämisam. Xchaptaj lok ruc' ri Abel ri ala ri jicom ranima' c'ä ruc' ri Zacarías ru c'ojol ri Berequías ri xcämisaj alak chquixol ri rachoch Dios ruc' ri ta'bal tok'ob. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Kas tzij quinbij chech alak chi ronojel wa' we mac ri' cäkaj na pa qui wi' ri winak cämic, —xcha ri Jesús chque ri tijonelab re ri Pixab xukuje' ri fariseos. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","¡Ay, winak aj Jerusalén! ¡Ix ri' ri queicämisaj ri k'alajisal tak re ru Lok' Pixab ri Dios, queiban che abaj ru tako'n ri Dios! ¡Q'uia mul nu rayim i mulixic iwonojel ri ix jas cuban jun ati't ec' queumulij ri alaj tak ral chuxe' ru xic'! ¡Ri ix c'ut man xiwaj taj! ");
INSERT INTO qucTNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Xak ba' chiwila na cäwonobax na can ri iwachoch. ");
INSERT INTO qucTNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Quinbij c'u chiwe chi man quiwil tä chi na nu wäch c'ä copan na ri k'ij aretak quibij: “Nim u k'ij ri petinak pa ru bi' ri Kajaw Dios,” —quixcha na, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Xel lok ri Jesús pa ri nimalaj rachoch Dios, benam re aretak xekeb ru tijoxelab ruc', xquichaplej u c'utic tak ri ja re ri nimalaj rachoch Dios chuwäch. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Xch'aw c'u ri Jesús, xubij chque: ¿A quiwil we nimak tak ja ri'? Kas tzij ri quinbij chiwe chi man cäcanaj tä c'u can jun abaj puwi' jun abaj chic. Ronojel cäwulix na, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Xe' c'u ri Jesús e rachi'l ru tijoxelab puwi' ri Ujuyubal Olivos. T'uyul c'u ri Jesús chila', ru tijoxelab xeopan ruc', xquibij che pa u tuquiel wi: Cäkaj chi cäbij la chke, ¿jampa' cäbantaj na wa'? ¿Jas u wäch etal cäbantaj na chuc'utic chkawäch chi xopan ri k'ij re ri petbal la xukuje' ri q'uisbal re ruwächulew? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ri Jesús xubij chque: Chichajij iwib, c'o jachin jun mixsubuwic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","E q'uia c'ut ri quepe na, cäquicoj na ri nu bi', cäquibij: “In ri' ri Cristo,” —quecha na. E q'uia winak c'ut ri quesubtaj na cumal, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ri ix quita na chi tajin cäban nimalaj ch'oj, quita na qui tzijoxic tak ch'oj jawije' tak chi', mixej c'u iwib. Rajwaxic chi je' cäbantaj na wa', c'ä mäja' c'u ri q'uisbal. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Cäch'ojin c'u na ri jun tinimit ruc' ri jun tinimit chic, xukuje' cäch'ojin na jun nim takanel ruc' jun nim takanel chic. Cäpe na wi'jal, cäpe na nimak tak yabil, quepe na q'uia cäbrakan jawije' tak chi'. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Xak c'u chaplebal wa' re ronojel ri c'äx ri cäpe na pa qui wi' ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Quixjach c'u na chquiwäch ri k'atal tak tzij rech cäban c'äx chiwe, quixcämisax na. Conojel ri winak cäquetzelaj na i wäch xa rumal wech in. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Pa tak ri k'ij ri' e q'uia ri cuban na quieb qui c'ux chwij. Cäquetzelaj na quib chbil tak quib, cäquijachala na quib pa cämisaxic. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","E q'uia ri quepe na ri xak e banal tak tzij, cäquibij chi e k'alajisal tak re ru Lok' Pixab ri Dios, e q'uia c'u ri winak ri quequisub na. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Sibalaj cänimar na ri etzelal. Je ri' chi e q'uia winak man cäcaj tä chi na quib. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Jachin c'u ri cuch'ij ri c'äx c'ä cäq'uis na ronojel, curik na ru tobanic ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Cätzijox c'u na ri Utzalaj Tzij re ri Evangelio chrij ru takanic ri Dios cho ronojel ruwächulew chque conojel qui wäch winak, te c'u ri' cäpe na ri q'uisbal. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ri ka mam Daniel, jun chque ri k'alajisal tak re ru Lok' Pixab ri Dios, xutz'ibaj ojer chrij ri itzel awaj ri quetzelan na ronojel. (Jachin ri cusiq'uij wa' ri tz'ibtal waral, chuch'obo' jachin ri' ri awaj ri cubij chi'.) Quiwil na wa' cäc'oji chila' pa ri lok'alaj c'olibal jawije' ri man ya'tal tä wi chi c'olic. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Rajwaxic chi ri winak ri e c'o pa Judea queanimaj bi pa tak ri juyub. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ri winak ri c'o puwi' ri rachoch, aninak chkaj lok, moc chi bi chupam ri ja chuc'amic bi jas jun jasach. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Xukuje' ri winak ri c'o pa ri juyub, mätzelej chi bi cho ja chuc'amic bi ri ratz'iak. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Sibalaj c'äx que ri ixokib ri yawab tak winak chic pa tak ri k'ij ri', xukuje' ri c'o alaj tak cal ri c'ä quetu'nic! ");
INSERT INTO qucTNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Chibana ba' orar, chita' che ri Dios chi mäc'ulmataj ronojel wa' pa u k'ijol ri tew, xukuje' chi mat cäbantaj wa' pa ri k'ij re uxlanem. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Cäpe c'u na nimalaj c'äxc'ol pa tak ri k'ij ri', ri man c'o tä jumul u banom wa' tzare chi' xchaplex lok ru banic ruwächulew rumal ri Dios, c'ä cämic. Te c'u ri' man cäpe tä chi na nimalaj c'äxc'ol junam ruc' ri c'äxc'ol ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","We ta ri Kajaw Dios mat cubano chi xak k'atatal k'ij cäc'oji we c'äxc'ol ri', mat c'o jun winak ri' ri cäc'asi canok. Ri Dios c'ut u banom chi xak k'atatal k'ij cäc'oji wa' we c'äxc'ol ri' rumal chi queraj ri e cha'tal rumal ri Are', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","We c'u c'o jun ri cubij chiwe: “Chiwilampe', c'o ri Cristo chi ri',” we cubij: “Chiwilampe', c'o jela',” —cächa chiwe, micojo ri cubij. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Quepe c'u na winak ri cäca'n che quib chi e Cristo, xukuje' quepe na jule' chic ri cäca'n che quib chi e k'alajisal tak re ru Lok' Pixab ri Dios. Cäca'n na nimak tak etal, xukuje' nimak tak cajmabal che qui subic ri winak, xukuje' ne ri e cha'tal rumal ri Dios we quecowinic. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nu bim chi c'u apan wa' chiwe ix, c'ä mäja' cäbantajic. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Rumal ri', we cäbix chiwe: “Chiwilampe', waral c'o wi ri Are' pa ri juyub ri cätz'inowic,” mixe' che rilic. We cäbix chiwe: “Chiwilampe', waral c'o wi pa ja,” micojo, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Je' jas cuban ri caypa' ri cärepk'un cho ri caj chrelbal k'ij cäk'alajin c'ä chukajbal k'ij, are je ri' ri nu petic in, in ri' ri Ralc'ual ri Dios ri Kas Winak. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Jawije' c'u c'o wi ri cäminak, chila' cäquimulij wi na quib ri c'uch, —xcha ri Jesús chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Xak xuwi c'u coc'ow ri nimalaj c'äx ri', ri k'ij cäk'ekumar na, ri ic' man cätunun tä chic, quetzak c'u na lok ri ch'imil cho ri caj. Queslabisax c'u na conojel ri c'o qui chuk'ab ri e c'o cho ri caj je' jas ri k'ij, ri ic', ri ch'imil xukuje' niq'uiaj chic. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Te c'u ri' quilitaj na cho ri caj ri retal ri nu petbal in, in ri' ri Ralc'ual ri Dios ri Kas Winak. Quebok' c'u na ri winak pa conojel tinimit cho ruwächulew. Quinquil c'u na in, in ri' ri Ralc'ual ri Dios ri Kas Winak, in petinak pa tak ri sutz' cho ri caj ruc' nimalaj chuk'ab, cänimarisax c'u na nu k'ij. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Queintak c'u na bi ri nu ángeles, rech ruc' ru ch'abal ri trompeta ri sibalaj co cätataj na pa ronojel ruwächulew, quebe' c'u che qui mulixic conojel ri e cha'tal rumal ri Dios pa ri relbal k'ij, pa ri u kajbal k'ij, pa ri u mox ri relbal k'ij, pa ri uwiquiäk'ab ri relbal k'ij, pa ronojel ruwächulew, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Chich'obo ba' ri c'utbal chrij ru che'al higos: Aretak queräxar ru k'ab, quetuxin c'u ru xak, iwetam ri' chi xak jubik' chic man copan ri k'alaj. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Je ri' xukuje' ri ix aretak quiwilo chi tajin cäc'ulmataj ronojel wa', chiwetamaj chi xak jubik' chic man copan ri k'ij ri quinpetic. Je' ta ne chi in c'o chi' ri uchibe. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Kas tzij ri quinbij chiwe chi quebantaj na ronojel wa' c'ä mäjok quecäm ri winak re we k'ij junab ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Cäsach na u wäch ri caj xukuje' ruwächulew, are c'u ri tzij ri nu bim chiwe quebantaj na wa', man cäsach tä qui wäch, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Man c'o tä c'u jachin jun retam jampa' copan ri k'ij ri', man etamtal tä c'u ri hora. Man quetam tä ri ángeles chila' chicaj, man retam tä c'u ru C'ojol ri Dios, xane xak xuwi ri ka Tat Dios retam wa', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Jas ri xc'ulmataj pa ru k'ijol ri ka mam Noé ojer, are je' cäc'ulmataj na aretak ri in quinpetic, in ri' ri Ralc'ual ri Dios ri Kas Winak. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Pa tak ri k'ij ri', c'ä mäjok xkaj ri nimalaj k'ekal jäb, ri winak xak xuwi xquilij ri wi'm, ru tijic tak vino. Xec'uli'c, xquiya ri calc'ual che c'ulanem. Je wa' xca'n ronojel k'ij c'ä xoc na ri ka mam Noé pa ri arca. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Man xeboc tä il c'ä xkaj na ri k'ekal jäb pa qui wi', xecäm c'u conojel. Je ri' xukuje' cäc'ulmataj na aretak quinpe in, in ri' ri Ralc'ual ri Dios ri Kas Winak. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Pa ri k'ij ri' quec'oji na quieb achijab ri tajin quechacun pa juyub. Jun chque cäc'am na bic, are c'u ri jun chic cäyi' na canok. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Pa ri k'ij ri' quec'oji na quieb ixokib ri tajin queque'nic. Ri jun cäc'am na bic, are c'u ri jun chic cäyi' na canok. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Chiwila ba' iwib, chixc'asc'atok, rumal chi man iwetam taj jachique hora ri cäpe ri Iwajaw, ru C'ojol ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mäsach ba' chiwe ri quinbij chanim ri': We ta jun rajaw ja retam jas hora copan ri elak'om chak'ab, man cäwar tä na ri', xane cäc'asi na. Man cuya tä ri' chi ri elak'om coc bi pa ri rachoch che relak'axic bi ri jastak re. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Rumal ri' chibana u banic iwib, xak chixeyenok. Aretak c'ut man quichomaj taj chi quinpetic, quinpe na in, in ri' ri Ralc'ual ri Dios ri Kas Winak. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Kachomajmpe' jas ri cuban jun patrón, ri c'o jun patänil re ri jicom ranima', ri c'o u no'j, cucoj c'u can che qui chajixic conojel ri e c'o pa rachoch rech cuya ri qui wa conojel ri rajchaquib ronojel k'ij. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Utz re ri patäninel ri' we tajin cubano jas ri xtak wi canok aretak cätzelej lok ru patrón. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Kas tzij ri quinbij chiwe, chi ri patrón cucoj na ri patäninel ri' che chajil re conojel ri jastak re. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","We c'u ri patäninel man utzalaj achi taj, cuchomaj c'u ri are' chi ru patrón man cätzelej tä lok chanim, ");
INSERT INTO qucTNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","cuchaplej u banic c'äx chque ri niq'uiaj ajchaquib, cuchaplej wi'm, cuchaplej u tijic ja' cuc' ri k'abarelab. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Te'talic ri patrón cätzelej lok pa ri k'ij ri man retam tä ri patäninel, pa ri hora ri man cuchomaj taj. ");
INSERT INTO qucTNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Sibalaj c'äx c'u ri c'äjisabal u wäch cuya na ri patrón, junam u c'äjisaxic u wäch cuban na cuc' ri winak ri xak quieb qui wäch. Cutij c'u na ok'ej cuc', cukuch'uch'ej na ru ware, —xcha ri Jesús chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ru takanic ri Dios pa qui wi' ri winak quinjunamaj ruc' ri lajuj alitomab ri xebe' cho rachoch ri ali ri cäc'uli'c che reyexic ri novio. Chquijujunal c'ut xquic'am bi ri qui lámparas. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","E job chque ri alitomab e sak'orib, are c'u ri job chic e sac'aj. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ri alitomab ri e sak'orib xquic'am bi ri qui lámparas, man xquic'am tä c'u bi niq'uiaj aceite chic rech cäquiya chquipam. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Are c'u ri alitomab ri e sac'aj xquic'am bi ri qui lámparas xukuje' xquic'am bi ri qui leme't re aceite. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Xbeytaj c'u ri novio. Ri lajuj alitomab conojel xquichaplej yuxc'atem, xewar c'ut. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Pa niq'uiaj ak'ab c'ut xtataj jun ri co xch'awic, xubij c'ut: “¡Chiwilampe', xpe ri novio, chixel lok chuc'ulaxic!” —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Xewalij c'u conojel ri alitomab, xquiban u banic ri qui lámparas. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Are c'u ri alitomab ri e sak'orib xquibij chque ri alitomab ri e sac'aj: “Chiya jubik' ke ri iwaceite rech man quechup tä ri ka lámparas uj,” —xecha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ri alitomab ri e sac'aj xech'awic, xquibij: “Man cuya' taj, rumal chi man cubana tä ne ri kech uj we cäkaya ri iwe ix. Are utz xa quilok'o lok ri iwe pa ri c'ayibal,” —xecha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","E benak c'u ri job alitomab ri e sak'orib chulok'ic ri aceite aretak xopan can ri novio. Ri job alitomab ri cuc'am caceite xeboc ruc' ri novio pa ri nimak'ij re ri c'ulanem. Xtz'apix c'u ri uchija. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Xetzelej c'u lok ri job alitomab chic ri xebe' chulok'ic ri caceite, xquibij c'ut: “¡Tat, tat, jaka la ri uchija chkawäch!” —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ri are' c'ut xubij chque: “Kas tzij quinbij chiwe chi man wetam tä i wäch,” —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Xubij c'u ri Jesús chque ru tijoxelab: Chiwila ba' iwib ix, chixc'asc'atok, rumal chi man iwetam taj jachique k'ij, jachique hora quinpe in, in ri' ri Ralc'ual ri Dios ri Kas Winak, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ru takanic ri Dios pa qui wi' ri winak quinjunamaj ruc' jun achi ri que' pa binem. Ri achi ri', aretak xak jubik' craj chi quel bic rech que' pa jun tinimit chic, xeusiq'uij ri patänil tak re, xujach c'u can ru rajil chquiwäch rech quechacun ruc'. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Xuya chque chquijujunal jas ri quecowinic chucojic. Xuya job mil quetzal che ri jun, che ri jun chic xuya quieb mil quetzal, che ri jun chic xuya mil quetzal. Te ri' ri achi xe' pa ru binem. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ri patäninel ri xuc'am job mil quetzal xe'c, xchacun ruc' ri puak. Je ri' xuch'ac chi job mil quetzal chic. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Xukuje' ri patäninel ri xuc'am quieb mil quetzal je' xubano, xuch'ac chi quieb mil quetzal chic. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Are c'u ri patäninel ri xuc'am xa mil quetzal xe'c, xuc'u' ru rajil ru patrón, xumuk pa ri ulew. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Xque' c'u q'uia k'ij, xtzelej lok ri qui patrón ri patäninelab, xuchap c'u u banic cuenta cuc' chrij ru rajil. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nabe xopan ri u c'amom job mil quetzal, xujach c'u che ru patrón ri job mil quetzal chic ru ch'acom, xubij che: “Tat, job mil quetzal xya la chwe, cämic ri' quinjach che la ri job mil quetzal chic ri xinch'aco,” —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ri patrón xubij che: “Ri at, at utzalaj patäninel ri jicom awanima'. Rumal chi jicom awanima' ruc' ri jubik' ri xinya chawe, nim c'u na ri quinya chi na chawe. Chatoc ba' lok, chatquicot junam wuc',” —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Xopan chi c'u ri patäninel ru c'amom quieb mil quetzal, xubij che ru patrón: “Tat, quieb mil quetzal xya la chwe, cämic ri' quinjach che la ri quieb mil chic ri xinch'aco,” —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ri patrón xubij che: “Ri at xukuje' at utzalaj patäninel ri jicom awanima'. Rumal chi jicom awanima' ruc' ri jubik' ri xinya chawe, nim c'u na ri quinya chawe, chatoc ba' lok, chatquicot junam wuc',” —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Aretak c'ut xopan ri patäninel ri u c'amom xa mil quetzal, xubij che ru patrón: “Tat, ri in wetam chi sibalaj lal c'a'n, chi cäyac la u wäch ri ulew ri man xticonij tä wi la, cämol la ri man xjopin tä wi la. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Rumal ri' xinxej wib, xine' c'ut, xinc'u' ri rajil la, xinmuk pulew. Quinjach c'u we rajil la ri',” —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Xubij c'u ri patrón che: “Ri at, at itzelalaj patäninel ri xa casak'orij ra chac. Caq'uey u ch'aquic ri puak. Ri at awetam chi quinyac u wäch ri ulew ri man quinticonij tä wi, xukuje' quinmol ri man xinjopij taj. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","We je ri', xaya ta c'u ri nu rajil pa ri banco. We ta je ri' xabano, aretak xintzelej lok xinc'am ta ri' ri nu rajil ruc' ri ral,” —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ri patrón xubij chque ri niq'uiaj ajchaquib chic ri e c'o chila': “Chic'ama ba' ri mil quetzal che, chiya che ri jun ri c'o lajuj mil quetzal ruc',” —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","“Je ri', rumal chi jachin ri q'uia c'o ruc' cäyi' na niq'uiaj chic che, coc'ow c'u na u wi' ri c'o ruc'. Are c'u ri jun ri man q'uia tä c'o ruc', quesax na ri jubik' ri c'o ruc',” —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","“Are c'u we patäninel ri' ri man c'o tä xuch'ac chrij ri rajil ri xyi' che, jiq'uiäka can chrij ja pa ri k'ekum. Chila' c'ut cok' wi na, chila' cukuch'uch'ej wi na ru ware,” —xcha ri Jesús chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Aretak quinpe na in, in ri' ri Ralc'ual ri Dios ri Kas Winak, ya jun Nim Takanel chic quinpetic. Conojel ri ángeles quepe na che wachi'l, quint'uyi c'u na pa ri je'lalaj nu t'uyulibal ri sibalaj nim u k'ij. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ri winak re conojel tak ri tinimit cho ruwächulew cäquimulij na quib chnuwäch, queincha' c'u na ri jicom qui c'aslemal chquixol ri man jicom taj. Je' quinban na jas ri cuban ri ajyuk' queucha' ri u chij chquixol ri q'uisic'. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Queinya na ri chij pa ri nu wiquiäk'ab, are c'u ri q'uisic' pa nu moxk'ab. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Te ri' ri in, in ri' ri Nim Takanel, quinbij na chque ri e c'o pa nu wiquiäk'ab: “Chixsa'j ix, ri ix tewchital rumal ri nu Tat. Chixoc chila' jawije' ri cätakan wi ri Dios, ri u chomam chi c'u lok wa' tzaretak xuban ri cajulew chi cuya chiwe. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Rumal chi aretak xinnumic, xiya nu wa, aretak xchaki'j nu chi', xiya jas quintijo, aretak xinwonocatic, xinic'ulaj cho tak iwachoch. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Aretak man c'o tä chi watz'iak, ri ix xiya ri watz'iak, aretak xinyawajic, xixopan wuc', aretak xinoc pa che', xixe' che wilic,” —quincha na chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ri winak ri jicom canima' chuwäch ri Dios cäquibij na chwe: “Tat, ¿jampa' c'u ri xkilo chi cänum la, te c'u ri' xkaya wa la? ¿Jampa' xkilo chi cächaki'j chi' la, te c'u ri' xkaya jas ri cätij la? ");
INSERT INTO qucTNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Jampa' ta c'u xkilo chi xak cäwonocat la, xkac'ulaj ta c'u la pa ri kachoch? ¿Jampa' xkilo chi man c'o tä atz'iak la, xkaya c'ut? ");
INSERT INTO qucTNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Jampa' ta c'u xkilo chi lal yawab o c'o la pa che', te c'u ri' xujopan uc' la che rilic jas banom la?” —quecha na. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ri in, in ri' ri Nim Takanel, quinbij na chque: “Kas tzij quinbij chiwe, chi apachique utzil ri xiban che apachin chque ri wachalal pune man nim u banic, chwe in ri' xiban wi wa',” —quincha na chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Quinbij c'u na chque ri winak ri e c'o pa nu moxk'ab: “Chixel chnuwäch, ix ri k'atom tzij pi wi' chi cäc'äjisax i wäch. Jix pa ri k'ak' ri man cächuptaj taj ri banom u banic rech chila' quec'ol wi ri Itzel e rachi'l ru ángeles. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Rumal chi aretak xinnumic, man xiya tä nu wa, aretak xchaki'j nu chi', man xiya tä chwe jas quintijo. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Aretak xak xinwonocatic, man xinic'ulaj tä cho tak iwachoch. Aretak man c'o tä chi watz'iak, man c'o tä ri xiya chwe. Aretak xinyawajic, aretak xinoc pa che', man xixopan tä che wilic,” —quincha na chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Cäquibij c'u na chwe: “Tat, ¿jampa' ta c'u lo xkilo chi cänum la, jampa' xkilo chi cächaki'j chi' la, jampa' xkilo chi xak cäwonocat la, jampa' xkilo chi man c'o tä atz'iak la, jampa' xkilo chi xyawaj la o xoc la pa che', te c'u ri' man xujtob tä che la?” —quecha na chwe. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ri in, in ri' ri Nim Takanel, quinch'awic, quinbij na chque: “Kas tzij quinbij chiwe chi apachique utzil ri man xiban tä che apachin jun winak, pune man nim u banic, chwe in ri' man xiban tä wi,” —quincha na chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ri winak ri' quebe' na chila' jawije' ri man cätäni tä wi ru c'äjisaxic qui wäch. Are c'u ri winak ri jicom canima' cho ri Dios quebe' na chila' jawije' ri c'o wi ri c'aslemal ri man c'o tä u q'uisic, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Aretak xto'taj ri Jesús chubixic ronojel wa' we tzij ri', xubij chque ru tijoxelab: ");
INSERT INTO qucTNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Ri ix iwetam chi xa pa quieb k'ij cäban na ri nimak'ij, Pascua u bi'. Ri in c'ut, in ri' ri Ralc'ual ri Dios ri Kas Winak, quinjach na pa qui k'ab ri nu c'ulel, rech quinrip cho ri cruz, quincämisax na, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Xquimulij c'u quib ri qui nimakil sacerdotes, ri tijonelab re ri Pixab xukuje' ri qui nimal ri winak aj Israel cho ri nimalaj ja rech ri tat Caifás ri qui nimal sacerdotes. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Chila' xquitala qui no'j chbil tak quib jas cäca'n na chuchapic ri Jesús ruc' subunic rech cäquicämisaj. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Xquibij c'ut: Mächap pa ri nimak'ij, rech metuquin ne ri winak, —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Are c'u ri Jesús c'o pa ri tinimit Betania cho rachoch ri tat Simón, jun tata' ri xc'oji na itzel ch'a'c che. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Xopan jun ixok ri ruc'am jun c'olibal cunabal re alabastro ri nojinak che c'oc'alaj cunabal. Sibalaj pakal rajil wa' we cunabal ri'. T'uyul c'u ri Jesús chi' ri mesa, ri ixok xuk'ij ri aceite pu jolom ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Aretak ri tijoxelab xquil wa', xpe coyowal, xquibij c'u chbil tak quib: ¿Jas che xak xtix wa' we cunabal ri'? —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Xq'uiyix ta ne wa', xtoj ta nimalaj rajil, xyi' ta c'u ri puak chque ri meba'ib, —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Xuta c'u ri Jesús ri cäquibij, xubij chque: ¿Jas che quiya latz' che ri ixok ri'? Jun nimalaj utzil c'u wa' ru banom chwe, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Amak'el ronojel k'ij c'ut e c'o ri meba'ib iwuc', are c'u ri in man in c'o tä iwuc' amak'el. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ri xuban ri ixok aretak xuk'ij ri c'oc'alaj aceite chwij, xa xucoj c'u bi ri c'oc'alaj cunabal chrij ri nu cuerpo c'ä mäjok quinmukic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Kas c'u tzij ri quinbij chiwe chi apawije' ta ne ri cätzijox wi na ri Utzalaj Tzij re ri Evangelio cho ronojel ruwächulew, ru banom we ixok ri' cätzijox na che na'tabal re, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Te c'u ri' jun chque ri cablajuj tijoxelab, ri u bi' Judas Iscariote, xel bic, xe' cuc' ri qui nimakil ri sacerdotes. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Xubij c'u chque: ¿Jas cäya alak chwe, we quinjach ri Jesús pa k'ab alak? —xcha chque. Ri e are' c'ut xquiya juwinak lajuj rakan sak puak che ri tat Judas. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tzare chi' c'ut ri tat Judas xutzucuj jun utzalaj k'ij rech cujach ri Jesús pa qui k'ab. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pa ri nabe k'ij re ri nimak'ij aretak cätijow ri caxlan wa ri man cäyi' tä ch'äm ruc', ru tijoxelab ri Jesús xekeb ruc', xquibij che: ¿Jawije' caj wi la chi cäka'n wi ri wi'm re ri Pascua rech cätij la? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ri Jesús xubij chque: Jix pa ri tinimit cho rachoch ri jun achi, chibij c'u che: “Cuta' ri Kajtij che la, cubij: Ya xopan ri hora. Cho achoch c'u la quinban na u banic wi ri nimak'ij re ri Pascua cuc' ri nu tijoxelab,” —cächa ri', —quixcha che, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ri tijoxelab xca'no jas ri xetak wi rumal ri Jesús. Xca'n c'u u banic ri wi'm re ri Pascua chila'. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Aretak chak'ab chic, ri Jesús xt'uyi chi' ri mesa cuc' ri cablajuj u tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","E t'uyul chila' chi' ri mesa, tajin quewi'c aretak ri Jesús xubij chque: Kas tzij ri quinbij chiwe chi c'o jun chiwe ri quinujach na, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ru tijoxelab sibalaj xebisonic. Chquijujunal c'ut xquichaplej u ta'ic che ri Jesús: Kajaw, ¿a man xa in ri'? —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ri Jesús xch'awic, xubij chque: Are ri jun ri curub ru wa wuc' pa ri lak, are c'u ri' ri quinjachow na, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Je' c'u quel na jas ri tz'ibtal pa ru Lok' Pixab ri Dios chwij in, in ri' ri Ralc'ual ri Dios ri Kas Winak. ¡C'äx c'u ri curik na ri achi ri quinjachow na! ¡Utz na re we achi ri' we ta mat xil u wäch! —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Xch'aw c'u ri Judas ri tijoxel ri cäjachow na, xubij che ri Jesús: We ne in, Ajtij, —xcha che. Xubij ri Jesús che: Je', at ri', —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Aretak tajin quewi'c, ri Jesús xuc'am ri caxlan wa, xuban orar, xumaltioxij wa' che ri Dios. Te c'u ri' xupiro, xuya chquiwäch ru tijoxelab, xubij: Chitija iwe wa', je' ta ne chi are nu cuerpo wa', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Te c'u ri' xuc'am jun vaso, xumaltioxij wa' che ri Dios, te ri' xuya chquiwäch ru tijoxelab, xubij chque: Chitija iwe iwonojel. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Je' ta ne chi are nu quiq'uel wa' ri cujiquiba ri c'ac' trato ru banom ri Dios cuc' ri winak. Cäturuw c'u na wa' ri nu quiq'uel che sachbal qui mac q'uia winak. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kas tzij ri quinbij chiwe chi man c'o tä jumul quintij chi na we ri vino re uvas, c'ä pa ri k'ij ri quintij na ri c'ac' vino junam iwuc' chila' jawije' ri cätakan wi ri nu Tat, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Te c'u ri' xquibixoj jun bix ri cuya u k'ij ri Dios, xebel bi chila', xebe' pa ri Ujuyubal Olivos. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Xubij c'u ri Jesús chque: Ri ix iwonojel quibisoj na nu wäch, quiniya na can nu tuquiel cämic chak'ab. Je c'u tz'ibtal can pa ru Lok' Pixab ri Dios: “Quincämisaj na ri ajyuk', quejabun c'u na ri chij,” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Aretak c'u ri in, in c'astajinak chic chquixol ri cäminakib, quinnabej na bi chiwäch, quine' na pa Galilea, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Xubij c'u ri tat Pedro che ri Jesús: Pune conojel cäyi' la can cumal, ri in man je' tä ri' quinbano, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Xubij c'u ri Jesús che: Kas tzij ri quinbij chawe chi tzpa we ak'ab ri' cämic, cabij na at oxmul chi man awetam tä nu wäch mäjok cok' ri ama' ec', —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ri tat Pedro xubij che: Pune rajwaxic chi quincäm na uc' la, man c'o tä na jumul quinbij chi man wetam tä wäch la, —xcha che. Je c'u xquibij xukuje' conojel ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Xopan c'u ri Jesús pa ri ch'äkap ulew u bi' Getsemaní e rachi'l ru tijoxelab, xubij c'u chque: Chixt'uyul can waral. Ri in c'ut quine' na jela' chubanic orar, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Xuc'am bi ri tat Pedro ruc' xukuje' ri quieb u c'ojol ri tat Zebedeo. Xuchaplej c'u t'ujuwem ri Jesús, xc'äxc'ob ri ranima'. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Xubij c'u chque: Sibalaj cuq'uis rib ri wanima' chupam ri bis. Chixcanaj can chi', chixc'asc'at wuc', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Te ri' xbin chi apan jubik' ri Jesús, xxuqui'c, xuya ru palaj cho ri ulew, xuban orar, xubij: Tat, we cuya', chesaj ba' la we vaso ri' chnuwäch, bana la chi man cäpe tä ri c'äx ri' chwij. Mäban ba' xa jas ri nu rayibal in, xane jas ri rayibal la, —xcha che ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Xtzelej c'u ri Jesús jawije' e c'o wi ru tijoxelab, xeurika tajin quewaric. Xubij c'u che ri tat Pedro: ¿A mat xixcowinic xixc'asi ta jun hora wuc'? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Chiwila ba' iwib, chixc'asc'atok, chibana orar rech man quixtzak taj aretak quixtakchi'x che mac. Kas tzij pa ri iwanima' quiwaj quiban ri utzil, man c'o tä c'u u chuk'ab ri i cuerpo chubanic wa', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Xe' chi jumul ri Jesús chubanic orar, je' xubij wa': ¡Tat! We ba' tzrajwaxic wi chi cäpe ri c'äx ri' chwij, bana ba' la chwe jas ri rayibal la, —xcha che ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Te c'u ri' xtzelej chic, xeurika ru tijoxelab jumul chic tajin quewaric rumal chi sibalaj c'äx qui waram. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Xeuya canok, xe' chi jumul ri Jesús chubanic orar churoxmul, je c'u xubij jas ri xubij nabe. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Te c'u ri' xe' jela' jawije' e c'o wi ru tijoxelab, xubij chque: Chixwar ba', chixuxlanok. Xopan ri hora. Quinjach c'u na in, in ri' ri Ralc'ual ri Dios ri Kas Winak, pa qui k'ab ri ajmaquib, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Jo' ba'! ¡Chixwalijok! Chiwilampe', xpe ri jachal we, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","C'ä tajin cäch'aw ri Jesús aretak xopan ri tat Judas, jun chque ri cablajuj u tijoxelab. E petinak ruc' ri are' q'uia winak ri cuc'am machetes, cuc'am che'. E takom lok cumal ri qui nimakil sacerdotes, xukuje' cumal ri qui nimakil ri winak aj Israel. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ri tat Judas ri jachal re ri Jesús u yo'm c'u can jun etal chque ri winak, xubij: “Ri quintz'umaj, are ri' ri Jesús. Chichapa', kas utz chibana bi chuc'amic,” —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Xkeb c'u ri tat Judas ruc' ri Jesús, xubij che: ¡Xoc ak'ab, Ajtij! —xcha che. Te c'u ri' xutz'umaj. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ri Jesús xch'awic, xubij che: Wachi'l, ¿jas a tajquil xatpetic? —xcha che. Xekeb c'u ri winak ruc' ri Jesús, xquichapo, xquiyut bic. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Aretak je' xbanic, jun chque ri e rachi'l ri Jesús xuc'am ru machete, xusoc ri patänil re ri qui nimal sacerdotes, xuk'at apan ru xiquin. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Xubij c'u ri Jesús che: Chaya ri a machete pa ri c'olibal re. Conojel c'u ri quech'ayan ruc' machete, ruc' machete quecämisax na, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿A mat awetam chi quincowinic quinta' apan che ri nu Tat chi quinuto', chi ri Are' cutak na lok chanim oxc'al lajuj mil ángeles che nu to'ic? ");
INSERT INTO qucTNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","We ta c'u je ri', man je' tä quel wi ri' ri tz'ibtal pa ru Lok' Pixab ri Dios, chi rajwaxic cäbantaj na wa' we ri', —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Xubij c'u ri Jesús chque ri winak: ¿Jas lo wa' chi je' ta ne chrij jun elak'om elinak wi lok alak? ¿A c'amom alak lok ri machete alak, ri che' alak che nu chapic? —xcha chque. Ronojel k'ij xinc'oji uc' alak pa ri nimalaj rachoch Dios, xinya ri tijonic chech alak, man xinchap tä c'u alak. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Je c'u cäban na wa' chwe, rech je' cäbantaj na jas ri tz'ibam can chwij cumal ri k'alajisal tak re ru Lok' Pixab ri Dios, —xcha chque. Chanim c'ut conojel ri tijoxelab xquiya can ri Jesús u tuquiel, xeanimaj bic. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ri winak ri xechapow ri Jesús xquic'am bi chuwäch ri tat Caifás, ri kas qui nimal ri sacerdotes. Chila' c'ut qui mulim wi quib ri tijonelab re ri Pixab, xukuje' ri qui nimakil ri winak aj Israel. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Are c'u ri tat Pedro xuterenej bi ri Jesús chi naj, xopan pa ri uwoja rech ri rachoch ri kas qui nimal sacerdotes. Xoc bi ri tat Pedro, xt'uyi c'u ri are' chila' cuc' ri chajil tak re ri nimalaj rachoch Dios rech cärilo jas ri cäc'ulmataj na ruc' ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ri qui nimakil sacerdotes, ri qui nimakil ri winak aj Israel, xukuje' conojel ri c'amal tak qui be ri winak, tajin cäquitzucuj jas u wäch mac ri cäk'alajisax chrij ri Jesús, pune man kas tzij taj, rech cäk'at tzij puwi' chi cäcämisaxic. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Man xquirik tä c'ut, pune e q'uia winak xquimulij quib, xquibij ri man kas tzij taj chrij ri Jesús. Q'uisbal re c'ut xepe quieb achijab chic ri xquik'alajisaj ri man kas tzij taj chrij ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Xquibij: We achi ri' cubij: “Ri in quincowinic quinwulij ri nimalaj rachoch Dios, quinyac chi c'u na pa oxib k'ij,” —cächa', —xecha ri achijab. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Xwalij c'u ri kas qui nimal sacerdotes, xuta' che ri Jesús, xubij che: ¿A mat c'o jas jun tzij cabij chutzelexic u wäch ri tajin cäbix chawij? ¿Jas pu wa' ri tajin cäquik'alajisaj we achijab ri' chawij? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Man xch'aw tä c'u ri Jesús. Xubij c'u ri qui nimal sacerdotes che: Pa ru bi' ri c'aslic Dios, quinbij chawe chi chabana juramento chubixic ri kas tzij. Chabij chke we at ri' ri Cristo ri u C'ojol ri Dios, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Xch'aw c'u ri Jesús, xubij che: In ri', tat, jas ri cäbij la, —xcha che. Quinbij c'u in chech alak, chi quinil na alak ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak, aretak in t'uyul pa ru wiquiäk'ab ri Dios ri sibalaj c'o u chuk'ab, aretak quinpe pa tak ri sutz' ajchicaj, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Are c'u ri kas qui nimal sacerdotes xurak'atij ri ratz'iak chuc'utic chi sibalaj c'äx xuna' ri xubij ri Jesús. Xubij c'u ri tata': We achi ri' u bim ri äwas u bixic chrij ri Dios. ¿Jas ta ne che e rajwaxic chi niq'uiaj k'alajisanelab chic chrij? I tom c'u ix chi u bim ri äwas u bixic chrij ri Dios, —xcha chque ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Jas c'u quichomaj? Ri e are' xquibij: C'o u mac, rajwaxic c'ut chi cäcämisaxic, —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Xquichubaj u palaj ri Jesús, xquit'oco. Niq'uiaj chic xquicoj k'ab chupalaj. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Xquibij c'u che: At ri' ri Cristo, ¡chach'obo ne jachin ri xatch'ayowic! —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Are c'u ri tat Pedro t'uyul can cho ja. Xopan c'u jun ali ajic' ruc', xubij che: Ri at xukuje' xatc'oji ruc' ri Jesús ri aj Galilea, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Are c'u ri tat Pedro xresaj rib chupam chquiwäch conojel, xubij: Man quinch'ob taj jas ri tajin cabij, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ri tat Pedro kas raj quel bi chuchi' ri ja, aretak xilitaj chi rumal jun ajic' chic, ri ajic' xubij chque ri e c'o chila': We achi ri' xukuje' xc'oji ruc' ri Jesús ri aj Nazaret, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Jumul chic ri tat Pedro xresaj rib chupam, xuban jurar, xubij: Ri in man wetam tä u wäch ri achi ri', —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Man naj tä c'u ri' ri winak ri e c'o chila' xeopan ruc' ri tat Pedro, xquibij che: Kas tzij ri at, at jun cuc' ri e rachi'l ri Jesús, rumal chi junam catch'awic jas ri winak aj Galilea, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Co c'u xch'aw ri tat Pedro, xuban jurar cho ri Dios, xubij: Man wetam tä u wäch ri achi ri', —xcha chque. Are chi' c'ut xok' jun ama' ec'. ");
INSERT INTO qucTNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Xna'taj c'u che ri tat Pedro ru bim ri Jesús che: “Ri at cabij na oxmul chi man awetam tä nu wäch, mäjok cok' ri ama' ec',” —xcha che. Xel c'u bi ri tat Pedro, sibalaj xuq'uis rib che ok'ej. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Aretak xsakiric, conojel ri qui nimakil ri sacerdotes, xukuje' ri qui nimakil ri winak aj Israel xquitala qui no'j, xquichomaj jas cäca'n chucämisaxic ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Xquiyut c'u bi ri Jesús, xquic'am bic, xequijacha pu k'ab ri tat Poncio Pilato ri k'atal tzij. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Aretak c'ut ri tat Judas, ri jachal re ri Jesús, xrilo chi xk'at tzij puwi' ri Jesús chi cäcämisaxic, xuna' c'äx pa ri ranima'. Xutzelej ri juwinak lajuj rakan sak puak chque ri qui nimakil ri sacerdotes xukuje' ri qui nimakil ri winak aj Israel. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Xubij chque: Xinmacun cho ri Dios rumal chi xinjach pa k'ab alak jun achi ri man c'o tä u mac rech cäcämisaj alak, —xcha chque. Ri e are' c'ut xquibij che ri tat Judas: ¿Jas ke uj che? ¡At chatilowok! —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Are c'u ri tat Judas xuq'uiäk can ri puak pa ri nimalaj rachoch Dios, xel bic, xe'c, xujitz'aj rib. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ri qui nimakil ri sacerdotes xquisic' ri puak, xquibij: Man cuya' taj cäkaya wa' we puak ri' pa ri c'olibal cuchuj, rumal chi rajil quic' wa', —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Xquichomaj c'ut chi ruc' wa' we puak ri' cäquilok' ri ulew ri cäbix Rulew ri Banal Bo'j che, rech c'o jun ulew ri quemuk wi ri winak ri man e aj Israel taj. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Rumal ri', c'ä cämic, ri ulew ri' cäbix Ulew re Quic' che. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Je ri' xbantajic jas ri xubij can ri ka mam Jeremías ri k'alajisal re ru Lok' Pixab ri Dios: “Xquic'am ri juwinak lajuj rakan sak puak (ri rajil jun achi ri chomam cumal ri winak aj Israel). ");
INSERT INTO qucTNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ruc' wa' xquilok' ri rulew ri banal bo'j. Are wa' ri in u takom wi ri Kajaw Dios,” —xcha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Xc'am c'u bi ri Jesús, xequijacha cho ri tat Pilato ri k'atal tzij. Xuta' c'u ri Pilato che, xubij: ¿A at ri' ri cattakan pa qui wi' ri winak aj Israel? —xcha che. Ri Jesús xubij che: Je ri' jas ri cäbij la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Q'uia tzij c'ut xca'n ri qui nimakil ri sacerdotes chrij ri Jesús, xukuje' ri qui nimakil ri winak aj Israel. Are c'u ri Jesús man c'o tä jas xubij. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Xubij c'u ri tat Pilato che: ¿A mat cata ri tajin cäbix chawij? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Man c'o tä c'u jun tzij xubij ri Jesús, je ri' chi xucajmaj wa' ri tat Pilato. Man curik tä c'u ri are' jas cubano. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Are c'u ri tat Pilato ri k'atal tzij nak'atalic chi pa ri nimak'ij cuban jun tok'ob chque ri winak, cutzokopij bi jun ajpache', apachin ta ne ri cächa' cumal ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","C'o c'u jun ajpache', Barrabás u bi', ri etamtalic chi are jun itzel achi. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Aretak c'ut qui mulim chi quib ri winak, ri tat Pilato xuta' chque: ¿Jachin ri quiwaj chi quintzokopij bic? ¿A are quintzokopij bi ri tat Barrabás o are quintzokopij bi ri Jesús ri cäbix Cristo che? —xcha chque ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Cuch'ob c'u ri tat Pilato chi xa rumal chi c'äx cäquina' che ri Jesús, rumal ri' qui jachom pu k'ab. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","T'uyul c'u ri tat Pilato pa ri k'atbal tzij, aretak ri rixokil xtakan chubixic che: “C'o jas maban che we achi ri' ri man c'o tä u mac. Xinwachic'aj c'u jun jasach ri sibalaj xibibal chak'ab rumal we achi ri',” —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Are c'u ri qui nimakil ri sacerdotes xukuje' ri qui nimakil ri winak aj Israel xquicoj qui chuk'ab chubixic chque ri winak chi más utz na cäquibij chi are cätzokopix ri tat Barrabás, cäcämisax c'u ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ri k'atal tzij c'ut xch'aw chi jumul, xuta' chque ri winak: ¿Jachin chque ri quieb achijab quiwaj chi quintzokopij bic? —xcha chque. Ri winak xquibij: Are cätzokopij la ri tat Barrabás, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Xuta' c'u ri tat Pilato chque ri winak: ¿Jas c'u quinban che ri Jesús ri cäbix Cristo che? —xcha chque. Conojel ri winak xech'awic, xquibij: ¡Chripok! —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Xch'aw c'u ri tat Pilato, xubij chque: ¿Jas che? ¿Jas pu etzelal u banom wa' we achi ri'? —xcha chque. Co c'u na xech'aw ri winak, xquibij: ¡Chripok! —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Aretak ri tat Pilato xrilo chi man coc tä tzij pa qui jolom ri winak, xane xa tajin cäquituquij quib, xtakan chuc'amic joron, xuch'aj ru k'ab chquiwäch ri winak, te c'u ri' xubij: Man c'o tä we in che ru cämical we achi ri' ri man c'o tä u mac. Chibana ix jas ri quiwaj quiban che, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Conojel c'u ri winak xech'awic, xquibij: ¡Ri uj, xukuje' ri kalc'ual, uj ajchak' mac che ru cämical we achi ri'! —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ri tat Pilato xutzokopij c'u bi ri tat Barrabás. Xtakan chuch'ayic ri Jesús, te c'u ri' xujach bic rech cäripic, cäcämisax cho ri cruz. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Te ri' xepe ru soldados ri k'atal tzij, xquic'am bi ri Jesús pa ri nimalaj ja jawije' conojel ri soldados xquimulij quib chrij. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Xquesaj ri ratz'iak ri Jesús, xquicoj jun quiäk k'u' chrij. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Xquicoj jun corona re quemom q'uix chujolom, xquiya jun che' pu k'ab re uwiquiäk'ab, xexuqui chuwäch, xquitze'j u wäch, xquibij: ¡Nim u k'ij ri Nim Takanel pa qui wi' ri winak aj Israel! —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Xechuban chupalaj ri Jesús, xukuje' xquic'am ri che' pu k'ab, xquik'osij chujolom. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Aretak xeto'taj che retz'bexic u wäch, xquijolij ri quiäk k'u' chrij, xquicoj c'u ri kas ratz'iak ri Are' chrij. Te c'u ri' xquic'am bi churipic cho ri cruz. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Elem bi que, xquirik c'u jun achi aj Cirene, Simón u bi', xquicoj qui chuk'ab che rech cutelej bi ru cruz ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Je wa ri' xeopan pa ri juyub ri cäbix Gólgota che. We bi'aj ri' quel cubij: Ri Juyub re ru Bakil Jolomaj. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Xquiya jun vino che ri Jesús ri yujtal ruc' jun c'a k'ayes ri cäbix “mirra” che. Aretak c'ut xuna' ri Jesús, man xraj taj xutijo. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Aretak qui ripom chic ri Jesús cho ri cruz, ri soldados xquesaj suerte chujachic ri ratz'iak ri Jesús chquiwäch. Je c'u xbantajic jas ri xubij can ri k'alajisal re ru Lok' Pixab ri Dios ojer: “Xquesaj suerte chujachic ri watz'iak chquiwäch,” —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Te c'u ri' ri soldados xet'uyi chila' chuchajixic ri Are'. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Cojom c'u puwi' ri cruz jun tz'ibtalic ri cubij jas che xk'at tzij puwi' ri Jesús rech cäripic. Ri tz'ibtalic xubij: ARE WA' RI JESÚS, RI NIM TAKANEL PA QUI WI' RI WINAK AJ ISRAEL, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Xukuje' xerip quieb elak'omab ruc'. Jun pu wiquiäk'ab, jun pu moxk'ab. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ri winak ri xeoc'owic xquiyok'o, xquisutusa ri qui jolom. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Xquibij: At ri' ri cabij chi catcowinic cawulij ri nimalaj rachoch Dios, xa c'u pa oxib k'ij cayac chi na wa' jumul chic, chato' ba' awib. We at ri' ru C'ojol ri Dios, chatkaj lok cho ri cruz, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Je' xukuje' ri qui nimakil ri sacerdotes, ri tijonelab re ri Pixab, ri tata'ib fariseos cuc' ri qui nimakil ri winak aj Israel, xquitze'j u wäch, xquitzijobela quib, xquibij: ");
INSERT INTO qucTNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Xtob chque niq'uiaj chic, man cäcowin tä c'u ri Are' chuto'ic rib. We kas are Nim Takanel quech ri winak aj Israel, chkaj lok cho ri cruz, rech cujcojon che, —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Cubij chi u cu'bam u c'ux chrij ri Dios. We ba' kas tzij lok' chuwäch ri Dios, ri Are' cäto'w ta na chanim ri'. U bim c'ut chi are u C'ojol ri Dios, —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ri elak'omab ri e ripom ruc' ri Jesús, xukuje' xquetz'bej u wäch. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Xk'ekumar c'u ronojel ruwächulew. Xuwi xuchap pa ri niq'uiaj k'ij, c'ä te' xoc'ow pa ri urox hora benak k'ij. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kas pa ri hora ri' xurak u chi' ri Jesús, co xch'awic, xubij: Eloi, Eloi, ¿lama sabactani? —xcha'. Je' quel cubij wa': Nu Dios, nu Dios, ¿jas che in wonobam la canok? —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Jujun c'u chque ri e tac'atoj chila' xquita wa', xquibij: We achi ri' are tajin cusiq'uij ri ka mam Elías ri k'alajisal re ru Lok' Pixab ri Dios ojer, —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Te c'u ri' jun chque ri winak xutic anim, xe'c, xuc'ama lok jun estropajo, xurub chupam ch'äm vino, xuya wa' puwi' jun aj, xuya ak'an che ri Jesús rech cutijo. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Are c'u ri niq'uiaj winak chic xquibij: Chiya canok, chkila na we ne cäpe ri ka mam Elías chuto'ic, —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jumul chic co xurak u chi' ri Jesús, xcäm c'ut, xel ranima'. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Are chi' c'ut ri tasbal u pam ri nimalaj rachoch Dios xjisjobic, quieb xubano, xpe ajsic c'ä iquim. Xpe jun cäbrakan, ri nimak tak abaj c'ut xepaxic. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ri qui jul tak ri cäminakib xejakjobic, e q'uia ri ojer tak winak ri xecojon che ri Dios, ri e cäminak chic, xec'astaj chquixol ri cäminakib. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ri e are' xebel bi pa ri qui jul aretak c'astajinak chi ri Jesús chquixol ri cäminakib, xeboc c'u pa ri lok'alaj tinimit Jerusalén. Chila' c'ut q'uia winak xeilowic. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Are c'u ri qui nimal soldados aj Roma xukuje' ri soldados ri e c'o ruc' ri qui chajim ri Jesús, aretak xquina' ri cäbrakan xukuje' xquil ronojel ri xc'ulmatajic, sibalaj xquixej quib, xquibij: ¡Kas tzij, u C'ojol ri Dios wa' we achi ri'! —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","E c'o c'u q'uia ixokib chila' ri tajin queca'y apan chinaj. We ixokib ri' xeteri ruc' ri Jesús, xepe ruc' pa Galilea, xetob c'u che. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Chquixol c'u ri e are' c'o ri nan María ri aj Magdala, ri María ru nan ri Jacobo, ri José, xukuje' ri qui nan ru c'ojol ri Zebedeo. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Aretak oquem cuban ri ak'ab, xpe jun k'inom achi, José u bi'. Are aj Arimatea, jun u tijoxel c'u ri Jesús wa'. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Xoc cho ri tat Pilato, xuta' ru cuerpo ri Jesús che. Xtakan c'u ri tat Pilato chi cäyi' che. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ri tat José xuc'am ru cuerpo ri Jesús, xupis chupam jun sakalaj payu'. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Xuya pa jun c'ac' mukubal ri rech ri are', ri c'otom cok pa ri abaj. Xuwolkotij c'u can jun abaj chuchi' ri mukubal che tz'apibal re, te c'u ri' xe'c. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","C'o c'u ri nan María ri aj Magdala chila' rachi'l ri jun María chic. E t'uyul chuwäch ri xmuk wi ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Chucab k'ij chic, ya oc'owinak chi ri k'ij aretak ri winak aj Israel cäca'n u banic ronojel che ri k'ij re uxlanem, ri qui nimakil ri sacerdotes cuc' ri tata'ib fariseos xebe' ruc' ri tat Pilato. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Xquibij c'u che: Tat, xna'taj chke chi ri Jesús ri q'uia banow tak tzij xubano, aretak c'asal na xubij chi churox k'ij cäc'astaj na chquixol ri cäminakib. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Rumal ri' takan la chuchajixic ri mukubal c'ä cätz'akat na ri oxib k'ij, rech man quepe tä ru tijoxelab che relak'axic bi ru cuerpo, te c'u ri' cäquibij ta c'u chque ri winak: “Xc'astaj ri Jesús chquixol ri cäminakib,” —mecha'. We je ri' are jun banow tzij ri' ri sibalaj nim na chuwäch ri nabe, —xecha che ri tat Pilato. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ri tat Pilato xubij chque: Chic'ama bi we soldados ri' iwuc'. Jix, jichajij ri mukubal. Utz chibana che, jas ri quixcowin che, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Xebe' c'ut, utz xca'n che ri mukubal. Xquicoj jun retal chrij ri abaj ri cojom chuchi'. Xequiya c'u can ri soldados chila' chuchajixic ri mukubal. ");
INSERT INTO qucTNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Oc'owinak chi c'u ri k'ij re uxlanem, sakirem cuban pa ri nabe k'ij re ri semana. Ri nan María ri aj Magdala rachi'l ri jun María chic xebe' che rilic ri mukubal. ");
INSERT INTO qucTNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Xak c'u te'talic xpe jun nimalaj cäbrakan. Are jun ángel ri takom lok rumal ri Dios xkaj lok chicaj, xopan chila' jawije' ri mukutal wi ri Jesús. Xresaj apan ri abaj ri tz'apibal re ru chi' ri mukubal, te c'u ri' xt'uyi puwi'. ");
INSERT INTO qucTNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ri ángel sibalaj cäjuluwic jas ri jun caypa'. Ri ratz'iak sibalaj sak je' jas ri sak tew. ");
INSERT INTO qucTNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Aretak xquil wa' ri soldados, sibalaj xquixej quib, xebirbitic, pac'alic xekajic je' ta ne ri xecämic. ");
INSERT INTO qucTNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ri ángel xubij chque ri ixokib: Mixej iwib. Wetam chi are tajin quitzucuj ri Jesús ri xrip cho ri cruz, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Man c'o tä chi waral, xane c'astajinak chi bi chquixol ri cäminakib jas ri xubij. Jiwilampe' jawije' ri xyi' wi. ");
INSERT INTO qucTNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Jix ba' aninak. Chibij wa' chque ru tijoxelab: “Ri Are' xcäm na, xc'astaj c'u bi chquixol ri cäminakib. Nabejinak chiwäch, benam re pa Galilea. Chila' c'ut quiwil wi na u wäch.” Are wa' ri nu tajquil iwuc', —xcha ri ángel chque ri ixokib. ");
INSERT INTO qucTNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Chanim c'ut xebel bi ri ixokib chi' ri mukubal, jubik' quixe'm quib, jubik' quequicotic. Aninak xebe' chubixic wa' chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Benam c'u que pa ri be aretak ri Jesús xuc'ut rib chquiwäch, xuya c'u rutzil qui wäch. Ri ixokib xekeb ruc' ri Jesús, xquik'ijilaj, xquichap c'u ri rakan. ");
INSERT INTO qucTNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ri Jesús xubij chque: Mixej iwib. Jibij chque ri wachalal chi rajwaxic quebe' pa Galilea. Cäquil c'u na nu wäch chila', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","E benak ri ixokib pa ri be, jujun chque ri soldados ri xechajin ri mukubal xebe' pa ri tinimit Jerusalén, xequibij c'u chque ri qui nimakil ri sacerdotes ri xc'ulmatajic. ");
INSERT INTO qucTNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Are c'u ri qui nimakil ri sacerdotes xebe' cuc' ri qui nimakil ri winak aj Israel, rech cäjunamataj qui tzij. Xquiya c'u nimak tak puak chque ri soldados che tojbal que. ");
INSERT INTO qucTNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Xquibij c'u chque: Chibij ix chi chak'ab aretak tajin quixwaric xepe ru tijoxelab ri Jesús, xquelak'aj bi ru cuerpo, —quixcha na. ");
INSERT INTO qucTNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","We c'u copan u bixic wa' ruc' ri k'atal tzij, ri uj cujtob na chubixic che chi kas tzij rech man c'o tä c'äx quiriko, —xecha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Xquic'am c'u ri puak ri soldados, je' xca'no jas ri xbix chque. Je wa' xel u tzijol chquixol ri winak aj Israel, je c'u wa' cäquitzijoj c'ä we cämic ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Xebe' c'u ri julajuj u tijoxelab ri Jesús pa Galilea, pa ri juyub ri xubij ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Aretak xquil u wäch ri Jesús, xquik'ijilaj. E c'o c'u jujun ri xuban quieb qui c'ux chrij. ");
INSERT INTO qucTNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Xkeb c'u ri Jesús cuc' ru tijoxelab, xubij chque: Chwe in yo'm wi ronojel takanic pa ri caj, xukuje' pa qui wi' ri winak cho ruwächulew, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jix ba' cuc' conojel qui wäch winak cho ruwächulew, chibana' chi queboc che nu tijoxelab. Chibana qui kasna' pa ru bi' ri ka Tat, pa ru bi' ru C'ojol, pa ru bi' ri Lok'alaj Espíritu. ");
INSERT INTO qucTNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Cheitijoj chunimaxic ronojel ri ix nu takom wi. Chiwetamaj c'ut chi ri in, in c'o iwuc' ronojel k'ij, c'ä pa ri q'uisbal k'ij re ruwächulew, —xcha ri Jesús chque ru tijoxelab. Amén.");
INSERT INTO qucTNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Je' u chaplexic wa' ri Utzalaj Tzij re ri Evangelio chrij ri Jesucristo ri u C'ojol ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Je wa' ri xtz'ibax can ojer chrij ri Cristo rumal ri ka mam Isaías ri k'alajisal re ru Lok' Pixab ri Dios, cubij: ¡Chiwilampe'! —xcha ri Dios chque ri winak. Xubij c'u che ru C'ojol: Ri in quintak bi ri nu tako'n, cänabej c'u na chawäch, cuban na u banic ra be, —xcha ri Dios che. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","C'o jun ri co cäch'aw pa tak juyub ri cätz'inowic, cubij: “Chibana u banic ri nim be ri cäbin wi ri Kajaw, chisuc'umaj, chibana c'u sibalaj jicom che ru be,” —cächa', —xcha ri ka mam Isaías. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Je wa' ri' xpe ri tat Juan. Are c'u tajin cuban qui kasna' ri winak pa tak juyub ri cätz'inowic. Cutzijoj c'u chque chi rajwaxic cäquiq'uex canima', cäquiq'uex qui chomanic, te c'u ri' cäban qui kasna' rech cäk'alajinic chi je' qui banom wa'. Xa je ri' cäsachtaj tak ri qui mac. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Xepe c'u conojel ri winak aj Jerusalén, xukuje' ri e c'o pa tak ri niq'uiaj tinimit chic re Judea, xeopan ruc' ri tat Juan chutatabexic ri cubij. Aretak cäquik'alajisaj ri qui mac, cäban c'u qui kasna' rumal ri tat Juan pa ri nima' Jordán. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Are c'u ri tat Juan cucoj atz'iak ri banom ruc' ri rismal jun awaj camello u bi', tz'um ru pas. Xa sac' xukuje' u wa'l che' cutijo. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Cätzijon c'u ri tat Juan, cubij chque ri winak: Cäpe chi na Jun ri kas nim u k'ij, nim c'u na u banic chnuwäch in. Man takal tä chwe in quinpachi'c quinquir ru c'amal u xajäb, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Kas tzij ri in nu banom kasna' alak ruc' joron, ri Are' c'ut cuban na kasna' alak ruc' ri Lok'alaj Espíritu rech ri Dios, —xcha chque ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Pa tak ri k'ij ri' xpe ri Jesús pa ri tinimit Nazaret re Galilea, xopan ruc' ri tat Juan. Xban u kasna' rumal ri tat Juan pa ri nima' Jordán. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Te c'u ri' aretak tajin quel lok ri Jesús pa ri ja', chanim xril ri caj tajin cäjakjobic, xukuje' xril ri Lok'alaj Espíritu tajin cäkaj lok puwi', je' ru banic jun palomäx. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Te c'u ri' xch'aw lok jun chicaj, xubij: At ri' ri lok'alaj nu C'ojol. Cäquicot c'u ri wanima' awumal, —xcha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Te c'u ri' ri Lok'alaj Espíritu xuc'am bi ri Jesús pa tak juyub ri cätz'inowic. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Xc'oji c'u chila' cawinak k'ij chquixol ri awaj aj pa tak juyub. Cätakchi'x ri Jesús che mac rumal ri Satanás. Xepe c'u ri ángeles chupatänixic. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Mäja' naj cojom ri tat Juan pa che' aretak ri Jesús xopan pa Galilea. Cutzijoj ri Utzalaj Tzij re ri Evangelio chrij ru takanic ri Dios pa qui wi' ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Xubij c'u ri Jesús chque: Xopan ri k'ij, xa jubik' chic man cuchaplej ru takanic ri Dios. Q'uexa anima' alak, q'uexa ba' alak ri chomanic alak, cojon c'u alak che ri Utzalaj Tzij re ri Evangelio, —xcha chque ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Oc'owem cuban ri Jesús chuchi' ri mar re Galilea, xril ri tat Simón rachi'l ri tat Andrés ru chak'. Tajin cäquiq'uiäk bi jun c'at chapäbal tak cär pa ri mar rumal chi e chapal tak cär ri e are'. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Xubij c'u ri Jesús chque: Chixsa'j wuc'. Quinban c'u na chiwe chi quixoc che qui mulixic winak chuq'uexwäch ri cär, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Chanim xequiya can ri qui c'at, xebe' ruc' ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Xbin chi c'u apan jubik' ri Jesús, xril ri tat Jacobo rachi'l ri tat Juan ru chak', e u c'ojol ri tat Zebedeo wa'. E c'o pa ri qui barco, quequic'ojoj c'u ri qui c'at. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Xeusiq'uij ri Jesús. Ri e are' c'ut chanim xquiya can ri Zebedeo ri qui tat pa ri barco cuc' ri ajchaquib, xebe' c'u ruc' ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Xeopan c'u pa ri tinimit Capernaum. Are c'u pa ri k'ij re uxlanem xoc ri Jesús pa ri rachoch Dios, xuchap qui tijoxic ri winak chila'. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ri winak c'ut sibalaj cäquicajmaj ru tijonic ri Jesús rumal chi queutijoj je' jas jun achi ri c'o u takanic pa qui wi', man junam taj jas ri cäca'n ri tijonelab re ri Pixab. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Xoc c'u bi pa ri rachoch Dios jun achi ri c'o jun itzelalaj espíritu che. Are chi' ri tajin cäch'aw ri Jesús, ri achi xurak u chi', ");
INSERT INTO qucTNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","xubij: ¡Aa! ¿Jas caj la chke uj, Jesús aj Nazaret? —cächa ri'. ¿A xa petinak la chusachic ka wäch? In wetam wäch la, chi lal ri' ri lok'alaj achi takom lok rumal ri Dios, —xcha che ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Are c'u ri Jesús xuyajo, xubij che: ¡Chatz'apij u pa chi', chatel che we achi ri'! —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ri itzelalaj espíritu xuban che ri achi chi xtzakic, xuyacya rib, co xurak u chi', xel bi che. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Conojel c'ut xquicajmaj wa', xquichapla u tzijobexic quib, xquibij: ¿Jas wa'? ¡Jun c'ac' tijonic ne lo wa'! We achi ri' yo'm pu k'ab queutak ri itzelalaj tak espíritus, queniman c'u che, —xecha ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Chanim c'ut ri tajin cäban rumal ri Jesús xel u tzijol wa' pa tak conojel ri tinimit ri e c'o pa Galilea, xukuje' pa tak ri tinimit ri nakaj e c'o wi che ri Galilea. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Aretak ri Jesús xel bi pa ri rachoch Dios, xe' chanim cho rachoch ri tat Simón, ri tat Andrés, e rachi'l c'u ri tat Jacobo, ri tat Juan. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Are c'u ru ji' chichu' ri tat Simón kajinak che jun nimalaj k'ak'. Chanim c'ut xquitzijoj wa' che ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ri Jesús xkeb ruc' ri chichu', xuchap che ru k'ab, xuwalijisaj c'ut. Chanim xtäni ri k'ak' chrij ri chichu'. Xuchap c'u ri qui patänixic. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Aretak xk'ekal chic, kajem cuban ri k'ij, xequic'am bi conojel ri yawabib cho ri Jesús, xukuje' conojel ri e c'o itzel tak espíritus chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Conojel ri winak ri quebel pa ri tinimit Capernaum xquimulij quib chi' ri ja, rachoch ri tat Simón. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ri Jesús xeucunaj q'uia yawabib ri e c'o q'uia u wäch yabil chque, xukuje' xeresaj bi q'uia itzel tak espíritus chque ri winak. Man cuya tä c'u ri Jesús chque ri itzel tak espíritus chi quech'awic, rumal chi quetam u wäch. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Sibalaj ak'ab c'ut xwalij ri Jesús, c'ä mäjok cäsakiric. Xel bic, xe' pa ri juyub ri cätz'inowic, xuban c'u orar chila'. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Are c'u ri tat Simón, xukuje' ri e c'o ruc' xebe'c, xquitzucuj ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Aretak xquiriko, xquibij che: Conojel ri winak quetzucun che la, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Xubij c'u ri Jesús chque: Jo' pa ri jule' tak tinimit chic ri e c'o chkanakaj, rech chila' xukuje' quintzijon wi. Che c'u wa' in elinak wi lok, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ri Jesús cusolij c'u tak ri tinimit pa ronojel Galilea. Pa tak ri rachoch Dios ri cäquimulij wi quib ri winak, cutzijoj ri Utzalaj Tzij re ri Evangelio chrij ru takanic ri Dios pa qui wi' ri winak, xukuje' queresaj bi itzel tak espíritus chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Xopan c'u ruc' ri Jesús jun achi ri c'o itzel ch'a'c che. Xuchap u bochi'xic ri Jesús, xxuqui'c, xubij che: Tat, ri in wetam chi ri lal cäcowin la che nu cunaxic we caj la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Xel c'u u c'ux ri Jesús che. Xuyuk ru k'ab, xuchap cok ri achi, xubij che: Cwaj, —cächa'. Chutzir ba' la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Xuwi wa' xubij, chanim xel ri itzel ch'a'c che ri achi, xutziric. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ri Jesús sibalaj xupixbaj ri achi c'ä mäja' cutak bic, ");
INSERT INTO qucTNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","xubij bi che: ¡Tampe la! C'o jas mäbij la che jachin jun. Oj la, jec'utu ib la cho ri sacerdote. Ya la ri sipanic ri takom can rumal ri ka mam Moisés ojer chi cäyi'c aretak cäcunataj jun ri c'o itzel ch'a'c che. Are c'u k'alajisabal wa' chquiwäch ri winak, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Xel c'u bi ri achi, sibalaj cutzijoj ri xban che. Xresaj c'u u tzijoxic wa', je c'u ri' chi ri Jesús man cäcowin tä chic coc chi sakil pa tak ri tinimit. Xane xak pa tak juyub ri cätz'inowic cäc'oji wi ri Are'. Quepe c'u ri winak pa ronojel tinimit, queopan ruc' ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Xopan jumul chic ri Jesús pa ri tinimit Capernaum. Xque' c'u quieb oxib k'ij, xtatajic chi c'o chi cho ja. ");
INSERT INTO qucTNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Chanim c'ut xquimulij quib q'uia winak, je ri' chi man c'o tä chi jawije' quec'oji wi, pune ta ne xa chuchi' ri ja. Are c'u ri Jesús cutzijoj ru Lok' Pixab ri Dios chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Xeopan c'u quiejeb achijab ruc' ri Jesús, qui telem jun achi ri cäminak u cuerpo. ");
INSERT INTO qucTNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Man quecowin tä c'ut queboc chuwäch ri Jesús, qui mac ri sibalaj q'uia winak. Xquesaj c'u apan ru xo'til ri ja. Xquic'ot jun jul puwi' ri ja chusiq'uel ri c'o wi ri Jesús, xquikasaj c'u bi ri alaj ch'at ri k'oyol wi ri cäminak u cuerpo. ");
INSERT INTO qucTNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Aretak ri Jesús xrilo chi sibalaj quecojon che, xubij che ri achi ri cäminak u cuerpo: Tat, ¡xesachtaj ri mac la! —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","E t'uyul c'u chila' jujun chque ri tijonelab re ri Pixab, tajin quechomanic, quetzijon c'u pa canima', ");
INSERT INTO qucTNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","cäquibij: “¿Jas che je' cätzijon wa' we achi ri'? Cubij ri sibalaj äwas u bixic,” —quecha'. “¿Jachin ta lo ri cäcowin chusachic mac xane xak xuwi ri Dios?” —xecha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Chanim xuna' wa' ri Jesús pa ranima', ya retam chic jas ri tajin cäquichomaj, xubij c'u chque: ¿Jas che je' cächomaj alak wa' pa anima' alak? —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Jachique ri man c'äx tä u bixic che ri achi, ri u bixic: “Ri mac la xesachtajic”, o ri u bixic: “Walij ba' la, c'ama la bi ri soc la, bin ba' la”? —cächa ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Rech ba' quetamaj alak chi ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak, c'o nu takanic pa qui wi' ri winak cho ruwächulew, xukuje' rech quetamaj alak chi ya'tal chwe in chi quinsach ri qui mac, ¡tampe alak ri quinbij! —xcha chque. Xubij c'u ri Jesús che ri achi ri cäminak u cuerpo: ");
INSERT INTO qucTNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Quinbij che la, ¡walij ba' la! Oj la cho ja, c'ama la bi ri soc la, —xcha ri Jesús che ri achi. ");
INSERT INTO qucTNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Chanim xwalij ri achi, xutelej bi ri alaj u ch'at. Xel bi chquiwäch conojel, je ri' chi conojel xquicajmaj ri xbantajic, xquinimarisaj u k'ij ri Dios, xquibij: ¡Man c'o tä jumul ri je' kilom wa'! —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ri Jesús xe' chi jumul chuchi' ri mar, sibalaj e q'uia c'u ri winak ri xeopan ruc'. Are c'u ri Are' xeutijoj che ru Lok' Pixab ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Oc'owem cuban ri Jesús jawije' ri cätoj wi ri alcabal, xril c'u ri tat Leví, u c'ojol ri tat Alfeo, t'uyul chila'. Xubij c'u che: Sa'j la wuc', —xcha che. Xwalij c'u ri tat Leví, xe' ruc' ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pa jun k'ij c'ut t'uyul ri Jesús chi' ri mesa cho rachoch ri tat Leví e rachi'l ru tijoxelab. E q'uia c'u ri tok'il tak alcabal, xukuje' niq'uiaj ajmaquib e t'uyut'oj chi' ri mesa ruc' ri Jesús, cuc' ru tijoxelab. E q'uia c'u ri winak e tereninak lok. ");
INSERT INTO qucTNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Xepe c'u ri tata'ib fariseos, xukuje' ri tijonelab re ri Pixab. Xquilo chi ri Jesús tajin cäwi' cuc' tok'il tak alcabal xukuje' niq'uiaj ajmaquib chic, xquita' c'u chque ru tijoxelab, xquibij: ¿Jas che cäwi' ri Jesús cuc' tok'il tak alcabal xukuje' niq'uiaj ajmaquib chic? —xecha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Aretak xuta ri Jesús wa', xubij chque: Ri winak ri utz qui wäch, ri c'o qui chuk'ab, man rajwaxic tä cunal que, xane are rajwaxic wa' chque ri yawabib, —cächa chque. Man in petinak tä che qui siq'uixic ri winak ri jicom canima' cho ri Dios, xane in petinak che qui siq'uixic ri ajmaquib ri mäja' cäquiq'uex canima', mäja' cäquiq'uex qui chomanic, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Pa jun k'ij ri' tajin cäca'n ayunar ru tijoxelab ri Juan Kasal Ja' xukuje' ri qui tijoxelab ri tata'ib fariseos. E c'o c'u jujun winak xeopan ruc' ri Jesús, xquibij che: Ru tijoxelab ri tat Juan xukuje' ri qui tijoxelab ri tata'ib fariseos cäca'n ayunar. ¿Jas c'u che man cäca'n tä ayunar ri tijoxelab la? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Xch'aw c'u ri Jesús, xubij chque: ¿A cuya' ne lo cäca'n ayunar ri e c'o pa jun c'ulanem aretak ri achi ri te' xc'uli'c c'o can cuc'? Aretak c'o ri achi ri' cuc' man cuya' taj cäca'n ayunar, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Copan c'u na ri k'ij aretak quesax bi ri achi chquixol. Te c'u ri' cäca'n na ayunar pa ri k'ij ri', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Xukuje' xubij ri Jesús: Man c'o tä jun winak ri cut'is jun pimalaj c'ojobal chrij jun k'el atz'iak. We ta je ri', ri c'ac' atz'iak cuc'ol rib, cäresaj bi jubik' che ri k'el atz'iak, cänimar c'u ru tek'tobic, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Man c'o tä jun ri cuya c'ac' vino pa tak k'el tak k'ebal re tz'um. We ta je ri', ri vino queut'ubij ri' ri tz'um, quetzeletaj c'u na can ri vino xukuje' tak ri tz'um. Rajwaxic c'ut chi ri c'ac' vino cäyi' pa tak c'ac' tak k'ebal re tz'um, —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Pa jun k'ij re uxlanem oc'owem re ri Jesús pa tak ri tico'n. Are chi' ri tajin quebin ru tijoxelab ruc', xquichaplej qui ch'upic ru jolom tak ri trico. ");
INSERT INTO qucTNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ri tata'ib fariseos xquibij che ri Jesús: ¡Chilampe la! ¿Jas che ri tijoxelab la cäca'n chac ri äwas u banic pa tak ri k'ij re uxlanem? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Xubij c'u ri Jesús chque: ¿A man c'o tä jumul ri siq'uim alak ri xuban ri ka mam David ojer aretak ri c'o rajwaxic che, xuna' numic, xukuje' ri xca'n ri e c'o ruc'? ");
INSERT INTO qucTNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Xoc c'u bi ri ka mam David pa ri rachoch Dios aretak ri tat Abiatar are qui nimal sacerdotes, xutij c'u re ri wa ri yo'm cho ri Dios, xuya c'u que ri e c'o ruc' xukuje'. Äwas c'u u tijic wa' cumal xak jachinok, xane xak xuwi chque ri sacerdotes ya'tal wi wa', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Xukuje' xubij ri Jesús chque: Ri k'ij re uxlanem xbantaj wa' ojer rech ri winak cäquirik utzil rumal, man xeban tä c'u ri winak rech cäca'n jun utzil che ri k'ij re uxlanem. ");
INSERT INTO qucTNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Je c'u ri' ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak, c'o nu takanic puwi' ri k'ij re uxlanem xukuje', —xcha ri Jesús chque ri tata'ib fariseos. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Xoc chi jumul ri Jesús pa ri rachoch Dios, c'o c'u jun achi chila' ri cäminak jun u k'ab. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Caluchi'x c'u ri Jesús cumal jujun tata'ib che rilic we cärutzirisaj ru k'ab ri achi pa ri k'ij re uxlanem rech cuya' cäquibij chi c'o u mac ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Xubij c'u ri Jesús che ri achi ri cäminak jun u k'ab: ¡Walij ba' la! ¡Tac'al la chkawäch! —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Xubij c'u ri Jesús chque ri achijab ri tajin cäcaluchi'j: ¿Jachique ri man äwas tä u banic pa ri k'ij re uxlanem, ri u banic utzil o ri u banic etzelal? ¿A utz ru to'ic ru c'aslemal jun winak o ru cämisaxic wa'? —xcha chque. Man xech'aw tä c'u ri tata'ib. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Xpe royowal ri Jesús chque ri achijab ri', queuca'yej conojel ri e c'o pa tak u xcut, cubisoj qui wäch rumal chi sibalaj abajarinak ri canima'. Xubij c'u che ri achi: ¡Yuku ri k'ab la! —xcha che. Xuyuk c'ut, xutzir c'u ru k'ab. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Xebel c'u bi ri tata'ib fariseos, chanim xquirik quib cuc' ri rachi'l ri tat Herodes, xquitala' qui no'j chbil tak quib jas ri cäca'n chucämisaxic ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Are c'u ri Jesús xe' apan chquiwäch ri winak chuchi' ri mar, e rachi'l c'u ru tijoxelab. Sibalaj e q'uia ri winak aj Galilea ri xeteri bi chrij. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Xukuje' e q'uia ri winak aj Judea xepetic. E c'o ri aj Jerusalén, xukuje' ri quepe pa Idumea. Niq'uiaj quepe ch'äkäp che ri nima' Jordán, xukuje' pa tak ri tinimit Tiro, ri tinimit Sidón. Xa rumal chi xquita u tzijol ronojel ri tajin cuban ri Jesús, xeopan c'u ruc'. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Xubij c'u ri Jesús chque ru tijoxelab chi xak chc'ol jun barco ri cäc'oji wi ri Are', rech man cäpitz' tä cumal ri q'uialaj winak. Je' xca'no. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Are ri Jesús xeucunaj q'uia winak, je ri' chi conojel ri yawabib cäquich'iquimij quib chrij ri Jesús rech cäquichap cok. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ri winak ri e c'o itzelalaj tak espíritus chque, aretak xquil ri Jesús, xetzak c'u chuwäch, xquirak qui chi', xquibij: ¡Lal ri' ri u C'ojol ri Dios! —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ri Jesús sibalaj xeupixbaj ri itzelalaj tak espíritus chi mäquibij jachin ri Are'. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Xpaki c'u ri Jesús puwi' jun juyub. Are c'u chila' ri xeusiq'uij wi jachin tak ri xraj xeucha'. Xeopan c'u ruc'. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Xeucoj c'u cablajuj achijab rech quec'oji ruc', rech queutak bi chutzijoxic ru Lok' Pixab ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Xukuje' xuya chque chi cäc'oji qui cuinem che qui cunaxic ri yawabib, xukuje' xuya takanic pa qui k'ab che quesaxic bi ri itzel tak espíritus chque ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","E are c'u wa' ri cablajuj ri xeucha' ri Jesús: ri tat Simón ri cäbix Pedro che rumal ri Jesús, ");
INSERT INTO qucTNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ri tat Jacobo u c'ojol ri tat Zebedeo, xukuje' ri tat Juan ru chak' ri tat Jacobo. E are' wa' ri xcoj Boanerges che qui bi' rumal ri Jesús. Ri bi'aj ri' quel cubij chi e junam ruc' ri quiäkul ja. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Xeucha' xukuje' ri tat Andrés, ri tat Felipe, ri tat Bartolomé, ri tat Mateo, ri tat Tomás, ri tat Jacobo u c'ojol ri tat Alfeo, ri tat Tadeo, ri tat Simón ri cäbix “u nimal tinimit” che. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ri tat Judas Iscariote, ri xjachow ri Jesús, xukuje' xcha'ic rumal. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Te c'u ri' xe' ri Jesús cho ja. Jumul chic xquimulij quib q'uia winak, je ri' chi ri Jesús e rachi'l ru tijoxelab man quecowin tä ne quewi'c. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Aretak ri rachalal ri Jesús xquito chi c'o chila', xebe' chuchapic. ¡Xquibij c'ut chi ch'ujarinak ri Are'! ");
INSERT INTO qucTNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ri tijonelab re ri Pixab c'ut, ri e petinak pa Jerusalén, cäquibij chi c'o ri Beelzebú ruc' ri Jesús. (Ri Beelzebú are qui nimal ri itzel tak espíritus.) Cäquibij chi xa rumal wa' ri Jesús cäcowin che quesax bi ri itzel tak espíritus, —quecha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ri Jesús c'ut xeusiq'uij ri winak, xucoj jun c'utbal chquiwäch, xubij: ¿Jas ta c'u lo cuban ri Satanás che resaxic bi rib? —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","We jun k'atbal tzij u banom quieb, ri juch'ob k'atal tak tzij cuyac rib chrij ri juch'ob chic, cuq'uis na u wäch ri k'atbal tzij ri' chbil rib. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Xukuje' we jun achalaxic u banom quieb, ri juch'ob cuyac rib chrij ri juch'ob chic, cuq'uis c'u na u wäch ri achalaxic ri' chbil rib, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","We ta u banom quieb ri Satanás, cuyac c'u rib chrij chbil rib, man cäcowin tä ri' chujekbaxic rib, xane cuq'uis c'u na rib ri are', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Man c'o tä jun cäcowinic coc pa ri rachoch jun achi ri sibalaj c'o u chuk'ab, querelak'aj bi ri jastak re, we ta mat nabe cuyut na ri achi ri c'o u chuk'ab, c'ä te c'u ri' cäcowinic querelak'aj bi ri c'o pa rachoch, —cächa ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Kas tzij quinbij chech alak chi conojel ri mac ri cäca'n ri winak cuya' quesachtaj na wa', xukuje' apachique ta ne ri äwas u bixic chrij ri Dios, ri cäquibij ri winak, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Apachin c'u ri cubij ri äwas u bixic chrij ri Lok'alaj Espíritu, man cäsachtaj tä u mac ri' pa tak ri k'ij ri quepe na, rumal chi u banom jun mac ri man cuya' taj cäsachtajic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ri Jesús xubij wa' rumal chi ri winak xquibij: C'o jun itzelalaj espíritu che ri Are', —xecha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Xopan c'u ru nan ri Jesús ruc', xukuje' tak ru chak'. Ri e are' c'ut xa e tac'atoj apan chrij ri ja, xetakan c'u chusiq'uixic ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","E q'uia c'u ri winak ri qui sutim rij ri Jesús, xquibij che ri Are': Ri nan la xukuje' tak ri chak' la xak e c'o apan cho ja, quetzucun che la, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Xch'aw ri Jesús, xubij chque: ¿Jachin ri nu nan, jachin c'u tak ri kas nu chak'? —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Xeuca'yej ri e t'uyut'oj pa tak u xcut, xubij: Cheiwilampe ri nu nan, xukuje' tak ri nu chak'. ");
INSERT INTO qucTNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Apachin ta ne ri cäbanow ru rayinic ri Dios, e are wa' ri kas wachalal, ri nu chak', ri wanab, ri nu nan, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ri Jesús xuchaplej chi na jumul qui tijoxic ri winak chuchi' ri mar. Xquimulij c'u quib q'uialaj winak ruc', je ri' chi xoc bi pa jun barco puwi' ri mar, xt'uyi c'u chupam. Conojel ri winak xecanaj can cho ri ulew chuchi' ri mar. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Xeucoj c'u tak c'utbal che qui tijoxic ri winak chquij q'uia u wäch tak no'j, xubij chque: ");
INSERT INTO qucTNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","¡Tampe alak! —cächa'. Xel bi jun ticol ija' cho rachoch, xe'c, xubana u tico'n. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Aretak tajin cujopij ri ija', xkaj jubik' pa ri be. Xeopan c'u ri chicop, querapapic quekajic, xa xquitij bi ri ija'. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Xkaj chi jubik' xol tak ri abaj, ri man c'o tä wi q'uia ulew. Chanim c'ut xq'uiy ri jubik' ija' ri' rumal chi man pim tä ri ulew. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Aretak c'ut xel lok ri k'ij, xec'at ri alaj tak tico'n, xechaki'jic rumal chi c'ä mäja' nim qui xera'. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Xkaj chi c'u jubik' ri ija' pa tak ri k'ayes ri c'o qui q'uixol. Xq'uiy c'u ri k'ayes ri', xujik'isaj ri tico'n, je ri' chi man xwächin taj. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Are c'u ri niq'uiaj ija' chic xekaj pa utzalaj ulew. Xebel lok ri tux, xeq'uiyic, xewächinic. E c'o jujun tico'n xquiya juwinak lajuj qui wäch chupam ru jolom trico chquijujunal, e c'o jule' chic ri xquiya oxc'al qui wäch chupam ru jolom chquijujunal. Ri niq'uiaj tico'n chic xquiya jun ciento qui wäch chupam ru jolom chquijujunal, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Te c'u ri' xubij chque ri winak: We c'o jun ri cujiquiba ranima' chutatabexic ri nu tzij, ¡chutatabej ba'! —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Aretak ri Jesús xak u tuquiel chic c'olic, xeopan jujun chque ri winak ruc', cachi'l ri cablajuj u tijoxelab. Xquita' c'u che jas quel cubij ri c'utbal ri xutzijoj chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Xch'aw c'u ri Jesús, xubij: Ri ix, yo'm chiwe rumal ri Dios ri retamaxic ri man quetam tä ri niq'uiaj winak chic chrij ru takanic ri Dios pa qui wi' ri winak. Are cätzijox c'u wa' chque ri jule' winak chic xa cuc' tak c'utbal. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Je ri', rumal chi pune jakal ri qui wak'äch, man quecowin tä chuch'obic ri cäquilo. Pune c'u cäquitatabej na ri kas tzij, man cäquich'ob tä ri' ri qui tatabem, rech man cäquitzelej tä quib ruc' ri Dios, man cäsachtaj tä qui mac, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Xubij chi c'u ri Jesús chque: ¿A mat lo quich'ob ri quel cubij wa' we c'utbal ri' ri xintzijoj chiwe? ¿Jas c'u quiwetamabej tak que conojel ri niq'uiaj tak c'utbal chic ri queintzijoj na chiwe? —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ri ticol ija' are junam ruc' ri winak ri cutzijoj ru Lok' Pixab ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ri ija' ri xekaj pa ri be, e are c'u wa' jas ri winak ri cätic ru Tzij ri Dios pa canima', cäquita c'u ri Tzij, chanim c'ut cäpe ri Satanás, cäresaj ri Tzij ri xkaj pa canima'. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Junam xukuje' ri ija' ri xekaj xol tak ri abaj. E are wa' jas ri winak ri cäquita ru Tzij ri Dios ruc' quicotemal, je'l cäquito. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Man kas tä c'u c'o ri qui xera', xane xak quieb oxib k'ij cäquich'ijo. Aretak cäquichaplej u rikic c'äx, craj queyok'ic rumal rech ru Tzij ri Dios, chanim quetzak canok. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ri jule' ija' chic ri xkaj pa tak k'ayes ri c'o qui q'uixol, e are wa' jas ri winak ri cäquita ru Tzij ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Te c'u ri' are quequilij na ri jastak re we uwächulew ri', quesub rumal ri k'inomal, xukuje' cäquirayij q'uia u wäch jastak chic, que' c'u canima' cuc'. Rumal c'u wa' cäjik'isax ri Tzij pa canima', man cäwächin tä c'u ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ri ija' ri xekaj pa utzalaj ulew, e are c'u wa' jas ri winak ri cäquita ru Tzij ri Dios, cäquic'amowaj, cäkaj wa' pa canima', cäquiya c'u q'uia qui wäch. Jujun cäquiya juwinak lajuj qui wäch chquijujunal, jule' chic cäquiya oxc'al qui wäch chquijujunal, ri niq'uiaj chic cäquiya jun ciento qui wäch chquijujunal, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Xukuje' xubij ri Jesús chque: ¿A cätzij lo jun chäj pa ri ja, te c'u ri' cäyi' wa' chuxe' jun lak, o cäyi' chuxe' ri ch'at? Man je' tä ri', xane cäyi' wa' chicaj rech k'alaj ronojel, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Man c'o tä jas ri ch'uktal u wi' ri mat cäk'alajin na. Man c'o tä jas ri c'u'talic ri mat quel na chi sak, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","We c'o jun ri cujiquiba ranima' chutatabexic ri nu tzij, ¡chutatabej ba'! —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Xukuje' xubij ri Jesús chque: ¡Chitampe ri tajin quinbij chiwe! —cächa'. Jas ri pajbal ri quicoj ix, are je' ri pajbal ri coc na chiwe ix, xukuje' cäyi' na u wi' chiwe ix ri quitatabej ri nu tzij. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Apachin c'u ri c'o c'o ruc', cäyi' chi na niq'uiaj che. Apachin c'u ri man c'o tä c'o ruc', quesax na che ri are' ri jubik' ri c'olic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Xubij chi c'u chque: Ru takanic ri Dios pa qui wi' ri winak, are jas jun achi ri cutic can ri ija' pa rulew. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Cäwar chak'ab, cäwalij c'ut. Cäc'astaj chi pak'ij. Je ri' queoc'ow tak ri k'ij, ri ak'ab. Cätux c'u ri ija' ri c'o pa ulew, cäq'uiyic. Man retam tä c'u ri achi jas cuban ri ija' cäq'uiyic. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tzpa re wi ri ulew cubano chi queq'uiy ri tico'n, quewächinic. Nabe quel lok ru tux, cäq'uiy c'u wa'. Te c'u ri' cäpe ru jolom ri trico. C'ä te ri' quechomakir ru jolom. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Aretak e chomak chic, chanim cäcoj ri ixjos chquixe' rumal chi chaki'j chic, xopan ri k'ij rech ri k'atoj, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Xubij chi ri Jesús: ¿Jas ruc' cäkajunamaj wi ru takanic ri Dios? ¿Jas u wäch c'utbal cäkacoj chuc'utic wa'? —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Are je' jas ri ija' re ri tico'n ri cäbix “mostaza” che. Aretak cätiquic, xa i nitz' wa' chquiwäch conojel ri ija' ri e c'o cho ruwächulew. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Aretak ticom chic, quel lok, nim na que' chquiwäch conojel tak ri niq'uiaj tico'n. Quenimakir tak ru k'ab, je ri' chi ri chicop ajuwocaj quecowinic cäca'n ri qui soc, quemu'jan chupam ri tico'n ri', —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Je wa' xuban ri Jesús che qui tijoxic ri winak. Xucoj q'uia tak c'utbal chquiwäch jas tak we ri' chutzijoxic ru Lok' Pixab ri Dios chque, xa jas ri quecowin chuch'obic. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Xak xuwi cuc' tak c'utbal xeutzijobej ri winak. Xuquir c'u ronojel wa' we tijonic ri' chquiwäch ru tijoxelab xak pa qui tuquiel wi. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Pa ri k'ij ri', aretak tajin coc ri ak'ab, xubij chque ru tijoxelab: Chujk'ax jela' ch'äkäp che ri mar, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Xequiya c'u can ri q'uia winak. Ri tijoxelab xquic'am bi ri Jesús pa ri barco. T'uyul c'u wi ri Are' chupam. Xcachi'laj c'u bi niq'uiaj tak barcos chic. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Xpe c'u jun nimalaj quiäkik' ri sibalaj c'äx puwi' ri ja'. Are c'u ri nimak tak uwoja' tajin queboc pa ri barco, je ri' chi tajin cänoj ri barco che ri ja'. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","C'o c'u ri Jesús pa ri barco pa ri cu'lbal chrij. Tajin cäwaric, u yo'm ru jolom puwi' jun ch'äcataj. Xepe ru tijoxelab, xquic'asuj, xquibij che: ¡Kajtij! ¿A mat cäxej ib la chke chi cujcämic? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Xc'astaj c'u ri Jesús, xuyaj ri quiäkik', xubij che ri mar: ¡Chattänalok! ¡Xak jun chatc'ol wi! —xcha che. Xtäni c'u ri quiäkik', xlilob c'u ronojel ru wi' ri mar. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Te c'u ri' xubij ri Jesús chque ri tijoxelab: ¿Jas che sibalaj quixej iwib? ¿A mat quixcojon che ri Dios? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Xquicajmaj c'u ri xuban ri Jesús, ¡sibalaj xquixej quib! Cäquibila' c'u chbil tak quib, cäquibij: ¿Jachin c'u lo we achi ri' chi ri quiäkik', xukuje' ri ja' re ri mar queniman che? —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Xeopan ch'äkäp che ri mar pa ri qui tinimit ri winak aj Gadara. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Aretak elem cuban ri Jesús pa ri barco, chanim xrik rumal jun achi ri c'o jun itzelalaj espíritu che. Elinak lok ri achi pa ri campo santo chquixol ri mukubal. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Chila' c'ut, xol tak ri mukubal, cäjeki wi. Man c'o tä jachin jun ri cowininak chuyukbaxic, pune xquixim na cuc' ximibal re ch'ich'. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Q'uia mul ximom cuc' chapbal akanaj, xukuje' cuc' ximibal re ch'ich'. Xeut'okopij c'u ri ximibal re ch'ich', xeupaxij ri chapbal akanaj. Man c'o tä jun ri c'o u chuk'ab chujekbaxic ri achi ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Chi chak'ab, chi pak'ij cäc'oji ri achi ri' xol tak ri mukubal xukuje' pa tak juyub, curak u chi', cusoc c'u rib cuc' tak abaj. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Aretak c'ut ri achi xril apan ri Jesús chinaj, xutic anim, xe' ruc', xxuqui chuwäch. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Xurak c'u u chi', co xch'awic, xubij: ¿Jas caj la chwe, Jesús, lal ri' ru C'ojol ri Nimalaj Dios aj Chicaj? Quinbochi'n che la cho ri Dios, chi mäban la c'äx chwe, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Xubij wa' rumal chi ri Jesús tajin cubij che: ¡Itzelalaj espíritu, chatel bi che ri achi! —cächa che. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Xuta' c'u ri Jesús che, xubij: ¿Jas ra bi'? —xcha che. Xubij c'u che ri Jesús: Ri nu bi' are Q'uiyal. Je wa' ri nu bi' rumal chi sibalaj uj q'uia, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Sibalaj xubochi'j ri Jesús chi mätakanic chi chebel bi pa ri tinimit ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","E sibalaj q'uia c'u ri ak ri tajin queyuk'ux apan chila' pa ri juyub ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ri itzelalaj tak espíritus tajin quebochi'n che ri Jesús, cäquibij: Chujtaka bi la cuc' ri ak rech cujoc bi chque, —quecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ri Jesús c'ut xuya chque chi je' cäca'no. Xebel c'u bi ri itzelalaj tak espíritus, xeboc bi chque ri ak. Conojel ri ak, craj e c'o quieb mil, xquiq'uiäk bi quib chutza'm ri juyub, xekaj c'u pa ri mar, xejik'ic. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","E are c'u ri ajyuk' tak ak xeanimajic, xebe'c. Xquiya u tzijol wa' pa ri tinimit, xukuje' pa tak ri juyub. Xepe c'u ri winak che rilic jas ri' ri xbantajic. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Aretak xeopan ruc' ri Jesús, xquil ri achi ri nabe xec'oji na q'uia itzelalaj tak espíritus che. T'uyul c'u ri achi chila', cojom chi ri ratz'iak, ulinak chi putzil. Xquixej c'u quib ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ri winak ri xquilo jas ri xban che ri achi ri xec'oji ri itzelalaj tak espíritus che, xukuje' jas ri xquic'ulmaj tak ri ak, xquitzijoj c'u ronojel wa' chque ri winak ri xquimulij quib. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Xquibochi'j c'u ri Jesús chi quel bi chanim pa ri qui tinimit. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Oquem cuban ri Jesús pa ri barco, ri achi ri xec'oji ri itzelalaj tak espíritus che xubochi'j ri Jesús chi cuya che chi que' ruc'. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Man xuya tä c'u ri Jesús che, xane xubij che: Oj la cho achoch la cuc' ri achalaxic la, tzijoj la chque ri e are' ronojel ru banom ri Kajaw Dios che la, chi sibalaj xel u c'ux che la, xutok'obisaj wäch la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Xe' c'u ri achi, xutzijoj c'u pa tak ri tinimit re Decápolis ronojel ru banom ri Jesús che. Xquicajmaj c'u wa' conojel ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Aretak ri Jesús xk'ax chi jumul ch'äkäp che ri mar pa ri barco, sibalaj q'uia winak xquimulij quib ruc'. C'o c'u ri Are' chuchi' ri mar. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Xopan c'u jun achi ruc' ri Jesús. Are qui nimal ri winak re ri rachoch Dios ri tata' ri', Jairo u bi'. Aretak ri tat Jairo xril ri Jesús, xxuqui chuwäch. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Sibalaj xubochi'j ri Jesús, xubij che: ¡Ri alaj nu mia'l tajin cäcämic! ¡Sa'j la wuc'! Ya la ri k'ab la puwi' rech cutziric, cäc'asi c'ut, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Xe' c'u ri Jesús ruc'. E q'uia ri winak ri xukuje' xebe' ruc', cäquipitz' c'u ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","C'o c'u jun ixok ri xque' cablajuj junab xak quel u quiq'uel. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Sibalaj u rikom c'äx pa qui k'ab q'uia tak cunanelab, u sachom c'u ronojel ri c'o ruc'. Man c'o tä c'u utzil u rikom, xane xa tajin cänimatajic. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Aretak xuta u tzijol ri tajin cuban ri Jesús, xopan c'u ruc'. Xoc chquixol ri q'uialaj winak, xkeb chrij ri Jesús, xuchap cok ru k'u'. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Cubij c'u pa ranima': “Xuwi ta ne we quinchap cok ru k'u', ¡quinutzir na!” —cächa ri ixok. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Chanim c'ut, aretak xchaptaj ru k'u' ri Jesús rumal, xtäni ru quiq'uel ri quelic. Xuna' ri ixok pa ru cuerpo chi xcunataj che ri itzelalaj yabil ri u rikom. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ri Jesús c'ut xuna' chi xel jubik' ru chuk'ab chucunaxic ri ixok. Chanim xutzolk'omij rib chquixol ri q'uialaj winak, xca'y c'u chque, xubij: ¿Jachin ri xchapow ri watz'iak? —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Xquibij c'u ru tijoxelab che: ¡Quil ya' la chi cäpitz' la cumal ri q'uialaj tak winak! ¿Jas che cäbij la: “¿Jachin ri xinchapowic?” —cächa la, —xecha che ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Cäca'ylob c'u ri Jesús che rilic jachin ri xbanow wa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Are c'u ri ixok ri xchapowic, xuxej rib, xbirbitic, xe' ruc' ri Jesús, xxuqui c'u chuwäch. Cuch'obo chi xcunatajic rumal ri Are', xutzijoj c'u che ri Jesús ronojel ri kas tzij chrij ri c'ulmatajinak ruc'. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ri Jesús xubij che: Nan, xcunataj la rumal chi xcojon la chwe. Oj ba' la, chuxlan anima' la, xutzir c'u can la che ri yabil la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tajin cätzijon ri Jesús aretak xeopan jujun winak, e petinak pa rachoch ri qui nimal ri winak re ri rachoch Dios, xquibij che ri tat Jairo: ¡Xcäm ri mia'l la! Xak mäya la latz' che ri Ajtij, —xecha che ri tata'. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Aretak ri Jesús xuta ri xbixic, man nim tä xril wi wa', xubij che ri qui nimal ri winak re ri rachoch Dios: Mäxej ib la, xane xak xuwi cojon la chwe, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Man xraj tä c'u ri Jesús chi c'o jachin chic xe' ruc', xane xak xuwi ri tat Pedro, ri tat Jacobo, xukuje' ri tat Juan u chak' ri tat Jacobo. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Aretak xeopan cho rachoch ri qui nimal ri winak re ri rachoch Dios, ri Jesús xrilo chi ri winak cäquituquij quib, xukuje' cäquiq'uis quib che ok'ej, sibalaj cäquirak qui chi'. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Oquinak c'u bi ri Jesús pa ri ja, xubij chque: ¿Jas che sibalaj cärak chi' alak, cäq'uis ib alak che ok'ej? Man cäminak tä ri ac'al, xane xa cäwaric, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ri e are' xa xquitze'j u wäch ri Jesús. Ri Are' c'ut xeresaj bi conojel ri winak cho ja. Xeuc'am ru tat, ru nan ri ac'al, xukuje' tak ri rachi'l, xoc c'u bi jawije' tutz'ul wi ri ac'al. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ri Jesús xuchap ri ali che ru k'ab, xubij che: ¡Talita, cumi! —xcha che. Ri tzij ri' quel cubij: ¡Alaj ali! Quinbij chawe, ¡chatwalijok! —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Chanim xwalij ri ali, xbinic. Cablajuj chi c'u u junab. Sibalaj xquicajmaj wa' ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ri Jesús sibalaj xeupixbaj chi mäquitzijoj wa' chque niq'uiaj winak chic. Xubij chi chquiya che ri ali jas cutijo. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Xel bi ri Jesús chila', xtzelej c'u bi pa ru tinimit ri Are', xebe' c'u ru tijoxelab ruc'. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Aretak xopan ri k'ij re uxlanem, ri Jesús xuchaplej qui tijoxic ri winak pa ri rachoch Dios. Xquicajmaj c'u wa' q'uia chque ri winak ri xeto'wic, xquibij: ¿Jawije' xretamaj wi ronojel wa' ri Are'? —quecha'. ¿Jas u wäch no'j wa' ri yo'm che? ¿Jas ta c'u lo cuban che qui banic ri nimalaj tak cajmabal ri tajin quebantaj rumal? —quecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Are ba' wa' ri kolol che', ri ral ri nan María, catz ri a Jacobo, ri a José, ri a Judas, xukuje' ri a Simón. E c'o c'u ri ranab ri Jesús kuc' waral xukuje', —xecha'. Tzel c'u xquita ru tzij. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Xubij c'u ri Jesús chque: Pa niq'uiaj tinimit chic nim quil wi ronojel k'alajisal re ru Lok' Pixab ri Dios. Xak xuwi pa ru tinimit ri are', xukuje' chquixol ri rachalal, xukuje' cho rachoch, man nim tä quil wi wa', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Man xcowin tä c'u ri Jesús chubanic jun nimalaj cajmabal chila', xane xak xuwi xuya ru k'ab pa qui wi' quieb oxib yawabib, xeucunaj. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ri Are' xucajmaj wa' chi man c'o tä jubik' ri qui cojonic ri winak che. Xeusolij c'u tak ri alaj tak tinimit ri e c'o chunakaj ri Nazaret, xeutijoj ri winak chila'. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ri Jesús xeusiq'uij ri cablajuj u tijoxelab ruc', xuchaplej qui takic bi chi cacabil. Xuya takanic pa qui k'ab che quesaxic bi ri itzelalaj tak espíritus. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Xubij c'u chque chi c'o jas mäquic'am bic, mäquic'am bi qui chim, o qui wa, o puak pa ri c'olibal qui rajil, xane xak xuwi ri qui ch'imiy. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Xukuje' xubij chque chi chquicojo bi qui xajäb, mäquic'am c'u bi quieb qui camixa', xane xa jun cäquicoj bic. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Xubij xukuje' ri Jesús chque: Apachique ja ri quixoc wi, chila' chixcanaj wi canok c'ä quixel na bi pa ri tinimit ri', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Apachique tinimit ri man quixc'ulax tä wi, ri man cäcaj taj cäquitatabej ri i tzij, aretak quixel bi chila', chitota' can ri ulew ri c'o che tak ri iwakan. Chibana wa' chuk'alajisaxic chquij ri winak re ri tinimit ri' chi man utz tä ri cäca'no, c'o qui mac. Kas tzij quinbij chiwe chi pa ri k'ij ri cäk'at na tzij pa qui wi' ri winak ri' rumal ri Dios, cätan na ri' ri cäban chuc'äjisaxic qui wäch ri winak re ri tinimit Sodoma, re ri tinimit Gomorra chuwäch ri cäban chuc'äjisaxic qui wäch ri winak re ri tinimit ri', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Xebel c'u bi ri tijoxelab, xebe'c, xquitzijoj chi ri winak rajwaxic cäquiq'uex canima', cäquiq'uex c'u qui chomanic. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Xequesaj c'u q'uia itzel tak espíritus chque ri winak. Xukuje' xquicoj aceite chque q'uia yawabib, xequicunaj c'ut. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ri nim takanel Herodes xretamaj ri tajin cuban ri Jesús rumal chi conojel ri winak qui tom u tzijol ronojel wa'. Xubij c'u ri tat Herodes: Are ri Juan Kasal Ja' ri' ri xc'astaj lok chquixol ri cäminakib, rumal c'u ri' c'o u cuinem ri are' chubanic q'uia u wäch cajmabal, —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","E c'o c'u niq'uiaj chic tajin cäquibij: Are ri tat Elías wa' ri ojer ka mam, —quecha'. Niq'uiaj chic cäquibij: Are wa' jun chque ri ojer k'alajisal tak re ru Lok' Pixab ri Dios, —xecha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Aretak c'ut xuta wa' ri tat Herodes, xubij ri are': Are ri tat Juan wa' ri xinwesaj u jolom, xa c'astajinak lok chquixol ri cäminakib, —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","(Xa c'u rumal rech ri nan Herodías xcämisax ri Juan Kasal Ja'.) Tzare c'u ri tat Herodes xtakan chuchapic ri tat Juan rech cäyutic cäyi' pa che', xa rumal rech ri nan Herodías ri xc'uli ruc' ri tat Herodes, pune are rixokil ri tat Felipe ru chak' ri tat Herodes. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Xchap c'u ri tat Juan rumal chi ri are' xubij che ri tat Herodes: Man takal tä che la chi cäban ixokil la che ri rixokil ri chak' la, xane äwas ri cäban la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Sibalaj xpe royowal ri nan Herodías che ri tat Juan rumal ronojel ri xubij. Sibalaj craj u cämisaxic. Man cäcowin tä c'ut rumal ri tat Herodes. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Je ri', rumal chi ri tat Herodes nim cäril wi ri tat Juan, cuxej c'u rib chuwäch. Retam c'ut chi are jun utzalaj achi ri jicom ranima' cho ri Dios. Xa rumal ri' cuchajij ri tat Juan rech man c'o tä c'äx cäban che. Aretak c'ut ri tat Herodes cutatabej ru tzij, man curik taj jas cubano. Pune ta ne je ri', sibalaj xkaj chuwäch ri tat Herodes xutatabej ri xubij. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Xurik c'u ri nimak'ij re ri roc'owisaxic u junab ri tat Herodes. Ri are' xuban jun nimalaj wi'm chque ri winak ri nimak qui banic ri e c'o ruc', xukuje' chque ri qui nimakil ri soldados, cachi'l ri qui nimakil ri winak aj Galilea. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Tajin quewi' ri rula' aretak ri ali ri ral ri nan Herodías xoc bi cuc', xuchap xojowem chquiwäch, cäxojowic, cäxojowic. Xkaj c'u ri ali chuwäch ri tat Herodes, xukuje' chquiwäch ri tajin quewi' ruc'. Xubij c'u ri nim takanel che ri ali: Chata' ba' chwe jas ri cawaj, quinya c'u na wa' chawe, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ri tat Herodes xuchi'j che ri ali ruc' juramento, xubij: Apachique ta ne ri cata' chwe quinya na chawe. Pune ta ne cata' chi quinya niq'uiaj chque tak ri tinimit ri quintakan wi, quinya na wa' chawe, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Xel c'u bi ri ali, xuch'abej ru nan, xubij: ¿Jas ta ne ri quinta' che? —xcha che. Xubij c'u ru nan: ¡Chata' chi cäyi' chawe ru jolom ri Juan Kasal Ja'! —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Aninak xoc chi bi ri ali ruc' ri nim takanel, xuta' che, xubij: ¡Cwaj chi cäya la chwe ru jolom ri Juan Kasal Ja' pa jun plato chanim ri'! —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Sibalaj xbison c'u ri tat Herodes. Ri are' man craj taj cuq'uex ri xuchi'j che ri ali, rumal chi xubij wa' ruc' juramento chquiwäch conojel ri rula'. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Chanim ri nim takanel xutak bi jun chque ri soldados chuc'amic lok ru jolom ri Juan Kasal Ja'. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Xel c'u bi ri soldado, xe'c, xresaj u jolom ri tat Juan ri c'o pa che'. Xuc'am lok pa jun plato, xuya che ri ali, ri ali c'ut xuya che ru nan. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Aretak xquita wa' ru tijoxelab ri tat Juan, xebe' che rilic, xquic'am c'u bi ru cuerpo, xquiya pa jun mukubal. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Xquimulij c'u quib ruc' ri Jesús ri cablajuj apóstoles ri takom bi rumal, xquitzijoj che ri Are' ronojel ri xca'no, xukuje' ronojel ri xequitijoj wi ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Xubij c'u ri Jesús chque: Chixsa'j wuc' xa i tuquiel wi. Jo' jawije' ri man c'o tä wi winak, cujuxlan c'u jun rat chila', —xcha chque. Je' xubij wa' rumal chi e q'uia winak ri tajin queopan cuc', xukuje' e c'o ri tajin quebel bic, je ri' chi ri Jesús e rachi'l ru tijoxelab man quecowin taj quewi'c. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Xebe' qui tuquiel wi pa jun barco, xeopan chila' pa ri juyub ri cätz'inowic. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","E q'uia c'u ri winak ri e petinak pa tak conojel ri tinimit chila'. Xquilo aretak xe' ri Jesús e rachi'l ru tijoxelab, xquich'ob c'u qui wäch. Xa je ri' ri winak chi cakan xebe' ri e are' jela' jawije' ri xebe' wi ri Jesús, ru tijoxelab. Xquicowij bic, xeopan c'u nabe chquiwäch. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Aretak xel lok ri Jesús pa ri barco, xeril ri q'uialaj winak. Xel c'u u c'ux chque rumal chi je' ta ne e chij ri man c'o tä cajyuk'. Ri Jesús c'ut xuchaplej qui tijoxic. Q'uia c'ut ri xuc'ut chquiwäch. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kajem c'u cuban ri k'ij, ru tijoxelab xekeb ruc', xquibij che: We juyub ri' ri uj c'o wi sibalaj cätz'inowic, benak chi c'u ri k'ij. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Chetaka la bi ri winak rech quebe' cho tak cachoch ri winak ri e sutininak chkij, xukuje' pa tak ri alaj tak tinimit ri nakaj e c'o wi, cäquilok' c'u na ri qui wa. Man c'o tä c'u ri cäquitijo, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Xch'aw c'u ri Jesús, xubij chque: Chiya ix ri cäquitijo, —xcha chque. Xquibij ru tijoxelab che: ¿Jas ta c'u cäka'no? ¿A cujcowin ta lo cuje'c quekalok' quieb cientos quetzales caxlan wa che tzukubal que we winak ri'? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Xuta' c'u ri Jesús, xubij chque: ¿Janipa' caxlan wa e c'o iwuc'? ¡Jiwilampe'! —xcha chque. Aretak xquetamaj, xquibij: Xa job caxlan wa e c'olic, xukuje' quieb cär, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Xtakan c'u ri Jesús chi quet'uyi ri winak pa tak mulaj cho ri räxalaj uwosak. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Xet'uyi c'ut pa tak mulaj, pa tak ciento, pa niq'uiaj tak ciento. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ri Jesús xeuc'am c'u ri job caxlan wa xukuje' ri quieb cär, xca'y chicaj, xeutewchij. Te c'u ri' xeupir ri caxlan wa, xeuya chque ru tijoxelab rech quequijach wa' chquiwäch ri winak. Xukuje' ri quieb cär xeujach chquiwäch conojel. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Xewi' c'u conojel, xenoj c'ut. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Te ri' xequic'ol ri ch'äkatak tak caxlan wa, xukuje' ri ch'äkatak cär ri xecanaj canok. Xuban cablajuj chicäch wa chi ronojel. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","E job mil achijab c'ut ri e c'o chquixol ri winak ri xewi'c, ri xquitij que ri wa. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Te c'u ri' ri Jesús xubij chque ru tijoxelab chi utz we queboc pa ri barco rech quebe'c, quenabej apanok chuwäch ri Are' pa ri tinimit Betsaida ch'äkäp che ri mar. Are c'u ri Jesús xcanaj can cuc' ri q'uialaj winak che qui jachic bic. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","E jachtajinak chi c'u bi ri winak rumal ri Jesús, xe' ri Are' pa ri juyub chubanic orar. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Are chi' ri tajin coc ri ak'ab, ri tijoxelab e c'o pa ri barco puwi' ri ja' pu niq'uiajal ri mar. Are c'u ri Jesús u tuquiel c'o can chuchi' ri mar. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Xrilo chi ru tijoxelab tajin cäquirik c'äx chubinisaxic ri barco rumal chi chquiwäch petinak wi ri quiäkik'. Xa jubik' craj man cäsakiric aretak xopan ri Jesús cuc', tajin cäbin puwi' ri ja'. U chomam ri Jesús chi xa coc'ow chquiwäch. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Aretak ri tijoxelab xquilo chi cäbin ri Jesús puwi' ri ja', xquichomaj c'ut chi are jun xibinel wa'. Xexibix c'u rumal, xquirak c'u qui chi'. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Je ri', rumal chi conojel xquilo, sibalaj xquixej quib. Chanim ri Jesús xeuch'abej, xubij chque: In wa', ¡mixej iwib, chichajij iwanima'! —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Xoc c'u bi ri Jesús pa ri barco cuc' ru tijoxelab, xtäni c'u ri quiäkik'. Sibalaj c'u xquicajmaj wa' ri tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Man oquinak tä c'u pa qui jolom jas quel cubij ri cajmabal ri xuban ri Jesús aretak xujach ri caxlan wa chque ri winak, xane xa abajarinak ri canima'. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","E k'axinak chi ch'äkäp che ri mar, xeopan chuchi' ri ulew pa Genesaret, xquixim c'u ri qui barco chila' chuchi' ri mar. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Aretak xebel bi pa ri barco, ri winak chanim xquich'ob u wäch ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Xebinlobic, xequisolij conojel tak ri tinimit chila'. Are c'u ri winak xquichaplej qui c'amic lok ri yawabib cho tak alaj tak ch'at jawije' chi' ri cäquito chi c'o wi ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Apawije' chi' c'ut ri xopan wi ri Jesús, we pa tak alaj tak tinimit, we pa nimak tak tinimit, we c'u pa tak juyub, xeyi' ri yawabib pa tak ri be, xquibochi'j c'u ri Jesús chi xuwi ta ne cuya chque chi cäquichap cok u chi' ru k'u'. Conojel c'u ri xechapowic xeutzir canok. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ri tata'ib fariseos xukuje' jujun chque ri tata'ib tijonelab re ri Pixab ri e petinak pa ri tinimit Jerusalén xquimulij quib chrij ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Xequil c'ut chi jujun chque ru tijoxelab ri Jesús cäquitij ri qui wa, man cäca'n tä c'u que ri e nak'atal wi ri fariseos. Are wa' ri u ch'ajic ri rij ri qui k'ab, na'l cäca'n che. Tzel c'u xquil wa' ri fariseos, xeyok'on chque ru tijoxelab ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Je ri', rumal chi ri tata'ib fariseos, xukuje' conojel ri niq'uiaj winak aj Israel na'l cäquich'aj ri rij qui k'ab, te c'u ri' quewi'c. Xak are qui c'amom ri e nak'atal wi ri qui nan qui tat ojer. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Xukuje' aretak quetzelej lok pa ri c'ayibal, we man cäquich'aj tä quib, man quewi' taj. E c'o c'u q'uia ri e nak'atal wi ri cäca'n ri e are', je' jas ri qui ch'ajic ri vasos, ri t'uy, ri ch'ich' tak lak, xukuje' tak ri qui ch'at. (Xa rumal ri e nak'atal wi ri tata'ib fariseos, xquibij chi äwas ri' we man cäca'n tä que ri winak jas ri cäca'n ri e are'.) ");
INSERT INTO qucTNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Rumal wa' ri fariseos xukuje' ri tijonelab re ri Pixab xquita' che ri Jesús, xquibij che: ¿Jas che man cäca'n tä ri tijoxelab la jas ri e nak'atal wi ri ka nan ka tat ojer? —quecha'. Xane quewi'c, man na'l taj cäca'n chuch'ajic ri rij ri qui k'ab nabe, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Xch'aw c'u ri Jesús, xubij chque: Kas tzij ri xubij ri ka mam Isaías ri k'alajisal re ru Lok' Pixab ri Dios ojer chij alak. Are la' chi xa quieb wäch alak, jas ri tz'ibtal rumal, ri cubij: We winak ri' xak che qui chi' cäquinimarisaj nu k'ij, man kas cäquijiquiba' ri canima' chwij, —cächa ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Xak lok' quek'ijilan chwe. Cäquiya che tijonic xak xuwi ri qui pixab ri winak, —cächa ri', —xcha ri ka mam Isaías. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Je ri', rumal chi ri alak yo'm can alak ru Lok' Pixab ri Dios. Chuq'uexwäch c'u wa', xa jiquibam anima' alak chquij ri e nak'atal wi ri winak, je' jas ri na'l qui ch'ajic ri t'uy, ri vasos, xukuje' q'uia u wäch ri e je' tak wa' ri nak'atal wi alak, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Xukuje' xubij chque: Ri alak man nim tä chic quil wi alak ru takanic ri Dios. Man c'o tä chi u patän wa' chuwäch alak. Chuq'uexwäch wa' cäban alak xa jas ri nak'atal wi alak, —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","U bim c'u can ri ka mam Moisés: “Nim cheawila wi ra nan a tat,” —cächa'. U bim xukuje': “Jachin c'u ri cuyok' ru nan u tat, tzrajwaxic cäcämisax na wa',” —cächa ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ri alak c'ut cäbij alak: Xak xuwi rajwaxic chi cubij jun achi che ru nan u tat: “Are Corbán wa' ronojel ri quincowinic quincoj che to'ic alak,” —cächa chque. (Ri “Corbán” quel cubij: “Yo'm cho ri Dios”, —cächa'.) ");
INSERT INTO qucTNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","We je' cubij wa' ri achi ri', man cäya tä alak che chi c'o jas cuban che qui to'ic ru nan u tat. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Je ri' man nim tä chic quil wi alak ru Tzij ri Dios, man c'o tä chi u patän ru Lok' Pixab ri Dios chuwäch alak. Xak xuwi chquij tak ri nak'atal wi alak cäya wi alak tijonic. Xukuje' q'uia ri je' tak wa' cäban alak, —xcha ri Jesús chque ri tata'ib ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ri Jesús xeusiq'uij ri winak ruc' jumul chic, xubij c'u chque: Alak, onojel alak, tatabej alak ri nu tzij, ch'obo alak ri quinbij, —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Man c'o tä ri cutij ri winak ri cäcowinic cäretzelaj u wäch ru c'aslemal. Xane are ri quel lok pa ranima' ri winak, are wa' ri quetzelan u wäch ru c'aslemal. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","We c'o jun ri cujiquiba ranima' chutatabexic ri nu tzij, ¡chutatabej ba'! —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Oquinak chi ri Jesús pa ri ja, u yo'm c'u can ri winak, xepe ru tijoxelab, xquita' che ri Are' chrij ri c'utbal ri xutzijoj chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Xuta' c'u ri Jesús chque, xubij: ¿A xukuje' ne ri ix man quich'ob tä wa'? —cächa'. ¿A mat iwetam chi ronojel ri cutij ri winak, ri coc chupam, man cäcowin tä wa' che retzelaxic u wäch ru c'aslemal? ");
INSERT INTO qucTNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Are je ri', rumal chi man coc tä pa ranima', xane xak xuwi pa ri rixco'l, quel c'u canok aretak cuban ru chul, —xcha chque. Xubij wa' chque chuc'utic chi man c'o tä jun u wäch wa ri äwas u tijic, ri quetzeletaj jun winak rumal. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Xukuje' xubij: Ri quel lok pa canima' ri winak are wa' ri quetzelan u wäch ri qui c'aslemal. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Je ri', rumal chi pa canima' ri winak, quebel wi lok ri itzel tak qui chomanic, xukuje' ri etzelal ri cäca'n ri e are' ri e je' tak wa': ru banic ri nimalaj mac ruc' ri rixokil o ri rachajil jun chic, ru banic jas ri cäca'n ri tz'i' ri xak cäquirik quib, man c'o tä qui pixab, xukuje' ru banic ri cämisanic, ");
INSERT INTO qucTNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ri elak'anic, ru rayixic ri quech niq'uiaj winak chic, ri etzelal, ri subunic, ri sac'ajil chubanic ronojel u wäch etzelal, ri c'äx cuna' jun chrij jun winak chic ri utz u rikom, ru yaquic tzij chrij jun chic, ru banic nimal, xukuje' ri man cuya' tä jun chi coc tzij pu jolom, xane xa cuban re ri are'. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Conojel wa' we etzelal ri' quebel lok pa canima' ri winak, quetzeletaj c'u ri qui c'aslemal cumal, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Xel bi ri Jesús chila', xe'c, xopan pa Fenicia chunakaj ri tinimit Tiro, xukuje' ri tinimit Sidón. Xoc c'u bi pa jun ja. Man craj taj chi ri winak cäquetamaj chi c'o chila', man cäcowin tä c'ut chuc'u'ic rib. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Chanim c'ut xretamaj jun ixok chi ri Jesús c'o chila'. Ri ixok ri' c'o jun alaj ral ali ri c'o jun itzelalaj espíritu che. Xopan c'u ruc' ri Jesús, xxuqui chuwäch. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ri ixok ri' man are tä aj Israel, xane ilom u wäch pa Fenicia, ch'äkäp re ri Siria. Xubochi'j ri Jesús, xuta' tok'ob che chi cäresaj bi ri itzel espíritu che ri ral ali. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Xubij c'u ri Jesús che: Cheyej na la rech nabe cäyi' ri qui wa ri ac'alab, chenoj c'u na ri e are'. Man utz tä ru chapic ri qui wa ri ac'alab, cäq'uiäk ta c'u chquiwäch ri alaj tak tz'i', —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Xch'aw c'u ri ixok, xubij che ri Jesús: ¡Je', Tat! Xukuje' ne ri alaj tak tz'i' ri queboc pa ja cäquitij ru xe'r tak ri qui wa ri ac'alab, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Xubij c'u ri Jesús che ri ixok: Rumal we tzij ri' ri xbij la, cuya' que' la cho ja. Elinak chi c'u bi ri itzel espíritu che ri alaj ali ri al la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Xe' c'u ri ixok cho ja. Aretak xopanic xurika ri ral k'oyol pa ru ch'at, elinak chi c'u bi ri itzel espíritu che ri alaj ali. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Xel c'u bi ri Jesús chila' chunakaj ri tinimit Tiro, xoc'ow pa ri tinimit Sidón, xukuje' pa tak ri tinimit re Decápolis, xopan c'u chuchi' ri mar re Galilea. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Aretak c'o chila' xc'am lok jun so'r achi ri xukuje' mem ruc' ri Jesús. Ri xec'amow lok quebochi'nic, cäquita' tok'ob che ri Jesús chi cuya ru k'ab puwi' ri achi. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ri Jesús xuc'am c'u bi ri achi chquiwäch ri winak pu tuquiel wi. Xeunim ru wi' tak u k'ab pa tak ru xiquin ri achi, xukuje' xchubanic, xuchap cok ri rak'. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Xca'y c'u ri Jesús chicaj, xbik'bitic, xubij che ri achi: ¡Efata! —xcha'. Quel cubij wa': ¡Chjaktajok! —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Chanim c'ut xejaktaj ru xiquin ri achi, xukuje' xutzir ri rak'. Cäcowin chi c'ut cätzijonic. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ri Jesús c'ut queupixbaj ri winak chi c'o jun mäquibij wi. Pune sibalaj queupixbaj na, xa sibalaj cäquesaj na u tzijol wa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Sibalaj c'u cäquicajmaj ri winak, cäquibij: ¡Sibalaj utz cuban ri Jesús che ronojel! Cubano chi cäquita chic ri so'rab, xukuje' cubano chi ri memab quech'awic, —xecha ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Pa tak ri k'ij ri', qui mulim quib sibalaj q'uia winak jumul chic, man c'o tä c'u ri cäquitijo. Ri Jesús xeusiq'uij ru tijoxelab, xubij chque: ");
INSERT INTO qucTNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Quel nu c'ux chque ri winak rumal chi oxib k'ij chi wa' e c'o wuc', man c'o tä c'u jas cäquitijo. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","We quintakan chque chi quebe' cho cachoch, mäja' c'u quewi'c, quetzak na pa tak ri be. Jujun c'u chque naj e petinak wi, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ru tijoxelab xech'awic, xquibij che: ¿Jawije' ta c'u lo cäcowin wi jun curik ri wa che qui tzukic wa' we winak ri' waral pa we juyub ri' ri cätz'inowic? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Xuta' c'u ri Jesús chque: ¿Janipa' caxlan wa e c'o iwuc'? —xcha'. Ri e are' xquibij: ¡Wukub! —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Xtakan c'u ri Jesús chque ri q'uialaj tak winak chi quecu'bi pulew. Te c'u ri' xeuc'am ri wukub caxlan wa, xmaltioxinic, xeupiro. Xeuya chque ru tijoxelab rech quequijach wa' chquiwäch ri winak. Je c'u ri' xca'no. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Xukuje' e c'o quieb oxib alaj tak cär. Ri Jesús xeutewchij ri alaj tak cär, xubij chque ru tijoxelab chi quequijach wa' xukuje' chquiwäch ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Xewi' c'u conojel ri winak, xenojic. Xequimulij c'u ri ch'äkatak tak caxlan wa ri xecanaj canok, ronojel c'u wa' xuban wukub chicäch wa. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Craj e c'o quiejeb mil winak ri xewi'c. Te c'u ri' xeutak bi ri Jesús cho cachoch. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Chanim c'ut xoc bi ri Jesús pa ri barco cuc' ru tijoxelab, xebe' pa Dalmanuta. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Xeopan c'u ri tata'ib fariseos ruc' ri Jesús, xquichap tzij ruc'. Te ri' xquita' che chi cuc'ut chquiwäch jun cajmabal etal ri cäpe chicaj. Xquibij wa' che rech cäkaj ri Jesús pa qui k'ab. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Sibalaj xbik'bit c'u ri Jesús, xubij: ¿Jas che cäquita' etal ri winak re we k'ij junab ri'? —cächa'. Kas tzij ri quinbij chech alak chi man cäyi' tä chi na jun etal chque, —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Xel bi ri Jesús chquiwäch. Xoc chi jumul pa ri barco, xe' c'u ch'äkäp che ri mar. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Xsach pa qui jolom ri tijoxelab u c'amic bi qui wa. Xak xuwi jun caxlan wa c'o cuc' pa ri barco. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ri Jesús xeupixbaj, xubij chque: ¡Chitampe'! ¡Chichajij iwib chuwäch ri qui ch'amil ri tata'ib fariseos, xukuje' chuwäch ru ch'amil ri Herodes! —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Xquitzijobela c'u quib ri tijoxelab, xquibij: Ri Are' cubij wa' rumal chi man c'o tä ka wa ka c'amom lok, —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Aretak ri Jesús xretamaj jas ri tajin cäquibij, xubij chque: ¿Jas che quitzijobela iwib chi man c'o tä i wa? —cächa chque. ¿A xak are mäja' quich'obo, mäja' quiwetamaj? ¿A xa abajarinak na ri iwanima'? —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Pune c'o i wak'äch rech quixca'yic, ¡man quixca'y taj! Pune c'o i xiquin rech quito, ¡man quitatabej taj! ¿A mat cäna'taj wa' chiwe ri xinbano? —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Aretak xinpir ri job caxlan wa, xinjach c'u wa' chquiwäch ri job mil winak, ¿janipa' chicäch nojinak chque ch'äkatak tak wa ri man xq'uis taj ri xeic'olo? —xcha chque. ¡E cablajuj! —xecha ri e are'. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Aretak c'ut xinpir ri wukub caxlan wa, xinjach wa' chquiwäch ri quiejeb mil winak, ¿janipa' chicäch nojinak chque ch'äkatak tak wa ri man xq'uis taj ri xeic'olo? —xcha chque. ¡E wukub chicäch! —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Xubij c'u ri Jesús chque: ¿Jas lo wa' chi c'ä mäja' quich'obo? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Te c'u ri' xopan ri Jesús pa ri tinimit Betsaida, e rachi'l c'u ru tijoxelab. Jujun winak xquic'am lok jun moy achi cho ri Jesús, xquibochi'j chi cuchap cok ri achi. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ri Jesús xuchap ri moy che ru k'ab, xuyukej bic, xebel c'u bi pa ri tinimit. Xchuban c'u pa tak u wak'äch ri moy, xuya ru k'ab puwi' ri achi, xuchap cok ru wak'äch, te c'u ri' xuta' che: ¿A c'o ri quil la? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Are c'u ri moy xca'y ak'anok, xubij: Quinwil ri winak chi je' ta ne e che', quinwil c'ut chi quebinic, —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ri Jesús xuya chi jumul ru k'ab puwi' ri achi, xuchap cok ru wak'äch. C'ä te ri' kas xca'yic. Xutzir can ru wak'äch, utz chic xcowin ri achi che rilic ronojel. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Te c'u ri' ri Jesús xutak bi cho rachoch, xubij bi che: Utz na we man coc tä la pa ri tinimit, man c'o tä c'u ri cätzijoj la apan che jun chic jas ri nu banom che la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Xe' c'u ri Jesús, e rachi'l ru tijoxelab, xeopan pa tak ri tinimit re Cesarea Filipo. Benam c'u que pa ri be, xuta' chque ru tijoxelab, xubij: ¿Jachin ri in ri cäquibij ri winak? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Xquibij c'u che: E c'o jujun winak cäquibij chi lal ri' ri Juan Kasal Ja', —quecha'. Xukuje' cäquibij jule' chic chi lal ri' ri ka mam Elías. E c'o chi niq'uiaj cäquibij chi lal jun chque ri ojer k'alajisal tak re ru Lok' Pixab ri Dios, —quecha', —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Te ri' xch'aw ri Jesús jumul chic, xuta' chque: E c'u ri ix, ¿jachin ri in ri quibij ix? —xcha chque. Xch'aw c'u ri tat Pedro, xubij che: ¡Lal ri' ri Cristo! —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Xeupixbaj c'ut ri Jesús chi mäquitzijoj wa' che jachin jun. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ri Jesús xuchaplej qui tijoxic ru tijoxelab, xubij chque: Rajwaxic chi ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak, quinrik na sibalaj c'äx, quinxutux na cumal ri qui nimakil ri winak, cumal ri qui nimakil sacerdotes, xukuje' cumal ri tijonelab re ri Pixab. Xukuje' rajwaxic chi quincämisax na, te ri' quinc'astaj chi c'u na churox k'ij chquixol ri cäminakib, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Utz u bixic wa' xuban ri Jesús rech cäquich'obo. Are c'u ri tat Pedro xuc'am bi ri Jesús u tuquiel wi, xuchaplej u yajic. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Xutzolk'omij c'u rib ri Jesús, xeuca'yej ru tijoxelab, xuyaj ri tat Pedro, xubij che: ¡Chatel chnuwäch, Satanás! —cächa ri Jesús. ¡Man cach'ob tä c'u ru chomanic ri Dios, xane xak xuwi cach'ob ri qui chomanic winak! —xcha ri' chquiwäch. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ri Jesús xeusiq'uij ri q'uialaj winak junam cuc' ru tijoxelab, xubij c'u chque: We c'o jun craj cäpe wuc' in, rajwaxic chi muban xa jas ri craj ri are'. Rajwaxic chutelej ru cruz, chpet wuc' in, —cächa'. (Quel cubij wa' chi ri winak ri' man nim tä chic cäril wi ru c'aslemal, pune ta ne curik ri cämical rumal rech ri Jesús.) ");
INSERT INTO qucTNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Apachin ta ne ri craj cuto' u wi' ru c'aslemal cho ruwächulew, cäcäm c'u na wa' we winak ri', cutzak na ronojel. Man curik tä na ri' ri c'aslemal ri man c'o tä u q'uisic. Apachin ta ne ri cuya ru c'aslemal rumal wech in, xukuje' rumal rech ri Utzalaj Tzij re ri Evangelio, cuto' na u wi' ri kas u c'aslemal, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Jas ta c'u lo ri' ri cuch'ac jun winak we cärechbej ronojel ruwächulew, cutzak c'u na ri kas u c'aslemal? ");
INSERT INTO qucTNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Jas ta c'u lo ri cäcowin ri winak chuya'ic chuq'uexwäch ri kas u c'aslemal? —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Apachin c'ut ri cäq'uix chwe in xukuje' che ri nu tzij chquiwäch ri itzelalaj tak winak rech we k'ij junab ri', ri man queniman tä chi che ri Dios, xane xa cäca'n jas ri cäcaj ri e are', in ri' ri Ralc'ual ri Dios ri Kas Winak, quinq'uix na xukuje' che ri winak ri' aretak quintzelej lok, quinpe c'u na ri' wachi'l ri lok'alaj tak ángeles, cänimarisax c'u na nu k'ij jas ru nimarisaxic u k'ij ri nu Tat, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Te c'u ri' xubij ri Jesús chque conojel: Kas tzij ri quinbij chiwe chi e c'o jujun chque ri e c'o waral chnuwäch ri man quecäm taj c'ä cäquil na chi ya petinak ri' ruc' nimalaj chuk'ab ru takanic ri Dios pa qui wi' ri winak, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Xque' wakib k'ij chic u bim can wa' ri Jesús, aretak xeuc'am bi xak xuwi ri tat Pedro, ri tat Jacobo, xukuje' ri tat Juan qui tuquiel wi, xepaki c'u puwi' jun nimalaj juyub. Xq'uextaj c'u ru ca'yebal ri Jesús chquiwäch. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Sibalaj xjuluw ri ratz'iak ri Jesús, sibalaj sakloloj je' jas ri sak tew, je ri' chi man c'o tä jun ch'ajal atz'iak cho ruwächulew ri je' cäcowin chusakarisaxic wa' cubano. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tzcajmabal chic, xquic'ut quib quieb achijab ri tajin quetzijon ruc' ri Jesús, e are c'u ri ka mam Elías rachi'l ri ka mam Moisés. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Xch'aw ri tat Pedro, xubij c'u che ri Jesús: Kajtij, ¡sibalaj utz chi uj c'o waral! Ka'na oxib mo', jun che la, jun che ri ka mam Moisés, xukuje' jun che ri ka mam Elías, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Je' xubij wa' rumal chi man curik taj jas cubij, ¡sibalaj c'u xquixej quib ri tijoxelab! ");
INSERT INTO qucTNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Te ri' xkaj jun sutz' chquij, xech'uktaj c'u rumal. Xch'aw c'u lok jun chupam ri sutz', xubij: ¡Are lok'alaj nu C'ojol wa'! Chitatabej ri cubij, —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Chanim xeca'ylobic, man c'o tä chi c'u jachin ri xquilo, xane xak xuwi ri Jesús c'o cuc'. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kajem que cho ri juyub, ri Jesús xeupixbaj chi c'o mäquitzijoj wi ri quilom, c'ä aretak cäc'astaj na ri Are', ri Ralc'ual ri Dios ri Kas Winak, chquixol ri cäminakib. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Xeniman c'u che ri Jesús, man c'o tä xquibij che jun chic jas ri' ri xquic'ulmaj. Xa xquitzijobej quib chquixol chi jas ri' ri c'astajic chquixol ri cäminakib. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Xquita' c'u che ri Jesús, xquibij che: ¿Jas che cäquibij ri tijonelab re ri Pixab chi rajwaxic cäpe na ri ka mam Elías nabe? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Xch'aw ri Jesús, xubij chque: Tzij ri' chi cäpe ri ka mam Elías nabe, rech cuban na u banic ronojel. ¿Jas c'u cubij ru Lok' Pixab ri Dios ri Tz'ibtalic chwij in, in ri' ri Ralc'ual ri Dios ri Kas Winak? Tz'ibam chi sibalaj quinrik na c'äx, quetzelax c'u na nu wäch, —cächa ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Quinbij c'u chiwe chi ya ulinak ri tat Elías, xca'n c'u ronojel u wäch c'äx che ri are', xa jas ri xcaj xca'no, je' jas ri cubij chrij pa ru Lok' Pixab ri Dios ri Tz'ibtalic, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Te c'u ri' aretak xetzelej lok, xeopan cuc' ri niq'uiaj tijoxelab chic, xequil q'uialaj tak winak qui sutim quij ri tijoxelab, xukuje' e c'o jujun chque ri tijonelab re ri Pixab qui chapom tzij cuc'. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Aretak ri winak xquil ri Jesús, sibalaj xquicajmaj u wäch, aninak xebe' chuch'abexic. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Xuta' ri Jesús chque ru tijoxelab, xubij: ¿Jas wa' ri tajin quichomala cuc'? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Jun chque ri winak xch'awic, xubij che: Ajtij, xinc'am lok ri nu c'ojol chuwäch la, rumal chi c'o jun itzel espíritu che, ri u banom che chi man cäcowin taj cäch'awic. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Apawije' ta ne ri c'o wi aretak ri itzel espíritu cuchapo, cuq'uiäk pulew, chila' cuyacya wi, cäpuluw c'u u pu chi', xukuje' cukuch'uch'ej u ware, cäche'r c'u u cuerpo. Xinta' tok'ob chque ri tijoxelab la rech cäquesaj bi ri itzel espíritu che, man xecowin tä c'ut, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Xch'aw chi ri Jesús, xubij: ¡Ay, winak, alak ri' rech we k'ij junab ri', man cäcojon tä alak! —cächa'. ¿A are lo caj alak chi xak are' quinc'oji uc' alak ronojel k'ij, chi quinchajij paciencia uc' alak? —cächa'. ¡C'ama ba' alak lok ri ala chnuwäch! —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Xquic'am c'u lok ri ala ruc'. Aretak ri itzel espíritu xril ri Jesús, chanim xuyacya ri ala, xtzak c'u ri ala pulew, xuwolkotij rib, xpuluw u pu chi'. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Xuta' ri Jesús che ru tat ri ala, xubij: ¿Jampa' xuchap wa' we c'äx ri'? —xcha che. Xubij ru tat: Tzpa ru ch'utinal, —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Q'uia mul ri itzel espíritu cuq'uiäk ri ala pa ri k'ak', pa ri ja' chucämisaxic. We c'u c'o jas ri cäcowin la chubanic che, tok'obisaj la ka wäch, ¡chujto' la! —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Xubij c'u ri Jesús che: We cäcowin la cäcojon la chwe, ¡ronojel cuya' cäbanic rumal ri winak ri cäcojonic! —xcha ri Jesús che. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Chanim ru tat ri ala co xch'awic, xubij: ¡Tat, quincojonic! ¡Chinto' ba' la rech quincojon na más! —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Aretak ri Jesús xrilo chi q'uia winak tajin cäquimulij quib chrij, xuyaj ri itzelalaj espíritu, xubij che: Itzelalaj espíritu ri caban mem, ri xukuje' caban so'r chque ri winak, catintako chi chatel che ri ala, ¡matoc chi jumul che! —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Xurak c'u u chi' ri itzelalaj espíritu, sibalaj xuyacya can ri ala, xel c'u bi che. Xcanaj can ri ala je' ta ne cäminak, je ri' chi e q'uia ri xquibij: ¡Xcämic! —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ri Jesús c'ut xuchap ri ala che ru k'ab, xuyaco. Xtaq'ui c'u ak'an ri ala. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Oquinak chi c'u ri Jesús pa jun ja, xepe ru tijoxelab, xquita' che ri Jesús pu tuquiel wi, xquibij: ¿Jas che ri uj man xujcowin tä che resaxic bi ri itzelalaj espíritu? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Xubij c'u ri Jesús chque: Xak xuwi rumal ru banic orar xukuje' ri u banic ayunar quel bi jun itzelalaj espíritu ri je' u banic wa', —xcha ri Jesús chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Aretak xebel bi chila', xebe'c, xeoc'ow c'u pa Galilea. Man craj tä c'u ri Jesús chi c'o jun cäretamaj chi c'olic. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Je ri', rumal chi ri Jesús tajin queutijoj ru tijoxelab, xubij chque: Ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak, quinjach c'u na in pa qui k'ab ri winak, quinquicämisaj na ri e are', —cächa'. Pune in cäminak chic, quinc'astaj c'u na churox k'ij chquixol ri cäminakib, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ri e are' c'ut man xquich'ob tä ri tajin cubij chque, xquixej c'u quib chuta'ic che. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Xeopan c'u pa ri tinimit Capernaum. Aretak ri Jesús ya c'o chic pa ri ja, xuta' chque ru tijoxelab, xubij: ¿Jas ri' ri tajin quichomala iwib chrij aretak uj petinak pa ri be? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Man xech'aw tä c'ut rumal chi ri e are' tajin cäquichomala' quib pa ri be chrij jachin chque are ri nim na u banic. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Xt'uyi c'u ri Jesús, xeusiq'uij ri cablajuj u tijoxelab, xubij chque: We c'o jun ri craj coc che qui nimal ri winak, rajwaxic cubano chi man nim tä u banic chquixol, xane coc na che patänil que conojel, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Xuc'am c'u ri Jesús jun alaj ac'al, xutac'aba pa qui niq'uiajal ri tijoxelab. Xuk'aluj c'ut, xubij chque: ");
INSERT INTO qucTNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Apachin ri cäc'amow we ac'al ri' rumal wech in, in ri' quinuc'amo. Apachin c'u ri quinuc'am in, man xak xuwi tä ri in quinuc'amo, xane xukuje' are cuc'am ri xintakow lok, —xcha chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Xubij c'u ri tat Juan che ri Jesús: Ajtij, kilom jun achi ri man jun tä kuc' ri tajin cucoj ri bi' la che quesaxic bi ri itzel tak espíritus. Ri uj xkak'il c'u canok rumal chi man jun tä kuc', —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Xubij c'u ri Jesús: Mik'ila chic, —cächa'. Rumal chi man c'o tä jun ri cucoj ri nu bi' chubanic jun nimalaj cajmabal, te c'u ri' chanim cubij tzij ri man utz taj chwij in. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Apachin c'u ri man cujuc'ulelaj taj, are jun ri' kuc', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Apachin ri cuya jun vaso joron chiwe pa ri nu bi' rech quitijo xa rumal chi ix rech ri Cristo, kas curik na ri tojbal re, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Apachin c'u ri cubano chi jun chque we ch'utik ri' ri quecojon chwe curik ri be ri man utz taj, are utz ri' we ta cäxim jun ca' re molino chukul ri winak ri', cäq'uiäk ta c'u bi pa ri mar. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","We ta ra k'ab cubano chi ri at carik ri be ri man utz taj, chak'ata apanok. Are utz na chawe we carik na ri kas a c'aslemal pune at cut, chuwäch ri c'o quieb a k'ab cate' pa ri c'atic jawije' c'o wi ri k'ak' ri man cächuptaj taj. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Chila' c'ut man quecäm tä wi na ri ixjut ri cäquitij ri qui tijol ri winak, man cächuptaj tä c'u ri k'ak'. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","We ta ri awakan cubano chi at carik ri be ri man utz taj, chak'ata apanok. Are utz na chawe we carik na ri kas a c'aslemal, pune xa jun awakan c'olic, chuwäch ri c'o quieb awakan catq'uiäk bi pa ri c'atic jawije' c'o wi ri k'ak' ri man cächuptaj taj. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Chila' c'ut man quecäm tä wi na ri ixjut ri cäquitij ri qui tijol ri winak, man cächuptaj tä c'u ri k'ak'. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","We ta c'u ra wak'äch cubano chi ri at carik ri be ri man utz taj, chawesaj apanok. Are utz na chawe catoc chquixol ri winak ri cätakan ri Dios pa qui wi', pune xa jun a wak'äch c'olic, chuwäch ri c'o quieb a wak'äch, catq'uiäk bi pa ri c'atic jawije' c'o wi ri k'ak' ri man cächuptaj taj. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Chila' c'ut man quecäm tä wi na ri ixjut ri cäquitij ri qui tijol ri winak, man cächuptaj tä c'u ri k'ak'. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Conojel winak cäquirik na c'äx je' ta ne chi cäyi' k'ak' pa qui wi' junam jas ri cäyi' ri atz'am puwi' ronojel awaj ri cäcämisax chusipaxic cho ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Utz ri atz'am. We c'u man c'o tä chic u tzayil ri atz'am, ¿jas ta c'u lo quicoj chic chutzayixic? Chc'ol utzil pa iwanima' je' jas ri utzalaj atz'am, man quixch'ojin tä c'ut, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Xel c'u bi ri Jesús pa ri tinimit Capernaum, xe' pa Judea, xukuje' xe' ch'äkäp che ri nima' Jordán. Xquimulij c'u quib q'uia winak ruc' jumul chic. Ri Jesús jumul chic xeutijoj jas ri nak'atal wi ri Are'. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Xeopan c'u jujun tata'ib fariseos ruc' ri Jesús, xquita' c'u che we takal che jun achi cujach bi ri rixokil. Xa xquibij wa' che ri Jesús rech cäkaj ri Are' pa qui k'ab. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Xch'aw ri Jesús, xubij chque: ¿Jas pu ri xtak wi alak rumal ri ka mam Moisés? —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Xquibij c'u ri tata'ib fariseos: Ri ka mam Moisés xuya' chke chi jun achi cuya' cutz'ibaj jun wuj ri cubij wi chi ri achi cujach bi ri rixokil, xa je ri' c'ut cäjach bi ri ixok, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Xubij c'u ri Jesús chque: Xa rumal chi sibalaj abajarinak ri anima' alak, are rumal ri' xtz'ibax wa' we takanic ri' chech alak rumal ri ka mam Moisés, —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tzpa ru chaplexic lok ronojel, aretak ri Dios xuchap u banic ruwächulew, “chi achi chi ixok xeuban ri Dios”. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Rumal wa' jun achi cuya can ru nan u tat, cätuni c'u na ruc' ri rixokil. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Xa e jun na ri quieb ri',” —cächa ri'. Je c'u ri' man e quieb tä chic, xane xa e jun wa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Rumal c'u ri' jas ri xeutunuba ri Dios, mäjach qui wäch wa' rumal ri winak, —xcha ri Jesús chque ri tata'ib fariseos. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Aretak e c'o chic pa ja, ri tijoxelab xquita' che ri Jesús chi cubij chi na jumul chic jas quel cubij ri' ri xtzijox rumal. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Xubij c'u ri Jesús chque: Apachin ri cujach bi ri rixokil, cäc'uli chi c'u na ruc' jun ixok chic, ri achi ri' cuban ri nimalaj mac ri äwas u banic chrij ri nabe rixokil. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","We are ri ixok cujach bi ri rachajil, cäc'uli chi c'u na ruc' jun achi chic, ri ixok ri' cuban ri nimalaj mac ri äwas u banic chrij ri rachajil, —xcha ri Jesús chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ri winak xequic'am lok ri ac'alab cho ri Jesús rech cuya ru k'ab pa qui wi'. Xeyaj c'u ri winak cumal ri tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Aretak xril ri Jesús chi queyajon ri tijoxelab, xpe royowal, xubij chque: Chiya chque ri ac'alab chi quepe wuc', meik'atej rumal chi ru takanic ri Dios pa qui wi' ri winak are quech ri e je' tak wa', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Kas tzij ri quinbij chiwe chi apachin ri man cuc'am tä ri' ru takanic ri Dios je' jas ri cuban jun alaj ac'al, man cäyi' tä c'u che chi cätakan ri Dios puwi', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ri Jesús xeuk'aluj ri ac'alab, xuya c'u ru k'ab pa qui wi', xeutewchij. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Aretak ri Jesús xutakej chi ru be, chanim xpe jun ac'al achi ruc', xxuqui chuwäch, xuta' che, xubij: Utzalaj Ajtij, ¿jas quinban in rech quinrik ri c'aslemal ri man c'o tä u q'uisic? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Xubij c'u ri Jesús che: ¿Jas che cabij utz chwe? ¡Man c'o tä jun kas utz, xane xak xuwi ri Dios! —cächa che. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Awetam c'u ri cätakan wi ru Lok' Pixab ri Dios: “Matcämisanic, maban ri nimalaj mac ri äwas u banic ruc' ri rixokil jun winak chic, maban ri elak', maban tzij chrij jun winak chic, maban subunic che jun winak chic che resaxic ri rech ri are', nim cheawil wi ra nan a tat,” —cächa ri', —xcha ri Jesús che. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Xubij c'u ri achi che: Ajtij, ronojel wa' nu takem tzaretak in ac'al na, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ri Jesús co xca'y che ri achi, sibalaj lok' xril wi, xubij che: C'o jun jasach chic ri c'ä mäja' cabano. Cheaq'uiyij conojel ri jastak awe, chaya ri rajil chque ri meba'ib. Cäc'oji c'u na ra k'inomal chila' chicaj. Jo', tasa'j wuc', chatelej c'u ra cruz, —xcha che. (Quel cubij wa' chi man nim tä chic cäril wi ru c'aslemal, pune ta ne curik ri cämical rumal rech ri Jesús.) ");
INSERT INTO qucTNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Xq'uextaj c'u ru wäch ri achi, xc'äxc'ob ri ranima' rumal ri xubij ri Jesús che. Xbisonic xe'c, rumal chi q'uia u k'inomal c'olic. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Xca'y ri Jesús pa tak u xcut, xubij chque ru tijoxelab: ¡Sibalaj c'äx cäquitij ri k'inomab queopan ruc' ri Dios rech cätakan pa qui wi'! —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ri tijoxelab xquicajmaj ri xubij chque, man xquirik tä chic jas xca'no. Xch'aw chi jumul ri Jesús, xubij chque: Kachalal, kas c'äx cäquitij ri winak ri cäcu'bi ri canima' chrij ri k'inomal, queopan ruc' ri Dios rech cätakan pa qui wi'. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Are man c'äx tä ri roc'owisaxic jun quiej camello pa ru julil jun t'isombal bak chuwäch ri ropanic jun k'inom ruc' ri Dios rech cätakan puwi', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Sibalaj xquicajmaj wa' ri tijoxelab, xquibij c'u chbil tak quib: ¿Jachin ta c'u lo ri cäcowinic curik ru tobanic ri Dios? —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ri Jesús tajin queuca'yej, xubij c'u chque: Man quecowin tä ri winak chubanic wa', cäcowin c'u na ri Dios che, rumal chi ri Dios cäcowin chubanic ronojel, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ri tat Pedro xuch'abej ri Jesús, xubij: Tat, chilampe la chi ri uj ka yo'm can ri jastak ke, uj c'o uc' la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Xubij c'u ri Jesús: Kas tzij ri quinbij chiwe chi man c'o tä jun ri cuya can ri rachoch, ri rachalal, ru nan u tat, ri rixokil, ri ralc'ual, ri rulew rumal wech in, xukuje' rumal rech ri Utzalaj Tzij re ri Evangelio, ");
INSERT INTO qucTNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ri mat curik na cämic pa tak we k'ij junab ri' jun ciento mul ri e je' tak wa', ri rachoch, rachalal, ru nan, ralc'ual, rulew, pune ruc' c'äx ri cäbantaj che cumal ri winak. Xukuje' curik na ru c'aslemal ri man c'o tä u q'uisic pa tak ri k'ij ri junab ri quepe na, —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","E q'uia chque ri winak ri nim queil wi cämic, man nim tä chi na queil wi pa ri k'ij ri', xukuje' e c'o ri man nim tä queil wi cämic, nim c'ut queil wi na, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","E benak c'u pa ri be, pakalem cäca'n pa Jerusalén, nabejinak c'u ri Jesús chquiwäch ru tijoxelab. Ri e are' sibalaj xquicajmaj u wäch ri Jesús. Conojel ri e teren chrij sibalaj quixe'm quib. Ri Jesús xeusiq'uij jumul chic ri cablajuj u tijoxelab ruc' pa qui tuquiel wi, xuchaplej c'u u bixic chque ri cäban na che. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Xubij c'u chque: Chiwilampe', benam ke, tajin cujpaki pa ri tinimit Jerusalén. Quinjach c'u na in, in ri' ri Ralc'ual ri Dios ri Kas Winak, pa qui k'ab ri qui nimakil ri sacerdotes, xukuje' pa qui k'ab ri tijonelab re ri Pixab. Cäquik'at na tzij pa nu wi' chi quincämisax na, quinquijach c'u na pa qui k'ab ri niq'uiaj winak chic. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Cäquetz'bej na nu wäch, xukuje' cäquichubaj na nu wäch. Quinquirapuj na, quinquicämisaj. Quinc'astaj chi c'u na churox k'ij, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Xekeb c'u ru c'ojol ri tat Zebedeo ruc' ri Jesús, e are' ri tat Jacobo, ri tat Juan, xquibij c'u che: Kajtij, cäkaj chi cäban la chke apachique u wäch tok'ob ri cäkata' che la, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Xubij ri Jesús chque: ¿Jas c'u quiwaj chi quinban chiwe? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Xquibij c'u che: Aretak cänimarisax ri k'ij la, cätakan chi la pa qui wi' conojel, ya la chke chi cujt'uyi na uc' la, chi jun chke cäc'oji pa ri wiquiäk'ab la, ri jun chic pa ri moxk'ab la, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Xubij c'u ri Jesús chque: ¡Man quich'ob taj jas u wäch tok'ob ri quita' chwe! —cächa chque. ¿A quixcowinic quich'ij na ri c'äx ri quinrik na in, quitij c'u na iwe ri c'o pa ri vaso ri quintij na we in? ¿A quixcowinic cäban i kasna' ix jas ri kasna' ri cäban na chwe in? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Xquibij c'u che: Cujcowinic, —xecha che. Xubij c'u ri Jesús chque: Kas tzij quitij na iwe ri c'o pa ri vaso ri quintij na we in, xukuje' cäban na i kasna' jas ri kasna' ri cäban na chwe in, —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Are c'u ri t'uyulem pa ri nu wiquiäk'ab, we ne pa ri nu moxk'ab, man cuya' taj quinya in chiwe. Are wa' quech ri e cha'tal rumal ri Dios chi quet'uyi pa tak ri t'uyulibal ri', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Aretak ri lajuj tijoxelab chic xquita u bixic ronojel wa', xpe coyowal ri e are' chque ri tat Jacobo, ri tat Juan. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Xeusiq'uij c'u ri Jesús, xubij chque: Ri ix iwetam chi ri winak ri ya'tal chque chi quetakan pa qui wi' ri niq'uiaj winak chic, kas tzij e c'o ri' pa qui k'ab. Ri qui nimakil winak quetakan pa qui wi' xukuje', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Man je' tä c'u wa' ri ix, xane apachin chiwe ri craj chi nim quil wi, rajwaxic chi coc na wa' che patänil iwe. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Apachin chiwe ri craj coc che i nimal ix, nabe rajwaxic chi coc na che patänil que conojel, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Are je ri', rumal chi ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak, man in petinak taj rech quinpatänixic, xane rech quinpatänin chque niq'uiaj chic, xukuje' rech quinya ri nu c'aslemal che tojbal re ri qui tzokopixic q'uia winak, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Xeopan c'u pa ri tinimit Jericó. Elem chi c'u bic cuban ri Jesús pa Jericó, e rachi'l c'u ru tijoxelab xukuje' q'uialaj tak winak chic. C'o c'u jun moy achi, Bartimeo u bi', t'uyul chi' ri be, are c'u jun molonel wa', u c'ojol ri tat Timeo. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Aretak xuto chi tajin coc'ow ri Jesús aj Nazaret, co xch'awic, xubij: ¡Tat Jesús, ralc'ual can ri ka mam David, tok'obisaj la nu wäch! —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","E q'uia ri winak ri xquiyajo, xquibij che chi chutz'apij u pu chi'. Ri are' c'ut xa man cuta taj, xane más co na xch'awic, xubij: ¡Ralc'ual can ri ka mam David, tok'obisaj la nu wäch! —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Xtaq'ui c'u ri Jesús, xubij: Siq'uij ba' alak lok, —xcha chque. Xquisiq'uij c'u lok ri moy, xquibij che: ¡Chachajij awanima'! ¡Chatwalijok! Ri Jesús tajin catusiq'uij, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ri are' c'ut xurokij can ru k'u' jela', chanim xwalijic, xe'c, xopan ruc' ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Xch'aw c'u ri Jesús, xubij che: ¿Jas caj la chi quinban che la? —xcha che. Xubij ri moy che: Ajtij, cwaj quinca'y jumul chic, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Xubij ri Jesús che: Cuya' que' la. Ya xutzir la rumal chi xcojon la chwe, —xcha che. Chanim c'ut xcowinic xca'yic, xteri bi chrij ri Jesús pa ri be. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Aretak nakaj chic e c'o wi che ri tinimit Jerusalén, chquiwäch ri tinimit Betfagé ruc' ri tinimit Betania, tajin queoc'ow chuxe' ri Ujuyubal Olivos, ri Jesús xeutak bi quieb chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Xubij chque: Jix pa ri alaj tinimit ri c'o apan chkawäch. Aretak quixopan chila' quirik na jun burro yukulic. Man c'o tä jun winak quiejeninak chrij, —cächa'. Chiquira', chic'ama lok, —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","We c'o jun cubij chiwe: ¿Jas che quiban wa'? —cächa ne chiwe. Chibij che: Xa cajwataj che ri Kajaw Jesús, chanim c'ut cutzelej chi na lok che la, —quixcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Xebe' c'u ri tijoxelab, xequirika c'u ri burro pa ri be, yukul cok chuchi' ri porta. Xquiquir c'ut. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Jujun chque ri a tac'atoj chila' xquibij chque: ¿Jas quibano quiquir ri burro? —xecha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ri tijoxelab xquibij chque jas ru bim bi ri Jesús. Xyi' c'u chque chi cäquic'am bic. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Xquic'am c'u bi ri burro, xquiya che ri Jesús. Xquiya ri qui k'u' chrij, xquiejen c'u ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","E q'uia winak xquilic' ri qui k'u' pa ri be, xukuje' c'o jujun chic ri xequiya u xak tak che' ri xequich'upula pa tak ri juyub. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ri winak ri e nabejinak chuwäch ri Jesús, xukuje' ri e teretoj chrij, co xech'awic, xquibij: ¡Chnimarisax u k'ij ri Dios! ¡Utz re ri petinak pa ru bi' ri Kajaw Dios! —quecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Tewchim ba' ri' ri takanic ri cäpe na pa ka wi'! Tzare wa' ri takanic ri xchaplex nabe rumal ri ka mam David. ¡Chnimarisax u k'ij ri Dios! —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Xopan c'u ri Jesús pa ri tinimit Jerusalén, xoc pa ri nimalaj rachoch Dios. U ca'ylobem chic ronojel, benak chi c'u ri k'ij, xel bic, xe' pa Betania, e rachi'l ri cablajuj u tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Chucab k'ij c'ut, aretak tajin quetzelej lok, e petinak pa ri tinimit Betania, xnum ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Xril c'u apan chinaj jun u che'al higos, räx c'u ru xak. Xe' ri Jesús che rilic we c'o u wäch curika'. Aretak xopan ruc' ri che', man c'o tä c'u u wäch xuriko, xane xak xuwi ru xak c'olic. Je ri', rumal chi mäja' ru k'ijol ri higos. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Xch'aw c'u ri Jesús, xubij che ri che': C'o jun mätijow chic ra wäch, —xcha che. Xquita c'u wa' ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Te c'u ri', aretak xeopan pa Jerusalén, xoc bi ri Jesús pa ri nimalaj rachoch Dios, xuchaplej quesaxic bi ri ajc'ayib, xukuje' ri quequilok' tak jastak chupam ri nimalaj rachoch Dios. Xeutzak ri qui mesa ri q'uexal tak puak, xukuje' xeutzak ri qui tem ri ajc'ay tak palomäx. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Man xuya' tä c'u ri Jesús chi c'o jun coc'ow chupam ri nimalaj rachoch Dios ri ruc'am reka'n. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Xeutijoj c'u ri winak, xubij chque: Tz'ibam c'u wa' pa ru Lok' Pixab ri Dios, cubij: “Ri wachoch in, are jun ja ri cäban wi orar,” —cuchixic. “Je c'u u cojic wa' cumal conojel winak,” —cächa ri'. Xukuje' xubij ri Jesús: Ri alak c'ut, jun cachoch elak'omab banom alak che, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Xquita c'u wa' ri qui nimakil sacerdotes xukuje' ri tijonelab re ri Pixab. Xa je ri' xquitzucuj jas cäca'n chucämisaxic. Je' xca'n wa' rumal chi xquixej quib cho ri Jesús, rumal chi conojel ri winak cäquicajmaj ru tijonic ri Are'. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Are chi' c'ut tajin coc ri ak'ab, xel bi ri Jesús pa ri tinimit. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ak'ab c'ut, chucab k'ij tajin queoc'ow pa ri be, xquilo chi ru che'al higos chaki'jarinak chic ronojel. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Xna'taj c'u wa' che ri tat Pedro, xubij che ri Jesús: Ajtij, ¡chilampe la! Ru che'al higos ri xyaj la, ya chaki'jarinak chic, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Xch'aw c'u ri Jesús, xubij chque ru tijoxelab: ¡Tzrajwaxic ba' quijiquiba iwanima' chrij ri Dios! —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kas tzij ri quinbij chiwe chi apachin ri cubij che we nimalaj juyub ri': “Chawesaj awib chi', chaq'uiäka bi awib pa ri nimalaj ja',” —we cächa che. We ta cubij wa', man cäquieblan tä c'u u c'ux, xane cujiquiba u c'ux chi ri cubij cäbantaj na, kas cäbantaj c'u na wa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Rumal wa' quinbij chiwe chi aretak c'o quita' che ri Dios aretak quiban orar, chijiquiba iwanima' che ri Dios chi quic'amo, cäbantaj c'u na wa' chiwe, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Amak'el c'ut aretak quiban orar, we c'o jun c'äx pa iwanima' chrij jun winak chic, chisacha u mac, rech ri i Tat ri c'o chicaj cuya' cusach ri i mac ix xukuje'. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","We c'u man quisach tä qui mac niq'uiaj chic, ri i Tat ri c'o chicaj man cusach tä ri i mac ix, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Xetzelej chi bic, xebe' pa ri tinimit Jerusalén. Ri Jesús tajin cubinibej u pam ri nimalaj rachoch Dios, aretak ri qui nimakil sacerdotes, ri tijonelab re ri Pixab, xukuje' ri qui nimakil ri winak xeopan ruc'. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Xquibij c'u che: ¿Jachin xtakow la chi cäban la ronojel wa' we ri'? ¿Jachin lo ri yo'winak che la chi je' cäban la wa'? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Xubij ri Jesús chque: Ri in xukuje' c'o ri quinta' chech alak. We cäcowin alak chubixic chwe jas ri quinta', quinbij na chech alak jachin ri yo'winak chwe chi c'o takanic pa nu k'ab rech je' quinban wa', —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Bij alak chwe jachin xtakow ri tat Juan chubanic ri kasna', we are ri Dios o are ri winak, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Xquichapla u tzijobexic quib, xquibij: We cäkabij chi are ri Dios xtakowic, cubij na ri Jesús chke: “¿Jas c'u che man xicoj taj?” —cächa na. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿A cäkabij ta c'ut chi e are ri winak xetakowic? —quecha'. Cäquixej c'u quib chquiwäch ri winak rumal chi elinak chi sak chquiwäch ri winak chi kas tzij ri tat Juan are k'alajisal re ru Lok' Pixab ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Rumal wa' xquitzelej u wäch u tzij ri Jesús, xquibij che: ¡Man ketam taj! —xecha che. Ri Jesús xch'awic, xubij chque: Je c'u ri' ri in man quinbij tä chech alak jachin ri yo'winak chwe chi ri in quinban ronojel wa' we ri', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ri Jesús xuchaplej qui tzijobexic ri winak cuc' tak c'utbal, xubij c'u chque: C'o jun achi ri xuban jun ticbal uvas, xucoralij rij, te c'u ri' xuc'ot jun jul ri cäpitz' wi ri uvas, xuban xukuje' jun tac'aticalaj ja ri cäcoj che chajibal re ronojel, xuya c'u can pa kajomal chque jujun tak ajchaquib, xe' naj pa jun tinimit chic, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Xopan c'u ri k'ij ri cäban ri cosecha rech uvas, ri ajchak'el xutak bi jun patänil re cuc' ri ajchaquib chuc'amic re ru wächinic ri ticbal uvas. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Are c'u ri ajchaquib xquichap ri patäninel, xquich'ayo, xquitak bic, man c'o tä xquiya bi che, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ri ajchak'el ri ticbal uvas xutak c'u bi jun patäninel chic cuc' ri ajchaquib. Ri e are' c'ut xca'n chi abaj ri patäninel ri', xquisoc chujolom, xa etzelal xca'n bi che. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Xutak chi c'u bi jun patänil re, ri ajchaquib c'ut xquicämisaj wa', je ri' xukuje' xca'n chque ri jule' u tako'n chic. Jujun chque xequich'ayo. Jujun chic xequicämisaj. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","C'ä c'o na jun tako'n chic ruc' ri ajchak'el, are c'u ri u c'ojol, ri sibalaj lok' chuwäch. Chuq'uisbal ronojel xutak bi wa' cuc' ri ajchaquib, xubij c'ut: “Kas nim cäquil wi na ri nu c'ojol,” —xcha ri ajchak'el. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ri ajchaquib xquitzijobej quib, xquibij: “Are wa' ri quechben ronojel. ¡Jo', kacämisaj c'ut, rech cäk'ax ronojel wa' pa ka k'ab!” —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Xquichapo, xquicämisaj, xquesaj c'u bi ru cuerpo pa ri ticbal uvas, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Te c'u ri' ri Jesús xuta' chque, xubij: ¿Jas c'u cuban na ri' ri ajchak'el ri ticbal uvas? —cächa ri Jesús. Copan na cuc', queucämisaj na ri ajchaquib, cuya c'u na ru ticbal uvas chque jule' chic, —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿A mat siq'uim alak wa' we tz'ibam ri' pa ru Lok' Pixab ri Dios? Je ri' cubij: Ri abaj ri man xcaj tä ri yacal tak ja, are abaj wa' xcoj che tok'ebal re ri ja. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Je' banom wa' rumal ri Kajaw Dios. Kas cajmabal c'u wa' chkawäch, —cächa', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ri qui nimakil ri winak aj Israel xquitzucuj c'ut jas cäca'n chuchapic ri Jesús rumal chi xquich'obo chi chquij ri e are' xutzijoj wa' we c'utbal ri'. Cäquixej c'u quib chquiwäch ri q'uialaj winak, xa rumal ri' xquiya can ri Jesús, xebe'c. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Xetak c'u bi jujun chque ri tata'ib fariseos ruc' ri Jesús, xukuje' jujun chque ri rachi'l ri tat Herodes che rilic we c'o jas quecowin chubanic rech cäkaj ri Jesús pa qui k'ab. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Aretak xeopanic, xquibij che ri Jesús: Ajtij, ketam chi jicom anima' la, xukuje' chi man cäxej tä ib la chquiwäch ri winak jas pu cäquichomaj ri e are' chij la. Man nim tä c'u quil wi la jun winak chuwäch ri jun chic, xane kas tzij cäc'ut la u beyal ru rayinic ri Dios chquiwäch conojel. ¿A takal chke cäkatoj alcabal che ri César o a man takal taj? —quecha'. ¿A rajwaxic c'ut cäkatojo o a man rajwaxic taj? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Retam c'u ri Jesús chi xak quieb qui wäch, rumal ri' xubij chque: ¿Jas che cäta' alak wa' chwe? ¿A mat xa caj alak chi quinkaj pa k'ab alak? —cächa'. C'amampe alak lok jun puak chnuwäch rech quinwilo, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ri e are' xquic'am lok ri puak, xril c'u wa' ri Jesús, te ri' xubij chque: ¿Jachin c'u ajchak'el we ca'yebal xukuje' we bi'aj ri'? —xcha chque. Xquibij c'u che: Are rech ri César, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Xubij c'u ri Jesús chque: Ya ba' alak che ri César ri rech ri César. Ya c'u alak che ri Dios ri rech ri Dios, —xcha ri Jesús chque. Ri e are' xquicajmaj u wäch ri Jesús rumal ri xubij chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Te ri' xeopan jujun tata'ib saduceos ruc' ri Jesús. Ri winak ri', ri saduceos, cäquibij chi man quec'astaj tä chi na ri cäminakib. Xquita' c'u che ri Jesús, xquibij: ");
INSERT INTO qucTNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","¡Ajtij! Tz'ibam can chke rumal ri ka mam Moisés chi we cäcäm ru chak' jun achi, we cäcäm ri ratz, c'o c'u can ri rixokil, we c'u man e c'o tä can ralc'ual ruc' ri rixokil, rajwaxic c'ut chi ri rachalal ri c'o canok, cäc'uli ruc' ri ixok ri' ri malca'n rech quec'oji can ralc'ual ruc'. Ri ac'alab ri' je' ta ne e rech ri cäminak, —quecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","E c'o c'u wukub achijab e cachalal quib. Ri nabeal xc'uli'c, xcäm c'ut, man c'o tä c'u can ralc'ual ruc' ri rixokil. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ri ucab xc'uli ruc' ri rixnam malca'n, xukuje' xcäm bic, man c'o tä can ralc'ual. Je' xukuje' xuban ri urox achi. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Je c'u ri' xca'n ri wukub achijab, cachalal quib, man xquiya tä can calc'ual. E cäminak chic conojel, xcäm c'u bi ri ixok. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Aretak c'ut quec'astaj na ri cäminakib, ¿jachin chque wa' we wukub achijab ri' cäc'amow ri ixok che rixokil? Xc'oji c'u che quixokil ri wukub, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Xch'aw c'u ri Jesús, xubij chque: Ri alak xa sachinak alak rumal chi man etam tä alak ru Lok' Pixab ri Dios ri Tz'ibtalic. Man etam tä c'u alak ru chuk'ab ri Dios, —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Aretak ri cäminakib quec'astajic, man quec'uli tä chic. Ri ka nan ka tat c'ut man cäquiya tä chi ri calc'ual che c'ulanem, xane e junam chi cuc' ri ángeles ri e c'o chicaj, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Chrij c'u wa' chi quec'astaj na ri cäminakib, c'o na ri cwaj quinbij chech alak: ¿A mat siq'uim alak pa ri wuj ri tz'ibam rumal ri ka mam Moisés jawije' ri cubij wi chi ri Dios c'o chupam ri juwi' q'uix ri tajin cäc'atic, xuch'abej lok ri ka mam Moisés? Je wa' xubij: “In ri' ru Dios ri Abraham, ru Dios ri Isaac, ru Dios ri Jacob,” —xcha ri Dios, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ri ka Dios man are tä Dios quech ri cäminakib, xane quech ri e c'asc'oj. Je ri' k'alaj chi xa sachinak alak, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Xopan c'u jun chque ri tijonelab re ri Pixab ri tajin cätatabenic aretak xquichomala quib. Retam c'ut chi ri Jesús utz u tzelexic u wäch ri qui tzij u banom, rumal ri' xuta' che: ¿Jas ri takanic ri nim na u banic chquiwäch conojel? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ri Jesús xch'awic, xubij che: Are wa' ri tznim na u banic: “Winak aj Israel, ¡chitatabej!” —cächa'. “Ri ka Dios ri Kajaw, xak xuwi ri Are', are Kajaw,” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","“Sibalaj chiwaj ri i Dios ri Iwajaw, chijiquiba ri i c'ux, chijiquiba ri iwanima', chicojo ri i chomanic, chitija c'u ri i chuk'ab chubanic wa',” —cächa'. Tzare c'u wa' ri nabe takanic ri sibalaj nim u banic. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ri ucab takanic ri sibalaj nim na u banic are wa': “Chiwaj ri iwach winak jas ri ix quiwaj iwib,” —cächa'. Man c'o tä chi c'u jun takanic ri nim na u banic chquiwäch wa', —xcha ri Jesús che. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Xubij c'u ri tijonel re ri Pixab che ri Jesús: ¡Utz ri cäbij la, Ajtij! Kas tzij ri cäbij la chi xa jun ri ka Dios, man c'o tä chi jun chuwäch ri Are', —cächa che. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Xukuje' rajwaxic chi jun winak sibalaj craj ri Dios, cujiquiba ru c'ux, cujiquiba ri ranima', cucoj ru chomanic, cutij c'u u chuk'ab chubanic wa'. Xukuje' rajwaxic chi craj ri rach winak je' jas ri are' craj rib. Nim na u banic wa' chquiwäch conojel ri sipanic ri queporox cho ri Dios, xukuje' chquiwäch conojel ri awaj ri quecämisax che sipanic cho ri Dios, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Aretak ri Jesús xuto chi sibalaj cäna'w ri tata' chutzelexic u wäch u tzij, xubij che: Xak jubik' craj man cätakan ri Dios puwi' la, —xcha che. Te c'u ri' man c'o tä chi jun xuchajij anima' chi c'o jas xuta' che ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ri Jesús tajin queutijoj ri winak pa ri nimalaj rachoch Dios, cäch'awic, cubij: ¿Jas che cäquibij ri tijonelab re ri Pixab chi ri Cristo are xak xuwi ralc'ual can ri ka mam David? ");
INSERT INTO qucTNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tzare c'u ri ka mam David cubij rumal ri Lok'alaj Espíritu: Xubij ri Kajaw ri ka Dios che ri Kajaw: “Chatt'uyul pa ri nu wiquiäk'ab, c'ä quinya na chawe chi catch'acanic cattakan pa qui wi' conojel ri cäca'n qui c'ulel chawe,” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","We ri ka mam David cubij: “Kajaw” che ri Cristo, ¿jas ta c'u che cäquibij ri e are' chi ri Cristo are xak xuwi ralc'ual can ri ka mam David? ¡Man je' tä ri'! —xcha chque. Ri winak c'ut, ri sibalaj e q'uia chic qui mulim quib, cäquicot canima' chutatabexic ru tzij ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ri Jesús tajin queutijoj ri winak, cubij chque: Chajij ib alak chquiwäch ri tijonelab re ri Pixab. Ri e are' cäkaj chquiwäch quebinicat pa chärchäk tak catz'iak. Xukuje' cäkaj chquiwäch chi nim queil wi na, cäyi' c'u rutzil qui wäch pa tak ri c'ayibal, pa tak ri be. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Cäquitzucuj ri t'uyulibal ri nimak qui banic pa tak ri rachoch Dios, xukuje' ri t'uyulibal ri nim queil wi pa tak ri ula'nem ri quewi' wi, —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Xukuje' cäquitokij tak ri cachoch ri malca'nib tak ixokib. Te ri' cäquiyuk u tza'm ri qui tzij aretak cäca'n orar rech man k'alaj tä ri etzelal ri tajin cäca'no. ¡Kas nim na ri c'äx cäquirik ri tijonelab re ri Pixab aretak cäk'at na tzij pa qui wi'! —xcha ri Jesús chque ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","T'uyul c'u ri Jesús pa ri nimalaj rachoch Dios chquiwäch tak ri cäxon ri cäyi' wi ri puak ri cäsipax cho ri Dios. Tajin cäca'y chque ri winak ri cäquiya ri qui rajil chupam tak ri cäxon ri'. E q'uia c'u chque ri k'inomab xequiya nimak tak qui rajil. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Xopan c'u jun malca'n chichu' ri meba', xuya xa quieb alaj tak puak, craj ne xa jun centavo rajil ri quieb puak ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ri Jesús xeusiq'uij ru tijoxelab, xubij c'u chque: Kas tzij ri quinbij chiwe, chi we meba'laj malca'n chichu' ri', are nim na wa' ri xusipaj ri are' chquiwäch conojel ri niq'uiaj winak ri qui yo'm qui rajil pa tak ri cäxon ri c'olibal puak. ");
INSERT INTO qucTNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ri e are' qui yo'm jubik' re ri q'uia ri c'o cuc'. Are c'u we malca'n chichu' ri' u yo'm ronojel ri c'o ruc', ronojel ri tzukubal re, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Elem bi re ri Jesús pa ri nimalaj rachoch Dios, jun chque ru tijoxelab xubij che: ¡Ajtij, chilampe la we je'lalaj tak abaj ri', xukuje' tak we ja ri yacom ri' ri sibalaj e cajmabal! —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Xch'aw c'u ri Jesús, xubij che: ¿A cawil conojel we nimalaj tak ja ri e yacom ri'? —cächa'. Man cäcanaj tä c'u can jun abaj puwi' ri jun abaj chic ri mat cäwulix na, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Xe' c'u ri Jesús, e rachi'l ru tijoxelab, pa ri Ujuyubal Olivos ri c'o apan cho ri rachoch Dios. T'uyul c'u ri Jesús chila', ri tat Pedro, ri tat Jacobo, ri tat Juan, xukuje' ri tat Andrés xquita' che ri Are' pu tuquiel wi, ");
INSERT INTO qucTNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","xquibij: Cäkaj chi cäbij la chke jampa' cäbantaj na wa'. ¿Jas u wäch etal cäban na chuc'utic chkawäch chi xopan ri k'ij ri' ri quebantaj na conojel tak wa' ri bim la chke? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ri Jesús xch'awic, xubij chque: ¡Chichajij iwib c'o jachin jun mixsubuwic! —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","E q'uia c'ut ri quepe na, cäquicoj na ri nu bi', cäquibij: “¡In ri' ri Cristo!” —quecha na. E q'uia c'u ri' ri quequisub na, —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Aretak quita nimalaj tak ch'oj, xukuje' quita u tzijoxic tak ch'oj jawije' tak chi', mixej iwib. Rajwaxic chi cäbantaj na wa'. C'ä mäjok c'u ri q'uisbal re ri k'ij junab ri', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Cäch'ojin c'u jun tinimit ruc' ri jun tinimit chic, xukuje' cäch'ojin jun nim takanel ruc' jun nim takanel chic. Quepe c'u na q'uia cäbrakan jawije' tak chi', cäpe na wi'jal xukuje', ri winak c'ut sibalaj cäquituquij na quib. Xak c'u chaplebal wa' re ronojel ri c'äx ri cäpe na pa qui wi' ri winak, —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","¡Chichajij ba' iwib! —cächa'. Quixjach c'u na pa tak qui k'ab ri qui nimakil winak ri quetakan pa qui wi', xukuje' quixch'ay na chquiwäch ri qui nimakil ri winak pa tak ri rachoch Dios ri cäquimulij wi quib ri winak. Quixtac'abax na chquiwäch k'atal tak tzij, xukuje' chquiwäch takanelab ri nimak qui banic rumal wech in rech quik'alajisaj na ri Utzalaj Tzij re ri Evangelio chquiwäch ri e are', —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","C'ä mäjok c'u copan ri q'uisbal re ri k'ij junab ri', rajwaxic cätzijox na we Utzalaj Tzij ri' re ri Evangelio chque conojel qui wäch winak cho ruwächulew, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Aretak quixc'am na bic rech quixjach chquiwäch ri k'atal tak tzij, mixej iwib, michomaj bic jas ri quibij na chque, xane chibij ri cäyi' chiwe rumal ri Dios pa ri k'ij ri'. Man ix tä c'ut ri quixtzijon na, xane are ri Lok'alaj Espíritu. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ri winak quequijach na ri cachalal pa cämisaxic, ri nan tat quequijach na ri calc'ual pa cämisaxic. Ri alc'ualaxelab cäquiyac na quib chquij ri qui nan qui tat, quequijach na pa cämisaxic. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","¡Conojel ri winak cäquetzelaj na i wäch xa rumal wech in! —cächa'. Are c'u ri cäch'ijowic c'ä cäq'uis na ronojel, curik na ri' ru tobanic ri Dios, —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ri ka mam Daniel, jun chque ri k'alajisal re ru Lok' Pixab ri Dios, xutz'ibaj ojer chrij ri “itzelalaj äwas ri quetzelan ronojel.” ¡Jachin ri cusiq'uij wa', ri tz'ibtal waral, chuch'obo' jas ri' ri äwas ri cubij chi'! Aretak quiwil wa' cäc'oji chila' jawije' ri man ya'tal tä wi, rajwaxic chi ri winak ri e c'o pa Judea queanimaj bi pa tak ri juyub. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ri winak ri e c'o puwi' tak cachoch, aninak chekaj lok, meboc chi bi chupam ri ja chuc'amic bi jun jasach. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Xukuje' ri e c'o pa ri juyub mätzelej bi cho ja chuc'amic ri qui k'u'. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Sibalaj c'äx que ri ixokib ri yawab tak winak chic pa tak ri k'ij ri', xukuje' ri e c'o alaj tak cal ri c'ä quetu'nic! ");
INSERT INTO qucTNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","¡Chibana ba' orar, chixbochi'n che ri Dios chi mäc'ulmataj ronojel wa' pa tak ri u k'ijol ri tew! ");
INSERT INTO qucTNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Je ri', rumal chi cäpe na nimalaj c'äxc'ol pa tak ri k'ij ri', ri man c'olinak tä ri' tzpa ru chaplexic lok ru banic ruwächulew rumal ri Dios c'ä pa tak we k'ij ri'. Te c'u ri' man c'o tä jumul ri quepe chi na c'äxalaj tak k'ij junam ruc' ri c'äxc'ol ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","We ta ri Kajaw Dios mat cubano chi xak k'atatal k'ij cäc'oji we c'äxc'ol ri', mat c'o jun winak ri' ri cäc'asi canok. Ri Dios c'ut u banom chi xak k'atatal k'ij cäc'oji wa' rumal chi queraj ri e cha'tal rumal ri Are'. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","We c'u c'o jun ri cubij chiwe: “¡Chiwilampe', c'o ri Cristo chi ri'!” We cubij: “¡Chiwilampe', c'o jela'!” —we cächa'. ¡Micoj ba'! —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Quepe na winak ri cäca'n che quib chi e are ri Cristo, xukuje' quepe chi na jule' chic ri cäca'n che quib chi e k'alajisal tak re ru Lok' Pixab ri Dios. Queca'n c'u na etal, xukuje' cajmabal che qui subic ri winak ri e cha'tal rumal ri Dios we quecowinic, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","¡Chiwila ba' iwib! Nu bim chi c'u apan ronojel wa' chiwe, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Pa tak ri k'ij ri' aretak oc'owinak chic ri nimalaj c'äx ri', ri k'ij cäk'ekumar na, ri ic' c'ut man cätunun tä chic. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Quetzak c'u na lok ri ch'imil cho ri caj. Queslabisax c'u na conojel ri c'o qui chuk'ab ri e c'o cho ri caj, je' jas ri k'ij, ri ch'imil, ri ic', xukuje' niq'uiaj chic, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Te c'u ri' quilitaj c'u na chi ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak, quinpe pa tak ri sutz' ruc' nimalaj nu chuk'ab, cänimarisax c'u nu k'ij, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Te ri' queintak na bi ri ángeles rech quequimulij ri winak ri e cha'tal rumal ri Dios pa ri relbal k'ij, pa ru kajbal k'ij, pa ri u moxk'ab ri relbal k'ij, pa ru wiquiäk'ab ri relbal k'ij, tzpa ronojel ri cajulew, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Chich'obo ba' ri c'utbal chrij ru che'al higos: Aretak queräxar ru k'ab, quetuxin c'u ru xak, iwetam ri' chi xak jubik' chic man copan ri k'alaj. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Je ri' xukuje' ri ix aretak quiwil qui c'ulmaxic ronojel wa', quiwetamaj na chi xak jubik' chic man copan ri k'ij ri quinpetic. Je' ta ne chi in c'o chi' ri uchibe. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Kas tzij ri quinbij chiwe chi quebantaj na ronojel wa' ri xinbij chiwe c'ä mäjok quecäm ri winak re we k'ij junab ri', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Cäsach na u wäch ri caj, xukuje' ruwächulew, are c'u ri tzij ri nu bim chiwe quebantaj na wa', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Man c'o tä c'u jachin jun ri retam jampa' copan ri k'ij ri', o ri hora. Man quetam tä ri ángeles, man retam tä ru C'ojol ri Dios, xane xak xuwi ri ka Tat Dios retam wa', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Rumal wa', ¡chiwila ba' iwib, chixc'asc'atok, chibana orar! ¡Man iwetam tä c'ut jampa' copan ri k'ij ri'! —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Are je' jas jun achi benam cubano, naj que' wi. C'ä mäja' quel bic cho ja, cuya can ronojel pa qui k'ab ri patänil tak re, xukuje' cuya can ri qui chac chquijujunal. Cätakan can che ri chajil uchibe chi utz rilic ri ja cubano, —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","¡Chiwila ba' iwib, chixc'asc'atok! rumal chi man iwetam taj jampa' cäpe ri ajchak'el ja, we tajin coc ri ak'ab aretak cäpetic, we pa niq'uiaj ak'ab, we pa ri hora ri cok' ri ama' äc', we tajin cäpe chi ru sakiric. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Chiwila ba' iwib rech we xak te'talic cäpetic mixulurika ne tajin quixwaric. ");
INSERT INTO qucTNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ri quinbij chiwe, quinbij c'u chque conojel. ¡Chiwila ba' iwib, chixc'asc'atok! —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Xa quieb k'ij chic craj che ri nimak'ij, Pascua u bi', xukuje' ri nimak'ij re ri caxlan wa ri man cäyi' tä ch'äm ruc'. Ri qui nimakil sacerdotes, xukuje' ri tijonelab re ri Pixab cäquitzucuj jas cäca'n na chuchapic ri Jesús ruc' subunic rech cäquicämisaj. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Xquibij c'ut: ¡Mächap pa ri nimak'ij rech metuquin ne ri winak! —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Are c'u ri Jesús c'o pa ri tinimit Betania cho rachoch ri tat Simón, jun tata' ri xc'oji itzel ch'a'c che. T'uyul c'u ri Jesús chi' ri mesa, xopan jun ixok ruc'am jun c'olibal cunabal re alabastro, c'o c'oc'alaj cunabal re kas nardo chupam. Sibalaj pakal rajil wa' we cunabal ri'. Ri ixok xupaxij ri c'olibal cunabal, xutix c'u ri cunabal pu jolom ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","E c'o c'u jujun chila' ri xa xpe coyowal, xquibij chbil tak quib: ¿Jas che xak xtix wa' we cunabal ri'? —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","¡Xq'uiyix ta c'u wa' che oxib cientos quetzales ruc' u wi', xyi' ta c'u ri puak chque ri meba'ib! —xecha'. Xeyok'on c'u che ri ixok. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Xubij c'u ri Jesús: ¿Jas che quiya latz' che ri ixok? ¡Miban wa' che! ¡Jun nimalaj utzil c'ut ru banom chwe! —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Amak'el c'ut e c'o ri meba'ib iwuc', cuya' c'ut quiban utzil chque aretak quiwaj u banic wa'. Are c'u ri in man in c'o tä iwuc' ronojel k'ij. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","We ixok ri' u banom jas ri xcowin chubanic, ri xpe pa ranima'. U cojom c'u bi ri c'oc'alaj cunabal che ri nu cuerpo c'ä mäjok quinmukic. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kas c'u tzij ri quinbij chiwe chi apawije' ta ne ri cätzijox wi na ri Utzalaj Tzij re ri Evangelio cho ronojel ruwächulew, ri u banom we ixok ri' cätzijox na che na'tabal re, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Te c'u ri' xel bi ri tat Judas Iscariote, jun chque ri cablajuj tijoxelab, xe' ri are' cuc' ri qui nimakil sacerdotes chuchomaxic cuc' jas cuban chujachic ri Jesús pa qui k'ab. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Aretak xquito, xequicotic, xquibij c'u che ri tat Judas chi cäquiya na puak che. Ri tat Judas c'ut tajin cäreyej chi copan jun utzalaj k'ij chujachic ri Jesús pa qui k'ab. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pa ri nabe k'ij re ri nimak'ij re ri caxlan wa ri man cäyi' tä ch'äm ruc', aretak cäcämisax ri chij che ri nimak'ij Pascua, ru tijoxelab ri Jesús xquibij che: ¿Jawije' caj wi la chi cäka'n wi ri wi'm re ri Pascua rech cätij la? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Xeutak c'u bi quieb chque ru tijoxelab, xubij c'u chque: ¡Jix pa ri tinimit! Quixurika na jun achi ruc'am jun k'ebal joron. Chiterenej bic. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Jawije' c'u ri coc wi ri achi, chibij c'u che ri ajchak'el ri ja: “Cuta' ri Kajtij che la, cubij: ¿Jawije' quinban wi ri wi'm re ri Pascua ri quintij junam cuc' ri nu tijoxelab?” —cächa ri', —quixcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ri are' cuc'ut na chiwäch jun nim ja pa ru cawik ja ri ya suc'umatal chic. Chibana u banic ri wi'm re ri Pascua chke uj chila', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Xebel c'u bi ri tijoxelab, xebe' pa ri tinimit, xquirika ronojel jas ri xubij bi ri Jesús chque. Xca'n c'u u banic ri wi'm re ri Pascua chila'. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Aretak chak'ab chic xopan ri Jesús, e rachi'l c'u ri cablajuj tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","E t'uyul chila' chi' ri mesa, tajin quewi'c aretak ri Jesús xubij chque: Kas tzij ri quinbij chiwe chi c'o jun chiwe ri quinujach na, are jun ri tajin cäwi' wuc', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ru tijoxelab sibalaj xebisonic. Chquijujunal c'ut xquichaplej u ta'ic che ri Jesús: ¿A man xa in ri'? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Xch'aw c'u ri Jesús, xubij chque: Are jun chque ri cablajuj tijoxelab ri curub ru wa wuc' pa ri lak, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Je' quinel na in jas ri tz'ibtal pa ru Lok' Pixab ri Dios chwij in, in ri' ri Ralc'ual ri Dios ri Kas Winak. ¡C'äx c'u curik na ri achi ri quinjachow na in! ¡Utz na re we achi ri' we ta mat xil u wäch! —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Aretak tajin quewi'c, ri Jesús xuc'am ri caxlan wa, xumaltioxij wa' che ri Dios, xuban orar puwi' chutewchixic. Te ri' xupiro. Xuya chquiwäch ru tijoxelab, xubij: ¡Chic'ama iwe! Je' ta ne are nu cuerpo wa', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Te c'u ri' xuc'am jun vaso, xumaltioxij c'u wa' che ri Dios. Xuya ri vaso chquiwäch, xquitij c'u que conojel. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Xubij c'u ri Jesús chque: Je' ta ne are nu quiq'uel wa' ri cujiquiba ri c'ac' trato ri u banom ri Dios cuc' ri winak. Cäturuw c'u na wa' ri nu quiq'uel rech cuban utzil chque q'uia winak, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kas tzij ri quinbij chiwe chi man quintij tä chi na we ri vino re uvas, c'ä pa ri k'ij ri quintij na ri c'ac' vino chila' jawije' ri cätakan wi ri Dios, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Te c'u ri' xquibixoj jun bix ri cuya u k'ij ri Dios, xebel bic, xebe' pa ri Ujuyubal Olivos. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Xubij c'u ri Jesús chque: Ri ix iwonojel quibisoj na nu wäch, quiniya na can cämic chak'ab. Je' c'u tz'ibam canok pa ru Lok' Pixab ri Dios: “Quinsoc na ri ajyuk', quejabun c'u na ri chij,” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Aretak c'u in c'astajinak chic chquixol ri cäminakib, quinnabej na bi chiwäch, quine' na pa Galilea, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Xubij c'u ri tat Pedro che ri Jesús: ¡Pune conojel cäquiya la canok, ri in man je' tä ri' quinbano! —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Xubij c'u ri Jesús che: Kas tzij ri quinbij chawe chi tzpa we ak'ab ri' cabij na at oxmul chi man awetam tä nu wäch mäjok cok' camul ri ama' äc', —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ri tat Pedro tzco na xch'awic, xubij: Pune rajwaxic chi quincäm na uc' la, kas tzij chi man quinbij taj chi man wetam tä wäch la, —xcha che. Je' c'u xquibij xukuje' conojel ri tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Aretak xeopan pa ri ch'äkap ulew, Getsemaní u bi', xubij ri Jesús chque ru tijoxelab: Chixt'uyul can chi' c'ä quinto'taj na chubanic orar, —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Xeuc'am bi ri tat Pedro, ri tat Jacobo, ri tat Juan ruc'. Xuchaplej c'u t'ujuwem ri ranima' ri Jesús, xc'äxc'ob c'u wa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Xubij c'u chque: ¡Xa are cuq'uis rib ri wanima' chupam ri bis! Chixcanaj can chi', chixc'asc'atok, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Te ri' xbin chi apan jubik' ri Jesús, xutzak rib pa ulew, tajin cuban orar, xutz'onoj che ri Dios chi we ta c'o banom wi, mat curik we c'äx ri' ri petinak chrij. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Aretak xuban orar, xubij: ¡Abba! ¡Tat! Ri lal cäcowin la che ronojel. Chesaj bi la we vaso ri' chnuwäch. Bana ba' la chi man cäpe tä we c'äx ri' chwij. Mäban c'u la xa jas ri cwaj in, xane jas ri caj la cäban la chwe, —xcha che ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Xtzelej c'u lok ri Jesús cuc' ru tijoxelab, xeurika', tajin quewaric. Xubij c'u che ri tat Pedro: ¿A catwaric, Simón? ¿A mat catcowinic catc'asi jun hora wuc'? —cächa che. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Chiwila ba' iwib, chixc'asc'atok, chibana orar rech man quixtzak taj aretak quixtakchi'x che mac. Kas tzij ri iwanima' craj u banic utzil, man c'o tä c'u u chuk'ab ri i cuerpo chubanic wa', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Xe' jumul chic ri Jesús, xubana orar, je' xubij jas ri xubij nabe. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Te c'u ri' xtzelej chi lok, xeurika ru tijoxelab chi jumul chic tajin quewaric rumal chi sibalaj c'äx qui waram. Man xquirik tä c'u ru tijoxelab jas cäquibij che ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Churoxmul xtzelej chi lok ri Jesús cuc', xubij c'u chque: Chixwar ba', chixuxlanok, —xcha'. Te ri' xubij: ¡Ruc' wa'! —cächa'. Opaninak c'u ri hora. Quinjach c'u na in, in ri' ri Ralc'ual ri Dios ri Kas Winak, pa qui k'ab ri ajmaquib, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Jo' ba'! ¡Chixwalijok! Chiwilampe', xpe ri jachal we, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","C'ä tajin cäch'aw ri Jesús aretak xopan ri tat Judas, jun chque ri cablajuj u tijoxelab. E petinak ruc' ri are' q'uia winak, cuc'am machetes, cuc'am che'. E takom lok cumal ri qui nimakil sacerdotes, cumal c'u tak ri tijonelab re ri Pixab, xukuje' ri qui nimakil ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ri tat Judas, ri jachal re ri Jesús, u yo'm c'u can jun etal chque ri winak, xubij: Ri quintz'umaj, are ri' ri Jesús. ¡Chichapa'! Kas utz chibana bi chujat'ixic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Aretak xopanic, chanim xkeb ruc' ri Jesús, xubij: ¡Kajtij, Kajtij! —xcha che. Xutz'umaj c'ut. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Xquichap c'u ri Jesús, xquiyut bic. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jun chque ri e tac'atoj chila' xuc'am ru machete, xusoc ri patänil re ri qui nimal sacerdotes, xuk'at apan ru xiquin. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Xubij c'u ri Jesús chque ri winak: ¿Jas lo wa' chi je' ta ne chrij jun elak'om elinak wi alak lok? C'amom alak lok ri machetes alak, ri che' alak che nu chapic, —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ronojel k'ij in c'o uc' alak pa ri nimalaj rachoch Dios, tajin quinya tijonic chech alak, man xinchap tä c'u alak. Je' c'u cäban na wa' chwe rech je' cäban na jas ri tz'ibam chwij pa ru Lok' Pixab ri Dios, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Chanim c'ut conojel ru tijoxelab xquiya can ri Jesús, xeanimaj bic. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","C'o c'u jun ala teren chrij ri Jesús, xak jun sak atz'iak u k'u'm chrij. Xchap c'u ri' cumal ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ri are' c'ut xuya can ri ratz'iak pa qui k'ab, ch'analic xanimaj bi chquiwäch. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Te ri' xquic'am bi ri Jesús cho ri kas qui nimal sacerdotes. Xquimulij c'u quib conojel ri qui nimakil sacerdotes, ri qui nimakil ri winak, xukuje' ri tijonelab re ri Pixab. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ri tat Pedro c'ut xuterenej bi ri Jesús chinaj, xopan c'u pa ri uwoja re ri rachoch ri kas qui nimal sacerdotes. Xt'uyi c'u ri tat Pedro chila' cuc' ri chajil tak re ri nimalaj rachoch Dios, tajin cumik' rib chrij ri k'ak'. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ri qui nimakil sacerdotes cuc' conojel ri qui nimakil ri winak tajin cäquitzucuj jas u wäch mac ri cäk'alajisax chrij ri Jesús rech cäcämisaxic. ¡Man xquirik tä c'ut! ");
INSERT INTO qucTNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","E q'uia c'u ri xca'n tzij chrij aretak xca'n k'alajisanic. Man xak tä c'u jun u wäch ri xquibij. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Te ri' xewalij jujun ri cäca'n tzij chrij ri Are', xquibij: ");
INSERT INTO qucTNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Ka tom ri xubij: “Ri in quinwulij na we nimalaj rachoch Dios ri' ri banom cumal ri winak, quinyac chi c'u na pa oxib k'ij jun ri man banom tä wa' cumal winak,” —xcha ri', —xecha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Man ruc' tä wa' xjunamataj u wäch ri xquibij chrij. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Xwalij c'u ri kas qui nimal sacerdotes, xtaq'ui chquiwäch conojel, xuta' che ri Jesús, xubij che: ¿A mat c'o jas jun tzij cabij chutzelexic u wäch ri tajin cäbix chawij? ¿Jas pu wa' we tajin cäquik'alajisaj we achijab ri' chawij? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Man cäch'aw tä c'u ri Jesús, man c'o tä wi jas cubij che. Ri kas qui nimal sacerdotes xuta' jumul chic che ri Jesús, xubij: ¿A kas at ri' ri Cristo, ru C'ojol ri Dios ri cäkaya u k'ij? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Xch'aw c'u ri Jesús, xubij che: ¡In ri', tat! —cächa che. ¡Quinil c'u na alak ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak, aretak in t'uyul pa ru wiquiäk'ab ri Dios ri sibalaj c'o u chuk'ab, xukuje' quinil na alak aretak quinpe na cuc' tak ri sutz' chicaj! —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Are c'u ri kas qui nimal sacerdotes xurak'achij ru k'u' chuc'utic chi sibalaj c'äx cuna' ri cubij ri Jesús. Xubij c'u ri tata': ¿Jas c'u che e rajwaxic chi niq'uiaj k'alajisanelab chrij? ");
INSERT INTO qucTNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","¡I tom c'u ri ix chi xubij ri äwas u bixic chrij ri Dios! ¿Jas c'u quichomaj? —xcha chque. Conojel c'ut xquik'at tzij puwi', xquibij chi rajwaxic cäcämisaxic. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","E c'o c'u jujun xquichaplej u chubaxic. Xquich'uk ru palaj, xquich'ayo, xquibij c'u che: ¡Chach'obo ne jachin ri xatuch'ayo! —xecha che. Xukuje' ri chajinelab xquicoj k'ab chupalaj. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","C'ä c'o ri tat Pedro iquim pa ri uwoja aretak xpe jun chque ri alitomab, ri ajic' rech ri kas qui nimal sacerdotes. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Aretak xril ri tat Pedro chi tajin cumik' rib cho ri k'ak', co xca'y che, xubij: ¡Ri at xukuje' xatc'oji ruc' ri Jesús aj Nazaret! —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Are c'u ri tat Pedro xresaj rib chupam, xubij: ¡Man wetam tä u wäch ri', man quinch'ob tä c'u ri' ri tajin cabij! —xcha che. Xel c'u bi chila', xopan chi' ri uchibe. Are chi' xok' ri ama' äc'. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ri ali xril ri tat Pedro jumul chic, xuchaplej chi na u bixic chque ri e tac'atoj chunakaj, xubij: ¡We achi ri' are jun chque ri e rachi'l ri Jesús! —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ri tat Pedro xresaj chi c'u rib jumul chic chupam, xubij chi man cuch'ob tä u wäch ri Jesús. Man naj tä c'u ri' ri e tac'atoj chila' xquibij jumul chic che ri tat Pedro: Kas tzij at jun chque rumal chi at aj Galilea. Xukuje' xak junam catch'awic jas ri winak aj Galilea, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Co c'u xch'aw ri tat Pedro, xuban c'u jurar cho ri Dios, xubij: ¡Kas tzij ri' chi ri in man wetam tä u wäch ri achi ri' ri tajin quitzijoj! —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Xok' chi c'u na ri ama' äc' chucamul. Xna'taj c'u che ri tat Pedro ru bim ri Jesús che: “Cabij na at oxmul chi man awetam tä nu wäch mäjok cok' camul ri ama' äc',” —xcha che. Aretak ri tat Pedro xna'taj wa' che, xutzokopij c'u ok'ej. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Sibalaj ak'ab c'u ri' xquimulij quib ri qui nimakil sacerdotes, ri qui nimakil ri winak, xukuje' ri tijonelab re ri Pixab cuc' ri niq'uiaj nimak tak tata'ib. Te c'u ri' conojel we nimak tak tata'ib ri' xquitala' qui no'j chuchomaxic jas cäca'no. Xquiyut c'u bi ri Jesús, xquic'am bic, xquijacha c'u cho ri tat Pilato. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Xuta' c'u ri tat Pilato che, xubij: ¿A at ri' ri cattakan pa qui wi' ri winak aj Israel? —xcha'. Xch'aw c'u ri Jesús, xubij: Je ri' jas ri cäbij la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Q'uia tzij c'ut xca'n ri qui nimakil sacerdotes chrij ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Xuta' c'u ri tat Pilato jumul chic che ri Jesús, xubij: ¿A mat c'o jas ri cabij? ¡Chatampe' chi q'uia ri cäquibij chawij! —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Man c'o tä jun tzij chic xubij ri Jesús, je c'u ri' chi xucajmaj wa' ri tat Pilato, man xurik tä chic jas cubano. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Are c'u ri tat Pilato nak'atal wi chi pa ri nimak'ij ri' ri are' cuban jun tok'ob chque ri winak, cutzokopij bi jun ajpache', apachin ta ne ri cäquita' che. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","C'o c'u jun achi, Barrabás u bi', yo'm pa che' junam cuc' ri rachi'l rumal chi xca'n cämisanic aretak ri winak re ri tinimit xquiwalijisaj quib chquij ri quetakan pa qui wi'. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Xquimulij c'u quib ri winak chuwäch ri tat Pilato, xquichaplej u tz'onoxic che chi chubana tok'ob chque, jas ri nak'atal wi ri are'. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Xch'aw c'u ri tat Pilato, xubij chque: ¿A quiwaj chi quinban tok'ob chiwe, quintzokopij bi ri tata' ri c'o u takanic pi wi' ix ri winak aj Israel? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Cuch'ob c'u ri tat Pilato chi xa rumal chi c'äx cäquina' ri qui nimakil sacerdotes che ri Jesús qui jachom ri Are' pu k'ab. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ri qui nimakil sacerdotes c'ut tajin cäca'no chi ri winak cäquituquij quib, xa cäquibij chi más utz na are cuban tok'ob chque, cätzokopix bi ri Barrabás. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Xch'aw chi ri tat Pilato, xuta' c'u chque: ¿Jas c'u ri quiwaj chi quinban che ri achi ri quibij ix chi are c'o u takanic pi wi' ix ri ix winak aj Israel? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ri winak co xquirak qui chi', xquibij: ¡Chripok! —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Xch'aw c'u ri tat Pilato, xuta' chque: ¿Jas che? ¿Jas etzelal u banom wa' we achi ri'? —xcha chque. Co c'u na xech'aw ri winak, xquibij: ¡Chripok! —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ri Pilato are c'u craj u banic xa jas ri qui rayinic ri winak. Xuban chque ri tok'ob ri xquita', xutzokopij c'u bi ri Barrabás. Xtakan c'ut chi cäch'ay ri Jesús, te c'u ri' xujach bic rech cäripic. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Xepe c'u ri soldados, xquic'am bi ri Jesús pa ri uwoja re ri rachoch ri nim k'atal tzij, xequisiq'uij ri niq'uiaj soldados chic rech cäquimulij quib cuc'. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Xquicoj c'u jun atz'iak morada chrij ri Jesús. Xukuje' xquicoj jun corona re quemom q'uix chujolom. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Chanim c'ut xquichaplej u rakic qui chi' chrij, xquibij: Lal ri' ri cätakan la pa qui wi' ri winak aj Israel, ¡chnimarisax k'ij la! —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Xquich'ay c'u chujolom ruc' jun aj, xquichubaj, xexuqui chuwäch, xak cäca'n che quib chi tajin cäquik'ijilaj. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Aretak xeto'taj che retz'bexic u wäch, xquijolij ru k'u' ri morada chrij, xquicoj ri kas ratz'iak ri Are' chrij, te c'u ri' xquic'am bi churipic cho ri cruz. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","C'o c'u jun achi aj Cirene, Simón u bi', qui tat ri tat Alejandro, ri tat Rufo. Ri are' tajin coc'owic, u petic c'u ri' pa juyub. Xquicoj qui chuk'ab che rech cutelej bi ru cruz ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Xquic'am c'u bi ri Jesús chila' jawije' ri cäbix Gólgota che. Quel cubij wa' ri bi'aj ri': Ri Juyub re ru Bakil Jolomaj, —cuchixic. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Xquiya c'u vino yujtal ruc' mirra chuwäch ri Jesús rech cutijo. Man xutij tä c'ut. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Aretak qui ripom chic cho ri cruz, ri soldados xquijach ri ratz'iak ri Jesús chquiwäch, xquesaj c'u suerte chrij rech cäquilo jas ri cäquic'am bi chquijujunal. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ak'ab c'ut xrip ri Jesús pa ri u belej hora. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Cojom c'u puwi' ri cruz jun tz'ibtalic ri cubij jas che cäk'at tzij puwi' ri Jesús rech cäripic, cubij c'ut: RI NIM TAKANEL PA QUI WI' RI WINAK AJ ISRAEL, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Xerip c'u quieb elak'omab ruc', jun pu wiquiäk'ab, jun pu moxk'ab. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Xbantaj c'u can ri tz'ibam chrij pa ru Lok' Pixab ri Dios ri cubij: “Je' ta ne chi are jun chque ri banal tak etzelal ri xk'at tzij puwi',” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ri queoc'owic cäquiyok'o, cäquisutisa' ri qui jolom, cäquibij: ¡Aa! ¡At ri' ri cabij chi catcowinic cawulij ri nimalaj rachoch Dios, xa c'u pa oxib k'ij cayac chi na wa' jumul chic! —quecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡Chato' ba' awib, chatkaj c'u lok cho ri cruz! —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Je' xukuje' ri qui nimakil sacerdotes cuc' ri tijonelab re ri Pixab cäquitze'j u wäch, cäquich'abej quib, cäquibij: ¡Xtob chque niq'uiaj chic, man cäcowin tä c'u ri Are' chuto'ic rib! —quecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Chkaj ba' lok cho ri cruz ri Cristo “ri Nim Takanel quech ri winak aj Israel” rech cäkilo, ¡cujcojon c'u na che! —xecha'. Ri e ripom ruc' ri Jesús xukuje' xquitze'j u wäch. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Aretak xurik ri cablajuj hora, xk'ekumar ronojel ruwächulew oxib horas. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tzpa ri rox hora re ri benak k'ij xurak u chi' ri Jesús, co xch'awic, xubij: Eloi, Eloi, ¿lama sabactani? —xcha'. Je' quel cubij wa': Nu Dios, nu Dios, ¿jas che in wonobam la canok? —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Jujun c'u chque ri e tac'atoj chila' xquita wa', xquibij: ¡Chitampe'! —quecha'. Tajin cusiq'uij ri ka mam Elías ri ojer k'alajisal re ru Lok' Pixab ri Dios, —xecha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Te c'u ri' jun chque ri winak xutic anim, xe'c, xurubu jun estropajo pa ch'äm vino, xuya wa' puwi' jun aj, xuya ak'an chuwäch ri Jesús rech cutijo, xubij c'u apan chque ri winak: ¡Chiweyej ba'! Chkila na we cäpe ri ka mam Elías chukasaxic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Sibalaj co xurak u chi' ri Jesús, xel ranima', xcäm c'u ri Are'. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Are c'u ri tasbal u pam ri nimalaj rachoch Dios xjisjobic, quieb xubano, xpe ajsic c'ä iquim. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ri qui nimal soldados aj Roma, ri tac'al cho ri Jesús, aretak xuto xurak u chi' ri Jesús, xukuje' xrilo jas xubano aretak xcämic, xubij: ¡Kas tzij u C'ojol ri Dios wa' we achi ri'! —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","E c'o c'u jujun ixokib ri tajin queca'y apan chinaj. Chquixol ri e are' c'o ri nan María aj Magdala, xukuje' ri nan María u nan ri tat Jacobo ri más c'ac'al na, ri xukuje' are u nan ri tat José wa'. C'o xukuje' ri nan Salomé cuc'. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Aretak ri Jesús xc'oji pa Galilea, we ixokib ri' xebin ruc', xepatänin che. Xukuje' e c'o chila' q'uia chque ri niq'uiaj ixokib chic ri e opaninak ruc' ri Jesús pa Jerusalén. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Benak chi ri k'ij pa ri k'ij ri cäban u banic ronojel che ri k'ij re uxlanem, are c'u víspera wa' re ri k'ij ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Xopan c'u ri tat José aj Arimatea, jun chque ri qui nimakil ri winak aj Israel ri tznim quil wi. Ri are' xukuje' cu'l u c'ux che reyexic chi cäpe na ri Dios rech cätakan na pa qui wi' ri winak. Xuchajij c'u anima', xoc cho ri tat Pilato chuta'ic chi cäyi' ru cuerpo ri Jesús che. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Xucajmaj wa' ri tat Pilato chi sibalaj chanim xcäm ri Jesús. Xtakan c'u chusiq'uixic ri qui nimal ri soldados chuwäch, xuta' che we kas tzij cäminak chic. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Aretak ri qui nimal soldados xubij chi kas tzij cäminak chic ri Jesús, ri tat Pilato xuya ru cuerpo che ri tat José. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ri tat José c'ut xulok' jun payu', xukasaj ru cuerpo ri Jesús, xupis c'u chupam ri payu'. Te ri' xuya chupam jun mukubal ri c'otom cok pa ri abaj. Xuwolkotij c'u jun abaj chuchi' ri mukubal. ");
INSERT INTO qucTNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ri nan María aj Magdala ruc' ri nan María u nan ri tat José tajin cäquilo jawije' ri cäyi' wi can ru cuerpo ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Oc'owinak chi c'u ri k'ij re uxlanem, ri nan María aj Magdala, xukuje' ri nan María u nan ri tat Jacobo ruc' ri nan Salomé, xquilok' c'oc'alaj tak cunabal rech quequibila chrij ru cuerpo ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sibalaj ak'ab c'ut pa ri nabe k'ij re ri semana xebe' ri ixokib chuchi' ri mukubal. Elinak chi c'u lok ri k'ij aretak xeopanic. ");
INSERT INTO qucTNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Xquich'abej c'u quib, xquibij: ¿Jachin ta c'u lo ri cäwolkotin na apan ri abaj chkawäch? ¡Tzchuchi' ri mukubal c'ut c'o wi! —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Aretak c'ut xeca'yic, c'ä te' xquilo chi wolkotim chi apan ri nimalaj abaj ri'. ");
INSERT INTO qucTNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Xeboc c'u bi pa ri mukubal, xquil jun ac'al achi t'uyul pa ru wiquiäk'ab ri mukubal. Sakloloj c'u ri ratz'iak ri achi. ¡Xquixej c'u quib ri ixokib, xquicajmaj wa'! ");
INSERT INTO qucTNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Xubij c'u ri achi chque: ¡Mixej iwib! Ri ix quitzucuj ri Jesús aj Nazaret, ri xrip cho ri cruz. C'astajinak c'u bi ri Are' chquixol ri cäminakib, man c'o tä chic waral. Chiwilampe' jawije' ri xyi' wi, —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Jix ba', chitzijoj c'u wa' chque ru tijoxelab, xukuje' che ri tat Pedro, chibij: “Nabejinak ri Jesús chiwäch, benam re pa Galilea. Chila' quiwila wi na u wäch ri Are' je' jas ri xubij chiwe,” —xcha chque ri ixokib. ");
INSERT INTO qucTNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Te ri' xebel bi ri ixokib, xeanimaj bi chuchi' ri mukubal. Sibalaj xebirbitic, qui xibim c'u quib. Man c'o tä c'u jas cäquibij che jachin jun rumal chi sibalaj qui xem quib. ");
INSERT INTO qucTNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","C'astajinak chi c'u ri Jesús chquixol ri cäminakib sibalaj ak'ab pa ri nabe k'ij re ri semana, xuc'ut rib nabe chuwäch ri nan María aj Magdala ri e resam bi wukub itzel tak espíritus che. ");
INSERT INTO qucTNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Xe' c'u ri are', xutzijoj wa' chque ri niq'uiaj chic ri xec'oji ruc' ri Jesús. Ri e are' sibalaj quebisonic, tajin quebok'ic. ");
INSERT INTO qucTNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Aretak xquito chi c'asal chi ri Jesús, chi ilom chi u wäch rumal ri nan María, ¡man xquicoj taj! ");
INSERT INTO qucTNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Te c'u ri' jun chi wi u c'utic rib ri xuban ri Jesús chquiwäch quieb chque ru tijoxelab ri benam que pa juyub. ");
INSERT INTO qucTNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Xetzelej c'u bi ri e are', xebe'c, xquitzijoj wa' chque ri niq'uiaj chic. Man xquicoj tä c'u ri qui tzij ri e are'. ");
INSERT INTO qucTNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Chuq'uisbal ri Jesús xuc'ut rib chquiwäch ri julajuj u tijoxelab, aretak e t'uyul chi' ri mesa. Xeuyajo rumal chi man xecojon taj, chi xa abajarinak ri canima'. Je' xuban wa' rumal chi man xquicoj tä ri qui tzij ri winak ri quilom u wäch ri Are' chi c'asal chic. ");
INSERT INTO qucTNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Xubij c'u ri Jesús chque: Jix cho ronojel ruwächulew, chitzijoj ri Utzalaj Tzij re ri Evangelio chque conojel ri winak, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Apachin c'u ri cäcojonic, cäban c'u na u kasna', curik na ri' ru tobanic ri Dios. Ri man cäcojon taj, cäk'at na tzij puwi' chi cäc'äjisax na u wäch, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ri quecojonic cäca'n na wa' we cajmabal tak etal ri': Pa ri nu bi' quequesaj na bi itzel tak espíritus, quech'aw c'u na pa jule' tak ch'abal chic. ");
INSERT INTO qucTNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Cäquichap na cumätz, xukuje' we cäquitij cämisanel cunabal, man c'o tä c'äx cäquiriko. Cäquiya na qui k'ab pa qui wi' ri yawabib, queutzir c'u na canok, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Te c'u ri', aretak ri Kajaw Jesús xto'taj che tzijonem cuc' ru tijoxelab, xc'am bi chicaj, xt'uyi c'u pa ru wiquiäk'ab ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Are c'u ru tijoxelab xebel bic, xquitzijoj ri Utzalaj Tzij re ri Evangelio apawije' chi' ri xeopan wi. Tzare c'u ri Kajaw Jesús xtob chque, xujiquiba chquiwäch ri winak chi kas tzij ri tajin cäquitzijoj rumal chi xuya chque chi cäca'n cajmabal tak etal junam ruc' ri tajin cäquitzijoj. Amén.");
INSERT INTO qucTNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Lok'alaj tat Teófilo: E q'uia ri winak ri xcaj xquitz'ibaj pa cholaj ri tzijobelil chrij ri kas xbantaj waral chkaxol. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ri xbantaj na are je' jas ri c'utum chkawäch cumal ri winak ri xquil ronojel wa' kas pa ri u chaplexic lok. We winak ri' e are' ri xetob chutzijoxic ru Lok' Pixab ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ri in xukuje' sibalaj utz rilic wa' nu banom in rech quinwetamaj ronojel wa' kas pa ru chaplexic lok. Rumal rech wa' xinchomaj in chi are utz we ri in xukuje' quintz'ibaj bi pa ru cholajil ronojel ri xbantajic. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Je ri' quinban na rech quetamaj la ri kas tzij chrij ri tijonic ri yo'm che la. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Aretak ri tat Herodes are nim takanel pa qui wi' ri winak aj Judea, xc'oji jun tata' chic chila', Zacarías u bi'. Ri tata' ri' are sacerdote aj Israel ri jun cuc' ri juch'ob sacerdotes aj re ri mam Abías. Ri rixokil, Elisabet u bi', are jun chque ri rachalaxic ri mam Aarón. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","E utzalaj tak winak wa' we juc'ulaj ri', jicom c'u canima' cho ri Dios. Xeniman che ri Dios pa ronojel ri xtakan wi, pa ronojel ru Lok' Pixab ri Kajaw. Man c'o tä etzelal ri xca'no. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Man c'o tä c'u calc'ual rumal chi ri nan Elisabet man calc'ualan taj. E nimak tak winak chi c'ut ri quieb ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Pa jun k'ij ri tat Zacarías tajin cäpatänin ri are' pa ri nimalaj rachoch ri Dios rumal chi cäquirik u banic wa' ri achijab ri e jun cuc' ri juch'ob sacerdotes aj re ri mam Abías pa tak ri k'ij ri'. Ri u chac ri tat Zacarías are la' chi cäch'aw pa qui wi' ri winak ruc' ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Je' jas ri qui nak'atisam wi quib ri sacerdotes, xquicha' ri tat Zacarías rech coc bi pa ri lok'alaj c'olibal ri sibalaj äwas chi coc bi xa apachinok chuporoxic ri incienso. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Conojel ri winak xquimulij apan quib cho ja chubanic orar aretak tajin cäporox ri incienso. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Te'talic c'ut xuc'ut rib jun ángel cho ri tat Zacarías, ri takom lok rumal ri Dios. Xtaq'ui c'u chuxcut ri cäporox wi ri incienso. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Aretak ri tat Zacarías xril ri ángel, man xurik taj jas xubano, xane sibalaj xuxej rib. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Xubij c'u ri ángel che ri tat Zacarías: Maxej awib. Ri a bochi'nic xta'taj rumal ri Dios. Quil c'u na u wäch jun a c'ojol rumal ri nan Elisabet ri awixokil. Cacoj c'u na a Juan che ru bi', —cächa che. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Xukuje' xubij: Sibalaj catquicot na rumal ri ac'al, xukuje' e q'uia chque ri jule' winak chic ri quequicot na aretak quil u wäch, —cächa ri ángel che. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Cänimar na u k'ij cho ri Kajaw Dios. Man cutij tä na vino, man cutij tä c'u tzam. Cätakan na ri Lok'alaj Espíritu pa ranima' ri ac'al c'ä mäjok quil u wäch, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Cuban c'u na ri a Juan chi q'uia chque ri winak aj Israel quetzelej na ruc' ri Kajaw ri qui Dios, —cächa ri ángel che ri tat Zacarías. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ri a Juan cänabej na cho ri Kajaw Jesús. Cäc'oji c'u na ru no'j xukuje' ru chuk'ab je' jas ri xc'oji che ri mam Elías, k'alajisal re ru Lok' Pixab ri Dios ojer. Cuban na chi ri nan tat quetzelejic queutzir cuc' ri calc'ual, xukuje' chi ri winak ri cäquiyac quib chrij ri Dios cäquiq'uex na canima', cäquiq'uex ri qui chomanic, cäquetamaj na ri nimanic, quetzelej qui wäch cuc' ri utzalaj tak winak, cäca'n na que ri e are'. Ri a Juan cuban na chque ri winak chi quecowin na chuc'ulaxic ri Kajaw, —xcha ri ángel che ri tat Zacarías. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Xuta' c'u ri tat Zacarías che ri ángel, xubij: ¿Jas ta quinban che retamaxic wa' chi kas tzij ri cätzijoj la chwe? Ri in, in ri'j achi chic, xukuje' ri wixokil are nim winak chic, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Xch'aw chi na jumul ri ángel, xubij che: In ri' ri Gabriel, in patänil re ri Dios. In takom c'u lok che a tzijobexic, che qui tzijoxic we utzalaj tak tzij ri' chawe, —cächa che. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Tzche we cämic ri' man catcowin tä chic catch'awic c'ä copan na ri k'ij ri cäbantaj na wa' ri xinbij chawe, c'ä quil na u wäch ri a c'ojol rumal rech wa' chi man xacoj tä ri nu tzij, —cächa ri'. Cäbantaj na wa' we nu tzijom ri' tzpa ru k'ijol, —xcha ri ángel che. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ri winak c'ut queye'm ri tat Zacarías. Xquicajmaj wa' chi sibalaj xbeytaj pa ri lok'alaj c'olibal ri sibalaj äwas chi coc bi xa apachinok. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Aretak xel lok ri tat Zacarías, man xcowin tä chic che qui ch'abexic ri winak. Xquetamaj chi c'o jas ri xuc'ut rib chuwäch ri tat Zacarías pa ri lok'alaj c'olibal. Xak pa memal chic xeuch'abej, rumal chi xmemar canok. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Aretak xetz'akat ri k'ij ri cäpatänin ri tat Zacarías pa ri nimalaj rachoch Dios, xe' ri are' cho rachoch. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Te c'u ri' ri nan Elisabet xcanaj yawab winak chic, xcanaj c'u job ic' cho rachoch. Xubij ri nan Elisabet pa ranima': ");
INSERT INTO qucTNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Xca'y ri Kajaw Dios chwe, xutok'obisaj c'u nu wäch rech man quinquiyok' tä chi ri winak,” —xcha ri nan Elisabet. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Chuwak ic' chi c'ut ri Dios xutak bi ri ángel Gabriel pa ri tinimit Nazaret re Galilea. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Xopan c'u ruc' jun k'apoj ali, María u bi', ri tz'onom chic rumal jun achi, José u bi'. We achi ri' rachalaxic can ri nim takanel David ojer. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ri ángel xoc bi chila' jawije' c'o wi ri k'apoj al María, xubij che: ¿A utz a wäch, María? —cächa'. ¡At ri' ri at cha'tal rumal ri Dios! Kas c'o ri Kajaw Dios awuc', —cächa che. Ri at c'ut, at tewchim na rumal ri Dios chquiwäch conojel ixokib, —xcha ri ángel che ri al María. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Aretak ri al María xril ri ángel, xutatabej ru tzij, xt'ujuw c'u ri ranima' rumal ri xbix che. Xuchomaj pa ranima', xubij: ¿Jas wa' ri cubij chwe? —xcha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Xch'aw chi ri ángel, xubij che ri k'apoj al María: Maxej awib, María, —cächa che. Ri at sibalaj at lok' cho ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ri at c'ut catcanaj can yawab winak. Cawil na u wäch jun awal ala ri cacoj na “Jesús” che ru bi', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Cänimar na u k'ij ri a Jesús. Cäbix na u C'ojol ri Dios aj Chicaj che. Ri Kajaw Dios cucoj na che nim takanel je' jas ra mam David. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Je ri' rech cätakan na puwi' ri tinimit Israel pa tak ri k'ij ri junab ri quepetic. Ru takanic ri Are', man c'o tä u q'uisic, —xcha ri ángel che ri al María. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Te ri' ri al María xuta' che ri ángel, xubij: ¿Jas lo quinc'ulmaj wa'? —cächa'. Mäja' quinc'oji ruc' achi, —xcha che ri ángel. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Xch'aw c'u ri ángel, xubij che: Cäkaj na lok ri Lok'alaj Espíritu pa wi'. Ri Dios aj Chicaj cärokxanej na wa' awuc' rumal ru chuk'ab. Rumal ri' we lok'alaj ac'al ri' ri quil na u wäch cäbix na u C'ojol ri Dios che, —cächa che. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Xukuje' ri nan Elisabet ri awachalal are' cäril na u wäch jun ac'al pune ri'j chic. Are c'u wakib ic' wa' cämic yawab winak chic ri nan Elisabet pune xbix canok che chi man cäcowin tä che ri alc'ualanic. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Man c'o tä c'u jas ri mat cäcowin ri Dios chubanic, —xcha ri ángel. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Xubij c'u ri k'apoj al María: In ri' ri patänil re ri Kajaw Dios. Chubana ba' ri Are' chwe jas ri tzijom la chwe, —xcha che. Xel c'u bi ri ángel chuwäch. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Pa tak ri k'ij ri' xel bic ri al María cho ja, xe' aninak pa jun tinimit ri c'o pa tak ri u juyubal ri Judea. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Xoc c'u bic pa rachoch ri tat Zacarías, xuya rutzil u wäch ri nan Elisabet ri rixokil. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ri nan Elisabet, aretak xuta ru tzij ri al María, xslab c'u ri ral pa ru c'ux. Xkaj ri Lok'alaj Espíritu puwi' ri nan Elisabet, xtakan c'u pa ranima'. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Co xch'aw ri nan Elisabet, xubij che ri al María: Ri at c'ut at tewchim na rumal ri Dios chquiwäch conojel ixokib. U tewchim na ri awal at xukuje', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Jas lo wa' chi ri Dios cuban jun nimalaj utzil chwe in, chi ru nan ri Kajaw xpe wuc'? —cächa ri nan Elisabet. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Chanim ri' aretak xinto chi xatch'awic, ri wal xquicotic, xslab pa nu c'ux. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Utz awe at ri xatcojon che ri Kajaw Dios, rumal chi kas tzij cäbantaj na ri xbix chawe rumal ri Dios, —xcha ri nan Elisabet che ri al María. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Xubij ri k'apoj al María: Quinnimarisaj u k'ij ri Kajaw Dios. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Cäquicot c'u ri wanima' rumal ri Dios ri To'l We. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Quinquicotic rumal chi ri Dios xca'y chwe in ru patäninel ri man nim tä nu banic. Conojel winak cäquibij na chwe pa tak ri k'ij ri junab ri quepetic chi utz we. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Je ri' cäquibij na rumal rech wa' chi ri Dios ri sibalaj c'o u chuk'ab u banom nimak tak utzil chwe. Sibalaj lok' ri Dios, sibalaj lok' ru bi' ri Are', —cächa ri al María. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Amak'el ronojel k'ij cutok'obisaj na qui wäch conojel winak ri nim cäquil wi ri Are', ri cäquixej quib chuwäch. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","U c'utum ri nimalaj u chuk'ab chquiwäch conojel. Xukasaj qui k'ij ri winak ri cäquichomaj chi sibalaj nim qui banic, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Xeresaj ri takanic pa qui k'ab ri nimak qui banic, xuya c'u wa' chque ri winak ri man nim tä queil wi. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","E q'uia ri utzil ri xuban ri Dios chque ri meba'ib, ri winak ri quenumic. Ri Dios xubij chque ri k'inomab: Jix, man c'o tä iwe ix, —xcha chque, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Xtoban chque ri winak aj Israel, ri patänil tak re ri Dios. Man xsach tä pu jolom ri Dios ru tok'obisaxic qui wäch. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Je' xuban wa' rumal chi je' xuchi'j chque ri kati't ka mam, che ri ka mam Abraham xukuje' ri rachalaxic ri are' amak'el pa tak ri k'ij ri junab ri quepetic, —xcha ri al María. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Craj oxib ic' xcanaj na can ri al María ruc' ri nan Elisabet. Te c'u ri' xtzelej bic, xe' cho rachoch. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Aretak xopan ri k'ij ri cutzir ri nan Elisabet, xril c'u u wäch jun ral ala. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ri u c'ul tak ja ri nan Elisabet xukuje' ri rachalaxic, aretak xquito chi ri Kajaw Dios sibalaj xutok'obisaj u wäch ri nan Elisabet, xequich'abej, xequicot c'u ruc'. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Chuwajxak k'ij c'ut xebe' chucojic ri retal ri ojer u trato ri Dios che ru cuerpo ri ac'al. Xcaj c'ut xquicoj Zacarías che ru bi', junam ruc' ru bi' ru tat. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Xch'aw c'u ru nan, xubij chque: ¡No! —cächa'. Ru bi' ri cäkacoj chrij ri ac'al are Juan, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Xquibij c'u che: ¿Jas che? Man c'o tä jun chque ri achalal la ri je' u bi' wa', —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Xak pa memal xquich'abej ru tat ri ac'al, xquita' che: ¿Jas u bi' ri ac'al cäcoj la? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ri tat Zacarías xuta' jun wuj rech cätz'ibanic. Xutz'ibaj c'u wa', xubij: “Juan ru bi' ri ac'al,” —xcha pa ri tz'ibanic. Conojel xquicajmaj wa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Xak c'u te'talic xtzelej ru ch'abal ri tat Zacarías, xcowin chic cätzijonic. Xtzijon c'ut, xunimarisaj u k'ij ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Sibalaj xquixej quib conojel ri qui c'ul tak ja, xquicajmaj wa'. Ronojel ri xuc'ulmataj jela' xtzijox apan pa tak ronojel ri juyub re Judea. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Conojel ri winak ri xetowic xechoman pa que wi, xquibij: ¿Jas lo cuban wa' we ac'al ri'? —xecha'. Je' xquibij wa' rumal chi k'alaj chi c'o ri Kajaw Dios ruc' ri ac'al. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Kajinak ri Lok'alaj Espíritu puwi' ri tat Zacarías ru tat ri ala, xk'alajisanic, xubij: ");
INSERT INTO qucTNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Quinya ba' u k'ij ri Kajaw ri ka Dios uj, uj ri' ri winak aj Israel, rumal chi xulic, xpe che ka to'ic uj, uj c'u ri' ri winak re ri u tinimit. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Xuya c'u chke jun To'l Ke ri sibalaj c'o u chuk'ab. Are c'u wa' jun chque ri rachalaxic ri ka mam David, patänil re ri Dios, —cächa ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Are wa' ri xuchi'j lok ri Dios cumal ri lok'alaj tak k'alajisal tak re ru Lok' Pixab pa ri ojer tak k'ij canok. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Xubij chi cujuto' na chquiwäch ri ka c'ulel, che ka to'ic pa qui k'ab, xukuje' pa qui k'ab conojel ri queetzelan ka wäch, —cächa ri tat Zacarías. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Xukuje' xubij chi cutok'obisaj na qui wäch ri kati't ka mam, xukuje' chuc'utic chquiwäch chi xna'taj che ri Are' ri Lok'alaj Trato ri xuchi'j chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Are c'u wa' ri Kas Tzij ri u bim che ri ka mam Abraham, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Je ri' rech aretak uj esam chic pa qui k'ab ri ka c'ulel, cuya' cujpatänin che ri Dios, man cäkaxej tä chi kib, ");
INSERT INTO qucTNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","xukuje' rech jicom ri kanima' cujpatänin che, ka jachom kib pu k'ab ri Dios pa tak ronojel ri k'ij re ri ka c'aslemal, —cächa ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","At c'ut, alaj ac'al, cäbix na k'alajisal re ru Lok' Pixab ri Dios aj Chicaj chawe, rumal chi catnabej na chuwäch ri Kajaw chubanic jicom che ru be. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","At c'ut catyo'w na retamaxic ri u tobanic ri Dios chque ri winak re ri u tinimit, xukuje' chi cäsach na ri qui mac, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ri ka Dios sibalaj quel u c'ux chke. Rumal ri' cutak na lok ri Kajaw Jesús kuc' uj. Sibalaj je'l c'u ri Are' je' jas ru sakilal ri k'ij aretak cäsakiric. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Cuya na sakilal pa canima' ri winak ri je' ta ne e c'o pa ri k'ekumal rumal ri qui mac, cäquixej c'u quib cho ri cämical. Cäc'oji na che c'amal ka be pa ri be ri cuxlan wi ri kanima', —xcha ri tat Zacarías. ");
INSERT INTO qucTNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ri a Juan xq'uiyic, sibalaj c'o u chuk'ab ri xyi' che rumal ri Lok'alaj Espíritu. Xcanaj can pa tak ri juyub ri sibalaj cätz'inowic c'ä pa ri k'ij ri xuc'ut rib chquiwäch ri winak aj Israel. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Pa tak ri k'ij ri', ri nimalaj takanel Augusto César xuya takanic chque conojel winak chi cätz'ibax ri qui bi'. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Aretak ri tat Cirenio are k'atal tzij re ri tinimit Siria, xbantaj we nabe tz'iban bi'aj ri'. Are jun censo wa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Xebe' c'u conojel ri winak chquijujunal pa tak ri qui tinimit rech cätz'ibax ri qui bi'. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Xa je ri' xel lok ri tat José pa ri tinimit Nazaret re Galilea, xe'c, xopan pa jun tinimit re Judea, Belén u bi'. Chila' xe' wi ri tat José rumal chi are rachalaxic ri mam David. Ri tinimit Belén are u tinimit ri mam David pa ojer tak k'ij canok. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Aretak xe' ri tat José rech cätz'ibax ru bi', xuc'am bi ri al María ri u to'm chic che rixokil, yawab winak chi c'ut. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Aretak e c'o chila' pa Belén, xopan ri k'ij ri cutzir ri al María. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Xril c'u u wäch ru nabeal, jun ala. Xucoj atz'iak rech nu'ch ac'al che. Xuk'oyoba pa jun echa'bal rumal chi man c'o tä chi jawije' ri quec'oji wi pa ri mesón. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","E c'o c'u ajyuk'ab pa tak ri juyub chunakaj ri tinimit Belén ri quequiwaraj ri cawaj chila'. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Xak te'talic c'ut jun ángel takom lok rumal ri Kajaw Dios xtaq'ui chquiwäch. Xjuluw c'u ri je'lalaj u juluwem ri Dios pa qui wi'. Sibalaj c'u xquixej quib ri ajyuk'ab. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Xubij c'u ri ángel chque: Mixej iwib, —cächa'. Kas tzij quinbij na jun utzalaj tzij chiwe. Ri u patän wa' we utzalaj tzij ri' are chi cuya nimalaj quicotemal chque conojel winak. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Are quinbij chiwe chi cämic ri' xil u wäch jun To'l Iwe pa ru tinimit ri mam David. Are Cristo wa' ri Kajaw, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Are c'u retal wa' chiwe: Quirik na jun alaj ne', cojom c'u atz'iak rech nu'ch ac'al chrij, k'oyobam pa jun echa'bal, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Xak te'talic c'ut e c'o chic ruc' ri ángel q'uialaj tak ángeles ajchicaj. Cäquinimarisaj c'u u k'ij ri Dios, cäquibij: ");
INSERT INTO qucTNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Kanimarisaj ba' u k'ij ri Dios ri c'o chicaj! ¡Chuxlan na canima' ri winak cho ruwächulew, e are c'u winak wa' ri utz queril wi ri Dios! —xecha ri ángeles. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Te c'u ri' aretak xebe' ri ángeles chicaj, ri ajyuk'ab xquitzijobela quib, xquibij: Jo' pa Belén, —quecha'. Jekila na we xc'ulmatajic ri' ri u tzijom ri Kajaw Dios chke, —xecha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Aninak xebe'c. Xequirika c'u ri nan María, ri tat José ruc' ri alaj ne'. K'oyobam c'u ri ne' pa jun echa'bal. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Aretak xquilo, xquitzijoj ri xubij ri ángel chque chrij ri ac'al. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Xquicajmaj c'u wa' conojel ri winak ri xetow ri qui tzij ri ajyuk'ab. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Are c'u ri nan María xak xuc'ol conojel we tzij ri' pa ranima', xchoman c'u chquij. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Xetzelej c'u bic ri ajyuk'ab, tajin cäquiya u k'ij, cäquinimarisaj c'u u k'ij ri Dios rumal ri xbix chque, xukuje' rumal chi xquilo chi kas je' jas ri xutzijoj ri ángel chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Chuwajxak k'ij c'ut, xquicoj ri retal ri ojer trato che ru cuerpo ri ac'al, xquicoj c'u Jesús che ru bi'. Are u bi' wa' ri xucoj can ri ángel aretak mäjok calc'ualax chuc'ux ri k'apoj al María. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Xopan ri k'ij ri quesax ri rawasil ri nan María. Je' jas ri cubij chupam ru Pixab ri mam Moisés, xquic'am lok ri ac'al chuyi'c chuwäch ri Kajaw Dios pa ri tinimit Jerusalén. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Je ri' xca'no rumal chi tz'ibam wa' pa ru Pixab ri Kajaw Dios, cubij: “Ronojel nabeal ala cätas wa' chupatänixic ri Kajaw Dios,” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Xebe' c'u ri tat José, ri nan María pa Jerusalén chusipaxic ri cäbix pa ru Pixab ri Kajaw Dios: Are juc'ulaj ut wa'. We man c'o tä ri ut cuya' queyi' quieb alaj tak tucumux che sipanic. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Xc'oji c'u pa ri tinimit Jerusalén jun tata', Simeón u bi'. We tata' ri' are utzalaj achi wa' ri cäniman che ri Dios pa ronojel, jicom c'u ranima' chuwäch. Ri are' reye'm ri Dios chi queuto' ri winak aj Israel. C'o c'u ri Lok'alaj Espíritu ruc'. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Xk'alajisax che ri tat Simeón rumal ri Lok'alaj Espíritu chi man cäcäm tä na chanim, xane nabe cäril na ri Cristo ri cha'tal rumal ri Kajaw Dios. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Xuna' c'u ru rayinic ri Lok'alaj Espíritu pa ranima', xe' pa ri nimalaj rachoch Dios. Aretak ru tat, u nan ri alaj a Jesús xquic'am bic, xeopan pa ri nimalaj rachoch Dios chubanic che ri ac'al jas ri cubij pa ri Pixab chi rajwaxic u banic wa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ri tat Simeón xuk'aluj ri ala, xuya u k'ij ri Dios. Xuban orar, xubij: ");
INSERT INTO qucTNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Kajaw Dios, ya la chwe cämic chi ri in, ri in patänil e la, chi quincäm na, cuxlan ri wanima', je' jas ri bim la lok chwe, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Wilom c'u in ri To'l Ke, ");
INSERT INTO qucTNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ri takom la lok chquiwäch conojel winak. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Are je' jas jun chäj, jun candela ri cätununic. Cuya na ri sakil re ri Pixab la pa canima' ri niq'uiaj winak chic ri man e aj Israel taj. Rumal wa' ri takom la lok, cänimarisax na u k'ij ri tinimit la, ri Israel, —xcha ri tat Simeón. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ri tat José ruc' ru nan ri ac'al xquicajmaj ronojel ri cätzijox chrij ri a Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ri tat Simeón xeutewchij, xubij che ri nan María, u nan ri ac'al: Chilampe la we ac'al ri', —cächa'. Cäcoj na wa' rech quetzak q'uia winak aj Israel, cäsach c'u na qui wäch. Queto' c'u na ri jule' winak chic aj Israel rumal ri Are', quewalijisax na. Xukuje' we ac'al ri' cäcoj na rumal ri Dios che etal chquiwäch ri winak. Cäquetzelaj c'u na u wäch, —cächa ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Cuban na ri Kajaw Jesús chi cäk'alajinic jas ri quechoman ri winak pa canima', —cächa chque. Ri lal, nan, cäq'uis na ib la che ok'ej, —xcha che ri nan María. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Xukuje' xc'oji chila' jun chichu' k'alajisanel, Ana u bi'. Are u mia'l ri tat Fanuel re ri rachalaxic ri mam Aser. Sibalaj nim winak chic ri chichu' ri'. Xa wukub junab xc'oji ruc' ri rachajil, xcäm c'u ri tata'. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Jumuch' quiejeb junab malca'n canok. Man quel tä chi bi pa ri nimalaj rachoch Dios. Cäpatänin c'u che ri Dios chila' chi pak'ij chi chak'ab. Cuban orar, xukuje' cuban ayunar. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Xtac'atob c'u wa' chquiwäch ri tat José, ri nan María pa we hora ri', xuban maltioxinic che ri Dios. Xtzijon chrij ri a Jesús chquiwäch conojel ri winak ri e eyeninak che ri Dios chi cuto' ri tinimit Israel. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Qui banom c'u ronojel ri cäbix pa ru Pixab ri Kajaw Dios, xetzelej c'u bic, xebe' pa Galilea, pa ri qui tinimit Nazaret. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Q'uiyem re ri ac'al, tajin cäcowiric, sibalaj c'o ru no'j. Ri Dios sibalaj tajin cätewchin ri a Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ronojel junab c'ut xebe' ru tat, ru nan pa ri tinimit Jerusalén che ri nimak'ij ri cäbix Pascua che. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Aretak cablajuj u junab chic ri a Jesús, xepaki bic, xebe' pa Jerusalén jas ri qui nak'atisam wi quib pa ri nimak'ij ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Xq'uis c'u ri nimak'ij, tzelejem cäca'n bic ri tat José, ri nan María. Xcanaj can ri alaj a Jesús pa Jerusalén, man c'o tä c'u quetam ru tat, u nan chrij wa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Xquichomaj chi c'o cuc' ri cachi'l. E benak jun k'ij pa ri be, xquitzucuj ri a Jesús chquixol ri cachalal, chquixol ri cachi'l. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Man xquirik tä c'ut. Xa je ri' xetzelej chic pa Jerusalén. Xquitzucuj ri ala chila'. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Qui tzucum c'u oxib k'ij, xquirik c'u pa ri nimalaj rachoch Dios. T'uyul ri a Jesús chquixol ri tijonelab re ri Pixab, tajin cutatabej ri qui tijonic. Cuc'ot c'u qui chi' ri tata'ib. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Conojel ri quetowic xquicajmaj chi utz cächoman ri ala, chi retam jas cubij chque ri tijonelab. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Aretak ru tat, u nan xquil u wäch ri ac'al, xquicajmaj wa'. Xubij ru nan che: Wal, ¿jas che je' a banom wa' chke? —cächa'. ¿A mat cawilo chi ra tat, ri in, uj elinak ch'uj chatzucuxic? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Xubij c'u ri a Jesús chque: ¿Jas che quintzucuj alak? ¿A mat etam alak chi rajwaxic chi quinban ri u rayinic ri nu Tat? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ri e are' man xquich'ob tä c'u ri cubij ri ac'al chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Xe' c'u ri a Jesús ruc' ri tat José, ruc' ru nan pa ri tinimit Nazaret. U yo'm c'u rib pa takic chque. Ru nan xuc'ol pa ranima' ronojel ri xbantajic. ");
INSERT INTO qucTNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Xq'uiy ri a Jesús, c'o na ru no'j, xukuje' xcowiric. Ri a Jesús sibalaj utz cuban cho ri Dios, xukuje' utz cäquil wi ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Pa ri ro'lajuj junab ri tajin cätakan ri tat Tiberio César ri nimalaj takanel, aretak ri tat Poncio Pilato are k'atal tzij puwi' ri Judea, ri tat Herodes c'ut are nim takanel puwi' ri Galilea. Ri tat Felipe, rachalal ri tat Herodes, are k'atal tzij pa Iturea xukuje' pa Traconite. Ri tat Lisanias are k'atal tzij pa Abilinia. ");
INSERT INTO qucTNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ri tat Anás, ri tat Caifás e are' qui nimakil sacerdotes quech ri winak aj Israel. Pa tak ri k'ij ri' ri Dios xutzijobej ri tat Juan, ru c'ojol ri tat Zacarías. C'o c'u ri tat Juan pa tak juyub ri cätz'inowic. ");
INSERT INTO qucTNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ri tat Juan xubinibej conojel tak ri juyub ri e c'o chunakaj ri nima' Jordán, cutzijoj c'u chque ri winak chi rajwaxic cäquiq'uex qui chomanic, cäq'uex c'u canima', te c'u ri' cäban qui kasna' rech cäk'alajinic chi je' qui banom wa'. Xa je ri' cäsachtaj ri qui mac. ");
INSERT INTO qucTNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Je' jas ri cubij pa ri wuj ri tz'ibam wi ru tzij ri ojer k'alajisal re ru Lok' Pixab ri Dios, ri Isaías: C'o jun ri co cäch'aw pa tak ri juyub ri quetz'inowic, cubij: “Chibana u banic ri nim be ri cäbin wi ri Kajaw. Chibana sibalaj jicom che ri alaj tak u be,” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","“Quenojisax na conojel tak ri siwan, quelianisax na conojel tak ri juyub, ri nimak xukuje' ri ch'utik. Ri be ri e cotaquic quejicomisax na. Ri be ri sibalaj e c'äx na chelianisaxok,” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","“Conojel winak cäquil c'u na jas cuban ri Dios che qui to'ic ri winak ajmaquib,” —xcha ri mam Isaías. ");
INSERT INTO qucTNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Xubij c'u ri tat Juan chque ri q'uia winak ri xeopan ruc' rech cäban qui kasna': ¡Alak subanelab tak winak, cachalaxic tz'i'! ¿Jachin c'u ri' ri xc'utuw chuwäch alak chi rajwaxic canimaj alak bi cho ri royowal ri Dios? —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Bana ba' alak ri takal u banic ri cuk'alajisaj chi kas tzij xq'uextaj anima' alak. Mächaplej alak u bixic xol tak alak: “Utz ke rumal chi ri uj, uj rachalaxic ri ka mam Abraham,” —mächa ne alak. Quinbij na chech alak chi ri Dios cäcowin chubanic chque tak we abaj ri' chi e rachalaxic chic ri ka mam Abraham, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Chanim ri' tajin cäcoj ri iquiäj chque tak ri qui xera' ri che' rech quet'oyic. Ronojel che' ri man cuya tä utzalaj u wäch cät'oy na, queq'uiäk c'u bi pa ri k'ak', —xcha ri tat Juan chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Xquita' c'u ri q'uia winak che, xquibij: ¿Jas ta c'u lo cäka'n na? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Xch'aw chi ri tat Juan, xubij chque: Apachin c'u ri c'o quieb u k'u', chuya jun re che ri winak ri man c'o tä re. Apachin ri c'o cutijo, chuya re ri winak ri man c'o tä cutijo, —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Xeopan xukuje' jujun chque ri tok'il tak alcabal rech cäban qui kasna', xquibij c'u che ri tat Juan: Kajtij, ¿jas cäka'n na uj? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Xubij ri tat Juan chque: Mitok'ij u wi' ri ix takom wi chutok'ixic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Xukuje' ri soldados xquita' che, xquibij: E c'u ri uj, ¿jas cäka'n na? —xecha che. Xubij ri tat Juan chque: Miban elak' che jachin jun winak, mibana c'u c'äx chque. Mibij jalum k'abam chquij ri winak. Chicu'ba c'u i c'ux ruc' ri tojbal iwe, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ri winak c'ut tajin quechoman pa canima' chrij ri tat Juan, tajin queye'n che rilic we ne ri tat Juan are ri Cristo. ");
INSERT INTO qucTNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Xch'aw chi ri Juan Kasal Ja', xubij chque conojel: Petinak jun achi ri c'o na u chuk'ab chnuwäch in. Man takal tä c'u chwe in chi quinquir ru c'amal u xajäb. Ri are' cuya na ri Lok'alaj Espíritu chech alak je' jas ri in quinban kasna' alak ruc' joron. Cuban c'u na kasna' alak ruc' k'ak', —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ri achi ri' cuc'am ru jopibal rech cujosk'ij ri trico, xukuje' rech cumulij bic ru trico, cuya c'u pa tak ru c'uja. Xukuje' ne cuporoj ri pajo, cuban jun k'ak' ri man cäcowin tä jun chuchupic, —cächa'. Jas ri cuban ri achi ajchac che ri trico, je ri' xukuje' cuban na ri Kajaw Dios chque tak winak, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Je ri' xubij ri tat Juan, xukuje' xeupixbaj ri winak cuc' q'uia pixab chic, xutzijoj c'u ri Utzalaj Tzij re ri Evangelio chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Xukuje' ri tat Juan xuyaj ri k'atal tzij Herodes rumal chi ri tat Herodes xuch'abej ri nan Herodías, rixokil ri tat Felipe ru chak' ri Herodes. Xuyaj c'u ri tat Herodes xukuje' cumal conojel ri etzelal ri u banom. ");
INSERT INTO qucTNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ri tat Herodes xa xunimarisaj u banic ri man utz taj puwi' ronojel ri u banom, chi xucoj ri tat Juan pa che'. ");
INSERT INTO qucTNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Pa jun k'ij aretak ri tat Juan tajin cuban qui kasna' conojel ri winak, xuban u kasna' ri Jesús xukuje'. Pa ri kasna' ri Jesús tajin cuban orar, xjaktaj c'u ri caj. ");
INSERT INTO qucTNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Xkaj c'u lok ri Lok'alaj Espíritu puwi' ri Jesús je' ta ne chi ri Lok'alaj Espíritu are jun palomäx. Te c'u ri' xch'aw lok Jun chicaj, xubij: At ri' ri lok'alaj nu C'ojol. Sibalaj cäquicot ri wanima' awumal, —xcha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Craj ne juwinak lajuj u junab ri Jesús aretak xuchaplej patäninem cho ri Dios. Xquichomaj ri winak chi ri Jesús are ralc'ual ri tat José. Ri tat José c'ut are rachalaxic ri tat Elí, ");
INSERT INTO qucTNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ri tat Elí are ralc'ual ri tat Matat, ri tat Matat ralc'ual ri tat Leví, ri tat Leví are ralc'ual ri tat Melqui, ri tat Melqui are ralc'ual ri tat Jana, ri tat Jana ralc'ual ri tat José, ");
INSERT INTO qucTNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ri tat José ralc'ual ri tat Matatías, ri tat Matatías ralc'ual ri tat Amós, ri tat Amós ralc'ual ri tat Nahum, ri tat Nahum ralc'ual ri tat Esli, ri tat Esli ralc'ual ri tat Nagai, ");
INSERT INTO qucTNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ri tat Nagai ralc'ual ri tat Maat, ri tat Maat ralc'ual ri tat Matatías, ri tat Matatías ralc'ual ri tat Semei, ri tat Semei ralc'ual ri tat José, ri tat José ralc'ual ri tat Judá, ");
INSERT INTO qucTNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ri tat Judá ralc'ual ri tat Joana, ri tat Joana ralc'ual ri tat Resa, ri tat Resa ralc'ual ri tat Zorobabel, ri tat Zorobabel ralc'ual ri tat Salatiel, ri tat Salatiel ralc'ual ri tat Neri, ");
INSERT INTO qucTNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ri tat Neri ralc'ual ri tat Melqui, ri tat Melqui ralc'ual ri tat Adi, ri tat Adi ralc'ual ri tat Cosam, ri tat Cosam ralc'ual ri tat Elmodam, ri tat Elmodam ralc'ual ri tat Er, ");
INSERT INTO qucTNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ri tat Er ralc'ual ri tat Josué, ri tat Josué ralc'ual ri tat Eliezer, ri tat Eliezer ralc'ual ri tat Jorim, ri tat Jorim ralc'ual ri tat Matat, ");
INSERT INTO qucTNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ri tat Matat ralc'ual ri tat Leví, ri tat Leví ralc'ual ri tat Simeón, ri tat Simeón ralc'ual ri tat Judá, ri tat Judá ralc'ual ri tat José, ri tat José ralc'ual ri tat Jonán, ri tat Jonán ralc'ual ri tat Eliaquim, ");
INSERT INTO qucTNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ri tat Eliaquim ralc'ual ri tat Melea, ri tat Melea ralc'ual ri tat Mainán, ri tat Mainán ralc'ual ri tat Matata, ri tat Matata ralc'ual ri tat Natán, ri tat Natán ralc'ual ri tat David, ");
INSERT INTO qucTNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ri tat David ralc'ual ri tat Isaí, ri tat Isaí ralc'ual ri tat Obed, ri tat Obed ralc'ual ri tat Booz, ri tat Booz ralc'ual ri tat Salmón, ri tat Salmón ralc'ual ri tat Naasón, ");
INSERT INTO qucTNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ri tat Naasón ralc'ual ri tat Aminadab, ri tat Aminadab ralc'ual ri tat Aram, ri tat Aram ralc'ual ri tat Esrom, ri tat Esrom ralc'ual ri tat Fares, ri tat Fares ralc'ual ri tat Judá, ");
INSERT INTO qucTNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ri tat Judá ralc'ual ri tat Jacob, ri tat Jacob ralc'ual ri tat Isaac, ri tat Isaac ralc'ual ri tat Abraham, ri tat Abraham ralc'ual ri tat Taré, ri tat Taré ralc'ual ri tat Nacor, ");
INSERT INTO qucTNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ri tat Nacor ralc'ual ri tat Serug, ri tat Serug ralc'ual ri tat Ragau, ri tat Ragau ralc'ual ri tat Peleg, ri tat Peleg ralc'ual ri tat Heber, ri tat Heber ralc'ual ri tat Sala, ");
INSERT INTO qucTNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ri tat Sala ralc'ual ri tat Cainán, ri tat Cainán ralc'ual ri tat Arfaxad, ri tat Arfaxad ralc'ual ri tat Sem, ri tat Sem ralc'ual ri tat Noé, ri tat Noé ralc'ual ri tat Lamec, ");
INSERT INTO qucTNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ri tat Lamec ralc'ual ri tat Matusalén, ri tat Matusalén ralc'ual ri tat Enoc, ri tat Enoc ralc'ual ri tat Jared, ri tat Jared ralc'ual ri tat Mahalaleel, ri tat Mahalaleel ralc'ual ri tat Cainán, ");
INSERT INTO qucTNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ri tat Cainán ralc'ual ri tat Enós, ri tat Enós ralc'ual ri tat Set, ri tat Set ralc'ual ri tat Adán, ri tat Adán are ralc'ual ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Xel bi ri Jesús pa ri nima' Jordán, xtzelej c'u lok kajinak ri Lok'alaj Espíritu puwi'. Te ri' ri Espíritu xuc'am bi ri Jesús pa tak juyub ri cätz'inowic. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Xc'oji c'u chila' cawinak k'ij, cätakchi'x c'u che mac rumal ri Itzel. Man c'o tä c'u jas xutij pa tak ri k'ij ri'. Te c'u ri' sibalaj xnumic. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Xubij c'u ri Itzel che: We lal ri' ri u C'ojol ri Dios, bij la che we abaj ri' chi cuban na wa che la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ri Jesús xch'awic, xubij che: Tz'ibam can wa' pa ru Lok' Pixab ri Dios ri Tz'ibtalic, cubij: “Man xak tä xuwi rumal ri wa quec'asi na ri winak, xane xukuje' rumal ronojel ru Tzij ri Dios,” —cächa ri', —xcha ri Jesús che. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Te c'u ri' ri Itzel xuc'am bi ajsic puwi' jun nimalaj juyub. Xeuc'utuxtaj conojel ri tinimit re ruwächulew chuwäch. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Xubij c'u che ri Jesús: Quinya na che la chi cätakan la pa qui wi' conojel we tinimit ri' xukuje' chi cänimarisax k'ij la rumal wa', —cächa'. Yo'm c'u ronojel wa' chwe in. Ri in c'ut cuya' quinya wa' che apachin ri quinwaj quinya wi, —xcha ri Itzel che. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","We cäxuqui la quink'ijilaj la quinya wa' che la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ri Jesús xch'awic, xubij: ¡Satanás! Chatel chnuwäch, —xcha'. Rumal chi tz'ibam pa ru Lok' Pixab ri Dios, cubij: “Chatk'ijilan na chwe in ri Awajaw ri a Dios. Chatpatänin xak xuwi chwe in,” —cächa ri u Tzij ri Dios, —xcha ri Jesús che. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ri Itzel xuc'am bic ri Jesús pa ri tinimit Jerusalén, xutac'aba puwi' ri nimalaj rachoch Dios, xubij che: We lal ri' ri u C'ojol ri Dios, q'uiäka bi ib la iquim, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Rumal chi ru Lok' Pixab ri Tz'ibtalic cubij: Queutak na lok ri ángeles che a chajixic, —cächa', —xcha ri Itzel che. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Xukuje' cubij pa ru Lok' Pixab ri Dios: Catquichap na che ra k'ab che a to'ic rech man cachäk'ij tä rawakan cho jun abaj, —cächa ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Xch'aw chi na jumul ri Jesús, xubij: Xukuje' cubij pa ru Lok' Pixab ri Dios ri Tz'ibtalic: “Mayac royowal ri Kajaw ri ka Dios,” —cächa', —xcha ri Jesús che. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Aretak ri Itzel xto'taj chutakchi'xic ri Jesús che mac, xel bi ruc'. Cätzelej chi na lok jumul pa jun k'ij chic. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Xtzelej c'u bi ri Jesús, c'o c'u ru chuk'ab ri Lok'alaj Espíritu ruc'. Xe' pa Galilea. Ri winak ajchila' xetzijon chrij ri Jesús pa ronojel tinimit. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ri Jesús xuya tijonic pa tak ri rachoch Dios ri cäquimulij wi quib ri winak aj Galilea. Conojel xquinimarisaj u k'ij. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Xtzelej bi ri Jesús, xe' pa ri tinimit Nazaret jawije' xq'uiyisax wi. Pa ri k'ij re uxlanem xoc bi pa ri rachoch Dios jas ru nak'atisam wi rib, xtaq'ui c'ut chusiq'uixic ru Lok' Pixab ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Xyi' c'u ri wuj che ri xutz'ibaj ri mam Isaías, k'alajisal re ru Lok' Pixab ri Dios ojer. Aretak xujak ri wuj, xuriko jawije' ri tz'ibtal wi ri', ri cubij: ");
INSERT INTO qucTNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ri Espíritu rech ri Kajaw Dios c'o wuc'. In cha'tal c'ut rech queintzijoj utzalaj tak tzij chque ri meba'ib. In u takom u lok che qui cu'bisaxic canima' ri quebisonic, chutzijoxic ri qui tzokopixic ri e tz'apim, chubanic c'ut chi queca'y ri moyab, xukuje' che qui tzokopixic ri man e tzokopim taj, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Xukuje' in takom lok chutzijoxic wa' chi ri Kajaw Dios xucha' we k'ij junab ri' chubanic utzil chque conojel winak, —cächa ri ka mam Isaías, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ri Jesús xutz'apij ri wuj, xutzelej wa' che ri chajil re ri rachoch Dios, xt'uyi'c. Conojel ri winak ri e c'o pa ri rachoch Dios naj qui wi' che. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Xubij c'u chque: Cämic ri' xbantaj wa' we Tz'ibtalic ri' chuwäch alak, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Conojel ri winak utz quech'aw chrij ri Jesús, xukuje' xquicajmaj ri je'lalaj tak tzij ri xutzijoj chque, xquibij: ¿A mat are ru c'ojol ri tat José? —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Xubij chque: Wetam ri cäbij na alak chwe in: “Ajcun, cunaj ib la,” —cächa na alak chwe. “Ri ka tom chi xeban la pa ri tinimit Capernaum, chebana c'u la waral pa ri tinimit la,” —cächa na alak, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Xukuje' xubij chque: Kas tzij ri quinbij chech alak chi sibalaj nim quil wi ronojel k'alajisanel. Xak xuwi pa ru tinimit ri are' man nim tä quil wi wa', —cächa ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tzij ri' ri quinbij chech alak chi xec'oji q'uia ri chuchuib malca'nib pa ri tinimit Israel pa tak ru k'ij ri ka mam Elías, jun k'alajisal re ru Lok' Pixab ri Dios ojer. Oxib junab ruc' wakib ic' man c'o tä jäb xubano. Xc'oji c'u jun nimalaj wi'jal pa ronojel ruwächulew pa tak ri k'ij ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Man xtak tä c'u bi ri tat Elías cuc' conojel ri malca'nib, xane xak xuwi ruc' ri jun chichu' malca'n pa ri tinimit Sarepta re Sidón, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Xukuje' xec'oji q'uia yawabib ri c'o ri itzel tak ch'a'c chquij pa ru k'ij ri Eliseo, jun k'alajisal re ru Lok' Pixab ri Dios ojer. Man c'o tä c'u jun ri xcunaxic, xane xak xuwi ri tat Naamán ri aj Siria, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Aretak ri winak xquita ri xubij chque, conojel ri e c'o pa ri rachoch Dios sibalaj xpe coyowal che ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Xewalij c'ut, xquesaj bi pa ri tinimit. Xquic'am bi chutza'm ri juyub ri yacom wi ri qui tinimit. Xcaj u q'uiäkic bi ri Jesús iquim. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Xk'atän c'u bi ri Jesús pa qui niq'uiajal ri winak, xe'c. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Xkaj bi ri Jesús, xe' pa Capernaum, jun tinimit re Galilea. Xeutijoj ri winak chila' ronojel k'ij re uxlanem. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ri winak xquicajmaj ru tijonic rumal chi xeutzijobej je' jas ri cuban jun ri cätakan pa qui wi'. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Xoc c'u bi pa ri rachoch Dios jun achi ri c'o jun itzelalaj espíritu che. Xurak u chi' ri achi, co xch'awic. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Xubij c'ut: ¡Aa! ¿Jas ke uj uc' la, Jesús aj Nazaret? ¿A petinak la chusachic ka wäch? In wetam wäch la, chi lal ri' ri Lok'alaj Achi ri takom lok rumal ri Dios, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ri Jesús xuyajo, xubij: ¡Chatz'apij u pa chi', chatel che ri achi! —xcha che. Te c'u ri' ri itzelalaj espíritu xuq'uiäk ri achi cho ulew chquixol ri winak, xel bic, man c'o tä c'äx xuban can che. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Conojel xecajmanic. Cäquitzijobela quib, cäquibij: ¿Jas wa' we tzij ri' ri cucoj ri tata'? ¡Cäcowin ri Are' che qui takic ri itzel tak espíritus, quebel chque ri winak! —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Quetzijon c'u chrij ri Jesús pa ronojel c'olibal chunakaj ri tinimit ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Xel c'u lok ri Jesús pa ri rachoch Dios, xoc bic pa ri rachoch ri tat Simón. Ru ji' chichu' ri tat Simón kajinak che jun nimalaj k'ak', xebochi'n c'u ri winak che ri Jesús puwi' ri chichu'. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Xnakajin che ri chichu', xtaq'ui c'u chuxcut. Xuyaj ri k'ak', xtäni c'u che. Chanim xwalij ri chichu', xeupatänij c'ut. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Aretak kajem cuban ri k'ij, conojel ri e c'o yawabib cuc' xequic'am lok chuwäch ri Jesús. Pune q'uia u wäch ri yabil ri e c'o chque ri winak, xcowin ri Jesús che qui cunaxic. Xuya ru k'ab pa qui wi' chquijujunal rech queutziric. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","E q'uia c'ut ri xebel itzel tak espíritus chque. Xquirak qui chi', xquibij: Lal ri' ri u C'ojol ri Dios, —xecha che. Queuyaj c'u ri Jesús, man cuya tä chque chi quetzijonic, rumal chi quetam u wäch chi are ri Cristo. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Aretak xsakiric, xel bi ri Jesús pa ri tinimit, xe' pa juyub jawije' ri xak cätz'inowic. Ri winak sibalaj xquitzucuj, xquiriko. Xquik'atej c'ut rech man quel tä bi chquixol. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ri Jesús xubij chque: Rajwaxic chi quine'c quintzijoj ri Utzalaj Tzij re ri Evangelio chrij ru takanic ri Dios chque ri winak pa tak ri niq'uiaj tinimit chic, are c'u wa' ri in takom wi lok, —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Xtzijon c'u ri Jesús pa tak ri rachoch Dios ri e c'o pa Galilea. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Aretak ri Jesús c'o chuchi' ri nimalaj ja' re ri mar re Genesaret, xeopan q'uia winak ruc' chutatabexic ru Tzij ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ri Jesús xeril quieb barcos ri e c'o chuchi' ri mar. E elinak lok ri chapal tak cär pa ri barcos che qui ch'ajic ri qui c'at. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Xoc c'u bic ri Jesús pa jun chque ri barcos, ri re ri tat Simón. Xt'uyi pa ri barco, xuta' tok'ob che ri tat Simón chi cukebisaj apan jubik' ri barco chuchi' ri ulew rech man cäpitz' tä ri Are' cumal ri q'uia winak. Chila' c'ut xuya lok tijonic chque ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Aretak xutänaba ri u tijonem, xubij che ri tat Simón: Chakebisaj ri barco pa ri mar. Chikasaj ri i c'at che qui chapic cär, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ri tat Simón xch'awic, xubij che: Kajtij, xujchacun ronojel ri jun ak'ab mier. Man c'o tä c'u ka chapom, —cächa'. We c'u je' cäbij la, quinban chi na wa', queinkasaj ri nu c'at, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Aretak xbantaj wa', xenoj c'u ri qui c'at chapäbal cär, je ri' chi quet'okopitaj chque tak ri cär. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ri tat Simón cuc' ri to'l tak re xequisiq'uij ri cachi'l ri e c'o pa ri jun barco chic, rech queopan che qui to'ic. Xebe' cuc' che qui to'ic, xequinojisaj c'u ri quieb barcos, je ri' chi tajin quesach pa ri ja'. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Aretak ri tat Simón Pedro xril ri xbanic, xubij: Kajaw Jesús, man takal tä chwe chi cäc'oji la wuc' rumal chi ri in, sibalaj in ajmac, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Xubij wa' rumal chi xuxej rib ri tat Simón xukuje' ri e c'o ruc' rumal ri q'uialaj cär ri xequichapo. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Xukuje' xecajman ri tat Jacobo, ri tat Juan, u c'ojol ri tat Zebedeo, cachi'l quib ruc' ri tat Simón. Xubij ri Jesús che ri tat Simón: Maxej awib. Jas ri caban chque tak ri cär, queamulij, je' caban na chque ri winak, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Xequesaj c'u lok ri qui barcos pa ri mar, xquiya cho ri ulew. Te ri' xquiya can ronojel, xebe' ruc' ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Aretak ri Jesús c'o pa jun tinimit chic, xopan jun achi ruc', ri sibalaj yawab, ri c'o itzel ch'a'c che. Ri achi, aretak xril ri Jesús, xupachba rib chuwäch. Xuchap u bochi'xic, xubij: Tat, we caj la cäcowin la che nu cunaxic, —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ri Jesús xuyuk ru k'ab, xuchap cok. Xubij che: Cwaj, —cächa'. Chutzir ba' la, —xcha che. Chanim c'ut xel ri itzel ch'a'c che ri achi, xutziric. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Xutak c'u ri Jesús chi mutzijoj wa' che apachin jun winak. Te ri' xubij che: ¡Oj la! Jec'utu ib la cho ri sacerdote. Ya ba' la ri takom can rumal ri ka mam Moisés chi cäyi' che u cunaxic jun ri c'o itzel ch'a'c che. Are c'u k'alajisabal wa' chquiwäch ri winak, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Xesax c'u na u tzijoxic wa' pa ronojel tinimit. Cäquimulij c'u quib q'uialaj tak winak chutatabexic ru tijonic ri Jesús, xukuje' rech queucunaj chque tak ri qui yabil. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Xel bi ri Jesús chila', xe' pa tak juyub ri quetz'inowic chubanic orar. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Pa jun k'ij ri Jesús tajin cuya tijonic. E t'uyut'oj c'u ri tata'ib fariseos xukuje' ri tijonelab re ri Pixab chunakaj ri Jesús. E elinak c'u lok ri e are' pa ronojel tinimit re Galilea, re Judea, xukuje' e c'o jujun ri xepe pa Jerusalén. Are c'u ri Jesús, sibalaj c'o ru chuk'ab ri Dios ruc' che cunanic. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Xeopan c'u jujun achijab cuc'am lok jun achi ri cäminak u cuerpo. K'oyol cho jun alaj u ch'at. Ri achijab xquitzucuj ri roquisaxic bi ri yawab pa ri ja chuya'ic cho ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Man xquirik tä c'ut jawije' queboc wi bic cumal ri q'uialaj winak. Xepaki c'u puwi' ri ja. Xquesaj apan jubik' ru xo'til ri ja, xquiban jun jul puwi' ri ja, xquikasaj c'u bi ri achi pa ri alaj ch'at chquixol ri winak cho ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Aretak ri Jesús xrilo chi kas quecojon che, xubij che ri achi ri cäminak u cuerpo: Tat, quesachtaj ri mac la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Te c'u ri' xpe coyowal ri fariseos xukuje' ri tijonelab re ri Pixab. Cäquichomaj pa canima', cäquibij: “¿Jachin lo wa' we achi ri' ri cubij ri äwas u bixic chrij ri Dios?” —quecha'. “Xak xuwi ri Dios cäcowin chusachic u mac jun,” —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ri Jesús chanim xuna' ri tajin cäquichomaj pa canima'. Xch'aw c'ut, xubij chque: Ri in wetam ri tajin cächomaj alak pa anima' alak, —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Jachique ri man c'äx tä u bixic che ri yawab: “Ra mac xesachtajic”, o ri u bixic: “Chatwalijok, chatbinok”? —cächa ri Jesús chque. (C'äx na u banic ri jun xukuje' ri jun chic.) ");
INSERT INTO qucTNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Rech ba' quetamaj alak chi ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak, c'o nu takanic pa qui wi' ri winak cho ruwächulew chusachic qui mac, quinban na wa', —xcha chque. Xubij che ri achi ri cäminak u cuerpo: Quinbij che la, walij ba' la. C'ama la bi ri soc la, oj la cho ja, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Chanim xwalij ri achi, xtaq'ui chquiwäch ri winak. Xutelej bi ri u soc ri k'oyol wi, xe' cho rachoch, tajin cunimarisaj u k'ij ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Conojel ri winak sibalaj xquicajmaj ri xubano, xquinimarisaj c'u u k'ij ri Dios. Sibalaj cäquixej quib ri winak, cäquitzijobela quib, cäquibij: Cämic ri' e c'o cajmabal ri kilom, —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Te c'u ri' xel bi ri Jesús chila', xril jun tok'il alcabal, Leví u bi', t'uyul jawije' cätoj wi alcabal. Xubij c'u che: Sa'j la wuc', —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ri tat Leví xwalijic, xuya can ronojel, xe' ruc' ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ri tat Leví xuban c'u jun nimalaj ula'nem che ri Jesús cho rachoch. Xeopan q'uia chque ri tok'il tak alcabal, xukuje' niq'uiaj tak winak chic. Xet'uyi c'u junam chi' ri mesa cuc' ru tijoxelab ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Xepe ri tijonelab re ri Pixab cachi'l ri fariseos. Xequiyaj ri tijoxelab, xquibij chque: ¿Jas che quixwi' cuc' tok'il tak alcabal xukuje' cuc' ajmaquib? —xecha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ri Jesús xch'awic, xubij chque: Ri winak ri utz qui wäch ri c'o qui chuk'ab man rajwaxic tä cunal que. Xane are rajwaxic wa' chque ri yawabib, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Man in petinak tä che qui siq'uixic ri utzalaj tak winak rech cäquiq'uex canima', cäquiq'uex c'u qui chomanic, xane che qui siq'uixic ajmaquib, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Xquibij c'u che ri Jesús: Ru tijoxelab ri tat Juan amak'el cäca'n ri ayuno, amak'el c'ut cäca'n orar. Je' c'u cäca'n ri qui tijoxelab ri fariseos xukuje'. ¿Jas c'u che ri tijoxelab la amak'el quewi'c, man cäca'n tä c'u ri ayuno? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Xubij c'u ri Jesús chque: ¿A cuya' lo ri e c'o pa jun c'ulanem cäca'n ayunar aretak c'o ri jia'xel cuc'? —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Copan c'u na ri k'ij ri man c'o tä chi ri jia'xel chquixol. Te c'u ri' cäca'n na ayunar pa ri k'ij ri', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Xukuje' xucoj jun c'utbal chquiwäch, xubij chque: Man c'o tä jun winak ri cut'is jun c'ac' c'ojbal chrij ri k'el atz'iak. We je ri', ri c'ac' cutek'tobisaj na ri' ri k'el, xukuje' ri c'ojbal ri esam che ri c'ac' atz'iak man cuc'ulajij tä rib ruc' ri k'el, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Man c'o tä c'u jun winak ri cuya c'ac' vino pa tak k'el tak k'ebal re tz'um. We je ri', ri c'ac' vino queut'ubij ri' ri tz'um, cätix c'u na ri' ri vino, queetzeletaj can ri' ri tz'um. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Are ri c'ac' vino cäyi' na pa c'ac' tak k'ebal re tz'um. Je ri' man cäsach tä u wäch ri vino, o ri c'olibal re. ");
INSERT INTO qucTNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Man c'o tä jun winak ri craj cutij re ri c'ac' vino we nabe u tijom re ri k'el vino. Cubij na ri' ri winak chi are utz na ri k'el vino, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Pa jun k'ij re uxlanem oc'owem re ri Jesús pa tak ri tico'n. Ru tijoxelab tajin quequich'up ru jolom trico, quequik'ich pa qui k'ab, quequitijo. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Jujun tata'ib fariseos xquibij: ¿Jas che cäban alak ri äwas u banic pa ri k'ij re uxlanem? —xecha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ri Jesús xch'awic, xubij chque ri fariseos: ¿A mat ne siq'uim alak jas ri xuban ri ka mam David aretak xnumic, xukuje' ri xca'n ri e c'o ruc'? —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Xoc c'u bi ri ka mam David pa ri rachoch Dios, xuchap ri wa ri e yo'm cho ri Dios, xutijo, xuya que ri e c'o ruc' xukuje'. Äwas c'u ne u tijic wa' cumal xak jachinok. Xane xak xuwi chque ri sacerdotes ya'tal wi wa', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Xukuje' xubij chque: Ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak, c'o nu takanic puwi' ri k'ij re uxlanem xukuje', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pa jun k'ij re uxlanem chic xoc bi ri Jesús pa ri rachoch Dios, xuchap c'u u ya'ic tijonic chque ri winak. C'o jun achi chila' ri cäminak jun u k'ab, ri u wiquiäk'ab. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Caluchi'x c'u ri Jesús cumal ri tijonelab re ri Pixab, xukuje' cumal ri tata'ib fariseos, che rilic we ri Are' cärutzirisaj ru k'ab ri achi pa ri k'ij re uxlanem rech cuya' cäquibij chi c'o u mac. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ri Jesús xretamaxtaj ri qui chomanic. Xubij c'u che ri achi ri cäminak u k'ab: Walij ba' la, tac'al la pa ka niq'uiajal, —xcha che. Xwalij c'ut, xtaq'ui chila'. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Xubij ri Jesús chque ri niq'uiaj winak ri e c'olic: C'o ri cwaj quinta' chech alak, —cächa chque. ¿Jachique ri ya'tal u banic pa ri k'ij re uxlanem? ¿A are ri u banic utzil? ¡We ne are ri u banic etzelal! ¿A ya'tal ri u to'ic ru c'aslemal jun o ri u cämisaxic? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ri Jesús co xca'y chque conojel ri e c'o pa tak u xcut, xubij c'u che ri achi: Yuku ri k'ab la, —xcha che. Je' xubano, xutzir c'u can ru k'ab. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ri u c'ulel ri Jesús sibalaj xejik' che ri coyowal, xquich'abla c'u quib jas ri quecowin chubanic chrij ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Pa ri k'ij ri' xe' ri Jesús pa jun juyub chubanic orar. Xroc'owisaj ronojel jun ak'ab pa oración cho ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Aretak xsakiric, xeusiq'uij ru tijoxelab, xeucha' cablajuj, xubij apóstoles chque (ri quel cubij “nu tako'n”). ");
INSERT INTO qucTNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","E are tak wa' ri xeucha' ri Jesús: Ri tat Simón ri xukuje' cäbix Pedro che, ri tat Andrés u chak' ri tat Pedro, ri tat Jacobo xukuje' ri tat Juan, ri tat Felipe xukuje' ri tat Bartolomé. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Xeucha' c'u ri tat Mateo xukuje' ri tat Tomás, ri tat Jacobo ru c'ojol ri tat Alfeo, xukuje' ri tat Simón ri cäbix “u nimal tinimit” che. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Xukuje' xeucha' ri tat Judas ru chak' ri tat Jacobo, xukuje' ri tat Judas Iscariote ri xjachow ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","E rachi'lam ru tijoxelab, ri Jesús xkaj lok pa ri juyub, xtaq'ui c'u pa jun lianic. Sibalaj e q'uia ri winak ri xebel lok pa conojel tak ri tinimit re Judea, pa ri tinimit Jerusalén, xukuje' pa tak ri tak'aj re Tiro xukuje' re ri Sidón. Xeopan c'u ruc' ri Jesús chutatabexic ri cubij, xukuje' rech quecunax che tak ri qui yab. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Xukuje' xerutzirisaj ri winak ri cäquirik c'äx cumal ri itzel tak espíritus. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Conojel ri winak cäquitzucuj cäquichap cok ri Jesús rumal rech chi quel chuk'ab ruc' che qui cunaxic conojel. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Xca'y c'u ri Jesús chque ru tijoxelab, xubij chque: Utz iwe ix ri ix meba'ib rumal chi ri Dios cätakan pi wi'. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Utz iwe ix ri quixnum cämic rumal chi sibalaj c'o ri quitij na. Utz iwe ix ri quixok' cämic rumal chi quixtze'n na ruc' quicotemal. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Utz iwe ix aretak quetzelax i wäch cumal ri winak, xukuje' aretak quixquesaj bi cuc', quixquiyok'o, xukuje' aretak quetzijon chiwij je' ta ne chi ix lawalo tak winak. Utz iwe aretak ri winak cäca'n ronojel wa' chiwe xa rumal wech in, in ri' ri Ralc'ual ri Dios ri Kas Winak, —cächa ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Sibalaj chixquicot pa ri k'ij ri', chixtze'nok, rumal chi nim ri tojbal iwe ri quirik na pa ri caj. Xukuje' ne ri cati't qui mam we winak ri' je' xca'n chque ri k'alajisal tak re ru Lok' Pixab ri Dios ojer, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Tok'ob c'u i wäch ix, ri ix k'inomab, rumal chi ya xixquicot ix waral. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Tok'ob i wäch ix ri sibalaj c'o quitij cämic rumal chi cäpe ri k'ij ri sibalaj quixnum na. Tok'ob i wäch ix ri xa quixtze'n ruc' quicotemal cämic rumal chi quixbison na, quixok'ic. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Tok'ob i wäch ix aretak conojel ri winak sibalaj utz quetzijon chiwij, rumal chi je' xca'n ri cati't qui mam we winak ri' ojer chque ri xquijaluj quib chi e k'alajisal tak re ru Lok' Pixab ri Dios, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Quinbij c'u chiwe ix ri tajin quitatabej ri nu tzij: Cheiwaj ri cäca'n qui c'ulel chiwe. Chibana utzil chque ri queetzelan i wäch. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Chibij: Ri Dios c'o pi wi', —quixchok chque ri winak ri cäquitzak itzel tzij pi wi'. Chibana orar pa qui wi' ri queyok'on chiwe, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","We c'o jun catch'ayow che ri juperaj a palaj, chaya ri juperaj chic chuwäch. We c'o jun cumaj ra chaquet, chaya che chi cuc'am bic xukuje' ra camixa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Chaya che apachin ri c'o jas cuta' chawe. Mata' chi ri jastak awe che ri jun ri xuc'am bic. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ri quiwaj chi cäca'n na ri winak chiwe, je' chibana ix chque xukuje', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","We xak xuwi queiwaj ri winak ri quixcaj ix, ¿jas ta c'u che quichomaj chi i banom jun nimalaj utzil? Xukuje' ne ri ajmaquib cäcaj quib. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","We xak xuwi quiban utzil chque ri winak ri quebanow utzil chiwe, ¿jas c'u che quichomaj chi c'o nimalaj utzil i banom? Are je' cäca'n ri ajmaquib xukuje', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","We xak xuwi quiya qui jalomal ri cu'l i c'ux chquij chi cäquitzelej chi na wa', ¿jas ta che ri' quibij chi i banom utzil? Xukuje' ne ri ajmaquib cäquiya ri qui jalomal ri cach tak ajmaquib ri cu'l qui c'ux chquij chi cäquitzelej chi na wa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Cheiwaj ri cäca'n qui c'ulel chiwe. Chibana utzil. Chiya jalomal, micu'ba iwanima' chrij chi cätzelex chi na wa' jumul chic. Nim c'u ri tojbal iwe, cäk'alajin c'u na chi kas ix ralc'ual ri Dios aj Chicaj, rumal chi sibalaj utz cuban ri Dios chque ri man quemaltioxin taj, xukuje' chque ri lawalo tak winak. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Chitok'obisaj qui wäch ri winak je' jas ri Dios ri i Tat u tok'obisam i wäch ix, —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Mik'at tzij pa qui wi' niq'uiaj winak chic, man cäk'at tä c'u na tzij pi wi' ix rumal ri Dios. Mibij tzij chquij ri winak, man cäbix tä na tzij chiwij ix rumal ri Dios. Chisacha ri qui mac jule' chic, cäsach c'u na i mac ix. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Chiya ix chque niq'uiaj chic, ri Dios c'ut cuya na chiwe ruc' jun utzalaj pajanic, t'icom, cänoj ra c'olibal, cäjat'jatic, —cächa'. Rumal chi jas ri pajanic ri quiya ix, je' ri pajanic ri cuya na ri Dios chiwe, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ri Jesús xucoj chi na jun c'utbal chic rech tijonic, xubij: ¿A cäcowin lo jun winak ri man cäca'y taj chuc'amic u be jun winak chic ri man cäca'y taj? ¿A mat junam ri' quetzak bi pa jun jul? —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Man c'o tä jun tijoxel ri nim na u banic chuwäch ri rajtij. Pune ta ne aretak cätijotaj ri tijoxel, junam c'u na ruc' ri rajtij, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Jas che c'o cabij chquij niq'uiaj winak chic? Je' ta ne chi caca'yej jun alaj mes ri c'o pa ru wak'äch ri awachalal, man cawil tä c'u ri a mac at ri je' ta ne jun tem ri c'o pa ri a wak'äch. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Je' ta ne chi cabij che ri awachalal: “Chaya chwe chi quinwesaj cok ri alaj mes ri c'o pa ra wak'äch,” —catcha che. ¡Xak quieb a wäch! Man cawil tä c'u ri tem ri c'o pa ra wak'äch at. Nabe rajwaxic casuc'umaj ri a c'aslemal at je' ta ne chi cawesaj bi jun tem pa ra wak'äch. Te c'u ri' kas utz catca'y na che resaxic cok ri alaj mes pa ru wak'äch ri awachalal ri je' ta ne xa jun mac ri man nim taj, —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Man c'o tä jun che' ri man utz taj ri cuya utz u wächinic. Man c'o tä c'u jun utzalaj che' ri cuya u wächinic ri man utz taj. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Are etamtal ri jun che' rumal ru wächinic. Man quetam tä higos chrij ri q'uix, man quetam tä c'u uvas chquij ri juwi' q'uix, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Jun utzalaj winak are cutzijoj ri utzil ri c'o pa ranima'. Jun winak ri man utz taj are cutzijoj ri' ri lawaloyil ri c'o pa ranima'. Xak xuwi cutzijoj jun winak jas ri c'o pa ranima', —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jas che quibij chwe: “Kajaw, Kajaw,” —quixcha chwe. Man quinimaj tä c'u ri quinbij, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Quinc'ut na chiwäch jachin ruc' quinjunamaj wi ronojel winak ri cäpe wuc' in, ri cutatabej ri quinbij xukuje' cänimanic, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Junam wa' we winak ri' ruc' jun winak ri cuyac rachoch. Cuc'ot ri ulew, naj cukasaj. Cuban ri tac'alibal re ri ja puwi' ri abaj. Aretak cäpe jun nimalaj u wo ja', ri ja' cupuq'uij rib chrij ri ja ri', man cäcowin tä c'u chuyico'misaxic rumal chi yacom wa' puwi' ri abaj, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ri winak c'ut ri quetataben ri nu tzij, man queniman tä c'u ri', e are' junam ruc' ri winak ri cuyac ri rachoch puwi' ri ulew, man cuban tä c'u ru tac'alibal ri ja. Aretak cäq'uiy ri ja', cupuq'uij rib chrij ri ja, chanim cätzakic, cäyojyob c'u ri ja, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Aretak xto'taj ri Jesús che qui tzijobexic ri winak, xe' ri Are' pa ri tinimit Capernaum. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Chila' c'ut c'o jun achi qui nimal soldados. C'o jun patänil re ri tata' ri sibalaj lok' chuwäch. Ri achi patäninel are sibalaj yawab, cämic cubano. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Aretak ri tata' xuta u tzijol ri Jesús, xeutak bi jujun chque ri nimak tak tata'ib que ri winak aj Israel ruc' ri Are' rech cäquibochi'j chi copan ruc' chucunaxic ri patänil re. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Xebe'c, xeopan c'u ruc' ri Jesús, sibalaj xebochi'n che, xquibij: Takal che ri tata' ri' chi cäto' la che, ");
INSERT INTO qucTNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","rumal chi are jun winak ri sibalaj lok' queril ri ka winakil uj, xuban c'u ke ri rachoch Dios ri cäkamulij wi kib, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Xe' ri Jesús, xerachi'laj bic. Nakaj chi c'ut c'o wi che ri rachoch ri qui nimal soldados, aretak ri are' xeutak bi jujun tak rachi'l chubixic che ri Jesús: Tat, mäcos ib la. Man takal tä chwe chi coc la lok pa ri wachoch. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Rumal ri' xinchomaj in chi man takal tä chwe chi quinopan in uc' la. Xane xak xuwi we cäbij la lok ri tzij, cäcunataj na ri patänil we, —cächa ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Rumal rech chi ri in, in winak ri c'o jun pa nu wi', ri in c'ut xukuje' quintakan in pa qui wi' ri nu soldados. Quinbij che jun: ¡Jat! —quincha che. Que' c'ut. Quinbij che ri jun chic: ¡Sa'j! —quincha che. Ri are' cäpetic. Quinbij che ri patänil we: ¡Chabana wa'! —quincha che. Cuban c'ut, —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Aretak xuta wa' ri Jesús, sibalaj xucajmaj. Xutzolk'omij rib, xubij chque ri winak ri e teretoj chrij: Tzij ba' chi chquixol ri winak aj Israel man c'o tä jumul nu rikom in jun achi junam ruc' ri tata' ri' ri sibalaj cäcojonic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Aretak xetzelej bic ri u tako'n ri tata' cho ja, xquirik chi ri patänil re ri tata' ya utz chic ri are'. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Te c'u ri' xe' ri Jesús pa jun tinimit chic, Naín u bi', xukuje' e benak ruc' q'uia chque ru tijoxelab cuc' niq'uiaj winak chic. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nakaj chic c'o wi ri Jesús che ri tinimit, te' xrilo chi c'o jun cäminak telem lok rech cäc'am bi pa mukic. Ri cäminak ri' are xa jun chi ala, ral jun malca'n chichu'. E c'o q'uia winak re ri tinimit e teren chrij. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Aretak ri Jesús xril ri malca'n, xel ranima' che, xubij: Man cok' tä chi la, nan, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Xkeb ri Jesús ruc' ri cäminak, xuchap cok ri u cäxon. Xetaq'ui c'ut ri e teleninak. Xubij c'u ri Jesús: Ala, —xcha che. Quinbij chawe, ¡chatwalijok! —xcha che ri cäminak. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Xwalij c'u ri ala ri xcäm na, xuchaplej ch'awem. Ri Jesús xujach can che ru nan. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Sibalaj xquixej quib conojel ri winak, cäquinimarisaj c'u u k'ij ri Dios. Cäquibij xukuje': C'o jun k'alajisal re ru Lok' Pixab ri Dios ri sibalaj nim u banic chkaxol. Xukuje' xquibij: Petinak ri Dios chubanic utzil che ru tinimit, —xecha ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ri xuban ri Jesús cätzijox wa' cumal conojel ri winak aj Judea xukuje' pa ronojel ri tinimit ri e c'o nakaj che ri Judea. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ru tijoxelab ri tat Juan xquiya u tzijoxic ronojel wa' che. Are c'u ri tat Juan xeuch'abej quieb chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Xeutak bi ruc' ri Jesús rech cäquita' che ri Are' we kas tzij Are ri Cristo ri cäpe na, o we are rajwaxic chi cäqueyej na Jun chic. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Xeopan c'u ri achijab ruc' ri Jesús, xquibij che: Ri tat Juan Kasal Ja' uj u takom lok uc' la, chuta'ic che la we lal ri' ri Cristo ri cäpe na, o we rajwaxic cäkeyej na Jun chic, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Che we chanim ri', aretak xeopanic, ri Jesús xerutzirisaj q'uia winak che ri qui yab, xukuje' xeresaj bi ri itzel tak espíritus ri e c'o chque jujun winak. Xuban c'ut chi xeca'y q'uia moyab. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Te ri' xch'aw ri Jesús, xubij chque ru tijoxelab ri tat Juan: Jitzijoj che ri tat Juan ri iwilom, ri i tatabem, chi ri moyab queca'y chic, ri ch'ocojib quebinic, ri winak ri c'o itzel ch'a'c chque queutzirisaxic, ri so'rab cäquita chic, ri cäminakib quec'astajisaxic, xukuje' cätzijox ri Utzalaj Tzij re ri Evangelio chque ri meba'ib. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Utz re ri winak ri man cuban tä quieb u c'ux chwij, xane kas tzij cäcojon chwe, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Aretak xebe' ru tako'n ri tat Juan, ri Jesús xuchaplej u tzijoxic ri tat Juan chque ri winak, xubij: ¿Jas ri' ri xe' alak che rilic pa tak ri juyub ri quetz'inowic? —cächa'. ¿A xe' alak che rilic jun winak ri xa cäquieblan ranima' je' ta ne chi are jun aj ri cäslabisax rumal ri quiäkik'? —cächa'. Man are taj, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Jas c'u ri xe' alak che rilic? ¿A xe' alak che rilic jun achi ri u cojom utzalaj tak ratz'iak? Ri winak ri c'o je'lalaj tak catz'iak, ri quequicot ruc' ri qui k'inomal, queriktaj wa' pa tak cachoch ri nimak tak takanelab, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Jas c'u lo ri xe' alak che rilic? ¿A xe' alak che rilic jun k'alajisal re ru Lok' Pixab ri Dios? —cächa'. Je ri', —cächa'. Ri tat Juan c'ut, are nim na u banic chquixol ri k'alajisal re ru Lok' Pixab ri Dios, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Are wa' ri achi ri tz'ibam chrij pa ru Lok' Pixab ri Dios, cubij: Quintak bic ri nu tako'n ri cänabej c'u na chawäch, ri cusuc'umaj na ra be chawäch, —cächa ri Tz'ibtalic, —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Quinbij chiwe chi man c'olinak tä jun k'alajisal re ru Lok' Pixab ri Dios ri kas nim na u banic cho ri tat Juan ri Kasal Ja' chquixol conojel ri winak cho ruwächulew, —cächa'. Pune ta ne ri tat Juan are jun qui nimal winak, ri man kas nim u banic jawije' cätakan wi ri Dios, are nim na u banic wa' cho ri tat Juan. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Aretak xquita wa' ri tok'il tak alcabal xukuje' ri niq'uiaj winak chic ri banom qui kasna' rumal ri tat Juan, xquibij chi ri Dios kas tzij cuban jicomal tzij. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Are c'u ri tata'ib fariseos xukuje' ri tijonelab re ri Pixab ri man banom tä qui kasna' rumal ri tat Juan, man nim tä xquil wi ri u Tzij ri Dios ri tzijom chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Xubij c'u ri Kajaw Jesús: ¿Jas c'u ruc' queinjunamaj wi ri winak re we k'ij junab ri'? ¿Jas c'u ruc' e junam wi? —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Xak e junam cuc' ri alabom ri e tac'atoj pa tak ri c'ayibal, ri cäquich'abela quib, cäquibij: “Xkok'esaj ri su' chiwe, man xixxojow taj. Xkaban u k'ojom cäminak, man xixok' tä c'ut,” —quecha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Xul c'u ri tat Juan ri Kasal Ja' ri man wi'j taj, ri man cutij tä vino. Quixtzijon c'u chrij, quibij: Xa c'o jun itzelalaj espíritu che, —quixcha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Xinpe c'u ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak. Quinwi'c, quintij vino. Quixtzijon c'u chwij, quibij: Chiwilampe', are jun jik'alaj achi, jun k'abarel ri cachi'l tok'il tak alcabal xukuje' ajmaquib, —quixcha chwe. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ri winak c'ut ri cäca'n ronojel ruc' no'j, cäquic'ut chkawäch chi kas utz ri' ri no'j ri cuya ri Dios, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Jun chque ri tata'ib fariseos xuta' tok'ob che ri Jesús chi cäwi' ruc'. Xoc c'u bi pa rachoch ri fariseo, xt'uyi chi' ri mesa. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Jun ixok re be, ri quel pa ri tinimit, xuto chi tajin cäwi' ri Jesús pa ri rachoch ri fariseo. Xe'c, xuc'am bi jun c'olibal cunabal re alabastro nojinak che c'oc'alaj cunabal. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Xc'oji c'u pa rakan ri Jesús, tajin cok'ic. Xuchaplej qui ja'xic ri rakan ruc' ri u wal u wäch, queusu' c'u che ru wi'. Xeutz'umaj ri rakan, xutix ri c'oc'alaj cunabal chquij. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Aretak ri tata' fariseo ri xula'n ri Jesús xril ri xuban ri ixok, xchoman pa ranima', xubij: “We ta are k'alajisal re ru Lok' Pixab ri Dios we achi ri', cuch'ob ta ri Are' jachin ri ixok ri'. Xukuje' cuch'ob ta na jas u banic ri ixok ri cächapow cok, chi are jun ixok re be wa',” —xcha ri fariseo pa ranima'. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Xch'aw ri Jesús, xubij che ri fariseo: Tat Simón, c'o ri cwaj quinbij na che la, —xcha'. Xch'aw ri tat Simón, xubij che: Ajtij, bij ba' la chwe, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Cubij c'u ri Jesús: E c'o quieb winak c'o qui c'as ruc' jun ya'l jalomal. Jun chque c'o jun ciento quetzales u c'as ruc' ri tata'. Ri jun chic xa lajuj quetzales u c'as, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Rumal c'u rech chi man c'o tä qui rajil chutojic ri qui c'as, ri ya'l jalomal xubij chque chi utz la' we man cäquitoj tä chic, —cächa ri' chque. ¿Jachin c'u chque ri ajc'asib ri kas lok' xril wi ri ya'l jalomal? —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Xch'aw c'u ri tat Simón, xubij: Quinchomaj in chi are ri jun ri nim na u c'as, ri man xutoj tä chic, —xcha'. Xubij ri Jesús che: Utz u ch'obic xban la, —cächa che. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ri in xinoc lok pa ri achoch la. Man xya tä la joron chwe che qui ch'ajic ri wakan. Ri ixok ri' u ja'm ri wakan che ri u wal u wäch, xeusu' c'u che ru wi', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Man xintz'umaj tä la. Are c'u ri ixok aretak xinoc lok, xuchap u banic wa' chwe, man u tänabam tä qui tz'umaxic ri wakan. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Man xya tä la aceite pa nu wi'. Ri are c'ut u yo'm c'oc'alaj cunabal chquij ri wakan. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Quinbij che la chi quesachtaj na ri q'uialaj tak u mac rumal chi sibalaj lok' quinrilo. Apachin c'ut ri cuna' pa ranima' chi man nim tä más ru mac ri quesachic, man lok' tä más ri Dios chuwäch, —xcha ri Jesús che. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Xubij c'u che ri ixok: Quesachtaj ba' ra mac, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ri e c'o ruc' ri Jesús chi' ri mesa cäquitzijobela quib, cäquibij: ¿Jachin lo wa' we achi ri' ri cäsachow mac? —xecha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Xubij c'u ri Jesús che ri ixok: Nan, a rikom ru tobanic ri Dios rumal chi kas tzij catcojonic. Cuya' cate'c, chuxlan ba' ri awanima', —xcha ri Jesús che. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Te c'u ri' ri Jesús xusolij conojel ri tinimit xukuje' conojel ri niq'uiaj c'olibal ri e c'o wi winak, xutzijoj ru Lok' Pixab ri Dios chque. Cuya retamaxic ri Utzalaj Tzij re ri Evangelio chrij ru takanic ri Dios pa qui wi' winak. E c'o c'u ri cablajuj u tako'n ruc'. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","E benak ruc' xukuje' jujun ixokib ri e utzirisam chque itzelalaj tak espíritus xukuje' chque tak ri qui yab. E are c'u wa': Ri nan María ri cäbix Magdalena che. Esam c'u bic wukub itzelalaj tak espíritus che. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","C'o ri nan Juana, rixokil ri tat Chuza, ru mayordomo ri tat Herodes. C'o c'u ri nan Susana, xukuje' q'uia ixokib chic ri xquicoj ri jastak que chuto'ic ri Kajaw Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Xquimulij c'u quib q'uia winak. Xeopan winak ruc' ri Jesús ri xepe pa ronojel tinimit. Ri Are' xucoj jun c'utbal chuya'ic tijonic chque, xubij: ");
INSERT INTO qucTNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Jun ticol ija' xel bi cho ja, xe' c'u pa ticonijic. Aretak xjopinic, xkaj jubik' ri ija' pa ri be, xtac'alexic. Xukuje' xekaj lok ri chicop ajuwocaj, xquitij bi ri ija'. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Xkaj xukuje' jubik' ri ija' pa tak abaj. Xuchaplej q'uiyem. Xchaki'jar c'ut rumal chi man c'o tä u räxil ri ulew. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Xkaj chi jubik' pa tak ri k'ayes ri c'o qui q'uixol. Xq'uiy ri ija' junam ruc' ri k'ayes. Xjik'isax c'u ri tico'n rumal. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Xkaj chi jubik' pa utzalaj ulew, xebel c'u lok, xeq'uiyic. Xquiya jun ciento qui wäch chquijujunal chupam ru jolom trico, —xcha chque. Aretak ri Jesús xto'taj chutzijoxic wa', co xch'awic, xubij: ¡Ri ix ri i jiquibam ri iwanima' chutatabexic ri nu tzij, chitatabej ba'! —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ru tijoxelab xquita' che ri Jesús, xquibij: ¿Jas quel cubij wa' we c'utbal ri'? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Xch'aw chi ri Jesús, xubij chque: Yo'm chiwe ix ri retamaxic ri man quetam tä ri niq'uiaj winak chic chrij ri u takanic ri Dios. Queincoj c'u c'utbal che qui tijoxic ri niq'uiaj winak chic rech pune queca'yic, je' ta ne chi man c'o tä cäquilo, pune cäquitatabej ri tzij, man cäquich'ob tä ri' ri qui tatabem, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Are c'u wa' ri quel cubij ri xintzijoj chiwe: Ri ija' are ru Tzij ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ri ija' ri xekaj pa ri be, e are junam jas ri winak ri cäquita ri Tzij. Copan c'u ri Itzel, cäresaj ri Tzij pa canima' rech man quecojon taj, man cäquirik tä ru tobanic ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ri ija' ri xkaj pa tak abaj, e are' junam jas ri winak ri cäquic'amowaj ri Tzij. Aretak cäquito, quequicotic. Man c'o tä c'u ri qui xera'. Xa quieb oxib k'ij cäquicojo. Aretak c'ut cäquichap u rikic c'äx, quetzelej canok, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ri ija' ri xkaj pa tak ri k'ayes e are' junam jas ri winak ri cäquita ri Tzij. Te c'u ri' cäquitakej chi na jumul ri qui be. Sibalaj que' canima' ruc' ri k'inomal ajuwächulew, que' canima' cuc' tak ri nimak'ij, xukuje' ruc' ri qui chac. Cäjik'isax c'u ru Tzij ri Dios pa canima', man cäquiya tä c'u ri qui wächinic, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ri ija' c'ut ri xkaj pa utzalaj ulew, quinjunamaj cuc' ri winak ri utz canima', ri cäca'n ronojel ruc' jicomal, cäquijiquiba canima' chrij ri Tzij ri xquitatabej. Cäquitakej c'ut, sibalaj quewächinic, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Xubij chi na ri Jesús: Man c'o tä jun winak ri cutzij jun chäj o jun candela, te ri' cuch'uk wa' che jun lak. Man cuya tä c'u wa' chuxe' jun ch'at. Xane cuya wa' chicaj rech quilitaj ru sakil cumal ri winak ri queboc bi pa ja, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ronojel ri c'u'talic cäk'alajin na. Ronojel ri ch'uktal u wi' quel na chi sak rech quetamaxic. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kas chitatabej ba' na ri quinbij, rumal chi apachin ri c'o c'o ruc' cäyi' na niq'uiaj che. Apachin c'u ri man c'o tä c'o ruc', quesax na jas ri cuchomaj chi c'olic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Xopan c'u ru nan ri Jesús, xukuje' tak ri u chak', ri ranab. Man quecowin tä c'ut quekeb ruc' rumal quech ri q'uialaj winak. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Xbix c'u wa' che ri Jesús: Ri nan la xukuje' ri achalal la e tac'atoj cho ja. Cäch'abex la cumal, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Xch'aw ri Jesús, xubij chque: Ri winak ri cäquitatabej ru Tzij ri Dios, cäca'n c'u ri cubij, e are' nu nan wa', xukuje' e are' wa' ri kas wachalal, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Pa jun k'ij xoc ri Jesús pa jun barco, e rachi'lam c'u ru tijoxelab. Xubij ri Jesús chque: Chujk'ax jela' ch'äkäp che ri mar, —xcha chque. Xebe' c'ut. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","E benak puwi' ri mar, xwar ri Jesús. Xpe c'u jun nimalaj quiäkik' ri sibalaj c'äx puwi' ri mar. Ri barco tajin cänoj che ja', je ri' chi xak quieb cubij pa qui wi'. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Xebe' ri tijoxelab ruc' ri Jesús, xquic'asuj. Xquibij che: ¡Kajtij, Kajtij, tajin cujcämic! —xecha che. Xc'astaj c'u ri Jesús, xuyaj ri quiäkik' xukuje' ri nimak tak uwoja'. Xtäni c'u ri quiäkik', xlilob u wi' ri ja'. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Xubij ri Jesús chque ru tijoxelab: ¿Jas che man quixcojon taj? —xcha chque. Xquixej quib, xquicajmaj ri xubano, cäquibila c'u chbil quib: ¿Jachin lo wa' ri c'o u takanic puwi' ri quiäkik' xukuje' ri ja' je ri' chi queniman che? —xecha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Xeopan c'u pa ri tinimit Gadara, ri c'o apan chuwäch ri Galilea chuchi' ri mar. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Aretak ri Jesús xel lok pa ri barco, xriktaj rumal jun achi re ri tinimit. Tzq'uia junab chic e c'o itzelalaj tak espíritus che ri achi. Man cucoj tä chi ratz'iak. Man cäjeki tä cho rachoch, xane chquixol ri mukubal cäc'oji wi we achi ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Aretak xril apan ri Jesús, xurak u chi', xutzak rib chuwäch. Co xch'awic, xubij c'u che ri Jesús: ¿Jas caj la chwe, tat Jesús? Lal ri' ri u C'ojol ri Nimalaj Dios aj Chicaj, —cächa che. ¡Bana ba' la tok'ob, mäban la c'äx chwe! —xcha che ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Xubij wa' rumal chi ri Jesús tajin cätakan che ri itzelalaj espíritu chi quel bi che ri achi. Tzq'uia junab c'o u takanic ri itzelalaj espíritu puwi' ri achi. Pune cächajixic, cäxim c'u cuc' ximibal re ch'ich', xukuje' chapbal akanaj, ri achi xa queut'okopij wa', quel bic. Ri itzelalaj espíritu cäresaj bi ri achi, cuc'am bi pa tak juyub ri quetz'inowic. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Xuta' ri Jesús che, xubij: ¿Jas ri a bi'? —xcha che. Xubij che ri Jesús: Ri nu bi' are Q'uiyal, —xcha'. Xubij wa' rumal chi sibalaj e q'uia ri itzelalaj tak espíritus ri e oquinak che ri achi. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ri itzelalaj tak espíritus xquibochi'j ri Jesús chi meutak bi pa ri k'ekumalaj jul. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","E q'uia c'u ri ak ri tajin queyuk'ux apan pa ri juyub. Xquibochi'j chi chuya chque chi queboc chque ri ak. Je'ey, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Xebel c'u bi ri itzelalaj tak espíritus che ri achi, xeboc chque tak ri ak. Conojel ri ak junam xquiq'uiäk bi quib chutza'm ri juyub, xetzak bi pa ri mar, xejik'ic. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Aretak ri ajyuk'ab xquil ri xbantajic, xeanimajic, xebe'c. Xquiya u tzijol wa' chque ri winak pa ri tinimit, xukuje' pa tak ri juyub. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Xebel lok ri winak che rilic ri xbantajic. Xeopan ruc' ri Jesús. Xquirik c'u ri achi ri xebel wi ri itzelalaj tak espíritus, cojom chi ri ratz'iak, man ch'uj tä chic. T'uyul c'u ri are' chuwäch ri Jesús. Xquixej c'u quib ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ri winak ri xeilow wa' ri xbanic xquitzijoj wa' chque ri jule' winak chic jas ri rutzirisaxic ri achi ri xec'oji na q'uia itzelalaj tak espíritus che. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Te c'u ri' conojel ri winak ri e jekel wi jela' chrij ri tinimit Gadara, xquibochi'j ri Jesús chi chel bic cuc' rumal chi sibalaj xquixej quib. Xoc chi bi ri Jesús pa ri barco, xtzelejic. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ri achi ri xebel wi ri itzelalaj tak espíritus sibalaj xubochi'j ri Jesús chi cuya che chi que' ruc'. Ri Jesús xutak bi cho rachoch, xubij che: ");
INSERT INTO qucTNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Chattzelej bi cho awachoch, cheatzijoj conojel ri nimak tak utzil ri u banom ri Dios chawe, —xcha che. Xe' c'u ri achi, xuchap qui tzijoxic chque conojel ri winak re ri u tinimit ri nimak tak utzil ri u banom ri Jesús che. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Aretak xtzelej bi ri Jesús, e c'o q'uia winak ri xlec'ulanok, xequicotic. Conojel queye'm ru tzelejic. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Xopan c'u jun achi ruc' ri Jesús, tat Jairo u bi' ri achi ri'. Are qui nimal ri winak wa' pa ri rachoch Dios. Xupach ba' rib cho ri Jesús, xubochi'j chi copan cho rachoch. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Xa jun chi u mia'l ri achi ri', craj cablajuj u junab. Cämic c'u cubano. Xe' ri Jesús ruc'. Benak c'u pa ri be, sibalaj cäpitz' cumal ri q'uialaj winak. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","C'o c'u jun ixok ri u rikom c'äx cablajuj junab rumal ru quiq'uel ri xa quelic, man cätäni tä che. U sachom c'u ronojel ru rajil cuc' cunanelab. Man c'o tä jun ri cowininak che rutzirisaxic. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Xkeb c'u chrij ri Jesús, xuchap cok ru chi' ru k'u'. Chanim c'ut xtäni ru quiq'uel ri quelic. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Xubij c'u ri Jesús: ¿Jachin ri' ri xinchapowic? —xcha'. Conojel ri winak xquibij chquijujunal: Man in tä ri', —xecha che. Xubij c'u ri tat Pedro xukuje' ri e c'o ruc': Kajtij, ¿a mat quil la chi e q'uia ri winak ri e c'o chij la? Cäpitz' ba' la cumal conojel. ¿Jas che cäbij la: “¿Jachin ri' ri xinchapowic?” —cächa la, —xcha ri tat Pedro che. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Xubij c'u ri Jesús che: C'o jun winak ri xinchapowic. Xinna' chi xel jubik' ri nu chuk'ab chucunaxic jun winak, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Aretak ri ixok xrilo chi man xc'u'taj taj, xkeb ruc' ri Jesús, cäbirbitic. Xxuqui chuwäch. Xuk'alajisaj chquiwäch conojel ri winak jas che xuchap cok ri Jesús, xukuje' chi xcunatajic. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Xubij ri Jesús che: Nan, xcunataj la rumal chi cäcojon la chwe, —cächa'. Cuya' que' la, chuxlan ba' anima' la, —xcha ri Jesús che. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","C'ä tajin cätzijon na ri Jesús, aretak xopan jun ajuworachoch ri qui nimal ri winak re ri rachoch Dios. Xubij che ri tat Jairo: Xcäm ri mia'l la, —cächa che. Xak mäya chi la latz' che ri Ajtij, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Aretak ri Jesús xuta ri xbixic, xch'awic, xubij che ri tat Jairo: Mäxej ib la, —cächa'. Xane cojon la chwe. Cutzir c'u na ri ali, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Aretak xopan cho rachoch ri tat Jairo, man xraj tä ri Jesús chi c'o jachin coc bi ruc', xak xuwi ri tat Pedro, ri tat Juan, ri tat Jacobo, xukuje' ru nan tat ri ali. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Conojel ri e c'o chila' tajin quebok'ic, cäquiq'uis quib che ok'ej. Xubij ri Jesús chque: Man cok' tä chi alak. Man cäminak tä ri ali, xane xak cäwaric, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ri winak c'ut xa cäquetze'j u wäch ri Jesús rumal chi quetam chi cäminak chi ri ali. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ri Jesús xuchap ri ali che ru k'ab, co xch'awic, xubij: Ali, chatwalijok, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Xtzelej c'u lok ri ranima'. Chanim xwalijic. Xtakan c'u ri Jesús chque chi chquiya che ri cutijo. ");
INSERT INTO qucTNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Xquicajmaj wa' ru tat u nan. Ri Jesús xeupixbaj chi c'o mäquibij wi wa' ri xbantajic. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ri Jesús xeusiq'uij ri cablajuj u tijoxelab ruc'. Xuya chque chi cäc'oji qui takanic pa qui wi' conojel ri itzelalaj tak espíritus rech quequesaj bi chque ri winak. Xukuje' xuya chque chi quequicunaj ri yawabib. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Xeutak bic chutzijoxic ru Lok' Pixab ri Dios chrij ru takanic ri Dios pa qui wi' ri winak. Xeutak bi xukuje' che qui cunaxic ri yawabib. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Xubij ri Jesús chque: C'o mic'am bic che ri be. Mic'am bi i ch'imiy, i chim, i wa, o ri i rajil. Xa jun iwatz'iak chijujunal quic'am bic, —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Apachique ja ri quixoc wi, chixcanaj can chila' c'ä quitakej chi na bi jumul ri i be. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","We c'o jun tinimit ri man quixc'ulax tä wi, chixel bi chila', chitota' can ri ulew ri c'o chque ri iwakan chuk'alajisaxic chquij ri winak re ri tinimit ri' chi man utz tä ri cäca'no, c'o qui mac, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Xebe' c'ut, xebe' pa tak conojel ri alaj tak tinimit. Xquitzijoj ri Utzalaj Tzij re ri Evangelio, xukuje' xca'n cunanic pa tak conojel ri tinimit. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ri nim takanel Herodes xretamaj ronojel ri tajin cuban ri Jesús. Man curik taj jas cubano rumal chi e c'o jujun cäquibij chrij ri Jesús: Xc'astaj lok ri tat Juan Kasal Ja' chquixol ri cäminakib, —quecha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Xukuje' e c'o jule' chic cäquibij chrij ri Jesús: Ri Elías, k'alajisal re ru Lok' Pixab ri Dios ojer u c'utum rib chkawäch, —quecha'. Cäquibij c'u jujun winak chic: Jun chic chque ri ojer tak k'alajisal tak re ru Lok' Pixab ri Dios xc'astaj lok chquixol ri cäminakib, —xecha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Xubij c'u ri tat Herodes: In xintakan che resaxic u jolom ri tat Juan. ¿Jachin ta c'u lo ri' ri je' tak wa' nu tom chrij? —xcha'. Cutzucuj c'u rilic u wäch ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Aretak xetzelej lok ri u tako'n ri Jesús, xquibij che ri Are' ronojel ri qui banom. Ri Jesús xeuc'am bic, xebe' c'u qui tuquiel wi pa jun tinimit, Betsaida u bi'. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Aretak xquetamaj ri winak chi xel bi ri Jesús, xeteri bi chrij. Xeuc'ulaj c'u ri Jesús, xeutzijobej chrij ru takanic ri Dios pa qui wi' winak, xukuje' xeucunaj ri yawabib. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kajem c'u cuban ri k'ij, xekeb ri cablajuj u tijoxelab ruc' ri Jesús, xquibij che: Chetaka la bi ri winak rech quebe' pa tak ri tinimit, xukuje' cho tak ri cachoch ri winak ri e c'o chunakaj ri tinimit, che rokxanexic quib churikic ri cäquitijo. Uj c'o c'u waral pa tak juyub ri cätz'inowic, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Xubij ri Jesús chque: Chiya ix ri cäquitijo, —xcha chque. Xquibij c'u ru tijoxelab che: Man c'o tä c'o kuc' xane xa job caxlan wa cuc' quieb cär. ¿A cuje' ta c'u lo chulok'ic ri qui wa conojel we winak ri'? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Craj c'u e c'o job mil achijab. Xubij ri Jesús chque ru tijoxelab: Chibij chque ri winak chi quecu'bi pa tak mulaj re niq'uiaj tak ciento, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Je' xca'no, xecu'bi c'u conojel ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ri Jesús xeuc'am ri job wa cuc' ri quieb cär, xca'y c'u chicaj, xeutewchij. Te ri' xeupiro, xeuya chque ru tijoxelab rech cäquijach wa' chquiwäch ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Conojel xewi'c, xenojic. Xquimulij c'u ri ch'äkatak wa. Are cablajuj chicäch ri xec'oltajic. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Pa jun k'ij ri Jesús tajin cuban orar. E c'o ru tijoxelab ruc' pa qui tuquiel wi. Ri Jesús xuchap u ta'ic chque, xubij: ¿Jas cäquibij ri winak chi jachin ri' ri in? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Xech'awic, xquibij che: E c'o jujun cäquibij chi lal ri' ri tat Juan Kasal Ja'. Jule' chic cäquibij chi lal ri' ri Elías, k'alajisal re ru Lok' Pixab ri Dios ojer. E c'o chi niq'uiaj cäquibij chi lal jun chic chque ri ojer tak k'alajisal tak re ru Lok' Pixab ri Dios ri xc'astaj lok chquixol ri cäminakib, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Xubij c'u ri Jesús chque: ¿Jas c'u quibij ix chi jachin ri in? —xcha chque. Ri tat Pedro xch'awic, xubij: Lal ri' ri Cristo ri takom la lok rumal ri Dios, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ri Jesús sibalaj xeupixbaj ru tijoxelab chi c'o mäquibij wi wa' chi are ri Cristo. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Xubij chque: Rajwaxic chi ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak, quinrik na sibalaj c'äx, quinxutux na cumal ri nimak tak tata'ib, cumal ri qui nimakil sacerdotes aj Israel xukuje' cumal ri tijonelab re ri Pixab, —cächa'. Xukuje' rajwaxic chi quincämisax na. Te c'u ri' quinc'astaj chi c'u na churox k'ij chquixol ri cäminakib, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Xubij c'u ri Jesús chque conojel: We c'o jun craj cäpe wuc' in, rajwaxic chi muban xa jas ru rayinic ri are'. Rajwaxic chi cutelej lok ru cruz ronojel k'ij, chpet wuc' in. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Apachin ta ne ri nim cril wi ru c'aslemal cho ru wächulew, cäsach na u wäch wa'. Apachin ta ne ri cuya na ru c'aslemal rumal wech in, cäc'oji na u c'aslemal ri man c'o tä u q'uisic, —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Jas lo ri utzil curik jun winak we cärechbej conojel ri jastak ajuwächulew, cuya c'u ri ranima' che tojbal que, cäsach c'u u wäch we winak ri'? —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Apachique winak ri xa cäq'uix chwe in, xukuje' che ri nu tzij, in ri' ri Ralc'ual ri Dios ri Kas Winak, quinq'uix na xukuje' che ri winak ri' aretak quintzelej lok ruc' nimalaj chuk'ab jas ru petic jun nim takanel. Cänimarisax na nu k'ij pa ri k'ij ri' junam jas ru nimarisaxic u k'ij ri nu Tat xukuje' ri lok'alaj tak ángeles, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Are kas tzij ri quinbij in chiwe chi e c'o jujun chque ri e c'o waral chnuwäch ri man quecäm tä na c'ä cäquil na ru takanic ri Dios pa qui wi' ri winak, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Craj xque' wajxakib k'ij u bim chi can wa' ri Jesús, te c'u ri' xeuc'am bi ri tat Pedro, ri tat Juan xukuje' ri tat Jacobo, xepaki c'u puwi' ri juyub chubanic orar. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Aretak tajin cuban orar, xq'uextaj ru ca'yebal ri Jesús. Sibalaj xjuluw ri ratz'iak, sibalaj sakloloj xubano je' jas ri sak tew. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tzcajmabal chic, e c'o c'u quieb achijab xetac'tobic, tajin quetzijon ruc' ri Jesús, e are ri mam Moisés rachi'l ri mam Elías. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Sibalaj je'l ru juluwem qui wäch. Cäquitzijobej c'u ri Jesús chrij ri relic bic cho ru wächulew, are la' ru cämical ri curik na pa Jerusalén. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pune ri tat Pedro xukuje' ri e c'o ruc' sibalaj c'äx qui waram, man xewar taj. Xquilo chi sibalaj je'l ru juluwem ru wäch ri Jesús xukuje' ri qui wäch ri quieb achijab ri e c'o ruc'. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Elem cäca'n bi ri achijab, xubij ri tat Pedro che ri Jesús: Kajtij, ¡sibalaj utz chi uj cujc'oji na waral! Ka'na oxib cäbal, jun che la, jun che ri ka mam Moisés, xukuje' jun che ri ka mam Elías, —xcha che. Je' xubij wa' ri tat Pedro rumal chi man curik taj jas cubij. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Je' tajin cubij wa' aretak xkaj jun sutz' chquij, xech'uktaj c'ut. Xquixej quib ri tijoxelab aretak ri sutz' xeuch'uku. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Xch'aw c'u lok jun chupam ri sutz', xubij: ¡Are lok'alaj nu C'ojol wa'! Chitatabej ri cubij, —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Aretak xtäni ri ch'awem, xcanaj can ri Jesús u tuquiel. Man xech'aw tä chi c'u ru tijoxelab. Xukuje' pa tak ri k'ij ri' man xquitzijoj tä che jachin jun winak ri xquilo. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Chucab k'ij aretak xekaj lok puwi' ri juyub, e c'o q'uia winak ri xebel lok churikic ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","C'o c'u jun achi cuc' ri winak, co xch'awic, xubij: Kajtij, bana la tok'ob chwe, —xcha'. Chilampe la ri nu c'ojol xa jun chi ala ri c'o wuc'. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Amak'el cächap rumal jun itzelalaj espíritu. Curak u chi' ri ala. Ri itzelalaj espíritu cubak'atila', cupuluwisaj u pu chi', xukuje' cutota', —cächa'. Tzman craj taj quel che ri ala, —xcha ri tata'. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Xeinbochi'j ri tijoxelab la che resaxic ri itzelalaj espíritu, man xecowin tä c'u che, —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Xch'aw ri Jesús, xubij: ¡Ay, winak! Man alak nimanelab tak winak taj, tzman cäcojon tä alak, —xcha chque. ¿A are caj alak chi xak quinc'oji in uc' alak ronojel k'ij che to'ic alak? Xque' q'uia ri k'ij nu cuyum ri mac alak, —xcha chque. Xubij c'u che ri achi: C'ama la lok ri c'ojol la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Aretak tajin cäkeb ri ala ruc' ri Jesús, ri itzelalaj espíritu xuq'uiäk pulew, xubak'atila'. Ri Jesús xuyaj ri itzelalaj espíritu, xrutzirisaj ri ala. Xujach bic che ru tat. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Conojel ri winak xquicajmaj ri nimalaj u chuk'ab ri Dios. Ri winak sibalaj tajin cäquicajmaj ri xubano, xch'aw chi ri Jesús, xubij chque ru tijoxelab: ");
INSERT INTO qucTNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Chicojo retal wa' ri quinbij chiwe, —cächa chque. ¡Ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak, quinjach na bi pa qui k'ab ri winak! —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Man xquich'ob tä c'u ru tijoxelab jas ri xubij chque. Man xyi' tä chque chi cäquich'ob we tzij ri'. Xquixej c'u quib chuta'ic che jas quel cubij wa' ri xubij chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Te c'u ri' ri tijoxelab xquichap u chomalaxic quib chrij jachin chque are ri nim na u banic chquixol. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Aretak ri Jesús xretamaj ri xquichomaj pa canima', xuc'am apan jun ac'al, xutac'aba ruc'. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Xubij c'u ri Jesús chque: Apachin jun winak ri kas cäc'amow we ac'al ri' rumal wech in, in ri' quinuc'amo xukuje'. Apachin c'u ri quinc'amow in, cuc'am ri' xukuje' ri xintakow lok. Apachin c'u chiwe ri man nim tä u banic, tzare wa' ri nim na quinwil in, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Xubij c'u ri tat Juan che ri Jesús: Kajtij, kilom jun ri queresaj itzelalaj tak espíritus pa ri bi' la. Xkak'il c'u canok rumal chi man are tä jun kuc', —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Xubij ri Jesús che: ¡Mik'ila chic! —xcha'. Apachin jun winak ri man cuban tä u c'ulel chke, cujuto' na ri', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Xketet c'u lok ri k'ij re ru c'amic bi ri Jesús chicaj, xujiquiba c'u ri ranima' che ru binem pa ri tinimit Jerusalén. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ri Jesús xeutak bi u tako'n rech quenabej bi chuwäch pa ri be. Xebe' c'ut, xeopan pa jun alaj tinimit re Samaria, xquitzucuj jawije' ri cäwar wi ri Are', xukuje' ri cäwi' wi chila'. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ri winak ajchila' man xquic'ulaj tä c'ut, rumal chi xquilo chi benam re ri Jesús pa Jerusalén. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Aretak ri tijoxelab, ri tat Jacobo, ri tat Juan xquil wa' jas ri xquiban ri ajtinimit, xquibij: Kajaw, ¿a caj la chi cujtakan chukasaxic k'ak' chicaj rech cäq'uis qui wäch we winak ri', je' jas xuban ri Elías, ri k'alajisal re ru Lok' Pixab ri Dios ojer? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Xutzolk'omij rib ri Jesús, xeuyajo, xubij chque: ¿A xa man quich'ob taj chi are ri Lok'alaj Espíritu rech ri Dios ri cätakan pi wi'? Man are tä c'u ru rayinic ri Are' chi je' quiban wa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ri in c'ut, in ri' ri Ralc'ual ri Dios ri Kas Winak, man xinpe tä chusachic qui wäch ri winak, xane che qui to'ic, —xcha chque. Xebe' c'u pa jun alaj tinimit chic. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","E benak c'u pa ri be, c'o jun achi xubij che ri Jesús: Kajaw, quine' uc' la apawije' ta ne ri que' wi la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Xubij ri Jesús che: Ri yac e c'o tak ri qui jul, xukuje' e c'o ri qui soc ri chicop ajuwocaj. Are c'u ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak, man c'o tä jawije' quinwar wi, —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Xubij ri Jesús che ri jun chic: Sa'j wuc', —xcha che. Xubij ri are': Kajaw, ya la chwe chi nabe quine'c, quinmuk na can ri nu tat aretak cäcämic, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Xch'aw chi ri Jesús, xubij che: Cheaya can ri cäminakib pa ri qui mac chequimuku ri qui cäminak. Ri at c'ut, jatzijoj ru Lok' Pixab ri Dios chrij ru takanic ri Dios pa qui wi' ri winak, —xcha ri Jesús che. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Jun achi chic xubij: Kajaw, quine' na uc' la, —cächa'. Nabe c'ut ya la chwe chi quine'c, queinch'abej na can ri ajuwowachoch, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Xubij ri Jesús che: Jun winak ri cuchap u banic taji'n, we cusak'orij ru chac, man cuq'uis taj, man c'o tä u patän wa'. Xukuje' jun winak ri craj coc che tijoxel we, ri xa cuban quieb ranima', man c'o tä c'u u patän wa' che ri Dios pa ru takanic pa qui wi' ri winak, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Te c'u ri' ri Jesús xeucha' oxc'al lajuj u tijoxelab chic. Pa cacabil xeutak bic rech quenabej bi chuwäch. Xebe' c'u pa ronojel tinimit, xukuje' jawije' chi' ri rajwaxic que' wi na ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Xubij ri Jesús chque: Kas nim ri jach', xa c'u e quieb oxib ri ajchaquib. Chibochi'j ba' ri Rajaw ri jach' chi cheutaka bi ajchaquib pa ru jach', —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","¡Jix ba'! Quixintak bic je' ta ne chi ri ix, ix alaj tak chij chquixol ri utiw. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Miwuc'aj bi i borxa che ri i rajil. Mic'am bi ri i chim, mic'am c'u bi ri i xajäb. Mixtaq'ui che tzij pa tak ri be rech man quixbeytaj taj. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Apachique ja ri quixoc wi, chibij nabe: Chuxlan ba' canima' ri winak ri e c'o pa we ja ri', —quixcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","We c'o jachin jun winak cho ri ja ri' ri kas craj chi cuxlan ranima', cuc'amowaj na wa' ri i tzij re tewchibal, cuxlan c'u na ranima'. Are c'u we man c'olic, man cäcanaj tä can ri tewchibal pa qui wi' ri winak re ri ja ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Chixcanaj can pa ri jun ja ri'. Xak mixbin chi' tak ja. Quitij na ri cäyi' chiwäch, rumal chi ya'tal che ri ajchac chi cuc'am ri tojbal re ru chac, —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Apachique tinimit ri quixopan wi, we quixquic'ulaj, chitija ri cäquiya chiwäch. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Chicunaj ri yawabib ri e c'olic, chibij c'u chque: “Nakaj ix c'o wi che ru takanic ri Dios pa qui wi' ri winak,” —quixcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Apachique tinimit ri quixopan wi, ri man quixquic'ulaj tä wi ri winak, chibij can wa' chque aretak quixel bic: ");
INSERT INTO qucTNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Xukuje' ne ri ulew re ri tinimit alak ri nac'al chque ri kakan, cäkatota' na can che k'alajisabal chij alak chi man utz tä ri cäban alak. Chich'obo ba' chi nakaj chech alak c'o wi ru takanic ri Dios pa qui wi' ri winak,” —quixcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Quinbij c'u chiwe chi pa ri k'ij ri cäpetic, ri cuk'at na tzij ri Dios, cätan na ri' ri c'äjisabal u wäch ri tinimit Sodoma chuwäch ri c'äjisabal u wäch ri tinimit ri', —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","¡C'äx iwe, winak re ri tinimit Corazín! ¡C'äx iwe, winak re ri tinimit Betsaida! We ta xeban ri cajmabal ri' pa ri tinimit Tiro, pa ri tinimit Sidón, jas ri xebantaj iwuc' ix, q'uextajinak ta chi na ri canima' ri winak jela', qui cojom ta chi catz'iak ri cuk'alajisaj chi quebisonic. Xukuje' c'o ta banom wi ri cuk'alajisaj chi are ri qui mac ri quebison che, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Rumal ri' cätan na ri c'äjisabal qui wäch ri winak aj Tiro, aj Sidón chuwäch ri c'äjisabal i wäch ix aretak cäk'at na tzij pi wi'. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ri ix c'ut, winak re ri tinimit Capernaum, ri sibalaj xinimarisaj iwib, c'ä pa ri k'ak' quixkasax wi na, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Xch'aw chi ri Jesús, xubij: Apachique winak ri cutatabej ri i tzij ix, in ri' ri quinutatabej. Apachin ri man nim tä quixrilo, in ri' ri man nim tä quinril wi xukuje'. Apachin c'u ri man nim tä quinrilo, man nim tä cäril wi ri' ri xintakow lok, —xcha chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ruc' quicotem c'ut xetzelej lok ri oxc'al lajuj tijoxelab ruc' ri Jesús, xquibij: Kajaw, xukuje' ri itzelalaj tak espíritus queniman chke aretak cäkacoj ri bi' la, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Xubij ri Jesús chque: Ri in xinwil ri xuban ri Satanás, aretak xtzak lok chicaj jas cuban ri caypa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ri in nu yo'm ri i chuk'ab rech quixcowinic quitac'alej tak cumätz xukuje' tak ixterix. Nu yo'm xukuje' ri i chuk'ab chrij ronojel ri cuban ri ka C'ulel, rech quixch'acan na puwi', man c'o tä c'u jas jun c'äx ri cäcowin chubanic chiwe ix, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mixquicot ba' rumal chi ri itzel tak espíritus queniman chiwe, xane are chixquicot na rumal chi e tz'ibam ri i bi' chicaj, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kas pa ri hora ri' sibalaj xquicot ri Jesús rumal ri Lok'alaj Espíritu, xubij: Maltiox che la, Tat, lal Rajaw ri cajulew, chi xban la chi ri ajno'jab, xukuje' ri c'o quetambal man cäquich'ob tä wa' we tzij ri'. Xane xec'ut la chquiwäch winak ri man c'o tä quetambal je' ta ne e are' alaj tak ac'alab. Je', Tat, je ri' ri utzalaj rayinic la, —xcha ri Jesús che. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Xubij xukuje': Ronojel ri c'olic are jachom chwe in rumal ri nu Tat. Man c'o tä jun ri kas retam jachin ri' ri u C'ojol ri Dios. Xak xuwi ri ka Tat retam. Man c'o tä c'u jun ri kas retam jachin ri' ri Dios ka Tat, xane xak xuwi ri u C'ojol. Apachin c'u chuwäch ri craj ri u C'ojol ri Dios cuc'ut wi wa', xukuje' ri winak ri' retam jachin ri' ri Dios ka Tat, —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ri Jesús xutzolk'omij rib cuc' ru tijoxelab, xubij chque pa qui tuquiel wi: Utz que ri winak ri cäquil ronojel wa' ri tajin quiwil ix, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Je' quinbij chiwe chi e c'o q'uia chque ri ojer tak k'alajisal re ru Lok' Pixab ri Dios, xukuje' nimak tak takanelab ri xquirayij ri rilic jas ri quiwil ix, man xquil tä c'ut. Xquirayij u tatabexic jas ri quitatabej ix, man xquita tä c'ut, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Xtaq'ui c'u ak'an jun tijonel re ri Pixab che resaxic u pu chi' ri Jesús, xuta' che, xubij: Ajtij, ¿jas c'u quinban in rech quinrik na ri c'aslemal ri man c'o tä u q'uisic? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Xubij ri Jesús che: ¿Jas ri' ri tz'ibam pa ri Pixab? ¿Jas pu ri cäsiq'uij la u wäch? —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Xch'aw chi ri tijonel re ri Pixab, xubij: “Sibalaj chiwaj ri i Dios ri Iwajaw, chijiquiba ri i c'ux, chijiquiba ri iwanima' chrij, chicojo ri i chomanic, chitija c'u i chuk'ab chubanic wa',” —cächa'. “Chiwaj c'u ri iwach winak jas ri ix quiwaj iwib,” —cächa ri Lok' Pixab, —xcha ri tata'. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Xubij ri Jesús che ri tata': Kas tzij ri bim la. Bana ba' la wa', c'o c'u na ri c'aslemal la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Are c'u ri tata' craj cuk'alajisaj rib chi jicom ranima', xubij c'u che ri Jesús: ¿Jachin ri' ri wach winak? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Xch'aw chi ri Jesús, xubij che: Jun achi xel bi pa ri tinimit Jerusalén, benam c'u re pa ri tinimit Jericó. Xchap c'u cumal elak'omab pa ri be. Ri e are' xquesaj bi ri ratz'iak, xquich'ayo. Xebe' c'ut, xquiya canok. Xa c'u jubik' man xcäm ri achi, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Xkaj c'u bi jun chque ri sacerdotes aj Israel pa ri be ri'. Aretak xril ri achi, naj xoc'ow wi che. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Xopan xukuje' jun tata' Levita jawije' c'o wi ri achi. Aretak xril ri achi soctajinak, ri are' naj xoc'ow wi che xukuje'. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Benak c'u jun tata' aj Samaria pa ri be ri'. Aretak xril ri achi ri soctajinak pol pa ri be, xel ranima' che, xutok'obisaj u wäch. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Xkeb ruc' ri achi, xucoj cunabal chque ru soctajic, xupiso. Te ri' xuya ri achi chrij ru quiej, xuc'am bi pa jun ja warbal, xrilij c'u chila', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Chucab k'ij aretak xel bic ri tata' aj Samaria, xresaj lok ru rajil, xuya niq'uiaj che ri rajaw ri warbal, xubij che: “Bana ba' la tok'ob chwe, chilij la we achi ri'. Ronojel ri cäsach na la chrij, quintoj na che la aretak quintzelej lok,” —xcha che, —cächa ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ri Jesús xuta' che ri tijonel, xubij: ¿Jas ri chomanic la? ¿Jachin chque ri oxib winak ri' are ri kas rach winak ri achi ri xchap cumal ri elak'omab? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Xch'aw chi ri tijonel re ri Pixab, xubij: Ri xutok'obisaj u wäch, are kas rach winak, —xcha'. Xubij c'u ri Jesús che: Ri lal, bana ba' la junam jas ri xuban ri tata' aj Samaria, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Xutakej ru be ri Jesús, e rachi'l c'u ru tijoxelab. Xeopan pa jun alaj tinimit. Jun ixok, Marta u bi', xeuc'ulaj cho rachoch. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ri nan Marta c'o jun u chak', María u bi'. Xt'uyi c'u ri nan María chuwäch ri Jesús chutatabexic ri cubij. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Sibalaj latz' c'u u wäch ri nan Marta rumal rech ri q'uia u chac. Xopan ruc' ri Jesús, xubij che: Kajaw, ¿a xak quil la chi ri nu chak' quinuya can nu tuquiel chubanic ri chac? Bij ba la che chi chinuto', —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Xch'aw ri Jesús, xubij che: Marta, Marta, sibalaj are cachomaj ri a chac. Tzbenak awanima' ruc'. ");
INSERT INTO qucTNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","C'o c'u ri kas rajwaxic. Are c'u ri María are xucha' ri utz na, man quesax tä c'u wa' che, —xcha ri Jesús che. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ri Jesús tajin cuban orar pa jun c'olibal chic. Aretak xto'tajic, jun chque ru tijoxelab xubij che: Kajaw, chujitijoj la chubanic orar, je' jas ri tat Juan xuc'ut chquiwäch ru tijoxelab, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Xubij ri Jesús chque: Aretak quiban orar, chibij: Ka tat, ri lal c'o la pa ri caj, chnimarisax ta na u k'ij ri bi' la. Chtakan ta na la pa qui wi' conojel winak. Chban ta ba' ri rayibal la cho ruwächulew, jas ri cäban uc' la chila' chicaj. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ya la ri ka wa ronojel k'ij. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Sacha la ri ka mac, je' jas ri uj xukuje' cäkasach ri qui mac ri cäca'n c'äx chke. Mäya la chke chi cujtakchi'x che mac, xane chujto' la cho ri Itzel, —quixcha na, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Xukuje' xubij ri Jesús chque: We c'o jun chiwe ri c'o jun awachi'l, copan ta awuc' pa niq'uiaj ak'ab, cubij chawe: “Wachi'l, quinjal ta na oxib caxlan wa chawe. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Xa c'o jun wachi'l chic petinak pa ri be, opaninak c'u wuc' cho wachoch. Man c'o tä c'u jas quinya che,” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Are c'u ri at catch'aw ta lok, cabij che: “Maya latz' chwe. Tz'aptal chi ri uchibe. Ri walc'ual c'ut e k'oyol chi wuc' in. Man quincowin taj quinwalijic chutzucuxic jas quinya chawe,” —catcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Pune man cawaj catwalij ri' chuya'ic ri wa che rumal c'u rech chi are ri awachi'l ri cuta' tok'ob chawe, kas catwalij na ri' rumal chi ri awachi'l man cutänaba tä ru ta'ic tok'ob, caya na ronojel ri rajwaxic che, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Je ri' quinbij chiwe: Chita' ba', c'o c'u cäya'taj na chiwe. Chitzucuj na, c'o na ri quiriko. Chixc'orc'otok, cäjakataj na ri uchija chiwäch. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Apachin c'u ri c'o jas cuta', cuc'am c'u na wa'. Ri winak ri c'o cutzucuj, c'o na ri curiko. Ri winak ri cäc'orc'otic, cäjakataj na ri uchija chuwäch, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","¿A c'o lo jun chiwe ix, ri ix tata'ib, we ta ri a c'ojol cuta' ru wa, ri at c'ut caya jun abaj che? We ta cuta' jun u cär, ¿a caya lo jun cumätz che chuq'uexwäch ri cär? ");
INSERT INTO qucTNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","We cuta' jun u sakmol, ¿a caya ne lo jun ixterix che? ¡Man je' taj! —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","We ri ix ri ix ajmaquib iwetam ri qui sipaxic utzalaj tak jastak chque ri iwalc'ual, ¿a ma tä ne ri i Tat ri c'o chila' chicaj cuya na ri Lok'alaj Espíritu chque ri winak ri cäquita' wa' che? —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ri Jesús tajin cäresaj bi jun itzelalaj espíritu ri cuban memal. Aretak xel bi ri itzelalaj espíritu, xcowinic xch'aw ri achi ri mem nabe. Xquicajmaj c'u wa' ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","E c'o jujun chque ri winak xquibij: Wa' we achi ri' queresaj bi ri itzel tak espíritus ruc' ru chuk'ab ri Beelzebú ri qui nimal ri itzel tak espíritus, —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","E c'o jule' chic ri xquicoj qui chuk'ab che resaxic u pu chi' ri Jesús che rilic jas ri cubano. Xquita' che chi cuban jun cajmabal c'utbal ajchicaj chquiwäch. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ri Jesús retam ri qui chomanic, xubij chque: Jun tinimit ri u banom quieb, ri cäch'ojin na ri juch'ob chrij ri juch'ob chic, cuq'uis c'u na rib ri tinimit ri'. Quewulix na conojel tak ri ja pa ri ch'oj. Xukuje' jun achalaxic ri u banom quieb, ri quech'ojinic, cusach c'u na rib qui wäch. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Xukuje' we ri Satanás cäch'ojin chrij chbil rib, ¿jas c'u lo cuban ri' chujekbaxic ri u takanic ri are'? —cächa ri Jesús. Quinbij wa' rumal chi ri alak cäbij alak chi quinwesaj bi ri itzel tak espíritus rumal ri Beelzebú. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","We ri in quinwesaj bi ri itzel tak espíritus ruc' ru chuk'ab ri Beelzebú, ¿jachin c'u cuya ri qui chuk'ab ri tijoxelab alak rech je' cäca'n wa' xukuje'? Ri e are' je' cäquic'ut na chi sachinak ri alak. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","We ri in quinwesaj bi ri itzel tak espíritus ruc' ru chuk'ab ri Dios, quel cubij wa' chi cämic ri' ri Dios u chaplem takanic waral, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","We c'o jun achi ri sibalaj c'o u chuk'ab, utz c'u cuban chuchajixic ri rachoch cuc' ch'ojibal re ch'ich', man c'o tä ri cäbanow c'äx ri' chque ri jastak re. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","We copan ne jun ri c'o na u chuk'ab chuwäch ri achi ri', cäch'acan c'u puwi', queresaj c'u bi conojel ru ch'ojibal tak ch'ich' ri xucu'bisaj wi u c'ux chquij. Queujach na bi ri jastak ri xeutokij chquiwäch ri rachi'l, —cächa'. (Je' xinch'acan in puwi' ri Satanás,) —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Apachique winak ri man craj tä cubano jas ri quinbij, cuban u c'ulel ri' chwe. Apachin c'u ri man quinuto' tä che qui mulixic ri nu chij, wa' we winak ri' are junam ruc' jun winak ri xa queujabuj, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Aretak jun itzelalaj espíritu quel bi che jun winak, xak cäwacatalob chi pa tak ri juyub ri quetz'inowic ri man c'o tä wi joron, cutzucuj c'u ri cuxlan wi. Man curik tä c'ut, xa je ri' cuchomaj: “Quintzelej na bi cho wachoch jawije' ri xinel wi lok,” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Aretak copanic, curik c'u ri ranima' ri winak je' ta ne jun ja ri ya mesom chic, ri ya banom chi u banic wa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Que' c'ut, queuc'ama chi lok wukub itzelalaj tak espíritus ri e c'äx na chuwäch ri are'. Conojel queboquic, quejeki c'u chila'. Chuq'uisbal ri u bantajic ri winak ri' ri e c'o ri itzelalaj tak espíritus che, sibalaj cänimataj na chuwäch ri nabe u banic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ri Jesús tajin cutzijoj wa' we tzij ri', co xch'aw jun ixok chquixol ri winak, xubij: ¡Utz re ri chichu' ri xil wäch la rumal, ri xq'uiyisan la! —xcha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Xubij c'u ri Jesús: ¡Are utz na que ri winak ri quetow ru Tzij ri Dios, queniman c'u che! —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Aretak ri winak xquimulij quib cho ri Jesús, xuchaplej qui tzijobexic, xubij chque: Xa e lawalo tak winak ri winak re ri k'ij junab ri'. Xak cäcaj chi quinban jun etal ri cajmabal chquiwäch. Man cäbantaj tä c'u na jun etal chquiwäch, xane xak xuwi ri etal re ri ka mam Jonás, k'alajisal re ru Lok' Pixab ri Dios ojer. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak, in ri' ri etal chque ri winak re we k'ij junab ri', je' jas ri ka mam Jonás are xoc che jun etal chquiwäch ri winak ri xec'oji pa ri tinimit Nínive, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ri chichu' ri xc'oji che nim takanel pa qui wi' conojel ri winak aj Seba cätaq'ui na cuc' ri winak re we k'ij junab ri' pa ri k'atän tzij ri cäpetic. Cäch'aw c'u na ri ixok ri' chiwij ix rumal chi xel lok ri are' pa ru tinimit ri sibalaj naj c'o wi, xopan c'u ruc' ri nim takanel Salomón ojer chutatabexic ri nojibal u tijonic. Chiwilampe ix chi c'o Jun waral ri nim na u banic chuwäch ri nim takanel Salomón. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ri winak c'ut aj Nínive, quetaq'ui na junam cuc' ri winak re we k'ij junab ri' pa ri k'atän tzij. Quech'aw c'u na ri winak aj Nínive chiwij ix rumal chi xquiq'uex canima', xquiq'uex c'u qui chomanic rumal ri xutzijoj ri ka mam Jonás chque. C'o c'u jun waral ri nim na u banic chuwäch ri ka mam Jonás, —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Man c'o tä jun winak ri cutzij jun chäj, o jun candela, te c'u ri' cuch'uku, cuya wa' chuxe' jun chicäch. Xane cutzuc'uba wa' chicaj rech cuya sakil chquiwäch ri winak ri queboc pa ja, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ri a wak'äch e are je' jas jun chäj ri cuya sakil chawe. We utz ri a wak'äch, k'alaj ri be chawäch. We man utz ri a wak'äch, man k'alaj tä ri be chawäch. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Chawila ba' chi ri sakil ri c'o awuc' man cäq'uextaj tä ri' pa k'ekumal. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","We c'o ri sakil chawäch, man c'o tä ne jubik' ri k'ekumal, cawil ba' na ronojel pa sakil, je' jas ri cuban jun chäj, o jun candela chawäch, cätununic, —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Aretak ri Jesús xto'taj chubixic wa', xch'aw jun tata' fariseo, xubochi'j chi cäwi' ruc' cho ja. Xe' c'u ri Jesús, xoc bi pa ri ja, xt'uyi chi' ri mesa. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ri fariseo xrilo chi aretak xoc ri Jesús che ri wi'm, man xuban tä ri cubij pa ri qui pixab ri fariseos, ri e nak'atal chubanic aretak cäban ri ch'ajow k'abaj. Ri fariseo jun wi xrilo. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Xubij ri Kajaw Jesús che: Ri alak fariseos, cäch'aj alak ri rij ri lak xukuje' ri rij ri vaso. Are c'u pa anima' alak c'o wi ri lawaloyil, c'o ri itzel rayinic alak, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Con tak winak! ¿A mat etam alak chi ri Dios ri xbanow ri rij jun winak are ri' ri xbanow ri ranima' xukuje'? ");
INSERT INTO qucTNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Bana ba' alak utzil rech quel na ri etzelal pa ri anima' alak. Je ri' ronojel cäcanaj na can ch'ajch'oj, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡C'äx ech alak, fariseos! Ri alak cäya alak ru lajujil ri k'ebun, ri ruda, xukuje' ronojel u wäch ichaj. Cäya c'u can alak ri u banic ri utzil, man kas tä c'u lok' ri Dios chuwäch alak. Are c'u wa' ri rajwaxic cäban na alak, man cäya tä c'u can alak ru banic ri jule' chic, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡C'äx ech alak, fariseos! Caj alak ri t'uyulibal quech nimak qui banic pa ri rachoch Dios, xukuje' caj alak chi nim quil wi alak, chi utz ch'abexic alak cäban pa tak ri be, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡C'äx ech alak, fariseos, xukuje' ri alak tijonelab re ri Pixab! Ri alak onojel alak xak quieb wäch alak. Ri alak junam alak cuc' ri mukubal ri man queilitaj taj. Quebin c'u ri winak pa qui wi' ri mukubal, man quetam taj chi c'o k'ayinak tak bak chupam, —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jun chque ri tijonelab re ri Pixab xch'awic, xubij che: Ajtij, aretak cäbij la wa', uj xukuje' cujyok' la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Xubij c'u ri Jesús chque: ¡C'äx ech alak xukuje', alak tijonelab re ri Pixab! Rumal chi cäya alak q'uia tak pixab chque ri winak je' ta ne chi e nimak tak eka'n ri cäya alak chquij. C'äx c'u ri queka'xic cumal ri winak. Ri alak c'ut man c'o tä jas cäban alak che qui to'ic ri e are', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡C'äx ech alak! Queyac alak ri mukubal tak ja ri e mukum wi ri ojer tak k'alajisal re ru Lok' Pixab ri Dios ri xecämisax cumal ri mam alak. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kas tzij chi ri alak, alak k'alajisal tak que ri xca'n ri mam alak, xukuje' junam wäch alak cuc' ri mam alak. E are' xecämisanic, ri alak c'ut queyac alak ri mukubal tak ja ri e mukum wi, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Rumal rech wa' cubij ri Dios ruc' ru nojibal: “Queintak na bic k'alajisal tak re ri Lok'alaj nu Pixab, xukuje' jule' tak nu tako'n chic. Ri winak c'ut quequicämisaj na jujun chque ri nu tako'n. Jujun c'ut cäca'n na c'äx chque,” —xcha ri Dios, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","U bim wa' ri Dios rech ri winak re tak we k'ij junab ri' cäc'äjisax qui wäch rumal ri qui cämisaxic conojel ri u k'alajisanelab ri Dios ri e cämisam tzpa ru banic ru wächulew petinak lok. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Are c'u tzje wa' ru cämisaxic ri tat Abel, xukuje' ru cämisaxic ri tat Zacarías ri xcäm chquixol ri ta'bal tok'ob ruc' ri lok'alaj c'olibal ri sibalaj äwas chi coc bi xa apachinok, ri c'o pa ri nimalaj rachoch ri Dios. Je' quinbij wa' che alak chi ri winak re we k'ij junab ri', e are wa' ri quequeklej na wa', —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡C'äx ech alak, tijonelab re ri Pixab! Etam alak jas u rikic ronojel u wäch no'j. C'u'm c'u alak wa' we etamanic ri' chquiwäch ri jule' tak winak chic. Ri alak c'ut, man cäban tä alak jas u beyal ri etamanic ri', —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Elem c'u cuban bi ri Jesús, ri tijonelab re ri Pixab xukuje' ri fariseos sibalaj xpe coyowal che. Xquicoj qui chuk'ab. Xquichap u c'otic u chi' chquij q'uia tak tzij. ");
INSERT INTO qucTNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Xquic'ac'lebej c'u u ta'ic jun tzij pu chi' rech cäca'n tzijtal chrij. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Xquimulij c'u quib sibalaj q'uia winak je ri' chi cäquitac'alela quib. Ri Jesús xeutzijobej ru tijoxelab nabe, xubij chque: Chichajij iwib chuwäch ri qui ch'amil ri tata'ib fariseos. Ri ch'äm ri quinbij chiwe man kas tä ch'äm wa', xane are ri qui no'j ri fariseos ri xak quieb qui wäch ri quinjunamaj ruc' ri ch'äm, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Man c'o tä c'u ri ch'uktalic ri mat cäk'alajin na. Man c'o tä c'u ri c'u'talic ri mat quetamataj na. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ri i tzijom pa k'ekum, cätatabex na wa' pa sakil. Ri i jasjatem xukuje' ri quiban pa ri ja, cätzijox na wa' pa ri be, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Quinbij c'u chiwe ix, kachalal, chi mixej iwib chquiwäch ri quecämisan ri cuerpo, te c'u ri' man c'o tä chi ri quecowin chubanic chiwe. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Quinc'ut na in jachin chuwäch ri rajwaxic quixej wi iwib. Are chixej iwib ri' chuwäch ri jun ri cäcowinic quixuq'uiäk bi pa ri k'ak' aretak ix u cämisam chic. Je' quinbij chiwe, are chixej iwib chuwäch wa', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","¿A mat quieb centavos queq'uiyix wi job chi'ch? Man c'o tä c'u jun chque we alaj tak chicop ri' ri cäsach pu jolom ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Xukuje' retam ri Dios joropa' ri rismal i wi' e c'olic. Mixej ba iwib. Más ix lok' na ix chquiwäch q'uia tak chi'ch, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Je' quinbij chiwe chi apachin ri cutzijoj chquiwäch ri winak chi are wachi'l in, in ri' ri Ralc'ual ri Dios ri Kas Winak, quinbij na chquiwäch ri ángeles re ri Dios chi wech in we winak ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Apachin c'u ri cubij chquiwäch ri winak chi man retam tä nu wäch in, quinbij c'u na in chquiwäch ri ángeles re ri Dios chi man wetam tä u wäch we winak ri', —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Apachique winak ri cäyok'on chwe in, in ri' ri Ralc'ual ri Dios ri Kas Winak, cäsach na u mac wa'. Apachin c'u ri cubij ri äwas u bixic chrij ri Lok'alaj Espíritu re ri Dios, man cäsach tä na u mac ri', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Aretak quixquichap ri winak, quixquic'am bi chquiwäch ri qui nimakil ri winak re ri rachoch Dios o chquiwäch ri k'atal tak tzij, xukuje' chquiwäch ri niq'uiaj tak takanelab, mixej iwib che jas ri rajwaxic quibij o jas quito'bej iwib. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Are c'u ri Lok'alaj Espíritu cuya na chiwe pa we hora ri' jas ri rajwaxic u bixic iwumal, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Jun chque ri winak xubij che ri Jesús: Bij la che ri wachalal chi cuya we ri echbal, —xcha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Xch'aw ri Jesús, xubij che: Tat, man in cojom tä che k'atal tzij puwi' alak. Xukuje' man in c'o tä che jachal echbal, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Xubij c'u chque conojel: Chilampe alak chi cächajij ib alak chuwäch ru rayixic q'uia u wäch jastak ajuwächulew. Pune e c'o q'uia ri jastak re jun winak, man are tä ri' ri cäyo'w ru c'aslemal, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ri Jesús xucoj chi na jun c'utbal chquiwäch, xubij: C'o jun achi ri sibalaj k'inom. Sibalaj nim ru wächinic ri rulew xuya'. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Cächoman c'u ri achi pa ranima', cubij: “¿Jas quinban na? Man c'o tä chi c'olibal jawije' quinya wi ri nu jal,” —cächa ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Xuchomaj pa ranima', xubij: “Are wa' ri quinban na. Queinyojij na ri nu c'uja, queinyac na jujun chic más nimak. Quinya na ri nu jal, xukuje' tak ri jastak we chquipam wa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Te c'u ri' aretak quinto'taj chubanic wa' quinbij na chwe chbil wib: Tuxlanok, two'k, chabana a nimak'ij rumal chi e q'uia ri jastak awe ri a c'olom. Cuban na wa' che q'uia junab,” —quincha na in, —cächa ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Xubij c'u ri Dios che: “¡Conalaj achi! Cämic chak'ab catcämic, quel na rawanima'. ¿Jachin lo ajchak'el can ri jastak ri a c'olom?” —xcha ri Dios che, —cächa ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Je ri' ri cuc'ulmaj ri winak ri cumulij k'inomal che chbil rib, man k'inom tä c'u wa' cho ri Dios, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Xubij c'u ri Jesús chque ru tijoxelab: Rumal ri' quinbij chiwe chi mixoc il che ri i c'aslemal, jas ri quitijo, jas ri iwatz'iak quicojo. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nim c'u na u banic ri i c'aslemal chuwäch ri wa. Nim na u banic ri i cuerpo chuwäch ri atz'iak, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","¡Cheiwilampe ri joj! Man cäquitic tä abix, man c'o tä c'u jach' cäca'no. Man c'o tä jawije' quequic'ol wi ri jastak que, man c'o tä c'u qui c'uja. Are c'u ri Dios quetzukuwic. Ri ix c'ut más ix lok' na chquiwäch ri chicop ajuwocaj, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Jachin ta c'u ne chiwe ix cäcowinic cäc'asi na quieb oxib junab chic xak pa re wi? Man c'o taj, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","We man quixcowin tä chubanic jun jasach ri nitz' na, ¿jas che quixoc il chque ri jule' jastak chic? —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Chiwilampe ri cotz'ij, jas cäca'no queq'uiyic. Man quechacun taj, man c'o tä c'u quiem cäca'no. Pune ta ne je ri', quinbij chiwe chi ri nim takanel Salomón ojer ruc' ronojel ru k'inomal man je' tä ratz'iak wa' xucojo jas jun chque we cotz'ij ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","We ri Dios je' cuban wa' che catz'iak ri k'ayes ri e c'o cämic pa juyub, chuwek c'ut queyi' pa ri k'ak', ¿a mat cärilij ri' ri Dios ri iwatz'iak ix? —cächa'. ¡Ay ri ix, ix achijab ri xak jubik' quixcojonic! ");
INSERT INTO qucTNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","¡Mixoc ba' il che jas quitijo, mixej c'u iwib rumal wa'! ");
INSERT INTO qucTNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Conojel we jastak ri' ronojel k'ij kas cäquitzucuj ri niq'uiaj winak chic ajuwächulew. Ri i Tat c'ut retam jachique ri cajwataj chiwe ix, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Chixchacun ba' nabe chujiquiba'xic ru takanic ri Dios, quirik c'u na xukuje' ri niq'uiaj jastak chic ri e rajwaxic chiwe, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Pune ri ix man ix q'uia taj, mixej ba' iwib. Rumal chi cäquicot ranima' ri ka Tat chuya'ic chiwe chi quixc'oji na pa ru takanic ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Chiq'uiyij ri jastak iwe, chisipaj ri rajil chque ri meba'ib. Je ri' cäyi' na chiwe jun iwechbal pa ri caj ri man cäk'elob taj. Cäyi' na xukuje' jun k'inomal chicaj ri man c'o tä u q'uisic. Man copan tä c'u elak'om chila', man cächicopir tä wa', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Jun winak are amak'el cuchomaj ri jastak re. We c'o ri iwech ix pa ri caj, are quichomaj na ri c'o chicaj, man xuwi tä ri' ri c'o cho ruwächulew, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Chisuc'umaj ba' iwib, chitzija c'u ri i candela chuc'ulaxic ri Iwajaw. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Je' quibano jas ri cäca'n ri patäninelab ri queye'm u c'ulaxic ri qui patrón cätzelej lok pa jun c'ulanem, rech aretak culic, cäch'aw chi' ri porta, chanim cäquitor chuwäch. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Utz que ri patäninelab ri' ri queriktaj na rumal ri qui patrón chi e c'aslic aretak cätzelej lok. Kas tzij quinbij chiwe chi ri qui patrón queut'uyuba' na chi' ri mesa, cusuc'umaj na rib rech cuya que ri qui wa, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Pune ta c'ä te' cul ri qui patrón pa niq'uiaj ak'ab, pune sibalaj ak'ab, we cärilo chi e c'aslic, utz que ri patäninelab ri', —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Chich'obo ba' wa' chi we ta jun ajchak'el ja cäretamaj jachique hora copan ri elak'om, cäc'asc'at na ri', man cuya' tä ri' chi cocbex ri rachoch, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Chiwila ba' chi ri ix, ix suc'umatal chic rumal chi cätzelej na lok ri Ralc'ual ri Dios ri Kas Winak pa ri hora ri man quichomaj taj, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Te ri' xubij ri tat Pedro che: Kajaw, ¿a xtzijoj la wa' we c'utbal ri' xak xuwi chke uj? ¿A mat chque conojel? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Xubij ri Kajaw Jesús: ¿Jachin lo ri jun utzalaj patäninel ri sibalaj c'o u no'j? We patäninel ri' are cäcoj na rumal ru patrón pa qui wi' ri niq'uiaj patäninelab chic rech cuya ri qui wa ronojel k'ij. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Utz re ri patäninel ri' ri cäriktajic chi tajin cuban ru chac aretak copan ru patrón, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Are kas tzij ri quinbij chiwe chi ri patrón cucoj na ri patäninel ri' pa qui wi' conojel ri jastak re. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kachomaj ba' jas cuc'ulmaj na we man utz tä cuban ri patäninel ri', xane ri are' cuchomaj chi xa cäbeytaj ru patrón, cuchaplej c'u ri u banic c'äx chque ri niq'uiaj ajchaquib chic xukuje' chque ri ajic'ab, xukuje' ne cuchaplej u banic nimak'ij. Xa sibalaj cäwi'c, xukuje' cäk'abaric. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Xak te'talic c'ut cul ru patrón pa jun k'ij ri man cuchomaj tä ri' ri patäninel, pa jun hora ri man retam taj. Kas tzij chi sibalaj cäc'äjisax na u wäch ri patäninel ri' rumal chi man jicom tä ri ranima' chubanic ronojel ri xtakan wi ri rajaw, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ri patäninel ri cuch'obo jas ru rayinic ru patrón, te c'u ri' man cujiquiba tä c'u rib, man cäniman tä c'u che, are c'u wa' we winak ri' sibalaj cäc'äjisax na u wäch. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ri patäninel c'ut ri man cuch'ob tä ru rayinic ru patrón, cuban c'ut jachique ri takal wi u c'äjisaxic u wäch, cätan na ri' ri c'äjisabal u wäch ri cäban na che. We jun winak cuya rib pa c'olibal re ekle'n, nim wa' ri cäta' na che cumal ri niq'uiaj winak chic. We ri winak qui jiquibam wi canima' che jun winak chic, q'uia c'u ri utzil cäquita' che we winak ri', —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Xinpe in rech quinya tijonic chque ri winak ajuwächulew. We tijonic ri' are je' jas ru t'ikic k'ak' cho tak ri juyub. Cwaj ta na chi ya tajin cäc'at chi we k'ak' ri', —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","C'o na jun nimalaj c'äx ri rajwaxic quinriko. Cwaj ta na chi xbantaj ta can ri c'äx ri', xinto'taj ta c'u che, —cächa ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿A quichomaj ix chi in petinak rech xa cäc'oji utzil chquixol ri winak ajuwächulew? ¡Man je' taj! Xane xinpe in chubanic ch'oj. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tzcämic ri' cächap na bi u banic we ch'oj ri'. Job winak ri e c'o pa jun ja cäquic'ulelaj na quib, ri oxib chquij ri quieb, ri quieb chic chquij ri oxib. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Cäbantaj na ch'oj, jun tata' cuc'ulelaj na ru c'ojol, ru c'ojol c'ut cuc'ulelaj na ru tat, xukuje' ri chichu' cuc'ulelaj na ri ral ali, ri ali cuc'ulelaj na ru nan, xukuje' ne ri jun ali chic cuc'ulelaj na ri ralib chichu', ri ralib chichu' c'ut cuc'ulelaj na ri are', —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Xubij c'u ri Jesús chque ri q'uialaj winak: We quiwil ri sutz' ri cäpaki lok, chanim quibij: Craj cäpe jäb, —quixcha'. Je' c'u cäc'ulmatajic, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Aretak cäxuli ri quiäkik', quibij: Cäpe na ri sak'ij, —quixcha'. Je' cäc'ulmatajic, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Ri alak, xa quieb wäch alak! Cächob alak ri u wo ri caj xukuje' ruwächulew. ¿Jas che man cäch'ob tä alak jas u wäch wa' we k'ij junab ri'? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Jas che man cächomaj tä alak jas ri' ri kas jicom, jas ri' ri man kas jicom taj? ");
INSERT INTO qucTNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Aretak que' alak cho ri k'atal tzij achi'l alak ri c'ulel alak, tija' ba' k'ij alak che rutzirisaxic ib alak pa ri be, rech man cäc'am tä bi alak cho ri k'atal tzij. Are c'u ri k'atal tzij cäjachow alak pu k'ab ri mayor. Ri mayor c'ut cäyo'w can alak pa che'. ");
INSERT INTO qucTNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kas tzij ri quinbij chi man quel tä na alak pa che' c'ä cätoj na alak ri q'uisbal centavo re ri multa, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Pa ri k'ij ri' e c'o jujun winak chila' ri xquitzijobej ri Jesús chquij ri winak aj Galilea ri xeucämisaj ri tat Pilato, xuyuj c'u ri qui quiq'uel ruc' ri qui quiq'uel ri awaj ri xecämisax che qui sipaxic cho ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Xch'aw chi ri Jesús, xubij chque: ¿A cächomaj alak chi ri winak aj Galilea xquirik wa' we nimalaj c'äx ri' xa rumal chi más e ajmaquib na chquiwäch ri niq'uiaj qui winakil chic? ");
INSERT INTO qucTNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Man je' ta wa', —cächa'. We ri alak man cäq'uex tä ri anima' alak, xukuje' ri chomanic alak, cäsach na wäch alak onojel alak xukuje', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Xukuje' e c'o ri wajxak lajuj winak ri xecäm pa Siloé rumal jun nimalaj ja ri xtzak pa qui wi'. ¿A cächomaj alak chi más e lawalo na we winak ri' chquiwäch ri niq'uiaj winak chic ri e c'o pa Jerusalén? ");
INSERT INTO qucTNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Man je' taj, —cächa'. We ri alak man cäq'uex tä anima' alak, xukuje' man cäq'uex tä chomanic alak, cäsach na wäch alak onojel alak xukuje', —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ri Jesús xutzijoj xukuje' we c'utbal ri' chuya'ic tijonic chque, xubij: Jun achi, c'o jun u che'al higos ruc', tictal c'ut pa ru ticbal uvas. Xe' c'u ri achi chutzucuxic ri u wäch ri che' ri', man c'o tä c'u xuriko. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Xubij che ri chajil ticbal uvas: “Chawilampe' chi xque' oxib junab quinpe chutzucuxic u wäch ri che' ri', man c'o tä c'u quinriko,” —xcha', —cächa ri Jesús. “Chat'oyo ba'. Xak c'u lok' cäc'oji waral pa ri wulew,” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Xch'aw chi ri chajinel, xubij che: “Tat, ya la canok xak xuwi che we junab chic ri'. Quinc'ot na rij, quinmesaj na. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","We ne cäwächin ne pa we jun junab chic ri', utz u banom. We c'u man cäwächin taj, cäkat'oy na apanok,” —xcha che ru patrón, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Pa jun k'ij re uxlanem ri Jesús tajin cuya tijonic pa jun chque ri rachoch Dios. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","C'o c'u jun chichu' chila' ri wajxak lajuj junab yawab rumal jun itzelalaj espíritu. U k'usum rib cäbinic, man cäcowin tä chic chujicomisaxic rib. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Aretak ri Jesús xrilo, xusiq'uij ri chichu', xubij che: Nan, cunam chi la che ri yabil la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Xuya ru k'ab puwi' ri chichu'. Chanim c'ut xcowinic xujicomisaj rib. Xunimarisaj c'u u k'ij ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ri qui nimal ri winak pa ri rachoch Dios sibalaj xpe royowal rumal chi ri Jesús xuban cunanic pa ri k'ij re uxlanem. Xubij ri achi chque ri winak: Xak xuwi wakib k'ij rajwaxic quixchacunic. Chixpet pa tak we k'ij ri' rech quixcunaxic, mixpe c'u pa ri k'ij re uxlanem, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Xch'aw chi ri Jesús, xubij che: ¡Ri alak xak quieb wäch alak! Chjujunal alak cäquir alak ri wacäx, ri burro pa ri recha'bal pa ri k'ij re uxlanem, cäc'am c'u bi alak rech cutija u joron. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Wa' we ixok ri', rachalaxic ri ka mam Abraham, yututal c'u rumal ri Satanás wajxak lajuj junab. ¿A mat rajwaxic u quiric wa' che we yabil ri' pa ri k'ij re uxlanem? —xcha che. ¡Je', je ri'! ");
INSERT INTO qucTNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Aretak ri Jesús xubij wa', conojel ri quec'ulelanic xeq'uixic. Are c'u conojel ri niq'uiaj winak chic sibalaj xequicotic cumal tak ri cajmabal ri tajin cuban ri Jesús. Sibalaj nim xequilo ri xuban ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Xubij c'u ri Jesús: ¿Jas ruc' junam wi ru takanic ri Dios pa qui wi' ri winak? ¿Jas ta ruc' quinjunamaj wi wa'? —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Are je' jas jun ija' re mostaza. Jun winak cuc'am bi ri ija' ri', cutic pa rulew. Cäq'uiyic, cuban nim je' jas cuban jun che' cäq'uiyic. Ri chicop ajuwocaj cäca'n ri qui soc pa tak ri u k'ab ri che' ri', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Xubij ri Jesús xukuje': ¿Jas ta ruc' quinjunamaj wi ru takanic ri Dios? —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Are je' jas ri ch'äm ri cuya jun chichu' ruc' oxib pajbal c'äj re caxlan wa, rech cäch'ämir ronojel ri k'or, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Benam re ri Jesús pa Jerusalén, xeusolij can ronojel tinimit, ri nimak xukuje' ri ch'utik, xuya c'u tijonic chila'. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","C'o c'u jun ri xuta' che ri Jesús: Tat, ¿a xa e quieb oxib ri' ri winak ri cäquirik ri u tobanic ri Dios? —xcha che. Xch'aw chi ri Jesús, xubij chque ri winak: ");
INSERT INTO qucTNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Cätij chuk'ab alak rech coc alak pa ri uchija ri sibalaj latz' u wäch. Je' quinbij chi e q'uia ri cäquitij na qui k'ij rech queboquic, man quecowin tä c'ut, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Te c'u ri', aretak ri ajchak'el ja u tz'apim ri porta, ri alak ri xak tac'atoj alak cho ri ja, cäch'aw na alak chuchi' ri ja, cäbij na alak: “Kajaw, Kajaw, toro la ri porta chkawäch,” —cächa na alak che. Cäch'aw c'u na lok ri ajchak'el ja, cubij na: “Ri in man quinch'ob tä wäch alak, xukuje' man wetam taj jawije' quel wi alak,” —cächa ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Cächaplej c'u na alak cäch'aw alak, cäbij alak che: “Uj wokinak ya' uc' la, xukuje' ri lal yo'm la tijonic pa tak ri be re ri ka tinimit,” —cächa na alak. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Cubij na ri ajchak'el ja: “Xinbij chech alak chi ri in man wetam taj jawije' ri quel wi alak chi'. Chel bi alak, alak banal tak etzelal,” —cächa na ri are'. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Are chi' c'ut cäban wi na alak ri ok'ej, xukuje' ri kuch'uch'em wareyaj rumal ri c'äx aretak quil alak chi ri ka mam Abraham, ri ka mam Isaac, ri ka mam Jacob, xukuje' conojel ri k'alajisal tak re ru Lok' Pixab ri Dios e c'o chila' jawije' ri Dios cätakan wi. Ri alak c'ut, man c'o tä alak cuc' rumal chi esam chi alak apanok. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Queopan c'u na winak ajrelbal k'ij, aj u kajbal k'ij, xukuje' winak aj u wiquiäk'ab ri relbal k'ij, aj u mox relbal k'ij, quet'uyi na chi' ri mesa che wi'm jawije' cätakan wi ri Dios, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Jujun c'u chque ri winak ri man nim tä queil wi cämic sibalaj nim queil wi na pa ri k'ij ri'. Are c'u jujun chque ri winak ri sibalaj nim queil wi cämic, man nim tä chi na queil wi pa ri k'ij ri', —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Pa ri k'ij ri' xeopan niq'uiaj tata'ib fariseos ruc' ri Jesús, xquibij che: ¡Chel bi la waral! ¡Chanej la! Are ri k'atal tzij Herodes craj cucämisaj la, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Xubij c'u ri Jesús chque: Jebij alak che we subanel Herodes chi cämic xukuje' chuwek quinwesaj na itzel tak espíritus, xukuje' quincunanic. C'ä te' pa ri urox k'ij quinto'taj na che ri nu chac, —cächa', —cächa alak che. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Rajwaxic c'ut chi cämic, chuwek, cäbij quinban na u banic ri nu chac, —cächa'. ¿A cuya lo cäcämisax jun k'alajisal re ru Lok' Pixab ri Dios pa jun tinimit chic, mat pa Jerusalén? Man je' taj, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","¡Ay, winak aj Jerusalén! Are quecämisaj alak ri k'alajisal tak re ru Lok' Pixab ri Dios, queban alak che abaj ri quetak bi uc' alak. ¡Q'uia mul nu rayim ri mulixic alak jas cuban jun ati't äc' cumulij ri alaj tak ral chuxe' ru xic', man caj tä c'u alak! —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Tampe alak, cäcanaj na can ri achoch alak, cäwonobax c'u na canok. Man quinil tä chi na alak c'ä copan na ri k'ij ri cäbij alak: “Nim ba' ru k'ij ri Jun ri u takom lok ri Kajaw Dios,” —cächa na alak, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Pa jun k'ij re uxlanem xe' ri Jesús cho rachoch jun chque ri qui nimal ri winak, jun tata' fariseo. Jela' xe' wi che wi'm, tajin c'u caluchi'x cumal ri niq'uiaj tata'ib fariseos. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Jun achi c'ut ri c'o sipoj che c'o chila' chuwäch ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Xch'aw ri Jesús, xeuch'abej ri tijonelab re ri Pixab xukuje' ri fariseos, xubij: ¿A takal u banic cunanic pa jun k'ij re uxlanem? We ne man takal taj, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Man xech'aw tä c'u ri e are'. Ri Jesús xuc'am bi ri yawab ruc', xucunaj, xutak bic. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Xubij c'u chque ri tata'ib: We c'o ri burro alak, ri wacäx alak, ri cätzak bi pa jun c'ua' pa ri k'ij re uxlanem, ¿a mat quesaj alak wa' chanim? —xcha chque. ¡Je', je ri'! ");
INSERT INTO qucTNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Man xquirik tä c'ut jas xquibij che. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Xril ri Jesús jas xca'n ri winak ri e ula'm, chi ri e are' xquicha' ri t'uyulibal quech ri nimak qui banic chi' ri mesa. Xucoj jun c'utbal chuyi'c tijonic chque, xubij: ");
INSERT INTO qucTNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","We cäsiq'uix alak che jun c'ulanem, mät'uyi wi alak pa tak ri t'uyulibal quech ri nimak qui banic. We ne cäpe na jun winak ri nim na u k'ij chuwäch alak ri xukuje' ula'm rumal ri achi. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Craj cäpe ri tata' ri xerulaj alak ri xukuje' xrulaj ri jun winak chic, cubij che alak: “Ya la ri t'uyulibal la che we achi ri',” —cächa na. Ri alak c'ut, pune sibalaj cäq'uix alak, cäk'ax na alak ri' pa ri t'uyulibal ri man kas tä nim u banic, —cächa ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Xane aretak cula'x alak, tzucuj alak ri t'uyulibal ri man kas tä nim u banic, t'uyul alak chila', rech we cäpe ri tata' ri xerulaj alak, cubij ta na ri' che alak: “Wachi'l, c'o jun t'uyulibal ja le' ri utz na che la,” —cächa na ri'. Kas cänimarisax na k'ij alak chquiwäch conojel ri e c'o uc' alak chi' ri mesa. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ronojel winak ri cunimarisaj rib, cäkasax na u k'ij ri are'. Ri winak ri man cunimarisaj tä rib, are c'u wa' cänimarisax na u k'ij, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Xubij c'u ri Jesús che ri tata' ri xula'nic: Aretak cäban la jun ula'nem, we ne jun nimak'ij, me'ulaj la xak xuwi ri achi'l la, man xak xuwi tä ri achalal la, o ri c'ul tak ja la ri e k'inomab. We je ri' craj ne je' cäca'n na wa' che la xukuje' chutojic u q'uexel ri xban la chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Xane aretak cäban la jun ula'nem, che'ulaj la ri winak meba'ib, ri winak cutucak quebinic, ri ch'ocojib xukuje' ri man queca'y taj. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Utz c'u na ri e la rumal chi man quecowin tä ri e are' chutojic u q'uexel wa' che la. Cäyi' c'u na u q'uexel che la pa ri k'ij re ri qui c'astajic ri winak ri jicom canima' chquixol ri cäminakib, —xcha ri Jesús che. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Xuta c'u wa' jun chque ri e t'uyul ruc' ri Jesús chi' ri mesa, xubij che: Utz re ri coc na che wi'm chila' jawije' ri cätakan wi ri Dios, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Xch'aw chi ri Jesús, xubij che: Jumul ri' jun achi xuban jun nimalaj ula'nem. E q'uia c'u ri xeusiq'uij. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Pa ri hora re ri wi'm ri achi xutak bic jun patänil re chubixic chque ri e siq'uim: “Sa'j alak, ya xutzir ronojel,” —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Junam c'ut xquichaplej resaxic quib conojel. Xubij ri nabe winak che ri patäninel: “Nu lok'om ch'äkap wulew,” —cächa'. “Rajwaxic chi quine' che rilic. Chabij che ri a patrón chi chubana tok'ob chwe, chusacha nu mac, man quine' taj,” —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Xubij jun winak chic: “Nu lok'om job c'ulaj wacäx, quinwil na jas cäca'no quechacunic,” —cächa'. “Chubana tok'ob chwe, chusacha nu mac, man quine' taj,” —cächa ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Xubij ri jun winak chic: “Man cuya' taj quine'c rumal chi c'ä te' xinc'uli'c,” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Xtzelej bi ri patäninel, xutzijoj ronojel wa' che ri u patrón. Xpe royowal ri u patrón, xubij c'u che ri patänil re: “Jat chanim pa tak ri be, pa tak ri c'ayibal re ri tinimit, cheatzucuj ri winak meba'ib, ri winak cutucak, ri man quecowin taj queca'yic, xukuje' ri ch'ocojib, cheac'ama c'u lok,” —cächa che. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Te c'u ri' xubij ri patäninel che ri u patrón: “Xbantaj canok ri xtakan wi la. C'o c'u na c'olibal chque niq'uiaj,” —cächa che. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Xubij c'u ri patrón che ru patäninel: “Jat naj pa tak ri be, pa tak ri juyub, chacojo a chuk'ab rech quepe ri winak, cänoj c'u na ri wachoch. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Quinbij chiwe ix ri ya ix c'o chic chi man c'o tä jun chque ri xewula'j nabe ri cutij na jubik' re ri nu wi'm ri xinbano,” —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","E q'uia winak c'ut e benak ruc' ri Jesús. Xutzolk'omij rib cuc', xubij chque: ");
INSERT INTO qucTNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","We c'o jun ri kas craj cäc'oji wuc' in, nim c'u na queril ru tat u nan chnuwäch in, xukuje' ri rixokil, ri ralc'ual, ri ratz, ru chak', we c'u ne ri ranab, man cuya' taj coc che tijoxel we, —cächa'. Xukuje' ne we nim na cäril ru c'aslemal chbil rib chnuwäch in, man cuya' tä ri' coc che tijoxel we, —cächa ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ri winak ri man cutelej tä ru cruz, te ri' cäpe wuc' in, man cuya' taj coc che tijoxel we, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","¿A c'o jun chiwe ri craj cuyac jun nimalaj ja, ri mat nabe cät'uyi na chubanic rakan, cärajilaj ru rajil joropa' ri c'olic che rilic we cuban ri puak chuq'uisic u banic ri ja? —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Je ri' cubano rech aretak cojom chic ri tac'alibal re ri ja, cäcowin c'u ri' chuq'uisic ri xuchaplej. We ta mat je ri' conojel ri winak ri queilowic cäquichap na u tze'xic u wäch, ");
INSERT INTO qucTNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","craj ne cäquibij: “We achi ri' xuchaplej u yaquic jun nim ja, man xcowin tä c'ut chubanic ronojel,” —quecha ne. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","We c'u ne c'o jun nim takanel ri que' che ch'oj chrij ri nim takanel re jun tinimit chic, ¿a mat nabe cuta' u no'j che retamaxic we cuban na ri u soldados? Craj c'o xa lajuj mil u soldados. Ri jun nim takanel chic craj e c'o juwinak mil u soldados. Ri tata' ri c'o xa lajuj mil u soldados cuchomaj na we quecowin ri e are' che qui ch'aquic ri juwinak mil soldados ri quepe na chrij. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","We ne man cäcowin tä che, aretak c'ä naj e c'o wi ru c'ulel che, queutak bi ru tako'n chutz'onoxic chi cutzir ruc', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Je c'u ri' apachin chiwe ix ri man cuya tä can ronojel ri rech are', man cuya' tä ri' coc che tijoxel we, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Utz ri atz'am. Are c'u we man c'o chic ru tzayil ri atz'am, ¿jas lo ruc' cätzayix wi ri riquil? —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Man c'o tä chi u patän. Man utz tä che ri ulew, man utz tä c'u chumesaxic. Ri winak xa cäquesaj na bi pa mes, —cächa'. Apachin ri cujiquiba ranima' che nu tatabexic, chutatabej, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Xenakajin c'u conojel ri tok'il tak alcabal xukuje' ri niq'uiaj ajmaquib ruc' ri Jesús chutatabexic. ");
INSERT INTO qucTNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Xewixwit c'u ri tata'ib fariseos xukuje' ri tijonelab re ri Pixab, xquibij: We achi ri' queuc'ulaj ri ajmaquib, cäwi' c'u cuc', —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ri Jesús xucoj we c'utbal ri' chuya'ic tijonic chque, xubij: ");
INSERT INTO qucTNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","We c'o jun chech alak ri c'o jun ciento ru chij, cätzak c'u jun chque, queuya na can ri jumuch' belej lajuj pa tak ri juyub, que' c'u chutzucuxic ri xtzak canok c'ä curika na wa', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Aretak curiko, cuya na lok chrij u wi', cäquicotic. ");
INSERT INTO qucTNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Aretak copan chic cho ja, queusiq'uij na ri rachi'l xukuje' ru c'ul tak ja, cubij chque: “Chixquicot wuc', rumal chi xinrik ri nu chij ri xtzak na canok,” —cächa na chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Je c'u ri' quinbij chiwe chi c'o na quicotemal chicaj rumal jun ajmac ri cuq'uex ranima', cuq'uex c'u u chomanic, chquiwäch ri jumuch' belej lajuj ri man cajwataj tä u q'uexic canima', —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","We c'o jun ixok ri e c'o lajuj quetzales ruc', cätzak c'u jun quetzal, ri ixok cutzij na jun u candela, cumes na ri upaja, cärilij na u tzucuxic c'ä curik na ri puak. ");
INSERT INTO qucTNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Aretak curiko, queuch'abej na ri rach tak ixokib xukuje' ri u c'ul tak ja, cubij chque: “Chixquicot wuc', rumal chi xinrik ri nu puak ri xtzakic,” —cächa na chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Je c'u ri' quinbij chiwe chi quequicot na ri ángeles re ri Dios aretak jun ajmac cuq'uex ranima', cuq'uex c'u u chomanic, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ri Jesús xukuje' xutzijoj wa' chque: Jun achi e c'o quieb u c'ojol. ");
INSERT INTO qucTNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ri ch'ut u c'ojol xubij che ru tat: “Tat, ya la ri quinwechbej in re ri k'inomal la,” —xcha che. Ri qui tat c'ut xujach ri jastak re chquiwäch ri quieb u c'ojol. ");
INSERT INTO qucTNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Xque' quieb oxib k'ij, ri ch'ut u c'ojol xumulij bi conojel ri jastak re, xe' naj pa jun tinimit chic. Chila' c'ut xak xusachila wi il ri c'o ruc', xtzak pa mac, man utz tä chic ru c'aslemal. ");
INSERT INTO qucTNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Aretak ronojel u sachom chic, xpe jun nimalaj wi'jal pa ri tinimit ri'. Xurik c'äx ri ala, sibalaj xnumic. ");
INSERT INTO qucTNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Xe'c, xutzucuj u chac ruc' jun chque ri winak re ri tinimit ri'. Xyi' c'u u chac. Xtak bi ri ala rumal ri achi che qui yuk'uxic ri ak pa ri juyub. ");
INSERT INTO qucTNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Sibalaj xurayij u tijic re ri rij tak pru't ri cäquitij ri ak. Man c'o tä c'u jun winak ri c'o jas cuya che. ");
INSERT INTO qucTNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Xul c'u ri ala pa sak, xubij: “E c'o q'uia ri ajchaquib cho rachoch ri nu tat ri sibalaj c'o ri qui wa. Ri in c'ut quincäm waral rumal ri wi'jal. ");
INSERT INTO qucTNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Quinwalijic, quine' na ruc' ri nu tat, quinbij na che: Tat, ri in, in macuninak chuwäch ri Dios, xukuje' chuwäch la, tat. ");
INSERT INTO qucTNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ri in, man ya'tal tä chwe chi cäban chi na la c'ojol la chwe. Bana ba' la chi quinoc che jun ajchac la,” —quincha na che, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Xwalijic, xe' c'u ruc' ru tat. Tajin cäbinic, nakaj chic c'o wi che ri rachoch. Ru tat xril apan chinaj. Xel ranima' ru tat che. Xutic anim, xe'c, xuk'aluj ri ala, xukuje' xutz'umaj. ");
INSERT INTO qucTNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Xubij c'u ru c'ojol che: “Tat, ri in, in macuninak chuwäch ri Dios, xukuje' chuwäch la, tat. Man ya'tal tä chic chwe in chi cäban la c'ojol la chwe,” —xcha che ru tat. ");
INSERT INTO qucTNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Xubij c'u ru tat chque tak ri patänil re: “Chiwesaxtaj lok ri atz'iak ri más utz na, chicojo che, chicojo xukuje' jun mulk'ab che ru k'ab, xukuje' xajäb chque ri rakan. ");
INSERT INTO qucTNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Jic'ama lok xukuje' ri alaj ama' wacäx ri sibalaj chom, chipila ba',” —xcha chque. “¡Chujwok, kabana nimak'ij! ");
INSERT INTO qucTNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Rumal chi we nu c'ojol ri' je' ta ne chi xcämic, xc'astaj c'u lok jumul chic. Xtzak na, xriktaj c'ut,” —xcha ri tata' chque. Xquichaplej c'u quicotem. ");
INSERT INTO qucTNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ri u c'ojol nabeal ri tata' benak pa juyub. Tzelejem re cho ja, xnakajin c'u che ri rachoch, xuta ri k'ojom xukuje' ri xojowem. ");
INSERT INTO qucTNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Xusiq'uij c'u jun patänil re ru tat, xuta' che: “¿Jas wa' ri quinto?” —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Xubij c'u ri patäninel che: “Ulinak ri chak' la. Ri tat la xtakan c'u chupilic ri alaj ama' wacäx ri sibalaj chom, rumal chi ulinak ri ala utz u wäch,” —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Te c'u ri' sibalaj xpe royowal ri nabeal, man xraj taj coc bic pa ri ja. Xel c'u lok ru tat chubochi'xic. ");
INSERT INTO qucTNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ri nabeal xch'awic, xubij che ru tat: “Kas q'uia junab in patäninak che la. Ronojel k'ij nu nimam jas ri cäbij la chwe. Man c'o tä c'u jumul ri yo'm la xa ta ne jun alaj q'uisic' chwe in rech quinban nimak'ij cuc' ri wachi'l,” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","“Aretak xul we c'ojol la ri', ri xusachila ri jastak e la cuc' ixokib re be, xcämisaj la ri alaj ama' wacäx ri sibalaj chom chubanic nimak'ij che,” —xcha che ru tat. ");
INSERT INTO qucTNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Xubij c'u ru tat che: “Nu c'ojol, ri at ronojel k'ij at c'o wuc' in, conojel c'u ri jastak we xukuje' awech at wa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Rajwaxic u banic nimak'ij, xukuje' cujquicotic rumal chi we a chak' ri' je' ta ne cäminak chic, xc'astaj c'u lok jumul chic. Xtzak na wa', xriktaj c'ut,” —xcha che ru c'ojol, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Xukuje' xutzijoj wa' ri Jesús chque ru tijoxelab: C'o jun k'inom achi, ri c'o jun u mayordomo. Xbix c'u che ri k'inom chi ri u mayordomo tajin queuq'uis bi ri jastak re. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ri k'inom achi xusiq'uij ri tata' mayordomo, xubij che: “¿Jas wa' ri nu tom chawij? Chabana cuenta che ri a patäninic chnuwäch. Man cuya' tä chi c'ut catc'oji wuc' che ri nu mayordomo,” —xcha ri tata' che. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Xuchomaj c'u ri mayordomo pa ranima', xubij: “¿Jas ta c'u ne quinbano?” —cächa'. “Man craj tä chi ri nu patrón chi quinchacun na ruc'. Man c'o tä c'u nu chuk'ab chubanic taji'n. Quinq'uix c'ut che ri molonic,” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","“Quinchomaj na ri quinbano rech quinquic'ulaj na ri winak pa tak cachoch aretak quesax ri nu chac chwe,” —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ri mayordomo xeusiq'uij ri rajc'asib ri rajaw chquijujunal. Xubij che ri nabe ajc'as: “¿Joropa' ri c'as la ruc' ri nu patrón?” —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Xubij ri ajc'as che: “Are jun ciento toneles aceite nu c'as,” —xcha'. Xubij c'u ri mayordomo che: “Waral c'o wi ru wujil ri c'as la. T'uyul ba la chanim ri', tz'ibaj la niq'uiaj ciento,” —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Te ri' xubij ri mayordomo che jun ajc'as chic: “Ri lal, ¿joropa ri' ri c'as la?” —xcha che. Xch'aw ri ajc'as, xubij che: “Wajxakib quintales trico ri nu c'as,” —xcha'. Xubij ri mayordomo che: “Waral c'o wi ru wujil ri c'as la. Tz'ibaj la wakib ruc' ri niq'uiaj,” —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ri u patrón ri mayordomo xubij chi sibalaj c'o u no'j ri mayordomo ri man utz taj rumal chi xna'w chubanic ronojel wa'. Are c'u ri winak ajuwächulew, ri man e cojonelab taj, c'o na quetam chquij tak wa' we jastak ri' chquiwäch ri cojonelab ri c'o ri u sakil re ru Lok' Pixab ri Dios pa canima', —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Quinbij in chiwe: Chicojo ba' ri i rajil ri ajuwächulew rech e c'o na iwachi'l. Aretak cäq'uis ri i rajil, quixc'ulax pa tak jekilibal ri man queq'uistaj tä ri', —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Apachin jun winak ri jicom ranima' chubanic ri man nim tä u banic, xukuje' are jicom ranima' chubanic ri nim na u banic. Apachin ri man jicom tä ranima' chubanic ri man nim tä u banic, man jicom tä c'u ri' chubanic ri nim u banic, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","We ri ix man jicom tä iwanima' ix chucojic ri k'inomal ajuwächulew, ¿jachin ta lo ri cäyo'w ri kas k'inomal ajchicaj chiwe? Man c'o taj, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","We ri ix man jicom tä iwanima' ix chrij ri rech jun winak chic, ¿jachin ta lo cäyo'w chiwe ri kas iwe ix? Man c'o taj, —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Xubij xukuje': Man c'o tä jun patäninel ri cäcowin che qui patänixic quieb u patrón, —cächa'. Cäretzelaj na u wäch ri jun, lok' c'u na cäril na ri' ri jun chic. Utz cuban na che ri jun u patrón, man nim tä c'u cäril wi ri jun chic, —cächa'. Man quixcowin taj quipatänij ri Dios we benak iwanima' ruc' ri puak, —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Xquita c'u ronojel wa' ri tata'ib fariseos ri sibalaj lok' cäquil wi ri qui rajil. Xquetze'j c'u u wäch ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Xubij c'u ri Jesús chque: Ri alak cäk'alajisaj ib alak chquiwäch ri winak chi jicom anima' alak. Are c'u ri Dios retam jas c'o pa anima' alak, —cächa'. Ri sibalaj nim quil wi cumal ri winak, are xabibal wa' cho ri Dios, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Xubij xukuje': Takal chque ri winak chi queniman che ri ojer Pixab rech ri ka mam Moisés xukuje' chque ri qui tijonic ri k'alajisal tak re ru Lok' Pixab ri Dios c'ä mäja' xul ri tat Juan Kasal Ja'. Cämic c'ut ri xul ri tat Juan, xchaplex u tzijoxic ri Utzalaj Tzij re ri Evangelio chrij ru takanic ri Dios pa qui wi' ri winak. Conojel ri winak tajin cäquitij qui chuk'ab rech queboquic. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Man c'äx tä ru sachic qui wäch ri cajulew chuwäch ri u sachic jun tzij re ru Lok' Pixab ri Dios rumal chi tzrajwaxic wi chi cäbantaj na ronojel ri cubij ru Lok' Pixab ri Dios, —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ronojel achi ri cujach bi ri rixokil, cuc'ama chi na jun ixok chic, cuban ri nimalaj mac ri äwas u banic cho ri Dios xukuje' chrij ri rixokil. Xukuje' ri achi ri cuc'am jun ixok ri jachom bic rumal ri rachajil cuban ri' ri nimalaj mac ri äwas u banic cho ri Dios xukuje' chrij ri nabe rixokil, —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Xc'oji jun achi ri sibalaj k'inom, ri cucoj je'lalaj tak atz'iak ri sibalaj pakalic. Ronojel k'ij c'ut xuban c'oc'alaj tak wi'm ri sibalaj nimak, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","C'o c'u jun winak meba', tat Lázaro u bi', k'oyol chuchi' ri rachoch ri k'inom. C'o c'u q'uia ri itzel tak ch'a'c che. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ri meba' curayij u tijic ri ch'äkatak wa ri quetzak chuxe' ru mesa ri k'inom. Quenakajin c'u ri tz'i' ruc' ri tat Lázaro, quequirik' ri u ch'a'c, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Xcäm c'u ri meba' tata'. Ri ángeles xquic'am bic, xquiya can ruc' ri ka mam Abraham. Xcäm xukuje' ri k'inom achi, xmuk c'ut, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","C'o c'u ri k'inom pa ri c'olibal ri quebe' wi ri canima' ri winak aretak quecämic. Sibalaj c'äx tajin curiko. Xca'y apanok, xril ri ka mam Abraham chinaj, xukuje' chi ri tat Lázaro c'o ruc'. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Co xch'awic, xusiq'uij, xubij: “Tat Abraham,” —cächa'. “Tok'obisaj la nu wäch, taka la lok ri tat Lázaro, curub c'u u k'ab pa joron rech cäpetic, cuya jubik' chwe rech quinjororic. Xa quinel ch'uj pa we k'ak' ri',” —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Xubij c'u ri ka mam Abraham: “Tat, chna'taj chawe chi xarik ri utzalaj tak jastak at pa ri a c'aslemal cho ruwächulew. Are c'u ri tat Lázaro, man c'o tä utzil xuriko. Cämic c'ut are cu'bisam ranima' wuc' in waral, ri at c'ut, at c'o pa c'äxc'ol,” —cächa che. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","“Cojom c'u jun nimalaj siwan chkaxol rech ri cäcaj quek'ax bi awuc' man quecowin tä che. Ri ajchila' c'ut ri e c'o awuc', man quecowin taj quek'ax lok kuc',” —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Xubij ri k'inom tata' che ri tat Abraham: “Quinbochi'n ba' che la, tat Abraham, chi cätak la bic ri tat Lázaro cho rachoch ri nu tat. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","E c'o job ri wachalal chila',” —cächa'. “Cwaj chi ri tat Lázaro cutzijoj wa' we c'äxc'ol ri' chque rech man quepe tä waral ri sibalaj cäquirik wi c'äx,” —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Xubij c'u ri ka mam Abraham: “C'o ri tz'ibam can rumal ri ka mam Moisés, xukuje' ri tz'ibam cumal ri ojer tak k'alajisal re ru Lok' Pixab ri Dios. C'o que ri wuj ri'. Chquitijoj quib chquij,” —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Xubij c'u ri k'inom: “¡Kas tzij, tat Abraham! Man quecojon tä c'u chque. We ta c'u c'o jun cäminak ri cäc'astajic, ri que' cuc', cäquiq'uex na ri' ri canima', cäquiq'uex ri qui chomanic,” —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Xubij ri mam Abraham che: “We man cäquinimaj tä ri ka mam Moisés xukuje' ri ojer tak k'alajisal re ru Lok' Pixab ri Dios, man quecojon tä na ri' pune che jun winak ri cäc'astaj bi chquixol ri cäminakib,” —xcha ri ka mam Abraham che, —xcha ri Jesús chque ri tata'ib fariseos. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Xubij ri Jesús chque ru tijoxelab: Tzc'o wi jachique ri cubano chi jun winak chic curik ri be ri man utz taj, cätakchi'x c'u che mac. ¡C'äx re ri winak ri' ri rumal rech cäbantaj wa'! —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Are utz na we ta cäxim jun ca' re molino chukul ri winak ri', cäq'uiäk ta c'u bi pa ri mar, ¡utz c'u na ri' chuwäch ru banic chi jun chque we alaj tak ch'utik ri' curik ri be ri man utz taj! ");
INSERT INTO qucTNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Chiwila ba' iwib, —xcha chque. Xubij c'ut: We cämacun ri awachalal, cuban jun c'äx chawe, chapixbaj wa'. We cuq'uex ranima', cuq'uex c'u u chomanic, chasacha ru mac, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","We cämacun chawij wukub mul pa jun k'ij, cätzelej c'u awuc', cubij: “Man quinban tä chic,” —cächa'. Rajwaxic c'ut chi ri at casach ru mac, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Xquibij ri apóstoles che ri Kajaw Jesús: Bana ba' la chke chi sibalaj cujcojon na, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Xubij ri Kajaw Jesús chque: We ta quixcojonic xa ta ne jubik' je' jas ru nimal jun alaj ija' re mostaza, cuya' quibij na ri' che we che' sicómoro ri': “Chaboko' awib, chatica awib pa ri mar,” —quixcha che. Cäniman c'u na wa' we che' ri' chiwe, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","We c'o jun chiwe ri c'o jun patänil re ri cuban taji'n, we ne que' pa yuk', aretak c'ut cätzelej lok iwuc' cho ja, ¿jas quibano? ¿A c'o lo jun chiwe ri cubij na che ri ajchac: “Tasa'j chanim, chatt'uyul chi' ri mesa, chatwok”? —quixcha che, —cächa ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Man je' taj. Xane quibij ri' che ri patäninel: “Chabana ri quintijo. Chasuc'umaj awib, chaya ri nu wa rech quinwi'c. Te ri' cuya' catwi' at,” —quixcha che, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿A c'o maltioxinic ri' che ri patäninel rumal chi xuban ri xtak wi? Man c'o taj, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Je ri' ri ix xukuje', aretak i banom chic ronojel ri ix takom wi, chibij na chbil iwib: “Ri uj, uj patäninelab ri man c'o tä ka patän, rumal chi xka'n xak xuwi ri' ri tzrajwaxic u banic,” —quixcha na, —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Benak c'u ri Jesús pa Jerusalén, oc'owem cuban chquixol ri Galilea ruc' ri Samaria. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Aretak xopan pa jun alaj tinimit, xriktaj ri Jesús cumal lajuj achijab ri c'o itzel tak ch'a'c chquij. Xetaq'ui c'u chinaj. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Co xech'awic, xquibij: ¡Tat Jesús! ¡Ajtij! ¡Tok'obisaj la ka wäch! —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Xerilo, xubij chque: Jic'utu iwib chquiwäch ri tata'ib sacerdotes, —xcha chque. Pa ri qui bic c'ut, are chi' xecunaxic. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Aretak jun chque xrilo chi cunam chic, xtzelejic, co xch'awic, xunimarisaj u k'ij ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Xuxuc rib cho ri Jesús, sibalaj xmaltioxin che. Aj Samaria c'ut we achi ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Xubij c'u ri Jesús: ¿A mat ne e lajuj ri xecunaxic? E c'u ri belejeb, ¿jawije' e c'o wi? —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Xak xuwi wa' we achi ri' ri man ka winakil taj xtzelej lok, cunimarisaj c'u u k'ij ri Dios, —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Xubij ri Jesús che: Chatwalijok, cuya' cate'c. At cunam chic rumal chi xatcojonic, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Aretak ri tata'ib fariseos xquita' che ri Jesús jampa' cäpe ru takanic ri Dios cho ruwächulew, xubij ri Jesús chque: Ri u petic ru takanic ri Dios cho ruwächulew man quilitaj tä ri', —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Man cäbix tä na che: “Chawilampe', c'o chi ri'. Jawilampe', c'o chila',” —cächa'. Man je' taj rumal chi ya ulinak chi ri Dios iwuc' che takanic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Xubij c'u ri Jesús chque ru tijoxelab: Copan na ri k'ij ri sibalaj quirayij chi ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak, c'o iwuc', man in c'o tä chic, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ri winak cäquibij na chiwe: “Chiwilampe', c'o chi ri'. Jiwilampe', c'o chila',” —quecha na. Mixe' c'ut, mixteri bi cuc', —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Je' jas ri caypa' cusakirisaxtaj ronojel ri caj, k'alaj wa' chquiwäch conojel ri winak, je ri' xukuje' ri k'ij aretak ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak, quinpetic, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Rajwaxic c'ut chi nabe sibalaj quinrik na c'äx, quetzelax na nu wäch cumal ri winak re we k'ij junab ri', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Jas ri xca'n ri winak ojer pa ru k'ij ri ka mam Noé, je ri' xukuje' cäbantaj na pa tak ri k'ij ri quintzelej lok, in ri' ri Ralc'ual ri Dios ri Kas Winak. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Xewi' ri winak, xca'n nimak'ij, xec'uli'c, xquiya c'u ri calc'ual pa tak c'ulanem c'ä pa ri k'ij ri xoc bic ri ka mam Noé pa ri nimalaj barco. Xpe c'u ri nimalaj k'ekal jäb, xusach c'u qui wäch conojel, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Je ri' xukuje' jas ri xca'n ri winak ojer pa ru k'ij ri ka mam Lot, xewi' ri winak, xca'n nimak'ij, xelok'omanic, xeq'uiyinic, xetico'nic, xquiyac tak cachoch. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pa ri k'ij ri xel bic ri ka mam Lot pa ri tinimit Sodoma, xkaj lok k'ak' ruc' k'ol chicaj, xusach c'u qui wäch conojel ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Je' cäban na wa' pa ri k'ij ri cäk'alajin na jachin ri' ri Ralc'ual ri Dios ri Kas Winak, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Pa ri k'ij ri', ri winak ri c'o puwi' ri ja, moc chi bic che qui c'amic bi ri jastak re ri e c'o can chupam ri ja. Xukuje' ne ri c'o pa juyub mätzelej chi na cho ja, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Chna'taj ri rixokil ri mam Lot chiwe. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ri cutzucuj u chajixic rib, cutzak na ronojel, cäcäm c'u na wa'. Apachin c'u ri cutzak ru c'aslemal, cäto'taj na wa', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Kas tzij quinbij chiwe chi pa ri ak'ab ri', quec'oji na quieb pa jun ch'at. Jun chque cäc'am na bic, ri jun chic cäyi' na canok. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Quec'oji na quieb ixokib ri tajin quequie'n junam. Jun chque cäc'am na bic, ri jun chic cäyi' na canok. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Quec'oji na quieb achijab cachi'l quib pa tak juyub. Jun chque cäc'am na bic, ri jun chic cäyi' na canok, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Xquibij c'u che ri Jesús: ¿Jawije' cäban wi wa', Kajaw? —xecha che. Xch'aw chi ri Jesús, xubij: Ri cäc'oji wi na ri qui bakil ri cäminakib, chila' c'ut cäquimulij wi na quib ri c'uch, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ri Jesús xutzijoj chi na jun c'utbal chuya'ic tijonic chque ru tijoxelab chuc'utic chquiwäch chi rajwaxic u banic orar amak'el ronojel k'ij, mäq'uistaj c'u qui c'ux. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Xubij c'u chque: Pa jun tinimit c'o wi jun k'atal tzij ri man cuxej tä rib cho ri Dios, man nim tä c'u queril wi ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Xukuje' c'o jun chichu' malca'n pa ri tinimit ri', ri amak'el copan ruc', cutz'onoj che: Chinto' la pu k'ab ri nu c'ulel, —cächa che. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Xque' q'uia ri k'ij ri k'atal tzij man craj taj cuto' ri chichu'. Te c'u ri' xchoman pa ranima', xubij: “Pune man quinxej tä wib cho ri Dios, man nim tä c'u quinwil wi jun winak, ");
INSERT INTO qucTNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","quinto' na we chichu' malca'n ri' rumal chi sibalaj cuya latz' chwe. We man quinban k'atow tzij puwi' ruc' jicomal, cäpe na ri chichu' amak'el ronojel k'ij, sibalaj quinucos na,” —xcha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Xubij c'u ri Kajaw Jesús: Chitatabej ba' jas ri xubij ri k'atal tzij ri man jicom tä ranima', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿A mat ri Dios cuban na k'atow tzij ruc' jicomal pa qui wi' ri winak ri xeucha' che qui to'ic, ri quebochi'n che chi pak'ij chi chak'ab? ¿A mat chanim queuto' na wa'? —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Je', quinbij chiwe chi chanim cätoban na chque, —cächa'. Aretak c'ut ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak, quintzelej na lok, ¿a queinrik ne lo winak ri kas quecojon chwe? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Xutzijoj c'u we c'utbal rech tijonic ri' chque jujun winak ri quechoman chquij chbil quib chi sibalaj e utz na, ri cäquetzelaj c'u qui wäch ri jule' chic. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Xubij chque: E c'o quieb achijab. Jun chque are jun tata' fariseo. Ri jun chic are tok'il alcabal. Xeboc c'u bi pa ri nimalaj rachoch Dios rech cäca'n orar. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Tac'al c'u ri fariseo, xuban orar chbil rib, xubij: “O Dios, maltiox che la chi ri in man in tä junam cuc' ri niq'uiaj winak chic, ri elak'omab, ri winak ri man cäquibij tä jicomal tzij, ri cäca'n nimalaj mac, man in junam tä c'u ruc' we jun tok'il alcabal ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ri in quinban ayunar camul ronojel semana. Quinya c'u ru lajujil joropa' ri quinriko,” —xcha ri tata' fariseo. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Are c'u ri tok'il alcabal, tac'al chinaj, man craj tä c'u cäca'y chicaj, xane cut'oc u wo u c'ux chuc'utic chi cäbisonic, cubij: “¡Ay, Dios! We ne cäpax c'ux la chwe in, in wa' sibalaj in ajmac,” —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kas tzij quinbij chiwe chi we achi ri' xe' cho rachoch jicom chic ri ranima' cho ri Dios. Man je' tä c'u ri jun chic, ri tata' fariseo. Are c'u ri winak ri cunimarisaj rib cho ri Dios, cäkasax na u k'ij. Apachin c'u ri cuban che chbil rib chi man nim tä u banic, cänimarisax na u k'ij wa', —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Xec'am c'u bi ri ac'alab cho ri Jesús rech cuya ru k'ab pa qui wi'. Ru tijoxelab xquilo, xequiyaj ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ri Jesús xeusiq'uij ru tijoxelab, xubij chque: Chiya chque ri ac'alab chi quepe wuc', meik'atej, —cächa'. Xak xuwi chque ri winak ri e je' jas ri ac'alab ri' cäyi' wi chi cätakan ri Dios pa qui wi'. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Kas tzij ri quinbij chiwe chi ri winak ri man cäquina' tä pa canima' chi ri e are' je' ta ne ac'alab cho ri Dios, man cäquic'ulaj tä c'u ru takanic ri Dios, man cäyi' tä chque chi queboquic, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","C'o c'u jun chque ri qui nimakil ri winak xuta' che ri Jesús, xubij: Utzalaj Ajtij, ¿jas quinban in rech quinrik ri c'aslemal ri man cäq'uistaj taj? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Xubij c'u ri Jesús: ¿Jas che cabij utz chwe? Man c'o tä jun ri kas utz, xane xak xuwi ri Dios, —cächa ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Awetam c'u ru Lok' Pixab ri Dios ri cubij: “Matcämisanic, maban ri nimalaj mac ri äwas u banic ruc' ri rixokil jun winak chic, maban elak', maban tzij chrij jun winak chic, nim cheawila wi ra tat, ra nan,” —cächa ri Pixab, —xcha ri Jesús che. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Xubij ri achi che ri Jesús: Ronojel wa' nu nimam tzpa ri wac'alal, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Xuta wa' ri Jesús, xubij che: C'o na ri mäja' cabano. Jaq'uiyij conojel ri jastak awe, chaya ri rajil chque ri meba'ib. Cäc'oji c'u na ra k'inomal chila' chicaj, —cächa'. Te c'u ri' cuya' catteri wuc'. Jo' ba', —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Aretak ri achi xuta wa', sibalaj xq'uextaj ru wäch pa bis, xc'äxc'ob ri ranima' rumal chi sibalaj nim ru k'inomal c'olic. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ri Jesús xrilo chi sibalaj cäbisonic, xubij: ¡Sibalaj c'äx ri queboquic ri k'inomab ruc' ri Dios rech cätakan pa qui wi'! —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Are man c'äx taj ri roc'owisaxic jun quiej camello pa ri u julil jun t'isombal bak chuwäch ri roquic jun winak k'inom ruc' ri Dios rech cätakan puwi', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ri winak ri xetowic xquibij che ri Jesús: We je ri', ¿jachin ta c'u lo ri cäcowin churikic ru tobanic ri Dios? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Xubij c'u ri Jesús chque: Ri man quecowin tä ri winak chubanic, are c'u wa' cäcowin ri Dios che, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Xubij ri tat Pedro: Kajaw, chilampe la chi ri uj ka yo'm can ri jastak ke rech cujc'oji uc' la, —xcha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ri Jesús xubij che: Kas tzij ri quinbij chiwe chi we c'o jun winak ri u yo'm can ri rachoch, ri rixokil, ri rachalal, ru tat, u nan, ri ralc'ual rech quinuto' chutzijoxic ru takanic ri Dios, ");
INSERT INTO qucTNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","curik na q'uia chuwäch wa' pa tak we k'ij junab ri'. Curik c'u na ri c'aslemal ri man c'o tä u q'uisic pa tak ri junab ri quepe na, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ri Jesús xeuc'am bi ri cablajuj u tako'n pa qui tuquiel wi, xubij c'u chque: Cujpaki na bic, cuje' na pa ri tinimit Jerusalén. Ronojel c'u ri tz'ibam can cumal ri ojer tak k'alajisal re ru Lok' Pixab ri Dios chwij in, in ri' ri Ralc'ual ri Dios ri Kas Winak, cäbantaj na wa' chwe, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Quinquijach c'u na bic pa qui k'ab ri niq'uiaj winak chic. Cäquetz'bej na nu wäch, quinquiyok' na, xukuje' cäquichubaj na nu palaj. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Quinquirapuj na, te c'u ri' quinquicämisaj. Churox k'ij c'ut quinc'astaj na chquixol ri cäminakib, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ri tijoxelab man c'o tä c'u jun chque ri cuch'ob ri u tzij ri Jesús. Xban c'u chque chi man quek'alajin tä wa' we tzij ri' chquiwäch. Are c'u ri xbix chque man cuya' taj cäquich'obo. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Benam re ri Jesús, tajin cänakajin che ri tinimit Jericó. C'o c'u jun moy achi t'uyul chuchi' ri be ri tajin cämolonic. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Aretak xuto chi q'uia winak tajin queoc'owic, xuta' jas tajin cäbanic, xubij: ¿Jas ri'? —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Xquibij che: Are ri tat Jesús aj Nazaret ri tajin coc'owic, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Co xch'aw ri moy achi, xubij: ¡Tat Jesús! —cächa'. ¡Lal ri' ralc'ual can ri ka mam David, tok'obisaj la nu wäch! —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ri winak ri e tac'atoj chuwäch xeyajon che, xquibij chi mäch'aw chic. Ri are' c'ut co na xurak u chi', xubij: ¡Tat, ri lal ralc'ual can ri ka mam David, tok'obisaj la nu wäch! —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Xtaq'ui c'u ri Jesús, xtakan chuc'amic lok ri tata' ruc'. Aretak ri moy achi c'o chi ruc' ri Jesús, xubij ri Are' che: ");
INSERT INTO qucTNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","¿Jas caj la chi quinban che la? —xcha che. Xubij c'u ri moy achi: Tat, cwaj quinca'y chic, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Xubij c'u ri Jesús che: ¡Ca'y ba' la! —cächa che. Rumal chi cäcojon la, xcunataj la canok, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Chanim c'ut ri moy achi xca'yic, xteri bi chrij ri Jesús, cunimarisaj u k'ij ri Dios. Xukuje' conojel ri winak xquinimarisaj u k'ij ri Dios aretak xquilo ri xban che ri moy achi. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Opaninak chi c'u ri Jesús pa Jericó, oc'owem tajin cuban chupam ri tinimit. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","C'o jun achi, Zaqueo u bi', jun chque ri qui nimakil ri tok'il tak alcabal. K'inom c'u wa' we achi ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Xutzucuj rilic u wäch ri Jesús che retamaxic jachin ri'. Man cäcowin tä c'ut rumal chi e q'uia ri winak, xak c'u co'l rakan ri tat Zaqueo. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Xutic anim, xnabej bi chquiwäch ri winak, xpaki c'u puwi' jun che' sicómoro che rilic ri Jesús, rumal chi chila' coc'ow wi na ri are'. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Xopan c'u ri Jesús pa ri c'olibal ri', xca'y ak'an ajsic, xril ri tat Zaqueo, xubij che: Chanej la, kaj la lok. Rajwaxic chi cämic quincanaj can cho achoch la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Te c'u ri' xkaj lok ri tat Zaqueo puwi' ri che'. Xuc'ulaj ri Jesús, sibalaj xquicotic. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Xilitaj c'u wa' cumal conojel ri winak, xewixwitic, xquibij: Ula'm ri tat Jesús rumal jun achi sibalaj ajmac, xe' c'u ruc', —xecha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Xtaq'ui c'u ri tat Zaqueo, xubij che ri Jesús: Tampe la ri quinbano. Pa niq'uiaj ri jastak we quinya na chque ri meba'ib. Xukuje' we c'o jas nu k'ipom chrij jun winak, quincajmulij na u tzelexic wa' che, —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Xubij ri Jesús che: Cämic xrik la ru tobanic ri Dios, xukuje' ri winak ri e c'o cho achoch la, rumal chi cäk'alajinic chi lal ri' are kas rachalal ri ka mam Abraham, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak, in petinak che qui tzucuxic ri winak ri e tzakinak, xukuje' che qui to'ic, —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ri winak qui tatabem we tzij ri', ri Jesús xuchaplej u tzijoxic jun c'utbal chic re tijonic chque rumal chi quenakajin chic che ri tinimit Jerusalén. Xquichomaj ri winak chi ri Dios cuc'ut na rib chquiwäch chanim, cuchaplej c'u takanic pa qui wi'. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Xubij c'u ri Jesús chque: C'o jun achi, nim u banic, ri xe' naj pa jun tinimit chic rech coc che nim takanel pa qui wi' ri winak re ri tinimit ri'. Cuchomaj ri tata' chi aretak cäto'taj chila', cätzelej chi na lok cho ja. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ri achi c'ut xeusiq'uij lajuj chque ri patänil re, xeuya juwinak quetzales chque chquijujunal. Xubij c'u chque: “Chicojo wa' we puak ri' rech c'o quich'ac na chrij. Chibana wa' c'ä copan na ri k'ij ri quintzelej lok,” —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Are c'u ri winak re ri tinimit ri que' wi, sibalaj cäquetzelaj u wäch, xequitak c'u bi nimak tata'ib chrij chubixic: “Man cäkaj tä wa' we achi ri' che nim takanel pa ka wi',” —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pune je ri' xoc c'u na che nim takanel. Aretak xtzelej lok cho ja, xtakanic chi quesiq'uix lok ri patäninel tak re, ri xec'amow ri puak, rech cäretamaj na jas ri qui ch'acom chquijujunal. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Xopan c'u ri nabe patänil re ruc', xubij: “Tat, ri rajil la xuch'ac chi lajuj mul je' jas ri xya la chwe,” —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Xubij c'u ru patrón che: “Utz a banom, utzalaj patänil we,” —cächa'. “Catincoj na che takanel pa qui wi' lajuj tinimit rumal chi utz a banom at chrij ri jun alaj chac,” —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Xopan c'u rucab patänil re, xubij che: “Tat, ri rajil la u ch'acom chi job mul je' jas ri yo'm la chwe,” —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Xubij c'u ru patrón che: “Ri at c'ut catcoj na che takanel pa qui wi' job tinimit,” —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Xopan chi c'u jun chic patänil re, xubij: “Tat, ri' ri rajil la ri c'o wuc', nu c'olom c'u wa' pa jun su't,” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","“Je' nu banom wa' rumal chi quinxej wib chuwäch la. Ri lal c'ut sibalaj c'a'n la. Cäc'am la ri man ech tä la, cäk'at c'u la ri man ticom tä la,” —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Xubij c'u ri nim takanel che: “¡Ay, patänil we ri sibalaj man utz taj! Quink'at na tzij pa wi' ruc' ri tzij ri a bim chwe. Awetam c'ut chi ri in sibalaj in c'a'n, chi quinc'am ri man wech taj, quink'at c'u ri man nu ticom taj,” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","“¿Jas che man xaya tä ri nu rajil ruc' jun winak ri cäyo'w pa jalomal rech quintok'ij ruc' ral aretak quinulic?” —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Xubij c'u chque ri e tac'atoj chunakaj: “Chiwesaj ri puak ri c'o ruc', chiya che ri patänil we ri c'o ri lajuj cientos quetzales ruc',” —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Xquibij c'u che: “Tat, ya c'o chic lajuj cientos quetzales ruc',” —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Xubij c'u chque: “Quinbij chiwe chi ronojel jachin ri c'o c'o ruc', cäyataj na más che. Apachin c'u ri man c'o tä c'o ruc', quesax na che ri jubik' ri c'olic,” —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","“Are c'u ri nu c'ulel, ri man xcaj taj chi quintakan pa qui wi', chic'ama lok, chicämisaj wa' chnuwäch,” —xcha chque, —xcha ri Jesús chque ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Aretak xbitaj wa' rumal ri Jesús, xnabej chquiwäch, xutakej ru be, xe' c'u pa ri tinimit Jerusalén. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nakaj chi c'u e c'o wi che ri tinimit Betfagé, xukuje' ri tinimit Betania chuwäch ri juyub u bi'am Ujuyubal Olivos, xeutak bic quieb chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Xubij c'u chque: Jix pa ri alaj tinimit ri c'o apan chkawäch. Aretak ix opaninak chi chila', quirika na jun burro yukulic, ri man c'o tä jumul jun winak quiejeninak chrij. Chiquira wa', chic'ama lok, —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","We c'o jun cuta' chiwe: ¿Jas che quiquiro? —cächa ne. Je' quibij wa' che: Xa cajwataj wa' che ri Kajaw Jesús, —quixcha che, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Xebe' c'u ri tijoxelab ri xeutak bic, je' xequirika jas ri xubij ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tajin cäquiquir ri burro aretak ri ajchak'el xquita' chque, xquibij: ¿Jas che tajin quiquir ri burro? —xecha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ri e are' xquibij: Xa cajwataj wa' che ri Kajaw Jesús, —xecha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Xquic'am c'u bic, xquiya c'u che ri Jesús. Xquicoj ri qui k'u' chrij, xquiya c'u ri Jesús chrij. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Quiejeninak ri Jesús, tajin cäbinic. Xquilic' ri qui k'u' pa ri be. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nakaj chi c'u e c'o wi che ri Jerusalén, xeopan pa ri xulanic re ri Ujuyubal Olivos. Conojel ri q'uialaj tak u tijoxelab xquichaplej quicotem, co xech'awic, xquinimarisaj u k'ij ri Dios rumal conojel ri nimak tak cajmabal ri quilom. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Cäquibij c'ut: ¡Tewchim ba' ri Nim Takanel ri petinak pa ru bi' ri Kajaw Dios! —quecha'. Cuxlan na kanima' rumal ri Dios chicaj. ¡Chnimarisax ba' u k'ij ri Dios ajchicaj! —xecha ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Jujun chque ri tata'ib fariseos ri e c'o chquixol ri q'uialaj winak xquibij che ri Jesús: Ajtij, cheyaja la ri tijoxelab la, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ri Jesús xch'awic, xubij chque: Kas tzij, we ta mat quech'aw wa' we winak ri', are co quech'aw na ri abaj, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Aretak xenakajin che ri tinimit, ri Jesús xok' pa qui wi' ri winak aj Jerusalén. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Xubij: Cwaj ta ne chi pa we k'ij ri' quiwetamaj jachin ri' ri cäcowinic cuya utzil chixol. C'u'tal c'u wa' cämic chiwäch, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Quepe c'u na ri k'ij chiwij aretak ri q'uialaj i c'ulel cäca'n na jun c'otom chrij ri tinimit, cäquisutij na rij, sibalaj c'u cäquilatz'obisaj na wa', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Quequiwulij na can ri iwachoch cho ulew, quixquicämisaj na. Man cäcanaj tä c'u na can jun abaj puwi' jun abaj chic, —cächa'. Are c'u rumal wa' chi man iwetam taj chi pa we k'ij ri' ri Dios xixusolij, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Xoc c'u bic ri Jesús pa ri nimalaj rachoch Dios, xuchaplej quesaxic bic ri ajc'ayib, xukuje' ri lok'omanelab. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Xubij c'u chque: Tz'ibam c'ut pa ru Lok' Pixab ri Dios: “Ri wachoch in are ja ri cäban wi orar,” —cächa ri Tz'ibtalic. Ri alak c'ut, cachoch elak'omab banom alak che, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ronojel k'ij ri Jesús xuya tijonic pa ri nimalaj rachoch Dios. Are c'u ri qui nimakil sacerdotes, ri tijonelab re ri Pixab, xukuje' ri qui nimakil ri winak re ri tinimit xquitzucuj u cämisaxic. ");
INSERT INTO qucTNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Man xquirik tä c'ut jas cäca'n che, rumal chi conojel ri winak qui jiquibam canima' chutatabexic ri cubij chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Pa jun k'ij ri Jesús tajin queutijoj ri winak pa ri nimalaj rachoch Dios, tajin cutzijoj ri Utzalaj Tzij re ri Evangelio chque. Xeopan c'u ri qui nimakil tak sacerdotes cuc' ri tijonelab re ri Pixab xukuje' ri qui nimakil ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Xquibij c'u che: ¿Jachin xtakow la chi ri lal cäban la wa' we ri'? ¿Jachin lo ri yo'winak takanic pa k'ab la chi je' cäban la wa'? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Xch'aw ri Jesús, xubij chque: Ri in xukuje' c'o jas quinta' chech alak, —cächa'. Bij alak chwe: ");
INSERT INTO qucTNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Jachin xtakow ri tat Juan chubanic kasna'? ¿A are ri Dios, o are ri winak? ¿Jachin xyo'w che chi je' cuban wa'? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Xquitzijobela quib, xquibij: We cäkabij chi are ri Dios, ri are' cubij na chke chi jas che man xkacoj tä wa', —quecha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","We c'u cäkabij chi xa are ri winak, conojel ri winak cujca'n na che abaj. Elinak c'u chi sak chquiwäch ri winak chi ri tat Juan are k'alajisal re ru Lok' Pixab ri Dios, —xecha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Xech'aw chic, xquibij che ri Jesús chi man cäquich'ob tä wa' chi jachin ri' ri xyo'w che ri tat Juan chi cuban kasna'. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Xubij c'u ri Jesús chque: Xukuje' ri in man quinbij tä in chech alak jachin ri yo'winak chwe chi in quinban wa' we ri', —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ri Jesús xuchaplej u tzijoxic wa' we c'utbal ri' re tijonic chque ri winak: C'o jun achi ri xuban jun ticbal uvas. Xticonijic, xuya c'u can ri ulew pa kajomal chque jujun tajinelab. Te c'u ri' xe' naj pa jun tinimit chic, naj xsachic. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Xopan c'u ri k'ij re ru yaquic ri wächinic, xutak bi jun patänil re cuc' ri ajchaquib rech cäquiya bi niq'uiaj re ri u wäch ri ticbal uvas. Are c'u ri ajchaquib xquich'ayo, xquitak bic, man c'o tä xquiya bi che, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Xutak c'u bi jun u patäninel chic. Xukuje' wa' xquich'ayo, xquetzelaj u wäch, xquitak bic, man c'o tä xquiya bi che, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Churox mul xutak bic jun patänil re cuc'. Xquisoc wa', xukuje' xquesaj bi pa ri ticbal uvas, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Te c'u ri' xuchomaj ri rajaw ri ticbal uvas, xubij: “¿Jas ta c'u lo quinbano?” —cächa'. “Quintak na bic ri lok'alaj nu c'ojol. Craj ne nim cäquil wi ri are' aretak cäquilo,” —xcha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ri ajchaquib, aretak xquilo, xquich'abej quib, xquibij: “¡Chawilampe'! Are wa' ri quechben na ronojel,” —quecha'. “Chixsa'j, kacämisaj ri achi rech cäkechbej na wa' we ulew ri',” —xecha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Xquesaj c'u bi ru c'ojol ri ajchak'el ri ticbal uvas, xquicämisaj c'ut, —xcha ri Jesús chque. Te ri' xuta' ri Jesús chque, xubij: ¿Jas c'u cuban na ri rajaw ri ticbal uvas chque? —cächa ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Cäpe na ri are', queucämisaj na ri ajchaquib ri', cuya na ri rulew chque jule' chic, —xcha ri Jesús chque. Aretak xquita wa', xquibij ri winak: ¡Ay, mäbantaj wa'! —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Xca'y c'u ri Jesús chque, xubij: ¿Jas quel cubij wa' ri tz'ibam canok pa ru Lok' Pixab ri Dios? cubij: Ri abaj ri man xcaj tä ri yacal tak ja, we abaj ri' are xcoj che tok'ebal re ri ja, —cächa ri Tz'ibtalic, —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ronojel winak jachin ri cätzak puwi' ri abaj ri', cäsoctaj na. We c'u cätzak we abaj ri' chrij jun, cuc'äjij na, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ri tijonelab re ri Pixab cuc' ri qui nimakil sacerdotes aj Israel xquichaplej u tzucuxic jas cäca'n chuchapic ri Jesús pa ri hora ri', xquixej c'u quib chquiwäch ri winak. Xquich'ob c'ut chi ri c'utbal ri', xtzijox wa' chquij ri e are'. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Xcaluchij ri Jesús, xequitak bi winak chuyuxlexic. Ri winak ri' xca'n che quib chi e utzalaj tak winak rech cäquirik jun tzij pu chi' ri Jesús rech cäquijach bi ri Are' pu k'ab ri k'atal tzij, cäk'at c'u na tzij puwi'. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Rumal wa' xquic'ot u chi' ri Jesús, xquibij: Ajtij, ketam chi utz wa' ri cätzijon la xukuje' ruc' jicomal cätijon la. Ketam c'ut chi man nim tä quil la jun winak chuwäch jun chic. Xane cäc'ut la ri kas u rayinic ri Dios, —quecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿A rajwaxic cäkatoj alcabal che ri nimalaj takanel aj Roma? We ne man rajwaxic taj, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Xretamaxtaj c'u ri Jesús ri qui chomanic, xubij chque: ¿Jas che cäta' alak wa' chwe? ");
INSERT INTO qucTNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","C'utu ba' alak jun puak chnuwäch, —cächa chque. ¿Jachin c'u rech we ca'yebal ri' xukuje' ri bi'aj ri' ri c'o chuwäch ri puak? —xcha ri Jesús. Xech'aw chi na ri winak, xquibij che: Are rech ri César ri nimalaj takanel, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Xubij c'u ri Jesús chque: Ya alak che ri tat César ri rech ri César. Ya ba' alak che ri Dios ri rech ri Dios, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Man c'o tä c'u jun tzij xecowin churikic pu chi' ri Jesús ri xkaj ta wi pa qui k'ab chquiwäch ri winak. Xane xquicajmaj ri xubij ri Jesús chque, man xech'aw tä c'u chic. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Xeopan c'u jujun chque ri tata'ib saduceos, ri cäquibij chi man quec'astaj tä chi na ri cäminakib. Ri tata'ib ri' xquic'ot u chi' ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Xquibij che: Ajtij, tz'ibam can chke rumal ri ka mam Moisés chi we cäcäm jun achi, c'o c'u can rixokil, man e c'o tä c'u can ralc'ual chrij are', rajwaxic chi ri rachalal ri cäminak cäc'uli ruc' ri ixok malca'n ri' rech quec'oji can ralc'ual ruc'. Ri ac'alab ri quil qui wäch je' ta ne e rech ri cäminak, —quecha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Xquibij c'ut: E c'o wukub achijab cachalal quib. Ri nabeal xc'uli'c, xcäm c'ut, man xc'oji tä can ralc'ual ruc' ri rixokil. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ri ucab xc'uli ruc' ri rixnam malca'n, xukuje' xcäm bic, man xc'oji tä can ralc'ual ruc'. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ri urox xukuje' xc'uli ruc' ri malca'n. Je c'u ri' xca'n ri wukub achijab chquijujunal, xecämic, man xec'oji tä can calc'ual. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Q'uisbal c'ut xcäm ri ixok, —quecha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Aretak c'ut quec'astaj chi ri cäminakib, ¿jachin lo chque ri wukub achijab ri' cäc'oji na che rachajil ri chichu'? Xoc c'u che quixokil ri wukub, —xecha che ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Xch'aw chi ri Jesús, xubij chque: Ri winak ajuwächulew quec'uli'c, cäquiya ri calc'ual pa c'ulanem. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ri winak ri ya'tal chque chi quec'astaj bic chquixol ri cäminakib, xukuje' chi cäc'oji qui c'aslemal ri man cäq'uis taj, man quec'uli tä chic, man queyi' tä c'u che c'ulanem, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","E junam chic jas ri ángeles. Man quecowin tä chic quecämic. E are c'u ralc'ual ri Dios wa', ri e c'astajinak chic chquixol ri cäminakib, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ri ka mam Moisés xutzijoj chi ri cäminakib quec'astaj na, —cächa'. Are wa' ri cuk'alajisaj ri tzij ri xutz'ibaj chrij ri q'uix ri cäc'atic. Chila' c'ut cubij wi xukuje' chi ri Kajaw Dios are ri u Dios ri ka mam Abraham, u Dios ri ka mam Isaac, u Dios ri ka mam Jacob, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ri Dios c'ut, man are tä Dios quech cäminakib, xane quech ri winak ri e c'asc'oj. Ri e c'aslic, e c'asc'oj c'u wa' rumal ri Dios, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Xech'aw chi na jujun chque ri tijonelab re ri Pixab, xquibij: Ajtij, kas utz ri bim la, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Man xquichajij tä chi c'u anima' chuc'otic u chi' ri Jesús jumul chic. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Xubij c'u ri Jesús chque: ¿Jas che cäbixic chi ri Cristo are ralc'ual can ri ka mam David? ");
INSERT INTO qucTNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Are c'u ri ka mam David cubij pa ri wuj Salmos: Xubij ri Kajaw Dios che ri Wajaw: “Chatt'uyul pa nu wiquiäk'ab ");
INSERT INTO qucTNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","c'ä quinya na chawe chi catch'acanic, cattakan c'u na pa qui wi' ri cäca'n qui c'ulel chawe,” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","We ri ka mam David cubij Wajaw che, ¿jas ta c'u che cäbij alak chi are xa ralc'ual can ri ka mam David? —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Conojel ri winak xetowic aretak xubij wa' chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Je wa' xubij: Chichajij iwib chquiwäch ri tijonelab re ri Pixab. Cäkaj chquiwäch quebinicat pa chärchäk tak catz'iak. Xukuje' je'l cäquilo, nim c'u queil wi ri cäyi' rutzil qui wäch pa tak ri c'ayibal. Cäquitzucuj c'u ri t'uyulibal ri nim qui banic pa tak ri rachoch Dios, xukuje' ri t'uyulibal ri nim queil wi pa tak ula'nem, —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Xukuje' cäquitokij tak ri cachoch ri ixokib malca'nib. Te ri' cäquiyuk rakan ri qui tzij aretak cäca'n orar rech man k'alaj tä ri etzelal ri cäca'no. Kas nim na ri c'äx cäquirik na ri tijonelab re ri Pixab aretak cäk'at tzij pa qui wi', —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Pa ri nimalaj rachoch Dios ri Jesús xeril ri k'inomab ri tajin cäquiya ri qui rajil pa ri c'olibal ri cäyi' wi ri cuchuj. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Xril xukuje' jun chichu' malca'n ri sibalaj meba'. Xeuya c'u quieb puak ri man nim tä rajil pa ri c'olibal cuchuj, craj ne xa jun centavo rajil ri quieb puak ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Xubij c'u ri Jesús: Kas tzij ri quinbij chiwe chi we meba'laj chichu' malca'n ri', are nim na wa' ri xuya ri are' chquiwäch conojel ri jule' winak ri qui yo'm que. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ri jule' winak chic qui yo'm jubik' che ri q'uia ri c'o cuc'. Are c'u we chichu' malca'n ri', pune sibalaj meba', u yo'm ronojel ri tzukubal re, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","E c'o c'u jujun chque ri winak tajin quetzijon chrij ri nimalaj rachoch Dios chi wiktal cuc' je'lalaj taj abaj, xukuje' cuc' lok'alaj tak sipanic. Xubij c'u ri Jesús: ");
INSERT INTO qucTNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Copan na ri k'ij ri man cäcanaj tä na can jun abaj puwi' jun abaj chic re we ja ri' ri quiwilo. Conojel quewulix na, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Xquita' c'u che ri Jesús, xquibij: Kajtij, ¿jampa' cäbantaj na wa'? ¿A c'o etal ri cuk'alajisaj chkawäch chi are k'ij ri' ri cäban na ri xbij la chke? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Xubij ri Jesús: Chichajij iwib rech mixsubtajic. E q'uia ri quepe na ri cäquicoj na ri nu bi', cäquibij: “In ri' ri Cristo,” —quecha na. Xukuje' cäquibij: “Ketetinak chi lok ri k'ij,” —quecha ri', —cächa ri Jesús. Mixe' c'u cuc' ri e are', —cächa ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Aretak quita u tzijol nimalaj ch'oj xukuje' chi cäquiwalijisaj quib ri winak chquij k'atal tak tzij, mixej iwib. Rajwaxic chi nabe cäbantaj na wa' we ri', —cächa chque. C'ä mäjok ri q'uisbal re we k'ij junab ri', —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Te ri' xubij chi ri Jesús chque: Quech'ojin na ri winak, ri juch'ob winak cuc' ri juch'ob chic. Xukuje' cäch'ojin na jun tinimit ruc' jun tinimit chic, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Cäpe na nimalaj wi'jal pa tak jujun tinimit. Pa tak niq'uiaj tinimit chic quepe na lawalo tak yabil. Quepe c'u na nimak tak cäbrakan. Queilitaj na xibibalalaj tak jastak xukuje' nimalaj tak etal chicaj, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Nabe c'ut chquiwäch wa' we jastak ri' quixquichap na ri winak, quixquijach na pa qui k'ab ri qui nimakil ri winak, xukuje' quixquicoj na pa che'. Quixquic'am na bi chquiwäch nimak tak tata'ib ri quetakan pa qui wi' ri winak, xukuje' chquiwäch k'atal tak tzij rumal wech in, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Are k'ij wa' rech quinik'alajisaj na in chquiwäch, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","C'ol ba' pa iwanima' chi michomaj na bic jas ri' ri quibij na chuto'ic iwib. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ri in quinya na chiwe ri rajwaxic u tzijoxic, xukuje' quinya ri i no'j. Ri i c'ulel man cäquirik tä chi na jas cäquibij chiwe, man quech'acan tä pi wi', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Cäban na tzijtal chiwij cumal ri i tat, i nan, ri iwachalal, ri iwachi'l rech quixjach bic. Quecämisax na jujun chiwe. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Conojel cäquetzelaj na i wäch xa rumal wech in, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Man cäsach tä c'u na u wäch jun chiwe. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","We quich'ij wa', quixto'taj na, c'o na ri i c'aslemal ri man c'o tä u q'uisic, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Aretak quiwil ri tinimit Jerusalén sutim rij cumal soldados, chich'obo' chi cäsach na u wäch ri tinimit chanim. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Pa ri k'ij ri' ri winak ri e c'o pa Judea cheanimaj bi pa tak ri juyub. Ri e c'o pa ri tinimit, chebel bic. Ri e c'o pa tak ri juyub, meboc chi bi pa ri tinimit, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Are c'u wa' ri k'ij ri cätoj na u q'uexel ri qui mac ri winak aj Jerusalén cho ri Dios. Cäbantaj na ronojel ri tz'ibam chrij we tinimit ri', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Tok'ob c'u qui wäch ri ixokib ri yawab tak winak chic, xukuje' ri e c'o alaj tak cal ri c'ä tajin quetu'nic pa ri k'ij ri'! Cäc'oji c'u na nimalaj c'äxc'ol cho ruwächulew. Are cäpe na ri nimalaj royowal ri Dios pa qui wi' ri winak re ri tinimit ri', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","E q'uia ri quecämisax na cuc' tak ch'ich'. Quechap c'u niq'uiaj, quec'am c'u na bi naj pa tak ronojel tinimit. Ri tinimit Jerusalén cäban na pa tak akan cumal ri winak ri man e aj Israel taj, c'ä cätz'akat na ri k'ij ri yo'm chque we winak ri' chi je' cäca'n wa', —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Quec'oji na etal ajsic chrij ri k'ij, chrij ri ic', chquij tak ri ch'imil. Sibalaj c'äx cäquirik na ri winak ri e c'o cho ruwächulew. Man cäquirik tä chic jas cäca'no, xane sibalaj cäquixej na quib rumal ri nimalaj rok'ebal ri cuban ruwoja' re ri mar, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Cäbirbit na ri canima' ri winak rumal ri xibriquil xukuje' rumal ru chomaxic wa' ri cäbantaj na cho ruwächulew. Queyicopisax na ri u chuk'ab ri caj, —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Te c'u ri' quilitaj na chi quinpetic, in ri' ri Ralc'ual ri Dios ri Kas Winak, pa jun sutz' ruc' nimalaj nu chuk'ab, cänimarisax c'u na nu k'ij, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Aretak quechap qui banic wa' we ri' ri nu bim chiwe, chiwilampe', chixca'y chicaj. Cäketet chi c'u lok ri k'ij ri quixutor na ri Dios, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Xutzijoj c'u jun c'utbal chic re tijonic chque, xubij: Chiwilampe ri u che'al higos, xukuje' ronojel u wäch che'. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Aretak quiwilo chi quetux ri qui xak, quich'ob pa iwe wi chi ketetinak chi lok ri k'alaj. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Je ri' xukuje' ri ix aretak quiwilo chi cäbantaj wa' ri nu tzijom chiwe, chich'obo' chi xak jubik' craj chi cäpe ri Dios che takanic pa qui wi' ri winak, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Kas tzij quinbij chiwe chi man coc'ow tä na we k'ij junab ri' c'ä cäbantaj na ronojel. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Cäsach c'u na u wäch ri caj, xukuje' ruwächulew, are c'u ri nu tzij ri nu bim chiwe, quebantaj na wa', —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Chichajij ba' iwib rech man que' tä iwanima' cuc' tak nimak'ij, k'abaric, rech man que' tä ne cuc' niq'uiaj jastak chic ajuwächulew pune are ri i chac, pune are ri qui tzukic iwalc'ual. Te'talic c'ut cäpe na ri k'ij ri' chiwij jas jun awanel. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Je' u petic wa' ri k'ij ri' pa qui wi' conojel winak ri e c'o cho ruwächulew, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Chiwila ba' iwib amak'el ronojel k'ij jas ri quibano, chibana orar amak'el che ri Dios rech cäyi' na chiwe chi quixresaj na chuwäch ronojel wa' ri cäpe na cho ruwächulew. Chibana wa' rech cuya' quixtaq'ui na chnuwäch in pa utzil, in ri' ri Ralc'ual ri Dios ri Kas Winak, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ri Jesús xuya tijonic ronojel k'ij pa ri nimalaj rachoch Dios. Chak'ab c'ut xel bic, xcanaj can pa ri juyub ri cojom Ujuyubal Olivos che ru bi'. ");
INSERT INTO qucTNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Sibalaj ak'ab cäquimulij quib ri winak chuwäch ri Jesús pa ri nimalaj rachoch Dios chutatabexic ru tzij. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Xketet chic ri nimak'ij re ri caxlan wa ri man cäyi' tä ch'äm ruc'. “Pascua” u bi' ri nimak'ij ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ri qui nimakil ri sacerdotes aj Israel, xukuje' ri tijonelab re ri Pixab tajin cäquitzucuj jas cäca'n chucämisaxic ri Jesús. Cäquixej c'u quib chquiwäch ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Xoc c'u ri Satanás pa ranima' ri tat Judas ri xukuje' cäcoj Iscariote che ru bi'. Are jun chque ri cablajuj apóstoles. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Xe' ri tat Judas, xeutzijobej c'u ri qui nimakil sacerdotes, xukuje' ri qui nimakil soldados rech cärilo jas cuban na chujachic ri Jesús pa qui k'ab. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Xequicot c'ut, xquiya qui tzij chi cäquiya na puak che ri tat Judas chutojic wa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Xuchi'j c'u ri tat Judas u jachic ri Jesús aretak man e c'o tä q'uia winak. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Xopan c'u ri nimak'ij re ri caxlan wa ri man cäyi' tä ch'äm ruc'. Pa ri k'ij ri' rajwaxic u cämisaxic ri alaj chij re ri Pascua rech cäquitijo. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ri Jesús xeutak bi ri tat Pedro, ri tat Juan, xubij chque: Jibana u banic ri wi'm re ri Pascua rech cäkatijo. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Xquita' c'u che ri Jesús, xquibij: ¿Jawije' caj wi la chi cäka'n wi ri wi'm? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Xubij ri Jesús chque: Aretak quixopan pa ri tinimit, quirika na jun achi ruc'am jun k'ebal joron. Chiterenej bic c'ä quixopan na pa ri ja ri coc wi. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Chibij che ri rajaw ja: “Cuta' ri Kajtij che la: ¿Jawije' c'o wi ri cuarto ri quintij wi ri wi'm re ri Pascua cuc' ri nu tijoxelab?” —quixcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Cuc'ut na chiwäch jun nimalaj cuarto suc'umatal chic pa ri cawik ja. Chibana u banic ri wi'm re ri Pascua chila', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Xebe' c'ut, xequirika ronojel je' jas ri u bim bi ri Jesús chque. Xquichap u banic ri wi'm re ri Pascua. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Aretak xopan ri hora, xt'uyi ri Jesús chi' ri mesa. E c'o ri cablajuj apóstoles ruc'. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Xubij chque: Sibalaj nu rayim u tijic wa' we wi'm ri' re ri Pascua iwuc' c'ä mäja' quinrik c'äx. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Quinbij c'u chiwe chi man c'o tä chi na jumul ri quintij na wa' c'ä cäbantaj na wa' pa ru takanic ri Dios, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Xuc'am c'u ri vaso, xumaltioxij wa' che ri Dios, xubij chque ru tijoxelab: Chic'ama wa'. Chijacha wa' chiwäch, chitija ba'. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Quinbij c'u chiwe chi man quintij tä chi na we ri u wa'l uvas c'ä cäpe na ri Dios che takanic pa qui wi' ri winak, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Aretak ri Jesús xuc'am ri wa, xumaltioxij wa' che ri Dios. Xupiro, xuya chque ru tijoxelab, xubij: Are je' jas ri nu cuerpo ri cäjach na rumal iwech ix. Chitija wa' che natabal we, —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Aretak e wokinak chic, xuc'am xukuje' ri vaso junam jas ri xuban che ri wa, xubij: Ri c'o chupam we vaso quinjunamaj ruc' ri nu quiq'uel ri cäturuwisax na rumal iwech ix. Cäban c'u na ri c'ac' trato rumal we nu quiq'uel ri', —cächa ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","¡Chiwilampe'! Ri jachal we tajin cäwi' wuc' chi' we mesa ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kas tzij quincäm na in, in ri' ri Ralc'ual ri Dios ri Kas Winak, je' jas u beyal ru chomanic ri Dios. ¡C'äx c'u re ri achi ri quinjachowic! —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Te ri' xquichap u c'otic qui chi' chbil quib chrij jachin chque ri cäbanow na wa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Te c'u ri' ri tijoxelab xquichaplej u chomalaxic quib chrij jachin chque ri nim na u banic. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Xubij c'u ri Jesús chque: Ri k'atal tak tzij quetakan wa' pa qui wi' ri winak. Ri e c'o pa qui wi' ri winak cäbix “Banal tak Utzil” chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Man je' tä c'u wa' ri ix. Xane ri nabeal chiwe are je' ta ne ri más ac'al. Are c'u ri nim u banic chixol are junam jas ri patänil iwe. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Jachin c'u ri nim na u banic? ¿A are ri cät'uyi chi' ri mesa, o are ri patänil iwe? ¿A mat are ri cät'uyi chi' ri mesa? Are c'u ri in, in c'o iwuc' je' jas ri patänil iwe, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ri ix c'ut, ronojel k'ij xixc'oji wuc' in. I rikom c'äx junam wuc' in. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Rumal wa' quinya na chiwe chi quixtakan na je' jas ri xuya ri Dios ri nu Tat chwe in chi ri in quintakanic. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Quinban na wa' rech quixwi' wuc' in chi' ri nu mesa pa ri nu takanic in. Ri ix c'ut cäyi' na chiwe chi quik'at na tzij pa qui wi' ri winak re ri cablajuj juch'ob winak re ri tinimit Israel, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Xukuje' xubij ri Kajaw Jesús: Simón, Simón, chawila' chi ix iwonojel ix u tz'onom ri Satanás rech quixutakchi'j che mac che rilic we kas tzij quich'ij wa'. Junam cuban na ri are' chiwe jas ri cuban jun winak cuseysa' ri trico rech cätzak na canok ri man utz taj, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","In bochi'm c'u ri Dios pa wi' at rech catcojon na, rech man cattzak taj. Ri at c'ut, aretak caq'uex awanima', catzelej awib, queato' ba' ri awachalal, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Xubij ri Simón Pedro che: Kajaw, nu jiquibam ri wanima' in chi quine' uc' la, pune ba' pa che', pune ba' quincäm uc' la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Xubij ri Jesús che: Pedro, kas tzij quinbij chawe chi c'ä mäjok cätzintzirikin ri ama' äc' cämic, cabij na at oxmul chi man awetam tä nu wäch, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Xubij ri Jesús chque conojel: Aretak xixintak bic, man c'o tä i bolsa re puak, man c'o tä i chim, man xic'am tä bic i xajäb. ¿A c'o lo jas xajwataj chiwe? —xcha chque. Man c'o taj, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Xubij c'u chque: Cämic c'ut, apachin ri c'o u bolsa re puak, chuc'ama bic, xukuje' chuc'ama bi ru chim. We man c'o tä u machete, chuq'uiyij ru k'u' chulok'ic jun re, —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Quinbij c'u chiwe chi tzrajwaxic wi chi cäbantaj ri tz'ibam chwij pa ru Lok' Pixab ri Dios, —cächa'. Are wa' ri cubij: “Xbix che chi are jun chque ri itzel tak winak,” —cächa'. Ronojel c'u ri tz'ibtal chwij, rajwaxic chi cäbantaj na wa', —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Xquibij ru tijoxelab che: Kajaw, ¡chilampe la! E c'o quieb machetes waral, —xecha che. Ruc' wa', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Xel bi ri Jesús, xe' pa ri Ujuyubal Olivos je' jas ru nak'atisam wi rib. Xukuje' ru tijoxelab xeteri bi chrij. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Aretak xeopan jela', xubij chque ru tijoxelab: Chibana orar rech man quixtzak taj aretak quixtakchi'x che mac, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ri Jesús c'ut xutas apan rib chque. Je' xec'ol wi apanok jas ru najil jun abaj ri cusirirej apan jun. Xxuqui'c, xuban orar. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Xubij: Tat, we caj la, bana ba' la chi man rajwaxic taj chi quinrik we nimalaj c'äx ri cäpetic, —cächa'. Mäban c'u la ri nu rayibal in, xane ri rayibal la, —xcha ri Kajaw Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Xuc'ut c'u rib jun ángel ajchicaj chuwäch ri xyo'w u chuk'ab. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ri Jesús, rumal chi sibalaj nim ri c'äx ri tajin cuno', sibalaj xucoj u chuk'ab chubanic orar. Sibalaj xubok ja' je' ta ne chi are nimak tak tz'uj re quic' ri cäkaj cho rulew. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Aretak xto'taj ri Jesús chubanic orar, xe' cuc' ru tijoxelab. Xeurika'. Tajin quewar rumal ri qui bis. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Xubij ri Jesús chque: ¿Jas che quixwaric? Chixwalijok, chibana orar rech man quixtzak taj aretak quixtakchi'x che mac, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Tajin cätzijon ri Jesús aretak xeopan q'uia winak. Ri tat Judas, jun chque ri cablajuj u tijoxelab ri Jesús u c'amom ri qui be. Xnakajin ri tat Judas che ri Jesús chutz'umaxic. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Xubij c'u ri Jesús che: Judas, —cächa'. ¿A quinatz'umaj che nu jachic bic? ¿A je' caban chwe in, in ri' ri Ralc'ual Dios ri Kas Winak? —xcha ri Jesús che. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ri e sutininak rij ri Jesús, aretak xquil ri xuc'ulmaj, xquibij che: Kajaw, ¿a quekach'ay na che machete? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Jun chque ri tijoxelab xusoc jun achi ri patänil re ri qui nimal sacerdotes aj Israel, xresaj c'u ru xiquin re u wiquiäk'ab. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Xch'aw chi ri Jesús, xubij: Ruc' wa', —xcha'. Chiya can ri ch'oj, —xcha chque. Xuchap c'u cok ru xiquin ri achi, xucunaj. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Te ri' xch'aw ri Jesús jumul chic, xubij chque ri qui nimakil sacerdotes, xukuje' chque ri qui nimakil soldados ri chajinelab re ri nimalaj rachoch Dios, xukuje' chque ri qui nimakil ri winak, e are' c'u tak wa' ri e petinak chrij chuchapic: Je' ta ne chrij jun elak'om ri elinak wi lok alak cuc' machetes, cuc' che', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","In c'o c'u uc' alak ronojel k'ij pa ri nimalaj rachoch Dios, man xinchap tä alak. Are c'u hora wa' ri yo'm chech alak chi cäban alak wa'. Ri chuk'ab alak are re ri Itzel wa' ri cätakan pa ri k'ekum, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Xquichap c'u ri Jesús, xquic'am bi cho rachoch ri qui nimal sacerdotes aj Israel. Ri tat Pedro u terenem chinaj. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Aretak xquinuc' k'ak' pu niq'uiajal ruwoja, conojel xquimulij quib chrij, xet'uyi'c. Xukuje' ri tat Pedro xt'uyi chquixol. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Te ri' jun ali ajic' xril ri tat Pedro t'uyul chrij ri k'ak'. Co xca'y che, xubij: Ri achi ri' are jun ruc' ri Jesús xukuje', —xcha ri ali. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ri tat Pedro xresaj rib chupam, xubij: Man je' taj, ali, —xcha'. Man wetam tä u wäch, —xcha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Man naj tä chi c'ut, c'o jun chic xilow ri tat Pedro, xubij che: Ri at xukuje', at jun chque ri e c'o ruc' ri tat Jesús, —xcha che. Xubij ri tat Pedro: Man in tä ri', tat, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Craj oc'owinak jun hora chic, c'o chi jun xujiquiba u bixic, xubij: Kas tzij ri are' jun ruc' rumal chi are aj Galilea, —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Xubij c'u ri tat Pedro: Tat, man quinch'ob taj jas ri cäbij la, —xcha che. C'ä tajin cätzijon ri tat Pedro aretak xtzintzirikin jun ama' äc'. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Te ri' xutzolk'omij rib ri Kajaw Jesús, xca'y che ri tat Pedro. Xna'taj c'u ri tzij ri u bim ri Kajaw Jesús che: “C'ä mäjok cätzintzirikin ri ama' äc', cabij na at oxmul chi man awetam tä nu wäch,” —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Xel c'u apan ri tat Pedro chrij ri ja, xuq'uis rib che ok'ej. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ri achijab c'ut, ri e chajininak ri Jesús, cäquetz'bej u wäch, xukuje' cäquich'ayo. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Xquich'uk ru wak'äch, xquibij c'u che: ¡Chach'obo'! ¿Jachin ri' ri xatch'ayowic? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Q'uia ri mälom tak tzij ri xquibij che, sibalaj xquiyok'o. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Aretak xsakiric, xquimulij quib ri qui nimakil ri winak aj Israel, ri qui nimakil sacerdotes aj Israel, xukuje' ri tijonelab re ri Pixab. Xc'am bi ri Jesús chquiwäch. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Xquibij c'u che: ¿A lal ri' ri Cristo? Bij ba' la chke, —xecha che. Xch'aw chi ri Jesús, xubij chque: Pune ta ne quinbij chech alak, man cäcoj tä alak ri nu tzij, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","We ta c'u c'o jas quinta' chech alak, man cäbij tä alak chwe jas ri quinta' chech alak. Man quintzokopij tä bi alak, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Tzcämic ri', in ri' ri Ralc'ual ri Dios ri Kas Winak, quint'uyi na pu wiquiäk'ab ri Dios ri sibalaj c'o u chuk'ab, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Chanim c'ut xquita' che, xquibij conojel: ¿A lal ne lo ri' ru C'ojol ri Dios? —xecha che. Xch'aw chi ri Jesús, xubij chque: Je ri' jas ri cäbij alak chwe chi in ri', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Xquibij c'ut: ¿A cajwataj ta c'u lo jun k'alajisanel chic chkawäch? ¡Man rajwaxic taj! Ri uj c'ut, uj xujtow pu chi' jas ri cubij chbil rib, —xecha ri tata'ib. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Te c'u ri' xewalij conojel ri winak ri xquimulij quib. Xquic'am bi ri Jesús cho ri k'atal tzij Pilato. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Xquichaplej u banic tzij chrij ri Jesús, xquibij: Ka rikom chi we achi ri' tajin cusach qui c'ux ri winak, xukuje' xujutijoj chi man rajwaxic taj cäkaya alcabal che ri tat César. Cubij c'u chbil rib chi ri are', are ri Cristo, jun nim takanel. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Xuta' c'u ri tat Pilato che: ¿A at ri' ri cattakan pa qui wi' ri winak aj Israel? —xcha ri'. Xch'aw ri Jesús, xubij: Je ri' jas ri cäbij la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Xubij c'u ri tat Pilato chque ri qui nimakil sacerdotes, xukuje' chque ri niq'uiaj winak chic: Man c'o tä mac quinrik chrij we achi ri', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Co c'ut xquijiquiba u bixic wa' conojel, xquibij: Xa cusach qui c'ux ri winak, cuya tijonic pa ronojel tinimit rech Judea. Xuchaplej lok tijonic pa Galilea, u takem u banic wa', xul waral pa Jerusalén, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Aretak ri tat Pilato xuta wa', xuta' we ri achi ri' are aj Galilea. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Aretak xretamaj chi jela' quel wi lok ri Jesús jawije' cätakan wi ri tat Herodes, xutak bi ri Jesús cho ri are'. Ri tat Herodes c'o apan pa Jerusalén pa tak ri k'ij ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Aretak ri tat Herodes xril ri Jesús, sibalaj xquicotic. Xque' c'u q'uia k'ij u rayim rilic u wäch. Craj ta c'u na cäril jun cajmabal rumal ri Jesús, rumal chi q'uia tak tzijobelil u tom chrij. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ri tat Herodes sibalaj xuc'ot u chi' ri Jesús. Man c'o tä c'u jas xubij ri Jesús che. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ri qui nimakil sacerdotes aj Israel xukuje' ri tijonelab re ri Pixab sibalaj xquitzucuj jas cäca'n chubanic tzij chrij. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Are c'u ri tat Herodes xukuje' ru soldados xquetzelaj u wäch ri Jesús. Xquetz'bej c'u u wäch xukuje'. Xquicoj jun je'lalaj atz'iak che je' jas ri cucoj jun nim takanel. Te ri' ri tat Herodes xutak chi bi ri Jesús ruc' ri tat Pilato. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Xutzir c'u ri qui ch'oj ri tat Herodes ruc' ri tat Pilato pa we k'ij ri'. Xjunamataj c'u qui wäch. Xebux cachi'l quib. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Te ri' ri tat Pilato xeusiq'uij ri qui nimakil sacerdotes, ri qui nimakil ri winak, xukuje' conojel ri winak rech cäquimulij quib chuwäch. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Xubij c'u chque: Ri ix, i c'amom lok ri achi ri' chnuwäch. Xibij chi xa cusach qui c'ux ri winak. Aretak xinc'ot u chi' chiwäch, man c'o tä mac xinrik chrij we achi ri' jas ri quibij ix. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Xukuje' ri tat Herodes man xurik tä mac chrij. U takom chi c'u lok kuc'. Chiwilampe' chi man c'o tä jas u banom we achi ri' ri takal u cämisaxic. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Quinc'äjisaj ba' u wäch. Te c'u ri' quintzokopij bic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ri k'atal tzij, jas ri qui nak'atisam wi ri winak, ronojel nimak'ij rajwaxic cutzokopij bi jun ajpache'. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Conojel ri winak juntir xquirak qui chi', xquibij: ¡Chesaj la bi wa'! ¡Tzokopij ba' la ri tat Barrabás chke! —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Are c'u ri tat Barrabás c'o pa che' rumal chi u cämisam jun winak, xukuje' xeumulij ri winak re ri tinimit rech cäquiyac quib chrij ri k'atal tzij. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ri tat Pilato xeuch'abej ri winak jumul chic. Are c'u ri are' craj cutzokopij ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ri winak xquirak qui chi' jumul chic, xquibij: ¡Chripok! ¡Chripok! —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Churox mul xubij chque: ¿Jas etzelal u banom wa' we achi ri'? Man c'o tä jun mac nu rikom chrij rech cäcämisaxic. Quinc'äjisaj ba' u wäch, quintzokopij c'u bic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ri winak c'ut xquicoj qui chuk'ab junam cuc' ri qui nimakil sacerdotes aj Israel. Sibalaj xquirak qui chi' chubixic chi cärip ri Jesús. Xecowinic, xech'acan che ri tat Pilato. Xyi' c'u chque jas ri xquirayij. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Te c'u ri' ri tat Pilato xuk'at tzij chi cäbantaj na jas ri xquita' che. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Xutzokopij c'u ri tata' ri xquita', are ri ajpache', ri achi cämisanel ri xeumulij ri winak re ri tinimit rech cäquiyac quib chrij ri k'atal tzij. Are c'u ri Jesús xujach pa qui k'ab. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Aretak tajin cäc'am bi ri Jesús churipic, xquichap apan jun achi aj Cirene, Simón u bi', ri petinak pa juyub. Xquiya c'u ri cruz chrij rech cutelej bic, cuterenej bi ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Xeteri c'u bic q'uialaj winak, xukuje' jujun tak ixokib ri cäquiq'uis quib che ok'ej, cäcok'ej u wäch ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Xutzolk'omij rib ri Jesús, xerilo, xubij c'u chque: Ixokib aj Jerusalén, —cächa'. Mok'ej chi alak nu wäch in, are c'u chok'ej ib alak, xukuje' cheok'ej alak qui wäch ri al alak, —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Copan c'u na ri k'ij aretak cäbixic: “Utz que ri chuchuib ri man quealc'ualan taj, ri man quecowin tä che alc'ualanic. Utz que ri chuchuib ri man c'o tä cal ri quetu'nic,” —cächa na. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Pa ri k'ij ri' cäquibij na ri winak chque ri nimak tak juyub: “Chixtzak lok pa ka wi',” —quecha na ri'. Xukuje' cäquibij chque ri juyub: “Chujich'uku,” —quecha na chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","We cäban wa' we c'äx ri' aretak räx ri che', ¿jas ta ne ri cäca'n na aretak chaki'j chic ri che'? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Xukuje' xequic'am bi ruc' ri Jesús quieb banal tak etzelal rech quecämisaxic. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Aretak xeopan pa ri c'olibal ri cojom U Bakil Jolomaj che ru bi', chila' xquirip wi ri Jesús, xukuje' ri quieb banal tak etzelal junam ruc', jun pu wiquiäk'ab, ri jun chic pu moxk'ab ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Xubij c'u ri Jesús: Tat, sacha la qui mac. Xa man cäquich'ob tä ri' jas ri tajin cäca'no, —xcha'. Ri soldados c'ut xquesaj qui suerte chrij ri ratz'iak ri Jesús, xquijach c'u wa' chquiwäch. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","E tac'atoj c'u ri winak, tajin queca'y che ri Jesús. Ri qui nimakil ri winak xquetz'bej u wäch, xquibij: Xuto' ri jule' winak chic. We kas tzij are ri Cristo ri cha'tal rumal ri Dios, chuto' ba' rib, —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Xukuje' ri soldados xquetz'bej u wäch. Xekeb ruc' ri Jesús, xquiya ch'äm vino chuwäch. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Xquibij che: ¡We at ri' ri cattakan pa qui wi' ri winak aj Israel chato' ba' awib! —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Cojom c'u jun tz'ibtalic puwi' ri cruz ri xrip wi ri Jesús. Are tz'ibam wa' pa qui ch'abal ri winak aj Israel, ri winak latinos, xukuje' ri winak griegos, cubij: ARE NIM TAKANEL PA QUI WI' RI WINAK AJ ISRAEL, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jun chque ri banal tak etzelal, ri e tzäyebam ruc', xuyok'o, xubij: We kas tzij lal ri' ri Cristo, chto' ib la. Chujto' la uj xukuje', —xcha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Xch'aw ri jun achi chic, xuyaj ri rachi'l. Xubij che: ¿A mat caxej awib at cho ri Dios, at c'ut junam tajin carik c'äx ruc'? ");
INSERT INTO qucTNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ri uj takal chke chi je' cäban wa' chke. Tajin cäkatoj u q'uexel ri ka'nom. Are c'u wa' we achi ri', man c'o tä etzelal u banom, —xcha che ri rachi'l. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Xubij che ri Jesús: Tat, chinnataj che la aretak cächaplej la takanic, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Xch'aw ri Jesús, xubij: Kas tzij ri quinbij chawe chi cämic ri' catc'oji na wuc' in pa ri je'lalaj c'olibal “paraíso” u bi', —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Craj pa ri cablajuj hora xk'ekumar ruwächulew c'ä pa ri urox hora re benak k'ij. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Xatin c'u ri k'ij, xukuje' xjisjob ri tasbal u pam ri nimalaj rachoch Dios. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Te ri' xurakakej u chi' ri Jesús, co xch'awic, xubij: ¡Tat! —xcha'. Quinjach ri wanima' pa k'ab la, —xcha'. U bim wa', xel ranima'. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Aretak ri qui nimal soldados xril ri xbantajic, xunimarisaj u k'ij ri Dios, xubij: Kas utzalaj achi wa' we achi ri', —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Conojel ri winak xquimulij quib che rilic. Aretak xquil ri xbantajic, xetzelejic, sibalaj quebisonic, quebok'ic. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Conojel ri etamaninak u wäch ri Jesús, xukuje' ri ixokib ri tereninak u lok pa Galilea xecanaj can chinaj che rilic ri xban che. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Te ri' xopan jun achi, José u bi'. Are jun chque ri qui nimakil ri winak, utzalaj achi c'u wa' ri jicom ranima'. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ri are' are aj Arimatea, jun tinimit re Judea. Are jun achi ri cu'l na u c'ux che reyexic ru takanic ri Dios pa qui wi' ri winak. Man xuc'ul tä c'u re ri are' ri ca'nom ri niq'uiaj qui nimakil ri winak chic. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Xopan c'u ri are' cho ri tat Pilato chuta'ic chi cäyi' ru cuerpo ri Jesús che. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Aretak xukajsaj, xubolk'otij pa jun manta. Xuya c'u pa jun mukubal ri mäja' c'o jun winak yo'm chupam. Ri mukubal ri' are jun pec c'otom cok cho ri abaj. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","We k'ij ri' are ri víspera wa' re ri Pascua. Xak jubik' craj chi cächaplex ri k'ij re uxlanem. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ri ixokib ri xeteri lok ruc' ri Jesús pa Galilea, xquiterenej bic, xquil ri mukubal. Xquilo jas ri xban can chuya'ic ri cäminak chupam. ");
INSERT INTO qucTNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Aretak xetzelej bi cho ja, xca'n u banic c'oc'alaj tak cunabal. Xeuxlan c'u pa ri k'ij re uxlanem, je' jas ri cubij ri Pixab. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Pa ri nabe k'ij re ri semana, sibalaj ak'ab xebe' ri ixokib, xeopan c'u chuchi' ri mukubal. Xquic'am bi ri c'oc'alaj tak cunabal ri ca'nom. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Xquirik ri abaj wolkotim chi apan jela' chuchi' ri mukubal. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Xeboc bic, man xquirik tä c'u ru cuerpo ri Kajaw Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Xquixej c'u quib, man xquirik taj jas cäca'no rumal ri xbantajic. Xak te'talic c'ut xetaq'ui quieb achijab chquinakaj, ri sibalaj cäjuluw ri catz'iak. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Xquixej c'u quib ri ixokib, xquipachba quib pulew. Xquibij c'u ri achijab chque: ¿Jas che quitzucuj ri c'aslic chquixol ri cäminakib? ");
INSERT INTO qucTNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Man c'o tä waral, xc'astaj bi ri', —quecha chque. Chna'taj chiwe jas ri xutzijoj can ri Jesús chiwe aretak c'ä c'o ri Are' pa Galilea, —quecha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Je' xubij wa' chiwe: “Rajwaxic chi ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak, quinjach na pa qui k'ab ajmaquib, quinrip na cho ri cruz, quinc'astaj c'u na bi chquixol ri cäminakib churox k'ij,” —xcha ri', —xecha chque ri ixokib. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Te c'u ri' xna'taj ru tzij ri Jesús chque ri ixokib. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Aretak tzelejem lok que, qui petic pa ri mukubal, xquitzijoj chque ri tijoxelab, xukuje' chque ri niq'uiaj cachi'l chic ronojel ri xquic'ulmaj. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ri xquitzijoj ri tzij ri' chque ri apóstoles, ru tako'n ri Jesús, e are' ri nan María Magdalena, ri nan Juana, ri nan María ru nan ri Jacobo, xukuje' ri jule' ixokib chic. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ri apóstoles man xquicoj tä ri qui tzij ri ixokib. Xel chquiwäch chi xak con tak tzij ri cäquibij. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pune ta ne je ri', ri tat Pedro xwalij bic. Xutic anim, xe' chuchi' ri mukubal. Xpachi'c, xca'y cok chupam. Xuwi ri manta xrilo. Xucajmaj c'u ri xc'ulmatajic. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Pa we k'ij ri' e benak pa ri be quieb chque ri tijoxelab. Benam que pa jun alaj tinimit, Emaús u bi'. Craj julajuj kilómetros u xol ruc' ri tinimit Jerusalén. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Cäquitzijobela quib chrij ri xbantaj pa Jerusalén. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tajin c'u cäquich'abej quib, cäquic'otola tak qui chi' aretak ri Jesús xurik bi rib cuc', xerachi'laj bi junam. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Xban c'ut chi man xquich'ob tä u wäch. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Xubij c'u chque: ¿Jas ri quitzijobela chbil tak iwib pa we be ri'? —cächa'. ¿Jas che quixbisonic? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jun chque ri achijab, Cleofas u bi', xch'awic, xubij che: ¿A xak lal jun oc'owel pa Jerusalén? Craj ne xak xuwi ri lal man etam tä la ri xbantaj jela' pa tak ri k'ij ri', —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Xubij c'u chque: ¿Jas ri' ri xbanic? —xcha ri Jesús chque. Xquibij che: Are ri xban che ri Jesús aj Nazaret. We achi ri' are jun k'alajisal re ru Lok' Pixab ri Dios, ri sibalaj c'o u chuk'ab ru tzij ri xukuje' cuban cajmabal. Nim c'u u banic cho ri Dios, xukuje' chquiwäch ri winak, —quecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Xjach c'u bic, xk'at tzij puwi' chi cäcämisaxic ri Are' cumal ri qui nimakil sacerdotes aj Israel, xukuje' cumal ri qui nimakil ri ka winak uj. ¡Xquirip c'u cho ri cruz! —quecha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Are c'u ri uj xkachomaj chi are wa' ri cutor na ri ka tinimit Israel. Ya xque' oxib k'ij cämic ri xban wa', —quecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Xkacajmaj c'ut jas ri xquitzijoj jujun tak ixokib chkaxol. Ak'ab xebe' chuchi' ru mukubal ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Man xquirik tä chi c'u ru cuerpo, —quecha'. Aretak xetzelej bic, xquitzijoj chke chi xequil ángeles ri xquibij chi xc'astaj bi ri Jesús, —quecha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Te ri' xebe' jujun chque ri kachi'l chuchi' ri mukubal, je' xquilo jas ri xquibij ri ixokib. Man xquil tä chi u wäch ri Jesús, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Te ri' xubij ri Jesús chque: ¡Ay, con tak achijab! ¡Man quixcojon tä che ri qui tzijom can ri ojer tak k'alajisal re ru Lok' Pixab ri Dios! ");
INSERT INTO qucTNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿A mat iwetam ix chi rajwaxic chi ri Cristo curik wa' we c'äx ri' c'ä mäjok cänimarisax u k'ij? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Xuchaplej c'u u k'alajisaxic chquiwäch ri u tzij ri mam Moisés xukuje' ri qui tzij ri ojer tak k'alajisal re ru Lok' Pixab ri Dios jas ri qui tz'ibam can chrij ri Cristo. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Xenakajin c'u che ri alaj tinimit jawije' e benam wi que. Ri Jesús xubano chi je' ta ne chi naj ri que' wi na, man xtaq'ui taj. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ri tijoxelab xquicoj qui chuk'ab rech cäcanaj can cuc', xquibij che: Canaj can la kuc'. Kajem c'u cuban ri k'ij, coc c'u na ri ak'ab, —xecha che. Xoc c'u bi ri Jesús, xcanaj can cuc'. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Aretak xt'uyi cuc' chi' ri mesa, xuc'am ri wa. Xutewchij, xupiro, xuya chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Te c'u ri' xyi' chque chi xecowinic xquich'ob u wäch. Xak te'talic c'ut xsach ri Jesús chquiwäch. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Xquibila c'u ri jun che ri jun chic: ¿A mat c'o jas xkana' pa kanima' aretak xujuch'abej pa ri be, aretak xuk'alajisaj ru Lok' Pixab ri Dios ri Tz'ibtalic chkawäch? —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Pa ri hora ri' xewalijic, xetzelej bi pa Jerusalén. Xequirika ri julajuj tijoxelab qui mulim quib xukuje' ri niq'uiaj cachi'l chic. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Xquibij c'u chque: Kas tzij xc'astaj ri Kajaw Jesús, u c'utum c'u rib chuwäch ri tat Simón, —xecha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Te ri' xquitzijoj ri xquic'ulmaj pa ri be, xukuje' xquitzijoj jas xquetamabej u wäch ri Jesús aretak xupir ri wa. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Aretak tajin cäquitzijobela quib chrij ri xquic'ulmaj, xuc'ut rib ri Jesús chquiwäch, xtaq'ui c'u chquixol. Xubij chque: Chuxlan ba' ri iwanima', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","¡Sibalaj c'u xquixej quib! Xquichomaj chi are jun xibinel ri tajin cäquilo. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Xubij c'u ri Jesús chque: ¿Jas che quixbirbit pa iwanima', cuban c'u quieb i c'ux? —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Chiwila ri wakan xukuje' ri nu k'ab chi kas in ri' ri Jesús. Chinina', chiniwila', —cächa'. Jun xibinel man c'o tä u tijal, man c'o tä c'u u bakil je' jas ri wech in ri quica'yej, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Aretak xubij wa' xuc'ut ru k'ab xukuje' ri rakan chquiwäch. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Cäcaj cäquicojo, cäcaj man cäquicoj taj rumal chi quicajmam quib. Jubik' quequicotic, jubik' c'u cäquixej quib. Xubij c'u ri Jesús chque: ¿A c'o waral jas quintijo? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Xquiya c'u jun ch'äkap bolom cär che. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Xuc'amo, xutij chquiwäch. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Xubij c'u chque: Aretak ri in xinc'oji iwuc', xintzijoj chiwe chi rajwaxic quebantaj conojel ri tz'ibam chwij pa ru Pixab ri ka mam Moisés, xukuje' ri tz'ibam cumal ri ojer tak k'alajisal re ru Lok' Pixab ri Dios, xukuje' pa tak ri salmos, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Te c'u ri' xuya chque chi xquich'ob na ri Tz'ibtalic. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Xubij chque: Je' tz'ibam wa' chi curik na c'äx ri Cristo, cäc'astaj c'u na bi chquixol ri cäminakib churox k'ij, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Xukuje' tz'ibam chi rajwaxic u tzijoxic ru Tzij ri Dios chque conojel tinimit pa ri u bi' ri Cristo chubixic chque chi rajwaxic cäquiq'uex canima', cäquiq'uex c'u qui chomanic ri winak rech quesachtaj na ri qui mac. Are cächapletaj na bi u tzijoxic wa' pa ri tinimit Jerusalén, —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ri ix c'ut, ix k'alajisanelab chrij ronojel wa' we ri'. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Quintaka na lok pi wi' jas ri xubij ri Dios ri nu Tat chi cuya na chiwe. Chixcanaj ba' can pa ri tinimit Jerusalén c'ä cäyi' na chiwe ri i chuk'ab ajchicaj. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Te c'u ri' ri Jesús xeuc'am bi apan chrij ri tinimit Betania. Chila' xuwalijisaj ru k'ab, xeutewchij. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Aretak tajin queutewchij, xel bi chquiwäch, xc'am bi chicaj. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Xnimarisax na u k'ij cumal chila'. Te ri' xetzelej lok pa Jerusalén, sibalaj c'u quequicotic. ");
INSERT INTO qucTNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Amak'el ronojel k'ij e c'o pa ri nimalaj rachoch Dios, tajin cäquiya c'u u k'ij ri Dios. Amén.");
INSERT INTO qucTNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Aretak mäjok cäban ri cajulew, ri Cristo, ri cäbix “u Tzij ri Dios” che, ya c'o chic ri Are'. Ri Are' ri cäbix “u Tzij ri Dios” che c'o chic ruc' ri Dios, are c'u kas Dios wa'. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ri Are' c'ut c'o ruc' ri Dios ojer tzaretak xchaptaj lok u banic ronojel. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Rumal ri Are' ri Dios xuban ronojel ri c'olic. Man c'o tä c'u jas ri c'olic ri mat xban rumal ri Are'. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ruc' ri Are' c'o wi ri kas c'aslemal ri man c'o tä u q'uisic. We c'aslemal ri' are wa' ri kas sakil chque conojel ri winak cho ruwächulew. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ri sakil ri' cäjuluw pa ri k'ekum, man cäcowin tä c'u ri k'ekum chusachic u wäch. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","C'o jun tata' ri xtak lok rumal ri Dios. Ri tata' ri' are Juan u bi'. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Xpe c'u ri are' chuk'alajisaxic ri sakil chquiwäch ri winak rech conojel quecojon ta che ri sakil rumal ri u tzij ri are'. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ri tat Juan man are tä ri sakil, xane xa takom lok rech cuk'alajisaj ri kas tzij chrij ri sakil. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ri kas sakil c'ut, ri cäjuluw pa qui wi' conojel ri winak, tajin cäpe cho ruwächulew. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ri Jun ri cäbix “u Tzij ri Dios” che c'o chic cho ruwächulew. Pune c'u rumal ri Are' ri Dios xuban ruwächulew, ri winak c'ut ri e c'o cho ruwächulew man kas xquich'ob tä u wäch. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Xopan pa ru tinimit, ru winakil c'ut man xquic'ulaj taj. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pune je ri' e c'o c'u jujun ri utz u c'ulaxic xca'no, xecojon che ri Are'. E are c'u tak wa' ri xyi' chque chi queboc che ralc'ual ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ri xecojonic, ri xeboc che ralc'ual ri Dios, man je' tä xban che calc'ualaxic jas ri calc'ual ri winak ri xak quil qui wäch rumal chi je wa' xquichomaj ri qui nan qui tat, o rumal ru rayibal jun winak. Xane ri Dios are ri kas qui Tat ri e are'. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ri Jun ri cäbix “u Tzij ri Dios” che xuban winak, xc'oji c'u chkaxol waral cho ruwächulew. Lok' xeril wi conojel winak, xubij c'u ri kas tzij chque. Xkil ri quelic, k'alaj chi kas are ru C'ojol ri ka Tat ri sibalaj nim u k'ij, ri xuwi wa' u C'ojol c'olic. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ri tat Juan xuk'alajisaj ri kas tzij chrij ri Are', xubij: Are wa' ri xinbij, chi ri Jun chic ri cäpe na, are nim na u k'ij chnuwäch in rumal chi ri Are' c'o chic aretak ri in mäja' quil nu wäch, —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Konojel ka c'amom ke ri nimalaj u k'inomal, ka rikom c'u tewchibal k'ij chi k'ij. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ri ka mam Moisés xutz'ibaj can ri Pixab ri xuya ri Dios che. Are c'u ri Jesucristo xuc'ut can chkawäch chi kas cujraj ri Dios, xuk'alajisaj ri kas tzij chkawäch. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Man c'o tä wi jun winak ilowinak u wäch ri Dios. Xane xak xuwi ru C'ojol ri Dios ri c'o ruc' ri ka Tat, ri xak xuwi wa' u C'ojol c'olic, are ri Are' xulk'alajisan chkawäch ru banic ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ri winak aj Israel pa Jerusalén xequitak bi sacerdotes xukuje' levitas ruc' ri tat Juan chuta'ic che jachin ri are'. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ri are' kas xuk'alajisaj chquiwäch chi sakil, xubij: Ri in, man in tä ri Cristo, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Xquita' chi c'u jumul che, xquibij: ¿Jachin c'u ri lal? ¿A lal ri' ri ka mam Elías ri k'alajisal re ru Lok' Pixab ri Dios? —xecha che. Ri tat Juan xubij: Man in tä ri', —xcha chque. Jumul chic xquita' che, xquibij: ¿A man lal c'u ri' ri k'alajisal u Tzij ri Dios ri cäbixic chi cäpe na? —xecha che. Ri are' xch'awic, xubij: Man in tä ri', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Xquibij c'u che: ¿Jachin c'u ri lal? Rajwaxic chi cuje'c, c'o jas ri que'kabij chque ri xujtakow lok. ¿Jas ri cäbij la chke chij ib la? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ri tat Juan xch'awic, xubij: In ri' ri jun ri co cäch'aw pa tak ri juyub ri cätz'inowic, cubij: “Chibana u banic ri nim be ri cäbin wi ri Kajaw, chibana jicom che,” —cächa'. Je' jas ri xubij lok ri ka mam Isaías ri k'alajisal re ru Lok' Pixab ri Dios, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ri achijab ri' ri xeopan ruc' ri tat Juan chuch'abexic, e are' qui tako'n ri tata'ib fariseos wa'. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Xquita' c'u che ri tat Juan: We ri lal, man lal tä ri' ri Cristo, man lal tä ri' ri ka mam Elías, man lal tä c'u ri' ri k'alajisal re ru Lok' Pixab ri Dios, ¿jas che cäban la kasna'? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ri tat Juan xubij chque: Ri in quinban kasna' ruc' joron. C'o c'u Jun chxol alak ri man etam tä alak u wäch ri Are'. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Are c'u wa' ri Jun ri teren lok chwij, pune nim c'u na u banic chnuwäch in. Man takal tä c'u chwe in quinquir ru c'amal u xajäb, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ronojel wa' we ri' xc'ulmataj pa Betábara ri c'o chrelbal k'ij che ri nima' Jordán jawije' ri tajin cuban wi kasna' ri tat Juan. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Chucab k'ij ri tat Juan xril ri Jesús tajin cänakajin lok ruc', xubij: ¡Chilampe alak! —cächa'. Are wa' ri Jun ri cäcämisax na cho ri Dios je' ta ne jun alaj chij che resaxic bi ri qui mac ri winak ri e c'o cho ruwächulew, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Chrij c'u ri Are' xintzijon wi aretak xinbij: Cäpe chi na Jun ri nim na u banic chnuwäch in. Je ri', rumal chi ri Are' ya c'o chic mäjok quil nu wäch in. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ri in xukuje' man wetam tä u wäch nabe, tajin c'u quinban qui kasna' ri winak rech conojel ri winak aj Israel cäquetamaj u wäch, —xcha ri tat Juan. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Xukuje' xubij ri tat Juan: Xinwil ri Lok'alaj Espíritu xkaj lok chicaj je' u banic jun palomäx, xcanaj c'u can puwi' ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ri in nabe man wetam taj jachin ri Are', ri Dios c'ut ri xintakowic chi quinban kasna' ruc' joron, are xubij chwe: “Jachin ri cawilo chi cäkaj ri Lok'alaj Espíritu puwi', cäcanajic, are ri' ri Jun ri cuban na kasna' ruc' ri Lok'alaj Espíritu,” —xcha chwe. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ri in wilom ri xuc'ulmaj, quink'alajisaj c'ut jas ri xinwilo chi are wa' ru C'ojol ri Dios, —xcha ri tat Juan chque ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Chucab k'ij ri tat Juan c'o chila' jumul chic e rachi'l quieb chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Aretak ri tat Juan xrilo chi tajin coc'ow ri Jesús, xubij: ¡Chiwilampe'! —cächa'. Are wa' ri Jun ri cäcämisax na cho ri Dios je' ta ne jun alaj chij, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ri quieb u tijoxelab ri tat Juan, aretak xquita ri xubij, xebe' ruc' ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ri Jesús xca'y can chrij, xrilo chi terenem ri Are' cumal ri quieb tijoxelab, xubij chque: ¿Jas tajin quitzucuj? —xcha'. Ri e are' xquibij che: Ajtij, ¿jawije' jekel wi la? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ri Jesús xch'awic, xubij chque: ¡Chixsajmpe'! Jo' ba', quiwila c'u na, —xcha ri' chque. Xebe' c'u ruc' ri Are', xquil na jawije' ri jekel wi. Chila' c'ut xecanaj wi can pa ri k'ij ri', rumal chi craj are ucaj hora ri' re ri benak k'ij. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jun c'u chque ri quieb achijab ri xquita ri xubij ri tat Juan, ri xebe' ruc' ri Jesús, are ri tat Andrés ri ratz ri tat Simón Pedro. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Xe' ri tat Andrés chanim chutzucuxic ri tat Simón ru chak', xubij c'u che: Xkarik ri Mesías, —xcha che. (Ri tzij ri' quel cubij “Cristo”.) ");
INSERT INTO qucTNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Te c'u ri' ri tat Andrés xuc'am bi ri tat Simón ruc' ri Jesús. Ri Jesús c'ut, aretak xrilo, xubij che: At ri' ri tat Simón ru c'ojol ri Jonás. Cefas chic cäbix na chawe (ri quel cubij Pedro), —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Chucab k'ij chic ri Jesús xuchomaj chi que' pa Galilea. Xurik c'u ri tat Felipe, xubij che: Tasa'j wuc', —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ri tat Felipe jela' cäpe wi pa ri tinimit Betsaida ri qui tinimit ri tat Andrés, ri tat Pedro. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ri tat Felipe xe' chutzucuxic ri tat Natanael, xubij che: Xkil u wäch ri achi ri c'o xutz'ibaj ri ka mam Moisés chrij pa tak ri wuj re ri Pixab, xukuje' ri c'o xquitz'ibaj ri k'alajisal tak re ru Lok' Pixab ri Dios chrij pa ri qui wuj. Are wa' ri Jesús ru c'ojol ri tat José aj Nazaret, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ri tat Natanael xubij che: ¿A c'o pu lo jun winak nim u banic ri cäpe pa Nazaret? —xcha che. Ri tat Felipe xubij che: Tasa'j ba', cawil c'u na at, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ri Jesús, aretak xrilo chi petinak ri tat Natanael, xubij: Xpe jun achi ri kas aj Israel, ri man c'o tä subunic pa ranima', —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Te ri' ri tat Natanael xuta' che ri Jesús: ¿Jas xban la che retamaxic nu wäch? —xcha che. Ri Jesús xubij che: Xatinwilo aretak mäja' catsiq'uix rumal ri tat Felipe, aretak at c'o chuxe' ri jun u che'al higos, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ri tat Natanael xubij che: Ajtij, lal ri' ri u C'ojol ri Dios, ri Nim Takanel pa qui wi' ri winak aj Israel, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ri Jesús xch'awic, xubij che: E ri at, ¿a cacoj wa' xa rumal chi xinbij chawe chi xatinwilo aretak ri at c'o chuxe' ru che'al higos? Cawil c'u na nimak tak cajmabal chuwäch wa' we ri', —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Xukuje' xubij ri Jesús: Kas tzij ri quinbij chiwe chi quiwil na ri caj jaktalic. Quiwil c'u na ri ángeles rech ri Dios quepaki'c, quexuli pa nu wi' in, in ri' ri Ralc'ual ri Dios ri Kas Winak, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Churox k'ij xban jun c'ulanem pa ri tinimit Caná re Galilea. Ru nan ri Jesús c'o pa ri c'ulanem. ");
INSERT INTO qucTNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Xukuje' ri Jesús e rachi'l ru tijoxelab xesiq'uix pa ri c'ulanem. ");
INSERT INTO qucTNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Xq'uis c'u ri vino. Xpe ru nan ri Jesús, xubij che ri Are': Man c'o tä chi vino, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ri Jesús c'ut xch'awic, xubij che: Nan, ¿jas che cabij wa' chwe in? Mäja' curik ri k'ij chwe, —xcha che ru nan. ");
INSERT INTO qucTNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Xubij c'u ru nan chque ri tajin quecojow ri vino: Chibana ronojel ri cubij na chiwe, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","C'o c'u wakib nimak tak k'ebal re abaj chila', c'olibal joron ri cäquicoj ri winak aj Israel che ch'ajbal quib aretak cäquesaj ri äwas chquij. Chquijujunal ri k'ebal cäquich'ij jumuch' o cien litros joron. ");
INSERT INTO qucTNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ri Jesús xubij chque ri tajin quepatänin chque ri winak: Nojisaj alak we k'ebal ri' che joron, —xcha chque. Xquichap c'u qui nojisaxic ri nimak tak k'ebal c'ä xenoj na. ");
INSERT INTO qucTNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Xubij c'u ri Jesús chque: Chesaj alak bi jubik', c'ama bi alak che ri c'amal be pa ri nimak'ij, —xcha chque. Je' c'u xca'no. ");
INSERT INTO qucTNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Aretak ri c'amal be pa ri nimak'ij xuna' ri joron ri q'uextajinak chi pa vino, man retam tä c'ut jawije' xe'c'am wi. Xak xuwi ri patäninelab c'o quetam chic che ri vino jawije' quesam wi bic. Ri c'amal be xusiq'uij ri ala (ri novio). ");
INSERT INTO qucTNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Xubij c'u che: Conojel ri winak are cäquicoj nabe ri utzalaj vino. Aretak c'ut e nojinak chi ri ula', te c'u ri' coc ri vino ri man kas tä pakal rajil. Are c'u ri at a c'olom can ri utzalaj vino rech c'ä te' coc wa' q'uisbal, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ri xuban ri Jesús pa Caná re Galilea, are wa' ri nabe cajmabal etal. Ruc' wa' xuc'utu chi sibalaj nim u k'ij ri Are'. Xecojon c'u ru tijoxelab che. ");
INSERT INTO qucTNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Te c'u ri' xel bi chila', xe' pa ri tinimit Capernaum, rachi'l ru nan, ru tijoxelab, xukuje' tak ru chak'. Xecanaj c'u na can quieb oxib k'ij chila'. ");
INSERT INTO qucTNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Xa jubik' craj man curik ri Pascua, jun chque ri qui nimak'ij ri winak aj Israel. Rumal ri' ri Jesús xe' pa ri tinimit Jerusalén. ");
INSERT INTO qucTNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Chila' pa ri nimalaj rachoch Dios xeurik ajc'ay tak wacäx, ajc'ay tak chij, xukuje' ajc'ay tak palomäx. Xukuje' xeurik ri q'uexel tak qui rajil ri winak t'uyut'oj pa tak ri qui tem. ");
INSERT INTO qucTNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ri Jesús aretak xeril wa', xuban u banic jun colob che u ch'ayibal, xuchaplej quesaxic bi conojel ri winak ri' pa ri nimalaj rachoch Dios, junam cuc' ri qui chij, ri qui wacäx. Xujabuj ri qui rajil ri q'uexel tak puak, xupakchij apan ri qui mesa. ");
INSERT INTO qucTNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Xubij chque ri ajc'ay tak palomäx: ¡Chesaj bi alak ronojel wa' waral! Mäban alak jun c'ayibal che ri rachoch ri nu Tat, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Are c'u ru tijoxelab, xna'taj chque ru Lok' Pixab ri Dios ri Tz'ibtalic, ri cubij: “Je' ta ne tajin cäc'at ri wanima' rumal ri u lok'al ri achoch la,” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Te ri' ri winak aj Israel xquita' che ri Jesús: ¿Jas etal cäc'ut la chkawäch rech cäkilo chi c'o takanic pa k'ab la chubanic ronojel wa'? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Xch'aw ri Jesús, xubij chque: We ta ri alak cäwulij alak ri nimalaj rachoch Dios ri', xa oxib k'ij quinsachi na chuyaquic wa' jumul chic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Xquibij c'u ri winak aj Israel che: Cawinak wakib junab xbeytaj u banic wa' we nimalaj rachoch Dios ri', te c'u ri' cäbij la chi xa choxib k'ij cäyac ta chi la jumul, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Are c'u ri nimalaj rachoch Dios ri xubij ri Jesús, are ru cuerpo ri Are'. ");
INSERT INTO qucTNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Rumal ri' aretak xc'astaj ri Jesús chquixol ri cäminakib, xna'taj wa' we tzij ri' ri xubij ri Jesús chque ru tijoxelab, xquicoj c'ut ri cubij ru Lok' Pixab ri Dios ri Tz'ibtalic, xukuje' xecojon che ru tzij ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Aretak ri Jesús xc'oji pa Jerusalén pa ri nimak'ij re ri Pascua, e q'uia xecojon che aretak xquil ri cajmabal tak etal ri xubano. ");
INSERT INTO qucTNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ri Jesús c'ut man xcu'bi tä u c'ux chquij rumal chi ri Are' retam ri c'o pa canima' conojel winak. ");
INSERT INTO qucTNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Man rajwaxic taj chi c'o jachin jun cäbin che ri cäquichomaj ri winak rumal chi ri Are' retam ri c'o pa tak ri canima'. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","C'o jun tata' fariseo, Nicodemo u bi'. Ri tata' ri' nim u banic chquixol ri winak aj Israel. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ri tat Nicodemo xopan ruc' ri Jesús chak'ab chuch'abexic, xubij che: Ajtij, —xcha che. Ketam chi are ri Dios takowinak la lok che ka tijoxic rumal chi man c'o tä jun cäcowin chuc'utic ri u chuk'ab cuc' cajmabal tak etal jas ri tajin cäban la we ta mat c'o ri Dios ruc', —xcha che ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Te ri' ri Jesús xubij che: Kas tzij quinbij che la chi we jun winak man quil chi na u wäch jumul chic, man cuya' taj que'rila' jawije' ri cätakan wi ri Dios, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ri tat Nicodemo xuta' che, xubij: ¿Jas ta c'u lo cuban jun achi ri ri'j chic rech quil chi na u wäch jumul chic? ¿A cäcowin ta c'u lo coc ri are' jumul chic chupam ru nan rech quil chi na u wäch chucamul? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ri Jesús xch'awic, xubij che: Kas tzij quinbij che la chi ri winak ri man quil tä na u wäch ruc' joron, xukuje' ruc' ri Lok'alaj Espíritu, man cuya' taj copan chila' jawije' ri cätakan wi ri Dios, —cächa che. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ri winak ri calc'ualax cumal ru nan u tat, xak winak ri'. Are c'u ri winak ri calc'ualax rumal ri Lok'alaj Espíritu, ralc'ual ri Dios ri'. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mäcajmaj ba' la chi quinbij che la: “Rajwaxic chi quil chi na u wäch jun winak jumul chic,” —cächa che. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Je' jas ri quiäkik' xa apawije' cäjich'ich' wi, cätataj ru jininem, man k'alaj tä c'ut jawije' ri cäpe wi, o jawije' ri que' wi. Are c'u je ri' ri winak ri quil u wäch rumal ri Lok'alaj Espíritu, —xcha ri Jesús che. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ri tat Nicodemo xuta' chi jumul che ri Jesús, xubij: ¿Jas c'u ru banic wa'? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ri Jesús xch'awic, xubij che: Ri lal, lal jun nimalaj ajtij pa Israel. ¿A mat cäch'ob la wa' ri tajin quinbij? —cächa che. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kas tzij quinbij che la, chi ri uj cäkabij ri ketam, cäkak'alajisaj c'u ri kilom. Are c'u ri alak man cäcoj tä alak ri cäkabij chech alak. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","We man cäcoj alak ri quinbij chrij ri cäc'ulmataj waral cho ruwächulew, ¿a are ta c'u lo cäcoj alak ri' we quintzijon chrij ri cäc'ulmataj pa ri caj? —cächa che. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Man c'o tä jun winak pakalinak bi chila' chicaj, xane xak xuwi ri kajinak lok chicaj. Are c'u ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak, —cächa ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Jas ri xbantaj pa ri juyub ri cätz'inowic aretak ri ka mam Moisés xuyac ri jun cumätz re ch'ich' bronce puwi' jun che' chquiwäch ri winak, je c'u ri' cäban na chwe in, in ri' ri Ralc'ual ri Dios ri Kas Winak. Quinyac na in chquiwäch ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Je ri' rech apachin ri cäcojon chwe in man cäsach tä u wäch, xane curik ri c'aslemal ri man c'o tä u q'uisic, —xcha ri Jesús che ri tat Nicodemo. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ri Dios c'ut sibalaj queraj ri winak cho ruwächulew chi xusipaj lok ru C'ojol ri xak xuwi wa' u C'ojol c'olic, rech apachin ri cäcojon che ri Are' man cäsach tä u wäch, xane curik ri c'aslemal ri man c'o tä u q'uisic. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ri Dios man xutak tä lok ru C'ojol cho ruwächulew chuk'atic tzij pa qui wi' ri winak chi c'äjisaxic qui wäch, xane che qui to'ic. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Jachin ri cäcojon che ru C'ojol ri Dios, man cäk'at tä tzij puwi' chi cäc'äjisax u wäch. Jachin c'u ri man cäcojon tä che, ya k'atom chi tzij puwi' chi cäc'äjisax u wäch rumal chi man cäcojon tä che ru C'ojol ri Dios ri xak xuwi u C'ojol wa' c'olic. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ri man quecojon taj k'atom chi tzij pa qui wi' chi cäc'äjisax qui wäch rumal chi aretak ri sakil xpe cho ruwächulew, ri winak are utz xquil wi ri k'ekum rumal chi man utz taj ri tajin cäca'no. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Conojel ri cäca'n etzelal cäquetzelaj u wäch ri sakil. Man cäcaj tä c'u quekeb cho ri sakil rumal chi man cäcaj taj chi cäk'alajin ri etzelal ri tajin cäca'no. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Jachin c'u tak ri cäca'n ri kas tzij, quekeb ri' cho ri sakil rech cäk'alajinic chi ronojel ri tajin cäca'no are wa' ri craj ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Te c'u ri' ri Jesús xel bi chila', xe' pa Judea junam cuc' ru tijoxelab. Naj c'ut xcanaj na chila' cuc' ri e are', xuban c'u kasna'. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ri tat Juan xukuje' tajin cuban kasna' pa Enón, chunakaj ri Salim, jawije' c'o wi q'uia joron. Xeopan ri winak ruc', xuban c'u qui kasna'. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Mäja' c'u coc ri tat Juan pa che' aretak xbantaj wa'. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Te ri' xchaptaj jun ch'oj chquixol ru tijoxelab ri tat Juan cuc' jujun aj Israel chrij ri resaxic ri äwas chquij. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Xe'quibij c'u che ri tat Juan: Ajtij, chilampe la chi ri Jun ri xc'oji uc' la chrelbal k'ij che ri nima' Jordán, ri Jun ri xk'alajisaj la chkawäch, ri Are' tajin cuban kasna' cämic, conojel c'u ri winak tajin quebe' ruc', —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ri tat Juan xubij chque: Man c'o tä jun winak c'o jas cäcowin chubanic, we man yo'm che rumal ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ri ix, kas xita ri' jas ri xinbij, chi man in taj ri Cristo, xane xa in takom lok nabe chuwäch ri Are'. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Pa jun c'ulanem, ri c'amowinak bi ri ali are ri ala. Are c'u ri rachi'l ri ala ri c'o chila' cutatabej ri ala cätzijonic, cäquicot c'u ruc' aretak cuto. Je c'u ri' ri in cämic sibalaj quinquicotic. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ri Are' rajwaxic are cänimar na u k'ij, are c'u ri in, rajwaxic chi nojim man nim tä chic quinil wi, —xcha ri tat Juan chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ri Jun ri cäpe chila' chicaj are c'o pa qui wi' conojel. Are c'u ri jun ri xak ajuwächulew, xuwi cutzijoj ri cäbantaj waral cho ruwächulew. Are c'u ri Jun ri cäpe chila' chicaj are c'o pa qui wi' conojel. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ri Are' c'ut, are cutzijoj ri rilom, ri u tom. Man c'o tä c'u jun cucojo jas ri cubij. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Jachin c'u ri cucojo, ruc' wa' cujiquiba u bixic chi ri Dios cubij ri kas tzij. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ri Jun ri takom lok rumal ri Dios, cutzijoj ru Tzij ri Dios, rumal chi ri Dios man xak tä jubik' ri Espíritu rech Are' u yo'm che. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ri Dios ka Tat lok' ru C'ojol chuwäch, u yo'm c'u ronojel pu k'ab. ");
INSERT INTO qucTNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Jachin ri cäcojon che ru C'ojol ri Dios c'o u c'aslemal ri man c'o tä u q'uisic. Jachin c'u ri man craj taj cäcojon che ru C'ojol ri Dios, man c'o tä u c'aslemal ri', xane ri nimalaj royowal ri Dios cäpe na puwi', cäc'äjisax c'u na u wäch. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ri tata'ib fariseos xquetamaj chi ri Jesús e q'uia na ru tijoxelab ri Are', xukuje' e q'uia na ri xban qui kasna' rumal ri Are' chuwäch ri xban qui kasna' rumal ri tat Juan. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Kas tzij c'ut, man are tä ri Jesús ri xbanow ri kasna', xane e are ru tijoxelab xebanowic. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Aretak ri Jesús xuta wa', ri tajin cäbixic, xel bi pa Judea, xtzelej chic pa Galilea. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Pa ru tzelejic c'ut rajwaxic chi coc'ow pa tak ri juyub re Samaria. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Xopan c'u pa jun tinimit re Samaria, Sicar u bi', chunakaj ri ulew ri u yo'm ri Jacob che rechbal ri José ru c'ojol. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Chila' c'ut c'o wi ri c'ua' ri cäbix “ru c'ua' ri Jacob” che. Ri Jesús cosinak chic che ri binem, xt'uyi chuchi' ri c'ua'. Xa c'u jubik' man curik ri niq'uiaj k'ij. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","E benak c'u ru tijoxelab pa ri tinimit chulok'ic ri cäquitijo, ");
INSERT INTO qucTNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","aretak xopan jun ixok aj Samaria chuchi' ri c'ua' chuc'amic u joron. Ri Jesús xubij che: Ya la jubik' nu joron, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Man cäquich'abej tä c'u quib ri winak aj Israel cuc' ri winak aj Samaria, rumal ri' ri ixok xubij che ri Jesús: ¿Jas che ri lal cäta' la joron la chwe in? Ri lal c'ut, lal aj Israel. Ri in, in aj Samaria, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ri Jesús xch'awic, xubij che: We ta etam la jas ri cusipaj ri Dios, xukuje' we ta etam la jachin ri in ri tajin quinta' nu joron che la, ri lal kas tzij cäta' la joron la ri' chwe in, quinya c'u na c'aslic joron che la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ri ixok xubij che: Tat, man c'o tä ne jas cäcoj la che resaxic ri joron, sibalaj naj c'ut kajinak ri c'ua'. ¿Jawije' ta c'u ne que'c'ama wi la ri c'aslic joron ri cäya la chwe? —cächa che. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ri Jacob ri ka mam ojer are yo'winak can wa' we c'ua' ri' chke, ri xresaj wi u joron ri are', ri ralc'ual, xukuje' ri xresaj wi qui joron ri rawaj. ¿A lal ta c'ut ri nim na banic la chuwäch ri are'? —xcha ri ixok che ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ri Jesús xch'awic, xubij che: Conojel ri cäquitij que we joron ri' cächaki'j chi na qui chi' jumul chic. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Jachin c'u ri cutij re ri joron ri quinya in, man c'o tä chi na jumul cächaki'j chi u chi'. Je ri', rumal chi ri joron ri quinya in che cäbulbut na pa ranima' je' jas jun u q'uiyibal ja' ri cuya c'aslemal ri man c'o tä u q'uisic, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ri ixok xubij che: Tat, ya la we ri joron ri' rech man cächaki'j tä chi nu chi', rech man rajwaxic tä chi quinpe chi waral chuc'amic nu joron, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ri Jesús xubij che: Oj ba' la, jesiq'uij la lok ri achajil la, cäpe chi c'u na la waral, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ri ixok xch'awic, xubij: Man c'o tä wachajil, —xcha che. Xubij c'u ri Jesús che: Tzij ri cäbij la chi man c'o tä achajil la. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","E job c'u ne ri achajil la e c'olinak. Are c'u ri jun ri c'o uc' la cämic, man are tä kas achajil la. Kas tzij ba' ri bim la, —xcha ri Jesús che ri ixok. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Aretak xuta ri ixok wa', xubij che ri Jesús: Tat, quinwilo chi lal jun k'alajisal re ru Lok' Pixab ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ri ka mam uj ojer, ri uj aj Samaria, xquik'ijilaj ri Dios waral pa we juyub ri'. Are c'u ri alak, ri alak aj Israel, cäbij alak chi pa ri tinimit Jerusalén rajwaxic cäk'ijilax wi ri Dios, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ri Jesús xch'awic, xubij: Nan, cojo ba' la ri quinbij chi copan na ri k'ij aretak ri alak cäk'ijilaj na alak ri ka Tat, man rajwaxic tä c'u na chi cäpe alak waral pa we juyub ri' o chi que' alak pa Jerusalén chuk'ijilaxic ri ka Tat, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ri alak, alak aj Samaria man kas etam alak jachin ri cäk'ijilaj alak. Are c'u ri uj ketam jachin ri cäkak'ijilaj, rumal chi ru tobanic ri Dios cäpetic cumal ri winak aj Israel. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Curik c'u na ri k'ij, are cämic c'ut, aretak ri winak ri kas tzij cäquik'ijilaj ri ka Tat, kas cäquik'ijilaj na ri Are' ruc' ru takanic ri Lok'alaj Espíritu pa canima'. Ri ka Tat c'ut, craj chi je' cäban wa' cumal ri winak ri quek'ijilan che. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ri Dios are Espíritu, jachin c'u tak ri quek'ijilan che, rajwaxic kas tzij cäquik'ijilaj na ruc' ru takanic ri Lok'alaj Espíritu pa canima'. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ri ixok xubij che: Ri in wetam chi cäpe na ri Mesías ri xukuje' cäbix Cristo che. Aretak cäpe ri Are', cuk'alajisaj na ronojel chkawäch, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ri Jesús xubij che: In ri', ri tajin quintzijon uc' la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Kas je' tajin cubij wa' ri Jesús aretak xeopan ru tijoxelab. Xquicajmaj c'ut chi tajin cätzijon ruc' jun ixok. Man c'o tä c'u jun xucoch'o xuta' che ri Jesús jas ri craj ri ixok o jas ri tajin cubij che. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ri ixok c'ut xuya can ru k'ebal, xe' pa ri tinimit, xubij chque ri winak: ");
INSERT INTO qucTNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Chixsajmpe', jiliwila c'u jun achi ri u bim chwe ronojel ri nu banom. ¿A mat are wa' ri Cristo? —xcha chque ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Xebel c'u bi ri winak pa ri tinimit, xebe' jela' jawije' c'o wi ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Are c'u ri tijoxelab tajin cäquibij che ri Jesús: Ajtij, wok ba' la, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ri Jesús c'ut xubij chque: Ri in c'o ri nu wa ri quintijo ri man iwetam tä ix jasach, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ri tijoxelab xquichaplej u ta'ic chbil tak quib, xquibij: ¿A xa ta c'u lo c'o jachin xc'amow lok ri cutijo? —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ri Jesús xubij chque: Ri nu wa are ru banic ru rayibal ri Jun ri xintakow lok, ru q'uisic c'ut ru chaplem lok u banic. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ri ix quibij: “Craj na quiejeb ic' ri cosecha.” Ri in c'ut quinbij chiwe: Chica'yej tak ri tico'n, e chaki'j chi c'ut, e utz chic che ri cosecha. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ri cächacun pa ri cosecha, cäyi' na ri tojbal re. Are c'u ri cosecha ri cuyaco are re c'aslemal wa' ri man c'o tä u q'uisic, rech ri quetico'nijic, xukuje' ri queyacowic, junam quequicotic. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kas tzij c'ut ri cäbixic: “Jun winak cätico'nijic, are c'u jun winak chic ri cäyacowic,” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ri in xixintak bic rech quiyac u wäch ri tico'n ri man xirik tä c'äx chutiquic. Jule' winak chic ri xechacunic, are c'u ri ix xak xuwi quixquicot chuyaquic u wäch ri qui tico'n, —xcha chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","E q'uia c'u chque ri winak pa ri alaj tinimit ri' re Samaria ri xecojon che ri Jesús rumal ri xuban ri ixok, xujiquiba c'u u bixic chque: “U bim chwe ronojel ri nu banom,” —xcha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Je ri' chi aretak xeopan ri winak aj Samaria ruc' ri Jesús, xquibochi'j chi cäcanaj na can cuc'. Xcanaj c'u na can quieb k'ij cuc'. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","E q'uia c'u na ri xecojonic aretak xquita ri tzij ri xubij ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Xquibij c'u che ri ixok: Cämic cäkacojo, man xuwi tä rumal ri xabij at chke, xane rumal chi ka tom uj ri cubij. Ketam c'ut chi kas tzij are wa' ri Cristo ri To'l Que ri winak cho ruwächulew, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Churox k'ij ri Jesús xel bi pa Samaria, xutakej ru be, xe' pa Galilea. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Je ri', rumal chi jun k'alajisal re ru Lok' Pixab ri Dios man nim tä quil wi ri are' pa ri kas u tinimit je' jas ri xubij ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Aretak xopan pa Galilea ri winak chila' utz u c'ulaxic xca'no. Ri e are' c'ut e petinak pa ri nimak'ij Pascua ri cäban pa ri tinimit Jerusalén, quilom c'u ronojel ri u banom ri Are' chila' pa ri nimak'ij. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Te ri' ri Jesús xe' chi jumul pa ri tinimit Caná pa Galilea jawije' ri xuq'uex wi ri joron pa vino. C'o c'u jun tata' chila' ri nim u banic pa ri tinimit Capernaum. Jun to'l re ri nim takanel wa'. Yawab c'u ri u c'ojol. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Aretak ri tata' ri' xuto chi ri Jesús xpe pa Judea, xopan c'u pa Galilea, xe' ri are' che rilic. Xuta' tok'ob che chi que' cho rachoch chucunaxic ri u c'ojol, ri xa jubik' man cäcämic. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ri Jesús c'ut xubij che: Ri alak man cäcojon tä alak we ta mat quil alak cajmabal, xukuje' etal, —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Xubij c'u ri tata' ri nim u banic che: Tat, sa'j la chanim cho wachoch mäja' c'u cäcäm ri nu c'ojol, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Xubij c'u ri Jesús che: ¡Oj la cho ja, cäc'asi c'u na ri c'ojol la! —xcha che. Xucoj c'u ri tata' ri xbix che rumal ri Jesús, xe' c'ut. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Aretak xa jubik' man copan ri tata' cho rachoch, xepe ri patänil tak re chuc'ulaxic, xquibij c'u che: ¡C'asal ri c'ojol la! —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ri tata' xuta' chque jas hora xuchap rutziric ri u c'ojol. Ri e are' xquibij che: Iwir pa ri nabe hora re ri benak k'ij xel ri k'ak' chrij, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ru tat ri ala xuch'obo chi pa ri hora ri' xubij ri Jesús che: “Ri c'ojol la cäc'asi na,” —xcha ri Jesús. Xcojon c'u ri tata' che ri Jesús, xukuje' conojel ri e c'o pa rachoch. ");
INSERT INTO qucTNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Are wa' ri ucab cajmabal etal ri xuban ri Jesús aretak xtzelej lok pa Judea, xopan c'u pa Galilea. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Te c'u ri' ri winak aj Israel xca'n jun qui nimak'ij chic pa Jerusalén. Ri Jesús c'ut xe' chi na jumul jela'. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Pa ri tinimit Jerusalén chunakaj ri uchibe ri cäbix “Uchibe ri Queboc wi Chij” che, c'o jun atinibal ri cäbix Betesda che ru bi' pa ri ch'abal hebreo. E c'o job rakan ja chrij. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Pa tak ri rakan ja ri' e k'oyok'oj q'uia yawabib. E c'o moyab, ch'ocojib, xukuje' winak ri cäminak qui cuerpo. Tajin cäqueyej chi cäslab ri joron. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Jun tak pa' c'ut cäkaj lok jun ángel pa ri atinibal, cuslabisaj c'u ri joron. Jachin ri nabe cäkaj pa ri joron aretak cäslabtaj can rumal ri ángel cäcunataj che apachique u wäch yabil ri c'o che. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","C'o c'u jun achi chila' ri xque' juwinak lajuj ruc' wajxakib junab yawab. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Aretak ri Jesús xrilo k'oyol cho ri ulew, xukuje' xretamaj chi q'uia junab chic yawab, xuta' che: ¿A caj la cutzir la? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ri yawab xch'awic, xubij che: Tat, man c'o tä jun quinkasan pa ri atinibal aretak cäslab ri joron. Amak'el aretak cwaj quinkajic, jun chic cäkaj bi nabe chnuwäch in, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ri Jesús xubij che: ¡Walij ba' la, yaca la bi ri soc la, bin ya' la! —xcha ri Jesús che. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Chanim xutzir ri achi. Xuyac bi ru soc, xuchaplej binem. Are c'u k'ij re uxlanem aretak xbantaj wa'. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ri winak aj Israel xquibij che ri achi ri xutziric: Cämic c'ut are k'ij re uxlanem. Man ya'tal taj cawekaj bi ra soc, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ri achi xch'awic, xubij chque: Ri jun ri xincunanic xubij chwe: “¡Yaca la bi ri soc la, bin ya' la!” —xcha ri' chwe, —xcha ri achi chque ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ri e are' xquita' che, xquibij: ¿Jachin ri' ri xbin chawe: “¡Yaca la bi ri soc la, bin ya' la!”? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Are c'u ri achi man xuch'ob tä chi u wäch jachin ri xcunanic rumal chi ri Jesús xsach chquixol ri q'uialaj winak ri e c'o chila'. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Te ri' ri Jesús xurik ri achi pa ri nimalaj rachoch Dios, xubij che: ¡Chilampe la! —xcha'. Cämic ri lal utz chic. Mämacun chi ba' la, mäpe chi ne jun c'äx chic chij la ri más nim na, —xcha ri Jesús che. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Xe' c'u ri achi, xubij chque ri winak aj Israel chi ri xcunanic are ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Rumal ri' ri winak aj Israel xquitzucuj u chapic ri Jesús rech cäquicämisaj, rumal chi cuban tak wa' we ri' pa ri k'ij re uxlanem. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Xubij c'u ri Jesús chque: Ri nu Tat amak'el chacuninak petinak lok. Rajwaxic c'ut chi ri in xukuje' quinchacunic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Rumal ri' ri winak aj Israel xa sibalaj xpe na coyowal, xcaj xquicämisaj ri Jesús rumal chi man nim tä xril wi ri cubij ri Pixab chrij ri k'ij re uxlanem. Man xuwi tä c'u ri', xane xukuje' xujunamaj rib ruc' ri Dios aretak xubij chi ri Dios Are ru Tat. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Te ri' ri Jesús xubij chque: Kas tzij quinbij chech alak chi ri u C'ojol ri Dios man cäcowin taj c'o jas cubano xak pa re wi. Xuwi cubano jachique ri cärilo chi cuban ri u Tat. Ronojel ri cuban ri u Tat, cuban c'u ri u C'ojol xukuje'. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ri ka Tat sibalaj lok' ri u C'ojol chuwäch, cuc'ut c'u chuwäch jachique ri cuban ri Are'. Cuc'ut c'u na nimak tak cajmabal chuwäch ru C'ojol, ri sibalaj cäcajmaj na alak. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Je' jas ri ka Tat queuc'astajisaj ri cäminakib, cuya c'u qui c'aslemal, je ri' xukuje' ri u C'ojol cuya c'aslemal chque jachin tak ri craj cuya wi. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ri ka Tat man cuk'at tä tzij puwi' jachin jun, xane u yo'm ronojel u wäch takanic pu k'ab ru C'ojol rech ri Are' cäk'atow tzij. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Je ri' rech conojel ri winak cäquiya u k'ij ri u C'ojol ri Dios junam jas ri cäca'n chuya'ic u k'ij ri ka Tat. Jachin ri man cuya tä u k'ij ri u C'ojol ri Dios, man cuya tä ri' u k'ij ri ka Tat ri xutak lok ri Are'. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Kas tzij quinbij chech alak chi jachin ri cutatabej ri nu tzij, cäcojon c'u che ri Dios ri xintakow lok, curik na ri' ri c'aslemal ri man c'o tä u q'uisic. Man cäk'at tä c'u tzij puwi' chi cäc'äjisax u wäch rumal chi elinak chic pa ri cämical re ri ojer c'aslemal, c'o chic ri kas u c'aslemal. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Kas tzij quinbij chech alak chi cäpe na ri k'ij, cämic c'ut ri k'ij ri' aretak ri cäminakib cäquita na chi quinch'awic, in ri' ri u C'ojol ri Dios. Jachin tak ri cäquinimaj ri quinbij quec'asi na. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ri ka Tat c'o cuinem pu k'ab pa re wi chuya'ic c'aslemal, xukuje' u yo'm pa nu k'ab in, in ri' ri u C'ojol, chi quincowinic quinya c'aslemal. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Xukuje' u yo'm takanic pa nu k'ab rech quink'at tzij rumal chi ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mäcajmaj alak wa' rumal chi copan na ri k'ij aretak conojel ri cäminakib cäquita na chi quinch'awic. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Quebel na lok pa tak ri mukubal. Ri ca'nom ri utzil quec'astajic rech cäc'oji na qui c'aslemal. Are c'u ri ca'nom ri man utz taj quec'astajic rech cäk'at na tzij pa qui wi' chi cäc'äjisax na qui wäch. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ri in man c'o tä jas quincowin chubanic xak pa we wi. Ri in quink'at tzij xa jas ri quintak wi. Jicom c'u quinban in chuk'atic tzij. Man are tä c'u quinban xa jas ri cwaj in, xane are quinban jas ri craj ri nu Tat ri xintakow lok. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","We ri in quink'alajisaj ri kas tzij chwij chbil wib, man c'o tä u patän ri' ri quinbij. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","C'o c'u Jun chic ri c'o jas cuk'alajisaj chwij, wetam c'ut chi ri cubij ri Are' chwij are kas tzij. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ri alak xtak alak u ta'ic che ri tat Juan. Ri xubij c'u ri are' chech alak are kas tzij. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ri in c'ut man are tä cu'l nu c'ux chrij ri cuk'alajisaj jun winak chwij. Xuwi quinbij wa' rech ri alak cärik na alak ru tobanic ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ri tat Juan are junam ruc' jun chäj o jun candela ri cäc'atic, ri cäjuluwic. Ri alak c'ut xquicot alak quieb oxib k'ij ruc' ri sakil ri'. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","C'o c'u na ri cäc'utuwic chi kas tzij ri quinbij. Are utz na wa' chuwäch ri xuk'alajisaj ri tat Juan chwij. Ri tajin quinbano, are wa' ri xinutak ri nu Tat chubanic. Are c'u wa' ri cäc'utuwic chi kas tzij are ri nu Tat ri in takowinak lok. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Xukuje' ri nu Tat ri xintakow lok cuk'alajisaj ri kas tzij chwij, pune ta ne ri alak man tom tä alak ri Are' cäch'awic, man ilom tä c'u alak u wäch. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Man kajinak tä c'u ru Tzij ri Dios pa anima' alak rumal chi man cäcojon tä alak che ri Jun ri takom lok rumal ri ka Tat. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ri alak na'l cäsiq'uij alak u wäch ru Lok' Pixab ri Dios ri Tz'ibtalic rumal chi cächomaj alak chi chila' cärik wi alak ri cäyo'w ri c'aslemal ri man c'o tä u q'uisic. Are c'u ru Lok' Pixab ri Dios ri Tz'ibtalic ri cuk'alajisaj ri kas tzij chwij in. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pune je ri', ri alak man caj tä alak cäpe alak wuc' rech cärik alak we c'aslemal ri' ri man c'o tä u q'uisic. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ri in man cwaj taj chi cäyi' nu k'ij cumal ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Wetam c'u in ri anima' alak, wetam chi man caj tä alak ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ri in, in petinak chuq'uexwäch ri nu Tat. Ri alak c'ut man xinc'ulaj tä alak. Are c'u we ta cäpe jachin jun chic xak pa re wi, ¡are ri are' cäc'ulaj na alak! ");
INSERT INTO qucTNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿A cäcowin lo alak ri' cäcojon alak chwe we xa cätzucuj alak u ya'ic k'ij alak chbil tak ib alak, man are tä cätzucuj alak chi cäyi' k'ij alak rumal ri Dios ri xak xuwi Dios wa' c'olic? ");
INSERT INTO qucTNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mächomaj alak chi ri in quinchap u bixic ri man utz taj chij alak cho ri nu Tat. Ri cäbin na wa' chij alak are ri ka mam Moisés, ri cu'bam c'ux alak chrij. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","We ta ri alak kas xcojon alak che ri xubij ri ka mam Moisés, cäcojon ta c'u alak ri' chwe in rumal chi ri ka mam Moisés c'o ri u tz'ibam chwij in. ");
INSERT INTO qucTNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","We c'u man xcojon alak che ri xutz'ibaj ri are', ¿jas ta c'u lo cäban alak chucojic ri quinbij in? —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Te c'u ri' ri Jesús xk'ax ch'äkäp che ri mar ri cäbix “Mar re Galilea” che, ri xukuje' cäcoj “Mar re Tiberias” che ru bi'. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","E q'uia winak c'ut xeteri bi chrij ri Jesús rumal chi quilom ri cajmabal tak etal ri xubano aretak xeucunaj tak ri yawabib. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Te ri' xpaki ri Jesús puwi' jun juyub, chila' c'ut xt'uyi wi junam cuc' ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Xa c'u jubik' craj man curik ri nimak'ij ri cäbix “Pascua” che, jun chque ri qui nimak'ij ri winak aj Israel. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Aretak ri Jesús xeril ri q'uialaj winak ri e benak ruc', xubij che ri tat Felipe: ¿Jawije' ta ne quekalok' wi ri wa ri cäkaya chque ri q'uialaj winak ri'? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Xubij wa' ri Jesús xa rech cärilo jas cubij ri tat Felipe. Kas retam c'u ri Are' jas ri cuban na. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Xch'aw c'u ri tat Felipe, xubij: Quieb cientos quetzales caxlan wa man cuban tä ri' rech c'o ju tak bik' que conojel chquijujunal, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Are c'u ri tat Andrés, ratz ri tat Simón Pedro, jun chque ru tijoxelab ri Jesús, xubij che: ");
INSERT INTO qucTNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Waral c'o wi jun ala ruc'am job caxlan wa re cebada ruc' quieb cär. ¿Jas ta c'u lo u patän wa' che qui tzukic ri q'uialaj winak ri e c'olic? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Xubij c'u ri Jesús chque ru tijoxelab: Chibij chque conojel ri winak chi quet'uyi'c, —xcha chque. Sibalaj q'uia c'u ri räx k'ayes c'o cho ri juyub ri', xet'uyi c'ut. Craj e c'o job mil achijab. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Te ri' ri Jesús xeuc'am ri caxlan wa. Aretak xetewchitaj wa' rumal, xeuya chque ru tijoxelab, ri tijoxelab chic xequijach wa' chquiwäch conojel ri winak ri e t'uyut'oj. Xukuje' je' xuban chque ri cär, xeuya chque jampa' ri xcaj. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Aretak e nojinak chic, ri Jesús xubij chque ru tijoxelab: Cheiyaca ri ch'äkatak ri xecanaj canok rech man xak tä quebe' pa mes, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Xequiyac c'ut, xequinojisaj cablajuj chicäch cuc' ri ch'äkatak ri xecanaj can chque ri job caxlan wa re cebada. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ri winak, aretak xquil we cajmabal etal ri' ri xuban ri Jesús, xquibij: Kas tzij are wa' ri k'alajisal re ru Lok' Pixab ri Dios ri cäbixic chi cäpe na cho ruwächulew, —xecha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ri Jesús c'ut xrilo chi cäcaj cäquicoj qui chuk'ab chuc'amic bic rech cäquicoj che nim takanel pa qui wi', rumal c'u ri' xa xel bi chquiwäch, xe' chi jumul puwi' ri juyub rech cäc'oji chila' u tuquiel. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Aretak chak'ab chic, ru tijoxelab ri Jesús xekaj bi chuchi' ri mar. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Xeboc c'u pa jun barco, xquichaplej binem puwi' ri mar rech quek'ax pa Capernaum. Sibalaj k'ekum chic, ri Jesús c'ut mäja' cätzelej lok pa ri juyub. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Xak te'talic xpe jun nimalaj quiäkik'. Xewalij c'u nimak tak uwoja' puwi' ri mar rumal. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Aretak qui binibem chi job o wakib kilómetros, xquil ri Jesús petinak tajin cäbin puwi' ri ja'. Nakaj chic c'o wi che ri barco, xquixej c'u quib che. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Are c'u ri Jesús xubij chque: ¡In ri', mixej ba' iwib! —xcha ri' chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Te ri' ri e are' xequicotic, xquibij che ri Jesús chi cäpaki cuc' pa ri barco. Chanim c'ut xeopan pa ri tinimit jawije' ri benam wi que. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Chucab k'ij ri winak ri xecanaj can ch'äkäp che ri mar xquilo chi ri tijoxelab xebe' pa ri jun barco ri xuwi barco wa' c'o chila', man xe' tä c'u ri Jesús cuc'. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Xurika c'ut chi xeopan niq'uiaj barcos chic ri qui petic pa ri tinimit Tiberias. Xeopan chila' chunakaj ri uwosak jawije' ri winak xquitij wi ri caxlan wa aretak xmaltioxitaj wa' rumal ri Kajaw Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Je ri' chi ri winak aretak xquilo chi man c'o tä chi ri Jesús chila', xukuje' chi man e c'o tä chi ru tijoxelab, xeboc pa tak ri barcos, xebe' c'u pa ri tinimit Capernaum chutzucuxic ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Aretak ri winak xeopan ch'äkäp che ri mar, xquirik ri Jesús, xquita' c'u che, xquibij: Ajtij, ¿jampa' xul la waral? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Xubij c'u ri Jesús chque: Kas tzij ri quinbij chech alak chi ri alak quintzucuj alak xa rumal chi xwi' alak, xnoj c'u alak. Man quintzucuj tä alak rumal chi cäch'ob alak u beyal ri cajmabal tak etal ri quinbano. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Moc il alak chutzucuxic ri wa ri xa cäsach u wäch, xane are rajwaxic chi coc il alak chutzucuxic ri wa ri man cäsach tä u wäch, ri cuya chech alak ri kas c'aslemal ri man c'o tä u q'uisic. Are wa' ri wa ri quinya na in chech alak, in ri' ri Ralc'ual ri Dios ri Kas Winak. Rumal wa' u c'utum ri Dios ka Tat chi ruc' Are' in petinak wi, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Te ri' ri winak xquita' che ri Jesús, xquibij: ¿Jas c'u ri' ri rajwaxic cäka'no rech cujcowinic cäka'no jachique ri craj ri Dios? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ri Jesús xch'awic, xubij chque: Ri craj ri Dios chi cäban alak are la' chi cäcojon alak che ri Jun ri u takom lok, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Xquita' chi che ri Jesús, xquibij che: ¿Jas u wäch etal cäban la chkawäch rech cäkilo, cujcojon c'u che la? ¿Jas ri cäcowin la chubanic? —quecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ri ka nan ka tat ojer xquitij ri maná pa ri juyub ri cätz'inowic, je' jas ri cubij ru Lok' Pixab ri Dios ri Tz'ibtalic: “Ri Dios xuya chutijic ri qui wa ri xpe chila' chicaj,” —xecha che ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Xch'aw c'u ri Jesús, xubij chque: Kas tzij ri quinbij chech alak chi man are tä ri ka mam Moisés ri xyo'w ri wa chque ri cäpe chila' chicaj, xane are ri nu Tat ri cäyo'w ri kas wa ri cäpe chila' chicaj. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ri wa ri cuya ri Dios are wa' ri kajinak lok chicaj, ri cuya ri kas c'aslemal chque conojel winak, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Xquibij c'u che ri Jesús: Tat, ya la ke ri wa ri' amak'el ronojel k'ij, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ri Jesús xubij chque: In ri' ri wa ri cuya ri kas c'aslemal. Jachin ri cäpe wuc', man c'o tä jumul ri cänum chic. Jachin ri cäcojon chwe man c'o tä jumul ri cächaki'j chi u chi'. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nu bim chi c'u chech alak chi ri alak man cäcojon tä alak chwe pune ilom alak nu wäch. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Conojel ri queyi' chwe rumal ri nu tat quepe na wuc' in. Apachin c'u ri quepe wuc' man queintzelejisaj tä bic. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ri in c'ut man xinpe tä chila' chicaj xa chubanic jachique ri cwaj in, xane chubanic ru rayibal ri xintakow lok. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ri u rayibal ri nu Tat ri xintakow lok are la' chi man c'o tä jun chque ri xeuya chwe ri quintzako, xane chi queinc'astajisaj na chquixol ri cäminakib pa ri q'uisbal k'ij. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ri u rayibal ri xintakow lok are la' chi conojel ri cäquil nu wäch in, in ri' ri u C'ojol ri Dios, quecojon c'u chwe, cäquirik ri c'aslemal ri man c'o tä u q'uisic. Queinc'astajisaj c'u na in chquixol ri cäminakib pa ri q'uisbal k'ij, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ri winak aj Israel, aretak xquita wa' we tzij ri', xquichap u bixic c'äx tak tzij chrij ri Jesús rumal ri xubij: “In ri' ri wa ri cäpe chila' chicaj,” —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Xquibij c'ut: ¿A mat are wa' ri Jesús ru c'ojol ri tat José? Ri uj ketam qui wäch ru nan u tat. ¿Jas lo wa' ri cubij chi petinak chila' chicaj? —xecha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Are c'u ri Jesús xubij chque: ¡Tanal alak che ri yok'onic! —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Man c'o tä jun ri cuya' cäpe wuc' in we ta mat cäc'am lok rumal ri nu Tat ri xintakow lok. Ri in c'ut quinc'astajisaj na chquixol ri cäminakib pa ri q'uisbal k'ij, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Cubij pa tak ri wuj ri xquitz'ibaj ri k'alajisal tak re ru Lok' Pixab ojer: “Ri Dios cuya na tijonic chque conojel,” —cächa ri'. Rumal ri' conojel ri cäquitatabej ri cubij ri ka Tat, c'o c'u ri cäquetamaj na ruc', quepe na ri e are' wuc' in, —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Are kas tzij chi man c'o tä jun winak ilowinak u wäch ri ka Tat. Ri Jun ri ilowinak u wäch are xak xuwi ri petinak ruc' ri Dios, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Kas tzij ri quinbij chech alak chi jachin ri cäcojon chwe in c'o na ru c'aslemal ri man c'o tä u q'uisic. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","In ri' ri wa ri kas cuya c'aslemal, —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ri nan tat alak ojer xquitij ri wa ri cäbix “maná” che pa ri juyub ri cätz'inowic, conojel c'ut xecämic. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Are c'u ri in tajin quintzijoj chech alak jas ri' ri kas wa ri petinak chila' chicaj. Jachin c'u ri cutij re we wa ri', man cäcäm tä ri', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","In c'u ri' ri c'aslic wa, ri kajinak lok chicaj. Jachin ri cutij re we wa ri', cäc'asi na pa tak ri k'ij ri junab ri quepetic. Ri wa ri quinya in are ri nu cuerpo. Quinya wa' rech c'o ri qui c'aslemal conojel winak cho ruwächulew, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ri winak aj Israel xquichaplej u tzijobexic quib chquixol, xquibij: ¿Jas ta c'u lo cuban we achi ri' chuya'ic ru tijal chke pa tijic? —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ri Jesús xubij chque: Kas tzij ri quinbij chech alak chi we ri alak man cätij tä alak ri nu cuerpo, in ri' ri Ralc'ual ri Dios ri Kas Winak, man cätij tä alak ri nu quiq'uel, te c'u ri' man cäc'oji tä na ri c'aslemal alak ri'. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Jachin ri cutij ri nu cuerpo xukuje' cutij ri nu quiq'uel, c'o c'u u c'aslemal ri man c'o tä u q'uisic. Ri in c'ut quinc'astajisaj na chquixol ri cäminakib pa ri q'uisbal k'ij. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ri nu cuerpo c'ut are ri kas wa, ri nu quiq'uel are kas je' jas ri vino ri cätijowic. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Jachin ri cutij ri nu cuerpo, xukuje' cutij ri nu quiq'uel kas cäc'oji ri are' wuc' in, ri in xukuje' kas quinc'oji ruc' are'. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ri nu Tat ri xintakow lok c'o u c'aslemal. Ri in xukuje' in c'asal rumal ri Are'. Je ri' xukuje' jachin ri cutzuk rib chwe in, cäc'asi na wumal in. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Are tajin quintzijon chrij ri wa ri petinak chila' chicaj. We wa ri' man junam tä ruc' ri maná ri xquitij ri nan tat alak ojer, xecäm c'u ri e are'. Are c'u ri cutij re we wa ri' cäc'asi na pa tak ri k'ij ri junab ri quepetic, —xcha ri Jesús chque ri winak aj Israel. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ri Jesús xubij wa' we tzij ri' chque ri winak ri qui mulim quib pa ri rachoch Dios pa Capernaum che qui tijoxic. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Aretak xquita wa' we tijonic ri', e q'uia chque ri winak ri e c'o ruc' xquibij: Sibalaj c'äx wa' ri tzij ri xubij. ¿Jachin ta lo ri cäcowinic cutatabej? —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ri Jesús c'ut xretamaj chi c'äx tajin quech'aw chrij rumal ri tzij ri xubij, xuta' c'u chque: ¿A tzel cäta alak ri xinbij? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Jas c'u ri cäc'ulmataj ri' we ta quinil alak in, in ri' ri Ralc'ual ri Dios ri Kas Winak, quintzelejic quinpaki c'u chicaj jawije' ri in c'o wi nabe? ");
INSERT INTO qucTNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ri Lok'alaj Espíritu are ri cäyo'w ri c'aslemal. Ri cuerpo xak u tuquiel man c'o tä u patän. Ri tzij c'ut ri nu bim chech alak e are' kas tzij ri quepe ruc' ri Dios, xukuje' cäquiya c'aslemal. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","E c'o c'u jujun chech alak ri man quecojon taj, —xcha chque. Kas c'u retam ri Jesús petinak lok jachin tak ri man quecojon tä che, xukuje' jachin ri' ri cäjachow na. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Xubij c'ut: Rumal ri' nu bim chech alak chi man c'o tä jun ri cuya' cäpe wuc' in we ta mat cäc'am lok rumal ri nu Tat. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tzare chi' c'ut e q'uia chque ri e c'o ruc' ri Jesús xquiya canok, man xec'oji tä c'u ruc'. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Te ri' ri Jesús xuta' chque ri cablajuj u tijoxelab, xubij: ¿A quiwaj ix xukuje' quixe' cuc'? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Xch'aw c'u ri tat Simón Pedro, xubij: Kajaw, ¿jachin chi ruc' cuje' wi? Ri tzij la e are tzij ri cäquiya c'aslemal ri man c'o tä u q'uisic. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ri uj, uj cojoninak che la, ketam chi lal ri' ri Cristo, ru C'ojol ri c'aslic Dios, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ri Jesús xch'awic, xubij: ¿A mat ix cablajuj xixincha' rech quixc'oji wuc'? Pune je ri' jun chiwe are c'o ri Itzel pa ranima', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ri Jesús aretak xubij wa' are tajin cäch'aw chrij ri Judas Iscariote ru c'ojol ri tat Simón. Je ri', rumal chi ri tat Judas are ri cäjachow na, pune are jun chque ri cablajuj u tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Te c'u ri' ri Jesús xubinibej ri Galilea. Man craj taj cäc'oji pa Judea rumal chi ri winak aj Israel cäcaj cäquicämisaj. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Xa c'u jubik' craj man curik ri nimak'ij que ri Cäbal, jun chque ri qui nimak'ij ri winak aj Israel. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ru chak' ri Jesús xquibij che: Mat canaj waral. Jat pa Judea rech xukuje' ra tijoxelab ri e c'o chila' cäquil na ri cajmabal ri cabano. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","We jun winak craj chi kas quetamax u wäch, man cuban tä ri' chic'uyal ri cubano. We ri at caban tak ri cajmabal ri', chabana wa' chquiwäch conojel ri winak, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","K'alaj c'ut chi ru chak' ri Jesús xa man xecojon tä che. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Te ri' xubij ri Jesús chque: Ri in mäja' curik ri k'ij chwe, are c'u ri ix apachique k'ij utz chiwe cuya' quixe'c. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ri winak ajuwächulew man quecowin taj cäquetzelaj i wäch ix. Are c'u ri in cäquetzelaj nu wäch rumal chi quink'alajisaj chquiwäch chi man utz tä ri cäca'no. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ri ix c'ut, jix pa ri nimak'ij. Ri in man quine' taj, rumal chi mäja' curik ri k'ij chwe. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Aretak xbitaj wa' we tzij ri' chque, xcanaj ri Are' pa Galilea. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Aretak c'ut e benak chi ru chak' ri Jesús pa ri nimak'ij, ri Are' xukuje' xe' na pa ri nimak'ij, pune man xuc'ut tä rib chquiwäch ri winak. Xane xak chic'uyal xe' ri Are'. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ri winak aj Israel xquitij u tzucuxic pa ri nimak'ij, xquibij: ¿Jawije' c'o wi ri achi ri'? —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Chquixol c'u ri winak, q'uia ri cäbix chrij ri Jesús. Jujun cäquibij: “Are jun utzalaj achi,” —quecha'. Niq'uiaj chic cäquibij: “Man are tä utzalaj achi, rumal chi queusub ri winak,” —quecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Man c'o tä c'u jun ri cucoch'o cäresaj u tzijol ri Jesús rumal chi cäquixej quib chquiwäch ri qui nimakil ri winak aj Israel. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Niq'uiajirinak chi c'u ri nimak'ij aretak ri Jesús xoc bi pa ri nimalaj rachoch Dios, xuchaplej c'u qui tijoxic ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Are c'u ri winak aj Israel sibalaj tajin cäquicajmaj wa', xquibij: ¿Jas lo wa' chi sibalaj q'uia retam we achi ri', man c'o tä c'u jawije' u tijom wi rib? —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ri Jesús xch'awic, xubij chque: Ri tijonic ri quinya man wech tä in, xane rech ri Jun ri xintakow lok. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","We c'o jun kas curayij u banic ri craj ri Dios, cäretamaj na we ri nu tijonic kas cäpe ruc' ri Dios, o xak pa we wi quintzijonic. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ri winak ri xak pa re wi cätzijonic, xa are craj ri' chi cänimarisax u k'ij cumal ri winak. Jachin c'u ri craj chi are cänimarisax u k'ij ri xtakow lok, cubij ri' ri kas tzij, man are tä jun banal tzij, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿A mat kas tzij chi ri ka mam Moisés xuya ri Pixab chech alak? Pune je ri', man c'o tä c'u jun chech alak ri cunimaj ri Pixab ri'. ¿Jas che caj alak quincämisaj alak? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ri winak xech'awic, xquibij: ¡Xa c'o jun itzel espíritu chawe! ¿Jachin lo ri craj catcämisanic? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ri Jesús xubij chque: Xa ruc' jun cajmabal ri xinban pa ri k'ij re uxlanem, ri alak sibalaj cäcajman alak che. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ri ka mam Moisés xunak'atajisaj alak chucojic retal ri ojer trato. Pune ta ne man are tä ri are' xchapow lok u banic wa', xane are qui tijonic can ri nan tat alak ojer. Ri alak c'ut cäcoj alak retal ri ojer trato che jun alaj ala pune pa ri k'ij re uxlanem. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","We c'u ri alak rumal ri u nimaxic ri Pixab ri xutz'ibaj ri ka mam Moisés cäcoj alak retal ri ojer trato che ri ala pune pa ri k'ij re uxlanem, ¿jas c'u che xpe oyowal alak chwe in aretak xincunaj ronojel ru cuerpo jun achi pa ri k'ij re uxlanem? —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","C'o jas mäbij alak chrij ri winak we utz cäpetic o man utz tä cäpetic. Aretak c'o jas cäbij alak chrij jun winak chic, kas chomaj na alak jas ri cäban alak, bana c'u alak wa' ruc' jicomal. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Te c'u ri' jujun chque ri winak aj Jerusalén xquichapla u ta'ic, xquibij: ¿A mat are wa' we achi ri' ri tajin cätzucuxic rech cäcämisaxic? —quecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Chiwilampe', cätzijon cuc' ri winak, man c'o tä c'u jun c'o jas cubij che. ¿A xa ta c'u lo kas cäquicoj ri k'atal tak tzij chi we achi ri' are ri Cristo? —quecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ri uj c'ut ketam jawije' petinak wi wa' we achi ri'. Aretak c'ut cäpe ri' ri Cristo, man c'o tä jun ri' etamaninak jawije' cäpe wi, —xecha ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Aretak ri Jesús, ri tajin cuya tijonic pa ri nimalaj rachoch Dios, xuta wa' co xch'awic, xubij: Cäbij alak chi etam alak nu wäch, xukuje' chi etam alak jawije' chi' quinpe wi. Man in petinak tä c'ut xak pa we wi, xane in takom lok rumal ri Jun ri kas jicom ranima'. Ri alak c'ut man etam tä alak u wäch. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ri in wetam u wäch rumal chi in petinak ruc', xukuje' are ri Are' in takowinak lok, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Xcaj c'ut xquic'am bi pa che', man c'o tä c'u jun xchapowic rumal chi mäja' curik ru k'ij. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","E q'uia c'ut xecojon che, xquibij c'ut: Aretak cäpe ri Cristo, ¿a cuban ta c'u lo más cajmabal tak etal chic chuwäch ri u banom we achi ri'? —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ri tata'ib fariseos xquita ri cäquibij ri winak chrij ri Jesús. Xa je ri' ri e are' cuc' ri qui nimakil sacerdotes xequitak bi jujun chajinelab re ri nimalaj rachoch Dios chuc'amic bi ri Jesús pa che'. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Te ri' xubij ri Jesús: Xak quieb oxib k'ij chic quinc'oji na uc' alak, te c'u ri' quintzelej na ruc' ri xintakow lok. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ri alak quintzucuj na alak, man quinrik tä chi c'u alak rumal chi man cäcowin tä alak copan alak chila' jawije' ri quinec'ol wi in, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ri qui nimakil ri winak aj Israel c'ut, xquichaplej u ta'ic chbil tak quib, xquibij: ¿Jawije' ta c'u que' wi wa' we achi ri' chi man cujcowin tä uj quekarika'? ¿A xa ta c'u lo que' cuc' ri winak aj Israel ri e jabuninak chquixol ri winak aj Grecia che qui tijoxic ri winak aj Grecia? ");
INSERT INTO qucTNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Jas quel cubij wa' ri xubij chke: “Quintzucuj na alak, man quinrik tä chi c'u alak rumal chi man cäcowin tä alak copan alak chila' jawije' ri quinec'ol wi”? —xcha ri', —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Pa ri q'uisbal k'ij re ri nimak'ij, ri k'ij ri sibalaj nim na u banic, ri Jesús xtaq'ui ak'anok chquixol ri winak, co xch'awic, xubij: We c'o jun cächaki'j u chi', chpet wuc', chutija u joron. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Je' jas ri cubij ru Lok' Pixab ri Dios ri Tz'ibtalic: Jachin ri cäcojon chwe, cäq'uiy na lok pa ranima' joron ri cuya ri kas c'aslemal, —cächa', —xcha ri Jesús chque ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ri Jesús c'ut, are tajin cäch'aw chrij ri Lok'alaj Espíritu ri cäquic'am na ri winak ri quecojon che ri Are'. Mäja' c'u cäyi' lok ri Lok'alaj Espíritu rumal chi mäja' cätzelej ri Jesús chila' chicaj rech cänimarisax u k'ij. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jujun chque ri winak, aretak xquita ri xubij ri Jesús, xquibij: Kas tzij we achi ri' are wa' ri k'alajisal re ru Lok' Pixab ri Dios ri cäbixic chi cäpe na, —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Niq'uiaj chic xquibij: Are wa' ri Cristo, —xecha'. Niq'uiaj chi c'ut xquibij: ¿A xa ta c'u lo pa Galilea cäpe wi ri Cristo? ");
INSERT INTO qucTNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ru Lok' Pixab ri Dios ri Tz'ibtalic cubij chi ri Cristo rajwaxic chquixol ri rachalaxic ri ka mam David ri nim takanel cäpe wi na. Pa Belén c'ut cäpe wi na, ri tinimit ri xc'oji wi ri ka mam David, —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Je c'u ri' ri winak xquitasala quib rumal rech ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","E c'o jujun ri xcaj xquic'am bi pa che', man c'o tä c'u jun xchapowic. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Xetzelej c'u ri chajinelab re ri nimalaj rachoch Dios, xeopan chila' jawije' e c'o wi ri tata'ib fariseos xukuje' ri qui nimakil ri sacerdotes. Ri e are' c'ut xquita' chque: ¿Jas che man xic'am tä lok ri Jesús? —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ri chajinelab xech'awic, xquibij: ¡Man c'o tä jun achi ka tom je' cätzijonic jas ri cätzijon ri achi ri'! —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Are c'u ri tata'ib fariseos xquibij chque: Ri ix xukuje' xa xiya iwib pa subic. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿A c'o pu lo jun chque ri ka nimakil ri cojoninak che, o jun ne chque ri tata'ib fariseos? ¡Man c'o taj! —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Xquiq'uiäk itzel tzij pa qui wi', xquibij: ¡We winak ri' man quetam tä ri Pixab! —xecha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Are c'u ri tat Nicodemo ri xopan ruc' ri Jesús chak'ab, are jun chque ri tata'ib fariseos. Xubij c'u chque: ");
INSERT INTO qucTNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Ri ka Pixab cubij chi man cuya' taj cäkak'at tzij puwi' jun winak chi cäc'äjisax u wäch we ta mat nabe cäkata na jas ri cubij che retamaxic jas ri u banom, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Te ri' xech'aw ri e are', xquibij che ri tat Nicodemo: E c'u ri lal, ¿a lal aj Galilea xukuje'? —xecha che. Na'l siq'uij la ru Lok' Pixab ri Dios ri Tz'ibtalic, quil c'u na la chi man c'o tä jun k'alajisal re ru Lok' Pixab ri Dios ri petinak pa Galilea, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Chquijujunal c'ut xebe' cho tak cachoch. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Are c'u ri Jesús xe' pa ri nimalaj juyub ri cäbix “Olivos” che. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Aretak xsakir chucab k'ij, ri Jesús xtzelej lok, xe' pa ri nimalaj rachoch Dios. Conojel ri winak xquimulij quib ruc'. Ri Are' c'ut xt'uyi'c, xuchaplej qui tijoxic. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Te ri' ri tijonelab re ri Pixab xukuje' ri tata'ib fariseos xquic'am lok jun ixok ri xquiriko tajin cuban ri nimalaj mac ri äwas u banic chrij ri rachajil. Xquiya c'u chquixol ri winak ri e c'o chila'. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Xquibij c'u che ri Jesús: Ajtij, we ixok ri' xriktajic tajin cuban ri nimalaj mac ri äwas u banic chrij ri rachajil. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ri Pixab ri xutz'ibaj ri ka mam Moisés cubij chi rajwaxic cäkacämisaj chabaj jun ixok ri je' cuban wa'. E ri lal, ¿jas c'u cäbij la? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Xquibij wa' che xak rech cäkaj pa qui k'ab, je c'u ri' quecowinic cäquibij chi c'o u mac ri Jesús. Are c'u ri Jesús xa xpachi'c, xuchaplej tz'ibanic cho ri ulew ruc' ri u wi' u k'ab. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Xquitakej c'u u c'otic u chi' ri Jesús. Xa je ri' ri Are' xujicomaj rib, xubij c'u chque: Apachin chech alak ri man c'o tä u mac, chuq'uiäka ri nabe abaj chrij we ixok ri', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Xpachi chi jumul ri Jesús, xutakej tz'ibanic cho ri ulew. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Aretak c'ut xquita ri xubij ri Jesús, xquina' quib pa canima' chi c'o qui mac. Chquijujunal c'ut xquichap elem bic. Nabe xebel bi ri ri'jab. Aretak conojel e elinak chi bic, xak xuwi chi ri Jesús c'o canok ruc' ri ixok ri canajinak can chila'. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Te ri' ri Jesús xujicomaj rib. Man c'o tä c'u jun xrilo, xane xak xuwi ri ixok. Ri Are' xubij che: Nan, ¿jawije' e c'o wi ri cäquibij chi c'o mac la? ¿A mat c'o jun xcanaj can chuk'atic tzij puwi' la chi cäc'äjisax wäch la? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ri ixok xubij che ri Jesús: Man c'o tä jun, Tat, —xcha che. Are c'u ri Jesús xubij che: Ri in xukuje' man quink'at tä tzij puwi' la chi cäc'äjisax wäch la. ¡Oj ba' la chanim, mämacun chi c'u la! —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Xtzijon chi jumul ri Jesús cuc' ri winak, xubij chque: In ri', ri in quinya sakil chque ri winak cho ruwächulew. Jachin ri cäpe wuc', cäc'oji na ri sakil ruc' ri cuya c'aslemal, man cäbin tä chi c'u pa ri k'ekum, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Te ri' ri tata'ib fariseos xquibij che ri Jesús: Ri lal xak tuquiel la tajin cäk'alajisaj la ri utz chij ib la. Rumal ri' ri tajin cäk'alajisaj la man c'o tä u patän, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ri Jesús xch'awic, xubij chque: Ri tajin quink'alajisaj chwij in, kas tzij c'o u patän, pune xak nu tuquiel quink'alajisaj ri utz chwij chbil wib. Wetam c'ut jawije' ri in petinak wi, xukuje' jawije' ri quine' wi. Ri alak c'ut man etam tä alak jawije' ri quinpe wi, man etam tä c'u alak jawije' ri quine' wi. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ri alak je' cäk'atow tzij alak jas ri quek'atow tzij ri winak ajuwächulew. Ri in c'ut man quink'at tä tzij puwi' jachin jun. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","We c'u quink'at tzij, jicom quinban chuk'atic tzij. Je ri', rumal chi man xak tä nu tuquiel quink'at tzij, xane ri nu Tat ri xintakow lok Are cuk'at tzij junam wuc'. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Pa ri Pixab alak tz'ibtal wi chi aretak quieb winak junam ri cäquibij chrij ri xquilo o chrij ri xquito, rajwaxic ri' cäcojic chi kas tzij ri cäquibij. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ri in c'ut quink'alajisaj ri kas tzij chwij chbil wib, xukuje' ri nu Tat ri xintakow lok cuk'alajisaj ri kas tzij chwij, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Te ri' ri tata'ib fariseos xquita' che ri Jesús: ¿Jawije' c'o wi ri tat la? —xecha che. Ri Jesús xch'awic, xubij chque: Ri alak man kas tä etam alak nu wäch, xukuje' man etam tä alak u wäch ri nu Tat. We ta kas etam alak nu wäch in, etam ta alak u wäch ri' ri nu Tat xukuje', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ri Jesús xubij wa' we tzij ri' aretak tajin cuya tijonic pa ri nimalaj rachoch Dios chunakaj ri c'olibal re tak ri cuchuj. Man c'o tä c'u jun xc'amow bi pa che' rumal chi mäja' curik ru k'ij. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ri Jesús xch'aw chi jumul, xubij chque: Ri in quine'c. Ri alak c'ut quintzucuj na alak. Pa ri mac alak c'ut cäcäm wi alak, rumal chi man cäcowin tä alak que' alak chila' jawije' ri quine' wi, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Te ri' ri winak aj Israel xquibij: ¿A xa ta lo cucämisaj rib, rumal c'u ri' cubij chi man cujcowin taj cuje' chila' jawije' ri que' wi? —xecha ri e are'. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Te ri' xubij ri Jesús chque: Ri alak, xak alak ajwaral, are c'u ri in chila' chicaj quinpe wi. Ri alak, xak alak ajuwächulew. Are c'u ri in man in ajuwächulew taj. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Rumal ri' xinbij chech alak chi pa ri mac alak cäcäm wi alak. Rumal chi we man cäcoj tä alak chi in ri' ri tajin quinbij, pa ri mac alak cäcäm wi na alak, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Te ri' xquita' che ri Jesús, xquibij: ¿Jachin c'u ri lal? —xecha che. Ri Jesús xch'awic, xubij chque: Ojer ri' nu bim chech alak jachin ri in, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Q'uia ri cwaj quinbij chech alak chrij ri tajin quinwilo chuk'atic tzij chrij ri cäban alak. Are c'u ri xintakow lok cubij ri kas tzij. Ri in c'ut, jachique ri nu tom chuchi' ri Are', are wa' ri quinbij chque ri winak ajuwächulew, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ri e are' c'ut man xquich'ob taj chi ri Jesús are tajin cäch'aw chrij ri ka Tat chila' chicaj. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Rumal ri' xubij chque: Aretak ri in, in ri' ri Ralc'ual ri Dios ri Kas Winak, quinyac na chicaj umal alak chquiwäch ri winak, quetamaj c'u na alak chi In Ri'. Man c'o tä c'u jas quinbano xak pa we wi, xane xak xuwi quinbij ri u c'utum ri ka Tat chnuwäch, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Are c'u ri xintakow lok c'o wuc' in. Ri nu Tat man in u yo'm tä can nu tuquiel rumal chi amak'el ronojel k'ij are quinban ri utz cäril wi ri Are', —xcha chque ri winak aj Israel. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Aretak ri Jesús xubij wa' we tzij ri', e q'uia xecojon che ri Are'. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Xubij c'u ri Jesús chque ri winak aj Israel ri xecojon che: We ri alak cätakej alak u banic ri nu bim chech alak, kas tzij alak nu tijoxelab, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Quetamaj c'u na alak ri kas tzij, ri kas tzij c'ut cubano chi tzokopital chi alak, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ri winak aj Israel xech'awic, xquibij: Ri uj are ka mam ri Abraham ojer, man uj cojom tä c'u xak che patänil re jun winak. ¿Jas lo wa' chi cäbij la chke chi cujtzokopitaj na? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ri Jesús xubij chque: Kas tzij quinbij chech alak chi conojel ri quemacunic e cojom ri' che patänil tak re ri mac. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Jun ri cojom che patäninel man are tä kas ajpaja. Are c'u ri u c'ojol ri rajaw ja kas ajpaja ri' amak'el ronojel k'ij. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Je c'u ri', we ri in, in u C'ojol ri Dios quintzokopin chech alak, kas tzij ri' chi tzokopital chi alak, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ri in wetam chi ri mam alak are ri Abraham ojer. Caj c'u alak quincämisaj alak rumal chi man cäcoj tä alak ri quinbij chech alak. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ri in are quinbij ri u c'utum ri nu Tat chnuwäch. Are c'u ri alak are cäban alak jachique ri bim chech alak rumal ri tat alak, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ri e are' xech'awic, xquibij: Ri ka tat uj are ri ka mam Abraham ojer, —xecha'. Ri Jesús xubij chque: We ta kas tzij are tat alak ri ka mam Abraham, are ta cäban alak ri' jas ri xuban ri are'. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pune nu bim ri kas tzij chech alak ri u c'utum ri Dios chnuwäch, ri alak caj alak quincämisaj alak. Ri ka mam Abraham man c'o tä jumul ri je' xuban wa'. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ri alak c'ut je' cäban alak jas ri cuban ri tat alak, —xcha ri Jesús chque. Ri e are' c'ut xquibij che: Ri uj, man uj alc'ualaxelab taj ri mat k'alaj u wäch ka tat. Ri ka Tat xa jun c'olic, are c'u ri Dios, —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ri Jesús c'ut xubij chque: We ta kas tzij chi ri Dios are Tat alak, quinaj ta alak ri' rumal chi ri in ruc' ri Dios in petinak wi, waral c'ut in c'o wi. Man in petinak taj xak pa we wi, xane are ri Dios xintakow lok. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Jas che ri alak man cäcowin tä alak chuch'obic ri quinbij? Xa rumal chi man caj tä alak cätatabej alak ri nu tzij. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ri tat alak are ri Itzel. Ri alak, alak rech ri are', are c'u caj alak cäban alak jachique ri craj ri are'. Ri Itzel are jun cämisanel ojer lok. Ri are' man cuban tä ri kas tzij, man cubij tä c'u ri kas tzij. Aretak cuban tzij, are cubij ri u banic ri are'. Are jun banal tzij, qui tat c'ut ri banal tak tzij. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ri in c'ut quinbij ri kas tzij, rumal c'u ri' ri alak man cäcoj tä alak ri nu tzij. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Jachin chech alak cäcowinic cuk'alajisaj chi kas tzij c'o mac nu banom? We c'u quinbij ri kas tzij, ¿jas c'u che man cäcoj tä alak ri quinbij? ");
INSERT INTO qucTNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Apachin ri rech ri Dios cutatabej ri' ru Tzij ri Dios. Are c'u ri alak man alak tä rech ri Dios. Rumal ri' man caj tä alak cätatabej alak ru Tzij ri Dios, —xcha ri Jesús chque ri winak aj Israel. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ri winak aj Israel xquibij che ri Jesús: Kas tzij ri xkabij aretak xkabij chi ri lal, xa lal aj Samaria, xukuje' chi ri lal c'o jun itzel espíritu che la, —xecha che ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ri Jesús xch'awic, xubij chque: Man c'o tä jun itzel espíritu chwe. Ri tajin quinbano, xa tajin quinya u k'ij ri nu Tat, are c'u ri alak xa quesaj alak nu q'uixbal. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ri in c'ut man cwaj taj chi cäyi' nu k'ij, pune ta ne c'o Jun ri craj chi cäyi' nu k'ij, cuk'at c'u na tzij ri Are' pa qui wi' ri cäquetzelaj nu wäch. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Kas tzij quinbij chech alak chi jachin ri cunimaj ri quinbij, man cäcäm tä na ri are', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Te ri' ri winak aj Israel xech'awic, xquibij: Cämic kas xel chi sak chkawäch chi xa c'o jun itzel espíritu che la, —xecha che ri Jesús. Ri ka mam Abraham, xukuje' conojel ri k'alajisal tak re ru Lok' Pixab ri Dios xecämic, te c'u ri' cäbij la: “Jachin ri cunimaj ri quinbij man cäcäm taj,” —cächa la. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿A lal ta c'ut nim na ri k'ij la chuwäch ri ka mam Abraham? Ri are' xcämic, xukuje' xecäm ri k'alajisal tak re ru Lok' Pixab ri Dios. ¿Jachin ta c'u ri lal ri cäban che ib la? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ri Jesús xch'awic, xubij chque: We ta xak in quinya nu k'ij chbil wib, man c'o tä u patän ri'. Are c'u ri cäyo'w nu k'ij are ri nu Tat, ri cäbij alak chi are Dios alak. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ri alak c'ut man etamam tä alak u wäch. Ri in kas tzij wetam u wäch. We ta quinbij chi man wetam tä u wäch, in banal tzij ta ri' je' jas ri alak. Ri in c'ut kas tzij wetam u wäch, quinnimaj c'ut ri cubij. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ri Abraham ri mam alak xquicotic aretak xuto chi cäril na ri nu k'ij. Xril c'ut, kas c'u xquicotic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ri winak aj Israel xquibij che ri Jesús: Mäja' ne niq'uiaj ciento junab la, te c'u ri' cäbij la chi xil la u wäch ri ka mam Abraham, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ri Jesús xch'awic, xubij: Kas tzij quinbij chech alak chi ri in, in c'o chic ojer, c'ä mäjok cäc'oji ri Abraham, —xcha chque ri winak aj Israel. ");
INSERT INTO qucTNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Xepe c'u ri winak aj Israel, xquic'am abaj rech cäquiq'uiäk chrij ri Jesús. Ri Are' c'ut, xuc'u' rib chquiwäch, xel lok pa ri nimalaj rachoch Dios, xoc'ow chquixol ri winak, xe'c. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ri Jesús benak pa ri be aretak xril jun achi ri moy tzaretak xil u wäch. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ru tijoxelab xquita' che ri Jesús: Ajtij, —xecha che. ¿Jas che moy we achi ri' tzaretak xil u wäch? ¿A xa rumal ri qui mac ru nan u tat o xa rumal ru mac ri are'? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ri Jesús xubij chque: Man rumal tä rech ru mac ri are', man rumal tä c'u rech ri qui mac ru nan u tat, xane rech rumal ri are' cäk'alajin ri cäcowin ri Dios chubanic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Chanim ri' ri c'o na ri k'ij, rajwaxic chi quinban na ri xintak chubanic rumal ri xintakow lok. Coc c'u na ri ak'ab aretak man c'o tä chi jun cäcowinic cächacunic. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Pa tak we k'ij ri' aretak in c'o cho ruwächulew, ri in quinya sakil chque ri winak ajuwächulew, —xcha ri Jesús chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Aretak xbitaj wa' we tzij ri' rumal ri Jesús, xutzak u chub pulew, xuban jubik' xok'ol ruc' ru chub, xubil c'u chrij tak ru wak'äch ri moy. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Te c'u ri' xubij che: ¡Oj la! Ch'aja la ri wäch la pa ri atinibal ri cäbix “Siloé” che. (We bi'aj ri' quel cubij “Takom”.) Ri moy achi xe'c, xuch'aj ru wäch. Aretak xtzelej lok, xcowinic xca'y chic. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Are c'u ri u c'ul tak ja, xukuje' ri winak ri quetamam u wäch chi moy nabe, xquibij: ¿A mat are wa' we achi ri' ri cät'uyi chi' tak ri be chuta'ic u limosna? —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Jujun xquibij: Je', are wa', —xecha'. Niq'uiaj chic xquibij: Man are taj. Xak c'u junam quel ruc', —xecha'. Are c'u ri achi ri moy can nabe xubij: Je', in ri', —xcha chque ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Te ri' ri winak xquita' che ri achi: ¿Jas lo wa' chi catcowin chic catca'yic? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ri are' xch'awic, xubij chque: Ri achi ri Jesús u bi' xuban jubik' xok'ol, xubil chrij tak ri nu wak'äch, te c'u ri' xubij chwe: “Oj la chi' ri atinibal ri cäbix “Siloé” che, ch'aja la ri wäch la chila',” —xcha chwe. Xine' c'ut. Aretak xch'ajtaj ri nu wäch, xincowinic xinca'yic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Te ri' ri winak xquibij: ¿Jawije' c'o wi ri achi ri'? —xecha che. Ri are' xubij chque: Man wetam taj, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Te ri' xquic'am bi ri achi ri moy can nabe, xequiya chquiwäch ri tata'ib fariseos. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Are c'u jun k'ij re uxlanem aretak ri Jesús xuban ri jubik' xok'ol, xucunaj ri achi ri moy. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ri tata'ib fariseos xukuje' xquita' che ri achi chi jas lo wa' chi cäcowin chic cäca'yic. Ri are' xubij chque: Xubil xok'ol chrij tak ri nu wak'äch, te c'u ri' xinch'aj ri nu wäch. Quinca'y chi c'u cämic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Te ri' jujun chque ri tata'ib fariseos xquibij: Ri achi ri xbanow wa' we cunanic ri' man rech tä ri Dios, rumal chi man nim tä cäril wi ri k'ij re uxlanem, —xecha'. Niq'uiaj chi c'ut xquibij: ¿Jas ta c'u lo wa' chi cäcowinic cuban tak we cajmabal etal ri' we ta kas tzij ajmac? —xecha'. Je ri' chi man xjunamataj tä ri qui chomanic, xquitasala c'u quib. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Xquita' chi c'u jumul che ri achi ri moy can nabe: E ri at, ¿jas cabij at chrij ri achi ri xcunan ra wak'äch? —xecha che. Ri are' c'ut xubij: Ri in quinbij chi are jun k'alajisal re ru Lok' Pixab ri Dios, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Are c'u ri winak aj Israel man xquicoj taj chi ri achi ri' are wa' ri moy can nabe, cämic c'ut cäca'y chic. C'ä te' xquicojo aretak xesiq'uix na lok ru nan u tat ri achi ri xcunatajic. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Xquita' c'u chque: ¿A are wa' ri alc'ual alak ri cäbij alak chi moy xil u wäch? ¿Jas lo wa' chi cämic cäcowin chic cäca'yic? —xecha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ru nan u tat xech'awic, xquibij: Ketam chi are wa' ri kalc'ual ri moy xil u wäch. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Man ketam tä c'ut jas wa' chi cämic cäcowin chic cäca'yic, man ketam tä c'u jachin ri xcunan ru wak'äch. Ta' alak che ri are'. Achi chi ya', cubij c'u na chech alak jas wa' chi cäcowin chic cäca'yic, —xecha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Je wa' xquibij ru nan u tat rumal chi xa xquixej quib chquiwäch ri winak aj Israel. Ri e are' c'ut qui chomam chic junam chi jachin ri cucojo chi ri Jesús are ri Cristo cäquesaj na bi pa ri rachoch Dios. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Rumal ri' ru nan u tat ri achi ri xcunax ru wak'äch xquibij: “Ta' alak che ri are'. Achi chi ya',” —xecha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Te c'u ri' ri winak aj Israel xquisiq'uij chi jumul ri achi ri moy can nabe, xquibij che: Chabij ba' ri kas tzij chke chuwäch ri Dios. Ri uj ketam chi ri achi ri' are jun ajmac, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ri achi xch'awic, xubij chque: Ri in man wetam taj we are jun ajmac o man are taj, xuwi wetam chi nabe canok in moy, cämic c'ut quinca'y chic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Xquita' chi c'u jumul che: ¿Jas xuban chawe? ¿Jas xuban chucunaxic ri a wak'äch? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Xch'aw ri achi, xubij chque: Xinbij chech alak, ri alak c'ut xa man cäta tä alak. ¿Jas che caj alak chi quinbij wa' jumul chic? ¿A xa caj alak coc alak che u tijoxel? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Te ri' ri e are' xquitze'j u wäch, xquibij c'u che: Ri at, at jun ruc' we achi ri', are c'u ri uj, uj jun ruc' ri ka mam Moisés. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ri uj ketam chi ri Dios xch'aw ruc' ri ka mam Moisés. Are c'u we achi ri' man ketam taj jawije' ri cäpe wi, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ri achi c'ut xch'awic, xubij chque: ¡Co'l ta ne ri'! Ri alak man etam tä alak jawije' cäpe wi, ri in c'ut xucunaj ri nu wak'äch. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kas ketam chi ri Dios man cuta tä ri qui tz'onobal tok'ob ri ajmaquib, xuwi cuta ri qui tz'onobal tok'ob ri winak ri quek'ijilan che, ri cäca'n ru rayibal. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Man c'o tä jumul ka tom cäbixic chi c'o jun cäcowin chucunaxic ru wak'äch jun achi ri moy xil u wäch. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","We ta ri achi ri' mat ruc' ri Dios petinak wi, mat c'o jas cäcowin ri' chubanic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Te ri' xquibij che: Ri at, xa at ajmac xil a wäch. ¿A are cawaj cujatijoj? —xecha che. Xquesaj c'u bic pa ri rachoch Dios. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ri Jesús xretamaj chi xesax bic ri achi ri moy can nabe. Aretak ri Jesús xuriko, xubij che: ¿A cäcojon la che ru C'ojol ri Dios? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ri achi xubij che: Tat, bij la chwe jachin ri' rech ri in quincojon che, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ri Jesús xch'awic, xubij che: Ilom chi la u wäch wa'. In ri', ri tajin quintzijon uc' la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Te c'u ri' ri achi xxuqui chuwäch ri Jesús, xubij che: Quincojon che la, Kajaw, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Xubij c'u ri Jesús: Ri in, in petinak cho ruwächulew chuk'atic tzij, rech ri moyab cäjaktaj ri qui wak'äch, xukuje' rech ri queca'yic quecanaj moy, —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Te ri' jujun chque ri tata'ib fariseos ri e c'o chila' ruc' ri Are', aretak xquita ri xubij ri Jesús, xquibij che: ¿A uj moy ta c'u lo uj xukuje'? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ri Jesús xch'awic, xubij chque: We ta alak moy, mat c'o mac alak ri'. Rumal c'u rech chi cäbij alak chi cäca'y alak, c'o mac alak, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Kas tzij quinbij chech alak chi jachin ri man coc tä bi chuchi' ri qui corral ri chij, xane xa cutzucuj jawije' cunim wi bi rib, ri achi ri' xa jun elak'om, jun t'orinel. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Are c'u ri coc bi chuchi' ri corral are ajyuk' ri', ri chajil que ri chij. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ri chajil u chi' ri corral cujak ri' chuwäch rech coquic. Ri chij c'ut cäquich'ob u wäch aretak cäch'awic. Ri ajyuk' queusiq'uij ru chij chquijujunal ruc' ri qui bi', queresaj c'u bi pa ri corral. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Aretak e resam chi bic conojel ri chij pa ri corral, cänabej bi chquiwäch, are c'u ri chij queteri bi chrij rumal chi cäquich'ob u wäch aretak cäch'awic. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Man queteri tä c'u chrij jun winak ri man quetam tä u wäch, xane xa queanimaj chuwäch rumal chi man cäquich'ob taj aretak cäch'aw jun winak ri man quetam tä u wäch, —xcha ri Jesús chque ri winak aj Israel. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ri Jesús xucoj wa' we c'utbal ri' chquiwäch, ri e are' c'ut man xquich'ob taj jas ri xraj xubij chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Te ri' ri Jesús xubij chi jumul chque: Kas tzij quinbij chech alak. Ri in, in ru chi' ri corral ri queboc wi bi ri chij. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Conojel ri nabe xebul chnuwäch in, e elak'omab ri', e t'orinelab. Ri chij c'ut man xquitatabej taj ri xquibij. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ri in, in ru chi' ri corral. Jachin ri wumal in coc pa ri corral curik ru tobanic ri Dios. Ri winak ri' junam ruc' jun chij ri coc pa ri corral, te c'u ri' quel bic, curik utzalaj echa'. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ri elak'om xuwi petinak rech querelak'aj bi ri chij, queucämisaj, cusach qui wäch. Ri in c'ut in petinak chuya'ic qui c'aslemal, rech c'o qui c'aslemal ri kas utz na. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","In ri' ri utzalaj ajyuk'. Ri utzalaj ajyuk' cuya ru c'aslemal pa cämical rumal quech ri chij. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Are c'u ri ajyuk' ri xuwi cuchomaj ri tojbal re, aretak cärilo cäpe ri utiw, queuya can ri chij, canimajic. Je ri' cubano rumal chi man are tä kas cajyuk' ri chij, xukuje' ri chij man e rech tä ri are'. Cäpe c'u ri utiw queuchap ri chij, queujabuj. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ri achi ri' canimajic rumal chi xuwi cuchomaj ri tojbal re. Man querilij tä ri chij. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","In ri' ri utzalaj ajyuk', wetam qui wäch ri nu chij, xukuje' ri e are' quetam nu wäch in. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Je' jas ri nu Tat retam nu wäch in, ri in xukuje' wetam u wäch ri nu Tat. Quinya c'u ri nu c'aslemal pa cämical rumal quech ri chij. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Xukuje' e c'o chi niq'uiaj nu chij ri man e c'o tä pa we corral ri'. Rajwaxic c'ut queinc'ama na lok xukuje'. Ri chij ri' cäquinimaj na ri quinbij. Xa c'u jumulaj chij cäc'oji na, xukuje' xa jun ri cajyuk'. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ri ka Tat quinraj in rumal chi quinya ri nu c'aslemal pa cämical, quinc'astaj chi c'u na rech cäc'oji chic ri nu c'aslemal. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Man c'o tä jun quesan ri nu c'aslemal chwe, xane ri in pa wanima' cäpe wi quinya ri nu c'aslemal. Pa nu k'ab c'o wi ru ya'ic ri nu c'aslemal, xukuje' pa nu k'ab c'o wi ru c'amic jumul chic. Are wa' ri xintak wi rumal ri nu Tat, —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Aretak ri winak aj Israel xquita wa' we tzij ri', xquichapla u tasic quib jumul chic. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","E q'uia chque xquibij: ¿Jas che cätatabej alak ri cubij? We achi ri' c'o jun itzel espíritu che, xukuje' ch'ujarinak wa', —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Niq'uiaj chi c'ut xquibij: Man c'o tä jun winak ri c'o jun itzel espíritu che ri je' cätzijon wa' we ri'. ¿A cäcowin pu lo jun itzel espíritu cujak ri qui wak'äch ri moyab? —xecha'. ¡Man cuya' taj! —xecha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Pa tak ri k'ij ri' xurik ri k'alaj. Are chi' tajin cäban ri nimak'ij pa ri tinimit Jerusalén, natabal re ri k'ij ri xq'uis u yaquic ri nimalaj rachoch Dios, xjach c'u pu k'ab ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ri Jesús tajin cäwacat pa ri nimalaj rachoch Dios, pa ri rakan ja re Salomón. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Xepe c'u ri winak aj Israel xquimulij quib chrij, xquibij che: ¿C'ä jampa' cujya la pa sak? We lal ri' ri Cristo, bij ba' la ri kas tzij cämic, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ri Jesús xch'awic, xubij chque: Ya nu bim chic. Ri alak c'ut man cäcoj tä alak ri xinbij. Ronojel ri u takom ri nu Tat chwe chi quinbano, are cäc'utuw na ruc' sakil. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ri alak c'ut man cäcojon tä alak rumal chi ri alak man jun tä cuc' ri nu chij, jas ri xinbij chech alak nabe. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ri nu chij quetam nu wäch aretak quinch'awic. Ri in xukuje' wetam qui wäch, queteri c'u chwij. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ri in quinya c'aslemal chque ri man c'o tä u q'uisic. Man cäsach tä qui wäch, man c'o tä c'u jachin queesan pa nu k'ab. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ri nu Tat, ri nim na u k'ij chquiwäch conojel, are ri xeyo'w chwe. Man c'o tä c'u jachin jun queesan pu k'ab ri Are'. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ri in, xukuje' ri nu Tat, xa uj jun, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Te ri' ri winak aj Israel jumul chic xquic'am abaj rech cäquiq'uiäk chrij ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ri Jesús xubij chque: Q'uia u wäch utzil nu banom chuwäch alak rumal ru chuk'ab ri nu Tat. ¿Rumal c'u jachique chque we utzil ri nu banom quinq'uiäk alak chabaj? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ri winak aj Israel xech'awic, xquibij: Man cäkaq'uiäk tä la chabaj rumal jun chque ri utzil ri banom la, xane rumal chi bim la ri äwas u bixic chrij ri Dios. Ri lal xak lal jun achi, banom c'u ib la chi lal Dios, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ri Jesús c'ut xubij chque: Pa ri Pixab alak tz'ibtal wi ri xubij ri Dios: “Ri ix, ix dioses,” —cächa', —xcha ri Are'. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ketam chi ri cubij ru Lok' Pixab ri Dios ri Tz'ibtalic, man cuya' taj cäsach u wäch. Ri Dios xubij “dios” chque ri winak ri xecojon che ru Lok' Pixab. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","We ri Dios xinucha' in, te c'u ri' xinutak lok cho we uwächulew, ¿jas lo wa' ri cäbij alak chi nu bim ri äwas u bixic chrij ri Dios rumal chi xinbij chi in u C'ojol ri Dios? ");
INSERT INTO qucTNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","We man quinbano jachique ri cuban ri nu Tat, ri alak man rajwaxic taj cäcojon alak chwe. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","We c'u quinbano, pune ba' man cäcojon tä alak chwe, cojon ba' alak che ri quinbano rech je ri' kas quetamaj alak, xukuje' cäcoj alak chi ri ka Tat c'o pa wanima' in, xukuje' ri in, in c'o pa ranima' ri ka Tat. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Jumul chic are ta xcaj xquic'am bi pa che'. Ri Jesús c'ut xresaj rib pa qui k'ab. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Te ri' ri Jesús xe' jumul chic ch'äkäp che ri nima' Jordán chrelbal k'ij jawije' ri xuban wi kasna' ri tat Juan nabe, xcanaj c'u chila'. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","E q'uia winak c'ut xebe' che rilic, xquibij c'ut: Kas tzij ri tat Juan, pune man xuban tä cajmabal tak etal, ronojel ri xubij chrij we achi ri' are kas tzij, —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","E q'uia winak c'ut xecojon che ri Jesús chila'. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","C'o jun achi yawab, Lázaro u bi', ri cäpe pa ri tinimit Betania, ri tinimit ri e jekel wi ri nan María xukuje' ri nan Marta ri ratz. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","We nan María ri', ri ranab ri tat Lázaro ri yawab, are wa' ri xk'ijow ri c'oc'alaj aceite chrij ri rakan ri Kajaw Jesús, ri xusu' c'u ruc' ru wi'. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","We quieb ixokib ri' ri cachalal quib, xquitak u bixic che ri Jesús: Kajaw, ri Lázaro ri sibalaj utz la ruc', yawab ri are', —xecha bic. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Aretak xuta ri Jesús wa', xubij: Ri cämical ri cuc'am lok we yabil ri' man are tä q'uisbal re ru c'aslemal, xane xa rech cäk'alajinic chi nim u k'ij ri Dios, xukuje' rech rumal we yabil ri' cäc'utunic chi nim u k'ij ru C'ojol ri Dios, —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ri Jesús, pune sibalaj lok' ri nan Marta chuwäch, xukuje' ru chak', xukuje' ri tat Lázaro, ");
INSERT INTO qucTNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","aretak xbix che chi yawab ri tat Lázaro, xcanaj na can quieb k'ij chila' jawije' ri c'o wi. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Te c'u ri' xubij chque ru tijoxelab: Jo' chi jumul pa Judea, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Xquibij c'u ru tijoxelab che: Ajtij, mäja' naj ri' ri winak aj Israel ri e c'o chila' xcaj xquicämisaj la che abaj. ¿Te ri' are caj la que' chi la jumul jela'? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ri Jesús xubij chque: ¿A mat cablajuj hora u pam ri jun k'ij? We jun winak cäbin pak'ij, man cätzak taj, rumal chi cäril ru sakil ri k'ij ri cäca'y puwi' ruwächulew. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","We c'u ri winak chak'ab cäbinic, cätzakic, rumal chi man c'o tä ri sakil pa ru be, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Te c'u ri' xubij chi ri Jesús chque: Ri tat Lázaro, ri sibalaj uj utz ruc', xwaric, quine' c'ut quinc'asuj na, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Te ri' ri tijoxelab xquibij che ri Jesús: Kajaw, we cäwaric quel cubij wa' chi cutzir na, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ri Jesús c'ut are tajin cubij chi ri tat Lázaro xcämic. Are c'u ri tijoxelab xquichomaj e are' chi are tajin cubij ri waram ri cuban jun winak. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Te ri' xubij ri Jesús chque chi sakil: Ri tat Lázaro ya xcämic, —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ri in quinquicotic chi man in c'o tä chila'. Are c'u utz na wa' chiwe ix rech quixcojonic. Jo' ba' jekila', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Are c'u ri tat Tomás ri “Gemelo” cuchixic, xubij chque ri niq'uiaj tijoxelab chic ri e rachi'l: Jo' uj xukuje' rech cujecäm ruc', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Aretak xopan ri Jesús, te' xuto chi xque' quiejeb k'ij mukutal chi ri tat Lázaro. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ri alaj tinimit Betania nakaj c'o wi che ri tinimit Jerusalén. Craj c'o niq'uiaj legua u najal. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","E q'uia c'u chque ri winak aj Israel e opaninak cho rachoch ri nan Marta, ri nan María, chucu'bisaxic qui c'ux rumal ru cämical ri qui xibal. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Aretak ri nan Marta xretamaj chi opanem cuban ri Jesús, xe' chuc'ulaxic, are c'u ri nan María xcanaj can cho ja. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ri nan Marta xubij che ri Jesús: Kajaw, we ta c'o la waral, mat xcäm ri nu xibal, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Wetam c'ut chi ronojel ri cäta' la che ri Dios, ri Are' cuya na wa' che la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ri Jesús xubij che: Ri a xibal cäc'astaj na chquixol ri cäminakib, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ri nan Marta xubij che ri Jesús: Je', wetam chi cäc'astaj na chquixol ri cäminakib pa ri q'uisbal k'ij, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Te ri' xubij ri Jesús che: Ri in, in ri' quinc'astajisaj ri cäminakib xukuje' quinya qui c'aslemal. Jachin ri cäcojon chwe in, pune cäcämic, cäc'asi chi c'u na. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Conojel c'u ri c'ä e c'aslic ri quecojon chwe, man quecäm tä wi. ¿A cacoj wa'? —xcha che ri nan Marta. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ri nan Marta xubij che: Je', Wajaw, ri in quincojo chi lal ri' ri Cristo, ru C'ojol ri Dios, ri ulinak la waral cho ri uwächulew, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Aretak xbitaj wa' we tzij ri' rumal ri nan Marta, xe'c, xusiq'uij lok ri nan María ru chak'. Xak chc'uyal xubij che: Ri Ajtij c'o waral, catusiq'uij, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ri nan María, xuwi xuto ri xbix che, chanim c'u xwalijic, xe' chuch'abexic ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Mäja' c'u kas copan ri Jesús pa ri tinimit. C'ä c'o chila' jawije' ri xc'ulax wi rumal ri nan Marta. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ri winak aj Israel, ri e c'o cuc' pa ja chucu'bisaxic qui c'ux, aretak xquilo chi aninak xwalij bi ri nan María, xebe' ri e are' ruc'. Xquichomaj chi jela' que' chuchi' ri mukubal che ok'ej. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Aretak c'ut xopan ri nan María ruc' ri Jesús, xxuqui chuwäch, xubij che: Wajaw, we ta c'o la waral, mat xcäm ri nu xibal, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ri Jesús, aretak xrilo chi xuchap ok'ej ri nan María, xukuje' ri winak aj Israel ri e petinak ruc', sibalaj xbisonic, c'äx xuna' pa ranima'. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Xuta' c'u chque: ¿Jawije' ri mukutal wi? —xcha chque. Ri e are' xquibij che: Kajaw, sa'jmpe la, je'ila la, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ri Jesús c'ut xok'ic. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Xquibij c'u ri winak aj Israel: Chiwilampe' chi sibalaj lok' chuwäch, —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Jujun c'u chque xquibij: We achi ri' ri xjakow ru wak'äch ri moy, ¿a mat xcowin ta wa' chubanic jun tok'ob che ri tat Lázaro rech mat xcämic? —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ri Jesús, jumul chic sibalaj c'äx tajin cuna' pa ranima', xnakajin chuchi' ri jul ri mukutal wi ri tat Lázaro. Are jun pec, cojom c'u jun abaj che tz'apibal re ru chi'. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ri Jesús xubij: Chesaj alak ri abaj, —xcha chque ri winak. Are c'u ri nan Marta, ri ranab can ri cäminak, xubij che ri Jesús: Kajaw, c'o chi ruxlab ri' rumal chi xque' quiejeb k'ij wa' cäminak chic, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Xubij c'u ri Jesús che: ¿A mat nu bim chawe chi we catcojonic cawil na u nimarisaxic u k'ij ri Dios? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Te ri' xquesaj ri abaj. Ri Jesús xca'y chicaj, xuban orar, xubij: Tat, quinmaltioxij che la chi xintatabej la. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Wetam chi amak'el ronojel k'ij quintatabej la. Xa c'u rumal quech we winak ri' ri e c'o waral, quinbij wa' rech cäquicojo chi are ri lal in takowinak la lok, —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Aretak xbitaj wa' rumal, co xch'awic, xubij: ¡Lázaro, chatel lok! —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Xel c'u lok ri cäminak, botz'om ri rakan u k'ab ruc' tak atz'iak. Ru palaj pistal ruc' jun su't. Ri Jesús xubij chque ri winak: Solo' alak, tzokopij alak bic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ruc' wa' ri xbantajic, e q'uia chque ri winak aj Israel ri e opaninak chucu'bisaxic u c'ux ri nan María, xecojon che ri Jesús. Xquil c'u ri cajmabal ri xubano. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","E c'o c'u jujun chque xebe' cuc' ri tata'ib fariseos chubixic chque ri u banom ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Are c'u ri tata'ib fariseos, xukuje' ri qui nimakil ri sacerdotes xe'quimulij quib cuc' ri qui nimakil ri winak, xquibij: ¿Jas cäka'no? We achi ri' tajin cuban q'uia cajmabal tak etal, —quecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","We cäkaya can xak chi je ri', conojel ri winak quecojon na che ri Are'. Quepe c'u na ri k'atal tak tzij aj Roma, cäquiwulij na ri nimalaj rachoch Dios ri cäkamulij wi kib, cäquisach na u wäch ri ka tinimit, —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Are c'u ri tat Caifás, ri qui nimal ri sacerdotes pa ri junab ri', xubij chque: Ri ix, xa man c'o tä iwetam, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","¿A mat quich'obo chi are utz na chke uj chi cäcäm xa jun achi che qui q'uexwäch ri winak, chuwäch ri cäsach u wäch ronojel ri tinimit? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Man xak tä c'u pa ru chomanic ri tat Caifás xpe wi wa' we tzij ri' ri xubij, xane rumal chi are qui nimal ri sacerdotes pa ri junab ri' ri Dios xyo'w wa' pa ranima' chi cubij chi ri Jesús cäcäm na rumal quech ri winak aj Israel. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Man xuwi tä c'u rumal quech ri winak aj Israel cäcäm na ri Jesús, xane che qui mulixic conojel ri ralc'ual ri Dios ri e jabuninak cho ronojel ruwächulew. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Xa je ri' ri qui nimakil ri winak aj Israel tzpa ri k'ij ri' xquichap u chomaxic jas cäca'n chucämisaxic ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Rumal ri' ri Jesús ya man xuc'ut tä chi rib chquiwäch ri winak aj Israel. Xel bi pa Judea, xe' jela' chunakaj ri juyub ri cätz'inowic, pa jun tinimit Efraín u bi'. Chila' xc'oji wi cuc' ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Xa c'u jubik' craj man curik ri Pascua, jun chque ri qui nimak'ij ri winak aj Israel. E q'uia winak c'ut pa tak ri niq'uiaj tak tinimit chic xebe' pa ri tinimit Jerusalén, mäjok ri Pascua, chuch'ajic quib che resaxic ri äwas chquij. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tajin c'u cäquitzucuj ri Jesús. Aretak e c'o pa ri nimalaj rachoch Dios cäquitala u tzijol chbil tak quib, cäquibij: ¿Jas cäbij alak? ¿A cäpe ri' pa we nimak'ij o man cäpe taj? —quecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ri tata'ib fariseos, xukuje' ri qui nimakil ri sacerdotes, qui yo'm takanic chi we c'o jun winak retam jawije' c'o wi ri Jesús, chubij wa' chque rech quecowinic quequichapa lok. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Wakib k'ij craj na che ri nimak'ij Pascua aretak ri Jesús xe' pa Betania, ri tinimit ri jekel wi ri tat Lázaro ri xc'astajisax rumal ri Jesús chquixol ri cäminakib. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Chila' c'ut xca'n u banic jun wi'm re benak k'ij chuya'ic u k'ij ri Jesús. Ri nan Marta tajin cucoj ri wa puwi' ri mesa, are c'u ri tat Lázaro jun ri are' t'uyul chi' ri mesa ruc' ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Te ri' xpe ri nan María ruc'am niq'uiaj litro c'oc'alaj cunabal re kas nardo. Sibalaj c'u pakal rajil wa' we cunabal ri'. Xuk'ij chrij ri rakan ri Jesús, te c'u ri' xusu' ruc' ru wi'. Ronojel c'u ru pam ri ja xnoj che ru c'oc'al ri cunabal. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Te ri' jun chque ru tijoxelab ri Jesús, ri jun ri cäjachow na, ri Judas Iscariote ru c'ojol ri tat Simón, xubij: ");
INSERT INTO qucTNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","¿Jas che man xq'uiyix ta wa' we c'oc'alaj cunabal ri' che oxib cientos quetzales, xyi' ta c'u ri puak chque ri meba'ib? —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Man kas tzij tä c'ut chi ri tat Judas xa cutok'obisaj qui wäch ri meba'ib chi je' xubij wa', xane rumal chi are jun elak'om. Pu k'ab c'u ri are' c'o wi ri c'olibal puak. Xa je ri' xcowinic xrelak'aj ri puak ri c'o ruc'. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Te ri' xubij ri Jesús che: ¡Maban wa' che ri ixok! U c'olom c'u bi ri c'oc'alaj cunabal ri' c'ä mäjok quinmukic. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Amak'el c'ut e c'o ri meba'ib iwuc', are c'u ri in man in c'o tä iwuc' amak'el ronojel k'ij, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","E q'uia c'u chque ri winak aj Israel xquito chi ri Jesús c'o pa ri alaj tinimit Betania, xebe' c'u jela' man xuwi tä che rilic ri Jesús, xane xukuje' che rilic ri tat Lázaro ri xc'astajisax rumal ri Jesús chquixol ri cäminakib. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Are c'u ri qui nimakil sacerdotes xjunamataj ri qui chomanic chucämisaxic ri tat Lázaro xukuje'. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Rumal c'u rech ri are' e q'uia chque ri winak aj Israel tajin cäquitas quib chquij ri qui nimakil sacerdotes rech quecojon che ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","E q'uia winak e benak pa ri tinimit Jerusalén che ri nimak'ij Pascua. Chucab k'ij xquito chi ri Jesús copan na pa ri tinimit. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Te ri' xquijol u xak tak palmas, xquic'am bic, xebe' c'u chuc'ulaxic ri Jesús. Co xech'awic, xquibij: ¡Chnimarisax u k'ij ri Dios! ¡Utz re ri petinak pa ru bi' ri Kajaw Dios! ¡Tewchital ba' ri nim takanel pa qui wi' ri winak aj Israel! —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ri Jesús xurik jun burro, xquiejen c'u chrij, jas ri cubij ru Lok' Pixab ri Dios ri Tz'ibtalic: ");
INSERT INTO qucTNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Mixej iwib, winak aj Sión. ¡Chiwilampe'! Petinak ri Jun ri cätakan na pi wi', quiejeninak chrij jun burro, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Pa tak ri k'ij ri' ru tijoxelab ri Jesús man xquich'ob tä ri tajin cäbantajic. Te c'u ri' aretak xnimarisax u k'ij ri Jesús, xna'taj chque chi ronojel wa' ri quilom are tz'ibtal lok chrij ri Are', ronojel c'ut bantajinak. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ri winak ri e c'o ruc' ri Jesús aretak xusiq'uij lok ri tat Lázaro pa ri mukubal, xuc'astajisaj c'u chquixol ri cäminakib, xquitzijoj wa' ri xquilo. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Rumal ri' ri winak xebel lok chuc'ulaxic ri Jesús, rumal chi xquetamaj we cajmabal etal ri' ri xubano. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Are c'u ri tata'ib fariseos xquibij chbil tak quib: Quil ba' alak chi man c'o tä jas cujcowin chubanic. ¡Chilampe alak! Conojel ri winak quebe' ruc', —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Chquixol ri winak ri e benak pa ri tinimit Jerusalén che k'ijilanic pa ri nimak'ij, e c'o jujun winak aj Grecia. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","We winak ri' xeopan ruc' ri tat Felipe ri aj Betsaida re Galilea, xquibochi'j, xquibij che: Tat, cäkaj cäkil u wäch ri Jesús, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ri tat Felipe xe'c, xubij che ri tat Andrés. Te c'u ri' ri quieb chic xebe'c, xe'quibij che ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Te ri' ri Jesús xubij chque: Xurik ri k'ij ri cänimarisax nu k'ij in, in ri' ri Ralc'ual ri Dios ri Kas Winak. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Kas tzij quinbij chiwe, chi we man cäkaj ri jun u wak'äch trico pa ri ulew rech cäk'ayic, tajin wi ri' xak jun u wak'äch trico. We c'u cäk'ayic, cätux na ri', cuya c'u na q'uia u wäch. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Apachin ta ne ri lok' cäril wi ru c'aslemal, cäcäm na wa' ri winak ri', cutzak na ronojel. Apachin c'u ri man lok' taj cäril wi ru c'aslemal cho we uwächulew, cuto' na u wi' ri', curik c'u na ri c'aslemal ri man c'o tä u q'uisic. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","We c'o jun ri craj cäpatänin chwe, chpet wuc'. Jawije' c'u ri quinc'oji wi, chila' xukuje' cäc'oji wi na ri patänil we. We c'o jun ri cäpatänin chwe, cäyi' na u k'ij rumal ri nu Tat, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Sibalaj c'äx quinna' pa wanima' cämic. ¿Jas ta c'u lo ri quinbij na? ¿A quinbij ta c'ut: “Tat, chinto' la chuwäch ri cäpe na pa nu wi' cämic”? Are c'u wa' nu patän in petinak, —xcha ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tat, nimarisaj ba' la u k'ij ri bi' la, —xcha'. Te c'u ri' c'o Jun ri xch'aw lok chicaj ri xubij: Nu nimarisam u k'ij, quinnimarisaj c'u na u k'ij jumul chic, —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Are c'u ri winak ri e c'o chila' ri tajin quetatabenic xquibij chi are jun quiäkulja ri xtatajic. Niq'uiaj chic xquibij: Are jun ángel ri xch'aw ruc', —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Te ri' ri Jesús xubij chque: Man rumal tä wech in xtatajic chi c'o Jun ri xch'aw lok chicaj, xane rumal iwech ix. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Cämic wa' ri k'ij ri cäk'at tzij puwi' we uwächulew ri'. Cämic ri k'ij ri cäpakchix apan ri jun ri cätakan puwi' we uwächulew. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Aretak c'ut ri in quinwalijisax chicaj, conojel queca'y na chwe, sibalaj cäquicajmaj c'u na nu wäch, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Xubij wa' we tzij ri' chuk'alajisaxic jas u wäch cämical curik na. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Xech'aw c'u ri winak, xquibij che: Ri uj ka tom u siq'uixic pa tak ri ka wuj re ri Pixab chi ri Cristo cäc'asi na pa tak ri k'ij ri junab ri quepetic. ¿Jas c'u che cäbij la chi ri Ralc'ual ri Dios ri Kas Winak cäwalijisax na chicaj? ¿Jachin chi c'u ri' ri Ralc'ual ri Dios ri Kas Winak? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Te ri' ri Jesús xubij chque: Cämic ri' c'ä c'o na ri sakil iwuc', xa c'u quieb oxib k'ij chic c'olic. Chixbin ba' chanim ri c'ä c'o ri sakil iwuc', rech man quixcanaj tä can pa k'ekum. Jachin c'u ri cäbin pa k'ekum, man cuch'ob tä ri' jawije' ri que' wi. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Chixcojon che ri sakil cämic, ri c'ä c'o na ri sakil iwuc'. Je ri' rech ri ix, ix winak chic rech ri sakil, —xcha ri Jesús chque. Xuwi xbitaj wa' we tzij ri' rumal ri Jesús, xe' ri Are', xuc'u' rib chquiwäch. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ri Jesús, pune xuban q'uia cajmabal tak etal chquiwäch ri winak aj Israel, ri e are' man xecojon tä che. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Rajwaxic c'ut chi cäbantaj na wa' jas ri u tz'ibam can ri ka mam Isaías ri k'alajisal re ru Lok' Pixab ri Dios ri cubij: Kajaw Dios, ¿jachin ta lo ri cojoninak che ru Lok' Pixab ri Dios ri ka bim? ¿Jachin ta lo chuwäch u c'utum wi ri Kajaw Dios ru chuk'ab? —cächa ri'. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Rumal ri' man xecowin taj xecojonic, rumal chi xukuje' xutz'ibaj can ri ka mam Isaías: ");
INSERT INTO qucTNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Ri Dios xuban moy chque, xukuje' xubano chi xeabajir ri canima', rech man cäquil tä ruc' ri qui wak'äch, man cäquich'ob tä ruc' ri qui chomabal, man quetzelej tä c'u wuc' in rech quecunatajic, —cächa ri Dios, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ri ka mam Isaías xubij wa' we tzij ri' rumal chi ri are' xrilo xnimarisax u k'ij ri Jesús, xch'aw c'u chrij. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pune je ri', e q'uia chque ri winak aj Israel xecojon na che ri Jesús, xukuje' ne jujun chque ri nimak qui banic. Man xquik'alajisaj tä c'u quib chquiwäch ri winak rumal chi xquixej quib chquiwäch ri tata'ib fariseos, rech man queesax tä bi pa ri rachoch Dios. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ri e are' c'ut are utz xquil na chi cäyi' qui k'ij cumal ri winak chuwäch ri cäyi' qui k'ij rumal ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ri Jesús sibalaj co xch'awic, xubij: Jachin ri cäcojon chwe in, man xuwi tä chwe in cäcojon wi, xane xukuje' cäcojon ri' che ri ka Tat ri xintakow lok. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Jachin c'u ri quinril in, cäril ri' xukuje' ri xintakow lok. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","In ri' ri quinya sakil, in petinak cho ruwächulew rech jachin tak ri quecojon chwe, man quecanaj tä can pa ri k'ekum. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Jachin c'u ri cuta ri nu tzij, te c'u ri' man cunimaj taj, man in tä ri' ri quink'atow tzij puwi' chi cäc'äjisax u wäch. Je ri', rumal chi ri in man in petinak tä chuk'atic tzij pa qui wi' ri winak ajuwächulew, xane in petinak che qui to'ic. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Jachin ri xa cäretzelaj nu wäch, man cunimaj tä c'u ri nu tzij, c'o ri cäk'atow na tzij puwi' chi cäc'äjisax u wäch. Ri tzij ri nu bim e are ri' ri quek'atow na tzij puwi' pa ri q'uisbal k'ij. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Man xak tä c'u pa we wi in quinch'awic. Ri ka Tat ri xintakow lok, are ri Are' u bim chwe jachique ri quinbij xukuje' jachique ri quinc'utu. ");
INSERT INTO qucTNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Wetam c'ut chi ru takanic ri nu Tat are re c'aslemal ri man c'o tä u q'uisic. Xa je ri', ri quinbij, are quinbij jas ri in takom wi rumal ri ka Tat. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Xa c'u jun k'ij chic craj che ri nimak'ij, Pascua u bi'. Retam chi c'u ri Jesús chi xurik ri k'ij ri cuya na can ruwächulew, cätzelej c'u ruc' ru Tat. Ri Are' amak'el ronojel k'ij sibalaj lok' xeril wi ru tijoxelab cho ruwächulew. Pa ri k'ij ri' tajin cuc'ut chquiwäch chi sibalaj lok' querilo, chi man c'o tä u q'uisic ri qui lok'al chuwäch. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Tajin cäca'n ri wi'm re benak k'ij. Ri Itzel c'ut u yo'm chi pa ranima' ri tat Judas Iscariote ru c'ojol ri tat Simón chi pa ri ak'ab ri' cujach na ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Retam c'u ri Jesús chi ronojel takanic yo'm pu k'ab rumal ru Tat. Retam chi ruc' ri Dios petinak wi ri Are', xukuje' chi ruc' ri Dios cätzelej wi. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Xwalij c'u ri Jesús chi' ri mesa, xresaj ru k'u', xuc'am jun toalla, xuxim c'u wa' xe' ru pam. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Te ri' xuya joron pa jun palangana, xuchap u ch'ajic cakan ru tijoxelab, xusu' c'u ruc' ri toalla ri ximital xe' ru pam. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Aretak craj cuch'aj rakan ri tat Pedro, ri are' xubij che ri Jesús: Wajaw, ¿a cäch'aj c'u la ri wakan in? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ri Jesús xch'awic, xubij che: Cämic ri' man cach'ob taj jas ri tajin quinbano, c'ä te' ba' pa jun k'ij chic cach'ob na, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Are c'u ri tat Pedro xubij che: Ri in, man c'o tä jumul quinya che la chi cäch'aj la ri wakan in, —xcha che. Ri Jesús xubij che: We man quinch'aj tä ri awakan, man cuya' taj catc'oji wuc', —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ri tat Simón Pedro xubij che: Wajaw, man xuwi tä ba' ri wakan, xane ch'aja la ri nu k'ab xukuje' ri nu jolom, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Are c'u ri Jesús xubij che: Jachin ri te' xto'taj che ri atinem man rajwaxic tä chic cuch'aj rib, xane xak xuwi chi ri rakan, rumal chi ronojel ru cuerpo ch'ajch'oj chic. Ri ix, ix ch'ajch'oj chic, pune man iwonojel taj, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ri Jesús ya retam chic jachin ri cäjachow na. Rumal ri' xubij: “Man iwonojel tä ri ix, ix ch'ajch'oj,” —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Aretak ri Jesús xto'taj chuch'ajic ri cakan ru tijoxelab, xuc'am ru k'u', xucoj chrij, xt'uyi chi c'u jumul chi' ri mesa. Xubij c'u chque: ¿A quich'obo jas quel cubij wa' ri xinban chiwe? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ri ix quibij Kajtij, xukuje' Kajaw, —quixcha chwe. Kas tzij ri quibij, rumal chi in c'u ri'. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","We in, ri in Iwajtij, ri in Iwajaw nu ch'ajom ri iwakan, ri ix xukuje' rajwaxic ba' quich'aj ri iwakan chbil tak iwib. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ri in nu yo'm jun c'utbal chiwäch rech ri ix xukuje' je' quibano jas ri nu banom in chiwe. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kas tzij quinbij chiwe chi man c'o tä jun patäninel ri nim na u banic chuwäch ru patrón, xukuje' man c'o tä jun tako'n ri nim na u banic chuwäch ri takowinak bic. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","We quich'ob wa' we ri', quitakej c'u u banic, utz c'u iwe ri', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ri tajin quinbij chanim, man quinbij tä wa' chiwij iwonojel ri ix. Ri in wetam jachin tak ri e cha'tal wumal. Rajwaxic c'ut je' cäbantaj na jas ri cubij ru Lok' Pixab ri Dios ri Tz'ibtalic: “Ri jun ri cäwi' junam wuc' u banom u c'ulel chwe,” —cächa ri'. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Quinbij wa' chiwe chanim c'ä mäja' cäbantajic, rech aretak cäbantaj wa', ri ix quicojo chi In Ri'. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Kas tzij quinbij chiwe, chi jachin ri cuc'ulaj ri quintak bic, in ri' quinuc'ulaj. Jachin c'u ri quinuc'ulaj in, cuc'ulaj ri' ri xintakow lok, —xcha ri Jesús chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Aretak xbitaj wa' we tzij ri' rumal ri Jesús, sibalaj xuna' c'äx pa ranima'. Kas chi sakil xubij chquiwäch ru tijoxelab: Kas tzij quinbij chiwe chi jun chiwe are quinjachow na, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Te ri' ri tijoxelab xquichap u ca'yexic quib ri jun ruc' ri jun chic, man xquich'ob tä c'u jachin ri tajin cubij ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jun chque ru tijoxelab ri Jesús, ri jun ri sibalaj lok' chuwäch tajin cäwi' chuxcut chi' ri mesa. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ri tat Simón Pedro xubij che rare' pa memal chi cuta' che ri Jesús jachin ri tajin cubij. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Te ri' ri are' xkeb ruc' ri Jesús, xuta' che: Wajaw, ¿jachin ri' ri cäbij la? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Xch'aw c'u ri Jesús, xubij che: Quinrub na jun ch'äkap caxlan wa. Jachin c'u che ri quinya wi wa', are ri are', —xcha che. Xurub c'u ri ch'äkap caxlan wa, xuya che ri tat Judas Iscariote, u c'ojol ri tat Simón. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Xuwi xc'amtaj ri ch'äkap caxlan wa rumal ri tat Judas, xoc ri Satanás pa ranima'. Xubij c'u ri Jesús che: Ri cachomaj cabano, chabana wa' chanim, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Man c'o tä c'u jun chque ri tajin quewi' chi' ri mesa ri xuch'obo jas che ri Jesús xubij wa' we tzij ri' che. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Quetam c'ut chi ri tat Judas pu k'ab c'o wi ri c'olibal puak, rumal ri' jujun xquichomaj chi ri Jesús are tajin cubij che chi culok' ri rajwaxic chque che ri nimak'ij o cuya jubik' puak che qui to'ic ri meba'ib. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Xuwi c'u xc'amtaj ri ch'äkap caxlan wa rumal ri tat Judas, xel bi ri are'. Chak'ab chi c'u ri'. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Aretak elinak chi bi ri tat Judas, xubij ri Jesús: Cämic cäk'alajin na chi kas nim nu k'ij in, in ri' ri Ralc'ual ri Dios ri Kas Winak. Rumal c'u wech in cänimarisax na u k'ij ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","We rumal wech in, in ri' ri Ralc'ual ri Dios ri Kas Winak, cänimarisax na u k'ij ri Dios, xukuje' ri Dios cunimarisaj na nu k'ij in. Chanim c'ut cuban na wa'. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ix ri', ix je' ta ne alaj tak walc'ual, man naj tä chic in c'o iwuc'. Ri ix quinitzucuj na. Jas c'u ri xinbij chque ri winak aj Israel, je' xukuje' quinbij chiwe ix: Man quixcowin taj quixe' chila' jawije' ri quine' wi in. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Quinya c'u can we c'ac' takanic ri' chiwe: Chiwaj iwib chbil tak iwib. Je' jas ri in quixwaj, je' ba' chibana ix, chiwaj iwib chbil tak iwib. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","We quiwaj iwib chbil tak iwib, conojel ri winak cäquetamaj na chi ri ix, ix nu tijoxelab, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ri tat Simón Pedro xuta' che ri Jesús: Kajaw, ¿jawije' que' wi la? —xcha che. Ri Jesús xch'awic, xubij che: Jawije' ri quine' wi, ri at man catcowin taj cate' wuc' cämic. C'ä te c'u ri' cate' na wuc', —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Xubij c'u ri tat Pedro che: Wajaw, ¿jas che man quincowin taj quine' uc' la cämic? Ri in quinya nu tzij chi quincäm rumal ech la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ri Jesús xch'awic, xubij che: ¿A kas tzij caya a tzij chi catcäm rumal wech in? —xcha che. Kas tzij quinbij chawe chi cabij na oxmul chi man awetam tä nu wäch mäjok cok' ri ama' äc', —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Xak mäk'oxow iwanima'. Chicu'ba i c'ux chrij ri Dios, xukuje' chicu'ba i c'ux chwij in. ");
INSERT INTO qucTNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Cho rachoch ri nu Tat c'o q'uia ri je'l tak ja ri cuya' quixc'oji wi. We ta mat je ri', nu bim ta ri' chiwe. Quine' ba', quinbana u banic jun ja ri cuya' quixc'oji wi. ");
INSERT INTO qucTNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Aretak in benak chic, bantajinak chi u banic ri ja ri quixc'oji wi, quinpe chi na che i c'amic bi wuc' rech ri ix quixec'ol chila' jawije' ri in c'o wi. ");
INSERT INTO qucTNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ri ix iwetam jawije' ri quine' wi, xukuje' iwetam ri be ri copan chila', —xcha ri Jesús chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ri tat Tomás xubij che: Kajaw, man ketam taj jawije' ri que' wi la. ¿Jas ta c'u cäka'n che retamaxic ri be? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ri Jesús xch'awic, xubij che: In ri' quinc'ut ri be, ri in quinc'ut ri kas tzij, xukuje' ri in quinya na ri c'aslemal. Xak xuwi rumal wech in jun winak cäcowinic copan ruc' ri ka Tat. ");
INSERT INTO qucTNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","We ta ri ix kas iwetam nu wäch, iwetam ta u wäch ri' ri nu Tat xukuje'. Iwetam chi c'u u wäch ri' cämic rumal chi amak'el tajin quiwil u wäch ri Are', —xcha che ri tat Tomás. ");
INSERT INTO qucTNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Te ri' xubij ri tat Felipe che: Kajaw, c'utu ba' la ri ka Tat chkawäch, xuwi wa' rajwaxic chke, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ri Jesús xch'awic, xubij che: Felipe, ojer chi ri' in c'o iwuc', ¿te c'u ri' man awetam tä nu wäch? Jachin ri rilom nu wäch in, rilom u wäch ri' ri nu Tat. ¿Jas che cata' chwe chi quinc'ut ri ka Tat chiwäch? ");
INSERT INTO qucTNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿A mat quicojo chi ri in, in c'o ruc' ri ka Tat, xukuje' chi ri ka Tat c'o wuc' in? Ri tzij ri quinbij chiwe man xak tä in quinbinic. Ri ka Tat ri cäjeki wuc' in, are ri Are' ri cäbanow ri chac. ");
INSERT INTO qucTNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Chicojo' chi ri in, in c'o ruc' ri ka Tat, xukuje' chi ri ka Tat, Are c'o wuc' in. We man je ri', chixcojon ba' chwe rumal ri quinbano. ");
INSERT INTO qucTNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Kas tzij quinbij chiwe, chi jachin ri cäcojon chwe, cuban na re xukuje' ri cajmabal ri quinban in. Nimak tak cajmabal c'ut chuwäch wa' cuban na rumal chi ri in quine'c jawije' ri c'o wi ri ka Tat. ");
INSERT INTO qucTNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ronojel c'u ri quita' che ri ka Tat pa ri nu bi', ri in quinban na rech ri in u C'ojol ri Dios quink'alajisaj chi nim na u k'ij ri ka Tat. ");
INSERT INTO qucTNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ri in quinban na apachique ri quita' chwe pa ri nu bi'. ");
INSERT INTO qucTNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","We ri ix kas quiniwaj, quinimaj na ri' ri nu takanic. ");
INSERT INTO qucTNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ri in c'ut quinbochi'j na ri nu Tat chi cutak lok Jun ri quixuto', ri cuwalijisaj na iwanima', rech cäc'oji iwuc' amak'el ronojel k'ij. ");
INSERT INTO qucTNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Are wa' ri Lok'alaj Espíritu ri cubij ri kas tzij. Ri winak ajuwächulew man quecowin taj cäquic'amo rumal chi man quilom tä u wäch, xukuje' man quetam tä u wäch. Are c'u ri ix iwetam u wäch rumal chi ri Are' c'o iwuc', cäjeki c'u na pa ri iwanima' amak'el ronojel k'ij. ");
INSERT INTO qucTNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Man quixinya tä canok xak i tuquiel. Quintzelej na lok rech quinc'oji iwuc'. ");
INSERT INTO qucTNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Xak quieb oxib k'ij chic, ri winak man cäquil tä chi na nu wäch. Are c'u ri ix, ix quiwil na nu wäch. Ri ix c'ut quixc'asi na rumal chi ri in, in c'aslic. ");
INSERT INTO qucTNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Pa ri k'ij ri' ri ix quiwetamaj na chi ri in, in c'o ruc' ri nu Tat, xukuje' chi ri ix, ix c'o wuc' in. Quiwetamaj na chi ri in, in c'o iwuc' ix. ");
INSERT INTO qucTNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Jachin ri retam ri nu takanic xukuje' cunimaj wa', cuc'ut ri' chi kas tzij quinraj. Lok' c'ut quil wi na rumal ri nu Tat jachin ri quinraj. Ri in xukuje' lok' quinwil wi, quinc'ut c'u na wib chuwäch. ");
INSERT INTO qucTNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ri tat Judas (man are tä ri Judas Iscariote) xuta' che ri Jesús, xubij: Kajaw, ¿jas lo wa' chi chkawäch uj cäc'ut wi ib la, man chquiwäch tä c'u ri winak ajuwächulew? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ri Jesús xch'awic, xubij che: Jachin ri quinraj cunimaj ri' ri quinbij. Lok' c'ut quil wi na ri are' rumal ri nu Tat. Ri nu Tat, xukuje' ri in cujpe na, cujjeki' na ruc'. ");
INSERT INTO qucTNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Jachin ri man quinraj taj man cunimaj tä ri' ri quinbij. Ri tzij ri tajin quitatabej man are tä nu tzij in, xane u tzij ri nu Tat ri xintakow lok. ");
INSERT INTO qucTNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Tajin quinbij ronojel wa' we tzij ri' chiwe che tak ri k'ij ri' ri c'ä in c'o iwuc'. ");
INSERT INTO qucTNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Are c'u ri Lok'alaj Espíritu ri cutak na lok ri nu Tat pa ri nu bi' rech quixuto', rech cucu'bisaj i c'ux, ri Are' c'ut cuc'ut na ronojel chiwäch. Cuna'taj c'u na chiwäch ronojel ri nu bim chiwe. ");
INSERT INTO qucTNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ruc' utzil quixinya canok. Quinya chiwe chi cuxlan ri iwanima', man junam tä c'u wa' ruc' ri cäquiya ri winak ajuwächulew. Mäk'oxow ba' iwanima', mixej c'u iwib. ");
INSERT INTO qucTNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ri ix xito aretak xinbij chi quine'c, quinpe chi c'u na jumul chic rech quinc'oji iwuc'. We ta kas tzij quiniwaj, xixquicot ta ri' aretak xinbij chi quine' ruc' ri nu Tat. Je ri', rumal chi ri nu Tat are nim na u k'ij chnuwäch in. ");
INSERT INTO qucTNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Quinbij apan wa' we ri' chiwe c'ä mäja' cäbantajic, rech aretak cäbantaj wa', quixcojon na. ");
INSERT INTO qucTNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Man c'o tä chi q'uia tzij quinbij chiwe. Cäpe c'u ri jun ri c'o u takanic puwi' we uwächulew. Man cäcowin tä c'u ri are' cätakan pa nu wi' in. ");
INSERT INTO qucTNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Rajwaxic wi chi je' cäbantaj na wa', rech ri winak cäquetamaj chi lok' ri nu Tat chnuwäch, quinban c'ut jas ri in u takom wi. ¡Chixwalijok! Chujel bi waral, —xcha ri Jesús chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","In ri' ri juwi' uvas, ri kas utzalaj tico'n. Ri nu Tat c'ut, Are ri ajchac ri queilow ri juwi' tak uvas. ");
INSERT INTO qucTNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Conojel ri alaj tak u k'ab ri juwi' uvas ri man cäquiya tä qui wäch que'resaj na apanok. Are c'u ri cäquiya qui wäch querilo queuban qui banic rech sibalaj quewächin na. ");
INSERT INTO qucTNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ri ix ch'ajch'oj chi ri iwanima' rumal ri tijonic ri nu yo'm chiwe. ");
INSERT INTO qucTNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Chibana ba' xa jun wuc' in, jas ri in nu banom xa jun iwuc' ix. Je' jas jun alaj u k'ab ri juwi' uvas man cäcowin taj cuya u wäch xak u tuquiel we man tikil che ri rakan, je ri' xukuje' ri ix, ix je' jas jun tico'n ri man cäwächin taj we man quiban xa jun wuc' in. ");
INSERT INTO qucTNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","In ri' ri juwi' uvas. Are c'u ri ix, ix ri alaj tak u k'ab ri juwi' uvas. Jachin ri cuban xa jun wuc' in, quinban c'u xa jun in ruc' ri are', are ri' sibalaj cäwächin na. Man c'o tä c'u jas quixcowin ix chubanic we man in c'o in iwuc'. ");
INSERT INTO qucTNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Jachin ri man cuban tä xa jun wuc' in, cäq'uiäk na apanok, cächaki'j c'u na je' jas ru k'ab tak ri che' ri quemolic, queporox pa k'ak'. ");
INSERT INTO qucTNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","We ri ix xa ix jun wuc' in, man cäsach tä c'u ri nu tijonic chiwe, cuya' quita' jachique ri quiwaj, cäya'taj c'u na wa' chiwe. ");
INSERT INTO qucTNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ri nu Tat cänimarisax na u k'ij aretak ri ix je' quiban wa' jas juwi' uvas ri sibalaj cäwächinic. Je wa' ri' kas tzij quixoc che nu tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ri in quixwaj ix jas ri nu Tat quinraj in. Chitakej ba' quiwaj iwib jas ri nu banom in chiwe. ");
INSERT INTO qucTNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","We quinimaj ri nu takanic, quitakej na ri' quiwaj iwib jas ri nu banom in chiwe je' jas ri in quinnimaj ru takanic ri nu Tat, ri Are' c'ut tajin wi lok' quinrilo. ");
INSERT INTO qucTNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Je' quintzijoj wa' chiwe rech quixquicot wuc', je c'u ri' kas cäquicot na ri iwanima'. ");
INSERT INTO qucTNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ri nu takanic are wa': Chiwaj iwib chbil tak iwib, je' jas ri in quixwaj ix. ");
INSERT INTO qucTNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ri rutzil ranima' jun winak ri más nim ri cuya' cäc'oji pa ranima' are la' chi cuya ri' ru c'aslemal che qui q'uexwäch ri e utz ruc'. ");
INSERT INTO qucTNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ri ix kas ix utz wuc' in we quibano jas ri quixintak wi. ");
INSERT INTO qucTNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ya man quinbij tä patänil tak we chiwe, rumal chi ri patäninel man retam tä ri' jas ri cuban ru patrón. Xane quinbij chiwe chi kas ix utz wuc' in rumal chi nu c'utum chiwäch ronojel ri u bim ri nu Tat chwe. ");
INSERT INTO qucTNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ri ix man xinicha' tä in, xane in ri' ri xixincha' ix. Xinya c'u pi k'ab chi je' quibano jas juwi' uvas ri sibalaj cäwächinic. Ri wächinic ri quiya man cäsach tä u wäch. Je c'u ri' ri nu Tat cuya na chiwe jachique ri quita' che pa ri nu bi'. ");
INSERT INTO qucTNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Are ba' wa' ri quixintak wi: Chiwaj iwib chbil tak iwib ri jun ruc' ri jun chic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","We ri winak ajuwächulew cäquetzelaj i wäch, chiwetamaj chi in ri' xquetzelaj nu wäch nabe. ");
INSERT INTO qucTNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","We ta ri ix, ix rech ruwächulew, ri winak ajuwächulew quixcaj ta ri', je' jas ri e are' sibalaj quecaj ri cachi'l. Ri in c'ut xixincha' chquixol ri winak ajuwächulew, rumal c'u ri' ri winak ajuwächulew cäquetzelaj i wäch rumal chi man ix jun tä chi cuc'. ");
INSERT INTO qucTNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Chna'taj ba' chiwe jas ri xinbij chiwe: “Man c'o tä jun patäninel ri nim na u banic chuwäch ru patrón.” We ri in cäban c'äx chwe cumal ri winak, ri ix xukuje' cäban na c'äx chiwe cumal. We c'u qui nimam ri nu tijonic in, xukuje' cäquinimaj na ri i tijonic ix. ");
INSERT INTO qucTNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ronojel wa' we c'äx ri' cäban na chiwe cumal ri winak rumal wech in, rumal chi man quetam tä u wäch ri xintakow lok. ");
INSERT INTO qucTNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Mat c'o qui mac we winak ri' we ta mat xinpe che qui tzijobexic. Cämic c'ut man cuya' taj cäquibij chi man c'o tä qui mac. ");
INSERT INTO qucTNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Jachin c'u tak ri cäquetzelaj nu wäch in, cäquetzelaj u wäch ri' ri nu Tat xukuje'. ");
INSERT INTO qucTNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mat c'o qui mac ri' we ta mat c'o ri nu banom chquixol ri man c'o tä chi jun banowinak. Ri e are' c'ut quilom ronojel ri nu banom. Pune je ri' cäquetzelaj nu wäch in, xukuje' cäquetzelaj u wäch ri nu Tat. ");
INSERT INTO qucTNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Rajwaxic c'ut chi je' cäbantaj na wa' rumal chi kas je' quel na jas ri tz'ibtal can pa ri qui Pixab: “Xquetzelaj nu wäch, man c'o tä c'u mac xinban chquij,” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Aretak c'ut cäpe ri Jun ri cätoban chiwe, ri cuwalijisaj iwanima', ri Lok'alaj Espíritu ri cubij ri kas tzij, ri quintak na lok aretak in c'o chi ruc' ri ka Tat, ri Are' cuk'alajisaj na ri kas tzij chwij. ");
INSERT INTO qucTNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ri ix xukuje' quik'alajisaj na ri kas tzij chwij, rumal chi ri ix c'olinak wuc' petinak lok, —xcha ri Jesús chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Quinbij wa' we tzij ri' chiwe rech man cuban tä quieb i c'ux, quixtzak c'ut. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Quixesax c'u na lok pa tak ri rachoch Dios. Je ri' chi copan na ri k'ij aretak apachin ri quixcämisanic cuchomaj na chi tajin cäpatänin che ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Je' cäca'n na wa' rumal chi man c'o tä jumul ri kas xquetamaj u wäch ri nu Tat, man c'o tä c'u jumul ri xquetamaj nu wäch in. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Quinbij apan ronojel wa' chiwe, rech aretak curik ri k'ij ri', cäna'taj chiwe chi ri in nu bim chi wa' chiwe, —xcha ri Jesús. Man xinbij tä wa' chiwe petinak lok rumal chi ri in, in c'o iwuc'. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Cämic c'ut quine'c rech quinec'ol ruc' ri Jun ri xintakow lok. Man c'o tä c'u jun chiwe cuta' chwe jawije' ri quine' wi. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Xa c'u xixbisonic rumal chi xinbij wa' we tzij ri' chiwe. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Quinbij c'u ri kas tzij chiwe: Are utz na chiwe ix chi quine'c. We ta c'u man quine'c, man cäpe tä ri' ri Jun ri cäc'oji iwuc' che i to'ic, ri cuwalijisaj iwanima'. We c'u quine'c, quintak na lok. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Aretak cäpe ri Are' cuya na pa canima' ri winak chi cäquich'obo chi c'o qui mac, chi rajwaxic cäca'n ri jicomal pa ri qui c'aslemal, xukuje' chi ri Dios cuk'at na tzij pa qui wi'. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","C'o qui mac rumal chi man quecojon tä chwe. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Cäquetamaj c'u na chi rajwaxic u banic ri jicomal pa ri qui c'aslemal rumal chi ri in quine' ruc' ri nu Tat, ri ix c'ut man quiwil tä chi na nu wäch. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Cäquetamaj na chi ri Dios cuk'at na tzij pa qui wi' rumal chi ri jun ri cätakan puwi' ruwächulew k'atom chi tzij puwi' chi cäc'äjisax u wäch. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Q'uia na ri cwaj quinbij chiwe, man quixcowin tä c'u chuch'obic wa' cämic. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Aretak c'ut cäpe ri Lok'alaj Espíritu ri cubij ri kas tzij, cuc'ut na ronojel ri kas tzij chiwäch. Man xak tä c'u pa re wi cäch'awic, xane are cubij ronojel ri cuto, cuc'ut c'u na chiwäch jas ri cäbantaj na. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ri Are' cunimarisaj na nu k'ij in rumal chi cuc'am na ri wech in, cuc'ut c'u na wa' chiwäch ix. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ronojel ri c'o ruc' ri nu Tat are wech in xukuje'. Rumal ri' xinbij chi ri Lok'alaj Espíritu cuc'am na ri wech in, cuc'ut c'u na wa' chiwäch ix. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Xak jubik' chic, te c'u ri' ri ix man quiwil tä chi na nu wäch. C'ä te c'u ri' quiwil chi na jumul nu wäch pa quieb oxib k'ij, rumal chi quine'c rech quinec'ol chila' jawije' ri c'o wi ri ka Tat, —xcha chque ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Te ri' jujun chque ru tijoxelab xquitala chbil tak quib, xquibij: ¿Jas quel cubij wa'? Cubij chke chi xak jubik' chic, te c'u ri' man cäkil tä chi u wäch. C'ä te c'u cäkil chi na u wäch jumul chic pa quieb oxib k'ij rumal chi que' jela' jawije' ri c'o wi ri ka Tat. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Jas lo wa' ri craj cubij chi “xak jubik' chic”? Man cäkach'ob taj jas ri tajin cubij, —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ri Jesús xuch'obo chi c'o jas ri cäcaj cäquita' che, xubij c'u chque: Ri in xinbij chiwe chi xak jubik' chic, te c'u ri' man quiwil tä chi nu wäch. C'ä te c'u quiwil chi na jumul nu wäch pa quieb oxib k'ij. ¿A are wa' ri tajin quitala chixol chbil tak iwib? ");
INSERT INTO qucTNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Kas tzij quinbij chiwe chi ri ix quixok' na, quixbison na, are c'u ri winak ajuwächulew quequicot na. Pune c'u je ri', chi ri ix quixbison na, ri i bis cujala na pa quicotem. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Aretak cäpe ri k'ij ri quil na u wäch ri ral jun ixok, cäbisonic rumal chi xurik ri k'ij re ri k'oxom. Aretak c'ut rilom chi u wäch ri ral, man cäna'taj tä chi ri k'oxom che rumal ri quicotemal ri cuna' chi ilom u wäch jun alaj ac'al cho ruwächulew. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Je c'u ri' ri ix, cämic quixbisonic. Ri in c'ut quinwil chi na i wäch jumul chic, te c'u ri' cäquicot c'u na ri iwanima'. Are jun quicotemal wa' ri man c'o tä jun cäcowinic quesan chiwe. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Pa ri k'ij ri' man c'o tä chi jas quita' na chwe. Kas tzij quinbij chiwe chi ri ka Tat cuya na chiwe ronojel ri quita' che pa ri nu bi'. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","C'ä we cämic ri' ri ix man c'o tä jas ri i tom pa ri nu bi'. Chita' ba', cäya'taj c'u na chiwe rech kas cäquicot ri iwanima', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Nu bim wa' we tzij ri' chiwe cuc' tak c'utbal. Curik c'u na ri k'ij aretak man quintzijon tä chi iwuc' cuc' tak c'utbal. Xane chi sakil chic quintzijon na iwuc' chrij ri ka Tat. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Pa ri k'ij ri' c'o ri quita' na che ri Are' pa ri nu bi'. Man quinbij tä c'u chiwe chi quinbochi'j ri nu Tat pi wi'. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Je ri', rumal chi ri ix, ix lok' chuwäch ri nu Tat. Ix lok' chuwäch rumal chi ri in, in lok' chiwäch ix, quicoj c'ut chi ruc' ri Dios in petinak wi. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Xinel lok ruc' ri ka Tat rech quinpe waral cho we uwächulew, cämic chi c'ut tajin quinya can ruwächulew rech quintzelej ruc' ri ka Tat, —xcha ri Jesús chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Te ri' xquibij ru tijoxelab ri Jesús: Cämic kas chi sakil tajin cätzijon la, man tajin tä cäcoj la c'utbal. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Cämic ketam chic chi etam la ronojel. Man rajwaxic taj chi c'o jun c'o jas cuta' che la. Rumal ri' cäkacojo chi ruc' ri Dios petinak wi la, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ri Jesús xch'awic, xubij chque: ¿A tzij ri' chi cämic kas quixcojonic? —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Petinak c'u ri k'ij, cämic c'u ri' aretak ri ix quixjabun na. Chijujunal quitzucuj na jawije' quixe' wi, quiniya c'u na can nu tuquiel. Man quincanaj tä c'u na can nu tuquiel rumal chi ri ka Tat are c'o wuc'. ");
INSERT INTO qucTNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Quinbij wa' we tzij ri' chiwe rech cuxlan ri iwanima' rumal chi xa ix jun wuc'. Cho ruwächulew quirik na c'äx. ¡Mixej ba' iwib! Ri in c'ut, in ch'acaninak puwi' ruwächulew. ");
INSERT INTO qucTNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Aretak xbitaj wa' we tzij ri' rumal ri Jesús, xca'y chicaj, xubij: Tat, xurik ri k'ij. Nimarisaj ba' la u k'ij ri C'ojol la, rech xukuje' ri C'ojol la cunimarisaj ri k'ij la. ");
INSERT INTO qucTNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Yo'm c'u la takanic pu k'ab ri C'ojol la pa qui wi' conojel winak rech cuya ri c'aslemal ri man c'o tä u q'uisic chque ri xeya la che. ");
INSERT INTO qucTNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ri c'aslemal ri man c'o tä u q'uisic are wa' chi cäquetamaj wäch la chi xuwi ri lal, lal kas Dios, xukuje' chi cäquetamaj u wäch ri Jesucristo ri xtak la lok. ");
INSERT INTO qucTNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ri in, nu nimarisam k'ij la waral cho ruwächulew xukuje' nu q'uisom u banic ri xintak la chubanic. ");
INSERT INTO qucTNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Cämic c'ut, Tat, ya la chwe chi cänimarisax nu k'ij uc' la jas ri nu banom nabe aretak mäjok xban ruwächulew. ");
INSERT INTO qucTNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ri winak ri xecha' la chquixol ri winak cho ruwächulew rech queya la chwe, nu bim chque jachin ri lal. E ech la wa', xeya c'u la chwe. Ri e are' c'ut qui nimam ri tzij la. ");
INSERT INTO qucTNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Cämic ri e are' quetam chi ronojel ri xya la chwe uc' la petinak wi. ");
INSERT INTO qucTNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nu yo'm c'u ri tzij la chque ri xya la chwe, xquicoj c'u pa canima'. Xquich'obo chi kas tzij uc' la in petinak wi, xukuje' xquicojo chi ri lal xintakow la lok. ");
INSERT INTO qucTNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Quinbochi'n che la pa qui wi'. Man quinbochi'n tä che la pa qui wi' ri winak ajuwächulew, xane pa qui wi' ri winak ri xeya la chwe, rumal chi e ech la wa'. ");
INSERT INTO qucTNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ronojel ri wech in ech la wa', are c'u ri ech la wech in wa'. Cumal c'u ri e are' cäk'alajinic chi sibalaj nim na nu k'ij. ");
INSERT INTO qucTNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ri in man quincanaj tä chic cho ruwächulew. Ri e are' c'ut quecanaj na can cho ruwächulew. Ri in quine'c rech quinc'oji uc' la. Lok'alaj ka Tat, chechajij ba' la ruc' ri chuk'ab la ri winak ri xeya la chwe, rech kas cäca'n xa jun, jas ri in, ri lal xa uj jun. ");
INSERT INTO qucTNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Aretak xinc'oji cuc' ri e are' waral cho we uwächulew, xeinchajij xukuje' xeinto' ruc' ri chuk'ab la conojel ri xeya la chwe. Man c'o tä jun chque ri xsachic, xane xak xuwi ri jun ri yo'm chrij chi cäsachic rech je' cäbantajic jas ri cubij ri Lok' Pixab la ri Tz'ibtalic. ");
INSERT INTO qucTNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Cämic c'ut quine' chila' jawije' ri c'o wi la. Che c'u we chanim ri' ri in c'o na cho ruwächulew, quinbij can wa' we tzij ri' chque rech ri e are' kas cäquina' pa canima' ri quicotemal ri quinna' in pa ri wanima'. ");
INSERT INTO qucTNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nu yo'm ri tzij la chque. Quetzelax c'u qui wäch ri e are' cumal ri winak ajuwächulew, rumal chi ri e are' man e rech tä ruwächulew je' jas ri in man in rech tä ruwächulew. ");
INSERT INTO qucTNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Man quinta' tä che la chi queesaj la bi cho ruwächulew, xane quinbochi'n che la chi queto' la chuwäch ri Itzel. ");
INSERT INTO qucTNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Je' jas ri in man in rech tä ruwächulew, ri e are' xukuje' man e rech tä ruwächulew. ");
INSERT INTO qucTNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Chetasa la chrij ronojel u wäch mac ruc' ri kas tzij rech cäquijach quib pa k'ab la. Ri Lok' Pixab la are ri kas tzij. ");
INSERT INTO qucTNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Jas ri lal xintak la lok chquixol ri winak ajuwächulew, ri in xukuje' queintak na bi ri e are' chquixol ri winak ajuwächulew. ");
INSERT INTO qucTNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Rumal c'u quech ri e are' ri in quinjach wib pa k'ab la, rech ri e are' xukuje' cäquijach quib pa k'ab la rumal ri kas tzij, cäquitas c'u quib chrij ronojel u wäch mac. ");
INSERT INTO qucTNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Man quinbochi'n tä c'u che la xak xuwi pa qui wi' ri e are', xane xukuje' pa qui wi' ri c'ä te' quecojon na chwe, aretak cäquita ri tzij ri cäquitzijoj na ri e are'. ");
INSERT INTO qucTNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Quinbochi'n che la chi conojel ri e are' kas cäca'n na xa jun, chi kas cäca'n ta na xa jun junam kuc' uj, Tat, je' jas ri lal c'o la wuc' in, xukuje' ri in, in c'o uc' la. Kas tzij ta ba' cäca'n xa jun rech ri winak ajuwächulew cäquicojo chi lal xintakow la lok. ");
INSERT INTO qucTNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ri in nu nimarisam qui k'ij jas ri u nimarisaxic nu k'ij in banom la, rech xa e jun, je' jas ri lal ri in xa uj jun. ");
INSERT INTO qucTNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ri in, in c'o cuc', ri lal c'ut c'o la wuc' in, rech ri e are' kas cäca'n na xa e jun, rech je ri' ri winak ajuwächulew cäquich'obo chi lal xintakow la lok, xukuje' chi e lok' chuwäch la jas ri in, in lok' chuwäch la. ");
INSERT INTO qucTNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tat, lal xeyo'w la chwe, cwaj c'ut chi quec'ol na wuc' in jawije' ri quinc'oji wi na in rech cäquilo chi yo'm la chwe chi sibalaj nim nu k'ij in. Ojer c'ut in lok' chuwäch la tzaretak mäjok cäban ruwächulew. ");
INSERT INTO qucTNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tat, lal ri jicom anima' la, ri winak ajuwächulew man kas quetam tä wäch la, ri in c'ut wetam wäch la. Ri winak c'ut ri e yo'm la chwe quetam chi lal ri' xintakow la lok. ");
INSERT INTO qucTNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nu bim chque jachin ri lal, quintakej c'u na u bixic wa' chque, rech jas ri nu lok'al in chuwäch la, je' qui lok'al ri e are' chuwäch la. Je ri' rech ri in kas quinc'oji na cuc', —xcha ri Jesús che ri ka Tat. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Aretak xbitaj we tzij ri' rumal ri Jesús, xel bi ri Are'. Junam cuc' ru tijoxelab xe' ri Are' ch'äkäp che ri binel ja', Cedrón u bi'. Chila' c'o wi jun ch'äkap ulew ri e tictal wi ri che', chila' c'ut xoc wi ri Jesús e rachi'l ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ri tat Judas ri tajin cäjachow ri Jesús xukuje' retam are' ri ch'äkap ulew ri' rumal chi ri Jesús q'uia mul c'olinak chila' cuc' ru tijoxelab. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Je ri' ri tat Judas xopan chila' e rachi'l jumulaj soldados, xukuje' jujun chajinelab re ri nimalaj rachoch Dios ri e takom bi cumal ri qui nimakil ri sacerdotes xukuje' ri tata'ib fariseos. We winak ri' cuc'am qui machetes, cuc'am qui lámpara, cuc'am c'u qui chäj. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Retam chi c'u ri Jesús ronojel ri cäban na che. Rumal ri' xel apan chquiwäch ri winak, xuta' chque: ¿Jachin ri cätzucuj alak? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ri e are' xech'awic, xquibij che: Ri Jesús ri aj Nazaret, —xecha'. Ri Jesús xubij: In ri', —xcha chque. Ri tat Judas ri tajin cäjachowic c'o chila' chquixol. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Aretak ri Jesús xubij: “In ri'”, pac'alic xebe'c, xetzak c'u pulew. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Te ri' ri Jesús xuta' chi jumul chque: ¿Jachin ri cätzucuj alak? —xcha chque. Xquibij c'u ri e are': Ri Jesús ri aj Nazaret, —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Te ri' xubij ri Jesús chque: Nu bim chi chech alak chi in ri', —cächa chque. We are ri in ri quintzucuj alak, ya alak chque we niq'uiaj ri' chi quebe'c, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Je' xubij wa' ri Jesús rech je' cäbantajic jas ri xubij ri Are': “Ri xeuya ri nu Tat chwe, man c'o tä jun chque xsachic,” —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Te ri' ri tat Simón Pedro ri c'o ru machete xuc'amo, xuk'at c'u apan ru xiquin ri tat Malco ri patänil re ri qui nimal sacerdotes. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Xubij c'u ri Jesús che ri tat Pedro: Chaya chi jumul ri a machete pa ri c'olibal re. We ri nu Tat cuban chwe chi quintij ri c'a ri c'o pa ri vaso, ¿a mat rajwaxic wi chi cäpe wa' we c'äx ri' chwij? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Xepe c'u ri jumulaj soldados cachi'l ri qui nimal ri e are', xukuje' ri chajinelab re ri nimalaj rachoch Dios ri aj Israel, xquichap ri Jesús, xquiyutu. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Te ri' xquic'am bi cho rachoch ri tat Anás. Ri tat Anás are u ji' ri tat Caifás ri qui nimal sacerdotes pa ri junab ri'. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Are ri tat Caifás wa' ri u bim can nabe chque ri winak aj Israel chi are utz na chque ri e are' chi cäcäm xa jun achi che qui q'uexwäch conojel ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ri tat Simón Pedro, rachi'l jun tijoxel chic, e benak ruc' ri Jesús. Ri jun tijoxel chic ri' etamtal u wäch rumal ri qui nimal sacerdotes, rumal c'u ri' xoc bi ri are' ruc' ri Jesús pa ri uwoja rech ri rachoch ri qui nimal sacerdotes. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Are c'u ri tat Pedro xcanaj can chrij ri ja chi' ri uchibe. Xa je ri' xel lok ri tijoxel ri etamtal u wäch rumal ri qui nimal sacerdotes, xch'aw ruc' ri chajil uchibe, xrocsaj c'u bi ri tat Pedro. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ri chajil uchibe xuta' che ri tat Pedro, xubij: ¿A mat lal jun chque ru tijoxelab we achi ri'? —xcha che. Ri tat Pedro xch'awic, xubij: No, man in jun tä chque, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Sibalaj c'äx tew tajin cubano. Rumal ri' ri patäninelab xukuje' ri chajinelab qui nuc'um jun k'ak'. E tac'atoj c'u chila', tajin cäquimik' quib. Ri tat Pedro xukuje' c'o cuc', tajin c'u cumik' rib chrij ri k'ak'. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ri qui nimal sacerdotes xuchap u ta'ic che ri Jesús jachin tak ru tijoxelab, xukuje' jas ri tajin cuc'ut chquiwäch ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ri Jesús xubij che: Ri in, in tzijoninak chquiwäch conojel ri winak chi sakil. Amak'el nu yo'm tijonic pa tak ri rachoch Dios xukuje' pa ri nimalaj rachoch Dios jawije' ri cäquimulij wi quib conojel ri winak aj Israel. Je ri' chi man c'o tä jun tzij nu bim xak chi c'uyal, —cächa che. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Jas che cäta' la chwe in? Ta' la chque ri winak ri qui tom ri nu tzij, chquibij c'ut jas chrij in tzijoninak wi. Ri e are' quetam jas ri nu bim, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Aretak xbitaj wa' we tzij ri' rumal ri Jesús, jun chque ri chajinelab rech ri nimalaj rachoch Dios ri c'o chila' xuya jun k'ab chupalaj ri Jesús, te c'u ri' xubij che: ¿A je' u ch'abexic wa' ri qui nimal sacerdotes cabano? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ri Jesús xch'awic, xubij che: We c'o jun tzij xinbij ri man utz taj, bij la chwe jachique ri tzij ri man utz taj. We c'u utz ri xinbij, ¿jas che quinch'ay la? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Yutum c'u ri Jesús, xpe ri tat Anás, xutak bi ruc' ri tat Caifás, ri qui nimal ri sacerdotes. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Are c'u ri tat Pedro tac'alic tajin cumik' na rib chrij ri k'ak'. Xquita' c'u che, xquibij: ¿A mat at jun chque ru tijoxelab we achi ri'? —xecha che. Ri tat Pedro c'ut xresaj rib chupam, xubij: ¡No, man in jun tä chque! —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Te ri' xta' che rumal jun chque ri patänil tak re ri qui nimal sacerdotes, ri alaxic ruc' ri achi ri xk'at apan u xiquin rumal ri tat Pedro, xubij che: ¿A mat xinwilo chi at c'o ruc' ri Are' pa ri ch'äkap ulew ri e tictal wi ri che'? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ri tat Pedro xresaj chi jumul rib chupam, tzare chi' c'ut xok' ri ama' äc'. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Te c'u ri' xquic'am bi ri Jesús cho rachoch ri tat Caifás, xebe' cho ri nimalaj ja re ri nim k'atal tzij. Xak jubik' chic craj man cäsakiric, ri winak aj Israel c'ut man xeboc tä pa ri nimalaj ja rech man cäca'n tä ri äwas u banic. We je ri' man cuya' tä ri' cäquitij ri wi'm rech ri Pascua. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Rumal ri' ri tat Pilato xel lok che qui tzijobexic, xubij chque: ¿Jas u mac we achi ri' ri quibij ix? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ri e are' xech'awic, xquibij: We ta mat are jun banal etzelal mat xkajach wa' pa k'ab la, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Xubij c'u ri tat Pilato chque: Chic'ama bi ix, chik'ata tzij puwi'. Chibana' jas ri cubij ri i pixab ix, —xcha chque. Ri winak aj Israel xech'awic, xquibij: Ri uj, ri uj aj Israel, man ya'tal tä chke chi cäkacämisaj jun winak, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Je ri' xbantajic jas ru bim can ri Jesús chrij ri cäban na che chucämisaxic. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ri tat Pilato xoc chi bi jumul pa ri nimalaj ja, xusiq'uij ri Jesús, te c'u ri' xuta' che: ¿A at ri' ri cattakan pa qui wi' ri winak aj Israel? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ri Jesús xubij che: ¿A xak lal cäbin la wa' o niq'uiaj chic xebin che la chwij in? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ri tat Pilato xch'awic, xubij: ¿A in pu lo jun aj Israel? Ri awinakil at, xukuje' ri qui nimakil ri sacerdotes e are tak wa' ri xatjachow pa nu k'ab. ¿Jas c'u ri a banom? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Te ri' xch'aw ri Jesús, xubij che: Ri nu takanic man rech tä we uwächulew ri'. We ta rech ruwächulew, ri nu tijoxelab xech'ojin ta ri' rech mat xinjach pa qui k'ab ri winak aj Israel. Ri nu takanic c'ut man ajwaral taj, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Xubij c'u ri tat Pilato che: Je ri' chi ri at, ¿a at nim takanel? —xcha che. Ri Jesús xch'awic, xubij: In nim takanel, jas ri cäbij la, —xcha che. Ri in xil nu wäch waral cho ruwächulew chubixic jas ri' ri kas tzij. Conojel c'u ri queniman che ri kas tzij cäquitatabej ri quinbij, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ri tat Pilato xubij che: ¿Jas c'u ri' ri kas tzij? —xcha che. Xuwi xta'taj wa' che ri Jesús rumal ri tat Pilato, ri are' xel chi lok jumul che qui tzijobexic ri winak aj Israel, xubij chque: Ri in, man c'o tä jun mac quinrik chrij we achi ri', —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ri ix c'ut ix nak'atalic chi quinban tok'ob chiwe, quintzokopij bi jun ajpache' pa ri nimak'ij re ri Pascua. ¿A quiwaj chi quintzokopij bi ri tata' ri' ri c'o u takanic pi wi' ix, ix winak aj Israel? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Te ri' conojel co xech'awic, xquibij: ¡Mätzokopij la bi ri are'! ¡Are tzokopij la bi ri Barrabás! —xecha'. Are' c'u jun elak'om wa' ri Barrabás. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Te ri' ri tat Pilato xuc'am bi ri Jesús, xtakan c'u chuch'ayic. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ri soldados xquicoj jun corona re quemom q'uix chujolom ri Jesús, xquicoj c'u jun atz'iak morada chrij. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Te c'u ri' xekeb ruc', xquibij c'ut: Lal ri' ri cätakan la pa qui wi' ri winak aj Israel, ¡chnimarisax k'ij la! —xecha che. Xquich'ay c'u chupalaj. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ri tat Pilato xel lok jumul chic, xubij c'u chque ri winak: Chiwilampe', quinwesaj lok we achi ri' chiwäch rech quiwetamaj chi man c'o tä jubik' mac quinrik in chrij, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Xel c'u lok ri Jesús, cojom c'u ri corona re quemom q'uix chujolom, cojom xukuje' ri atz'iak morada chrij. Te c'u ri' xubij ri tat Pilato chque: ¡Waral c'o wi ri achi! —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Aretak ri qui nimakil sacerdotes, xukuje' ri chajinelab re ri nimalaj rachoch Dios xquilo, co xech'awic, xquibij: ¡Chripok! ¡Chripok! —xecha'. Ri tat Pilato xubij chque: ¡Chic'ama bi ix, chiripa'! Ri in man c'o tä jubik' mac quinrik in chrij, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ri winak aj Israel xech'awic, xquibij: Ri uj c'o jun ka pixab, ri ka pixab c'ut cubij chi rajwaxic cäcämisaxic rumal chi xuban che rib chi are u C'ojol ri Dios, —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ri tat Pilato, aretak xuta wa' ri xquibij, sibalaj xuxej na rib. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Xoc chi bi jumul pa ri nimalaj ja, xuta' che ri Jesús: ¿Jawije' ri catpe wi? —xcha che. Are c'u ri Jesús man xch'aw taj, man c'o tä c'u jas xubij che. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Xubij c'u ri tat Pilato che: ¿Jas che man quinach'abej taj? ¿A mat awetam chi c'o takanic pa nu k'ab che a ripic cho ri cruz o che a tzokopixic bic? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ri Jesús xch'awic, xubij che: Man c'o tä jubik' takanic la pa nu wi' we ta mat yo'm che la rumal ri Dios. Rumal ri', jachin ri xinjachow pa k'ab la nim na u mac ri' chuwäch la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Tzare chi' c'ut ri tat Pilato xutzucuj jas xubano rech cutzokopij bi ri Jesús. Are c'u ri winak aj Israel co xech'awic, xquibij: ¡We cätzokopij la bic, man utz tä anima' la ri' ruc' ri nimalaj takanel! ¡Jachin ri cuban che rib chi are nim takanel, u c'ulel ri' ri nimalaj takanel! —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ri tat Pilato aretak xuta ri xquibij, xtakan che resaxic lok ri Jesús. Ri are' c'ut xt'uyi cho ri k'atbal tzij pa ri c'olibal ri cäbix “Gabata” che pa hebreo, ri quel cubij “Lajom Abaj”. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Xa c'u chuwek chic ri nimak'ij Pascua. Craj are ri niq'uiaj k'ij. Ri tat Pilato c'ut xubij chque ri winak aj Israel: ¡Waral c'o wi ri tata' ri c'o u takanic pi wi'! —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ri e are' c'ut co xech'awic, xquibij: ¡Chcämisaxok! ¡Chcämisaxok! ¡Chripok! —xecha'. Ri tat Pilato xubij chque: ¿A quinrip ta c'u cho ri cruz ri tata' ri c'o u takanic pi wi? —xcha chque. Are c'u ri qui nimakil ri sacerdotes xech'awic, xquibij che: Ri uj man c'o tä chi jun achi chic ri cätakan pa ka wi', xane xak xuwi ri nimalaj takanel, —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ri tat Pilato xuwi xuta wa', xujach bi ri Jesús pa qui k'ab rech cäquirip cho ri cruz. Xquic'am c'u bic. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Xel c'u bi ri Jesús, xuc'am bi ru cruz, xe' pa ri juyub ri cäbix U Bakil Jolomaj che. (Pa ri ch'abal hebreo are cäbix Gólgota che.) ");
INSERT INTO qucTNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Chila' xquirip wi cho ri cruz junam cuc' quieb achijab chic, jujun pa tak u xcut. Ri Jesús xcanaj pa qui niq'uiajal. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ri tat Pilato xtakan chucojic jun tz'ibtalic puwi' ri cruz ri cubij: JESÚS AJ NAZARET RI NIM TAKANEL PA QUI WI' RI WINAK AJ ISRAEL. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","E q'uia chque ri winak aj Israel xquisiq'uij u wäch ri tz'ibtalic ri' rumal chi ri juyub ri xrip wi ri Jesús nakaj c'o wi che ri tinimit Jerusalén. Ri tz'ibtalic, tz'ibtal wa' pa ri hebreo, griego, xukuje' pa ri latín. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Rumal ri' ri qui nimakil sacerdotes quech ri winak aj Israel xquibij che ri tat Pilato: Mätz'ibaj la: “Ri Nim Takanel quech ri winak aj Israel.” Xane tz'ibaj la: “Ri cubij che rib chi are Nim Takanel quech ri winak aj Israel,” —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Are c'u ri tat Pilato xch'awic, xubij chque: Ri xintz'ibaj, xak je wa' cäcanajic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Te ri', aretak xeto'taj ri soldados churipic ri Jesús cho ri cruz, xquic'am ri ratz'iak, xca'n c'u quiejeb che, jujun que ri jujun soldados. Xukuje' xquic'am ri camixa'. Man t'isom tä c'u wa', xane xa jun u banom, quemom petinak ajsic c'ä iquim. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ri soldados xquibij chbil tak quib: Man cäkarak'atij taj. Chkesaj suerte chrij rech cäkilo jachin cäch'acowic, —xecha'. Je ri' xbantajic jas ri tz'ibtal pa ru Lok' Pixab ri Dios ri cubij: “Xquijach ri watz'iak chquiwäch, xquesaj suerte chrij,” —cächa'. Are wa' ri xca'n ri soldados. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Chunakaj ri cruz ri ripom wi ri Jesús c'o ru nan, c'o ru chak' ru nan, c'o ri nan María ri rixokil ri tat Cleofas, xukuje' c'o ri nan María ri aj Magdala. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Aretak ri Jesús xril ru nan xukuje' ri tijoxel ri sibalaj lok' chuwäch tac'al chuxcut, xubij che ru nan: Nan, chabana awal che we achi ri', —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Te c'u ri' xubij che ru tijoxel: Chabana a nan che ri nu nan, —xcha che. Tzare chi' c'ut ri tijoxel ri' xuc'am bi ru nan ri Jesús cho rachoch. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Te c'u ri' rumal chi ri Jesús retam chi ronojel ri tz'ibtal chrij bantajinak chic, xukuje' rech kas cäbantajic jas ri cubij ru Lok' Pixab ri Dios, xubij: Cächaki'j nu chi', —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","C'o c'u apan jun lak nojinak che ch'äm vino. Xquirub c'u jun estropajo chupam ri vino ri', xquiya puwi' jun aj, te c'u ri' xquiya ak'an chuchi' ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ri Jesús xutij ri ch'äm vino, te c'u ri' xubij: Ronojel xbantajic, —xcha'. Xupachba c'u ru jolom, xel ranima'. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Xa c'u chuwek chic ri nimak'ij Pascua. Man cäcaj tä c'u ri winak aj Israel chi ri qui cuerpo ri winak quecanaj can cho tak ri cruz pa ri k'ij re uxlanem. Ri k'ij re uxlanem ri' are jun k'ij wa' nim u banic. Rumal ri' xquita' che ri tat Pilato chi cätakan chuk'ajisaxic ri cakan ri e ripil cho tak ri cruz, xukuje' chi cäkasax ri qui cuerpo cho ri cruz. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Te ri' xebe' ri soldados, xquik'ajisaj ri rakan ri nabe xukuje' ri jun chic ri e ripom ruc' ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Aretak c'ut xekeb ruc' ri Jesús, xquilo chi cäminak chic, xa je ri' man xquik'ajisaj tä ri rakan ri Are'. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pune je ri' jun chque ri soldados xujak ru c'alc'ax ri Jesús ruc' jun lanza, chanim c'ut xel lok quic' xukuje' joron. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ri cäbin wa' we tzij ri', are jun ri kas xrilo, kas tzij c'u ri cubij. Ri are' cubij ri kas tzij ri retam rech ri ix xukuje' quixcojonic. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Je c'u xc'ulmataj wa' rech cäbantajic jas ri tz'ibtal pa ru Lok' Pixab ri Dios ri cubij: “Man c'o tä jun bak xquik'ajisaj che,” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Cubij xukuje' ru Lok' Pixab ri Dios pa jun u xak chic: “Cäquil na ri xquisoco,” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Te c'u ri' xpe ri tat José ri quel pa ri tinimit Arimatea, xuta' che ri tat Pilato chi cäyi' che chi cukasaj ru cuerpo ri Jesús. Ri tat José are jun u tijoxel ri Jesús, xa c'u chi c'uyal rumal chi cuxej rib chquiwäch ri winak aj Israel. Xyi' c'u che rumal ri tat Pilato. Xa je ri' xe' ri tat José, xukasaj ru cuerpo ri Jesús, xuc'am c'u bi pa mukic. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Xpe xukuje' ri tat Nicodemo ri nabe canok xopan ruc' ri Jesús chak'ab chutzijobexic. Ri are' ruc'am jun cunabal, are mirra ri yujtal ruc' áloes, ri cäpajan cien libras. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Je ri' ri tat José rachi'l ri tat Nicodemo xquic'am bi ru cuerpo ri Jesús, xquipis c'u pa tak manta re lino ri yo'm ri c'oc'alaj tak cunabal chrij. Je' xca'n che jas ri e nak'atal wi ri winak aj Israel che qui mukic ri cäminakib. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Pa ri juyub ri xrip wi ri Jesús cho ri cruz, c'o jun ch'äkap ulew ri e tictal wi ri che'. Pa ri ulew ri' c'o jun c'ac' mukubal ri mäja' yo'm jun cäminak chupam. ");
INSERT INTO qucTNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Chupam c'ut xquiya wi ru cuerpo ri Jesús, rumal chi ri mukubal ri' nakaj c'o wi, xukuje' rumal chi xa jubik' craj man cächaptaj ri k'ij re uxlanem chque ri winak aj Israel. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Pa ri nabe k'ij re ri semana, sibalaj ak'ab, k'ekum na, ri nan María ri aj Magdala xe' chuchi' ri mukubal. Xril c'ut chi esam chi apan ri abaj ri tz'apibem u chi' ri mukubal. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Xa je ri' xutic anim, xe'c, xurika ri tat Simón Pedro, xukuje' ri jun tijoxel chic ri sibalaj lok' chuwäch ri Jesús, xubij chque: Ri Kajaw Jesús xesax bi pa ri mukubal, xc'am bic, man ketam tä c'ut jawije' ri xyi' wi, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Te ri' ri tat Pedro rachi'l ri jun tijoxel chic xebel bic, xebe' chuchi' ri mukubal. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ri quieb xquitic anim, junam e benak. Are c'u ri jun chic sibalaj xutic na anim chuwäch ri tat Pedro. Ri are' xopan nabe chi' ri mukubal. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Man xoc tä c'u pa ri mukubal, xane xak xuwi xpachi cok che rilic. Te' xrilo chi e c'o can ri manta chila'. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Te c'u ri' xopan chi ri tat Simón Pedro, ri teren lok chrij. Ri are' c'ut xoc bi pa ri mukubal. Xukuje' xeril ri manta ri e c'o can chila'. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Xukuje' xrilo chi ri manta ri xpispex u jolom ri Jesús man junam taj c'o cuc' ri niq'uiaj manta chic, xane botom wa', yo'm c'u apan jela'. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Te c'u ri' xoc chi bi ri jun tijoxel chic ri xopan nabe chuchi' ri mukubal. Xrilo ri bantajinak, xcojon c'u ri are'. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Mäja' c'u cäquich'obo jas ri cubij ru Lok' Pixab ri Dios ri Tz'ibtalic chi are rajwaxic chi ri Jesús cäc'astaj na chquixol ri cäminakib. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Te ri' xetzelej we quieb tijoxelab ri' cho cachoch. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Are c'u ri nan María xcanaj can chuchi' ri mukubal, tajin cok'ic. C'ä tajin cok'ic aretak xpachi'c rech cäca'y cok chupam ri mukubal. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Te' xrilo chi e c'o quieb ángeles, ri e t'uyut'oj jawije' ri xyi' wi ru cuerpo ri Jesús, sakloloj c'u ri catz'iak. Ri jun t'uyul pu jolom, ri jun chi c'ut t'uyul pa rakan. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ri ángeles xquita' che ri nan María, xquibij: Nan, ¿jas che tajin cok' la? —xecha che. Ri nan María xubij chque: Rumal chi xquic'am bi ri Wajaw Jesús, man wetam tä c'ut jawije' ri xyi' wi, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Te' xbitaj wa' rumal, aretak xca'y chrij, xrilo chi c'o ri Jesús chila'. Man xuch'ob tä c'ut chi are ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Xpe c'u ri Jesús, xuta' che, xubij: Nan, ¿jas che tajin catok'ic? ¿Jachin c'u ri tajin catzucuj? —xcha che. Ri nan María xuchomaj chi are ri chajinel re ri ulew ri', xubij che: Tat, we lal xc'amow la bic, bij la chwe jawije' ri xya wi la rech ri in quinc'am bic, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Te ri' xubij ri Jesús che: ¡María! —xcha che. Ri are' xca'y chrij, te c'u ri' xubij che pa hebreo: ¡Raboni! —xcha che. Ri tzij ri' quel cubij “Ajtij”. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ri Jesús xubij che: Minachapo rumal chi c'ä mäja' quinpaki chila' jawije' ri c'o wi ri nu Tat, —xcha'. Jat ba', jabij c'u chque ri wachalal chi quinpaki chila' jawije' c'o wi ri nu Tat, ri xukuje' ri i Tat ix, ri nu Dios c'ut, ri xukuje' are ri i Dios ix, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Te ri' xe' ri nan María ri aj Magdala, xubij c'u chque ri tijoxelab chi ri are' xril u wäch ri Kajaw Jesús, xukuje' chi ri Jesús xubij wa' we tzij ri' che. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Kas pa ri k'ij ri', ri nabe k'ij re ri semana, chak'ab chic qui mulim quib ri tijoxelab. Qui tz'apim c'u ri u chi' tak ja rumal chi xquixej quib chquiwäch ri winak aj Israel. Xoc bi ri Jesús, xtaq'ui c'u chquixol. Xuya rutzil qui wäch, xubij chque: Chuxlan ba' ri iwanima', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Aretak xbitaj wa' we tzij ri' rumal, xuc'ut ru k'ab chquiwäch xukuje' ru c'alc'ax. Ri tijoxelab xequicotic aretak xquil u wäch ri Kajaw Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Te c'u ri' ri Jesús xubij chi jumul chque: Chuxlan ba' ri iwanima', —xcha'. Je' jas ri nu Tat xinutak lok in, je ri' ri in xukuje' quixintak bi ix, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Te c'u ri' xuya ri ruxlab pa qui wi', xubij: Chic'ama ri Lok'alaj Espíritu, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Jachin tak ri quisach ri qui mac, cäsachtaj na ri qui mac. Jachin tak ri man quisach tä ri qui mac, man cäsachtaj tä na ri qui mac, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ri tat Tomás, jun chque ri cablajuj u tijoxelab ri Jesús ri cäbix Gemelo che, man c'o tä ri are' aretak xopan ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Te c'u ri' ri niq'uiaj tijoxelab chic xquibij che ri tat Tomás: Xkil u wäch ri Kajaw Jesús, —xecha che. Are c'u ri tat Tomás xubij chque: We man quinwil ri soctajinak ri xuban ri clawux pu k'ab, te c'u ri' quinnim ru wi' nu k'ab pa tak ri jul, xukuje' quinnim ri nu k'ab pa ru c'alc'ax, man quincoj taj, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Oc'owinak chi wajxakib k'ij. Ri tijoxelab qui mulim quib jumul chic pa jun ja, c'o chi c'u ri tat Tomás cuc' ri e are'. Te ri', pune e tz'apil ru chi' tak ja, ri Jesús xoc bic, xtaq'ui c'u chquixol. Xuya rutzil qui wäch, xubij: Chuxlan ba' ri iwanima', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Te c'u ri' xubij che ri tat Tomás: Chawilampe ri nu k'ab, chanima c'u bi ru wi' a k'ab waral. Chayuku ra k'ab, chanima c'u bi pa ri nu c'alc'ax. Muban chi quieb a c'ux, xane chatcojon chwe, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Te ri' xch'aw ri tat Tomás, xubij che: ¡Wajaw, nu Dios! —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ri Jesús xubij che: Tomás, ri at cämic xatcojon chwe rumal chi xawil nu wäch. Utz c'u que ri quecojon chwe pune man cäquil nu wäch, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Q'uia c'u cajmabal tak etal xuban na ri Jesús chquiwäch ru tijoxelab ri man xetz'ibax tä pa we wuj ri'. ");
INSERT INTO qucTNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Xetz'ibax c'u wa' ri c'o waral rech ri ix quicojo chi ri Jesús are ri Cristo, ru C'ojol ri Dios, rech aretak quixcojon che ri Are', quirik na ri c'aslemal ri man c'o tä u q'uisic, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Te c'u ri' ri Jesús xuc'ut rib jumul chic chquiwäch ru tijoxelab chi' ri mar re Tiberias. Je wa' xuban chuc'utic rib: ");
INSERT INTO qucTNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Conojel wa' junam e c'olic. Ri tat Simón Pedro, ri tat Tomás ri cäbix Gemelo che, ri tat Natanael ri aj Caná re Galilea, ri quieb u c'ojol ri tat Zebedeo, xukuje' quieb chic chque ru tijoxelab ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ri tat Simón Pedro xubij chque: Quine' chuchapic cär, —xcha chque. Ri e are' xquibij che: Ri uj xukuje' cuje' awuc', —xecha che. Xebe' c'ut, xeboc pa jun barco, man c'o tä c'u cär xquichap pa ronojel ri jun ak'ab ri'. ");
INSERT INTO qucTNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Aretak tajin cäpe ru sakiric, ri Jesús xuc'ut rib chquiwäch chi' ri mar, are c'u ru tijoxelab man xquich'ob taj chi are ri Are'. ");
INSERT INTO qucTNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Te ri' xubij chque: ¡Ix achijab! ¿A mat c'o ri i chapom? —xcha chque. Ri e are' xech'awic, xquibij: Man c'o taj, —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Te ri' xubij ri Jesús chque: Chiq'uiäka ri c'at pa ru wiquiäk'ab ri barco, c'o c'u na ri quichapo, —xcha ri' chque. Je' c'u xca'no. Te ri' man xecowin tä chi c'u che resaxic lok ri c'at chapäbal cär pa ri ja' rumal chi sibalaj xnoj ri c'at che tak cär. ");
INSERT INTO qucTNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Te ri' ri tijoxel ri sibalaj lok' chuwäch ri Jesús xubij che ri tat Pedro: ¡Are ri Kajaw Jesús! —xcha che. Xuwi xuta wa' ri tat Simón Pedro chi are ri Kajaw Jesús, xucoj ri ratz'iak rumal chi resam wa'. Xuq'uiäk c'u bi rib pa ri ja'. ");
INSERT INTO qucTNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ri niq'uiaj tijoxelab chic xeopan chi' ri ulew chupam ri barco, qui jururem ri c'at nojinak che tak cär. Xa c'u cien metros xec'oji wi che ru chi' ri ulew. ");
INSERT INTO qucTNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Aretak xebel pa ri barco, te' xquilo c'o jun k'ak' nuc'um, c'o c'u jun cär pa ri rachak k'ak', xukuje' e c'o jujun caxlan wa. ");
INSERT INTO qucTNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ri Jesús xubij chque: Cheic'ama lok jujun chque ri cär ri c'ä te' xechaptaj iwumal, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Xpaki c'u ri tat Simón Pedro pa ri barco, xresaj c'u lok ri jun c'at chapäbal cär nojinak che tak cär. Xujururej c'u lok wa' chi' ri ulew. ¡Nojinak c'u ri c'at! E c'o jun ciento ruc' cawinak oxlajuj nimak tak cär chupam. Pune sibalaj e q'uia ri cär, ri c'at man xt'okopin taj. ");
INSERT INTO qucTNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Te ri' xubij ri Jesús chque: Chixsa'j, chixwok ba', —xcha chque. Man c'o tä c'u jun chque ru tijoxelab xuchajij anima' xuta' che jachin ri Are' rumal chi conojel quetam chi are ri Kajaw Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Te c'u ri' ri Jesús xkeb cuc', xuc'am c'u ri caxlan wa, xuya chque. Je' xukuje' xuban ruc' ri cär. ");
INSERT INTO qucTNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Are urox mul wa' ri xuc'ut rib ri Jesús chquiwäch ru tijoxelab aretak ya c'astajinak chic chquixol ri cäminakib. ");
INSERT INTO qucTNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Aretak xtijtaj ri qui wa re ak'abil, ri Jesús xuta' che ri tat Simón Pedro, xubij che: Simón, u c'ojol ri tat Jonás, ¿a kas lok' na quinawil in chquiwäch conojel tak wa'? —xcha che. Ri tat Pedro xch'awic, xubij: Je', je ri', Wajaw. Etam ya' la chi cwaj la, —xcha che. Ri Jesús xubij che: Cheayuk'uj ba' ri alaj tak nu chij, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Chucamul chic xuta' che: Simón, u c'ojol ri tat Jonás, ¿a kas lok' na quinawilo? —xcha che. Ri tat Pedro xch'awic, xubij che: Je', Wajaw. Etam ya' la chi cwaj la, —xcha che. Ri Jesús xubij che: Cheayuk'uj ba' ri nu chij, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Churox mul chic xuta' che: Simón, u c'ojol ri tat Jonás, ¿a kas quinawaj? —xcha che. Ri tat Pedro xbisonic rumal chi xuta' che churox mul we kas lok' chuwäch, xubij c'u che: Wajaw, etam la ronojel. Etam ya' la chi kas cwaj la, —xcha che. Ri Jesús xubij che: Cheayuk'uj ba' ri nu chij, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Kas tzij quinbij chawe, chi aretak at ala na, ri at xacoj ri awatz'iak, xate'c jawije' ri xawaj xate' wi. Aretak c'ut catrijobic, cayuk na ri a k'ab, jun chi c'ut cäcojow na ri awatz'iak chawij, catuc'am c'u na bi chila' jawije' ri man cawaj tä wi, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ri Jesús xubij wa' we tzij ri' chubixic che jas u wäch cämical ri curik na ri tat Pedro, cunimarisaj c'u na u k'ij ri Dios. Te c'u ri' xubij che: ¡Tasa'j wuc'! —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Aretak xca'y ri tat Pedro chrij, xrilo chi teren ri tijoxel chquij ri sibalaj lok' chuwäch ri Jesús, ri xt'uyi chuxcut ri Jesús chi' ri mesa aretak xca'n ri q'uisbal wi'm re benak k'ij, ri xuta' che ri Jesús, xubij: “Wajaw, ¿jachin ri' ri cäjachow na la?” —xcha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Aretak ri tat Pedro xrilo, xubij che ri Jesús: Kajaw, wa' we jun ri', ¿jas ri cuc'ulmaj na ri are'? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ri Jesús xch'awic, xubij che: We ri in cwaj chi cäc'asi na ri are' c'ä quintzelej na lok, ¿jas awe at che? Ri at tasa'j wuc', —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Xel c'u u tzijol wa' chquixol ri kachalal chi ri tijoxel ri' man cäcäm taj. Man xubij tä c'u ri Jesús che chi man cäcäm taj, xane xubij: “We cwaj chi cäc'asi na ri are' c'ä quintzelej na lok, ¿jas awe at che?” —xcha ri Jesús che ri tat Pedro. ");
INSERT INTO qucTNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Are c'u wa' ri tijoxel ri xuk'alajisaj chi kas tzij wa' ri xutz'ibaj canok. Ketam c'ut chi cubij ri kas tzij. ");
INSERT INTO qucTNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Sibalaj q'uia chi c'u na ri xuban ri Jesús. We ta quetz'ibax wa' chquijujunal, quinchomaj chi man cubana tä ronojel ruwächulew che c'olibal que ri wuj ri quetz'ibax na. Amén.");
INSERT INTO qucTNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Lok'alaj tat Teófilo: Pa ri nabe nu wuj ri xintz'ibaj che la, xintzijon chrij ronojel ri xuban ri Jesús, xukuje' chrij ronojel ri xuc'ut canok chquiwäch ri winak aretak xuchaplej u patänixic ri Dios waral chkaxol. ");
INSERT INTO qucTNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Pa ri nabe nu wuj xintzijon chrij nimalaj ronojel ri xuban ri Are' c'ä xc'am na bi chicaj. Aretak mäja' que' chicaj, xuya takanic, xeupixbaj can ri apóstoles ri xeucha'. Rumal ri Lok'alaj Espíritu ri c'o ruc', xubij can chque jas ri rajwaxic cäca'no. ");
INSERT INTO qucTNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Xurik c'äx ri Jesús, xcämisaxic, te c'u ri' xuc'ut rib chquiwäch ri apóstoles chwinakil rech k'alaj chi c'astajinak chic chquixol ri cäminakib. Q'uia ri xuban chquiwäch rech cäquicojo chi kas tzij c'asal chic ri Are'. Cawinak k'ij ri' xuc'ut na rib chquiwäch amak'el. Xukuje' xtzijon cuc' chrij ri cuban na ri Dios aretak cätakan pa qui wi' ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Aretak ri Jesús c'ä c'o cuc' ri apóstoles, xubij chque chi mebel bic pa ri tinimit Jerusalén chanim, xane chi queye'nic. Je wa' xubij: Chiweyej na chi cäyataj chiwe ri bim lok rumal ri nu Tat, jas ri xinbij chiwe, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Kas tzij, ri tat Juan xuban qui kasna' ri winak ruc' ja', are c'u ri ix xa pa quieb oxib k'ij cäban na i kasna' ruc' ri Lok'alaj Espíritu, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Are c'u ri apóstoles qui mulim quib ruc' ri Jesús, xquita' c'u che ri Are', xquibij: Kajaw, ¿a mat xopan ri k'ij ri cäya la chque ri ka winakil chi quetakan chi na jumul puwi' ri ka tinimit Israel rech man cäquitakej tä takanic ri niq'uiaj winak chic pa ka wi'? —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Xch'aw c'u ri Jesús, xubij chque: Ri k'ij, ri ajilabal, man ya'tal tä chiwe ix chi quiwetamaj, xane xak xuwi pu k'ab ri ka Tat c'o wi ronojel wa'. ");
INSERT INTO qucTNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Aretak c'ut cäpe ri Lok'alaj Espíritu pi wi', cäc'oji na i chuk'ab. Te c'u ri' quixe'c, quitzijoj na jas ri i wilom chi xinban che qui to'ic ri winak, jas ri xinc'ulmaj aretak xincämisaxic, xukuje' aretak xinc'astaj chquixol ri cäminakib. Ronojel wa' quitzijoj na pa Jerusalén, pa tak conojel ri tinimit re Judea, re Samaria, xukuje' c'ä pa tak ri qui tinimit ri winak ri sibalaj naj e c'o wi cho ruwächulew, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Aretak ri Jesús xto'taj chubixic wa' we tzij ri' chque ri apóstoles, xyac bi chicaj chquiwäch. Ri e are' tajin queca'y che aretak xpaki chicaj, xch'uktaj c'u rumal jun sutz', man xecowin tä chic xquilo. ");
INSERT INTO qucTNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ri e are' tajin queca'y chicaj che ri Jesús, xak c'u te'talic xquic'ut quib quieb achijab pa qui xcut ri sibalaj sak ri catz'iak. ");
INSERT INTO qucTNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","We achijab ri' xech'awic, xquibij chque ri apóstoles: Tata'ib, alak ri' ri aj Galilea, ¿jas che xak c'o alak chi', tajin cäca'y alak chicaj? —quecha chque. We Jesús ri' ri xyac bi chxol alak, xpaki chicaj, cäpe chi na ri Are' jumul chic. Je c'u wa' ru petic jas ri xubano, xe' chicaj, —xecha ri achijab chque ri apóstoles. ");
INSERT INTO qucTNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Te c'u ri' xekaj lok ri apóstoles cho ri juyub ri xec'oji wi, ri cäbix Ujuyubal Olivos che. Xetzelejic, xebe' pa ri tinimit Jerusalén. Nakaj c'o wi ri juyub ri' che ri Jerusalén, man naj tä c'u ri cäbinibaxic, xuwi ri ya'talic chi cäbin jun pa ri k'ij re uxlanem (craj are jun kilómetro wa'). ");
INSERT INTO qucTNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Aretak xeopan pa ri tinimit, xepaki pa ru cawik ja re ri ja ri e jekel wi. Ri e c'olic e are' ri tat Pedro, ri tat Jacobo, ri tat Juan, ri tat Andrés, ri tat Felipe, ri tat Tomás, ri tat Bartolomé, ri tat Mateo, ri tat Jacobo u c'ojol ri tat Alfeo, ri tat Simón ri cäbix “U Nimal Tinimit” che, rachi'l ri tat Judas, rachalal ri tat Jacobo. ");
INSERT INTO qucTNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Conojel wa' we apóstoles ri' junam ri qui chomanic xquimulij quib amak'el rech cäca'n orar junam cuc' jujun ixokib cojonelab, cachi'l ri nan María ru nan ri Jesús, xukuje' tak ri rachalal. ");
INSERT INTO qucTNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Pa tak ri k'ij ri' qui mulim quib ri cojonelab. Craj e are' jun ciento ruc' juwinak ri' ri qui mulim quib. Xwalij c'u ri tat Pedro, xtaq'ui chquiwäch ri kachalal che qui ch'abexic, xubij chque: ");
INSERT INTO qucTNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Kachalal, tzrajwaxic wi chi cäbantajic jas ri cubij ru Lok' Pixab ri Dios ri Tz'ibtalic, ri xubij lok ri Lok'alaj Espíritu chuchi' ri ka mam David ojer, —cächa'. Ri ka mam David xch'aw chrij ri Judas ri xc'amow qui be ri jumulaj winak ri xechapow ri Kajaw Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ri Judas jun ri are' chkaxol nabe, xyi' che chi cächacun junam kuc'. ");
INSERT INTO qucTNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Are c'u ri are' xulok' jun rulew ruc' ri puak, ri tojbal re ri etzelal ri xubano. Ch'iquilic xkajic, xtzak pulew, xrak'atin ru pam, xel lok juntir ri rixco'l, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Xel c'u u tzijol wa' ri xuc'ulmaj ri Judas chquixol conojel ri winak pa ri tinimit Jerusalén. Xa je ri' ri winak xquicoj ri tzij Acéldama che ru bi' ri ulew ri'. Ri tzij ri' pa ri qui ch'abal ri winak quel cubij Ulew re Quic'. ");
INSERT INTO qucTNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Tz'ibtal c'u pa ri wuj Salmos, cubij: Chtoli' can u pam ri rachoch, chwonobax canok, mat c'o chi na jun cäc'oji chupam, —cächa'. Xukuje' cubij: Ri rekle'n ri are', chyo'k che jun winak chic, —cächa', —xcha ri tat Pedro chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","E c'o c'u achijab chkaxol ri xujcachi'laj amak'el aretak xc'oji ri Kajaw Jesús kuc'. ");
INSERT INTO qucTNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Tzaretak ri xban u kasna' ri Jesús rumal ri tat Juan, c'ä aretak xc'am bi ri Are' chicaj chkaxol, e c'olinak we achijab ri' kuc'. Tzrajwaxic c'ut chi jun chque ri e are' coc kuc' chutzijoxic chi kas tzij xc'astaj bi ri Kajaw Jesús chquixol ri cäminakib, —xcha ri tat Pedro chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Xquichomaj c'u quij quieb achijab: E are' ri tat José ri cäbix Barsabás che, ri xukuje' cäbix Justo che, rachi'l ri tat Matías. ");
INSERT INTO qucTNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Xca'n orar, xquibij: Kajaw, etam la ri canima' conojel ri winak, c'utu ba' la chkawäch jachin chque we quieb achijab ri' are cha'tal umal la, ");
INSERT INTO qucTNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","rech coc ri' che apóstol, cuc'am c'u ri ekle'n ri xuya can ri Judas aretak xkaj pa mac, xe' c'u chila' jawije' ri ya'tal wi che, —xecha che ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Xquesaj c'u suerte che rilic jachin ri cäcanajic. Are c'u ri suerte xkaj chrij ri tat Matías. Xoc c'u ri are' cuc' ri julajuj apóstoles. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Aretak xurik ri nimak'ij ri cäbix Pentecostés che, conojel ri cojonelab junam qui wäch qui mulim quib pa jun ja. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Xak te'talic xquita jun nimalaj jininem ri xpe chicaj, je' jas jun nimalaj quiäkik' ri xjinin pa ronojel ri ja jawije' ri e t'uyul wi ri cojonelab. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Te ri' c'o ri xquilo, je' ta ne jas jujun u xak k'ak' ri xkaj pa qui jolom chquijujunal. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Je ri' ri Lok'alaj Espíritu xuchap canima' conojel, xquichaplej ch'awem pa jule' tak ch'abal chic ri xeuya ri Lok'alaj Espíritu chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Pa tak ri k'ij ri' e jekel pa ri tinimit Jerusalén achijab aj Israel ri queniman che ri Dios, ri e petinak pa conojel tak ri tinimit cho ruwächulew. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Aretak xquita wa' jas ri xquic'ulmaj ri cojonelab, xquimulij quib q'uia winak. Man xquirik taj jas cäca'no rumal chi chquijujunal ri winak xquito chi ri cojonelab quech'aw pa ri jalajoj tak qui ch'abal ri e are'. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Xquixej c'u quib, sibalaj xquicajmaj ri tajin cäbanic. Xquitzijobela quib, xquibij: ¡Chiwilampe'! ¿A mat aj Galilea conojel wa' we winak ri' ri tajin quech'awic? ");
INSERT INTO qucTNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Jas lo u banic wa' chi quech'aw pa ri ka ch'abal uj ri ketamam lok tzpa ri ka ch'utinal? —quecha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Q'uia u wäch ri tinimit ri uj petinak wi. Chkaxol uj, ri uj c'o waral, e c'o winak ri aj Partia, aj Media, aj Elam, aj Mesopotamia, aj Judea, aj Capadocia, aj Ponto, aj Asia. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Xukuje' e c'o kuc' ri aj Frigia, aj Panfilia, aj Egipto. E c'o c'u niq'uiaj chic ri ajchila' pa África, ri e petinak jela' chrij ri tinimit Cirene. E c'o xukuje' winak aj Roma chkaxol. Jujun chque ri e are' e kas aj Israel, ri kas winak aj Israel ri qui nan qui tat. Jujun chic c'ut xa e oquinak cuc' ri aj Israel winak, junam ri qui chomanic chrij ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Xukuje' e c'o winak aj Creta, xukuje' aj Arabia, —quecha'. Konojel c'ut quekato chi cäquitzijoj tzpa ri ka ch'abal uj chkajujunal ri nimak tak cajmabal ri u banom ri Dios, —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Sibalaj qui cajmam quib conojel ri winak, man xquirik tä c'u jas cäca'no. Xquitzijobela quib, xquitala chbil tak quib, xquibij: ¿Jas lo u banic wa'? —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","E c'o jujun ri xa xquitze'j qui wäch ri cojonelab, xquibij c'ut: ¡Wa' we winak ri' xa e k'abarelab! —xecha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Te c'u ri' ri tat Pedro, junam cuc' ri julajuj apóstoles chic, xwalijic, xtaq'ui chquiwäch ri winak che qui ch'abexic. Co xch'awic, xubij c'u chque conojel ri e c'olic: Tata'ib, alak aj Judea, xukuje' onojel alak ri jekel alak waral pa Jerusalén, tatabej na alak ri quinbij, chetamaj alak wa', —cächa chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Konojel ri uj ri ka mulim kib waral, man uj k'abarelab taj jas ri cächomaj alak. C'ä te ne u belej hora rech ri ak'abil chanim ri'. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Xane ri tajin quil alak cämic ri' are wa' ru bim lok ri ka mam Joel ri k'alajisal re ru Lok' Pixab ri Dios. Are c'u wa' ri xubij: ");
INSERT INTO qucTNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ri Dios cubij: Pa ri q'uisbal tak k'ij quintak na bi ri Lok'alaj Espíritu wech in pa qui wi' conojel winak, —cächa'. Ri i c'ojol xukuje' ri i mia'l cäquik'alajisaj na ri tzij ri quinya chque. Ri alabom ri e c'o chixol c'o ri cäquil na ri quinc'ut chquiwäch, ri tata'ib c'ut ri c'o chi ri qui junab c'o ri cäquil na pa ri cachic', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Xukuje' pa tak ri k'ij ri' quintak na bi ri Espíritu wech in pa qui wi' ri patänil tak we, chi achijab chi ixokib, cäquik'alajisaj c'u na ri tzij ri quinya chque, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Quinban tak na cajmabal cho ri caj xukuje' cho ruwächulew. Ri quinbano e are' etal wa' chiwe. Xak apawije' quilitaj wi na ri quic', ri k'ak', xukuje' nimak tak sib je' jas ri sutz', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ri k'ij cäk'ekumar na, ri ic' cäquiäkar na je' jas ri quic', cäc'ulmataj c'u wa' c'ä mäjok curika na ri nimalaj u k'ij ri Kajaw Dios. Ri k'ij ri' kas tzij sibalaj nim u banic. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Conojel c'u ri cäquita' na tok'ob che ri Kajaw Dios, cäquirik na ru tobanic ri Are', —cächa', —xcha ri apóstol Pedro chque ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Xutakej tzij ri tat Pedro, xubij: Tata'ib, alak aj Israel, tatabej na alak ri quinbij, —cächa chque. Ri alak, etam alak chi ri Jesús aj Nazaret are wa' ri achi ri xyi' u k'ij rumal ri Dios chuc'utic chi are ri Are' takowinak lok. K'alaj wa' chuwäch alak cumal tak conojel ri cajmabal ri xubano, ri nimak tak c'utbal, xukuje' ri etal ri xeuban ri Dios chxol alak rumal ri Are', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Pune ta ne je ri', aretak xjach ri Jesús pa k'ab alak, xchap alak, xya alak pa qui k'ab itzel tak achijab chucämisaxic, xquirip c'u cho ri cruz. Je' xban alak wa' che rumal chi je wa' ru chomam lok ri Dios chrij ojer, —cächa ri tat Pedro chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pune c'u je wa' ri xbantajic, xpe ri Dios, xresaj pu k'ab ri cämical, xuc'astajisaj chi na ri Jesús chquixol ri cäminakib, rumal chi man c'o tä jas cäcowin ri cämical chubanic che. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kas ojer c'ut ch'awinak lok ri ka mam David chrij ri Kajaw Jesús, xubij: Ri in amak'el quinwil ri Kajaw c'o wuc'. C'o pa nu wiquiäk'ab rech man c'o tä jas ri cäcowin jun chubanic chwe chi quinxej wib, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Rumal ri' sibalaj cäquicot ri wanima', amak'el quintzijoj tzij re quicotemal, cu'l c'u nu c'ux chrij ri Dios chi man c'o tä jun kas c'äxc'ol quinriko, cuxlan c'u ri wanima'. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Man quinya tä la can chquixol ri cäminakib, man cäya tä la chi cäk'ay ri nu cuerpo in, in ri' ri lok'alaj patänil e la. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","C'utum la ri be chnuwäch ri cäc'aman bi pa ri kas c'aslemal, c'o c'u na nimalaj nu quicotemal aretak ri in c'o chi uc' la, —cächa', —xcha ri tat Pedro. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Kachalal, ri alak aj Israel, tampe alak ri quinbij: K'alaj ri' chi ri ka mam David xcäm ri' ri are', xmuktajic. Ri jul ri xmuk wi xak are c'o waral kuc' uj cämic, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ketam c'ut chi ri ka mam David are jun k'alajisal re ru Lok' Pixab ri Dios, ri are c'ut xucoj ri tzij ri xubij ri Dios che ruc' juramento, chi jun chque ri rachalaxic ri quil na u wäch pa tak ri k'ij ri quepe na, are ri Cristo ri cäyi' na takanic pu k'ab. Coc che Nim Takanel je' jas ri ka mam David. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ri ka mam David je' ta ne chi ojer tajin cäril lok ri cuc'ulmaj ri Cristo, xch'aw chrij ru c'astajibal. Xubij c'ut chi man cäcanaj tä can chquixol ri cäminakib, man cäk'ay tä na ru cuerpo, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Are c'u wa' we Jesús ri' ri xc'astajisax rumal ri Dios, ri uj konojel kas xkilo chi xc'astaj wa' chquixol ri cäminakib. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Xwalijisax rumal ri Dios, xnimarisax u k'ij aretak xut'uyuba pa ru wiquiäk'ab. Aretak c'ut u c'amom chic pu k'ab ru Tat ri Lok'alaj Espíritu ri xuchi'j canok, xutak lok pa ka wi', are c'u wa' ronojel ri tajin quil alak, ri tajin cäta alak, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Pune c'u man xpaki ri ka mam David chicaj, jas ri xuban ri Kajaw Jesús, tzare c'ut xbinic: Xubij ri Kajaw ri ka Dios che ri Wajaw: “Chatt'uyul pa ri nu wiquiäk'ab, ");
INSERT INTO qucTNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","c'ä quinya na chawe chi catch'acanic, cattakan pa qui wi' conojel ri cäca'n qui c'ulel chawe,” —cächa ri Dios, —xcha ri ka mam David. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Kas rajwaxic chi conojel ri winak aj Israel chquetamaj chi we Jesús ri' ri xcämisaj alak cho ri cruz, are wa' xcha'ic, xban Cristo che rumal ri Dios, xoc c'u che Rajaw ronojel, —xcha ri tat Pedro chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Aretak ri winak xquita wa' we tzij ri', sibalaj c'äx xquina' pa canima', xquita' c'u che ri tat Pedro xukuje' chque ri niq'uiaj apóstoles chic, xquibij: Kachalal, ¿jas rajwaxic cäka'no? —xecha chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ri tat Pedro xubij chque: Chq'uexa ri anima' alak, xukuje' ri chomanic alak. Rajwaxic chi cäban kasna' alak chjujunal alak pa ru bi' ri Jesucristo, xa je ri' cäsach mac alak rumal ri Dios, ri Are' c'ut cusipaj ri Lok'alaj Espíritu chech alak. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Are chech alak ri Dios xuchi'j wi wa', chque ri alc'ual alak, xukuje' chque ri winak ri naj e c'o wi, chque c'u conojel ri quesiq'uix na rumal ri Dios ri Kajaw rech quec'oji na ruc', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ri tat Pedro q'uia xubij chque. Cuc' tak wa' we tzij ri' xeuch'abej, xeupixbaj, xubij chque: Chto' ib alak, ya' alak can ri itzel tak winak re we k'ij junab ri', ri man jicom tä ri qui c'aslemal, —xcha ri tat Pedro chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Conojel c'u ri xquic'am pa canima' ru Lok' Pixab ri Dios ri xutzijoj ri tat Pedro, xban c'u qui kasna'. Craj e oxib mil ri' ri xeboc cuc' ri cojonelab pa ri k'ij ri'. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Conojel c'u ri xecojonic, xquitakej u banic jas ri xquic'ut ri apóstoles chquiwäch, xquimulij quib ruc' quicotemal, junam xca'n orar, junam c'ut xquitij ri qui wa. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Sibalaj xquixej quib conojel ri winak, rumal chi q'uia u wäch cajmabal xukuje' tak etal xeban cumal ri apóstoles. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Conojel ri e cojoninak che ri Cristo xa jun qui chomanic, xquijachala ri jastak que chbil tak quib. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Xquiq'uiyij ri culew, xukuje' ri jastak que. Are c'u ri rajil xquijachala chquiwäch ri c'o qui rajwaxic. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ronojel k'ij xquimulij quib pa ri nimalaj rachoch Dios, xukuje' xquimulij quib cho tak cachoch ri cojonelab, xquijach ri wa chquiwäch conojel. Junam c'ut xewi'c, xequicotic, man c'o tä jun cuna' pa ranima' chi nim u banic. ");
INSERT INTO qucTNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Xquiya c'u u k'ij ri Dios, nim xe'il wi cumal conojel ri winak. Ri Dios xubano chi ronojel k'ij e c'o niq'uiaj winak chic ri cäquirik ru tobanic ri Are'. Xeuya c'u ri winak ri' cuc' ri kachalal cojonelab. ");
INSERT INTO qucTNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Jun k'ij xepaki'c, xebe' ri tat Pedro rachi'l ri tat Juan pa ri nimalaj rachoch Dios pa ri u rox hora re ri benak k'ij, ri hora ri cäban ri oración. ");
INSERT INTO qucTNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Chila' c'ut c'o jun achi ri man xcowin taj xbinic rumal ri c'äx ri c'o che ri rakan tzpa tak ri k'ij ri xil u wäch. Xyi' c'u wa' chuchi' ri nimalaj rachoch Dios chi' ri uchibe ri cojom Sibalaj Je'lic che ru bi'. Je' c'u xban wa' che ri achi ronojel k'ij rech cuta' u limosna chque ri winak ri queboc bi pa ri nimalaj rachoch Dios. ");
INSERT INTO qucTNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Aretak ri achi xeril ri quieb apóstoles, ri tat Pedro, ri tat Juan oquem que pa ri rachoch Dios, xuta' jun u limosna chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ri e are' c'ut co xeca'y che, xubij c'u ri tat Pedro: Chatca'y chke, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ri achi co xca'y chque, xuchomaj are' chi c'o jas cäyi' can che cumal. ");
INSERT INTO qucTNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Are c'u ri tat Pedro xubij che: Man c'o tä nu rajil, man c'o tä sak puak, man c'o tä k'än puak. Are c'u ri c'o wuc' quinya na chawe. Rumal ri Jesucristo aj Nazaret, pa ru bi' ri Are', chatwalijok, chatbinok, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ri tat Pedro xuchap che ru wiquiäk'ab, xuyaco. Chanim c'ut xecowir ri rakan ri achi, xukuje' ru kul tak rakan. ");
INSERT INTO qucTNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Xa je ri' ri achi ri u banom c'äx ri rakan xuq'uiäk rib, xtaq'uic, xuchaplej binem. Xoc c'u bi junam cuc' ri apóstoles pa ri nimalaj rachoch Dios, xbinic, xuq'uiäk rib, xuya u k'ij ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Conojel c'u ri winak xquilo chi tajin cäbinic, xukuje' chi tajin cuya u k'ij ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Sibalaj c'u xquicajmaj wa' ri xuc'ulmaj ri achi, man xquirik tä c'ut jas cäca'no rumal chi xquetamaj u wäch ri achi chi are ri cät'uyi ronojel k'ij chuta'ic u limosna chuwäch ri nimalaj rachoch Dios pa ri porta ri cojom Sibalaj Je'lic che ru bi'. ");
INSERT INTO qucTNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ri achi ri u banom c'äx ri rakan nabe, ri xcunatajic, ri are' man xutzokopij tä ri tat Pedro, ri tat Juan. Conojel c'u ri winak sibalaj qui cajmam quib, xquitij anim, xquimulij quib chquij ri quieb apóstoles pa ri rakan ja ru bi' Rakan Ja re Salomón ri e c'o wi ri e are'. ");
INSERT INTO qucTNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Aretak ri tat Pedro xrilo chi xquimulij quib ri winak, xubij chque: Kachalal, alak aj Israel, ¿jas che cäcajmaj alak wa' ri xbantajic? ¿Jas che co cujca'yej alak? ¿A xa cächomaj alak chi ruc' ri ka chuk'ab uj o xa rumal chi sibalaj uj nimanelab che ri Dios xka'no chi cäbin we achi ri'? ");
INSERT INTO qucTNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Man je' tä ri', xane are ru Dios ri ka mam Abraham, ri ka mam Isaac, xukuje' ri ka mam Jacob, are Dios wa' xa xunimarisaj u k'ij ri Jesús, ri lok'alaj u C'ojol ri xjach alak pa qui k'ab ri k'atal tak tzij. Aretak ri tat Pilato xuchomaj u tzokopixic bic, ri alak man xaj tä alak. ");
INSERT INTO qucTNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Man xaj tä alak chi cätzokopix ri lok'alaj u C'ojol ri Dios ri kas jicom ranima', xane xbij alak chi are utz cätzokopix jun cämisanel chuq'uexwäch ri Are'. ");
INSERT INTO qucTNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Xak je ri' xcämisaj alak ri Jesús, ri jun ri cäyo'w ri kas c'aslemal chque ri winak. Ri Dios c'ut xuc'astajisaj ri Are' chquixol ri cäminakib. Ri uj c'ut xkilo chi kas tzij xc'astajic. ");
INSERT INTO qucTNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Rumal c'u ri cojonic che ru bi' ri Jesús xutzir we achi ri' ri quil alak, ri etam alak u wäch. Ri cojonic ri' che ri Jesús, are wa' xbanowic chi xutzir canok we achi ri' chuwäch onojel alak, —cächa ri tat Pedro. ");
INSERT INTO qucTNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Wetam c'u in, kachalal, chi ri alak, xukuje' ri c'amal tak be alak, xcämisaj alak ri Jesús rumal chi man kas cäch'ob alak ri tajin cäban alak. ");
INSERT INTO qucTNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ri Dios c'ut xuya' chi je wa' xbanic, rech je' quel wi ri u bim lok ri Are' cumal conojel ri ojer tak k'alajisal re ru Lok' Pixab, chi ri Cristo ri cha'tal rumal ri Dios curik na c'äx. ");
INSERT INTO qucTNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Rumal ri' chq'uexa anima' alak, tzelej ba' alak ruc' ri Dios rech quesachtaj ri mac alak, —cächa'. We je' cäban alak wa', ri Dios cubano chi quepe na k'ij re jororemal rech cuxlan anima' alak. ");
INSERT INTO qucTNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Xukuje' cutak na lok ri Jesús ri ojer ri' cha'talic rech coc che Cristo che to'ic alak. ");
INSERT INTO qucTNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Che we chanim ri' rajwaxic chi ri Jesucristo cäc'oji na can pa ri caj c'ä cutzirisax c'u na ronojel rumal ri Dios, cäban na u banic ronojel wa' jas ri u banom nabe, je' jas ri xubij lok ri Dios chquichi' ri lok'alaj tak k'alajisal re ru Lok' Pixab ojer, —cächa ri tat Pedro. ");
INSERT INTO qucTNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Rumal ri' ri ka mam Moisés xubij chque ri ka nan ka tat ojer: “Ri Kajaw ri ka Dios cucha' na jun chque ri i winakil, cutak c'u na rech coc che k'alajisal re ru Lok' Pixab, je' jas ri xinutak in. Rajwaxic c'ut chi quinimaj ronojel ri cubij chiwe,” —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","“Apachin c'u ri man cuta tä ri cubij ri k'alajisal re ru Lok' Pixab ri Dios ri', quesax na bi pa ri tinimit Israel, cäsachisax c'u na u wäch,” —xcha ri ka mam Moisés, —cächa ri tat Pedro. ");
INSERT INTO qucTNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Conojel c'u ri k'alajisal re ru Lok' Pixab ri Dios, cächapletaj lok ruc' ri ka mam Samuel, xukuje' ri c'ä te xepe chic, conojel wa' ri xek'alajisanic, xquiya lok u bixic wa' ri tajin cäc'ulmataj cämic, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ronojel ri xuchi'j lok ri Dios cumal tak ri k'alajisal re ru Lok' Pixab ri Are', ech alak wa'. Ri Dios c'ut xuban jun trato cuc' ri ka mam ojer chubanic utzil chech alak, aretak xubij che ri ka mam Abraham: “Conojel ri winak cho ruwächulew quetewchitaj c'u na cumal ri awachalaxic ri quil na qui wäch,” —xcha ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Aretak ri Dios xuc'astajisaj ru C'ojol chquixol ri cäminakib, nabe xutak bi uc' alak, alak ri' ri winak aj Israel, rech cätewchix na alak, rumal chi ri Are' cubano chi chjujunal alak cätas ib alak chrij ri etzelal, —xcha ri tat Pedro chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ri tat Pedro rachi'l ri tat Juan c'ä tajin cäquitzijobej ri winak aretak xepe ri sacerdotes aj Israel, cachi'l ri qui nimakil ri chajil tak re ri nimalaj rachoch Dios, xukuje' ri tata'ib saduceos, xeopan c'u cuc'. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Sibalaj yactajinak coyowal, rumal chi ri tat Pedro, ri tat Juan tajin quequitijoj ri winak, cäquibij chi kas tzij quec'astaj chi na ri cäminakib. Cäquibij c'ut chi are c'utbal wa' chque conojel chi xc'astaj ri Jesús chquixol ri cäminakib. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Xequichapo, xequic'am bic, xequicoj c'u pa che' c'ä chucab k'ij, rumal chi ya na'tam chic. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","E q'uia chque ri xquita ru Lok' Pixab ri Dios ri xecojonic. We queajilax xak xuwi ri achijab, craj e job mil ri e are'. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Chucab k'ij c'ut xquimulij quib pa Jerusalén ri c'amal tak qui be ri winak aj Israel, ri qui nimakil ri winak, xukuje' ri tijonelab re ri Pixab. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Xquirik quib cuc' ri tat Anás rachi'l ri tat Caifás, ri kas qui nimakil sacerdotes. E c'o ri tat Juan, ri tat Alejandro, xukuje' conojel ri cachalal ri qui nimakil sacerdotes. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Xquitac'aba c'u ri tat Pedro, ri tat Juan chquiwäch, xquic'ot qui chi', xquibij chque: ¿Jachin ri yo'winak pa i k'ab chi quiban ri tajin cäkilo? ¿Jas u bi' ri quicojo rech quixcowinic quiban wa'? —xecha chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ri tat Pedro, kajinak ri Lok'alaj Espíritu puwi', xubij chque: Tata'ib, alak ri c'amal tak qui be ri winak, alak ri' ri qui nimakil ri winak aj Israel, ");
INSERT INTO qucTNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","cämic cäc'ot alak ka chi' rumal ri utzil ri xbantaj che jun achi yawab che retamaxic jas ri xban chucunaxic. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Chetamaj ba' alak xukuje' conojel ri winak aj Israel chi rumal ri Jesucristo aj Nazaret, pa ru bi' ri Are', xcunataj wa' we achi ri' ri c'o chuwäch alak. Ri Jesús ri xcämisaj alak cho ri cruz, ri xc'astajisax rumal ri Dios chquixol ri cäminakib, are ri Are' xcunan we achi ri'. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","We Jesús ri' are wa' ri abaj ri man xaj tä alak, alak ri' ri yacal tak ja, are abaj wa' xcoj che tok'ebal re ri ja. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Man cäriktaj tä ru tobanic ri Dios ruc' jachin jun winak, xane xak xuwi ruc' ri Jesús. Je ri', rumal chi ri Dios man u yo'm tä chke ru bi' jachin jun chic cho ronojel ruwächulew, ri ya'tal che chi rumal ri are' cuya' cäkarik na ru tobanic ri Dios, —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Aretak ri k'atal tak tzij xquilo chi ri tat Pedro, ri tat Juan man cäquixej tä quib quech'awic, xukuje' xquilo chi xak e winak ri man c'o tä ri q'uia quetamam chrij wuj, sibalaj xquicajmaj wa'. Te c'u ri' xquich'obo chi e are' tak wa' jujun chque ri xerachi'laj ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Xukuje' xquilo chi c'o ri achi ri xcunatajic tac'al cuc' ri apóstoles, xa je ri' man xquirik tä chic jas cäquibij. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Xquibij c'u chque ri apóstoles chi quebel bi chquiwäch, are c'u ri e are' xecanajic, xquitzijobela c'u quib. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Xquibij: ¿Jas cäka'n chque we achijab ri'? Kas tzij c'ut etamtal chic cumal conojel ri winak pa ri tinimit Jerusalén ri cajmabal etal ri ca'nom. Man cuya' tä c'ut cäkabij chi man kas tzij taj. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Je ba' ka'na wa', rech man cäbin tä más u tzijol ri xbantajic. Chekaxibij rech man quetzijon tä chic chuwek cäbij chrij ri Jesús che jachin jun, —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Xequisiq'uij c'ut, xetakan chque chi man c'o tä chi jumul cäquitzijoj chic ri Jesús, man cäquiya tä chi c'u tijonic pa ru bi' chque ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Xech'aw c'u ri tat Pedro rachi'l ri tat Juan, xquibij: Kas chomaj alak ri', ¿a are utz lo cäril ri Dios chi are cujniman chech alak chuq'uexwäch ri cäkanimaj ri Are'? ");
INSERT INTO qucTNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ri uj c'ut man cujcowin taj ri mat cäkabij chi na ri kilom xukuje' ri ka tom, —xecha chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ri k'atal tak tzij xcaj xequixibij ri apóstoles, q'uia ri xquibij chque, xequitzokopij c'u bic. Man xquirik taj jas cäca'n chuc'äjisaxic qui wäch, rumal chi conojel ri winak tajin cäquiya u k'ij ri Dios rumal ri xbantajic. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ri achi ri xbantaj wi ri cajmabal cunanic c'o chi na cawinak u junab ruc' u wi'. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Aretak ri tat Pedro, ri tat Juan e tzokopital chic, xebe' cuc' ri niq'uiaj cojonelab chic, xquitzijoj ronojel ri xbix chque cumal ri qui nimakil ri sacerdotes xukuje' conojel ri qui nimakil ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Aretak xquita wa', junam xca'n orar, xquibij che ri Dios: Nimalaj Kajaw, lal ri' ri kas Dios ri xbanow ri caj, ri ulew, ri mar. Ronojel ri c'olic, xbantaj c'u wa' umal la. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tzojer c'ut bim la lok rumal ri Lok'alaj Espíritu chuchi' ri ka mam David ri patänil e la, xbij la: ¿Jas lo wa' chi ri winak cho ruwächulew yactajinak coyowal, xak quetontiric, cäca'n c'u nimal? ¿Jas che wa' chi ri winak cäquichomaj u banic ch'oj ri man c'o tä u beyal? ");
INSERT INTO qucTNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ri nimak tak takanelab cho ri uwächulew junam xquiwalijisaj quib, ri qui nimakil ri winak xquimulij quib rech cäquiyac quib chrij ri Kajaw Dios, xukuje' chrij ri Cristo ri cha'tal rumal ri Dios, —xcha la, —quecha ri cojonelab. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Xquitakej oración, xquibij: Kas c'u tzij wi xquirik quib ri nim takanel Herodes ruc' ri tat Poncio Pilato waral ri' pa we tinimit junam cuc' ri niq'uiaj winak chic cachi'l ri winak aj Israel, xquimulij c'u quib chrij ri lok'alaj C'ojol la, ri Jesús, ri cha'tal umal la. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Je' xca'n wa' rech je' cäbantajic jas ri chomam la lok chi rajwaxic cäbanic. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Kajaw, chilampe la cämic ri' chi q'uia ri tajin cäquibij we winak ri' chkij. Ya la chke uj, ri uj patänil tak e la, chi cujcowinic cäkatzijoj ri Lok' Pixab la, man c'o tä cäkaxej wi kib. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Xukuje' cäkata' che la chi cäc'oji ke ri chuk'ab la chubanic cunanic chque ri yawabib, xukuje' che qui banic ri cajmabal tak etal, xukuje' nimak tak c'utbal pa ru bi' ri lok'alaj C'ojol la, ri Jesús, —xecha che ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Aretak xeto'taj chubanic orar, ri ja ri e c'o wi xslabisaxic, conojel c'ut xkaj ri Lok'alaj Espíritu pa qui wi', man xquixej tä quib xquitzijoj ru Lok' Pixab ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ri q'uia winak ri e cojoninak che ri Cristo, xa jun qui chomanic conojel, cäquina' pa canima' chi xa e jun. Man c'o tä jun cubij chi xak xuwi rech are' ri c'o ruc', xane conojel ri jastak que, are quech conojel wa'. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ri apóstoles ruc' nimalaj chuk'ab xquitakej u tzijoxic chi kas tzij xc'astaj ri Kajaw Jesús chquixol ri cäminakib. Ri Dios c'ut cuya nimalaj tak tewchibal pa qui wi' conojel ri cojonelab. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Xa je ri' man c'o tä jun chquixol ri c'o u rajwaxic, rumal chi conojel ri c'o culew o ri c'o cachoch xquiq'uiyij wa'. Are c'u ri rajil xquic'am bi cuc' ri apóstoles. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Cäquiya wa' we puak ri' pa qui k'ab, ri e are' c'ut cäquijach wa' chquiwäch ri c'o qui rajwaxic. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Xak je ri', c'o jun tata', jun chque ri levitas, José u bi', ri xil u wäch pa Chipre, jun ch'äkap ulew wa' ri c'o pa ri mar. Ri tata' ri' xukuje' cäbix Bernabé che cumal ri apóstoles. Quel cubij wa' chi are jun ri cucu'bisaj qui c'ux ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","We achi ri' c'o jun ch'äkap rulew xuq'uiyij, xuc'am c'u bi ri rajil, xujach pa qui k'ab ri apóstoles. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","C'o c'u jun achi chic u bi' Ananías, ri rixokil are Safira u bi'. Junam xquichomaj u q'uiyixic jun ch'äkap culew. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ri achi xresaj can jubik' che ri puak ri rajil ri ulew, retam c'u wa' ri rixokil. Je ri' xa niq'uiaj ri puak xuc'am bic, xujach pa qui k'ab ri apóstoles, je' ta ne chi are tz'akat ri puak ri xyi' cumal. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Xpe c'u ri tat Pedro, xubij che ri tat Ananías: Ananías, ¿jas che xya la che ri Satanás chi coc pa ri anima' la, xban la tzij che ri Lok'alaj Espíritu ruc' ri subunic ri xban la, xesaj c'u la can niq'uiaj che ri rajil ri ulew ri xq'uiyij la? ");
INSERT INTO qucTNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿A mat ech la ri ulew aretak mäjok cäq'uiyij la? Aretak xq'uiyij la ri ulew, ¿a mat ech la ri puak? —cächa'. ¿Jas c'u che xchomaj la wa' pa anima' la? Man are tä chque ri winak ri xban wi la tzij ruc' ri subunic, xane are che ri Dios ri xban wi la, —xcha ri tat Pedro che. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Aretak ri tat Ananías xuta wa' we tzij ri', xtzak pulew, xcämic. Conojel c'u ri xetow ri xbantajic sibalaj xquixej quib. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Xepe c'u ri alabom, xquipis ru cuerpo pa jun payu', xquic'am bic, xe'quimuku canok. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Craj oc'owinak chi oxib horas xopan ri rixokil ri tat Ananías. Man retam tä c'ut jas ri xbantajic. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Xubij c'u ri tat Pedro che: Bij la chwe, ¿a je' puak wa' ri xbij alak chi xyi' che ri ulew ri xq'uiyij alak? —cächa'. Xubij c'u ri ixok: Je', jela' ri puak, —xcha che ri tat Pedro. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ri tat Pedro xubij che ri ixok: ¿Jas che xchomaj alak junam chi cäcowin alak chubanic ri subunic che ri Lok'alaj Espíritu rech ri Kajaw? —cächa'. Chilampe la, xak chi' ri porta chic e c'o wi ri alabom ri xe'quimuku can ri achajil la, cäc'am na bi la xukuje' cumal ri e are', —xcha ri tat Pedro che. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Chanim xtzak ri nan Safira pulew chuwäch ri tat Pedro, xcämic. Aretak xeboc bi ri alabom, c'ä te xquilo cäminak ri nan Safira. Xquic'am c'u bic, xe'quimuku can chuxcut ri rachajil. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Conojel ri kachalal cojonelab, xukuje' conojel ri xquita wa' ri xbantajic, sibalaj xquixej quib. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Sibalaj c'u q'uia u wäch tak cajmabal, xukuje' nimak tak c'utbal tajin quebantaj chquixol ri winak cumal ri apóstoles. Conojel ri cojonelab c'ut tajin cäquimulij quib amak'el pa ri rakan ja re ri nimalaj rachoch Dios, ri cäbix Rakan Ja re Salomón che. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Man c'o tä jun chque ri niq'uiaj winak chic cucoch'o coc cuc' ri cojonelab, pune sibalaj nim que'il wi cumal ri winak re ri tinimit. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","E q'uia c'u ri xecojon che ri Kajaw Jesús, chi achijab chi ixokib, je ri' chi sibalaj xeq'uiar ri cojonelab. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Xa cumal ri cajmabal ri tajin cäca'n ri apóstoles, ri winak xequesaj lok ri qui yawab pa tak ri be, xequiya pa tak ch'at, cho tak pop rech aretak coc'ow ri tat Pedro chquixcut, xuwi ta ne ru nanoch' cäkaj pa qui wi' rech queutziric. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Xukuje' ne ri winak ri quebel pa tak ri tinimit ri e c'o chunakaj ri Jerusalén, xquic'am lok ri qui yawab cachi'l ri tajin cäquirik c'äx cumal ri itzelalaj tak espíritus ri e c'o chque. Conojel c'ut xecunatajic. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Are c'u ri qui nimal sacerdotes, xukuje' conojel ri rachi'l, ri winak ri cäbix saduceos chque, sibalaj c'äx cäquina' chquij ri apóstoles rumal chi sibalaj nim que'il wi cumal ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Xequichapo, xequicoj pa che' jawije' e c'o wi ronojel u wäch ajpache'. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Xpe c'u jun ángel ri xtak lok rumal ri Kajaw Dios, chak'ab c'ut xujak ri porta rech ri che', xeresaj lok, xubij chque: ");
INSERT INTO qucTNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Jix pa ri nimalaj rachoch Dios, chixtac'al chila' che qui tzijobexic ri winak chrij wa' we c'ac' c'aslemal ri', —xcha ri ángel chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Xquita ri xbix chque rumal ri ángel. Je c'u ri' chucab k'ij xeboc pa ri nimalaj rachoch Dios, xquichap c'u qui tijoxic ri winak. E c'o ri apóstoles chila' aretak ri qui nimal sacerdotes cuc' ri rachi'l xequisiq'uij conojel ri qui nimakil ri winak aj Israel xukuje' conojel ri nimak tak tata'ib rech cäquimulij quib. E are' tak wa' xetakan bi che qui c'amic lok ri apóstoles pa che'. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Aretak c'ut xeopan ri tako'n pa che', man xequirik tä c'u ri apóstoles. Xetzelejic, xequiya u bixic wa'. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Je wa' xquibij: Aretak ri uj xujopanic xkilo chi ri che' utz banom che u tz'apixic, xukuje' chi ri chajinelab e c'o chi' tak ri porta. Aretak c'ut xkajako, c'ä te xkilo chi man c'o tä jun chupam, —xecha chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Aretak xquita wa' we tzij ri', ri kas qui nimal sacerdotes, xukuje' ri c'amal qui be ri chajil tak re ri nimalaj rachoch Dios, xukuje' ri qui nimakil ri sacerdotes xquita'la chbil tak quib, xquibij: ¿Jas ta lo ri cäc'ulmataj chi na? —xecha'. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Chanim c'ut xopan jun achi, xubij chque: Ri achijab ri xcoj alak pa che', chanim e c'o pa ri nimalaj rachoch Dios, tajin quequitijoj ri winak, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Chanim ri c'amal qui be ri chajil tak re ri nimalaj rachoch Dios, xe' che quilic ri apóstoles, xeuc'am c'u bi ri chajinelab che rachi'l. Xeuc'am lok ri tat Pedro, ri tat Juan ruc' utzil, man c'o tä c'u jas xuban chque rumal chi cuxej rib chquiwäch ri winak, we ne ri are' cäban che abaj cumal. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Aretak xec'amtaj lok, xequiya chquiwäch ri qui nimakil ri winak ri qui mulim quib. Xpe ri qui nimal sacerdotes, xuc'ot qui chi', xubij: ");
INSERT INTO qucTNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","¿A mat xkabij chiwe ruc' pixbenic chi man queitijoj tä chic ri winak chrij ri Jesús? ¡Chiwilampe ri i banom! Cämic c'ut i jabum ri i tijonic pa ronojel we tinimit Jerusalén. Xukuje' quibij chi uj ri uj ajchak' mac che ru cämical we achi ri' ri Jesús, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ri tat Pedro, xukuje' ri niq'uiaj apóstoles chic xech'awic, xquibij che: Tzrajwaxic wi are cäkanimaj ri cubij ri Dios nabe chuwäch ri cäquibij ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ri qui Dios ri ka mam ojer xuc'astajisaj ri Jesús ri xcämisaj alak, ri xrip alak cho ri cruz. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Tzare wa' we Dios ri' xunimarisaj u k'ij ri Jesús, xut'uyuba pa ru wiquiäk'ab, xucoj che C'amal Be chque ri winak, xukuje' xucoj che To'l Que. Je' xuban wa' rech ri winak aj Israel cäquiq'uex canima', cäquiq'uex qui chomanic, cäquirik c'u ri sachbal qui mac. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ri uj xkilo chi xc'astaj ri Jesús, rumal ri' ri Dios uj u cojom che k'alajisal tak re chquiwäch ri winak junam ruc' ri Lok'alaj Espíritu ri u yo'm ri Dios chque ri queniman che, —xecha chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ri qui nimakil ri winak, aretak xquita wa' sibalaj xpe coyowal. Are cäcaj quequicämisaj ri apóstoles. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","C'o c'u jun tata' chquixol ri qui nimakil ri winak, Gamaliel u bi', are tijonel re ri Pixab, jun fariseo. Nim quil wi ri are' cumal ri winak. Ri are' xtaq'ui ak'anok, xubij chi que'esax na bi jun rat ri apóstoles. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Te c'u ri' xubij chque ri qui nimakil ri winak: Kachalal, alak aj Israel, kas chomaj na alak jas ri cäban alak chque we achijab ri'. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Chna'taj chech alak chi xque' quieb oxib junab wa', xwalij jun achi, Teudas u bi', ri xuban che rib chi nim u banic. E quiejeb ciento achijab ri xeboc ruc'. Xcämisax c'u ri are', xa je ri' conojel ri e c'o ruc' xejabunic, xq'uis c'u u wäch juntir. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Bantajinak chi wa', xwalij chi jun tata', Judas u bi', aj Galilea, aretak tajin cäban ri censo, queajilax c'u ri winak. E q'uia c'ut ri xeboc ruc'. Xcämisax c'u ri are' xukuje'. Xa je ri' conojel ri e c'o ruc' xejabunic. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Rumal ri' quinbij chech alak chi are utz na we cäya can alak we achijab ri', mänim ib alak cuc'. We ri tajin cäquitzijoj o ri tajin cäca'no are quech ri winak, cäsach na u wäch wa'. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","We c'u ne rech ri Dios, man cäcowin tä alak cäsach alak u wäch. Chilampe alak chi mäyac ne ib alak chrij ri Dios, mäch'ojin alak ruc' ri Are', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Conojel ri qui nimakil ri winak xquinimaj ri xubij ri tat Gamaliel. Xequisiq'uij c'u ri apóstoles, xequich'ayo, xequirapuj. Te c'u ri' xquiya takanic chque chi man c'o tä chi jumul cäquitzijobej ri winak pa ru bi' ri Jesús. Te c'u ri' xequitzokopij bic. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ri apóstoles c'ut xebel bi chquiwäch ri qui nimakil ri winak, xequicotic rumal chi ri Dios xuya chque chi cäquirik q'uixbalalaj c'äxc'ol rumal ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Man xquitanaba tä c'u u tzijoxic ri Utzalaj Tzij re ri Evangelio chrij ri Jesucristo ronojel k'ij. Xequitijoj c'u ri winak pa ri nimalaj rachoch Dios, xukuje' cho tak ja. ");
INSERT INTO qucTNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Pa tak ri k'ij ri' sibalaj xeq'uiar ri cojonelab. Are c'u ri cojonelab ri quech'aw pa griego xquichap u yaquic tzij chquij ri cojonelab ri quech'aw pa hebreo. Ri winak ri quech'aw pa griego cäquibij chi ri malca'nib ri e c'o cuc' man junam tä cäban che quilic aretak cäjach ri wa. ");
INSERT INTO qucTNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Are c'u ri apóstoles xequimulij conojel ri cojonelab, xquibij c'u chque: Uj ri', ri uj apóstoles, man utz taj chi mat cäkatakej u tzijoxic ru Lok' Pixab ri Dios mac rech uj cujjachow ri wa. ");
INSERT INTO qucTNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kachalal, tzucuj ba' alak wukub achijab chxol alak. We achijab ri' rajwaxic chi utz ri qui c'aslemal, k'alaj chi cätakan ri Lok'alaj Espíritu pa canima', c'o quetambal, cäkaya c'u pa qui k'ab ru jachic ri wa. ");
INSERT INTO qucTNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Are c'u ri uj cäkatakej u banic orar, xukuje' cäkatakej u tzijoxic ru Lok' Pixab ri Dios, —xecha ri apóstoles chque ri cojonelab. ");
INSERT INTO qucTNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Conojel c'ut utz xquita ri xquibij ri apóstoles. Xquicha' c'u ri tat Esteban. Ri are' are jun tata' ri sibalaj cäcojon che ri Dios, xukuje' k'alaj chi ri Lok'alaj Espíritu cätakan pa ranima'. Xukuje' xquicha' ri tat Felipe, ri tat Prócoro, ri tat Nicanor, ri tat Timón, ri tat Parmenas, xukuje' ri tat Nicolás ri aj Antioquía ri ojer oquinak cuc' ri winak aj Israel, junam ru chomanic chrij ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Te c'u ri' xequiya we achijab ri' chquiwäch ri apóstoles. Ri e are' c'ut xquiya qui k'ab pa qui wi', xca'n orar. ");
INSERT INTO qucTNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Are c'u ru Lok' Pixab ri Dios xjabun u wäch, sibalaj xeq'uiar ri cojonelab pa ri tinimit Jerusalén. Xukuje' sibalaj e q'uia chque ri sacerdotes aj Israel xeniman che ri Utzalaj Tzij re ri Evangelio. ");
INSERT INTO qucTNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Sibalaj nim c'u ru tok'ob ri Dios c'o puwi' ri tat Esteban, xukuje' yo'm nimalaj u chuk'ab rech cuban nimak tak etal chquixol ri winak, xukuje' nimak tak cajmabal. ");
INSERT INTO qucTNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Xewalij c'u jujun achijab ri quepe pa jun rachoch Dios ri cojom “Quech Tzokopim Achijab” che ru bi', xquichap c'u tzij ruc' ri tat Esteban. Xepe chi c'u niq'uiaj achijab chic chrij. E c'o ri aj Cirene, aj Alejandría, aj Cilicia, xukuje' niq'uiaj chic ri e petinak pa tak ri tinimit re Asia. ");
INSERT INTO qucTNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Man xecowin tä c'ut xquik'atej u wäch ru tzij ri tat Esteban, rumal chi ri are' c'o u no'j, cäch'aw c'u ruc' ri etamanic ri yo'm che rumal ri Lok'alaj Espíritu. ");
INSERT INTO qucTNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Xequitoj c'u jujun achijab rech cäquibij chi kas tzij qui tom ri tat Esteban cubij ri äwas u bixic chrij ri ka mam Moisés xukuje' chrij ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Je ri' xca'no, xquicojola qui c'ux ri winak xukuje' ri nimak tak tata'ib cachi'l ri tijonelab re ri Pixab rech cäpe coyowal chrij ri tat Esteban. Xquimajij c'u ri tat Esteban, xquichapo, xquic'am bi chquiwäch ri qui nimakil ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Xukuje' xequitzucuj achijab rech cäquibij ri man kas tzij taj chrij ri tat Esteban. We winak ri' cäquibij: We achi ri' man cäcos tä chubixic ri äwas u bixic chrij we lok'alaj rachoch Dios ri' ri kech uj, xukuje' chrij ru Pixab ri ka mam Moisés. ");
INSERT INTO qucTNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ka tom c'ut ri are' cubij chi we Jesús ri' ri aj Nazaret cusach na u wäch we nimalaj rachoch Dios ri', xukuje' cuq'uex na ronojel ri uj u nak'atajisam wi can ri ka mam Moisés, —xecha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Te c'u ri' ri qui nimakil ri winak xukuje' conojel ri e t'uyul pa ri k'atbal tzij, aretak xeca'y che ri tat Esteban, xquilo chi ru palaj are je' jas ru palaj jun ángel. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Xpe ri qui nimal sacerdotes, xuta' c'u che ri tat Esteban, xubij: ¿A kas tzij wa' ri tajin cäbix chawij? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Xch'aw c'u ri tat Esteban, xubij chque conojel: Lok'alaj tak kachalal, alak c'amal tak ka be, tampe alak ri quinbij, —cächa'. Ri ka Dios, ri sibalaj nim u k'ij, xuc'ut rib chuwäch ri ka mam Abraham ojer aretak c'o pa tak ri juyub re Mesopotamia, c'ä mäjok cäk'ax are' pa ri tinimit Harán. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Xubij che: “Chaya can ra tinimit, xukuje' conojel ri awachalaxic, rech cate' pa ri ulew ri quinc'ut na chawäch,” —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Xel c'u bi ri ka mam Abraham pa ri qui tinimit ri winak aj Caldea, xe'c, xc'oji pa Harán. Te c'u ri', aretak cäminak chi ru tat, xc'am lok rumal ri Dios waral pa we tinimit ri c'o wi alak cämic. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Man xyi' tä c'u ch'äkap ulew che rechbal ri ka mam Abraham pa we tinimit ri' rumal ri Dios, man c'o tä c'u ne jun alaj ch'äkap ri cuya' cäc'oji wi. Xubij c'u ri Dios che chi cäpe na ri k'ij aretak ri are' cärechbej na ri ulew, cäcanaj can wa' we ulew ri' chque ri ralc'ual aretak cäcäm ri are', pune ta ne mäja' c'o ralc'ual ri ka mam Abraham pa tak ri k'ij ri'. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Xukuje' xubij ri Dios che chi ri ralc'ual ri quil na qui wäch quec'oji na pa jun tinimit chic, ri man qui tinimit taj. Quec'oji na pa qui k'ab ri winak jela', quepatänin na chque. Are quiejeb ciento junab cäquirik na c'äx chila', —xcha ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Xukuje' xubij ri Dios che: “Ri in quink'at na tzij pa qui wi' ri niq'uiaj winak chic ri quecojow na che patänil tak que. Quebel c'u na lok chila', quinquipatänij na waral ri',” —xcha ri Dios che. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Xukuje' xuban jun trato ri Dios ruc' ri ka mam Abraham. Che retal ri trato xtakan ri Dios chi cäk'at ru cuerpo jun achi o jun ala. Rumal ri' ri ka mam Abraham, aretak ilom chi u wäch ri alaj a Isaac ru c'ojol, chuwajxak k'ij xucoj ri etal che ru cuerpo. Xukuje' je' xuban ri tat Isaac che ri a Jacob ru c'ojol, ri tat Jacob xukuje' xucoj ri retal ri trato chque ru c'ojol ri are', xk'at ri qui cuerpo. Ri cablajuj u c'ojol ri tat Jacob e are wa' ri ojer tak qui mam conojel ri winak aj Israel cämic, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ri ralc'ual ri tat Jacob, ri ka mam ojer, c'äx xquina' che ri a José ri qui chak', xquiq'uiyij c'ut rech cäc'am bi pa Egipto. Ri Dios c'ut, c'o ri Are' ruc' ri a José. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Xuto' c'ut pa conojel tak ri c'äxc'ol ri xuriko. Xuya u no'j, xuya che chi utz quil wi rumal ri Faraón ri nim takanel puwi' ri Egipto. Aretak achi chic ri a José, ri Faraón xucoj ri are' che k'atal tzij puwi' ronojel ri Egipto, xukuje' xucoj ri are' che takanel puwi' ri rachoch. Ronojel c'ut xuya pu k'ab, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Xpe c'u wi'jal xukuje' nimalaj c'äxc'ol puwi' ronojel ri Egipto, xukuje' puwi' ronojel ri Canaán. Ri ka nan ka tat ojer man c'o tä chi ri cäquitijo. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Are c'u ri tat Jacob, aretak xuto chi c'o trico pa Egipto, xeutak bi ri u c'ojol jela'. Ri cablajuj u c'ojol ri tat Jacob, e are c'u wa' ri ka mam ojer. Are c'u nabe mul wa' ri xebe' pa Egipto. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Chucamul chic ri xebe'c, are chi' ri tat José xuc'ut rib chquiwäch ri rachalal, xretamaj c'u ri nim takanel, ri Faraón, jachin tak ri rachalaxic ri tat José. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Xtakan c'u ri tat José chuc'amic ri Jacob ru tat, xukuje' conojel ri niq'uiaj rachalaxic. E oxc'al olajuj winak c'u wa' chconojel. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Je' u k'axic wa' ri tat Jacob pa Egipto junam cuc' ri rachalaxic, chila' c'ut xcäm wi. Xukuje' chila' xecäm wi ri cablajuj u c'ojol, ri ojer tak ka mam. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Xc'am c'u lok ri qui cuerpo pa Siquem rech quemuk pa ri mukubal ri xulok' ri ka mam Abraham chque ru c'ojol ri tat Hamor aj Siquem ruc' ru rajil ri are', —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Aretak c'ut xa jubik' craj man copan ri k'ij ri cäbantajic jas ru bim ri Dios ruc' juramento che ri ka mam Abraham, ri tinimit Israel xnimaric, sibalaj xeq'uiar c'u ri ka winakil pa Egipto. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Are chi' c'ut xoc chi na jun takanel chic puwi' ri Egipto ri man retam tä u wäch ri tat José. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","We nim takanel ri' xna'w che qui subic ri ka winakil, xuban c'u etzelal chque ri ka nan ka tat ojer. Xuban c'äx chque, xeutako rech quequiwonoba can ri alaj tak calc'ual ri te' xil qui wäch rech xak quecämic. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Pa tak c'u ri k'ij ri' xil u wäch ri alaj a Moisés. Are sibalaj utz xil wi rumal ri Dios. Ru nan u tat xecowinic xquiq'uiyisaj na oxib ic' cho cachoch. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Aretak c'ut xajwatajic chi xquiya canok, xriktaj rumal ru mia'l ri Faraón ri takanel puwi' ri Egipto, xuc'am bi cho rachoch, xuq'uiyisaj, xuban ralbal che. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Je ri' ri a Moisés xc'ut ronojel u wäch etambal re Egipto chuwäch, xukuje' ronojel u wäch no'j. Rumal wa' ri a Moisés xc'oji nimalaj u no'j. Nim chi c'u u k'ij ri are'. Xk'alajin c'u wa' aretak xch'awic, xukuje' pa ronojel ri xubano, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Aretak tz'akat chic cawinak u junab, xpe pa ranima' ri qui solixic ru winakil, ri winak aj Israel. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Chila' xril jun chque ru winakil ri tajin cäban c'äx che rumal jun aj Egipto. Xe' c'ut, xuto', xucämisaj c'u ri aj Egipto chutojic u q'uexel ri c'äx ri xuban che ri aj Israel. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Xuchomaj c'u ri tat Moisés chi ru winakil cäquich'ob na chi ri Dios cucoj na ri are' che qui tzokopixic. Ri e are' c'ut man xquich'ob tä wa'. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Chucab k'ij chic ri tat Moisés xeurik quieb winak aj Israel ri tajin quech'ojinic, craj c'ut cujach qui wäch, cuya utzil chquixol, xubij chque: “Ri alak achalal ib alak. ¿Jas che c'äx cäban alak chbil tak ib alak?” —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Are c'u ri jun ri tajin cuban c'äx che ri rachi'l, xupakchij apan ri tat Moisés jela', xubij che: “¿Jachin xatcojow che takanel xukuje' che k'atal tzij pa ka wi'? ");
INSERT INTO qucTNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿A cawaj quinacämisaj jas ri xaban che ri jun aj Egipto iwir?” —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Aretak ri tat Moisés xuta wa' we tzij ri', xanimaj bic, xel bi pa Egipto, xe' pa Madián. Xc'oji c'u chquixol winak ri man u winakil taj. Chila' c'ut xc'uli'c. Xil qui wäch quieb u c'ojol, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Oc'owinak chi c'u cawinak junab, xuc'ut rib jun ángel chuwäch pa ri juyub ri cätz'inowic, nakaj che ri nim juyub, Sinaí u bi'. Ri ángel c'o pa ri k'ak' rech ri juwi' q'uix ri tajin cäc'atic. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Sibalaj c'u xucajmaj wa' ri tat Moisés aretak xrilo. Aretak xkeb ruc' rech kas cärilo, xuto chi xch'aw lok ri Kajaw Dios, xubij: ");
INSERT INTO qucTNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“In ri' ri qui Dios ri a mam ojer, ru Dios ri a mam Abraham, ru Dios ri a mam Isaac, ru Dios ri a mam Jacob,” —xcha'. Are c'u ri tat Moisés xuxej rib, xbirbitic, man xucoch' tä chic xrilo. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Xubij c'u ri Kajaw Dios che: “Chewesaj ra xajäb, rumal chi ri ch'äkap ulew ri at c'o wi are lok'alaj ulew wa'. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Kas tzij wilom ri c'äx ri tajin cäquirik ri nu winak pa Egipto. Nu tom ri cok'ej ri winak, rumal c'u ri' in kajinak lok che qui to'ic, rech quetzokopitajic. ¡Tasa'jmpe'! Catintak na bi pa Egipto,” —xcha ri Kajaw Dios che, —cächa ri tat Esteban. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Are ri tat Moisés xetzelax u wäch cumal ri winak aj Israel. Xquibij che: “¿Jachin xatcojow pa ka wi' che takanel, xukuje' che k'atal tzij?” —xecha che. Pune je ri', are ri are' ri xutak bi ri Dios che takanel pa qui wi' xukuje' che to'l que. Je' xuban ri Dios rumal ri ángel ri xuc'ut rib chuwäch pa ri juwi' q'uix. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ri tat Moisés are ri are' ri xeresaj lok ri ka nan ka tat ojer pa Egipto. Xuban nimak tak c'utbal xukuje' tak cajmabal pa Egipto, pa ri Quiäk Mar, xukuje' pa tak ri juyub ri cätz'inowic. Cawinak junab c'ut xuban wa'. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Are wa' ri tat Moisés ri xubij chque ri winak aj Israel: “Ri Dios cucha' na jun chque ri i winakil, cutak c'u na rech coc che k'alajisal re ru Lok' Pixab, je' jas ri xinutak in. Rajwaxic c'ut chi quinimaj ronojel ri cubij chiwe,” —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Tzare c'u ri' ri tat Moisés ri xc'oji chquixol ri winak aj Israel ri qui mulim quib pa ri juyub ri cätz'inowic, xukuje' xc'oji ri are' ruc' ri ángel ri xch'aw ruc' puwi' ri nim juyub, Sinaí u bi', xukuje' cuc' ri ka nan ka tat ojer. Xukuje' xuta ri tzij ri cuya ri kas c'aslemal, xuc'am c'ut, xuya lok wa' chke uj, —cächa ri tat Esteban chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ri ka mam ojer c'ut, man xcaj taj xeniman che, xane xa xquetzelaj u wäch. Xquipakchij ri ka mam Moisés, xquirayij pa canima' ri qui tzelejic jumul chic pa Egipto. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Xquibij che ri tat Aarón: “Cheabana jujun ka tiox ri quenabej na chkawäch, rumal chi man ketam taj jas xuc'ulmaj we tat Moisés ri xujesan lok pa Egipto,” —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Xca'n c'u jun qui tiox ri je' cäpe jun alaj ama' wacäx, xequicämisaj tak awaj, xequisipaj c'u cho ri qui tiox ri xca'no. Xca'n c'u jun nimak'ij, xequicot ruc' ri jun tiox ri xak e are' xebanowic. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Rumal ri' ri Dios xutas rib chquij, xeutzokopij canok rech quequik'ijilaj ri k'ij, ri ic', ri ch'imil, je' jas ri cäbix pa ri qui wuj ri k'alajisal tak re ru Lok' Pixab ri Dios: Winak aj Israel, pa tak ri cawinak junab ri xixc'oji pa ri juyub ri cätz'inowic, ¿a xeicämisaj lo awaj che quisipaxic wa' chnuwäch in? ");
INSERT INTO qucTNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Man je' taj xibano, xane are xeik'ijilaj niq'uiaj tak dioses. Are xitelej ri rachoch ri dios, Moloc u bi' (are jun carpa wa' ri rachoch ri qui dios Moloc), xukuje' ru ca'yebal ru ch'imil ri i dios, Renfán u bi'. Xak e tiox ri' ri ix xixbanowic rech queik'ijilaj. Xa rumal wa' quixinwesaj na bi pa ri i tinimit ix, quixintak c'u na bi pa jun tinimit chic ri naj c'o wi, c'ä jela' ch'äkäp che ri tinimit Babilonia, —xcha ri Dios chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ri ka nan ka tat ojer, aretak xquibinibej ri juyub ri cätz'inowic, c'o ri rachoch Dios cuc'. Are wa' ri banom ruc' manta, ri c'o wi ri tz'alam tak abaj re ri Pixab. Je' c'u u banic wa' jas ri xubij ri Dios che ri ka mam Moisés, aretak xubij che chi cuban jun rachoch Dios ri je' u banic jas ri c'utum chuwäch. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ri ka nan ka tat ojer xquechbej wa' we rachoch Dios ri' pa qui k'ab ri qui nan qui tat ri e are'. Aretak c'ut ri winak ri' rachi'l ri tat Josué xeboquic, xec'oji pa ri culew ri niq'uiaj winak chic ri esam bi chquiwäch rumal ri Dios, xquic'am bi ri rachoch Dios cuc'. Xek'ijilan c'u chupam c'ä pa ru k'ijol ri ka mam David ojer. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ri nim takanel David nim xil wi rumal ri Dios, je ri' chi xurik nimalaj utzil pa ru c'aslemal. Rumal ri' are u rayinic cuyac jun kas rachoch ri Dios. Are Dios wa' ru Dios ri ka mam Jacob ojer xukuje'. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Are c'u ri tat Salomón ru c'ojol ri tat David xyacow wa' we ja ri' che ri Dios aretak xoc che takanel. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Pune ri Nimalaj Dios aj Chicaj man cäc'oji tä pa jun ja ri xa banom cumal winak, jas ri xubij ri k'alajisal re ru Lok' Pixab ri Dios: ");
INSERT INTO qucTNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ri caj are nu t'uyulibal ri quintakan wi puwi' ronojel, are c'u ri ulew je' ta ne ruxlanibal ri wakan. ¿Jas c'u u wäch ri ja ri quiwaj quiyac chwe? —cächa ri Kajaw Dios, ¿o jawije' c'o wi ri uxlanibal ri quinuxlan wi? ");
INSERT INTO qucTNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿A mat are ri in ri xinbanow ronojel ri c'olic? —xcha ri Dios, —xcha ri tat Esteban. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ri tat Esteban xutakej u bixic chque ri qui nimakil ri winak: Ri alak sibalaj abajarinak ri anima' alak. Ri anima' alak man queniman tä che ri Dios, man coc tä c'u ru tzij pa jolom alak. Alak xak junam cuc' ri man e cojonelab taj. Ri alak amak'el cäk'atej alak u wäch ri Lok'alaj Espíritu. Junam alak cuc' ri mam alak ojer, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿A c'o lo jun chque ri k'alajisal tak re ru Lok' Pixab ri Dios ri mat xban c'äx che cumal ri mam alak ojer? Man c'o tä jun, xane xequicämisaj ri xeyo'w lok u bixic chi cäpe na ri Cristo ri Jicomalaj Patänil re ri Dios. Are c'u wa' ri xjach alak pa qui k'ab ri winak, xcämisaj alak. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ru Pixab ri Dios ri xyi' nabe canok cumal ri ángeles che ri ka mam Moisés, are Pixab wa' ri xyi' chech alak. Pune je ri', ri xuban ri Dios rech cäyataj ri Pixab pa k'ab alak, man cänimaj tä alak wa', —xcha ri tat Esteban chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ri winak, aretak xquita wa' we tzij ri', sibalaj xpe coyowal che ri tat Esteban, xquimut'ut'ej ri qui ware chrij chuc'utic ri nimalaj coyowal. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Are c'u ri are' kajinak ri Lok'alaj Espíritu puwi', xca'y chicaj, xril c'u ri je'lalaj u juluwem ri Dios, xukuje' xril ri Jesús, tac'al pa ru wiquiäk'ab ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Xubij c'ut: ¡Chilampe alak! —xcha'. Quinwil ri caj jaktalic, xukuje' quinwil ri Ralc'ual ri Dios ri Kas Winak c'o pa ru wiquiäk'ab ri Dios, —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ri nimak tak tata'ib xquitz'apij ri qui xiquin, sibalaj co xquirakakej qui chi'. Xak jun xquiyo' xebe' chrij ri tat Esteban. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Xquesaj bi chrij ri tinimit, xquiq'uiäk c'u che abaj. Ri achijab c'ut ri xebanow tzij chrij ri are' xquiya can ri catz'iak ruc' jun achi, Saulo u bi'. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Aretak tajin cäquiq'uiäk che abaj, ri tat Esteban xuban orar, xuta' tok'ob che ri Kajaw Jesús, xubij: Kajaw Jesús, c'ama la ri wanima', —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Te c'u ri' xxuqui'c, co xurak u chi', xubij: Tat, mäya la wa' we mac ri' chquij, —xcha ri tat Esteban. Xuwi xbitaj wa' rumal, xel ranima'. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ri tat Saulo utz xrilo chi xcämisax ri tat Esteban. Kas c'u pa ri k'ij ri xcäm ri are' xchaptaj u banic nimalaj c'äx chque ri kachalal cojonelab pa ri tinimit Jerusalén. Conojel c'ut xejabux bic. E c'o xebe' pa tak ri tinimit re Judea, e c'o niq'uiaj chic xebe' pa tak ri tinimit re Samaria. Xuwi ri apóstoles xecanaj canok. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Xepe c'u jujun achijab ri kas queniman che ri Dios, xquic'am bi ri tat Esteban, xe'quimuku canok. Sibalaj xebok' c'u chrij. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Are c'u ri tat Saulo xutakej u banic c'äx chque ri kachalal cojonelab. Xoc cho tak ja, xeucharchatej bi achijab, ixokib, xeucoj c'u pa che'. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Are c'u ri cojonelab ri xebel bi pa ri tinimit Jerusalén, xquitzijoj ri Utzalaj Tzij re ri Evangelio apawije' chi' ri xebe' wi. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ri tat Felipe xe' pa jun tinimit re Samaria, chila' c'ut xuchaplej qui tzijobexic ri winak chrij ri Cristo. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ri winak xquimulij quib chrij ri tat Felipe. Sibalaj xquitatabej ri tzij ri xubij. Xukuje' xquil ri cajmabal tak etal ri tajin cubano. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","E q'uia c'u ri winak ri e c'o itzelalaj tak espíritus chque. Xeutzir c'u wa' we winak ri'. Ri itzelalaj tak espíritus, aretak xebel chque ri winak, xquirak qui chi', xebe'c. E q'uia c'u ri cäminak qui cuerpo ri xecunatajic, xukuje' e q'uia ri u banom c'äx ri cakan, ri man xecowin taj xebinic. Ri e are' xukuje' xecunatajic. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Je ri' chi conojel ri winak pa ri tinimit ri' sibalaj xequicotic. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","C'o c'u jun tata' pa ri tinimit ri', Simón u bi', ri nabe canok xuban ri itzinic, xesub ri winak aj Samaria rumal. Xuban che rib chi ri are' sibalaj nim u banic pa ri tinimit. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Conojel c'u ri winak chi ac'alab chi ri'jab sibalaj xquitatabej ri cubij ri achi ri', xquibij: We achi ri' are c'o ri nimalaj u chuk'ab ri Dios ruc', —xecha'. Ri Nimalaj u Chuk'ab ri Dios, —xuchix che ri are'. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ojer chi c'u ri' e subum lok ri winak rumal ri itzinic ri tajin cubano. Rumal c'u ri' sibalaj xquicoj ri xubij. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Aretak c'ut ri winak xquinimaj ri Utzalaj Tzij re ri Evangelio ri xutzijoj ri tat Felipe chque chrij ru takanic ri Dios, xukuje' chrij ri Jesucristo, xa je ri' e q'uia chque xban qui kasna', chi achijab chi ixokib. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Xukuje' ne ri tat Simón xcojonic, xban u kasna', xuchaplej c'u rachi'laxic ri tat Felipe. Sibalaj xucajmaj ri nimak tak cajmabal, xukuje' ri nimak tak etal ri xebantajic. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Aretak ri apóstoles ri e c'o pa ri tinimit Jerusalén xquito chi ri winak pa Samaria xquinimaj ru Lok' Pixab ri Dios, xequitak bi ri tat Pedro rachi'l ri tat Juan jela'. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Aretak xeopanic, xca'n orar pa qui wi' ri cojonelab aj Samaria rech cäkaj ri Lok'alaj Espíritu pa qui wi'. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Je ri', rumal chi man c'o tä jun chque kajinak ri Lok'alaj Espíritu puwi'. Xuwi banom qui kasna' pa ru bi' ri Kajaw Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Te ri' ri tat Pedro, ri tat Juan xquiya ri qui k'ab pa qui wi' ri cojonelab, xkaj c'u ri Lok'alaj Espíritu pa qui wi'. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ri tat Simón xrilo chi aretak ri apóstoles xquiya ri qui k'ab pa qui wi' ri cojonelab, xkaj ri Lok'alaj Espíritu pa qui wi', xpe c'u ri are', xuchi'j puak chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Xubij: Ya alak we chuk'ab ri' chwe in xukuje', rech apachin ri quinya ri nu k'ab puwi' cäkaj ri Lok'alaj Espíritu puwi', —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Xubij c'u ri tat Pedro che: Utz na we ta ri rajil la cäsach u wäch wa' uc' la, rumal chi cächomaj la chi ri cusipaj ri Dios cuya' cälok' wa' ruc' puak. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Man c'o tä e la kuc' pa we chac ri', man ya'tal tä c'u wa' che la, rumal chi man jicom tä ri anima' la chuwäch ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ya la can wa' we etzelal ri' ri chomam la. Bochi'j ba' la ri Dios, ta' la tok'ob che chi cäsachtaj ri mac la, are c'u ri' ri itzel chomanic ri xq'uiy pa anima' la. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","K'alaj c'ut chi c'o ri c'äx ri t'uyul pa ri anima' la. Are wa' ru xera' ri etzelal. Je' ta ne chi ri lal chaptajinak la rumal we etzelal ri', —xcha ri tat Pedro che ri tat Simón. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Xch'aw c'u ri tat Simón, xubij che ri tat Pedro: Bana ba' alak orar pa nu wi' chuwäch ri Kajaw Dios, rech man quinrik tä ne jubik' ri c'äx ri xbij la chwe, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Aretak ri quieb apóstoles xeto'taj chubixic ru banom ri Dios pa ri qui c'aslemal, xukuje' chutzijoxic ru Lok' Pixab ri Dios, xetzelej bi pa Jerusalén. Xquitzijoj can ri Utzalaj Tzij re ri Evangelio pa tak ri alaj tak tinimit re Samaria ri xeoc'ow wi. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Te c'u ri' jun ángel xuch'abej ri tat Felipe, xubij che: Chatwalij ba', jat pa ru mox ri relbal k'ij pa ri be ri quel bi pa ri tinimit Jerusalén, cäxuli pa Gaza, —xcha che. We be ri' are wa' ri cäk'atan pa ri juyub ri cätz'inowic. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Xwalij c'u bi ri tat Felipe, xe'c. Xurik c'u jun tata' aj Etiopía pa ri be. Are jun tata' eunuco, —cuchixic. We achi ri' sibalaj nim u banic, are quilow ronojel ri jastak re ri chichu' ri cäcoj Candace che ru bi'. Ri ixok ri' are ri nim takanel pa qui wi' conojel ri aj Etiopía. Ri tata' ri' u petic pa ri tinimit Jerusalén ri xuk'ijilaj wi ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Tzelejem c'u re pa ru tinimit, t'uyul pa ru carreta, tajin cusiq'uij ri wuj ri xutz'ibaj ri ka mam Isaías, k'alajisal re ru Lok' Pixab ri Dios ojer. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ri Espíritu rech ri Dios xubij che ri tat Felipe: Chatkeb ruc' we jun carreta ri', chawachi'laj bic, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Aretak xkeb ri tat Felipe, xuto chi ri tata' tajin cusiq'uij ri wuj ri u tz'ibam ri ka mam Isaías, xuta' c'u che: ¿A cäch'ob la jas quel cubij ri tajin cäsiq'uij la? —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ri tata' xubij che: ¿Jas ta quinban in chuch'obic wa' we man c'o jachin ri cäbin chwe jas quel cubij ri tajin quinsiq'uij? —xcha che. Xubij c'u che ri tat Felipe chi cäpaki lok pa ri carreta, cät'uyi bi ruc' are'. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Jawije' ri tajin cusiq'uij wi ri tata' pa ru Lok' Pixab ri Dios, je wa' cubij: Je' jas ri cäban che jun chij ri cäc'am bi pa pilic, je' xban che ri are'. Je' jas jun alaj chij ri man curak tä u chi' aretak cäsocax ri rismal, je' xuban ri are', man c'o tä jas xubij. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Xkasax u k'ij ri are'. Pune man c'o tä u mac, xk'at tzij puwi'. Man jicom tä c'ut ri xban che, man c'o tä c'u jun ri xto'wic. ¿Jachin ta c'u ri cäcowin che qui tzijoxic jas qui banic ri winak ri xil ta ne qui wäch rumal ri are'? Man c'o tä jun, rumal chi xesax bi pa ri tinimit, xc'am c'u bic pa cämisaxic, —cächa ru Lok' Pixab ri Dios ri tajin cusiq'uij ri tata'. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Xubij ri tata' ri nim u banic che ri tat Felipe: Bana ba' la tok'ob, bij la chwe, ¿jachin chrij tajin cäch'aw ri k'alajisal re ru Lok' Pixab ri Dios? ¿A are ri are' ri tajin cäch'aw chrij chbil rib, o are jun chic ri cubij? —cächa che. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Xch'aw c'u ri tat Felipe. Ruc' we tzij ri' ri tajin cusiq'uij ri aj Etiopía, xuchaplej u tzijoxic ri Utzalaj Tzij re ri Evangelio chrij ri Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","E benak pa ri be, oc'owem cäca'n chuchi' jun ja', ri tata' aj Etiopía xubij che ri tat Felipe: C'o joron waral, ¿a mat cuya' cäban nu kasna' chi'? —xcha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ri tat Felipe xubij che: We kas tzij cäcojon la, cuya' cäban ri kasna' la, —xcha che. Xch'aw c'u ri are', xubij: Quincojo chi ri Jesucristo are ru C'ojol ri Dios, —xcha'. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Xtakan c'u chutac'baxic ri carreta. Ri quieb xekaj pa ri ja', xban c'u u kasna' ri tata' rumal ri tat Felipe. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Aretak xebel lok pa ri ja', ri Espíritu rech ri Kajaw Dios xuc'am bi ri tat Felipe. Ri tata' ri nim u banic aj Etiopía man xril tä chi u wäch. Xutakej c'u ru be ri are', sibalaj xquicot ranima'. ");
INSERT INTO qucTNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Are c'u ri tat Felipe te' cärilo chi c'o ri are' pa ri tinimit Azoto. Xel bic jela', benam re pa ri tinimit Cesarea. Pa ronojel tinimit ri xoc'ow wi xutzijoj ri Utzalaj Tzij re ri Evangelio chque ri winak c'ä xopan na pa Cesarea. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Are c'u ri tat Saulo sibalaj royowal chquij ri winak ri e cojoninak che ri Kajaw Jesús. Ri are' craj queucämisaj. ¡Xeuxibij c'ut! Rumal ri' xe' ri are', xtzijon ruc' ri qui nimal sacerdotes ri c'o pa ri tinimit Jerusalén. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Xuta' che chi cuya bi jujun tak wuj che, ri cubij wi chi yo'm takanic pu k'ab rech coc pa tak ri rachoch Dios pa ri tinimit Damasco. Je ri' rech queutzucuj ri queniman che ri Utzalaj Tzij re ri Evangelio, chi achijab chi ixokib, che qui chapic rech queuc'am lok che cocsaxic pa che' pa ri tinimit Jerusalén. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Benak c'u pa ri be, c'o ri are' chunakaj ri tinimit Damasco, xak te'talic c'ut xtunun jun nimalaj sakil chrij ri xpe chicaj. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Xtzak c'u pulew, te' xuto chi c'o jun ri xch'aw lok chicaj ri xubij: Saulo, Saulo, ¿jas che tajin caban we nimalaj c'äx ri' chwe? —xcha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ri tat Saulo xubij: ¿Jachin ri lal, Tat? —xcha che. Ri Jun ri xch'awic xubij: ¡In ri' ri Jesús! Ri c'äx ri tajin cabano, are chwe In ri tajin caban wi wa'. Xak je ri' ri at tajin carik c'äx jas ri cuban ri wacäx ri cucoj akan che ri jun che' t'ist'ic u wi', —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ri tat Saulo xuxej rib, xbirbitic, xubij: Tat, ¿jas caj la chi quinbano? —xcha'. Xubij c'u ri Kajaw Jesús che: Chatwalijok, jat pa ri tinimit, cäbix c'u na chawe jas ri rajwaxic cabano, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ri achijab ri e benak pa ri be ruc' ri tat Saulo sibalaj xquixej quib rumal chi xquita ri ch'abal, man c'o tä c'u jachin xquilo. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Xwalij c'u ri tat Saulo, xujak ru wak'äch, man xcowin tä c'ut xca'yic. Rumal ri' xa xyukex bi che ru k'ab, xc'am bi pa ri tinimit Damasco. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Chila' c'ut xc'oji wi oxib k'ij, man xcowin taj xca'yic. Man c'o tä c'u jas xutijo. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","C'o c'u jun cojonel pa ri tinimit Damasco, Ananías u bi'. Xuc'ut rib ri Kajaw Jesús chuwäch, xubij che: ¡Ananías! —xcha che. Ri are' xch'awic, xubij: In c'olic ri', Wajaw, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ri Kajaw Jesús xubij che: Chatwalij ba', jat pa ri jun be ri cäbix “Jicom” che. Aretak catopan pa rachoch ri tat Judas, chata' che we c'o ri jun achi chila' aj Tarso, Saulo u bi'. Chanim ri' tajin cuban orar. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","C'o ri xuc'ut ri Dios chuwäch. Xril jun achi, Ananías u bi', ri xoc bi ruc', xuya ru k'ab puwi' rech cäcowinic cäca'y jumul chic, —xcha ri Kajaw Jesús che. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Xch'aw c'u ri tat Ananías, xubij: Kajaw, e q'uia ri qui bim chwe chrij we achi ri' chi u banom q'uia u wäch c'äx chque ri winak pa ri tinimit Jerusalén ri e cojoninak che la. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ulinak c'u waral, yo'm lok takanic pu k'ab cumal ri qui nimakil sacerdotes che qui chapic bi conojel ri cäquicoj ri bi' la aretak cäca'n orar, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Xubij c'u ri Kajaw Jesús che: ¡Jat ba'! Are rumal chi we achi ri' cha'tal wumal rech cutzijoj ri Utzalaj Tzij chwij In chque ri winak re ri niq'uiaj tak tinimit chic, chque ri quetakan pa qui wi', xukuje' chque ri winak aj Israel. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Quinc'ut c'u na chuwäch jas ri nimalaj c'äx ri rajwaxic curik na ri are' rumal wech in, —xcha ri Kajaw Jesús che ri tat Ananías. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Xe' c'u ri tat Ananías. Xoc bi pa ri ja ri c'o wi ri tat Saulo, xuya ru k'ab puwi', xubij c'u che: Wachalal Saulo, ri Kajaw Jesús, ri xuc'ut rib chuwäch la pa ri be ri petinak wi la, xinutak lok uc' la rech cäcowin la cäca'y chi na la, xukuje' rech cäkaj ri Lok'alaj Espíritu puwi' la, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Chanim c'ut xetzak lok je' ta ne jujun solot pu wak'äch ri tat Saulo. Je ri' xcowinic xca'y jumul chic ri are'. Xwalij c'ut, xban u kasna'. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Te c'u ri' xwi'c, xpe chi jumul ru chuk'ab. Xc'oji c'u na quieb oxib k'ij cuc' ri cojonelab ri e c'o pa ri tinimit Damasco. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Te c'u ri' ri tat Saulo xuchaplej u tzijoxic ru Lok' Pixab ri Dios pa tak ri rachoch Dios, cubij c'u chque ri winak chi ri Jesús are ri u C'ojol ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Conojel c'u ri xquita ru tzij sibalaj xquicajmaj wa', xquibij: ¿A mat are wa' ri achi ri cuban c'äx chque ri winak pa Jerusalén ri cäquicoj ru bi' ri Jesús aretak cäca'n orar? ¿A mat are ulinak waral che qui chapic bic, che qui jachic pa qui k'ab ri qui nimakil sacerdotes? —xecha ri'. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Are c'u ri tat Saulo ruc' nimalaj chuk'ab xch'awic, xuk'alajisaj c'ut chi ri Jesús kas tzij Are ri Cristo, ri To'l Ke, je ri' chi ri winak aj Israel ri e c'o pa ri tinimit Damasco man xquirik tä chic jas cäca'no. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Oc'owinak chi c'u q'uialaj tak k'ij, ri winak aj Israel xquichomaj jas cäca'n chucämisaxic ri tat Saulo. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ri are' c'ut xretamaj jas ri qui chomam u banic chucämisaxic. Pak'ij chi chak'ab ri e are' xquiyuxlej ri tat Saulo chuchi' tak ri porta re ri tinimit chucämisaxic. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Are c'u ri cojonelab xquic'am ri tat Saulo, xquiya pa jun nim chicäch. Chak'ab xquikasaj bi chrij ri tapya ri c'o chrij ri tinimit. Je' ri xca'n chuto'ic ri tat Saulo. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Aretak xopan ri tat Saulo pa ri tinimit Jerusalén, xraj xc'oji cuc' ri cojonelab. Conojel c'ut xquixej quib che ri are' rumal chi man xquicoj taj chi are jun kas cojonel. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Xpe c'u ri tat Bernabé, xuc'am bi ri tat Saulo chquiwäch ri apóstoles rech cäquetamaj u wäch. Xutzijoj c'u chque jas xuban ri tat Saulo, xril ri Kajaw Jesús pa ri be, xukuje' chi xch'aw ri Kajaw Jesús ruc'. Xubij c'u chque chi ri tat Saulo man xuxej tä rib che qui tzijobexic ri winak chrij ri Cristo pa ri tinimit Damasco. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Je ri' ri tat Saulo xcanaj can cuc' ri cojonelab pa ri tinimit Jerusalén, xerachi'laj jawije' ri xebe' wi. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Man xuxej tä rib che qui tzijobexic ri winak chrij ri Cristo. Xuchap tzij cuc' ri winak aj Israel ri quech'aw pa griego. Are c'u ri e are' xa xquitzucuj jas cäca'n na chucämisaxic. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Aretak xquetamaj wa' ri kachalal, xquic'am bi ri tat Saulo pa ri tinimit Cesarea, xquitak c'u bi pa ri tinimit Tarso. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Xak je ri' conojel ri kachalal cojonelab ri e c'o pa Judea, pa Galilea, xukuje' pa Samaria, xuxlan ri canima'. Tajin quecowiric, c'o c'u na qui chuk'ab. Xquixej quib chuwäch ri Dios, xeniman c'u che. Are ri Lok'alaj Espíritu ri tajin cäbanowic chi sibalaj queq'uiaric, chi cäc'oji na qui chuk'ab. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pa jun k'ij ri tat Pedro tajin queusolij ri kachalal, xukuje' xe' che quilic ri kachalal cojonelab ri e c'o pa ri tinimit Lida. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Chila' xurik wi jun achi, Eneas u bi'. We achi ri' wajxakib junab chic c'o pa ch'at, cäminak c'u ru cuerpo. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ri tat Pedro xubij che: Tat Eneas, ri Jesucristo catcunanic. Chatwalijok, chabana can u banic ra ch'at, —xcha che. Chanim c'ut xwalijic. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Aretak c'ut ri winak ri e c'o pa ri tinimit Lida, xukuje' ri e c'o pa ri tak'aj re Sarón ri c'o wi ri Lida, xquilo chi ri tat Eneas xwalijic, xquiya can ri ojer qui c'aslemal. Rumal ri xbantajic xecojon che ri Kajaw Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Pa tak ri k'ij ri' c'o jun chichu' cojonel pa ri tinimit Jope, Tabita u bi', ri cäbix Dorcas che pa ri ch'abal griego. We chichu' ri' amak'el xuban ronojel u wäch utzil chque ri winak, xeuto' c'u ri c'o qui rajwaxic. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Pa tak ri k'ij ri' xyawaj ri nan Dorcas, xcämic. Aretak xch'ajtaj ru cuerpo, xyi' pa ru cawik ja. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Nakaj c'ut c'o wi ri tinimit Jope che ri tinimit Lida ri c'o wi ri tat Pedro. Ri cojonelab xquito chi ri tat Pedro c'o pa Lida, xequitak bi quieb achijab chubixic che: Bana ba' la jun tok'ob, sa'j la kuc' chanim, —xecha bic. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ri tat Pedro xuban c'u u banic rib, xe' cuc' ri achijab. Aretak xeopanic, xquic'am bi ri tat Pedro pa ri cawik ja ri c'o wi ri cäminak. Xepe c'u conojel ri malca'nib ixokib, xemuli chrij ri tat Pedro, tajin quebok'ic, xquic'ut tak ri camixa' xukuje' niq'uiaj atz'iak chic ri xuban ri nan Dorcas aretak c'aslic. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ri tat Pedro xubij chque chi quebel na bi conojel, te c'u ri' xxuqui'c, xuban orar. Xca'y c'u che ri chichu' ri cäminak, xubij: Nan Dorcas, walij ba' la, —xcha che. Ri nan Dorcas xca'yic, aretak c'ut xril ri tat Pedro, xwalijic, xcu'bic. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ri tat Pedro xuchap che ru k'ab, xuyaco. Xeusiq'uij ri malca'nib ixokib, xukuje' conojel ri niq'uiaj cojonelab chic. C'asal chic xuya chquiwäch rech cäquilo. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Xel c'u u tzijol wa' pa ronojel ri tinimit Jope. E q'uia c'ut xecojon che ri Kajaw Jesús. ");
INSERT INTO qucTNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Naj c'ut xc'oji na ri tat Pedro pa ri tinimit Jope cho rachoch jun tata' josk'il tz'um, Simón u bi'. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","C'o c'u jun tata', Cornelio u bi', pa ri tinimit Cesarea. Ri tata' ri' are jun qui nimal soldados ri c'o cien achijab pu k'ab. Ri soldados ri' cäbix “Aj Italiano” chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ri are' xk'ijilan che ri Dios, junam cuc' conojel ri e c'o pa rachoch. Xniman che ri Dios, xuxej rib chuwäch. Q'uia ri u banom che qui to'ic ri meba'ib winak aj Israel, amak'el c'ut xuban orar chuwäch ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Pa jun k'ij, craj pa ri rox hora re ri benak k'ij, c'o ri xuc'ut ri Dios chuwäch ri tat Cornelio. Are jun ángel ri takom lok rumal ri ka Tat. Kas xrilo xoc bi ri ángel ruc', te c'u ri' ri ángel xubij che: ¡Tat Cornelio! —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ri are' sibalaj xuxej rib, co xca'y che ri ángel, xuta' che: ¿Jas caj la, tat? —xcha che. Are c'u ri ángel xubij che: Ri Dios retam jas a banom, chi sibalaj caban orar chuwäch, xukuje' rilom ri utzil ri caban chque ri winak. Man sachinak tä wa' che ri Are'. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Cheataka bi jujun achijab pa ri tinimit Jope chusiq'uixic lok jun tata', Simón u bi', ri xukuje' cäbix Pedro che, —cächa'. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ri are' c'o pa rachoch jun tata' ri xukuje' cäcoj Simón che ru bi'. We tata' ri' are josk'il tz'um, ri c'o rachoch chuchi' ri mar, —cächa'. Ri tat Pedro cubij c'u na chawe jas ri rajwaxic cabano, —xcha ri ángel che ri tat Cornelio. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Aretak benak chi ri ángel ri xtzijon ruc' ri tat Cornelio, ri are' xeusiq'uij quieb chque ri patänil tak re, xukuje' jun soldado ri sibalaj cu'l u c'ux ri tat Cornelio chrij rumal kas tzij cäcojon ri soldado ri' che ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Xutzijoj chque ronojel ri xrilo, te c'u ri' xeutak bi pa ri tinimit Jope. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Chucab k'ij e benak ri achijab pa ri be, nakaj chic e c'o wi che ri tinimit Jope. Ri tat Pedro c'ut xpaki puwi' ri ja ri c'o wi chubanic orar, craj are ri u cablajuj hora chic. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Sibalaj cänum chi ri tat Pedro, craj cäwi'c, mäja' c'u cutzir ru wa re pak'ij. Ri Dios xuban che ri tat Pedro chi xsachi'c, c'o c'u ri xuc'ut ri Dios chuwäch. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Xril ri caj tajin cäjakjobic, te c'u ri' xrilo chi tajin cäkaj lok cho ruwächulew jun liq'uilic manta ri sibalaj nim, ri ximital chque ri quiejeb u tza'm. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","E c'o c'u ronojel u wäch awaj chupam ri manta. E c'o chicop ri cajcaj cakan, xukuje' e c'o chicop ri cäquijuruj quib, xukuje' niq'uiaj chicop ri querapapic. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Xuta c'u Jun ri xch'aw lok chicaj ri xubij che: Chatwalijok, Pedro, chacämisaj apachique chicop, chatwok, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Xch'aw c'u ri tat Pedro, xubij che: ¡No, Wajaw! Man c'o tä c'u jumul nu tijom ri man ya'tal tä u tijic, ri äwas chwe quintijo, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Xch'aw jumul chic ri Jun ri xch'aw nabe, xubij che ri tat Pedro: Ri cubij ri Dios chi ya'tal u tijic, mabij at che chi äwas u tijic wa', —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Oxmul c'ut xbantaj wa'. Te c'u ri' ri manta xpaki chi jumul chicaj. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ri tat Pedro tajin cuchomaj jas quel cubij wa' ri xrilo aretak ri achijab ri e takom bi rumal ri tat Cornelio xeopan chi' ri uchibe chuta'ic we chila' ri rachoch ri tat Simón. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Co xech'awic chuta'ic we chila' jekel wi jun tata', Simón u bi', ri xukuje' cäbix Pedro che. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Tajin cächoman c'u na ri tat Pedro chrij ri xuc'ut ri Dios chuwäch aretak ri Lok'alaj Espíritu xubij che: Chawilampe', e c'o oxib achijab tajin catquitzucuj. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Chatwalij ba', chatkaj c'u na bic. Jat cuc', muban c'u quieb a c'ux. Are ri in xinyo'w takanic chque chi quepe che a ch'abexic, —xcha ri Lok'alaj Espíritu che ri tat Pedro. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Xkaj c'u lok ri tat Pedro, xopan chila' jawije' e c'o wi ri achijab ri e takom bi rumal ri tat Cornelio, xubij chque: In ri' ri quintzucuj alak. ¿Jas tajquil alak wuc'? —xcha chque. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ri e are' xech'awic, xquibij: Uj takom lok rumal ri tat Cornelio, ri qui nimal jun ciento soldados. Are jun tata' ri jicom ranima', ri cäniman che ri Dios. Ri are' sibalaj nim quil wi, xukuje' sibalaj lok' chquiwäch conojel ri winak aj Israel. Xbix c'u che rumal jun ángel ri xtak lok rumal ri Dios, chi cutak siq'uixic la rech que' la cho rachoch, cuta c'u na ri tzij ri cäbij la, —xecha che. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Xeocsax c'u pa ja rumal ri tat Pedro, xecanaj chila' che ri jun ak'ab. Chucab k'ij xewalijic, xe' c'u ri tat Pedro cuc' ri tata'ib. E rachi'l jujun kachalal aj Jope. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Chucab k'ij xeopan pa ri tinimit Cesarea. Eyeninak c'u ri tat Cornelio chque junam cuc' jujun chque ri rachalaxic, xukuje' ri winak ri sibalaj e utz ruc' ri are'. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Aretak xopan ri tat Pedro, xel lok ri tat Cornelio chuc'ulaxic, xxuqui c'u chuwäch chuk'ijilaxic. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Xpe c'u ri tat Pedro, xuyaco, xubij che: ¡Walij la, tat Cornelio! Ri in, xak in achi jas ri lal, —xcha che. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Tajin quetzijonic, xeboc apan chi' ja. Xoc c'u bi ri tat Pedro, te' xrilo q'uia winak qui mulim quib. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Xubij ri tat Pedro chque ri winak: Ri alak etam alak chi man ya'tal tä che jun aj Israel cärachi'laj o coc pa rachoch jun winak ri man aj Israel taj. Ri Dios c'ut xuc'ut chnuwäch chi man cuya' taj quinbij chi are äwas ri quinc'oji ruc' jun winak ri man aj Israel o quinbij chi man ch'ajch'oj tä ri ranima' ri are' cho ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Rumal ri' aretak xtakan alak che nu siq'uixic, man c'o tä jas xincoj pa nu tzij, xinpe chanim. Cwaj c'ut quinwetamaj jas che xtakan alak che nu siq'uixic, —xcha ri tat Pedro chque ri winak. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Xch'aw c'u ri tat Cornelio, xubij: Xque' ne lo quiejeb k'ij, je' tak hora ri' tajin quinban ri ayuno. Pa ri u rox hora re ri benak k'ij in c'o pa ja, tajin quinban orar. Xak c'u te'talic xtac'atob jun achi chnuwäch ri sibalaj cäjuluw ri ratz'iak. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Xubij c'u chwe: “Tat Cornelio, ri oración ri xabano xtataj rumal ri Dios, ri utzil ri tajin caban chque ri winak ri c'o qui rajwaxic sibalaj utz cäril wi ri Dios. ");
INSERT INTO qucTNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Chattakan ba' chusiq'uixic lok ri tat Simón ri xukuje' cäbix Pedro che, ri c'o pa rachoch jun tata', Simón