﻿USE sofia;
DROP TABLE IF EXISTS sofia.qucNNT_vpl;
CREATE TABLE qucNNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES qucNNT_vpl WRITE;
INSERT INTO qucNNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Are wa' ri ki b'i' ri u mam ri Jesús ojer. Ri Jesús Are rachalaxik ri qa mam David xuquje' ri qa mam Abraham ojer. ");
INSERT INTO qucNNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ri qa mam Abraham are u tat ri qa mam Isaac. Ri qa mam Isaac are u tat ri qa mam Jacob. Ri qa mam Jacob are u tat ri qa mam Judá xuquje' taq ri e rachalal ri are'. ");
INSERT INTO qucNNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ri qa mam Judá are u tat ri qa mam Fares xuquje' ri qa mam Zara. Ri ki nan k'ut are ri nan Tamar. Ri qa mam Fares are u tat ri qa mam Esrom. Ri qa mam Esrom are u tat ri qa mam Aram. ");
INSERT INTO qucNNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ri qa mam Aram are u tat ri qa mam Aminadab. Ri qa mam Aminadab are u tat ri qa mam Naasón. Ri qa mam Naasón are u tat ri qa mam Salmón. ");
INSERT INTO qucNNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ri qa mam Salmón are u tat ri qa mam Booz. Ru nan ri qa mam Booz are ri nan Rahab. Ri qa mam Booz are u tat ri qa mam Obed. Ru nan ri qa mam Obed are ri nan Rut. Ri qa mam Obed are u tat ri qa mam Isaí. ");
INSERT INTO qucNNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ri qa mam Isaí are u tat ri qa mam David ri nim taqanel. Ri qa mam David ri nim taqanel ruk' ri chichu' ri xrixoqilaj na ri tat Urías, e are' u nan u tat ri qa mam Salomón. ");
INSERT INTO qucNNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ri qa mam Salomón are u tat ri qa mam Roboam. Ri qa mam Roboam are u tat ri qa mam Abías. Ri qa mam Abías are u tat ri qa mam Asa. ");
INSERT INTO qucNNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ri qa mam Asa are u tat ri qa mam Josafat. Ri qa mam Josafat are u tat ri qa mam Joram. Ri qa mam Joram are u tat ri qa mam Uzías. ");
INSERT INTO qucNNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ri qa mam Uzías are u tat ri qa mam Jotam. Ri qa mam Jotam are u tat ri qa mam Acaz. Ri qa mam Acaz are u tat ri qa mam Ezequías. ");
INSERT INTO qucNNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ri qa mam Ezequías are u tat ri qa mam Manasés. Ri qa mam Manasés are u tat ri qa mam Amón. Ri qa mam Amón are u tat ri qa mam Josías. ");
INSERT INTO qucNNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ri qa mam Josías are u tat ri qa mam Jeconías, xuquje' ri e rachalal. Pa taq ri q'ij ri' xek'am b'i ri winaq aj Israel, xeopan k'u pa ri tinimit Babilonia. ");
INSERT INTO qucNNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Aretaq ri winaq aj Israel e k'o chik pa ri tinimit Babilonia, ri qa mam Jeconías xk'oji jun u k'ojol, Salatiel u b'i'. Ri qa mam Salatiel are u tat ri qa mam Zorobabel. ");
INSERT INTO qucNNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ri qa mam Zorobabel are u tat ri qa mam Abiud. Ri qa mam Abiud are u tat ri qa mam Eliaquim. Ri qa mam Eliaquim are u tat ri qa mam Azor. ");
INSERT INTO qucNNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ri qa mam Azor are u tat ri qa mam Sadoc. Ri qa mam Sadoc are u tat ri qa mam Akim. Ri qa mam Akim are u tat ri qa mam Eliud. ");
INSERT INTO qucNNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ri qa mam Eliud are u tat ri qa mam Eleazar. Ri qa mam Eleazar are u tat ri qa mam Matán. Ri qa mam Matán are u tat ri qa mam Jacob. ");
INSERT INTO qucNNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ri qa mam Jacob are ru tat ri a José ri rachajil ri María. We María ri' are k'u wa' ru nan ri Jesús ri käb'ix Cristo che. ");
INSERT INTO qucNNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Je ri' chi kajlajuj juch'ob' tataxelab' kachi'l ri ki k'ojol e ok'owinaq xchaptaj loq ruk' ri qa mam Abraham k'ä ruk' ri qa mam David. Kajlajuj chik xchaptaj loq ruk' ri qa mam David k'ä aretaq xek'am b'i ri winaq aj Israel, xeopan pa ri tinimit Babilonia. Te k'u ri' e k'o chi kajlajuj chik k'ä xil na u wäch ri Cristo. ");
INSERT INTO qucNNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Are je wa' xb'antajik aretaq xil u wäch ri alaj a Jesús: Ri q'apoj al María ru nan u yo'm chi u tzij che k'ulanem ruk' ri a José. Mäja' k'u kek'uli'k aretaq ri al María xkanaj yawab' winaq rumal ru chuq'ab' ri Loq'alaj Espíritu. ");
INSERT INTO qucNNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ri a José k'ut ri rachajil are jun achi ri jikom ranima' cho ri Dios, man kraj tä k'ut käresaj u k'ixb'al ri al María chkiwäch ri winaq. Rumal ri' xuchomaj u ya'ik kanoq xaq chi k'uyal. ");
INSERT INTO qucNNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Aretaq je' tajin kuchomaj wa', xpe jun ángel ri taqom loq rumal ri Dios ri xuk'ut rib' chuwäch ri a José pa ri u waram, xub'ij che: A José, at b'a' at rachalaxik ri tat David. Maxej awib' chuk'amik ri al María che awixoqil, rumal chi ri ral ri kil na u wäch, are rech ri Loq'alaj Espíritu wa'. ");
INSERT INTO qucNNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ri are' käk'oji na jun ral ala, kakoj k'u na JESÚS che u b'i'. (Ri “Jesús” kel kub'ij “To'l Qe”.) Je' u b'i' wa' rumal chi keuto' na ru winaqil, keresaj na pa ri ki mak, —xcha ri ángel. ");
INSERT INTO qucNNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ronojel wa' xb'antajik rech qas je' kel wi jas ru b'im ri Qajaw Dios rumal ri q'alajisal re ru Loq' Pixab' ri kub'ij: ");
INSERT INTO qucNNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ri q'apoj ali käkanaj na kan yawab' winaq, käril k'u na u wäch jun ral ala ri käb'ix na Emanuel che, —kächa'. Kel kub'ij wa': Ri Dios k'o quk', —kächa ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Aretaq xk'astaj ri a José che ru waram, xunimaj ri xb'ix che rumal ri ángel ri taqom loq rumal ri Dios. Xuk'am ri al María che rixoqil. ");
INSERT INTO qucNNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Man xkiriq tä k'u na kib', xane k'ä te' aretaq xil na u wäch ri ral ri al María. Ri a José xukoj k'u JESÚS che u b'i'. ");
INSERT INTO qucNNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ri alaj a Jesús xil u wäch pa ri tinimit Belén, ri k'o pa Judea. Are chi' k'o ri tat Herodes che nim taqanel puwi' ronojel ri Judea. Xeopan k'u jujun achijab' ajno'jab' pa ri tinimit Jerusalén, jela' k'u kepe pa relb'al q'ij. ");
INSERT INTO qucNNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Xkita' k'u u tzijol chila', xkib'ij: ¿Jawije' käriqtaj wi ri nim taqanel ri kätaqan na pa ki wi' ri winaq aj Israel ri k'ä te' xil u wäch? Xa xqil ru ch'imil pa relb'al q'ij, rumal ri' xujpe chuq'ijilaxik, —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Aretaq ri tat Herodes ri nim taqanel xuta wa', sib'alaj xsach u k'ux, je' xuquje' konojel ri nik'iaj winaq aj Jerusalén. ");
INSERT INTO qucNNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Xtaqan k'u ri nim taqanel che ki sik'ixik ri ki nimaqil sacerdotes, xuquje' ri tijonelab' re ri Pixab', xuta' k'u chke jawije' kil wi na u wäch ri Cristo. ");
INSERT INTO qucNNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ri e are' xkib'ij che: Pa ri tinimit Belén ri k'o pa Judea, rumal chi ri q'alajisal re ru Loq' Pixab' ri Dios je wa' xutz'ib'aj: ");
INSERT INTO qucNNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ri at tinimit Belén, at ri' ri rech ri rulew ri Judá, machomaj chi ri at man nim tä a q'ij at chkiwäch ri q'atal taq tzij ri e k'o chila', rumal chi awuk' at kel wi na jun nim k'amal b'e, ri kuk'am na ki b'e ri nu winaq aj Israel, —kächa', —xecha ri tijonelab' re ri Pixab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Are k'u ri tat Herodes chelaq'al xeusik'ij ri ajno'jab', xuta' k'u chke jampa' qas xk'utun ri ch'imil. ");
INSERT INTO qucNNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Te ri' xeutaq b'i pa Belén, xub'ij b'i chke: Jix b'a' jela', chitatab'ela' jawije' k'o wi ri ak'al. Aretaq kiriqo, chixpe chub'ixik chwe, rech ri in xuquje' kine' na chuq'ijilaxik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ri ajno'jab' xuwi xkito ri xb'ix chke rumal ri nim taqanel, xeb'e'k. Are k'u ri ch'imil ri xkil pa relb'al q'ij xnab'ej chkiwäch, k'ä xopan na puwi' ri k'o wi ri ak'al, xtak'i k'u chila'. ");
INSERT INTO qucNNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ri ajno'jab', aretaq xkil ri ch'imil, sib'alaj xekikotik. ");
INSERT INTO qucNNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Xeb'ok k'u b'i pa ri ja, xkil k'u ri ak'al k'o ruk' ri al María ru nan. Xexuki'k, xkiq'ijilaj ri ak'al. Te k'u ri' xkijaq u wi' ri ki k'olib'al, xkisipaj q'än puaq, incienso, xuquje' mirra che ri Are'. ");
INSERT INTO qucNNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Te k'u ri' xb'ix chke pa achik' chi meok'ow chi jela' jawije' k'o wi ri tat Herodes. Xetzelej k'u b'i pa ri ki tinimit, xkik'am b'i jun b'e chik. ");
INSERT INTO qucNNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Aretaq e b'enaq chi ri ajno'jab', xpe jun ángel ri taqom loq rumal ri Dios, xuk'ut rib' chuwäch ri a José pa achik', xub'ij che: Chatwalijoq, chak'ama b'i ri ak'al, rachi'l ru nan, chixanimaj b'ik. Jix pa Egipto, chixkanaj k'u na kan chila' k'ä kinb'ij na chiwe jampa' kixpetik. Je ri' chib'ana rumal chi ri tat Herodes kutzukuj na u kämisaxik ri ak'al, —xcha ri ángel che. ");
INSERT INTO qucNNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Xwalij k'u ri a José, xuk'am ri ak'al, rachi'l ru nan, chaq'ab' k'ut xeb'el b'ik, xeb'e' pa Egipto. ");
INSERT INTO qucNNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Chila' xek'oji wi na k'ä xkäm na ri tat Herodes. Je' xb'antaj wa' rech qas je' kel wi jas ri xub'ij ri Dios rumal ri q'alajisal re ru Loq' Pixab' ri kub'ij: “Pa Egipto xinsik'ij wi loq ri nu K'ojol,” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Aretaq ri tat Herodes xretamaj chi man are tä qas tzij ri xb'ix kan che kumal ri ajno'jab', sib'alaj xpe royowal. Xutaq k'u ki kämisaxik konojel ri ak'alab' alab'om ri tz'aqat chi kieb' ki junab' xuquje' ri mäja' kätz'aqat kieb' ki junab' ri e k'o pa ri tinimit Belén xuquje' ri e k'o pa taq ri tinimit chunaqaj ri Belén, je' jas ri q'ij ri xkib'ij kan ri ajno'jab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Xa je ri' qas je' xel wi jas ri xutz'ib'aj kan ri qa mam Jeremías ri q'alajisal re ru Loq' Pixab' ri Dios ri kub'ij: ");
INSERT INTO qucNNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Xtataj k'ut chi k'o jun ri kuraq u chi' pa ri tinimit Ramá, nimalaj oq'ej wa', nimalaj b'is käb'anik. Are ri nan Raquel ri kub'isoj ki wäch ri ral, ri man kuya' taj käku'b'isax u k'ux rumal chi ya e käminaq chik ri ral, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Aretaq k'ut käminaq chik ri tat Herodes, jun ángel ri taqom loq rumal ri Dios xuk'ut rib' chuwäch ri a José pa achik' jela' pa Egipto, xub'ij che: ");
INSERT INTO qucNNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Chatwalijoq, chak'ama b'i ri ak'al awuk', xuquje' ru nan, chixtzelej chi na jumul pa Israel. Xekäm k'u konojel ri käkaj käkikämisaj ri ak'al, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Xwalij k'u ri a José, xuk'am b'i ri ak'al rachi'l ru nan, xtzelej chi na jumul pa Israel. ");
INSERT INTO qucNNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Aretaq k'ut ri a José xuto chi are ri tat Arquelao chik k'o che nim taqanel pa Judea chuk'exel ri Herodes ru tat, xuxej rib' xe' jela'. Xch'ab'ex k'u rumal ri Dios pa achik', rumal ri' jela' xe' wi pa Galilea. ");
INSERT INTO qucNNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Aretaq xopan chila', jela' xek'ol wi pa ri tinimit Nazaret. Je' xb'antaj wa' rech qas je' kel wi ri xkib'ij kan ri q'alajisal taq re ru Loq' Pixab' ri Dios, chi ri Jesús käb'ix na aj Nazaret che. ");
INSERT INTO qucNNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Pa taq ri q'ij ri' ri tat Juan Qasal Ja' xopan pa Judea, pa taq ri juyub' ri kätz'inowik. Tajin kutzijoj ru Loq' Pixab' ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Kub'ij k'u chke ri winaq: Chik'exa ri iwanima', chik'exa ri i chomanik, rumal chi xa jub'iq' chik man kuchaplej ru taqanik ri Dios, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","We tat Juan ri' are wa' ri xtz'ib'ax kan chrij ojer rumal ri qa mam Isaías, ri q'alajisal re ru Loq' Pixab' ri Dios ri kub'ij: K'o jun ri ko käch'aw pa taq ri juyub' ri ketz'inowik, kub'ij: “Chib'ana u b'anik ri nim b'e ri käb'in wi ri Qajaw. Chisuk'umaj, chib'ana sib'alaj jikom che,” —xcha ri qa mam Isaías. ");
INSERT INTO qucNNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Are k'u ri tat Juan xukoj atz'iaq ri b'anom ruk' ri rismal jun awaj, camello u b'i', tz'um k'u ru pas. Xa sak' xuquje' uwal che' xutijo. ");
INSERT INTO qucNNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Xepe k'u ri winaq aj Jerusalén, xuquje' ri e k'o pa taq nik'iaj taq tinimit chik re Judea xuquje' ri e k'o chunaqaj ri nima' Jordán, xeopan k'u ruk' ri tat Juan chutatab'exik ri kub'ij. ");
INSERT INTO qucNNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Aretaq xkiq'alajisaj ri ki mak, xb'an k'u ki qasna' rumal ri tat Juan pa ri nima' Jordán. ");
INSERT INTO qucNNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Aretaq k'ut xril ri tat Juan chi e k'ia chke ri tata'ib' fariseos xuquje' ri tata'ib' saduceos xepetik rech käb'an ki qasna', xub'ij chke: ¡Ri alaq sub'anelab' taq winaq! ¿Jachin k'u ri xb'in chech alaq chi rajwaxik kanimaj alaq chuwäch ri nimalaj royowal ri Dios ri käpetik? ");
INSERT INTO qucNNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","B'ana b'a' alaq ri taqal u b'anik, ri kuq'alajisaj chi qas tzij xk'extaj ri anima' alaq, ri chomanik alaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mächaplej k'u alaq u b'ixik pa anima' alaq: “Ri uj, uj rachalaxik kan ri qa mam Abraham.” Kinb'ij k'u chech alaq chi ri Dios käkowinik kub'an chke taq we ab'aj ri' chi e rachalaxik kan ri qa mam Abraham. ");
INSERT INTO qucNNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kämik ri' tajin käkoj ri ikiäj che taq ri ki xera' ri che' rech ket'oyik. Ronojel che' ri man kuya tä utzalaj u wäch, kät'oy k'u na wa', käporox na pa ri q'aq'. ");
INSERT INTO qucNNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ri in qas tzij kinb'an qasna' alaq ruk' joron, k'utb'al wa' chi k'exom chi anima' alaq, k'exom chi ri chomanik alaq. Käpe chi k'u na jun chik ri kub'an na qasna' alaq ruk' ri Loq'alaj Espíritu xuquje' ruk' q'aq'. Ri Are' nim na u q'ij chnuwäch in, nim k'u na u b'anik. Man taqal tä chwe in chi kinkir ru k'amal u xajäb'. ");
INSERT INTO qucNNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ri Are' are jas jun achi ri kujosq'ij ru triko. Ruk'am chi ru pala, kujopij k'u na ri triko, kutas che ri pajo. Kuk'ol na ri triko pa ri k'uja. Are k'u ri pajo kuporoj na pa jun q'aq' ri man kächup tä chik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Xel k'u loq ri Jesús pa Galilea, xopan chuchi' ri nima' Jordán ri k'o wi ri tat Juan rech käb'an u qasna' rumal. ");
INSERT INTO qucNNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Man xraj tä k'u ri tat Juan, xane xub'ij che ri Jesús: Ri in man taqal tä chwe chi kinb'an qasna' la. Rajwaxik ne chi ri lal käb'an la nu qasna' in, —kächa'. ¿Jas che xpe la wuk' in? —xcha che ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Xub'ij k'u ri Jesús che: Che we chanim ri', chaya chwe chi je' kinb'an wa'. Are k'u wa' taqalik rech käqa'no jachike ri kätaqan wi ri Dios, —xcha che. Ri tat Juan k'ut xunimaj ri xub'ij. ");
INSERT INTO qucNNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Aretaq k'ut xb'antaj u qasna' ri Jesús, xel loq ri Are' pa ri ja'. ¡Chanim xjaqjob' ri kaj! Ri Jesús k'ut xril ri Loq'alaj Espíritu xqaj loq puwi' ri Are', je' u b'anik jun palomäx. ");
INSERT INTO qucNNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Te ri' xtataj k'ut chi käch'aw loq jun chikaj ri xub'ij: Are ri Loq'alaj nu K'ojol wa'. Käkikot ri wanima' rumal, —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Te k'u ri' ri Loq'alaj Espíritu xuk'am b'i ri Jesús pa taq juyub' ri ketz'inowik, rech kätaqchi'x che mak chila' rumal ri Itzel. ");
INSERT INTO qucNNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kawinaq q'ij, kawinaq aq'ab' xk'oji chila', man k'o tä k'u jas ri xutijo. Te k'u ri' sib'alaj xnumik. ");
INSERT INTO qucNNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Xpe k'u ri Itzel, xopan ruk' ri Jesús rech kutaqchi'j ri Are' che mak, xub'ij che: We qas tzij chi lal u K'ojol ri Dios, taqan la chke taq we ab'aj ri' chi käka'n na wa, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Xch'aw ri Jesús, xub'ij che: Ru Loq' Pixab' ri Dios ri Tz'ib'talik kub'ij: “Man xaq tä xuwi rumal ri wa kek'asi na ri winaq, xane xuquje' rumal ronojel ru Tzij ri Dios,” —kächa', —xcha ri Jesús che. ");
INSERT INTO qucNNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ri Itzel xuk'am b'i ri Jesús pa ri loq'alaj tinimit Jerusalén, xupaqb'a k'u puwi' ri nimalaj rachoch Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Te ri' xub'ij che: We qas tzij chi lal u K'ojol ri Dios, k'iäqa b'i ib' la ikim, rumal chi ru Loq' Pixab' ri Dios ri Tz'ib'talik kub'ij: Ri Dios keutaq na loq ri ángeles awuk' che a chajixik. Katkichap na che ra q'ab' che a to'ik rech man kachaq'ij tä rawaqan cho ab'aj, —kächa', —xcha ri Itzel che. ");
INSERT INTO qucNNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ri Jesús xch'awik, xub'ij che: Xuquje' kub'ij ru Loq' Pixab' ri Dios ri Tz'ib'talik: “Mayak royowal ri Awajaw, ri a Dios,” —kächa', —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Te k'u ri' ri Itzel xuk'am b'i ri Jesús puwi' jun nimalaj juyub'. Xeuk'ut k'u konojel taq ri tinimit ajuwächulew chuwäch ri Are', xuquje' ri ki q'inomal. ");
INSERT INTO qucNNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Xub'ij k'u che ri Jesús: Ronojel wa' kinya che la, we käxuki la, kinq'ijilaj la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Xch'aw ri Jesús, xub'ij che: Jat, Satanás, chatel chnuwäch rumal chi ru Loq' Pixab' ri Dios ri Tz'ib'talik kub'ij: “Chaq'ijilaj ri Awajaw ri a Dios, xuwi k'u ri Are' chapatänij,” —kächa', —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Xel k'u b'i ri Itzel ruk' ri Jesús. Xepe k'u jujun ángeles rech kepatänin che ri Are'. ");
INSERT INTO qucNNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ri Jesús, aretaq xuto chi k'o ri tat Juan pa che', xe' pa Galilea. ");
INSERT INTO qucNNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Man xkanaj tä k'u kan pa ri tinimit Nazaret, xane xa xk'oji pa Capernaum, jun tinimit Romano wa' ri k'o chi' ri mar chkinaqaj ri ojer taq tinimit Zabulón ruk' Neftalí. ");
INSERT INTO qucNNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Je' xb'antaj wa' rech qas je' kel wi jas ri xutz'ib'aj kan ri qa mam Isaías ri q'alajisal re ru Loq' Pixab' ri Dios ri kub'ij: ");
INSERT INTO qucNNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Winaq aj Zabulón, winaq aj Neftalí, ix ri' ri naqaj ix k'o wi che ri mar, ch'äqäp che ri nima' Jordán, chila' pa Galilea jawije' e k'o wi winaq ri man aj Israel taj. ");
INSERT INTO qucNNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ri winaq ri je' ta ne e k'o pa q'equm xkil jun nimalaj saqil. E are' winaq wa' ri e k'o pa ri ki mak, ri e k'o cho ri kämikal, xpe jun nimalaj saqil pa ki wi', —xcha ri qa mam Isaías. ");
INSERT INTO qucNNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","K'ä te ri' k'ut ri Jesús xuchaplej u tzijoxik ru Loq' Pixab' ri Dios, xub'ij k'u chke ri winaq: Chik'exa ri iwanima', chik'exa ri i chomanik, rumal chi xa jub'iq' chik man kuchaplej ru taqanik ri Dios, —xcha chke ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ok'owem kub'an ri Jesús chuchi' ri mar re Galilea, xeril k'u kieb' achijab' kachalal kib'. Ri jun are ri tat Simón ri xuquje' käb'ix Pedro che, ri jun chik are ri tat Andrés. Tajin käkik'iäq b'i jun k'at chapäb'al kär pa ri cho rumal chi e chapal taq kär ri e are'. ");
INSERT INTO qucNNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ri Jesús xub'ij chke: Chixsa'j wuk'. Kinb'an k'u na chiwe chi kixok che ki mulixik winaq che ki k'exwäch ri kär, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Chanim xkiya kan ri ki k'at, xeb'e' ruk' ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ok'owinaq chi apan jub'iq' ri Jesús, xeril chi k'u kieb' achijab' chik kachalal kib'. E are' ri tat Jacobo rachi'l ri tat Juan. E u k'ojol ri tat Zebedeo wa'. E k'o pa jun barco kachi'l ri ki tat, tajin käkik'ojoj k'u ri ki k'at. Xesik'ix k'u rumal ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ri e are' k'ut chanim xkiya kan ri barco ruk' ri Zebedeo ri ki tat, xeb'e' ruk' ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ri Jesús xb'in pa konojel taq ri tinimit re Galilea, xuya tijonik chke ri winaq pa taq ri rachoch Dios. Xutzijoj ri Utzalaj Tzij re ri Evangelio chrij ru taqanik ri Dios pa ki wi' ri winaq. Xuquje' xukunaj ronojel u wäch yab'il ri k'o chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Xtataj k'u u tzijol ri Jesús kumal ri winaq pa konojel taq ri tinimit re Siria. Ri winaq k'ut xekik'am loq konojel ri ki riqom k'äx rumal k'ia u wäch k'äxk'ol, yab'il, q'oxom. Xekik'am loq ri e k'o itzel taq espíritus chke, xuquje' ri winaq ri man utz tä chi ki jolom rumal chi e elinaq ch'uj, xekik'am k'u loq ri käminaq ki cuerpo. Ri Jesús k'ut xeukunaj konojel. ");
INSERT INTO qucNNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","E k'ia winaq k'ut aj Galilea xeb'e' ruk' ri Jesús. Xuquje' e k'o winaq aj Decápolis, aj Jerusalén, aj Judea, e k'o k'u ri xepe ch'äqäp che ri nima' Jordán. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Aretaq ri Jesús xeril ri k'ialaj winaq, xpaqi puwi' ri juyub', xt'uyi chila'. Xkimulij k'u kib' ru tijoxelab' ruk'. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ri Jesús xuchaplej ki tijoxik, je wa' xub'ij chke: ");
INSERT INTO qucNNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Utz ke ri käkina' pa kanima' chi k'o ri rajwaxik chke ri käpe chila' chikaj. Ri Dios k'ut kätaqan na pa ki wi'. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Utz ke ri keb'isonik rumal chi ri Dios käku'b'isan na ki k'ux. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Utz ke ri man käka'n tä nimal. Ri e are' k'ut käkechb'ej na ri ulew ri u b'im ri Dios chi kuya chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Utz ke ri kenumik, ri kächaqi'j ki chi' che jun k'aslemal jikom. Are k'u ri Dios käyo'w na wa' chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Utz ke ri kel ki k'ux chke nik'iaj winaq chik. Ri Dios k'ut kutoq'ob'isaj na ki wäch ri e are'. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Utz ke ri saq kanima'. Ri e are' k'ut käkil na u wäch ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Utz ke ri käkitzukuj u ya'ik utzil chkixol ri winaq. Ri Dios kub'ij na chi e are' ralk'ual ri Are'. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Utz ke ri ketzelax ki wäch rumal ru b'anik ri jikomal cho ri Dios. Ri Dios k'ut kätaqan na pa ki wi'. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Utz iwe ix aretaq käb'an k'äx chiwe kumal ri winaq, kixyoq' kumal, käkib'ij ronojel u wäch ri man qas tzij taj chiwij, xa rumal chi kixkojon chwe in. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Chixkikot b'a', chixtze'noq rumal chi kik'am na jun nimalaj tojb'al iwe chila' chikaj. Je k'u k'äx wa' xb'an chke ri q'alajisal taq re ru Loq' Pixab' ri Dios ri xek'oji kan ojer, —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ri ix, je' ta ne ix atz'am chke ri winaq cho ruwächulew. We k'u man k'o chik u tzayil ri atz'am, ¿jas ta k'u lo käb'an che rech k'o chi kupatänij? Man k'o tä chi u patän ri', xane xa käk'iäq na apanoq, kätak'alex k'u na kumal ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ri ix, je' ta ne ix saqil chke ri winaq cho ruwächulew je' jas jun tinimit ri k'o puwi' jun juyub', ri amaq'el käq'alajinik. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Man kätzij tä jun chäj, te k'u ri' käyi' chuxe' jun koxon, xane xa käyi' ri' pa jun k'olib'al chikaj rech kätunun pa ki wi' konojel ri e k'o pa ri ja. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Je wa' chib'ana ix xuquje', chib'ana' chi ri saqil ri k'o iwuk' kätunun chkiwäch ri winaq. Je ri' rech aretaq käkil ri utzil ri kib'ano, käkiya u q'ij ri i Tat ri k'o chila' chikaj. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Michomaj ix chi in petinaq che resaxik ri Pixab' ri xutz'ib'aj kan ri qa mam Moisés, o ri ki tijonik ri q'alajisal taq re ru Loq' Pixab' ri Dios. Man in petinaq tä che resaxik, xane in petinaq chub'ixik ri qas u b'anik ri Pixab' xuquje' ri ki tijonik ri q'alajisal taq re ru Loq' Pixab' ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Qas tzij kinb'ij chiwe, man k'o tä kesax na che ri Pixab', xane xa ronojel käb'antaj na. K'ä mäjoq käsach u wäch ri kaj ulew, man k'o tä jun punto, man k'o tä jun alaj tz'ib' ri kesax na che ri Pixab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Rumal ri' jachin ri man kunimaj tä jun chke ri taqanik re ri Pixab', pune are ri man nim tä u b'anik, xuquje' kuk'ut chkiwäch nik'iaj winaq chik chi man qas rajwaxik taj känimax wa', ri are' man nim taj kil wi na chkixol ri winaq ri kätaqan na ri Dios pa ki wi'. Are k'u ri winaq ri kunimaj ri Pixab', xuquje' kuk'ut chkiwäch nik'iaj winaq chik chi käkinimaj wa', qas nim na u b'anik wa' chkixol ri winaq ri kätaqan na ri Dios pa ki wi'. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kinb'ij k'u chiwe, chi we man jikom na ri i k'aslemal ix chuwäch ri ki k'aslemal ri tata'ib' fariseos xuquje' ri tijonelab' re ri Pixab', man kixok tä ri' chkixol ri winaq ri kätaqan na ri Dios pa ki wi'. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ri ix i tom chi xb'ix chke ri qa mam ojer: “Mixkämisanik, apachin k'u ri käkämisanik käq'at na tzij puwi',” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Are k'u ri in kinb'ij chiwe chi jachin ri kuyak royowal chrij ri rachalal käq'at na tzij puwi'. Jachin ri k'äx käch'aw che ri rachalal käq'at na tzij puwi' kumal ri q'atal taq tzij. Xuquje' jachin ri kub'ij che ri rachalal chi xa are jun kon, chi man k'o tä chi u patän, ke' na ri' pa ri q'aq'. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Rumal k'u ri', we kak'am b'i ri a sipanik cho ri ta'b'al toq'ob', chila' k'ut käna'taj chawe chi k'o jun k'äx ri kuna' ri awachalal chawij, chaya kan ri a sipanik cho ri ta'b'al toq'ob'. Jat na ruk' ri awachalal rech katutzir ruk' nab'e, te k'u ri' kuya' kattzelej cho ri ta'b'al toq'ob' chuya'ik ra sipanik cho ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","We k'o jun winaq kub'an u k'ulel chawe, katuk'am k'u b'i pa ri q'atb'al tzij, chatutzir na ruk' pa ri b'e rech man katujach tä pu q'ab' ri q'atal tzij. We ta mat je ri', ri q'atal tzij katujach na pa ki q'ab' ri mayor, ri mayor k'ut katkikoj na pa che'. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Qas tzij b'a' ri kinb'ij chawe chi man k'o tä awelik loq chila' k'ä katoj na ronojel ri a multa, —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ri ix i tom chi xb'ix kan nab'e: “Mab'an ri nimalaj mak ri äwas u b'anik chrij ra k'ulaj,” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Are k'u ri in kinb'ij chiwe, chi jachin ri kuka'yej jun ixoq, xaq xuwi ruk' ru rayixik u wäch xmakun ri' ruk' pa ranima', —kächa ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","We ri awaq'äch re ri awikiäq'ab' kub'ano chi katzaq pa mak, chawesaj, chak'iäqa apanoq. Are utz na chawe we kel jun ch'äqap che ra cuerpo, chuwäch wa' chi ronojel ra cuerpo käk'iäq b'i pa ri q'aq'. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","We k'u are ri a q'ab' re ri awikiäq'ab' kub'ano chi katzaq pa mak, chaq'ata', chak'iäqa apanoq. Are k'u utz na chawe we kel jun ch'äqap che ra cuerpo, chuwäch wa' chi ronojel ra cuerpo käk'iäq b'i pa ri q'aq', —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","(Käch'aw chi ri Jesús, kub'ij:) Xuquje' xb'ix kan nab'e: “Apachin ri kujach b'i ri rixoqil, rajwaxik kuya b'i jun wuj che ri kub'ij wi chi jachom kanoq,” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ri in k'ut kinb'ij chiwe, chi we jun achi kujach b'i ri rixoqil man rumal tä u ch'ab'exik jun achi chik, kub'an ri' chi ri rixoqil kub'an ri nimalaj mak ri äwas u b'anik. Jachin k'u ri käk'uli ruk' jun ixoq ri jachom b'ik, kub'an ri' ri nimalaj mak ri äwas u b'anik, —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Xuquje' i tom ri' ri xb'ix chke ri qa mam ojer: “Qas chab'ana' jas ri xachi'j u b'anik ruk' juramento cho ri Qajaw Dios,” —xeuchixik. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ri in k'ut kinb'ij chiwe, chi mib'an juramento aretaq k'o ri kichi'j che jun winaq chik. Mib'an juramento ruk' ri kaj rumal chi chila' k'o wi ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mib'an juramento ruk' ruwächulew rumal chi are je' ta ne u tak'alib'al ri raqan ri Dios. Mib'an juramento ruk' ri tinimit Jerusalén rumal chi are u tinimit ri Dios ri Nimalaj Taqanel. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Xuquje' mib'an juramento ruk' ri i jolom, rumal chi man kixkowin taj kib'an saq o q'eq che xa jun i wi'. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Xane xaq xuwi chib'ij “je', je ri'” o “man je' taj”, —kixcha'. Are k'u ri tzij ri xaq u wi' tzij chik, rech ri Itzel ri', —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ri ix i tom chi xb'ix kan nab'e: “We jun käresaj u waq'äch jun winaq chik, kesax na ru waq'äch ri are'. We jun käresaj u ware jun winaq chik, kesax na ru ware ri are',” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Are k'u ri in kinb'ij chiwe: Chixel chuwäch ri itzel achi ri kraj käch'ojin iwuk'. Xane we k'o jun katch'ayow che ri juperaj a palaj, chaya ri juperaj a palaj chik chuwäch. Mitzelej u k'exel ri k'äx ri käb'an chiwe. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","We k'o jun kraj katusik'ij pa q'atb'al tzij, kraj k'ut kumaj ri a kamixa', chaya b'i ra chaket che xuquje'. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","We k'o jun kukoj u chuq'ab' chawe chi kak'am b'i jun eqa'n ri käb'inib'ej jun legua, chak'ama b'i kieb' legua ruk'. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Apachin ri k'o jas kuta' chawe, chaya che. Makowirisaj ri awanima' chuwäch ri winaq ri kraj käqajan awuk'. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Xuquje' i tom ri' ri xb'ix kan nab'e: “Loq' chawila wi ri awachi'l, chawetzelaj k'u u wäch ri a k'ulel,” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Are k'u ri in kinb'ij chiwe: Loq' chiwila wi ri i k'ulel. Chib'ij: Ri Dios k'o pi wi', —kixcha chke ri winaq ri keyoq'on chiwe. Chib'ana utzil chke ri käketzelaj i wäch, chib'ana b'a' orar pa ki wi' ri xaq käka'n k'äx chiwe. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","We je' kib'an wa' q'alaj ri' chi qas ix ralk'ual ri qa Tat ri k'o chila' chikaj. Are k'u ri qa Tat kesan loq ri q'ij pa ki wi' ri utzalaj taq winaq, xuquje' pa ki wi' ri itzel taq winaq. Kutaq k'u loq ri jäb' pa ki wi' ri käka'n ri jikomal, xuquje' pa ki wi' ri man käka'n tä ri jikomal. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Are k'u we xaq xuwi keiwaj ri kixkaj ix, ¿jas ta k'u che käyi' na tojb'al re wa' chiwe rumal ri Dios? Xuquje' ne ri toq'il taq alkab'al käkaj kib' ri e are'. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","We xaq xuwi kiya rutzil ki wäch ri iwachalal, ¿a kichomaj lo ri' chi i b'anom jun nimalaj utzil? Je k'u ne wa' xuquje' käka'n ri man qas ketam tä u wäch ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Je b'a' chib'ana ix jas ri qa Tat ri k'o chila' chikaj. Ri Are' tz'aqat pa ru chomab'al. Ri ix xuquje' chib'ana tz'aqat pa ri i chomab'al, —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ru patänixik ri Dios ri kib'ano, mib'an wa' chkiwäch ri winaq xaq rech käkilo, käkiya k'u i q'ij. We je' kib'an wa', ri qa Tat ri k'o chila' chikaj man k'o tä tojb'al iwe kuya na. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Rumal ri' aretaq keito' ri k'o ki rajwaxik, mitzijoj chke konojel ri winaq, je' jas ri käka'n ri winaq ri xaq kieb' ki wäch käkitzijoj chke konojel ri winaq pa taq ri rachoch Dios, pa taq ri b'e. Je' käka'n wa' xaq xuwi rech utz kech'aw ri winaq chkij. Qas tzij k'ut kinb'ij chiwe chi ri käb'ix chkij xuwi wa' ri tojb'al ke käkiriq na. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Xane ri ix aretaq k'o jas u wäch jun tob'anik ri kiya chke ri k'o ki rajwaxik, k'o jun metamanik. Mitzijoj ne wa' che ri utzalaj iwachi'l. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Chib'ana b'a' ri utzil xaq chelaq'al. Ri qa Tat k'ut ri kilow ronojel ri kib'an chelaq'al, are käyo'w na ri tojb'al iwe, —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ri ix aretaq kib'an orar mib'an iwe jas ri käka'n ri winaq ri xaq kieb' ki wäch, ri käqaj chkiwäch xaq e tak'atoj käka'n orar pa taq ri rachoch Dios, pa taq ri u cruz taq b'e. Xaq are käkaj chi ke'ilitaj kumal ri winaq. Qas tzij kinb'ij chiwe chi xuwi wa' ri tojb'al ke käkiriq na. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Xane ri ix aretaq kib'an orar, chixok pa ja, chitz'apij ri uchija. Chib'ana orar chuwäch ri qa Tat ri k'o iwuk' pa i tukiel wi. Ri qa Tat k'ut ri kilowik chi tajin kib'an orar chelaq'al, are käyo'w na ri tojb'al iwe. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Aretaq kib'an orar, mib'ij k'ia tzij ri man k'o tä ki patän, jas ri käka'n ri winaq ri man qas ketam tä u wäch ri Dios. Ri e are' käkichomaj chi ri Dios keutatab'ej xa rumal chi k'ia ri käkib'ij pa taq ri oración ri käka'no. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mib'an b'a' iwe jas ri käka'n ri e are'. Rumal chi ri qa Tat retam chik jas ri rajwaxik chiwe k'ä mäja' kita' wa' che. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Rumal ri' aretaq kib'an orar, je wa' chib'ij: Qa Tat ri k'o la pa ri kaj, chnimarisax ta na u q'ij ri b'i' la. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Taqan na la pa ki wi' konojel winaq. B'ana b'a' na la ri rayib'al la cho ruwächulew, jas ri käb'an chila' chikaj. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ya la chqawäch ri käqatijo, jas ri rajwaxik chqe kämik. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Sacha la ri qa mak ri qa'nom je' jas ri uj käqasach ri ki mak ri käka'n k'äx chqe. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mäya la chqe chi kujtaqchi'x che mak, xane chujto' la cho ri Itzel. Ronojel wa' käqata' che la rumal chi ri lal kätaqan la puwi' ronojel. K'o nimalaj chuq'ab' uk' la puwi' ronojel, chnimarisax ta b'a' q'ij la amaq'el pa taq ri q'ij ri junab' ri kepetik. Amén. (Je wa' kib'ij aretaq kib'an orar, —xcha ri Jesús chke.) ");
INSERT INTO qucNNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","We ri ix kisach ki mak nik'iaj winaq chik ri ka'nom k'äx chiwe, ri qa Tat ri k'o chila' chikaj xuquje' kusach na ri i mak ix. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Are k'u we man kisach ki mak nik'iaj winaq chik, ri qa Tat man kusach tä na ri i mak ix, —xcha ri Jesús chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Aretaq ri ix kib'an ayuno mib'an iwe jas ri käka'n ri achijab' ri xaq kieb' ki wäch. Ri e are' käka'n che kib' chi keb'isonik. Je' käka'n wa' xaq rech käkil ri winaq chi tajin käka'n ayuno. Qas tzij kinb'ij chiwe chi xuwi wa' ri tojb'al ke käkiriq na. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ri ix k'ut aretaq kib'an ayuno, chich'aja ri i palaj, utz kib'an chuxayik ri i wi'. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Je wa' kib'ano rech ri winaq man käkich'ob' taj chi tajin kib'an ayuno, xane xaq xuwi ri qa Tat ri k'o iwuk' pa i tukiel wi kilowik. Are k'ut käyo'w na ri tojb'al iwe. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Mimulij i q'inomal waral cho ruwächulew, rumal chi waral xa kechikopir ri jastaq, xa keq'elob'ik, xa kelaq'axik. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Xane are chimulij i q'inomal chila' chikaj, jawije' ri man kechikopir tä wi, man keq'elob' taj, man kelaq'ax tä k'ut. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ri k'o wi ri i q'inomal, chila' ri' b'enaq wi ri iwanima', —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ri a waq'äch are je' jas jun candela ri kuya saqil chawe. We utz ri a waq'äch, q'alaj ri' ri a b'e chawäch. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","We k'u man utz ra waq'äch, man q'alaj tä ri' ra b'e, at k'o ri' pa q'equm. We ri saqil ri k'o pa ri awanima' kub'an q'equm, ¡sib'alaj nim na ri q'equm ri'! —xcha ri Jesús chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Man k'o tä jun winaq käkowinik keupatänij kieb' patrón. Käretzelaj k'u na u wäch ri jun, loq' käril na ri jun chik. Kub'an ri jikomal ruk' ri jun, man nim tä k'u käril wi ri jun chik. Jun winaq man kuya' taj kupatänij ri Dios we b'enaq u k'ux ruk' ri q'inomal, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Rumal ri' kinb'ij chiwe: Mixok il che jas ri kib'an chuch'akik ri i wa o ri kitijo. Mixok il che ri iwatz'iaq ri kikojo. Are k'u nim na u b'anik ri k'aslemal chuwäch ri kitijo, are k'u nim na u b'anik ri i cuerpo chuwäch ri atz'iaq ri kikojo. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Chiwilampe ri chikop ri kerapap chikaj. Man käka'n tä tiko'n, man käkiyak tä k'u u wäch ri tiko'n chuk'olik wa' pa taq k'uja. Pune je ri', ri qa Tat ri k'o chila' chikaj ketzuquwik. Nim k'u na i q'ij ix chkiwäch ri chikop ajuwokaj. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿A k'o lo jun chiwe ri käkowinik käk'asi chi na kieb' oxib' junab' xa rumal chi sib'alaj kok il che? ¡Man k'o taj! —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Jas k'u che sib'alaj kixok il che ri iwatz'iaq? Chiwilampe ri kotz'ij pa taq ri juyub' jas käka'no kek'iyik. Man keb'atz'in taj, xuquje' man kekiemen taj. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kinb'ij k'u chiwe chi pune ta ne je ri', ri nim taqanel Salomón, ruk' ronojel ru q'inomal, man xkowin tä xukoj jun ratz'iaq je' jas jun chke we kotz'ij ri', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","We ri Dios je wa' u b'anom che ri katz'iaq ri q'ayes ri e k'o kämik pa juyub', chuweq k'ut xa keyi' na pa ri q'aq', ¡e ta k'u lo ri ix! ¿A mat kixrilij na ri Dios che ri iwatz'iaq? Ri ix xa jub'iq' kixkojonik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Rumal ri', mixok b'a' il, mib'ij: “¿Jawije' käpe wi ri qa wa? o ¿jawije' käpe wi ri käqatijo? o ¿jawije' käpe wi ri qatz'iaq?” —mixcha', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Konojel k'u we jastaq ri' are ri käkitzukuj ri winaq. Are k'u ri ix k'o ri i Tat chila' chikaj ri retam chi keajwataj wa' chiwe. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Rumal ri' are nab'e chitzukuj chi ri Dios kätaqan pa ri i k'aslemal, xuquje' chib'ana ri jikomal chuwäch ri Are', käya'taj k'u na ronojel ri kajwataj chiwe. ");
INSERT INTO qucNNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mixok b'a' il che ri chuweq. Ri chuweq k'o na ri k'äx käriqtajik jas ri kämik. Ruk' wa' ri i kosik re ri q'ij kämik, —xcha ri Jesús chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Miq'at tzij pa ki wi' nik'iaj winaq chik, rech ri Dios man kuq'at tä tzij pi wi' ix. ");
INSERT INTO qucNNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ri Dios je' u q'atik tzij kub'an na pi wi' ix jas ru q'atik tzij kib'an ix pa ki wi' nik'iaj winaq chik. Jas ri pajb'al ri kikoj ix chke nik'iaj winaq chik, je' käkoj na chiwe ix. ");
INSERT INTO qucNNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Jas che kab'ij tzij chkij nik'iaj winaq chik? ¡Je' ta ne chi kawil ri in nitz' mes ri k'o pa ru waq'äch ri awachalal, man kawil tä k'u ri a mak at ri je' jas jun kuta'm ri k'o pa ra waq'äch! ");
INSERT INTO qucNNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","We ri at k'o jun kuta'm pa ra waq'äch, ¿a kuya' lo ri' kab'ij che ri awachalal: “Chaya chwe chi kinwesaj koq ri in nitz' mes ri k'o pa ra waq'äch”? ");
INSERT INTO qucNNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Ri at xaq kieb' a wäch! Chawila' nab'e jas u b'anik ra k'aslemal at, je' ta ne chi kawesaj jun kuta'm ri k'o pa ra waq'äch. Je ri' qas katka'y na che resaxik koq ri in nitz' mes ri k'o pa ru waq'äch ri awachalal. ");
INSERT INTO qucNNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Meiya ri loq'alaj taq jastaq ri rech ri Dios chke taq ri tz'i', mepe k'u ne chiwij, käka'n k'u ch'aqataq chiwe. Meiya ri je'lalaj taq ab'aj perlas chkiwäch taq ri aq, xaq k'u ne mäkitak'alej. ");
INSERT INTO qucNNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Chita' ri kiwaj, käya'taj k'u na wa' chiwe rumal ri Dios. Chitzukuj ruk' ri Dios, kiriq k'u na. Chik'orok'a ri uchija, käjaqtaj k'u na wa' chiwäch. ");
INSERT INTO qucNNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Je ri', rumal chi jachin ri k'o jas kuta', käya'taj na che. Jachin ri k'o kutzukuj, k'o kuriqo, jachin k'u ri kuk'orok'a ri uchija, käjaqtaj na wa' chuwäch. ");
INSERT INTO qucNNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿A k'o lo jun chiwe ri kuya jun ab'aj che ri u k'ojol aretaq kuta' u wa? ");
INSERT INTO qucNNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿A kuya ne lo jun kumätz che aretaq kuta' jun kär? ");
INSERT INTO qucNNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","We ri ix, ix ajmakib', kixkowin chuya'ik utzalaj taq jastaq chke ri iwalk'ual, ¿a mat ri i Tat ri k'o chila' chikaj keuya na utzalaj taq jastaq chke ri käkita' che? ");
INSERT INTO qucNNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Je k'u ri', jas ri kiwaj ix chi käka'n ri winaq chiwe, je' chib'ana ix chke ri e are' xuquje'. Are k'u je wa' ri kub'ij ri Pixab' ri xutz'ib'aj ri qa mam Moisés, xuquje' je wa' kub'ij taq ri wuj ri xkitz'ib'aj kan ri q'alajisal taq re ru Loq' Pixab' ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Chixok b'i pa ri uchib'e ri latz' u wäch. Ri uchib'e xuquje' ri b'e ri ke' pa ri k'äx jawije' käsach wi ki wäch ri winaq, nim ki wäch. E k'ia k'ut ri keb'ok pa ri uchib'e ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Are k'u ri uchib'e xuquje' ri b'e ri ke' pa ri k'aslemal ruk' ri Dios, nu'ch ki wäch xuquje' sib'alaj k'äx. Man e k'ia tä k'ut ri keriqowik. ");
INSERT INTO qucNNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Chichajij iwib' chkiwäch ri achijab' ri xaq e b'anal taq tzij, ri käka'n che kib' chi e q'alajisal taq re ru Loq' Pixab' ri Dios. E are k'u wa' kepe iwuk', sib'alaj utz kepetik je' ta ne chij ri kij, are k'u chkipam e jiq'ab' taq utiw. ");
INSERT INTO qucNNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ri ix kich'ob' na jachin taq wa' rumal ri käka'no. Je' jas jun che' käch'ob'taj u wäch rumal ru wächinik. ¿A k'o lo jumul ri ketam uvas chrij ri k'ix? ¿A ketam lo higos chrij ri tzäkäm? ¡Man je' taj! ");
INSERT INTO qucNNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Je k'u ri' ronojel utzalaj che' utz ri u wäch ri kuya'. Are k'u ri che' ri man utz taj, man utz tä ru wäch ri kuya'. ");
INSERT INTO qucNNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ri utzalaj che' man käkowin taj kuya ru wäch ri man utz taj. Ri che' ri man utz taj man käkowin taj kuya utzalaj u wäch ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ronojel che' ri man kuya tä utzalaj u wäch, kät'aqix na, käk'iäq na ri' pa ri q'aq'. ");
INSERT INTO qucNNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Je wa ri' ri ix qas kich'ob' na jas ki b'anik ri winaq rumal ri käka'no, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Man konojel tä winaq keb'ok chila' jawije' ri kätaqan wi ri Dios, pune käkib'ij chwe: “Qajaw, Qajaw,” —kecha ri', xane xaq xuwi ri keb'anow ru rayib'al ri nu Tat ri k'o chila' chikaj. ");
INSERT INTO qucNNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","E k'ia ri käkib'ij na chwe pa ri q'ij ri': “Qajaw, Qajaw, ri uj qa yo'm tzijonem pa ri b'i' la. Pa ri b'i' la xeqesaj b'i itzel taq espíritus chke ri winaq, xuquje' are pa ri b'i' la ri xqa'n k'ia u wäch kajmab'al,” —kecha na. ");
INSERT INTO qucNNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ri in k'ut kinb'ij na chke: “Man wetam tä i wäch. Chixel b'i chnuwäch, ri ix xaq ix b'anal taq etzelal,” —kincha na chke, —xcha ri Jesús chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Je k'u ri' jachin ri kutatab'ej ri nu tzij, kub'an k'ut jas ri kinb'ij, are je ri' jas jun achi ri k'o u no'j, ri xuyak ri rachoch pa ab'aj. ");
INSERT INTO qucNNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Xqaj k'u ri jäb', xek'iy taq ri ja', xpe jun nimalaj kiäqiq' chrij ri ja, man xtzaq tä k'ut rumal chi ru tak'alib'al are ab'aj. ");
INSERT INTO qucNNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Jachin k'u ri kutatab'ej ri nu tzij, man kub'an tä k'ut jas ri kinb'ij, junam ri' ruk' jun achi ri man kuch'ob' taj jas ri kub'ano, ri xuyak ri rachoch puwi' ri senyäb'. ");
INSERT INTO qucNNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Xqaj ri jäb', xek'iy taq ri ja', xpe jun nimalaj kiäqiq' chrij ri ja, xtzaq k'u ri ja. ¡Ronojel xa xwulijik! —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Aretaq ri Jesús xto'taj che tzijonem, ri winaq sib'alaj xkikajmaj ru tijonik. ");
INSERT INTO qucNNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Je ri', rumal chi ri u tijonik kuk'utu chi are je' jas jun ri k'o u taqanik pa ki wi', man je' taj jas ri xka'n ri tijonelab' re ri Pixab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Aretaq ri Jesús xqaj loq cho ri juyub', e k'ia winaq xeteri loq chrij. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Xopan k'u ruk' ri Jesús jun achi ri k'o itzel ch'a'k che. Xxuki chuwäch ri Jesús, xub'ij che: Tat, ri in wetam chi käkowin la che nu kunaxik we kaj la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Xuyuq k'u ru q'ab' ri Jesús, xuchap koq ri achi, xub'ij che: ¡Kwaj! Chutzir b'a' la, —xcha che. Xuwi wa' xub'ij ri Jesús. Xutzir k'u ri achi ri k'o ri itzel ch'a'k che. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Xub'ij k'u ri Jesús che: ¡Tampe la! K'o jas mäb'ij la che jachin jun. Oj la, jek'utu ib' la cho ri sacerdote. Ya la ri sipanik ri taqom kan rumal ri qa mam Moisés chi käyi'k aretaq käkunataj jun ri k'o itzel ch'a'k che. Are k'u q'alajisab'al wa' chkiwäch ri winaq chi utzirinaq chi la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Aretaq xopan ri Jesús pa ri tinimit Capernaum, xpe jun achi ruk'. Are jun chke ri ki nimal soldados aj Roma. Xuta' k'u jun toq'ob' che ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Je wa' xub'ij: Tat, ri ala ri patänil we qajinaq pa ch'at cho ja, käminaq u cuerpo. Sib'alaj k'äx u riqom rumal ri yab'il, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ri Jesús xub'ij che: Kine' na chukunaxik, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ri ki nimal soldados xch'awik, xub'ij che ri Jesús: Tat, man taqal tä chwe chi kok la pa ri wachoch. Xaq xuwi taqan la chi kel ri yab'il che ri patänil we, ruk' k'u wa' kutzir na, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ri in xuquje' k'o jun ri kätaqan pa nu wi' ri nim u b'anik. Xuquje' ri in e k'o nu soldados ri kintaqan pa ki wi'. Aretaq kinb'ij che jun chke ri nu soldados chi ke'k, ke' k'ut. Aretaq kinb'ij che jun chik chi käpetik, käpe k'u ri are'. Aretaq kintaq ri patänil we chub'anik jun chak, ri are' kub'an ri kinb'ij, —xcha ri ki nimal soldados che ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Aretaq ri Jesús xuta wa', sib'alaj xukajmaj, xub'ij k'u chke ri winaq ri e teren chrij: Qas tzij kinb'ij chiwe, chi man k'o tä jumul ri nu riqom chkixol ri winaq aj Israel jun achi jas we achi ri' ri sib'alaj käkojon chwe, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Kinb'ij k'u chiwe chi e k'ia ri kepe na chrelb'al q'ij, xuquje' chuqajb'al q'ij, ri ket'uyi na junam ruk' ri qa mam Abraham, ri qa mam Isaac, ri qa mam Jacob chuchi' ri mesa chila' jawije' ri kätaqan wi ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Are k'u ri xa xkichomaj keb'ok chila' jawije' ri kätaqan wi ri Dios, man keb'ok taj rumal chi man xekojon taj. Xane xa kek'iäq na b'i pa ri q'equm. Chila' k'ut keb'oq' wi na, chila' käkiquch'uch'ej wi na ri ki ware, —xcha ri Jesús chke ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Te ri' xub'ij ri Jesús che ri ki nimal soldados: Oj la cho ja. Rumal chi xkoj la chi käkunataj ri ala, je k'u käb'antaj na, —xcha che. Tzare chi' k'ut xutzir ri ala aretaq xub'ij ri Jesús wa' we tzij ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ri Jesús xe' cho rachoch ri tat Pedro, xril k'u ru ji' chichu' ri tat Pedro qajinaq pa ch'at rumal jun nimalaj q'aq'. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ri Jesús xuchap ri chichu' che ru q'ab', xel k'u ri q'aq' chrij. Chanim k'ut xwalijik, xuchap ki patänixik. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Aretaq xq'eqal chik, e k'ia winaq ri k'o itzelalaj taq espíritus chke xek'am b'i cho ri Jesús. Xa k'u ruk' jun tzij ri xub'ij ri Jesús xeb'el b'i ri itzelalaj taq espíritus, xuquje' xeukunaj konojel taq ri yawab'ib'. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Je' xb'antaj wa' rech je' kelik jas ri xub'ij ri qa mam Isaías ri q'alajisal re ru Loq' Pixab' ri Dios: “Ri Are' xuriq k'äx rumal qech, xuya qa chuq'ab', xujukunaj che ri qa yab'ilal,” —xcha ri qa mam Isaías. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ri Jesús xrilo chi e k'ia winaq ki mulim kib' ruk', xub'ij chke ru tijoxelab': Chujq'ax ch'äqäp che ri mar, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Xpe k'u jun tijonel re ri Pixab', xqeb' k'u ruk' ri Jesús, xub'ij che: Ajtij, kwaj kine' uk' la apawije' ta ne ri ke' wi la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Xch'aw k'u ri Jesús, xub'ij che: Ri yak k'o ki jul, xuquje' ri chikop ri kerapap cho ri kaj k'o ki sok. Are k'u ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, man k'o tä jawije' ri kinwar wi, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Jun achi chik, jun chke ru tijoxelab', xub'ij che ri Jesús: Tat, ya la chwe chi nab'e kine'k, kinmuq kan ri nu tat aretaq käkämik, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Xch'aw k'u ri Jesús, xub'ij che: Tasa'j at wuk', chaya chke ri käminaqib' chi chkimuqu ri ki käminaq, —xcha ri Jesús che. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Te ri' xok ri Jesús pa ri barco, ru tijoxelab' k'ut xeb'e' ruk'. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Xpe k'u jun nimalaj kiäqiq' ri sib'alaj k'äx puwi' ri ja', je ri' chi ri nimaq taq uwoja' tajin keb'ok pa ri barco. Are k'u ri Jesús tajin käwarik. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Xeb'e' k'u ru tijoxelab', xekik'asuj, xkib'ij che: ¡Qajaw Jesús, chujto' la! ¡Tajin kujkämik! —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Xch'aw k'u ri Jesús, xub'ij chke: ¿Jas che sib'alaj kixej iwib'? ¡Ri ix qas tzij man nim tä más ri i kojonik! —xcha chke. Xwalij k'u ri Jesús, xuyaj ri kiäqiq' xuquje' ri mar. Xtäni k'u ri kiäqiq', xlilob' ronojel ru wi' ri mar. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ri achijab' sib'alaj xkikajmaj, xkib'ij k'ut: ¿Jachin lo ri' we achi ri', chi ri kiäqiq' xuquje' ri ja' re ri mar keniman che? —xecha ri achijab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Aretaq xeopan ch'äqäp che ri mar, pa ri ki tinimit ri winaq aj Gadara, xeb'el loq kieb' achijab' pa ri campo santo chkixol taq ri muqub'al, xeopan k'u ruk' ri Jesús. E k'o itzel taq espíritus chke we achijab' ri'. Sib'alaj xib'ib'al kepetik, je ri' chi man k'o tä chi jun käkowinik kok'ow pa ri b'e ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Xkichap k'u u raqik ki chi', ko xech'awik, xkib'ij che ri Jesús: ¿Jas kaj la chqe uj, Jesús, lal ri' ri u K'ojol ri Dios? ¿A petinaq la waral chub'anik k'äx chqe pune mäja' kuriq ri q'ij? —xecha che ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","E k'ia k'u ri aq tajin keyuq'ux apan chila' pa ri juyub' ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ri itzel taq espíritus xeb'ochi'n che ri Jesús, xkib'ij che: We kujesaj b'i la, ya la chqe chi kujok chke ri aq, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Xub'ij k'u ri Jesús chke: Jix b'a', chixok chke ri aq, —xcha chke. Xeb'el k'u b'i ri itzel taq espíritus chke ri achijab', xeb'ok b'i chke ri aq. Konojel k'u ri aq xkik'iäq b'i kib' chutza'm ri juyub', xeqaj k'u pa ri mar, xejiq'ik. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Are k'u ri ajyuq'ab' taq aq sib'alaj xkixej kib', xeanimaj b'ik, xeb'e'k. Aretaq xeopan pa ri tinimit xkesaj u tzijol wa' ri xkilo, xuquje' ri xb'antaj kuk' ri achijab' ri xek'oji ri itzel taq espíritus chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Konojel k'u ri winaq ri e k'o pa ri tinimit xeb'e' jela' jawije' k'o wi ri Jesús. Aretaq xkil ri Jesús, xkib'ochi'j, xkib'ij che chi chel b'i pa ri ki tinimit. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Te k'u ri' xok ri Jesús pa jun barco, xq'ax ch'äqäp che ri cho, xopan k'u pa ru tinimit ri Are'. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Xk'am k'u b'i jun achi cho ri Jesús ri käminaq u cuerpo, q'oyol k'u ri' cho jun alaj ch'at. Aretaq ri Jesús xrilo chi ri achijab' ri e teleninaq loq sib'alaj kekojon che, xub'ij che ri yawab': Mäb'ison chi la, tat, ri mak la xesachtajik, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jujun k'u chke ri tijonelab' re ri Pixab' tajin kechomanik, xkib'ij pa kanima': “We achi ri' kub'ij ri äwas u b'ixik chrij ri Dios,” —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ri Jesús retam chik jas ri tajin käkichomaj, xub'ij k'u chke: ¿Jas che k'o we itzel taq chomanik ri' pa anima' alaq? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Jachike ri man k'äx tä u b'ixik: “Ri mak la xesachtajik”, o ru b'ixik: “Walij la, oj la cho ja”? —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Rech b'a' ketamaj alaq chi ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, k'o k'u nu taqanik pa ki wi' ri winaq cho ruwächulew chusachik ri ki mak, ¡tampe alaq ri kinb'ij! —xcha chke. Xub'ij k'u ri Jesús che ri achi ri käminaq u cuerpo: Walij la, oj la cho ja, k'ama b'i la ri sok la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Xwalij k'u b'i ri achi ri käminaq u cuerpo, xe' cho rachoch. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Aretaq xkil ri winaq wa', xkixej kib'. Xkinimarisaj k'u u q'ij ri Dios, rumal chi u yo'm pa ki q'ab' winaq chi taqal u b'anik we kajmab'al ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Xel b'i ri Jesús chila'. Ok'owem kub'an ri Are' jawije' ri kätoj wi ri alkab'al, xril k'u u wäch jun achi, Mateo u b'i', t'uyul chila'. Xub'ij k'u che: Tasa'j wuk', —xcha che. Xwalij k'u ri tat Mateo, xe' ruk' ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Pa jun q'ij k'ut t'uyul ri Jesús chi' ri mesa cho rachoch ri tat Mateo. E k'ia k'u ri toq'il taq alkab'al, xuquje' nik'iaj ajmakib' chik e t'uyul ruk' ri Jesús chi' ri mesa junam kuk' ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Xepe k'u ri tata'ib' fariseos, xkil ronojel wa'. Xkita' k'u chke ru tijoxelab', xkib'ij: ¿Jas che käwi' ri Jesús ri iwajtij kuk' ri toq'il taq alkab'al xuquje' kuk' ri ajmakib'? —xecha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Aretaq xuta ri Jesús wa', xub'ij chke: Ri winaq ri utz ki wäch, ri k'o ki chuq'ab', man rajwaxik tä kunal ke, xane are rajwaxik wa' chke ri yawab'ib', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Oj alaq, jetamaj alaq jas kel kub'ij wa' we tzij ri' ri tz'ib'tal kan pa ru Loq' Pixab' ri Dios ri kub'ij: “Ri in are kwaj chi ri ix kitoq'ob'isaj ki wäch ri winaq. Man are tä kwaj chi keikämisaj taq awaj che ki sipaxik chnuwäch,” —kächa ri Dios, —xcha chke. Ri in, man in petinaq tä che ki sik'ixik winaq ri jikom kanima' cho ri Dios, xane in petinaq che ki sik'ixik ri ajmakib' rech käkik'ex kanima', käkik'ex k'u ki chomanik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ru tijoxelab' ri tat Juan Qasal Ja' xeopan ruk' ri Jesús, xkib'ij che: ¿Jas che ri uj xuquje' ri tata'ib' fariseos amaq'el käqa'n ri ayuno, are k'u ri tijoxelab' la man käka'n tä ri ayuno? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ri Jesús xch'awik, xub'ij chke: ¿A keb'ison lo ri winaq ri e k'o pa jun k'ulanem aretaq ri achi ri te' xk'uli'k k'o kuk'? Kopan k'u na ri q'ij aretaq kesax b'i we achi ri' chkixol. Te k'u ri' käka'n na ri ayuno pa ri q'ij ri', —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Xuquje' xub'ij ri Jesús chke: Man k'o tä jun winaq ri kut'is jun k'ak' k'ojob'al chrij jun q'el atz'iaq. We ta je ri' ri k'ak' k'ojob'al kuk'ol rib', käresaj k'u b'i jub'iq' che ri q'el atz'iaq, känimar k'u ru teq'tob'ik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Man k'o tä jun ri kuya k'ak' vino pa q'el taq q'eb'al re tz'um. We ta je ri', ri vino kut'ub'ij na ri tz'um, ketzeletaj k'u na ri vino xuquje' taq ri tz'um. Rajwaxik k'ut chi ri k'ak' vino käyi' pa taq k'ak' taq q'eb'al re tz'um, rech ri vino xuquje' taq ri tz'um man ketzeletaj taj, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Je wa' tajin kub'ij ri Jesús chke ri winaq aretaq xopan jun tata' ki nimal ri winaq aj Israel. Xxuki chuwäch ri Jesús, xub'ij che: Ri alaj nu mia'l k'ä te' xkäm kanoq. We k'u ri lal ke' la wuk', käya la ri q'ab' la puwi', käk'asi na, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Xe' k'u ri Jesús ruk' ri tata', e rachi'l ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","K'o k'u jun ixoq yawab', ri xke' kab'lajuj junab' xaq kel u kik'el. Xqeb' k'u chrij ri Jesús, xuchap koq ru chi' ru q'u'. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Xub'ij k'u pa ranima': “Xuwi ta ne we kinchap koq ru q'u', kinutzir na,” —xcha ri ixoq. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ri Jesús k'ut xutzolq'omij rib', xril ri ixoq, xub'ij che: Mäb'ison chi la, nan, xkunataj k'u la, rumal chi xkojon la chwe, —xcha che. Tzare chi' k'ut xutzir ri ixoq. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Aretaq ri Jesús xopan cho rachoch ri tata' ri ki nimal ri winaq aj Israel, xrilo chi e k'o chi ri ajq'ojomab' ri keb'e' che ri muqnajik, xuquje' xeril ri winaq chi sib'alaj käkik'is kib' che oq'ej, sib'alaj käkiraq ki chi'. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Xub'ij k'u chke: ¡Chel na apan alaq cho ja! Man käminaq tä ri ali, xane xa käwarik, —xcha chke. Are k'u ri winaq xa xkitze'j u wäch ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ri Jesús k'ut xeresaj b'i ri winaq cho ja, te k'u ri' xok b'ik. Xuchap ri ali che ru q'ab'. Ri ali k'ut xwalijik. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Xel k'u u tzijol wa' ri xb'antajik pa taq konojel ri tinimit chila'. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Aretaq xel b'i ri Jesús chila', kieb' moyab' xeteri b'i chrij, xkiraq ki chi', xkib'ij: ¡Tat, lal ri' ri Ralk'ual kan ri qa mam David, toq'ob'isaj la qa wäch! —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Aretaq ri Jesús xok b'i pa ri ja, ri kieb' moyab' xeqeb' ruk'. Ri Jesús xuta' chke: ¿A käkoj alaq chi kinkowin chub'anik wa'? —xcha chke. Käqakojo, Tat, —xecha ri e are'. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ri Jesús xuchap koq ri ki waq'äch, xub'ij chke: Je' ta b'a' chb'antajik jas ri xkoj alaq chi kinkowin chub'anik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Xutzir k'u ri ki waq'äch. Ri Jesús sib'alaj xeupixb'aj, xub'ij chke: Mätzijoj alaq wa' che jachin jun, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Te k'u ri', aretaq xeb'el b'ik, xkichap u tzijoxik wa' jas ri xub'an ri Jesús kuk' pa konojel taq ri tinimit ri k'o jela'. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Tajin keb'el b'i ri kieb' moyab' ri xekunaxik, aretaq xk'am loq chuwäch ri Jesús jun achi mem ri k'o jun itzel espíritu che. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Aretaq xesax b'i ri itzel espíritu rumal ri Jesús, ri achi ri mem xuchaplej tzijonem. Ri winaq sib'alaj xkikajmaj wa', xkib'ij: Man k'o tä jumul ri je' qilom wa' waral pa Israel, —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Are k'u ri tata'ib' fariseos xkib'ij: We achi ri' keresaj b'i ri itzel taq espíritus chke ri winaq ruk' ru chuq'ab' ri ki nimal ri itzel taq espíritus, —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ri Jesús xeusolij ri nimaq taq tinimit xuquje' ri alaj taq tinimit. Pa taq ri rachoch Dios ri käkimulij wi kib' ri winaq xuya tijonik, xutzijoj ri Utzalaj Tzij re ri Evangelio chrij ru taqanik ri Dios pa ki wi' ri winaq. Xukunaj ronojel u wäch yab'il, xuquje' xresaj ronojel u wäch k'äx chke ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Aretaq xeril ri k'ialaj winaq, xel u k'ux chke rumal chi keb'isonik, man k'o tä käku'b'isan ki k'ux. E je' ta ne chij ri man k'o tä kajyuq'. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Xub'ij k'u chke ru tijoxelab': Qas tzij sib'alaj nim ri q'atoj, xa k'u e kieb' oxib' ri ajchakib'. ");
INSERT INTO qucNNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Chib'ochi'j b'a' ri Ajchaq'el ri q'atoj chi keutaq b'i nik'iaj ajchakib' chik pa ru chak, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ri Jesús xeusik'ij ri kab'lajuj u tijoxelab'. Xuya chke chi käk'oji taqanik pa ki q'ab' che kesaxik b'i ri itzel taq espíritus, xuquje' che ki kunaxik ri winaq che ronojel u wäch yab'il o ronojel u wäch k'äx ri k'o chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Are wa' ri ki b'i' ri kab'lajuj apóstoles: nab'e ri tat Simón ri xuquje' käb'ix Pedro che, ruk' ri tat Andrés ri rachalal. Ri tat Jacobo ruk' ri tat Juan ri rachalal ri e u k'ojol ri tat Zebedeo. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ri tat Felipe, ri tat Bartolomé, ri tat Tomás, xuquje' ri tat Mateo ri toq'il alkab'al. Ri tat Jacobo ru k'ojol ri tat Alfeo. Ri tat Lebeo ri xuquje' käb'ix Tadeo che. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ri tat Simón ri käb'ix u nimal tinimit che, xuquje' ri tat Judas Iscariote ri xjachow ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ri Jesús xeutaq b'i we achijab' ri', xeupixb'aj b'ik, xub'ij chke: Mixe' pa taq ri ki tinimit ri winaq ri man aj Israel taj. Man kixok tä k'ut pa taq ri ki tinimit ri winaq aj Samaria. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Xane are kixe' kuk' ri winaq aj Israel, ri e je' ta ne chij e sachinaq kan pa taq juyub'. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Jix, jib'ij chke chi xa jub'iq' man kuchaplej ru taqanik ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Cheikunaj ri yawab'ib', cheik'astajisaj ri käminaqib', cheikunaj ri k'o itzel taq ch'a'k chkij, cheiwesaj k'u b'i ri itzel taq espíritus chke ri winaq. Ri ix xaq sipam wa' we kuinem ri' chiwe, k'o k'u b'a' mita' che ri ki to'ik ri winaq, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mik'am b'i i rajil. Ri q'än puaq, ri saq puaq, ri kiäq puaq mik'am k'u b'ik. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mik'am b'i ri i chim che ri b'e. Xa jun i kamixa' kik'am b'ik. Mik'am b'i i xajäb'. Mik'am b'i i ch'imiy. Je ri', rumal chi taqal che ri ajchak chi käyi' ri kajwataj che. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Apachike tinimit ri kixopan wi, we nim, we ch'utin, chitzukuj jun winaq chila' ri qas kixk'ulaj. Chixkanaj kan chila' k'ä kichap na b'i jumul chik ri i b'e. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Aretaq kixok pa jun ja, chiya rutzil ki wäch ri e k'o pa ri ja. Kib'ij chke chi are utzil kiwaj chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","We taqal chke ri winaq ri e k'o pa ri ja chi kiya kan rutzil ki wäch ruk' utzil, chiya kanoq. We k'u man taqal chke, miya kan rutzil ki wäch. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Are k'u we man kixk'ulax kumal, we man käkaj taj käkitatab'ej ri i tzij, chixel b'i cho ri ja ri' o pa ri tinimit ri'. Chitota' kan ri ulew ri k'o che taq ri iwaqan. (Chib'ana wa' chuq'alajisaxik chkij ri winaq re ri tinimit ri' chi man utz tä ri käka'no, k'o ki mak.) ");
INSERT INTO qucNNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Qas tzij kinb'ij chiwe chi pa ri q'ij ri käq'at na tzij pa ki wi' ri winaq ri' rumal ri Dios, nim na ri k'äjisab'al ki wäch ri winaq re ri tinimit ri' chuwäch ri k'äjisab'al ki wäch ri winaq aj Sodoma xuquje' ri winaq aj Gomorra, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","¡Chiwilampe'! Ri in kixintaq b'ik je' ta ne chi ix chij chkixol ri utiw. Chixsak'laj b'a' je' jas ri kumätz, chib'ana k'ut je' jas ri kub'an ri palomäx ri man kub'an tä k'äx. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Chiwila b'a' iwib', rumal chi ri winaq kixkijach na pa ki q'ab' ri ki nimaqil ri winaq, kixkich'ay na pa taq ri rachoch Dios ri käkimulij wi kib' ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kixkik'am na b'i chkiwäch q'atal taq tzij, xuquje' chkiwäch nimaq taq taqanelab' rumal wech in, rech kiq'alajisaj ri Utzalaj Tzij re ri Evangelio chkiwäch ri e are' xuquje' chkiwäch ri winaq ri man aj Israel taj. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Aretaq k'ut kixk'am b'ik rech kixjach chkiwäch ri q'atal taq tzij, mixej iwib'. Michomaj b'ik jas ri kib'ij, o jas ri kib'an chub'ixik wa'. K'ol b'a' pa i jolom chi aretaq rajwaxik kixch'awik, ri Dios käyo'w na chiwe ri tzij ri kib'ij. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Man ix tä k'u ri' ri kixtzijon na, xane are ri Loq'alaj Espíritu rech ri qa Tat käyo'w na ri tzij pa ri iwanima', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ri winaq kekijach na ri kachalal pa kämisaxik. Ri nan tat kekijach na ri kalk'ual pa kämisaxik. Ri alk'ualaxelab' käkiyak na kib' chkij ri ki nan ki tat, kekijach na pa kämisaxik. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ketzelax na i wäch kumal konojel ri winaq xa rumal wech in. Apachin k'u ri kuch'ij ri k'äx k'ä käk'is na ronojel kuriq na ru tob'anik ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Aretaq käb'an k'äx chiwe pa jun tinimit, chixanimaj b'i pa jun tinimit chik. Qas tzij kinb'ij chiwe chi mäja' kixkowin chusolixik taq konojel ri tinimit ri e k'o wi ri winaq aj Israel aretaq kinpe in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, —xcha chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ri tijoxel man are tä nim na u b'anik chuwäch ru tijonel. Ri ajchak k'ut man are tä nim na u b'anik chuwäch ri u patrón. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ri tijoxel rajwaxik käku'b'i u k'ux chi käjunamataj na ruk' ru tijonel. Ri ajchak k'ut rajwaxik käku'b'i u k'ux chi käjunamataj na ruk' ru patrón. We ri ajchaq'el ja käb'ix Beelzebú che xa che yoq'b'al re, ¿jas ta k'u lo käb'ix chke ri rachalaxik ri are'? ");
INSERT INTO qucNNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Rumal ri' mixej iwib' chkiwäch ri winaq. Man k'o tä ri ch'uqtalik ri mat kel na chi saq. Man k'o tä k'u ri k'u'talik ri mat ketamax na. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ri kinb'ij chiwe ix pa ri q'equm, chiya u b'ixik pa saqil. Ri kinb'ij chiwe chik'uyal, chiraqa i chi' chub'ixik wa' pa taq ri b'e. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mixej iwib' chkiwäch ri winaq ri kekowinik käkikämisaj ri cuerpo, man kekowin tä k'u chukämisaxik ri ranima' jun. Xane are chixej iwib' chuwäch ri Jun ri käkowinik kusach u wäch ru cuerpo jun winaq xuquje' ri ranima' ri are' pa ri q'aq'. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","¿A mat xa jun centavo kek'iyix wi kieb' alaj taq chikop ajuwokaj? Man k'o tä k'u jun chke we alaj taq chikop ri' ri käkämik we ta mat kraj ri i Tat. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Xuquje' ne ri rismal i wi', konojel wa' e ajilatal rumal ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Mixej b'a' iwib', ri ix sib'alaj ix loq' na chkiwäch k'ia alaj taq chikop ajuwokaj, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Konojel ri käkiq'alajisaj kib' chkiwäch ri winaq chi e kojoninaq chwe, ri in xuquje' kinq'alajisaj na chuwäch ri nu Tat ri k'o chila' chikaj chi e wachi'l in. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Apachin k'u ri kub'ij chkiwäch ri winaq chi man retam tä nu wäch, ri in xuquje' kinb'ij chuwäch ri nu Tat ri k'o chila' chikaj chi man wetam tä u wäch ri are', —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Michomaj chi ri in petinaq chuya'ik utzil chkixol ri winaq cho ruwächulew, xane rumal wech in käk'oji na ch'oj chkixol ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Käb'antaj na ch'oj rumal wech, jun tata' chrij ri u k'ojol, ru k'ojol k'ut chrij ru tat, jun chichu' chrij ri ral ali, ri ali k'ut chrij ru nan, xuquje' ne ri jun ali chik chrij ru nan ralib', ru nan ralib' k'ut chrij ri are'. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Je ri' chi ri ki k'ulel ri winaq chkijujunal, e are' ri kachalaxik ri e are', —kächa ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Apachin ri loq' na käril ru nan u tat chnuwäch in, man taqal tä ri' chi kok che nu tijoxel. Apachin ri loq' na käril ru k'ojol o ru mia'l chnuwäch in, man taqal tä ri' chi kok che nu tijoxel. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Apachin ri man käpe tä wuk' in rumal chi man kraj taj kuriq ri kämikal jas ri kinriq in, man taqal tä ri' chi kok che nu tijoxel. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Jachin ri kraj kuto' u wi' ru k'aslemal waral cho ruwächulew, käkäm na ri'. Jachin k'u ri kuya ru k'aslemal rumal wech in, kuto' na u wi' ri' ru k'aslemal. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ri winaq ri utz i k'ulaxik kub'ano, in ri' kinuk'ulaj. Jachin ri kinuk'ulaj in, are kuk'ulaj ri' ri Jun ri xintaqow loq. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Jachin ri kuk'ulaj jun q'alajisal re ru Loq' Pixab' ri Dios ri taqom loq rumal ri Dios, kuk'am na ri tojb'al re jas ri käyi' che jun q'alajisal re ru Loq' Pixab' ri Dios. Jachin ri kuk'ulaj jun utzalaj achi, kuk'am na ri tojb'al re jas ri käyi' che jun utzalaj achi rumal ri utzil ri kub'ano. ");
INSERT INTO qucNNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Apachin ri kuya jun vaso joron che jun chke we winaq ri' ri man nim tä ki b'anik xa rumal chi are nu tijoxel wa', qas kuriq na ri tojb'al re, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Aretaq ri Jesús xto'taj che ki pixb'exik ri kab'lajuj u tijoxelab', xel b'i chila' rech kuya tijonik chke nik'iaj winaq pa taq ri tinimit jela', xuquje' rech kutzijoj ri Utzalaj Tzij re ri Evangelio chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Are k'u ri tat Juan Qasal Ja' k'o pa che'. Xretamaj k'ut jas ri tajin kub'an ri Cristo. Ri are' xeutaq b'i kieb' chke ru tijoxelab' ruk' ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Je' xub'ano rech käkita' che: ¿A lal ri' ri Cristo ri käpe na? o ¿A rajwaxik ne käqeyej chi na jun chik? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Xch'aw k'u ri Jesús, xub'ij chke: Oj alaq, b'ij alaq che ri tat Juan jas ri tajin kil alaq, xuquje' ri tajin käta alaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","B'ij alaq che chi ri moyab' keka'y chik, ri ch'okojib' keb'in chik, ri k'o itzel ch'a'k chkij tajin keutzir che ri ki yab'. B'ij alaq che chi ri so'rab' käkita chik, ri käminaqib' tajin kek'astajik, xuquje' chi ri meb'a'ib' tajin kätzijox ri Utzalaj Tzij re ri Evangelio chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Utz re ri winaq ri man kub'an tä kieb' u k'ux chwij, —xcha chke ru tijoxelab' ri tat Juan. ");
INSERT INTO qucNNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Aretaq xeb'e' ru tijoxelab' ri tat Juan, ri Jesús xuchaplej u tzijoxik ri tat Juan chke ri winaq, xub'ij chke: ¿Jas xe' alaq che rilik pa ri juyub' ri kätz'inowik? ¿A xe' alaq che rilik jun aj ri tajin käslab'isax rumal ri kiäqiq'? ");
INSERT INTO qucNNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","We man are tä ri', ¿jas ri xil alaq? ¿A xil alaq jun achi ri je'l ri ratz'iaq u kojom? Etam alaq chi ri k'o je'lalaj taq katz'iaq, e k'o ri e are' pa taq kachoch ri nimaq taq taqanelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Jas k'u ri xe' alaq che rilik? ¿A xil alaq jun q'alajisal re ru Loq' Pixab' ri Dios? Je', je ri', —xcha'. Tzare k'u ri tat Juan nim na u b'anik chuwäch apachike q'alajisal re ru Loq' Pixab' ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ri tat Juan are wa' ri tz'ib'am kan chrij pa ru Loq' Pixab' ri Dios ri Tz'ib'talik ri kub'ij: Kintaq na b'i ri nu taqo'n, känab'ej k'u na chawäch ri kub'an na u b'anik ra b'e, —kächa ri', —xcha ri Jesús chke ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Qas tzij ri kinb'ij chiwe chi chkixol konojel ri winaq ri e k'olinaq k'ä we kämik ri', man k'o tä jun ri nim na u q'ij chuwäch ri tat Juan Qasal Ja'. Pune je ri', ri jun ri man qas nim tä u b'anik ri kätaqan ri Dios pa ranima', are nim na u q'ij wa' chuwäch ri tat Juan Qasal Ja', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tzpa taq ri q'ij ri xpe ri tat Juan Qasal Ja' k'ä kämik, ri winaq xkichaplej loq u tijik ki chuq'ab' rech keb'ok pa ru taqanik ri Dios. Ri käkikoj ki chuq'ab' käkichomaj chi e are' kech'akan na. ");
INSERT INTO qucNNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ri Pixab' ri xutz'ib'aj ri qa mam Moisés kub'ij chi käpe na ri Dios rech kätaqan pa ki wi' ri winaq, xuquje' je' xkib'ij konojel ri q'alajisal taq re ru Loq' Pixab' ri Dios k'ä xpe na ri tat Juan. ");
INSERT INTO qucNNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","We k'u ri ix qas kiwaj kikoj wa', ri tat Juan are ri q'alajisal re ru Loq' Pixab' ri Dios ri käpe na jas ri xpe ri qa mam Elías ojer. ");
INSERT INTO qucNNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Jachin taq ri käkijikib'a kanima' chutatab'exik ri nu tzij, chkitatab'ej b'a', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Jas ruk' keinjunamaj wi ri winaq re we q'ij junab' ri'? Ri winaq kämik kejunamataj kuk' ri ak'alab' ri keetz'en pa taq ri k'ayib'al, käkiraq ki chi' che ki ch'ab'exik ri kachi'l, käkib'ij: ");
INSERT INTO qucNNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Xqoq'esaj ri su' chiwe, man xixxojow tä k'ut. Xqa'n u q'ojom käminaq, man xixoq' tä k'ut,” —kecha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Xpe k'u ri tat Juan ri man wi'j taj, ri man kutij tä vino. Ri winaq k'ut käkib'ij chi xa k'o jun itzel espíritu che. ");
INSERT INTO qucNNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Aretaq k'ut xinpe in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, ri kinwi'k, ri kintij vino, konojel k'ut käkib'ij chi xa in jiq'alaj achi, in q'ab'arel, in kachi'l ajmakib' xuquje' toq'il taq alkab'al. Ri winaq ri utz ru chak q'alaj wa' chi k'o ri u no'j ri Dios ruk', —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ri Jesús k'ut xuchap ki yajik ri winaq pa taq ri tinimit jawije' u b'anom wi k'ia taq kajmab'al. Je ri', rumal chi ri winaq ri e k'o chila' man ki k'exom tä kanima', man ki k'exom tä k'u ri ki chomanik. Xub'ij k'u chke: ");
INSERT INTO qucNNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","¡K'äx iwe, winaq re ri tinimit Corazín! ¡K'äx iwe, winaq re ri tinimit Betsaida! We ta xeb'an wa' we kajmab'al ri' pa taq ri tinimit Tiro, ri tinimit Sidón jas ri xeb'antaj iwuk' ix, k'extajinaq ta chi ri' ri kanima', ri ki chomanik ri winaq jela'. Xkikoj ta katz'iaq ri' ri kuq'alajisaj chi keb'isonik. Xuquje' k'o ta b'anom wi chi kuq'alajisaj chi are rumal ri ki mak chi keb'isonik, —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kinb'ij k'u chiwe ix chi pa ri q'ij ri kuq'at na tzij ri Dios, nim na ri k'äjisab'al i wäch kiriq na chuwäch ri k'äjisab'al ki wäch ri käkiriq na ri winaq aj Tiro, aj Sidón. ");
INSERT INTO qucNNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Are k'u ri ix winaq aj Capernaum, ri sib'alaj kinimarisaj iwib', k'ä pa ri q'aq' k'ut kixqasax wi na. We ta kuk' ri winaq aj Sodoma xeb'an wi taq ri kajmab'al ri xeb'antaj iwuk' ix, k'o ta na ri' ri ki tinimit kämik. ");
INSERT INTO qucNNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kinb'ij k'u chiwe chi pa ri q'ij aretaq kuq'at na tzij ri Dios, nim na ri k'äjisab'al i wäch ix kiriq na chuwäch ri käkiriq ri winaq aj Sodoma, —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Pa ri q'ij ri' xub'ij ri Jesús: Kinnimarisaj q'ij la, Tat, Rajaw ri kajulew. Je ri', rumal chi xk'u' la ri etamb'al la chkiwäch ri winaq ri k'o ki no'j, ri k'o ketamb'al, are k'utum k'u la wa' chkiwäch ri man k'o tä ketamb'al, ri je' ta ne chi e ak'alab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Je', Tat, rumal chi je ri' ri utzalaj rayib'al la chke ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ri nu Tat u jachom pa nu q'ab' ronojel ri k'olik. Man k'o tä jun ri qas retam u wäch ru K'ojol ri Dios, xane xaq xuwi ri qa Tat. Xuquje' man k'o tä jun ri qas retam u wäch ri qa Tat, xane xaq xuwi ri in, in ri' ri u K'ojol, xuquje' jachin k'u taq chke ri kwaj kinb'ij wi jas ru b'anik ri qa Tat Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Chixsa'j wuk' in, iwonojel ri ix kosinaq, iwonojel ri k'o iweqa'n, kinya k'u uxlanem chiwe. ");
INSERT INTO qucNNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Chik'ama ri eqb'al yunt ri kinya chiwij. Chiwetamaj iwe wuk' in rumal chi ri in k'o nu paciencia, man kinnimarisaj tä wib'. Kuxlan k'u na ri iwanima'. ");
INSERT INTO qucNNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ri eqb'al yunt ri kinya chiwij man k'äx tä ruk'axik. Ri eqa'n k'ut ri kinya chiwij, man al tä ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Pa jun q'ij re uxlanem ri Jesús tajin kok'ow xol taq ri triko. Are k'u ru tijoxelab' xpe ki numik, xkichap k'u u ch'upik ru jolom taq ri triko. Xkib'aq pa ki q'ab', te k'u ri' xkitijo. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Aretaq ri tata'ib' fariseos xkilo, xkib'ij che ri Jesús: Chilampe la, ri tijoxelab' la tajin käka'n chak ri äwas u b'anik pa taq ri q'ij re uxlanem. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ri Jesús xub'ij chke: ¿A mat k'o jumul ri sik'im alaq jas ri xub'an ri qa mam David ojer aretaq ri are' xuna' numik, xuquje' jas ri xka'n ri e k'o ruk'? ");
INSERT INTO qucNNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Xok k'u b'i ri qa mam David pa ri nimalaj rachoch Dios, xutij k'u re ri wa ri yo'm cho ri Dios, xuya k'u ke ri e k'o ruk' xuquje'. Äwas k'u u tijik wa' kumal xaq jachinoq, xane xaq xuwi chke ri sacerdotes ya'tal wi wa', —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Xuquje' xub'ij: ¿A mat k'o jumul ri sik'im alaq pa ri Pixab' ri xutz'ib'aj ri qa mam Moisés, chi ri sacerdotes ri kepatänin pa ri rachoch Dios man keuxlan tä pa ri q'ij re uxlanem? Pune ta ne je ri' man mak tä k'u ri' chi je' käka'n wa'. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kinb'ij k'u chech alaq, chi waral k'o Jun ri nim na u b'anik chuwäch ri nimalaj rachoch Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ri alaq xa man käch'ob' tä alaq jas kel kub'ij wa' we tzij ri' ri tz'ib'tal kan pa ru Loq' Pixab' ri Dios ri kub'ij: “Ri in kwaj chi ri ix kib'an toq'ob' chke ri winaq, man are tä kwaj chi keikämisaj awaj che ki sipaxik chnuwäch,” —kächa ri'. We ta qas käch'ob' alaq wa', mat käq'at alaq tzij chi käk'äjisax ki wäch ri winaq ri man k'o tä ki mak. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Are k'u ri' ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, k'o nu taqanik puwi' ri q'ij re uxlanem xuquje', —xcha ri Jesús chke ri tata'ib' fariseos. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Xel k'u b'i ri Jesús chila', xok b'i pa jun chke ri rachoch Dios ri käkimulij wi kib' ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","K'o k'u jun achi chila' ri käminaq jun u q'ab'. Are k'u ri tata'ib' fariseos käkaj käkitzukuj u mak ri Jesús, rumal ri' xkita' che: ¿A ya'talik käkunax jun yawab' pa ri q'ij re uxlanem? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Xch'aw ri Jesús, xub'ij chke: We jun chiwe k'o jun u chij, kätzaq k'u b'i pa jun k'ua' pa jun q'ij re uxlanem, ¿a mat ke' ri' che resaxik? ");
INSERT INTO qucNNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","E ta k'u lo jun winaq, are ri Dios nim na u b'anik käril wi wa' chuwäch jun chij. Rumal ri' ya'tal u b'anik toq'ob' pa taq ri q'ij re uxlanem, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Xub'ij k'u ri Jesús che ri achi: Yuqu ri q'ab' la, —xcha che. Xuyuq ru q'ab', xutzir k'ut. Je' chik ri u q'ab' ri' jas ri jun chik. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Xeb'el k'u b'i ri tata'ib' fariseos, xkitala ki no'j chb'il taq kib' jas ri käka'n chukämisaxik ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Aretaq ri Jesús xuch'ob' ri ki chomanik ri tata'ib' fariseos, xel b'i chila'. E k'ia k'u ri winaq xeteri b'i chrij. Ri Jesús k'ut xeukunaj konojel taq ri yawab'ib'. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Xeutaq k'u ri winaq, xub'ij chke chi k'o jachin che mäkib'ij wi jachin ri Are'. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Xub'ij ri Jesús wa' rech je' kel wi jas ri xub'ij loq ri qa mam Isaías ri q'alajisal re ru Loq' Pixab' ri Dios ri xub'ij: ");
INSERT INTO qucNNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Are wa' ri patänil we ri cha'tal wumal, ri sib'alaj loq' chnuwäch, ri käkikot ri wanima' rumal. Kinya na ri Loq'alaj nu Espíritu pa ranima' ri Are'. Kub'ij k'u na chke konojel ki wäch winaq chi ri in kinq'at na tzij pa ki wi'. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Man käch'ojin taj, man kuraq tä u chi', man k'o ta jun käto'w ri Are' ko käch'aw pa taq ri b'e. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","We k'o jun winaq ri je' jas jun aj ri kotakik, man kuq'up taj. We ne k'o jun winaq ri junam jas jun candela ri man nim tä ru q'aq'al, man kuchup tä ri'. Xane kächakun na che rilik chi kopan na ri q'ij aretaq qas käq'at na tzij ruk' jikomal. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Konojel k'u ki wäch winaq cho ruwächulew, käku'b'i na ki k'ux chrij ri Are', —xcha ri Dios chuchi' ri q'alajisal re ru Loq' Pixab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Xk'am k'u b'i jun achi ruk' ri Jesús. Ri achi mem xuquje' moy, k'o k'u jun itzel espíritu ruk'. Xkunax k'u rumal ri Jesús, je ri' chi ri achi xkowinik xka'yik xuquje' xch'awik. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Konojel ri winaq xkikajmaj wa', xkib'ij: ¿A mat are wa' ri Ralk'ual kan ri qa mam David ri käb'ixik chi käpe na? —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Aretaq k'ut xkita ri tata'ib' fariseos ri käkib'ij ri winaq, ri e are' xkib'ij: We achi ri' käkowinik keresaj b'i ri itzel taq espíritus chke ri winaq xa rumal ru chuq'ab' ri Beelzebú ri ki nimal ri itzel taq espíritus ri k'o ruk', —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ri Jesús xuch'ob'o jas ri tajin käkichomaj, xub'ij k'u chke: Apachike q'atb'al tzij ri u b'anom kieb', ri juch'ob' q'atal taq tzij käkiyak kib' chkij ri juch'ob' chik, ri q'atb'al tzij ri' käk'is na u wäch. We jun tinimit o jun ja winaq u b'anom kieb' rumal chi k'o ch'oj chkixol, man naj tä ri' kuch'ijo. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Je ri' xuquje', we ta ri Satanás käresaj b'i ri Satanás, u b'anom kieb' ri'. We ta je ri', ¿a naj ta k'u ri' kuch'ij ru taqanik? ¡Man je' taj! ");
INSERT INTO qucNNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ri alaq käb'ij alaq chi ri in kinwesaj b'i ri itzel taq espíritus ruk' ru chuq'ab' ri Beelzebú. We ta je ri', ¿jachin käyo'w ki chuq'ab' ri tijoxelab' alaq che kesaxik b'i ri itzel taq espíritus? Qas are ri e are' käkiq'alajisaj chi xa sachinaq alaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ri in k'ut kinwesaj b'i ri itzel taq espíritus ruk' ru chuq'ab' ri Espíritu rech ri Dios ri k'o wuk'. Kel kub'ij wa' chi ri Dios k'o chi uk' alaq rech kätaqan puwi' alaq, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Man k'o tä jun käkowinik kok pa rachoch jun achi ri sib'alaj k'o u chuq'ab', kärelaq'aj k'u b'i ri jastaq re, we ta mat nab'e kuyut na ri achi ri k'o u chuq'ab'. Te k'u ri' käkowinik kärelaq'aj b'i ri jastaq re. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ri jun ri man junam tä u chomanik wuk', kinuk'ulelaj ri'. Ri jun ri man kächakun tä wuk', xaq kutur ri' ri nu chak, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Rumal ri' kinb'ij chech alaq: Ronojel mak ri käka'n ri winaq kuya' käsachtaj na ki mak ri' rumal ri Dios, xuquje' ronojel ri äwas u b'ixik chrij ri Dios ri käkib'ij ri winaq kuya' käsachtaj na ki mak ri'. Are k'u we käkib'ij ri äwas u b'ixik chrij ri Loq'alaj Espíritu man kuya' taj käsachtaj ri ki mak ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Apachin ri kub'ij tzij ri äwas u b'ixik chwij in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, käsachtaj na u mak ri' che. Apachin k'u ri kub'ij ri äwas u b'ixik chrij ri Loq'alaj Espíritu, man käsachtaj tä na u mak ri' che waral cho we uwächulew. Man käsach tä k'u u mak ri' pa ri jun k'aslemal chik ri käpe na, —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","We utz ri che', utz ru wäch ri kuya. We man utz tä ri che', man utz tä ru wäch ri' ri kuya. Ri jun che' rumal ru wäch käch'ob'tajik jas u b'anik. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Ri alaq, alaq sub'anelab' taq winaq! ¿A käkowin lo alaq ri' chub'ixik utzalaj taq tzij, alaq itzel taq winaq k'ut? Ri kel loq pu chi' ri winaq, are wa' ri qas k'o pa ranima'. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ri utzalaj winaq, utz ri' ri kub'ij rumal rech ri utzil ri k'o pa ranima'. Ri itzel winaq, man utz tä ri' ri kub'ij rumal chi etzelal wa' ri k'o pa ranima'. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Kinb'ij k'u chech alaq, chi pa ri q'ij aretaq kuq'at na tzij ri Dios, konojel ri winaq käkijach na kuenta rumal ronojel tzij ri ki b'im ri man k'o tä u patän. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Jas k'u je' ri kätzijon ri winaq, are je ri' ri q'atow tzij ri käb'an na puwi'. Käq'alajisax k'u na we k'o u mak o man k'o taj. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Jujun tata'ib' fariseos kachi'l jujun tijonelab' re ri Pixab', xkib'ij che ri Jesús: Ajtij, käqaj chi käb'an la jun kajmab'al etal chqawäch rech käqilo, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ri Jesús xch'awik, xub'ij chke: Ri lawalo taq winaq, ri man jikom tä kanima', käkaj chi kinb'an jun kajmab'al etal chkiwäch. Man käyi' tä k'u wa' chke, xane xaq xuwi ri etal chrij ri Jonás ri q'alajisal re ru Loq' Pixab' ri Dios ojer. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Je' jas ri Jonás xk'oji chupam ri jun nimalaj kär oxib' q'ij, oxib' aq'ab', are k'u je' kinb'an na in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, kink'oji k'u na xe' ri ulew oxib' q'ij, oxib' aq'ab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ri winaq aj Nínive, pa ri q'ij re ri q'atow tzij aretaq käq'at tzij pa ki wi' ri winaq ri e k'o kämik, käkiq'at na tzij pa ki wi' chi käk'äjisax ki wäch. Je ri', rumal chi ri winaq aj Nínive, xkik'ex ri kanima', xkik'ex k'u ri ki chomanik aretaq ri Jonás xutzijoj ru Loq' Pixab' ri Dios chke. Waral k'ut k'o Jun ri nim na u b'anik chuwäch ri Jonás. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Xuquje' ri nimalaj taqanel ixoq ri xk'oji chumox ri relb'al q'ij, käk'oji na pa ri q'ij re ri q'atow tzij. Aretaq käq'at tzij pa ki wi' ri winaq ri e k'o kämik, ri are' kuq'at na tzij pa ki wi' chi käk'äjisax ki wäch. Je ri', rumal chi ri ixoq ri' naj xel wi loq, xpe k'u chutatab'exik ri nimalaj retamb'al ri Salomón. Waral k'ut k'o wi Jun ri nim na u b'anik chuwäch ri Salomón. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Aretaq jun itzelalaj espíritu kel b'i che jun winaq, xaq käwakatalob' chik pa taq juyub' ri kätz'inowik, kutzukuj jawije' kuxlan wi. Aretaq man kuriq taj jawije' kuxlan wi, kub'ij: ");
INSERT INTO qucNNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Kintzelej na b'i cho ri wachoch jawije' ri xinel wi loq,” —kächa'. Aretaq kopanik, kuriqa ri ranima' ri winaq je' u b'anik jun ja tolonik, mesom chi u pam, utz k'u b'anom che. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ke' k'ut, keuk'ama chi na wuqub' itzelalaj taq espíritus ri sib'alaj e lawalo na chuwäch ri are'. Konojel wa' keb'ok pa ranima' ri winaq. Ri winaq ri' nim na ri k'äx kuriq na chuwäch ri k'äx ri xuriq nab'e. Je k'u wa' ri käkik'ulmaj na ri lawalo taq winaq kämik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ri Jesús tajin kätzijon na kuk' ri winaq aretaq xopan ru nan, e rachi'l ri rachalal. Xaq k'u chrij ri ja e tak'atoj wi, käkaj k'ut ketzijon ruk' ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","K'o k'u jun ri xub'ij che ri Jesús: Ri nan la, xuquje' ri chaq' la e k'o chrij ri ja, käch'ab'ex la kumal, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Xub'ij k'u ri Jesús che ri xb'in che: ¿Jachin ri' ri nu nan, xuquje' jachin taq ri qas e wachalal? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Xeuk'ut ru tijoxelab' chkiwäch ri winaq, te k'u ri' xub'ij: E are wa' je' ta ne ri nu nan, xuquje' ri nu chaq', —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Je ri', rumal chi apachin ta ne ri käb'anow ru rayib'al ri nu Tat ri k'o chila' chikaj, are wa' ri qas wachalal, ri nu chaq', ri wanab', ri nu nan, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Pa ri q'ij ri' ri Jesús xel loq cho ja, xe' k'u chuchi' ri mar, xt'uyi k'u chila'. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Xkimulij k'u kib' k'ia winaq ruk', je ri' chi xok b'i ri Are' pa jun barco, xt'uyi k'u chupam. Konojel ri winaq xekanaj kan cho ri ulew chuchi' ri mar. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Xeukoj k'u taq k'utb'al che ki tijoxik ri winaq chkij k'ia u wäch taq no'j, xub'ij chke: Xel b'i jun tikol ija' cho rachoch, xe' chub'anik u tiko'n, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Aretaq tajin kujopij ri ija', xqaj jub'iq' ri ija' pa ri b'e. Xeopan k'u ri chikop ajuwokaj. Kerapapik xeqajik, xa xkitij b'i ri ija'. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Xqaj chi jub'iq' xol taq ri ab'aj, ri man k'o tä wi k'ia ulew. Chanim k'ut xk'iy ri jub'iq' ija' ri' rumal chi man pim tä ri ulew. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Aretaq k'ut xel loq ri q'ij, xek'at ri alaj taq tiko'n rumal, xechaqi'jik rumal chi man qas tä k'u k'o ki xera'. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Xqaj chi k'u jub'iq' ri ija' pa taq ri q'ayes ri k'o ki k'ixol. Xek'iy k'u ri q'ayes, xekijiq'isaj ri tiko'n. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Are k'u ri nik'iaj ija' chik xeqaj pa utzalaj ulew. Sib'alaj xewächinik. E k'o jujun tiko'n xkiya jujun ciento ki wäch pa taq ri ki jolom ri triko chkijujunal, e k'o k'u jule' chik xkiya oxk'al ki wäch pa taq ri jujun ki jolom. Ri nik'iaj tiko'n chik xkiya juwinaq lajuj ki wäch chkijujunal, —xcha ri Jesús chke ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","We ri ix kijikib'a ri iwanima' chutatab'exik ri nu tzij, ¡chitatab'ej b'a'! —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ru tijoxelab' ri Jesús xeqeb' ruk', xkita' che: ¿Jas che kuk' taq k'utb'al ketzijob'ej la ri winaq? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ri Jesús xch'awik, xub'ij chke: Ri ix yo'm chiwe rumal ri Dios ri retamaxik ri man ketam tä ri nik'iaj winaq chik chrij ru taqanik ri Dios pa ki wi' ri winaq. Man ya'tal tä k'u chke ri e are' chi käkich'ob' wa'. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ri winaq ri k'o k'o ruk', käyi' chi na nik'iaj che rech känimar ri k'o ruk'. Are k'u ri winaq ri man k'o tä k'o ruk', ri jub'iq' ri k'o ruk' kesax na che. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Rumal ri' keintzijob'ej ri winaq kuk' taq k'utb'al, rumal chi pune jaqal ri ki waq'äch, man kekowin tä chuch'ob'ik ri käkilo, je' ta ne chi man keka'y taj. Pune käkitatab'ej ri qas tzij, man käkich'ob' tä ri' ri ki tatab'em. Je' ta ne chi man käkita tä ri kinb'ij. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Are k'u je' käb'antaj na wa' kuk' ri e are' jas ri xub'ij ri qa mam Isaías ri q'alajisal re ru Loq' Pixab' ri Dios: Ri ix, pune kitatab'ej ri qas tzij, man kich'ob' taj. Pune kixka'yik, man kich'ob' tä ri kiwilo. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Je ri', rumal chi ab'ajarinaq ri kanima' we winaq ri'. Man utz tä ketow tzij. Ki tz'apim k'u ri ki waq'äch rech man keka'y taj. Je' u b'anom ri kanima' rech man käkita taj, rech man käqaj tä ri nu tzij pa kanima', rech man kinkitzukuj taj rech keinkunaj, —xcha ri Dios chuchi' ri q'alajisal re ru Loq' Pixab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Are k'u ri iwe ix, sib'alaj utz iwe, rumal chi tajin kiwil ri tajin kinb'ano, tajin kita ri tajin kinb'ij. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Qas tzij kinb'ij chiwe chi e k'ia q'alajisal taq re ru Loq' Pixab' ri Dios, xuquje' e k'ia utzalaj taq winaq xkaj xkilo jas ri tajin kiwil ix kämik, man xkil tä k'ut. Xkaj xkita jas ri tajin kita ix kämik, man xkita tä k'ut, —xcha ri Jesús chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Chitatab'ej b'a' jas kel kub'ij ri k'utb'al chrij ri tikol ija', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ri ija' ri xeqaj pa ri b'e, e are wa' jas ri winaq ri käkitatab'ej ru Loq' Pixab' ri Dios chrij ru taqanik ri Dios pa ki wi' ri winaq, man käkich'ob' tä k'ut. Chanim käpe ri Itzel, käresaj k'u b'i ri tzij ri xqaj pa kanima'. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ri ija' ri xeqaj xol taq ri ab'aj, e are wa' jas ri winaq ri käkita ru Tzij ri Dios ruk' kikotemal, je'l käkito. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Rumal k'ut chi man qas tä k'o ri ki xera', xa kieb' oxib' q'ij käkich'ijo. Aretaq k'ut käkichaplej u riqik k'äx, kraj keyoq'ik rumal rech ru Tzij ri Dios, chanim ketzaq kanoq. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ri ija' ri xeqaj pa taq ri q'ayes ri k'o ki k'ixol, e are wa' jas ri winaq ri käkita ru Tzij ri Dios, are k'u käkilij na ri jastaq rech we uwächulew ri', kesub'taj rumal ri q'inomal. Are k'u wa' käjiq'isan ru Tzij ri Dios, man käwächin tä k'u ri' pa ri kanima'. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Are k'u ri ija' ri xeqaj pa utzalaj ulew, e are wa' jas ri winaq ri käkita ru Tzij ri Dios, käkich'ob'o. Käkiya k'u k'ia ki wäch. E je' jas ri ija' ri xkiya jujun ciento ki wäch chkijujunal, nik'iaj chik e je' jas ri ija' ri xkiya oxk'al ki wäch chkijujunal, jujun chik e je' jas ri ija' ri xkiya juwinaq lajuj ki wäch chkijujunal, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ri Jesús xukoj jun k'utb'al chik chkiwäch: Ru taqanik ri Dios pa ki wi' ri winaq, are junam ruk' jun achi ri xutik utzalaj ija' pa ri rulew. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Xpe k'u jun u k'ulel ri ajchaq'el ri tiko'n. Aretaq konojel tajin kewarik, xok b'i pa ri ulew, xutika k'u kan itzel taq q'ayes xol taq ri triko. Te k'u ri' xe'k. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Aretaq xk'iy ri triko, xechomaqir ru jolom, xuquje' xek'iy ri itzel taq q'ayes. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Xeb'e' k'u ri ajchakib', xekib'ij che ri ki patrón: “Tat, we qas utz ri ija' ri xtik la, ¿jawije' k'ut xpe wi wa' we itzel q'ayes ri'?” —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Xub'ij k'u ri patrón chke: “Xa k'o jun nu k'ulel xb'anow wa',” —xcha chke. Ri ajchakib' xkib'ij che ri ki patrón: “¿A kaj la chi keqab'oq ri itzel taq q'ayes?” —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ri patrón xub'ij chke: “Man utz tä ri' we je' kib'ano, rumal chi we ne kib'oq b'i ri triko junam ruk' ri itzel q'ayes. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Chek'iy na ri itzel taq q'ayes junam ruk' ri triko, chiweyej na k'ä kuriq ri q'atoj. Keintaq k'u na b'i ri ajchakib' rech nab'e käkimol ri itzel taq q'ayes, käkixim pa taq yataj, te k'u ri' käkiporoj. Are k'u ri triko käkik'ol na pa ri nu k'uja,” —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ri Jesús xukoj chi jun k'utb'al chkiwäch, xub'ij: Ru taqanik ri Dios pa ki wi' ri winaq, junam wa' ruk' ri ija' re ri tiko'n ri käb'ix “mostaza” che, ri kutik jun achi pa ri rulew. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Qas tzij ri ija' ri' are ri sib'alaj nitz' na chkiwäch konojel taq u wäch ija'. Aretaq k'ut käk'iyik, are nim na ke' chkiwäch konojel taq ri tiko'n. Kub'an jun nimalaj che', je ri' chi ri chikop ajuwokaj käka'n ri ki sok xol taq ru q'ab', kemu'jan chupam, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ri Jesús xukoj chi jun k'utb'al chkiwäch, xub'ij: Ru taqanik ri Dios pa ki wi' ri winaq, are je' jas ri ch'äm ri kuya jun ixoq ruk' oxib' pajb'al k'äj, rech kuk'iyisaj ronojel ri q'or re kaxlan wa, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ronojel wa' we tzij ri' xub'ij ri Jesús chke ri winaq kuk' taq k'utb'al. Xaq xuwi kuk' taq k'utb'al xeutzijob'ej ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Je' xb'antaj wa' rech qas je' kel wi jas ri xub'ij ri q'alajisal re ru Loq' Pixab' ri Dios ri Tz'ib'tal kanoq: Kintzijon na kuk' taq k'utb'al, kinb'ij na ri man etamtal taj tzaretaq ri Dios xub'an ri kajulew, —xcha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Xtäni k'u ri Jesús che ru tzij, xeutaq b'i ri winaq cho taq ri kachoch, ri Are' k'ut xok pa ja. Are k'u ri tijoxelab' xkiriq kib' ruk', xkib'ij che: B'ij la chqe jas kel kub'ij ri k'utb'al chrij ri itzel q'ayes ri xtik kan pa ri ulew, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ri Jesús xub'ij chke: Ri kätikow ri utzalaj ija', in ri' ri Ralk'ual ri Dios ri Qas Winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ri ulew are ronojel ruwächulew. Ri utzalaj ija' e are wa' ri winaq ri kätaqan ri Dios pa ki wi'. Ri itzel q'ayes e are wa' ri winaq ri e rech ri itzel. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ri k'ulel ri xtikow ri itzel q'ayes, are ri Itzel wa'. Ri q'atoj kel kub'ij ri k'isb'al re ruwächulew aretaq käk'is ronojel. Ri keb'anow ri q'atoj e are' ri ángeles. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Je' jas ri käb'an che ri itzel q'ayes, kämolik, käk'iäq pa ri q'aq', are k'u je' käb'an na pa ri k'isb'al re ruwächulew. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, keintaq na loq ri nu ángeles che ki molik konojel ri winaq ri kekitaqchi'j nik'iaj winaq chik che mak, xuquje' ri b'anal taq etzelal. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Kekik'iäq k'u na b'i pa ri nimalaj q'aq', jawije' keb'oq' wi na, käkiquch'uch'ej na ri ki ware. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Are k'u ri käka'n ri kraj ri Dios, keopan na jawije' ri kätaqan wi ri qa Tat chila' chikaj. Kejuluw na je' jas ri q'ij. We kijikib'a ri iwanima' chutatab'exik ri kinb'ij, ¡chitatab'ej b'a'! —xcha ri Jesús chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ru taqanik ri Dios pa ki wi' ri winaq, kinjunamaj ruk' jun koxon puaq ri muqtalik. Käriqtaj k'u ri puaq rumal jun achi. Ri are' kumuq chi k'u kan jumul chik chila'. Rumal ru kikotemal ke'k, kuk'iyij ronojel ri jastaq re, kuloq' ri ulew, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Xuquje' kinjunamaj ru taqanik ri Dios ruk' jun ajk'ay ri kutzukuj je'lalaj taq ab'aj ri kejuluwik. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Aretaq kuriq jun ri sib'alaj paqal rajil, ke'k, kuk'iyij ronojel ri jastaq re, kuloq' ri perla ri xuriqo, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Xuquje' kinjunamaj ru taqanik ri Dios pa ki wi' ri winaq ruk' jun k'at chapäb'al kär ri käk'iäq b'i pa ri ja', keb'ok k'u ronojel ki wäch kär chupam. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Aretaq nojinaq chi ri k'at, kesax loq kumal ri chapal taq kär, käkiya chuchi' ri ja', te k'u ri' ket'uyi che ki cha'ik ri kär. Ri utzalaj taq kär kekiya pa taq chikäch, are k'u ri man e utz taj, kekik'iäq kan pa ri ja', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Are je wa' käb'antaj na aretaq käk'is ruwächulew. Kepe ri ángeles che ki cha'ik ri utzalaj taq winaq chkixol ri man e utz taj. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ri man e utz taj kekik'iäq na pa ri nimalaj q'aq'. Chila' keb'oq' wi na, käkiquch'uch'ej na ri ki ware, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ri Jesús xuta' chke ri winaq, xub'ij: ¿A kich'ob' ronojel ri xinb'ij? —xcha chke. Käqach'ob'o, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Xub'ij k'u ri Jesús chke: Aretaq jun tijonel re ri Pixab' kraj käretamaj ronojel chrij ru taqanik ri Dios pa ki wi' ri winaq, je' u b'anik ri' jas jun ajchaq'el ja ri k'o k'ia jastaq re. Aretaq rajwaxik ri q'el che, käresaj loq, kukojo. Aretaq rajwaxik ri k'ak' che, käresaj loq, kukojo, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Aretaq xto'taj ri Jesús che ki tijoxik ri winaq kuk' taq we k'utb'al ri', xel b'i chila'. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Xopan k'u pa ri u tinimit ri Are'. Xuchaplej ki tijoxik ri winaq pa ri rachoch Dios ri k'o chila'. Are k'u ri winaq sib'alaj xkikajmaj wa', xkib'ij: ¿Jawije' xretamaj wi we achi ri' we no'j ri'? ¿Jas lo kub'ano che ki b'anik ri nimaq taq kajmab'al ri tajin keb'antaj rumal? —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Are wa' ru k'ojol ri tata' ri qolol che', ru nan k'ut are ri nan María. Katz ri a Jacobo, ri a José, ri a Simón, xuquje' ri a Judas. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","E k'o k'u ri ranab' quk' waral xuquje'. ¿Jawije' k'ut xretamaj wi wa' ronojel ri tajin kub'ano? —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Rumal ri' ri winaq xa tzel xkita ru tzij. Xub'ij k'u ri Jesús chke: Pa nik'iaj tinimit chik, nim kil wi ronojel q'alajisal re ru Loq' Pixab' ri Dios. Xaq xuwi pa ru tinimit ri are', xuquje' chkixol ri rachalal, xuquje' cho rachoch man nim tä kil wi, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Man xkowin tä k'u ri Jesús chub'anik k'ia taq kajmab'al chila' rumal chi ri winaq man xekojon tä che ri Are'. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Pa taq ri q'ij ri' ri tat Herodes, ri nim taqanel pa Galilea, xretamaj ri tajin kub'an ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Xub'ij k'u chke ri winaq ri e k'o ruk': Are ri Juan Qasal Ja' ri' ri xk'astaj loq chkixol ri käminaqib', rumal ri' käkowin ri are' chub'anik k'ia u wäch kajmab'al, —xcha ri tat Herodes chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tzare k'u ri tat Herodes xtaqan chuchapik ri tat Juan rech käyutik, käyi' pa che', xa rumal rech ri nan Herodías ri xk'uli ruk' are' pune are rixoqil ri Felipe ru chaq'. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Xub'ij k'u ri tat Juan che ri tat Herodes: Man taqal tä che la chi käb'an ixoqil la che ri rixoqil ri chaq' la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ri tat Herodes sib'alaj kraj kukämisaj ri tat Juan, kuxej k'u rib' chkiwäch ri winaq. Je ri', rumal chi konojel ketam chi ri Juan Qasal Ja', are jun q'alajisal re ru Loq' Pixab' ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Xuriq k'u ri nimaq'ij re ri rok'owisaxik u junab' ri tat Herodes. Are k'u ri ali ri ral ri nan Herodías xok b'i kuk', xuchap xojowem chkiwäch ri ula' ri e k'olik. Xqaj k'u ri ali chuwäch ri tat Herodes. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Sib'alaj xqaj chuwäch, xub'an k'u juramento chi kuya che ri ali apachike ta ne ri kraj ri are'. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ri ali k'ut kojom chi loq u k'ux rumal ru nan, xub'ij che ri tat Herodes: Kwaj chi käya la chwe ru jolom ri Juan Qasal Ja' pa jun plato, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Sib'alaj k'u xb'ison ri tat Herodes. Rumal k'u rech chi xub'ij wa' ruk' juramento chkiwäch konojel ri rula' chi kuya che ri ali apachike ri kuta' che, xtaqan k'u chuya'ik wa' che. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Xtaqan che resaxik ru jolom ri Juan Qasal Ja' ri k'o pa che'. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Xk'am loq pa jun plato, xyi' k'u che ri ali. Ri ali k'ut xuya che ru nan. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Xeopan k'u ru tijoxelab' ri tat Juan, xkik'am b'i ru cuerpo, xekiya kan pa jun muqub'al. Xeb'e' k'ut, xekib'ij che ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ri Jesús, aretaq xuto jas ri xb'antaj che ri tat Juan, xel b'i chila' u tukiel, xok pa jun barco, xe' k'u jela' jawije' ri man k'o tä wi winaq. Xketamaj k'u ri winaq chi ri Jesús b'enaq jela'. Xeb'el loq pa taq ri ki tinimit, xeb'e' k'u chi kaqan churiqik ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Aretaq xel loq ri Jesús pa ri barco, xeril ri k'ialaj winaq, xel k'u u k'ux chke. Xeukunaj ri yawab'ib' ri xkik'am b'i jela' kuk'. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Qajem k'u kub'an ri q'ij, ru tijoxelab' ri Jesús xeqeb' ruk', xkib'ij che: We juyub' ri' ri uj k'o wi sib'alaj kätz'inowik, b'enaq chi k'u ri q'ij. Chetaqa la b'i ri winaq rech keb'e' pa ri alaj taq tinimit ri naqaj e k'o wi, rech käkiloq' k'u na ri ki wa, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ri Jesús xub'ij chke: Man rajwaxik taj keb'e'k, xane xa chiya ix ri käkitijo, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Xkib'ij k'u ru tijoxelab' che: Xa job' kaxlan wa rachi'l kieb' kär k'o quk', —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ri Jesús xub'ij chke: Chik'ama loq chwe waral, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Xtaqan k'u ri Jesús chi ket'uyi ri winaq cho ri räxalaj uwosaq. Ri Jesús xeuk'am k'u ri job' kaxlan wa xuquje' ri kieb' kär, xka'y chikaj, xeutewchij. Te k'u ri' xeupir ri kaxlan wa, xeuya chke ri tijoxelab' rech kekijach wa' chkiwäch ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Xewi' k'u konojel, xenoj k'ut. Te k'u ri' xekik'ol ri ch'aqataq ri xekanaj kanoq. Xub'an kab'lajuj chikäch wa' chi ronojel. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kraj are job' mil achijab' ri xewi'k. Man xeajilax tä k'u ri ixoqib' xuquje' ri ak'alab' (ri xuquje' xewi'k). ");
INSERT INTO qucNNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Te k'u ri' ri Jesús xub'ij chke ru tijoxelab' chi utz we keb'ok pa ri barco rech keb'e'k, kenab'ej apan chuwäch ri Are' rech keopan ch'äqäp che ri mar. Are k'u ri Are' xkanaj na kan kuk' ri k'ialaj winaq che ki jachik b'ik. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Aretaq e jachtajinaq chi b'i ri winaq rumal ri Jesús, xe' ri Are' puwi' ri juyub' u tukiel chub'anik orar. Aretaq xok ri aq'ab', ri Jesús u tukiel k'o chila'. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Are k'u ri tijoxelab' e k'o chi pa ri barco puwi' ri ja' pu nik'iajal ri mar. Ri nimaq taq uwoja' xupuk'ij rib' chrij ri barco, rumal chi xa chkiwäch petinaq wi ri kiäqiq'. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Xa k'u jub'iq' man käsaqirik aretaq xopan ri Jesús kuk', tajin käb'in puwi' ri ja'. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Aretaq ri tijoxelab' xkilo chi käb'in ri Jesús puwi' ri ja', xkixej kib'. Rumal rech chi xkixej kib' xkiraq ki chi', xkib'ij: ¡Are jun xib'inel wa'! —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Chanim ri Jesús xeuch'ab'ej, xub'ij chke: ¡In wa', mixej iwib', chichajij anima'! —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Xch'aw k'u ri tat Pedro, xub'ij che: We lal ri', Tat, taqan la chi kinb'in puwi' ri ja', rech kinopan uk' la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ri Jesús xub'ij che: Tasa'j b'a', —xcha ri Jesús che. Ri tat Pedro xel b'i pa ri barco, xuchaplej b'inem puwi' ri ja' rech kuriqa ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Aretaq k'ut xrilo chi sib'alaj k'o u chuq'ab' ri kiäqiq', xuxej rib'. Xe' ri raqan pa ri ja', xuraq u chi', xub'ij che ri Jesús: ¡Wajaw, chinto' la! —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ri Jesús chanim xuchap che ru q'ab', xub'ij che: ¡Tzij ri' chi man qas tä katkojonik! ¿Jas che xub'an kieb' a k'ux? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Aretaq k'ut xpaqi ri Jesús pa ri barco, xtäni ri kiäqiq'. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ri e k'o pa ri barco xexuki chuwäch ri Jesús, xkib'ij che: Qas tzij, lal ri' ri u K'ojol ri Dios, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Xeq'ax pa ri mar, xeopan k'u chuchi' ri ulew pa Genesaret. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Aretaq ri winaq ajchila' xkich'ob' u wäch ri Jesús, xkesaj u tzijol wa' pa taq ri tinimit. Xekik'am k'u loq konojel ri yawab'ib' jawije' chi' k'o wi ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Xkib'ochi'j ri Jesús chi xuwi ta ne kuya chke chi käkichap koq ru chi' ru q'u'. Konojel k'u ri xechapowik, xeutzirik. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Te ri' jujun tata'ib' fariseos xuquje' jujun chke ri tata'ib' tijonelab' re ri Pixab' ri e petinaq pa ri tinimit Jerusalén, xkimulij kib' chrij ri Jesús, xkita' che: ");
INSERT INTO qucNNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","¿Jas che ri tijoxelab' la man käka'n taj jas ri e naq'atal wi ri qa nan qa tat ojer? Man käka'n taj jas ri naq'atal u b'anik. Are wa' ru ch'ajik ri rij ri ki q'ab' aretaq mäja' kewi'k, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Xuta' k'u ri Jesús chke: E ri alaq, ¿jas che yo'm kan alaq ru Loq' Pixab' ri Dios? Chuk'exwäch wa' are jikib'am anima' alaq chrij ri naq'atal wi alaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kub'ij k'u ri Dios pa ri Loq' Pixab' ri Tz'ib'talik: “Nim cheawila wi ra nan a tat,” —kächa'. Xuquje' kub'ij: “Jachin ri kuyoq' ru nan u tat, tzrajwaxik wi ri' käkämisaxik,” —kächa', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ri alaq k'ut käb'ij alaq chi xaq xuwi rajwaxik kub'ij jun achi chke ru nan u tat: “Ronojel ri kinkowinik kinkoj che to'ik alaq, nu yo'm cho ri Dios,” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","We ri achi je' kub'ij wa', man käya tä alaq che chi k'o jas kub'an che ki to'ik ru nan u tat. Je ri' man nim tä chik kil wi alaq ru Tzij ri Dios, man k'o tä k'u u patän ru Loq' Pixab' ri Dios chuwäch alaq rumal ru b'anik ri naq'atal wi alaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Xaq kieb' wäch alaq! Qas tzij ri xub'ij ri qa mam Isaías ri q'alajisal re ru Loq' Pixab' ri Dios chij alaq aretaq xutz'ib'aj kan we tzij ri' ri kub'ij: ");
INSERT INTO qucNNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","We winaq ri' xaq chi ki chi' käkinimarisaj nu q'ij, Man qas tä käkijikib'a ri kanima' chwij, —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Xaq loq' keq'ijilan chwe, xaq k'u ki taqanik winaq käkiya che tijonik, —xcha ri Dios chuchi' ri qa mam Isaías. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ri Jesús xeusik'ij ri winaq ruk', xub'ij chke: Alaq, onojel alaq, tatab'ej alaq ri nu tzij, ch'ob'o alaq ri kinb'ij. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ri kutij ri winaq, man are tä ri' ri ketzelan u wäch ru k'aslemal, xane xa are ri kel loq pu chi' ri winaq are wa' ri ketzelan u wäch ru k'aslemal, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Xeqeb' k'u ri tijoxelab' ruk' ri Jesús, xkib'ij che: ¿A etam la chi ri tata'ib' fariseos k'äx xkina' ri xb'ij la? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ri Jesús xch'awik, xub'ij chke: Apachike u wäch tiko'n ri man xtik tä rumal ri nu Tat ajchikaj, käb'oq na apanoq. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Xaq je' taq ke la' ri fariseos. Ri e are' e je' jas moyab' ri käkik'am ki b'e nik'iaj moyab' chik. We jun moy kuk'am u b'e jun moy chik, ri kieb' ri' ketzaq na pa jun jul. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Xub'ij k'u ri tat Pedro che ri Jesús: B'ij la chqe jas kel kub'ij ri k'utb'al ri xkoj la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ri Jesús xub'ij che: ¿A mat lo kich'ob' wa' ri ix? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿A mat iwetam chi ronojel ri kutij ri winaq pa ri rixko'l ke' wi, kel k'u kanoq aretaq kub'ana ru chul? —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Are k'u ri kel loq pu chi' ri winaq, pa ranima' ri' kel wi loq. Are k'u wa' ri ketzelan u wäch ru k'aslemal. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Je ri', rumal chi pa ranima' ri winaq kel wi loq ri itzel taq chomanik, ru b'anik kämisanik, ru b'anik ri nimalaj mak ruk' ri rixoqil jun winaq chik, ru b'anik jas ri käka'n ri tz'i' ri xaq käkiriq kib', man k'o tä ki pixab', ru b'anik elaq', ru b'anik ri b'anow tzij, xuquje' ru yakik tzij chrij jun winaq chik. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","E are wa' we etzelal ri' ri ketzelan u wäch ru k'aslemal ri winaq cho ri Dios. Are k'u we jun winaq man kub'an tä ri naq'atal u b'anik, man kuch'aj tä ri rij ru q'ab' aretaq mäja' käwi'k, man käretzelaj tä ru k'aslemal ri' cho ri Dios, —xcha ri Jesús chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Xel b'i ri Jesús chila', xe'k, xopan pa Fenicia chunaqaj ri tinimit Tiro, xuquje' ri tinimit Sidón. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Xpe k'u jun ixoq aj Cananea ri k'o chila', xopan ruk' ri Jesús, xuraq k'u u chi', xub'ij: ¡Tat, lal ri' ri rachalaxik kan ri David, chel k'ux la chwe! Ri wal ali k'o jun itzel espíritu che, sib'alaj kuriq k'äx rumal, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ri Jesús k'ut man k'o tä jun tzij xub'ij che. Xepe k'u ru tijoxelab' ri Jesús, xkita' toq'ob' che, xkib'ij: Taqa la b'i ri chichu' rumal chi xaq kuraq u chi' teren chqij, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Xub'ij k'u ri Jesús chke: Ri Dios in u taqom loq xaq xuwi kuk' ri winaq aj Israel, rumal chi ri e are' e je' ta ne chij ri e sachinaq, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Xpe k'u ri ixoq, xqeb' ruk' ri Jesús, xxuki chuwäch, xub'ij che: ¡Tat, chinto' la! —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ri Jesús xub'ij che: Man utz tä ru chapik ri ki wa ri qas ralk'ual jun, käk'iäq ta k'u chkiwäch ri alaj taq tz'i', —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Xub'ij k'u ri ixoq che: Je', Tat. Xuquje' ne ri alaj taq tz'i' ri keb'ok pa ja, käkitij ru xe'r taq ki wa ri kajaw ri ketzaq pulew, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ri Jesús xub'ij che ri ixoq: ¡Qas tzij b'a' chi nim ri kojonik la, nan! Chb'antaj ta b'a' jas ri kaj la, —xcha che. Tzare chi' k'ut xutzir ri ral ali. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Xel b'i ri Jesús chila', xok'ow chuchi' ri mar re Galilea. Te k'u ri' xpaqi puwi' jun juyub', xt'uyi k'u chila'. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Xeopan k'u k'ia winaq ruk' kuk'am b'i ch'okojib', moyab', memab', winaq ri k'äx u b'anom ri ki q'ab', xuquje' e k'ia ri k'o nik'iaj yab'il chik chke. Xekiya chuwäch ri Jesús, ri Are' k'ut xeukunaj. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ri winaq sib'alaj xkikajmaj aretaq xkilo chi ri memab' xech'aw chik, ri k'äx u b'anom ki q'ab' xeutzirik, ri ch'okojib' xeb'in chik, ri moyab' xeka'y chik. Xkichap k'u u nimarisaxik u q'ij ri Dios aj Israel. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ri Jesús xeusik'ij ru tijoxelab', xub'ij chke: Kel nu k'ux chke ri winaq rumal chi oxib' q'ij chi wa' e k'o wuk', man k'o tä k'u jas käkitijo. Man kwaj taj keintaq b'i cho taq kachoch mäja' k'u kewi'k, ketzaq ta k'u ne pa taq ri b'e, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ru tijoxelab' xech'awik, xkib'ij che: ¿Jawije' ta k'u lo käqariq wi ri wa ri käqaya chke we k'ialaj winaq ri' waral pa we juyub' ri' ri kätz'inowik? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Xuta' k'u ri Jesús chke: ¿Janipa' kaxlan wa k'o iwuk'? —xcha chke. Ri e are' xkib'ij: Wuqub' kaxlan wa, rachi'l kieb' oxib' alaj taq kär, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Xtaqan k'u ri Jesús chke ri k'ialaj winaq chi keku'b'i pulew. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Te k'u ri' xeuk'am ri wuqub' kaxlan wa, xuquje' ri alaj taq kär, xmaltioxinik. Xeupiro, xeuya chke ru tijoxelab' rech käkijach wa' chkiwäch ri winaq. Je k'u ri' xka'no. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Xewi' k'u konojel ri winaq, xenojik. Xekimulij k'u ri ch'aqataq taq wa ri xekanaj kanoq. Ronojel wa' xub'an wuqub' chikäch wa. ");
INSERT INTO qucNNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","E kiejeb' mil achijab' k'ut ri xewi'k. Man xekajilaj tä k'u ri ixoqib' xuquje' ri ak'alab' (ri xuquje' xewi'k). ");
INSERT INTO qucNNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Te k'u ri' ri Jesús xeujach b'i ri winaq rech keb'e' cho taq kachoch. Ri Are' xok b'i pa ri barco, xe' pa ri tinimit Magdala. ");
INSERT INTO qucNNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ri tata'ib' fariseos xuquje' ri tata'ib' saduceos xeopan ruk' ri Jesús. Te k'u ri' xkita' che chi kuk'ut chkiwäch jun kajmab'al etal ri käpe chikaj. Xkib'ij wa' che xaq rech käqaj ri Jesús pa ki q'ab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Xch'aw k'u ri Jesús, xub'ij chke: Pa b'enaq taq q'ij käb'ij alaq: “Saq'ij wa' kub'ano rumal chi kiäq ri uwokaj,” —kächa alaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Are k'u ri aq'ab'il käb'ij alaq: “Kämik käpe jäb' rumal chi kiäq ri uwokaj, xuquje' q'eqmuj,” —kächa alaq. ¡Ri alaq xaq kieb' wäch alaq! Käkowin alaq chuch'ob'ik ri u wäch ri kaj, man käch'ob' tä k'u alaq jas ri tajin kuk'ut ri Dios chuwäch alaq pa taq we q'ij junab' ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","We winaq ri' ri e lawalo, ri man jikom tä kanima', käkaj chi kinb'an jun kajmab'al etal chkiwäch. Man käyi' tä chi k'u na jun etal chke, xane are kinna'taj chke ri etal rech ri Jonás, —xcha chke. Ri Jesús xeuya kan wa' we achijab' ri', xe'k. ");
INSERT INTO qucNNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Aretaq xeq'ax ru tijoxelab' ri Jesús ch'äqäp che ri mar, xsach pa ki jolom ru k'amik b'i ki wa. ");
INSERT INTO qucNNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Xub'ij k'u ri Jesús chke: ¡Chitampe'! Chichajij iwib' chuwäch ri ki ch'amil ri tata'ib' fariseos xuquje' chuwäch ri ki ch'amil ri tata'ib' saduceos, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Xkitzijob'ela k'u kib' ri tijoxelab', xkib'ij: Ri Are' kub'ij wa' chqe rumal chi man k'o tä qa wa qa k'amom loq, —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Aretaq ri Jesús xretamaj jas ri tajin käkib'ij, xub'ij chke: ¿Jas che tajin kib'ij chi man k'o tä i wa? ¡Tzij ri' chi xa man qas tä kixkojonik! —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿A xaq are mäja' kich'ob'o, man käna'taj tä chiwe chi xinpir ri job' kaxlan wa, xinjach k'u wa' chkiwäch ri job' mil winaq? ¿A mat käna'taj chiwe janipa' chikäch ch'aqataq taq kaxlan wa ri man xek'is taj ri xeik'olo? ");
INSERT INTO qucNNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿A mat k'u käna'taj chiwe xuquje' chi xinpir ri wuqub' kaxlan wa, xinjach k'u wa' chkiwäch kiejeb' mil winaq, janipa' chikäch ch'aqataq taq kaxlan wa ri man xek'is taj ri xeik'olo? ");
INSERT INTO qucNNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Jas che man kich'ob' taj chi ri in man are tä tajin kinb'ij ri kaxlan wa aretaq xinb'ij chi kichajij iwib' chuwäch ri ki ch'amil ri tata'ib' fariseos xuquje' ri tata'ib' saduceos? —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Te k'u ri' ri tijoxelab' xkich'ob'o chi ri Jesús man are tä xub'ij chke chi käkichajij kib' chuwäch ri ch'äm re kaxlan wa, xane chuwäch ri ki tijonik ri tata'ib' fariseos xuquje' ri tata'ib' saduceos. ");
INSERT INTO qucNNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Aretaq ri Jesús tajin känaqajin che ri tinimit Cesarea Filipo, xuta' chke ru tijoxelab', xub'ij chke: ¿Jas käkib'ij ri winaq chwij chi jachin ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Xkib'ij k'u che: E k'o jujun winaq käkib'ij chi lal ri' ri Juan Qasal Ja', xuquje' käkib'ij jule' chik chi lal ri' ri qa mam Elías. E k'o chi nik'iaj käkib'ij chi lal ri' ri qa mam Jeremías o jun chik chke ri ojer q'alajisal taq re ru Loq' Pixab' ri Dios, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Xuta' k'u ri Jesús chke: E k'u ri ix, ¿jachin ri in ri kib'ij ix? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Xch'aw ri tat Pedro, xub'ij che: Lal ri' ri Cristo, ru K'ojol ri k'aslik Dios, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ri Jesús xch'awik, xub'ij che: Utz awe, Simón, u k'ojol ri tat Jonás, rumal chi man are tä jun winaq ri xb'in wa' chawe, xane are ri nu Tat ri k'o chila' chikaj. ");
INSERT INTO qucNNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ri in kinb'ij chawe chi ri at, at Pedro. Puwi' k'u we nimalaj ab'aj ri' keinjeqb'a wi na ri winaq ri kekojon chwe. Man käkowin tä k'u na ri kämikal chusachik ki wäch, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Keinya chawe ri lawe re ri k'olib'al ri taqan wi ri Dios. Jachike ri kaq'alajisaj chi man utz tä u b'anik cho ruwächulew, man utz tä u b'anik ri' chila' chikaj. Jachike ri kaq'alajisaj chi utz u b'anik cho ruwächulew, utz u b'anik ri' chila' chikaj. ");
INSERT INTO qucNNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ri Jesús k'ut xeupixb'aj ru tijoxelab', xub'ij chke chi mäkitzijoj wa' che jachin jun chi ri Are' are ri Cristo. ");
INSERT INTO qucNNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tzare chi' k'ut ri Jesús xuchaplej u q'alajisaxik chkiwäch ru tijoxelab' chi ri Are' rajwaxik ke' na pa ri tinimit Jerusalén. Xub'ij chi käb'an na sib'alaj k'äx che kumal ri ki nimaqil ri winaq, kumal ri ki nimaqil ri sacerdotes, xuquje' kumal ri tijonelab' re ri Pixab'. Xuquje' rajwaxik chi käkämisax na, te ri' käk'astaj chi k'u na churox q'ij chkixol ri käminaqib'. ");
INSERT INTO qucNNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Are k'u ri tat Pedro xuk'am b'i ri Jesús u tukiel wi. Xuchaplej u yajik, xub'ij che: ¡Mat kraj ri Dios wa', Wajaw! ¡Mat je' käk'ulmaj la wa'! —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Xutzolq'omij k'u rib' ri Jesús, xub'ij che ri tat Pedro: ¡Chatel chnuwäch, Satanás, xaq at ya'l latz' chwe! Man kach'ob' tä k'u ru chomanik ri Dios, xane xaq xuwi kach'ob' ri ki chomanik winaq, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ri Jesús k'ut xub'ij chke ru tijoxelab': We k'o jun kraj käpe wuk' in, rajwaxik chi mub'an chik xaq jas ri kraj ri are'. Rajwaxik kutelej loq ru cruz, käpe wuk' in, —xcha chke. (Kel kub'ij wa' chi ri winaq ri' man nim tä chik käril ru k'aslemal, xane kuya u tzij pune ta ne kuriq ri kämikal rumal rech ri Jesús.) ");
INSERT INTO qucNNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Je ri', rumal chi apachin ta ne ri kraj kuto' u wi' ru k'aslemal cho ruwächulew, käkäm na ri winaq ri', kutzaq na ronojel. Apachin k'u ri kuya ru k'aslemal pa ri k'äx rumal wech in, kuto' na u wi' ri' ri qas u k'aslemal wa'. ");
INSERT INTO qucNNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Jas ta k'u lo ri kuch'ak jun winaq we kärechb'ej ronojel ruwächulew, kutzaq k'u na ri ranima'? ¿Jas ta k'u lo ri käkowin ri winaq chuya'ik chuk'exwäch ri ranima'? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kinpe k'u na in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, e wachi'l ri loq'alaj taq ángeles. Känimarisax na nu q'ij jas ru nimarisaxik u q'ij ri nu Tat. Kinya k'u na ri tojb'al ke ri winaq chkijujunal jas ri xka'n ri e are' pa ri ki k'aslemal. ");
INSERT INTO qucNNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Qas tzij kinb'ij chiwe chi e k'o jujun chke ri e k'o waral ri man kekäm tä na k'ä kinkil na in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, in petinaq rech kintaqan pa ki wi' ri winaq, —xcha ri Jesús chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Xke' waqib' q'ij u b'im kan ri Jesús wa', aretaq xeuk'am b'i ri tat Pedro, ri tat Jacobo, xuquje' ri tat Juan ru chaq' ri tat Jacobo. Ki tukiel wi xepaqi puwi' jun nimalaj juyub'. ");
INSERT INTO qucNNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Xk'extaj k'u ru kayeb'al ri Jesús chkiwäch. Ru palaj ri Jesús xjuluwik je' jas ri q'ij. Ri ratz'iaq xub'an sib'alaj saqloloj je' jas ri saqil. ");
INSERT INTO qucNNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Xaq k'u te'talik xkik'ut kib' kieb' achijab' ri tajin ketzijon ruk' ri Jesús. E are' ri qa mam Moisés rachi'l ri qa mam Elías. ");
INSERT INTO qucNNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Xch'aw k'u ri tat Pedro, xub'ij che ri Jesús: Qajaw, ¡sib'alaj utz chi uj k'o waral! We kaj la, käqa'n na oxib' mo', jun che la, jun che ri qa mam Moisés, jun chik che ri qa mam Elías, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Aretaq tajin kätzijon ri tat Pedro, xqaj loq jun saqloloj sutz' chkij, xech'uqtaj k'u rumal. Te k'u ri' xch'aw loq Jun chupam ri sutz', xub'ij: Are ri loq'alaj nu K'ojol wa', sib'alaj käkikot ri wanima' rumal. Chitatab'ej b'a' ri kub'ij, —xcha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ri tijoxelab', aretaq xkita wa', sib'alaj xkixej kib'. Xexuki'k xkiqasaj ri ki palaj cho ri ulew. ");
INSERT INTO qucNNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Are k'u ri Jesús xqeb' kuk', xeuchap k'u qajoq, xub'ij chke: Mixej b'a' iwib'. Chixwalijoq, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ri e are' chanim xeka'ylob'ik. Man k'o tä chi k'u jachin xkilo, xane xaq xuwi ri Jesús k'o kuk'. ");
INSERT INTO qucNNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Qajem ke loq cho ri juyub', ri Jesús xeupixb'aj, xub'ij chke: K'o jachin mitzijoj wi ri iwilom k'ä kink'astaj na chkixol ri käminaqib', in ri' ri Ralk'ual ri Dios ri Qas Winaq, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ri tijoxelab' xkita' che ri Jesús, xkib'ij che: ¿Jas che käkib'ij ri tijonelab' re ri Pixab' chi rajwaxik käpe na ri qa mam Elías nab'e? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Xch'aw k'u ri Jesús, xub'ij chke: Tzij ri' chi käpe ri qa mam Elías nab'e, rech kub'an na u b'anik ronojel. ");
INSERT INTO qucNNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ri in k'ut kinb'ij chiwe chi ya ulinaq chik ri qa mam Elías. Ri winaq k'ut man xkich'ob' tä u wäch, xane xa xka'n che ri are' jas ri xkaj xka'no. Je k'u ri' xuquje' ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, kinriq na k'äx pa ki q'ab', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Xkich'ob' k'u ri tijoxelab' chi ri tajin kub'ij ri Jesús chke, are ri Juan Qasal Ja'. ");
INSERT INTO qucNNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Aretaq k'ut xeopan chila' jawije' e k'o wi ri k'ialaj winaq, xpe jun achi, xopan ruk' ri Jesús, xxuki k'u chuwäch, xub'ij che: ");
INSERT INTO qucNNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Tat, chel k'ux la che ri nu k'ojol, xa k'o jun itzel espíritu che, sib'alaj k'u kuriq k'äx rumal. K'ia mul kätzaq pa ri q'aq', pa ri ja'. ");
INSERT INTO qucNNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Xink'am loq, xinya chkiwäch ri tijoxelab' la, ri e are' k'ut man xekowin tä chukunaxik, —xcha che ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ri Jesús xch'awik, xub'ij: ¡Ay, ri alaq winaq ri man käkojon tä alaq che ri Dios! ¡Xaq xuwi käb'an alaq jas ri kaj alaq! ¿A are lo kaj alaq chi xaq tajin wi kink'oji uk' alaq ronojel q'ij? ¿A are lo kaj alaq chi xaq kinkuy alaq? K'ama b'a' alaq loq ri ala chnuwäch, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ri Jesús k'ut xuyaj ri itzel espíritu ri k'o che ri ala, xresaj b'ik. Tzare chi' xutzir ri ala, utz chi k'u kanoq. ");
INSERT INTO qucNNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ru tijoxelab' ri Jesús xkita' che pa u tukiel wi: ¿Jas che ri uj man xujkowin tä che resaxik b'i ri itzel espíritu ri'? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Xub'ij ri Jesús chke: Are wa' rumal chi man qas tä k'o ri i kojonik, —xcha chke. Qas tzij kinb'ij chiwe chi we ta ri i kojonik je' jas ri in nitz' ija' re mostaza, kixkowin ri' kib'ij che we juyub' ri': “¡Chatel b'i chi', jat jela'!” —kixcha che. Ri juyub' kel na b'ik. Man k'o tä ri mat kixkowin chub'anik we ta qas tzij kixkojonik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Xaq xuwi ruk' ru b'anik orar, xuquje' ruk' ru b'anik ayuno kel b'i jun itzel espíritu ri je' u b'anik wa', —xcha ri Jesús chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Aretaq xetzelej b'i kuk' ri k'ialaj winaq, ri Jesús xub'ij chke ru tijoxelab': Ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, kinjach na pa ki q'ab' ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Kinkämisax na, churox q'ij k'ut kink'astaj na chkixol ri käminaqib', —xcha chke. Aretaq xkita wa' ri tijoxelab', sib'alaj xeb'isonik. ");
INSERT INTO qucNNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Aretaq ri Jesús kuk' ru tijoxelab' xeopan pa ri tinimit Capernaum, ri toq'il taq alkab'al re ri nimalaj rachoch Dios xeopan ruk' ri tat Pedro, xkib'ij che: ¿A mat kutoj re ri ajtij alaq ri alkab'al re ri nimalaj rachoch Dios? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Je', je ri', —xcha ri tat Pedro chke. Aretaq k'ut xok b'i ri tat Pedro pa ri ja, nab'e xch'aw ri Jesús, xub'ij che: Simón, ¿jas kachomaj? ¿Jachin taq chke käkita' wi ri alkab'al o ri kuchuj ri nimaq taq taqanelab' rech ruwächulew? ¿A käkita' wa' chke ri ki winaqil o chke ri man ki winaqil taj? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ri tat Pedro xch'awik, xub'ij che: Chke ri man ki winaqil taj käkita' wi wa', —xcha che. Ri Jesús xub'ij che: We je ri', ri winaq ri keb'el pa ri ki tinimit ri nimaq taq taqanelab' man k'o tä alkab'al ri' käkitojo, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Man kwaj tä k'ut chi kinyak royowal jachin jun winaq. Rumal ri' jat chuchi' ri mar, chak'iäqa b'i ri anzuelo pa ri ja'. Chawesaj loq ri nab'e kär ri kachapo, pu chi' k'ut kawesaj wi jun puaq. Ruk' ri puaq ri' katoj ri alkab'al re ri nimalaj rachoch Dios, ri wech in xuquje' ri awech at. Chak'ama k'u wa', kate' k'ut, katojo kanoq, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Pa ri q'ij ri' ri tijoxelab' xkimulij kib' ruk' ri Jesús, xkita' che: ¿Jachin ri nim na u b'anik chila' jawije' ri kätaqan wi ri Dios? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ri Jesús xusik'ij apan jun alaj ak'al, xuk'amo, xutak'ab'a chkiwäch ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Xub'ij k'u chke: Qas tzij kinb'ij chiwe. We ri ix man kik'ex tä ri iwanima', ri i chomanik, we man kib'an iwe jas ri käka'n ri ak'alab' man käka'n tä nimal, man kixopan tä ri' chila' jawije' ri kätaqan wi ri Dios, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Je k'u ri' kinb'ij chiwe chi ri nim na u b'anik chila' jawije' ri kätaqan wi ri Dios, are ri man nim tä kub'an che rib', kub'an k'ut jas we ak'al ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Apachin ri kuk'ulaj jun ak'al jas we ak'al ri' rumal wech in, in ri' kinuk'ulaj, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Apachin k'u ri kub'ano chi jun chke we ch'utiq ri' ri kekojon chwe kuriq ri b'e ri man utz taj, are utz ri' we ta käxim jun ka' re molino chuqul ri winaq ri', käk'iäq ta k'u b'i pa ri mar. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Sib'alaj k'äx chke ri winaq cho ruwächulew chi k'o jas ri kub'ano chi ri winaq käkiriq ri b'e ri man utz taj! Amaq'el k'ut käkik'ulmaj wa'. Sib'alaj k'äx k'u re ri winaq ri kub'ano chi jun winaq chik kuriq ri b'e ri man utz taj. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Rumal ri', we ri a q'ab' o ri awaqan kub'ano chi ri at kariq ri b'e ri man utz taj, chaq'ata', chak'iäqa apanoq. Are utz na chawe we kariq na ri qas k'aslemal pune at kut o at ch'oko', chuwäch ri k'o kieb' a q'ab' o kieb' awaqan kate' pa ri k'atik jawije' k'o wi ri q'aq' ri man kächuptaj taj. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","We are ri a waq'äch kub'ano chi kariq ri b'e ri man utz taj, chawesaj, chak'iäqa apanoq. Are utz na chawe we kariq na ri qas k'aslemal pune xa jun ra waq'äch k'olik, chuwäch ri k'o kieb' a waq'äch, katk'iäq b'i pa ri nimalaj q'aq', —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Miwetzelaj b'a' ki wäch jun chke we ch'utiq ri' ri kekojon chwe. Kinb'ij k'u chiwe chi ri e are' amaq'el ronojel q'ij k'o ri ki ángeles chuwäch ri nu Tat chila' chikaj. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Je ri', rumal chi ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, xinpe che ki to'ik ri winaq ri e sachinaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Jas kichomaj chrij ri kinb'ij na? We k'o jun achi ri k'o jun ciento u chij, kätzaq k'u kan jun chke, ¿a mat keuya na kan ri' ri jumuch' b'elejlajuj pa ri juyub', ke' k'u chutzukuxik ri jun ri xtzaq kanoq? Je', je ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","We kuriqo, sib'alaj käkikot na ruk'. Nim na ru kikotemal ruk' wa' chuwäch ru kikotemal kuk' ri jumuch' b'elejlajuj ri man xetzaq taj. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Je k'u ri' ri i Tat ri k'o chila' chikaj man kraj taj chi kätzaq jun chke we ch'utiq ri' ri kekojon chwe. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","We ri awachalal kub'an jun k'äx chawe, chattzijon ruk' pa u tukiel wi, chab'ij che jas ru mak. We kukoj rib' chupam, xatkowin ri' chuch'akik ra wachalal. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","We k'u ri awachalal man kukoj tä rib' pa ru mak aretaq kattzijon ruk', chasik'ij jun o kieb' winaq chik, rech ronojel ri kib'ij ketamax wa' kumal kieb' u oxib' tal taq tzij. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","We k'u man kok ri tzij pu jolom ri käb'ix che kumal ri nik'iaj chik, cheasik'ij konojel ri nik'iaj qachalal. We k'u man kuto jas ri käkib'ij konojel ri qachalal, chab'ana che chi je' jas jun winaq ri man käkojon tä che ri Dios o jun toq'il alkab'al. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Qas tzij kinb'ij chiwe chi jachike ri kiq'alajisaj chi man utz tä u b'anik kumal ri winaq cho ruwächulew, man utz tä u b'anik ri' chila' chikaj. Jachike k'u ri kiq'alajisaj chi utz u b'anik kumal ri winaq waral cho ruwächulew, utz u b'anik ri' chila' chikaj. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Xuquje' kinb'ij chiwe chi we k'o kieb' chixol waral cho we uwächulew ri kuriq rib' ki chomanik puwi' jun rajwaxik, käka'n k'u orar chuta'ik wa', ri qa Tat ri k'o chila' chikaj kuya na wa' chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Je ri', rumal chi jawije' ri ki mulim wi kib' kieb' oxib' winaq rumal chi kekojon chwe, kuk' ri' in k'o wi, —xcha ri Jesús chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Xpe ri tat Pedro, xuta' k'u che ri Jesús: Qajaw, we ri wachalal k'ia mul kub'an k'äx chwe, ¿janipa' mul rajwaxik kinsach u mak? ¿A kraj ne wuqub' mul ri'? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Xch'aw k'u ri Jesús, xub'ij che: Man kinb'ij tä chawe chi xa wuqub' mul kasach u mak, xane rajwaxik kasach u mak wuqub' mul chik, wuqub' mul chik, k'ä kopan na pa job' ciento, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Je ri', rumal chi ru taqanik ri Dios pa ki wi' ri winaq, are je' jas jun q'inom achi ri xeumulij ri rajchakib', xuchap k'u u ta'ik we k'o ri ki k'as, o we ne k'o u k'as ri are' kuk'. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Aretaq tajin kuchaplej rajilaxik ri ki kuenta chkijujunal, xk'am loq jun ajchak ri u k'as k'ia mil quetzales. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Are k'u ri jun ajchak ri' man k'o tä kutojb'ej re ru k'as. Ri patrón xtaqanik chi käk'iyix ri ajchak ri' pu q'ab' jun winaq chik rech käpatänin che, rachi'l ri rixoqil, ri ralk'ual, xuquje' konojel ri jastaq re, rech kätojtaj ru k'as. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Are k'u ri ajchak xxuki chuwäch ru patrón, xb'ochi'nik, xuta' toq'ob', xub'ij che: “Tat, chajij la paciencia wuk', kintoj na ronojel ri nu k'as,” —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ri patrón xutoq'ob'isaj u wäch ri rajchak, xusach u mak, xub'ij che chi man kutoj tä chi ru k'as, xutzoqopij k'u b'ik. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Te ri' ri ajchak ri xtzoqopitaj b'ik, xuriq jun rach ajchak ri u k'as kieb' oxib' quetzal ruk'. Xuchap ri rach ajchak chuqul, xuchap u jitz'axik, xub'ij che: “¡Chatojo ra k'as wuk'!” —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ri rach ajchak xxuki chuwäch, xb'ochi'nik, xuta' toq'ob' che, xub'ij: “Chachajij paciencia wuk', kintoj na ronojel ri nu k'as,” —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ri are' k'ut man xusach tä u mak ri rach ajchak, xane xukoj pa che', xub'ij che chi rajwaxik kutoj na ru k'as. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Aretaq xkil wa' ri nik'iaj ajchakib' chik, sib'alaj xeb'isonik. Xeb'e' k'ut, xekib'ij che ri ki patrón ronojel ri xb'antajik. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Xpe k'u ri ki patrón, xtaqan chusik'ixik ri ajchak ri', xub'ij che: “¡Itzel ajchak! Ri in xinkuy ra k'as rumal chi xata' toq'ob' chwe. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ri at xuquje' rajwaxik xatoq'ob'isaj ta u wäch ri awach ajchak, jas ri xinb'an in chawe xintoq'ob'isaj a wäch,” —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","¡Ru patrón k'ut, sib'alaj xpe royowal! Xtaqanik chi käk'äjisax u wäch ri rajchak k'ä kutoj na ru k'as. ");
INSERT INTO qucNNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ri Jesús xuk'isb'ej re ru tzij, xub'ij: Jas ri xub'an ri patrón che ri rajchak, are je' kub'an na ri nu Tat ri k'o chila' chikaj chiwe, we man qas kisach ki mak ri iwachalal, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Aretaq xto'taj ri Jesús chub'ixik ronojel wa' we tzij ri', xel b'i pa Galilea, xe' pa taq ri tinimit re Judea, ch'äqäp che ri nima' Jordán. ");
INSERT INTO qucNNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","E k'ia winaq xeteri b'i chrij, xeukunaj k'u taq ri yawab'ib' chila'. ");
INSERT INTO qucNNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Xeopan k'u jujun tata'ib' fariseos ruk' ri Jesús, xkita' che: ¿A taqal che jun achi kujach b'i ri rixoqil pune man qas k'o u mak? —xecha che. Xkib'ij wa' che xaq rech käqaj ri Jesús pa ki q'ab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Xch'aw k'u ri Jesús, xub'ij chke: ¿A mat sik'im alaq pa ru Loq' Pixab' ri Dios ri Tz'ib'talik jas ri xub'an ri Dios pa ru chaplexik loq ronojel, “chi achi chi ixoq xeub'ano”? —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Xuquje' kub'ij: “Rumal wa' jun achi kuya na kan ru nan u tat, kätuni k'u na ruk' ri rixoqil. Xa e jun chik ri kieb' winaq ri',” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Je k'u ri' man e kieb' tä chik, xane xa e jun chik. Rumal k'u ri', jas ri xeutunub'a ri Dios, mäjach ki wäch wa' kumal ri winaq, —xcha ri Jesús chke ri tata'ib' fariseos. ");
INSERT INTO qucNNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Xkib'ij k'u ri tata'ib' fariseos: ¿Jas che ri qa mam Moisés xtaqanik chi jun achi kuya' kutz'ib'aj jun wuj ri kub'ij wi chi kujach b'i ri rixoqil? Je k'u ri' kuya' kujach b'i ri rixoqil, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ri Jesús xub'ij chke: Xa rumal chi sib'alaj ab'ajarinaq ri anima' alaq, are rumal ri' xuya chech alaq chi kuya' käjach b'i alaq ri ixoqil alaq. Man je' tä k'u wa' aretaq xchapletaj loq ronojel. ");
INSERT INTO qucNNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ri in k'ut kinb'ij chech alaq chi apachin ri kujach b'i ri rixoqil, we man rumal ru ch'ab'exik jun achi chik, käk'uli chi k'u na ruk' jun ixoq chik, ri achi ri' kub'an ri nimalaj mak ri äwas u b'anik chrij ri nab'e rixoqil. Ri achi k'ut ri käk'uli ruk' jun ixoq ri jachom kanoq kub'an ri nimalaj mak ri', —xcha ri Jesús chke ri tata'ib' fariseos. ");
INSERT INTO qucNNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Xkib'ij k'u ru tijoxelab' ri Jesús che ri Are': We jun achi man kuya' taj kujach b'i ri rixoqil, are utz na ri' chi man käk'uli taj, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ri Jesús xub'ij chke: Man konojel tä winaq käkich'ij wa' chi man kek'uli taj, xane xaq xuwi ri yo'm chke rumal ri Dios chi käkich'ijo. ");
INSERT INTO qucNNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","K'o k'u jas che jujun achijab' man kek'uli taj. E k'o jujun xa tzkech wi man kek'uli taj, e k'o nik'iaj chik ri xa b'anom chke kumal ri achijab' chi man kek'uli taj, e k'o k'u nik'iaj chik käkich'ijo man kek'uli taj xa rumal chi käkaj käkipatänij ri Dios. Jachin ri käkowinik je' kub'an wa', chub'ana', —xcha ri Jesús chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ri winaq xekik'am loq ri ak'alab' cho ri Jesús rech kuya ru q'ab' pa ki wi', rech xuquje' kub'an orar pa ki wi'. Ri winaq ri xekik'am loq ri ak'alab' xeyaj kumal ri tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ri Jesús k'ut xub'ij chke: Chiya chke ri ak'alab' chi kepe wuk', meiq'atej rumal chi ri winaq ri kätaqan ri Dios pa ki wi' e are' winaq ri e je' jas we ak'alab' ri', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Xuya k'u ru q'ab' pa ki wi' ri ak'alab', te k'u ri' xel b'i chila'. ");
INSERT INTO qucNNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Jun ak'al achi xopan ruk' ri Jesús, xuta' che: Utzalaj Ajtij, ¿jas u wäch utzil rajwaxik kinb'ano rech kinriq ri k'aslemal ri man k'o tä u k'isik? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ri Jesús xub'ij che: ¿Jas che kab'ij chwe chi utz ri in? Man k'o tä jun qas utz, xane xaq xuwi ri Dios, —xcha che. We k'u kawaj kariq ri k'aslemal ri man k'o tä u k'isik, chanimaj ru taqanik ri Dios, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ri achi xub'ij che: ¿Jachike taq ri' ru taqanik ri Dios ri rajwaxik kinniman chke? —xcha che. Ri Jesús xub'ij che: Matkämisanik, mab'an ri nimalaj mak ri äwas u b'anik ruk' ri rixoqil jun winaq chik, mab'an ri elaq', mab'an tzij chrij jun winaq chik. ");
INSERT INTO qucNNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Nim cheawila wi ra nan a tat. Loq' cheawila wi ri awach winaq jas ri at loq' kawil awib', —xcha ri Jesús che ri achi. ");
INSERT INTO qucNNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ri achi xub'ij che ri Jesús: Ronojel wa' nu taqem u b'anik tzaretaq in ak'al na. ¿Jas ta chi k'u ri rajwaxik kinb'ano? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ri Jesús xub'ij che: We kawaj käjikomataj ra k'aslemal cho ri Dios, jat, cheak'iyij konojel ri jastaq awe, chaya ri rajil chke ri meb'a'ib'. Käk'oji k'u na ra q'inomal chila' chikaj. Te ri' tasa'j wuk', —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Aretaq ri achi xuta ri xub'ij ri Jesús, xk'extaj ru wäch, xb'isonik, xe'k rumal chi k'ia ru q'inomal k'olik. ");
INSERT INTO qucNNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Xub'ij k'u ri Jesús chke ru tijoxelab': Qas tzij kinb'ij chiwe, chi sib'alaj k'äx kutij jun q'inom kok chkixol ri winaq ri kätaqan ri Dios pa ki wi'. ");
INSERT INTO qucNNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Are man k'äx tä ri rok'owisaxik jun awaj camello pa ru julil jun t'isomb'al b'aq, chuwäch ri rokik jun q'inom chkixol ri winaq ri kätaqan ri Dios pa ki wi', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ri tijoxelab' aretaq xkita wa', sib'alaj xkikajmaj, xkib'ij k'u chb'il taq kib': ¿Jachin ta k'u lo ri käkowinik kuriq ru tob'anik ri Dios? —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ri Jesús ko xka'y chke, te ri' xub'ij: Man kekowin tä ri winaq chub'anik wa', käkowin k'u na ri Dios che ronojel, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ri tat Pedro xub'ij che ri Jesús: Qajaw, chilampe la chi ri uj qa yo'm kan konojel ri jastaq qe, uj k'o uk' la. ¿Jas k'u ri käyi' na chqe? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Xch'aw k'u ri Jesús, xub'ij chke: Qas tzij kinb'ij chiwe, kopan na jun q'ij aretaq käb'an k'ak' che ronojel. Aretaq ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, kinku'b'i na pa ri je'lalaj nu t'uyulib'al, känimarisax nu q'ij, are chi' k'ut chi ri ix, ri ix ri k'o wuk' kixku'b'i na xuquje' pa kab'lajuj je'lalaj taq t'uyulib'al. Kiq'at k'u na tzij pa ki wi' ri kab'lajuj tinimit re Israel. ");
INSERT INTO qucNNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Konojel ri ki yo'm kan kachoch, kachalal, ki nan ki tat, kixoqil, kalk'ual, kulew rumal wech in, käkiriq na jun ciento mul ri tojb'al ke, xuquje' käkiriq na ri k'aslemal ri man k'o ta u k'isik pa taq ri q'ij ri junab' ri kepe na, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","E k'ia k'u ri winaq ri nim ke'il wi kämik ri man nim tä chi na ke'il wi pa taq ri q'ij ri'. Xuquje' e k'ia ri man nim tä ke'il wi kämik ri nim ke'il wi na pa ri q'ij ri', —xcha chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ru taqanik ri Dios pa ki wi' ri winaq, are je' jas jun achi ajchaq'el jun nimalaj ulew. Xel b'i sib'alaj aq'ab' che ki tzukuxik ajchakib' che ki mulixik ru wäch taq uvas. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Xeuriq k'u jujun achijab', xuchomaj k'u kuk' chi käkich'ak kakab' quetzal che ri jun q'ij, xeutaq k'u b'i pa ri rulew che ri chak. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Xel chi k'u b'i jumul pa ri u b'elej hora re ri aq'ab'il. Xeril nik'iaj achijab' chik ri xaq tajin keqasan q'ij pa ri k'ayib'al. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Xub'ij k'u chke: “Jix pa ri nu chak, kinya k'u na ri tojb'al iwe ri taqal chiwe,” —xcha chke. Ri e are' k'ut xeb'e' pa ri chak. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ri patrón xel chi b'i jumul pa ri nik'iaj q'ij che ki tzukuxik ajchakib', xuquje' pa ri urox hora re ri b'enaq q'ij, junam xub'an kuk' nik'iaj ajchakib' chik. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Pa ri uro' hora chik re ri b'enaq q'ij, xel chi b'i jumul pa ri k'ayib'al. Xeuriqa chi nik'iaj achijab' ri xaq tajin keqasan q'ij, xub'ij k'u chke: “¿Jas che xaq ix k'o waral juntir ri jun q'ij man k'o tä k'u chak kib'ano?” —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ri e are' xkib'ij: “Xa man k'o tä jun ri käb'in chak chqe,” —xecha che. Xub'ij k'u chke: “Jix pa chak wuk' in pa ri wulew, kinya k'u na ri tojb'al iwe ri taqal chiwe,” —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Aretaq k'ut xok ri aq'ab', ri patrón xub'ij che ri chajil ke ri ajchakib': “Cheasik'ij ri ajchakib', chaya b'i ri tojb'al ke. Are kachap ki tojik nab'e ri xeb'ok k'isb'al. Are k'u ri xeb'ok nab'e keatoj wa' k'isb'al,” —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Xepe k'u ri ajchakib' ri te' xeb'ok pa chak pa ri uro' hora re ri b'enaq q'ij. Chkijujunal tz'aqat kakab' quetzal xyi' chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Te k'u ri', aretaq hora chik chi ketoj ri okinaq nab'e pa ri chak, ri e are' xkichomaj chi más na ri tojb'al ke käyi' chkiwäch ri k'ä te' xeb'ok pa ri chak. Xuquje' k'u ri e are' xyi' kakab' quetzal chke chkijujunal. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Aretaq xkik'amo xkichap u yajik ri ki patrón. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Xkib'ij: “We ajchakib' ri' ri te' xeb'ul k'isb'al, xa jun hora xechakunik. Xaq junam k'u ki tojik xb'an la jas ri uj. Ri uj k'ut xqach'ij ronojel ri jun q'ij chak, xujchakun chuwäch ru chuq'ab' ri q'ij,” —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ri patrón xub'ij che jun chke ri ajchakib': “E ri at, man k'o tä jas ri tajin kinb'an chawe ri mat jikom. ¿A mat junam xqachomaj chi xaq kieb' quetzal ri tojb'al awe? ");
INSERT INTO qucNNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","K'ama b'i ri tojb'al awe, jat. Ri in kwaj kinya ri tojb'al ke we nik'iaj ri' ri te' xeb'ok k'isb'al junam jas ri xinya chawe at. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿A mat pa nu q'ab' k'o wi jachike ri kwaj kinb'an ruk' ri nu rajil? ¿A xa k'äx ne kana' chi in utz kuk' konojel?” —xcha ri patrón che ri ajchak. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Je k'u ri' ri winaq ri man nim tä ke'il wi kämik nim ke'il wi na. Are k'u ri winaq ri nim ke'il wi kämik, man nim tä chi ke'il wi na. E k'ia ri e sik'im. Man e k'ia tä k'ut ri e cha'talik, —xcha chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Paqalem re ri Jesús pa Jerusalén, xeusik'ij k'u ri kab'lajuj u tijoxelab' pa ki tukiel wi, xub'ij chke: ");
INSERT INTO qucNNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","¡Chiwilampe'! B'enam qe, tajin kujpaqi pa ri tinimit Jerusalén. Kinjach k'u na in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, pa ki q'ab' ri ki nimaqil ri sacerdotes, xuquje' pa ki q'ab' ri tijonelab' re ri Pixab'. Käkiq'at k'u na tzij pa nu wi' chi kinkämisax na. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Kinkijach k'u na pa ki q'ab' ri nik'iaj winaq chik, käketz'b'ej na nu wäch, kinkich'ay na, kinkirip k'u na cho ri cruz. Kink'astaj k'u na chkixol ri käminaqib' churox q'ij, —xcha ri Jesús chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Te k'u ri' xeqeb' ru k'ojol ri tat Zebedeo ruk' ri Jesús. E are' ri tat Jacobo, ri tat Juan, kachi'l ri ki nan. Ri ki nan xxuki chuwäch ri Jesús chuta'ik jun toq'ob' che. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ri Jesús xuta' che: ¿Jas kaj la, nan? —xcha che. Ri chichu' xub'ij: Aretaq kächaplej taqanik la pa ki wi' ri winaq, kwaj chi käya la chke ri kieb' wal chi keku'b'i uk' la, ri jun pa wikiäq'ab' la, ri jun chik pa ri moxq'ab' la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Xub'ij k'u ri Jesús chke: Ri ix man kich'ob' taj jas u wäch toq'ob' ri tajin kita' chwe. ¿A kixkowinik kich'ij ri k'äx ri kinriq na in, kitij iwe ri k'o pa ri vaso ri kintij wi na we? ¿A kixkowinik käb'an na i qasna' ix jas ri qasna' ri käb'an na chwe in? —xcha chke. Xkib'ij k'u che: Kujkowinik, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Xub'ij ri Jesús chke: Qas tzij kiriq na k'äx, kitij k'u na iwe ri k'o pa ri vaso ri kintij na we in, xuquje' käb'an na i qasna' jas ri käb'an na chwe in. Are k'u ri t'uyulem pa ri nu wikiäq'ab' o pa ri nu moxq'ab', man kuya' taj kinya in chiwe, xane are wa' kech ri e cha'tal rumal ri nu Tat chi ket'uyi pa taq ri t'uyulib'al ri', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Aretaq ri lajuj tijoxelab' chik xkita u b'ixik ronojel wa', xpe koyowal ri e are' chrij ri tat Jacobo, ri tat Juan. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Xeusik'ij k'u ri Jesús, xub'ij chke: Ri ix iwetam chi ri winaq ri yo'm chke chi ketaqan pa ki wi' ri nik'iaj winaq chik, käkina' chi qas k'o ki chuq'ab' pa ki wi'. Ri ki nimaqil ri winaq k'ut ketaqan pa ki wi', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Man je' tä k'u wa' ri ix. Xane apachin chiwe ri kraj chi nim kil wi, rajwaxik chi kok na che patänil ke konojel. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Apachin chiwe ri kraj kok che i nimal, rajwaxik chi kok na che patänil ke ri nik'iaj chik. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Are je ri', rumal chi ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, man in petinaq taj rech kinpatänixik, xane rech kinpatänin chke nik'iaj chik, xuquje' rech kinya ri nu k'aslemal che tojb'al re ri ki torik k'ia winaq, —xcha ri Jesús chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Aretaq ri Jesús tajin kel b'i pa ri tinimit Jericó e rachi'l ru tijoxelab', e k'ia winaq xeteri b'i chrij. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","E k'o k'u kieb' achijab' moyab' t'uyul chi' ri b'e. Xkito chi ri Jesús tajin kok'ow chila', xkiraq ki chi', xkib'ij che ri Jesús: ¡Tat, lal ri' ralk'ual kan ri qa mam David, toq'ob'isaj la qa wäch! —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ri winaq xa xekiyajo, xkib'ij chke chi chkitz'apij u pa ki chi'. Are k'u ri e are' man xkita taj, xane sib'alaj ko chi na xkiraq ki chi', xkib'ij: ¡Tat, lal ri' ralk'ual kan ri qa mam David, toq'ob'isaj la qa wäch! —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Xtak'i k'u ri Jesús. Xeusik'ij ri kieb' moyab', xuta' chke: ¿Jas kaj alaq chi kinb'an chech alaq? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ri moyab' xkib'ij: Tat, käqaj kujka'yik, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Te ri' ri Jesús xutoq'ob'isaj ki wäch, xuchap k'u koq ri ki waq'äch. Chanim k'ut xekowinik xeka'yik, xeb'e' k'u ruk' ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Aretaq naqaj chik e k'o wi che ri tinimit Jerusalén, xeopan pa ri alaj tinimit Betfagé. Tajin keok'ow chuwäch ri Ujuyub'al Olivos. Ri Jesús xeutaq b'i kieb' chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Xub'ij b'i chke: Jix pa ri alaj tinimit ri k'o apan chqawäch. Chila' kiriq wi na jun ati't burro yuqulik, rachi'l jun alaj burro. Chikira', cheik'ama k'u loq chwe, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","We k'o jachin jun k'o jas kub'ij chiwe, chib'ij che chi xa kajwataj che ri Qajaw Jesús, chanim k'ut kutzelej chi na loq, —kixcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Je' xb'antaj wa' rech qas je' kelik jas ri xutz'ib'aj kan ri q'alajisal re ru Loq' Pixab' ri Dios ri kub'ij: ");
INSERT INTO qucNNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Chib'ij chke ri winaq re ri tinimit Jerusalén ri k'o puwi' ri juyub' Sión: “¡Chiwilampe'! Ri Nimalaj i Taqanel petem re iwuk'. Man nim tä u b'anik u b'anom che rib', xane kiejeninaq chrij jun burro. Chrij ri alaj ral jun burro kiejeninaq wi,” —kächa ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Xeb'e' k'u ri kieb' tijoxelab', je' xka'no jas ri xetaq wi b'i rumal ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Xkik'am loq ri ati't burro rachi'l ri ral. Xkiya k'u ri ki q'u' chrij, xkiejen k'u ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","E k'ia k'u ri winaq xkilik' ri ki q'u' pa ri b'e, xuquje' e k'o nik'iaj chik ri xekiya u xaq taq che' pa ri b'e ri xekich'upala pa taq ri juyub'. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ri winaq ri e nab'ejinaq chuwäch ri Jesús, xuquje' ri e teretoj chrij, ko xech'awik, xkib'ij: ¡Chnimarisax u q'ij ri ralk'ualaxik ri qa mam David ri nim taqanel! ¡Utz re ri petinaq pa ru b'i' ri Qajaw Dios! ¡Chnimarisax u q'ij ri Dios! —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Aretaq xok ri Jesús pa ri tinimit Jerusalén, konojel ri winaq xkitukij kib', xkitatab'ala chb'il taq kib', xkib'ij: ¿Jachin wa' we achi ri'? —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ri winaq xkib'ij: Are wa' ri Jesús, ri q'alajisal re ru Loq' Pixab' ri Dios, ri aj Nazaret re Galilea, —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Te k'u ri' xok b'i ri Jesús pa ri nimalaj rachoch Dios, xeresax b'i ri ajk'ayib' xuquje' ri kekiloq' taq jastaq pa ri nimalaj rachoch Dios. Xeutzaq ri ki mesa ri k'exal taq puaq xuquje' xeutzaq ri ki tem ri ajk'ay taq palomäx. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Xub'ij chke ri winaq: Tz'ib'tal pa ru Loq' Pixab' ri Dios, kub'ij: “Ri wachoch in are jun ja ri käb'an wi orar,” —kächa'. Ri alaq k'ut jun kachoch elaq'omab' b'anom alaq che, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Chila' pa ri nimalaj rachoch Dios, xeopan jujun achijab' moyab' ruk' ri Jesús, xuquje' jujun ch'okojib'. Xekunax k'u rumal ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Aretaq k'ut ri ki nimaqil ri sacerdotes xuquje' ri tijonelab' re ri Pixab', xkil taq ri kajmab'al ri xub'an ri Jesús, xuquje' xkito chi ri ak'alab' käkiraq ki chi' pa ri nimalaj rachoch Dios, käkib'ij: “¡Nim u q'ij ri ralk'ual kan ri nim taqanel David ojer!” —kecha'. Ri e are' xpe koyowal. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Xkib'ij k'u che ri Jesús: ¿A käta la jas ri tajin käkib'ij ri ak'alab'? —xecha che. Ri Jesús xch'awik, xub'ij chke: Je', kinto, —xcha chke. ¿A mat sik'im pu alaq ri tz'ib'tal pa ru Loq' Pixab' ri Dios? Je wa' kub'ij: Xya la chke ri ak'alab', chke ri alaj taq ak'alab' ri ketu'nik chi qas tzij käkib'ixoj b'ix ri kuya u q'ij ri Dios, —kächa', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Xe' k'u ri Jesús, xeuya kan ri ki nimaqil sacerdotes xuquje' ri tijonelab' re ri Pixab'. Xel b'i pa ri tinimit Jerusalén, xe' pa ri tinimit Betania. Chila' k'ut xkanaj kan che ri chaq'ab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Aq'ab'il aretaq tajin ketzelej b'i pa Jerusalén, e petinaq pa ri tinimit Betania, xnum k'u ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Xril apan jun u che'al higos ri k'o chuchi' ri b'e. Xerila', man k'o tä k'u u wäch xuriqo, xane xaq xuwi u xaq. Xub'ij k'u ri Jesús che ri che': ¡Man k'o tä chi jumul chik käk'oji a wäch! —xcha che. Chanim k'ut xchaqi'jar ru che'al higos. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ru tijoxelab' ri Jesús aretaq xkil wa' sib'alaj xkikajmaj. Xkita' k'u che ri Jesús: ¿Jas che chanim xchaqi'jar ru che'al higos? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ri Jesús xch'awik, xub'ij chke: Qas tzij kinb'ij chiwe, we qas kixkojonik, man kub'an tä k'u kieb' i k'ux, man xuwi tä wa' kixkowin chub'anik jas ri xinb'an in che ru che'al higos. Xane kuya' kib'ij che we juyub' ri': “Chatel b'i waral, chak'iäqa b'i awib' pa ri mar,” —kixcha che. Käb'antaj k'u na wa', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ronojel k'u ri kita' che ri Dios käya'taj na chiwe we qas kixkojonik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ri Jesús xok pa ri nimalaj rachoch Dios. Aretaq tajin keutijoj ri winaq chila', ri ki nimaqil sacerdotes, xuquje' ri ki nimaqil ri winaq aj Israel xeopan ruk', xkita' che: ¿Jachin xtaqow la chi käb'an la ronojel wa' we ri'? ¿Jachin lo ri yo'winaq che la chi je' käb'an la wa'? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ri Jesús xch'awik, xub'ij chke: Ri in xuquje' k'o ri kinta' chech alaq. We käkowin alaq chub'ixik chwe jas ri kinta', kinb'ij na chech alaq jachin ri yo'winaq chwe chi k'o nu taqanik rech je' kinb'an wa', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","B'ij alaq chwe: ¿Jachin xtaqow ri tat Juan chub'anik ri qasna'? ¿A are ri Dios o e are ri winaq? —xcha chke. Xkichaplej k'u u tzijob'exik kib', xkib'ij: We käqab'ij chi are ri Dios xtaqowik, kub'ij na chqe: “¿Jas k'u che man xkojon tä alaq che?” —kächa na. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","We käqab'ij chi e are ri winaq xtaqowik, käqaxej qib' chkiwäch ri winaq. Konojel k'u ri winaq käkikojo chi ri tat Juan are jun q'alajisal re ru Loq' Pixab' ri Dios, —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Rumal wa' xkib'ij che ri Jesús: Man qetam taj, —xecha che. Ri Jesús xch'awik, xub'ij chke: Man kinb'ij tä k'u in chiwe jachin yo'winaq chwe chi kinb'an wa' we ri', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ri Jesús xub'ij chke ri tata'ib' fariseos: ¿Jas kächomaj alaq che wa' ri kinb'ij chech alaq ri'? K'o jun achi ri e k'o kieb' u k'ojol. Xub'ij k'u che jun chke ru k'ojol: “Nu k'ojol, jat kämik pa ri nu chak che ki mulixik ru wäch taq ri uvas,” —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ri ala xub'ij che ru tat: “¡Man k'o tä kine' wi in!” —xcha che. Te k'u ri' xuk'ex ru chomanik, xe' na che ri chak. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ri tata' xe' chi ruk' ri jun u k'ojol chik, xub'ij che: “Jat kämik pa ri nu chak che ki mulixik ru wäch taq ri uvas,” —xcha che. Ru k'ojol xub'ij che: “Je', tat, utz ri' kine'k,” —xcha che. Man xe' tä k'ut. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Jachin k'u chke we kieb' ri' xub'ano jas ri xraj ru tat chi käb'anik? —xcha ri Jesús chke ri tata'ib' fariseos. Ri e are' xkib'ij: Are ri xtaq nab'e, —xecha che ri Jesús. Xub'ij ri Jesús chke: Qas tzij ri kinb'ij chech alaq chi ri toq'il taq alkab'al, xuquje' ri itzel taq ixoqib' nab'e keb'ok na chuwäch alaq chkixol ri winaq ri kätaqan ri Dios pa ki wi', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Je ri', rumal chi ri Juan Qasal Ja' xpetik, xuk'ut chuwäch alaq jas käb'an alaq rech jikom ri k'aslemal alaq cho ri Dios, man xkoj tä k'u alaq ru tzij. Are k'u ri toq'il taq alkab'al, xuquje' ri itzel taq ixoqib' xkikojo. Are k'u ri alaq, pune xil alaq wa' ri xka'n ri e are', man xk'ex tä ri anima' alaq, man xk'ex tä k'u ri chomanik alaq. Man xkoj tä alaq ri xub'ij ri tat Juan Qasal Ja' chech alaq, —xcha ri Jesús chke ri tata'ib' fariseos. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Tatab'ej b'a' alaq we jun k'utb'al chik ri', —xcha chke. K'o jun achi ri xub'an jun tikb'al uvas, xukoralij rij, te k'u ri' xuk'ot jun jul ri käpitz' wi ri uvas, xub'an xuquje' jun tak'atikalaj ja ri käkoj che chajib'al re ronojel. Xuya k'u kan pa qajomal chke jujun achijab', te ri' xe' ri are' naj pa jun tinimit chik. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Xopan k'u ri q'ij ri xechäq'aj ri ki wäch ri uvas, ri ajchaq'el xeutaq b'i jujun patänil taq re kuk' ri ajchakib' chuk'amik re ri ki wäch ri uvas. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Are k'u ri ajchakib' xekichap ri patäninelab', jun xkich'ayo, jun xkikämisaj, jun chik k'ut xka'n chab'aj. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ri ajchaq'el ri ulew xeutaq chi b'i nik'iaj taqo'n chik. E k'ia chi na ri xeutaq b'ik chuwäch ri nab'e. Ri ajchakib' k'ut je' xka'n chke jas ri xka'n chke ri nab'e taq taqo'n. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Chuk'isb'al ronojel xutaq b'i ri u k'ojol, xuchomaj k'ut: “Qas nim käkil wi na ri nu k'ojol,” —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Aretaq k'ut ri ajchakib' xkil ru k'ojol ri tata', xkitzijob'ela kib', xkib'ij: “Are wa' ri kechb'en na ronojel. Jo', qakämisaj rech käq'ax kan ronojel ri ulew pa qa q'ab' uj,” —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Xkichapo, xkesaj b'i pa ri tikb'al uvas, xkikämisaj. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Te k'u ri' ri Jesús xuta' chke, xub'ij: Aretaq käpe ri ajchaq'el ri ulew tikb'al uvas, ¿jas kub'an na chke ri ajchakib'? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ri e are' xkib'ij che ri Jesús: Man kutoq'ob'isaj tä na ki wäch, keukämisaj na ri itzel taq ajchakib' ri', kuya k'u na ri tikb'al uvas chke nik'iaj chik, ri käkijach ru wäch ri tiko'n aretaq kuriq ri q'ij, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Xub'ij k'u ri Jesús chke: ¿A mat sik'im alaq wa' we tzij ri' pa ru Loq' Pixab' ri Dios? Je wa' kub'ij: Ri ab'aj ri man xkaj tä ri yakal taq ja, are ab'aj wa' xkoj che toq'eb'al re ri ja. Je' b'anom wa' rumal ri Qajaw Dios. Qas kajmab'al k'u wa' chqawäch, —kächa', —xcha ri Jesús chke ri tata'ib' fariseos. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Rumal ri' kinb'ij chech alaq chi ri Dios man kätaqan tä chi na puwi' alaq, xane ri Dios are kätaqan na pa ki wi' ri winaq ri utz käka'n che ri ki chak, ri käkijach kuenta cho ri Dios aretaq kuriq ri q'ij. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Are k'u we k'o jun kätzaq puwi' ri ab'aj, käq'aj na. We k'u ne are ri ab'aj kätzaq puwi' jun winaq, käk'äjisax na rumal ri ab'aj, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Aretaq ri ki nimaqil ri sacerdotes xuquje' ri tata'ib' fariseos xkita wa', xkich'ob'o chi chkij ri e are' xutzijoj wi wa' we k'utb'al ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Xkaj xkichap ri Jesús. Xkixej k'u kib' chkiwäch ri winaq, rumal chi ri winaq xkikojo chi ri Jesús are jun q'alajisal re ru Loq' Pixab' ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jumul chik ri Jesús xuchaplej ki tzijob'exik ri winaq kuk' taq k'utb'al, xub'ij chke: ");
INSERT INTO qucNNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Ru taqanik ri Dios pa ki wi' ri winaq, junam ruk' jun nim taqanel ri xub'an jun nimaq'ij che ru k'ulanem ru k'ojol. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Xeutaq b'i ri patänil taq re che ki sik'ixik loq ri winaq ri e sik'im pa ri k'ulanem, man xkaj tä k'u ri winaq xepetik. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ri tata' xeutaq chi b'i nik'iaj chik patänil taq re, xub'ij b'i chke: “Chib'ij chke ri winaq ri e sik'im chi xutzir ri wa. Xintaqan che ki kämisaxik ri nu wakäx, ri awaj ri e nu q'ob'sam xepilitajik. Ronojel ri ulab'al k'o chik, sa'j alaq pa ri k'ulanem,” —kixcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Are k'u ri winaq ri xesik'ix che ri k'ulanem man xeb'ok tä il che ri xub'ij ri nim taqanel. Xaq xkitzukuj jas xka'no. Jun xe' chusolixik ri rulew, jun chik xe' che k'ayinik. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ri nik'iaj chik xekichap ri u taqo'n ri nim taqanel, xka'n k'äx chke, xekikämisaj. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ri nim taqanel sib'alaj xpe royowal, xeutaq k'u b'i ru soldados che ki kämisaxik ri winaq ri xekämisan ru taqo'n. Xtaqan che ru poroxik ri ki tinimit. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Xub'ij k'u chke ri patänil taq re: “Ronojel ri kajwataj che ri k'ulanem k'o chik, are k'u ri winaq ri xeqasik'ij che ri k'ulanem man taqal tä chke chi kepetik. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Rumal ri' jix pa taq ri nim b'e, cheisik'ij loq konojel ri winaq ri keiriqo rech kepe pa ri k'ulanem,” —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ru taqo'n xeb'el b'i che ki tzukuxik ri winaq pa taq ri b'e. Xekimulij k'u loq konojel ri xekiriqo, ri e utz xuquje' ri man e utz taj. Xnoj k'u ri ja kumal ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Xok b'i ri tata' che kilik konojel ri xesik'ix pa ri k'ulanem. Xril k'u jun achi chkixol ri winaq ri man u kojom tä atz'iaq re k'ulanem. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Xub'ij che: E k'u ri at, “¿Jas che xatok loq waral we man k'o tä awatz'iaq re k'ulanem?” —xcha che. Ri achi man k'o tä jas xub'ij. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ri nim taqanel xub'ij chke ri ke'ilow ri mesa: “Chiyutu ri raqan u q'ab'. Jik'iäqa kan chrij ja pa ri q'equm. Chila' k'ut koq' wi na, kuquch'uch'ej na ru ware,” —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","E k'ia k'u ri e sik'im, xaq k'u e kieb' oxib' ri e cha'talik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Xeb'e' k'u ri tata'ib' fariseos, xkitala ki no'j, xjunamataj k'u ki chomanik rech käkik'ot u chi' ri Jesús xaq rech kuya' käkib'ij chi k'o u mak. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Rumal ri' xekitaq b'i jujun chke ri kachi'l junam kuk' nik'iaj chik ri e rachi'l ri tat Herodes chub'ixik che ri Jesús: Ajtij, qetam chi jikom ri anima' la, xuquje' chi käk'ut la ru b'eyal ru rayib'al ri Dios chkiwäch konojel ri winaq. Man käxej tä ib' la chkiwäch ri winaq, pune k'o jas käkichomaj chij la, rumal chi man nim tä kil la jun winaq chuwäch ri jun chik. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","B'ij b'a' la chqe jas ri kächomaj la: ¿A taqal chqe käqatoj alkab'al che ri César o man taqal taj? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ri Jesús xretamaj k'ut ri itzel taq ki chomanik, xub'ij chke: Xaq kieb' wäch alaq, ¿jas che käta' alaq wa' chwe? ¿A mat xa kaj alaq chi kinqaj pa q'ab' alaq? ");
INSERT INTO qucNNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","K'amampe alaq loq jun puaq chnuwäch ri kätojb'ex re ri alkab'al, —xcha chke. Xkik'am k'u loq ri jun puaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Aretaq ri Jesús xrilo, xub'ij chke: ¿Jachin ajchaq'el we kayeb'al ri', xuquje' we b'i'aj ri' ri tz'ib'tal chuwäch? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ri e are' xech'awik, xkib'ij: Are rech ri César, —xecha che. Xub'ij k'u ri Jesús chke: Ya b'a' alaq che ri César ri rech ri César. Ya k'u alaq che ri Dios ri rech ri Dios, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Aretaq ri tata'ib' fariseos xkita ri xub'ij ri Jesús chke, sib'alaj xkikajmaj u wäch. Xkiya k'u kanoq, xeb'e'k. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Pa ri q'ij ri' xeopan jujun tata'ib' saduceos ruk' ri Jesús. Ri tata'ib' ri' käkib'ij chi man kek'astaj tä chi na ri käminaqib'. Xkita' k'u che ri Jesús, xkib'ij: ");
INSERT INTO qucNNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ajtij, b'im kan chqe rumal ri qa mam Moisés chi we käkäm jun achi, käkanaj kan ri rixoqil pa malka'nil, man k'o tä k'u kan ralk'ual ruk', rajwaxik chi ri rachalal chaq'axel ri k'o kanoq käk'uli ruk' ri ixoq ri malka'n rech kek'oji ralk'ual ruk'. Ri ak'alab' ri' e je' ta ne rech ri käminaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Chqaxol uj je' xk'ulmataj wa': Xek'oji wuqub' achijab' kachalal kib'. Ri nab'eal xk'uli'k, xkäm k'ut. Man k'o tä ralk'ual xk'oji kan ruk' ri rixoqil, xa je ri' xkanaj kan ri malka'n ixoq che rixoqil ri chaq'axel rachalal. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Je' xk'ulmataj xuquje' ruk' ri ukab', ri urox rachalal, k'ä xek'is na ri wuqub' achalaxik. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","E käminaq chik konojel, xkäm k'u b'i ri ixoq. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Aretaq k'ut kek'astaj na ri käminaqib', ¿jachin chke wa' we wuqub' achijab' ri' käk'amow ri ixoq che rixoqil? Xk'oji k'u che kixoqil ri wuqub', —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ri Jesús xch'awik, xub'ij chke: Ri alaq xa sachinaq alaq rumal chi man etam tä alaq ru Loq' Pixab' ri Dios ri Tz'ib'talik, man etam tä k'u alaq ru chuq'ab' ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Aretaq ri käminaqib' kek'astajik, man kek'uli tä chik, man käkiya tä k'u ri kalk'ual che k'ulanem, xane xaq e junam chik kuk' ri ángeles rech ri Dios ri e k'o chila' chikaj, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Chrij k'u wa' chi kek'astaj na ri käminaqib', k'o na ri kwaj kinb'ij chech alaq: ¿A mat sik'im alaq ri kub'ij wi ri Dios? Je wa' kub'ij: ");
INSERT INTO qucNNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“In ri', in ru Dios ri Abraham, ru Dios ri Isaac, ru Dios ri Jacob,” —kächa'. Ri qa Dios man are tä Dios kech ri käminaqib', xane kech ri e k'ask'oj, —xcha ri Jesús chke ri tata'ib' saduceos. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Aretaq xkita ri winaq wa' ri xub'ij ri Jesús, konojel sib'alaj xkikajmaj ru tijonik. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Aretaq ri tata'ib' fariseos xkito chi ri saduceos xtz'apix u pa ki chi' rumal ri Jesús, ri e are' xkimulij kib'. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Jun k'u chke ri fariseos are tijonel re ri Pixab'. Xopan k'u ruk' ri Jesús rech kuk'am u pu chi', xub'ij che: ");
INSERT INTO qucNNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ajtij, ¿jachike ri taqanik ri nim na u b'anik ri k'o pa ri Pixab'? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ri Jesús xub'ij che: “Sib'alaj chiwaj ri i Dios, ri Iwajaw, chijikib'a ri i k'ux, chijikib'a ri iwanima' chrij, chikojo ri i chomanik chub'anik wa',” —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Are wa' ri taqanik ri nim na u b'anik, ri nab'e chkiwäch konojel. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ri ukab' taqanik ri nim na u b'anik ri junam ruk' ri nab'e are wa': “Cheiwaj ri i wach winaq, jas ri ix kiwaj iwib',” —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","We kieb' taqanik ri' e are wa' ri qas u k'ux ronojel ri Pixab' ri xutz'ib'aj ri qa mam Moisés, xuquje' e are wa' u k'ux ri ki tijonik ri q'alajisal taq re ru Loq' Pixab' ri Dios, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","K'ä ki mulim kib' ri tata'ib' fariseos. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Ri Jesús xuta' chke: ¿Jas kächomaj alaq chrij ri Cristo? ¿Ralk'ual jachinoq? —xcha chke. Ri e are' xkib'ij: Ri Cristo are ralk'ual kan ri qa mam David ojer, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ri Jesús xub'ij chke: ¿Jas k'u che ri qa mam David ojer rumal ri Loq'alaj Espíritu xub'ij Qajaw che ri Cristo? Xub'ij k'ut: ");
INSERT INTO qucNNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Xub'ij ri Qajaw ri qa Dios che ri Wajaw: “Chatt'uyul pa ri nu wikiäq'ab', k'ä kinya na chawe chi katch'akanik, kattaqan k'u pa ki wi' konojel ri käka'n ki k'ulel chawe,” —xcha ri qa mam David. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Jas ta ne che ri Cristo are ralk'ual kan ri David we ri qa mam David xub'ij Qajaw che ri Cristo? —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Man k'o tä chi k'u jachin jun xkowinik xch'awik, xub'ij ta chi jun tzij che ri Jesús. Pa taq k'u ri q'ij ri' xetani'k, man k'o tä chi jachin jun k'o jas xuta' che ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ri Jesús xub'ij chke ri winaq xuquje' chke ru tijoxelab': ");
INSERT INTO qucNNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ri tijonelab' re ri Pixab', xuquje' ri tata'ib' fariseos k'o taqanik pa ki q'ab' chuq'alajisaxik ri Pixab' ri xutz'ib'aj ri qa mam Moisés. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Cheinimaj b'a', chib'ana k'u ronojel ri käkib'ij chiwe. Xuwi k'u mib'an iwe jas ri käka'n ri e are', rumal chi jun wi ri käkib'ij, jun chi k'u wi ri käka'no. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ri taqanik ri käkiya are je' jas jun eqa'n ri sib'alaj al, ri man k'o tä jun kuch'ij ri ra'lal. Käkaj k'ut chi käkinimaj ri winaq. Ri e are' k'ut man k'o tä jub'iq' käka'n che ki to'ik. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ronojel ri käka'no xaq rech kilitaj kumal ri winaq. Käqaj chkiwäch käkinak' paj taq tzij re ru Loq' Pixab' ri Dios cho ru krukil ri ki palaj xuquje' che ri ki q'ab' ri tz'ib'tal cho rab'ara'q taq wuj. Xuquje' käqaj chkiwäch käkikoj charchäq taq atz'iaq ri k'o retz'b'alil nimaq na chuwäch ri ke ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Are käkitzukuj ri t'uyulib'al ri nim ke'il wi na pa taq ri ula'nem, xuquje' ri t'uyulib'al ri nimaq ki b'anik pa taq ri rachoch Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Käkaj chi sib'alaj utz ki ch'ab'exik käb'an kumal ri winaq pa taq ri b'e, xuquje' chi käb'ix ajtij chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Are k'u ri ix mib'ano chi ri winaq käkib'ij ajtij chiwe. Iwonojel ri ix, iwachalal iwib', xa k'u jun ri Iwajtij k'olik, are ri Cristo. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mib'an i tat che jun winaq cho ruwächulew, xa k'u jun ri i Tat, are ri k'o chila' chikaj. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mib'an che iwib' chkiwäch ri winaq chi ix k'amal taq ki b'e, xuwi k'u ri Cristo are K'amal i B'e. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Jachin ri keupatänij konojel, are wa' ri nim na u b'anik chixol. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Jachin ri nim kub'an che rib' man nim tä kil wi na. Jachin k'u ri man nim tä kub'an che rib' are ri' nim kil wi na. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","¡K'äx ech alaq, tijonelab' re ri Pixab' xuquje' ri alaq tata'ib' fariseos! ¡Xaq kieb' wäch alaq! Keq'atej alaq ri winaq rech man keb'ok tä chkixol ri winaq ri kätaqan ri Dios pa ki wi'. Xaq keq'atej alaq ri käkaj keb'okik, man kok tä k'u alaq xuquje'. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡K'äx ech alaq, tijonelab' re ri Pixab' xuquje' ri alaq tata'ib' fariseos! ¡Xaq kieb' wäch alaq! Kätoqij alaq ri kachoch ri malka'nib' taq ixoqib', te ri' käyuq alaq u tza'm ri tzij alaq aretaq käb'an alaq orar, rech man q'alaj tä ri etzelal ri käb'an alaq. Rumal ri' nim na ri k'äjisab'al wäch alaq aretaq käq'at na tzij pa ki wi' ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡K'äx ech alaq, tijonelab' re ri Pixab' xuquje' ri alaq tata'ib' fariseos! ¡Xaq kieb' wäch alaq! Ri alaq käwakat alaq cho ronojel ruwächulew, käq'ax alaq ch'äqäp che taq ri mar chuch'akik jun winaq ruk' ri tijonik alaq. Aretaq k'ut käkowin alaq chuch'akik, käb'an alaq che chi taqalik ke' pa ri q'aq' nab'e chuwäch alaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡K'äx ech alaq, ri alaq moyab' k'amal taq b'e! Ri alaq käb'ij alaq: “We jun winaq kukoj ru b'i' ri nimalaj rachoch Dios pa ru tzij aretaq kub'an juramento, man qas rajwaxik tä ri' kub'ano jas ri xuchi'j u b'anik. Are k'u we kukoj pa ru tzij ri q'än puaq ri kojom che ri nimalaj rachoch Dios, rajwaxik wi ri' kub'ano jas ri xuchi'j,” —kächa alaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Xaq alaq kon, xaq alaq moyab'! ¿Jachike nim na u b'anik: ri q'än puaq o ri nimalaj rachoch Dios ri kub'an nim u b'anik che ri q'än puaq? ");
INSERT INTO qucNNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Xuquje' käb'ij alaq: “We jun winaq kukoj ri ta'b'al toq'ob' pa ru tzij aretaq kub'an juramento, man qas rajwaxik tä ri' kub'ano jas ri xuchi'j u b'anik. We k'u are kukoj ri sipanik ri k'o puwi' ri ta'b'al toq'ob' pa ru tzij, rajwaxik ri' kub'ano jas ri xuchi'j,” —kächa alaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Xaq alaq kon, xaq alaq moyab'! ¿Jachike ri nim na u b'anik: ri sipanik o ri ta'b'al toq'ob' ri kub'an sib'alaj loq' che ri sipanik? ");
INSERT INTO qucNNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Jachin ri kukoj ri ta'b'al toq'ob' pa ru tzij, man xuwi tä ri ta'b'al toq'ob' ri' kukoj pa ru tzij, xane ronojel ri k'o puwi' ri ta'b'al toq'ob'. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Jachin ri kukoj ri nimalaj rachoch Dios pa ru tzij man xuwi tä ri nimalaj rachoch Dios ri' kukoj pa ru tzij, xane xuquje' ri Dios ri k'o chila'. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Xuquje' jachin ri kukoj ri kaj pa ri u tzij aretaq kub'an juramento, man xuwi tä kukoj ri je'lalaj u t'uyulib'al ri Dios pa ru tzij, xane xuquje' ri Dios ri t'uyul puwi'. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡K'äx ech alaq, tijonelab' re ri Pixab' xuquje' ri alaq tata'ib' fariseos! ¡Xaq kieb' wäch alaq! Ri alaq käya alaq che ri Dios ru lajujil ri q'eb'un, ri anís, ri comino, yo'm k'u kan alaq u b'anik ri tijonik ri nim u b'anik ri k'o pa ri Pixab'. Man käb'an tä alaq ri jikomal, man kätoq'ob'isaj tä alaq ki wäch nik'iaj winaq chik, man qas tä käkojon alaq che ri Dios. Are wa' ri rajwaxik käb'an alaq, man käya tä k'u kan alaq u b'anik ri nik'iaj chik. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Ri alaq, xaq alaq moyab' k'amal taq b'e! Käb'an ech alaq jas kub'an jun achi, man kraj taj kub'iq' b'i jun amalo. Je' ta ne chi käb'iq' b'i alaq jun awaj camello. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡K'äx ech alaq, tijonelab' re ri Pixab' xuquje' ri alaq tata'ib' fariseos! ¡Xaq kieb' wäch alaq! Utz käb'an alaq chkiwäch ri winaq xaq rech utz kil wi alaq kumal. Qas tzij k'ut kelaq'an alaq, kärayij alaq ri kech nik'iaj winaq chik. Je' ri b'anik alaq jas ri laq ri xuwi ch'ajtal ri rij, are k'u ru pam tz'il na. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Alaq moyab' taq fariseos. Are rajwaxik nab'e käch'aj ru pam ri vaso xuquje' ri plato, te k'u ri' käch'aj ri rij. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡K'äx ech alaq, tijonelab' re ri Pixab' xuquje' ri alaq tata'ib' fariseos! ¡Xaq kieb' wäch alaq! Junam alaq kuk' ri muqub'al ke taq ri käminaqib' ri tz'ajom ri rij che chun. Rumal ri' sib'alaj je'l kelik. Are k'u ru pam nojinaq che ki b'aqil taq käminaqib', xuquje' nojinaq che ronojel chulaj tz'ilol. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Je ri' ri alaq. Utz kel alaq chkiwäch ri winaq. Are k'u ri anima' alaq sib'alaj man utz taj, xaq k'u kieb' u wäch ri käb'an alaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡K'äx ech alaq, tijonelab' re ri Pixab' xuquje' ri alaq tata'ib' fariseos! ¡Xaq kieb' wäch alaq! Ri alaq käb'an alaq ki b'anik ri muqub'al kech ri q'alajisal taq re ru Loq' Pixab' ri Dios ojer. Käwiq alaq ri muqub'al kech ri winaq ri utz xka'no. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Käb'ij k'u alaq: “We ta xujk'oji kan pa ri ki q'ijol ri qa nan qa tat ojer, mat xujtob' ri' che ki kämisaxik ri q'alajisal taq re ru Loq' Pixab' ri Dios ojer,” —kächa alaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ruk' wa' we käb'ij alaq ri', käq'alajisaj ib' alaq chi alaq kachalaxik kan ri winaq ri xekämisan ri q'alajisal taq re ru Loq' Pixab' ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Xaq tajin käk'is alaq u b'anik ri xkichaplej kan u b'anik ri nan tat alaq ojer! ");
INSERT INTO qucNNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Alaq kumätz! ¡Itzel taq winaq! ¡Alaq kal taq kumätz! ¿Jachin ta lo ri käto'w alaq chuwäch ri k'äjisab'al wächaj re ri q'aq'? ");
INSERT INTO qucNNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Rumal ri' keintaq na loq q'alajisal taq re ru Loq' Pixab' ri Dios uk' alaq, keintaq na loq achijab' ri k'o ki no'j xuquje' tijonelab'. Are k'u ri alaq kekämisaj na alaq, kerip na alaq jujun chke cho ri cruz. Jujun chik kech'ay na alaq pa taq ri rachoch Dios. Jujun chik käb'an alaq k'äx chke je ri' chi rajwaxik keanimaj na b'i pa taq ri tinimit. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Rumal ri' alaq ajchaq' mak che ri ki kämikal konojel ri utzalaj taq winaq ri e kämisam. Xchaptaj loq ruk' ri Abel ri ala ri jikom ranima' k'ä ruk' ri Zacarías ru k'ojol ri Berequías ri xkämisaj alaq chkixol ri rachoch Dios ruk' ri ta'b'al toq'ob'. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Qas tzij kinb'ij chech alaq chi ronojel wa' we mak ri' käqaj na pa ki wi' ri winaq kämik, —xcha ri Jesús chke ri tijonelab' re ri Pixab' xuquje' ri fariseos. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","¡Ay, winaq aj Jerusalén! ¡Ix ri' ri keikämisaj ri q'alajisal taq re ru Loq' Pixab' ri Dios, keib'an che ab'aj ru taqo'n ri Dios! ¡K'ia mul nu rayim i mulixik iwonojel ri ix jas kub'an jun ati't ek' keumulij ri alaj taq ral chuxe' ru xik'! ¡Ri ix k'ut man xiwaj taj! ");
INSERT INTO qucNNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Xaq b'a' chiwila na käwonob'ax na kan ri iwachoch. ");
INSERT INTO qucNNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kinb'ij k'u chiwe chi man kiwil tä chi na nu wäch k'ä kopan na ri q'ij aretaq kib'ij: “Nim u q'ij ri petinaq pa ru b'i' ri Qajaw Dios,” —kixcha na, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Xel loq ri Jesús pa ri nimalaj rachoch Dios, b'enam re aretaq xeqeb' ru tijoxelab' ruk', xkichaplej u k'utik taq ri ja re ri nimalaj rachoch Dios chuwäch. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Xch'aw k'u ri Jesús, xub'ij chke: ¿A kiwil we nimaq taq ja ri'? Qas tzij ri kinb'ij chiwe chi man käkanaj tä k'u kan jun ab'aj puwi' jun ab'aj chik. Ronojel käwulix na, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Xe' k'u ri Jesús e rachi'l ru tijoxelab' puwi' ri Ujuyub'al Olivos. T'uyul k'u ri Jesús chila', ru tijoxelab' xeopan ruk', xkib'ij che pa u tukiel wi: Käqaj chi käb'ij la chqe, ¿jampa' käb'antaj na wa'? ¿Jas u wäch etal käb'antaj na chuk'utik chqawäch chi xopan ri q'ij re ri petb'al la xuquje' ri k'isb'al re ruwächulew? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ri Jesús xub'ij chke: Chichajij iwib', k'o jachin jun mixsub'uwik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","E k'ia k'ut ri kepe na, käkikoj na ri nu b'i', käkib'ij: “In ri' ri Cristo,” —kecha na. E k'ia winaq k'ut ri kesub'taj na kumal, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ri ix kita na chi tajin käb'an nimalaj ch'oj, kita na ki tzijoxik taq ch'oj jawije' taq chi', mixej k'u iwib'. Rajwaxik chi je' käb'antaj na wa', k'ä mäja' k'u ri k'isb'al. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Käch'ojin k'u na ri jun tinimit ruk' ri jun tinimit chik, xuquje' käch'ojin na jun nim taqanel ruk' jun nim taqanel chik. Käpe na wi'jal, käpe na nimaq taq yab'il, kepe na k'ia käb'raqan jawije' taq chi'. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Xaq k'u chapleb'al wa' re ronojel ri k'äx ri käpe na pa ki wi' ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Kixjach k'u na chkiwäch ri q'atal taq tzij rech käb'an k'äx chiwe, kixkämisax na. Konojel ri winaq käketzelaj na i wäch xa rumal wech in. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Pa taq ri q'ij ri' e k'ia ri kub'an na kieb' ki k'ux chwij. Käketzelaj na kib' chb'il taq kib', käkijachala na kib' pa kämisaxik. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","E k'ia ri kepe na ri xaq e b'anal taq tzij, käkib'ij chi e q'alajisal taq re ru Loq' Pixab' ri Dios, e k'ia k'u ri winaq ri kekisub' na. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Sib'alaj känimar na ri etzelal. Je ri' chi e k'ia winaq man käkaj tä chi na kib'. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Jachin k'u ri kuch'ij ri k'äx k'ä käk'is na ronojel, kuriq na ru tob'anik ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kätzijox k'u na ri Utzalaj Tzij re ri Evangelio chrij ru taqanik ri Dios cho ronojel ruwächulew chke konojel ki wäch winaq, te k'u ri' käpe na ri k'isb'al. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ri qa mam Daniel, jun chke ri q'alajisal taq re ru Loq' Pixab' ri Dios, xutz'ib'aj ojer chrij ri itzel awaj ri ketzelan na ronojel. (Jachin ri kusik'ij wa' ri tz'ib'tal waral, chuch'ob'o' jachin ri' ri awaj ri kub'ij chi'.) Kiwil na wa' käk'oji chila' pa ri loq'alaj k'olib'al jawije' ri man ya'tal tä wi chi k'olik. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Rajwaxik chi ri winaq ri e k'o pa Judea keanimaj b'i pa taq ri juyub'. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ri winaq ri k'o puwi' ri rachoch, aninaq chqaj loq, mok chi b'i chupam ri ja chuk'amik b'i jas jun jasach. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Xuquje' ri winaq ri k'o pa ri juyub', mätzelej chi b'i cho ja chuk'amik b'i ri ratz'iaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Sib'alaj k'äx ke ri ixoqib' ri yawab' taq winaq chik pa taq ri q'ij ri', xuquje' ri k'o alaj taq kal ri k'ä ketu'nik! ");
INSERT INTO qucNNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Chib'ana b'a' orar, chita' che ri Dios chi mäk'ulmataj ronojel wa' pa u q'ijol ri tew, xuquje' chi mat käb'antaj wa' pa ri q'ij re uxlanem. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Käpe k'u na nimalaj k'äxk'ol pa taq ri q'ij ri', ri man k'o tä jumul u b'anom wa' tzare chi' xchaplex loq ru b'anik ruwächulew rumal ri Dios, k'ä kämik. Te k'u ri' man käpe tä chi na nimalaj k'äxk'ol junam ruk' ri k'äxk'ol ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","We ta ri Qajaw Dios mat kub'ano chi xaq q'atatal q'ij käk'oji we k'äxk'ol ri', mat k'o jun winaq ri' ri käk'asi kanoq. Ri Dios k'ut u b'anom chi xaq q'atatal q'ij käk'oji wa' we k'äxk'ol ri' rumal chi keraj ri e cha'tal rumal ri Are', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","We k'u k'o jun ri kub'ij chiwe: “Chiwilampe', k'o ri Cristo chi ri',” we kub'ij: “Chiwilampe', k'o jela',” —kächa chiwe, mikojo ri kub'ij. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kepe k'u na winaq ri käka'n che kib' chi e Cristo, xuquje' kepe na jule' chik ri käka'n che kib' chi e q'alajisal taq re ru Loq' Pixab' ri Dios. Käka'n na nimaq taq etal, xuquje' nimaq taq kajmab'al che ki sub'ik ri winaq, xuquje' ne ri e cha'tal rumal ri Dios we kekowinik. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nu b'im chi k'u apan wa' chiwe ix, k'ä mäja' käb'antajik. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Rumal ri', we käb'ix chiwe: “Chiwilampe', waral k'o wi ri Are' pa ri juyub' ri kätz'inowik,” mixe' che rilik. We käb'ix chiwe: “Chiwilampe', waral k'o wi pa ja,” mikojo, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Je' jas kub'an ri kaypa' ri kärepq'un cho ri kaj chrelb'al q'ij käq'alajin k'ä chuqajb'al q'ij, are je ri' ri nu petik in, in ri' ri Ralk'ual ri Dios ri Qas Winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Jawije' k'u k'o wi ri käminaq, chila' käkimulij wi na kib' ri k'uch, —xcha ri Jesús chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Xaq xuwi k'u kok'ow ri nimalaj k'äx ri', ri q'ij käq'equmar na, ri ik' man kätunun tä chik, ketzaq k'u na loq ri ch'imil cho ri kaj. Keslab'isax k'u na konojel ri k'o ki chuq'ab' ri e k'o cho ri kaj je' jas ri q'ij, ri ik', ri ch'imil xuquje' nik'iaj chik. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Te k'u ri' kilitaj na cho ri kaj ri retal ri nu petb'al in, in ri' ri Ralk'ual ri Dios ri Qas Winaq. Keb'oq' k'u na ri winaq pa konojel tinimit cho ruwächulew. Kinkil k'u na in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, in petinaq pa taq ri sutz' cho ri kaj ruk' nimalaj chuq'ab', känimarisax k'u na nu q'ij. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Keintaq k'u na b'i ri nu ángeles, rech ruk' ru ch'ab'al ri trompeta ri sib'alaj ko kätataj na pa ronojel ruwächulew, keb'e' k'u che ki mulixik konojel ri e cha'tal rumal ri Dios pa ri relb'al q'ij, pa ri u qajb'al q'ij, pa ri u mox ri relb'al q'ij, pa ri uwikiäq'ab' ri relb'al q'ij, pa ronojel ruwächulew, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Chich'ob'o b'a' ri k'utb'al chrij ru che'al higos: Aretaq keräxar ru q'ab', ketuxin k'u ru xaq, iwetam ri' chi xaq jub'iq' chik man kopan ri q'alaj. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Je ri' xuquje' ri ix aretaq kiwilo chi tajin käk'ulmataj ronojel wa', chiwetamaj chi xaq jub'iq' chik man kopan ri q'ij ri kinpetik. Je' ta ne chi in k'o chi' ri uchib'e. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Qas tzij ri kinb'ij chiwe chi keb'antaj na ronojel wa' k'ä mäjoq kekäm ri winaq re we q'ij junab' ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Käsach na u wäch ri kaj xuquje' ruwächulew, are k'u ri tzij ri nu b'im chiwe keb'antaj na wa', man käsach tä ki wäch, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Man k'o tä k'u jachin jun retam jampa' kopan ri q'ij ri', man etamtal tä k'u ri hora. Man ketam tä ri ángeles chila' chikaj, man retam tä k'u ru K'ojol ri Dios, xane xaq xuwi ri qa Tat Dios retam wa', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Jas ri xk'ulmataj pa ru q'ijol ri qa mam Noé ojer, are je' käk'ulmataj na aretaq ri in kinpetik, in ri' ri Ralk'ual ri Dios ri Qas Winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Pa taq ri q'ij ri', k'ä mäjoq xqaj ri nimalaj q'eqal jäb', ri winaq xaq xuwi xkilij ri wi'm, ru tijik taq vino. Xek'uli'k, xkiya ri kalk'ual che k'ulanem. Je wa' xka'n ronojel q'ij k'ä xok na ri qa mam Noé pa ri arca. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Man xeb'ok tä il k'ä xqaj na ri q'eqal jäb' pa ki wi', xekäm k'u konojel. Je ri' xuquje' käk'ulmataj na aretaq kinpe in, in ri' ri Ralk'ual ri Dios ri Qas Winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Pa ri q'ij ri' kek'oji na kieb' achijab' ri tajin kechakun pa juyub'. Jun chke käk'am na b'ik, are k'u ri jun chik käyi' na kanoq. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Pa ri q'ij ri' kek'oji na kieb' ixoqib' ri tajin keke'nik. Ri jun käk'am na b'ik, are k'u ri jun chik käyi' na kanoq. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Chiwila b'a' iwib', chixk'ask'atoq, rumal chi man iwetam taj jachike hora ri käpe ri Iwajaw, ru K'ojol ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mäsach b'a' chiwe ri kinb'ij chanim ri': We ta jun rajaw ja retam jas hora kopan ri elaq'om chaq'ab', man käwar tä na ri', xane käk'asi na. Man kuya tä ri' chi ri elaq'om kok b'i pa ri rachoch che relaq'axik b'i ri jastaq re. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Rumal ri' chib'ana u b'anik iwib', xaq chixeyenoq. Aretaq k'ut man kichomaj taj chi kinpetik, kinpe na in, in ri' ri Ralk'ual ri Dios ri Qas Winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Qachomajmpe' jas ri kub'an jun patrón, ri k'o jun patänil re ri jikom ranima', ri k'o u no'j, kukoj k'u kan che ki chajixik konojel ri e k'o pa rachoch rech kuya ri ki wa konojel ri rajchakib' ronojel q'ij. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Utz re ri patäninel ri' we tajin kub'ano jas ri xtaq wi kanoq aretaq kätzelej loq ru patrón. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Qas tzij ri kinb'ij chiwe, chi ri patrón kukoj na ri patäninel ri' che chajil re konojel ri jastaq re. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","We k'u ri patäninel man utzalaj achi taj, kuchomaj k'u ri are' chi ru patrón man kätzelej tä loq chanim, ");
INSERT INTO qucNNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","kuchaplej u b'anik k'äx chke ri nik'iaj ajchakib', kuchaplej wi'm, kuchaplej u tijik ja' kuk' ri q'ab'arelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Te'talik ri patrón kätzelej loq pa ri q'ij ri man retam tä ri patäninel, pa ri hora ri man kuchomaj taj. ");
INSERT INTO qucNNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Sib'alaj k'äx k'u ri k'äjisab'al u wäch kuya na ri patrón, junam u k'äjisaxik u wäch kub'an na kuk' ri winaq ri xaq kieb' ki wäch. Kutij k'u na oq'ej kuk', kuquch'uch'ej na ru ware, —xcha ri Jesús chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ru taqanik ri Dios pa ki wi' ri winaq kinjunamaj ruk' ri lajuj alitomab' ri xeb'e' cho rachoch ri ali ri käk'uli'k che reyexik ri novio. Chkijujunal k'ut xkik'am b'i ri ki lámparas. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","E job' chke ri alitomab' e saq'orib', are k'u ri job' chik e sak'aj. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ri alitomab' ri e saq'orib' xkik'am b'i ri ki lámparas, man xkik'am tä k'u b'i nik'iaj aceite chik rech käkiya chkipam. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Are k'u ri alitomab' ri e sak'aj xkik'am b'i ri ki lámparas xuquje' xkik'am b'i ri ki leme't re aceite. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Xb'eytaj k'u ri novio. Ri lajuj alitomab' konojel xkichaplej yuxk'atem, xewar k'ut. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Pa nik'iaj aq'ab' k'ut xtataj jun ri ko xch'awik, xub'ij k'ut: “¡Chiwilampe', xpe ri novio, chixel loq chuk'ulaxik!” —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Xewalij k'u konojel ri alitomab', xkib'an u b'anik ri ki lámparas. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Are k'u ri alitomab' ri e saq'orib' xkib'ij chke ri alitomab' ri e sak'aj: “Chiya jub'iq' qe ri iwaceite rech man kechup tä ri qa lámparas uj,” —xecha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ri alitomab' ri e sak'aj xech'awik, xkib'ij: “Man kuya' taj, rumal chi man kub'ana tä ne ri qech uj we käqaya ri iwe ix. Are utz xa kiloq'o loq ri iwe pa ri k'ayib'al,” —xecha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","E b'enaq k'u ri job' alitomab' ri e saq'orib' chuloq'ik ri aceite aretaq xopan kan ri novio. Ri job' alitomab' ri kuk'am kaceite xeb'ok ruk' ri novio pa ri nimaq'ij re ri k'ulanem. Xtz'apix k'u ri uchija. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Xetzelej k'u loq ri job' alitomab' chik ri xeb'e' chuloq'ik ri kaceite, xkib'ij k'ut: “¡Tat, tat, jaqa la ri uchija chqawäch!” —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ri are' k'ut xub'ij chke: “Qas tzij kinb'ij chiwe chi man wetam tä i wäch,” —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Xub'ij k'u ri Jesús chke ru tijoxelab': Chiwila b'a' iwib' ix, chixk'ask'atoq, rumal chi man iwetam taj jachike q'ij, jachike hora kinpe in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ru taqanik ri Dios pa ki wi' ri winaq kinjunamaj ruk' jun achi ri ke' pa b'inem. Ri achi ri', aretaq xaq jub'iq' kraj chi kel b'ik rech ke' pa jun tinimit chik, xeusik'ij ri patänil taq re, xujach k'u kan ru rajil chkiwäch rech kechakun ruk'. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Xuya chke chkijujunal jas ri kekowinik chukojik. Xuya job' mil quetzal che ri jun, che ri jun chik xuya kieb' mil quetzal, che ri jun chik xuya mil quetzal. Te ri' ri achi xe' pa ru b'inem. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ri patäninel ri xuk'am job' mil quetzal xe'k, xchakun ruk' ri puaq. Je ri' xuch'ak chi job' mil quetzal chik. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Xuquje' ri patäninel ri xuk'am kieb' mil quetzal je' xub'ano, xuch'ak chi kieb' mil quetzal chik. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Are k'u ri patäninel ri xuk'am xa mil quetzal xe'k, xuk'u' ru rajil ru patrón, xumuq pa ri ulew. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Xke' k'u k'ia q'ij, xtzelej loq ri ki patrón ri patäninelab', xuchap k'u u b'anik kuenta kuk' chrij ru rajil. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nab'e xopan ri u k'amom job' mil quetzal, xujach k'u che ru patrón ri job' mil quetzal chik ru ch'akom, xub'ij che: “Tat, job' mil quetzal xya la chwe, kämik ri' kinjach che la ri job' mil quetzal chik ri xinch'ako,” —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ri patrón xub'ij che: “Ri at, at utzalaj patäninel ri jikom awanima'. Rumal chi jikom awanima' ruk' ri jub'iq' ri xinya chawe, nim k'u na ri kinya chi na chawe. Chatok b'a' loq, chatkikot junam wuk',” —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Xopan chi k'u ri patäninel ru k'amom kieb' mil quetzal, xub'ij che ru patrón: “Tat, kieb' mil quetzal xya la chwe, kämik ri' kinjach che la ri kieb' mil chik ri xinch'ako,” —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ri patrón xub'ij che: “Ri at xuquje' at utzalaj patäninel ri jikom awanima'. Rumal chi jikom awanima' ruk' ri jub'iq' ri xinya chawe, nim k'u na ri kinya chawe, chatok b'a' loq, chatkikot junam wuk',” —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Aretaq k'ut xopan ri patäninel ri u k'amom xa mil quetzal, xub'ij che ru patrón: “Tat, ri in wetam chi sib'alaj lal k'a'n, chi käyak la u wäch ri ulew ri man xtikonij tä wi la, kämol la ri man xjopin tä wi la. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Rumal ri' xinxej wib', xine' k'ut, xink'u' ri rajil la, xinmuq pulew. Kinjach k'u we rajil la ri',” —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Xub'ij k'u ri patrón che: “Ri at, at itzelalaj patäninel ri xa kasaq'orij ra chak. Kak'ey u ch'akik ri puaq. Ri at awetam chi kinyak u wäch ri ulew ri man kintikonij tä wi, xuquje' kinmol ri man xinjopij taj. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","We je ri', xaya ta k'u ri nu rajil pa ri banco. We ta je ri' xab'ano, aretaq xintzelej loq xink'am ta ri' ri nu rajil ruk' ri ral,” —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ri patrón xub'ij chke ri nik'iaj ajchakib' chik ri e k'o chila': “Chik'ama b'a' ri mil quetzal che, chiya che ri jun ri k'o lajuj mil quetzal ruk',” —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","“Je ri', rumal chi jachin ri k'ia k'o ruk' käyi' na nik'iaj chik che, kok'ow k'u na u wi' ri k'o ruk'. Are k'u ri jun ri man k'ia tä k'o ruk', kesax na ri jub'iq' ri k'o ruk',” —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","“Are k'u we patäninel ri' ri man k'o tä xuch'ak chrij ri rajil ri xyi' che, jik'iäqa kan chrij ja pa ri q'equm. Chila' k'ut koq' wi na, chila' kuquch'uch'ej wi na ru ware,” —xcha ri Jesús chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Aretaq kinpe na in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, ya jun Nim Taqanel chik kinpetik. Konojel ri ángeles kepe na che wachi'l, kint'uyi k'u na pa ri je'lalaj nu t'uyulib'al ri sib'alaj nim u q'ij. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ri winaq re konojel taq ri tinimit cho ruwächulew käkimulij na kib' chnuwäch, keincha' k'u na ri jikom ki k'aslemal chkixol ri man jikom taj. Je' kinb'an na jas ri kub'an ri ajyuq' keucha' ri u chij chkixol ri k'isik'. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Keinya na ri chij pa ri nu wikiäq'ab', are k'u ri k'isik' pa nu moxq'ab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Te ri' ri in, in ri' ri Nim Taqanel, kinb'ij na chke ri e k'o pa nu wikiäq'ab': “Chixsa'j ix, ri ix tewchital rumal ri nu Tat. Chixok chila' jawije' ri kätaqan wi ri Dios, ri u chomam chi k'u loq wa' tzaretaq xub'an ri kajulew chi kuya chiwe. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Rumal chi aretaq xinnumik, xiya nu wa, aretaq xchaqi'j nu chi', xiya jas kintijo, aretaq xinwonokatik, xinik'ulaj cho taq iwachoch. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Aretaq man k'o tä chi watz'iaq, ri ix xiya ri watz'iaq, aretaq xinyawajik, xixopan wuk', aretaq xinok pa che', xixe' che wilik,” —kincha na chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ri winaq ri jikom kanima' chuwäch ri Dios käkib'ij na chwe: “Tat, ¿jampa' k'u ri xqilo chi känum la, te k'u ri' xqaya wa la? ¿Jampa' xqilo chi kächaqi'j chi' la, te k'u ri' xqaya jas ri kätij la? ");
INSERT INTO qucNNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Jampa' ta k'u xqilo chi xaq käwonokat la, xqak'ulaj ta k'u la pa ri qachoch? ¿Jampa' xqilo chi man k'o tä atz'iaq la, xqaya k'ut? ");
INSERT INTO qucNNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Jampa' ta k'u xqilo chi lal yawab' o k'o la pa che', te k'u ri' xujopan uk' la che rilik jas b'anom la?” —kecha na. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ri in, in ri' ri Nim Taqanel, kinb'ij na chke: “Qas tzij kinb'ij chiwe, chi apachike utzil ri xib'an che apachin chke ri wachalal pune man nim u b'anik, chwe in ri' xib'an wi wa',” —kincha na chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Kinb'ij k'u na chke ri winaq ri e k'o pa nu moxq'ab': “Chixel chnuwäch, ix ri q'atom tzij pi wi' chi käk'äjisax i wäch. Jix pa ri q'aq' ri man kächuptaj taj ri b'anom u b'anik rech chila' kek'ol wi ri Itzel e rachi'l ru ángeles. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Rumal chi aretaq xinnumik, man xiya tä nu wa, aretaq xchaqi'j nu chi', man xiya tä chwe jas kintijo. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Aretaq xaq xinwonokatik, man xinik'ulaj tä cho taq iwachoch. Aretaq man k'o tä chi watz'iaq, man k'o tä ri xiya chwe. Aretaq xinyawajik, aretaq xinok pa che', man xixopan tä che wilik,” —kincha na chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Käkib'ij k'u na chwe: “Tat, ¿jampa' ta k'u lo xqilo chi känum la, jampa' xqilo chi kächaqi'j chi' la, jampa' xqilo chi xaq käwonokat la, jampa' xqilo chi man k'o tä atz'iaq la, jampa' xqilo chi xyawaj la o xok la pa che', te k'u ri' man xujtob' tä che la?” —kecha na chwe. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ri in, in ri' ri Nim Taqanel, kinch'awik, kinb'ij na chke: “Qas tzij kinb'ij chiwe chi apachike utzil ri man xib'an tä che apachin jun winaq, pune man nim u b'anik, chwe in ri' man xib'an tä wi,” —kincha na chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ri winaq ri' keb'e' na chila' jawije' ri man kätäni tä wi ru k'äjisaxik ki wäch. Are k'u ri winaq ri jikom kanima' cho ri Dios keb'e' na chila' jawije' ri k'o wi ri k'aslemal ri man k'o tä u k'isik, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Aretaq xto'taj ri Jesús chub'ixik ronojel wa' we tzij ri', xub'ij chke ru tijoxelab': ");
INSERT INTO qucNNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Ri ix iwetam chi xa pa kieb' q'ij käb'an na ri nimaq'ij, Pascua u b'i'. Ri in k'ut, in ri' ri Ralk'ual ri Dios ri Qas Winaq, kinjach na pa ki q'ab' ri nu k'ulel, rech kinrip cho ri cruz, kinkämisax na, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Xkimulij k'u kib' ri ki nimaqil sacerdotes, ri tijonelab' re ri Pixab' xuquje' ri ki nimal ri winaq aj Israel cho ri nimalaj ja rech ri tat Caifás ri ki nimal sacerdotes. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Chila' xkitala ki no'j chb'il taq kib' jas käka'n na chuchapik ri Jesús ruk' sub'unik rech käkikämisaj. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Xkib'ij k'ut: Mächap pa ri nimaq'ij, rech metukin ne ri winaq, —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Are k'u ri Jesús k'o pa ri tinimit Betania cho rachoch ri tat Simón, jun tata' ri xk'oji na itzel ch'a'k che. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Xopan jun ixoq ri ruk'am jun k'olib'al kunab'al re alabastro ri nojinaq che k'ok'alaj kunab'al. Sib'alaj paqal rajil wa' we kunab'al ri'. T'uyul k'u ri Jesús chi' ri mesa, ri ixoq xuq'ij ri aceite pu jolom ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Aretaq ri tijoxelab' xkil wa', xpe koyowal, xkib'ij k'u chb'il taq kib': ¿Jas che xaq xtix wa' we kunab'al ri'? —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Xk'iyix ta ne wa', xtoj ta nimalaj rajil, xyi' ta k'u ri puaq chke ri meb'a'ib', —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Xuta k'u ri Jesús ri käkib'ij, xub'ij chke: ¿Jas che kiya latz' che ri ixoq ri'? Jun nimalaj utzil k'u wa' ru b'anom chwe, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Amaq'el ronojel q'ij k'ut e k'o ri meb'a'ib' iwuk', are k'u ri in man in k'o tä iwuk' amaq'el. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ri xub'an ri ixoq aretaq xuq'ij ri k'ok'alaj aceite chwij, xa xukoj k'u b'i ri k'ok'alaj kunab'al chrij ri nu cuerpo k'ä mäjoq kinmuqik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Qas k'u tzij ri kinb'ij chiwe chi apawije' ta ne ri kätzijox wi na ri Utzalaj Tzij re ri Evangelio cho ronojel ruwächulew, ru b'anom we ixoq ri' kätzijox na che na'tab'al re, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Te k'u ri' jun chke ri kab'lajuj tijoxelab', ri u b'i' Judas Iscariote, xel b'ik, xe' kuk' ri ki nimaqil ri sacerdotes. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Xub'ij k'u chke: ¿Jas käya alaq chwe, we kinjach ri Jesús pa q'ab' alaq? —xcha chke. Ri e are' k'ut xkiya juwinaq lajuj raqan saq puaq che ri tat Judas. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tzare chi' k'ut ri tat Judas xutzukuj jun utzalaj q'ij rech kujach ri Jesús pa ki q'ab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pa ri nab'e q'ij re ri nimaq'ij aretaq kätijow ri kaxlan wa ri man käyi' tä ch'äm ruk', ru tijoxelab' ri Jesús xeqeb' ruk', xkib'ij che: ¿Jawije' kaj wi la chi käqa'n wi ri wi'm re ri Pascua rech kätij la? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ri Jesús xub'ij chke: Jix pa ri tinimit cho rachoch ri jun achi, chib'ij k'u che: “Kuta' ri Qajtij che la, kub'ij: Ya xopan ri hora. Cho achoch k'u la kinb'an na u b'anik wi ri nimaq'ij re ri Pascua kuk' ri nu tijoxelab',” —kächa ri', —kixcha che, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ri tijoxelab' xka'no jas ri xetaq wi rumal ri Jesús. Xka'n k'u u b'anik ri wi'm re ri Pascua chila'. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Aretaq chaq'ab' chik, ri Jesús xt'uyi chi' ri mesa kuk' ri kab'lajuj u tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","E t'uyul chila' chi' ri mesa, tajin kewi'k aretaq ri Jesús xub'ij chke: Qas tzij ri kinb'ij chiwe chi k'o jun chiwe ri kinujach na, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ru tijoxelab' sib'alaj xeb'isonik. Chkijujunal k'ut xkichaplej u ta'ik che ri Jesús: Qajaw, ¿a man xa in ri'? —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ri Jesús xch'awik, xub'ij chke: Are ri jun ri kurub' ru wa wuk' pa ri laq, are k'u ri' ri kinjachow na, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Je' k'u kel na jas ri tz'ib'tal pa ru Loq' Pixab' ri Dios chwij in, in ri' ri Ralk'ual ri Dios ri Qas Winaq. ¡K'äx k'u ri kuriq na ri achi ri kinjachow na! ¡Utz na re we achi ri' we ta mat xil u wäch! —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Xch'aw k'u ri Judas ri tijoxel ri käjachow na, xub'ij che ri Jesús: We ne in, Ajtij, —xcha che. Xub'ij ri Jesús che: Je', at ri', —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Aretaq tajin kewi'k, ri Jesús xuk'am ri kaxlan wa, xub'an orar, xumaltioxij wa' che ri Dios. Te k'u ri' xupiro, xuya chkiwäch ru tijoxelab', xub'ij: Chitija iwe wa', je' ta ne chi are nu cuerpo wa', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Te k'u ri' xuk'am jun vaso, xumaltioxij wa' che ri Dios, te ri' xuya chkiwäch ru tijoxelab', xub'ij chke: Chitija iwe iwonojel. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Je' ta ne chi are nu kik'el wa' ri kujikib'a ri k'ak' trato ru b'anom ri Dios kuk' ri winaq. Käturuw k'u na wa' ri nu kik'el che sachb'al ki mak k'ia winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Qas tzij ri kinb'ij chiwe chi man k'o tä jumul kintij chi na we ri vino re uvas, k'ä pa ri q'ij ri kintij na ri k'ak' vino junam iwuk' chila' jawije' ri kätaqan wi ri nu Tat, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Te k'u ri' xkib'ixoj jun b'ix ri kuya u q'ij ri Dios, xeb'el b'i chila', xeb'e' pa ri Ujuyub'al Olivos. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Xub'ij k'u ri Jesús chke: Ri ix iwonojel kib'isoj na nu wäch, kiniya na kan nu tukiel kämik chaq'ab'. Je k'u tz'ib'tal kan pa ru Loq' Pixab' ri Dios: “Kinkämisaj na ri ajyuq', kejab'un k'u na ri chij,” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Aretaq k'u ri in, in k'astajinaq chik chkixol ri käminaqib', kinnab'ej na b'i chiwäch, kine' na pa Galilea, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Xub'ij k'u ri tat Pedro che ri Jesús: Pune konojel käyi' la kan kumal, ri in man je' tä ri' kinb'ano, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Xub'ij k'u ri Jesús che: Qas tzij ri kinb'ij chawe chi tzpa we aq'ab' ri' kämik, kab'ij na at oxmul chi man awetam tä nu wäch mäjoq koq' ri ama' ek', —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ri tat Pedro xub'ij che: Pune rajwaxik chi kinkäm na uk' la, man k'o tä na jumul kinb'ij chi man wetam tä wäch la, —xcha che. Je k'u xkib'ij xuquje' konojel ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Xopan k'u ri Jesús pa ri ch'äqap ulew u b'i' Getsemaní e rachi'l ru tijoxelab', xub'ij k'u chke: Chixt'uyul kan waral. Ri in k'ut kine' na jela' chub'anik orar, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Xuk'am b'i ri tat Pedro ruk' xuquje' ri kieb' u k'ojol ri tat Zebedeo. Xuchaplej k'u t'ujuwem ri Jesús, xk'äxk'ob' ri ranima'. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Xub'ij k'u chke: Sib'alaj kuk'is rib' ri wanima' chupam ri b'is. Chixkanaj kan chi', chixk'ask'at wuk', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Te ri' xb'in chi apan jub'iq' ri Jesús, xxuki'k, xuya ru palaj cho ri ulew, xub'an orar, xub'ij: Tat, we kuya', chesaj b'a' la we vaso ri' chnuwäch, b'ana la chi man käpe tä ri k'äx ri' chwij. Mäb'an b'a' xa jas ri nu rayib'al in, xane jas ri rayib'al la, —xcha che ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Xtzelej k'u ri Jesús jawije' e k'o wi ru tijoxelab', xeuriqa tajin kewarik. Xub'ij k'u che ri tat Pedro: ¿A mat xixkowinik xixk'asi ta jun hora wuk'? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Chiwila b'a' iwib', chixk'ask'atoq, chib'ana orar rech man kixtzaq taj aretaq kixtaqchi'x che mak. Qas tzij pa ri iwanima' kiwaj kib'an ri utzil, man k'o tä k'u u chuq'ab' ri i cuerpo chub'anik wa', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Xe' chi jumul ri Jesús chub'anik orar, je' xub'ij wa': ¡Tat! We b'a' tzrajwaxik wi chi käpe ri k'äx ri' chwij, b'ana b'a' la chwe jas ri rayib'al la, —xcha che ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Te k'u ri' xtzelej chik, xeuriqa ru tijoxelab' jumul chik tajin kewarik rumal chi sib'alaj k'äx ki waram. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Xeuya kanoq, xe' chi jumul ri Jesús chub'anik orar churoxmul, je k'u xub'ij jas ri xub'ij nab'e. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Te k'u ri' xe' jela' jawije' e k'o wi ru tijoxelab', xub'ij chke: Chixwar b'a', chixuxlanoq. Xopan ri hora. Kinjach k'u na in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, pa ki q'ab' ri ajmakib', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Jo' b'a'! ¡Chixwalijoq! Chiwilampe', xpe ri jachal we, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","K'ä tajin käch'aw ri Jesús aretaq xopan ri tat Judas, jun chke ri kab'lajuj u tijoxelab'. E petinaq ruk' ri are' k'ia winaq ri kuk'am machetes, kuk'am che'. E taqom loq kumal ri ki nimaqil sacerdotes, xuquje' kumal ri ki nimaqil ri winaq aj Israel. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ri tat Judas ri jachal re ri Jesús u yo'm k'u kan jun etal chke ri winaq, xub'ij: “Ri kintz'umaj, are ri' ri Jesús. Chichapa', qas utz chib'ana b'i chuk'amik,” —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Xqeb' k'u ri tat Judas ruk' ri Jesús, xub'ij che: ¡Xok aq'ab', Ajtij! —xcha che. Te k'u ri' xutz'umaj. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ri Jesús xch'awik, xub'ij che: Wachi'l, ¿jas a tajkil xatpetik? —xcha che. Xeqeb' k'u ri winaq ruk' ri Jesús, xkichapo, xkiyut b'ik. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Aretaq je' xb'anik, jun chke ri e rachi'l ri Jesús xuk'am ru machete, xusok ri patänil re ri ki nimal sacerdotes, xuq'at apan ru xikin. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Xub'ij k'u ri Jesús che: Chaya ri a machete pa ri k'olib'al re. Konojel k'u ri kech'ayan ruk' machete, ruk' machete kekämisax na, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿A mat awetam chi kinkowinik kinta' apan che ri nu Tat chi kinuto', chi ri Are' kutaq na loq chanim oxk'al lajuj mil ángeles che nu to'ik? ");
INSERT INTO qucNNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","We ta k'u je ri', man je' tä kel wi ri' ri tz'ib'tal pa ru Loq' Pixab' ri Dios, chi rajwaxik käb'antaj na wa' we ri', —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Xub'ij k'u ri Jesús chke ri winaq: ¿Jas lo wa' chi je' ta ne chrij jun elaq'om elinaq wi loq alaq? ¿A k'amom alaq loq ri machete alaq, ri che' alaq che nu chapik? —xcha chke. Ronojel q'ij xink'oji uk' alaq pa ri nimalaj rachoch Dios, xinya ri tijonik chech alaq, man xinchap tä k'u alaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Je k'u käb'an na wa' chwe, rech je' käb'antaj na jas ri tz'ib'am kan chwij kumal ri q'alajisal taq re ru Loq' Pixab' ri Dios, —xcha chke. Chanim k'ut konojel ri tijoxelab' xkiya kan ri Jesús u tukiel, xeanimaj b'ik. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ri winaq ri xechapow ri Jesús xkik'am b'i chuwäch ri tat Caifás, ri qas ki nimal ri sacerdotes. Chila' k'ut ki mulim wi kib' ri tijonelab' re ri Pixab', xuquje' ri ki nimaqil ri winaq aj Israel. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Are k'u ri tat Pedro xuterenej b'i ri Jesús chi naj, xopan pa ri uwoja rech ri rachoch ri qas ki nimal sacerdotes. Xok b'i ri tat Pedro, xt'uyi k'u ri are' chila' kuk' ri chajil taq re ri nimalaj rachoch Dios rech kärilo jas ri käk'ulmataj na ruk' ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ri ki nimaqil sacerdotes, ri ki nimaqil ri winaq aj Israel, xuquje' konojel ri k'amal taq ki b'e ri winaq, tajin käkitzukuj jas u wäch mak ri käq'alajisax chrij ri Jesús, pune man qas tzij taj, rech käq'at tzij puwi' chi käkämisaxik. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Man xkiriq tä k'ut, pune e k'ia winaq xkimulij kib', xkib'ij ri man qas tzij taj chrij ri Jesús. K'isb'al re k'ut xepe kieb' achijab' chik ri xkiq'alajisaj ri man qas tzij taj chrij ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Xkib'ij: We achi ri' kub'ij: “Ri in kinkowinik kinwulij ri nimalaj rachoch Dios, kinyak chi k'u na pa oxib' q'ij,” —kächa', —xecha ri achijab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Xwalij k'u ri qas ki nimal sacerdotes, xuta' che ri Jesús, xub'ij che: ¿A mat k'o jas jun tzij kab'ij chutzelexik u wäch ri tajin käb'ix chawij? ¿Jas pu wa' ri tajin käkiq'alajisaj we achijab' ri' chawij? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Man xch'aw tä k'u ri Jesús. Xub'ij k'u ri ki nimal sacerdotes che: Pa ru b'i' ri k'aslik Dios, kinb'ij chawe chi chab'ana juramento chub'ixik ri qas tzij. Chab'ij chqe we at ri' ri Cristo ri u K'ojol ri Dios, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Xch'aw k'u ri Jesús, xub'ij che: In ri', tat, jas ri käb'ij la, —xcha che. Kinb'ij k'u in chech alaq, chi kinil na alaq ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, aretaq in t'uyul pa ru wikiäq'ab' ri Dios ri sib'alaj k'o u chuq'ab', aretaq kinpe pa taq ri sutz' ajchikaj, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Are k'u ri qas ki nimal sacerdotes xuraq'atij ri ratz'iaq chuk'utik chi sib'alaj k'äx xuna' ri xub'ij ri Jesús. Xub'ij k'u ri tata': We achi ri' u b'im ri äwas u b'ixik chrij ri Dios. ¿Jas ta ne che e rajwaxik chi nik'iaj q'alajisanelab' chik chrij? I tom k'u ix chi u b'im ri äwas u b'ixik chrij ri Dios, —xcha chke ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Jas k'u kichomaj? Ri e are' xkib'ij: K'o u mak, rajwaxik k'ut chi käkämisaxik, —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Xkichub'aj u palaj ri Jesús, xkit'oko. Nik'iaj chik xkikoj q'ab' chupalaj. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Xkib'ij k'u che: At ri' ri Cristo, ¡chach'ob'o ne jachin ri xatch'ayowik! —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Are k'u ri tat Pedro t'uyul kan cho ja. Xopan k'u jun ali ajik' ruk', xub'ij che: Ri at xuquje' xatk'oji ruk' ri Jesús ri aj Galilea, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Are k'u ri tat Pedro xresaj rib' chupam chkiwäch konojel, xub'ij: Man kinch'ob' taj jas ri tajin kab'ij, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ri tat Pedro qas raj kel b'i chuchi' ri ja, aretaq xilitaj chi rumal jun ajik' chik, ri ajik' xub'ij chke ri e k'o chila': We achi ri' xuquje' xk'oji ruk' ri Jesús ri aj Nazaret, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Jumul chik ri tat Pedro xresaj rib' chupam, xub'an jurar, xub'ij: Ri in man wetam tä u wäch ri achi ri', —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Man naj tä k'u ri' ri winaq ri e k'o chila' xeopan ruk' ri tat Pedro, xkib'ij che: Qas tzij ri at, at jun kuk' ri e rachi'l ri Jesús, rumal chi junam katch'awik jas ri winaq aj Galilea, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ko k'u xch'aw ri tat Pedro, xub'an jurar cho ri Dios, xub'ij: Man wetam tä u wäch ri achi ri', —xcha chke. Are chi' k'ut xoq' jun ama' ek'. ");
INSERT INTO qucNNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Xna'taj k'u che ri tat Pedro ru b'im ri Jesús che: “Ri at kab'ij na oxmul chi man awetam tä nu wäch, mäjoq koq' ri ama' ek',” —xcha che. Xel k'u b'i ri tat Pedro, sib'alaj xuk'is rib' che oq'ej. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Aretaq xsaqirik, konojel ri ki nimaqil ri sacerdotes, xuquje' ri ki nimaqil ri winaq aj Israel xkitala ki no'j, xkichomaj jas käka'n chukämisaxik ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Xkiyut k'u b'i ri Jesús, xkik'am b'ik, xekijacha pu q'ab' ri tat Poncio Pilato ri q'atal tzij. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Aretaq k'ut ri tat Judas, ri jachal re ri Jesús, xrilo chi xq'at tzij puwi' ri Jesús chi käkämisaxik, xuna' k'äx pa ri ranima'. Xutzelej ri juwinaq lajuj raqan saq puaq chke ri ki nimaqil ri sacerdotes xuquje' ri ki nimaqil ri winaq aj Israel. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Xub'ij chke: Xinmakun cho ri Dios rumal chi xinjach pa q'ab' alaq jun achi ri man k'o tä u mak rech käkämisaj alaq, —xcha chke. Ri e are' k'ut xkib'ij che ri tat Judas: ¿Jas qe uj che? ¡At chatilowoq! —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Are k'u ri tat Judas xuk'iäq kan ri puaq pa ri nimalaj rachoch Dios, xel b'ik, xe'k, xujitz'aj rib'. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ri ki nimaqil ri sacerdotes xkisik' ri puaq, xkib'ij: Man kuya' taj käqaya wa' we puaq ri' pa ri k'olib'al kuchuj, rumal chi rajil kik' wa', —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Xkichomaj k'ut chi ruk' wa' we puaq ri' käkiloq' ri ulew ri käb'ix Rulew ri B'anal B'o'j che, rech k'o jun ulew ri kemuq wi ri winaq ri man e aj Israel taj. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Rumal ri', k'ä kämik, ri ulew ri' käb'ix Ulew re Kik' che. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Je ri' xb'antajik jas ri xub'ij kan ri qa mam Jeremías ri q'alajisal re ru Loq' Pixab' ri Dios: “Xkik'am ri juwinaq lajuj raqan saq puaq (ri rajil jun achi ri chomam kumal ri winaq aj Israel). ");
INSERT INTO qucNNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ruk' wa' xkiloq' ri rulew ri b'anal b'o'j. Are wa' ri in u taqom wi ri Qajaw Dios,” —xcha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Xk'am k'u b'i ri Jesús, xekijacha cho ri tat Pilato ri q'atal tzij. Xuta' k'u ri Pilato che, xub'ij: ¿A at ri' ri kattaqan pa ki wi' ri winaq aj Israel? —xcha che. Ri Jesús xub'ij che: Je ri' jas ri käb'ij la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","K'ia tzij k'ut xka'n ri ki nimaqil ri sacerdotes chrij ri Jesús, xuquje' ri ki nimaqil ri winaq aj Israel. Are k'u ri Jesús man k'o tä jas xub'ij. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Xub'ij k'u ri tat Pilato che: ¿A mat kata ri tajin käb'ix chawij? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Man k'o tä k'u jun tzij xub'ij ri Jesús, je ri' chi xukajmaj wa' ri tat Pilato. Man kuriq tä k'u ri are' jas kub'ano. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Are k'u ri tat Pilato ri q'atal tzij naq'atalik chi pa ri nimaq'ij kub'an jun toq'ob' chke ri winaq, kutzoqopij b'i jun ajpache', apachin ta ne ri kächa' kumal ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","K'o k'u jun ajpache', Barrabás u b'i', ri etamtalik chi are jun itzel achi. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Aretaq k'ut ki mulim chi kib' ri winaq, ri tat Pilato xuta' chke: ¿Jachin ri kiwaj chi kintzoqopij b'ik? ¿A are kintzoqopij b'i ri tat Barrabás o are kintzoqopij b'i ri Jesús ri käb'ix Cristo che? —xcha chke ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kuch'ob' k'u ri tat Pilato chi xa rumal chi k'äx käkina' che ri Jesús, rumal ri' ki jachom pu q'ab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","T'uyul k'u ri tat Pilato pa ri q'atb'al tzij, aretaq ri rixoqil xtaqan chub'ixik che: “K'o jas mab'an che we achi ri' ri man k'o tä u mak. Xinwachik'aj k'u jun jasach ri sib'alaj xib'ib'al chaq'ab' rumal we achi ri',” —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Are k'u ri ki nimaqil ri sacerdotes xuquje' ri ki nimaqil ri winaq aj Israel xkikoj ki chuq'ab' chub'ixik chke ri winaq chi más utz na käkib'ij chi are kätzoqopix ri tat Barrabás, käkämisax k'u ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ri q'atal tzij k'ut xch'aw chi jumul, xuta' chke ri winaq: ¿Jachin chke ri kieb' achijab' kiwaj chi kintzoqopij b'ik? —xcha chke. Ri winaq xkib'ij: Are kätzoqopij la ri tat Barrabás, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Xuta' k'u ri tat Pilato chke ri winaq: ¿Jas k'u kinb'an che ri Jesús ri käb'ix Cristo che? —xcha chke. Konojel ri winaq xech'awik, xkib'ij: ¡Chripoq! —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Xch'aw k'u ri tat Pilato, xub'ij chke: ¿Jas che? ¿Jas pu etzelal u b'anom wa' we achi ri'? —xcha chke. Ko k'u na xech'aw ri winaq, xkib'ij: ¡Chripoq! —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Aretaq ri tat Pilato xrilo chi man kok tä tzij pa ki jolom ri winaq, xane xa tajin käkitukij kib', xtaqan chuk'amik joron, xuch'aj ru q'ab' chkiwäch ri winaq, te k'u ri' xub'ij: Man k'o tä we in che ru kämikal we achi ri' ri man k'o tä u mak. Chib'ana ix jas ri kiwaj kib'an che, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Konojel k'u ri winaq xech'awik, xkib'ij: ¡Ri uj, xuquje' ri qalk'ual, uj ajchaq' mak che ru kämikal we achi ri'! —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ri tat Pilato xutzoqopij k'u b'i ri tat Barrabás. Xtaqan chuch'ayik ri Jesús, te k'u ri' xujach b'ik rech käripik, käkämisax cho ri cruz. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Te ri' xepe ru soldados ri q'atal tzij, xkik'am b'i ri Jesús pa ri nimalaj ja jawije' konojel ri soldados xkimulij kib' chrij. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Xkesaj ri ratz'iaq ri Jesús, xkikoj jun kiäq q'u' chrij. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Xkikoj jun corona re kemom k'ix chujolom, xkiya jun che' pu q'ab' re uwikiäq'ab', xexuki chuwäch, xkitze'j u wäch, xkib'ij: ¡Nim u q'ij ri Nim Taqanel pa ki wi' ri winaq aj Israel! —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Xechub'an chupalaj ri Jesús, xuquje' xkik'am ri che' pu q'ab', xkiq'osij chujolom. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Aretaq xeto'taj che retz'b'exik u wäch, xkijolij ri kiäq q'u' chrij, xkikoj k'u ri qas ratz'iaq ri Are' chrij. Te k'u ri' xkik'am b'i churipik cho ri cruz. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Elem b'i ke, xkiriq k'u jun achi aj Cirene, Simón u b'i', xkikoj ki chuq'ab' che rech kutelej b'i ru cruz ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Je wa ri' xeopan pa ri juyub' ri käb'ix Gólgota che. We b'i'aj ri' kel kub'ij: Ri Juyub' re ru B'aqil Jolomaj. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Xkiya jun vino che ri Jesús ri yujtal ruk' jun k'a q'ayes ri käb'ix “mirra” che. Aretaq k'ut xuna' ri Jesús, man xraj taj xutijo. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Aretaq ki ripom chik ri Jesús cho ri cruz, ri soldados xkesaj suerte chujachik ri ratz'iaq ri Jesús chkiwäch. Je k'u xb'antajik jas ri xub'ij kan ri q'alajisal re ru Loq' Pixab' ri Dios ojer: “Xkesaj suerte chujachik ri watz'iaq chkiwäch,” —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Te k'u ri' ri soldados xet'uyi chila' chuchajixik ri Are'. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Kojom k'u puwi' ri cruz jun tz'ib'talik ri kub'ij jas che xq'at tzij puwi' ri Jesús rech käripik. Ri tz'ib'talik xub'ij: ARE WA' RI JESÚS, RI NIM TAQANEL PA KI WI' RI WINAQ AJ ISRAEL, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Xuquje' xerip kieb' elaq'omab' ruk'. Jun pu wikiäq'ab', jun pu moxq'ab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ri winaq ri xeok'owik xkiyoq'o, xkisutusa ri ki jolom. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Xkib'ij: At ri' ri kab'ij chi katkowinik kawulij ri nimalaj rachoch Dios, xa k'u pa oxib' q'ij kayak chi na wa' jumul chik, chato' b'a' awib'. We at ri' ru K'ojol ri Dios, chatqaj loq cho ri cruz, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Je' xuquje' ri ki nimaqil ri sacerdotes, ri tijonelab' re ri Pixab', ri tata'ib' fariseos kuk' ri ki nimaqil ri winaq aj Israel, xkitze'j u wäch, xkitzijob'ela kib', xkib'ij: ");
INSERT INTO qucNNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Xtob' chke nik'iaj chik, man käkowin tä k'u ri Are' chuto'ik rib'. We qas are Nim Taqanel kech ri winaq aj Israel, chqaj loq cho ri cruz, rech kujkojon che, —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kub'ij chi u ku'b'am u k'ux chrij ri Dios. We b'a' qas tzij loq' chuwäch ri Dios, ri Are' käto'w ta na chanim ri'. U b'im k'ut chi are u K'ojol ri Dios, —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ri elaq'omab' ri e ripom ruk' ri Jesús, xuquje' xketz'b'ej u wäch. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Xq'equmar k'u ronojel ruwächulew. Xuwi xuchap pa ri nik'iaj q'ij, k'ä te' xok'ow pa ri urox hora b'enaq q'ij. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Qas pa ri hora ri' xuraq u chi' ri Jesús, ko xch'awik, xub'ij: Eloi, Eloi, ¿lama sabactani? —xcha'. Je' kel kub'ij wa': Nu Dios, nu Dios, ¿jas che in wonob'am la kanoq? —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Jujun k'u chke ri e tak'atoj chila' xkita wa', xkib'ij: We achi ri' are tajin kusik'ij ri qa mam Elías ri q'alajisal re ru Loq' Pixab' ri Dios ojer, —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Te k'u ri' jun chke ri winaq xutik anim, xe'k, xuk'ama loq jun estropajo, xurub' chupam ch'äm vino, xuya wa' puwi' jun aj, xuya aq'an che ri Jesús rech kutijo. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Are k'u ri nik'iaj winaq chik xkib'ij: Chiya kanoq, chqila na we ne käpe ri qa mam Elías chuto'ik, —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jumul chik ko xuraq u chi' ri Jesús, xkäm k'ut, xel ranima'. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Are chi' k'ut ri tasb'al u pam ri nimalaj rachoch Dios xjisjob'ik, kieb' xub'ano, xpe ajsik k'ä ikim. Xpe jun käb'raqan, ri nimaq taq ab'aj k'ut xepaxik. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ri ki jul taq ri käminaqib' xejaqjob'ik, e k'ia ri ojer taq winaq ri xekojon che ri Dios, ri e käminaq chik, xek'astaj chkixol ri käminaqib'. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ri e are' xeb'el b'i pa ri ki jul aretaq k'astajinaq chi ri Jesús chkixol ri käminaqib', xeb'ok k'u pa ri loq'alaj tinimit Jerusalén. Chila' k'ut k'ia winaq xeilowik. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Are k'u ri ki nimal soldados aj Roma xuquje' ri soldados ri e k'o ruk' ri ki chajim ri Jesús, aretaq xkina' ri käb'raqan xuquje' xkil ronojel ri xk'ulmatajik, sib'alaj xkixej kib', xkib'ij: ¡Qas tzij, u K'ojol ri Dios wa' we achi ri'! —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","E k'o k'u k'ia ixoqib' chila' ri tajin keka'y apan chinaj. We ixoqib' ri' xeteri ruk' ri Jesús, xepe ruk' pa Galilea, xetob' k'u che. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Chkixol k'u ri e are' k'o ri nan María ri aj Magdala, ri María ru nan ri Jacobo, ri José, xuquje' ri ki nan ru k'ojol ri Zebedeo. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Aretaq okem kub'an ri aq'ab', xpe jun q'inom achi, José u b'i'. Are aj Arimatea, jun u tijoxel k'u ri Jesús wa'. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Xok cho ri tat Pilato, xuta' ru cuerpo ri Jesús che. Xtaqan k'u ri tat Pilato chi käyi' che. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ri tat José xuk'am ru cuerpo ri Jesús, xupis chupam jun saqalaj payu'. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Xuya pa jun k'ak' muqub'al ri rech ri are', ri k'otom koq pa ri ab'aj. Xuwolqotij k'u kan jun ab'aj chuchi' ri muqub'al che tz'apib'al re, te k'u ri' xe'k. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","K'o k'u ri nan María ri aj Magdala chila' rachi'l ri jun María chik. E t'uyul chuwäch ri xmuq wi ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Chukab' q'ij chik, ya ok'owinaq chi ri q'ij aretaq ri winaq aj Israel käka'n u b'anik ronojel che ri q'ij re uxlanem, ri ki nimaqil ri sacerdotes kuk' ri tata'ib' fariseos xeb'e' ruk' ri tat Pilato. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Xkib'ij k'u che: Tat, xna'taj chqe chi ri Jesús ri k'ia b'anow taq tzij xub'ano, aretaq k'asal na xub'ij chi churox q'ij käk'astaj na chkixol ri käminaqib'. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Rumal ri' taqan la chuchajixik ri muqub'al k'ä kätz'aqat na ri oxib' q'ij, rech man kepe tä ru tijoxelab' che relaq'axik b'i ru cuerpo, te k'u ri' käkib'ij ta k'u chke ri winaq: “Xk'astaj ri Jesús chkixol ri käminaqib',” —mecha'. We je ri' are jun b'anow tzij ri' ri sib'alaj nim na chuwäch ri nab'e, —xecha che ri tat Pilato. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ri tat Pilato xub'ij chke: Chik'ama b'i we soldados ri' iwuk'. Jix, jichajij ri muqub'al. Utz chib'ana che, jas ri kixkowin che, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Xeb'e' k'ut, utz xka'n che ri muqub'al. Xkikoj jun retal chrij ri ab'aj ri kojom chuchi'. Xekiya k'u kan ri soldados chila' chuchajixik ri muqub'al. ");
INSERT INTO qucNNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ok'owinaq chi k'u ri q'ij re uxlanem, saqirem kub'an pa ri nab'e q'ij re ri semana. Ri nan María ri aj Magdala rachi'l ri jun María chik xeb'e' che rilik ri muqub'al. ");
INSERT INTO qucNNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Xaq k'u te'talik xpe jun nimalaj käb'raqan. Are jun ángel ri taqom loq rumal ri Dios xqaj loq chikaj, xopan chila' jawije' ri muqutal wi ri Jesús. Xresaj apan ri ab'aj ri tz'apib'al re ru chi' ri muqub'al, te k'u ri' xt'uyi puwi'. ");
INSERT INTO qucNNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ri ángel sib'alaj käjuluwik jas ri jun kaypa'. Ri ratz'iaq sib'alaj saq je' jas ri saq tew. ");
INSERT INTO qucNNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Aretaq xkil wa' ri soldados, sib'alaj xkixej kib', xeb'irb'itik, pak'alik xeqajik je' ta ne ri xekämik. ");
INSERT INTO qucNNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ri ángel xub'ij chke ri ixoqib': Mixej iwib'. Wetam chi are tajin kitzukuj ri Jesús ri xrip cho ri cruz, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Man k'o tä chi waral, xane k'astajinaq chi b'i chkixol ri käminaqib' jas ri xub'ij. Jiwilampe' jawije' ri xyi' wi. ");
INSERT INTO qucNNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Jix b'a' aninaq. Chib'ij wa' chke ru tijoxelab': “Ri Are' xkäm na, xk'astaj k'u b'i chkixol ri käminaqib'. Nab'ejinaq chiwäch, b'enam re pa Galilea. Chila' k'ut kiwil wi na u wäch.” Are wa' ri nu tajkil iwuk', —xcha ri ángel chke ri ixoqib'. ");
INSERT INTO qucNNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Chanim k'ut xeb'el b'i ri ixoqib' chi' ri muqub'al, jub'iq' kixe'm kib', jub'iq' kekikotik. Aninaq xeb'e' chub'ixik wa' chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","B'enam k'u ke pa ri b'e aretaq ri Jesús xuk'ut rib' chkiwäch, xuya k'u rutzil ki wäch. Ri ixoqib' xeqeb' ruk' ri Jesús, xkiq'ijilaj, xkichap k'u ri raqan. ");
INSERT INTO qucNNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ri Jesús xub'ij chke: Mixej iwib'. Jib'ij chke ri wachalal chi rajwaxik keb'e' pa Galilea. Käkil k'u na nu wäch chila', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","E b'enaq ri ixoqib' pa ri b'e, jujun chke ri soldados ri xechajin ri muqub'al xeb'e' pa ri tinimit Jerusalén, xekib'ij k'u chke ri ki nimaqil ri sacerdotes ri xk'ulmatajik. ");
INSERT INTO qucNNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Are k'u ri ki nimaqil ri sacerdotes xeb'e' kuk' ri ki nimaqil ri winaq aj Israel, rech käjunamataj ki tzij. Xkiya k'u nimaq taq puaq chke ri soldados che tojb'al ke. ");
INSERT INTO qucNNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Xkib'ij k'u chke: Chib'ij ix chi chaq'ab' aretaq tajin kixwarik xepe ru tijoxelab' ri Jesús, xkelaq'aj b'i ru cuerpo, —kixcha na. ");
INSERT INTO qucNNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","We k'u kopan u b'ixik wa' ruk' ri q'atal tzij, ri uj kujtob' na chub'ixik che chi qas tzij rech man k'o tä k'äx kiriqo, —xecha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Xkik'am k'u ri puaq ri soldados, je' xka'no jas ri xb'ix chke. Je wa' xel u tzijol chkixol ri winaq aj Israel, je k'u wa' käkitzijoj k'ä we kämik ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Xeb'e' k'u ri julajuj u tijoxelab' ri Jesús pa Galilea, pa ri juyub' ri xub'ij ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Aretaq xkil u wäch ri Jesús, xkiq'ijilaj. E k'o k'u jujun ri xub'an kieb' ki k'ux chrij. ");
INSERT INTO qucNNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Xqeb' k'u ri Jesús kuk' ru tijoxelab', xub'ij chke: Chwe in yo'm wi ronojel taqanik pa ri kaj, xuquje' pa ki wi' ri winaq cho ruwächulew, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jix b'a' kuk' konojel ki wäch winaq cho ruwächulew, chib'ana' chi keb'ok che nu tijoxelab'. Chib'ana ki qasna' pa ru b'i' ri qa Tat, pa ru b'i' ru K'ojol, pa ru b'i' ri Loq'alaj Espíritu. ");
INSERT INTO qucNNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Cheitijoj chunimaxik ronojel ri ix nu taqom wi. Chiwetamaj k'ut chi ri in, in k'o iwuk' ronojel q'ij, k'ä pa ri k'isb'al q'ij re ruwächulew, —xcha ri Jesús chke ru tijoxelab'. Amén.");
INSERT INTO qucNNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Je' u chaplexik wa' ri Utzalaj Tzij re ri Evangelio chrij ri Jesucristo ri u K'ojol ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Je wa' ri xtz'ib'ax kan ojer chrij ri Cristo rumal ri qa mam Isaías ri q'alajisal re ru Loq' Pixab' ri Dios, kub'ij: ¡Chiwilampe'! —xcha ri Dios chke ri winaq. Xub'ij k'u che ru K'ojol: Ri in kintaq b'i ri nu taqo'n, känab'ej k'u na chawäch, kub'an na u b'anik ra b'e, —xcha ri Dios che. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","K'o jun ri ko käch'aw pa taq juyub' ri kätz'inowik, kub'ij: “Chib'ana u b'anik ri nim b'e ri käb'in wi ri Qajaw, chisuk'umaj, chib'ana k'u sib'alaj jikom che ru b'e,” —kächa', —xcha ri qa mam Isaías. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Je wa' ri' xpe ri tat Juan. Are k'u tajin kub'an ki qasna' ri winaq pa taq juyub' ri kätz'inowik. Kutzijoj k'u chke chi rajwaxik käkik'ex kanima', käkik'ex ki chomanik, te k'u ri' käb'an ki qasna' rech käq'alajinik chi je' ki b'anom wa'. Xa je ri' käsachtaj taq ri ki mak. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Xepe k'u konojel ri winaq aj Jerusalén, xuquje' ri e k'o pa taq ri nik'iaj tinimit chik re Judea, xeopan ruk' ri tat Juan chutatab'exik ri kub'ij. Aretaq käkiq'alajisaj ri ki mak, käb'an k'u ki qasna' rumal ri tat Juan pa ri nima' Jordán. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Are k'u ri tat Juan kukoj atz'iaq ri b'anom ruk' ri rismal jun awaj camello u b'i', tz'um ru pas. Xa sak' xuquje' u wa'l che' kutijo. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kätzijon k'u ri tat Juan, kub'ij chke ri winaq: Käpe chi na Jun ri qas nim u q'ij, nim k'u na u b'anik chnuwäch in. Man taqal tä chwe in kinpachi'k kinkir ru k'amal u xajäb', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Qas tzij ri in nu b'anom qasna' alaq ruk' joron, ri Are' k'ut kub'an na qasna' alaq ruk' ri Loq'alaj Espíritu rech ri Dios, —xcha chke ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Pa taq ri q'ij ri' xpe ri Jesús pa ri tinimit Nazaret re Galilea, xopan ruk' ri tat Juan. Xb'an u qasna' rumal ri tat Juan pa ri nima' Jordán. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Te k'u ri' aretaq tajin kel loq ri Jesús pa ri ja', chanim xril ri kaj tajin käjaqjob'ik, xuquje' xril ri Loq'alaj Espíritu tajin käqaj loq puwi', je' ru b'anik jun palomäx. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Te k'u ri' xch'aw loq jun chikaj, xub'ij: At ri' ri loq'alaj nu K'ojol. Käkikot k'u ri wanima' awumal, —xcha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Te k'u ri' ri Loq'alaj Espíritu xuk'am b'i ri Jesús pa taq juyub' ri kätz'inowik. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Xk'oji k'u chila' kawinaq q'ij chkixol ri awaj aj pa taq juyub'. Kätaqchi'x ri Jesús che mak rumal ri Satanás. Xepe k'u ri ángeles chupatänixik. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Mäja' naj kojom ri tat Juan pa che' aretaq ri Jesús xopan pa Galilea. Kutzijoj ri Utzalaj Tzij re ri Evangelio chrij ru taqanik ri Dios pa ki wi' ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Xub'ij k'u ri Jesús chke: Xopan ri q'ij, xa jub'iq' chik man kuchaplej ru taqanik ri Dios. K'exa anima' alaq, k'exa b'a' alaq ri chomanik alaq, kojon k'u alaq che ri Utzalaj Tzij re ri Evangelio, —xcha chke ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ok'owem kub'an ri Jesús chuchi' ri mar re Galilea, xril ri tat Simón rachi'l ri tat Andrés ru chaq'. Tajin käkik'iäq b'i jun k'at chapäb'al taq kär pa ri mar rumal chi e chapal taq kär ri e are'. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Xub'ij k'u ri Jesús chke: Chixsa'j wuk'. Kinb'an k'u na chiwe chi kixok che ki mulixik winaq chuk'exwäch ri kär, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Chanim xekiya kan ri ki k'at, xeb'e' ruk' ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Xb'in chi k'u apan jub'iq' ri Jesús, xril ri tat Jacobo rachi'l ri tat Juan ru chaq', e u k'ojol ri tat Zebedeo wa'. E k'o pa ri ki barco, kekik'ojoj k'u ri ki k'at. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Xeusik'ij ri Jesús. Ri e are' k'ut chanim xkiya kan ri Zebedeo ri ki tat pa ri barco kuk' ri ajchakib', xeb'e' k'u ruk' ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Xeopan k'u pa ri tinimit Capernaum. Are k'u pa ri q'ij re uxlanem xok ri Jesús pa ri rachoch Dios, xuchap ki tijoxik ri winaq chila'. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ri winaq k'ut sib'alaj käkikajmaj ru tijonik ri Jesús rumal chi keutijoj je' jas jun achi ri k'o u taqanik pa ki wi', man junam taj jas ri käka'n ri tijonelab' re ri Pixab'. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Xok k'u b'i pa ri rachoch Dios jun achi ri k'o jun itzelalaj espíritu che. Are chi' ri tajin käch'aw ri Jesús, ri achi xuraq u chi', ");
INSERT INTO qucNNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","xub'ij: ¡Aa! ¿Jas kaj la chqe uj, Jesús aj Nazaret? —kächa ri'. ¿A xa petinaq la chusachik qa wäch? In wetam wäch la, chi lal ri' ri loq'alaj achi taqom loq rumal ri Dios, —xcha che ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Are k'u ri Jesús xuyajo, xub'ij che: ¡Chatz'apij u pa chi', chatel che we achi ri'! —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ri itzelalaj espíritu xub'an che ri achi chi xtzaqik, xuyakya rib', ko xuraq u chi', xel b'i che. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Konojel k'ut xkikajmaj wa', xkichapla u tzijob'exik kib', xkib'ij: ¿Jas wa'? ¡Jun k'ak' tijonik ne lo wa'! We achi ri' yo'm pu q'ab' keutaq ri itzelalaj taq espíritus, keniman k'u che, —xecha ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Chanim k'ut ri tajin käb'an rumal ri Jesús xel u tzijol wa' pa taq konojel ri tinimit ri e k'o pa Galilea, xuquje' pa taq ri tinimit ri naqaj e k'o wi che ri Galilea. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Aretaq ri Jesús xel b'i pa ri rachoch Dios, xe' chanim cho rachoch ri tat Simón, ri tat Andrés, e rachi'l k'u ri tat Jacobo, ri tat Juan. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Are k'u ru ji' chichu' ri tat Simón qajinaq che jun nimalaj q'aq'. Chanim k'ut xkitzijoj wa' che ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ri Jesús xqeb' ruk' ri chichu', xuchap che ru q'ab', xuwalijisaj k'ut. Chanim xtäni ri q'aq' chrij ri chichu'. Xuchap k'u ri ki patänixik. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Aretaq xq'eqal chik, qajem kub'an ri q'ij, xekik'am b'i konojel ri yawab'ib' cho ri Jesús, xuquje' konojel ri e k'o itzel taq espíritus chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Konojel ri winaq ri keb'el pa ri tinimit Capernaum xkimulij kib' chi' ri ja, rachoch ri tat Simón. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ri Jesús xeukunaj k'ia yawab'ib' ri e k'o k'ia u wäch yab'il chke, xuquje' xeresaj b'i k'ia itzel taq espíritus chke ri winaq. Man kuya tä k'u ri Jesús chke ri itzel taq espíritus chi kech'awik, rumal chi ketam u wäch. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Sib'alaj aq'ab' k'ut xwalij ri Jesús, k'ä mäjoq käsaqirik. Xel b'ik, xe' pa ri juyub' ri kätz'inowik, xub'an k'u orar chila'. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Are k'u ri tat Simón, xuquje' ri e k'o ruk' xeb'e'k, xkitzukuj ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Aretaq xkiriqo, xkib'ij che: Konojel ri winaq ketzukun che la, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Xub'ij k'u ri Jesús chke: Jo' pa ri jule' taq tinimit chik ri e k'o chqanaqaj, rech chila' xuquje' kintzijon wi. Che k'u wa' in elinaq wi loq, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ri Jesús kusolij k'u taq ri tinimit pa ronojel Galilea. Pa taq ri rachoch Dios ri käkimulij wi kib' ri winaq, kutzijoj ri Utzalaj Tzij re ri Evangelio chrij ru taqanik ri Dios pa ki wi' ri winaq, xuquje' keresaj b'i itzel taq espíritus chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Xopan k'u ruk' ri Jesús jun achi ri k'o itzel ch'a'k che. Xuchap u b'ochi'xik ri Jesús, xxuki'k, xub'ij che: Tat, ri in wetam chi ri lal käkowin la che nu kunaxik we kaj la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Xel k'u u k'ux ri Jesús che. Xuyuq ru q'ab', xuchap koq ri achi, xub'ij che: Kwaj, —kächa'. Chutzir b'a' la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Xuwi wa' xub'ij, chanim xel ri itzel ch'a'k che ri achi, xutzirik. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ri Jesús sib'alaj xupixb'aj ri achi k'ä mäja' kutaq b'ik, ");
INSERT INTO qucNNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","xub'ij b'i che: ¡Tampe la! K'o jas mäb'ij la che jachin jun. Oj la, jek'utu ib' la cho ri sacerdote. Ya la ri sipanik ri taqom kan rumal ri qa mam Moisés ojer chi käyi'k aretaq käkunataj jun ri k'o itzel ch'a'k che. Are k'u q'alajisab'al wa' chkiwäch ri winaq, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Xel k'u b'i ri achi, sib'alaj kutzijoj ri xb'an che. Xresaj k'u u tzijoxik wa', je k'u ri' chi ri Jesús man käkowin tä chik kok chi saqil pa taq ri tinimit. Xane xaq pa taq juyub' ri kätz'inowik käk'oji wi ri Are'. Kepe k'u ri winaq pa ronojel tinimit, keopan ruk' ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Xopan jumul chik ri Jesús pa ri tinimit Capernaum. Xke' k'u kieb' oxib' q'ij, xtatajik chi k'o chi cho ja. ");
INSERT INTO qucNNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Chanim k'ut xkimulij kib' k'ia winaq, je ri' chi man k'o tä chi jawije' kek'oji wi, pune ta ne xa chuchi' ri ja. Are k'u ri Jesús kutzijoj ru Loq' Pixab' ri Dios chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Xeopan k'u kiejeb' achijab' ruk' ri Jesús, ki telem jun achi ri käminaq u cuerpo. ");
INSERT INTO qucNNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Man kekowin tä k'ut keb'ok chuwäch ri Jesús, ki mak ri sib'alaj k'ia winaq. Xkesaj k'u apan ru xo'til ri ja. Xkik'ot jun jul puwi' ri ja chusik'el ri k'o wi ri Jesús, xkiqasaj k'u b'i ri alaj ch'at ri q'oyol wi ri käminaq u cuerpo. ");
INSERT INTO qucNNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Aretaq ri Jesús xrilo chi sib'alaj kekojon che, xub'ij che ri achi ri käminaq u cuerpo: Tat, ¡xesachtaj ri mak la! —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","E t'uyul k'u chila' jujun chke ri tijonelab' re ri Pixab', tajin kechomanik, ketzijon k'u pa kanima', ");
INSERT INTO qucNNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","käkib'ij: “¿Jas che je' kätzijon wa' we achi ri'? Kub'ij ri sib'alaj äwas u b'ixik,” —kecha'. “¿Jachin ta lo ri käkowin chusachik mak xane xaq xuwi ri Dios?” —xecha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Chanim xuna' wa' ri Jesús pa ranima', ya retam chik jas ri tajin käkichomaj, xub'ij k'u chke: ¿Jas che je' kächomaj alaq wa' pa anima' alaq? —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Jachike ri man k'äx tä u b'ixik che ri achi, ri u b'ixik: “Ri mak la xesachtajik”, o ri u b'ixik: “Walij b'a' la, k'ama la b'i ri sok la, b'in b'a' la”? —kächa ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Rech b'a' ketamaj alaq chi ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, k'o nu taqanik pa ki wi' ri winaq cho ruwächulew, xuquje' rech ketamaj alaq chi ya'tal chwe in chi kinsach ri ki mak, ¡tampe alaq ri kinb'ij! —xcha chke. Xub'ij k'u ri Jesús che ri achi ri käminaq u cuerpo: ");
INSERT INTO qucNNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Kinb'ij che la, ¡walij b'a' la! Oj la cho ja, k'ama la b'i ri sok la, —xcha ri Jesús che ri achi. ");
INSERT INTO qucNNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Chanim xwalij ri achi, xutelej b'i ri alaj u ch'at. Xel b'i chkiwäch konojel, je ri' chi konojel xkikajmaj ri xb'antajik, xkinimarisaj u q'ij ri Dios, xkib'ij: ¡Man k'o tä jumul ri je' qilom wa'! —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ri Jesús xe' chi jumul chuchi' ri mar, sib'alaj e k'ia k'u ri winaq ri xeopan ruk'. Are k'u ri Are' xeutijoj che ru Loq' Pixab' ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ok'owem kub'an ri Jesús jawije' ri kätoj wi ri alkab'al, xril k'u ri tat Leví, u k'ojol ri tat Alfeo, t'uyul chila'. Xub'ij k'u che: Sa'j la wuk', —xcha che. Xwalij k'u ri tat Leví, xe' ruk' ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pa jun q'ij k'ut t'uyul ri Jesús chi' ri mesa cho rachoch ri tat Leví e rachi'l ru tijoxelab'. E k'ia k'u ri toq'il taq alkab'al, xuquje' nik'iaj ajmakib' e t'uyut'oj chi' ri mesa ruk' ri Jesús, kuk' ru tijoxelab'. E k'ia k'u ri winaq e tereninaq loq. ");
INSERT INTO qucNNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Xepe k'u ri tata'ib' fariseos, xuquje' ri tijonelab' re ri Pixab'. Xkilo chi ri Jesús tajin käwi' kuk' toq'il taq alkab'al xuquje' nik'iaj ajmakib' chik, xkita' k'u chke ru tijoxelab', xkib'ij: ¿Jas che käwi' ri Jesús kuk' toq'il taq alkab'al xuquje' nik'iaj ajmakib' chik? —xecha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Aretaq xuta ri Jesús wa', xub'ij chke: Ri winaq ri utz ki wäch, ri k'o ki chuq'ab', man rajwaxik tä kunal ke, xane are rajwaxik wa' chke ri yawab'ib', —kächa chke. Man in petinaq tä che ki sik'ixik ri winaq ri jikom kanima' cho ri Dios, xane in petinaq che ki sik'ixik ri ajmakib' ri mäja' käkik'ex kanima', mäja' käkik'ex ki chomanik, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Pa jun q'ij ri' tajin käka'n ayunar ru tijoxelab' ri Juan Qasal Ja' xuquje' ri ki tijoxelab' ri tata'ib' fariseos. E k'o k'u jujun winaq xeopan ruk' ri Jesús, xkib'ij che: Ru tijoxelab' ri tat Juan xuquje' ri ki tijoxelab' ri tata'ib' fariseos käka'n ayunar. ¿Jas k'u che man käka'n tä ayunar ri tijoxelab' la? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Xch'aw k'u ri Jesús, xub'ij chke: ¿A kuya' ne lo käka'n ayunar ri e k'o pa jun k'ulanem aretaq ri achi ri te' xk'uli'k k'o kan kuk'? Aretaq k'o ri achi ri' kuk' man kuya' taj käka'n ayunar, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kopan k'u na ri q'ij aretaq kesax b'i ri achi chkixol. Te k'u ri' käka'n na ayunar pa ri q'ij ri', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Xuquje' xub'ij ri Jesús: Man k'o tä jun winaq ri kut'is jun pimalaj k'ojob'al chrij jun q'el atz'iaq. We ta je ri', ri k'ak' atz'iaq kuk'ol rib', käresaj b'i jub'iq' che ri q'el atz'iaq, känimar k'u ru teq'tob'ik, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Man k'o tä jun ri kuya k'ak' vino pa taq q'el taq q'eb'al re tz'um. We ta je ri', ri vino keut'ub'ij ri' ri tz'um, ketzeletaj k'u na kan ri vino xuquje' taq ri tz'um. Rajwaxik k'ut chi ri k'ak' vino käyi' pa taq k'ak' taq q'eb'al re tz'um, —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Pa jun q'ij re uxlanem ok'owem re ri Jesús pa taq ri tiko'n. Are chi' ri tajin keb'in ru tijoxelab' ruk', xkichaplej ki ch'upik ru jolom taq ri triko. ");
INSERT INTO qucNNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ri tata'ib' fariseos xkib'ij che ri Jesús: ¡Chilampe la! ¿Jas che ri tijoxelab' la käka'n chak ri äwas u b'anik pa taq ri q'ij re uxlanem? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Xub'ij k'u ri Jesús chke: ¿A man k'o tä jumul ri sik'im alaq ri xub'an ri qa mam David ojer aretaq ri k'o rajwaxik che, xuna' numik, xuquje' ri xka'n ri e k'o ruk'? ");
INSERT INTO qucNNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Xok k'u b'i ri qa mam David pa ri rachoch Dios aretaq ri tat Abiatar are ki nimal sacerdotes, xutij k'u re ri wa ri yo'm cho ri Dios, xuya k'u ke ri e k'o ruk' xuquje'. Äwas k'u u tijik wa' kumal xaq jachinoq, xane xaq xuwi chke ri sacerdotes ya'tal wi wa', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Xuquje' xub'ij ri Jesús chke: Ri q'ij re uxlanem xb'antaj wa' ojer rech ri winaq käkiriq utzil rumal, man xeb'an tä k'u ri winaq rech käka'n jun utzil che ri q'ij re uxlanem. ");
INSERT INTO qucNNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Je k'u ri' ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, k'o nu taqanik puwi' ri q'ij re uxlanem xuquje', —xcha ri Jesús chke ri tata'ib' fariseos. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Xok chi jumul ri Jesús pa ri rachoch Dios, k'o k'u jun achi chila' ri käminaq jun u q'ab'. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Kaluchi'x k'u ri Jesús kumal jujun tata'ib' che rilik we kärutzirisaj ru q'ab' ri achi pa ri q'ij re uxlanem rech kuya' käkib'ij chi k'o u mak ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Xub'ij k'u ri Jesús che ri achi ri käminaq jun u q'ab': ¡Walij b'a' la! ¡Tak'al la chqawäch! —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Xub'ij k'u ri Jesús chke ri achijab' ri tajin käkaluchi'j: ¿Jachike ri man äwas tä u b'anik pa ri q'ij re uxlanem, ri u b'anik utzil o ri u b'anik etzelal? ¿A utz ru to'ik ru k'aslemal jun winaq o ru kämisaxik wa'? —xcha chke. Man xech'aw tä k'u ri tata'ib'. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Xpe royowal ri Jesús chke ri achijab' ri', keuka'yej konojel ri e k'o pa taq u xkut, kub'isoj ki wäch rumal chi sib'alaj ab'ajarinaq ri kanima'. Xub'ij k'u che ri achi: ¡Yuqu ri q'ab' la! —xcha che. Xuyuq k'ut, xutzir k'u ru q'ab'. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Xeb'el k'u b'i ri tata'ib' fariseos, chanim xkiriq kib' kuk' ri rachi'l ri tat Herodes, xkitala' ki no'j chb'il taq kib' jas ri käka'n chukämisaxik ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Are k'u ri Jesús xe' apan chkiwäch ri winaq chuchi' ri mar, e rachi'l k'u ru tijoxelab'. Sib'alaj e k'ia ri winaq aj Galilea ri xeteri b'i chrij. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Xuquje' e k'ia ri winaq aj Judea xepetik. E k'o ri aj Jerusalén, xuquje' ri kepe pa Idumea. Nik'iaj kepe ch'äqäp che ri nima' Jordán, xuquje' pa taq ri tinimit Tiro, ri tinimit Sidón. Xa rumal chi xkita u tzijol ronojel ri tajin kub'an ri Jesús, xeopan k'u ruk'. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Xub'ij k'u ri Jesús chke ru tijoxelab' chi xaq chk'ol jun barco ri käk'oji wi ri Are', rech man käpitz' tä kumal ri k'ialaj winaq. Je' xka'no. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Are ri Jesús xeukunaj k'ia winaq, je ri' chi konojel ri yawab'ib' käkich'ikimij kib' chrij ri Jesús rech käkichap koq. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ri winaq ri e k'o itzelalaj taq espíritus chke, aretaq xkil ri Jesús, xetzaq k'u chuwäch, xkiraq ki chi', xkib'ij: ¡Lal ri' ri u K'ojol ri Dios! —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ri Jesús sib'alaj xeupixb'aj ri itzelalaj taq espíritus chi mäkib'ij jachin ri Are'. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Xpaqi k'u ri Jesús puwi' jun juyub'. Are k'u chila' ri xeusik'ij wi jachin taq ri xraj xeucha'. Xeopan k'u ruk'. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Xeukoj k'u kab'lajuj achijab' rech kek'oji ruk', rech keutaq b'i chutzijoxik ru Loq' Pixab' ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Xuquje' xuya chke chi käk'oji ki kuinem che ki kunaxik ri yawab'ib', xuquje' xuya taqanik pa ki q'ab' che kesaxik b'i ri itzel taq espíritus chke ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","E are k'u wa' ri kab'lajuj ri xeucha' ri Jesús: ri tat Simón ri käb'ix Pedro che rumal ri Jesús, ");
INSERT INTO qucNNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ri tat Jacobo u k'ojol ri tat Zebedeo, xuquje' ri tat Juan ru chaq' ri tat Jacobo. E are' wa' ri xkoj Boanerges che ki b'i' rumal ri Jesús. Ri b'i'aj ri' kel kub'ij chi e junam ruk' ri kiäqul ja. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Xeucha' xuquje' ri tat Andrés, ri tat Felipe, ri tat Bartolomé, ri tat Mateo, ri tat Tomás, ri tat Jacobo u k'ojol ri tat Alfeo, ri tat Tadeo, ri tat Simón ri käb'ix “u nimal tinimit” che. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ri tat Judas Iscariote, ri xjachow ri Jesús, xuquje' xcha'ik rumal. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Te k'u ri' xe' ri Jesús cho ja. Jumul chik xkimulij kib' k'ia winaq, je ri' chi ri Jesús e rachi'l ru tijoxelab' man kekowin tä ne kewi'k. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Aretaq ri rachalal ri Jesús xkito chi k'o chila', xeb'e' chuchapik. ¡Xkib'ij k'ut chi ch'ujarinaq ri Are'! ");
INSERT INTO qucNNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ri tijonelab' re ri Pixab' k'ut, ri e petinaq pa Jerusalén, käkib'ij chi k'o ri Beelzebú ruk' ri Jesús. (Ri Beelzebú are ki nimal ri itzel taq espíritus.) Käkib'ij chi xa rumal wa' ri Jesús käkowin che kesax b'i ri itzel taq espíritus, —kecha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ri Jesús k'ut xeusik'ij ri winaq, xukoj jun k'utb'al chkiwäch, xub'ij: ¿Jas ta k'u lo kub'an ri Satanás che resaxik b'i rib'? —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","We jun q'atb'al tzij u b'anom kieb', ri juch'ob' q'atal taq tzij kuyak rib' chrij ri juch'ob' chik, kuk'is na u wäch ri q'atb'al tzij ri' chb'il rib'. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Xuquje' we jun achalaxik u b'anom kieb', ri juch'ob' kuyak rib' chrij ri juch'ob' chik, kuk'is k'u na u wäch ri achalaxik ri' chb'il rib', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","We ta u b'anom kieb' ri Satanás, kuyak k'u rib' chrij chb'il rib', man käkowin tä ri' chujeqb'axik rib', xane kuk'is k'u na rib' ri are', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Man k'o tä jun käkowinik kok pa ri rachoch jun achi ri sib'alaj k'o u chuq'ab', kerelaq'aj b'i ri jastaq re, we ta mat nab'e kuyut na ri achi ri k'o u chuq'ab', k'ä te k'u ri' käkowinik kerelaq'aj b'i ri k'o pa rachoch, —kächa ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Qas tzij kinb'ij chech alaq chi konojel ri mak ri käka'n ri winaq kuya' kesachtaj na wa', xuquje' apachike ta ne ri äwas u b'ixik chrij ri Dios, ri käkib'ij ri winaq, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Apachin k'u ri kub'ij ri äwas u b'ixik chrij ri Loq'alaj Espíritu, man käsachtaj tä u mak ri' pa taq ri q'ij ri kepe na, rumal chi u b'anom jun mak ri man kuya' taj käsachtajik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ri Jesús xub'ij wa' rumal chi ri winaq xkib'ij: K'o jun itzelalaj espíritu che ri Are', —xecha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Xopan k'u ru nan ri Jesús ruk', xuquje' taq ru chaq'. Ri e are' k'ut xa e tak'atoj apan chrij ri ja, xetaqan k'u chusik'ixik ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","E k'ia k'u ri winaq ri ki sutim rij ri Jesús, xkib'ij che ri Are': Ri nan la xuquje' taq ri chaq' la xaq e k'o apan cho ja, ketzukun che la, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Xch'aw ri Jesús, xub'ij chke: ¿Jachin ri nu nan, jachin k'u taq ri qas nu chaq'? —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Xeuka'yej ri e t'uyut'oj pa taq u xkut, xub'ij: Cheiwilampe ri nu nan, xuquje' taq ri nu chaq'. ");
INSERT INTO qucNNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Apachin ta ne ri käb'anow ru rayinik ri Dios, e are wa' ri qas wachalal, ri nu chaq', ri wanab', ri nu nan, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ri Jesús xuchaplej chi na jumul ki tijoxik ri winaq chuchi' ri mar. Xkimulij k'u kib' k'ialaj winaq ruk', je ri' chi xok b'i pa jun barco puwi' ri mar, xt'uyi k'u chupam. Konojel ri winaq xekanaj kan cho ri ulew chuchi' ri mar. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Xeukoj k'u taq k'utb'al che ki tijoxik ri winaq chkij k'ia u wäch taq no'j, xub'ij chke: ");
INSERT INTO qucNNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","¡Tampe alaq! —kächa'. Xel b'i jun tikol ija' cho rachoch, xe'k, xub'ana u tiko'n. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Aretaq tajin kujopij ri ija', xqaj jub'iq' pa ri b'e. Xeopan k'u ri chikop, kerapapik keqajik, xa xkitij b'i ri ija'. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Xqaj chi jub'iq' xol taq ri ab'aj, ri man k'o tä wi k'ia ulew. Chanim k'ut xk'iy ri jub'iq' ija' ri' rumal chi man pim tä ri ulew. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Aretaq k'ut xel loq ri q'ij, xek'at ri alaj taq tiko'n, xechaqi'jik rumal chi k'ä mäja' nim ki xera'. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Xqaj chi k'u jub'iq' ri ija' pa taq ri q'ayes ri k'o ki k'ixol. Xk'iy k'u ri q'ayes ri', xujiq'isaj ri tiko'n, je ri' chi man xwächin taj. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Are k'u ri nik'iaj ija' chik xeqaj pa utzalaj ulew. Xeb'el loq ri tux, xek'iyik, xewächinik. E k'o jujun tiko'n xkiya juwinaq lajuj ki wäch chupam ru jolom triko chkijujunal, e k'o jule' chik ri xkiya oxk'al ki wäch chupam ru jolom chkijujunal. Ri nik'iaj tiko'n chik xkiya jun ciento ki wäch chupam ru jolom chkijujunal, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Te k'u ri' xub'ij chke ri winaq: We k'o jun ri kujikib'a ranima' chutatab'exik ri nu tzij, ¡chutatab'ej b'a'! —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Aretaq ri Jesús xaq u tukiel chik k'olik, xeopan jujun chke ri winaq ruk', kachi'l ri kab'lajuj u tijoxelab'. Xkita' k'u che jas kel kub'ij ri k'utb'al ri xutzijoj chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Xch'aw k'u ri Jesús, xub'ij: Ri ix, yo'm chiwe rumal ri Dios ri retamaxik ri man ketam tä ri nik'iaj winaq chik chrij ru taqanik ri Dios pa ki wi' ri winaq. Are kätzijox k'u wa' chke ri jule' winaq chik xa kuk' taq k'utb'al. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Je ri', rumal chi pune jaqal ri ki waq'äch, man kekowin tä chuch'ob'ik ri käkilo. Pune k'u käkitatab'ej na ri qas tzij, man käkich'ob' tä ri' ri ki tatab'em, rech man käkitzelej tä kib' ruk' ri Dios, man käsachtaj tä ki mak, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Xub'ij chi k'u ri Jesús chke: ¿A mat lo kich'ob' ri kel kub'ij wa' we k'utb'al ri' ri xintzijoj chiwe? ¿Jas k'u kiwetamab'ej taq ke konojel ri nik'iaj taq k'utb'al chik ri keintzijoj na chiwe? —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ri tikol ija' are junam ruk' ri winaq ri kutzijoj ru Loq' Pixab' ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ri ija' ri xeqaj pa ri b'e, e are k'u wa' jas ri winaq ri kätik ru Tzij ri Dios pa kanima', käkita k'u ri Tzij, chanim k'ut käpe ri Satanás, käresaj ri Tzij ri xqaj pa kanima'. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Junam xuquje' ri ija' ri xeqaj xol taq ri ab'aj. E are wa' jas ri winaq ri käkita ru Tzij ri Dios ruk' kikotemal, je'l käkito. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Man qas tä k'u k'o ri ki xera', xane xaq kieb' oxib' q'ij käkich'ijo. Aretaq käkichaplej u riqik k'äx, kraj keyoq'ik rumal rech ru Tzij ri Dios, chanim ketzaq kanoq. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ri jule' ija' chik ri xqaj pa taq q'ayes ri k'o ki k'ixol, e are wa' jas ri winaq ri käkita ru Tzij ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Te k'u ri' are kekilij na ri jastaq re we uwächulew ri', kesub' rumal ri q'inomal, xuquje' käkirayij k'ia u wäch jastaq chik, ke' k'u kanima' kuk'. Rumal k'u wa' käjiq'isax ri Tzij pa kanima', man käwächin tä k'u ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ri ija' ri xeqaj pa utzalaj ulew, e are k'u wa' jas ri winaq ri käkita ru Tzij ri Dios, käkik'amowaj, käqaj wa' pa kanima', käkiya k'u k'ia ki wäch. Jujun käkiya juwinaq lajuj ki wäch chkijujunal, jule' chik käkiya oxk'al ki wäch chkijujunal, ri nik'iaj chik käkiya jun ciento ki wäch chkijujunal, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Xuquje' xub'ij ri Jesús chke: ¿A kätzij lo jun chäj pa ri ja, te k'u ri' käyi' wa' chuxe' jun laq, o käyi' chuxe' ri ch'at? Man je' tä ri', xane käyi' wa' chikaj rech q'alaj ronojel, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Man k'o tä jas ri ch'uqtal u wi' ri mat käq'alajin na. Man k'o tä jas ri k'u'talik ri mat kel na chi saq, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","We k'o jun ri kujikib'a ranima' chutatab'exik ri nu tzij, ¡chutatab'ej b'a'! —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Xuquje' xub'ij ri Jesús chke: ¡Chitampe ri tajin kinb'ij chiwe! —kächa'. Jas ri pajb'al ri kikoj ix, are je' ri pajb'al ri kok na chiwe ix, xuquje' käyi' na u wi' chiwe ix ri kitatab'ej ri nu tzij. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Apachin k'u ri k'o k'o ruk', käyi' chi na nik'iaj che. Apachin k'u ri man k'o tä k'o ruk', kesax na che ri are' ri jub'iq' ri k'olik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Xub'ij chi k'u chke: Ru taqanik ri Dios pa ki wi' ri winaq, are jas jun achi ri kutik kan ri ija' pa rulew. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Käwar chaq'ab', käwalij k'ut. Käk'astaj chi paq'ij. Je ri' keok'ow taq ri q'ij, ri aq'ab'. Kätux k'u ri ija' ri k'o pa ulew, käk'iyik. Man retam tä k'u ri achi jas kub'an ri ija' käk'iyik. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tzpa re wi ri ulew kub'ano chi kek'iy ri tiko'n, kewächinik. Nab'e kel loq ru tux, käk'iy k'u wa'. Te k'u ri' käpe ru jolom ri triko. K'ä te ri' kechomaqir ru jolom. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Aretaq e chomaq chik, chanim käkoj ri ixjos chkixe' rumal chi chaqi'j chik, xopan ri q'ij rech ri q'atoj, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Xub'ij chi ri Jesús: ¿Jas ruk' käqajunamaj wi ru taqanik ri Dios? ¿Jas u wäch k'utb'al käqakoj chuk'utik wa'? —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Are je' jas ri ija' re ri tiko'n ri käb'ix “mostaza” che. Aretaq kätikik, xa i nitz' wa' chkiwäch konojel ri ija' ri e k'o cho ruwächulew. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Aretaq tikom chik, kel loq, nim na ke' chkiwäch konojel taq ri nik'iaj tiko'n. Kenimaqir taq ru q'ab', je ri' chi ri chikop ajuwokaj kekowinik käka'n ri ki sok, kemu'jan chupam ri tiko'n ri', —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Je wa' xub'an ri Jesús che ki tijoxik ri winaq. Xukoj k'ia taq k'utb'al chkiwäch jas taq we ri' chutzijoxik ru Loq' Pixab' ri Dios chke, xa jas ri kekowin chuch'ob'ik. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Xaq xuwi kuk' taq k'utb'al xeutzijob'ej ri winaq. Xukir k'u ronojel wa' we tijonik ri' chkiwäch ru tijoxelab' xaq pa ki tukiel wi. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Pa ri q'ij ri', aretaq tajin kok ri aq'ab', xub'ij chke ru tijoxelab': Chujq'ax jela' ch'äqäp che ri mar, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Xekiya k'u kan ri k'ia winaq. Ri tijoxelab' xkik'am b'i ri Jesús pa ri barco. T'uyul k'u wi ri Are' chupam. Xkachi'laj k'u b'i nik'iaj taq barcos chik. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Xpe k'u jun nimalaj kiäqiq' ri sib'alaj k'äx puwi' ri ja'. Are k'u ri nimaq taq uwoja' tajin keb'ok pa ri barco, je ri' chi tajin känoj ri barco che ri ja'. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","K'o k'u ri Jesús pa ri barco pa ri ku'lb'al chrij. Tajin käwarik, u yo'm ru jolom puwi' jun ch'äkataj. Xepe ru tijoxelab', xkik'asuj, xkib'ij che: ¡Qajtij! ¿A mat käxej ib' la chqe chi kujkämik? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Xk'astaj k'u ri Jesús, xuyaj ri kiäqiq', xub'ij che ri mar: ¡Chattänaloq! ¡Xaq jun chatk'ol wi! —xcha che. Xtäni k'u ri kiäqiq', xlilob' k'u ronojel ru wi' ri mar. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Te k'u ri' xub'ij ri Jesús chke ri tijoxelab': ¿Jas che sib'alaj kixej iwib'? ¿A mat kixkojon che ri Dios? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Xkikajmaj k'u ri xub'an ri Jesús, ¡sib'alaj xkixej kib'! Käkib'ila' k'u chb'il taq kib', käkib'ij: ¿Jachin k'u lo we achi ri' chi ri kiäqiq', xuquje' ri ja' re ri mar keniman che? —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Xeopan ch'äqäp che ri mar pa ri ki tinimit ri winaq aj Gadara. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Aretaq elem kub'an ri Jesús pa ri barco, chanim xriq rumal jun achi ri k'o jun itzelalaj espíritu che. Elinaq loq ri achi pa ri campo santo chkixol ri muqub'al. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Chila' k'ut, xol taq ri muqub'al, käjeqi wi. Man k'o tä jachin jun ri kowininaq chuyuqb'axik, pune xkixim na kuk' ximib'al re ch'ich'. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","K'ia mul ximom kuk' chapb'al aqanaj, xuquje' kuk' ximib'al re ch'ich'. Xeut'oqopij k'u ri ximib'al re ch'ich', xeupaxij ri chapb'al aqanaj. Man k'o tä jun ri k'o u chuq'ab' chujeqb'axik ri achi ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Chi chaq'ab', chi paq'ij käk'oji ri achi ri' xol taq ri muqub'al xuquje' pa taq juyub', kuraq u chi', kusok k'u rib' kuk' taq ab'aj. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Aretaq k'ut ri achi xril apan ri Jesús chinaj, xutik anim, xe' ruk', xxuki chuwäch. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Xuraq k'u u chi', ko xch'awik, xub'ij: ¿Jas kaj la chwe, Jesús, lal ri' ru K'ojol ri Nimalaj Dios aj Chikaj? Kinb'ochi'n che la cho ri Dios, chi mäb'an la k'äx chwe, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Xub'ij wa' rumal chi ri Jesús tajin kub'ij che: ¡Itzelalaj espíritu, chatel b'i che ri achi! —kächa che. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Xuta' k'u ri Jesús che, xub'ij: ¿Jas ra b'i'? —xcha che. Xub'ij k'u che ri Jesús: Ri nu b'i' are K'iyal. Je wa' ri nu b'i' rumal chi sib'alaj uj k'ia, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Sib'alaj xub'ochi'j ri Jesús chi mätaqanik chi cheb'el b'i pa ri tinimit ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","E sib'alaj k'ia k'u ri aq ri tajin keyuq'ux apan chila' pa ri juyub' ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ri itzelalaj taq espíritus tajin keb'ochi'n che ri Jesús, käkib'ij: Chujtaqa b'i la kuk' ri aq rech kujok b'i chke, —kecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ri Jesús k'ut xuya chke chi je' käka'no. Xeb'el k'u b'i ri itzelalaj taq espíritus, xeb'ok b'i chke ri aq. Konojel ri aq, kraj e k'o kieb' mil, xkik'iäq b'i kib' chutza'm ri juyub', xeqaj k'u pa ri mar, xejiq'ik. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","E are k'u ri ajyuq' taq aq xeanimajik, xeb'e'k. Xkiya u tzijol wa' pa ri tinimit, xuquje' pa taq ri juyub'. Xepe k'u ri winaq che rilik jas ri' ri xb'antajik. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Aretaq xeopan ruk' ri Jesús, xkil ri achi ri nab'e xek'oji na k'ia itzelalaj taq espíritus che. T'uyul k'u ri achi chila', kojom chi ri ratz'iaq, ulinaq chi putzil. Xkixej k'u kib' ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ri winaq ri xkilo jas ri xb'an che ri achi ri xek'oji ri itzelalaj taq espíritus che, xuquje' jas ri xkik'ulmaj taq ri aq, xkitzijoj k'u ronojel wa' chke ri winaq ri xkimulij kib'. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Xkib'ochi'j k'u ri Jesús chi kel b'i chanim pa ri ki tinimit. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Okem kub'an ri Jesús pa ri barco, ri achi ri xek'oji ri itzelalaj taq espíritus che xub'ochi'j ri Jesús chi kuya che chi ke' ruk'. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Man xuya tä k'u ri Jesús che, xane xub'ij che: Oj la cho achoch la kuk' ri achalaxik la, tzijoj la chke ri e are' ronojel ru b'anom ri Qajaw Dios che la, chi sib'alaj xel u k'ux che la, xutoq'ob'isaj wäch la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Xe' k'u ri achi, xutzijoj k'u pa taq ri tinimit re Decápolis ronojel ru b'anom ri Jesús che. Xkikajmaj k'u wa' konojel ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Aretaq ri Jesús xq'ax chi jumul ch'äqäp che ri mar pa ri barco, sib'alaj k'ia winaq xkimulij kib' ruk'. K'o k'u ri Are' chuchi' ri mar. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Xopan k'u jun achi ruk' ri Jesús. Are ki nimal ri winaq re ri rachoch Dios ri tata' ri', Jairo u b'i'. Aretaq ri tat Jairo xril ri Jesús, xxuki chuwäch. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Sib'alaj xub'ochi'j ri Jesús, xub'ij che: ¡Ri alaj nu mia'l tajin käkämik! ¡Sa'j la wuk'! Ya la ri q'ab' la puwi' rech kutzirik, käk'asi k'ut, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Xe' k'u ri Jesús ruk'. E k'ia ri winaq ri xuquje' xeb'e' ruk', käkipitz' k'u ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","K'o k'u jun ixoq ri xke' kab'lajuj junab' xaq kel u kik'el. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Sib'alaj u riqom k'äx pa ki q'ab' k'ia taq kunanelab', u sachom k'u ronojel ri k'o ruk'. Man k'o tä k'u utzil u riqom, xane xa tajin känimatajik. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Aretaq xuta u tzijol ri tajin kub'an ri Jesús, xopan k'u ruk'. Xok chkixol ri k'ialaj winaq, xqeb' chrij ri Jesús, xuchap koq ru q'u'. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Kub'ij k'u pa ranima': “Xuwi ta ne we kinchap koq ru q'u', ¡kinutzir na!” —kächa ri ixoq. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Chanim k'ut, aretaq xchaptaj ru q'u' ri Jesús rumal, xtäni ru kik'el ri kelik. Xuna' ri ixoq pa ru cuerpo chi xkunataj che ri itzelalaj yab'il ri u riqom. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ri Jesús k'ut xuna' chi xel jub'iq' ru chuq'ab' chukunaxik ri ixoq. Chanim xutzolq'omij rib' chkixol ri k'ialaj winaq, xka'y k'u chke, xub'ij: ¿Jachin ri xchapow ri watz'iaq? —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Xkib'ij k'u ru tijoxelab' che: ¡Kil ya' la chi käpitz' la kumal ri k'ialaj taq winaq! ¿Jas che käb'ij la: “¿Jachin ri xinchapowik?” —kächa la, —xecha che ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Käka'ylob' k'u ri Jesús che rilik jachin ri xb'anow wa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Are k'u ri ixoq ri xchapowik, xuxej rib', xb'irb'itik, xe' ruk' ri Jesús, xxuki k'u chuwäch. Kuch'ob'o chi xkunatajik rumal ri Are', xutzijoj k'u che ri Jesús ronojel ri qas tzij chrij ri k'ulmatajinaq ruk'. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ri Jesús xub'ij che: Nan, xkunataj la rumal chi xkojon la chwe. Oj b'a' la, chuxlan anima' la, xutzir k'u kan la che ri yab'il la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tajin kätzijon ri Jesús aretaq xeopan jujun winaq, e petinaq pa rachoch ri ki nimal ri winaq re ri rachoch Dios, xkib'ij che ri tat Jairo: ¡Xkäm ri mia'l la! Xaq mäya la latz' che ri Ajtij, —xecha che ri tata'. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Aretaq ri Jesús xuta ri xb'ixik, man nim tä xril wi wa', xub'ij che ri ki nimal ri winaq re ri rachoch Dios: Mäxej ib' la, xane xaq xuwi kojon la chwe, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Man xraj tä k'u ri Jesús chi k'o jachin chik xe' ruk', xane xaq xuwi ri tat Pedro, ri tat Jacobo, xuquje' ri tat Juan u chaq' ri tat Jacobo. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Aretaq xeopan cho rachoch ri ki nimal ri winaq re ri rachoch Dios, ri Jesús xrilo chi ri winaq käkitukij kib', xuquje' käkik'is kib' che oq'ej, sib'alaj käkiraq ki chi'. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Okinaq k'u b'i ri Jesús pa ri ja, xub'ij chke: ¿Jas che sib'alaj käraq chi' alaq, käk'is ib' alaq che oq'ej? Man käminaq tä ri ak'al, xane xa käwarik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ri e are' xa xkitze'j u wäch ri Jesús. Ri Are' k'ut xeresaj b'i konojel ri winaq cho ja. Xeuk'am ru tat, ru nan ri ak'al, xuquje' taq ri rachi'l, xok k'u b'i jawije' tutz'ul wi ri ak'al. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ri Jesús xuchap ri ali che ru q'ab', xub'ij che: ¡Talita, kumi! —xcha che. Ri tzij ri' kel kub'ij: ¡Alaj ali! Kinb'ij chawe, ¡chatwalijoq! —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Chanim xwalij ri ali, xb'inik. Kab'lajuj chi k'u u junab'. Sib'alaj xkikajmaj wa' ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ri Jesús sib'alaj xeupixb'aj chi mäkitzijoj wa' chke nik'iaj winaq chik. Xub'ij chi chkiya che ri ali jas kutijo. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Xel b'i ri Jesús chila', xtzelej k'u b'i pa ru tinimit ri Are', xeb'e' k'u ru tijoxelab' ruk'. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Aretaq xopan ri q'ij re uxlanem, ri Jesús xuchaplej ki tijoxik ri winaq pa ri rachoch Dios. Xkikajmaj k'u wa' k'ia chke ri winaq ri xeto'wik, xkib'ij: ¿Jawije' xretamaj wi ronojel wa' ri Are'? —kecha'. ¿Jas u wäch no'j wa' ri yo'm che? ¿Jas ta k'u lo kub'an che ki b'anik ri nimalaj taq kajmab'al ri tajin keb'antaj rumal? —kecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Are b'a' wa' ri qolol che', ri ral ri nan María, katz ri a Jacobo, ri a José, ri a Judas, xuquje' ri a Simón. E k'o k'u ri ranab' ri Jesús quk' waral xuquje', —xecha'. Tzel k'u xkita ru tzij. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Xub'ij k'u ri Jesús chke: Pa nik'iaj tinimit chik nim kil wi ronojel q'alajisal re ru Loq' Pixab' ri Dios. Xaq xuwi pa ru tinimit ri are', xuquje' chkixol ri rachalal, xuquje' cho rachoch, man nim tä kil wi wa', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Man xkowin tä k'u ri Jesús chub'anik jun nimalaj kajmab'al chila', xane xaq xuwi xuya ru q'ab' pa ki wi' kieb' oxib' yawab'ib', xeukunaj. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ri Are' xukajmaj wa' chi man k'o tä jub'iq' ri ki kojonik ri winaq che. Xeusolij k'u taq ri alaj taq tinimit ri e k'o chunaqaj ri Nazaret, xeutijoj ri winaq chila'. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ri Jesús xeusik'ij ri kab'lajuj u tijoxelab' ruk', xuchaplej ki taqik b'i chi kakab'il. Xuya taqanik pa ki q'ab' che kesaxik b'i ri itzelalaj taq espíritus. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Xub'ij k'u chke chi k'o jas mäkik'am b'ik, mäkik'am b'i ki chim, o ki wa, o puaq pa ri k'olib'al ki rajil, xane xaq xuwi ri ki ch'imiy. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Xuquje' xub'ij chke chi chkikojo b'i ki xajäb', mäkik'am k'u b'i kieb' ki kamixa', xane xa jun käkikoj b'ik. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Xub'ij xuquje' ri Jesús chke: Apachike ja ri kixok wi, chila' chixkanaj wi kanoq k'ä kixel na b'i pa ri tinimit ri', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Apachike tinimit ri man kixk'ulax tä wi, ri man käkaj taj käkitatab'ej ri i tzij, aretaq kixel b'i chila', chitota' kan ri ulew ri k'o che taq ri iwaqan. Chib'ana wa' chuq'alajisaxik chkij ri winaq re ri tinimit ri' chi man utz tä ri käka'no, k'o ki mak. Qas tzij kinb'ij chiwe chi pa ri q'ij ri käq'at na tzij pa ki wi' ri winaq ri' rumal ri Dios, kätan na ri' ri käb'an chuk'äjisaxik ki wäch ri winaq re ri tinimit Sodoma, re ri tinimit Gomorra chuwäch ri käb'an chuk'äjisaxik ki wäch ri winaq re ri tinimit ri', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Xeb'el k'u b'i ri tijoxelab', xeb'e'k, xkitzijoj chi ri winaq rajwaxik käkik'ex kanima', käkik'ex k'u ki chomanik. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Xekesaj k'u k'ia itzel taq espíritus chke ri winaq. Xuquje' xkikoj aceite chke k'ia yawab'ib', xekikunaj k'ut. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ri nim taqanel Herodes xretamaj ri tajin kub'an ri Jesús rumal chi konojel ri winaq ki tom u tzijol ronojel wa'. Xub'ij k'u ri tat Herodes: Are ri Juan Qasal Ja' ri' ri xk'astaj loq chkixol ri käminaqib', rumal k'u ri' k'o u kuinem ri are' chub'anik k'ia u wäch kajmab'al, —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","E k'o k'u nik'iaj chik tajin käkib'ij: Are ri tat Elías wa' ri ojer qa mam, —kecha'. Nik'iaj chik käkib'ij: Are wa' jun chke ri ojer q'alajisal taq re ru Loq' Pixab' ri Dios, —xecha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Aretaq k'ut xuta wa' ri tat Herodes, xub'ij ri are': Are ri tat Juan wa' ri xinwesaj u jolom, xa k'astajinaq loq chkixol ri käminaqib', —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","(Xa k'u rumal rech ri nan Herodías xkämisax ri Juan Qasal Ja'.) Tzare k'u ri tat Herodes xtaqan chuchapik ri tat Juan rech käyutik käyi' pa che', xa rumal rech ri nan Herodías ri xk'uli ruk' ri tat Herodes, pune are rixoqil ri tat Felipe ru chaq' ri tat Herodes. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Xchap k'u ri tat Juan rumal chi ri are' xub'ij che ri tat Herodes: Man taqal tä che la chi käb'an ixoqil la che ri rixoqil ri chaq' la, xane äwas ri käb'an la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Sib'alaj xpe royowal ri nan Herodías che ri tat Juan rumal ronojel ri xub'ij. Sib'alaj kraj u kämisaxik. Man käkowin tä k'ut rumal ri tat Herodes. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Je ri', rumal chi ri tat Herodes nim käril wi ri tat Juan, kuxej k'u rib' chuwäch. Retam k'ut chi are jun utzalaj achi ri jikom ranima' cho ri Dios. Xa rumal ri' kuchajij ri tat Juan rech man k'o tä k'äx käb'an che. Aretaq k'ut ri tat Herodes kutatab'ej ru tzij, man kuriq taj jas kub'ano. Pune ta ne je ri', sib'alaj xqaj chuwäch ri tat Herodes xutatab'ej ri xub'ij. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Xuriq k'u ri nimaq'ij re ri rok'owisaxik u junab' ri tat Herodes. Ri are' xub'an jun nimalaj wi'm chke ri winaq ri nimaq ki b'anik ri e k'o ruk', xuquje' chke ri ki nimaqil ri soldados, kachi'l ri ki nimaqil ri winaq aj Galilea. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Tajin kewi' ri rula' aretaq ri ali ri ral ri nan Herodías xok b'i kuk', xuchap xojowem chkiwäch, käxojowik, käxojowik. Xqaj k'u ri ali chuwäch ri tat Herodes, xuquje' chkiwäch ri tajin kewi' ruk'. Xub'ij k'u ri nim taqanel che ri ali: Chata' b'a' chwe jas ri kawaj, kinya k'u na wa' chawe, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ri tat Herodes xuchi'j che ri ali ruk' juramento, xub'ij: Apachike ta ne ri kata' chwe kinya na chawe. Pune ta ne kata' chi kinya nik'iaj chke taq ri tinimit ri kintaqan wi, kinya na wa' chawe, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Xel k'u b'i ri ali, xuch'ab'ej ru nan, xub'ij: ¿Jas ta ne ri kinta' che? —xcha che. Xub'ij k'u ru nan: ¡Chata' chi käyi' chawe ru jolom ri Juan Qasal Ja'! —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Aninaq xok chi b'i ri ali ruk' ri nim taqanel, xuta' che, xub'ij: ¡Kwaj chi käya la chwe ru jolom ri Juan Qasal Ja' pa jun plato chanim ri'! —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Sib'alaj xb'ison k'u ri tat Herodes. Ri are' man kraj taj kuk'ex ri xuchi'j che ri ali, rumal chi xub'ij wa' ruk' juramento chkiwäch konojel ri rula'. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Chanim ri nim taqanel xutaq b'i jun chke ri soldados chuk'amik loq ru jolom ri Juan Qasal Ja'. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Xel k'u b'i ri soldado, xe'k, xresaj u jolom ri tat Juan ri k'o pa che'. Xuk'am loq pa jun plato, xuya che ri ali, ri ali k'ut xuya che ru nan. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Aretaq xkita wa' ru tijoxelab' ri tat Juan, xeb'e' che rilik, xkik'am k'u b'i ru cuerpo, xkiya pa jun muqub'al. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Xkimulij k'u kib' ruk' ri Jesús ri kab'lajuj apóstoles ri taqom b'i rumal, xkitzijoj che ri Are' ronojel ri xka'no, xuquje' ronojel ri xekitijoj wi ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Xub'ij k'u ri Jesús chke: Chixsa'j wuk' xa i tukiel wi. Jo' jawije' ri man k'o tä wi winaq, kujuxlan k'u jun rat chila', —xcha chke. Je' xub'ij wa' rumal chi e k'ia winaq ri tajin keopan kuk', xuquje' e k'o ri tajin keb'el b'ik, je ri' chi ri Jesús e rachi'l ru tijoxelab' man kekowin taj kewi'k. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Xeb'e' ki tukiel wi pa jun barco, xeopan chila' pa ri juyub' ri kätz'inowik. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","E k'ia k'u ri winaq ri e petinaq pa taq konojel ri tinimit chila'. Xkilo aretaq xe' ri Jesús e rachi'l ru tijoxelab', xkich'ob' k'u ki wäch. Xa je ri' ri winaq chi kaqan xeb'e' ri e are' jela' jawije' ri xeb'e' wi ri Jesús, ru tijoxelab'. Xkikowij b'ik, xeopan k'u nab'e chkiwäch. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Aretaq xel loq ri Jesús pa ri barco, xeril ri k'ialaj winaq. Xel k'u u k'ux chke rumal chi je' ta ne e chij ri man k'o tä kajyuq'. Ri Jesús k'ut xuchaplej ki tijoxik. K'ia k'ut ri xuk'ut chkiwäch. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Qajem k'u kub'an ri q'ij, ru tijoxelab' xeqeb' ruk', xkib'ij che: We juyub' ri' ri uj k'o wi sib'alaj kätz'inowik, b'enaq chi k'u ri q'ij. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Chetaqa la b'i ri winaq rech keb'e' cho taq kachoch ri winaq ri e sutininaq chqij, xuquje' pa taq ri alaj taq tinimit ri naqaj e k'o wi, käkiloq' k'u na ri ki wa. Man k'o tä k'u ri käkitijo, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Xch'aw k'u ri Jesús, xub'ij chke: Chiya ix ri käkitijo, —xcha chke. Xkib'ij ru tijoxelab' che: ¿Jas ta k'u käqa'no? ¿A kujkowin ta lo kuje'k keqaloq' kieb' cientos quetzales kaxlan wa che tzuqub'al ke we winaq ri'? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Xuta' k'u ri Jesús, xub'ij chke: ¿Janipa' kaxlan wa e k'o iwuk'? ¡Jiwilampe'! —xcha chke. Aretaq xketamaj, xkib'ij: Xa job' kaxlan wa e k'olik, xuquje' kieb' kär, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Xtaqan k'u ri Jesús chi ket'uyi ri winaq pa taq mulaj cho ri räxalaj uwosaq. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Xet'uyi k'ut pa taq mulaj, pa taq ciento, pa nik'iaj taq ciento. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ri Jesús xeuk'am k'u ri job' kaxlan wa xuquje' ri kieb' kär, xka'y chikaj, xeutewchij. Te k'u ri' xeupir ri kaxlan wa, xeuya chke ru tijoxelab' rech kekijach wa' chkiwäch ri winaq. Xuquje' ri kieb' kär xeujach chkiwäch konojel. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Xewi' k'u konojel, xenoj k'ut. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Te ri' xekik'ol ri ch'äqataq taq kaxlan wa, xuquje' ri ch'äqataq kär ri xekanaj kanoq. Xub'an kab'lajuj chikäch wa chi ronojel. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","E job' mil achijab' k'ut ri e k'o chkixol ri winaq ri xewi'k, ri xkitij ke ri wa. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Te k'u ri' ri Jesús xub'ij chke ru tijoxelab' chi utz we keb'ok pa ri barco rech keb'e'k, kenab'ej apanoq chuwäch ri Are' pa ri tinimit Betsaida ch'äqäp che ri mar. Are k'u ri Jesús xkanaj kan kuk' ri k'ialaj winaq che ki jachik b'ik. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","E jachtajinaq chi k'u b'i ri winaq rumal ri Jesús, xe' ri Are' pa ri juyub' chub'anik orar. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Are chi' ri tajin kok ri aq'ab', ri tijoxelab' e k'o pa ri barco puwi' ri ja' pu nik'iajal ri mar. Are k'u ri Jesús u tukiel k'o kan chuchi' ri mar. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Xrilo chi ru tijoxelab' tajin käkiriq k'äx chub'inisaxik ri barco rumal chi chkiwäch petinaq wi ri kiäqiq'. Xa jub'iq' kraj man käsaqirik aretaq xopan ri Jesús kuk', tajin käb'in puwi' ri ja'. U chomam ri Jesús chi xa kok'ow chkiwäch. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Aretaq ri tijoxelab' xkilo chi käb'in ri Jesús puwi' ri ja', xkichomaj k'ut chi are jun xib'inel wa'. Xexib'ix k'u rumal, xkiraq k'u ki chi'. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Je ri', rumal chi konojel xkilo, sib'alaj xkixej kib'. Chanim ri Jesús xeuch'ab'ej, xub'ij chke: In wa', ¡mixej iwib', chichajij iwanima'! —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Xok k'u b'i ri Jesús pa ri barco kuk' ru tijoxelab', xtäni k'u ri kiäqiq'. Sib'alaj k'u xkikajmaj wa' ri tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Man okinaq tä k'u pa ki jolom jas kel kub'ij ri kajmab'al ri xub'an ri Jesús aretaq xujach ri kaxlan wa chke ri winaq, xane xa ab'ajarinaq ri kanima'. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","E q'axinaq chi ch'äqäp che ri mar, xeopan chuchi' ri ulew pa Genesaret, xkixim k'u ri ki barco chila' chuchi' ri mar. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Aretaq xeb'el b'i pa ri barco, ri winaq chanim xkich'ob' u wäch ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Xeb'inlob'ik, xekisolij konojel taq ri tinimit chila'. Are k'u ri winaq xkichaplej ki k'amik loq ri yawab'ib' cho taq alaj taq ch'at jawije' chi' ri käkito chi k'o wi ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Apawije' chi' k'ut ri xopan wi ri Jesús, we pa taq alaj taq tinimit, we pa nimaq taq tinimit, we k'u pa taq juyub', xeyi' ri yawab'ib' pa taq ri b'e, xkib'ochi'j k'u ri Jesús chi xuwi ta ne kuya chke chi käkichap koq u chi' ru q'u'. Konojel k'u ri xechapowik xeutzir kanoq. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ri tata'ib' fariseos xuquje' jujun chke ri tata'ib' tijonelab' re ri Pixab' ri e petinaq pa ri tinimit Jerusalén xkimulij kib' chrij ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Xekil k'ut chi jujun chke ru tijoxelab' ri Jesús käkitij ri ki wa, man käka'n tä k'u ke ri e naq'atal wi ri fariseos. Are wa' ri u ch'ajik ri rij ri ki q'ab', na'l käka'n che. Tzel k'u xkil wa' ri fariseos, xeyoq'on chke ru tijoxelab' ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Je ri', rumal chi ri tata'ib' fariseos, xuquje' konojel ri nik'iaj winaq aj Israel na'l käkich'aj ri rij ki q'ab', te k'u ri' kewi'k. Xaq are ki k'amom ri e naq'atal wi ri ki nan ki tat ojer. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Xuquje' aretaq ketzelej loq pa ri k'ayib'al, we man käkich'aj tä kib', man kewi' taj. E k'o k'u k'ia ri e naq'atal wi ri käka'n ri e are', je' jas ri ki ch'ajik ri vasos, ri t'uy, ri ch'ich' taq laq, xuquje' taq ri ki ch'at. (Xa rumal ri e naq'atal wi ri tata'ib' fariseos, xkib'ij chi äwas ri' we man käka'n tä ke ri winaq jas ri käka'n ri e are'.) ");
INSERT INTO qucNNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Rumal wa' ri fariseos xuquje' ri tijonelab' re ri Pixab' xkita' che ri Jesús, xkib'ij che: ¿Jas che man käka'n tä ri tijoxelab' la jas ri e naq'atal wi ri qa nan qa tat ojer? —kecha'. Xane kewi'k, man na'l taj käka'n chuch'ajik ri rij ri ki q'ab' nab'e, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Xch'aw k'u ri Jesús, xub'ij chke: Qas tzij ri xub'ij ri qa mam Isaías ri q'alajisal re ru Loq' Pixab' ri Dios ojer chij alaq. Are la' chi xa kieb' wäch alaq, jas ri tz'ib'tal rumal, ri kub'ij: We winaq ri' xaq che ki chi' käkinimarisaj nu q'ij, man qas käkijikib'a' ri kanima' chwij, —kächa ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Xaq loq' keq'ijilan chwe. Käkiya che tijonik xaq xuwi ri ki pixab' ri winaq, —kächa ri', —xcha ri qa mam Isaías. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Je ri', rumal chi ri alaq yo'm kan alaq ru Loq' Pixab' ri Dios. Chuk'exwäch k'u wa', xa jikib'am anima' alaq chkij ri e naq'atal wi ri winaq, je' jas ri na'l ki ch'ajik ri t'uy, ri vasos, xuquje' k'ia u wäch ri e je' taq wa' ri naq'atal wi alaq, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Xuquje' xub'ij chke: Ri alaq man nim tä chik kil wi alaq ru taqanik ri Dios. Man k'o tä chi u patän wa' chuwäch alaq. Chuk'exwäch wa' käb'an alaq xa jas ri naq'atal wi alaq, —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","U b'im k'u kan ri qa mam Moisés: “Nim cheawila wi ra nan a tat,” —kächa'. U b'im xuquje': “Jachin k'u ri kuyoq' ru nan u tat, tzrajwaxik käkämisax na wa',” —kächa ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ri alaq k'ut käb'ij alaq: Xaq xuwi rajwaxik chi kub'ij jun achi che ru nan u tat: “Are Corbán wa' ronojel ri kinkowinik kinkoj che to'ik alaq,” —kächa chke. (Ri “Corbán” kel kub'ij: “Yo'm cho ri Dios”, —kächa'.) ");
INSERT INTO qucNNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","We je' kub'ij wa' ri achi ri', man käya tä alaq che chi k'o jas kub'an che ki to'ik ru nan u tat. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Je ri' man nim tä chik kil wi alaq ru Tzij ri Dios, man k'o tä chi u patän ru Loq' Pixab' ri Dios chuwäch alaq. Xaq xuwi chkij taq ri naq'atal wi alaq käya wi alaq tijonik. Xuquje' k'ia ri je' taq wa' käb'an alaq, —xcha ri Jesús chke ri tata'ib' ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ri Jesús xeusik'ij ri winaq ruk' jumul chik, xub'ij k'u chke: Alaq, onojel alaq, tatab'ej alaq ri nu tzij, ch'ob'o alaq ri kinb'ij, —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Man k'o tä ri kutij ri winaq ri käkowinik käretzelaj u wäch ru k'aslemal. Xane are ri kel loq pa ranima' ri winaq, are wa' ri ketzelan u wäch ru k'aslemal. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","We k'o jun ri kujikib'a ranima' chutatab'exik ri nu tzij, ¡chutatab'ej b'a'! —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Okinaq chi ri Jesús pa ri ja, u yo'm k'u kan ri winaq, xepe ru tijoxelab', xkita' che ri Are' chrij ri k'utb'al ri xutzijoj chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Xuta' k'u ri Jesús chke, xub'ij: ¿A xuquje' ne ri ix man kich'ob' tä wa'? —kächa'. ¿A mat iwetam chi ronojel ri kutij ri winaq, ri kok chupam, man käkowin tä wa' che retzelaxik u wäch ru k'aslemal? ");
INSERT INTO qucNNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Are je ri', rumal chi man kok tä pa ranima', xane xaq xuwi pa ri rixko'l, kel k'u kanoq aretaq kub'an ru chul, —xcha chke. Xub'ij wa' chke chuk'utik chi man k'o tä jun u wäch wa ri äwas u tijik, ri ketzeletaj jun winaq rumal. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Xuquje' xub'ij: Ri kel loq pa kanima' ri winaq are wa' ri ketzelan u wäch ri ki k'aslemal. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Je ri', rumal chi pa kanima' ri winaq, keb'el wi loq ri itzel taq ki chomanik, xuquje' ri etzelal ri käka'n ri e are' ri e je' taq wa': ru b'anik ri nimalaj mak ruk' ri rixoqil o ri rachajil jun chik, ru b'anik jas ri käka'n ri tz'i' ri xaq käkiriq kib', man k'o tä ki pixab', xuquje' ru b'anik ri kämisanik, ");
INSERT INTO qucNNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ri elaq'anik, ru rayixik ri kech nik'iaj winaq chik, ri etzelal, ri sub'unik, ri sak'ajil chub'anik ronojel u wäch etzelal, ri k'äx kuna' jun chrij jun winaq chik ri utz u riqom, ru yakik tzij chrij jun chik, ru b'anik nimal, xuquje' ri man kuya' tä jun chi kok tzij pu jolom, xane xa kub'an re ri are'. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Konojel wa' we etzelal ri' keb'el loq pa kanima' ri winaq, ketzeletaj k'u ri ki k'aslemal kumal, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Xel b'i ri Jesús chila', xe'k, xopan pa Fenicia chunaqaj ri tinimit Tiro, xuquje' ri tinimit Sidón. Xok k'u b'i pa jun ja. Man kraj taj chi ri winaq käketamaj chi k'o chila', man käkowin tä k'ut chuk'u'ik rib'. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Chanim k'ut xretamaj jun ixoq chi ri Jesús k'o chila'. Ri ixoq ri' k'o jun alaj ral ali ri k'o jun itzelalaj espíritu che. Xopan k'u ruk' ri Jesús, xxuki chuwäch. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ri ixoq ri' man are tä aj Israel, xane ilom u wäch pa Fenicia, ch'äqäp re ri Siria. Xub'ochi'j ri Jesús, xuta' toq'ob' che chi käresaj b'i ri itzel espíritu che ri ral ali. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Xub'ij k'u ri Jesús che: Cheyej na la rech nab'e käyi' ri ki wa ri ak'alab', chenoj k'u na ri e are'. Man utz tä ru chapik ri ki wa ri ak'alab', käk'iäq ta k'u chkiwäch ri alaj taq tz'i', —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Xch'aw k'u ri ixoq, xub'ij che ri Jesús: ¡Je', Tat! Xuquje' ne ri alaj taq tz'i' ri keb'ok pa ja käkitij ru xe'r taq ri ki wa ri ak'alab', —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Xub'ij k'u ri Jesús che ri ixoq: Rumal we tzij ri' ri xb'ij la, kuya' ke' la cho ja. Elinaq chi k'u b'i ri itzel espíritu che ri alaj ali ri al la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Xe' k'u ri ixoq cho ja. Aretaq xopanik xuriqa ri ral q'oyol pa ru ch'at, elinaq chi k'u b'i ri itzel espíritu che ri alaj ali. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Xel k'u b'i ri Jesús chila' chunaqaj ri tinimit Tiro, xok'ow pa ri tinimit Sidón, xuquje' pa taq ri tinimit re Decápolis, xopan k'u chuchi' ri mar re Galilea. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Aretaq k'o chila' xk'am loq jun so'r achi ri xuquje' mem ruk' ri Jesús. Ri xek'amow loq keb'ochi'nik, käkita' toq'ob' che ri Jesús chi kuya ru q'ab' puwi' ri achi. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ri Jesús xuk'am k'u b'i ri achi chkiwäch ri winaq pu tukiel wi. Xeunim ru wi' taq u q'ab' pa taq ru xikin ri achi, xuquje' xchub'anik, xuchap koq ri raq'. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Xka'y k'u ri Jesús chikaj, xb'iq'b'itik, xub'ij che ri achi: ¡Efata! —xcha'. Kel kub'ij wa': ¡Chjaqtajoq! —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Chanim k'ut xejaqtaj ru xikin ri achi, xuquje' xutzir ri raq'. Käkowin chi k'ut kätzijonik. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ri Jesús k'ut keupixb'aj ri winaq chi k'o jun mäkib'ij wi. Pune sib'alaj keupixb'aj na, xa sib'alaj käkesaj na u tzijol wa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Sib'alaj k'u käkikajmaj ri winaq, käkib'ij: ¡Sib'alaj utz kub'an ri Jesús che ronojel! Kub'ano chi käkita chik ri so'rab', xuquje' kub'ano chi ri memab' kech'awik, —xecha ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Pa taq ri q'ij ri', ki mulim kib' sib'alaj k'ia winaq jumul chik, man k'o tä k'u ri käkitijo. Ri Jesús xeusik'ij ru tijoxelab', xub'ij chke: ");
INSERT INTO qucNNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Kel nu k'ux chke ri winaq rumal chi oxib' q'ij chi wa' e k'o wuk', man k'o tä k'u jas käkitijo. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","We kintaqan chke chi keb'e' cho kachoch, mäja' k'u kewi'k, ketzaq na pa taq ri b'e. Jujun k'u chke naj e petinaq wi, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ru tijoxelab' xech'awik, xkib'ij che: ¿Jawije' ta k'u lo käkowin wi jun kuriq ri wa che ki tzuqik wa' we winaq ri' waral pa we juyub' ri' ri kätz'inowik? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Xuta' k'u ri Jesús chke: ¿Janipa' kaxlan wa e k'o iwuk'? —xcha'. Ri e are' xkib'ij: ¡Wuqub'! —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Xtaqan k'u ri Jesús chke ri k'ialaj taq winaq chi keku'b'i pulew. Te k'u ri' xeuk'am ri wuqub' kaxlan wa, xmaltioxinik, xeupiro. Xeuya chke ru tijoxelab' rech kekijach wa' chkiwäch ri winaq. Je k'u ri' xka'no. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Xuquje' e k'o kieb' oxib' alaj taq kär. Ri Jesús xeutewchij ri alaj taq kär, xub'ij chke ru tijoxelab' chi kekijach wa' xuquje' chkiwäch ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Xewi' k'u konojel ri winaq, xenojik. Xekimulij k'u ri ch'äqataq taq kaxlan wa ri xekanaj kanoq, ronojel k'u wa' xub'an wuqub' chikäch wa. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kraj e k'o kiejeb' mil winaq ri xewi'k. Te k'u ri' xeutaq b'i ri Jesús cho kachoch. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Chanim k'ut xok b'i ri Jesús pa ri barco kuk' ru tijoxelab', xeb'e' pa Dalmanuta. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Xeopan k'u ri tata'ib' fariseos ruk' ri Jesús, xkichap tzij ruk'. Te ri' xkita' che chi kuk'ut chkiwäch jun kajmab'al etal ri käpe chikaj. Xkib'ij wa' che rech käqaj ri Jesús pa ki q'ab'. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Sib'alaj xb'iq'b'it k'u ri Jesús, xub'ij: ¿Jas che käkita' etal ri winaq re we q'ij junab' ri'? —kächa'. Qas tzij ri kinb'ij chech alaq chi man käyi' tä chi na jun etal chke, —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Xel b'i ri Jesús chkiwäch. Xok chi jumul pa ri barco, xe' k'u ch'äqäp che ri mar. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Xsach pa ki jolom ri tijoxelab' u k'amik b'i ki wa. Xaq xuwi jun kaxlan wa k'o kuk' pa ri barco. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ri Jesús xeupixb'aj, xub'ij chke: ¡Chitampe'! ¡Chichajij iwib' chuwäch ri ki ch'amil ri tata'ib' fariseos, xuquje' chuwäch ru ch'amil ri Herodes! —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Xkitzijob'ela k'u kib' ri tijoxelab', xkib'ij: Ri Are' kub'ij wa' rumal chi man k'o tä qa wa qa k'amom loq, —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Aretaq ri Jesús xretamaj jas ri tajin käkib'ij, xub'ij chke: ¿Jas che kitzijob'ela iwib' chi man k'o tä i wa? —kächa chke. ¿A xaq are mäja' kich'ob'o, mäja' kiwetamaj? ¿A xa ab'ajarinaq na ri iwanima'? —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Pune k'o i waq'äch rech kixka'yik, ¡man kixka'y taj! Pune k'o i xikin rech kito, ¡man kitatab'ej taj! ¿A mat käna'taj wa' chiwe ri xinb'ano? —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Aretaq xinpir ri job' kaxlan wa, xinjach k'u wa' chkiwäch ri job' mil winaq, ¿janipa' chikäch nojinaq chke ch'äqataq taq wa ri man xk'is taj ri xeik'olo? —xcha chke. ¡E kab'lajuj! —xecha ri e are'. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Aretaq k'ut xinpir ri wuqub' kaxlan wa, xinjach wa' chkiwäch ri kiejeb' mil winaq, ¿janipa' chikäch nojinaq chke ch'äqataq taq wa ri man xk'is taj ri xeik'olo? —xcha chke. ¡E wuqub' chikäch! —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Xub'ij k'u ri Jesús chke: ¿Jas lo wa' chi k'ä mäja' kich'ob'o? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Te k'u ri' xopan ri Jesús pa ri tinimit Betsaida, e rachi'l k'u ru tijoxelab'. Jujun winaq xkik'am loq jun moy achi cho ri Jesús, xkib'ochi'j chi kuchap koq ri achi. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ri Jesús xuchap ri moy che ru q'ab', xuyuqej b'ik, xeb'el k'u b'i pa ri tinimit. Xchub'an k'u pa taq u waq'äch ri moy, xuya ru q'ab' puwi' ri achi, xuchap koq ru waq'äch, te k'u ri' xuta' che: ¿A k'o ri kil la? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Are k'u ri moy xka'y aq'anoq, xub'ij: Kinwil ri winaq chi je' ta ne e che', kinwil k'ut chi keb'inik, —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ri Jesús xuya chi jumul ru q'ab' puwi' ri achi, xuchap koq ru waq'äch. K'ä te ri' qas xka'yik. Xutzir kan ru waq'äch, utz chik xkowin ri achi che rilik ronojel. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Te k'u ri' ri Jesús xutaq b'i cho rachoch, xub'ij b'i che: Utz na we man kok tä la pa ri tinimit, man k'o tä k'u ri kätzijoj la apan che jun chik jas ri nu b'anom che la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Xe' k'u ri Jesús, e rachi'l ru tijoxelab', xeopan pa taq ri tinimit re Cesarea Filipo. B'enam k'u ke pa ri b'e, xuta' chke ru tijoxelab', xub'ij: ¿Jachin ri in ri käkib'ij ri winaq? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Xkib'ij k'u che: E k'o jujun winaq käkib'ij chi lal ri' ri Juan Qasal Ja', —kecha'. Xuquje' käkib'ij jule' chik chi lal ri' ri qa mam Elías. E k'o chi nik'iaj käkib'ij chi lal jun chke ri ojer q'alajisal taq re ru Loq' Pixab' ri Dios, —kecha', —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Te ri' xch'aw ri Jesús jumul chik, xuta' chke: E k'u ri ix, ¿jachin ri in ri kib'ij ix? —xcha chke. Xch'aw k'u ri tat Pedro, xub'ij che: ¡Lal ri' ri Cristo! —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Xeupixb'aj k'ut ri Jesús chi mäkitzijoj wa' che jachin jun. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ri Jesús xuchaplej ki tijoxik ru tijoxelab', xub'ij chke: Rajwaxik chi ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, kinriq na sib'alaj k'äx, kinxutux na kumal ri ki nimaqil ri winaq, kumal ri ki nimaqil sacerdotes, xuquje' kumal ri tijonelab' re ri Pixab'. Xuquje' rajwaxik chi kinkämisax na, te ri' kink'astaj chi k'u na churox q'ij chkixol ri käminaqib', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Utz u b'ixik wa' xub'an ri Jesús rech käkich'ob'o. Are k'u ri tat Pedro xuk'am b'i ri Jesús u tukiel wi, xuchaplej u yajik. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Xutzolq'omij k'u rib' ri Jesús, xeuka'yej ru tijoxelab', xuyaj ri tat Pedro, xub'ij che: ¡Chatel chnuwäch, Satanás! —kächa ri Jesús. ¡Man kach'ob' tä k'u ru chomanik ri Dios, xane xaq xuwi kach'ob' ri ki chomanik winaq! —xcha ri' chkiwäch. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ri Jesús xeusik'ij ri k'ialaj winaq junam kuk' ru tijoxelab', xub'ij k'u chke: We k'o jun kraj käpe wuk' in, rajwaxik chi mub'an xa jas ri kraj ri are'. Rajwaxik chutelej ru cruz, chpet wuk' in, —kächa'. (Kel kub'ij wa' chi ri winaq ri' man nim tä chik käril wi ru k'aslemal, pune ta ne kuriq ri kämikal rumal rech ri Jesús.) ");
INSERT INTO qucNNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Apachin ta ne ri kraj kuto' u wi' ru k'aslemal cho ruwächulew, käkäm k'u na wa' we winaq ri', kutzaq na ronojel. Man kuriq tä na ri' ri k'aslemal ri man k'o tä u k'isik. Apachin ta ne ri kuya ru k'aslemal rumal wech in, xuquje' rumal rech ri Utzalaj Tzij re ri Evangelio, kuto' na u wi' ri qas u k'aslemal, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Jas ta k'u lo ri' ri kuch'ak jun winaq we kärechb'ej ronojel ruwächulew, kutzaq k'u na ri qas u k'aslemal? ");
INSERT INTO qucNNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Jas ta k'u lo ri käkowin ri winaq chuya'ik chuk'exwäch ri qas u k'aslemal? —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Apachin k'ut ri käk'ix chwe in xuquje' che ri nu tzij chkiwäch ri itzelalaj taq winaq rech we q'ij junab' ri', ri man keniman tä chi che ri Dios, xane xa käka'n jas ri käkaj ri e are', in ri' ri Ralk'ual ri Dios ri Qas Winaq, kink'ix na xuquje' che ri winaq ri' aretaq kintzelej loq, kinpe k'u na ri' wachi'l ri loq'alaj taq ángeles, känimarisax k'u na nu q'ij jas ru nimarisaxik u q'ij ri nu Tat, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Te k'u ri' xub'ij ri Jesús chke konojel: Qas tzij ri kinb'ij chiwe chi e k'o jujun chke ri e k'o waral chnuwäch ri man kekäm taj k'ä käkil na chi ya petinaq ri' ruk' nimalaj chuq'ab' ru taqanik ri Dios pa ki wi' ri winaq, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Xke' waqib' q'ij chik u b'im kan wa' ri Jesús, aretaq xeuk'am b'i xaq xuwi ri tat Pedro, ri tat Jacobo, xuquje' ri tat Juan ki tukiel wi, xepaqi k'u puwi' jun nimalaj juyub'. Xk'extaj k'u ru ka'yeb'al ri Jesús chkiwäch. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Sib'alaj xjuluw ri ratz'iaq ri Jesús, sib'alaj saqloloj je' jas ri saq tew, je ri' chi man k'o tä jun ch'ajal atz'iaq cho ruwächulew ri je' käkowin chusaqarisaxik wa' kub'ano. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tzkajmab'al chik, xkik'ut kib' kieb' achijab' ri tajin ketzijon ruk' ri Jesús, e are k'u ri qa mam Elías rachi'l ri qa mam Moisés. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Xch'aw ri tat Pedro, xub'ij k'u che ri Jesús: Qajtij, ¡sib'alaj utz chi uj k'o waral! Qa'na oxib' mo', jun che la, jun che ri qa mam Moisés, xuquje' jun che ri qa mam Elías, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Je' xub'ij wa' rumal chi man kuriq taj jas kub'ij, ¡sib'alaj k'u xkixej kib' ri tijoxelab'! ");
INSERT INTO qucNNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Te ri' xqaj jun sutz' chkij, xech'uqtaj k'u rumal. Xch'aw k'u loq jun chupam ri sutz', xub'ij: ¡Are loq'alaj nu K'ojol wa'! Chitatab'ej ri kub'ij, —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Chanim xeka'ylob'ik, man k'o tä chi k'u jachin ri xkilo, xane xaq xuwi ri Jesús k'o kuk'. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Qajem ke cho ri juyub', ri Jesús xeupixb'aj chi k'o mäkitzijoj wi ri kilom, k'ä aretaq käk'astaj na ri Are', ri Ralk'ual ri Dios ri Qas Winaq, chkixol ri käminaqib'. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Xeniman k'u che ri Jesús, man k'o tä xkib'ij che jun chik jas ri' ri xkik'ulmaj. Xa xkitzijob'ej kib' chkixol chi jas ri' ri k'astajik chkixol ri käminaqib'. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Xkita' k'u che ri Jesús, xkib'ij che: ¿Jas che käkib'ij ri tijonelab' re ri Pixab' chi rajwaxik käpe na ri qa mam Elías nab'e? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Xch'aw ri Jesús, xub'ij chke: Tzij ri' chi käpe ri qa mam Elías nab'e, rech kub'an na u b'anik ronojel. ¿Jas k'u kub'ij ru Loq' Pixab' ri Dios ri Tz'ib'talik chwij in, in ri' ri Ralk'ual ri Dios ri Qas Winaq? Tz'ib'am chi sib'alaj kinriq na k'äx, ketzelax k'u na nu wäch, —kächa ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kinb'ij k'u chiwe chi ya ulinaq ri tat Elías, xka'n k'u ronojel u wäch k'äx che ri are', xa jas ri xkaj xka'no, je' jas ri kub'ij chrij pa ru Loq' Pixab' ri Dios ri Tz'ib'talik, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Te k'u ri' aretaq xetzelej loq, xeopan kuk' ri nik'iaj tijoxelab' chik, xekil k'ialaj taq winaq ki sutim kij ri tijoxelab', xuquje' e k'o jujun chke ri tijonelab' re ri Pixab' ki chapom tzij kuk'. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Aretaq ri winaq xkil ri Jesús, sib'alaj xkikajmaj u wäch, aninaq xeb'e' chuch'ab'exik. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Xuta' ri Jesús chke ru tijoxelab', xub'ij: ¿Jas wa' ri tajin kichomala kuk'? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Jun chke ri winaq xch'awik, xub'ij che: Ajtij, xink'am loq ri nu k'ojol chuwäch la, rumal chi k'o jun itzel espíritu che, ri u b'anom che chi man käkowin taj käch'awik. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Apawije' ta ne ri k'o wi aretaq ri itzel espíritu kuchapo, kuk'iäq pulew, chila' kuyakya wi, käpuluw k'u u pu chi', xuquje' kuquch'uch'ej u ware, käche'r k'u u cuerpo. Xinta' toq'ob' chke ri tijoxelab' la rech käkesaj b'i ri itzel espíritu che, man xekowin tä k'ut, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Xch'aw chi ri Jesús, xub'ij: ¡Ay, winaq, alaq ri' rech we q'ij junab' ri', man käkojon tä alaq! —kächa'. ¿A are lo kaj alaq chi xaq are' kink'oji uk' alaq ronojel q'ij, chi kinchajij paciencia uk' alaq? —kächa'. ¡K'ama b'a' alaq loq ri ala chnuwäch! —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Xkik'am k'u loq ri ala ruk'. Aretaq ri itzel espíritu xril ri Jesús, chanim xuyakya ri ala, xtzaq k'u ri ala pulew, xuwolqotij rib', xpuluw u pu chi'. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Xuta' ri Jesús che ru tat ri ala, xub'ij: ¿Jampa' xuchap wa' we k'äx ri'? —xcha che. Xub'ij ru tat: Tzpa ru ch'utinal, —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","K'ia mul ri itzel espíritu kuk'iäq ri ala pa ri q'aq', pa ri ja' chukämisaxik. We k'u k'o jas ri käkowin la chub'anik che, toq'ob'isaj la qa wäch, ¡chujto' la! —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Xub'ij k'u ri Jesús che: We käkowin la käkojon la chwe, ¡ronojel kuya' käb'anik rumal ri winaq ri käkojonik! —xcha ri Jesús che. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Chanim ru tat ri ala ko xch'awik, xub'ij: ¡Tat, kinkojonik! ¡Chinto' b'a' la rech kinkojon na más! —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Aretaq ri Jesús xrilo chi k'ia winaq tajin käkimulij kib' chrij, xuyaj ri itzelalaj espíritu, xub'ij che: Itzelalaj espíritu ri kab'an mem, ri xuquje' kab'an so'r chke ri winaq, katintaqo chi chatel che ri ala, ¡matok chi jumul che! —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Xuraq k'u u chi' ri itzelalaj espíritu, sib'alaj xuyakya kan ri ala, xel k'u b'i che. Xkanaj kan ri ala je' ta ne käminaq, je ri' chi e k'ia ri xkib'ij: ¡Xkämik! —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ri Jesús k'ut xuchap ri ala che ru q'ab', xuyako. Xtak'i k'u aq'an ri ala. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Okinaq chi k'u ri Jesús pa jun ja, xepe ru tijoxelab', xkita' che ri Jesús pu tukiel wi, xkib'ij: ¿Jas che ri uj man xujkowin tä che resaxik b'i ri itzelalaj espíritu? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Xub'ij k'u ri Jesús chke: Xaq xuwi rumal ru b'anik orar xuquje' ri u b'anik ayunar kel b'i jun itzelalaj espíritu ri je' u b'anik wa', —xcha ri Jesús chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Aretaq xeb'el b'i chila', xeb'e'k, xeok'ow k'u pa Galilea. Man kraj tä k'u ri Jesús chi k'o jun käretamaj chi k'olik. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Je ri', rumal chi ri Jesús tajin keutijoj ru tijoxelab', xub'ij chke: Ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, kinjach k'u na in pa ki q'ab' ri winaq, kinkikämisaj na ri e are', —kächa'. Pune in käminaq chik, kink'astaj k'u na churox q'ij chkixol ri käminaqib', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ri e are' k'ut man xkich'ob' tä ri tajin kub'ij chke, xkixej k'u kib' chuta'ik che. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Xeopan k'u pa ri tinimit Capernaum. Aretaq ri Jesús ya k'o chik pa ri ja, xuta' chke ru tijoxelab', xub'ij: ¿Jas ri' ri tajin kichomala iwib' chrij aretaq uj petinaq pa ri b'e? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Man xech'aw tä k'ut rumal chi ri e are' tajin käkichomala' kib' pa ri b'e chrij jachin chke are ri nim na u b'anik. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Xt'uyi k'u ri Jesús, xeusik'ij ri kab'lajuj u tijoxelab', xub'ij chke: We k'o jun ri kraj kok che ki nimal ri winaq, rajwaxik kub'ano chi man nim tä u b'anik chkixol, xane kok na che patänil ke konojel, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Xuk'am k'u ri Jesús jun alaj ak'al, xutak'ab'a pa ki nik'iajal ri tijoxelab'. Xuq'aluj k'ut, xub'ij chke: ");
INSERT INTO qucNNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Apachin ri käk'amow we ak'al ri' rumal wech in, in ri' kinuk'amo. Apachin k'u ri kinuk'am in, man xaq xuwi tä ri in kinuk'amo, xane xuquje' are kuk'am ri xintaqow loq, —xcha chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Xub'ij k'u ri tat Juan che ri Jesús: Ajtij, qilom jun achi ri man jun tä quk' ri tajin kukoj ri b'i' la che kesaxik b'i ri itzel taq espíritus. Ri uj xqaq'il k'u kanoq rumal chi man jun tä quk', —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Xub'ij k'u ri Jesús: Miq'ila chik, —kächa'. Rumal chi man k'o tä jun ri kukoj ri nu b'i' chub'anik jun nimalaj kajmab'al, te k'u ri' chanim kub'ij tzij ri man utz taj chwij in. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Apachin k'u ri man kujuk'ulelaj taj, are jun ri' quk', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Apachin ri kuya jun vaso joron chiwe pa ri nu b'i' rech kitijo xa rumal chi ix rech ri Cristo, qas kuriq na ri tojb'al re, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Apachin k'u ri kub'ano chi jun chke we ch'utiq ri' ri kekojon chwe kuriq ri b'e ri man utz taj, are utz ri' we ta käxim jun ka' re molino chuqul ri winaq ri', käk'iäq ta k'u b'i pa ri mar. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","We ta ra q'ab' kub'ano chi ri at kariq ri b'e ri man utz taj, chaq'ata apanoq. Are utz na chawe we kariq na ri qas a k'aslemal pune at kut, chuwäch ri k'o kieb' a q'ab' kate' pa ri k'atik jawije' k'o wi ri q'aq' ri man kächuptaj taj. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Chila' k'ut man kekäm tä wi na ri ixjut ri käkitij ri ki tijol ri winaq, man kächuptaj tä k'u ri q'aq'. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","We ta ri awaqan kub'ano chi at kariq ri b'e ri man utz taj, chaq'ata apanoq. Are utz na chawe we kariq na ri qas a k'aslemal, pune xa jun awaqan k'olik, chuwäch ri k'o kieb' awaqan katk'iäq b'i pa ri k'atik jawije' k'o wi ri q'aq' ri man kächuptaj taj. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Chila' k'ut man kekäm tä wi na ri ixjut ri käkitij ri ki tijol ri winaq, man kächuptaj tä k'u ri q'aq'. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","We ta k'u ra waq'äch kub'ano chi ri at kariq ri b'e ri man utz taj, chawesaj apanoq. Are utz na chawe katok chkixol ri winaq ri kätaqan ri Dios pa ki wi', pune xa jun a waq'äch k'olik, chuwäch ri k'o kieb' a waq'äch, katk'iäq b'i pa ri k'atik jawije' k'o wi ri q'aq' ri man kächuptaj taj. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Chila' k'ut man kekäm tä wi na ri ixjut ri käkitij ri ki tijol ri winaq, man kächuptaj tä k'u ri q'aq'. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Konojel winaq käkiriq na k'äx je' ta ne chi käyi' q'aq' pa ki wi' junam jas ri käyi' ri atz'am puwi' ronojel awaj ri käkämisax chusipaxik cho ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Utz ri atz'am. We k'u man k'o tä chik u tzayil ri atz'am, ¿jas ta k'u lo kikoj chik chutzayixik? Chk'ol utzil pa iwanima' je' jas ri utzalaj atz'am, man kixch'ojin tä k'ut, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Xel k'u b'i ri Jesús pa ri tinimit Capernaum, xe' pa Judea, xuquje' xe' ch'äqäp che ri nima' Jordán. Xkimulij k'u kib' k'ia winaq ruk' jumul chik. Ri Jesús jumul chik xeutijoj jas ri naq'atal wi ri Are'. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Xeopan k'u jujun tata'ib' fariseos ruk' ri Jesús, xkita' k'u che we taqal che jun achi kujach b'i ri rixoqil. Xa xkib'ij wa' che ri Jesús rech käqaj ri Are' pa ki q'ab'. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Xch'aw ri Jesús, xub'ij chke: ¿Jas pu ri xtaq wi alaq rumal ri qa mam Moisés? —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Xkib'ij k'u ri tata'ib' fariseos: Ri qa mam Moisés xuya' chqe chi jun achi kuya' kutz'ib'aj jun wuj ri kub'ij wi chi ri achi kujach b'i ri rixoqil, xa je ri' k'ut käjach b'i ri ixoq, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Xub'ij k'u ri Jesús chke: Xa rumal chi sib'alaj ab'ajarinaq ri anima' alaq, are rumal ri' xtz'ib'ax wa' we taqanik ri' chech alaq rumal ri qa mam Moisés, —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tzpa ru chaplexik loq ronojel, aretaq ri Dios xuchap u b'anik ruwächulew, “chi achi chi ixoq xeub'an ri Dios”. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Rumal wa' jun achi kuya kan ru nan u tat, kätuni k'u na ruk' ri rixoqil. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Xa e jun na ri kieb' ri',” —kächa ri'. Je k'u ri' man e kieb' tä chik, xane xa e jun wa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Rumal k'u ri' jas ri xeutunub'a ri Dios, mäjach ki wäch wa' rumal ri winaq, —xcha ri Jesús chke ri tata'ib' fariseos. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Aretaq e k'o chik pa ja, ri tijoxelab' xkita' che ri Jesús chi kub'ij chi na jumul chik jas kel kub'ij ri' ri xtzijox rumal. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Xub'ij k'u ri Jesús chke: Apachin ri kujach b'i ri rixoqil, käk'uli chi k'u na ruk' jun ixoq chik, ri achi ri' kub'an ri nimalaj mak ri äwas u b'anik chrij ri nab'e rixoqil. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","We are ri ixoq kujach b'i ri rachajil, käk'uli chi k'u na ruk' jun achi chik, ri ixoq ri' kub'an ri nimalaj mak ri äwas u b'anik chrij ri rachajil, —xcha ri Jesús chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ri winaq xekik'am loq ri ak'alab' cho ri Jesús rech kuya ru q'ab' pa ki wi'. Xeyaj k'u ri winaq kumal ri tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Aretaq xril ri Jesús chi keyajon ri tijoxelab', xpe royowal, xub'ij chke: Chiya chke ri ak'alab' chi kepe wuk', meiq'atej rumal chi ru taqanik ri Dios pa ki wi' ri winaq are kech ri e je' taq wa', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Qas tzij ri kinb'ij chiwe chi apachin ri man kuk'am tä ri' ru taqanik ri Dios je' jas ri kub'an jun alaj ak'al, man käyi' tä k'u che chi kätaqan ri Dios puwi', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ri Jesús xeuq'aluj ri ak'alab', xuya k'u ru q'ab' pa ki wi', xeutewchij. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Aretaq ri Jesús xutaqej chi ru b'e, chanim xpe jun ak'al achi ruk', xxuki chuwäch, xuta' che, xub'ij: Utzalaj Ajtij, ¿jas kinb'an in rech kinriq ri k'aslemal ri man k'o tä u k'isik? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Xub'ij k'u ri Jesús che: ¿Jas che kab'ij utz chwe? ¡Man k'o tä jun qas utz, xane xaq xuwi ri Dios! —kächa che. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Awetam k'u ri kätaqan wi ru Loq' Pixab' ri Dios: “Matkämisanik, mab'an ri nimalaj mak ri äwas u b'anik ruk' ri rixoqil jun winaq chik, mab'an ri elaq', mab'an tzij chrij jun winaq chik, mab'an sub'unik che jun winaq chik che resaxik ri rech ri are', nim cheawil wi ra nan a tat,” —kächa ri', —xcha ri Jesús che. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Xub'ij k'u ri achi che: Ajtij, ronojel wa' nu taqem tzaretaq in ak'al na, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ri Jesús ko xka'y che ri achi, sib'alaj loq' xril wi, xub'ij che: K'o jun jasach chik ri k'ä mäja' kab'ano. Cheak'iyij konojel ri jastaq awe, chaya ri rajil chke ri meb'a'ib'. Käk'oji k'u na ra q'inomal chila' chikaj. Jo', tasa'j wuk', chatelej k'u ra cruz, —xcha che. (Kel kub'ij wa' chi man nim tä chik käril wi ru k'aslemal, pune ta ne kuriq ri kämikal rumal rech ri Jesús.) ");
INSERT INTO qucNNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Xk'extaj k'u ru wäch ri achi, xk'äxk'ob' ri ranima' rumal ri xub'ij ri Jesús che. Xb'isonik xe'k, rumal chi k'ia u q'inomal k'olik. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Xka'y ri Jesús pa taq u xkut, xub'ij chke ru tijoxelab': ¡Sib'alaj k'äx käkitij ri q'inomab' keopan ruk' ri Dios rech kätaqan pa ki wi'! —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ri tijoxelab' xkikajmaj ri xub'ij chke, man xkiriq tä chik jas xka'no. Xch'aw chi jumul ri Jesús, xub'ij chke: Qachalal, qas k'äx käkitij ri winaq ri käku'b'i ri kanima' chrij ri q'inomal, keopan ruk' ri Dios rech kätaqan pa ki wi'. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Are man k'äx tä ri rok'owisaxik jun kiej camello pa ru julil jun t'isomb'al b'aq chuwäch ri ropanik jun q'inom ruk' ri Dios rech kätaqan puwi', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Sib'alaj xkikajmaj wa' ri tijoxelab', xkib'ij k'u chb'il taq kib': ¿Jachin ta k'u lo ri käkowinik kuriq ru tob'anik ri Dios? —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ri Jesús tajin keuka'yej, xub'ij k'u chke: Man kekowin tä ri winaq chub'anik wa', käkowin k'u na ri Dios che, rumal chi ri Dios käkowin chub'anik ronojel, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ri tat Pedro xuch'ab'ej ri Jesús, xub'ij: Tat, chilampe la chi ri uj qa yo'm kan ri jastaq qe, uj k'o uk' la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Xub'ij k'u ri Jesús: Qas tzij ri kinb'ij chiwe chi man k'o tä jun ri kuya kan ri rachoch, ri rachalal, ru nan u tat, ri rixoqil, ri ralk'ual, ri rulew rumal wech in, xuquje' rumal rech ri Utzalaj Tzij re ri Evangelio, ");
INSERT INTO qucNNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ri mat kuriq na kämik pa taq we q'ij junab' ri' jun ciento mul ri e je' taq wa', ri rachoch, rachalal, ru nan, ralk'ual, rulew, pune ruk' k'äx ri käb'antaj che kumal ri winaq. Xuquje' kuriq na ru k'aslemal ri man k'o tä u k'isik pa taq ri q'ij ri junab' ri kepe na, —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","E k'ia chke ri winaq ri nim keil wi kämik, man nim tä chi na keil wi pa ri q'ij ri', xuquje' e k'o ri man nim tä keil wi kämik, nim k'ut keil wi na, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","E b'enaq k'u pa ri b'e, paqalem käka'n pa Jerusalén, nab'ejinaq k'u ri Jesús chkiwäch ru tijoxelab'. Ri e are' sib'alaj xkikajmaj u wäch ri Jesús. Konojel ri e teren chrij sib'alaj kixe'm kib'. Ri Jesús xeusik'ij jumul chik ri kab'lajuj u tijoxelab' ruk' pa ki tukiel wi, xuchaplej k'u u b'ixik chke ri käb'an na che. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Xub'ij k'u chke: Chiwilampe', b'enam qe, tajin kujpaqi pa ri tinimit Jerusalén. Kinjach k'u na in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, pa ki q'ab' ri ki nimaqil ri sacerdotes, xuquje' pa ki q'ab' ri tijonelab' re ri Pixab'. Käkiq'at na tzij pa nu wi' chi kinkämisax na, kinkijach k'u na pa ki q'ab' ri nik'iaj winaq chik. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Käketz'b'ej na nu wäch, xuquje' käkichub'aj na nu wäch. Kinkirapuj na, kinkikämisaj. Kink'astaj chi k'u na churox q'ij, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Xeqeb' k'u ru k'ojol ri tat Zebedeo ruk' ri Jesús, e are' ri tat Jacobo, ri tat Juan, xkib'ij k'u che: Qajtij, käqaj chi käb'an la chqe apachike u wäch toq'ob' ri käqata' che la, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Xub'ij ri Jesús chke: ¿Jas k'u kiwaj chi kinb'an chiwe? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Xkib'ij k'u che: Aretaq känimarisax ri q'ij la, kätaqan chi la pa ki wi' konojel, ya la chqe chi kujt'uyi na uk' la, chi jun chqe käk'oji pa ri wikiäq'ab' la, ri jun chik pa ri moxq'ab' la, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Xub'ij k'u ri Jesús chke: ¡Man kich'ob' taj jas u wäch toq'ob' ri kita' chwe! —kächa chke. ¿A kixkowinik kich'ij na ri k'äx ri kinriq na in, kitij k'u na iwe ri k'o pa ri vaso ri kintij na we in? ¿A kixkowinik käb'an i qasna' ix jas ri qasna' ri käb'an na chwe in? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Xkib'ij k'u che: Kujkowinik, —xecha che. Xub'ij k'u ri Jesús chke: Qas tzij kitij na iwe ri k'o pa ri vaso ri kintij na we in, xuquje' käb'an na i qasna' jas ri qasna' ri käb'an na chwe in, —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Are k'u ri t'uyulem pa ri nu wikiäq'ab', we ne pa ri nu moxq'ab', man kuya' taj kinya in chiwe. Are wa' kech ri e cha'tal rumal ri Dios chi ket'uyi pa taq ri t'uyulib'al ri', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Aretaq ri lajuj tijoxelab' chik xkita u b'ixik ronojel wa', xpe koyowal ri e are' chke ri tat Jacobo, ri tat Juan. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Xeusik'ij k'u ri Jesús, xub'ij chke: Ri ix iwetam chi ri winaq ri ya'tal chke chi ketaqan pa ki wi' ri nik'iaj winaq chik, qas tzij e k'o ri' pa ki q'ab'. Ri ki nimaqil winaq ketaqan pa ki wi' xuquje', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Man je' tä k'u wa' ri ix, xane apachin chiwe ri kraj chi nim kil wi, rajwaxik chi kok na wa' che patänil iwe. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Apachin chiwe ri kraj kok che i nimal ix, nab'e rajwaxik chi kok na che patänil ke konojel, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Are je ri', rumal chi ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, man in petinaq taj rech kinpatänixik, xane rech kinpatänin chke nik'iaj chik, xuquje' rech kinya ri nu k'aslemal che tojb'al re ri ki tzoqopixik k'ia winaq, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Xeopan k'u pa ri tinimit Jericó. Elem chi k'u b'ik kub'an ri Jesús pa Jericó, e rachi'l k'u ru tijoxelab' xuquje' k'ialaj taq winaq chik. K'o k'u jun moy achi, Bartimeo u b'i', t'uyul chi' ri b'e, are k'u jun molonel wa', u k'ojol ri tat Timeo. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Aretaq xuto chi tajin kok'ow ri Jesús aj Nazaret, ko xch'awik, xub'ij: ¡Tat Jesús, ralk'ual kan ri qa mam David, toq'ob'isaj la nu wäch! —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","E k'ia ri winaq ri xkiyajo, xkib'ij che chi chutz'apij u pu chi'. Ri are' k'ut xa man kuta taj, xane más ko na xch'awik, xub'ij: ¡Ralk'ual kan ri qa mam David, toq'ob'isaj la nu wäch! —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Xtak'i k'u ri Jesús, xub'ij: Sik'ij b'a' alaq loq, —xcha chke. Xkisik'ij k'u loq ri moy, xkib'ij che: ¡Chachajij awanima'! ¡Chatwalijoq! Ri Jesús tajin katusik'ij, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ri are' k'ut xuroqij kan ru q'u' jela', chanim xwalijik, xe'k, xopan ruk' ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Xch'aw k'u ri Jesús, xub'ij che: ¿Jas kaj la chi kinb'an che la? —xcha che. Xub'ij ri moy che: Ajtij, kwaj kinka'y jumul chik, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Xub'ij ri Jesús che: Kuya' ke' la. Ya xutzir la rumal chi xkojon la chwe, —xcha che. Chanim k'ut xkowinik xka'yik, xteri b'i chrij ri Jesús pa ri b'e. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Aretaq naqaj chik e k'o wi che ri tinimit Jerusalén, chkiwäch ri tinimit Betfagé ruk' ri tinimit Betania, tajin keok'ow chuxe' ri Ujuyub'al Olivos, ri Jesús xeutaq b'i kieb' chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Xub'ij chke: Jix pa ri alaj tinimit ri k'o apan chqawäch. Aretaq kixopan chila' kiriq na jun burro yuqulik. Man k'o tä jun winaq kiejeninaq chrij, —kächa'. Chikira', chik'ama loq, —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","We k'o jun kub'ij chiwe: ¿Jas che kib'an wa'? —kächa ne chiwe. Chib'ij che: Xa kajwataj che ri Qajaw Jesús, chanim k'ut kutzelej chi na loq che la, —kixcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Xeb'e' k'u ri tijoxelab', xekiriqa k'u ri burro pa ri b'e, yuqul koq chuchi' ri porta. Xkikir k'ut. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Jujun chke ri a tak'atoj chila' xkib'ij chke: ¿Jas kib'ano kikir ri burro? —xecha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ri tijoxelab' xkib'ij chke jas ru b'im b'i ri Jesús. Xyi' k'u chke chi käkik'am b'ik. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Xkik'am k'u b'i ri burro, xkiya che ri Jesús. Xkiya ri ki q'u' chrij, xkiejen k'u ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","E k'ia winaq xkilik' ri ki q'u' pa ri b'e, xuquje' k'o jujun chik ri xekiya u xaq taq che' ri xekich'upula pa taq ri juyub'. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ri winaq ri e nab'ejinaq chuwäch ri Jesús, xuquje' ri e teretoj chrij, ko xech'awik, xkib'ij: ¡Chnimarisax u q'ij ri Dios! ¡Utz re ri petinaq pa ru b'i' ri Qajaw Dios! —kecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Tewchim b'a' ri' ri taqanik ri käpe na pa qa wi'! Tzare wa' ri taqanik ri xchaplex nab'e rumal ri qa mam David. ¡Chnimarisax u q'ij ri Dios! —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Xopan k'u ri Jesús pa ri tinimit Jerusalén, xok pa ri nimalaj rachoch Dios. U ka'ylob'em chik ronojel, b'enaq chi k'u ri q'ij, xel b'ik, xe' pa Betania, e rachi'l ri kab'lajuj u tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Chukab' q'ij k'ut, aretaq tajin ketzelej loq, e petinaq pa ri tinimit Betania, xnum ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Xril k'u apan chinaj jun u che'al higos, räx k'u ru xaq. Xe' ri Jesús che rilik we k'o u wäch kuriqa'. Aretaq xopan ruk' ri che', man k'o tä k'u u wäch xuriqo, xane xaq xuwi ru xaq k'olik. Je ri', rumal chi mäja' ru q'ijol ri higos. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Xch'aw k'u ri Jesús, xub'ij che ri che': K'o jun mätijow chik ra wäch, —xcha che. Xkita k'u wa' ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Te k'u ri', aretaq xeopan pa Jerusalén, xok b'i ri Jesús pa ri nimalaj rachoch Dios, xuchaplej kesaxik b'i ri ajk'ayib', xuquje' ri kekiloq' taq jastaq chupam ri nimalaj rachoch Dios. Xeutzaq ri ki mesa ri k'exal taq puaq, xuquje' xeutzaq ri ki tem ri ajk'ay taq palomäx. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Man xuya' tä k'u ri Jesús chi k'o jun kok'ow chupam ri nimalaj rachoch Dios ri ruk'am reqa'n. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Xeutijoj k'u ri winaq, xub'ij chke: Tz'ib'am k'u wa' pa ru Loq' Pixab' ri Dios, kub'ij: “Ri wachoch in, are jun ja ri käb'an wi orar,” —kuchixik. “Je k'u u kojik wa' kumal konojel winaq,” —kächa ri'. Xuquje' xub'ij ri Jesús: Ri alaq k'ut, jun kachoch elaq'omab' b'anom alaq che, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Xkita k'u wa' ri ki nimaqil sacerdotes xuquje' ri tijonelab' re ri Pixab'. Xa je ri' xkitzukuj jas käka'n chukämisaxik. Je' xka'n wa' rumal chi xkixej kib' cho ri Jesús, rumal chi konojel ri winaq käkikajmaj ru tijonik ri Are'. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Are chi' k'ut tajin kok ri aq'ab', xel b'i ri Jesús pa ri tinimit. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Aq'ab' k'ut, chukab' q'ij tajin keok'ow pa ri b'e, xkilo chi ru che'al higos chaqi'jarinaq chik ronojel. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Xna'taj k'u wa' che ri tat Pedro, xub'ij che ri Jesús: Ajtij, ¡chilampe la! Ru che'al higos ri xyaj la, ya chaqi'jarinaq chik, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Xch'aw k'u ri Jesús, xub'ij chke ru tijoxelab': ¡Tzrajwaxik b'a' kijikib'a iwanima' chrij ri Dios! —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Qas tzij ri kinb'ij chiwe chi apachin ri kub'ij che we nimalaj juyub' ri': “Chawesaj awib' chi', chak'iäqa b'i awib' pa ri nimalaj ja',” —we kächa che. We ta kub'ij wa', man käkieb'lan tä k'u u k'ux, xane kujikib'a u k'ux chi ri kub'ij käb'antaj na, qas käb'antaj k'u na wa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Rumal wa' kinb'ij chiwe chi aretaq k'o kita' che ri Dios aretaq kib'an orar, chijikib'a iwanima' che ri Dios chi kik'amo, käb'antaj k'u na wa' chiwe, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Amaq'el k'ut aretaq kib'an orar, we k'o jun k'äx pa iwanima' chrij jun winaq chik, chisacha u mak, rech ri i Tat ri k'o chikaj kuya' kusach ri i mak ix xuquje'. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","We k'u man kisach tä ki mak nik'iaj chik, ri i Tat ri k'o chikaj man kusach tä ri i mak ix, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Xetzelej chi b'ik, xeb'e' pa ri tinimit Jerusalén. Ri Jesús tajin kub'inib'ej u pam ri nimalaj rachoch Dios, aretaq ri ki nimaqil sacerdotes, ri tijonelab' re ri Pixab', xuquje' ri ki nimaqil ri winaq xeopan ruk'. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Xkib'ij k'u che: ¿Jachin xtaqow la chi käb'an la ronojel wa' we ri'? ¿Jachin lo ri yo'winaq che la chi je' käb'an la wa'? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Xub'ij ri Jesús chke: Ri in xuquje' k'o ri kinta' chech alaq. We käkowin alaq chub'ixik chwe jas ri kinta', kinb'ij na chech alaq jachin ri yo'winaq chwe chi k'o taqanik pa nu q'ab' rech je' kinb'an wa', —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","B'ij alaq chwe jachin xtaqow ri tat Juan chub'anik ri qasna', we are ri Dios o are ri winaq, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Xkichapla u tzijob'exik kib', xkib'ij: We käqab'ij chi are ri Dios xtaqowik, kub'ij na ri Jesús chqe: “¿Jas k'u che man xikoj taj?” —kächa na. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿A käqab'ij ta k'ut chi e are ri winaq xetaqowik? —kecha'. Käkixej k'u kib' chkiwäch ri winaq rumal chi elinaq chi saq chkiwäch ri winaq chi qas tzij ri tat Juan are q'alajisal re ru Loq' Pixab' ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Rumal wa' xkitzelej u wäch u tzij ri Jesús, xkib'ij che: ¡Man qetam taj! —xecha che. Ri Jesús xch'awik, xub'ij chke: Je k'u ri' ri in man kinb'ij tä chech alaq jachin ri yo'winaq chwe chi ri in kinb'an ronojel wa' we ri', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ri Jesús xuchaplej ki tzijob'exik ri winaq kuk' taq k'utb'al, xub'ij k'u chke: K'o jun achi ri xub'an jun tikb'al uvas, xukoralij rij, te k'u ri' xuk'ot jun jul ri käpitz' wi ri uvas, xub'an xuquje' jun tak'atikalaj ja ri käkoj che chajib'al re ronojel, xuya k'u kan pa qajomal chke jujun taq ajchakib', xe' naj pa jun tinimit chik, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Xopan k'u ri q'ij ri käb'an ri cosecha rech uvas, ri ajchaq'el xutaq b'i jun patänil re kuk' ri ajchakib' chuk'amik re ru wächinik ri tikb'al uvas. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Are k'u ri ajchakib' xkichap ri patäninel, xkich'ayo, xkitaq b'ik, man k'o tä xkiya b'i che, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ri ajchaq'el ri tikb'al uvas xutaq k'u b'i jun patäninel chik kuk' ri ajchakib'. Ri e are' k'ut xka'n chi ab'aj ri patäninel ri', xkisok chujolom, xa etzelal xka'n b'i che. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Xutaq chi k'u b'i jun patänil re, ri ajchakib' k'ut xkikämisaj wa', je ri' xuquje' xka'n chke ri jule' u taqo'n chik. Jujun chke xekich'ayo. Jujun chik xekikämisaj. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","K'ä k'o na jun taqo'n chik ruk' ri ajchaq'el, are k'u ri u k'ojol, ri sib'alaj loq' chuwäch. Chuk'isb'al ronojel xutaq b'i wa' kuk' ri ajchakib', xub'ij k'ut: “Qas nim käkil wi na ri nu k'ojol,” —xcha ri ajchaq'el. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ri ajchakib' xkitzijob'ej kib', xkib'ij: “Are wa' ri kechb'en ronojel. ¡Jo', qakämisaj k'ut, rech käq'ax ronojel wa' pa qa q'ab'!” —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Xkichapo, xkikämisaj, xkesaj k'u b'i ru cuerpo pa ri tikb'al uvas, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Te k'u ri' ri Jesús xuta' chke, xub'ij: ¿Jas k'u kub'an na ri' ri ajchaq'el ri tikb'al uvas? —kächa ri Jesús. Kopan na kuk', keukämisaj na ri ajchakib', kuya k'u na ru tikb'al uvas chke jule' chik, —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿A mat sik'im alaq wa' we tz'ib'am ri' pa ru Loq' Pixab' ri Dios? Je ri' kub'ij: Ri ab'aj ri man xkaj tä ri yakal taq ja, are ab'aj wa' xkoj che toq'eb'al re ri ja. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Je' b'anom wa' rumal ri Qajaw Dios. Qas kajmab'al k'u wa' chqawäch, —kächa', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ri ki nimaqil ri winaq aj Israel xkitzukuj k'ut jas käka'n chuchapik ri Jesús rumal chi xkich'ob'o chi chkij ri e are' xutzijoj wa' we k'utb'al ri'. Käkixej k'u kib' chkiwäch ri k'ialaj winaq, xa rumal ri' xkiya kan ri Jesús, xeb'e'k. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Xetaq k'u b'i jujun chke ri tata'ib' fariseos ruk' ri Jesús, xuquje' jujun chke ri rachi'l ri tat Herodes che rilik we k'o jas kekowin chub'anik rech käqaj ri Jesús pa ki q'ab'. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Aretaq xeopanik, xkib'ij che ri Jesús: Ajtij, qetam chi jikom anima' la, xuquje' chi man käxej tä ib' la chkiwäch ri winaq jas pu käkichomaj ri e are' chij la. Man nim tä k'u kil wi la jun winaq chuwäch ri jun chik, xane qas tzij käk'ut la u b'eyal ru rayinik ri Dios chkiwäch konojel. ¿A taqal chqe käqatoj alkab'al che ri César o a man taqal taj? —kecha'. ¿A rajwaxik k'ut käqatojo o a man rajwaxik taj? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Retam k'u ri Jesús chi xaq kieb' ki wäch, rumal ri' xub'ij chke: ¿Jas che käta' alaq wa' chwe? ¿A mat xa kaj alaq chi kinqaj pa q'ab' alaq? —kächa'. K'amampe alaq loq jun puaq chnuwäch rech kinwilo, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ri e are' xkik'am loq ri puaq, xril k'u wa' ri Jesús, te ri' xub'ij chke: ¿Jachin k'u ajchaq'el we ka'yeb'al xuquje' we b'i'aj ri'? —xcha chke. Xkib'ij k'u che: Are rech ri César, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Xub'ij k'u ri Jesús chke: Ya b'a' alaq che ri César ri rech ri César. Ya k'u alaq che ri Dios ri rech ri Dios, —xcha ri Jesús chke. Ri e are' xkikajmaj u wäch ri Jesús rumal ri xub'ij chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Te ri' xeopan jujun tata'ib' saduceos ruk' ri Jesús. Ri winaq ri', ri saduceos, käkib'ij chi man kek'astaj tä chi na ri käminaqib'. Xkita' k'u che ri Jesús, xkib'ij: ");
INSERT INTO qucNNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","¡Ajtij! Tz'ib'am kan chqe rumal ri qa mam Moisés chi we käkäm ru chaq' jun achi, we käkäm ri ratz, k'o k'u kan ri rixoqil, we k'u man e k'o tä kan ralk'ual ruk' ri rixoqil, rajwaxik k'ut chi ri rachalal ri k'o kanoq, käk'uli ruk' ri ixoq ri' ri malka'n rech kek'oji kan ralk'ual ruk'. Ri ak'alab' ri' je' ta ne e rech ri käminaq, —kecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","E k'o k'u wuqub' achijab' e kachalal kib'. Ri nab'eal xk'uli'k, xkäm k'ut, man k'o tä k'u kan ralk'ual ruk' ri rixoqil. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ri ukab' xk'uli ruk' ri rixnam malka'n, xuquje' xkäm b'ik, man k'o tä kan ralk'ual. Je' xuquje' xub'an ri urox achi. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Je k'u ri' xka'n ri wuqub' achijab', kachalal kib', man xkiya tä kan kalk'ual. E käminaq chik konojel, xkäm k'u b'i ri ixoq. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Aretaq k'ut kek'astaj na ri käminaqib', ¿jachin chke wa' we wuqub' achijab' ri' käk'amow ri ixoq che rixoqil? Xk'oji k'u che kixoqil ri wuqub', —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Xch'aw k'u ri Jesús, xub'ij chke: Ri alaq xa sachinaq alaq rumal chi man etam tä alaq ru Loq' Pixab' ri Dios ri Tz'ib'talik. Man etam tä k'u alaq ru chuq'ab' ri Dios, —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Aretaq ri käminaqib' kek'astajik, man kek'uli tä chik. Ri qa nan qa tat k'ut man käkiya tä chi ri kalk'ual che k'ulanem, xane e junam chi kuk' ri ángeles ri e k'o chikaj, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Chrij k'u wa' chi kek'astaj na ri käminaqib', k'o na ri kwaj kinb'ij chech alaq: ¿A mat sik'im alaq pa ri wuj ri tz'ib'am rumal ri qa mam Moisés jawije' ri kub'ij wi chi ri Dios k'o chupam ri juwi' k'ix ri tajin käk'atik, xuch'ab'ej loq ri qa mam Moisés? Je wa' xub'ij: “In ri' ru Dios ri Abraham, ru Dios ri Isaac, ru Dios ri Jacob,” —xcha ri Dios, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ri qa Dios man are tä Dios kech ri käminaqib', xane kech ri e k'ask'oj. Je ri' q'alaj chi xa sachinaq alaq, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Xopan k'u jun chke ri tijonelab' re ri Pixab' ri tajin kätatab'enik aretaq xkichomala kib'. Retam k'ut chi ri Jesús utz u tzelexik u wäch ri ki tzij u b'anom, rumal ri' xuta' che: ¿Jas ri taqanik ri nim na u b'anik chkiwäch konojel? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ri Jesús xch'awik, xub'ij che: Are wa' ri tznim na u b'anik: “Winaq aj Israel, ¡chitatab'ej!” —kächa'. “Ri qa Dios ri Qajaw, xaq xuwi ri Are', are Qajaw,” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","“Sib'alaj chiwaj ri i Dios ri Iwajaw, chijikib'a ri i k'ux, chijikib'a ri iwanima', chikojo ri i chomanik, chitija k'u ri i chuq'ab' chub'anik wa',” —kächa'. Tzare k'u wa' ri nab'e taqanik ri sib'alaj nim u b'anik. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ri ukab' taqanik ri sib'alaj nim na u b'anik are wa': “Chiwaj ri iwach winaq jas ri ix kiwaj iwib',” —kächa'. Man k'o tä chi k'u jun taqanik ri nim na u b'anik chkiwäch wa', —xcha ri Jesús che. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Xub'ij k'u ri tijonel re ri Pixab' che ri Jesús: ¡Utz ri käb'ij la, Ajtij! Qas tzij ri käb'ij la chi xa jun ri qa Dios, man k'o tä chi jun chuwäch ri Are', —kächa che. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Xuquje' rajwaxik chi jun winaq sib'alaj kraj ri Dios, kujikib'a ru k'ux, kujikib'a ri ranima', kukoj ru chomanik, kutij k'u u chuq'ab' chub'anik wa'. Xuquje' rajwaxik chi kraj ri rach winaq je' jas ri are' kraj rib'. Nim na u b'anik wa' chkiwäch konojel ri sipanik ri keporox cho ri Dios, xuquje' chkiwäch konojel ri awaj ri kekämisax che sipanik cho ri Dios, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Aretaq ri Jesús xuto chi sib'alaj käna'w ri tata' chutzelexik u wäch u tzij, xub'ij che: Xaq jub'iq' kraj man kätaqan ri Dios puwi' la, —xcha che. Te k'u ri' man k'o tä chi jun xuchajij anima' chi k'o jas xuta' che ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ri Jesús tajin keutijoj ri winaq pa ri nimalaj rachoch Dios, käch'awik, kub'ij: ¿Jas che käkib'ij ri tijonelab' re ri Pixab' chi ri Cristo are xaq xuwi ralk'ual kan ri qa mam David? ");
INSERT INTO qucNNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tzare k'u ri qa mam David kub'ij rumal ri Loq'alaj Espíritu: Xub'ij ri Qajaw ri qa Dios che ri Qajaw: “Chatt'uyul pa ri nu wikiäq'ab', k'ä kinya na chawe chi katch'akanik kattaqan pa ki wi' konojel ri käka'n ki k'ulel chawe,” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","We ri qa mam David kub'ij: “Qajaw” che ri Cristo, ¿jas ta k'u che käkib'ij ri e are' chi ri Cristo are xaq xuwi ralk'ual kan ri qa mam David? ¡Man je' tä ri'! —xcha chke. Ri winaq k'ut, ri sib'alaj e k'ia chik ki mulim kib', käkikot kanima' chutatab'exik ru tzij ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ri Jesús tajin keutijoj ri winaq, kub'ij chke: Chajij ib' alaq chkiwäch ri tijonelab' re ri Pixab'. Ri e are' käqaj chkiwäch keb'inikat pa charchäq taq katz'iaq. Xuquje' käqaj chkiwäch chi nim keil wi na, käyi' k'u rutzil ki wäch pa taq ri k'ayib'al, pa taq ri b'e. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Käkitzukuj ri t'uyulib'al ri nimaq ki b'anik pa taq ri rachoch Dios, xuquje' ri t'uyulib'al ri nim keil wi pa taq ri ula'nem ri kewi' wi, —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Xuquje' käkitoqij taq ri kachoch ri malka'nib' taq ixoqib'. Te ri' käkiyuq u tza'm ri ki tzij aretaq käka'n orar rech man q'alaj tä ri etzelal ri tajin käka'no. ¡Qas nim na ri k'äx käkiriq ri tijonelab' re ri Pixab' aretaq käq'at na tzij pa ki wi'! —xcha ri Jesús chke ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","T'uyul k'u ri Jesús pa ri nimalaj rachoch Dios chkiwäch taq ri käxon ri käyi' wi ri puaq ri käsipax cho ri Dios. Tajin käka'y chke ri winaq ri käkiya ri ki rajil chupam taq ri käxon ri'. E k'ia k'u chke ri q'inomab' xekiya nimaq taq ki rajil. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Xopan k'u jun malka'n chichu' ri meb'a', xuya xa kieb' alaj taq puaq, kraj ne xa jun centavo rajil ri kieb' puaq ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ri Jesús xeusik'ij ru tijoxelab', xub'ij k'u chke: Qas tzij ri kinb'ij chiwe, chi we meb'a'laj malka'n chichu' ri', are nim na wa' ri xusipaj ri are' chkiwäch konojel ri nik'iaj winaq ri ki yo'm ki rajil pa taq ri käxon ri k'olib'al puaq. ");
INSERT INTO qucNNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ri e are' ki yo'm jub'iq' re ri k'ia ri k'o kuk'. Are k'u we malka'n chichu' ri' u yo'm ronojel ri k'o ruk', ronojel ri tzuqub'al re, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Elem b'i re ri Jesús pa ri nimalaj rachoch Dios, jun chke ru tijoxelab' xub'ij che: ¡Ajtij, chilampe la we je'lalaj taq ab'aj ri', xuquje' taq we ja ri yakom ri' ri sib'alaj e kajmab'al! —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Xch'aw k'u ri Jesús, xub'ij che: ¿A kawil konojel we nimalaj taq ja ri e yakom ri'? —kächa'. Man käkanaj tä k'u kan jun ab'aj puwi' ri jun ab'aj chik ri mat käwulix na, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Xe' k'u ri Jesús, e rachi'l ru tijoxelab', pa ri Ujuyub'al Olivos ri k'o apan cho ri rachoch Dios. T'uyul k'u ri Jesús chila', ri tat Pedro, ri tat Jacobo, ri tat Juan, xuquje' ri tat Andrés xkita' che ri Are' pu tukiel wi, ");
INSERT INTO qucNNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","xkib'ij: Käqaj chi käb'ij la chqe jampa' käb'antaj na wa'. ¿Jas u wäch etal käb'an na chuk'utik chqawäch chi xopan ri q'ij ri' ri keb'antaj na konojel taq wa' ri b'im la chqe? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ri Jesús xch'awik, xub'ij chke: ¡Chichajij iwib' k'o jachin jun mixsub'uwik! —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","E k'ia k'ut ri kepe na, käkikoj na ri nu b'i', käkib'ij: “¡In ri' ri Cristo!” —kecha na. E k'ia k'u ri' ri kekisub' na, —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Aretaq kita nimalaj taq ch'oj, xuquje' kita u tzijoxik taq ch'oj jawije' taq chi', mixej iwib'. Rajwaxik chi käb'antaj na wa'. K'ä mäjoq k'u ri k'isb'al re ri q'ij junab' ri', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Käch'ojin k'u jun tinimit ruk' ri jun tinimit chik, xuquje' käch'ojin jun nim taqanel ruk' jun nim taqanel chik. Kepe k'u na k'ia käb'raqan jawije' taq chi', käpe na wi'jal xuquje', ri winaq k'ut sib'alaj käkitukij na kib'. Xaq k'u chapleb'al wa' re ronojel ri k'äx ri käpe na pa ki wi' ri winaq, —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","¡Chichajij b'a' iwib'! —kächa'. Kixjach k'u na pa taq ki q'ab' ri ki nimaqil winaq ri ketaqan pa ki wi', xuquje' kixch'ay na chkiwäch ri ki nimaqil ri winaq pa taq ri rachoch Dios ri käkimulij wi kib' ri winaq. Kixtak'ab'ax na chkiwäch q'atal taq tzij, xuquje' chkiwäch taqanelab' ri nimaq ki b'anik rumal wech in rech kiq'alajisaj na ri Utzalaj Tzij re ri Evangelio chkiwäch ri e are', —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","K'ä mäjoq k'u kopan ri k'isb'al re ri q'ij junab' ri', rajwaxik kätzijox na we Utzalaj Tzij ri' re ri Evangelio chke konojel ki wäch winaq cho ruwächulew, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Aretaq kixk'am na b'ik rech kixjach chkiwäch ri q'atal taq tzij, mixej iwib', michomaj b'ik jas ri kib'ij na chke, xane chib'ij ri käyi' chiwe rumal ri Dios pa ri q'ij ri'. Man ix tä k'ut ri kixtzijon na, xane are ri Loq'alaj Espíritu. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ri winaq kekijach na ri kachalal pa kämisaxik, ri nan tat kekijach na ri kalk'ual pa kämisaxik. Ri alk'ualaxelab' käkiyak na kib' chkij ri ki nan ki tat, kekijach na pa kämisaxik. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","¡Konojel ri winaq käketzelaj na i wäch xa rumal wech in! —kächa'. Are k'u ri käch'ijowik k'ä käk'is na ronojel, kuriq na ri' ru tob'anik ri Dios, —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ri qa mam Daniel, jun chke ri q'alajisal re ru Loq' Pixab' ri Dios, xutz'ib'aj ojer chrij ri “itzelalaj äwas ri ketzelan ronojel.” ¡Jachin ri kusik'ij wa', ri tz'ib'tal waral, chuch'ob'o' jas ri' ri äwas ri kub'ij chi'! Aretaq kiwil wa' käk'oji chila' jawije' ri man ya'tal tä wi, rajwaxik chi ri winaq ri e k'o pa Judea keanimaj b'i pa taq ri juyub'. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ri winaq ri e k'o puwi' taq kachoch, aninaq cheqaj loq, meb'ok chi b'i chupam ri ja chuk'amik b'i jun jasach. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Xuquje' ri e k'o pa ri juyub' mätzelej b'i cho ja chuk'amik ri ki q'u'. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Sib'alaj k'äx ke ri ixoqib' ri yawab' taq winaq chik pa taq ri q'ij ri', xuquje' ri e k'o alaj taq kal ri k'ä ketu'nik! ");
INSERT INTO qucNNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","¡Chib'ana b'a' orar, chixb'ochi'n che ri Dios chi mäk'ulmataj ronojel wa' pa taq ri u q'ijol ri tew! ");
INSERT INTO qucNNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Je ri', rumal chi käpe na nimalaj k'äxk'ol pa taq ri q'ij ri', ri man k'olinaq tä ri' tzpa ru chaplexik loq ru b'anik ruwächulew rumal ri Dios k'ä pa taq we q'ij ri'. Te k'u ri' man k'o tä jumul ri kepe chi na k'äxalaj taq q'ij junam ruk' ri k'äxk'ol ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","We ta ri Qajaw Dios mat kub'ano chi xaq q'atatal q'ij käk'oji we k'äxk'ol ri', mat k'o jun winaq ri' ri käk'asi kanoq. Ri Dios k'ut u b'anom chi xaq q'atatal q'ij käk'oji wa' rumal chi keraj ri e cha'tal rumal ri Are'. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","We k'u k'o jun ri kub'ij chiwe: “¡Chiwilampe', k'o ri Cristo chi ri'!” We kub'ij: “¡Chiwilampe', k'o jela'!” —we kächa'. ¡Mikoj b'a'! —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kepe na winaq ri käka'n che kib' chi e are ri Cristo, xuquje' kepe chi na jule' chik ri käka'n che kib' chi e q'alajisal taq re ru Loq' Pixab' ri Dios. Keka'n k'u na etal, xuquje' kajmab'al che ki sub'ik ri winaq ri e cha'tal rumal ri Dios we kekowinik, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","¡Chiwila b'a' iwib'! Nu b'im chi k'u apan ronojel wa' chiwe, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Pa taq ri q'ij ri' aretaq ok'owinaq chik ri nimalaj k'äx ri', ri q'ij käq'equmar na, ri ik' k'ut man kätunun tä chik. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ketzaq k'u na loq ri ch'imil cho ri kaj. Keslab'isax k'u na konojel ri k'o ki chuq'ab' ri e k'o cho ri kaj, je' jas ri q'ij, ri ch'imil, ri ik', xuquje' nik'iaj chik, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Te k'u ri' kilitaj k'u na chi ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, kinpe pa taq ri sutz' ruk' nimalaj nu chuq'ab', känimarisax k'u nu q'ij, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Te ri' keintaq na b'i ri ángeles rech kekimulij ri winaq ri e cha'tal rumal ri Dios pa ri relb'al q'ij, pa ru qajb'al q'ij, pa ri u moxq'ab' ri relb'al q'ij, pa ru wikiäq'ab' ri relb'al q'ij, tzpa ronojel ri kajulew, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Chich'ob'o b'a' ri k'utb'al chrij ru che'al higos: Aretaq keräxar ru q'ab', ketuxin k'u ru xaq, iwetam ri' chi xaq jub'iq' chik man kopan ri q'alaj. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Je ri' xuquje' ri ix aretaq kiwil ki k'ulmaxik ronojel wa', kiwetamaj na chi xaq jub'iq' chik man kopan ri q'ij ri kinpetik. Je' ta ne chi in k'o chi' ri uchib'e. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Qas tzij ri kinb'ij chiwe chi keb'antaj na ronojel wa' ri xinb'ij chiwe k'ä mäjoq kekäm ri winaq re we q'ij junab' ri', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Käsach na u wäch ri kaj, xuquje' ruwächulew, are k'u ri tzij ri nu b'im chiwe keb'antaj na wa', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Man k'o tä k'u jachin jun ri retam jampa' kopan ri q'ij ri', o ri hora. Man ketam tä ri ángeles, man retam tä ru K'ojol ri Dios, xane xaq xuwi ri qa Tat Dios retam wa', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Rumal wa', ¡chiwila b'a' iwib', chixk'ask'atoq, chib'ana orar! ¡Man iwetam tä k'ut jampa' kopan ri q'ij ri'! —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Are je' jas jun achi b'enam kub'ano, naj ke' wi. K'ä mäja' kel b'ik cho ja, kuya kan ronojel pa ki q'ab' ri patänil taq re, xuquje' kuya kan ri ki chak chkijujunal. Kätaqan kan che ri chajil uchib'e chi utz rilik ri ja kub'ano, —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","¡Chiwila b'a' iwib', chixk'ask'atoq! rumal chi man iwetam taj jampa' käpe ri ajchaq'el ja, we tajin kok ri aq'ab' aretaq käpetik, we pa nik'iaj aq'ab', we pa ri hora ri koq' ri ama' äk', we tajin käpe chi ru saqirik. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Chiwila b'a' iwib' rech we xaq te'talik käpetik mixuluriqa ne tajin kixwarik. ");
INSERT INTO qucNNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ri kinb'ij chiwe, kinb'ij k'u chke konojel. ¡Chiwila b'a' iwib', chixk'ask'atoq! —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Xa kieb' q'ij chik kraj che ri nimaq'ij, Pascua u b'i', xuquje' ri nimaq'ij re ri kaxlan wa ri man käyi' tä ch'äm ruk'. Ri ki nimaqil sacerdotes, xuquje' ri tijonelab' re ri Pixab' käkitzukuj jas käka'n na chuchapik ri Jesús ruk' sub'unik rech käkikämisaj. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Xkib'ij k'ut: ¡Mächap pa ri nimaq'ij rech metukin ne ri winaq! —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Are k'u ri Jesús k'o pa ri tinimit Betania cho rachoch ri tat Simón, jun tata' ri xk'oji itzel ch'a'k che. T'uyul k'u ri Jesús chi' ri mesa, xopan jun ixoq ruk'am jun k'olib'al kunab'al re alabastro, k'o k'ok'alaj kunab'al re qas nardo chupam. Sib'alaj paqal rajil wa' we kunab'al ri'. Ri ixoq xupaxij ri k'olib'al kunab'al, xutix k'u ri kunab'al pu jolom ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","E k'o k'u jujun chila' ri xa xpe koyowal, xkib'ij chb'il taq kib': ¿Jas che xaq xtix wa' we kunab'al ri'? —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","¡Xk'iyix ta k'u wa' che oxib' cientos quetzales ruk' u wi', xyi' ta k'u ri puaq chke ri meb'a'ib'! —xecha'. Xeyoq'on k'u che ri ixoq. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Xub'ij k'u ri Jesús: ¿Jas che kiya latz' che ri ixoq? ¡Mib'an wa' che! ¡Jun nimalaj utzil k'ut ru b'anom chwe! —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Amaq'el k'ut e k'o ri meb'a'ib' iwuk', kuya' k'ut kib'an utzil chke aretaq kiwaj u b'anik wa'. Are k'u ri in man in k'o tä iwuk' ronojel q'ij. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","We ixoq ri' u b'anom jas ri xkowin chub'anik, ri xpe pa ranima'. U kojom k'u b'i ri k'ok'alaj kunab'al che ri nu cuerpo k'ä mäjoq kinmuqik. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Qas k'u tzij ri kinb'ij chiwe chi apawije' ta ne ri kätzijox wi na ri Utzalaj Tzij re ri Evangelio cho ronojel ruwächulew, ri u b'anom we ixoq ri' kätzijox na che na'tab'al re, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Te k'u ri' xel b'i ri tat Judas Iscariote, jun chke ri kab'lajuj tijoxelab', xe' ri are' kuk' ri ki nimaqil sacerdotes chuchomaxik kuk' jas kub'an chujachik ri Jesús pa ki q'ab'. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Aretaq xkito, xekikotik, xkib'ij k'u che ri tat Judas chi käkiya na puaq che. Ri tat Judas k'ut tajin käreyej chi kopan jun utzalaj q'ij chujachik ri Jesús pa ki q'ab'. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pa ri nab'e q'ij re ri nimaq'ij re ri kaxlan wa ri man käyi' tä ch'äm ruk', aretaq käkämisax ri chij che ri nimaq'ij Pascua, ru tijoxelab' ri Jesús xkib'ij che: ¿Jawije' kaj wi la chi käqa'n wi ri wi'm re ri Pascua rech kätij la? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Xeutaq k'u b'i kieb' chke ru tijoxelab', xub'ij k'u chke: ¡Jix pa ri tinimit! Kixuriqa na jun achi ruk'am jun q'eb'al joron. Chiterenej b'ik. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Jawije' k'u ri kok wi ri achi, chib'ij k'u che ri ajchaq'el ri ja: “Kuta' ri Qajtij che la, kub'ij: ¿Jawije' kinb'an wi ri wi'm re ri Pascua ri kintij junam kuk' ri nu tijoxelab'?” —kächa ri', —kixcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ri are' kuk'ut na chiwäch jun nim ja pa ru kawiq ja ri ya suk'umatal chik. Chib'ana u b'anik ri wi'm re ri Pascua chqe uj chila', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Xeb'el k'u b'i ri tijoxelab', xeb'e' pa ri tinimit, xkiriqa ronojel jas ri xub'ij b'i ri Jesús chke. Xka'n k'u u b'anik ri wi'm re ri Pascua chila'. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Aretaq chaq'ab' chik xopan ri Jesús, e rachi'l k'u ri kab'lajuj tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","E t'uyul chila' chi' ri mesa, tajin kewi'k aretaq ri Jesús xub'ij chke: Qas tzij ri kinb'ij chiwe chi k'o jun chiwe ri kinujach na, are jun ri tajin käwi' wuk', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ru tijoxelab' sib'alaj xeb'isonik. Chkijujunal k'ut xkichaplej u ta'ik che ri Jesús: ¿A man xa in ri'? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Xch'aw k'u ri Jesús, xub'ij chke: Are jun chke ri kab'lajuj tijoxelab' ri kurub' ru wa wuk' pa ri laq, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Je' kinel na in jas ri tz'ib'tal pa ru Loq' Pixab' ri Dios chwij in, in ri' ri Ralk'ual ri Dios ri Qas Winaq. ¡K'äx k'u kuriq na ri achi ri kinjachow na in! ¡Utz na re we achi ri' we ta mat xil u wäch! —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Aretaq tajin kewi'k, ri Jesús xuk'am ri kaxlan wa, xumaltioxij wa' che ri Dios, xub'an orar puwi' chutewchixik. Te ri' xupiro. Xuya chkiwäch ru tijoxelab', xub'ij: ¡Chik'ama iwe! Je' ta ne are nu cuerpo wa', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Te k'u ri' xuk'am jun vaso, xumaltioxij k'u wa' che ri Dios. Xuya ri vaso chkiwäch, xkitij k'u ke konojel. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Xub'ij k'u ri Jesús chke: Je' ta ne are nu kik'el wa' ri kujikib'a ri k'ak' trato ri u b'anom ri Dios kuk' ri winaq. Käturuw k'u na wa' ri nu kik'el rech kub'an utzil chke k'ia winaq, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Qas tzij ri kinb'ij chiwe chi man kintij tä chi na we ri vino re uvas, k'ä pa ri q'ij ri kintij na ri k'ak' vino chila' jawije' ri kätaqan wi ri Dios, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Te k'u ri' xkib'ixoj jun b'ix ri kuya u q'ij ri Dios, xeb'el b'ik, xeb'e' pa ri Ujuyub'al Olivos. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Xub'ij k'u ri Jesús chke: Ri ix iwonojel kib'isoj na nu wäch, kiniya na kan kämik chaq'ab'. Je' k'u tz'ib'am kanoq pa ru Loq' Pixab' ri Dios: “Kinsok na ri ajyuq', kejab'un k'u na ri chij,” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Aretaq k'u in k'astajinaq chik chkixol ri käminaqib', kinnab'ej na b'i chiwäch, kine' na pa Galilea, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Xub'ij k'u ri tat Pedro che ri Jesús: ¡Pune konojel käkiya la kanoq, ri in man je' tä ri' kinb'ano! —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Xub'ij k'u ri Jesús che: Qas tzij ri kinb'ij chawe chi tzpa we aq'ab' ri' kab'ij na at oxmul chi man awetam tä nu wäch mäjoq koq' kamul ri ama' äk', —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ri tat Pedro tzko na xch'awik, xub'ij: Pune rajwaxik chi kinkäm na uk' la, qas tzij chi man kinb'ij taj chi man wetam tä wäch la, —xcha che. Je' k'u xkib'ij xuquje' konojel ri tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Aretaq xeopan pa ri ch'äqap ulew, Getsemaní u b'i', xub'ij ri Jesús chke ru tijoxelab': Chixt'uyul kan chi' k'ä kinto'taj na chub'anik orar, —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Xeuk'am b'i ri tat Pedro, ri tat Jacobo, ri tat Juan ruk'. Xuchaplej k'u t'ujuwem ri ranima' ri Jesús, xk'äxk'ob' k'u wa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Xub'ij k'u chke: ¡Xa are kuk'is rib' ri wanima' chupam ri b'is! Chixkanaj kan chi', chixk'ask'atoq, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Te ri' xb'in chi apan jub'iq' ri Jesús, xutzaq rib' pa ulew, tajin kub'an orar, xutz'onoj che ri Dios chi we ta k'o b'anom wi, mat kuriq we k'äx ri' ri petinaq chrij. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Aretaq xub'an orar, xub'ij: ¡Abba! ¡Tat! Ri lal käkowin la che ronojel. Chesaj b'i la we vaso ri' chnuwäch. B'ana b'a' la chi man käpe tä we k'äx ri' chwij. Mäb'an k'u la xa jas ri kwaj in, xane jas ri kaj la käb'an la chwe, —xcha che ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Xtzelej k'u loq ri Jesús kuk' ru tijoxelab', xeuriqa', tajin kewarik. Xub'ij k'u che ri tat Pedro: ¿A katwarik, Simón? ¿A mat katkowinik katk'asi jun hora wuk'? —kächa che. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Chiwila b'a' iwib', chixk'ask'atoq, chib'ana orar rech man kixtzaq taj aretaq kixtaqchi'x che mak. Qas tzij ri iwanima' kraj u b'anik utzil, man k'o tä k'u u chuq'ab' ri i cuerpo chub'anik wa', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Xe' jumul chik ri Jesús, xub'ana orar, je' xub'ij jas ri xub'ij nab'e. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Te k'u ri' xtzelej chi loq, xeuriqa ru tijoxelab' chi jumul chik tajin kewarik rumal chi sib'alaj k'äx ki waram. Man xkiriq tä k'u ru tijoxelab' jas käkib'ij che ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Churoxmul xtzelej chi loq ri Jesús kuk', xub'ij k'u chke: Chixwar b'a', chixuxlanoq, —xcha'. Te ri' xub'ij: ¡Ruk' wa'! —kächa'. Opaninaq k'u ri hora. Kinjach k'u na in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, pa ki q'ab' ri ajmakib', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Jo' b'a'! ¡Chixwalijoq! Chiwilampe', xpe ri jachal we, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","K'ä tajin käch'aw ri Jesús aretaq xopan ri tat Judas, jun chke ri kab'lajuj u tijoxelab'. E petinaq ruk' ri are' k'ia winaq, kuk'am machetes, kuk'am che'. E taqom loq kumal ri ki nimaqil sacerdotes, kumal k'u taq ri tijonelab' re ri Pixab', xuquje' ri ki nimaqil ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ri tat Judas, ri jachal re ri Jesús, u yo'm k'u kan jun etal chke ri winaq, xub'ij: Ri kintz'umaj, are ri' ri Jesús. ¡Chichapa'! Qas utz chib'ana b'i chujat'ixik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Aretaq xopanik, chanim xqeb' ruk' ri Jesús, xub'ij: ¡Qajtij, Qajtij! —xcha che. Xutz'umaj k'ut. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Xkichap k'u ri Jesús, xkiyut b'ik. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jun chke ri e tak'atoj chila' xuk'am ru machete, xusok ri patänil re ri ki nimal sacerdotes, xuq'at apan ru xikin. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Xub'ij k'u ri Jesús chke ri winaq: ¿Jas lo wa' chi je' ta ne chrij jun elaq'om elinaq wi alaq loq? K'amom alaq loq ri machetes alaq, ri che' alaq che nu chapik, —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ronojel q'ij in k'o uk' alaq pa ri nimalaj rachoch Dios, tajin kinya tijonik chech alaq, man xinchap tä k'u alaq. Je' k'u käb'an na wa' chwe rech je' käb'an na jas ri tz'ib'am chwij pa ru Loq' Pixab' ri Dios, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Chanim k'ut konojel ru tijoxelab' xkiya kan ri Jesús, xeanimaj b'ik. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","K'o k'u jun ala teren chrij ri Jesús, xaq jun saq atz'iaq u q'u'm chrij. Xchap k'u ri' kumal ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ri are' k'ut xuya kan ri ratz'iaq pa ki q'ab', ch'analik xanimaj b'i chkiwäch. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Te ri' xkik'am b'i ri Jesús cho ri qas ki nimal sacerdotes. Xkimulij k'u kib' konojel ri ki nimaqil sacerdotes, ri ki nimaqil ri winaq, xuquje' ri tijonelab' re ri Pixab'. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ri tat Pedro k'ut xuterenej b'i ri Jesús chinaj, xopan k'u pa ri uwoja re ri rachoch ri qas ki nimal sacerdotes. Xt'uyi k'u ri tat Pedro chila' kuk' ri chajil taq re ri nimalaj rachoch Dios, tajin kumiq' rib' chrij ri q'aq'. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ri ki nimaqil sacerdotes kuk' konojel ri ki nimaqil ri winaq tajin käkitzukuj jas u wäch mak ri käq'alajisax chrij ri Jesús rech käkämisaxik. ¡Man xkiriq tä k'ut! ");
INSERT INTO qucNNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","E k'ia k'u ri xka'n tzij chrij aretaq xka'n q'alajisanik. Man xaq tä k'u jun u wäch ri xkib'ij. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Te ri' xewalij jujun ri käka'n tzij chrij ri Are', xkib'ij: ");
INSERT INTO qucNNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Qa tom ri xub'ij: “Ri in kinwulij na we nimalaj rachoch Dios ri' ri b'anom kumal ri winaq, kinyak chi k'u na pa oxib' q'ij jun ri man b'anom tä wa' kumal winaq,” —xcha ri', —xecha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Man ruk' tä wa' xjunamataj u wäch ri xkib'ij chrij. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Xwalij k'u ri qas ki nimal sacerdotes, xtak'i chkiwäch konojel, xuta' che ri Jesús, xub'ij che: ¿A mat k'o jas jun tzij kab'ij chutzelexik u wäch ri tajin käb'ix chawij? ¿Jas pu wa' we tajin käkiq'alajisaj we achijab' ri' chawij? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Man käch'aw tä k'u ri Jesús, man k'o tä wi jas kub'ij che. Ri qas ki nimal sacerdotes xuta' jumul chik che ri Jesús, xub'ij: ¿A qas at ri' ri Cristo, ru K'ojol ri Dios ri käqaya u q'ij? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Xch'aw k'u ri Jesús, xub'ij che: ¡In ri', tat! —kächa che. ¡Kinil k'u na alaq ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, aretaq in t'uyul pa ru wikiäq'ab' ri Dios ri sib'alaj k'o u chuq'ab', xuquje' kinil na alaq aretaq kinpe na kuk' taq ri sutz' chikaj! —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Are k'u ri qas ki nimal sacerdotes xuraq'achij ru q'u' chuk'utik chi sib'alaj k'äx kuna' ri kub'ij ri Jesús. Xub'ij k'u ri tata': ¿Jas k'u che e rajwaxik chi nik'iaj q'alajisanelab' chrij? ");
INSERT INTO qucNNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","¡I tom k'u ri ix chi xub'ij ri äwas u b'ixik chrij ri Dios! ¿Jas k'u kichomaj? —xcha chke. Konojel k'ut xkiq'at tzij puwi', xkib'ij chi rajwaxik käkämisaxik. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","E k'o k'u jujun xkichaplej u chub'axik. Xkich'uq ru palaj, xkich'ayo, xkib'ij k'u che: ¡Chach'ob'o ne jachin ri xatuch'ayo! —xecha che. Xuquje' ri chajinelab' xkikoj q'ab' chupalaj. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","K'ä k'o ri tat Pedro ikim pa ri uwoja aretaq xpe jun chke ri alitomab', ri ajik' rech ri qas ki nimal sacerdotes. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Aretaq xril ri tat Pedro chi tajin kumiq' rib' cho ri q'aq', ko xka'y che, xub'ij: ¡Ri at xuquje' xatk'oji ruk' ri Jesús aj Nazaret! —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Are k'u ri tat Pedro xresaj rib' chupam, xub'ij: ¡Man wetam tä u wäch ri', man kinch'ob' tä k'u ri' ri tajin kab'ij! —xcha che. Xel k'u b'i chila', xopan chi' ri uchib'e. Are chi' xoq' ri ama' äk'. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ri ali xril ri tat Pedro jumul chik, xuchaplej chi na u b'ixik chke ri e tak'atoj chunaqaj, xub'ij: ¡We achi ri' are jun chke ri e rachi'l ri Jesús! —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ri tat Pedro xresaj chi k'u rib' jumul chik chupam, xub'ij chi man kuch'ob' tä u wäch ri Jesús. Man naj tä k'u ri' ri e tak'atoj chila' xkib'ij jumul chik che ri tat Pedro: Qas tzij at jun chke rumal chi at aj Galilea. Xuquje' xaq junam katch'awik jas ri winaq aj Galilea, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ko k'u xch'aw ri tat Pedro, xub'an k'u jurar cho ri Dios, xub'ij: ¡Qas tzij ri' chi ri in man wetam tä u wäch ri achi ri' ri tajin kitzijoj! —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Xoq' chi k'u na ri ama' äk' chukamul. Xna'taj k'u che ri tat Pedro ru b'im ri Jesús che: “Kab'ij na at oxmul chi man awetam tä nu wäch mäjoq koq' kamul ri ama' äk',” —xcha che. Aretaq ri tat Pedro xna'taj wa' che, xutzoqopij k'u oq'ej. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Sib'alaj aq'ab' k'u ri' xkimulij kib' ri ki nimaqil sacerdotes, ri ki nimaqil ri winaq, xuquje' ri tijonelab' re ri Pixab' kuk' ri nik'iaj nimaq taq tata'ib'. Te k'u ri' konojel we nimaq taq tata'ib' ri' xkitala' ki no'j chuchomaxik jas käka'no. Xkiyut k'u b'i ri Jesús, xkik'am b'ik, xkijacha k'u cho ri tat Pilato. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Xuta' k'u ri tat Pilato che, xub'ij: ¿A at ri' ri kattaqan pa ki wi' ri winaq aj Israel? —xcha'. Xch'aw k'u ri Jesús, xub'ij: Je ri' jas ri käb'ij la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","K'ia tzij k'ut xka'n ri ki nimaqil sacerdotes chrij ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Xuta' k'u ri tat Pilato jumul chik che ri Jesús, xub'ij: ¿A mat k'o jas ri kab'ij? ¡Chatampe' chi k'ia ri käkib'ij chawij! —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Man k'o tä jun tzij chik xub'ij ri Jesús, je k'u ri' chi xukajmaj wa' ri tat Pilato, man xuriq tä chik jas kub'ano. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Are k'u ri tat Pilato naq'atal wi chi pa ri nimaq'ij ri' ri are' kub'an jun toq'ob' chke ri winaq, kutzoqopij b'i jun ajpache', apachin ta ne ri käkita' che. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","K'o k'u jun achi, Barrabás u b'i', yo'm pa che' junam kuk' ri rachi'l rumal chi xka'n kämisanik aretaq ri winaq re ri tinimit xkiwalijisaj kib' chkij ri ketaqan pa ki wi'. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Xkimulij k'u kib' ri winaq chuwäch ri tat Pilato, xkichaplej u tz'onoxik che chi chub'ana toq'ob' chke, jas ri naq'atal wi ri are'. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Xch'aw k'u ri tat Pilato, xub'ij chke: ¿A kiwaj chi kinb'an toq'ob' chiwe, kintzoqopij b'i ri tata' ri k'o u taqanik pi wi' ix ri winaq aj Israel? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Kuch'ob' k'u ri tat Pilato chi xa rumal chi k'äx käkina' ri ki nimaqil sacerdotes che ri Jesús ki jachom ri Are' pu q'ab'. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ri ki nimaqil sacerdotes k'ut tajin käka'no chi ri winaq käkitukij kib', xa käkib'ij chi más utz na are kub'an toq'ob' chke, kätzoqopix b'i ri Barrabás. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Xch'aw chi ri tat Pilato, xuta' k'u chke: ¿Jas k'u ri kiwaj chi kinb'an che ri achi ri kib'ij ix chi are k'o u taqanik pi wi' ix ri ix winaq aj Israel? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ri winaq ko xkiraq ki chi', xkib'ij: ¡Chripoq! —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Xch'aw k'u ri tat Pilato, xuta' chke: ¿Jas che? ¿Jas etzelal u b'anom wa' we achi ri'? —xcha chke. Ko k'u na xech'aw ri winaq, xkib'ij: ¡Chripoq! —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ri Pilato are k'u kraj u b'anik xa jas ri ki rayinik ri winaq. Xub'an chke ri toq'ob' ri xkita', xutzoqopij k'u b'i ri Barrabás. Xtaqan k'ut chi käch'ay ri Jesús, te k'u ri' xujach b'ik rech käripik. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Xepe k'u ri soldados, xkik'am b'i ri Jesús pa ri uwoja re ri rachoch ri nim q'atal tzij, xekisik'ij ri nik'iaj soldados chik rech käkimulij kib' kuk'. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Xkikoj k'u jun atz'iaq morada chrij ri Jesús. Xuquje' xkikoj jun corona re kemom k'ix chujolom. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Chanim k'ut xkichaplej u raqik ki chi' chrij, xkib'ij: Lal ri' ri kätaqan la pa ki wi' ri winaq aj Israel, ¡chnimarisax q'ij la! —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Xkich'ay k'u chujolom ruk' jun aj, xkichub'aj, xexuki chuwäch, xaq käka'n che kib' chi tajin käkiq'ijilaj. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Aretaq xeto'taj che retz'b'exik u wäch, xkijolij ru q'u' ri morada chrij, xkikoj ri qas ratz'iaq ri Are' chrij, te k'u ri' xkik'am b'i churipik cho ri cruz. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","K'o k'u jun achi aj Cirene, Simón u b'i', ki tat ri tat Alejandro, ri tat Rufo. Ri are' tajin kok'owik, u petik k'u ri' pa juyub'. Xkikoj ki chuq'ab' che rech kutelej b'i ru cruz ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Xkik'am k'u b'i ri Jesús chila' jawije' ri käb'ix Gólgota che. Kel kub'ij wa' ri b'i'aj ri': Ri Juyub' re ru B'aqil Jolomaj, —kuchixik. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Xkiya k'u vino yujtal ruk' mirra chuwäch ri Jesús rech kutijo. Man xutij tä k'ut. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Aretaq ki ripom chik cho ri cruz, ri soldados xkijach ri ratz'iaq ri Jesús chkiwäch, xkesaj k'u suerte chrij rech käkilo jas ri käkik'am b'i chkijujunal. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Aq'ab' k'ut xrip ri Jesús pa ri u b'elej hora. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Kojom k'u puwi' ri cruz jun tz'ib'talik ri kub'ij jas che käq'at tzij puwi' ri Jesús rech käripik, kub'ij k'ut: RI NIM TAQANEL PA KI WI' RI WINAQ AJ ISRAEL, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Xerip k'u kieb' elaq'omab' ruk', jun pu wikiäq'ab', jun pu moxq'ab'. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Xb'antaj k'u kan ri tz'ib'am chrij pa ru Loq' Pixab' ri Dios ri kub'ij: “Je' ta ne chi are jun chke ri b'anal taq etzelal ri xq'at tzij puwi',” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ri keok'owik käkiyoq'o, käkisutisa' ri ki jolom, käkib'ij: ¡Aa! ¡At ri' ri kab'ij chi katkowinik kawulij ri nimalaj rachoch Dios, xa k'u pa oxib' q'ij kayak chi na wa' jumul chik! —kecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡Chato' b'a' awib', chatqaj k'u loq cho ri cruz! —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Je' xuquje' ri ki nimaqil sacerdotes kuk' ri tijonelab' re ri Pixab' käkitze'j u wäch, käkich'ab'ej kib', käkib'ij: ¡Xtob' chke nik'iaj chik, man käkowin tä k'u ri Are' chuto'ik rib'! —kecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Chqaj b'a' loq cho ri cruz ri Cristo “ri Nim Taqanel kech ri winaq aj Israel” rech käqilo, ¡kujkojon k'u na che! —xecha'. Ri e ripom ruk' ri Jesús xuquje' xkitze'j u wäch. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Aretaq xuriq ri kab'lajuj hora, xq'equmar ronojel ruwächulew oxib' horas. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tzpa ri rox hora re ri b'enaq q'ij xuraq u chi' ri Jesús, ko xch'awik, xub'ij: Eloi, Eloi, ¿lama sabactani? —xcha'. Je' kel kub'ij wa': Nu Dios, nu Dios, ¿jas che in wonob'am la kanoq? —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Jujun k'u chke ri e tak'atoj chila' xkita wa', xkib'ij: ¡Chitampe'! —kecha'. Tajin kusik'ij ri qa mam Elías ri ojer q'alajisal re ru Loq' Pixab' ri Dios, —xecha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Te k'u ri' jun chke ri winaq xutik anim, xe'k, xurub'u jun estropajo pa ch'äm vino, xuya wa' puwi' jun aj, xuya aq'an chuwäch ri Jesús rech kutijo, xub'ij k'u apan chke ri winaq: ¡Chiweyej b'a'! Chqila na we käpe ri qa mam Elías chuqasaxik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Sib'alaj ko xuraq u chi' ri Jesús, xel ranima', xkäm k'u ri Are'. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Are k'u ri tasb'al u pam ri nimalaj rachoch Dios xjisjob'ik, kieb' xub'ano, xpe ajsik k'ä ikim. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ri ki nimal soldados aj Roma, ri tak'al cho ri Jesús, aretaq xuto xuraq u chi' ri Jesús, xuquje' xrilo jas xub'ano aretaq xkämik, xub'ij: ¡Qas tzij u K'ojol ri Dios wa' we achi ri'! —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","E k'o k'u jujun ixoqib' ri tajin keka'y apan chinaj. Chkixol ri e are' k'o ri nan María aj Magdala, xuquje' ri nan María u nan ri tat Jacobo ri más k'ak'al na, ri xuquje' are u nan ri tat José wa'. K'o xuquje' ri nan Salomé kuk'. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Aretaq ri Jesús xk'oji pa Galilea, we ixoqib' ri' xeb'in ruk', xepatänin che. Xuquje' e k'o chila' k'ia chke ri nik'iaj ixoqib' chik ri e opaninaq ruk' ri Jesús pa Jerusalén. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","B'enaq chi ri q'ij pa ri q'ij ri käb'an u b'anik ronojel che ri q'ij re uxlanem, are k'u víspera wa' re ri q'ij ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Xopan k'u ri tat José aj Arimatea, jun chke ri ki nimaqil ri winaq aj Israel ri tznim kil wi. Ri are' xuquje' ku'l u k'ux che reyexik chi käpe na ri Dios rech kätaqan na pa ki wi' ri winaq. Xuchajij k'u anima', xok cho ri tat Pilato chuta'ik chi käyi' ru cuerpo ri Jesús che. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Xukajmaj wa' ri tat Pilato chi sib'alaj chanim xkäm ri Jesús. Xtaqan k'u chusik'ixik ri ki nimal ri soldados chuwäch, xuta' che we qas tzij käminaq chik. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Aretaq ri ki nimal soldados xub'ij chi qas tzij käminaq chik ri Jesús, ri tat Pilato xuya ru cuerpo che ri tat José. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ri tat José k'ut xuloq' jun payu', xuqasaj ru cuerpo ri Jesús, xupis k'u chupam ri payu'. Te ri' xuya chupam jun muqub'al ri k'otom koq pa ri ab'aj. Xuwolqotij k'u jun ab'aj chuchi' ri muqub'al. ");
INSERT INTO qucNNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ri nan María aj Magdala ruk' ri nan María u nan ri tat José tajin käkilo jawije' ri käyi' wi kan ru cuerpo ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ok'owinaq chi k'u ri q'ij re uxlanem, ri nan María aj Magdala, xuquje' ri nan María u nan ri tat Jacobo ruk' ri nan Salomé, xkiloq' k'ok'alaj taq kunab'al rech kekib'ila chrij ru cuerpo ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sib'alaj aq'ab' k'ut pa ri nab'e q'ij re ri semana xeb'e' ri ixoqib' chuchi' ri muqub'al. Elinaq chi k'u loq ri q'ij aretaq xeopanik. ");
INSERT INTO qucNNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Xkich'ab'ej k'u kib', xkib'ij: ¿Jachin ta k'u lo ri käwolqotin na apan ri ab'aj chqawäch? ¡Tzchuchi' ri muqub'al k'ut k'o wi! —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Aretaq k'ut xeka'yik, k'ä te' xkilo chi wolqotim chi apan ri nimalaj ab'aj ri'. ");
INSERT INTO qucNNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Xeb'ok k'u b'i pa ri muqub'al, xkil jun ak'al achi t'uyul pa ru wikiäq'ab' ri muqub'al. Saqloloj k'u ri ratz'iaq ri achi. ¡Xkixej k'u kib' ri ixoqib', xkikajmaj wa'! ");
INSERT INTO qucNNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Xub'ij k'u ri achi chke: ¡Mixej iwib'! Ri ix kitzukuj ri Jesús aj Nazaret, ri xrip cho ri cruz. K'astajinaq k'u b'i ri Are' chkixol ri käminaqib', man k'o tä chik waral. Chiwilampe' jawije' ri xyi' wi, —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Jix b'a', chitzijoj k'u wa' chke ru tijoxelab', xuquje' che ri tat Pedro, chib'ij: “Nab'ejinaq ri Jesús chiwäch, b'enam re pa Galilea. Chila' kiwila wi na u wäch ri Are' je' jas ri xub'ij chiwe,” —xcha chke ri ixoqib'. ");
INSERT INTO qucNNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Te ri' xeb'el b'i ri ixoqib', xeanimaj b'i chuchi' ri muqub'al. Sib'alaj xeb'irb'itik, ki xib'im k'u kib'. Man k'o tä k'u jas käkib'ij che jachin jun rumal chi sib'alaj ki xem kib'. ");
INSERT INTO qucNNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","K'astajinaq chi k'u ri Jesús chkixol ri käminaqib' sib'alaj aq'ab' pa ri nab'e q'ij re ri semana, xuk'ut rib' nab'e chuwäch ri nan María aj Magdala ri e resam b'i wuqub' itzel taq espíritus che. ");
INSERT INTO qucNNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Xe' k'u ri are', xutzijoj wa' chke ri nik'iaj chik ri xek'oji ruk' ri Jesús. Ri e are' sib'alaj keb'isonik, tajin keb'oq'ik. ");
INSERT INTO qucNNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Aretaq xkito chi k'asal chi ri Jesús, chi ilom chi u wäch rumal ri nan María, ¡man xkikoj taj! ");
INSERT INTO qucNNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Te k'u ri' jun chi wi u k'utik rib' ri xub'an ri Jesús chkiwäch kieb' chke ru tijoxelab' ri b'enam ke pa juyub'. ");
INSERT INTO qucNNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Xetzelej k'u b'i ri e are', xeb'e'k, xkitzijoj wa' chke ri nik'iaj chik. Man xkikoj tä k'u ri ki tzij ri e are'. ");
INSERT INTO qucNNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Chuk'isb'al ri Jesús xuk'ut rib' chkiwäch ri julajuj u tijoxelab', aretaq e t'uyul chi' ri mesa. Xeuyajo rumal chi man xekojon taj, chi xa ab'ajarinaq ri kanima'. Je' xub'an wa' rumal chi man xkikoj tä ri ki tzij ri winaq ri kilom u wäch ri Are' chi k'asal chik. ");
INSERT INTO qucNNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Xub'ij k'u ri Jesús chke: Jix cho ronojel ruwächulew, chitzijoj ri Utzalaj Tzij re ri Evangelio chke konojel ri winaq, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Apachin k'u ri käkojonik, käb'an k'u na u qasna', kuriq na ri' ru tob'anik ri Dios. Ri man käkojon taj, käq'at na tzij puwi' chi käk'äjisax na u wäch, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ri kekojonik käka'n na wa' we kajmab'al taq etal ri': Pa ri nu b'i' kekesaj na b'i itzel taq espíritus, kech'aw k'u na pa jule' taq ch'ab'al chik. ");
INSERT INTO qucNNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Käkichap na kumätz, xuquje' we käkitij kämisanel kunab'al, man k'o tä k'äx käkiriqo. Käkiya na ki q'ab' pa ki wi' ri yawab'ib', keutzir k'u na kanoq, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Te k'u ri', aretaq ri Qajaw Jesús xto'taj che tzijonem kuk' ru tijoxelab', xk'am b'i chikaj, xt'uyi k'u pa ru wikiäq'ab' ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Are k'u ru tijoxelab' xeb'el b'ik, xkitzijoj ri Utzalaj Tzij re ri Evangelio apawije' chi' ri xeopan wi. Tzare k'u ri Qajaw Jesús xtob' chke, xujikib'a chkiwäch ri winaq chi qas tzij ri tajin käkitzijoj rumal chi xuya chke chi käka'n kajmab'al taq etal junam ruk' ri tajin käkitzijoj. Amén. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Loq'alaj tat Teófilo: E k'ia ri winaq ri xkaj xkitz'ib'aj pa cholaj ri tzijob'elil chrij ri qas xb'antaj waral chqaxol. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ri xb'antaj na are je' jas ri k'utum chqawäch kumal ri winaq ri xkil ronojel wa' qas pa ri u chaplexik loq. We winaq ri' e are' ri xetob' chutzijoxik ru Loq' Pixab' ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ri in xuquje' sib'alaj utz rilik wa' nu b'anom in rech kinwetamaj ronojel wa' qas pa ru chaplexik loq. Rumal rech wa' xinchomaj in chi are utz we ri in xuquje' kintz'ib'aj b'i pa ru cholajil ronojel ri xb'antajik. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Je ri' kinb'an na rech ketamaj la ri qas tzij chrij ri tijonik ri yo'm che la. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Aretaq ri tat Herodes are nim taqanel pa ki wi' ri winaq aj Judea, xk'oji jun tata' chik chila', Zacarías u b'i'. Ri tata' ri' are sacerdote aj Israel ri jun kuk' ri juch'ob' sacerdotes aj re ri mam Abías. Ri rixoqil, Elisabet u b'i', are jun chke ri rachalaxik ri mam Aarón. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","E utzalaj taq winaq wa' we juk'ulaj ri', jikom k'u kanima' cho ri Dios. Xeniman che ri Dios pa ronojel ri xtaqan wi, pa ronojel ru Loq' Pixab' ri Qajaw. Man k'o tä etzelal ri xka'no. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Man k'o tä k'u kalk'ual rumal chi ri nan Elisabet man kalk'ualan taj. E nimaq taq winaq chi k'ut ri kieb' ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Pa jun q'ij ri tat Zacarías tajin käpatänin ri are' pa ri nimalaj rachoch ri Dios rumal chi käkiriq u b'anik wa' ri achijab' ri e jun kuk' ri juch'ob' sacerdotes aj re ri mam Abías pa taq ri q'ij ri'. Ri u chak ri tat Zacarías are la' chi käch'aw pa ki wi' ri winaq ruk' ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Je' jas ri ki naq'atisam wi kib' ri sacerdotes, xkicha' ri tat Zacarías rech kok b'i pa ri loq'alaj k'olib'al ri sib'alaj äwas chi kok b'i xa apachinoq chuporoxik ri incienso. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Konojel ri winaq xkimulij apan kib' cho ja chub'anik orar aretaq tajin käporox ri incienso. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Te'talik k'ut xuk'ut rib' jun ángel cho ri tat Zacarías, ri taqom loq rumal ri Dios. Xtak'i k'u chuxkut ri käporox wi ri incienso. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Aretaq ri tat Zacarías xril ri ángel, man xuriq taj jas xub'ano, xane sib'alaj xuxej rib'. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Xub'ij k'u ri ángel che ri tat Zacarías: Maxej awib'. Ri a b'ochi'nik xta'taj rumal ri Dios. Kil k'u na u wäch jun a k'ojol rumal ri nan Elisabet ri awixoqil. Kakoj k'u na a Juan che ru b'i', —kächa che. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Xuquje' xub'ij: Sib'alaj katkikot na rumal ri ak'al, xuquje' e k'ia chke ri jule' winaq chik ri kekikot na aretaq kil u wäch, —kächa ri ángel che. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Känimar na u q'ij cho ri Qajaw Dios. Man kutij tä na vino, man kutij tä k'u tzam. Kätaqan na ri Loq'alaj Espíritu pa ranima' ri ak'al k'ä mäjoq kil u wäch, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kub'an k'u na ri a Juan chi k'ia chke ri winaq aj Israel ketzelej na ruk' ri Qajaw ri ki Dios, —kächa ri ángel che ri tat Zacarías. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ri a Juan känab'ej na cho ri Qajaw Jesús. Käk'oji k'u na ru no'j xuquje' ru chuq'ab' je' jas ri xk'oji che ri mam Elías, q'alajisal re ru Loq' Pixab' ri Dios ojer. Kub'an na chi ri nan tat ketzelejik keutzir kuk' ri kalk'ual, xuquje' chi ri winaq ri käkiyak kib' chrij ri Dios käkik'ex na kanima', käkik'ex ri ki chomanik, käketamaj na ri nimanik, ketzelej ki wäch kuk' ri utzalaj taq winaq, käka'n na ke ri e are'. Ri a Juan kub'an na chke ri winaq chi kekowin na chuk'ulaxik ri Qajaw, —xcha ri ángel che ri tat Zacarías. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Xuta' k'u ri tat Zacarías che ri ángel, xub'ij: ¿Jas ta kinb'an che retamaxik wa' chi qas tzij ri kätzijoj la chwe? Ri in, in ri'j achi chik, xuquje' ri wixoqil are nim winaq chik, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Xch'aw chi na jumul ri ángel, xub'ij che: In ri' ri Gabriel, in patänil re ri Dios. In taqom k'u loq che a tzijob'exik, che ki tzijoxik we utzalaj taq tzij ri' chawe, —kächa che. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Tzche we kämik ri' man katkowin tä chik katch'awik k'ä kopan na ri q'ij ri käb'antaj na wa' ri xinb'ij chawe, k'ä kil na u wäch ri a k'ojol rumal rech wa' chi man xakoj tä ri nu tzij, —kächa ri'. Käb'antaj na wa' we nu tzijom ri' tzpa ru q'ijol, —xcha ri ángel che. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ri winaq k'ut keye'm ri tat Zacarías. Xkikajmaj wa' chi sib'alaj xb'eytaj pa ri loq'alaj k'olib'al ri sib'alaj äwas chi kok b'i xa apachinoq. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Aretaq xel loq ri tat Zacarías, man xkowin tä chik che ki ch'ab'exik ri winaq. Xketamaj chi k'o jas ri xuk'ut rib' chuwäch ri tat Zacarías pa ri loq'alaj k'olib'al. Xaq pa memal chik xeuch'ab'ej, rumal chi xmemar kanoq. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Aretaq xetz'aqat ri q'ij ri käpatänin ri tat Zacarías pa ri nimalaj rachoch Dios, xe' ri are' cho rachoch. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Te k'u ri' ri nan Elisabet xkanaj yawab' winaq chik, xkanaj k'u job' ik' cho rachoch. Xub'ij ri nan Elisabet pa ranima': ");
INSERT INTO qucNNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Xka'y ri Qajaw Dios chwe, xutoq'ob'isaj k'u nu wäch rech man kinkiyoq' tä chi ri winaq,” —xcha ri nan Elisabet. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Chuwaq ik' chi k'ut ri Dios xutaq b'i ri ángel Gabriel pa ri tinimit Nazaret re Galilea. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Xopan k'u ruk' jun q'apoj ali, María u b'i', ri tz'onom chik rumal jun achi, José u b'i'. We achi ri' rachalaxik kan ri nim taqanel David ojer. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ri ángel xok b'i chila' jawije' k'o wi ri q'apoj al María, xub'ij che: ¿A utz a wäch, María? —kächa'. ¡At ri' ri at cha'tal rumal ri Dios! Qas k'o ri Qajaw Dios awuk', —kächa che. Ri at k'ut, at tewchim na rumal ri Dios chkiwäch konojel ixoqib', —xcha ri ángel che ri al María. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Aretaq ri al María xril ri ángel, xutatab'ej ru tzij, xt'ujuw k'u ri ranima' rumal ri xb'ix che. Xuchomaj pa ranima', xub'ij: ¿Jas wa' ri kub'ij chwe? —xcha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Xch'aw chi ri ángel, xub'ij che ri q'apoj al María: Maxej awib', María, —kächa che. Ri at sib'alaj at loq' cho ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ri at k'ut katkanaj kan yawab' winaq. Kawil na u wäch jun awal ala ri kakoj na “Jesús” che ru b'i', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Känimar na u q'ij ri a Jesús. Käb'ix na u K'ojol ri Dios aj Chikaj che. Ri Qajaw Dios kukoj na che nim taqanel je' jas ra mam David. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Je ri' rech kätaqan na puwi' ri tinimit Israel pa taq ri q'ij ri junab' ri kepetik. Ru taqanik ri Are', man k'o tä u k'isik, —xcha ri ángel che ri al María. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Te ri' ri al María xuta' che ri ángel, xub'ij: ¿Jas lo kink'ulmaj wa'? —kächa'. Mäja' kink'oji ruk' achi, —xcha che ri ángel. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Xch'aw k'u ri ángel, xub'ij che: Käqaj na loq ri Loq'alaj Espíritu pa wi'. Ri Dios aj Chikaj käroqxanej na wa' awuk' rumal ru chuq'ab'. Rumal ri' we loq'alaj ak'al ri' ri kil na u wäch käb'ix na u K'ojol ri Dios che, —kächa che. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Xuquje' ri nan Elisabet ri awachalal are' käril na u wäch jun ak'al pune ri'j chik. Are k'u waqib' ik' wa' kämik yawab' winaq chik ri nan Elisabet pune xb'ix kanoq che chi man käkowin tä che ri alk'ualanik. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Man k'o tä k'u jas ri mat käkowin ri Dios chub'anik, —xcha ri ángel. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Xub'ij k'u ri q'apoj al María: In ri' ri patänil re ri Qajaw Dios. Chub'ana b'a' ri Are' chwe jas ri tzijom la chwe, —xcha che. Xel k'u b'i ri ángel chuwäch. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Pa taq ri q'ij ri' xel b'ik ri al María cho ja, xe' aninaq pa jun tinimit ri k'o pa taq ri u juyub'al ri Judea. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Xok k'u b'ik pa rachoch ri tat Zacarías, xuya rutzil u wäch ri nan Elisabet ri rixoqil. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ri nan Elisabet, aretaq xuta ru tzij ri al María, xslab' k'u ri ral pa ru k'ux. Xqaj ri Loq'alaj Espíritu puwi' ri nan Elisabet, xtaqan k'u pa ranima'. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ko xch'aw ri nan Elisabet, xub'ij che ri al María: Ri at k'ut at tewchim na rumal ri Dios chkiwäch konojel ixoqib'. U tewchim na ri awal at xuquje', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Jas lo wa' chi ri Dios kub'an jun nimalaj utzil chwe in, chi ru nan ri Qajaw xpe wuk'? —kächa ri nan Elisabet. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Chanim ri' aretaq xinto chi xatch'awik, ri wal xkikotik, xslab' pa nu k'ux. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Utz awe at ri xatkojon che ri Qajaw Dios, rumal chi qas tzij käb'antaj na ri xb'ix chawe rumal ri Dios, —xcha ri nan Elisabet che ri al María. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Xub'ij ri q'apoj al María: Kinnimarisaj u q'ij ri Qajaw Dios. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Käkikot k'u ri wanima' rumal ri Dios ri To'l We. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kinkikotik rumal chi ri Dios xka'y chwe in ru patäninel ri man nim tä nu b'anik. Konojel winaq käkib'ij na chwe pa taq ri q'ij ri junab' ri kepetik chi utz we. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Je ri' käkib'ij na rumal rech wa' chi ri Dios ri sib'alaj k'o u chuq'ab' u b'anom nimaq taq utzil chwe. Sib'alaj loq' ri Dios, sib'alaj loq' ru b'i' ri Are', —kächa ri al María. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Amaq'el ronojel q'ij kutoq'ob'isaj na ki wäch konojel winaq ri nim käkil wi ri Are', ri käkixej kib' chuwäch. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","U k'utum ri nimalaj u chuq'ab' chkiwäch konojel. Xuqasaj ki q'ij ri winaq ri käkichomaj chi sib'alaj nim ki b'anik, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Xeresaj ri taqanik pa ki q'ab' ri nimaq ki b'anik, xuya k'u wa' chke ri winaq ri man nim tä keil wi. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","E k'ia ri utzil ri xub'an ri Dios chke ri meb'a'ib', ri winaq ri kenumik. Ri Dios xub'ij chke ri q'inomab': Jix, man k'o tä iwe ix, —xcha chke, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Xtob'an chke ri winaq aj Israel, ri patänil taq re ri Dios. Man xsach tä pu jolom ri Dios ru toq'ob'isaxik ki wäch. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Je' xub'an wa' rumal chi je' xuchi'j chke ri qati't qa mam, che ri qa mam Abraham xuquje' ri rachalaxik ri are' amaq'el pa taq ri q'ij ri junab' ri kepetik, —xcha ri al María. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Kraj oxib' ik' xkanaj na kan ri al María ruk' ri nan Elisabet. Te k'u ri' xtzelej b'ik, xe' cho rachoch. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Aretaq xopan ri q'ij ri kutzir ri nan Elisabet, xril k'u u wäch jun ral ala. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ri u k'ul taq ja ri nan Elisabet xuquje' ri rachalaxik, aretaq xkito chi ri Qajaw Dios sib'alaj xutoq'ob'isaj u wäch ri nan Elisabet, xekich'ab'ej, xekikot k'u ruk'. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Chuwajxaq q'ij k'ut xeb'e' chukojik ri retal ri ojer u trato ri Dios che ru cuerpo ri ak'al. Xkaj k'ut xkikoj Zacarías che ru b'i', junam ruk' ru b'i' ru tat. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Xch'aw k'u ru nan, xub'ij chke: ¡No! —kächa'. Ru b'i' ri käqakoj chrij ri ak'al are Juan, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Xkib'ij k'u che: ¿Jas che? Man k'o tä jun chke ri achalal la ri je' u b'i' wa', —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Xaq pa memal xkich'ab'ej ru tat ri ak'al, xkita' che: ¿Jas u b'i' ri ak'al käkoj la? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ri tat Zacarías xuta' jun wuj rech kätz'ib'anik. Xutz'ib'aj k'u wa', xub'ij: “Juan ru b'i' ri ak'al,” —xcha pa ri tz'ib'anik. Konojel xkikajmaj wa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Xaq k'u te'talik xtzelej ru ch'ab'al ri tat Zacarías, xkowin chik kätzijonik. Xtzijon k'ut, xunimarisaj u q'ij ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Sib'alaj xkixej kib' konojel ri ki k'ul taq ja, xkikajmaj wa'. Ronojel ri xuk'ulmataj jela' xtzijox apan pa taq ronojel ri juyub' re Judea. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Konojel ri winaq ri xetowik xechoman pa ke wi, xkib'ij: ¿Jas lo kub'an wa' we ak'al ri'? —xecha'. Je' xkib'ij wa' rumal chi q'alaj chi k'o ri Qajaw Dios ruk' ri ak'al. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Qajinaq ri Loq'alaj Espíritu puwi' ri tat Zacarías ru tat ri ala, xq'alajisanik, xub'ij: ");
INSERT INTO qucNNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Kinya b'a' u q'ij ri Qajaw ri qa Dios uj, uj ri' ri winaq aj Israel, rumal chi xulik, xpe che qa to'ik uj, uj k'u ri' ri winaq re ri u tinimit. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Xuya k'u chqe jun To'l Qe ri sib'alaj k'o u chuq'ab'. Are k'u wa' jun chke ri rachalaxik ri qa mam David, patänil re ri Dios, —kächa ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Are wa' ri xuchi'j loq ri Dios kumal ri loq'alaj taq q'alajisal taq re ru Loq' Pixab' pa ri ojer taq q'ij kanoq. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Xub'ij chi kujuto' na chkiwäch ri qa k'ulel, che qa to'ik pa ki q'ab', xuquje' pa ki q'ab' konojel ri keetzelan qa wäch, —kächa ri tat Zacarías. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Xuquje' xub'ij chi kutoq'ob'isaj na ki wäch ri qati't qa mam, xuquje' chuk'utik chkiwäch chi xna'taj che ri Are' ri Loq'alaj Trato ri xuchi'j chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Are k'u wa' ri Qas Tzij ri u b'im che ri qa mam Abraham, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Je ri' rech aretaq uj esam chik pa ki q'ab' ri qa k'ulel, kuya' kujpatänin che ri Dios, man käqaxej tä chi qib', ");
INSERT INTO qucNNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","xuquje' rech jikom ri qanima' kujpatänin che, qa jachom qib' pu q'ab' ri Dios pa taq ronojel ri q'ij re ri qa k'aslemal, —kächa ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","At k'ut, alaj ak'al, käb'ix na q'alajisal re ru Loq' Pixab' ri Dios aj Chikaj chawe, rumal chi katnab'ej na chuwäch ri Qajaw chub'anik jikom che ru b'e. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","At k'ut katyo'w na retamaxik ri u tob'anik ri Dios chke ri winaq re ri u tinimit, xuquje' chi käsach na ri ki mak, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ri qa Dios sib'alaj kel u k'ux chqe. Rumal ri' kutaq na loq ri Qajaw Jesús quk' uj. Sib'alaj je'l k'u ri Are' je' jas ru saqilal ri q'ij aretaq käsaqirik. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Kuya na saqilal pa kanima' ri winaq ri je' ta ne e k'o pa ri q'equmal rumal ri ki mak, käkixej k'u kib' cho ri kämikal. Käk'oji na che k'amal qa b'e pa ri b'e ri kuxlan wi ri qanima', —xcha ri tat Zacarías. ");
INSERT INTO qucNNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ri a Juan xk'iyik, sib'alaj k'o u chuq'ab' ri xyi' che rumal ri Loq'alaj Espíritu. Xkanaj kan pa taq ri juyub' ri sib'alaj kätz'inowik k'ä pa ri q'ij ri xuk'ut rib' chkiwäch ri winaq aj Israel. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Pa taq ri q'ij ri', ri nimalaj taqanel Augusto César xuya taqanik chke konojel winaq chi kätz'ib'ax ri ki b'i'. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Aretaq ri tat Cirenio are q'atal tzij re ri tinimit Siria, xb'antaj we nab'e tz'ib'an b'i'aj ri'. Are jun censo wa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Xeb'e' k'u konojel ri winaq chkijujunal pa taq ri ki tinimit rech kätz'ib'ax ri ki b'i'. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Xa je ri' xel loq ri tat José pa ri tinimit Nazaret re Galilea, xe'k, xopan pa jun tinimit re Judea, Belén u b'i'. Chila' xe' wi ri tat José rumal chi are rachalaxik ri mam David. Ri tinimit Belén are u tinimit ri mam David pa ojer taq q'ij kanoq. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Aretaq xe' ri tat José rech kätz'ib'ax ru b'i', xuk'am b'i ri al María ri u to'm chik che rixoqil, yawab' winaq chi k'ut. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Aretaq e k'o chila' pa Belén, xopan ri q'ij ri kutzir ri al María. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Xril k'u u wäch ru nab'eal, jun ala. Xukoj atz'iaq rech nu'ch ak'al che. Xuq'oyob'a pa jun echa'b'al rumal chi man k'o tä chi jawije' ri kek'oji wi pa ri mesón. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","E k'o k'u ajyuq'ab' pa taq ri juyub' chunaqaj ri tinimit Belén ri kekiwaraj ri kawaj chila'. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Xaq te'talik k'ut jun ángel taqom loq rumal ri Qajaw Dios xtak'i chkiwäch. Xjuluw k'u ri je'lalaj u juluwem ri Dios pa ki wi'. Sib'alaj k'u xkixej kib' ri ajyuq'ab'. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Xub'ij k'u ri ángel chke: Mixej iwib', —kächa'. Qas tzij kinb'ij na jun utzalaj tzij chiwe. Ri u patän wa' we utzalaj tzij ri' are chi kuya nimalaj kikotemal chke konojel winaq. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Are kinb'ij chiwe chi kämik ri' xil u wäch jun To'l Iwe pa ru tinimit ri mam David. Are Cristo wa' ri Qajaw, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Are k'u retal wa' chiwe: Kiriq na jun alaj ne', kojom k'u atz'iaq rech nu'ch ak'al chrij, q'oyob'am pa jun echa'b'al, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Xaq te'talik k'ut e k'o chik ruk' ri ángel k'ialaj taq ángeles ajchikaj. Käkinimarisaj k'u u q'ij ri Dios, käkib'ij: ");
INSERT INTO qucNNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Qanimarisaj b'a' u q'ij ri Dios ri k'o chikaj! ¡Chuxlan na kanima' ri winaq cho ruwächulew, e are k'u winaq wa' ri utz keril wi ri Dios! —xecha ri ángeles. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Te k'u ri' aretaq xeb'e' ri ángeles chikaj, ri ajyuq'ab' xkitzijob'ela kib', xkib'ij: Jo' pa Belén, —kecha'. Jeqila na we xk'ulmatajik ri' ri u tzijom ri Qajaw Dios chqe, —xecha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Aninaq xeb'e'k. Xekiriqa k'u ri nan María, ri tat José ruk' ri alaj ne'. Q'oyob'am k'u ri ne' pa jun echa'b'al. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Aretaq xkilo, xkitzijoj ri xub'ij ri ángel chke chrij ri ak'al. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Xkikajmaj k'u wa' konojel ri winaq ri xetow ri ki tzij ri ajyuq'ab'. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Are k'u ri nan María xaq xuk'ol konojel we tzij ri' pa ranima', xchoman k'u chkij. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Xetzelej k'u b'ik ri ajyuq'ab', tajin käkiya u q'ij, käkinimarisaj k'u u q'ij ri Dios rumal ri xb'ix chke, xuquje' rumal chi xkilo chi qas je' jas ri xutzijoj ri ángel chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Chuwajxaq q'ij k'ut, xkikoj ri retal ri ojer trato che ru cuerpo ri ak'al, xkikoj k'u Jesús che ru b'i'. Are u b'i' wa' ri xukoj kan ri ángel aretaq mäjoq kalk'ualax chuk'ux ri q'apoj al María. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Xopan ri q'ij ri kesax ri rawasil ri nan María. Je' jas ri kub'ij chupam ru Pixab' ri mam Moisés, xkik'am loq ri ak'al chuyi'k chuwäch ri Qajaw Dios pa ri tinimit Jerusalén. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Je ri' xka'no rumal chi tz'ib'am wa' pa ru Pixab' ri Qajaw Dios, kub'ij: “Ronojel nab'eal ala kätas wa' chupatänixik ri Qajaw Dios,” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Xeb'e' k'u ri tat José, ri nan María pa Jerusalén chusipaxik ri käb'ix pa ru Pixab' ri Qajaw Dios: Are juk'ulaj ut wa'. We man k'o tä ri ut kuya' keyi' kieb' alaj taq tukumux che sipanik. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Xk'oji k'u pa ri tinimit Jerusalén jun tata', Simeón u b'i'. We tata' ri' are utzalaj achi wa' ri käniman che ri Dios pa ronojel, jikom k'u ranima' chuwäch. Ri are' reye'm ri Dios chi keuto' ri winaq aj Israel. K'o k'u ri Loq'alaj Espíritu ruk'. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Xq'alajisax che ri tat Simeón rumal ri Loq'alaj Espíritu chi man käkäm tä na chanim, xane nab'e käril na ri Cristo ri cha'tal rumal ri Qajaw Dios. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Xuna' k'u ru rayinik ri Loq'alaj Espíritu pa ranima', xe' pa ri nimalaj rachoch Dios. Aretaq ru tat, u nan ri alaj a Jesús xkik'am b'ik, xeopan pa ri nimalaj rachoch Dios chub'anik che ri ak'al jas ri kub'ij pa ri Pixab' chi rajwaxik u b'anik wa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ri tat Simeón xuq'aluj ri ala, xuya u q'ij ri Dios. Xub'an orar, xub'ij: ");
INSERT INTO qucNNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Qajaw Dios, ya la chwe kämik chi ri in, ri in patänil e la, chi kinkäm na, kuxlan ri wanima', je' jas ri b'im la loq chwe, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Wilom k'u in ri To'l Qe, ");
INSERT INTO qucNNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ri taqom la loq chkiwäch konojel winaq. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Are je' jas jun chäj, jun candela ri kätununik. Kuya na ri saqil re ri Pixab' la pa kanima' ri nik'iaj winaq chik ri man e aj Israel taj. Rumal wa' ri taqom la loq, känimarisax na u q'ij ri tinimit la, ri Israel, —xcha ri tat Simeón. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ri tat José ruk' ru nan ri ak'al xkikajmaj ronojel ri kätzijox chrij ri a Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ri tat Simeón xeutewchij, xub'ij che ri nan María, u nan ri ak'al: Chilampe la we ak'al ri', —kächa'. Käkoj na wa' rech ketzaq k'ia winaq aj Israel, käsach k'u na ki wäch. Keto' k'u na ri jule' winaq chik aj Israel rumal ri Are', kewalijisax na. Xuquje' we ak'al ri' käkoj na rumal ri Dios che etal chkiwäch ri winaq. Käketzelaj k'u na u wäch, —kächa ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Kub'an na ri Qajaw Jesús chi käq'alajinik jas ri kechoman ri winaq pa kanima', —kächa chke. Ri lal, nan, käk'is na ib' la che oq'ej, —xcha che ri nan María. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Xuquje' xk'oji chila' jun chichu' q'alajisanel, Ana u b'i'. Are u mia'l ri tat Fanuel re ri rachalaxik ri mam Aser. Sib'alaj nim winaq chik ri chichu' ri'. Xa wuqub' junab' xk'oji ruk' ri rachajil, xkäm k'u ri tata'. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Jumuch' kiejeb' junab' malka'n kanoq. Man kel tä chi b'i pa ri nimalaj rachoch Dios. Käpatänin k'u che ri Dios chila' chi paq'ij chi chaq'ab'. Kub'an orar, xuquje' kub'an ayunar. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Xtak'atob' k'u wa' chkiwäch ri tat José, ri nan María pa we hora ri', xub'an maltioxinik che ri Dios. Xtzijon chrij ri a Jesús chkiwäch konojel ri winaq ri e eyeninaq che ri Dios chi kuto' ri tinimit Israel. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ki b'anom k'u ronojel ri käb'ix pa ru Pixab' ri Qajaw Dios, xetzelej k'u b'ik, xeb'e' pa Galilea, pa ri ki tinimit Nazaret. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","K'iyem re ri ak'al, tajin käkowirik, sib'alaj k'o ru no'j. Ri Dios sib'alaj tajin kätewchin ri a Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ronojel junab' k'ut xeb'e' ru tat, ru nan pa ri tinimit Jerusalén che ri nimaq'ij ri käb'ix Pascua che. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Aretaq kab'lajuj u junab' chik ri a Jesús, xepaqi b'ik, xeb'e' pa Jerusalén jas ri ki naq'atisam wi kib' pa ri nimaq'ij ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Xk'is k'u ri nimaq'ij, tzelejem käka'n b'ik ri tat José, ri nan María. Xkanaj kan ri alaj a Jesús pa Jerusalén, man k'o tä k'u ketam ru tat, u nan chrij wa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Xkichomaj chi k'o kuk' ri kachi'l. E b'enaq jun q'ij pa ri b'e, xkitzukuj ri a Jesús chkixol ri kachalal, chkixol ri kachi'l. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Man xkiriq tä k'ut. Xa je ri' xetzelej chik pa Jerusalén. Xkitzukuj ri ala chila'. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ki tzukum k'u oxib' q'ij, xkiriq k'u pa ri nimalaj rachoch Dios. T'uyul ri a Jesús chkixol ri tijonelab' re ri Pixab', tajin kutatab'ej ri ki tijonik. Kuk'ot k'u ki chi' ri tata'ib'. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Konojel ri ketowik xkikajmaj chi utz kächoman ri ala, chi retam jas kub'ij chke ri tijonelab'. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Aretaq ru tat, u nan xkil u wäch ri ak'al, xkikajmaj wa'. Xub'ij ru nan che: Wal, ¿jas che je' a b'anom wa' chqe? —kächa'. ¿A mat kawilo chi ra tat, ri in, uj elinaq ch'uj chatzukuxik? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Xub'ij k'u ri a Jesús chke: ¿Jas che kintzukuj alaq? ¿A mat etam alaq chi rajwaxik chi kinb'an ri u rayinik ri nu Tat? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ri e are' man xkich'ob' tä k'u ri kub'ij ri ak'al chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Xe' k'u ri a Jesús ruk' ri tat José, ruk' ru nan pa ri tinimit Nazaret. U yo'm k'u rib' pa taqik chke. Ru nan xuk'ol pa ranima' ronojel ri xb'antajik. ");
INSERT INTO qucNNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Xk'iy ri a Jesús, k'o na ru no'j, xuquje' xkowirik. Ri a Jesús sib'alaj utz kub'an cho ri Dios, xuquje' utz käkil wi ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Pa ri ro'lajuj junab' ri tajin kätaqan ri tat Tiberio César ri nimalaj taqanel, aretaq ri tat Poncio Pilato are q'atal tzij puwi' ri Judea, ri tat Herodes k'ut are nim taqanel puwi' ri Galilea. Ri tat Felipe, rachalal ri tat Herodes, are q'atal tzij pa Iturea xuquje' pa Traconite. Ri tat Lisanias are q'atal tzij pa Abilinia. ");
INSERT INTO qucNNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ri tat Anás, ri tat Caifás e are' ki nimaqil sacerdotes kech ri winaq aj Israel. Pa taq ri q'ij ri' ri Dios xutzijob'ej ri tat Juan, ru k'ojol ri tat Zacarías. K'o k'u ri tat Juan pa taq juyub' ri kätz'inowik. ");
INSERT INTO qucNNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ri tat Juan xub'inib'ej konojel taq ri juyub' ri e k'o chunaqaj ri nima' Jordán, kutzijoj k'u chke ri winaq chi rajwaxik käkik'ex ki chomanik, käk'ex k'u kanima', te k'u ri' käb'an ki qasna' rech käq'alajinik chi je' ki b'anom wa'. Xa je ri' käsachtaj ri ki mak. ");
INSERT INTO qucNNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Je' jas ri kub'ij pa ri wuj ri tz'ib'am wi ru tzij ri ojer q'alajisal re ru Loq' Pixab' ri Dios, ri Isaías: K'o jun ri ko käch'aw pa taq ri juyub' ri ketz'inowik, kub'ij: “Chib'ana u b'anik ri nim b'e ri käb'in wi ri Qajaw. Chib'ana sib'alaj jikom che ri alaj taq u b'e,” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","“Kenojisax na konojel taq ri siwan, kelianisax na konojel taq ri juyub', ri nimaq xuquje' ri ch'utiq. Ri b'e ri e kotakik kejikomisax na. Ri b'e ri sib'alaj e k'äx na chelianisaxoq,” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","“Konojel winaq käkil k'u na jas kub'an ri Dios che ki to'ik ri winaq ajmakib',” —xcha ri mam Isaías. ");
INSERT INTO qucNNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Xub'ij k'u ri tat Juan chke ri k'ia winaq ri xeopan ruk' rech käb'an ki qasna': ¡Alaq sub'anelab' taq winaq, kachalaxik tz'i'! ¿Jachin k'u ri' ri xk'utuw chuwäch alaq chi rajwaxik kanimaj alaq b'i cho ri royowal ri Dios? —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","B'ana b'a' alaq ri taqal u b'anik ri kuq'alajisaj chi qas tzij xk'extaj anima' alaq. Mächaplej alaq u b'ixik xol taq alaq: “Utz qe rumal chi ri uj, uj rachalaxik ri qa mam Abraham,” —mächa ne alaq. Kinb'ij na chech alaq chi ri Dios käkowin chub'anik chke taq we ab'aj ri' chi e rachalaxik chik ri qa mam Abraham, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Chanim ri' tajin käkoj ri ikiäj chke taq ri ki xera' ri che' rech ket'oyik. Ronojel che' ri man kuya tä utzalaj u wäch kät'oy na, kek'iäq k'u b'i pa ri q'aq', —xcha ri tat Juan chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Xkita' k'u ri k'ia winaq che, xkib'ij: ¿Jas ta k'u lo käqa'n na? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Xch'aw chi ri tat Juan, xub'ij chke: Apachin k'u ri k'o kieb' u q'u', chuya jun re che ri winaq ri man k'o tä re. Apachin ri k'o kutijo, chuya re ri winaq ri man k'o tä kutijo, —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Xeopan xuquje' jujun chke ri toq'il taq alkab'al rech käb'an ki qasna', xkib'ij k'u che ri tat Juan: Qajtij, ¿jas käqa'n na uj? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Xub'ij ri tat Juan chke: Mitoq'ij u wi' ri ix taqom wi chutoq'ixik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Xuquje' ri soldados xkita' che, xkib'ij: E k'u ri uj, ¿jas käqa'n na? —xecha che. Xub'ij ri tat Juan chke: Mib'an elaq' che jachin jun winaq, mib'ana k'u k'äx chke. Mib'ij jalum q'ab'am chkij ri winaq. Chiku'b'a k'u i k'ux ruk' ri tojb'al iwe, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ri winaq k'ut tajin kechoman pa kanima' chrij ri tat Juan, tajin keye'n che rilik we ne ri tat Juan are ri Cristo. ");
INSERT INTO qucNNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Xch'aw chi ri Juan Qasal Ja', xub'ij chke konojel: Petinaq jun achi ri k'o na u chuq'ab' chnuwäch in. Man taqal tä k'u chwe in chi kinkir ru k'amal u xajäb'. Ri are' kuya na ri Loq'alaj Espíritu chech alaq je' jas ri in kinb'an qasna' alaq ruk' joron. Kub'an k'u na qasna' alaq ruk' q'aq', —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ri achi ri' kuk'am ru jopib'al rech kujosq'ij ri triko, xuquje' rech kumulij b'ik ru triko, kuya k'u pa taq ru k'uja. Xuquje' ne kuporoj ri pajo, kub'an jun q'aq' ri man käkowin tä jun chuchupik, —kächa'. Jas ri kub'an ri achi ajchak che ri triko, je ri' xuquje' kub'an na ri Qajaw Dios chke taq winaq, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Je ri' xub'ij ri tat Juan, xuquje' xeupixb'aj ri winaq kuk' k'ia pixab' chik, xutzijoj k'u ri Utzalaj Tzij re ri Evangelio chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Xuquje' ri tat Juan xuyaj ri q'atal tzij Herodes rumal chi ri tat Herodes xuch'ab'ej ri nan Herodías, rixoqil ri tat Felipe ru chaq' ri Herodes. Xuyaj k'u ri tat Herodes xuquje' kumal konojel ri etzelal ri u b'anom. ");
INSERT INTO qucNNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ri tat Herodes xa xunimarisaj u b'anik ri man utz taj puwi' ronojel ri u b'anom, chi xukoj ri tat Juan pa che'. ");
INSERT INTO qucNNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Pa jun q'ij aretaq ri tat Juan tajin kub'an ki qasna' konojel ri winaq, xub'an u qasna' ri Jesús xuquje'. Pa ri qasna' ri Jesús tajin kub'an orar, xjaqtaj k'u ri kaj. ");
INSERT INTO qucNNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Xqaj k'u loq ri Loq'alaj Espíritu puwi' ri Jesús je' ta ne chi ri Loq'alaj Espíritu are jun palomäx. Te k'u ri' xch'aw loq Jun chikaj, xub'ij: At ri' ri loq'alaj nu K'ojol. Sib'alaj käkikot ri wanima' awumal, —xcha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Kraj ne juwinaq lajuj u junab' ri Jesús aretaq xuchaplej patäninem cho ri Dios. Xkichomaj ri winaq chi ri Jesús are ralk'ual ri tat José. Ri tat José k'ut are rachalaxik ri tat Elí, ");
INSERT INTO qucNNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ri tat Elí are ralk'ual ri tat Matat, ri tat Matat ralk'ual ri tat Leví, ri tat Leví are ralk'ual ri tat Melqui, ri tat Melqui are ralk'ual ri tat Jana, ri tat Jana ralk'ual ri tat José, ");
INSERT INTO qucNNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ri tat José ralk'ual ri tat Matatías, ri tat Matatías ralk'ual ri tat Amós, ri tat Amós ralk'ual ri tat Nahum, ri tat Nahum ralk'ual ri tat Esli, ri tat Esli ralk'ual ri tat Nagai, ");
INSERT INTO qucNNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ri tat Nagai ralk'ual ri tat Maat, ri tat Maat ralk'ual ri tat Matatías, ri tat Matatías ralk'ual ri tat Semei, ri tat Semei ralk'ual ri tat José, ri tat José ralk'ual ri tat Judá, ");
INSERT INTO qucNNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ri tat Judá ralk'ual ri tat Joana, ri tat Joana ralk'ual ri tat Resa, ri tat Resa ralk'ual ri tat Zorobabel, ri tat Zorobabel ralk'ual ri tat Salatiel, ri tat Salatiel ralk'ual ri tat Neri, ");
INSERT INTO qucNNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ri tat Neri ralk'ual ri tat Melqui, ri tat Melqui ralk'ual ri tat Adi, ri tat Adi ralk'ual ri tat Cosam, ri tat Cosam ralk'ual ri tat Elmodam, ri tat Elmodam ralk'ual ri tat Er, ");
INSERT INTO qucNNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ri tat Er ralk'ual ri tat Josué, ri tat Josué ralk'ual ri tat Eliezer, ri tat Eliezer ralk'ual ri tat Jorim, ri tat Jorim ralk'ual ri tat Matat, ");
INSERT INTO qucNNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ri tat Matat ralk'ual ri tat Leví, ri tat Leví ralk'ual ri tat Simeón, ri tat Simeón ralk'ual ri tat Judá, ri tat Judá ralk'ual ri tat José, ri tat José ralk'ual ri tat Jonán, ri tat Jonán ralk'ual ri tat Eliaquim, ");
INSERT INTO qucNNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ri tat Eliaquim ralk'ual ri tat Melea, ri tat Melea ralk'ual ri tat Mainán, ri tat Mainán ralk'ual ri tat Matata, ri tat Matata ralk'ual ri tat Natán, ri tat Natán ralk'ual ri tat David, ");
INSERT INTO qucNNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ri tat David ralk'ual ri tat Isaí, ri tat Isaí ralk'ual ri tat Obed, ri tat Obed ralk'ual ri tat Booz, ri tat Booz ralk'ual ri tat Salmón, ri tat Salmón ralk'ual ri tat Naasón, ");
INSERT INTO qucNNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ri tat Naasón ralk'ual ri tat Aminadab, ri tat Aminadab ralk'ual ri tat Aram, ri tat Aram ralk'ual ri tat Esrom, ri tat Esrom ralk'ual ri tat Fares, ri tat Fares ralk'ual ri tat Judá, ");
INSERT INTO qucNNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ri tat Judá ralk'ual ri tat Jacob, ri tat Jacob ralk'ual ri tat Isaac, ri tat Isaac ralk'ual ri tat Abraham, ri tat Abraham ralk'ual ri tat Taré, ri tat Taré ralk'ual ri tat Nacor, ");
INSERT INTO qucNNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ri tat Nacor ralk'ual ri tat Serug, ri tat Serug ralk'ual ri tat Ragau, ri tat Ragau ralk'ual ri tat Peleg, ri tat Peleg ralk'ual ri tat Heber, ri tat Heber ralk'ual ri tat Sala, ");
INSERT INTO qucNNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ri tat Sala ralk'ual ri tat Cainán, ri tat Cainán ralk'ual ri tat Arfaxad, ri tat Arfaxad ralk'ual ri tat Sem, ri tat Sem ralk'ual ri tat Noé, ri tat Noé ralk'ual ri tat Lamec, ");
INSERT INTO qucNNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ri tat Lamec ralk'ual ri tat Matusalén, ri tat Matusalén ralk'ual ri tat Enoc, ri tat Enoc ralk'ual ri tat Jared, ri tat Jared ralk'ual ri tat Mahalaleel, ri tat Mahalaleel ralk'ual ri tat Cainán, ");
INSERT INTO qucNNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ri tat Cainán ralk'ual ri tat Enós, ri tat Enós ralk'ual ri tat Set, ri tat Set ralk'ual ri tat Adán, ri tat Adán are ralk'ual ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Xel b'i ri Jesús pa ri nima' Jordán, xtzelej k'u loq qajinaq ri Loq'alaj Espíritu puwi'. Te ri' ri Espíritu xuk'am b'i ri Jesús pa taq juyub' ri kätz'inowik. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Xk'oji k'u chila' kawinaq q'ij, kätaqchi'x k'u che mak rumal ri Itzel. Man k'o tä k'u jas xutij pa taq ri q'ij ri'. Te k'u ri' sib'alaj xnumik. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Xub'ij k'u ri Itzel che: We lal ri' ri u K'ojol ri Dios, b'ij la che we ab'aj ri' chi kub'an na wa che la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ri Jesús xch'awik, xub'ij che: Tz'ib'am kan wa' pa ru Loq' Pixab' ri Dios ri Tz'ib'talik, kub'ij: “Man xaq tä xuwi rumal ri wa kek'asi na ri winaq, xane xuquje' rumal ronojel ru Tzij ri Dios,” —kächa ri', —xcha ri Jesús che. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Te k'u ri' ri Itzel xuk'am b'i ajsik puwi' jun nimalaj juyub'. Xeuk'utuxtaj konojel ri tinimit re ruwächulew chuwäch. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Xub'ij k'u che ri Jesús: Kinya na che la chi kätaqan la pa ki wi' konojel we tinimit ri' xuquje' chi känimarisax q'ij la rumal wa', —kächa'. Yo'm k'u ronojel wa' chwe in. Ri in k'ut kuya' kinya wa' che apachin ri kinwaj kinya wi, —xcha ri Itzel che. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","We käxuki la kinq'ijilaj la kinya wa' che la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ri Jesús xch'awik, xub'ij: ¡Satanás! Chatel chnuwäch, —xcha'. Rumal chi tz'ib'am pa ru Loq' Pixab' ri Dios, kub'ij: “Chatq'ijilan na chwe in ri Awajaw ri a Dios. Chatpatänin xaq xuwi chwe in,” —kächa ri u Tzij ri Dios, —xcha ri Jesús che. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ri Itzel xuk'am b'ik ri Jesús pa ri tinimit Jerusalén, xutak'ab'a puwi' ri nimalaj rachoch Dios, xub'ij che: We lal ri' ri u K'ojol ri Dios, k'iäqa b'i ib' la ikim, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Rumal chi ru Loq' Pixab' ri Tz'ib'talik kub'ij: Keutaq na loq ri ángeles che a chajixik, —kächa', —xcha ri Itzel che. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Xuquje' kub'ij pa ru Loq' Pixab' ri Dios: Katkichap na che ra q'ab' che a to'ik rech man kachäq'ij tä rawaqan cho jun ab'aj, —kächa ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Xch'aw chi na jumul ri Jesús, xub'ij: Xuquje' kub'ij pa ru Loq' Pixab' ri Dios ri Tz'ib'talik: “Mayak royowal ri Qajaw ri qa Dios,” —kächa', —xcha ri Jesús che. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Aretaq ri Itzel xto'taj chutaqchi'xik ri Jesús che mak, xel b'i ruk'. Kätzelej chi na loq jumul pa jun q'ij chik. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Xtzelej k'u b'i ri Jesús, k'o k'u ru chuq'ab' ri Loq'alaj Espíritu ruk'. Xe' pa Galilea. Ri winaq ajchila' xetzijon chrij ri Jesús pa ronojel tinimit. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ri Jesús xuya tijonik pa taq ri rachoch Dios ri käkimulij wi kib' ri winaq aj Galilea. Konojel xkinimarisaj u q'ij. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Xtzelej b'i ri Jesús, xe' pa ri tinimit Nazaret jawije' xk'iyisax wi. Pa ri q'ij re uxlanem xok b'i pa ri rachoch Dios jas ru naq'atisam wi rib', xtak'i k'ut chusik'ixik ru Loq' Pixab' ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Xyi' k'u ri wuj che ri xutz'ib'aj ri mam Isaías, q'alajisal re ru Loq' Pixab' ri Dios ojer. Aretaq xujaq ri wuj, xuriqo jawije' ri tz'ib'tal wi ri', ri kub'ij: ");
INSERT INTO qucNNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ri Espíritu rech ri Qajaw Dios k'o wuk'. In cha'tal k'ut rech keintzijoj utzalaj taq tzij chke ri meb'a'ib'. In u taqom u loq che ki ku'b'isaxik kanima' ri keb'isonik, chutzijoxik ri ki tzoqopixik ri e tz'apim, chub'anik k'ut chi keka'y ri moyab', xuquje' che ki tzoqopixik ri man e tzoqopim taj, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Xuquje' in taqom loq chutzijoxik wa' chi ri Qajaw Dios xucha' we q'ij junab' ri' chub'anik utzil chke konojel winaq, —kächa ri qa mam Isaías, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ri Jesús xutz'apij ri wuj, xutzelej wa' che ri chajil re ri rachoch Dios, xt'uyi'k. Konojel ri winaq ri e k'o pa ri rachoch Dios naj ki wi' che. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Xub'ij k'u chke: Kämik ri' xb'antaj wa' we Tz'ib'talik ri' chuwäch alaq, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Konojel ri winaq utz kech'aw chrij ri Jesús, xuquje' xkikajmaj ri je'lalaj taq tzij ri xutzijoj chke, xkib'ij: ¿A mat are ru k'ojol ri tat José? —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Xub'ij chke: Wetam ri käb'ij na alaq chwe in: “Ajkun, kunaj ib' la,” —kächa na alaq chwe. “Ri qa tom chi xeb'an la pa ri tinimit Capernaum, cheb'ana k'u la waral pa ri tinimit la,” —kächa na alaq, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Xuquje' xub'ij chke: Qas tzij ri kinb'ij chech alaq chi sib'alaj nim kil wi ronojel q'alajisanel. Xaq xuwi pa ru tinimit ri are' man nim tä kil wi wa', —kächa ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tzij ri' ri kinb'ij chech alaq chi xek'oji k'ia ri chuchuib' malka'nib' pa ri tinimit Israel pa taq ru q'ij ri qa mam Elías, jun q'alajisal re ru Loq' Pixab' ri Dios ojer. Oxib' junab' ruk' waqib' ik' man k'o tä jäb' xub'ano. Xk'oji k'u jun nimalaj wi'jal pa ronojel ruwächulew pa taq ri q'ij ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Man xtaq tä k'u b'i ri tat Elías kuk' konojel ri malka'nib', xane xaq xuwi ruk' ri jun chichu' malka'n pa ri tinimit Sarepta re Sidón, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Xuquje' xek'oji k'ia yawab'ib' ri k'o ri itzel taq ch'a'k chkij pa ru q'ij ri Eliseo, jun q'alajisal re ru Loq' Pixab' ri Dios ojer. Man k'o tä k'u jun ri xkunaxik, xane xaq xuwi ri tat Naamán ri aj Siria, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Aretaq ri winaq xkita ri xub'ij chke, konojel ri e k'o pa ri rachoch Dios sib'alaj xpe koyowal che ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Xewalij k'ut, xkesaj b'i pa ri tinimit. Xkik'am b'i chutza'm ri juyub' ri yakom wi ri ki tinimit. Xkaj u k'iäqik b'i ri Jesús ikim. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Xq'atän k'u b'i ri Jesús pa ki nik'iajal ri winaq, xe'k. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Xqaj b'i ri Jesús, xe' pa Capernaum, jun tinimit re Galilea. Xeutijoj ri winaq chila' ronojel q'ij re uxlanem. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ri winaq xkikajmaj ru tijonik rumal chi xeutzijob'ej je' jas ri kub'an jun ri kätaqan pa ki wi'. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Xok k'u b'i pa ri rachoch Dios jun achi ri k'o jun itzelalaj espíritu che. Xuraq u chi' ri achi, ko xch'awik. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Xub'ij k'ut: ¡Aa! ¿Jas qe uj uk' la, Jesús aj Nazaret? ¿A petinaq la chusachik qa wäch? In wetam wäch la, chi lal ri' ri Loq'alaj Achi ri taqom loq rumal ri Dios, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ri Jesús xuyajo, xub'ij: ¡Chatz'apij u pa chi', chatel che ri achi! —xcha che. Te k'u ri' ri itzelalaj espíritu xuk'iäq ri achi cho ulew chkixol ri winaq, xel b'ik, man k'o tä k'äx xub'an kan che. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Konojel xekajmanik. Käkitzijob'ela kib', käkib'ij: ¿Jas wa' we tzij ri' ri kukoj ri tata'? ¡Käkowin ri Are' che ki taqik ri itzel taq espíritus, keb'el chke ri winaq! —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ketzijon k'u chrij ri Jesús pa ronojel k'olib'al chunaqaj ri tinimit ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Xel k'u loq ri Jesús pa ri rachoch Dios, xok b'ik pa ri rachoch ri tat Simón. Ru ji' chichu' ri tat Simón qajinaq che jun nimalaj q'aq', xeb'ochi'n k'u ri winaq che ri Jesús puwi' ri chichu'. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Xnaqajin che ri chichu', xtak'i k'u chuxkut. Xuyaj ri q'aq', xtäni k'u che. Chanim xwalij ri chichu', xeupatänij k'ut. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Aretaq qajem kub'an ri q'ij, konojel ri e k'o yawab'ib' kuk' xekik'am loq chuwäch ri Jesús. Pune k'ia u wäch ri yab'il ri e k'o chke ri winaq, xkowin ri Jesús che ki kunaxik. Xuya ru q'ab' pa ki wi' chkijujunal rech keutzirik. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","E k'ia k'ut ri xeb'el itzel taq espíritus chke. Xkiraq ki chi', xkib'ij: Lal ri' ri u K'ojol ri Dios, —xecha che. Keuyaj k'u ri Jesús, man kuya tä chke chi ketzijonik, rumal chi ketam u wäch chi are ri Cristo. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Aretaq xsaqirik, xel b'i ri Jesús pa ri tinimit, xe' pa juyub' jawije' ri xaq kätz'inowik. Ri winaq sib'alaj xkitzukuj, xkiriqo. Xkiq'atej k'ut rech man kel tä b'i chkixol. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ri Jesús xub'ij chke: Rajwaxik chi kine'k kintzijoj ri Utzalaj Tzij re ri Evangelio chrij ru taqanik ri Dios chke ri winaq pa taq ri nik'iaj tinimit chik, are k'u wa' ri in taqom wi loq, —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Xtzijon k'u ri Jesús pa taq ri rachoch Dios ri e k'o pa Galilea. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Aretaq ri Jesús k'o chuchi' ri nimalaj ja' re ri mar re Genesaret, xeopan k'ia winaq ruk' chutatab'exik ru Tzij ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ri Jesús xeril kieb' barcos ri e k'o chuchi' ri mar. E elinaq loq ri chapal taq kär pa ri barcos che ki ch'ajik ri ki k'at. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Xok k'u b'ik ri Jesús pa jun chke ri barcos, ri re ri tat Simón. Xt'uyi pa ri barco, xuta' toq'ob' che ri tat Simón chi kuqeb'isaj apan jub'iq' ri barco chuchi' ri ulew rech man käpitz' tä ri Are' kumal ri k'ia winaq. Chila' k'ut xuya loq tijonik chke ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Aretaq xutänab'a ri u tijonem, xub'ij che ri tat Simón: Chaqeb'isaj ri barco pa ri mar. Chiqasaj ri i k'at che ki chapik kär, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ri tat Simón xch'awik, xub'ij che: Qajtij, xujchakun ronojel ri jun aq'ab' mier. Man k'o tä k'u qa chapom, —kächa'. We k'u je' käb'ij la, kinb'an chi na wa', keinqasaj ri nu k'at, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Aretaq xb'antaj wa', xenoj k'u ri ki k'at chapäb'al kär, je ri' chi ket'oqopitaj chke taq ri kär. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ri tat Simón kuk' ri to'l taq re xekisik'ij ri kachi'l ri e k'o pa ri jun barco chik, rech keopan che ki to'ik. Xeb'e' kuk' che ki to'ik, xekinojisaj k'u ri kieb' barcos, je ri' chi tajin kesach pa ri ja'. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Aretaq ri tat Simón Pedro xril ri xb'anik, xub'ij: Qajaw Jesús, man taqal tä chwe chi käk'oji la wuk' rumal chi ri in, sib'alaj in ajmak, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Xub'ij wa' rumal chi xuxej rib' ri tat Simón xuquje' ri e k'o ruk' rumal ri k'ialaj kär ri xekichapo. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Xuquje' xekajman ri tat Jacobo, ri tat Juan, u k'ojol ri tat Zebedeo, kachi'l kib' ruk' ri tat Simón. Xub'ij ri Jesús che ri tat Simón: Maxej awib'. Jas ri kab'an chke taq ri kär, keamulij, je' kab'an na chke ri winaq, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Xekesaj k'u loq ri ki barcos pa ri mar, xkiya cho ri ulew. Te ri' xkiya kan ronojel, xeb'e' ruk' ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Aretaq ri Jesús k'o pa jun tinimit chik, xopan jun achi ruk', ri sib'alaj yawab', ri k'o itzel ch'a'k che. Ri achi, aretaq xril ri Jesús, xupachb'a rib' chuwäch. Xuchap u b'ochi'xik, xub'ij: Tat, we kaj la käkowin la che nu kunaxik, —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ri Jesús xuyuq ru q'ab', xuchap koq. Xub'ij che: Kwaj, —kächa'. Chutzir b'a' la, —xcha che. Chanim k'ut xel ri itzel ch'a'k che ri achi, xutzirik. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Xutaq k'u ri Jesús chi mutzijoj wa' che apachin jun winaq. Te ri' xub'ij che: ¡Oj la! Jek'utu ib' la cho ri sacerdote. Ya b'a' la ri taqom kan rumal ri qa mam Moisés chi käyi' che u kunaxik jun ri k'o itzel ch'a'k che. Are k'u q'alajisab'al wa' chkiwäch ri winaq, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Xesax k'u na u tzijoxik wa' pa ronojel tinimit. Käkimulij k'u kib' k'ialaj taq winaq chutatab'exik ru tijonik ri Jesús, xuquje' rech keukunaj chke taq ri ki yab'il. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Xel b'i ri Jesús chila', xe' pa taq juyub' ri ketz'inowik chub'anik orar. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Pa jun q'ij ri Jesús tajin kuya tijonik. E t'uyut'oj k'u ri tata'ib' fariseos xuquje' ri tijonelab' re ri Pixab' chunaqaj ri Jesús. E elinaq k'u loq ri e are' pa ronojel tinimit re Galilea, re Judea, xuquje' e k'o jujun ri xepe pa Jerusalén. Are k'u ri Jesús, sib'alaj k'o ru chuq'ab' ri Dios ruk' che kunanik. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Xeopan k'u jujun achijab' kuk'am loq jun achi ri käminaq u cuerpo. Q'oyol cho jun alaj u ch'at. Ri achijab' xkitzukuj ri rokisaxik b'i ri yawab' pa ri ja chuya'ik cho ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Man xkiriq tä k'ut jawije' keb'ok wi b'ik kumal ri k'ialaj winaq. Xepaqi k'u puwi' ri ja. Xkesaj apan jub'iq' ru xo'til ri ja, xkib'an jun jul puwi' ri ja, xkiqasaj k'u b'i ri achi pa ri alaj ch'at chkixol ri winaq cho ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Aretaq ri Jesús xrilo chi qas kekojon che, xub'ij che ri achi ri käminaq u cuerpo: Tat, kesachtaj ri mak la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Te k'u ri' xpe koyowal ri fariseos xuquje' ri tijonelab' re ri Pixab'. Käkichomaj pa kanima', käkib'ij: “¿Jachin lo wa' we achi ri' ri kub'ij ri äwas u b'ixik chrij ri Dios?” —kecha'. “Xaq xuwi ri Dios käkowin chusachik u mak jun,” —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ri Jesús chanim xuna' ri tajin käkichomaj pa kanima'. Xch'aw k'ut, xub'ij chke: Ri in wetam ri tajin kächomaj alaq pa anima' alaq, —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Jachike ri man k'äx tä u b'ixik che ri yawab': “Ra mak xesachtajik”, o ri u b'ixik: “Chatwalijoq, chatb'inoq”? —kächa ri Jesús chke. (K'äx na u b'anik ri jun xuquje' ri jun chik.) ");
INSERT INTO qucNNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Rech b'a' ketamaj alaq chi ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, k'o nu taqanik pa ki wi' ri winaq cho ruwächulew chusachik ki mak, kinb'an na wa', —xcha chke. Xub'ij che ri achi ri käminaq u cuerpo: Kinb'ij che la, walij b'a' la. K'ama la b'i ri sok la, oj la cho ja, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Chanim xwalij ri achi, xtak'i chkiwäch ri winaq. Xutelej b'i ri u sok ri q'oyol wi, xe' cho rachoch, tajin kunimarisaj u q'ij ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Konojel ri winaq sib'alaj xkikajmaj ri xub'ano, xkinimarisaj k'u u q'ij ri Dios. Sib'alaj käkixej kib' ri winaq, käkitzijob'ela kib', käkib'ij: Kämik ri' e k'o kajmab'al ri qilom, —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Te k'u ri' xel b'i ri Jesús chila', xril jun toq'il alkab'al, Leví u b'i', t'uyul jawije' kätoj wi alkab'al. Xub'ij k'u che: Sa'j la wuk', —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ri tat Leví xwalijik, xuya kan ronojel, xe' ruk' ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ri tat Leví xub'an k'u jun nimalaj ula'nem che ri Jesús cho rachoch. Xeopan k'ia chke ri toq'il taq alkab'al, xuquje' nik'iaj taq winaq chik. Xet'uyi k'u junam chi' ri mesa kuk' ru tijoxelab' ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Xepe ri tijonelab' re ri Pixab' kachi'l ri fariseos. Xekiyaj ri tijoxelab', xkib'ij chke: ¿Jas che kixwi' kuk' toq'il taq alkab'al xuquje' kuk' ajmakib'? —xecha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ri Jesús xch'awik, xub'ij chke: Ri winaq ri utz ki wäch ri k'o ki chuq'ab' man rajwaxik tä kunal ke. Xane are rajwaxik wa' chke ri yawab'ib', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Man in petinaq tä che ki sik'ixik ri utzalaj taq winaq rech käkik'ex kanima', käkik'ex k'u ki chomanik, xane che ki sik'ixik ajmakib', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Xkib'ij k'u che ri Jesús: Ru tijoxelab' ri tat Juan amaq'el käka'n ri ayuno, amaq'el k'ut käka'n orar. Je' k'u käka'n ri ki tijoxelab' ri fariseos xuquje'. ¿Jas k'u che ri tijoxelab' la amaq'el kewi'k, man käka'n tä k'u ri ayuno? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Xub'ij k'u ri Jesús chke: ¿A kuya' lo ri e k'o pa jun k'ulanem käka'n ayunar aretaq k'o ri jia'xel kuk'? —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kopan k'u na ri q'ij ri man k'o tä chi ri jia'xel chkixol. Te k'u ri' käka'n na ayunar pa ri q'ij ri', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Xuquje' xukoj jun k'utb'al chkiwäch, xub'ij chke: Man k'o tä jun winaq ri kut'is jun k'ak' k'ojb'al chrij ri q'el atz'iaq. We je ri', ri k'ak' kuteq'tob'isaj na ri' ri q'el, xuquje' ri k'ojb'al ri esam che ri k'ak' atz'iaq man kuk'ulajij tä rib' ruk' ri q'el, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Man k'o tä k'u jun winaq ri kuya k'ak' vino pa taq q'el taq q'eb'al re tz'um. We je ri', ri k'ak' vino keut'ub'ij ri' ri tz'um, kätix k'u na ri' ri vino, keetzeletaj kan ri' ri tz'um. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Are ri k'ak' vino käyi' na pa k'ak' taq q'eb'al re tz'um. Je ri' man käsach tä u wäch ri vino, o ri k'olib'al re. ");
INSERT INTO qucNNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Man k'o tä jun winaq ri kraj kutij re ri k'ak' vino we nab'e u tijom re ri q'el vino. Kub'ij na ri' ri winaq chi are utz na ri q'el vino, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Pa jun q'ij re uxlanem ok'owem re ri Jesús pa taq ri tiko'n. Ru tijoxelab' tajin kekich'up ru jolom triko, kekiq'ich pa ki q'ab', kekitijo. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Jujun tata'ib' fariseos xkib'ij: ¿Jas che käb'an alaq ri äwas u b'anik pa ri q'ij re uxlanem? —xecha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ri Jesús xch'awik, xub'ij chke ri fariseos: ¿A mat ne sik'im alaq jas ri xub'an ri qa mam David aretaq xnumik, xuquje' ri xka'n ri e k'o ruk'? —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Xok k'u b'i ri qa mam David pa ri rachoch Dios, xuchap ri wa ri e yo'm cho ri Dios, xutijo, xuya ke ri e k'o ruk' xuquje'. Äwas k'u ne u tijik wa' kumal xaq jachinoq. Xane xaq xuwi chke ri sacerdotes ya'tal wi wa', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Xuquje' xub'ij chke: Ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, k'o nu taqanik puwi' ri q'ij re uxlanem xuquje', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pa jun q'ij re uxlanem chik xok b'i ri Jesús pa ri rachoch Dios, xuchap k'u u ya'ik tijonik chke ri winaq. K'o jun achi chila' ri käminaq jun u q'ab', ri u wikiäq'ab'. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kaluchi'x k'u ri Jesús kumal ri tijonelab' re ri Pixab', xuquje' kumal ri tata'ib' fariseos, che rilik we ri Are' kärutzirisaj ru q'ab' ri achi pa ri q'ij re uxlanem rech kuya' käkib'ij chi k'o u mak. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ri Jesús xretamaxtaj ri ki chomanik. Xub'ij k'u che ri achi ri käminaq u q'ab': Walij b'a' la, tak'al la pa qa nik'iajal, —xcha che. Xwalij k'ut, xtak'i chila'. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Xub'ij ri Jesús chke ri nik'iaj winaq ri e k'olik: K'o ri kwaj kinta' chech alaq, —kächa chke. ¿Jachike ri ya'tal u b'anik pa ri q'ij re uxlanem? ¿A are ri u b'anik utzil? ¡We ne are ri u b'anik etzelal! ¿A ya'tal ri u to'ik ru k'aslemal jun o ri u kämisaxik? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ri Jesús ko xka'y chke konojel ri e k'o pa taq u xkut, xub'ij k'u che ri achi: Yuqu ri q'ab' la, —xcha che. Je' xub'ano, xutzir k'u kan ru q'ab'. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ri u k'ulel ri Jesús sib'alaj xejiq' che ri koyowal, xkich'ab'la k'u kib' jas ri kekowin chub'anik chrij ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Pa ri q'ij ri' xe' ri Jesús pa jun juyub' chub'anik orar. Xrok'owisaj ronojel jun aq'ab' pa oración cho ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Aretaq xsaqirik, xeusik'ij ru tijoxelab', xeucha' kab'lajuj, xub'ij apóstoles chke (ri kel kub'ij “nu taqo'n”). ");
INSERT INTO qucNNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","E are taq wa' ri xeucha' ri Jesús: Ri tat Simón ri xuquje' käb'ix Pedro che, ri tat Andrés u chaq' ri tat Pedro, ri tat Jacobo xuquje' ri tat Juan, ri tat Felipe xuquje' ri tat Bartolomé. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Xeucha' k'u ri tat Mateo xuquje' ri tat Tomás, ri tat Jacobo ru k'ojol ri tat Alfeo, xuquje' ri tat Simón ri käb'ix “u nimal tinimit” che. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Xuquje' xeucha' ri tat Judas ru chaq' ri tat Jacobo, xuquje' ri tat Judas Iscariote ri xjachow ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","E rachi'lam ru tijoxelab', ri Jesús xqaj loq pa ri juyub', xtak'i k'u pa jun lianik. Sib'alaj e k'ia ri winaq ri xeb'el loq pa konojel taq ri tinimit re Judea, pa ri tinimit Jerusalén, xuquje' pa taq ri taq'aj re Tiro xuquje' re ri Sidón. Xeopan k'u ruk' ri Jesús chutatab'exik ri kub'ij, xuquje' rech kekunax che taq ri ki yab'. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Xuquje' xerutzirisaj ri winaq ri käkiriq k'äx kumal ri itzel taq espíritus. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Konojel ri winaq käkitzukuj käkichap koq ri Jesús rumal rech chi kel chuq'ab' ruk' che ki kunaxik konojel. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Xka'y k'u ri Jesús chke ru tijoxelab', xub'ij chke: Utz iwe ix ri ix meb'a'ib' rumal chi ri Dios kätaqan pi wi'. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Utz iwe ix ri kixnum kämik rumal chi sib'alaj k'o ri kitij na. Utz iwe ix ri kixoq' kämik rumal chi kixtze'n na ruk' kikotemal. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Utz iwe ix aretaq ketzelax i wäch kumal ri winaq, xuquje' aretaq kixkesaj b'i kuk', kixkiyoq'o, xuquje' aretaq ketzijon chiwij je' ta ne chi ix lawalo taq winaq. Utz iwe aretaq ri winaq käka'n ronojel wa' chiwe xa rumal wech in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, —kächa ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Sib'alaj chixkikot pa ri q'ij ri', chixtze'noq, rumal chi nim ri tojb'al iwe ri kiriq na pa ri kaj. Xuquje' ne ri kati't ki mam we winaq ri' je' xka'n chke ri q'alajisal taq re ru Loq' Pixab' ri Dios ojer, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Toq'ob' k'u i wäch ix, ri ix q'inomab', rumal chi ya xixkikot ix waral. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Toq'ob' i wäch ix ri sib'alaj k'o kitij kämik rumal chi käpe ri q'ij ri sib'alaj kixnum na. Toq'ob' i wäch ix ri xa kixtze'n ruk' kikotemal kämik rumal chi kixb'ison na, kixoq'ik. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Toq'ob' i wäch ix aretaq konojel ri winaq sib'alaj utz ketzijon chiwij, rumal chi je' xka'n ri kati't ki mam we winaq ri' ojer chke ri xkijaluj kib' chi e q'alajisal taq re ru Loq' Pixab' ri Dios, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Kinb'ij k'u chiwe ix ri tajin kitatab'ej ri nu tzij: Cheiwaj ri käka'n ki k'ulel chiwe. Chib'ana utzil chke ri keetzelan i wäch. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Chib'ij: Ri Dios k'o pi wi', —kixchoq chke ri winaq ri käkitzaq itzel tzij pi wi'. Chib'ana orar pa ki wi' ri keyoq'on chiwe, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","We k'o jun katch'ayow che ri juperaj a palaj, chaya ri juperaj chik chuwäch. We k'o jun kumaj ra chaket, chaya che chi kuk'am b'ik xuquje' ra kamixa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Chaya che apachin ri k'o jas kuta' chawe. Mata' chi ri jastaq awe che ri jun ri xuk'am b'ik. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ri kiwaj chi käka'n na ri winaq chiwe, je' chib'ana ix chke xuquje', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","We xaq xuwi keiwaj ri winaq ri kixkaj ix, ¿jas ta k'u che kichomaj chi i b'anom jun nimalaj utzil? Xuquje' ne ri ajmakib' käkaj kib'. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","We xaq xuwi kib'an utzil chke ri winaq ri keb'anow utzil chiwe, ¿jas k'u che kichomaj chi k'o nimalaj utzil i b'anom? Are je' käka'n ri ajmakib' xuquje', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","We xaq xuwi kiya ki jalomal ri ku'l i k'ux chkij chi käkitzelej chi na wa', ¿jas ta che ri' kib'ij chi i b'anom utzil? Xuquje' ne ri ajmakib' käkiya ri ki jalomal ri kach taq ajmakib' ri ku'l ki k'ux chkij chi käkitzelej chi na wa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Cheiwaj ri käka'n ki k'ulel chiwe. Chib'ana utzil. Chiya jalomal, miku'b'a iwanima' chrij chi kätzelex chi na wa' jumul chik. Nim k'u ri tojb'al iwe, käq'alajin k'u na chi qas ix ralk'ual ri Dios aj Chikaj, rumal chi sib'alaj utz kub'an ri Dios chke ri man kemaltioxin taj, xuquje' chke ri lawalo taq winaq. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Chitoq'ob'isaj ki wäch ri winaq je' jas ri Dios ri i Tat u toq'ob'isam i wäch ix, —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Miq'at tzij pa ki wi' nik'iaj winaq chik, man käq'at tä k'u na tzij pi wi' ix rumal ri Dios. Mib'ij tzij chkij ri winaq, man käb'ix tä na tzij chiwij ix rumal ri Dios. Chisacha ri ki mak jule' chik, käsach k'u na i mak ix. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Chiya ix chke nik'iaj chik, ri Dios k'ut kuya na chiwe ruk' jun utzalaj pajanik, t'ikom, känoj ra k'olib'al, käjat'jatik, —kächa'. Rumal chi jas ri pajanik ri kiya ix, je' ri pajanik ri kuya na ri Dios chiwe, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ri Jesús xukoj chi na jun k'utb'al chik rech tijonik, xub'ij: ¿A käkowin lo jun winaq ri man käka'y taj chuk'amik u b'e jun winaq chik ri man käka'y taj? ¿A mat junam ri' ketzaq b'i pa jun jul? —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Man k'o tä jun tijoxel ri nim na u b'anik chuwäch ri rajtij. Pune ta ne aretaq kätijotaj ri tijoxel, junam k'u na ruk' ri rajtij, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Jas che k'o kab'ij chkij nik'iaj winaq chik? Je' ta ne chi kaka'yej jun alaj mes ri k'o pa ru waq'äch ri awachalal, man kawil tä k'u ri a mak at ri je' ta ne jun tem ri k'o pa ri a waq'äch. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Je' ta ne chi kab'ij che ri awachalal: “Chaya chwe chi kinwesaj koq ri alaj mes ri k'o pa ra waq'äch,” —katcha che. ¡Xaq kieb' a wäch! Man kawil tä k'u ri tem ri k'o pa ra waq'äch at. Nab'e rajwaxik kasuk'umaj ri a k'aslemal at je' ta ne chi kawesaj b'i jun tem pa ra waq'äch. Te k'u ri' qas utz katka'y na che resaxik koq ri alaj mes pa ru waq'äch ri awachalal ri je' ta ne xa jun mak ri man nim taj, —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Man k'o tä jun che' ri man utz taj ri kuya utz u wächinik. Man k'o tä k'u jun utzalaj che' ri kuya u wächinik ri man utz taj. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Are etamtal ri jun che' rumal ru wächinik. Man ketam tä higos chrij ri k'ix, man ketam tä k'u uvas chkij ri juwi' k'ix, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Jun utzalaj winaq are kutzijoj ri utzil ri k'o pa ranima'. Jun winaq ri man utz taj are kutzijoj ri' ri lawaloyil ri k'o pa ranima'. Xaq xuwi kutzijoj jun winaq jas ri k'o pa ranima', —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jas che kib'ij chwe: “Qajaw, Qajaw,” —kixcha chwe. Man kinimaj tä k'u ri kinb'ij, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kink'ut na chiwäch jachin ruk' kinjunamaj wi ronojel winaq ri käpe wuk' in, ri kutatab'ej ri kinb'ij xuquje' känimanik, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Junam wa' we winaq ri' ruk' jun winaq ri kuyak rachoch. Kuk'ot ri ulew, naj kuqasaj. Kub'an ri tak'alib'al re ri ja puwi' ri ab'aj. Aretaq käpe jun nimalaj u wo ja', ri ja' kupuk'ij rib' chrij ri ja ri', man käkowin tä k'u chuyiko'misaxik rumal chi yakom wa' puwi' ri ab'aj, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ri winaq k'ut ri ketatab'en ri nu tzij, man keniman tä k'u ri', e are' junam ruk' ri winaq ri kuyak ri rachoch puwi' ri ulew, man kub'an tä k'u ru tak'alib'al ri ja. Aretaq käk'iy ri ja', kupuk'ij rib' chrij ri ja, chanim kätzaqik, käyojyob' k'u ri ja, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Aretaq xto'taj ri Jesús che ki tzijob'exik ri winaq, xe' ri Are' pa ri tinimit Capernaum. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Chila' k'ut k'o jun achi ki nimal soldados. K'o jun patänil re ri tata' ri sib'alaj loq' chuwäch. Ri achi patäninel are sib'alaj yawab', kämik kub'ano. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Aretaq ri tata' xuta u tzijol ri Jesús, xeutaq b'i jujun chke ri nimaq taq tata'ib' ke ri winaq aj Israel ruk' ri Are' rech käkib'ochi'j chi kopan ruk' chukunaxik ri patänil re. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Xeb'e'k, xeopan k'u ruk' ri Jesús, sib'alaj xeb'ochi'n che, xkib'ij: Taqal che ri tata' ri' chi käto' la che, ");
INSERT INTO qucNNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","rumal chi are jun winaq ri sib'alaj loq' keril ri qa winaqil uj, xub'an k'u qe ri rachoch Dios ri käqamulij wi qib', —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Xe' ri Jesús, xerachi'laj b'ik. Naqaj chi k'ut k'o wi che ri rachoch ri ki nimal soldados, aretaq ri are' xeutaq b'i jujun taq rachi'l chub'ixik che ri Jesús: Tat, mäkos ib' la. Man taqal tä chwe chi kok la loq pa ri wachoch. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Rumal ri' xinchomaj in chi man taqal tä chwe chi kinopan in uk' la. Xane xaq xuwi we käb'ij la loq ri tzij, käkunataj na ri patänil we, —kächa ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Rumal rech chi ri in, in winaq ri k'o jun pa nu wi', ri in k'ut xuquje' kintaqan in pa ki wi' ri nu soldados. Kinb'ij che jun: ¡Jat! —kincha che. Ke' k'ut. Kinb'ij che ri jun chik: ¡Sa'j! —kincha che. Ri are' käpetik. Kinb'ij che ri patänil we: ¡Chab'ana wa'! —kincha che. Kub'an k'ut, —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Aretaq xuta wa' ri Jesús, sib'alaj xukajmaj. Xutzolq'omij rib', xub'ij chke ri winaq ri e teretoj chrij: Tzij b'a' chi chkixol ri winaq aj Israel man k'o tä jumul nu riqom in jun achi junam ruk' ri tata' ri' ri sib'alaj käkojonik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Aretaq xetzelej b'ik ri u taqo'n ri tata' cho ja, xkiriq chi ri patänil re ri tata' ya utz chik ri are'. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Te k'u ri' xe' ri Jesús pa jun tinimit chik, Naín u b'i', xuquje' e b'enaq ruk' k'ia chke ru tijoxelab' kuk' nik'iaj winaq chik. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Naqaj chik k'o wi ri Jesús che ri tinimit, te' xrilo chi k'o jun käminaq telem loq rech käk'am b'i pa muqik. Ri käminaq ri' are xa jun chi ala, ral jun malka'n chichu'. E k'o k'ia winaq re ri tinimit e teren chrij. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Aretaq ri Jesús xril ri malka'n, xel ranima' che, xub'ij: Man koq' tä chi la, nan, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Xqeb' ri Jesús ruk' ri käminaq, xuchap koq ri u käxon. Xetak'i k'ut ri e teleninaq. Xub'ij k'u ri Jesús: Ala, —xcha che. Kinb'ij chawe, ¡chatwalijoq! —xcha che ri käminaq. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Xwalij k'u ri ala ri xkäm na, xuchaplej ch'awem. Ri Jesús xujach kan che ru nan. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Sib'alaj xkixej kib' konojel ri winaq, käkinimarisaj k'u u q'ij ri Dios. Käkib'ij xuquje': K'o jun q'alajisal re ru Loq' Pixab' ri Dios ri sib'alaj nim u b'anik chqaxol. Xuquje' xkib'ij: Petinaq ri Dios chub'anik utzil che ru tinimit, —xecha ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ri xub'an ri Jesús kätzijox wa' kumal konojel ri winaq aj Judea xuquje' pa ronojel ri tinimit ri e k'o naqaj che ri Judea. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ru tijoxelab' ri tat Juan xkiya u tzijoxik ronojel wa' che. Are k'u ri tat Juan xeuch'ab'ej kieb' chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Xeutaq b'i ruk' ri Jesús rech käkita' che ri Are' we qas tzij Are ri Cristo ri käpe na, o we are rajwaxik chi käkeyej na Jun chik. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Xeopan k'u ri achijab' ruk' ri Jesús, xkib'ij che: Ri tat Juan Qasal Ja' uj u taqom loq uk' la, chuta'ik che la we lal ri' ri Cristo ri käpe na, o we rajwaxik käqeyej na Jun chik, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Che we chanim ri', aretaq xeopanik, ri Jesús xerutzirisaj k'ia winaq che ri ki yab', xuquje' xeresaj b'i ri itzel taq espíritus ri e k'o chke jujun winaq. Xub'an k'ut chi xeka'y k'ia moyab'. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Te ri' xch'aw ri Jesús, xub'ij chke ru tijoxelab' ri tat Juan: Jitzijoj che ri tat Juan ri iwilom, ri i tatab'em, chi ri moyab' keka'y chik, ri ch'okojib' keb'inik, ri winaq ri k'o itzel ch'a'k chke keutzirisaxik, ri so'rab' käkita chik, ri käminaqib' kek'astajisaxik, xuquje' kätzijox ri Utzalaj Tzij re ri Evangelio chke ri meb'a'ib'. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Utz re ri winaq ri man kub'an tä kieb' u k'ux chwij, xane qas tzij käkojon chwe, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Aretaq xeb'e' ru taqo'n ri tat Juan, ri Jesús xuchaplej u tzijoxik ri tat Juan chke ri winaq, xub'ij: ¿Jas ri' ri xe' alaq che rilik pa taq ri juyub' ri ketz'inowik? —kächa'. ¿A xe' alaq che rilik jun winaq ri xa käkieblan ranima' je' ta ne chi are jun aj ri käslab'isax rumal ri kiäqiq'? —kächa'. Man are taj, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Jas k'u ri xe' alaq che rilik? ¿A xe' alaq che rilik jun achi ri u kojom utzalaj taq ratz'iaq? Ri winaq ri k'o je'lalaj taq katz'iaq, ri kekikot ruk' ri ki q'inomal, keriqtaj wa' pa taq kachoch ri nimaq taq taqanelab', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Jas k'u lo ri xe' alaq che rilik? ¿A xe' alaq che rilik jun q'alajisal re ru Loq' Pixab' ri Dios? —kächa'. Je ri', —kächa'. Ri tat Juan k'ut, are nim na u b'anik chkixol ri q'alajisal re ru Loq' Pixab' ri Dios, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Are wa' ri achi ri tz'ib'am chrij pa ru Loq' Pixab' ri Dios, kub'ij: Kintaq b'ik ri nu taqo'n ri känab'ej k'u na chawäch, ri kusuk'umaj na ra b'e chawäch, —kächa ri Tz'ib'talik, —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kinb'ij chiwe chi man k'olinaq tä jun q'alajisal re ru Loq' Pixab' ri Dios ri qas nim na u b'anik cho ri tat Juan ri Qasal Ja' chkixol konojel ri winaq cho ruwächulew, —kächa'. Pune ta ne ri tat Juan are jun ki nimal winaq, ri man qas nim u b'anik jawije' kätaqan wi ri Dios, are nim na u b'anik wa' cho ri tat Juan. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Aretaq xkita wa' ri toq'il taq alkab'al xuquje' ri nik'iaj winaq chik ri b'anom ki qasna' rumal ri tat Juan, xkib'ij chi ri Dios qas tzij kub'an jikomal tzij. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Are k'u ri tata'ib' fariseos xuquje' ri tijonelab' re ri Pixab' ri man b'anom tä ki qasna' rumal ri tat Juan, man nim tä xkil wi ri u Tzij ri Dios ri tzijom chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Xub'ij k'u ri Qajaw Jesús: ¿Jas k'u ruk' keinjunamaj wi ri winaq re we q'ij junab' ri'? ¿Jas k'u ruk' e junam wi? —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Xaq e junam kuk' ri alab'om ri e tak'atoj pa taq ri k'ayib'al, ri käkich'ab'ela kib', käkib'ij: “Xqoq'esaj ri su' chiwe, man xixxojow taj. Xqab'an u q'ojom käminaq, man xixoq' tä k'ut,” —kecha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Xul k'u ri tat Juan ri Qasal Ja' ri man wi'j taj, ri man kutij tä vino. Kixtzijon k'u chrij, kib'ij: Xa k'o jun itzelalaj espíritu che, —kixcha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Xinpe k'u ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq. Kinwi'k, kintij vino. Kixtzijon k'u chwij, kib'ij: Chiwilampe', are jun jiq'alaj achi, jun q'ab'arel ri kachi'l toq'il taq alkab'al xuquje' ajmakib', —kixcha chwe. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ri winaq k'ut ri käka'n ronojel ruk' no'j, käkik'ut chqawäch chi qas utz ri' ri no'j ri kuya ri Dios, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Jun chke ri tata'ib' fariseos xuta' toq'ob' che ri Jesús chi käwi' ruk'. Xok k'u b'i pa rachoch ri fariseo, xt'uyi chi' ri mesa. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Jun ixoq re b'e, ri kel pa ri tinimit, xuto chi tajin käwi' ri Jesús pa ri rachoch ri fariseo. Xe'k, xuk'am b'i jun k'olib'al kunab'al re alabastro nojinaq che k'ok'alaj kunab'al. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Xk'oji k'u pa raqan ri Jesús, tajin koq'ik. Xuchaplej ki ja'xik ri raqan ruk' ri u wal u wäch, keusu' k'u che ru wi'. Xeutz'umaj ri raqan, xutix ri k'ok'alaj kunab'al chkij. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Aretaq ri tata' fariseo ri xula'n ri Jesús xril ri xub'an ri ixoq, xchoman pa ranima', xub'ij: “We ta are q'alajisal re ru Loq' Pixab' ri Dios we achi ri', kuch'ob' ta ri Are' jachin ri ixoq ri'. Xuquje' kuch'ob' ta na jas u b'anik ri ixoq ri kächapow koq, chi are jun ixoq re b'e wa',” —xcha ri fariseo pa ranima'. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Xch'aw ri Jesús, xub'ij che ri fariseo: Tat Simón, k'o ri kwaj kinb'ij na che la, —xcha'. Xch'aw ri tat Simón, xub'ij che: Ajtij, b'ij b'a' la chwe, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Kub'ij k'u ri Jesús: E k'o kieb' winaq k'o ki k'as ruk' jun ya'l jalomal. Jun chke k'o jun ciento quetzales u k'as ruk' ri tata'. Ri jun chik xa lajuj quetzales u k'as, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Rumal k'u rech chi man k'o tä ki rajil chutojik ri ki k'as, ri ya'l jalomal xub'ij chke chi utz la' we man käkitoj tä chik, —kächa ri' chke. ¿Jachin k'u chke ri ajk'asib' ri qas loq' xril wi ri ya'l jalomal? —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Xch'aw k'u ri tat Simón, xub'ij: Kinchomaj in chi are ri jun ri nim na u k'as, ri man xutoj tä chik, —xcha'. Xub'ij ri Jesús che: Utz u ch'ob'ik xb'an la, —kächa che. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ri in xinok loq pa ri achoch la. Man xya tä la joron chwe che ki ch'ajik ri waqan. Ri ixoq ri' u ja'm ri waqan che ri u wal u wäch, xeusu' k'u che ru wi', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Man xintz'umaj tä la. Are k'u ri ixoq aretaq xinok loq, xuchap u b'anik wa' chwe, man u tänab'am tä ki tz'umaxik ri waqan. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Man xya tä la aceite pa nu wi'. Ri are k'ut u yo'm k'ok'alaj kunab'al chkij ri waqan. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kinb'ij che la chi kesachtaj na ri k'ialaj taq u mak rumal chi sib'alaj loq' kinrilo. Apachin k'ut ri kuna' pa ranima' chi man nim tä más ru mak ri kesachik, man loq' tä más ri Dios chuwäch, —xcha ri Jesús che. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Xub'ij k'u che ri ixoq: Kesachtaj b'a' ra mak, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ri e k'o ruk' ri Jesús chi' ri mesa käkitzijob'ela kib', käkib'ij: ¿Jachin lo wa' we achi ri' ri käsachow mak? —xecha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Xub'ij k'u ri Jesús che ri ixoq: Nan, a riqom ru tob'anik ri Dios rumal chi qas tzij katkojonik. Kuya' kate'k, chuxlan b'a' ri awanima', —xcha ri Jesús che. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Te k'u ri' ri Jesús xusolij konojel ri tinimit xuquje' konojel ri nik'iaj k'olib'al ri e k'o wi winaq, xutzijoj ru Loq' Pixab' ri Dios chke. Kuya retamaxik ri Utzalaj Tzij re ri Evangelio chrij ru taqanik ri Dios pa ki wi' winaq. E k'o k'u ri kab'lajuj u taqo'n ruk'. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","E b'enaq ruk' xuquje' jujun ixoqib' ri e utzirisam chke itzelalaj taq espíritus xuquje' chke taq ri ki yab'. E are k'u wa': Ri nan María ri käb'ix Magdalena che. Esam k'u b'ik wuqub' itzelalaj taq espíritus che. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","K'o ri nan Juana, rixoqil ri tat Chuza, ru mayordomo ri tat Herodes. K'o k'u ri nan Susana, xuquje' k'ia ixoqib' chik ri xkikoj ri jastaq ke chuto'ik ri Qajaw Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Xkimulij k'u kib' k'ia winaq. Xeopan winaq ruk' ri Jesús ri xepe pa ronojel tinimit. Ri Are' xukoj jun k'utb'al chuya'ik tijonik chke, xub'ij: ");
INSERT INTO qucNNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Jun tikol ija' xel b'i cho ja, xe' k'u pa tikonijik. Aretaq xjopinik, xqaj jub'iq' ri ija' pa ri b'e, xtak'alexik. Xuquje' xeqaj loq ri chikop ajuwokaj, xkitij b'i ri ija'. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Xqaj xuquje' jub'iq' ri ija' pa taq ab'aj. Xuchaplej k'iyem. Xchaqi'jar k'ut rumal chi man k'o tä u räxil ri ulew. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Xqaj chi jub'iq' pa taq ri q'ayes ri k'o ki k'ixol. Xk'iy ri ija' junam ruk' ri q'ayes. Xjiq'isax k'u ri tiko'n rumal. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Xqaj chi jub'iq' pa utzalaj ulew, xeb'el k'u loq, xek'iyik. Xkiya jun ciento ki wäch chkijujunal chupam ru jolom triko, —xcha chke. Aretaq ri Jesús xto'taj chutzijoxik wa', ko xch'awik, xub'ij: ¡Ri ix ri i jikib'am ri iwanima' chutatab'exik ri nu tzij, chitatab'ej b'a'! —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ru tijoxelab' xkita' che ri Jesús, xkib'ij: ¿Jas kel kub'ij wa' we k'utb'al ri'? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Xch'aw chi ri Jesús, xub'ij chke: Yo'm chiwe ix ri retamaxik ri man ketam tä ri nik'iaj winaq chik chrij ri u taqanik ri Dios. Keinkoj k'u k'utb'al che ki tijoxik ri nik'iaj winaq chik rech pune keka'yik, je' ta ne chi man k'o tä käkilo, pune käkitatab'ej ri tzij, man käkich'ob' tä ri' ri ki tatab'em, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Are k'u wa' ri kel kub'ij ri xintzijoj chiwe: Ri ija' are ru Tzij ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ri ija' ri xeqaj pa ri b'e, e are junam jas ri winaq ri käkita ri Tzij. Kopan k'u ri Itzel, käresaj ri Tzij pa kanima' rech man kekojon taj, man käkiriq tä ru tob'anik ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ri ija' ri xqaj pa taq ab'aj, e are' junam jas ri winaq ri käkik'amowaj ri Tzij. Aretaq käkito, kekikotik. Man k'o tä k'u ri ki xera'. Xa kieb' oxib' q'ij käkikojo. Aretaq k'ut käkichap u riqik k'äx, ketzelej kanoq, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ri ija' ri xqaj pa taq ri q'ayes e are' junam jas ri winaq ri käkita ri Tzij. Te k'u ri' käkitaqej chi na jumul ri ki b'e. Sib'alaj ke' kanima' ruk' ri q'inomal ajuwächulew, ke' kanima' kuk' taq ri nimaq'ij, xuquje' ruk' ri ki chak. Käjiq'isax k'u ru Tzij ri Dios pa kanima', man käkiya tä k'u ri ki wächinik, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ri ija' k'ut ri xqaj pa utzalaj ulew, kinjunamaj kuk' ri winaq ri utz kanima', ri käka'n ronojel ruk' jikomal, käkijikib'a kanima' chrij ri Tzij ri xkitatab'ej. Käkitaqej k'ut, sib'alaj kewächinik, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Xub'ij chi na ri Jesús: Man k'o tä jun winaq ri kutzij jun chäj o jun candela, te ri' kuch'uq wa' che jun laq. Man kuya tä k'u wa' chuxe' jun ch'at. Xane kuya wa' chikaj rech kilitaj ru saqil kumal ri winaq ri keb'ok b'i pa ja, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ronojel ri k'u'talik käq'alajin na. Ronojel ri ch'uqtal u wi' kel na chi saq rech ketamaxik. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Qas chitatab'ej b'a' na ri kinb'ij, rumal chi apachin ri k'o k'o ruk' käyi' na nik'iaj che. Apachin k'u ri man k'o tä k'o ruk', kesax na jas ri kuchomaj chi k'olik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Xopan k'u ru nan ri Jesús, xuquje' taq ri u chaq', ri ranab'. Man kekowin tä k'ut keqeb' ruk' rumal kech ri k'ialaj winaq. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Xb'ix k'u wa' che ri Jesús: Ri nan la xuquje' ri achalal la e tak'atoj cho ja. Käch'ab'ex la kumal, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Xch'aw ri Jesús, xub'ij chke: Ri winaq ri käkitatab'ej ru Tzij ri Dios, käka'n k'u ri kub'ij, e are' nu nan wa', xuquje' e are' wa' ri qas wachalal, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Pa jun q'ij xok ri Jesús pa jun barco, e rachi'lam k'u ru tijoxelab'. Xub'ij ri Jesús chke: Chujq'ax jela' ch'äqäp che ri mar, —xcha chke. Xeb'e' k'ut. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","E b'enaq puwi' ri mar, xwar ri Jesús. Xpe k'u jun nimalaj kiäqiq' ri sib'alaj k'äx puwi' ri mar. Ri barco tajin känoj che ja', je ri' chi xaq kieb' kub'ij pa ki wi'. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Xeb'e' ri tijoxelab' ruk' ri Jesús, xkik'asuj. Xkib'ij che: ¡Qajtij, Qajtij, tajin kujkämik! —xecha che. Xk'astaj k'u ri Jesús, xuyaj ri kiäqiq' xuquje' ri nimaq taq uwoja'. Xtäni k'u ri kiäqiq', xlilob' u wi' ri ja'. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Xub'ij ri Jesús chke ru tijoxelab': ¿Jas che man kixkojon taj? —xcha chke. Xkixej kib', xkikajmaj ri xub'ano, käkib'ila k'u chb'il kib': ¿Jachin lo wa' ri k'o u taqanik puwi' ri kiäqiq' xuquje' ri ja' je ri' chi keniman che? —xecha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Xeopan k'u pa ri tinimit Gadara, ri k'o apan chuwäch ri Galilea chuchi' ri mar. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Aretaq ri Jesús xel loq pa ri barco, xriqtaj rumal jun achi re ri tinimit. Tzk'ia junab' chik e k'o itzelalaj taq espíritus che ri achi. Man kukoj tä chi ratz'iaq. Man käjeqi tä cho rachoch, xane chkixol ri muqub'al käk'oji wi we achi ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Aretaq xril apan ri Jesús, xuraq u chi', xutzaq rib' chuwäch. Ko xch'awik, xub'ij k'u che ri Jesús: ¿Jas kaj la chwe, tat Jesús? Lal ri' ri u K'ojol ri Nimalaj Dios aj Chikaj, —kächa che. ¡B'ana b'a' la toq'ob', mäb'an la k'äx chwe! —xcha che ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Xub'ij wa' rumal chi ri Jesús tajin kätaqan che ri itzelalaj espíritu chi kel b'i che ri achi. Tzk'ia junab' k'o u taqanik ri itzelalaj espíritu puwi' ri achi. Pune kächajixik, käxim k'u kuk' ximib'al re ch'ich', xuquje' chapb'al aqanaj, ri achi xa keut'oqopij wa', kel b'ik. Ri itzelalaj espíritu käresaj b'i ri achi, kuk'am b'i pa taq juyub' ri ketz'inowik. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Xuta' ri Jesús che, xub'ij: ¿Jas ri a b'i'? —xcha che. Xub'ij che ri Jesús: Ri nu b'i' are K'iyal, —xcha'. Xub'ij wa' rumal chi sib'alaj e k'ia ri itzelalaj taq espíritus ri e okinaq che ri achi. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ri itzelalaj taq espíritus xkib'ochi'j ri Jesús chi meutaq b'i pa ri q'equmalaj jul. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","E k'ia k'u ri aq ri tajin keyuq'ux apan pa ri juyub'. Xkib'ochi'j chi chuya chke chi keb'ok chke ri aq. Je'ey, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Xeb'el k'u b'i ri itzelalaj taq espíritus che ri achi, xeb'ok chke taq ri aq. Konojel ri aq junam xkik'iäq b'i kib' chutza'm ri juyub', xetzaq b'i pa ri mar, xejiq'ik. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Aretaq ri ajyuq'ab' xkil ri xb'antajik, xeanimajik, xeb'e'k. Xkiya u tzijol wa' chke ri winaq pa ri tinimit, xuquje' pa taq ri juyub'. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Xeb'el loq ri winaq che rilik ri xb'antajik. Xeopan ruk' ri Jesús. Xkiriq k'u ri achi ri xeb'el wi ri itzelalaj taq espíritus, kojom chi ri ratz'iaq, man ch'uj tä chik. T'uyul k'u ri are' chuwäch ri Jesús. Xkixej k'u kib' ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ri winaq ri xeilow wa' ri xb'anik xkitzijoj wa' chke ri jule' winaq chik jas ri rutzirisaxik ri achi ri xek'oji na k'ia itzelalaj taq espíritus che. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Te k'u ri' konojel ri winaq ri e jeqel wi jela' chrij ri tinimit Gadara, xkib'ochi'j ri Jesús chi chel b'ik kuk' rumal chi sib'alaj xkixej kib'. Xok chi b'i ri Jesús pa ri barco, xtzelejik. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ri achi ri xeb'el wi ri itzelalaj taq espíritus sib'alaj xub'ochi'j ri Jesús chi kuya che chi ke' ruk'. Ri Jesús xutaq b'i cho rachoch, xub'ij che: ");
INSERT INTO qucNNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Chattzelej b'i cho awachoch, cheatzijoj konojel ri nimaq taq utzil ri u b'anom ri Dios chawe, —xcha che. Xe' k'u ri achi, xuchap ki tzijoxik chke konojel ri winaq re ri u tinimit ri nimaq taq utzil ri u b'anom ri Jesús che. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Aretaq xtzelej b'i ri Jesús, e k'o k'ia winaq ri xlek'ulanoq, xekikotik. Konojel keye'm ru tzelejik. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Xopan k'u jun achi ruk' ri Jesús, tat Jairo u b'i' ri achi ri'. Are ki nimal ri winaq wa' pa ri rachoch Dios. Xupach b'a' rib' cho ri Jesús, xub'ochi'j chi kopan cho rachoch. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Xa jun chi u mia'l ri achi ri', kraj kab'lajuj u junab'. Kämik k'u kub'ano. Xe' ri Jesús ruk'. B'enaq k'u pa ri b'e, sib'alaj käpitz' kumal ri k'ialaj winaq. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","K'o k'u jun ixoq ri u riqom k'äx kab'lajuj junab' rumal ru kik'el ri xa kelik, man kätäni tä che. U sachom k'u ronojel ru rajil kuk' kunanelab'. Man k'o tä jun ri kowininaq che rutzirisaxik. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Xqeb' k'u chrij ri Jesús, xuchap koq ru chi' ru q'u'. Chanim k'ut xtäni ru kik'el ri kelik. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Xub'ij k'u ri Jesús: ¿Jachin ri' ri xinchapowik? —xcha'. Konojel ri winaq xkib'ij chkijujunal: Man in tä ri', —xecha che. Xub'ij k'u ri tat Pedro xuquje' ri e k'o ruk': Qajtij, ¿a mat kil la chi e k'ia ri winaq ri e k'o chij la? Käpitz' b'a' la kumal konojel. ¿Jas che käb'ij la: “¿Jachin ri' ri xinchapowik?” —kächa la, —xcha ri tat Pedro che. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Xub'ij k'u ri Jesús che: K'o jun winaq ri xinchapowik. Xinna' chi xel jub'iq' ri nu chuq'ab' chukunaxik jun winaq, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Aretaq ri ixoq xrilo chi man xk'u'taj taj, xqeb' ruk' ri Jesús, käb'irb'itik. Xxuki chuwäch. Xuq'alajisaj chkiwäch konojel ri winaq jas che xuchap koq ri Jesús, xuquje' chi xkunatajik. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Xub'ij ri Jesús che: Nan, xkunataj la rumal chi käkojon la chwe, —kächa'. Kuya' ke' la, chuxlan b'a' anima' la, —xcha ri Jesús che. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","K'ä tajin kätzijon na ri Jesús, aretaq xopan jun ajuworachoch ri ki nimal ri winaq re ri rachoch Dios. Xub'ij che ri tat Jairo: Xkäm ri mia'l la, —kächa che. Xaq mäya chi la latz' che ri Ajtij, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Aretaq ri Jesús xuta ri xb'ixik, xch'awik, xub'ij che ri tat Jairo: Mäxej ib' la, —kächa'. Xane kojon la chwe. Kutzir k'u na ri ali, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Aretaq xopan cho rachoch ri tat Jairo, man xraj tä ri Jesús chi k'o jachin kok b'i ruk', xaq xuwi ri tat Pedro, ri tat Juan, ri tat Jacobo, xuquje' ru nan tat ri ali. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Konojel ri e k'o chila' tajin keb'oq'ik, käkik'is kib' che oq'ej. Xub'ij ri Jesús chke: Man koq' tä chi alaq. Man käminaq tä ri ali, xane xaq käwarik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ri winaq k'ut xa käketze'j u wäch ri Jesús rumal chi ketam chi käminaq chi ri ali. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ri Jesús xuchap ri ali che ru q'ab', ko xch'awik, xub'ij: Ali, chatwalijoq, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Xtzelej k'u loq ri ranima'. Chanim xwalijik. Xtaqan k'u ri Jesús chke chi chkiya che ri kutijo. ");
INSERT INTO qucNNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Xkikajmaj wa' ru tat u nan. Ri Jesús xeupixb'aj chi k'o mäkib'ij wi wa' ri xb'antajik. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ri Jesús xeusik'ij ri kab'lajuj u tijoxelab' ruk'. Xuya chke chi käk'oji ki taqanik pa ki wi' konojel ri itzelalaj taq espíritus rech kekesaj b'i chke ri winaq. Xuquje' xuya chke chi kekikunaj ri yawab'ib'. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Xeutaq b'ik chutzijoxik ru Loq' Pixab' ri Dios chrij ru taqanik ri Dios pa ki wi' ri winaq. Xeutaq b'i xuquje' che ki kunaxik ri yawab'ib'. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Xub'ij ri Jesús chke: K'o mik'am b'ik che ri b'e. Mik'am b'i i ch'imiy, i chim, i wa, o ri i rajil. Xa jun iwatz'iaq chijujunal kik'am b'ik, —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Apachike ja ri kixok wi, chixkanaj kan chila' k'ä kitaqej chi na b'i jumul ri i b'e. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","We k'o jun tinimit ri man kixk'ulax tä wi, chixel b'i chila', chitota' kan ri ulew ri k'o chke ri iwaqan chuq'alajisaxik chkij ri winaq re ri tinimit ri' chi man utz tä ri käka'no, k'o ki mak, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Xeb'e' k'ut, xeb'e' pa taq konojel ri alaj taq tinimit. Xkitzijoj ri Utzalaj Tzij re ri Evangelio, xuquje' xka'n kunanik pa taq konojel ri tinimit. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ri nim taqanel Herodes xretamaj ronojel ri tajin kub'an ri Jesús. Man kuriq taj jas kub'ano rumal chi e k'o jujun käkib'ij chrij ri Jesús: Xk'astaj loq ri tat Juan Qasal Ja' chkixol ri käminaqib', —kecha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Xuquje' e k'o jule' chik käkib'ij chrij ri Jesús: Ri Elías, q'alajisal re ru Loq' Pixab' ri Dios ojer u k'utum rib' chqawäch, —kecha'. Käkib'ij k'u jujun winaq chik: Jun chik chke ri ojer taq q'alajisal taq re ru Loq' Pixab' ri Dios xk'astaj loq chkixol ri käminaqib', —xecha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Xub'ij k'u ri tat Herodes: In xintaqan che resaxik u jolom ri tat Juan. ¿Jachin ta k'u lo ri' ri je' taq wa' nu tom chrij? —xcha'. Kutzukuj k'u rilik u wäch ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Aretaq xetzelej loq ri u taqo'n ri Jesús, xkib'ij che ri Are' ronojel ri ki b'anom. Ri Jesús xeuk'am b'ik, xeb'e' k'u ki tukiel wi pa jun tinimit, Betsaida u b'i'. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Aretaq xketamaj ri winaq chi xel b'i ri Jesús, xeteri b'i chrij. Xeuk'ulaj k'u ri Jesús, xeutzijob'ej chrij ru taqanik ri Dios pa ki wi' ri winaq, xuquje' xeukunaj ri yawab'ib'. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Qajem k'u kub'an ri q'ij, xeqeb' ri kab'lajuj u tijoxelab' ruk' ri Jesús, xkib'ij che: Chetaqa la b'i ri winaq rech keb'e' pa taq ri tinimit, xuquje' cho taq ri kachoch ri winaq ri e k'o chunaqaj ri tinimit, che roqxanexik kib' churiqik ri käkitijo. Uj k'o k'u waral pa taq juyub' ri kätz'inowik, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Xub'ij ri Jesús chke: Chiya ix ri käkitijo, —xcha chke. Xkib'ij k'u ru tijoxelab' che: Man k'o tä k'o quk' xane xa job' kaxlan wa kuk' kieb' kär. ¿A kuje' ta k'u lo chuloq'ik ri ki wa konojel we winaq ri'? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kraj k'u e k'o job' mil achijab'. Xub'ij ri Jesús chke ru tijoxelab': Chib'ij chke ri winaq chi keku'b'i pa taq mulaj re nik'iaj taq ciento, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Je' xka'no, xeku'b'i k'u konojel ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ri Jesús xeuk'am ri job' wa kuk' ri kieb' kär, xka'y k'u chikaj, xeutewchij. Te ri' xeupiro, xeuya chke ru tijoxelab' rech käkijach wa' chkiwäch ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Konojel xewi'k, xenojik. Xkimulij k'u ri ch'äqataq wa. Are kab'lajuj chikäch ri xek'oltajik. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Pa jun q'ij ri Jesús tajin kub'an orar. E k'o ru tijoxelab' ruk' pa ki tukiel wi. Ri Jesús xuchap u ta'ik chke, xub'ij: ¿Jas käkib'ij ri winaq chi jachin ri' ri in? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Xech'awik, xkib'ij che: E k'o jujun käkib'ij chi lal ri' ri tat Juan Qasal Ja'. Jule' chik käkib'ij chi lal ri' ri Elías, q'alajisal re ru Loq' Pixab' ri Dios ojer. E k'o chi nik'iaj käkib'ij chi lal jun chik chke ri ojer taq q'alajisal taq re ru Loq' Pixab' ri Dios ri xk'astaj loq chkixol ri käminaqib', —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Xub'ij k'u ri Jesús chke: ¿Jas k'u kib'ij ix chi jachin ri in? —xcha chke. Ri tat Pedro xch'awik, xub'ij: Lal ri' ri Cristo ri taqom la loq rumal ri Dios, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ri Jesús sib'alaj xeupixb'aj ru tijoxelab' chi k'o mäkib'ij wi wa' chi are ri Cristo. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Xub'ij chke: Rajwaxik chi ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, kinriq na sib'alaj k'äx, kinxutux na kumal ri nimaq taq tata'ib', kumal ri ki nimaqil sacerdotes aj Israel xuquje' kumal ri tijonelab' re ri Pixab', —kächa'. Xuquje' rajwaxik chi kinkämisax na. Te k'u ri' kink'astaj chi k'u na churox q'ij chkixol ri käminaqib', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Xub'ij k'u ri Jesús chke konojel: We k'o jun kraj käpe wuk' in, rajwaxik chi mub'an xa jas ru rayinik ri are'. Rajwaxik chi kutelej loq ru cruz ronojel q'ij, chpet wuk' in. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Apachin ta ne ri nim kril wi ru k'aslemal cho ru wächulew, käsach na u wäch wa'. Apachin ta ne ri kuya na ru k'aslemal rumal wech in, käk'oji na u k'aslemal ri man k'o tä u k'isik, —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Jas lo ri utzil kuriq jun winaq we kärechb'ej konojel ri jastaq ajuwächulew, kuya k'u ri ranima' che tojb'al ke, käsach k'u u wäch we winaq ri'? —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Apachike winaq ri xa käk'ix chwe in, xuquje' che ri nu tzij, in ri' ri Ralk'ual ri Dios ri Qas Winaq, kink'ix na xuquje' che ri winaq ri' aretaq kintzelej loq ruk' nimalaj chuq'ab' jas ru petik jun nim taqanel. Känimarisax na nu q'ij pa ri q'ij ri' junam jas ru nimarisaxik u q'ij ri nu Tat xuquje' ri loq'alaj taq ángeles, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Are qas tzij ri kinb'ij in chiwe chi e k'o jujun chke ri e k'o waral chnuwäch ri man kekäm tä na k'ä käkil na ru taqanik ri Dios pa ki wi' ri winaq, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kraj xke' wajxaqib' q'ij u b'im chi kan wa' ri Jesús, te k'u ri' xeuk'am b'i ri tat Pedro, ri tat Juan xuquje' ri tat Jacobo, xepaqi k'u puwi' ri juyub' chub'anik orar. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Aretaq tajin kub'an orar, xk'extaj ru ka'yeb'al ri Jesús. Sib'alaj xjuluw ri ratz'iaq, sib'alaj saqloloj xub'ano je' jas ri saq tew. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tzkajmab'al chik, e k'o k'u kieb' achijab' xetak'tob'ik, tajin ketzijon ruk' ri Jesús, e are ri mam Moisés rachi'l ri mam Elías. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Sib'alaj je'l ru juluwem ki wäch. Käkitzijob'ej k'u ri Jesús chrij ri relik b'ik cho ru wächulew, are la' ru kämikal ri kuriq na pa Jerusalén. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pune ri tat Pedro xuquje' ri e k'o ruk' sib'alaj k'äx ki waram, man xewar taj. Xkilo chi sib'alaj je'l ru juluwem ru wäch ri Jesús xuquje' ri ki wäch ri kieb' achijab' ri e k'o ruk'. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Elem käka'n b'i ri achijab', xub'ij ri tat Pedro che ri Jesús: Qajtij, ¡sib'alaj utz chi uj kujk'oji na waral! Qa'na oxib' käb'al, jun che la, jun che ri qa mam Moisés, xuquje' jun che ri qa mam Elías, —xcha che. Je' xub'ij wa' ri tat Pedro rumal chi man kuriq taj jas kub'ij. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Je' tajin kub'ij wa' aretaq xqaj jun sutz' chkij, xech'uqtaj k'ut. Xkixej kib' ri tijoxelab' aretaq ri sutz' xeuch'uqu. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Xch'aw k'u loq jun chupam ri sutz', xub'ij: ¡Are loq'alaj nu K'ojol wa'! Chitatab'ej ri kub'ij, —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Aretaq xtäni ri ch'awem, xkanaj kan ri Jesús u tukiel. Man xech'aw tä chi k'u ru tijoxelab'. Xuquje' pa taq ri q'ij ri' man xkitzijoj tä che jachin jun winaq ri xkilo. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Chukab' q'ij aretaq xeqaj loq puwi' ri juyub', e k'o k'ia winaq ri xeb'el loq churiqik ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","K'o k'u jun achi kuk' ri winaq, ko xch'awik, xub'ij: Qajtij, b'ana la toq'ob' chwe, —xcha'. Chilampe la ri nu k'ojol xa jun chi ala ri k'o wuk'. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Amaq'el kächap rumal jun itzelalaj espíritu. Kuraq u chi' ri ala. Ri itzelalaj espíritu kub'aq'atila', kupuluwisaj u pu chi', xuquje' kutota', —kächa'. Tzman kraj taj kel che ri ala, —xcha ri tata'. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Xeinb'ochi'j ri tijoxelab' la che resaxik ri itzelalaj espíritu, man xekowin tä k'u che, —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Xch'aw ri Jesús, xub'ij: ¡Ay, winaq! Man alaq nimanelab' taq winaq taj, tzman käkojon tä alaq, —xcha chke. ¿A are kaj alaq chi xaq kink'oji in uk' alaq ronojel q'ij che to'ik alaq? Xke' k'ia ri q'ij nu kuyum ri mak alaq, —xcha chke. Xub'ij k'u che ri achi: K'ama la loq ri k'ojol la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Aretaq tajin käqeb' ri ala ruk' ri Jesús, ri itzelalaj espíritu xuk'iäq pulew, xub'aq'atila'. Ri Jesús xuyaj ri itzelalaj espíritu, xrutzirisaj ri ala. Xujach b'ik che ru tat. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Konojel ri winaq xkikajmaj ri nimalaj u chuq'ab' ri Dios. Ri winaq sib'alaj tajin käkikajmaj ri xub'ano, xch'aw chi ri Jesús, xub'ij chke ru tijoxelab': ");
INSERT INTO qucNNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Chikojo retal wa' ri kinb'ij chiwe, —kächa chke. ¡Ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, kinjach na b'i pa ki q'ab' ri winaq! —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Man xkich'ob' tä k'u ru tijoxelab' jas ri xub'ij chke. Man xyi' tä chke chi käkich'ob' we tzij ri'. Xkixej k'u kib' chuta'ik che jas kel kub'ij wa' ri xub'ij chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Te k'u ri' ri tijoxelab' xkichap u chomalaxik kib' chrij jachin chke are ri nim na u b'anik chkixol. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Aretaq ri Jesús xretamaj ri xkichomaj pa kanima', xuk'am apan jun ak'al, xutak'ab'a ruk'. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Xub'ij k'u ri Jesús chke: Apachin jun winaq ri qas käk'amow we ak'al ri' rumal wech in, in ri' kinuk'amo xuquje'. Apachin k'u ri kink'amow in, kuk'am ri' xuquje' ri xintaqow loq. Apachin k'u chiwe ri man nim tä u b'anik, tzare wa' ri nim na kinwil in, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Xub'ij k'u ri tat Juan che ri Jesús: Qajtij, qilom jun ri keresaj itzelalaj taq espíritus pa ri b'i' la. Xqaq'il k'u kanoq rumal chi man are tä jun quk', —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Xub'ij ri Jesús che: ¡Miq'ila chik! —xcha'. Apachin jun winaq ri man kub'an tä u k'ulel chqe, kujuto' na ri', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Xqetet k'u loq ri q'ij re ru k'amik b'i ri Jesús chikaj, xujikib'a k'u ri ranima' che ru b'inem pa ri tinimit Jerusalén. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ri Jesús xeutaq b'i u taqo'n rech kenab'ej b'i chuwäch pa ri b'e. Xeb'e' k'ut, xeopan pa jun alaj tinimit re Samaria, xkitzukuj jawije' ri käwar wi ri Are', xuquje' ri käwi' wi chila'. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ri winaq ajchila' man xkik'ulaj tä k'ut, rumal chi xkilo chi b'enam re ri Jesús pa Jerusalén. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Aretaq ri tijoxelab', ri tat Jacobo, ri tat Juan xkil wa' jas ri xkib'an ri ajtinimit, xkib'ij: Qajaw, ¿a kaj la chi kujtaqan chuqasaxik q'aq' chikaj rech käk'is ki wäch we winaq ri', je' jas xub'an ri Elías, ri q'alajisal re ru Loq' Pixab' ri Dios ojer? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Xutzolq'omij rib' ri Jesús, xeuyajo, xub'ij chke: ¿A xa man kich'ob' taj chi are ri Loq'alaj Espíritu rech ri Dios ri kätaqan pi wi'? Man are tä k'u ru rayinik ri Are' chi je' kib'an wa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ri in k'ut, in ri' ri Ralk'ual ri Dios ri Qas Winaq, man xinpe tä chusachik ki wäch ri winaq, xane che ki to'ik, —xcha chke. Xeb'e' k'u pa jun alaj tinimit chik. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","E b'enaq k'u pa ri b'e, k'o jun achi xub'ij che ri Jesús: Qajaw, kine' uk' la apawije' ta ne ri ke' wi la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Xub'ij ri Jesús che: Ri yak e k'o taq ri ki jul, xuquje' e k'o ri ki sok ri chikop ajuwokaj. Are k'u ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, man k'o tä jawije' kinwar wi, —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Xub'ij ri Jesús che ri jun chik: Sa'j wuk', —xcha che. Xub'ij ri are': Qajaw, ya la chwe chi nab'e kine'k, kinmuq na kan ri nu tat aretaq käkämik, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Xch'aw chi ri Jesús, xub'ij che: Cheaya kan ri käminaqib' pa ri ki mak chekimuqu ri ki käminaq. Ri at k'ut, jatzijoj ru Loq' Pixab' ri Dios chrij ru taqanik ri Dios pa ki wi' ri winaq, —xcha ri Jesús che. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Jun achi chik xub'ij: Qajaw, kine' na uk' la, —kächa'. Nab'e k'ut ya la chwe chi kine'k, keinch'ab'ej na kan ri ajuwowachoch, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Xub'ij ri Jesús che: Jun winaq ri kuchap u b'anik taji'n, we kusaq'orij ru chak, man kuk'is taj, man k'o tä u patän wa'. Xuquje' jun winaq ri kraj kok che tijoxel we, ri xa kub'an kieb' ranima', man k'o tä k'u u patän wa' che ri Dios pa ru taqanik pa ki wi' ri winaq, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Te k'u ri' ri Jesús xeucha' oxk'al lajuj u tijoxelab' chik. Pa kakab'il xeutaq b'ik rech kenab'ej b'i chuwäch. Xeb'e' k'u pa ronojel tinimit, xuquje' jawije' chi' ri rajwaxik ke' wi na ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Xub'ij ri Jesús chke: Qas nim ri jach', xa k'u e kieb' oxib' ri ajchakib'. Chib'ochi'j b'a' ri Rajaw ri jach' chi cheutaqa b'i ajchakib' pa ru jach', —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","¡Jix b'a'! Kixintaq b'ik je' ta ne chi ri ix, ix alaj taq chij chkixol ri utiw. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Miwuk'aj b'i i bolsa che ri i rajil. Mik'am b'i ri i chim, mik'am k'u b'i ri i xajäb'. Mixtak'i che tzij pa taq ri b'e rech man kixb'eytaj taj. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Apachike ja ri kixok wi, chib'ij nab'e: Chuxlan b'a' kanima' ri winaq ri e k'o pa we ja ri', —kixcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","We k'o jachin jun winaq cho ri ja ri' ri qas kraj chi kuxlan ranima', kuk'amowaj na wa' ri i tzij re tewchib'al, kuxlan k'u na ranima'. Are k'u we man k'olik, man käkanaj tä kan ri tewchib'al pa ki wi' ri winaq re ri ja ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Chixkanaj kan pa ri jun ja ri'. Xaq mixb'in chi' taq ja. Kitij na ri käyi' chiwäch, rumal chi ya'tal che ri ajchak chi kuk'am ri tojb'al re ru chak, —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Apachike tinimit ri kixopan wi, we kixkik'ulaj, chitija ri käkiya chiwäch. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Chikunaj ri yawab'ib' ri e k'olik, chib'ij k'u chke: “Naqaj ix k'o wi che ru taqanik ri Dios pa ki wi' ri winaq,” —kixcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Apachike tinimit ri kixopan wi, ri man kixkik'ulaj tä wi ri winaq, chib'ij kan wa' chke aretaq kixel b'ik: ");
INSERT INTO qucNNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Xuquje' ne ri ulew re ri tinimit alaq ri nak'al chke ri qaqan, käqatota' na kan che q'alajisab'al chij alaq chi man utz tä ri käb'an alaq. Chich'ob'o b'a' chi naqaj chech alaq k'o wi ru taqanik ri Dios pa ki wi' ri winaq,” —kixcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kinb'ij k'u chiwe chi pa ri q'ij ri käpetik, ri kuq'at na tzij ri Dios, kätan na ri' ri k'äjisab'al u wäch ri tinimit Sodoma chuwäch ri k'äjisab'al u wäch ri tinimit ri', —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","¡K'äx iwe, winaq re ri tinimit Corazín! ¡K'äx iwe, winaq re ri tinimit Betsaida! We ta xeb'an ri kajmab'al ri' pa ri tinimit Tiro, pa ri tinimit Sidón, jas ri xeb'antaj iwuk' ix, k'extajinaq ta chi na ri kanima' ri winaq jela', ki kojom ta chi katz'iaq ri kuq'alajisaj chi keb'isonik. Xuquje' k'o ta b'anom wi ri kuq'alajisaj chi are ri ki mak ri keb'ison che, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Rumal ri' kätan na ri k'äjisab'al ki wäch ri winaq aj Tiro, aj Sidón chuwäch ri k'äjisab'al i wäch ix aretaq käq'at na tzij pi wi'. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ri ix k'ut, winaq re ri tinimit Capernaum, ri sib'alaj xinimarisaj iwib', k'ä pa ri q'aq' kixqasax wi na, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Xch'aw chi ri Jesús, xub'ij: Apachike winaq ri kutatab'ej ri i tzij ix, in ri' ri kinutatab'ej. Apachin ri man nim tä kixrilo, in ri' ri man nim tä kinril wi xuquje'. Apachin k'u ri man nim tä kinrilo, man nim tä käril wi ri' ri xintaqow loq, —xcha chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ruk' kikotem k'ut xetzelej loq ri oxk'al lajuj tijoxelab' ruk' ri Jesús, xkib'ij: Qajaw, xuquje' ri itzelalaj taq espíritus keniman chqe aretaq käqakoj ri b'i' la, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Xub'ij ri Jesús chke: Ri in xinwil ri xub'an ri Satanás, aretaq xtzaq loq chikaj jas kub'an ri kaypa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ri in nu yo'm ri i chuq'ab' rech kixkowinik kitak'alej taq kumätz xuquje' taq ixterix. Nu yo'm xuquje' ri i chuq'ab' chrij ronojel ri kub'an ri qa K'ulel, rech kixch'akan na puwi', man k'o tä k'u jas jun k'äx ri käkowin chub'anik chiwe ix, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mixkikot b'a' rumal chi ri itzel taq espíritus keniman chiwe, xane are chixkikot na rumal chi e tz'ib'am ri i b'i' chikaj, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Qas pa ri hora ri' sib'alaj xkikot ri Jesús rumal ri Loq'alaj Espíritu, xub'ij: Maltiox che la, Tat, lal Rajaw ri kajulew, chi xb'an la chi ri ajno'jab', xuquje' ri k'o ketamb'al man käkich'ob' tä wa' we tzij ri'. Xane xek'ut la chkiwäch winaq ri man k'o tä ketamb'al je' ta ne e are' alaj taq ak'alab'. Je', Tat, je ri' ri utzalaj rayinik la, —xcha ri Jesús che. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Xub'ij xuquje': Ronojel ri k'olik are jachom chwe in rumal ri nu Tat. Man k'o tä jun ri qas retam jachin ri' ri u K'ojol ri Dios. Xaq xuwi ri qa Tat retam. Man k'o tä k'u jun ri qas retam jachin ri' ri Dios qa Tat, xane xaq xuwi ri u K'ojol. Apachin k'u chuwäch ri kraj ri u K'ojol ri Dios kuk'ut wi wa', xuquje' ri winaq ri' retam jachin ri' ri Dios qa Tat, —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ri Jesús xutzolq'omij rib' kuk' ru tijoxelab', xub'ij chke pa ki tukiel wi: Utz ke ri winaq ri käkil ronojel wa' ri tajin kiwil ix, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Je' kinb'ij chiwe chi e k'o k'ia chke ri ojer taq q'alajisal re ru Loq' Pixab' ri Dios, xuquje' nimaq taq taqanelab' ri xkirayij ri rilik jas ri kiwil ix, man xkil tä k'ut. Xkirayij u tatab'exik jas ri kitatab'ej ix, man xkita tä k'ut, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Xtak'i k'u aq'an jun tijonel re ri Pixab' che resaxik u pu chi' ri Jesús, xuta' che, xub'ij: Ajtij, ¿jas k'u kinb'an in rech kinriq na ri k'aslemal ri man k'o tä u k'isik? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Xub'ij ri Jesús che: ¿Jas ri' ri tz'ib'am pa ri Pixab'? ¿Jas pu ri käsik'ij la u wäch? —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Xch'aw chi ri tijonel re ri Pixab', xub'ij: “Sib'alaj chiwaj ri i Dios ri Iwajaw, chijikib'a ri i k'ux, chijikib'a ri iwanima' chrij, chikojo ri i chomanik, chitija k'u i chuq'ab' chub'anik wa',” —kächa'. “Chiwaj k'u ri iwach winaq jas ri ix kiwaj iwib',” —kächa ri Loq' Pixab', —xcha ri tata'. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Xub'ij ri Jesús che ri tata': Qas tzij ri b'im la. B'ana b'a' la wa', k'o k'u na ri k'aslemal la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Are k'u ri tata' kraj kuq'alajisaj rib' chi jikom ranima', xub'ij k'u che ri Jesús: ¿Jachin ri' ri wach winaq? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Xch'aw chi ri Jesús, xub'ij che: Jun achi xel b'i pa ri tinimit Jerusalén, b'enam k'u re pa ri tinimit Jericó. Xchap k'u kumal elaq'omab' pa ri b'e. Ri e are' xkesaj b'i ri ratz'iaq, xkich'ayo. Xeb'e' k'ut, xkiya kanoq. Xa k'u jub'iq' man xkäm ri achi, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Xqaj k'u b'i jun chke ri sacerdotes aj Israel pa ri b'e ri'. Aretaq xril ri achi, naj xok'ow wi che. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Xopan xuquje' jun tata' Levita jawije' k'o wi ri achi. Aretaq xril ri achi soktajinaq, ri are' naj xok'ow wi che xuquje'. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","B'enaq k'u jun tata' aj Samaria pa ri b'e ri'. Aretaq xril ri achi ri soktajinaq pol pa ri b'e, xel ranima' che, xutoq'ob'isaj u wäch. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Xqeb' ruk' ri achi, xukoj kunab'al chke ru soktajik, xupiso. Te ri' xuya ri achi chrij ru kiej, xuk'am b'i pa jun ja warb'al, xrilij k'u chila', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Chukab' q'ij aretaq xel b'ik ri tata' aj Samaria, xresaj loq ru rajil, xuya nik'iaj che ri rajaw ri warb'al, xub'ij che: “B'ana b'a' la toq'ob' chwe, chilij la we achi ri'. Ronojel ri käsach na la chrij, kintoj na che la aretaq kintzelej loq,” —xcha che, —kächa ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ri Jesús xuta' che ri tijonel, xub'ij: ¿Jas ri chomanik la? ¿Jachin chke ri oxib' winaq ri' are ri qas rach winaq ri achi ri xchap kumal ri elaq'omab'? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Xch'aw chi ri tijonel re ri Pixab', xub'ij: Ri xutoq'ob'isaj u wäch, are qas rach winaq, —xcha'. Xub'ij k'u ri Jesús che: Ri lal, b'ana b'a' la junam jas ri xub'an ri tata' aj Samaria, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Xutaqej ru b'e ri Jesús, e rachi'l k'u ru tijoxelab'. Xeopan pa jun alaj tinimit. Jun ixoq, Marta u b'i', xeuk'ulaj cho rachoch. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ri nan Marta k'o jun u chaq', María u b'i'. Xt'uyi k'u ri nan María chuwäch ri Jesús chutatab'exik ri kub'ij. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Sib'alaj latz' k'u u wäch ri nan Marta rumal rech ri k'ia u chak. Xopan ruk' ri Jesús, xub'ij che: Qajaw, ¿a xaq kil la chi ri nu chaq' kinuya kan nu tukiel chub'anik ri chak? B'ij b'a la che chi chinuto', —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Xch'aw ri Jesús, xub'ij che: Marta, Marta, sib'alaj are kachomaj ri a chak. Tzb'enaq awanima' ruk'. ");
INSERT INTO qucNNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","K'o k'u ri qas rajwaxik. Are k'u ri María are xucha' ri utz na, man kesax tä k'u wa' che, —xcha ri Jesús che. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ri Jesús tajin kub'an orar pa jun k'olib'al chik. Aretaq xto'tajik, jun chke ru tijoxelab' xub'ij che: Qajaw, chujitijoj la chub'anik orar, je' jas ri tat Juan xuk'ut chkiwäch ru tijoxelab', —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Xub'ij ri Jesús chke: Aretaq kib'an orar, chib'ij: Qa tat, ri lal k'o la pa ri kaj, chnimarisax ta na u q'ij ri b'i' la. Chtaqan ta na la pa ki wi' konojel winaq. Chb'an ta b'a' ri rayib'al la cho ruwächulew, jas ri käb'an uk' la chila' chikaj. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ya la ri qa wa ronojel q'ij. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Sacha la ri qa mak, je' jas ri uj xuquje' käqasach ri ki mak ri käka'n k'äx chqe. Mäya la chqe chi kujtaqchi'x che mak, xane chujto' la cho ri Itzel, —kixcha na, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Xuquje' xub'ij ri Jesús chke: We k'o jun chiwe ri k'o jun awachi'l, kopan ta awuk' pa nik'iaj aq'ab', kub'ij chawe: “Wachi'l, kinjal ta na oxib' kaxlan wa chawe. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Xa k'o jun wachi'l chik petinaq pa ri b'e, opaninaq k'u wuk' cho wachoch. Man k'o tä k'u jas kinya che,” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Are k'u ri at katch'aw ta loq, kab'ij che: “Maya latz' chwe. Tz'aptal chi ri uchib'e. Ri walk'ual k'ut e q'oyol chi wuk' in. Man kinkowin taj kinwalijik chutzukuxik jas kinya chawe,” —katcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Pune man kawaj katwalij ri' chuya'ik ri wa che rumal k'u rech chi are ri awachi'l ri kuta' toq'ob' chawe, qas katwalij na ri' rumal chi ri awachi'l man kutänab'a tä ru ta'ik toq'ob', kaya na ronojel ri rajwaxik che, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Je ri' kinb'ij chiwe: Chita' b'a', k'o k'u käya'taj na chiwe. Chitzukuj na, k'o na ri kiriqo. Chixk'ork'otoq, käjaqataj na ri uchija chiwäch. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Apachin k'u ri k'o jas kuta', kuk'am k'u na wa'. Ri winaq ri k'o kutzukuj, k'o na ri kuriqo. Ri winaq ri käk'ork'otik, käjaqataj na ri uchija chuwäch, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","¿A k'o lo jun chiwe ix, ri ix tata'ib', we ta ri a k'ojol kuta' ru wa, ri at k'ut kaya jun ab'aj che? We ta kuta' jun u kär, ¿a kaya lo jun kumätz che chuk'exwäch ri kär? ");
INSERT INTO qucNNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","We kuta' jun u saqmol, ¿a kaya ne lo jun ixterix che? ¡Man je' taj! —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","We ri ix ri ix ajmakib' iwetam ri ki sipaxik utzalaj taq jastaq chke ri iwalk'ual, ¿a ma tä ne ri i Tat ri k'o chila' chikaj kuya na ri Loq'alaj Espíritu chke ri winaq ri käkita' wa' che? —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ri Jesús tajin käresaj b'i jun itzelalaj espíritu ri kub'an memal. Aretaq xel b'i ri itzelalaj espíritu, xkowinik xch'aw ri achi ri mem nab'e. Xkikajmaj k'u wa' ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","E k'o jujun chke ri winaq xkib'ij: Wa' we achi ri' keresaj b'i ri itzel taq espíritus ruk' ru chuq'ab' ri Beelzebú ri ki nimal ri itzel taq espíritus, —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","E k'o jule' chik ri xkikoj ki chuq'ab' che resaxik u pu chi' ri Jesús che rilik jas ri kub'ano. Xkita' che chi kub'an jun kajmab'al k'utb'al ajchikaj chkiwäch. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ri Jesús retam ri ki chomanik, xub'ij chke: Jun tinimit ri u b'anom kieb', ri käch'ojin na ri juch'ob' chrij ri juch'ob' chik, kuk'is k'u na rib' ri tinimit ri'. Kewulix na konojel taq ri ja pa ri ch'oj. Xuquje' jun achalaxik ri u b'anom kieb', ri kech'ojinik, kusach k'u na rib' ki wäch. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Xuquje' we ri Satanás käch'ojin chrij chb'il rib', ¿jas k'u lo kub'an ri' chujeqb'axik ri u taqanik ri are'? —kächa ri Jesús. Kinb'ij wa' rumal chi ri alaq käb'ij alaq chi kinwesaj b'i ri itzel taq espíritus rumal ri Beelzebú. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","We ri in kinwesaj b'i ri itzel taq espíritus ruk' ru chuq'ab' ri Beelzebú, ¿jachin k'u kuya ri ki chuq'ab' ri tijoxelab' alaq rech je' käka'n wa' xuquje'? Ri e are' je' käkik'ut na chi sachinaq ri alaq. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","We ri in kinwesaj b'i ri itzel taq espíritus ruk' ru chuq'ab' ri Dios, kel kub'ij wa' chi kämik ri' ri Dios u chaplem taqanik waral, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","We k'o jun achi ri sib'alaj k'o u chuq'ab', utz k'u kub'an chuchajixik ri rachoch kuk' ch'ojib'al re ch'ich', man k'o tä ri käb'anow k'äx ri' chke ri jastaq re. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","We kopan ne jun ri k'o na u chuq'ab' chuwäch ri achi ri', käch'akan k'u puwi', keresaj k'u b'i konojel ru ch'ojib'al taq ch'ich' ri xuku'b'isaj wi u k'ux chkij. Keujach na b'i ri jastaq ri xeutoqij chkiwäch ri rachi'l, —kächa'. (Je' xinch'akan in puwi' ri Satanás,) —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Apachike winaq ri man kraj tä kub'ano jas ri kinb'ij, kub'an u k'ulel ri' chwe. Apachin k'u ri man kinuto' tä che ki mulixik ri nu chij, wa' we winaq ri' are junam ruk' jun winaq ri xa keujab'uj, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Aretaq jun itzelalaj espíritu kel b'i che jun winaq, xaq käwakatalob' chi pa taq ri juyub' ri ketz'inowik ri man k'o tä wi joron, kutzukuj k'u ri kuxlan wi. Man kuriq tä k'ut, xa je ri' kuchomaj: “Kintzelej na b'i cho wachoch jawije' ri xinel wi loq,” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Aretaq kopanik, kuriq k'u ri ranima' ri winaq je' ta ne jun ja ri ya mesom chik, ri ya b'anom chi u b'anik wa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ke' k'ut, keuk'ama chi loq wuqub' itzelalaj taq espíritus ri e k'äx na chuwäch ri are'. Konojel keb'okik, kejeqi k'u chila'. Chuk'isb'al ri u b'antajik ri winaq ri' ri e k'o ri itzelalaj taq espíritus che, sib'alaj känimataj na chuwäch ri nab'e u b'anik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ri Jesús tajin kutzijoj wa' we tzij ri', ko xch'aw jun ixoq chkixol ri winaq, xub'ij: ¡Utz re ri chichu' ri xil wäch la rumal, ri xk'iyisan la! —xcha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Xub'ij k'u ri Jesús: ¡Are utz na ke ri winaq ri ketow ru Tzij ri Dios, keniman k'u che! —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Aretaq ri winaq xkimulij kib' cho ri Jesús, xuchaplej ki tzijob'exik, xub'ij chke: Xa e lawalo taq winaq ri winaq re ri q'ij junab' ri'. Xaq käkaj chi kinb'an jun etal ri kajmab'al chkiwäch. Man käb'antaj tä k'u na jun etal chkiwäch, xane xaq xuwi ri etal re ri qa mam Jonás, q'alajisal re ru Loq' Pixab' ri Dios ojer. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, in ri' ri etal chke ri winaq re we q'ij junab' ri', je' jas ri qa mam Jonás are xok che jun etal chkiwäch ri winaq ri xek'oji pa ri tinimit Nínive, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ri chichu' ri xk'oji che nim taqanel pa ki wi' konojel ri winaq aj Seba kätak'i na kuk' ri winaq re we q'ij junab' ri' pa ri q'atän tzij ri käpetik. Käch'aw k'u na ri ixoq ri' chiwij ix rumal chi xel loq ri are' pa ru tinimit ri sib'alaj naj k'o wi, xopan k'u ruk' ri nim taqanel Salomón ojer chutatab'exik ri nojib'al u tijonik. Chiwilampe ix chi k'o Jun waral ri nim na u b'anik chuwäch ri nim taqanel Salomón. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ri winaq k'ut aj Nínive, ketak'i na junam kuk' ri winaq re we q'ij junab' ri' pa ri q'atän tzij. Kech'aw k'u na ri winaq aj Nínive chiwij ix rumal chi xkik'ex kanima', xkik'ex k'u ki chomanik rumal ri xutzijoj ri qa mam Jonás chke. K'o k'u jun waral ri nim na u b'anik chuwäch ri qa mam Jonás, —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Man k'o tä jun winaq ri kutzij jun chäj, o jun candela, te k'u ri' kuch'uqu, kuya wa' chuxe' jun chikäch. Xane kutzuk'ub'a wa' chikaj rech kuya saqil chkiwäch ri winaq ri keb'ok pa ja, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ri a waq'äch e are je' jas jun chäj ri kuya saqil chawe. We utz ri a waq'äch, q'alaj ri b'e chawäch. We man utz ri a waq'äch, man q'alaj tä ri b'e chawäch. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Chawila b'a' chi ri saqil ri k'o awuk' man käk'extaj tä ri' pa q'equmal. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","We k'o ri saqil chawäch, man k'o tä ne jub'iq' ri q'equmal, kawil b'a' na ronojel pa saqil, je' jas ri kub'an jun chäj, o jun candela chawäch, kätununik, —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Aretaq ri Jesús xto'taj chub'ixik wa', xch'aw jun tata' fariseo, xub'ochi'j chi käwi' ruk' cho ja. Xe' k'u ri Jesús, xok b'i pa ri ja, xt'uyi chi' ri mesa. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ri fariseo xrilo chi aretaq xok ri Jesús che ri wi'm, man xub'an tä ri kub'ij pa ri ki pixab' ri fariseos, ri e naq'atal chub'anik aretaq käb'an ri ch'ajow q'ab'aj. Ri fariseo jun wi xrilo. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Xub'ij ri Qajaw Jesús che: Ri alaq fariseos, käch'aj alaq ri rij ri laq xuquje' ri rij ri vaso. Are k'u pa anima' alaq k'o wi ri lawaloyil, k'o ri itzel rayinik alaq, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Kon taq winaq! ¿A mat etam alaq chi ri Dios ri xb'anow ri rij jun winaq are ri' ri xb'anow ri ranima' xuquje'? ");
INSERT INTO qucNNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","B'ana b'a' alaq utzil rech kel na ri etzelal pa ri anima' alaq. Je ri' ronojel käkanaj na kan ch'ajch'oj, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡K'äx ech alaq, fariseos! Ri alaq käya alaq ru lajujil ri q'eb'un, ri ruda, xuquje' ronojel u wäch ichaj. Käya k'u kan alaq ri u b'anik ri utzil, man qas tä k'u loq' ri Dios chuwäch alaq. Are k'u wa' ri rajwaxik käb'an na alaq, man käya tä k'u kan alaq ru b'anik ri jule' chik, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡K'äx ech alaq, fariseos! Kaj alaq ri t'uyulib'al kech nimaq ki b'anik pa ri rachoch Dios, xuquje' kaj alaq chi nim kil wi alaq, chi utz ch'ab'exik alaq käb'an pa taq ri b'e, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡K'äx ech alaq, fariseos, xuquje' ri alaq tijonelab' re ri Pixab'! Ri alaq onojel alaq xaq kieb' wäch alaq. Ri alaq junam alaq kuk' ri muqub'al ri man keilitaj taj. Keb'in k'u ri winaq pa ki wi' ri muqub'al, man ketam taj chi k'o q'ayinaq taq b'aq chupam, —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jun chke ri tijonelab' re ri Pixab' xch'awik, xub'ij che: Ajtij, aretaq käb'ij la wa', uj xuquje' kujyoq' la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Xub'ij k'u ri Jesús chke: ¡K'äx ech alaq xuquje', alaq tijonelab' re ri Pixab'! Rumal chi käya alaq k'ia taq pixab' chke ri winaq je' ta ne chi e nimaq taq eqa'n ri käya alaq chkij. K'äx k'u ri keqa'xik kumal ri winaq. Ri alaq k'ut man k'o tä jas käb'an alaq che ki to'ik ri e are', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡K'äx ech alaq! Keyak alaq ri muqub'al taq ja ri e muqum wi ri ojer taq q'alajisal re ru Loq' Pixab' ri Dios ri xekämisax kumal ri mam alaq. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Qas tzij chi ri alaq, alaq q'alajisal taq ke ri xka'n ri mam alaq, xuquje' junam wäch alaq kuk' ri mam alaq. E are' xekämisanik, ri alaq k'ut keyak alaq ri muqub'al taq ja ri e muqum wi, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Rumal rech wa' kub'ij ri Dios ruk' ru nojib'al: “Keintaq na b'ik q'alajisal taq re ri Loq'alaj nu Pixab', xuquje' jule' taq nu taqo'n chik. Ri winaq k'ut kekikämisaj na jujun chke ri nu taqo'n. Jujun k'ut käka'n na k'äx chke,” —xcha ri Dios, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","U b'im wa' ri Dios rech ri winaq re taq we q'ij junab' ri' käk'äjisax ki wäch rumal ri ki kämisaxik konojel ri u q'alajisanelab' ri Dios ri e kämisam tzpa ru b'anik ru wächulew petinaq loq. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Are k'u tzje wa' ru kämisaxik ri tat Abel, xuquje' ru kämisaxik ri tat Zacarías ri xkäm chkixol ri ta'b'al toq'ob' ruk' ri loq'alaj k'olib'al ri sib'alaj äwas chi kok b'i xa apachinoq, ri k'o pa ri nimalaj rachoch ri Dios. Je' kinb'ij wa' che alaq chi ri winaq re we q'ij junab' ri', e are wa' ri kekeqlej na wa', —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡K'äx ech alaq, tijonelab' re ri Pixab'! Etam alaq jas u riqik ronojel u wäch no'j. K'u'm k'u alaq wa' we etamanik ri' chkiwäch ri jule' taq winaq chik. Ri alaq k'ut, man käb'an tä alaq jas u b'eyal ri etamanik ri', —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Elem k'u kub'an b'i ri Jesús, ri tijonelab' re ri Pixab' xuquje' ri fariseos sib'alaj xpe koyowal che. Xkikoj ki chuq'ab'. Xkichap u k'otik u chi' chkij k'ia taq tzij. ");
INSERT INTO qucNNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Xkik'ak'leb'ej k'u u ta'ik jun tzij pu chi' rech käka'n tzijtal chrij. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Xkimulij k'u kib' sib'alaj k'ia winaq je ri' chi käkitak'alela kib'. Ri Jesús xeutzijob'ej ru tijoxelab' nab'e, xub'ij chke: Chichajij iwib' chuwäch ri ki ch'amil ri tata'ib' fariseos. Ri ch'äm ri kinb'ij chiwe man qas tä ch'äm wa', xane are ri ki no'j ri fariseos ri xaq kieb' ki wäch ri kinjunamaj ruk' ri ch'äm, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Man k'o tä k'u ri ch'uqtalik ri mat käq'alajin na. Man k'o tä k'u ri k'u'talik ri mat ketamataj na. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ri i tzijom pa q'equm, kätatab'ex na wa' pa saqil. Ri i jasjatem xuquje' ri kib'an pa ri ja, kätzijox na wa' pa ri b'e, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Kinb'ij k'u chiwe ix, qachalal, chi mixej iwib' chkiwäch ri kekämisan ri cuerpo, te k'u ri' man k'o tä chi ri kekowin chub'anik chiwe. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kink'ut na in jachin chuwäch ri rajwaxik kixej wi iwib'. Are chixej iwib' ri' chuwäch ri jun ri käkowinik kixuk'iäq b'i pa ri q'aq' aretaq ix u kämisam chik. Je' kinb'ij chiwe, are chixej iwib' chuwäch wa', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","¿A mat kieb' centavos kek'iyix wi job' chi'ch? Man k'o tä k'u jun chke we alaj taq chikop ri' ri käsach pu jolom ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Xuquje' retam ri Dios joropa' ri rismal i wi' e k'olik. Mixej b'a iwib'. Más ix loq' na ix chkiwäch k'ia taq chi'ch, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Je' kinb'ij chiwe chi apachin ri kutzijoj chkiwäch ri winaq chi are wachi'l in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, kinb'ij na chkiwäch ri ángeles re ri Dios chi wech in we winaq ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Apachin k'u ri kub'ij chkiwäch ri winaq chi man retam tä nu wäch in, kinb'ij k'u na in chkiwäch ri ángeles re ri Dios chi man wetam tä u wäch we winaq ri', —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Apachike winaq ri käyoq'on chwe in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, käsach na u mak wa'. Apachin k'u ri kub'ij ri äwas u b'ixik chrij ri Loq'alaj Espíritu re ri Dios, man käsach tä na u mak ri', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Aretaq kixkichap ri winaq, kixkik'am b'i chkiwäch ri ki nimaqil ri winaq re ri rachoch Dios o chkiwäch ri q'atal taq tzij, xuquje' chkiwäch ri nik'iaj taq taqanelab', mixej iwib' che jas ri rajwaxik kib'ij o jas kito'b'ej iwib'. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Are k'u ri Loq'alaj Espíritu kuya na chiwe pa we hora ri' jas ri rajwaxik u b'ixik iwumal, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Jun chke ri winaq xub'ij che ri Jesús: B'ij la che ri wachalal chi kuya we ri echb'al, —xcha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Xch'aw ri Jesús, xub'ij che: Tat, man in kojom tä che q'atal tzij puwi' alaq. Xuquje' man in k'o tä che jachal echb'al, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Xub'ij k'u chke konojel: Chilampe alaq chi kächajij ib' alaq chuwäch ru rayixik k'ia u wäch jastaq ajuwächulew. Pune e k'o k'ia ri jastaq re jun winaq, man are tä ri' ri käyo'w ru k'aslemal, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ri Jesús xukoj chi na jun k'utb'al chkiwäch, xub'ij: K'o jun achi ri sib'alaj q'inom. Sib'alaj nim ru wächinik ri rulew xuya'. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kächoman k'u ri achi pa ranima', kub'ij: “¿Jas kinb'an na? Man k'o tä chi k'olib'al jawije' kinya wi ri nu jal,” —kächa ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Xuchomaj pa ranima', xub'ij: “Are wa' ri kinb'an na. Keinyojij na ri nu k'uja, keinyak na jujun chik más nimaq. Kinya na ri nu jal, xuquje' taq ri jastaq we chkipam wa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Te k'u ri' aretaq kinto'taj chub'anik wa' kinb'ij na chwe chb'il wib': Tuxlanoq, two'q, chab'ana a nimaq'ij rumal chi e k'ia ri jastaq awe ri a k'olom. Kub'an na wa' che k'ia junab',” —kincha na in, —kächa ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Xub'ij k'u ri Dios che: “¡Konalaj achi! Kämik chaq'ab' katkämik, kel na rawanima'. ¿Jachin lo ajchaq'el kan ri jastaq ri a k'olom?” —xcha ri Dios che, —kächa ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Je ri' ri kuk'ulmaj ri winaq ri kumulij q'inomal che chb'il rib', man q'inom tä k'u wa' cho ri Dios, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Xub'ij k'u ri Jesús chke ru tijoxelab': Rumal ri' kinb'ij chiwe chi mixok il che ri i k'aslemal, jas ri kitijo, jas ri iwatz'iaq kikojo. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nim k'u na u b'anik ri i k'aslemal chuwäch ri wa. Nim na u b'anik ri i cuerpo chuwäch ri atz'iaq, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","¡Cheiwilampe ri joj! Man käkitik tä ab'ix, man k'o tä k'u jach' käka'no. Man k'o tä jawije' kekik'ol wi ri jastaq ke, man k'o tä k'u ki k'uja. Are k'u ri Dios ketzuquwik. Ri ix k'ut más ix loq' na chkiwäch ri chikop ajuwokaj, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Jachin ta k'u ne chiwe ix käkowinik käk'asi na kieb' oxib' junab' chik xaq pa re wi? Man k'o taj, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","We man kixkowin tä chub'anik jun jasach ri nitz' na, ¿jas che kixok il chke ri jule' jastaq chik? —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Chiwilampe ri kotz'ij, jas käka'no kek'iyik. Man kechakun taj, man k'o tä k'u kiem käka'no. Pune ta ne je ri', kinb'ij chiwe chi ri nim taqanel Salomón ojer ruk' ronojel ru q'inomal man je' tä ratz'iaq wa' xukojo jas jun chke we kotz'ij ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","We ri Dios je' kub'an wa' che katz'iaq ri q'ayes ri e k'o kämik pa juyub', chuweq k'ut keyi' pa ri q'aq', ¿a mat kärilij ri' ri Dios ri iwatz'iaq ix? —kächa'. ¡Ay ri ix, ix achijab' ri xaq jub'iq' kixkojonik! ");
INSERT INTO qucNNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","¡Mixok b'a' il che jas kitijo, mixej k'u iwib' rumal wa'! ");
INSERT INTO qucNNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Konojel we jastaq ri' ronojel q'ij qas käkitzukuj ri nik'iaj winaq chik ajuwächulew. Ri i Tat k'ut retam jachike ri kajwataj chiwe ix, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Chixchakun b'a' nab'e chujikib'a'xik ru taqanik ri Dios, kiriq k'u na xuquje' ri nik'iaj jastaq chik ri e rajwaxik chiwe, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Pune ri ix man ix k'ia taj, mixej b'a' iwib'. Rumal chi käkikot ranima' ri qa Tat chuya'ik chiwe chi kixk'oji na pa ru taqanik ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Chik'iyij ri jastaq iwe, chisipaj ri rajil chke ri meb'a'ib'. Je ri' käyi' na chiwe jun iwechb'al pa ri kaj ri man käq'elob' taj. Käyi' na xuquje' jun q'inomal chikaj ri man k'o tä u k'isik. Man kopan tä k'u elaq'om chila', man kächikopir tä wa', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Jun winaq are amaq'el kuchomaj ri jastaq re. We k'o ri iwech ix pa ri kaj, are kichomaj na ri k'o chikaj, man xuwi tä ri' ri k'o cho ruwächulew, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Chisuk'umaj b'a' iwib', chitzija k'u ri i candela chuk'ulaxik ri Iwajaw. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Je' kib'ano jas ri käka'n ri patäninelab' ri keye'm u k'ulaxik ri ki patrón kätzelej loq pa jun k'ulanem, rech aretaq kulik, käch'aw chi' ri porta, chanim käkitor chuwäch. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Utz ke ri patäninelab' ri' ri keriqtaj na rumal ri ki patrón chi e k'aslik aretaq kätzelej loq. Qas tzij kinb'ij chiwe chi ri ki patrón keut'uyub'a' na chi' ri mesa, kusuk'umaj na rib' rech kuya ke ri ki wa, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Pune ta k'ä te' kul ri ki patrón pa nik'iaj aq'ab', pune sib'alaj aq'ab', we kärilo chi e k'aslik, utz ke ri patäninelab' ri', —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Chich'ob'o b'a' wa' chi we ta jun ajchaq'el ja käretamaj jachike hora kopan ri elaq'om, käk'ask'at na ri', man kuya' tä ri' chi kokb'ex ri rachoch, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Chiwila b'a' chi ri ix, ix suk'umatal chik rumal chi kätzelej na loq ri Ralk'ual ri Dios ri Qas Winaq pa ri hora ri man kichomaj taj, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Te ri' xub'ij ri tat Pedro che: Qajaw, ¿a xtzijoj la wa' we k'utb'al ri' xaq xuwi chqe uj? ¿A mat chke konojel? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Xub'ij ri Qajaw Jesús: ¿Jachin lo ri jun utzalaj patäninel ri sib'alaj k'o u no'j? We patäninel ri' are käkoj na rumal ru patrón pa ki wi' ri nik'iaj patäninelab' chik rech kuya ri ki wa ronojel q'ij. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Utz re ri patäninel ri' ri käriqtajik chi tajin kub'an ru chak aretaq kopan ru patrón, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Are qas tzij ri kinb'ij chiwe chi ri patrón kukoj na ri patäninel ri' pa ki wi' konojel ri jastaq re. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Qachomaj b'a' jas kuk'ulmaj na we man utz tä kub'an ri patäninel ri', xane ri are' kuchomaj chi xa käb'eytaj ru patrón, kuchaplej k'u ri u b'anik k'äx chke ri nik'iaj ajchakib' chik xuquje' chke ri ajik'ab', xuquje' ne kuchaplej u b'anik nimaq'ij. Xa sib'alaj käwi'k, xuquje' käq'ab'arik. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Xaq te'talik k'ut kul ru patrón pa jun q'ij ri man kuchomaj tä ri' ri patäninel, pa jun hora ri man retam taj. Qas tzij chi sib'alaj käk'äjisax na u wäch ri patäninel ri' rumal chi man jikom tä ri ranima' chub'anik ronojel ri xtaqan wi ri rajaw, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ri patäninel ri kuch'ob'o jas ru rayinik ru patrón, te k'u ri' man kujikib'a tä k'u rib', man käniman tä k'u che, are k'u wa' we winaq ri' sib'alaj käk'äjisax na u wäch. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ri patäninel k'ut ri man kuch'ob' tä ru rayinik ru patrón, kub'an k'ut jachike ri taqal wi u k'äjisaxik u wäch, kätan na ri' ri k'äjisab'al u wäch ri käb'an na che. We jun winaq kuya rib' pa k'olib'al re eqle'n, nim wa' ri käta' na che kumal ri nik'iaj winaq chik. We ri winaq ki jikib'am wi kanima' che jun winaq chik, k'ia k'u ri utzil käkita' che we winaq ri', —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Xinpe in rech kinya tijonik chke ri winaq ajuwächulew. We tijonik ri' are je' jas ru t'iqik q'aq' cho taq ri juyub'. Kwaj ta na chi ya tajin käk'at chi we q'aq' ri', —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","K'o na jun nimalaj k'äx ri rajwaxik kinriqo. Kwaj ta na chi xb'antaj ta kan ri k'äx ri', xinto'taj ta k'u che, —kächa ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿A kichomaj ix chi in petinaq rech xa käk'oji utzil chkixol ri winaq ajuwächulew? ¡Man je' taj! Xane xinpe in chub'anik ch'oj. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tzkämik ri' kächap na b'i u b'anik we ch'oj ri'. Job' winaq ri e k'o pa jun ja käkik'ulelaj na kib', ri oxib' chkij ri kieb', ri kieb' chik chkij ri oxib'. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Käb'antaj na ch'oj, jun tata' kuk'ulelaj na ru k'ojol, ru k'ojol k'ut kuk'ulelaj na ru tat, xuquje' ri chichu' kuk'ulelaj na ri ral ali, ri ali kuk'ulelaj na ru nan, xuquje' ne ri jun ali chik kuk'ulelaj na ri ralib' chichu', ri ralib' chichu' k'ut kuk'ulelaj na ri are', —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Xub'ij k'u ri Jesús chke ri k'ialaj winaq: We kiwil ri sutz' ri käpaqi loq, chanim kib'ij: Kraj käpe jäb', —kixcha'. Je' k'u käk'ulmatajik, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Aretaq käxuli ri kiäqiq', kib'ij: Käpe na ri saq'ij, —kixcha'. Je' käk'ulmatajik, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Ri alaq, xa kieb' wäch alaq! Kächob' alaq ri u wo ri kaj xuquje' ruwächulew. ¿Jas che man käch'ob' tä alaq jas u wäch wa' we q'ij junab' ri'? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Jas che man kächomaj tä alaq jas ri' ri qas jikom, jas ri' ri man qas jikom taj? ");
INSERT INTO qucNNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Aretaq ke' alaq cho ri q'atal tzij achi'l alaq ri k'ulel alaq, tija' b'a' q'ij alaq che rutzirisaxik ib' alaq pa ri b'e, rech man käk'am tä b'i alaq cho ri q'atal tzij. Are k'u ri q'atal tzij käjachow alaq pu q'ab' ri mayor. Ri mayor k'ut käyo'w kan alaq pa che'. ");
INSERT INTO qucNNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Qas tzij ri kinb'ij chi man kel tä na alaq pa che' k'ä kätoj na alaq ri k'isb'al centavo re ri multa, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Pa ri q'ij ri' e k'o jujun winaq chila' ri xkitzijob'ej ri Jesús chkij ri winaq aj Galilea ri xeukämisaj ri tat Pilato, xuyuj k'u ri ki kik'el ruk' ri ki kik'el ri awaj ri xekämisax che ki sipaxik cho ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Xch'aw chi ri Jesús, xub'ij chke: ¿A kächomaj alaq chi ri winaq aj Galilea xkiriq wa' we nimalaj k'äx ri' xa rumal chi más e ajmakib' na chkiwäch ri nik'iaj ki winaqil chik? ");
INSERT INTO qucNNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Man je' ta wa', —kächa'. We ri alaq man käk'ex tä ri anima' alaq, xuquje' ri chomanik alaq, käsach na wäch alaq onojel alaq xuquje', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Xuquje' e k'o ri wajxaq lajuj winaq ri xekäm pa Siloé rumal jun nimalaj ja ri xtzaq pa ki wi'. ¿A kächomaj alaq chi más e lawalo na we winaq ri' chkiwäch ri nik'iaj winaq chik ri e k'o pa Jerusalén? ");
INSERT INTO qucNNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Man je' taj, —kächa'. We ri alaq man käk'ex tä anima' alaq, xuquje' man käk'ex tä chomanik alaq, käsach na wäch alaq onojel alaq xuquje', —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ri Jesús xutzijoj xuquje' we k'utb'al ri' chuya'ik tijonik chke, xub'ij: Jun achi, k'o jun u che'al higos ruk', tiktal k'ut pa ru tikb'al uvas. Xe' k'u ri achi chutzukuxik ri u wäch ri che' ri', man k'o tä k'u xuriqo. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Xub'ij che ri chajil tikb'al uvas: “Chawilampe' chi xke' oxib' junab' kinpe chutzukuxik u wäch ri che' ri', man k'o tä k'u kinriqo,” —xcha', —kächa ri Jesús. “Chat'oyo b'a'. Xaq k'u loq' käk'oji waral pa ri wulew,” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Xch'aw chi ri chajinel, xub'ij che: “Tat, ya la kanoq xaq xuwi che we junab' chik ri'. Kink'ot na rij, kinmesaj na. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","We ne käwächin ne pa we jun junab' chik ri', utz u b'anom. We k'u man käwächin taj, käqat'oy na apanoq,” —xcha che ru patrón, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Pa jun q'ij re uxlanem ri Jesús tajin kuya tijonik pa jun chke ri rachoch Dios. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","K'o k'u jun chichu' chila' ri wajxaq lajuj junab' yawab' rumal jun itzelalaj espíritu. U q'usum rib' käb'inik, man käkowin tä chik chujikomisaxik rib'. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Aretaq ri Jesús xrilo, xusik'ij ri chichu', xub'ij che: Nan, kunam chi la che ri yab'il la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Xuya ru q'ab' puwi' ri chichu'. Chanim k'ut xkowinik xujikomisaj rib'. Xunimarisaj k'u u q'ij ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ri ki nimal ri winaq pa ri rachoch Dios sib'alaj xpe royowal rumal chi ri Jesús xub'an kunanik pa ri q'ij re uxlanem. Xub'ij ri achi chke ri winaq: Xaq xuwi waqib' q'ij rajwaxik kixchakunik. Chixpet pa taq we q'ij ri' rech kixkunaxik, mixpe k'u pa ri q'ij re uxlanem, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Xch'aw chi ri Jesús, xub'ij che: ¡Ri alaq xaq kieb' wäch alaq! Chjujunal alaq käkir alaq ri wakäx, ri burro pa ri recha'b'al pa ri q'ij re uxlanem, käk'am k'u b'i alaq rech kutija u joron. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Wa' we ixoq ri', rachalaxik ri qa mam Abraham, yututal k'u rumal ri Satanás wajxaq lajuj junab'. ¿A mat rajwaxik u kirik wa' che we yab'il ri' pa ri q'ij re uxlanem? —xcha che. ¡Je', je ri'! ");
INSERT INTO qucNNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Aretaq ri Jesús xub'ij wa', konojel ri kek'ulelanik xek'ixik. Are k'u konojel ri nik'iaj winaq chik sib'alaj xekikotik kumal taq ri kajmab'al ri tajin kub'an ri Jesús. Sib'alaj nim xekilo ri xub'an ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Xub'ij k'u ri Jesús: ¿Jas ruk' junam wi ru taqanik ri Dios pa ki wi' ri winaq? ¿Jas ta ruk' kinjunamaj wi wa'? —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Are je' jas jun ija' re mostaza. Jun winaq kuk'am b'i ri ija' ri', kutik pa rulew. Käk'iyik, kub'an nim je' jas kub'an jun che' käk'iyik. Ri chikop ajuwokaj käka'n ri ki sok pa taq ri u q'ab' ri che' ri', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Xub'ij ri Jesús xuquje': ¿Jas ta ruk' kinjunamaj wi ru taqanik ri Dios? —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Are je' jas ri ch'äm ri kuya jun chichu' ruk' oxib' pajb'al k'äj re kaxlan wa, rech käch'ämir ronojel ri q'or, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","B'enam re ri Jesús pa Jerusalén, xeusolij kan ronojel tinimit, ri nimaq xuquje' ri ch'utiq, xuya k'u tijonik chila'. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","K'o k'u jun ri xuta' che ri Jesús: Tat, ¿a xa e kieb' oxib' ri' ri winaq ri käkiriq ri u tob'anik ri Dios? —xcha che. Xch'aw chi ri Jesús, xub'ij chke ri winaq: ");
INSERT INTO qucNNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Kätij chuq'ab' alaq rech kok alaq pa ri uchija ri sib'alaj latz' u wäch. Je' kinb'ij chi e k'ia ri käkitij na ki q'ij rech keb'okik, man kekowin tä k'ut, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Te k'u ri', aretaq ri ajchaq'el ja u tz'apim ri porta, ri alaq ri xaq tak'atoj alaq cho ri ja, käch'aw na alaq chuchi' ri ja, käb'ij na alaq: “Qajaw, Qajaw, toro la ri porta chqawäch,” —kächa na alaq che. Käch'aw k'u na loq ri ajchaq'el ja, kub'ij na: “Ri in man kinch'ob' tä wäch alaq, xuquje' man wetam taj jawije' kel wi alaq,” —kächa ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Kächaplej k'u na alaq käch'aw alaq, käb'ij alaq che: “Uj woqinaq ya' uk' la, xuquje' ri lal yo'm la tijonik pa taq ri b'e re ri qa tinimit,” —kächa na alaq. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kub'ij na ri ajchaq'el ja: “Xinb'ij chech alaq chi ri in man wetam taj jawije' ri kel wi alaq chi'. Chel b'i alaq, alaq b'anal taq etzelal,” —kächa na ri are'. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Are chi' k'ut käb'an wi na alaq ri oq'ej, xuquje' ri quch'uch'em wareyaj rumal ri k'äx aretaq kil alaq chi ri qa mam Abraham, ri qa mam Isaac, ri qa mam Jacob, xuquje' konojel ri q'alajisal taq re ru Loq' Pixab' ri Dios e k'o chila' jawije' ri Dios kätaqan wi. Ri alaq k'ut, man k'o tä alaq kuk' rumal chi esam chi alaq apanoq. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Keopan k'u na winaq ajrelb'al q'ij, aj u qajb'al q'ij, xuquje' winaq aj u wikiäq'ab' ri relb'al q'ij, aj u mox relb'al q'ij, ket'uyi na chi' ri mesa che wi'm jawije' kätaqan wi ri Dios, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Jujun k'u chke ri winaq ri man nim tä keil wi kämik sib'alaj nim keil wi na pa ri q'ij ri'. Are k'u jujun chke ri winaq ri sib'alaj nim keil wi kämik, man nim tä chi na keil wi pa ri q'ij ri', —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Pa ri q'ij ri' xeopan nik'iaj tata'ib' fariseos ruk' ri Jesús, xkib'ij che: ¡Chel b'i la waral! ¡Chanej la! Are ri q'atal tzij Herodes kraj kukämisaj la, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Xub'ij k'u ri Jesús chke: Jeb'ij alaq che we sub'anel Herodes chi kämik xuquje' chuweq kinwesaj na itzel taq espíritus, xuquje' kinkunanik. K'ä te' pa ri urox q'ij kinto'taj na che ri nu chak, —kächa', —kächa alaq che. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Rajwaxik k'ut chi kämik, chuweq, käb'ij kinb'an na u b'anik ri nu chak, —kächa'. ¿A kuya lo käkämisax jun q'alajisal re ru Loq' Pixab' ri Dios pa jun tinimit chik, mat pa Jerusalén? Man je' taj, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","¡Ay, winaq aj Jerusalén! Are kekämisaj alaq ri q'alajisal taq re ru Loq' Pixab' ri Dios, keb'an alaq che ab'aj ri ketaq b'i uk' alaq. ¡K'ia mul nu rayim ri mulixik alaq jas kub'an jun ati't äk' kumulij ri alaj taq ral chuxe' ru xik', man kaj tä k'u alaq! —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Tampe alaq, käkanaj na kan ri achoch alaq, käwonob'ax k'u na kanoq. Man kinil tä chi na alaq k'ä kopan na ri q'ij ri käb'ij alaq: “Nim b'a' ru q'ij ri Jun ri u taqom loq ri Qajaw Dios,” —kächa na alaq, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Pa jun q'ij re uxlanem xe' ri Jesús cho rachoch jun chke ri ki nimal ri winaq, jun tata' fariseo. Jela' xe' wi che wi'm, tajin k'u kaluchi'x kumal ri nik'iaj tata'ib' fariseos. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Jun achi k'ut ri k'o sipoj che k'o chila' chuwäch ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Xch'aw ri Jesús, xeuch'ab'ej ri tijonelab' re ri Pixab' xuquje' ri fariseos, xub'ij: ¿A taqal u b'anik kunanik pa jun q'ij re uxlanem? We ne man taqal taj, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Man xech'aw tä k'u ri e are'. Ri Jesús xuk'am b'i ri yawab' ruk', xukunaj, xutaq b'ik. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Xub'ij k'u chke ri tata'ib': We k'o ri burro alaq, ri wakäx alaq, ri kätzaq b'i pa jun k'ua' pa ri q'ij re uxlanem, ¿a mat kesaj alaq wa' chanim? —xcha chke. ¡Je', je ri'! ");
INSERT INTO qucNNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Man xkiriq tä k'ut jas xkib'ij che. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Xril ri Jesús jas xka'n ri winaq ri e ula'm, chi ri e are' xkicha' ri t'uyulib'al kech ri nimaq ki b'anik chi' ri mesa. Xukoj jun k'utb'al chuyi'k tijonik chke, xub'ij: ");
INSERT INTO qucNNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","We käsik'ix alaq che jun k'ulanem, mät'uyi wi alaq pa taq ri t'uyulib'al kech ri nimaq ki b'anik. We ne käpe na jun winaq ri nim na u q'ij chuwäch alaq ri xuquje' ula'm rumal ri achi. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Kraj käpe ri tata' ri xerulaj alaq ri xuquje' xrulaj ri jun winaq chik, kub'ij che alaq: “Ya la ri t'uyulib'al la che we achi ri',” —kächa na. Ri alaq k'ut, pune sib'alaj käk'ix alaq, käq'ax na alaq ri' pa ri t'uyulib'al ri man qas tä nim u b'anik, —kächa ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Xane aretaq kula'x alaq, tzukuj alaq ri t'uyulib'al ri man qas tä nim u b'anik, t'uyul alaq chila', rech we käpe ri tata' ri xerulaj alaq, kub'ij ta na ri' che alaq: “Wachi'l, k'o jun t'uyulib'al ja le' ri utz na che la,” —kächa na ri'. Qas känimarisax na q'ij alaq chkiwäch konojel ri e k'o uk' alaq chi' ri mesa. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ronojel winaq ri kunimarisaj rib', käqasax na u q'ij ri are'. Ri winaq ri man kunimarisaj tä rib', are k'u wa' känimarisax na u q'ij, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Xub'ij k'u ri Jesús che ri tata' ri xula'nik: Aretaq käb'an la jun ula'nem, we ne jun nimaq'ij, me'ulaj la xaq xuwi ri achi'l la, man xaq xuwi tä ri achalal la, o ri k'ul taq ja la ri e q'inomab'. We je ri' kraj ne je' käka'n na wa' che la xuquje' chutojik u k'exel ri xb'an la chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Xane aretaq käb'an la jun ula'nem, che'ulaj la ri winaq meb'a'ib', ri winaq kutukaq keb'inik, ri ch'okojib' xuquje' ri man keka'y taj. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Utz k'u na ri e la rumal chi man kekowin tä ri e are' chutojik u k'exel wa' che la. Käyi' k'u na u k'exel che la pa ri q'ij re ri ki k'astajik ri winaq ri jikom kanima' chkixol ri käminaqib', —xcha ri Jesús che. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Xuta k'u wa' jun chke ri e t'uyul ruk' ri Jesús chi' ri mesa, xub'ij che: Utz re ri kok na che wi'm chila' jawije' ri kätaqan wi ri Dios, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Xch'aw chi ri Jesús, xub'ij che: Jumul ri' jun achi xub'an jun nimalaj ula'nem. E k'ia k'u ri xeusik'ij. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Pa ri hora re ri wi'm ri achi xutaq b'ik jun patänil re chub'ixik chke ri e sik'im: “Sa'j alaq, ya xutzir ronojel,” —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Junam k'ut xkichaplej resaxik kib' konojel. Xub'ij ri nab'e winaq che ri patäninel: “Nu loq'om ch'äqap wulew,” —kächa'. “Rajwaxik chi kine' che rilik. Chab'ij che ri a patrón chi chub'ana toq'ob' chwe, chusacha nu mak, man kine' taj,” —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Xub'ij jun winaq chik: “Nu loq'om job' k'ulaj wakäx, kinwil na jas käka'no kechakunik,” —kächa'. “Chub'ana toq'ob' chwe, chusacha nu mak, man kine' taj,” —kächa ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Xub'ij ri jun winaq chik: “Man kuya' taj kine'k rumal chi k'ä te' xink'uli'k,” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Xtzelej b'i ri patäninel, xutzijoj ronojel wa' che ri u patrón. Xpe royowal ri u patrón, xub'ij k'u che ri patänil re: “Jat chanim pa taq ri b'e, pa taq ri k'ayib'al re ri tinimit, cheatzukuj ri winaq meb'a'ib', ri winaq kutukaq, ri man kekowin taj keka'yik, xuquje' ri ch'okojib', cheak'ama k'u loq,” —kächa che. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Te k'u ri' xub'ij ri patäninel che ri u patrón: “Xb'antaj kanoq ri xtaqan wi la. K'o k'u na k'olib'al chke nik'iaj,” —kächa che. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Xub'ij k'u ri patrón che ru patäninel: “Jat naj pa taq ri b'e, pa taq ri juyub', chakojo a chuq'ab' rech kepe ri winaq, känoj k'u na ri wachoch. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kinb'ij chiwe ix ri ya ix k'o chik chi man k'o tä jun chke ri xewula'j nab'e ri kutij na jub'iq' re ri nu wi'm ri xinb'ano,” —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","E k'ia winaq k'ut e b'enaq ruk' ri Jesús. Xutzolq'omij rib' kuk', xub'ij chke: ");
INSERT INTO qucNNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","We k'o jun ri qas kraj käk'oji wuk' in, nim k'u na keril ru tat u nan chnuwäch in, xuquje' ri rixoqil, ri ralk'ual, ri ratz, ru chaq', we k'u ne ri ranab', man kuya' taj kok che tijoxel we, —kächa'. Xuquje' ne we nim na käril ru k'aslemal chb'il rib' chnuwäch in, man kuya' tä ri' kok che tijoxel we, —kächa ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ri winaq ri man kutelej tä ru cruz, te ri' käpe wuk' in, man kuya' taj kok che tijoxel we, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","¿A k'o jun chiwe ri kraj kuyak jun nimalaj ja, ri mat nab'e kät'uyi na chub'anik raqan, kärajilaj ru rajil joropa' ri k'olik che rilik we kub'an ri puaq chuk'isik u b'anik ri ja? —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Je ri' kub'ano rech aretaq kojom chik ri tak'alib'al re ri ja, käkowin k'u ri' chuk'isik ri xuchaplej. We ta mat je ri' konojel ri winaq ri keilowik käkichap na u tze'xik u wäch, ");
INSERT INTO qucNNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","kraj ne käkib'ij: “We achi ri' xuchaplej u yakik jun nim ja, man xkowin tä k'ut chub'anik ronojel,” —kecha ne. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","We k'u ne k'o jun nim taqanel ri ke' che ch'oj chrij ri nim taqanel re jun tinimit chik, ¿a mat nab'e kuta' u no'j che retamaxik we kub'an na ri u soldados? Kraj k'o xa lajuj mil u soldados. Ri jun nim taqanel chik kraj e k'o juwinaq mil u soldados. Ri tata' ri k'o xa lajuj mil u soldados kuchomaj na we kekowin ri e are' che ki ch'akik ri juwinaq mil soldados ri kepe na chrij. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","We ne man käkowin tä che, aretaq k'ä naj e k'o wi ru k'ulel che, keutaq b'i ru taqo'n chutz'onoxik chi kutzir ruk', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Je k'u ri' apachin chiwe ix ri man kuya tä kan ronojel ri rech are', man kuya' tä ri' kok che tijoxel we, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Utz ri atz'am. Are k'u we man k'o chik ru tzayil ri atz'am, ¿jas lo ruk' kätzayix wi ri rikil? —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Man k'o tä chi u patän. Man utz tä che ri ulew, man utz tä k'u chumesaxik. Ri winaq xa käkesaj na b'i pa mes, —kächa'. Apachin ri kujikib'a ranima' che nu tatab'exik, chutatab'ej, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Xenaqajin k'u konojel ri toq'il taq alkab'al xuquje' ri nik'iaj ajmakib' ruk' ri Jesús chutatab'exik. ");
INSERT INTO qucNNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Xewixwit k'u ri tata'ib' fariseos xuquje' ri tijonelab' re ri Pixab', xkib'ij: We achi ri' keuk'ulaj ri ajmakib', käwi' k'u kuk', —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ri Jesús xukoj we k'utb'al ri' chuya'ik tijonik chke, xub'ij: ");
INSERT INTO qucNNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","We k'o jun chech alaq ri k'o jun ciento ru chij, kätzaq k'u jun chke, keuya na kan ri jumuch' b'elej lajuj pa taq ri juyub', ke' k'u chutzukuxik ri xtzaq kanoq k'ä kuriqa na wa', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Aretaq kuriqo, kuya na loq chrij u wi', käkikotik. ");
INSERT INTO qucNNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Aretaq kopan chik cho ja, keusik'ij na ri rachi'l xuquje' ru k'ul taq ja, kub'ij chke: “Chixkikot wuk', rumal chi xinriq ri nu chij ri xtzaq na kanoq,” —kächa na chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Je k'u ri' kinb'ij chiwe chi k'o na kikotemal chikaj rumal jun ajmak ri kuk'ex ranima', kuk'ex k'u u chomanik, chkiwäch ri jumuch' b'elej lajuj ri man kajwataj tä u k'exik kanima', —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","We k'o jun ixoq ri e k'o lajuj quetzales ruk', kätzaq k'u jun quetzal, ri ixoq kutzij na jun u candela, kumes na ri upaja, kärilij na u tzukuxik k'ä kuriq na ri puaq. ");
INSERT INTO qucNNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Aretaq kuriqo, keuch'ab'ej na ri rach taq ixoqib' xuquje' ri u k'ul taq ja, kub'ij chke: “Chixkikot wuk', rumal chi xinriq ri nu puaq ri xtzaqik,” —kächa na chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Je k'u ri' kinb'ij chiwe chi kekikot na ri ángeles re ri Dios aretaq jun ajmak kuk'ex ranima', kuk'ex k'u u chomanik, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ri Jesús xuquje' xutzijoj wa' chke: Jun achi e k'o kieb' u k'ojol. ");
INSERT INTO qucNNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ri ch'ut u k'ojol xub'ij che ru tat: “Tat, ya la ri kinwechb'ej in re ri q'inomal la,” —xcha che. Ri ki tat k'ut xujach ri jastaq re chkiwäch ri kieb' u k'ojol. ");
INSERT INTO qucNNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Xke' kieb' oxib' q'ij, ri ch'ut u k'ojol xumulij b'i konojel ri jastaq re, xe' naj pa jun tinimit chik. Chila' k'ut xaq xusachila wi il ri k'o ruk', xtzaq pa mak, man utz tä chik ru k'aslemal. ");
INSERT INTO qucNNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Aretaq ronojel u sachom chik, xpe jun nimalaj wi'jal pa ri tinimit ri'. Xuriq k'äx ri ala, sib'alaj xnumik. ");
INSERT INTO qucNNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Xe'k, xutzukuj u chak ruk' jun chke ri winaq re ri tinimit ri'. Xyi' k'u u chak. Xtaq b'i ri ala rumal ri achi che ki yuq'uxik ri aq pa ri juyub'. ");
INSERT INTO qucNNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Sib'alaj xurayij u tijik re ri rij taq pru't ri käkitij ri aq. Man k'o tä k'u jun winaq ri k'o jas kuya che. ");
INSERT INTO qucNNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Xul k'u ri ala pa saq, xub'ij: “E k'o k'ia ri ajchakib' cho rachoch ri nu tat ri sib'alaj k'o ri ki wa. Ri in k'ut kinkäm waral rumal ri wi'jal. ");
INSERT INTO qucNNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Kinwalijik, kine' na ruk' ri nu tat, kinb'ij na che: Tat, ri in, in makuninaq chuwäch ri Dios, xuquje' chuwäch la, tat. ");
INSERT INTO qucNNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ri in, man ya'tal tä chwe chi käb'an chi na la k'ojol la chwe. B'ana b'a' la chi kinok che jun ajchak la,” —kincha na che, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Xwalijik, xe' k'u ruk' ru tat. Tajin käb'inik, naqaj chik k'o wi che ri rachoch. Ru tat xril apan chinaj. Xel ranima' ru tat che. Xutik anim, xe'k, xuq'aluj ri ala, xuquje' xutz'umaj. ");
INSERT INTO qucNNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Xub'ij k'u ru k'ojol che: “Tat, ri in, in makuninaq chuwäch ri Dios, xuquje' chuwäch la, tat. Man ya'tal tä chik chwe in chi käb'an la k'ojol la chwe,” —xcha che ru tat. ");
INSERT INTO qucNNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Xub'ij k'u ru tat chke taq ri patänil re: “Chiwesaxtaj loq ri atz'iaq ri más utz na, chikojo che, chikojo xuquje' jun mulq'ab' che ru q'ab', xuquje' xajäb' chke ri raqan. ");
INSERT INTO qucNNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Jik'ama loq xuquje' ri alaj ama' wakäx ri sib'alaj chom, chipila b'a',” —xcha chke. “¡Chujwoq, qab'ana nimaq'ij! ");
INSERT INTO qucNNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Rumal chi we nu k'ojol ri' je' ta ne chi xkämik, xk'astaj k'u loq jumul chik. Xtzaq na, xriqtaj k'ut,” —xcha ri tata' chke. Xkichaplej k'u kikotem. ");
INSERT INTO qucNNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ri u k'ojol nab'eal ri tata' b'enaq pa juyub'. Tzelejem re cho ja, xnaqajin k'u che ri rachoch, xuta ri q'ojom xuquje' ri xojowem. ");
INSERT INTO qucNNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Xusik'ij k'u jun patänil re ru tat, xuta' che: “¿Jas wa' ri kinto?” —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Xub'ij k'u ri patäninel che: “Ulinaq ri chaq' la. Ri tat la xtaqan k'u chupilik ri alaj ama' wakäx ri sib'alaj chom, rumal chi ulinaq ri ala utz u wäch,” —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Te k'u ri' sib'alaj xpe royowal ri nab'eal, man xraj taj kok b'ik pa ri ja. Xel k'u loq ru tat chub'ochi'xik. ");
INSERT INTO qucNNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ri nab'eal xch'awik, xub'ij che ru tat: “Qas k'ia junab' in patäninaq che la. Ronojel q'ij nu nimam jas ri käb'ij la chwe. Man k'o tä k'u jumul ri yo'm la xa ta ne jun alaj k'isik' chwe in rech kinb'an nimaq'ij kuk' ri wachi'l,” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","“Aretaq xul we k'ojol la ri', ri xusachila ri jastaq e la kuk' ixoqib' re b'e, xkämisaj la ri alaj ama' wakäx ri sib'alaj chom chub'anik nimaq'ij che,” —xcha che ru tat. ");
INSERT INTO qucNNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Xub'ij k'u ru tat che: “Nu k'ojol, ri at ronojel q'ij at k'o wuk' in, konojel k'u ri jastaq we xuquje' awech at wa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Rajwaxik u b'anik nimaq'ij, xuquje' kujkikotik rumal chi we a chaq' ri' je' ta ne käminaq chik, xk'astaj k'u loq jumul chik. Xtzaq na wa', xriqtaj k'ut,” —xcha che ru k'ojol, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Xuquje' xutzijoj wa' ri Jesús chke ru tijoxelab': K'o jun q'inom achi, ri k'o jun u mayordomo. Xb'ix k'u che ri q'inom chi ri u mayordomo tajin keuk'is b'i ri jastaq re. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ri q'inom achi xusik'ij ri tata' mayordomo, xub'ij che: “¿Jas wa' ri nu tom chawij? Chab'ana kuenta che ri a patäninik chnuwäch. Man kuya' tä chi k'ut katk'oji wuk' che ri nu mayordomo,” —xcha ri tata' che. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Xuchomaj k'u ri mayordomo pa ranima', xub'ij: “¿Jas ta k'u ne kinb'ano?” —kächa'. “Man kraj tä chi ri nu patrón chi kinchakun na ruk'. Man k'o tä k'u nu chuq'ab' chub'anik taji'n. Kink'ix k'ut che ri molonik,” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","“Kinchomaj na ri kinb'ano rech kinkik'ulaj na ri winaq pa taq kachoch aretaq kesax ri nu chak chwe,” —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ri mayordomo xeusik'ij ri rajk'asib' ri rajaw chkijujunal. Xub'ij che ri nab'e ajk'as: “¿Joropa' ri k'as la ruk' ri nu patrón?” —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Xub'ij ri ajk'as che: “Are jun ciento toneles aceite nu k'as,” —xcha'. Xub'ij k'u ri mayordomo che: “Waral k'o wi ru wujil ri k'as la. T'uyul b'a la chanim ri', tz'ib'aj la nik'iaj ciento,” —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Te ri' xub'ij ri mayordomo che jun ajk'as chik: “Ri lal, ¿joropa ri' ri k'as la?” —xcha che. Xch'aw ri ajk'as, xub'ij che: “Wajxaqib' quintales triko ri nu k'as,” —xcha'. Xub'ij ri mayordomo che: “Waral k'o wi ru wujil ri k'as la. Tz'ib'aj la waqib' ruk' ri nik'iaj,” —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ri u patrón ri mayordomo xub'ij chi sib'alaj k'o u no'j ri mayordomo ri man utz taj rumal chi xna'w chub'anik ronojel wa'. Are k'u ri winaq ajuwächulew, ri man e kojonelab' taj, k'o na ketam chkij taq wa' we jastaq ri' chkiwäch ri kojonelab' ri k'o ri u saqil re ru Loq' Pixab' ri Dios pa kanima', —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Kinb'ij in chiwe: Chikojo b'a' ri i rajil ri ajuwächulew rech e k'o na iwachi'l. Aretaq käk'is ri i rajil, kixk'ulax pa taq jeqilib'al ri man kek'istaj tä ri', —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Apachin jun winaq ri jikom ranima' chub'anik ri man nim tä u b'anik, xuquje' are jikom ranima' chub'anik ri nim na u b'anik. Apachin ri man jikom tä ranima' chub'anik ri man nim tä u b'anik, man jikom tä k'u ri' chub'anik ri nim u b'anik, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","We ri ix man jikom tä iwanima' ix chukojik ri q'inomal ajuwächulew, ¿jachin ta lo ri käyo'w ri qas q'inomal ajchikaj chiwe? Man k'o taj, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","We ri ix man jikom tä iwanima' ix chrij ri rech jun winaq chik, ¿jachin ta lo käyo'w chiwe ri qas iwe ix? Man k'o taj, —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Xub'ij xuquje': Man k'o tä jun patäninel ri käkowin che ki patänixik kieb' u patrón, —kächa'. Käretzelaj na u wäch ri jun, loq' k'u na käril na ri' ri jun chik. Utz kub'an na che ri jun u patrón, man nim tä k'u käril wi ri jun chik, —kächa'. Man kixkowin taj kipatänij ri Dios we b'enaq iwanima' ruk' ri puaq, —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Xkita k'u ronojel wa' ri tata'ib' fariseos ri sib'alaj loq' käkil wi ri ki rajil. Xketze'j k'u u wäch ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Xub'ij k'u ri Jesús chke: Ri alaq käq'alajisaj ib' alaq chkiwäch ri winaq chi jikom anima' alaq. Are k'u ri Dios retam jas k'o pa anima' alaq, —kächa'. Ri sib'alaj nim kil wi kumal ri winaq, are xab'ib'al wa' cho ri Dios, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Xub'ij xuquje': Taqal chke ri winaq chi keniman che ri ojer Pixab' rech ri qa mam Moisés xuquje' chke ri ki tijonik ri q'alajisal taq re ru Loq' Pixab' ri Dios k'ä mäja' xul ri tat Juan Qasal Ja'. Kämik k'ut ri xul ri tat Juan, xchaplex u tzijoxik ri Utzalaj Tzij re ri Evangelio chrij ru taqanik ri Dios pa ki wi' ri winaq. Konojel ri winaq tajin käkitij ki chuq'ab' rech keb'okik. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Man k'äx tä ru sachik ki wäch ri kajulew chuwäch ri u sachik jun tzij re ru Loq' Pixab' ri Dios rumal chi tzrajwaxik wi chi käb'antaj na ronojel ri kub'ij ru Loq' Pixab' ri Dios, —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ronojel achi ri kujach b'i ri rixoqil, kuk'ama chi na jun ixoq chik, kub'an ri nimalaj mak ri äwas u b'anik cho ri Dios xuquje' chrij ri rixoqil. Xuquje' ri achi ri kuk'am jun ixoq ri jachom b'ik rumal ri rachajil kub'an ri' ri nimalaj mak ri äwas u b'anik cho ri Dios xuquje' chrij ri nab'e rixoqil, —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Xk'oji jun achi ri sib'alaj q'inom, ri kukoj je'lalaj taq atz'iaq ri sib'alaj paqalik. Ronojel q'ij k'ut xub'an k'ok'alaj taq wi'm ri sib'alaj nimaq, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","K'o k'u jun winaq meb'a', tat Lázaro u b'i', q'oyol chuchi' ri rachoch ri q'inom. K'o k'u k'ia ri itzel taq ch'a'k che. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ri meb'a' kurayij u tijik ri ch'äqataq wa ri ketzaq chuxe' ru mesa ri q'inom. Kenaqajin k'u ri tz'i' ruk' ri tat Lázaro, kekiriq' ri u ch'a'k, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Xkäm k'u ri meb'a' tata'. Ri ángeles xkik'am b'ik, xkiya kan ruk' ri qa mam Abraham. Xkäm xuquje' ri q'inom achi, xmuq k'ut, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","K'o k'u ri q'inom pa ri k'olib'al ri keb'e' wi ri kanima' ri winaq aretaq kekämik. Sib'alaj k'äx tajin kuriqo. Xka'y apanoq, xril ri qa mam Abraham chinaj, xuquje' chi ri tat Lázaro k'o ruk'. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ko xch'awik, xusik'ij, xub'ij: “Tat Abraham,” —kächa'. “Toq'ob'isaj la nu wäch, taqa la loq ri tat Lázaro, kurub' k'u u q'ab' pa joron rech käpetik, kuya jub'iq' chwe rech kinjororik. Xa kinel ch'uj pa we q'aq' ri',” —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Xub'ij k'u ri qa mam Abraham: “Tat, chna'taj chawe chi xariq ri utzalaj taq jastaq at pa ri a k'aslemal cho ruwächulew. Are k'u ri tat Lázaro, man k'o tä utzil xuriqo. Kämik k'ut are ku'b'isam ranima' wuk' in waral, ri at k'ut, at k'o pa k'äxk'ol,” —kächa che. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","“Kojom k'u jun nimalaj siwan chqaxol rech ri käkaj keq'ax b'i awuk' man kekowin tä che. Ri ajchila' k'ut ri e k'o awuk', man kekowin taj keq'ax loq quk',” —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Xub'ij ri q'inom tata' che ri tat Abraham: “Kinb'ochi'n b'a' che la, tat Abraham, chi kätaq la b'ik ri tat Lázaro cho rachoch ri nu tat. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","E k'o job' ri wachalal chila',” —kächa'. “Kwaj chi ri tat Lázaro kutzijoj wa' we k'äxk'ol ri' chke rech man kepe tä waral ri sib'alaj käkiriq wi k'äx,” —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Xub'ij k'u ri qa mam Abraham: “K'o ri tz'ib'am kan rumal ri qa mam Moisés, xuquje' ri tz'ib'am kumal ri ojer taq q'alajisal re ru Loq' Pixab' ri Dios. K'o ke ri wuj ri'. Chkitijoj kib' chkij,” —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Xub'ij k'u ri q'inom: “¡Qas tzij, tat Abraham! Man kekojon tä k'u chke. We ta k'u k'o jun käminaq ri käk'astajik, ri ke' kuk', käkik'ex na ri' ri kanima', käkik'ex ri ki chomanik,” —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Xub'ij ri mam Abraham che: “We man käkinimaj tä ri qa mam Moisés xuquje' ri ojer taq q'alajisal re ru Loq' Pixab' ri Dios, man kekojon tä na ri' pune che jun winaq ri käk'astaj b'i chkixol ri käminaqib',” —xcha ri qa mam Abraham che, —xcha ri Jesús chke ri tata'ib' fariseos. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Xub'ij ri Jesús chke ru tijoxelab': Tzk'o wi jachike ri kub'ano chi jun winaq chik kuriq ri b'e ri man utz taj, kätaqchi'x k'u che mak. ¡K'äx re ri winaq ri' ri rumal rech käb'antaj wa'! —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Are utz na we ta käxim jun ka' re molino chuqul ri winaq ri', käk'iäq ta k'u b'i pa ri mar, ¡utz k'u na ri' chuwäch ru b'anik chi jun chke we alaj taq ch'utiq ri' kuriq ri b'e ri man utz taj! ");
INSERT INTO qucNNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Chiwila b'a' iwib', —xcha chke. Xub'ij k'ut: We kämakun ri awachalal, kub'an jun k'äx chawe, chapixb'aj wa'. We kuk'ex ranima', kuk'ex k'u u chomanik, chasacha ru mak, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","We kämakun chawij wuqub' mul pa jun q'ij, kätzelej k'u awuk', kub'ij: “Man kinb'an tä chik,” —kächa'. Rajwaxik k'ut chi ri at kasach ru mak, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Xkib'ij ri apóstoles che ri Qajaw Jesús: B'ana b'a' la chqe chi sib'alaj kujkojon na, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Xub'ij ri Qajaw Jesús chke: We ta kixkojonik xa ta ne jub'iq' je' jas ru nimal jun alaj ija' re mostaza, kuya' kib'ij na ri' che we che' sicómoro ri': “Chab'oqo' awib', chatika awib' pa ri mar,” —kixcha che. Käniman k'u na wa' we che' ri' chiwe, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","We k'o jun chiwe ri k'o jun patänil re ri kub'an taji'n, we ne ke' pa yuq', aretaq k'ut kätzelej loq iwuk' cho ja, ¿jas kib'ano? ¿A k'o lo jun chiwe ri kub'ij na che ri ajchak: “Tasa'j chanim, chatt'uyul chi' ri mesa, chatwoq”? —kixcha che, —kächa ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Man je' taj. Xane kib'ij ri' che ri patäninel: “Chab'ana ri kintijo. Chasuk'umaj awib', chaya ri nu wa rech kinwi'k. Te ri' kuya' katwi' at,” —kixcha che, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿A k'o maltioxinik ri' che ri patäninel rumal chi xub'an ri xtaq wi? Man k'o taj, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Je ri' ri ix xuquje', aretaq i b'anom chik ronojel ri ix taqom wi, chib'ij na chb'il iwib': “Ri uj, uj patäninelab' ri man k'o tä qa patän, rumal chi xqa'n xaq xuwi ri' ri tzrajwaxik u b'anik,” —kixcha na, —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","B'enaq k'u ri Jesús pa Jerusalén, ok'owem kub'an chkixol ri Galilea ruk' ri Samaria. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Aretaq xopan pa jun alaj tinimit, xriqtaj ri Jesús kumal lajuj achijab' ri k'o itzel taq ch'a'k chkij. Xetak'i k'u chinaj. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ko xech'awik, xkib'ij: ¡Tat Jesús! ¡Ajtij! ¡Toq'ob'isaj la qa wäch! —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Xerilo, xub'ij chke: Jik'utu iwib' chkiwäch ri tata'ib' sacerdotes, —xcha chke. Pa ri ki b'ik k'ut, are chi' xekunaxik. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Aretaq jun chke xrilo chi kunam chik, xtzelejik, ko xch'awik, xunimarisaj u q'ij ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Xuxuk rib' cho ri Jesús, sib'alaj xmaltioxin che. Aj Samaria k'ut we achi ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Xub'ij k'u ri Jesús: ¿A mat ne e lajuj ri xekunaxik? E k'u ri b'elejeb', ¿jawije' e k'o wi? —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Xaq xuwi wa' we achi ri' ri man qa winaqil taj xtzelej loq, kunimarisaj k'u u q'ij ri Dios, —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Xub'ij ri Jesús che: Chatwalijoq, kuya' kate'k. At kunam chik rumal chi xatkojonik, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Aretaq ri tata'ib' fariseos xkita' che ri Jesús jampa' käpe ru taqanik ri Dios cho ruwächulew, xub'ij ri Jesús chke: Ri u petik ru taqanik ri Dios cho ruwächulew man kilitaj tä ri', —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Man käb'ix tä na che: “Chawilampe', k'o chi ri'. Jawilampe', k'o chila',” —kächa'. Man je' taj rumal chi ya ulinaq chi ri Dios iwuk' che taqanik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Xub'ij k'u ri Jesús chke ru tijoxelab': Kopan na ri q'ij ri sib'alaj kirayij chi ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, k'o iwuk', man in k'o tä chik, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ri winaq käkib'ij na chiwe: “Chiwilampe', k'o chi ri'. Jiwilampe', k'o chila',” —kecha na. Mixe' k'ut, mixteri b'i kuk', —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Je' jas ri kaypa' kusaqirisaxtaj ronojel ri kaj, q'alaj wa' chkiwäch konojel ri winaq, je ri' xuquje' ri q'ij aretaq ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, kinpetik, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Rajwaxik k'ut chi nab'e sib'alaj kinriq na k'äx, ketzelax na nu wäch kumal ri winaq re we q'ij junab' ri', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Jas ri xka'n ri winaq ojer pa ru q'ij ri qa mam Noé, je ri' xuquje' käb'antaj na pa taq ri q'ij ri kintzelej loq, in ri' ri Ralk'ual ri Dios ri Qas Winaq. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Xewi' ri winaq, xka'n nimaq'ij, xek'uli'k, xkiya k'u ri kalk'ual pa taq k'ulanem k'ä pa ri q'ij ri xok b'ik ri qa mam Noé pa ri nimalaj barco. Xpe k'u ri nimalaj q'eqal jäb', xusach k'u ki wäch konojel, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Je ri' xuquje' jas ri xka'n ri winaq ojer pa ru q'ij ri qa mam Lot, xewi' ri winaq, xka'n nimaq'ij, xeloq'omanik, xek'iyinik, xetiko'nik, xkiyak taq kachoch. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pa ri q'ij ri xel b'ik ri qa mam Lot pa ri tinimit Sodoma, xqaj loq q'aq' ruk' q'ol chikaj, xusach k'u ki wäch konojel ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Je' käb'an na wa' pa ri q'ij ri käq'alajin na jachin ri' ri Ralk'ual ri Dios ri Qas Winaq, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Pa ri q'ij ri', ri winaq ri k'o puwi' ri ja, mok chi b'ik che ki k'amik b'i ri jastaq re ri e k'o kan chupam ri ja. Xuquje' ne ri k'o pa juyub' mätzelej chi na cho ja, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Chna'taj ri rixoqil ri mam Lot chiwe. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ri kutzukuj u chajixik rib', kutzaq na ronojel, käkäm k'u na wa'. Apachin k'u ri kutzaq ru k'aslemal, käto'taj na wa', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Qas tzij kinb'ij chiwe chi pa ri aq'ab' ri', kek'oji na kieb' pa jun ch'at. Jun chke käk'am na b'ik, ri jun chik käyi' na kanoq. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Kek'oji na kieb' ixoqib' ri tajin kekie'n junam. Jun chke käk'am na b'ik, ri jun chik käyi' na kanoq. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Kek'oji na kieb' achijab' kachi'l kib' pa taq juyub'. Jun chke käk'am na b'ik, ri jun chik käyi' na kanoq, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Xkib'ij k'u che ri Jesús: ¿Jawije' käb'an wi wa', Qajaw? —xecha che. Xch'aw chi ri Jesús, xub'ij: Ri käk'oji wi na ri ki b'aqil ri käminaqib', chila' k'ut käkimulij wi na kib' ri k'uch, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ri Jesús xutzijoj chi na jun k'utb'al chuya'ik tijonik chke ru tijoxelab' chuk'utik chkiwäch chi rajwaxik u b'anik orar amaq'el ronojel q'ij, mäk'istaj k'u ki k'ux. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Xub'ij k'u chke: Pa jun tinimit k'o wi jun q'atal tzij ri man kuxej tä rib' cho ri Dios, man nim tä k'u keril wi ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Xuquje' k'o jun chichu' malka'n pa ri tinimit ri', ri amaq'el kopan ruk', kutz'onoj che: Chinto' la pu q'ab' ri nu k'ulel, —kächa che. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Xke' k'ia ri q'ij ri q'atal tzij man kraj taj kuto' ri chichu'. Te k'u ri' xchoman pa ranima', xub'ij: “Pune man kinxej tä wib' cho ri Dios, man nim tä k'u kinwil wi jun winaq, ");
INSERT INTO qucNNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","kinto' na we chichu' malka'n ri' rumal chi sib'alaj kuya latz' chwe. We man kinb'an q'atow tzij puwi' ruk' jikomal, käpe na ri chichu' amaq'el ronojel q'ij, sib'alaj kinukos na,” —xcha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Xub'ij k'u ri Qajaw Jesús: Chitatab'ej b'a' jas ri xub'ij ri q'atal tzij ri man jikom tä ranima', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿A mat ri Dios kub'an na q'atow tzij ruk' jikomal pa ki wi' ri winaq ri xeucha' che ki to'ik, ri keb'ochi'n che chi paq'ij chi chaq'ab'? ¿A mat chanim keuto' na wa'? —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Je', kinb'ij chiwe chi chanim kätob'an na chke, —kächa'. Aretaq k'ut ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, kintzelej na loq, ¿a keinriq ne lo winaq ri qas kekojon chwe? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Xutzijoj k'u we k'utb'al rech tijonik ri' chke jujun winaq ri kechoman chkij chb'il kib' chi sib'alaj e utz na, ri käketzelaj k'u ki wäch ri jule' chik. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Xub'ij chke: E k'o kieb' achijab'. Jun chke are jun tata' fariseo. Ri jun chik are toq'il alkab'al. Xeb'ok k'u b'i pa ri nimalaj rachoch Dios rech käka'n orar. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Tak'al k'u ri fariseo, xub'an orar chb'il rib', xub'ij: “O Dios, maltiox che la chi ri in man in tä junam kuk' ri nik'iaj winaq chik, ri elaq'omab', ri winaq ri man käkib'ij tä jikomal tzij, ri käka'n nimalaj mak, man in junam tä k'u ruk' we jun toq'il alkab'al ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ri in kinb'an ayunar kamul ronojel semana. Kinya k'u ru lajujil joropa' ri kinriqo,” —xcha ri tata' fariseo. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Are k'u ri toq'il alkab'al, tak'al chinaj, man kraj tä k'u käka'y chikaj, xane kut'ok u wo u k'ux chuk'utik chi käb'isonik, kub'ij: “¡Ay, Dios! We ne käpax k'ux la chwe in, in wa' sib'alaj in ajmak,” —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Qas tzij kinb'ij chiwe chi we achi ri' xe' cho rachoch jikom chik ri ranima' cho ri Dios. Man je' tä k'u ri jun chik, ri tata' fariseo. Are k'u ri winaq ri kunimarisaj rib' cho ri Dios, käqasax na u q'ij. Apachin k'u ri kub'an che chb'il rib' chi man nim tä u b'anik, känimarisax na u q'ij wa', —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Xek'am k'u b'i ri ak'alab' cho ri Jesús rech kuya ru q'ab' pa ki wi'. Ru tijoxelab' xkilo, xekiyaj ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ri Jesús xeusik'ij ru tijoxelab', xub'ij chke: Chiya chke ri ak'alab' chi kepe wuk', meiq'atej, —kächa'. Xaq xuwi chke ri winaq ri e je' jas ri ak'alab' ri' käyi' wi chi kätaqan ri Dios pa ki wi'. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Qas tzij ri kinb'ij chiwe chi ri winaq ri man käkina' tä pa kanima' chi ri e are' je' ta ne ak'alab' cho ri Dios, man käkik'ulaj tä k'u ru taqanik ri Dios, man käyi' tä chke chi keb'okik, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","K'o k'u jun chke ri ki nimaqil ri winaq xuta' che ri Jesús, xub'ij: Utzalaj Ajtij, ¿jas kinb'an in rech kinriq ri k'aslemal ri man käk'istaj taj? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Xub'ij k'u ri Jesús: ¿Jas che kab'ij utz chwe? Man k'o tä jun ri qas utz, xane xaq xuwi ri Dios, —kächa ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Awetam k'u ru Loq' Pixab' ri Dios ri kub'ij: “Matkämisanik, mab'an ri nimalaj mak ri äwas u b'anik ruk' ri rixoqil jun winaq chik, mab'an elaq', mab'an tzij chrij jun winaq chik, nim cheawila wi ra tat, ra nan,” —kächa ri Pixab', —xcha ri Jesús che. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Xub'ij ri achi che ri Jesús: Ronojel wa' nu nimam tzpa ri wak'alal, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Xuta wa' ri Jesús, xub'ij che: K'o na ri mäja' kab'ano. Jak'iyij konojel ri jastaq awe, chaya ri rajil chke ri meb'a'ib'. Käk'oji k'u na ra q'inomal chila' chikaj, —kächa'. Te k'u ri' kuya' katteri wuk'. Jo' b'a', —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Aretaq ri achi xuta wa', sib'alaj xk'extaj ru wäch pa b'is, xk'äxk'ob' ri ranima' rumal chi sib'alaj nim ru q'inomal k'olik. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ri Jesús xrilo chi sib'alaj käb'isonik, xub'ij: ¡Sib'alaj k'äx ri keb'okik ri q'inomab' ruk' ri Dios rech kätaqan pa ki wi'! —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Are man k'äx taj ri rok'owisaxik jun kiej camello pa ri u julil jun t'isomb'al b'aq chuwäch ri rokik jun winaq q'inom ruk' ri Dios rech kätaqan puwi', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ri winaq ri xetowik xkib'ij che ri Jesús: We je ri', ¿jachin ta k'u lo ri käkowin churiqik ru tob'anik ri Dios? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Xub'ij k'u ri Jesús chke: Ri man kekowin tä ri winaq chub'anik, are k'u wa' käkowin ri Dios che, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Xub'ij ri tat Pedro: Qajaw, chilampe la chi ri uj qa yo'm kan ri jastaq qe rech kujk'oji uk' la, —xcha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ri Jesús xub'ij che: Qas tzij ri kinb'ij chiwe chi we k'o jun winaq ri u yo'm kan ri rachoch, ri rixoqil, ri rachalal, ru tat, u nan, ri ralk'ual rech kinuto' chutzijoxik ru taqanik ri Dios, ");
INSERT INTO qucNNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kuriq na k'ia chuwäch wa' pa taq we q'ij junab' ri'. Kuriq k'u na ri k'aslemal ri man k'o tä u k'isik pa taq ri junab' ri kepe na, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ri Jesús xeuk'am b'i ri kab'lajuj u taqo'n pa ki tukiel wi, xub'ij k'u chke: Kujpaqi na b'ik, kuje' na pa ri tinimit Jerusalén. Ronojel k'u ri tz'ib'am kan kumal ri ojer taq q'alajisal re ru Loq' Pixab' ri Dios chwij in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, käb'antaj na wa' chwe, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kinkijach k'u na b'ik pa ki q'ab' ri nik'iaj winaq chik. Käketz'b'ej na nu wäch, kinkiyoq' na, xuquje' käkichub'aj na nu palaj. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Kinkirapuj na, te k'u ri' kinkikämisaj. Churox q'ij k'ut kink'astaj na chkixol ri käminaqib', —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ri tijoxelab' man k'o tä k'u jun chke ri kuch'ob' ri u tzij ri Jesús. Xb'an k'u chke chi man keq'alajin tä wa' we tzij ri' chkiwäch. Are k'u ri xb'ix chke man kuya' taj käkich'ob'o. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","B'enam re ri Jesús, tajin känaqajin che ri tinimit Jericó. K'o k'u jun moy achi t'uyul chuchi' ri b'e ri tajin kämolonik. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Aretaq xuto chi k'ia winaq tajin keok'owik, xuta' jas tajin käb'anik, xub'ij: ¿Jas ri'? —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Xkib'ij che: Are ri tat Jesús aj Nazaret ri tajin kok'owik, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ko xch'aw ri moy achi, xub'ij: ¡Tat Jesús! —kächa'. ¡Lal ri' ralk'ual kan ri qa mam David, toq'ob'isaj la nu wäch! —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ri winaq ri e tak'atoj chuwäch xeyajon che, xkib'ij chi mäch'aw chik. Ri are' k'ut ko na xuraq u chi', xub'ij: ¡Tat, ri lal ralk'ual kan ri qa mam David, toq'ob'isaj la nu wäch! —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Xtak'i k'u ri Jesús, xtaqan chuk'amik loq ri tata' ruk'. Aretaq ri moy achi k'o chi ruk' ri Jesús, xub'ij ri Are' che: ");
INSERT INTO qucNNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","¿Jas kaj la chi kinb'an che la? —xcha che. Xub'ij k'u ri moy achi: Tat, kwaj kinka'y chik, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Xub'ij k'u ri Jesús che: ¡Ka'y b'a' la! —kächa che. Rumal chi käkojon la, xkunataj la kanoq, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Chanim k'ut ri moy achi xka'yik, xteri b'i chrij ri Jesús, kunimarisaj u q'ij ri Dios. Xuquje' konojel ri winaq xkinimarisaj u q'ij ri Dios aretaq xkilo ri xb'an che ri moy achi. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Opaninaq chi k'u ri Jesús pa Jericó, ok'owem tajin kub'an chupam ri tinimit. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","K'o jun achi, Zaqueo u b'i', jun chke ri ki nimaqil ri toq'il taq alkab'al. Q'inom k'u wa' we achi ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Xutzukuj rilik u wäch ri Jesús che retamaxik jachin ri'. Man käkowin tä k'ut rumal chi e k'ia ri winaq, xaq k'u ko'l raqan ri tat Zaqueo. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Xutik anim, xnab'ej b'i chkiwäch ri winaq, xpaqi k'u puwi' jun che' sicómoro che rilik ri Jesús, rumal chi chila' kok'ow wi na ri are'. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Xopan k'u ri Jesús pa ri k'olib'al ri', xka'y aq'an ajsik, xril ri tat Zaqueo, xub'ij che: Chanej la, qaj la loq. Rajwaxik chi kämik kinkanaj kan cho achoch la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Te k'u ri' xqaj loq ri tat Zaqueo puwi' ri che'. Xuk'ulaj ri Jesús, sib'alaj xkikotik. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Xilitaj k'u wa' kumal konojel ri winaq, xewixwitik, xkib'ij: Ula'm ri tat Jesús rumal jun achi sib'alaj ajmak, xe' k'u ruk', —xecha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Xtak'i k'u ri tat Zaqueo, xub'ij che ri Jesús: Tampe la ri kinb'ano. Pa nik'iaj ri jastaq we kinya na chke ri meb'a'ib'. Xuquje' we k'o jas nu q'ipom chrij jun winaq, kinkajmulij na u tzelexik wa' che, —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Xub'ij ri Jesús che: Kämik xriq la ru tob'anik ri Dios, xuquje' ri winaq ri e k'o cho achoch la, rumal chi käq'alajinik chi lal ri' are qas rachalal ri qa mam Abraham, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, in petinaq che ki tzukuxik ri winaq ri e tzaqinaq, xuquje' che ki to'ik, —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ri winaq ki tatab'em we tzij ri', ri Jesús xuchaplej u tzijoxik jun k'utb'al chik re tijonik chke rumal chi kenaqajin chik che ri tinimit Jerusalén. Xkichomaj ri winaq chi ri Dios kuk'ut na rib' chkiwäch chanim, kuchaplej k'u taqanik pa ki wi'. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Xub'ij k'u ri Jesús chke: K'o jun achi, nim u b'anik, ri xe' naj pa jun tinimit chik rech kok che nim taqanel pa ki wi' ri winaq re ri tinimit ri'. Kuchomaj ri tata' chi aretaq käto'taj chila', kätzelej chi na loq cho ja. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ri achi k'ut xeusik'ij lajuj chke ri patänil re, xeuya juwinaq quetzales chke chkijujunal. Xub'ij k'u chke: “Chikojo wa' we puaq ri' rech k'o kich'ak na chrij. Chib'ana wa' k'ä kopan na ri q'ij ri kintzelej loq,” —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Are k'u ri winaq re ri tinimit ri ke' wi, sib'alaj käketzelaj u wäch, xekitaq k'u b'i nimaq tata'ib' chrij chub'ixik: “Man käqaj tä wa' we achi ri' che nim taqanel pa qa wi',” —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pune je ri' xok k'u na che nim taqanel. Aretaq xtzelej loq cho ja, xtaqanik chi kesik'ix loq ri patäninel taq re, ri xek'amow ri puaq, rech käretamaj na jas ri ki ch'akom chkijujunal. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Xopan k'u ri nab'e patänil re ruk', xub'ij: “Tat, ri rajil la xuch'ak chi lajuj mul je' jas ri xya la chwe,” —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Xub'ij k'u ru patrón che: “Utz a b'anom, utzalaj patänil we,” —kächa'. “Katinkoj na che taqanel pa ki wi' lajuj tinimit rumal chi utz a b'anom at chrij ri jun alaj chak,” —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Xopan k'u rukab' patänil re, xub'ij che: “Tat, ri rajil la u ch'akom chi job' mul je' jas ri yo'm la chwe,” —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Xub'ij k'u ru patrón che: “Ri at k'ut katkoj na che taqanel pa ki wi' job' tinimit,” —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Xopan chi k'u jun chik patänil re, xub'ij: “Tat, ri' ri rajil la ri k'o wuk', nu k'olom k'u wa' pa jun su't,” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","“Je' nu b'anom wa' rumal chi kinxej wib' chuwäch la. Ri lal k'ut sib'alaj k'a'n la. Käk'am la ri man ech tä la, käq'at k'u la ri man tikom tä la,” —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Xub'ij k'u ri nim taqanel che: “¡Ay, patänil we ri sib'alaj man utz taj! Kinq'at na tzij pa wi' ruk' ri tzij ri a b'im chwe. Awetam k'ut chi ri in sib'alaj in k'a'n, chi kink'am ri man wech taj, kinq'at k'u ri man nu tikom taj,” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","“¿Jas che man xaya tä ri nu rajil ruk' jun winaq ri käyo'w pa jalomal rech kintoq'ij ruk' ral aretaq kinulik?” —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Xub'ij k'u chke ri e tak'atoj chunaqaj: “Chiwesaj ri puaq ri k'o ruk', chiya che ri patänil we ri k'o ri lajuj cientos quetzales ruk',” —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Xkib'ij k'u che: “Tat, ya k'o chik lajuj cientos quetzales ruk',” —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Xub'ij k'u chke: “Kinb'ij chiwe chi ronojel jachin ri k'o k'o ruk', käyataj na más che. Apachin k'u ri man k'o tä k'o ruk', kesax na che ri jub'iq' ri k'olik,” —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","“Are k'u ri nu k'ulel, ri man xkaj taj chi kintaqan pa ki wi', chik'ama loq, chikämisaj wa' chnuwäch,” —xcha chke, —xcha ri Jesús chke ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Aretaq xb'itaj wa' rumal ri Jesús, xnab'ej chkiwäch, xutaqej ru b'e, xe' k'u pa ri tinimit Jerusalén. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Naqaj chi k'u e k'o wi che ri tinimit Betfagé, xuquje' ri tinimit Betania chuwäch ri juyub' u b'i'am Ujuyub'al Olivos, xeutaq b'ik kieb' chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Xub'ij k'u chke: Jix pa ri alaj tinimit ri k'o apan chqawäch. Aretaq ix opaninaq chi chila', kiriqa na jun burro yuqulik, ri man k'o tä jumul jun winaq kiejeninaq chrij. Chikira wa', chik'ama loq, —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","We k'o jun kuta' chiwe: ¿Jas che kikiro? —kächa ne. Je' kib'ij wa' che: Xa kajwataj wa' che ri Qajaw Jesús, —kixcha che, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Xeb'e' k'u ri tijoxelab' ri xeutaq b'ik, je' xekiriqa jas ri xub'ij ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tajin käkikir ri burro aretaq ri ajchaq'el xkita' chke, xkib'ij: ¿Jas che tajin kikir ri burro? —xecha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ri e are' xkib'ij: Xa kajwataj wa' che ri Qajaw Jesús, —xecha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Xkik'am k'u b'ik, xkiya k'u che ri Jesús. Xkikoj ri ki q'u' chrij, xkiya k'u ri Jesús chrij. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Kiejeninaq ri Jesús, tajin käb'inik. Xkilik' ri ki q'u' pa ri b'e. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Naqaj chi k'u e k'o wi che ri Jerusalén, xeopan pa ri xulanik re ri Ujuyub'al Olivos. Konojel ri k'ialaj taq u tijoxelab' xkichaplej kikotem, ko xech'awik, xkinimarisaj u q'ij ri Dios rumal konojel ri nimaq taq kajmab'al ri kilom. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Käkib'ij k'ut: ¡Tewchim b'a' ri Nim Taqanel ri petinaq pa ru b'i' ri Qajaw Dios! —kecha'. Kuxlan na qanima' rumal ri Dios chikaj. ¡Chnimarisax b'a' u q'ij ri Dios ajchikaj! —xecha ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Jujun chke ri tata'ib' fariseos ri e k'o chkixol ri k'ialaj winaq xkib'ij che ri Jesús: Ajtij, cheyaja la ri tijoxelab' la, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ri Jesús xch'awik, xub'ij chke: Qas tzij, we ta mat kech'aw wa' we winaq ri', are ko kech'aw na ri ab'aj, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Aretaq xenaqajin che ri tinimit, ri Jesús xoq' pa ki wi' ri winaq aj Jerusalén. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Xub'ij: Kwaj ta ne chi pa we q'ij ri' kiwetamaj jachin ri' ri käkowinik kuya utzil chixol. K'u'tal k'u wa' kämik chiwäch, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kepe k'u na ri q'ij chiwij aretaq ri k'ialaj i k'ulel käka'n na jun k'otom chrij ri tinimit, käkisutij na rij, sib'alaj k'u käkilatz'ob'isaj na wa', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Kekiwulij na kan ri iwachoch cho ulew, kixkikämisaj na. Man käkanaj tä k'u na kan jun ab'aj puwi' jun ab'aj chik, —kächa'. Are k'u rumal wa' chi man iwetam taj chi pa we q'ij ri' ri Dios xixusolij, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Xok k'u b'ik ri Jesús pa ri nimalaj rachoch Dios, xuchaplej kesaxik b'ik ri ajk'ayib', xuquje' ri loq'omanelab'. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Xub'ij k'u chke: Tz'ib'am k'ut pa ru Loq' Pixab' ri Dios: “Ri wachoch in are ja ri käb'an wi orar,” —kächa ri Tz'ib'talik. Ri alaq k'ut, kachoch elaq'omab' b'anom alaq che, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ronojel q'ij ri Jesús xuya tijonik pa ri nimalaj rachoch Dios. Are k'u ri ki nimaqil sacerdotes, ri tijonelab' re ri Pixab', xuquje' ri ki nimaqil ri winaq re ri tinimit xkitzukuj u kämisaxik. ");
INSERT INTO qucNNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Man xkiriq tä k'ut jas käka'n che, rumal chi konojel ri winaq ki jikib'am kanima' chutatab'exik ri kub'ij chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Pa jun q'ij ri Jesús tajin keutijoj ri winaq pa ri nimalaj rachoch Dios, tajin kutzijoj ri Utzalaj Tzij re ri Evangelio chke. Xeopan k'u ri ki nimaqil taq sacerdotes kuk' ri tijonelab' re ri Pixab' xuquje' ri ki nimaqil ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Xkib'ij k'u che: ¿Jachin xtaqow la chi ri lal käb'an la wa' we ri'? ¿Jachin lo ri yo'winaq taqanik pa q'ab' la chi je' käb'an la wa'? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Xch'aw ri Jesús, xub'ij chke: Ri in xuquje' k'o jas kinta' chech alaq, —kächa'. B'ij alaq chwe: ");
INSERT INTO qucNNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Jachin xtaqow ri tat Juan chub'anik qasna'? ¿A are ri Dios, o are ri winaq? ¿Jachin xyo'w che chi je' kub'an wa'? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Xkitzijob'ela kib', xkib'ij: We käqab'ij chi are ri Dios, ri are' kub'ij na chqe chi jas che man xqakoj tä wa', —kecha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","We k'u käqab'ij chi xa are ri winaq, konojel ri winaq kujka'n na che ab'aj. Elinaq k'u chi saq chkiwäch ri winaq chi ri tat Juan are q'alajisal re ru Loq' Pixab' ri Dios, —xecha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Xech'aw chik, xkib'ij che ri Jesús chi man käkich'ob' tä wa' chi jachin ri' ri xyo'w che ri tat Juan chi kub'an qasna'. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Xub'ij k'u ri Jesús chke: Xuquje' ri in man kinb'ij tä in chech alaq jachin ri yo'winaq chwe chi in kinb'an wa' we ri', —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ri Jesús xuchaplej u tzijoxik wa' we k'utb'al ri' re tijonik chke ri winaq: K'o jun achi ri xub'an jun tikb'al uvas. Xtikonijik, xuya k'u kan ri ulew pa qajomal chke jujun tajinelab'. Te k'u ri' xe' naj pa jun tinimit chik, naj xsachik. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Xopan k'u ri q'ij re ru yakik ri wächinik, xutaq b'i jun patänil re kuk' ri ajchakib' rech käkiya b'i nik'iaj re ri u wäch ri tikb'al uvas. Are k'u ri ajchakib' xkich'ayo, xkitaq b'ik, man k'o tä xkiya b'i che, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Xutaq k'u b'i jun u patäninel chik. Xuquje' wa' xkich'ayo, xketzelaj u wäch, xkitaq b'ik, man k'o tä xkiya b'i che, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Churox mul xutaq b'ik jun patänil re kuk'. Xkisok wa', xuquje' xkesaj b'i pa ri tikb'al uvas, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Te k'u ri' xuchomaj ri rajaw ri tikb'al uvas, xub'ij: “¿Jas ta k'u lo kinb'ano?” —kächa'. “Kintaq na b'ik ri loq'alaj nu k'ojol. Kraj ne nim käkil wi ri are' aretaq käkilo,” —xcha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ri ajchakib', aretaq xkilo, xkich'ab'ej kib', xkib'ij: “¡Chawilampe'! Are wa' ri kechb'en na ronojel,” —kecha'. “Chixsa'j, qakämisaj ri achi rech käqechb'ej na wa' we ulew ri',” —xecha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Xkesaj k'u b'i ru k'ojol ri ajchaq'el ri tikb'al uvas, xkikämisaj k'ut, —xcha ri Jesús chke. Te ri' xuta' ri Jesús chke, xub'ij: ¿Jas k'u kub'an na ri rajaw ri tikb'al uvas chke? —kächa ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Käpe na ri are', keukämisaj na ri ajchakib' ri', kuya na ri rulew chke jule' chik, —xcha ri Jesús chke. Aretaq xkita wa', xkib'ij ri winaq: ¡Ay, mäb'antaj wa'! —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Xka'y k'u ri Jesús chke, xub'ij: ¿Jas kel kub'ij wa' ri tz'ib'am kanoq pa ru Loq' Pixab' ri Dios? kub'ij: Ri ab'aj ri man xkaj tä ri yakal taq ja, we ab'aj ri' are xkoj che toq'eb'al re ri ja, —kächa ri Tz'ib'talik, —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ronojel winaq jachin ri kätzaq puwi' ri ab'aj ri', käsoktaj na. We k'u kätzaq we ab'aj ri' chrij jun, kuk'äjij na, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ri tijonelab' re ri Pixab' kuk' ri ki nimaqil sacerdotes aj Israel xkichaplej u tzukuxik jas käka'n chuchapik ri Jesús pa ri hora ri', xkixej k'u kib' chkiwäch ri winaq. Xkich'ob' k'ut chi ri k'utb'al ri', xtzijox wa' chkij ri e are'. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Xkaluchij ri Jesús, xekitaq b'i winaq chuyuxlexik. Ri winaq ri' xka'n che kib' chi e utzalaj taq winaq rech käkiriq jun tzij pu chi' ri Jesús rech käkijach b'i ri Are' pu q'ab' ri q'atal tzij, käq'at k'u na tzij puwi'. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Rumal wa' xkik'ot u chi' ri Jesús, xkib'ij: Ajtij, qetam chi utz wa' ri kätzijon la xuquje' ruk' jikomal kätzijon la. Qetam k'ut chi man nim tä kil la jun winaq chuwäch jun chik. Xane käk'ut la ri qas u rayinik ri Dios, —kecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿A rajwaxik käqatoj alkab'al che ri nimalaj taqanel aj Roma? We ne man rajwaxik taj, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Xretamaxtaj k'u ri Jesús ri ki chomanik, xub'ij chke: ¿Jas che käta' alaq wa' chwe? ");
INSERT INTO qucNNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","K'utu b'a' alaq jun puaq chnuwäch, —kächa chke. ¿Jachin k'u rech we ka'yeb'al ri' xuquje' ri b'i'aj ri' ri k'o chuwäch ri puaq? —xcha ri Jesús. Xech'aw chi na ri winaq, xkib'ij che: Are rech ri César ri nimalaj taqanel, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Xub'ij k'u ri Jesús chke: Ya alaq che ri tat César ri rech ri César. Ya b'a' alaq che ri Dios ri rech ri Dios, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Man k'o tä k'u jun tzij xekowin churiqik pu chi' ri Jesús ri xqaj ta wi pa ki q'ab' chkiwäch ri winaq. Xane xkikajmaj ri xub'ij ri Jesús chke, man xech'aw tä k'u chik. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Xeopan k'u jujun chke ri tata'ib' saduceos, ri käkib'ij chi man kek'astaj tä chi na ri käminaqib'. Ri tata'ib' ri' xkik'ot u chi' ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Xkib'ij che: Ajtij, tz'ib'am kan chqe rumal ri qa mam Moisés chi we käkäm jun achi, k'o k'u kan rixoqil, man e k'o tä k'u kan ralk'ual chrij are', rajwaxik chi ri rachalal ri käminaq käk'uli ruk' ri ixoq malka'n ri' rech kek'oji kan ralk'ual ruk'. Ri ak'alab' ri kil ki wäch je' ta ne e rech ri käminaq, —kecha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Xkib'ij k'ut: E k'o wuqub' achijab' kachalal kib'. Ri nab'eal xk'uli'k, xkäm k'ut, man xk'oji tä kan ralk'ual ruk' ri rixoqil. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ri ukab' xk'uli ruk' ri rixnam malka'n, xuquje' xkäm b'ik, man xk'oji tä kan ralk'ual ruk'. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ri urox xuquje' xk'uli ruk' ri malka'n. Je k'u ri' xka'n ri wuqub' achijab' chkijujunal, xekämik, man xek'oji tä kan kalk'ual. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","K'isb'al k'ut xkäm ri ixoq, —kecha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Aretaq k'ut kek'astaj chi ri käminaqib', ¿jachin lo chke ri wuqub' achijab' ri' käk'oji na che rachajil ri chichu'? Xok k'u che kixoqil ri wuqub', —xecha che ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Xch'aw chi ri Jesús, xub'ij chke: Ri winaq ajuwächulew kek'uli'k, käkiya ri kalk'ual pa k'ulanem. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ri winaq ri ya'tal chke chi kek'astaj b'ik chkixol ri käminaqib', xuquje' chi käk'oji ki k'aslemal ri man käk'is taj, man kek'uli tä chik, man keyi' tä k'u che k'ulanem, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","E junam chik jas ri ángeles. Man kekowin tä chik kekämik. E are k'u ralk'ual ri Dios wa', ri e k'astajinaq chik chkixol ri käminaqib', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ri qa mam Moisés xutzijoj chi ri käminaqib' kek'astaj na, —kächa'. Are wa' ri kuq'alajisaj ri tzij ri xutz'ib'aj chrij ri k'ix ri käk'atik. Chila' k'ut kub'ij wi xuquje' chi ri Qajaw Dios are ri u Dios ri qa mam Abraham, u Dios ri qa mam Isaac, u Dios ri qa mam Jacob, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ri Dios k'ut, man are tä Dios kech käminaqib', xane kech ri winaq ri e k'ask'oj. Ri e k'aslik, e k'ask'oj k'u wa' rumal ri Dios, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Xech'aw chi na jujun chke ri tijonelab' re ri Pixab', xkib'ij: Ajtij, qas utz ri b'im la, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Man xkichajij tä chi k'u anima' chuk'otik u chi' ri Jesús jumul chik. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Xub'ij k'u ri Jesús chke: ¿Jas che käb'ixik chi ri Cristo are ralk'ual kan ri qa mam David? ");
INSERT INTO qucNNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Are k'u ri qa mam David kub'ij pa ri wuj Salmos: Xub'ij ri Qajaw Dios che ri Wajaw: “Chatt'uyul pa nu wikiäq'ab' ");
INSERT INTO qucNNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","k'ä kinya na chawe chi katch'akanik, kattaqan k'u na pa ki wi' ri käka'n ki k'ulel chawe,” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","We ri qa mam David kub'ij Wajaw che, ¿jas ta k'u che käb'ij alaq chi are xa ralk'ual kan ri qa mam David? —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Konojel ri winaq xetowik aretaq xub'ij wa' chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Je wa' xub'ij: Chichajij iwib' chkiwäch ri tijonelab' re ri Pixab'. Käqaj chkiwäch keb'inikat pa charchäq taq katz'iaq. Xuquje' je'l käkilo, nim k'u keil wi ri käyi' rutzil ki wäch pa taq ri k'ayib'al. Käkitzukuj k'u ri t'uyulib'al ri nim ki b'anik pa taq ri rachoch Dios, xuquje' ri t'uyulib'al ri nim keil wi pa taq ula'nem, —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Xuquje' käkitoqij taq ri kachoch ri ixoqib' malka'nib'. Te ri' käkiyuq raqan ri ki tzij aretaq käka'n orar rech man q'alaj tä ri etzelal ri käka'no. Qas nim na ri k'äx käkiriq na ri tijonelab' re ri Pixab' aretaq käq'at tzij pa ki wi', —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Pa ri nimalaj rachoch Dios ri Jesús xeril ri q'inomab' ri tajin käkiya ri ki rajil pa ri k'olib'al ri käyi' wi ri kuchuj. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Xril xuquje' jun chichu' malka'n ri sib'alaj meb'a'. Xeuya k'u kieb' puaq ri man nim tä rajil pa ri k'olib'al kuchuj, kraj ne xa jun centavo rajil ri kieb' puaq ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Xub'ij k'u ri Jesús: Qas tzij ri kinb'ij chiwe chi we meb'a'laj chichu' malka'n ri', are nim na wa' ri xuya ri are' chkiwäch konojel ri jule' winaq ri ki yo'm ke. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ri jule' winaq chik ki yo'm jub'iq' che ri k'ia ri k'o kuk'. Are k'u we chichu' malka'n ri', pune sib'alaj meb'a', u yo'm ronojel ri tzuqub'al re, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","E k'o k'u jujun chke ri winaq tajin ketzijon chrij ri nimalaj rachoch Dios chi wiqtal kuk' je'lalaj taj ab'aj, xuquje' kuk' loq'alaj taq sipanik. Xub'ij k'u ri Jesús: ");
INSERT INTO qucNNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Kopan na ri q'ij ri man käkanaj tä na kan jun ab'aj puwi' jun ab'aj chik re we ja ri' ri kiwilo. Konojel kewulix na, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Xkita' k'u che ri Jesús, xkib'ij: Qajtij, ¿jampa' käb'antaj na wa'? ¿A k'o etal ri kuq'alajisaj chqawäch chi are q'ij ri' ri käb'an na ri xb'ij la chqe? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Xub'ij ri Jesús: Chichajij iwib' rech mixsub'tajik. E k'ia ri kepe na ri käkikoj na ri nu b'i', käkib'ij: “In ri' ri Cristo,” —kecha na. Xuquje' käkib'ij: “Qetetinaq chi loq ri q'ij,” —kecha ri', —kächa ri Jesús. Mixe' k'u kuk' ri e are', —kächa ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Aretaq kita u tzijol nimalaj ch'oj xuquje' chi käkiwalijisaj kib' ri winaq chkij q'atal taq tzij, mixej iwib'. Rajwaxik chi nab'e käb'antaj na wa' we ri', —kächa chke. K'ä mäjoq ri k'isb'al re we q'ij junab' ri', —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Te ri' xub'ij chi ri Jesús chke: Kech'ojin na ri winaq, ri juch'ob' winaq kuk' ri juch'ob' chik. Xuquje' käch'ojin na jun tinimit ruk' jun tinimit chik, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Käpe na nimalaj wi'jal pa taq jujun tinimit. Pa taq nik'iaj tinimit chik kepe na lawalo taq yab'il. Kepe k'u na nimaq taq käb'raqan. Keilitaj na xib'ib'alalaj taq jastaq xuquje' nimalaj taq etal chikaj, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Nab'e k'ut chkiwäch wa' we jastaq ri' kixkichap na ri winaq, kixkijach na pa ki q'ab' ri ki nimaqil ri winaq, xuquje' kixkikoj na pa che'. Kixkik'am na b'i chkiwäch nimaq taq tata'ib' ri ketaqan pa ki wi' ri winaq, xuquje' chkiwäch q'atal taq tzij rumal wech in, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Are q'ij wa' rech kiniq'alajisaj na in chkiwäch, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","K'ol b'a' pa iwanima' chi michomaj na b'ik jas ri' ri kib'ij na chuto'ik iwib'. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ri in kinya na chiwe ri rajwaxik u tzijoxik, xuquje' kinya ri i no'j. Ri i k'ulel man käkiriq tä chi na jas käkib'ij chiwe, man kech'akan tä pi wi', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Käb'an na tzijtal chiwij kumal ri i tat, i nan, ri iwachalal, ri iwachi'l rech kixjach b'ik. Kekämisax na jujun chiwe. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Konojel käketzelaj na i wäch xa rumal wech in, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Man käsach tä k'u na u wäch jun chiwe. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","We kich'ij wa', kixto'taj na, k'o na ri i k'aslemal ri man k'o tä u k'isik, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Aretaq kiwil ri tinimit Jerusalén sutim rij kumal soldados, chich'ob'o' chi käsach na u wäch ri tinimit chanim. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Pa ri q'ij ri' ri winaq ri e k'o pa Judea cheanimaj b'i pa taq ri juyub'. Ri e k'o pa ri tinimit, cheb'el b'ik. Ri e k'o pa taq ri juyub', meb'ok chi b'i pa ri tinimit, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Are k'u wa' ri q'ij ri kätoj na u k'exel ri ki mak ri winaq aj Jerusalén cho ri Dios. Käb'antaj na ronojel ri tz'ib'am chrij we tinimit ri', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Toq'ob' k'u ki wäch ri ixoqib' ri yawab' taq winaq chik, xuquje' ri e k'o alaj taq kal ri k'ä tajin ketu'nik pa ri q'ij ri'! Käk'oji k'u na nimalaj k'äxk'ol cho ruwächulew. Are käpe na ri nimalaj royowal ri Dios pa ki wi' ri winaq re ri tinimit ri', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","E k'ia ri kekämisax na kuk' taq ch'ich'. Kechap k'u nik'iaj, kek'am k'u na b'i naj pa taq ronojel tinimit. Ri tinimit Jerusalén käb'an na pa taq aqan kumal ri winaq ri man e aj Israel taj, k'ä kätz'aqat na ri q'ij ri yo'm chke we winaq ri' chi je' käka'n wa', —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Kek'oji na etal ajsik chrij ri q'ij, chrij ri ik', chkij taq ri ch'imil. Sib'alaj k'äx käkiriq na ri winaq ri e k'o cho ruwächulew. Man käkiriq tä chik jas käka'no, xane sib'alaj käkixej na kib' rumal ri nimalaj roq'eb'al ri kub'an ruwoja' re ri mar, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Käb'irb'it na ri kanima' ri winaq rumal ri xib'rikil xuquje' rumal ru chomaxik wa' ri käb'antaj na cho ruwächulew. Keyikopisax na ri u chuq'ab' ri kaj, —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Te k'u ri' kilitaj na chi kinpetik, in ri' ri Ralk'ual ri Dios ri Qas Winaq, pa jun sutz' ruk' nimalaj nu chuq'ab', känimarisax k'u na nu q'ij, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Aretaq kechap ki b'anik wa' we ri' ri nu b'im chiwe, chiwilampe', chixka'y chikaj. Käqetet chi k'u loq ri q'ij ri kixutor na ri Dios, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Xutzijoj k'u jun k'utb'al chik re tijonik chke, xub'ij: Chiwilampe ri u che'al higos, xuquje' ronojel u wäch che'. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Aretaq kiwilo chi ketux ri ki xaq, kich'ob' pa iwe wi chi qetetinaq chi loq ri q'alaj. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Je ri' xuquje' ri ix aretaq kiwilo chi käb'antaj wa' ri nu tzijom chiwe, chich'ob'o' chi xaq jub'iq' kraj chi käpe ri Dios che taqanik pa ki wi' ri winaq, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Qas tzij kinb'ij chiwe chi man kok'ow tä na we q'ij junab' ri' k'ä käb'antaj na ronojel. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Käsach k'u na u wäch ri kaj, xuquje' ruwächulew, are k'u ri nu tzij ri nu b'im chiwe, keb'antaj na wa', —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Chichajij b'a' iwib' rech man ke' tä iwanima' kuk' taq nimaq'ij, q'ab'arik, rech man ke' tä ne kuk' nik'iaj jastaq chik ajuwächulew pune are ri i chak, pune are ri ki tzuqik iwalk'ual. Te'talik k'ut käpe na ri q'ij ri' chiwij jas jun awanel. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Je' u petik wa' ri q'ij ri' pa ki wi' konojel winaq ri e k'o cho ruwächulew, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Chiwila b'a' iwib' amaq'el ronojel q'ij jas ri kib'ano, chib'ana orar amaq'el che ri Dios rech käyi' na chiwe chi kixresaj na chuwäch ronojel wa' ri käpe na cho ruwächulew. Chib'ana wa' rech kuya' kixtak'i na chnuwäch in pa utzil, in ri' ri Ralk'ual ri Dios ri Qas Winaq, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ri Jesús xuya tijonik ronojel q'ij pa ri nimalaj rachoch Dios. Chaq'ab' k'ut xel b'ik, xkanaj kan pa ri juyub' ri kojom Ujuyub'al Olivos che ru b'i'. ");
INSERT INTO qucNNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Sib'alaj aq'ab' käkimulij kib' ri winaq chuwäch ri Jesús pa ri nimalaj rachoch Dios chutatab'exik ru tzij. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Xqetet chik ri nimaq'ij re ri kaxlan wa ri man käyi' tä ch'äm ruk'. “Pascua” u b'i' ri nimaq'ij ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ri ki nimaqil ri sacerdotes aj Israel, xuquje' ri tijonelab' re ri Pixab' tajin käkitzukuj jas käka'n chukämisaxik ri Jesús. Käkixej k'u kib' chkiwäch ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Xok k'u ri Satanás pa ranima' ri tat Judas ri xuquje' käkoj Iscariote che ru b'i'. Are jun chke ri kab'lajuj apóstoles. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Xe' ri tat Judas, xeutzijob'ej k'u ri ki nimaqil sacerdotes, xuquje' ri ki nimaqil soldados rech kärilo jas kub'an na chujachik ri Jesús pa ki q'ab'. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Xekikot k'ut, xkiya ki tzij chi käkiya na puaq che ri tat Judas chutojik wa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Xuchi'j k'u ri tat Judas u jachik ri Jesús aretaq man e k'o tä k'ia winaq. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Xopan k'u ri nimaq'ij re ri kaxlan wa ri man käyi' tä ch'äm ruk'. Pa ri q'ij ri' rajwaxik u kämisaxik ri alaj chij re ri Pascua rech käkitijo. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ri Jesús xeutaq b'i ri tat Pedro, ri tat Juan, xub'ij chke: Jib'ana u b'anik ri wi'm re ri Pascua rech käqatijo. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Xkita' k'u che ri Jesús, xkib'ij: ¿Jawije' kaj wi la chi käqa'n wi ri wi'm? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Xub'ij ri Jesús chke: Aretaq kixopan pa ri tinimit, kiriqa na jun achi ruk'am jun q'eb'al joron. Chiterenej b'ik k'ä kixopan na pa ri ja ri kok wi. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Chib'ij che ri rajaw ja: “Kuta' ri Qajtij che la: ¿Jawije' k'o wi ri cuarto ri kintij wi ri wi'm re ri Pascua kuk' ri nu tijoxelab'?” —kixcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kuk'ut na chiwäch jun nimalaj cuarto suk'umatal chik pa ri kawiq ja. Chib'ana u b'anik ri wi'm re ri Pascua chila', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Xeb'e' k'ut, xekiriqa ronojel je' jas ri u b'im b'i ri Jesús chke. Xkichap u b'anik ri wi'm re ri Pascua. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Aretaq xopan ri hora, xt'uyi ri Jesús chi' ri mesa. E k'o ri kab'lajuj apóstoles ruk'. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Xub'ij chke: Sib'alaj nu rayim u tijik wa' we wi'm ri' re ri Pascua iwuk' k'ä mäja' kinriq k'äx. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kinb'ij k'u chiwe chi man k'o tä chi na jumul ri kintij na wa' k'ä käb'antaj na wa' pa ru taqanik ri Dios, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Xuk'am k'u ri vaso, xumaltioxij wa' che ri Dios, xub'ij chke ru tijoxelab': Chik'ama wa'. Chijacha wa' chiwäch, chitija b'a'. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kinb'ij k'u chiwe chi man kintij tä chi na we ri u wa'l uvas k'ä käpe na ri Dios che taqanik pa ki wi' ri winaq, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Aretaq ri Jesús xuk'am ri wa, xumaltioxij wa' che ri Dios. Xupiro, xuya chke ru tijoxelab', xub'ij: Are je' jas ri nu cuerpo ri käjach na rumal iwech ix. Chitija wa' che natab'al we, —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Aretaq e woqinaq chik, xuk'am xuquje' ri vaso junam jas ri xub'an che ri wa, xub'ij: Ri k'o chupam we vaso kinjunamaj ruk' ri nu kik'el ri käturuwisax na rumal iwech ix. Käb'an k'u na ri k'ak' trato rumal we nu kik'el ri', —kächa ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","¡Chiwilampe'! Ri jachal we tajin käwi' wuk' chi' we mesa ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Qas tzij kinkäm na in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, je' jas u b'eyal ru chomanik ri Dios. ¡K'äx k'u re ri achi ri kinjachowik! —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Te ri' xkichap u k'otik ki chi' chb'il kib' chrij jachin chke ri käb'anow na wa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Te k'u ri' ri tijoxelab' xkichaplej u chomalaxik kib' chrij jachin chke ri nim na u b'anik. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Xub'ij k'u ri Jesús chke: Ri q'atal taq tzij ketaqan wa' pa ki wi' ri winaq. Ri e k'o pa ki wi' ri winaq käb'ix “B'anal taq Utzil” chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Man je' tä k'u wa' ri ix. Xane ri nab'eal chiwe are je' ta ne ri más ak'al. Are k'u ri nim u b'anik chixol are junam jas ri patänil iwe. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Jachin k'u ri nim na u b'anik? ¿A are ri kät'uyi chi' ri mesa, o are ri patänil iwe? ¿A mat are ri kät'uyi chi' ri mesa? Are k'u ri in, in k'o iwuk' je' jas ri patänil iwe, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ri ix k'ut, ronojel q'ij xixk'oji wuk' in. I riqom k'äx junam wuk' in. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Rumal wa' kinya na chiwe chi kixtaqan na je' jas ri xuya ri Dios ri nu Tat chwe in chi ri in kintaqanik. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Kinb'an na wa' rech kixwi' wuk' in chi' ri nu mesa pa ri nu taqanik in. Ri ix k'ut käyi' na chiwe chi kiq'at na tzij pa ki wi' ri winaq re ri kab'lajuj juch'ob' winaq re ri tinimit Israel, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Xuquje' xub'ij ri Qajaw Jesús: Simón, Simón, chawila' chi ix iwonojel ix u tz'onom ri Satanás rech kixutaqchi'j che mak che rilik we qas tzij kich'ij wa'. Junam kub'an na ri are' chiwe jas ri kub'an jun winaq kuseysa' ri triko rech kätzaq na kanoq ri man utz taj, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","In b'ochi'm k'u ri Dios pa wi' at rech katkojon na, rech man kattzaq taj. Ri at k'ut, aretaq kak'ex awanima', katzelej awib', keato' b'a' ri awachalal, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Xub'ij ri Simón Pedro che: Qajaw, nu jikib'am ri wanima' in chi kine' uk' la, pune b'a' pa che', pune b'a' kinkäm uk' la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Xub'ij ri Jesús che: Pedro, qas tzij kinb'ij chawe chi k'ä mäjoq kätzintziriqin ri ama' äk' kämik, kab'ij na at oxmul chi man awetam tä nu wäch, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Xub'ij ri Jesús chke konojel: Aretaq xixintaq b'ik, man k'o tä i bolsa re puaq, man k'o tä i chim, man xik'am tä b'ik i xajäb'. ¿A k'o lo jas xajwataj chiwe? —xcha chke. Man k'o taj, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Xub'ij k'u chke: Kämik k'ut, apachin ri k'o u bolsa re puaq, chuk'ama b'ik, xuquje' chuk'ama b'i ru chim. We man k'o tä u machete, chuk'iyij ru q'u' chuloq'ik jun re, —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kinb'ij k'u chiwe chi tzrajwaxik wi chi käb'antaj ri tz'ib'am chwij pa ru Loq' Pixab' ri Dios, —kächa'. Are wa' ri kub'ij: “Xb'ix che chi are jun chke ri itzel taq winaq,” —kächa'. Ronojel k'u ri tz'ib'tal chwij, rajwaxik chi käb'antaj na wa', —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Xkib'ij ru tijoxelab' che: Qajaw, ¡chilampe la! E k'o kieb' machetes waral, —xecha che. Ruk' wa', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Xel b'i ri Jesús, xe' pa ri Ujuyub'al Olivos je' jas ru naq'atisam wi rib'. Xuquje' ru tijoxelab' xeteri b'i chrij. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Aretaq xeopan jela', xub'ij chke ru tijoxelab': Chib'ana orar rech man kixtzaq taj aretaq kixtaqchi'x che mak, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ri Jesús k'ut xutas apan rib' chke. Je' xek'ol wi apanoq jas ru najil jun ab'aj ri kusirirej apan jun. Xxuki'k, xub'an orar. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Xub'ij: Tat, we kaj la, b'ana b'a' la chi man rajwaxik taj chi kinriq we nimalaj k'äx ri käpetik, —kächa'. Mäb'an k'u la ri nu rayib'al in, xane ri rayib'al la, —xcha ri Qajaw Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Xuk'ut k'u rib' jun ángel ajchikaj chuwäch ri xyo'w u chuq'ab'. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ri Jesús, rumal chi sib'alaj nim ri k'äx ri tajin kuno', sib'alaj xukoj u chuq'ab' chub'anik orar. Sib'alaj xub'oq ja' je' ta ne chi are nimaq taq tz'uj re kik' ri käqaj cho rulew. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Aretaq xto'taj ri Jesús chub'anik orar, xe' kuk' ru tijoxelab'. Xeuriqa'. Tajin kewar rumal ri ki b'is. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Xub'ij ri Jesús chke: ¿Jas che kixwarik? Chixwalijoq, chib'ana orar rech man kixtzaq taj aretaq kixtaqchi'x che mak, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Tajin kätzijon ri Jesús aretaq xeopan k'ia winaq. Ri tat Judas, jun chke ri kab'lajuj u tijoxelab' ri Jesús u k'amom ri ki b'e. Xnaqajin ri tat Judas che ri Jesús chutz'umaxik. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Xub'ij k'u ri Jesús che: Judas, —kächa'. ¿A kinatz'umaj che nu jachik b'ik? ¿A je' kab'an chwe in, in ri' ri Ralk'ual Dios ri Qas Winaq? —xcha ri Jesús che. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ri e sutininaq rij ri Jesús, aretaq xkil ri xuk'ulmaj, xkib'ij che: Qajaw, ¿a keqach'ay na che machete? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Jun chke ri tijoxelab' xusok jun achi ri patänil re ri ki nimal sacerdotes aj Israel, xresaj k'u ru xikin re u wikiäq'ab'. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Xch'aw chi ri Jesús, xub'ij: Ruk' wa', —xcha'. Chiya kan ri ch'oj, —xcha chke. Xuchap k'u koq ru xikin ri achi, xukunaj. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Te ri' xch'aw ri Jesús jumul chik, xub'ij chke ri ki nimaqil sacerdotes, xuquje' chke ri ki nimaqil soldados ri chajinelab' re ri nimalaj rachoch Dios, xuquje' chke ri ki nimaqil ri winaq, e are' k'u taq wa' ri e petinaq chrij chuchapik: Je' ta ne chrij jun elaq'om ri elinaq wi loq alaq kuk' machetes, kuk' che', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","In k'o k'u uk' alaq ronojel q'ij pa ri nimalaj rachoch Dios, man xinchap tä alaq. Are k'u hora wa' ri yo'm chech alaq chi käb'an alaq wa'. Ri chuq'ab' alaq are re ri Itzel wa' ri kätaqan pa ri q'equm, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Xkichap k'u ri Jesús, xkik'am b'i cho rachoch ri ki nimal sacerdotes aj Israel. Ri tat Pedro u terenem chinaj. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Aretaq xkinuk' q'aq' pu nik'iajal ruwoja, konojel xkimulij kib' chrij, xet'uyi'k. Xuquje' ri tat Pedro xt'uyi chkixol. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Te ri' jun ali ajik' xril ri tat Pedro t'uyul chrij ri q'aq'. Ko xka'y che, xub'ij: Ri achi ri' are jun ruk' ri Jesús xuquje', —xcha ri ali. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ri tat Pedro xresaj rib' chupam, xub'ij: Man je' taj, ali, —xcha'. Man wetam tä u wäch, —xcha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Man naj tä chi k'ut, k'o jun chik xilow ri tat Pedro, xub'ij che: Ri at xuquje', at jun chke ri e k'o ruk' ri tat Jesús, —xcha che. Xub'ij ri tat Pedro: Man in tä ri', tat, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kraj ok'owinaq jun hora chik, k'o chi jun xujikib'a u b'ixik, xub'ij: Qas tzij ri are' jun ruk' rumal chi are aj Galilea, —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Xub'ij k'u ri tat Pedro: Tat, man kinch'ob' taj jas ri käb'ij la, —xcha che. K'ä tajin kätzijon ri tat Pedro aretaq xtzintziriqin jun ama' äk'. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Te ri' xutzolq'omij rib' ri Qajaw Jesús, xka'y che ri tat Pedro. Xna'taj k'u ri tzij ri u b'im ri Qajaw Jesús che: “K'ä mäjoq kätzintziriqin ri ama' äk', kab'ij na at oxmul chi man awetam tä nu wäch,” —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Xel k'u apan ri tat Pedro chrij ri ja, xuk'is rib' che oq'ej. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ri achijab' k'ut, ri e chajininaq ri Jesús, käketz'b'ej u wäch, xuquje' käkich'ayo. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Xkich'uq ru waq'äch, xkib'ij k'u che: ¡Chach'ob'o'! ¿Jachin ri' ri xatch'ayowik? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","K'ia ri mälom taq tzij ri xkib'ij che, sib'alaj xkiyoq'o. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Aretaq xsaqirik, xkimulij kib' ri ki nimaqil ri winaq aj Israel, ri ki nimaqil sacerdotes aj Israel, xuquje' ri tijonelab' re ri Pixab'. Xk'am b'i ri Jesús chkiwäch. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Xkib'ij k'u che: ¿A lal ri' ri Cristo? B'ij b'a' la chqe, —xecha che. Xch'aw chi ri Jesús, xub'ij chke: Pune ta ne kinb'ij chech alaq, man käkoj tä alaq ri nu tzij, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","We ta k'u k'o jas kinta' chech alaq, man käb'ij tä alaq chwe jas ri kinta' chech alaq. Man kintzoqopij tä b'i alaq, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Tzkämik ri', in ri' ri Ralk'ual ri Dios ri Qas Winaq, kint'uyi na pu wikiäq'ab' ri Dios ri sib'alaj k'o u chuq'ab', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Chanim k'ut xkita' che, xkib'ij konojel: ¿A lal ne lo ri' ru K'ojol ri Dios? —xecha che. Xch'aw chi ri Jesús, xub'ij chke: Je ri' jas ri käb'ij alaq chwe chi in ri', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Xkib'ij k'ut: ¿A kajwataj ta k'u lo jun q'alajisanel chik chqawäch? ¡Man rajwaxik taj! Ri uj k'ut, uj xujtow pu chi' jas ri kub'ij chb'il rib', —xecha ri tata'ib'. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Te k'u ri' xewalij konojel ri winaq ri xkimulij kib'. Xkik'am b'i ri Jesús cho ri q'atal tzij Pilato. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Xkichaplej u b'anik tzij chrij ri Jesús, xkib'ij: Qa riqom chi we achi ri' tajin kusach ki k'ux ri winaq, xuquje' xujutijoj chi man rajwaxik taj käqaya alkab'al che ri tat César. Kub'ij k'u chb'il rib' chi ri are', are ri Cristo, jun nim taqanel. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Xuta' k'u ri tat Pilato che: ¿A at ri' ri kattaqan pa ki wi' ri winaq aj Israel? —xcha ri'. Xch'aw ri Jesús, xub'ij: Je ri' jas ri käb'ij la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Xub'ij k'u ri tat Pilato chke ri ki nimaqil sacerdotes, xuquje' chke ri nik'iaj winaq chik: Man k'o tä mak kinriq chrij we achi ri', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ko k'ut xkijikib'a u b'ixik wa' konojel, xkib'ij: Xa kusach ki k'ux ri winaq, kuya tijonik pa ronojel tinimit rech Judea. Xuchaplej loq tijonik pa Galilea, u taqem u b'anik wa', xul waral pa Jerusalén, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Aretaq ri tat Pilato xuta wa', xuta' we ri achi ri' are aj Galilea. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Aretaq xretamaj chi jela' kel wi loq ri Jesús jawije' kätaqan wi ri tat Herodes, xutaq b'i ri Jesús cho ri are'. Ri tat Herodes k'o apan pa Jerusalén pa taq ri q'ij ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Aretaq ri tat Herodes xril ri Jesús, sib'alaj xkikotik. Xke' k'u k'ia q'ij u rayim rilik u wäch. Kraj ta k'u na käril jun kajmab'al rumal ri Jesús, rumal chi k'ia taq tzijob'elil u tom chrij. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ri tat Herodes sib'alaj xuk'ot u chi' ri Jesús. Man k'o tä k'u jas xub'ij ri Jesús che. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ri ki nimaqil sacerdotes aj Israel xuquje' ri tijonelab' re ri Pixab' sib'alaj xkitzukuj jas käka'n chub'anik tzij chrij. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Are k'u ri tat Herodes xuquje' ru soldados xketzelaj u wäch ri Jesús. Xketz'b'ej k'u u wäch xuquje'. Xkikoj jun je'lalaj atz'iaq che je' jas ri kukoj jun nim taqanel. Te ri' ri tat Herodes xutaq chi b'i ri Jesús ruk' ri tat Pilato. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Xutzir k'u ri ki ch'oj ri tat Herodes ruk' ri tat Pilato pa we q'ij ri'. Xjunamataj k'u ki wäch. Xeb'ux kachi'l kib'. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Te ri' ri tat Pilato xeusik'ij ri ki nimaqil sacerdotes, ri ki nimaqil ri winaq, xuquje' konojel ri winaq rech käkimulij kib' chuwäch. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Xub'ij k'u chke: Ri ix, i k'amom loq ri achi ri' chnuwäch. Xib'ij chi xa kusach ki k'ux ri winaq. Aretaq xink'ot u chi' chiwäch, man k'o tä mak xinriq chrij we achi ri' jas ri kib'ij ix. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Xuquje' ri tat Herodes man xuriq tä mak chrij. U taqom chi k'u loq quk'. Chiwilampe' chi man k'o tä jas u b'anom we achi ri' ri taqal u kämisaxik. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kink'äjisaj b'a' u wäch. Te k'u ri' kintzoqopij b'ik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ri q'atal tzij, jas ri ki naq'atisam wi ri winaq, ronojel nimaq'ij rajwaxik kutzoqopij b'i jun ajpache'. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Konojel ri winaq juntir xkiraq ki chi', xkib'ij: ¡Chesaj la b'i wa'! ¡Tzoqopij b'a' la ri tat Barrabás chqe! —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Are k'u ri tat Barrabás k'o pa che' rumal chi u kämisam jun winaq, xuquje' xeumulij ri winaq re ri tinimit rech käkiyak kib' chrij ri q'atal tzij. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ri tat Pilato xeuch'ab'ej ri winaq jumul chik. Are k'u ri are' kraj kutzoqopij ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ri winaq xkiraq ki chi' jumul chik, xkib'ij: ¡Chripoq! ¡Chripoq! —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Churox mul xub'ij chke: ¿Jas etzelal u b'anom wa' we achi ri'? Man k'o tä jun mak nu riqom chrij rech käkämisaxik. Kink'äjisaj b'a' u wäch, kintzoqopij k'u b'ik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ri winaq k'ut xkikoj ki chuq'ab' junam kuk' ri ki nimaqil sacerdotes aj Israel. Sib'alaj xkiraq ki chi' chub'ixik chi kärip ri Jesús. Xekowinik, xech'akan che ri tat Pilato. Xyi' k'u chke jas ri xkirayij. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Te k'u ri' ri tat Pilato xuq'at tzij chi käb'antaj na jas ri xkita' che. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Xutzoqopij k'u ri tata' ri xkita', are ri ajpache', ri achi kämisanel ri xeumulij ri winaq re ri tinimit rech käkiyak kib' chrij ri q'atal tzij. Are k'u ri Jesús xujach pa ki q'ab'. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Aretaq tajin käk'am b'i ri Jesús churipik, xkichap apan jun achi aj Cirene, Simón u b'i', ri petinaq pa juyub'. Xkiya k'u ri cruz chrij rech kutelej b'ik, kuterenej b'i ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Xeteri k'u b'ik k'ialaj winaq, xuquje' jujun taq ixoqib' ri käkik'is kib' che oq'ej, käkoq'ej u wäch ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Xutzolq'omij rib' ri Jesús, xerilo, xub'ij k'u chke: Ixoqib' aj Jerusalén, —kächa'. Moq'ej chi alaq nu wäch in, are k'u choq'ej ib' alaq, xuquje' cheoq'ej alaq ki wäch ri al alaq, —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kopan k'u na ri q'ij aretaq käb'ixik: “Utz ke ri chuchuib' ri man kealk'ualan taj, ri man kekowin tä che alk'ualanik. Utz ke ri chuchuib' ri man k'o tä kal ri ketu'nik,” —kächa na. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Pa ri q'ij ri' käkib'ij na ri winaq chke ri nimaq taq juyub': “Chixtzaq loq pa qa wi',” —kecha na ri'. Xuquje' käkib'ij chke ri juyub': “Chujich'uqu,” —kecha na chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","We käb'an wa' we k'äx ri' aretaq räx ri che', ¿jas ta ne ri käka'n na aretaq chaqi'j chik ri che'? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Xuquje' xekik'am b'i ruk' ri Jesús kieb' b'anal taq etzelal rech kekämisaxik. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Aretaq xeopan pa ri k'olib'al ri kojom U B'aqil Jolomaj che ru b'i', chila' xkirip wi ri Jesús, xuquje' ri kieb' b'anal taq etzelal junam ruk', jun pu wikiäq'ab', ri jun chik pu moxq'ab' ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Xub'ij k'u ri Jesús: Tat, sacha la ki mak. Xa man käkich'ob' tä ri' jas ri tajin käka'no, —xcha'. Ri soldados k'ut xkesaj ki suerte chrij ri ratz'iaq ri Jesús, xkijach k'u wa' chkiwäch. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","E tak'atoj k'u ri winaq, tajin keka'y che ri Jesús. Ri ki nimaqil ri winaq xketz'b'ej u wäch, xkib'ij: Xuto' ri jule' winaq chik. We qas tzij are ri Cristo ri cha'tal rumal ri Dios, chuto' b'a' rib', —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Xuquje' ri soldados xketz'b'ej u wäch. Xeqeb' ruk' ri Jesús, xkiya ch'äm vino chuwäch. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Xkib'ij che: ¡We at ri' ri kattaqan pa ki wi' ri winaq aj Israel chato' b'a' awib'! —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kojom k'u jun tz'ib'talik puwi' ri cruz ri xrip wi ri Jesús. Are tz'ib'am wa' pa ki ch'ab'al ri winaq aj Israel, ri winaq latinos, xuquje' ri winaq griegos, kub'ij: ARE NIM TAQANEL PA KI WI' RI WINAQ AJ ISRAEL, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jun chke ri b'anal taq etzelal, ri e tzäyeb'am ruk', xuyoq'o, xub'ij: We qas tzij lal ri' ri Cristo, chto' ib' la. Chujto' la uj xuquje', —xcha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Xch'aw ri jun achi chik, xuyaj ri rachi'l. Xub'ij che: ¿A mat kaxej awib' at cho ri Dios, at k'ut junam tajin kariq k'äx ruk'? ");
INSERT INTO qucNNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ri uj taqal chqe chi je' käb'an wa' chqe. Tajin käqatoj u k'exel ri qa'nom. Are k'u wa' we achi ri', man k'o tä etzelal u b'anom, —xcha che ri rachi'l. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Xub'ij che ri Jesús: Tat, chinnataj che la aretaq kächaplej la taqanik, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Xch'aw ri Jesús, xub'ij: Qas tzij ri kinb'ij chawe chi kämik ri' katk'oji na wuk' in pa ri je'lalaj k'olib'al “paraíso” u b'i', —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kraj pa ri kab'lajuj hora xq'equmar ruwächulew k'ä pa ri urox hora re b'enaq q'ij. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Xatin k'u ri q'ij, xuquje' xjisjob' ri tasb'al u pam ri nimalaj rachoch Dios. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Te ri' xuraqaqej u chi' ri Jesús, ko xch'awik, xub'ij: ¡Tat! —xcha'. Kinjach ri wanima' pa q'ab' la, —xcha'. U b'im wa', xel ranima'. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Aretaq ri ki nimal soldados xril ri xb'antajik, xunimarisaj u q'ij ri Dios, xub'ij: Qas utzalaj achi wa' we achi ri', —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Konojel ri winaq xkimulij kib' che rilik. Aretaq xkil ri xb'antajik, xetzelejik, sib'alaj keb'isonik, keb'oq'ik. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Konojel ri etamaninaq u wäch ri Jesús, xuquje' ri ixoqib' ri tereninaq u loq pa Galilea xekanaj kan chinaj che rilik ri xb'an che. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Te ri' xopan jun achi, José u b'i'. Are jun chke ri ki nimaqil ri winaq, utzalaj achi k'u wa' ri jikom ranima'. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ri are' are aj Arimatea, jun tinimit re Judea. Are jun achi ri ku'l na u k'ux che reyexik ru taqanik ri Dios pa ki wi' ri winaq. Man xuk'ul tä k'u re ri are' ri ka'nom ri nik'iaj ki nimaqil ri winaq chik. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Xopan k'u ri are' cho ri tat Pilato chuta'ik chi käyi' ru cuerpo ri Jesús che. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Aretaq xuqajsaj, xub'olq'otij pa jun manta. Xuya k'u pa jun muqub'al ri mäja' k'o jun winaq yo'm chupam. Ri muqub'al ri' are jun pek k'otom koq cho ri ab'aj. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","We q'ij ri' are ri víspera wa' re ri Pascua. Xaq jub'iq' kraj chi kächaplex ri q'ij re uxlanem. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ri ixoqib' ri xeteri loq ruk' ri Jesús pa Galilea, xkiterenej b'ik, xkil ri muqub'al. Xkilo jas ri xb'an kan chuya'ik ri käminaq chupam. ");
INSERT INTO qucNNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Aretaq xetzelej b'i cho ja, xka'n u b'anik k'ok'alaj taq kunab'al. Xeuxlan k'u pa ri q'ij re uxlanem, je' jas ri kub'ij ri Pixab'. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Pa ri nab'e q'ij re ri semana, sib'alaj aq'ab' xeb'e' ri ixoqib', xeopan k'u chuchi' ri muqub'al. Xkik'am b'i ri k'ok'alaj taq kunab'al ri ka'nom. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Xkiriq ri ab'aj wolqotim chi apan jela' chuchi' ri muqub'al. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Xeb'ok b'ik, man xkiriq tä k'u ru cuerpo ri Qajaw Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Xkixej k'u kib', man xkiriq taj jas käka'no rumal ri xb'antajik. Xaq te'talik k'ut xetak'i kieb' achijab' chkinaqaj, ri sib'alaj käjuluw ri katz'iaq. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Xkixej k'u kib' ri ixoqib', xkipachb'a kib' pulew. Xkib'ij k'u ri achijab' chke: ¿Jas che kitzukuj ri k'aslik chkixol ri käminaqib'? ");
INSERT INTO qucNNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Man k'o tä waral, xk'astaj b'i ri', —kecha chke. Chna'taj chiwe jas ri xutzijoj kan ri Jesús chiwe aretaq k'ä k'o ri Are' pa Galilea, —kecha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Je' xub'ij wa' chiwe: “Rajwaxik chi ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, kinjach na pa ki q'ab' ajmakib', kinrip na cho ri cruz, kink'astaj k'u na b'i chkixol ri käminaqib' churox q'ij,” —xcha ri', —xecha chke ri ixoqib'. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Te k'u ri' xna'taj ru tzij ri Jesús chke ri ixoqib'. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Aretaq tzelejem loq ke, ki petik pa ri muqub'al, xkitzijoj chke ri tijoxelab', xuquje' chke ri nik'iaj kachi'l chik ronojel ri xkik'ulmaj. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ri xkitzijoj ri tzij ri' chke ri apóstoles, ru taqo'n ri Jesús, e are' ri nan María Magdalena, ri nan Juana, ri nan María ru nan ri Jacobo, xuquje' ri jule' ixoqib' chik. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ri apóstoles man xkikoj tä ri ki tzij ri ixoqib'. Xel chkiwäch chi xaq kon taq tzij ri käkib'ij. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pune ta ne je ri', ri tat Pedro xwalij b'ik. Xutik anim, xe' chuchi' ri muqub'al. Xpachi'k, xka'y koq chupam. Xuwi ri manta xrilo. Xukajmaj k'u ri xk'ulmatajik. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Pa we q'ij ri' e b'enaq pa ri b'e kieb' chke ri tijoxelab'. B'enam ke pa jun alaj tinimit, Emaús u b'i'. Kraj julajuj kilómetros u xol ruk' ri tinimit Jerusalén. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Käkitzijob'ela kib' chrij ri xb'antaj pa Jerusalén. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tajin k'u käkich'ab'ej kib', käkik'otola taq ki chi' aretaq ri Jesús xuriq b'i rib' kuk', xerachi'laj b'i junam. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Xb'an k'ut chi man xkich'ob' tä u wäch. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Xub'ij k'u chke: ¿Jas ri kitzijob'ela chb'il taq iwib' pa we b'e ri'? —kächa'. ¿Jas che kixb'isonik? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jun chke ri achijab', Cleofas u b'i', xch'awik, xub'ij che: ¿A xaq lal jun ok'owel pa Jerusalén? Kraj ne xaq xuwi ri lal man etam tä la ri xb'antaj jela' pa taq ri q'ij ri', —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Xub'ij k'u chke: ¿Jas ri' ri xb'anik? —xcha ri Jesús chke. Xkib'ij che: Are ri xb'an che ri Jesús aj Nazaret. We achi ri' are jun q'alajisal re ru Loq' Pixab' ri Dios, ri sib'alaj k'o u chuq'ab' ru tzij ri xuquje' kub'an kajmab'al. Nim k'u u b'anik cho ri Dios, xuquje' chkiwäch ri winaq, —kecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Xjach k'u b'ik, xq'at tzij puwi' chi käkämisaxik ri Are' kumal ri ki nimaqil sacerdotes aj Israel, xuquje' kumal ri ki nimaqil ri qa winaq uj. ¡Xkirip k'u cho ri cruz! —kecha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Are k'u ri uj xqachomaj chi are wa' ri kutor na ri qa tinimit Israel. Ya xke' oxib' q'ij kämik ri xb'an wa', —kecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Xqakajmaj k'ut jas ri xkitzijoj jujun taq ixoqib' chqaxol. Aq'ab' xeb'e' chuchi' ru muqub'al ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Man xkiriq tä chi k'u ru cuerpo, —kecha'. Aretaq xetzelej b'ik, xkitzijoj chqe chi xekil ángeles ri xkib'ij chi xk'astaj b'i ri Jesús, —kecha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Te ri' xeb'e' jujun chke ri qachi'l chuchi' ri muqub'al, je' xkilo jas ri xkib'ij ri ixoqib'. Man xkil tä chi u wäch ri Jesús, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Te ri' xub'ij ri Jesús chke: ¡Ay, kon taq achijab'! ¡Man kixkojon tä che ri ki tzijom kan ri ojer taq q'alajisal re ru Loq' Pixab' ri Dios! ");
INSERT INTO qucNNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿A mat iwetam ix chi rajwaxik chi ri Cristo kuriq wa' we k'äx ri' k'ä mäjoq känimarisax u q'ij? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Xuchaplej k'u u q'alajisaxik chkiwäch ri u tzij ri mam Moisés xuquje' ri ki tzij ri ojer taq q'alajisal re ru Loq' Pixab' ri Dios jas ri ki tz'ib'am kan chrij ri Cristo. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Xenaqajin k'u che ri alaj tinimit jawije' e b'enam wi ke. Ri Jesús xub'ano chi je' ta ne chi naj ri ke' wi na, man xtak'i taj. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ri tijoxelab' xkikoj ki chuq'ab' rech käkanaj kan kuk', xkib'ij che: Kanaj kan la quk'. Qajem k'u kub'an ri q'ij, kok k'u na ri aq'ab', —xecha che. Xok k'u b'i ri Jesús, xkanaj kan kuk'. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Aretaq xt'uyi kuk' chi' ri mesa, xuk'am ri wa. Xutewchij, xupiro, xuya chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Te k'u ri' xyi' chke chi xekowinik xkich'ob' u wäch. Xaq te'talik k'ut xsach ri Jesús chkiwäch. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Xkib'ila k'u ri jun che ri jun chik: ¿A mat k'o jas xqana' pa qanima' aretaq xujuch'ab'ej pa ri b'e, aretaq xuq'alajisaj ru Loq' Pixab' ri Dios ri Tz'ib'talik chqawäch? —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Pa ri hora ri' xewalijik, xetzelej b'i pa Jerusalén. Xekiriqa ri julajuj tijoxelab' ki mulim kib' xuquje' ri nik'iaj kachi'l chik. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Xkib'ij k'u chke: Qas tzij xk'astaj ri Qajaw Jesús, u k'utum k'u rib' chuwäch ri tat Simón, —xecha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Te ri' xkitzijoj ri xkik'ulmaj pa ri b'e, xuquje' xkitzijoj jas xketamab'ej u wäch ri Jesús aretaq xupir ri wa. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Aretaq tajin käkitzijob'ela kib' chrij ri xkik'ulmaj, xuk'ut rib' ri Jesús chkiwäch, xtak'i k'u chkixol. Xub'ij chke: Chuxlan b'a' ri iwanima', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","¡Sib'alaj k'u xkixej kib'! Xkichomaj chi are jun xib'inel ri tajin käkilo. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Xub'ij k'u ri Jesús chke: ¿Jas che kixb'irb'it pa iwanima', kub'an k'u kieb' i k'ux? —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Chiwila ri waqan xuquje' ri nu q'ab' chi qas in ri' ri Jesús. Chinina', chiniwila', —kächa'. Jun xib'inel man k'o tä u tijal, man k'o tä k'u u b'aqil je' jas ri wech in ri kika'yej, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Aretaq xub'ij wa' xuk'ut ru q'ab' xuquje' ri raqan chkiwäch. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Käkaj käkikojo, käkaj man käkikoj taj rumal chi kikajmam kib'. Jub'iq' kekikotik, jub'iq' k'u käkixej kib'. Xub'ij k'u ri Jesús chke: ¿A k'o waral jas kintijo? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Xkiya k'u jun ch'äqap b'olom kär che. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Xuk'amo, xutij chkiwäch. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Xub'ij k'u chke: Aretaq ri in xink'oji iwuk', xintzijoj chiwe chi rajwaxik keb'antaj konojel ri tz'ib'am chwij pa ru Pixab' ri qa mam Moisés, xuquje' ri tz'ib'am kumal ri ojer taq q'alajisal re ru Loq' Pixab' ri Dios, xuquje' pa taq ri salmos, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Te k'u ri' xuya chke chi xkich'ob' na ri Tz'ib'talik. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Xub'ij chke: Je' tz'ib'am wa' chi kuriq na k'äx ri Cristo, käk'astaj k'u na b'i chkixol ri käminaqib' churox q'ij, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Xuquje' tz'ib'am chi rajwaxik u tzijoxik ru Tzij ri Dios chke konojel tinimit pa ri u b'i' ri Cristo chub'ixik chke chi rajwaxik käkik'ex kanima', käkik'ex k'u ki chomanik ri winaq rech kesachtaj na ri ki mak. Are kächapletaj na b'i u tzijoxik wa' pa ri tinimit Jerusalén, —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ri ix k'ut, ix q'alajisanelab' chrij ronojel wa' we ri'. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Kintaqa na loq pi wi' jas ri xub'ij ri Dios ri nu Tat chi kuya na chiwe. Chixkanaj b'a' kan pa ri tinimit Jerusalén k'ä käyi' na chiwe ri i chuq'ab' ajchikaj. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Te k'u ri' ri Jesús xeuk'am b'i apan chrij ri tinimit Betania. Chila' xuwalijisaj ru q'ab', xeutewchij. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Aretaq tajin keutewchij, xel b'i chkiwäch, xk'am b'i chikaj. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Xnimarisax na u q'ij kumal chila'. Te ri' xetzelej loq pa Jerusalén, sib'alaj k'u kekikotik. ");
INSERT INTO qucNNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Amaq'el ronojel q'ij e k'o pa ri nimalaj rachoch Dios, tajin käkiya k'u u q'ij ri Dios. Amén. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Aretaq mäjoq käb'an ri kajulew, ri Cristo, ri käb'ix “u Tzij ri Dios” che, ya k'o chik ri Are'. Ri Are' ri käb'ix “u Tzij ri Dios” che k'o chik ruk' ri Dios, are k'u qas Dios wa'. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ri Are' k'ut k'o ruk' ri Dios ojer tzaretaq xchaptaj loq u b'anik ronojel. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Rumal ri Are' ri Dios xub'an ronojel ri k'olik. Man k'o tä k'u jas ri k'olik ri mat xb'an rumal ri Are'. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ruk' ri Are' k'o wi ri qas k'aslemal ri man k'o tä u k'isik. We k'aslemal ri' are wa' ri qas saqil chke konojel ri winaq cho ruwächulew. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ri saqil ri' käjuluw pa ri q'equm, man käkowin tä k'u ri q'equm chusachik u wäch. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","K'o jun tata' ri xtaq loq rumal ri Dios. Ri tata' ri' are Juan u b'i'. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Xpe k'u ri are' chuq'alajisaxik ri saqil chkiwäch ri winaq rech konojel kekojon ta che ri saqil rumal ri u tzij ri are'. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ri tat Juan man are tä ri saqil, xane xa taqom loq rech kuq'alajisaj ri qas tzij chrij ri saqil. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ri qas saqil k'ut, ri käjuluw pa ki wi' konojel ri winaq, tajin käpe cho ruwächulew. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ri Jun ri käb'ix “u Tzij ri Dios” che k'o chik cho ruwächulew. Pune k'u rumal ri Are' ri Dios xub'an ruwächulew, ri winaq k'ut ri e k'o cho ruwächulew man qas xkich'ob' tä u wäch. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Xopan pa ru tinimit, ru winaqil k'ut man xkik'ulaj taj. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pune je ri' e k'o k'u jujun ri utz u k'ulaxik xka'no, xekojon che ri Are'. E are k'u taq wa' ri xyi' chke chi keb'ok che ralk'ual ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ri xekojonik, ri xeb'ok che ralk'ual ri Dios, man je' tä xb'an che kalk'ualaxik jas ri kalk'ual ri winaq ri xaq kil ki wäch rumal chi je wa' xkichomaj ri ki nan ki tat, o rumal ru rayib'al jun winaq. Xane ri Dios are ri qas ki Tat ri e are'. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ri Jun ri käb'ix “u Tzij ri Dios” che xub'an winaq, xk'oji k'u chqaxol waral cho ruwächulew. Loq' xeril wi konojel winaq, xub'ij k'u ri qas tzij chke. Xqil ri kelik, q'alaj chi qas are ru K'ojol ri qa Tat ri sib'alaj nim u q'ij, ri xuwi wa' u K'ojol k'olik. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ri tat Juan xuq'alajisaj ri qas tzij chrij ri Are', xub'ij: Are wa' ri xinb'ij, chi ri Jun chik ri käpe na, are nim na u q'ij chnuwäch in rumal chi ri Are' k'o chik aretaq ri in mäja' kil nu wäch, —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Qonojel qa k'amom qe ri nimalaj u q'inomal, qa riqom k'u tewchib'al q'ij chi q'ij. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ri qa mam Moisés xutz'ib'aj kan ri Pixab' ri xuya ri Dios che. Are k'u ri Jesucristo xuk'ut kan chqawäch chi qas kujraj ri Dios, xuq'alajisaj ri qas tzij chqawäch. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Man k'o tä wi jun winaq ilowinaq u wäch ri Dios. Xane xaq xuwi ru K'ojol ri Dios ri k'o ruk' ri qa Tat, ri xaq xuwi wa' u K'ojol k'olik, are ri Are' xulq'alajisan chqawäch ru b'anik ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ri winaq aj Israel pa Jerusalén xekitaq b'i sacerdotes xuquje' levitas ruk' ri tat Juan chuta'ik che jachin ri are'. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ri are' qas xuq'alajisaj chkiwäch chi saqil, xub'ij: Ri in, man in tä ri Cristo, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Xkita' chi k'u jumul che, xkib'ij: ¿Jachin k'u ri lal? ¿A lal ri' ri qa mam Elías ri q'alajisal re ru Loq' Pixab' ri Dios? —xecha che. Ri tat Juan xub'ij: Man in tä ri', —xcha chke. Jumul chik xkita' che, xkib'ij: ¿A man lal k'u ri' ri q'alajisal u Tzij ri Dios ri käb'ixik chi käpe na? —xecha che. Ri are' xch'awik, xub'ij: Man in tä ri', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Xkib'ij k'u che: ¿Jachin k'u ri lal? Rajwaxik chi kuje'k, k'o jas ri ke'qab'ij chke ri xujtaqow loq. ¿Jas ri käb'ij la chqe chij ib' la? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ri tat Juan xch'awik, xub'ij: In ri' ri jun ri ko käch'aw pa taq ri juyub' ri kätz'inowik, kub'ij: “Chib'ana u b'anik ri nim b'e ri käb'in wi ri Qajaw, chib'ana jikom che,” —kächa'. Je' jas ri xub'ij loq ri qa mam Isaías ri q'alajisal re ru Loq' Pixab' ri Dios, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ri achijab' ri' ri xeopan ruk' ri tat Juan chuch'ab'exik, e are' ki taqo'n ri tata'ib' fariseos wa'. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Xkita' k'u che ri tat Juan: We ri lal, man lal tä ri' ri Cristo, man lal tä ri' ri qa mam Elías, man lal tä k'u ri' ri q'alajisal re ru Loq' Pixab' ri Dios, ¿jas che käb'an la qasna'? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ri tat Juan xub'ij chke: Ri in kinb'an qasna' ruk' joron. K'o k'u Jun chxol alaq ri man etam tä alaq u wäch ri Are'. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Are k'u wa' ri Jun ri teren loq chwij, pune nim k'u na u b'anik chnuwäch in. Man taqal tä k'u chwe in kinkir ru k'amal u xajäb', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ronojel wa' we ri' xk'ulmataj pa Betábara ri k'o chrelb'al q'ij che ri nima' Jordán jawije' ri tajin kub'an wi qasna' ri tat Juan. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Chukab' q'ij ri tat Juan xril ri Jesús tajin känaqajin loq ruk', xub'ij: ¡Chilampe alaq! —kächa'. Are wa' ri Jun ri käkämisax na cho ri Dios je' ta ne jun alaj chij che resaxik b'i ri ki mak ri winaq ri e k'o cho ruwächulew, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Chrij k'u ri Are' xintzijon wi aretaq xinb'ij: Käpe chi na Jun ri nim na u b'anik chnuwäch in. Je ri', rumal chi ri Are' ya k'o chik mäjoq kil nu wäch in. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ri in xuquje' man wetam tä u wäch nab'e, tajin k'u kinb'an ki qasna' ri winaq rech konojel ri winaq aj Israel käketamaj u wäch, —xcha ri tat Juan. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Xuquje' xub'ij ri tat Juan: Xinwil ri Loq'alaj Espíritu xqaj loq chikaj je' u b'anik jun palomäx, xkanaj k'u kan puwi' ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ri in nab'e man wetam taj jachin ri Are', ri Dios k'ut ri xintaqowik chi kinb'an qasna' ruk' joron, are xub'ij chwe: “Jachin ri kawilo chi käqaj ri Loq'alaj Espíritu puwi', käkanajik, are ri' ri Jun ri kub'an na qasna' ruk' ri Loq'alaj Espíritu,” —xcha chwe. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ri in wilom ri xuk'ulmaj, kinq'alajisaj k'ut jas ri xinwilo chi are wa' ru K'ojol ri Dios, —xcha ri tat Juan chke ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Chukab' q'ij ri tat Juan k'o chila' jumul chik e rachi'l kieb' chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Aretaq ri tat Juan xrilo chi tajin kok'ow ri Jesús, xub'ij: ¡Chiwilampe'! —kächa'. Are wa' ri Jun ri käkämisax na cho ri Dios je' ta ne jun alaj chij, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ri kieb' u tijoxelab' ri tat Juan, aretaq xkita ri xub'ij, xeb'e' ruk' ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ri Jesús xka'y kan chrij, xrilo chi terenem ri Are' kumal ri kieb' tijoxelab', xub'ij chke: ¿Jas tajin kitzukuj? —xcha'. Ri e are' xkib'ij che: Ajtij, ¿jawije' jeqel wi la? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ri Jesús xch'awik, xub'ij chke: ¡Chixsajmpe'! Jo' b'a', kiwila k'u na, —xcha ri' chke. Xeb'e' k'u ruk' ri Are', xkil na jawije' ri jeqel wi. Chila' k'ut xekanaj wi kan pa ri q'ij ri', rumal chi kraj are ukaj hora ri' re ri b'enaq q'ij. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jun k'u chke ri kieb' achijab' ri xkita ri xub'ij ri tat Juan, ri xeb'e' ruk' ri Jesús, are ri tat Andrés ri ratz ri tat Simón Pedro. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Xe' ri tat Andrés chanim chutzukuxik ri tat Simón ru chaq', xub'ij k'u che: Xqariq ri Mesías, —xcha che. (Ri tzij ri' kel kub'ij “Cristo”.) ");
INSERT INTO qucNNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Te k'u ri' ri tat Andrés xuk'am b'i ri tat Simón ruk' ri Jesús. Ri Jesús k'ut, aretaq xrilo, xub'ij che: At ri' ri tat Simón ru k'ojol ri Jonás. Cefas chik käb'ix na chawe (ri kel kub'ij Pedro), —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Chukab' q'ij chik ri Jesús xuchomaj chi ke' pa Galilea. Xuriq k'u ri tat Felipe, xub'ij che: Tasa'j wuk', —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ri tat Felipe jela' käpe wi pa ri tinimit Betsaida ri ki tinimit ri tat Andrés, ri tat Pedro. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ri tat Felipe xe' chutzukuxik ri tat Natanael, xub'ij che: Xqil u wäch ri achi ri k'o xutz'ib'aj ri qa mam Moisés chrij pa taq ri wuj re ri Pixab', xuquje' ri k'o xkitz'ib'aj ri q'alajisal taq re ru Loq' Pixab' ri Dios chrij pa ri ki wuj. Are wa' ri Jesús ru k'ojol ri tat José aj Nazaret, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ri tat Natanael xub'ij che: ¿A k'o pu lo jun winaq nim u b'anik ri käpe pa Nazaret? —xcha che. Ri tat Felipe xub'ij che: Tasa'j b'a', kawil k'u na at, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ri Jesús, aretaq xrilo chi petinaq ri tat Natanael, xub'ij: Xpe jun achi ri qas aj Israel, ri man k'o tä sub'unik pa ranima', —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Te ri' ri tat Natanael xuta' che ri Jesús: ¿Jas xb'an la che retamaxik nu wäch? —xcha che. Ri Jesús xub'ij che: Xatinwilo aretaq mäja' katsik'ix rumal ri tat Felipe, aretaq at k'o chuxe' ri jun u che'al higos, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ri tat Natanael xub'ij che: Ajtij, lal ri' ri u K'ojol ri Dios, ri Nim Taqanel pa ki wi' ri winaq aj Israel, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ri Jesús xch'awik, xub'ij che: E ri at, ¿a kakoj wa' xa rumal chi xinb'ij chawe chi xatinwilo aretaq ri at k'o chuxe' ru che'al higos? Kawil k'u na nimaq taq kajmab'al chuwäch wa' we ri', —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Xuquje' xub'ij ri Jesús: Qas tzij ri kinb'ij chiwe chi kiwil na ri kaj jaqtalik. Kiwil k'u na ri ángeles rech ri Dios kepaqi'k, kexuli pa nu wi' in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Churox q'ij xb'an jun k'ulanem pa ri tinimit Caná re Galilea. Ru nan ri Jesús k'o pa ri k'ulanem. ");
INSERT INTO qucNNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Xuquje' ri Jesús e rachi'l ru tijoxelab' xesik'ix pa ri k'ulanem. ");
INSERT INTO qucNNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Xk'is k'u ri vino. Xpe ru nan ri Jesús, xub'ij che ri Are': Man k'o tä chi vino, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ri Jesús k'ut xch'awik, xub'ij che: Nan, ¿jas che kab'ij wa' chwe in? Mäja' kuriq ri q'ij chwe, —xcha che ru nan. ");
INSERT INTO qucNNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Xub'ij k'u ru nan chke ri tajin kekojow ri vino: Chib'ana ronojel ri kub'ij na chiwe, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","K'o k'u waqib' nimaq taq q'eb'al re ab'aj chila', k'olib'al joron ri käkikoj ri winaq aj Israel che ch'ajb'al kib' aretaq käkesaj ri äwas chkij. Chkijujunal ri q'eb'al käkich'ij jumuch' o cien litros joron. ");
INSERT INTO qucNNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ri Jesús xub'ij chke ri tajin kepatänin chke ri winaq: Nojisaj alaq we q'eb'al ri' che joron, —xcha chke. Xkichap k'u ki nojisaxik ri nimaq taq q'eb'al k'ä xenoj na. ");
INSERT INTO qucNNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Xub'ij k'u ri Jesús chke: Chesaj alaq b'i jub'iq', k'ama b'i alaq che ri k'amal b'e pa ri nimaq'ij, —xcha chke. Je' k'u xka'no. ");
INSERT INTO qucNNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Aretaq ri k'amal b'e pa ri nimaq'ij xuna' ri joron ri k'extajinaq chi pa vino, man retam tä k'ut jawije' xe'k'am wi. Xaq xuwi ri patäninelab' k'o ketam chik che ri vino jawije' kesam wi b'ik. Ri k'amal b'e xusik'ij ri ala (ri novio). ");
INSERT INTO qucNNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Xub'ij k'u che: Konojel ri winaq are käkikoj nab'e ri utzalaj vino. Aretaq k'ut e nojinaq chi ri ula', te k'u ri' kok ri vino ri man qas tä paqal rajil. Are k'u ri at a k'olom kan ri utzalaj vino rech k'ä te' kok wa' k'isb'al, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ri xub'an ri Jesús pa Caná re Galilea, are wa' ri nab'e kajmab'al etal. Ruk' wa' xuk'utu chi sib'alaj nim u q'ij ri Are'. Xekojon k'u ru tijoxelab' che. ");
INSERT INTO qucNNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Te k'u ri' xel b'i chila', xe' pa ri tinimit Capernaum, rachi'l ru nan, ru tijoxelab', xuquje' taq ru chaq'. Xekanaj k'u na kan kieb' oxib' q'ij chila'. ");
INSERT INTO qucNNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Xa jub'iq' kraj man kuriq ri Pascua, jun chke ri ki nimaq'ij ri winaq aj Israel. Rumal ri' ri Jesús xe' pa ri tinimit Jerusalén. ");
INSERT INTO qucNNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Chila' pa ri nimalaj rachoch Dios xeuriq ajk'ay taq wakäx, ajk'ay taq chij, xuquje' ajk'ay taq palomäx. Xuquje' xeuriq ri k'exel taq ki rajil ri winaq t'uyut'oj pa taq ri ki tem. ");
INSERT INTO qucNNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ri Jesús aretaq xeril wa', xub'an u b'anik jun kolob' che u ch'ayib'al, xuchaplej kesaxik b'i konojel ri winaq ri' pa ri nimalaj rachoch Dios, junam kuk' ri ki chij, ri ki wakäx. Xujab'uj ri ki rajil ri k'exel taq puaq, xupaqchij apan ri ki mesa. ");
INSERT INTO qucNNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Xub'ij chke ri ajk'ay taq palomäx: ¡Chesaj b'i alaq ronojel wa' waral! Mäb'an alaq jun k'ayib'al che ri rachoch ri nu Tat, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Are k'u ru tijoxelab', xna'taj chke ru Loq' Pixab' ri Dios ri Tz'ib'talik, ri kub'ij: “Je' ta ne tajin käk'at ri wanima' rumal ri u loq'al ri achoch la,” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Te ri' ri winaq aj Israel xkita' che ri Jesús: ¿Jas etal käk'ut la chqawäch rech käqilo chi k'o taqanik pa q'ab' la chub'anik ronojel wa'? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Xch'aw ri Jesús, xub'ij chke: We ta ri alaq käwulij alaq ri nimalaj rachoch Dios ri', xa oxib' q'ij kinsachi na chuyakik wa' jumul chik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Xkib'ij k'u ri winaq aj Israel che: Kawinaq waqib' junab' xb'eytaj u b'anik wa' we nimalaj rachoch Dios ri', te k'u ri' käb'ij la chi xa choxib' q'ij käyak ta chi la jumul, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Are k'u ri nimalaj rachoch Dios ri xub'ij ri Jesús, are ru cuerpo ri Are'. ");
INSERT INTO qucNNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Rumal ri' aretaq xk'astaj ri Jesús chkixol ri käminaqib', xna'taj wa' we tzij ri' ri xub'ij ri Jesús chke ru tijoxelab', xkikoj k'ut ri kub'ij ru Loq' Pixab' ri Dios ri Tz'ib'talik, xuquje' xekojon che ru tzij ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Aretaq ri Jesús xk'oji pa Jerusalén pa ri nimaq'ij re ri Pascua, e k'ia xekojon che aretaq xkil ri kajmab'al taq etal ri xub'ano. ");
INSERT INTO qucNNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ri Jesús k'ut man xku'b'i tä u k'ux chkij rumal chi ri Are' retam ri k'o pa kanima' konojel winaq. ");
INSERT INTO qucNNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Man rajwaxik taj chi k'o jachin jun käb'in che ri käkichomaj ri winaq rumal chi ri Are' retam ri k'o pa taq ri kanima'. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","K'o jun tata' fariseo, Nicodemo u b'i'. Ri tata' ri' nim u b'anik chkixol ri winaq aj Israel. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ri tat Nicodemo xopan ruk' ri Jesús chaq'ab' chuch'ab'exik, xub'ij che: Ajtij, —xcha che. Qetam chi are ri Dios taqowinaq la loq che qa tijoxik rumal chi man k'o tä jun käkowin chuk'utik ri u chuq'ab' kuk' kajmab'al taq etal jas ri tajin käb'an la we ta mat k'o ri Dios ruk', —xcha che ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Te ri' ri Jesús xub'ij che: Qas tzij kinb'ij che la chi we jun winaq man kil chi na u wäch jumul chik, man kuya' taj ke'rila' jawije' ri kätaqan wi ri Dios, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ri tat Nicodemo xuta' che, xub'ij: ¿Jas ta k'u lo kub'an jun achi ri ri'j chik rech kil chi na u wäch jumul chik? ¿A käkowin ta k'u lo kok ri are' jumul chik chupam ru nan rech kil chi na u wäch chukamul? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ri Jesús xch'awik, xub'ij che: Qas tzij kinb'ij che la chi ri winaq ri man kil tä na u wäch ruk' joron, xuquje' ruk' ri Loq'alaj Espíritu, man kuya' taj kopan chila' jawije' ri kätaqan wi ri Dios, —kächa che. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ri winaq ri kalk'ualax kumal ru nan u tat, xaq winaq ri'. Are k'u ri winaq ri kalk'ualax rumal ri Loq'alaj Espíritu, ralk'ual ri Dios ri'. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mäkajmaj b'a' la chi kinb'ij che la: “Rajwaxik chi kil chi na u wäch jun winaq jumul chik,” —kächa che. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Je' jas ri kiäqiq' xa apawije' käjich'ich' wi, kätataj ru jininem, man q'alaj tä k'ut jawije' ri käpe wi, o jawije' ri ke' wi. Are k'u je ri' ri winaq ri kil u wäch rumal ri Loq'alaj Espíritu, —xcha ri Jesús che. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ri tat Nicodemo xuta' chi jumul che ri Jesús, xub'ij: ¿Jas k'u ru b'anik wa'? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ri Jesús xch'awik, xub'ij che: Ri lal, lal jun nimalaj ajtij pa Israel. ¿A mat käch'ob' la wa' ri tajin kinb'ij? —kächa che. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Qas tzij kinb'ij che la, chi ri uj käqab'ij ri qetam, käqaq'alajisaj k'u ri qilom. Are k'u ri alaq man käkoj tä alaq ri käqab'ij chech alaq. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","We man käkoj alaq ri kinb'ij chrij ri käk'ulmataj waral cho ruwächulew, ¿a are ta k'u lo käkoj alaq ri' we kintzijon chrij ri käk'ulmataj pa ri kaj? —kächa che. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Man k'o tä jun winaq paqalinaq b'i chila' chikaj, xane xaq xuwi ri qajinaq loq chikaj. Are k'u ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, —kächa ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Jas ri xb'antaj pa ri juyub' ri kätz'inowik aretaq ri qa mam Moisés xuyak ri jun kumätz re ch'ich' bronce puwi' jun che' chkiwäch ri winaq, je k'u ri' käb'an na chwe in, in ri' ri Ralk'ual ri Dios ri Qas Winaq. Kinyak na in chkiwäch ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Je ri' rech apachin ri käkojon chwe in man käsach tä u wäch, xane kuriq ri k'aslemal ri man k'o tä u k'isik, —xcha ri Jesús che ri tat Nicodemo. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ri Dios k'ut sib'alaj keraj ri winaq cho ruwächulew chi xusipaj loq ru K'ojol ri xaq xuwi wa' u K'ojol k'olik, rech apachin ri käkojon che ri Are' man käsach tä u wäch, xane kuriq ri k'aslemal ri man k'o tä u k'isik. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ri Dios man xutaq tä loq ru K'ojol cho ruwächulew chuq'atik tzij pa ki wi' ri winaq chi k'äjisaxik ki wäch, xane che ki to'ik. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Jachin ri käkojon che ru K'ojol ri Dios, man käq'at tä tzij puwi' chi käk'äjisax u wäch. Jachin k'u ri man käkojon tä che, ya q'atom chi tzij puwi' chi käk'äjisax u wäch rumal chi man käkojon tä che ru K'ojol ri Dios ri xaq xuwi u K'ojol wa' k'olik. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ri man kekojon taj q'atom chi tzij pa ki wi' chi käk'äjisax ki wäch rumal chi aretaq ri saqil xpe cho ruwächulew, ri winaq are utz xkil wi ri q'equm rumal chi man utz taj ri tajin käka'no. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Konojel ri käka'n etzelal käketzelaj u wäch ri saqil. Man käkaj tä k'u keqeb' cho ri saqil rumal chi man käkaj taj chi käq'alajin ri etzelal ri tajin käka'no. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Jachin k'u taq ri käka'n ri qas tzij, keqeb' ri' cho ri saqil rech käq'alajinik chi ronojel ri tajin käka'no are wa' ri kraj ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Te k'u ri' ri Jesús xel b'i chila', xe' pa Judea junam kuk' ru tijoxelab'. Naj k'ut xkanaj na chila' kuk' ri e are', xub'an k'u qasna'. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ri tat Juan xuquje' tajin kub'an qasna' pa Enón, chunaqaj ri Salim, jawije' k'o wi k'ia joron. Xeopan ri winaq ruk', xub'an k'u ki qasna'. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Mäja' k'u kok ri tat Juan pa che' aretaq xb'antaj wa'. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Te ri' xchaptaj jun ch'oj chkixol ru tijoxelab' ri tat Juan kuk' jujun aj Israel chrij ri resaxik ri äwas chkij. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Xe'kib'ij k'u che ri tat Juan: Ajtij, chilampe la chi ri Jun ri xk'oji uk' la chrelb'al q'ij che ri nima' Jordán, ri Jun ri xq'alajisaj la chqawäch, ri Are' tajin kub'an qasna' kämik, konojel k'u ri winaq tajin keb'e' ruk', —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ri tat Juan xub'ij chke: Man k'o tä jun winaq k'o jas käkowin chub'anik, we man yo'm che rumal ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ri ix, qas xita ri' jas ri xinb'ij, chi man in taj ri Cristo, xane xa in taqom loq nab'e chuwäch ri Are'. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Pa jun k'ulanem, ri k'amowinaq b'i ri ali are ri ala. Are k'u ri rachi'l ri ala ri k'o chila' kutatab'ej ri ala kätzijonik, käkikot k'u ruk' aretaq kuto. Je k'u ri' ri in kämik sib'alaj kinkikotik. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ri Are' rajwaxik are känimar na u q'ij, are k'u ri in, rajwaxik chi nojim man nim tä chik kinil wi, —xcha ri tat Juan chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ri Jun ri käpe chila' chikaj are k'o pa ki wi' konojel. Are k'u ri jun ri xaq ajuwächulew, xuwi kutzijoj ri käb'antaj waral cho ruwächulew. Are k'u ri Jun ri käpe chila' chikaj are k'o pa ki wi' konojel. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ri Are' k'ut, are kutzijoj ri rilom, ri u tom. Man k'o tä k'u jun kukojo jas ri kub'ij. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Jachin k'u ri kukojo, ruk' wa' kujikib'a u b'ixik chi ri Dios kub'ij ri qas tzij. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ri Jun ri taqom loq rumal ri Dios, kutzijoj ru Tzij ri Dios, rumal chi ri Dios man xaq tä jub'iq' ri Espíritu rech Are' u yo'm che. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ri Dios qa Tat loq' ru K'ojol chuwäch, u yo'm k'u ronojel pu q'ab'. ");
INSERT INTO qucNNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Jachin ri käkojon che ru K'ojol ri Dios k'o u k'aslemal ri man k'o tä u k'isik. Jachin k'u ri man kraj taj käkojon che ru K'ojol ri Dios, man k'o tä u k'aslemal ri', xane ri nimalaj royowal ri Dios käpe na puwi', käk'äjisax k'u na u wäch. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ri tata'ib' fariseos xketamaj chi ri Jesús e k'ia na ru tijoxelab' ri Are', xuquje' e k'ia na ri xb'an ki qasna' rumal ri Are' chuwäch ri xb'an ki qasna' rumal ri tat Juan. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Qas tzij k'ut, man are tä ri Jesús ri xb'anow ri qasna', xane e are ru tijoxelab' xeb'anowik. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Aretaq ri Jesús xuta wa', ri tajin käb'ixik, xel b'i pa Judea, xtzelej chik pa Galilea. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Pa ru tzelejik k'ut rajwaxik chi kok'ow pa taq ri juyub' re Samaria. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Xopan k'u pa jun tinimit re Samaria, Sicar u b'i', chunaqaj ri ulew ri u yo'm ri Jacob che rechb'al ri José ru k'ojol. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Chila' k'ut k'o wi ri k'ua' ri käb'ix “ru k'ua' ri Jacob” che. Ri Jesús kosinaq chik che ri b'inem, xt'uyi chuchi' ri k'ua'. Xa k'u jub'iq' man kuriq ri nik'iaj q'ij. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","E b'enaq k'u ru tijoxelab' pa ri tinimit chuloq'ik ri käkitijo, ");
INSERT INTO qucNNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","aretaq xopan jun ixoq aj Samaria chuchi' ri k'ua' chuk'amik u joron. Ri Jesús xub'ij che: Ya la jub'iq' nu joron, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Man käkich'ab'ej tä k'u kib' ri winaq aj Israel kuk' ri winaq aj Samaria, rumal ri' ri ixoq xub'ij che ri Jesús: ¿Jas che ri lal käta' la joron la chwe in? Ri lal k'ut, lal aj Israel. Ri in, in aj Samaria, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ri Jesús xch'awik, xub'ij che: We ta etam la jas ri kusipaj ri Dios, xuquje' we ta etam la jachin ri in ri tajin kinta' nu joron che la, ri lal qas tzij käta' la joron la ri' chwe in, kinya k'u na k'aslik joron che la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ri ixoq xub'ij che: Tat, man k'o tä ne jas käkoj la che resaxik ri joron, sib'alaj naj k'ut qajinaq ri k'ua'. ¿Jawije' ta k'u ne ke'k'ama wi la ri k'aslik joron ri käya la chwe? —kächa che. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ri Jacob ri qa mam ojer are yo'winaq kan wa' we k'ua' ri' chqe, ri xresaj wi u joron ri are', ri ralk'ual, xuquje' ri xresaj wi ki joron ri rawaj. ¿A lal ta k'ut ri nim na b'anik la chuwäch ri are'? —xcha ri ixoq che ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ri Jesús xch'awik, xub'ij che: Konojel ri käkitij ke we joron ri' kächaqi'j chi na ki chi' jumul chik. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Jachin k'u ri kutij re ri joron ri kinya in, man k'o tä chi na jumul kächaqi'j chi u chi'. Je ri', rumal chi ri joron ri kinya in che käb'ulb'ut na pa ranima' je' jas jun u k'iyib'al ja' ri kuya k'aslemal ri man k'o tä u k'isik, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ri ixoq xub'ij che: Tat, ya la we ri joron ri' rech man kächaqi'j tä chi nu chi', rech man rajwaxik tä chi kinpe chi waral chuk'amik nu joron, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ri Jesús xub'ij che: Oj b'a' la, jesik'ij la loq ri achajil la, käpe chi k'u na la waral, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ri ixoq xch'awik, xub'ij: Man k'o tä wachajil, —xcha che. Xub'ij k'u ri Jesús che: Tzij ri käb'ij la chi man k'o tä achajil la. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","E job' k'u ne ri achajil la e k'olinaq. Are k'u ri jun ri k'o uk' la kämik, man are tä qas achajil la. Qas tzij b'a' ri b'im la, —xcha ri Jesús che ri ixoq. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Aretaq xuta ri ixoq wa', xub'ij che ri Jesús: Tat, kinwilo chi lal jun q'alajisal re ru Loq' Pixab' ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ri qa mam uj ojer, ri uj aj Samaria, xkiq'ijilaj ri Dios waral pa we juyub' ri'. Are k'u ri alaq, ri alaq aj Israel, käb'ij alaq chi pa ri tinimit Jerusalén rajwaxik käq'ijilax wi ri Dios, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ri Jesús xch'awik, xub'ij: Nan, kojo b'a' la ri kinb'ij chi kopan na ri q'ij aretaq ri alaq käq'ijilaj na alaq ri qa Tat, man rajwaxik tä k'u na chi käpe alaq waral pa we juyub' ri' o chi ke' alaq pa Jerusalén chuq'ijilaxik ri qa Tat, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ri alaq, alaq aj Samaria man qas etam alaq jachin ri käq'ijilaj alaq. Are k'u ri uj qetam jachin ri käqaq'ijilaj, rumal chi ru tob'anik ri Dios käpetik kumal ri winaq aj Israel. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kuriq k'u na ri q'ij, are kämik k'ut, aretaq ri winaq ri qas tzij käkiq'ijilaj ri qa Tat, qas käkiq'ijilaj na ri Are' ruk' ru taqanik ri Loq'alaj Espíritu pa kanima'. Ri qa Tat k'ut, kraj chi je' käb'an wa' kumal ri winaq ri keq'ijilan che. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ri Dios are Espíritu, jachin k'u taq ri keq'ijilan che, rajwaxik qas tzij käkiq'ijilaj na ruk' ru taqanik ri Loq'alaj Espíritu pa kanima'. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ri ixoq xub'ij che: Ri in wetam chi käpe na ri Mesías ri xuquje' käb'ix Cristo che. Aretaq käpe ri Are', kuq'alajisaj na ronojel chqawäch, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ri Jesús xub'ij che: In ri', ri tajin kintzijon uk' la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Qas je' tajin kub'ij wa' ri Jesús aretaq xeopan ru tijoxelab'. Xkikajmaj k'ut chi tajin kätzijon ruk' jun ixoq. Man k'o tä k'u jun xukoch'o xuta' che ri Jesús jas ri kraj ri ixoq o jas ri tajin kub'ij che. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ri ixoq k'ut xuya kan ru q'eb'al, xe' pa ri tinimit, xub'ij chke ri winaq: ");
INSERT INTO qucNNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Chixsajmpe', jiliwila k'u jun achi ri u b'im chwe ronojel ri nu b'anom. ¿A mat are wa' ri Cristo? —xcha chke ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Xeb'el k'u b'i ri winaq pa ri tinimit, xeb'e' jela' jawije' k'o wi ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Are k'u ri tijoxelab' tajin käkib'ij che ri Jesús: Ajtij, woq b'a' la, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ri Jesús k'ut xub'ij chke: Ri in k'o ri nu wa ri kintijo ri man iwetam tä ix jasach, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ri tijoxelab' xkichaplej u ta'ik chb'il taq kib', xkib'ij: ¿A xa ta k'u lo k'o jachin xk'amow loq ri kutijo? —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ri Jesús xub'ij chke: Ri nu wa are ru b'anik ru rayib'al ri Jun ri xintaqow loq, ru k'isik k'ut ru chaplem loq u b'anik. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ri ix kib'ij: “Kraj na kiejeb' ik' ri cosecha.” Ri in k'ut kinb'ij chiwe: Chika'yej taq ri tiko'n, e chaqi'j chi k'ut, e utz chik che ri cosecha. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ri kächakun pa ri cosecha, käyi' na ri tojb'al re. Are k'u ri cosecha ri kuyako are re k'aslemal wa' ri man k'o tä u k'isik, rech ri ketiko'nijik, xuquje' ri keyakowik, junam kekikotik. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Qas tzij k'ut ri käb'ixik: “Jun winaq kätiko'nijik, are k'u jun winaq chik ri käyakowik,” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ri in xixintaq b'ik rech kiyak u wäch ri tiko'n ri man xiriq tä k'äx chutikik. Jule' winaq chik ri xechakunik, are k'u ri ix xaq xuwi kixkikot chuyakik u wäch ri ki tiko'n, —xcha chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","E k'ia k'u chke ri winaq pa ri alaj tinimit ri' re Samaria ri xekojon che ri Jesús rumal ri xub'an ri ixoq, xujikib'a k'u u b'ixik chke: “U b'im chwe ronojel ri nu b'anom,” —xcha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Je ri' chi aretaq xeopan ri winaq aj Samaria ruk' ri Jesús, xkib'ochi'j chi käkanaj na kan kuk'. Xkanaj k'u na kan kieb' q'ij kuk'. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","E k'ia k'u na ri xekojonik aretaq xkita ri tzij ri xub'ij ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Xkib'ij k'u che ri ixoq: Kämik käqakojo, man xuwi tä rumal ri xab'ij at chqe, xane rumal chi qa tom uj ri kub'ij. Qetam k'ut chi qas tzij are wa' ri Cristo ri To'l Ke ri winaq cho ruwächulew, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Churox q'ij ri Jesús xel b'i pa Samaria, xutaqej ru b'e, xe' pa Galilea. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Je ri', rumal chi jun q'alajisal re ru Loq' Pixab' ri Dios man nim tä kil wi ri are' pa ri qas u tinimit je' jas ri xub'ij ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Aretaq xopan pa Galilea ri winaq chila' utz u k'ulaxik xka'no. Ri e are' k'ut e petinaq pa ri nimaq'ij Pascua ri käb'an pa ri tinimit Jerusalén, kilom k'u ronojel ri u b'anom ri Are' chila' pa ri nimaq'ij. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Te ri' ri Jesús xe' chi jumul pa ri tinimit Caná pa Galilea jawije' ri xuk'ex wi ri joron pa vino. K'o k'u jun tata' chila' ri nim u b'anik pa ri tinimit Capernaum. Jun to'l re ri nim taqanel wa'. Yawab' k'u ri u k'ojol. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Aretaq ri tata' ri' xuto chi ri Jesús xpe pa Judea, xopan k'u pa Galilea, xe' ri are' che rilik. Xuta' toq'ob' che chi ke' cho rachoch chukunaxik ri u k'ojol, ri xa jub'iq' man käkämik. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ri Jesús k'ut xub'ij che: Ri alaq man käkojon tä alaq we ta mat kil alaq kajmab'al, xuquje' etal, —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Xub'ij k'u ri tata' ri nim u b'anik che: Tat, sa'j la chanim cho wachoch mäja' k'u käkäm ri nu k'ojol, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Xub'ij k'u ri Jesús che: ¡Oj la cho ja, käk'asi k'u na ri k'ojol la! —xcha che. Xukoj k'u ri tata' ri xb'ix che rumal ri Jesús, xe' k'ut. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Aretaq xa jub'iq' man kopan ri tata' cho rachoch, xepe ri patänil taq re chuk'ulaxik, xkib'ij k'u che: ¡K'asal ri k'ojol la! —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ri tata' xuta' chke jas hora xuchap rutzirik ri u k'ojol. Ri e are' xkib'ij che: Iwir pa ri nab'e hora re ri b'enaq q'ij xel ri q'aq' chrij, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ru tat ri ala xuch'ob'o chi pa ri hora ri' xub'ij ri Jesús che: “Ri k'ojol la käk'asi na,” —xcha ri Jesús. Xkojon k'u ri tata' che ri Jesús, xuquje' konojel ri e k'o pa rachoch. ");
INSERT INTO qucNNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Are wa' ri ukab' kajmab'al etal ri xub'an ri Jesús aretaq xtzelej loq pa Judea, xopan k'u pa Galilea. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Te k'u ri' ri winaq aj Israel xka'n jun ki nimaq'ij chik pa Jerusalén. Ri Jesús k'ut xe' chi na jumul jela'. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Pa ri tinimit Jerusalén chunaqaj ri uchib'e ri käb'ix “Uchib'e ri Keb'ok wi Chij” che, k'o jun atinib'al ri käb'ix Betesda che ru b'i' pa ri ch'ab'al hebreo. E k'o job' raqan ja chrij. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Pa taq ri raqan ja ri' e q'oyoq'oj k'ia yawab'ib'. E k'o moyab', ch'okojib', xuquje' winaq ri käminaq ki cuerpo. Tajin käkeyej chi käslab' ri joron. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Jun taq pa' k'ut käqaj loq jun ángel pa ri atinib'al, kuslab'isaj k'u ri joron. Jachin ri nab'e käqaj pa ri joron aretaq käslab'taj kan rumal ri ángel käkunataj che apachike u wäch yab'il ri k'o che. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","K'o k'u jun achi chila' ri xke' juwinaq lajuj ruk' wajxaqib' junab' yawab'. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Aretaq ri Jesús xrilo q'oyol cho ri ulew, xuquje' xretamaj chi k'ia junab' chik yawab', xuta' che: ¿A kaj la kutzir la? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ri yawab' xch'awik, xub'ij che: Tat, man k'o tä jun kinqasan pa ri atinib'al aretaq käslab' ri joron. Amaq'el aretaq kwaj kinqajik, jun chik käqaj b'i nab'e chnuwäch in, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ri Jesús xub'ij che: ¡Walij b'a' la, yaka la b'i ri sok la, b'in ya' la! —xcha ri Jesús che. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Chanim xutzir ri achi. Xuyak b'i ru sok, xuchaplej b'inem. Are k'u q'ij re uxlanem aretaq xb'antaj wa'. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ri winaq aj Israel xkib'ij che ri achi ri xutzirik: Kämik k'ut are q'ij re uxlanem. Man ya'tal taj kaweqaj b'i ra sok, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ri achi xch'awik, xub'ij chke: Ri jun ri xinkunanik xub'ij chwe: “¡Yaca la b'i ri sok la, b'in ya' la!” —xcha ri' chwe, —xcha ri achi chke ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ri e are' xkita' che, xkib'ij: ¿Jachin ri' ri xb'in chawe: “¡Yaca la b'i ri sok la, b'in ya' la!”? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Are k'u ri achi man xuch'ob' tä chi u wäch jachin ri xkunanik rumal chi ri Jesús xsach chkixol ri k'ialaj winaq ri e k'o chila'. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Te ri' ri Jesús xuriq ri achi pa ri nimalaj rachoch Dios, xub'ij che: ¡Chilampe la! —xcha'. Kämik ri lal utz chik. Mämakun chi b'a' la, mäpe chi ne jun k'äx chik chij la ri más nim na, —xcha ri Jesús che. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Xe' k'u ri achi, xub'ij chke ri winaq aj Israel chi ri xkunanik are ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Rumal ri' ri winaq aj Israel xkitzukuj u chapik ri Jesús rech käkikämisaj, rumal chi kub'an taq wa' we ri' pa ri q'ij re uxlanem. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Xub'ij k'u ri Jesús chke: Ri nu Tat amaq'el chakuninaq petinaq loq. Rajwaxik k'ut chi ri in xuquje' kinchakunik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Rumal ri' ri winaq aj Israel xa sib'alaj xpe na koyowal, xkaj xkikämisaj ri Jesús rumal chi man nim tä xril wi ri kub'ij ri Pixab' chrij ri q'ij re uxlanem. Man xuwi tä k'u ri', xane xuquje' xujunamaj rib' ruk' ri Dios aretaq xub'ij chi ri Dios Are ru Tat. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Te ri' ri Jesús xub'ij chke: Qas tzij kinb'ij chech alaq chi ri u K'ojol ri Dios man käkowin taj k'o jas kub'ano xaq pa re wi. Xuwi kub'ano jachike ri kärilo chi kub'an ri u Tat. Ronojel ri kub'an ri u Tat, kub'an k'u ri u K'ojol xuquje'. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ri qa Tat sib'alaj loq' ri u K'ojol chuwäch, kuk'ut k'u chuwäch jachike ri kub'an ri Are'. Kuk'ut k'u na nimaq taq kajmab'al chuwäch ru K'ojol, ri sib'alaj käkajmaj na alaq. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Je' jas ri qa Tat keuk'astajisaj ri käminaqib', kuya k'u ki k'aslemal, je ri' xuquje' ri u K'ojol kuya k'aslemal chke jachin taq ri kraj kuya wi. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ri qa Tat man kuq'at tä tzij puwi' jachin jun, xane u yo'm ronojel u wäch taqanik pu q'ab' ru K'ojol rech ri Are' käq'atow tzij. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Je ri' rech konojel ri winaq käkiya u q'ij ri u K'ojol ri Dios junam jas ri käka'n chuya'ik u q'ij ri qa Tat. Jachin ri man kuya tä u q'ij ri u K'ojol ri Dios, man kuya tä ri' u q'ij ri qa Tat ri xutaq loq ri Are'. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Qas tzij kinb'ij chech alaq chi jachin ri kutatab'ej ri nu tzij, käkojon k'u che ri Dios ri xintaqow loq, kuriq na ri' ri k'aslemal ri man k'o tä u k'isik. Man käq'at tä k'u tzij puwi' chi käk'äjisax u wäch rumal chi elinaq chik pa ri kämikal re ri ojer k'aslemal, k'o chik ri qas u k'aslemal. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Qas tzij kinb'ij chech alaq chi käpe na ri q'ij, kämik k'ut ri q'ij ri' aretaq ri käminaqib' käkita na chi kinch'awik, in ri' ri u K'ojol ri Dios. Jachin taq ri käkinimaj ri kinb'ij kek'asi na. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ri qa Tat k'o kuinem pu q'ab' pa re wi chuya'ik k'aslemal, xuquje' u yo'm pa nu q'ab' in, in ri' ri u K'ojol, chi kinkowinik kinya k'aslemal. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Xuquje' u yo'm taqanik pa nu q'ab' rech kinq'at tzij rumal chi ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mäkajmaj alaq wa' rumal chi kopan na ri q'ij aretaq konojel ri käminaqib' käkita na chi kinch'awik. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Keb'el na loq pa taq ri muqub'al. Ri ka'nom ri utzil kek'astajik rech käk'oji na ki k'aslemal. Are k'u ri ka'nom ri man utz taj kek'astajik rech käq'at na tzij pa ki wi' chi käk'äjisax na ki wäch. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ri in man k'o tä jas kinkowin chub'anik xaq pa we wi. Ri in kinq'at tzij xa jas ri kintaq wi. Jikom k'u kinb'an in chuq'atik tzij. Man are tä k'u kinb'an xa jas ri kwaj in, xane are kinb'an jas ri kraj ri nu Tat ri xintaqow loq. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","We ri in kinq'alajisaj ri qas tzij chwij chb'il wib', man k'o tä u patän ri' ri kinb'ij. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","K'o k'u Jun chik ri k'o jas kuq'alajisaj chwij, wetam k'ut chi ri kub'ij ri Are' chwij are qas tzij. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ri alaq xtaq alaq u ta'ik che ri tat Juan. Ri xub'ij k'u ri are' chech alaq are qas tzij. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ri in k'ut man are tä ku'l nu k'ux chrij ri kuq'alajisaj jun winaq chwij. Xuwi kinb'ij wa' rech ri alaq käriq na alaq ru tob'anik ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ri tat Juan are junam ruk' jun chäj o jun candela ri käk'atik, ri käjuluwik. Ri alaq k'ut xkikot alaq kieb' oxib' q'ij ruk' ri saqil ri'. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","K'o k'u na ri käk'utuwik chi qas tzij ri kinb'ij. Are utz na wa' chuwäch ri xuq'alajisaj ri tat Juan chwij. Ri tajin kinb'ano, are wa' ri xinutaq ri nu Tat chub'anik. Are k'u wa' ri käk'utuwik chi qas tzij are ri nu Tat ri in taqowinaq loq. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Xuquje' ri nu Tat ri xintaqow loq kuq'alajisaj ri qas tzij chwij, pune ta ne ri alaq man tom tä alaq ri Are' käch'awik, man ilom tä k'u alaq u wäch. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Man qajinaq tä k'u ru Tzij ri Dios pa anima' alaq rumal chi man käkojon tä alaq che ri Jun ri taqom loq rumal ri qa Tat. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ri alaq na'l käsik'ij alaq u wäch ru Loq' Pixab' ri Dios ri Tz'ib'talik rumal chi kächomaj alaq chi chila' käriq wi alaq ri käyo'w ri k'aslemal ri man k'o tä u k'isik. Are k'u ru Loq' Pixab' ri Dios ri Tz'ib'talik ri kuq'alajisaj ri qas tzij chwij in. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pune je ri', ri alaq man kaj tä alaq käpe alaq wuk' rech käriq alaq we k'aslemal ri' ri man k'o tä u k'isik. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ri in man kwaj taj chi käyi' nu q'ij kumal ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Wetam k'u in ri anima' alaq, wetam chi man kaj tä alaq ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ri in, in petinaq chuk'exwäch ri nu Tat. Ri alaq k'ut man xink'ulaj tä alaq. Are k'u we ta käpe jachin jun chik xaq pa re wi, ¡are ri are' käk'ulaj na alaq! ");
INSERT INTO qucNNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿A käkowin lo alaq ri' käkojon alaq chwe we xa kätzukuj alaq u ya'ik q'ij alaq chb'il taq ib' alaq, man are tä kätzukuj alaq chi käyi' q'ij alaq rumal ri Dios ri xaq xuwi Dios wa' k'olik? ");
INSERT INTO qucNNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mächomaj alaq chi ri in kinchap u b'ixik ri man utz taj chij alaq cho ri nu Tat. Ri käb'in na wa' chij alaq are ri qa mam Moisés, ri ku'b'am k'ux alaq chrij. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","We ta ri alaq qas xkojon alaq che ri xub'ij ri qa mam Moisés, käkojon ta k'u alaq ri' chwe in rumal chi ri qa mam Moisés k'o ri u tz'ib'am chwij in. ");
INSERT INTO qucNNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","We k'u man xkojon alaq che ri xutz'ib'aj ri are', ¿jas ta k'u lo käb'an alaq chukojik ri kinb'ij in? —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Te k'u ri' ri Jesús xq'ax ch'äqäp che ri mar ri käb'ix “Mar re Galilea” che, ri xuquje' käkoj “Mar re Tiberias” che ru b'i'. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","E k'ia winaq k'ut xeteri b'i chrij ri Jesús rumal chi kilom ri kajmab'al taq etal ri xub'ano aretaq xeukunaj taq ri yawab'ib'. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Te ri' xpaqi ri Jesús puwi' jun juyub', chila' k'ut xt'uyi wi junam kuk' ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Xa k'u jub'iq' kraj man kuriq ri nimaq'ij ri käb'ix “Pascua” che, jun chke ri ki nimaq'ij ri winaq aj Israel. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Aretaq ri Jesús xeril ri k'ialaj winaq ri e b'enaq ruk', xub'ij che ri tat Felipe: ¿Jawije' ta ne keqaloq' wi ri wa ri käqaya chke ri k'ialaj winaq ri'? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Xub'ij wa' ri Jesús xa rech kärilo jas kub'ij ri tat Felipe. Qas retam k'u ri Are' jas ri kub'an na. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Xch'aw k'u ri tat Felipe, xub'ij: Kieb' cientos quetzales kaxlan wa man kub'an tä ri' rech k'o ju taq b'iq' ke konojel chkijujunal, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Are k'u ri tat Andrés, ratz ri tat Simón Pedro, jun chke ru tijoxelab' ri Jesús, xub'ij che: ");
INSERT INTO qucNNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Waral k'o wi jun ala ruk'am job' kaxlan wa re cebada ruk' kieb' kär. ¿Jas ta k'u lo u patän wa' che ki tzuqik ri k'ialaj winaq ri e k'olik? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Xub'ij k'u ri Jesús chke ru tijoxelab': Chib'ij chke konojel ri winaq chi ket'uyi'k, —xcha chke. Sib'alaj k'ia k'u ri räx q'ayes k'o cho ri juyub' ri', xet'uyi k'ut. Kraj e k'o job' mil achijab'. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Te ri' ri Jesús xeuk'am ri kaxlan wa. Aretaq xetewchitaj wa' rumal, xeuya chke ru tijoxelab', ri tijoxelab' chik xekijach wa' chkiwäch konojel ri winaq ri e t'uyut'oj. Xuquje' je' xub'an chke ri kär, xeuya chke jampa' ri xkaj. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Aretaq e nojinaq chik, ri Jesús xub'ij chke ru tijoxelab': Cheiyaka ri ch'äqataq ri xekanaj kanoq rech man xaq tä keb'e' pa mes, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Xekiyak k'ut, xekinojisaj kab'lajuj chikäch kuk' ri ch'äqataq ri xekanaj kan chke ri job' kaxlan wa re cebada. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ri winaq, aretaq xkil we kajmab'al etal ri' ri xub'an ri Jesús, xkib'ij: Qas tzij are wa' ri q'alajisal re ru Loq' Pixab' ri Dios ri käb'ixik chi käpe na cho ruwächulew, —xecha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ri Jesús k'ut xrilo chi käkaj käkikoj ki chuq'ab' chuk'amik b'ik rech käkikoj che nim taqanel pa ki wi', rumal k'u ri' xa xel b'i chkiwäch, xe' chi jumul puwi' ri juyub' rech käk'oji chila' u tukiel. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Aretaq chaq'ab' chik, ru tijoxelab' ri Jesús xeqaj b'i chuchi' ri mar. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Xeb'ok k'u pa jun barco, xkichaplej b'inem puwi' ri mar rech keq'ax pa Capernaum. Sib'alaj q'equm chik, ri Jesús k'ut mäja' kätzelej loq pa ri juyub'. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Xaq te'talik xpe jun nimalaj kiäqiq'. Xewalij k'u nimaq taq uwoja' puwi' ri mar rumal. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Aretaq ki b'inib'em chi job' o waqib' kilómetros, xkil ri Jesús petinaq tajin käb'in puwi' ri ja'. Naqaj chik k'o wi che ri barco, xkixej k'u kib' che. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Are k'u ri Jesús xub'ij chke: ¡In ri', mixej b'a' iwib'! —xcha ri' chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Te ri' ri e are' xekikotik, xkib'ij che ri Jesús chi käpaqi kuk' pa ri barco. Chanim k'ut xeopan pa ri tinimit jawije' ri b'enam wi ke. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Chukab' q'ij ri winaq ri xekanaj kan ch'äqäp che ri mar xkilo chi ri tijoxelab' xeb'e' pa ri jun barco ri xuwi barco wa' k'o chila', man xe' tä k'u ri Jesús kuk'. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Xuriqa k'ut chi xeopan nik'iaj barcos chik ri ki petik pa ri tinimit Tiberias. Xeopan chila' chunaqaj ri uwosaq jawije' ri winaq xkitij wi ri kaxlan wa aretaq xmaltioxitaj wa' rumal ri Qajaw Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Je ri' chi ri winaq aretaq xkilo chi man k'o tä chi ri Jesús chila', xuquje' chi man e k'o tä chi ru tijoxelab', xeb'ok pa taq ri barcos, xeb'e' k'u pa ri tinimit Capernaum chutzukuxik ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Aretaq ri winaq xeopan ch'äqäp che ri mar, xkiriq ri Jesús, xkita' k'u che, xkib'ij: Ajtij, ¿jampa' xul la waral? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Xub'ij k'u ri Jesús chke: Qas tzij ri kinb'ij chech alaq chi ri alaq kintzukuj alaq xa rumal chi xwi' alaq, xnoj k'u alaq. Man kintzukuj tä alaq rumal chi käch'ob' alaq u b'eyal ri kajmab'al taq etal ri kinb'ano. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mok il alaq chutzukuxik ri wa ri xa käsach u wäch, xane are rajwaxik chi kok il alaq chutzukuxik ri wa ri man käsach tä u wäch, ri kuya chech alaq ri qas k'aslemal ri man k'o tä u k'isik. Are wa' ri wa ri kinya na in chech alaq, in ri' ri Ralk'ual ri Dios ri Qas Winaq. Rumal wa' u k'utum ri Dios qa Tat chi ruk' Are' in petinaq wi, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Te ri' ri winaq xkita' che ri Jesús, xkib'ij: ¿Jas k'u ri' ri rajwaxik käqa'no rech kujkowinik käqa'no jachike ri kraj ri Dios? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ri Jesús xch'awik, xub'ij chke: Ri kraj ri Dios chi käb'an alaq are la' chi käkojon alaq che ri Jun ri u taqom loq, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Xkita' chi che ri Jesús, xkib'ij che: ¿Jas u wäch etal käb'an la chqawäch rech käqilo, kujkojon k'u che la? ¿Jas ri käkowin la chub'anik? —kecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ri qa nan qa tat ojer xkitij ri maná pa ri juyub' ri kätz'inowik, je' jas ri kub'ij ru Loq' Pixab' ri Dios ri Tz'ib'talik: “Ri Dios xuya chutijik ri ki wa ri xpe chila' chikaj,” —xecha che ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Xch'aw k'u ri Jesús, xub'ij chke: Qas tzij ri kinb'ij chech alaq chi man are tä ri qa mam Moisés ri xyo'w ri wa chke ri käpe chila' chikaj, xane are ri nu Tat ri käyo'w ri qas wa ri käpe chila' chikaj. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ri wa ri kuya ri Dios are wa' ri qajinaq loq chikaj, ri kuya ri qas k'aslemal chke konojel winaq, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Xkib'ij k'u che ri Jesús: Tat, ya la qe ri wa ri' amaq'el ronojel q'ij, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ri Jesús xub'ij chke: In ri' ri wa ri kuya ri qas k'aslemal. Jachin ri käpe wuk', man k'o tä jumul ri känum chik. Jachin ri käkojon chwe man k'o tä jumul ri kächaqi'j chi u chi'. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nu b'im chi k'u chech alaq chi ri alaq man käkojon tä alaq chwe pune ilom alaq nu wäch. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Konojel ri keyi' chwe rumal ri nu tat kepe na wuk' in. Apachin k'u ri kepe wuk' man keintzelejisaj tä b'ik. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ri in k'ut man xinpe tä chila' chikaj xa chub'anik jachike ri kwaj in, xane chub'anik ru rayib'al ri xintaqow loq. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ri u rayib'al ri nu Tat ri xintaqow loq are la' chi man k'o tä jun chke ri xeuya chwe ri kintzaqo, xane chi keink'astajisaj na chkixol ri käminaqib' pa ri k'isb'al q'ij. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ri u rayib'al ri xintaqow loq are la' chi konojel ri käkil nu wäch in, in ri' ri u K'ojol ri Dios, kekojon k'u chwe, käkiriq ri k'aslemal ri man k'o tä u k'isik. Keink'astajisaj k'u na in chkixol ri käminaqib' pa ri k'isb'al q'ij, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ri winaq aj Israel, aretaq xkita wa' we tzij ri', xkichap u b'ixik k'äx taq tzij chrij ri Jesús rumal ri xub'ij: “In ri' ri wa ri käpe chila' chikaj,” —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Xkib'ij k'ut: ¿A mat are wa' ri Jesús ru k'ojol ri tat José? Ri uj qetam ki wäch ru nan u tat. ¿Jas lo wa' ri kub'ij chi petinaq chila' chikaj? —xecha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Are k'u ri Jesús xub'ij chke: ¡Tanal alaq che ri yoq'onik! —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Man k'o tä jun ri kuya' käpe wuk' in we ta mat käk'am loq rumal ri nu Tat ri xintaqow loq. Ri in k'ut kink'astajisaj na chkixol ri käminaqib' pa ri k'isb'al q'ij, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kub'ij pa taq ri wuj ri xkitz'ib'aj ri q'alajisal taq re ru Loq' Pixab' ojer: “Ri Dios kuya na tijonik chke konojel,” —kächa ri'. Rumal ri' konojel ri käkitatab'ej ri kub'ij ri qa Tat, k'o k'u ri käketamaj na ruk', kepe na ri e are' wuk' in, —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Are qas tzij chi man k'o tä jun winaq ilowinaq u wäch ri qa Tat. Ri Jun ri ilowinaq u wäch are xaq xuwi ri petinaq ruk' ri Dios, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Qas tzij ri kinb'ij chech alaq chi jachin ri käkojon chwe in k'o na ru k'aslemal ri man k'o tä u k'isik. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","In ri' ri wa ri qas kuya k'aslemal, —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ri nan tat alaq ojer xkitij ri wa ri käb'ix “maná” che pa ri juyub' ri kätz'inowik, konojel k'ut xekämik. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Are k'u ri in tajin kintzijoj chech alaq jas ri' ri qas wa ri petinaq chila' chikaj. Jachin k'u ri kutij re we wa ri', man käkäm tä ri', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","In k'u ri' ri k'aslik wa, ri qajinaq loq chikaj. Jachin ri kutij re we wa ri', käk'asi na pa taq ri q'ij ri junab' ri kepetik. Ri wa ri kinya in are ri nu cuerpo. Kinya wa' rech k'o ri ki k'aslemal konojel winaq cho ruwächulew, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ri winaq aj Israel xkichaplej u tzijob'exik kib' chkixol, xkib'ij: ¿Jas ta k'u lo kub'an we achi ri' chuya'ik ru tijal chqe pa tijik? —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ri Jesús xub'ij chke: Qas tzij ri kinb'ij chech alaq chi we ri alaq man kätij tä alaq ri nu cuerpo, in ri' ri Ralk'ual ri Dios ri Qas Winaq, man kätij tä alaq ri nu kik'el, te k'u ri' man käk'oji tä na ri k'aslemal alaq ri'. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Jachin ri kutij ri nu cuerpo xuquje' kutij ri nu kik'el, k'o k'u u k'aslemal ri man k'o tä u k'isik. Ri in k'ut kink'astajisaj na chkixol ri käminaqib' pa ri k'isb'al q'ij. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ri nu cuerpo k'ut are ri qas wa, ri nu kik'el are qas je' jas ri vino ri kätijowik. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Jachin ri kutij ri nu cuerpo, xuquje' kutij ri nu kik'el qas käk'oji ri are' wuk' in, ri in xuquje' qas kink'oji ruk' are'. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ri nu Tat ri xintaqow loq k'o u k'aslemal. Ri in xuquje' in k'asal rumal ri Are'. Je ri' xuquje' jachin ri kutzuq rib' chwe in, käk'asi na wumal in. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Are tajin kintzijon chrij ri wa ri petinaq chila' chikaj. We wa ri' man junam tä ruk' ri maná ri xkitij ri nan tat alaq ojer, xekäm k'u ri e are'. Are k'u ri kutij re we wa ri' käk'asi na pa taq ri q'ij ri junab' ri kepetik, —xcha ri Jesús chke ri winaq aj Israel. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ri Jesús xub'ij wa' we tzij ri' chke ri winaq ri ki mulim kib' pa ri rachoch Dios pa Capernaum che ki tijoxik. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Aretaq xkita wa' we tijonik ri', e k'ia chke ri winaq ri e k'o ruk' xkib'ij: Sib'alaj k'äx wa' ri tzij ri xub'ij. ¿Jachin ta lo ri käkowinik kutatab'ej? —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ri Jesús k'ut xretamaj chi k'äx tajin kech'aw chrij rumal ri tzij ri xub'ij, xuta' k'u chke: ¿A tzel käta alaq ri xinb'ij? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Jas k'u ri käk'ulmataj ri' we ta kinil alaq in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, kintzelejik kinpaqi k'u chikaj jawije' ri in k'o wi nab'e? ");
INSERT INTO qucNNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ri Loq'alaj Espíritu are ri käyo'w ri k'aslemal. Ri cuerpo xaq u tukiel man k'o tä u patän. Ri tzij k'ut ri nu b'im chech alaq e are' qas tzij ri kepe ruk' ri Dios, xuquje' käkiya k'aslemal. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","E k'o k'u jujun chech alaq ri man kekojon taj, —xcha chke. Qas k'u retam ri Jesús petinaq loq jachin taq ri man kekojon tä che, xuquje' jachin ri' ri käjachow na. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Xub'ij k'ut: Rumal ri' nu b'im chech alaq chi man k'o tä jun ri kuya' käpe wuk' in we ta mat käk'am loq rumal ri nu Tat. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tzare chi' k'ut e k'ia chke ri e k'o ruk' ri Jesús xkiya kanoq, man xek'oji tä k'u ruk'. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Te ri' ri Jesús xuta' chke ri kab'lajuj u tijoxelab', xub'ij: ¿A kiwaj ix xuquje' kixe' kuk'? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Xch'aw k'u ri tat Simón Pedro, xub'ij: Qajaw, ¿jachin chi ruk' kuje' wi? Ri tzij la e are tzij ri käkiya k'aslemal ri man k'o tä u k'isik. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ri uj, uj kojoninaq che la, qetam chi lal ri' ri Cristo, ru K'ojol ri k'aslik Dios, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ri Jesús xch'awik, xub'ij: ¿A mat ix kab'lajuj xixincha' rech kixk'oji wuk'? Pune je ri' jun chiwe are k'o ri Itzel pa ranima', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ri Jesús aretaq xub'ij wa' are tajin käch'aw chrij ri Judas Iscariote ru k'ojol ri tat Simón. Je ri', rumal chi ri tat Judas are ri käjachow na, pune are jun chke ri kab'lajuj u tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Te k'u ri' ri Jesús xub'inib'ej ri Galilea. Man kraj taj käk'oji pa Judea rumal chi ri winaq aj Israel käkaj käkikämisaj. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Xa k'u jub'iq' kraj man kuriq ri nimaq'ij ke ri Käb'al, jun chke ri ki nimaq'ij ri winaq aj Israel. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ru chaq' ri Jesús xkib'ij che: Mat kanaj waral. Jat pa Judea rech xuquje' ra tijoxelab' ri e k'o chila' käkil na ri kajmab'al ri kab'ano. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","We jun winaq kraj chi qas ketamax u wäch, man kub'an tä ri' chik'uyal ri kub'ano. We ri at kab'an taq ri kajmab'al ri', chab'ana wa' chkiwäch konojel ri winaq, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Q'alaj k'ut chi ru chaq' ri Jesús xa man xekojon tä che. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Te ri' xub'ij ri Jesús chke: Ri in mäja' kuriq ri q'ij chwe, are k'u ri ix apachike q'ij utz chiwe kuya' kixe'k. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ri winaq ajuwächulew man kekowin taj käketzelaj i wäch ix. Are k'u ri in käketzelaj nu wäch rumal chi kinq'alajisaj chkiwäch chi man utz tä ri käka'no. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ri ix k'ut, jix pa ri nimaq'ij. Ri in man kine' taj, rumal chi mäja' kuriq ri q'ij chwe. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Aretaq xb'itaj wa' we tzij ri' chke, xkanaj ri Are' pa Galilea. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Aretaq k'ut e b'enaq chi ru chaq' ri Jesús pa ri nimaq'ij, ri Are' xuquje' xe' na pa ri nimaq'ij, pune man xuk'ut tä rib' chkiwäch ri winaq. Xane xaq chik'uyal xe' ri Are'. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ri winaq aj Israel xkitij u tzukuxik pa ri nimaq'ij, xkib'ij: ¿Jawije' k'o wi ri achi ri'? —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Chkixol k'u ri winaq, k'ia ri käb'ix chrij ri Jesús. Jujun käkib'ij: “Are jun utzalaj achi,” —kecha'. Nik'iaj chik käkib'ij: “Man are tä utzalaj achi, rumal chi keusub' ri winaq,” —kecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Man k'o tä k'u jun ri kukoch'o käresaj u tzijol ri Jesús rumal chi käkixej kib' chkiwäch ri ki nimaqil ri winaq aj Israel. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nik'iajirinaq chi k'u ri nimaq'ij aretaq ri Jesús xok b'i pa ri nimalaj rachoch Dios, xuchaplej k'u ki tijoxik ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Are k'u ri winaq aj Israel sib'alaj tajin käkikajmaj wa', xkib'ij: ¿Jas lo wa' chi sib'alaj k'ia retam we achi ri', man k'o tä k'u jawije' u tijom wi rib'? —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ri Jesús xch'awik, xub'ij chke: Ri tijonik ri kinya man wech tä in, xane rech ri Jun ri xintaqow loq. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","We k'o jun qas kurayij u b'anik ri kraj ri Dios, käretamaj na we ri nu tijonik qas käpe ruk' ri Dios, o xaq pa we wi kintzijonik. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ri winaq ri xaq pa re wi kätzijonik, xa are kraj ri' chi känimarisax u q'ij kumal ri winaq. Jachin k'u ri kraj chi are känimarisax u q'ij ri xtaqow loq, kub'ij ri' ri qas tzij, man are tä jun b'anal tzij, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿A mat qas tzij chi ri qa mam Moisés xuya ri Pixab' chech alaq? Pune je ri', man k'o tä k'u jun chech alaq ri kunimaj ri Pixab' ri'. ¿Jas che kaj alaq kinkämisaj alaq? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ri winaq xech'awik, xkib'ij: ¡Xa k'o jun itzel espíritu chawe! ¿Jachin lo ri kraj katkämisanik? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ri Jesús xub'ij chke: Xa ruk' jun kajmab'al ri xinb'an pa ri q'ij re uxlanem, ri alaq sib'alaj käkajman alaq che. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ri qa mam Moisés xunaq'atajisaj alaq chukojik retal ri ojer trato. Pune ta ne man are tä ri are' xchapow loq u b'anik wa', xane are ki tijonik kan ri nan tat alaq ojer. Ri alaq k'ut käkoj alaq retal ri ojer trato che jun alaj ala pune pa ri q'ij re uxlanem. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","We k'u ri alaq rumal ri u nimaxik ri Pixab' ri xutz'ib'aj ri qa mam Moisés käkoj alaq retal ri ojer trato che ri ala pune pa ri q'ij re uxlanem, ¿jas k'u che xpe oyowal alaq chwe in aretaq xinkunaj ronojel ru cuerpo jun achi pa ri q'ij re uxlanem? —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","K'o jas mäb'ij alaq chrij ri winaq we utz käpetik o man utz tä käpetik. Aretaq k'o jas käb'ij alaq chrij jun winaq chik, qas chomaj na alaq jas ri käb'an alaq, b'ana k'u alaq wa' ruk' jikomal. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Te k'u ri' jujun chke ri winaq aj Jerusalén xkichapla u ta'ik, xkib'ij: ¿A mat are wa' we achi ri' ri tajin kätzukuxik rech käkämisaxik? —kecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Chiwilampe', kätzijon kuk' ri winaq, man k'o tä k'u jun k'o jas kub'ij che. ¿A xa ta k'u lo qas käkikoj ri q'atal taq tzij chi we achi ri' are ri Cristo? —kecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ri uj k'ut qetam jawije' petinaq wi wa' we achi ri'. Aretaq k'ut käpe ri' ri Cristo, man k'o tä jun ri' etamaninaq jawije' käpe wi, —xecha ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Aretaq ri Jesús, ri tajin kuya tijonik pa ri nimalaj rachoch Dios, xuta wa' ko xch'awik, xub'ij: Käb'ij alaq chi etam alaq nu wäch, xuquje' chi etam alaq jawije' chi' kinpe wi. Man in petinaq tä k'ut xaq pa we wi, xane in taqom loq rumal ri Jun ri qas jikom ranima'. Ri alaq k'ut man etam tä alaq u wäch. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ri in wetam u wäch rumal chi in petinaq ruk', xuquje' are ri Are' in taqowinaq loq, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Xkaj k'ut xkik'am b'i pa che', man k'o tä k'u jun xchapowik rumal chi mäja' kuriq ru q'ij. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","E k'ia k'ut xekojon che, xkib'ij k'ut: Aretaq käpe ri Cristo, ¿a kub'an ta k'u lo más kajmab'al taq etal chik chuwäch ri u b'anom we achi ri'? —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ri tata'ib' fariseos xkita ri käkib'ij ri winaq chrij ri Jesús. Xa je ri' ri e are' kuk' ri ki nimaqil sacerdotes xekitaq b'i jujun chajinelab' re ri nimalaj rachoch Dios chuk'amik b'i ri Jesús pa che'. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Te ri' xub'ij ri Jesús: Xaq kieb' oxib' q'ij chik kink'oji na uk' alaq, te k'u ri' kintzelej na ruk' ri xintaqow loq. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ri alaq kintzukuj na alaq, man kinriq tä chi k'u alaq rumal chi man käkowin tä alaq kopan alaq chila' jawije' ri kinek'ol wi in, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ri ki nimaqil ri winaq aj Israel k'ut, xkichaplej u ta'ik chb'il taq kib', xkib'ij: ¿Jawije' ta k'u ke' wi wa' we achi ri' chi man kujkowin tä uj keqariqa'? ¿A xa ta k'u lo ke' kuk' ri winaq aj Israel ri e jab'uninaq chkixol ri winaq aj Grecia che ki tijoxik ri winaq aj Grecia? ");
INSERT INTO qucNNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Jas kel kub'ij wa' ri xub'ij chqe: “Kintzukuj na alaq, man kinriq tä chi k'u alaq rumal chi man käkowin tä alaq kopan alaq chila' jawije' ri kinek'ol wi”? —xcha ri', —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Pa ri k'isb'al q'ij re ri nimaq'ij, ri q'ij ri sib'alaj nim na u b'anik, ri Jesús xtak'i aq'anoq chkixol ri winaq, ko xch'awik, xub'ij: We k'o jun kächaqi'j u chi', chpet wuk', chutija u joron. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Je' jas ri kub'ij ru Loq' Pixab' ri Dios ri Tz'ib'talik: Jachin ri käkojon chwe, käk'iy na loq pa ranima' joron ri kuya ri qas k'aslemal, —kächa', —xcha ri Jesús chke ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ri Jesús k'ut, are tajin käch'aw chrij ri Loq'alaj Espíritu ri käkik'am na ri winaq ri kekojon che ri Are'. Mäja' k'u käyi' loq ri Loq'alaj Espíritu rumal chi mäja' kätzelej ri Jesús chila' chikaj rech känimarisax u q'ij. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jujun chke ri winaq, aretaq xkita ri xub'ij ri Jesús, xkib'ij: Qas tzij we achi ri' are wa' ri q'alajisal re ru Loq' Pixab' ri Dios ri käb'ixik chi käpe na, —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Nik'iaj chik xkib'ij: Are wa' ri Cristo, —xecha'. Nik'iaj chi k'ut xkib'ij: ¿A xa ta k'u lo pa Galilea käpe wi ri Cristo? ");
INSERT INTO qucNNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ru Loq' Pixab' ri Dios ri Tz'ib'talik kub'ij chi ri Cristo rajwaxik chkixol ri rachalaxik ri qa mam David ri nim taqanel käpe wi na. Pa Belén k'ut käpe wi na, ri tinimit ri xk'oji wi ri qa mam David, —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Je k'u ri' ri winaq xkitasala kib' rumal rech ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","E k'o jujun ri xkaj xkik'am b'i pa che', man k'o tä k'u jun xchapowik. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Xetzelej k'u ri chajinelab' re ri nimalaj rachoch Dios, xeopan chila' jawije' e k'o wi ri tata'ib' fariseos xuquje' ri ki nimaqil ri sacerdotes. Ri e are' k'ut xkita' chke: ¿Jas che man xik'am tä loq ri Jesús? —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ri chajinelab' xech'awik, xkib'ij: ¡Man k'o tä jun achi qa tom je' kätzijonik jas ri kätzijon ri achi ri'! —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Are k'u ri tata'ib' fariseos xkib'ij chke: Ri ix xuquje' xa xiya iwib' pa sub'ik. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿A k'o pu lo jun chke ri qa nimaqil ri kojoninaq che, o jun ne chke ri tata'ib' fariseos? ¡Man k'o taj! —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Xkik'iäq itzel tzij pa ki wi', xkib'ij: ¡We winaq ri' man ketam tä ri Pixab'! —xecha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Are k'u ri tat Nicodemo ri xopan ruk' ri Jesús chaq'ab', are jun chke ri tata'ib' fariseos. Xub'ij k'u chke: ");
INSERT INTO qucNNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Ri qa Pixab' kub'ij chi man kuya' taj käqaq'at tzij puwi' jun winaq chi käk'äjisax u wäch we ta mat nab'e käqata na jas ri kub'ij che retamaxik jas ri u b'anom, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Te ri' xech'aw ri e are', xkib'ij che ri tat Nicodemo: E k'u ri lal, ¿a lal aj Galilea xuquje'? —xecha che. Na'l sik'ij la ru Loq' Pixab' ri Dios ri Tz'ib'talik, kil k'u na la chi man k'o tä jun q'alajisal re ru Loq' Pixab' ri Dios ri petinaq pa Galilea, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Chkijujunal k'ut xeb'e' cho taq kachoch. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Are k'u ri Jesús xe' pa ri nimalaj juyub' ri käb'ix “Olivos” che. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Aretaq xsaqir chukab' q'ij, ri Jesús xtzelej loq, xe' pa ri nimalaj rachoch Dios. Konojel ri winaq xkimulij kib' ruk'. Ri Are' k'ut xt'uyi'k, xuchaplej ki tijoxik. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Te ri' ri tijonelab' re ri Pixab' xuquje' ri tata'ib' fariseos xkik'am loq jun ixoq ri xkiriqo tajin kub'an ri nimalaj mak ri äwas u b'anik chrij ri rachajil. Xkiya k'u chkixol ri winaq ri e k'o chila'. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Xkib'ij k'u che ri Jesús: Ajtij, we ixoq ri' xriqtajik tajin kub'an ri nimalaj mak ri äwas u b'anik chrij ri rachajil. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ri Pixab' ri xutz'ib'aj ri qa mam Moisés kub'ij chi rajwaxik käqakämisaj chab'aj jun ixoq ri je' kub'an wa'. E ri lal, ¿jas k'u käb'ij la? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Xkib'ij wa' che xaq rech käqaj pa ki q'ab', je k'u ri' kekowinik käkib'ij chi k'o u mak ri Jesús. Are k'u ri Jesús xa xpachi'k, xuchaplej tz'ib'anik cho ri ulew ruk' ri u wi' u q'ab'. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Xkitaqej k'u u k'otik u chi' ri Jesús. Xa je ri' ri Are' xujikomaj rib', xub'ij k'u chke: Apachin chech alaq ri man k'o tä u mak, chuk'iäqa ri nab'e ab'aj chrij we ixoq ri', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Xpachi chi jumul ri Jesús, xutaqej tz'ib'anik cho ri ulew. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Aretaq k'ut xkita ri xub'ij ri Jesús, xkina' kib' pa kanima' chi k'o ki mak. Chkijujunal k'ut xkichap elem b'ik. Nab'e xeb'el b'i ri ri'jab'. Aretaq konojel e elinaq chi b'ik, xaq xuwi chi ri Jesús k'o kanoq ruk' ri ixoq ri kanajinaq kan chila'. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Te ri' ri Jesús xujikomaj rib'. Man k'o tä k'u jun xrilo, xane xaq xuwi ri ixoq. Ri Are' xub'ij che: Nan, ¿jawije' e k'o wi ri käkib'ij chi k'o mak la? ¿A mat k'o jun xkanaj kan chuq'atik tzij puwi' la chi käk'äjisax wäch la? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ri ixoq xub'ij che ri Jesús: Man k'o tä jun, Tat, —xcha che. Are k'u ri Jesús xub'ij che: Ri in xuquje' man kinq'at tä tzij puwi' la chi käk'äjisax wäch la. ¡Oj b'a' la chanim, mämakun chi k'u la! —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Xtzijon chi jumul ri Jesús kuk' ri winaq, xub'ij chke: In ri', ri in kinya saqil chke ri winaq cho ruwächulew. Jachin ri käpe wuk', käk'oji na ri saqil ruk' ri kuya k'aslemal, man käb'in tä chi k'u pa ri q'equm, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Te ri' ri tata'ib' fariseos xkib'ij che ri Jesús: Ri lal xaq tukiel la tajin käq'alajisaj la ri utz chij ib' la. Rumal ri' ri tajin käq'alajisaj la man k'o tä u patän, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ri Jesús xch'awik, xub'ij chke: Ri tajin kinq'alajisaj chwij in, qas tzij k'o u patän, pune xaq nu tukiel kinq'alajisaj ri utz chwij chb'il wib'. Wetam k'ut jawije' ri in petinaq wi, xuquje' jawije' ri kine' wi. Ri alaq k'ut man etam tä alaq jawije' ri kinpe wi, man etam tä k'u alaq jawije' ri kine' wi. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ri alaq je' käq'atow tzij alaq jas ri keq'atow tzij ri winaq ajuwächulew. Ri in k'ut man kinq'at tä tzij puwi' jachin jun. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","We k'u kinq'at tzij, jikom kinb'an chuq'atik tzij. Je ri', rumal chi man xaq tä nu tukiel kinq'at tzij, xane ri nu Tat ri xintaqow loq Are kuq'at tzij junam wuk'. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Pa ri Pixab' alaq tz'ib'tal wi chi aretaq kieb' winaq junam ri käkib'ij chrij ri xkilo o chrij ri xkito, rajwaxik ri' käkojik chi qas tzij ri käkib'ij. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ri in k'ut kinq'alajisaj ri qas tzij chwij chb'il wib', xuquje' ri nu Tat ri xintaqow loq kuq'alajisaj ri qas tzij chwij, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Te ri' ri tata'ib' fariseos xkita' che ri Jesús: ¿Jawije' k'o wi ri tat la? —xecha che. Ri Jesús xch'awik, xub'ij chke: Ri alaq man qas tä etam alaq nu wäch, xuquje' man etam tä alaq u wäch ri nu Tat. We ta qas etam alaq nu wäch in, etam ta alaq u wäch ri' ri nu Tat xuquje', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ri Jesús xub'ij wa' we tzij ri' aretaq tajin kuya tijonik pa ri nimalaj rachoch Dios chunaqaj ri k'olib'al re taq ri kuchuj. Man k'o tä k'u jun xk'amow b'i pa che' rumal chi mäja' kuriq ru q'ij. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ri Jesús xch'aw chi jumul, xub'ij chke: Ri in kine'k. Ri alaq k'ut kintzukuj na alaq. Pa ri mak alaq k'ut käkäm wi alaq, rumal chi man käkowin tä alaq ke' alaq chila' jawije' ri kine' wi, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Te ri' ri winaq aj Israel xkib'ij: ¿A xa ta lo kukämisaj rib', rumal k'u ri' kub'ij chi man kujkowin taj kuje' chila' jawije' ri ke' wi? —xecha ri e are'. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Te ri' xub'ij ri Jesús chke: Ri alaq, xaq alaq ajwaral, are k'u ri in chila' chikaj kinpe wi. Ri alaq, xaq alaq ajuwächulew. Are k'u ri in man in ajuwächulew taj. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Rumal ri' xinb'ij chech alaq chi pa ri mak alaq käkäm wi alaq. Rumal chi we man käkoj tä alaq chi in ri' ri tajin kinb'ij, pa ri mak alaq käkäm wi na alaq, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Te ri' xkita' che ri Jesús, xkib'ij: ¿Jachin k'u ri lal? —xecha che. Ri Jesús xch'awik, xub'ij chke: Ojer ri' nu b'im chech alaq jachin ri in, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","K'ia ri kwaj kinb'ij chech alaq chrij ri tajin kinwilo chuq'atik tzij chrij ri käb'an alaq. Are k'u ri xintaqow loq kub'ij ri qas tzij. Ri in k'ut, jachike ri nu tom chuchi' ri Are', are wa' ri kinb'ij chke ri winaq ajuwächulew, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ri e are' k'ut man xkich'ob' taj chi ri Jesús are tajin käch'aw chrij ri qa Tat chila' chikaj. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Rumal ri' xub'ij chke: Aretaq ri in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, kinyak na chikaj umal alaq chkiwäch ri winaq, ketamaj k'u na alaq chi In Ri'. Man k'o tä k'u jas kinb'ano xaq pa we wi, xane xaq xuwi kinb'ij ri u k'utum ri qa Tat chnuwäch, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Are k'u ri xintaqow loq k'o wuk' in. Ri nu Tat man in u yo'm tä kan nu tukiel rumal chi amaq'el ronojel q'ij are kinb'an ri utz käril wi ri Are', —xcha chke ri winaq aj Israel. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Aretaq ri Jesús xub'ij wa' we tzij ri', e k'ia xekojon che ri Are'. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Xub'ij k'u ri Jesús chke ri winaq aj Israel ri xekojon che: We ri alaq kätaqej alaq u b'anik ri nu b'im chech alaq, qas tzij alaq nu tijoxelab', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ketamaj k'u na alaq ri qas tzij, ri qas tzij k'ut kub'ano chi tzoqopital chi alaq, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ri winaq aj Israel xech'awik, xkib'ij: Ri uj are qa mam ri Abraham ojer, man uj kojom tä k'u xaq che patänil re jun winaq. ¿Jas lo wa' chi käb'ij la chqe chi kujtzoqopitaj na? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ri Jesús xub'ij chke: Qas tzij kinb'ij chech alaq chi konojel ri kemakunik e kojom ri' che patänil taq re ri mak. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Jun ri kojom che patäninel man are tä qas ajpaja. Are k'u ri u k'ojol ri rajaw ja qas ajpaja ri' amaq'el ronojel q'ij. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Je k'u ri', we ri in, in u K'ojol ri Dios kintzoqopin chech alaq, qas tzij ri' chi tzoqopital chi alaq, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ri in wetam chi ri mam alaq are ri Abraham ojer. Kaj k'u alaq kinkämisaj alaq rumal chi man käkoj tä alaq ri kinb'ij chech alaq. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ri in are kinb'ij ri u k'utum ri nu Tat chnuwäch. Are k'u ri alaq are käb'an alaq jachike ri b'im chech alaq rumal ri tat alaq, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ri e are' xech'awik, xkib'ij: Ri qa tat uj are ri qa mam Abraham ojer, —xecha'. Ri Jesús xub'ij chke: We ta qas tzij are tat alaq ri qa mam Abraham, are ta käb'an alaq ri' jas ri xub'an ri are'. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pune nu b'im ri qas tzij chech alaq ri u k'utum ri Dios chnuwäch, ri alaq kaj alaq kinkämisaj alaq. Ri qa mam Abraham man k'o tä jumul ri je' xub'an wa'. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ri alaq k'ut je' käb'an alaq jas ri kub'an ri tat alaq, —xcha ri Jesús chke. Ri e are' k'ut xkib'ij che: Ri uj, man uj alk'ualaxelab' taj ri mat q'alaj u wäch qa tat. Ri qa Tat xa jun k'olik, are k'u ri Dios, —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ri Jesús k'ut xub'ij chke: We ta qas tzij chi ri Dios are Tat alaq, kinaj ta alaq ri' rumal chi ri in ruk' ri Dios in petinaq wi, waral k'ut in k'o wi. Man in petinaq taj xaq pa we wi, xane are ri Dios xintaqow loq. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Jas che ri alaq man käkowin tä alaq chuch'ob'ik ri kinb'ij? Xa rumal chi man kaj tä alaq kätatab'ej alaq ri nu tzij. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ri tat alaq are ri Itzel. Ri alaq, alaq rech ri are', are k'u kaj alaq käb'an alaq jachike ri kraj ri are'. Ri Itzel are jun kämisanel ojer loq. Ri are' man kub'an tä ri qas tzij, man kub'ij tä k'u ri qas tzij. Aretaq kub'an tzij, are kub'ij ri u b'anik ri are'. Are jun b'anal tzij, ki tat k'ut ri b'anal taq tzij. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ri in k'ut kinb'ij ri qas tzij, rumal k'u ri' ri alaq man käkoj tä alaq ri nu tzij. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Jachin chech alaq käkowinik kuq'alajisaj chi qas tzij k'o mak nu b'anom? We k'u kinb'ij ri qas tzij, ¿jas k'u che man käkoj tä alaq ri kinb'ij? ");
INSERT INTO qucNNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Apachin ri rech ri Dios kutatab'ej ri' ru Tzij ri Dios. Are k'u ri alaq man alaq tä rech ri Dios. Rumal ri' man kaj tä alaq kätatab'ej alaq ru Tzij ri Dios, —xcha ri Jesús chke ri winaq aj Israel. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ri winaq aj Israel xkib'ij che ri Jesús: Qas tzij ri xqab'ij aretaq xqab'ij chi ri lal, xa lal aj Samaria, xuquje' chi ri lal k'o jun itzel espíritu che la, —xecha che ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ri Jesús xch'awik, xub'ij chke: Man k'o tä jun itzel espíritu chwe. Ri tajin kinb'ano, xa tajin kinya u q'ij ri nu Tat, are k'u ri alaq xa kesaj alaq nu k'ixb'al. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ri in k'ut man kwaj taj chi käyi' nu q'ij, pune ta ne k'o Jun ri kraj chi käyi' nu q'ij, kuq'at k'u na tzij ri Are' pa ki wi' ri käketzelaj nu wäch. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Qas tzij kinb'ij chech alaq chi jachin ri kunimaj ri kinb'ij, man käkäm tä na ri are', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Te ri' ri winaq aj Israel xech'awik, xkib'ij: Kämik qas xel chi saq chqawäch chi xa k'o jun itzel espíritu che la, —xecha che ri Jesús. Ri qa mam Abraham, xuquje' konojel ri q'alajisal taq re ru Loq' Pixab' ri Dios xekämik, te k'u ri' käb'ij la: “Jachin ri kunimaj ri kinb'ij man käkäm taj,” —kächa la. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿A lal ta k'ut nim na ri q'ij la chuwäch ri qa mam Abraham? Ri are' xkämik, xuquje' xekäm ri q'alajisal taq re ru Loq' Pixab' ri Dios. ¿Jachin ta k'u ri lal ri käb'an che ib' la? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ri Jesús xch'awik, xub'ij chke: We ta xaq in kinya nu q'ij chb'il wib', man k'o tä u patän ri'. Are k'u ri käyo'w nu q'ij are ri nu Tat, ri käb'ij alaq chi are Dios alaq. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ri alaq k'ut man etamam tä alaq u wäch. Ri in qas tzij wetam u wäch. We ta kinb'ij chi man wetam tä u wäch, in b'anal tzij ta ri' je' jas ri alaq. Ri in k'ut qas tzij wetam u wäch, kinnimaj k'ut ri kub'ij. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ri Abraham ri mam alaq xkikotik aretaq xuto chi käril na ri nu q'ij. Xril k'ut, qas k'u xkikotik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ri winaq aj Israel xkib'ij che ri Jesús: Mäja' ne nik'iaj ciento junab' la, te k'u ri' käb'ij la chi xil la u wäch ri qa mam Abraham, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ri Jesús xch'awik, xub'ij: Qas tzij kinb'ij chech alaq chi ri in, in k'o chik ojer, k'ä mäjoq käk'oji ri Abraham, —xcha chke ri winaq aj Israel. ");
INSERT INTO qucNNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Xepe k'u ri winaq aj Israel, xkik'am ab'aj rech käkik'iäq chrij ri Jesús. Ri Are' k'ut, xuk'u' rib' chkiwäch, xel loq pa ri nimalaj rachoch Dios, xok'ow chkixol ri winaq, xe'k. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ri Jesús b'enaq pa ri b'e aretaq xril jun achi ri moy tzaretaq xil u wäch. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ru tijoxelab' xkita' che ri Jesús: Ajtij, —xecha che. ¿Jas che moy we achi ri' tzaretaq xil u wäch? ¿A xa rumal ri ki mak ru nan u tat o xa rumal ru mak ri are'? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ri Jesús xub'ij chke: Man rumal tä rech ru mak ri are', man rumal tä k'u rech ri ki mak ru nan u tat, xane rech rumal ri are' käq'alajin ri käkowin ri Dios chub'anik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Chanim ri' ri k'o na ri q'ij, rajwaxik chi kinb'an na ri xintaq chub'anik rumal ri xintaqow loq. Kok k'u na ri aq'ab' aretaq man k'o tä chi jun käkowinik kächakunik. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Pa taq we q'ij ri' aretaq in k'o cho ruwächulew, ri in kinya saqil chke ri winaq ajuwächulew, —xcha ri Jesús chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Aretaq xb'itaj wa' we tzij ri' rumal ri Jesús, xutzaq u chub' pulew, xub'an jub'iq' xoq'ol ruk' ru chub', xub'il k'u chrij taq ru waq'äch ri moy. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Te k'u ri' xub'ij che: ¡Oj la! Ch'aja la ri wäch la pa ri atinib'al ri käb'ix “Siloé” che. (We b'i'aj ri' kel kub'ij “Taqom”.) Ri moy achi xe'k, xuch'aj ru wäch. Aretaq xtzelej loq, xkowinik xka'y chik. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Are k'u ri u k'ul taq ja, xuquje' ri winaq ri ketamam u wäch chi moy nab'e, xkib'ij: ¿A mat are wa' we achi ri' ri kät'uyi chi' taq ri b'e chuta'ik u limosna? —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Jujun xkib'ij: Je', are wa', —xecha'. Nik'iaj chik xkib'ij: Man are taj. Xaq k'u junam kel ruk', —xecha'. Are k'u ri achi ri moy kan nab'e xub'ij: Je', in ri', —xcha chke ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Te ri' ri winaq xkita' che ri achi: ¿Jas lo wa' chi katkowin chik katka'yik? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ri are' xch'awik, xub'ij chke: Ri achi ri Jesús u b'i' xub'an jub'iq' xoq'ol, xub'il chrij taq ri nu waq'äch, te k'u ri' xub'ij chwe: “Oj la chi' ri atinib'al ri käb'ix “Siloé” che, ch'aja la ri wäch la chila',” —xcha chwe. Xine' k'ut. Aretaq xch'ajtaj ri nu wäch, xinkowinik xinka'yik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Te ri' ri winaq xkib'ij: ¿Jawije' k'o wi ri achi ri'? —xecha che. Ri are' xub'ij chke: Man wetam taj, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Te ri' xkik'am b'i ri achi ri moy kan nab'e, xekiya chkiwäch ri tata'ib' fariseos. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Are k'u jun q'ij re uxlanem aretaq ri Jesús xub'an ri jub'iq' xoq'ol, xukunaj ri achi ri moy. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ri tata'ib' fariseos xuquje' xkita' che ri achi chi jas lo wa' chi käkowin chik käka'yik. Ri are' xub'ij chke: Xub'il xoq'ol chrij taq ri nu waq'äch, te k'u ri' xinch'aj ri nu wäch. Kinka'y chi k'u kämik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Te ri' jujun chke ri tata'ib' fariseos xkib'ij: Ri achi ri xb'anow wa' we kunanik ri' man rech tä ri Dios, rumal chi man nim tä käril wi ri q'ij re uxlanem, —xecha'. Nik'iaj chi k'ut xkib'ij: ¿Jas ta k'u lo wa' chi käkowinik kub'an taq we kajmab'al etal ri' we ta qas tzij ajmak? —xecha'. Je ri' chi man xjunamataj tä ri ki chomanik, xkitasala k'u kib'. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Xkita' chi k'u jumul che ri achi ri moy kan nab'e: E ri at, ¿jas kab'ij at chrij ri achi ri xkunan ra waq'äch? —xecha che. Ri are' k'ut xub'ij: Ri in kinb'ij chi are jun q'alajisal re ru Loq' Pixab' ri Dios, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Are k'u ri winaq aj Israel man xkikoj taj chi ri achi ri' are wa' ri moy kan nab'e, kämik k'ut käka'y chik. K'ä te' xkikojo aretaq xesik'ix na loq ru nan u tat ri achi ri xkunatajik. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Xkita' k'u chke: ¿A are wa' ri alk'ual alaq ri käb'ij alaq chi moy xil u wäch? ¿Jas lo wa' chi kämik käkowin chik käka'yik? —xecha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ru nan u tat xech'awik, xkib'ij: Qetam chi are wa' ri qalk'ual ri moy xil u wäch. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Man qetam tä k'ut jas wa' chi kämik käkowin chik käka'yik, man qetam tä k'u jachin ri xkunan ru waq'äch. Ta' alaq che ri are'. Achi chi ya', kub'ij k'u na chech alaq jas wa' chi käkowin chik käka'yik, —xecha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Je wa' xkib'ij ru nan u tat rumal chi xa xkixej kib' chkiwäch ri winaq aj Israel. Ri e are' k'ut ki chomam chik junam chi jachin ri kukojo chi ri Jesús are ri Cristo käkesaj na b'i pa ri rachoch Dios. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Rumal ri' ru nan u tat ri achi ri xkunax ru waq'äch xkib'ij: “Ta' alaq che ri are'. Achi chi ya',” —xecha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Te k'u ri' ri winaq aj Israel xkisik'ij chi jumul ri achi ri moy kan nab'e, xkib'ij che: Chab'ij b'a' ri qas tzij chqe chuwäch ri Dios. Ri uj qetam chi ri achi ri' are jun ajmak, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ri achi xch'awik, xub'ij chke: Ri in man wetam taj we are jun ajmak o man are taj, xuwi wetam chi nab'e kanoq in moy, kämik k'ut kinka'y chik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Xkita' chi k'u jumul che: ¿Jas xub'an chawe? ¿Jas xub'an chukunaxik ri a waq'äch? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Xch'aw ri achi, xub'ij chke: Xinb'ij chech alaq, ri alaq k'ut xa man käta tä alaq. ¿Jas che kaj alaq chi kinb'ij wa' jumul chik? ¿A xa kaj alaq kok alaq che u tijoxel? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Te ri' ri e are' xkitze'j u wäch, xkib'ij k'u che: Ri at, at jun ruk' we achi ri', are k'u ri uj, uj jun ruk' ri qa mam Moisés. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ri uj qetam chi ri Dios xch'aw ruk' ri qa mam Moisés. Are k'u we achi ri' man qetam taj jawije' ri käpe wi, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ri achi k'ut xch'awik, xub'ij chke: ¡Ko'l ta ne ri'! Ri alaq man etam tä alaq jawije' käpe wi, ri in k'ut xukunaj ri nu waq'äch. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Qas qetam chi ri Dios man kuta tä ri ki tz'onob'al toq'ob' ri ajmakib', xuwi kuta ri ki tz'onob'al toq'ob' ri winaq ri keq'ijilan che, ri käka'n ru rayib'al. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Man k'o tä jumul qa tom käb'ixik chi k'o jun käkowin chukunaxik ru waq'äch jun achi ri moy xil u wäch. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","We ta ri achi ri' mat ruk' ri Dios petinaq wi, mat k'o jas käkowin ri' chub'anik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Te ri' xkib'ij che: Ri at, xa at ajmak xil a wäch. ¿A are kawaj kujatijoj? —xecha che. Xkesaj k'u b'ik pa ri rachoch Dios. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ri Jesús xretamaj chi xesax b'ik ri achi ri moy kan nab'e. Aretaq ri Jesús xuriqo, xub'ij che: ¿A käkojon la che ru K'ojol ri Dios? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ri achi xub'ij che: Tat, b'ij la chwe jachin ri' rech ri in kinkojon che, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ri Jesús xch'awik, xub'ij che: Ilom chi la u wäch wa'. In ri', ri tajin kintzijon uk' la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Te k'u ri' ri achi xxuki chuwäch ri Jesús, xub'ij che: Kinkojon che la, Qajaw, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Xub'ij k'u ri Jesús: Ri in, in petinaq cho ruwächulew chuq'atik tzij, rech ri moyab' käjaqtaj ri ki waq'äch, xuquje' rech ri keka'yik kekanaj moy, —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Te ri' jujun chke ri tata'ib' fariseos ri e k'o chila' ruk' ri Are', aretaq xkita ri xub'ij ri Jesús, xkib'ij che: ¿A uj moy ta k'u lo uj xuquje'? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ri Jesús xch'awik, xub'ij chke: We ta alaq moy, mat k'o mak alaq ri'. Rumal k'u rech chi käb'ij alaq chi käka'y alaq, k'o mak alaq, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Qas tzij kinb'ij chech alaq chi jachin ri man kok tä b'i chuchi' ri ki corral ri chij, xane xa kutzukuj jawije' kunim wi b'i rib', ri achi ri' xa jun elaq'om, jun t'orinel. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Are k'u ri kok b'i chuchi' ri corral are ajyuq' ri', ri chajil ke ri chij. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ri chajil u chi' ri corral kujaq ri' chuwäch rech kokik. Ri chij k'ut käkich'ob' u wäch aretaq käch'awik. Ri ajyuq' keusik'ij ru chij chkijujunal ruk' ri ki b'i', keresaj k'u b'i pa ri corral. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Aretaq e resam chi b'ik konojel ri chij pa ri corral, känab'ej b'i chkiwäch, are k'u ri chij keteri b'i chrij rumal chi käkich'ob' u wäch aretaq käch'awik. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Man keteri tä k'u chrij jun winaq ri man ketam tä u wäch, xane xa keanimaj chuwäch rumal chi man käkich'ob' taj aretaq käch'aw jun winaq ri man ketam tä u wäch, —xcha ri Jesús chke ri winaq aj Israel. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ri Jesús xukoj wa' we k'utb'al ri' chkiwäch, ri e are' k'ut man xkich'ob' taj jas ri xraj xub'ij chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Te ri' ri Jesús xub'ij chi jumul chke: Qas tzij kinb'ij chech alaq. Ri in, in ru chi' ri corral ri keb'ok wi b'i ri chij. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Konojel ri nab'e xeb'ul chnuwäch in, e elaq'omab' ri', e t'orinelab'. Ri chij k'ut man xkitatab'ej taj ri xkib'ij. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ri in, in ru chi' ri corral. Jachin ri wumal in kok pa ri corral kuriq ru tob'anik ri Dios. Ri winaq ri' junam ruk' jun chij ri kok pa ri corral, te k'u ri' kel b'ik, kuriq utzalaj echa'. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ri elaq'om xuwi petinaq rech kerelaq'aj b'i ri chij, keukämisaj, kusach ki wäch. Ri in k'ut in petinaq chuya'ik ki k'aslemal, rech k'o ki k'aslemal ri qas utz na. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","In ri' ri utzalaj ajyuq'. Ri utzalaj ajyuq' kuya ru k'aslemal pa kämikal rumal kech ri chij. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Are k'u ri ajyuq' ri xuwi kuchomaj ri tojb'al re, aretaq kärilo käpe ri utiw, keuya kan ri chij, kanimajik. Je ri' kub'ano rumal chi man are tä qas kajyuq' ri chij, xuquje' ri chij man e rech tä ri are'. Käpe k'u ri utiw keuchap ri chij, keujab'uj. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ri achi ri' kanimajik rumal chi xuwi kuchomaj ri tojb'al re. Man kerilij tä ri chij. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","In ri' ri utzalaj ajyuq', wetam ki wäch ri nu chij, xuquje' ri e are' ketam nu wäch in. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Je' jas ri nu Tat retam nu wäch in, ri in xuquje' wetam u wäch ri nu Tat. Kinya k'u ri nu k'aslemal pa kämikal rumal kech ri chij. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Xuquje' e k'o chi nik'iaj nu chij ri man e k'o tä pa we corral ri'. Rajwaxik k'ut keink'ama na loq xuquje'. Ri chij ri' käkinimaj na ri kinb'ij. Xa k'u jumulaj chij käk'oji na, xuquje' xa jun ri kajyuq'. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ri qa Tat kinraj in rumal chi kinya ri nu k'aslemal pa kämikal, kink'astaj chi k'u na rech käk'oji chik ri nu k'aslemal. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Man k'o tä jun kesan ri nu k'aslemal chwe, xane ri in pa wanima' käpe wi kinya ri nu k'aslemal. Pa nu q'ab' k'o wi ru ya'ik ri nu k'aslemal, xuquje' pa nu q'ab' k'o wi ru k'amik jumul chik. Are wa' ri xintaq wi rumal ri nu Tat, —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Aretaq ri winaq aj Israel xkita wa' we tzij ri', xkichapla u tasik kib' jumul chik. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","E k'ia chke xkib'ij: ¿Jas che kätatab'ej alaq ri kub'ij? We achi ri' k'o jun itzel espíritu che, xuquje' ch'ujarinaq wa', —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Nik'iaj chi k'ut xkib'ij: Man k'o tä jun winaq ri k'o jun itzel espíritu che ri je' kätzijon wa' we ri'. ¿A käkowin pu lo jun itzel espíritu kujaq ri ki waq'äch ri moyab'? —xecha'. ¡Man kuya' taj! —xecha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Pa taq ri q'ij ri' xuriq ri q'alaj. Are chi' tajin käb'an ri nimaq'ij pa ri tinimit Jerusalén, natab'al re ri q'ij ri xk'is u yakik ri nimalaj rachoch Dios, xjach k'u pu q'ab' ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ri Jesús tajin käwakat pa ri nimalaj rachoch Dios, pa ri raqan ja re Salomón. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Xepe k'u ri winaq aj Israel xkimulij kib' chrij, xkib'ij che: ¿K'ä jampa' kujya la pa saq? We lal ri' ri Cristo, b'ij b'a' la ri qas tzij kämik, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ri Jesús xch'awik, xub'ij chke: Ya nu b'im chik. Ri alaq k'ut man käkoj tä alaq ri xinb'ij. Ronojel ri u taqom ri nu Tat chwe chi kinb'ano, are käk'utuw na ruk' saqil. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ri alaq k'ut man käkojon tä alaq rumal chi ri alaq man jun tä kuk' ri nu chij, jas ri xinb'ij chech alaq nab'e. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ri nu chij ketam nu wäch aretaq kinch'awik. Ri in xuquje' wetam ki wäch, keteri k'u chwij. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ri in kinya k'aslemal chke ri man k'o tä u k'isik. Man käsach tä ki wäch, man k'o tä k'u jachin keesan pa nu q'ab'. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ri nu Tat, ri nim na u q'ij chkiwäch konojel, are ri xeyo'w chwe. Man k'o tä k'u jachin jun keesan pu q'ab' ri Are'. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ri in, xuquje' ri nu Tat, xa uj jun, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Te ri' ri winaq aj Israel jumul chik xkik'am ab'aj rech käkik'iäq chrij ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ri Jesús xub'ij chke: K'ia u wäch utzil nu b'anom chuwäch alaq rumal ru chuq'ab' ri nu Tat. ¿Rumal k'u jachike chke we utzil ri nu b'anom kink'iäq alaq chab'aj? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ri winaq aj Israel xech'awik, xkib'ij: Man käqak'iäq tä la chab'aj rumal jun chke ri utzil ri b'anom la, xane rumal chi b'im la ri äwas u b'ixik chrij ri Dios. Ri lal xaq lal jun achi, b'anom k'u ib' la chi lal Dios, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ri Jesús k'ut xub'ij chke: Pa ri Pixab' alaq tz'ib'tal wi ri xub'ij ri Dios: “Ri ix, ix dioses,” —kächa', —xcha ri Are'. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Qetam chi ri kub'ij ru Loq' Pixab' ri Dios ri Tz'ib'talik, man kuya' taj käsach u wäch. Ri Dios xub'ij “dios” chke ri winaq ri xekojon che ru Loq' Pixab'. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","We ri Dios xinucha' in, te k'u ri' xinutaq loq cho we uwächulew, ¿jas lo wa' ri käb'ij alaq chi nu b'im ri äwas u b'ixik chrij ri Dios rumal chi xinb'ij chi in u K'ojol ri Dios? ");
INSERT INTO qucNNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","We man kinb'ano jachike ri kub'an ri nu Tat, ri alaq man rajwaxik taj käkojon alaq chwe. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","We k'u kinb'ano, pune b'a' man käkojon tä alaq chwe, kojon b'a' alaq che ri kinb'ano rech je ri' qas ketamaj alaq, xuquje' käkoj alaq chi ri qa Tat k'o pa wanima' in, xuquje' ri in, in k'o pa ranima' ri qa Tat. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Jumul chik are ta xkaj xkik'am b'i pa che'. Ri Jesús k'ut xresaj rib' pa ki q'ab'. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Te ri' ri Jesús xe' jumul chik ch'äqäp che ri nima' Jordán chrelb'al q'ij jawije' ri xub'an wi qasna' ri tat Juan nab'e, xkanaj k'u chila'. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","E k'ia winaq k'ut xeb'e' che rilik, xkib'ij k'ut: Qas tzij ri tat Juan, pune man xub'an tä kajmab'al taq etal, ronojel ri xub'ij chrij we achi ri' are qas tzij, —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","E k'ia winaq k'ut xekojon che ri Jesús chila'. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","K'o jun achi yawab', Lázaro u b'i', ri käpe pa ri tinimit Betania, ri tinimit ri e jeqel wi ri nan María xuquje' ri nan Marta ri ratz. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","We nan María ri', ri ranab' ri tat Lázaro ri yawab', are wa' ri xq'ijow ri k'ok'alaj aceite chrij ri raqan ri Qajaw Jesús, ri xusu' k'u ruk' ru wi'. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","We kieb' ixoqib' ri' ri kachalal kib', xkitaq u b'ixik che ri Jesús: Qajaw, ri Lázaro ri sib'alaj utz la ruk', yawab' ri are', —xecha b'ik. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Aretaq xuta ri Jesús wa', xub'ij: Ri kämikal ri kuk'am loq we yab'il ri' man are tä k'isb'al re ru k'aslemal, xane xa rech käq'alajinik chi nim u q'ij ri Dios, xuquje' rech rumal we yab'il ri' käk'utunik chi nim u q'ij ru K'ojol ri Dios, —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ri Jesús, pune sib'alaj loq' ri nan Marta chuwäch, xuquje' ru chaq', xuquje' ri tat Lázaro, ");
INSERT INTO qucNNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","aretaq xb'ix che chi yawab' ri tat Lázaro, xkanaj na kan kieb' q'ij chila' jawije' ri k'o wi. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Te k'u ri' xub'ij chke ru tijoxelab': Jo' chi jumul pa Judea, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Xkib'ij k'u ru tijoxelab' che: Ajtij, mäja' naj ri' ri winaq aj Israel ri e k'o chila' xkaj xkikämisaj la che ab'aj. ¿Te ri' are kaj la ke' chi la jumul jela'? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ri Jesús xub'ij chke: ¿A mat kab'lajuj hora u pam ri jun q'ij? We jun winaq käb'in paq'ij, man kätzaq taj, rumal chi käril ru saqil ri q'ij ri käka'y puwi' ruwächulew. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","We k'u ri winaq chaq'ab' käb'inik, kätzaqik, rumal chi man k'o tä ri saqil pa ru b'e, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Te k'u ri' xub'ij chi ri Jesús chke: Ri tat Lázaro, ri sib'alaj uj utz ruk', xwarik, kine' k'ut kink'asuj na, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Te ri' ri tijoxelab' xkib'ij che ri Jesús: Qajaw, we käwarik kel kub'ij wa' chi kutzir na, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ri Jesús k'ut are tajin kub'ij chi ri tat Lázaro xkämik. Are k'u ri tijoxelab' xkichomaj e are' chi are tajin kub'ij ri waram ri kub'an jun winaq. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Te ri' xub'ij ri Jesús chke chi saqil: Ri tat Lázaro ya xkämik, —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ri in kinkikotik chi man in k'o tä chila'. Are k'u utz na wa' chiwe ix rech kixkojonik. Jo' b'a' jeqila', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Are k'u ri tat Tomás ri “Gemelo” kuchixik, xub'ij chke ri nik'iaj tijoxelab' chik ri e rachi'l: Jo' uj xuquje' rech kujekäm ruk', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Aretaq xopan ri Jesús, te' xuto chi xke' kiejeb' q'ij muqutal chi ri tat Lázaro. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ri alaj tinimit Betania naqaj k'o wi che ri tinimit Jerusalén. Kraj k'o nik'iaj legua u najal. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","E k'ia k'u chke ri winaq aj Israel e opaninaq cho rachoch ri nan Marta, ri nan María, chuku'b'isaxik ki k'ux rumal ru kämikal ri ki xib'al. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Aretaq ri nan Marta xretamaj chi opanem kub'an ri Jesús, xe' chuk'ulaxik, are k'u ri nan María xkanaj kan cho ja. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ri nan Marta xub'ij che ri Jesús: Qajaw, we ta k'o la waral, mat xkäm ri nu xib'al, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Wetam k'ut chi ronojel ri käta' la che ri Dios, ri Are' kuya na wa' che la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ri Jesús xub'ij che: Ri a xib'al käk'astaj na chkixol ri käminaqib', —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ri nan Marta xub'ij che ri Jesús: Je', wetam chi käk'astaj na chkixol ri käminaqib' pa ri k'isb'al q'ij, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Te ri' xub'ij ri Jesús che: Ri in, in ri' kink'astajisaj ri käminaqib' xuquje' kinya ki k'aslemal. Jachin ri käkojon chwe in, pune käkämik, käk'asi chi k'u na. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Konojel k'u ri k'ä e k'aslik ri kekojon chwe, man kekäm tä wi. ¿A kakoj wa'? —xcha che ri nan Marta. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ri nan Marta xub'ij che: Je', Wajaw, ri in kinkojo chi lal ri' ri Cristo, ru K'ojol ri Dios, ri ulinaq la waral cho ri uwächulew, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Aretaq xb'itaj wa' we tzij ri' rumal ri nan Marta, xe'k, xusik'ij loq ri nan María ru chaq'. Xaq chk'uyal xub'ij che: Ri Ajtij k'o waral, katusik'ij, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ri nan María, xuwi xuto ri xb'ix che, chanim k'u xwalijik, xe' chuch'ab'exik ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Mäja' k'u qas kopan ri Jesús pa ri tinimit. K'ä k'o chila' jawije' ri xk'ulax wi rumal ri nan Marta. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ri winaq aj Israel, ri e k'o kuk' pa ja chuku'b'isaxik ki k'ux, aretaq xkilo chi aninaq xwalij b'i ri nan María, xeb'e' ri e are' ruk'. Xkichomaj chi jela' ke' chuchi' ri muqub'al che oq'ej. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Aretaq k'ut xopan ri nan María ruk' ri Jesús, xxuki chuwäch, xub'ij che: Wajaw, we ta k'o la waral, mat xkäm ri nu xib'al, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ri Jesús, aretaq xrilo chi xuchap oq'ej ri nan María, xuquje' ri winaq aj Israel ri e petinaq ruk', sib'alaj xb'isonik, k'äx xuna' pa ranima'. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Xuta' k'u chke: ¿Jawije' ri muqutal wi? —xcha chke. Ri e are' xkib'ij che: Qajaw, sa'jmpe la, je'ila la, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ri Jesús k'ut xoq'ik. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Xkib'ij k'u ri winaq aj Israel: Chiwilampe' chi sib'alaj loq' chuwäch, —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Jujun k'u chke xkib'ij: We achi ri' ri xjaqow ru waq'äch ri moy, ¿a mat xkowin ta wa' chub'anik jun toq'ob' che ri tat Lázaro rech mat xkämik? —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ri Jesús, jumul chik sib'alaj k'äx tajin kuna' pa ranima', xnaqajin chuchi' ri jul ri muqutal wi ri tat Lázaro. Are jun pek, kojom k'u jun ab'aj che tz'apib'al re ru chi'. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ri Jesús xub'ij: Chesaj alaq ri ab'aj, —xcha chke ri winaq. Are k'u ri nan Marta, ri ranab' kan ri käminaq, xub'ij che ri Jesús: Qajaw, k'o chi ruxlab' ri' rumal chi xke' kiejeb' q'ij wa' käminaq chik, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Xub'ij k'u ri Jesús che: ¿A mat nu b'im chawe chi we katkojonik kawil na u nimarisaxik u q'ij ri Dios? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Te ri' xkesaj ri ab'aj. Ri Jesús xka'y chikaj, xub'an orar, xub'ij: Tat, kinmaltioxij che la chi xintatab'ej la. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Wetam chi amaq'el ronojel q'ij kintatab'ej la. Xa k'u rumal kech we winaq ri' ri e k'o waral, kinb'ij wa' rech käkikojo chi are ri lal in taqowinaq la loq, —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Aretaq xb'itaj wa' rumal, ko xch'awik, xub'ij: ¡Lázaro, chatel loq! —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Xel k'u loq ri käminaq, b'otz'om ri raqan u q'ab' ruk' taq atz'iaq. Ru palaj pistal ruk' jun su't. Ri Jesús xub'ij chke ri winaq: Solo' alaq, tzoqopij alaq b'ik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ruk' wa' ri xb'antajik, e k'ia chke ri winaq aj Israel ri e opaninaq chuku'b'isaxik u k'ux ri nan María, xekojon che ri Jesús. Xkil k'u ri kajmab'al ri xub'ano. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","E k'o k'u jujun chke xeb'e' kuk' ri tata'ib' fariseos chub'ixik chke ri u b'anom ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Are k'u ri tata'ib' fariseos, xuquje' ri ki nimaqil ri sacerdotes xe'kimulij kib' kuk' ri ki nimaqil ri winaq, xkib'ij: ¿Jas käqa'no? We achi ri' tajin kub'an k'ia kajmab'al taq etal, —kecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","We käqaya kan xaq chi je ri', konojel ri winaq kekojon na che ri Are'. Kepe k'u na ri q'atal taq tzij aj Roma, käkiwulij na ri nimalaj rachoch Dios ri käqamulij wi qib', käkisach na u wäch ri qa tinimit, —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Are k'u ri tat Caifás, ri ki nimal ri sacerdotes pa ri junab' ri', xub'ij chke: Ri ix, xa man k'o tä iwetam, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","¿A mat kich'ob'o chi are utz na chqe uj chi käkäm xa jun achi che ki k'exwäch ri winaq, chuwäch ri käsach u wäch ronojel ri tinimit? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Man xaq tä k'u pa ru chomanik ri tat Caifás xpe wi wa' we tzij ri' ri xub'ij, xane rumal chi are ki nimal ri sacerdotes pa ri junab' ri' ri Dios xyo'w wa' pa ranima' chi kub'ij chi ri Jesús käkäm na rumal kech ri winaq aj Israel. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Man xuwi tä k'u rumal kech ri winaq aj Israel käkäm na ri Jesús, xane che ki mulixik konojel ri ralk'ual ri Dios ri e jab'uninaq cho ronojel ruwächulew. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Xa je ri' ri ki nimaqil ri winaq aj Israel tzpa ri q'ij ri' xkichap u chomaxik jas käka'n chukämisaxik ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Rumal ri' ri Jesús ya man xuk'ut tä chi rib' chkiwäch ri winaq aj Israel. Xel b'i pa Judea, xe' jela' chunaqaj ri juyub' ri kätz'inowik, pa jun tinimit Efraín u b'i'. Chila' xk'oji wi kuk' ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Xa k'u jub'iq' kraj man kuriq ri Pascua, jun chke ri ki nimaq'ij ri winaq aj Israel. E k'ia winaq k'ut pa taq ri nik'iaj taq tinimit chik xeb'e' pa ri tinimit Jerusalén, mäjoq ri Pascua, chuch'ajik kib' che resaxik ri äwas chkij. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tajin k'u käkitzukuj ri Jesús. Aretaq e k'o pa ri nimalaj rachoch Dios käkitala u tzijol chb'il taq kib', käkib'ij: ¿Jas käb'ij alaq? ¿A käpe ri' pa we nimaq'ij o man käpe taj? —kecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ri tata'ib' fariseos, xuquje' ri ki nimaqil ri sacerdotes, ki yo'm taqanik chi we k'o jun winaq retam jawije' k'o wi ri Jesús, chub'ij wa' chke rech kekowinik kekichapa loq. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Waqib' q'ij kraj na che ri nimaq'ij Pascua aretaq ri Jesús xe' pa Betania, ri tinimit ri jeqel wi ri tat Lázaro ri xk'astajisax rumal ri Jesús chkixol ri käminaqib'. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Chila' k'ut xka'n u b'anik jun wi'm re b'enaq q'ij chuya'ik u q'ij ri Jesús. Ri nan Marta tajin kukoj ri wa puwi' ri mesa, are k'u ri tat Lázaro jun ri are' t'uyul chi' ri mesa ruk' ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Te ri' xpe ri nan María ruk'am nik'iaj litro k'ok'alaj kunab'al re qas nardo. Sib'alaj k'u paqal rajil wa' we kunab'al ri'. Xuq'ij chrij ri raqan ri Jesús, te k'u ri' xusu' ruk' ru wi'. Ronojel k'u ru pam ri ja xnoj che ru k'ok'al ri kunab'al. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Te ri' jun chke ru tijoxelab' ri Jesús, ri jun ri käjachow na, ri Judas Iscariote ru k'ojol ri tat Simón, xub'ij: ");
INSERT INTO qucNNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","¿Jas che man xk'iyix ta wa' we k'ok'alaj kunab'al ri' che oxib' cientos quetzales, xyi' ta k'u ri puaq chke ri meb'a'ib'? —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Man qas tzij tä k'ut chi ri tat Judas xa kutoq'ob'isaj ki wäch ri meb'a'ib' chi je' xub'ij wa', xane rumal chi are jun elaq'om. Pu q'ab' k'u ri are' k'o wi ri k'olib'al puaq. Xa je ri' xkowinik xrelaq'aj ri puaq ri k'o ruk'. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Te ri' xub'ij ri Jesús che: ¡Mab'an wa' che ri ixoq! U k'olom k'u b'i ri k'ok'alaj kunab'al ri' k'ä mäjoq kinmuqik. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Amaq'el k'ut e k'o ri meb'a'ib' iwuk', are k'u ri in man in k'o tä iwuk' amaq'el ronojel q'ij, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","E k'ia k'u chke ri winaq aj Israel xkito chi ri Jesús k'o pa ri alaj tinimit Betania, xeb'e' k'u jela' man xuwi tä che rilik ri Jesús, xane xuquje' che rilik ri tat Lázaro ri xk'astajisax rumal ri Jesús chkixol ri käminaqib'. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Are k'u ri ki nimaqil sacerdotes xjunamataj ri ki chomanik chukämisaxik ri tat Lázaro xuquje'. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Rumal k'u rech ri are' e k'ia chke ri winaq aj Israel tajin käkitas kib' chkij ri ki nimaqil sacerdotes rech kekojon che ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","E k'ia winaq e b'enaq pa ri tinimit Jerusalén che ri nimaq'ij Pascua. Chukab' q'ij xkito chi ri Jesús kopan na pa ri tinimit. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Te ri' xkijol u xaq taq palmas, xkik'am b'ik, xeb'e' k'u chuk'ulaxik ri Jesús. Ko xech'awik, xkib'ij: ¡Chnimarisax u q'ij ri Dios! ¡Utz re ri petinaq pa ru b'i' ri Qajaw Dios! ¡Tewchital b'a' ri nim taqanel pa ki wi' ri winaq aj Israel! —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ri Jesús xuriq jun burro, xkiejen k'u chrij, jas ri kub'ij ru Loq' Pixab' ri Dios ri Tz'ib'talik: ");
INSERT INTO qucNNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Mixej iwib', winaq aj Sión. ¡Chiwilampe'! Petinaq ri Jun ri kätaqan na pi wi', kiejeninaq chrij jun burro, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Pa taq ri q'ij ri' ru tijoxelab' ri Jesús man xkich'ob' tä ri tajin käb'antajik. Te k'u ri' aretaq xnimarisax u q'ij ri Jesús, xna'taj chke chi ronojel wa' ri kilom are tz'ib'tal loq chrij ri Are', ronojel k'ut b'antajinaq. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ri winaq ri e k'o ruk' ri Jesús aretaq xusik'ij loq ri tat Lázaro pa ri muqub'al, xuk'astajisaj k'u chkixol ri käminaqib', xkitzijoj wa' ri xkilo. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Rumal ri' ri winaq xeb'el loq chuk'ulaxik ri Jesús, rumal chi xketamaj we kajmab'al etal ri' ri xub'ano. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Are k'u ri tata'ib' fariseos xkib'ij chb'il taq kib': Kil b'a' alaq chi man k'o tä jas kujkowin chub'anik. ¡Chilampe alaq! Konojel ri winaq keb'e' ruk', —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Chkixol ri winaq ri e b'enaq pa ri tinimit Jerusalén che q'ijilanik pa ri nimaq'ij, e k'o jujun winaq aj Grecia. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","We winaq ri' xeopan ruk' ri tat Felipe ri aj Betsaida re Galilea, xkib'ochi'j, xkib'ij che: Tat, käqaj käqil u wäch ri Jesús, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ri tat Felipe xe'k, xub'ij che ri tat Andrés. Te k'u ri' ri kieb' chik xeb'e'k, xe'kib'ij che ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Te ri' ri Jesús xub'ij chke: Xuriq ri q'ij ri känimarisax nu q'ij in, in ri' ri Ralk'ual ri Dios ri Qas Winaq. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Qas tzij kinb'ij chiwe, chi we man käqaj ri jun u waq'äch triko pa ri ulew rech käq'ayik, tajin wi ri' xaq jun u waq'äch triko. We k'u käq'ayik, kätux na ri', kuya k'u na k'ia u wäch. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Apachin ta ne ri loq' käril wi ru k'aslemal, käkäm na wa' ri winaq ri', kutzaq na ronojel. Apachin k'u ri man loq' taj käril wi ru k'aslemal cho we uwächulew, kuto' na u wi' ri', kuriq k'u na ri k'aslemal ri man k'o tä u k'isik. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","We k'o jun ri kraj käpatänin chwe, chpet wuk'. Jawije' k'u ri kink'oji wi, chila' xuquje' käk'oji wi na ri patänil we. We k'o jun ri käpatänin chwe, käyi' na u q'ij rumal ri nu Tat, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Sib'alaj k'äx kinna' pa wanima' kämik. ¿Jas ta k'u lo ri kinb'ij na? ¿A kinb'ij ta k'ut: “Tat, chinto' la chuwäch ri käpe na pa nu wi' kämik”? Are k'u wa' nu patän in petinaq, —xcha ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tat, nimarisaj b'a' la u q'ij ri b'i' la, —xcha'. Te k'u ri' k'o Jun ri xch'aw loq chikaj ri xub'ij: Nu nimarisam u q'ij, kinnimarisaj k'u na u q'ij jumul chik, —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Are k'u ri winaq ri e k'o chila' ri tajin ketatab'enik xkib'ij chi are jun kiäqulja ri xtatajik. Nik'iaj chik xkib'ij: Are jun ángel ri xch'aw ruk', —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Te ri' ri Jesús xub'ij chke: Man rumal tä wech in xtatajik chi k'o Jun ri xch'aw loq chikaj, xane rumal iwech ix. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Kämik wa' ri q'ij ri käq'at tzij puwi' we uwächulew ri'. Kämik ri q'ij ri käpaqchix apan ri jun ri kätaqan puwi' we uwächulew. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Aretaq k'ut ri in kinwalijisax chikaj, konojel keka'y na chwe, sib'alaj käkikajmaj k'u na nu wäch, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Xub'ij wa' we tzij ri' chuq'alajisaxik jas u wäch kämikal kuriq na. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Xech'aw k'u ri winaq, xkib'ij che: Ri uj qa tom u sik'ixik pa taq ri qa wuj re ri Pixab' chi ri Cristo käk'asi na pa taq ri q'ij ri junab' ri kepetik. ¿Jas k'u che käb'ij la chi ri Ralk'ual ri Dios ri Qas Winaq käwalijisax na chikaj? ¿Jachin chi k'u ri' ri Ralk'ual ri Dios ri Qas Winaq? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Te ri' ri Jesús xub'ij chke: Kämik ri' k'ä k'o na ri saqil iwuk', xa k'u kieb' oxib' q'ij chik k'olik. Chixb'in b'a' chanim ri k'ä k'o ri saqil iwuk', rech man kixkanaj tä kan pa q'equm. Jachin k'u ri käb'in pa q'equm, man kuch'ob' tä ri' jawije' ri ke' wi. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Chixkojon che ri saqil kämik, ri k'ä k'o na ri saqil iwuk'. Je ri' rech ri ix, ix winaq chik rech ri saqil, —xcha ri Jesús chke. Xuwi xb'itaj wa' we tzij ri' rumal ri Jesús, xe' ri Are', xuk'u' rib' chkiwäch. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ri Jesús, pune xub'an k'ia kajmab'al taq etal chkiwäch ri winaq aj Israel, ri e are' man xekojon tä che. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Rajwaxik k'ut chi käb'antaj na wa' jas ri u tz'ib'am kan ri qa mam Isaías ri q'alajisal re ru Loq' Pixab' ri Dios ri kub'ij: Qajaw Dios, ¿jachin ta lo ri kojoninaq che ru Loq' Pixab' ri Dios ri qa b'im? ¿Jachin ta lo chuwäch u k'utum wi ri Qajaw Dios ru chuq'ab'? —kächa ri'. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Rumal ri' man xekowin taj xekojonik, rumal chi xuquje' xutz'ib'aj kan ri qa mam Isaías: ");
INSERT INTO qucNNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Ri Dios xub'an moy chke, xuquje' xub'ano chi xeab'ajir ri kanima', rech man käkil tä ruk' ri ki waq'äch, man käkich'ob' tä ruk' ri ki chomab'al, man ketzelej tä k'u wuk' in rech kekunatajik, —kächa ri Dios, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ri qa mam Isaías xub'ij wa' we tzij ri' rumal chi ri are' xrilo xnimarisax u q'ij ri Jesús, xch'aw k'u chrij. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pune je ri', e k'ia chke ri winaq aj Israel xekojon na che ri Jesús, xuquje' ne jujun chke ri nimaq ki b'anik. Man xkiq'alajisaj tä k'u kib' chkiwäch ri winaq rumal chi xkixej kib' chkiwäch ri tata'ib' fariseos, rech man keesax tä b'i pa ri rachoch Dios. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ri e are' k'ut are utz xkil na chi käyi' ki q'ij kumal ri winaq chuwäch ri käyi' ki q'ij rumal ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ri Jesús sib'alaj ko xch'awik, xub'ij: Jachin ri käkojon chwe in, man xuwi tä chwe in käkojon wi, xane xuquje' käkojon ri' che ri qa Tat ri xintaqow loq. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Jachin k'u ri kinril in, käril ri' xuquje' ri xintaqow loq. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","In ri' ri kinya saqil, in petinaq cho ruwächulew rech jachin taq ri kekojon chwe, man kekanaj tä kan pa ri q'equm. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Jachin k'u ri kuta ri nu tzij, te k'u ri' man kunimaj taj, man in tä ri' ri kinq'atow tzij puwi' chi käk'äjisax u wäch. Je ri', rumal chi ri in man in petinaq tä chuq'atik tzij pa ki wi' ri winaq ajuwächulew, xane in petinaq che ki to'ik. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Jachin ri xa käretzelaj nu wäch, man kunimaj tä k'u ri nu tzij, k'o ri käq'atow na tzij puwi' chi käk'äjisax u wäch. Ri tzij ri nu b'im e are ri' ri keq'atow na tzij puwi' pa ri k'isb'al q'ij. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Man xaq tä k'u pa we wi in kinch'awik. Ri qa Tat ri xintaqow loq, are ri Are' u b'im chwe jachike ri kinb'ij xuquje' jachike ri kink'utu. ");
INSERT INTO qucNNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Wetam k'ut chi ru taqanik ri nu Tat are re k'aslemal ri man k'o tä u k'isik. Xa je ri', ri kinb'ij, are kinb'ij jas ri in taqom wi rumal ri qa Tat. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Xa k'u jun q'ij chik kraj che ri nimaq'ij, Pascua u b'i'. Retam chi k'u ri Jesús chi xuriq ri q'ij ri kuya na kan ruwächulew, kätzelej k'u ruk' ru Tat. Ri Are' amaq'el ronojel q'ij sib'alaj loq' xeril wi ru tijoxelab' cho ruwächulew. Pa ri q'ij ri' tajin kuk'ut chkiwäch chi sib'alaj loq' kerilo, chi man k'o tä u k'isik ri ki loq'al chuwäch. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Tajin käka'n ri wi'm re b'enaq q'ij. Ri Itzel k'ut u yo'm chi pa ranima' ri tat Judas Iscariote ru k'ojol ri tat Simón chi pa ri aq'ab' ri' kujach na ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Retam k'u ri Jesús chi ronojel taqanik yo'm pu q'ab' rumal ru Tat. Retam chi ruk' ri Dios petinaq wi ri Are', xuquje' chi ruk' ri Dios kätzelej wi. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Xwalij k'u ri Jesús chi' ri mesa, xresaj ru q'u', xuk'am jun toalla, xuxim k'u wa' xe' ru pam. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Te ri' xuya joron pa jun palangana, xuchap u ch'ajik kaqan ru tijoxelab', xusu' k'u ruk' ri toalla ri ximital xe' ru pam. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Aretaq kraj kuch'aj raqan ri tat Pedro, ri are' xub'ij che ri Jesús: Wajaw, ¿a käch'aj k'u la ri waqan in? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ri Jesús xch'awik, xub'ij che: Kämik ri' man kach'ob' taj jas ri tajin kinb'ano, k'ä te' b'a' pa jun q'ij chik kach'ob' na, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Are k'u ri tat Pedro xub'ij che: Ri in, man k'o tä jumul kinya che la chi käch'aj la ri waqan in, —xcha che. Ri Jesús xub'ij che: We man kinch'aj tä ri awaqan, man kuya' taj katk'oji wuk', —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ri tat Simón Pedro xub'ij che: Wajaw, man xuwi tä b'a' ri waqan, xane ch'aja la ri nu q'ab' xuquje' ri nu jolom, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Are k'u ri Jesús xub'ij che: Jachin ri te' xto'taj che ri atinem man rajwaxik tä chik kuch'aj rib', xane xaq xuwi chi ri raqan, rumal chi ronojel ru cuerpo ch'ajch'oj chik. Ri ix, ix ch'ajch'oj chik, pune man iwonojel taj, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ri Jesús ya retam chik jachin ri käjachow na. Rumal ri' xub'ij: “Man iwonojel tä ri ix, ix ch'ajch'oj,” —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Aretaq ri Jesús xto'taj chuch'ajik ri kaqan ru tijoxelab', xuk'am ru q'u', xukoj chrij, xt'uyi chi k'u jumul chi' ri mesa. Xub'ij k'u chke: ¿A kich'ob'o jas kel kub'ij wa' ri xinb'an chiwe? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ri ix kib'ij Qajtij, xuquje' Qajaw, —kixcha chwe. Qas tzij ri kib'ij, rumal chi in k'u ri'. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","We in, ri in Iwajtij, ri in Iwajaw nu ch'ajom ri iwaqan, ri ix xuquje' rajwaxik b'a' kich'aj ri iwaqan chb'il taq iwib'. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ri in nu yo'm jun k'utb'al chiwäch rech ri ix xuquje' je' kib'ano jas ri nu b'anom in chiwe. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Qas tzij kinb'ij chiwe chi man k'o tä jun patäninel ri nim na u b'anik chuwäch ru patrón, xuquje' man k'o tä jun taqo'n ri nim na u b'anik chuwäch ri taqowinaq b'ik. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","We kich'ob' wa' we ri', kitaqej k'u u b'anik, utz k'u iwe ri', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ri tajin kinb'ij chanim, man kinb'ij tä wa' chiwij iwonojel ri ix. Ri in wetam jachin taq ri e cha'tal wumal. Rajwaxik k'ut je' käb'antaj na jas ri kub'ij ru Loq' Pixab' ri Dios ri Tz'ib'talik: “Ri jun ri käwi' junam wuk' u b'anom u k'ulel chwe,” —kächa ri'. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Kinb'ij wa' chiwe chanim k'ä mäja' käb'antajik, rech aretaq käb'antaj wa', ri ix kikojo chi In Ri'. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Qas tzij kinb'ij chiwe, chi jachin ri kuk'ulaj ri kintaq b'ik, in ri' kinuk'ulaj. Jachin k'u ri kinuk'ulaj in, kuk'ulaj ri' ri xintaqow loq, —xcha ri Jesús chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Aretaq xb'itaj wa' we tzij ri' rumal ri Jesús, sib'alaj xuna' k'äx pa ranima'. Qas chi saqil xub'ij chkiwäch ru tijoxelab': Qas tzij kinb'ij chiwe chi jun chiwe are kinjachow na, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Te ri' ri tijoxelab' xkichap u ka'yexik kib' ri jun ruk' ri jun chik, man xkich'ob' tä k'u jachin ri tajin kub'ij ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jun chke ru tijoxelab' ri Jesús, ri jun ri sib'alaj loq' chuwäch tajin käwi' chuxkut chi' ri mesa. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ri tat Simón Pedro xub'ij che rare' pa memal chi kuta' che ri Jesús jachin ri tajin kub'ij. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Te ri' ri are' xqeb' ruk' ri Jesús, xuta' che: Wajaw, ¿jachin ri' ri käb'ij la? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Xch'aw k'u ri Jesús, xub'ij che: Kinrub' na jun ch'äqap kaxlan wa. Jachin k'u che ri kinya wi wa', are ri are', —xcha che. Xurub' k'u ri ch'äqap kaxlan wa, xuya che ri tat Judas Iscariote, u k'ojol ri tat Simón. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Xuwi xk'amtaj ri ch'äqap kaxlan wa rumal ri tat Judas, xok ri Satanás pa ranima'. Xub'ij k'u ri Jesús che: Ri kachomaj kab'ano, chab'ana wa' chanim, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Man k'o tä k'u jun chke ri tajin kewi' chi' ri mesa ri xuch'ob'o jas che ri Jesús xub'ij wa' we tzij ri' che. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ketam k'ut chi ri tat Judas pu q'ab' k'o wi ri k'olib'al puaq, rumal ri' jujun xkichomaj chi ri Jesús are tajin kub'ij che chi kuloq' ri rajwaxik chke che ri nimaq'ij o kuya jub'iq' puaq che ki to'ik ri meb'a'ib'. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Xuwi k'u xk'amtaj ri ch'äqap kaxlan wa rumal ri tat Judas, xel b'i ri are'. Chaq'ab' chi k'u ri'. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Aretaq elinaq chi b'i ri tat Judas, xub'ij ri Jesús: Kämik käq'alajin na chi qas nim nu q'ij in, in ri' ri Ralk'ual ri Dios ri Qas Winaq. Rumal k'u wech in känimarisax na u q'ij ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","We rumal wech in, in ri' ri Ralk'ual ri Dios ri Qas Winaq, känimarisax na u q'ij ri Dios, xuquje' ri Dios kunimarisaj na nu q'ij in. Chanim k'ut kub'an na wa'. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ix ri', ix je' ta ne alaj taq walk'ual, man naj tä chik in k'o iwuk'. Ri ix kinitzukuj na. Jas k'u ri xinb'ij chke ri winaq aj Israel, je' xuquje' kinb'ij chiwe ix: Man kixkowin taj kixe' chila' jawije' ri kine' wi in. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Kinya k'u kan we k'ak' taqanik ri' chiwe: Chiwaj iwib' chb'il taq iwib'. Je' jas ri in kixwaj, je' b'a' chib'ana ix, chiwaj iwib' chb'il taq iwib'. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","We kiwaj iwib' chb'il taq iwib', konojel ri winaq käketamaj na chi ri ix, ix nu tijoxelab', —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ri tat Simón Pedro xuta' che ri Jesús: Qajaw, ¿jawije' ke' wi la? —xcha che. Ri Jesús xch'awik, xub'ij che: Jawije' ri kine' wi, ri at man katkowin taj kate' wuk' kämik. K'ä te k'u ri' kate' na wuk', —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Xub'ij k'u ri tat Pedro che: Wajaw, ¿jas che man kinkowin taj kine' uk' la kämik? Ri in kinya nu tzij chi kinkäm rumal ech la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ri Jesús xch'awik, xub'ij che: ¿A qas tzij kaya a tzij chi katkäm rumal wech in? —xcha che. Qas tzij kinb'ij chawe chi kab'ij na oxmul chi man awetam tä nu wäch mäjoq koq' ri ama' äk', —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Xaq mäq'oxow iwanima'. Chiku'b'a i k'ux chrij ri Dios, xuquje' chiku'b'a i k'ux chwij in. ");
INSERT INTO qucNNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Cho rachoch ri nu Tat k'o k'ia ri je'l taq ja ri kuya' kixk'oji wi. We ta mat je ri', nu b'im ta ri' chiwe. Kine' b'a', kinb'ana u b'anik jun ja ri kuya' kixk'oji wi. ");
INSERT INTO qucNNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Aretaq in b'enaq chik, b'antajinaq chi u b'anik ri ja ri kixk'oji wi, kinpe chi na che i k'amik b'i wuk' rech ri ix kixek'ol chila' jawije' ri in k'o wi. ");
INSERT INTO qucNNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ri ix iwetam jawije' ri kine' wi, xuquje' iwetam ri b'e ri kopan chila', —xcha ri Jesús chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ri tat Tomás xub'ij che: Qajaw, man qetam taj jawije' ri ke' wi la. ¿Jas ta k'u käqa'n che retamaxik ri b'e? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ri Jesús xch'awik, xub'ij che: In ri' kink'ut ri b'e, ri in kink'ut ri qas tzij, xuquje' ri in kinya na ri k'aslemal. Xaq xuwi rumal wech in jun winaq käkowinik kopan ruk' ri qa Tat. ");
INSERT INTO qucNNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","We ta ri ix qas iwetam nu wäch, iwetam ta u wäch ri' ri nu Tat xuquje'. Iwetam chi k'u u wäch ri' kämik rumal chi amaq'el tajin kiwil u wäch ri Are', —xcha che ri tat Tomás. ");
INSERT INTO qucNNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Te ri' xub'ij ri tat Felipe che: Qajaw, k'utu b'a' la ri qa Tat chqawäch, xuwi wa' rajwaxik chqe, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ri Jesús xch'awik, xub'ij che: Felipe, ojer chi ri' in k'o iwuk', ¿te k'u ri' man awetam tä nu wäch? Jachin ri rilom nu wäch in, rilom u wäch ri' ri nu Tat. ¿Jas che kata' chwe chi kink'ut ri qa Tat chiwäch? ");
INSERT INTO qucNNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿A mat kikojo chi ri in, in k'o ruk' ri qa Tat, xuquje' chi ri qa Tat k'o wuk' in? Ri tzij ri kinb'ij chiwe man xaq tä in kinb'inik. Ri qa Tat ri käjeqi wuk' in, are ri Are' ri käb'anow ri chak. ");
INSERT INTO qucNNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Chikojo' chi ri in, in k'o ruk' ri qa Tat, xuquje' chi ri qa Tat, Are k'o wuk' in. We man je ri', chixkojon b'a' chwe rumal ri kinb'ano. ");
INSERT INTO qucNNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Qas tzij kinb'ij chiwe, chi jachin ri käkojon chwe, kub'an na re xuquje' ri kajmab'al ri kinb'an in. Nimaq taq kajmab'al k'ut chuwäch wa' kub'an na rumal chi ri in kine'k jawije' ri k'o wi ri qa Tat. ");
INSERT INTO qucNNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ronojel k'u ri kita' che ri qa Tat pa ri nu b'i', ri in kinb'an na rech ri in u K'ojol ri Dios kinq'alajisaj chi nim na u q'ij ri qa Tat. ");
INSERT INTO qucNNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ri in kinb'an na apachike ri kita' chwe pa ri nu b'i'. ");
INSERT INTO qucNNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","We ri ix qas kiniwaj, kinimaj na ri' ri nu taqanik. ");
INSERT INTO qucNNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ri in k'ut kinb'ochi'j na ri nu Tat chi kutaq loq Jun ri kixuto', ri kuwalijisaj na iwanima', rech käk'oji iwuk' amaq'el ronojel q'ij. ");
INSERT INTO qucNNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Are wa' ri Loq'alaj Espíritu ri kub'ij ri qas tzij. Ri winaq ajuwächulew man kekowin taj käkik'amo rumal chi man kilom tä u wäch, xuquje' man ketam tä u wäch. Are k'u ri ix iwetam u wäch rumal chi ri Are' k'o iwuk', käjeqi k'u na pa ri iwanima' amaq'el ronojel q'ij. ");
INSERT INTO qucNNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Man kixinya tä kanoq xaq i tukiel. Kintzelej na loq rech kink'oji iwuk'. ");
INSERT INTO qucNNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Xaq kieb' oxib' q'ij chik, ri winaq man käkil tä chi na nu wäch. Are k'u ri ix, ix kiwil na nu wäch. Ri ix k'ut kixk'asi na rumal chi ri in, in k'aslik. ");
INSERT INTO qucNNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Pa ri q'ij ri' ri ix kiwetamaj na chi ri in, in k'o ruk' ri nu Tat, xuquje' chi ri ix, ix k'o wuk' in. Kiwetamaj na chi ri in, in k'o iwuk' ix. ");
INSERT INTO qucNNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Jachin ri retam ri nu taqanik xuquje' kunimaj wa', kuk'ut ri' chi qas tzij kinraj. Loq' k'ut kil wi na rumal ri nu Tat jachin ri kinraj. Ri in xuquje' loq' kinwil wi, kink'ut k'u na wib' chuwäch. ");
INSERT INTO qucNNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ri tat Judas (man are tä ri Judas Iscariote) xuta' che ri Jesús, xub'ij: Qajaw, ¿jas lo wa' chi chqawäch uj käk'ut wi ib' la, man chkiwäch tä k'u ri winaq ajuwächulew? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ri Jesús xch'awik, xub'ij che: Jachin ri kinraj kunimaj ri' ri kinb'ij. Loq' k'ut kil wi na ri are' rumal ri nu Tat. Ri nu Tat, xuquje' ri in kujpe na, kujjeqi' na ruk'. ");
INSERT INTO qucNNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Jachin ri man kinraj taj man kunimaj tä ri' ri kinb'ij. Ri tzij ri tajin kitatab'ej man are tä nu tzij in, xane u tzij ri nu Tat ri xintaqow loq. ");
INSERT INTO qucNNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Tajin kinb'ij ronojel wa' we tzij ri' chiwe che taq ri q'ij ri' ri k'ä in k'o iwuk'. ");
INSERT INTO qucNNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Are k'u ri Loq'alaj Espíritu ri kutaq na loq ri nu Tat pa ri nu b'i' rech kixuto', rech kuku'b'isaj i k'ux, ri Are' k'ut kuk'ut na ronojel chiwäch. Kuna'taj k'u na chiwäch ronojel ri nu b'im chiwe. ");
INSERT INTO qucNNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ruk' utzil kixinya kanoq. Kinya chiwe chi kuxlan ri iwanima', man junam tä k'u wa' ruk' ri käkiya ri winaq ajuwächulew. Mäq'oxow b'a' iwanima', mixej k'u iwib'. ");
INSERT INTO qucNNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ri ix xito aretaq xinb'ij chi kine'k, kinpe chi k'u na jumul chik rech kink'oji iwuk'. We ta qas tzij kiniwaj, xixkikot ta ri' aretaq xinb'ij chi kine' ruk' ri nu Tat. Je ri', rumal chi ri nu Tat are nim na u q'ij chnuwäch in. ");
INSERT INTO qucNNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kinb'ij apan wa' we ri' chiwe k'ä mäja' käb'antajik, rech aretaq käb'antaj wa', kixkojon na. ");
INSERT INTO qucNNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Man k'o tä chi k'ia tzij kinb'ij chiwe. Käpe k'u ri jun ri k'o u taqanik puwi' we uwächulew. Man käkowin tä k'u ri are' kätaqan pa nu wi' in. ");
INSERT INTO qucNNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Rajwaxik wi chi je' käb'antaj na wa', rech ri winaq käketamaj chi loq' ri nu Tat chnuwäch, kinb'an k'ut jas ri in u taqom wi. ¡Chixwalijoq! Chujel b'i waral, —xcha ri Jesús chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","In ri' ri juwi' uvas, ri qas utzalaj tiko'n. Ri nu Tat k'ut, Are ri ajchak ri keilow ri juwi' taq uvas. ");
INSERT INTO qucNNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Konojel ri alaj taq u q'ab' ri juwi' uvas ri man käkiya tä ki wäch ke'resaj na apanoq. Are k'u ri käkiya ki wäch kerilo keub'an ki b'anik rech sib'alaj kewächin na. ");
INSERT INTO qucNNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ri ix ch'ajch'oj chi ri iwanima' rumal ri tijonik ri nu yo'm chiwe. ");
INSERT INTO qucNNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Chib'ana b'a' xa jun wuk' in, jas ri in nu b'anom xa jun iwuk' ix. Je' jas jun alaj u q'ab' ri juwi' uvas man käkowin taj kuya u wäch xaq u tukiel we man tiqil che ri raqan, je ri' xuquje' ri ix, ix je' jas jun tiko'n ri man käwächin taj we man kib'an xa jun wuk' in. ");
INSERT INTO qucNNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","In ri' ri juwi' uvas. Are k'u ri ix, ix ri alaj taq u q'ab' ri juwi' uvas. Jachin ri kub'an xa jun wuk' in, kinb'an k'u xa jun in ruk' ri are', are ri' sib'alaj käwächin na. Man k'o tä k'u jas kixkowin ix chub'anik we man in k'o in iwuk'. ");
INSERT INTO qucNNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Jachin ri man kub'an tä xa jun wuk' in, käk'iäq na apanoq, kächaqi'j k'u na je' jas ru q'ab' taq ri che' ri kemolik, keporox pa q'aq'. ");
INSERT INTO qucNNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","We ri ix xa ix jun wuk' in, man käsach tä k'u ri nu tijonik chiwe, kuya' kita' jachike ri kiwaj, käya'taj k'u na wa' chiwe. ");
INSERT INTO qucNNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ri nu Tat känimarisax na u q'ij aretaq ri ix je' kib'an wa' jas juwi' uvas ri sib'alaj käwächinik. Je wa' ri' qas tzij kixok che nu tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ri in kixwaj ix jas ri nu Tat kinraj in. Chitaqej b'a' kiwaj iwib' jas ri nu b'anom in chiwe. ");
INSERT INTO qucNNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","We kinimaj ri nu taqanik, kitaqej na ri' kiwaj iwib' jas ri nu b'anom in chiwe je' jas ri in kinnimaj ru taqanik ri nu Tat, ri Are' k'ut tajin wi loq' kinrilo. ");
INSERT INTO qucNNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Je' kintzijoj wa' chiwe rech kixkikot wuk', je k'u ri' qas käkikot na ri iwanima'. ");
INSERT INTO qucNNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ri nu taqanik are wa': Chiwaj iwib' chb'il taq iwib', je' jas ri in kixwaj ix. ");
INSERT INTO qucNNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ri rutzil ranima' jun winaq ri más nim ri kuya' käk'oji pa ranima' are la' chi kuya ri' ru k'aslemal che ki k'exwäch ri e utz ruk'. ");
INSERT INTO qucNNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ri ix qas ix utz wuk' in we kib'ano jas ri kixintaq wi. ");
INSERT INTO qucNNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ya man kinb'ij tä patänil taq we chiwe, rumal chi ri patäninel man retam tä ri' jas ri kub'an ru patrón. Xane kinb'ij chiwe chi qas ix utz wuk' in rumal chi nu k'utum chiwäch ronojel ri u b'im ri nu Tat chwe. ");
INSERT INTO qucNNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ri ix man xinicha' tä in, xane in ri' ri xixincha' ix. Xinya k'u pi q'ab' chi je' kib'ano jas juwi' uvas ri sib'alaj käwächinik. Ri wächinik ri kiya man käsach tä u wäch. Je k'u ri' ri nu Tat kuya na chiwe jachike ri kita' che pa ri nu b'i'. ");
INSERT INTO qucNNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Are b'a' wa' ri kixintaq wi: Chiwaj iwib' chb'il taq iwib' ri jun ruk' ri jun chik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","We ri winaq ajuwächulew käketzelaj i wäch, chiwetamaj chi in ri' xketzelaj nu wäch nab'e. ");
INSERT INTO qucNNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","We ta ri ix, ix rech ruwächulew, ri winaq ajuwächulew kixkaj ta ri', je' jas ri e are' sib'alaj kekaj ri kachi'l. Ri in k'ut xixincha' chkixol ri winaq ajuwächulew, rumal k'u ri' ri winaq ajuwächulew käketzelaj i wäch rumal chi man ix jun tä chi kuk'. ");
INSERT INTO qucNNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Chna'taj b'a' chiwe jas ri xinb'ij chiwe: “Man k'o tä jun patäninel ri nim na u b'anik chuwäch ru patrón.” We ri in käb'an k'äx chwe kumal ri winaq, ri ix xuquje' käb'an na k'äx chiwe kumal. We k'u ki nimam ri nu tijonik in, xuquje' käkinimaj na ri i tijonik ix. ");
INSERT INTO qucNNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ronojel wa' we k'äx ri' käb'an na chiwe kumal ri winaq rumal wech in, rumal chi man ketam tä u wäch ri xintaqow loq. ");
INSERT INTO qucNNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Mat k'o ki mak we winaq ri' we ta mat xinpe che ki tzijob'exik. Kämik k'ut man kuya' taj käkib'ij chi man k'o tä ki mak. ");
INSERT INTO qucNNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Jachin k'u taq ri käketzelaj nu wäch in, käketzelaj u wäch ri' ri nu Tat xuquje'. ");
INSERT INTO qucNNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mat k'o ki mak ri' we ta mat k'o ri nu b'anom chkixol ri man k'o tä chi jun b'anowinaq. Ri e are' k'ut kilom ronojel ri nu b'anom. Pune je ri' käketzelaj nu wäch in, xuquje' käketzelaj u wäch ri nu Tat. ");
INSERT INTO qucNNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Rajwaxik k'ut chi je' käb'antaj na wa' rumal chi qas je' kel na jas ri tz'ib'tal kan pa ri ki Pixab': “Xketzelaj nu wäch, man k'o tä k'u mak xinb'an chkij,” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Aretaq k'ut käpe ri Jun ri kätob'an chiwe, ri kuwalijisaj iwanima', ri Loq'alaj Espíritu ri kub'ij ri qas tzij, ri kintaq na loq aretaq in k'o chi ruk' ri qa Tat, ri Are' kuq'alajisaj na ri qas tzij chwij. ");
INSERT INTO qucNNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ri ix xuquje' kiq'alajisaj na ri qas tzij chwij, rumal chi ri ix k'olinaq wuk' petinaq loq, —xcha ri Jesús chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Kinb'ij wa' we tzij ri' chiwe rech man kub'an tä kieb' i k'ux, kixtzaq k'ut. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Kixesax k'u na loq pa taq ri rachoch Dios. Je ri' chi kopan na ri q'ij aretaq apachin ri kixkämisanik kuchomaj na chi tajin käpatänin che ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Je' käka'n na wa' rumal chi man k'o tä jumul ri qas xketamaj u wäch ri nu Tat, man k'o tä k'u jumul ri xketamaj nu wäch in. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Kinb'ij apan ronojel wa' chiwe, rech aretaq kuriq ri q'ij ri', käna'taj chiwe chi ri in nu b'im chi wa' chiwe, —xcha ri Jesús. Man xinb'ij tä wa' chiwe petinaq loq rumal chi ri in, in k'o iwuk'. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Kämik k'ut kine'k rech kinek'ol ruk' ri Jun ri xintaqow loq. Man k'o tä k'u jun chiwe kuta' chwe jawije' ri kine' wi. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Xa k'u xixb'isonik rumal chi xinb'ij wa' we tzij ri' chiwe. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kinb'ij k'u ri qas tzij chiwe: Are utz na chiwe ix chi kine'k. We ta k'u man kine'k, man käpe tä ri' ri Jun ri käk'oji iwuk' che i to'ik, ri kuwalijisaj iwanima'. We k'u kine'k, kintaq na loq. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Aretaq käpe ri Are' kuya na pa kanima' ri winaq chi käkich'ob'o chi k'o ki mak, chi rajwaxik käka'n ri jikomal pa ri ki k'aslemal, xuquje' chi ri Dios kuq'at na tzij pa ki wi'. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","K'o ki mak rumal chi man kekojon tä chwe. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Käketamaj k'u na chi rajwaxik u b'anik ri jikomal pa ri ki k'aslemal rumal chi ri in kine' ruk' ri nu Tat, ri ix k'ut man kiwil tä chi na nu wäch. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Käketamaj na chi ri Dios kuq'at na tzij pa ki wi' rumal chi ri jun ri kätaqan puwi' ruwächulew q'atom chi tzij puwi' chi käk'äjisax u wäch. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","K'ia na ri kwaj kinb'ij chiwe, man kixkowin tä k'u chuch'ob'ik wa' kämik. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Aretaq k'ut käpe ri Loq'alaj Espíritu ri kub'ij ri qas tzij, kuk'ut na ronojel ri qas tzij chiwäch. Man xaq tä k'u pa re wi käch'awik, xane are kub'ij ronojel ri kuto, kuk'ut k'u na chiwäch jas ri käb'antaj na. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ri Are' kunimarisaj na nu q'ij in rumal chi kuk'am na ri wech in, kuk'ut k'u na wa' chiwäch ix. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ronojel ri k'o ruk' ri nu Tat are wech in xuquje'. Rumal ri' xinb'ij chi ri Loq'alaj Espíritu kuk'am na ri wech in, kuk'ut k'u na wa' chiwäch ix. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Xaq jub'iq' chik, te k'u ri' ri ix man kiwil tä chi na nu wäch. K'ä te k'u ri' kiwil chi na jumul nu wäch pa kieb' oxib' q'ij, rumal chi kine'k rech kinek'ol chila' jawije' ri k'o wi ri qa Tat, —xcha chke ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Te ri' jujun chke ru tijoxelab' xkitala chb'il taq kib', xkib'ij: ¿Jas kel kub'ij wa'? Kub'ij chqe chi xaq jub'iq' chik, te k'u ri' man käqil tä chi u wäch. K'ä te k'u käqil chi na u wäch jumul chik pa kieb' oxib' q'ij rumal chi ke' jela' jawije' ri k'o wi ri qa Tat. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Jas lo wa' ri kraj kub'ij chi “xaq jub'iq' chik”? Man käqach'ob' taj jas ri tajin kub'ij, —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ri Jesús xuch'ob'o chi k'o jas ri käkaj käkita' che, xub'ij k'u chke: Ri in xinb'ij chiwe chi xaq jub'iq' chik, te k'u ri' man kiwil tä chi nu wäch. K'ä te k'u kiwil chi na jumul nu wäch pa kieb' oxib' q'ij. ¿A are wa' ri tajin kitala chixol chb'il taq iwib'? ");
INSERT INTO qucNNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Qas tzij kinb'ij chiwe chi ri ix kixoq' na, kixb'ison na, are k'u ri winaq ajuwächulew kekikot na. Pune k'u je ri', chi ri ix kixb'ison na, ri i b'is kujala na pa kikotem. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Aretaq käpe ri q'ij ri kil na u wäch ri ral jun ixoq, käb'isonik rumal chi xuriq ri q'ij re ri q'oxom. Aretaq k'ut rilom chi u wäch ri ral, man käna'taj tä chi ri q'oxom che rumal ri kikotemal ri kuna' chi ilom u wäch jun alaj ak'al cho ruwächulew. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Je k'u ri' ri ix, kämik kixb'isonik. Ri in k'ut kinwil chi na i wäch jumul chik, te k'u ri' käkikot k'u na ri iwanima'. Are jun kikotemal wa' ri man k'o tä jun käkowinik kesan chiwe. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Pa ri q'ij ri' man k'o tä chi jas kita' na chwe. Qas tzij kinb'ij chiwe chi ri qa Tat kuya na chiwe ronojel ri kita' che pa ri nu b'i'. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","K'ä we kämik ri' ri ix man k'o tä jas ri i tom pa ri nu b'i'. Chita' b'a', käya'taj k'u na chiwe rech qas käkikot ri iwanima', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Nu b'im wa' we tzij ri' chiwe kuk' taq k'utb'al. Kuriq k'u na ri q'ij aretaq man kintzijon tä chi iwuk' kuk' taq k'utb'al. Xane chi saqil chik kintzijon na iwuk' chrij ri qa Tat. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Pa ri q'ij ri' k'o ri kita' na che ri Are' pa ri nu b'i'. Man kinb'ij tä k'u chiwe chi kinb'ochi'j ri nu Tat pi wi'. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Je ri', rumal chi ri ix, ix loq' chuwäch ri nu Tat. Ix loq' chuwäch rumal chi ri in, in loq' chiwäch ix, kikoj k'ut chi ruk' ri Dios in petinaq wi. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Xinel loq ruk' ri qa Tat rech kinpe waral cho we uwächulew, kämik chi k'ut tajin kinya kan ruwächulew rech kintzelej ruk' ri qa Tat, —xcha ri Jesús chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Te ri' xkib'ij ru tijoxelab' ri Jesús: Kämik qas chi saqil tajin kätzijon la, man tajin tä käkoj la k'utb'al. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Kämik qetam chik chi etam la ronojel. Man rajwaxik taj chi k'o jun k'o jas kuta' che la. Rumal ri' käqakojo chi ruk' ri Dios petinaq wi la, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ri Jesús xch'awik, xub'ij chke: ¿A tzij ri' chi kämik qas kixkojonik? —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Petinaq k'u ri q'ij, kämik k'u ri' aretaq ri ix kixjab'un na. Chijujunal kitzukuj na jawije' kixe' wi, kiniya k'u na kan nu tukiel. Man kinkanaj tä k'u na kan nu tukiel rumal chi ri qa Tat are k'o wuk'. ");
INSERT INTO qucNNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Kinb'ij wa' we tzij ri' chiwe rech kuxlan ri iwanima' rumal chi xa ix jun wuk'. Cho ruwächulew kiriq na k'äx. ¡Mixej b'a' iwib'! Ri in k'ut, in ch'akaninaq puwi' ruwächulew. ");
INSERT INTO qucNNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Aretaq xb'itaj wa' we tzij ri' rumal ri Jesús, xka'y chikaj, xub'ij: Tat, xuriq ri q'ij. Nimarisaj b'a' la u q'ij ri K'ojol la, rech xuquje' ri K'ojol la kunimarisaj ri q'ij la. ");
INSERT INTO qucNNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Yo'm k'u la taqanik pu q'ab' ri K'ojol la pa ki wi' konojel winaq rech kuya ri k'aslemal ri man k'o tä u k'isik chke ri xeya la che. ");
INSERT INTO qucNNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ri k'aslemal ri man k'o tä u k'isik are wa' chi käketamaj wäch la chi xuwi ri lal, lal qas Dios, xuquje' chi käketamaj u wäch ri Jesucristo ri xtaq la loq. ");
INSERT INTO qucNNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ri in, nu nimarisam q'ij la waral cho ruwächulew xuquje' nu k'isom u b'anik ri xintaq la chub'anik. ");
INSERT INTO qucNNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kämik k'ut, Tat, ya la chwe chi känimarisax nu q'ij uk' la jas ri nu b'anom nab'e aretaq mäjoq xb'an ruwächulew. ");
INSERT INTO qucNNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ri winaq ri xecha' la chkixol ri winaq cho ruwächulew rech keya la chwe, nu b'im chke jachin ri lal. E ech la wa', xeya k'u la chwe. Ri e are' k'ut ki nimam ri tzij la. ");
INSERT INTO qucNNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Kämik ri e are' ketam chi ronojel ri xya la chwe uk' la petinaq wi. ");
INSERT INTO qucNNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nu yo'm k'u ri tzij la chke ri xya la chwe, xkikoj k'u pa kanima'. Xkich'ob'o chi qas tzij uk' la in petinaq wi, xuquje' xkikojo chi ri lal xintaqow la loq. ");
INSERT INTO qucNNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Kinb'ochi'n che la pa ki wi'. Man kinb'ochi'n tä che la pa ki wi' ri winaq ajuwächulew, xane pa ki wi' ri winaq ri xeya la chwe, rumal chi e ech la wa'. ");
INSERT INTO qucNNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ronojel ri wech in ech la wa', are k'u ri ech la wech in wa'. Kumal k'u ri e are' käq'alajinik chi sib'alaj nim na nu q'ij. ");
INSERT INTO qucNNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ri in man kinkanaj tä chik cho ruwächulew. Ri e are' k'ut kekanaj na kan cho ruwächulew. Ri in kine'k rech kink'oji uk' la. Loq'alaj qa Tat, chechajij b'a' la ruk' ri chuq'ab' la ri winaq ri xeya la chwe, rech qas käka'n xa jun, jas ri in, ri lal xa uj jun. ");
INSERT INTO qucNNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Aretaq xink'oji kuk' ri e are' waral cho we uwächulew, xeinchajij xuquje' xeinto' ruk' ri chuq'ab' la konojel ri xeya la chwe. Man k'o tä jun chke ri xsachik, xane xaq xuwi ri jun ri yo'm chrij chi käsachik rech je' käb'antajik jas ri kub'ij ri Loq' Pixab' la ri Tz'ib'talik. ");
INSERT INTO qucNNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Kämik k'ut kine' chila' jawije' ri k'o wi la. Che k'u we chanim ri' ri in k'o na cho ruwächulew, kinb'ij kan wa' we tzij ri' chke rech ri e are' qas käkina' pa kanima' ri kikotemal ri kinna' in pa ri wanima'. ");
INSERT INTO qucNNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nu yo'm ri tzij la chke. Ketzelax k'u ki wäch ri e are' kumal ri winaq ajuwächulew, rumal chi ri e are' man e rech tä ruwächulew je' jas ri in man in rech tä ruwächulew. ");
INSERT INTO qucNNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Man kinta' tä che la chi keesaj la b'i cho ruwächulew, xane kinb'ochi'n che la chi keto' la chuwäch ri Itzel. ");
INSERT INTO qucNNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Je' jas ri in man in rech tä ruwächulew, ri e are' xuquje' man e rech tä ruwächulew. ");
INSERT INTO qucNNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Chetasa la chrij ronojel u wäch mak ruk' ri qas tzij rech käkijach kib' pa q'ab' la. Ri Loq' Pixab' la are ri qas tzij. ");
INSERT INTO qucNNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Jas ri lal xintaq la loq chkixol ri winaq ajuwächulew, ri in xuquje' keintaq na b'i ri e are' chkixol ri winaq ajuwächulew. ");
INSERT INTO qucNNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Rumal k'u kech ri e are' ri in kinjach wib' pa q'ab' la, rech ri e are' xuquje' käkijach kib' pa q'ab' la rumal ri qas tzij, käkitas k'u kib' chrij ronojel u wäch mak. ");
INSERT INTO qucNNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Man kinb'ochi'n tä k'u che la xaq xuwi pa ki wi' ri e are', xane xuquje' pa ki wi' ri k'ä te' kekojon na chwe, aretaq käkita ri tzij ri käkitzijoj na ri e are'. ");
INSERT INTO qucNNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Kinb'ochi'n che la chi konojel ri e are' qas käka'n na xa jun, chi qas käka'n ta na xa jun junam quk' uj, Tat, je' jas ri lal k'o la wuk' in, xuquje' ri in, in k'o uk' la. Qas tzij ta b'a' käka'n xa jun rech ri winaq ajuwächulew käkikojo chi lal xintaqow la loq. ");
INSERT INTO qucNNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ri in nu nimarisam ki q'ij jas ri u nimarisaxik nu q'ij in b'anom la, rech xa e jun, je' jas ri lal ri in xa uj jun. ");
INSERT INTO qucNNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ri in, in k'o kuk', ri lal k'ut k'o la wuk' in, rech ri e are' qas käka'n na xa e jun, rech je ri' ri winaq ajuwächulew käkich'ob'o chi lal xintaqow la loq, xuquje' chi e loq' chuwäch la jas ri in, in loq' chuwäch la. ");
INSERT INTO qucNNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tat, lal xeyo'w la chwe, kwaj k'ut chi kek'ol na wuk' in jawije' ri kink'oji wi na in rech käkilo chi yo'm la chwe chi sib'alaj nim nu q'ij in. Ojer k'ut in loq' chuwäch la tzaretaq mäjoq käb'an ruwächulew. ");
INSERT INTO qucNNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tat, lal ri jikom anima' la, ri winaq ajuwächulew man qas ketam tä wäch la, ri in k'ut wetam wäch la. Ri winaq k'ut ri e yo'm la chwe ketam chi lal ri' xintaqow la loq. ");
INSERT INTO qucNNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nu b'im chke jachin ri lal, kintaqej k'u na u b'ixik wa' chke, rech jas ri nu loq'al in chuwäch la, je' ki loq'al ri e are' chuwäch la. Je ri' rech ri in qas kink'oji na kuk', —xcha ri Jesús che ri qa Tat. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Aretaq xb'itaj we tzij ri' rumal ri Jesús, xel b'i ri Are'. Junam kuk' ru tijoxelab' xe' ri Are' ch'äqäp che ri b'inel ja', Cedrón u b'i'. Chila' k'o wi jun ch'äqap ulew ri e tiktal wi ri che', chila' k'ut xok wi ri Jesús e rachi'l ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ri tat Judas ri tajin käjachow ri Jesús xuquje' retam are' ri ch'äqap ulew ri' rumal chi ri Jesús k'ia mul k'olinaq chila' kuk' ru tijoxelab'. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Je ri' ri tat Judas xopan chila' e rachi'l jumulaj soldados, xuquje' jujun chajinelab' re ri nimalaj rachoch Dios ri e taqom b'i kumal ri ki nimaqil ri sacerdotes xuquje' ri tata'ib' fariseos. We winaq ri' kuk'am ki machetes, kuk'am ki lámpara, kuk'am k'u ki chäj. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Retam chi k'u ri Jesús ronojel ri käb'an na che. Rumal ri' xel apan chkiwäch ri winaq, xuta' chke: ¿Jachin ri kätzukuj alaq? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ri e are' xech'awik, xkib'ij che: Ri Jesús ri aj Nazaret, —xecha'. Ri Jesús xub'ij: In ri', —xcha chke. Ri tat Judas ri tajin käjachowik k'o chila' chkixol. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Aretaq ri Jesús xub'ij: “In ri'”, pak'alik xeb'e'k, xetzaq k'u pulew. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Te ri' ri Jesús xuta' chi jumul chke: ¿Jachin ri kätzukuj alaq? —xcha chke. Xkib'ij k'u ri e are': Ri Jesús ri aj Nazaret, —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Te ri' xub'ij ri Jesús chke: Nu b'im chi chech alaq chi in ri', —kächa chke. We are ri in ri kintzukuj alaq, ya alaq chke we nik'iaj ri' chi keb'e'k, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Je' xub'ij wa' ri Jesús rech je' käb'antajik jas ri xub'ij ri Are': “Ri xeuya ri nu Tat chwe, man k'o tä jun chke xsachik,” —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Te ri' ri tat Simón Pedro ri k'o ru machete xuk'amo, xuq'at k'u apan ru xikin ri tat Malco ri patänil re ri ki nimal sacerdotes. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Xub'ij k'u ri Jesús che ri tat Pedro: Chaya chi jumul ri a machete pa ri k'olib'al re. We ri nu Tat kub'an chwe chi kintij ri k'a ri k'o pa ri vaso, ¿a mat rajwaxik wi chi käpe wa' we k'äx ri' chwij? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Xepe k'u ri jumulaj soldados kachi'l ri ki nimal ri e are', xuquje' ri chajinelab' re ri nimalaj rachoch Dios ri aj Israel, xkichap ri Jesús, xkiyutu. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Te ri' xkik'am b'i cho rachoch ri tat Anás. Ri tat Anás are u ji' ri tat Caifás ri ki nimal sacerdotes pa ri junab' ri'. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Are ri tat Caifás wa' ri u b'im kan nab'e chke ri winaq aj Israel chi are utz na chke ri e are' chi käkäm xa jun achi che ki k'exwäch konojel ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ri tat Simón Pedro, rachi'l jun tijoxel chik, e b'enaq ruk' ri Jesús. Ri jun tijoxel chik ri' etamtal u wäch rumal ri ki nimal sacerdotes, rumal k'u ri' xok b'i ri are' ruk' ri Jesús pa ri uwoja rech ri rachoch ri ki nimal sacerdotes. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Are k'u ri tat Pedro xkanaj kan chrij ri ja chi' ri uchib'e. Xa je ri' xel loq ri tijoxel ri etamtal u wäch rumal ri ki nimal sacerdotes, xch'aw ruk' ri chajil uchib'e, xroksaj k'u b'i ri tat Pedro. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ri chajil uchib'e xuta' che ri tat Pedro, xub'ij: ¿A mat lal jun chke ru tijoxelab' we achi ri'? —xcha che. Ri tat Pedro xch'awik, xub'ij: No, man in jun tä chke, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Sib'alaj k'äx tew tajin kub'ano. Rumal ri' ri patäninelab' xuquje' ri chajinelab' ki nuk'um jun q'aq'. E tak'atoj k'u chila', tajin käkimiq' kib'. Ri tat Pedro xuquje' k'o kuk', tajin k'u kumiq' rib' chrij ri q'aq'. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ri ki nimal sacerdotes xuchap u ta'ik che ri Jesús jachin taq ru tijoxelab', xuquje' jas ri tajin kuk'ut chkiwäch ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ri Jesús xub'ij che: Ri in, in tzijoninaq chkiwäch konojel ri winaq chi saqil. Amaq'el nu yo'm tijonik pa taq ri rachoch Dios xuquje' pa ri nimalaj rachoch Dios jawije' ri käkimulij wi kib' konojel ri winaq aj Israel. Je ri' chi man k'o tä jun tzij nu b'im xaq chi k'uyal, —kächa che. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Jas che käta' la chwe in? Ta' la chke ri winaq ri ki tom ri nu tzij, chkib'ij k'ut jas chrij in tzijoninaq wi. Ri e are' ketam jas ri nu b'im, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Aretaq xb'itaj wa' we tzij ri' rumal ri Jesús, jun chke ri chajinelab' rech ri nimalaj rachoch Dios ri k'o chila' xuya jun q'ab' chupalaj ri Jesús, te k'u ri' xub'ij che: ¿A je' u ch'ab'exik wa' ri ki nimal sacerdotes kab'ano? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ri Jesús xch'awik, xub'ij che: We k'o jun tzij xinb'ij ri man utz taj, b'ij la chwe jachike ri tzij ri man utz taj. We k'u utz ri xinb'ij, ¿jas che kinch'ay la? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Yutum k'u ri Jesús, xpe ri tat Anás, xutaq b'i ruk' ri tat Caifás, ri ki nimal ri sacerdotes. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Are k'u ri tat Pedro tak'alik tajin kumiq' na rib' chrij ri q'aq'. Xkita' k'u che, xkib'ij: ¿A mat at jun chke ru tijoxelab' we achi ri'? —xecha che. Ri tat Pedro k'ut xresaj rib' chupam, xub'ij: ¡No, man in jun tä chke! —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Te ri' xta' che rumal jun chke ri patänil taq re ri ki nimal sacerdotes, ri alaxik ruk' ri achi ri xq'at apan u xikin rumal ri tat Pedro, xub'ij che: ¿A mat xinwilo chi at k'o ruk' ri Are' pa ri ch'äqap ulew ri e tiktal wi ri che'? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ri tat Pedro xresaj chi jumul rib' chupam, tzare chi' k'ut xoq' ri ama' äk'. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Te k'u ri' xkik'am b'i ri Jesús cho rachoch ri tat Caifás, xeb'e' cho ri nimalaj ja re ri nim q'atal tzij. Xaq jub'iq' chik kraj man käsaqirik, ri winaq aj Israel k'ut man xeb'ok tä pa ri nimalaj ja rech man käka'n tä ri äwas u b'anik. We je ri' man kuya' tä ri' käkitij ri wi'm rech ri Pascua. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Rumal ri' ri tat Pilato xel loq che ki tzijob'exik, xub'ij chke: ¿Jas u mak we achi ri' ri kib'ij ix? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ri e are' xech'awik, xkib'ij: We ta mat are jun b'anal etzelal mat xqajach wa' pa q'ab' la, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Xub'ij k'u ri tat Pilato chke: Chik'ama b'i ix, chiq'ata tzij puwi'. Chib'ana' jas ri kub'ij ri i pixab' ix, —xcha chke. Ri winaq aj Israel xech'awik, xkib'ij: Ri uj, ri uj aj Israel, man ya'tal tä chqe chi käqakämisaj jun winaq, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Je ri' xb'antajik jas ru b'im kan ri Jesús chrij ri käb'an na che chukämisaxik. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ri tat Pilato xok chi b'i jumul pa ri nimalaj ja, xusik'ij ri Jesús, te k'u ri' xuta' che: ¿A at ri' ri kattaqan pa ki wi' ri winaq aj Israel? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ri Jesús xub'ij che: ¿A xaq lal käb'in la wa' o nik'iaj chik xeb'in che la chwij in? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ri tat Pilato xch'awik, xub'ij: ¿A in pu lo jun aj Israel? Ri awinaqil at, xuquje' ri ki nimaqil ri sacerdotes e are taq wa' ri xatjachow pa nu q'ab'. ¿Jas k'u ri a b'anom? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Te ri' xch'aw ri Jesús, xub'ij che: Ri nu taqanik man rech tä we uwächulew ri'. We ta rech ruwächulew, ri nu tijoxelab' xech'ojin ta ri' rech mat xinjach pa ki q'ab' ri winaq aj Israel. Ri nu taqanik k'ut man ajwaral taj, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Xub'ij k'u ri tat Pilato che: Je ri' chi ri at, ¿a at nim taqanel? —xcha che. Ri Jesús xch'awik, xub'ij: In nim taqanel, jas ri käb'ij la, —xcha che. Ri in xil nu wäch waral cho ruwächulew chub'ixik jas ri' ri qas tzij. Konojel k'u ri keniman che ri qas tzij käkitatab'ej ri kinb'ij, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ri tat Pilato xub'ij che: ¿Jas k'u ri' ri qas tzij? —xcha che. Xuwi xta'taj wa' che ri Jesús rumal ri tat Pilato, ri are' xel chi loq jumul che ki tzijob'exik ri winaq aj Israel, xub'ij chke: Ri in, man k'o tä jun mak kinriq chrij we achi ri', —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ri ix k'ut ix naq'atalik chi kinb'an toq'ob' chiwe, kintzoqopij b'i jun ajpache' pa ri nimaq'ij re ri Pascua. ¿A kiwaj chi kintzoqopij b'i ri tata' ri' ri k'o u taqanik pi wi' ix, ix winaq aj Israel? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Te ri' konojel ko xech'awik, xkib'ij: ¡Mätzoqopij la b'i ri are'! ¡Are tzoqopij la b'i ri Barrabás! —xecha'. Are' k'u jun elaq'om wa' ri Barrabás. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Te ri' ri tat Pilato xuk'am b'i ri Jesús, xtaqan k'u chuch'ayik. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ri soldados xkikoj jun corona re kemom k'ix chujolom ri Jesús, xkikoj k'u jun atz'iaq morada chrij. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Te k'u ri' xeqeb' ruk', xkib'ij k'ut: Lal ri' ri kätaqan la pa ki wi' ri winaq aj Israel, ¡chnimarisax q'ij la! —xecha che. Xkich'ay k'u chupalaj. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ri tat Pilato xel loq jumul chik, xub'ij k'u chke ri winaq: Chiwilampe', kinwesaj loq we achi ri' chiwäch rech kiwetamaj chi man k'o tä jub'iq' mak kinriq in chrij, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Xel k'u loq ri Jesús, kojom k'u ri corona re kemom k'ix chujolom, kojom xuquje' ri atz'iaq morada chrij. Te k'u ri' xub'ij ri tat Pilato chke: ¡Waral k'o wi ri achi! —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Aretaq ri ki nimaqil sacerdotes, xuquje' ri chajinelab' re ri nimalaj rachoch Dios xkilo, ko xech'awik, xkib'ij: ¡Chripoq! ¡Chripoq! —xecha'. Ri tat Pilato xub'ij chke: ¡Chik'ama b'i ix, chiripa'! Ri in man k'o tä jub'iq' mak kinriq in chrij, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ri winaq aj Israel xech'awik, xkib'ij: Ri uj k'o jun qa pixab', ri qa pixab' k'ut kub'ij chi rajwaxik käkämisaxik rumal chi xub'an che rib' chi are u K'ojol ri Dios, —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ri tat Pilato, aretaq xuta wa' ri xkib'ij, sib'alaj xuxej na rib'. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Xok chi b'i jumul pa ri nimalaj ja, xuta' che ri Jesús: ¿Jawije' ri katpe wi? —xcha che. Are k'u ri Jesús man xch'aw taj, man k'o tä k'u jas xub'ij che. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Xub'ij k'u ri tat Pilato che: ¿Jas che man kinach'ab'ej taj? ¿A mat awetam chi k'o taqanik pa nu q'ab' che a ripik cho ri cruz o che a tzoqopixik b'ik? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ri Jesús xch'awik, xub'ij che: Man k'o tä jub'iq' taqanik la pa nu wi' we ta mat yo'm che la rumal ri Dios. Rumal ri', jachin ri xinjachow pa q'ab' la nim na u mak ri' chuwäch la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Tzare chi' k'ut ri tat Pilato xutzukuj jas xub'ano rech kutzoqopij b'i ri Jesús. Are k'u ri winaq aj Israel ko xech'awik, xkib'ij: ¡We kätzoqopij la b'ik, man utz tä anima' la ri' ruk' ri nimalaj taqanel! ¡Jachin ri kub'an che rib' chi are nim taqanel, u k'ulel ri' ri nimalaj taqanel! —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ri tat Pilato aretaq xuta ri xkib'ij, xtaqan che resaxik loq ri Jesús. Ri are' k'ut xt'uyi cho ri q'atb'al tzij pa ri k'olib'al ri käb'ix “Gabata” che pa hebreo, ri kel kub'ij “Lajom Ab'aj”. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Xa k'u chuweq chik ri nimaq'ij Pascua. Kraj are ri nik'iaj q'ij. Ri tat Pilato k'ut xub'ij chke ri winaq aj Israel: ¡Waral k'o wi ri tata' ri k'o u taqanik pi wi'! —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ri e are' k'ut ko xech'awik, xkib'ij: ¡Chkämisaxoq! ¡Chkämisaxoq! ¡Chripoq! —xecha'. Ri tat Pilato xub'ij chke: ¿A kinrip ta k'u cho ri cruz ri tata' ri k'o u taqanik pi wi? —xcha chke. Are k'u ri ki nimaqil ri sacerdotes xech'awik, xkib'ij che: Ri uj man k'o tä chi jun achi chik ri kätaqan pa qa wi', xane xaq xuwi ri nimalaj taqanel, —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ri tat Pilato xuwi xuta wa', xujach b'i ri Jesús pa ki q'ab' rech käkirip cho ri cruz. Xkik'am k'u b'ik. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Xel k'u b'i ri Jesús, xuk'am b'i ru cruz, xe' pa ri juyub' ri käb'ix U B'aqil Jolomaj che. (Pa ri ch'ab'al hebreo are käb'ix Gólgota che.) ");
INSERT INTO qucNNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Chila' xkirip wi cho ri cruz junam kuk' kieb' achijab' chik, jujun pa taq u xkut. Ri Jesús xkanaj pa ki nik'iajal. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ri tat Pilato xtaqan chukojik jun tz'ib'talik puwi' ri cruz ri kub'ij: JESÚS AJ NAZARET RI NIM TAQANEL PA KI WI' RI WINAQ AJ ISRAEL. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","E k'ia chke ri winaq aj Israel xkisik'ij u wäch ri tz'ib'talik ri' rumal chi ri juyub' ri xrip wi ri Jesús naqaj k'o wi che ri tinimit Jerusalén. Ri tz'ib'talik, tz'ib'tal wa' pa ri hebreo, griego, xuquje' pa ri latín. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Rumal ri' ri ki nimaqil sacerdotes kech ri winaq aj Israel xkib'ij che ri tat Pilato: Mätz'ib'aj la: “Ri Nim Taqanel kech ri winaq aj Israel.” Xane tz'ib'aj la: “Ri kub'ij che rib' chi are Nim Taqanel kech ri winaq aj Israel,” —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Are k'u ri tat Pilato xch'awik, xub'ij chke: Ri xintz'ib'aj, xaq je wa' käkanajik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Te ri', aretaq xeto'taj ri soldados churipik ri Jesús cho ri cruz, xkik'am ri ratz'iaq, xka'n k'u kiejeb' che, jujun ke ri jujun soldados. Xuquje' xkik'am ri kamixa'. Man t'isom tä k'u wa', xane xa jun u b'anom, kemom petinaq ajsik k'ä ikim. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ri soldados xkib'ij chb'il taq kib': Man käqaraq'atij taj. Chqesaj suerte chrij rech käqilo jachin käch'akowik, —xecha'. Je ri' xb'antajik jas ri tz'ib'tal pa ru Loq' Pixab' ri Dios ri kub'ij: “Xkijach ri watz'iaq chkiwäch, xkesaj suerte chrij,” —kächa'. Are wa' ri xka'n ri soldados. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Chunaqaj ri cruz ri ripom wi ri Jesús k'o ru nan, k'o ru chaq' ru nan, k'o ri nan María ri rixoqil ri tat Cleofas, xuquje' k'o ri nan María ri aj Magdala. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Aretaq ri Jesús xril ru nan xuquje' ri tijoxel ri sib'alaj loq' chuwäch tak'al chuxkut, xub'ij che ru nan: Nan, chab'ana awal che we achi ri', —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Te k'u ri' xub'ij che ru tijoxel: Chab'ana a nan che ri nu nan, —xcha che. Tzare chi' k'ut ri tijoxel ri' xuk'am b'i ru nan ri Jesús cho rachoch. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Te k'u ri' rumal chi ri Jesús retam chi ronojel ri tz'ib'tal chrij b'antajinaq chik, xuquje' rech qas käb'antajik jas ri kub'ij ru Loq' Pixab' ri Dios, xub'ij: Kächaqi'j nu chi', —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","K'o k'u apan jun laq nojinaq che ch'äm vino. Xkirub' k'u jun estropajo chupam ri vino ri', xkiya puwi' jun aj, te k'u ri' xkiya aq'an chuchi' ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ri Jesús xutij ri ch'äm vino, te k'u ri' xub'ij: Ronojel xb'antajik, —xcha'. Xupachb'a k'u ru jolom, xel ranima'. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Xa k'u chuweq chik ri nimaq'ij Pascua. Man käkaj tä k'u ri winaq aj Israel chi ri ki cuerpo ri winaq kekanaj kan cho taq ri cruz pa ri q'ij re uxlanem. Ri q'ij re uxlanem ri' are jun q'ij wa' nim u b'anik. Rumal ri' xkita' che ri tat Pilato chi kätaqan chuq'ajisaxik ri kaqan ri e ripil cho taq ri cruz, xuquje' chi käqasax ri ki cuerpo cho ri cruz. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Te ri' xeb'e' ri soldados, xkiq'ajisaj ri raqan ri nab'e xuquje' ri jun chik ri e ripom ruk' ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Aretaq k'ut xeqeb' ruk' ri Jesús, xkilo chi käminaq chik, xa je ri' man xkiq'ajisaj tä ri raqan ri Are'. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pune je ri' jun chke ri soldados xujaq ru k'alk'ax ri Jesús ruk' jun lanza, chanim k'ut xel loq kik' xuquje' joron. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ri käb'in wa' we tzij ri', are jun ri qas xrilo, qas tzij k'u ri kub'ij. Ri are' kub'ij ri qas tzij ri retam rech ri ix xuquje' kixkojonik. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Je k'u xk'ulmataj wa' rech käb'antajik jas ri tz'ib'tal pa ru Loq' Pixab' ri Dios ri kub'ij: “Man k'o tä jun b'aq xkiq'ajisaj che,” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Kub'ij xuquje' ru Loq' Pixab' ri Dios pa jun u xaq chik: “Käkil na ri xkisoko,” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Te k'u ri' xpe ri tat José ri kel pa ri tinimit Arimatea, xuta' che ri tat Pilato chi käyi' che chi kuqasaj ru cuerpo ri Jesús. Ri tat José are jun u tijoxel ri Jesús, xa k'u chi k'uyal rumal chi kuxej rib' chkiwäch ri winaq aj Israel. Xyi' k'u che rumal ri tat Pilato. Xa je ri' xe' ri tat José, xuqasaj ru cuerpo ri Jesús, xuk'am k'u b'i pa muqik. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Xpe xuquje' ri tat Nicodemo ri nab'e kanoq xopan ruk' ri Jesús chaq'ab' chutzijob'exik. Ri are' ruk'am jun kunab'al, are mirra ri yujtal ruk' áloes, ri käpajan cien libras. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Je ri' ri tat José rachi'l ri tat Nicodemo xkik'am b'i ru cuerpo ri Jesús, xkipis k'u pa taq manta re lino ri yo'm ri k'ok'alaj taq kunab'al chrij. Je' xka'n che jas ri e naq'atal wi ri winaq aj Israel che ki muqik ri käminaqib'. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Pa ri juyub' ri xrip wi ri Jesús cho ri cruz, k'o jun ch'äqap ulew ri e tiktal wi ri che'. Pa ri ulew ri' k'o jun k'ak' muqub'al ri mäja' yo'm jun käminaq chupam. ");
INSERT INTO qucNNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Chupam k'ut xkiya wi ru cuerpo ri Jesús, rumal chi ri muqub'al ri' naqaj k'o wi, xuquje' rumal chi xa jub'iq' kraj man kächaptaj ri q'ij re uxlanem chke ri winaq aj Israel. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Pa ri nab'e q'ij re ri semana, sib'alaj aq'ab', q'equm na, ri nan María ri aj Magdala xe' chuchi' ri muqub'al. Xril k'ut chi esam chi apan ri ab'aj ri tz'apib'em u chi' ri muqub'al. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Xa je ri' xutik anim, xe'k, xuriqa ri tat Simón Pedro, xuquje' ri jun tijoxel chik ri sib'alaj loq' chuwäch ri Jesús, xub'ij chke: Ri Qajaw Jesús xesax b'i pa ri muqub'al, xk'am b'ik, man qetam tä k'ut jawije' ri xyi' wi, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Te ri' ri tat Pedro rachi'l ri jun tijoxel chik xeb'el b'ik, xeb'e' chuchi' ri muqub'al. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ri kieb' xkitik anim, junam e b'enaq. Are k'u ri jun chik sib'alaj xutik na anim chuwäch ri tat Pedro. Ri are' xopan nab'e chi' ri muqub'al. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Man xok tä k'u pa ri muqub'al, xane xaq xuwi xpachi koq che rilik. Te' xrilo chi e k'o kan ri manta chila'. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Te k'u ri' xopan chi ri tat Simón Pedro, ri teren loq chrij. Ri are' k'ut xok b'i pa ri muqub'al. Xuquje' xeril ri manta ri e k'o kan chila'. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Xuquje' xrilo chi ri manta ri xpispex u jolom ri Jesús man junam taj k'o kuk' ri nik'iaj manta chik, xane b'otom wa', yo'm k'u apan jela'. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Te k'u ri' xok chi b'i ri jun tijoxel chik ri xopan nab'e chuchi' ri muqub'al. Xrilo ri b'antajinaq, xkojon k'u ri are'. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Mäja' k'u käkich'ob'o jas ri kub'ij ru Loq' Pixab' ri Dios ri Tz'ib'talik chi are rajwaxik chi ri Jesús käk'astaj na chkixol ri käminaqib'. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Te ri' xetzelej we kieb' tijoxelab' ri' cho kachoch. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Are k'u ri nan María xkanaj kan chuchi' ri muqub'al, tajin koq'ik. K'ä tajin koq'ik aretaq xpachi'k rech käka'y koq chupam ri muqub'al. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Te' xrilo chi e k'o kieb' ángeles, ri e t'uyut'oj jawije' ri xyi' wi ru cuerpo ri Jesús, saqloloj k'u ri katz'iaq. Ri jun t'uyul pu jolom, ri jun chi k'ut t'uyul pa raqan. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ri ángeles xkita' che ri nan María, xkib'ij: Nan, ¿jas che tajin koq' la? —xecha che. Ri nan María xub'ij chke: Rumal chi xkik'am b'i ri Wajaw Jesús, man wetam tä k'ut jawije' ri xyi' wi, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Te' xb'itaj wa' rumal, aretaq xka'y chrij, xrilo chi k'o ri Jesús chila'. Man xuch'ob' tä k'ut chi are ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Xpe k'u ri Jesús, xuta' che, xub'ij: Nan, ¿jas che tajin katoq'ik? ¿Jachin k'u ri tajin katzukuj? —xcha che. Ri nan María xuchomaj chi are ri chajinel re ri ulew ri', xub'ij che: Tat, we lal xk'amow la b'ik, b'ij la chwe jawije' ri xya wi la rech ri in kink'am b'ik, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Te ri' xub'ij ri Jesús che: ¡María! —xcha che. Ri are' xka'y chrij, te k'u ri' xub'ij che pa hebreo: ¡Raboni! —xcha che. Ri tzij ri' kel kub'ij “Ajtij”. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ri Jesús xub'ij che: Minachapo rumal chi k'ä mäja' kinpaqi chila' jawije' ri k'o wi ri nu Tat, —xcha'. Jat b'a', jab'ij k'u chke ri wachalal chi kinpaqi chila' jawije' k'o wi ri nu Tat, ri xuquje' ri i Tat ix, ri nu Dios k'ut, ri xuquje' are ri i Dios ix, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Te ri' xe' ri nan María ri aj Magdala, xub'ij k'u chke ri tijoxelab' chi ri are' xril u wäch ri Qajaw Jesús, xuquje' chi ri Jesús xub'ij wa' we tzij ri' che. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Qas pa ri q'ij ri', ri nab'e q'ij re ri semana, chaq'ab' chik ki mulim kib' ri tijoxelab'. Ki tz'apim k'u ri u chi' taq ja rumal chi xkixej kib' chkiwäch ri winaq aj Israel. Xok b'i ri Jesús, xtak'i k'u chkixol. Xuya rutzil ki wäch, xub'ij chke: Chuxlan b'a' ri iwanima', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Aretaq xb'itaj wa' we tzij ri' rumal, xuk'ut ru q'ab' chkiwäch xuquje' ru k'alk'ax. Ri tijoxelab' xekikotik aretaq xkil u wäch ri Qajaw Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Te k'u ri' ri Jesús xub'ij chi jumul chke: Chuxlan b'a' ri iwanima', —xcha'. Je' jas ri nu Tat xinutaq loq in, je ri' ri in xuquje' kixintaq b'i ix, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Te k'u ri' xuya ri ruxlab' pa ki wi', xub'ij: Chik'ama ri Loq'alaj Espíritu, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Jachin taq ri kisach ri ki mak, käsachtaj na ri ki mak. Jachin taq ri man kisach tä ri ki mak, man käsachtaj tä na ri ki mak, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ri tat Tomás, jun chke ri kab'lajuj u tijoxelab' ri Jesús ri käb'ix Gemelo che, man k'o tä ri are' aretaq xopan ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Te k'u ri' ri nik'iaj tijoxelab' chik xkib'ij che ri tat Tomás: Xqil u wäch ri Qajaw Jesús, —xecha che. Are k'u ri tat Tomás xub'ij chke: We man kinwil ri soktajinaq ri xub'an ri klawux pu q'ab', te k'u ri' kinnim ru wi' nu q'ab' pa taq ri jul, xuquje' kinnim ri nu q'ab' pa ru k'alk'ax, man kinkoj taj, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ok'owinaq chi wajxaqib' q'ij. Ri tijoxelab' ki mulim kib' jumul chik pa jun ja, k'o chi k'u ri tat Tomás kuk' ri e are'. Te ri', pune e tz'apil ru chi' taq ja, ri Jesús xok b'ik, xtak'i k'u chkixol. Xuya rutzil ki wäch, xub'ij: Chuxlan b'a' ri iwanima', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Te k'u ri' xub'ij che ri tat Tomás: Chawilampe ri nu q'ab', chanima k'u b'i ru wi' a q'ab' waral. Chayuqu ra q'ab', chanima k'u b'i pa ri nu k'alk'ax. Mub'an chi kieb' a k'ux, xane chatkojon chwe, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Te ri' xch'aw ri tat Tomás, xub'ij che: ¡Wajaw, nu Dios! —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ri Jesús xub'ij che: Tomás, ri at kämik xatkojon chwe rumal chi xawil nu wäch. Utz k'u ke ri kekojon chwe pune man käkil nu wäch, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","K'ia k'u kajmab'al taq etal xub'an na ri Jesús chkiwäch ru tijoxelab' ri man xetz'ib'ax tä pa we wuj ri'. ");
INSERT INTO qucNNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Xetz'ib'ax k'u wa' ri k'o waral rech ri ix kikojo chi ri Jesús are ri Cristo, ru K'ojol ri Dios, rech aretaq kixkojon che ri Are', kiriq na ri k'aslemal ri man k'o tä u k'isik, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Te k'u ri' ri Jesús xuk'ut rib' jumul chik chkiwäch ru tijoxelab' chi' ri mar re Tiberias. Je wa' xub'an chuk'utik rib': ");
INSERT INTO qucNNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Konojel wa' junam e k'olik. Ri tat Simón Pedro, ri tat Tomás ri käb'ix Gemelo che, ri tat Natanael ri aj Caná re Galilea, ri kieb' u k'ojol ri tat Zebedeo, xuquje' kieb' chik chke ru tijoxelab' ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ri tat Simón Pedro xub'ij chke: Kine' chuchapik kär, —xcha chke. Ri e are' xkib'ij che: Ri uj xuquje' kuje' awuk', —xecha che. Xeb'e' k'ut, xeb'ok pa jun barco, man k'o tä k'u kär xkichap pa ronojel ri jun aq'ab' ri'. ");
INSERT INTO qucNNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Aretaq tajin käpe ru saqirik, ri Jesús xuk'ut rib' chkiwäch chi' ri mar, are k'u ru tijoxelab' man xkich'ob' taj chi are ri Are'. ");
INSERT INTO qucNNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Te ri' xub'ij chke: ¡Ix achijab'! ¿A mat k'o ri i chapom? —xcha chke. Ri e are' xech'awik, xkib'ij: Man k'o taj, —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Te ri' xub'ij ri Jesús chke: Chik'iäqa ri k'at pa ru wikiäq'ab' ri barco, k'o k'u na ri kichapo, —xcha ri' chke. Je' k'u xka'no. Te ri' man xekowin tä chi k'u che resaxik loq ri k'at chapäb'al kär pa ri ja' rumal chi sib'alaj xnoj ri k'at che taq kär. ");
INSERT INTO qucNNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Te ri' ri tijoxel ri sib'alaj loq' chuwäch ri Jesús xub'ij che ri tat Pedro: ¡Are ri Qajaw Jesús! —xcha che. Xuwi xuta wa' ri tat Simón Pedro chi are ri Qajaw Jesús, xukoj ri ratz'iaq rumal chi resam wa'. Xuk'iäq k'u b'i rib' pa ri ja'. ");
INSERT INTO qucNNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ri nik'iaj tijoxelab' chik xeopan chi' ri ulew chupam ri barco, ki jururem ri k'at nojinaq che taq kär. Xa k'u cien metros xek'oji wi che ru chi' ri ulew. ");
INSERT INTO qucNNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Aretaq xeb'el pa ri barco, te' xkilo k'o jun q'aq' nuk'um, k'o k'u jun kär pa ri rachaq q'aq', xuquje' e k'o jujun kaxlan wa. ");
INSERT INTO qucNNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ri Jesús xub'ij chke: Cheik'ama loq jujun chke ri kär ri k'ä te' xechaptaj iwumal, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Xpaqi k'u ri tat Simón Pedro pa ri barco, xresaj k'u loq ri jun k'at chapäb'al kär nojinaq che taq kär. Xujururej k'u loq wa' chi' ri ulew. ¡Nojinaq k'u ri k'at! E k'o jun ciento ruk' kawinaq oxlajuj nimaq taq kär chupam. Pune sib'alaj e k'ia ri kär, ri k'at man xt'oqopin taj. ");
INSERT INTO qucNNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Te ri' xub'ij ri Jesús chke: Chixsa'j, chixwoq b'a', —xcha chke. Man k'o tä k'u jun chke ru tijoxelab' xuchajij anima' xuta' che jachin ri Are' rumal chi konojel ketam chi are ri Qajaw Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Te k'u ri' ri Jesús xqeb' kuk', xuk'am k'u ri kaxlan wa, xuya chke. Je' xuquje' xub'an ruk' ri kär. ");
INSERT INTO qucNNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Are urox mul wa' ri xuk'ut rib' ri Jesús chkiwäch ru tijoxelab' aretaq ya k'astajinaq chik chkixol ri käminaqib'. ");
INSERT INTO qucNNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Aretaq xtijtaj ri ki wa re aq'ab'il, ri Jesús xuta' che ri tat Simón Pedro, xub'ij che: Simón, u k'ojol ri tat Jonás, ¿a qas loq' na kinawil in chkiwäch konojel taq wa'? —xcha che. Ri tat Pedro xch'awik, xub'ij: Je', je ri', Wajaw. Etam ya' la chi kwaj la, —xcha che. Ri Jesús xub'ij che: Cheayuq'uj b'a' ri alaj taq nu chij, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Chukamul chik xuta' che: Simón, u k'ojol ri tat Jonás, ¿a qas loq' na kinawilo? —xcha che. Ri tat Pedro xch'awik, xub'ij che: Je', Wajaw. Etam ya' la chi kwaj la, —xcha che. Ri Jesús xub'ij che: Cheayuq'uj b'a' ri nu chij, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Churox mul chik xuta' che: Simón, u k'ojol ri tat Jonás, ¿a qas kinawaj? —xcha che. Ri tat Pedro xb'isonik rumal chi xuta' che churox mul we qas loq' chuwäch, xub'ij k'u che: Wajaw, etam la ronojel. Etam ya' la chi qas kwaj la, —xcha che. Ri Jesús xub'ij che: Cheayuq'uj b'a' ri nu chij, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Qas tzij kinb'ij chawe, chi aretaq at ala na, ri at xakoj ri awatz'iaq, xate'k jawije' ri xawaj xate' wi. Aretaq k'ut katrijob'ik, kayuq na ri a q'ab', jun chi k'ut käkojow na ri awatz'iaq chawij, katuk'am k'u na b'i chila' jawije' ri man kawaj tä wi, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ri Jesús xub'ij wa' we tzij ri' chub'ixik che jas u wäch kämikal ri kuriq na ri tat Pedro, kunimarisaj k'u na u q'ij ri Dios. Te k'u ri' xub'ij che: ¡Tasa'j wuk'! —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Aretaq xka'y ri tat Pedro chrij, xrilo chi teren ri tijoxel chkij ri sib'alaj loq' chuwäch ri Jesús, ri xt'uyi chuxkut ri Jesús chi' ri mesa aretaq xka'n ri k'isb'al wi'm re b'enaq q'ij, ri xuta' che ri Jesús, xub'ij: “Wajaw, ¿jachin ri' ri käjachow na la?” —xcha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Aretaq ri tat Pedro xrilo, xub'ij che ri Jesús: Qajaw, wa' we jun ri', ¿jas ri kuk'ulmaj na ri are'? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ri Jesús xch'awik, xub'ij che: We ri in kwaj chi käk'asi na ri are' k'ä kintzelej na loq, ¿jas awe at che? Ri at tasa'j wuk', —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Xel k'u u tzijol wa' chkixol ri qachalal chi ri tijoxel ri' man käkäm taj. Man xub'ij tä k'u ri Jesús che chi man käkäm taj, xane xub'ij: “We kwaj chi käk'asi na ri are' k'ä kintzelej na loq, ¿jas awe at che?” —xcha ri Jesús che ri tat Pedro. ");
INSERT INTO qucNNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Are k'u wa' ri tijoxel ri xuq'alajisaj chi qas tzij wa' ri xutz'ib'aj kanoq. Qetam k'ut chi kub'ij ri qas tzij. ");
INSERT INTO qucNNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Sib'alaj k'ia chi k'u na ri xub'an ri Jesús. We ta ketz'ib'ax wa' chkijujunal, kinchomaj chi man kub'ana tä ronojel ruwächulew che k'olib'al ke ri wuj ri ketz'ib'ax na. Amén.");
INSERT INTO qucNNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Loq'alaj tat Teófilo: Pa ri nab'e nu wuj ri xintz'ib'aj che la, xintzijon chrij ronojel ri xub'an ri Jesús, xuquje' chrij ronojel ri xuk'ut kanoq chkiwäch ri winaq aretaq xuchaplej u patänixik ri Dios waral chqaxol. ");
INSERT INTO qucNNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Pa ri nab'e nu wuj xintzijon chrij nimalaj ronojel ri xub'an ri Are' k'ä xk'am na b'i chikaj. Aretaq mäja' ke' chikaj, xuya taqanik, xeupixb'aj kan ri apóstoles ri xeucha'. Rumal ri Loq'alaj Espíritu ri k'o ruk', xub'ij kan chke jas ri rajwaxik käka'no. ");
INSERT INTO qucNNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Xuriq k'äx ri Jesús, xkämisaxik, te k'u ri' xuk'ut rib' chkiwäch ri apóstoles chwinaqil rech q'alaj chi k'astajinaq chik chkixol ri käminaqib'. K'ia ri xub'an chkiwäch rech käkikojo chi qas tzij k'asal chik ri Are'. Kawinaq q'ij ri' xuk'ut na rib' chkiwäch amaq'el. Xuquje' xtzijon kuk' chrij ri kub'an na ri Dios aretaq kätaqan pa ki wi' ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Aretaq ri Jesús k'ä k'o kuk' ri apóstoles, xub'ij chke chi meb'el b'ik pa ri tinimit Jerusalén chanim, xane chi keye'nik. Je wa' xub'ij: Chiweyej na chi käyataj chiwe ri b'im loq rumal ri nu Tat, jas ri xinb'ij chiwe, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Qas tzij, ri tat Juan xub'an ki qasna' ri winaq ruk' ja', are k'u ri ix xa pa kieb' oxib' q'ij käb'an na i qasna' ruk' ri Loq'alaj Espíritu, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Are k'u ri apóstoles ki mulim kib' ruk' ri Jesús, xkita' k'u che ri Are', xkib'ij: Qajaw, ¿a mat xopan ri q'ij ri käya la chke ri qa winaqil chi ketaqan chi na jumul puwi' ri qa tinimit Israel rech man käkitaqej tä taqanik ri nik'iaj winaq chik pa qa wi'? —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Xch'aw k'u ri Jesús, xub'ij chke: Ri q'ij, ri ajilab'al, man ya'tal tä chiwe ix chi kiwetamaj, xane xaq xuwi pu q'ab' ri qa Tat k'o wi ronojel wa'. ");
INSERT INTO qucNNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Aretaq k'ut käpe ri Loq'alaj Espíritu pi wi', käk'oji na i chuq'ab'. Te k'u ri' kixe'k, kitzijoj na jas ri i wilom chi xinb'an che ki to'ik ri winaq, jas ri xink'ulmaj aretaq xinkämisaxik, xuquje' aretaq xink'astaj chkixol ri käminaqib'. Ronojel wa' kitzijoj na pa Jerusalén, pa taq konojel ri tinimit re Judea, re Samaria, xuquje' k'ä pa taq ri ki tinimit ri winaq ri sib'alaj naj e k'o wi cho ruwächulew, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Aretaq ri Jesús xto'taj chub'ixik wa' we tzij ri' chke ri apóstoles, xyak b'i chikaj chkiwäch. Ri e are' tajin keka'y che aretaq xpaqi chikaj, xch'uqtaj k'u rumal jun sutz', man xekowin tä chik xkilo. ");
INSERT INTO qucNNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ri e are' tajin keka'y chikaj che ri Jesús, xaq k'u te'talik xkik'ut kib' kieb' achijab' pa ki xkut ri sib'alaj saq ri katz'iaq. ");
INSERT INTO qucNNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","We achijab' ri' xech'awik, xkib'ij chke ri apóstoles: Tata'ib', alaq ri' ri aj Galilea, ¿jas che xaq k'o alaq chi', tajin käka'y alaq chikaj? —kecha chke. We Jesús ri' ri xyak b'i chxol alaq, xpaqi chikaj, käpe chi na ri Are' jumul chik. Je k'u wa' ru petik jas ri xub'ano, xe' chikaj, —xecha ri achijab' chke ri apóstoles. ");
INSERT INTO qucNNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Te k'u ri' xeqaj loq ri apóstoles cho ri juyub' ri xek'oji wi, ri käb'ix Ujuyub'al Olivos che. Xetzelejik, xeb'e' pa ri tinimit Jerusalén. Naqaj k'o wi ri juyub' ri' che ri Jerusalén, man naj tä k'u ri käb'inib'axik, xuwi ri ya'talik chi käb'in jun pa ri q'ij re uxlanem (kraj are jun kilómetro wa'). ");
INSERT INTO qucNNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Aretaq xeopan pa ri tinimit, xepaqi pa ru kawiq ja re ri ja ri e jeqel wi. Ri e k'olik e are' ri tat Pedro, ri tat Jacobo, ri tat Juan, ri tat Andrés, ri tat Felipe, ri tat Tomás, ri tat Bartolomé, ri tat Mateo, ri tat Jacobo u k'ojol ri tat Alfeo, ri tat Simón ri käb'ix “U Nimal Tinimit” che, rachi'l ri tat Judas, rachalal ri tat Jacobo. ");
INSERT INTO qucNNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Konojel wa' we apóstoles ri' junam ri ki chomanik xkimulij kib' amaq'el rech käka'n orar junam kuk' jujun ixoqib' kojonelab', kachi'l ri nan María ru nan ri Jesús, xuquje' taq ri rachalal. ");
INSERT INTO qucNNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Pa taq ri q'ij ri' ki mulim kib' ri kojonelab'. Kraj e are' jun ciento ruk' juwinaq ri' ri ki mulim kib'. Xwalij k'u ri tat Pedro, xtak'i chkiwäch ri qachalal che ki ch'ab'exik, xub'ij chke: ");
INSERT INTO qucNNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Qachalal, tzrajwaxik wi chi käb'antajik jas ri kub'ij ru Loq' Pixab' ri Dios ri Tz'ib'talik, ri xub'ij loq ri Loq'alaj Espíritu chuchi' ri qa mam David ojer, —kächa'. Ri qa mam David xch'aw chrij ri Judas ri xk'amow ki b'e ri jumulaj winaq ri xechapow ri Qajaw Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ri Judas jun ri are' chqaxol nab'e, xyi' che chi kächakun junam quk'. ");
INSERT INTO qucNNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Are k'u ri are' xuloq' jun rulew ruk' ri puaq, ri tojb'al re ri etzelal ri xub'ano. Ch'ikilik xqajik, xtzaq pulew, xraq'atin ru pam, xel loq juntir ri rixko'l, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Xel k'u u tzijol wa' ri xuk'ulmaj ri Judas chkixol konojel ri winaq pa ri tinimit Jerusalén. Xa je ri' ri winaq xkikoj ri tzij Acéldama che ru b'i' ri ulew ri'. Ri tzij ri' pa ri ki ch'ab'al ri winaq kel kub'ij Ulew re Kik'. ");
INSERT INTO qucNNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Tz'ib'tal k'u pa ri wuj Salmos, kub'ij: Chtoli' kan u pam ri rachoch, chwonob'ax kanoq, mat k'o chi na jun käk'oji chupam, —kächa'. Xuquje' kub'ij: Ri reqle'n ri are', chyo'q che jun winaq chik, —kächa', —xcha ri tat Pedro chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","E k'o k'u achijab' chqaxol ri xujkachi'laj amaq'el aretaq xk'oji ri Qajaw Jesús quk'. ");
INSERT INTO qucNNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Tzaretaq ri xb'an u qasna' ri Jesús rumal ri tat Juan, k'ä aretaq xk'am b'i ri Are' chikaj chqaxol, e k'olinaq we achijab' ri' quk'. Tzrajwaxik k'ut chi jun chke ri e are' kok quk' chutzijoxik chi qas tzij xk'astaj b'i ri Qajaw Jesús chkixol ri käminaqib', —xcha ri tat Pedro chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Xkichomaj k'u kij kieb' achijab': E are' ri tat José ri käb'ix Barsabás che, ri xuquje' käb'ix Justo che, rachi'l ri tat Matías. ");
INSERT INTO qucNNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Xka'n orar, xkib'ij: Qajaw, etam la ri kanima' konojel ri winaq, k'utu b'a' la chqawäch jachin chke we kieb' achijab' ri' are cha'tal umal la, ");
INSERT INTO qucNNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","rech kok ri' che apóstol, kuk'am k'u ri eqle'n ri xuya kan ri Judas aretaq xqaj pa mak, xe' k'u chila' jawije' ri ya'tal wi che, —xecha che ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Xkesaj k'u suerte che rilik jachin ri käkanajik. Are k'u ri suerte xqaj chrij ri tat Matías. Xok k'u ri are' kuk' ri julajuj apóstoles. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Aretaq xuriq ri nimaq'ij ri käb'ix Pentecostés che, konojel ri kojonelab' junam ki wäch ki mulim kib' pa jun ja. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Xaq te'talik xkita jun nimalaj jininem ri xpe chikaj, je' jas jun nimalaj kiäqiq' ri xjinin pa ronojel ri ja jawije' ri e t'uyul wi ri kojonelab'. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Te ri' k'o ri xkilo, je' ta ne jas jujun u xaq q'aq' ri xqaj pa ki jolom chkijujunal. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Je ri' ri Loq'alaj Espíritu xuchap kanima' konojel, xkichaplej ch'awem pa jule' taq ch'ab'al chik ri xeuya ri Loq'alaj Espíritu chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Pa taq ri q'ij ri' e jeqel pa ri tinimit Jerusalén achijab' aj Israel ri keniman che ri Dios, ri e petinaq pa konojel taq ri tinimit cho ruwächulew. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Aretaq xkita wa' jas ri xkik'ulmaj ri kojonelab', xkimulij kib' k'ia winaq. Man xkiriq taj jas käka'no rumal chi chkijujunal ri winaq xkito chi ri kojonelab' kech'aw pa ri jalajoj taq ki ch'ab'al ri e are'. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Xkixej k'u kib', sib'alaj xkikajmaj ri tajin käb'anik. Xkitzijob'ela kib', xkib'ij: ¡Chiwilampe'! ¿A mat aj Galilea konojel wa' we winaq ri' ri tajin kech'awik? ");
INSERT INTO qucNNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Jas lo u b'anik wa' chi kech'aw pa ri qa ch'ab'al uj ri qetamam loq tzpa ri qa ch'utinal? —kecha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","K'ia u wäch ri tinimit ri uj petinaq wi. Chqaxol uj, ri uj k'o waral, e k'o winaq ri aj Partia, aj Media, aj Elam, aj Mesopotamia, aj Judea, aj Capadocia, aj Ponto, aj Asia. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Xuquje' e k'o quk' ri aj Frigia, aj Panfilia, aj Egipto. E k'o k'u nik'iaj chik ri ajchila' pa África, ri e petinaq jela' chrij ri tinimit Cirene. E k'o xuquje' winaq aj Roma chqaxol. Jujun chke ri e are' e qas aj Israel, ri qas winaq aj Israel ri ki nan ki tat. Jujun chik k'ut xa e okinaq kuk' ri aj Israel winaq, junam ri ki chomanik chrij ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Xuquje' e k'o winaq aj Creta, xuquje' aj Arabia, —kecha'. Qonojel k'ut keqato chi käkitzijoj tzpa ri qa ch'ab'al uj chqajujunal ri nimaq taq kajmab'al ri u b'anom ri Dios, —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Sib'alaj ki kajmam kib' konojel ri winaq, man xkiriq tä k'u jas käka'no. Xkitzijob'ela kib', xkitala chb'il taq kib', xkib'ij: ¿Jas lo u b'anik wa'? —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","E k'o jujun ri xa xkitze'j ki wäch ri kojonelab', xkib'ij k'ut: ¡Wa' we winaq ri' xa e q'ab'arelab'! —xecha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Te k'u ri' ri tat Pedro, junam kuk' ri julajuj apóstoles chik, xwalijik, xtak'i chkiwäch ri winaq che ki ch'ab'exik. Ko xch'awik, xub'ij k'u chke konojel ri e k'olik: Tata'ib', alaq aj Judea, xuquje' onojel alaq ri jeqel alaq waral pa Jerusalén, tatab'ej na alaq ri kinb'ij, chetamaj alaq wa', —kächa chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Qonojel ri uj ri qa mulim qib' waral, man uj q'ab'arelab' taj jas ri kächomaj alaq. K'ä te ne u b'elej hora rech ri aq'ab'il chanim ri'. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Xane ri tajin kil alaq kämik ri' are wa' ru b'im loq ri qa mam Joel ri q'alajisal re ru Loq' Pixab' ri Dios. Are k'u wa' ri xub'ij: ");
INSERT INTO qucNNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ri Dios kub'ij: Pa ri k'isb'al taq q'ij kintaq na b'i ri Loq'alaj Espíritu wech in pa ki wi' konojel winaq, —kächa'. Ri i k'ojol xuquje' ri i mia'l käkiq'alajisaj na ri tzij ri kinya chke. Ri alab'om ri e k'o chixol k'o ri käkil na ri kink'ut chkiwäch, ri tata'ib' k'ut ri k'o chi ri ki junab' k'o ri käkil na pa ri kachik', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Xuquje' pa taq ri q'ij ri' kintaq na b'i ri Espíritu wech in pa ki wi' ri patänil taq we, chi achijab' chi ixoqib', käkiq'alajisaj k'u na ri tzij ri kinya chke, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Kinb'an taq na kajmab'al cho ri kaj xuquje' cho ruwächulew. Ri kinb'ano e are' etal wa' chiwe. Xaq apawije' kilitaj wi na ri kik', ri q'aq', xuquje' nimaq taq sib' je' jas ri sutz', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ri q'ij käq'equmar na, ri ik' käkiäqar na je' jas ri kik', käk'ulmataj k'u wa' k'ä mäjoq kuriqa na ri nimalaj u q'ij ri Qajaw Dios. Ri q'ij ri' qas tzij sib'alaj nim u b'anik. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Konojel k'u ri käkita' na toq'ob' che ri Qajaw Dios, käkiriq na ru tob'anik ri Are', —kächa', —xcha ri apóstol Pedro chke ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Xutaqej tzij ri tat Pedro, xub'ij: Tata'ib', alaq aj Israel, tatab'ej na alaq ri kinb'ij, —kächa chke. Ri alaq, etam alaq chi ri Jesús aj Nazaret are wa' ri achi ri xyi' u q'ij rumal ri Dios chuk'utik chi are ri Are' taqowinaq loq. Q'alaj wa' chuwäch alaq kumal taq konojel ri kajmab'al ri xub'ano, ri nimaq taq k'utb'al, xuquje' ri etal ri xeub'an ri Dios chxol alaq rumal ri Are', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Pune ta ne je ri', aretaq xjach ri Jesús pa q'ab' alaq, xchap alaq, xya alaq pa ki q'ab' itzel taq achijab' chukämisaxik, xkirip k'u cho ri cruz. Je' xb'an alaq wa' che rumal chi je wa' ru chomam loq ri Dios chrij ojer, —kächa ri tat Pedro chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pune k'u je wa' ri xb'antajik, xpe ri Dios, xresaj pu q'ab' ri kämikal, xuk'astajisaj chi na ri Jesús chkixol ri käminaqib', rumal chi man k'o tä jas käkowin ri kämikal chub'anik che. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Qas ojer k'ut ch'awinaq loq ri qa mam David chrij ri Qajaw Jesús, xub'ij: Ri in amaq'el kinwil ri Qajaw k'o wuk'. K'o pa nu wikiäq'ab' rech man k'o tä jas ri käkowin jun chub'anik chwe chi kinxej wib', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Rumal ri' sib'alaj käkikot ri wanima', amaq'el kintzijoj tzij re kikotemal, ku'l k'u nu k'ux chrij ri Dios chi man k'o tä jun qas k'äxk'ol kinriqo, kuxlan k'u ri wanima'. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Man kinya tä la kan chkixol ri käminaqib', man käya tä la chi käq'ay ri nu cuerpo in, in ri' ri loq'alaj patänil e la. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","K'utum la ri b'e chnuwäch ri käk'aman b'i pa ri qas k'aslemal, k'o k'u na nimalaj nu kikotemal aretaq ri in k'o chi uk' la, —kächa', —xcha ri tat Pedro. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Qachalal, ri alaq aj Israel, tampe alaq ri kinb'ij: Q'alaj ri' chi ri qa mam David xkäm ri' ri are', xmuqtajik. Ri jul ri xmuq wi xaq are k'o waral quk' uj kämik, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Qetam k'ut chi ri qa mam David are jun q'alajisal re ru Loq' Pixab' ri Dios, ri are k'ut xukoj ri tzij ri xub'ij ri Dios che ruk' juramento, chi jun chke ri rachalaxik ri kil na u wäch pa taq ri q'ij ri kepe na, are ri Cristo ri käyi' na taqanik pu q'ab'. Kok che Nim Taqanel je' jas ri qa mam David. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ri qa mam David je' ta ne chi ojer tajin käril loq ri kuk'ulmaj ri Cristo, xch'aw chrij ru k'astajib'al. Xub'ij k'ut chi man käkanaj tä kan chkixol ri käminaqib', man käq'ay tä na ru cuerpo, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Are k'u wa' we Jesús ri' ri xk'astajisax rumal ri Dios, ri uj qonojel qas xqilo chi xk'astaj wa' chkixol ri käminaqib'. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Xwalijisax rumal ri Dios, xnimarisax u q'ij aretaq xut'uyub'a pa ru wikiäq'ab'. Aretaq k'ut u k'amom chik pu q'ab' ru Tat ri Loq'alaj Espíritu ri xuchi'j kanoq, xutaq loq pa qa wi', are k'u wa' ronojel ri tajin kil alaq, ri tajin käta alaq, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Pune k'u man xpaqi ri qa mam David chikaj, jas ri xub'an ri Qajaw Jesús, tzare k'ut xb'inik: Xub'ij ri Qajaw ri qa Dios che ri Wajaw: “Chatt'uyul pa ri nu wikiäq'ab', ");
INSERT INTO qucNNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","k'ä kinya na chawe chi katch'akanik, kattaqan pa ki wi' konojel ri käka'n ki k'ulel chawe,” —kächa ri Dios, —xcha ri qa mam David. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Qas rajwaxik chi konojel ri winaq aj Israel chketamaj chi we Jesús ri' ri xkämisaj alaq cho ri cruz, are wa' xcha'ik, xb'an Cristo che rumal ri Dios, xok k'u che Rajaw ronojel, —xcha ri tat Pedro chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Aretaq ri winaq xkita wa' we tzij ri', sib'alaj k'äx xkina' pa kanima', xkita' k'u che ri tat Pedro xuquje' chke ri nik'iaj apóstoles chik, xkib'ij: Qachalal, ¿jas rajwaxik käqa'no? —xecha chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ri tat Pedro xub'ij chke: Chk'exa ri anima' alaq, xuquje' ri chomanik alaq. Rajwaxik chi käb'an qasna' alaq chjujunal alaq pa ru b'i' ri Jesucristo, xa je ri' käsach mak alaq rumal ri Dios, ri Are' k'ut kusipaj ri Loq'alaj Espíritu chech alaq. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Are chech alaq ri Dios xuchi'j wi wa', chke ri alk'ual alaq, xuquje' chke ri winaq ri naj e k'o wi, chke k'u konojel ri kesik'ix na rumal ri Dios ri Qajaw rech kek'oji na ruk', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ri tat Pedro k'ia xub'ij chke. Kuk' taq wa' we tzij ri' xeuch'ab'ej, xeupixb'aj, xub'ij chke: Chto' ib' alaq, ya' alaq kan ri itzel taq winaq re we q'ij junab' ri', ri man jikom tä ri ki k'aslemal, —xcha ri tat Pedro chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Konojel k'u ri xkik'am pa kanima' ru Loq' Pixab' ri Dios ri xutzijoj ri tat Pedro, xb'an k'u ki qasna'. Kraj e oxib' mil ri' ri xeb'ok kuk' ri kojonelab' pa ri q'ij ri'. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Konojel k'u ri xekojonik, xkitaqej u b'anik jas ri xkik'ut ri apóstoles chkiwäch, xkimulij kib' ruk' kikotemal, junam xka'n orar, junam k'ut xkitij ri ki wa. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Sib'alaj xkixej kib' konojel ri winaq, rumal chi k'ia u wäch kajmab'al xuquje' taq etal xeb'an kumal ri apóstoles. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Konojel ri e kojoninaq che ri Cristo xa jun ki chomanik, xkijachala ri jastaq ke chb'il taq kib'. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Xkik'iyij ri kulew, xuquje' ri jastaq ke. Are k'u ri rajil xkijachala chkiwäch ri k'o ki rajwaxik. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ronojel q'ij xkimulij kib' pa ri nimalaj rachoch Dios, xuquje' xkimulij kib' cho taq kachoch ri kojonelab', xkijach ri wa chkiwäch konojel. Junam k'ut xewi'k, xekikotik, man k'o tä jun kuna' pa ranima' chi nim u b'anik. ");
INSERT INTO qucNNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Xkiya k'u u q'ij ri Dios, nim xe'il wi kumal konojel ri winaq. Ri Dios xub'ano chi ronojel q'ij e k'o nik'iaj winaq chik ri käkiriq ru tob'anik ri Are'. Xeuya k'u ri winaq ri' kuk' ri qachalal kojonelab'. ");
INSERT INTO qucNNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Jun q'ij xepaqi'k, xeb'e' ri tat Pedro rachi'l ri tat Juan pa ri nimalaj rachoch Dios pa ri u rox hora re ri b'enaq q'ij, ri hora ri käb'an ri oración. ");
INSERT INTO qucNNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Chila' k'ut k'o jun achi ri man xkowin taj xb'inik rumal ri k'äx ri k'o che ri raqan tzpa taq ri q'ij ri xil u wäch. Xyi' k'u wa' chuchi' ri nimalaj rachoch Dios chi' ri uchib'e ri kojom Sib'alaj Je'lik che ru b'i'. Je' k'u xb'an wa' che ri achi ronojel q'ij rech kuta' u limosna chke ri winaq ri keb'ok b'i pa ri nimalaj rachoch Dios. ");
INSERT INTO qucNNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Aretaq ri achi xeril ri kieb' apóstoles, ri tat Pedro, ri tat Juan okem ke pa ri rachoch Dios, xuta' jun u limosna chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ri e are' k'ut ko xeka'y che, xub'ij k'u ri tat Pedro: Chatka'y chqe, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ri achi ko xka'y chke, xuchomaj are' chi k'o jas käyi' kan che kumal. ");
INSERT INTO qucNNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Are k'u ri tat Pedro xub'ij che: Man k'o tä nu rajil, man k'o tä saq puaq, man k'o tä q'än puaq. Are k'u ri k'o wuk' kinya na chawe. Rumal ri Jesucristo aj Nazaret, pa ru b'i' ri Are', chatwalijoq, chatb'inoq, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ri tat Pedro xuchap che ru wikiäq'ab', xuyako. Chanim k'ut xekowir ri raqan ri achi, xuquje' ru qul taq raqan. ");
INSERT INTO qucNNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Xa je ri' ri achi ri u b'anom k'äx ri raqan xuk'iäq rib', xtak'ik, xuchaplej b'inem. Xok k'u b'i junam kuk' ri apóstoles pa ri nimalaj rachoch Dios, xb'inik, xuk'iäq rib', xuya u q'ij ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Konojel k'u ri winaq xkilo chi tajin käb'inik, xuquje' chi tajin kuya u q'ij ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Sib'alaj k'u xkikajmaj wa' ri xuk'ulmaj ri achi, man xkiriq tä k'ut jas käka'no rumal chi xketamaj u wäch ri achi chi are ri kät'uyi ronojel q'ij chuta'ik u limosna chuwäch ri nimalaj rachoch Dios pa ri porta ri kojom Sib'alaj Je'lik che ru b'i'. ");
INSERT INTO qucNNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ri achi ri u b'anom k'äx ri raqan nab'e, ri xkunatajik, ri are' man xutzoqopij tä ri tat Pedro, ri tat Juan. Konojel k'u ri winaq sib'alaj ki kajmam kib', xkitij anim, xkimulij kib' chkij ri kieb' apóstoles pa ri raqan ja ru b'i' Raqan Ja re Salomón ri e k'o wi ri e are'. ");
INSERT INTO qucNNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Aretaq ri tat Pedro xrilo chi xkimulij kib' ri winaq, xub'ij chke: Qachalal, alaq aj Israel, ¿jas che käkajmaj alaq wa' ri xb'antajik? ¿Jas che ko kujka'yej alaq? ¿A xa kächomaj alaq chi ruk' ri qa chuq'ab' uj o xa rumal chi sib'alaj uj nimanelab' che ri Dios xqa'no chi käb'in we achi ri'? ");
INSERT INTO qucNNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Man je' tä ri', xane are ru Dios ri qa mam Abraham, ri qa mam Isaac, xuquje' ri qa mam Jacob, are Dios wa' xa xunimarisaj u q'ij ri Jesús, ri loq'alaj u K'ojol ri xjach alaq pa ki q'ab' ri q'atal taq tzij. Aretaq ri tat Pilato xuchomaj u tzoqopixik b'ik, ri alaq man xaj tä alaq. ");
INSERT INTO qucNNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Man xaj tä alaq chi kätzoqopix ri loq'alaj u K'ojol ri Dios ri qas jikom ranima', xane xb'ij alaq chi are utz kätzoqopix jun kämisanel chuk'exwäch ri Are'. ");
INSERT INTO qucNNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Xaq je ri' xkämisaj alaq ri Jesús, ri jun ri käyo'w ri qas k'aslemal chke ri winaq. Ri Dios k'ut xuk'astajisaj ri Are' chkixol ri käminaqib'. Ri uj k'ut xqilo chi qas tzij xk'astajik. ");
INSERT INTO qucNNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Rumal k'u ri kojonik che ru b'i' ri Jesús xutzir we achi ri' ri kil alaq, ri etam alaq u wäch. Ri kojonik ri' che ri Jesús, are wa' xb'anowik chi xutzir kanoq we achi ri' chuwäch onojel alaq, —kächa ri tat Pedro. ");
INSERT INTO qucNNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Wetam k'u in, qachalal, chi ri alaq, xuquje' ri k'amal taq b'e alaq, xkämisaj alaq ri Jesús rumal chi man qas käch'ob' alaq ri tajin käb'an alaq. ");
INSERT INTO qucNNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ri Dios k'ut xuya' chi je wa' xb'anik, rech je' kel wi ri u b'im loq ri Are' kumal konojel ri ojer taq q'alajisal re ru Loq' Pixab', chi ri Cristo ri cha'tal rumal ri Dios kuriq na k'äx. ");
INSERT INTO qucNNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Rumal ri' chk'exa anima' alaq, tzelej b'a' alaq ruk' ri Dios rech kesachtaj ri mak alaq, —kächa'. We je' käb'an alaq wa', ri Dios kub'ano chi kepe na q'ij re jororemal rech kuxlan anima' alaq. ");
INSERT INTO qucNNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Xuquje' kutaq na loq ri Jesús ri ojer ri' cha'talik rech kok che Cristo che to'ik alaq. ");
INSERT INTO qucNNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Che we chanim ri' rajwaxik chi ri Jesucristo käk'oji na kan pa ri kaj k'ä kutzirisax k'u na ronojel rumal ri Dios, käb'an na u b'anik ronojel wa' jas ri u b'anom nab'e, je' jas ri xub'ij loq ri Dios chkichi' ri loq'alaj taq q'alajisal re ru Loq' Pixab' ojer, —kächa ri tat Pedro. ");
INSERT INTO qucNNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Rumal ri' ri qa mam Moisés xub'ij chke ri qa nan qa tat ojer: “Ri Qajaw ri qa Dios kucha' na jun chke ri i winaqil, kutaq k'u na rech kok che q'alajisal re ru Loq' Pixab', je' jas ri xinutaq in. Rajwaxik k'ut chi kinimaj ronojel ri kub'ij chiwe,” —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","“Apachin k'u ri man kuta tä ri kub'ij ri q'alajisal re ru Loq' Pixab' ri Dios ri', kesax na b'i pa ri tinimit Israel, käsachisax k'u na u wäch,” —xcha ri qa mam Moisés, —kächa ri tat Pedro. ");
INSERT INTO qucNNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Konojel k'u ri q'alajisal re ru Loq' Pixab' ri Dios, kächapletaj loq ruk' ri qa mam Samuel, xuquje' ri k'ä te xepe chik, konojel wa' ri xeq'alajisanik, xkiya loq u b'ixik wa' ri tajin käk'ulmataj kämik, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ronojel ri xuchi'j loq ri Dios kumal taq ri q'alajisal re ru Loq' Pixab' ri Are', ech alaq wa'. Ri Dios k'ut xub'an jun trato kuk' ri qa mam ojer chub'anik utzil chech alaq, aretaq xub'ij che ri qa mam Abraham: “Konojel ri winaq cho ruwächulew ketewchitaj k'u na kumal ri awachalaxik ri kil na ki wäch,” —xcha ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Aretaq ri Dios xuk'astajisaj ru K'ojol chkixol ri käminaqib', nab'e xutaq b'i uk' alaq, alaq ri' ri winaq aj Israel, rech kätewchix na alaq, rumal chi ri Are' kub'ano chi chjujunal alaq kätas ib' alaq chrij ri etzelal, —xcha ri tat Pedro chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ri tat Pedro rachi'l ri tat Juan k'ä tajin käkitzijob'ej ri winaq aretaq xepe ri sacerdotes aj Israel, kachi'l ri ki nimaqil ri chajil taq re ri nimalaj rachoch Dios, xuquje' ri tata'ib' saduceos, xeopan k'u kuk'. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Sib'alaj yaktajinaq koyowal, rumal chi ri tat Pedro, ri tat Juan tajin kekitijoj ri winaq, käkib'ij chi qas tzij kek'astaj chi na ri käminaqib'. Käkib'ij k'ut chi are k'utb'al wa' chke konojel chi xk'astaj ri Jesús chkixol ri käminaqib'. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Xekichapo, xekik'am b'ik, xekikoj k'u pa che' k'ä chukab' q'ij, rumal chi ya na'tam chik. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","E k'ia chke ri xkita ru Loq' Pixab' ri Dios ri xekojonik. We keajilax xaq xuwi ri achijab', kraj e job' mil ri e are'. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Chukab' q'ij k'ut xkimulij kib' pa Jerusalén ri k'amal taq ki b'e ri winaq aj Israel, ri ki nimaqil ri winaq, xuquje' ri tijonelab' re ri Pixab'. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Xkiriq kib' kuk' ri tat Anás rachi'l ri tat Caifás, ri qas ki nimaqil sacerdotes. E k'o ri tat Juan, ri tat Alejandro, xuquje' konojel ri kachalal ri ki nimaqil sacerdotes. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Xkitak'ab'a k'u ri tat Pedro, ri tat Juan chkiwäch, xkik'ot ki chi', xkib'ij chke: ¿Jachin ri yo'winaq pa i q'ab' chi kib'an ri tajin käqilo? ¿Jas u b'i' ri kikojo rech kixkowinik kib'an wa'? —xecha chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ri tat Pedro, qajinaq ri Loq'alaj Espíritu puwi', xub'ij chke: Tata'ib', alaq ri k'amal taq ki b'e ri winaq, alaq ri' ri ki nimaqil ri winaq aj Israel, ");
INSERT INTO qucNNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","kämik käk'ot alaq qa chi' rumal ri utzil ri xb'antaj che jun achi yawab' che retamaxik jas ri xb'an chukunaxik. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Chetamaj b'a' alaq xuquje' konojel ri winaq aj Israel chi rumal ri Jesucristo aj Nazaret, pa ru b'i' ri Are', xkunataj wa' we achi ri' ri k'o chuwäch alaq. Ri Jesús ri xkämisaj alaq cho ri cruz, ri xk'astajisax rumal ri Dios chkixol ri käminaqib', are ri Are' xkunan we achi ri'. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","We Jesús ri' are wa' ri ab'aj ri man xaj tä alaq, alaq ri' ri yakal taq ja, are ab'aj wa' xkoj che toq'eb'al re ri ja. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Man käriqtaj tä ru tob'anik ri Dios ruk' jachin jun winaq, xane xaq xuwi ruk' ri Jesús. Je ri', rumal chi ri Dios man u yo'm tä chqe ru b'i' jachin jun chik cho ronojel ruwächulew, ri ya'tal che chi rumal ri are' kuya' käqariq na ru tob'anik ri Dios, —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Aretaq ri q'atal taq tzij xkilo chi ri tat Pedro, ri tat Juan man käkixej tä kib' kech'awik, xuquje' xkilo chi xaq e winaq ri man k'o tä ri k'ia ketamam chrij wuj, sib'alaj xkikajmaj wa'. Te k'u ri' xkich'ob'o chi e are' taq wa' jujun chke ri xerachi'laj ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Xuquje' xkilo chi k'o ri achi ri xkunatajik tak'al kuk' ri apóstoles, xa je ri' man xkiriq tä chik jas käkib'ij. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Xkib'ij k'u chke ri apóstoles chi keb'el b'i chkiwäch, are k'u ri e are' xekanajik, xkitzijob'ela k'u kib'. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Xkib'ij: ¿Jas käqa'n chke we achijab' ri'? Qas tzij k'ut etamtal chik kumal konojel ri winaq pa ri tinimit Jerusalén ri kajmab'al etal ri ka'nom. Man kuya' tä k'ut käqab'ij chi man qas tzij taj. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Je b'a' qa'na wa', rech man käb'in tä más u tzijol ri xb'antajik. Cheqaxib'ij rech man ketzijon tä chik chuweq käb'ij chrij ri Jesús che jachin jun, —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Xekisik'ij k'ut, xetaqan chke chi man k'o tä chi jumul käkitzijoj chik ri Jesús, man käkiya tä chi k'u tijonik pa ru b'i' chke ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Xech'aw k'u ri tat Pedro rachi'l ri tat Juan, xkib'ij: Qas chomaj alaq ri', ¿a are utz lo käril ri Dios chi are kujniman chech alaq chuk'exwäch ri käqanimaj ri Are'? ");
INSERT INTO qucNNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ri uj k'ut man kujkowin taj ri mat käqab'ij chi na ri qilom xuquje' ri qa tom, —xecha chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ri q'atal taq tzij xkaj xekixib'ij ri apóstoles, k'ia ri xkib'ij chke, xekitzoqopij k'u b'ik. Man xkiriq taj jas käka'n chuk'äjisaxik ki wäch, rumal chi konojel ri winaq tajin käkiya u q'ij ri Dios rumal ri xb'antajik. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ri achi ri xb'antaj wi ri kajmab'al kunanik k'o chi na kawinaq u junab' ruk' u wi'. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Aretaq ri tat Pedro, ri tat Juan e tzoqopital chik, xeb'e' kuk' ri nik'iaj kojonelab' chik, xkitzijoj ronojel ri xb'ix chke kumal ri ki nimaqil ri sacerdotes xuquje' konojel ri ki nimaqil ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Aretaq xkita wa', junam xka'n orar, xkib'ij che ri Dios: Nimalaj Qajaw, lal ri' ri qas Dios ri xb'anow ri kaj, ri ulew, ri mar. Ronojel ri k'olik, xb'antaj k'u wa' umal la. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tzojer k'ut b'im la loq rumal ri Loq'alaj Espíritu chuchi' ri qa mam David ri patänil e la, xb'ij la: ¿Jas lo wa' chi ri winaq cho ruwächulew yaktajinaq koyowal, xaq ketontirik, käka'n k'u nimal? ¿Jas che wa' chi ri winaq käkichomaj u b'anik ch'oj ri man k'o tä u b'eyal? ");
INSERT INTO qucNNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ri nimaq taq taqanelab' cho ri uwächulew junam xkiwalijisaj kib', ri ki nimaqil ri winaq xkimulij kib' rech käkiyak kib' chrij ri Qajaw Dios, xuquje' chrij ri Cristo ri cha'tal rumal ri Dios, —xcha la, —kecha ri kojonelab'. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Xkitaqej oración, xkib'ij: Qas k'u tzij wi xkiriq kib' ri nim taqanel Herodes ruk' ri tat Poncio Pilato waral ri' pa we tinimit junam kuk' ri nik'iaj winaq chik kachi'l ri winaq aj Israel, xkimulij k'u kib' chrij ri loq'alaj K'ojol la, ri Jesús, ri cha'tal umal la. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Je' xka'n wa' rech je' käb'antajik jas ri chomam la loq chi rajwaxik käb'anik. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Qajaw, chilampe la kämik ri' chi k'ia ri tajin käkib'ij we winaq ri' chqij. Ya la chqe uj, ri uj patänil taq e la, chi kujkowinik käqatzijoj ri Loq' Pixab' la, man k'o tä käqaxej wi qib'. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Xuquje' käqata' che la chi käk'oji qe ri chuq'ab' la chub'anik kunanik chke ri yawab'ib', xuquje' che ki b'anik ri kajmab'al taq etal, xuquje' nimaq taq k'utb'al pa ru b'i' ri loq'alaj K'ojol la, ri Jesús, —xecha che ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Aretaq xeto'taj chub'anik orar, ri ja ri e k'o wi xslab'isaxik, konojel k'ut xqaj ri Loq'alaj Espíritu pa ki wi', man xkixej tä kib' xkitzijoj ru Loq' Pixab' ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ri k'ia winaq ri e kojoninaq che ri Cristo, xa jun ki chomanik konojel, käkina' pa kanima' chi xa e jun. Man k'o tä jun kub'ij chi xaq xuwi rech are' ri k'o ruk', xane konojel ri jastaq ke, are kech konojel wa'. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ri apóstoles ruk' nimalaj chuq'ab' xkitaqej u tzijoxik chi qas tzij xk'astaj ri Qajaw Jesús chkixol ri käminaqib'. Ri Dios k'ut kuya nimalaj taq tewchib'al pa ki wi' konojel ri kojonelab'. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Xa je ri' man k'o tä jun chkixol ri k'o u rajwaxik, rumal chi konojel ri k'o kulew o ri k'o kachoch xkik'iyij wa'. Are k'u ri rajil xkik'am b'i kuk' ri apóstoles. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Käkiya wa' we puaq ri' pa ki q'ab', ri e are' k'ut käkijach wa' chkiwäch ri k'o ki rajwaxik. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Xaq je ri', k'o jun tata', jun chke ri levitas, José u b'i', ri xil u wäch pa Chipre, jun ch'äqap ulew wa' ri k'o pa ri mar. Ri tata' ri' xuquje' käb'ix Bernabé che kumal ri apóstoles. Kel kub'ij wa' chi are jun ri kuku'b'isaj ki k'ux ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","We achi ri' k'o jun ch'äqap rulew xuk'iyij, xuk'am k'u b'i ri rajil, xujach pa ki q'ab' ri apóstoles. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","K'o k'u jun achi chik u b'i' Ananías, ri rixoqil are Safira u b'i'. Junam xkichomaj u k'iyixik jun ch'äqap kulew. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ri achi xresaj kan jub'iq' che ri puaq ri rajil ri ulew, retam k'u wa' ri rixoqil. Je ri' xa nik'iaj ri puaq xuk'am b'ik, xujach pa ki q'ab' ri apóstoles, je' ta ne chi are tz'aqat ri puaq ri xyi' kumal. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Xpe k'u ri tat Pedro, xub'ij che ri tat Ananías: Ananías, ¿jas che xya la che ri Satanás chi kok pa ri anima' la, xb'an la tzij che ri Loq'alaj Espíritu ruk' ri sub'unik ri xb'an la, xesaj k'u la kan nik'iaj che ri rajil ri ulew ri xk'iyij la? ");
INSERT INTO qucNNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿A mat ech la ri ulew aretaq mäjoq käk'iyij la? Aretaq xk'iyij la ri ulew, ¿a mat ech la ri puaq? —kächa'. ¿Jas k'u che xchomaj la wa' pa anima' la? Man are tä chke ri winaq ri xb'an wi la tzij ruk' ri sub'unik, xane are che ri Dios ri xb'an wi la, —xcha ri tat Pedro che. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Aretaq ri tat Ananías xuta wa' we tzij ri', xtzaq pulew, xkämik. Konojel k'u ri xetow ri xb'antajik sib'alaj xkixej kib'. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Xepe k'u ri alab'om, xkipis ru cuerpo pa jun payu', xkik'am b'ik, xe'kimuqu kanoq. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kraj ok'owinaq chi oxib' horas xopan ri rixoqil ri tat Ananías. Man retam tä k'ut jas ri xb'antajik. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Xub'ij k'u ri tat Pedro che: B'ij la chwe, ¿a je' puaq wa' ri xb'ij alaq chi xyi' che ri ulew ri xk'iyij alaq? —kächa'. Xub'ij k'u ri ixoq: Je', jela' ri puaq, —xcha che ri tat Pedro. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ri tat Pedro xub'ij che ri ixoq: ¿Jas che xchomaj alaq junam chi käkowin alaq chub'anik ri sub'unik che ri Loq'alaj Espíritu rech ri Qajaw? —kächa'. Chilampe la, xaq chi' ri porta chik e k'o wi ri alab'om ri xe'kimuqu kan ri achajil la, käk'am na b'i la xuquje' kumal ri e are', —xcha ri tat Pedro che. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Chanim xtzaq ri nan Safira pulew chuwäch ri tat Pedro, xkämik. Aretaq xeb'ok b'i ri alab'om, k'ä te xkilo käminaq ri nan Safira. Xkik'am k'u b'ik, xe'kimuqu kan chuxkut ri rachajil. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Konojel ri qachalal kojonelab', xuquje' konojel ri xkita wa' ri xb'antajik, sib'alaj xkixej kib'. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Sib'alaj k'u k'ia u wäch taq kajmab'al, xuquje' nimaq taq k'utb'al tajin keb'antaj chkixol ri winaq kumal ri apóstoles. Konojel ri kojonelab' k'ut tajin käkimulij kib' amaq'el pa ri raqan ja re ri nimalaj rachoch Dios, ri käb'ix Raqan Ja re Salomón che. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Man k'o tä jun chke ri nik'iaj winaq chik kukoch'o kok kuk' ri kojonelab', pune sib'alaj nim ke'il wi kumal ri winaq re ri tinimit. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","E k'ia k'u ri xekojon che ri Qajaw Jesús, chi achijab' chi ixoqib', je ri' chi sib'alaj xek'iar ri kojonelab'. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Xa kumal ri kajmab'al ri tajin käka'n ri apóstoles, ri winaq xekesaj loq ri ki yawab' pa taq ri b'e, xekiya pa taq ch'at, cho taq pop rech aretaq kok'ow ri tat Pedro chkixkut, xuwi ta ne ru nanoch' käqaj pa ki wi' rech keutzirik. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Xuquje' ne ri winaq ri keb'el pa taq ri tinimit ri e k'o chunaqaj ri Jerusalén, xkik'am loq ri ki yawab' kachi'l ri tajin käkiriq k'äx kumal ri itzelalaj taq espíritus ri e k'o chke. Konojel k'ut xekunatajik. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Are k'u ri ki nimal sacerdotes, xuquje' konojel ri rachi'l, ri winaq ri käb'ix saduceos chke, sib'alaj k'äx käkina' chkij ri apóstoles rumal chi sib'alaj nim ke'il wi kumal ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Xekichapo, xekikoj pa che' jawije' e k'o wi ronojel u wäch ajpache'. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Xpe k'u jun ángel ri xtaq loq rumal ri Qajaw Dios, chaq'ab' k'ut xujaq ri porta rech ri che', xeresaj loq, xub'ij chke: ");
INSERT INTO qucNNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Jix pa ri nimalaj rachoch Dios, chixtak'al chila' che ki tzijob'exik ri winaq chrij wa' we k'ak' k'aslemal ri', —xcha ri ángel chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Xkita ri xb'ix chke rumal ri ángel. Je k'u ri' chukab' q'ij xeb'ok pa ri nimalaj rachoch Dios, xkichap k'u ki tijoxik ri winaq. E k'o ri apóstoles chila' aretaq ri ki nimal sacerdotes kuk' ri rachi'l xekisik'ij konojel ri ki nimaqil ri winaq aj Israel xuquje' konojel ri nimaq taq tata'ib' rech käkimulij kib'. E are' taq wa' xetaqan b'i che ki k'amik loq ri apóstoles pa che'. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Aretaq k'ut xeopan ri taqo'n pa che', man xekiriq tä k'u ri apóstoles. Xetzelejik, xekiya u b'ixik wa'. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Je wa' xkib'ij: Aretaq ri uj xujopanik xqilo chi ri che' utz b'anom che u tz'apixik, xuquje' chi ri chajinelab' e k'o chi' taq ri porta. Aretaq k'ut xqajaqo, k'ä te xqilo chi man k'o tä jun chupam, —xecha chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Aretaq xkita wa' we tzij ri', ri qas ki nimal sacerdotes, xuquje' ri k'amal ki b'e ri chajil taq re ri nimalaj rachoch Dios, xuquje' ri ki nimaqil ri sacerdotes xkita'la chb'il taq kib', xkib'ij: ¿Jas ta lo ri käk'ulmataj chi na? —xecha'. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Chanim k'ut xopan jun achi, xub'ij chke: Ri achijab' ri xkoj alaq pa che', chanim e k'o pa ri nimalaj rachoch Dios, tajin kekitijoj ri winaq, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Chanim ri k'amal ki b'e ri chajil taq re ri nimalaj rachoch Dios, xe' che kilik ri apóstoles, xeuk'am k'u b'i ri chajinelab' che rachi'l. Xeuk'am loq ri tat Pedro, ri tat Juan ruk' utzil, man k'o tä k'u jas xub'an chke rumal chi kuxej rib' chkiwäch ri winaq, we ne ri are' käb'an che ab'aj kumal. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Aretaq xek'amtaj loq, xekiya chkiwäch ri ki nimaqil ri winaq ri ki mulim kib'. Xpe ri ki nimal sacerdotes, xuk'ot ki chi', xub'ij: ");
INSERT INTO qucNNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","¿A mat xqab'ij chiwe ruk' pixb'enik chi man keitijoj tä chik ri winaq chrij ri Jesús? ¡Chiwilampe ri i b'anom! Kämik k'ut i jab'um ri i tijonik pa ronojel we tinimit Jerusalén. Xuquje' kib'ij chi uj ri uj ajchaq' mak che ru kämikal we achi ri' ri Jesús, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ri tat Pedro, xuquje' ri nik'iaj apóstoles chik xech'awik, xkib'ij che: Tzrajwaxik wi are käqanimaj ri kub'ij ri Dios nab'e chuwäch ri käkib'ij ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ri ki Dios ri qa mam ojer xuk'astajisaj ri Jesús ri xkämisaj alaq, ri xrip alaq cho ri cruz. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Tzare wa' we Dios ri' xunimarisaj u q'ij ri Jesús, xut'uyub'a pa ru wikiäq'ab', xukoj che K'amal B'e chke ri winaq, xuquje' xukoj che To'l Ke. Je' xub'an wa' rech ri winaq aj Israel käkik'ex kanima', käkik'ex ki chomanik, käkiriq k'u ri sachb'al ki mak. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ri uj xqilo chi xk'astaj ri Jesús, rumal ri' ri Dios uj u kojom che q'alajisal taq re chkiwäch ri winaq junam ruk' ri Loq'alaj Espíritu ri u yo'm ri Dios chke ri keniman che, —xecha chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ri ki nimaqil ri winaq, aretaq xkita wa' sib'alaj xpe koyowal. Are käkaj kekikämisaj ri apóstoles. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","K'o k'u jun tata' chkixol ri ki nimaqil ri winaq, Gamaliel u b'i', are tijonel re ri Pixab', jun fariseo. Nim kil wi ri are' kumal ri winaq. Ri are' xtak'i aq'anoq, xub'ij chi ke'esax na b'i jun rat ri apóstoles. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Te k'u ri' xub'ij chke ri ki nimaqil ri winaq: Qachalal, alaq aj Israel, qas chomaj na alaq jas ri käb'an alaq chke we achijab' ri'. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Chna'taj chech alaq chi xke' kieb' oxib' junab' wa', xwalij jun achi, Teudas u b'i', ri xub'an che rib' chi nim u b'anik. E kiejeb' ciento achijab' ri xeb'ok ruk'. Xkämisax k'u ri are', xa je ri' konojel ri e k'o ruk' xejab'unik, xk'is k'u u wäch juntir. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","B'antajinaq chi wa', xwalij chi jun tata', Judas u b'i', aj Galilea, aretaq tajin käb'an ri censo, keajilax k'u ri winaq. E k'ia k'ut ri xeb'ok ruk'. Xkämisax k'u ri are' xuquje'. Xa je ri' konojel ri e k'o ruk' xejab'unik. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Rumal ri' kinb'ij chech alaq chi are utz na we käya kan alaq we achijab' ri', mänim ib' alaq kuk'. We ri tajin käkitzijoj o ri tajin käka'no are kech ri winaq, käsach na u wäch wa'. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","We k'u ne rech ri Dios, man käkowin tä alaq käsach alaq u wäch. Chilampe alaq chi mäyak ne ib' alaq chrij ri Dios, mäch'ojin alaq ruk' ri Are', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Konojel ri ki nimaqil ri winaq xkinimaj ri xub'ij ri tat Gamaliel. Xekisik'ij k'u ri apóstoles, xekich'ayo, xekirapuj. Te k'u ri' xkiya taqanik chke chi man k'o tä chi jumul käkitzijob'ej ri winaq pa ru b'i' ri Jesús. Te k'u ri' xekitzoqopij b'ik. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ri apóstoles k'ut xeb'el b'i chkiwäch ri ki nimaqil ri winaq, xekikotik rumal chi ri Dios xuya chke chi käkiriq k'ixb'alalaj k'äxk'ol rumal ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Man xkitanab'a tä k'u u tzijoxik ri Utzalaj Tzij re ri Evangelio chrij ri Jesucristo ronojel q'ij. Xekitijoj k'u ri winaq pa ri nimalaj rachoch Dios, xuquje' cho taq ja. ");
INSERT INTO qucNNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Pa taq ri q'ij ri' sib'alaj xek'iar ri kojonelab'. Are k'u ri kojonelab' ri kech'aw pa griego xkichap u yakik tzij chkij ri kojonelab' ri kech'aw pa hebreo. Ri winaq ri kech'aw pa griego käkib'ij chi ri malka'nib' ri e k'o kuk' man junam tä käb'an che kilik aretaq käjach ri wa. ");
INSERT INTO qucNNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Are k'u ri apóstoles xekimulij konojel ri kojonelab', xkib'ij k'u chke: Uj ri', ri uj apóstoles, man utz taj chi mat käqataqej u tzijoxik ru Loq' Pixab' ri Dios mak rech uj kujjachow ri wa. ");
INSERT INTO qucNNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Qachalal, tzukuj b'a' alaq wuqub' achijab' chxol alaq. We achijab' ri' rajwaxik chi utz ri ki k'aslemal, q'alaj chi kätaqan ri Loq'alaj Espíritu pa kanima', k'o ketamb'al, käqaya k'u pa ki q'ab' ru jachik ri wa. ");
INSERT INTO qucNNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Are k'u ri uj käqataqej u b'anik orar, xuquje' käqataqej u tzijoxik ru Loq' Pixab' ri Dios, —xecha ri apóstoles chke ri kojonelab'. ");
INSERT INTO qucNNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Konojel k'ut utz xkita ri xkib'ij ri apóstoles. Xkicha' k'u ri tat Esteban. Ri are' are jun tata' ri sib'alaj käkojon che ri Dios, xuquje' q'alaj chi ri Loq'alaj Espíritu kätaqan pa ranima'. Xuquje' xkicha' ri tat Felipe, ri tat Prócoro, ri tat Nicanor, ri tat Timón, ri tat Parmenas, xuquje' ri tat Nicolás ri aj Antioquía ri ojer okinaq kuk' ri winaq aj Israel, junam ru chomanik chrij ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Te k'u ri' xekiya we achijab' ri' chkiwäch ri apóstoles. Ri e are' k'ut xkiya ki q'ab' pa ki wi', xka'n orar. ");
INSERT INTO qucNNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Are k'u ru Loq' Pixab' ri Dios xjab'un u wäch, sib'alaj xek'iar ri kojonelab' pa ri tinimit Jerusalén. Xuquje' sib'alaj e k'ia chke ri sacerdotes aj Israel xeniman che ri Utzalaj Tzij re ri Evangelio. ");
INSERT INTO qucNNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Sib'alaj nim k'u ru toq'ob' ri Dios k'o puwi' ri tat Esteban, xuquje' yo'm nimalaj u chuq'ab' rech kub'an nimaq taq etal chkixol ri winaq, xuquje' nimaq taq kajmab'al. ");
INSERT INTO qucNNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Xewalij k'u jujun achijab' ri kepe pa jun rachoch Dios ri kojom “Kech Tzoqopim Achijab'” che ru b'i', xkichap k'u tzij ruk' ri tat Esteban. Xepe chi k'u nik'iaj achijab' chik chrij. E k'o ri aj Cirene, aj Alejandría, aj Cilicia, xuquje' nik'iaj chik ri e petinaq pa taq ri tinimit re Asia. ");
INSERT INTO qucNNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Man xekowin tä k'ut xkiq'atej u wäch ru tzij ri tat Esteban, rumal chi ri are' k'o u no'j, käch'aw k'u ruk' ri etamanik ri yo'm che rumal ri Loq'alaj Espíritu. ");
INSERT INTO qucNNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Xekitoj k'u jujun achijab' rech käkib'ij chi qas tzij ki tom ri tat Esteban kub'ij ri äwas u b'ixik chrij ri qa mam Moisés xuquje' chrij ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Je ri' xka'no, xkikojola ki k'ux ri winaq xuquje' ri nimaq taq tata'ib' kachi'l ri tijonelab' re ri Pixab' rech käpe koyowal chrij ri tat Esteban. Xkimajij k'u ri tat Esteban, xkichapo, xkik'am b'i chkiwäch ri ki nimaqil ri winaq. ");
INSERT INTO qucNNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Xuquje' xekitzukuj achijab' rech käkib'ij ri man qas tzij taj chrij ri tat Esteban. We winaq ri' käkib'ij: We achi ri' man käkos tä chub'ixik ri äwas u b'ixik chrij we loq'alaj rachoch Dios ri' ri qech uj, xuquje' chrij ru Pixab' ri qa mam Moisés. ");
INSERT INTO qucNNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Qa tom k'ut ri are' kub'ij chi we Jesús ri' ri aj Nazaret kusach na u wäch we nimalaj rachoch Dios ri', xuquje' kuk'ex na ronojel ri uj u naq'atajisam wi kan ri qa mam Moisés, —xecha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Te k'u ri' ri ki nimaqil ri winaq xuquje' konojel ri e t'uyul pa ri q'atb'al tzij, aretaq xeka'y che ri tat Esteban, xkilo chi ru palaj are je' jas ru palaj jun ángel. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Xpe ri ki nimal sacerdotes, xuta' k'u che ri tat Esteban, xub'ij: ¿A qas tzij wa' ri tajin käb'ix chawij? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Xch'aw k'u ri tat Esteban, xub'ij chke konojel: Loq'alaj taq qachalal, alaq k'amal taq qa b'e, tampe alaq ri kinb'ij, —kächa'. Ri qa Dios, ri sib'alaj nim u q'ij, xuk'ut rib' chuwäch ri qa mam Abraham ojer aretaq k'o pa taq ri juyub' re Mesopotamia, k'ä mäjoq käq'ax are' pa ri tinimit Harán. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Xub'ij che: “Chaya kan ra tinimit, xuquje' konojel ri awachalaxik, rech kate' pa ri ulew ri kink'ut na chawäch,” —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Xel k'u b'i ri qa mam Abraham pa ri ki tinimit ri winaq aj Caldea, xe'k, xk'oji pa Harán. Te k'u ri', aretaq käminaq chi ru tat, xk'am loq rumal ri Dios waral pa we tinimit ri k'o wi alaq kämik. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Man xyi' tä k'u ch'äqap ulew che rechb'al ri qa mam Abraham pa we tinimit ri' rumal ri Dios, man k'o tä k'u ne jun alaj ch'äqap ri kuya' käk'oji wi. Xub'ij k'u ri Dios che chi käpe na ri q'ij aretaq ri are' kärechb'ej na ri ulew, käkanaj kan wa' we ulew ri' chke ri ralk'ual aretaq käkäm ri are', pune ta ne mäja' k'o ralk'ual ri qa mam Abraham pa taq ri q'ij ri'. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Xuquje' xub'ij ri Dios che chi ri ralk'ual ri kil na ki wäch kek'oji na pa jun tinimit chik, ri man ki tinimit taj. Kek'oji na pa ki q'ab' ri winaq jela', kepatänin na chke. Are kiejeb' ciento junab' käkiriq na k'äx chila', —xcha ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Xuquje' xub'ij ri Dios che: “Ri in kinq'at na tzij pa ki wi' ri nik'iaj winaq chik ri kekojow na che patänil taq ke. Keb'el k'u na loq chila', kinkipatänij na waral ri',” —xcha ri Dios che. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Xuquje' xub'an jun trato ri Dios ruk' ri qa mam Abraham. Che retal ri trato xtaqan ri Dios chi käq'at ru cuerpo jun achi o jun ala. Rumal ri' ri qa mam Abraham, aretaq ilom chi u wäch ri alaj a Isaac ru k'ojol, chuwajxaq q'ij xukoj ri etal che ru cuerpo. Xuquje' je' xub'an ri tat Isaac che ri a Jacob ru k'ojol, ri tat Jacob xuquje' xukoj ri retal ri trato chke ru k'ojol ri are', xq'at ri ki cuerpo. Ri kab'lajuj u k'ojol ri tat Jacob e are wa' ri ojer taq ki mam konojel ri winaq aj Israel kämik, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ri ralk'ual ri tat Jacob, ri qa mam ojer, k'äx xkina' che ri a José ri ki chaq', xkik'iyij k'ut rech käk'am b'i pa Egipto. Ri Dios k'ut, k'o ri Are' ruk' ri a José. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Xuto' k'ut pa konojel taq ri k'äxk'ol ri xuriqo. Xuya u no'j, xuya che chi utz kil wi rumal ri Faraón ri nim taqanel puwi' ri Egipto. Aretaq achi chik ri a José, ri Faraón xukoj ri are' che q'atal tzij puwi' ronojel ri Egipto, xuquje' xukoj ri are' che taqanel puwi' ri rachoch. Ronojel k'ut xuya pu q'ab', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Xpe k'u wi'jal xuquje' nimalaj k'äxk'ol puwi' ronojel ri Egipto, xuquje' puwi' ronojel ri Canaán. Ri qa nan qa tat ojer man k'o tä chi ri käkitijo. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Are k'u ri tat Jacob, aretaq xuto chi k'o triko pa Egipto, xeutaq b'i ri u k'ojol jela'. Ri kab'lajuj u k'ojol ri tat Jacob, e are k'u wa' ri qa mam ojer. Are k'u nab'e mul wa' ri xeb'e' pa Egipto. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Chukamul chik ri xeb'e'k, are chi' ri tat José xuk'ut rib' chkiwäch ri rachalal, xretamaj k'u ri nim taqanel, ri Faraón, jachin taq ri rachalaxik ri tat José. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Xtaqan k'u ri tat José chuk'amik ri Jacob ru tat, xuquje' konojel ri nik'iaj rachalaxik. E oxk'al olajuj winaq k'u wa' chkonojel. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Je' u q'axik wa' ri tat Jacob pa Egipto junam kuk' ri rachalaxik, chila' k'ut xkäm wi. Xuquje' chila' xekäm wi ri kab'lajuj u k'ojol, ri ojer taq qa mam. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Xk'am k'u loq ri ki cuerpo pa Siquem rech kemuq pa ri muqub'al ri xuloq' ri qa mam Abraham chke ru k'ojol ri tat Hamor aj Siquem ruk' ru rajil ri are', —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Aretaq k'ut xa jub'iq' kraj man kopan ri q'ij ri käb'antajik jas ru b'im ri Dios ruk' juramento che ri qa mam Abraham, ri tinimit Israel xnimarik, sib'alaj xek'iar k'u ri qa winaqil pa Egipto. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Are chi' k'ut xok chi na jun taqanel chik puwi' ri Egipto ri man retam tä u wäch ri tat José. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","We nim taqanel ri' xna'w che ki sub'ik ri qa winaqil, xub'an k'u etzelal chke ri qa nan qa tat ojer. Xub'an k'äx chke, xeutaqo rech kekiwonob'a kan ri alaj taq kalk'ual ri te' xil ki wäch rech xaq kekämik. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Pa taq k'u ri q'ij ri' xil u wäch ri alaj a Moisés. Are sib'alaj utz xil wi rumal ri Dios. Ru nan u tat xekowinik xkik'iyisaj na oxib' ik' cho kachoch. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Aretaq k'ut xajwatajik chi xkiya kanoq, xriqtaj rumal ru mia'l ri Faraón ri taqanel puwi' ri Egipto, xuk'am b'i cho rachoch, xuk'iyisaj, xub'an ralb'al che. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Je ri' ri a Moisés xk'ut ronojel u wäch etamb'al re Egipto chuwäch, xuquje' ronojel u wäch no'j. Rumal wa' ri a Moisés xk'oji nimalaj u no'j. Nim chi k'u u q'ij ri are'. Xq'alajin k'u wa' aretaq xch'awik, xuquje' pa ronojel ri xub'ano, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Aretaq tz'aqat chik kawinaq u junab', xpe pa ranima' ri ki solixik ru winaqil, ri winaq aj Israel. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Chila' xril jun chke ru winaqil ri tajin käb'an k'äx che rumal jun aj Egipto. Xe' k'ut, xuto', xukämisaj k'u ri aj Egipto chutojik u k'exel ri k'äx ri xub'an che ri aj Israel. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Xuchomaj k'u ri tat Moisés chi ru winaqil käkich'ob' na chi ri Dios kukoj na ri are' che ki tzoqopixik. Ri e are' k'ut man xkich'ob' tä wa'. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Chukab' q'ij chik ri tat Moisés xeuriq kieb' winaq aj Israel ri tajin kech'ojinik, kraj k'ut kujach ki wäch, kuya utzil chkixol, xub'ij chke: “Ri alaq achalal ib' alaq. ¿Jas che k'äx käb'an alaq chb'il taq ib' alaq?” —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Are k'u ri jun ri tajin kub'an k'äx che ri rachi'l, xupaqchij apan ri tat Moisés jela', xub'ij che: “¿Jachin xatkojow che taqanel xuquje' che q'atal tzij pa qa wi'? ");
INSERT INTO qucNNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿A kawaj kinakämisaj jas ri xab'an che ri jun aj Egipto iwir?” —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Aretaq ri tat Moisés xuta wa' we tzij ri', xanimaj b'ik, xel b'i pa Egipto, xe' pa Madián. Xk'oji k'u chkixol winaq ri man u winaqil taj. Chila' k'ut xk'uli'k. Xil ki wäch kieb' u k'ojol, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ok'owinaq chi k'u kawinaq junab', xuk'ut rib' jun ángel chuwäch pa ri juyub' ri kätz'inowik, naqaj che ri nim juyub', Sinaí u b'i'. Ri ángel k'o pa ri q'aq' rech ri juwi' k'ix ri tajin käk'atik. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Sib'alaj k'u xukajmaj wa' ri tat Moisés aretaq xrilo. Aretaq xqeb' ruk' rech qas kärilo, xuto chi xch'aw loq ri Qajaw Dios, xub'ij: ");
INSERT INTO qucNNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“In ri' ri ki Dios ri a mam ojer, ru Dios ri a mam Abraham, ru Dios ri a mam Isaac, ru Dios ri a mam Jacob,” —xcha'. Are k'u ri tat Moisés xuxej rib', xb'irb'itik, man xukoch' tä chik xrilo. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Xub'ij k'u ri Qajaw Dios che: “Chewesaj ra xajäb', rumal chi ri ch'äqap ulew ri at k'o wi are loq'alaj ulew wa'. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Qas tzij wilom ri k'äx ri tajin käkiriq ri nu winaq pa Egipto. Nu tom ri koq'ej ri winaq, rumal k'u ri' in qajinaq loq che ki to'ik, rech ketzoqopitajik. ¡Tasa'jmpe'! Katintaq na b'i pa Egipto,” —xcha ri Qajaw Dios che, —kächa ri tat Esteban. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Are ri tat Moisés xetzelax u wäch kumal ri winaq aj Israel. Xkib'ij che: “¿Jachin xatkojow pa qa wi' che taqanel, xuquje' che q'atal tzij?” —xecha che. Pune je ri', are ri are' ri xutaq b'i ri Dios che taqanel pa ki wi' xuquje' che to'l ke. Je' xub'an ri Dios rumal ri ángel ri xuk'ut rib' chuwäch pa ri juwi' k'ix. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ri tat Moisés are ri are' ri xeresaj loq ri qa nan qa tat ojer pa Egipto. Xub'an nimaq taq k'utb'al xuquje' taq kajmab'al pa Egipto, pa ri Kiäq Mar, xuquje' pa taq ri juyub' ri kätz'inowik. Kawinaq junab' k'ut xub'an wa'. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Are wa' ri tat Moisés ri xub'ij chke ri winaq aj Israel: “Ri Dios kucha' na jun chke ri i winaqil, kutaq k'u na rech kok che q'alajisal re ru Loq' Pixab', je' jas ri xinutaq in. Rajwaxik k'ut chi kinimaj ronojel ri kub'ij chiwe,” —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Tzare k'u ri' ri tat Moisés ri xk'oji chkixol ri winaq aj Israel ri ki mulim kib' pa ri juyub' ri kätz'inowik, xuquje' xk'oji ri are' ruk' ri ángel ri xch'aw ruk' puwi' ri nim juyub', Sinaí u b'i', xuquje' kuk' ri qa nan qa tat ojer. Xuquje' xuta ri tzij ri kuya ri qas k'aslemal, xuk'am k'ut, xuya loq wa' chqe uj, —kächa ri tat Esteban chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ri qa mam ojer k'ut, man xkaj taj xeniman che, xane xa xketzelaj u wäch. Xkipaqchij ri qa mam Moisés, xkirayij pa kanima' ri ki tzelejik jumul chik pa Egipto. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Xkib'ij che ri tat Aarón: “Cheab'ana jujun qa tiox ri kenab'ej na chqawäch, rumal chi man qetam taj jas xuk'ulmaj we tat Moisés ri xujesan loq pa Egipto,” —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Xka'n k'u jun ki tiox ri je' käpe jun alaj ama' wakäx, xekikämisaj taq awaj, xekisipaj k'u cho ri ki tiox ri xka'no. Xka'n k'u jun nimaq'ij, xekikot ruk' ri jun tiox ri xaq e are' xeb'anowik. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Rumal ri' ri Dios xutas rib' chkij, xeutzoqopij kanoq rech kekiq'ijilaj ri q'ij, ri ik', ri ch'imil, je' jas ri käb'ix pa ri ki wuj ri q'alajisal taq re ru Loq' Pixab' ri Dios: Winaq aj Israel, pa taq ri kawinaq junab' ri xixk'oji pa ri juyub' ri kätz'inowik, ¿a xeikämisaj lo awaj che kisipaxik wa' chnuwäch in? ");
INSERT INTO qucNNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Man je' taj xib'ano, xane are xeiq'ijilaj nik'iaj taq dioses. Are xitelej ri rachoch ri dios, Moloc u b'i' (are jun carpa wa' ri rachoch ri ki dios Moloc), xuquje' ru ka'yeb'al ru ch'imil ri i dios, Renfán u b'i'. Xaq e tiox ri' ri ix xixb'anowik rech keiq'ijilaj. Xa rumal wa' kixinwesaj na b'i pa ri i tinimit ix, kixintaq k'u na b'i pa jun tinimit chik ri naj k'o wi, k'ä jela' ch'äqäp che ri tinimit Babilonia, —xcha ri Dios chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ri qa nan qa tat ojer, aretaq xkib'inib'ej ri juyub' ri kätz'inowik, k'o ri rachoch Dios kuk'. Are wa' ri b'anom ruk' manta, ri k'o wi ri tz'alam taq ab'aj re ri Pixab'. Je' k'u u b'anik wa' jas ri xub'ij ri Dios che ri qa mam Moisés, aretaq xub'ij che chi kub'an jun rachoch Dios ri je' u b'anik jas ri k'utum chuwäch. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ri qa nan qa tat ojer xkechb'ej wa' we rachoch Dios ri' pa ki q'ab' ri ki nan ki tat ri e are'. Aretaq k'ut ri winaq ri' rachi'l ri tat Josué xeb'okik, xek'oji pa ri kulew ri nik'iaj winaq chik ri esam b'i chkiwäch rumal ri Dios, xkik'am b'i ri rachoch Dios kuk'. Xeq'ijilan k'u chupam k'ä pa ru q'ijol ri qa mam David ojer. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ri nim taqanel David nim xil wi rumal ri Dios, je ri' chi xuriq nimalaj utzil pa ru k'aslemal. Rumal ri' are u rayinik kuyak jun qas rachoch ri Dios. Are Dios wa' ru Dios ri qa mam Jacob ojer xuquje'. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Are k'u ri tat Salomón ru k'ojol ri tat David xyakow wa' we ja ri' che ri Dios aretaq xok che taqanel. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Pune ri Nimalaj Dios aj Chikaj man käk'oji tä pa jun ja ri xa b'anom kumal winaq, jas ri xub'ij ri q'alajisal re ru Loq' Pixab' ri Dios: ");
INSERT INTO qucNNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ri kaj are nu t'uyulib'al ri kintaqan wi puwi' ronojel, are k'u ri ulew je' ta ne ruxlanib'al ri waqan. ¿Jas k'u u wäch ri ja ri kiwaj kiyak chwe? —kächa ri Qajaw Dios, ¿o jawije' k'o wi ri uxlanib'al ri kinuxlan wi? ");
INSERT INTO qucNNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿A mat are ri in ri xinb'anow ronojel ri k'olik? —xcha ri Dios, —xcha ri tat Esteban. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ri tat Esteban xutaqej u b'ixik chke ri ki nimaqil ri winaq: Ri alaq sib'alaj ab'ajarinaq ri anima' alaq. Ri anima' alaq man keniman tä che ri Dios, man kok tä k'u ru tzij pa jolom alaq. Alaq xaq junam kuk' ri man e kojonelab' taj. Ri alaq amaq'el käq'atej alaq u wäch ri Loq'alaj Espíritu. Junam alaq kuk' ri mam alaq ojer, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿A k'o lo jun chke ri q'alajisal taq re ru Loq' Pixab' ri Dios ri mat xb'an k'äx che kumal ri mam alaq ojer? Man k'o tä jun, xane xekikämisaj ri xeyo'w loq u b'ixik chi käpe na ri Cristo ri Jikomalaj Patänil re ri Dios. Are k'u wa' ri xjach alaq pa ki q'ab' ri winaq, xkämisaj alaq. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ru Pixab' ri Dios ri xyi' nab'e kanoq kumal ri ángeles che ri qa mam Moisés, are Pixab' wa' ri xyi' chech alaq. Pune je ri', ri xub'an ri Dios rech käyataj ri Pixab' pa q'ab' alaq, man känimaj tä alaq wa', —xcha ri tat Esteban chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ri winaq, aretaq xkita wa' we tzij ri', sib'alaj xpe koyowal che ri tat Esteban, xkimut'ut'ej ri ki ware chrij chuk'utik ri nimalaj koyowal. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Are k'u ri are' qajinaq ri Loq'alaj Espíritu puwi', xka'y chikaj, xril k'u ri je'lalaj u juluwem ri Dios, xuquje' xril ri Jesús, tak'al pa ru wikiäq'ab' ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Xub'ij k'ut: ¡Chilampe alaq! —xcha'. Kinwil ri kaj jaqtalik, xuquje' kinwil ri Ralk'ual ri Dios ri Qas Winaq k'o pa ru wikiäq'ab' ri Dios, —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ri nimaq taq tata'ib' xkitz'apij ri ki xikin, sib'alaj ko xkiraqaqej ki chi'. Xaq jun xkiyo' xeb'e' chrij ri tat Esteban. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Xkesaj b'i chrij ri tinimit, xkik'iäq k'u che ab'aj. Ri achijab' k'ut ri xeb'anow tzij chrij ri are' xkiya kan ri katz'iaq ruk' jun achi, Saulo u b'i'. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Aretaq tajin käkik'iäq che ab'aj, ri tat Esteban xub'an orar, xuta' toq'ob' che ri Qajaw Jesús, xub'ij: Qajaw Jesús, k'ama la ri wanima', —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Te k'u ri' xxuki'k, ko xuraq u chi', xub'ij: Tat, mäya la wa' we mak ri' chkij, —xcha ri tat Esteban. Xuwi xb'itaj wa' rumal, xel ranima'. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ri tat Saulo utz xrilo chi xkämisax ri tat Esteban. Qas k'u pa ri q'ij ri xkäm ri are' xchaptaj u b'anik nimalaj k'äx chke ri qachalal kojonelab' pa ri tinimit Jerusalén. Konojel k'ut xejab'ux b'ik. E k'o xeb'e' pa taq ri tinimit re Judea, e k'o nik'iaj chik xeb'e' pa taq ri tinimit re Samaria. Xuwi ri apóstoles xekanaj kanoq. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Xepe k'u jujun achijab' ri qas keniman che ri Dios, xkik'am b'i ri tat Esteban, xe'kimuqu kanoq. Sib'alaj xeb'oq' k'u chrij. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Are k'u ri tat Saulo xutaqej u b'anik k'äx chke ri qachalal kojonelab'. Xok cho taq ja, xeucharchatej b'i achijab', ixoqib', xeukoj k'u pa che'. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Are k'u ri kojonelab' ri xeb'el b'i pa ri tinimit Jerusalén, xkitzijoj ri Utzalaj Tzij re ri Evangelio apawije' chi' ri xeb'e' wi. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ri tat Felipe xe' pa jun tinimit re Samaria, chila' k'ut xuchaplej ki tzijob'exik ri winaq chrij ri Cristo. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ri winaq xkimulij kib' chrij ri tat Felipe. Sib'alaj xkitatab'ej ri tzij ri xub'ij. Xuquje' xkil ri kajmab'al taq etal ri tajin kub'ano. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","E k'ia k'u ri winaq ri e k'o itzelalaj taq espíritus chke. Xeutzir k'u wa' we winaq ri'. Ri itzelalaj taq espíritus, aretaq xeb'el chke ri winaq, xkiraq ki chi', xeb'e'k. E k'ia k'u ri käminaq ki cuerpo ri xekunatajik, xuquje' e k'ia ri u b'anom k'äx ri kaqan, ri man xekowin taj xeb'inik. Ri e are' xuquje' xekunatajik. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Je ri' chi konojel ri winaq pa ri tinimit ri' sib'alaj xekikotik. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","K'o k'u jun tata' pa ri tinimit ri', Simón u b'i', ri nab'e kanoq xub'an ri itzinik, xesub' ri winaq aj Samaria rumal. Xub'an che rib' chi ri are' sib'alaj nim u b'anik pa ri tinimit. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Konojel k'u ri winaq chi ak'alab' chi ri'jab' sib'alaj xkitatab'ej ri kub'ij ri achi ri', xkib'ij: We achi ri' are k'o ri nimalaj u chuq'ab' ri Dios ruk', —xecha'. Ri Nimalaj u Chuq'ab' ri Dios, —xuchix che ri are'. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ojer chi k'u ri' e sub'um loq ri winaq rumal ri itzinik ri tajin kub'ano. Rumal k'u ri' sib'alaj xkikoj ri xub'ij. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Aretaq k'ut ri winaq xkinimaj ri Utzalaj Tzij re ri Evangelio ri xutzijoj ri tat Felipe chke chrij ru taqanik ri Dios, xuquje' chrij ri Jesucristo, xa je ri' e k'ia chke xb'an ki qasna', chi achijab' chi ixoqib'. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Xuquje' ne ri tat Simón xkojonik, xb'an u qasna', xuchaplej k'u rachi'laxik ri tat Felipe. Sib'alaj xukajmaj ri nimaq taq kajmab'al, xuquje' ri nimaq taq etal ri xeb'antajik. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Aretaq ri apóstoles ri e k'o pa ri tinimit Jerusalén xkito chi ri winaq pa Samaria xkinimaj ru Loq' Pixab' ri Dios, xekitaq b'i ri tat Pedro rachi'l ri tat Juan jela'. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Aretaq xeopanik, xka'n orar pa ki wi' ri kojonelab' aj Samaria rech käqaj ri Loq'alaj Espíritu pa ki wi'. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Je ri', rumal chi man k'o tä jun chke qajinaq ri Loq'alaj Espíritu puwi'. Xuwi b'anom ki qasna' pa ru b'i' ri Qajaw Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Te ri' ri tat Pedro, ri tat Juan xkiya ri ki q'ab' pa ki wi' ri kojonelab', xqaj k'u ri Loq'alaj Espíritu pa ki wi'. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ri tat Simón xrilo chi aretaq ri apóstoles xkiya ri ki q'ab' pa ki wi' ri kojonelab', xqaj ri Loq'alaj Espíritu pa ki wi', xpe k'u ri are', xuchi'j puaq chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Xub'ij: Ya alaq we chuq'ab' ri' chwe in xuquje', rech apachin ri kinya ri nu q'ab' puwi' käqaj ri Loq'alaj Espíritu puwi', —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Xub'ij k'u ri tat Pedro che: Utz na we ta ri rajil la käsach u wäch wa' uk' la, rumal chi kächomaj la chi ri kusipaj ri Dios kuya' käloq' wa' ruk' puaq. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Man k'o tä e la quk' pa we chak ri', man ya'tal tä k'u wa' che la, rumal chi man jikom tä ri anima' la chuwäch ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ya la kan wa' we etzelal ri' ri chomam la. B'ochi'j b'a' la ri Dios, ta' la toq'ob' che chi käsachtaj ri mak la, are k'u ri' ri itzel chomanik ri xk'iy pa anima' la. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Q'alaj k'ut chi k'o ri k'äx ri t'uyul pa ri anima' la. Are wa' ru xera' ri etzelal. Je' ta ne chi ri lal chaptajinaq la rumal we etzelal ri', —xcha ri tat Pedro che ri tat Simón. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Xch'aw k'u ri tat Simón, xub'ij che ri tat Pedro: B'ana b'a' alaq orar pa nu wi' chuwäch ri Qajaw Dios, rech man kinriq tä ne jub'iq' ri k'äx ri xb'ij la chwe, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Aretaq ri kieb' apóstoles xeto'taj chub'ixik ru b'anom ri Dios pa ri ki k'aslemal, xuquje' chutzijoxik ru Loq' Pixab' ri Dios, xetzelej b'i pa Jerusalén. Xkitzijoj kan ri Utzalaj Tzij re ri Evangelio pa taq ri alaj taq tinimit re Samaria ri xeok'ow wi. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Te k'u ri' jun ángel xuch'ab'ej ri tat Felipe, xub'ij che: Chatwalij b'a', jat pa ru mox ri relb'al q'ij pa ri b'e ri kel b'i pa ri tinimit Jerusalén, käxuli pa Gaza, —xcha che. We b'e ri' are wa' ri käq'atan pa ri juyub' ri kätz'inowik. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Xwalij k'u b'i ri tat Felipe, xe'k. Xuriq k'u jun tata' aj Etiopía pa ri b'e. Are jun tata' eunuco, —kuchixik. We achi ri' sib'alaj nim u b'anik, are kilow ronojel ri jastaq re ri chichu' ri käkoj Candace che ru b'i'. Ri ixoq ri' are ri nim taqanel pa ki wi' konojel ri aj Etiopía. Ri tata' ri' u petik pa ri tinimit Jerusalén ri xuq'ijilaj wi ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Tzelejem k'u re pa ru tinimit, t'uyul pa ru carreta, tajin kusik'ij ri wuj ri xutz'ib'aj ri qa mam Isaías, q'alajisal re ru Loq' Pixab' ri Dios ojer. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ri Espíritu rech ri Dios xub'ij che ri tat Felipe: Chatqeb' ruk' we jun carreta ri', chawachi'laj b'ik, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Aretaq xqeb' ri tat Felipe, xuto chi ri tata' tajin kusik'ij ri wuj ri u tz'ib'am ri qa mam Isaías, xuta' k'u che: ¿A käch'ob' la jas kel kub'ij ri tajin käsik'ij la? —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ri tata' xub'ij che: ¿Jas ta kinb'an in chuch'ob'ik wa' we man k'o jachin ri käb'in chwe jas kel kub'ij ri tajin kinsik'ij? —xcha che. Xub'ij k'u che ri tat Felipe chi käpaqi loq pa ri carreta, kät'uyi b'i ruk' are'. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Jawije' ri tajin kusik'ij wi ri tata' pa ru Loq' Pixab' ri Dios, je wa' kub'ij: Je' jas ri käb'an che jun chij ri käk'am b'i pa pilik, je' xb'an che ri are'. Je' jas jun alaj chij ri man kuraq tä u chi' aretaq käsokax ri rismal, je' xub'an ri are', man k'o tä jas xub'ij. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Xqasax u q'ij ri are'. Pune man k'o tä u mak, xq'at tzij puwi'. Man jikom tä k'ut ri xb'an che, man k'o tä k'u jun ri xto'wik. ¿Jachin ta k'u ri käkowin che ki tzijoxik jas ki b'anik ri winaq ri xil ta ne ki wäch rumal ri are'? Man k'o tä jun, rumal chi xesax b'i pa ri tinimit, xk'am k'u b'ik pa kämisaxik, —kächa ru Loq' Pixab' ri Dios ri tajin kusik'ij ri tata'. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Xub'ij ri tata' ri nim u b'anik che ri tat Felipe: B'ana b'a' la toq'ob', b'ij la chwe, ¿jachin chrij tajin käch'aw ri q'alajisal re ru Loq' Pixab' ri Dios? ¿A are ri are' ri tajin käch'aw chrij chb'il rib', o are jun chik ri kub'ij? —kächa che. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Xch'aw k'u ri tat Felipe. Ruk' we tzij ri' ri tajin kusik'ij ri aj Etiopía, xuchaplej u tzijoxik ri Utzalaj Tzij re ri Evangelio chrij ri Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","E b'enaq pa ri b'e, ok'owem käka'n chuchi' jun ja', ri tata' aj Etiopía xub'ij che ri tat Felipe: K'o joron waral, ¿a mat kuya' käb'an nu qasna' chi'? —xcha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ri tat Felipe xub'ij che: We qas tzij käkojon la, kuya' käb'an ri qasna' la, —xcha che. Xch'aw k'u ri are', xub'ij: Kinkojo chi ri Jesucristo are ru K'ojol ri Dios, —xcha'. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Xtaqan k'u chutak'b'axik ri carreta. Ri kieb' xeqaj pa ri ja', xb'an k'u u qasna' ri tata' rumal ri tat Felipe. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Aretaq xeb'el loq pa ri ja', ri Espíritu rech ri Qajaw Dios xuk'am b'i ri tat Felipe. Ri tata' ri nim u b'anik aj Etiopía man xril tä chi u wäch. Xutaqej k'u ru b'e ri are', sib'alaj xkikot ranima'. ");
INSERT INTO qucNNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Are k'u ri tat Felipe te' kärilo chi k'o ri are' pa ri tinimit Azoto. Xel b'ik jela', b'enam re pa ri tinimit Cesarea. Pa ronojel tinimit ri xok'ow wi xutzijoj ri Utzalaj Tzij re ri Evangelio chke ri winaq k'ä xopan na pa Cesarea. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Are k'u ri tat Saulo sib'alaj royowal chkij ri winaq ri e kojoninaq che ri Qajaw Jesús. Ri are' kraj keukämisaj. ¡Xeuxib'ij k'ut! Rumal ri' xe' ri are', xtzijon ruk' ri ki nimal sacerdotes ri k'o pa ri tinimit Jerusalén. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Xuta' che chi kuya b'i jujun taq wuj che, ri kub'ij wi chi yo'm taqanik pu q'ab' rech kok pa taq ri rachoch Dios pa ri tinimit Damasco. Je ri' rech keutzukuj ri keniman che ri Utzalaj Tzij re ri Evangelio, chi achijab' chi ixoqib', che ki chapik rech keuk'am loq che koksaxik pa che' pa ri tinimit Jerusalén. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","B'enaq k'u pa ri b'e, k'o ri are' chunaqaj ri tinimit Damasco, xaq te'talik k'ut xtunun jun nimalaj saqil chrij ri xpe chikaj. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Xtzaq k'u pulew, te' xuto chi k'o jun ri xch'aw loq chikaj ri xub'ij: Saulo, Saulo, ¿jas che tajin kab'an we nimalaj k'äx ri' chwe? —xcha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ri tat Saulo xub'ij: ¿Jachin ri lal, Tat? —xcha che. Ri Jun ri xch'awik xub'ij: ¡In ri' ri Jesús! Ri k'äx ri tajin kab'ano, are chwe In ri tajin kab'an wi wa'. Xaq je ri' ri at tajin kariq k'äx jas ri kub'an ri wakäx ri kukoj aqan che ri jun che' t'ist'ik u wi', —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ri tat Saulo xuxej rib', xb'irb'itik, xub'ij: Tat, ¿jas kaj la chi kinb'ano? —xcha'. Xub'ij k'u ri Qajaw Jesús che: Chatwalijoq, jat pa ri tinimit, käb'ix k'u na chawe jas ri rajwaxik kab'ano, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ri achijab' ri e b'enaq pa ri b'e ruk' ri tat Saulo sib'alaj xkixej kib' rumal chi xkita ri ch'ab'al, man k'o tä k'u jachin xkilo. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Xwalij k'u ri tat Saulo, xujaq ru waq'äch, man xkowin tä k'ut xka'yik. Rumal ri' xa xyuqex b'i che ru q'ab', xk'am b'i pa ri tinimit Damasco. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Chila' k'ut xk'oji wi oxib' q'ij, man xkowin taj xka'yik. Man k'o tä k'u jas xutijo. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","K'o k'u jun kojonel pa ri tinimit Damasco, Ananías u b'i'. Xuk'ut rib' ri Qajaw Jesús chuwäch, xub'ij che: ¡Ananías! —xcha che. Ri are' xch'awik, xub'ij: In k'olik ri', Wajaw, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ri Qajaw Jesús xub'ij che: Chatwalij b'a', jat pa ri jun b'e ri käb'ix “Jikom” che. Aretaq katopan pa rachoch ri tat Judas, chata' che we k'o ri jun achi chila' aj Tarso, Saulo u b'i'. Chanim ri' tajin kub'an orar. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","K'o ri xuk'ut ri Dios chuwäch. Xril jun achi, Ananías u b'i', ri xok b'i ruk', xuya ru q'ab' puwi' rech käkowinik käka'y jumul chik, —xcha ri Qajaw Jesús che. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Xch'aw k'u ri tat Ananías, xub'ij: Qajaw, e k'ia ri ki b'im chwe chrij we achi ri' chi u b'anom k'ia u wäch k'äx chke ri winaq pa ri tinimit Jerusalén ri e kojoninaq che la. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ulinaq k'u waral, yo'm loq taqanik pu q'ab' kumal ri ki nimaqil sacerdotes che ki chapik b'i konojel ri käkikoj ri b'i' la aretaq käka'n orar, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Xub'ij k'u ri Qajaw Jesús che: ¡Jat b'a'! Are rumal chi we achi ri' cha'tal wumal rech kutzijoj ri Utzalaj Tzij chwij In chke ri winaq re ri nik'iaj taq tinimit chik, chke ri ketaqan pa ki wi', xuquje' chke ri winaq aj Israel. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Kink'ut k'u na chuwäch jas ri nimalaj k'äx ri rajwaxik kuriq na ri are' rumal wech in, —xcha ri Qajaw Jesús che ri tat Ananías. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Xe' k'u ri tat Ananías. Xok b'i pa ri ja ri k'o wi ri tat Saulo, xuya ru q'ab' puwi', xub'ij k'u che: Wachalal Saulo, ri Qajaw Jesús, ri xuk'ut rib' chuwäch la pa ri b'e ri petinaq wi la, xinutaq loq uk' la rech käkowin la käka'y chi na la, xuquje' rech käqaj ri Loq'alaj Espíritu puwi' la, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Chanim k'ut xetzaq loq je' ta ne jujun solot pu waq'äch ri tat Saulo. Je ri' xkowinik xka'y jumul chik ri are'. Xwalij k'ut, xb'an u qasna'. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Te k'u ri' xwi'k, xpe chi jumul ru chuq'ab'. Xk'oji k'u na kieb' oxib' q'ij kuk' ri kojonelab' ri e k'o pa ri tinimit Damasco. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Te k'u ri' ri tat Saulo xuchaplej u tzijoxik ru Loq' Pixab' ri Dios pa taq ri rachoch Dios, kub'ij k'u chke ri winaq chi ri Jesús are ri u K'ojol ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Konojel k'u ri xkita ru tzij sib'alaj xkikajmaj wa', xkib'ij: ¿A mat are wa' ri achi ri kub'an k'äx chke ri winaq pa Jerusalén ri käkikoj ru b'i' ri Jesús aretaq käka'n orar? ¿A mat are ulinaq waral che ki chapik b'ik, che ki jachik pa ki q'ab' ri ki nimaqil sacerdotes? —xecha ri'. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Are k'u ri tat Saulo ruk' nimalaj chuq'ab' xch'awik, xuq'alajisaj k'ut chi ri Jesús qas tzij Are ri Cristo, ri To'l Qe, je ri' chi ri winaq aj Israel ri e k'o pa ri tinimit Damasco man xkiriq tä chik jas käka'no. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ok'owinaq chi k'u k'ialaj taq q'ij, ri winaq aj Israel xkichomaj jas käka'n chukämisaxik ri tat Saulo. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ri are' k'ut xretamaj jas ri ki chomam u b'anik chukämisaxik. Paq'ij chi chaq'ab' ri e are' xkiyuxlej ri tat Saulo chuchi' taq ri porta re ri tinimit chukämisaxik. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Are k'u ri kojonelab' xkik'am ri tat Saulo, xkiya pa jun nim chikäch. Chaq'ab' xkiqasaj b'i chrij ri tapya ri k'o chrij ri tinimit. Je' ri xka'n chuto'ik ri tat Saulo. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Aretaq xopan ri tat Saulo pa ri tinimit Jerusalén, xraj xk'oji kuk' ri kojonelab'. Konojel k'ut xkixej kib' che ri are' rumal chi man xkikoj taj chi are jun qas kojonel. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Xpe k'u ri tat Bernabé, xuk'am b'i ri tat Saulo chkiwäch ri apóstoles rech käketamaj u wäch. Xutzijoj k'u chke jas xub'an ri tat Saulo, xril ri Qajaw Jesús pa ri b'e, xuquje' chi xch'aw ri Qajaw Jesús ruk'. Xub'ij k'u chke chi ri tat Saulo man xuxej tä rib' che ki tzijob'exik ri winaq chrij ri Cristo pa ri tinimit Damasco. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Je ri' ri tat Saulo xkanaj kan kuk' ri kojonelab' pa ri tinimit Jerusalén, xerachi'laj jawije' ri xeb'e' wi. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Man xuxej tä rib' che ki tzijob'exik ri winaq chrij ri Cristo. Xuchap tzij kuk' ri winaq aj Israel ri kech'aw pa griego. Are k'u ri e are' xa xkitzukuj jas käka'n na chukämisaxik. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Aretaq xketamaj wa' ri qachalal, xkik'am b'i ri tat Saulo pa ri tinimit Cesarea, xkitaq k'u b'i pa ri tinimit Tarso. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Xaq je ri' konojel ri qachalal kojonelab' ri e k'o pa Judea, pa Galilea, xuquje' pa Samaria, xuxlan ri kanima'. Tajin kekowirik, k'o k'u na ki chuq'ab'. Xkixej kib' chuwäch ri Dios, xeniman k'u che. Are ri Loq'alaj Espíritu ri tajin käb'anowik chi sib'alaj kek'iarik, chi käk'oji na ki chuq'ab'. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pa jun q'ij ri tat Pedro tajin keusolij ri qachalal, xuquje' xe' che kilik ri qachalal kojonelab' ri e k'o pa ri tinimit Lida. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Chila' xuriq wi jun achi, Eneas u b'i'. We achi ri' wajxaqib' junab' chik k'o pa ch'at, käminaq k'u ru cuerpo. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ri tat Pedro xub'ij che: Tat Eneas, ri Jesucristo katkunanik. Chatwalijoq, chab'ana kan u b'anik ra ch'at, —xcha che. Chanim k'ut xwalijik. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Aretaq k'ut ri winaq ri e k'o pa ri tinimit Lida, xuquje' ri e k'o pa ri taq'aj re Sarón ri k'o wi ri Lida, xkilo chi ri tat Eneas xwalijik, xkiya kan ri ojer ki k'aslemal. Rumal ri xb'antajik xekojon che ri Qajaw Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Pa taq ri q'ij ri' k'o jun chichu' kojonel pa ri tinimit Jope, Tabita u b'i', ri käb'ix Dorcas che pa ri ch'ab'al griego. We chichu' ri' amaq'el xub'an ronojel u wäch utzil chke ri winaq, xeuto' k'u ri k'o ki rajwaxik. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Pa taq ri q'ij ri' xyawaj ri nan Dorcas, xkämik. Aretaq xch'ajtaj ru cuerpo, xyi' pa ru kawiq ja. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Naqaj k'ut k'o wi ri tinimit Jope che ri tinimit Lida ri k'o wi ri tat Pedro. Ri kojonelab' xkito chi ri tat Pedro k'o pa Lida, xekitaq b'i kieb' achijab' chub'ixik che: B'ana b'a' la jun toq'ob', sa'j la quk' chanim, —xecha b'ik. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ri tat Pedro xub'an k'u u b'anik rib', xe' kuk' ri achijab'. Aretaq xeopanik, xkik'am b'i ri tat Pedro pa ri kawiq ja ri k'o wi ri käminaq. Xepe k'u konojel ri malka'nib' ixoqib', xemuli chrij ri tat Pedro, tajin keb'oq'ik, xkik'ut taq ri kamixa' xuquje' nik'iaj atz'iaq chik ri xub'an ri nan Dorcas aretaq k'aslik. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ri tat Pedro xub'ij chke chi keb'el na b'i konojel, te k'u ri' xxuki'k, xub'an orar. Xka'y k'u che ri chichu' ri käminaq, xub'ij: Nan Dorcas, walij b'a' la, —xcha che. Ri nan Dorcas xka'yik, aretaq k'ut xril ri tat Pedro, xwalijik, xku'b'ik. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ri tat Pedro xuchap che ru q'ab', xuyako. Xeusik'ij ri malka'nib' ixoqib', xuquje' konojel ri nik'iaj kojonelab' chik. K'asal chik xuya chkiwäch rech käkilo. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Xel k'u u tzijol wa' pa ronojel ri tinimit Jope. E k'ia k'ut xekojon che ri Qajaw Jesús. ");
INSERT INTO qucNNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Naj k'ut xk'oji na ri tat Pedro pa ri tinimit Jope cho rachoch jun tata' josq'il tz'um, Simón u b'i'. ");
INSERT INTO qucNNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","K'o k'u jun tata', Cornelio u b'i', pa ri tinimit Cesarea. Ri tata' ri' are jun ki nimal soldados ri k'o cien achijab' pu q'ab'. Ri soldados ri' käb'ix “Aj Italiano” chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ri are' xq'ijilan che ri Dios, junam kuk' konojel ri e k'o pa rachoch. Xniman che ri Dios, xuxej rib' chuwäch. K'ia ri u b'anom che ki to'ik ri meb'a'ib' winaq aj Israel, amaq'el k'ut xub'an orar chuwäch ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Pa jun q'ij, kraj pa ri rox hora re ri b'enaq q'ij, k'o ri xuk'ut ri Dios chuwäch ri tat Cornelio. Are jun ángel ri taqom loq rumal ri qa Tat. Qas xrilo xok b'i ri ángel ruk', te k'u ri' ri ángel xub'ij che: ¡Tat Cornelio! —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ri are' sib'alaj xuxej rib', ko xka'y che ri ángel, xuta' che: ¿Jas kaj la, tat? —xcha che. Are k'u ri ángel xub'ij che: Ri Dios retam jas a b'anom, chi sib'alaj kab'an orar chuwäch, xuquje' rilom ri utzil ri kab'an chke ri winaq. Man sachinaq tä wa' che ri Are'. ");
INSERT INTO qucNNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Cheataqa b'i jujun achijab' pa ri tinimit Jope chusik'ixik loq jun tata', Simón u b'i', ri xuquje' käb'ix Pedro che, —kächa'. ");
INSERT INTO qucNNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ri are' k'o pa rachoch jun tata' ri xuquje' käkoj Simón che ru b'i'. We tata' ri' are josq'il tz'um, ri k'o rachoch chuchi' ri mar, —kächa'. Ri tat Pedro kub'ij k'u na chawe jas ri rajwaxik kab'ano, —xcha ri ángel che ri tat Cornelio. ");
INSERT INTO qucNNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Aretaq b'enaq chi ri ángel ri xtzijon ruk' ri tat Cornelio, ri are' xeusik'ij kieb' chke ri patänil taq re, xuquje' jun soldado ri sib'alaj ku'l u k'ux ri tat Cornelio chrij rumal qas tzij käkojon ri soldado ri' che ri Dios. ");
INSERT INTO qucNNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Xutzijoj chke ronojel ri xrilo, te k'u ri' xeutaq b'i pa ri tinimit Jope. ");
INSERT INTO qucNNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Chukab' q'ij e b'enaq ri achijab' pa ri b'e, naqaj chik e k'o wi che ri tinimit Jope. Ri tat Pedro k'ut xpaqi puwi' ri ja ri k'o wi chub'anik orar, kraj are ri u kab'lajuj hora chik. ");
INSERT INTO qucNNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Sib'alaj känum chi ri tat Pedro, kraj käwi'k, mäja' k'u kutzir ru wa re paq'ij. Ri Dios xub'an che ri tat Pedro chi xsachi'k, k'o k'u ri xuk'ut ri Dios chuwäch. ");
INSERT INTO qucNNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Xril ri kaj tajin käjaqjob'ik, te k'u ri' xrilo chi tajin käqaj loq cho ruwächulew jun lik'ilik manta ri sib'alaj nim, ri ximital chke ri kiejeb' u tza'm. ");
INSERT INTO qucNNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","E k'o k'u ronojel u wäch awaj chupam ri manta. E k'o chikop ri kajkaj kaqan, xuquje' e k'o chikop ri käkijuruj kib', xuquje' nik'iaj chikop ri kerapapik. ");
INSERT INTO qucNNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Xuta k'u Jun ri xch'aw loq chikaj ri xub'ij che: Chatwalijoq, Pedro, chakämisaj apachike chikop, chatwoq, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Xch'aw k'u ri tat Pedro, xub'ij che: ¡No, Wajaw! Man k'o tä k'u jumul nu tijom ri man ya'tal tä u tijik, ri äwas chwe kintijo, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Xch'aw jumul chik ri Jun ri xch'aw nab'e, xub'ij che ri tat Pedro: Ri kub'ij ri Dios chi ya'tal u tijik, mab'ij at che chi äwas u tijik wa', —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Oxmul k'ut xb'antaj wa'. Te k'u ri' ri manta xpaqi chi jumul chikaj. ");
INSERT INTO qucNNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ri tat Pedro tajin kuchomaj jas kel kub'ij wa' ri xrilo aretaq ri achijab' ri e taqom b'i rumal ri tat Cornelio xeopan chi' ri uchib'e chuta'ik we chila' ri rachoch ri tat Simón. ");
INSERT INTO qucNNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ko xech'awik chuta'ik we chila' jeqel wi jun tata', Simón u b'i', ri xuquje' käb'ix Pedro che. ");
INSERT INTO qucNNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Tajin kächoman k'u na ri tat Pedro chrij ri xuk'ut ri Dios chuwäch aretaq ri Loq'alaj Espíritu xub'ij che: Chawilampe', e k'o oxib' achijab' tajin katkitzukuj. ");
INSERT INTO qucNNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Chatwalij b'a', chatqaj k'u na b'ik. Jat kuk', mub'an k'u kieb' a k'ux. Are ri in xinyo'w taqanik chke chi kepe che a ch'ab'exik, —xcha ri Loq'alaj Espíritu che ri tat Pedro. ");
INSERT INTO qucNNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Xqaj k'u loq ri tat Pedro, xopan chila' jawije' e k'o wi ri achijab' ri e taqom b'i rumal ri tat Cornelio, xub'ij chke: In ri' ri kintzukuj alaq. ¿Jas tajkil alaq wuk'? —xcha chke. ");
INSERT INTO qucNNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ri e are' xech'awik, xkib'ij: Uj taqom loq rumal ri tat Cornelio, ri ki nimal jun ciento soldados. Are jun tata' ri jikom ranima', ri käniman che ri Dios. Ri are' sib'alaj nim kil wi, xuquje' sib'alaj loq' chkiwäch konojel ri winaq aj Israel. Xb'ix k'u che rumal jun ángel ri xtaq loq rumal ri Dios, chi kutaq sik'ixik la rech ke' la cho rachoch, kuta k'u na ri tzij ri käb'ij la, —xecha che. ");
INSERT INTO qucNNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Xeoksax k'u pa ja rumal ri tat Pedro, xekanaj chila' che ri jun aq'ab'. Chukab' q'ij xewalijik, xe' k'u ri tat Pedro kuk' ri tata'ib'. E rachi'l jujun qachalal aj Jope. ");
INSERT INTO qucNNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Chukab' q'ij xeopan pa ri tinimit Cesarea. Eyeninaq k'u ri tat Cornelio chke junam kuk' jujun chke ri rachalaxik, xuquje' ri winaq ri sib'alaj e utz ruk' ri are'. ");
INSERT INTO qucNNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Aretaq xopan ri tat Pedro, xel loq ri tat Cornelio chuk'ulaxik, xxuki k'u chuwäch chuq'ijilaxik. ");
INSERT INTO qucNNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Xpe k'u ri tat Pedro, xuyako, xub'ij che: ¡Walij la, tat Cornelio! Ri in, xaq in achi jas ri lal, —xcha che. ");
INSERT INTO qucNNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Tajin ketzijonik, xeb'ok apan chi' ja. Xok k'u b'i ri tat Pedro, te' xrilo k'ia winaq ki mulim kib'. ");
INSERT INTO qucNNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Xub'ij ri tat Pedro chke ri winaq: Ri alaq etam alaq chi man ya'tal tä che jun aj Israel kärachi'laj o kok pa rachoch jun winaq ri man aj Israel taj. Ri Dios k'ut xuk'ut chnuwäch chi man kuya' taj kinb'ij chi are äwas ri kink'oji ruk' jun winaq ri man aj Israel o kinb'ij